/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ie.util.RelationTriple;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.AnnotationSerializer;
import edu.stanford.nlp.pipeline.CoreDocument;
import edu.stanford.nlp.pipeline.CoreEntityMention;
import edu.stanford.nlp.pipeline.CoreQuote;
import edu.stanford.nlp.pipeline.CoreSentence;
import edu.stanford.nlp.pipeline.ProtobufAnnotationSerializer;
import edu.stanford.nlp.pipeline.ProtobufAnnotationSerializerSlowITest;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.util.Pair;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import junit.framework.TestCase;

public class CoreWrapperITest
extends TestCase {
    public void testPipeline() throws Exception {
        Properties props = new Properties();
        props.setProperty("annotators", "tokenize,ssplit,pos,lemma,ner,depparse,coref,kbp,quote");
        StanfordCoreNLP pipeline = new StanfordCoreNLP(props);
        CoreDocument exampleDocument = new CoreDocument("Barack Obama was born in Hawaii on August 4, 1961. He was elected president in 2008, defeating Arizona senator John McCain. Obama said, \"My fellow citizens:  I stand here today humbled by the task before us, grateful for the trust you've bestowed, mindful of the sacrifices borne by our ancestors\" to begin his inaugural address.");
        pipeline.annotate(exampleDocument);
        CoreWrapperITest.assertEquals((int)3, (int)exampleDocument.sentences().size());
        CoreSentence firstSentence = exampleDocument.sentences().get(0);
        CoreSentence secondSentence = exampleDocument.sentences().get(1);
        int sentenceCount = 0;
        for (CoreSentence coreSentence : exampleDocument.sentences()) {
            CoreWrapperITest.assertEquals((Object)coreSentence.coreMap(), ((List)exampleDocument.annotation().get(CoreAnnotations.SentencesAnnotation.class)).get(sentenceCount));
            ++sentenceCount;
        }
        CoreWrapperITest.assertEquals((String)"He was elected president in 2008, defeating Arizona senator John McCain.", (String)secondSentence.text());
        CoreWrapperITest.assertSame((Object)secondSentence.document(), (Object)exampleDocument);
        Pair<Integer, Integer> sentenceTwoOffsets = new Pair<Integer, Integer>(51, 123);
        CoreWrapperITest.assertEquals(sentenceTwoOffsets, secondSentence.charOffsets());
        CoreWrapperITest.assertEquals((int)6, (int)secondSentence.entityMentions().size());
        CoreEntityMention arizonaMentionFromSentence = secondSentence.entityMentions().get(2);
        CoreEntityMention arizonaMentionFromDocument = exampleDocument.entityMentions().get(5);
        CoreWrapperITest.assertEquals((String)"Arizona", (String)arizonaMentionFromSentence.text());
        CoreWrapperITest.assertSame((Object)arizonaMentionFromSentence, (Object)arizonaMentionFromDocument);
        List<RelationTriple> kbpRelationsFromSentenceOne = firstSentence.relations();
        String sentenceOneRelationOne = '(' + kbpRelationsFromSentenceOne.get(0).subjectGloss() + ',' + kbpRelationsFromSentenceOne.get(0).relationGloss() + ',' + kbpRelationsFromSentenceOne.get(0).objectGloss() + ')';
        String goldSentenceOneRelationOne = "(Barack Obama,per:stateorprovince_of_birth,Hawaii)";
        CoreWrapperITest.assertEquals((String)goldSentenceOneRelationOne, (String)sentenceOneRelationOne);
        CoreEntityMention firstEntityMention = exampleDocument.entityMentions().get(0);
        CoreEntityMention fifthEntityMention = exampleDocument.entityMentions().get(4);
        CoreWrapperITest.assertEquals((int)12, (int)exampleDocument.entityMentions().size());
        CoreWrapperITest.assertEquals((String)"Barack Obama", (String)firstEntityMention.text());
        CoreWrapperITest.assertEquals((String)"Barack Obama was born in Hawaii on August 4, 1961.", (String)firstEntityMention.sentence().text());
        Pair<Integer, Integer> goldFirstEntityMentionCharOffsets = new Pair<Integer, Integer>(0, 12);
        CoreWrapperITest.assertEquals(goldFirstEntityMentionCharOffsets, firstEntityMention.charOffsets());
        CoreWrapperITest.assertEquals((String)"PERSON", (String)firstEntityMention.entityType());
        CoreWrapperITest.assertEquals((String)"2008", (String)fifthEntityMention.text());
        CoreWrapperITest.assertEquals((String)"He was elected president in 2008, defeating Arizona senator John McCain.", (String)fifthEntityMention.sentence().text());
        Pair<Integer, Integer> goldFifthEntityMentionCharOffsets = new Pair<Integer, Integer>(79, 83);
        CoreWrapperITest.assertEquals(goldFifthEntityMentionCharOffsets, fifthEntityMention.charOffsets());
        CoreWrapperITest.assertEquals((String)"DATE", (String)fifthEntityMention.entityType());
        CoreQuote firstQuote = exampleDocument.quotes().get(0);
        CoreWrapperITest.assertEquals((String)"\"My fellow citizens:  I stand here today humbled by the task before us, grateful for the trust you've bestowed, mindful of the sacrifices borne by our ancestors\"", (String)firstQuote.text());
        CoreWrapperITest.assertEquals((String)"Obama", (String)firstQuote.speaker().get());
        CoreWrapperITest.assertEquals((String)"Barack Obama", (String)firstQuote.canonicalSpeaker().get());
        ProtobufAnnotationSerializer serializer = new ProtobufAnnotationSerializer();
        ByteArrayOutputStream ks = new ByteArrayOutputStream();
        serializer.writeCoreDocument(exampleDocument, ks).close();
        ByteArrayInputStream kis = new ByteArrayInputStream(ks.toByteArray());
        Pair<Annotation, InputStream> pair = ((AnnotationSerializer)serializer).read(kis);
        ((InputStream)pair.second).close();
        Annotation readAnnotation = (Annotation)pair.first;
        ((InputStream)kis).close();
        CoreDocument readCoreDocument = new CoreDocument(readAnnotation);
        ProtobufAnnotationSerializerSlowITest.sameAsRead(exampleDocument.annotation(), readCoreDocument.annotation());
    }
}

