/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.ChunkAnnotationUtils;
import edu.stanford.nlp.pipeline.TokenizerAnnotator;
import edu.stanford.nlp.pipeline.WordsToSentencesAnnotator;
import java.util.List;
import junit.framework.TestCase;

public class ChunkAnnotationUtilsTest
extends TestCase {
    public void testMergeChunks() throws Exception {
        String text = "I have created sentence1.  And then sentence2.  Now sentence3. Finally sentence4.";
        TokenizerAnnotator tokenizer = new TokenizerAnnotator("en");
        WordsToSentencesAnnotator ssplit = new WordsToSentencesAnnotator();
        Annotation annotation = new Annotation(text);
        tokenizer.annotate(annotation);
        ssplit.annotate(annotation);
        List sentences = (List)annotation.get(CoreAnnotations.SentencesAnnotation.class);
        ChunkAnnotationUtilsTest.assertEquals((String)"4 sentence expected", (int)4, (int)sentences.size());
        ChunkAnnotationUtils.mergeChunks(sentences, text, 1, 4);
        ChunkAnnotationUtilsTest.assertEquals((String)"2 sentence expected", (int)2, (int)sentences.size());
    }
}

