/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.naturalli.NaturalLogicAnnotator;
import edu.stanford.nlp.naturalli.OpenIE;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.pipeline.CharniakParserAnnotator;
import edu.stanford.nlp.pipeline.CleanXmlAnnotator;
import edu.stanford.nlp.pipeline.ColumnDataClassifierAnnotator;
import edu.stanford.nlp.pipeline.CorefAnnotator;
import edu.stanford.nlp.pipeline.CorefMentionAnnotator;
import edu.stanford.nlp.pipeline.DependencyParseAnnotator;
import edu.stanford.nlp.pipeline.DeterministicCorefAnnotator;
import edu.stanford.nlp.pipeline.EntityMentionsAnnotator;
import edu.stanford.nlp.pipeline.GenderAnnotator;
import edu.stanford.nlp.pipeline.KBPAnnotator;
import edu.stanford.nlp.pipeline.MorphaAnnotator;
import edu.stanford.nlp.pipeline.NERCombinerAnnotator;
import edu.stanford.nlp.pipeline.POSTaggerAnnotator;
import edu.stanford.nlp.pipeline.ParserAnnotator;
import edu.stanford.nlp.pipeline.QuoteAnnotator;
import edu.stanford.nlp.pipeline.QuoteAttributionAnnotator;
import edu.stanford.nlp.pipeline.RelationExtractorAnnotator;
import edu.stanford.nlp.pipeline.SentimentAnnotator;
import edu.stanford.nlp.pipeline.TokenizerAnnotator;
import edu.stanford.nlp.pipeline.TokensRegexAnnotator;
import edu.stanford.nlp.pipeline.TokensRegexNERAnnotator;
import edu.stanford.nlp.pipeline.TrueCaseAnnotator;
import edu.stanford.nlp.pipeline.UDFeatureAnnotator;
import edu.stanford.nlp.pipeline.WikidictAnnotator;
import edu.stanford.nlp.pipeline.WordsToSentencesAnnotator;
import edu.stanford.nlp.util.MetaClass;
import edu.stanford.nlp.util.PropertiesUtils;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;

public class AnnotatorImplementations {
    private static Redwood.RedwoodChannels log = Redwood.channels(AnnotatorImplementations.class);

    public Annotator tokenizer(Properties properties) {
        return new TokenizerAnnotator(properties);
    }

    public CleanXmlAnnotator cleanXML(Properties properties) {
        return new CleanXmlAnnotator(properties);
    }

    public Annotator wordToSentences(Properties properties) {
        return new WordsToSentencesAnnotator(properties);
    }

    public Annotator posTagger(Properties properties) {
        String annotatorName = "pos";
        return new POSTaggerAnnotator(annotatorName, properties);
    }

    public Annotator morpha(Properties properties, boolean verbose) {
        return new MorphaAnnotator(verbose);
    }

    public Annotator ner(Properties properties) {
        try {
            return new NERCombinerAnnotator(properties);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    public Annotator tokensregex(Properties properties, String name) {
        return new TokensRegexAnnotator(name, properties);
    }

    public Annotator tokensRegexNER(Properties properties, String name) {
        return new TokensRegexNERAnnotator(name, properties);
    }

    public Annotator entityMentions(Properties properties, String name) {
        return new EntityMentionsAnnotator(name, properties);
    }

    public Annotator gender(Properties properties, String name) {
        return new GenderAnnotator(name, properties);
    }

    public Annotator parse(Properties properties) {
        String parserType = properties.getProperty("parse.type", "stanford");
        String maxLenStr = properties.getProperty("parse.maxlen");
        if (parserType.equalsIgnoreCase("stanford")) {
            return new ParserAnnotator("parse", properties);
        }
        if (parserType.equalsIgnoreCase("charniak")) {
            String model = properties.getProperty("parse.model");
            String parserExecutable = properties.getProperty("parse.executable");
            if (model == null || parserExecutable == null) {
                throw new RuntimeException("Both parse.model and parse.executable properties must be specified if parse.type=charniak");
            }
            int maxLen = 399;
            if (maxLenStr != null) {
                maxLen = Integer.parseInt(maxLenStr);
            }
            return new CharniakParserAnnotator(model, parserExecutable, false, maxLen);
        }
        throw new RuntimeException("Unknown parser type: " + parserType + " (currently supported: stanford and charniak)");
    }

    public Annotator custom(Properties properties, String property) {
        String customName = property;
        String customClassName = properties.getProperty("customAnnotatorClass." + property);
        if (property.startsWith("customAnnotatorClass.")) {
            customName = property.substring("customAnnotatorClass.".length());
            customClassName = properties.getProperty(property);
        }
        try {
            return (Annotator)new MetaClass(customClassName).createInstance(customName, properties);
        }
        catch (MetaClass.ConstructorNotFoundException e) {
            try {
                return (Annotator)new MetaClass(customClassName).createInstance(customName);
            }
            catch (MetaClass.ConstructorNotFoundException e2) {
                try {
                    return (Annotator)new MetaClass(customClassName).createInstance(properties);
                }
                catch (MetaClass.ConstructorNotFoundException e3) {
                    return (Annotator)new MetaClass(customClassName).createInstance(new Object[0]);
                }
            }
        }
    }

    public Annotator trueCase(Properties properties) {
        return new TrueCaseAnnotator(properties);
    }

    public Annotator corefMention(Properties properties) {
        Properties corefProperties = PropertiesUtils.extractPrefixedProperties(properties, "coref.", true);
        Properties mentionProperties = PropertiesUtils.extractPrefixedProperties(properties, "coref.mention.", true);
        Properties allPropsForCoref = new Properties();
        allPropsForCoref.putAll((Map<?, ?>)corefProperties);
        allPropsForCoref.putAll((Map<?, ?>)mentionProperties);
        return new CorefMentionAnnotator(allPropsForCoref);
    }

    public Annotator coref(Properties properties) {
        Properties corefProperties = PropertiesUtils.extractPrefixedProperties(properties, "coref.", true);
        Properties mentionProperties = PropertiesUtils.extractPrefixedProperties(properties, "coref.mention.", true);
        Properties allPropsForCoref = new Properties();
        allPropsForCoref.putAll((Map<?, ?>)corefProperties);
        allPropsForCoref.putAll((Map<?, ?>)mentionProperties);
        return new CorefAnnotator(allPropsForCoref);
    }

    public Annotator dcoref(Properties properties) {
        return new DeterministicCorefAnnotator(properties);
    }

    public Annotator relations(Properties properties) {
        return new RelationExtractorAnnotator(properties);
    }

    public Annotator sentiment(Properties properties, String name) {
        return new SentimentAnnotator(name, properties);
    }

    public Annotator columnData(Properties properties) {
        if (properties.containsKey("classify.loadClassifier")) {
            properties.setProperty("loadClassifier", properties.getProperty("classify.loadClassifier"));
        }
        if (!properties.containsKey("loadClassifier")) {
            throw new RuntimeException("Must load a classifier when creating a column data classifier annotator");
        }
        return new ColumnDataClassifierAnnotator(properties);
    }

    public Annotator dependencies(Properties properties) {
        Properties relevantProperties = PropertiesUtils.extractPrefixedProperties(properties, "depparse.");
        return new DependencyParseAnnotator(relevantProperties);
    }

    public Annotator natlog(Properties properties) {
        Properties relevantProperties = PropertiesUtils.extractPrefixedProperties(properties, "natlog.");
        return new NaturalLogicAnnotator(relevantProperties);
    }

    public Annotator openie(Properties properties) {
        Properties relevantProperties = PropertiesUtils.extractPrefixedProperties(properties, "openie.");
        return new OpenIE(relevantProperties);
    }

    public Annotator quote(Properties properties) {
        Properties relevantProperties = PropertiesUtils.extractPrefixedProperties(properties, "quote.");
        return new QuoteAnnotator(relevantProperties);
    }

    public Annotator quoteattribution(Properties properties) {
        Properties relevantProperties = PropertiesUtils.extractPrefixedProperties(properties, "quote.attribution.");
        return new QuoteAttributionAnnotator(relevantProperties);
    }

    public Annotator udfeats(Properties properties) {
        return new UDFeatureAnnotator();
    }

    public Annotator kbp(Properties properties) {
        return new KBPAnnotator("kbp", properties);
    }

    public Annotator link(Properties properties) {
        return new WikidictAnnotator("entitylink", properties);
    }
}

