/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.patterns.surface;

import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.tokensregex.MultiPatternMatcher;
import edu.stanford.nlp.ling.tokensregex.SequenceMatchResult;
import edu.stanford.nlp.ling.tokensregex.SequenceMatcher;
import edu.stanford.nlp.ling.tokensregex.TokenSequencePattern;
import edu.stanford.nlp.patterns.ConstantsAndVariables;
import edu.stanford.nlp.patterns.DataInstance;
import edu.stanford.nlp.patterns.Pattern;
import edu.stanford.nlp.patterns.PatternFactory;
import edu.stanford.nlp.patterns.PatternsAnnotations;
import edu.stanford.nlp.stats.TwoDimensionalCounter;
import edu.stanford.nlp.util.CollectionValuedMap;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.Triple;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;

public class ApplyPatternsMulti<E extends Pattern>
implements Callable<Pair<TwoDimensionalCounter<Pair<String, String>, E>, CollectionValuedMap<E, Triple<String, Integer, Integer>>>> {
    private final String label;
    private final Map<TokenSequencePattern, E> patterns;
    private final List<String> sentids;
    private final boolean removeStopWordsFromSelectedPhrases;
    private final boolean removePhrasesWithStopWords;
    private final ConstantsAndVariables constVars;
    private final MultiPatternMatcher<CoreMap> multiPatternMatcher;
    private final Map<String, DataInstance> sents;

    public ApplyPatternsMulti(Map<String, DataInstance> sents, List<String> sentids, Map<TokenSequencePattern, E> patterns, String label, boolean removeStopWordsFromSelectedPhrases, boolean removePhrasesWithStopWords, ConstantsAndVariables cv) {
        this.sents = sents;
        this.patterns = patterns;
        this.multiPatternMatcher = TokenSequencePattern.getMultiPatternMatcher(patterns.keySet());
        this.sentids = sentids;
        this.label = label;
        this.removeStopWordsFromSelectedPhrases = removeStopWordsFromSelectedPhrases;
        this.removePhrasesWithStopWords = removePhrasesWithStopWords;
        this.constVars = cv;
    }

    @Override
    public Pair<TwoDimensionalCounter<Pair<String, String>, E>, CollectionValuedMap<E, Triple<String, Integer, Integer>>> call() throws Exception {
        CollectionValuedMap<Pattern, Triple<String, Integer, Integer>> matchedTokensByPat = new CollectionValuedMap<Pattern, Triple<String, Integer, Integer>>();
        TwoDimensionalCounter<Pair<String, String>, Pattern> allFreq = new TwoDimensionalCounter<Pair<String, String>, Pattern>();
        for (String sentid : this.sentids) {
            List<CoreLabel> sent = this.sents.get(sentid).getTokens();
            List<SequenceMatchResult<CoreLabel>> matched = this.multiPatternMatcher.find(sent, SequenceMatcher.FindType.FIND_ALL);
            for (SequenceMatchResult sequenceMatchResult : matched) {
                int i;
                int s = sequenceMatchResult.start("$term");
                int e = sequenceMatchResult.end("$term");
                Pattern matchedPat = (Pattern)this.patterns.get(sequenceMatchResult.pattern());
                matchedTokensByPat.add(matchedPat, new Triple<String, Integer, Integer>(sentid, s, e));
                String phrase = "";
                String phraseLemma = "";
                boolean useWordNotLabeled = false;
                boolean doNotUse = false;
                if (this.constVars.clubNeighboringLabeledWords) {
                    for (int i2 = s - 1; i2 >= 0; --i2) {
                        if (((String)sent.get(i2).get(this.constVars.getAnswerClass().get(this.label))).equals(this.label)) continue;
                        s = i2 + 1;
                        break;
                    }
                    for (int i2 = e; i2 < sent.size(); ++i2) {
                        if (((String)sent.get(i2).get(this.constVars.getAnswerClass().get(this.label))).equals(this.label)) continue;
                        e = i2;
                        break;
                    }
                }
                boolean[] addedindices = new boolean[e - s];
                for (i = s; i < e; ++i) {
                    CoreLabel l = sent.get(i);
                    l.set(PatternsAnnotations.MatchedPattern.class, true);
                    if (!l.containsKey(PatternsAnnotations.MatchedPatterns.class)) {
                        l.set(PatternsAnnotations.MatchedPatterns.class, new HashSet());
                    }
                    ((Set)l.get(PatternsAnnotations.MatchedPatterns.class)).add(matchedPat);
                    for (Map.Entry<Class, Object> ig : this.constVars.getIgnoreWordswithClassesDuringSelection().get(this.label).entrySet()) {
                        if (!l.containsKey(ig.getKey()) || !l.get(ig.getKey()).equals(ig.getValue())) continue;
                        doNotUse = true;
                    }
                    boolean containsStop = ApplyPatternsMulti.containsStopWord(l, this.constVars.getCommonEngWords(), PatternFactory.ignoreWordRegex);
                    if (this.removePhrasesWithStopWords && containsStop) {
                        doNotUse = true;
                        continue;
                    }
                    if (containsStop && this.removeStopWordsFromSelectedPhrases) continue;
                    if (this.label == null || l.get(this.constVars.getAnswerClass().get(this.label)) == null || !((String)l.get(this.constVars.getAnswerClass().get(this.label))).equals(this.label.toString())) {
                        useWordNotLabeled = true;
                    }
                    phrase = phrase + " " + l.word();
                    phraseLemma = phraseLemma + " " + l.lemma();
                    addedindices[i - s] = true;
                }
                for (i = 0; i < addedindices.length; ++i) {
                    if (i <= 0 || i >= addedindices.length - 1 || !addedindices[i - 1] || addedindices[i] || !addedindices[i + 1]) continue;
                    doNotUse = true;
                    break;
                }
                if (doNotUse || !useWordNotLabeled) continue;
                phrase = phrase.trim();
                phraseLemma = phraseLemma.trim();
                allFreq.incrementCount(new Pair<String, String>(phrase, phraseLemma), matchedPat, 1.0);
            }
        }
        return new Pair<TwoDimensionalCounter<Pair<String, String>, E>, CollectionValuedMap<E, Triple<String, Integer, Integer>>>(allFreq, matchedTokensByPat);
    }

    private static boolean containsStopWord(CoreLabel l, Set<String> commonEngWords, java.util.regex.Pattern ignoreWordRegex) {
        return commonEngWords.contains(l.lemma()) || commonEngWords.contains(l.word()) || ignoreWordRegex != null && ignoreWordRegex.matcher(l.lemma()).matches();
    }
}

