/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.io.TeeStream;
import edu.stanford.nlp.parser.lexparser.LexicalizedParser;
import edu.stanford.nlp.util.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Formatter;
import junit.framework.TestCase;

public class BuildLexicalizedParserITest
extends TestCase {
    public static final String[] englishCommandLines = new String[]{"-evals factDA,tsv -goodPCFG -saveToSerializedFile %s -saveToTextFile %s -maxLength 40 -train %s -testTreebank %s", "-evals factDA,tsv -goodPCFG -noTagSplit -saveToSerializedFile %s -saveToTextFile %s -compactGrammar 0 -maxLength 40 -train %s -testTreebank %s", "-evals factDA,tsv -ijcai03 -v -printStates -compactGrammar 0 -correctTags -saveToSerializedFile %s -saveToTextFile %s -maxLength 40 -train %s -testTreebank %s", "-evals factDA,tsv -ijcai03 -v -printStates -compactGrammar 0 -saveToSerializedFile %s -saveToTextFile %s -maxLength 40 -train %s -testTreebank %s"};
    public static final String[] englishTwoTreebanks = new String[]{"-evals factDA,tsv -ijcai03 -saveToSerializedFile %s -saveToTextFile %s -maxLength 40 -train %s -train2 %s 0-9 0.5 -testTreebank %s", "-evals factDA,tsv -goodPCFG -saveToSerializedFile %s -saveToTextFile %s -maxLength 40 -train %s -train2 %s 0-9 0.5 -testTreebank %s"};
    public static final String[] chineseCommandLines = new String[]{"-evals factDA,tsv -tLPP edu.stanford.nlp.parser.lexparser.ChineseTreebankParserParams -chinesePCFG -encoding utf-8 -saveToSerializedFile %s -saveToTextFile %s -maxLength 40 -train %s -test %s", "-evals factDA,tsv -tLPP edu.stanford.nlp.parser.lexparser.ChineseTreebankParserParams -acl03chinese -encoding utf-8 -scTags -saveToSerializedFile %s -saveToTextFile %s -maxLength 40 -train %s -test %s", "-evals factDA,tsv -tLPP edu.stanford.nlp.parser.lexparser.ChineseTreebankParserParams -encoding utf-8 -chineseFactored -saveToSerializedFile %s -saveToTextFile %s -maxLength 40 -train %s -test %s", "-evals factDA,tsv -tLPP edu.stanford.nlp.parser.lexparser.ChineseTreebankParserParams -chinesePCFG -encoding utf-8 -saveToSerializedFile %s -saveToTextFile %s -maxLength 40 -train %s -test %s", "-evals factDA,tsv -tLPP edu.stanford.nlp.parser.lexparser.ChineseTreebankParserParams -encoding utf-8 -segmentMarkov -saveToSerializedFile %s -saveToTextFile %s -train %s -test %s -sctags -acl03chinese"};
    public static final String[] germanCommandLines = new String[]{"-evals factDA,tsv -tLPP edu.stanford.nlp.parser.lexparser.NegraPennTreebankParserParams -encoding UTF-8 -hMarkov 1 -vMarkov 2 -vSelSplitCutOff 300 -uwm 1 -unknownSuffixSize 2 -maxLength 40 -nodeCleanup 2 -saveToSerializedFile %s -saveToTextFile %s -train %s -test %s", "-evals factDA,tsv -tLPP edu.stanford.nlp.parser.lexparser.NegraPennTreebankParserParams -encoding UTF-8 -PCFG -hMarkov 1 -vMarkov 2 -vSelSplitCutOff 300 -uwm 1 -unknownSuffixSize 1 -maxLength 40 -nodeCleanup 2 -saveToSerializedFile %s -saveToTextFile %s -train %s -test %s"};
    public static final String[] frenchCommandLines = new String[]{"-evals factDA,tsv -maxLength 40 -tLPP edu.stanford.nlp.parser.lexparser.FrenchTreebankParserParams -encoding UTF-8 -frenchFactored -saveToSerializedFile %s -saveToTextFile %s -train %s -test %s"};
    public static final String[] arabicCommandLines = new String[]{"-evals factDA,tsv -maxLength 40 -tLPP edu.stanford.nlp.parser.lexparser.ArabicTreebankParserParams -encoding UTF-8 -arabicFactored -saveToSerializedFile %s -saveToTextFile %s -train %s -test %s"};
    public static final String baseTestSerCommandLine = "-encoding utf-8 -loadFromSerializedFile %s -testTreebank %s 0-1";
    public static final String baseTestTextCommandLine = "-encoding utf-8 -loadFromTextFile %s -testTreebank %s 0-1";
    public static final String englishOneTree = "projects/core/data/edu/stanford/nlp/parser/trees/en-onetree.txt";
    public static final String englishSecondTree = "projects/core/data/edu/stanford/nlp/parser/trees/en-secondtree.txt";
    public static final String englishThreeTrees = "projects/core/data/edu/stanford/nlp/parser/trees/en-threetrees.txt";
    public static final String chineseOneTree = "projects/core/data/edu/stanford/nlp/parser/trees/zh-onetree.txt";
    public static final String chineseThreeTrees = "projects/core/data/edu/stanford/nlp/parser/trees/zh-threetrees.txt";
    public static final String germanOneTree = "projects/core/data/edu/stanford/nlp/parser/trees/de-onesent.txt";
    public static final String germanThreeTrees = "projects/core/data/edu/stanford/nlp/parser/trees/de-threesents.txt";
    public static final String frenchOneTree = "projects/core/data/edu/stanford/nlp/parser/trees/fr-onetree.txt";
    public static final String frenchThreeTrees = "projects/core/data/edu/stanford/nlp/parser/trees/fr-threetrees.txt";
    public static final String arabicOneTree = "projects/core/data/edu/stanford/nlp/parser/trees/ar-onetree.txt";
    public static final String arabicThreeTrees = "projects/core/data/edu/stanford/nlp/parser/trees/ar-threetrees.txt";

    public static void buildAndTest(ParserTestCase test) throws IOException {
        PrintStream originalOut = System.out;
        PrintStream originalErr = System.err;
        System.out.println("Training:");
        System.out.println(StringUtils.join(test.trainCommandLine));
        ByteArrayOutputStream savedOutput = new ByteArrayOutputStream();
        TeeStream teeOut = new TeeStream(savedOutput, System.out);
        PrintStream teeOutPS = new PrintStream(teeOut);
        TeeStream teeErr = new TeeStream(savedOutput, System.err);
        PrintStream teeErrPS = new PrintStream(teeErr);
        System.setOut(teeOutPS);
        System.setErr(teeErrPS);
        LexicalizedParser.main(test.trainCommandLine);
        teeOutPS.flush();
        teeErrPS.flush();
        teeOut.flush();
        teeErr.flush();
        String[] outputLines = savedOutput.toString().split("(?:\\n|\\r)+");
        String perfLine = outputLines[outputLines.length - 5];
        System.out.println(perfLine);
        BuildLexicalizedParserITest.assertEquals((String)"factor LP/LR summary evalb: LP: 100.0 LR: 100.0 F1: 100.0 Exact: 100.0 N: 1", (String)perfLine.trim());
        Formatter commandLineFormatter = new Formatter();
        commandLineFormatter.format(baseTestSerCommandLine, test.parserFile.getPath(), test.testPath);
        Object[] testCommandLine = commandLineFormatter.toString().split("\\s");
        System.out.println("Testing:");
        System.out.println(StringUtils.join(testCommandLine));
        LexicalizedParser.main((String[])testCommandLine);
        commandLineFormatter = new Formatter();
        commandLineFormatter.format(baseTestTextCommandLine, test.textFile.getPath(), test.testPath);
        testCommandLine = commandLineFormatter.toString().split("\\s");
        System.out.println("Testing:");
        System.out.println(StringUtils.join(testCommandLine));
        LexicalizedParser.main((String[])testCommandLine);
        teeOutPS.flush();
        teeErrPS.flush();
        teeOut.flush();
        teeErr.flush();
        System.setOut(originalOut);
        System.setErr(originalErr);
    }

    public void testBuildEnglishParser() throws IOException {
        ParserTestCase test;
        for (String englishCommandLine : englishCommandLines) {
            test = ParserTestCase.buildOneTreebankTestCase(englishCommandLine, englishOneTree, englishThreeTrees);
            BuildLexicalizedParserITest.buildAndTest(test);
        }
        for (String englishCommandLine : englishTwoTreebanks) {
            test = ParserTestCase.buildTwoTreebankTestCase(englishCommandLine, englishOneTree, englishSecondTree, englishThreeTrees);
            BuildLexicalizedParserITest.buildAndTest(test);
        }
    }

    public void testBuildChineseParser() throws IOException {
        for (String chineseCommandLine : chineseCommandLines) {
            ParserTestCase test = ParserTestCase.buildOneTreebankTestCase(chineseCommandLine, chineseOneTree, chineseThreeTrees);
            BuildLexicalizedParserITest.buildAndTest(test);
        }
    }

    public void testBuildGermanParser() throws IOException {
        for (String germanCommandLine : germanCommandLines) {
            ParserTestCase test = ParserTestCase.buildOneTreebankTestCase(germanCommandLine, germanOneTree, germanThreeTrees);
            BuildLexicalizedParserITest.buildAndTest(test);
        }
    }

    public void testBuildFrenchParser() throws IOException {
        for (String frenchCommandLine : frenchCommandLines) {
            ParserTestCase test = ParserTestCase.buildOneTreebankTestCase(frenchCommandLine, frenchOneTree, frenchThreeTrees);
            BuildLexicalizedParserITest.buildAndTest(test);
        }
    }

    public void testBuildArabicParser() throws IOException {
        for (String arabicCommandLine : arabicCommandLines) {
            ParserTestCase test = ParserTestCase.buildOneTreebankTestCase(arabicCommandLine, arabicOneTree, arabicThreeTrees);
            BuildLexicalizedParserITest.buildAndTest(test);
        }
    }

    public static class ParserTestCase {
        public final String[] trainCommandLine;
        public final String testPath;
        public final File parserFile;
        public final File textFile;

        ParserTestCase(String[] trainCommandLine, String testPath, File parserFile, File textFile) {
            this.trainCommandLine = trainCommandLine;
            this.testPath = testPath;
            this.parserFile = parserFile;
            this.textFile = textFile;
        }

        public static ParserTestCase buildOneTreebankTestCase(String baseCommandLine, String trainPath, String testPath) throws IOException {
            File parserFile = File.createTempFile("parser", ".ser.gz");
            File textFile = File.createTempFile("parser", ".txt");
            Formatter commandLineFormatter = new Formatter();
            commandLineFormatter.format(baseCommandLine, parserFile.getPath(), textFile.getPath(), trainPath, trainPath);
            String[] trainCommandLine = commandLineFormatter.toString().split("\\s+");
            ParserTestCase test = new ParserTestCase(trainCommandLine, testPath, parserFile, textFile);
            return test;
        }

        public static ParserTestCase buildTwoTreebankTestCase(String baseCommandLine, String trainPath, String secondaryPath, String testPath) throws IOException {
            File parserFile = File.createTempFile("parser", ".ser.gz");
            File textFile = File.createTempFile("parser", ".txt");
            Formatter commandLineFormatter = new Formatter();
            commandLineFormatter.format(baseCommandLine, parserFile.getPath(), textFile.getPath(), trainPath, secondaryPath, trainPath);
            String[] trainCommandLine = commandLineFormatter.toString().split("\\s+");
            ParserTestCase test = new ParserTestCase(trainCommandLine, testPath, parserFile, textFile);
            return test;
        }
    }
}

