/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.dvparser;

import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.parser.dvparser.DVModel;
import edu.stanford.nlp.parser.dvparser.DVParserCostAndGradient;
import edu.stanford.nlp.parser.lexparser.LexicalizedParser;
import edu.stanford.nlp.parser.lexparser.Options;
import edu.stanford.nlp.parser.lexparser.Reranker;
import edu.stanford.nlp.parser.lexparser.RerankerQuery;
import edu.stanford.nlp.parser.metrics.Eval;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeTransformer;
import edu.stanford.nlp.trees.Trees;
import edu.stanford.nlp.util.Generics;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import org.ejml.simple.SimpleMatrix;

public class CombinedDVModelReranker
implements Reranker {
    private final Options op;
    private final List<DVModel> models;

    public CombinedDVModelReranker(Options op, List<DVModel> models) {
        this.op = op;
        this.models = models;
    }

    @Override
    public Query process(List<? extends HasWord> sentence) {
        return new Query();
    }

    @Override
    public List<Eval> getEvals() {
        return Collections.emptyList();
    }

    public class Query
    implements RerankerQuery {
        private final TreeTransformer transformer;
        private final List<DVParserCostAndGradient> scorers;

        public Query() {
            this.transformer = LexicalizedParser.buildTrainTransformer(CombinedDVModelReranker.this.op);
            this.scorers = Generics.newArrayList();
            for (DVModel model : CombinedDVModelReranker.this.models) {
                this.scorers.add(new DVParserCostAndGradient(null, null, model, CombinedDVModelReranker.this.op));
            }
        }

        @Override
        public double score(Tree tree) {
            double totalScore = 0.0;
            for (DVParserCostAndGradient scorer : this.scorers) {
                IdentityHashMap<Tree, SimpleMatrix> nodeVectors = Generics.newIdentityHashMap();
                Tree transformedTree = this.transformer.transformTree(tree);
                if (((CombinedDVModelReranker)CombinedDVModelReranker.this).op.trainOptions.useContextWords) {
                    Trees.convertToCoreLabels(transformedTree);
                    transformedTree.setSpans();
                }
                double score = scorer.score(transformedTree, nodeVectors);
                totalScore += score;
            }
            return totalScore;
        }
    }
}

