/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.naturalli;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.naturalli.NaturalLogicAnnotations;
import edu.stanford.nlp.naturalli.Polarity;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.StringUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Test;

public class PolarityITest {
    private static final StanfordCoreNLP pipeline = new StanfordCoreNLP(new Properties(){
        {
            this.setProperty("annotators", "tokenize,ssplit,pos,lemma,parse,natlog");
            this.setProperty("ssplit.isOneSentence", "true");
            this.setProperty("tokenize.class", "PTBTokenizer");
            this.setProperty("tokenize.language", "en");
            this.setProperty("enforceRequirements", "false");
            this.setProperty("natlog.neQuantifiers", "true");
        }
    });

    private Polarity[] annotate(String text) {
        Annotation ann = new Annotation(text);
        pipeline.annotate(ann);
        List tokens = (List)((CoreMap)((List)ann.get(CoreAnnotations.SentencesAnnotation.class)).get(0)).get(CoreAnnotations.TokensAnnotation.class);
        Polarity[] polarities = new Polarity[tokens.size()];
        for (int i = 0; i < tokens.size(); ++i) {
            polarities[i] = (Polarity)((CoreLabel)tokens.get(i)).get(NaturalLogicAnnotations.PolarityAnnotation.class);
        }
        return polarities;
    }

    private void check(String[] expected, String sentence) {
        Polarity[] actual = this.annotate(sentence);
        Assert.assertEquals((String)("Expected polarities have wrong length (" + expected.length + " but got " + actual.length + ") for sentence: '" + sentence + "'"), (long)expected.length, (long)actual.length);
        String expectedStr = StringUtils.join(Arrays.stream(expected).map(x -> {
            switch (x.toLowerCase()) {
                case "up": 
                case "u": 
                case "^": {
                    return "up";
                }
                case "down": 
                case "d": 
                case "v": {
                    return "down";
                }
                case "flat": 
                case "f": 
                case "-": {
                    return "flat";
                }
            }
            throw new IllegalArgumentException("Unknown polarity: " + x);
        }).collect(Collectors.toList()), " ");
        String actualStr = StringUtils.join(Arrays.stream(actual).map(Polarity::toString).collect(Collectors.toList()), " ");
        Assert.assertEquals((String)sentence, (Object)expectedStr, (Object)actualStr);
    }

    private void check(String expected, String sentence) {
        this.check(expected.split(" "), sentence);
    }

    @Test
    public void allCatsHaveTails() {
        Polarity[] p = this.annotate("all cats have tails");
        Assert.assertTrue((boolean)p[0].isUpwards());
        Assert.assertTrue((boolean)p[1].isDownwards());
        Assert.assertTrue((boolean)p[2].isUpwards());
        Assert.assertTrue((boolean)p[3].isUpwards());
    }

    @Test
    public void thereIsNoDoubtThatCatsHaveTails() {
        Polarity[] p = this.annotate("There is no doubt that cats have tails.");
        Assert.assertTrue((boolean)p[0].isUpwards());
        Assert.assertTrue((boolean)p[1].isUpwards());
        Assert.assertTrue((boolean)p[2].isUpwards());
        Assert.assertTrue((boolean)p[3].isDownwards());
        Assert.assertTrue((boolean)p[4].isUpwards());
        Assert.assertTrue((boolean)p[5].isUpwards());
    }

    @Test
    public void someCatsDontHaveTails() {
        Polarity[] p = this.annotate("some cats don't have tails");
        Assert.assertTrue((boolean)p[0].isUpwards());
        Assert.assertTrue((boolean)p[1].isUpwards());
        Assert.assertTrue((boolean)p[2].isUpwards());
        Assert.assertTrue((boolean)p[3].isUpwards());
        Assert.assertTrue((boolean)p[4].isDownwards());
        Assert.assertTrue((boolean)p[5].isDownwards());
    }

    @Test
    public void complexProperNouns() {
        Polarity[] p = this.annotate("Kip , his brothers , and Fletcher also played the Denver area bar scene while calling themselves Colorado .");
        Assert.assertTrue((boolean)p[0].isUpwards());
        for (int i = 1; i < p.length; ++i) {
            Assert.assertTrue((boolean)p[i].isUpwards());
        }
    }

    @Test
    public void temporalTestCases() {
        this.check("^ ^ v v", "Can not do Tuesday");
        this.check("v ^ ^ v v v", "Tuesday is not good for me");
        this.check("v ^ ^ v", "Tuesday won't work");
        this.check("^ ^ v v v v", "Can't make it on Tuesday");
        this.check("v ^ ^ v v", "I can't make tomorrow");
        this.check("^ ^ v v", "Anytime except next tuesday");
        this.check("^ ^ ^ v", "No, not Tuesday");
        this.check("v v v ^ ^ v v", "No, I can't do Tuesday");
        this.check("v v ^ ^ v v", "No I can't do Tuesday");
    }
}

