/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.naturalli;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.naturalli.NaturalLogicAnnotations;
import edu.stanford.nlp.naturalli.OperatorSpec;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Test;

public class OperatorScopeITest {
    private static final StanfordCoreNLP pipeline = new StanfordCoreNLP(new Properties(){
        {
            this.setProperty("annotators", "tokenize,ssplit,pos,lemma,parse,natlog");
            this.setProperty("ssplit.isOneSentence", "true");
            this.setProperty("tokenize.class", "PTBTokenizer");
            this.setProperty("tokenize.language", "en");
            this.setProperty("natlog.neQuantifiers", "true");
        }
    });

    private Optional<OperatorSpec>[] annotate(String text) {
        Annotation ann = new Annotation(text);
        pipeline.annotate(ann);
        List tokens = (List)((CoreMap)((List)ann.get(CoreAnnotations.SentencesAnnotation.class)).get(0)).get(CoreAnnotations.TokensAnnotation.class);
        Object[] scopes = new Optional[tokens.size()];
        Arrays.fill(scopes, Optional.empty());
        for (int i = 0; i < tokens.size(); ++i) {
            if (!((CoreLabel)tokens.get(i)).containsKey(NaturalLogicAnnotations.OperatorAnnotation.class)) continue;
            scopes[i] = Optional.of(((CoreLabel)tokens.get(i)).get(NaturalLogicAnnotations.OperatorAnnotation.class));
        }
        return scopes;
    }

    private void checkScope(int subjBegin, int subjEnd, int objBegin, int objEnd, Optional<OperatorSpec> guess) {
        Assert.assertTrue((String)"No quantifier found", (boolean)guess.isPresent());
        Assert.assertEquals((String)("Bad subject begin " + guess.get()), (long)subjBegin, (long)guess.get().subjectBegin);
        Assert.assertEquals((String)("Bad subject end " + guess.get()), (long)subjEnd, (long)guess.get().subjectEnd);
        Assert.assertEquals((String)("Bad object begin " + guess.get()), (long)objBegin, (long)guess.get().objectBegin);
        Assert.assertEquals((String)("Bad object end " + guess.get()), (long)objEnd, (long)guess.get().objectEnd);
    }

    private void checkScope(int subjBegin, int subjEnd, Optional<OperatorSpec> guess) {
        Assert.assertTrue((String)"No quantifier found", (boolean)guess.isPresent());
        Assert.assertEquals((String)("Bad subject begin " + guess.get() + "  (expected=" + subjBegin + " got=" + guess.get().subjectBegin + ")"), (long)subjBegin, (long)guess.get().subjectBegin);
        Assert.assertEquals((String)("Bad subject end " + guess.get() + "  (expected=" + subjEnd + " got=" + guess.get().subjectEnd + ")"), (long)subjEnd, (long)guess.get().subjectEnd);
        Assert.assertEquals((String)"Two-place quantifier matched", (long)subjEnd, (long)guess.get().objectBegin);
        Assert.assertEquals((String)"Two place quantifier matched", (long)subjEnd, (long)guess.get().objectEnd);
    }

    private void checkScope(String spec) {
        String[] terms = spec.replace(",", " ,").replace(".", " .").split("\\s+");
        int quantEnd = -1;
        int subjBegin = -1;
        int subjEnd = -1;
        int objBegin = -1;
        int objEnd = -1;
        boolean seenSubj = false;
        int tokenIndex = 0;
        ArrayList<String> cleanSentence = new ArrayList<String>();
        String[] stringArray = terms;
        int n = stringArray.length;
        block12: for (int i = 0; i < n; ++i) {
            String term;
            switch (term = stringArray[i]) {
                case "{": {
                    continue block12;
                }
                case "}": {
                    quantEnd = tokenIndex;
                    continue block12;
                }
                case "[": {
                    if (!seenSubj) {
                        subjBegin = tokenIndex;
                        continue block12;
                    }
                    objBegin = tokenIndex;
                    continue block12;
                }
                case "]": {
                    if (!seenSubj) {
                        subjEnd = tokenIndex;
                        seenSubj = true;
                        continue block12;
                    }
                    objEnd = tokenIndex;
                    continue block12;
                }
                default: {
                    cleanSentence.add(term);
                    ++tokenIndex;
                }
            }
        }
        Optional<OperatorSpec>[] scopes = this.annotate(StringUtils.join(cleanSentence, " "));
        System.err.println("Checking [@ " + (quantEnd - 1) + "]:  " + spec);
        if (objBegin >= 0 && objEnd >= 0) {
            this.checkScope(subjBegin, subjEnd, objBegin, objEnd, scopes[quantEnd - 1]);
        } else {
            this.checkScope(subjBegin, subjEnd, scopes[quantEnd - 1]);
        }
    }

    @Test
    public void annotatorRuns() {
        this.annotate("All green cats have tails.");
    }

    @Test
    public void negationMidSentence() {
        this.checkScope(0, 1, 3, 6, this.annotate("Obama was not born in Dallas")[2]);
    }

    @Test
    public void all_X_verb_Y() {
        this.checkScope(1, 2, 2, 4, this.annotate("All cats eat mice.")[0]);
        this.checkScope(1, 2, 2, 4, this.annotate("All cats have tails.")[0]);
    }

    @Test
    public void all_X_want_Y() {
        this.checkScope(1, 2, 2, 4, this.annotate("All cats want milk.")[0]);
    }

    @Test
    public void all_X_verb_prep_Y() {
        this.checkScope(1, 2, 2, 5, this.annotate("All cats are in boxes.")[0]);
        this.checkScope(1, 2, 2, 5, this.annotate("All cats voted for Roosevelt.")[0]);
        this.checkScope(1, 5, 5, 8, this.annotate("All cats who like dogs voted for Teddy.")[0]);
        this.checkScope(1, 2, 2, 6, this.annotate("All cats have spoken to Fido.")[0]);
    }

    @Test
    public void all_X_be_Y() {
        this.checkScope(1, 2, 2, 4, this.annotate("All cats are cute")[0]);
    }

    @Test
    public void all_X_can_Y() {
        this.checkScope(1, 2, 2, 4, this.annotate("All cats can purr")[0]);
    }

    @Test
    public void all_X_relclause_verb_Y() {
        this.checkScope(1, 5, 5, 7, this.annotate("All cats who like dogs eat fish.")[0]);
    }

    @Test
    public void all_of_X_verb_Y() {
        this.checkScope(2, 4, 4, 6, this.annotate("All of the cats hate dogs.")[1]);
        this.checkScope(2, 6, 6, 9, this.annotate("Each of the other 99 companies owns one computer.")[1]);
    }

    @Test
    public void PER_predicate() {
        this.checkScope(0, 1, 1, 4, this.annotate("Felix likes cat food.")[0]);
    }

    @Test
    public void PER_has_predicate() {
        this.checkScope(0, 1, 1, 5, this.annotate("Felix has liked cat food.")[0]);
    }

    @Test
    public void PER_predicate_prep() {
        this.checkScope(0, 1, 1, 7, this.annotate("Jack paid the bank for 10 years")[0]);
    }

    @Test
    public void PER_has_predicate_prep() {
        this.checkScope(0, 1, 1, 5, this.annotate("Felix has spoken to Fido.")[0]);
    }

    @Test
    public void PER_is_nn() {
        this.checkScope(0, 1, 1, 4, this.annotate("Felix is a cat.")[0]);
    }

    @Test
    public void PER_is_jj() {
        this.checkScope(0, 1, 1, 3, this.annotate("Felix is cute.")[0]);
    }

    @Test
    public void few_x_verb_y() {
        this.checkScope(1, 2, 2, 4, this.annotate("all cats chase dogs")[0]);
    }

    @Test
    public void a_few_x_verb_y() {
        this.checkScope(2, 3, 3, 5, this.annotate("a few cats chase dogs")[1]);
        Assert.assertFalse((boolean)this.annotate("a few cats chase dogs")[0].isPresent());
    }

    @Test
    public void binary_no() {
        this.checkScope(1, 2, 2, 4, this.annotate("no cats chase dogs")[0]);
    }

    @Test
    public void unary_not() {
        Optional<OperatorSpec>[] quantifiers = this.annotate("some cats don't like dogs");
        this.checkScope(1, 2, 2, 6, quantifiers[0]);
        this.checkScope(4, 6, quantifiers[3]);
        Assert.assertFalse((boolean)quantifiers[3].get().isBinary());
    }

    @Test
    public void num_X_verb_Y() {
        this.checkScope(1, 2, 2, 4, this.annotate("Three cats eat mice.")[0]);
        this.checkScope(1, 2, 2, 4, this.annotate("3 cats have tails.")[0]);
    }

    @Test
    public void at_least_num_X_verb_Y() {
        this.checkScope(3, 4, 4, 6, this.annotate("at least Three cats eat mice.")[2]);
        this.checkScope(3, 4, 4, 6, this.annotate("at least 3 cats have tails.")[2]);
    }

    @Test
    public void everyone_pp_verb_Y() {
        this.checkScope(1, 3, 3, 5, this.annotate("everyone at Stanford likes cats.")[0]);
        this.checkScope(1, 5, 5, 7, this.annotate("everyone who is at Stanford likes cats.")[0]);
    }

    @Test
    public void there_are_np() {
        this.checkScope(2, 3, this.annotate("there are cats")[1]);
    }

    @Test
    public void there_are_np_pp() {
        this.checkScope(2, 6, this.annotate("there are cats who like dogs")[1]);
    }

    @Test
    public void one_of_the_X_Y() {
        this.checkScope(3, 4, 4, 6, this.annotate("one of the cats have tails")[2]);
    }

    @Test
    public void regressionStrangeComma() {
        Optional<OperatorSpec>[] operators = this.annotate("all cats, have tails.");
        this.checkScope(1, 2, 3, 5, operators[0]);
    }

    @Test
    public void unarySome() {
        this.checkScope(3, 4, this.annotate("Cats eat some mice")[2]);
    }

    @Test
    public void fracasSentencesWithAll() {
        this.checkScope("{ All } [ APCOM managers ] [ have company cars ]");
        this.checkScope("{ All } [ Canadian residents ] [ can travel freely within Europe ]");
        this.checkScope("{ All } [ Europeans ] [ are people ]");
        this.checkScope("{ All } [ Europeans ] [ can travel freely within Europe ]");
        this.checkScope("{ All } [ Europeans ] [ have the right to live in Europe ]");
        this.checkScope("{ All } [ Italian men ] [ want to be a great tenor ]");
        this.checkScope("{ All } [ committee members ] [ are people ]");
        this.checkScope("{ All } [ competent legal authorities ] [ are competent law lecturers ]");
        this.checkScope("{ All } [ elephants ] [ are large animals ]");
        this.checkScope("{ All } [ fat legal authorities ] [ are fat law lecturers ]");
        this.checkScope("{ All } [ law lecturers ] [ are legal authorities ]");
        this.checkScope("{ All } [ legal authorities ] [ are law lecturers ]");
        this.checkScope("{ All } [ mice ] [ are small animals ]");
        this.checkScope("{ All } [ people who are from Portugal ] [ are from southern Europe ]");
        this.checkScope("{ All } [ people who are from Sweden ] [ are from Scandinavia ]");
        this.checkScope("{ All } [ people who are resident in Europe ] [ can travel freely within Europe ]");
        this.checkScope("{ All } [ residents of major western countries ] [ are residents of western countries ]");
        this.checkScope("{ All } [ residents of member states ] [ are individuals ]");
        this.checkScope("{ All } [ residents of the North American continent ] [ can travel freely within Europe ]");
        this.checkScope("{ All } [ the people who were at the meeting ] [ voted for a new chairman ]");
    }

    @Test
    public void fracasSentencesWithEach() {
        this.checkScope("{ Each } [ Canadian resident ] [ can travel freely within Europe ]");
        this.checkScope("{ Each } [ European ] [ can travel freely within Europe ]");
        this.checkScope("{ Each } [ European ] [ has the right to live in Europe ]");
        this.checkScope("{ Each } [ Italian tenor ] [ wants to be great ]");
        this.checkScope("{ Each } [ department ] [ has a dedicated line ]");
        this.checkScope("{ Each } [ resident of the North American continent ] [ can travel freely within Europe ]");
    }

    @Test
    public void fracasSentencesWithEvery() {
        this.checkScope("{ Every } [ Ancient Greek ] [ was a noted philosopher ]");
        this.checkScope("{ Every } [ Canadian resident ] [ can travel freely within Europe ]");
        this.checkScope("{ Every } [ Canadian resident ] [ is a resident of the North American continent ]");
        this.checkScope("{ Every } [ European ] [ can travel freely within Europe ]");
        this.checkScope("{ Every } [ European ] [ has the right to live in Europe ]");
        this.checkScope("{ Every } [ European ] [ is a person ]");
        this.checkScope("{ Every } [ Italian man ] [ wants to be a great tenor ]");
        this.checkScope("{ Every } [ Swede ] [ is a Scandinavian ]");
        this.checkScope("{ Every } [ committee ] [ has a chairman ]");
        this.checkScope("{ Every } [ committee ] [ has a chairman appointed by members of the committee ]");
        this.checkScope("{ Every } [ customer who owns a computer ] [ has a service contract for it ]");
        this.checkScope("{ Every } [ department ] [ rents a line from BT ]");
        this.checkScope("{ Every } [ executive who had a laptop computer ] [ brought it to take notes at the meeting ]");
        this.checkScope("{ Every } [ four-legged mammal ] [ is a four-legged animal ]");
        this.checkScope("{ Every } [ individual who has the right to live anywhere in Europe ] [ can travel freely within Europe ]");
        this.checkScope("{ Every } [ individual who has the right to live in Europe ] [ can travel freely within Europe ]");
        this.checkScope("{ Every } [ inhabitant of Cambridge ] [ voted for a Labour MP ]");
        this.checkScope("{ Every } [ mammal ] [ is an animal ]");
        this.checkScope("{ Every } [ person who has the right to live in Europe ] [ can travel freely within Europe ]");
        this.checkScope("{ Every } [ report ] [ has a cover page ]");
        this.checkScope("{ Every } [ representative and client ] [ was at the meeting ]");
        this.checkScope("{ Every } [ representative and every client ] [ was at the meeting ]");
        this.checkScope("{ Every } [ representative ] [ has read this report ]");
        this.checkScope("{ Every } [ representative or client ] [ was at the meeting ]");
        this.checkScope("{ Every } [ representative ] [ was at the meeting ]");
        this.checkScope("{ Every } [ resident of the North American continent ] [ can travel freely within Europe ]");
        this.checkScope("{ Every } [ student ] [ used her workstation ]");
    }

    @Test
    public void fracasSentencesWithEveryone() {
        this.checkScope("{ Everyone } [ at the meeting ] [ voted for a new chairman ]");
        this.checkScope("{ Everyone } [ who starts gambling seriously ] [ continues until he is broke ]");
        this.checkScope("{ Everyone } [ who starts gambling seriously ] [ stops the moment he is broke ]");
    }

    @Test
    public void fracasSentencesWithFew() {
        this.checkScope("{ Few } [ committee members ] [ are from Portugal ]");
        this.checkScope("{ Few } [ committee members ] [ are from southern Europe ]");
        this.checkScope("{ Few } [ female committee members ] [ are from southern Europe ]");
    }

    @Test
    public void fracasSentencesWithA() {
        this.checkScope("{ A } [ Scandinavian ] [ won a Nobel prize ]");
        this.checkScope("{ A } [ Swede ] [ won a Nobel prize ]");
        this.checkScope("{ A } [ company director ] [ awarded himself a large payrise ]");
        this.checkScope("{ A } [ company director ] [ has awarded and been awarded a payrise ]");
        this.checkScope("{ A } [ lawyer ] [ signed every report ]");
        this.checkScope("{ An } [ Irishman ] [ won a Nobel prize ]");
        this.checkScope("{ An } [ Irishman ] [ won the Nobel prize for literature ]");
        this.checkScope("{ An } [ Italian ] [ became the world 's greatest tenor ]");
    }

    @Test
    public void fracasSentencesWithAFew() {
        this.checkScope("{ A few } [ committee members ] [ are from Scandinavia ]");
        this.checkScope("{ A few } [ committee members ] [ are from Sweden ]");
        this.checkScope("{ A few } [ female committee members ] [ are from Scandinavia ]");
        this.checkScope("{ A few } [ great tenors ] [ sing popular music ]");
    }

    @Test
    public void fracasSentencesWithAtLeastAFew() {
        this.checkScope("{ At least a few } [ committee members ] [ are from Scandinavia ]");
        this.checkScope("{ At least a few } [ committee members ] [ are from Sweden ]");
    }

    @Test
    public void fracasSentencesWithEither() {
        this.checkScope("{ Either } [ Smith Jones or Anderson ] [ signed the contract ]");
    }

    @Test
    public void fracasSentencesWithOneOfThe() {
        this.checkScope("{ One of } [ the commissioners ] [ spends a lot of time at home ]");
    }

    @Test
    public void fracasSentencesWithSeveral() {
        this.checkScope("{ Several } [ Portuguese delegates ] [ got the results published in major national newspapers ]");
        this.checkScope("{ Several } [ delegates ] [ got the results published ]");
        this.checkScope("{ Several } [ delegates ] [ got the results published in major national newspapers ]");
        this.checkScope("{ Several } [ great tenors ] [ are British ]");
    }

    @Test
    public void fracasSentencesWithSome() {
        this.checkScope("{ Some } [ Irish delegates ] [ finished the survey on time ]");
        this.checkScope("{ Some } [ Italian men ] [ are great tenors ]");
        this.checkScope("{ Some } [ Italian tenors ] [ are great ]");
        this.checkScope("{ Some } [ Scandinavian delegate ] [ finished the report on time ]");
        this.checkScope("{ Some } [ accountant ] [ attended the meeting ]");
        this.checkScope("{ Some } [ accountants ] [ attended the meeting ]");
        this.checkScope("{ Some } [ delegate ] [ finished the report on time ]");
        this.checkScope("{ Some } [ delegates ] [ finished the survey ]");
        this.checkScope("{ Some } [ delegates ] [ finished the survey on time ]");
        this.checkScope("{ Some } [ great tenors ] [ are Swedish ]");
        this.checkScope("{ Some } [ people ] [ discover that they have been asleep ]");
    }

    @Test
    public void fracasSentencesWithThe() {
        this.checkScope("{ The } [ Ancient Greeks ] [ were all noted philosophers ]");
        this.checkScope("{ The } [ Ancient Greeks ] [ were noted philosophers ]");
        this.checkScope("{ The } [ ITEL-XZ ] [ is fast ]");
        this.checkScope("{ The } [ ITEL-ZX ] [ is an ITEL computer ]");
        this.checkScope("{ The } [ ITEL-ZX ] [ is slower than 500 MIPS ]");
        this.checkScope("{ The } [ PC-6082 ] [ is as fast as the ITEL-XZ ]");
        this.checkScope("{ The } [ PC-6082 ] [ is fast ]");
        this.checkScope("{ The } [ PC-6082 ] [ is faster than 500 MIPS ]");
        this.checkScope("{ The } [ PC-6082 ] [ is faster than any ITEL computer ]");
        this.checkScope("{ The } [ PC-6082 ] [ is faster than every ITEL computer ]");
        this.checkScope("{ The } [ PC-6082 ] [ is faster than some ITEL computer ]");
        this.checkScope("{ The } [ PC-6082 ] [ is faster than the ITEL-XZ ]");
        this.checkScope("{ The } [ PC-6082 ] [ is faster than the ITEL-ZX ]");
        this.checkScope("{ The } [ PC-6082 ] [ is faster than the ITEL-ZX and the ITEL-ZY ]");
        this.checkScope("{ The } [ PC-6082 ] [ is faster than the ITEL-ZX or the ITEL-ZY ]");
        this.checkScope("{ The } [ PC-6082 ] [ is slow ]");
        this.checkScope("{ The } [ PC-6082 ] [ is slower than the ITEL-XZ ]");
        this.checkScope("{ The } [ chairman of the department ] [ is a person ]");
        this.checkScope("{ The } [ chairman ] [ read out every item on the agenda ]");
        this.checkScope("{ The } [ chairman ] [ read out the items on the agenda ]");
        this.checkScope("{ The } [ conference ] [ started on July 4th , 1994 ]");
        this.checkScope("{ The } [ conference ] [ was over on July 8th , 1994 ]");
        this.checkScope("{ The } [ inhabitants of Cambridge ] [ voted for a Labour MP ]");
        this.checkScope("{ The } [ people who were at the meeting ] [ voted for a new chairman ]");
        this.checkScope("{ The } [ really ambitious tenors ] [ are Italian ]");
        this.checkScope("{ The } [ residents of major western countries ] [ can travel freely within Europe ]");
        this.checkScope("{ The } [ residents of major western countries ] [ have the right to live in Europe ]");
        this.checkScope("{ The } [ residents of member states ] [ can travel freely within Europe ]");
        this.checkScope("{ The } [ residents of member states ] [ have the right to live anywhere in Europe ]");
        this.checkScope("{ The } [ residents of member states ] [ have the right to live in Europe ]");
        this.checkScope("{ The } [ residents of western countries ] [ can travel freely within Europe ]");
        this.checkScope("{ The } [ residents of western countries ] [ have the right to live in Europe ]");
        this.checkScope("{ The } [ sales department ] [ rents a line from BT ]");
        this.checkScope("{ The } [ sales department ] [ rents it from BT ]");
        this.checkScope("{ The } [ students ] [ are going to Paris by train ]");
        this.checkScope("{ The } [ students ] [ have spoken to Mary ]");
        this.checkScope("{ The } [ system failure ] [ was blamed on one or more software faults ]");
    }

    @Test
    public void fracasSentencesWithThereAre() {
        this.checkScope("{ There are } [ 100 companies ]");
        this.checkScope("{ There are } [ Italian men who want to be a great tenor ]");
        this.checkScope("{ There are } [ Italian tenors who want to be great ]");
        this.checkScope("{ There are } [ few committee members from Portugal ]");
        this.checkScope("{ There are } [ few committee members from southern Europe ]");
        this.checkScope("{ There are } [ great tenors who are British ]");
        this.checkScope("{ There are } [ great tenors who are German ]");
        this.checkScope("{ There are } [ great tenors who are Italian ]");
        this.checkScope("{ There are } [ great tenors who are Swedish ]");
        this.checkScope("{ There are } [ great tenors who sing popular music ]");
        this.checkScope("{ There are } [ sixteen representatives ]");
        this.checkScope("{ There are } [ some reports from ITEL on Smith 's desk ]");
        this.checkScope("{ There are } [ tenors who will take part in the concert ]");
        this.checkScope("{ There is } [ a car that John and Bill own ]");
        this.checkScope("{ There is } [ someone whom Helen saw answer the phone ]");
        this.checkScope("{ There was } [ a group of people that met ]");
        this.checkScope("{ There was } [ an Italian who became the world 's greatest tenor ]");
        this.checkScope("{ There was } [ one auditor who signed all the reports ]");
    }

    @Test
    public void fracasSentencesWithProperNouns() {
        this.checkScope("[ { APCOM } ] [ has a more important customer than ITEL ]");
        this.checkScope("[ { APCOM } ] [ has a more important customer than ITEL has ]");
        this.checkScope("[ { APCOM } ] [ has a more important customer than ITEL is ]");
        this.checkScope("[ { APCOM } ] [ has been paying mortgage interest for a total of 15 years or more ]");
        this.checkScope("[ { APCOM } ] [ lost some orders ]");
        this.checkScope("[ { APCOM } ] [ lost ten orders ]");
        this.checkScope("[ { APCOM } ] [ signed the contract Friday , 13th ]");
        this.checkScope("[ { APCOM } ] [ sold exactly 2500 computers ]");
        this.checkScope("[ { APCOM } ] [ won some orders ]");
        this.checkScope("[ { APCOM } ] [ won ten orders ]");
        this.checkScope("[ { Bill } ] [ bought a car ]");
        this.checkScope("[ { Bill } ] [ has spoken to Mary ]");
        this.checkScope("[ { Bill } ] [ is going to ]");
        this.checkScope("[ { Bill } ] [ knows why John had his paper accepted ]");
        this.checkScope("[ { Bill } ] [ owns a blue car ]");
        this.checkScope("[ { Bill } ] [ owns a blue one ]");
        this.checkScope("[ { Bill } ] [ owns a car ]");
        this.checkScope("[ { Bill } ] [ owns a fast car ]");
        this.checkScope("[ { Bill } ] [ owns a fast one ]");
        this.checkScope("[ { Bill } ] [ owns a fast red car ]");
        this.checkScope("[ { Bill } ] [ owns a red car ]");
        this.checkScope("[ { Bill } ] [ owns a slow one ]");
        this.checkScope("[ { Bill } ] [ owns a slow red car ]");
        this.checkScope("[ { Bill } ] [ said Mary wrote a report ]");
        this.checkScope("[ { Bill } ] [ said Peter wrote a report ]");
        this.checkScope("[ { Bill } ] [ spoke to Mary ]");
        this.checkScope("[ { Bill } ] [ spoke to Mary at five o'clock ]");
        this.checkScope("[ { Bill } ] [ spoke to Mary at four o'clock ]");
        this.checkScope("[ { Bill } ] [ spoke to Mary on Monday ]");
        this.checkScope("[ { Bill } ] [ spoke to everyone that John did ]");
        this.checkScope("[ { Bill } ] [ suggested to Frank 's boss that they should go to the meeting together , and Carl to Alan 's wife ]");
        this.checkScope("[ { Bill } ] [ went to Berlin by car ]");
        this.checkScope("[ { Bill } ] [ went to Berlin by train ]");
        this.checkScope("[ { Bill } ] [ went to Paris by train ]");
        this.checkScope("[ { Bill } ] [ will speak to Mary ]");
        this.checkScope("[ { Bill } ] [ wrote a report ]");
        this.checkScope("[ { Dumbo } ] [ is a four-legged animal ]");
        this.checkScope("[ { Dumbo } ] [ is a large animal ]");
        this.checkScope("[ { Dumbo } ] [ is a small animal ]");
        this.checkScope("[ { Dumbo } ] [ is a small elephant ]");
        this.checkScope("[ { Dumbo } ] [ is four-legged ]");
        this.checkScope("[ { Dumbo } ] [ is larger than Mickey ]");
        this.checkScope("[ { GFI } ] [ owns several computers ]");
        this.checkScope("[ { Helen } ] [ saw the chairman of the department answer the phone ]");
        this.checkScope("[ { ICM } ] [ is one of the companies and owns 150 computers ]");
        this.checkScope("[ { ITEL } ] [ built MTALK in 1993 ]");
        this.checkScope("[ { ITEL } ] [ delivered reports late in 1993 ]");
        this.checkScope("[ { ITEL } ] [ developed a new editor in 1993 ]");
        this.checkScope("[ { ITEL } ] [ existed in 1992 ]");
        this.checkScope("[ { ITEL } ] [ expanded in 1993 ]");
        this.checkScope("[ { ITEL } ] [ finished MTALK in 1993 ]");
        this.checkScope("[ { ITEL } ] [ has a factory in Birmingham ]");
        this.checkScope("[ { ITEL } ] [ has developed a new editor since 1992 ]");
        this.checkScope("[ { ITEL } ] [ has expanded since 1992 ]");
        this.checkScope("[ { ITEL } ] [ has made a loss since 1992 ]");
        this.checkScope("[ { ITEL } ] [ has sent most of the reports Smith needs ]");
        this.checkScope("[ { ITEL } ] [ made a loss in 1993 ]");
        this.checkScope("[ { ITEL } ] [ maintains all the computers that GFI owns ]");
        this.checkScope("[ { ITEL } ] [ maintains them ]");
        this.checkScope("[ { ITEL } ] [ managed to win the contract in 1992 ]");
        this.checkScope("[ { ITEL } ] [ owned APCOM from 1988 to 1992 ]");
        this.checkScope("[ { ITEL } ] [ owned APCOM in 1990 ]");
        this.checkScope("[ { ITEL } ] [ sent a progress report in July 1994 ]");
        this.checkScope("[ { ITEL } ] [ sold 3000 more computers than APCOM ]");
        this.checkScope("[ { ITEL } ] [ sold 5500 computers ]");
        this.checkScope("[ { ITEL } ] [ tried to win the contract in 1992 ]");
        this.checkScope("[ { ITEL } ] [ was building MTALK in 1993 ]");
        this.checkScope("[ { ITEL } ] [ was winning the contract from APCOM in 1993 ]");
        this.checkScope("[ { ITEL } ] [ won a contract in 1993 ]");
        this.checkScope("[ { ITEL } ] [ won at least eleven orders ]");
        this.checkScope("[ { ITEL } ] [ won more orders than APCOM ]");
        this.checkScope("[ { ITEL } ] [ won more orders than APCOM did ]");
        this.checkScope("[ { ITEL } ] [ won more orders than the APCOM contract ]");
        this.checkScope("[ { ITEL } ] [ won more than one order ]");
        this.checkScope("[ { ITEL } ] [ won some orders ]");
        this.checkScope("[ { ITEL } ] [ won the APCOM contract ]");
        this.checkScope("[ { ITEL } ] [ won the contract from APCOM in 1993 ]");
        this.checkScope("[ { ITEL } ] [ won the contract in 1992 ]");
        this.checkScope("[ { ITEL } ] [ won twenty orders ]");
        this.checkScope("[ { ITEL } ] [ won twice as many orders than APCOM ]");
        this.checkScope("[ { Itel } ] [ was in Birmingham in 1993 ]");
        this.checkScope("[ { John } ] [ bought a car ]");
        this.checkScope("[ { John } ] [ found Mary before Bill ]");
        this.checkScope("[ { John } ] [ found Mary before Bill found Mary ]");
        this.checkScope("[ { John } ] [ found Mary before John found Bill ]");
        this.checkScope("[ { John } ] [ had his paper accepted ]");
        this.checkScope("[ { John } ] [ has a diamond ]");
        this.checkScope("[ { John } ] [ has a genuine diamond ]");
        this.checkScope("[ { John } ] [ has spoken to Mary ]");
        this.checkScope("[ { John } ] [ hated the meeting ]");
        this.checkScope("[ { John } ] [ is a cleverer politician than Bill ]");
        this.checkScope("[ { John } ] [ is a fatter politician than Bill ]");
        this.checkScope("[ { John } ] [ is a former successful university student ]");
        this.checkScope("[ { John } ] [ is a former university student ]");
        this.checkScope("[ { John } ] [ is a man and Mary is a woman ]");
        this.checkScope("[ { John } ] [ is a successful former university student ]");
        this.checkScope("[ { John } ] [ is a university student ]");
        this.checkScope("[ { John } ] [ is cleverer than Bill ]");
        this.checkScope("[ { John } ] [ is fatter than Bill ]");
        this.checkScope("[ { John } ] [ is going to Paris by car , and the students by train ]");
        this.checkScope("[ { John } ] [ is successful ]");
        this.checkScope("[ { John } ] [ owns a car ]");
        this.checkScope("[ { John } ] [ owns a fast red car ]");
        this.checkScope("[ { John } ] [ owns a red car ]");
        this.checkScope("[ { John } ] [ represents his company ] and so does Mary");
        this.checkScope("[ { John } ] [ said Bill had been hurt ]");
        this.checkScope("[ { John } ] [ said Bill had hurt himself ]");
        this.checkScope("[ { John } ] [ said Bill wrote a report ]");
        this.checkScope("[ { John } ] [ said Mary wrote a report ] , and Bill did too");
        this.checkScope("[ { John } ] [ spoke to Mary ]");
        this.checkScope("[ { John } ] [ spoke to Mary at four o'clock ]");
        this.checkScope("[ { John } ] [ spoke to Mary on Friday ]");
        this.checkScope("[ { John } ] [ spoke to Mary on Monday ]");
        this.checkScope("[ { John } ] [ spoke to Mary on Thursday ]");
        this.checkScope("[ { John } ] [ spoke to Sue ]");
        this.checkScope("[ { John } ] [ wanted to buy a car ] , and he did");
        this.checkScope("[ { John } ] [ wants to know how many men work part time ]");
        this.checkScope("[ { John } ] [ wants to know how many men work part time , and which ]");
        this.checkScope("[ { John } ] [ wants to know how many women work part time ]");
        this.checkScope("[ { John } ] [ wants to know which men work part time ]");
        this.checkScope("[ { John } ] [ went to Paris by car ]");
        this.checkScope("[ { John } ] [ went to Paris by car , and Bill by train ]");
        this.checkScope("[ { John } ] [ went to Paris by car , and Bill by train to Berlin ]");
        this.checkScope("[ { John } ] [ went to Paris by car , and Bill to Berlin ]");
        this.checkScope("[ { John } ] [ wrote a report ]");
        this.checkScope("[ { Jones } ] [ claimed Smith had costed Jones ' proposal ]");
        this.checkScope("[ { Jones } ] [ claimed Smith had costed Smith 's proposal ]");
        this.checkScope("[ { Jones } ] [ claimed he had costed Smith 's proposal ]");
        this.checkScope("[ { Jones } ] [ claimed he had costed his own proposal ]");
        this.checkScope("[ { Jones } ] [ graduated in March ] and has been employed ever since");
        this.checkScope("[ { Jones } ] [ has a company car ]");
        this.checkScope("[ { Jones } ] [ has been unemployed in the past ]");
        this.checkScope("[ { Jones } ] [ has more than one company car ]");
        this.checkScope("[ { Jones } ] [ is an APCOM manager ]");
        this.checkScope("[ { Jones } ] [ is the chairman of ITEL ]");
        this.checkScope("[ { Jones } ] [ left after Anderson left ]");
        this.checkScope("[ { Jones } ] [ left after Anderson was present ]");
        this.checkScope("[ { Jones } ] [ left after Smith left ]");
        this.checkScope("[ { Jones } ] [ left before Anderson left ]");
        this.checkScope("[ { Jones } ] [ left before Smith left ]");
        this.checkScope("[ { Jones } ] [ left the meeting ]");
        this.checkScope("[ { Jones } ] [ represents Jones 's company ]");
        this.checkScope("[ { Jones } ] [ represents Smith 's company ]");
        this.checkScope("[ { Jones } ] [ revised the contract ]");
        this.checkScope("[ { Jones } ] [ revised the contract after Smith did ]");
        this.checkScope("[ { Jones } ] [ revised the contract before Smith did ]");
        this.checkScope("[ { Jones } ] [ signed another contract ]");
        this.checkScope("[ { Jones } ] [ signed the contract ]");
        this.checkScope("[ { Jones } ] [ signed two contracts ]");
        this.checkScope("[ { Jones } ] [ swam after Smith swam ]");
        this.checkScope("[ { Jones } ] [ swam to the shore ]");
        this.checkScope("[ { Jones } ] [ swam to the shore after Smith swam to the shore ]");
        this.checkScope("[ { Jones } ] [ was present ]");
        this.checkScope("[ { Jones } ] [ was present after Smith was present ]");
        this.checkScope("[ { Jones } ] [ was present before Smith was present ]");
        this.checkScope("[ { Jones } ] [ was unemployed at some time before he graduated ]");
        this.checkScope("[ { Jones } ] [ was writing a report ]");
        this.checkScope("[ { Jones } ] [ was writing a report after Smith was writing a report ]");
        this.checkScope("[ { Jones } ] [ was writing a report before Smith was writing a report ]");
        this.checkScope("[ { Kim } ] [ is a clever person ]");
        this.checkScope("[ { Kim } ] [ is a clever politician ]");
        this.checkScope("[ { Kim } ] [ is clever ]");
        this.checkScope("[ { MFI } ] [ has a service contract for all its computers ]");
        this.checkScope("[ { MFI } ] [ is a customer that owns exactly one computer ]");
        this.checkScope("[ { MFI } ] [ is a customer that owns several computers ]");
        this.checkScope("[ { Mary } ] [ has a workstation ]");
        this.checkScope("[ { Mary } ] [ is a student ]");
        this.checkScope("[ { Mary } ] [ is female ]");
        this.checkScope("[ { Mary } ] [ represents John 's company ]");
        this.checkScope("[ { Mary } ] [ represents her own company ]");
        this.checkScope("[ { Mary } ] [ used a workstation ]");
        this.checkScope("[ { Mary } ] [ used her workstation ]");
        this.checkScope("[ { Mickey } ] [ is a large animal ]");
        this.checkScope("[ { Mickey } ] [ is a large mouse ]");
        this.checkScope("[ { Mickey } ] [ is a small animal ]");
        this.checkScope("[ { Mickey } ] [ is larger than Dumbo ]");
        this.checkScope("[ { Mickey } ] [ is smaller than Dumbo ]");
        this.checkScope("[ { Pavarotti } ] [ is a leading tenor who comes cheap ]");
        this.checkScope("[ { Tuesday } ] [ is not good for me ] .");
    }

    @Test
    public void fracasSentencesWithAtMostAtLeast() {
        this.checkScope("{ At least three } [ commissioners ] [ spend a lot of time at home ]");
        this.checkScope("{ At least three } [ commissioners ] [ spend time at home ]");
        this.checkScope("{ At least three } [ female commissioners ] [ spend time at home ]");
        this.checkScope("{ At least three } [ male commissioners ] [ spend time at home ]");
        this.checkScope("{ At least three } [ tenors ] [ will take part in the concert ]");
        this.checkScope("{ At most ten } [ commissioners ] [ spend a lot of time at home ]");
        this.checkScope("{ At most ten } [ commissioners ] [ spend time at home ]");
        this.checkScope("{ At most ten } [ female commissioners ] [ spend time at home ]");
        this.checkScope("{ Just one } [ accountant ] [ attended the meeting ]");
    }

    @Test
    public void fracasSentencesWithPureNumbers() {
        this.checkScope("{ Eight } [ machines ] [ have been removed ]");
        this.checkScope("{ Five } [ men ] [ work part time ]");
        this.checkScope("{ Forty five } [ women ] [ work part time ]");
        this.checkScope("{ Six } [ accountants ] [ signed the contract ]");
        this.checkScope("{ Six } [ lawyers ] [ signed the contract ]");
        this.checkScope("{ Two } [ machines ] [ have been removed ]");
    }

    @Test
    public void fracasSentencesWithBoth() {
        this.checkScope("{ Both } [ commissioners ] [ used to be businessmen ]");
        this.checkScope("{ Both } [ commissioners ] [ used to be leading businessmen ]");
        this.checkScope("{ Both } [ leading tenors ] [ are excellent ]");
        this.checkScope("{ Both } [ leading tenors ] [ are indispensable ]");
    }

    @Test
    public void fracasSentencesWithMany() {
        this.checkScope("{ Many } [ British delegates ] [ obtained interesting results from the survey ]");
        this.checkScope("{ Many } [ delegates ] [ obtained interesting results from the survey ]");
        this.checkScope("{ Many } [ delegates ] [ obtained results from the survey ]");
        this.checkScope("{ Many } [ great tenors ] [ are German ]");
    }

    @Test
    public void fracasSentencesWithMost() {
        this.checkScope("{ Most } [ Europeans ] [ can travel freely within Europe ]");
        this.checkScope("{ Most } [ Europeans who are resident in Europe ] [ can travel freely within Europe ]");
        this.checkScope("{ Most } [ Europeans who are resident outside Europe ] [ can travel freely within Europe ]");
        this.checkScope("{ Most } [ clients at the demonstration ] [ were impressed by the system 's performance ]");
        this.checkScope("{ Most } [ companies that own a computer ] [ have a service contract for it ]");
        this.checkScope("{ Most } [ great tenors ] [ are Italian ]");
    }

    @Test
    public void fracasSentencesWithNeither() {
        this.checkScope("{ Neither } [ commissioner ] [ spends a lot of time at home ]");
        this.checkScope("{ Neither } [ commissioner ] [ spends time at home ]");
        this.checkScope("{ Neither } [ leading tenor ] [ comes cheap ]");
    }

    @Test
    public void fracasSentencesWithBinaryNo() {
        this.checkScope("{ No } [ Scandinavian delegate ] [ finished the report on time ]");
        this.checkScope("{ No } [ accountant ] [ attended the meeting ]");
        this.checkScope("{ No } [ accountants ] [ attended the meeting ]");
        this.checkScope("{ No } [ delegate ] [ finished the report ]");
        this.checkScope("{ No } [ really great tenors ] [ are modest ]");
        this.checkScope("{ No } [ representative ] [ took less than half a day to read the report ]");
        this.checkScope("{ No } [ student ] [ used her workstation ]");
        this.checkScope("{ No } [ two representatives ] [ have read it at the same time ]");
        this.checkScope("{ No } [ delegate ] [ finished the report on time ]");
    }

    @Test
    public void fracasSentencesWithBinaryNoOne() {
        this.checkScope("{ Nobody } [ who is asleep ] [ ever knows that he is asleep ]");
    }

    @Test
    public void temporalRegressions() {
        this.checkScope("[ I ] can { not } [ make tomorrow ]");
        this.checkScope("Anytime { but } [ next Tuesday ]");
        this.checkScope("Anytime { except } [ next Tuesday ]");
        this.checkScope("{ not } [ on Tuesday ]");
    }

    @Test
    public void implicitNegationsBut() {
        this.checkScope("Anytime { but } [ next Tuesday ]");
        this.checkScope("food but { not } [ water ]");
    }

    @Test
    public void implicitNegationsExcept() {
        this.checkScope("I like everything , { except } [ cabbage ]");
        this.checkScope("Anytime { except } [ next Tuesday ]");
    }

    @Test
    public void doubleNegatives() {
        this.checkScope("No, { not } [ Tuesday ]");
        this.checkScope("[ No , I ] can { not } [ do Tuesday ]");
        this.checkScope("[ No I ] can { not } [ do Tuesday ]");
    }

    @Test
    public void binaryNegationOutOfOrder() {
        this.checkScope("[ Tuesday ] will { not } [ work ]");
        this.checkScope("[ Cats ] are { not } [ fluffy ]");
        this.checkScope("[ Tuesday ] is { not } [ good for me ] .");
    }
}

