/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.misc;

import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DependencyAnalyzer {
    private static Redwood.RedwoodChannels log = Redwood.channels(DependencyAnalyzer.class);
    private static final boolean VERBOSE = false;
    private Map<String, Identifier> identifiers = Generics.newHashMap();
    public static final Pattern pkgLine = Pattern.compile("(\\S*)(?:\\s+\\*)?\\s*");
    public static final Pattern classLine = Pattern.compile("    ([^<]\\S*)(?:\\s+\\*)?\\s*");
    public static final Pattern memberLine = Pattern.compile("        ([a-zA-Z_\\$]{1}.*)");
    public static final Pattern inDepLine = Pattern.compile("\\s*<-- (.*)");
    public static final Pattern outDepLine = Pattern.compile("\\s*--> (.*)");
    public static final Pattern bothDepLine = Pattern.compile("\\s*<-> (.*)");

    void addStartingClasses(LinkedList<Identifier> depQueue, Set<Identifier> closure, List<String> startingClasses) {
        Pattern[] startingPatterns = new Pattern[startingClasses.size()];
        boolean[] matched = new boolean[startingClasses.size()];
        for (int i = 0; i < startingClasses.size(); ++i) {
            String startingClass = startingClasses.get(i);
            startingClass = startingClass.replaceAll("\\.", "\\\\\\.");
            startingClass = startingClass.replaceAll("\\$", "\\\\\\$");
            startingClass = startingClass.replaceAll("\\*", ".*");
            startingPatterns[i] = Pattern.compile(startingClass);
            matched[i] = false;
        }
        block1: for (Identifier id : this.identifiers.values()) {
            if (!id.isClass) continue;
            for (int i = 0; i < startingClasses.size(); ++i) {
                if (!startingPatterns[i].matcher(id.name).matches()) continue;
                depQueue.addLast(id);
                closure.add(id);
                matched[i] = true;
                continue block1;
            }
        }
        for (int i = 0; i < startingClasses.size(); ++i) {
            if (matched[i]) continue;
            log.info("Warning: pattern " + startingClasses.get(i) + " matched nothing");
        }
    }

    public Collection<Identifier> transitiveClosure(List<String> startingClassNames) {
        Set<Identifier> closure = Generics.newHashSet();
        LinkedList<Identifier> depQueue = new LinkedList<Identifier>();
        this.addStartingClasses(depQueue, closure, startingClassNames);
        while (!depQueue.isEmpty()) {
            Identifier id = depQueue.removeFirst();
            for (Identifier outgoingDependency : id.outgoingDependencies) {
                if (!outgoingDependency.isClass || closure.contains(outgoingDependency)) continue;
                depQueue.addLast(outgoingDependency);
                closure.add(outgoingDependency);
            }
        }
        return closure;
    }

    public static void main(String[] args) throws Exception {
        DependencyAnalyzer da = new DependencyAnalyzer(args[0]);
        ArrayList<String> startingClasses = new ArrayList<String>(args.length - 1);
        for (int i = 1; i < args.length; ++i) {
            startingClasses.add(args[i]);
        }
        Collection<Identifier> closure = da.transitiveClosure(startingClasses);
        ArrayList<Identifier> sortedClosure = new ArrayList<Identifier>(closure);
        Collections.sort(sortedClosure);
        Set<String> alreadyOutput = Generics.newHashSet();
        for (Identifier identifier : sortedClosure) {
            String name = identifier.name;
            if (!name.startsWith("edu.stanford.nlp")) continue;
            name = name.replace('.', '/') + ".class";
            if (alreadyOutput.contains(name = name.replaceAll("\\[\\]", ""))) continue;
            alreadyOutput.add(name);
            System.out.println(name);
        }
    }

    public static String prependPackage(String pkgname, String classname) {
        if (pkgname.equals("")) {
            return classname;
        }
        return pkgname + "." + classname;
    }

    public DependencyAnalyzer(String filename) throws IOException {
        String line;
        BufferedReader input = new BufferedReader(new FileReader(filename));
        Identifier curPackage = null;
        Identifier curClass = null;
        while ((line = input.readLine()) != null) {
            String name;
            Matcher matcher = pkgLine.matcher(line);
            if (matcher.matches()) {
                name = matcher.group(1);
                curPackage = this.canonicalIdentifier(name);
                curClass = null;
                continue;
            }
            matcher = classLine.matcher(line);
            if (matcher.matches()) {
                name = DependencyAnalyzer.prependPackage(curPackage.name, matcher.group(1));
                curClass = this.canonicalIdentifier(name);
                curClass.isClass = true;
                continue;
            }
            matcher = memberLine.matcher(line);
            if (matcher.matches()) {
                name = curClass.name + "." + matcher.group(1);
                continue;
            }
            matcher = inDepLine.matcher(line);
            if (matcher.matches()) {
                name = matcher.group(1);
                Identifier inDep = this.canonicalIdentifier(name);
                if (curClass == null) continue;
                curClass.ingoingDependencies.add(inDep);
                continue;
            }
            matcher = outDepLine.matcher(line);
            if (matcher.matches()) {
                name = matcher.group(1);
                Identifier outDep = this.canonicalIdentifier(name);
                if (curClass == null) continue;
                curClass.outgoingDependencies.add(outDep);
                continue;
            }
            matcher = bothDepLine.matcher(line);
            if (matcher.matches()) {
                name = matcher.group(1);
                Identifier dep = this.canonicalIdentifier(name);
                if (curClass == null) continue;
                curClass.ingoingDependencies.add(dep);
                curClass.outgoingDependencies.add(dep);
                continue;
            }
            log.info("Found unmatching line: " + line);
        }
        for (String className : this.identifiers.keySet()) {
            String baseName;
            Identifier baseId;
            int baseIndex;
            Identifier classId = this.identifiers.get(className);
            if (!classId.isClass || (baseIndex = className.indexOf("$")) < 0 || (baseId = this.identifiers.get(baseName = className.substring(0, baseIndex))) == null) continue;
            baseId.ingoingDependencies.add(classId);
            baseId.outgoingDependencies.add(classId);
            classId.ingoingDependencies.add(baseId);
            classId.outgoingDependencies.add(baseId);
        }
    }

    private Identifier canonicalIdentifier(String name) {
        Identifier ident = this.identifiers.get(name);
        if (ident == null) {
            ident = new Identifier(name);
            this.identifiers.put(name, ident);
        }
        return ident;
    }

    static class Identifier
    implements Comparable<Identifier> {
        public String name;
        public Set<Identifier> ingoingDependencies = Generics.newHashSet();
        public Set<Identifier> outgoingDependencies = Generics.newHashSet();
        boolean isClass = false;

        public Identifier(String name) {
            this.name = name;
        }

        public boolean equals(Object obj) {
            return obj != null && obj instanceof Identifier && ((Identifier)obj).name.equals(this.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        @Override
        public int compareTo(Identifier o) {
            return this.name.compareTo(o.name);
        }

        public String toString() {
            return this.name;
        }
    }
}

