/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.loglinear.model;

import edu.stanford.nlp.loglinear.model.ConcatVector;
import edu.stanford.nlp.loglinear.model.ConcatVectorTable;
import edu.stanford.nlp.loglinear.model.proto.GraphicalModelProto;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class GraphicalModel {
    public Map<String, String> modelMetaData = new HashMap<String, String>();
    public List<Map<String, String>> variableMetaData = new ArrayList<Map<String, String>>();
    public Set<Factor> factors = new HashSet<Factor>();

    public Map<String, String> getModelMetaDataByReference() {
        return this.modelMetaData;
    }

    public synchronized Map<String, String> getVariableMetaDataByReference(int variableIndex) {
        while (variableIndex >= this.variableMetaData.size()) {
            this.variableMetaData.add(new HashMap());
        }
        return this.variableMetaData.get(variableIndex);
    }

    public Factor addFactor(int[] neighborIndices, int[] neighborDimensions, Function<int[], ConcatVector> assignmentFeaturizer) {
        ConcatVectorTable features = new ConcatVectorTable(neighborDimensions);
        for (int[] assignment : features) {
            features.setAssignmentValue(assignment, () -> (ConcatVector)assignmentFeaturizer.apply(assignment));
        }
        return this.addFactor(features, neighborIndices);
    }

    public Factor addFactor(ConcatVectorTable featureTable, int[] neighborIndices) {
        assert (featureTable.getDimensions().length == neighborIndices.length);
        Factor factor = new Factor(featureTable, neighborIndices);
        this.factors.add(factor);
        return factor;
    }

    public int[] getVariableSizes() {
        if (this.factors.size() == 0) {
            return new int[0];
        }
        int maxVar = 0;
        for (Factor f : this.factors) {
            for (int n : f.neigborIndices) {
                if (n <= maxVar) continue;
                maxVar = n;
            }
        }
        int[] sizes = new int[maxVar + 1];
        for (int i = 0; i < sizes.length; ++i) {
            sizes[i] = -1;
        }
        for (Factor f : this.factors) {
            for (int i = 0; i < f.neigborIndices.length; ++i) {
                sizes[f.neigborIndices[i]] = f.featuresTable.getDimensions()[i];
            }
        }
        return sizes;
    }

    public void writeToStream(OutputStream stream) throws IOException {
        this.getProtoBuilder().build().writeDelimitedTo(stream);
    }

    public static GraphicalModel readFromStream(InputStream stream) throws IOException {
        return GraphicalModel.readFromProto(GraphicalModelProto.GraphicalModel.parseDelimitedFrom(stream));
    }

    public GraphicalModelProto.GraphicalModel.Builder getProtoBuilder() {
        GraphicalModelProto.GraphicalModel.Builder builder = GraphicalModelProto.GraphicalModel.newBuilder();
        builder.setMetaData(GraphicalModel.getProtoMetaDataBuilder(this.modelMetaData));
        for (Map<String, String> metaData : this.variableMetaData) {
            builder.addVariableMetaData(GraphicalModel.getProtoMetaDataBuilder(metaData));
        }
        for (Factor factor : this.factors) {
            builder.addFactor(factor.getProtoBuilder());
        }
        return builder;
    }

    public static GraphicalModel readFromProto(GraphicalModelProto.GraphicalModel proto) {
        int i;
        if (proto == null) {
            return null;
        }
        GraphicalModel model = new GraphicalModel();
        model.modelMetaData = GraphicalModel.readMetaDataFromProto(proto.getMetaData());
        model.variableMetaData = new ArrayList<Map<String, String>>();
        for (i = 0; i < proto.getVariableMetaDataCount(); ++i) {
            model.variableMetaData.add(GraphicalModel.readMetaDataFromProto(proto.getVariableMetaData(i)));
        }
        for (i = 0; i < proto.getFactorCount(); ++i) {
            model.factors.add(Factor.readFromProto(proto.getFactor(i)));
        }
        return model;
    }

    public boolean valueEquals(GraphicalModel other, double tolerance) {
        if (!this.modelMetaData.equals(other.modelMetaData)) {
            return false;
        }
        if (!this.variableMetaData.equals(other.variableMetaData)) {
            return false;
        }
        HashSet<Factor> remaining = new HashSet<Factor>();
        remaining.addAll(this.factors);
        for (Factor otherFactor : other.factors) {
            Factor match = null;
            for (Factor factor : remaining) {
                if (!factor.valueEquals(otherFactor, tolerance)) continue;
                match = factor;
                break;
            }
            if (match == null) {
                return false;
            }
            remaining.remove(match);
        }
        return remaining.size() <= 0;
    }

    public String toString() {
        String s = "{";
        for (Factor f : this.factors) {
            s = s + "\n\t" + Arrays.toString(f.neigborIndices) + "@" + f;
        }
        s = s + "\n}";
        return s;
    }

    public GraphicalModel cloneModel() {
        GraphicalModel clone = new GraphicalModel();
        clone.modelMetaData.putAll(this.modelMetaData);
        for (int i = 0; i < this.variableMetaData.size(); ++i) {
            if (this.variableMetaData.get(i) == null) continue;
            clone.getVariableMetaDataByReference(i).putAll(this.variableMetaData.get(i));
        }
        for (Factor f : this.factors) {
            clone.factors.add(f.cloneFactor());
        }
        return clone;
    }

    private static GraphicalModelProto.MetaData.Builder getProtoMetaDataBuilder(Map<String, String> metaData) {
        GraphicalModelProto.MetaData.Builder builder = GraphicalModelProto.MetaData.newBuilder();
        for (String key : metaData.keySet()) {
            builder.addKey(key);
            builder.addValue(metaData.get(key));
        }
        return builder;
    }

    private static Map<String, String> readMetaDataFromProto(GraphicalModelProto.MetaData proto) {
        HashMap<String, String> metaData = new HashMap<String, String>();
        for (int i = 0; i < proto.getKeyCount(); ++i) {
            metaData.put(proto.getKey(i), proto.getValue(i));
        }
        return metaData;
    }

    public static class Factor {
        public ConcatVectorTable featuresTable;
        public int[] neigborIndices;
        public Map<String, String> metaData = new HashMap<String, String>();

        private Factor() {
        }

        public Factor(ConcatVectorTable featuresTable, int[] neighborIndices) {
            this.featuresTable = featuresTable;
            this.neigborIndices = neighborIndices;
        }

        public Map<String, String> getMetaDataByReference() {
            return this.metaData;
        }

        public boolean valueEquals(Factor other, double tolerance) {
            return Arrays.equals(this.neigborIndices, other.neigborIndices) && this.metaData.equals(other.metaData) && this.featuresTable.valueEquals(other.featuresTable, tolerance);
        }

        public GraphicalModelProto.Factor.Builder getProtoBuilder() {
            GraphicalModelProto.Factor.Builder builder = GraphicalModelProto.Factor.newBuilder();
            for (int neighbor : this.neigborIndices) {
                builder.addNeighbor(neighbor);
            }
            builder.setFeaturesTable(this.featuresTable.getProtoBuilder());
            builder.setMetaData(GraphicalModel.getProtoMetaDataBuilder(this.metaData));
            return builder;
        }

        public static Factor readFromProto(GraphicalModelProto.Factor proto) {
            Factor factor = new Factor();
            factor.featuresTable = ConcatVectorTable.readFromProto(proto.getFeaturesTable());
            factor.metaData = GraphicalModel.readMetaDataFromProto(proto.getMetaData());
            factor.neigborIndices = new int[proto.getNeighborCount()];
            for (int i = 0; i < factor.neigborIndices.length; ++i) {
                factor.neigborIndices[i] = proto.getNeighbor(i);
            }
            return factor;
        }

        public Factor cloneFactor() {
            Factor clone = new Factor();
            clone.neigborIndices = (int[])this.neigborIndices.clone();
            clone.featuresTable = this.featuresTable.cloneTable();
            clone.metaData.putAll(this.metaData);
            return clone;
        }
    }
}

