/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.loglinear.model;

import com.pholser.junit.quickcheck.ForAll;
import com.pholser.junit.quickcheck.From;
import com.pholser.junit.quickcheck.generator.GenerationStatus;
import com.pholser.junit.quickcheck.generator.Generator;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import edu.stanford.nlp.loglinear.model.ConcatVector;
import edu.stanford.nlp.loglinear.model.ConcatVectorNamespace;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.contrib.theories.Theories;
import org.junit.contrib.theories.Theory;
import org.junit.runner.RunWith;

@RunWith(value=Theories.class)
public class ConcatVectorNamespaceTest {
    @Theory
    public void testResizeOnSetComponent(@ForAll(sampleSize=50) @From(value={MapGenerator.class}) Map<Integer, Integer> featureMap1, @ForAll(sampleSize=50) @From(value={MapGenerator.class}) Map<Integer, Integer> featureMap2) {
        ConcatVectorNamespace namespace = new ConcatVectorNamespace();
        ConcatVector namespace1 = this.toNamespaceVector(namespace, featureMap1);
        ConcatVector namespace2 = this.toNamespaceVector(namespace, featureMap2);
        ConcatVector regular1 = this.toVector(featureMap1);
        ConcatVector regular2 = this.toVector(featureMap2);
        Assert.assertEquals((double)regular1.dotProduct(regular2), (double)namespace1.dotProduct(namespace2), (double)1.0E-5);
        ConcatVector namespaceSum = namespace1.deepClone();
        namespaceSum.addVectorInPlace(namespace2, 1.0);
        ConcatVector regularSum = regular1.deepClone();
        regularSum.addVectorInPlace(regular2, 1.0);
        Assert.assertEquals((double)regular1.dotProduct(regularSum), (double)namespace1.dotProduct(namespaceSum), (double)1.0E-5);
        Assert.assertEquals((double)regularSum.dotProduct(regular2), (double)namespaceSum.dotProduct(namespace2), (double)1.0E-5);
    }

    public ConcatVector toNamespaceVector(ConcatVectorNamespace namespace, Map<Integer, Integer> featureMap) {
        ConcatVector newVector = namespace.newVector();
        for (int i : featureMap.keySet()) {
            String feature = "feat" + i;
            String sparse = "index" + featureMap.get(i);
            namespace.setSparseFeature(newVector, feature, sparse, 1.0);
        }
        return newVector;
    }

    public ConcatVector toVector(Map<Integer, Integer> featureMap) {
        ConcatVector vector = new ConcatVector(20);
        for (int i : featureMap.keySet()) {
            vector.setSparseComponent(i, featureMap.get(i), 1.0);
        }
        return vector;
    }

    public static class MapGenerator
    extends Generator<Map<Integer, Integer>> {
        public MapGenerator(Class<Map<Integer, Integer>> type) {
            super(type);
        }

        public Map<Integer, Integer> generate(SourceOfRandomness sourceOfRandomness, GenerationStatus generationStatus) {
            int numFeatures = sourceOfRandomness.nextInt(1, 15);
            HashMap<Integer, Integer> featureMap = new HashMap<Integer, Integer>();
            for (int i = 0; i < numFeatures; ++i) {
                int featureValue = sourceOfRandomness.nextInt(20);
                while (featureMap.containsKey(featureValue)) {
                    featureValue = sourceOfRandomness.nextInt(20);
                }
                featureMap.put(featureValue, sourceOfRandomness.nextInt(2));
            }
            return featureMap;
        }
    }
}

