/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ling.tokensregex.demo;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.tokensregex.MultiPatternMatcher;
import edu.stanford.nlp.ling.tokensregex.SequenceMatchResult;
import edu.stanford.nlp.ling.tokensregex.TokenSequencePattern;
import edu.stanford.nlp.objectbank.ObjectBank;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.PropertiesUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class TokensRegexMatcher {
    private TokensRegexMatcher() {
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 2) {
            System.err.println("TokensRegexMatcher rules file [outFile]");
            return;
        }
        String rules = args[0];
        PrintWriter out2 = args.length > 2 ? new PrintWriter(args[2]) : new PrintWriter(System.out);
        StanfordCoreNLP pipeline = new StanfordCoreNLP(PropertiesUtils.asProperties("annotators", "tokenize,ssplit,pos,lemma,ner"));
        Annotation annotation = new Annotation(IOUtils.slurpFileNoExceptions(args[1]));
        pipeline.annotate(annotation);
        ArrayList<TokenSequencePattern> tokenSequencePatterns = new ArrayList<TokenSequencePattern>();
        for (String line : ObjectBank.getLineIterator(rules)) {
            TokenSequencePattern pattern = TokenSequencePattern.compile(line);
            tokenSequencePatterns.add(pattern);
        }
        List sentences = (List)annotation.get(CoreAnnotations.SentencesAnnotation.class);
        int i = 0;
        for (CoreMap sentence : sentences) {
            List tokens = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
            out2.println("Sentence #" + ++i);
            out2.print("  Tokens:");
            for (CoreLabel token : tokens) {
                out2.print(' ');
                out2.print(token.toShortString("Text", "PartOfSpeech", "NamedEntityTag"));
            }
            out2.println();
            MultiPatternMatcher<CoreMap> multiMatcher = TokenSequencePattern.getMultiPatternMatcher(tokenSequencePatterns);
            List<SequenceMatchResult<CoreMap>> answers = multiMatcher.findNonOverlapping(tokens);
            int j = 0;
            for (SequenceMatchResult<CoreMap> matched : answers) {
                out2.println("  Match #" + ++j);
                for (int k = 0; k <= matched.groupCount(); ++k) {
                    out2.println("    group " + k + " = " + matched.group(k));
                }
            }
        }
        out2.flush();
    }
}

