/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ling;

import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.SentenceUtils;
import edu.stanford.nlp.ling.TaggedWord;
import edu.stanford.nlp.simple.Sentence;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SentenceTest {
    private static final String[] words = new String[]{"This", "is", "a", "test", "."};
    private static final String[] tags = new String[]{"A", "B", "C", "D", "E"};
    private static final String expectedValueOnly = "This is a test .";
    private static final String expectedTagged = "This_A is_B a_C test_D ._E";
    private static final String separator = "_";

    @Before
    public void setUp() {
        Assert.assertEquals((long)words.length, (long)tags.length);
    }

    @Test
    public void testCoreLabelListToString() {
        ArrayList<CoreLabel> clWords = new ArrayList<CoreLabel>();
        ArrayList<CoreLabel> clValues = new ArrayList<CoreLabel>();
        ArrayList<CoreLabel> clWordTags = new ArrayList<CoreLabel>();
        ArrayList<CoreLabel> clValueTags = new ArrayList<CoreLabel>();
        for (int i = 0; i < words.length; ++i) {
            CoreLabel cl = new CoreLabel();
            cl.setWord(words[i]);
            clWords.add(cl);
            cl = new CoreLabel();
            cl.setValue(words[i]);
            clValues.add(cl);
            cl = new CoreLabel();
            cl.setWord(words[i]);
            cl.setTag(tags[i]);
            clWordTags.add(cl);
            cl = new CoreLabel();
            cl.setValue(words[i]);
            cl.setTag(tags[i]);
            clValueTags.add(cl);
        }
        Assert.assertEquals((Object)expectedValueOnly, (Object)SentenceUtils.listToString(clWords, true));
        Assert.assertEquals((Object)expectedValueOnly, (Object)SentenceUtils.listToString(clValues, true));
        Assert.assertEquals((Object)expectedTagged, (Object)SentenceUtils.listToString(clWordTags, false, separator));
        Assert.assertEquals((Object)expectedTagged, (Object)SentenceUtils.listToString(clValueTags, false, separator));
    }

    @Test
    public void testTaggedWordListToString() {
        ArrayList<TaggedWord> tagged = new ArrayList<TaggedWord>();
        for (int i = 0; i < words.length; ++i) {
            tagged.add(new TaggedWord(words[i], tags[i]));
        }
        Assert.assertEquals((Object)expectedValueOnly, (Object)SentenceUtils.listToString(tagged, true));
        Assert.assertEquals((Object)expectedTagged, (Object)SentenceUtils.listToString(tagged, false, separator));
    }

    @Test
    public void testTokenizedSentenceSize() {
        String text = "one two three four five";
        byte[] sentenceArray = new Sentence(text).serialize().toByteArray();
        byte[] textArray = text.getBytes();
        Assert.assertTrue((String)String.format("Sentence size (%d bytes) shouldn't be more than %d times bigger than text size (%d bytes)", sentenceArray.length, 11, textArray.length), (sentenceArray.length < textArray.length * 11 ? 1 : 0) != 0);
    }
}

