/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ling;

import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.ling.Label;
import org.junit.Assert;
import org.junit.Test;

public class IndexedWordTest {
    @Test
    public void testIndexedWordComparisons() {
        CoreLabel cl;
        CoreLabel l = cl = CoreLabel.wordFromString("fiddle");
        IndexedWord iw1 = new IndexedWord(cl);
        IndexedWord iw2 = new IndexedWord((Label)l);
        IndexedWord iw3 = new IndexedWord("test", 1, 3);
        iw3.setWord("fiddle");
        IndexedWord iw4 = IndexedWord.NO_WORD;
        IndexedWord iw5 = new IndexedWord("test", 1, 1);
        iw5.setWord("earlier");
        IndexedWord iw6 = new IndexedWord("test", 1, 3);
        iw6.setWord("different");
        Assert.assertEquals((Object)l, (Object)cl);
        Assert.assertEquals((Object)cl, (Object)iw1.backingLabel());
        Assert.assertEquals((Object)cl, (Object)iw2.backingLabel());
        Assert.assertEquals((Object)iw1, (Object)iw2);
        Assert.assertEquals((Object)iw1.word(), (Object)iw3.word());
        Assert.assertEquals((long)0L, (long)iw1.compareTo(iw2));
        Assert.assertEquals((Object)iw3, (Object)iw6);
        Assert.assertTrue((iw4.compareTo(iw3) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((iw3.compareTo(iw4) > 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)iw6, (Object)iw3);
        Assert.assertTrue((iw3.compareTo(iw5) > 0 ? 1 : 0) != 0);
    }
}

