/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.international.spanish;

import edu.stanford.nlp.international.spanish.SpanishVerbStripper;
import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;

public class SpanishVerbStripperITest
extends TestCase {
    private final SpanishVerbStripper verbStripper = SpanishVerbStripper.getInstance();

    public static void testStrippable() {
        SpanishVerbStripperITest.assertTrue((boolean)SpanishVerbStripper.isStrippable("decirme"));
        SpanishVerbStripperITest.assertTrue((boolean)SpanishVerbStripper.isStrippable("decirnos"));
        SpanishVerbStripperITest.assertTrue((boolean)SpanishVerbStripper.isStrippable("jugarles"));
        SpanishVerbStripperITest.assertTrue((boolean)SpanishVerbStripper.isStrippable("mandarlos"));
        SpanishVerbStripperITest.assertTrue((boolean)SpanishVerbStripper.isStrippable("leerlo"));
        SpanishVerbStripperITest.assertTrue((boolean)SpanishVerbStripper.isStrippable("jugarla"));
        SpanishVerbStripperITest.assertTrue((boolean)SpanishVerbStripper.isStrippable("jug\u00e1rselos"));
        SpanishVerbStripperITest.assertTrue((boolean)SpanishVerbStripper.isStrippable("dec\u00edrmelo"));
        SpanishVerbStripperITest.assertTrue((boolean)SpanishVerbStripper.isStrippable("cont\u00e1ndolo"));
        SpanishVerbStripperITest.assertTrue((boolean)SpanishVerbStripper.isStrippable("y\u00e9ndole"));
        SpanishVerbStripperITest.assertTrue((boolean)SpanishVerbStripper.isStrippable("vivi\u00e9ndolo"));
        SpanishVerbStripperITest.assertTrue((boolean)SpanishVerbStripper.isStrippable("ley\u00e9ndolo"));
        SpanishVerbStripperITest.assertTrue((boolean)SpanishVerbStripper.isStrippable("busc\u00e1ndome"));
        SpanishVerbStripperITest.assertTrue((boolean)SpanishVerbStripper.isStrippable("sentaos"));
        SpanishVerbStripperITest.assertTrue((boolean)SpanishVerbStripper.isStrippable("vest\u00edos"));
        SpanishVerbStripperITest.assertTrue((boolean)SpanishVerbStripper.isStrippable("c\u00f3mprelos"));
        SpanishVerbStripperITest.assertTrue((boolean)SpanishVerbStripper.isStrippable("h\u00e1zmelo"));
        SpanishVerbStripperITest.assertTrue((boolean)SpanishVerbStripper.isStrippable("sent\u00e9monos"));
        SpanishVerbStripperITest.assertTrue((boolean)SpanishVerbStripper.isStrippable("escrib\u00e1mosela"));
        SpanishVerbStripperITest.assertTrue((boolean)SpanishVerbStripper.isStrippable("ponerlos"));
    }

    private void checkPronouns(String word, String originalStem, String normalizedStem, String ... pronouns) {
        if (pronouns.length == 0) {
            SpanishVerbStripperITest.assertNull((Object)this.verbStripper.separatePronouns(word));
        } else {
            List<String> pronounList = Arrays.asList(pronouns);
            SpanishVerbStripper.StrippedVerb result = this.verbStripper.separatePronouns(word);
            SpanishVerbStripperITest.assertEquals((String)originalStem, (String)result.getOriginalStem());
            SpanishVerbStripperITest.assertEquals((String)normalizedStem, (String)result.getStem());
            SpanishVerbStripperITest.assertEquals(pronounList, result.getPronouns());
        }
    }

    public void testSeparatePronouns() {
        this.checkPronouns("decirme", "decir", "decir", "me");
        this.checkPronouns("Decirme", "Decir", "Decir", "me");
        this.checkPronouns("cont\u00e1ndoselo", "cont\u00e1ndo", "contando", "se", "lo");
        this.checkPronouns("aplic\u00e1rseles", "aplic\u00e1r", "aplicar", "se", "les");
        this.checkPronouns("sentados", null, null, new String[0]);
        this.checkPronouns("sentaos", "senta", "sentad", "os");
        this.checkPronouns("damelo", "da", "da", "me", "lo");
        this.checkPronouns("Imag\u00ednense", "Imag\u00ednen", "Imaginen", "se");
        this.checkPronouns("v\u00e1monos", "v\u00e1mo", "vamos", "nos");
        this.checkPronouns("escrib\u00e1mosela", "escrib\u00e1mo", "escribamos", "se", "la");
        this.checkPronouns("c\u00edmbalo", null, null, new String[0]);
        this.checkPronouns("contando", null, null, new String[0]);
        this.checkPronouns("salos", null, null, new String[0]);
    }

    public void testStripVerb() {
        SpanishVerbStripperITest.assertEquals((String)"decir", (String)this.verbStripper.stripVerb("decirme"));
        SpanishVerbStripperITest.assertEquals((String)"decir", (String)this.verbStripper.stripVerb("decirnos"));
        SpanishVerbStripperITest.assertEquals((String)"jugar", (String)this.verbStripper.stripVerb("jugarles"));
        SpanishVerbStripperITest.assertEquals((String)"mandar", (String)this.verbStripper.stripVerb("mandarlos"));
        SpanishVerbStripperITest.assertEquals((String)"leer", (String)this.verbStripper.stripVerb("leerlo"));
        SpanishVerbStripperITest.assertEquals((String)"jugar", (String)this.verbStripper.stripVerb("jugarla"));
        SpanishVerbStripperITest.assertEquals((String)"jugar", (String)this.verbStripper.stripVerb("jug\u00e1rselos"));
        SpanishVerbStripperITest.assertEquals((String)"jugar", (String)this.verbStripper.stripVerb("jugaros"));
        SpanishVerbStripperITest.assertEquals((String)"decir", (String)this.verbStripper.stripVerb("dec\u00edrmelo"));
        SpanishVerbStripperITest.assertEquals((String)"contando", (String)this.verbStripper.stripVerb("cont\u00e1ndolo"));
        SpanishVerbStripperITest.assertEquals((String)"yendo", (String)this.verbStripper.stripVerb("y\u00e9ndole"));
        SpanishVerbStripperITest.assertEquals((String)"viviendo", (String)this.verbStripper.stripVerb("vivi\u00e9ndolo"));
        SpanishVerbStripperITest.assertEquals((String)"leyendo", (String)this.verbStripper.stripVerb("ley\u00e9ndolo"));
        SpanishVerbStripperITest.assertEquals((String)"buscando", (String)this.verbStripper.stripVerb("busc\u00e1ndome"));
        SpanishVerbStripperITest.assertEquals((String)"sentad", (String)this.verbStripper.stripVerb("sentaos"));
        SpanishVerbStripperITest.assertEquals((String)"vestid", (String)this.verbStripper.stripVerb("vest\u00edos"));
        SpanishVerbStripperITest.assertEquals((String)"compre", (String)this.verbStripper.stripVerb("c\u00f3mprelos"));
        SpanishVerbStripperITest.assertEquals((String)"haz", (String)this.verbStripper.stripVerb("h\u00e1zmelo"));
        SpanishVerbStripperITest.assertEquals((String)"o\u00edr", (String)this.verbStripper.stripVerb("o\u00edrse"));
        SpanishVerbStripperITest.assertEquals((String)"escribamos", (String)this.verbStripper.stripVerb("escrib\u00e1mosela"));
        SpanishVerbStripperITest.assertEquals((String)"sentemos", (String)this.verbStripper.stripVerb("sent\u00e9monos"));
        SpanishVerbStripperITest.assertEquals((String)"haber", (String)this.verbStripper.stripVerb("haberlo"));
        SpanishVerbStripperITest.assertEquals((String)"poner", (String)this.verbStripper.stripVerb("ponerlos"));
    }
}

