/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.international.french.scripts;

import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeReader;
import edu.stanford.nlp.trees.international.french.FrenchTreeReaderFactory;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;

public final class MungeTreesWithMorfetteAnalyses {
    private static Redwood.RedwoodChannels log = Redwood.channels(MungeTreesWithMorfetteAnalyses.class);
    private static final Pattern pIsPunct = Pattern.compile("\\p{Punct}+");
    private static final Pattern pAllUpper = Pattern.compile("\\p{Upper}+");

    public static void main(String[] args) {
        if (args.length != 2) {
            System.err.printf("Usage: java %s tree_file morfette_tnt_file%n", MungeTreesWithMorfetteAnalyses.class.getName());
            System.exit(-1);
        }
        String treeFile = args[0];
        String morfetteFile = args[1];
        FrenchTreeReaderFactory trf = new FrenchTreeReaderFactory();
        try {
            Tree tree;
            TreeReader tr = trf.newTreeReader(new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(treeFile), "UTF-8")));
            MorfetteFileIterator morfetteItr = new MorfetteFileIterator(morfetteFile);
            while ((tree = tr.readTree()) != null && morfetteItr.hasNext()) {
                List analysis = (List)morfetteItr.next();
                ArrayList<Label> yield = tree.yield();
                assert (analysis.size() == yield.size());
                int yieldLen = yield.size();
                for (int i = 0; i < yieldLen; ++i) {
                    CoreLabel tokenAnalysis = (CoreLabel)analysis.get(i);
                    Label token = (Label)yield.get(i);
                    String lemma = MungeTreesWithMorfetteAnalyses.getLemma(token.value(), tokenAnalysis.lemma());
                    String newLeaf = String.format("%s%s%s%s%s", token.value(), "~#", lemma, "|||", tokenAnalysis.tag());
                    ((CoreLabel)token).setValue(newLeaf);
                }
                System.out.println(tree.toString());
            }
            if (tr.readTree() != null || morfetteItr.hasNext()) {
                log.info("WARNING: Uneven input files!");
            }
            tr.close();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static String getLemma(String rawToken, String lemma) {
        boolean isUpper = Character.isUpperCase(rawToken.charAt(0));
        boolean isAllUpper = pAllUpper.matcher(rawToken).matches();
        boolean isParen = rawToken.equals("-RRB-") || rawToken.equals("-LRB-");
        boolean isPunc = pIsPunct.matcher(rawToken).matches();
        if (isParen || isPunc || isAllUpper) {
            return rawToken;
        }
        if (isUpper) {
            Character firstChar = Character.valueOf(Character.toUpperCase(lemma.charAt(0)));
            lemma = firstChar + lemma.substring(1, lemma.length());
        }
        return lemma;
    }

    private static class MorfetteFileIterator
    implements Iterator<List<CoreLabel>> {
        private BufferedReader reader;
        private List<CoreLabel> nextList;
        private int lineId = 0;

        public MorfetteFileIterator(String filename) {
            try {
                this.reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), "UTF-8"));
                this.primeNext();
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }

        private void primeNext() {
            try {
                String line;
                this.nextList = new ArrayList<CoreLabel>(40);
                while ((line = this.reader.readLine()) != null) {
                    if ((line = line.trim()).equals("")) {
                        ++this.lineId;
                        break;
                    }
                    String[] toks = line.split("\\s+");
                    if (toks.length != 3) {
                        log.info(toks.length);
                        log.info(line);
                        log.info(this.lineId);
                        throw new RuntimeException(String.format("line %d: Morfette format is |word lemma tag|: |%s|", this.lineId, line));
                    }
                    CoreLabel cl = new CoreLabel();
                    String word = toks[0];
                    String lemma = toks[1];
                    String tag = toks[2];
                    cl.setWord(word);
                    cl.setValue(word);
                    cl.setLemma(lemma);
                    cl.setTag(tag);
                    this.nextList.add(cl);
                    ++this.lineId;
                }
                if (this.nextList.size() == 0) {
                    this.reader.close();
                    this.nextList = null;
                }
            }
            catch (IOException e) {
                System.err.printf("Problem reading file at line %d%n", this.lineId);
                e.printStackTrace();
                this.nextList = null;
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextList != null;
        }

        @Override
        public List<CoreLabel> next() {
            if (this.hasNext()) {
                List<CoreLabel> next = this.nextList;
                this.primeNext();
                return next;
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

