/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie.qe;

import edu.stanford.nlp.ie.qe.Unit;
import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.ling.tokensregex.Env;
import edu.stanford.nlp.util.ErasureUtils;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.BufferedReader;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class Units {
    public static void registerDerivedUnit(Env env, Class clazz, String derivedType, String suffix, String symbolSuffix) {
        Field[] fields;
        for (Field field : fields = clazz.getDeclaredFields()) {
            boolean isStatic = Modifier.isStatic(field.getModifiers());
            boolean isUnit = Unit.class.isAssignableFrom(field.getType());
            if (!isStatic || !isUnit) continue;
            try {
                Unit unit = (Unit)ErasureUtils.uncheckedCast(field.get(null));
                Units.registerDerivedUnit(env, unit, derivedType, suffix, symbolSuffix);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    public static void registerDerivedUnit(Env env, Unit unit, String derivedType, String suffix, String symbolSuffix) {
        Unit derivedUnit = new Unit(unit.getName() + " " + suffix, unit.getSymbol() + symbolSuffix, derivedType);
        env.bind(derivedType + "_" + unit.getName().toUpperCase() + "_" + suffix.toUpperCase(), derivedUnit);
    }

    public static void registerUnit(Env env, Class clazz) {
        Field[] fields;
        for (Field field : fields = clazz.getDeclaredFields()) {
            boolean isStatic = Modifier.isStatic(field.getModifiers());
            boolean isUnit = Unit.class.isAssignableFrom(field.getType());
            if (!isStatic || !isUnit) continue;
            try {
                Unit unit = (Unit)ErasureUtils.uncheckedCast(field.get(null));
                Units.registerUnit(env, unit);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    public static void registerUnit(Env env, Unit unit) {
        env.bind((unit.getType() + "_" + unit.getName()).toUpperCase(), unit);
    }

    public static void registerUnits(Env env, String filename) throws IOException {
        List<Unit> units = Units.loadUnits(filename);
        Units.registerUnits(env, units);
        Units.registerUnit(env, Currencies.class);
    }

    public static void registerUnits(Env env, List<Unit> units) {
        for (Unit unit : units) {
            Units.registerUnit(env, unit);
            if (!"LENGTH".equals(unit.getType())) continue;
            Units.registerDerivedUnit(env, unit, "AREA", "2", "2");
            Units.registerDerivedUnit(env, unit, "VOLUME", "3", "3");
        }
    }

    public static List<Unit> loadUnits(String filename) throws IOException {
        String line;
        Pattern commaPattern = Pattern.compile("\\s*,\\s*");
        BufferedReader br = IOUtils.getBufferedFileReader(filename);
        String headerString = br.readLine();
        String[] header = commaPattern.split(headerString);
        HashMap<String, Integer> headerIndex = new HashMap<String, Integer>();
        for (int i = 0; i < header.length; ++i) {
            headerIndex.put(header[i], i);
        }
        int iName = (Integer)headerIndex.get("unit");
        int iPrefix = (Integer)headerIndex.get("prefix");
        int iSymbol = (Integer)headerIndex.get("symbol");
        int iType = (Integer)headerIndex.get("type");
        int iSystem = (Integer)headerIndex.get("system");
        int iDefaultUnit = (Integer)headerIndex.get("defaultUnit");
        int iDefaultUnitScale = (Integer)headerIndex.get("defaultUnitScale");
        ArrayList<Unit> list = new ArrayList<Unit>();
        HashMap<String, Unit> unitsByName = new HashMap<String, Unit>();
        HashMap<String, Pair<String, Double>> unitToDefaultUnits = new HashMap<String, Pair<String, Double>>();
        while ((line = br.readLine()) != null) {
            String[] fields = commaPattern.split(line);
            Unit unit = new Unit(fields[iName], fields[iSymbol], fields[iType].toUpperCase());
            unit.system = fields[iSystem];
            if (fields.length > iPrefix) {
                unit.prefixSystem = fields[iPrefix];
            }
            if (fields.length > iDefaultUnit) {
                double scale = 1.0;
                if (fields.length > iDefaultUnitScale) {
                    scale = Double.parseDouble(fields[iDefaultUnitScale]);
                }
                unitToDefaultUnits.put(unit.getName(), Pair.makePair(fields[iDefaultUnit], scale));
            }
            unitsByName.put(unit.getName(), unit);
            list.add(unit);
        }
        for (Map.Entry entry : unitToDefaultUnits.entrySet()) {
            Unit unit = (Unit)unitsByName.get(entry.getKey());
            Unit defaultUnit = (Unit)unitsByName.get(((Pair)entry.getValue()).first);
            if (defaultUnit != null) {
                unit.defaultUnit = defaultUnit;
                unit.defaultUnitScale = (Double)((Pair)entry.getValue()).second;
                continue;
            }
            Redwood.Util.warn("Unknown default unit " + (String)((Pair)entry.getValue()).first + " for " + (String)entry.getKey());
        }
        br.close();
        return list;
    }

    public static class Currencies {
        public static final Unit DOLLAR = new MoneyUnit("dollar", "$");
        public static final Unit CENT = new MoneyUnit("cent", "\u00a2", DOLLAR, 0.01);
        public static final Unit POUND = new MoneyUnit("pound", "\u00a3");
        public static final Unit PENNY = new MoneyUnit("penny", "\u00a2", DOLLAR, 0.01);
        public static final Unit EURO = new MoneyUnit("euro", "\u00ac");
        public static final Unit YEN = new MoneyUnit("yen", "\u00a5");
        public static final Unit YUAN = new MoneyUnit("yuan", "\u5143");
        public static final Unit WON = new MoneyUnit("won", "\u20a9");

        private Currencies() {
        }
    }

    public static class MoneyUnit
    extends Unit {
        public static final String TYPE = "MONEY";

        public MoneyUnit(String name, String symbol) {
            super(name, symbol, TYPE);
        }

        public MoneyUnit(String name, String symbol, Unit defaultUnit, double defaultUnitScale) {
            super(name, symbol, TYPE, defaultUnit, defaultUnitScale);
        }

        @Override
        public String format(double amount) {
            return this.symbol + String.format("%.2f", amount);
        }
    }
}

