/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie.machinereading.domains.roth;

import edu.stanford.nlp.ie.machinereading.MachineReading;
import edu.stanford.nlp.ie.machinereading.MachineReadingProperties;
import edu.stanford.nlp.ie.machinereading.RelationFeatureFactory;
import edu.stanford.nlp.ie.machinereading.ResultsPrinter;
import edu.stanford.nlp.ie.machinereading.structure.AnnotationUtils;
import edu.stanford.nlp.ie.machinereading.structure.RelationMention;
import edu.stanford.nlp.ie.machinereading.structure.RelationMentionFactory;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Pair;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class RothResultsByRelation
extends ResultsPrinter {
    private RelationFeatureFactory featureFactory;
    private RelationMentionFactory mentionFactory;

    @Override
    public void printResults(PrintWriter pw, List<CoreMap> goldStandard, List<CoreMap> extractorOutput) {
        this.featureFactory = MachineReading.makeRelationFeatureFactory(MachineReadingProperties.relationFeatureFactoryClass, MachineReadingProperties.relationFeatures, false);
        this.mentionFactory = new RelationMentionFactory();
        ResultsPrinter.align(goldStandard, extractorOutput);
        ArrayList relations = new ArrayList();
        final HashMap<RelationMention, String> predictions = new HashMap<RelationMention, String>();
        for (int i = 0; i < goldStandard.size(); ++i) {
            List<RelationMention> goldRelations = AnnotationUtils.getAllRelations(this.mentionFactory, goldStandard.get(i), true);
            relations.addAll(goldRelations);
            Iterator iterator = goldRelations.iterator();
            while (iterator.hasNext()) {
                RelationMention rel = (RelationMention)iterator.next();
                predictions.put(rel, AnnotationUtils.getRelation(this.mentionFactory, extractorOutput.get(i), rel.getArg(0), rel.getArg(1)).getType());
            }
        }
        final ClassicCounter<Pair<Pair<String, String>, String>> pathCounts = new ClassicCounter<Pair<Pair<String, String>, String>>();
        for (RelationMention rel : relations) {
            pathCounts.incrementCount(new Pair<Pair<String, String>, String>(new Pair<String, String>(rel.getArg(0).getType(), rel.getArg(1).getType()), this.featureFactory.getFeature(rel, "dependency_path_lowlevel")));
        }
        ClassicCounter<String> singletonCorrect = new ClassicCounter<String>();
        ClassicCounter<String> singletonPredicted = new ClassicCounter<String>();
        ClassicCounter<String> singletonActual = new ClassicCounter<String>();
        for (RelationMention rel : relations) {
            if (pathCounts.getCount(new Pair<Pair<String, String>, String>(new Pair<String, String>(rel.getArg(0).getType(), rel.getArg(1).getType()), this.featureFactory.getFeature(rel, "dependency_path_lowlevel"))) != 1.0) continue;
            String prediction = (String)predictions.get(rel);
            if (prediction.equals(rel.getType())) {
                singletonCorrect.incrementCount(prediction);
            }
            singletonPredicted.incrementCount(prediction);
            singletonActual.incrementCount(rel.getType());
        }
        class RelComp
        implements Comparator<RelationMention> {
            RelComp() {
            }

            @Override
            public int compare(RelationMention rel1, RelationMention rel2) {
                String prediction1 = (String)predictions.get(rel1);
                String prediction2 = (String)predictions.get(rel2);
                int entComp = (rel1.getArg(0).getType() + rel1.getArg(1).getType()).compareTo(rel2.getArg(0).getType() + rel2.getArg(1).getType());
                int typeComp = rel1.getType().compareTo(rel2.getType());
                int predictionComp = prediction1.compareTo(prediction2);
                double pathCount1 = pathCounts.getCount(new Pair<Pair<String, String>, String>(new Pair<String, String>(rel1.getArg(0).getType(), rel1.getArg(1).getType()), RothResultsByRelation.this.featureFactory.getFeature(rel1, "dependency_path_lowlevel")));
                double pathCount2 = pathCounts.getCount(new Pair<Pair<String, String>, String>(new Pair<String, String>(rel2.getArg(0).getType(), rel2.getArg(1).getType()), RothResultsByRelation.this.featureFactory.getFeature(rel2, "dependency_path_lowlevel")));
                if (entComp != 0) {
                    return entComp;
                }
                if (pathCount1 < pathCount2) {
                    return -1;
                }
                if (pathCount1 > pathCount2) {
                    return 1;
                }
                if (typeComp != 0) {
                    return typeComp;
                }
                if (predictionComp != 0) {
                    return predictionComp;
                }
                return ((String)rel1.getSentence().get(CoreAnnotations.TextAnnotation.class)).compareTo((String)rel2.getSentence().get(CoreAnnotations.TextAnnotation.class));
            }
        }
        RelComp relComp = new RelComp();
        Collections.sort(relations, relComp);
        for (RelationMention rel : relations) {
            String prediction = (String)predictions.get(rel);
            String type1 = rel.getArg(0).getType();
            String type2 = rel.getArg(1).getType();
            String path = this.featureFactory.getFeature(rel, "dependency_path_lowlevel");
            if (!((type1.equals("PEOPLE") && type2.equals("PEOPLE") || type1.equals("PEOPLE") && type2.equals("LOCATION") || type1.equals("LOCATION") && type2.equals("LOCATION") || type1.equals("ORGANIZATION") && type2.equals("LOCATION") || type1.equals("PEOPLE") && type2.equals("ORGANIZATION")) && !path.equals(""))) continue;
            pw.println("\nLABEL: " + prediction);
            pw.println(rel);
            pw.println(path);
            pw.println(this.featureFactory.getFeatures(rel, "dependency_path_words"));
            pw.println(this.featureFactory.getFeature(rel, "surface_path_POS"));
        }
    }

    @Override
    public void printResultsUsingLabels(PrintWriter pw, List<String> goldStandard, List<String> extractorOutput) {
    }
}

