/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie.crf;

import edu.stanford.nlp.ie.crf.TestThreadedCRFClassifier;
import java.util.Properties;
import junit.framework.TestCase;

public class ThreadedSegmenterITest
extends TestCase {
    Properties props;
    static final String crf1 = "/u/nlp/data/gale/segtool/stanford-seg/classifiers-2010/pk-chris6.lex.gz";
    static final String crf2 = "/u/nlp/data/gale/segtool/stanford-seg/classifiers-2010/05202008-ctb6.processed-chris6.lex.gz";

    public void setUp() {
        this.props = new Properties();
        this.props.setProperty("sighanCorporaDict", "/u/nlp/data/gale/segtool/stanford-seg/data");
        this.props.setProperty("testFile", "/u/nlp/segtool/stanford-seg/data/Sighan2006/CTB_train_test/test/CTB.utf8.simp");
        this.props.setProperty("inputEncoding", "utf-8");
        this.props.setProperty("sighanPostProcessing", "true");
        this.props.setProperty("serDictionary", "/u/nlp/data/gale/segtool/stanford-seg/classifiers/dict-chris6.ser.gz");
        this.props.setProperty("keepAllWhitespaces", "false");
    }

    public void testPkuCRF() {
        System.out.println("Testing PKU segmenter");
        System.out.println("=====================");
        this.props.setProperty("crf1", crf1);
        TestThreadedCRFClassifier.runTest(this.props);
    }

    public void testCtbCRF() {
        System.out.println("Testing CTB segmenter");
        System.out.println("=====================");
        this.props.setProperty("crf1", crf2);
        TestThreadedCRFClassifier.runTest(this.props);
    }

    public void testTwoCRFs() {
        System.out.println("Testing two segmenters");
        System.out.println("======================");
        this.props.setProperty("crf1", crf1);
        this.props.setProperty("crf2", crf2);
        TestThreadedCRFClassifier.runTest(this.props);
    }
}

