/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie;

import edu.stanford.nlp.ie.QuantifiableEntityNormalizer;
import junit.framework.TestCase;

public class QuantifiableEntityNormalizerTest
extends TestCase {
    private String[] dateStrings = new String[]{"February 5, 1923", "Mar 3", "18 July 2005", "18 Sep 05", "Jan. 13 , '90", "Jan. 13", "2009-07-19", "2007-06-16"};
    private String[] dateAnswers = new String[]{"19230205", "****0303", "20050718", "20050918", "19900113", "****0113", "20090719", "20070616"};
    private String[] percentStrings = new String[]{"one percent", "% 8", "8 %", "8.25 %", "48 percent", "%4.9"};
    private String[] percentAnswers = new String[]{"%1.0", "%8.0", "%8.0", "%8.25", "%48.0", "%4.9"};
    private String[] moneyStrings = new String[]{"24 cents", "18\u00a2", "250 won", "\u00a35.40", "10 thousand million pounds", "10 thousand million dollars", "million dollars", "four million dollars", "$1m", "50 million yuan", "50 cents", "# 1500", "\u00a3 1500", "\u00a3 .50", "# .50", "$ 1500", "$1500", "$ 1,500", "$1,500", "$48.75", "$ 57 . 60", "2.30", "8 million", "$8 thousand", "$42,33"};
    private String[] moneyAnswers = new String[]{"$0.24", "$0.18", "\u20a9250.0", "\u00a35.4", "\u00a31.0E10", "$1.0E10", "$1000000.0", "$4000000.0", "$1000000.0", "\u51435.0E7", "$0.5", "\u00a31500.0", "\u00a31500.0", "\u00a30.5", "\u00a30.5", "$1500.0", "$1500.0", "$1500.0", "$1500.0", "$48.75", "$57.6", "$2.3", "$8000000.0", "$8000.0", "$42.33"};
    private String[] numberStrings = new String[]{"twenty-five", "1.3 million", "10 thousand million", "3.625", "-15", "117-111", "", " ", "   "};
    private String[] numberAnswers = new String[]{"25.0", "1300000.0", "1.0E10", "3.625", "-15.0", "117.0 - 111.0", "", " ", "   "};
    private String[] ordinalStrings = new String[]{"twelfth", "twenty-second", "0th", "1,000th"};
    private String[] ordinalAnswers = new String[]{"12.0", "22.0", "0.0", "1000.0"};
    private String[] timeStrings = new String[]{"4:30", "11:00 pm", "2 am", "12:29 p.m.", "midnight", "22:26:48"};
    private String[] timeAnswers = new String[]{"4:30", "11:00pm", "2:00am", "12:29pm", "00:00am", "22:26:48"};

    public void testDateNormalization() {
        QuantifiableEntityNormalizerTest.assertEquals((int)this.dateStrings.length, (int)this.dateAnswers.length);
        for (int i = 0; i < this.dateStrings.length; ++i) {
            QuantifiableEntityNormalizerTest.assertEquals((String)("Testing " + this.dateStrings[i]), (String)this.dateAnswers[i], (String)QuantifiableEntityNormalizer.normalizedDateString(this.dateStrings[i], null));
        }
    }

    public void testPercentNormalization() {
        QuantifiableEntityNormalizerTest.assertEquals((int)this.percentStrings.length, (int)this.percentAnswers.length);
        for (int i = 0; i < this.percentStrings.length; ++i) {
            QuantifiableEntityNormalizerTest.assertEquals((String)this.percentAnswers[i], (String)QuantifiableEntityNormalizer.normalizedPercentString(this.percentStrings[i], null));
        }
    }

    public void testMoneyNormalization() {
        QuantifiableEntityNormalizerTest.assertEquals((int)this.moneyStrings.length, (int)this.moneyAnswers.length);
        for (int i = 0; i < this.moneyStrings.length; ++i) {
            QuantifiableEntityNormalizerTest.assertEquals((String)this.moneyAnswers[i], (String)QuantifiableEntityNormalizer.normalizedMoneyString(this.moneyStrings[i], null));
        }
    }

    public void testNumberNormalization() {
        QuantifiableEntityNormalizerTest.assertEquals((int)this.numberStrings.length, (int)this.numberAnswers.length);
        for (int i = 0; i < this.numberStrings.length; ++i) {
            QuantifiableEntityNormalizerTest.assertEquals((String)this.numberAnswers[i], (String)QuantifiableEntityNormalizer.normalizedNumberString(this.numberStrings[i], "", null));
        }
    }

    public void testOrdinalNormalization() {
        QuantifiableEntityNormalizerTest.assertEquals((int)this.ordinalStrings.length, (int)this.ordinalAnswers.length);
        for (int i = 0; i < this.ordinalStrings.length; ++i) {
            QuantifiableEntityNormalizerTest.assertEquals((String)this.ordinalAnswers[i], (String)QuantifiableEntityNormalizer.normalizedOrdinalString(this.ordinalStrings[i], null));
        }
    }

    public void testTimeNormalization() {
        QuantifiableEntityNormalizerTest.assertEquals((int)this.timeStrings.length, (int)this.timeAnswers.length);
        for (int i = 0; i < this.timeStrings.length; ++i) {
            QuantifiableEntityNormalizerTest.assertEquals((String)this.timeAnswers[i], (String)QuantifiableEntityNormalizer.normalizedTimeString(this.timeStrings[i], null));
        }
    }
}

