/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie;

import edu.stanford.nlp.ie.AbstractSequenceClassifier;
import edu.stanford.nlp.ie.crf.CRFClassifier;
import edu.stanford.nlp.ie.ner.CMMClassifier;
import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.logging.Redwood;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class NERGUI {
    private static Redwood.RedwoodChannels log = Redwood.channels(NERGUI.class);
    private AbstractSequenceClassifier<?> classifier;
    private JFrame frame;
    private JEditorPane editorPane;
    private JToolBar tagPanel;
    private static final int HEIGHT = 600;
    private static final int WIDTH = 650;
    private Map<String, Color> tagToColorMap;
    private JFileChooser fileChooser = new JFileChooser(System.getProperty("user.dir"));
    private MutableAttributeSet defaultAttrSet = new SimpleAttributeSet();
    private ActionListener actor = new ActionPerformer();
    private File loadedFile;
    private String untaggedContents = null;
    private String taggedContents = null;
    private String htmlContents = null;
    private JMenuItem saveUntagged = null;
    private JMenuItem saveTaggedAs = null;
    private static final String initText = "In bringing his distinct vision to the Western genre, writer-director Jim Jarmusch has created a quasi-mystical avant-garde drama that remains a deeply spiritual viewing experience. After losing his parents and fianc\u00e9e, a Cleveland accountant named William Blake (a remarkable Johnny Depp) spends all his money and takes a train to the frontier town of Machine in order to work at a factory. Upon arriving in Machine, he is denied his expected job and finds himself a fugitive after murdering a man in self-defense. Wounded and helpless, Blake is befriended by Nobody (Gary Farmer), a wandering Native American who considers him to be a ghostly manifestation of the famous poet. Nobody aids Blake in his flight from three bumbling bounty hunters, preparing him for his final journey--a return to the world of the spirits.";
    JButton extractButton = null;
    private static Color[] basicColors = new Color[]{new Color(204, 102, 0), new Color(102, 0, 102), new Color(204, 0, 102), new Color(153, 0, 0), new Color(153, 0, 204), new Color(255, 102, 0), new Color(255, 102, 153), new Color(204, 152, 255), new Color(102, 102, 255), new Color(153, 102, 0), new Color(51, 102, 51), new Color(0, 102, 255)};

    private void createAndShowGUI() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        this.frame = new JFrame("Stanford Named Entity Recognizer");
        this.frame.setDefaultCloseOperation(3);
        this.frame.getContentPane().setLayout(new BorderLayout());
        this.frame.getContentPane().setSize(650, 600);
        this.frame.setJMenuBar(this.addMenuBar());
        this.frame.setSize(650, 600);
        this.buildTagPanel();
        this.buildContentPanel();
        this.frame.pack();
        this.frame.setSize(650, 600);
        this.frame.setVisible(true);
    }

    private JMenuBar addMenuBar() {
        JMenuBar menubar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        menubar.add(fileMenu);
        JMenu editMenu = new JMenu("Edit");
        menubar.add(editMenu);
        JMenu classifierMenu = new JMenu("Classifier");
        menubar.add(classifierMenu);
        int menuMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        JMenuItem openFile = new JMenuItem("Open File");
        openFile.setMnemonic('O');
        openFile.setAccelerator(KeyStroke.getKeyStroke(70, menuMask));
        openFile.addActionListener(this.actor);
        fileMenu.add(openFile);
        JMenuItem loadURL = new JMenuItem("Load URL");
        loadURL.setMnemonic('L');
        loadURL.setAccelerator(KeyStroke.getKeyStroke(85, menuMask));
        loadURL.addActionListener(this.actor);
        fileMenu.add(loadURL);
        fileMenu.add(new JSeparator());
        this.saveUntagged = new JMenuItem("Save Untagged File");
        this.saveUntagged.setMnemonic('S');
        this.saveUntagged.setAccelerator(KeyStroke.getKeyStroke(83, menuMask));
        this.saveUntagged.addActionListener(this.actor);
        this.saveUntagged.setEnabled(false);
        fileMenu.add(this.saveUntagged);
        JMenuItem saveUntaggedAs = new JMenuItem("Save Untagged File As ...");
        saveUntaggedAs.setMnemonic('U');
        saveUntaggedAs.setAccelerator(KeyStroke.getKeyStroke(85, menuMask));
        saveUntaggedAs.addActionListener(this.actor);
        fileMenu.add(saveUntaggedAs);
        this.saveTaggedAs = new JMenuItem("Save Tagged File As ...");
        this.saveTaggedAs.setMnemonic('T');
        this.saveTaggedAs.setAccelerator(KeyStroke.getKeyStroke(84, menuMask));
        this.saveTaggedAs.addActionListener(this.actor);
        this.saveTaggedAs.setEnabled(false);
        fileMenu.add(this.saveTaggedAs);
        fileMenu.add(new JSeparator());
        JMenuItem exit = new JMenuItem("Exit");
        exit.setMnemonic('x');
        exit.setAccelerator(KeyStroke.getKeyStroke(81, menuMask));
        exit.addActionListener(this.actor);
        fileMenu.add(exit);
        JMenuItem clear = new JMenuItem("Clear");
        clear.setMnemonic('C');
        clear.setAccelerator(KeyStroke.getKeyStroke(76, menuMask));
        clear.addActionListener(this.actor);
        editMenu.add(clear);
        JMenuItem loadCRF = new JMenuItem("Load CRF From File");
        loadCRF.setMnemonic('R');
        loadCRF.setAccelerator(KeyStroke.getKeyStroke(82, menuMask));
        loadCRF.addActionListener(this.actor);
        classifierMenu.add(loadCRF);
        JMenuItem loadDefaultCRF = new JMenuItem("Load Default CRF");
        loadDefaultCRF.setMnemonic('L');
        loadDefaultCRF.setAccelerator(KeyStroke.getKeyStroke(76, menuMask));
        loadDefaultCRF.addActionListener(this.actor);
        classifierMenu.add(loadDefaultCRF);
        JMenuItem loadCMM = new JMenuItem("Load CMM From File");
        loadCMM.setMnemonic('M');
        loadCMM.setAccelerator(KeyStroke.getKeyStroke(77, menuMask));
        loadCMM.addActionListener(this.actor);
        classifierMenu.add(loadCMM);
        JMenuItem loadDefaultCMM = new JMenuItem("Load Default CMM");
        loadDefaultCMM.setMnemonic('D');
        loadDefaultCMM.setAccelerator(KeyStroke.getKeyStroke(68, menuMask));
        loadDefaultCMM.addActionListener(this.actor);
        classifierMenu.add(loadDefaultCMM);
        return menubar;
    }

    public File getFile(boolean open) {
        File file = null;
        int returnVal = open ? this.fileChooser.showOpenDialog(this.frame) : this.fileChooser.showSaveDialog(this.frame);
        if (returnVal == 0) {
            file = this.fileChooser.getSelectedFile();
            if (open && !this.checkFile(file)) {
                file = null;
            }
        }
        return file;
    }

    public void saveUntaggedContents(File file) {
        try {
            String contents;
            if (this.editorPane.getContentType().equals("text/html")) {
                contents = this.editorPane.getText();
            } else {
                Document doc = this.editorPane.getDocument();
                contents = doc.getText(0, doc.getLength());
            }
            NERGUI.saveFile(file, contents);
            this.saveUntagged.setEnabled(true);
            this.loadedFile = file;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void saveFile(File file, String contents) {
        StringUtils.printToFile(file, contents);
    }

    public String getURL() {
        String url = JOptionPane.showInputDialog(this.frame, "URL: ", "Load URL", 3);
        return url;
    }

    public boolean checkFile(File file) {
        if (file.isFile()) {
            this.fileChooser.setCurrentDirectory(file.getParentFile());
            return true;
        }
        String message = "File Not Found: " + file.getAbsolutePath();
        this.displayError("File Not Found Error", message);
        return false;
    }

    public void displayError(String title, String message) {
        JOptionPane.showMessageDialog(this.frame, message, title, 0);
    }

    public void loadClassifier(File file, boolean crf) {
        try {
            this.classifier = crf ? CRFClassifier.getClassifier(file) : CMMClassifier.getClassifier(file);
        }
        catch (Exception e) {
            String message = "Error loading " + (crf ? "CRF" : "CMM") + ": " + file.getAbsolutePath();
            String title = (crf ? "CRF" : "CMM") + " Load Error";
            message = message + "\nMessage: " + e.getMessage();
            this.displayError(title, message);
            return;
        }
        this.removeTags();
        this.buildTagPanel();
        this.buildExtractButton();
    }

    public void loadDefaultClassifier(boolean crf) {
        try {
            this.classifier = crf ? CRFClassifier.getDefaultClassifier() : CMMClassifier.getDefaultClassifier();
        }
        catch (Exception e) {
            String message = "Error loading default " + (crf ? "CRF" : "CMM");
            String title = (crf ? "CRF" : "CMM") + " Load Error";
            message = message + "\nMessage: " + e.getMessage();
            this.displayError(title, message);
            return;
        }
        this.removeTags();
        this.buildTagPanel();
        this.buildExtractButton();
    }

    public void openFile(File file) {
        String encoding = this.classifier == null ? "utf-8" : this.classifier.flags.inputEncoding;
        String text = IOUtils.slurpFileNoExceptions(file.getPath(), encoding);
        System.out.println(text);
        this.editorPane.setContentType("text/plain");
        this.editorPane.setText(text);
        System.out.println(this.editorPane.getText());
        this.loadedFile = file;
        this.redraw();
        this.saveUntagged.setEnabled(true);
    }

    public void openURL(String url) {
        try {
            this.editorPane.setPage(url);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.displayError("Error Loading URL " + url, "Message: " + e.toString());
            return;
        }
        this.loadedFile = null;
        this.redraw();
    }

    public void redraw() {
        String text = this.editorPane.getText();
        this.taggedContents = null;
        this.untaggedContents = null;
        if (!this.editorPane.getContentType().equals("text/html")) {
            this.editorPane.setContentType("text/rtf");
            Document doc = this.editorPane.getDocument();
            try {
                doc.insertString(0, text, this.defaultAttrSet);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.editorPane.revalidate();
            this.editorPane.repaint();
            this.editorPane.setEditable(true);
            this.htmlContents = null;
        } else {
            this.editorPane.setEditable(false);
            this.htmlContents = this.editorPane.getText();
        }
        this.saveUntagged.setEnabled(false);
        this.saveTaggedAs.setEnabled(false);
    }

    private void removeTags() {
        if (this.editorPane.getContentType().equals("text/html")) {
            this.editorPane.setText(this.htmlContents);
            this.editorPane.revalidate();
            this.editorPane.repaint();
        } else {
            DefaultStyledDocument doc = (DefaultStyledDocument)this.editorPane.getDocument();
            SimpleAttributeSet attr = new SimpleAttributeSet();
            StyleConstants.setForeground(attr, Color.BLACK);
            StyleConstants.setBackground(attr, Color.WHITE);
            doc.setCharacterAttributes(0, doc.getLength(), attr, false);
        }
        this.saveTaggedAs.setEnabled(false);
    }

    private void extract() {
        log.info("content type: " + this.editorPane.getContentType());
        if (!this.editorPane.getContentType().equals("text/html")) {
            String labeledText;
            DefaultStyledDocument doc = (DefaultStyledDocument)this.editorPane.getDocument();
            String text = null;
            try {
                text = doc.getText(0, doc.getLength());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.taggedContents = labeledText = this.classifier.classifyWithInlineXML(text);
            this.untaggedContents = text;
            Set<String> tags = this.classifier.labels();
            String background = this.classifier.backgroundSymbol();
            String tagPattern = "";
            for (String tag : tags) {
                if (background.equals(tag)) continue;
                if (tagPattern.length() > 0) {
                    tagPattern = tagPattern + "|";
                }
                tagPattern = tagPattern + tag;
            }
            Pattern startPattern = Pattern.compile("<(" + tagPattern + ")>");
            Pattern endPattern = Pattern.compile("</(" + tagPattern + ")>");
            String finalText = labeledText;
            Matcher m = startPattern.matcher(finalText);
            while (m.find()) {
                int start = m.start();
                finalText = m.replaceFirst("");
                if ((m = endPattern.matcher(finalText)).find()) {
                    int end = m.start();
                    String tag = m.group(1);
                    finalText = m.replaceFirst("");
                    AttributeSet attSet = this.getAttributeSet(tag);
                    try {
                        String entity = finalText.substring(start, end);
                        doc.setCharacterAttributes(start, entity.length(), attSet, false);
                    }
                    catch (Exception ex) {
                        throw new RuntimeException(ex);
                    }
                    log.info(tag + ": " + finalText.substring(start, end));
                }
                m = startPattern.matcher(finalText);
            }
            this.editorPane.revalidate();
            this.editorPane.repaint();
        } else {
            this.untaggedContents = this.editorPane.getText();
            this.taggedContents = this.classifier.classifyWithInlineXML(this.untaggedContents);
            Set<String> tags = this.classifier.labels();
            String background = this.classifier.backgroundSymbol();
            String tagPattern = "";
            for (String tag : tags) {
                if (background.equals(tag)) continue;
                if (tagPattern.length() > 0) {
                    tagPattern = tagPattern + "|";
                }
                tagPattern = tagPattern + tag;
            }
            Pattern startPattern = Pattern.compile("<(" + tagPattern + ")>");
            Pattern endPattern = Pattern.compile("</(" + tagPattern + ")>");
            String finalText = this.taggedContents;
            Matcher m = startPattern.matcher(finalText);
            while (m.find()) {
                String tag = m.group(1);
                String color = NERGUI.colorToHTML(this.tagToColorMap.get(tag));
                String newTag = "<span style=\"background-color: " + color + "; color: white\">";
                finalText = m.replaceFirst(newTag);
                int start = m.start() + newTag.length();
                Matcher m1 = endPattern.matcher(finalText);
                m1.find(m.end());
                String entity = finalText.substring(start, m1.start());
                log.info(tag + ": " + entity);
                finalText = m1.replaceFirst("</span>");
                m = startPattern.matcher(finalText);
            }
            System.out.println(finalText);
            this.editorPane.setText(finalText);
            this.editorPane.revalidate();
            this.editorPane.repaint();
            log.info(finalText);
        }
        this.saveTaggedAs.setEnabled(true);
    }

    private AttributeSet getAttributeSet(String tag) {
        SimpleAttributeSet attr = new SimpleAttributeSet();
        Color color = this.tagToColorMap.get(tag);
        StyleConstants.setBackground(attr, color);
        StyleConstants.setForeground(attr, Color.WHITE);
        return attr;
    }

    public void clearDocument() {
        this.editorPane.setContentType("text/rtf");
        DefaultStyledDocument doc = new DefaultStyledDocument();
        this.editorPane.setDocument(doc);
        log.info("attr: " + this.defaultAttrSet);
        try {
            doc.insertString(0, " ", this.defaultAttrSet);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        this.editorPane.setEditable(true);
        this.editorPane.revalidate();
        this.editorPane.repaint();
        this.saveUntagged.setEnabled(false);
        this.saveTaggedAs.setEnabled(false);
        this.taggedContents = null;
        this.untaggedContents = null;
        this.htmlContents = null;
        this.loadedFile = null;
    }

    public void exit() {
        System.exit(-1);
    }

    private void buildContentPanel() {
        this.editorPane = new JEditorPane();
        this.editorPane.setContentType("text/rtf");
        this.editorPane.addKeyListener(new InputListener());
        StyleConstants.setFontFamily(this.defaultAttrSet, "Lucinda Sans");
        DefaultStyledDocument doc = new DefaultStyledDocument();
        this.editorPane.setDocument(doc);
        try {
            doc.insertString(0, initText, this.defaultAttrSet);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        JScrollPane scrollPane = new JScrollPane(this.editorPane);
        this.frame.getContentPane().add((Component)scrollPane, "Center");
        this.editorPane.setEditable(true);
    }

    public static String colorToHTML(Color color) {
        String r = Integer.toHexString(color.getRed());
        if (r.length() == 0) {
            r = "00";
        } else if (r.length() == 1) {
            r = "0" + r;
        } else if (r.length() > 2) {
            throw new IllegalArgumentException("invalid hex color for red" + r);
        }
        String g = Integer.toHexString(color.getGreen());
        if (g.length() == 0) {
            g = "00";
        } else if (g.length() == 1) {
            g = "0" + g;
        } else if (g.length() > 2) {
            throw new IllegalArgumentException("invalid hex color for green" + g);
        }
        String b = Integer.toHexString(color.getBlue());
        if (b.length() == 0) {
            b = "00";
        } else if (b.length() == 1) {
            b = "0" + b;
        } else if (b.length() > 2) {
            throw new IllegalArgumentException("invalid hex color for blue" + b);
        }
        return "#" + r + g + b;
    }

    private void buildExtractButton() {
        if (this.extractButton == null) {
            JPanel buttonPanel = new JPanel();
            this.extractButton = new JButton("Extract");
            buttonPanel.add(this.extractButton);
            this.frame.add((Component)buttonPanel, "South");
            this.extractButton.addActionListener(this.actor);
        }
    }

    private void buildTagPanel() {
        if (this.tagPanel == null) {
            this.tagPanel = new JToolBar(1);
            this.tagPanel.setFloatable(false);
            this.frame.getContentPane().add((Component)this.tagPanel, "East");
        } else {
            this.tagPanel.removeAll();
        }
        if (this.classifier != null) {
            this.makeTagMaps();
            Set<String> tags = this.classifier.labels();
            String backgroundSymbol = this.classifier.backgroundSymbol();
            for (String tag : tags) {
                if (backgroundSymbol.equals(tag)) continue;
                Color color = this.tagToColorMap.get(tag);
                JButton b = new JButton(tag, new ColorIcon(color));
                this.tagPanel.add(b);
            }
        }
        this.tagPanel.revalidate();
        this.tagPanel.repaint();
    }

    private void makeTagMaps() {
        Set<String> tags = this.classifier.labels();
        String backgroundSymbol = this.classifier.backgroundSymbol();
        this.tagToColorMap = NERGUI.makeTagToColorMap(tags, backgroundSymbol);
    }

    public static Map<String, Color> makeTagToColorMap(Set<String> tags, String backgroundSymbol) {
        int numColors = tags.size() - 1;
        Color[] colors = NERGUI.getNColors(numColors);
        Map<String, Color> result = Generics.newHashMap();
        int i = 0;
        for (String tag : tags) {
            if (backgroundSymbol.equals(tag) || result.get(tag) != null) continue;
            result.put(tag, colors[i++]);
        }
        return result;
    }

    public static Color[] getNColors(int n) {
        Color[] colors = new Color[n];
        if (n <= basicColors.length) {
            System.arraycopy(basicColors, 0, colors, 0, n);
        } else {
            int s = 255 / (int)Math.ceil(Math.pow(n, 0.3333333333333333));
            int index = 0;
            block0: for (int i = 0; i < 256; i += s) {
                for (int j = 0; j < 256; j += s) {
                    for (int k = 0; k < 256; k += s) {
                        colors[index++] = new Color(i, j, k);
                        if (index == n) break block0;
                    }
                }
            }
        }
        return colors;
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> {
            NERGUI gui = new NERGUI();
            gui.createAndShowGUI();
        });
    }

    static class ColorIcon
    implements Icon {
        Color color;

        public ColorIcon(Color c) {
            this.color = c;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(this.color);
            g.fillRect(x, y, this.getIconWidth(), this.getIconHeight());
        }

        @Override
        public int getIconWidth() {
            return 10;
        }

        @Override
        public int getIconHeight() {
            return 10;
        }
    }

    private class ActionPerformer
    implements ActionListener {
        private ActionPerformer() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String com;
            switch (com = e.getActionCommand()) {
                case "Open File": {
                    File file = NERGUI.this.getFile(true);
                    if (file == null) break;
                    NERGUI.this.openFile(file);
                    break;
                }
                case "Load URL": {
                    String url = NERGUI.this.getURL();
                    if (url == null) break;
                    NERGUI.this.openURL(url);
                    break;
                }
                case "Exit": {
                    NERGUI.this.exit();
                    break;
                }
                case "Clear": {
                    NERGUI.this.clearDocument();
                    break;
                }
                case "Load CRF From File": {
                    File file = NERGUI.this.getFile(true);
                    if (file == null) break;
                    NERGUI.this.loadClassifier(file, true);
                    break;
                }
                case "Load CMM From File": {
                    File file = NERGUI.this.getFile(true);
                    if (file == null) break;
                    NERGUI.this.loadClassifier(file, false);
                    break;
                }
                case "Load Default CRF": {
                    NERGUI.this.loadDefaultClassifier(true);
                    break;
                }
                case "Load Default CMM": {
                    NERGUI.this.loadDefaultClassifier(false);
                    break;
                }
                case "Extract": {
                    NERGUI.this.extract();
                    break;
                }
                case "Save Untagged File": {
                    NERGUI.this.saveUntaggedContents(NERGUI.this.loadedFile);
                    break;
                }
                case "Save Untagged File As ...": {
                    NERGUI.this.saveUntaggedContents(NERGUI.this.getFile(false));
                    break;
                }
                case "Save Tagged File As ...": {
                    NERGUI.saveFile(NERGUI.this.getFile(false), NERGUI.this.taggedContents);
                    break;
                }
                default: {
                    log.info("Unknown Action: " + e);
                }
            }
        }
    }

    private class InputListener
    implements KeyListener {
        private InputListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            NERGUI.this.saveTaggedAs.setEnabled(false);
        }
    }
}

