/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie;

import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.HashIndex;
import edu.stanford.nlp.util.Index;
import edu.stanford.nlp.util.Pair;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ChineseMorphFeatureSets
implements Serializable {
    private static final long serialVersionUID = -1055526945031459198L;
    private Index<String> featIndex = new HashIndex<String>();
    private Map<String, Set<Character>> singletonFeatures = Generics.newHashMap();
    private Map<String, Pair<Set<Character>, Set<Character>>> affixFeatures = Generics.newHashMap();

    public Map<String, Set<Character>> getSingletonFeatures() {
        return this.singletonFeatures;
    }

    public Map<String, Pair<Set<Character>, Set<Character>>> getAffixFeatures() {
        return this.affixFeatures;
    }

    public ChineseMorphFeatureSets(String featureDir) {
        try {
            File[] files;
            File dir = new File(featureDir);
            for (File file : files = dir.listFiles((dir1, name) -> name.endsWith(".gb"))) {
                this.getFeatures(file);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error creating ChineseMaxentLexicon" + e);
        }
    }

    private void getFeatures(File file) throws IOException {
        String line;
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "GB18030"));
        String filename = file.getName();
        String singleFeatName = filename;
        if (singleFeatName.indexOf(46) >= 0) {
            singleFeatName = singleFeatName.substring(0, filename.lastIndexOf(46));
        }
        FeatType featType = null;
        for (FeatType ft : FeatType.values()) {
            if (!filename.contains(ft.toString().toLowerCase())) continue;
            featType = ft;
            if (!(singleFeatName = singleFeatName.substring(0, filename.indexOf(ft.toString().toLowerCase()))).endsWith("_")) break;
            singleFeatName = singleFeatName.substring(0, singleFeatName.lastIndexOf(95));
            break;
        }
        this.featIndex.add(singleFeatName);
        String singleFeatIndexString = Integer.toString(this.featIndex.indexOf(singleFeatName));
        Set<Character> featureSet = Generics.newHashSet();
        Pattern typedDoubleFeatPattern = Pattern.compile("([A-Za-z]+)\\s+(.)\\s+(.)\\s*");
        Pattern typedSingleFeatPattern = Pattern.compile("([A-Za-z]+)\\s+(.)\\s*");
        Pattern singleFeatPattern = Pattern.compile("(.)(?:\\s+[0-9]+)?\\s*");
        while ((line = in.readLine()) != null) {
            String featIndexString;
            String featName;
            Matcher typedDoubleFeatMatcher;
            if (line.length() == 0) continue;
            if (featType == null && (typedDoubleFeatMatcher = typedDoubleFeatPattern.matcher(line)).matches()) {
                featName = typedDoubleFeatMatcher.group(1);
                this.featIndex.add(featName);
                featIndexString = Integer.toString(this.featIndex.indexOf(featName));
                String prefixChar = typedDoubleFeatMatcher.group(2);
                this.addTypedFeature(featIndexString, prefixChar.charAt(0), true);
                String suffixChar = typedDoubleFeatMatcher.group(3);
                this.addTypedFeature(featIndexString, suffixChar.charAt(0), false);
                continue;
            }
            Matcher typedSingleFeatMatcher = typedSingleFeatPattern.matcher(line);
            if (typedSingleFeatMatcher.matches()) {
                featName = typedSingleFeatMatcher.group(1);
                this.featIndex.add(featName);
                featIndexString = Integer.toString(this.featIndex.indexOf(featName));
                String charString = typedSingleFeatMatcher.group(2);
                switch (featType) {
                    case PREFIX: {
                        this.addTypedFeature(featIndexString, charString.charAt(0), true);
                        break;
                    }
                    case SUFFIX: {
                        this.addTypedFeature(featIndexString, charString.charAt(0), false);
                        break;
                    }
                    case SINGLETON: {
                        throw new RuntimeException("ERROR: typed SINGLETON feature.");
                    }
                }
                continue;
            }
            Matcher singleFeatMatcher = singleFeatPattern.matcher(line);
            if (singleFeatMatcher.matches()) {
                String charString = singleFeatMatcher.group();
                featureSet.add(Character.valueOf(charString.charAt(0)));
                continue;
            }
            if (!line.startsWith("prefix") && !line.startsWith("suffix")) continue;
            if (featureSet.size() > 0) {
                Pair<Set<Character>, Set<Character>> p = this.affixFeatures.get(singleFeatIndexString);
                if (p == null) {
                    p = new Pair();
                    this.affixFeatures.put(singleFeatIndexString, p);
                }
                if (featType == FeatType.PREFIX) {
                    p.setFirst(featureSet);
                } else {
                    p.setSecond(featureSet);
                }
                featureSet = Generics.newHashSet();
            }
            featType = FeatType.PREFIX;
            if (line.startsWith("prefix")) {
                featType = FeatType.PREFIX;
                continue;
            }
            if (!line.startsWith("suffix")) continue;
            featType = FeatType.SUFFIX;
        }
        if (featureSet.size() > 0) {
            if (featType == FeatType.SINGLETON) {
                this.singletonFeatures.put(singleFeatIndexString, featureSet);
            } else {
                Pair<Set<Character>, Set<Character>> p = this.affixFeatures.get(singleFeatIndexString);
                if (p == null) {
                    p = new Pair();
                    this.affixFeatures.put(singleFeatIndexString, p);
                }
                if (featType == FeatType.PREFIX) {
                    p.setFirst(featureSet);
                } else {
                    p.setSecond(featureSet);
                }
            }
        }
    }

    private void addTypedFeature(String featName, char featChar, boolean isPrefix) {
        Set<Character> feature;
        Pair<Set<Character>, Set<Character>> p = this.affixFeatures.get(featName);
        if (p == null) {
            p = new Pair();
            this.affixFeatures.put(featName, p);
        }
        if (isPrefix) {
            feature = p.first();
            if (feature == null) {
                feature = Generics.newHashSet();
                p.setFirst(feature);
            }
        } else {
            feature = p.second();
            if (feature == null) {
                feature = Generics.newHashSet();
                p.setSecond(feature);
            }
        }
        feature.add(Character.valueOf(featChar));
    }

    private static enum FeatType {
        PREFIX,
        SUFFIX,
        SINGLETON;

    }
}

