/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.graph;

import edu.stanford.nlp.graph.DirectedMultiGraph;
import edu.stanford.nlp.util.CollectionUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;

public class DirectedMultiGraphTest
extends TestCase {
    DirectedMultiGraph<Integer, String> graph = new DirectedMultiGraph();

    public void setUp() {
        this.graph.clear();
        this.graph.add(1, 2, "1->2");
        this.graph.add(2, 3, "2->3");
        this.graph.add(1, 4, "1->4");
        this.graph.add(4, 1, "4->1");
        this.graph.addVertex(5);
        this.graph.add(5, 6, "5->6");
        this.graph.add(7, 6, "7->6");
        this.graph.addVertex(7);
        this.graph.addVertex(8);
        this.graph.add(9, 10, "9->10");
    }

    public <V, E> void checkGraphConsistency(DirectedMultiGraph<V, E> graph) {
        Map incoming = graph.incomingEdges;
        Map outgoing = graph.outgoingEdges;
        for (Object source : incoming.keySet()) {
            for (Object target : incoming.get(source).keySet()) {
                DirectedMultiGraphTest.assertTrue((boolean)outgoing.containsKey(target));
                DirectedMultiGraphTest.assertTrue((boolean)outgoing.get(target).containsKey(source));
                DirectedMultiGraphTest.assertEquals(incoming.get(source).get(target), outgoing.get(target).get(source));
            }
        }
    }

    public void testForm() {
        System.out.println("Graph is \n" + this.graph.toString());
        DirectedMultiGraphTest.assertEquals((int)this.graph.getNumVertices(), (int)10);
        DirectedMultiGraphTest.assertEquals((int)this.graph.getNumEdges(), (int)7);
    }

    public void testRemove() {
        this.graph.removeVertex(2);
        System.out.println("after deleting 2\n" + this.graph.toString());
        DirectedMultiGraphTest.assertEquals((int)this.graph.getNumVertices(), (int)9);
        DirectedMultiGraphTest.assertEquals((int)this.graph.getNumEdges(), (int)5);
        DirectedMultiGraphTest.assertFalse((boolean)this.graph.removeVertex(11));
        this.setUp();
        DirectedMultiGraphTest.assertTrue((boolean)this.graph.removeEdges(2, 3));
        System.out.println("after deleting 2->3 edge\n" + this.graph.toString());
        DirectedMultiGraphTest.assertEquals((int)this.graph.getNumVertices(), (int)10);
        DirectedMultiGraphTest.assertEquals((int)this.graph.getNumEdges(), (int)6);
        DirectedMultiGraphTest.assertFalse((boolean)this.graph.removeEdges(2, 3));
    }

    public void testDelZeroDegreeNodes() {
        this.graph.removeVertex(2);
        this.graph.removeZeroDegreeNodes();
        System.out.println("after deleting 2, and then zero deg nodes \n" + this.graph.toString());
        DirectedMultiGraphTest.assertEquals((int)this.graph.getNumVertices(), (int)7);
        DirectedMultiGraphTest.assertEquals((int)this.graph.getNumEdges(), (int)5);
    }

    public void testShortestPathDirectionSensitiveNodes() {
        List<Integer> nodes = this.graph.getShortestPath(1, 3, true);
        System.out.println("directed path nodes btw 1 and 3 is " + nodes);
        DirectedMultiGraphTest.assertEquals((int)3, (int)nodes.size());
        DirectedMultiGraphTest.assertEquals((int)1, (int)nodes.get(0));
        DirectedMultiGraphTest.assertEquals((int)2, (int)nodes.get(1));
        DirectedMultiGraphTest.assertEquals((int)3, (int)nodes.get(2));
        nodes = this.graph.getShortestPath(2, 4, true);
        System.out.println("directed path nodes btw 2 and 4 is " + nodes);
        DirectedMultiGraphTest.assertEquals(null, nodes);
        nodes = this.graph.getShortestPath(1, 5, true);
        System.out.println("directed path nodes btw 1 and 5 is " + nodes);
        DirectedMultiGraphTest.assertEquals(null, nodes);
    }

    public void testShortedPathDirectionSensitiveEdges() {
        List<String> edges = this.graph.getShortestPathEdges(1, 3, true);
        System.out.println("directed path edges btw 1 and 3 is " + edges);
        DirectedMultiGraphTest.assertEquals((int)2, (int)edges.size());
        DirectedMultiGraphTest.assertEquals((String)"1->2", (String)edges.get(0));
        DirectedMultiGraphTest.assertEquals((String)"2->3", (String)edges.get(1));
        edges = this.graph.getShortestPathEdges(2, 4, true);
        System.out.println("directed path edges btw 2 and 4 is " + edges);
        DirectedMultiGraphTest.assertEquals(null, edges);
        edges = this.graph.getShortestPathEdges(1, 5, true);
        System.out.println("directed path edges btw 1 and 5 is " + edges);
        DirectedMultiGraphTest.assertEquals(null, edges);
    }

    public void testShortestPathDirectionInsensitiveNodes() {
        List<Integer> nodes = this.graph.getShortestPath(1, 3);
        System.out.println("undirected nodes btw 1 and 3 is " + nodes);
        DirectedMultiGraphTest.assertEquals((int)3, (int)nodes.size());
        DirectedMultiGraphTest.assertEquals((int)1, (int)nodes.get(0));
        DirectedMultiGraphTest.assertEquals((int)2, (int)nodes.get(1));
        DirectedMultiGraphTest.assertEquals((int)3, (int)nodes.get(2));
        nodes = this.graph.getShortestPath(2, 4);
        System.out.println("undirected nodes btw 2 and 4 is " + nodes);
        DirectedMultiGraphTest.assertEquals((int)3, (int)nodes.size());
        DirectedMultiGraphTest.assertEquals((int)2, (int)nodes.get(0));
        DirectedMultiGraphTest.assertEquals((int)1, (int)nodes.get(1));
        DirectedMultiGraphTest.assertEquals((int)4, (int)nodes.get(2));
        nodes = this.graph.getShortestPath(1, 5);
        System.out.println("undirected nodes btw 1 and 5 is " + nodes);
        DirectedMultiGraphTest.assertEquals(null, nodes);
    }

    public void testShortestPathDirectionInsensitiveEdges() {
        List<String> edges = this.graph.getShortestPathEdges(1, 3, false);
        System.out.println("undirected edges btw 1 and 3 is " + edges);
        DirectedMultiGraphTest.assertEquals((int)2, (int)edges.size());
        DirectedMultiGraphTest.assertEquals((String)"1->2", (String)edges.get(0));
        DirectedMultiGraphTest.assertEquals((String)"2->3", (String)edges.get(1));
        edges = this.graph.getShortestPathEdges(2, 4, false);
        System.out.println("undirected edges btw 2 and 4 is " + edges);
        DirectedMultiGraphTest.assertEquals((int)2, (int)edges.size());
        DirectedMultiGraphTest.assertEquals((String)"1->2", (String)edges.get(0));
        DirectedMultiGraphTest.assertEquals((String)"1->4", (String)edges.get(1));
        edges = this.graph.getShortestPathEdges(1, 5, false);
        System.out.println("undirected edges btw 2 and 4 is " + edges);
        DirectedMultiGraphTest.assertEquals(null, edges);
    }

    public void testConnectedComponents() {
        System.out.println("graph is " + this.graph.toString());
        List<Set<Integer>> ccs = this.graph.getConnectedComponents();
        for (Set<Integer> cc : ccs) {
            System.out.println("Connected component: " + cc);
        }
        DirectedMultiGraphTest.assertEquals((int)ccs.size(), (int)4);
        DirectedMultiGraphTest.assertEquals(CollectionUtils.sorted((Iterable)ccs.get(0)), Arrays.asList(1, 2, 3, 4));
    }

    public void testEdgesNodes() {
        DirectedMultiGraphTest.assertTrue((boolean)this.graph.isEdge(1, 2));
        DirectedMultiGraphTest.assertFalse((boolean)this.graph.isEdge(2, 1));
        DirectedMultiGraphTest.assertTrue((boolean)this.graph.isNeighbor(2, 1));
        List<String> incomingEdges = this.graph.getEdges(4, 1);
        DirectedMultiGraphTest.assertEquals(CollectionUtils.sorted(incomingEdges), Arrays.asList("4->1"));
        Set<Integer> neighbors = this.graph.getNeighbors(2);
        DirectedMultiGraphTest.assertEquals(CollectionUtils.sorted(neighbors), CollectionUtils.sorted(Arrays.asList(1, 3)));
        Set<Integer> parents = this.graph.getParents(4);
        DirectedMultiGraphTest.assertEquals(CollectionUtils.sorted(parents), CollectionUtils.sorted(Arrays.asList(1)));
        parents = this.graph.getParents(1);
        DirectedMultiGraphTest.assertEquals(CollectionUtils.sorted(parents), CollectionUtils.sorted(Arrays.asList(4)));
        parents = this.graph.getParents(6);
        DirectedMultiGraphTest.assertEquals(CollectionUtils.sorted(parents), CollectionUtils.sorted(Arrays.asList(5, 7)));
    }

    public void testAdd() {
        DirectedMultiGraph<Integer, String> g = new DirectedMultiGraph<Integer, String>();
        DirectedMultiGraphTest.assertEquals((int)0, (int)g.getNumVertices());
        DirectedMultiGraphTest.assertEquals((int)0, (int)g.getNumEdges());
        g.addVertex(1);
        DirectedMultiGraphTest.assertEquals((int)1, (int)g.getNumVertices());
        DirectedMultiGraphTest.assertEquals((int)0, (int)g.getNumEdges());
        g.addVertex(2);
        DirectedMultiGraphTest.assertEquals((int)2, (int)g.getNumVertices());
        DirectedMultiGraphTest.assertEquals((int)0, (int)g.getNumEdges());
        g.add(1, 2, "foo");
        DirectedMultiGraphTest.assertEquals((int)2, (int)g.getNumVertices());
        DirectedMultiGraphTest.assertEquals((int)1, (int)g.getNumEdges());
        g.add(1, 2, "bar");
        DirectedMultiGraphTest.assertEquals((int)2, (int)g.getNumVertices());
        DirectedMultiGraphTest.assertEquals((int)2, (int)g.getNumEdges());
        g.addVertex(2);
        DirectedMultiGraphTest.assertEquals((int)2, (int)g.getNumVertices());
        DirectedMultiGraphTest.assertEquals((int)2, (int)g.getNumEdges());
        g.addVertex(3);
        DirectedMultiGraphTest.assertEquals((int)3, (int)g.getNumVertices());
        DirectedMultiGraphTest.assertEquals((int)2, (int)g.getNumEdges());
        g.add(1, 3, "bar");
        DirectedMultiGraphTest.assertEquals((int)3, (int)g.getNumVertices());
        DirectedMultiGraphTest.assertEquals((int)3, (int)g.getNumEdges());
        g.add(2, 3, "foo");
        DirectedMultiGraphTest.assertEquals((int)3, (int)g.getNumVertices());
        DirectedMultiGraphTest.assertEquals((int)4, (int)g.getNumEdges());
        g.add(2, 3, "baz");
        DirectedMultiGraphTest.assertEquals((int)3, (int)g.getNumVertices());
        DirectedMultiGraphTest.assertEquals((int)5, (int)g.getNumEdges());
        g.add(2, 4, "baz");
        DirectedMultiGraphTest.assertEquals((int)4, (int)g.getNumVertices());
        DirectedMultiGraphTest.assertEquals((int)6, (int)g.getNumEdges());
    }

    public void testSmallAddRemove() {
        DirectedMultiGraph<Integer, String> g = new DirectedMultiGraph<Integer, String>();
        g.addVertex(1);
        g.addVertex(2);
        g.add(1, 2, "foo");
        DirectedMultiGraphTest.assertEquals((int)2, (int)g.getNumVertices());
        DirectedMultiGraphTest.assertEquals((int)1, (int)g.getNumEdges());
        DirectedMultiGraphTest.assertTrue((boolean)g.isEdge(1, 2));
        g.removeEdge(1, 2, "foo");
        DirectedMultiGraphTest.assertFalse((boolean)g.isEdge(1, 2));
        g.add(1, 2, "foo");
        g.add(1, 2, "bar");
        DirectedMultiGraphTest.assertTrue((boolean)g.isEdge(1, 2));
        DirectedMultiGraphTest.assertEquals((int)2, (int)g.getNumVertices());
        DirectedMultiGraphTest.assertEquals((int)2, (int)g.getNumEdges());
        g.removeEdge(1, 2, "foo");
        DirectedMultiGraphTest.assertTrue((boolean)g.isEdge(1, 2));
        DirectedMultiGraphTest.assertEquals((int)2, (int)g.getNumVertices());
        DirectedMultiGraphTest.assertEquals((int)1, (int)g.getNumEdges());
        g.removeEdge(1, 2, "bar");
        DirectedMultiGraphTest.assertFalse((boolean)g.isEdge(1, 2));
        DirectedMultiGraphTest.assertEquals((int)2, (int)g.getNumVertices());
        DirectedMultiGraphTest.assertEquals((int)0, (int)g.getNumEdges());
    }

    public void testSmallRemoveVertex() {
        DirectedMultiGraph<Integer, String> g = new DirectedMultiGraph<Integer, String>();
        g.addVertex(1);
        g.addVertex(2);
        g.add(1, 2, "foo");
        g.removeVertex(2);
        DirectedMultiGraphTest.assertEquals((int)1, (int)g.getNumVertices());
        DirectedMultiGraphTest.assertEquals((int)0, (int)g.getNumEdges());
        g.addVertex(2);
        DirectedMultiGraphTest.assertEquals((int)2, (int)g.getNumVertices());
        DirectedMultiGraphTest.assertEquals((int)0, (int)g.getNumEdges());
        DirectedMultiGraphTest.assertFalse((boolean)g.isEdge(1, 2));
        DirectedMultiGraphTest.assertFalse((boolean)g.isEdge(2, 1));
    }

    public void testSmallContains() {
        DirectedMultiGraph<Integer, String> g = new DirectedMultiGraph<Integer, String>();
        g.addVertex(1);
        g.addVertex(2);
        g.add(1, 2, "foo");
        DirectedMultiGraphTest.assertTrue((boolean)g.containsVertex(1));
        DirectedMultiGraphTest.assertTrue((boolean)g.containsVertex(2));
        DirectedMultiGraphTest.assertFalse((boolean)g.containsVertex(3));
        g.removeEdge(1, 2, "foo");
        DirectedMultiGraphTest.assertTrue((boolean)g.containsVertex(1));
        DirectedMultiGraphTest.assertTrue((boolean)g.containsVertex(2));
        DirectedMultiGraphTest.assertFalse((boolean)g.containsVertex(3));
        g.removeVertex(2);
        DirectedMultiGraphTest.assertEquals((int)1, (int)g.getNumVertices());
        DirectedMultiGraphTest.assertTrue((boolean)g.containsVertex(1));
        DirectedMultiGraphTest.assertFalse((boolean)g.containsVertex(2));
        DirectedMultiGraphTest.assertFalse((boolean)g.containsVertex(3));
    }

    public void testAddRemove() {
        DirectedMultiGraph<Integer, String> g = new DirectedMultiGraph<Integer, String>();
        g.addVertex(1);
        g.addVertex(2);
        g.add(1, 2, "foo");
        g.add(1, 2, "bar");
        g.addVertex(3);
        g.add(1, 3, "bar");
        g.add(2, 3, "foo");
        g.add(2, 3, "baz");
        g.add(2, 4, "baz");
        DirectedMultiGraphTest.assertEquals((int)4, (int)g.getNumVertices());
        DirectedMultiGraphTest.assertEquals((int)6, (int)g.getNumEdges());
        DirectedMultiGraphTest.assertTrue((boolean)g.isEdge(2, 3));
        g.removeEdges(2, 3);
        DirectedMultiGraphTest.assertFalse((boolean)g.isEdge(2, 3));
        DirectedMultiGraphTest.assertEquals((int)4, (int)g.getNumVertices());
        DirectedMultiGraphTest.assertEquals((int)4, (int)g.getNumEdges());
        DirectedMultiGraphTest.assertTrue((boolean)g.isEdge(1, 2));
        g.removeEdge(1, 2, "foo");
        DirectedMultiGraphTest.assertTrue((boolean)g.isEdge(1, 2));
        DirectedMultiGraphTest.assertEquals((int)4, (int)g.getNumVertices());
        DirectedMultiGraphTest.assertEquals((int)3, (int)g.getNumEdges());
        g.removeEdge(1, 2, "bar");
        DirectedMultiGraphTest.assertFalse((boolean)g.isEdge(1, 2));
        DirectedMultiGraphTest.assertEquals((int)4, (int)g.getNumVertices());
        DirectedMultiGraphTest.assertEquals((int)2, (int)g.getNumEdges());
        DirectedMultiGraphTest.assertFalse((boolean)g.removeEdge(3, 1, "bar"));
        DirectedMultiGraphTest.assertEquals((int)4, (int)g.getNumVertices());
        DirectedMultiGraphTest.assertEquals((int)2, (int)g.getNumEdges());
        DirectedMultiGraphTest.assertTrue((boolean)g.removeEdge(1, 3, "bar"));
        DirectedMultiGraphTest.assertEquals((int)4, (int)g.getNumVertices());
        DirectedMultiGraphTest.assertEquals((int)1, (int)g.getNumEdges());
        DirectedMultiGraphTest.assertFalse((boolean)g.removeEdge(2, 4, "arg"));
        DirectedMultiGraphTest.assertTrue((boolean)g.removeEdge(2, 4, "baz"));
        DirectedMultiGraphTest.assertEquals((int)4, (int)g.getNumVertices());
        DirectedMultiGraphTest.assertEquals((int)0, (int)g.getNumEdges());
        DirectedMultiGraphTest.assertFalse((boolean)g.removeVertex(5));
        DirectedMultiGraphTest.assertEquals((int)4, (int)g.getNumVertices());
        DirectedMultiGraphTest.assertEquals((int)0, (int)g.getNumEdges());
        DirectedMultiGraphTest.assertTrue((boolean)g.removeVertex(4));
        DirectedMultiGraphTest.assertEquals((int)3, (int)g.getNumVertices());
        DirectedMultiGraphTest.assertEquals((int)0, (int)g.getNumEdges());
        DirectedMultiGraphTest.assertFalse((boolean)g.removeVertex(4));
        DirectedMultiGraphTest.assertEquals((int)3, (int)g.getNumVertices());
        DirectedMultiGraphTest.assertEquals((int)0, (int)g.getNumEdges());
        List<Integer> vertices = Arrays.asList(3, 4);
        DirectedMultiGraphTest.assertTrue((boolean)g.removeVertices(vertices));
        DirectedMultiGraphTest.assertEquals((int)2, (int)g.getNumVertices());
        DirectedMultiGraphTest.assertEquals((int)0, (int)g.getNumEdges());
        DirectedMultiGraphTest.assertFalse((boolean)g.removeVertices(vertices));
        DirectedMultiGraphTest.assertEquals((int)2, (int)g.getNumVertices());
        DirectedMultiGraphTest.assertEquals((int)0, (int)g.getNumEdges());
        g.clear();
        DirectedMultiGraphTest.assertEquals((int)0, (int)g.getNumVertices());
        DirectedMultiGraphTest.assertEquals((int)0, (int)g.getNumEdges());
        g.addVertex(1);
        g.addVertex(2);
        g.add(1, 2, "foo");
        g.add(1, 2, "bar");
        g.addVertex(3);
        g.add(1, 3, "bar");
        g.add(2, 3, "foo");
        g.add(2, 3, "baz");
        g.add(2, 4, "baz");
        DirectedMultiGraphTest.assertEquals((int)4, (int)g.getNumVertices());
        DirectedMultiGraphTest.assertEquals((int)6, (int)g.getNumEdges());
        DirectedMultiGraphTest.assertTrue((boolean)g.removeVertices(vertices));
        DirectedMultiGraphTest.assertEquals((int)2, (int)g.getNumVertices());
        DirectedMultiGraphTest.assertEquals((int)2, (int)g.getNumEdges());
    }

    public void testAddRemove2() {
        DirectedMultiGraph<Integer, String> g = new DirectedMultiGraph<Integer, String>();
        g.clear();
        g.addVertex(1);
        g.addVertex(2);
        g.add(1, 2, "foo");
        g.add(1, 2, "bar");
        g.addVertex(3);
        g.add(1, 3, "bar");
        g.add(2, 3, "foo");
        g.add(2, 3, "baz");
        g.add(2, 4, "baz");
        DirectedMultiGraphTest.assertEquals((int)4, (int)g.getNumVertices());
        DirectedMultiGraphTest.assertEquals((int)6, (int)g.getNumEdges());
        List<Integer> vertices = Arrays.asList(2, 4);
        DirectedMultiGraphTest.assertTrue((boolean)g.removeVertices(vertices));
        DirectedMultiGraphTest.assertEquals((int)2, (int)g.getNumVertices());
        DirectedMultiGraphTest.assertEquals((int)1, (int)g.getNumEdges());
    }

    public void testAddRemove3() {
        DirectedMultiGraph<Integer, String> g = new DirectedMultiGraph<Integer, String>();
        g.clear();
        g.addVertex(1);
        g.addVertex(2);
        g.add(1, 2, "foo");
        g.add(1, 2, "bar");
        g.addVertex(3);
        g.add(1, 3, "bar");
        g.add(2, 3, "foo");
        g.add(2, 3, "baz");
        g.add(2, 4, "baz");
        g.removeEdges(2, 3);
        g.removeEdge(1, 2, "foo");
        g.removeEdge(1, 2, "bar");
        g.removeEdge(1, 3, "bar");
        g.removeEdge(2, 4, "baz");
        DirectedMultiGraphTest.assertEquals((int)4, (int)g.getNumVertices());
        DirectedMultiGraphTest.assertEquals((int)0, (int)g.getNumEdges());
        g.removeVertex(4);
        DirectedMultiGraphTest.assertEquals((int)3, (int)g.getNumVertices());
        DirectedMultiGraphTest.assertEquals((int)0, (int)g.getNumEdges());
        List<Integer> vertices = Arrays.asList(2, 4);
        DirectedMultiGraphTest.assertTrue((boolean)g.removeVertices(vertices));
        DirectedMultiGraphTest.assertEquals((int)2, (int)g.getNumVertices());
        DirectedMultiGraphTest.assertEquals((int)0, (int)g.getNumEdges());
        DirectedMultiGraphTest.assertFalse((boolean)g.isEmpty());
        g.removeVertex(1);
        DirectedMultiGraphTest.assertFalse((boolean)g.isEmpty());
        g.removeVertex(3);
        DirectedMultiGraphTest.assertTrue((boolean)g.isEmpty());
    }

    public void testGetAllVertices() {
        DirectedMultiGraph<Integer, String> g = new DirectedMultiGraph<Integer, String>();
        g.addVertex(1);
        DirectedMultiGraphTest.assertEquals(new HashSet<Integer>(Arrays.asList(1)), g.getAllVertices());
        g.addVertex(2);
        DirectedMultiGraphTest.assertEquals(new HashSet<Integer>(Arrays.asList(1, 2)), g.getAllVertices());
        g.add(1, 2, "foo");
        g.add(1, 2, "bar");
        g.addVertex(3);
        DirectedMultiGraphTest.assertEquals(new HashSet<Integer>(Arrays.asList(1, 2, 3)), g.getAllVertices());
        g.add(1, 3, "bar");
        g.add(2, 3, "foo");
        g.add(2, 3, "baz");
        g.add(2, 4, "baz");
        DirectedMultiGraphTest.assertEquals(new HashSet<Integer>(Arrays.asList(1, 2, 3, 4)), g.getAllVertices());
        g.removeEdges(2, 3);
        g.removeEdge(1, 2, "foo");
        g.removeEdge(1, 2, "bar");
        g.removeEdge(1, 3, "bar");
        g.removeEdge(2, 4, "baz");
        DirectedMultiGraphTest.assertEquals(new HashSet<Integer>(Arrays.asList(1, 2, 3, 4)), g.getAllVertices());
        g.removeVertex(4);
        DirectedMultiGraphTest.assertEquals(new HashSet<Integer>(Arrays.asList(1, 2, 3)), g.getAllVertices());
        g.add(1, 4, "blah");
        DirectedMultiGraphTest.assertEquals(new HashSet<Integer>(Arrays.asList(1, 2, 3, 4)), g.getAllVertices());
        g.removeZeroDegreeNodes();
        DirectedMultiGraphTest.assertEquals(new HashSet<Integer>(Arrays.asList(1, 4)), g.getAllVertices());
    }

    public void testNeighbors() {
        DirectedMultiGraph<Integer, String> g = new DirectedMultiGraph<Integer, String>();
        g.addVertex(1);
        DirectedMultiGraphTest.assertEquals(Collections.emptySet(), g.getParents(1));
        DirectedMultiGraphTest.assertEquals(Collections.emptySet(), g.getChildren(1));
        DirectedMultiGraphTest.assertEquals(Collections.emptySet(), g.getNeighbors(1));
        DirectedMultiGraphTest.assertEquals(null, g.getParents(2));
        DirectedMultiGraphTest.assertEquals(null, g.getChildren(2));
        DirectedMultiGraphTest.assertEquals(null, g.getNeighbors(2));
        g.addVertex(2);
        DirectedMultiGraphTest.assertEquals(Collections.emptySet(), g.getParents(1));
        DirectedMultiGraphTest.assertEquals(Collections.emptySet(), g.getChildren(1));
        DirectedMultiGraphTest.assertEquals(Collections.emptySet(), g.getNeighbors(1));
        DirectedMultiGraphTest.assertEquals(Collections.emptySet(), g.getParents(2));
        DirectedMultiGraphTest.assertEquals(Collections.emptySet(), g.getChildren(2));
        DirectedMultiGraphTest.assertEquals(Collections.emptySet(), g.getNeighbors(2));
        g.add(1, 2, "foo");
        DirectedMultiGraphTest.assertEquals(Collections.emptySet(), g.getParents(1));
        DirectedMultiGraphTest.assertEquals(new HashSet<Integer>(Arrays.asList(2)), g.getChildren(1));
        DirectedMultiGraphTest.assertEquals(new HashSet<Integer>(Arrays.asList(2)), g.getNeighbors(1));
        DirectedMultiGraphTest.assertEquals(new HashSet<Integer>(Arrays.asList(1)), g.getParents(2));
        DirectedMultiGraphTest.assertEquals(Collections.emptySet(), g.getChildren(2));
        DirectedMultiGraphTest.assertEquals(new HashSet<Integer>(Arrays.asList(1)), g.getNeighbors(2));
        g.add(1, 2, "bar");
        DirectedMultiGraphTest.assertEquals(Collections.emptySet(), g.getParents(1));
        DirectedMultiGraphTest.assertEquals(new HashSet<Integer>(Arrays.asList(2)), g.getChildren(1));
        DirectedMultiGraphTest.assertEquals(new HashSet<Integer>(Arrays.asList(2)), g.getNeighbors(1));
        DirectedMultiGraphTest.assertEquals(new HashSet<Integer>(Arrays.asList(1)), g.getParents(2));
        DirectedMultiGraphTest.assertEquals(Collections.emptySet(), g.getChildren(2));
        DirectedMultiGraphTest.assertEquals(new HashSet<Integer>(Arrays.asList(1)), g.getNeighbors(2));
        g.addVertex(3);
        g.add(1, 3, "bar");
        g.add(2, 3, "foo");
        g.add(2, 3, "baz");
        DirectedMultiGraphTest.assertEquals(Collections.emptySet(), g.getParents(1));
        DirectedMultiGraphTest.assertEquals(new HashSet<Integer>(Arrays.asList(2, 3)), g.getChildren(1));
        DirectedMultiGraphTest.assertEquals(new HashSet<Integer>(Arrays.asList(2, 3)), g.getNeighbors(1));
        DirectedMultiGraphTest.assertEquals(new HashSet<Integer>(Arrays.asList(1)), g.getParents(2));
        DirectedMultiGraphTest.assertEquals(new HashSet<Integer>(Arrays.asList(3)), g.getChildren(2));
        DirectedMultiGraphTest.assertEquals(new HashSet<Integer>(Arrays.asList(1, 3)), g.getNeighbors(2));
        DirectedMultiGraphTest.assertEquals(new HashSet<Integer>(Arrays.asList(1, 2)), g.getParents(3));
        DirectedMultiGraphTest.assertEquals(Collections.emptySet(), g.getChildren(3));
        DirectedMultiGraphTest.assertEquals(new HashSet<Integer>(Arrays.asList(1, 2)), g.getNeighbors(3));
        g.add(2, 4, "baz");
        DirectedMultiGraphTest.assertEquals(Collections.emptySet(), g.getParents(1));
        DirectedMultiGraphTest.assertEquals(new HashSet<Integer>(Arrays.asList(2, 3)), g.getChildren(1));
        DirectedMultiGraphTest.assertEquals(new HashSet<Integer>(Arrays.asList(2, 3)), g.getNeighbors(1));
        DirectedMultiGraphTest.assertEquals(new HashSet<Integer>(Arrays.asList(1)), g.getParents(2));
        DirectedMultiGraphTest.assertEquals(new HashSet<Integer>(Arrays.asList(3, 4)), g.getChildren(2));
        DirectedMultiGraphTest.assertEquals(new HashSet<Integer>(Arrays.asList(1, 3, 4)), g.getNeighbors(2));
        DirectedMultiGraphTest.assertEquals(new HashSet<Integer>(Arrays.asList(1, 2)), g.getParents(3));
        DirectedMultiGraphTest.assertEquals(Collections.emptySet(), g.getChildren(3));
        DirectedMultiGraphTest.assertEquals(new HashSet<Integer>(Arrays.asList(1, 2)), g.getNeighbors(3));
        DirectedMultiGraphTest.assertEquals(new HashSet<Integer>(Arrays.asList(2)), g.getParents(4));
        DirectedMultiGraphTest.assertEquals(Collections.emptySet(), g.getChildren(4));
        DirectedMultiGraphTest.assertEquals(new HashSet<Integer>(Arrays.asList(2)), g.getNeighbors(4));
        g.removeEdges(2, 3);
        DirectedMultiGraphTest.assertEquals(Collections.emptySet(), g.getParents(1));
        DirectedMultiGraphTest.assertEquals(new HashSet<Integer>(Arrays.asList(2, 3)), g.getChildren(1));
        DirectedMultiGraphTest.assertEquals(new HashSet<Integer>(Arrays.asList(2, 3)), g.getNeighbors(1));
        DirectedMultiGraphTest.assertEquals(new HashSet<Integer>(Arrays.asList(1)), g.getParents(2));
        DirectedMultiGraphTest.assertEquals(new HashSet<Integer>(Arrays.asList(4)), g.getChildren(2));
        DirectedMultiGraphTest.assertEquals(new HashSet<Integer>(Arrays.asList(1, 4)), g.getNeighbors(2));
        DirectedMultiGraphTest.assertEquals(new HashSet<Integer>(Arrays.asList(1)), g.getParents(3));
        DirectedMultiGraphTest.assertEquals(new HashSet<Integer>(Arrays.asList(1)), g.getNeighbors(3));
        DirectedMultiGraphTest.assertEquals(Collections.emptySet(), g.getChildren(3));
        DirectedMultiGraphTest.assertEquals(new HashSet<Integer>(Arrays.asList(2)), g.getParents(4));
        DirectedMultiGraphTest.assertEquals(Collections.emptySet(), g.getChildren(4));
        DirectedMultiGraphTest.assertEquals(new HashSet<Integer>(Arrays.asList(2)), g.getNeighbors(4));
        g.removeEdge(1, 2, "foo");
        DirectedMultiGraphTest.assertEquals(Collections.emptySet(), g.getParents(1));
        DirectedMultiGraphTest.assertEquals(new HashSet<Integer>(Arrays.asList(2, 3)), g.getChildren(1));
        DirectedMultiGraphTest.assertEquals(new HashSet<Integer>(Arrays.asList(2, 3)), g.getNeighbors(1));
        DirectedMultiGraphTest.assertEquals(new HashSet<Integer>(Arrays.asList(1)), g.getParents(2));
        DirectedMultiGraphTest.assertEquals(new HashSet<Integer>(Arrays.asList(4)), g.getChildren(2));
        DirectedMultiGraphTest.assertEquals(new HashSet<Integer>(Arrays.asList(1, 4)), g.getNeighbors(2));
        DirectedMultiGraphTest.assertEquals(new HashSet<Integer>(Arrays.asList(1)), g.getParents(3));
        DirectedMultiGraphTest.assertEquals(new HashSet<Integer>(Arrays.asList(1)), g.getNeighbors(3));
        DirectedMultiGraphTest.assertEquals(Collections.emptySet(), g.getChildren(3));
        DirectedMultiGraphTest.assertEquals(new HashSet<Integer>(Arrays.asList(2)), g.getParents(4));
        DirectedMultiGraphTest.assertEquals(Collections.emptySet(), g.getChildren(4));
        DirectedMultiGraphTest.assertEquals(new HashSet<Integer>(Arrays.asList(2)), g.getNeighbors(4));
        g.removeEdge(1, 2, "bar");
        DirectedMultiGraphTest.assertEquals(Collections.emptySet(), g.getParents(1));
        DirectedMultiGraphTest.assertEquals(new HashSet<Integer>(Arrays.asList(3)), g.getChildren(1));
        DirectedMultiGraphTest.assertEquals(new HashSet<Integer>(Arrays.asList(3)), g.getNeighbors(1));
        DirectedMultiGraphTest.assertEquals(Collections.emptySet(), g.getParents(2));
        DirectedMultiGraphTest.assertEquals(new HashSet<Integer>(Arrays.asList(4)), g.getChildren(2));
        DirectedMultiGraphTest.assertEquals(new HashSet<Integer>(Arrays.asList(4)), g.getNeighbors(2));
        DirectedMultiGraphTest.assertEquals(new HashSet<Integer>(Arrays.asList(1)), g.getParents(3));
        DirectedMultiGraphTest.assertEquals(Collections.emptySet(), g.getChildren(3));
        DirectedMultiGraphTest.assertEquals(new HashSet<Integer>(Arrays.asList(1)), g.getNeighbors(3));
        DirectedMultiGraphTest.assertEquals(new HashSet<Integer>(Arrays.asList(2)), g.getParents(4));
        DirectedMultiGraphTest.assertEquals(Collections.emptySet(), g.getChildren(4));
        DirectedMultiGraphTest.assertEquals(new HashSet<Integer>(Arrays.asList(2)), g.getNeighbors(4));
        g.add(1, 2, "bar");
        DirectedMultiGraphTest.assertEquals(Collections.emptySet(), g.getParents(1));
        DirectedMultiGraphTest.assertEquals(new HashSet<Integer>(Arrays.asList(2, 3)), g.getChildren(1));
        DirectedMultiGraphTest.assertEquals(new HashSet<Integer>(Arrays.asList(2, 3)), g.getNeighbors(1));
        DirectedMultiGraphTest.assertEquals(new HashSet<Integer>(Arrays.asList(1)), g.getParents(2));
        DirectedMultiGraphTest.assertEquals(new HashSet<Integer>(Arrays.asList(4)), g.getChildren(2));
        DirectedMultiGraphTest.assertEquals(new HashSet<Integer>(Arrays.asList(1, 4)), g.getNeighbors(2));
        DirectedMultiGraphTest.assertEquals(new HashSet<Integer>(Arrays.asList(1)), g.getParents(3));
        DirectedMultiGraphTest.assertEquals(new HashSet<Integer>(Arrays.asList(1)), g.getNeighbors(3));
        DirectedMultiGraphTest.assertEquals(Collections.emptySet(), g.getChildren(3));
        DirectedMultiGraphTest.assertEquals(new HashSet<Integer>(Arrays.asList(2)), g.getParents(4));
        DirectedMultiGraphTest.assertEquals(Collections.emptySet(), g.getChildren(4));
        DirectedMultiGraphTest.assertEquals(new HashSet<Integer>(Arrays.asList(2)), g.getNeighbors(4));
        g.removeVertex(2);
        DirectedMultiGraphTest.assertEquals(Collections.emptySet(), g.getParents(1));
        DirectedMultiGraphTest.assertEquals(new HashSet<Integer>(Arrays.asList(3)), g.getChildren(1));
        DirectedMultiGraphTest.assertEquals(new HashSet<Integer>(Arrays.asList(3)), g.getNeighbors(1));
        DirectedMultiGraphTest.assertEquals(null, g.getParents(2));
        DirectedMultiGraphTest.assertEquals(null, g.getChildren(2));
        DirectedMultiGraphTest.assertEquals(null, g.getNeighbors(2));
        DirectedMultiGraphTest.assertEquals(new HashSet<Integer>(Arrays.asList(1)), g.getParents(3));
        DirectedMultiGraphTest.assertEquals(Collections.emptySet(), g.getChildren(3));
        DirectedMultiGraphTest.assertEquals(new HashSet<Integer>(Arrays.asList(1)), g.getNeighbors(3));
        DirectedMultiGraphTest.assertEquals(Collections.emptySet(), g.getParents(4));
        DirectedMultiGraphTest.assertEquals(Collections.emptySet(), g.getChildren(4));
        DirectedMultiGraphTest.assertEquals(Collections.emptySet(), g.getNeighbors(4));
    }

    public void testIsNeighbor() {
        DirectedMultiGraph<Integer, String> g = new DirectedMultiGraph<Integer, String>();
        g.addVertex(1);
        g.addVertex(2);
        DirectedMultiGraphTest.assertFalse((boolean)g.isNeighbor(1, 2));
        DirectedMultiGraphTest.assertFalse((boolean)g.isNeighbor(2, 1));
        g.add(1, 2, "foo");
        DirectedMultiGraphTest.assertTrue((boolean)g.isNeighbor(1, 2));
        DirectedMultiGraphTest.assertTrue((boolean)g.isNeighbor(2, 1));
        g.add(1, 2, "bar");
        DirectedMultiGraphTest.assertTrue((boolean)g.isNeighbor(1, 2));
        DirectedMultiGraphTest.assertTrue((boolean)g.isNeighbor(2, 1));
        g.addVertex(3);
        DirectedMultiGraphTest.assertTrue((boolean)g.isNeighbor(1, 2));
        DirectedMultiGraphTest.assertTrue((boolean)g.isNeighbor(2, 1));
        DirectedMultiGraphTest.assertFalse((boolean)g.isNeighbor(1, 3));
        DirectedMultiGraphTest.assertFalse((boolean)g.isNeighbor(3, 1));
        DirectedMultiGraphTest.assertFalse((boolean)g.isNeighbor(2, 3));
        DirectedMultiGraphTest.assertFalse((boolean)g.isNeighbor(3, 2));
        g.add(1, 3, "bar");
        DirectedMultiGraphTest.assertTrue((boolean)g.isNeighbor(1, 2));
        DirectedMultiGraphTest.assertTrue((boolean)g.isNeighbor(2, 1));
        DirectedMultiGraphTest.assertTrue((boolean)g.isNeighbor(1, 3));
        DirectedMultiGraphTest.assertTrue((boolean)g.isNeighbor(3, 1));
        DirectedMultiGraphTest.assertFalse((boolean)g.isNeighbor(2, 3));
        DirectedMultiGraphTest.assertFalse((boolean)g.isNeighbor(3, 2));
        g.add(2, 3, "foo");
        g.add(2, 3, "baz");
        DirectedMultiGraphTest.assertTrue((boolean)g.isNeighbor(1, 2));
        DirectedMultiGraphTest.assertTrue((boolean)g.isNeighbor(2, 1));
        DirectedMultiGraphTest.assertTrue((boolean)g.isNeighbor(1, 3));
        DirectedMultiGraphTest.assertTrue((boolean)g.isNeighbor(3, 1));
        DirectedMultiGraphTest.assertTrue((boolean)g.isNeighbor(2, 3));
        DirectedMultiGraphTest.assertTrue((boolean)g.isNeighbor(3, 2));
        g.removeEdge(1, 2, "foo");
        DirectedMultiGraphTest.assertTrue((boolean)g.isNeighbor(1, 2));
        DirectedMultiGraphTest.assertTrue((boolean)g.isNeighbor(2, 1));
        DirectedMultiGraphTest.assertTrue((boolean)g.isNeighbor(1, 3));
        DirectedMultiGraphTest.assertTrue((boolean)g.isNeighbor(3, 1));
        DirectedMultiGraphTest.assertTrue((boolean)g.isNeighbor(2, 3));
        DirectedMultiGraphTest.assertTrue((boolean)g.isNeighbor(3, 2));
        g.removeEdge(1, 2, "bar");
        DirectedMultiGraphTest.assertFalse((boolean)g.isNeighbor(1, 2));
        DirectedMultiGraphTest.assertFalse((boolean)g.isNeighbor(2, 1));
        DirectedMultiGraphTest.assertTrue((boolean)g.isNeighbor(1, 3));
        DirectedMultiGraphTest.assertTrue((boolean)g.isNeighbor(3, 1));
        DirectedMultiGraphTest.assertTrue((boolean)g.isNeighbor(2, 3));
        DirectedMultiGraphTest.assertTrue((boolean)g.isNeighbor(3, 2));
        g.add(1, 2, "foo");
        g.add(1, 2, "bar");
        DirectedMultiGraphTest.assertTrue((boolean)g.isNeighbor(1, 2));
        DirectedMultiGraphTest.assertTrue((boolean)g.isNeighbor(2, 1));
        DirectedMultiGraphTest.assertTrue((boolean)g.isNeighbor(1, 3));
        DirectedMultiGraphTest.assertTrue((boolean)g.isNeighbor(3, 1));
        DirectedMultiGraphTest.assertTrue((boolean)g.isNeighbor(2, 3));
        DirectedMultiGraphTest.assertTrue((boolean)g.isNeighbor(3, 2));
        g.removeEdges(1, 2);
        DirectedMultiGraphTest.assertFalse((boolean)g.isNeighbor(1, 2));
        DirectedMultiGraphTest.assertFalse((boolean)g.isNeighbor(2, 1));
        DirectedMultiGraphTest.assertTrue((boolean)g.isNeighbor(1, 3));
        DirectedMultiGraphTest.assertTrue((boolean)g.isNeighbor(3, 1));
        DirectedMultiGraphTest.assertTrue((boolean)g.isNeighbor(2, 3));
        DirectedMultiGraphTest.assertTrue((boolean)g.isNeighbor(3, 2));
        g.removeVertex(2);
        DirectedMultiGraphTest.assertFalse((boolean)g.isNeighbor(1, 2));
        DirectedMultiGraphTest.assertFalse((boolean)g.isNeighbor(2, 1));
        DirectedMultiGraphTest.assertTrue((boolean)g.isNeighbor(1, 3));
        DirectedMultiGraphTest.assertTrue((boolean)g.isNeighbor(3, 1));
        DirectedMultiGraphTest.assertFalse((boolean)g.isNeighbor(2, 3));
        DirectedMultiGraphTest.assertFalse((boolean)g.isNeighbor(3, 2));
    }

    public void testDegree() {
        DirectedMultiGraph<Integer, String> g = new DirectedMultiGraph<Integer, String>();
        g.addVertex(1);
        g.addVertex(2);
        DirectedMultiGraphTest.assertEquals((int)0, (int)g.getOutDegree(1));
        DirectedMultiGraphTest.assertEquals((int)0, (int)g.getInDegree(1));
        DirectedMultiGraphTest.assertEquals((int)0, (int)g.getOutDegree(2));
        DirectedMultiGraphTest.assertEquals((int)0, (int)g.getInDegree(2));
        g.add(1, 2, "foo");
        DirectedMultiGraphTest.assertEquals((int)1, (int)g.getOutDegree(1));
        DirectedMultiGraphTest.assertEquals((int)0, (int)g.getInDegree(1));
        DirectedMultiGraphTest.assertEquals((int)0, (int)g.getOutDegree(2));
        DirectedMultiGraphTest.assertEquals((int)1, (int)g.getInDegree(2));
        g.add(1, 2, "bar");
        DirectedMultiGraphTest.assertEquals((int)2, (int)g.getOutDegree(1));
        DirectedMultiGraphTest.assertEquals((int)0, (int)g.getInDegree(1));
        DirectedMultiGraphTest.assertEquals((int)0, (int)g.getOutDegree(2));
        DirectedMultiGraphTest.assertEquals((int)2, (int)g.getInDegree(2));
        g.add(1, 3, "foo");
        DirectedMultiGraphTest.assertEquals((int)3, (int)g.getOutDegree(1));
        DirectedMultiGraphTest.assertEquals((int)0, (int)g.getInDegree(1));
        DirectedMultiGraphTest.assertEquals((int)0, (int)g.getOutDegree(2));
        DirectedMultiGraphTest.assertEquals((int)2, (int)g.getInDegree(2));
        DirectedMultiGraphTest.assertEquals((int)0, (int)g.getOutDegree(3));
        DirectedMultiGraphTest.assertEquals((int)1, (int)g.getInDegree(3));
        g.add(2, 3, "foo");
        DirectedMultiGraphTest.assertEquals((int)3, (int)g.getOutDegree(1));
        DirectedMultiGraphTest.assertEquals((int)0, (int)g.getInDegree(1));
        DirectedMultiGraphTest.assertEquals((int)1, (int)g.getOutDegree(2));
        DirectedMultiGraphTest.assertEquals((int)2, (int)g.getInDegree(2));
        DirectedMultiGraphTest.assertEquals((int)0, (int)g.getOutDegree(3));
        DirectedMultiGraphTest.assertEquals((int)2, (int)g.getInDegree(3));
        g.removeVertex(2);
        DirectedMultiGraphTest.assertEquals((int)1, (int)g.getOutDegree(1));
        DirectedMultiGraphTest.assertEquals((int)0, (int)g.getInDegree(1));
        DirectedMultiGraphTest.assertEquals((int)0, (int)g.getOutDegree(3));
        DirectedMultiGraphTest.assertEquals((int)1, (int)g.getInDegree(3));
        g.add(2, 1, "foo");
        DirectedMultiGraphTest.assertEquals((int)1, (int)g.getOutDegree(1));
        DirectedMultiGraphTest.assertEquals((int)1, (int)g.getInDegree(1));
        DirectedMultiGraphTest.assertEquals((int)1, (int)g.getOutDegree(2));
        DirectedMultiGraphTest.assertEquals((int)0, (int)g.getInDegree(2));
        DirectedMultiGraphTest.assertEquals((int)0, (int)g.getOutDegree(3));
        DirectedMultiGraphTest.assertEquals((int)1, (int)g.getInDegree(3));
        g.add(2, 1, "bar");
        DirectedMultiGraphTest.assertEquals((int)1, (int)g.getOutDegree(1));
        DirectedMultiGraphTest.assertEquals((int)2, (int)g.getInDegree(1));
        DirectedMultiGraphTest.assertEquals((int)2, (int)g.getOutDegree(2));
        DirectedMultiGraphTest.assertEquals((int)0, (int)g.getInDegree(2));
        DirectedMultiGraphTest.assertEquals((int)0, (int)g.getOutDegree(3));
        DirectedMultiGraphTest.assertEquals((int)1, (int)g.getInDegree(3));
        g.add(2, 1, "baz");
        DirectedMultiGraphTest.assertEquals((int)1, (int)g.getOutDegree(1));
        DirectedMultiGraphTest.assertEquals((int)3, (int)g.getInDegree(1));
        DirectedMultiGraphTest.assertEquals((int)3, (int)g.getOutDegree(2));
        DirectedMultiGraphTest.assertEquals((int)0, (int)g.getInDegree(2));
        DirectedMultiGraphTest.assertEquals((int)0, (int)g.getOutDegree(3));
        DirectedMultiGraphTest.assertEquals((int)1, (int)g.getInDegree(3));
        g.removeEdge(2, 1, "blah");
        DirectedMultiGraphTest.assertEquals((int)1, (int)g.getOutDegree(1));
        DirectedMultiGraphTest.assertEquals((int)3, (int)g.getInDegree(1));
        DirectedMultiGraphTest.assertEquals((int)3, (int)g.getOutDegree(2));
        DirectedMultiGraphTest.assertEquals((int)0, (int)g.getInDegree(2));
        DirectedMultiGraphTest.assertEquals((int)0, (int)g.getOutDegree(3));
        DirectedMultiGraphTest.assertEquals((int)1, (int)g.getInDegree(3));
        g.removeEdge(2, 1, "bar");
        DirectedMultiGraphTest.assertEquals((int)1, (int)g.getOutDegree(1));
        DirectedMultiGraphTest.assertEquals((int)2, (int)g.getInDegree(1));
        DirectedMultiGraphTest.assertEquals((int)2, (int)g.getOutDegree(2));
        DirectedMultiGraphTest.assertEquals((int)0, (int)g.getInDegree(2));
        DirectedMultiGraphTest.assertEquals((int)0, (int)g.getOutDegree(3));
        DirectedMultiGraphTest.assertEquals((int)1, (int)g.getInDegree(3));
        g.removeEdges(2, 1);
        DirectedMultiGraphTest.assertEquals((int)1, (int)g.getOutDegree(1));
        DirectedMultiGraphTest.assertEquals((int)0, (int)g.getInDegree(1));
        DirectedMultiGraphTest.assertEquals((int)0, (int)g.getOutDegree(2));
        DirectedMultiGraphTest.assertEquals((int)0, (int)g.getInDegree(2));
        DirectedMultiGraphTest.assertEquals((int)0, (int)g.getOutDegree(3));
        DirectedMultiGraphTest.assertEquals((int)1, (int)g.getInDegree(3));
        g.add(2, 3, "bar");
        g.add(3, 4, "bar");
        g.add(3, 5, "bar");
        g.add(3, 6, "bar");
        g.add(3, 7, "bar");
        g.add(3, 8, "bar");
        g.add(3, 9, "bar");
        g.add(3, 10, "bar");
        g.add(3, 10, "foo");
        DirectedMultiGraphTest.assertEquals((int)1, (int)g.getOutDegree(1));
        DirectedMultiGraphTest.assertEquals((int)0, (int)g.getInDegree(1));
        DirectedMultiGraphTest.assertEquals((int)1, (int)g.getOutDegree(2));
        DirectedMultiGraphTest.assertEquals((int)0, (int)g.getInDegree(2));
        DirectedMultiGraphTest.assertEquals((int)8, (int)g.getOutDegree(3));
        DirectedMultiGraphTest.assertEquals((int)2, (int)g.getInDegree(3));
    }

    public <E> void checkIterator(Iterable<E> edges, E ... expected) {
        HashSet<E> expectedSet = new HashSet<E>(Arrays.asList(expected));
        HashSet<E> foundSet = new HashSet<E>();
        for (E edge : edges) {
            if (foundSet.contains(edge)) {
                throw new AssertionError((Object)("Received two copies of " + edge + " when running an edge iterator"));
            }
            foundSet.add(edge);
        }
        DirectedMultiGraphTest.assertEquals(expectedSet, foundSet);
    }

    public void testIterables() {
        DirectedMultiGraph<Integer, String> g = new DirectedMultiGraph<Integer, String>();
        g.addVertex(1);
        g.addVertex(2);
        this.checkIterator(g.incomingEdgeIterable(1), new String[0]);
        this.checkIterator(g.outgoingEdgeIterable(1), new String[0]);
        this.checkIterator(g.incomingEdgeIterable(2), new String[0]);
        this.checkIterator(g.outgoingEdgeIterable(2), new String[0]);
        this.checkIterator(g.edgeIterable(), new String[0]);
        g.add(1, 2, "1-2");
        this.checkIterator(g.incomingEdgeIterable(1), new String[0]);
        this.checkIterator(g.outgoingEdgeIterable(1), "1-2");
        this.checkIterator(g.incomingEdgeIterable(2), "1-2");
        this.checkIterator(g.outgoingEdgeIterable(2), new String[0]);
        this.checkIterator(g.edgeIterable(), "1-2");
        g.add(1, 2, "1-2b");
        this.checkIterator(g.incomingEdgeIterable(1), new String[0]);
        this.checkIterator(g.outgoingEdgeIterable(1), "1-2", "1-2b");
        this.checkIterator(g.incomingEdgeIterable(2), "1-2", "1-2b");
        this.checkIterator(g.outgoingEdgeIterable(2), new String[0]);
        this.checkIterator(g.edgeIterable(), "1-2", "1-2b");
        g.add(1, 3, "1-3");
        this.checkIterator(g.incomingEdgeIterable(1), new String[0]);
        this.checkIterator(g.outgoingEdgeIterable(1), "1-2", "1-2b", "1-3");
        this.checkIterator(g.incomingEdgeIterable(2), "1-2", "1-2b");
        this.checkIterator(g.outgoingEdgeIterable(2), new String[0]);
        this.checkIterator(g.incomingEdgeIterable(3), "1-3");
        this.checkIterator(g.outgoingEdgeIterable(3), new String[0]);
        this.checkIterator(g.edgeIterable(), "1-2", "1-2b", "1-3");
        this.checkIterator(g.getEdges(1, 2), "1-2", "1-2b");
        this.checkIterator(g.getEdges(1, 3), "1-3");
        g.add(1, 3, "1-3b");
        this.checkIterator(g.incomingEdgeIterable(1), new String[0]);
        this.checkIterator(g.outgoingEdgeIterable(1), "1-2", "1-2b", "1-3", "1-3b");
        this.checkIterator(g.incomingEdgeIterable(2), "1-2", "1-2b");
        this.checkIterator(g.outgoingEdgeIterable(2), new String[0]);
        this.checkIterator(g.incomingEdgeIterable(3), "1-3", "1-3b");
        this.checkIterator(g.outgoingEdgeIterable(3), new String[0]);
        this.checkIterator(g.edgeIterable(), "1-2", "1-2b", "1-3", "1-3b");
        g.removeEdge(1, 3, "1-3b");
        this.checkIterator(g.incomingEdgeIterable(1), new String[0]);
        this.checkIterator(g.outgoingEdgeIterable(1), "1-2", "1-2b", "1-3");
        this.checkIterator(g.incomingEdgeIterable(2), "1-2", "1-2b");
        this.checkIterator(g.outgoingEdgeIterable(2), new String[0]);
        this.checkIterator(g.incomingEdgeIterable(3), "1-3");
        this.checkIterator(g.outgoingEdgeIterable(3), new String[0]);
        this.checkIterator(g.edgeIterable(), "1-2", "1-2b", "1-3");
        g.removeEdge(1, 3, "1-3b");
        this.checkIterator(g.incomingEdgeIterable(1), new String[0]);
        this.checkIterator(g.outgoingEdgeIterable(1), "1-2", "1-2b", "1-3");
        this.checkIterator(g.incomingEdgeIterable(2), "1-2", "1-2b");
        this.checkIterator(g.outgoingEdgeIterable(2), new String[0]);
        this.checkIterator(g.incomingEdgeIterable(3), "1-3");
        this.checkIterator(g.outgoingEdgeIterable(3), new String[0]);
        this.checkIterator(g.edgeIterable(), "1-2", "1-2b", "1-3");
        g.removeEdge(1, 3, "1-3");
        this.checkIterator(g.incomingEdgeIterable(1), new String[0]);
        this.checkIterator(g.outgoingEdgeIterable(1), "1-2", "1-2b");
        this.checkIterator(g.incomingEdgeIterable(2), "1-2", "1-2b");
        this.checkIterator(g.outgoingEdgeIterable(2), new String[0]);
        this.checkIterator(g.incomingEdgeIterable(3), new String[0]);
        this.checkIterator(g.outgoingEdgeIterable(3), new String[0]);
        this.checkIterator(g.edgeIterable(), "1-2", "1-2b");
        g.add(1, 3, "1-3");
        g.add(1, 3, "1-3b");
        this.checkIterator(g.incomingEdgeIterable(1), new String[0]);
        this.checkIterator(g.outgoingEdgeIterable(1), "1-2", "1-2b", "1-3", "1-3b");
        this.checkIterator(g.incomingEdgeIterable(2), "1-2", "1-2b");
        this.checkIterator(g.outgoingEdgeIterable(2), new String[0]);
        this.checkIterator(g.incomingEdgeIterable(3), "1-3", "1-3b");
        this.checkIterator(g.outgoingEdgeIterable(3), new String[0]);
        this.checkIterator(g.edgeIterable(), "1-2", "1-2b", "1-3", "1-3b");
        g.add(1, 1, "1-1");
        this.checkIterator(g.incomingEdgeIterable(1), "1-1");
        this.checkIterator(g.outgoingEdgeIterable(1), "1-1", "1-2", "1-2b", "1-3", "1-3b");
        this.checkIterator(g.incomingEdgeIterable(2), "1-2", "1-2b");
        this.checkIterator(g.outgoingEdgeIterable(2), new String[0]);
        this.checkIterator(g.incomingEdgeIterable(3), "1-3", "1-3b");
        this.checkIterator(g.outgoingEdgeIterable(3), new String[0]);
        this.checkIterator(g.edgeIterable(), "1-1", "1-2", "1-2b", "1-3", "1-3b");
        g.add(2, 1, "2-1");
        this.checkIterator(g.incomingEdgeIterable(1), "1-1", "2-1");
        this.checkIterator(g.outgoingEdgeIterable(1), "1-1", "1-2", "1-2b", "1-3", "1-3b");
        this.checkIterator(g.incomingEdgeIterable(2), "1-2", "1-2b");
        this.checkIterator(g.outgoingEdgeIterable(2), "2-1");
        this.checkIterator(g.incomingEdgeIterable(3), "1-3", "1-3b");
        this.checkIterator(g.outgoingEdgeIterable(3), new String[0]);
        this.checkIterator(g.edgeIterable(), "1-1", "1-2", "1-2b", "1-3", "1-3b", "2-1");
        this.checkIterator(g.getEdges(1, 1), "1-1");
        this.checkIterator(g.getEdges(1, 2), "1-2", "1-2b");
        this.checkIterator(g.getEdges(1, 3), "1-3", "1-3b");
        this.checkIterator(g.getEdges(3, 1), new String[0]);
        g.removeVertex(2);
        this.checkIterator(g.incomingEdgeIterable(1), "1-1");
        this.checkIterator(g.outgoingEdgeIterable(1), "1-1", "1-3", "1-3b");
        this.checkIterator(g.incomingEdgeIterable(3), "1-3", "1-3b");
        this.checkIterator(g.outgoingEdgeIterable(3), new String[0]);
        this.checkIterator(g.edgeIterable(), "1-1", "1-3", "1-3b");
    }

    public void testCopyConstructor() {
        DirectedMultiGraph<Integer, String> g = new DirectedMultiGraph<Integer, String>();
        g.addVertex(1);
        g.addVertex(2);
        g.addVertex(3);
        g.add(1, 2, "1-2a");
        g.add(1, 2, "1-2b");
        g.add(1, 2, "1-2c");
        g.add(1, 3, "1-3a");
        g.add(1, 3, "1-3b");
        g.add(2, 3, "2-3a");
        g.add(2, 3, "2-3b");
        g.add(3, 1, "3-1a");
        g.add(3, 1, "3-1b");
        DirectedMultiGraph<Integer, String> copy = new DirectedMultiGraph<Integer, String>(g);
        DirectedMultiGraphTest.assertEquals((int)g.getNumEdges(), (int)copy.getNumEdges());
        int originalSize = g.getNumEdges();
        DirectedMultiGraphTest.assertEquals((int)originalSize, (int)g.getNumEdges());
        copy.removeEdge(1, 2, "1-2b");
        DirectedMultiGraphTest.assertEquals((int)(originalSize - 1), (int)copy.getNumEdges());
        DirectedMultiGraphTest.assertEquals((int)originalSize, (int)g.getNumEdges());
        copy.removeVertex(3);
        DirectedMultiGraphTest.assertEquals((int)(originalSize - 7), (int)copy.getNumEdges());
        DirectedMultiGraphTest.assertEquals((int)originalSize, (int)g.getNumEdges());
    }

    public void testIteratorRemove() {
        DirectedMultiGraph<Integer, String> g = new DirectedMultiGraph<Integer, String>();
        g.addVertex(1);
        g.addVertex(2);
        g.addVertex(3);
        g.add(1, 2, "1-2a");
        g.add(1, 2, "1-2b");
        g.add(1, 2, "1-2c");
        g.add(1, 3, "1-3a");
        g.add(1, 3, "1-3b");
        g.add(2, 3, "2-3a");
        g.add(2, 3, "2-3b");
        g.add(3, 1, "3-1a");
        g.add(3, 1, "3-1b");
        this.checkGraphConsistency(g);
        for (String edge : g.getAllEdges()) {
            int originalSize = g.getNumEdges();
            DirectedMultiGraph<Integer, String> gold = new DirectedMultiGraph<Integer, String>(g);
            DirectedMultiGraph guess = new DirectedMultiGraph(g);
            gold.removeEdge(Integer.parseInt(edge.substring(0, 1)), Integer.parseInt(edge.substring(2, 3)), edge);
            DirectedMultiGraphTest.assertEquals((int)originalSize, (int)g.getNumEdges());
            DirectedMultiGraphTest.assertEquals((int)(originalSize - 1), (int)gold.getAllEdges().size());
            Iterator iter = guess.edgeIterator();
            int iterations = 0;
            while (iter.hasNext()) {
                ++iterations;
                if (!((String)iter.next()).equals(edge)) continue;
                iter.remove();
                this.checkGraphConsistency(guess);
            }
            DirectedMultiGraphTest.assertEquals((int)9, (int)iterations);
            this.checkGraphConsistency(guess);
            DirectedMultiGraphTest.assertEquals(gold, guess);
        }
    }

    public void testLoops() {
        DirectedMultiGraph<Integer, String> g = new DirectedMultiGraph<Integer, String>();
        g.addVertex(1);
        g.addVertex(2);
        g.add(1, 1, "1-1");
        g.add(1, 2, "1-2");
        g.add(2, 1, "2-1");
        this.checkIterator(g.incomingEdgeIterable(1), "1-1", "2-1");
        this.checkIterator(g.outgoingEdgeIterable(1), "1-1", "1-2");
        this.checkIterator(g.incomingEdgeIterable(2), "1-2");
        this.checkIterator(g.outgoingEdgeIterable(2), "2-1");
        this.checkIterator(g.edgeIterable(), "1-1", "1-2", "2-1");
        g.removeVertex(1);
        this.checkIterator(g.incomingEdgeIterable(2), new String[0]);
        this.checkIterator(g.outgoingEdgeIterable(2), new String[0]);
        this.checkIterator(g.edgeIterable(), new String[0]);
        g.addVertex(1);
        this.checkIterator(g.incomingEdgeIterable(1), new String[0]);
        this.checkIterator(g.outgoingEdgeIterable(1), new String[0]);
        this.checkIterator(g.incomingEdgeIterable(2), new String[0]);
        this.checkIterator(g.outgoingEdgeIterable(2), new String[0]);
        this.checkIterator(g.edgeIterable(), new String[0]);
        g.add(1, 1, "1-1");
        g.add(1, 2, "1-2");
        g.add(2, 1, "2-1");
        this.checkIterator(g.incomingEdgeIterable(1), "1-1", "2-1");
        this.checkIterator(g.outgoingEdgeIterable(1), "1-1", "1-2");
        this.checkIterator(g.incomingEdgeIterable(2), "1-2");
        this.checkIterator(g.outgoingEdgeIterable(2), "2-1");
        this.checkIterator(g.edgeIterable(), "1-1", "1-2", "2-1");
        g.removeEdge(1, 1, "1-1");
        this.checkIterator(g.incomingEdgeIterable(1), "2-1");
        this.checkIterator(g.outgoingEdgeIterable(1), "1-2");
        this.checkIterator(g.incomingEdgeIterable(2), "1-2");
        this.checkIterator(g.outgoingEdgeIterable(2), "2-1");
        this.checkIterator(g.edgeIterable(), "1-2", "2-1");
        g.add(1, 1, "1-1");
        this.checkIterator(g.incomingEdgeIterable(1), "1-1", "2-1");
        this.checkIterator(g.outgoingEdgeIterable(1), "1-1", "1-2");
        this.checkIterator(g.incomingEdgeIterable(2), "1-2");
        this.checkIterator(g.outgoingEdgeIterable(2), "2-1");
        this.checkIterator(g.edgeIterable(), "1-1", "1-2", "2-1");
        g.removeEdges(1, 1);
        this.checkIterator(g.incomingEdgeIterable(1), "2-1");
        this.checkIterator(g.outgoingEdgeIterable(1), "1-2");
        this.checkIterator(g.incomingEdgeIterable(2), "1-2");
        this.checkIterator(g.outgoingEdgeIterable(2), "2-1");
        this.checkIterator(g.edgeIterable(), "1-2", "2-1");
        g.add(1, 1, "1-1");
        this.checkIterator(g.incomingEdgeIterable(1), "1-1", "2-1");
        this.checkIterator(g.outgoingEdgeIterable(1), "1-1", "1-2");
        this.checkIterator(g.incomingEdgeIterable(2), "1-2");
        this.checkIterator(g.outgoingEdgeIterable(2), "2-1");
        this.checkIterator(g.edgeIterable(), "1-1", "1-2", "2-1");
        g.removeEdges(1, 2);
        this.checkIterator(g.incomingEdgeIterable(1), "1-1", "2-1");
        this.checkIterator(g.outgoingEdgeIterable(1), "1-1");
        this.checkIterator(g.incomingEdgeIterable(2), new String[0]);
        this.checkIterator(g.outgoingEdgeIterable(2), "2-1");
        this.checkIterator(g.edgeIterable(), "1-1", "2-1");
        g.add(1, 2, "1-2");
        this.checkIterator(g.incomingEdgeIterable(1), "1-1", "2-1");
        this.checkIterator(g.outgoingEdgeIterable(1), "1-1", "1-2");
        this.checkIterator(g.incomingEdgeIterable(2), "1-2");
        this.checkIterator(g.outgoingEdgeIterable(2), "2-1");
        this.checkIterator(g.edgeIterable(), "1-1", "1-2", "2-1");
        g.removeEdges(2, 1);
        this.checkIterator(g.incomingEdgeIterable(1), "1-1");
        this.checkIterator(g.outgoingEdgeIterable(1), "1-1", "1-2");
        this.checkIterator(g.incomingEdgeIterable(2), "1-2");
        this.checkIterator(g.outgoingEdgeIterable(2), new String[0]);
        this.checkIterator(g.edgeIterable(), "1-1", "1-2");
    }
}

