/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.classify;

import edu.stanford.nlp.classify.Classifier;
import edu.stanford.nlp.classify.Dataset;
import edu.stanford.nlp.classify.GeneralDataset;
import edu.stanford.nlp.classify.LinearClassifier;
import edu.stanford.nlp.classify.LinearClassifierFactory;
import edu.stanford.nlp.ling.BasicDatum;
import edu.stanford.nlp.stats.Counter;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;

public class DatasetTest {
    @Test
    public void testDataset() {
        Dataset<String, String> data = new Dataset<String, String>();
        data.add(new BasicDatum<String, String>(Arrays.asList("fever", "cough", "congestion"), "cold"));
        data.add(new BasicDatum<String, String>(Arrays.asList("fever", "cough", "nausea"), "flu"));
        data.add(new BasicDatum<String, String>(Arrays.asList("cough", "congestion"), "cold"));
        Assert.assertEquals((long)4L, (long)data.numFeatures());
        Assert.assertEquals((long)4L, (long)data.numFeatureTypes());
        Assert.assertEquals((long)2L, (long)data.numClasses());
        Assert.assertEquals((long)8L, (long)data.numFeatureTokens());
        Assert.assertEquals((long)3L, (long)data.size());
        data.applyFeatureCountThreshold(2);
        Assert.assertEquals((long)3L, (long)data.numFeatures());
        Assert.assertEquals((long)3L, (long)data.numFeatureTypes());
        Assert.assertEquals((long)2L, (long)data.numClasses());
        Assert.assertEquals((long)7L, (long)data.numFeatureTokens());
        Assert.assertEquals((long)3L, (long)data.size());
        LinearClassifierFactory factory = new LinearClassifierFactory();
        Classifier classifier = factory.trainClassifier((GeneralDataset)data);
        BasicDatum d = new BasicDatum(Arrays.asList("cough", "fever"));
        Assert.assertEquals((String)"Classification incorrect", (Object)"flu", ((LinearClassifier)classifier).classOf(d));
        Counter probs = ((LinearClassifier)classifier).probabilityOf(d);
        Assert.assertEquals((String)"Returned probability incorrect", (double)0.4553, (double)probs.getCount("cold"), (double)1.0E-4);
        Assert.assertEquals((String)"Returned probability incorrect", (double)0.5447, (double)probs.getCount("flu"), (double)1.0E-4);
        System.out.println();
    }
}

