/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.classify;

import edu.stanford.nlp.classify.ColumnDataClassifier;
import edu.stanford.nlp.io.IOUtils;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import junit.framework.TestCase;

public class ColumnDataClassifierITest
extends TestCase {
    public static void runAndTestCDC(String goldFileName, String ... args) throws IOException {
        String line;
        PrintStream oldOut = System.out;
        PrintStream oldErr = System.err;
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        ByteArrayOutputStream errStream = new ByteArrayOutputStream();
        PrintStream outPrint = new PrintStream(outStream);
        PrintStream errPrint = new PrintStream(errStream);
        System.setOut(outPrint);
        System.setErr(errPrint);
        ColumnDataClassifier.main(args);
        System.setOut(oldOut);
        System.setErr(oldErr);
        BufferedReader goldFile = IOUtils.readerFromString(goldFileName);
        ArrayList<String> lines = new ArrayList<String>();
        while ((line = goldFile.readLine()) != null) {
            lines.add(line.trim().replaceAll("\\s+", " "));
        }
        String[] result = outStream.toString().trim().split("\n");
        ColumnDataClassifierITest.assertEquals((int)lines.size(), (int)result.length);
        for (int i = 0; i < result.length; ++i) {
            String goldLine = (String)lines.get(i);
            String resultLine = result[i].trim().replaceAll("\\s+", " ");
            ColumnDataClassifierITest.assertEquals((String)goldLine, (String)resultLine);
        }
    }

    public void testNoArgClassify() throws IOException {
        ColumnDataClassifierITest.runAndTestCDC("projects/core/data/edu/stanford/nlp/classify/iris.gold", "-prop", "projects/core/data/edu/stanford/nlp/classify/iris.prop");
    }
}

