/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.generator.java.math;

import com.pholser.junit.quickcheck.generator.GenerationStatus;
import com.pholser.junit.quickcheck.generator.Generator;
import com.pholser.junit.quickcheck.generator.InRange;
import com.pholser.junit.quickcheck.internal.Ranges;
import com.pholser.junit.quickcheck.internal.Reflection;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import java.math.BigInteger;

public class BigIntegerGenerator
extends Generator<BigInteger> {
    private BigInteger min;
    private BigInteger max;

    public BigIntegerGenerator() {
        super(BigInteger.class);
    }

    public void configure(InRange range) {
        if (!Reflection.defaultValueOf(InRange.class, (String)"min").equals(range.min())) {
            this.min = new BigInteger(range.min());
        }
        if (!Reflection.defaultValueOf(InRange.class, (String)"max").equals(range.max())) {
            this.max = new BigInteger(range.max());
        }
        if (this.min != null && this.max != null) {
            Ranges.checkRange((Ranges.Type)Ranges.Type.INTEGRAL, (Comparable)this.min, (Comparable)this.max);
        }
    }

    public BigInteger generate(SourceOfRandomness random, GenerationStatus status) {
        int numberOfBits = status.size() + 1;
        if (this.min == null && this.max == null) {
            return random.nextBigInteger(numberOfBits);
        }
        BigInteger minToUse = this.min;
        BigInteger maxToUse = this.max;
        if (minToUse == null) {
            minToUse = maxToUse.subtract(BigInteger.TEN.pow(numberOfBits));
        } else if (maxToUse == null) {
            maxToUse = minToUse.add(BigInteger.TEN.pow(numberOfBits));
        }
        return Ranges.choose((SourceOfRandomness)random, (BigInteger)minToUse, (BigInteger)maxToUse);
    }
}

