/*
 * Decompiled with CFR 0.152.
 */
package jflex.gui;

import java.io.File;
import jflex.ErrorMessages;
import jflex.GeneratorException;
import jflex.Main;
import jflex.Options;
import jflex.Out;
import jflex.gui.MainFrame;

public class GeneratorThread
extends Thread {
    private static volatile boolean running = false;
    String inputFile;
    String outputDir;
    MainFrame parent;

    public GeneratorThread(MainFrame parent, String inputFile, String outputDir) {
        this.parent = parent;
        this.inputFile = inputFile;
        this.outputDir = outputDir;
    }

    public void run() {
        if (running) {
            Out.error(ErrorMessages.ALREADY_RUNNING);
            this.parent.generationFinished(false);
        } else {
            running = true;
            this.setPriority(1);
            try {
                if (!this.outputDir.equals("")) {
                    Options.setDir(this.outputDir);
                }
                Main.generate(new File(this.inputFile));
                Out.statistics();
                this.parent.generationFinished(true);
            }
            catch (GeneratorException e) {
                Out.statistics();
                this.parent.generationFinished(false);
            }
            finally {
                running = false;
            }
        }
    }
}

