/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.simple;

import org.ejml.data.Complex64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.factory.DecompositionFactory;
import org.ejml.factory.EigenDecomposition;
import org.ejml.simple.SimpleMatrix;

public class SimpleEVD<T extends SimpleMatrix> {
    private EigenDecomposition<DenseMatrix64F> eig;
    DenseMatrix64F mat;

    public SimpleEVD(DenseMatrix64F denseMatrix64F) {
        this.mat = denseMatrix64F;
        this.eig = DecompositionFactory.eig(denseMatrix64F.numCols, true);
        if (!this.eig.decompose(denseMatrix64F)) {
            throw new RuntimeException("Eigenvalue Decomposition failed");
        }
    }

    public int getNumberOfEigenvalues() {
        return this.eig.getNumberOfEigenvalues();
    }

    public Complex64F getEigenvalue(int n) {
        return this.eig.getEigenvalue(n);
    }

    public T getEigenVector(int n) {
        return (T)SimpleMatrix.wrap(this.eig.getEigenVector(n));
    }

    public double quality() {
        return DecompositionFactory.quality(this.mat, this.eig);
    }

    public EigenDecomposition getEVD() {
        return this.eig;
    }

    public int getIndexMax() {
        int n = 0;
        double d = this.getEigenvalue(0).getMagnitude2();
        int n2 = this.getNumberOfEigenvalues();
        for (int i = 1; i < n2; ++i) {
            double d2 = this.getEigenvalue(i).getMagnitude2();
            if (!(d2 > d)) continue;
            d = d2;
            n = i;
        }
        return n;
    }

    public int getIndexMin() {
        int n = 0;
        double d = this.getEigenvalue(0).getMagnitude2();
        int n2 = this.getNumberOfEigenvalues();
        for (int i = 1; i < n2; ++i) {
            double d2 = this.getEigenvalue(i).getMagnitude2();
            if (!(d2 < d)) continue;
            d = d2;
            n = i;
        }
        return n;
    }
}

