/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.linsol.qr;

import org.ejml.alg.dense.decomposition.TriangularSolver;
import org.ejml.alg.dense.decomposition.qr.QRColPivDecompositionHouseholderColumn;
import org.ejml.alg.dense.decomposition.qr.QrHelperFunctions;
import org.ejml.alg.dense.linsol.qr.BaseLinearSolverQrp;
import org.ejml.data.DenseMatrix64F;

public class LinearSolverQrpHouseCol
extends BaseLinearSolverQrp {
    private QRColPivDecompositionHouseholderColumn decomposition;
    private DenseMatrix64F x_basic = new DenseMatrix64F(1, 1);

    public LinearSolverQrpHouseCol(QRColPivDecompositionHouseholderColumn qRColPivDecompositionHouseholderColumn, boolean bl) {
        super(qRColPivDecompositionHouseholderColumn, bl);
        this.decomposition = qRColPivDecompositionHouseholderColumn;
    }

    @Override
    public void solve(DenseMatrix64F denseMatrix64F, DenseMatrix64F denseMatrix64F2) {
        if (denseMatrix64F2.numRows != this.numCols) {
            throw new IllegalArgumentException("Unexpected dimensions for X");
        }
        if (denseMatrix64F.numRows != this.numRows || denseMatrix64F.numCols != denseMatrix64F2.numCols) {
            throw new IllegalArgumentException("Unexpected dimensions for B");
        }
        int n = denseMatrix64F.numCols;
        int[] nArray = this.decomposition.getPivots();
        double[][] dArray = this.decomposition.getQR();
        double[] dArray2 = this.decomposition.getGammas();
        for (int i = 0; i < n; ++i) {
            int n2;
            this.x_basic.reshape(this.numRows, 1);
            this.Y.reshape(this.numRows, 1);
            for (n2 = 0; n2 < this.numRows; ++n2) {
                this.x_basic.data[n2] = denseMatrix64F.get(n2, i);
            }
            for (n2 = 0; n2 < this.rank; ++n2) {
                double[] dArray3 = dArray[n2];
                double d = dArray3[n2];
                dArray3[n2] = 1.0;
                QrHelperFunctions.rank1UpdateMultR(this.x_basic, dArray3, dArray2[n2], 0, n2, this.numRows, this.Y.data);
                dArray3[n2] = d;
            }
            TriangularSolver.solveU(this.R11.data, this.x_basic.data, this.rank);
            this.x_basic.reshape(this.numCols, 1, true);
            for (n2 = this.rank; n2 < this.numCols; ++n2) {
                this.x_basic.data[n2] = 0.0;
            }
            if (this.norm2Solution && this.rank < this.numCols) {
                this.upgradeSolution(this.x_basic);
            }
            for (n2 = 0; n2 < this.numCols; ++n2) {
                denseMatrix64F2.set(nArray[n2], i, this.x_basic.data[n2]);
            }
        }
    }

    @Override
    public boolean modifiesA() {
        return this.decomposition.inputModified();
    }

    @Override
    public boolean modifiesB() {
        return false;
    }
}

