/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.decomposition.svd.implicitqr;

import java.util.Random;
import org.ejml.UtilEjml;
import org.ejml.alg.dense.decomposition.eig.EigenvalueSmall;
import org.ejml.data.DenseMatrix64F;
import org.ejml.simple.SimpleMatrix;

public class SvdImplicitQrAlgorithm {
    protected Random rand = new Random(3434270L);
    protected DenseMatrix64F Ut;
    protected DenseMatrix64F Vt;
    protected int totalSteps;
    protected double maxValue;
    protected int N;
    protected EigenvalueSmall eigenSmall = new EigenvalueSmall();
    protected int numExceptional;
    protected int nextExceptional;
    protected double[] diag;
    protected double[] off;
    double bulge;
    protected int x1;
    protected int x2;
    int steps;
    protected int[] splits;
    protected int numSplits;
    private int exceptionalThresh = 15;
    private int maxIterations = this.exceptionalThresh * 100;
    boolean followScript;
    private static final int giveUpOnKnown = 10;
    private double[] values;
    private boolean fastValues = false;
    private boolean findingZeros;
    double c;
    double s;

    public SvdImplicitQrAlgorithm(boolean bl) {
        this.fastValues = bl;
    }

    public SvdImplicitQrAlgorithm() {
    }

    public DenseMatrix64F getUt() {
        return this.Ut;
    }

    public void setUt(DenseMatrix64F denseMatrix64F) {
        this.Ut = denseMatrix64F;
    }

    public DenseMatrix64F getVt() {
        return this.Vt;
    }

    public void setVt(DenseMatrix64F denseMatrix64F) {
        this.Vt = denseMatrix64F;
    }

    public void setMatrix(int n, int n2, double[] dArray, double[] dArray2) {
        this.initParam(n, n2);
        this.diag = dArray;
        this.off = dArray2;
        this.maxValue = Math.abs(dArray[0]);
        for (int i = 1; i < this.N; ++i) {
            double d = Math.abs(dArray[i]);
            double d2 = Math.abs(dArray2[i - 1]);
            if (d > this.maxValue) {
                this.maxValue = Math.abs(d);
            }
            if (!(d2 > this.maxValue)) continue;
            this.maxValue = Math.abs(d2);
        }
    }

    public double[] swapDiag(double[] dArray) {
        double[] dArray2 = this.diag;
        this.diag = dArray;
        return dArray2;
    }

    public double[] swapOff(double[] dArray) {
        double[] dArray2 = this.off;
        this.off = dArray;
        return dArray2;
    }

    public void setMaxValue(double d) {
        this.maxValue = d;
    }

    public void initParam(int n, int n2) {
        if (n2 > n) {
            throw new RuntimeException("Must be a square or tall matrix");
        }
        this.N = n2;
        if (this.splits == null || this.splits.length < n2) {
            this.splits = new int[n2];
        }
        this.x1 = 0;
        this.x2 = this.N - 1;
        this.steps = 0;
        this.totalSteps = 0;
        this.numSplits = 0;
        this.numExceptional = 0;
        this.nextExceptional = this.exceptionalThresh;
    }

    public boolean process() {
        this.followScript = false;
        this.findingZeros = true;
        return this._process();
    }

    public boolean process(double[] dArray) {
        this.followScript = true;
        this.values = dArray;
        this.findingZeros = false;
        return this._process();
    }

    public boolean _process() {
        if (this.maxValue == 0.0) {
            return true;
        }
        while (this.x2 >= 0) {
            if (this.steps > this.maxIterations) {
                return false;
            }
            if (this.x1 == this.x2) {
                this.resetSteps();
                if (this.nextSplit()) continue;
                break;
            }
            if (this.fastValues && this.x2 - this.x1 == 1) {
                this.resetSteps();
                this.eigenBB_2x2(this.x1);
                this.setSubmatrix(this.x2, this.x2);
                continue;
            }
            if (this.steps >= this.nextExceptional) {
                this.exceptionShift();
                continue;
            }
            if (this.checkForAndHandleZeros()) continue;
            if (this.followScript) {
                this.performScriptedStep();
                continue;
            }
            this.performDynamicStep();
        }
        return true;
    }

    private void performDynamicStep() {
        if (this.findingZeros) {
            if (this.steps > 6) {
                this.findingZeros = false;
            } else {
                double d = this.computeBulgeScale();
                this.performImplicitSingleStep(d, 0.0, false);
            }
        } else {
            double d = this.computeBulgeScale();
            double d2 = this.selectWilkinsonShift(d);
            this.performImplicitSingleStep(d, d2, false);
        }
    }

    private void performScriptedStep() {
        double d = this.computeBulgeScale();
        if (this.steps > 10) {
            this.followScript = false;
        } else {
            double d2 = this.values[this.x2] / d;
            this.performImplicitSingleStep(d, d2 * d2, false);
        }
    }

    public void incrementSteps() {
        ++this.steps;
        ++this.totalSteps;
    }

    public boolean isOffZero(int n) {
        double d = Math.abs(this.diag[n]) + Math.abs(this.diag[n + 1]);
        return Math.abs(this.off[n]) <= d * UtilEjml.EPS;
    }

    public boolean isDiagonalZero(int n) {
        double d = Math.abs(this.diag[n + 1]) + Math.abs(this.off[n]);
        return Math.abs(this.diag[n]) <= d * UtilEjml.EPS;
    }

    public void resetSteps() {
        this.steps = 0;
        this.nextExceptional = this.exceptionalThresh;
        this.numExceptional = 0;
    }

    public boolean nextSplit() {
        if (this.numSplits == 0) {
            return false;
        }
        this.x2 = this.splits[--this.numSplits];
        this.x1 = this.numSplits > 0 ? this.splits[this.numSplits - 1] + 1 : 0;
        return true;
    }

    public void performImplicitSingleStep(double d, double d2, boolean bl) {
        this.createBulge(this.x1, d2, d, bl);
        for (int i = this.x1; i < this.x2 - 1 && this.bulge != 0.0; ++i) {
            this.removeBulgeLeft(i, true);
            if (this.bulge == 0.0) break;
            this.removeBulgeRight(i);
        }
        if (this.bulge != 0.0) {
            this.removeBulgeLeft(this.x2 - 1, false);
        }
        this.incrementSteps();
    }

    protected void updateRotator(DenseMatrix64F denseMatrix64F, int n, int n2, double d, double d2) {
        int n3 = n * denseMatrix64F.numCols;
        int n4 = n2 * denseMatrix64F.numCols;
        int n5 = n3 + denseMatrix64F.numCols;
        while (n3 != n5) {
            double d3 = denseMatrix64F.get(n3);
            double d4 = denseMatrix64F.get(n4);
            denseMatrix64F.set(n3, d * d3 + d2 * d4);
            denseMatrix64F.set(n4, -d2 * d3 + d * d4);
            ++n3;
            ++n4;
        }
    }

    private double computeBulgeScale() {
        double d = this.diag[this.x1];
        double d2 = this.off[this.x1];
        return Math.max(Math.abs(d), Math.abs(d2));
    }

    protected void createBulge(int n, double d, double d2, boolean bl) {
        double d3 = this.diag[n];
        double d4 = this.off[n];
        double d5 = this.diag[n + 1];
        if (bl) {
            this.c = Math.cos(d);
            this.s = Math.sin(d);
        } else {
            double d6 = d3 / d2 * (d3 / d2) - d;
            double d7 = d4 / d2 * (d3 / d2);
            double d8 = Math.sqrt(d6 * d6 + d7 * d7);
            this.c = d6 / d8;
            this.s = d7 / d8;
        }
        this.diag[n] = d3 * this.c + d4 * this.s;
        this.off[n] = d4 * this.c - d3 * this.s;
        this.diag[n + 1] = d5 * this.c;
        this.bulge = d5 * this.s;
        if (this.Vt != null) {
            this.updateRotator(this.Vt, n, n + 1, this.c, this.s);
        }
    }

    protected void computeRotator(double d, double d2) {
        if (Math.abs(d) < Math.abs(d2)) {
            double d3 = d / d2;
            double d4 = Math.sqrt(1.0 + d3 * d3);
            this.s = 1.0 / d4;
            this.c = d3 / d4;
        } else {
            double d5 = d2 / d;
            double d6 = Math.sqrt(1.0 + d5 * d5);
            this.c = 1.0 / d6;
            this.s = d5 / d6;
        }
    }

    protected void removeBulgeLeft(int n, boolean bl) {
        double d = this.diag[n];
        double d2 = this.off[n];
        double d3 = this.diag[n + 1];
        this.computeRotator(d, this.bulge);
        this.diag[n] = this.c * d + this.s * this.bulge;
        this.off[n] = this.c * d2 + this.s * d3;
        this.diag[n + 1] = this.c * d3 - this.s * d2;
        if (bl) {
            double d4 = this.off[n + 1];
            this.bulge = this.s * d4;
            this.off[n + 1] = this.c * d4;
        }
        if (this.Ut != null) {
            this.updateRotator(this.Ut, n, n + 1, this.c, this.s);
        }
    }

    protected void removeBulgeRight(int n) {
        double d = this.off[n];
        double d2 = this.diag[n + 1];
        double d3 = this.off[n + 1];
        this.computeRotator(d, this.bulge);
        this.off[n] = d * this.c + this.bulge * this.s;
        this.diag[n + 1] = d2 * this.c + d3 * this.s;
        this.off[n + 1] = -d2 * this.s + d3 * this.c;
        double d4 = this.diag[n + 2];
        this.diag[n + 2] = d4 * this.c;
        this.bulge = d4 * this.s;
        if (this.Vt != null) {
            this.updateRotator(this.Vt, n + 1, n + 2, this.c, this.s);
        }
    }

    public void setSubmatrix(int n, int n2) {
        this.x1 = n;
        this.x2 = n2;
    }

    public double selectWilkinsonShift(double d) {
        double d2;
        double d3;
        double d4;
        if (this.x2 - this.x1 > 1) {
            d4 = this.diag[this.x2 - 1] / d;
            d3 = this.off[this.x2 - 2] / d;
            double d5 = this.diag[this.x2] / d;
            double d6 = this.off[this.x2 - 1] / d;
            double d7 = d3 * d3 + d4 * d4;
            d2 = d6 * d6 + d5 * d5;
            this.eigenSmall.symm2x2_fast(d7, d6 * d4, d2);
        } else {
            d4 = this.diag[this.x2 - 1] / d;
            d3 = this.off[this.x2 - 1] / d;
            double d8 = this.diag[this.x2] / d;
            double d9 = d4 * d4;
            d2 = d3 * d3 + d8 * d8;
            this.eigenSmall.symm2x2_fast(d9, d4 * d3, d2);
        }
        d4 = Math.abs(this.eigenSmall.value0.real - d2);
        d3 = Math.abs(this.eigenSmall.value1.real - d2);
        return d4 < d3 ? this.eigenSmall.value0.real : this.eigenSmall.value1.real;
    }

    protected void eigenBB_2x2(int n) {
        double d;
        double d2 = this.diag[n];
        double d3 = this.off[n];
        double d4 = this.diag[n + 1];
        double d5 = Math.abs(d2);
        double d6 = Math.abs(d3);
        double d7 = Math.abs(d4);
        double d8 = d = d5 > d6 ? d5 : d6;
        if (d7 > d) {
            d = d7;
        }
        if (d == 0.0) {
            return;
        }
        this.eigenSmall.symm2x2_fast((d2 /= d) * d2, d2 * (d3 /= d), d3 * d3 + (d4 /= d) * d4);
        this.off[n] = 0.0;
        this.diag[n] = d * Math.sqrt(this.eigenSmall.value0.real);
        double d9 = Math.signum(this.eigenSmall.value1.real);
        this.diag[n + 1] = d9 * d * Math.sqrt(Math.abs(this.eigenSmall.value1.real));
    }

    protected boolean checkForAndHandleZeros() {
        int n;
        for (n = this.x2 - 1; n >= this.x1; --n) {
            if (!this.isOffZero(n)) continue;
            this.resetSteps();
            this.splits[this.numSplits++] = n;
            this.x1 = n + 1;
            return true;
        }
        for (n = this.x2 - 1; n >= this.x1; --n) {
            if (!this.isDiagonalZero(n)) continue;
            this.pushRight(n);
            this.resetSteps();
            this.splits[this.numSplits++] = n;
            this.x1 = n + 1;
            return true;
        }
        return false;
    }

    private void pushRight(int n) {
        if (this.isOffZero(n)) {
            return;
        }
        this.rotatorPushRight(n);
        int n2 = this.N - 2 - n;
        for (int i = 0; i < n2 && this.bulge != 0.0; ++i) {
            this.rotatorPushRight2(n, i + 2);
        }
    }

    private void rotatorPushRight(int n) {
        double d = this.off[n];
        double d2 = this.diag[n + 1];
        this.computeRotator(d2, -d);
        this.off[n] = 0.0;
        this.diag[n + 1] = d2 * this.c - d * this.s;
        if (n + 2 < this.N) {
            double d3 = this.off[n + 1];
            this.off[n + 1] = d3 * this.c;
            this.bulge = d3 * this.s;
        } else {
            this.bulge = 0.0;
        }
        if (this.Ut != null) {
            this.updateRotator(this.Ut, n, n + 1, this.c, this.s);
        }
    }

    private void rotatorPushRight2(int n, int n2) {
        double d = this.bulge;
        double d2 = this.diag[n + n2];
        this.computeRotator(d2, -d);
        this.diag[n + n2] = d2 * this.c - d * this.s;
        if (n + n2 < this.N - 1) {
            double d3 = this.off[n + n2];
            this.off[n + n2] = d3 * this.c;
            this.bulge = d3 * this.s;
        }
        if (this.Ut != null) {
            this.updateRotator(this.Ut, n, n + n2, this.c, this.s);
        }
    }

    public void exceptionShift() {
        ++this.numExceptional;
        double d = 0.05 * (double)this.numExceptional;
        if (d > 1.0) {
            d = 1.0;
        }
        double d2 = Math.PI * 2 * (this.rand.nextDouble() - 0.5) * d;
        this.performImplicitSingleStep(0.0, d2, true);
        this.nextExceptional = this.steps + this.exceptionalThresh;
    }

    private SimpleMatrix createQ(int n, double d, double d2, boolean bl) {
        return this.createQ(n, n + 1, d, d2, bl);
    }

    private SimpleMatrix createQ(int n, int n2, double d, double d2, boolean bl) {
        SimpleMatrix simpleMatrix = SimpleMatrix.identity(this.N);
        simpleMatrix.set(n, n, d);
        if (bl) {
            simpleMatrix.set(n, n2, d2);
            simpleMatrix.set(n2, n, -d2);
        } else {
            simpleMatrix.set(n, n2, -d2);
            simpleMatrix.set(n2, n, d2);
        }
        simpleMatrix.set(n2, n2, d);
        return simpleMatrix;
    }

    private SimpleMatrix createB() {
        SimpleMatrix simpleMatrix = new SimpleMatrix(this.N, this.N);
        for (int i = 0; i < this.N - 1; ++i) {
            simpleMatrix.set(i, i, this.diag[i]);
            simpleMatrix.set(i, i + 1, this.off[i]);
        }
        simpleMatrix.set(this.N - 1, this.N - 1, this.diag[this.N - 1]);
        return simpleMatrix;
    }

    public void printMatrix() {
        int n;
        System.out.print("Off Diag[ ");
        for (n = 0; n < this.N - 1; ++n) {
            System.out.printf("%5.2f ", this.off[n]);
        }
        System.out.println();
        System.out.print("    Diag[ ");
        for (n = 0; n < this.N; ++n) {
            System.out.printf("%5.2f ", this.diag[n]);
        }
        System.out.println();
    }

    public int getNumberOfSingularValues() {
        return this.N;
    }

    public double getSingularValue(int n) {
        return this.diag[n];
    }

    public void setFastValues(boolean bl) {
        this.fastValues = bl;
    }

    public double[] getSingularValues() {
        return this.diag;
    }

    public double[] getDiag() {
        return this.diag;
    }

    public double[] getOff() {
        return this.off;
    }

    public double getMaxValue() {
        return this.maxValue;
    }
}

