/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.decomposition.svd;

import org.ejml.alg.dense.decomposition.bidiagonal.BidiagonalDecomposition;
import org.ejml.alg.dense.decomposition.bidiagonal.BidiagonalDecompositionRow;
import org.ejml.alg.dense.decomposition.bidiagonal.BidiagonalDecompositionTall;
import org.ejml.alg.dense.decomposition.svd.implicitqr.SvdImplicitQrAlgorithm;
import org.ejml.data.DenseMatrix64F;
import org.ejml.factory.SingularValueDecomposition;
import org.ejml.ops.CommonOps;

public class SvdImplicitQrDecompose
implements SingularValueDecomposition<DenseMatrix64F> {
    private int numRows;
    private int numCols;
    private int numRowsT;
    private int numColsT;
    private boolean canUseTallBidiagonal;
    private BidiagonalDecomposition<DenseMatrix64F> bidiag;
    private SvdImplicitQrAlgorithm qralg = new SvdImplicitQrAlgorithm();
    double[] diag;
    double[] off;
    private DenseMatrix64F Ut;
    private DenseMatrix64F Vt;
    private double[] singularValues;
    private int numSingular;
    private boolean compact;
    private boolean computeU;
    private boolean computeV;
    private boolean prefComputeU;
    private boolean prefComputeV;
    private boolean transposed;
    private DenseMatrix64F A_mod = new DenseMatrix64F(1, 1);

    public SvdImplicitQrDecompose(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.compact = bl;
        this.prefComputeU = bl2;
        this.prefComputeV = bl3;
        this.canUseTallBidiagonal = bl4;
    }

    @Override
    public double[] getSingularValues() {
        return this.singularValues;
    }

    @Override
    public int numberOfSingularValues() {
        return this.numSingular;
    }

    @Override
    public boolean isCompact() {
        return this.compact;
    }

    @Override
    public DenseMatrix64F getU(DenseMatrix64F denseMatrix64F, boolean bl) {
        if (!this.prefComputeU) {
            throw new IllegalArgumentException("As requested U was not computed.");
        }
        if (bl) {
            if (denseMatrix64F == null) {
                return this.Ut;
            }
            if (denseMatrix64F.numRows != this.Ut.numRows || denseMatrix64F.numCols != this.Ut.numCols) {
                throw new IllegalArgumentException("Unexpected shape of U");
            }
            denseMatrix64F.set(this.Ut);
        } else {
            if (denseMatrix64F == null) {
                denseMatrix64F = new DenseMatrix64F(this.Ut.numCols, this.Ut.numRows);
            } else if (denseMatrix64F.numRows != this.Ut.numCols || denseMatrix64F.numCols != this.Ut.numRows) {
                throw new IllegalArgumentException("Unexpected shape of U");
            }
            CommonOps.transpose(this.Ut, denseMatrix64F);
        }
        return denseMatrix64F;
    }

    @Override
    public DenseMatrix64F getV(DenseMatrix64F denseMatrix64F, boolean bl) {
        if (!this.prefComputeV) {
            throw new IllegalArgumentException("As requested V was not computed.");
        }
        if (bl) {
            if (denseMatrix64F == null) {
                return this.Vt;
            }
            if (denseMatrix64F.numRows != this.Vt.numRows || denseMatrix64F.numCols != this.Vt.numCols) {
                throw new IllegalArgumentException("Unexpected shape of V");
            }
            denseMatrix64F.set(this.Vt);
        } else {
            if (denseMatrix64F == null) {
                denseMatrix64F = new DenseMatrix64F(this.Vt.numCols, this.Vt.numRows);
            } else if (denseMatrix64F.numRows != this.Vt.numCols || denseMatrix64F.numCols != this.Vt.numRows) {
                throw new IllegalArgumentException("Unexpected shape of V");
            }
            CommonOps.transpose(this.Vt, denseMatrix64F);
        }
        return denseMatrix64F;
    }

    @Override
    public DenseMatrix64F getW(DenseMatrix64F denseMatrix64F) {
        int n;
        int n2 = this.compact ? this.numSingular : this.numRows;
        int n3 = n = this.compact ? this.numSingular : this.numCols;
        if (denseMatrix64F == null) {
            denseMatrix64F = new DenseMatrix64F(n2, n);
        } else {
            denseMatrix64F.reshape(n2, n, false);
            denseMatrix64F.zero();
        }
        for (int i = 0; i < this.numSingular; ++i) {
            denseMatrix64F.unsafe_set(i, i, this.singularValues[i]);
        }
        return denseMatrix64F;
    }

    @Override
    public boolean decompose(DenseMatrix64F denseMatrix64F) {
        this.setup(denseMatrix64F);
        if (this.bidiagonalization(denseMatrix64F)) {
            return false;
        }
        if (this.computeUWV()) {
            return false;
        }
        this.makeSingularPositive();
        this.undoTranspose();
        return true;
    }

    @Override
    public boolean inputModified() {
        return false;
    }

    private boolean bidiagonalization(DenseMatrix64F denseMatrix64F) {
        if (this.transposed) {
            this.A_mod.reshape(denseMatrix64F.numCols, denseMatrix64F.numRows, false);
            CommonOps.transpose(denseMatrix64F, this.A_mod);
        } else {
            this.A_mod.reshape(denseMatrix64F.numRows, denseMatrix64F.numCols, false);
            this.A_mod.set(denseMatrix64F);
        }
        return !this.bidiag.decompose(this.A_mod);
    }

    private void undoTranspose() {
        if (this.transposed) {
            DenseMatrix64F denseMatrix64F = this.Vt;
            this.Vt = this.Ut;
            this.Ut = denseMatrix64F;
        }
    }

    private boolean computeUWV() {
        this.bidiag.getDiagonal(this.diag, this.off);
        this.qralg.setMatrix(this.numRowsT, this.numColsT, this.diag, this.off);
        if (this.computeU) {
            this.Ut = this.bidiag.getU(this.Ut, true, this.compact);
        }
        if (this.computeV) {
            this.Vt = this.bidiag.getV(this.Vt, true, this.compact);
        }
        this.qralg.setFastValues(false);
        if (this.computeU) {
            this.qralg.setUt(this.Ut);
        } else {
            this.qralg.setUt(null);
        }
        if (this.computeV) {
            this.qralg.setVt(this.Vt);
        } else {
            this.qralg.setVt(null);
        }
        boolean bl = !this.qralg.process();
        return bl;
    }

    private void setup(DenseMatrix64F denseMatrix64F) {
        boolean bl = this.transposed = denseMatrix64F.numCols > denseMatrix64F.numRows;
        if (this.transposed) {
            this.computeU = this.prefComputeV;
            this.computeV = this.prefComputeU;
            this.numRowsT = denseMatrix64F.numCols;
            this.numColsT = denseMatrix64F.numRows;
        } else {
            this.computeU = this.prefComputeU;
            this.computeV = this.prefComputeV;
            this.numRowsT = denseMatrix64F.numRows;
            this.numColsT = denseMatrix64F.numCols;
        }
        this.numRows = denseMatrix64F.numRows;
        this.numCols = denseMatrix64F.numCols;
        if (this.diag == null || this.diag.length < this.numColsT) {
            this.diag = new double[this.numColsT];
            this.off = new double[this.numColsT - 1];
        }
        if (this.canUseTallBidiagonal && this.numRows > this.numCols * 2 && !this.computeU) {
            if (this.bidiag == null || !(this.bidiag instanceof BidiagonalDecompositionTall)) {
                this.bidiag = new BidiagonalDecompositionTall();
            }
        } else if (this.bidiag == null || !(this.bidiag instanceof BidiagonalDecompositionRow)) {
            this.bidiag = new BidiagonalDecompositionRow();
        }
    }

    private void makeSingularPositive() {
        this.numSingular = this.qralg.getNumberOfSingularValues();
        this.singularValues = this.qralg.getSingularValues();
        for (int i = 0; i < this.numSingular; ++i) {
            double d = this.qralg.getSingularValue(i);
            if (d < 0.0) {
                this.singularValues[i] = 0.0 - d;
                if (!this.computeU) continue;
                int n = i * this.Ut.numCols;
                int n2 = n + this.Ut.numCols;
                for (int j = n; j < n2; ++j) {
                    this.Ut.set(j, 0.0 - this.Ut.get(j));
                }
                continue;
            }
            this.singularValues[i] = d;
        }
    }

    @Override
    public int numRows() {
        return this.numRows;
    }

    @Override
    public int numCols() {
        return this.numCols;
    }
}

