/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.decomposition.lu;

import org.ejml.alg.dense.decomposition.lu.LUDecompositionBase;
import org.ejml.data.DenseMatrix64F;

public class LUDecompositionAlt
extends LUDecompositionBase {
    @Override
    public boolean decompose(DenseMatrix64F denseMatrix64F) {
        this.decomposeCommonInit(denseMatrix64F);
        double[] dArray = this.vv;
        for (int i = 0; i < this.n; ++i) {
            double d;
            int n;
            int n2;
            int n3;
            for (n3 = 0; n3 < this.m; ++n3) {
                dArray[n3] = this.dataLU[n3 * this.n + i];
            }
            n3 = 0;
            while (n3 < this.m) {
                int n4 = n3 * this.n;
                int n5 = n3 < i ? n3 : i;
                double d2 = 0.0;
                for (n2 = 0; n2 < n5; ++n2) {
                    d2 += this.dataLU[n4 + n2] * dArray[n2];
                }
                int n6 = n3++;
                double d3 = dArray[n6] - d2;
                dArray[n6] = d3;
                this.dataLU[n4 + i] = d3;
            }
            n3 = i;
            double d4 = Math.abs(dArray[n3]);
            for (n = i + 1; n < this.m; ++n) {
                double d5 = Math.abs(dArray[n]);
                if (!(d5 > d4)) continue;
                n3 = n;
                d4 = d5;
            }
            if (n3 != i) {
                n = n3 * this.n;
                int n7 = i * this.n;
                n2 = n + this.n;
                while (n < n2) {
                    double d6 = this.dataLU[n];
                    this.dataLU[n] = this.dataLU[n7];
                    this.dataLU[n7] = d6;
                    ++n;
                    ++n7;
                }
                int n8 = this.pivot[n3];
                this.pivot[n3] = this.pivot[i];
                this.pivot[i] = n8;
                this.pivsign = -this.pivsign;
            }
            this.indx[i] = n3;
            if (i >= this.m || (d = this.dataLU[i * this.n + i]) == 0.0) continue;
            for (n2 = i + 1; n2 < this.m; ++n2) {
                int n9 = n2 * this.n + i;
                this.dataLU[n9] = this.dataLU[n9] / d;
            }
        }
        return true;
    }
}

