/*
 * Decompiled with CFR 0.152.
 */
package de.jollyday.parser.impl;

import de.jollyday.Holiday;
import de.jollyday.HolidayType;
import de.jollyday.config.Holidays;
import de.jollyday.config.RelativeToEasterSunday;
import de.jollyday.parser.AbstractHolidayParser;
import java.util.Set;
import org.joda.time.LocalDate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelativeToEasterSundayParser
extends AbstractHolidayParser {
    private static final String PREFIX_PROPERTY_CHRISTIAN = "christian.";

    @Override
    public void parse(int year, Set<Holiday> holidays, Holidays config) {
        for (RelativeToEasterSunday ch : config.getRelativeToEasterSunday()) {
            if (!this.isValid(ch, year)) continue;
            LocalDate easterSunday = this.getEasterSunday(year, ch.getChronology()).plusDays(ch.getDays());
            String propertiesKey = PREFIX_PROPERTY_CHRISTIAN + ch.getDescriptionPropertiesKey();
            this.addChrstianHoliday(easterSunday, propertiesKey, ch.getLocalizedType(), holidays);
        }
    }

    protected void addChrstianHoliday(LocalDate day, String propertiesKey, de.jollyday.config.HolidayType holidayType, Set<Holiday> holidays) {
        LocalDate convertedDate = this.calendarUtil.convertToISODate(day);
        HolidayType type = this.xmlUtil.getType(holidayType);
        Holiday h = new Holiday(convertedDate, propertiesKey, type);
        holidays.add(h);
    }
}

