/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.compound;

import java.io.File;
import java.io.IOException;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.compound.Lucene43CompoundWordTokenFilterBase;
import org.apache.lucene.analysis.compound.hyphenation.Hyphenation;
import org.apache.lucene.analysis.compound.hyphenation.HyphenationTree;
import org.apache.lucene.analysis.util.CharArraySet;
import org.xml.sax.InputSource;

@Deprecated
public class Lucene43HyphenationCompoundWordTokenFilter
extends Lucene43CompoundWordTokenFilterBase {
    private HyphenationTree hyphenator;

    public Lucene43HyphenationCompoundWordTokenFilter(TokenStream input, HyphenationTree hyphenator, CharArraySet dictionary) {
        this(input, hyphenator, dictionary, 5, 2, 15, false);
    }

    public Lucene43HyphenationCompoundWordTokenFilter(TokenStream input, HyphenationTree hyphenator, CharArraySet dictionary, int minWordSize, int minSubwordSize, int maxSubwordSize, boolean onlyLongestMatch) {
        super(input, dictionary, minWordSize, minSubwordSize, maxSubwordSize, onlyLongestMatch);
        this.hyphenator = hyphenator;
    }

    public Lucene43HyphenationCompoundWordTokenFilter(TokenStream input, HyphenationTree hyphenator, int minWordSize, int minSubwordSize, int maxSubwordSize) {
        this(input, hyphenator, null, minWordSize, minSubwordSize, maxSubwordSize, false);
    }

    public Lucene43HyphenationCompoundWordTokenFilter(TokenStream input, HyphenationTree hyphenator) {
        this(input, hyphenator, 5, 2, 15);
    }

    public static HyphenationTree getHyphenationTree(String hyphenationFilename) throws IOException {
        return Lucene43HyphenationCompoundWordTokenFilter.getHyphenationTree(new InputSource(hyphenationFilename));
    }

    public static HyphenationTree getHyphenationTree(File hyphenationFile) throws IOException {
        return Lucene43HyphenationCompoundWordTokenFilter.getHyphenationTree(new InputSource(hyphenationFile.toURI().toASCIIString()));
    }

    public static HyphenationTree getHyphenationTree(InputSource hyphenationSource) throws IOException {
        HyphenationTree tree = new HyphenationTree();
        tree.loadPatterns(hyphenationSource);
        return tree;
    }

    @Override
    protected void decompose() {
        Hyphenation hyphens = this.hyphenator.hyphenate(this.termAtt.buffer(), 0, this.termAtt.length(), 1, 1);
        if (hyphens == null) {
            return;
        }
        int[] hyp = hyphens.getHyphenationPoints();
        for (int i = 0; i < hyp.length; ++i) {
            int partLength;
            int remaining = hyp.length - i;
            int start = hyp[i];
            Lucene43CompoundWordTokenFilterBase.CompoundToken longestMatchToken = null;
            for (int j = 1; j < remaining && (partLength = hyp[i + j] - start) <= this.maxSubwordSize; ++j) {
                if (partLength < this.minSubwordSize) continue;
                if (this.dictionary == null || this.dictionary.contains(this.termAtt.buffer(), start, partLength)) {
                    if (this.onlyLongestMatch) {
                        if (longestMatchToken != null) {
                            if (longestMatchToken.txt.length() >= partLength) continue;
                            longestMatchToken = new Lucene43CompoundWordTokenFilterBase.CompoundToken(start, partLength);
                            continue;
                        }
                        longestMatchToken = new Lucene43CompoundWordTokenFilterBase.CompoundToken(start, partLength);
                        continue;
                    }
                    this.tokens.add(new Lucene43CompoundWordTokenFilterBase.CompoundToken(start, partLength));
                    continue;
                }
                if (!this.dictionary.contains(this.termAtt.buffer(), start, partLength - 1)) continue;
                if (this.onlyLongestMatch) {
                    if (longestMatchToken != null) {
                        if (longestMatchToken.txt.length() >= partLength - 1) continue;
                        longestMatchToken = new Lucene43CompoundWordTokenFilterBase.CompoundToken(start, partLength - 1);
                        continue;
                    }
                    longestMatchToken = new Lucene43CompoundWordTokenFilterBase.CompoundToken(start, partLength - 1);
                    continue;
                }
                this.tokens.add(new Lucene43CompoundWordTokenFilterBase.CompoundToken(start, partLength - 1));
            }
            if (!this.onlyLongestMatch || longestMatchToken == null) continue;
            this.tokens.add(longestMatchToken);
        }
    }
}

