/*
 * Decompiled with CFR 0.152.
 */
package slothLib.io;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import slothLib.SlothLib;
import slothLib.SlothLibException;
import slothLib.io.AbstractContentReader;
import slothLib.portUtil.PortUtil;
import slothLib.portUtil.ProcessPipe;

public class GenericContentReader
extends AbstractContentReader {
    static final String placeHolder = "__FILE__";
    static final String outputHolder = "__OUTPUT__";
    private String encoding;
    List<String[]> commandLists = new ArrayList<String[]>();
    boolean filterMode;

    public GenericContentReader(String ... extensions) {
        super(extensions);
        this.encoding = SlothLib.getDefaultEncoding();
    }

    public void addCommand(String ... command) {
        this.commandLists.add(command);
    }

    public void setFileterMode(boolean filterMode) {
        this.filterMode = filterMode;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    private static String[] replace(String[] commandLine, String filePath, String outfile) {
        String[] tmp = (String[])commandLine.clone();
        int i = 0;
        while (i < tmp.length) {
            if (tmp[i].equals(placeHolder)) {
                tmp[i] = filePath;
            } else if (tmp[i].equals(outputHolder)) {
                tmp[i] = outfile;
            }
            ++i;
        }
        return tmp;
    }

    private boolean checkOutputHolder() {
        Iterator<String[]> iterator = this.commandLists.iterator();
        while (iterator.hasNext()) {
            String[] commandList;
            String[] stringArray = commandList = iterator.next();
            int n = commandList.length;
            int n2 = 0;
            while (n2 < n) {
                String str = stringArray[n2];
                if (str.equals(outputHolder)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    @Override
    protected String process(String filePath) throws SlothLibException {
        String string;
        block15: {
            ProcessPipe pipe = null;
            String outputFile = null;
            try {
                int ec;
                pipe = new ProcessPipe();
                boolean outputFileUsed = this.checkOutputHolder();
                if (outputFileUsed) {
                    File f = File.createTempFile("slothlib", "out");
                    outputFile = f.getAbsolutePath();
                    pipe.setResultFileName(outputFile);
                }
                for (String[] commandList : this.commandLists) {
                    pipe.add(GenericContentReader.replace(commandList, filePath, outputFile));
                }
                if (this.filterMode) {
                    pipe.start(filePath);
                } else {
                    pipe.start();
                }
                String output = null;
                if (!outputFileUsed) {
                    output = PortUtil.readFully(pipe.getInputStream(), this.encoding);
                }
                while (true) {
                    try {
                        pipe.waitFor();
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
                if (outputFileUsed) {
                    output = PortUtil.readFully(pipe.getInputStream(), this.encoding);
                }
                if ((ec = pipe.exitValue()) != 0) {
                    System.err.println(PortUtil.readFully(pipe.getErrorStream(), this.encoding));
                    throw new SlothLibException("pipe\u306e\u5b9f\u884c\u6642\u306b\u30a8\u30e9\u30fc\u304c\u8d77\u3053\u308a\u307e\u3057\u305f\u3002");
                }
                string = output;
                pipe.destroy();
                if (outputFile == null) break block15;
                new File(outputFile).delete();
            }
            catch (IOException e) {
                try {
                    throw new SlothLibException(e);
                }
                catch (Throwable throwable) {
                    pipe.destroy();
                    if (outputFile != null) {
                        new File(outputFile).delete();
                    }
                    throw throwable;
                }
            }
        }
        return string;
    }
}

