/*
 * Decompiled with CFR 0.152.
 */
package slothLib.io;

import java.io.IOException;
import java.util.ArrayList;
import slothLib.SlothLibException;
import slothLib.io.AbstractContentReader;
import slothLib.portUtil.PortUtil;

public class PdftotextReader
extends AbstractContentReader {
    private static String PDFTOTEXTREADER_TAG = "slothlib.pdftotext.path";
    private static String PDFTOTEXT_DEFAULT = "/usr/bin/pdftotext";
    private String pdftotextExePath = null;

    public PdftotextReader(String pdftotextExePath) throws SlothLibException {
        super(".pdf");
        if (pdftotextExePath == null) {
            pdftotextExePath = PDFTOTEXT_DEFAULT;
        }
        if (!PortUtil.fileExists(pdftotextExePath)) {
            throw new SlothLibException("\u6307\u5b9a\u3055\u308c\u305fpdftotext\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f" + pdftotextExePath);
        }
        this.pdftotextExePath = pdftotextExePath;
    }

    public PdftotextReader() throws SlothLibException {
        this(System.getProperty(PDFTOTEXTREADER_TAG));
    }

    @Override
    protected String process(String filePath) throws SlothLibException {
        Process p = null;
        try {
            ArrayList<String> cmds = new ArrayList<String>();
            cmds.add(this.pdftotextExePath);
            cmds.add(filePath);
            cmds.add("-");
            ProcessBuilder pb = new ProcessBuilder(cmds);
            p = pb.start();
            String output = PortUtil.readFully(p.getInputStream(), "UTF-8");
            while (true) {
                try {
                    p.waitFor();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
            int ec = p.exitValue();
            if (ec != 0) {
                System.err.println(PortUtil.readFully(p.getErrorStream(), "UTF-8"));
                throw new SlothLibException("pdftotext\u306e\u5b9f\u884c\u6642\u306b\u30a8\u30e9\u30fc\u304c\u8d77\u3053\u308a\u307e\u3057\u305f\u3002");
            }
            String string = output;
            return string;
        }
        catch (IOException e) {
            throw new SlothLibException(e);
        }
        finally {
            p.destroy();
        }
    }
}

