private rule architecture {
	meta:
		bits = 32
		endianness = "little"
		architecture = "x86"
	condition:
		true
}

rule file_0_0_0 {
	meta:
		name = "___gthr_win32_once"
		size = 128
		refs = "0045 __imp__Sleep@4"
	strings:
		$1 = { 83 EC 1C 8B 44 24 24 89 5C 24 14 8B 5C 24 20 89 74 24 18 85 C0 75 11 B8 16 00 00 00 8B 5C 24 14 8B 74 24 18 83 C4 1C C3 85 DB 74 EB 8B 0B 85 C9 75 30 BA 01 00 00 00 F0 0F C1 53 04 83 FA FF 74 2F 8B 13 8B 35 ?? ?? ?? ?? 85 D2 75 15 8D 76 00 C7 04 24 00 00 00 00 FF D6 8B 03 83 EC 04 85 C0 74 EE 31 C0 8B 5C 24 14 8B 74 24 18 83 C4 1C C3 FF D0 31 C0 C7 03 01 00 00 00 EB E8 8D 74 26 00 }
	condition:
		$1
}

rule file_0_1_0 {
	meta:
		name = "___gthr_win32_key_create"
		size = 80
		refs = "0015 __imp__TlsAlloc@0 0039 __imp__GetLastError@0 0034 ___mingwthr_key_dtor"
	strings:
		$1 = { 83 EC 0C 89 5C 24 04 8B 5C 24 14 89 74 24 08 8B 74 24 10 FF 15 ?? ?? ?? ?? 83 F8 FF 74 1A 89 06 8B 74 24 08 89 5C 24 14 8B 5C 24 04 89 44 24 10 83 C4 0C E9 ?? ?? ?? ?? A1 ?? ?? ?? ?? 8B 5C 24 04 8B 74 24 08 83 C4 0C FF E0 8D B6 00 00 00 00 }
	condition:
		$1
}

rule file_0_2_0 {
	meta:
		name = "___gthr_win32_key_delete"
		size = 48
		refs = "000c __imp__TlsFree@4 0021 __imp__GetLastError@0"
	strings:
		$1 = { 83 EC 1C 8B 44 24 20 89 04 24 FF 15 ?? ?? ?? ?? 83 EC 04 85 C0 74 09 31 C0 83 C4 1C C3 8D 76 00 A1 ?? ?? ?? ?? 83 C4 1C FF E0 8D B6 00 00 00 00 }
	condition:
		$1
}

rule file_0_3_0 {
	meta:
		name = "___gthr_win32_getspecific"
		size = 64
		refs = "000d __imp__GetLastError@0 001c __imp__TlsGetValue@4 002a __imp__SetLastError@4"
	strings:
		$1 = { 83 EC 1C 89 5C 24 14 89 74 24 18 FF 15 ?? ?? ?? ?? 89 C6 8B 44 24 20 89 04 24 FF 15 ?? ?? ?? ?? 83 EC 04 89 C3 89 34 24 FF 15 ?? ?? ?? ?? 89 D8 83 EC 04 8B 5C 24 14 8B 74 24 18 83 C4 1C C3 90 }
	condition:
		$1
}

rule file_0_4_0 {
	meta:
		name = "___gthr_win32_setspecific"
		size = 48
		refs = "0014 __imp__TlsSetValue@8 0026 __imp__GetLastError@0"
	strings:
		$1 = { 83 EC 1C 8B 44 24 24 89 44 24 04 8B 44 24 20 89 04 24 FF 15 ?? ?? ?? ?? 83 EC 08 85 C0 74 06 31 C0 83 C4 1C C3 A1 ?? ?? ?? ?? 83 C4 1C FF E0 90 }
	condition:
		$1
}

rule file_0_5_0 {
	meta:
		name = "___gthr_win32_mutex_init_function"
		size = 64
		refs = "002f __imp__CreateSemaphoreA@16"
	strings:
		$1 = { 53 83 EC 18 8B 5C 24 20 C7 03 FF FF FF FF C7 44 24 0C 00 00 00 00 C7 44 24 08 FF FF 00 00 C7 44 24 04 00 00 00 00 C7 04 24 00 00 00 00 FF 15 ?? ?? ?? ?? 83 EC 10 89 43 04 83 C4 18 5B C3 66 90 }
	condition:
		$1
}

rule file_0_6_0 {
	meta:
		name = "___gthr_win32_mutex_destroy"
		size = 32
		refs = "000f __imp__CloseHandle@4"
	strings:
		$1 = { 83 EC 1C 8B 44 24 20 8B 40 04 89 04 24 FF 15 ?? ?? ?? ?? 83 EC 04 83 C4 1C C3 8D B6 00 00 00 00 }
	condition:
		$1
}

rule file_0_7_0 {
	meta:
		name = "___gthr_win32_mutex_lock"
		size = 80
		refs = "0026 __imp__WaitForSingleObject@8"
	strings:
		$1 = { 53 B8 01 00 00 00 83 EC 18 8B 5C 24 20 F0 0F C1 03 83 F8 FF 74 2E C7 44 24 04 FF FF FF FF 8B 43 04 89 04 24 FF 15 ?? ?? ?? ?? 83 EC 08 85 C0 74 13 B8 FF FF FF FF F0 0F C1 03 83 C4 18 B8 01 00 00 00 5B C3 83 C4 18 31 C0 5B C3 90 8D 74 26 00 }
	condition:
		$1
}

rule file_0_8_0 {
	meta:
		name = "___gthr_win32_mutex_trylock"
		size = 32
	strings:
		$1 = { 8B 54 24 04 B8 FF FF FF FF 31 C9 F0 0F B1 0A F7 D0 C1 E8 1F C3 8D 74 26 00 8D BC 27 00 00 00 00 }
	condition:
		$1
}

rule file_0_9_0 {
	meta:
		name = "___gthr_win32_mutex_unlock"
		size = 80
		refs = "002e __imp__ReleaseSemaphore@12"
	strings:
		$1 = { 83 EC 1C BA FF FF FF FF 8B 4C 24 20 F0 0F C1 11 31 C0 85 D2 7E 27 C7 44 24 08 00 00 00 00 C7 44 24 04 01 00 00 00 8B 41 04 89 04 24 FF 15 ?? ?? ?? ?? 83 EC 0C 85 C0 0F 94 C0 0F B6 C0 83 C4 1C C3 EB 0D 90 90 90 90 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_0_10_0 {
	meta:
		name = "___gthr_win32_recursive_mutex_init_function"
		size = 80
		refs = "003d __imp__CreateSemaphoreA@16"
	strings:
		$1 = { 53 83 EC 18 8B 5C 24 20 C7 03 FF FF FF FF C7 43 04 00 00 00 00 C7 43 08 00 00 00 00 C7 44 24 0C 00 00 00 00 C7 44 24 08 FF FF 00 00 C7 44 24 04 00 00 00 00 C7 04 24 00 00 00 00 FF 15 ?? ?? ?? ?? 83 EC 10 89 43 0C 83 C4 18 5B C3 8D 74 26 00 }
	condition:
		$1
}

rule file_0_11_0 {
	meta:
		name = "___gthr_win32_recursive_mutex_lock"
		size = 176
		refs = "0011 __imp__GetCurrentThreadId@0 003a __imp__WaitForSingleObject@8"
	strings:
		$1 = { 83 EC 1C 89 5C 24 14 8B 5C 24 20 89 74 24 18 FF 15 ?? ?? ?? ?? BA 01 00 00 00 89 C6 F0 0F C1 13 83 FA FF 74 5B 39 43 08 74 36 C7 44 24 04 FF FF FF FF 8B 43 0C 89 04 24 FF 15 ?? ?? ?? ?? 83 EC 08 85 C0 74 53 B8 FF FF FF FF F0 0F C1 03 B8 01 00 00 00 8B 5C 24 14 8B 74 24 18 83 C4 1C C3 90 B8 FF FF FF FF F0 0F C1 03 31 C0 8B 74 24 18 83 43 04 01 8B 5C 24 14 83 C4 1C C3 90 8D 74 26 00 89 43 08 8B 74 24 18 31 C0 C7 43 04 01 00 00 00 8B 5C 24 14 83 C4 1C C3 89 73 08 8B 74 24 18 C7 43 04 01 00 00 00 8B 5C 24 14 83 C4 1C C3 66 90 }
	condition:
		$1
}

rule file_0_12_0 {
	meta:
		name = "___gthr_win32_recursive_mutex_trylock"
		size = 96
		refs = "0011 __imp__GetCurrentThreadId@0"
	strings:
		$1 = { 83 EC 0C 89 5C 24 04 8B 5C 24 10 89 74 24 08 FF 15 ?? ?? ?? ?? 31 C9 89 C6 B8 FF FF FF FF F0 0F B1 0B 85 C0 78 1C 39 73 08 B8 01 00 00 00 75 06 83 43 04 01 30 C0 8B 5C 24 04 8B 74 24 08 83 C4 0C C3 89 73 08 31 C0 8B 74 24 08 C7 43 04 01 00 00 00 8B 5C 24 04 83 C4 0C C3 8D B6 00 00 00 00 }
	condition:
		$1
}

rule file_0_13_0 {
	meta:
		name = "___gthr_win32_recursive_mutex_unlock"
		size = 96
		refs = "0039 __imp__ReleaseSemaphore@12"
	strings:
		$1 = { 83 EC 1C 8B 44 24 20 83 68 04 01 75 43 C7 40 08 00 00 00 00 BA FF FF FF FF F0 0F C1 10 85 D2 7E 2F C7 44 24 08 00 00 00 00 C7 44 24 04 01 00 00 00 8B 40 0C 89 04 24 FF 15 ?? ?? ?? ?? 83 EC 0C 85 C0 0F 94 C0 83 C4 1C 0F B6 C0 C3 8D 74 26 00 31 C0 83 C4 1C C3 90 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_2_0_0 {
	meta:
		name = "___dfp_set_round"
		size = 16
		refs = "0005 .bss"
	strings:
		$1 = { 8B 44 24 04 A3 ?? ?? ?? ?? C3 8D B6 00 00 00 00 }
	condition:
		$1
}

rule file_2_1_0 {
	meta:
		name = "___dfp_get_round"
		size = 16
		refs = "0001 .bss"
	strings:
		$1 = { A1 ?? ?? ?? ?? C3 8D 76 00 8D BC 27 00 00 00 00 }
	condition:
		$1
}

rule file_2_2_0 {
	meta:
		name = "___dfp_clear_except"
		size = 16
		refs = "0002 .bss"
	strings:
		$1 = { 83 25 ?? ?? ?? ?? C0 C3 90 8D B4 26 00 00 00 00 }
	condition:
		$1
}

rule file_2_3_0 {
	meta:
		name = "___dfp_test_except"
		size = 80
		refs = "0009 .bss"
	strings:
		$1 = { 53 8B 4C 24 08 31 C0 8B 15 ?? ?? ?? ?? 89 CB 83 E3 20 F6 C2 20 0F 45 C3 F6 C2 10 74 07 89 CB 83 E3 10 09 D8 F6 C2 08 74 07 89 CB 83 E3 08 09 D8 F6 C2 04 74 07 89 CB 83 E3 04 09 D8 83 E2 01 74 05 83 E1 01 09 C8 5B C3 90 8D B4 26 00 00 00 00 }
	condition:
		$1
}

rule file_3_0_0 {
	meta:
		name = "___bid_fixunssddi"
		size = 48
		refs = "000b ___bid32_to_bid64 0017 ___bid64_to_uint64_xint"
	strings:
		$1 = { 83 EC 1C 8B 44 24 20 89 04 24 E8 ?? ?? ?? ?? 89 04 24 89 54 24 04 E8 ?? ?? ?? ?? 8D 8A 00 00 00 80 09 C1 75 04 31 C0 31 D2 83 C4 1C C3 90 90 90 }
	condition:
		$1
}

rule file_4_0_0 {
	meta:
		name = "___lshrdi3"
		size = 96
	strings:
		$1 = { 83 EC 0C 89 1C 24 8B 5C 24 18 89 74 24 04 8B 44 24 10 89 7C 24 08 8B 54 24 14 85 DB 74 1F BE 20 00 00 00 29 DE 85 F6 7E 27 89 D7 89 D9 D3 EF 89 F1 D3 E2 89 D9 D3 E8 09 C2 89 D0 89 FA 8B 1C 24 8B 74 24 04 8B 7C 24 08 83 C4 0C C3 8D 74 26 00 89 F1 31 FF F7 D9 D3 EA EB DF 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_5_0_0 {
	meta:
		name = "___moddi3"
		size = 432
	strings:
		$1 = { 83 EC 2C 89 5C 24 1C 8B 5C 24 34 8B 54 24 3C 89 6C 24 28 31 ED 8B 4C 24 30 89 74 24 20 8B 44 24 38 85 DB 89 7C 24 24 89 D6 0F 88 B1 00 00 00 85 F6 0F 88 99 00 00 00 85 D2 89 DE 89 4C 24 0C 89 C7 89 04 24 89 4C 24 04 89 5C 24 08 75 12 39 D8 76 5E 89 C8 89 DA F7 F7 89 D6 89 F0 31 D2 EB 08 39 DA 76 23 89 C8 89 DA 85 ED 74 07 F7 D8 83 D2 00 F7 DA 8B 5C 24 1C 8B 74 24 20 8B 7C 24 24 8B 6C 24 28 83 C4 2C C3 0F BD DA 83 F3 1F 75 62 3B 44 24 04 0F 86 E7 00 00 00 39 F2 0F 82 DF 00 00 00 8B 44 24 04 8B 54 24 08 EB BD 90 8D 74 26 00 85 C0 75 0B B8 01 00 00 00 31 D2 F7 F7 89 C7 89 F0 31 D2 F7 F7 8B 44 24 04 F7 F7 89 D6 EB 8B 90 F7 D8 83 D2 00 F7 DA E9 5B FF FF FF 8D 74 26 00 F7 D9 BD FF FF FF FF 83 D3 00 F7 DB E9 3E FF FF FF C7 44 24 04 20 00 00 00 89 D9 8B 04 24 29 5C 24 04 D3 E2 0F B6 4C 24 04 D3 E8 89 D9 09 D0 89 F2 89 44 24 08 8B 04 24 D3 E0 0F B6 4C 24 04 89 04 24 8B 44 24 0C D3 EA 89 D9 D3 E6 0F B6 4C 24 04 D3 E8 89 D9 09 F0 8B 74 24 0C F7 74 24 08 D3 E6 89 74 24 0C 89 D6 F7 24 24 39 D6 89 C7 89 D1 72 47 39 44 24 0C 72 3D 8B 44 24 0C 29 F8 19 CE 89 D9 89 C7 D3 EF 0F B6 4C 24 04 89 F0 89 F2 D3 E0 89 D9 89 04 24 D3 EA 09 F8 E9 E9 FE FF FF 90 8B 4C 24 04 29 F9 19 D6 89 4C 24 04 89 74 24 08 E9 0C FF FF FF 39 D6 75 BF 89 D1 89 C7 2B 3C 24 1B 4C 24 08 EB B2 90 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_6_0_0 {
	meta:
		name = "___bid_ltdd2"
		size = 48
		refs = "0024 ___bid64_quiet_less"
	strings:
		$1 = { 53 83 EC 18 8B 5C 24 2C 8B 44 24 20 8B 54 24 24 8B 4C 24 28 89 5C 24 0C 89 04 24 89 54 24 04 89 4C 24 08 E8 ?? ?? ?? ?? 83 C4 18 5B F7 D8 C3 90 }
	condition:
		$1
}

rule file_7_0_0 {
	meta:
		name = "___bid_floatdisd"
		size = 48
		refs = "0013 ___bid64_from_int64 001f ___bid64_to_bid32"
	strings:
		$1 = { 83 EC 1C 8B 44 24 20 8B 54 24 24 89 04 24 89 54 24 04 E8 ?? ?? ?? ?? 89 04 24 89 54 24 04 E8 ?? ?? ?? ?? 83 C4 1C C3 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_183_0_0 {
	meta:
		name = "___bid_floatunsdisd"
		size = 48
		refs = "0013 ___bid64_from_uint64 001f ___bid64_to_bid32"
	strings:
		$1 = { 83 EC 1C 8B 44 24 20 8B 54 24 24 89 04 24 89 54 24 04 E8 ?? ?? ?? ?? 89 04 24 89 54 24 04 E8 ?? ?? ?? ?? 83 C4 1C C3 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_8_0_0 {
	meta:
		name = "___bid_lesd2"
		size = 96
		refs = "001b ___bid32_to_bid64 003b ___bid64_quiet_less_equal"
	strings:
		$1 = { 83 EC 1C 8B 44 24 20 89 5C 24 10 8B 5C 24 24 89 74 24 14 89 7C 24 18 89 04 24 E8 ?? ?? ?? ?? 89 1C 24 89 C6 89 D7 E8 ?? ?? ?? ?? 89 34 24 89 7C 24 04 89 44 24 08 89 54 24 0C E8 ?? ?? ?? ?? 8B 5C 24 10 8B 74 24 14 8B 7C 24 18 83 F8 01 19 C0 83 C4 1C 83 E0 02 83 E8 01 C3 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_9_0_0 {
	meta:
		name = "___fixunstfsi"
		size = 400
	strings:
		$1 = { 83 EC 5C 8B 44 24 6C 8B 54 24 60 8B 4C 24 68 89 5C 24 4C 8B 5C 24 64 89 74 24 50 89 C6 C1 EE 10 89 6C 24 58 81 E6 FF 7F 00 00 0F B7 E8 89 44 24 0C C1 E8 18 C0 E8 07 81 FE FE 3F 00 00 89 7C 24 54 89 14 24 89 5C 24 04 89 4C 24 08 89 54 24 10 89 5C 24 14 89 4C 24 18 89 6C 24 1C 7F 32 85 F6 BF 20 00 00 00 74 3B 31 C0 85 FF 74 0F D9 74 24 20 66 83 4C 24 24 20 D9 64 24 20 9B 8B 5C 24 4C 8B 74 24 50 8B 7C 24 54 8B 6C 24 58 83 C4 5C C3 84 C0 74 20 B8 FF FF FF FF D9 EE D8 F0 DD D8 9B EB DA 09 DA 09 CA 09 EA 83 FA 01 19 FF F7 D7 83 E7 20 EB B3 81 FE 1E 40 00 00 7E 04 31 C0 EB D9 B9 6F 40 00 00 89 D7 29 F1 31 C0 89 CA 31 DB C1 FA 05 83 C0 01 81 CD 00 00 01 00 09 FB 39 C2 89 6C 24 1C 7E 0D 8B 7C 84 10 83 C0 01 09 FB 39 C2 7F F3 85 D2 B8 01 00 00 00 89 CE 0F 4F C2 83 E6 1F 75 45 B9 03 00 00 00 29 D1 8D 44 24 10 8D 74 8C 14 8B 0C 90 89 08 83 C0 04 39 F0 75 F4 B8 04 00 00 00 29 D0 C7 44 84 10 00 00 00 00 83 C0 01 83 F8 03 7E F0 83 FB 01 8B 44 24 10 19 FF F7 D7 83 E7 20 E9 21 FF FF FF 8B 44 84 10 B9 20 00 00 00 29 F1 D3 E0 09 C3 83 FA 02 75 28 8B 44 94 14 8B 54 94 10 D3 E0 89 F1 D3 EA 09 D0 BA 01 00 00 00 89 44 24 10 B8 02 00 00 00 89 F1 D3 ED 89 6C 94 10 EB A1 B8 01 00 00 00 31 D2 EB ED 90 90 90 }
	condition:
		$1
}

rule file_10_0_0 {
	meta:
		name = "___bid_round64_2_18"
		size = 624
		refs = "001d ___bid_midpoint64 0033 ___bid_Kx64 00b0 ___bid_Ex64m64 00d1 ___bid_mask64 00dc ___bid_half64 0121 ___bid_ten2mxtrunc64 0177 ___bid_ten2k64"
	strings:
		$1 = { 83 EC 34 89 6C 24 30 8B 6C 24 3C 89 5C 24 24 89 7C 24 2C 89 74 24 28 83 ED 01 8B 0C ED ?? ?? ?? ?? 8B 1C ED ?? ?? ?? ?? 03 4C 24 40 13 5C 24 44 8B 3C ED ?? ?? ?? ?? 89 DE 8B 1C ED ?? ?? ?? ?? 89 F0 F7 E7 89 44 24 08 89 F0 89 54 24 0C F7 E3 89 44 24 18 89 C8 89 54 24 1C F7 E7 89 54 24 14 8B 7C 24 14 31 D2 89 44 24 10 8B 44 24 08 89 FE 31 FF 01 C6 89 C8 11 D7 F7 E3 01 C6 11 D7 8B 54 24 0C 89 FB 89 D9 89 74 24 04 89 D0 31 D2 03 44 24 18 13 54 24 1C 31 DB 01 C8 11 DA 31 C9 89 0C 24 8B 4C 24 10 31 DB 01 0C 24 89 D6 0F B6 0C AD ?? ?? ?? ?? 11 5C 24 04 89 C3 31 FF 0F AD D3 D3 EE F6 C1 20 0F 45 DE 0F 45 F7 89 5C 24 18 8B 1C ED ?? ?? ?? ?? 89 74 24 1C 8B 34 ED ?? ?? ?? ?? 21 C3 8B 04 ED ?? ?? ?? ?? 21 D0 8B 14 ED ?? ?? ?? ?? 39 D0 0F 87 CE 00 00 00 0F 83 C0 00 00 00 31 C2 31 DE 09 F2 0F 84 CB 00 00 00 8B 54 24 5C C7 02 01 00 00 00 09 D8 75 4A 8B 4C 24 04 3B 0C ED ?? ?? ?? ?? 77 3D 0F 83 E3 00 00 00 8B 44 24 18 83 E0 01 85 C0 0F 84 E9 00 00 00 8B 44 24 54 83 44 24 18 FF 8B 74 24 58 83 54 24 1C FF C7 00 01 00 00 00 8B 44 24 5C C7 06 00 00 00 00 C7 00 00 00 00 00 8B 44 24 38 2B 44 24 3C 8B 74 24 1C 8B 54 24 18 33 34 C5 ?? ?? ?? ?? 33 14 C5 ?? ?? ?? ?? 09 D6 0F 84 BE 00 00 00 8B 44 24 4C C7 00 00 00 00 00 8B 44 24 48 8B 54 24 18 8B 4C 24 1C 8B 5C 24 24 8B 74 24 28 89 10 8B 7C 24 2C 89 48 04 8B 6C 24 30 83 C4 34 C3 8D B4 26 00 00 00 00 39 F3 0F 86 38 FF FF FF 8B 74 24 58 C7 06 01 00 00 00 E9 3F FF FF FF 8B 74 24 04 0B 34 24 0F 84 28 FF FF FF 8B 54 24 04 3B 14 ED ?? ?? ?? ?? 0F 82 21 FF FF FF 77 D1 8B 0C 24 3B 0C ED ?? ?? ?? ?? 0F 86 0F FF FF FF EB BF 8D B4 26 00 00 00 00 8B 1C 24 3B 1C ED ?? ?? ?? ?? 0F 87 44 FF FF FF E9 08 FF FF FF 8B 44 24 50 8B 54 24 58 8B 4C 24 5C C7 00 01 00 00 00 C7 02 00 00 00 00 C7 01 00 00 00 00 E9 1C FF FF FF 8B 34 C5 ?? ?? ?? ?? 8B 1C C5 ?? ?? ?? ?? 89 74 24 1C 8B 74 24 4C 89 5C 24 18 C7 06 01 00 00 00 E9 27 FF FF FF 8D 76 00 }
	condition:
		$1
}

rule file_10_1_0 {
	meta:
		name = "___bid_round128_19_38"
		size = 2656
		refs = "0065 ___bid_midpoint64 0081 ___bid_Kx128 038e ___bid_Ex128m128 041f ___bid_mask128 0437 ___bid_half128 0468 ___bid_ten2mxtrunc128 04f8 ___bid_ten2k64 0565 ___bid_midpoint128 0629 ___bid_ten2k128"
	strings:
		$1 = { 55 57 56 53 83 EC 7C 8B 84 24 98 00 00 00 8B AC 24 94 00 00 00 89 44 24 60 8B 84 24 9C 00 00 00 83 ED 01 8B 4C 24 60 83 FD 12 89 44 24 64 8B 84 24 A0 00 00 00 8B 5C 24 64 89 44 24 68 8B 84 24 A4 00 00 00 8B 74 24 68 89 44 24 6C 8B 7C 24 6C 89 74 24 10 89 7C 24 14 0F 8F F6 04 00 00 89 C8 89 DA 03 04 ED ?? ?? ?? ?? 13 14 ED ?? ?? ?? ?? 39 DA 0F 86 08 06 00 00 89 EB 89 D1 C1 E3 04 8B B3 ?? ?? ?? ?? 89 04 24 8B BB ?? ?? ?? ?? 89 F0 F7 E2 89 7C 24 38 89 74 24 30 89 44 24 18 89 F8 89 54 24 1C F7 E1 89 44 24 20 89 F0 89 54 24 24 F7 24 24 89 54 24 2C 8B 7C 24 2C 31 D2 89 44 24 28 8B 44 24 18 89 FE 31 FF 89 7C 24 0C 8B 7C 24 1C 89 74 24 08 01 44 24 08 8B 44 24 38 11 54 24 0C 89 FE F7 24 24 01 44 24 08 11 54 24 0C 31 FF 89 74 24 18 8B 74 24 20 89 7C 24 1C 8B 7C 24 24 01 74 24 18 11 7C 24 1C 8B 54 24 0C 8B BB ?? ?? ?? ?? 8B 9B ?? ?? ?? ?? 89 D0 31 D2 01 44 24 18 89 F8 11 54 24 1C F7 E1 89 7C 24 20 89 5C 24 54 89 C6 89 D8 89 D7 F7 E1 89 44 24 58 8B 44 24 20 89 54 24 5C F7 24 24 89 54 24 44 8B 5C 24 44 31 D2 89 44 24 40 8B 44 24 54 89 D9 31 DB 01 F1 89 FE 11 D3 F7 24 24 01 C1 11 D3 31 FF 03 74 24 58 89 DA 13 7C 24 5C 89 D0 89 4C 24 4C 31 D2 8B 4C 24 08 01 C6 11 D7 31 C0 89 44 24 48 8B 44 24 40 31 D2 01 44 24 48 89 CB 11 54 24 4C 31 C9 31 D2 89 4C 24 08 8B 44 24 28 01 44 24 08 89 5C 24 0C 11 54 24 0C 01 74 24 08 11 7C 24 0C 3B 7C 24 0C 72 10 0F 86 A8 04 00 00 83 44 24 18 01 83 54 24 1C 00 8B 5C 24 14 8B 44 24 30 8B 4C 24 10 F7 E3 89 44 24 10 8B 44 24 38 89 54 24 14 F7 E3 89 44 24 40 8B 44 24 30 89 54 24 44 F7 E1 89 54 24 34 8B 7C 24 34 31 D2 89 44 24 30 8B 44 24 10 89 FE 31 FF 89 74 24 28 01 44 24 28 8B 44 24 38 89 7C 24 2C 8B 7C 24 14 11 54 24 2C F7 E1 01 44 24 28 89 FE 11 54 24 2C 31 FF 89 74 24 10 8B 74 24 40 01 74 24 10 89 7C 24 14 8B 7C 24 44 11 7C 24 14 8B 54 24 2C 89 D0 31 D2 01 44 24 10 8B 44 24 20 11 54 24 14 F7 E3 89 44 24 38 8B 44 24 54 89 54 24 3C F7 E3 8B 5C 24 3C 89 44 24 40 8B 44 24 20 89 54 24 44 F7 E1 89 54 24 24 8B 7C 24 24 31 D2 89 44 24 20 8B 44 24 38 89 FE 31 FF 01 C6 8B 44 24 54 11 D7 F7 E1 89 D9 01 C6 11 D7 31 DB 03 4C 24 40 89 FA 13 5C 24 44 89 D0 31 D2 01 C1 11 D3 31 C0 89 44 24 38 8B 44 24 20 31 D2 89 74 24 3C 8B 74 24 30 01 44 24 38 8B 44 24 28 11 54 24 3C 89 74 24 20 89 C2 31 C0 03 44 24 20 C7 44 24 24 00 00 00 00 13 54 24 24 01 C8 11 DA 39 D3 72 10 0F 86 8F 03 00 00 83 44 24 10 01 83 54 24 14 00 8B 5C 24 08 B9 01 00 00 00 03 5C 24 38 8B 74 24 0C 13 74 24 3C 89 5C 24 08 31 DB 39 74 24 3C 89 74 24 0C 77 0A 0F 83 67 03 00 00 31 C9 31 DB 8B 74 24 18 01 C8 8B 7C 24 1C 11 DA 01 C6 11 D7 39 FA 0F 87 F1 01 00 00 0F 83 E3 01 00 00 39 D3 C7 44 24 18 01 00 00 00 C7 44 24 1C 00 00 00 00 0F 86 DC 02 00 00 8B 44 24 18 8B 54 24 1C 8B 4C 24 10 8B 5C 24 14 01 C1 89 4C 24 20 8B 0C AD ?? ?? ?? ?? 11 D3 83 FD 12 89 5C 24 24 89 4C 24 28 0F 8F F2 01 00 00 8B 44 24 20 BB 40 00 00 00 8B 54 24 24 29 CB 89 D9 31 DB 0F A5 C2 D3 E0 F6 C1 20 0F B6 4C 24 28 0F 45 D0 0F 45 C3 89 44 24 10 89 F0 31 DB 89 54 24 14 89 FA 0F AD F8 D3 EA F6 C1 20 8B 4C 24 14 0F 45 C2 0F 45 D3 89 54 24 34 8B 54 24 10 31 DB 0B 4C 24 34 89 44 24 30 09 C2 8B 44 24 20 89 54 24 18 8B 54 24 24 89 4C 24 1C 0F B6 4C 24 28 0F AD D0 D3 EA F6 C1 20 8B 0C ED ?? ?? ?? ?? 0F 45 C2 0F 45 D3 8B 1C ED ?? ?? ?? ?? 21 F9 89 CF 8B 0C ED ?? ?? ?? ?? 21 F3 89 DE 8B 1C ED ?? ?? ?? ?? 39 CF 0F 86 83 02 00 00 8B 8C 24 B8 00 00 00 C7 01 01 00 00 00 89 F9 09 F1 75 6F 89 E9 C1 E1 04 8B 99 ?? ?? ?? ?? 8B 89 ?? ?? ?? ?? 39 4C 24 0C 0F 83 E9 02 00 00 8B 4C 24 18 83 E1 01 85 C9 0F 84 D5 04 00 00 83 44 24 18 FF 83 54 24 1C FF 8B 4C 24 18 23 4C 24 1C 83 F9 FF 0F 84 6A 05 00 00 8B 8C 24 B4 00 00 00 8B BC 24 B8 00 00 00 C7 01 01 00 00 00 8B 8C 24 BC 00 00 00 C7 07 00 00 00 00 C7 01 00 00 00 00 8D 76 00 8B 8C 24 90 00 00 00 2B 8C 24 94 00 00 00 83 F9 13 0F 8F 31 01 00 00 89 D7 09 C7 75 1E 8B 74 24 1C 8B 5C 24 18 33 34 CD ?? ?? ?? ?? 33 1C CD ?? ?? ?? ?? 09 DE 0F 84 29 04 00 00 8B 8C 24 AC 00 00 00 C7 01 00 00 00 00 8B B4 24 A8 00 00 00 89 46 08 8B 44 24 18 89 56 0C 8B 54 24 1C 89 06 89 56 04 83 C4 7C 5B 5E 5F 5D C3 8D B6 00 00 00 00 39 F0 0F 86 15 FE FF FF B8 01 00 00 00 31 D2 E9 29 FE FF FF 8B B4 24 94 00 00 00 83 EE 14 89 F0 C1 E0 04 8B 90 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 01 C8 11 DA 39 DA 0F 86 45 01 00 00 C1 E6 04 8B 8E ?? ?? ?? ?? 8B 9E ?? ?? ?? ?? 01 4C 24 10 11 5C 24 14 E9 E1 FA FF FF 0F B6 4C 24 28 31 DB 8B 54 24 24 8B 44 24 20 0F AD D0 D3 EA F6 C1 20 8B 4C 24 20 0F 45 C2 0F 45 D3 8B 1C ED ?? ?? ?? ?? 89 44 24 18 8B 44 24 24 89 54 24 1C 8B 14 ED ?? ?? ?? ?? 23 04 ED ?? ?? ?? ?? 23 0C ED ?? ?? ?? ?? 39 D0 0F 86 09 01 00 00 8B 94 24 B8 00 00 00 C7 02 01 00 00 00 09 C8 0F 84 4E 04 00 00 8B 8C 24 90 00 00 00 31 C0 31 D2 2B 8C 24 94 00 00 00 83 F9 13 0F 8E D5 FE FF FF 83 F9 14 0F 84 94 02 00 00 8D 59 EC C1 E3 04 8B BB ?? ?? ?? ?? 8B B3 ?? ?? ?? ?? 31 D7 31 C6 09 F7 0F 84 A1 02 00 00 8B 9C 24 AC 00 00 00 C7 03 00 00 00 00 E9 C7 FE FF FF 0F 83 FB 00 00 00 C7 44 24 18 00 00 00 00 C7 44 24 1C 00 00 00 00 E9 09 FD FF FF 8D 74 26 00 3B 74 24 08 0F 86 58 FB FF FF E9 49 FB FF FF 90 0F 83 AC 00 00 00 83 44 24 10 01 83 54 24 14 00 E9 E3 F9 FF FF 39 C1 0F 86 73 FC FF FF E9 64 FC FF FF 8B 74 24 08 39 74 24 38 0F 87 8F FC FF FF 31 C9 31 DB E9 86 FC FF FF 8D B4 26 00 00 00 00 73 5E 83 44 24 10 01 83 54 24 14 00 E9 AA FE FF FF 73 72 31 F9 31 F3 09 D9 0F 84 D7 00 00 00 8B 9C 24 BC 00 00 00 C7 03 01 00 00 00 E9 6A FD FF FF 73 1E 31 C2 31 CB 09 DA 0F 84 24 01 00 00 8B 9C 24 BC 00 00 00 C7 03 01 00 00 00 E9 E4 FE FF FF 39 D9 0F 87 CF FE FF FF EB D8 90 8D 74 26 00 39 C8 0F 83 53 FE FF FF 90 8D B4 26 00 00 00 00 EB 90 39 C8 0F 83 3E F9 FF FF 8D B6 00 00 00 00 E9 41 FF FF FF 39 DE 0F 87 01 FD FF FF 8D 76 00 EB 81 39 C1 0F 87 1B FC FF FF 8D B6 00 00 00 00 E9 F2 FE FF FF 77 0F 39 5C 24 08 90 8D 74 26 00 0F 82 06 FD FF FF 33 4C 24 0C 33 5C 24 08 09 D9 0F 85 4A FD FF FF 89 E9 8B 5C 24 4C C1 E1 04 3B 99 ?? ?? ?? ?? 0F 87 35 FD FF FF 0F 82 DB FC FF FF 8B 74 24 48 3B B1 ?? ?? ?? ?? 0F 87 1F FD FF FF E9 C6 FC FF FF 8B 4C 24 0C 0B 4C 24 08 0F 85 BF 00 00 00 8B 5C 24 4C 0B 5C 24 48 0F 84 0D FF FF FF 89 E9 C1 E1 04 8B 99 ?? ?? ?? ?? 8B 89 ?? ?? ?? ?? 33 4C 24 0C 33 5C 24 08 09 D9 0F 85 68 FC FF FF 89 E9 8B 5C 24 4C C1 E1 04 3B 99 ?? ?? ?? ?? 0F 82 53 FC FF FF 0F 87 40 FC FF FF 8B 5C 24 48 3B 99 ?? ?? ?? ?? 0F 86 3D FC FF FF E9 2B FC FF FF 89 FA 09 F2 0F 85 BB FD FF FF 8B 5C 24 0C 0B 5C 24 08 0F 85 9B 01 00 00 8B 54 24 4C 0B 54 24 48 0F 84 B6 FE FF FF 89 EA C1 E2 04 8B 9A ?? ?? ?? ?? 89 5C 24 10 8B 9A ?? ?? ?? ?? 8B 54 24 08 33 5C 24 0C 33 54 24 10 09 D3 0F 84 A9 01 00 00 09 C8 0F 85 83 FD FF FF 31 C0 31 D2 E9 DE FB FF FF 89 E9 C1 E1 04 8B 99 ?? ?? ?? ?? 8B 89 ?? ?? ?? ?? 39 4C 24 0C 0F 87 B0 FB FF FF 0F 82 3F FF FF FF 39 5C 24 08 0F 87 A0 FB FF FF 66 90 E9 2E FF FF FF 8B 1D ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 31 D3 31 C1 09 CB 0F 84 C3 00 00 00 8B BC 24 AC 00 00 00 C7 07 00 00 00 00 E9 39 FC FF FF 90 8B 74 24 1C 33 B3 ?? ?? ?? ?? 8B 9B ?? ?? ?? ?? 33 5C 24 18 09 DE 0F 85 43 FD FF FF 83 E9 15 C1 E1 04 8B 81 ?? ?? ?? ?? 8B 91 ?? ?? ?? ?? 89 44 24 18 8B 81 ?? ?? ?? ?? 89 54 24 1C 8B 91 ?? ?? ?? ?? 8B 8C 24 AC 00 00 00 C7 01 01 00 00 00 E9 E4 FB FF FF 8B 14 CD ?? ?? ?? ?? 8B 04 CD ?? ?? ?? ?? 89 54 24 1C 8B 94 24 AC 00 00 00 89 44 24 18 31 C0 C7 02 01 00 00 00 31 D2 E9 B8 FB FF FF 8B 8C 24 B0 00 00 00 8B 9C 24 B8 00 00 00 8B B4 24 BC 00 00 00 C7 01 01 00 00 00 C7 03 00 00 00 00 C7 06 00 00 00 00 E9 44 FB FF FF 8D 74 26 00 8B 5C 24 1C 8B 4C 24 18 33 1D ?? ?? ?? ?? 33 0D ?? ?? ?? ?? 09 CB 0F 85 21 FF FF FF 8B 35 ?? ?? ?? ?? 31 C0 31 D2 8B 1D ?? ?? ?? ?? 89 74 24 1C 8B B4 24 AC 00 00 00 89 5C 24 18 C7 06 01 00 00 00 E9 42 FB FF FF 89 EA C1 E2 04 8B 9A ?? ?? ?? ?? 89 5C 24 10 8B 9A ?? ?? ?? ?? 39 5C 24 0C 0F 87 F3 FB FF FF 0F 82 63 FE FF FF 8B 54 24 10 39 54 24 08 0F 87 DF FB FF FF E9 50 FE FF FF 66 90 83 C0 FF 83 D2 FF E9 8B FA FF FF 89 EA 8B 5C 24 4C C1 E2 04 3B 9A ?? ?? ?? ?? 0F 82 42 FE FF FF 0F 87 B2 FB FF FF 8B 5C 24 48 3B 9A ?? ?? ?? ?? 0F 86 2C FE FF FF E9 9D FB FF FF 31 C0 31 D2 E9 07 FA FF FF 8D B6 00 00 00 00 8D BF 00 00 00 00 }
	condition:
		$1
}

rule file_10_2_0 {
	meta:
		name = "___bid_round192_39_57"
		size = 8560
		refs = "00b8 ___bid_midpoint64 0111 ___bid_Kx192 02d5 ___bid_midpoint128 06e3 ___bid_midpoint192 12e1 ___bid_Ex192m192 139e ___bid_mask192 13b0 ___bid_half192 1438 ___bid_ten2k64 16cc ___bid_ten2k128 1728 ___bid_ten2mxtrunc192 19b9 ___bid_ten2k256"
	strings:
		$1 = { 55 57 56 53 81 EC DC 00 00 00 8B 84 24 F8 00 00 00 89 84 24 B0 00 00 00 8B 84 24 FC 00 00 00 89 84 24 B4 00 00 00 8B 84 24 00 01 00 00 8B 94 24 B4 00 00 00 89 84 24 B8 00 00 00 8B 84 24 04 01 00 00 8B B4 24 B8 00 00 00 89 84 24 BC 00 00 00 8B 84 24 08 01 00 00 8B BC 24 BC 00 00 00 89 84 24 C0 00 00 00 8B 84 24 0C 01 00 00 8B 8C 24 C0 00 00 00 89 84 24 C4 00 00 00 8B 9C 24 C4 00 00 00 8B 84 24 B0 00 00 00 89 8C 24 88 00 00 00 89 9C 24 8C 00 00 00 8B 9C 24 F4 00 00 00 83 EB 01 83 FB 12 89 5C 24 5C 0F 8F 04 02 00 00 8B 6C 24 5C 89 C1 89 D3 03 0C ED ?? ?? ?? ?? 13 1C ED ?? ?? ?? ?? 89 4C 24 30 39 D3 89 5C 24 34 0F 83 1D 09 00 00 89 F0 89 FA 83 C0 01 83 D2 00 89 D1 09 C1 0F 85 79 1A 00 00 8B 7C 24 5C 8B 54 24 34 83 84 24 88 00 00 00 01 83 94 24 8C 00 00 00 00 8D 1C 7F 8B 74 24 30 8D 3C DD 00 00 00 00 89 D0 8B 8F ?? ?? ?? ?? 89 54 24 08 8B AF ?? ?? ?? ?? C7 44 24 3C 00 00 00 00 F7 E1 89 4C 24 60 89 AC 24 98 00 00 00 89 44 24 18 89 C8 89 54 24 1C F7 E6 89 54 24 24 8B 5C 24 24 31 D2 89 44 24 20 8B 44 24 18 89 D9 31 DB 01 C1 89 E8 8B AF ?? ?? ?? ?? 11 D3 F7 E6 89 AC 24 A4 00 00 00 8B AF ?? ?? ?? ?? 01 C1 8B 44 24 08 11 D3 31 D2 89 54 24 54 89 6C 24 70 F7 E5 89 5C 24 50 89 44 24 30 89 E8 89 54 24 34 F7 E6 89 54 24 14 8B 54 24 30 89 44 24 10 89 54 24 38 8B 54 24 14 89 D0 31 D2 89 44 24 28 8B 44 24 38 01 44 24 28 8B 84 24 A4 00 00 00 89 54 24 2C 8B 54 24 3C 11 54 24 2C 8B AF ?? ?? ?? ?? F7 E6 8B BF ?? ?? ?? ?? 01 44 24 28 8B 44 24 28 11 54 24 2C 89 AC 24 A0 00 00 00 8B 6C 24 1C 89 C2 31 C0 89 44 24 48 8B 44 24 10 89 54 24 4C 31 D2 01 44 24 48 8B 44 24 08 11 54 24 4C F7 A4 24 98 00 00 00 89 7C 24 68 89 EF 31 ED 01 C7 11 D5 03 7C 24 50 13 6C 24 54 03 7C 24 48 13 6C 24 4C 89 BC 24 90 00 00 00 89 AC 24 94 00 00 00 C7 44 24 10 00 00 00 00 C7 44 24 14 00 00 00 00 C7 84 24 80 00 00 00 00 00 00 00 C7 84 24 84 00 00 00 00 00 00 00 C7 44 24 50 00 00 00 00 C7 44 24 54 00 00 00 00 C7 44 24 40 00 00 00 00 C7 44 24 44 00 00 00 00 C7 84 24 C8 00 00 00 00 00 00 00 C7 84 24 CC 00 00 00 00 00 00 00 C7 44 24 18 00 00 00 00 C7 44 24 1C 00 00 00 00 E9 F0 0A 00 00 83 7C 24 5C 25 8B 9C 24 F4 00 00 00 0F 8F 15 04 00 00 83 EB 14 89 C1 89 5C 24 10 C1 E3 04 89 DD 89 D3 03 8D ?? ?? ?? ?? 13 9D ?? ?? ?? ?? 89 4C 24 08 39 D3 89 5C 24 0C 0F 86 26 18 00 00 8B 4C 24 10 89 F0 89 FA C1 E1 04 03 81 ?? ?? ?? ?? 13 91 ?? ?? ?? ?? 39 FA 0F 82 72 19 00 00 0F 86 64 19 00 00 89 D5 89 C7 8B 5C 24 5C 8D 34 5B C1 E6 03 8B 8E ?? ?? ?? ?? 8B 9E ?? ?? ?? ?? 89 C8 F7 E5 89 5C 24 38 89 9C 24 98 00 00 00 89 4C 24 20 89 44 24 10 89 C8 89 54 24 14 F7 E7 89 4C 24 60 89 54 24 1C 8B 5C 24 1C 31 D2 89 44 24 18 8B 44 24 10 89 D9 31 DB 01 C1 8B 44 24 38 11 D3 F7 E7 01 C1 11 D3 89 DA 8B 9E ?? ?? ?? ?? 89 4C 24 7C 8B 8E ?? ?? ?? ?? 89 D0 89 84 24 C8 00 00 00 31 C0 31 D2 89 44 24 78 8B 44 24 18 89 94 24 CC 00 00 00 31 D2 01 44 24 78 89 C8 11 54 24 7C F7 E5 89 4C 24 30 89 5C 24 48 89 4C 24 70 89 44 24 50 89 C8 89 54 24 54 F7 E7 89 9C 24 A4 00 00 00 89 44 24 18 89 54 24 1C 8B 5C 24 1C 31 D2 8B 44 24 50 89 D9 31 DB 01 C1 8B 44 24 48 11 D3 F7 E7 01 C1 11 D3 89 DA 89 4C 24 2C 8B 8E ?? ?? ?? ?? 89 D0 89 84 24 80 00 00 00 31 C0 31 D2 89 44 24 28 8B 44 24 18 89 94 24 84 00 00 00 31 D2 8B B6 ?? ?? ?? ?? 01 44 24 28 89 C8 11 54 24 2C F7 E5 89 4C 24 68 89 B4 24 A0 00 00 00 89 44 24 18 89 C8 89 54 24 1C F7 E7 89 54 24 44 8B 5C 24 44 31 D2 89 44 24 40 8B 44 24 18 89 D9 31 DB 01 C1 89 F0 11 D3 F7 E7 8B 7C 24 1C 01 C1 8B 84 24 A0 00 00 00 89 FE 11 D3 31 FF 89 74 24 18 89 7C 24 1C F7 E5 01 44 24 18 11 54 24 1C 31 D2 01 5C 24 18 11 54 24 1C 31 F6 8B 7C 24 14 31 DB 8B 44 24 38 89 B4 24 90 00 00 00 89 8C 24 94 00 00 00 8B 4C 24 40 89 FE 31 FF F7 E5 89 74 24 10 8B B4 24 C8 00 00 00 01 44 24 10 B8 01 00 00 00 89 7C 24 14 8B BC 24 CC 00 00 00 11 54 24 14 01 74 24 10 8B 74 24 28 11 7C 24 14 01 74 24 10 8B 7C 24 2C 11 7C 24 14 31 D2 8B 74 24 14 39 F7 0F 87 14 00 00 00 0F 82 CE 16 00 00 8B 7C 24 10 39 7C 24 28 0F 86 C0 16 00 00 8B B4 24 90 00 00 00 8B BC 24 94 00 00 00 89 84 24 C8 00 00 00 89 94 24 CC 00 00 00 01 CE 11 DF 8B 5C 24 54 89 74 24 40 01 44 24 40 8B 44 24 48 89 7C 24 44 89 D9 11 54 24 44 31 DB 8B 74 24 44 F7 E5 89 4C 24 50 8B 8C 24 80 00 00 00 01 44 24 50 8B 44 24 30 89 5C 24 54 8B 9C 24 84 00 00 00 11 54 24 54 01 4C 24 50 11 5C 24 54 8B 5C 24 40 01 5C 24 50 11 74 24 54 8B 74 24 08 F7 E6 89 84 24 80 00 00 00 89 94 24 84 00 00 00 8B 54 24 0C 8B 9C 24 84 00 00 00 89 54 24 08 89 D0 F7 64 24 30 89 D9 89 4C 24 28 31 DB 89 5C 24 2C 89 44 24 30 8B 44 24 30 89 54 24 34 31 D2 01 44 24 28 8B 44 24 48 11 54 24 2C F7 E6 01 44 24 28 8B 4C 24 28 11 54 24 2C 31 D2 8B 84 24 80 00 00 00 89 CB 31 C9 89 4C 24 48 01 44 24 48 8B 44 24 08 89 5C 24 4C 11 54 24 4C 31 DB F7 64 24 20 89 C7 8B 44 24 08 89 D5 F7 64 24 38 89 84 24 90 00 00 00 8B 44 24 20 89 94 24 94 00 00 00 C7 84 24 80 00 00 00 01 00 00 00 C7 84 24 84 00 00 00 00 00 00 00 F7 E6 89 44 24 20 8B 44 24 38 89 D1 89 54 24 24 31 D2 01 F9 11 D3 89 EF F7 E6 01 C1 11 D3 31 ED 89 DA 89 D0 31 D2 03 BC 24 90 00 00 00 13 AC 24 94 00 00 00 01 C7 8B 44 24 78 11 D5 8B 54 24 7C 03 7C 24 48 13 6C 24 4C 01 F8 11 EA 39 54 24 7C 89 84 24 90 00 00 00 89 94 24 94 00 00 00 77 10 0F 82 35 15 00 00 39 44 24 78 0F 86 2B 15 00 00 8B 84 24 80 00 00 00 8B 94 24 84 00 00 00 03 44 24 10 13 54 24 14 89 44 24 10 89 54 24 14 E9 C9 06 00 00 83 EB 27 89 C1 8D 2C 5B 03 0C ED ?? ?? ?? ?? 89 5C 24 10 89 D3 13 1C ED ?? ?? ?? ?? 89 4C 24 28 39 D3 89 5C 24 2C 0F 86 AC 13 00 00 8B 4C 24 10 8D 04 49 8B 14 C5 ?? ?? ?? ?? 8B 04 C5 ?? ?? ?? ?? 01 F0 11 FA 39 FA 77 16 0F 83 99 15 00 00 83 84 24 88 00 00 00 01 83 94 24 8C 00 00 00 00 8B 5C 24 10 89 D5 8D 0C 5B 8B 5C 24 5C 8B 34 CD ?? ?? ?? ?? 01 B4 24 88 00 00 00 8B 3C CD ?? ?? ?? ?? 8D 34 5B 11 BC 24 8C 00 00 00 89 C7 C1 E6 03 8B 8E ?? ?? ?? ?? 8B 9E ?? ?? ?? ?? 89 C8 F7 E2 89 5C 24 78 89 9C 24 98 00 00 00 89 4C 24 20 89 44 24 10 89 C8 89 54 24 14 F7 E7 89 4C 24 60 89 54 24 1C 8B 5C 24 1C 31 D2 89 44 24 18 8B 44 24 10 89 D9 31 DB 01 C1 8B 44 24 78 11 D3 F7 E7 01 C1 11 D3 89 DA 89 8C 24 84 00 00 00 8B 8E ?? ?? ?? ?? 89 D0 89 44 24 40 31 C0 31 D2 89 84 24 80 00 00 00 8B 44 24 18 89 54 24 44 31 D2 01 84 24 80 00 00 00 89 C8 11 94 24 84 00 00 00 F7 E5 89 4C 24 38 8B 9E ?? ?? ?? ?? 89 4C 24 70 89 44 24 50 89 C8 89 54 24 54 F7 E7 89 5C 24 48 89 9C 24 A4 00 00 00 89 54 24 1C 8B 5C 24 1C 31 D2 89 44 24 18 8B 44 24 50 89 D9 31 DB 01 C1 8B 44 24 48 11 D3 F7 E7 01 C1 11 D3 89 DA 89 4C 24 34 8B 8E ?? ?? ?? ?? 89 D0 89 84 24 90 00 00 00 31 C0 31 D2 89 44 24 30 8B 44 24 18 89 94 24 94 00 00 00 31 D2 8B B6 ?? ?? ?? ?? 01 44 24 30 89 C8 11 54 24 34 F7 E5 89 4C 24 68 89 B4 24 A0 00 00 00 89 44 24 18 89 C8 89 54 24 1C F7 E7 89 54 24 0C 8B 5C 24 0C 31 D2 89 44 24 08 8B 44 24 18 89 D9 31 DB 01 C1 89 F0 11 D3 F7 E7 8B 7C 24 1C 01 C1 89 FE 11 D3 31 FF 89 74 24 18 89 7C 24 1C 8B 84 24 A0 00 00 00 8B 7C 24 14 89 8C 24 AC 00 00 00 8B 4C 24 08 F7 E5 01 44 24 18 8B 44 24 78 11 54 24 1C 31 D2 01 5C 24 18 11 54 24 1C 31 F6 F7 E5 31 DB 89 B4 24 A8 00 00 00 89 FE 31 FF 89 74 24 10 8B 74 24 40 01 44 24 10 B8 01 00 00 00 89 7C 24 14 8B 7C 24 44 11 54 24 14 01 74 24 10 8B 74 24 30 11 7C 24 14 01 74 24 10 8B 7C 24 34 11 7C 24 14 31 D2 8B 74 24 14 39 F7 0F 87 19 00 00 00 0F 82 B3 12 00 00 8B 7C 24 10 39 7C 24 30 0F 86 A5 12 00 00 90 8D 74 26 00 8B B4 24 A8 00 00 00 8B BC 24 AC 00 00 00 89 84 24 C8 00 00 00 89 94 24 CC 00 00 00 01 CE 11 DF 8B 5C 24 54 89 74 24 40 01 44 24 40 8B 44 24 48 89 7C 24 44 89 D9 11 54 24 44 31 DB 8B 74 24 44 F7 E5 89 4C 24 50 8B 8C 24 90 00 00 00 01 44 24 50 89 5C 24 54 8B 9C 24 94 00 00 00 11 54 24 54 01 4C 24 50 11 5C 24 54 8B 5C 24 40 01 5C 24 50 11 74 24 54 8B 74 24 2C 89 74 24 08 89 F0 8B 74 24 28 F7 64 24 20 89 C7 89 D5 E9 7E 02 00 00 90 0F 86 0B 11 00 00 89 FD 89 F7 8B 5C 24 5C 8D 34 5B C1 E6 03 8B 8E ?? ?? ?? ?? 8B 9E ?? ?? ?? ?? 89 C8 F7 E5 89 5C 24 78 89 9C 24 98 00 00 00 89 4C 24 20 89 44 24 10 89 C8 89 54 24 14 F7 E7 89 4C 24 60 89 54 24 1C 8B 5C 24 1C 31 D2 89 44 24 18 8B 44 24 10 89 D9 31 DB 01 C1 8B 44 24 78 11 D3 F7 E7 01 C1 11 D3 89 DA 8B 9E ?? ?? ?? ?? 89 8C 24 84 00 00 00 8B 8E ?? ?? ?? ?? 89 D0 89 44 24 40 31 C0 31 D2 89 84 24 80 00 00 00 8B 44 24 18 89 54 24 44 31 D2 01 84 24 80 00 00 00 89 C8 11 94 24 84 00 00 00 F7 E5 89 4C 24 38 89 5C 24 48 89 4C 24 70 89 44 24 50 89 C8 89 54 24 54 F7 E7 89 9C 24 A4 00 00 00 89 44 24 18 89 54 24 1C 8B 5C 24 1C 31 D2 8B 44 24 50 89 D9 31 DB 01 C1 8B 44 24 48 11 D3 F7 E7 01 C1 11 D3 89 DA 89 4C 24 0C 8B 8E ?? ?? ?? ?? 89 D0 89 84 24 90 00 00 00 31 C0 31 D2 89 44 24 08 8B 44 24 18 89 94 24 94 00 00 00 31 D2 8B B6 ?? ?? ?? ?? 01 44 24 08 89 C8 11 54 24 0C F7 E5 89 4C 24 68 89 B4 24 A0 00 00 00 89 44 24 18 89 C8 89 54 24 1C F7 E7 89 54 24 2C 8B 5C 24 2C 31 D2 89 44 24 28 8B 44 24 18 89 D9 31 DB 01 C1 89 F0 11 D3 F7 E7 8B 7C 24 1C 01 C1 8B 84 24 A0 00 00 00 89 FE 11 D3 31 FF 89 74 24 18 89 7C 24 1C F7 E5 01 44 24 18 11 54 24 1C 31 D2 01 5C 24 18 11 54 24 1C 31 F6 8B 7C 24 14 31 DB 8B 44 24 78 89 B4 24 A8 00 00 00 89 8C 24 AC 00 00 00 8B 4C 24 28 89 FE 31 FF F7 E5 89 74 24 10 8B 74 24 40 01 44 24 10 B8 01 00 00 00 89 7C 24 14 8B 7C 24 44 11 54 24 14 01 74 24 10 8B 74 24 08 11 7C 24 14 01 74 24 10 8B 7C 24 0C 11 7C 24 14 31 D2 8B 74 24 14 39 F7 0F 86 A2 0D 00 00 8B B4 24 A8 00 00 00 8B BC 24 AC 00 00 00 89 84 24 C8 00 00 00 89 94 24 CC 00 00 00 01 CE 11 DF 8B 5C 24 54 89 74 24 40 01 44 24 40 8B 44 24 48 89 7C 24 44 89 D9 11 54 24 44 31 DB 8B 74 24 44 F7 E5 89 4C 24 50 8B 8C 24 90 00 00 00 01 44 24 50 89 5C 24 54 8B 9C 24 94 00 00 00 11 54 24 54 01 4C 24 50 11 5C 24 54 8B 5C 24 40 01 5C 24 50 11 74 24 54 8B 74 24 34 89 74 24 08 89 F0 8B 74 24 30 F7 64 24 20 89 C7 89 D5 8B 44 24 20 31 DB F7 E6 89 44 24 20 8B 44 24 78 89 D1 89 54 24 24 31 D2 01 F9 11 D3 89 EF F7 E6 01 C1 11 D3 89 DA 89 D0 31 D2 89 84 24 A8 00 00 00 8B 44 24 08 89 94 24 AC 00 00 00 F7 64 24 38 89 44 24 30 8B 44 24 38 89 54 24 34 F7 E6 89 44 24 38 89 D0 31 D2 89 44 24 28 8B 44 24 30 89 54 24 2C 31 D2 01 44 24 28 8B 44 24 48 11 54 24 2C F7 E6 01 44 24 28 8B 44 24 28 11 54 24 2C 89 C2 B8 00 00 00 00 89 44 24 48 8B 44 24 38 89 54 24 4C 31 D2 01 44 24 48 11 54 24 4C 31 ED 8B 44 24 08 F7 64 24 78 C7 44 24 38 01 00 00 00 C7 44 24 3C 00 00 00 00 01 C7 8B 84 24 80 00 00 00 11 D5 8B 94 24 84 00 00 00 03 BC 24 A8 00 00 00 13 AC 24 AC 00 00 00 03 7C 24 48 13 6C 24 4C 01 F8 11 EA 39 94 24 84 00 00 00 89 84 24 90 00 00 00 89 94 24 94 00 00 00 77 16 0F 83 75 0C 00 00 C7 44 24 38 00 00 00 00 C7 44 24 3C 00 00 00 00 8B 44 24 38 8B 54 24 3C 89 84 24 80 00 00 00 89 94 24 84 00 00 00 03 44 24 10 13 54 24 14 89 44 24 10 89 54 24 14 8B 54 24 20 31 C0 C7 44 24 3C 00 00 00 00 89 44 24 78 8B 84 24 A4 00 00 00 89 4C 24 7C 8B 4C 24 3C 89 54 24 38 8B 54 24 38 01 54 24 78 11 4C 24 7C F7 64 24 08 89 84 24 A8 00 00 00 8B 44 24 68 89 94 24 AC 00 00 00 F7 64 24 08 89 44 24 38 8B 84 24 A0 00 00 00 89 54 24 3C F7 64 24 08 89 44 24 08 8B 44 24 68 89 54 24 0C F7 E6 89 54 24 24 8B 5C 24 24 31 D2 89 44 24 20 8B 44 24 38 89 D9 31 DB 01 C1 8B 84 24 A0 00 00 00 11 D3 F7 E6 01 C1 11 D3 8B 54 24 3C 89 D0 31 D2 89 44 24 38 8B 44 24 08 89 54 24 3C 8B 54 24 0C 01 44 24 38 11 54 24 3C 31 D2 01 5C 24 38 11 54 24 3C 39 6C 24 4C C7 44 24 08 01 00 00 00 C7 44 24 0C 00 00 00 00 77 10 0F 82 26 07 00 00 39 7C 24 48 0F 86 1C 07 00 00 8B 44 24 20 31 D2 89 CB 03 44 24 08 13 54 24 0C 31 C9 8B B4 24 AC 00 00 00 01 C8 11 DA 8B 5C 24 34 89 D9 31 DB 89 5C 24 34 8B 9C 24 A8 00 00 00 89 4C 24 30 01 5C 24 30 8B 5C 24 2C 11 74 24 34 89 D9 31 DB 01 4C 24 30 11 5C 24 34 01 44 24 30 11 54 24 34 3B 54 24 34 77 10 0F 82 AF 05 00 00 3B 44 24 30 0F 86 A5 05 00 00 B9 01 00 00 00 31 DB 8B 74 24 38 8B 7C 24 3C 01 CE 11 DF 89 7C 24 3C 8B 7C 24 54 39 7C 24 44 89 74 24 38 77 14 0F 82 9A 05 00 00 8B 6C 24 50 39 6C 24 40 0F 86 8C 05 00 00 B8 01 00 00 00 31 D2 8B 74 24 18 8B 8C 24 8C 00 00 00 8B 7C 24 1C 01 C6 8B 44 24 60 89 74 24 18 8B B4 24 88 00 00 00 11 D7 89 7C 24 1C F7 E1 89 44 24 08 8B 84 24 98 00 00 00 89 54 24 0C F7 E1 89 84 24 88 00 00 00 8B 44 24 60 89 94 24 8C 00 00 00 F7 E6 89 54 24 64 8B 6C 24 64 31 D2 89 44 24 60 8B 44 24 08 89 EF 31 ED 89 7C 24 40 01 44 24 40 8B 84 24 98 00 00 00 89 6C 24 44 11 54 24 44 F7 E6 01 44 24 40 8B 7C 24 40 11 54 24 44 31 D2 8B 44 24 60 89 FD 31 FF 89 7C 24 48 89 6C 24 4C 01 44 24 48 8B 44 24 70 11 54 24 4C F7 E1 89 44 24 20 8B 84 24 A4 00 00 00 89 54 24 24 F7 E1 89 84 24 98 00 00 00 8B 44 24 70 89 94 24 9C 00 00 00 F7 E6 89 54 24 74 8B }
	condition:
		$1
}

rule file_10_3_0 {
	meta:
		name = "___bid_round256_58_76"
		size = 31712
		refs = "00f0 ___bid_midpoint64 0147 ___bid_Kx256 07a8 ___bid_midpoint128 107b ___bid_midpoint192 2bf8 ___bid_Ex256m256 2d13 ___bid_mask256 2d25 ___bid_half256 3137 ___bid_ten2k128 31ac ___bid_ten2mxtrunc256 32b7 ___bid_ten2k64 3410 ___bid_ten2k256 41a2 ___bid_midpoint256"
	strings:
		$1 = { 55 57 56 53 81 EC 6C 01 00 00 8B 84 24 88 01 00 00 89 84 24 40 01 00 00 8B 84 24 8C 01 00 00 89 84 24 44 01 00 00 8B 84 24 90 01 00 00 8B 94 24 44 01 00 00 89 84 24 48 01 00 00 8B 84 24 94 01 00 00 8B B4 24 48 01 00 00 89 84 24 4C 01 00 00 8B 84 24 98 01 00 00 8B BC 24 4C 01 00 00 89 84 24 50 01 00 00 8B 84 24 9C 01 00 00 8B 8C 24 50 01 00 00 89 84 24 54 01 00 00 8B 84 24 A0 01 00 00 8B 9C 24 54 01 00 00 89 4C 24 10 89 84 24 58 01 00 00 8B 84 24 A4 01 00 00 89 5C 24 14 8B 8C 24 58 01 00 00 89 84 24 5C 01 00 00 8B 9C 24 5C 01 00 00 8B 84 24 40 01 00 00 89 8C 24 F8 00 00 00 89 9C 24 FC 00 00 00 8B 9C 24 84 01 00 00 83 EB 01 83 FB 12 89 9C 24 A4 00 00 00 0F 8F A5 06 00 00 8B AC 24 A4 00 00 00 89 C1 89 D3 03 0C ED ?? ?? ?? ?? 13 1C ED ?? ?? ?? ?? 89 4C 24 18 39 D3 89 5C 24 1C 0F 83 EA 18 00 00 89 F0 89 FA 83 C0 01 83 D2 00 89 D1 09 C1 0F 85 09 35 00 00 8B 74 24 10 8B 7C 24 14 83 C6 01 83 D7 00 89 FA 09 F2 0F 84 D9 6B 00 00 89 FD 89 F7 8B B4 24 A4 00 00 00 C1 E6 05 8B 8E ?? ?? ?? ?? 8B 9E ?? ?? ?? ?? 89 C8 F7 E5 89 9C 24 88 00 00 00 89 9C 24 1C 01 00 00 89 4C 24 28 89 44 24 30 89 C8 89 54 24 34 F7 E7 89 4C 24 78 89 54 24 0C 8B 5C 24 0C 31 D2 89 44 24 08 8B 44 24 30 89 D9 31 DB 01 C1 8B 84 24 88 00 00 00 11 D3 F7 E7 01 C1 11 D3 89 DA 8B 9E ?? ?? ?? ?? 89 4C 24 4C 8B 8E ?? ?? ?? ?? 89 D0 89 44 24 58 31 C0 31 D2 89 44 24 48 8B 44 24 08 89 54 24 5C 31 D2 01 44 24 48 89 C8 11 54 24 4C F7 E5 89 4C 24 38 89 9C 24 98 00 00 00 89 8C 24 90 00 00 00 89 84 24 80 00 00 00 89 C8 89 94 24 84 00 00 00 F7 E7 89 9C 24 18 01 00 00 89 44 24 20 89 54 24 24 8B 5C 24 24 31 D2 8B 84 24 80 00 00 00 89 D9 31 DB 01 C1 8B 84 24 98 00 00 00 11 D3 F7 E7 01 C1 11 D3 89 DA 8B 9E ?? ?? ?? ?? 89 4C 24 0C 8B 8E ?? ?? ?? ?? 89 D0 89 84 24 B8 00 00 00 31 C0 31 D2 89 44 24 08 8B 44 24 20 89 94 24 BC 00 00 00 31 D2 01 44 24 08 89 C8 11 54 24 0C F7 E5 89 5C 24 10 89 9C 24 04 01 00 00 89 4C 24 50 89 44 24 70 89 C8 89 54 24 74 F7 E7 89 8C 24 F0 00 00 00 89 54 24 24 8B 5C 24 24 31 D2 89 44 24 20 8B 44 24 70 89 D9 31 DB 01 C1 8B 44 24 10 11 D3 F7 E7 01 C1 11 D3 8B 54 24 74 89 D0 31 D2 89 44 24 70 8B 44 24 10 89 54 24 74 F7 E5 01 44 24 70 11 54 24 74 89 DA 89 D0 31 D2 89 4C 24 6C 8B 8E ?? ?? ?? ?? 01 44 24 70 11 54 24 74 31 C0 8B 54 24 20 89 44 24 68 89 C8 8B B6 ?? ?? ?? ?? 89 8C 24 C0 00 00 00 C7 44 24 44 00 00 00 00 89 54 24 40 F7 E5 89 B4 24 00 01 00 00 89 44 24 20 89 C8 89 54 24 24 F7 E7 89 54 24 64 8B 5C 24 64 31 D2 89 44 24 60 8B 44 24 20 89 D9 31 DB 01 C1 89 F0 11 D3 F7 E7 8B 7C 24 24 01 C1 8B 84 24 00 01 00 00 89 FE 11 D3 31 FF 89 74 24 20 89 7C 24 24 F7 E5 01 44 24 20 11 54 24 24 31 D2 01 5C 24 20 11 54 24 24 31 F6 8B 44 24 60 31 D2 8B 5C 24 34 89 B4 24 D8 00 00 00 8B 74 24 0C 01 84 24 D8 00 00 00 8B 84 24 88 00 00 00 89 8C 24 DC 00 00 00 89 D9 11 94 24 DC 00 00 00 31 DB F7 E5 89 4C 24 30 8B 4C 24 58 01 44 24 30 B8 01 00 00 00 89 5C 24 34 8B 5C 24 5C 11 54 24 34 01 4C 24 30 11 5C 24 34 8B 5C 24 08 01 5C 24 30 11 74 24 34 31 D2 8B 7C 24 34 39 FE 77 0E 72 08 8B 4C 24 30 39 CB 77 04 31 C0 31 D2 8B 5C 24 68 03 5C 24 40 8B 74 24 6C 8B BC 24 84 00 00 00 13 74 24 44 89 5C 24 68 8B 8C 24 B8 00 00 00 01 44 24 68 8B 9C 24 BC 00 00 00 89 84 24 08 01 00 00 8B 84 24 98 00 00 00 89 74 24 6C 89 FE 11 54 24 6C 31 FF 89 94 24 0C 01 00 00 F7 E5 89 B4 24 80 00 00 00 8B 74 24 6C 01 84 24 80 00 00 00 89 BC 24 84 00 00 00 11 94 24 84 00 00 00 01 8C 24 80 00 00 00 11 9C 24 84 00 00 00 8B 5C 24 68 01 9C 24 80 00 00 00 11 B4 24 84 00 00 00 31 FF 8B 6C 24 1C 8B 44 24 38 C7 44 24 44 00 00 00 00 F7 E5 89 94 24 BC 00 00 00 8B 54 24 18 89 84 24 B8 00 00 00 89 D0 F7 64 24 38 89 44 24 38 8B 84 24 B8 00 00 00 89 D6 31 D2 01 C6 8B 44 24 18 11 D7 F7 A4 24 98 00 00 00 01 C6 8B 44 24 50 11 D7 31 DB 89 9C 24 B4 00 00 00 31 DB 89 BC 24 B0 00 00 00 89 F7 F7 E5 89 44 24 08 8B 44 24 18 89 54 24 0C F7 64 24 50 89 44 24 50 8B 44 24 08 89 D1 89 54 24 54 31 D2 01 C1 8B 44 24 18 11 D3 F7 64 24 10 01 C1 89 C8 11 D3 89 C2 B8 00 00 00 00 89 44 24 10 8B 44 24 38 31 F6 89 54 24 14 8B 54 24 50 89 54 24 40 31 D2 01 C6 8B 44 24 28 11 D7 F7 E5 89 84 24 A8 00 00 00 8B 44 24 18 89 94 24 AC 00 00 00 F7 64 24 28 89 44 24 28 89 D0 89 44 24 60 8B 84 24 A8 00 00 00 89 54 24 2C 31 D2 89 54 24 64 31 D2 01 44 24 60 8B 44 24 18 11 54 24 64 F7 A4 24 88 00 00 00 01 44 24 60 11 54 24 64 8B 54 24 64 89 D0 31 D2 89 54 24 3C 8B 94 24 AC 00 00 00 89 44 24 38 89 D0 31 D2 89 84 24 A8 00 00 00 8B 84 24 88 00 00 00 89 94 24 AC 00 00 00 F7 E5 01 84 24 A8 00 00 00 8B 44 24 38 11 94 24 AC 00 00 00 01 84 24 A8 00 00 00 B8 01 00 00 00 8B 54 24 3C 11 94 24 AC 00 00 00 01 B4 24 A8 00 00 00 11 BC 24 AC 00 00 00 31 D2 3B BC 24 AC 00 00 00 77 0F 72 09 3B B4 24 A8 00 00 00 77 04 31 C0 31 D2 8B 74 24 10 03 74 24 40 8B 7C 24 14 13 7C 24 44 89 74 24 10 89 44 24 58 01 44 24 10 8B 84 24 98 00 00 00 89 7C 24 14 8B BC 24 BC 00 00 00 11 54 24 14 89 54 24 5C F7 E5 89 FE 31 FF C7 84 24 C8 00 00 00 01 00 00 00 C7 84 24 CC 00 00 00 00 00 00 00 01 C6 8B 44 24 48 11 D7 8B 54 24 4C 03 B4 24 B0 00 00 00 13 BC 24 B4 00 00 00 03 74 24 10 13 7C 24 14 01 F0 11 FA 39 54 24 4C 89 84 24 D0 00 00 00 89 94 24 D4 00 00 00 77 1E 72 06 39 44 24 48 77 16 C7 84 24 C8 00 00 00 00 00 00 00 C7 84 24 CC 00 00 00 00 00 00 00 8B 84 24 C8 00 00 00 8B 94 24 CC 00 00 00 03 44 24 30 13 54 24 34 89 B4 24 B0 00 00 00 89 44 24 30 89 54 24 34 89 BC 24 B4 00 00 00 C7 44 24 50 00 00 00 00 C7 44 24 54 00 00 00 00 C7 84 24 E8 00 00 00 00 00 00 00 C7 84 24 EC 00 00 00 00 00 00 00 C7 84 24 98 00 00 00 00 00 00 00 C7 84 24 9C 00 00 00 00 00 00 00 C7 44 24 40 00 00 00 00 C7 44 24 44 00 00 00 00 C7 84 24 20 01 00 00 00 00 00 00 C7 84 24 24 01 00 00 00 00 00 00 C7 84 24 B8 00 00 00 00 00 00 00 C7 84 24 BC 00 00 00 00 00 00 00 C7 44 24 38 00 00 00 00 C7 44 24 3C 00 00 00 00 C7 84 24 88 00 00 00 00 00 00 00 C7 84 24 8C 00 00 00 00 00 00 00 E9 A6 1B 00 00 83 BC 24 A4 00 00 00 25 8B 9C 24 84 01 00 00 0F 8F C6 08 00 00 83 EB 14 89 C1 89 DD C1 E5 04 03 8D ?? ?? ?? ?? 89 5C 24 38 89 D3 13 9D ?? ?? ?? ?? 89 4C 24 48 39 D3 89 5C 24 4C 0F 86 B8 2E 00 00 8B 4C 24 38 89 F0 89 FA C1 E1 04 03 81 ?? ?? ?? ?? 13 91 ?? ?? ?? ?? 39 FA 0F 82 D5 55 00 00 0F 86 C7 55 00 00 8B B4 24 A4 00 00 00 89 C7 89 D5 C1 E6 05 8B 8E ?? ?? ?? ?? 8B 9E ?? ?? ?? ?? 89 C8 F7 E2 89 9C 24 A8 00 00 00 89 9C 24 1C 01 00 00 89 4C 24 58 89 44 24 50 89 C8 89 54 24 54 F7 E7 89 4C 24 78 89 54 24 0C 8B 5C 24 0C 31 D2 89 44 24 08 8B 44 24 50 89 D9 31 DB 01 C1 8B 84 24 A8 00 00 00 11 D3 F7 E7 01 C1 11 D3 89 DA 8B 9E ?? ?? ?? ?? 89 8C 24 EC 00 00 00 8B 8E ?? ?? ?? ?? 89 D0 89 84 24 80 00 00 00 31 C0 31 D2 89 84 24 E8 00 00 00 8B 44 24 08 89 94 24 84 00 00 00 31 D2 01 84 24 E8 00 00 00 89 C8 11 94 24 EC 00 00 00 F7 E5 89 8C 24 B0 00 00 00 89 9C 24 C8 00 00 00 89 8C 24 90 00 00 00 89 84 24 98 00 00 00 89 C8 89 94 24 9C 00 00 00 F7 E7 89 9C 24 18 01 00 00 89 44 24 08 89 54 24 0C 8B 5C 24 0C 31 D2 8B 84 24 98 00 00 00 89 D9 31 DB 01 C1 8B 84 24 C8 00 00 00 11 D3 F7 E7 01 C1 11 D3 89 DA 8B 9E ?? ?? ?? ?? 89 4C 24 24 8B 8E ?? ?? ?? ?? 89 D0 89 44 24 60 31 C0 31 D2 89 44 24 20 8B 44 24 08 89 54 24 64 31 D2 01 44 24 20 89 C8 11 54 24 24 F7 E5 89 9C 24 D0 00 00 00 89 9C 24 04 01 00 00 89 4C 24 08 89 84 24 88 00 00 00 89 C8 89 94 24 8C 00 00 00 F7 E7 89 8C 24 F0 00 00 00 89 54 24 3C 8B 5C 24 3C 31 D2 89 44 24 38 8B 84 24 88 00 00 00 89 D9 31 DB 01 C1 8B 84 24 D0 00 00 00 11 D3 F7 E7 01 C1 11 D3 8B 94 24 8C 00 00 00 89 D0 31 D2 89 84 24 88 00 00 00 8B 84 24 D0 00 00 00 89 94 24 8C 00 00 00 F7 E5 01 84 24 88 00 00 00 11 94 24 8C 00 00 00 89 DA 89 D0 31 D2 89 4C 24 44 8B 8E ?? ?? ?? ?? 01 84 24 88 00 00 00 11 94 24 8C 00 00 00 31 C0 8B 54 24 38 89 44 24 40 89 C8 8B B6 ?? ?? ?? ?? 89 4C 24 18 89 8C 24 C0 00 00 00 89 54 24 30 F7 E5 89 74 24 28 89 B4 24 00 01 00 00 C7 44 24 34 00 00 00 00 89 44 24 38 89 C8 89 54 24 3C F7 E7 89 54 24 74 8B 5C 24 74 31 D2 89 44 24 70 8B 44 24 38 89 D9 31 DB 01 C1 89 F0 11 D3 F7 E7 8B 7C 24 3C 01 C1 8B 44 24 28 89 FE 11 D3 31 FF 89 74 24 38 89 7C 24 3C F7 E5 01 44 24 38 11 54 24 3C 31 D2 01 5C 24 38 11 54 24 3C 31 F6 8B 44 24 70 31 D2 8B 5C 24 54 89 B4 24 B8 00 00 00 8B 74 24 24 01 84 24 B8 00 00 00 8B 84 24 A8 00 00 00 89 8C 24 BC 00 00 00 89 D9 11 94 24 BC 00 00 00 31 DB F7 E5 89 4C 24 50 8B 8C 24 80 00 00 00 01 44 24 50 B8 01 00 00 00 89 5C 24 54 8B 9C 24 84 00 00 00 11 54 24 54 01 4C 24 50 11 5C 24 54 8B 5C 24 20 01 5C 24 50 11 74 24 54 31 D2 8B 7C 24 54 39 FE 77 0E 72 08 8B 4C 24 50 39 CB 77 04 31 C0 31 D2 8B 5C 24 40 03 5C 24 30 8B 74 24 44 8B BC 24 9C 00 00 00 13 74 24 34 89 5C 24 40 8B 4C 24 60 01 44 24 40 8B 5C 24 64 89 84 24 20 01 00 00 8B 84 24 C8 00 00 00 89 74 24 44 89 FE 11 54 24 44 31 FF 89 94 24 24 01 00 00 F7 E5 89 B4 24 98 00 00 00 8B 74 24 44 01 84 24 98 00 00 00 89 BC 24 9C 00 00 00 11 94 24 9C 00 00 00 01 8C 24 98 00 00 00 11 9C 24 9C 00 00 00 8B 5C 24 40 01 9C 24 98 00 00 00 11 B4 24 9C 00 00 00 8B 6C 24 14 8B 44 24 58 8B 74 24 10 F7 E5 89 44 24 30 89 F0 89 54 24 34 F7 64 24 58 89 54 24 24 8B 5C 24 24 31 D2 89 44 24 20 8B 44 24 30 89 D9 31 DB 01 C1 89 F0 11 D3 F7 A4 24 A8 00 00 00 01 C1 8B 44 24 20 11 D3 31 F6 31 FF 31 D2 89 B4 24 E0 00 00 00 01 84 24 E0 00 00 00 8B 84 24 B0 00 00 00 89 8C 24 E4 00 00 00 11 94 24 E4 00 00 00 F7 E5 89 9C 24 08 01 00 00 89 BC 24 0C 01 00 00 89 84 24 80 00 00 00 8B 44 24 10 89 94 24 84 00 00 00 F7 A4 24 B0 00 00 00 89 54 24 24 8B 5C 24 24 31 D2 89 44 24 20 8B 84 24 80 00 00 00 89 D9 31 DB 01 C1 8B 44 24 10 11 D3 F7 A4 24 C8 00 00 00 01 C1 11 D3 31 F6 89 9C 24 10 01 00 00 8B 44 24 20 31 FF 31 D2 89 BC 24 14 01 00 00 89 CF C7 44 24 64 00 00 00 00 01 C6 8B 44 24 08 11 D7 F7 E5 89 44 24 70 8B 44 24 10 89 54 24 74 F7 64 24 08 89 54 24 24 8B 5C 24 24 31 D2 89 44 24 20 8B 44 24 70 89 D9 31 DB 01 C1 8B 44 24 10 11 D3 F7 A4 24 D0 00 00 00 01 C1 11 D3 8B 54 24 74 89 4C 24 6C 89 D0 31 D2 89 44 24 70 8B 84 24 D0 00 00 00 89 54 24 74 F7 E5 01 44 24 70 11 54 24 74 89 DA 89 D0 31 D2 01 44 24 70 11 54 24 74 31 C0 8B 54 24 20 89 44 24 68 8B 44 24 18 89 54 24 60 F7 E5 89 44 24 20 8B 44 24 10 89 54 24 24 F7 64 24 18 89 54 24 1C 8B 5C 24 1C 31 D2 89 44 24 18 8B 44 24 20 89 D9 31 DB 01 C1 8B 44 24 10 11 D3 F7 64 24 28 01 C1 11 D3 8B 54 24 24 89 8C 24 DC 00 00 00 89 D0 31 D2 89 44 24 20 8B 44 24 28 89 54 24 24 F7 E5 01 44 24 20 11 54 24 24 89 DA 89 D0 8B 5C 24 34 31 D2 01 44 24 20 11 54 24 24 31 C0 31 D2 89 84 24 D8 00 00 00 8B 44 24 18 89 D9 01 84 24 D8 00 00 00 11 94 24 DC 00 00 00 31 DB 89 4C 24 30 89 5C 24 34 8B 84 24 A8 00 00 00 8B 8C 24 08 01 00 00 8B 9C 24 0C 01 00 00 F7 E5 01 44 24 30 B8 01 00 00 00 11 54 24 34 01 4C 24 30 11 5C 24 34 01 74 24 30 11 7C 24 34 31 D2 3B 7C 24 34 0F 86 63 63 00 00 8B 5C 24 68 03 5C 24 60 8B 74 24 6C 13 74 24 64 89 84 24 08 01 00 00 8B BC 24 84 00 00 00 89 5C 24 68 01 44 24 68 8B 84 24 C8 00 00 00 89 74 24 6C 89 FE 11 54 24 6C 31 FF 89 94 24 0C 01 00 00 F7 E5 89 B4 24 80 00 00 00 89 BC 24 84 00 00 00 01 84 24 80 00 00 00 8B 8C 24 10 01 00 00 11 94 24 84 00 00 00 8B 9C 24 14 01 00 00 01 8C 24 80 00 00 00 11 9C 24 84 00 00 00 8B 5C 24 68 01 9C 24 80 00 00 00 8B 74 24 6C 11 B4 24 84 00 00 00 8B 74 24 48 8B 6C 24 4C 89 F0 F7 64 24 58 89 74 24 18 89 44 24 28 8B 44 24 58 89 54 24 2C 8B 5C 24 2C F7 E5 89 D9 31 DB 89 4C 24 60 89 5C 24 64 89 44 24 58 8B 44 24 58 89 54 24 5C 31 D2 01 44 24 60 89 F0 11 54 24 64 F7 A4 24 A8 00 00 00 01 44 24 60 89 F0 11 54 24 64 31 FF F7 A4 24 B0 00 00 00 89 44 24 10 8B 84 24 B0 00 00 00 89 54 24 14 8B 5C 24 14 F7 E5 89 D9 31 DB 89 C6 89 84 24 B0 00 00 00 8B 44 24 18 89 94 24 B4 00 00 00 F7 A4 24 C8 00 00 00 01 F1 11 FB 8B 7C 24 5C 01 C1 8B 44 24 10 11 D3 31 F6 89 74 24 48 31 D2 89 FE 01 44 24 48 8B 84 24 A8 00 00 00 89 4C 24 4C 11 54 24 4C 31 FF F7 E5 01 C6 11 D7 8B 54 24 64 89 D0 31 D2 01 C6 8B 84 24 E8 00 00 00 11 D7 8B 94 24 EC 00 00 00 03 74 24 48 13 7C 24 4C 01 F0 11 FA 89 84 24 A8 00 00 00 89 94 24 AC 00 00 00 39 94 24 EC 00 00 00 C7 44 24 10 01 00 00 00 C7 44 24 14 00 00 00 00 77 16 0F 83 A0 61 00 00 C7 44 24 10 00 00 00 00 C7 44 24 14 00 00 00 00 8B 44 24 10 8B 54 24 14 89 9C 24 28 01 00 00 89 84 24 E8 00 00 00 89 94 24 EC 00 00 00 03 44 24 50 13 54 24 54 89 44 24 50 8B 44 24 18 89 54 24 54 31 D2 89 94 24 2C 01 00 00 F7 64 24 08 89 84 24 10 01 00 00 8B 44 24 08 89 94 24 14 01 00 00 8B 9C 24 14 01 00 00 F7 E5 89 D9 31 DB 89 44 24 08 8B 44 24 08 89 54 24 0C 31 D2 01 C1 8B 44 24 18 11 D3 F7 A4 24 D0 00 00 00 01 C1 89 C8 11 D3 89 C2 B8 00 00 00 00 89 54 24 14 31 D2 39 7C 24 }
	condition:
		$1
}

rule file_12_0_0 {
	meta:
		name = "___addvdi3"
		size = 96
		refs = "0035 _abort"
	strings:
		$1 = { 83 EC 0C 89 74 24 04 8B 74 24 18 89 7C 24 08 8B 4C 24 10 8B 7C 24 1C 89 1C 24 8B 5C 24 14 89 F0 01 C8 89 FA 11 DA 85 FF 78 16 39 DA 7C 06 7F 20 39 C8 73 1C E8 ?? ?? ?? ?? 8D B4 26 00 00 00 00 39 DA 7F F0 7C 0A 39 C8 77 EA 8D B6 00 00 00 00 8B 1C 24 8B 74 24 04 8B 7C 24 08 83 C4 0C C3 90 }
	condition:
		$1
}

rule file_13_0_0 {
	meta:
		name = "___powisf2"
		size = 80
		refs = "0044 .rdata"
	strings:
		$1 = { 8B 54 24 08 D9 44 24 04 D9 E8 89 D1 C1 F9 1F 89 C8 31 D0 29 C8 A8 01 74 09 DD D8 D9 C0 EB 03 90 D9 C9 D1 E8 74 12 D9 C9 A8 01 D8 C8 74 F2 D1 E8 DC C9 75 F4 DD D8 EB 02 DD D9 85 D2 78 04 66 90 F3 C3 D8 3D ?? ?? ?? ?? C3 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_14_0_0 {
	meta:
		name = "___fixtfsi"
		size = 464
	strings:
		$1 = { 83 EC 5C 89 5C 24 4C 8B 5C 24 6C 8B 54 24 60 89 74 24 50 8B 74 24 68 89 6C 24 58 8B 6C 24 64 89 D9 C1 E9 10 89 7C 24 54 81 E1 FF 7F 00 00 0F B7 FB 89 5C 24 0C C1 EB 18 C0 EB 07 81 F9 FE 3F 00 00 89 14 24 89 6C 24 04 89 74 24 08 89 54 24 10 89 6C 24 14 89 74 24 18 89 7C 24 1C 7F 32 85 C9 0F 84 CD 00 00 00 31 C0 D9 74 24 20 66 83 4C 24 24 20 D9 64 24 20 9B 8B 5C 24 4C 8B 74 24 50 8B 7C 24 54 8B 6C 24 58 83 C4 5C C3 90 8D 74 26 00 81 F9 1D 40 00 00 0F 8F AA 00 00 00 BD 6F 40 00 00 89 D0 29 CD 31 C9 89 EA 31 F6 C1 FA 05 83 C1 01 81 CF 00 00 01 00 09 C6 39 CA 89 7C 24 1C 7E 0D 8B 44 8C 10 83 C1 01 09 C6 39 CA 7F F3 85 D2 B8 01 00 00 00 0F 4F C2 83 E5 1F 0F 85 A3 00 00 00 B9 03 00 00 00 29 D1 8D 44 24 10 8D 7C 8C 14 8B 0C 90 89 08 83 C0 04 39 F8 75 F4 B8 04 00 00 00 29 D0 C7 44 84 10 00 00 00 00 83 C0 01 83 F8 03 7E F0 8B 44 24 10 83 FE 01 19 D2 89 C1 F7 D9 84 DB 0F 45 C1 83 E2 20 0F 84 3A FF FF FF E9 44 FF FF FF 09 EA 09 F2 09 FA 0F 85 27 FF FF FF 31 C0 E9 31 FF FF FF 0F B6 C3 05 FF FF FF 7F 81 F9 1E 40 00 00 75 22 84 DB 74 1E 89 F1 C1 E7 0F C1 E9 11 09 CF 75 12 09 EA C1 E6 0F 09 F2 0F 84 04 FF FF FF E9 F0 FE FF FF D9 EE D8 F0 DD D8 9B E9 F3 FE FF FF 8B 44 84 10 B9 20 00 00 00 29 E9 D3 E0 09 C6 83 FA 02 75 2B 8B 44 94 14 8B 54 94 10 D3 E0 89 E9 D3 EA 09 D0 BA 01 00 00 00 89 44 24 10 B8 02 00 00 00 89 E9 D3 EF 89 7C 94 10 E9 40 FF FF FF B8 01 00 00 00 31 D2 EB EA 90 90 90 90 }
	condition:
		$1
}

rule file_15_0_0 {
	meta:
		name = "___bid128_to_int64_rnint"
		size = 3568
		refs = "0132 ___bid_nr_digits 01bc ___bid_midpoint128 022b ___bid_IDEC_glbflags 0313 ___bid_ten2k64 04c1 ___bid_midpoint64 06db ___bid_ten2mk128 09e9 ___bid_maskhigh128 09f7 ___bid_shiftright128 0a84 ___bid_ten2mk128trunc"
	strings:
		$1 = { 81 EC AC 00 00 00 8B 84 24 B0 00 00 00 89 B4 24 A0 00 00 00 8B B4 24 BC 00 00 00 89 9C 24 9C 00 00 00 89 BC 24 A4 00 00 00 89 84 24 80 00 00 00 8B 84 24 B4 00 00 00 8B 8C 24 80 00 00 00 89 F2 81 E2 00 00 00 78 89 AC 24 A8 00 00 00 89 84 24 84 00 00 00 8B 9C 24 84 00 00 00 8B 84 24 B8 00 00 00 89 4C 24 10 89 5C 24 14 89 F3 81 E3 00 00 00 80 81 FA 00 00 00 78 89 5C 24 24 0F 84 95 01 00 00 89 F3 89 C1 81 E3 FF FF 01 00 81 FB 09 ED 01 00 76 3C C7 44 24 18 00 00 00 00 C7 44 24 1C 00 00 00 00 8B 44 24 18 8B 54 24 1C 8B 9C 24 9C 00 00 00 8B B4 24 A0 00 00 00 8B BC 24 A4 00 00 00 8B AC 24 A8 00 00 00 81 C4 AC 00 00 00 C3 90 0F 83 6F 01 00 00 89 DA 89 C8 81 F2 09 ED 01 00 35 C0 87 AD BE 09 C2 0F 84 C4 01 00 00 89 F0 25 00 00 00 60 3D 00 00 00 60 74 99 89 DF 09 CF 0F 84 50 01 00 00 89 4C 24 78 89 5C 24 7C DF 6C 24 78 DD 5C 24 18 8B 54 24 1C 89 D0 C1 E8 14 25 FF 07 00 00 2D BE 03 00 00 83 E8 01 89 C2 C1 E2 05 8B BA ?? ?? ?? ?? 85 FF 75 2C 8B BA ?? ?? ?? ?? 8B AA ?? ?? ?? ?? 8B 92 ?? ?? ?? ?? 39 D3 0F 87 2F 03 00 00 0F 83 16 05 00 00 31 DA 31 CD 09 EA 0F 84 F9 02 00 00 81 E6 00 00 FE 7F C1 EE 11 81 EE 20 18 00 00 8D 2C 37 83 FD 13 0F 8F A8 00 00 00 0F 84 61 01 00 00 83 FD 00 C7 44 24 18 00 00 00 00 C7 44 24 1C 00 00 00 00 0F 8C 04 FF FF FF 0F 85 5E 02 00 00 8D 47 FF 83 F8 12 0F 8E FE 02 00 00 83 EF 14 89 F8 C1 E0 04 8B 90 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 39 C3 0F 82 C6 FE FF FF 77 08 39 D1 0F 82 BC FE FF FF 31 D8 31 D1 09 C8 66 90 0F 84 6F 0B 00 00 8B 44 24 24 C7 44 24 18 01 00 00 00 C7 44 24 1C 00 00 00 00 85 C0 0F 84 A2 FE FF FF C7 44 24 18 FF FF FF FF C7 44 24 1C FF FF FF FF E9 8D FE FF FF 89 F0 25 00 00 00 7C 3D 00 00 00 7C 0F 84 1A 02 00 00 83 0D ?? ?? ?? ?? 01 C7 44 24 18 00 00 00 00 C7 44 24 1C 00 00 00 80 E9 5F FE FF FF 3D C0 87 AD BE 0F 87 44 FE FF FF E9 81 FE FF FF 8B 6C 24 14 0B 6C 24 10 C7 44 24 18 00 00 00 00 C7 44 24 1C 00 00 00 00 0F 84 31 FE FF FF 81 7C 24 14 FF FF 1F 00 0F 86 0F 02 00 00 8B 54 24 14 89 D0 31 D2 89 44 24 78 89 54 24 7C DF 6C 24 78 DD 5C 24 18 8B 54 24 1C 89 D0 C1 E8 14 25 FF 07 00 00 2D DE 03 00 00 E9 77 FE FF FF 81 7C 24 14 63 8E 8D 37 C7 44 24 18 00 00 00 00 C7 44 24 1C 00 00 00 00 0F 87 D5 FD FF FF 89 F7 81 E7 00 00 00 60 81 FF 00 00 00 60 0F 85 22 FE FF FF E9 BC FD FF FF 8B 44 24 24 85 C0 0F 84 3C 02 00 00 83 FF 13 0F 8F F7 08 00 00 8B 44 24 10 8B 6C 24 14 89 44 24 38 B8 14 00 00 00 29 F8 8B 3C C5 ?? ?? ?? ?? 8B 04 C5 ?? ?? ?? ?? 89 44 24 30 89 F8 F7 E5 89 44 24 18 8B 44 24 30 89 54 24 1C F7 E5 89 44 24 40 8B 44 24 38 89 54 24 44 F7 E7 89 54 24 2C 8B 6C 24 2C 31 D2 89 44 24 28 8B 44 24 18 89 EF 31 ED 89 7C 24 48 01 44 24 48 8B 44 24 30 89 6C 24 4C 11 54 24 4C F7 64 24 38 01 44 24 48 11 54 24 4C 8B 54 24 1C 8B 6C 24 4C 89 D0 31 D2 03 44 24 40 89 EF 13 54 24 44 31 ED 01 F8 8B 7C 24 48 11 EA 89 FD BF 00 00 00 00 89 7C 24 18 8B 7C 24 28 89 6C 24 1C 31 ED 01 7C 24 18 BF 05 00 00 00 11 6C 24 1C 31 ED C7 44 24 28 05 00 00 00 C7 44 24 2C 00 00 00 00 39 D5 0F 82 55 FE FF FF 77 08 39 C7 0F 82 4B FE FF FF 31 EA 31 F8 09 C2 75 1E 8B 6C 24 1C 39 6C 24 2C 77 14 0F 82 33 FE FF FF 8B 44 24 18 39 44 24 28 0F 82 25 FE FF FF 83 FE 00 0F 8C 78 02 00 00 0F 85 D4 00 00 00 8B 4C 24 10 8B 5C 24 14 8B 54 24 24 89 4C 24 18 89 5C 24 1C 85 D2 0F 84 75 FC FF FF F7 D9 83 D3 00 F7 DB 89 4C 24 18 89 5C 24 1C E9 61 FC FF FF 83 0D ?? ?? ?? ?? 01 C7 44 24 18 00 00 00 00 C7 44 24 1C 00 00 00 80 E9 45 FC FF FF C1 E0 05 8B 54 24 14 05 ?? ?? ?? ?? 39 50 14 0F 87 F2 FC FF FF 72 0D 8B 6C 24 10 39 68 10 0F 87 E3 FC FF FF 83 C7 01 E9 DB FC FF FF 90 8D 74 26 00 DF 6C 24 10 DD 5C 24 18 8B 54 24 1C 89 D0 C1 E8 14 25 FF 07 00 00 2D FE 03 00 00 E9 78 FC FF FF 89 DA 09 CA 0F 85 2C FD FF FF 8B 4C 24 14 39 0C C5 ?? ?? ?? ?? 0F 87 C9 FB FF FF 0F 82 15 FD FF FF 8B 5C 24 10 39 1C C5 ?? ?? ?? ?? 0F 83 B2 FB FF FF E9 FF FC FF FF 8B 44 24 24 85 C0 0F 84 F2 05 00 00 8B 7C 24 10 8B 6C 24 14 8B 0C F5 ?? ?? ?? ?? 8B 14 F5 ?? ?? ?? ?? F7 DF 83 D5 00 89 F8 F7 DD 0F AF D7 0F AF CD 01 D1 F7 24 F5 ?? ?? ?? ?? 01 CA 89 44 24 18 89 54 24 1C E9 74 FB FF FF 83 FF 13 0F 8F E0 05 00 00 B8 14 00 00 00 8B 6C 24 14 29 F8 8B 54 24 10 8B 3C C5 ?? ?? ?? ?? 8B 04 C5 ?? ?? ?? ?? 89 54 24 38 89 44 24 30 89 F8 F7 E5 89 44 24 18 8B 44 24 30 89 54 24 1C F7 E5 89 44 24 40 8B 44 24 38 89 54 24 44 F7 E7 89 54 24 2C 8B 6C 24 2C 31 D2 89 44 24 28 8B 44 24 18 89 EF 31 ED 89 7C 24 48 01 44 24 48 8B 44 24 30 89 6C 24 4C 11 54 24 4C F7 64 24 38 01 44 24 48 11 54 24 4C 8B 54 24 1C 8B 6C 24 4C 89 D0 31 D2 03 44 24 40 89 EF 13 54 24 44 31 ED 01 F8 8B 7C 24 48 11 EA 89 FD BF 00 00 00 00 89 7C 24 30 89 6C 24 34 8B 6C 24 28 C7 44 24 1C 00 00 00 00 C7 44 24 28 FB FF FF FF C7 44 24 2C FF FF FF FF 89 6C 24 18 8B 7C 24 18 8B 6C 24 1C 01 7C 24 30 11 6C 24 34 C7 44 24 18 04 00 00 00 C7 44 24 1C 00 00 00 00 39 54 24 1C 0F 82 FC FB FF FF 77 0A 39 44 24 18 0F 82 F0 FB FF FF 33 54 24 1C 33 44 24 18 09 C2 0F 85 BB FD FF FF 8B 6C 24 34 39 6C 24 2C 0F 87 AD FD FF FF 0F 82 CC FB FF FF 8B 44 24 30 39 44 24 28 0F 87 99 FD FF FF E9 B9 FB FF FF 39 E9 0F 87 0B FE FF FF 90 8D B4 26 00 00 00 00 E9 D5 FA FF FF 89 F7 F7 DF 83 FF 13 89 7C 24 64 0F 8F 8A 06 00 00 F7 D6 8B 44 24 10 8B 54 24 14 03 04 F5 ?? ?? ?? ?? 13 14 F5 ?? ?? ?? ?? 89 74 24 20 39 54 24 14 72 0E 77 06 39 44 24 10 76 06 83 C1 01 83 D3 00 8B 74 24 20 89 D7 89 C5 C7 44 24 54 00 00 00 00 C1 E6 04 8B 86 ?? ?? ?? ?? 8B 96 ?? ?? ?? ?? 89 44 24 38 89 54 24 48 F7 E7 89 44 24 18 8B 44 24 48 89 54 24 1C F7 E7 89 44 24 30 8B 44 24 38 89 54 24 34 F7 E5 89 54 24 44 8B 54 24 18 89 44 24 40 89 54 24 50 8B 54 24 44 89 D0 31 D2 89 44 24 10 8B 44 24 50 01 44 24 10 8B 44 24 48 89 54 24 14 8B 54 24 54 11 54 24 14 F7 E5 01 44 24 10 11 54 24 14 8B 54 24 1C 89 D0 31 D2 89 44 24 18 8B 44 24 30 01 44 24 18 89 54 24 1C 8B 54 24 34 11 54 24 1C 8B 54 24 14 89 D0 31 D2 01 44 24 18 11 54 24 1C 8B 96 ?? ?? ?? ?? 8B B6 ?? ?? ?? ?? 89 D0 89 54 24 30 F7 E7 89 74 24 60 89 44 24 50 89 F0 89 54 24 54 F7 E7 89 44 24 70 8B 44 24 30 89 54 24 74 F7 E5 89 54 24 6C 8B 7C 24 6C 31 D2 89 44 24 68 8B 44 24 50 89 FE 31 FF 89 74 24 58 01 44 24 58 8B 44 24 60 89 7C 24 5C 11 54 24 5C F7 E5 01 44 24 58 8B 7C 24 54 11 54 24 5C 8B 54 24 5C 89 FE 31 FF 03 74 24 70 89 D0 13 7C 24 74 31 D2 01 C6 8B 44 24 10 11 D7 89 C2 31 C0 89 44 24 10 8B 44 24 40 89 54 24 14 31 D2 01 44 24 10 11 54 24 14 01 74 24 10 11 7C 24 14 3B 7C 24 14 72 12 77 06 3B 74 24 10 76 0A 83 44 24 18 01 83 54 24 1C 00 8B 44 24 38 89 DE 89 CD F7 E3 89 44 24 28 8B 44 24 48 89 54 24 2C F7 E3 89 44 24 50 8B 44 24 38 89 54 24 54 F7 E1 89 54 24 3C 8B 5C 24 3C 31 D2 89 44 24 38 8B 44 24 28 89 D9 31 DB 89 4C 24 40 01 44 24 40 8B 44 24 48 89 5C 24 44 8B 5C 24 2C 11 54 24 44 F7 E5 01 44 24 40 89 D9 11 54 24 44 31 DB 8B 54 24 44 89 4C 24 28 8B 4C 24 50 01 4C 24 28 89 5C 24 2C 8B 5C 24 54 89 D0 11 5C 24 2C 31 D2 01 44 24 28 8B 44 24 30 11 54 24 2C F7 E6 89 C1 8B 44 24 60 89 D3 F7 E6 89 44 24 50 8B 44 24 30 89 54 24 54 F7 E5 89 54 24 34 8B 7C 24 34 31 D2 89 44 24 30 8B 44 24 60 C7 44 24 34 00 00 00 00 89 FE 31 FF 01 CE 89 D9 11 D7 F7 E5 8B 6C 24 38 01 C6 8B 44 24 30 11 D7 31 DB 03 4C 24 50 13 5C 24 54 31 D2 89 6C 24 30 01 F9 89 F7 11 D3 31 F6 31 D2 01 C6 8B 44 24 40 11 D7 89 C2 31 C0 03 44 24 30 13 54 24 34 01 C8 11 DA 39 D3 72 10 77 04 39 C1 76 0A 83 44 24 28 01 83 54 24 2C 00 8B 4C 24 10 8B 5C 24 14 01 F1 11 FB 89 5C 24 14 31 DB 3B 7C 24 14 89 4C 24 10 B9 01 00 00 00 77 0C 72 06 3B 74 24 10 77 04 31 C9 31 DB 8B 74 24 18 01 C8 8B 7C 24 1C 11 DA 01 C6 11 D7 39 FA 89 74 24 18 89 7C 24 1C 0F 87 0D 03 00 00 72 08 39 F0 0F 87 03 03 00 00 31 FF 39 D3 BE 01 00 00 00 77 0A 72 04 39 C1 77 04 31 F6 31 FF 03 74 24 28 13 7C 24 2C 83 7C 24 64 16 0F 8F E7 02 00 00 8B 6C 24 20 31 DB 8B 44 24 18 8B 54 24 1C 23 04 ED ?? ?? ?? ?? 23 14 ED ?? ?? ?? ?? 8B 2C AD ?? ?? ?? ?? 89 44 24 28 8B 44 24 18 89 54 24 30 8B 54 24 1C 89 E9 0F AD D0 D3 EA F6 C1 20 0F 45 C2 0F 45 D3 89 44 24 18 B8 40 00 00 00 29 E8 31 ED 89 C1 0F A5 F7 89 54 24 1C D3 E6 8B 5C 24 1C 8B 4C 24 18 A8 20 0F 45 FE 0F 45 F5 09 FB 09 F1 8B 74 24 30 0B 74 24 28 0F 85 C6 F9 FF FF 8B 74 24 58 31 D2 8B 44 24 68 8B 6C 24 14 89 F7 31 F6 01 C6 11 D7 0B 6C 24 10 75 0A 89 F8 09 F0 0F 84 A0 F9 FF FF 8B 44 24 20 C1 E0 04 8B 90 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 39 44 24 14 72 39 77 06 39 54 24 10 72 31 33 44 24 14 33 54 24 10 09 D0 0F 85 6F F9 FF FF 8B 44 24 20 C1 E0 04 3B B8 ?? ?? ?? ?? 0F 87 5C F9 FF FF 72 0C 3B B0 ?? ?? ?? ?? 0F 87 4E F9 FF FF 89 C8 83 E0 01 85 C0 0F 84 41 F9 FF FF 83 C1 FF 83 D3 FF E9 36 F9 FF FF 8B 4C 24 14 8B 44 24 10 0F AF 04 F5 ?? ?? ?? ?? 0F AF 0C F5 ?? ?? ?? ?? 01 C1 8B 44 24 10 F7 24 F5 ?? ?? ?? ?? 01 CA 89 44 24 18 89 54 24 1C E9 8B F5 FF FF 83 FF 14 0F 84 91 02 00 00 8B 14 FD ?? ?? ?? ?? 8B 04 FD ?? ?? ?? ?? BF FB FF FF FF 89 54 24 3C 89 D5 89 44 24 28 89 44 24 38 89 D0 F7 E7 89 44 24 30 B8 FF FF FF FF 89 54 24 34 F7 E5 89 44 24 18 8B 44 24 28 89 54 24 1C F7 E7 89 54 24 44 8B 6C 24 44 31 D2 89 44 24 40 8B 44 24 30 89 EF 31 ED 01 C7 B8 FF FF FF FF 11 D5 F7 64 24 28 01 C7 89 F8 11 D5 89 C2 B8 00 00 00 00 89 44 24 28 8B 44 24 40 89 54 24 2C 31 D2 01 44 24 28 11 54 24 2C 8B 44 24 38 8B 54 24 3C 0F A4 C2 02 C1 E0 02 01 44 24 18 11 54 24 1C 8B 54 24 34 89 D0 31 D2 01 44 24 18 89 C8 11 54 24 1C 31 D2 8B 7C 24 10 01 6C 24 18 8B 6C 24 14 11 54 24 1C 89 DA 89 7C 24 30 89 6C 24 34 E9 2F FA FF FF 83 FF 14 0F 84 86 01 00 00 83 EF 14 8B 2C FD ?? ?? ?? ?? 89 6C 24 40 8B 44 24 40 BD 05 00 00 00 F7 E5 89 44 24 30 8B 04 FD ?? ?? ?? ?? 89 54 24 34 F7 E5 89 54 24 1C 8B 6C 24 1C 31 D2 89 44 24 18 8B 44 24 30 89 EF 31 ED 89 7C 24 38 01 44 24 38 8B 44 24 38 89 6C 24 3C 8B 6C 24 34 11 54 24 3C 89 C2 31 C0 89 44 24 28 8B 44 24 18 89 EF 89 54 24 2C 31 D2 01 44 24 28 11 54 24 2C 31 ED 8B 54 24 40 8B 44 24 18 8D 14 92 89 54 24 30 8B 54 24 30 03 54 24 1C 01 C7 11 D5 8B 54 24 3C 89 D0 31 D2 01 C7 8B 44 24 10 11 D5 8B 54 24 14 89 44 24 18 89 C8 89 54 24 1C 89 DA E9 19 F7 FF FF BE 01 00 00 00 31 FF E9 06 FD FF FF 8B 5C 24 20 89 F0 89 FA 8B 6C 24 20 8B 1C 9D ?? ?? ?? ?? 89 D9 31 DB 83 E9 40 D3 EA 0F AD F8 F6 C1 20 0F 45 C2 0F 45 D3 89 C1 89 D3 8B 04 ED ?? ?? ?? ?? 8B 14 ED ?? ?? ?? ?? 21 F0 21 FA 09 C2 0F 85 16 F7 FF FF 8B 44 24 18 8B 54 24 1C 89 44 24 28 89 54 24 30 E9 2D FD FF FF 8D B6 00 00 00 00 BF EC FF FF FF 8B 44 24 10 29 F7 8B 54 24 14 F7 D6 C1 E7 04 03 87 ?? ?? ?? ?? 89 74 24 20 13 97 ?? ?? ?? ?? 03 8F ?? ?? ?? ?? 13 9F ?? ?? ?? ?? E9 5D F9 FF FF C1 E7 04 8B 74 24 14 39 B7 ?? ?? ?? ?? 0F 87 2C F3 FF FF 0F 82 78 F4 FF FF 8B 6C 24 10 39 AF ?? ?? ?? ?? 0F 83 16 F3 FF FF E9 63 F4 FF FF 8B 7C 24 10 89 C8 89 DA 8B 6C 24 14 C7 44 24 28 05 00 00 00 C7 44 24 2C 00 00 00 00 89 7C 24 18 BF 05 00 00 00 89 6C 24 1C 31 ED E9 19 F6 FF FF 8B 7C 24 10 89 C8 89 DA 8B 6C 24 14 C7 44 24 28 FB FF FF FF C7 44 24 2C FF FF FF FF 89 7C 24 30 89 6C 24 34 C7 44 24 18 04 00 00 00 C7 44 24 1C 00 00 00 00 E9 37 F8 FF FF 8D 74 26 00 }
	condition:
		$1
}

rule file_15_1_0 {
	meta:
		name = "___bid128_to_int64_xrnint"
		size = 4432
		refs = "0125 ___bid_nr_digits 01ac ___bid_midpoint128 0200 ___bid_IDEC_glbflags 0312 ___bid_ten2k64 04c1 ___bid_midpoint64 0707 ___bid_ten2mk128 0a3a ___bid_maskhigh128 0a48 ___bid_shiftright128 0aef ___bid_ten2mk128trunc 0d68 ___bid_onehalf128"
	strings:
		$1 = { 81 EC 9C 00 00 00 8B 84 24 A0 00 00 00 89 B4 24 90 00 00 00 8B B4 24 AC 00 00 00 89 9C 24 8C 00 00 00 89 BC 24 94 00 00 00 89 44 24 70 8B 84 24 A4 00 00 00 8B 4C 24 70 89 F2 81 E2 00 00 00 78 89 AC 24 98 00 00 00 89 44 24 74 8B 5C 24 74 8B 84 24 A8 00 00 00 89 4C 24 08 89 5C 24 0C 89 F3 81 E3 00 00 00 80 81 FA 00 00 00 78 89 5C 24 14 0F 84 9A 01 00 00 89 F3 89 C1 81 E3 FF FF 01 00 81 FB 09 ED 01 00 76 3B C7 44 24 18 00 00 00 00 C7 44 24 1C 00 00 00 00 8B 44 24 18 8B 54 24 1C 8B 9C 24 8C 00 00 00 8B B4 24 90 00 00 00 8B BC 24 94 00 00 00 8B AC 24 98 00 00 00 81 C4 9C 00 00 00 C3 0F 83 77 01 00 00 89 DA 89 C8 81 F2 09 ED 01 00 35 C0 87 AD BE 09 C2 0F 84 D0 01 00 00 89 F0 25 00 00 00 60 3D 00 00 00 60 74 9A 89 DF 09 CF 0F 84 58 01 00 00 89 4C 24 68 89 5C 24 6C DF 6C 24 68 DD 5C 24 18 8B 54 24 1C 89 D0 C1 E8 14 25 FF 07 00 00 2D BE 03 00 00 83 E8 01 89 C7 C1 E7 05 8B 97 ?? ?? ?? ?? 85 D2 75 33 8B 97 ?? ?? ?? ?? 8B AF ?? ?? ?? ?? 8B BF ?? ?? ?? ?? 39 FB 0F 87 3B 03 00 00 0F 83 33 05 00 00 31 DF 31 CD 09 EF 0F 84 05 03 00 00 8D B4 26 00 00 00 00 81 E6 00 00 FE 7F C1 EE 11 81 EE 20 18 00 00 8D 04 32 83 F8 13 0F 8F A7 00 00 00 0F 84 66 01 00 00 83 F8 00 0F 8C 0B 05 00 00 8D B6 00 00 00 00 0F 85 6D 02 00 00 8D 42 FF 83 F8 12 0F 8E 0E 03 00 00 83 EA 14 89 D0 C1 E0 04 8B B0 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 39 C3 0F 82 22 03 00 00 77 08 39 F1 0F 82 18 03 00 00 31 D8 31 F1 09 C8 66 90 0F 84 00 0C 00 00 8B 44 24 14 C7 44 24 18 01 00 00 00 C7 44 24 1C 00 00 00 00 85 C0 74 10 C7 44 24 18 FF FF FF FF C7 44 24 1C FF FF FF FF 83 0D ?? ?? ?? ?? 20 E9 8E FE FF FF 8D B6 00 00 00 00 89 F0 25 00 00 00 7C 3D 00 00 00 7C 0F 84 20 02 00 00 83 0D ?? ?? ?? ?? 01 C7 44 24 18 00 00 00 00 C7 44 24 1C 00 00 00 80 E9 5A FE FF FF 66 90 3D C0 87 AD BE 0F 87 3D FE FF FF E9 79 FE FF FF 8B 6C 24 0C 0B 6C 24 08 C7 44 24 18 00 00 00 00 C7 44 24 1C 00 00 00 00 0F 84 2A FE FF FF 81 7C 24 0C FF FF 1F 00 0F 86 14 02 00 00 8B 54 24 0C 89 D0 31 D2 89 44 24 68 89 54 24 6C DF 6C 24 68 DD 5C 24 18 8B 54 24 1C 89 D0 C1 E8 14 25 FF 07 00 00 2D DE 03 00 00 E9 6F FE FF FF 8D 74 26 00 81 7C 24 0C 63 8E 8D 37 C7 44 24 18 00 00 00 00 C7 44 24 1C 00 00 00 00 0F 87 CA FD FF FF 89 F7 81 E7 00 00 00 60 81 FF 00 00 00 60 0F 85 16 FE FF FF E9 B1 FD FF FF 8B 44 24 14 85 C0 0F 84 4D 02 00 00 83 FA 13 0F 8F 5C 09 00 00 8B 44 24 08 8B 6C 24 0C 89 44 24 38 B8 14 00 00 00 29 D0 8B 3C C5 ?? ?? ?? ?? 8B 04 C5 ?? ?? ?? ?? 89 44 24 28 89 F8 F7 E5 89 44 24 18 8B 44 24 28 89 54 24 1C F7 E5 89 44 24 30 8B 44 24 38 89 54 24 34 F7 E7 89 54 24 24 8B 6C 24 24 31 D2 89 44 24 20 8B 44 24 18 89 EF 31 ED 89 7C 24 40 01 44 24 40 8B 44 24 28 89 6C 24 44 11 54 24 44 F7 64 24 38 01 44 24 40 11 54 24 44 8B 54 24 1C 8B 6C 24 44 89 D0 31 D2 03 44 24 30 89 EF 13 54 24 34 31 ED 01 F8 8B 7C 24 40 11 EA 89 FD BF 00 00 00 00 89 7C 24 18 8B 7C 24 20 89 6C 24 1C 31 ED 01 7C 24 18 BF 05 00 00 00 11 6C 24 1C 31 ED C7 44 24 20 05 00 00 00 C7 44 24 24 00 00 00 00 39 D5 0F 82 4F FE FF FF 77 08 39 C7 0F 82 45 FE FF FF 31 EA 31 F8 09 C2 75 1E 8B 6C 24 1C 39 6C 24 24 77 14 0F 82 2D FE FF FF 8B 44 24 18 39 44 24 20 0F 82 1F FE FF FF 83 FE 00 0F 8C A5 02 00 00 0F 85 E3 00 00 00 8B 44 24 14 8B 7C 24 08 8B 6C 24 0C 85 C0 89 7C 24 18 89 6C 24 1C 0F 84 6A FC FF FF F7 DF 83 D5 00 F7 DD 89 7C 24 18 89 6C 24 1C E9 56 FC FF FF 83 0D ?? ?? ?? ?? 01 C7 44 24 18 00 00 00 00 C7 44 24 1C 00 00 00 80 E9 3A FC FF FF C1 E0 05 8B 7C 24 0C 05 ?? ?? ?? ?? 39 78 14 0F 87 ED FC FF FF 72 0D 8B 6C 24 08 39 68 10 0F 87 DE FC FF FF 83 C2 01 E9 D6 FC FF FF 8D B6 00 00 00 00 DF 6C 24 08 DD 5C 24 18 8B 54 24 1C 89 D0 C1 E8 14 25 FF 07 00 00 2D FE 03 00 00 E9 6B FC FF FF 89 DA 09 CA 0F 85 1C FD FF FF 8B 4C 24 0C 39 0C C5 ?? ?? ?? ?? 77 19 0F 82 09 FD FF FF 8B 5C 24 08 39 1C C5 ?? ?? ?? ?? 0F 82 F8 FC FF FF 66 90 C7 44 24 18 00 00 00 00 C7 44 24 1C 00 00 00 00 E9 09 FD FF FF 8B 44 24 14 85 C0 0F 84 46 06 00 00 8B 7C 24 08 8B 6C 24 0C 8B 0C F5 ?? ?? ?? ?? 8B 14 F5 ?? ?? ?? ?? F7 DF 83 D5 00 89 F8 F7 DD 0F AF D7 0F AF CD 01 D1 F7 24 F5 ?? ?? ?? ?? 01 CA 89 44 24 18 89 54 24 1C E9 5A FB FF FF 66 90 83 FA 13 0F 8F 32 06 00 00 8B 7C 24 08 B8 14 00 00 00 29 D0 8B 6C 24 0C 89 7C 24 38 8B 3C C5 ?? ?? ?? ?? 8B 04 C5 ?? ?? ?? ?? 89 44 24 28 89 F8 F7 E5 89 44 24 18 8B 44 24 28 89 54 24 1C F7 E5 89 44 24 30 8B 44 24 38 89 54 24 34 F7 E7 89 54 24 24 8B 6C 24 24 31 D2 89 44 24 20 8B 44 24 18 89 EF 31 ED 89 7C 24 40 01 44 24 40 8B 44 24 28 89 6C 24 44 11 54 24 44 F7 64 24 38 01 44 24 40 11 54 24 44 8B 54 24 1C 8B 6C 24 44 89 D0 31 D2 03 44 24 30 89 EF 13 54 24 34 31 ED 01 F8 8B 7C 24 40 11 EA 89 FD BF 00 00 00 00 89 7C 24 28 89 6C 24 2C 8B 6C 24 20 C7 44 24 1C 00 00 00 00 C7 44 24 20 FB FF FF FF C7 44 24 24 FF FF FF FF 89 6C 24 18 8B 7C 24 18 8B 6C 24 1C 01 7C 24 28 11 6C 24 2C C7 44 24 18 04 00 00 00 C7 44 24 1C 00 00 00 00 39 54 24 1C 0F 82 E5 FB FF FF 77 0A 39 44 24 18 0F 82 D9 FB FF FF 33 54 24 1C 33 44 24 18 09 C2 0F 85 AA FD FF FF 8B 6C 24 2C 39 6C 24 24 0F 87 9C FD FF FF 0F 82 B5 FB FF FF 8B 44 24 28 39 44 24 20 0F 87 88 FD FF FF E9 A2 FB FF FF 39 E9 0F 87 FA FD FF FF 90 8D B4 26 00 00 00 00 E9 B8 FA FF FF 83 0D ?? ?? ?? ?? 20 C7 44 24 18 00 00 00 00 C7 44 24 1C 00 00 00 00 E9 E7 F9 FF FF 89 F5 F7 DD 83 FD 13 89 6C 24 5C 0F 8F DF 06 00 00 F7 D6 8B 44 24 08 8B 54 24 0C 03 04 F5 ?? ?? ?? ?? 13 14 F5 ?? ?? ?? ?? 89 74 24 04 39 54 24 0C 72 0E 77 06 39 44 24 08 76 06 83 C1 01 83 D3 00 8B 74 24 04 89 D7 89 C5 C7 44 24 2C 00 00 00 00 C1 E6 04 8B 86 ?? ?? ?? ?? 8B 96 ?? ?? ?? ?? 89 44 24 38 89 54 24 40 F7 E7 89 44 24 18 8B 44 24 40 89 54 24 1C F7 E7 89 44 24 20 8B 44 24 38 89 54 24 24 F7 E5 89 54 24 4C 8B 54 24 18 89 44 24 48 89 54 24 28 8B 54 24 4C 89 D0 31 D2 89 44 24 08 8B 44 24 28 01 44 24 08 8B 44 24 40 89 54 24 0C 8B 54 24 2C 11 54 24 0C F7 E5 01 44 24 08 11 54 24 0C 8B 54 24 1C 89 D0 31 D2 89 44 24 18 8B 44 24 20 01 44 24 18 89 54 24 1C 8B 54 24 24 11 54 24 1C 8B 54 24 0C 89 D0 31 D2 01 44 24 18 11 54 24 1C 8B 96 ?? ?? ?? ?? 8B B6 ?? ?? ?? ?? 89 D0 89 54 24 28 F7 E7 89 74 24 58 89 44 24 20 89 F0 89 54 24 24 F7 E7 89 44 24 50 8B 44 24 28 89 54 24 54 F7 E5 89 54 24 64 8B 7C 24 64 31 D2 89 44 24 60 8B 44 24 20 89 FE 31 FF 01 C6 8B 44 24 58 11 D7 F7 E5 01 C6 11 D7 8B 54 24 24 89 D0 31 D2 89 44 24 20 8B 44 24 50 89 54 24 24 8B 54 24 54 01 44 24 20 11 54 24 24 31 D2 01 7C 24 20 11 54 24 24 31 C0 31 D2 8B 6C 24 24 89 74 24 54 8B 74 24 08 89 44 24 50 8B 44 24 60 01 44 24 50 11 54 24 54 31 D2 89 F7 8B 44 24 48 31 F6 89 7C 24 0C 8B 7C 24 20 89 74 24 08 01 44 24 08 11 54 24 0C 01 7C 24 08 11 6C 24 0C 8B 44 24 0C 39 C5 72 14 77 08 8B 54 24 08 39 D7 76 0A 83 44 24 18 01 83 54 24 1C 00 8B 44 24 38 89 DE 89 CD F7 E3 89 44 24 20 8B 44 24 40 89 54 24 24 F7 E3 89 44 24 48 8B 44 24 38 89 54 24 4C F7 E1 89 54 24 3C 8B 5C 24 3C 31 D2 89 44 24 38 8B 44 24 20 89 D9 31 DB 89 4C 24 30 01 44 24 30 8B 44 24 40 89 5C 24 34 8B 5C 24 24 11 54 24 34 F7 E5 01 44 24 30 89 D9 11 54 24 34 31 DB 8B 54 24 34 89 4C 24 20 8B 4C 24 48 01 4C 24 20 89 5C 24 24 8B 5C 24 4C 89 D0 11 5C 24 24 31 D2 01 44 24 20 8B 44 24 28 11 54 24 24 F7 E6 89 C1 8B 44 24 58 89 D3 F7 E6 89 44 24 48 8B 44 24 28 89 54 24 4C F7 E5 89 54 24 2C 8B 7C 24 2C 31 D2 89 44 24 28 8B 44 24 58 C7 44 24 2C 00 00 00 00 89 FE 31 FF 01 CE 89 D9 11 D7 F7 E5 8B 6C 24 38 01 C6 8B 44 24 28 11 D7 31 DB 03 4C 24 48 13 5C 24 4C 31 D2 89 6C 24 28 01 F9 89 F7 11 D3 31 F6 31 D2 01 C6 8B 44 24 30 11 D7 89 C2 31 C0 03 44 24 28 13 54 24 2C 01 C8 11 DA 39 D3 72 10 77 04 39 C1 76 0A 83 44 24 20 01 83 54 24 24 00 8B 4C 24 08 8B 5C 24 0C 01 F1 11 FB 89 5C 24 0C 31 DB 3B 7C 24 0C 89 4C 24 08 B9 01 00 00 00 77 0C 72 06 3B 74 24 08 77 04 31 C9 31 DB 8B 74 24 18 01 C8 8B 7C 24 1C 11 DA 01 C6 11 D7 39 FA 89 74 24 18 89 7C 24 1C 0F 87 23 03 00 00 72 08 39 F0 0F 87 19 03 00 00 31 FF 39 D3 BE 01 00 00 00 77 0A 72 04 39 C1 77 04 31 F6 31 FF 03 74 24 20 13 7C 24 24 83 7C 24 5C 16 0F 8F FD 02 00 00 8B 6C 24 04 BB 40 00 00 00 8B 44 24 18 8B 54 24 1C 23 04 ED ?? ?? ?? ?? 23 14 ED ?? ?? ?? ?? 8B 0C AD ?? ?? ?? ?? 31 ED 89 44 24 20 8B 44 24 18 89 54 24 24 8B 54 24 1C 0F AD D0 D3 EA F6 C1 20 0F 45 C2 0F 45 D5 29 CB 89 D9 31 DB 0F A5 F7 D3 E6 F6 C1 20 0F 45 FE 0F 45 F3 89 F1 89 FB 09 C1 09 D3 83 7C 24 5C 03 0F 8F 7F 05 00 00 81 7C 24 0C 00 00 00 80 0F 87 9F 03 00 00 72 0B 83 7C 24 08 00 0F 87 92 03 00 00 8B 44 24 0C 05 00 00 00 80 0B 44 24 08 0F 84 9D 04 00 00 83 0D ?? ?? ?? ?? 20 8B 7C 24 24 0B 7C 24 20 75 4D 8B 6C 24 0C 0B 6C 24 08 75 0A 8B 44 24 54 0B 44 24 50 74 39 8B 44 24 04 C1 E0 04 8B 90 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 39 44 24 0C 0F 82 43 04 00 00 77 0A 39 54 24 08 0F 82 37 04 00 00 33 44 24 0C 33 54 24 08 09 D0 0F 84 FE 03 00 00 8B 44 24 14 89 4C 24 18 89 5C 24 1C 85 C0 0F 84 65 F5 FF FF F7 D9 83 D3 00 F7 DB 89 4C 24 18 89 5C 24 1C E9 51 F5 FF FF 8B 4C 24 0C 8B 44 24 08 0F AF 04 F5 ?? ?? ?? ?? 0F AF 0C F5 ?? ?? ?? ?? 01 C1 8B 44 24 08 F7 24 F5 ?? ?? ?? ?? 01 CA 89 44 24 18 89 54 24 1C E9 1D F5 FF FF 83 FA 14 0F 84 60 03 00 00 8B 2C D5 ?? ?? ?? ?? 8B 3C D5 ?? ?? ?? ?? 89 6C 24 3C 8B 6C 24 3C 89 7C 24 20 89 7C 24 38 BF FB FF FF FF 89 E8 F7 E7 89 44 24 28 B8 FF FF FF FF 89 54 24 2C F7 E5 89 44 24 18 8B 44 24 20 89 54 24 1C F7 E7 89 54 24 34 8B 6C 24 34 31 D2 89 44 24 30 8B 44 24 28 89 EF 31 ED 01 C7 B8 FF FF FF FF 11 D5 F7 64 24 20 01 C7 89 F8 11 D5 89 C2 B8 00 00 00 00 89 44 24 20 8B 44 24 30 89 54 24 24 31 D2 01 44 24 20 11 54 24 24 8B 44 24 38 8B 54 24 3C 0F A4 C2 02 C1 E0 02 01 44 24 18 11 54 24 1C 8B 54 24 2C 89 D0 31 D2 01 44 24 18 89 C8 11 54 24 1C 31 D2 8B 7C 24 08 01 6C 24 18 8B 6C 24 0C 11 54 24 1C 89 DA 89 7C 24 28 89 6C 24 2C E9 DB F9 FF FF 83 FA 14 0F 84 53 02 00 00 8D 6A EC 8B 3C ED ?? ?? ?? ?? 89 7C 24 30 8B 44 24 30 BF 05 00 00 00 F7 E7 89 44 24 28 8B 04 ED ?? ?? ?? ?? 89 54 24 2C F7 E7 89 54 24 1C 8B 6C 24 1C 31 D2 89 44 24 18 8B 44 24 28 89 EF 31 ED 89 7C 24 38 01 44 24 38 8B 44 24 38 89 6C 24 3C 8B 6C 24 2C 11 54 24 3C 89 C2 31 C0 89 44 24 20 8B 44 24 18 89 EF 89 54 24 24 31 D2 01 44 24 20 11 54 24 24 31 ED 8B 54 24 30 8B 44 24 18 8D 14 92 89 54 24 28 8B 54 24 28 03 54 24 1C 01 C7 11 D5 8B 54 24 3C 89 D0 31 D2 01 C7 8B 44 24 08 11 D5 8B 54 24 0C 89 44 24 18 89 C8 89 54 24 1C 89 DA E9 B4 F6 FF FF BE 01 00 00 00 31 FF E9 F0 FC FF FF 8B 5C 24 04 89 FA 8B 2C DD ?? ?? ?? ?? 8B 04 9D ?? ?? ?? ?? 21 F5 89 6C 24 38 8B 2C DD ?? ?? ?? ?? 89 C1 83 E9 40 89 F0 0F AD F8 31 DB D3 EA 21 FD 8B 7C 24 04 F6 C1 20 0F 45 C2 0F 45 D3 89 C1 89 D3 8B 04 FD ?? ?? ?? ?? 8B 34 FD ?? ?? ?? ?? 39 C5 0F 86 89 00 00 00 8B 44 24 18 8B 54 24 1C 83 0D ?? ?? ?? ?? 20 89 44 24 20 89 54 24 24 0B 6C 24 38 0F 85 83 FD FF FF E9 27 FD FF FF BF EC FF FF FF 8B 44 24 08 29 F7 8B 54 24 0C F7 D6 C1 E7 04 03 87 ?? ?? ?? ?? 89 74 24 04 13 97 ?? ?? ?? ?? 03 8F ?? ?? ?? ?? 13 9F ?? ?? ?? ?? E9 08 F9 FF FF C1 E2 04 8B 74 24 0C 39 B2 ?? ?? ?? ?? 0F 87 F7 F6 FF FF 0F 82 E7 F3 FF FF 8B 7C 24 08 39 BA ?? ?? ?? ?? 0F 83 E1 F6 FF FF E9 D2 F3 FF FF 72 10 39 74 24 38 8D B6 00 00 00 00 0F 87 65 FF FF FF 33 74 24 38 31 E8 09 F0 0F 84 64 01 00 00 8B 74 24 18 8B 7C 24 1C 83 0D ?? ?? ?? ?? 20 89 74 24 20 89 7C 24 24 E9 52 FF FF FF 8B 74 24 08 8B 7C 24 0C 8B 44 24 04 83 C6 00 81 D7 00 00 00 80 C1 E0 04 8B 90 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 39 C7 0F 87 55 FC FF FF 72 08 39 D6 0F 87 4B FC FF FF 31 F8 31 F2 09 D0 0F 85 46 FC FF FF 8B 44 24 04 8B 54 24 54 C1 E0 04 3B 90 ?? ?? ?? ?? 0F 82 2F FC FF FF 0F 87 22 FC FF FF 8B 74 24 50 3B B0 ?? ?? ?? ?? 0F 82 19 FC FF FF E9 0D FC FF FF 8B 7C 24 08 89 C8 89 DA 8B 6C 24 0C C7 44 24 20 05 00 00 00 C7 44 24 24 00 00 00 00 89 7C 24 18 BF 05 00 00 00 89 6C 24 1C 31 ED E9 E7 F4 FF FF 8B 7C 24 08 89 C8 89 DA 8B 6C 24 0C C7 44 24 20 FB FF FF FF C7 44 24 24 FF FF FF FF 89 7C 24 28 89 6C 24 2C C7 44 24 18 04 00 00 00 C7 44 24 1C 00 00 00 00 E9 16 F7 FF FF 8B 44 24 04 8B 54 24 54 C1 E0 04 3B 90 ?? ?? ?? ?? 0F 87 EB FB FF FF 72 10 8B 74 24 50 3B B0 ?? ?? ?? ?? 0F 87 D9 FB FF FF 89 C8 83 E0 01 85 C0 0F 84 CC FB FF FF 83 C1 FF 83 D3 FF E9 C1 FB FF FF 8B 6C 24 54 0B 6C 24 50 0F 84 55 FB FF FF 8B 44 24 04 31 F6 31 FF C1 E0 04 8B 90 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? E9 EE FE FF FF 8B 74 24 1C 0B 74 24 18 0F 85 E5 FD FF FF 8B 7C 24 0C 0B 7C 24 08 75 40 8B 44 24 54 0B 44 24 50 0F 84 76 FE FF FF 8B 44 24 04 C1 E0 04 8B B0 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 39 44 24 0C 0F 84 40 01 00 00 C7 44 24 20 00 00 00 00 C7 44 24 24 00 00 00 00 E9 B2 FD FF FF 8B 44 24 04 C1 E0 04 8B B0 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 39 44 24 0C 0F 87 7E FD FF FF 72 C2 39 }
	condition:
		$1
}

rule file_15_2_0 {
	meta:
		name = "___bid128_to_int64_floor"
		size = 3152
		refs = "0123 ___bid_nr_digits 01e4 ___bid_IDEC_glbflags 032b ___bid_ten2k64 0611 ___bid_ten2mk128 0955 ___bid_maskhigh128 095c ___bid_shiftright128 09b8 ___bid_ten2mk128trunc"
	strings:
		$1 = { 81 EC 9C 00 00 00 8B 84 24 A0 00 00 00 8B 8C 24 AC 00 00 00 89 B4 24 90 00 00 00 89 9C 24 8C 00 00 00 89 44 24 70 8B 84 24 A4 00 00 00 8B 5C 24 70 89 AC 24 98 00 00 00 8B AC 24 A8 00 00 00 89 BC 24 94 00 00 00 89 44 24 74 8B 74 24 74 89 C8 25 00 00 00 78 89 5C 24 08 89 74 24 0C 89 CE 81 E6 00 00 00 80 3D 00 00 00 78 89 74 24 48 0F 84 5C 01 00 00 89 CF 89 EE 81 E7 FF FF 01 00 81 FF 09 ED 01 00 76 3B C7 44 24 10 00 00 00 00 C7 44 24 14 00 00 00 00 8B 44 24 10 8B 54 24 14 8B 9C 24 8C 00 00 00 8B B4 24 90 00 00 00 8B BC 24 94 00 00 00 8B AC 24 98 00 00 00 81 C4 9C 00 00 00 C3 0F 83 39 01 00 00 89 FA 89 F0 81 F2 09 ED 01 00 35 C0 87 AD BE 09 C2 0F 84 92 01 00 00 89 C8 25 00 00 00 60 3D 00 00 00 60 74 9A 89 F8 09 F0 0F 84 1B 01 00 00 89 74 24 68 89 7C 24 6C DF 6C 24 68 DD 5C 24 10 8B 54 24 14 89 D0 C1 E8 14 25 FF 07 00 00 2D BE 03 00 00 83 E8 01 89 C3 C1 E3 05 8B 93 ?? ?? ?? ?? 89 44 24 18 85 D2 75 34 8B 83 ?? ?? ?? ?? 8B 93 ?? ?? ?? ?? 8B 9B ?? ?? ?? ?? 89 44 24 10 39 DF 0F 87 A3 01 00 00 0F 83 A2 04 00 00 8B 44 24 10 31 FB 31 F0 09 C3 0F 84 60 01 00 00 81 E1 00 00 FE 7F C1 E9 11 8D 99 E0 E7 FF FF 8D 04 1A 83 F8 13 7F 68 0F 84 78 01 00 00 85 C0 0F 8E BF 02 00 00 83 FB 00 90 8D 74 26 00 0F 8C 6C 04 00 00 0F 85 DC 02 00 00 8B 44 24 48 8B 4C 24 08 8B 5C 24 0C 85 C0 89 4C 24 10 89 5C 24 14 0F 84 DE FE FF FF F7 D9 83 D3 00 F7 DB 89 4C 24 10 89 5C 24 14 E9 CA FE FF FF 8D 74 26 00 89 C8 25 00 00 00 7C 3D 00 00 00 7C 0F 84 C5 00 00 00 83 0D ?? ?? ?? ?? 01 C7 44 24 10 00 00 00 00 C7 44 24 14 00 00 00 80 E9 98 FE FF FF 66 90 81 FD C0 87 AD BE 0F 87 7A FE FF FF E9 B6 FE FF FF 8B 54 24 0C 0B 54 24 08 C7 44 24 10 00 00 00 00 C7 44 24 14 00 00 00 00 0F 84 67 FE FF FF 81 7C 24 0C FF FF 1F 00 0F 86 84 02 00 00 8B 54 24 0C 89 D0 31 D2 89 44 24 68 89 54 24 6C DF 6C 24 68 DD 5C 24 10 8B 54 24 14 89 D0 C1 E8 14 25 FF 07 00 00 2D DE 03 00 00 E9 AC FE FF FF 8D 76 00 81 7C 24 0C 63 8E 8D 37 C7 44 24 10 00 00 00 00 C7 44 24 14 00 00 00 00 0F 87 08 FE FF FF 89 CB 81 E3 00 00 00 60 81 FB 00 00 00 60 0F 85 54 FE FF FF E9 EF FD FF FF 83 0D ?? ?? ?? ?? 01 C7 44 24 10 00 00 00 00 C7 44 24 14 00 00 00 80 E9 D3 FD FF FF 8B 44 24 18 8B 5C 24 0C C1 E0 05 05 ?? ?? ?? ?? 39 58 14 0F 87 87 FE FF FF 72 12 8B 5C 24 08 39 58 10 0F 87 78 FE FF FF 90 8D 74 26 00 83 C2 01 E9 6B FE FF FF 8B 44 24 48 85 C0 0F 84 DD 01 00 00 83 FA 13 0F 8F C6 07 00 00 8B 44 24 0C 8B 4C 24 08 C7 44 24 3C 00 00 00 00 89 44 24 28 B8 14 00 00 00 29 D0 8B 14 C5 ?? ?? ?? ?? 8B 04 C5 ?? ?? ?? ?? 89 54 24 18 89 44 24 30 89 D0 F7 64 24 28 89 44 24 10 8B 44 24 30 89 54 24 14 F7 64 24 28 89 44 24 28 8B 44 24 18 89 54 24 2C F7 E1 89 54 24 1C 8B 54 24 10 89 44 24 18 89 54 24 38 8B 54 24 1C 89 D0 31 D2 89 44 24 20 8B 44 24 38 01 44 24 20 8B 44 24 30 89 54 24 24 8B 54 24 3C 11 54 24 24 F7 E1 01 44 24 20 11 54 24 24 8B 4C 24 14 8B 44 24 28 C7 44 24 1C 00 00 00 00 89 CA 31 C9 89 54 24 10 8B 54 24 2C 01 44 24 10 89 4C 24 14 11 54 24 14 8B 54 24 24 89 D0 31 D2 01 44 24 10 11 54 24 14 8B 54 24 20 8B 44 24 18 C7 44 24 18 05 00 00 00 89 D1 31 D2 89 54 24 20 31 D2 01 44 24 20 89 4C 24 24 11 54 24 24 8B 4C 24 14 39 4C 24 1C 0F 82 D6 FD FF FF 77 0E 8B 44 24 10 39 44 24 18 0F 82 C6 FD FF FF 8B 54 24 1C 8B 44 24 18 33 54 24 14 33 44 24 10 09 C2 0F 85 54 FD FF FF 8B 54 24 24 0B 54 24 20 0F 84 46 FD FF FF E9 9B FD FF FF 8B 7C 24 48 C7 44 24 10 00 00 00 00 C7 44 24 14 00 00 00 00 85 FF 0F 84 33 FC FF FF C7 44 24 10 FF FF FF FF C7 44 24 14 FF FF FF FF E9 1E FC FF FF 8B 44 24 48 85 C0 0F 84 3D 01 00 00 8B 74 24 08 8B 7C 24 0C 8B 0C DD ?? ?? ?? ?? 8B 14 DD ?? ?? ?? ?? F7 DE 83 D7 00 89 F0 F7 DF 0F AF D6 0F AF CF 01 D1 F7 24 DD ?? ?? ?? ?? 01 CA 89 44 24 10 89 54 24 14 E9 D5 FB FF FF DF 6C 24 08 DD 5C 24 10 8B 54 24 14 89 D0 C1 E8 14 25 FF 07 00 00 2D FE 03 00 00 E9 38 FC FF FF 83 FA 13 0F 8F 2E 06 00 00 B8 14 00 00 00 8B 4C 24 0C 29 D0 8B 14 C5 ?? ?? ?? ?? 8B 04 C5 ?? ?? ?? ?? 89 4C 24 18 8B 4C 24 08 C7 44 24 2C 00 00 00 00 89 54 24 10 89 44 24 30 89 D0 F7 64 24 18 89 44 24 20 8B 44 24 30 89 54 24 24 F7 64 24 18 89 44 24 18 8B 44 24 10 89 54 24 1C 8B 54 24 20 89 54 24 28 F7 E1 89 D0 31 D2 89 44 24 10 8B 44 24 28 01 44 24 10 89 54 24 14 8B 54 24 2C 11 54 24 14 8B 54 24 24 89 D0 31 D2 89 44 24 20 8B 44 24 18 01 44 24 20 89 54 24 24 8B 54 24 1C 11 54 24 24 8B 44 24 30 F7 E1 01 44 24 10 B8 05 00 00 00 11 54 24 14 8B 4C 24 14 89 CA 31 C9 01 54 24 20 11 4C 24 24 31 D2 3B 54 24 24 0F 82 30 FC FF FF 3B 44 24 20 0F 87 CC FB FF FF E9 21 FC FF FF 8B 4C 24 0C 8B 44 24 08 0F AF 04 DD ?? ?? ?? ?? 0F AF 0C DD ?? ?? ?? ?? 01 C1 8B 44 24 08 F7 24 DD ?? ?? ?? ?? 01 CA 89 44 24 10 89 54 24 14 E9 A1 FA FF FF 39 C6 0F 87 F3 FC FF FF E9 51 FB FF FF 89 D9 F7 D3 89 5C 24 4C C1 E3 04 F7 D9 8B 93 ?? ?? ?? ?? 8B 83 ?? ?? ?? ?? 89 4C 24 64 8B 4C 24 0C C7 44 24 34 00 00 00 00 89 54 24 28 89 44 24 38 89 D0 F7 E1 89 44 24 20 8B 44 24 38 89 54 24 24 F7 E1 89 44 24 18 8B 44 24 28 89 54 24 1C F7 64 24 08 89 54 24 44 8B 54 24 20 89 44 24 40 89 54 24 30 8B 54 24 44 89 D0 31 D2 89 44 24 10 8B 44 24 30 01 44 24 10 8B 44 24 38 89 54 24 14 8B 54 24 34 11 54 24 14 F7 64 24 08 01 44 24 10 11 54 24 14 8B 54 24 24 89 D0 31 D2 89 44 24 20 8B 44 24 18 01 44 24 20 89 54 24 24 8B 54 24 1C 11 54 24 24 8B 54 24 14 89 D0 31 D2 01 44 24 20 11 54 24 24 8B 93 ?? ?? ?? ?? 8B 9B ?? ?? ?? ?? 89 D0 89 54 24 30 F7 E1 89 5C 24 60 89 44 24 18 89 D8 89 54 24 1C F7 E1 89 44 24 50 8B 44 24 30 89 54 24 54 F7 64 24 08 89 54 24 5C 8B 5C 24 5C 31 D2 89 44 24 58 8B 44 24 18 89 D9 31 DB 01 C1 8B 44 24 60 11 D3 F7 64 24 08 01 C1 11 D3 8B 54 24 1C 89 D0 31 D2 89 44 24 18 8B 44 24 50 01 44 24 18 89 54 24 1C 8B 54 24 54 11 54 24 1C 31 D2 01 5C 24 18 11 54 24 1C 31 C0 31 D2 89 4C 24 54 8B 4C 24 10 89 44 24 50 8B 44 24 58 01 44 24 50 11 54 24 54 31 D2 8B 44 24 40 89 CB 31 C9 89 4C 24 10 01 44 24 10 8B 44 24 18 89 5C 24 14 11 54 24 14 8B 54 24 1C 01 44 24 10 11 54 24 14 8B 4C 24 14 39 CA 72 14 77 08 8B 5C 24 10 39 D8 76 0A 83 44 24 20 01 83 54 24 24 00 8B 44 24 28 31 DB F7 E7 89 44 24 08 8B 44 24 38 89 54 24 0C 8B 4C 24 08 F7 E7 89 44 24 40 8B 44 24 28 89 54 24 44 8B 74 24 44 F7 E5 89 44 24 28 89 D0 89 44 24 18 8B 44 24 38 89 54 24 2C 31 D2 89 54 24 1C F7 E5 01 44 24 18 11 54 24 1C 01 4C 24 18 11 5C 24 1C 8B 5C 24 0C 8B 54 24 1C 89 D9 31 DB 89 5C 24 0C 8B 5C 24 40 89 D0 89 4C 24 08 01 5C 24 08 11 74 24 0C 31 D2 01 44 24 08 8B 44 24 30 11 54 24 0C 31 DB C7 44 24 1C 00 00 00 00 F7 E7 89 44 24 38 8B 44 24 60 89 54 24 3C 8B 74 24 38 F7 E7 31 FF 89 44 24 40 8B 44 24 30 89 54 24 44 F7 E5 89 44 24 30 8B 44 24 60 89 D1 89 54 24 34 F7 E5 8B 6C 24 28 01 C1 8B 44 24 30 11 D3 01 F1 11 FB 8B 7C 24 3C 89 FE 31 FF 03 74 24 40 13 7C 24 44 31 D2 01 DE 89 CB 11 D7 31 C9 31 D2 01 C1 8B 44 24 18 11 D3 89 6C 24 18 89 C2 31 C0 03 44 24 18 13 54 24 1C 01 F0 11 FA 39 D7 72 10 77 04 39 C6 76 0A 83 44 24 08 01 83 54 24 0C 00 8B 74 24 10 8B 7C 24 14 01 CE 11 DF 89 7C 24 14 31 FF 3B 5C 24 14 89 74 24 10 BE 01 00 00 00 77 0C 72 06 3B 4C 24 10 77 04 31 F6 31 FF 8B 4C 24 20 01 F0 8B 5C 24 24 11 FA 01 C1 11 D3 39 DA 89 4C 24 20 89 5C 24 24 0F 87 AF 01 00 00 72 08 39 C8 0F 87 A5 01 00 00 31 DB 39 D7 B9 01 00 00 00 77 0A 72 04 39 C6 77 04 31 C9 31 DB 89 C8 89 DA 03 44 24 08 13 54 24 0C 83 7C 24 64 16 8B 5C 24 4C 0F 8F BE 00 00 00 8B 34 DD ?? ?? ?? ?? 8B 0C 9D ?? ?? ?? ?? 8B 7C 24 24 8B 2C DD ?? ?? ?? ?? 31 DB 89 74 24 08 8B 74 24 20 0F AD FE D3 EF F6 C1 20 0F 45 F7 0F 45 FB BB 40 00 00 00 29 CB 89 D9 31 DB 0F A5 C2 D3 E0 F6 C1 20 0F 45 D0 0F 45 C3 89 C1 89 D3 09 F1 09 FB 83 7C 24 64 03 0F 8F 11 02 00 00 8B 44 24 4C C1 E0 04 8B 90 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 39 44 24 14 0F 87 E4 00 00 00 72 0A 39 54 24 10 0F 87 D8 00 00 00 33 44 24 14 33 54 24 10 09 D0 0F 84 A6 01 00 00 8B 44 24 48 85 C0 0F 84 CB F7 FF FF 89 CF 89 DD F7 DF 83 D5 00 F7 DD 89 7C 24 10 89 6C 24 14 E9 8A F6 FF FF 8D 74 26 00 8B 1C 9D ?? ?? ?? ?? 89 C6 89 D7 89 D9 31 DB 83 E9 40 0F AD D6 D3 EF F6 C1 20 0F 45 F7 0F 45 FB 89 FB 8B 7C 24 4C 89 F1 23 04 FD ?? ?? ?? ?? 23 14 FD ?? ?? ?? ?? 09 C2 75 66 8B 6C 24 24 0B 6C 24 20 75 5C 8B 44 24 4C C1 E0 04 8B 90 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 39 44 24 14 77 43 72 06 39 54 24 10 77 3B 33 44 24 14 33 54 24 10 09 D0 0F 85 63 FF FF FF 8B 44 24 4C 8B 54 24 54 C1 E0 04 3B 90 ?? ?? ?? ?? 0F 82 4C FF FF FF 77 12 8B 74 24 50 3B B0 ?? ?? ?? ?? 0F 86 3A FF FF FF 66 90 8B 44 24 48 85 C0 0F 84 03 F7 FF FF 83 C1 01 83 D3 00 E9 2D FF FF FF B8 01 00 00 00 31 D2 E9 68 FE FF FF 83 FA 14 74 75 83 EA 14 B8 05 00 00 00 8B 0C D5 ?? ?? ?? ?? F7 24 D5 ?? ?? ?? ?? 89 74 24 10 89 7C 24 14 8D 0C 89 01 CA 89 44 24 18 8B 44 24 08 89 54 24 1C 8B 54 24 0C 89 44 24 20 89 54 24 24 E9 E6 F8 FF FF 83 FA 14 74 5D 83 EA 14 B8 05 00 00 00 8B 0C D5 ?? ?? ?? ?? F7 24 D5 ?? ?? ?? ?? 89 74 24 20 89 7C 24 24 8D 0C 89 01 CA 39 FA 0F 87 40 F6 FF FF E9 5B FA FF FF 8B 54 24 08 8B 4C 24 0C 89 74 24 10 89 7C 24 14 89 54 24 20 89 4C 24 24 C7 44 24 18 05 00 00 00 C7 44 24 1C 00 00 00 00 E9 84 F8 FF FF 89 74 24 20 B8 05 00 00 00 31 D2 89 7C 24 24 E9 1A FA FF FF 8B 44 24 4C 8B 6C 24 54 C1 E0 04 3B A8 ?? ?? ?? ?? 0F 82 43 FE FF FF 0F 87 05 FF FF FF 8B 54 24 50 3B 90 ?? ?? ?? ?? 0F 86 2D FE FF FF E9 F0 FE FF FF 8B 54 24 20 8B 44 24 24 23 44 24 08 21 EA 09 D0 0F 85 DA FE FF FF 8B 44 24 4C C1 E0 04 8B 90 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 39 44 24 14 0F 87 BD FE FF FF 72 0A 39 54 24 10 0F 87 B1 FE FF FF 33 44 24 14 33 54 24 10 09 D0 0F 85 D9 FD FF FF 8B 44 24 4C 8B 74 24 54 C1 E0 04 3B B0 ?? ?? ?? ?? 0F 82 C2 FD FF FF 0F 87 84 FE FF FF 8B 7C 24 50 3B B8 ?? ?? ?? ?? 0F 86 AC FD FF FF E9 6F FE FF FF EB 0D 90 90 90 90 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_15_3_0 {
	meta:
		name = "___bid128_to_int64_xfloor"
		size = 3104
		refs = "00ea ___bid_nr_digits 01d4 ___bid_IDEC_glbflags 02fb ___bid_ten2k64 05e0 ___bid_ten2mk128 0924 ___bid_maskhigh128 092b ___bid_shiftright128 0987 ___bid_ten2mk128trunc"
	strings:
		$1 = { 81 EC 9C 00 00 00 8B 84 24 A0 00 00 00 8B 8C 24 AC 00 00 00 89 B4 24 90 00 00 00 89 9C 24 8C 00 00 00 89 44 24 70 8B 84 24 A4 00 00 00 8B 5C 24 70 89 AC 24 98 00 00 00 8B AC 24 A8 00 00 00 89 BC 24 94 00 00 00 89 44 24 74 8B 74 24 74 89 C8 25 00 00 00 78 89 5C 24 08 89 74 24 0C 89 CE 81 E6 00 00 00 80 3D 00 00 00 78 89 74 24 48 0F 84 4C 01 00 00 89 CF 89 EE 81 E7 FF FF 01 00 81 FF 09 ED 01 00 0F 83 F9 00 00 00 89 FA 89 F0 81 F2 09 ED 01 00 35 C0 87 AD BE 09 C2 0F 84 AF 01 00 00 89 C8 25 00 00 00 60 3D 00 00 00 60 0F 84 D2 00 00 00 89 F8 09 F0 0F 84 43 01 00 00 89 74 24 68 89 7C 24 6C DF 6C 24 68 DD 5C 24 10 8B 54 24 14 89 D0 C1 E8 14 25 FF 07 00 00 2D BE 03 00 00 83 E8 01 89 C3 C1 E3 05 8B 93 ?? ?? ?? ?? 89 44 24 18 85 D2 75 3A 8B 83 ?? ?? ?? ?? 8B 93 ?? ?? ?? ?? 8B 9B ?? ?? ?? ?? 89 44 24 10 39 DF 0F 87 AC 01 00 00 0F 83 AA 04 00 00 8B 44 24 10 31 FB 31 F0 09 C3 0F 84 67 01 00 00 8D B6 00 00 00 00 81 E1 00 00 FE 7F C1 E9 11 8D 99 E0 E7 FF FF 8D 04 1A 83 F8 13 0F 8F 87 00 00 00 0F 84 77 01 00 00 85 C0 0F 8E BE 02 00 00 83 FB 00 8D 74 26 00 0F 8C 6B 04 00 00 0F 85 D4 02 00 00 8B 7C 24 48 85 FF 74 21 F7 5C 24 08 83 54 24 0C 00 F7 5C 24 0C EB 12 76 6B C7 44 24 08 00 00 00 00 C7 44 24 0C 00 00 00 00 8B 44 24 08 8B 54 24 0C 8B 9C 24 8C 00 00 00 8B B4 24 90 00 00 00 8B BC 24 94 00 00 00 8B AC 24 98 00 00 00 81 C4 9C 00 00 00 C3 89 C8 25 00 00 00 7C 3D 00 00 00 7C 0F 84 A3 00 00 00 83 0D ?? ?? ?? ?? 01 C7 44 24 08 00 00 00 00 C7 44 24 0C 00 00 00 80 EB AA 90 8D 74 26 00 81 FD C0 87 AD BE 0F 86 8E FE FF FF EB 87 66 90 8B 54 24 0C 0B 54 24 08 0F 84 77 FF FF FF 81 7C 24 0C FF FF 1F 00 0F 86 74 02 00 00 8B 54 24 0C 89 D0 31 D2 89 44 24 68 89 54 24 6C DF 6C 24 68 DD 5C 24 10 8B 54 24 14 89 D0 C1 E8 14 25 FF 07 00 00 2D DE 03 00 00 E9 94 FE FF FF 8D 74 26 00 81 7C 24 0C 63 8E 8D 37 0F 87 27 FF FF FF 89 C8 25 00 00 00 60 3D 00 00 00 60 0F 85 4D FE FF FF E9 10 FF FF FF 83 0D ?? ?? ?? ?? 01 C7 44 24 08 00 00 00 00 C7 44 24 0C 00 00 00 80 E9 04 FF FF FF 8B 44 24 18 8B 5C 24 0C C1 E0 05 05 ?? ?? ?? ?? 39 58 14 0F 87 86 FE FF FF 72 14 8B 5C 24 08 39 58 10 0F 87 77 FE FF FF 8D B4 26 00 00 00 00 83 C2 01 E9 68 FE FF FF 8B 44 24 48 85 C0 0F 84 DC 01 00 00 83 FA 13 0F 8F CF 07 00 00 8B 44 24 0C 8B 4C 24 08 C7 44 24 3C 00 00 00 00 89 44 24 28 B8 14 00 00 00 29 D0 8B 14 C5 ?? ?? ?? ?? 8B 04 C5 ?? ?? ?? ?? 89 54 24 18 89 44 24 30 89 D0 F7 64 24 28 89 44 24 10 8B 44 24 30 89 54 24 14 F7 64 24 28 89 44 24 28 8B 44 24 18 89 54 24 2C F7 E1 89 54 24 1C 8B 54 24 10 89 44 24 18 89 54 24 38 8B 54 24 1C 89 D0 31 D2 89 44 24 20 8B 44 24 38 01 44 24 20 8B 44 24 30 89 54 24 24 8B 54 24 3C 11 54 24 24 F7 E1 01 44 24 20 11 54 24 24 8B 4C 24 14 8B 44 24 28 C7 44 24 1C 00 00 00 00 89 CA 31 C9 89 54 24 10 8B 54 24 2C 01 44 24 10 89 4C 24 14 11 54 24 14 8B 54 24 24 89 D0 31 D2 01 44 24 10 11 54 24 14 8B 54 24 20 8B 44 24 18 C7 44 24 18 05 00 00 00 89 D1 31 D2 89 54 24 20 31 D2 01 44 24 20 89 4C 24 24 11 54 24 24 8B 4C 24 14 39 4C 24 1C 0F 82 F6 FD FF FF 77 0E 8B 44 24 10 39 44 24 18 0F 82 E6 FD FF FF 8B 54 24 1C 8B 44 24 18 33 54 24 14 33 44 24 10 09 C2 0F 85 55 FD FF FF 8B 54 24 24 0B 54 24 20 0F 84 47 FD FF FF E9 BB FD FF FF 8B 7C 24 48 83 0D ?? ?? ?? ?? 20 C7 44 24 08 FF FF FF FF 85 FF C7 44 24 0C FF FF FF FF 0F 84 4B FD FF FF E9 56 FD FF FF 90 8B 74 24 48 85 F6 0F 84 44 01 00 00 8B 74 24 08 8B 7C 24 0C 8B 0C DD ?? ?? ?? ?? 8B 14 DD ?? ?? ?? ?? F7 DE 83 D7 00 89 F0 F7 DF 0F AF D6 0F AF CF 01 D1 F7 24 DD ?? ?? ?? ?? 01 CA 89 44 24 08 89 54 24 0C E9 0C FD FF FF 8D B4 26 00 00 00 00 DF 6C 24 08 DD 5C 24 10 8B 54 24 14 89 D0 C1 E8 14 25 FF 07 00 00 2D FE 03 00 00 E9 30 FC FF FF 83 FA 13 0F 8F 38 06 00 00 B8 14 00 00 00 8B 4C 24 0C 29 D0 8B 14 C5 ?? ?? ?? ?? 8B 04 C5 ?? ?? ?? ?? 89 4C 24 18 8B 4C 24 08 C7 44 24 2C 00 00 00 00 89 54 24 10 89 44 24 30 89 D0 F7 64 24 18 89 44 24 20 8B 44 24 30 89 54 24 24 F7 64 24 18 89 44 24 18 8B 44 24 10 89 54 24 1C 8B 54 24 20 89 54 24 28 F7 E1 89 D0 31 D2 89 44 24 10 8B 44 24 28 01 44 24 10 89 54 24 14 8B 54 24 2C 11 54 24 14 8B 54 24 24 89 D0 31 D2 89 44 24 20 8B 44 24 18 01 44 24 20 89 54 24 24 8B 54 24 1C 11 54 24 24 8B 44 24 30 F7 E1 01 44 24 10 B8 05 00 00 00 11 54 24 14 8B 4C 24 14 89 CA 31 C9 01 54 24 20 11 4C 24 24 31 D2 3B 54 24 24 0F 82 51 FC FF FF 3B 44 24 20 0F 87 CE FB FF FF E9 42 FC FF FF 8B 4C 24 0C 8B 44 24 08 0F AF 04 DD ?? ?? ?? ?? 0F AF 0C DD ?? ?? ?? ?? 01 C1 8B 44 24 08 F7 24 DD ?? ?? ?? ?? 01 CA 89 44 24 08 89 54 24 0C E9 D1 FB FF FF 39 C6 0F 87 F4 FC FF FF E9 49 FB FF FF 89 D9 F7 D3 89 5C 24 4C C1 E3 04 F7 D9 8B 93 ?? ?? ?? ?? 8B 83 ?? ?? ?? ?? 89 4C 24 64 8B 4C 24 0C C7 44 24 34 00 00 00 00 89 54 24 28 89 44 24 38 89 D0 F7 E1 89 44 24 20 8B 44 24 38 89 54 24 24 F7 E1 89 44 24 18 8B 44 24 28 89 54 24 1C F7 64 24 08 89 54 24 44 8B 54 24 20 89 44 24 40 89 54 24 30 8B 54 24 44 89 D0 31 D2 89 44 24 10 8B 44 24 30 01 44 24 10 8B 44 24 38 89 54 24 14 8B 54 24 34 11 54 24 14 F7 64 24 08 01 44 24 10 11 54 24 14 8B 54 24 24 89 D0 31 D2 89 44 24 20 8B 44 24 18 01 44 24 20 89 54 24 24 8B 54 24 1C 11 54 24 24 8B 54 24 14 89 D0 31 D2 01 44 24 20 11 54 24 24 8B 93 ?? ?? ?? ?? 8B 9B ?? ?? ?? ?? 89 D0 89 54 24 30 F7 E1 89 5C 24 60 89 44 24 18 89 D8 89 54 24 1C F7 E1 89 44 24 50 8B 44 24 30 89 54 24 54 F7 64 24 08 89 54 24 5C 8B 5C 24 5C 31 D2 89 44 24 58 8B 44 24 18 89 D9 31 DB 01 C1 8B 44 24 60 11 D3 F7 64 24 08 01 C1 11 D3 8B 54 24 1C 89 D0 31 D2 89 44 24 18 8B 44 24 50 01 44 24 18 89 54 24 1C 8B 54 24 54 11 54 24 1C 31 D2 01 5C 24 18 11 54 24 1C 31 C0 31 D2 89 4C 24 54 8B 4C 24 10 89 44 24 50 8B 44 24 58 01 44 24 50 11 54 24 54 31 D2 8B 44 24 40 89 CB 31 C9 89 4C 24 10 01 44 24 10 8B 44 24 18 89 5C 24 14 11 54 24 14 8B 54 24 1C 01 44 24 10 11 54 24 14 8B 4C 24 14 39 CA 72 14 77 08 8B 5C 24 10 39 D8 76 0A 83 44 24 20 01 83 54 24 24 00 8B 44 24 28 31 DB F7 E7 89 44 24 08 8B 44 24 38 89 54 24 0C 8B 4C 24 08 F7 E7 89 44 24 40 8B 44 24 28 89 54 24 44 8B 74 24 44 F7 E5 89 44 24 28 89 D0 89 44 24 18 8B 44 24 38 89 54 24 2C 31 D2 89 54 24 1C F7 E5 01 44 24 18 11 54 24 1C 01 4C 24 18 11 5C 24 1C 8B 5C 24 0C 8B 54 24 1C 89 D9 31 DB 89 5C 24 0C 8B 5C 24 40 89 D0 89 4C 24 08 01 5C 24 08 11 74 24 0C 31 D2 01 44 24 08 8B 44 24 30 11 54 24 0C 31 DB C7 44 24 1C 00 00 00 00 F7 E7 89 44 24 38 8B 44 24 60 89 54 24 3C 8B 74 24 38 F7 E7 31 FF 89 44 24 40 8B 44 24 30 89 54 24 44 F7 E5 89 44 24 30 8B 44 24 60 89 D1 89 54 24 34 F7 E5 8B 6C 24 28 01 C1 8B 44 24 30 11 D3 01 F1 11 FB 8B 7C 24 3C 89 FE 31 FF 03 74 24 40 13 7C 24 44 31 D2 01 DE 89 CB 11 D7 31 C9 31 D2 01 C1 8B 44 24 18 11 D3 89 6C 24 18 89 C2 31 C0 03 44 24 18 13 54 24 1C 01 F0 11 FA 39 D7 72 10 77 04 39 C6 76 0A 83 44 24 08 01 83 54 24 0C 00 8B 74 24 10 8B 7C 24 14 01 CE 11 DF 89 7C 24 14 31 FF 3B 5C 24 14 89 74 24 10 BE 01 00 00 00 77 0C 72 06 3B 4C 24 10 77 04 31 F6 31 FF 8B 4C 24 20 01 F0 8B 5C 24 24 11 FA 01 C1 11 D3 39 DA 89 4C 24 20 89 5C 24 24 0F 87 B9 01 00 00 72 08 39 C8 0F 87 AF 01 00 00 31 DB 39 D7 B9 01 00 00 00 77 0A 72 04 39 C6 77 04 31 C9 31 DB 89 C8 89 DA 03 44 24 08 13 54 24 0C 83 7C 24 64 16 8B 5C 24 4C 0F 8F BF 00 00 00 8B 34 DD ?? ?? ?? ?? 8B 0C 9D ?? ?? ?? ?? 8B 7C 24 24 8B 2C DD ?? ?? ?? ?? 31 DB 89 74 24 08 8B 74 24 20 0F AD FE D3 EF F6 C1 20 0F 45 F7 0F 45 FB BB 40 00 00 00 29 CB 89 D9 31 DB 0F A5 C2 D3 E0 F6 C1 20 0F 45 D0 0F 45 C3 89 C1 89 D3 09 F1 09 FB 83 7C 24 64 03 0F 8F 1B 02 00 00 8B 44 24 4C C1 E0 04 8B 90 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 39 44 24 14 0F 87 E5 00 00 00 72 0A 39 54 24 10 0F 87 D9 00 00 00 33 44 24 14 33 54 24 10 09 D0 0F 84 B0 01 00 00 8B 6C 24 48 89 4C 24 08 89 5C 24 0C 85 ED 0F 84 CA F7 FF FF F7 D9 83 D3 00 F7 DB 89 4C 24 08 89 5C 24 0C E9 B6 F7 FF FF 90 8B 1C 9D ?? ?? ?? ?? 89 C6 89 D7 89 D9 31 DB 83 E9 40 0F AD D6 D3 EF F6 C1 20 0F 45 F7 0F 45 FB 89 FB 8B 7C 24 4C 89 F1 23 04 FD ?? ?? ?? ?? 23 14 FD ?? ?? ?? ?? 09 C2 75 66 8B 6C 24 24 0B 6C 24 20 75 5C 8B 44 24 4C C1 E0 04 8B 90 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 39 44 24 14 77 43 72 06 39 54 24 10 77 3B 33 44 24 14 33 54 24 10 09 D0 0F 85 62 FF FF FF 8B 44 24 4C 8B 54 24 54 C1 E0 04 3B 90 ?? ?? ?? ?? 0F 82 4B FF FF FF 77 12 8B 74 24 50 3B B0 ?? ?? ?? ?? 0F 86 39 FF FF FF 66 90 8B 44 24 48 85 C0 74 06 83 C1 01 83 D3 00 83 0D ?? ?? ?? ?? 20 E9 1D FF FF FF 8D B6 00 00 00 00 B8 01 00 00 00 31 D2 E9 5E FE FF FF 83 FA 14 74 75 83 EA 14 B8 05 00 00 00 8B 0C D5 ?? ?? ?? ?? F7 24 D5 ?? ?? ?? ?? 89 74 24 10 89 7C 24 14 8D 0C 89 01 CA 89 44 24 18 8B 44 24 08 89 54 24 1C 8B 54 24 0C 89 44 24 20 89 54 24 24 E9 DD F8 FF FF 83 FA 14 74 5D 83 EA 14 B8 05 00 00 00 8B 0C D5 ?? ?? ?? ?? F7 24 D5 ?? ?? ?? ?? 89 74 24 20 89 7C 24 24 8D 0C 89 01 CA 39 FA 0F 87 38 F6 FF FF E9 51 FA FF FF 8B 54 24 08 8B 4C 24 0C 89 74 24 10 89 7C 24 14 89 54 24 20 89 4C 24 24 C7 44 24 18 05 00 00 00 C7 44 24 1C 00 00 00 00 E9 7B F8 FF FF 89 74 24 20 B8 05 00 00 00 31 D2 89 7C 24 24 E9 10 FA FF FF 8B 44 24 4C 8B 6C 24 54 C1 E0 04 3B A8 ?? ?? ?? ?? 0F 82 39 FE FF FF 0F 87 FC FE FF FF 8B 54 24 50 3B 90 ?? ?? ?? ?? 0F 86 23 FE FF FF E9 E7 FE FF FF 8B 54 24 20 8B 44 24 24 23 44 24 08 21 EA 09 D0 0F 85 D1 FE FF FF 8B 44 24 4C C1 E0 04 8B 90 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 39 44 24 14 0F 87 B4 FE FF FF 72 0A 39 54 24 10 0F 87 A8 FE FF FF 33 44 24 14 33 54 24 10 09 D0 0F 85 CF FD FF FF 8B 44 24 4C 8B 74 24 54 C1 E0 04 3B B0 ?? ?? ?? ?? 0F 82 B8 FD FF FF 0F 87 7B FE FF FF 8B 7C 24 50 3B B8 ?? ?? ?? ?? 0F 86 A2 FD FF FF E9 66 FE FF FF 8D B6 00 00 00 00 }
	condition:
		$1
}

rule file_15_4_0 {
	meta:
		name = "___bid128_to_int64_ceil"
		size = 3632
		refs = "0122 ___bid_nr_digits 01e4 ___bid_IDEC_glbflags 031e ___bid_ten2k64 0698 ___bid_ten2mk128 09bf ___bid_maskhigh128 09c6 ___bid_shiftright128 0a21 ___bid_ten2mk128trunc"
	strings:
		$1 = { 81 EC 9C 00 00 00 8B 84 24 A0 00 00 00 8B 8C 24 AC 00 00 00 89 B4 24 90 00 00 00 89 9C 24 8C 00 00 00 89 44 24 70 8B 84 24 A4 00 00 00 8B 5C 24 70 89 AC 24 98 00 00 00 8B AC 24 A8 00 00 00 89 BC 24 94 00 00 00 89 44 24 74 8B 74 24 74 89 C8 25 00 00 00 78 89 1C 24 89 74 24 04 89 CE 81 E6 00 00 00 80 3D 00 00 00 78 89 74 24 1C 0F 84 5D 01 00 00 89 CF 89 EE 81 E7 FF FF 01 00 81 FF 09 ED 01 00 76 3B C7 44 24 08 00 00 00 00 C7 44 24 0C 00 00 00 00 8B 44 24 08 8B 54 24 0C 8B 9C 24 8C 00 00 00 8B B4 24 90 00 00 00 8B BC 24 94 00 00 00 8B AC 24 98 00 00 00 81 C4 9C 00 00 00 C3 0F 83 3A 01 00 00 89 FA 89 F0 81 F2 09 ED 01 00 35 C0 87 AD BE 09 C2 0F 84 93 01 00 00 89 C8 25 00 00 00 60 3D 00 00 00 60 74 9A 89 F8 09 F0 0F 84 1C 01 00 00 89 74 24 68 89 7C 24 6C DF 6C 24 68 DD 5C 24 08 8B 54 24 0C 89 D0 C1 E8 14 25 FF 07 00 00 2D BE 03 00 00 83 E8 01 89 C3 C1 E3 05 8B 93 ?? ?? ?? ?? 89 44 24 10 85 D2 75 34 8B 83 ?? ?? ?? ?? 8B 93 ?? ?? ?? ?? 8B 9B ?? ?? ?? ?? 89 44 24 08 39 DF 0F 87 A4 01 00 00 0F 83 14 05 00 00 8B 44 24 08 31 FB 31 F0 09 C3 0F 84 61 01 00 00 81 E1 00 00 FE 7F C1 E9 11 81 E9 20 18 00 00 89 C8 01 D0 83 F8 13 89 4C 24 38 7F 64 0F 84 74 01 00 00 85 C0 0F 8E C9 02 00 00 83 7C 24 38 00 0F 8C DC 04 00 00 0F 85 D4 02 00 00 8B 7C 24 1C 8B 0C 24 8B 5C 24 04 85 FF 89 4C 24 08 89 5C 24 0C 0F 84 DD FE FF FF F7 D9 83 D3 00 F7 DB 89 4C 24 08 89 5C 24 0C E9 C9 FE FF FF 8D 74 26 00 89 C8 25 00 00 00 7C 3D 00 00 00 7C 0F 84 C5 00 00 00 83 0D ?? ?? ?? ?? 01 C7 44 24 08 00 00 00 00 C7 44 24 0C 00 00 00 80 E9 97 FE FF FF 66 90 81 FD C0 87 AD BE 0F 87 79 FE FF FF E9 B5 FE FF FF 8B 54 24 04 0B 14 24 C7 44 24 08 00 00 00 00 C7 44 24 0C 00 00 00 00 0F 84 67 FE FF FF 81 7C 24 04 FF FF 1F 00 0F 86 84 02 00 00 8B 54 24 04 89 D0 31 D2 89 44 24 68 89 54 24 6C DF 6C 24 68 DD 5C 24 08 8B 54 24 0C 89 D0 C1 E8 14 25 FF 07 00 00 2D DE 03 00 00 E9 AC FE FF FF 8D 74 26 00 81 7C 24 04 63 8E 8D 37 C7 44 24 08 00 00 00 00 C7 44 24 0C 00 00 00 00 0F 87 07 FE FF FF 89 CB 81 E3 00 00 00 60 81 FB 00 00 00 60 0F 85 53 FE FF FF E9 EE FD FF FF 83 0D ?? ?? ?? ?? 01 C7 44 24 08 00 00 00 00 C7 44 24 0C 00 00 00 80 E9 D2 FD FF FF 8B 44 24 10 8B 5C 24 04 C1 E0 05 05 ?? ?? ?? ?? 39 58 14 0F 87 86 FE FF FF 72 12 8B 1C 24 39 58 10 0F 87 78 FE FF FF 8D B6 00 00 00 00 83 C2 01 E9 6A FE FF FF 8B 44 24 1C 85 C0 0F 84 DC 01 00 00 83 FA 13 0F 8F 2F 08 00 00 B8 14 00 00 00 8B 5C 24 04 29 D0 8B 0C 24 8B 14 C5 ?? ?? ?? ?? 8B 04 C5 ?? ?? ?? ?? C7 44 24 44 00 00 00 00 89 54 24 08 89 44 24 30 89 D0 F7 E3 89 44 24 28 8B 44 24 30 89 54 24 2C F7 E3 8B 5C 24 2C 89 44 24 10 8B 44 24 08 89 54 24 14 F7 E1 89 54 24 0C 8B 54 24 28 89 44 24 08 89 54 24 40 8B 54 24 0C 89 D0 31 D2 89 44 24 20 8B 44 24 40 01 44 24 20 8B 44 24 30 89 54 24 24 8B 54 24 44 11 54 24 24 F7 E1 89 D9 01 44 24 20 11 54 24 24 31 DB 8B 54 24 24 03 4C 24 10 13 5C 24 14 89 D0 31 D2 01 C1 8B 44 24 20 11 D3 89 C2 31 C0 89 44 24 20 89 54 24 24 8B 54 24 08 C7 44 24 14 00 00 00 00 C7 44 24 08 05 00 00 00 C7 44 24 0C 00 00 00 00 89 54 24 10 8B 44 24 10 8B 54 24 14 01 44 24 20 11 54 24 24 C7 44 24 10 0A 00 00 00 C7 44 24 14 00 00 00 00 39 5C 24 0C 0F 82 D5 FD FF FF 77 0A 39 4C 24 08 0F 82 C9 FD FF FF 8B 54 24 0C 8B 44 24 08 31 DA 31 C8 09 C2 0F 85 5F FD FF FF 8B 5C 24 24 39 5C 24 14 0F 87 51 FD FF FF 0F 82 A1 FD FF FF 8B 44 24 20 39 44 24 10 0F 87 3D FD FF FF 90 E9 8D FD FF FF 8B 7C 24 1C 31 D2 C7 44 24 0C 00 00 00 00 85 FF 0F 94 C2 89 54 24 08 E9 24 FC FF FF 8B 74 24 1C 85 F6 0F 84 B3 01 00 00 8B 5C 24 38 8B 34 24 8B 7C 24 04 8B 0C DD ?? ?? ?? ?? 8B 14 DD ?? ?? ?? ?? F7 DE 83 D7 00 89 F0 F7 DF 0F AF CF 0F AF D6 01 D1 F7 24 DD ?? ?? ?? ?? 01 CA 89 44 24 08 89 54 24 0C E9 D8 FB FF FF 8D 76 00 DF 2C 24 DD 5C 24 08 8B 54 24 0C 89 D0 C1 E8 14 25 FF 07 00 00 2D FE 03 00 00 E9 39 FC FF FF 90 83 FA 13 0F 8F 2C 07 00 00 B8 14 00 00 00 8B 5C 24 04 29 D0 8B 0C 24 8B 14 C5 ?? ?? ?? ?? 8B 04 C5 ?? ?? ?? ?? C7 44 24 44 00 00 00 00 89 54 24 08 89 44 24 30 89 D0 F7 E3 89 44 24 28 8B 44 24 30 89 54 24 2C F7 E3 8B 5C 24 2C 89 44 24 10 8B 44 24 08 89 54 24 14 F7 E1 89 54 24 0C 8B 54 24 28 89 44 24 08 89 54 24 40 8B 54 24 0C 89 D0 31 D2 89 44 24 20 8B 44 24 40 01 44 24 20 8B 44 24 30 89 54 24 24 8B 54 24 44 11 54 24 24 F7 E1 89 D9 01 44 24 20 11 54 24 24 31 DB 8B 54 24 24 03 4C 24 10 13 5C 24 14 89 D0 31 D2 01 C1 8B 44 24 20 11 D3 89 C2 31 C0 89 44 24 20 89 54 24 24 8B 54 24 08 C7 44 24 14 00 00 00 00 C7 44 24 08 04 00 00 00 C7 44 24 0C 00 00 00 00 89 54 24 10 8B 44 24 10 8B 54 24 14 01 44 24 20 11 54 24 24 C7 44 24 10 F6 FF FF FF C7 44 24 14 FF FF FF FF 39 5C 24 0C 0F 82 F9 FB FF FF 77 0A 39 4C 24 08 0F 82 ED FB FF FF 8B 54 24 0C 8B 44 24 08 31 DA 31 C8 09 C2 0F 85 83 FB FF FF 8B 5C 24 24 39 5C 24 14 0F 87 75 FB FF FF 0F 82 C5 FB FF FF 8B 44 24 20 39 44 24 10 0F 83 61 FB FF FF E9 B2 FB FF FF 8B 5C 24 38 8B 4C 24 04 8B 04 24 0F AF 04 DD ?? ?? ?? ?? 0F AF 0C DD ?? ?? ?? ?? 01 C1 8B 04 24 F7 24 DD ?? ?? ?? ?? 01 CA 89 44 24 08 89 54 24 0C E9 2F FA FF FF 39 C6 0F 87 82 FC FF FF E9 DF FA FF FF 8B 5C 24 38 8B 4C 24 04 C7 44 24 34 00 00 00 00 F7 DB 89 5C 24 64 8B 5C 24 38 F7 D3 89 5C 24 48 C1 E3 04 8B 83 ?? ?? ?? ?? 8B 93 ?? ?? ?? ?? 89 44 24 28 89 54 24 38 F7 E1 89 44 24 20 8B 44 24 38 89 54 24 24 F7 E1 89 44 24 10 8B 44 24 28 89 54 24 14 F7 24 24 89 54 24 44 8B 54 24 20 89 44 24 40 89 54 24 30 8B 54 24 44 89 D0 31 D2 89 44 24 08 8B 44 24 30 01 44 24 08 8B 44 24 38 89 54 24 0C 8B 54 24 34 11 54 24 0C F7 24 24 01 44 24 08 11 54 24 0C 8B 54 24 24 89 D0 31 D2 89 44 24 20 8B 44 24 10 01 44 24 20 89 54 24 24 8B 54 24 14 11 54 24 24 8B 54 24 0C 89 D0 31 D2 01 44 24 20 11 54 24 24 8B 93 ?? ?? ?? ?? 8B 9B ?? ?? ?? ?? 89 D0 89 54 24 30 F7 E1 89 5C 24 60 89 44 24 10 89 D8 89 54 24 14 F7 E1 89 44 24 50 8B 44 24 30 89 54 24 54 F7 24 24 89 54 24 5C 8B 5C 24 5C 31 D2 89 44 24 58 8B 44 24 10 89 D9 31 DB 01 C1 8B 44 24 60 11 D3 F7 24 24 01 C1 11 D3 8B 54 24 14 89 D0 31 D2 89 44 24 10 8B 44 24 50 01 44 24 10 89 54 24 14 8B 54 24 54 11 54 24 14 31 D2 01 5C 24 10 11 54 24 14 31 C0 31 D2 89 4C 24 54 8B 4C 24 08 89 44 24 50 8B 44 24 58 01 44 24 50 11 54 24 54 31 D2 8B 44 24 40 89 CB 31 C9 89 4C 24 08 01 44 24 08 8B 44 24 10 89 5C 24 0C 11 54 24 0C 8B 54 24 14 01 44 24 08 11 54 24 0C 8B 4C 24 0C 39 CA 72 14 77 08 8B 5C 24 08 39 D8 76 0A 83 44 24 20 01 83 54 24 24 00 8B 44 24 28 31 DB F7 E7 89 04 24 8B 44 24 38 89 54 24 04 8B 0C 24 F7 E7 89 44 24 40 8B 44 24 28 89 54 24 44 F7 E5 89 44 24 28 89 D0 89 44 24 10 8B 44 24 38 89 54 24 2C 31 D2 89 54 24 14 F7 E5 01 44 24 10 11 54 24 14 01 4C 24 10 11 5C 24 14 8B 5C 24 04 8B 54 24 14 89 D9 31 DB 89 0C 24 8B 4C 24 40 89 D0 01 0C 24 89 5C 24 04 8B 5C 24 44 11 5C 24 04 31 D2 01 04 24 8B 44 24 30 11 54 24 04 31 DB C7 44 24 14 00 00 00 00 F7 E7 89 44 24 38 8B 44 24 60 89 54 24 3C 8B 74 24 38 F7 E7 31 FF 89 44 24 40 8B 44 24 30 89 54 24 44 F7 E5 89 44 24 30 8B 44 24 60 89 D1 89 54 24 34 F7 E5 8B 6C 24 28 01 C1 8B 44 24 30 11 D3 01 F1 11 FB 8B 7C 24 3C 89 FE 31 FF 03 74 24 40 13 7C 24 44 31 D2 01 DE 89 CB 11 D7 31 C9 31 D2 01 C1 8B 44 24 10 11 D3 89 6C 24 10 89 C2 31 C0 03 44 24 10 13 54 24 14 01 F0 11 FA 39 D7 72 0F 77 04 39 C6 76 09 83 04 24 01 83 54 24 04 00 8B 74 24 08 8B 7C 24 0C 01 CE 11 DF 89 7C 24 0C 31 FF 3B 5C 24 0C 89 74 24 08 BE 01 00 00 00 77 0C 72 06 3B 4C 24 08 77 04 31 F6 31 FF 8B 4C 24 20 01 F0 8B 5C 24 24 11 FA 01 C1 11 D3 39 DA 89 4C 24 20 89 5C 24 24 0F 87 AD 01 00 00 72 08 39 C8 0F 87 A3 01 00 00 31 DB 39 D7 B9 01 00 00 00 77 0A 72 04 39 C6 77 04 31 C9 31 DB 89 C8 89 DA 03 04 24 13 54 24 04 83 7C 24 64 16 8B 5C 24 48 0F 8F B9 00 00 00 8B 34 DD ?? ?? ?? ?? 8B 0C 9D ?? ?? ?? ?? 8B 7C 24 24 8B 2C DD ?? ?? ?? ?? 31 DB 89 34 24 8B 74 24 20 0F AD FE D3 EF F6 C1 20 0F 45 F7 0F 45 FB BB 40 00 00 00 29 CB 89 D9 31 DB 0F A5 C2 D3 E0 F6 C1 20 0F 45 D0 0F 45 C3 89 C1 89 D3 09 F1 09 FB 83 7C 24 64 03 0F 8F 90 03 00 00 8B 44 24 48 C1 E0 04 8B 90 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 39 44 24 0C 0F 87 DE 00 00 00 72 0A 39 54 24 08 0F 87 D2 00 00 00 33 44 24 0C 33 54 24 08 09 D0 0F 84 25 03 00 00 8B 6C 24 1C 85 ED 0F 84 62 F7 FF FF 89 CF 89 DD F7 DF 83 D5 00 F7 DD 89 7C 24 08 89 6C 24 0C E9 20 F6 FF FF 8B 1C 9D ?? ?? ?? ?? 89 C6 89 D7 89 D9 31 DB 83 E9 40 0F AD D6 D3 EF F6 C1 20 0F 45 F7 0F 45 FB 89 FB 8B 7C 24 48 89 F1 23 04 FD ?? ?? ?? ?? 23 14 FD ?? ?? ?? ?? 09 C2 75 64 8B 6C 24 24 0B 6C 24 20 75 5A 8B 44 24 48 C1 E0 04 8B 90 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 39 44 24 0C 77 41 72 06 39 54 24 08 77 39 33 44 24 0C 33 54 24 08 09 D0 0F 85 67 FF FF FF 8B 44 24 48 8B 54 24 54 C1 E0 04 3B 90 ?? ?? ?? ?? 0F 82 50 FF FF FF 77 10 8B 74 24 50 3B B0 ?? ?? ?? ?? 0F 86 3E FF FF FF 8B 44 24 1C 85 C0 0F 85 3E FF FF FF 83 C1 01 83 D3 00 E9 95 F6 FF FF 8D B6 00 00 00 00 B8 01 00 00 00 31 D2 E9 6A FE FF FF 83 FA 14 0F 84 C1 01 00 00 83 EA 14 BB 0A 00 00 00 8B 0C D5 ?? ?? ?? ?? 89 D8 C7 44 24 14 00 00 00 00 89 4C 24 30 8B 0C D5 ?? ?? ?? ?? F7 E1 8D 0C 89 89 44 24 08 8B 44 24 30 89 54 24 0C F7 E3 89 54 24 2C 8B 54 24 08 89 44 24 28 89 54 24 10 8B 54 24 2C 89 D0 31 D2 89 44 24 20 8B 44 24 10 01 44 24 20 8B 44 24 20 89 54 24 24 8B 54 24 14 11 54 24 24 89 C2 31 C0 89 44 24 10 8B 44 24 28 89 54 24 14 31 D2 01 44 24 10 11 54 24 14 8B 54 24 0C 89 D0 31 D2 89 44 24 08 B8 05 00 00 00 89 54 24 0C F7 64 24 30 01 CA 01 44 24 08 11 54 24 0C 8B 54 24 24 8B 0C 24 8B 5C 24 04 89 D0 31 D2 01 44 24 08 11 54 24 0C 89 4C 24 20 89 F1 89 5C 24 24 89 FB E9 EE F7 FF FF 83 FA 14 0F 84 20 01 00 00 8B 1C D5 ?? ?? ?? ?? 8B 0C D5 ?? ?? ?? ?? 89 5C 24 2C 8B 5C 24 2C 89 4C 24 10 89 4C 24 28 B9 F6 FF FF FF 89 C8 F7 E3 89 44 24 30 B8 FF FF FF FF 89 54 24 34 F7 E3 89 44 24 08 8B 44 24 10 89 54 24 0C F7 E1 89 54 24 4C 8B 5C 24 4C 31 D2 89 44 24 48 8B 44 24 30 89 D9 31 DB 89 4C 24 20 01 44 24 20 B8 FF FF FF FF 89 5C 24 24 11 54 24 24 F7 64 24 10 01 44 24 20 8B 4C 24 20 11 54 24 24 31 D2 8B 44 24 48 89 CB 31 C9 89 4C 24 10 01 44 24 10 89 5C 24 14 11 54 24 14 8B 44 24 28 8B 54 24 2C 8B 0C 24 8B 5C 24 04 0F A4 C2 02 C1 E0 02 01 44 24 08 11 54 24 0C 8B 54 24 34 89 4C 24 20 89 F1 89 D0 31 D2 01 44 24 08 11 54 24 0C 8B 54 24 24 89 5C 24 24 89 FB 89 D0 31 D2 01 44 24 08 11 54 24 0C E9 D9 F8 FF FF 8B 0C 24 8B 5C 24 04 C7 44 24 10 0A 00 00 00 C7 44 24 14 00 00 00 00 89 4C 24 20 89 F1 89 5C 24 24 89 FB C7 44 24 08 05 00 00 00 C7 44 24 0C 00 00 00 00 E9 C5 F6 FF FF 8B 0C 24 8B 5C 24 04 C7 44 24 10 F6 FF FF FF C7 44 24 14 FF FF FF FF 89 4C 24 20 89 F1 89 5C 24 24 89 FB C7 44 24 08 04 00 00 00 C7 44 24 0C 00 00 00 00 E9 69 F8 FF FF 8B 44 24 48 8B 6C 24 54 C1 E0 04 3B A8 ?? ?? ?? ?? 0F 82 C4 FC FF FF 0F 87 80 FD FF FF 8B 54 24 50 3B 90 ?? ?? ?? ?? 0F 86 AE FC FF FF E9 6B FD FF FF 8B 44 24 24 23 6C 24 20 23 04 24 09 E8 0F 85 58 FD FF FF 8B 44 24 48 C1 E0 04 8B 90 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 39 44 24 0C 0F 87 3B FD FF FF 72 0A 39 54 24 08 0F 87 2F FD FF FF 33 44 24 0C 33 54 24 08 09 D0 0F 85 5D FC FF FF 8B 44 24 48 8B 74 24 54 C1 E0 04 3B B0 ?? ?? ?? ?? 0F 82 46 FC FF FF 0F 87 02 FD FF FF 8B 7C 24 50 3B B8 ?? ?? ?? ?? 0F 86 30 FC FF FF E9 ED FC FF FF 8D 76 00 8D BC 27 00 00 00 00 }
	condition:
		$1
}

rule file_15_5_0 {
	meta:
		name = "___bid128_to_int64_xceil"
		size = 3648
		refs = "0122 ___bid_nr_digits 01e4 ___bid_IDEC_glbflags 031e ___bid_ten2k64 06a5 ___bid_ten2mk128 09cc ___bid_maskhigh128 09d3 ___bid_shiftright128 0a2e ___bid_ten2mk128trunc"
	strings:
		$1 = { 81 EC 9C 00 00 00 8B 84 24 A0 00 00 00 8B 8C 24 AC 00 00 00 89 B4 24 90 00 00 00 89 9C 24 8C 00 00 00 89 44 24 70 8B 84 24 A4 00 00 00 8B 5C 24 70 89 AC 24 98 00 00 00 8B AC 24 A8 00 00 00 89 BC 24 94 00 00 00 89 44 24 74 8B 74 24 74 89 C8 25 00 00 00 78 89 1C 24 89 74 24 04 89 CE 81 E6 00 00 00 80 3D 00 00 00 78 89 74 24 1C 0F 84 5D 01 00 00 89 CF 89 EE 81 E7 FF FF 01 00 81 FF 09 ED 01 00 76 3B C7 44 24 08 00 00 00 00 C7 44 24 0C 00 00 00 00 8B 44 24 08 8B 54 24 0C 8B 9C 24 8C 00 00 00 8B B4 24 90 00 00 00 8B BC 24 94 00 00 00 8B AC 24 98 00 00 00 81 C4 9C 00 00 00 C3 0F 83 3A 01 00 00 89 FA 89 F0 81 F2 09 ED 01 00 35 C0 87 AD BE 09 C2 0F 84 93 01 00 00 89 C8 25 00 00 00 60 3D 00 00 00 60 74 9A 89 F8 09 F0 0F 84 1C 01 00 00 89 74 24 68 89 7C 24 6C DF 6C 24 68 DD 5C 24 08 8B 54 24 0C 89 D0 C1 E8 14 25 FF 07 00 00 2D BE 03 00 00 83 E8 01 89 C3 C1 E3 05 8B 93 ?? ?? ?? ?? 89 44 24 10 85 D2 75 34 8B 83 ?? ?? ?? ?? 8B 93 ?? ?? ?? ?? 8B 9B ?? ?? ?? ?? 89 44 24 08 39 DF 0F 87 A4 01 00 00 0F 83 1E 05 00 00 8B 44 24 08 31 FB 31 F0 09 C3 0F 84 61 01 00 00 81 E1 00 00 FE 7F C1 E9 11 81 E9 20 18 00 00 89 C8 01 D0 83 F8 13 89 4C 24 38 7F 64 0F 84 74 01 00 00 85 C0 0F 8E C9 02 00 00 83 7C 24 38 00 0F 8C E9 04 00 00 0F 85 DB 02 00 00 8B 44 24 1C 8B 3C 24 8B 6C 24 04 85 C0 89 7C 24 08 89 6C 24 0C 0F 84 DD FE FF FF F7 DF 83 D5 00 F7 DD 89 7C 24 08 89 6C 24 0C E9 C9 FE FF FF 8D 74 26 00 89 C8 25 00 00 00 7C 3D 00 00 00 7C 0F 84 C5 00 00 00 83 0D ?? ?? ?? ?? 01 C7 44 24 08 00 00 00 00 C7 44 24 0C 00 00 00 80 E9 97 FE FF FF 66 90 81 FD C0 87 AD BE 0F 87 79 FE FF FF E9 B5 FE FF FF 8B 54 24 04 0B 14 24 C7 44 24 08 00 00 00 00 C7 44 24 0C 00 00 00 00 0F 84 67 FE FF FF 81 7C 24 04 FF FF 1F 00 0F 86 88 02 00 00 8B 54 24 04 89 D0 31 D2 89 44 24 68 89 54 24 6C DF 6C 24 68 DD 5C 24 08 8B 54 24 0C 89 D0 C1 E8 14 25 FF 07 00 00 2D DE 03 00 00 E9 AC FE FF FF 8D 74 26 00 81 7C 24 04 63 8E 8D 37 C7 44 24 08 00 00 00 00 C7 44 24 0C 00 00 00 00 0F 87 07 FE FF FF 89 CB 81 E3 00 00 00 60 81 FB 00 00 00 60 0F 85 53 FE FF FF E9 EE FD FF FF 83 0D ?? ?? ?? ?? 01 C7 44 24 08 00 00 00 00 C7 44 24 0C 00 00 00 80 E9 D2 FD FF FF 8B 44 24 10 8B 5C 24 04 C1 E0 05 05 ?? ?? ?? ?? 39 58 14 0F 87 86 FE FF FF 72 12 8B 1C 24 39 58 10 0F 87 78 FE FF FF 8D B6 00 00 00 00 83 C2 01 E9 6A FE FF FF 8B 44 24 1C 85 C0 0F 84 DF 01 00 00 83 FA 13 0F 8F 3F 08 00 00 B8 14 00 00 00 8B 5C 24 04 29 D0 8B 0C 24 8B 14 C5 ?? ?? ?? ?? 8B 04 C5 ?? ?? ?? ?? C7 44 24 44 00 00 00 00 89 54 24 08 89 44 24 30 89 D0 F7 E3 89 44 24 28 8B 44 24 30 89 54 24 2C F7 E3 8B 5C 24 2C 89 44 24 10 8B 44 24 08 89 54 24 14 F7 E1 89 54 24 0C 8B 54 24 28 89 44 24 08 89 54 24 40 8B 54 24 0C 89 D0 31 D2 89 44 24 20 8B 44 24 40 01 44 24 20 8B 44 24 30 89 54 24 24 8B 54 24 44 11 54 24 24 F7 E1 89 D9 01 44 24 20 11 54 24 24 31 DB 8B 54 24 24 03 4C 24 10 13 5C 24 14 89 D0 31 D2 01 C1 8B 44 24 20 11 D3 89 C2 31 C0 89 44 24 20 89 54 24 24 8B 54 24 08 C7 44 24 14 00 00 00 00 C7 44 24 08 05 00 00 00 C7 44 24 0C 00 00 00 00 89 54 24 10 8B 44 24 10 8B 54 24 14 01 44 24 20 11 54 24 24 C7 44 24 10 0A 00 00 00 C7 44 24 14 00 00 00 00 39 5C 24 0C 0F 82 D5 FD FF FF 77 0A 39 4C 24 08 0F 82 C9 FD FF FF 8B 54 24 0C 8B 44 24 08 31 DA 31 C8 09 C2 0F 85 5F FD FF FF 8B 5C 24 24 39 5C 24 14 0F 87 51 FD FF FF 0F 82 A1 FD FF FF 8B 44 24 20 39 44 24 10 0F 87 3D FD FF FF 90 E9 8D FD FF FF 8B 7C 24 1C 31 D2 83 0D ?? ?? ?? ?? 20 C7 44 24 0C 00 00 00 00 85 FF 0F 94 C2 89 54 24 08 E9 1D FC FF FF 8B 74 24 1C 85 F6 0F 84 B1 01 00 00 8B 6C 24 38 8B 34 24 8B 7C 24 04 8B 0C ED ?? ?? ?? ?? 8B 14 ED ?? ?? ?? ?? F7 DE 83 D7 00 89 F0 F7 DF 0F AF CF 0F AF D6 01 D1 F7 24 ED ?? ?? ?? ?? 01 CA 89 44 24 08 89 54 24 0C E9 D1 FB FF FF DF 2C 24 DD 5C 24 08 8B 54 24 0C 89 D0 C1 E8 14 25 FF 07 00 00 2D FE 03 00 00 E9 35 FC FF FF 83 FA 13 0F 8F 39 07 00 00 B8 14 00 00 00 8B 5C 24 04 29 D0 8B 0C 24 8B 14 C5 ?? ?? ?? ?? 8B 04 C5 ?? ?? ?? ?? C7 44 24 44 00 00 00 00 89 54 24 08 89 44 24 30 89 D0 F7 E3 89 44 24 28 8B 44 24 30 89 54 24 2C F7 E3 8B 5C 24 2C 89 44 24 10 8B 44 24 08 89 54 24 14 F7 E1 89 54 24 0C 8B 54 24 28 89 44 24 08 89 54 24 40 8B 54 24 0C 89 D0 31 D2 89 44 24 20 8B 44 24 40 01 44 24 20 8B 44 24 30 89 54 24 24 8B 54 24 44 11 54 24 24 F7 E1 89 D9 01 44 24 20 11 54 24 24 31 DB 8B 54 24 24 03 4C 24 10 13 5C 24 14 89 D0 31 D2 01 C1 8B 44 24 20 11 D3 89 C2 31 C0 89 44 24 20 89 54 24 24 8B 54 24 08 C7 44 24 14 00 00 00 00 C7 44 24 08 04 00 00 00 C7 44 24 0C 00 00 00 00 89 54 24 10 8B 44 24 10 8B 54 24 14 01 44 24 20 11 54 24 24 C7 44 24 10 F6 FF FF FF C7 44 24 14 FF FF FF FF 39 5C 24 0C 0F 82 F6 FB FF FF 77 0A 39 4C 24 08 0F 82 EA FB FF FF 8B 54 24 0C 8B 44 24 08 31 DA 31 C8 09 C2 0F 85 80 FB FF FF 8B 5C 24 24 39 5C 24 14 0F 87 72 FB FF FF 0F 82 C2 FB FF FF 8B 44 24 20 39 44 24 10 0F 83 5E FB FF FF 66 90 E9 AD FB FF FF 8B 5C 24 38 8B 4C 24 04 8B 04 24 0F AF 04 DD ?? ?? ?? ?? 0F AF 0C DD ?? ?? ?? ?? 01 C1 8B 04 24 F7 24 DD ?? ?? ?? ?? 01 CA 89 44 24 08 89 54 24 0C E9 2A FA FF FF 90 8D 74 26 00 39 C6 0F 87 78 FC FF FF E9 D5 FA FF FF 8D 76 00 8B 5C 24 38 8B 4C 24 04 C7 44 24 34 00 00 00 00 F7 DB 89 5C 24 64 8B 5C 24 38 F7 D3 89 5C 24 48 C1 E3 04 8B 83 ?? ?? ?? ?? 8B 93 ?? ?? ?? ?? 89 44 24 28 89 54 24 38 F7 E1 89 44 24 20 8B 44 24 38 89 54 24 24 F7 E1 89 44 24 10 8B 44 24 28 89 54 24 14 F7 24 24 89 54 24 44 8B 54 24 20 89 44 24 40 89 54 24 30 8B 54 24 44 89 D0 31 D2 89 44 24 08 8B 44 24 30 01 44 24 08 8B 44 24 38 89 54 24 0C 8B 54 24 34 11 54 24 0C F7 24 24 01 44 24 08 11 54 24 0C 8B 54 24 24 89 D0 31 D2 89 44 24 20 8B 44 24 10 01 44 24 20 89 54 24 24 8B 54 24 14 11 54 24 24 8B 54 24 0C 89 D0 31 D2 01 44 24 20 11 54 24 24 8B 93 ?? ?? ?? ?? 8B 9B ?? ?? ?? ?? 89 D0 89 54 24 30 F7 E1 89 5C 24 60 89 44 24 10 89 D8 89 54 24 14 F7 E1 89 44 24 50 8B 44 24 30 89 54 24 54 F7 24 24 89 54 24 5C 8B 5C 24 5C 31 D2 89 44 24 58 8B 44 24 10 89 D9 31 DB 01 C1 8B 44 24 60 11 D3 F7 24 24 01 C1 11 D3 8B 54 24 14 89 D0 31 D2 89 44 24 10 8B 44 24 50 01 44 24 10 89 54 24 14 8B 54 24 54 11 54 24 14 31 D2 01 5C 24 10 11 54 24 14 31 C0 31 D2 89 4C 24 54 8B 4C 24 08 89 44 24 50 8B 44 24 58 01 44 24 50 11 54 24 54 31 D2 8B 44 24 40 89 CB 31 C9 89 4C 24 08 01 44 24 08 8B 44 24 10 89 5C 24 0C 11 54 24 0C 8B 54 24 14 01 44 24 08 11 54 24 0C 8B 4C 24 0C 39 CA 72 14 77 08 8B 5C 24 08 39 D8 76 0A 83 44 24 20 01 83 54 24 24 00 8B 44 24 28 31 DB F7 E7 89 04 24 8B 44 24 38 89 54 24 04 8B 0C 24 F7 E7 89 44 24 40 8B 44 24 28 89 54 24 44 F7 E5 89 44 24 28 89 D0 89 44 24 10 8B 44 24 38 89 54 24 2C 31 D2 89 54 24 14 F7 E5 01 44 24 10 11 54 24 14 01 4C 24 10 11 5C 24 14 8B 5C 24 04 8B 54 24 14 89 D9 31 DB 89 0C 24 8B 4C 24 40 89 D0 01 0C 24 89 5C 24 04 8B 5C 24 44 11 5C 24 04 31 D2 01 04 24 8B 44 24 30 11 54 24 04 31 DB C7 44 24 14 00 00 00 00 F7 E7 89 44 24 38 8B 44 24 60 89 54 24 3C 8B 74 24 38 F7 E7 31 FF 89 44 24 40 8B 44 24 30 89 54 24 44 F7 E5 89 44 24 30 8B 44 24 60 89 D1 89 54 24 34 F7 E5 8B 6C 24 28 01 C1 8B 44 24 30 11 D3 01 F1 11 FB 8B 7C 24 3C 89 FE 31 FF 03 74 24 40 13 7C 24 44 31 D2 01 DE 89 CB 11 D7 31 C9 31 D2 01 C1 8B 44 24 10 11 D3 89 6C 24 10 89 C2 31 C0 03 44 24 10 13 54 24 14 01 F0 11 FA 39 D7 72 0F 77 04 39 C6 76 09 83 04 24 01 83 54 24 04 00 8B 74 24 08 8B 7C 24 0C 01 CE 11 DF 89 7C 24 0C 31 FF 3B 5C 24 0C 89 74 24 08 BE 01 00 00 00 77 0C 72 06 3B 4C 24 08 77 04 31 F6 31 FF 8B 4C 24 20 01 F0 8B 5C 24 24 11 FA 01 C1 11 D3 39 DA 89 4C 24 20 89 5C 24 24 0F 87 B0 01 00 00 72 08 39 C8 0F 87 A6 01 00 00 31 DB 39 D7 B9 01 00 00 00 77 0A 72 04 39 C6 77 04 31 C9 31 DB 89 C8 89 DA 03 04 24 13 54 24 04 83 7C 24 64 16 8B 5C 24 48 0F 8F BF 00 00 00 8B 34 DD ?? ?? ?? ?? 8B 0C 9D ?? ?? ?? ?? 8B 7C 24 24 8B 2C DD ?? ?? ?? ?? 31 DB 89 34 24 8B 74 24 20 0F AD FE D3 EF F6 C1 20 0F 45 F7 0F 45 FB BB 40 00 00 00 29 CB 89 D9 31 DB 0F A5 C2 D3 E0 F6 C1 20 0F 45 D0 0F 45 C3 89 C1 89 D3 09 F1 09 FB 83 7C 24 64 03 0F 8F 93 03 00 00 8B 44 24 48 C1 E0 04 8B 90 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 39 44 24 0C 0F 87 E4 00 00 00 72 0A 39 54 24 08 0F 87 D8 00 00 00 33 44 24 0C 33 54 24 08 09 D0 0F 84 28 03 00 00 66 90 8B 44 24 1C 89 4C 24 08 89 5C 24 0C 85 C0 0F 84 21 F6 FF FF F7 D9 83 D3 00 F7 DB 89 4C 24 08 89 5C 24 0C E9 0D F6 FF FF 8B 1C 9D ?? ?? ?? ?? 89 C6 89 D7 89 D9 31 DB 83 E9 40 0F AD D6 D3 EF F6 C1 20 0F 45 F7 0F 45 FB 89 FB 8B 7C 24 48 89 F1 23 04 FD ?? ?? ?? ?? 23 14 FD ?? ?? ?? ?? 09 C2 75 64 8B 6C 24 24 0B 6C 24 20 75 5A 8B 44 24 48 C1 E0 04 8B 90 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 39 44 24 0C 77 41 72 06 39 54 24 08 77 39 33 44 24 0C 33 54 24 08 09 D0 0F 85 63 FF FF FF 8B 44 24 48 8B 54 24 54 C1 E0 04 3B 90 ?? ?? ?? ?? 0F 82 4C FF FF FF 77 10 8B 74 24 50 3B B0 ?? ?? ?? ?? 0F 86 3A FF FF FF 8B 44 24 1C 85 C0 75 06 83 C1 01 83 D3 00 83 0D ?? ?? ?? ?? 20 E9 20 FF FF FF B8 01 00 00 00 31 D2 E9 67 FE FF FF 83 FA 14 0F 84 C1 01 00 00 83 EA 14 BB 0A 00 00 00 8B 0C D5 ?? ?? ?? ?? 89 D8 C7 44 24 14 00 00 00 00 89 4C 24 30 8B 0C D5 ?? ?? ?? ?? F7 E1 8D 0C 89 89 44 24 08 8B 44 24 30 89 54 24 0C F7 E3 89 54 24 2C 8B 54 24 08 89 44 24 28 89 54 24 10 8B 54 24 2C 89 D0 31 D2 89 44 24 20 8B 44 24 10 01 44 24 20 8B 44 24 20 89 54 24 24 8B 54 24 14 11 54 24 24 89 C2 31 C0 89 44 24 10 8B 44 24 28 89 54 24 14 31 D2 01 44 24 10 11 54 24 14 8B 54 24 0C 89 D0 31 D2 89 44 24 08 B8 05 00 00 00 89 54 24 0C F7 64 24 30 01 CA 01 44 24 08 11 54 24 0C 8B 54 24 24 8B 0C 24 8B 5C 24 04 89 D0 31 D2 01 44 24 08 11 54 24 0C 89 4C 24 20 89 F1 89 5C 24 24 89 FB E9 DE F7 FF FF 83 FA 14 0F 84 20 01 00 00 8B 1C D5 ?? ?? ?? ?? 8B 0C D5 ?? ?? ?? ?? 89 5C 24 2C 8B 5C 24 2C 89 4C 24 10 89 4C 24 28 B9 F6 FF FF FF 89 C8 F7 E3 89 44 24 30 B8 FF FF FF FF 89 54 24 34 F7 E3 89 44 24 08 8B 44 24 10 89 54 24 0C F7 E1 89 54 24 4C 8B 5C 24 4C 31 D2 89 44 24 48 8B 44 24 30 89 D9 31 DB 89 4C 24 20 01 44 24 20 B8 FF FF FF FF 89 5C 24 24 11 54 24 24 F7 64 24 10 01 44 24 20 8B 4C 24 20 11 54 24 24 31 D2 8B 44 24 48 89 CB 31 C9 89 4C 24 10 01 44 24 10 89 5C 24 14 11 54 24 14 8B 44 24 28 8B 54 24 2C 8B 0C 24 8B 5C 24 04 0F A4 C2 02 C1 E0 02 01 44 24 08 11 54 24 0C 8B 54 24 34 89 4C 24 20 89 F1 89 D0 31 D2 01 44 24 08 11 54 24 0C 8B 54 24 24 89 5C 24 24 89 FB 89 D0 31 D2 01 44 24 08 11 54 24 0C E9 CC F8 FF FF 8B 0C 24 8B 5C 24 04 C7 44 24 10 0A 00 00 00 C7 44 24 14 00 00 00 00 89 4C 24 20 89 F1 89 5C 24 24 89 FB C7 44 24 08 05 00 00 00 C7 44 24 0C 00 00 00 00 E9 B5 F6 FF FF 8B 0C 24 8B 5C 24 04 C7 44 24 10 F6 FF FF FF C7 44 24 14 FF FF FF FF 89 4C 24 20 89 F1 89 5C 24 24 89 FB C7 44 24 08 04 00 00 00 C7 44 24 0C 00 00 00 00 E9 5C F8 FF FF 8B 44 24 48 8B 6C 24 54 C1 E0 04 3B A8 ?? ?? ?? ?? 0F 82 C3 FC FF FF 0F 87 83 FD FF FF 8B 54 24 50 3B 90 ?? ?? ?? ?? 0F 86 AD FC FF FF E9 6E FD FF FF 8B 44 24 24 23 6C 24 20 23 04 24 09 E8 0F 85 5B FD FF FF 8B 44 24 48 C1 E0 04 8B 90 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 39 44 24 0C 0F 87 3E FD FF FF 72 0A 39 54 24 08 0F 87 32 FD FF FF 33 44 24 0C 33 54 24 08 09 D0 0F 85 5C FC FF FF 8B 44 24 48 8B 74 24 54 C1 E0 04 3B B0 ?? ?? ?? ?? 0F 82 45 FC FF FF 0F 87 05 FD FF FF 8B 7C 24 50 3B B8 ?? ?? ?? ?? 0F 86 2F FC FF FF E9 F0 FC FF FF 8D 76 00 8D BC 27 00 00 00 00 }
	condition:
		$1
}

rule file_15_6_0 {
	meta:
		name = "___bid128_to_int64_int"
		size = 2896
		refs = "0123 ___bid_nr_digits 01eb ___bid_IDEC_glbflags 0317 ___bid_ten2k64 0504 ___bid_ten2mk128 081a ___bid_shiftright128"
	strings:
		$1 = { 81 EC 9C 00 00 00 8B 84 24 A0 00 00 00 8B 8C 24 AC 00 00 00 89 B4 24 90 00 00 00 89 9C 24 8C 00 00 00 89 44 24 70 8B 84 24 A4 00 00 00 8B 5C 24 70 89 AC 24 98 00 00 00 8B AC 24 A8 00 00 00 89 BC 24 94 00 00 00 89 44 24 74 8B 74 24 74 89 C8 25 00 00 00 78 89 5C 24 08 89 74 24 0C 89 CE 81 E6 00 00 00 80 3D 00 00 00 78 89 74 24 48 0F 84 63 01 00 00 89 CF 89 EE 81 E7 FF FF 01 00 81 FF 09 ED 01 00 76 3B C7 44 24 10 00 00 00 00 C7 44 24 14 00 00 00 00 8B 44 24 10 8B 54 24 14 8B 9C 24 8C 00 00 00 8B B4 24 90 00 00 00 8B BC 24 94 00 00 00 8B AC 24 98 00 00 00 81 C4 9C 00 00 00 C3 0F 83 3E 01 00 00 89 FA 89 F0 81 F2 09 ED 01 00 35 C0 87 AD BE 09 C2 0F 84 94 01 00 00 89 C8 25 00 00 00 60 3D 00 00 00 60 74 9A 89 F8 09 F0 0F 84 20 01 00 00 89 74 24 68 89 7C 24 6C DF 6C 24 68 DD 5C 24 10 8B 54 24 14 89 D0 C1 E8 14 25 FF 07 00 00 2D BE 03 00 00 83 E8 01 89 C3 C1 E3 05 8B 93 ?? ?? ?? ?? 89 44 24 18 85 D2 75 34 8B 83 ?? ?? ?? ?? 8B 93 ?? ?? ?? ?? 8B 9B ?? ?? ?? ?? 89 44 24 10 39 DF 0F 87 A7 01 00 00 0F 83 3D 08 00 00 8B 44 24 10 31 FB 31 F0 09 C3 0F 84 69 01 00 00 81 E1 00 00 FE 7F C1 E9 11 8D 99 E0 E7 FF FF 8D 0C 1A 83 F9 13 7F 6F 0F 84 D0 01 00 00 85 C9 C7 44 24 10 00 00 00 00 C7 44 24 14 00 00 00 00 0F 8E FE FE FF FF 83 FB 00 0F 8C 54 03 00 00 0F 85 59 01 00 00 8B 44 24 48 8B 5C 24 08 8B 74 24 0C 85 C0 89 5C 24 10 89 74 24 14 0F 84 D3 FE FF FF F7 DB 83 D6 00 F7 DE 89 5C 24 10 89 74 24 14 E9 BF FE FF FF 89 C8 25 00 00 00 7C 3D 00 00 00 7C 0F 84 C7 00 00 00 83 0D ?? ?? ?? ?? 01 C7 44 24 10 00 00 00 00 C7 44 24 14 00 00 00 80 E9 91 FE FF FF 81 FD C0 87 AD BE 0F 87 75 FE FF FF E9 B1 FE FF FF 8B 54 24 0C 0B 54 24 08 C7 44 24 10 00 00 00 00 C7 44 24 14 00 00 00 00 0F 84 62 FE FF FF 81 7C 24 0C FF FF 1F 00 0F 86 93 02 00 00 8B 54 24 0C 89 D0 31 D2 89 44 24 68 89 54 24 6C DF 6C 24 68 DD 5C 24 10 8B 54 24 14 89 D0 C1 E8 14 25 FF 07 00 00 2D DE 03 00 00 E9 A7 FE FF FF 81 7C 24 0C 63 8E 8D 37 C7 44 24 10 00 00 00 00 C7 44 24 14 00 00 00 00 0F 87 06 FE FF FF 89 CB 81 E3 00 00 00 60 81 FB 00 00 00 60 0F 85 52 FE FF FF E9 ED FD FF FF 8D B4 26 00 00 00 00 83 0D ?? ?? ?? ?? 01 C7 44 24 10 00 00 00 00 C7 44 24 14 00 00 00 80 E9 CA FD FF FF 8B 44 24 18 8B 5C 24 0C C1 E0 05 05 ?? ?? ?? ?? 39 58 14 0F 87 7E FE FF FF 72 0D 8B 5C 24 08 39 58 10 0F 87 6F FE FF FF 83 C2 01 E9 67 FE FF FF 8D 74 26 00 8B 44 24 48 85 C0 0F 84 6B 05 00 00 8B 74 24 08 8B 7C 24 0C 8B 0C DD ?? ?? ?? ?? 8B 14 DD ?? ?? ?? ?? F7 DE 83 D7 00 89 F0 F7 DF 0F AF D6 0F AF CF 01 D1 F7 24 DD ?? ?? ?? ?? 01 CA 89 44 24 10 89 54 24 14 E9 4D FD FF FF 8D B4 26 00 00 00 00 8B 44 24 48 85 C0 0F 84 54 05 00 00 83 FA 13 0F 8F B0 06 00 00 8B 44 24 0C 8B 4C 24 08 C7 44 24 2C 00 00 00 00 89 44 24 18 B8 14 00 00 00 29 D0 8B 14 C5 ?? ?? ?? ?? 8B 04 C5 ?? ?? ?? ?? 89 54 24 10 89 44 24 38 89 D0 F7 64 24 18 89 44 24 30 8B 44 24 38 89 54 24 34 F7 64 24 18 89 44 24 18 8B 44 24 10 89 54 24 1C F7 E1 89 54 24 14 8B 54 24 30 89 44 24 10 89 54 24 28 8B 54 24 14 89 D0 31 D2 89 44 24 20 8B 44 24 28 01 44 24 20 8B 44 24 38 89 54 24 24 8B 54 24 2C 11 54 24 24 F7 E1 01 44 24 20 11 54 24 24 8B 4C 24 34 8B 44 24 18 89 CA 31 C9 89 54 24 28 8B 54 24 1C 01 44 24 28 8B 44 24 20 89 4C 24 2C 8B 4C 24 24 11 54 24 2C C7 44 24 1C 00 00 00 00 89 CA 31 C9 01 54 24 28 89 C2 11 4C 24 2C 31 C0 89 54 24 24 8B 54 24 10 89 44 24 20 C7 44 24 10 05 00 00 00 89 54 24 18 8B 44 24 18 8B 54 24 1C 01 44 24 20 11 54 24 24 C7 44 24 18 0A 00 00 00 C7 44 24 1C 00 00 00 00 C7 44 24 14 00 00 00 00 8B 54 24 2C 39 54 24 14 0F 82 63 FD FF FF 77 0E 8B 4C 24 28 39 4C 24 10 0F 82 53 FD FF FF 8B 54 24 2C 8B 44 24 28 33 54 24 14 33 44 24 10 09 C2 0F 85 EA FC FF FF 8B 44 24 24 39 44 24 1C 0F 87 DC FC FF FF 0F 82 27 FD FF FF 8B 54 24 20 39 54 24 18 0F 87 C8 FC FF FF E9 14 FD FF FF DF 6C 24 08 DD 5C 24 10 8B 54 24 14 89 D0 C1 E8 14 25 FF 07 00 00 2D FE 03 00 00 E9 24 FC FF FF 89 D9 F7 D3 89 5C 24 58 C1 E3 04 F7 D9 8B 93 ?? ?? ?? ?? 8B 83 ?? ?? ?? ?? 89 4C 24 5C 8B 4C 24 0C C7 44 24 3C 00 00 00 00 89 54 24 30 89 44 24 28 89 D0 F7 E1 89 44 24 20 8B 44 24 28 89 54 24 24 F7 E1 89 44 24 18 8B 44 24 30 89 54 24 1C F7 64 24 08 89 54 24 44 8B 54 24 20 89 44 24 40 89 54 24 38 8B 54 24 44 89 D0 31 D2 89 44 24 10 8B 44 24 38 01 44 24 10 8B 44 24 28 89 54 24 14 8B 54 24 3C 11 54 24 14 F7 64 24 08 01 44 24 10 11 54 24 14 8B 54 24 24 89 D0 31 D2 89 44 24 20 8B 44 24 18 01 44 24 20 89 54 24 24 8B 54 24 1C 11 54 24 24 8B 54 24 14 89 D0 31 D2 01 44 24 20 11 54 24 24 8B 93 ?? ?? ?? ?? 8B 9B ?? ?? ?? ?? 89 D0 89 54 24 38 F7 E1 89 5C 24 4C 89 44 24 50 89 D8 31 DB 89 54 24 54 F7 E1 8B 4C 24 50 89 44 24 60 8B 44 24 38 89 54 24 64 F7 64 24 08 89 D0 31 D2 89 44 24 18 01 4C 24 18 89 54 24 1C 11 5C 24 1C 8B 5C 24 54 8B 44 24 4C 89 D9 31 DB 03 4C 24 60 13 5C 24 64 F7 64 24 08 01 44 24 18 11 54 24 1C 8B 54 24 1C 89 D0 31 D2 01 C1 8B 44 24 10 11 D3 89 C2 31 C0 89 44 24 10 8B 44 24 40 89 54 24 14 31 D2 01 44 24 10 11 54 24 14 01 4C 24 10 11 5C 24 14 3B 5C 24 14 72 12 77 06 3B 4C 24 10 76 0A 83 44 24 20 01 83 54 24 24 00 8B 44 24 30 31 DB F7 E7 89 44 24 08 8B 44 24 28 89 54 24 0C 8B 4C 24 08 F7 E7 89 44 24 40 8B 44 24 30 89 54 24 44 F7 E5 89 44 24 30 89 D0 89 44 24 18 8B 44 24 28 89 54 24 34 31 D2 89 54 24 1C F7 E5 01 44 24 18 11 54 24 1C 01 4C 24 18 11 5C 24 1C 8B 5C 24 0C 8B 54 24 1C 89 D9 31 DB 89 4C 24 08 8B 4C 24 40 89 D0 01 4C 24 08 89 5C 24 0C 8B 5C 24 44 11 5C 24 0C 31 D2 01 44 24 08 8B 44 24 38 11 54 24 0C 31 DB F7 E7 89 44 24 28 8B 44 24 4C 89 54 24 2C 8B 74 24 28 F7 E7 31 FF 89 44 24 40 8B 44 24 38 89 54 24 44 F7 E5 89 44 24 38 8B 44 24 4C 89 D1 89 54 24 3C F7 E5 01 C1 11 D3 01 F1 11 FB 8B 7C 24 2C 89 4C 24 2C 8B 4C 24 30 89 FE 31 FF 03 74 24 40 13 7C 24 44 31 D2 01 DE 11 D7 31 C0 89 44 24 28 8B 44 24 38 31 D2 01 44 24 28 8B 44 24 18 11 54 24 2C 31 DB 89 C2 31 C0 01 C8 11 DA 01 F0 11 FA 39 D7 72 10 77 04 39 C6 76 0A 83 44 24 08 01 83 54 24 0C 00 8B 4C 24 10 BE 01 00 00 00 8B 5C 24 14 03 4C 24 28 13 5C 24 2C 31 FF 39 5C 24 2C 77 0C 72 06 39 4C 24 28 77 04 31 F6 31 FF 8B 4C 24 20 01 F0 8B 5C 24 24 11 FA 01 C1 11 D3 39 DA 89 4C 24 20 89 5C 24 24 0F 87 D0 01 00 00 72 08 39 C8 0F 87 C6 01 00 00 31 DB 39 D7 B9 01 00 00 00 77 0A 72 04 39 C6 77 04 31 C9 31 DB 89 C8 89 DA 03 44 24 08 13 54 24 0C 83 7C 24 5C 16 0F 8F A6 01 00 00 8B 5C 24 58 8B 7C 24 24 8B 74 24 20 8B 0C 9D ?? ?? ?? ?? 31 DB 0F AD FE D3 EF F6 C1 20 0F 45 F7 0F 45 FB BB 40 00 00 00 31 ED 29 CB 89 D9 0F A5 C2 D3 E0 F6 C3 20 0F 45 D0 0F 45 C5 89 C1 89 D3 09 F1 09 FB 8B 44 24 48 89 4C 24 10 89 5C 24 14 85 C0 0F 84 33 F8 FF FF F7 D9 83 D3 00 F7 DB 89 4C 24 10 89 5C 24 14 E9 1F F8 FF FF 8B 4C 24 0C 8B 44 24 08 0F AF 04 DD ?? ?? ?? ?? 0F AF 0C DD ?? ?? ?? ?? 01 C1 8B 44 24 08 F7 24 DD ?? ?? ?? ?? 01 CA 89 44 24 10 89 54 24 14 E9 EB F7 FF FF 90 8D 74 26 00 83 FA 13 0F 8F 23 01 00 00 B8 14 00 00 00 8B 4C 24 0C 29 D0 8B 14 C5 ?? ?? ?? ?? 8B 04 C5 ?? ?? ?? ?? 89 4C 24 18 8B 4C 24 08 C7 44 24 34 00 00 00 00 89 54 24 10 89 44 24 38 89 D0 F7 64 24 18 89 44 24 20 8B 44 24 38 89 54 24 24 F7 64 24 18 89 44 24 18 8B 44 24 10 89 54 24 1C 8B 54 24 20 89 54 24 30 F7 E1 89 D0 31 D2 89 44 24 10 8B 44 24 30 01 44 24 10 89 54 24 14 8B 54 24 34 11 54 24 14 8B 54 24 24 89 D0 31 D2 89 44 24 20 8B 44 24 18 01 44 24 20 89 54 24 24 8B 54 24 1C 11 54 24 24 8B 44 24 38 F7 E1 01 44 24 10 B8 05 00 00 00 11 54 24 14 8B 4C 24 14 89 CA 31 C9 01 54 24 20 11 4C 24 24 31 D2 3B 54 24 24 0F 82 68 F8 FF FF 3B 44 24 20 0F 87 0D F8 FF FF E9 59 F8 FF FF 39 C6 0F 87 5C F9 FF FF 90 8D B4 26 00 00 00 00 E9 AE F7 FF FF B8 01 00 00 00 31 D2 E9 47 FE FF FF 8B 5C 24 58 89 C6 89 D7 31 ED 8B 0C 9D ?? ?? ?? ?? 83 E9 40 D3 EF 0F AD D6 F6 C1 20 0F 45 F7 0F 45 FD 89 F1 89 FB E9 73 FE FF FF 83 FA 14 0F 84 12 01 00 00 83 EA 14 B8 05 00 00 00 8B 0C D5 ?? ?? ?? ?? F7 24 D5 ?? ?? ?? ?? 89 74 24 20 89 7C 24 24 8D 0C 89 01 CA 39 FA 0F 87 88 F7 FF FF E9 62 FF FF FF 83 FA 14 0F 84 ED 00 00 00 83 EA 14 B8 0A 00 00 00 8B 0C D5 ?? ?? ?? ?? C7 44 24 1C 00 00 00 00 89 4C 24 38 8B 0C D5 ?? ?? ?? ?? F7 E1 8D 0C 89 89 44 24 10 B8 0A 00 00 00 89 54 24 14 F7 64 24 38 89 54 24 34 8B 54 24 10 89 44 24 30 89 54 24 18 8B 54 24 34 89 D0 31 D2 89 44 24 20 8B 44 24 18 01 44 24 20 8B 44 24 20 89 54 24 24 8B 54 24 1C 11 54 24 24 89 C2 B8 00 00 00 00 89 44 24 18 8B 44 24 30 89 54 24 1C 31 D2 01 44 24 18 11 54 24 1C 8B 54 24 14 89 D0 31 D2 89 44 24 10 B8 05 00 00 00 89 54 24 14 F7 64 24 38 01 CA 01 44 24 10 11 54 24 14 8B 54 24 24 8B 4C 24 0C 89 74 24 28 89 7C 24 2C 89 D0 31 D2 01 44 24 10 11 54 24 14 8B 54 24 08 89 4C 24 24 89 54 24 20 E9 81 F9 FF FF 89 74 24 20 B8 05 00 00 00 31 D2 89 7C 24 24 E9 6C FE FF FF 8B 44 24 08 8B 54 24 0C 89 74 24 28 89 7C 24 2C 89 44 24 20 89 54 24 24 C7 44 24 18 0A 00 00 00 C7 44 24 1C 00 00 00 00 C7 44 24 10 05 00 00 00 C7 44 24 14 00 00 00 00 E9 30 F9 FF FF 90 8D B4 26 00 00 00 00 }
	condition:
		$1
}

rule file_15_7_0 {
	meta:
		name = "___bid128_to_int64_xint"
		size = 3360
		refs = "0123 ___bid_nr_digits 01e4 ___bid_IDEC_glbflags 030f ___bid_ten2k64 04f5 ___bid_ten2mk128 0839 ___bid_maskhigh128 0840 ___bid_shiftright128 089c ___bid_ten2mk128trunc"
	strings:
		$1 = { 81 EC 9C 00 00 00 8B 84 24 A0 00 00 00 8B 8C 24 AC 00 00 00 89 B4 24 90 00 00 00 89 9C 24 8C 00 00 00 89 44 24 70 8B 84 24 A4 00 00 00 8B 5C 24 70 89 AC 24 98 00 00 00 8B AC 24 A8 00 00 00 89 BC 24 94 00 00 00 89 44 24 74 8B 74 24 74 89 C8 25 00 00 00 78 89 5C 24 08 89 74 24 0C 89 CE 81 E6 00 00 00 80 3D 00 00 00 78 89 74 24 48 0F 84 5C 01 00 00 89 CF 89 EE 81 E7 FF FF 01 00 81 FF 09 ED 01 00 76 3B C7 44 24 10 00 00 00 00 C7 44 24 14 00 00 00 00 8B 44 24 10 8B 54 24 14 8B 9C 24 8C 00 00 00 8B B4 24 90 00 00 00 8B BC 24 94 00 00 00 8B AC 24 98 00 00 00 81 C4 9C 00 00 00 C3 0F 83 39 01 00 00 89 FA 89 F0 81 F2 09 ED 01 00 35 C0 87 AD BE 09 C2 0F 84 92 01 00 00 89 C8 25 00 00 00 60 3D 00 00 00 60 74 9A 89 F8 09 F0 0F 84 1B 01 00 00 89 74 24 68 89 7C 24 6C DF 6C 24 68 DD 5C 24 10 8B 54 24 14 89 D0 C1 E8 14 25 FF 07 00 00 2D BE 03 00 00 83 E8 01 89 C3 C1 E3 05 8B 93 ?? ?? ?? ?? 89 44 24 18 85 D2 75 34 8B 83 ?? ?? ?? ?? 8B 93 ?? ?? ?? ?? 8B 9B ?? ?? ?? ?? 89 44 24 10 39 DF 0F 87 A3 01 00 00 0F 83 BD 08 00 00 8B 44 24 10 31 FB 31 F0 09 C3 0F 84 60 01 00 00 81 E1 00 00 FE 7F C1 E9 11 8D 99 E0 E7 FF FF 8D 04 1A 83 F8 13 7F 68 0F 84 C1 01 00 00 85 C0 0F 8E A9 08 00 00 83 FB 00 90 8D 74 26 00 0F 8C 50 03 00 00 0F 85 5C 01 00 00 8B 44 24 48 8B 7C 24 08 8B 6C 24 0C 85 C0 89 7C 24 10 89 6C 24 14 0F 84 DE FE FF FF F7 DF 83 D5 00 F7 DD 89 7C 24 10 89 6C 24 14 E9 CA FE FF FF 8D 74 26 00 89 C8 25 00 00 00 7C 3D 00 00 00 7C 0F 84 C5 00 00 00 83 0D ?? ?? ?? ?? 01 C7 44 24 10 00 00 00 00 C7 44 24 14 00 00 00 80 E9 98 FE FF FF 66 90 81 FD C0 87 AD BE 0F 87 7A FE FF FF E9 B6 FE FF FF 8B 54 24 0C 0B 54 24 08 C7 44 24 10 00 00 00 00 C7 44 24 14 00 00 00 00 0F 84 67 FE FF FF 81 7C 24 0C FF FF 1F 00 0F 86 89 02 00 00 8B 54 24 0C 89 D0 31 D2 89 44 24 68 89 54 24 6C DF 6C 24 68 DD 5C 24 10 8B 54 24 14 89 D0 C1 E8 14 25 FF 07 00 00 2D DE 03 00 00 E9 AC FE FF FF 8D 76 00 81 7C 24 0C 63 8E 8D 37 C7 44 24 10 00 00 00 00 C7 44 24 14 00 00 00 00 0F 87 08 FE FF FF 89 CB 81 E3 00 00 00 60 81 FB 00 00 00 60 0F 85 54 FE FF FF E9 EF FD FF FF 83 0D ?? ?? ?? ?? 01 C7 44 24 10 00 00 00 00 C7 44 24 14 00 00 00 80 E9 D3 FD FF FF 8B 44 24 18 8B 5C 24 0C C1 E0 05 05 ?? ?? ?? ?? 39 58 14 0F 87 87 FE FF FF 72 12 8B 5C 24 08 39 58 10 0F 87 78 FE FF FF 90 8D 74 26 00 83 C2 01 E9 6B FE FF FF 8B 74 24 48 85 F6 0F 84 F4 05 00 00 8B 74 24 08 8B 7C 24 0C 8B 0C DD ?? ?? ?? ?? 8B 14 DD ?? ?? ?? ?? F7 DE 83 D7 00 89 F0 F7 DF 0F AF D6 0F AF CF 01 D1 F7 24 DD ?? ?? ?? ?? 01 CA 89 44 24 10 89 54 24 14 E9 55 FD FF FF 8B 44 24 48 85 C0 0F 84 E3 05 00 00 83 FA 13 0F 8F A6 07 00 00 8B 44 24 0C 8B 4C 24 08 C7 44 24 3C 00 00 00 00 89 44 24 18 B8 14 00 00 00 29 D0 8B 14 C5 ?? ?? ?? ?? 8B 04 C5 ?? ?? ?? ?? 89 54 24 10 89 44 24 30 89 D0 F7 64 24 18 89 44 24 28 8B 44 24 30 89 54 24 2C F7 64 24 18 89 44 24 18 8B 44 24 10 89 54 24 1C F7 E1 89 54 24 14 8B 54 24 28 89 44 24 10 89 54 24 38 8B 54 24 14 89 D0 31 D2 89 44 24 20 8B 44 24 38 01 44 24 20 8B 44 24 30 89 54 24 24 8B 54 24 3C 11 54 24 24 F7 E1 01 44 24 20 11 54 24 24 8B 4C 24 2C 8B 44 24 18 89 CA 31 C9 89 54 24 28 8B 54 24 1C 01 44 24 28 8B 44 24 20 89 4C 24 2C 8B 4C 24 24 11 54 24 2C C7 44 24 1C 00 00 00 00 89 CA 31 C9 01 54 24 28 89 C2 11 4C 24 2C 31 C0 89 54 24 24 8B 54 24 10 89 44 24 20 C7 44 24 10 05 00 00 00 89 54 24 18 8B 44 24 18 8B 54 24 1C 01 44 24 20 11 54 24 24 C7 44 24 18 0A 00 00 00 C7 44 24 1C 00 00 00 00 C7 44 24 14 00 00 00 00 8B 54 24 2C 39 54 24 14 0F 82 6B FD FF FF 77 0E 8B 4C 24 28 39 4C 24 10 0F 82 5B FD FF FF 8B 54 24 2C 8B 44 24 28 33 54 24 14 33 44 24 10 09 C2 0F 85 E9 FC FF FF 8B 44 24 24 39 44 24 1C 0F 87 DB FC FF FF 0F 82 2F FD FF FF 8B 54 24 20 39 54 24 18 0F 87 C7 FC FF FF E9 1C FD FF FF DF 6C 24 08 DD 5C 24 10 8B 54 24 14 89 D0 C1 E8 14 25 FF 07 00 00 2D FE 03 00 00 E9 33 FC FF FF 89 D9 F7 D3 89 5C 24 4C C1 E3 04 F7 D9 8B 93 ?? ?? ?? ?? 8B 83 ?? ?? ?? ?? 89 4C 24 64 8B 4C 24 0C C7 44 24 34 00 00 00 00 89 54 24 28 89 44 24 38 89 D0 F7 E1 89 44 24 20 8B 44 24 38 89 54 24 24 F7 E1 89 44 24 18 8B 44 24 28 89 54 24 1C F7 64 24 08 89 54 24 44 8B 54 24 20 89 44 24 40 89 54 24 30 8B 54 24 44 89 D0 31 D2 89 44 24 10 8B 44 24 30 01 44 24 10 8B 44 24 38 89 54 24 14 8B 54 24 34 11 54 24 14 F7 64 24 08 01 44 24 10 11 54 24 14 8B 54 24 24 89 D0 31 D2 89 44 24 20 8B 44 24 18 01 44 24 20 89 54 24 24 8B 54 24 1C 11 54 24 24 8B 54 24 14 89 D0 31 D2 01 44 24 20 11 54 24 24 8B 93 ?? ?? ?? ?? 8B 9B ?? ?? ?? ?? 89 D0 89 54 24 30 F7 E1 89 5C 24 60 89 44 24 18 89 D8 89 54 24 1C F7 E1 89 44 24 50 8B 44 24 30 89 54 24 54 F7 64 24 08 89 54 24 5C 8B 5C 24 5C 31 D2 89 44 24 58 8B 44 24 18 89 D9 31 DB 01 C1 8B 44 24 60 11 D3 F7 64 24 08 01 C1 11 D3 8B 54 24 1C 89 D0 31 D2 89 44 24 18 8B 44 24 50 01 44 24 18 89 54 24 1C 8B 54 24 54 11 54 24 1C 31 D2 01 5C 24 18 11 54 24 1C 31 C0 31 D2 89 4C 24 54 8B 4C 24 10 89 44 24 50 8B 44 24 58 01 44 24 50 11 54 24 54 31 D2 8B 44 24 40 89 CB 31 C9 89 4C 24 10 01 44 24 10 8B 44 24 18 89 5C 24 14 11 54 24 14 8B 54 24 1C 01 44 24 10 11 54 24 14 8B 4C 24 14 39 CA 72 14 77 08 8B 5C 24 10 39 D8 76 0A 83 44 24 20 01 83 54 24 24 00 8B 44 24 28 31 DB F7 E7 89 44 24 08 8B 44 24 38 89 54 24 0C 8B 4C 24 08 F7 E7 89 44 24 40 8B 44 24 28 89 54 24 44 F7 E5 89 44 24 28 89 D0 89 44 24 18 8B 44 24 38 89 54 24 2C 31 D2 89 54 24 1C F7 E5 01 44 24 18 11 54 24 1C 01 4C 24 18 11 5C 24 1C 8B 5C 24 0C 8B 54 24 1C 89 D9 31 DB 89 4C 24 08 8B 4C 24 40 89 D0 01 4C 24 08 89 5C 24 0C 8B 5C 24 44 11 5C 24 0C 31 D2 01 44 24 08 8B 44 24 30 11 54 24 0C 31 DB C7 44 24 1C 00 00 00 00 F7 E7 89 44 24 38 8B 44 24 60 89 54 24 3C 8B 74 24 38 F7 E7 31 FF 89 44 24 40 8B 44 24 30 89 54 24 44 F7 E5 89 44 24 30 8B 44 24 60 89 D1 89 54 24 34 F7 E5 8B 6C 24 28 01 C1 8B 44 24 30 11 D3 01 F1 11 FB 8B 7C 24 3C 89 FE 31 FF 03 74 24 40 13 7C 24 44 31 D2 01 DE 89 CB 11 D7 31 C9 31 D2 01 C1 8B 44 24 18 11 D3 89 6C 24 18 89 C2 31 C0 03 44 24 18 13 54 24 1C 01 F0 11 FA 39 D7 72 10 77 04 39 C6 76 0A 83 44 24 08 01 83 54 24 0C 00 8B 74 24 10 8B 7C 24 14 01 CE 11 DF 89 7C 24 14 31 FF 3B 5C 24 14 89 74 24 10 BE 01 00 00 00 77 0C 72 06 3B 4C 24 10 77 04 31 F6 31 FF 8B 4C 24 20 01 F0 8B 5C 24 24 11 FA 01 C1 11 D3 39 DA 89 4C 24 20 89 5C 24 24 0F 87 29 02 00 00 72 08 39 C8 0F 87 1F 02 00 00 31 DB 39 D7 B9 01 00 00 00 77 0A 72 04 39 C6 77 04 31 C9 31 DB 89 C8 89 DA 03 44 24 08 13 54 24 0C 83 7C 24 64 16 8B 5C 24 4C 0F 8F 1A 02 00 00 8B 34 DD ?? ?? ?? ?? 8B 0C 9D ?? ?? ?? ?? 8B 7C 24 24 8B 2C DD ?? ?? ?? ?? 31 DB 89 74 24 08 8B 74 24 20 0F AD FE D3 EF F6 C1 20 0F 45 F7 0F 45 FB BB 40 00 00 00 29 CB 89 D9 31 DB 0F A5 C2 D3 E0 F6 C1 20 0F 45 D0 0F 45 C3 89 C1 89 D3 09 F1 09 FB 83 7C 24 64 03 0F 8F 03 04 00 00 8B 44 24 4C C1 E0 04 8B 90 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 39 44 24 14 0F 87 40 02 00 00 72 0A 39 54 24 10 0F 87 34 02 00 00 33 44 24 14 33 54 24 10 09 D0 0F 84 98 03 00 00 8D 74 26 00 8B 44 24 48 89 4C 24 10 89 5C 24 14 85 C0 0F 84 B2 F7 FF FF F7 D9 83 D3 00 F7 DB 89 4C 24 10 89 5C 24 14 E9 9E F7 FF FF 8B 4C 24 0C 8B 44 24 08 0F AF 04 DD ?? ?? ?? ?? 0F AF 0C DD ?? ?? ?? ?? 01 C1 8B 44 24 08 F7 24 DD ?? ?? ?? ?? 01 CA 89 44 24 10 89 54 24 14 E9 6A F7 FF FF 8D 74 26 00 83 FA 13 0F 8F A5 02 00 00 B8 14 00 00 00 8B 4C 24 0C 29 D0 8B 14 C5 ?? ?? ?? ?? 8B 04 C5 ?? ?? ?? ?? 89 4C 24 18 8B 4C 24 08 C7 44 24 2C 00 00 00 00 89 54 24 10 89 44 24 30 89 D0 F7 64 24 18 89 44 24 20 8B 44 24 30 89 54 24 24 F7 64 24 18 89 44 24 18 8B 44 24 10 89 54 24 1C 8B 54 24 20 89 54 24 28 F7 E1 89 D0 31 D2 89 44 24 10 8B 44 24 28 01 44 24 10 89 54 24 14 8B 54 24 2C 11 54 24 14 8B 54 24 24 89 D0 31 D2 89 44 24 20 8B 44 24 18 01 44 24 20 89 54 24 24 8B 54 24 1C 11 54 24 24 8B 44 24 30 F7 E1 01 44 24 10 B8 05 00 00 00 11 54 24 14 8B 4C 24 14 89 CA 31 C9 01 54 24 20 11 4C 24 24 31 D2 3B 54 24 24 0F 82 E1 F7 FF FF 3B 44 24 20 0F 87 7D F7 FF FF E9 D2 F7 FF FF 39 C6 0F 87 D8 F8 FF FF 90 8D B4 26 00 00 00 00 E9 2E F7 FF FF B8 01 00 00 00 31 D2 E9 EE FD FF FF 83 0D ?? ?? ?? ?? 20 C7 44 24 10 00 00 00 00 C7 44 24 14 00 00 00 00 E9 49 F6 FF FF 8D 76 00 8B 1C 9D ?? ?? ?? ?? 89 C6 89 D7 89 D9 31 DB 83 E9 40 0F AD D6 D3 EF F6 C1 20 0F 45 F7 0F 45 FB 89 FB 8B 7C 24 4C 89 F1 23 04 FD ?? ?? ?? ?? 23 14 FD ?? ?? ?? ?? 09 C2 75 66 8B 6C 24 24 0B 6C 24 20 75 5C 8B 44 24 4C C1 E0 04 8B 90 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 39 44 24 14 77 43 72 06 39 54 24 10 77 3B 33 44 24 14 33 54 24 10 09 D0 0F 85 0B FE FF FF 8B 44 24 4C 8B 54 24 54 C1 E0 04 3B 90 ?? ?? ?? ?? 0F 82 F4 FD FF FF 77 12 8B 74 24 50 3B B0 ?? ?? ?? ?? 0F 86 E2 FD FF FF 66 90 83 0D ?? ?? ?? ?? 20 E9 D4 FD FF FF 83 FA 14 0F 84 0E 01 00 00 83 EA 14 B8 0A 00 00 00 8B 0C D5 ?? ?? ?? ?? C7 44 24 1C 00 00 00 00 89 4C 24 30 8B 0C D5 ?? ?? ?? ?? F7 E1 8D 0C 89 89 44 24 10 B8 0A 00 00 00 89 54 24 14 F7 64 24 30 89 54 24 2C 8B 54 24 10 89 44 24 28 89 54 24 18 8B 54 24 2C 89 D0 31 D2 89 44 24 20 8B 44 24 18 01 44 24 20 8B 44 24 20 89 54 24 24 8B 54 24 1C 11 54 24 24 89 C2 B8 00 00 00 00 89 44 24 18 8B 44 24 28 89 54 24 1C 31 D2 01 44 24 18 11 54 24 1C 8B 54 24 14 89 D0 31 D2 89 44 24 10 B8 05 00 00 00 89 54 24 14 F7 64 24 30 01 CA 01 44 24 10 11 54 24 14 8B 54 24 24 8B 4C 24 0C 89 74 24 28 89 7C 24 2C 89 D0 31 D2 01 44 24 10 11 54 24 14 8B 54 24 08 89 4C 24 24 89 54 24 20 E9 8B F8 FF FF 83 FA 14 74 6D 83 EA 14 B8 05 00 00 00 8B 0C D5 ?? ?? ?? ?? F7 24 D5 ?? ?? ?? ?? 89 74 24 20 89 7C 24 24 8D 0C 89 01 CA 39 FA 0F 87 7A F5 FF FF E9 E4 FD FF FF 8B 44 24 08 8B 54 24 0C 89 74 24 28 89 7C 24 2C 89 44 24 20 89 54 24 24 C7 44 24 18 0A 00 00 00 C7 44 24 1C 00 00 00 00 C7 44 24 10 05 00 00 00 C7 44 24 14 00 00 00 00 E9 19 F8 FF FF 89 74 24 20 B8 05 00 00 00 31 D2 89 7C 24 24 E9 93 FD FF FF 8B 44 24 4C 8B 6C 24 54 C1 E0 04 3B A8 ?? ?? ?? ?? 0F 82 55 FC FF FF 0F 87 6F FE FF FF 8B 54 24 50 3B 90 ?? ?? ?? ?? 0F 86 3F FC FF FF E9 5A FE FF FF 8B 44 24 24 23 6C 24 20 23 44 24 08 09 E8 0F 85 46 FE FF FF 8B 44 24 4C C1 E0 04 8B 90 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 39 44 24 14 0F 87 29 FE FF FF 72 0A 39 54 24 10 0F 87 1D FE FF FF 33 44 24 14 33 54 24 10 09 D0 0F 85 ED FB FF FF 8B 44 24 4C 8B 74 24 54 C1 E0 04 3B B0 ?? ?? ?? ?? 0F 82 D6 FB FF FF 0F 87 F0 FD FF FF 8B 7C 24 50 3B B8 ?? ?? ?? ?? 0F 86 C0 FB FF FF E9 DB FD FF FF 8D 74 26 00 8D BC 27 00 00 00 00 }
	condition:
		$1
}

rule file_15_8_0 {
	meta:
		name = "___bid128_to_int64_rninta"
		size = 3328
		refs = "0125 ___bid_nr_digits 01b6 ___bid_midpoint128 0224 ___bid_IDEC_glbflags 0312 ___bid_ten2k64 04c1 ___bid_midpoint64 06d7 ___bid_ten2mk128 09eb ___bid_shiftright128"
	strings:
		$1 = { 81 EC 9C 00 00 00 8B 84 24 A0 00 00 00 89 B4 24 90 00 00 00 8B B4 24 AC 00 00 00 89 9C 24 8C 00 00 00 89 BC 24 94 00 00 00 89 44 24 70 8B 84 24 A4 00 00 00 8B 4C 24 70 89 F2 81 E2 00 00 00 78 89 AC 24 98 00 00 00 89 44 24 74 8B 5C 24 74 8B 84 24 A8 00 00 00 89 4C 24 08 89 5C 24 0C 89 F3 81 E3 00 00 00 80 81 FA 00 00 00 78 89 5C 24 14 0F 84 9A 01 00 00 89 F3 89 C1 81 E3 FF FF 01 00 81 FB 09 ED 01 00 76 3B C7 44 24 18 00 00 00 00 C7 44 24 1C 00 00 00 00 8B 44 24 18 8B 54 24 1C 8B 9C 24 8C 00 00 00 8B B4 24 90 00 00 00 8B BC 24 94 00 00 00 8B AC 24 98 00 00 00 81 C4 9C 00 00 00 C3 0F 83 77 01 00 00 89 DA 89 C8 81 F2 09 ED 01 00 35 C0 87 AD BE 09 C2 0F 84 D0 01 00 00 89 F0 25 00 00 00 60 3D 00 00 00 60 74 9A 89 DF 09 CF 0F 84 58 01 00 00 89 4C 24 68 89 5C 24 6C DF 6C 24 68 DD 5C 24 18 8B 54 24 1C 89 D0 C1 E8 14 25 FF 07 00 00 2D BE 03 00 00 83 E8 01 89 C2 C1 E2 05 8B BA ?? ?? ?? ?? 85 FF 75 33 8B BA ?? ?? ?? ?? 8B AA ?? ?? ?? ?? 8B 92 ?? ?? ?? ?? 39 D3 0F 87 3B 03 00 00 0F 83 23 05 00 00 31 DA 31 CD 09 EA 0F 84 05 03 00 00 8D B4 26 00 00 00 00 81 E6 00 00 FE 7F C1 EE 11 81 EE 20 18 00 00 8D 2C 37 83 FD 13 0F 8F A7 00 00 00 0F 84 66 01 00 00 83 FD 00 C7 44 24 18 00 00 00 00 C7 44 24 1C 00 00 00 00 0F 8C FE FE FF FF 0F 85 63 02 00 00 8D 47 FF 83 F8 12 0F 8E 04 03 00 00 83 EF 14 89 F8 C1 E0 04 8B 90 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 39 C3 0F 82 C0 FE FF FF 77 08 39 D1 0F 82 B6 FE FF FF 31 D8 31 D1 09 C8 0F 84 7C 0A 00 00 8B 44 24 14 C7 44 24 18 01 00 00 00 C7 44 24 1C 00 00 00 00 85 C0 0F 84 9E FE FF FF C7 44 24 18 FF FF FF FF C7 44 24 1C FF FF FF FF E9 89 FE FF FF 90 89 F0 25 00 00 00 7C 3D 00 00 00 7C 0F 84 20 02 00 00 83 0D ?? ?? ?? ?? 01 C7 44 24 18 00 00 00 00 C7 44 24 1C 00 00 00 80 E9 5A FE FF FF 66 90 3D C0 87 AD BE 0F 87 3D FE FF FF E9 79 FE FF FF 8B 6C 24 0C 0B 6C 24 08 C7 44 24 18 00 00 00 00 C7 44 24 1C 00 00 00 00 0F 84 2A FE FF FF 81 7C 24 0C FF FF 1F 00 0F 86 14 02 00 00 8B 54 24 0C 89 D0 31 D2 89 44 24 68 89 54 24 6C DF 6C 24 68 DD 5C 24 18 8B 54 24 1C 89 D0 C1 E8 14 25 FF 07 00 00 2D DE 03 00 00 E9 6F FE FF FF 8D 74 26 00 81 7C 24 0C 63 8E 8D 37 C7 44 24 18 00 00 00 00 C7 44 24 1C 00 00 00 00 0F 87 CA FD FF FF 89 F7 81 E7 00 00 00 60 81 FF 00 00 00 60 0F 85 16 FE FF FF E9 B1 FD FF FF 8B 44 24 14 85 C0 0F 84 3D 02 00 00 83 FF 13 0F 8F 33 08 00 00 8B 44 24 08 8B 6C 24 0C 89 44 24 38 B8 14 00 00 00 29 F8 8B 3C C5 ?? ?? ?? ?? 8B 04 C5 ?? ?? ?? ?? 89 44 24 28 89 F8 F7 E5 89 44 24 18 8B 44 24 28 89 54 24 1C F7 E5 89 44 24 30 8B 44 24 38 89 54 24 34 F7 E7 89 54 24 24 8B 6C 24 24 31 D2 89 44 24 20 8B 44 24 18 89 EF 31 ED 89 7C 24 40 01 44 24 40 8B 44 24 28 89 6C 24 44 11 54 24 44 F7 64 24 38 01 44 24 40 11 54 24 44 8B 54 24 1C 8B 6C 24 44 89 D0 31 D2 03 44 24 30 89 EF 13 54 24 34 31 ED 01 F8 8B 7C 24 40 11 EA 89 FD BF 00 00 00 00 89 7C 24 18 8B 7C 24 20 89 6C 24 1C 31 ED 01 7C 24 18 BF 05 00 00 00 11 6C 24 1C 31 ED C7 44 24 20 05 00 00 00 C7 44 24 24 00 00 00 00 39 D5 0F 82 4F FE FF FF 77 08 39 C7 0F 82 45 FE FF FF 31 EA 31 F8 09 C2 75 1E 8B 6C 24 1C 39 6C 24 24 77 14 0F 82 2D FE FF FF 8B 44 24 18 39 44 24 20 0F 86 1F FE FF FF 83 FE 00 0F 8C 79 02 00 00 0F 85 D5 00 00 00 8B 4C 24 08 8B 5C 24 0C 8B 44 24 14 89 4C 24 18 89 5C 24 1C 85 C0 0F 84 6A FC FF FF F7 D9 83 D3 00 F7 DB 89 4C 24 18 89 5C 24 1C E9 56 FC FF FF 83 0D ?? ?? ?? ?? 01 C7 44 24 18 00 00 00 00 C7 44 24 1C 00 00 00 80 E9 3A FC FF FF C1 E0 05 8B 54 24 0C 05 ?? ?? ?? ?? 39 50 14 0F 87 ED FC FF FF 72 0D 8B 6C 24 08 39 68 10 0F 87 DE FC FF FF 83 C7 01 E9 D6 FC FF FF 8D B6 00 00 00 00 DF 6C 24 08 DD 5C 24 18 8B 54 24 1C 89 D0 C1 E8 14 25 FF 07 00 00 2D FE 03 00 00 E9 6B FC FF FF 89 DA 09 CA 0F 85 24 FD FF FF 8B 4C 24 0C 39 0C C5 ?? ?? ?? ?? 0F 87 BD FB FF FF 0F 82 0D FD FF FF 8B 5C 24 08 39 1C C5 ?? ?? ?? ?? 0F 87 A6 FB FF FF E9 F7 FC FF FF 8B 44 24 14 85 C0 0F 84 2D 05 00 00 8B 7C 24 08 8B 6C 24 0C 8B 0C F5 ?? ?? ?? ?? 8B 14 F5 ?? ?? ?? ?? F7 DF 83 D5 00 89 F8 F7 DD 0F AF D7 0F AF CD 01 D1 F7 24 F5 ?? ?? ?? ?? 01 CA 89 44 24 18 89 54 24 1C E9 68 FB FF FF 83 FF 13 0F 8F 1B 05 00 00 B8 14 00 00 00 8B 6C 24 0C 29 F8 8B 54 24 08 8B 3C C5 ?? ?? ?? ?? 8B 04 C5 ?? ?? ?? ?? 89 54 24 38 89 44 24 28 89 F8 F7 E5 89 44 24 18 8B 44 24 28 89 54 24 1C F7 E5 89 44 24 30 8B 44 24 38 89 54 24 34 F7 E7 89 54 24 24 8B 6C 24 24 31 D2 89 44 24 20 8B 44 24 18 89 EF 31 ED 89 7C 24 40 01 44 24 40 8B 44 24 28 89 6C 24 44 11 54 24 44 F7 64 24 38 01 44 24 40 11 54 24 44 8B 54 24 1C 8B 6C 24 44 89 D0 31 D2 03 44 24 30 89 EF 13 54 24 34 31 ED 01 F8 8B 7C 24 40 11 EA 89 FD BF 00 00 00 00 89 7C 24 28 89 6C 24 2C 8B 6C 24 20 C7 44 24 1C 00 00 00 00 C7 44 24 20 FB FF FF FF C7 44 24 24 FF FF FF FF 89 6C 24 18 8B 7C 24 18 8B 6C 24 1C 01 7C 24 28 11 6C 24 2C C7 44 24 18 04 00 00 00 C7 44 24 1C 00 00 00 00 39 54 24 1C 0F 82 F5 FB FF FF 77 0A 39 44 24 18 0F 82 E9 FB FF FF 33 54 24 1C 33 44 24 18 09 C2 0F 85 BA FD FF FF 8B 6C 24 2C 39 6C 24 24 0F 87 AC FD FF FF 0F 82 C5 FB FF FF 8B 44 24 28 39 44 24 20 0F 87 98 FD FF FF E9 B2 FB FF FF 39 E9 0F 87 0A FE FF FF 90 8D B4 26 00 00 00 00 E9 C8 FA FF FF 89 F7 F7 DF 83 FF 13 89 7C 24 54 0F 8F 8F 05 00 00 F7 D6 8B 44 24 08 8B 54 24 0C 03 04 F5 ?? ?? ?? ?? 13 14 F5 ?? ?? ?? ?? 89 74 24 50 39 54 24 0C 72 0E 77 06 39 44 24 08 76 06 83 C1 01 83 D3 00 8B 74 24 50 89 44 24 30 89 54 24 60 C1 E6 04 8B BE ?? ?? ?? ?? 8B AE ?? ?? ?? ?? 89 F8 F7 E2 89 6C 24 40 89 7C 24 38 89 44 24 18 89 E8 89 54 24 1C F7 64 24 60 89 44 24 20 8B 44 24 30 89 54 24 24 F7 E7 89 54 24 4C 8B 6C 24 4C 31 D2 89 44 24 48 8B 44 24 18 89 EF 31 ED 89 6C 24 0C 8B 6C 24 1C 89 7C 24 08 01 44 24 08 8B 44 24 30 11 54 24 0C 89 EF F7 64 24 40 01 44 24 08 11 54 24 0C 31 ED 89 7C 24 18 89 6C 24 1C 8B 7C 24 20 8B 6C 24 24 01 7C 24 18 8B 54 24 0C 11 6C 24 1C 8B AE ?? ?? ?? ?? 8B B6 ?? ?? ?? ?? 89 D0 31 D2 01 44 24 18 11 54 24 1C 89 E8 F7 64 24 60 31 FF 89 74 24 04 89 6C 24 28 89 44 24 58 8B 44 24 60 89 54 24 5C F7 E6 8B 74 24 58 89 44 24 60 8B 44 24 30 89 54 24 64 F7 E5 89 D0 31 D2 89 44 24 20 8B 44 24 30 01 74 24 20 89 54 24 24 11 7C 24 24 8B 7C 24 5C 89 FE 31 FF 03 74 24 60 13 7C 24 64 F7 64 24 04 01 44 24 20 11 54 24 24 8B 54 24 24 89 D0 31 D2 01 C6 8B 44 24 08 11 D7 89 C2 31 C0 89 44 24 08 8B 44 24 48 89 54 24 0C 31 D2 01 44 24 08 11 54 24 0C 01 74 24 08 11 7C 24 0C 3B 7C 24 0C 72 12 77 06 3B 74 24 08 76 0A 83 44 24 18 01 83 54 24 1C 00 8B 44 24 38 89 DE F7 E6 89 44 24 20 8B 44 24 40 89 54 24 24 F7 E6 89 44 24 48 8B 44 24 38 89 54 24 4C F7 E1 89 54 24 3C 8B 6C 24 3C 31 D2 89 44 24 38 8B 44 24 20 89 EF 31 ED 89 7C 24 30 01 44 24 30 8B 44 24 40 89 6C 24 34 8B 6C 24 24 11 54 24 34 F7 E1 01 44 24 30 89 EF 11 54 24 34 31 ED 8B 54 24 34 89 7C 24 20 8B 7C 24 48 01 7C 24 20 89 6C 24 24 8B 6C 24 4C 89 D0 11 6C 24 24 31 D2 01 44 24 20 8B 44 24 28 11 54 24 24 8B 6C 24 38 F7 E6 89 44 24 40 8B 44 24 04 89 54 24 44 8B 5C 24 44 F7 E6 89 44 24 48 8B 44 24 28 89 54 24 4C F7 E1 89 54 24 2C 8B 7C 24 2C 31 D2 89 44 24 28 8B 44 24 40 C7 44 24 2C 00 00 00 00 89 FE 31 FF 01 C6 8B 44 24 04 11 D7 F7 E1 89 D9 01 C6 8B 44 24 28 11 D7 31 DB 03 4C 24 48 13 5C 24 4C 31 D2 89 6C 24 28 01 F9 89 F7 11 D3 31 F6 31 D2 01 C6 8B 44 24 30 11 D7 89 C2 31 C0 03 44 24 28 13 54 24 2C 01 C8 11 DA 39 D3 72 10 77 04 39 C1 76 0A 83 44 24 20 01 83 54 24 24 00 8B 4C 24 08 8B 5C 24 0C C7 44 24 08 01 00 00 00 C7 44 24 0C 00 00 00 00 01 F1 11 FB 39 DF 77 16 72 04 39 CE 77 10 C7 44 24 08 00 00 00 00 C7 44 24 0C 00 00 00 00 8B 74 24 18 03 44 24 08 8B 7C 24 1C 13 54 24 0C 01 C6 11 D7 39 FA 0F 87 49 02 00 00 72 08 39 F0 0F 87 3F 02 00 00 31 DB B9 01 00 00 00 39 54 24 0C 77 0C 72 06 39 44 24 08 77 04 31 C9 31 DB 89 C8 89 DA 03 44 24 20 13 54 24 24 83 7C 24 54 16 0F 8F 1B 02 00 00 8B 6C 24 50 BB 40 00 00 00 8B 0C AD ?? ?? ?? ?? 31 ED 0F AD FE D3 EF F6 C1 20 0F 45 F7 0F 45 FD 29 CB 89 D9 31 DB 0F A5 C2 D3 E0 F6 C1 20 0F 45 D0 0F 45 C3 89 C1 89 D3 09 F1 09 FB E9 FA F9 FF FF 8B 4C 24 0C 8B 44 24 08 0F AF 04 F5 ?? ?? ?? ?? 0F AF 0C F5 ?? ?? ?? ?? 01 C1 8B 44 24 08 F7 24 F5 ?? ?? ?? ?? 01 CA 89 44 24 18 89 54 24 1C E9 44 F6 FF FF 83 FF 14 0F 84 5B 02 00 00 8B 14 FD ?? ?? ?? ?? 8B 04 FD ?? ?? ?? ?? BF FB FF FF FF 89 54 24 3C 89 D5 89 44 24 20 89 44 24 38 89 D0 F7 E7 89 44 24 28 B8 FF FF FF FF 89 54 24 2C F7 E5 89 44 24 18 8B 44 24 20 89 54 24 1C F7 E7 89 54 24 34 8B 6C 24 34 31 D2 89 44 24 30 8B 44 24 28 89 EF 31 ED 01 C7 B8 FF FF FF FF 11 D5 F7 64 24 20 01 C7 89 F8 11 D5 89 C2 B8 00 00 00 00 89 44 24 20 8B 44 24 30 89 54 24 24 31 D2 01 44 24 20 11 54 24 24 8B 44 24 38 8B 54 24 3C 0F A4 C2 02 C1 E0 02 01 44 24 18 11 54 24 1C 8B 54 24 2C 89 D0 31 D2 01 44 24 18 89 C8 11 54 24 1C 31 D2 8B 7C 24 08 01 6C 24 18 8B 6C 24 0C 11 54 24 1C 89 DA 89 7C 24 28 89 6C 24 2C E9 F4 FA FF FF 83 FF 14 0F 84 50 01 00 00 83 EF 14 8B 2C FD ?? ?? ?? ?? 89 6C 24 30 8B 44 24 30 BD 05 00 00 00 F7 E5 89 44 24 28 8B 04 FD ?? ?? ?? ?? 89 54 24 2C F7 E5 89 54 24 1C 8B 6C 24 1C 31 D2 89 44 24 18 8B 44 24 28 89 EF 31 ED 89 7C 24 38 01 44 24 38 8B 44 24 38 89 6C 24 3C 8B 6C 24 2C 11 54 24 3C 89 C2 31 C0 89 44 24 20 8B 44 24 18 89 EF 89 54 24 24 31 D2 01 44 24 20 11 54 24 24 31 ED 8B 54 24 30 8B 44 24 18 8D 14 92 89 54 24 28 8B 54 24 28 03 54 24 1C 01 C7 11 D5 8B 54 24 3C 89 D0 31 D2 01 C7 8B 44 24 08 11 D5 8B 54 24 0C 89 44 24 18 89 C8 89 54 24 1C 89 DA E9 DD F7 FF FF B8 01 00 00 00 31 D2 E9 D2 FD FF FF 8B 5C 24 50 89 C6 89 D7 31 ED 8B 0C 9D ?? ?? ?? ?? 83 E9 40 D3 EF 0F AD D6 F6 C1 20 0F 45 F7 0F 45 FD 89 F1 89 FB E9 F5 F7 FF FF BF EC FF FF FF 8B 44 24 08 29 F7 8B 54 24 0C F7 D6 C1 E7 04 03 87 ?? ?? ?? ?? 89 74 24 50 13 97 ?? ?? ?? ?? 03 8F ?? ?? ?? ?? 13 9F ?? ?? ?? ?? E9 58 FA FF FF C1 E7 04 8B 74 24 0C 39 B7 ?? ?? ?? ?? 0F 87 1B F4 FF FF 0F 82 6B F5 FF FF 8B 6C 24 08 39 AF ?? ?? ?? ?? 0F 87 05 F4 FF FF E9 56 F5 FF FF 8B 7C 24 08 89 C8 89 DA 8B 6C 24 0C C7 44 24 20 05 00 00 00 C7 44 24 24 00 00 00 00 89 7C 24 18 BF 05 00 00 00 89 6C 24 1C 31 ED E9 13 F7 FF FF 8B 7C 24 08 89 C8 89 DA 8B 6C 24 0C C7 44 24 20 FB FF FF FF C7 44 24 24 FF FF FF FF 89 7C 24 28 89 6C 24 2C C7 44 24 18 04 00 00 00 C7 44 24 1C 00 00 00 00 E9 32 F9 FF FF EB 0D 90 90 90 90 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_15_9_0 {
	meta:
		name = "___bid128_to_int64_xrninta"
		size = 4144
		refs = "0125 ___bid_nr_digits 01ac ___bid_midpoint128 0200 ___bid_IDEC_glbflags 0312 ___bid_ten2k64 04c1 ___bid_midpoint64 0707 ___bid_ten2mk128 0a39 ___bid_maskhigh128 0a53 ___bid_shiftright128 0cff ___bid_onehalf128 0d5b ___bid_ten2mk128trunc"
	strings:
		$1 = { 81 EC 9C 00 00 00 8B 84 24 A0 00 00 00 89 B4 24 90 00 00 00 8B B4 24 AC 00 00 00 89 9C 24 8C 00 00 00 89 BC 24 94 00 00 00 89 44 24 70 8B 84 24 A4 00 00 00 8B 4C 24 70 89 F2 81 E2 00 00 00 78 89 AC 24 98 00 00 00 89 44 24 74 8B 5C 24 74 8B 84 24 A8 00 00 00 89 4C 24 08 89 5C 24 0C 89 F3 81 E3 00 00 00 80 81 FA 00 00 00 78 89 5C 24 14 0F 84 9A 01 00 00 89 F3 89 C1 81 E3 FF FF 01 00 81 FB 09 ED 01 00 76 3B C7 44 24 18 00 00 00 00 C7 44 24 1C 00 00 00 00 8B 44 24 18 8B 54 24 1C 8B 9C 24 8C 00 00 00 8B B4 24 90 00 00 00 8B BC 24 94 00 00 00 8B AC 24 98 00 00 00 81 C4 9C 00 00 00 C3 0F 83 77 01 00 00 89 DA 89 C8 81 F2 09 ED 01 00 35 C0 87 AD BE 09 C2 0F 84 D0 01 00 00 89 F0 25 00 00 00 60 3D 00 00 00 60 74 9A 89 DF 09 CF 0F 84 58 01 00 00 89 4C 24 68 89 5C 24 6C DF 6C 24 68 DD 5C 24 18 8B 54 24 1C 89 D0 C1 E8 14 25 FF 07 00 00 2D BE 03 00 00 83 E8 01 89 C7 C1 E7 05 8B 97 ?? ?? ?? ?? 85 D2 75 33 8B 97 ?? ?? ?? ?? 8B AF ?? ?? ?? ?? 8B BF ?? ?? ?? ?? 39 FB 0F 87 3B 03 00 00 0F 83 33 05 00 00 31 DF 31 CD 09 EF 0F 84 05 03 00 00 8D B4 26 00 00 00 00 81 E6 00 00 FE 7F C1 EE 11 81 EE 20 18 00 00 8D 04 32 83 F8 13 0F 8F A7 00 00 00 0F 84 66 01 00 00 83 F8 00 0F 8C 0B 05 00 00 8D B6 00 00 00 00 0F 85 6D 02 00 00 8D 42 FF 83 F8 12 0F 8E 0E 03 00 00 83 EA 14 89 D0 C1 E0 04 8B B0 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 39 C3 0F 82 22 03 00 00 77 08 39 F1 0F 82 18 03 00 00 31 D8 31 F1 09 C8 66 90 0F 84 0F 0C 00 00 8B 44 24 14 C7 44 24 18 01 00 00 00 C7 44 24 1C 00 00 00 00 85 C0 74 10 C7 44 24 18 FF FF FF FF C7 44 24 1C FF FF FF FF 83 0D ?? ?? ?? ?? 20 E9 8E FE FF FF 8D B6 00 00 00 00 89 F0 25 00 00 00 7C 3D 00 00 00 7C 0F 84 20 02 00 00 83 0D ?? ?? ?? ?? 01 C7 44 24 18 00 00 00 00 C7 44 24 1C 00 00 00 80 E9 5A FE FF FF 66 90 3D C0 87 AD BE 0F 87 3D FE FF FF E9 79 FE FF FF 8B 6C 24 0C 0B 6C 24 08 C7 44 24 18 00 00 00 00 C7 44 24 1C 00 00 00 00 0F 84 2A FE FF FF 81 7C 24 0C FF FF 1F 00 0F 86 14 02 00 00 8B 54 24 0C 89 D0 31 D2 89 44 24 68 89 54 24 6C DF 6C 24 68 DD 5C 24 18 8B 54 24 1C 89 D0 C1 E8 14 25 FF 07 00 00 2D DE 03 00 00 E9 6F FE FF FF 8D 74 26 00 81 7C 24 0C 63 8E 8D 37 C7 44 24 18 00 00 00 00 C7 44 24 1C 00 00 00 00 0F 87 CA FD FF FF 89 F7 81 E7 00 00 00 60 81 FF 00 00 00 60 0F 85 16 FE FF FF E9 B1 FD FF FF 8B 44 24 14 85 C0 0F 84 4D 02 00 00 83 FA 13 0F 8F 24 08 00 00 8B 44 24 08 8B 6C 24 0C 89 44 24 38 B8 14 00 00 00 29 D0 8B 3C C5 ?? ?? ?? ?? 8B 04 C5 ?? ?? ?? ?? 89 44 24 28 89 F8 F7 E5 89 44 24 18 8B 44 24 28 89 54 24 1C F7 E5 89 44 24 30 8B 44 24 38 89 54 24 34 F7 E7 89 54 24 24 8B 6C 24 24 31 D2 89 44 24 20 8B 44 24 18 89 EF 31 ED 89 7C 24 40 01 44 24 40 8B 44 24 28 89 6C 24 44 11 54 24 44 F7 64 24 38 01 44 24 40 11 54 24 44 8B 54 24 1C 8B 6C 24 44 89 D0 31 D2 03 44 24 30 89 EF 13 54 24 34 31 ED 01 F8 8B 7C 24 40 11 EA 89 FD BF 00 00 00 00 89 7C 24 18 8B 7C 24 20 89 6C 24 1C 31 ED 01 7C 24 18 BF 05 00 00 00 11 6C 24 1C 31 ED C7 44 24 20 05 00 00 00 C7 44 24 24 00 00 00 00 39 D5 0F 82 4F FE FF FF 77 08 39 C7 0F 82 45 FE FF FF 31 EA 31 F8 09 C2 75 1E 8B 6C 24 1C 39 6C 24 24 77 14 0F 82 2D FE FF FF 8B 44 24 18 39 44 24 20 0F 86 1F FE FF FF 83 FE 00 0F 8C A5 02 00 00 0F 85 E3 00 00 00 8B 74 24 08 8B 7C 24 0C 8B 44 24 14 89 74 24 18 89 7C 24 1C 85 C0 0F 84 6A FC FF FF F7 DE 83 D7 00 F7 DF 89 74 24 18 89 7C 24 1C E9 56 FC FF FF 83 0D ?? ?? ?? ?? 01 C7 44 24 18 00 00 00 00 C7 44 24 1C 00 00 00 80 E9 3A FC FF FF C1 E0 05 8B 7C 24 0C 05 ?? ?? ?? ?? 39 78 14 0F 87 ED FC FF FF 72 0D 8B 6C 24 08 39 68 10 0F 87 DE FC FF FF 83 C2 01 E9 D6 FC FF FF 8D B6 00 00 00 00 DF 6C 24 08 DD 5C 24 18 8B 54 24 1C 89 D0 C1 E8 14 25 FF 07 00 00 2D FE 03 00 00 E9 6B FC FF FF 89 DA 09 CA 0F 85 1C FD FF FF 8B 4C 24 0C 39 0C C5 ?? ?? ?? ?? 77 19 0F 82 09 FD FF FF 8B 5C 24 08 39 1C C5 ?? ?? ?? ?? 0F 86 F8 FC FF FF 66 90 C7 44 24 18 00 00 00 00 C7 44 24 1C 00 00 00 00 E9 09 FD FF FF 8B 44 24 14 85 C0 0F 84 EB 05 00 00 8B 7C 24 08 8B 6C 24 0C 8B 0C F5 ?? ?? ?? ?? 8B 14 F5 ?? ?? ?? ?? F7 DF 83 D5 00 89 F8 F7 DD 0F AF D7 0F AF CD 01 D1 F7 24 F5 ?? ?? ?? ?? 01 CA 89 44 24 18 89 54 24 1C E9 5A FB FF FF 66 90 83 FA 13 0F 8F 96 06 00 00 8B 7C 24 08 B8 14 00 00 00 29 D0 8B 6C 24 0C 89 7C 24 38 8B 3C C5 ?? ?? ?? ?? 8B 04 C5 ?? ?? ?? ?? 89 44 24 28 89 F8 F7 E5 89 44 24 18 8B 44 24 28 89 54 24 1C F7 E5 89 44 24 30 8B 44 24 38 89 54 24 34 F7 E7 89 54 24 24 8B 6C 24 24 31 D2 89 44 24 20 8B 44 24 18 89 EF 31 ED 89 7C 24 40 01 44 24 40 8B 44 24 28 89 6C 24 44 11 54 24 44 F7 64 24 38 01 44 24 40 11 54 24 44 8B 54 24 1C 8B 6C 24 44 89 D0 31 D2 03 44 24 30 89 EF 13 54 24 34 31 ED 01 F8 8B 7C 24 40 11 EA 89 FD BF 00 00 00 00 89 7C 24 28 89 6C 24 2C 8B 6C 24 20 C7 44 24 1C 00 00 00 00 C7 44 24 20 FB FF FF FF C7 44 24 24 FF FF FF FF 89 6C 24 18 8B 7C 24 18 8B 6C 24 1C 01 7C 24 28 11 6C 24 2C C7 44 24 18 04 00 00 00 C7 44 24 1C 00 00 00 00 39 54 24 1C 0F 82 E5 FB FF FF 77 0A 39 44 24 18 0F 82 D9 FB FF FF 33 54 24 1C 33 44 24 18 09 C2 0F 85 AA FD FF FF 8B 6C 24 2C 39 6C 24 24 0F 87 9C FD FF FF 0F 82 B5 FB FF FF 8B 44 24 28 39 44 24 20 0F 87 88 FD FF FF E9 A2 FB FF FF 39 E9 0F 87 FA FD FF FF 90 8D B4 26 00 00 00 00 E9 B8 FA FF FF 83 0D ?? ?? ?? ?? 20 C7 44 24 18 00 00 00 00 C7 44 24 1C 00 00 00 00 E9 E7 F9 FF FF 89 F5 F7 DD 83 FD 13 89 6C 24 5C 0F 8F EE 06 00 00 F7 D6 8B 44 24 08 8B 54 24 0C 03 04 F5 ?? ?? ?? ?? 13 14 F5 ?? ?? ?? ?? 89 74 24 04 39 54 24 0C 72 0E 77 06 39 44 24 08 76 06 83 C1 01 83 D3 00 8B 74 24 04 89 D7 89 C5 C7 44 24 2C 00 00 00 00 C1 E6 04 8B 86 ?? ?? ?? ?? 8B 96 ?? ?? ?? ?? 89 44 24 38 89 54 24 40 F7 E7 89 44 24 18 8B 44 24 40 89 54 24 1C F7 E7 89 44 24 20 8B 44 24 38 89 54 24 24 F7 E5 89 54 24 4C 8B 54 24 18 89 44 24 48 89 54 24 28 8B 54 24 4C 89 D0 31 D2 89 44 24 08 8B 44 24 28 01 44 24 08 8B 44 24 40 89 54 24 0C 8B 54 24 2C 11 54 24 0C F7 E5 01 44 24 08 11 54 24 0C 8B 54 24 1C 89 D0 31 D2 89 44 24 18 8B 44 24 20 01 44 24 18 89 54 24 1C 8B 54 24 24 11 54 24 1C 8B 54 24 0C 89 D0 31 D2 01 44 24 18 11 54 24 1C 8B 96 ?? ?? ?? ?? 8B B6 ?? ?? ?? ?? 89 D0 89 54 24 28 F7 E7 89 74 24 58 89 44 24 20 89 F0 89 54 24 24 F7 E7 89 44 24 50 8B 44 24 28 89 54 24 54 F7 E5 89 54 24 64 8B 7C 24 64 31 D2 89 44 24 60 8B 44 24 20 89 FE 31 FF 01 C6 8B 44 24 58 11 D7 F7 E5 01 C6 11 D7 8B 54 24 24 89 D0 31 D2 89 44 24 20 8B 44 24 50 89 54 24 24 8B 54 24 54 01 44 24 20 11 54 24 24 31 D2 01 7C 24 20 11 54 24 24 31 C0 31 D2 8B 6C 24 24 89 74 24 54 8B 74 24 08 89 44 24 50 8B 44 24 60 01 44 24 50 11 54 24 54 31 D2 89 F7 8B 44 24 48 31 F6 89 7C 24 0C 8B 7C 24 20 89 74 24 08 01 44 24 08 11 54 24 0C 01 7C 24 08 11 6C 24 0C 8B 44 24 0C 39 C5 72 14 77 08 8B 54 24 08 39 D7 76 0A 83 44 24 18 01 83 54 24 1C 00 8B 44 24 38 89 DE 89 CD F7 E3 89 44 24 20 8B 44 24 40 89 54 24 24 F7 E3 89 44 24 48 8B 44 24 38 89 54 24 4C F7 E1 89 54 24 3C 8B 5C 24 3C 31 D2 89 44 24 38 8B 44 24 20 89 D9 31 DB 89 4C 24 30 01 44 24 30 8B 44 24 40 89 5C 24 34 8B 5C 24 24 11 54 24 34 F7 E5 01 44 24 30 89 D9 11 54 24 34 31 DB 8B 54 24 34 89 4C 24 20 8B 4C 24 48 01 4C 24 20 89 5C 24 24 8B 5C 24 4C 89 D0 11 5C 24 24 31 D2 01 44 24 20 8B 44 24 28 11 54 24 24 F7 E6 89 C1 8B 44 24 58 89 D3 F7 E6 89 44 24 48 8B 44 24 28 89 54 24 4C F7 E5 89 54 24 2C 8B 7C 24 2C 31 D2 89 44 24 28 8B 44 24 58 C7 44 24 2C 00 00 00 00 89 FE 31 FF 01 CE 89 D9 11 D7 F7 E5 8B 6C 24 38 01 C6 8B 44 24 28 11 D7 31 DB 03 4C 24 48 13 5C 24 4C 31 D2 89 6C 24 28 01 F9 89 F7 11 D3 31 F6 31 D2 01 C6 8B 44 24 30 11 D7 89 C2 31 C0 03 44 24 28 13 54 24 2C 01 C8 11 DA 39 D3 72 10 77 04 39 C1 76 0A 83 44 24 20 01 83 54 24 24 00 8B 4C 24 08 8B 5C 24 0C 01 F1 11 FB 89 5C 24 0C 31 DB 3B 7C 24 0C 89 4C 24 08 B9 01 00 00 00 77 0C 72 06 3B 74 24 08 77 04 31 C9 31 DB 8B 74 24 18 01 C8 8B 7C 24 1C 11 DA 01 C6 11 D7 39 FA 89 74 24 18 89 7C 24 1C 0F 87 C8 02 00 00 72 08 39 F0 0F 87 BE 02 00 00 31 FF 39 D3 BE 01 00 00 00 77 0A 72 04 39 C1 77 04 31 F6 31 FF 03 74 24 20 13 7C 24 24 83 7C 24 5C 16 0F 8F A2 02 00 00 8B 5C 24 04 8B 6C 24 04 8B 54 24 1C 8B 44 24 18 8B 1C DD ?? ?? ?? ?? 8B 2C ED ?? ?? ?? ?? 89 5C 24 38 8B 5C 24 04 89 6C 24 30 8B 2C 9D ?? ?? ?? ?? 31 DB 89 E9 0F AD D0 D3 EA F6 C1 20 0F 45 C2 0F 45 D3 BB 40 00 00 00 29 EB 89 44 24 20 89 D9 89 F0 89 54 24 24 89 FA 8B 7C 24 24 0F A5 F2 31 F6 D3 E0 F6 C3 20 0F 45 D0 0F 45 C6 8B 74 24 20 09 D7 89 44 24 28 89 54 24 2C 09 C6 83 7C 24 5C 03 0F 8F A0 04 00 00 81 7C 24 0C 00 00 00 80 0F 87 58 03 00 00 72 0B 83 7C 24 08 00 0F 87 4B 03 00 00 8B 44 24 0C 05 00 00 00 80 0B 44 24 08 0F 84 16 04 00 00 90 8D 74 26 00 83 0D ?? ?? ?? ?? 20 E9 2E F9 FF FF 8B 4C 24 0C 8B 44 24 08 0F AF 04 F5 ?? ?? ?? ?? 0F AF 0C F5 ?? ?? ?? ?? 01 C1 8B 44 24 08 F7 24 F5 ?? ?? ?? ?? 01 CA 89 44 24 18 89 54 24 1C E9 78 F5 FF FF 83 FA 14 0F 84 98 03 00 00 8D 6A EC 8B 3C ED ?? ?? ?? ?? 89 7C 24 30 8B 44 24 30 BF 05 00 00 00 F7 E7 89 44 24 28 8B 04 ED ?? ?? ?? ?? 89 54 24 2C F7 E7 89 54 24 1C 8B 6C 24 1C 31 D2 89 44 24 18 8B 44 24 28 89 EF 31 ED 89 7C 24 38 01 44 24 38 8B 44 24 38 89 6C 24 3C 8B 6C 24 2C 11 54 24 3C 89 C2 31 C0 89 44 24 20 8B 44 24 18 89 EF 89 54 24 24 31 D2 01 44 24 20 11 54 24 24 31 ED 8B 54 24 30 8B 44 24 18 8D 14 92 89 54 24 28 8B 54 24 28 03 54 24 1C 01 C7 11 D5 8B 54 24 3C 89 D0 31 D2 01 C7 8B 44 24 08 11 D5 8B 54 24 0C 89 44 24 18 89 C8 89 54 24 1C 89 DA E9 EC F7 FF FF 83 FA 14 0F 84 A0 02 00 00 8B 2C D5 ?? ?? ?? ?? 8B 3C D5 ?? ?? ?? ?? 89 6C 24 3C 8B 6C 24 3C 89 7C 24 20 89 7C 24 38 BF FB FF FF FF 89 E8 F7 E7 89 44 24 28 B8 FF FF FF FF 89 54 24 2C F7 E5 89 44 24 18 8B 44 24 20 89 54 24 1C F7 E7 89 54 24 34 8B 6C 24 34 31 D2 89 44 24 30 8B 44 24 28 89 EF 31 ED 01 C7 B8 FF FF FF FF 11 D5 F7 64 24 20 01 C7 89 F8 11 D5 89 C2 B8 00 00 00 00 89 44 24 20 8B 44 24 30 89 54 24 24 31 D2 01 44 24 20 11 54 24 24 8B 44 24 38 8B 54 24 3C 0F A4 C2 02 C1 E0 02 01 44 24 18 11 54 24 1C 8B 54 24 2C 89 D0 31 D2 01 44 24 18 89 C8 11 54 24 1C 31 D2 8B 7C 24 08 01 6C 24 18 8B 6C 24 0C 11 54 24 1C 89 DA 89 7C 24 28 89 6C 24 2C E9 77 F9 FF FF BE 01 00 00 00 31 FF E9 4B FD FF FF 8B 5C 24 04 8B 2C 9D ?? ?? ?? ?? 8B 14 DD ?? ?? ?? ?? 8B 04 DD ?? ?? ?? ?? 89 E9 31 ED 83 E9 40 21 F2 21 F8 0F AD FE D3 EF F6 C1 20 0F 45 F7 0F 45 FD 89 DD 8B 1C DD ?? ?? ?? ?? 8B 0C ED ?? ?? ?? ?? 39 C8 0F 87 CE FD FF FF 72 08 39 DA 0F 87 C4 FD FF FF 31 C8 31 DA 09 D0 0F 85 B8 FD FF FF 8B 6C 24 1C 0B 6C 24 18 0F 85 AA FD FF FF 8B 44 24 0C 0B 44 24 08 0F 85 D7 01 00 00 8B 54 24 54 0B 54 24 50 0F 84 8E FD FF FF 8B 44 24 04 C1 E0 04 8B 90 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 39 44 24 0C 0F 85 AB F6 FF FF 39 54 24 08 0F 85 A1 F6 FF FF 8B 44 24 04 8B 4C 24 54 C1 E0 04 3B 88 ?? ?? ?? ?? 0F 82 8A F6 FF FF 0F 87 4A FD FF FF 8B 5C 24 50 3B 98 ?? ?? ?? ?? 0F 86 74 F6 FF FF E9 35 FD FF FF 90 8D 74 26 00 BF EC FF FF FF 8B 44 24 08 29 F7 8B 54 24 0C F7 D6 C1 E7 04 03 87 ?? ?? ?? ?? 89 74 24 04 13 97 ?? ?? ?? ?? 03 8F ?? ?? ?? ?? 13 9F ?? ?? ?? ?? E9 F9 F8 FF FF C1 E2 04 8B 74 24 0C 39 B2 ?? ?? ?? ?? 0F 87 E8 F6 FF FF 0F 82 D8 F3 FF FF 8B 7C 24 08 39 BA ?? ?? ?? ?? 0F 87 D2 F6 FF FF E9 C3 F3 FF FF 8B 4C 24 08 8B 5C 24 0C 8B 44 24 04 83 C1 00 81 D3 00 00 00 80 C1 E0 04 8B 90 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 39 C3 0F 87 A1 FC FF FF 72 08 39 D1 0F 87 97 FC FF FF 31 D8 31 CA 09 D0 90 0F 85 C4 F5 FF FF 8B 44 24 04 8B 54 24 54 C1 E0 04 3B 90 ?? ?? ?? ?? 0F 82 AD F5 FF FF 0F 87 6D FC FF FF 8B 4C 24 50 3B 88 ?? ?? ?? ?? 0F 82 97 F5 FF FF E9 58 FC FF FF 8B 7C 24 08 89 C8 89 DA 8B 6C 24 0C C7 44 24 20 FB FF FF FF C7 44 24 24 FF FF FF FF 89 7C 24 28 89 6C 24 2C C7 44 24 18 04 00 00 00 C7 44 24 1C 00 00 00 00 E9 72 F7 FF FF 8B 7C 24 08 89 C8 89 DA 8B 6C 24 0C C7 44 24 20 05 00 00 00 C7 44 24 24 00 00 00 00 89 7C 24 18 BF 05 00 00 00 89 6C 24 1C 31 ED E9 DA F4 FF FF 8B 44 24 54 0B 44 24 50 0F 84 E1 FB FF FF 8B 44 24 04 31 C9 31 DB C1 E0 04 8B 90 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? E9 2E FF FF FF 8B 44 24 04 C1 E0 04 8B 90 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 39 44 24 0C 0F 87 A8 FB FF FF 0F 82 27 FE FF FF 39 54 24 08 0F 87 98 FB FF FF E9 18 FE FF FF 8B 54 24 04 8B 5C 24 1C 23 5C 24 38 8B 4C 24 18 8B 04 D5 ?? ?? ?? ?? 8B 14 D5 ?? ?? ?? ?? 23 4C 24 30 89 44 24 18 39 D3 89 54 24 1C 77 75 72 04 39 C1 77 6F 3B 5C 24 1C 0F 85 55 FB FF FF 3B 4C 24 18 0F 85 4B FB FF FF 8B 5C 24 0C 0B 5C 24 08 75 0E 8B 6C 24 54 0B 6C 24 50 0F 84 33 FB FF FF 8B 44 24 04 C1 E0 04 8B 90 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 39 44 24 0C 0F 87 16 FB FF FF 72 0A 39 54 24 08 0F 87 0A FB FF FF 33 44 24 0C 33 54 24 08 09 D0 0F 85 34 F4 FF FF E9 8E FD FF FF 90 8D 74 26 00 89 C8 89 DA 2B 44 24 18 1B 54 24 1C 89 44 24 18 }
	condition:
		$1
}

rule file_16_0_0 {
	meta:
		name = "___powitf2"
		size = 464
		refs = "009e ___multf3 0182 ___divtf3"
	strings:
		$1 = { 55 31 ED 57 56 53 83 EC 6C 8B BC 24 A0 00 00 00 8B 9C 24 A0 00 00 00 8B 84 24 98 00 00 00 8B 8C 24 90 00 00 00 C1 FF 1F 8B 94 24 94 00 00 00 31 FB 8B B4 24 9C 00 00 00 29 FB 89 DF 83 E7 01 89 44 24 34 89 E8 0F 45 C1 89 44 24 44 89 E8 0F 45 6C 24 34 0F 45 C2 89 44 24 48 8B 44 24 34 8D 7C 24 50 89 6C 24 4C BD 00 00 FF 3F 0F 45 EE 89 6C 24 30 D1 EB 0F 84 B5 00 00 00 89 4C 24 20 89 54 24 24 89 44 24 28 89 74 24 2C 89 4C 24 10 89 54 24 14 89 44 24 18 89 74 24 1C 89 3C 24 E8 ?? ?? ?? ?? F6 C3 01 8B 4C 24 50 8B 54 24 54 8B 44 24 58 8B 74 24 5C 74 BB 8B 6C 24 44 89 4C 24 20 89 54 24 24 89 44 24 28 89 6C 24 10 8B 6C 24 48 89 74 24 2C 89 3C 24 89 44 24 38 89 6C 24 14 8B 6C 24 4C 89 54 24 3C 89 4C 24 40 89 6C 24 18 8B 6C 24 30 89 6C 24 1C E8 ?? ?? ?? ?? 8B 6C 24 50 D1 EB 8B 4C 24 40 8B 54 24 3C 8B 44 24 38 89 6C 24 44 8B 6C 24 54 89 6C 24 48 8B 6C 24 58 89 6C 24 4C 8B 6C 24 5C 89 6C 24 30 0F 85 4B FF FF FF 8B 84 24 A0 00 00 00 8B 6C 24 30 85 C0 79 64 8B 54 24 44 8D 44 24 50 8B 5C 24 48 89 6C 24 2C 89 04 24 89 54 24 20 8B 54 24 4C 89 5C 24 24 C7 44 24 10 00 00 00 00 C7 44 24 14 00 00 00 00 89 54 24 28 C7 44 24 18 00 00 00 00 C7 44 24 1C 00 00 FF 3F E8 ?? ?? ?? ?? 8B 6C 24 54 8B 5C 24 50 8B 44 24 58 89 6C 24 48 8B 6C 24 5C 89 5C 24 44 89 44 24 4C 8B 84 24 80 00 00 00 8B 54 24 44 8B 5C 24 48 89 68 0C 89 10 8B 54 24 4C 89 58 04 89 50 08 83 C4 6C 5B 5E 5F 5D C3 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_17_0_0 {
	meta:
		name = "___powidf2"
		size = 80
		refs = "0048 .rdata"
	strings:
		$1 = { 8B 54 24 0C DD 44 24 04 89 D1 C1 F9 1F 89 C8 31 D0 29 C8 A8 01 74 2B D9 C0 EB 07 90 8D 74 26 00 D9 C9 D1 E8 74 12 D9 C9 A8 01 D8 C8 74 F2 D1 E8 DC C9 75 F4 DD D8 EB 02 DD D9 85 D2 78 08 66 90 F3 C3 D9 E8 EB DC D8 3D ?? ?? ?? ?? C3 90 90 90 }
	condition:
		$1
}

rule file_18_0_0 {
	meta:
		name = "___muldc3"
		size = 1088
		refs = "01c4 .rdata"
	strings:
		$1 = { 53 83 EC 40 DD 44 24 4C DD 44 24 54 DD 44 24 5C DD 44 24 64 D9 C3 8B 54 24 48 D8 CA DD 5C 24 20 D9 C2 D8 C9 DD 5C 24 28 D9 C3 D8 C9 DD 5C 24 30 D9 C2 D8 CA DD 5C 24 38 DD 44 24 20 DD 44 24 28 DD 14 24 D8 E9 DD 44 24 30 DD 54 24 08 DD 44 24 38 DD 54 24 10 DE C1 D9 C9 DB E8 7A 36 DD DD DD DD DD D8 DD D8 DD D8 EB 1E DD DE DD DC DD D8 DD D8 DD D8 EB 12 DD D8 DD DB DD D8 DD DA EB 08 DD D8 DD DB DD D8 DD DA DD 1A 89 D0 DD 5A 08 83 C4 40 5B C3 D9 C9 DB E8 7B D0 D9 C6 D8 E7 DD 54 24 18 DF E8 7B 07 E9 99 02 00 00 D9 CE D9 C5 D8 E6 DD 54 24 18 DF E8 7B 07 E9 C5 01 00 00 D9 CD D9 CC 31 C0 DB E8 D9 C0 0F 9A C3 D8 E1 DD 54 24 18 DF E8 0F 8A 75 01 00 00 D9 CB EB 02 D9 CB DB E8 D9 C0 0F 9A C1 D8 E1 DD 54 24 18 DF E8 0F 8A E8 00 00 00 84 C0 0F 85 A1 00 00 00 D9 C2 D8 E3 DD 54 24 18 DF E8 0F 8A 1D 03 00 00 DD DA D9 C9 DD 04 24 D8 E0 DF E8 0F 8A FC 02 00 00 DD 44 24 08 D8 E0 DF E8 0F 8A DD 02 00 00 DD 44 24 10 D8 E0 DF E8 0F 8B 3D FF FF FF DD 44 24 10 DF E8 0F 8A 3B FF FF FF DD DB DD D8 D9 C9 D9 CB EB 1C DD DB DD D8 D9 C9 D9 CB EB 12 DD DB DD D8 D9 C9 D9 CB EB 08 DD D8 DD DA D9 C9 D9 CB DB E8 0F 8A 77 02 00 00 D9 CA EB 02 D9 CA DB E8 0F 8A 4D 02 00 00 84 DB 74 07 E9 24 02 00 00 D9 C9 84 C9 8D 76 00 0F 85 E5 01 00 00 D9 CA D9 CB EB 1C DD DC DD D8 DD D8 D9 C9 EB 12 D9 CA D9 CB EB 0C D9 CA D9 CB EB 06 D9 CA D9 CB D9 CA D9 C3 D8 CA D9 C3 D8 CA DE E9 D9 05 ?? ?? ?? ?? DC C9 D9 CD DE CA D9 CB DE CA DE C1 DE CA E9 AC FE FF FF 84 C9 0F 85 10 FF FF FF DD DC DD D8 DD D8 D9 E5 DF E0 DD D8 F6 C4 02 D9 EE 74 0A DD D8 D9 EE D9 E0 EB 02 D9 C9 D9 E8 D9 CA D9 E5 DF E0 DD D8 D9 C9 F6 C4 02 D9 E1 74 02 D9 E0 D9 CB DB E8 0F 8A C9 00 00 00 D9 CA EB 02 D9 CA DB E8 0F 8B 79 FF FF FF D9 E5 DF E0 DD D8 F6 C4 02 D9 EE 0F 84 6E FF FF FF DD D8 D9 EE D9 E0 D9 CA D9 CB E9 6B FF FF FF 84 DB 0F 85 87 FE FF FF DD DC DD D8 DD D8 D9 C9 D9 E5 DF E0 DD D8 F6 C4 02 D9 E8 74 06 DD D8 D9 E8 D9 E0 D9 C1 D8 E2 DF E8 0F 8A 8A 00 00 00 D9 EE D9 CA EB 82 D9 CD DB E8 0F 8A 31 FE FF FF D9 CE D9 E5 DF E0 DD D8 F6 C4 02 D9 EE 74 0C DD D8 D9 EE D9 E0 EB 04 D9 CE D9 CD D9 E8 DD 5C 24 18 D9 CE D9 E5 DF E0 DD D8 DD 44 24 18 F6 C4 02 D9 E1 74 06 D9 E0 D9 CC EB 02 D9 CC DB E8 7A 60 D9 CB EB 02 D9 CB DB E8 7A 41 D9 CB D9 CC D9 CD D9 CC B8 01 00 00 00 E9 DB FD FF FF D9 E5 DF E0 DD D8 F6 C4 02 D9 EE 0F 84 2A FF FF FF DD D8 D9 EE D9 E0 D9 CA E9 1F FF FF FF D9 C9 DB E8 0F 8B EE FE FF FF D9 C9 E9 65 FF FF FF D9 E5 DF E0 DD D8 F6 C4 02 D9 EE 74 B2 DD D8 D9 EE D9 E0 EB AA D9 E5 DF E0 DD D8 F6 C4 02 D9 EE 74 97 DD D8 D9 EE D9 E0 D9 CB EB 8F D9 CE DB E8 0F 8A 5D FD FF FF D9 E5 DF E0 DD D8 F6 C4 02 D9 E8 74 06 DD D8 D9 E8 D9 E0 D9 C5 D8 E6 DD 54 24 18 DF E8 7A 33 D9 EE DD 5C 24 18 D9 CE D9 CD E9 34 FF FF FF D9 CB D9 E5 DF E0 DD D8 F6 C4 02 D9 EE 0F 84 24 FE FF FF DD D8 D9 EE D9 E0 D9 CA D9 CB D9 CA E9 19 FE FF FF D9 CD DB E8 0F 8B FA FE FF FF D9 CD EB BF D9 C9 D9 E5 DF E0 DD D8 F6 C4 02 D9 EE 0F 84 C9 FD FF FF DD D8 D9 EE D9 E0 D9 C9 E9 BE FD FF FF D9 E5 DF E0 DD D8 F6 C4 02 D9 EE 0F 84 A2 FD FF FF DD D8 D9 EE D9 E0 E9 97 FD FF FF D9 E5 DF E0 DD D8 F6 C4 02 D9 EE 0F 84 7C FD FF FF DD D8 D9 EE D9 E0 D9 CA E9 71 FD FF FF DD 44 24 08 DF E8 0F 8B 3B FD FF FF E9 12 FD FF FF DD 04 24 DF E8 0F 8B 35 FD FF FF E9 F4 FC FF FF D9 CA DF E8 0F 8B 30 FD FF FF D9 C9 E9 D6 FC FF FF 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_20_0_0 {
	meta:
		name = "___fixdfdi"
		size = 64
		refs = "0026 ___fixunsdfdi"
	strings:
		$1 = { 83 EC 1C DD 44 24 20 D9 EE DF E9 77 13 DD 5C 24 20 83 C4 1C E9 ?? ?? ?? ?? 8D B4 26 00 00 00 00 D9 E0 DD 1C 24 E8 ?? ?? ?? ?? F7 D8 83 D2 00 83 C4 1C F7 DA C3 90 90 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_21_0_0 {
	meta:
		name = "___bid_floatunssidd"
		size = 32
		refs = "000b ___bid64_from_uint32"
	strings:
		$1 = { 83 EC 1C 8B 44 24 20 89 04 24 E8 ?? ?? ?? ?? 83 C4 1C C3 90 90 90 90 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_188_0_0 {
	meta:
		name = "___bid_extendsddd2"
		size = 32
		refs = "000b ___bid32_to_bid64"
	strings:
		$1 = { 83 EC 1C 8B 44 24 20 89 04 24 E8 ?? ?? ?? ?? 83 C4 1C C3 90 90 90 90 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_198_0_0 {
	meta:
		name = "___bid_floatsidd"
		size = 32
		refs = "000b ___bid64_from_int32"
	strings:
		$1 = { 83 EC 1C 8B 44 24 20 89 04 24 E8 ?? ?? ?? ?? 83 C4 1C C3 90 90 90 90 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_264_0_2 {
	meta:
		name = "_ftello"
		size = 32
		refs = "000b _ftello64"
	strings:
		$1 = { 83 EC 1C 8B 44 24 20 89 04 24 E8 ?? ?? ?? ?? 83 C4 1C C3 90 90 90 90 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_22_0_0 {
	meta:
		name = "___bid_fixsdsi"
		size = 32
		refs = "000b ___bid32_to_bid64 0017 ___bid64_to_int32_xint"
	strings:
		$1 = { 83 EC 1C 8B 44 24 20 89 04 24 E8 ?? ?? ?? ?? 89 04 24 89 54 24 04 E8 ?? ?? ?? ?? 83 C4 1C C3 90 }
	condition:
		$1
}

rule file_165_0_0 {
	meta:
		name = "___bid_fixsddi"
		size = 32
		refs = "000b ___bid32_to_bid64 0017 ___bid64_to_int64_xint"
	strings:
		$1 = { 83 EC 1C 8B 44 24 20 89 04 24 E8 ?? ?? ?? ?? 89 04 24 89 54 24 04 E8 ?? ?? ?? ?? 83 C4 1C C3 90 }
	condition:
		$1
}

rule file_131_0_0 {
	meta:
		name = "___bid_floatsisd"
		size = 32
		refs = "000b ___bid64_from_int32 0017 ___bid64_to_bid32"
	strings:
		$1 = { 83 EC 1C 8B 44 24 20 89 04 24 E8 ?? ?? ?? ?? 89 04 24 89 54 24 04 E8 ?? ?? ?? ?? 83 C4 1C C3 90 }
	condition:
		$1
}

rule file_115_0_0 {
	meta:
		name = "___bid_floatunssisd"
		size = 32
		refs = "000b ___bid64_from_uint32 0017 ___bid64_to_bid32"
	strings:
		$1 = { 83 EC 1C 8B 44 24 20 89 04 24 E8 ?? ?? ?? ?? 89 04 24 89 54 24 04 E8 ?? ?? ?? ?? 83 C4 1C C3 90 }
	condition:
		$1
}

rule file_124_0_0 {
	meta:
		name = "_isinfd32"
		size = 32
		refs = "000b ___bid32_to_bid64 0017 ___bid64_isInf"
	strings:
		$1 = { 83 EC 1C 8B 44 24 20 89 04 24 E8 ?? ?? ?? ?? 89 04 24 89 54 24 04 E8 ?? ?? ?? ?? 83 C4 1C C3 90 }
	condition:
		$1
}

rule file_23_0_0 {
	meta:
		name = "___addvsi3"
		size = 48
		refs = "0028 _abort"
	strings:
		$1 = { 83 EC 0C 8B 4C 24 14 8B 54 24 10 85 C9 8D 04 11 78 0E 39 D0 0F 9C C2 84 D2 75 0C 83 C4 0C C3 90 39 D0 0F 9F C2 EB F0 E8 ?? ?? ?? ?? 90 90 90 90 }
	condition:
		$1
}

rule file_24_0_0 {
	meta:
		name = "___extendxftf2"
		size = 336
	strings:
		$1 = { 83 EC 4C DB 6C 24 54 89 5C 24 3C 89 74 24 40 8B 44 24 50 DB 7C 24 10 0F B7 4C 24 18 0F B6 5C 24 19 89 7C 24 44 8B 7C 24 10 89 6C 24 48 8B 6C 24 14 66 81 E1 FF 7F 0F B7 F1 8D 56 01 81 E2 FF 7F 00 00 C0 EB 07 83 FA 01 7E 66 89 FE 89 EA C1 EE 0F C1 E2 11 09 D6 C1 E7 11 C1 ED 0F 0F B7 54 24 2E C1 E3 07 66 89 6C 24 2C 66 81 E2 00 80 09 CA 66 89 54 24 2E 66 C1 EA 08 83 E2 7F 09 DA 88 54 24 2F 8B 54 24 2C 89 78 04 8B 5C 24 3C 89 70 08 8B 7C 24 44 C7 00 00 00 00 00 8B 74 24 40 89 50 0C 8B 6C 24 48 83 C4 4C C3 8D B4 26 00 00 00 00 85 F6 89 EA 74 5A 09 FA 74 76 89 E9 89 FE C1 E9 0F 89 EA 66 89 4C 24 2C 0F B7 4C 24 2E C1 E2 11 C1 EE 0F C1 E3 07 09 D6 C1 E7 11 66 81 C9 FF 7F 66 89 4C 24 2E 66 C1 E9 08 83 E1 7F 09 D9 81 E5 00 00 00 40 88 4C 24 2F 8B 54 24 2C 75 88 D9 EE D8 F0 DD D8 9B E9 7C FF FF FF 8D B6 00 00 00 00 09 FA 74 2C 89 FE 89 EA C1 EE 0F 31 C9 C1 E2 11 09 D6 C1 E7 11 C1 ED 0F E9 2F FF FF FF 8D 76 00 B9 FF 7F 00 00 31 ED 31 F6 31 FF E9 1C FF FF FF 31 C9 31 ED 31 F6 31 FF E9 0F FF FF FF 90 90 90 }
	condition:
		$1
}

rule file_25_0_0 {
	meta:
		name = "___bid_gtsd2"
		size = 80
		refs = "001b ___bid32_to_bid64 003b ___bid64_quiet_greater"
	strings:
		$1 = { 83 EC 1C 8B 44 24 20 89 5C 24 10 8B 5C 24 24 89 74 24 14 89 7C 24 18 89 04 24 E8 ?? ?? ?? ?? 89 1C 24 89 C6 89 D7 E8 ?? ?? ?? ?? 89 34 24 89 7C 24 04 89 44 24 08 89 54 24 0C E8 ?? ?? ?? ?? 8B 5C 24 10 8B 74 24 14 8B 7C 24 18 83 C4 1C C3 90 }
	condition:
		$1
}

rule file_29_0_0 {
	meta:
		name = "___bid_nesd2"
		size = 80
		refs = "001b ___bid32_to_bid64 003b ___bid64_quiet_not_equal"
	strings:
		$1 = { 83 EC 1C 8B 44 24 20 89 5C 24 10 8B 5C 24 24 89 74 24 14 89 7C 24 18 89 04 24 E8 ?? ?? ?? ?? 89 1C 24 89 C6 89 D7 E8 ?? ?? ?? ?? 89 34 24 89 7C 24 04 89 44 24 08 89 54 24 0C E8 ?? ?? ?? ?? 8B 5C 24 10 8B 74 24 14 8B 7C 24 18 83 C4 1C C3 90 }
	condition:
		$1
}

rule file_108_0_0 {
	meta:
		name = "___bid_unordsd2"
		size = 80
		refs = "001b ___bid32_to_bid64 003b ___bid64_quiet_unordered"
	strings:
		$1 = { 83 EC 1C 8B 44 24 20 89 5C 24 10 8B 5C 24 24 89 74 24 14 89 7C 24 18 89 04 24 E8 ?? ?? ?? ?? 89 1C 24 89 C6 89 D7 E8 ?? ?? ?? ?? 89 34 24 89 7C 24 04 89 44 24 08 89 54 24 0C E8 ?? ?? ?? ?? 8B 5C 24 10 8B 74 24 14 8B 7C 24 18 83 C4 1C C3 90 }
	condition:
		$1
}

rule file_26_0_0 {
	meta:
		name = "___bid_ltsd2"
		size = 96
		refs = "001b ___bid32_to_bid64 003b ___bid64_quiet_less"
	strings:
		$1 = { 83 EC 1C 8B 44 24 20 89 5C 24 10 8B 5C 24 24 89 74 24 14 89 7C 24 18 89 04 24 E8 ?? ?? ?? ?? 89 1C 24 89 C6 89 D7 E8 ?? ?? ?? ?? 89 34 24 89 7C 24 04 89 44 24 08 89 54 24 0C E8 ?? ?? ?? ?? 8B 5C 24 10 8B 74 24 14 8B 7C 24 18 83 C4 1C F7 D8 C3 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_27_0_0 {
	meta:
		name = "___bid64qq_mul"
		size = 912
		refs = "02a2 ___bid64qqq_fma"
	strings:
		$1 = { 55 57 56 53 81 EC 9C 00 00 00 8B 84 24 B0 00 00 00 C7 84 24 80 00 00 00 00 00 00 00 C7 84 24 84 00 00 00 00 00 00 00 C7 84 24 88 00 00 00 00 00 00 00 89 44 24 70 8B 84 24 B4 00 00 00 C7 84 24 8C 00 00 00 00 00 FE 5F 89 44 24 74 8B 84 24 B8 00 00 00 89 44 24 78 8B 84 24 BC 00 00 00 89 44 24 7C 8B 84 24 C0 00 00 00 8B 54 24 7C 89 44 24 60 8B 84 24 C4 00 00 00 89 D1 81 E1 00 00 00 7C 81 F9 00 00 00 7C 89 44 24 64 8B 84 24 C8 00 00 00 89 44 24 68 8B 84 24 CC 00 00 00 8B 74 24 68 89 44 24 6C 8B 44 24 78 8B 7C 24 6C 0F 84 84 01 00 00 89 FB 81 E3 00 00 00 7C 81 FB 00 00 00 7C 0F 84 70 01 00 00 81 F9 00 00 00 78 0F 84 64 01 00 00 81 FB 00 00 00 78 0F 84 58 01 00 00 8B 4C 24 70 8B 5C 24 74 89 4C 24 48 89 D1 81 E1 00 00 00 60 81 F9 00 00 00 60 89 5C 24 4C 0F 84 23 02 00 00 89 D3 89 D5 81 E3 FF FF 01 00 81 E5 00 00 FE 7F 81 FB 09 ED 01 00 89 44 24 38 89 5C 24 3C 0F 86 8B 01 00 00 C7 44 24 48 00 00 00 00 C7 44 24 4C 00 00 00 00 C7 44 24 38 00 00 00 00 C7 44 24 3C 00 00 00 00 8B 4C 24 60 8B 5C 24 64 89 4C 24 50 89 F9 81 E1 00 00 00 60 81 F9 00 00 00 60 89 5C 24 54 0F 84 EE 01 00 00 89 FB 89 F9 81 E3 FF FF 01 00 81 E1 00 00 FE 7F 81 FB 09 ED 01 00 89 74 24 40 89 5C 24 44 77 16 0F 82 60 01 00 00 81 FE C0 87 AD BE 0F 86 54 01 00 00 8D 74 26 00 C7 44 24 50 00 00 00 00 C7 44 24 54 00 00 00 00 C7 44 24 40 00 00 00 00 C7 44 24 44 00 00 00 00 89 EB C1 EB 11 C1 E9 11 8D AC 0B C0 CF FF FF 31 C9 31 DB 81 FD 72 FE FF FF 7C 1C 31 C9 81 FD 71 01 00 00 BB 00 00 E0 5F 7F 0D 8D 8D 8E 01 00 00 89 CB 31 C9 C1 E3 15 8B 6C 24 3C 0B 6C 24 38 75 0A 8B 6C 24 4C 0B 6C 24 48 74 14 8B 6C 24 44 0B 6C 24 40 75 21 8B 6C 24 54 0B 6C 24 50 75 17 31 FA 81 C4 9C 00 00 00 81 E2 00 00 00 80 89 C8 09 DA 5B 5E 5F 5D C3 8B 84 24 80 00 00 00 89 44 24 20 8B 84 24 84 00 00 00 89 44 24 24 8B 84 24 88 00 00 00 89 44 24 28 8B 84 24 8C 00 00 00 89 44 24 2C 8B 44 24 70 89 44 24 10 8B 44 24 74 89 44 24 14 8B 44 24 78 89 44 24 18 8B 44 24 7C 89 44 24 1C 8B 44 24 60 89 04 24 8B 44 24 64 89 44 24 04 8B 44 24 68 89 44 24 08 8B 44 24 6C 89 44 24 0C E8 ?? ?? ?? ?? 81 C4 9C 00 00 00 5B 5E 5F 5D C3 72 0B 3D C0 87 AD BE 0F 87 68 FE FF FF 8B 5C 24 3C 8B 4C 24 38 81 F3 09 ED 01 00 81 F1 C0 87 AD BE 09 CB 0F 85 6C FE FF FF 81 7C 24 4C 63 8E 8D 37 0F 87 3E FE FF FF E9 59 FE FF FF 8D 76 00 8B 5C 24 44 81 F3 09 ED 01 00 89 5C 24 5C 8B 5C 24 40 81 F3 C0 87 AD BE 0B 5C 24 5C 0F 85 AE FE FF FF 81 7C 24 54 63 8E 8D 37 0F 87 80 FE FF FF E9 9B FE FF FF 89 D3 0F A4 C3 02 89 DD 81 E5 00 00 FE 7F C7 44 24 48 00 00 00 00 C7 44 24 4C 00 00 00 00 C7 44 24 38 00 00 00 00 C7 44 24 3C 00 00 00 00 E9 EE FD FF FF 89 FB 0F A4 F3 02 89 D9 81 E1 00 00 FE 7F C7 44 24 50 00 00 00 00 C7 44 24 54 00 00 00 00 C7 44 24 40 00 00 00 00 C7 44 24 44 00 00 00 00 E9 35 FE FF FF 90 8D 74 26 00 }
	condition:
		$1
}

rule file_27_1_0 {
	meta:
		name = "___bid64qd_mul"
		size = 144
		refs = "003b ___bid64_to_bid128"
	strings:
		$1 = { 83 EC 4C 8B 44 24 50 8D 4C 24 30 8B 54 24 64 89 0C 24 89 44 24 20 8B 44 24 54 89 54 24 08 89 44 24 24 8B 44 24 58 89 44 24 28 8B 44 24 5C 89 44 24 2C 8B 44 24 60 89 44 24 04 E8 ?? ?? ?? ?? 8B 44 24 30 89 44 24 10 8B 44 24 34 89 44 24 14 8B 44 24 38 89 44 24 18 8B 44 24 3C 89 44 24 1C 8B 44 24 20 89 04 24 8B 44 24 24 89 44 24 04 8B 44 24 28 89 44 24 08 8B 44 24 2C 89 44 24 0C E8 ED FB FF FF 83 C4 4C C3 89 F6 8D BC 27 00 00 00 00 }
	condition:
		$1
}

rule file_27_2_0 {
	meta:
		name = "___bid64dq_mul"
		size = 144
		refs = "003b ___bid64_to_bid128"
	strings:
		$1 = { 83 EC 4C 8B 44 24 58 8D 4C 24 30 8B 54 24 54 89 0C 24 89 44 24 20 8B 44 24 5C 89 54 24 08 89 44 24 24 8B 44 24 60 89 44 24 28 8B 44 24 64 89 44 24 2C 8B 44 24 50 89 44 24 04 E8 ?? ?? ?? ?? 8B 44 24 20 89 44 24 10 8B 44 24 24 89 44 24 14 8B 44 24 28 89 44 24 18 8B 44 24 2C 89 44 24 1C 8B 44 24 30 89 04 24 8B 44 24 34 89 44 24 04 8B 44 24 38 89 44 24 08 8B 44 24 3C 89 44 24 0C E8 5D FB FF FF 83 C4 4C C3 89 F6 8D BC 27 00 00 00 00 }
	condition:
		$1
}

rule file_27_3_0 {
	meta:
		name = "___bid128_mul"
		size = 1088
		refs = "0317 ___bid128_fma"
	strings:
		$1 = { 55 57 56 53 81 EC BC 00 00 00 8B 84 24 D4 00 00 00 8B AC 24 D0 00 00 00 C7 84 24 90 00 00 00 00 00 00 00 C7 84 24 94 00 00 00 00 00 00 00 89 84 24 80 00 00 00 8B 84 24 D8 00 00 00 C7 84 24 98 00 00 00 00 00 00 00 C7 84 24 9C 00 00 00 00 00 FE 5F 89 84 24 84 00 00 00 8B 84 24 DC 00 00 00 89 84 24 88 00 00 00 8B 84 24 E0 00 00 00 8B B4 24 88 00 00 00 89 84 24 8C 00 00 00 8B 84 24 E4 00 00 00 8B BC 24 8C 00 00 00 89 44 24 70 8B 84 24 E8 00 00 00 89 44 24 74 8B 84 24 EC 00 00 00 89 44 24 78 8B 84 24 F0 00 00 00 8B 4C 24 78 89 44 24 7C 89 F8 8B 5C 24 7C 25 00 00 00 7C 3D 00 00 00 7C 0F 84 CB 01 00 00 89 DA 81 E2 00 00 00 7C 81 FA 00 00 00 7C 0F 84 B7 01 00 00 3D 00 00 00 78 0F 84 AC 01 00 00 81 FA 00 00 00 78 0F 84 A0 01 00 00 8B 84 24 80 00 00 00 8B 94 24 84 00 00 00 89 44 24 58 89 F8 25 00 00 00 60 3D 00 00 00 60 89 54 24 5C 0F 84 A9 02 00 00 89 FA 89 F8 81 E2 FF FF 01 00 25 00 00 FE 7F 81 FA 09 ED 01 00 89 74 24 40 89 54 24 44 89 44 24 50 0F 86 0D 02 00 00 C7 44 24 58 00 00 00 00 C7 44 24 5C 00 00 00 00 C7 44 24 40 00 00 00 00 C7 44 24 44 00 00 00 00 8B 44 24 70 8B 54 24 74 89 44 24 60 89 D8 25 00 00 00 60 3D 00 00 00 60 89 54 24 64 0F 84 7B 02 00 00 89 DA 89 D8 81 E2 FF FF 01 00 25 00 00 FE 7F 81 FA 09 ED 01 00 89 4C 24 48 89 54 24 4C 77 12 0F 82 E6 01 00 00 81 F9 C0 87 AD BE 0F 86 DA 01 00 00 C7 44 24 60 00 00 00 00 C7 44 24 64 00 00 00 00 C7 44 24 48 00 00 00 00 C7 44 24 4C 00 00 00 00 8B 54 24 50 C1 E8 11 C7 44 24 50 00 00 00 00 C7 44 24 54 00 00 00 00 C1 EA 11 8D 84 02 C0 CF FF FF 3D E0 E7 FF FF 7C 3C 3D DF 17 00 00 C7 44 24 50 00 00 00 00 C7 44 24 54 00 00 FE 5F 7F 25 05 20 18 00 00 89 44 24 50 89 C2 8B 44 24 50 C1 FA 1F 89 54 24 54 89 C2 31 C0 C1 E2 11 89 44 24 50 89 54 24 54 8B 54 24 44 0B 54 24 40 75 0A 8B 44 24 5C 0B 44 24 58 74 14 8B 54 24 4C 0B 54 24 48 75 3C 8B 44 24 64 0B 44 24 60 75 32 89 F8 8B 54 24 50 31 D8 25 00 00 00 80 0B 44 24 54 C7 45 00 00 00 00 00 C7 45 04 00 00 00 00 89 45 0C 89 E8 89 55 08 81 C4 BC 00 00 00 5B 5E 5F 5D C3 8B 94 24 90 00 00 00 8D 84 24 A0 00 00 00 89 04 24 89 54 24 24 8B 94 24 94 00 00 00 89 54 24 28 8B 94 24 98 00 00 00 89 54 24 2C 8B 94 24 9C 00 00 00 89 54 24 30 8B 94 24 80 00 00 00 89 54 24 14 8B 94 24 84 00 00 00 89 54 24 18 8B 94 24 88 00 00 00 89 54 24 1C 8B 94 24 8C 00 00 00 89 54 24 20 8B 54 24 70 89 54 24 04 8B 54 24 74 89 54 24 08 8B 54 24 78 89 54 24 0C 8B 54 24 7C 89 54 24 10 E8 ?? ?? ?? ?? 8B 84 24 A0 00 00 00 8B 94 24 A4 00 00 00 89 45 00 8B 84 24 A8 00 00 00 89 55 04 8B 94 24 AC 00 00 00 89 45 08 89 E8 89 55 0C 81 C4 BC 00 00 00 5B 5E 5F 5D C3 72 0C 81 FE C0 87 AD BE 0F 87 E5 FD FF FF 8B 54 24 44 8B 44 24 40 81 F2 09 ED 01 00 35 C0 87 AD BE 09 C2 0F 85 EA FD FF FF 81 7C 24 5C 63 8E 8D 37 0F 87 BC FD FF FF E9 D7 FD FF FF 8D 74 26 00 8B 54 24 4C 81 F2 09 ED 01 00 89 54 24 6C 8B 54 24 48 81 F2 C0 87 AD BE 0B 54 24 6C 0F 85 24 FE FF FF 81 7C 24 64 63 8E 8D 37 0F 87 F6 FD FF FF E9 11 FE FF FF 89 FA 0F A4 F2 02 81 E2 00 00 FE 7F 89 54 24 50 C7 44 24 58 00 00 00 00 C7 44 24 5C 00 00 00 00 C7 44 24 40 00 00 00 00 C7 44 24 44 00 00 00 00 E9 69 FD FF FF 8D B6 00 00 00 00 89 DA 0F A4 CA 02 89 D0 25 00 00 FE 7F C7 44 24 60 00 00 00 00 C7 44 24 64 00 00 00 00 C7 44 24 48 00 00 00 00 C7 44 24 4C 00 00 00 00 E9 A4 FD FF FF 8D B4 26 00 00 00 00 8D BC 27 00 00 00 00 }
	condition:
		$1
}

rule file_27_4_0 {
	meta:
		name = "___bid128qd_mul"
		size = 192
		refs = "0049 ___bid64_to_bid128"
	strings:
		$1 = { 53 83 EC 68 8B 44 24 74 8D 4C 24 50 8B 94 24 88 00 00 00 89 0C 24 8B 5C 24 70 89 44 24 30 8B 44 24 78 89 54 24 08 89 44 24 34 8B 44 24 7C 89 44 24 38 8B 84 24 80 00 00 00 89 44 24 3C 8B 84 24 84 00 00 00 89 44 24 04 E8 ?? ?? ?? ?? 8B 54 24 50 8D 44 24 40 89 04 24 89 54 24 14 8B 54 24 54 89 54 24 18 8B 54 24 58 89 54 24 1C 8B 54 24 5C 89 54 24 20 8B 54 24 30 89 54 24 04 8B 54 24 34 89 54 24 08 8B 54 24 38 89 54 24 0C 8B 54 24 3C 89 54 24 10 E8 27 FB FF FF 8B 44 24 40 8B 54 24 44 89 03 8B 44 24 48 89 53 04 8B 54 24 4C 89 43 08 89 D8 89 53 0C 83 C4 68 5B C3 90 8D 74 26 00 }
	condition:
		$1
}

rule file_27_5_0 {
	meta:
		name = "___bid128dq_mul"
		size = 192
		refs = "0049 ___bid64_to_bid128"
	strings:
		$1 = { 53 83 EC 68 8B 44 24 7C 8D 4C 24 50 8B 54 24 78 89 0C 24 8B 5C 24 70 89 44 24 30 8B 84 24 80 00 00 00 89 54 24 08 89 44 24 34 8B 84 24 84 00 00 00 89 44 24 38 8B 84 24 88 00 00 00 89 44 24 3C 8B 44 24 74 89 44 24 04 E8 ?? ?? ?? ?? 8B 54 24 30 8D 44 24 40 89 04 24 89 54 24 14 8B 54 24 34 89 54 24 18 8B 54 24 38 89 54 24 1C 8B 54 24 3C 89 54 24 20 8B 54 24 50 89 54 24 04 8B 54 24 54 89 54 24 08 8B 54 24 58 89 54 24 0C 8B 54 24 5C 89 54 24 10 E8 67 FA FF FF 8B 44 24 40 8B 54 24 44 89 03 8B 44 24 48 89 53 04 8B 54 24 4C 89 43 08 89 D8 89 53 0C 83 C4 68 5B C3 90 8D 74 26 00 }
	condition:
		$1
}

rule file_27_6_0 {
	meta:
		name = "___bid128dd_mul"
		size = 208
		refs = "0036 ___bid64_to_bid128"
	strings:
		$1 = { 83 EC 6C 8B 54 24 74 8D 44 24 40 8B 4C 24 78 89 74 24 64 8B 74 24 7C 89 7C 24 68 8B BC 24 80 00 00 00 89 54 24 04 89 4C 24 08 89 04 24 89 5C 24 60 8B 5C 24 70 E8 ?? ?? ?? ?? 8D 44 24 50 89 74 24 04 89 7C 24 08 89 04 24 E8 ?? ?? ?? ?? 8B 54 24 50 8D 44 24 30 89 04 24 89 54 24 14 8B 54 24 54 89 54 24 18 8B 54 24 58 89 54 24 1C 8B 54 24 5C 89 54 24 20 8B 54 24 40 89 54 24 04 8B 54 24 44 89 54 24 08 8B 54 24 48 89 54 24 0C 8B 54 24 4C 89 54 24 10 E8 A6 F9 FF FF 8B 44 24 30 8B 54 24 34 8B 74 24 64 8B 7C 24 68 89 03 8B 44 24 38 89 53 04 8B 54 24 3C 89 43 08 89 D8 89 53 0C 8B 5C 24 60 83 C4 6C C3 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_28_0_0 {
	meta:
		name = "___unordtf2"
		size = 160
	strings:
		$1 = { 83 EC 4C 8B 54 24 60 8B 44 24 5C 89 6C 24 48 89 5C 24 3C 8B 5C 24 58 89 54 24 04 8B 54 24 64 0F B7 C8 C1 E8 10 66 25 FF 7F 89 54 24 08 8B 54 24 68 89 74 24 40 8B 74 24 50 89 7C 24 44 8B 7C 24 54 89 54 24 0C 8B 54 24 6C 0F B7 EA C1 EA 10 66 81 E2 FF 7F 66 3D FF 7F 74 36 66 81 FA FF 7F 74 16 31 C0 8B 5C 24 3C 8B 74 24 40 8B 7C 24 44 8B 6C 24 48 83 C4 4C C3 8B 44 24 08 0B 44 24 04 0B 44 24 0C 09 E8 74 DA B8 01 00 00 00 EB D5 66 90 09 FE B8 01 00 00 00 09 DE 09 CE 74 BD EB C4 90 }
	condition:
		$1
}

rule file_31_0_0 {
	meta:
		name = "___fixunstfdi"
		size = 496
	strings:
		$1 = { 83 EC 6C 89 74 24 60 8B 74 24 7C 8B 44 24 70 8B 4C 24 74 8B 54 24 78 89 7C 24 64 89 F7 C1 EF 10 89 6C 24 68 0F B7 EE 81 E7 FF 7F 00 00 89 74 24 1C C1 EE 18 89 5C 24 5C 89 F3 C0 EB 07 81 FF FE 3F 00 00 89 44 24 10 89 4C 24 14 89 54 24 18 89 44 24 04 89 44 24 20 89 4C 24 24 89 54 24 28 89 6C 24 2C 7F 3B 85 FF BE 20 00 00 00 74 49 31 C0 31 D2 85 F6 74 0F D9 74 24 30 66 83 4C 24 34 20 D9 64 24 30 9B 8B 5C 24 5C 8B 74 24 60 8B 7C 24 64 8B 6C 24 68 83 C4 6C C3 8D B4 26 00 00 00 00 84 DB 74 25 B8 FF FF FF FF BA FF FF FF FF D9 EE D8 F0 DD D8 9B EB CE 09 C8 09 D0 09 E8 83 F8 01 19 F6 F7 D6 83 E6 20 EB A5 81 FF 3E 40 00 00 7E 06 31 C0 31 D2 EB D7 89 EA 8B 5C 24 04 BD 6F 40 00 00 29 FD 31 C9 89 E8 31 F6 C1 F8 05 83 C1 01 81 CA 00 00 01 00 09 DE 39 C8 89 54 24 2C 7E 0D 8B 5C 8C 20 83 C1 01 09 DE 39 C8 7F F3 85 C0 B9 01 00 00 00 0F 4F C8 83 E5 1F 89 6C 24 04 75 53 B9 03 00 00 00 29 C1 8D 54 24 20 8D 5C 8C 24 8B 0C 82 89 0A 83 C2 04 39 DA 75 F4 BB 04 00 00 00 29 C3 C7 44 9C 20 00 00 00 00 83 C3 01 83 FB 03 7E F0 8B 44 24 24 83 FE 01 8B 4C 24 20 19 F6 31 DB F7 D6 83 E6 20 89 C2 31 C0 01 C8 11 DA E9 FF FE FF FF 8B 5C 8C 20 BD 20 00 00 00 2B 6C 24 04 89 E9 D3 E3 B9 03 00 00 00 09 DE 29 C1 89 4C 24 0C 74 4E 8D 5C 8C 20 89 F7 8D 54 24 20 89 5C 24 08 8B 5C 82 04 89 E9 8B 34 82 D3 E3 0F B6 4C 24 04 D3 EE 09 F3 89 1A 83 C2 04 3B 54 24 08 75 E1 8B 54 24 2C BB 04 00 00 00 89 FE 29 C3 0F B6 4C 24 04 8B 44 24 0C D3 EA 89 54 84 20 E9 61 FF FF FF BB 01 00 00 00 EB E5 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_32_0_0 {
	meta:
		name = "_nr_digits256"
		size = 656
		refs = "0046 ___bid_ten2k256 0105 ___bid_ten2k64 0161 ___bid_ten2k128"
	strings:
		$1 = { 55 57 56 53 83 EC 4C 8B 44 24 60 8B 4C 24 64 8B 5C 24 7C 8B 7C 24 78 89 44 24 18 8B 44 24 68 89 4C 24 14 8B 4C 24 70 8B 6C 24 6C 89 44 24 10 89 D8 09 F8 89 4C 24 0C 8B 4C 24 74 0F 84 9F 00 00 00 89 6C 24 1C BA ?? ?? ?? ?? B8 01 00 00 00 89 CD 8B 4A 04 8B 32 39 D9 72 11 76 0B 83 C0 27 83 C4 4C 5B 5E 5F 5D C3 39 FE 77 F1 31 D9 31 FE 09 F1 74 15 83 C0 01 83 C2 20 83 F8 1E 75 D3 83 C4 4C B0 45 5B 5E 5F 5D C3 8B 4A FC 8B 72 F8 39 E9 72 08 77 C8 3B 74 24 0C 77 C2 33 74 24 0C 31 E9 09 F1 75 CF 8B 4A F4 3B 4C 24 1C 8B 72 F0 72 08 77 AA 3B 74 24 10 77 A4 33 4C 24 1C 33 74 24 10 09 F1 75 AF 8B 4C 24 14 39 4A EC 72 A6 77 8D 8B 4C 24 18 39 4A E8 76 9B EB 82 8D B6 00 00 00 00 8B 44 24 0C 09 C8 75 48 8B 4C 24 10 09 E9 75 70 B8 01 00 00 00 8B 4C 24 18 8B 54 24 14 EB 1C 90 72 0D 39 0C C5 ?? ?? ?? ?? 0F 87 50 FF FF FF 83 C0 01 83 F8 14 0F 84 44 FF FF FF 39 14 C5 ?? ?? ?? ?? 76 DC 83 C4 4C 5B 5E 5F 5D C3 8D 74 26 00 A1 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 39 C8 77 11 0F 82 90 00 00 00 3B 54 24 0C 0F 86 86 00 00 00 90 83 C4 4C B8 27 00 00 00 5B 5E 5F 5D C3 8D 76 00 A1 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 39 E8 77 59 72 06 3B 54 24 10 77 51 33 54 24 10 31 E8 09 D0 74 2D 8B 7C 24 14 BA ?? ?? ?? ?? B8 01 00 00 00 8B 74 24 10 8B 4A 04 8B 1A 39 E9 0F 82 A8 00 00 00 0F 86 9A 00 00 00 83 C0 14 E9 B1 FE FF FF 8B 44 24 14 39 05 ?? ?? ?? ?? 77 0E 72 C5 8B 4C 24 18 39 0D ?? ?? ?? ?? 76 B9 83 C4 4C B8 14 00 00 00 5B 5E 5F 5D C3 33 54 24 0C 31 C8 09 D0 0F 85 5E FE FF FF 8B 15 ?? ?? ?? ?? A1 ?? ?? ?? ?? 39 EA 0F 87 5A FF FF FF 72 0A 3B 44 24 10 0F 87 4E FF FF FF 33 44 24 10 31 EA 09 C2 0F 85 31 FE FF FF 8B 44 24 14 39 05 ?? ?? ?? ?? 0F 87 30 FF FF FF 0F 82 1B FE FF FF 8B 44 24 18 39 05 ?? ?? ?? ?? 0F 87 1A FF FF FF E9 06 FE FF FF 90 8D 74 26 00 39 F3 0F 87 5E FF FF FF 31 E9 31 F3 09 D9 66 90 74 1E 83 C0 01 83 C2 10 83 F8 13 0F 85 32 FF FF FF 83 C4 4C B0 27 5B 5E 5F 5D C3 90 8D 74 26 00 39 7A FC 72 DD 0F 87 2B FF FF FF 8B 4C 24 18 39 4A F8 76 CE E9 1D FF FF FF 8D B4 26 00 00 00 00 }
	condition:
		$1
}

rule file_32_1_0 {
	meta:
		name = "_rounding_correction.constprop.1"
		size = 848
		refs = "003c ___bid_IDEC_glbflags"
	strings:
		$1 = { 83 EC 2C 89 54 24 10 89 7C 24 24 8B 7C 24 10 89 74 24 20 8B 74 24 3C 89 5C 24 1C 89 6C 24 28 09 CF 0B 7C 24 30 0B 7C 24 34 89 44 24 0C 8B 56 04 8B 06 8B 6E 08 8B 5E 0C 74 07 83 0D ?? ?? ?? ?? 20 8B 7C 24 38 89 2C 24 89 DD 81 E5 FF FF 01 00 89 6C 24 04 89 DD 81 C7 20 18 00 00 C1 E7 11 81 E5 00 00 00 80 74 49 83 7C 24 0C 01 0F 94 C3 83 7C 24 10 00 0F 85 26 02 00 00 83 7C 24 0C 04 0F 84 40 02 00 00 84 DB 0F 85 38 02 00 00 8B 5C 24 30 09 CB 89 5C 24 14 0F 84 14 01 00 00 8B 5C 24 0C 83 EB 02 83 FB 01 0F 87 04 01 00 00 EB 47 90 83 7C 24 0C 02 0F 94 C3 83 7C 24 10 00 0F 85 CD 00 00 00 83 7C 24 0C 04 0F 84 E2 01 00 00 84 DB 0F 85 DA 01 00 00 8B 5C 24 30 09 CB 89 5C 24 14 0F 84 CB 00 00 00 8B 5C 24 0C 83 E3 FD 83 FB 01 0F 85 BB 00 00 00 83 C0 FF 83 D2 FF 89 D3 F7 D3 89 5C 24 08 89 C3 F7 D3 89 5C 24 10 8B 5C 24 08 0B 5C 24 10 0F 84 D6 01 00 00 89 D3 81 F3 09 5B C1 38 0B 5C 24 10 0F 85 85 00 00 00 8B 1C 24 81 F3 93 8D 44 C6 89 5C 24 08 8B 5C 24 04 81 F3 4D 31 00 00 89 5C 24 10 8B 5C 24 08 0B 5C 24 10 75 60 85 FF 0F 84 A7 01 00 00 8B 7C 24 38 BA 63 8E 8D 37 8B 44 24 38 C7 04 24 C0 87 AD BE C7 44 24 04 09 ED 01 00 81 C7 1F 18 00 00 83 E8 01 89 44 24 38 C1 E7 11 B8 FF FF FF FF EB 25 8D 74 26 00 84 DB 0F 84 2B FF FF FF 83 C0 01 83 D2 00 89 D1 09 C1 0F 85 98 00 00 00 83 04 24 01 83 54 24 04 00 81 7C 24 38 DF 17 00 00 7E 2A 83 0D ?? ?? ?? ?? 28 85 ED 75 4A 83 7C 24 0C 04 74 0B 83 7C 24 0C 02 0F 85 FE 00 00 00 31 C9 BB 00 00 00 78 31 C0 31 D2 EB 09 8B 5C 24 04 8B 0C 24 09 FB 09 DD 8B 7C 24 24 89 6E 0C 8B 5C 24 1C 89 06 8B 6C 24 28 89 56 04 89 4E 08 8B 74 24 20 83 C4 2C C3 90 83 7C 24 0C 04 74 1B 83 7C 24 0C 01 B9 C0 87 AD BE BB 09 ED FF DF B8 FF FF FF FF BA 63 8E 8D 37 75 BC 31 C9 BB 00 00 00 F8 31 C0 31 D2 EB AF 90 89 D3 89 C1 81 F3 64 8E 8D 37 09 D9 0F 85 5F FF FF FF 8B 0C 24 8B 5C 24 04 81 F1 C0 87 AD BE 81 F3 09 ED 01 00 09 D9 0F 85 44 FF FF FF 8B 7C 24 38 31 C0 BA 0A 5B C1 38 8B 5C 24 38 C7 04 24 93 8D 44 C6 C7 44 24 04 4D 31 00 00 81 C7 21 18 00 00 83 C3 01 C1 E7 11 89 5C 24 38 E9 11 FF FF FF 84 DB 0F 85 F0 FE FF FF E9 CD FD FF FF 8D 76 00 8B 5C 24 34 85 DB 0F 85 DC FE FF FF 8D 74 26 00 E9 11 FE FF FF 8B 5C 24 34 85 DB 0F 84 BC FD FF FF E9 C2 FE FF FF B9 C0 87 AD BE BB 09 ED FF 5F B8 FF FF FF FF BA 63 8E 8D 37 E9 FF FE FF FF 90 83 04 24 FF 83 54 24 04 FF E9 B3 FE FF FF 66 90 0B 4C 24 14 74 2A 83 0D ?? ?? ?? ?? 10 B8 FF FF FF FF BA 09 5B C1 38 C7 04 24 93 8D 44 C6 C7 44 24 04 4D 31 00 00 E9 86 FE FF FF 90 8D 74 26 00 B8 FF FF FF FF BA 09 5B C1 38 C7 04 24 93 8D 44 C6 C7 44 24 04 4D 31 00 00 E9 63 FE FF FF 66 90 }
	condition:
		$1
}

rule file_32_2_0 {
	meta:
		name = "_add_and_round.constprop.0"
		size = 10528
		refs = "0223 ___bid_ten2k64 0403 ___bid_ten2k128 115a ___bid_IDEC_glbflags 1364 ___bid_round192_39_57 1947 ___bid_round128_19_38 1c51 ___bid_round256_58_76 248c ___bid_midpoint64 265c ___bid_midpoint128 27d0 ___bid_round64_2_18"
	strings:
		$1 = { 55 57 56 53 81 EC DC 01 00 00 89 4C 24 68 8B 8C 24 F4 01 00 00 8B 9C 24 F8 01 00 00 8B B4 24 FC 01 00 00 8B BC 24 00 02 00 00 89 8C 24 B0 00 00 00 8B 8C 24 04 02 00 00 8B AC 24 48 02 00 00 89 9C 24 D4 00 00 00 89 B4 24 98 00 00 00 89 8C 24 10 01 00 00 8B 8C 24 08 02 00 00 89 BC 24 D0 00 00 00 89 8C 24 14 01 00 00 8B 8C 24 0C 02 00 00 89 8C 24 18 01 00 00 8B 8C 24 10 02 00 00 89 8C 24 1C 01 00 00 8B 8C 24 14 02 00 00 89 8C 24 F0 00 00 00 8B 8C 24 18 02 00 00 89 8C 24 F4 00 00 00 8B 8C 24 1C 02 00 00 89 8C 24 F8 00 00 00 8B 8C 24 20 02 00 00 89 8C 24 FC 00 00 00 8B 8C 24 24 02 00 00 89 8C 24 00 01 00 00 8B 8C 24 28 02 00 00 89 8C 24 04 01 00 00 8B B4 24 F0 00 00 00 8B 8C 24 2C 02 00 00 8B BC 24 F4 00 00 00 8B 9C 24 14 01 00 00 89 B4 24 C0 00 00 00 8B B4 24 F8 00 00 00 89 8C 24 08 01 00 00 8B 8C 24 30 02 00 00 89 BC 24 C4 00 00 00 8B BC 24 FC 00 00 00 89 5C 24 64 8B 9C 24 1C 01 00 00 89 B4 24 90 00 00 00 8B B4 24 00 01 00 00 89 8C 24 0C 01 00 00 8B 8C 24 10 01 00 00 89 BC 24 94 00 00 00 8B BC 24 04 01 00 00 C7 84 24 24 01 00 00 00 00 00 00 89 74 24 78 8B B4 24 08 01 00 00 89 4C 24 60 8B 8C 24 18 01 00 00 89 7C 24 7C 8B BC 24 0C 01 00 00 C7 84 24 28 01 00 00 00 00 00 00 89 74 24 70 8B 75 00 C7 84 24 2C 01 00 00 00 00 00 00 89 7C 24 74 C7 84 24 30 01 00 00 00 00 00 00 89 B4 24 60 01 00 00 8B 75 04 C7 84 24 34 01 00 00 00 00 00 00 89 B4 24 64 01 00 00 8B 75 08 2B 94 24 F0 01 00 00 89 B4 24 68 01 00 00 8B 75 0C 29 C2 89 B4 24 6C 01 00 00 75 30 C7 44 24 58 00 00 00 00 C7 44 24 5C 00 00 00 00 8B B4 24 D4 00 00 00 39 B4 24 D0 00 00 00 BE 00 00 00 00 0F 84 02 15 00 00 31 FF E9 B5 0C 00 00 83 FA 13 0F 8F D0 01 00 00 8B 34 D5 ?? ?? ?? ?? 8B 14 D5 ?? ?? ?? ?? 89 9C 24 B8 00 00 00 C7 84 24 48 01 00 00 00 00 00 00 89 B4 24 40 01 00 00 89 D0 89 94 24 88 00 00 00 89 94 24 44 01 00 00 F7 E1 C7 84 24 4C 01 00 00 00 00 00 00 89 44 24 58 8B 84 24 88 00 00 00 89 54 24 5C F7 E3 89 84 24 A8 00 00 00 89 F0 89 94 24 AC 00 00 00 F7 E1 89 94 24 A4 00 00 00 8B 9C 24 A4 00 00 00 31 D2 89 84 24 A0 00 00 00 8B 44 24 58 89 D9 31 DB 89 8C 24 80 00 00 00 01 84 24 80 00 00 00 8B 84 24 B8 00 00 00 89 9C 24 84 00 00 00 8B 5C 24 5C 11 94 24 84 00 00 00 F7 E6 01 84 24 80 00 00 00 89 D9 11 94 24 84 00 00 00 31 DB 89 4C 24 58 8B 8C 24 A8 00 00 00 89 5C 24 5C 8B 9C 24 AC 00 00 00 01 4C 24 58 8B 94 24 84 00 00 00 8B 4C 24 60 11 5C 24 5C 8B 7C 24 64 89 D0 31 D2 01 44 24 58 8B 84 24 88 00 00 00 11 54 24 5C F7 E1 89 44 24 60 8B 84 24 88 00 00 00 89 54 24 64 F7 E7 89 84 24 88 00 00 00 89 F0 89 94 24 8C 00 00 00 F7 E1 89 94 24 AC 00 00 00 8B 9C 24 AC 00 00 00 31 D2 89 84 24 A8 00 00 00 8B 44 24 60 89 D9 31 DB 01 C1 89 F0 11 D3 F7 E7 8B 7C 24 64 01 C1 89 FE 11 D3 31 FF 03 B4 24 88 00 00 00 89 DA 13 BC 24 8C 00 00 00 89 D0 31 D2 01 C6 11 D7 31 C0 89 44 24 60 8B 84 24 A8 00 00 00 31 D2 89 4C 24 64 8B 8C 24 80 00 00 00 01 44 24 60 8B 84 24 A0 00 00 00 11 54 24 64 31 D2 89 CB 31 C9 01 C1 11 D3 01 F1 11 FB 39 DF 0F 82 27 FE FF FF 77 08 39 CE 0F 86 1D FE FF FF 83 44 24 58 01 83 54 24 5C 00 E9 0E FE FF FF 8D B4 26 00 00 00 00 83 FA 26 0F 8F 87 04 00 00 83 EA 14 89 D0 C1 E0 04 8B B0 ?? ?? ?? ?? 8B B8 ?? ?? ?? ?? 89 C8 89 94 24 A0 00 00 00 89 9C 24 80 00 00 00 F7 E6 89 8C 24 A8 00 00 00 89 44 24 58 89 D8 89 54 24 5C F7 E6 89 84 24 C8 00 00 00 89 C8 89 94 24 CC 00 00 00 F7 E7 89 94 24 DC 00 00 00 8B 9C 24 DC 00 00 00 31 D2 89 84 24 D8 00 00 00 8B 44 24 58 89 D9 31 DB 89 8C 24 88 00 00 00 01 84 24 88 00 00 00 8B 84 24 80 00 00 00 89 9C 24 8C 00 00 00 8B 5C 24 5C 11 94 24 8C 00 00 00 F7 E7 01 84 24 88 00 00 00 89 D9 11 94 24 8C 00 00 00 31 DB 89 4C 24 58 8B 8C 24 C8 00 00 00 01 4C 24 58 89 5C 24 5C 8B 9C 24 CC 00 00 00 11 5C 24 5C 8B 94 24 8C 00 00 00 8B 5C 24 64 89 D0 31 D2 01 44 24 58 8B 44 24 60 11 54 24 5C 89 9C 24 B8 00 00 00 89 84 24 C8 00 00 00 F7 E6 89 44 24 60 89 D8 89 54 24 64 F7 E6 89 84 24 E8 00 00 00 8B 84 24 C8 00 00 00 89 94 24 EC 00 00 00 F7 E7 89 94 24 E4 00 00 00 8B 9C 24 E4 00 00 00 31 D2 89 84 24 E0 00 00 00 8B 44 24 60 89 D9 31 DB 01 C1 8B 84 24 B8 00 00 00 11 D3 F7 E7 8B 7C 24 64 01 C1 89 FE 11 D3 31 FF 03 B4 24 E8 00 00 00 89 DA 13 BC 24 EC 00 00 00 89 D0 89 4C 24 64 31 D2 8B 8C 24 88 00 00 00 01 C6 11 D7 31 C0 89 44 24 60 8B 84 24 E0 00 00 00 31 D2 01 44 24 60 89 CB 11 54 24 64 31 C9 31 D2 89 8C 24 88 00 00 00 8B 84 24 D8 00 00 00 01 84 24 88 00 00 00 89 9C 24 8C 00 00 00 11 94 24 8C 00 00 00 01 B4 24 88 00 00 00 11 BC 24 8C 00 00 00 3B BC 24 8C 00 00 00 72 10 0F 86 3E 20 00 00 83 44 24 58 01 83 54 24 5C 00 8B 84 24 A0 00 00 00 C1 E0 04 8B B0 ?? ?? ?? ?? 8B 98 ?? ?? ?? ?? 8B 84 24 A8 00 00 00 89 9C 24 D8 00 00 00 F7 E6 89 84 24 A0 00 00 00 8B 84 24 80 00 00 00 89 94 24 A4 00 00 00 F7 E6 89 84 24 E0 00 00 00 89 D8 89 94 24 E4 00 00 00 F7 A4 24 A8 00 00 00 89 94 24 AC 00 00 00 8B 9C 24 AC 00 00 00 31 D2 89 84 24 A8 00 00 00 8B 84 24 A0 00 00 00 89 D9 31 DB 01 C1 8B 84 24 D8 00 00 00 11 D3 F7 A4 24 80 00 00 00 01 C1 11 D3 8B 94 24 A4 00 00 00 89 D0 31 D2 89 84 24 A0 00 00 00 8B 84 24 E0 00 00 00 01 84 24 A0 00 00 00 8B 84 24 C8 00 00 00 89 94 24 A4 00 00 00 8B 94 24 E4 00 00 00 11 94 24 A4 00 00 00 31 D2 01 9C 24 A0 00 00 00 11 94 24 A4 00 00 00 F7 E6 89 84 24 80 00 00 00 8B 84 24 B8 00 00 00 89 94 24 84 00 00 00 F7 E6 89 84 24 E0 00 00 00 8B 84 24 D8 00 00 00 89 94 24 E4 00 00 00 F7 A4 24 C8 00 00 00 89 94 24 CC 00 00 00 8B BC 24 CC 00 00 00 31 D2 89 84 24 C8 00 00 00 8B 84 24 80 00 00 00 89 FE 31 FF 01 C6 8B 84 24 D8 00 00 00 11 D7 F7 A4 24 B8 00 00 00 01 C6 11 D7 8B 94 24 84 00 00 00 89 B4 24 BC 00 00 00 89 D0 31 D2 89 84 24 80 00 00 00 8B 84 24 E0 00 00 00 01 84 24 80 00 00 00 89 94 24 84 00 00 00 8B 94 24 E4 00 00 00 11 94 24 84 00 00 00 89 FA 89 D0 31 D2 01 84 24 80 00 00 00 89 CF 11 94 24 84 00 00 00 31 C0 31 D2 89 84 24 B8 00 00 00 8B 84 24 C8 00 00 00 01 84 24 B8 00 00 00 11 94 24 BC 00 00 00 31 F6 8B 84 24 A8 00 00 00 31 D2 01 C6 11 D7 03 B4 24 80 00 00 00 13 BC 24 84 00 00 00 39 BC 24 84 00 00 00 72 16 0F 86 38 1E 00 00 83 84 24 A0 00 00 00 01 83 94 24 A4 00 00 00 00 8B 8C 24 88 00 00 00 8B 9C 24 8C 00 00 00 03 8C 24 B8 00 00 00 13 9C 24 BC 00 00 00 39 9C 24 BC 00 00 00 C7 84 24 80 00 00 00 01 00 00 00 C7 84 24 84 00 00 00 00 00 00 00 77 1C 0F 83 D5 1D 00 00 C7 84 24 80 00 00 00 00 00 00 00 C7 84 24 84 00 00 00 00 00 00 00 8B 44 24 58 03 B4 24 80 00 00 00 8B 54 24 5C 13 BC 24 84 00 00 00 01 F0 89 44 24 58 11 FA 39 D7 89 54 24 5C 0F 87 90 16 00 00 0F 83 82 16 00 00 31 D2 B8 01 00 00 00 39 BC 24 84 00 00 00 77 0F 72 09 39 B4 24 80 00 00 00 77 04 31 C0 31 D2 8B B4 24 A0 00 00 00 8B BC 24 A4 00 00 00 01 C6 11 D7 E9 16 06 00 00 8D 74 26 00 83 FA 39 0F 8F 57 16 00 00 83 EA 26 8B 34 D5 ?? ?? ?? ?? 8B 14 D5 ?? ?? ?? ?? 89 F0 89 94 24 A0 00 00 00 F7 E1 89 B4 24 80 00 00 00 89 94 24 AC 00 00 00 8B BC 24 AC 00 00 00 31 D2 89 84 24 A8 00 00 00 8B 84 24 A0 00 00 00 89 FE 31 FF 0F AF C1 8B 4C 24 64 89 74 24 58 8B 74 24 60 01 44 24 58 8B 84 24 A0 00 00 00 89 7C 24 5C 11 54 24 5C F7 E6 89 84 24 C8 00 00 00 8B 84 24 80 00 00 00 89 94 24 CC 00 00 00 F7 E6 89 94 24 BC 00 00 00 8B BC 24 BC 00 00 00 31 D2 89 84 24 B8 00 00 00 8B 84 24 C8 00 00 00 89 FE 31 FF 89 B4 24 88 00 00 00 01 84 24 88 00 00 00 8B 84 24 80 00 00 00 89 BC 24 8C 00 00 00 11 94 24 8C 00 00 00 F7 E1 01 84 24 88 00 00 00 8B B4 24 88 00 00 00 11 94 24 8C 00 00 00 31 D2 8B 84 24 B8 00 00 00 89 F7 31 F6 89 74 24 60 01 44 24 60 8B 74 24 60 89 7C 24 64 8B 84 24 A8 00 00 00 11 54 24 64 31 D2 8B 7C 24 64 89 B4 24 50 01 00 00 89 BC 24 54 01 00 00 8B BC 24 CC 00 00 00 89 FE 31 FF 01 C6 8B 84 24 A0 00 00 00 11 D7 F7 E1 01 C6 89 D8 11 D7 F7 A4 24 80 00 00 00 01 44 24 58 8B 4C 24 58 11 54 24 5C 8B 94 24 8C 00 00 00 89 CB 31 C9 01 CE 8B 0D ?? ?? ?? ?? 11 DF 8B 5C 24 64 89 D0 31 D2 01 C6 11 D7 89 C8 89 9C 24 E0 00 00 00 89 B4 24 58 01 00 00 89 BC 24 5C 01 00 00 89 8C 24 A0 00 00 00 8B 1D ?? ?? ?? ?? F7 A4 24 E0 00 00 00 89 9C 24 B8 00 00 00 89 44 24 58 89 D8 89 54 24 5C F7 A4 24 E0 00 00 00 89 84 24 80 00 00 00 8B 44 24 60 89 94 24 84 00 00 00 F7 E1 89 94 24 CC 00 00 00 8B 9C 24 CC 00 00 00 31 D2 89 84 24 C8 00 00 00 8B 44 24 58 89 D9 31 DB 89 9C 24 8C 00 00 00 8B 5C 24 5C 89 8C 24 88 00 00 00 01 84 24 88 00 00 00 8B 44 24 60 11 94 24 8C 00 00 00 89 D9 F7 A4 24 B8 00 00 00 01 84 24 88 00 00 00 11 94 24 8C 00 00 00 31 DB 89 4C 24 58 8B 8C 24 80 00 00 00 01 4C 24 58 89 5C 24 5C 8B 9C 24 84 00 00 00 11 5C 24 5C 8B 94 24 8C 00 00 00 8B 1D ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 89 D0 31 D2 01 44 24 58 89 D8 11 54 24 5C F7 A4 24 E0 00 00 00 89 9C 24 A8 00 00 00 89 8C 24 D8 00 00 00 89 84 24 80 00 00 00 89 C8 89 94 24 84 00 00 00 F7 A4 24 E0 00 00 00 89 84 24 E8 00 00 00 8B 44 24 60 89 94 24 EC 00 00 00 F7 E3 89 94 24 E4 00 00 00 8B 9C 24 E4 00 00 00 31 D2 89 84 24 E0 00 00 00 8B 84 24 80 00 00 00 89 D9 31 DB 01 C1 8B 44 24 60 11 D3 F7 A4 24 D8 00 00 00 01 C1 11 D3 8B 94 24 84 00 00 00 89 D0 31 D2 89 84 24 80 00 00 00 8B 84 24 E8 00 00 00 01 84 24 80 00 00 00 89 94 24 84 00 00 00 8B 94 24 EC 00 00 00 11 94 24 84 00 00 00 89 DA 89 D0 31 D2 01 84 24 80 00 00 00 11 94 24 84 00 00 00 31 C0 31 D2 89 4C 24 64 8B 8C 24 88 00 00 00 89 44 24 60 8B 84 24 E0 00 00 00 01 44 24 60 11 54 24 64 31 D2 89 CB 8B 84 24 C8 00 00 00 31 C9 89 8C 24 88 00 00 00 01 84 24 88 00 00 00 8B 84 24 80 00 00 00 89 9C 24 8C 00 00 00 11 94 24 8C 00 00 00 8B 94 24 84 00 00 00 01 84 24 88 00 00 00 11 94 24 8C 00 00 00 8B 8C 24 8C 00 00 00 39 CA 0F 83 FC 19 00 00 8B 84 24 A0 00 00 00 89 F9 89 F7 F7 E1 89 84 24 80 00 00 00 8B 84 24 B8 00 00 00 89 94 24 84 00 00 00 F7 E1 89 84 24 E0 00 00 00 8B 84 24 A0 00 00 00 89 94 24 E4 00 00 00 F7 E6 89 94 24 A4 00 00 00 8B B4 24 A4 00 00 00 31 D2 89 84 24 A0 00 00 00 8B 84 24 80 00 00 00 89 F3 31 F6 89 9C 24 C8 00 00 00 01 84 24 C8 00 00 00 8B 84 24 B8 00 00 00 89 B4 24 CC 00 00 00 8B B4 24 84 00 00 00 11 94 24 CC 00 00 00 F7 E7 01 84 24 C8 00 00 00 89 F3 11 94 24 CC 00 00 00 31 F6 8B 94 24 CC 00 00 00 89 9C 24 80 00 00 00 8B 9C 24 E0 00 00 00 01 9C 24 80 00 00 00 89 B4 24 84 00 00 00 8B B4 24 E4 00 00 00 89 D0 11 B4 24 84 00 00 00 31 D2 01 84 24 80 00 00 00 8B 84 24 A8 00 00 00 11 94 24 84 00 00 00 F7 E1 89 84 24 B8 00 00 00 8B 84 24 D8 00 00 00 89 94 24 BC 00 00 00 F7 E1 89 84 24 E0 00 00 00 8B 84 24 A8 00 00 00 89 94 24 E4 00 00 00 F7 E7 89 94 24 AC 00 00 00 8B 9C 24 AC 00 00 00 31 D2 89 84 24 A8 00 00 00 8B 84 24 B8 00 00 00 89 D9 31 DB 01 C1 8B 84 24 D8 00 00 00 11 D3 F7 E7 8B BC 24 BC 00 00 00 01 C1 89 FE 11 D3 31 FF 03 B4 24 E0 00 00 00 89 DA 13 BC 24 E4 00 00 00 89 D0 31 D2 01 C6 11 D7 31 C0 89 84 24 B8 00 00 00 8B 84 24 A8 00 00 00 31 D2 01 84 24 B8 00 00 00 8B 84 24 C8 00 00 00 89 8C 24 BC 00 00 00 8B 8C 24 A0 00 00 00 11 94 24 BC 00 00 00 89 C2 31 C0 31 DB 01 C8 11 DA 01 F0 11 FA 39 D7 72 16 0F 86 EF 17 00 00 83 84 24 80 00 00 00 01 83 94 24 84 00 00 00 00 8B 8C 24 B8 00 00 00 8B 9C 24 BC 00 00 00 03 8C 24 88 00 00 00 13 9C 24 8C 00 00 00 39 9C 24 BC 00 00 00 C7 84 24 A0 00 00 00 01 00 00 00 C7 84 24 A4 00 00 00 00 00 00 00 77 1C 0F 83 85 17 00 00 C7 84 24 A0 00 00 00 00 00 00 00 C7 84 24 A4 00 00 00 00 00 00 00 8B 74 24 58 03 84 24 A0 00 00 00 8B 7C 24 5C 13 94 24 A4 00 00 00 01 C6 89 74 24 58 11 D7 39 FA 89 7C 24 5C 0F 87 5A 10 00 00 0F 83 4C 10 00 00 31 FF BE 01 00 00 00 39 94 24 A4 00 00 00 0F 86 B9 17 00 00 89 F0 89 FA 8B B4 24 80 00 00 00 8B BC 24 84 00 00 00 01 C6 11 D7 8B 94 24 D0 00 00 00 8B 84 24 98 00 00 00 33 94 24 D4 00 00 00 33 84 24 B0 00 00 00 09 C2 0F 84 72 08 00 00 39 7C 24 74 0F 82 E0 05 00 00 77 0A 39 74 24 70 0F 82 D4 05 00 00 8B 54 24 74 8B 44 24 70 31 FA 31 F0 09 C2 0F 84 40 05 00 00 8B 84 24 C0 00 00 00 8B 94 24 C4 00 00 00 2B 44 24 60 1B 54 24 64 39 94 24 C4 00 00 00 89 84 24 B0 00 00 00 89 94 24 B4 00 00 00 77 13 0F 82 BE 02 00 00 39 84 24 C0 00 00 00 0F 82 B1 02 00 00 8B 84 24 90 00 00 00 8B 94 24 94 00 00 00 29 C8 19 DA 39 94 24 94 00 00 00 89 44 24 60 89 54 24 64 77 13 0F 82 DF 02 00 00 39 84 24 90 00 00 00 0F 82 D2 02 00 00 8B 4C 24 78 8B 5C 24 7C 2B 4C 24 58 1B 5C 24 5C 39 5C 24 7C 77 14 0F 82 EE 02 00 00 39 4C 24 78 0F 82 E4 02 00 00 8D 74 26 00 8B 44 24 70 8B 54 24 74 89 8C 24 C0 01 00 00 89 9C 24 C4 01 00 00 29 F0 8B B4 24 B0 00 00 00 19 FA 8B BC 24 B4 00 00 00 89 84 24 C8 01 00 00 89 94 24 CC 01 00 00 89 B4 24 B0 01 00 00 8B 74 24 60 89 BC 24 B4 01 00 00 8B 7C 24 64 89 B4 24 B8 01 00 00 89 BC 24 BC 01 00 00 89 D7 09 C7 75 34 8B 84 24 C4 01 00 00 0B 84 24 C0 01 00 00 75 24 8B 84 24 BC 01 00 00 0B 84 24 B8 01 00 00 75 14 }
	condition:
		$1
}

rule file_32_3_0 {
	meta:
		name = "_bid128_ext_fma"
		size = 53392
		refs = "04aa ___bid_IDEC_glbflags 0898 ___bid_nr_digits 0c37 ___bid_IDEC_glbround 0e21 ___bid_ten2k128 0fea ___bid_round192_39_57 160f ___bid_ten2k64 29b1 ___bid_ten2k256 2ffb ___bid_round64_2_18 32c0 ___bid_round256_58_76 3587 ___bid_round128_19_38 5e01 ___bid_midpoint64 898c ___bid_midpoint192 8c39 ___bid_midpoint128 ac0d ___bid_midpoint256"
	strings:
		$1 = { 55 89 C5 57 56 53 81 EC AC 02 00 00 8B 84 24 C8 02 00 00 89 94 24 00 01 00 00 89 8C 24 04 01 00 00 89 84 24 B0 01 00 00 8B 84 24 CC 02 00 00 89 84 24 B4 01 00 00 8B 84 24 D0 02 00 00 8B 94 24 B4 01 00 00 89 84 24 B8 01 00 00 8B 84 24 D4 02 00 00 89 84 24 BC 01 00 00 8B 84 24 D8 02 00 00 89 84 24 A0 01 00 00 8B 84 24 DC 02 00 00 89 84 24 A4 01 00 00 8B 84 24 E0 02 00 00 89 84 24 A8 01 00 00 8B 84 24 E4 02 00 00 89 84 24 AC 01 00 00 8B 84 24 E8 02 00 00 89 84 24 90 01 00 00 8B 84 24 EC 02 00 00 89 84 24 94 01 00 00 8B 84 24 F0 02 00 00 89 84 24 98 01 00 00 8B 84 24 F4 02 00 00 89 84 24 9C 01 00 00 8B 84 24 B0 01 00 00 89 84 24 A8 00 00 00 8B B4 24 A0 01 00 00 8B BC 24 A4 01 00 00 89 94 24 AC 00 00 00 8B 94 24 AC 01 00 00 8B 8C 24 B8 01 00 00 89 B4 24 90 00 00 00 8B B4 24 90 01 00 00 89 BC 24 94 00 00 00 8B BC 24 94 01 00 00 8B 9C 24 BC 01 00 00 8B 84 24 A8 01 00 00 89 B4 24 B0 00 00 00 8B B4 24 98 01 00 00 89 BC 24 B4 00 00 00 8B BC 24 9C 01 00 00 C7 84 24 E0 01 00 00 DD BA DD BA C7 84 24 E4 01 00 00 DD BA DD BA 89 B4 24 80 00 00 00 89 D6 81 E6 00 00 00 7C 81 FE 00 00 00 7C 89 BC 24 84 00 00 00 C7 84 24 E8 01 00 00 DD BA DD BA C7 84 24 EC 01 00 00 DD BA DD BA C7 84 24 C4 01 00 00 00 00 00 00 C7 84 24 C8 01 00 00 00 00 00 00 C7 84 24 CC 01 00 00 00 00 00 00 C7 84 24 D0 01 00 00 00 00 00 00 C7 84 24 D4 01 00 00 00 00 00 00 0F 84 1C 01 00 00 8B BC 24 84 00 00 00 81 E7 00 00 00 7C 81 FF 00 00 00 7C 89 BC 24 08 01 00 00 0F 84 0B 02 00 00 89 DF 81 E7 00 00 00 7C 81 FF 00 00 00 7C 89 BC 24 A0 00 00 00 0F 84 B4 02 00 00 89 DF 81 E7 00 00 00 80 89 BC 24 B8 00 00 00 89 DF 81 E7 FF FF 01 00 81 BC 24 A0 00 00 00 00 00 00 78 89 8C 24 98 00 00 00 89 BC 24 9C 00 00 00 0F 84 1A 10 00 00 89 DF 81 E7 00 00 00 60 81 FF 00 00 00 60 0F 84 56 03 00 00 89 DF 81 E7 00 00 FE 7F 81 BC 24 9C 00 00 00 09 ED 01 00 C7 84 24 E8 00 00 00 00 00 00 00 89 BC 24 EC 00 00 00 77 3F 0F 83 3F 13 00 00 8B 9C 24 9C 00 00 00 8B 8C 24 98 00 00 00 81 F3 09 ED 01 00 81 F1 C0 87 AD BE 09 CB 0F 85 51 03 00 00 81 BC 24 AC 00 00 00 63 8E 8D 37 0F 86 40 03 00 00 8D B6 00 00 00 00 C7 84 24 A8 00 00 00 00 00 00 00 C7 84 24 AC 00 00 00 00 00 00 00 C7 84 24 98 00 00 00 00 00 00 00 C7 84 24 9C 00 00 00 00 00 00 00 E9 09 03 00 00 89 D6 89 C7 81 E6 FF 3F 00 00 81 FE 4D 31 00 00 0F 86 39 02 00 00 89 D6 31 C0 81 E6 00 C0 FF FF 89 F2 C7 84 24 90 00 00 00 00 00 00 00 C7 84 24 94 00 00 00 00 00 00 00 89 D6 81 E6 00 00 00 7E 81 FE 00 00 00 7E 0F 84 9A 0F 00 00 89 84 24 E8 01 00 00 89 D0 8B B4 24 90 00 00 00 25 FF 3F 00 FC 8B BC 24 94 00 00 00 89 84 24 EC 01 00 00 8B 84 24 84 00 00 00 89 B4 24 E0 01 00 00 89 BC 24 E4 01 00 00 25 00 00 00 7E 3D 00 00 00 7E 0F 84 33 01 00 00 89 D8 25 00 00 00 7E 3D 00 00 00 7E 0F 84 21 01 00 00 8B 94 24 00 01 00 00 8B 8C 24 04 01 00 00 8B 9C 24 C0 02 00 00 8B B4 24 C4 02 00 00 C7 02 00 00 00 00 C7 01 00 00 00 00 C7 03 00 00 00 00 C7 06 00 00 00 00 8B 84 24 E0 01 00 00 89 45 00 8B 84 24 E4 01 00 00 89 45 04 8B 84 24 E8 01 00 00 89 45 08 8B 84 24 EC 01 00 00 89 45 0C 81 C4 AC 02 00 00 89 E8 5B 5E 5F 5D C3 8B 84 24 84 00 00 00 8B 94 24 80 00 00 00 25 FF 3F 00 00 3D 4D 31 00 00 0F 86 59 01 00 00 8B 84 24 84 00 00 00 C7 84 24 80 00 00 00 00 00 00 00 C7 84 24 B0 00 00 00 00 00 00 00 C7 84 24 B4 00 00 00 00 00 00 00 25 00 C0 FF FF 89 84 24 84 00 00 00 8B 84 24 84 00 00 00 25 00 00 00 7E 3D 00 00 00 7E 0F 84 E7 10 00 00 8B 84 24 84 00 00 00 8B B4 24 80 00 00 00 8B 94 24 B4 00 00 00 25 FF 3F 00 FC 89 84 24 EC 01 00 00 8B 84 24 B0 00 00 00 89 B4 24 E8 01 00 00 89 94 24 E4 01 00 00 89 84 24 E0 01 00 00 89 D8 25 00 00 00 7E 3D 00 00 00 7E 0F 85 DF FE FF FF 83 0D ?? ?? ?? ?? 01 E9 D3 FE FF FF 89 D8 89 CA 25 FF 3F 00 00 3D 4D 31 00 00 0F 87 D9 0D 00 00 0F 83 B2 11 00 00 35 4D 31 00 00 81 F2 93 8D 44 C6 09 D0 0F 84 AF 0D 00 00 89 D8 25 00 00 00 7E 3D 00 00 00 7E 0F 84 DD 1B 00 00 89 8C 24 E8 01 00 00 8B 94 24 A8 00 00 00 89 D8 8B 8C 24 AC 00 00 00 25 FF 3F 00 FC 89 84 24 EC 01 00 00 89 94 24 E0 01 00 00 89 8C 24 E4 01 00 00 E9 5E FE FF FF 8D B4 26 00 00 00 00 72 0B 3D 93 8D 44 C6 0F 87 BA FD FF FF 81 F6 4D 31 00 00 81 F7 93 8D 44 C6 09 FE 0F 85 C8 FD FF FF 81 BC 24 94 00 00 00 09 5B C1 38 0F 86 B7 FD FF FF E9 90 FD FF FF 72 0D 81 FA 93 8D 44 C6 90 0F 87 98 FE FF FF 35 4D 31 00 00 81 F2 93 8D 44 C6 09 D0 0F 85 B9 FE FF FF 81 BC 24 B4 00 00 00 09 5B C1 38 0F 86 A8 FE FF FF E9 6F FE FF FF 90 0F A4 CB 02 89 DF 81 E7 00 00 FE 7F C7 84 24 E8 00 00 00 00 00 00 00 89 BC 24 EC 00 00 00 C7 84 24 A8 00 00 00 00 00 00 00 C7 84 24 AC 00 00 00 00 00 00 00 C7 84 24 98 00 00 00 00 00 00 00 C7 84 24 9C 00 00 00 00 00 00 00 89 D1 89 D3 81 E1 00 00 00 80 81 E3 FF FF 01 00 81 FE 00 00 00 78 89 8C 24 D8 00 00 00 89 C1 0F 84 61 0C 00 00 89 D7 81 E7 00 00 00 60 81 FF 00 00 00 60 0F 84 1F 0D 00 00 89 D7 81 E7 00 00 FE 7F 81 FB 09 ED 01 00 C7 84 24 D0 00 00 00 00 00 00 00 89 BC 24 D4 00 00 00 0F 87 08 0B 00 00 0F 83 57 0F 00 00 89 DA 89 C8 81 F2 09 ED 01 00 35 C0 87 AD BE 09 C2 0F 84 DA 0A 00 00 8B 84 24 84 00 00 00 8B BC 24 84 00 00 00 8B 94 24 80 00 00 00 C7 84 24 E0 00 00 00 00 00 00 00 25 00 00 00 80 81 E7 FF FF 01 00 81 BC 24 08 01 00 00 00 00 00 78 89 84 24 C8 00 00 00 89 94 24 88 00 00 00 89 BC 24 8C 00 00 00 0F 84 B9 0A 00 00 8B 84 24 84 00 00 00 25 00 00 00 60 3D 00 00 00 60 0F 84 B2 0C 00 00 8B 84 24 84 00 00 00 C7 84 24 F0 00 00 00 00 00 00 00 25 00 00 FE 7F 81 BC 24 8C 00 00 00 09 ED 01 00 89 84 24 F4 00 00 00 0F 87 0B 0A 00 00 0F 83 8D 0E 00 00 8B 94 24 88 00 00 00 8B BC 24 8C 00 00 00 8B 84 24 B0 00 00 00 81 F2 C0 87 AD BE 89 94 24 F8 00 00 00 8B 94 24 B4 00 00 00 81 F7 09 ED 01 00 0B BC 24 F8 00 00 00 89 84 24 C0 00 00 00 89 94 24 C4 00 00 00 0F 84 AA 09 00 00 8D 76 00 8B 94 24 D8 00 00 00 33 94 24 B8 00 00 00 81 BC 24 A0 00 00 00 00 00 00 78 C7 84 24 FC 00 00 00 00 00 00 00 89 94 24 D8 00 00 00 0F 84 26 0A 00 00 81 FE 00 00 00 78 0F 84 77 0B 00 00 81 BC 24 08 01 00 00 00 00 00 78 0F 84 72 19 00 00 8B BC 24 EC 00 00 00 8B 84 24 D4 00 00 00 C7 84 24 E8 00 00 00 00 00 00 00 C7 84 24 EC 00 00 00 00 00 00 00 C1 EF 11 C1 E8 11 89 84 24 D0 00 00 00 8D 84 07 C0 CF FF FF 3D E0 E7 FF FF 89 BC 24 A0 00 00 00 7C 34 05 20 18 00 00 89 84 24 E8 00 00 00 8B B4 24 E8 00 00 00 89 C2 C1 FA 1F 89 94 24 EC 00 00 00 89 F7 31 F6 C1 E7 11 89 B4 24 E8 00 00 00 89 BC 24 EC 00 00 00 8B BC 24 9C 00 00 00 0B BC 24 98 00 00 00 75 14 8B 84 24 AC 00 00 00 0B 84 24 A8 00 00 00 0F 84 77 03 00 00 89 DA 09 CA 75 14 8B B4 24 94 00 00 00 0B B4 24 90 00 00 00 0F 84 5D 03 00 00 8B BC 24 9C 00 00 00 0B BC 24 98 00 00 00 0F 84 76 0B 00 00 DF AC 24 98 00 00 00 DD 9C 24 B8 00 00 00 8B 94 24 BC 00 00 00 89 D0 C1 E8 14 25 FF 07 00 00 2D BE 03 00 00 83 E8 01 89 C2 C1 E2 05 8B B2 ?? ?? ?? ?? 85 F6 75 70 8B B2 ?? ?? ?? ?? 8B BA ?? ?? ?? ?? 8B 92 ?? ?? ?? ?? 3B 94 24 9C 00 00 00 0F 82 59 0E 00 00 77 0D 3B BC 24 98 00 00 00 0F 82 4A 0E 00 00 33 94 24 9C 00 00 00 33 BC 24 98 00 00 00 09 FA 75 30 C1 E0 05 8B 94 24 AC 00 00 00 05 ?? ?? ?? ?? 39 50 14 77 1C 0F 82 1E 0E 00 00 8B BC 24 A8 00 00 00 39 78 10 0F 86 0E 0E 00 00 8D B6 00 00 00 00 89 D8 09 C8 0F 84 B6 0B 00 00 89 8C 24 88 01 00 00 89 9C 24 8C 01 00 00 DF AC 24 88 01 00 00 DD 9C 24 B8 00 00 00 8B 94 24 BC 00 00 00 89 D0 C1 E8 14 25 FF 07 00 00 2D BF 03 00 00 89 84 24 F8 00 00 00 8B 94 24 F8 00 00 00 C1 E2 05 8B BA ?? ?? ?? ?? 85 FF 75 6B 8B 82 ?? ?? ?? ?? 8B BA ?? ?? ?? ?? 8B 92 ?? ?? ?? ?? 89 84 24 B8 00 00 00 39 DA 0F 82 88 0D 00 00 77 08 39 C8 0F 82 7E 0D 00 00 8B 84 24 B8 00 00 00 31 DA 31 C8 09 C2 75 31 8B 84 24 F8 00 00 00 8B 94 24 94 00 00 00 C1 E0 05 05 ?? ?? ?? ?? 39 50 14 77 16 0F 82 4E 0D 00 00 8B 94 24 90 00 00 00 39 50 10 0F 86 3E 0D 00 00 8B 84 24 8C 00 00 00 0B 84 24 88 00 00 00 0F 84 6A 0A 00 00 DF AC 24 88 00 00 00 DD 9C 24 B8 00 00 00 8B 94 24 BC 00 00 00 89 D0 C1 E8 14 25 FF 07 00 00 2D BF 03 00 00 89 84 24 08 01 00 00 8B 94 24 08 01 00 00 C1 E2 05 8B 82 ?? ?? ?? ?? 85 C0 89 84 24 B8 00 00 00 0F 85 90 00 00 00 8B 82 ?? ?? ?? ?? 89 84 24 B8 00 00 00 8B 82 ?? ?? ?? ?? 8B 92 ?? ?? ?? ?? 3B 94 24 8C 00 00 00 89 84 24 F8 00 00 00 0F 82 A3 0C 00 00 77 14 8B 84 24 88 00 00 00 39 84 24 F8 00 00 00 0F 82 8D 0C 00 00 8B 84 24 F8 00 00 00 33 94 24 8C 00 00 00 33 84 24 88 00 00 00 09 C2 75 34 8B 84 24 08 01 00 00 8B 94 24 C4 00 00 00 C1 E0 05 05 ?? ?? ?? ?? 39 50 14 77 19 0F 82 53 0C 00 00 8B 94 24 C0 00 00 00 39 50 10 0F 86 43 0C 00 00 8D 76 00 8B 84 24 9C 00 00 00 0B 84 24 98 00 00 00 75 10 8B 94 24 AC 00 00 00 0B 94 24 A8 00 00 00 74 1E 89 D8 09 C8 0F 85 86 01 00 00 8B 94 24 94 00 00 00 0B 94 24 90 00 00 00 0F 85 72 01 00 00 8B 8C 24 EC 00 00 00 39 8C 24 F4 00 00 00 0F 86 7F 0B 00 00 8B 84 24 F0 00 00 00 B9 22 00 00 00 8B 94 24 F4 00 00 00 2B 8C 24 B8 00 00 00 2B 84 24 E8 00 00 00 1B 94 24 EC 00 00 00 89 D6 C1 EE 11 39 F1 0F 4E F1 85 F6 0F 85 ED 1A 00 00 8B 84 24 B0 00 00 00 8B 94 24 B4 00 00 00 89 84 24 E0 01 00 00 89 94 24 E4 01 00 00 8B 84 24 F0 00 00 00 89 F7 BE 00 00 00 00 8B 94 24 F4 00 00 00 C1 E7 11 29 F0 19 FA 89 D0 8B 94 24 80 00 00 00 25 00 00 FE 7F 0B 84 24 C8 00 00 00 0B 84 24 84 00 00 00 89 94 24 E8 01 00 00 89 84 24 EC 01 00 00 E9 D4 F7 FF FF 8B BC 24 8C 00 00 00 0B BC 24 88 00 00 00 0F 85 8F FC FF FF 8B 84 24 C4 00 00 00 0B 84 24 C0 00 00 00 0F 85 7B FC FF FF 8B 94 24 EC 00 00 00 39 94 24 F4 00 00 00 0F 82 12 27 00 00 77 14 8B 8C 24 E8 00 00 00 39 8C 24 F0 00 00 00 0F 86 FC 26 00 00 8B 9C 24 E8 00 00 00 8B B4 24 EC 00 00 00 89 9C 24 E8 01 00 00 89 B4 24 EC 01 00 00 8B 9C 24 C8 00 00 00 39 9C 24 D8 00 00 00 0F 84 1B 3A 00 00 83 3D ?? ?? ?? ?? 01 0F 85 EE 05 00 00 83 8C 24 E8 01 00 00 00 81 8C 24 EC 01 00 00 00 00 00 80 C7 84 24 E0 01 00 00 00 00 00 00 C7 84 24 E4 01 00 00 00 00 00 00 E9 17 F7 FF FF 8B 84 24 F4 00 00 00 01 F7 8B 94 24 A0 00 00 00 89 BC 24 80 00 00 00 C1 E8 11 2D 20 18 00 00 83 FF 13 89 84 24 F8 00 00 00 8B 84 24 D0 00 00 00 8D 84 02 C0 CF FF FF 89 84 24 D0 00 00 00 0F 8E 1C 09 00 00 83 BC 24 80 00 00 00 14 0F 84 8D 1F 00 00 83 BC 24 80 00 00 00 26 0F 8F 5E 1A 00 00 83 FE 13 0F 8F B7 28 00 00 8B B4 24 A8 00 00 00 8B 84 24 94 00 00 00 8B BC 24 AC 00 00 00 89 B4 24 B0 00 00 00 8B B4 24 90 00 00 00 89 84 24 08 01 00 00 89 F0 F7 E7 89 84 24 98 00 00 00 8B 84 24 08 01 00 00 89 94 24 9C 00 00 00 F7 E7 89 84 24 A0 00 00 00 8B 84 24 B0 00 00 00 89 94 24 A4 00 00 00 F7 E6 89 94 24 94 00 00 00 8B BC 24 94 00 00 00 31 D2 89 84 24 90 00 00 00 8B 84 24 98 00 00 00 89 FE 31 FF 01 C6 8B 84 24 08 01 00 00 11 D7 F7 A4 24 B0 00 00 00 01 C6 89 F0 11 D7 89 C2 B8 00 00 00 00 89 84 24 B0 00 00 00 8B 84 24 90 00 00 00 89 94 24 B4 00 00 00 31 D2 01 84 24 B0 00 00 00 11 94 24 B4 00 00 00 8B 84 24 AC 00 00 00 8B 94 24 A8 00 00 00 0F AF C1 0F AF D3 8D 1C 02 8B 84 24 A8 00 00 00 F7 E1 01 DA 89 94 24 94 00 00 00 8B 8C 24 94 00 00 00 89 84 24 90 00 00 00 8B 94 24 90 00 00 00 01 94 24 A0 00 00 00 11 8C 24 A4 00 00 00 8B 94 24 9C 00 00 00 89 D0 31 D2 01 84 24 A0 00 00 00 11 94 24 A4 00 00 00 31 D2 01 BC 24 A0 00 00 00 11 94 24 A4 00 00 00 8B 94 24 80 00 00 00 83 EA 15 89 D0 C1 E0 04 8B B0 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 3B 84 24 A4 00 00 00 0F 87 EA 24 00 00 72 0D 3B B4 24 A0 00 00 00 0F 87 DB 24 00 00 8B 9C 24 A4 00 00 00 8B 8C 24 A0 00 00 00 C7 84 24 50 01 00 00 00 00 00 00 C7 84 24 54 01 00 00 00 00 00 00 31 C3 31 F1 09 CB C7 84 24 48 01 00 00 00 00 00 00 C7 84 24 4C 01 00 00 00 00 00 00 0F 84 B0 22 00 00 8D 76 00 8B B4 24 8C 00 00 00 0B B4 24 88 00 00 00 0F 85 2C 09 00 00 8B BC 24 C4 00 00 00 0B BC 24 C0 00 00 00 0F 85 18 09 00 00 8B 1D ?? ?? ?? ?? 83 BC 24 80 00 00 00 22 C7 05 ?? ?? ?? ?? 00 00 00 00 89 9C 24 88 00 00 00 0F 8E C8 1E 00 00 8B 9C 24 80 00 00 00 83 EB 22 83 BC 24 80 00 00 00 26 0F 8E 19 53 00 00 83 BC 24 80 00 00 00 39 0F 8F F8 4C 00 00 8B BC 24 4C 01 00 00 8B 84 24 A0 00 00 00 8B 94 24 A4 00 00 00 8B 8C 24 48 01 00 00 89 BC 24 34 02 00 00 8B BC 24 B4 00 00 00 89 84 24 28 02 00 00 8B 84 24 B0 00 00 00 89 94 24 2C 02 00 00 8D 94 24 D0 01 00 00 8B B4 24 48 01 00 00 89 54 24 34 8D 94 24 CC 01 00 00 89 BC 24 24 02 00 00 89 44 24 08 8B 84 24 24 02 00 00 89 54 24 30 8D 94 24 C8 01 00 00 89 54 24 2C 8D 94 24 C4 01 00 00 89 54 24 28 8D 94 24 D4 01 00 00 89 44 24 0C 8B 84 24 2C 02 00 00 89 54 24 24 8D 94 24 40 02 00 00 89 4C 24 18 8B 8C 24 A0 00 00 00 89 B4 24 30 02 00 00 8B B4 24 B0 00 00 00 89 54 24 20 8B 94 24 80 00 00 00 89 44 24 14 8B 84 24 34 02 00 00 89 4C 24 10 89 B4 24 20 02 00 00 89 14 24 89 44 24 1C 89 5C 24 04 E8 ?? ?? ?? ?? 8B 84 24 40 02 00 00 8B 94 24 44 02 00 00 89 84 24 E0 }
	condition:
		$1
}

rule file_32_4_0 {
	meta:
		name = "___bid128_fma"
		size = 240
	strings:
		$1 = { 53 81 EC 98 00 00 00 8B 84 24 C4 00 00 00 8D 54 24 70 8D 4C 24 74 8B 9C 24 A0 00 00 00 89 44 24 28 8B 84 24 C8 00 00 00 89 44 24 2C 8B 84 24 CC 00 00 00 89 44 24 30 8B 84 24 D0 00 00 00 89 44 24 34 8B 84 24 B4 00 00 00 89 44 24 18 8B 84 24 B8 00 00 00 89 44 24 1C 8B 84 24 BC 00 00 00 89 44 24 20 8B 84 24 C0 00 00 00 89 44 24 24 8B 84 24 A4 00 00 00 89 44 24 08 8B 84 24 A8 00 00 00 89 44 24 0C 8B 84 24 AC 00 00 00 89 44 24 10 8B 84 24 B0 00 00 00 89 44 24 14 8D 44 24 7C 89 44 24 04 8D 44 24 78 89 04 24 8D 84 24 80 00 00 00 E8 BB 2E FF FF 8B 84 24 80 00 00 00 8B 94 24 84 00 00 00 89 03 8B 84 24 88 00 00 00 89 53 04 8B 94 24 8C 00 00 00 89 43 08 89 D8 89 53 0C 81 C4 98 00 00 00 5B C3 8D 76 00 8D BC 27 00 00 00 00 }
	condition:
		$1
}

rule file_32_5_0 {
	meta:
		name = "___bid128ddd_fma"
		size = 368
		refs = "0073 ___bid64_to_bid128"
	strings:
		$1 = { 55 57 56 53 81 EC AC 00 00 00 8B 9C 24 C8 00 00 00 8B 8C 24 C4 00 00 00 8B 84 24 D4 00 00 00 8B 94 24 D8 00 00 00 8B B4 24 CC 00 00 00 8B BC 24 D0 00 00 00 89 5C 24 08 8D 5C 24 70 8B AC 24 C0 00 00 00 89 4C 24 04 89 1C 24 89 44 24 4C 89 54 24 48 C7 44 24 50 00 00 00 00 C7 44 24 54 00 00 00 00 C7 44 24 58 00 00 00 00 C7 44 24 5C 00 00 00 00 E8 ?? ?? ?? ?? 8D 8C 24 80 00 00 00 89 74 24 04 89 7C 24 08 89 0C 24 E8 ?? ?? ?? ?? 8B 44 24 4C 8D 8C 24 90 00 00 00 8B 54 24 48 89 0C 24 89 44 24 04 89 54 24 08 E8 ?? ?? ?? ?? 8B 84 24 90 00 00 00 8D 54 24 50 8D 4C 24 54 89 44 24 28 8B 84 24 94 00 00 00 89 44 24 2C 8B 84 24 98 00 00 00 89 44 24 30 8B 84 24 9C 00 00 00 89 44 24 34 8B 84 24 80 00 00 00 89 44 24 18 8B 84 24 84 00 00 00 89 44 24 1C 8B 84 24 88 00 00 00 89 44 24 20 8B 84 24 8C 00 00 00 89 44 24 24 8B 44 24 70 89 44 24 08 8B 44 24 74 89 44 24 0C 8B 44 24 78 89 44 24 10 8B 44 24 7C 89 44 24 14 8D 44 24 5C 89 44 24 04 8D 44 24 58 89 04 24 8D 44 24 60 E8 3B 2D FF FF 8B 44 24 60 8B 54 24 64 89 45 00 8B 44 24 68 89 55 04 8B 54 24 6C 89 45 08 89 E8 89 55 0C 81 C4 AC 00 00 00 5B 5E 5F 5D C3 66 90 }
	condition:
		$1
}

rule file_32_6_0 {
	meta:
		name = "___bid128ddq_fma"
		size = 352
		refs = "0088 ___bid64_to_bid128"
	strings:
		$1 = { 57 56 53 81 EC 90 00 00 00 8B 84 24 B4 00 00 00 8D 4C 24 70 8B 94 24 A8 00 00 00 8B B4 24 AC 00 00 00 8B BC 24 B0 00 00 00 89 44 24 40 8B 84 24 B8 00 00 00 89 54 24 08 8B 9C 24 A0 00 00 00 89 0C 24 C7 44 24 50 00 00 00 00 89 44 24 44 8B 84 24 BC 00 00 00 C7 44 24 54 00 00 00 00 C7 44 24 58 00 00 00 00 C7 44 24 5C 00 00 00 00 89 44 24 48 8B 84 24 C0 00 00 00 89 44 24 4C 8B 84 24 A4 00 00 00 89 44 24 04 E8 ?? ?? ?? ?? 8D 84 24 80 00 00 00 89 74 24 04 89 7C 24 08 89 04 24 E8 ?? ?? ?? ?? 8B 44 24 40 8D 54 24 50 8D 4C 24 54 89 44 24 28 8B 44 24 44 89 44 24 2C 8B 44 24 48 89 44 24 30 8B 44 24 4C 89 44 24 34 8B 84 24 80 00 00 00 89 44 24 18 8B 84 24 84 00 00 00 89 44 24 1C 8B 84 24 88 00 00 00 89 44 24 20 8B 84 24 8C 00 00 00 89 44 24 24 8B 44 24 70 89 44 24 08 8B 44 24 74 89 44 24 0C 8B 44 24 78 89 44 24 10 8B 44 24 7C 89 44 24 14 8D 44 24 5C 89 44 24 04 8D 44 24 58 89 04 24 8D 44 24 60 E8 E1 2B FF FF 8B 44 24 60 8B 54 24 64 89 03 8B 44 24 68 89 53 04 8B 54 24 6C 89 43 08 89 D8 89 53 0C 81 C4 90 00 00 00 5B 5E 5F C3 8D 76 00 8D BC 27 00 00 00 00 }
	condition:
		$1
}

rule file_32_7_0 {
	meta:
		name = "___bid128dqd_fma"
		size = 352
		refs = "0088 ___bid64_to_bid128"
	strings:
		$1 = { 57 56 53 81 EC 90 00 00 00 8B 84 24 AC 00 00 00 8D 4C 24 70 8B 94 24 A8 00 00 00 8B B4 24 BC 00 00 00 8B BC 24 C0 00 00 00 89 44 24 40 8B 84 24 B0 00 00 00 89 54 24 08 8B 9C 24 A0 00 00 00 89 0C 24 C7 44 24 50 00 00 00 00 89 44 24 44 8B 84 24 B4 00 00 00 C7 44 24 54 00 00 00 00 C7 44 24 58 00 00 00 00 C7 44 24 5C 00 00 00 00 89 44 24 48 8B 84 24 B8 00 00 00 89 44 24 4C 8B 84 24 A4 00 00 00 89 44 24 04 E8 ?? ?? ?? ?? 8D 84 24 80 00 00 00 89 74 24 04 89 7C 24 08 89 04 24 E8 ?? ?? ?? ?? 8B 84 24 80 00 00 00 8D 54 24 50 8D 4C 24 54 89 44 24 28 8B 84 24 84 00 00 00 89 44 24 2C 8B 84 24 88 00 00 00 89 44 24 30 8B 84 24 8C 00 00 00 89 44 24 34 8B 44 24 40 89 44 24 18 8B 44 24 44 89 44 24 1C 8B 44 24 48 89 44 24 20 8B 44 24 4C 89 44 24 24 8B 44 24 70 89 44 24 08 8B 44 24 74 89 44 24 0C 8B 44 24 78 89 44 24 10 8B 44 24 7C 89 44 24 14 8D 44 24 5C 89 44 24 04 8D 44 24 58 89 04 24 8D 44 24 60 E8 81 2A FF FF 8B 44 24 60 8B 54 24 64 89 03 8B 44 24 68 89 53 04 8B 54 24 6C 89 43 08 89 D8 89 53 0C 81 C4 90 00 00 00 5B 5E 5F C3 8D 76 00 8D BC 27 00 00 00 00 }
	condition:
		$1
}

rule file_32_8_0 {
	meta:
		name = "___bid128dqq_fma"
		size = 352
		refs = "00a7 ___bid64_to_bid128"
	strings:
		$1 = { 53 81 EC 98 00 00 00 8B 84 24 AC 00 00 00 8D 8C 24 80 00 00 00 8B 94 24 A8 00 00 00 89 0C 24 8B 9C 24 A0 00 00 00 C7 44 24 60 00 00 00 00 89 44 24 50 8B 84 24 B0 00 00 00 89 54 24 08 C7 44 24 64 00 00 00 00 C7 44 24 68 00 00 00 00 89 44 24 54 8B 84 24 B4 00 00 00 C7 44 24 6C 00 00 00 00 89 44 24 58 8B 84 24 B8 00 00 00 89 44 24 5C 8B 84 24 BC 00 00 00 89 44 24 40 8B 84 24 C0 00 00 00 89 44 24 44 8B 84 24 C4 00 00 00 89 44 24 48 8B 84 24 C8 00 00 00 89 44 24 4C 8B 84 24 A4 00 00 00 89 44 24 04 E8 ?? ?? ?? ?? 8B 44 24 40 8D 54 24 60 8D 4C 24 64 89 44 24 28 8B 44 24 44 89 44 24 2C 8B 44 24 48 89 44 24 30 8B 44 24 4C 89 44 24 34 8B 44 24 50 89 44 24 18 8B 44 24 54 89 44 24 1C 8B 44 24 58 89 44 24 20 8B 44 24 5C 89 44 24 24 8B 84 24 80 00 00 00 89 44 24 08 8B 84 24 84 00 00 00 89 44 24 0C 8B 84 24 88 00 00 00 89 44 24 10 8B 84 24 8C 00 00 00 89 44 24 14 8D 44 24 6C 89 44 24 04 8D 44 24 68 89 04 24 8D 44 24 70 E8 19 29 FF FF 8B 44 24 70 8B 54 24 74 89 03 8B 44 24 78 89 53 04 8B 54 24 7C 89 43 08 89 D8 89 53 0C 81 C4 98 00 00 00 5B C3 8D 74 26 00 }
	condition:
		$1
}

rule file_32_9_0 {
	meta:
		name = "___bid128qdd_fma"
		size = 352
		refs = "0088 ___bid64_to_bid128"
	strings:
		$1 = { 57 56 53 81 EC 90 00 00 00 8B 84 24 A4 00 00 00 8D 4C 24 70 8B 94 24 B8 00 00 00 8B B4 24 BC 00 00 00 8B BC 24 C0 00 00 00 89 44 24 40 8B 84 24 A8 00 00 00 89 54 24 08 8B 9C 24 A0 00 00 00 89 0C 24 C7 44 24 50 00 00 00 00 89 44 24 44 8B 84 24 AC 00 00 00 C7 44 24 54 00 00 00 00 C7 44 24 58 00 00 00 00 C7 44 24 5C 00 00 00 00 89 44 24 48 8B 84 24 B0 00 00 00 89 44 24 4C 8B 84 24 B4 00 00 00 89 44 24 04 E8 ?? ?? ?? ?? 8D 84 24 80 00 00 00 89 74 24 04 89 7C 24 08 89 04 24 E8 ?? ?? ?? ?? 8B 84 24 80 00 00 00 8D 54 24 50 8D 4C 24 54 89 44 24 28 8B 84 24 84 00 00 00 89 44 24 2C 8B 84 24 88 00 00 00 89 44 24 30 8B 84 24 8C 00 00 00 89 44 24 34 8B 44 24 70 89 44 24 18 8B 44 24 74 89 44 24 1C 8B 44 24 78 89 44 24 20 8B 44 24 7C 89 44 24 24 8B 44 24 40 89 44 24 08 8B 44 24 44 89 44 24 0C 8B 44 24 48 89 44 24 10 8B 44 24 4C 89 44 24 14 8D 44 24 5C 89 44 24 04 8D 44 24 58 89 04 24 8D 44 24 60 E8 C1 27 FF FF 8B 44 24 60 8B 54 24 64 89 03 8B 44 24 68 89 53 04 8B 54 24 6C 89 43 08 89 D8 89 53 0C 81 C4 90 00 00 00 5B 5E 5F C3 8D 76 00 8D BC 27 00 00 00 00 }
	condition:
		$1
}

rule file_32_10_0 {
	meta:
		name = "___bid128qdq_fma"
		size = 352
		refs = "00a7 ___bid64_to_bid128"
	strings:
		$1 = { 53 81 EC 98 00 00 00 8B 84 24 A4 00 00 00 8D 8C 24 80 00 00 00 8B 94 24 B8 00 00 00 89 0C 24 8B 9C 24 A0 00 00 00 C7 44 24 60 00 00 00 00 89 44 24 50 8B 84 24 A8 00 00 00 89 54 24 08 C7 44 24 64 00 00 00 00 C7 44 24 68 00 00 00 00 89 44 24 54 8B 84 24 AC 00 00 00 C7 44 24 6C 00 00 00 00 89 44 24 58 8B 84 24 B0 00 00 00 89 44 24 5C 8B 84 24 BC 00 00 00 89 44 24 40 8B 84 24 C0 00 00 00 89 44 24 44 8B 84 24 C4 00 00 00 89 44 24 48 8B 84 24 C8 00 00 00 89 44 24 4C 8B 84 24 B4 00 00 00 89 44 24 04 E8 ?? ?? ?? ?? 8B 44 24 40 8D 54 24 60 8D 4C 24 64 89 44 24 28 8B 44 24 44 89 44 24 2C 8B 44 24 48 89 44 24 30 8B 44 24 4C 89 44 24 34 8B 84 24 80 00 00 00 89 44 24 18 8B 84 24 84 00 00 00 89 44 24 1C 8B 84 24 88 00 00 00 89 44 24 20 8B 84 24 8C 00 00 00 89 44 24 24 8B 44 24 50 89 44 24 08 8B 44 24 54 89 44 24 0C 8B 44 24 58 89 44 24 10 8B 44 24 5C 89 44 24 14 8D 44 24 6C 89 44 24 04 8D 44 24 68 89 04 24 8D 44 24 70 E8 59 26 FF FF 8B 44 24 70 8B 54 24 74 89 03 8B 44 24 78 89 53 04 8B 54 24 7C 89 43 08 89 D8 89 53 0C 81 C4 98 00 00 00 5B C3 8D 74 26 00 }
	condition:
		$1
}

rule file_32_11_0 {
	meta:
		name = "___bid128qqd_fma"
		size = 352
		refs = "00a7 ___bid64_to_bid128"
	strings:
		$1 = { 53 81 EC 98 00 00 00 8B 84 24 A4 00 00 00 8D 8C 24 80 00 00 00 8B 94 24 C8 00 00 00 89 0C 24 8B 9C 24 A0 00 00 00 C7 44 24 60 00 00 00 00 89 44 24 50 8B 84 24 A8 00 00 00 89 54 24 08 C7 44 24 64 00 00 00 00 C7 44 24 68 00 00 00 00 89 44 24 54 8B 84 24 AC 00 00 00 C7 44 24 6C 00 00 00 00 89 44 24 58 8B 84 24 B0 00 00 00 89 44 24 5C 8B 84 24 B4 00 00 00 89 44 24 40 8B 84 24 B8 00 00 00 89 44 24 44 8B 84 24 BC 00 00 00 89 44 24 48 8B 84 24 C0 00 00 00 89 44 24 4C 8B 84 24 C4 00 00 00 89 44 24 04 E8 ?? ?? ?? ?? 8B 84 24 80 00 00 00 8D 54 24 60 8D 4C 24 64 89 44 24 28 8B 84 24 84 00 00 00 89 44 24 2C 8B 84 24 88 00 00 00 89 44 24 30 8B 84 24 8C 00 00 00 89 44 24 34 8B 44 24 40 89 44 24 18 8B 44 24 44 89 44 24 1C 8B 44 24 48 89 44 24 20 8B 44 24 4C 89 44 24 24 8B 44 24 50 89 44 24 08 8B 44 24 54 89 44 24 0C 8B 44 24 58 89 44 24 10 8B 44 24 5C 89 44 24 14 8D 44 24 6C 89 44 24 04 8D 44 24 68 89 04 24 8D 44 24 70 E8 F9 24 FF FF 8B 44 24 70 8B 54 24 74 89 03 8B 44 24 78 89 53 04 8B 54 24 7C 89 43 08 89 D8 89 53 0C 81 C4 98 00 00 00 5B C3 8D 74 26 00 }
	condition:
		$1
}

rule file_32_12_0 {
	meta:
		name = "___bid64qqq_fma"
		size = 3488
		refs = "000c ___bid_IDEC_glbflags 0181 ___bid_IDEC_glbround 020d ___bid128_to_bid64 03a1 ___bid_nr_digits 04c6 ___bid_round128_19_38 05bd ___bid_ten2k64 0a24 ___bid_round64_2_18 0cd0 ___bid_midpoint64"
	strings:
		$1 = { 55 57 56 53 81 EC 0C 01 00 00 8B 2D ?? ?? ?? ?? 8B 84 24 40 01 00 00 8D 8C 24 A8 00 00 00 C7 84 24 A4 00 00 00 00 00 00 00 8D 94 24 A4 00 00 00 C7 84 24 A8 00 00 00 00 00 00 00 C7 84 24 AC 00 00 00 00 00 00 00 89 44 24 28 8B 84 24 44 01 00 00 C7 84 24 B0 00 00 00 00 00 00 00 C7 84 24 B4 00 00 00 00 00 00 00 C7 84 24 B8 00 00 00 00 00 00 00 89 44 24 2C 8B 84 24 48 01 00 00 C7 84 24 BC 00 00 00 00 00 00 00 C7 84 24 C0 00 00 00 00 00 00 00 C7 84 24 E0 00 00 00 DD BA DD BA 89 44 24 30 8B 84 24 4C 01 00 00 C7 84 24 E4 00 00 00 DD BA DD BA C7 84 24 E8 00 00 00 DD BA DD BA C7 84 24 EC 00 00 00 DD BA DD BA 89 44 24 34 8B 84 24 30 01 00 00 C7 84 24 C8 00 00 00 DD BA DD BA C7 84 24 CC 00 00 00 DD BA DD BA C7 05 ?? ?? ?? ?? 00 00 00 00 89 44 24 18 8B 84 24 34 01 00 00 89 44 24 1C 8B 84 24 38 01 00 00 89 44 24 20 8B 84 24 3C 01 00 00 89 44 24 24 8B 84 24 20 01 00 00 89 44 24 08 8B 84 24 24 01 00 00 89 44 24 0C 8B 84 24 28 01 00 00 89 44 24 10 8B 84 24 2C 01 00 00 89 44 24 14 8D 84 24 B0 00 00 00 89 44 24 04 8D 84 24 AC 00 00 00 89 04 24 8D 84 24 D0 00 00 00 E8 69 23 FF FF 8B 84 24 D0 00 00 00 8B 94 24 D4 00 00 00 8B B4 24 DC 00 00 00 89 44 24 50 A1 ?? ?? ?? ?? 89 54 24 54 8B 94 24 D8 00 00 00 8D 48 FF 83 F9 02 0F 86 86 00 00 00 89 F1 81 E1 00 00 00 7C 81 F9 00 00 00 7C 74 76 81 F9 00 00 00 78 74 6E 89 F3 89 F7 81 E3 FF FF 01 00 81 E7 00 00 FE 7F 89 D1 89 DA C1 EF 11 09 CA 0F 85 3D 01 00 00 8B 54 24 54 0B 54 24 50 0F 85 2F 01 00 00 8B 84 24 D0 00 00 00 89 04 24 8B 84 24 D4 00 00 00 89 44 24 04 8B 84 24 D8 00 00 00 89 44 24 08 8B 84 24 DC 00 00 00 89 44 24 0C E8 ?? ?? ?? ?? 09 2D ?? ?? ?? ?? 81 C4 0C 01 00 00 5B 5E 5F 5D C3 8B 84 24 D0 00 00 00 89 04 24 8B 84 24 D4 00 00 00 89 44 24 04 8B 84 24 D8 00 00 00 89 44 24 08 8B 84 24 DC 00 00 00 89 44 24 0C E8 ?? ?? ?? ?? 89 D1 81 E1 00 00 00 7C 81 F9 00 00 00 7C 74 5E F7 C2 00 00 E0 7F 75 56 89 D1 81 E1 FF FF 1F 00 81 F9 7E 8D 03 00 77 46 72 07 3D FF 7F C6 A4 77 3D 8B BC 24 AC 00 00 00 85 FF 75 22 8B B4 24 B0 00 00 00 85 F6 75 17 8B 9C 24 A4 00 00 00 85 DB 75 0C 8B 8C 24 A8 00 00 00 85 C9 74 4E 90 8B 0D ?? ?? ?? ?? 83 C9 30 EB 19 90 8D 74 26 00 8B BC 24 AC 00 00 00 85 FF 74 1C 8B 0D ?? ?? ?? ?? 83 C9 20 09 CD 89 2D ?? ?? ?? ?? 81 C4 0C 01 00 00 5B 5E 5F 5D C3 8B B4 24 B0 00 00 00 85 F6 75 D9 8B 9C 24 A4 00 00 00 85 DB 75 CE 8B 8C 24 A8 00 00 00 85 C9 75 C3 8B 0D ?? ?? ?? ?? EB C4 8D 97 90 E9 FF FF 81 FA 30 03 00 00 0F 87 BF FE FF FF 83 F8 04 0F 84 77 06 00 00 89 D8 09 C8 75 3F 81 7C 24 54 FF FF 1F 00 0F 86 F1 06 00 00 8B 54 24 54 89 D0 31 D2 89 44 24 68 89 54 24 6C DF 6C 24 68 DD 5C 24 58 8B 54 24 5C 89 D0 C1 E8 14 25 FF 07 00 00 2D DE 03 00 00 EB 27 8D 74 26 00 89 4C 24 68 89 5C 24 6C DF 6C 24 68 DD 5C 24 58 8B 54 24 5C 89 D0 C1 E8 14 25 FF 07 00 00 2D BE 03 00 00 83 E8 01 89 C2 C1 E2 05 89 44 24 48 8B 82 ?? ?? ?? ?? 85 C0 89 44 24 58 75 58 8B 82 ?? ?? ?? ?? 89 44 24 58 8B 82 ?? ?? ?? ?? 8B 92 ?? ?? ?? ?? 89 44 24 64 39 D3 77 35 72 04 39 C1 77 2F 8B 44 24 64 31 DA 31 C8 09 C2 75 28 8B 44 24 48 8B 54 24 54 C1 E0 05 05 ?? ?? ?? ?? 39 50 14 77 13 72 0C 8B 54 24 50 39 50 10 77 08 8D 76 00 83 44 24 58 01 81 EF 20 18 00 00 83 7C 24 58 10 0F 8E EA 00 00 00 8B 44 24 58 83 E8 10 83 7C 24 58 12 89 44 24 64 0F 8E 9A 05 00 00 8B 54 24 54 89 8C 24 F8 00 00 00 8B 44 24 50 89 9C 24 FC 00 00 00 89 94 24 F4 00 00 00 89 CA 8D 8C 24 C0 00 00 00 89 4C 24 2C 8D 8C 24 BC 00 00 00 89 4C 24 28 8D 8C 24 B8 00 00 00 89 4C 24 24 8D 8C 24 B4 00 00 00 89 4C 24 20 8D 8C 24 C4 00 00 00 89 4C 24 1C 8D 8C 24 E0 00 00 00 89 4C 24 18 8B 8C 24 F4 00 00 00 89 54 24 10 8B 94 24 FC 00 00 00 89 44 24 08 8B 44 24 50 89 4C 24 0C 8B 4C 24 58 89 54 24 14 8B 54 24 64 89 84 24 F0 00 00 00 89 0C 24 89 54 24 04 E8 ?? ?? ?? ?? 8B 8C 24 E0 00 00 00 8B 9C 24 E4 00 00 00 89 8C 24 C8 00 00 00 89 9C 24 CC 00 00 00 03 7C 24 64 83 BC 24 C4 00 00 00 01 C7 44 24 58 10 00 00 00 83 DF FF EB 17 90 8B 44 24 50 8B 54 24 54 89 84 24 C8 00 00 00 89 94 24 CC 00 00 00 8B 84 24 B0 00 00 00 85 C0 75 0F 8B 8C 24 A4 00 00 00 85 C9 0F 84 50 01 00 00 8B 94 24 B4 00 00 00 85 D2 0F 84 41 01 00 00 8B 84 24 C8 00 00 00 8B 94 24 CC 00 00 00 C7 84 24 B4 00 00 00 00 00 00 00 C7 84 24 BC 00 00 00 01 00 00 00 83 C0 FF 83 D2 FF 89 84 24 C8 00 00 00 35 FF 7F C6 A4 89 94 24 CC 00 00 00 81 F2 7E 8D 03 00 09 C2 0F 84 66 05 00 00 8B 44 24 58 81 E6 00 00 00 80 01 F8 3D 81 01 00 00 0F 8F 77 02 00 00 81 FF 71 01 00 00 0F 8E F3 01 00 00 81 EF 71 01 00 00 8B 84 24 CC 00 00 00 8B 0C FD ?? ?? ?? ?? 0F AF 8C 24 C8 00 00 00 0F AF 04 FD ?? ?? ?? ?? 01 C1 8B 84 24 C8 00 00 00 F7 24 FD ?? ?? ?? ?? 01 CA 89 54 24 54 8B 4C 24 54 89 44 24 50 8B 54 24 50 81 7C 24 58 11 FD FF FF 89 8C 24 CC 00 00 00 89 94 24 C8 00 00 00 0F 8D 71 04 00 00 8B 8C 24 BC 00 00 00 B8 FF 02 00 00 85 C9 75 51 8B 8C 24 C0 00 00 00 85 C9 75 46 8B 94 24 B4 00 00 00 85 D2 75 3B 8B BC 24 B8 00 00 00 85 FF 75 30 8B 9C 24 AC 00 00 00 85 DB 75 25 8B 8C 24 B0 00 00 00 85 C9 75 1A 83 BC 24 A4 00 00 00 00 75 10 83 BC 24 A8 00 00 00 00 0F 84 6F 01 00 00 66 90 83 0D ?? ?? ?? ?? 30 E9 61 01 00 00 8D 74 26 00 8B 94 24 AC 00 00 00 85 D2 0F 85 94 00 00 00 8B 9C 24 A8 00 00 00 85 DB 0F 85 85 00 00 00 8B 9C 24 B4 00 00 00 8B 8C 24 B8 00 00 00 85 DB 89 5C 24 50 0F 85 AE 04 00 00 85 C9 0F 84 80 00 00 00 85 C0 0F 85 C9 04 00 00 8B 84 24 A4 00 00 00 85 C0 0F 85 BA 04 00 00 8B 44 24 50 85 C0 0F 84 A7 FE FF FF 8B 84 24 A8 00 00 00 85 C0 0F 84 98 FE FF FF C7 84 24 BC 00 00 00 00 00 00 00 C7 84 24 C0 00 00 00 01 00 00 00 C7 84 24 B4 00 00 00 00 00 00 00 C7 84 24 B8 00 00 00 00 00 00 00 E9 67 FE FF FF 8B 8C 24 B8 00 00 00 85 C9 0F 85 1E 03 00 00 83 BC 24 B4 00 00 00 00 0F 85 82 04 00 00 8B 9C 24 BC 00 00 00 85 DB 0F 85 3B FE FF FF 8B 8C 24 C0 00 00 00 85 C9 0F 85 2C FE FF FF 85 C0 75 0B 8B 84 24 A4 00 00 00 85 C0 74 0B C7 84 24 C0 00 00 00 01 00 00 00 85 D2 75 0F 8B 84 24 A8 00 00 00 85 C0 0F 84 FF FD FF FF C7 84 24 BC 00 00 00 01 00 00 00 E9 EF FD FF FF 90 8D 74 26 00 3D 82 FE FF FF 0F 8C 8B 00 00 00 8D 87 8E 01 00 00 8B 94 24 BC 00 00 00 85 D2 0F 84 D0 02 00 00 83 0D ?? ?? ?? ?? 20 8B 8C 24 C8 00 00 00 8B 9C 24 CC 00 00 00 89 4C 24 50 89 5C 24 54 83 3D ?? ?? ?? ?? 04 0F 84 89 03 00 00 81 7C 24 54 FF FF 1F 00 0F 87 88 01 00 00 89 C2 8B 44 24 50 C1 E2 15 09 F2 0B 54 24 54 09 2D ?? ?? ?? ?? 81 C4 0C 01 00 00 5B 5E 5F 5D C3 0B 2D ?? ?? ?? ?? 89 F2 31 C0 81 CA 00 00 00 78 83 CD 28 89 2D ?? ?? ?? ?? E9 A6 FA FF FF 81 FF 72 FE FF FF 0F 8D 80 02 00 00 8B 84 24 BC 00 00 00 BA 72 FE FF FF 8B 8C 24 B4 00 00 00 29 FA 39 54 24 58 C7 84 24 BC 00 00 00 00 00 00 00 89 84 24 AC 00 00 00 8B 84 24 C0 00 00 00 89 8C 24 A4 00 00 00 8B 8C 24 B8 00 00 00 C7 84 24 C0 00 00 00 00 00 00 00 C7 84 24 B4 00 00 00 00 00 00 00 89 84 24 B0 00 00 00 89 8C 24 A8 00 00 00 C7 84 24 B8 00 00 00 00 00 00 00 0F 8F 39 03 00 00 3B 54 24 58 0F 84 FE 03 00 00 C7 84 24 BC 00 00 00 01 00 00 00 C7 44 24 50 00 00 00 00 C7 44 24 54 00 00 00 00 85 C0 0F 85 EC 02 00 00 8B BC 24 A4 00 00 00 85 FF 0F 85 DD 02 00 00 8B 94 24 AC 00 00 00 85 D2 0F 85 0C 02 00 00 8B 8C 24 A8 00 00 00 85 C9 0F 85 FD 01 00 00 8B 9C 24 B4 00 00 00 8B 8C 24 B8 00 00 00 85 DB 0F 85 F9 03 00 00 85 C9 0F 85 F9 03 00 00 8B 9C 24 BC 00 00 00 85 DB 0F 85 01 04 00 00 8B 8C 24 C0 00 00 00 85 C9 0F 85 F2 03 00 00 85 C0 75 0A 83 BC 24 A4 00 00 00 00 74 0B C7 84 24 C0 00 00 00 01 00 00 00 85 D2 75 0E 83 BC 24 A8 00 00 00 00 0F 84 E7 01 00 00 31 C0 E9 F1 FC FF FF 90 8B 4C 24 54 89 F2 C1 E0 13 81 CA 00 00 00 60 09 C2 8B 44 24 50 81 E1 FF FF 07 00 09 CA E9 65 FE FF FF 8B 84 24 B8 00 00 00 85 C0 0F 84 7A F9 FF FF 83 84 24 C8 00 00 00 FF 83 94 24 CC 00 00 00 FF E9 65 F9 FF FF 8D 94 24 C0 00 00 00 8B 4C 24 54 89 54 24 24 8D 94 24 BC 00 00 00 89 54 24 20 8D 94 24 B8 00 00 00 89 54 24 1C 8D 94 24 B4 00 00 00 89 54 24 18 8D 94 24 C4 00 00 00 89 54 24 14 8D 94 24 C8 00 00 00 89 54 24 10 8B 54 24 50 89 4C 24 0C 8B 4C 24 58 89 44 24 04 89 54 24 08 89 0C 24 E8 ?? ?? ?? ?? E9 B9 FA FF FF 8D 76 00 DF 6C 24 50 DD 5C 24 58 8B 54 24 5C 89 D0 C1 E8 14 25 FF 07 00 00 2D FE 03 00 00 E9 43 F9 FF FF 83 84 24 C8 00 00 00 01 83 94 24 CC 00 00 00 00 C7 84 24 B8 00 00 00 00 00 00 00 C7 84 24 C0 00 00 00 01 00 00 00 E9 0F FB FF FF 90 8D 74 26 00 B8 FF 02 00 00 E9 27 FD FF FF 8D B6 00 00 00 00 8B BC 24 C0 00 00 00 85 FF 0F 85 21 FD FF FF 8B 9C 24 B4 00 00 00 85 DB 0F 85 12 FD FF FF 8B 8C 24 B8 00 00 00 85 C9 0F 85 03 FD FF FF E9 05 FD FF FF 8B 84 24 C8 00 00 00 8B 94 24 CC 00 00 00 8B 8C 24 BC 00 00 00 89 44 24 50 8D 87 8E 01 00 00 89 54 24 54 E9 31 FB FF FF 8D B6 00 00 00 00 C7 84 24 C8 00 00 00 FF FF C0 6F 83 EF 01 C7 84 24 CC 00 00 00 F2 86 23 00 E9 7C FA FF FF 8B BC 24 B8 00 00 00 85 FF 0F 85 74 01 00 00 83 BC 24 B4 00 00 00 00 0F 84 04 FE FF FF 85 D2 75 0F 8B 9C 24 A8 00 00 00 85 DB 0F 84 01 02 00 00 C7 84 24 C0 00 00 00 01 00 00 00 C7 84 24 B4 00 00 00 00 00 00 00 C7 84 24 B8 00 00 00 00 00 00 00 31 C0 E9 B9 FA FF FF 85 C9 0F 84 75 FB FF FF E9 4D FB FF FF 8B 94 24 B8 00 00 00 85 D2 0F 84 68 FC FF FF 83 44 24 50 01 83 54 24 54 00 E9 59 FC FF FF C7 84 24 BC 00 00 00 01 00 00 00 C7 84 24 C0 00 00 00 00 00 00 00 C7 84 24 B4 00 00 00 00 00 00 00 C7 84 24 B8 00 00 00 00 00 00 00 E9 C8 F9 FF FF 85 D2 0F 85 28 FB FF FF E9 14 FB FF FF 90 8B 9C 24 B4 00 00 00 85 DB 0F 84 14 FD FF FF 83 44 24 50 FF 83 54 24 54 FF 31 C0 E9 80 FA FF FF 8B 9C 24 CC 00 00 00 8D 84 24 C0 00 00 00 89 44 24 24 8D 84 24 BC 00 00 00 8B 8C 24 C8 00 00 00 89 44 24 20 8D 84 24 B8 00 00 00 89 44 24 1C 8D 84 24 B4 00 00 00 89 5C 24 0C 8B 5C 24 58 89 44 24 18 8D 84 24 C4 00 00 00 89 44 24 14 8D 84 24 C8 00 00 00 89 44 24 10 89 54 24 04 89 4C 24 08 89 1C 24 89 54 24 4C E8 ?? ?? ?? ?? 8B 84 24 C4 00 00 00 8B 54 24 4C 85 C0 0F 85 DE 00 00 00 8B 94 24 C8 00 00 00 8B 8C 24 CC 00 00 00 8B 84 24 B0 00 00 00 89 54 24 50 89 4C 24 54 E9 4B FC FF FF 83 44 24 50 01 83 54 24 54 00 31 C0 8B 8C 24 BC 00 00 00 C7 84 24 B8 00 00 00 00 00 00 00 C7 84 24 C0 00 00 00 01 00 00 00 E9 5C F9 FF FF BA 71 FE FF FF 29 FA 8B BC 24 C8 00 00 00 8B 0C D5 ?? ?? ?? ?? 8B 1C D5 ?? ?? ?? ?? 8B 94 24 CC 00 00 00 39 D1 72 0E 0F 87 D5 FB FF FF 39 FB 0F 87 CD FB FF FF 31 CA 31 FB 09 DA 0F 84 87 00 00 00 C7 84 24 C0 00 00 00 01 00 00 00 C7 44 24 50 01 00 00 00 C7 44 24 54 00 00 00 00 E9 BC FB FF FF 85 C9 0F 84 07 FE FF FF 85 C0 75 49 8B BC 24 A4 00 00 00 85 FF 75 3E 85 DB 0F 85 F0 FD FF FF 8B 8C 24 BC 00 00 00 31 C0 E9 CE F8 FF FF 8B 5C 24 58 29 D3 8B 04 DD ?? ?? ?? ?? 8B 14 DD ?? ?? ?? ?? 89 44 24 50 8B 84 24 B0 00 00 00 89 54 24 54 E9 67 FB FF FF C7 84 24 B8 00 00 00 00 00 00 00 31 C0 E9 E9 F8 FF FF C7 84 24 B8 00 00 00 01 00 00 00 E9 35 FB FF FF 89 F6 8D BC 27 00 00 00 00 }
	condition:
		$1
}

rule file_32_13_0 {
	meta:
		name = "___bid64qqd_fma"
		size = 224
		refs = "006d ___bid64_to_bid128"
	strings:
		$1 = { 83 EC 6C 8B 44 24 70 8D 4C 24 50 8B 94 24 94 00 00 00 89 0C 24 89 44 24 40 8B 44 24 74 89 54 24 08 89 44 24 44 8B 44 24 78 89 44 24 48 8B 44 24 7C 89 44 24 4C 8B 84 24 80 00 00 00 89 44 24 30 8B 84 24 84 00 00 00 89 44 24 34 8B 84 24 88 00 00 00 89 44 24 38 8B 84 24 8C 00 00 00 89 44 24 3C 8B 84 24 90 00 00 00 89 44 24 04 E8 ?? ?? ?? ?? 8B 44 24 50 89 44 24 20 8B 44 24 54 89 44 24 24 8B 44 24 58 89 44 24 28 8B 44 24 5C 89 44 24 2C 8B 44 24 30 89 44 24 10 8B 44 24 34 89 44 24 14 8B 44 24 38 89 44 24 18 8B 44 24 3C 89 44 24 1C 8B 44 24 40 89 04 24 8B 44 24 44 89 44 24 04 8B 44 24 48 89 44 24 08 8B 44 24 4C 89 44 24 0C E8 8B F1 FF FF 83 C4 6C C3 8D B4 26 00 00 00 00 }
	condition:
		$1
}

rule file_32_14_0 {
	meta:
		name = "___bid64qdq_fma"
		size = 224
		refs = "006d ___bid64_to_bid128"
	strings:
		$1 = { 83 EC 6C 8B 44 24 70 8D 4C 24 50 8B 94 24 84 00 00 00 89 0C 24 89 44 24 40 8B 44 24 74 89 54 24 08 89 44 24 44 8B 44 24 78 89 44 24 48 8B 44 24 7C 89 44 24 4C 8B 84 24 88 00 00 00 89 44 24 30 8B 84 24 8C 00 00 00 89 44 24 34 8B 84 24 90 00 00 00 89 44 24 38 8B 84 24 94 00 00 00 89 44 24 3C 8B 84 24 80 00 00 00 89 44 24 04 E8 ?? ?? ?? ?? 8B 44 24 30 89 44 24 20 8B 44 24 34 89 44 24 24 8B 44 24 38 89 44 24 28 8B 44 24 3C 89 44 24 2C 8B 44 24 50 89 44 24 10 8B 44 24 54 89 44 24 14 8B 44 24 58 89 44 24 18 8B 44 24 5C 89 44 24 1C 8B 44 24 40 89 04 24 8B 44 24 44 89 44 24 04 8B 44 24 48 89 44 24 08 8B 44 24 4C 89 44 24 0C E8 AB F0 FF FF 83 C4 6C C3 8D B4 26 00 00 00 00 }
	condition:
		$1
}

rule file_32_15_0 {
	meta:
		name = "___bid64qdd_fma"
		size = 224
		refs = "0051 ___bid64_to_bid128"
	strings:
		$1 = { 57 56 83 EC 64 8B 44 24 70 8D 4C 24 40 8B 94 24 84 00 00 00 8B B4 24 88 00 00 00 8B BC 24 8C 00 00 00 89 44 24 30 8B 44 24 74 89 54 24 08 89 0C 24 89 44 24 34 8B 44 24 78 89 44 24 38 8B 44 24 7C 89 44 24 3C 8B 84 24 80 00 00 00 89 44 24 04 E8 ?? ?? ?? ?? 8D 44 24 50 89 74 24 04 89 7C 24 08 89 04 24 E8 ?? ?? ?? ?? 8B 44 24 50 89 44 24 20 8B 44 24 54 89 44 24 24 8B 44 24 58 89 44 24 28 8B 44 24 5C 89 44 24 2C 8B 44 24 40 89 44 24 10 8B 44 24 44 89 44 24 14 8B 44 24 48 89 44 24 18 8B 44 24 4C 89 44 24 1C 8B 44 24 30 89 04 24 8B 44 24 34 89 44 24 04 8B 44 24 38 89 44 24 08 8B 44 24 3C 89 44 24 0C E8 D3 EF FF FF 83 C4 64 5E 5F C3 8D B6 00 00 00 00 8D BC 27 00 00 00 00 }
	condition:
		$1
}

rule file_32_16_0 {
	meta:
		name = "___bid64dqq_fma"
		size = 224
		refs = "006d ___bid64_to_bid128"
	strings:
		$1 = { 83 EC 6C 8B 44 24 78 8D 4C 24 50 8B 54 24 74 89 0C 24 89 44 24 40 8B 44 24 7C 89 54 24 08 89 44 24 44 8B 84 24 80 00 00 00 89 44 24 48 8B 84 24 84 00 00 00 89 44 24 4C 8B 84 24 88 00 00 00 89 44 24 30 8B 84 24 8C 00 00 00 89 44 24 34 8B 84 24 90 00 00 00 89 44 24 38 8B 84 24 94 00 00 00 89 44 24 3C 8B 44 24 70 89 44 24 04 E8 ?? ?? ?? ?? 8B 44 24 30 89 44 24 20 8B 44 24 34 89 44 24 24 8B 44 24 38 89 44 24 28 8B 44 24 3C 89 44 24 2C 8B 44 24 40 89 44 24 10 8B 44 24 44 89 44 24 14 8B 44 24 48 89 44 24 18 8B 44 24 4C 89 44 24 1C 8B 44 24 50 89 04 24 8B 44 24 54 89 44 24 04 8B 44 24 58 89 44 24 08 8B 44 24 5C 89 44 24 0C E8 EB EE FF FF 83 C4 6C C3 8D B4 26 00 00 00 00 }
	condition:
		$1
}

rule file_32_17_0 {
	meta:
		name = "___bid64dqd_fma"
		size = 224
		refs = "0051 ___bid64_to_bid128"
	strings:
		$1 = { 57 56 83 EC 64 8B 44 24 78 8D 4C 24 40 8B 54 24 74 8B B4 24 88 00 00 00 8B BC 24 8C 00 00 00 89 44 24 30 8B 44 24 7C 89 54 24 08 89 0C 24 89 44 24 34 8B 84 24 80 00 00 00 89 44 24 38 8B 84 24 84 00 00 00 89 44 24 3C 8B 44 24 70 89 44 24 04 E8 ?? ?? ?? ?? 8D 44 24 50 89 74 24 04 89 7C 24 08 89 04 24 E8 ?? ?? ?? ?? 8B 44 24 50 89 44 24 20 8B 44 24 54 89 44 24 24 8B 44 24 58 89 44 24 28 8B 44 24 5C 89 44 24 2C 8B 44 24 30 89 44 24 10 8B 44 24 34 89 44 24 14 8B 44 24 38 89 44 24 18 8B 44 24 3C 89 44 24 1C 8B 44 24 40 89 04 24 8B 44 24 44 89 44 24 04 8B 44 24 48 89 44 24 08 8B 44 24 4C 89 44 24 0C E8 13 EE FF FF 83 C4 64 5E 5F C3 8D B6 00 00 00 00 8D BC 27 00 00 00 00 }
	condition:
		$1
}

rule file_32_18_0 {
	meta:
		name = "___bid64ddq_fma"
		size = 224
		refs = "0051 ___bid64_to_bid128"
	strings:
		$1 = { 57 56 83 EC 64 8B 84 24 80 00 00 00 8D 4C 24 40 8B 54 24 74 8B 74 24 78 8B 7C 24 7C 89 44 24 30 8B 84 24 84 00 00 00 89 54 24 08 89 0C 24 89 44 24 34 8B 84 24 88 00 00 00 89 44 24 38 8B 84 24 8C 00 00 00 89 44 24 3C 8B 44 24 70 89 44 24 04 E8 ?? ?? ?? ?? 8D 44 24 50 89 74 24 04 89 7C 24 08 89 04 24 E8 ?? ?? ?? ?? 8B 44 24 30 89 44 24 20 8B 44 24 34 89 44 24 24 8B 44 24 38 89 44 24 28 8B 44 24 3C 89 44 24 2C 8B 44 24 50 89 44 24 10 8B 44 24 54 89 44 24 14 8B 44 24 58 89 44 24 18 8B 44 24 5C 89 44 24 1C 8B 44 24 40 89 04 24 8B 44 24 44 89 44 24 04 8B 44 24 48 89 44 24 08 8B 44 24 4C 89 44 24 0C E8 33 ED FF FF 83 C4 64 5E 5F C3 90 90 90 90 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_33_0_0 {
	meta:
		name = "___fixunsxfdi"
		size = 208
		refs = "0027 .rdata"
	strings:
		$1 = { 83 EC 1C DB 6C 24 20 89 5C 24 10 89 74 24 14 D9 EE DF E9 89 7C 24 18 0F 87 94 00 00 00 D9 7C 24 0E D9 C0 31 C9 D8 0D ?? ?? ?? ?? 0F B7 44 24 0E B4 0C 66 89 44 24 0C D9 6C 24 0C DF 3C 24 D9 6C 24 0E 8B 04 24 89 0C 24 89 44 24 04 85 C0 89 C3 DF 2C 24 78 72 DE E9 D9 EE DF E9 77 26 D9 6C 24 0C DF 3C 24 D9 6C 24 0E 31 D2 8B 7C 24 18 8B 34 24 89 F0 8B 74 24 14 01 C8 11 DA 8B 5C 24 10 83 C4 1C C3 D9 E0 89 CE D9 6C 24 0C DF 3C 24 D9 6C 24 0E 31 D2 89 DF 8B 5C 24 10 8B 04 24 29 C6 19 D7 89 F0 8B 74 24 14 89 FA 8B 7C 24 18 83 C4 1C C3 DD D8 31 C0 31 D2 8B 5C 24 10 8B 74 24 14 8B 7C 24 18 83 C4 1C C3 D8 05 ?? ?? ?? ?? EB 86 90 }
	condition:
		$1
}

rule file_34_0_0 {
	meta:
		name = "___addtf3"
		size = 9312
	strings:
		$1 = { 55 57 56 53 81 EC CC 00 00 00 8B 8C 24 FC 00 00 00 8B 9C 24 F4 00 00 00 8B B4 24 F8 00 00 00 8B 84 24 F0 00 00 00 89 CD 0F B7 F9 8B 94 24 0C 01 00 00 89 4C 24 4C C1 ED 10 C1 E9 18 81 E5 FF 7F 00 00 C0 E9 07 89 6C 24 18 0F B6 E9 88 4C 24 1C 89 F1 89 6C 24 24 89 DD C1 E9 1D 89 74 24 48 C1 E7 03 C1 E6 03 09 CF 8B 8C 24 04 01 00 00 C1 ED 1D 09 F5 89 C6 89 5C 24 44 C1 EE 1D C1 E3 03 09 DE 8B 9C 24 08 01 00 00 89 44 24 40 C1 E0 03 89 44 24 10 89 44 24 70 8B 84 24 00 01 00 00 89 4C 24 54 89 D1 C1 E9 10 89 5C 24 58 89 CB 81 E3 FF 7F 00 00 89 44 24 50 0F B7 C2 89 5C 24 20 8D 1C C5 00 00 00 00 8B 84 24 08 01 00 00 89 54 24 5C C1 EA 18 C0 EA 07 88 54 24 2F 0F B6 D2 C1 E8 1D 09 C3 D9 7C 24 3E 89 54 24 28 89 7C 24 7C 89 6C 24 78 89 74 24 74 89 9C 24 8C 00 00 00 8B 94 24 04 01 00 00 8B 84 24 08 01 00 00 8B 8C 24 00 01 00 00 C1 EA 1D C1 E0 03 09 C2 8B 84 24 04 01 00 00 C1 E9 1D 89 94 24 88 00 00 00 C1 E0 03 09 C1 8B 84 24 00 01 00 00 89 8C 24 84 00 00 00 C1 E0 03 89 44 24 0C 89 84 24 80 00 00 00 8B 44 24 28 39 44 24 24 8B 44 24 18 0F 84 42 03 00 00 2B 44 24 20 83 F8 00 89 44 24 14 0F 8E F1 05 00 00 8B 44 24 20 85 C0 0F 85 39 02 00 00 89 D0 09 C8 09 D8 0B 44 24 0C 0F 85 15 04 00 00 81 7C 24 18 FF 7F 00 00 0F 84 87 0D 00 00 C7 44 24 08 00 00 00 00 89 AC 24 98 00 00 00 8B 6C 24 18 8B 5C 24 10 0F B7 4C 24 3E 8B 54 24 18 89 6C 24 14 8B 6C 24 24 89 D8 89 9C 24 90 00 00 00 66 81 E1 00 0C 83 E0 07 89 B4 24 94 00 00 00 83 C2 01 89 BC 24 9C 00 00 00 8B 5C 24 08 83 CB 20 85 C0 0F 44 5C 24 08 89 5C 24 08 66 81 F9 00 04 0F 84 50 05 00 00 66 81 F9 00 08 0F 84 1C 05 00 00 66 85 C9 75 5C 8B 44 24 10 83 E0 0F 83 F8 04 74 50 8B 44 24 10 83 C0 04 89 84 24 90 00 00 00 83 F8 03 8B 84 24 94 00 00 00 0F 96 C3 0F B6 DB 01 D8 39 C3 89 84 24 94 00 00 00 8B 84 24 98 00 00 00 0F 97 C3 0F B6 DB 01 D8 39 C3 89 84 24 98 00 00 00 0F 97 C0 0F B6 C0 01 C7 89 BC 24 9C 00 00 00 F7 C7 00 00 08 00 0F 85 49 04 00 00 0F B7 6C 24 14 89 D7 8B 84 24 94 00 00 00 81 E7 FF 7F 00 00 8B 9C 24 90 00 00 00 66 81 E5 FF 7F 89 C1 8B B4 24 98 00 00 00 C1 EB 03 C1 E1 1D 09 D9 8B 9C 24 9C 00 00 00 C1 E8 03 89 F2 C1 E2 1D 09 C2 89 D8 C1 E0 1D C1 EE 03 09 F0 C1 EB 03 83 FF 01 89 8C 24 90 00 00 00 89 CF 89 94 24 94 00 00 00 89 84 24 98 00 00 00 0F 8E 1C 04 00 00 66 89 5C 24 6C 0F B7 5C 24 6E 66 81 E5 FF 7F 0F B6 4C 24 1C 89 7C 24 60 89 54 24 64 66 81 E3 00 80 09 EB 66 89 5C 24 6E C1 E1 07 66 C1 EB 08 89 CE 83 E3 7F 09 F3 F6 44 24 08 01 88 5C 24 6F 8B 5C 24 6C 89 44 24 68 74 07 D9 EE D8 F0 DD D8 9B F6 44 24 08 08 74 18 D9 B4 24 A0 00 00 00 66 83 8C 24 A4 00 00 00 08 D9 A4 24 A0 00 00 00 9B F6 44 24 08 10 74 18 D9 B4 24 A0 00 00 00 66 83 8C 24 A4 00 00 00 10 D9 A4 24 A0 00 00 00 9B F6 44 24 08 20 74 18 D9 B4 24 A0 00 00 00 66 83 8C 24 A4 00 00 00 20 D9 A4 24 A0 00 00 00 9B 8B AC 24 E0 00 00 00 89 45 08 89 E8 89 7D 00 89 55 04 89 5D 0C 81 C4 CC 00 00 00 5B 5E 5F 5D C3 81 7C 24 18 FF 7F 00 00 0F 84 7F 0B 00 00 81 8C 24 8C 00 00 00 00 00 08 00 C7 44 24 08 00 00 00 00 83 7C 24 14 74 0F 8F B6 06 00 00 8B 5C 24 14 8B 7C 24 14 C1 FB 05 83 E7 1F 85 DB 0F 84 BA 0F 00 00 8B 4C 24 0C 31 ED 8D 84 24 84 00 00 00 8D 94 9C 80 00 00 00 09 CD 39 D0 74 0B 8B 08 83 C0 04 09 CD 39 D0 75 F5 89 D8 85 FF 0F 85 EE 08 00 00 BA 03 00 00 00 29 DA 8D 84 24 80 00 00 00 8D 94 94 84 00 00 00 8B 0C 98 89 08 83 C0 04 39 D0 75 F4 B8 04 00 00 00 29 D8 83 F8 04 74 1D 8D 94 24 80 00 00 00 8D B4 26 00 00 00 00 C7 04 82 00 00 00 00 83 C0 01 83 F8 03 7E F1 8B B4 24 80 00 00 00 31 C0 85 ED 8B 94 24 88 00 00 00 0F 95 C0 8B BC 24 8C 00 00 00 8B AC 24 84 00 00 00 09 C6 89 54 24 0C E9 26 06 00 00 8D 76 00 2B 44 24 20 83 F8 00 89 44 24 14 0F 8E 9F 06 00 00 8B 44 24 20 85 C0 0F 84 73 01 00 00 81 7C 24 18 FF 7F 00 00 0F 84 76 0A 00 00 81 8C 24 8C 00 00 00 00 00 08 00 C7 44 24 08 00 00 00 00 83 7C 24 14 74 0F 8F BD 0A 00 00 8B 5C 24 14 8B 6C 24 14 C1 FB 05 83 E5 1F 85 DB 0F 84 98 15 00 00 8B 4C 24 0C 31 FF 8D 84 24 84 00 00 00 8D 94 9C 80 00 00 00 09 CF 39 D0 74 0B 8B 08 83 C0 04 09 CF 39 D0 75 F5 89 D8 85 ED 0F 85 92 0E 00 00 BA 03 00 00 00 29 DA 8D 84 24 80 00 00 00 8D 94 94 84 00 00 00 8B 0C 98 89 08 83 C0 04 39 D0 75 F4 B8 04 00 00 00 29 D8 83 F8 04 74 16 8D 94 24 80 00 00 00 C7 04 82 00 00 00 00 83 C0 01 83 F8 03 7E F1 8B B4 24 80 00 00 00 31 C0 85 FF 8B 94 24 8C 00 00 00 0F 95 C0 8B BC 24 88 00 00 00 8B AC 24 84 00 00 00 09 C6 89 54 24 0C E9 34 0A 00 00 90 83 6C 24 14 01 0F 85 35 06 00 00 8B 44 24 10 2B 44 24 0C 19 CE 19 D5 19 DF 89 84 24 90 00 00 00 8B 44 24 18 89 AC 24 98 00 00 00 8B 6C 24 24 89 BC 24 9C 00 00 00 89 B4 24 94 00 00 00 89 44 24 14 C7 44 24 08 02 00 00 00 8D B4 26 00 00 00 00 8B BC 24 9C 00 00 00 F7 C7 00 00 08 00 0F 85 54 03 00 00 8B 84 24 90 00 00 00 89 EB 0F B7 4C 24 3E 8B 54 24 14 88 5C 24 1C 89 44 24 10 83 E0 07 66 81 E1 00 0C 83 C2 01 E9 B6 FB FF FF 8D 76 00 89 D0 09 C8 09 D8 0B 44 24 0C 0F 84 4B FB FF FF 83 6C 24 14 01 0F 84 C5 0A 00 00 81 7C 24 18 FF 7F 00 00 C7 44 24 08 02 00 00 00 0F 85 7D FE FF FF 89 E8 09 F0 09 F8 0B 44 24 10 74 0F 89 FA C1 E2 0D C1 FA 1F 83 C2 03 89 54 24 08 8B 5C 24 10 BA 00 80 00 00 0F B7 4C 24 3E 89 AC 24 98 00 00 00 8B 6C 24 24 89 B4 24 94 00 00 00 89 D8 89 9C 24 90 00 00 00 66 81 E1 00 0C 83 E0 07 89 BC 24 9C 00 00 00 C7 44 24 14 FF 7F 00 00 E9 22 FB FF FF 81 E7 FF FF F7 FF 81 FA FF 7F 00 00 89 BC 24 9C 00 00 00 0F 84 B6 02 00 00 8B 84 24 94 00 00 00 8D 7A 01 89 D5 81 E7 FF 7F 00 00 66 81 E5 FF 7F 8B 9C 24 90 00 00 00 89 54 24 14 89 C1 E9 97 FB FF FF 89 D6 09 CE 09 C6 09 DE 0F 84 EF 02 00 00 8B 4C 24 14 85 C9 0F 85 BB 04 00 00 83 4C 24 08 10 E9 C0 FB FF FF 85 ED 0F 85 3D FB FF FF 85 C0 0F 84 35 FB FF FF 8B 44 24 10 83 C0 08 89 84 24 90 00 00 00 83 F8 07 E9 E0 FA FF FF 8D 76 00 85 ED 0F 84 14 FB FF FF EB D5 8D B6 00 00 00 00 0F 85 2D 06 00 00 8B 44 24 18 83 C0 01 25 FF 7F 00 00 83 F8 01 0F 8E 95 0B 00 00 8B 44 24 10 2B 44 24 0C 1B B4 24 84 00 00 00 1B AC 24 88 00 00 00 1B BC 24 8C 00 00 00 89 84 24 90 00 00 00 89 F8 A9 00 00 08 00 89 BC 24 9C 00 00 00 89 AC 24 98 00 00 00 89 B4 24 94 00 00 00 0F 84 FF 06 00 00 8B 6C 24 18 89 D8 C7 44 24 08 00 00 00 00 8B 5C 24 0C 2B 5C 24 70 1B 4C 24 74 1B 54 24 78 1B 44 24 7C 89 84 24 9C 00 00 00 89 6C 24 14 8B 6C 24 28 89 94 24 98 00 00 00 89 8C 24 94 00 00 00 89 9C 24 90 00 00 00 85 C0 0F 84 5E 01 00 00 0F BD C0 83 F0 1F 8D 70 13 83 E8 0C 89 44 24 10 8B 54 24 10 0F 49 F0 C1 F8 1F C1 E8 1B C1 FE 05 01 C2 83 E2 1F 29 C2 89 54 24 0C 0F 84 18 02 00 00 83 FE 02 0F 8F 57 0B 00 00 8B 4C 24 0C B8 03 00 00 00 89 EF C7 44 24 18 20 00 00 00 8D 9C 24 90 00 00 00 29 F0 29 4C 24 18 89 DD 8D 04 83 8B 50 FC 0F B6 4C 24 18 8B 18 D3 EA 0F B6 4C 24 0C D3 E3 09 DA 89 14 B0 83 E8 04 39 E8 75 E1 89 FD 8D 46 FF 8B 94 24 90 00 00 00 0F B6 4C 24 0C D3 E2 89 94 B4 90 00 00 00 85 C0 8D 9C 24 90 00 00 00 78 0C C7 04 83 00 00 00 00 83 E8 01 79 F4 8B 5C 24 10 39 5C 24 14 0F 8F 44 01 00 00 8B 7C 24 10 2B 7C 24 14 8D 47 20 83 C7 01 89 FA 0F 49 C7 C1 FA 1F C1 EA 1B 01 D7 89 7C 24 10 C1 F8 05 83 64 24 10 1F 29 54 24 10 85 C0 0F 8E 97 0A 00 00 8D 94 24 90 00 00 00 31 F6 8D 0C 82 0B 32 83 C2 04 39 CA 75 F7 89 C2 8B 7C 24 10 85 FF 0F 85 DE 02 00 00 BA 03 00 00 00 89 D1 29 C1 0F 88 C2 08 00 00 8D 94 24 90 00 00 00 8D 8C 8C 94 00 00 00 8B 1C 82 89 1A 83 C2 04 39 CA 75 F4 BA 04 00 00 00 29 C2 E9 39 03 00 00 89 F8 25 FF FF 07 00 85 C0 89 84 24 9C 00 00 00 0F 85 A2 FE FF FF 8B 84 24 98 00 00 00 85 C0 0F 84 7A 03 00 00 0F BD C0 83 F0 1F 83 C0 20 E9 8B FE FF FF 8D B6 00 00 00 00 66 85 C9 0F 84 7F 01 00 00 66 81 F9 00 08 0F 84 6C 01 00 00 66 81 F9 00 04 0F 84 A1 07 00 00 C7 84 24 9C 00 00 00 FF FF FF FF BB FF FF FF FF BD FE 7F 00 00 C7 84 24 98 00 00 00 FF FF FF FF BF FF 7F 00 00 C7 84 24 94 00 00 00 FF FF FF FF C7 44 24 14 FE 7F 00 00 83 4C 24 08 28 89 D9 8B 84 24 94 00 00 00 E9 A0 F8 FF FF 8D B6 00 00 00 00 31 DB 31 C0 31 D2 31 FF E9 DA F8 FF FF 8D 76 00 8B 94 24 90 00 00 00 89 EB 8B 44 24 10 29 44 24 14 0F B7 4C 24 3E 89 54 24 10 8B 54 24 14 8B 44 24 10 81 A4 24 9C 00 00 00 FF FF F7 FF 66 81 E1 00 0C 8B BC 24 9C 00 00 00 83 C2 01 88 5C 24 1C 83 E0 07 E9 8B F7 FF FF 83 FE 03 B8 03 00 00 00 8D 9C 24 90 00 00 00 0F 8F 45 FE FF FF 89 F2 F7 DA 8D 84 24 9C 00 00 00 8D 8C B4 8C 00 00 00 C1 E2 02 8B 1C 10 89 18 83 E8 04 39 C8 75 F4 8D 46 FF E9 11 FE FF FF 8B 84 24 88 00 00 00 0B 84 24 84 00 00 00 0B 84 24 8C 00 00 00 0B 44 24 0C C7 44 24 0C 00 00 00 00 83 F8 01 19 F6 31 ED 83 C6 01 31 FF 8B 5C 24 7C 8B 4C 24 78 8B 54 24 74 8B 44 24 10 29 F0 19 EA 1B 4C 24 0C 19 FB 89 9C 24 9C 00 00 00 8B 5C 24 18 89 8C 24 98 00 00 00 8B 6C 24 24 89 94 24 94 00 00 00 89 84 24 90 00 00 00 89 5C 24 14 E9 E6 FA FF FF 8D B6 00 00 00 00 85 ED 0F 85 97 FE FF FF C7 84 24 9C 00 00 00 00 00 00 00 31 DB BD FF 7F 00 00 C7 84 24 98 00 00 00 00 00 00 00 31 FF C7 84 24 94 00 00 00 00 00 00 00 C7 44 24 14 FF 7F 00 00 E9 98 FE FF FF 90 0F 85 EE 08 00 00 8B 44 24 18 83 C0 01 89 44 24 14 25 FF 7F 00 00 83 F8 01 0F 8E F1 05 00 00 8B 44 24 10 8D 94 24 94 00 00 00 03 44 24 0C 13 B4 24 84 00 00 00 13 AC 24 88 00 00 00 13 BC 24 8C 00 00 00 89 BC 24 9C 00 00 00 89 C7 89 B4 24 94 00 00 00 C1 E7 1F 89 AC 24 98 00 00 00 8D B4 24 9C 00 00 00 89 84 24 90 00 00 00 8B 1A D1 E8 89 D9 C1 E1 1F 09 C1 39 F2 89 4A FC 0F 84 E0 06 00 00 89 D8 83 C2 04 EB E3 80 CF 80 E9 07 F7 FF FF 81 7C 24 18 FF 7F 00 00 C7 44 24 08 02 00 00 00 0F 85 DF F7 FF FF E9 66 FA FF FF 90 8D 74 26 00 8B 4C 24 10 C7 44 24 0C 20 00 00 00 8B 94 94 90 00 00 00 29 4C 24 0C 0F B6 4C 24 0C C7 44 24 14 03 00 00 00 29 44 24 14 8B 5C 24 14 D3 E2 09 D6 85 DB 0F 8E A9 05 00 00 8B 5C 24 14 8D 94 24 90 00 00 00 89 F7 8D 1C 9A 89 5C 24 18 8B 5C 82 04 0F B6 4C 24 0C 8B 34 82 D3 E3 0F B6 4C 24 10 D3 EE 09 F3 89 1A 83 C2 04 3B 54 24 18 75 DE BA 04 00 00 00 89 FE 29 C2 8B 84 24 9C 00 00 00 0F B6 4C 24 10 8B 5C 24 14 D3 E8 89 84 9C 90 00 00 00 83 FA 03 8D 9C 24 90 00 00 00 7F 13 8D 74 26 00 C7 04 93 00 00 00 00 83 C2 01 83 FA 03 7E F1 8B 94 24 90 00 00 00 31 C0 85 F6 0F B7 4C 24 3E 0F 95 C0 89 EB 88 5C 24 1C 8B BC 24 9C 00 00 00 C7 44 24 14 00 00 00 00 09 D0 BA 01 00 00 00 89 44 24 10 66 81 E1 00 0C 89 84 24 90 00 00 00 83 E0 07 E9 ED F4 FF FF 8B 84 24 94 00 00 00 85 C0 0F 84 4B 03 00 00 0F BD C0 83 F0 1F 83 C0 40 E9 02 FB FF FF C7 44 24 0C 20 00 00 00 8B 84 84 80 00 00 00 29 7C 24 0C 0F B6 4C 24 0C D3 E0 09 C5 B8 03 00 00 00 29 D8 89 44 24 1C 0F 84 C1 04 00 00 8B 54 24 1C 8D 84 24 80 00 00 00 8D 14 90 89 54 24 14 8B 54 98 04 0F B6 4C 24 0C 8B 34 98 D3 E2 89 F9 D3 EE 09 F2 89 10 83 C0 04 3B 44 24 14 75 E1 B8 04 00 00 00 29 D8 8B 94 24 8C 00 00 00 89 F9 8B 5C 24 1C D3 EA 89 94 9C 80 00 00 00 E9 BA F6 FF FF 8B 44 24 14 F7 D8 89 44 24 14 8B 44 24 18 85 C0 0F 84 BA 02 00 00 81 7C 24 20 FF 7F 00 00 0F 84 02 15 00 00 81 4C 24 7C 00 00 08 00 C7 44 24 08 00 00 00 00 83 7C 24 14 74 0F 8F 9E 08 00 00 8B 74 24 14 8B 6C 24 14 C1 FE 05 83 E5 1F 85 F6 0F 84 0C 14 00 00 8B 4C 24 10 31 FF 8D 44 24 74 8D 54 B4 70 09 CF 39 D0 74 0B 8B 08 83 C0 04 09 CF 39 D0 75 F5 89 F0 85 ED 0F 85 73 0E 00 00 BA 03 00 00 00 29 F2 8D 44 24 70 8D 54 94 74 8B 0C B0 89 08 83 C0 04 39 D0 75 F4 B8 04 00 00 00 29 F0 83 F8 04 74 17 8D 54 24 70 8D 74 26 00 C7 04 82 00 00 00 00 83 C0 01 83 F8 03 7E F1 8B 6C 24 7C 31 C0 85 FF 8B 7C 24 74 0F 95 C0 0B 44 24 70 89 6C 24 10 8B 6C 24 78 8B 9C 24 8C 00 00 00 8B 8C 24 88 00 00 00 8B 94 24 84 00 00 00 8B 74 24 0C 29 C6 19 FA 19 E9 1B 5C 24 10 8B 44 24 20 89 9C 24 9C 00 00 00 8B 6C 24 28 89 8C 24 98 00 00 00 89 94 24 94 00 00 00 89 B4 24 90 00 00 00 89 44 24 14 E9 36 F7 FF FF 8D B6 00 00 00 00 0B BC 24 90 00 00 00 0B BC 24 94 00 00 00 0B BC 24 98 00 00 00 0F 85 06 02 00 00 0F B7 4C 24 3E 66 81 E1 00 0C 66 81 F9 00 04 0F 94 44 24 1C 0F B6 6C 24 1C C7 44 24 08 00 00 00 00 BA 01 00 00 00 31 C0 8B BC 24 9C 00 00 00 C7 44 24 10 00 00 00 00 C7 44 24 14 00 00 00 00 E9 D6 F2 FF FF 90 89 E8 09 F0 09 F8 0B 44 24 10 0F 84 D0 01 00 00 89 FA C1 EA 12 83 F2 01 89 54 24 08 E9 60 F2 FF FF 89 E8 09 F0 09 F8 0B 44 24 10 C7 44 24 08 00 00 00 00 74 0C 89 F8 C1 E8 12 83 F0 01 89 44 24 08 8B 54 24 10 0F B7 4C 24 3E 89 AC 24 98 00 00 00 8B 6C 24 24 89 B4 24 94 00 00 00 89 D0 89 94 24 90 00 00 00 66 81 E1 00 0C 83 E0 07 89 BC 24 9C 00 00 00 BA 00 80 00 00 C7 44 24 14 FF 7F 00 00 E9 3D F2 FF FF 8B 84 24 88 00 00 00 0B 84 24 84 00 00 00 0B 84 24 8C 00 00 00 0B 44 24 0C C7 44 24 0C 00 00 00 00 83 F8 01 19 F6 31 ED 83 C6 01 31 FF 8B 5C 24 7C 8B 4C 24 78 8B 54 24 74 8B 44 24 10 01 F0 11 EA 11 F9 13 5C 24 0C 89 9C 24 9C 00 00 00 8B 5C 24 18 89 8C 24 98 00 00 00 89 }
	condition:
		$1
}

rule file_36_0_0 {
	meta:
		name = "___netf2"
		size = 416
	strings:
		$1 = { 83 EC 5C 8B 44 24 64 8B 4C 24 6C 8B 54 24 68 89 5C 24 4C 8B 5C 24 74 89 44 24 04 8B 44 24 78 66 89 4C 24 02 89 54 24 08 0F B7 D1 89 54 24 0C 89 CA 89 44 24 14 8B 44 24 7C C1 E9 18 C0 E9 07 88 4C 24 1E C1 EA 10 89 74 24 50 81 E2 FF 7F 00 00 0F B7 C8 89 C6 89 4C 24 18 89 C1 C1 E9 10 C1 E8 18 81 E1 FF 7F 00 00 C0 E8 07 81 FA FF 7F 00 00 89 7C 24 54 8B 7C 24 60 89 6C 24 58 8B 6C 24 70 89 5C 24 10 88 44 24 1F 74 39 81 F9 FF 7F 00 00 74 52 39 CA 0F 84 9B 00 00 00 81 FA FF 7F 00 00 74 5E 81 F9 FF 7F 00 00 74 6C B8 01 00 00 00 8B 5C 24 4C 8B 74 24 50 8B 7C 24 54 8B 6C 24 58 83 C4 5C C3 8B 44 24 04 09 F8 0B 44 24 08 0B 44 24 0C 74 B7 66 83 7C 24 02 00 78 C7 D9 EE D8 F0 DD D8 9B EB C6 8B 44 24 10 09 E8 0B 44 24 14 0B 44 24 18 74 9E 81 FA FF 7F 00 00 75 A6 8D 74 26 00 0B 7C 24 04 0B 7C 24 08 0B 7C 24 0C 75 C5 81 F9 FF 7F 00 00 75 94 8B 54 24 10 B8 01 00 00 00 09 EA 0B 54 24 14 0B 54 24 18 74 84 66 85 F6 79 AB E9 7A FF FF FF 39 EF 0F 85 5D FF FF FF 8B 5C 24 10 39 5C 24 04 0F 85 4F FF FF FF 8B 44 24 14 39 44 24 08 0F 85 41 FF FF FF 8B 5C 24 18 39 5C 24 0C 0F 85 33 FF FF FF 0F B6 5C 24 1F 31 C0 38 5C 24 1E 0F 84 37 FF FF FF 85 D2 0F 85 1A FF FF FF 0B 7C 24 04 0B 7C 24 08 0B 7C 24 0C 0F 85 10 FF FF FF 89 D0 E9 16 FF FF FF 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_37_0_0 {
	meta:
		name = "___bid_extendddtd2"
		size = 96
		refs = "0027 ___bid64_to_bid128"
	strings:
		$1 = { 83 EC 2C 89 5C 24 24 8B 4C 24 34 8D 44 24 10 8B 5C 24 38 89 04 24 89 74 24 28 8B 74 24 30 89 4C 24 04 89 5C 24 08 E8 ?? ?? ?? ?? 8B 44 24 10 8B 5C 24 24 89 06 8B 44 24 14 89 46 04 8B 44 24 18 89 46 08 8B 44 24 1C 89 46 0C 89 F0 8B 74 24 28 83 C4 2C C3 90 90 90 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_176_0_0 {
	meta:
		name = "___bid_extendddtf"
		size = 96
		refs = "0027 ___bid64_to_binary128"
	strings:
		$1 = { 83 EC 2C 89 5C 24 24 8B 4C 24 34 8D 44 24 10 8B 5C 24 38 89 04 24 89 74 24 28 8B 74 24 30 89 4C 24 04 89 5C 24 08 E8 ?? ?? ?? ?? 8B 44 24 10 8B 5C 24 24 89 06 8B 44 24 14 89 46 04 8B 44 24 18 89 46 08 8B 44 24 1C 89 46 0C 89 F0 8B 74 24 28 83 C4 2C C3 90 90 90 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_39_0_0 {
	meta:
		name = "___powixf2"
		size = 80
		refs = "0048 .rdata"
	strings:
		$1 = { 8B 54 24 10 DB 6C 24 04 89 D1 C1 F9 1F 89 C8 31 D0 29 C8 A8 01 74 2B D9 C0 EB 07 90 8D 74 26 00 D9 C9 D1 E8 74 12 D9 C9 A8 01 D8 C8 74 F2 D1 E8 DC C9 75 F4 DD D8 EB 02 DD D9 85 D2 78 08 66 90 F3 C3 D9 E8 EB DC D8 3D ?? ?? ?? ?? C3 90 90 90 }
	condition:
		$1
}

rule file_40_0_0 {
	meta:
		name = "___bid64_to_bid128"
		size = 576
		refs = "011e ___bid_power10_table_128 0212 ___bid_IDEC_glbflags"
	strings:
		$1 = { 83 EC 44 89 5C 24 34 8B 5C 24 50 89 6C 24 40 8B 4C 24 4C 89 74 24 38 8B 74 24 48 89 7C 24 3C 89 D8 89 DD 25 00 00 00 60 81 E5 00 00 00 80 3D 00 00 00 60 0F 84 79 01 00 00 89 DF 89 DA C1 EF 15 81 E2 FF FF 1F 00 81 E7 FF 03 00 00 89 4C 24 08 89 54 24 0C 8B 44 24 0C 0B 44 24 08 0F 84 90 00 00 00 8B 44 24 08 81 C7 92 16 00 00 8B 54 24 0C C1 E7 11 09 EF C7 46 08 00 00 00 00 89 06 89 56 04 89 7E 0C 89 F0 8B 5C 24 34 8B 74 24 38 8B 7C 24 3C 8B 6C 24 40 83 C4 44 C3 8D B6 00 00 00 00 89 D8 25 FF FF 03 00 3D 7E 8D 03 00 0F 87 6E 01 00 00 72 0C 81 F9 FF 7F C6 A4 0F 87 60 01 00 00 89 D8 25 FF FF 03 FE 89 4C 24 08 89 44 24 0C 89 D8 25 00 00 00 7C 3D 00 00 00 78 75 13 89 D8 25 00 00 00 F8 C7 44 24 08 00 00 00 00 89 44 24 0C 31 FF 89 DA 0F A4 CA 01 81 FA FF FF FF EF 0F 86 5E FF FF FF 89 D8 25 00 00 00 7E 3D 00 00 00 7E 0F 84 FA 00 00 00 8B 5C 24 0C 31 ED 8B 3D ?? ?? ?? ?? 8B 54 24 08 81 E3 FF FF 03 00 89 D8 89 54 24 24 F7 E7 89 44 24 10 A1 ?? ?? ?? ?? 89 54 24 14 8B 4C 24 10 F7 E3 31 DB 89 44 24 28 8B 44 24 24 89 54 24 2C F7 E7 89 44 24 18 8B 44 24 24 89 D7 89 54 24 1C F7 25 ?? ?? ?? ?? 01 C7 11 D5 01 CF 8B 4C 24 18 11 DD 31 C0 31 DB 89 FA 01 C8 11 DA 8B 5C 24 14 89 06 8B 44 24 0C 89 56 04 89 D9 31 DB 03 4C 24 28 13 5C 24 2C 31 D2 01 E9 11 D3 25 00 00 00 FC 09 D8 89 4E 08 89 46 0C E9 D2 FE FF FF 89 D8 25 00 00 00 78 3D 00 00 00 78 0F 84 DC FE FF FF 89 D8 25 FF FF 07 00 0D 00 00 20 00 3D F2 86 23 00 89 4C 24 08 89 44 24 0C 76 21 C7 44 24 08 00 00 00 00 C7 44 24 0C 00 00 00 00 89 DF C1 EF 13 81 E7 FF 03 00 00 E9 55 FE FF FF 90 72 ED 81 F9 FF FF C0 6F 76 E5 EB D3 8D 74 26 00 83 0D ?? ?? ?? ?? 01 E9 FA FE FF FF 8D 74 26 00 89 DA 81 E2 00 00 00 FE C7 44 24 08 00 00 00 00 89 54 24 0C E9 96 FE FF FF 8D B4 26 00 00 00 00 }
	condition:
		$1
}

rule file_40_1_0 {
	meta:
		name = "___bid128_to_bid64"
		size = 6832
		refs = "00a1 ___bid_power10_table_128 017a ___bid_reciprocals10_128 0412 ___bid_recip_scale 04ce ___bid_IDEC_glbround 0517 ___bid_IDEC_glbflags 0599 .rdata 05ce ___bid_estimate_decimal_digits 05e8 ___bid_power10_index_binexp_128 068a ___bid_round_const_table_128 12a8 ___bid_round_const_table"
	strings:
		$1 = { 55 57 56 53 81 EC DC 00 00 00 8B 84 24 F0 00 00 00 89 84 24 C0 00 00 00 8B 84 24 F4 00 00 00 89 84 24 C4 00 00 00 8B 84 24 F8 00 00 00 8B BC 24 C4 00 00 00 89 84 24 C8 00 00 00 8B 84 24 FC 00 00 00 89 7C 24 1C 8B 9C 24 C8 00 00 00 89 84 24 CC 00 00 00 8B B4 24 CC 00 00 00 89 5C 24 10 89 74 24 14 8B 44 24 14 8B 7C 24 14 8B B4 24 C0 00 00 00 25 00 00 00 78 81 E7 00 00 00 80 3D FF FF FF 5F 89 74 24 18 89 7C 24 50 0F 86 80 00 00 00 3D 00 00 00 78 0F 85 B5 0C 00 00 8B 44 24 14 8B 15 ?? ?? ?? ?? 8B 3D ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? 25 FF 3F 00 00 8B 1D ?? ?? ?? ?? 39 C2 8B 4C 24 10 0F 83 C9 0C 00 00 8B 6C 24 14 31 FF C7 44 24 30 00 00 00 00 81 E5 00 00 00 FE 89 6C 24 34 31 ED 8B 44 24 14 31 C9 25 00 00 00 7C 3D 00 00 00 78 75 6A 8B 5C 24 14 31 FF 31 ED C7 44 24 30 00 00 00 00 81 E3 00 00 00 F8 89 5C 24 34 EB 4E 8B 7C 24 14 A1 ?? ?? ?? ?? 8B 74 24 10 8B 1D ?? ?? ?? ?? 81 E7 FF FF 01 00 8B 0D ?? ?? ?? ?? 39 C7 8B 15 ?? ?? ?? ?? 0F 86 43 03 00 00 8B 4C 24 14 C1 E9 11 81 E1 FF 3F 00 00 31 FF C7 44 24 30 00 00 00 00 31 ED C7 44 24 34 00 00 00 00 8B 44 24 10 8B 54 24 14 0F A4 C2 01 81 FA FF FF FF EF 0F 86 AA 0B 00 00 89 E8 8B 35 ?? ?? ?? ?? F7 25 ?? ?? ?? ?? 89 6C 24 48 8B 6C 24 30 89 44 24 70 A1 ?? ?? ?? ?? 89 54 24 74 F7 E7 89 54 24 7C 8B 5C 24 7C 31 D2 89 44 24 78 8B 44 24 70 89 D9 31 DB 89 4C 24 38 8B 4C 24 34 01 44 24 38 A1 ?? ?? ?? ?? 89 5C 24 3C 11 54 24 3C F7 E7 01 44 24 38 A1 ?? ?? ?? ?? 11 54 24 3C 81 E1 FF 3F 00 00 31 DB 89 4C 24 6C F7 E5 89 84 24 80 00 00 00 89 E8 8B 8C 24 80 00 00 00 89 94 24 84 00 00 00 F7 E6 89 44 24 18 8B 44 24 6C 89 54 24 1C F7 E6 89 44 24 40 89 54 24 44 8B 54 24 1C 01 4C 24 40 11 5C 24 44 89 D0 31 D2 01 44 24 40 8B 4C 24 40 11 54 24 44 31 D2 8B 44 24 18 89 CB 31 C9 89 4C 24 50 01 44 24 50 8B 44 24 48 89 5C 24 54 11 54 24 54 31 DB F7 E6 89 44 24 18 8B 44 24 48 89 54 24 1C 8B 4C 24 18 F7 25 ?? ?? ?? ?? 89 44 24 60 89 F8 89 54 24 64 F7 E6 89 D0 31 D2 89 44 24 20 01 4C 24 20 89 54 24 24 11 5C 24 24 8B 5C 24 1C A1 ?? ?? ?? ?? 8B 74 24 64 89 D9 31 DB 89 5C 24 1C 8B 5C 24 60 89 4C 24 18 01 5C 24 18 11 74 24 1C F7 E7 01 44 24 20 11 54 24 24 8B 5C 24 24 8B 44 24 6C 89 D9 31 DB 01 4C 24 18 11 5C 24 1C 31 FF F7 25 ?? ?? ?? ?? 31 DB 89 44 24 20 8B 44 24 6C 89 54 24 24 8B 74 24 20 F7 25 ?? ?? ?? ?? 89 44 24 60 A1 ?? ?? ?? ?? 89 54 24 64 F7 E5 89 44 24 28 A1 ?? ?? ?? ?? 89 D1 F7 E5 01 C1 11 D3 01 F1 11 FB 8B 7C 24 24 89 FE 31 FF 89 74 24 20 8B 44 24 28 89 7C 24 24 8B 7C 24 60 01 7C 24 20 8B 6C 24 64 11 6C 24 24 31 D2 01 5C 24 20 89 CB 11 54 24 24 31 C9 31 D2 8B 7C 24 74 01 C1 8B 44 24 6C 11 D3 F7 25 ?? ?? ?? ?? 8B 6C 24 78 89 FE 31 FF C7 44 24 2C 00 00 00 00 01 C6 8B 44 24 48 11 D7 F7 25 ?? ?? ?? ?? 89 6C 24 28 01 C6 11 D7 8B 94 24 84 00 00 00 89 D0 31 D2 01 C6 11 D7 8B 54 24 3C 89 D0 31 D2 01 C6 11 D7 8B 54 24 44 89 D0 31 D2 01 C6 8B 44 24 38 11 D7 89 C2 31 C0 03 44 24 28 13 54 24 2C 03 44 24 50 13 54 24 54 39 54 24 54 72 10 0F 87 D8 0B 00 00 39 44 24 50 0F 87 CE 0B 00 00 03 44 24 18 13 54 24 1C 39 54 24 1C 72 10 0F 87 9A 0B 00 00 39 44 24 18 0F 87 90 0B 00 00 89 C8 89 DA 01 F0 11 FA 39 D7 72 14 0F 87 6E 0B 00 00 39 C6 0F 87 66 0B 00 00 8D B6 00 00 00 00 8B 35 ?? ?? ?? ?? 31 DB 8B 7C 24 24 89 F1 0F AD D0 D3 EA F6 C1 20 0F 45 C2 B9 40 00 00 00 0F 45 D3 8B 5C 24 34 29 F1 8B 74 24 20 89 C5 31 C0 81 E3 00 00 00 FC 0F A5 F7 09 D3 D3 E6 F6 C1 20 8B 4C 24 14 0F 45 FE 89 DA 0F 45 F0 89 E8 09 F0 09 FA 81 E1 00 00 00 7E 81 F9 00 00 00 7E 0F 84 6D 09 00 00 81 C4 DC 00 00 00 5B 5E 5F 5D C3 66 90 0F 83 4A 09 00 00 31 F8 31 F2 09 D0 0F 84 5E 09 00 00 8B 44 24 14 8B 54 24 18 8B 5C 24 1C C1 E8 11 09 F2 25 FF 3F 00 00 09 FB 89 C1 09 D3 0F 84 DC 15 00 00 89 FB 09 F3 0F 85 AA 00 00 00 81 7C 24 1C F2 86 23 00 0F 83 8C 00 00 00 8B 1D ?? ?? ?? ?? 2D 92 16 00 00 8B 74 24 18 8B 7C 24 1C 89 44 24 0C 81 7C 24 0C FF 02 00 00 0F 86 DC 07 00 00 8B 6C 24 0C 85 ED 0F 88 73 0D 00 00 81 FF 7E 8D 03 00 0F 82 73 0C 00 00 0F 86 61 0C 00 00 8B 54 24 50 31 C0 83 0D ?? ?? ?? ?? 28 81 CA 00 00 00 78 83 FB 02 0F 84 FB 12 00 00 83 FB 03 0F 84 8C 11 00 00 83 FB 01 0F 85 36 FF FF FF 8B 74 24 50 85 F6 0F 85 2A FF FF FF B8 FF FF C0 6F BA F2 86 FB 77 E9 1B FF FF FF 77 0E 81 7C 24 18 FF FF C0 6F 0F 86 64 FF FF FF 89 B4 24 B0 00 00 00 85 FF 89 BC 24 B4 00 00 00 DF AC 24 B0 00 00 00 0F 88 DB 0C 00 00 D9 9C 24 BC 00 00 00 8B 54 24 1C D9 84 24 BC 00 00 00 D9 05 ?? ?? ?? ?? DC C9 85 D2 DF 6C 24 18 0F 88 AC 0C 00 00 DD D9 D9 5C 24 10 89 FB D8 44 24 10 D9 5C 24 10 8B 54 24 10 C1 EA 17 81 E2 FF 00 00 00 83 EA 7F 8B 2C 95 ?? ?? ?? ?? 89 D1 C1 E1 04 89 6C 24 20 83 ED 10 89 6C 24 30 89 CD 89 F1 2B 8D ?? ?? ?? ?? 1B 9D ?? ?? ?? ?? 89 4C 24 10 83 FB 00 89 5C 24 14 0F 8E 0D 0C 00 00 8B 5C 24 20 83 EB 0F 89 5C 24 30 8B 6C 24 30 8B 1D ?? ?? ?? ?? 01 C5 89 6C 24 78 8B 6C 24 50 89 9C 24 80 00 00 00 89 5C 24 40 85 ED 74 16 89 DA 83 EA 01 83 FA 01 77 0C C7 44 24 40 03 00 00 00 29 5C 24 40 81 7C 24 78 91 16 00 00 0F 8E 0B 07 00 00 8B 5C 24 78 C7 84 24 B8 00 00 00 00 00 00 00 81 EB 92 16 00 00 89 5C 24 0C 8B 6C 24 40 8B 5C 24 30 8B 4C 24 18 8D 44 ED 00 8D 2C 83 8B 5C 24 1C C1 E5 04 8B 85 ?? ?? ?? ?? 8B 95 ?? ?? ?? ?? 01 C1 11 D3 89 5C 24 1C 03 B5 ?? ?? ?? ?? 13 BD ?? ?? ?? ?? 31 DB 39 54 24 1C 89 4C 24 18 B9 01 00 00 00 72 17 0F 87 A1 08 00 00 39 44 24 18 0F 83 97 08 00 00 8D B4 26 00 00 00 00 89 F0 89 FA 8B 74 24 1C 01 C8 8B 7C 24 18 11 DA 89 54 24 14 8B 54 24 30 89 44 24 10 C1 E2 04 8D 82 ?? ?? ?? ?? 8B 92 ?? ?? ?? ?? 8B 58 08 8B 48 04 8B 40 0C 89 94 24 A8 00 00 00 89 5C 24 20 89 4C 24 6C 89 44 24 68 89 D8 F7 E6 89 84 24 88 00 00 00 8B 44 24 68 89 94 24 8C 00 00 00 F7 E6 89 84 24 A0 00 00 00 89 D8 89 94 24 A4 00 00 00 F7 E7 89 94 24 94 00 00 00 8B 9C 24 94 00 00 00 31 D2 89 84 24 90 00 00 00 8B 84 24 88 00 00 00 89 D9 31 DB 89 4C 24 28 01 44 24 28 8B 44 24 68 89 5C 24 2C 11 54 24 2C F7 E7 01 44 24 28 11 54 24 2C 8B 54 24 10 8B 44 24 6C 8B 6C 24 14 89 14 24 F7 E2 89 84 24 98 00 00 00 8B 04 24 89 94 24 9C 00 00 00 F7 A4 24 A8 00 00 00 89 54 24 14 8B 5C 24 14 31 D2 89 44 24 10 8B 84 24 98 00 00 00 89 D9 31 DB 89 4C 24 38 01 44 24 38 8B 84 24 A8 00 00 00 89 5C 24 3C 11 54 24 3C F7 E5 01 44 24 38 8B 4C 24 38 11 54 24 3C 31 D2 8B 44 24 10 89 CB 31 C9 89 4C 24 48 01 44 24 48 89 5C 24 4C 11 54 24 4C 8B 84 24 A8 00 00 00 F7 E6 89 44 24 18 8B 44 24 6C 89 54 24 1C 8B 4C 24 1C F7 E6 89 44 24 60 8B 84 24 A8 00 00 00 89 54 24 64 F7 E7 89 54 24 14 8B 74 24 14 31 D2 89 44 24 10 8B 44 24 18 89 F3 31 F6 01 C3 8B 44 24 6C 11 D6 F7 E7 01 C3 8B 44 24 60 11 D6 89 CA 89 54 24 18 31 C9 8B 54 24 64 01 44 24 18 8B 44 24 10 89 4C 24 1C 11 54 24 1C 31 D2 01 74 24 18 11 54 24 1C 31 D2 89 54 24 60 31 D2 01 44 24 60 89 5C 24 64 11 54 24 64 8B 44 24 20 F7 E5 89 44 24 10 8B 44 24 68 89 54 24 14 8B 4C 24 14 F7 E5 89 84 24 A8 00 00 00 8B 44 24 20 89 94 24 AC 00 00 00 8B 9C 24 AC 00 00 00 F7 24 24 89 54 24 24 8B 7C 24 24 31 D2 89 44 24 20 8B 44 24 10 89 FE 31 FF 01 C6 8B 44 24 68 11 D7 F7 24 24 01 C6 8B 44 24 20 11 D7 89 CA 31 C9 89 4C 24 14 8B 8C 24 A8 00 00 00 89 54 24 10 01 4C 24 10 11 5C 24 14 31 D2 01 7C 24 10 11 54 24 14 31 C9 31 D2 89 8C 24 A8 00 00 00 89 B4 24 AC 00 00 00 01 84 24 A8 00 00 00 8B BC 24 8C 00 00 00 8B 44 24 6C 11 94 24 AC 00 00 00 8B 8C 24 90 00 00 00 89 FE 31 FF 03 B4 24 A0 00 00 00 13 BC 24 A4 00 00 00 F7 E5 01 C6 11 D7 8B 54 24 2C 89 D0 31 D2 01 C6 11 D7 8B 94 24 9C 00 00 00 89 D0 31 D2 01 C6 11 D7 8B 54 24 3C 89 D0 31 D2 01 C6 8B 44 24 28 11 D7 31 DB 89 C2 31 C0 01 C8 11 DA 03 44 24 48 13 54 24 4C 39 54 24 4C 0F 82 10 00 00 00 0F 87 A7 05 00 00 39 44 24 48 0F 87 9D 05 00 00 8B 4C 24 18 8B 5C 24 1C 01 C1 11 D3 39 5C 24 1C 89 4C 24 20 89 5C 24 24 72 13 0F 87 42 04 00 00 39 4C 24 18 0F 87 38 04 00 00 8D 76 00 8B 84 24 A8 00 00 00 8B 94 24 AC 00 00 00 01 F0 11 FA 39 D7 89 44 24 58 89 54 24 5C 72 0E 0F 87 1C 04 00 00 39 C6 0F 87 14 04 00 00 8B 5C 24 30 8B 2C 9D ?? ?? ?? ?? 83 FD 3F 0F 8E 1E 04 00 00 8B 7C 24 14 8D 4D C0 31 C0 8B 74 24 10 0F AD FE D3 EF 83 E1 20 0F 45 F7 0F 45 F8 8B 44 24 40 85 C0 0F 84 50 04 00 00 BB 80 00 00 00 29 EB 83 FB 3F 0F 8E 69 05 00 00 8B 44 24 58 B9 40 00 00 00 8B 54 24 5C 29 E9 0F A5 C2 D3 E0 F6 C1 20 74 04 89 C2 31 C0 89 44 24 70 89 54 24 74 83 7C 24 40 01 C7 44 24 10 00 00 00 00 C7 44 24 14 00 00 00 00 0F 84 9B 05 00 00 0F 82 43 06 00 00 83 7C 24 40 03 0F 84 8A 05 00 00 83 7C 24 40 04 0F 84 2D 06 00 00 8B 44 24 30 C7 44 24 28 01 00 00 00 C7 44 24 2C 00 00 00 00 C1 E0 04 8B 90 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 03 44 24 60 13 54 24 64 39 54 24 64 77 16 0F 83 8C 0B 00 00 C7 44 24 28 00 00 00 00 C7 44 24 2C 00 00 00 00 8B 44 24 20 03 44 24 28 8B 54 24 24 13 54 24 2C 89 44 24 20 8B 44 24 30 89 54 24 24 C1 E0 04 8B 90 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 03 44 24 20 13 54 24 24 39 54 24 24 0F 87 33 0A 00 00 0F 83 23 0A 00 00 8B 4C 24 24 31 D2 B8 01 00 00 00 39 4C 24 2C 0F 86 55 0B 00 00 89 44 24 20 89 54 24 24 83 FB 3F 0F 8F BE 09 00 00 8B 44 24 70 8D 4D C0 8B 54 24 74 0F A5 C2 D3 E0 F6 C1 20 74 04 89 C2 31 C0 89 44 24 30 8B 44 24 10 89 D9 89 54 24 34 8B 54 24 14 0F AD D0 D3 EA F6 C1 20 74 04 89 D0 31 D2 8B 4C 24 30 09 C1 8B 44 24 70 89 4C 24 10 8B 4C 24 34 09 D1 8B 54 24 74 89 4C 24 14 89 D9 31 DB 0F AD D0 D3 EA F6 C1 20 0F 45 C2 0F 45 D3 89 44 24 70 89 54 24 74 83 FD 3F 0F 8F 15 09 00 00 B9 40 00 00 00 31 D2 29 E9 B8 01 00 00 00 0F AD D0 31 DB D3 EA F6 C1 20 0F 45 C2 89 E9 0F 45 D3 89 44 24 28 31 C0 89 54 24 2C 31 D2 F6 C1 20 0F 94 C0 0F 95 C2 D3 E2 D3 E0 89 44 24 18 89 54 24 1C 8B 4C 24 10 8B 5C 24 14 03 4C 24 20 13 5C 24 24 3B 5C 24 24 77 10 0F 83 60 0A 00 00 83 44 24 70 01 83 54 24 74 00 8B 54 24 74 39 54 24 2C 72 3A 0F 86 33 0A 00 00 8B 54 24 2C 8B 44 24 28 33 54 24 74 33 44 24 70 09 C2 0F 84 6A 0A 00 00 8D B6 00 00 00 00 83 BC 24 B8 00 00 00 01 19 C0 83 E0 F0 83 C0 30 09 05 ?? ?? ?? ?? 81 FF F2 86 23 00 8B 9C 24 80 00 00 00 0F 82 4A F8 FF FF 77 0C 81 FE FF FF C0 6F 0F 86 3C F8 FF FF 8B 74 24 78 BF 7E 8D 03 00 81 EE 91 16 00 00 89 74 24 0C BE 00 80 C6 A4 81 7C 24 0C FF 02 00 00 0F 87 24 F8 FF FF 81 FF FF FF 1F 00 0F 86 E7 03 00 00 89 FA 89 F0 81 F2 F2 86 23 00 35 00 00 C1 6F 09 C2 0F 84 25 0A 00 00 8B 4C 24 50 89 F8 8B 5C 24 0C 25 FF FF 07 00 81 C4 DC 00 00 00 81 C9 00 00 00 60 09 C1 89 F0 C1 E3 13 89 CA 09 DA 5B 5E 5F 5D C3 90 8D 74 26 00 81 E9 92 16 00 00 0F 88 54 08 00 00 8B 54 24 50 81 F9 FF 02 00 00 BB FF 02 00 00 0F 4E D9 81 C4 DC 00 00 00 C1 E3 15 31 C0 09 DA 5B 5E 5F 5D C3 8B 4C 24 14 C1 E9 0F E9 E8 F3 FF FF 8D 74 26 00 3D 6E 16 00 00 0F 8F 65 04 00 00 8B 5C 24 78 C7 84 24 B8 00 00 00 01 00 00 00 C7 44 24 40 03 00 00 00 81 EB 92 16 00 00 89 5C 24 0C E9 DD F8 FF FF 77 08 39 CB 0F 82 2D F3 FF FF 31 D0 31 D9 09 C8 0F 84 4E 09 00 00 8B 54 24 14 8B 44 24 10 8B 7C 24 18 8B 6C 24 1C 81 E2 FF 3F 00 FE 89 44 24 30 89 54 24 34 E9 18 F3 FF FF 8D B6 00 00 00 00 39 D6 0F 87 65 F3 FF FF E9 A9 F6 FF FF 8D 76 00 83 0D ?? ?? ?? ?? 01 E9 87 F6 FF FF 8D 74 26 00 3B 4C 24 1C 0F 82 43 F3 FF FF 0F 87 92 F6 FF FF 3B 5C 24 18 0F 86 33 F3 FF FF 8D B6 00 00 00 00 E9 7D F6 FF FF 83 C6 01 83 D7 00 E9 C0 FB FF FF 8B 5C 24 30 83 44 24 10 01 83 54 24 14 00 8B 2C 9D ?? ?? ?? ?? 83 FD 3F 0F 8F E2 FB FF FF 8B 44 24 10 B9 40 00 00 00 31 DB 8B 54 24 14 29 E9 8B 74 24 5C 0F A5 C2 D3 E0 F6 C1 20 0F 45 D0 0F 45 C3 8B 5C 24 58 89 E9 31 FF 0F AD F3 D3 EE F6 C1 20 0F 45 DE 0F 45 F7 89 74 24 2C 8B 7C 24 2C 89 5C 24 28 8B 74 24 28 09 D7 09 C6 8B 44 24 40 85 C0 0F 85 B0 FB FF FF 89 F1 BB 80 00 00 00 83 E1 01 29 EB 85 C9 0F 84 A3 FB FF FF 83 FB 3F 0F 8E DC 06 00 00 8B 44 24 58 B9 40 00 00 00 8B 54 24 5C 29 E9 0F A5 C2 D3 E0 F6 C1 20 74 04 89 C2 31 C0 89 54 24 74 09 C2 89 44 24 70 0F 85 9B FB FF FF 8B 4C 24 30 C1 E1 04 8B 91 ?? ?? ?? ?? 8B 89 ?? ?? ?? ?? 39 4C 24 24 72 45 77 06 39 54 24 20 72 3D 8B 44 24 24 31 C8 8B 4C 24 20 31 D1 09 C1 0F 85 38 FB FF FF 8B 4C 24 30 8B 44 24 64 C1 E1 04 3B 81 ?? ?? ?? ?? 0F 87 21 FB FF FF 72 10 8B 54 24 60 3B 91 ?? ?? ?? ?? 0F 83 0F FB FF FF 83 C6 FF 83 D7 FF E9 04 FB FF FF 8D B6 00 00 00 00 83 C6 01 83 D7 00 E9 58 FA FF FF 90 8D 74 26 00 31 C9 31 DB E9 67 F7 FF FF 8D B4 26 00 00 00 00 83 44 24 20 01 83 54 24 24 00 E9 91 F4 FF FF 90 83 C6 01 89 C8 83 D7 00 89 DA 01 F0 11 FA 39 D7 0F 82 7A F4 FF FF E9 61 F4 FF FF 90 8D 74 26 00 83 C6 01 83 D7 00 03 44 24 18 13 54 24 1C 39 54 24 1C 0F 82 38 F4 FF FF E9 23 F4 FF FF 8D 76 00 8B 54 24 5C 8D 4D C0 8B 44 24 58 0F AD D0 D3 EA F6 C1 20 74 04 89 D0 31 D2 89 44 24 28 89 54 24 2C 8B 44 24 10 89 D9 8B 54 24 14 0F A5 C2 D3 E0 F6 C1 20 74 04 89 C2 31 C0 0B 44 24 28 0B 54 24 }
	condition:
		$1
}

rule file_41_0_0 {
	meta:
		name = "___bid_floatsitd"
		size = 64
		refs = "0018 ___bid128_from_int32"
	strings:
		$1 = { 53 83 EC 28 8B 54 24 34 8D 44 24 10 89 04 24 8B 5C 24 30 89 54 24 04 E8 ?? ?? ?? ?? 8B 44 24 10 89 03 8B 44 24 14 89 43 04 8B 44 24 18 89 43 08 8B 44 24 1C 89 43 0C 83 C4 28 89 D8 5B C3 90 90 }
	condition:
		$1
}

rule file_114_0_0 {
	meta:
		name = "___bid_extendsdtd2"
		size = 64
		refs = "0018 ___bid32_to_bid128"
	strings:
		$1 = { 53 83 EC 28 8B 54 24 34 8D 44 24 10 89 04 24 8B 5C 24 30 89 54 24 04 E8 ?? ?? ?? ?? 8B 44 24 10 89 03 8B 44 24 14 89 43 04 8B 44 24 18 89 43 08 8B 44 24 1C 89 43 0C 83 C4 28 89 D8 5B C3 90 90 }
	condition:
		$1
}

rule file_93_0_0 {
	meta:
		name = "___bid_extendsdtf"
		size = 64
		refs = "0018 ___bid32_to_binary128"
	strings:
		$1 = { 53 83 EC 28 8B 54 24 34 8D 44 24 10 89 04 24 8B 5C 24 30 89 54 24 04 E8 ?? ?? ?? ?? 8B 44 24 10 89 03 8B 44 24 14 89 43 04 8B 44 24 18 89 43 08 8B 44 24 1C 89 43 0C 83 C4 28 89 D8 5B C3 90 90 }
	condition:
		$1
}

rule file_143_0_0 {
	meta:
		name = "___bid_floatunssitd"
		size = 64
		refs = "0018 ___bid128_from_uint32"
	strings:
		$1 = { 53 83 EC 28 8B 54 24 34 8D 44 24 10 89 04 24 8B 5C 24 30 89 54 24 04 E8 ?? ?? ?? ?? 8B 44 24 10 89 03 8B 44 24 14 89 43 04 8B 44 24 18 89 43 08 8B 44 24 1C 89 43 0C 83 C4 28 89 D8 5B C3 90 90 }
	condition:
		$1
}

rule file_42_0_0 {
	meta:
		name = "___popcountsi2"
		size = 48
		refs = "0019 ___popcount_tab"
	strings:
		$1 = { 53 8B 5C 24 08 31 C0 31 C9 89 DA D3 EA 83 C1 08 81 E2 FF 00 00 00 0F B6 92 ?? ?? ?? ?? 01 D0 83 F9 20 75 E5 5B C3 90 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_43_0_0 {
	meta:
		name = "___popcountdi2"
		size = 64
		refs = "002c ___popcount_tab"
	strings:
		$1 = { 57 31 C9 56 53 8B 44 24 10 31 DB 8B 54 24 14 90 89 D7 89 C6 0F AD FE D3 EF F6 C1 20 74 02 89 FE 81 E6 FF 00 00 00 83 C1 08 0F B6 B6 ?? ?? ?? ?? 01 F3 83 F9 40 75 D9 89 D8 5B 5E 5F C3 90 90 90 }
	condition:
		$1
}

rule file_44_0_0 {
	meta:
		name = "___floatundixf"
		size = 48
		refs = "001f .rdata"
	strings:
		$1 = { 83 EC 0C 31 D2 8B 44 24 14 89 54 24 04 31 D2 89 04 24 8B 44 24 10 DF 2C 24 89 54 24 04 D8 0D ?? ?? ?? ?? 89 04 24 DF 2C 24 83 C4 0C DE C1 C3 90 }
	condition:
		$1
}

rule file_45_0_0 {
	meta:
		name = "___bid128_quiet_equal"
		size = 2080
		refs = "01f5 ___bid_ten2k128 0552 ___bid_IDEC_glbflags 06a9 ___bid_ten2k64"
	strings:
		$1 = { 81 EC AC 00 00 00 8B 94 24 B8 00 00 00 8B 84 24 B0 00 00 00 8B 8C 24 C0 00 00 00 89 9C 24 9C 00 00 00 8B 9C 24 C8 00 00 00 89 54 24 08 8B 94 24 BC 00 00 00 89 04 24 89 B4 24 A0 00 00 00 8B B4 24 C4 00 00 00 89 AC 24 A8 00 00 00 8B AC 24 B4 00 00 00 89 D0 25 00 00 00 7C 3D 00 00 00 7C 89 4C 24 18 8B 8C 24 CC 00 00 00 89 BC 24 A4 00 00 00 89 5C 24 38 0F 84 8D 04 00 00 89 C8 25 00 00 00 7C 3D 00 00 00 7C 0F 84 7B 04 00 00 8B 44 24 18 89 F7 33 04 24 31 EF 09 C7 0F 84 C0 04 00 00 89 D0 25 00 00 00 78 3D 00 00 00 78 0F 84 63 05 00 00 89 C8 25 00 00 00 78 3D 00 00 00 78 0F 84 40 04 00 00 89 D7 81 E7 FF FF 01 00 81 FF 09 ED 01 00 89 7C 24 10 0F 86 A4 04 00 00 BF 01 00 00 00 8B 5C 24 38 89 5C 24 58 89 CB 81 E3 FF FF 01 00 81 FB 09 ED 01 00 89 5C 24 1C 77 14 0F 82 BE 04 00 00 81 7C 24 38 C0 87 AD BE 0F 86 B0 04 00 00 BB 01 00 00 00 89 F8 84 C0 0F 85 D5 04 00 00 8B 7C 24 10 0B 7C 24 08 0F 85 12 05 00 00 8B 04 24 09 E8 0F 94 C0 89 C7 88 44 24 20 84 DB 75 1A 8B 5C 24 1C 0B 5C 24 38 0F 85 B6 04 00 00 8B 44 24 18 09 F0 0F 85 AA 04 00 00 89 FB B8 01 00 00 00 84 DB 0F 85 BD 03 00 00 30 C0 80 7C 24 20 00 0F 84 B0 03 00 00 89 D7 31 CF 0F 88 84 03 00 00 C1 EA 11 C1 E9 11 81 E2 FF 3F 00 00 81 E1 FF 3F 00 00 89 D0 39 CA 0F 8F B4 04 00 00 8B 54 24 18 8B 5C 24 38 89 74 24 30 8B 3C 24 8B 74 24 1C 89 54 24 28 8B 54 24 10 89 6C 24 5C 8B 6C 24 08 89 5C 24 20 89 74 24 38 89 7C 24 18 89 6C 24 58 89 54 24 1C 29 C1 31 C0 83 F9 21 0F 8F 46 03 00 00 83 F9 13 0F 8E BD 04 00 00 83 E9 14 8B 44 24 30 C1 E1 04 8B 99 ?? ?? ?? ?? 8B B1 ?? ?? ?? ?? F7 E3 89 74 24 08 89 5C 24 40 89 04 24 8B 44 24 30 89 54 24 04 F7 E6 89 44 24 10 8B 44 24 28 89 54 24 14 F7 E3 8B 99 ?? ?? ?? ?? 89 54 24 64 8B 7C 24 64 31 D2 89 44 24 60 8B 04 24 89 FE 31 FF 01 C6 8B 44 24 28 11 D7 F7 64 24 08 01 C6 11 D7 8B 54 24 04 89 D0 31 D2 89 04 24 8B 44 24 10 01 04 24 89 54 24 04 8B 54 24 14 11 54 24 04 31 D2 01 3C 24 11 54 24 04 89 5C 24 48 8B 44 24 30 8B A9 ?? ?? ?? ?? F7 E3 89 44 24 10 8B 44 24 30 89 54 24 14 F7 E5 89 44 24 30 8B 44 24 28 89 54 24 34 F7 E3 89 54 24 6C 8B 5C 24 6C 31 D2 89 44 24 68 8B 44 24 10 89 D9 31 DB 89 4C 24 50 01 44 24 50 8B 44 24 28 89 5C 24 54 8B 5C 24 14 11 54 24 54 F7 E5 01 44 24 50 89 D9 11 54 24 54 31 DB 8B 54 24 54 03 4C 24 30 13 5C 24 34 89 74 24 14 89 D0 31 D2 01 C1 11 D3 31 C0 89 44 24 10 8B 44 24 60 31 D2 01 44 24 10 11 54 24 14 01 4C 24 10 11 5C 24 14 3B 5C 24 14 72 11 77 06 3B 4C 24 10 76 09 83 04 24 01 83 54 24 04 00 8B 44 24 38 F7 64 24 40 89 44 24 28 8B 44 24 38 89 54 24 2C 8B 5C 24 2C F7 64 24 08 89 D9 89 44 24 30 8B 44 24 20 89 54 24 34 F7 64 24 40 89 54 24 44 8B 7C 24 44 31 D2 89 44 24 40 8B 44 24 28 89 4C 24 28 8B 4C 24 30 89 FE 31 FF 01 C6 8B 44 24 20 11 D7 F7 64 24 08 01 C6 8B 44 24 38 11 D7 31 DB 89 5C 24 2C 8B 5C 24 34 01 4C 24 28 11 5C 24 2C 31 D2 01 7C 24 28 11 54 24 2C F7 64 24 48 89 44 24 08 8B 44 24 38 89 54 24 0C F7 E5 89 44 24 38 8B 44 24 20 89 54 24 3C F7 64 24 48 89 54 24 4C 8B 5C 24 4C 31 D2 89 44 24 48 8B 44 24 08 89 D9 31 DB 01 C1 8B 44 24 20 11 D3 F7 E5 01 C1 11 D3 8B 54 24 0C 89 D0 31 D2 89 44 24 08 8B 44 24 38 01 44 24 08 8B 44 24 48 89 54 24 0C 8B 54 24 3C 11 54 24 0C 31 D2 01 5C 24 08 89 CB 11 54 24 0C 31 C9 31 D2 01 C1 11 D3 89 F2 8B 74 24 40 31 C0 31 FF 01 F0 11 FA 03 44 24 08 13 54 24 0C 39 54 24 0C 72 12 77 06 39 44 24 08 76 0A 83 44 24 28 01 83 54 24 2C 00 8B 74 24 10 8B 7C 24 14 01 CE 11 DF 89 7C 24 14 31 FF 3B 5C 24 14 89 74 24 10 BE 01 00 00 00 77 0C 72 06 3B 4C 24 10 77 04 31 F6 31 FF 8B 0C 24 01 F0 8B 5C 24 04 11 FA 01 C1 11 D3 39 DA 89 0C 24 89 5C 24 04 0F 87 70 03 00 00 72 08 39 C8 0F 87 66 03 00 00 31 DB 39 D7 B9 01 00 00 00 77 0A 72 04 39 C6 77 04 31 C9 31 DB 03 4C 24 28 13 5C 24 2C 89 DE 09 CE 75 3B 8B 7C 24 04 0B 3C 24 75 32 8B 44 24 14 8B 54 24 10 33 44 24 1C 33 54 24 58 09 D0 75 1E 8B 44 24 50 31 DB 8B 4C 24 68 89 C2 31 C0 01 C8 11 DA 33 44 24 18 33 54 24 5C 09 C2 74 70 31 C0 EB 1E 81 E2 00 00 00 7E 81 FA 00 00 00 7E 74 3A 81 E1 00 00 00 7E 31 C0 81 F9 00 00 00 7E 74 2A 8B 9C 24 9C 00 00 00 8B B4 24 A0 00 00 00 8B BC 24 A4 00 00 00 8B AC 24 A8 00 00 00 81 C4 AC 00 00 00 C3 8D B4 26 00 00 00 00 83 0D ?? ?? ?? ?? 01 31 C0 EB CB 90 8D 74 26 00 8B 44 24 08 89 CF 33 44 24 38 31 D7 09 C7 0F 85 2C FB FF FF B8 01 00 00 00 EB AB 90 8D 74 26 00 72 0E 81 7C 24 08 C0 87 AD BE 0F 87 4C FB FF FF 8B 7C 24 10 8B 44 24 08 81 F7 09 ED 01 00 35 C0 87 AD BE 09 C7 0F 84 E5 00 00 00 89 D0 25 00 00 00 60 3D 00 00 00 60 0F 94 C0 89 C7 E9 20 FB FF FF 8B 5C 24 1C 8B 44 24 38 81 F3 09 ED 01 00 35 C0 87 AD BE 09 D8 0F 84 9C 00 00 00 89 C8 25 00 00 00 60 3D 00 00 00 60 89 F8 0F 94 C3 84 C0 0F 84 2B FB FF FF BF 01 00 00 00 C6 44 24 20 01 E9 38 FB FF FF 89 FB 31 C0 84 DB 0F 85 16 FF FF FF E9 61 FB FF FF 89 CB 31 C0 81 E3 00 00 00 78 81 FB 00 00 00 78 0F 85 FB FE FF FF 89 D0 31 C8 F7 D0 C1 E8 1F E9 ED FE FF FF 8D B4 26 00 00 00 00 31 FF C6 44 24 20 00 E9 F0 FA FF FF 8D 74 26 00 8B 1C 24 89 C8 89 D1 89 6C 24 30 8B 7C 24 08 8B 6C 24 10 89 74 24 5C 89 5C 24 28 89 7C 24 20 89 6C 24 38 E9 5B FB FF FF 81 FE 63 8E 8D 37 BB 01 00 00 00 0F 87 8D FA FF FF E9 4E FF FF FF 66 90 81 FD 63 8E 8D 37 BF 01 00 00 00 0F 87 40 FA FF FF E9 05 FF FF FF 8B 34 CD ?? ?? ?? ?? 8B 44 24 20 8B 0C CD ?? ?? ?? ?? F7 E1 89 04 24 8B 44 24 38 89 54 24 04 F7 E1 89 44 24 10 8B 44 24 20 89 54 24 14 F7 E6 89 54 24 24 8B 6C 24 24 31 D2 89 44 24 20 8B 04 24 89 EF 31 ED 89 7C 24 08 01 44 24 08 8B 44 24 38 89 6C 24 0C 8B 6C 24 04 11 54 24 0C F7 E6 01 44 24 08 89 EF 11 54 24 0C 31 ED 89 3C 24 8B 7C 24 10 01 3C 24 89 6C 24 04 8B 6C 24 14 11 6C 24 04 8B 54 24 0C 8B 6C 24 20 C7 44 24 0C 00 00 00 00 89 D0 31 D2 01 04 24 8B 44 24 28 11 54 24 04 F7 E1 89 44 24 10 8B 44 24 30 89 54 24 14 8B 7C 24 14 F7 E1 89 44 24 38 8B 44 24 28 89 54 24 3C F7 E6 89 54 24 2C 8B 5C 24 2C 31 D2 89 44 24 28 8B 44 24 10 89 D9 31 DB 01 C1 8B 44 24 30 11 D3 F7 E6 89 FE 01 C1 8B 44 24 08 11 D3 31 FF 03 74 24 38 13 7C 24 3C 31 D2 89 6C 24 08 01 DE 11 D7 89 C2 31 C0 03 44 24 08 13 54 24 0C 01 F0 11 FA 39 D7 72 0F 77 04 39 C6 76 09 83 04 24 01 83 54 24 04 00 8B 74 24 04 0B 34 24 0F 85 2F FD FF FF 33 54 24 1C 33 44 24 58 09 C2 0F 85 1F FD FF FF 89 CA 8B 4C 24 28 31 C0 8B 74 24 5C 31 DB 01 C8 11 DA 33 44 24 18 31 D6 09 C6 0F 84 6F FD FF FF 31 C0 E9 1A FD FF FF B9 01 00 00 00 31 DB E9 A3 FC FF FF 90 8D B4 26 00 00 00 00 }
	condition:
		$1
}

rule file_45_1_0 {
	meta:
		name = "___bid128_quiet_greater"
		size = 4608
		refs = "01f2 ___bid_ten2k128 06a3 ___bid_IDEC_glbflags 07c7 ___bid_ten2k64"
	strings:
		$1 = { 81 EC BC 00 00 00 8B 8C 24 C8 00 00 00 89 9C 24 AC 00 00 00 8B 9C 24 D0 00 00 00 89 B4 24 B0 00 00 00 8B B4 24 C4 00 00 00 89 BC 24 B4 00 00 00 8B BC 24 D4 00 00 00 89 0C 24 8B 8C 24 CC 00 00 00 89 5C 24 08 8B 9C 24 D8 00 00 00 89 AC 24 B8 00 00 00 8B AC 24 C0 00 00 00 89 C8 25 00 00 00 7C 3D 00 00 00 7C 89 5C 24 10 8B 9C 24 DC 00 00 00 0F 84 E9 05 00 00 89 D8 25 00 00 00 7C 3D 00 00 00 7C 0F 84 D7 05 00 00 8B 44 24 08 89 FA 31 F2 31 E8 09 C2 0F 84 15 06 00 00 89 C8 25 00 00 00 78 3D 00 00 00 78 0F 84 C3 06 00 00 89 D8 25 00 00 00 78 3D 00 00 00 78 0F 84 A1 06 00 00 89 C8 25 FF FF 01 00 3D 09 ED 01 00 89 44 24 18 0F 86 F2 05 00 00 C6 44 24 20 01 89 DA 81 E2 FF FF 01 00 81 FA 09 ED 01 00 89 54 24 28 77 14 0F 82 12 06 00 00 81 7C 24 10 C0 87 AD BE 0F 86 04 06 00 00 C6 44 24 30 01 80 7C 24 20 00 BA 01 00 00 00 75 12 8B 44 24 18 31 D2 0B 04 24 75 07 89 EA 09 F2 0F 94 C2 80 7C 24 30 00 0F 85 13 06 00 00 8B 44 24 28 0B 44 24 10 0F 84 F9 05 00 00 84 D2 0F 85 1A 06 00 00 89 CA 31 DA 0F 88 10 06 00 00 89 CA 89 D8 C1 EA 11 C1 E8 11 81 E2 FF 3F 00 00 25 FF 3F 00 00 39 D0 89 44 24 20 0F 84 25 06 00 00 8B 44 24 28 39 44 24 18 0F 87 31 08 00 00 72 0D 8B 44 24 10 39 04 24 0F 87 22 08 00 00 8B 44 24 18 33 44 24 28 89 44 24 30 8B 04 24 33 44 24 10 0B 44 24 30 0F 84 55 0D 00 00 8B 44 24 28 39 44 24 18 72 0B 77 13 8B 44 24 10 39 04 24 73 0A 3B 54 24 20 0F 8E FA 07 00 00 89 D0 2B 44 24 20 85 C0 0F 8E 78 08 00 00 83 F8 21 0F 8F 70 05 00 00 83 F8 13 0F 8E DA 05 00 00 8D 48 EC C1 E1 04 8B 91 ?? ?? ?? ?? 8B 81 ?? ?? ?? ?? C7 44 24 54 00 00 00 00 89 54 24 58 89 44 24 40 89 D0 F7 E6 89 44 24 30 8B 44 24 40 89 54 24 34 F7 E6 89 44 24 38 8B 44 24 58 89 54 24 3C F7 E5 89 54 24 4C 8B 54 24 30 89 44 24 48 89 54 24 50 8B 54 24 4C 89 D0 31 D2 89 44 24 20 8B 44 24 50 01 44 24 20 8B 44 24 40 89 54 24 24 8B 54 24 54 11 54 24 24 F7 E5 01 44 24 20 11 54 24 24 8B 54 24 34 89 D0 31 D2 89 44 24 30 89 54 24 34 8B 44 24 38 01 44 24 30 8B 54 24 3C 11 54 24 34 8B 54 24 24 C7 44 24 74 00 00 00 00 89 D0 31 D2 01 44 24 30 11 54 24 34 8B 91 ?? ?? ?? ?? 8B 89 ?? ?? ?? ?? 89 D0 89 54 24 68 F7 E6 89 44 24 38 89 C8 89 54 24 3C F7 E6 89 44 24 50 8B 44 24 68 89 54 24 54 F7 E5 89 54 24 7C 8B 54 24 38 89 44 24 78 89 54 24 70 8B 54 24 7C 89 D0 31 D2 89 44 24 60 8B 44 24 70 01 44 24 60 89 C8 89 54 24 64 8B 54 24 74 11 54 24 64 F7 E5 01 44 24 60 11 54 24 64 8B 54 24 3C C7 44 24 3C 00 00 00 00 89 D0 31 D2 89 44 24 70 8B 44 24 50 01 44 24 70 89 54 24 74 8B 54 24 54 11 54 24 74 8B 54 24 64 89 D0 31 D2 01 44 24 70 8B 44 24 20 11 54 24 74 89 C2 31 C0 89 54 24 24 8B 54 24 48 89 44 24 20 89 54 24 38 8B 44 24 38 01 44 24 20 8B 54 24 3C 11 54 24 24 8B 44 24 70 01 44 24 20 8B 54 24 74 11 54 24 24 8B 44 24 24 39 C2 72 16 77 0A 8B 54 24 20 39 54 24 70 76 0A 83 44 24 30 01 83 54 24 34 00 8B 44 24 18 F7 64 24 58 C7 44 24 3C 00 00 00 00 89 44 24 48 8B 44 24 18 89 54 24 4C F7 64 24 40 89 44 24 70 8B 04 24 89 54 24 74 F7 64 24 58 89 54 24 5C 8B 54 24 48 89 44 24 58 89 54 24 38 8B 54 24 5C 89 D0 31 D2 89 44 24 50 8B 04 24 89 54 24 54 F7 64 24 40 01 44 24 50 8B 44 24 38 11 54 24 54 01 44 24 50 8B 54 24 3C 11 54 24 54 8B 54 24 4C 89 D0 31 D2 89 44 24 48 8B 44 24 70 01 44 24 48 89 54 24 4C 8B 54 24 74 11 54 24 4C 8B 54 24 54 C7 44 24 74 00 00 00 00 89 D0 31 D2 01 44 24 48 8B 44 24 18 11 54 24 4C F7 64 24 68 89 44 24 38 8B 44 24 18 89 54 24 3C F7 E1 89 44 24 18 8B 04 24 89 54 24 1C F7 64 24 68 89 54 24 6C 8B 54 24 38 89 44 24 68 89 54 24 70 8B 54 24 6C 89 D0 31 D2 89 44 24 40 8B 04 24 89 54 24 44 F7 E1 01 44 24 40 11 54 24 44 8B 54 24 70 01 54 24 40 8B 54 24 3C 8B 4C 24 74 11 4C 24 44 8B 4C 24 1C 89 D0 31 D2 89 54 24 3C 8B 54 24 18 89 44 24 38 01 54 24 38 8B 54 24 44 11 4C 24 3C 89 D0 31 D2 01 44 24 38 8B 44 24 40 11 54 24 3C 89 C2 31 C0 89 44 24 40 8B 44 24 68 89 54 24 44 31 D2 01 44 24 40 11 54 24 44 8B 54 24 50 89 D1 31 D2 89 54 24 18 8B 44 24 58 31 D2 01 44 24 18 8B 44 24 38 89 4C 24 1C 11 54 24 1C 8B 54 24 3C 01 44 24 18 11 54 24 1C 8B 4C 24 1C 39 CA 72 14 77 08 8B 54 24 18 39 D0 76 0A 83 44 24 48 01 83 54 24 4C 00 8B 44 24 20 8B 54 24 24 03 44 24 40 13 54 24 44 39 54 24 44 89 44 24 20 89 54 24 24 C7 04 24 01 00 00 00 C7 44 24 04 00 00 00 00 77 17 72 06 39 44 24 40 77 0F C7 04 24 00 00 00 00 C7 44 24 04 00 00 00 00 8B 54 24 18 03 14 24 8B 4C 24 1C 13 4C 24 04 89 54 24 38 8B 44 24 30 8B 54 24 34 03 44 24 38 89 4C 24 3C 13 54 24 3C 89 44 24 30 39 D1 89 54 24 34 0F 87 72 09 00 00 72 0A 39 44 24 38 0F 87 66 09 00 00 8B 4C 24 3C 31 D2 B8 01 00 00 00 39 4C 24 04 77 0F 72 09 8B 4C 24 38 39 0C 24 77 04 31 C0 31 D2 03 44 24 48 13 54 24 4C 89 D1 09 C1 75 5E 8B 44 24 34 0B 44 24 30 75 54 8B 54 24 60 8B 44 24 78 89 D1 31 D2 89 54 24 60 31 D2 01 44 24 60 8B 44 24 10 89 4C 24 64 11 54 24 64 8B 54 24 28 33 54 24 24 33 44 24 20 09 C2 0F 84 16 0B 00 00 8B 44 24 24 39 44 24 28 72 14 0F 87 37 03 00 00 8B 54 24 20 39 54 24 10 0F 83 29 03 00 00 BA 01 00 00 00 89 D8 C1 E8 1F 31 D0 EB 23 90 8D 74 26 00 81 E1 00 00 00 7E 81 F9 00 00 00 7E 74 33 81 E3 00 00 00 7E 31 C0 81 FB 00 00 00 7E 74 23 8B 9C 24 AC 00 00 00 8B B4 24 B0 00 00 00 8B BC 24 B4 00 00 00 8B AC 24 B8 00 00 00 81 C4 BC 00 00 00 C3 83 0D ?? ?? ?? ?? 01 31 C0 EB D2 8D 74 26 00 8B 44 24 10 89 DA 33 04 24 31 CA 09 C2 0F 85 D8 F9 FF FF 31 C0 EB B7 72 0D 81 3C 24 C0 87 AD BE 0F 87 FF F9 FF FF 8B 54 24 18 8B 04 24 81 F2 09 ED 01 00 35 C0 87 AD BE 09 C2 0F 84 90 02 00 00 89 C8 25 00 00 00 60 3D 00 00 00 60 0F 94 44 24 20 E9 D4 F9 FF FF 8B 54 24 28 8B 44 24 10 81 F2 09 ED 01 00 35 C0 87 AD BE 09 C2 0F 84 75 02 00 00 89 D8 25 00 00 00 60 3D 00 00 00 60 0F 94 44 24 30 E9 D0 F9 FF FF 8B 44 24 08 09 F8 0F 85 FB F9 FF FF 31 C0 84 D2 0F 85 31 FF FF FF 84 D2 75 0F 89 C8 F7 D0 C1 E8 1F E9 21 FF FF FF 8D 76 00 89 D8 C1 E8 1F E9 14 FF FF FF 8D B6 00 00 00 00 85 C9 0F 88 4B FF FF FF 89 DA B8 01 00 00 00 81 E2 00 00 00 78 C1 EB 1F 81 FA 00 00 00 78 0F 44 C3 E9 E8 FE FF FF 8B 5C 24 28 39 5C 24 18 77 13 0F 82 6F 02 00 00 8B 5C 24 10 39 1C 24 0F 86 62 02 00 00 BA 01 00 00 00 89 C8 C1 E8 1F 31 D0 E9 BA FE FF FF 8B 0C C5 ?? ?? ?? ?? 8B 04 C5 ?? ?? ?? ?? C7 44 24 4C 00 00 00 00 89 44 24 40 F7 24 24 89 44 24 20 8B 44 24 40 89 54 24 24 F7 64 24 18 89 44 24 38 8B 04 24 89 54 24 3C F7 E1 89 54 24 04 8B 54 24 20 89 04 24 89 54 24 48 8B 54 24 04 89 D0 31 D2 89 44 24 30 8B 44 24 48 01 44 24 30 8B 44 24 18 89 54 24 34 8B 54 24 4C 11 54 24 34 F7 E1 01 44 24 30 11 54 24 34 8B 54 24 24 89 D0 31 D2 89 44 24 20 8B 44 24 38 01 44 24 20 89 54 24 24 8B 54 24 3C 11 54 24 24 8B 54 24 34 C7 44 24 54 00 00 00 00 89 D0 31 D2 01 44 24 20 8B 44 24 40 11 54 24 24 F7 E5 89 44 24 18 8B 44 24 40 89 54 24 1C F7 E6 89 44 24 40 89 C8 89 54 24 44 F7 E5 89 54 24 4C 8B 54 24 18 89 44 24 48 89 54 24 50 8B 54 24 4C 89 D0 31 D2 89 44 24 38 8B 44 24 50 01 44 24 38 89 C8 89 54 24 3C 8B 54 24 54 11 54 24 3C 8B 4C 24 1C F7 E6 01 44 24 38 11 54 24 3C 8B 44 24 40 89 CA 31 C9 89 54 24 18 8B 54 24 44 01 44 24 18 89 4C 24 1C 8B 0C 24 11 54 24 1C 8B 54 24 3C C7 44 24 34 00 00 00 00 89 D0 31 D2 01 44 24 18 8B 44 24 30 11 54 24 1C 89 4C 24 30 89 C2 31 C0 03 44 24 30 13 54 24 34 03 44 24 18 13 54 24 1C 39 54 24 1C 72 12 77 06 39 44 24 18 76 0A 83 44 24 20 01 83 54 24 24 00 8B 4C 24 24 0B 4C 24 20 0F 85 01 FD FF FF 8B 74 24 28 8B 4C 24 10 31 D6 31 C1 09 CE 0F 84 9E 07 00 00 39 54 24 28 0F 82 E3 FC FF FF 77 0A 39 44 24 10 0F 82 D7 FC FF FF 31 D2 E9 D5 FC FF FF 8D 76 00 81 FE 63 8E 8D 37 C6 44 24 20 01 0F 87 49 F7 FF FF E9 5A FD FF FF 81 FF 63 8E 8D 37 C6 44 24 30 01 0F 87 60 F7 FF FF E9 75 FD FF FF 8D 74 26 00 3B 54 24 20 0F 8D 97 FD FF FF 8B 44 24 28 39 44 24 18 73 0A 89 C8 C1 E8 1F E9 B0 FC FF FF 77 09 8B 44 24 10 39 04 24 72 EB 8B 44 24 18 33 44 24 28 89 44 24 30 8B 04 24 33 44 24 10 0B 44 24 30 0F 85 D4 F7 FF FF 39 F7 0F 82 CC F7 FF FF 0F 87 BC F7 FF FF 39 6C 24 08 0F 86 BC F7 FF FF 66 90 E9 AB F7 FF FF 8B 54 24 18 8B 04 24 33 54 24 28 33 44 24 10 09 C2 74 07 31 D2 E9 89 FD FF FF 39 F7 77 F5 0F 82 7A FD FF FF 39 6C 24 08 8D 76 00 0F 86 6D FD FF FF 31 D2 E9 6B FD FF FF 8D 76 00 8B 44 24 20 29 D0 83 F8 21 0F 8F 65 FF FF FF 83 F8 13 0F 8E CB 04 00 00 8D 58 EC C1 E3 04 8B 83 ?? ?? ?? ?? 8B 93 ?? ?? ?? ?? C7 44 24 54 00 00 00 00 89 44 24 48 89 54 24 38 F7 E7 89 44 24 30 8B 44 24 38 89 54 24 34 F7 E7 89 44 24 58 8B 44 24 48 89 54 24 5C F7 64 24 08 89 54 24 44 8B 54 24 30 89 44 24 40 89 54 24 50 8B 54 24 44 89 D0 31 D2 89 44 24 20 8B 44 24 50 01 44 24 20 8B 44 24 38 89 54 24 24 8B 54 24 54 11 54 24 24 F7 64 24 08 01 44 24 20 11 54 24 24 8B 54 24 34 89 D0 31 D2 89 44 24 30 8B 44 24 58 01 44 24 30 89 54 24 34 8B 54 24 5C 11 54 24 34 8B 54 24 24 C7 44 24 7C 00 00 00 00 89 D0 31 D2 01 44 24 30 11 54 24 34 8B 93 ?? ?? ?? ?? 8B 9B ?? ?? ?? ?? 89 D0 89 54 24 58 F7 E7 89 44 24 60 89 D8 89 54 24 64 F7 E7 89 44 24 50 8B 44 24 58 89 54 24 54 F7 64 24 08 89 54 24 74 8B 54 24 60 89 44 24 70 89 54 24 78 8B 54 24 74 89 D0 31 D2 89 44 24 68 8B 44 24 78 89 54 24 6C 8B 54 24 7C 01 44 24 68 8B 44 24 08 11 54 24 6C C7 44 24 0C 00 00 00 00 F7 E3 01 44 24 68 11 54 24 6C 8B 54 24 64 89 D0 31 D2 89 44 24 60 8B 44 24 50 01 44 24 60 89 54 24 64 8B 54 24 54 11 54 24 64 8B 54 24 6C 89 D0 31 D2 01 44 24 60 8B 44 24 20 11 54 24 64 89 C2 31 C0 89 54 24 24 8B 54 24 40 89 44 24 20 89 54 24 08 8B 44 24 08 8B 54 24 0C 01 44 24 20 8B 44 24 60 11 54 24 24 01 44 24 20 8B 54 24 64 11 54 24 24 8B 44 24 24 39 C2 72 16 77 0A 8B 54 24 20 39 54 24 60 76 0A 83 44 24 30 01 83 54 24 34 00 8B 44 24 28 F7 64 24 48 C7 44 24 0C 00 00 00 00 89 44 24 40 8B 44 24 28 89 54 24 44 F7 64 24 38 89 44 24 50 8B 44 24 10 89 54 24 54 F7 64 24 48 89 54 24 4C 8B 54 24 40 89 44 24 48 89 54 24 08 8B 54 24 4C 89 D0 31 D2 89 44 24 60 8B 44 24 10 89 54 24 64 F7 64 24 38 01 44 24 60 8B 44 24 08 11 54 24 64 01 44 24 60 8B 54 24 0C 11 54 24 64 8B 54 24 44 89 D0 31 D2 89 44 24 40 8B 44 24 50 01 44 24 40 89 54 24 44 8B 54 24 54 11 54 24 44 8B 54 24 64 C7 44 24 54 00 00 00 00 89 D0 31 D2 01 44 24 40 8B 44 24 28 11 54 24 44 F7 64 24 58 89 44 24 38 8B 44 24 28 89 54 24 3C F7 E3 89 44 24 28 8B 44 24 10 89 54 24 2C F7 64 24 58 89 54 24 5C 8B 54 24 38 89 44 24 58 89 54 24 50 8B 54 24 5C 89 D0 31 D2 89 44 24 08 8B 44 24 10 89 54 24 0C F7 E3 01 44 24 08 11 54 24 0C 8B 44 24 50 01 44 24 08 8B 54 24 54 11 54 24 0C 8B 54 24 3C 89 D0 31 D2 89 44 24 38 8B 44 24 28 01 44 24 38 89 54 24 3C 8B 54 24 2C 11 54 24 3C 8B 54 24 0C 89 D0 31 D2 01 44 24 38 8B 44 24 08 11 54 24 3C 89 C2 31 C0 89 44 24 08 8B 44 24 58 89 54 24 0C 31 D2 01 44 24 08 8B 44 24 60 11 54 24 0C 89 C2 31 C0 89 44 24 28 8B 44 24 48 89 54 24 2C 31 D2 01 44 24 28 8B 44 24 38 11 54 24 2C 8B 54 24 3C 01 44 24 28 11 54 24 2C 8B 5C 24 2C 39 DA 72 14 77 08 8B 54 24 28 39 D0 76 0A 83 44 24 40 01 83 54 24 44 00 8B 44 24 20 8B 54 24 24 03 44 24 08 13 54 24 0C 39 54 24 0C 89 44 24 20 89 54 24 24 C7 44 24 10 01 00 00 00 C7 44 24 14 00 00 00 00 77 18 72 06 39 44 24 08 77 10 C7 44 24 10 00 00 00 00 C7 44 24 14 00 00 00 00 8B 44 24 28 8B 54 24 2C 03 44 24 10 13 54 24 14 89 44 24 28 8B 44 24 30 89 54 24 2C 8B 54 24 34 03 44 24 28 13 54 24 2C 39 54 24 2C 89 44 24 30 89 54 24 34 0F 87 B0 02 00 00 72 0A 39 44 24 28 0F 87 A4 02 00 00 8B 5C 24 2C 31 D2 B8 01 00 00 00 39 5C 24 14 77 10 72 0A 8B 5C 24 28 39 5C 24 10 77 04 31 C0 31 D2 03 44 24 40 13 54 24 44 89 D3 09 C3 75 49 8B 44 24 34 0B 44 24 30 75 3F 8B 5C 24 70 8B 44 24 68 C7 44 24 0C 00 00 00 00 89 5C 24 08 8B 5C 24 24 89 C2 31 C0 03 44 24 08 13 54 24 0C 39 5C 24 18 74 28 8B 44 24 24 39 44 24 18 72 0B 77 39 8B 54 24 20 39 14 24 73 30 BA 01 00 00 00 89 C8 F7 D0 C1 E8 1F 31 D0 E9 A5 F7 FF FF 8B 5C 24 20 39 1C 24 75 CF 39 F2 0F 84 04 03 00 00 39 F2 72 08 66 90 77 D4 39 E8 77 D0 31 D2 EB D1 8D B6 00 00 00 00 39 F7 73 11 3B 54 24 20 0F 8C E8 FA FF FF 66 90 E9 3C F8 FF FF 0F 87 A5 F2 FF FF 39 6C 24 08 90 72 E2 E9 CF FA FF FF B8 01 00 00 00 31 D2 E9 AE F6 FF FF 8B 0C C5 ?? ?? ?? ?? 8B 04 C5 ?? ?? ?? ?? C7 44 24 4C 00 00 00 00 89 44 24 40 F7 64 24 10 89 44 24 20 8B 44 24 40 89 54 24 24 F7 64 24 28 89 44 24 38 8B 44 24 10 89 54 24 3C F7 E1 89 54 24 14 8B 54 24 20 89 44 24 10 89 54 24 48 8B 54 24 14 89 D0 31 D2 89 44 24 30 8B 44 24 48 01 44 24 30 8B 44 24 28 89 54 24 34 8B 54 24 4C 11 54 24 34 F7 E1 01 44 24 30 11 54 24 34 8B 54 24 24 89 D0 31 D2 89 44 24 20 8B 44 24 38 01 44 24 20 89 54 24 24 8B 54 24 3C 11 54 24 24 8B 54 24 34 C7 44 24 4C 00 00 00 00 89 D0 31 D2 01 44 24 20 8B 44 24 40 11 54 24 24 F7 64 24 08 89 44 24 28 8B 44 24 40 89 54 24 2C F7 E7 89 44 24 40 8B }
	condition:
		$1
}

rule file_45_2_0 {
	meta:
		name = "___bid128_quiet_greater_equal"
		size = 4576
		refs = "01d0 ___bid_ten2k128 067a ___bid_IDEC_glbflags 07b5 ___bid_ten2k64"
	strings:
		$1 = { 81 EC BC 00 00 00 8B 8C 24 C8 00 00 00 89 9C 24 AC 00 00 00 8B 9C 24 D0 00 00 00 89 B4 24 B0 00 00 00 8B B4 24 C4 00 00 00 89 BC 24 B4 00 00 00 8B BC 24 D4 00 00 00 89 4C 24 08 8B 8C 24 CC 00 00 00 89 1C 24 8B 9C 24 D8 00 00 00 89 AC 24 B8 00 00 00 8B AC 24 C0 00 00 00 89 C8 25 00 00 00 7C 3D 00 00 00 7C 89 5C 24 10 8B 9C 24 DC 00 00 00 0F 84 C0 05 00 00 89 D8 25 00 00 00 7C 3D 00 00 00 7C 0F 84 AE 05 00 00 8B 04 24 89 FA 31 F2 31 E8 09 C2 0F 84 E9 05 00 00 89 C8 25 00 00 00 78 3D 00 00 00 78 0F 84 A4 06 00 00 89 D8 25 00 00 00 78 3D 00 00 00 78 0F 84 82 06 00 00 89 C8 25 FF FF 01 00 3D 09 ED 01 00 89 44 24 18 0F 86 CC 05 00 00 C6 44 24 28 01 89 DA 81 E2 FF FF 01 00 81 FA 09 ED 01 00 89 54 24 20 77 14 0F 82 EE 05 00 00 81 7C 24 10 C0 87 AD BE 0F 86 E0 05 00 00 C6 44 24 30 01 80 7C 24 28 00 BA 01 00 00 00 75 13 8B 44 24 18 31 D2 0B 44 24 08 75 07 89 EA 09 F2 0F 94 C2 80 7C 24 30 00 0F 85 ED 05 00 00 8B 44 24 20 0B 44 24 10 0F 84 D4 05 00 00 84 D2 0F 85 FA 05 00 00 89 CA 31 DA 0F 88 F0 05 00 00 89 C8 C1 E8 11 25 FF 3F 00 00 89 44 24 30 89 D8 C1 E8 11 25 FF 3F 00 00 3B 44 24 30 0F 84 02 06 00 00 8B 54 24 20 39 54 24 18 0F 83 1C 08 00 00 39 F7 72 12 77 05 39 2C 24 72 0B 39 44 24 30 90 0F 8C FF 0E 00 00 8B 54 24 30 29 C2 85 D2 89 54 24 28 0F 8E A8 08 00 00 83 FA 21 0F 8F 7D 05 00 00 83 7C 24 28 13 0F 8E 16 0D 00 00 8B 4C 24 28 C7 44 24 54 00 00 00 00 83 E9 14 C1 E1 04 8B 81 ?? ?? ?? ?? 8B 91 ?? ?? ?? ?? 89 44 24 58 89 54 24 40 F7 E6 89 44 24 38 8B 44 24 40 89 54 24 3C F7 E6 89 44 24 30 8B 44 24 58 89 54 24 34 F7 E5 89 54 24 4C 8B 54 24 38 89 44 24 48 89 54 24 50 8B 54 24 4C 89 D0 31 D2 89 44 24 28 8B 44 24 50 01 44 24 28 8B 44 24 40 89 54 24 2C 8B 54 24 54 11 54 24 2C F7 E5 01 44 24 28 11 54 24 2C 8B 54 24 3C 89 D0 31 D2 89 44 24 38 8B 44 24 30 01 44 24 38 89 54 24 3C 8B 54 24 34 11 54 24 3C 8B 54 24 2C C7 44 24 74 00 00 00 00 89 D0 31 D2 01 44 24 38 11 54 24 3C 8B 91 ?? ?? ?? ?? 8B 89 ?? ?? ?? ?? 89 D0 89 54 24 60 F7 E6 89 44 24 30 89 C8 89 54 24 34 F7 E6 89 44 24 50 8B 44 24 60 89 54 24 54 F7 E5 89 54 24 7C 8B 54 24 30 89 44 24 78 89 54 24 70 8B 54 24 7C 89 D0 31 D2 89 44 24 68 8B 44 24 70 01 44 24 68 89 C8 89 54 24 6C 8B 54 24 74 11 54 24 6C F7 E5 01 44 24 68 11 54 24 6C 8B 54 24 34 C7 44 24 34 00 00 00 00 89 D0 31 D2 89 44 24 70 8B 44 24 50 01 44 24 70 89 54 24 74 8B 54 24 54 11 54 24 74 8B 54 24 6C 89 D0 31 D2 01 44 24 70 8B 44 24 28 11 54 24 74 89 C2 31 C0 89 54 24 2C 8B 54 24 48 89 44 24 28 89 54 24 30 8B 44 24 30 01 44 24 28 8B 54 24 34 11 54 24 2C 8B 44 24 70 01 44 24 28 8B 54 24 74 11 54 24 2C 8B 44 24 2C 39 C2 72 16 77 0A 8B 54 24 28 39 54 24 70 76 0A 83 44 24 38 01 83 54 24 3C 00 8B 44 24 18 F7 64 24 58 C7 44 24 34 00 00 00 00 89 44 24 48 8B 44 24 18 89 54 24 4C F7 64 24 40 89 44 24 70 8B 44 24 08 89 54 24 74 F7 64 24 58 89 54 24 5C 8B 54 24 48 89 44 24 58 89 54 24 30 8B 54 24 5C 89 D0 31 D2 89 44 24 50 8B 44 24 08 89 54 24 54 F7 64 24 40 01 44 24 50 8B 44 24 30 11 54 24 54 01 44 24 50 8B 54 24 34 11 54 24 54 8B 54 24 4C 89 D0 31 D2 89 44 24 48 8B 44 24 70 01 44 24 48 89 54 24 4C 8B 54 24 74 11 54 24 4C 8B 54 24 54 C7 44 24 74 00 00 00 00 89 D0 31 D2 01 44 24 48 8B 44 24 18 11 54 24 4C F7 64 24 60 89 44 24 30 8B 44 24 18 89 54 24 34 F7 E1 89 44 24 18 8B 44 24 08 89 54 24 1C F7 64 24 60 89 54 24 64 8B 54 24 30 89 44 24 60 89 54 24 70 8B 54 24 64 89 D0 31 D2 89 44 24 40 8B 44 24 08 89 54 24 44 F7 E1 01 44 24 40 11 54 24 44 8B 54 24 70 01 54 24 40 8B 54 24 34 8B 4C 24 74 11 4C 24 44 8B 4C 24 1C 89 D0 31 D2 89 54 24 34 8B 54 24 18 89 44 24 30 01 54 24 30 8B 54 24 44 11 4C 24 34 89 D0 31 D2 01 44 24 30 8B 44 24 40 11 54 24 34 89 C2 31 C0 89 44 24 40 8B 44 24 60 89 54 24 44 31 D2 01 44 24 40 11 54 24 44 8B 54 24 50 89 D1 31 D2 89 54 24 18 8B 44 24 58 31 D2 01 44 24 18 8B 44 24 30 89 4C 24 1C 11 54 24 1C 8B 54 24 34 01 44 24 18 11 54 24 1C 8B 4C 24 1C 39 CA 72 14 77 08 8B 54 24 18 39 D0 76 0A 83 44 24 48 01 83 54 24 4C 00 8B 44 24 28 8B 54 24 2C 03 44 24 40 13 54 24 44 39 54 24 44 89 44 24 28 89 54 24 2C C7 44 24 08 01 00 00 00 C7 44 24 0C 00 00 00 00 77 18 72 06 39 44 24 40 77 10 C7 44 24 08 00 00 00 00 C7 44 24 0C 00 00 00 00 8B 54 24 18 03 54 24 08 8B 4C 24 1C 13 4C 24 0C 89 54 24 30 8B 44 24 38 8B 54 24 3C 03 44 24 30 89 4C 24 34 13 54 24 34 89 44 24 38 39 D1 89 54 24 3C 0F 87 0F 0B 00 00 72 0A 39 44 24 30 0F 87 03 0B 00 00 8B 4C 24 34 31 D2 B8 01 00 00 00 39 4C 24 0C 77 10 72 0A 8B 4C 24 30 39 4C 24 08 77 04 31 C0 31 D2 03 44 24 48 13 54 24 4C 89 D1 09 C1 75 5E 8B 44 24 3C 0B 44 24 38 75 54 8B 54 24 68 8B 44 24 78 89 D1 31 D2 89 54 24 68 31 D2 01 44 24 68 8B 44 24 10 89 4C 24 6C 11 54 24 6C 8B 54 24 20 33 54 24 2C 33 44 24 28 09 C2 0F 84 F2 0A 00 00 8B 44 24 2C 39 44 24 20 72 14 0F 87 4B 03 00 00 8B 54 24 28 39 54 24 10 0F 83 3D 03 00 00 BA 01 00 00 00 89 D8 C1 E8 1F 31 D0 EB 1E 81 E1 00 00 00 7E 81 F9 00 00 00 7E 74 33 81 E3 00 00 00 7E 31 C0 81 FB 00 00 00 7E 74 23 8B 9C 24 AC 00 00 00 8B B4 24 B0 00 00 00 8B BC 24 B4 00 00 00 8B AC 24 B8 00 00 00 81 C4 BC 00 00 00 C3 83 0D ?? ?? ?? ?? 01 31 C0 EB D2 8B 44 24 10 89 DA 33 44 24 08 31 CA 09 C2 0F 85 03 FA FF FF B8 01 00 00 00 EB B7 66 90 72 0E 81 7C 24 08 C0 87 AD BE 0F 87 24 FA FF FF 8B 54 24 18 8B 44 24 08 81 F2 09 ED 01 00 35 C0 87 AD BE 09 C2 0F 84 A5 02 00 00 89 C8 25 00 00 00 60 3D 00 00 00 60 0F 94 44 24 28 E9 F8 F9 FF FF 8B 54 24 20 8B 44 24 10 81 F2 09 ED 01 00 35 C0 87 AD BE 09 C2 0F 84 8A 02 00 00 89 D8 25 00 00 00 60 3D 00 00 00 60 0F 94 44 24 30 E9 F4 F9 FF FF 8B 04 24 09 F8 0F 85 21 FA FF FF 84 D2 B8 01 00 00 00 0F 85 2B FF FF FF 84 D2 75 12 89 C8 F7 D0 C1 E8 1F E9 1B FF FF FF 8D B6 00 00 00 00 89 D8 C1 E8 1F E9 0B FF FF FF 8D B6 00 00 00 00 85 C9 B8 01 00 00 00 0F 89 F8 FE FF FF 89 DA 81 E2 00 00 00 78 81 FA 00 00 00 78 74 36 31 C0 E9 E1 FE FF FF 8B 5C 24 20 39 5C 24 18 77 14 0F 82 91 02 00 00 8B 5C 24 10 39 5C 24 08 0F 86 83 02 00 00 BA 01 00 00 00 89 C8 C1 E8 1F 31 D0 E9 B2 FE FF FF 85 DB 0F 88 AA FE FF FF 31 C0 E9 A3 FE FF FF 8B 0C C5 ?? ?? ?? ?? 8B 04 C5 ?? ?? ?? ?? C7 44 24 4C 00 00 00 00 89 44 24 40 F7 64 24 10 89 44 24 28 8B 44 24 40 89 54 24 2C F7 64 24 20 89 44 24 30 8B 44 24 10 89 54 24 34 F7 E1 89 54 24 14 8B 54 24 28 89 44 24 10 89 54 24 48 8B 54 24 14 89 D0 31 D2 89 44 24 38 8B 44 24 48 01 44 24 38 8B 44 24 20 89 54 24 3C 8B 54 24 4C 11 54 24 3C F7 E1 01 44 24 38 11 54 24 3C 8B 54 24 2C 89 D0 31 D2 89 44 24 28 8B 44 24 30 01 44 24 28 89 54 24 2C 8B 54 24 34 11 54 24 2C 8B 54 24 3C C7 44 24 4C 00 00 00 00 89 D0 31 D2 01 44 24 28 8B 44 24 40 11 54 24 2C F7 24 24 89 44 24 20 8B 44 24 40 89 54 24 24 F7 E7 89 44 24 40 8B 04 24 89 54 24 44 F7 E1 89 54 24 04 8B 54 24 20 89 04 24 89 54 24 48 8B 54 24 04 89 D0 31 D2 89 44 24 30 8B 44 24 48 01 44 24 30 89 C8 89 54 24 34 8B 54 24 4C 11 54 24 34 8B 4C 24 24 F7 E7 01 44 24 30 11 54 24 34 8B 44 24 40 89 CA 31 C9 89 54 24 20 8B 54 24 44 01 44 24 20 89 4C 24 24 8B 4C 24 10 11 54 24 24 8B 54 24 34 C7 44 24 3C 00 00 00 00 89 D0 31 D2 01 44 24 20 8B 44 24 38 11 54 24 24 89 4C 24 38 89 C2 31 C0 03 44 24 38 13 54 24 3C 03 44 24 20 13 54 24 24 39 54 24 24 72 12 77 06 39 44 24 20 76 0A 83 44 24 28 01 83 54 24 2C 00 8B 4C 24 2C 0B 4C 24 28 75 2B 8B 7C 24 18 8B 4C 24 08 31 D7 31 C1 09 CF 0F 84 DC 07 00 00 39 54 24 18 0F 87 D0 FC FF FF 72 0B 39 44 24 08 90 0F 87 C3 FC FF FF 31 D2 E9 C1 FC FF FF 8D 76 00 81 FE 63 8E 8D 37 C6 44 24 28 01 0F 87 58 F7 FF FF E9 45 FD FF FF 81 FF 63 8E 8D 37 C6 44 24 30 01 0F 87 6F F7 FF FF E9 60 FD FF FF 77 0E 8B 54 24 10 39 54 24 08 0F 82 D4 F7 FF FF 39 F7 76 27 8B 54 24 20 39 54 24 18 0F 82 CD F7 FF FF 0F 87 D2 F7 FF FF 8B 54 24 10 39 54 24 08 0F 86 B9 F7 FF FF E9 BF F7 FF FF 72 09 39 2C 24 8D 74 26 00 77 CE 39 44 24 30 0F 8F 42 FD FF FF 8B 54 24 20 39 54 24 18 0F 87 9C F7 FF FF 0F 82 80 F7 FF FF 8B 54 24 10 39 54 24 08 0F 87 88 F7 FF FF 66 90 E9 6B F7 FF FF 8B 54 24 18 8B 44 24 08 33 54 24 20 33 44 24 10 09 C2 74 07 31 D2 E9 67 FD FF FF 39 F7 77 F5 0F 82 58 FD FF FF 39 2C 24 8D 76 00 0F 86 4C FD FF FF 31 D2 E9 4A FD FF FF 8D 76 00 2B 44 24 30 83 F8 21 0F 8F 38 06 00 00 83 F8 13 0F 8E 4C FD FF FF 8D 58 EC C1 E3 04 8B 83 ?? ?? ?? ?? 8B 93 ?? ?? ?? ?? C7 44 24 54 00 00 00 00 89 44 24 48 89 54 24 40 F7 E7 89 44 24 38 8B 44 24 40 89 54 24 3C F7 E7 89 44 24 58 8B 44 24 48 89 54 24 5C F7 24 24 89 54 24 34 8B 54 24 38 89 44 24 30 89 54 24 50 8B 54 24 34 89 D0 31 D2 89 44 24 28 8B 44 24 50 01 44 24 28 8B 44 24 40 89 54 24 2C 8B 54 24 54 11 54 24 2C F7 24 24 01 44 24 28 11 54 24 2C 8B 54 24 3C 89 D0 31 D2 89 44 24 38 8B 44 24 58 01 44 24 38 89 54 24 3C 8B 54 24 5C 11 54 24 3C 8B 54 24 2C C7 44 24 7C 00 00 00 00 89 D0 31 D2 01 44 24 38 11 54 24 3C 8B 93 ?? ?? ?? ?? 8B 9B ?? ?? ?? ?? 89 D0 89 54 24 58 F7 E7 89 44 24 60 89 D8 89 54 24 64 F7 E7 89 44 24 50 8B 44 24 58 89 54 24 54 F7 24 24 89 54 24 74 8B 54 24 60 89 44 24 70 89 54 24 78 8B 54 24 74 89 D0 31 D2 89 44 24 68 8B 44 24 78 89 54 24 6C 8B 54 24 7C 01 44 24 68 8B 04 24 11 54 24 6C C7 44 24 04 00 00 00 00 F7 E3 01 44 24 68 11 54 24 6C 8B 54 24 64 89 D0 31 D2 89 44 24 60 8B 44 24 50 01 44 24 60 89 54 24 64 8B 54 24 54 11 54 24 64 8B 54 24 6C 89 D0 31 D2 01 44 24 60 8B 44 24 28 11 54 24 64 89 C2 31 C0 89 54 24 2C 8B 54 24 30 89 44 24 28 89 14 24 8B 04 24 8B 54 24 04 01 44 24 28 8B 44 24 60 11 54 24 2C 01 44 24 28 8B 54 24 64 11 54 24 2C 8B 44 24 2C 39 C2 72 16 77 0A 8B 54 24 28 39 54 24 60 76 0A 83 44 24 38 01 83 54 24 3C 00 8B 44 24 20 F7 64 24 48 C7 44 24 04 00 00 00 00 89 44 24 30 8B 44 24 20 89 54 24 34 F7 64 24 40 89 44 24 50 8B 44 24 10 89 54 24 54 F7 64 24 48 89 54 24 4C 8B 54 24 30 89 44 24 48 89 14 24 8B 54 24 4C 89 D0 31 D2 89 44 24 60 8B 44 24 10 89 54 24 64 F7 64 24 40 01 44 24 60 8B 04 24 11 54 24 64 01 44 24 60 8B 54 24 04 11 54 24 64 8B 54 24 34 89 D0 31 D2 89 44 24 30 8B 44 24 50 01 44 24 30 89 54 24 34 8B 54 24 54 11 54 24 34 8B 54 24 64 C7 44 24 54 00 00 00 00 89 D0 31 D2 01 44 24 30 8B 44 24 20 11 54 24 34 F7 64 24 58 89 44 24 40 8B 44 24 20 89 54 24 44 F7 E3 89 44 24 20 8B 44 24 10 89 54 24 24 F7 64 24 58 89 54 24 5C 8B 54 24 40 89 44 24 58 89 54 24 50 8B 54 24 5C 89 D0 31 D2 89 04 24 8B 44 24 10 89 54 24 04 F7 E3 01 04 24 11 54 24 04 8B 44 24 50 01 04 24 8B 54 24 54 11 54 24 04 8B 54 24 44 89 D0 31 D2 89 44 24 40 8B 44 24 20 01 44 24 40 89 54 24 44 8B 54 24 24 11 54 24 44 8B 54 24 04 89 D0 31 D2 01 44 24 40 8B 04 24 11 54 24 44 89 C2 31 C0 89 04 24 8B 44 24 58 89 54 24 04 31 D2 01 04 24 8B 44 24 60 11 54 24 04 89 C2 31 C0 89 44 24 20 8B 44 24 48 89 54 24 24 31 D2 01 44 24 20 8B 44 24 40 11 54 24 24 8B 54 24 44 01 44 24 20 11 54 24 24 8B 5C 24 24 39 DA 72 14 77 08 8B 54 24 20 39 D0 76 0A 83 44 24 30 01 83 54 24 34 00 8B 44 24 28 8B 54 24 2C 03 04 24 13 54 24 04 39 54 24 04 89 44 24 28 89 54 24 2C C7 44 24 10 01 00 00 00 C7 44 24 14 00 00 00 00 77 17 72 05 39 04 24 77 10 C7 44 24 10 00 00 00 00 C7 44 24 14 00 00 00 00 8B 44 24 20 8B 54 24 24 03 44 24 10 13 54 24 14 89 44 24 20 8B 44 24 38 89 54 24 24 8B 54 24 3C 03 44 24 20 13 54 24 24 39 54 24 24 89 44 24 38 89 54 24 3C 0F 87 7B 02 00 00 72 0A 39 44 24 20 0F 87 6F 02 00 00 8B 5C 24 24 31 D2 B8 01 00 00 00 39 5C 24 14 77 10 72 0A 8B 5C 24 20 39 5C 24 10 77 04 31 C0 31 D2 03 44 24 30 13 54 24 34 89 D3 09 C3 0F 85 BA FB FF FF 8B 44 24 3C 0B 44 24 38 0F 85 AC FB FF FF 8B 5C 24 70 8B 44 24 68 C7 44 24 04 00 00 00 00 89 1C 24 8B 5C 24 2C 89 C2 31 C0 03 04 24 13 54 24 04 39 5C 24 18 0F 84 D2 02 00 00 8B 44 24 2C 39 44 24 18 0F 82 72 FB FF FF 0F 87 D5 F8 FF FF 8B 54 24 28 39 54 24 08 0F 87 C7 F8 FF FF 31 D2 E9 C5 F8 FF FF 8B 44 24 28 C7 44 24 4C 00 00 00 00 8B 14 C5 ?? ?? ?? ?? 8B 0C C5 ?? ?? ?? ?? 89 54 24 40 89 D0 F7 64 24 08 89 44 24 28 8B 44 24 40 89 54 24 2C F7 64 24 18 89 44 24 30 8B 44 24 08 89 54 24 34 F7 E1 89 54 24 0C 8B 54 24 28 89 44 24 08 89 54 24 48 8B 54 24 0C 89 D0 31 D2 89 44 24 38 8B 44 24 48 01 44 24 38 8B 44 24 18 89 54 24 3C 8B 54 24 4C 11 54 24 3C F7 E1 01 44 24 38 11 54 24 3C 8B 54 24 2C 89 D0 31 D2 89 44 24 28 8B 44 24 30 01 44 24 28 89 54 24 2C 8B 54 24 34 11 54 24 2C 8B 54 24 3C C7 44 24 54 00 00 00 00 89 D0 31 D2 01 44 24 28 8B 44 24 40 11 54 24 2C F7 E5 89 44 24 18 8B 44 24 40 89 54 24 1C F7 E6 89 44 24 40 89 C8 89 54 24 44 F7 E5 89 54 24 4C 8B 54 24 18 89 44 24 48 89 54 24 50 8B 54 24 4C 89 D0 31 D2 89 44 24 30 8B 44 24 50 01 44 24 30 89 C8 89 54 24 34 8B 54 24 54 11 54 24 34 8B 4C 24 1C F7 E6 01 44 24 30 11 54 24 34 8B 44 24 40 89 CA 31 C9 89 54 24 18 8B 54 24 44 01 44 24 18 89 4C }
	condition:
		$1
}

rule file_45_3_0 {
	meta:
		name = "___bid128_quiet_greater_unordered"
		size = 4560
		refs = "01d0 ___bid_ten2k128 0682 ___bid_IDEC_glbflags 07a8 ___bid_ten2k64"
	strings:
		$1 = { 81 EC BC 00 00 00 8B 8C 24 C8 00 00 00 89 9C 24 AC 00 00 00 8B 9C 24 D0 00 00 00 89 B4 24 B0 00 00 00 8B B4 24 C4 00 00 00 89 BC 24 B4 00 00 00 8B BC 24 D4 00 00 00 89 4C 24 08 8B 8C 24 CC 00 00 00 89 1C 24 8B 9C 24 D8 00 00 00 89 AC 24 B8 00 00 00 8B AC 24 C0 00 00 00 89 C8 25 00 00 00 7C 3D 00 00 00 7C 89 5C 24 10 8B 9C 24 DC 00 00 00 0F 84 C0 05 00 00 89 D8 25 00 00 00 7C 3D 00 00 00 7C 0F 84 AE 05 00 00 8B 04 24 89 FA 31 F2 31 E8 09 C2 0F 84 F6 05 00 00 89 C8 25 00 00 00 78 3D 00 00 00 78 0F 84 A4 06 00 00 89 D8 25 00 00 00 78 3D 00 00 00 78 0F 84 88 06 00 00 89 C8 25 FF FF 01 00 3D 09 ED 01 00 89 44 24 18 0F 86 D4 05 00 00 C6 44 24 28 01 89 DA 81 E2 FF FF 01 00 81 FA 09 ED 01 00 89 54 24 20 77 14 0F 82 FD 05 00 00 81 7C 24 10 C0 87 AD BE 0F 86 EF 05 00 00 C6 44 24 30 01 80 7C 24 28 00 BA 01 00 00 00 75 13 8B 44 24 18 31 D2 0B 44 24 08 75 07 89 EA 09 F2 0F 94 C2 80 7C 24 30 00 0F 85 FC 05 00 00 8B 44 24 20 0B 44 24 10 0F 84 E3 05 00 00 84 D2 0F 85 00 06 00 00 89 CA 31 DA 0F 88 F6 05 00 00 89 C8 C1 E8 11 25 FF 3F 00 00 89 44 24 30 89 D8 C1 E8 11 25 FF 3F 00 00 3B 44 24 30 0F 84 04 06 00 00 8B 54 24 20 39 54 24 18 0F 83 0C 08 00 00 39 F7 72 12 77 05 39 2C 24 72 0B 39 44 24 30 90 0F 8C EF 0E 00 00 8B 54 24 30 29 C2 85 D2 89 54 24 28 0F 8E 98 08 00 00 83 FA 21 0F 8F 89 05 00 00 83 7C 24 28 13 0F 8E 06 0D 00 00 8B 4C 24 28 C7 44 24 54 00 00 00 00 83 E9 14 C1 E1 04 8B 81 ?? ?? ?? ?? 8B 91 ?? ?? ?? ?? 89 44 24 58 89 54 24 40 F7 E6 89 44 24 38 8B 44 24 40 89 54 24 3C F7 E6 89 44 24 30 8B 44 24 58 89 54 24 34 F7 E5 89 54 24 4C 8B 54 24 38 89 44 24 48 89 54 24 50 8B 54 24 4C 89 D0 31 D2 89 44 24 28 8B 44 24 50 01 44 24 28 8B 44 24 40 89 54 24 2C 8B 54 24 54 11 54 24 2C F7 E5 01 44 24 28 11 54 24 2C 8B 54 24 3C 89 D0 31 D2 89 44 24 38 8B 44 24 30 01 44 24 38 89 54 24 3C 8B 54 24 34 11 54 24 3C 8B 54 24 2C C7 44 24 74 00 00 00 00 89 D0 31 D2 01 44 24 38 11 54 24 3C 8B 91 ?? ?? ?? ?? 8B 89 ?? ?? ?? ?? 89 D0 89 54 24 60 F7 E6 89 44 24 30 89 C8 89 54 24 34 F7 E6 89 44 24 50 8B 44 24 60 89 54 24 54 F7 E5 89 54 24 7C 8B 54 24 30 89 44 24 78 89 54 24 70 8B 54 24 7C 89 D0 31 D2 89 44 24 68 8B 44 24 70 01 44 24 68 89 C8 89 54 24 6C 8B 54 24 74 11 54 24 6C F7 E5 01 44 24 68 11 54 24 6C 8B 54 24 34 C7 44 24 34 00 00 00 00 89 D0 31 D2 89 44 24 70 8B 44 24 50 01 44 24 70 89 54 24 74 8B 54 24 54 11 54 24 74 8B 54 24 6C 89 D0 31 D2 01 44 24 70 8B 44 24 28 11 54 24 74 89 C2 31 C0 89 54 24 2C 8B 54 24 48 89 44 24 28 89 54 24 30 8B 44 24 30 01 44 24 28 8B 54 24 34 11 54 24 2C 8B 44 24 70 01 44 24 28 8B 54 24 74 11 54 24 2C 8B 44 24 2C 39 C2 72 16 77 0A 8B 54 24 28 39 54 24 70 76 0A 83 44 24 38 01 83 54 24 3C 00 8B 44 24 18 F7 64 24 58 C7 44 24 34 00 00 00 00 89 44 24 48 8B 44 24 18 89 54 24 4C F7 64 24 40 89 44 24 70 8B 44 24 08 89 54 24 74 F7 64 24 58 89 54 24 5C 8B 54 24 48 89 44 24 58 89 54 24 30 8B 54 24 5C 89 D0 31 D2 89 44 24 50 8B 44 24 08 89 54 24 54 F7 64 24 40 01 44 24 50 8B 44 24 30 11 54 24 54 01 44 24 50 8B 54 24 34 11 54 24 54 8B 54 24 4C 89 D0 31 D2 89 44 24 48 8B 44 24 70 01 44 24 48 89 54 24 4C 8B 54 24 74 11 54 24 4C 8B 54 24 54 C7 44 24 74 00 00 00 00 89 D0 31 D2 01 44 24 48 8B 44 24 18 11 54 24 4C F7 64 24 60 89 44 24 30 8B 44 24 18 89 54 24 34 F7 E1 89 44 24 18 8B 44 24 08 89 54 24 1C F7 64 24 60 89 54 24 64 8B 54 24 30 89 44 24 60 89 54 24 70 8B 54 24 64 89 D0 31 D2 89 44 24 40 8B 44 24 08 89 54 24 44 F7 E1 01 44 24 40 11 54 24 44 8B 54 24 70 01 54 24 40 8B 54 24 34 8B 4C 24 74 11 4C 24 44 8B 4C 24 1C 89 D0 31 D2 89 54 24 34 8B 54 24 18 89 44 24 30 01 54 24 30 8B 54 24 44 11 4C 24 34 89 D0 31 D2 01 44 24 30 8B 44 24 40 11 54 24 34 89 C2 31 C0 89 44 24 40 8B 44 24 60 89 54 24 44 31 D2 01 44 24 40 11 54 24 44 8B 54 24 50 89 D1 31 D2 89 54 24 18 8B 44 24 58 31 D2 01 44 24 18 8B 44 24 30 89 4C 24 1C 11 54 24 1C 8B 54 24 34 01 44 24 18 11 54 24 1C 8B 4C 24 1C 39 CA 72 14 77 08 8B 54 24 18 39 D0 76 0A 83 44 24 48 01 83 54 24 4C 00 8B 44 24 28 8B 54 24 2C 03 44 24 40 13 54 24 44 39 54 24 44 89 44 24 28 89 54 24 2C C7 44 24 08 01 00 00 00 C7 44 24 0C 00 00 00 00 77 18 72 06 39 44 24 40 77 10 C7 44 24 08 00 00 00 00 C7 44 24 0C 00 00 00 00 8B 54 24 18 03 54 24 08 8B 4C 24 1C 13 4C 24 0C 89 54 24 30 8B 44 24 38 8B 54 24 3C 03 44 24 30 89 4C 24 34 13 54 24 34 89 44 24 38 39 D1 89 54 24 3C 0F 87 FF 0A 00 00 72 0A 39 44 24 30 0F 87 F3 0A 00 00 8B 4C 24 34 31 D2 B8 01 00 00 00 39 4C 24 0C 77 10 72 0A 8B 4C 24 30 39 4C 24 08 77 04 31 C0 31 D2 03 44 24 48 13 54 24 4C 89 D1 09 C1 75 5E 8B 44 24 3C 0B 44 24 38 75 54 8B 54 24 68 8B 44 24 78 89 D1 31 D2 89 54 24 68 31 D2 01 44 24 68 8B 44 24 10 89 4C 24 6C 11 54 24 6C 8B 54 24 20 33 54 24 2C 33 44 24 28 09 C2 0F 84 E2 0A 00 00 8B 44 24 2C 39 44 24 20 72 14 0F 87 3D 03 00 00 8B 54 24 28 39 54 24 10 0F 83 2F 03 00 00 BA 01 00 00 00 89 D8 C1 E8 1F 31 D0 EB 21 81 E1 00 00 00 7E 81 F9 00 00 00 7E 74 3B 81 E3 00 00 00 7E B8 01 00 00 00 81 FB 00 00 00 7E 74 28 8B 9C 24 AC 00 00 00 8B B4 24 B0 00 00 00 8B BC 24 B4 00 00 00 8B AC 24 B8 00 00 00 81 C4 BC 00 00 00 C3 90 8D 74 26 00 83 0D ?? ?? ?? ?? 01 B8 01 00 00 00 EB CA 66 90 8B 44 24 10 89 DA 33 44 24 08 31 CA 09 C2 0F 85 F6 F9 FF FF 31 C0 EB B0 72 0E 81 7C 24 08 C0 87 AD BE 0F 87 1C FA FF FF 8B 54 24 18 8B 44 24 08 81 F2 09 ED 01 00 35 C0 87 AD BE 09 C2 0F 84 8D 02 00 00 89 C8 25 00 00 00 60 3D 00 00 00 60 0F 94 44 24 28 E9 F0 F9 FF FF 8D B4 26 00 00 00 00 8B 54 24 20 8B 44 24 10 81 F2 09 ED 01 00 35 C0 87 AD BE 09 C2 0F 84 6B 02 00 00 89 D8 25 00 00 00 60 3D 00 00 00 60 0F 94 44 24 30 E9 E5 F9 FF FF 8B 04 24 09 F8 0F 85 12 FA FF FF 31 C0 84 D2 0F 85 22 FF FF FF 84 D2 75 0C 89 C8 F7 D0 C1 E8 1F E9 12 FF FF FF 89 D8 C1 E8 1F E9 08 FF FF FF 85 C9 0F 88 4C FF FF FF 89 DA B8 01 00 00 00 81 E2 00 00 00 78 C1 EB 1F 81 FA 00 00 00 78 0F 44 C3 E9 E2 FE FF FF 8B 5C 24 20 39 5C 24 18 77 14 0F 82 7F 02 00 00 8B 5C 24 10 39 5C 24 08 0F 86 71 02 00 00 BA 01 00 00 00 89 C8 C1 E8 1F 31 D0 E9 B3 FE FF FF 8B 0C C5 ?? ?? ?? ?? 8B 04 C5 ?? ?? ?? ?? C7 44 24 4C 00 00 00 00 89 44 24 40 F7 64 24 10 89 44 24 28 8B 44 24 40 89 54 24 2C F7 64 24 20 89 44 24 30 8B 44 24 10 89 54 24 34 F7 E1 89 54 24 14 8B 54 24 28 89 44 24 10 89 54 24 48 8B 54 24 14 89 D0 31 D2 89 44 24 38 8B 44 24 48 01 44 24 38 8B 44 24 20 89 54 24 3C 8B 54 24 4C 11 54 24 3C F7 E1 01 44 24 38 11 54 24 3C 8B 54 24 2C 89 D0 31 D2 89 44 24 28 8B 44 24 30 01 44 24 28 89 54 24 2C 8B 54 24 34 11 54 24 2C 8B 54 24 3C C7 44 24 4C 00 00 00 00 89 D0 31 D2 01 44 24 28 8B 44 24 40 11 54 24 2C F7 24 24 89 44 24 20 8B 44 24 40 89 54 24 24 F7 E7 89 44 24 40 8B 04 24 89 54 24 44 F7 E1 89 54 24 04 8B 54 24 20 89 04 24 89 54 24 48 8B 54 24 04 89 D0 31 D2 89 44 24 30 8B 44 24 48 01 44 24 30 89 C8 89 54 24 34 8B 54 24 4C 11 54 24 34 8B 4C 24 24 F7 E7 01 44 24 30 11 54 24 34 8B 44 24 40 89 CA 31 C9 89 54 24 20 8B 54 24 44 01 44 24 20 89 4C 24 24 8B 4C 24 10 11 54 24 24 8B 54 24 34 C7 44 24 3C 00 00 00 00 89 D0 31 D2 01 44 24 20 8B 44 24 38 11 54 24 24 89 4C 24 38 89 C2 31 C0 03 44 24 38 13 54 24 3C 03 44 24 20 13 54 24 24 39 54 24 24 72 12 77 06 39 44 24 20 76 0A 83 44 24 28 01 83 54 24 2C 00 8B 4C 24 2C 0B 4C 24 28 75 2A 8B 7C 24 18 8B 4C 24 08 31 D7 31 C1 09 CF 0F 84 D9 07 00 00 39 54 24 18 0F 87 DD FC FF FF 72 0A 39 44 24 08 0F 87 D1 FC FF FF 31 D2 E9 CF FC FF FF 90 81 FE 63 8E 8D 37 C6 44 24 28 01 0F 87 68 F7 FF FF E9 5D FD FF FF 81 FF 63 8E 8D 37 C6 44 24 30 01 0F 87 7F F7 FF FF E9 7F FD FF FF 77 0E 8B 54 24 10 39 54 24 08 0F 82 E4 F7 FF FF 39 F7 76 27 8B 54 24 20 39 54 24 18 0F 82 DD F7 FF FF 0F 87 E2 F7 FF FF 8B 54 24 10 39 54 24 08 0F 86 C9 F7 FF FF E9 CF F7 FF FF 72 09 39 2C 24 8D 74 26 00 77 CE 39 44 24 30 0F 8F 5E FD FF FF 8B 54 24 20 39 54 24 18 0F 87 AC F7 FF FF 0F 82 90 F7 FF FF 8B 54 24 10 39 54 24 08 0F 87 98 F7 FF FF 66 90 E9 7B F7 FF FF 8B 54 24 18 8B 44 24 08 33 54 24 20 33 44 24 10 09 C2 74 07 31 D2 E9 79 FD FF FF 39 F7 77 F5 0F 82 6A FD FF FF 39 2C 24 8D 76 00 0F 86 5E FD FF FF 31 D2 E9 5C FD FF FF 8D 76 00 2B 44 24 30 83 F8 21 0F 8F 38 06 00 00 83 F8 13 0F 8E 4F FD FF FF 8D 58 EC C1 E3 04 8B 83 ?? ?? ?? ?? 8B 93 ?? ?? ?? ?? C7 44 24 54 00 00 00 00 89 44 24 48 89 54 24 40 F7 E7 89 44 24 38 8B 44 24 40 89 54 24 3C F7 E7 89 44 24 58 8B 44 24 48 89 54 24 5C F7 24 24 89 54 24 34 8B 54 24 38 89 44 24 30 89 54 24 50 8B 54 24 34 89 D0 31 D2 89 44 24 28 8B 44 24 50 01 44 24 28 8B 44 24 40 89 54 24 2C 8B 54 24 54 11 54 24 2C F7 24 24 01 44 24 28 11 54 24 2C 8B 54 24 3C 89 D0 31 D2 89 44 24 38 8B 44 24 58 01 44 24 38 89 54 24 3C 8B 54 24 5C 11 54 24 3C 8B 54 24 2C C7 44 24 7C 00 00 00 00 89 D0 31 D2 01 44 24 38 11 54 24 3C 8B 93 ?? ?? ?? ?? 8B 9B ?? ?? ?? ?? 89 D0 89 54 24 58 F7 E7 89 44 24 60 89 D8 89 54 24 64 F7 E7 89 44 24 50 8B 44 24 58 89 54 24 54 F7 24 24 89 54 24 74 8B 54 24 60 89 44 24 70 89 54 24 78 8B 54 24 74 89 D0 31 D2 89 44 24 68 8B 44 24 78 89 54 24 6C 8B 54 24 7C 01 44 24 68 8B 04 24 11 54 24 6C C7 44 24 04 00 00 00 00 F7 E3 01 44 24 68 11 54 24 6C 8B 54 24 64 89 D0 31 D2 89 44 24 60 8B 44 24 50 01 44 24 60 89 54 24 64 8B 54 24 54 11 54 24 64 8B 54 24 6C 89 D0 31 D2 01 44 24 60 8B 44 24 28 11 54 24 64 89 C2 31 C0 89 54 24 2C 8B 54 24 30 89 44 24 28 89 14 24 8B 04 24 8B 54 24 04 01 44 24 28 8B 44 24 60 11 54 24 2C 01 44 24 28 8B 54 24 64 11 54 24 2C 8B 44 24 2C 39 C2 72 16 77 0A 8B 54 24 28 39 54 24 60 76 0A 83 44 24 38 01 83 54 24 3C 00 8B 44 24 20 F7 64 24 48 C7 44 24 04 00 00 00 00 89 44 24 30 8B 44 24 20 89 54 24 34 F7 64 24 40 89 44 24 50 8B 44 24 10 89 54 24 54 F7 64 24 48 89 54 24 4C 8B 54 24 30 89 44 24 48 89 14 24 8B 54 24 4C 89 D0 31 D2 89 44 24 60 8B 44 24 10 89 54 24 64 F7 64 24 40 01 44 24 60 8B 04 24 11 54 24 64 01 44 24 60 8B 54 24 04 11 54 24 64 8B 54 24 34 89 D0 31 D2 89 44 24 30 8B 44 24 50 01 44 24 30 89 54 24 34 8B 54 24 54 11 54 24 34 8B 54 24 64 C7 44 24 54 00 00 00 00 89 D0 31 D2 01 44 24 30 8B 44 24 20 11 54 24 34 F7 64 24 58 89 44 24 40 8B 44 24 20 89 54 24 44 F7 E3 89 44 24 20 8B 44 24 10 89 54 24 24 F7 64 24 58 89 54 24 5C 8B 54 24 40 89 44 24 58 89 54 24 50 8B 54 24 5C 89 D0 31 D2 89 04 24 8B 44 24 10 89 54 24 04 F7 E3 01 04 24 11 54 24 04 8B 44 24 50 01 04 24 8B 54 24 54 11 54 24 04 8B 54 24 44 89 D0 31 D2 89 44 24 40 8B 44 24 20 01 44 24 40 89 54 24 44 8B 54 24 24 11 54 24 44 8B 54 24 04 89 D0 31 D2 01 44 24 40 8B 04 24 11 54 24 44 89 C2 31 C0 89 04 24 8B 44 24 58 89 54 24 04 31 D2 01 04 24 8B 44 24 60 11 54 24 04 89 C2 31 C0 89 44 24 20 8B 44 24 48 89 54 24 24 31 D2 01 44 24 20 8B 44 24 40 11 54 24 24 8B 54 24 44 01 44 24 20 11 54 24 24 8B 5C 24 24 39 DA 72 14 77 08 8B 54 24 20 39 D0 76 0A 83 44 24 30 01 83 54 24 34 00 8B 44 24 28 8B 54 24 2C 03 04 24 13 54 24 04 39 54 24 04 89 44 24 28 89 54 24 2C C7 44 24 10 01 00 00 00 C7 44 24 14 00 00 00 00 77 17 72 05 39 04 24 77 10 C7 44 24 10 00 00 00 00 C7 44 24 14 00 00 00 00 8B 44 24 20 8B 54 24 24 03 44 24 10 13 54 24 14 89 44 24 20 8B 44 24 38 89 54 24 24 8B 54 24 3C 03 44 24 20 13 54 24 24 39 54 24 24 89 44 24 38 89 54 24 3C 0F 87 7B 02 00 00 72 0A 39 44 24 20 0F 87 6F 02 00 00 8B 5C 24 24 31 D2 B8 01 00 00 00 39 5C 24 14 77 10 72 0A 8B 5C 24 20 39 5C 24 10 77 04 31 C0 31 D2 03 44 24 30 13 54 24 34 89 D3 09 C3 0F 85 BA FB FF FF 8B 44 24 3C 0B 44 24 38 0F 85 AC FB FF FF 8B 5C 24 70 8B 44 24 68 C7 44 24 04 00 00 00 00 89 1C 24 8B 5C 24 2C 89 C2 31 C0 03 04 24 13 54 24 04 39 5C 24 18 0F 84 D4 02 00 00 8B 44 24 2C 39 44 24 18 0F 82 72 FB FF FF 0F 87 E7 F8 FF FF 8B 54 24 28 39 54 24 08 0F 87 D9 F8 FF FF 31 D2 E9 D7 F8 FF FF 8B 44 24 28 C7 44 24 4C 00 00 00 00 8B 14 C5 ?? ?? ?? ?? 8B 0C C5 ?? ?? ?? ?? 89 54 24 40 89 D0 F7 64 24 08 89 44 24 28 8B 44 24 40 89 54 24 2C F7 64 24 18 89 44 24 30 8B 44 24 08 89 54 24 34 F7 E1 89 54 24 0C 8B 54 24 28 89 44 24 08 89 54 24 48 8B 54 24 0C 89 D0 31 D2 89 44 24 38 8B 44 24 48 01 44 24 38 8B 44 24 18 89 54 24 3C 8B 54 24 4C 11 54 24 3C F7 E1 01 44 24 38 11 54 24 3C 8B 54 24 2C 89 D0 31 D2 89 44 24 28 8B 44 24 30 01 44 24 28 89 54 24 2C 8B 54 24 34 11 54 24 2C 8B 54 24 3C C7 44 24 54 00 00 00 00 89 D0 31 D2 01 44 24 28 8B 44 24 40 11 54 24 2C F7 E5 89 44 24 18 8B 44 24 40 89 54 24 1C F7 E6 89 44 24 40 89 C8 89 54 24 44 F7 E5 89 54 24 4C 8B 54 24 18 89 44 24 48 89 54 24 50 8B 54 24 4C 89 D0 31 D2 89 44 24 30 8B 44 24 50 01 44 24 30 89 C8 89 54 24 34 8B 54 24 54 11 54 24 34 8B 4C 24 1C F7 E6 01 44 24 30 11 54 24 34 8B 44 24 40 89 CA 31 C9 89 54 24 18 8B 54 24 44 01 44 24 18 89 4C 24 1C 8B 4C 24 08 11 54 24 1C 8B 54 24 34 C7 44 }
	condition:
		$1
}

rule file_45_4_0 {
	meta:
		name = "___bid128_quiet_less"
		size = 4592
		refs = "01f2 ___bid_ten2k128 06a3 ___bid_IDEC_glbflags 07bf ___bid_ten2k64"
	strings:
		$1 = { 81 EC BC 00 00 00 8B 8C 24 C8 00 00 00 89 9C 24 AC 00 00 00 8B 9C 24 D0 00 00 00 89 B4 24 B0 00 00 00 8B B4 24 C4 00 00 00 89 BC 24 B4 00 00 00 8B BC 24 D4 00 00 00 89 0C 24 8B 8C 24 CC 00 00 00 89 5C 24 08 8B 9C 24 D8 00 00 00 89 AC 24 B8 00 00 00 8B AC 24 C0 00 00 00 89 C8 25 00 00 00 7C 3D 00 00 00 7C 89 5C 24 10 8B 9C 24 DC 00 00 00 0F 84 E9 05 00 00 89 D8 25 00 00 00 7C 3D 00 00 00 7C 0F 84 D7 05 00 00 8B 44 24 08 89 FA 31 F2 31 E8 09 C2 0F 84 15 06 00 00 89 C8 25 00 00 00 78 3D 00 00 00 78 0F 84 B3 06 00 00 89 D8 25 00 00 00 78 3D 00 00 00 78 0F 84 C1 06 00 00 89 C8 25 FF FF 01 00 3D 09 ED 01 00 89 44 24 18 0F 86 F2 05 00 00 C6 44 24 20 01 89 DA 81 E2 FF FF 01 00 81 FA 09 ED 01 00 89 54 24 28 77 14 0F 82 12 06 00 00 81 7C 24 10 C0 87 AD BE 0F 86 04 06 00 00 C6 44 24 30 01 80 7C 24 20 00 BA 01 00 00 00 75 12 8B 44 24 18 31 D2 0B 04 24 75 07 89 EA 09 F2 0F 94 C2 80 7C 24 30 00 0F 85 13 06 00 00 8B 44 24 28 0B 44 24 10 0F 84 F9 05 00 00 84 D2 0F 85 3A 06 00 00 89 CA 31 DA 0F 88 30 06 00 00 89 CA 89 D8 C1 EA 11 C1 E8 11 81 E2 FF 3F 00 00 25 FF 3F 00 00 39 D0 89 44 24 20 0F 84 1B 06 00 00 8B 44 24 28 39 44 24 18 0F 87 27 08 00 00 72 0D 8B 44 24 10 39 04 24 0F 87 18 08 00 00 8B 44 24 18 33 44 24 28 89 44 24 30 8B 04 24 33 44 24 10 0B 44 24 30 0F 84 47 0D 00 00 8B 44 24 28 39 44 24 18 72 0B 77 13 8B 44 24 10 39 04 24 73 0A 3B 54 24 20 0F 8E F0 07 00 00 89 D0 2B 44 24 20 85 C0 0F 8E 6F 08 00 00 83 F8 21 0F 8F 70 05 00 00 83 F8 13 0F 8E D2 05 00 00 8D 48 EC C1 E1 04 8B 91 ?? ?? ?? ?? 8B 81 ?? ?? ?? ?? C7 44 24 54 00 00 00 00 89 54 24 58 89 44 24 40 89 D0 F7 E6 89 44 24 30 8B 44 24 40 89 54 24 34 F7 E6 89 44 24 38 8B 44 24 58 89 54 24 3C F7 E5 89 54 24 4C 8B 54 24 30 89 44 24 48 89 54 24 50 8B 54 24 4C 89 D0 31 D2 89 44 24 20 8B 44 24 50 01 44 24 20 8B 44 24 40 89 54 24 24 8B 54 24 54 11 54 24 24 F7 E5 01 44 24 20 11 54 24 24 8B 54 24 34 89 D0 31 D2 89 44 24 30 89 54 24 34 8B 44 24 38 01 44 24 30 8B 54 24 3C 11 54 24 34 8B 54 24 24 C7 44 24 74 00 00 00 00 89 D0 31 D2 01 44 24 30 11 54 24 34 8B 91 ?? ?? ?? ?? 8B 89 ?? ?? ?? ?? 89 D0 89 54 24 68 F7 E6 89 44 24 38 89 C8 89 54 24 3C F7 E6 89 44 24 50 8B 44 24 68 89 54 24 54 F7 E5 89 54 24 7C 8B 54 24 38 89 44 24 78 89 54 24 70 8B 54 24 7C 89 D0 31 D2 89 44 24 60 8B 44 24 70 01 44 24 60 89 C8 89 54 24 64 8B 54 24 74 11 54 24 64 F7 E5 01 44 24 60 11 54 24 64 8B 54 24 3C C7 44 24 3C 00 00 00 00 89 D0 31 D2 89 44 24 70 8B 44 24 50 01 44 24 70 89 54 24 74 8B 54 24 54 11 54 24 74 8B 54 24 64 89 D0 31 D2 01 44 24 70 8B 44 24 20 11 54 24 74 89 C2 31 C0 89 54 24 24 8B 54 24 48 89 44 24 20 89 54 24 38 8B 44 24 38 01 44 24 20 8B 54 24 3C 11 54 24 24 8B 44 24 70 01 44 24 20 8B 54 24 74 11 54 24 24 8B 44 24 24 39 C2 72 16 77 0A 8B 54 24 20 39 54 24 70 76 0A 83 44 24 30 01 83 54 24 34 00 8B 44 24 18 F7 64 24 58 C7 44 24 3C 00 00 00 00 89 44 24 48 8B 44 24 18 89 54 24 4C F7 64 24 40 89 44 24 70 8B 04 24 89 54 24 74 F7 64 24 58 89 54 24 5C 8B 54 24 48 89 44 24 58 89 54 24 38 8B 54 24 5C 89 D0 31 D2 89 44 24 50 8B 04 24 89 54 24 54 F7 64 24 40 01 44 24 50 8B 44 24 38 11 54 24 54 01 44 24 50 8B 54 24 3C 11 54 24 54 8B 54 24 4C 89 D0 31 D2 89 44 24 48 8B 44 24 70 01 44 24 48 89 54 24 4C 8B 54 24 74 11 54 24 4C 8B 54 24 54 C7 44 24 74 00 00 00 00 89 D0 31 D2 01 44 24 48 8B 44 24 18 11 54 24 4C F7 64 24 68 89 44 24 38 8B 44 24 18 89 54 24 3C F7 E1 89 44 24 18 8B 04 24 89 54 24 1C F7 64 24 68 89 54 24 6C 8B 54 24 38 89 44 24 68 89 54 24 70 8B 54 24 6C 89 D0 31 D2 89 44 24 40 8B 04 24 89 54 24 44 F7 E1 01 44 24 40 11 54 24 44 8B 54 24 70 01 54 24 40 8B 54 24 3C 8B 4C 24 74 11 4C 24 44 8B 4C 24 1C 89 D0 31 D2 89 54 24 3C 8B 54 24 18 89 44 24 38 01 54 24 38 8B 54 24 44 11 4C 24 3C 89 D0 31 D2 01 44 24 38 8B 44 24 40 11 54 24 3C 89 C2 31 C0 89 44 24 40 8B 44 24 68 89 54 24 44 31 D2 01 44 24 40 11 54 24 44 8B 54 24 50 89 D1 31 D2 89 54 24 18 8B 44 24 58 31 D2 01 44 24 18 8B 44 24 38 89 4C 24 1C 11 54 24 1C 8B 54 24 3C 01 44 24 18 11 54 24 1C 8B 4C 24 1C 39 CA 72 14 77 08 8B 54 24 18 39 D0 76 0A 83 44 24 48 01 83 54 24 4C 00 8B 44 24 20 8B 54 24 24 03 44 24 40 13 54 24 44 39 54 24 44 89 44 24 20 89 54 24 24 C7 04 24 01 00 00 00 C7 44 24 04 00 00 00 00 77 17 72 06 39 44 24 40 77 0F C7 04 24 00 00 00 00 C7 44 24 04 00 00 00 00 8B 54 24 18 03 14 24 8B 4C 24 1C 13 4C 24 04 89 54 24 38 8B 44 24 30 8B 54 24 34 03 44 24 38 89 4C 24 3C 13 54 24 3C 89 44 24 30 39 D1 89 54 24 34 0F 87 62 09 00 00 72 0A 39 44 24 38 0F 87 56 09 00 00 8B 4C 24 3C 31 D2 B8 01 00 00 00 39 4C 24 04 77 0F 72 09 8B 4C 24 38 39 0C 24 77 04 31 C0 31 D2 03 44 24 48 13 54 24 4C 89 D1 09 C1 75 5E 8B 44 24 34 0B 44 24 30 75 54 8B 54 24 60 8B 44 24 78 89 D1 31 D2 89 54 24 60 31 D2 01 44 24 60 8B 44 24 10 89 4C 24 64 11 54 24 64 8B 54 24 28 33 54 24 24 33 44 24 20 09 C2 0F 84 06 0B 00 00 8B 44 24 24 39 44 24 28 72 14 0F 87 2F 03 00 00 8B 54 24 20 39 54 24 10 0F 83 21 03 00 00 BA 01 00 00 00 89 D8 F7 D0 C1 E8 1F 31 D0 EB 21 8D 76 00 81 E1 00 00 00 7E 81 F9 00 00 00 7E 74 33 81 E3 00 00 00 7E 31 C0 81 FB 00 00 00 7E 74 23 8B 9C 24 AC 00 00 00 8B B4 24 B0 00 00 00 8B BC 24 B4 00 00 00 8B AC 24 B8 00 00 00 81 C4 BC 00 00 00 C3 83 0D ?? ?? ?? ?? 01 31 C0 EB D2 8D 74 26 00 8B 44 24 10 89 DA 33 04 24 31 CA 09 C2 0F 85 D8 F9 FF FF 31 C0 EB B7 72 0D 81 3C 24 C0 87 AD BE 0F 87 FF F9 FF FF 8B 54 24 18 8B 04 24 81 F2 09 ED 01 00 35 C0 87 AD BE 09 C2 0F 84 85 02 00 00 89 C8 25 00 00 00 60 3D 00 00 00 60 0F 94 44 24 20 E9 D4 F9 FF FF 8B 54 24 28 8B 44 24 10 81 F2 09 ED 01 00 35 C0 87 AD BE 09 C2 0F 84 6F 02 00 00 89 D8 25 00 00 00 60 3D 00 00 00 60 0F 94 44 24 30 E9 D0 F9 FF FF 8B 44 24 08 09 F8 0F 85 FB F9 FF FF 31 C0 84 D2 0F 85 31 FF FF FF 84 D2 75 2F 89 C8 C1 E8 1F E9 23 FF FF FF 90 8D 74 26 00 31 C0 85 C9 0F 89 14 FF FF FF 89 DA B0 01 81 E2 00 00 00 78 81 FA 00 00 00 78 0F 85 FE FE FF FF 89 D8 F7 D0 C1 E8 1F E9 F2 FE FF FF 8B 5C 24 28 39 5C 24 18 77 13 0F 82 74 02 00 00 8B 5C 24 10 39 1C 24 0F 86 67 02 00 00 BA 01 00 00 00 89 C8 F7 D0 C1 E8 1F 31 D0 E9 C2 FE FF FF 8B 0C C5 ?? ?? ?? ?? 8B 04 C5 ?? ?? ?? ?? C7 44 24 4C 00 00 00 00 89 44 24 40 F7 24 24 89 44 24 20 8B 44 24 40 89 54 24 24 F7 64 24 18 89 44 24 38 8B 04 24 89 54 24 3C F7 E1 89 54 24 04 8B 54 24 20 89 04 24 89 54 24 48 8B 54 24 04 89 D0 31 D2 89 44 24 30 8B 44 24 48 01 44 24 30 8B 44 24 18 89 54 24 34 8B 54 24 4C 11 54 24 34 F7 E1 01 44 24 30 11 54 24 34 8B 54 24 24 89 D0 31 D2 89 44 24 20 8B 44 24 38 01 44 24 20 89 54 24 24 8B 54 24 3C 11 54 24 24 8B 54 24 34 C7 44 24 54 00 00 00 00 89 D0 31 D2 01 44 24 20 8B 44 24 40 11 54 24 24 F7 E5 89 44 24 18 8B 44 24 40 89 54 24 1C F7 E6 89 44 24 40 89 C8 89 54 24 44 F7 E5 89 54 24 4C 8B 54 24 18 89 44 24 48 89 54 24 50 8B 54 24 4C 89 D0 31 D2 89 44 24 38 8B 44 24 50 01 44 24 38 89 C8 89 54 24 3C 8B 54 24 54 11 54 24 3C 8B 4C 24 1C F7 E6 01 44 24 38 11 54 24 3C 8B 44 24 40 89 CA 31 C9 89 54 24 18 8B 54 24 44 01 44 24 18 89 4C 24 1C 8B 0C 24 11 54 24 1C 8B 54 24 3C C7 44 24 34 00 00 00 00 89 D0 31 D2 01 44 24 18 8B 44 24 30 11 54 24 1C 89 4C 24 30 89 C2 31 C0 03 44 24 30 13 54 24 34 03 44 24 18 13 54 24 1C 39 54 24 1C 72 12 77 06 39 44 24 18 76 0A 83 44 24 20 01 83 54 24 24 00 8B 4C 24 24 0B 4C 24 20 0F 85 09 FD FF FF 8B 74 24 28 8B 4C 24 10 31 D6 31 C1 09 CE 0F 84 94 07 00 00 39 54 24 28 0F 82 EB FC FF FF 77 0A 39 44 24 10 0F 82 DF FC FF FF 31 D2 E9 DD FC FF FF 81 FE 63 8E 8D 37 C6 44 24 20 01 0F 87 54 F7 FF FF E9 65 FD FF FF 90 8D 74 26 00 81 FF 63 8E 8D 37 C6 44 24 30 01 0F 87 66 F7 FF FF E9 7B FD FF FF 3B 54 24 20 0F 8D A1 FD FF FF 8B 44 24 28 39 44 24 18 73 0C 89 C8 F7 D0 C1 E8 1F E9 B8 FC FF FF 77 09 8B 44 24 10 39 04 24 72 E9 8B 44 24 18 33 44 24 28 89 44 24 30 8B 04 24 33 44 24 10 0B 44 24 30 0F 85 DC F7 FF FF 39 F7 0F 82 D4 F7 FF FF 0F 87 C4 F7 FF FF 39 6C 24 08 0F 86 C4 F7 FF FF E9 B5 F7 FF FF 90 8D 74 26 00 8B 54 24 18 8B 04 24 33 54 24 28 33 44 24 10 09 C2 74 07 31 D2 E9 84 FD FF FF 39 F7 77 F5 66 90 0F 82 73 FD FF FF 39 6C 24 08 0F 86 69 FD FF FF 31 D2 E9 67 FD FF FF 8B 44 24 20 29 D0 83 F8 21 0F 8F 64 FF FF FF 83 F8 13 0F 8E C4 04 00 00 8D 58 EC C1 E3 04 8B 83 ?? ?? ?? ?? 8B 93 ?? ?? ?? ?? C7 44 24 54 00 00 00 00 89 44 24 48 89 54 24 38 F7 E7 89 44 24 30 8B 44 24 38 89 54 24 34 F7 E7 89 44 24 58 8B 44 24 48 89 54 24 5C F7 64 24 08 89 54 24 44 8B 54 24 30 89 44 24 40 89 54 24 50 8B 54 24 44 89 D0 31 D2 89 44 24 20 8B 44 24 50 01 44 24 20 8B 44 24 38 89 54 24 24 8B 54 24 54 11 54 24 24 F7 64 24 08 01 44 24 20 11 54 24 24 8B 54 24 34 89 D0 31 D2 89 44 24 30 8B 44 24 58 01 44 24 30 89 54 24 34 8B 54 24 5C 11 54 24 34 8B 54 24 24 C7 44 24 7C 00 00 00 00 89 D0 31 D2 01 44 24 30 11 54 24 34 8B 93 ?? ?? ?? ?? 8B 9B ?? ?? ?? ?? 89 D0 89 54 24 58 F7 E7 89 44 24 60 89 D8 89 54 24 64 F7 E7 89 44 24 50 8B 44 24 58 89 54 24 54 F7 64 24 08 89 54 24 74 8B 54 24 60 89 44 24 70 89 54 24 78 8B 54 24 74 89 D0 31 D2 89 44 24 68 8B 44 24 78 89 54 24 6C 8B 54 24 7C 01 44 24 68 8B 44 24 08 11 54 24 6C C7 44 24 0C 00 00 00 00 F7 E3 01 44 24 68 11 54 24 6C 8B 54 24 64 89 D0 31 D2 89 44 24 60 8B 44 24 50 01 44 24 60 89 54 24 64 8B 54 24 54 11 54 24 64 8B 54 24 6C 89 D0 31 D2 01 44 24 60 8B 44 24 20 11 54 24 64 89 C2 31 C0 89 54 24 24 8B 54 24 40 89 44 24 20 89 54 24 08 8B 44 24 08 8B 54 24 0C 01 44 24 20 8B 44 24 60 11 54 24 24 01 44 24 20 8B 54 24 64 11 54 24 24 8B 44 24 24 39 C2 72 16 77 0A 8B 54 24 20 39 54 24 60 76 0A 83 44 24 30 01 83 54 24 34 00 8B 44 24 28 F7 64 24 48 C7 44 24 0C 00 00 00 00 89 44 24 40 8B 44 24 28 89 54 24 44 F7 64 24 38 89 44 24 50 8B 44 24 10 89 54 24 54 F7 64 24 48 89 54 24 4C 8B 54 24 40 89 44 24 48 89 54 24 08 8B 54 24 4C 89 D0 31 D2 89 44 24 60 8B 44 24 10 89 54 24 64 F7 64 24 38 01 44 24 60 8B 44 24 08 11 54 24 64 01 44 24 60 8B 54 24 0C 11 54 24 64 8B 54 24 44 89 D0 31 D2 89 44 24 40 8B 44 24 50 01 44 24 40 89 54 24 44 8B 54 24 54 11 54 24 44 8B 54 24 64 C7 44 24 54 00 00 00 00 89 D0 31 D2 01 44 24 40 8B 44 24 28 11 54 24 44 F7 64 24 58 89 44 24 38 8B 44 24 28 89 54 24 3C F7 E3 89 44 24 28 8B 44 24 10 89 54 24 2C F7 64 24 58 89 54 24 5C 8B 54 24 38 89 44 24 58 89 54 24 50 8B 54 24 5C 89 D0 31 D2 89 44 24 08 8B 44 24 10 89 54 24 0C F7 E3 01 44 24 08 11 54 24 0C 8B 44 24 50 01 44 24 08 8B 54 24 54 11 54 24 0C 8B 54 24 3C 89 D0 31 D2 89 44 24 38 8B 44 24 28 01 44 24 38 89 54 24 3C 8B 54 24 2C 11 54 24 3C 8B 54 24 0C 89 D0 31 D2 01 44 24 38 8B 44 24 08 11 54 24 3C 89 C2 31 C0 89 44 24 08 8B 44 24 58 89 54 24 0C 31 D2 01 44 24 08 8B 44 24 60 11 54 24 0C 89 C2 31 C0 89 44 24 28 8B 44 24 48 89 54 24 2C 31 D2 01 44 24 28 8B 44 24 38 11 54 24 2C 8B 54 24 3C 01 44 24 28 11 54 24 2C 8B 5C 24 2C 39 DA 72 14 77 08 8B 54 24 28 39 D0 76 0A 83 44 24 40 01 83 54 24 44 00 8B 44 24 20 8B 54 24 24 03 44 24 08 13 54 24 0C 39 54 24 0C 89 44 24 20 89 54 24 24 C7 44 24 10 01 00 00 00 C7 44 24 14 00 00 00 00 77 18 72 06 39 44 24 08 77 10 C7 44 24 10 00 00 00 00 C7 44 24 14 00 00 00 00 8B 44 24 28 8B 54 24 2C 03 44 24 10 13 54 24 14 89 44 24 28 8B 44 24 30 89 54 24 2C 8B 54 24 34 03 44 24 28 13 54 24 2C 39 54 24 2C 89 44 24 30 89 54 24 34 0F 87 A7 02 00 00 72 0A 39 44 24 28 0F 87 9B 02 00 00 8B 5C 24 2C 31 D2 B8 01 00 00 00 39 5C 24 14 77 10 72 0A 8B 5C 24 28 39 5C 24 10 77 04 31 C0 31 D2 03 44 24 40 13 54 24 44 89 D3 09 C3 75 49 8B 44 24 34 0B 44 24 30 75 3F 8B 5C 24 70 8B 44 24 68 C7 44 24 0C 00 00 00 00 89 5C 24 08 8B 5C 24 24 89 C2 31 C0 03 44 24 08 13 54 24 0C 39 5C 24 18 74 26 8B 44 24 24 39 44 24 18 72 0B 77 35 8B 54 24 20 39 14 24 73 2C BA 01 00 00 00 89 C8 C1 E8 1F 31 D0 E9 B0 F7 FF FF 8B 5C 24 20 39 1C 24 75 D1 39 F2 0F 84 FF 02 00 00 39 F2 72 06 77 D8 39 E8 77 D4 31 D2 90 8D 74 26 00 EB D0 39 F7 73 0F 3B 54 24 20 0F 8C EE FA FF FF E9 4C F8 FF FF 0F 87 B5 F2 FF FF 39 6C 24 08 90 72 E4 E9 D7 FA FF FF B8 01 00 00 00 31 D2 E9 BE F6 FF FF 8B 0C C5 ?? ?? ?? ?? 8B 04 C5 ?? ?? ?? ?? C7 44 24 4C 00 00 00 00 89 44 24 40 F7 64 24 10 89 44 24 20 8B 44 24 40 89 54 24 24 F7 64 24 28 89 44 24 38 8B 44 24 10 89 54 24 3C F7 E1 89 54 24 14 8B 54 24 20 89 44 24 10 89 54 24 48 8B 54 24 14 89 D0 31 D2 89 44 24 30 8B 44 24 48 01 44 24 30 8B 44 24 28 89 54 24 34 8B 54 24 4C 11 54 24 34 F7 E1 01 44 24 30 11 54 24 34 8B 54 24 24 89 D0 31 D2 89 44 24 20 8B 44 24 38 01 44 24 20 89 54 24 24 8B 54 24 3C 11 54 24 24 8B 54 24 34 C7 44 24 4C 00 00 00 00 89 D0 31 D2 01 44 24 20 8B 44 24 40 11 54 24 24 F7 64 24 08 89 44 24 28 8B 44 24 40 89 54 24 2C F7 E7 89 44 24 40 8B 44 24 08 89 54 24 44 F7 E1 89 54 24 0C 8B 54 24 }
	condition:
		$1
}

rule file_45_5_0 {
	meta:
		name = "___bid128_quiet_less_equal"
		size = 4624
		refs = "01f2 ___bid_ten2k128 06a3 ___bid_IDEC_glbflags 07d5 ___bid_ten2k64"
	strings:
		$1 = { 81 EC BC 00 00 00 8B 8C 24 C8 00 00 00 89 9C 24 AC 00 00 00 8B 9C 24 D0 00 00 00 89 B4 24 B0 00 00 00 8B B4 24 C4 00 00 00 89 BC 24 B4 00 00 00 8B BC 24 D4 00 00 00 89 0C 24 8B 8C 24 CC 00 00 00 89 5C 24 08 8B 9C 24 D8 00 00 00 89 AC 24 B8 00 00 00 8B AC 24 C0 00 00 00 89 C8 25 00 00 00 7C 3D 00 00 00 7C 89 5C 24 10 8B 9C 24 DC 00 00 00 0F 84 E9 05 00 00 89 D8 25 00 00 00 7C 3D 00 00 00 7C 0F 84 D7 05 00 00 8B 44 24 08 89 FA 31 F2 31 E8 09 C2 0F 84 15 06 00 00 89 C8 25 00 00 00 78 3D 00 00 00 78 0F 84 C7 06 00 00 89 D8 25 00 00 00 78 3D 00 00 00 78 0F 84 A9 06 00 00 89 C8 25 FF FF 01 00 3D 09 ED 01 00 89 44 24 18 0F 86 FB 05 00 00 C6 44 24 20 01 89 DA 81 E2 FF FF 01 00 81 FA 09 ED 01 00 89 54 24 28 77 14 0F 82 1C 06 00 00 81 7C 24 10 C0 87 AD BE 0F 86 0E 06 00 00 C6 44 24 30 01 80 7C 24 20 00 BA 01 00 00 00 75 12 8B 44 24 18 31 D2 0B 04 24 75 07 89 EA 09 F2 0F 94 C2 80 7C 24 30 00 0F 85 1D 06 00 00 8B 44 24 28 0B 44 24 10 0F 84 03 06 00 00 84 D2 0F 85 22 06 00 00 89 CA 31 DA 0F 88 18 06 00 00 89 CA 89 D8 C1 EA 11 C1 E8 11 81 E2 FF 3F 00 00 25 FF 3F 00 00 39 D0 89 44 24 20 0F 84 31 06 00 00 8B 44 24 28 39 44 24 18 0F 87 41 08 00 00 72 0D 8B 44 24 10 39 04 24 0F 87 32 08 00 00 8B 44 24 18 33 44 24 28 89 44 24 30 8B 04 24 33 44 24 10 0B 44 24 30 0F 84 65 0D 00 00 8B 44 24 28 39 44 24 18 72 0B 77 13 8B 44 24 10 39 04 24 73 0A 3B 54 24 20 0F 8E 0A 08 00 00 89 D0 2B 44 24 20 85 C0 0F 8E 88 08 00 00 83 F8 21 0F 8F 7D 05 00 00 83 F8 13 0F 8E E8 05 00 00 8D 48 EC C1 E1 04 8B 91 ?? ?? ?? ?? 8B 81 ?? ?? ?? ?? C7 44 24 54 00 00 00 00 89 54 24 58 89 44 24 40 89 D0 F7 E6 89 44 24 30 8B 44 24 40 89 54 24 34 F7 E6 89 44 24 38 8B 44 24 58 89 54 24 3C F7 E5 89 54 24 4C 8B 54 24 30 89 44 24 48 89 54 24 50 8B 54 24 4C 89 D0 31 D2 89 44 24 20 8B 44 24 50 01 44 24 20 8B 44 24 40 89 54 24 24 8B 54 24 54 11 54 24 24 F7 E5 01 44 24 20 11 54 24 24 8B 54 24 34 89 D0 31 D2 89 44 24 30 89 54 24 34 8B 44 24 38 01 44 24 30 8B 54 24 3C 11 54 24 34 8B 54 24 24 C7 44 24 74 00 00 00 00 89 D0 31 D2 01 44 24 30 11 54 24 34 8B 91 ?? ?? ?? ?? 8B 89 ?? ?? ?? ?? 89 D0 89 54 24 68 F7 E6 89 44 24 38 89 C8 89 54 24 3C F7 E6 89 44 24 50 8B 44 24 68 89 54 24 54 F7 E5 89 54 24 7C 8B 54 24 38 89 44 24 78 89 54 24 70 8B 54 24 7C 89 D0 31 D2 89 44 24 60 8B 44 24 70 01 44 24 60 89 C8 89 54 24 64 8B 54 24 74 11 54 24 64 F7 E5 01 44 24 60 11 54 24 64 8B 54 24 3C C7 44 24 3C 00 00 00 00 89 D0 31 D2 89 44 24 70 8B 44 24 50 01 44 24 70 89 54 24 74 8B 54 24 54 11 54 24 74 8B 54 24 64 89 D0 31 D2 01 44 24 70 8B 44 24 20 11 54 24 74 89 C2 31 C0 89 54 24 24 8B 54 24 48 89 44 24 20 89 54 24 38 8B 44 24 38 01 44 24 20 8B 54 24 3C 11 54 24 24 8B 44 24 70 01 44 24 20 8B 54 24 74 11 54 24 24 8B 44 24 24 39 C2 72 16 77 0A 8B 54 24 20 39 54 24 70 76 0A 83 44 24 30 01 83 54 24 34 00 8B 44 24 18 F7 64 24 58 C7 44 24 3C 00 00 00 00 89 44 24 48 8B 44 24 18 89 54 24 4C F7 64 24 40 89 44 24 70 8B 04 24 89 54 24 74 F7 64 24 58 89 54 24 5C 8B 54 24 48 89 44 24 58 89 54 24 38 8B 54 24 5C 89 D0 31 D2 89 44 24 50 8B 04 24 89 54 24 54 F7 64 24 40 01 44 24 50 8B 44 24 38 11 54 24 54 01 44 24 50 8B 54 24 3C 11 54 24 54 8B 54 24 4C 89 D0 31 D2 89 44 24 48 8B 44 24 70 01 44 24 48 89 54 24 4C 8B 54 24 74 11 54 24 4C 8B 54 24 54 C7 44 24 74 00 00 00 00 89 D0 31 D2 01 44 24 48 8B 44 24 18 11 54 24 4C F7 64 24 68 89 44 24 38 8B 44 24 18 89 54 24 3C F7 E1 89 44 24 18 8B 04 24 89 54 24 1C F7 64 24 68 89 54 24 6C 8B 54 24 38 89 44 24 68 89 54 24 70 8B 54 24 6C 89 D0 31 D2 89 44 24 40 8B 04 24 89 54 24 44 F7 E1 01 44 24 40 11 54 24 44 8B 54 24 70 01 54 24 40 8B 54 24 3C 8B 4C 24 74 11 4C 24 44 8B 4C 24 1C 89 D0 31 D2 89 54 24 3C 8B 54 24 18 89 44 24 38 01 54 24 38 8B 54 24 44 11 4C 24 3C 89 D0 31 D2 01 44 24 38 8B 44 24 40 11 54 24 3C 89 C2 31 C0 89 44 24 40 8B 44 24 68 89 54 24 44 31 D2 01 44 24 40 11 54 24 44 8B 54 24 50 89 D1 31 D2 89 54 24 18 8B 44 24 58 31 D2 01 44 24 18 8B 44 24 38 89 4C 24 1C 11 54 24 1C 8B 54 24 3C 01 44 24 18 11 54 24 1C 8B 4C 24 1C 39 CA 72 14 77 08 8B 54 24 18 39 D0 76 0A 83 44 24 48 01 83 54 24 4C 00 8B 44 24 20 8B 54 24 24 03 44 24 40 13 54 24 44 39 54 24 44 89 44 24 20 89 54 24 24 C7 04 24 01 00 00 00 C7 44 24 04 00 00 00 00 77 17 72 06 39 44 24 40 77 0F C7 04 24 00 00 00 00 C7 44 24 04 00 00 00 00 8B 54 24 18 03 14 24 8B 4C 24 1C 13 4C 24 04 89 54 24 38 8B 44 24 30 8B 54 24 34 03 44 24 38 89 4C 24 3C 13 54 24 3C 89 44 24 30 39 D1 89 54 24 34 0F 87 82 09 00 00 72 0A 39 44 24 38 0F 87 76 09 00 00 8B 4C 24 3C 31 D2 B8 01 00 00 00 39 4C 24 04 77 0F 72 09 8B 4C 24 38 39 0C 24 77 04 31 C0 31 D2 03 44 24 48 13 54 24 4C 89 D1 09 C1 75 5E 8B 44 24 34 0B 44 24 30 75 54 8B 54 24 60 8B 44 24 78 89 D1 31 D2 89 54 24 60 31 D2 01 44 24 60 8B 44 24 10 89 4C 24 64 11 54 24 64 8B 54 24 28 33 54 24 24 33 44 24 20 09 C2 0F 84 26 0B 00 00 8B 44 24 24 39 44 24 28 72 14 0F 87 47 03 00 00 8B 54 24 20 39 54 24 10 0F 83 39 03 00 00 BA 01 00 00 00 89 D8 F7 D0 C1 E8 1F 31 D0 EB 21 8D 76 00 81 E1 00 00 00 7E 81 F9 00 00 00 7E 74 33 81 E3 00 00 00 7E 31 C0 81 FB 00 00 00 7E 74 23 8B 9C 24 AC 00 00 00 8B B4 24 B0 00 00 00 8B BC 24 B4 00 00 00 8B AC 24 B8 00 00 00 81 C4 BC 00 00 00 C3 83 0D ?? ?? ?? ?? 01 31 C0 EB D2 8D 74 26 00 8B 44 24 10 89 DA 33 04 24 31 CA 09 C2 0F 85 D8 F9 FF FF B8 01 00 00 00 EB B4 8D B6 00 00 00 00 72 0D 81 3C 24 C0 87 AD BE 0F 87 F6 F9 FF FF 8B 54 24 18 8B 04 24 81 F2 09 ED 01 00 35 C0 87 AD BE 09 C2 0F 84 97 02 00 00 89 C8 25 00 00 00 60 3D 00 00 00 60 0F 94 44 24 20 E9 CB F9 FF FF 90 8B 54 24 28 8B 44 24 10 81 F2 09 ED 01 00 35 C0 87 AD BE 09 C2 0F 84 7B 02 00 00 89 D8 25 00 00 00 60 3D 00 00 00 60 0F 94 44 24 30 E9 C6 F9 FF FF 8B 44 24 08 09 F8 0F 85 F1 F9 FF FF 84 D2 B8 01 00 00 00 0F 85 24 FF FF FF 84 D2 75 0A 89 C8 C1 E8 1F E9 16 FF FF FF 89 D8 F7 D0 C1 E8 1F E9 0A FF FF FF 85 C9 0F 88 47 FF FF FF 89 D8 25 00 00 00 78 3D 00 00 00 78 74 07 31 C0 E9 ED FE FF FF 85 DB B8 01 00 00 00 0F 89 E0 FE FF FF 66 90 EB E8 8B 5C 24 28 39 5C 24 18 77 13 0F 82 73 02 00 00 8B 5C 24 10 39 1C 24 0F 86 66 02 00 00 BA 01 00 00 00 89 C8 F7 D0 C1 E8 1F 31 D0 E9 AC FE FF FF 8B 0C C5 ?? ?? ?? ?? 8B 04 C5 ?? ?? ?? ?? C7 44 24 4C 00 00 00 00 89 44 24 40 F7 24 24 89 44 24 20 8B 44 24 40 89 54 24 24 F7 64 24 18 89 44 24 38 8B 04 24 89 54 24 3C F7 E1 89 54 24 04 8B 54 24 20 89 04 24 89 54 24 48 8B 54 24 04 89 D0 31 D2 89 44 24 30 8B 44 24 48 01 44 24 30 8B 44 24 18 89 54 24 34 8B 54 24 4C 11 54 24 34 F7 E1 01 44 24 30 11 54 24 34 8B 54 24 24 89 D0 31 D2 89 44 24 20 8B 44 24 38 01 44 24 20 89 54 24 24 8B 54 24 3C 11 54 24 24 8B 54 24 34 C7 44 24 54 00 00 00 00 89 D0 31 D2 01 44 24 20 8B 44 24 40 11 54 24 24 F7 E5 89 44 24 18 8B 44 24 40 89 54 24 1C F7 E6 89 44 24 40 89 C8 89 54 24 44 F7 E5 89 54 24 4C 8B 54 24 18 89 44 24 48 89 54 24 50 8B 54 24 4C 89 D0 31 D2 89 44 24 38 8B 44 24 50 01 44 24 38 89 C8 89 54 24 3C 8B 54 24 54 11 54 24 3C 8B 4C 24 1C F7 E6 01 44 24 38 11 54 24 3C 8B 44 24 40 89 CA 31 C9 89 54 24 18 8B 54 24 44 01 44 24 18 89 4C 24 1C 8B 0C 24 11 54 24 1C 8B 54 24 3C C7 44 24 34 00 00 00 00 89 D0 31 D2 01 44 24 18 8B 44 24 30 11 54 24 1C 89 4C 24 30 89 C2 31 C0 03 44 24 30 13 54 24 34 03 44 24 18 13 54 24 1C 39 54 24 1C 72 12 77 06 39 44 24 18 76 0A 83 44 24 20 01 83 54 24 24 00 8B 4C 24 24 0B 4C 24 20 0F 85 F3 FC FF FF 8B 74 24 28 8B 4C 24 10 31 D6 31 C1 09 CE 0F 84 9E 07 00 00 39 54 24 28 0F 82 D5 FC FF FF 77 0C 39 44 24 10 66 90 0F 82 C7 FC FF FF 31 D2 E9 C5 FC FF FF 8D 76 00 81 FE 63 8E 8D 37 C6 44 24 20 01 0F 87 39 F7 FF FF E9 53 FD FF FF 81 FF 63 8E 8D 37 C6 44 24 30 01 0F 87 50 F7 FF FF E9 6F FD FF FF 8D 74 26 00 3B 54 24 20 0F 8D 94 FD FF FF 8B 44 24 28 39 44 24 18 73 0C 89 C8 F7 D0 C1 E8 1F E9 9E FC FF FF 77 09 8B 44 24 10 39 04 24 72 E9 8B 44 24 18 33 44 24 28 89 44 24 30 8B 04 24 33 44 24 10 0B 44 24 30 0F 85 C2 F7 FF FF 39 F7 0F 82 BA F7 FF FF 0F 87 AA F7 FF FF 39 6C 24 08 0F 86 AA F7 FF FF E9 9B F7 FF FF 8B 54 24 18 8B 04 24 33 54 24 28 33 44 24 10 09 C2 74 07 31 D2 E9 85 FD FF FF 39 F7 77 F5 0F 82 76 FD FF FF 39 6C 24 08 8D 76 00 0F 86 69 FD FF FF 31 D2 E9 67 FD FF FF 8D 76 00 8B 44 24 20 29 D0 83 F8 21 0F 8F 65 FF FF FF 83 F8 13 0F 8E CB 04 00 00 8D 58 EC C1 E3 04 8B 83 ?? ?? ?? ?? 8B 93 ?? ?? ?? ?? C7 44 24 54 00 00 00 00 89 44 24 48 89 54 24 38 F7 E7 89 44 24 30 8B 44 24 38 89 54 24 34 F7 E7 89 44 24 58 8B 44 24 48 89 54 24 5C F7 64 24 08 89 54 24 44 8B 54 24 30 89 44 24 40 89 54 24 50 8B 54 24 44 89 D0 31 D2 89 44 24 20 8B 44 24 50 01 44 24 20 8B 44 24 38 89 54 24 24 8B 54 24 54 11 54 24 24 F7 64 24 08 01 44 24 20 11 54 24 24 8B 54 24 34 89 D0 31 D2 89 44 24 30 8B 44 24 58 01 44 24 30 89 54 24 34 8B 54 24 5C 11 54 24 34 8B 54 24 24 C7 44 24 7C 00 00 00 00 89 D0 31 D2 01 44 24 30 11 54 24 34 8B 93 ?? ?? ?? ?? 8B 9B ?? ?? ?? ?? 89 D0 89 54 24 58 F7 E7 89 44 24 60 89 D8 89 54 24 64 F7 E7 89 44 24 50 8B 44 24 58 89 54 24 54 F7 64 24 08 89 54 24 74 8B 54 24 60 89 44 24 70 89 54 24 78 8B 54 24 74 89 D0 31 D2 89 44 24 68 8B 44 24 78 89 54 24 6C 8B 54 24 7C 01 44 24 68 8B 44 24 08 11 54 24 6C C7 44 24 0C 00 00 00 00 F7 E3 01 44 24 68 11 54 24 6C 8B 54 24 64 89 D0 31 D2 89 44 24 60 8B 44 24 50 01 44 24 60 89 54 24 64 8B 54 24 54 11 54 24 64 8B 54 24 6C 89 D0 31 D2 01 44 24 60 8B 44 24 20 11 54 24 64 89 C2 31 C0 89 54 24 24 8B 54 24 40 89 44 24 20 89 54 24 08 8B 44 24 08 8B 54 24 0C 01 44 24 20 8B 44 24 60 11 54 24 24 01 44 24 20 8B 54 24 64 11 54 24 24 8B 44 24 24 39 C2 72 16 77 0A 8B 54 24 20 39 54 24 60 76 0A 83 44 24 30 01 83 54 24 34 00 8B 44 24 28 F7 64 24 48 C7 44 24 0C 00 00 00 00 89 44 24 40 8B 44 24 28 89 54 24 44 F7 64 24 38 89 44 24 50 8B 44 24 10 89 54 24 54 F7 64 24 48 89 54 24 4C 8B 54 24 40 89 44 24 48 89 54 24 08 8B 54 24 4C 89 D0 31 D2 89 44 24 60 8B 44 24 10 89 54 24 64 F7 64 24 38 01 44 24 60 8B 44 24 08 11 54 24 64 01 44 24 60 8B 54 24 0C 11 54 24 64 8B 54 24 44 89 D0 31 D2 89 44 24 40 8B 44 24 50 01 44 24 40 89 54 24 44 8B 54 24 54 11 54 24 44 8B 54 24 64 C7 44 24 54 00 00 00 00 89 D0 31 D2 01 44 24 40 8B 44 24 28 11 54 24 44 F7 64 24 58 89 44 24 38 8B 44 24 28 89 54 24 3C F7 E3 89 44 24 28 8B 44 24 10 89 54 24 2C F7 64 24 58 89 54 24 5C 8B 54 24 38 89 44 24 58 89 54 24 50 8B 54 24 5C 89 D0 31 D2 89 44 24 08 8B 44 24 10 89 54 24 0C F7 E3 01 44 24 08 11 54 24 0C 8B 44 24 50 01 44 24 08 8B 54 24 54 11 54 24 0C 8B 54 24 3C 89 D0 31 D2 89 44 24 38 8B 44 24 28 01 44 24 38 89 54 24 3C 8B 54 24 2C 11 54 24 3C 8B 54 24 0C 89 D0 31 D2 01 44 24 38 8B 44 24 08 11 54 24 3C 89 C2 31 C0 89 44 24 08 8B 44 24 58 89 54 24 0C 31 D2 01 44 24 08 8B 44 24 60 11 54 24 0C 89 C2 31 C0 89 44 24 28 8B 44 24 48 89 54 24 2C 31 D2 01 44 24 28 8B 44 24 38 11 54 24 2C 8B 54 24 3C 01 44 24 28 11 54 24 2C 8B 5C 24 2C 39 DA 72 14 77 08 8B 54 24 28 39 D0 76 0A 83 44 24 40 01 83 54 24 44 00 8B 44 24 20 8B 54 24 24 03 44 24 08 13 54 24 0C 39 54 24 0C 89 44 24 20 89 54 24 24 C7 44 24 10 01 00 00 00 C7 44 24 14 00 00 00 00 77 18 72 06 39 44 24 08 77 10 C7 44 24 10 00 00 00 00 C7 44 24 14 00 00 00 00 8B 44 24 28 8B 54 24 2C 03 44 24 10 13 54 24 14 89 44 24 28 8B 44 24 30 89 54 24 2C 8B 54 24 34 03 44 24 28 13 54 24 2C 39 54 24 2C 89 44 24 30 89 54 24 34 0F 87 AE 02 00 00 72 0A 39 44 24 28 0F 87 A2 02 00 00 8B 5C 24 2C 31 D2 B8 01 00 00 00 39 5C 24 14 77 10 72 0A 8B 5C 24 28 39 5C 24 10 77 04 31 C0 31 D2 03 44 24 40 13 54 24 44 89 D3 09 C3 75 49 8B 44 24 34 0B 44 24 30 75 3F 8B 5C 24 70 8B 44 24 68 C7 44 24 0C 00 00 00 00 89 5C 24 08 8B 5C 24 24 89 C2 31 C0 03 44 24 08 13 54 24 0C 39 5C 24 18 74 26 8B 44 24 24 39 44 24 18 72 0B 77 39 8B 54 24 20 39 14 24 73 30 BA 01 00 00 00 89 C8 C1 E8 1F 31 D0 E9 97 F7 FF FF 8B 5C 24 20 39 1C 24 75 D1 39 F2 0F 84 02 03 00 00 39 F2 72 0A 8D 74 26 00 77 D4 39 E8 77 D0 31 D2 EB D1 8D B6 00 00 00 00 39 F7 73 11 3B 54 24 20 0F 8C EA FA FF FF 66 90 E9 39 F8 FF FF 0F 87 95 F2 FF FF 39 6C 24 08 90 72 E2 E9 D1 FA FF FF B8 01 00 00 00 31 D2 E9 9E F6 FF FF 8B 0C C5 ?? ?? ?? ?? 8B 04 C5 ?? ?? ?? ?? C7 44 24 4C 00 00 00 00 89 44 24 40 F7 64 24 10 89 44 24 20 8B 44 24 40 89 54 24 24 F7 64 24 28 89 44 24 38 8B 44 24 10 89 54 24 3C F7 E1 89 54 24 14 8B 54 24 20 89 44 24 10 89 54 24 48 8B 54 24 14 89 D0 31 D2 89 44 24 30 8B 44 24 48 01 44 24 30 8B 44 24 28 89 54 24 34 8B 54 24 4C 11 54 24 34 F7 E1 01 44 24 30 11 54 24 34 8B 54 24 24 89 D0 31 D2 89 44 24 20 8B 44 24 38 01 44 24 20 89 54 24 24 8B 54 24 3C 11 54 24 24 8B 54 24 34 C7 44 24 4C 00 00 00 00 89 D0 31 D2 01 44 24 20 8B 44 24 40 11 54 24 24 F7 64 24 08 89 44 24 }
	condition:
		$1
}

rule file_45_6_0 {
	meta:
		name = "___bid128_quiet_less_unordered"
		size = 4608
		refs = "01f2 ___bid_ten2k128 06a6 ___bid_IDEC_glbflags 07c4 ___bid_ten2k64"
	strings:
		$1 = { 81 EC BC 00 00 00 8B 8C 24 C8 00 00 00 89 9C 24 AC 00 00 00 8B 9C 24 D0 00 00 00 89 B4 24 B0 00 00 00 8B B4 24 C4 00 00 00 89 BC 24 B4 00 00 00 8B BC 24 D4 00 00 00 89 0C 24 8B 8C 24 CC 00 00 00 89 5C 24 08 8B 9C 24 D8 00 00 00 89 AC 24 B8 00 00 00 8B AC 24 C0 00 00 00 89 C8 25 00 00 00 7C 3D 00 00 00 7C 89 5C 24 10 8B 9C 24 DC 00 00 00 0F 84 E9 05 00 00 89 D8 25 00 00 00 7C 3D 00 00 00 7C 0F 84 D7 05 00 00 8B 44 24 08 89 FA 31 F2 31 E8 09 C2 0F 84 17 06 00 00 89 C8 25 00 00 00 78 3D 00 00 00 78 0F 84 B8 06 00 00 89 D8 25 00 00 00 78 3D 00 00 00 78 0F 84 C6 06 00 00 89 C8 25 FF FF 01 00 3D 09 ED 01 00 89 44 24 18 0F 86 FB 05 00 00 C6 44 24 20 01 89 DA 81 E2 FF FF 01 00 81 FA 09 ED 01 00 89 54 24 28 77 14 0F 82 1C 06 00 00 81 7C 24 10 C0 87 AD BE 0F 86 0E 06 00 00 C6 44 24 30 01 80 7C 24 20 00 BA 01 00 00 00 75 12 8B 44 24 18 31 D2 0B 04 24 75 07 89 EA 09 F2 0F 94 C2 80 7C 24 30 00 0F 85 1D 06 00 00 8B 44 24 28 0B 44 24 10 0F 84 03 06 00 00 84 D2 0F 85 3F 06 00 00 89 CA 31 DA 0F 88 35 06 00 00 89 CA 89 D8 C1 EA 11 C1 E8 11 81 E2 FF 3F 00 00 25 FF 3F 00 00 39 D0 89 44 24 20 0F 84 20 06 00 00 8B 44 24 28 39 44 24 18 0F 87 31 08 00 00 72 0D 8B 44 24 10 39 04 24 0F 87 22 08 00 00 8B 44 24 18 33 44 24 28 89 44 24 30 8B 04 24 33 44 24 10 0B 44 24 30 0F 84 55 0D 00 00 8B 44 24 28 39 44 24 18 72 0B 77 13 8B 44 24 10 39 04 24 73 0A 3B 54 24 20 0F 8E FA 07 00 00 89 D0 2B 44 24 20 85 C0 0F 8E 78 08 00 00 83 F8 21 0F 8F 7A 05 00 00 83 F8 13 0F 8E D7 05 00 00 8D 48 EC C1 E1 04 8B 91 ?? ?? ?? ?? 8B 81 ?? ?? ?? ?? C7 44 24 54 00 00 00 00 89 54 24 58 89 44 24 40 89 D0 F7 E6 89 44 24 30 8B 44 24 40 89 54 24 34 F7 E6 89 44 24 38 8B 44 24 58 89 54 24 3C F7 E5 89 54 24 4C 8B 54 24 30 89 44 24 48 89 54 24 50 8B 54 24 4C 89 D0 31 D2 89 44 24 20 8B 44 24 50 01 44 24 20 8B 44 24 40 89 54 24 24 8B 54 24 54 11 54 24 24 F7 E5 01 44 24 20 11 54 24 24 8B 54 24 34 89 D0 31 D2 89 44 24 30 89 54 24 34 8B 44 24 38 01 44 24 30 8B 54 24 3C 11 54 24 34 8B 54 24 24 C7 44 24 74 00 00 00 00 89 D0 31 D2 01 44 24 30 11 54 24 34 8B 91 ?? ?? ?? ?? 8B 89 ?? ?? ?? ?? 89 D0 89 54 24 68 F7 E6 89 44 24 38 89 C8 89 54 24 3C F7 E6 89 44 24 50 8B 44 24 68 89 54 24 54 F7 E5 89 54 24 7C 8B 54 24 38 89 44 24 78 89 54 24 70 8B 54 24 7C 89 D0 31 D2 89 44 24 60 8B 44 24 70 01 44 24 60 89 C8 89 54 24 64 8B 54 24 74 11 54 24 64 F7 E5 01 44 24 60 11 54 24 64 8B 54 24 3C C7 44 24 3C 00 00 00 00 89 D0 31 D2 89 44 24 70 8B 44 24 50 01 44 24 70 89 54 24 74 8B 54 24 54 11 54 24 74 8B 54 24 64 89 D0 31 D2 01 44 24 70 8B 44 24 20 11 54 24 74 89 C2 31 C0 89 54 24 24 8B 54 24 48 89 44 24 20 89 54 24 38 8B 44 24 38 01 44 24 20 8B 54 24 3C 11 54 24 24 8B 44 24 70 01 44 24 20 8B 54 24 74 11 54 24 24 8B 44 24 24 39 C2 72 16 77 0A 8B 54 24 20 39 54 24 70 76 0A 83 44 24 30 01 83 54 24 34 00 8B 44 24 18 F7 64 24 58 C7 44 24 3C 00 00 00 00 89 44 24 48 8B 44 24 18 89 54 24 4C F7 64 24 40 89 44 24 70 8B 04 24 89 54 24 74 F7 64 24 58 89 54 24 5C 8B 54 24 48 89 44 24 58 89 54 24 38 8B 54 24 5C 89 D0 31 D2 89 44 24 50 8B 04 24 89 54 24 54 F7 64 24 40 01 44 24 50 8B 44 24 38 11 54 24 54 01 44 24 50 8B 54 24 3C 11 54 24 54 8B 54 24 4C 89 D0 31 D2 89 44 24 48 8B 44 24 70 01 44 24 48 89 54 24 4C 8B 54 24 74 11 54 24 4C 8B 54 24 54 C7 44 24 74 00 00 00 00 89 D0 31 D2 01 44 24 48 8B 44 24 18 11 54 24 4C F7 64 24 68 89 44 24 38 8B 44 24 18 89 54 24 3C F7 E1 89 44 24 18 8B 04 24 89 54 24 1C F7 64 24 68 89 54 24 6C 8B 54 24 38 89 44 24 68 89 54 24 70 8B 54 24 6C 89 D0 31 D2 89 44 24 40 8B 04 24 89 54 24 44 F7 E1 01 44 24 40 11 54 24 44 8B 54 24 70 01 54 24 40 8B 54 24 3C 8B 4C 24 74 11 4C 24 44 8B 4C 24 1C 89 D0 31 D2 89 54 24 3C 8B 54 24 18 89 44 24 38 01 54 24 38 8B 54 24 44 11 4C 24 3C 89 D0 31 D2 01 44 24 38 8B 44 24 40 11 54 24 3C 89 C2 31 C0 89 44 24 40 8B 44 24 68 89 54 24 44 31 D2 01 44 24 40 11 54 24 44 8B 54 24 50 89 D1 31 D2 89 54 24 18 8B 44 24 58 31 D2 01 44 24 18 8B 44 24 38 89 4C 24 1C 11 54 24 1C 8B 54 24 3C 01 44 24 18 11 54 24 1C 8B 4C 24 1C 39 CA 72 14 77 08 8B 54 24 18 39 D0 76 0A 83 44 24 48 01 83 54 24 4C 00 8B 44 24 20 8B 54 24 24 03 44 24 40 13 54 24 44 39 54 24 44 89 44 24 20 89 54 24 24 C7 04 24 01 00 00 00 C7 44 24 04 00 00 00 00 77 17 72 06 39 44 24 40 77 0F C7 04 24 00 00 00 00 C7 44 24 04 00 00 00 00 8B 54 24 18 03 14 24 8B 4C 24 1C 13 4C 24 04 89 54 24 38 8B 44 24 30 8B 54 24 34 03 44 24 38 89 4C 24 3C 13 54 24 3C 89 44 24 30 39 D1 89 54 24 34 0F 87 72 09 00 00 72 0A 39 44 24 38 0F 87 66 09 00 00 8B 4C 24 3C 31 D2 B8 01 00 00 00 39 4C 24 04 77 0F 72 09 8B 4C 24 38 39 0C 24 77 04 31 C0 31 D2 03 44 24 48 13 54 24 4C 89 D1 09 C1 75 5E 8B 44 24 34 0B 44 24 30 75 54 8B 54 24 60 8B 44 24 78 89 D1 31 D2 89 54 24 60 31 D2 01 44 24 60 8B 44 24 10 89 4C 24 64 11 54 24 64 8B 54 24 28 33 54 24 24 33 44 24 20 09 C2 0F 84 16 0B 00 00 8B 44 24 24 39 44 24 28 72 14 0F 87 37 03 00 00 8B 54 24 20 39 54 24 10 0F 83 29 03 00 00 BA 01 00 00 00 89 D8 F7 D0 C1 E8 1F 31 D0 EB 24 8D 76 00 81 E1 00 00 00 7E 81 F9 00 00 00 7E 74 36 81 E3 00 00 00 7E B8 01 00 00 00 81 FB 00 00 00 7E 74 23 8B 9C 24 AC 00 00 00 8B B4 24 B0 00 00 00 8B BC 24 B4 00 00 00 8B AC 24 B8 00 00 00 81 C4 BC 00 00 00 C3 83 0D ?? ?? ?? ?? 01 B8 01 00 00 00 EB CF 8B 44 24 10 89 DA 33 04 24 31 CA 09 C2 0F 85 D6 F9 FF FF 31 C0 EB B8 8D B4 26 00 00 00 00 72 0D 81 3C 24 C0 87 AD BE 0F 87 F6 F9 FF FF 8B 54 24 18 8B 04 24 81 F2 09 ED 01 00 35 C0 87 AD BE 09 C2 0F 84 87 02 00 00 89 C8 25 00 00 00 60 3D 00 00 00 60 0F 94 44 24 20 E9 CB F9 FF FF 90 8B 54 24 28 8B 44 24 10 81 F2 09 ED 01 00 35 C0 87 AD BE 09 C2 0F 84 6B 02 00 00 89 D8 25 00 00 00 60 3D 00 00 00 60 0F 94 44 24 30 E9 C6 F9 FF FF 8B 44 24 08 09 F8 0F 85 F1 F9 FF FF 31 C0 84 D2 0F 85 2A FF FF FF 84 D2 75 2A 89 C8 C1 E8 1F E9 1C FF FF FF 31 C0 85 C9 0F 89 12 FF FF FF 89 DA B0 01 81 E2 00 00 00 78 81 FA 00 00 00 78 0F 85 FC FE FF FF 89 D8 F7 D0 C1 E8 1F E9 F0 FE FF FF 8B 5C 24 28 39 5C 24 18 77 13 0F 82 74 02 00 00 8B 5C 24 10 39 1C 24 0F 86 67 02 00 00 BA 01 00 00 00 89 C8 F7 D0 C1 E8 1F 31 D0 E9 C0 FE FF FF 8B 0C C5 ?? ?? ?? ?? 8B 04 C5 ?? ?? ?? ?? C7 44 24 4C 00 00 00 00 89 44 24 40 F7 24 24 89 44 24 20 8B 44 24 40 89 54 24 24 F7 64 24 18 89 44 24 38 8B 04 24 89 54 24 3C F7 E1 89 54 24 04 8B 54 24 20 89 04 24 89 54 24 48 8B 54 24 04 89 D0 31 D2 89 44 24 30 8B 44 24 48 01 44 24 30 8B 44 24 18 89 54 24 34 8B 54 24 4C 11 54 24 34 F7 E1 01 44 24 30 11 54 24 34 8B 54 24 24 89 D0 31 D2 89 44 24 20 8B 44 24 38 01 44 24 20 89 54 24 24 8B 54 24 3C 11 54 24 24 8B 54 24 34 C7 44 24 54 00 00 00 00 89 D0 31 D2 01 44 24 20 8B 44 24 40 11 54 24 24 F7 E5 89 44 24 18 8B 44 24 40 89 54 24 1C F7 E6 89 44 24 40 89 C8 89 54 24 44 F7 E5 89 54 24 4C 8B 54 24 18 89 44 24 48 89 54 24 50 8B 54 24 4C 89 D0 31 D2 89 44 24 38 8B 44 24 50 01 44 24 38 89 C8 89 54 24 3C 8B 54 24 54 11 54 24 3C 8B 4C 24 1C F7 E6 01 44 24 38 11 54 24 3C 8B 44 24 40 89 CA 31 C9 89 54 24 18 8B 54 24 44 01 44 24 18 89 4C 24 1C 8B 0C 24 11 54 24 1C 8B 54 24 3C C7 44 24 34 00 00 00 00 89 D0 31 D2 01 44 24 18 8B 44 24 30 11 54 24 1C 89 4C 24 30 89 C2 31 C0 03 44 24 30 13 54 24 34 03 44 24 18 13 54 24 1C 39 54 24 1C 72 12 77 06 39 44 24 18 76 0A 83 44 24 20 01 83 54 24 24 00 8B 4C 24 24 0B 4C 24 20 0F 85 04 FD FF FF 8B 74 24 28 8B 4C 24 10 31 D6 31 C1 09 CE 0F 84 9F 07 00 00 39 54 24 28 0F 82 E6 FC FF FF 77 0D 39 44 24 10 8D 76 00 0F 82 D7 FC FF FF 31 D2 E9 D5 FC FF FF 8D 76 00 81 FE 63 8E 8D 37 C6 44 24 20 01 0F 87 49 F7 FF FF E9 63 FD FF FF 81 FF 63 8E 8D 37 C6 44 24 30 01 0F 87 60 F7 FF FF E9 7F FD FF FF 8D 74 26 00 3B 54 24 20 0F 8D A1 FD FF FF 8B 44 24 28 39 44 24 18 73 0C 89 C8 F7 D0 C1 E8 1F E9 B1 FC FF FF 77 09 8B 44 24 10 39 04 24 72 E9 8B 44 24 18 33 44 24 28 89 44 24 30 8B 04 24 33 44 24 10 0B 44 24 30 0F 85 D2 F7 FF FF 39 F7 0F 82 CA F7 FF FF 0F 87 BA F7 FF FF 39 6C 24 08 0F 86 BA F7 FF FF E9 AB F7 FF FF 8B 54 24 18 8B 04 24 33 54 24 28 33 44 24 10 09 C2 74 07 31 D2 E9 84 FD FF FF 39 F7 77 F5 0F 82 75 FD FF FF 39 6C 24 08 8D 76 00 0F 86 68 FD FF FF 31 D2 E9 66 FD FF FF 8D 76 00 8B 44 24 20 29 D0 83 F8 21 0F 8F 65 FF FF FF 83 F8 13 0F 8E CB 04 00 00 8D 58 EC C1 E3 04 8B 83 ?? ?? ?? ?? 8B 93 ?? ?? ?? ?? C7 44 24 54 00 00 00 00 89 44 24 48 89 54 24 38 F7 E7 89 44 24 30 8B 44 24 38 89 54 24 34 F7 E7 89 44 24 58 8B 44 24 48 89 54 24 5C F7 64 24 08 89 54 24 44 8B 54 24 30 89 44 24 40 89 54 24 50 8B 54 24 44 89 D0 31 D2 89 44 24 20 8B 44 24 50 01 44 24 20 8B 44 24 38 89 54 24 24 8B 54 24 54 11 54 24 24 F7 64 24 08 01 44 24 20 11 54 24 24 8B 54 24 34 89 D0 31 D2 89 44 24 30 8B 44 24 58 01 44 24 30 89 54 24 34 8B 54 24 5C 11 54 24 34 8B 54 24 24 C7 44 24 7C 00 00 00 00 89 D0 31 D2 01 44 24 30 11 54 24 34 8B 93 ?? ?? ?? ?? 8B 9B ?? ?? ?? ?? 89 D0 89 54 24 58 F7 E7 89 44 24 60 89 D8 89 54 24 64 F7 E7 89 44 24 50 8B 44 24 58 89 54 24 54 F7 64 24 08 89 54 24 74 8B 54 24 60 89 44 24 70 89 54 24 78 8B 54 24 74 89 D0 31 D2 89 44 24 68 8B 44 24 78 89 54 24 6C 8B 54 24 7C 01 44 24 68 8B 44 24 08 11 54 24 6C C7 44 24 0C 00 00 00 00 F7 E3 01 44 24 68 11 54 24 6C 8B 54 24 64 89 D0 31 D2 89 44 24 60 8B 44 24 50 01 44 24 60 89 54 24 64 8B 54 24 54 11 54 24 64 8B 54 24 6C 89 D0 31 D2 01 44 24 60 8B 44 24 20 11 54 24 64 89 C2 31 C0 89 54 24 24 8B 54 24 40 89 44 24 20 89 54 24 08 8B 44 24 08 8B 54 24 0C 01 44 24 20 8B 44 24 60 11 54 24 24 01 44 24 20 8B 54 24 64 11 54 24 24 8B 44 24 24 39 C2 72 16 77 0A 8B 54 24 20 39 54 24 60 76 0A 83 44 24 30 01 83 54 24 34 00 8B 44 24 28 F7 64 24 48 C7 44 24 0C 00 00 00 00 89 44 24 40 8B 44 24 28 89 54 24 44 F7 64 24 38 89 44 24 50 8B 44 24 10 89 54 24 54 F7 64 24 48 89 54 24 4C 8B 54 24 40 89 44 24 48 89 54 24 08 8B 54 24 4C 89 D0 31 D2 89 44 24 60 8B 44 24 10 89 54 24 64 F7 64 24 38 01 44 24 60 8B 44 24 08 11 54 24 64 01 44 24 60 8B 54 24 0C 11 54 24 64 8B 54 24 44 89 D0 31 D2 89 44 24 40 8B 44 24 50 01 44 24 40 89 54 24 44 8B 54 24 54 11 54 24 44 8B 54 24 64 C7 44 24 54 00 00 00 00 89 D0 31 D2 01 44 24 40 8B 44 24 28 11 54 24 44 F7 64 24 58 89 44 24 38 8B 44 24 28 89 54 24 3C F7 E3 89 44 24 28 8B 44 24 10 89 54 24 2C F7 64 24 58 89 54 24 5C 8B 54 24 38 89 44 24 58 89 54 24 50 8B 54 24 5C 89 D0 31 D2 89 44 24 08 8B 44 24 10 89 54 24 0C F7 E3 01 44 24 08 11 54 24 0C 8B 44 24 50 01 44 24 08 8B 54 24 54 11 54 24 0C 8B 54 24 3C 89 D0 31 D2 89 44 24 38 8B 44 24 28 01 44 24 38 89 54 24 3C 8B 54 24 2C 11 54 24 3C 8B 54 24 0C 89 D0 31 D2 01 44 24 38 8B 44 24 08 11 54 24 3C 89 C2 31 C0 89 44 24 08 8B 44 24 58 89 54 24 0C 31 D2 01 44 24 08 8B 44 24 60 11 54 24 0C 89 C2 31 C0 89 44 24 28 8B 44 24 48 89 54 24 2C 31 D2 01 44 24 28 8B 44 24 38 11 54 24 2C 8B 54 24 3C 01 44 24 28 11 54 24 2C 8B 5C 24 2C 39 DA 72 14 77 08 8B 54 24 28 39 D0 76 0A 83 44 24 40 01 83 54 24 44 00 8B 44 24 20 8B 54 24 24 03 44 24 08 13 54 24 0C 39 54 24 0C 89 44 24 20 89 54 24 24 C7 44 24 10 01 00 00 00 C7 44 24 14 00 00 00 00 77 18 72 06 39 44 24 08 77 10 C7 44 24 10 00 00 00 00 C7 44 24 14 00 00 00 00 8B 44 24 28 8B 54 24 2C 03 44 24 10 13 54 24 14 89 44 24 28 8B 44 24 30 89 54 24 2C 8B 54 24 34 03 44 24 28 13 54 24 2C 39 54 24 2C 89 44 24 30 89 54 24 34 0F 87 AE 02 00 00 72 0A 39 44 24 28 0F 87 A2 02 00 00 8B 5C 24 2C 31 D2 B8 01 00 00 00 39 5C 24 14 77 10 72 0A 8B 5C 24 28 39 5C 24 10 77 04 31 C0 31 D2 03 44 24 40 13 54 24 44 89 D3 09 C3 75 49 8B 44 24 34 0B 44 24 30 75 3F 8B 5C 24 70 8B 44 24 68 C7 44 24 0C 00 00 00 00 89 5C 24 08 8B 5C 24 24 89 C2 31 C0 03 44 24 08 13 54 24 0C 39 5C 24 18 74 26 8B 44 24 24 39 44 24 18 72 0B 77 39 8B 54 24 20 39 14 24 73 30 BA 01 00 00 00 89 C8 C1 E8 1F 31 D0 E9 AA F7 FF FF 8B 5C 24 20 39 1C 24 75 D1 39 F2 0F 84 06 03 00 00 39 F2 72 0A 8D 74 26 00 77 D4 39 E8 77 D0 31 D2 EB D1 8D B6 00 00 00 00 39 F7 73 11 3B 54 24 20 0F 8C EA FA FF FF 66 90 E9 46 F8 FF FF 0F 87 A5 F2 FF FF 39 6C 24 08 90 72 E2 E9 D1 FA FF FF B8 01 00 00 00 31 D2 E9 AE F6 FF FF 8B 0C C5 ?? ?? ?? ?? 8B 04 C5 ?? ?? ?? ?? C7 44 24 4C 00 00 00 00 89 44 24 40 F7 64 24 10 89 44 24 20 8B 44 24 40 89 54 24 24 F7 64 24 28 89 44 24 38 8B 44 24 10 89 54 24 3C F7 E1 89 54 24 14 8B 54 24 20 89 44 24 10 89 54 24 48 8B 54 24 14 89 D0 31 D2 89 44 24 30 8B 44 24 48 01 44 24 30 8B 44 24 28 89 54 24 34 8B 54 24 4C 11 54 24 34 F7 E1 01 44 24 30 11 54 24 34 8B 54 24 24 89 D0 31 D2 89 44 24 20 8B 44 24 38 01 44 24 20 89 54 24 24 8B 54 24 3C 11 54 24 24 8B 54 24 34 C7 44 24 4C 00 00 00 00 89 D0 31 D2 01 44 24 20 8B 44 24 40 11 54 24 24 F7 64 24 08 89 44 24 28 8B 44 24 40 89 54 24 2C F7 E7 89 44 24 40 8B }
	condition:
		$1
}

rule file_45_7_0 {
	meta:
		name = "___bid128_quiet_not_equal"
		size = 2064
		refs = "01f5 ___bid_ten2k128 0557 ___bid_IDEC_glbflags 06b9 ___bid_ten2k64"
	strings:
		$1 = { 81 EC AC 00 00 00 8B 94 24 B8 00 00 00 8B 84 24 B0 00 00 00 8B 8C 24 C0 00 00 00 89 9C 24 9C 00 00 00 8B 9C 24 C8 00 00 00 89 54 24 08 8B 94 24 BC 00 00 00 89 04 24 89 B4 24 A0 00 00 00 8B B4 24 C4 00 00 00 89 AC 24 A8 00 00 00 8B AC 24 B4 00 00 00 89 D0 25 00 00 00 7C 3D 00 00 00 7C 89 4C 24 18 8B 8C 24 CC 00 00 00 89 BC 24 A4 00 00 00 89 5C 24 38 0F 84 96 04 00 00 89 C8 25 00 00 00 7C 3D 00 00 00 7C 0F 84 84 04 00 00 8B 44 24 18 89 F7 33 04 24 31 EF 09 C7 0F 84 C3 04 00 00 89 D0 25 00 00 00 78 3D 00 00 00 78 0F 84 66 05 00 00 89 C8 25 00 00 00 78 3D 00 00 00 78 0F 84 7C 05 00 00 89 D7 81 E7 FF FF 01 00 81 FF 09 ED 01 00 89 7C 24 10 0F 86 A4 04 00 00 BF 01 00 00 00 8B 5C 24 38 89 5C 24 58 89 CB 81 E3 FF FF 01 00 81 FB 09 ED 01 00 89 5C 24 1C 77 14 0F 82 BE 04 00 00 81 7C 24 38 C0 87 AD BE 0F 86 B0 04 00 00 BB 01 00 00 00 89 F8 84 C0 0F 85 D5 04 00 00 8B 7C 24 10 0B 7C 24 08 0F 85 22 05 00 00 8B 04 24 09 E8 0F 94 C0 89 C7 88 44 24 20 84 DB 75 1A 8B 5C 24 1C 0B 5C 24 38 0F 85 B6 04 00 00 8B 44 24 18 09 F0 0F 85 AA 04 00 00 89 FB 31 C0 84 DB 0F 85 CC 03 00 00 80 7C 24 20 00 B0 01 0F 84 BF 03 00 00 89 D7 31 CF 0F 88 C3 04 00 00 C1 EA 11 C1 E9 11 81 E2 FF 3F 00 00 81 E1 FF 3F 00 00 89 D0 39 CA 0F 8F C7 04 00 00 8B 54 24 18 8B 5C 24 38 89 74 24 30 8B 3C 24 8B 74 24 1C 89 54 24 28 8B 54 24 10 89 6C 24 5C 8B 6C 24 08 89 5C 24 20 89 74 24 38 89 7C 24 18 89 6C 24 58 89 54 24 1C 29 C1 B8 01 00 00 00 83 F9 21 0F 8F 52 03 00 00 83 F9 13 0F 8E CD 04 00 00 83 E9 14 8B 44 24 30 C1 E1 04 8B 99 ?? ?? ?? ?? 8B B1 ?? ?? ?? ?? F7 E3 89 74 24 08 89 5C 24 40 89 04 24 8B 44 24 30 89 54 24 04 F7 E6 89 44 24 10 8B 44 24 28 89 54 24 14 F7 E3 8B 99 ?? ?? ?? ?? 89 54 24 64 8B 7C 24 64 31 D2 89 44 24 60 8B 04 24 89 FE 31 FF 01 C6 8B 44 24 28 11 D7 F7 64 24 08 01 C6 11 D7 8B 54 24 04 89 D0 31 D2 89 04 24 8B 44 24 10 01 04 24 89 54 24 04 8B 54 24 14 11 54 24 04 31 D2 01 3C 24 11 54 24 04 89 5C 24 48 8B 44 24 30 8B A9 ?? ?? ?? ?? F7 E3 89 44 24 10 8B 44 24 30 89 54 24 14 F7 E5 89 44 24 30 8B 44 24 28 89 54 24 34 F7 E3 89 54 24 6C 8B 5C 24 6C 31 D2 89 44 24 68 8B 44 24 10 89 D9 31 DB 89 4C 24 50 01 44 24 50 8B 44 24 28 89 5C 24 54 8B 5C 24 14 11 54 24 54 F7 E5 01 44 24 50 89 D9 11 54 24 54 31 DB 8B 54 24 54 03 4C 24 30 13 5C 24 34 89 74 24 14 89 D0 31 D2 01 C1 11 D3 31 C0 89 44 24 10 8B 44 24 60 31 D2 01 44 24 10 11 54 24 14 01 4C 24 10 11 5C 24 14 3B 5C 24 14 72 11 77 06 3B 4C 24 10 76 09 83 04 24 01 83 54 24 04 00 8B 44 24 38 F7 64 24 40 89 44 24 28 8B 44 24 38 89 54 24 2C 8B 5C 24 2C F7 64 24 08 89 D9 89 44 24 30 8B 44 24 20 89 54 24 34 F7 64 24 40 89 54 24 44 8B 7C 24 44 31 D2 89 44 24 40 8B 44 24 28 89 4C 24 28 8B 4C 24 30 89 FE 31 FF 01 C6 8B 44 24 20 11 D7 F7 64 24 08 01 C6 8B 44 24 38 11 D7 31 DB 89 5C 24 2C 8B 5C 24 34 01 4C 24 28 11 5C 24 2C 31 D2 01 7C 24 28 11 54 24 2C F7 64 24 48 89 44 24 08 8B 44 24 38 89 54 24 0C F7 E5 89 44 24 38 8B 44 24 20 89 54 24 3C F7 64 24 48 89 54 24 4C 8B 5C 24 4C 31 D2 89 44 24 48 8B 44 24 08 89 D9 31 DB 01 C1 8B 44 24 20 11 D3 F7 E5 01 C1 11 D3 8B 54 24 0C 89 D0 31 D2 89 44 24 08 8B 44 24 38 01 44 24 08 8B 44 24 48 89 54 24 0C 8B 54 24 3C 11 54 24 0C 31 D2 01 5C 24 08 89 CB 11 54 24 0C 31 C9 31 D2 01 C1 11 D3 89 F2 8B 74 24 40 31 C0 31 FF 01 F0 11 FA 03 44 24 08 13 54 24 0C 39 54 24 0C 72 12 77 06 39 44 24 08 76 0A 83 44 24 28 01 83 54 24 2C 00 8B 74 24 10 8B 7C 24 14 01 CE 11 DF 89 7C 24 14 31 FF 3B 5C 24 14 89 74 24 10 BE 01 00 00 00 77 0C 72 06 3B 4C 24 10 77 04 31 F6 31 FF 8B 0C 24 01 F0 8B 5C 24 04 11 FA 01 C1 11 D3 39 DA 89 0C 24 89 5C 24 04 0F 87 5F 03 00 00 72 08 39 C8 0F 87 55 03 00 00 31 DB 39 D7 B9 01 00 00 00 77 0A 72 04 39 C6 77 04 31 C9 31 DB 03 4C 24 28 B8 01 00 00 00 13 5C 24 2C 89 DE 09 CE 75 64 8B 7C 24 04 0B 3C 24 75 5B 8B 54 24 14 8B 4C 24 10 33 54 24 1C 33 4C 24 58 09 CA 75 47 8B 44 24 50 8B 4C 24 68 89 C2 31 C0 8B 74 24 5C 31 DB 01 C8 11 DA 33 44 24 18 31 D6 09 F0 0F 95 C0 0F B6 C0 EB 21 81 E2 00 00 00 7E 81 FA 00 00 00 7E 74 36 81 E1 00 00 00 7E B8 01 00 00 00 81 F9 00 00 00 7E 74 23 8B 9C 24 9C 00 00 00 8B B4 24 A0 00 00 00 8B BC 24 A4 00 00 00 8B AC 24 A8 00 00 00 81 C4 AC 00 00 00 C3 83 0D ?? ?? ?? ?? 01 B8 01 00 00 00 EB CF 8B 44 24 08 89 CF 33 44 24 38 31 D7 09 C7 0F 85 29 FB FF FF 31 C0 EB B7 90 8D 74 26 00 72 0E 81 7C 24 08 C0 87 AD BE 0F 87 4C FB FF FF 8B 7C 24 10 8B 44 24 08 81 F7 09 ED 01 00 35 C0 87 AD BE 09 C7 0F 84 F5 00 00 00 89 D0 25 00 00 00 60 3D 00 00 00 60 0F 94 C0 89 C7 E9 20 FB FF FF 8B 5C 24 1C 8B 44 24 38 81 F3 09 ED 01 00 35 C0 87 AD BE 09 D8 0F 84 AC 00 00 00 89 C8 25 00 00 00 60 3D 00 00 00 60 89 F8 0F 94 C3 84 C0 0F 84 2B FB FF FF BF 01 00 00 00 C6 44 24 20 01 E9 38 FB FF FF 89 FB B8 01 00 00 00 84 DB 0F 85 1F FF FF FF E9 5B FB FF FF 89 CB B8 01 00 00 00 81 E3 00 00 00 78 81 FB 00 00 00 78 0F 85 01 FF FF FF 89 D0 31 C8 C1 E8 1F E9 F5 FE FF FF 8D 76 00 B8 01 00 00 00 E9 E8 FE FF FF 8D B6 00 00 00 00 31 FF C6 44 24 20 00 E9 E0 FA FF FF 8D 74 26 00 8B 1C 24 89 C8 89 D1 89 6C 24 30 8B 7C 24 08 8B 6C 24 10 89 74 24 5C 89 5C 24 28 89 7C 24 20 89 6C 24 38 E9 48 FB FF FF 81 FE 63 8E 8D 37 BB 01 00 00 00 0F 87 7D FA FF FF E9 3E FF FF FF 66 90 81 FD 63 8E 8D 37 BF 01 00 00 00 0F 87 30 FA FF FF E9 F5 FE FF FF 8B 3C CD ?? ?? ?? ?? 8B 44 24 20 8B 34 CD ?? ?? ?? ?? F7 E7 89 04 24 8B 44 24 38 89 54 24 04 F7 E7 89 44 24 08 8B 44 24 20 89 54 24 0C F7 E6 89 54 24 24 8B 5C 24 24 31 D2 89 44 24 20 8B 04 24 89 D9 31 DB 01 C1 8B 44 24 38 11 D3 F7 E6 01 C1 11 D3 8B 54 24 04 89 D0 31 D2 89 04 24 8B 44 24 08 01 04 24 8B 44 24 28 89 54 24 04 8B 54 24 0C 11 54 24 04 31 D2 01 1C 24 89 CB 11 54 24 04 F7 E7 89 44 24 10 8B 44 24 30 89 54 24 14 F7 E7 89 44 24 38 8B 44 24 28 89 54 24 3C F7 E6 89 54 24 2C 8B 6C 24 2C 31 D2 89 44 24 28 8B 44 24 10 89 EF 31 ED 89 7C 24 08 8B 7C 24 14 01 44 24 08 8B 44 24 30 89 6C 24 0C 11 54 24 0C F7 E6 89 FE 01 44 24 08 11 54 24 0C 31 FF 8B 54 24 0C 03 74 24 38 13 7C 24 3C 89 D0 31 D2 01 C6 8B 44 24 20 11 D7 31 C9 31 D2 01 C1 11 D3 01 F1 11 FB 39 DF 72 0F 77 04 39 CE 76 09 83 04 24 01 83 54 24 04 00 8B 54 24 04 B8 01 00 00 00 0B 14 24 0F 85 5A FD FF FF 8B 54 24 1C 33 4C 24 58 31 DA 09 CA 0F 85 48 FD FF FF 8B 44 24 08 8B 4C 24 28 89 C2 31 C0 E9 FC FC FF FF B9 01 00 00 00 31 DB E9 B4 FC FF FF 89 F6 8D BC 27 00 00 00 00 }
	condition:
		$1
}

rule file_45_8_0 {
	meta:
		name = "___bid128_quiet_not_greater"
		size = 4624
		refs = "01f2 ___bid_ten2k128 06a6 ___bid_IDEC_glbflags 07d5 ___bid_ten2k64"
	strings:
		$1 = { 81 EC BC 00 00 00 8B 8C 24 C8 00 00 00 89 9C 24 AC 00 00 00 8B 9C 24 D0 00 00 00 89 B4 24 B0 00 00 00 8B B4 24 C4 00 00 00 89 BC 24 B4 00 00 00 8B BC 24 D4 00 00 00 89 0C 24 8B 8C 24 CC 00 00 00 89 5C 24 08 8B 9C 24 D8 00 00 00 89 AC 24 B8 00 00 00 8B AC 24 C0 00 00 00 89 C8 25 00 00 00 7C 3D 00 00 00 7C 89 5C 24 10 8B 9C 24 DC 00 00 00 0F 84 E9 05 00 00 89 D8 25 00 00 00 7C 3D 00 00 00 7C 0F 84 D7 05 00 00 8B 44 24 08 89 FA 31 F2 31 E8 09 C2 0F 84 17 06 00 00 89 C8 25 00 00 00 78 3D 00 00 00 78 0F 84 C7 06 00 00 89 D8 25 00 00 00 78 3D 00 00 00 78 0F 84 A9 06 00 00 89 C8 25 FF FF 01 00 3D 09 ED 01 00 89 44 24 18 0F 86 FB 05 00 00 C6 44 24 20 01 89 DA 81 E2 FF FF 01 00 81 FA 09 ED 01 00 89 54 24 28 77 14 0F 82 1C 06 00 00 81 7C 24 10 C0 87 AD BE 0F 86 0E 06 00 00 C6 44 24 30 01 80 7C 24 20 00 BA 01 00 00 00 75 12 8B 44 24 18 31 D2 0B 04 24 75 07 89 EA 09 F2 0F 94 C2 80 7C 24 30 00 0F 85 1D 06 00 00 8B 44 24 28 0B 44 24 10 0F 84 03 06 00 00 84 D2 0F 85 22 06 00 00 89 CA 31 DA 0F 88 18 06 00 00 89 CA 89 D8 C1 EA 11 C1 E8 11 81 E2 FF 3F 00 00 25 FF 3F 00 00 39 D0 89 44 24 20 0F 84 31 06 00 00 8B 44 24 28 39 44 24 18 0F 87 41 08 00 00 72 0D 8B 44 24 10 39 04 24 0F 87 32 08 00 00 8B 44 24 18 33 44 24 28 89 44 24 30 8B 04 24 33 44 24 10 0B 44 24 30 0F 84 65 0D 00 00 8B 44 24 28 39 44 24 18 72 0B 77 13 8B 44 24 10 39 04 24 73 0A 3B 54 24 20 0F 8E 0A 08 00 00 89 D0 2B 44 24 20 85 C0 0F 8E 88 08 00 00 83 F8 21 0F 8F 7D 05 00 00 83 F8 13 0F 8E E8 05 00 00 8D 48 EC C1 E1 04 8B 91 ?? ?? ?? ?? 8B 81 ?? ?? ?? ?? C7 44 24 54 00 00 00 00 89 54 24 58 89 44 24 40 89 D0 F7 E6 89 44 24 30 8B 44 24 40 89 54 24 34 F7 E6 89 44 24 38 8B 44 24 58 89 54 24 3C F7 E5 89 54 24 4C 8B 54 24 30 89 44 24 48 89 54 24 50 8B 54 24 4C 89 D0 31 D2 89 44 24 20 8B 44 24 50 01 44 24 20 8B 44 24 40 89 54 24 24 8B 54 24 54 11 54 24 24 F7 E5 01 44 24 20 11 54 24 24 8B 54 24 34 89 D0 31 D2 89 44 24 30 89 54 24 34 8B 44 24 38 01 44 24 30 8B 54 24 3C 11 54 24 34 8B 54 24 24 C7 44 24 74 00 00 00 00 89 D0 31 D2 01 44 24 30 11 54 24 34 8B 91 ?? ?? ?? ?? 8B 89 ?? ?? ?? ?? 89 D0 89 54 24 68 F7 E6 89 44 24 38 89 C8 89 54 24 3C F7 E6 89 44 24 50 8B 44 24 68 89 54 24 54 F7 E5 89 54 24 7C 8B 54 24 38 89 44 24 78 89 54 24 70 8B 54 24 7C 89 D0 31 D2 89 44 24 60 8B 44 24 70 01 44 24 60 89 C8 89 54 24 64 8B 54 24 74 11 54 24 64 F7 E5 01 44 24 60 11 54 24 64 8B 54 24 3C C7 44 24 3C 00 00 00 00 89 D0 31 D2 89 44 24 70 8B 44 24 50 01 44 24 70 89 54 24 74 8B 54 24 54 11 54 24 74 8B 54 24 64 89 D0 31 D2 01 44 24 70 8B 44 24 20 11 54 24 74 89 C2 31 C0 89 54 24 24 8B 54 24 48 89 44 24 20 89 54 24 38 8B 44 24 38 01 44 24 20 8B 54 24 3C 11 54 24 24 8B 44 24 70 01 44 24 20 8B 54 24 74 11 54 24 24 8B 44 24 24 39 C2 72 16 77 0A 8B 54 24 20 39 54 24 70 76 0A 83 44 24 30 01 83 54 24 34 00 8B 44 24 18 F7 64 24 58 C7 44 24 3C 00 00 00 00 89 44 24 48 8B 44 24 18 89 54 24 4C F7 64 24 40 89 44 24 70 8B 04 24 89 54 24 74 F7 64 24 58 89 54 24 5C 8B 54 24 48 89 44 24 58 89 54 24 38 8B 54 24 5C 89 D0 31 D2 89 44 24 50 8B 04 24 89 54 24 54 F7 64 24 40 01 44 24 50 8B 44 24 38 11 54 24 54 01 44 24 50 8B 54 24 3C 11 54 24 54 8B 54 24 4C 89 D0 31 D2 89 44 24 48 8B 44 24 70 01 44 24 48 89 54 24 4C 8B 54 24 74 11 54 24 4C 8B 54 24 54 C7 44 24 74 00 00 00 00 89 D0 31 D2 01 44 24 48 8B 44 24 18 11 54 24 4C F7 64 24 68 89 44 24 38 8B 44 24 18 89 54 24 3C F7 E1 89 44 24 18 8B 04 24 89 54 24 1C F7 64 24 68 89 54 24 6C 8B 54 24 38 89 44 24 68 89 54 24 70 8B 54 24 6C 89 D0 31 D2 89 44 24 40 8B 04 24 89 54 24 44 F7 E1 01 44 24 40 11 54 24 44 8B 54 24 70 01 54 24 40 8B 54 24 3C 8B 4C 24 74 11 4C 24 44 8B 4C 24 1C 89 D0 31 D2 89 54 24 3C 8B 54 24 18 89 44 24 38 01 54 24 38 8B 54 24 44 11 4C 24 3C 89 D0 31 D2 01 44 24 38 8B 44 24 40 11 54 24 3C 89 C2 31 C0 89 44 24 40 8B 44 24 68 89 54 24 44 31 D2 01 44 24 40 11 54 24 44 8B 54 24 50 89 D1 31 D2 89 54 24 18 8B 44 24 58 31 D2 01 44 24 18 8B 44 24 38 89 4C 24 1C 11 54 24 1C 8B 54 24 3C 01 44 24 18 11 54 24 1C 8B 4C 24 1C 39 CA 72 14 77 08 8B 54 24 18 39 D0 76 0A 83 44 24 48 01 83 54 24 4C 00 8B 44 24 20 8B 54 24 24 03 44 24 40 13 54 24 44 39 54 24 44 89 44 24 20 89 54 24 24 C7 04 24 01 00 00 00 C7 44 24 04 00 00 00 00 77 17 72 06 39 44 24 40 77 0F C7 04 24 00 00 00 00 C7 44 24 04 00 00 00 00 8B 54 24 18 03 14 24 8B 4C 24 1C 13 4C 24 04 89 54 24 38 8B 44 24 30 8B 54 24 34 03 44 24 38 89 4C 24 3C 13 54 24 3C 89 44 24 30 39 D1 89 54 24 34 0F 87 82 09 00 00 72 0A 39 44 24 38 0F 87 76 09 00 00 8B 4C 24 3C 31 D2 B8 01 00 00 00 39 4C 24 04 77 0F 72 09 8B 4C 24 38 39 0C 24 77 04 31 C0 31 D2 03 44 24 48 13 54 24 4C 89 D1 09 C1 75 5E 8B 44 24 34 0B 44 24 30 75 54 8B 54 24 60 8B 44 24 78 89 D1 31 D2 89 54 24 60 31 D2 01 44 24 60 8B 44 24 10 89 4C 24 64 11 54 24 64 8B 54 24 28 33 54 24 24 33 44 24 20 09 C2 0F 84 26 0B 00 00 8B 44 24 24 39 44 24 28 72 14 0F 87 47 03 00 00 8B 54 24 20 39 54 24 10 0F 83 39 03 00 00 BA 01 00 00 00 89 D8 F7 D0 C1 E8 1F 31 D0 EB 24 8D 76 00 81 E1 00 00 00 7E 81 F9 00 00 00 7E 74 36 81 E3 00 00 00 7E B8 01 00 00 00 81 FB 00 00 00 7E 74 23 8B 9C 24 AC 00 00 00 8B B4 24 B0 00 00 00 8B BC 24 B4 00 00 00 8B AC 24 B8 00 00 00 81 C4 BC 00 00 00 C3 83 0D ?? ?? ?? ?? 01 B8 01 00 00 00 EB CF 8B 44 24 10 89 DA 33 04 24 31 CA 09 C2 0F 85 D6 F9 FF FF B8 01 00 00 00 EB B5 8D 74 26 00 72 0D 81 3C 24 C0 87 AD BE 0F 87 F6 F9 FF FF 8B 54 24 18 8B 04 24 81 F2 09 ED 01 00 35 C0 87 AD BE 09 C2 0F 84 97 02 00 00 89 C8 25 00 00 00 60 3D 00 00 00 60 0F 94 44 24 20 E9 CB F9 FF FF 90 8B 54 24 28 8B 44 24 10 81 F2 09 ED 01 00 35 C0 87 AD BE 09 C2 0F 84 7B 02 00 00 89 D8 25 00 00 00 60 3D 00 00 00 60 0F 94 44 24 30 E9 C6 F9 FF FF 8B 44 24 08 09 F8 0F 85 F1 F9 FF FF 84 D2 B8 01 00 00 00 0F 85 27 FF FF FF 84 D2 75 0A 89 C8 C1 E8 1F E9 19 FF FF FF 89 D8 F7 D0 C1 E8 1F E9 0D FF FF FF 85 C9 0F 88 49 FF FF FF 89 D8 25 00 00 00 78 3D 00 00 00 78 74 07 31 C0 E9 F0 FE FF FF 85 DB B8 01 00 00 00 0F 89 E3 FE FF FF 66 90 EB E8 8B 5C 24 28 39 5C 24 18 77 13 0F 82 73 02 00 00 8B 5C 24 10 39 1C 24 0F 86 66 02 00 00 BA 01 00 00 00 89 C8 F7 D0 C1 E8 1F 31 D0 E9 AF FE FF FF 8B 0C C5 ?? ?? ?? ?? 8B 04 C5 ?? ?? ?? ?? C7 44 24 4C 00 00 00 00 89 44 24 40 F7 24 24 89 44 24 20 8B 44 24 40 89 54 24 24 F7 64 24 18 89 44 24 38 8B 04 24 89 54 24 3C F7 E1 89 54 24 04 8B 54 24 20 89 04 24 89 54 24 48 8B 54 24 04 89 D0 31 D2 89 44 24 30 8B 44 24 48 01 44 24 30 8B 44 24 18 89 54 24 34 8B 54 24 4C 11 54 24 34 F7 E1 01 44 24 30 11 54 24 34 8B 54 24 24 89 D0 31 D2 89 44 24 20 8B 44 24 38 01 44 24 20 89 54 24 24 8B 54 24 3C 11 54 24 24 8B 54 24 34 C7 44 24 54 00 00 00 00 89 D0 31 D2 01 44 24 20 8B 44 24 40 11 54 24 24 F7 E5 89 44 24 18 8B 44 24 40 89 54 24 1C F7 E6 89 44 24 40 89 C8 89 54 24 44 F7 E5 89 54 24 4C 8B 54 24 18 89 44 24 48 89 54 24 50 8B 54 24 4C 89 D0 31 D2 89 44 24 38 8B 44 24 50 01 44 24 38 89 C8 89 54 24 3C 8B 54 24 54 11 54 24 3C 8B 4C 24 1C F7 E6 01 44 24 38 11 54 24 3C 8B 44 24 40 89 CA 31 C9 89 54 24 18 8B 54 24 44 01 44 24 18 89 4C 24 1C 8B 0C 24 11 54 24 1C 8B 54 24 3C C7 44 24 34 00 00 00 00 89 D0 31 D2 01 44 24 18 8B 44 24 30 11 54 24 1C 89 4C 24 30 89 C2 31 C0 03 44 24 30 13 54 24 34 03 44 24 18 13 54 24 1C 39 54 24 1C 72 12 77 06 39 44 24 18 76 0A 83 44 24 20 01 83 54 24 24 00 8B 4C 24 24 0B 4C 24 20 0F 85 F3 FC FF FF 8B 74 24 28 8B 4C 24 10 31 D6 31 C1 09 CE 0F 84 9E 07 00 00 39 54 24 28 0F 82 D5 FC FF FF 77 0C 39 44 24 10 66 90 0F 82 C7 FC FF FF 31 D2 E9 C5 FC FF FF 8D 76 00 81 FE 63 8E 8D 37 C6 44 24 20 01 0F 87 39 F7 FF FF E9 53 FD FF FF 81 FF 63 8E 8D 37 C6 44 24 30 01 0F 87 50 F7 FF FF E9 6F FD FF FF 8D 74 26 00 3B 54 24 20 0F 8D 94 FD FF FF 8B 44 24 28 39 44 24 18 73 0C 89 C8 F7 D0 C1 E8 1F E9 A1 FC FF FF 77 09 8B 44 24 10 39 04 24 72 E9 8B 44 24 18 33 44 24 28 89 44 24 30 8B 04 24 33 44 24 10 0B 44 24 30 0F 85 C2 F7 FF FF 39 F7 0F 82 BA F7 FF FF 0F 87 AA F7 FF FF 39 6C 24 08 0F 86 AA F7 FF FF E9 9B F7 FF FF 8B 54 24 18 8B 04 24 33 54 24 28 33 44 24 10 09 C2 74 07 31 D2 E9 85 FD FF FF 39 F7 77 F5 0F 82 76 FD FF FF 39 6C 24 08 8D 76 00 0F 86 69 FD FF FF 31 D2 E9 67 FD FF FF 8D 76 00 8B 44 24 20 29 D0 83 F8 21 0F 8F 65 FF FF FF 83 F8 13 0F 8E CB 04 00 00 8D 58 EC C1 E3 04 8B 83 ?? ?? ?? ?? 8B 93 ?? ?? ?? ?? C7 44 24 54 00 00 00 00 89 44 24 48 89 54 24 38 F7 E7 89 44 24 30 8B 44 24 38 89 54 24 34 F7 E7 89 44 24 58 8B 44 24 48 89 54 24 5C F7 64 24 08 89 54 24 44 8B 54 24 30 89 44 24 40 89 54 24 50 8B 54 24 44 89 D0 31 D2 89 44 24 20 8B 44 24 50 01 44 24 20 8B 44 24 38 89 54 24 24 8B 54 24 54 11 54 24 24 F7 64 24 08 01 44 24 20 11 54 24 24 8B 54 24 34 89 D0 31 D2 89 44 24 30 8B 44 24 58 01 44 24 30 89 54 24 34 8B 54 24 5C 11 54 24 34 8B 54 24 24 C7 44 24 7C 00 00 00 00 89 D0 31 D2 01 44 24 30 11 54 24 34 8B 93 ?? ?? ?? ?? 8B 9B ?? ?? ?? ?? 89 D0 89 54 24 58 F7 E7 89 44 24 60 89 D8 89 54 24 64 F7 E7 89 44 24 50 8B 44 24 58 89 54 24 54 F7 64 24 08 89 54 24 74 8B 54 24 60 89 44 24 70 89 54 24 78 8B 54 24 74 89 D0 31 D2 89 44 24 68 8B 44 24 78 89 54 24 6C 8B 54 24 7C 01 44 24 68 8B 44 24 08 11 54 24 6C C7 44 24 0C 00 00 00 00 F7 E3 01 44 24 68 11 54 24 6C 8B 54 24 64 89 D0 31 D2 89 44 24 60 8B 44 24 50 01 44 24 60 89 54 24 64 8B 54 24 54 11 54 24 64 8B 54 24 6C 89 D0 31 D2 01 44 24 60 8B 44 24 20 11 54 24 64 89 C2 31 C0 89 54 24 24 8B 54 24 40 89 44 24 20 89 54 24 08 8B 44 24 08 8B 54 24 0C 01 44 24 20 8B 44 24 60 11 54 24 24 01 44 24 20 8B 54 24 64 11 54 24 24 8B 44 24 24 39 C2 72 16 77 0A 8B 54 24 20 39 54 24 60 76 0A 83 44 24 30 01 83 54 24 34 00 8B 44 24 28 F7 64 24 48 C7 44 24 0C 00 00 00 00 89 44 24 40 8B 44 24 28 89 54 24 44 F7 64 24 38 89 44 24 50 8B 44 24 10 89 54 24 54 F7 64 24 48 89 54 24 4C 8B 54 24 40 89 44 24 48 89 54 24 08 8B 54 24 4C 89 D0 31 D2 89 44 24 60 8B 44 24 10 89 54 24 64 F7 64 24 38 01 44 24 60 8B 44 24 08 11 54 24 64 01 44 24 60 8B 54 24 0C 11 54 24 64 8B 54 24 44 89 D0 31 D2 89 44 24 40 8B 44 24 50 01 44 24 40 89 54 24 44 8B 54 24 54 11 54 24 44 8B 54 24 64 C7 44 24 54 00 00 00 00 89 D0 31 D2 01 44 24 40 8B 44 24 28 11 54 24 44 F7 64 24 58 89 44 24 38 8B 44 24 28 89 54 24 3C F7 E3 89 44 24 28 8B 44 24 10 89 54 24 2C F7 64 24 58 89 54 24 5C 8B 54 24 38 89 44 24 58 89 54 24 50 8B 54 24 5C 89 D0 31 D2 89 44 24 08 8B 44 24 10 89 54 24 0C F7 E3 01 44 24 08 11 54 24 0C 8B 44 24 50 01 44 24 08 8B 54 24 54 11 54 24 0C 8B 54 24 3C 89 D0 31 D2 89 44 24 38 8B 44 24 28 01 44 24 38 89 54 24 3C 8B 54 24 2C 11 54 24 3C 8B 54 24 0C 89 D0 31 D2 01 44 24 38 8B 44 24 08 11 54 24 3C 89 C2 31 C0 89 44 24 08 8B 44 24 58 89 54 24 0C 31 D2 01 44 24 08 8B 44 24 60 11 54 24 0C 89 C2 31 C0 89 44 24 28 8B 44 24 48 89 54 24 2C 31 D2 01 44 24 28 8B 44 24 38 11 54 24 2C 8B 54 24 3C 01 44 24 28 11 54 24 2C 8B 5C 24 2C 39 DA 72 14 77 08 8B 54 24 28 39 D0 76 0A 83 44 24 40 01 83 54 24 44 00 8B 44 24 20 8B 54 24 24 03 44 24 08 13 54 24 0C 39 54 24 0C 89 44 24 20 89 54 24 24 C7 44 24 10 01 00 00 00 C7 44 24 14 00 00 00 00 77 18 72 06 39 44 24 08 77 10 C7 44 24 10 00 00 00 00 C7 44 24 14 00 00 00 00 8B 44 24 28 8B 54 24 2C 03 44 24 10 13 54 24 14 89 44 24 28 8B 44 24 30 89 54 24 2C 8B 54 24 34 03 44 24 28 13 54 24 2C 39 54 24 2C 89 44 24 30 89 54 24 34 0F 87 AE 02 00 00 72 0A 39 44 24 28 0F 87 A2 02 00 00 8B 5C 24 2C 31 D2 B8 01 00 00 00 39 5C 24 14 77 10 72 0A 8B 5C 24 28 39 5C 24 10 77 04 31 C0 31 D2 03 44 24 40 13 54 24 44 89 D3 09 C3 75 49 8B 44 24 34 0B 44 24 30 75 3F 8B 5C 24 70 8B 44 24 68 C7 44 24 0C 00 00 00 00 89 5C 24 08 8B 5C 24 24 89 C2 31 C0 03 44 24 08 13 54 24 0C 39 5C 24 18 74 26 8B 44 24 24 39 44 24 18 72 0B 77 39 8B 54 24 20 39 14 24 73 30 BA 01 00 00 00 89 C8 C1 E8 1F 31 D0 E9 9A F7 FF FF 8B 5C 24 20 39 1C 24 75 D1 39 F2 0F 84 02 03 00 00 39 F2 72 0A 8D 74 26 00 77 D4 39 E8 77 D0 31 D2 EB D1 8D B6 00 00 00 00 39 F7 73 11 3B 54 24 20 0F 8C EA FA FF FF 66 90 E9 39 F8 FF FF 0F 87 95 F2 FF FF 39 6C 24 08 90 72 E2 E9 D1 FA FF FF B8 01 00 00 00 31 D2 E9 9E F6 FF FF 8B 0C C5 ?? ?? ?? ?? 8B 04 C5 ?? ?? ?? ?? C7 44 24 4C 00 00 00 00 89 44 24 40 F7 64 24 10 89 44 24 20 8B 44 24 40 89 54 24 24 F7 64 24 28 89 44 24 38 8B 44 24 10 89 54 24 3C F7 E1 89 54 24 14 8B 54 24 20 89 44 24 10 89 54 24 48 8B 54 24 14 89 D0 31 D2 89 44 24 30 8B 44 24 48 01 44 24 30 8B 44 24 28 89 54 24 34 8B 54 24 4C 11 54 24 34 F7 E1 01 44 24 30 11 54 24 34 8B 54 24 24 89 D0 31 D2 89 44 24 20 8B 44 24 38 01 44 24 20 89 54 24 24 8B 54 24 3C 11 54 24 24 8B 54 24 34 C7 44 24 4C 00 00 00 00 89 D0 31 D2 01 44 24 20 8B 44 24 40 11 54 24 24 F7 64 24 08 89 44 24 }
	condition:
		$1
}

rule file_45_9_0 {
	meta:
		name = "___bid128_quiet_not_less"
		size = 4592
		refs = "01d0 ___bid_ten2k128 0682 ___bid_IDEC_glbflags 07c5 ___bid_ten2k64"
	strings:
		$1 = { 81 EC BC 00 00 00 8B 8C 24 C8 00 00 00 89 9C 24 AC 00 00 00 8B 9C 24 D0 00 00 00 89 B4 24 B0 00 00 00 8B B4 24 C4 00 00 00 89 BC 24 B4 00 00 00 8B BC 24 D4 00 00 00 89 4C 24 08 8B 8C 24 CC 00 00 00 89 1C 24 8B 9C 24 D8 00 00 00 89 AC 24 B8 00 00 00 8B AC 24 C0 00 00 00 89 C8 25 00 00 00 7C 3D 00 00 00 7C 89 5C 24 10 8B 9C 24 DC 00 00 00 0F 84 C0 05 00 00 89 D8 25 00 00 00 7C 3D 00 00 00 7C 0F 84 AE 05 00 00 8B 04 24 89 FA 31 F2 31 E8 09 C2 0F 84 F6 05 00 00 89 C8 25 00 00 00 78 3D 00 00 00 78 0F 84 B4 06 00 00 89 D8 25 00 00 00 78 3D 00 00 00 78 0F 84 92 06 00 00 89 C8 25 FF FF 01 00 3D 09 ED 01 00 89 44 24 18 0F 86 DC 05 00 00 C6 44 24 28 01 89 DA 81 E2 FF FF 01 00 81 FA 09 ED 01 00 89 54 24 20 77 14 0F 82 FE 05 00 00 81 7C 24 10 C0 87 AD BE 0F 86 F0 05 00 00 C6 44 24 30 01 80 7C 24 28 00 BA 01 00 00 00 75 13 8B 44 24 18 31 D2 0B 44 24 08 75 07 89 EA 09 F2 0F 94 C2 80 7C 24 30 00 0F 85 FD 05 00 00 8B 44 24 20 0B 44 24 10 0F 84 E4 05 00 00 84 D2 0F 85 0A 06 00 00 89 CA 31 DA 0F 88 00 06 00 00 89 C8 C1 E8 11 25 FF 3F 00 00 89 44 24 30 89 D8 C1 E8 11 25 FF 3F 00 00 3B 44 24 30 0F 84 12 06 00 00 8B 54 24 20 39 54 24 18 0F 83 2C 08 00 00 39 F7 72 12 77 05 39 2C 24 72 0B 39 44 24 30 90 0F 8C 0F 0F 00 00 8B 54 24 30 29 C2 85 D2 89 54 24 28 0F 8E B8 08 00 00 83 FA 21 0F 8F 8D 05 00 00 83 7C 24 28 13 0F 8E 26 0D 00 00 8B 4C 24 28 C7 44 24 54 00 00 00 00 83 E9 14 C1 E1 04 8B 81 ?? ?? ?? ?? 8B 91 ?? ?? ?? ?? 89 44 24 58 89 54 24 40 F7 E6 89 44 24 38 8B 44 24 40 89 54 24 3C F7 E6 89 44 24 30 8B 44 24 58 89 54 24 34 F7 E5 89 54 24 4C 8B 54 24 38 89 44 24 48 89 54 24 50 8B 54 24 4C 89 D0 31 D2 89 44 24 28 8B 44 24 50 01 44 24 28 8B 44 24 40 89 54 24 2C 8B 54 24 54 11 54 24 2C F7 E5 01 44 24 28 11 54 24 2C 8B 54 24 3C 89 D0 31 D2 89 44 24 38 8B 44 24 30 01 44 24 38 89 54 24 3C 8B 54 24 34 11 54 24 3C 8B 54 24 2C C7 44 24 74 00 00 00 00 89 D0 31 D2 01 44 24 38 11 54 24 3C 8B 91 ?? ?? ?? ?? 8B 89 ?? ?? ?? ?? 89 D0 89 54 24 60 F7 E6 89 44 24 30 89 C8 89 54 24 34 F7 E6 89 44 24 50 8B 44 24 60 89 54 24 54 F7 E5 89 54 24 7C 8B 54 24 30 89 44 24 78 89 54 24 70 8B 54 24 7C 89 D0 31 D2 89 44 24 68 8B 44 24 70 01 44 24 68 89 C8 89 54 24 6C 8B 54 24 74 11 54 24 6C F7 E5 01 44 24 68 11 54 24 6C 8B 54 24 34 C7 44 24 34 00 00 00 00 89 D0 31 D2 89 44 24 70 8B 44 24 50 01 44 24 70 89 54 24 74 8B 54 24 54 11 54 24 74 8B 54 24 6C 89 D0 31 D2 01 44 24 70 8B 44 24 28 11 54 24 74 89 C2 31 C0 89 54 24 2C 8B 54 24 48 89 44 24 28 89 54 24 30 8B 44 24 30 01 44 24 28 8B 54 24 34 11 54 24 2C 8B 44 24 70 01 44 24 28 8B 54 24 74 11 54 24 2C 8B 44 24 2C 39 C2 72 16 77 0A 8B 54 24 28 39 54 24 70 76 0A 83 44 24 38 01 83 54 24 3C 00 8B 44 24 18 F7 64 24 58 C7 44 24 34 00 00 00 00 89 44 24 48 8B 44 24 18 89 54 24 4C F7 64 24 40 89 44 24 70 8B 44 24 08 89 54 24 74 F7 64 24 58 89 54 24 5C 8B 54 24 48 89 44 24 58 89 54 24 30 8B 54 24 5C 89 D0 31 D2 89 44 24 50 8B 44 24 08 89 54 24 54 F7 64 24 40 01 44 24 50 8B 44 24 30 11 54 24 54 01 44 24 50 8B 54 24 34 11 54 24 54 8B 54 24 4C 89 D0 31 D2 89 44 24 48 8B 44 24 70 01 44 24 48 89 54 24 4C 8B 54 24 74 11 54 24 4C 8B 54 24 54 C7 44 24 74 00 00 00 00 89 D0 31 D2 01 44 24 48 8B 44 24 18 11 54 24 4C F7 64 24 60 89 44 24 30 8B 44 24 18 89 54 24 34 F7 E1 89 44 24 18 8B 44 24 08 89 54 24 1C F7 64 24 60 89 54 24 64 8B 54 24 30 89 44 24 60 89 54 24 70 8B 54 24 64 89 D0 31 D2 89 44 24 40 8B 44 24 08 89 54 24 44 F7 E1 01 44 24 40 11 54 24 44 8B 54 24 70 01 54 24 40 8B 54 24 34 8B 4C 24 74 11 4C 24 44 8B 4C 24 1C 89 D0 31 D2 89 54 24 34 8B 54 24 18 89 44 24 30 01 54 24 30 8B 54 24 44 11 4C 24 34 89 D0 31 D2 01 44 24 30 8B 44 24 40 11 54 24 34 89 C2 31 C0 89 44 24 40 8B 44 24 60 89 54 24 44 31 D2 01 44 24 40 11 54 24 44 8B 54 24 50 89 D1 31 D2 89 54 24 18 8B 44 24 58 31 D2 01 44 24 18 8B 44 24 30 89 4C 24 1C 11 54 24 1C 8B 54 24 34 01 44 24 18 11 54 24 1C 8B 4C 24 1C 39 CA 72 14 77 08 8B 54 24 18 39 D0 76 0A 83 44 24 48 01 83 54 24 4C 00 8B 44 24 28 8B 54 24 2C 03 44 24 40 13 54 24 44 39 54 24 44 89 44 24 28 89 54 24 2C C7 44 24 08 01 00 00 00 C7 44 24 0C 00 00 00 00 77 18 72 06 39 44 24 40 77 10 C7 44 24 08 00 00 00 00 C7 44 24 0C 00 00 00 00 8B 54 24 18 03 54 24 08 8B 4C 24 1C 13 4C 24 0C 89 54 24 30 8B 44 24 38 8B 54 24 3C 03 44 24 30 89 4C 24 34 13 54 24 34 89 44 24 38 39 D1 89 54 24 3C 0F 87 1F 0B 00 00 72 0A 39 44 24 30 0F 87 13 0B 00 00 8B 4C 24 34 31 D2 B8 01 00 00 00 39 4C 24 0C 77 10 72 0A 8B 4C 24 30 39 4C 24 08 77 04 31 C0 31 D2 03 44 24 48 13 54 24 4C 89 D1 09 C1 75 5E 8B 44 24 3C 0B 44 24 38 75 54 8B 54 24 68 8B 44 24 78 89 D1 31 D2 89 54 24 68 31 D2 01 44 24 68 8B 44 24 10 89 4C 24 6C 11 54 24 6C 8B 54 24 20 33 54 24 2C 33 44 24 28 09 C2 0F 84 02 0B 00 00 8B 44 24 2C 39 44 24 20 72 14 0F 87 5B 03 00 00 8B 54 24 28 39 54 24 10 0F 83 4D 03 00 00 BA 01 00 00 00 89 D8 C1 E8 1F 31 D0 EB 21 81 E1 00 00 00 7E 81 F9 00 00 00 7E 74 3B 81 E3 00 00 00 7E B8 01 00 00 00 81 FB 00 00 00 7E 74 28 8B 9C 24 AC 00 00 00 8B B4 24 B0 00 00 00 8B BC 24 B4 00 00 00 8B AC 24 B8 00 00 00 81 C4 BC 00 00 00 C3 90 8D 74 26 00 83 0D ?? ?? ?? ?? 01 B8 01 00 00 00 EB CA 66 90 8B 44 24 10 89 DA 33 44 24 08 31 CA 09 C2 0F 85 F6 F9 FF FF B8 01 00 00 00 EB AD 90 8D 74 26 00 72 0E 81 7C 24 08 C0 87 AD BE 0F 87 14 FA FF FF 8B 54 24 18 8B 44 24 08 81 F2 09 ED 01 00 35 C0 87 AD BE 09 C2 0F 84 A5 02 00 00 89 C8 25 00 00 00 60 3D 00 00 00 60 0F 94 44 24 28 E9 E8 F9 FF FF 8B 54 24 20 8B 44 24 10 81 F2 09 ED 01 00 35 C0 87 AD BE 09 C2 0F 84 8A 02 00 00 89 D8 25 00 00 00 60 3D 00 00 00 60 0F 94 44 24 30 E9 E4 F9 FF FF 8B 04 24 09 F8 0F 85 11 FA FF FF 84 D2 B8 01 00 00 00 0F 85 1E FF FF FF 84 D2 75 12 89 C8 F7 D0 C1 E8 1F E9 0E FF FF FF 8D B6 00 00 00 00 89 D8 C1 E8 1F E9 FE FE FF FF 8D B6 00 00 00 00 85 C9 B8 01 00 00 00 0F 89 EB FE FF FF 89 DA 81 E2 00 00 00 78 81 FA 00 00 00 78 74 36 31 C0 E9 D4 FE FF FF 8B 5C 24 20 39 5C 24 18 77 14 0F 82 91 02 00 00 8B 5C 24 10 39 5C 24 08 0F 86 83 02 00 00 BA 01 00 00 00 89 C8 C1 E8 1F 31 D0 E9 A5 FE FF FF 85 DB 0F 88 9D FE FF FF 31 C0 E9 96 FE FF FF 8B 0C C5 ?? ?? ?? ?? 8B 04 C5 ?? ?? ?? ?? C7 44 24 4C 00 00 00 00 89 44 24 40 F7 64 24 10 89 44 24 28 8B 44 24 40 89 54 24 2C F7 64 24 20 89 44 24 30 8B 44 24 10 89 54 24 34 F7 E1 89 54 24 14 8B 54 24 28 89 44 24 10 89 54 24 48 8B 54 24 14 89 D0 31 D2 89 44 24 38 8B 44 24 48 01 44 24 38 8B 44 24 20 89 54 24 3C 8B 54 24 4C 11 54 24 3C F7 E1 01 44 24 38 11 54 24 3C 8B 54 24 2C 89 D0 31 D2 89 44 24 28 8B 44 24 30 01 44 24 28 89 54 24 2C 8B 54 24 34 11 54 24 2C 8B 54 24 3C C7 44 24 4C 00 00 00 00 89 D0 31 D2 01 44 24 28 8B 44 24 40 11 54 24 2C F7 24 24 89 44 24 20 8B 44 24 40 89 54 24 24 F7 E7 89 44 24 40 8B 04 24 89 54 24 44 F7 E1 89 54 24 04 8B 54 24 20 89 04 24 89 54 24 48 8B 54 24 04 89 D0 31 D2 89 44 24 30 8B 44 24 48 01 44 24 30 89 C8 89 54 24 34 8B 54 24 4C 11 54 24 34 8B 4C 24 24 F7 E7 01 44 24 30 11 54 24 34 8B 44 24 40 89 CA 31 C9 89 54 24 20 8B 54 24 44 01 44 24 20 89 4C 24 24 8B 4C 24 10 11 54 24 24 8B 54 24 34 C7 44 24 3C 00 00 00 00 89 D0 31 D2 01 44 24 20 8B 44 24 38 11 54 24 24 89 4C 24 38 89 C2 31 C0 03 44 24 38 13 54 24 3C 03 44 24 20 13 54 24 24 39 54 24 24 72 12 77 06 39 44 24 20 76 0A 83 44 24 28 01 83 54 24 2C 00 8B 4C 24 2C 0B 4C 24 28 75 2B 8B 7C 24 18 8B 4C 24 08 31 D7 31 C1 09 CF 0F 84 DC 07 00 00 39 54 24 18 0F 87 C0 FC FF FF 72 0B 39 44 24 08 90 0F 87 B3 FC FF FF 31 D2 E9 B1 FC FF FF 8D 76 00 81 FE 63 8E 8D 37 C6 44 24 28 01 0F 87 48 F7 FF FF E9 45 FD FF FF 81 FF 63 8E 8D 37 C6 44 24 30 01 0F 87 5F F7 FF FF E9 60 FD FF FF 77 0E 8B 54 24 10 39 54 24 08 0F 82 C4 F7 FF FF 39 F7 76 27 8B 54 24 20 39 54 24 18 0F 82 BD F7 FF FF 0F 87 C2 F7 FF FF 8B 54 24 10 39 54 24 08 0F 86 A9 F7 FF FF E9 AF F7 FF FF 72 09 39 2C 24 8D 74 26 00 77 CE 39 44 24 30 0F 8F 42 FD FF FF 8B 54 24 20 39 54 24 18 0F 87 8C F7 FF FF 0F 82 70 F7 FF FF 8B 54 24 10 39 54 24 08 0F 87 78 F7 FF FF 66 90 E9 5B F7 FF FF 8B 54 24 18 8B 44 24 08 33 54 24 20 33 44 24 10 09 C2 74 07 31 D2 E9 67 FD FF FF 39 F7 77 F5 0F 82 58 FD FF FF 39 2C 24 8D 76 00 0F 86 4C FD FF FF 31 D2 E9 4A FD FF FF 8D 76 00 2B 44 24 30 83 F8 21 0F 8F 38 06 00 00 83 F8 13 0F 8E 4C FD FF FF 8D 58 EC C1 E3 04 8B 83 ?? ?? ?? ?? 8B 93 ?? ?? ?? ?? C7 44 24 54 00 00 00 00 89 44 24 48 89 54 24 40 F7 E7 89 44 24 38 8B 44 24 40 89 54 24 3C F7 E7 89 44 24 58 8B 44 24 48 89 54 24 5C F7 24 24 89 54 24 34 8B 54 24 38 89 44 24 30 89 54 24 50 8B 54 24 34 89 D0 31 D2 89 44 24 28 8B 44 24 50 01 44 24 28 8B 44 24 40 89 54 24 2C 8B 54 24 54 11 54 24 2C F7 24 24 01 44 24 28 11 54 24 2C 8B 54 24 3C 89 D0 31 D2 89 44 24 38 8B 44 24 58 01 44 24 38 89 54 24 3C 8B 54 24 5C 11 54 24 3C 8B 54 24 2C C7 44 24 7C 00 00 00 00 89 D0 31 D2 01 44 24 38 11 54 24 3C 8B 93 ?? ?? ?? ?? 8B 9B ?? ?? ?? ?? 89 D0 89 54 24 58 F7 E7 89 44 24 60 89 D8 89 54 24 64 F7 E7 89 44 24 50 8B 44 24 58 89 54 24 54 F7 24 24 89 54 24 74 8B 54 24 60 89 44 24 70 89 54 24 78 8B 54 24 74 89 D0 31 D2 89 44 24 68 8B 44 24 78 89 54 24 6C 8B 54 24 7C 01 44 24 68 8B 04 24 11 54 24 6C C7 44 24 04 00 00 00 00 F7 E3 01 44 24 68 11 54 24 6C 8B 54 24 64 89 D0 31 D2 89 44 24 60 8B 44 24 50 01 44 24 60 89 54 24 64 8B 54 24 54 11 54 24 64 8B 54 24 6C 89 D0 31 D2 01 44 24 60 8B 44 24 28 11 54 24 64 89 C2 31 C0 89 54 24 2C 8B 54 24 30 89 44 24 28 89 14 24 8B 04 24 8B 54 24 04 01 44 24 28 8B 44 24 60 11 54 24 2C 01 44 24 28 8B 54 24 64 11 54 24 2C 8B 44 24 2C 39 C2 72 16 77 0A 8B 54 24 28 39 54 24 60 76 0A 83 44 24 38 01 83 54 24 3C 00 8B 44 24 20 F7 64 24 48 C7 44 24 04 00 00 00 00 89 44 24 30 8B 44 24 20 89 54 24 34 F7 64 24 40 89 44 24 50 8B 44 24 10 89 54 24 54 F7 64 24 48 89 54 24 4C 8B 54 24 30 89 44 24 48 89 14 24 8B 54 24 4C 89 D0 31 D2 89 44 24 60 8B 44 24 10 89 54 24 64 F7 64 24 40 01 44 24 60 8B 04 24 11 54 24 64 01 44 24 60 8B 54 24 04 11 54 24 64 8B 54 24 34 89 D0 31 D2 89 44 24 30 8B 44 24 50 01 44 24 30 89 54 24 34 8B 54 24 54 11 54 24 34 8B 54 24 64 C7 44 24 54 00 00 00 00 89 D0 31 D2 01 44 24 30 8B 44 24 20 11 54 24 34 F7 64 24 58 89 44 24 40 8B 44 24 20 89 54 24 44 F7 E3 89 44 24 20 8B 44 24 10 89 54 24 24 F7 64 24 58 89 54 24 5C 8B 54 24 40 89 44 24 58 89 54 24 50 8B 54 24 5C 89 D0 31 D2 89 04 24 8B 44 24 10 89 54 24 04 F7 E3 01 04 24 11 54 24 04 8B 44 24 50 01 04 24 8B 54 24 54 11 54 24 04 8B 54 24 44 89 D0 31 D2 89 44 24 40 8B 44 24 20 01 44 24 40 89 54 24 44 8B 54 24 24 11 54 24 44 8B 54 24 04 89 D0 31 D2 01 44 24 40 8B 04 24 11 54 24 44 89 C2 31 C0 89 04 24 8B 44 24 58 89 54 24 04 31 D2 01 04 24 8B 44 24 60 11 54 24 04 89 C2 31 C0 89 44 24 20 8B 44 24 48 89 54 24 24 31 D2 01 44 24 20 8B 44 24 40 11 54 24 24 8B 54 24 44 01 44 24 20 11 54 24 24 8B 5C 24 24 39 DA 72 14 77 08 8B 54 24 20 39 D0 76 0A 83 44 24 30 01 83 54 24 34 00 8B 44 24 28 8B 54 24 2C 03 04 24 13 54 24 04 39 54 24 04 89 44 24 28 89 54 24 2C C7 44 24 10 01 00 00 00 C7 44 24 14 00 00 00 00 77 17 72 05 39 04 24 77 10 C7 44 24 10 00 00 00 00 C7 44 24 14 00 00 00 00 8B 44 24 20 8B 54 24 24 03 44 24 10 13 54 24 14 89 44 24 20 8B 44 24 38 89 54 24 24 8B 54 24 3C 03 44 24 20 13 54 24 24 39 54 24 24 89 44 24 38 89 54 24 3C 0F 87 7B 02 00 00 72 0A 39 44 24 20 0F 87 6F 02 00 00 8B 5C 24 24 31 D2 B8 01 00 00 00 39 5C 24 14 77 10 72 0A 8B 5C 24 20 39 5C 24 10 77 04 31 C0 31 D2 03 44 24 30 13 54 24 34 89 D3 09 C3 0F 85 BA FB FF FF 8B 44 24 3C 0B 44 24 38 0F 85 AC FB FF FF 8B 5C 24 70 8B 44 24 68 C7 44 24 04 00 00 00 00 89 1C 24 8B 5C 24 2C 89 C2 31 C0 03 04 24 13 54 24 04 39 5C 24 18 0F 84 D2 02 00 00 8B 44 24 2C 39 44 24 18 0F 82 72 FB FF FF 0F 87 D5 F8 FF FF 8B 54 24 28 39 54 24 08 0F 87 C7 F8 FF FF 31 D2 E9 C5 F8 FF FF 8B 44 24 28 C7 44 24 4C 00 00 00 00 8B 14 C5 ?? ?? ?? ?? 8B 0C C5 ?? ?? ?? ?? 89 54 24 40 89 D0 F7 64 24 08 89 44 24 28 8B 44 24 40 89 54 24 2C F7 64 24 18 89 44 24 30 8B 44 24 08 89 54 24 34 F7 E1 89 54 24 0C 8B 54 24 28 89 44 24 08 89 54 24 48 8B 54 24 0C 89 D0 31 D2 89 44 24 38 8B 44 24 48 01 44 24 38 8B 44 24 18 89 54 24 3C 8B 54 24 4C 11 54 24 3C F7 E1 01 44 24 38 11 54 24 3C 8B 54 24 2C 89 D0 31 D2 89 44 24 28 8B 44 24 30 01 44 24 28 89 54 24 2C 8B 54 24 34 11 54 24 2C 8B 54 24 3C C7 44 24 54 00 00 00 00 89 D0 31 D2 01 44 24 28 8B 44 24 40 11 54 24 2C F7 E5 89 44 24 18 8B 44 24 40 89 54 24 1C F7 E6 89 44 24 40 89 C8 89 54 24 44 F7 E5 89 54 24 4C 8B 54 24 18 89 44 24 48 89 54 24 50 8B 54 24 4C 89 D0 31 D2 89 44 24 30 8B 44 24 50 01 44 24 30 89 C8 89 54 24 34 8B 54 24 54 11 54 24 34 8B 4C 24 1C F7 E6 01 44 24 30 11 54 24 34 8B 44 24 40 89 CA }
	condition:
		$1
}

rule file_45_10_0 {
	meta:
		name = "___bid128_quiet_ordered"
		size = 96
		refs = "0054 ___bid_IDEC_glbflags"
	strings:
		$1 = { 53 83 EC 28 8B 54 24 3C 8B 4C 24 4C 89 D0 25 00 00 00 7C 3D 00 00 00 7C 74 1A 89 CB B8 01 00 00 00 81 E3 00 00 00 7C 81 FB 00 00 00 7C 74 05 83 C4 28 5B C3 81 E2 00 00 00 7E 81 FA 00 00 00 7E 74 10 81 E1 00 00 00 7E 31 C0 81 F9 00 00 00 7E 75 DD 83 0D ?? ?? ?? ?? 01 83 C4 28 31 C0 5B C3 }
	condition:
		$1
}

rule file_45_11_0 {
	meta:
		name = "___bid128_quiet_unordered"
		size = 112
		refs = "0054 ___bid_IDEC_glbflags"
	strings:
		$1 = { 53 83 EC 28 8B 54 24 3C 8B 4C 24 4C 89 D0 25 00 00 00 7C 3D 00 00 00 7C 74 17 89 CB 31 C0 81 E3 00 00 00 7C 81 FB 00 00 00 7C 74 05 83 C4 28 5B C3 81 E2 00 00 00 7E 81 FA 00 00 00 7E 74 13 81 E1 00 00 00 7E B8 01 00 00 00 81 F9 00 00 00 7E 75 DA 83 0D ?? ?? ?? ?? 01 83 C4 28 B8 01 00 00 00 5B C3 8D B6 00 00 00 00 8D BC 27 00 00 00 00 }
	condition:
		$1
}

rule file_45_12_0 {
	meta:
		name = "___bid128_signaling_greater"
		size = 4560
		refs = "01f5 ___bid_ten2k128 0668 ___bid_IDEC_glbflags 07ac ___bid_ten2k64"
	strings:
		$1 = { 81 EC BC 00 00 00 8B 8C 24 C8 00 00 00 89 9C 24 AC 00 00 00 8B 9C 24 D0 00 00 00 89 B4 24 B0 00 00 00 8B B4 24 C4 00 00 00 89 BC 24 B4 00 00 00 8B BC 24 D4 00 00 00 89 4C 24 08 8B 8C 24 CC 00 00 00 89 1C 24 8B 9C 24 D8 00 00 00 89 AC 24 B8 00 00 00 8B AC 24 C0 00 00 00 89 C8 25 00 00 00 7C 3D 00 00 00 7C 89 5C 24 10 8B 9C 24 DC 00 00 00 0F 84 EF 05 00 00 89 D8 25 00 00 00 7C 3D 00 00 00 7C 0F 84 DD 05 00 00 8B 04 24 89 FA 31 F2 31 E8 09 C2 0F 84 F8 05 00 00 89 C8 25 00 00 00 78 3D 00 00 00 78 0F 84 45 06 00 00 89 D8 25 00 00 00 78 3D 00 00 00 78 0F 84 B2 06 00 00 89 C8 25 FF FF 01 00 3D 09 ED 01 00 89 44 24 18 0F 86 DC 05 00 00 C6 44 24 20 01 89 DA 81 E2 FF FF 01 00 81 FA 09 ED 01 00 89 54 24 28 77 14 0F 82 20 06 00 00 81 7C 24 10 C0 87 AD BE 0F 86 12 06 00 00 C6 44 24 30 01 80 7C 24 20 00 BA 01 00 00 00 75 13 8B 44 24 18 31 D2 0B 44 24 08 75 07 89 EA 09 F2 0F 94 C2 80 7C 24 30 00 0F 85 1F 06 00 00 8B 44 24 28 0B 44 24 10 0F 84 06 06 00 00 84 D2 0F 85 2A 06 00 00 89 CA 31 DA 0F 88 20 06 00 00 89 C8 89 DA C1 E8 11 C1 EA 11 25 FF 3F 00 00 81 E2 FF 3F 00 00 39 C2 89 44 24 20 0F 84 09 06 00 00 8B 44 24 28 39 44 24 18 0F 87 17 08 00 00 72 0E 8B 44 24 10 39 44 24 08 0F 87 07 08 00 00 8B 44 24 18 33 44 24 28 89 44 24 30 8B 44 24 08 33 44 24 10 0B 44 24 30 0F 84 25 0D 00 00 8B 44 24 28 39 44 24 18 72 0C 77 14 8B 44 24 10 39 44 24 08 73 0A 39 54 24 20 0F 8E DD 07 00 00 8B 44 24 20 29 D0 85 C0 0F 8E 5B 08 00 00 83 F8 21 0F 8F 79 05 00 00 83 F8 13 0F 8E BC 05 00 00 8D 48 EC C1 E1 04 8B 91 ?? ?? ?? ?? 8B 81 ?? ?? ?? ?? C7 44 24 54 00 00 00 00 89 54 24 58 89 44 24 40 89 D0 F7 E6 89 44 24 30 8B 44 24 40 89 54 24 34 F7 E6 89 44 24 38 8B 44 24 58 89 54 24 3C F7 E5 89 54 24 4C 8B 54 24 30 89 44 24 48 89 54 24 50 8B 54 24 4C 89 D0 31 D2 89 44 24 20 8B 44 24 50 01 44 24 20 8B 44 24 40 89 54 24 24 8B 54 24 54 11 54 24 24 F7 E5 01 44 24 20 11 54 24 24 8B 54 24 34 89 D0 31 D2 89 44 24 30 89 54 24 34 8B 44 24 38 01 44 24 30 8B 54 24 3C 11 54 24 34 8B 54 24 24 C7 44 24 74 00 00 00 00 89 D0 31 D2 01 44 24 30 11 54 24 34 8B 91 ?? ?? ?? ?? 8B 89 ?? ?? ?? ?? 89 D0 89 54 24 60 F7 E6 89 44 24 38 89 C8 89 54 24 3C F7 E6 89 44 24 50 8B 44 24 60 89 54 24 54 F7 E5 89 54 24 7C 8B 54 24 38 89 44 24 78 89 54 24 70 8B 54 24 7C 89 D0 31 D2 89 44 24 68 8B 44 24 70 01 44 24 68 89 C8 89 54 24 6C 8B 54 24 74 11 54 24 6C F7 E5 01 44 24 68 11 54 24 6C 8B 54 24 3C C7 44 24 3C 00 00 00 00 89 D0 31 D2 89 44 24 70 8B 44 24 50 01 44 24 70 89 54 24 74 8B 54 24 54 11 54 24 74 8B 54 24 6C 89 D0 31 D2 01 44 24 70 8B 44 24 20 11 54 24 74 89 C2 31 C0 89 54 24 24 8B 54 24 48 89 44 24 20 89 54 24 38 8B 44 24 38 01 44 24 20 8B 54 24 3C 11 54 24 24 8B 44 24 70 01 44 24 20 8B 54 24 74 11 54 24 24 8B 44 24 24 39 C2 72 16 77 0A 8B 54 24 20 39 54 24 70 76 0A 83 44 24 30 01 83 54 24 34 00 8B 44 24 18 F7 64 24 58 C7 44 24 3C 00 00 00 00 89 44 24 48 8B 44 24 18 89 54 24 4C F7 64 24 40 89 44 24 70 8B 44 24 08 89 54 24 74 F7 64 24 58 89 54 24 5C 8B 54 24 48 89 44 24 58 89 54 24 38 8B 54 24 5C 89 D0 31 D2 89 44 24 50 8B 44 24 08 89 54 24 54 F7 64 24 40 01 44 24 50 8B 44 24 38 11 54 24 54 01 44 24 50 8B 54 24 3C 11 54 24 54 8B 54 24 4C 89 D0 31 D2 89 44 24 48 8B 44 24 70 01 44 24 48 89 54 24 4C 8B 54 24 74 11 54 24 4C 8B 54 24 54 C7 44 24 74 00 00 00 00 89 D0 31 D2 01 44 24 48 8B 44 24 18 11 54 24 4C F7 64 24 60 89 44 24 38 8B 44 24 18 89 54 24 3C F7 E1 89 44 24 18 8B 44 24 08 89 54 24 1C F7 64 24 60 89 54 24 64 8B 54 24 38 89 44 24 60 89 54 24 70 8B 54 24 64 89 D0 31 D2 89 44 24 40 8B 44 24 08 89 54 24 44 F7 E1 01 44 24 40 11 54 24 44 8B 54 24 70 01 54 24 40 8B 54 24 3C 8B 4C 24 74 11 4C 24 44 8B 4C 24 1C 89 D0 31 D2 89 54 24 3C 8B 54 24 18 89 44 24 38 01 54 24 38 8B 54 24 44 11 4C 24 3C 89 D0 31 D2 01 44 24 38 8B 44 24 40 11 54 24 3C 89 C2 31 C0 89 44 24 40 8B 44 24 60 89 54 24 44 31 D2 01 44 24 40 11 54 24 44 8B 54 24 50 89 D1 31 D2 89 54 24 18 8B 44 24 58 31 D2 01 44 24 18 8B 44 24 38 89 4C 24 1C 11 54 24 1C 8B 54 24 3C 01 44 24 18 11 54 24 1C 8B 4C 24 1C 39 CA 72 14 77 08 8B 54 24 18 39 D0 76 0A 83 44 24 48 01 83 54 24 4C 00 8B 44 24 20 8B 54 24 24 03 44 24 40 13 54 24 44 39 54 24 44 89 44 24 20 89 54 24 24 C7 44 24 08 01 00 00 00 C7 44 24 0C 00 00 00 00 77 18 72 06 39 44 24 40 77 10 C7 44 24 08 00 00 00 00 C7 44 24 0C 00 00 00 00 8B 54 24 18 03 54 24 08 8B 4C 24 1C 13 4C 24 0C 89 54 24 38 8B 44 24 30 8B 54 24 34 03 44 24 38 89 4C 24 3C 13 54 24 3C 89 44 24 30 39 D1 89 54 24 34 0F 87 38 09 00 00 72 0A 39 44 24 38 0F 87 2C 09 00 00 8B 4C 24 3C 31 D2 B8 01 00 00 00 39 4C 24 0C 77 10 72 0A 8B 4C 24 38 39 4C 24 08 77 04 31 C0 31 D2 03 44 24 48 13 54 24 4C 89 D1 09 C1 75 5E 8B 44 24 34 0B 44 24 30 75 54 8B 54 24 68 8B 44 24 78 89 D1 31 D2 89 54 24 68 31 D2 01 44 24 68 8B 44 24 10 89 4C 24 6C 11 54 24 6C 8B 54 24 28 33 54 24 24 33 44 24 20 09 C2 0F 84 E3 0A 00 00 8B 44 24 24 39 44 24 28 72 14 0F 87 15 03 00 00 8B 54 24 20 39 54 24 10 0F 83 07 03 00 00 BA 01 00 00 00 89 D8 C1 E8 1F 31 D0 EB 09 83 0D ?? ?? ?? ?? 01 31 C0 8B 9C 24 AC 00 00 00 8B B4 24 B0 00 00 00 8B BC 24 B4 00 00 00 8B AC 24 B8 00 00 00 81 C4 BC 00 00 00 C3 8B 44 24 10 89 DA 33 44 24 08 31 CA 09 C2 0F 85 F4 F9 FF FF 31 C0 EB C5 8D B6 00 00 00 00 72 0E 81 7C 24 08 C0 87 AD BE 0F 87 14 FA FF FF 8B 54 24 18 8B 44 24 08 81 F2 09 ED 01 00 35 C0 87 AD BE 09 C2 0F 84 8B 02 00 00 89 C8 25 00 00 00 60 3D 00 00 00 60 0F 94 44 24 20 E9 E8 F9 FF FF 85 C9 78 B1 89 DA B8 01 00 00 00 81 E2 00 00 00 78 C1 EB 1F 81 FA 00 00 00 78 0F 44 C3 E9 5C FF FF FF 8B 54 24 28 8B 44 24 10 81 F2 09 ED 01 00 35 C0 87 AD BE 09 C2 0F 84 52 02 00 00 89 D8 25 00 00 00 60 3D 00 00 00 60 0F 94 44 24 30 E9 C2 F9 FF FF 8B 04 24 09 F8 0F 85 EF F9 FF FF 31 C0 84 D2 0F 85 16 FF FF FF 84 D2 75 13 89 C8 F7 D0 C1 E8 1F E9 06 FF FF FF 8D B4 26 00 00 00 00 89 D8 C1 E8 1F E9 F5 FE FF FF 8B 5C 24 28 39 5C 24 18 77 14 0F 82 76 02 00 00 8B 5C 24 10 39 5C 24 08 0F 86 68 02 00 00 BA 01 00 00 00 89 C8 C1 E8 1F 31 D0 E9 C6 FE FF FF 8B 0C C5 ?? ?? ?? ?? 8B 04 C5 ?? ?? ?? ?? C7 44 24 4C 00 00 00 00 89 44 24 40 F7 64 24 08 89 44 24 20 8B 44 24 40 89 54 24 24 F7 64 24 18 89 44 24 38 8B 44 24 08 89 54 24 3C F7 E1 89 54 24 0C 8B 54 24 20 89 44 24 08 89 54 24 48 8B 54 24 0C 89 D0 31 D2 89 44 24 30 8B 44 24 48 01 44 24 30 8B 44 24 18 89 54 24 34 8B 54 24 4C 11 54 24 34 F7 E1 01 44 24 30 11 54 24 34 8B 54 24 24 89 D0 31 D2 89 44 24 20 8B 44 24 38 01 44 24 20 89 54 24 24 8B 54 24 3C 11 54 24 24 8B 54 24 34 C7 44 24 54 00 00 00 00 89 D0 31 D2 01 44 24 20 8B 44 24 40 11 54 24 24 F7 E5 89 44 24 18 8B 44 24 40 89 54 24 1C F7 E6 89 44 24 40 89 C8 89 54 24 44 F7 E5 89 54 24 4C 8B 54 24 18 89 44 24 48 89 54 24 50 8B 54 24 4C 89 D0 31 D2 89 44 24 38 8B 44 24 50 01 44 24 38 89 C8 89 54 24 3C 8B 54 24 54 11 54 24 3C 8B 4C 24 1C F7 E6 01 44 24 38 11 54 24 3C 8B 44 24 40 89 CA 31 C9 89 54 24 18 8B 54 24 44 01 44 24 18 89 4C 24 1C 8B 4C 24 08 11 54 24 1C 8B 54 24 3C C7 44 24 34 00 00 00 00 89 D0 31 D2 01 44 24 18 8B 44 24 30 11 54 24 1C 89 4C 24 30 89 C2 31 C0 03 44 24 30 13 54 24 34 03 44 24 18 13 54 24 1C 39 54 24 1C 72 12 77 06 39 44 24 18 76 0A 83 44 24 20 01 83 54 24 24 00 8B 4C 24 24 0B 4C 24 20 0F 85 23 FD FF FF 8B 74 24 28 8B 4C 24 10 31 D6 31 C1 09 CE 0F 84 8C 07 00 00 39 54 24 28 0F 82 05 FD FF FF 77 0A 39 44 24 10 0F 82 F9 FC FF FF 31 D2 E9 F7 FC FF FF 81 FE 63 8E 8D 37 C6 44 24 20 01 0F 87 62 F7 FF FF E9 5F FD FF FF 8D 74 26 00 81 FF 63 8E 8D 37 C6 44 24 30 01 0F 87 75 F7 FF FF E9 98 FD FF FF 39 54 24 20 0F 8D BD FD FF FF 8B 44 24 28 39 44 24 18 73 0A 89 C8 C1 E8 1F E9 BB FC FF FF 77 0A 8B 44 24 10 39 44 24 08 72 EA 8B 44 24 18 33 44 24 28 89 44 24 30 8B 44 24 08 33 44 24 10 0B 44 24 30 0F 85 EF F7 FF FF 39 F7 0F 82 E7 F7 FF FF 0F 87 D7 F7 FF FF 39 2C 24 90 0F 86 D7 F7 FF FF E9 C8 F7 FF FF 90 8D 74 26 00 8B 54 24 18 8B 44 24 08 33 54 24 28 33 44 24 10 09 C2 74 07 31 D2 E9 82 FD FF FF 39 F7 77 F5 90 0F 82 72 FD FF FF 39 2C 24 0F 86 69 FD FF FF 31 D2 E9 67 FD FF FF 89 D0 2B 44 24 20 83 F8 21 0F 8F 65 FF FF FF 83 F8 13 0F 8E B5 04 00 00 8D 58 EC C1 E3 04 8B 83 ?? ?? ?? ?? 8B 93 ?? ?? ?? ?? C7 44 24 54 00 00 00 00 89 44 24 48 89 54 24 40 F7 E7 89 44 24 30 8B 44 24 40 89 54 24 34 F7 E7 89 44 24 58 8B 44 24 48 89 54 24 5C F7 24 24 89 54 24 3C 8B 54 24 30 89 44 24 38 89 54 24 50 8B 54 24 3C 89 D0 31 D2 89 44 24 20 8B 44 24 50 01 44 24 20 8B 44 24 40 89 54 24 24 8B 54 24 54 11 54 24 24 F7 24 24 01 44 24 20 11 54 24 24 8B 54 24 34 89 D0 31 D2 89 44 24 30 8B 44 24 58 01 44 24 30 89 54 24 34 8B 54 24 5C 11 54 24 34 8B 54 24 24 C7 44 24 7C 00 00 00 00 89 D0 31 D2 01 44 24 30 11 54 24 34 8B 93 ?? ?? ?? ?? 8B 9B ?? ?? ?? ?? 89 D0 89 54 24 58 F7 E7 89 44 24 60 89 D8 89 54 24 64 F7 E7 89 44 24 50 8B 44 24 58 89 54 24 54 F7 24 24 89 54 24 74 8B 54 24 60 89 44 24 70 89 54 24 78 8B 54 24 74 89 D0 31 D2 89 44 24 68 8B 44 24 78 89 54 24 6C 8B 54 24 7C 01 44 24 68 8B 04 24 11 54 24 6C C7 44 24 04 00 00 00 00 F7 E3 01 44 24 68 11 54 24 6C 8B 54 24 64 89 D0 31 D2 89 44 24 60 8B 44 24 50 01 44 24 60 89 54 24 64 8B 54 24 54 11 54 24 64 8B 54 24 6C 89 D0 31 D2 01 44 24 60 8B 44 24 20 11 54 24 64 89 C2 31 C0 89 54 24 24 8B 54 24 38 89 44 24 20 89 14 24 8B 04 24 8B 54 24 04 01 44 24 20 8B 44 24 60 11 54 24 24 01 44 24 20 8B 54 24 64 11 54 24 24 8B 44 24 24 39 C2 72 16 77 0A 8B 54 24 20 39 54 24 60 76 0A 83 44 24 30 01 83 54 24 34 00 8B 44 24 28 F7 64 24 48 C7 44 24 04 00 00 00 00 89 44 24 38 8B 44 24 28 89 54 24 3C F7 64 24 40 89 44 24 50 8B 44 24 10 89 54 24 54 F7 64 24 48 89 54 24 4C 8B 54 24 38 89 44 24 48 89 14 24 8B 54 24 4C 89 D0 31 D2 89 44 24 60 8B 44 24 10 89 54 24 64 F7 64 24 40 01 44 24 60 8B 04 24 11 54 24 64 01 44 24 60 8B 54 24 04 11 54 24 64 8B 54 24 3C 89 D0 31 D2 89 44 24 38 8B 44 24 50 01 44 24 38 89 54 24 3C 8B 54 24 54 11 54 24 3C 8B 54 24 64 C7 44 24 54 00 00 00 00 89 D0 31 D2 01 44 24 38 8B 44 24 28 11 54 24 3C F7 64 24 58 89 44 24 40 8B 44 24 28 89 54 24 44 F7 E3 89 44 24 28 8B 44 24 10 89 54 24 2C F7 64 24 58 89 54 24 5C 8B 54 24 40 89 44 24 58 89 54 24 50 8B 54 24 5C 89 D0 31 D2 89 04 24 8B 44 24 10 89 54 24 04 F7 E3 01 04 24 11 54 24 04 8B 44 24 50 01 04 24 8B 54 24 54 11 54 24 04 8B 54 24 44 89 D0 31 D2 89 44 24 40 8B 44 24 28 01 44 24 40 89 54 24 44 8B 54 24 2C 11 54 24 44 8B 54 24 04 89 D0 31 D2 01 44 24 40 8B 04 24 11 54 24 44 89 C2 31 C0 89 04 24 8B 44 24 58 89 54 24 04 31 D2 01 04 24 8B 44 24 60 11 54 24 04 89 C2 31 C0 89 44 24 28 8B 44 24 48 89 54 24 2C 31 D2 01 44 24 28 8B 44 24 40 11 54 24 2C 8B 54 24 44 01 44 24 28 11 54 24 2C 8B 5C 24 2C 39 DA 72 14 77 08 8B 54 24 28 39 D0 76 0A 83 44 24 38 01 83 54 24 3C 00 8B 44 24 20 8B 54 24 24 03 04 24 13 54 24 04 39 54 24 04 89 44 24 20 89 54 24 24 C7 44 24 10 01 00 00 00 C7 44 24 14 00 00 00 00 77 17 72 05 39 04 24 77 10 C7 44 24 10 00 00 00 00 C7 44 24 14 00 00 00 00 8B 44 24 28 8B 54 24 2C 03 44 24 10 13 54 24 14 89 44 24 28 8B 44 24 30 89 54 24 2C 8B 54 24 34 03 44 24 28 13 54 24 2C 39 54 24 2C 89 44 24 30 89 54 24 34 0F 87 B1 02 00 00 72 0A 39 44 24 28 0F 87 A5 02 00 00 8B 5C 24 2C 31 D2 B8 01 00 00 00 39 5C 24 14 77 10 72 0A 8B 5C 24 28 39 5C 24 10 77 04 31 C0 31 D2 03 44 24 38 13 54 24 3C 89 D3 09 C3 75 48 8B 44 24 34 0B 44 24 30 75 3E 8B 5C 24 70 8B 44 24 68 C7 44 24 04 00 00 00 00 89 1C 24 8B 5C 24 24 89 C2 31 C0 03 04 24 13 54 24 04 39 5C 24 18 74 29 8B 44 24 24 39 44 24 18 72 0C 77 39 8B 54 24 20 39 54 24 08 73 2F BA 01 00 00 00 89 C8 F7 D0 C1 E8 1F 31 D0 E9 C1 F7 FF FF 8B 5C 24 20 39 5C 24 08 75 CD 39 F2 0F 84 FD 02 00 00 39 F2 72 06 77 D5 39 E8 77 D1 31 D2 8D 74 26 00 EB CE 39 F7 73 0F 39 54 24 20 0F 8C FE FA FF FF E9 78 F8 FF FF 0F 87 D8 F2 FF FF 39 2C 24 66 90 72 E4 E9 E7 FA FF FF B8 01 00 00 00 31 D2 E9 E9 F6 FF FF 8B 0C C5 ?? ?? ?? ?? 8B 04 C5 ?? ?? ?? ?? C7 44 24 4C 00 00 00 00 89 44 24 40 F7 64 24 10 89 44 24 20 8B 44 24 40 89 54 24 24 F7 64 24 28 89 44 24 38 8B 44 24 10 89 54 24 3C F7 E1 89 54 24 14 8B 54 24 20 89 44 24 10 89 54 24 48 8B 54 24 14 89 D0 31 D2 89 44 24 30 8B 44 24 48 01 44 24 30 8B 44 24 28 89 54 24 34 8B 54 24 4C 11 54 24 34 F7 E1 01 44 24 30 11 54 24 34 8B 54 24 24 89 D0 31 D2 89 44 24 20 8B 44 24 38 01 44 24 20 89 54 24 24 8B 54 24 3C 11 54 24 24 8B 54 24 34 C7 44 24 4C 00 00 00 00 89 D0 31 D2 01 44 24 20 8B 44 24 40 11 54 24 24 F7 24 24 89 44 24 28 8B 44 24 40 89 54 24 2C F7 E7 89 44 24 40 8B 04 24 89 54 24 44 F7 E1 89 54 24 04 8B 54 24 28 89 04 24 89 54 24 48 8B 54 24 04 89 D0 31 D2 89 44 24 38 8B 44 24 48 01 44 24 38 89 C8 89 54 24 3C }
	condition:
		$1
}

rule file_45_13_0 {
	meta:
		name = "___bid128_signaling_greater_equal"
		size = 4576
		refs = "01d0 ___bid_ten2k128 0642 ___bid_IDEC_glbflags 07ab ___bid_ten2k64"
	strings:
		$1 = { 81 EC BC 00 00 00 8B 8C 24 C8 00 00 00 89 9C 24 AC 00 00 00 8B 9C 24 D0 00 00 00 89 B4 24 B0 00 00 00 8B B4 24 C4 00 00 00 89 BC 24 B4 00 00 00 8B BC 24 D4 00 00 00 89 4C 24 08 8B 8C 24 CC 00 00 00 89 1C 24 8B 9C 24 D8 00 00 00 89 AC 24 B8 00 00 00 8B AC 24 C0 00 00 00 89 C8 25 00 00 00 7C 3D 00 00 00 7C 89 5C 24 10 8B 9C 24 DC 00 00 00 0F 84 C9 05 00 00 89 D8 25 00 00 00 7C 3D 00 00 00 7C 0F 84 B7 05 00 00 8B 04 24 89 FA 31 F2 31 E8 09 C2 0F 84 D6 05 00 00 89 C8 25 00 00 00 78 3D 00 00 00 78 0F 84 25 06 00 00 89 D8 25 00 00 00 78 3D 00 00 00 78 0F 84 A2 06 00 00 89 C8 25 FF FF 01 00 3D 09 ED 01 00 89 44 24 18 0F 86 BC 05 00 00 C6 44 24 28 01 89 DA 81 E2 FF FF 01 00 81 FA 09 ED 01 00 89 54 24 20 77 14 0F 82 0D 06 00 00 81 7C 24 10 C0 87 AD BE 0F 86 FF 05 00 00 C6 44 24 30 01 80 7C 24 28 00 BA 01 00 00 00 75 13 8B 44 24 18 31 D2 0B 44 24 08 75 07 89 EA 09 F2 0F 94 C2 80 7C 24 30 00 0F 85 0C 06 00 00 8B 44 24 20 0B 44 24 10 0F 84 F3 05 00 00 84 D2 0F 85 1A 06 00 00 89 CA 31 DA 0F 88 10 06 00 00 89 C8 89 DA C1 E8 11 C1 EA 11 25 FF 3F 00 00 81 E2 FF 3F 00 00 39 C2 89 44 24 30 0F 84 F9 05 00 00 8B 44 24 20 39 44 24 18 0F 83 17 08 00 00 39 F7 72 13 77 05 39 2C 24 72 0C 39 54 24 30 66 90 0F 8C FA 0E 00 00 8B 44 24 30 29 D0 85 C0 89 44 24 28 0F 8E 9E 08 00 00 83 F8 21 0F 8F 9C 05 00 00 83 7C 24 28 13 0F 8E 0C 0D 00 00 8B 4C 24 28 C7 44 24 54 00 00 00 00 83 E9 14 C1 E1 04 8B 91 ?? ?? ?? ?? 8B 81 ?? ?? ?? ?? 89 54 24 58 89 44 24 40 89 D0 F7 E6 89 44 24 38 8B 44 24 40 89 54 24 3C F7 E6 89 44 24 30 8B 44 24 58 89 54 24 34 F7 E5 89 54 24 4C 8B 54 24 38 89 44 24 48 89 54 24 50 8B 54 24 4C 89 D0 31 D2 89 44 24 28 8B 44 24 50 01 44 24 28 8B 44 24 40 89 54 24 2C 8B 54 24 54 11 54 24 2C F7 E5 01 44 24 28 11 54 24 2C 8B 54 24 3C 89 D0 31 D2 89 44 24 38 8B 44 24 30 01 44 24 38 89 54 24 3C 8B 54 24 34 11 54 24 3C 8B 54 24 2C C7 44 24 74 00 00 00 00 89 D0 31 D2 01 44 24 38 11 54 24 3C 8B 91 ?? ?? ?? ?? 8B 89 ?? ?? ?? ?? 89 D0 89 54 24 60 F7 E6 89 44 24 30 89 C8 89 54 24 34 F7 E6 89 44 24 50 8B 44 24 60 89 54 24 54 F7 E5 89 54 24 7C 8B 54 24 30 89 44 24 78 89 54 24 70 8B 54 24 7C 89 D0 31 D2 89 44 24 68 8B 44 24 70 01 44 24 68 89 C8 89 54 24 6C 8B 54 24 74 11 54 24 6C F7 E5 01 44 24 68 11 54 24 6C 8B 54 24 34 C7 44 24 34 00 00 00 00 89 D0 31 D2 89 44 24 70 8B 44 24 50 01 44 24 70 89 54 24 74 8B 54 24 54 11 54 24 74 8B 54 24 6C 89 D0 31 D2 01 44 24 70 8B 44 24 28 11 54 24 74 89 C2 31 C0 89 54 24 2C 8B 54 24 48 89 44 24 28 89 54 24 30 8B 44 24 30 01 44 24 28 8B 54 24 34 11 54 24 2C 8B 44 24 70 01 44 24 28 8B 54 24 74 11 54 24 2C 8B 44 24 2C 39 C2 72 16 77 0A 8B 54 24 28 39 54 24 70 76 0A 83 44 24 38 01 83 54 24 3C 00 8B 44 24 18 F7 64 24 58 C7 44 24 34 00 00 00 00 89 44 24 48 8B 44 24 18 89 54 24 4C F7 64 24 40 89 44 24 70 8B 44 24 08 89 54 24 74 F7 64 24 58 89 54 24 5C 8B 54 24 48 89 44 24 58 89 54 24 30 8B 54 24 5C 89 D0 31 D2 89 44 24 50 8B 44 24 08 89 54 24 54 F7 64 24 40 01 44 24 50 8B 44 24 30 11 54 24 54 01 44 24 50 8B 54 24 34 11 54 24 54 8B 54 24 4C 89 D0 31 D2 89 44 24 48 8B 44 24 70 01 44 24 48 89 54 24 4C 8B 54 24 74 11 54 24 4C 8B 54 24 54 C7 44 24 74 00 00 00 00 89 D0 31 D2 01 44 24 48 8B 44 24 18 11 54 24 4C F7 64 24 60 89 44 24 30 8B 44 24 18 89 54 24 34 F7 E1 89 44 24 18 8B 44 24 08 89 54 24 1C F7 64 24 60 89 54 24 64 8B 54 24 30 89 44 24 60 89 54 24 70 8B 54 24 64 89 D0 31 D2 89 44 24 40 8B 44 24 08 89 54 24 44 F7 E1 01 44 24 40 11 54 24 44 8B 54 24 70 01 54 24 40 8B 54 24 34 8B 4C 24 74 11 4C 24 44 8B 4C 24 1C 89 D0 31 D2 89 54 24 34 8B 54 24 18 89 44 24 30 01 54 24 30 8B 54 24 44 11 4C 24 34 89 D0 31 D2 01 44 24 30 8B 44 24 40 11 54 24 34 89 C2 31 C0 89 44 24 40 8B 44 24 60 89 54 24 44 31 D2 01 44 24 40 11 54 24 44 8B 54 24 50 89 D1 31 D2 89 54 24 18 8B 44 24 58 31 D2 01 44 24 18 8B 44 24 30 89 4C 24 1C 11 54 24 1C 8B 54 24 34 01 44 24 18 11 54 24 1C 8B 4C 24 1C 39 CA 72 14 77 08 8B 54 24 18 39 D0 76 0A 83 44 24 48 01 83 54 24 4C 00 8B 44 24 28 8B 54 24 2C 03 44 24 40 13 54 24 44 39 54 24 44 89 44 24 28 89 54 24 2C C7 44 24 08 01 00 00 00 C7 44 24 0C 00 00 00 00 77 18 72 06 39 44 24 40 77 10 C7 44 24 08 00 00 00 00 C7 44 24 0C 00 00 00 00 8B 54 24 18 03 54 24 08 8B 4C 24 1C 13 4C 24 0C 89 54 24 30 8B 44 24 38 8B 54 24 3C 03 44 24 30 89 4C 24 34 13 54 24 34 89 44 24 38 39 D1 89 54 24 3C 0F 87 08 0B 00 00 72 0A 39 44 24 30 0F 87 FC 0A 00 00 8B 4C 24 34 31 D2 B8 01 00 00 00 39 4C 24 0C 77 10 72 0A 8B 4C 24 30 39 4C 24 08 77 04 31 C0 31 D2 03 44 24 48 13 54 24 4C 89 D1 09 C1 75 5E 8B 44 24 3C 0B 44 24 38 75 54 8B 54 24 68 8B 44 24 78 89 D1 31 D2 89 54 24 68 31 D2 01 44 24 68 8B 44 24 10 89 4C 24 6C 11 54 24 6C 8B 54 24 20 33 54 24 2C 33 44 24 28 09 C2 0F 84 F8 0A 00 00 8B 44 24 2C 39 44 24 20 72 14 0F 87 40 03 00 00 8B 54 24 28 39 54 24 10 0F 83 32 03 00 00 BA 01 00 00 00 89 D8 C1 E8 1F 31 D0 EB 10 8D B4 26 00 00 00 00 83 0D ?? ?? ?? ?? 01 31 C0 8B 9C 24 AC 00 00 00 8B B4 24 B0 00 00 00 8B BC 24 B4 00 00 00 8B AC 24 B8 00 00 00 81 C4 BC 00 00 00 C3 8D 74 26 00 8B 44 24 10 89 DA 33 44 24 08 31 CA 09 C2 0F 85 16 FA FF FF B8 01 00 00 00 EB BE 90 8D 74 26 00 72 0E 81 7C 24 08 C0 87 AD BE 0F 87 34 FA FF FF 8B 54 24 18 8B 44 24 08 81 F2 09 ED 01 00 35 C0 87 AD BE 09 C2 0F 84 C5 02 00 00 89 C8 25 00 00 00 60 3D 00 00 00 60 0F 94 44 24 28 E9 08 FA FF FF 85 C9 B8 01 00 00 00 0F 89 6B FF FF FF 89 DA 81 E2 00 00 00 78 81 FA 00 00 00 78 0F 84 A7 00 00 00 31 C0 E9 50 FF FF FF 8D B4 26 00 00 00 00 8B 54 24 20 8B 44 24 10 81 F2 09 ED 01 00 35 C0 87 AD BE 09 C2 0F 84 4A 02 00 00 89 D8 25 00 00 00 60 3D 00 00 00 60 0F 94 44 24 30 E9 D5 F9 FF FF 8B 04 24 09 F8 0F 85 02 FA FF FF 84 D2 B8 01 00 00 00 0F 85 00 FF FF FF 84 D2 75 13 89 C8 F7 D0 C1 E8 1F E9 F0 FE FF FF 8D B4 26 00 00 00 00 89 D8 C1 E8 1F E9 DF FE FF FF 8B 5C 24 20 39 5C 24 18 77 14 0F 82 93 02 00 00 8B 5C 24 10 39 5C 24 08 0F 86 85 02 00 00 BA 01 00 00 00 89 C8 C1 E8 1F 31 D0 E9 B0 FE FF FF 85 DB 0F 88 A8 FE FF FF 31 C0 E9 A1 FE FF FF 8B 0C D5 ?? ?? ?? ?? 8B 14 D5 ?? ?? ?? ?? C7 44 24 4C 00 00 00 00 89 54 24 40 89 D0 F7 64 24 10 89 44 24 28 8B 44 24 40 89 54 24 2C F7 64 24 20 89 44 24 30 8B 44 24 10 89 54 24 34 F7 E1 89 54 24 14 8B 54 24 28 89 44 24 10 89 54 24 48 8B 54 24 14 89 D0 31 D2 89 44 24 38 8B 44 24 48 01 44 24 38 8B 44 24 20 89 54 24 3C 8B 54 24 4C 11 54 24 3C F7 E1 01 44 24 38 11 54 24 3C 8B 54 24 2C 89 D0 31 D2 89 44 24 28 8B 44 24 30 01 44 24 28 89 54 24 2C 8B 54 24 34 11 54 24 2C 8B 54 24 3C C7 44 24 4C 00 00 00 00 89 D0 31 D2 01 44 24 28 8B 44 24 40 11 54 24 2C F7 24 24 89 44 24 20 8B 44 24 40 89 54 24 24 F7 E7 89 44 24 40 8B 04 24 89 54 24 44 F7 E1 89 54 24 04 8B 54 24 20 89 04 24 89 54 24 48 8B 54 24 04 89 D0 31 D2 89 44 24 30 8B 44 24 48 01 44 24 30 89 C8 89 54 24 34 8B 54 24 4C 11 54 24 34 8B 4C 24 24 F7 E7 01 44 24 30 11 54 24 34 8B 44 24 40 89 CA 31 C9 89 54 24 20 8B 54 24 44 01 44 24 20 89 4C 24 24 8B 4C 24 10 11 54 24 24 8B 54 24 34 C7 44 24 3C 00 00 00 00 89 D0 31 D2 01 44 24 20 8B 44 24 38 11 54 24 24 89 4C 24 38 89 C2 31 C0 03 44 24 38 13 54 24 3C 03 44 24 20 13 54 24 24 39 54 24 24 72 12 77 06 39 44 24 20 76 0A 83 44 24 28 01 83 54 24 2C 00 8B 4C 24 2C 0B 4C 24 28 75 2A 8B 7C 24 18 8B 4C 24 08 31 D7 31 C1 09 CF 0F 84 EE 07 00 00 39 54 24 18 0F 87 DA FC FF FF 72 0A 39 44 24 08 0F 87 CE FC FF FF 31 D2 90 E9 CB FC FF FF 81 FF 63 8E 8D 37 C6 44 24 30 01 0F 87 90 F7 FF FF E9 A0 FD FF FF 90 8D 74 26 00 81 FE 63 8E 8D 37 C6 44 24 28 01 0F 87 48 F7 FF FF E9 25 FD FF FF 77 0E 8B 44 24 10 39 44 24 08 0F 82 D9 F7 FF FF 39 F7 76 27 8B 44 24 20 39 44 24 18 0F 82 D2 F7 FF FF 0F 87 D8 F7 FF FF 8B 44 24 10 39 44 24 08 0F 86 BE F7 FF FF E9 C5 F7 FF FF 72 05 39 2C 24 77 D2 39 54 24 30 8D 74 26 00 0F 8F 67 FD FF FF 8B 44 24 20 39 44 24 18 0F 87 A2 F7 FF FF 0F 82 85 F7 FF FF 8B 44 24 10 39 44 24 08 0F 87 8E F7 FF FF E9 72 F7 FF FF 8B 54 24 18 8B 44 24 08 33 54 24 20 33 44 24 10 09 C2 74 07 31 D2 E9 65 FD FF FF 39 F7 77 F5 8D 74 26 00 0F 82 52 FD FF FF 39 2C 24 0F 86 49 FD FF FF 31 D2 E9 47 FD FF FF 2B 54 24 30 83 FA 21 0F 8F 3D 06 00 00 83 FA 13 0F 8E 4C FD FF FF 8D 5A EC C1 E3 04 8B 83 ?? ?? ?? ?? 8B 93 ?? ?? ?? ?? C7 44 24 54 00 00 00 00 89 44 24 48 89 54 24 40 F7 E7 89 44 24 38 8B 44 24 40 89 54 24 3C F7 E7 89 44 24 58 8B 44 24 48 89 54 24 5C F7 24 24 89 54 24 34 8B 54 24 38 89 44 24 30 89 54 24 50 8B 54 24 34 89 D0 31 D2 89 44 24 28 8B 44 24 50 01 44 24 28 8B 44 24 40 89 54 24 2C 8B 54 24 54 11 54 24 2C F7 24 24 01 44 24 28 11 54 24 2C 8B 54 24 3C 89 D0 31 D2 89 44 24 38 8B 44 24 58 01 44 24 38 89 54 24 3C 8B 54 24 5C 11 54 24 3C 8B 54 24 2C C7 44 24 7C 00 00 00 00 89 D0 31 D2 01 44 24 38 11 54 24 3C 8B 93 ?? ?? ?? ?? 8B 9B ?? ?? ?? ?? 89 D0 89 54 24 58 F7 E7 89 44 24 60 89 D8 89 54 24 64 F7 E7 89 44 24 50 8B 44 24 58 89 54 24 54 F7 24 24 89 54 24 74 8B 54 24 60 89 44 24 70 89 54 24 78 8B 54 24 74 89 D0 31 D2 89 44 24 68 8B 44 24 78 89 54 24 6C 8B 54 24 7C 01 44 24 68 8B 04 24 11 54 24 6C C7 44 24 04 00 00 00 00 F7 E3 01 44 24 68 11 54 24 6C 8B 54 24 64 89 D0 31 D2 89 44 24 60 8B 44 24 50 01 44 24 60 89 54 24 64 8B 54 24 54 11 54 24 64 8B 54 24 6C 89 D0 31 D2 01 44 24 60 8B 44 24 28 11 54 24 64 89 C2 31 C0 89 54 24 2C 8B 54 24 30 89 44 24 28 89 14 24 8B 04 24 8B 54 24 04 01 44 24 28 8B 44 24 60 11 54 24 2C 01 44 24 28 8B 54 24 64 11 54 24 2C 8B 44 24 2C 39 C2 72 16 77 0A 8B 54 24 28 39 54 24 60 76 0A 83 44 24 38 01 83 54 24 3C 00 8B 44 24 20 F7 64 24 48 C7 44 24 04 00 00 00 00 89 44 24 30 8B 44 24 20 89 54 24 34 F7 64 24 40 89 44 24 50 8B 44 24 10 89 54 24 54 F7 64 24 48 89 54 24 4C 8B 54 24 30 89 44 24 48 89 14 24 8B 54 24 4C 89 D0 31 D2 89 44 24 60 8B 44 24 10 89 54 24 64 F7 64 24 40 01 44 24 60 8B 04 24 11 54 24 64 01 44 24 60 8B 54 24 04 11 54 24 64 8B 54 24 34 89 D0 31 D2 89 44 24 30 8B 44 24 50 01 44 24 30 89 54 24 34 8B 54 24 54 11 54 24 34 8B 54 24 64 C7 44 24 54 00 00 00 00 89 D0 31 D2 01 44 24 30 8B 44 24 20 11 54 24 34 F7 64 24 58 89 44 24 40 8B 44 24 20 89 54 24 44 F7 E3 89 44 24 20 8B 44 24 10 89 54 24 24 F7 64 24 58 89 54 24 5C 8B 54 24 40 89 44 24 58 89 54 24 50 8B 54 24 5C 89 D0 31 D2 89 04 24 8B 44 24 10 89 54 24 04 F7 E3 01 04 24 11 54 24 04 8B 44 24 50 01 04 24 8B 54 24 54 11 54 24 04 8B 54 24 44 89 D0 31 D2 89 44 24 40 8B 44 24 20 01 44 24 40 89 54 24 44 8B 54 24 24 11 54 24 44 8B 54 24 04 89 D0 31 D2 01 44 24 40 8B 04 24 11 54 24 44 89 C2 31 C0 89 04 24 8B 44 24 58 89 54 24 04 31 D2 01 04 24 8B 44 24 60 11 54 24 04 89 C2 31 C0 89 44 24 20 8B 44 24 48 89 54 24 24 31 D2 01 44 24 20 8B 44 24 40 11 54 24 24 8B 54 24 44 01 44 24 20 11 54 24 24 8B 5C 24 24 39 DA 72 14 77 08 8B 54 24 20 39 D0 76 0A 83 44 24 30 01 83 54 24 34 00 8B 44 24 28 8B 54 24 2C 03 04 24 13 54 24 04 39 54 24 04 89 44 24 28 89 54 24 2C C7 44 24 10 01 00 00 00 C7 44 24 14 00 00 00 00 77 17 72 05 39 04 24 77 10 C7 44 24 10 00 00 00 00 C7 44 24 14 00 00 00 00 8B 44 24 20 8B 54 24 24 03 44 24 10 13 54 24 14 89 44 24 20 8B 44 24 38 89 54 24 24 8B 54 24 3C 03 44 24 20 13 54 24 24 39 54 24 24 89 44 24 38 89 54 24 3C 0F 87 80 02 00 00 72 0A 39 44 24 20 0F 87 74 02 00 00 8B 5C 24 24 31 D2 B8 01 00 00 00 39 5C 24 14 77 10 72 0A 8B 5C 24 20 39 5C 24 10 77 04 31 C0 31 D2 03 44 24 30 13 54 24 34 89 D3 09 C3 0F 85 BC FB FF FF 8B 44 24 3C 0B 44 24 38 0F 85 AE FB FF FF 8B 5C 24 70 8B 44 24 68 C7 44 24 04 00 00 00 00 89 1C 24 8B 5C 24 2C 89 C2 31 C0 03 04 24 13 54 24 04 39 5C 24 18 0F 84 D6 02 00 00 8B 44 24 2C 39 44 24 18 0F 82 74 FB FF FF 0F 87 D5 F8 FF FF 8B 54 24 28 39 54 24 08 0F 87 C7 F8 FF FF 31 D2 E9 C5 F8 FF FF 8B 44 24 28 C7 44 24 4C 00 00 00 00 8B 14 C5 ?? ?? ?? ?? 8B 0C C5 ?? ?? ?? ?? 89 54 24 40 89 D0 F7 64 24 08 89 44 24 28 8B 44 24 40 89 54 24 2C F7 64 24 18 89 44 24 30 8B 44 24 08 89 54 24 34 F7 E1 89 54 24 0C 8B 54 24 28 89 44 24 08 89 54 24 48 8B 54 24 0C 89 D0 31 D2 89 44 24 38 8B 44 24 48 01 44 24 38 8B 44 24 18 89 54 24 3C 8B 54 24 4C 11 54 24 3C F7 E1 01 44 24 38 11 54 24 3C 8B 54 24 2C 89 D0 31 D2 89 44 24 28 8B 44 24 30 01 44 24 28 89 54 24 2C 8B 54 24 34 11 54 24 2C 8B 54 24 3C C7 44 24 54 00 00 00 00 89 D0 31 D2 01 44 24 28 8B 44 24 40 11 54 24 2C F7 E5 89 44 24 18 8B 44 24 40 89 54 24 1C F7 E6 89 44 24 40 89 C8 89 54 24 44 F7 E5 89 54 24 4C 8B 54 24 18 89 44 24 48 89 54 24 50 8B 54 24 4C 89 D0 31 D2 89 44 24 30 8B 44 24 50 01 44 24 30 89 C8 89 54 24 34 8B 54 24 54 11 54 24 34 8B 4C 24 1C F7 E6 01 44 24 30 11 54 24 34 8B 44 24 40 89 CA 31 C9 89 54 24 18 8B 54 24 44 01 44 24 18 89 4C 24 1C 8B 4C 24 08 11 54 24 1C }
	condition:
		$1
}

rule file_45_14_0 {
	meta:
		name = "___bid128_signaling_greater_unordered"
		size = 4528
		refs = "01d0 ___bid_ten2k128 0642 ___bid_IDEC_glbflags 0784 ___bid_ten2k64"
	strings:
		$1 = { 81 EC BC 00 00 00 8B 8C 24 C8 00 00 00 89 9C 24 AC 00 00 00 8B 9C 24 D0 00 00 00 89 B4 24 B0 00 00 00 8B B4 24 C4 00 00 00 89 BC 24 B4 00 00 00 8B BC 24 D4 00 00 00 89 4C 24 08 8B 8C 24 CC 00 00 00 89 1C 24 8B 9C 24 D8 00 00 00 89 AC 24 B8 00 00 00 8B AC 24 C0 00 00 00 89 C8 25 00 00 00 7C 3D 00 00 00 7C 89 5C 24 10 8B 9C 24 DC 00 00 00 0F 84 C9 05 00 00 89 D8 25 00 00 00 7C 3D 00 00 00 7C 0F 84 B7 05 00 00 8B 04 24 89 FA 31 F2 31 E8 09 C2 0F 84 D6 05 00 00 89 C8 25 00 00 00 78 3D 00 00 00 78 0F 84 24 06 00 00 89 D8 25 00 00 00 78 3D 00 00 00 78 0F 84 8A 06 00 00 89 C8 25 FF FF 01 00 3D 09 ED 01 00 89 44 24 18 0F 86 B4 05 00 00 C6 44 24 28 01 89 DA 81 E2 FF FF 01 00 81 FA 09 ED 01 00 89 54 24 20 77 14 0F 82 FF 05 00 00 81 7C 24 10 C0 87 AD BE 0F 86 F1 05 00 00 C6 44 24 30 01 80 7C 24 28 00 BA 01 00 00 00 75 13 8B 44 24 18 31 D2 0B 44 24 08 75 07 89 EA 09 F2 0F 94 C2 80 7C 24 30 00 0F 85 FE 05 00 00 8B 44 24 20 0B 44 24 10 0F 84 E5 05 00 00 84 D2 0F 85 02 06 00 00 89 CA 31 DA 0F 88 F8 05 00 00 89 C8 89 DA C1 E8 11 C1 EA 11 25 FF 3F 00 00 81 E2 FF 3F 00 00 39 C2 89 44 24 30 0F 84 E1 05 00 00 8B 44 24 20 39 44 24 18 0F 83 F1 07 00 00 39 F7 72 13 77 05 39 2C 24 72 0C 39 54 24 30 66 90 0F 8C CF 0E 00 00 8B 44 24 30 29 D0 85 C0 89 44 24 28 0F 8E 78 08 00 00 83 F8 21 0F 8F 8B 05 00 00 83 7C 24 28 13 0F 8E E6 0C 00 00 8B 4C 24 28 C7 44 24 54 00 00 00 00 83 E9 14 C1 E1 04 8B 91 ?? ?? ?? ?? 8B 81 ?? ?? ?? ?? 89 54 24 58 89 44 24 40 89 D0 F7 E6 89 44 24 38 8B 44 24 40 89 54 24 3C F7 E6 89 44 24 30 8B 44 24 58 89 54 24 34 F7 E5 89 54 24 4C 8B 54 24 38 89 44 24 48 89 54 24 50 8B 54 24 4C 89 D0 31 D2 89 44 24 28 8B 44 24 50 01 44 24 28 8B 44 24 40 89 54 24 2C 8B 54 24 54 11 54 24 2C F7 E5 01 44 24 28 11 54 24 2C 8B 54 24 3C 89 D0 31 D2 89 44 24 38 8B 44 24 30 01 44 24 38 89 54 24 3C 8B 54 24 34 11 54 24 3C 8B 54 24 2C C7 44 24 74 00 00 00 00 89 D0 31 D2 01 44 24 38 11 54 24 3C 8B 91 ?? ?? ?? ?? 8B 89 ?? ?? ?? ?? 89 D0 89 54 24 60 F7 E6 89 44 24 30 89 C8 89 54 24 34 F7 E6 89 44 24 50 8B 44 24 60 89 54 24 54 F7 E5 89 54 24 7C 8B 54 24 30 89 44 24 78 89 54 24 70 8B 54 24 7C 89 D0 31 D2 89 44 24 68 8B 44 24 70 01 44 24 68 89 C8 89 54 24 6C 8B 54 24 74 11 54 24 6C F7 E5 01 44 24 68 11 54 24 6C 8B 54 24 34 C7 44 24 34 00 00 00 00 89 D0 31 D2 89 44 24 70 8B 44 24 50 01 44 24 70 89 54 24 74 8B 54 24 54 11 54 24 74 8B 54 24 6C 89 D0 31 D2 01 44 24 70 8B 44 24 28 11 54 24 74 89 C2 31 C0 89 54 24 2C 8B 54 24 48 89 44 24 28 89 54 24 30 8B 44 24 30 01 44 24 28 8B 54 24 34 11 54 24 2C 8B 44 24 70 01 44 24 28 8B 54 24 74 11 54 24 2C 8B 44 24 2C 39 C2 72 16 77 0A 8B 54 24 28 39 54 24 70 76 0A 83 44 24 38 01 83 54 24 3C 00 8B 44 24 18 F7 64 24 58 C7 44 24 34 00 00 00 00 89 44 24 48 8B 44 24 18 89 54 24 4C F7 64 24 40 89 44 24 70 8B 44 24 08 89 54 24 74 F7 64 24 58 89 54 24 5C 8B 54 24 48 89 44 24 58 89 54 24 30 8B 54 24 5C 89 D0 31 D2 89 44 24 50 8B 44 24 08 89 54 24 54 F7 64 24 40 01 44 24 50 8B 44 24 30 11 54 24 54 01 44 24 50 8B 54 24 34 11 54 24 54 8B 54 24 4C 89 D0 31 D2 89 44 24 48 8B 44 24 70 01 44 24 48 89 54 24 4C 8B 54 24 74 11 54 24 4C 8B 54 24 54 C7 44 24 74 00 00 00 00 89 D0 31 D2 01 44 24 48 8B 44 24 18 11 54 24 4C F7 64 24 60 89 44 24 30 8B 44 24 18 89 54 24 34 F7 E1 89 44 24 18 8B 44 24 08 89 54 24 1C F7 64 24 60 89 54 24 64 8B 54 24 30 89 44 24 60 89 54 24 70 8B 54 24 64 89 D0 31 D2 89 44 24 40 8B 44 24 08 89 54 24 44 F7 E1 01 44 24 40 11 54 24 44 8B 54 24 70 01 54 24 40 8B 54 24 34 8B 4C 24 74 11 4C 24 44 8B 4C 24 1C 89 D0 31 D2 89 54 24 34 8B 54 24 18 89 44 24 30 01 54 24 30 8B 54 24 44 11 4C 24 34 89 D0 31 D2 01 44 24 30 8B 44 24 40 11 54 24 34 89 C2 31 C0 89 44 24 40 8B 44 24 60 89 54 24 44 31 D2 01 44 24 40 11 54 24 44 8B 54 24 50 89 D1 31 D2 89 54 24 18 8B 44 24 58 31 D2 01 44 24 18 8B 44 24 30 89 4C 24 1C 11 54 24 1C 8B 54 24 34 01 44 24 18 11 54 24 1C 8B 4C 24 1C 39 CA 72 14 77 08 8B 54 24 18 39 D0 76 0A 83 44 24 48 01 83 54 24 4C 00 8B 44 24 28 8B 54 24 2C 03 44 24 40 13 54 24 44 39 54 24 44 89 44 24 28 89 54 24 2C C7 44 24 08 01 00 00 00 C7 44 24 0C 00 00 00 00 77 18 72 06 39 44 24 40 77 10 C7 44 24 08 00 00 00 00 C7 44 24 0C 00 00 00 00 8B 54 24 18 03 54 24 08 8B 4C 24 1C 13 4C 24 0C 89 54 24 30 8B 44 24 38 8B 54 24 3C 03 44 24 30 89 4C 24 34 13 54 24 34 89 44 24 38 39 D1 89 54 24 3C 0F 87 DD 0A 00 00 72 0A 39 44 24 30 0F 87 D1 0A 00 00 8B 4C 24 34 31 D2 B8 01 00 00 00 39 4C 24 0C 77 10 72 0A 8B 4C 24 30 39 4C 24 08 77 04 31 C0 31 D2 03 44 24 48 13 54 24 4C 89 D1 09 C1 75 5E 8B 44 24 3C 0B 44 24 38 75 54 8B 54 24 68 8B 44 24 78 89 D1 31 D2 89 54 24 68 31 D2 01 44 24 68 8B 44 24 10 89 4C 24 6C 11 54 24 6C 8B 54 24 20 33 54 24 2C 33 44 24 28 09 C2 0F 84 C9 0A 00 00 8B 44 24 2C 39 44 24 20 72 14 0F 87 19 03 00 00 8B 54 24 28 39 54 24 10 0F 83 0B 03 00 00 BA 01 00 00 00 89 D8 C1 E8 1F 31 D0 EB 13 8D B4 26 00 00 00 00 83 0D ?? ?? ?? ?? 01 B8 01 00 00 00 8B 9C 24 AC 00 00 00 8B B4 24 B0 00 00 00 8B BC 24 B4 00 00 00 8B AC 24 B8 00 00 00 81 C4 BC 00 00 00 C3 90 8B 44 24 10 89 DA 33 44 24 08 31 CA 09 C2 0F 85 16 FA FF FF 31 C0 EB C4 72 0E 81 7C 24 08 C0 87 AD BE 0F 87 3C FA FF FF 8B 54 24 18 8B 44 24 08 81 F2 09 ED 01 00 35 C0 87 AD BE 09 C2 0F 84 8D 02 00 00 89 C8 25 00 00 00 60 3D 00 00 00 60 0F 94 44 24 28 E9 10 FA FF FF 8D B4 26 00 00 00 00 85 C9 78 B0 89 DA B8 01 00 00 00 81 E2 00 00 00 78 C1 EB 1F 81 FA 00 00 00 78 0F 44 C3 E9 5A FF FF FF 8B 54 24 20 8B 44 24 10 81 F2 09 ED 01 00 35 C0 87 AD BE 09 C2 0F 84 49 02 00 00 89 D8 25 00 00 00 60 3D 00 00 00 60 0F 94 44 24 30 E9 E3 F9 FF FF 8B 04 24 09 F8 0F 85 10 FA FF FF 31 C0 84 D2 0F 85 14 FF FF FF 84 D2 75 0C 89 C8 F7 D0 C1 E8 1F E9 04 FF FF FF 89 D8 C1 E8 1F E9 FA FE FF FF 8B 5C 24 20 39 5C 24 18 77 14 0F 82 86 02 00 00 8B 5C 24 10 39 5C 24 08 0F 86 78 02 00 00 BA 01 00 00 00 89 C8 C1 E8 1F 31 D0 E9 CB FE FF FF 8B 0C D5 ?? ?? ?? ?? 8B 14 D5 ?? ?? ?? ?? C7 44 24 4C 00 00 00 00 89 54 24 40 89 D0 F7 64 24 10 89 44 24 28 8B 44 24 40 89 54 24 2C F7 64 24 20 89 44 24 30 8B 44 24 10 89 54 24 34 F7 E1 89 54 24 14 8B 54 24 28 89 44 24 10 89 54 24 48 8B 54 24 14 89 D0 31 D2 89 44 24 38 8B 44 24 48 01 44 24 38 8B 44 24 20 89 54 24 3C 8B 54 24 4C 11 54 24 3C F7 E1 01 44 24 38 11 54 24 3C 8B 54 24 2C 89 D0 31 D2 89 44 24 28 8B 44 24 30 01 44 24 28 89 54 24 2C 8B 54 24 34 11 54 24 2C 8B 54 24 3C C7 44 24 4C 00 00 00 00 89 D0 31 D2 01 44 24 28 8B 44 24 40 11 54 24 2C F7 24 24 89 44 24 20 8B 44 24 40 89 54 24 24 F7 E7 89 44 24 40 8B 04 24 89 54 24 44 F7 E1 89 54 24 04 8B 54 24 20 89 04 24 89 54 24 48 8B 54 24 04 89 D0 31 D2 89 44 24 30 8B 44 24 48 01 44 24 30 89 C8 89 54 24 34 8B 54 24 4C 11 54 24 34 8B 4C 24 24 F7 E7 01 44 24 30 11 54 24 34 8B 44 24 40 89 CA 31 C9 89 54 24 20 8B 54 24 44 01 44 24 20 89 4C 24 24 8B 4C 24 10 11 54 24 24 8B 54 24 34 C7 44 24 3C 00 00 00 00 89 D0 31 D2 01 44 24 20 8B 44 24 38 11 54 24 24 89 4C 24 38 89 C2 31 C0 03 44 24 38 13 54 24 3C 03 44 24 20 13 54 24 24 39 54 24 24 72 12 77 06 39 44 24 20 76 0A 83 44 24 28 01 83 54 24 2C 00 8B 4C 24 2C 0B 4C 24 28 75 2A 8B 7C 24 18 8B 4C 24 08 31 D7 31 C1 09 CF 0F 84 E5 07 00 00 39 54 24 18 0F 87 01 FD FF FF 72 0A 39 44 24 08 0F 87 F5 FC FF FF 31 D2 E9 F3 FC FF FF 8D 76 00 81 FE 63 8E 8D 37 C6 44 24 28 01 0F 87 88 F7 FF FF E9 5D FD FF FF 81 FF 63 8E 8D 37 C6 44 24 30 01 0F 87 9F F7 FF FF E9 A1 FD FF FF 8D 74 26 00 77 0E 8B 44 24 10 39 44 24 08 0F 82 FF F7 FF FF 39 F7 76 2C 8B 44 24 20 39 44 24 18 0F 82 F8 F7 FF FF 0F 87 FE F7 FF FF 8B 44 24 10 39 44 24 08 0F 86 E4 F7 FF FF E9 EB F7 FF FF 90 8D 74 26 00 72 05 39 2C 24 77 CD 39 54 24 30 0F 8F 7B FD FF FF 8B 44 24 20 39 44 24 18 0F 87 C7 F7 FF FF 0F 82 AA F7 FF FF 8B 44 24 10 39 44 24 08 0F 87 B3 F7 FF FF E9 97 F7 FF FF 8B 54 24 18 8B 44 24 08 33 54 24 20 33 44 24 10 09 C2 74 07 31 D2 E9 72 FD FF FF 39 F7 77 F5 0F 82 63 FD FF FF 39 2C 24 0F 86 5A FD FF FF 31 D2 E9 58 FD FF FF 8D 76 00 2B 54 24 30 83 FA 21 0F 8F 38 06 00 00 83 FA 13 0F 8E 4B FD FF FF 8D 5A EC C1 E3 04 8B 83 ?? ?? ?? ?? 8B 93 ?? ?? ?? ?? C7 44 24 54 00 00 00 00 89 44 24 48 89 54 24 40 F7 E7 89 44 24 38 8B 44 24 40 89 54 24 3C F7 E7 89 44 24 58 8B 44 24 48 89 54 24 5C F7 24 24 89 54 24 34 8B 54 24 38 89 44 24 30 89 54 24 50 8B 54 24 34 89 D0 31 D2 89 44 24 28 8B 44 24 50 01 44 24 28 8B 44 24 40 89 54 24 2C 8B 54 24 54 11 54 24 2C F7 24 24 01 44 24 28 11 54 24 2C 8B 54 24 3C 89 D0 31 D2 89 44 24 38 8B 44 24 58 01 44 24 38 89 54 24 3C 8B 54 24 5C 11 54 24 3C 8B 54 24 2C C7 44 24 7C 00 00 00 00 89 D0 31 D2 01 44 24 38 11 54 24 3C 8B 93 ?? ?? ?? ?? 8B 9B ?? ?? ?? ?? 89 D0 89 54 24 58 F7 E7 89 44 24 60 89 D8 89 54 24 64 F7 E7 89 44 24 50 8B 44 24 58 89 54 24 54 F7 24 24 89 54 24 74 8B 54 24 60 89 44 24 70 89 54 24 78 8B 54 24 74 89 D0 31 D2 89 44 24 68 8B 44 24 78 89 54 24 6C 8B 54 24 7C 01 44 24 68 8B 04 24 11 54 24 6C C7 44 24 04 00 00 00 00 F7 E3 01 44 24 68 11 54 24 6C 8B 54 24 64 89 D0 31 D2 89 44 24 60 8B 44 24 50 01 44 24 60 89 54 24 64 8B 54 24 54 11 54 24 64 8B 54 24 6C 89 D0 31 D2 01 44 24 60 8B 44 24 28 11 54 24 64 89 C2 31 C0 89 54 24 2C 8B 54 24 30 89 44 24 28 89 14 24 8B 04 24 8B 54 24 04 01 44 24 28 8B 44 24 60 11 54 24 2C 01 44 24 28 8B 54 24 64 11 54 24 2C 8B 44 24 2C 39 C2 72 16 77 0A 8B 54 24 28 39 54 24 60 76 0A 83 44 24 38 01 83 54 24 3C 00 8B 44 24 20 F7 64 24 48 C7 44 24 04 00 00 00 00 89 44 24 30 8B 44 24 20 89 54 24 34 F7 64 24 40 89 44 24 50 8B 44 24 10 89 54 24 54 F7 64 24 48 89 54 24 4C 8B 54 24 30 89 44 24 48 89 14 24 8B 54 24 4C 89 D0 31 D2 89 44 24 60 8B 44 24 10 89 54 24 64 F7 64 24 40 01 44 24 60 8B 04 24 11 54 24 64 01 44 24 60 8B 54 24 04 11 54 24 64 8B 54 24 34 89 D0 31 D2 89 44 24 30 8B 44 24 50 01 44 24 30 89 54 24 34 8B 54 24 54 11 54 24 34 8B 54 24 64 C7 44 24 54 00 00 00 00 89 D0 31 D2 01 44 24 30 8B 44 24 20 11 54 24 34 F7 64 24 58 89 44 24 40 8B 44 24 20 89 54 24 44 F7 E3 89 44 24 20 8B 44 24 10 89 54 24 24 F7 64 24 58 89 54 24 5C 8B 54 24 40 89 44 24 58 89 54 24 50 8B 54 24 5C 89 D0 31 D2 89 04 24 8B 44 24 10 89 54 24 04 F7 E3 01 04 24 11 54 24 04 8B 44 24 50 01 04 24 8B 54 24 54 11 54 24 04 8B 54 24 44 89 D0 31 D2 89 44 24 40 8B 44 24 20 01 44 24 40 89 54 24 44 8B 54 24 24 11 54 24 44 8B 54 24 04 89 D0 31 D2 01 44 24 40 8B 04 24 11 54 24 44 89 C2 31 C0 89 04 24 8B 44 24 58 89 54 24 04 31 D2 01 04 24 8B 44 24 60 11 54 24 04 89 C2 31 C0 89 44 24 20 8B 44 24 48 89 54 24 24 31 D2 01 44 24 20 8B 44 24 40 11 54 24 24 8B 54 24 44 01 44 24 20 11 54 24 24 8B 5C 24 24 39 DA 72 14 77 08 8B 54 24 20 39 D0 76 0A 83 44 24 30 01 83 54 24 34 00 8B 44 24 28 8B 54 24 2C 03 04 24 13 54 24 04 39 54 24 04 89 44 24 28 89 54 24 2C C7 44 24 10 01 00 00 00 C7 44 24 14 00 00 00 00 77 17 72 05 39 04 24 77 10 C7 44 24 10 00 00 00 00 C7 44 24 14 00 00 00 00 8B 44 24 20 8B 54 24 24 03 44 24 10 13 54 24 14 89 44 24 20 8B 44 24 38 89 54 24 24 8B 54 24 3C 03 44 24 20 13 54 24 24 39 54 24 24 89 44 24 38 89 54 24 3C 0F 87 7B 02 00 00 72 0A 39 44 24 20 0F 87 6F 02 00 00 8B 5C 24 24 31 D2 B8 01 00 00 00 39 5C 24 14 77 10 72 0A 8B 5C 24 20 39 5C 24 10 77 04 31 C0 31 D2 03 44 24 30 13 54 24 34 89 D3 09 C3 0F 85 BD FB FF FF 8B 44 24 3C 0B 44 24 38 0F 85 AF FB FF FF 8B 5C 24 70 8B 44 24 68 C7 44 24 04 00 00 00 00 89 1C 24 8B 5C 24 2C 89 C2 31 C0 03 04 24 13 54 24 04 39 5C 24 18 0F 84 CC 02 00 00 8B 44 24 2C 39 44 24 18 0F 82 75 FB FF FF 0F 87 E3 F8 FF FF 8B 54 24 28 39 54 24 08 0F 87 D5 F8 FF FF 31 D2 E9 D3 F8 FF FF 8B 44 24 28 C7 44 24 4C 00 00 00 00 8B 14 C5 ?? ?? ?? ?? 8B 0C C5 ?? ?? ?? ?? 89 54 24 40 89 D0 F7 64 24 08 89 44 24 28 8B 44 24 40 89 54 24 2C F7 64 24 18 89 44 24 30 8B 44 24 08 89 54 24 34 F7 E1 89 54 24 0C 8B 54 24 28 89 44 24 08 89 54 24 48 8B 54 24 0C 89 D0 31 D2 89 44 24 38 8B 44 24 48 01 44 24 38 8B 44 24 18 89 54 24 3C 8B 54 24 4C 11 54 24 3C F7 E1 01 44 24 38 11 54 24 3C 8B 54 24 2C 89 D0 31 D2 89 44 24 28 8B 44 24 30 01 44 24 28 89 54 24 2C 8B 54 24 34 11 54 24 2C 8B 54 24 3C C7 44 24 54 00 00 00 00 89 D0 31 D2 01 44 24 28 8B 44 24 40 11 54 24 2C F7 E5 89 44 24 18 8B 44 24 40 89 54 24 1C F7 E6 89 44 24 40 89 C8 89 54 24 44 F7 E5 89 54 24 4C 8B 54 24 18 89 44 24 48 89 54 24 50 8B 54 24 4C 89 D0 31 D2 89 44 24 30 8B 44 24 50 01 44 24 30 89 C8 89 54 24 34 8B 54 24 54 11 54 24 34 8B 4C 24 1C F7 E6 01 44 24 30 11 54 24 34 8B 44 24 40 89 CA 31 C9 89 54 24 18 8B 54 24 44 01 44 24 18 89 4C 24 1C 8B 4C 24 08 11 54 24 1C 8B 54 24 34 C7 44 24 3C 00 00 00 00 89 D0 31 D2 01 44 24 18 8B 44 24 38 11 54 24 1C 89 4C 24 38 89 C2 31 C0 03 44 }
	condition:
		$1
}

rule file_45_15_0 {
	meta:
		name = "___bid128_signaling_less"
		size = 4576
		refs = "01f5 ___bid_ten2k128 066a ___bid_IDEC_glbflags 07c6 ___bid_ten2k64"
	strings:
		$1 = { 81 EC BC 00 00 00 8B 8C 24 C8 00 00 00 89 9C 24 AC 00 00 00 8B 9C 24 D0 00 00 00 89 B4 24 B0 00 00 00 8B B4 24 C4 00 00 00 89 BC 24 B4 00 00 00 8B BC 24 D4 00 00 00 89 4C 24 08 8B 8C 24 CC 00 00 00 89 1C 24 8B 9C 24 D8 00 00 00 89 AC 24 B8 00 00 00 8B AC 24 C0 00 00 00 89 C8 25 00 00 00 7C 3D 00 00 00 7C 89 5C 24 10 8B 9C 24 DC 00 00 00 0F 84 F1 05 00 00 89 D8 25 00 00 00 7C 3D 00 00 00 7C 0F 84 DF 05 00 00 8B 04 24 89 FA 31 F2 31 E8 09 C2 0F 84 26 06 00 00 89 C8 25 00 00 00 78 3D 00 00 00 78 0F 84 74 06 00 00 89 D8 25 00 00 00 78 3D 00 00 00 78 0F 84 F2 05 00 00 89 C8 25 FF FF 01 00 3D 09 ED 01 00 89 44 24 18 0F 86 04 06 00 00 C6 44 24 20 01 89 DA 81 E2 FF FF 01 00 81 FA 09 ED 01 00 89 54 24 28 77 14 0F 82 52 06 00 00 81 7C 24 10 C0 87 AD BE 0F 86 44 06 00 00 C6 44 24 30 01 80 7C 24 20 00 BA 01 00 00 00 75 13 8B 44 24 18 31 D2 0B 44 24 08 75 07 89 EA 09 F2 0F 94 C2 80 7C 24 30 00 0F 85 6F 05 00 00 8B 44 24 28 0B 44 24 10 0F 84 56 05 00 00 84 D2 0F 85 6A 05 00 00 89 CA 31 DA 0F 88 60 05 00 00 89 C8 89 DA C1 E8 11 C1 EA 11 25 FF 3F 00 00 81 E2 FF 3F 00 00 39 C2 89 44 24 20 0F 84 21 06 00 00 8B 44 24 28 39 44 24 18 0F 87 37 08 00 00 72 0E 8B 44 24 10 39 44 24 08 0F 87 27 08 00 00 8B 44 24 18 33 44 24 28 89 44 24 30 8B 44 24 08 33 44 24 10 0B 44 24 30 0F 84 C9 05 00 00 8B 44 24 28 39 44 24 18 72 0C 77 14 8B 44 24 10 39 44 24 08 73 0A 39 54 24 20 0F 8E FD 07 00 00 8B 44 24 20 29 D0 85 C0 0F 8E 7B 08 00 00 83 F8 21 0F 8F A4 05 00 00 83 F8 13 0F 8E D6 05 00 00 8D 48 EC C1 E1 04 8B 91 ?? ?? ?? ?? 8B 81 ?? ?? ?? ?? C7 44 24 54 00 00 00 00 89 54 24 58 89 44 24 40 89 D0 F7 E6 89 44 24 30 8B 44 24 40 89 54 24 34 F7 E6 89 44 24 38 8B 44 24 58 89 54 24 3C F7 E5 89 54 24 4C 8B 54 24 30 89 44 24 48 89 54 24 50 8B 54 24 4C 89 D0 31 D2 89 44 24 20 8B 44 24 50 01 44 24 20 8B 44 24 40 89 54 24 24 8B 54 24 54 11 54 24 24 F7 E5 01 44 24 20 11 54 24 24 8B 54 24 34 89 D0 31 D2 89 44 24 30 89 54 24 34 8B 44 24 38 01 44 24 30 8B 54 24 3C 11 54 24 34 8B 54 24 24 C7 44 24 74 00 00 00 00 89 D0 31 D2 01 44 24 30 11 54 24 34 8B 91 ?? ?? ?? ?? 8B 89 ?? ?? ?? ?? 89 D0 89 54 24 60 F7 E6 89 44 24 38 89 C8 89 54 24 3C F7 E6 89 44 24 50 8B 44 24 60 89 54 24 54 F7 E5 89 54 24 7C 8B 54 24 38 89 44 24 78 89 54 24 70 8B 54 24 7C 89 D0 31 D2 89 44 24 68 8B 44 24 70 01 44 24 68 89 C8 89 54 24 6C 8B 54 24 74 11 54 24 6C F7 E5 01 44 24 68 11 54 24 6C 8B 54 24 3C C7 44 24 3C 00 00 00 00 89 D0 31 D2 89 44 24 70 8B 44 24 50 01 44 24 70 89 54 24 74 8B 54 24 54 11 54 24 74 8B 54 24 6C 89 D0 31 D2 01 44 24 70 8B 44 24 20 11 54 24 74 89 C2 31 C0 89 54 24 24 8B 54 24 48 89 44 24 20 89 54 24 38 8B 44 24 38 01 44 24 20 8B 54 24 3C 11 54 24 24 8B 44 24 70 01 44 24 20 8B 54 24 74 11 54 24 24 8B 44 24 24 39 C2 72 16 77 0A 8B 54 24 20 39 54 24 70 76 0A 83 44 24 30 01 83 54 24 34 00 8B 44 24 18 F7 64 24 58 C7 44 24 3C 00 00 00 00 89 44 24 48 8B 44 24 18 89 54 24 4C F7 64 24 40 89 44 24 70 8B 44 24 08 89 54 24 74 F7 64 24 58 89 54 24 5C 8B 54 24 48 89 44 24 58 89 54 24 38 8B 54 24 5C 89 D0 31 D2 89 44 24 50 8B 44 24 08 89 54 24 54 F7 64 24 40 01 44 24 50 8B 44 24 38 11 54 24 54 01 44 24 50 8B 54 24 3C 11 54 24 54 8B 54 24 4C 89 D0 31 D2 89 44 24 48 8B 44 24 70 01 44 24 48 89 54 24 4C 8B 54 24 74 11 54 24 4C 8B 54 24 54 C7 44 24 74 00 00 00 00 89 D0 31 D2 01 44 24 48 8B 44 24 18 11 54 24 4C F7 64 24 60 89 44 24 38 8B 44 24 18 89 54 24 3C F7 E1 89 44 24 18 8B 44 24 08 89 54 24 1C F7 64 24 60 89 54 24 64 8B 54 24 38 89 44 24 60 89 54 24 70 8B 54 24 64 89 D0 31 D2 89 44 24 40 8B 44 24 08 89 54 24 44 F7 E1 01 44 24 40 11 54 24 44 8B 54 24 70 01 54 24 40 8B 54 24 3C 8B 4C 24 74 11 4C 24 44 8B 4C 24 1C 89 D0 31 D2 89 54 24 3C 8B 54 24 18 89 44 24 38 01 54 24 38 8B 54 24 44 11 4C 24 3C 89 D0 31 D2 01 44 24 38 8B 44 24 40 11 54 24 3C 89 C2 31 C0 89 44 24 40 8B 44 24 60 89 54 24 44 31 D2 01 44 24 40 11 54 24 44 8B 54 24 50 89 D1 31 D2 89 54 24 18 8B 44 24 58 31 D2 01 44 24 18 8B 44 24 38 89 4C 24 1C 11 54 24 1C 8B 54 24 3C 01 44 24 18 11 54 24 1C 8B 4C 24 1C 39 CA 72 14 77 08 8B 54 24 18 39 D0 76 0A 83 44 24 48 01 83 54 24 4C 00 8B 44 24 20 8B 54 24 24 03 44 24 40 13 54 24 44 39 54 24 44 89 44 24 20 89 54 24 24 C7 44 24 08 01 00 00 00 C7 44 24 0C 00 00 00 00 77 18 72 06 39 44 24 40 77 10 C7 44 24 08 00 00 00 00 C7 44 24 0C 00 00 00 00 8B 54 24 18 03 54 24 08 8B 4C 24 1C 13 4C 24 0C 89 54 24 38 8B 44 24 30 8B 54 24 34 03 44 24 38 89 4C 24 3C 13 54 24 3C 89 44 24 30 39 D1 89 54 24 34 0F 87 4C 09 00 00 72 0A 39 44 24 38 0F 87 40 09 00 00 8B 4C 24 3C 31 D2 B8 01 00 00 00 39 4C 24 0C 77 10 72 0A 8B 4C 24 38 39 4C 24 08 77 04 31 C0 31 D2 03 44 24 48 13 54 24 4C 89 D1 09 C1 75 5E 8B 44 24 34 0B 44 24 30 75 54 8B 54 24 68 8B 44 24 78 89 D1 31 D2 89 54 24 68 31 D2 01 44 24 68 8B 44 24 10 89 4C 24 6C 11 54 24 6C 8B 54 24 28 33 54 24 24 33 44 24 20 09 C2 0F 84 F3 0A 00 00 8B 44 24 24 39 44 24 28 72 14 0F 87 2F 03 00 00 8B 54 24 20 39 54 24 10 0F 83 21 03 00 00 BA 01 00 00 00 89 D8 F7 D0 C1 E8 1F 31 D0 EB 09 83 0D ?? ?? ?? ?? 01 31 C0 8B 9C 24 AC 00 00 00 8B B4 24 B0 00 00 00 8B BC 24 B4 00 00 00 8B AC 24 B8 00 00 00 81 C4 BC 00 00 00 C3 8B 04 24 09 F8 0F 85 9F FA FF FF 31 C0 84 D2 75 CC 84 D2 0F 84 DB 00 00 00 8D 76 00 89 D8 F7 D0 C1 E8 1F EB B8 8D B4 26 00 00 00 00 8B 44 24 10 89 DA 33 44 24 08 31 CA 09 C2 0F 85 C6 F9 FF FF 31 C0 EB 99 72 0E 81 7C 24 08 C0 87 AD BE 0F 87 EC F9 FF FF 8B 54 24 18 8B 44 24 08 81 F2 09 ED 01 00 35 C0 87 AD BE 09 C2 0F 84 82 02 00 00 89 C8 25 00 00 00 60 3D 00 00 00 60 0F 94 44 24 20 E9 C0 F9 FF FF 8D B4 26 00 00 00 00 31 C0 85 C9 0F 89 47 FF FF FF 89 DA B0 01 81 E2 00 00 00 78 81 FA 00 00 00 78 0F 85 31 FF FF FF E9 6B FF FF FF 8B 54 24 28 8B 44 24 10 81 F2 09 ED 01 00 35 C0 87 AD BE 09 C2 0F 84 40 02 00 00 89 D8 25 00 00 00 60 3D 00 00 00 60 0F 94 44 24 30 E9 90 F9 FF FF 39 F7 0F 83 74 07 00 00 39 54 24 20 0F 8C 78 02 00 00 89 C8 C1 E8 1F E9 DF FE FF FF 8B 5C 24 28 39 5C 24 18 77 14 0F 82 7E 02 00 00 8B 5C 24 10 39 5C 24 08 0F 86 70 02 00 00 BA 01 00 00 00 89 C8 F7 D0 C1 E8 1F 31 D0 E9 AE FE FF FF 8B 0C C5 ?? ?? ?? ?? 8B 04 C5 ?? ?? ?? ?? C7 44 24 4C 00 00 00 00 89 44 24 40 F7 64 24 08 89 44 24 20 8B 44 24 40 89 54 24 24 F7 64 24 18 89 44 24 38 8B 44 24 08 89 54 24 3C F7 E1 89 54 24 0C 8B 54 24 20 89 44 24 08 89 54 24 48 8B 54 24 0C 89 D0 31 D2 89 44 24 30 8B 44 24 48 01 44 24 30 8B 44 24 18 89 54 24 34 8B 54 24 4C 11 54 24 34 F7 E1 01 44 24 30 11 54 24 34 8B 54 24 24 89 D0 31 D2 89 44 24 20 8B 44 24 38 01 44 24 20 89 54 24 24 8B 54 24 3C 11 54 24 24 8B 54 24 34 C7 44 24 54 00 00 00 00 89 D0 31 D2 01 44 24 20 8B 44 24 40 11 54 24 24 F7 E5 89 44 24 18 8B 44 24 40 89 54 24 1C F7 E6 89 44 24 40 89 C8 89 54 24 44 F7 E5 89 54 24 4C 8B 54 24 18 89 44 24 48 89 54 24 50 8B 54 24 4C 89 D0 31 D2 89 44 24 38 8B 44 24 50 01 44 24 38 89 C8 89 54 24 3C 8B 54 24 54 11 54 24 3C 8B 4C 24 1C F7 E6 01 44 24 38 11 54 24 3C 8B 44 24 40 89 CA 31 C9 89 54 24 18 8B 54 24 44 01 44 24 18 89 4C 24 1C 8B 4C 24 08 11 54 24 1C 8B 54 24 3C C7 44 24 34 00 00 00 00 89 D0 31 D2 01 44 24 18 8B 44 24 30 11 54 24 1C 89 4C 24 30 89 C2 31 C0 03 44 24 30 13 54 24 34 03 44 24 18 13 54 24 1C 39 54 24 1C 72 12 77 06 39 44 24 18 76 0A 83 44 24 20 01 83 54 24 24 00 8B 4C 24 24 0B 4C 24 20 0F 85 09 FD FF FF 8B 74 24 28 8B 4C 24 10 31 D6 31 C1 09 CE 0F 84 84 07 00 00 39 54 24 28 0F 82 EB FC FF FF 77 0A 39 44 24 10 0F 82 DF FC FF FF 31 D2 90 8D 74 26 00 E9 D8 FC FF FF 81 FE 63 8E 8D 37 C6 44 24 20 01 0F 87 43 F7 FF FF E9 68 FD FF FF 90 8D 74 26 00 81 FF 63 8E 8D 37 C6 44 24 30 01 0F 87 55 F7 FF FF E9 AA FD FF FF 39 54 24 20 0F 8D C8 FD FF FF 8B 44 24 28 39 44 24 18 73 0C 89 C8 F7 D0 C1 E8 1F E9 9B FC FF FF 77 0A 8B 44 24 10 39 44 24 08 72 E8 8B 44 24 18 33 44 24 28 89 44 24 30 8B 44 24 08 33 44 24 10 0B 44 24 30 0F 85 CD F7 FF FF 39 F7 0F 82 C5 F7 FF FF 0F 87 B5 F7 FF FF 39 2C 24 0F 86 B6 F7 FF FF E9 A7 F7 FF FF 8D 74 26 00 8B 54 24 18 8B 44 24 08 33 54 24 28 33 44 24 10 09 C2 74 07 31 D2 E9 7A FD FF FF 39 F7 77 F5 90 0F 82 6A FD FF FF 39 2C 24 0F 86 61 FD FF FF 31 D2 E9 5F FD FF FF 89 D0 2B 44 24 20 83 F8 21 0F 8F 65 FF FF FF 83 F8 13 0F 8E A9 04 00 00 8D 58 EC C1 E3 04 8B 83 ?? ?? ?? ?? 8B 93 ?? ?? ?? ?? C7 44 24 54 00 00 00 00 89 44 24 48 89 54 24 40 F7 E7 89 44 24 30 8B 44 24 40 89 54 24 34 F7 E7 89 44 24 58 8B 44 24 48 89 54 24 5C F7 24 24 89 54 24 3C 8B 54 24 30 89 44 24 38 89 54 24 50 8B 54 24 3C 89 D0 31 D2 89 44 24 20 8B 44 24 50 01 44 24 20 8B 44 24 40 89 54 24 24 8B 54 24 54 11 54 24 24 F7 24 24 01 44 24 20 11 54 24 24 8B 54 24 34 89 D0 31 D2 89 44 24 30 8B 44 24 58 01 44 24 30 89 54 24 34 8B 54 24 5C 11 54 24 34 8B 54 24 24 C7 44 24 7C 00 00 00 00 89 D0 31 D2 01 44 24 30 11 54 24 34 8B 93 ?? ?? ?? ?? 8B 9B ?? ?? ?? ?? 89 D0 89 54 24 58 F7 E7 89 44 24 60 89 D8 89 54 24 64 F7 E7 89 44 24 50 8B 44 24 58 89 54 24 54 F7 24 24 89 54 24 74 8B 54 24 60 89 44 24 70 89 54 24 78 8B 54 24 74 89 D0 31 D2 89 44 24 68 8B 44 24 78 89 54 24 6C 8B 54 24 7C 01 44 24 68 8B 04 24 11 54 24 6C C7 44 24 04 00 00 00 00 F7 E3 01 44 24 68 11 54 24 6C 8B 54 24 64 89 D0 31 D2 89 44 24 60 8B 44 24 50 01 44 24 60 89 54 24 64 8B 54 24 54 11 54 24 64 8B 54 24 6C 89 D0 31 D2 01 44 24 60 8B 44 24 20 11 54 24 64 89 C2 31 C0 89 54 24 24 8B 54 24 38 89 44 24 20 89 14 24 8B 04 24 8B 54 24 04 01 44 24 20 8B 44 24 60 11 54 24 24 01 44 24 20 8B 54 24 64 11 54 24 24 8B 44 24 24 39 C2 72 16 77 0A 8B 54 24 20 39 54 24 60 76 0A 83 44 24 30 01 83 54 24 34 00 8B 44 24 28 F7 64 24 48 C7 44 24 04 00 00 00 00 89 44 24 38 8B 44 24 28 89 54 24 3C F7 64 24 40 89 44 24 50 8B 44 24 10 89 54 24 54 F7 64 24 48 89 54 24 4C 8B 54 24 38 89 44 24 48 89 14 24 8B 54 24 4C 89 D0 31 D2 89 44 24 60 8B 44 24 10 89 54 24 64 F7 64 24 40 01 44 24 60 8B 04 24 11 54 24 64 01 44 24 60 8B 54 24 04 11 54 24 64 8B 54 24 3C 89 D0 31 D2 89 44 24 38 8B 44 24 50 01 44 24 38 89 54 24 3C 8B 54 24 54 11 54 24 3C 8B 54 24 64 C7 44 24 54 00 00 00 00 89 D0 31 D2 01 44 24 38 8B 44 24 28 11 54 24 3C F7 64 24 58 89 44 24 40 8B 44 24 28 89 54 24 44 F7 E3 89 44 24 28 8B 44 24 10 89 54 24 2C F7 64 24 58 89 54 24 5C 8B 54 24 40 89 44 24 58 89 54 24 50 8B 54 24 5C 89 D0 31 D2 89 04 24 8B 44 24 10 89 54 24 04 F7 E3 01 04 24 11 54 24 04 8B 44 24 50 01 04 24 8B 54 24 54 11 54 24 04 8B 54 24 44 89 D0 31 D2 89 44 24 40 8B 44 24 28 01 44 24 40 89 54 24 44 8B 54 24 2C 11 54 24 44 8B 54 24 04 89 D0 31 D2 01 44 24 40 8B 04 24 11 54 24 44 89 C2 31 C0 89 04 24 8B 44 24 58 89 54 24 04 31 D2 01 04 24 8B 44 24 60 11 54 24 04 89 C2 31 C0 89 44 24 28 8B 44 24 48 89 54 24 2C 31 D2 01 44 24 28 8B 44 24 40 11 54 24 2C 8B 54 24 44 01 44 24 28 11 54 24 2C 8B 5C 24 2C 39 DA 72 14 77 08 8B 54 24 28 39 D0 76 0A 83 44 24 38 01 83 54 24 3C 00 8B 44 24 20 8B 54 24 24 03 04 24 13 54 24 04 39 54 24 04 89 44 24 20 89 54 24 24 C7 44 24 10 01 00 00 00 C7 44 24 14 00 00 00 00 77 17 72 05 39 04 24 77 10 C7 44 24 10 00 00 00 00 C7 44 24 14 00 00 00 00 8B 44 24 28 8B 54 24 2C 03 44 24 10 13 54 24 14 89 44 24 28 8B 44 24 30 89 54 24 2C 8B 54 24 34 03 44 24 28 13 54 24 2C 39 54 24 2C 89 44 24 30 89 54 24 34 0F 87 A3 02 00 00 72 0A 39 44 24 28 0F 87 97 02 00 00 8B 5C 24 2C 31 D2 B8 01 00 00 00 39 5C 24 14 77 10 72 0A 8B 5C 24 28 39 5C 24 10 77 04 31 C0 31 D2 03 44 24 38 13 54 24 3C 89 D3 09 C3 75 48 8B 44 24 34 0B 44 24 30 75 3E 8B 5C 24 70 8B 44 24 68 C7 44 24 04 00 00 00 00 89 1C 24 8B 5C 24 24 89 C2 31 C0 03 04 24 13 54 24 04 39 5C 24 18 74 27 8B 44 24 24 39 44 24 18 72 0C 77 37 8B 54 24 20 39 54 24 08 73 2D BA 01 00 00 00 89 C8 C1 E8 1F 31 D0 E9 A5 F7 FF FF 8B 5C 24 20 39 5C 24 08 75 CF 39 F2 0F 84 EF 02 00 00 39 F2 72 06 77 D7 39 E8 77 D3 31 D2 8D B6 00 00 00 00 EB CE 0F 87 CB F2 FF FF 39 2C 24 90 8D 74 26 00 0F 82 78 F8 FF FF E9 F5 FA FF FF B8 01 00 00 00 31 D2 E9 D5 F6 FF FF 8B 0C C5 ?? ?? ?? ?? 8B 04 C5 ?? ?? ?? ?? C7 44 24 4C 00 00 00 00 89 44 24 40 F7 64 24 10 89 44 24 20 8B 44 24 40 89 54 24 24 F7 64 24 28 89 44 24 38 8B 44 24 10 89 54 24 3C F7 E1 89 54 24 14 8B 54 24 20 89 44 24 10 89 54 24 48 8B 54 24 14 89 D0 31 D2 89 44 24 30 8B 44 24 48 01 44 24 30 8B 44 24 28 89 54 24 34 8B 54 24 4C 11 54 24 34 F7 E1 01 44 24 30 11 54 24 34 8B 54 24 24 89 D0 31 D2 89 44 24 20 8B 44 24 38 01 44 24 20 89 54 24 24 8B 54 24 3C 11 54 24 24 8B 54 24 34 C7 44 24 4C 00 00 00 00 89 D0 31 D2 01 44 24 20 8B 44 24 40 11 54 24 24 F7 24 24 89 44 24 28 8B 44 24 40 89 54 24 2C F7 E7 89 44 24 40 8B 04 24 89 54 24 44 F7 E1 89 54 24 04 8B 54 24 28 89 04 24 89 54 24 48 8B 54 24 04 89 D0 }
	condition:
		$1
}

rule file_45_16_0 {
	meta:
		name = "___bid128_signaling_less_equal"
		size = 4576
		refs = "01f5 ___bid_ten2k128 066a ___bid_IDEC_glbflags 07b6 ___bid_ten2k64"
	strings:
		$1 = { 81 EC BC 00 00 00 8B 8C 24 C8 00 00 00 89 9C 24 AC 00 00 00 8B 9C 24 D0 00 00 00 89 B4 24 B0 00 00 00 8B B4 24 C4 00 00 00 89 BC 24 B4 00 00 00 8B BC 24 D4 00 00 00 89 4C 24 08 8B 8C 24 CC 00 00 00 89 1C 24 8B 9C 24 D8 00 00 00 89 AC 24 B8 00 00 00 8B AC 24 C0 00 00 00 89 C8 25 00 00 00 7C 3D 00 00 00 7C 89 5C 24 10 8B 9C 24 DC 00 00 00 0F 84 F1 05 00 00 89 D8 25 00 00 00 7C 3D 00 00 00 7C 0F 84 DF 05 00 00 8B 04 24 89 FA 31 F2 31 E8 09 C2 0F 84 FA 05 00 00 89 C8 25 00 00 00 78 3D 00 00 00 78 0F 84 45 06 00 00 89 D8 25 00 00 00 78 3D 00 00 00 78 0F 84 A9 06 00 00 89 C8 25 FF FF 01 00 3D 09 ED 01 00 89 44 24 18 0F 86 DC 05 00 00 C6 44 24 20 01 89 DA 81 E2 FF FF 01 00 81 FA 09 ED 01 00 89 54 24 28 77 14 0F 82 1D 06 00 00 81 7C 24 10 C0 87 AD BE 0F 86 0F 06 00 00 C6 44 24 30 01 80 7C 24 20 00 BA 01 00 00 00 75 13 8B 44 24 18 31 D2 0B 44 24 08 75 07 89 EA 09 F2 0F 94 C2 80 7C 24 30 00 0F 85 1C 06 00 00 8B 44 24 28 0B 44 24 10 0F 84 03 06 00 00 84 D2 0F 85 21 06 00 00 89 CA 31 DA 0F 88 17 06 00 00 89 C8 89 DA C1 E8 11 C1 EA 11 25 FF 3F 00 00 81 E2 FF 3F 00 00 39 C2 89 44 24 20 0F 84 11 06 00 00 8B 44 24 28 39 44 24 18 0F 87 27 08 00 00 72 0E 8B 44 24 10 39 44 24 08 0F 87 17 08 00 00 8B 44 24 18 33 44 24 28 89 44 24 30 8B 44 24 08 33 44 24 10 0B 44 24 30 0F 84 35 0D 00 00 8B 44 24 28 39 44 24 18 72 0C 77 14 8B 44 24 10 39 44 24 08 73 0A 39 54 24 20 0F 8E ED 07 00 00 8B 44 24 20 29 D0 85 C0 0F 8E 6B 08 00 00 83 F8 21 0F 8F 79 05 00 00 83 F8 13 0F 8E C6 05 00 00 8D 48 EC C1 E1 04 8B 91 ?? ?? ?? ?? 8B 81 ?? ?? ?? ?? C7 44 24 54 00 00 00 00 89 54 24 58 89 44 24 40 89 D0 F7 E6 89 44 24 30 8B 44 24 40 89 54 24 34 F7 E6 89 44 24 38 8B 44 24 58 89 54 24 3C F7 E5 89 54 24 4C 8B 54 24 30 89 44 24 48 89 54 24 50 8B 54 24 4C 89 D0 31 D2 89 44 24 20 8B 44 24 50 01 44 24 20 8B 44 24 40 89 54 24 24 8B 54 24 54 11 54 24 24 F7 E5 01 44 24 20 11 54 24 24 8B 54 24 34 89 D0 31 D2 89 44 24 30 89 54 24 34 8B 44 24 38 01 44 24 30 8B 54 24 3C 11 54 24 34 8B 54 24 24 C7 44 24 74 00 00 00 00 89 D0 31 D2 01 44 24 30 11 54 24 34 8B 91 ?? ?? ?? ?? 8B 89 ?? ?? ?? ?? 89 D0 89 54 24 60 F7 E6 89 44 24 38 89 C8 89 54 24 3C F7 E6 89 44 24 50 8B 44 24 60 89 54 24 54 F7 E5 89 54 24 7C 8B 54 24 38 89 44 24 78 89 54 24 70 8B 54 24 7C 89 D0 31 D2 89 44 24 68 8B 44 24 70 01 44 24 68 89 C8 89 54 24 6C 8B 54 24 74 11 54 24 6C F7 E5 01 44 24 68 11 54 24 6C 8B 54 24 3C C7 44 24 3C 00 00 00 00 89 D0 31 D2 89 44 24 70 8B 44 24 50 01 44 24 70 89 54 24 74 8B 54 24 54 11 54 24 74 8B 54 24 6C 89 D0 31 D2 01 44 24 70 8B 44 24 20 11 54 24 74 89 C2 31 C0 89 54 24 24 8B 54 24 48 89 44 24 20 89 54 24 38 8B 44 24 38 01 44 24 20 8B 54 24 3C 11 54 24 24 8B 44 24 70 01 44 24 20 8B 54 24 74 11 54 24 24 8B 44 24 24 39 C2 72 16 77 0A 8B 54 24 20 39 54 24 70 76 0A 83 44 24 30 01 83 54 24 34 00 8B 44 24 18 F7 64 24 58 C7 44 24 3C 00 00 00 00 89 44 24 48 8B 44 24 18 89 54 24 4C F7 64 24 40 89 44 24 70 8B 44 24 08 89 54 24 74 F7 64 24 58 89 54 24 5C 8B 54 24 48 89 44 24 58 89 54 24 38 8B 54 24 5C 89 D0 31 D2 89 44 24 50 8B 44 24 08 89 54 24 54 F7 64 24 40 01 44 24 50 8B 44 24 38 11 54 24 54 01 44 24 50 8B 54 24 3C 11 54 24 54 8B 54 24 4C 89 D0 31 D2 89 44 24 48 8B 44 24 70 01 44 24 48 89 54 24 4C 8B 54 24 74 11 54 24 4C 8B 54 24 54 C7 44 24 74 00 00 00 00 89 D0 31 D2 01 44 24 48 8B 44 24 18 11 54 24 4C F7 64 24 60 89 44 24 38 8B 44 24 18 89 54 24 3C F7 E1 89 44 24 18 8B 44 24 08 89 54 24 1C F7 64 24 60 89 54 24 64 8B 54 24 38 89 44 24 60 89 54 24 70 8B 54 24 64 89 D0 31 D2 89 44 24 40 8B 44 24 08 89 54 24 44 F7 E1 01 44 24 40 11 54 24 44 8B 54 24 70 01 54 24 40 8B 54 24 3C 8B 4C 24 74 11 4C 24 44 8B 4C 24 1C 89 D0 31 D2 89 54 24 3C 8B 54 24 18 89 44 24 38 01 54 24 38 8B 54 24 44 11 4C 24 3C 89 D0 31 D2 01 44 24 38 8B 44 24 40 11 54 24 3C 89 C2 31 C0 89 44 24 40 8B 44 24 60 89 54 24 44 31 D2 01 44 24 40 11 54 24 44 8B 54 24 50 89 D1 31 D2 89 54 24 18 8B 44 24 58 31 D2 01 44 24 18 8B 44 24 38 89 4C 24 1C 11 54 24 1C 8B 54 24 3C 01 44 24 18 11 54 24 1C 8B 4C 24 1C 39 CA 72 14 77 08 8B 54 24 18 39 D0 76 0A 83 44 24 48 01 83 54 24 4C 00 8B 44 24 20 8B 54 24 24 03 44 24 40 13 54 24 44 39 54 24 44 89 44 24 20 89 54 24 24 C7 44 24 08 01 00 00 00 C7 44 24 0C 00 00 00 00 77 18 72 06 39 44 24 40 77 10 C7 44 24 08 00 00 00 00 C7 44 24 0C 00 00 00 00 8B 54 24 18 03 54 24 08 8B 4C 24 1C 13 4C 24 0C 89 54 24 38 8B 44 24 30 8B 54 24 34 03 44 24 38 89 4C 24 3C 13 54 24 3C 89 44 24 30 39 D1 89 54 24 34 0F 87 48 09 00 00 72 0A 39 44 24 38 0F 87 3C 09 00 00 8B 4C 24 3C 31 D2 B8 01 00 00 00 39 4C 24 0C 77 10 72 0A 8B 4C 24 38 39 4C 24 08 77 04 31 C0 31 D2 03 44 24 48 13 54 24 4C 89 D1 09 C1 75 5E 8B 44 24 34 0B 44 24 30 75 54 8B 54 24 68 8B 44 24 78 89 D1 31 D2 89 54 24 68 31 D2 01 44 24 68 8B 44 24 10 89 4C 24 6C 11 54 24 6C 8B 54 24 28 33 54 24 24 33 44 24 20 09 C2 0F 84 F3 0A 00 00 8B 44 24 24 39 44 24 28 72 14 0F 87 1F 03 00 00 8B 54 24 20 39 54 24 10 0F 83 11 03 00 00 BA 01 00 00 00 89 D8 F7 D0 C1 E8 1F 31 D0 EB 09 83 0D ?? ?? ?? ?? 01 31 C0 8B 9C 24 AC 00 00 00 8B B4 24 B0 00 00 00 8B BC 24 B4 00 00 00 8B AC 24 B8 00 00 00 81 C4 BC 00 00 00 C3 8B 44 24 10 89 DA 33 44 24 08 31 CA 09 C2 0F 85 F2 F9 FF FF B8 01 00 00 00 EB C2 90 72 0E 81 7C 24 08 C0 87 AD BE 0F 87 14 FA FF FF 8B 54 24 18 8B 44 24 08 81 F2 09 ED 01 00 35 C0 87 AD BE 09 C2 0F 84 B5 02 00 00 89 C8 25 00 00 00 60 3D 00 00 00 60 0F 94 44 24 20 E9 E8 F9 FF FF 85 C9 78 B3 89 D8 25 00 00 00 78 3D 00 00 00 78 74 70 31 C0 E9 67 FF FF FF 8D B6 00 00 00 00 8B 54 24 28 8B 44 24 10 81 F2 09 ED 01 00 35 C0 87 AD BE 09 C2 0F 84 4A 02 00 00 89 D8 25 00 00 00 60 3D 00 00 00 60 0F 94 44 24 30 E9 C5 F9 FF FF 8B 04 24 09 F8 0F 85 F2 F9 FF FF 84 D2 B8 01 00 00 00 0F 85 18 FF FF FF 84 D2 75 0A 89 C8 C1 E8 1F E9 0A FF FF FF 89 D8 F7 D0 C1 E8 1F E9 FE FE FF FF 85 DB B8 01 00 00 00 0F 89 F1 FE FF FF EB 81 8B 5C 24 28 39 5C 24 18 77 14 0F 82 7E 02 00 00 8B 5C 24 10 39 5C 24 08 0F 86 70 02 00 00 BA 01 00 00 00 89 C8 F7 D0 C1 E8 1F 31 D0 E9 BE FE FF FF 8B 0C C5 ?? ?? ?? ?? 8B 04 C5 ?? ?? ?? ?? C7 44 24 4C 00 00 00 00 89 44 24 40 F7 64 24 08 89 44 24 20 8B 44 24 40 89 54 24 24 F7 64 24 18 89 44 24 38 8B 44 24 08 89 54 24 3C F7 E1 89 54 24 0C 8B 54 24 20 89 44 24 08 89 54 24 48 8B 54 24 0C 89 D0 31 D2 89 44 24 30 8B 44 24 48 01 44 24 30 8B 44 24 18 89 54 24 34 8B 54 24 4C 11 54 24 34 F7 E1 01 44 24 30 11 54 24 34 8B 54 24 24 89 D0 31 D2 89 44 24 20 8B 44 24 38 01 44 24 20 89 54 24 24 8B 54 24 3C 11 54 24 24 8B 54 24 34 C7 44 24 54 00 00 00 00 89 D0 31 D2 01 44 24 20 8B 44 24 40 11 54 24 24 F7 E5 89 44 24 18 8B 44 24 40 89 54 24 1C F7 E6 89 44 24 40 89 C8 89 54 24 44 F7 E5 89 54 24 4C 8B 54 24 18 89 44 24 48 89 54 24 50 8B 54 24 4C 89 D0 31 D2 89 44 24 38 8B 44 24 50 01 44 24 38 89 C8 89 54 24 3C 8B 54 24 54 11 54 24 3C 8B 4C 24 1C F7 E6 01 44 24 38 11 54 24 3C 8B 44 24 40 89 CA 31 C9 89 54 24 18 8B 54 24 44 01 44 24 18 89 4C 24 1C 8B 4C 24 08 11 54 24 1C 8B 54 24 3C C7 44 24 34 00 00 00 00 89 D0 31 D2 01 44 24 18 8B 44 24 30 11 54 24 1C 89 4C 24 30 89 C2 31 C0 03 44 24 30 13 54 24 34 03 44 24 18 13 54 24 1C 39 54 24 1C 72 12 77 06 39 44 24 18 76 0A 83 44 24 20 01 83 54 24 24 00 8B 4C 24 24 0B 4C 24 20 0F 85 19 FD FF FF 8B 74 24 28 8B 4C 24 10 31 D6 31 C1 09 CE 0F 84 90 07 00 00 39 54 24 28 0F 82 FB FC FF FF 77 0A 39 44 24 10 0F 82 EF FC FF FF 31 D2 90 8D 74 26 00 E9 E8 FC FF FF 81 FF 63 8E 8D 37 C6 44 24 30 01 0F 87 80 F7 FF FF E9 A0 FD FF FF 90 8D 74 26 00 81 FE 63 8E 8D 37 C6 44 24 20 01 0F 87 38 F7 FF FF E9 35 FD FF FF 39 54 24 20 0F 8D AD FD FF FF 8B 44 24 28 39 44 24 18 73 0C 89 C8 F7 D0 C1 E8 1F E9 AB FC FF FF 77 0A 8B 44 24 10 39 44 24 08 72 E8 8B 44 24 18 33 44 24 28 89 44 24 30 8B 44 24 08 33 44 24 10 0B 44 24 30 0F 85 DD F7 FF FF 39 F7 0F 82 D5 F7 FF FF 0F 87 C5 F7 FF FF 39 2C 24 0F 86 C6 F7 FF FF E9 B7 F7 FF FF 8D 74 26 00 8B 54 24 18 8B 44 24 08 33 54 24 28 33 44 24 10 09 C2 74 07 31 D2 E9 7A FD FF FF 39 F7 77 F5 90 0F 82 6A FD FF FF 39 2C 24 0F 86 61 FD FF FF 31 D2 E9 5F FD FF FF 89 D0 2B 44 24 20 83 F8 21 0F 8F 65 FF FF FF 83 F8 13 0F 8E B5 04 00 00 8D 58 EC C1 E3 04 8B 83 ?? ?? ?? ?? 8B 93 ?? ?? ?? ?? C7 44 24 54 00 00 00 00 89 44 24 48 89 54 24 40 F7 E7 89 44 24 30 8B 44 24 40 89 54 24 34 F7 E7 89 44 24 58 8B 44 24 48 89 54 24 5C F7 24 24 89 54 24 3C 8B 54 24 30 89 44 24 38 89 54 24 50 8B 54 24 3C 89 D0 31 D2 89 44 24 20 8B 44 24 50 01 44 24 20 8B 44 24 40 89 54 24 24 8B 54 24 54 11 54 24 24 F7 24 24 01 44 24 20 11 54 24 24 8B 54 24 34 89 D0 31 D2 89 44 24 30 8B 44 24 58 01 44 24 30 89 54 24 34 8B 54 24 5C 11 54 24 34 8B 54 24 24 C7 44 24 7C 00 00 00 00 89 D0 31 D2 01 44 24 30 11 54 24 34 8B 93 ?? ?? ?? ?? 8B 9B ?? ?? ?? ?? 89 D0 89 54 24 58 F7 E7 89 44 24 60 89 D8 89 54 24 64 F7 E7 89 44 24 50 8B 44 24 58 89 54 24 54 F7 24 24 89 54 24 74 8B 54 24 60 89 44 24 70 89 54 24 78 8B 54 24 74 89 D0 31 D2 89 44 24 68 8B 44 24 78 89 54 24 6C 8B 54 24 7C 01 44 24 68 8B 04 24 11 54 24 6C C7 44 24 04 00 00 00 00 F7 E3 01 44 24 68 11 54 24 6C 8B 54 24 64 89 D0 31 D2 89 44 24 60 8B 44 24 50 01 44 24 60 89 54 24 64 8B 54 24 54 11 54 24 64 8B 54 24 6C 89 D0 31 D2 01 44 24 60 8B 44 24 20 11 54 24 64 89 C2 31 C0 89 54 24 24 8B 54 24 38 89 44 24 20 89 14 24 8B 04 24 8B 54 24 04 01 44 24 20 8B 44 24 60 11 54 24 24 01 44 24 20 8B 54 24 64 11 54 24 24 8B 44 24 24 39 C2 72 16 77 0A 8B 54 24 20 39 54 24 60 76 0A 83 44 24 30 01 83 54 24 34 00 8B 44 24 28 F7 64 24 48 C7 44 24 04 00 00 00 00 89 44 24 38 8B 44 24 28 89 54 24 3C F7 64 24 40 89 44 24 50 8B 44 24 10 89 54 24 54 F7 64 24 48 89 54 24 4C 8B 54 24 38 89 44 24 48 89 14 24 8B 54 24 4C 89 D0 31 D2 89 44 24 60 8B 44 24 10 89 54 24 64 F7 64 24 40 01 44 24 60 8B 04 24 11 54 24 64 01 44 24 60 8B 54 24 04 11 54 24 64 8B 54 24 3C 89 D0 31 D2 89 44 24 38 8B 44 24 50 01 44 24 38 89 54 24 3C 8B 54 24 54 11 54 24 3C 8B 54 24 64 C7 44 24 54 00 00 00 00 89 D0 31 D2 01 44 24 38 8B 44 24 28 11 54 24 3C F7 64 24 58 89 44 24 40 8B 44 24 28 89 54 24 44 F7 E3 89 44 24 28 8B 44 24 10 89 54 24 2C F7 64 24 58 89 54 24 5C 8B 54 24 40 89 44 24 58 89 54 24 50 8B 54 24 5C 89 D0 31 D2 89 04 24 8B 44 24 10 89 54 24 04 F7 E3 01 04 24 11 54 24 04 8B 44 24 50 01 04 24 8B 54 24 54 11 54 24 04 8B 54 24 44 89 D0 31 D2 89 44 24 40 8B 44 24 28 01 44 24 40 89 54 24 44 8B 54 24 2C 11 54 24 44 8B 54 24 04 89 D0 31 D2 01 44 24 40 8B 04 24 11 54 24 44 89 C2 31 C0 89 04 24 8B 44 24 58 89 54 24 04 31 D2 01 04 24 8B 44 24 60 11 54 24 04 89 C2 31 C0 89 44 24 28 8B 44 24 48 89 54 24 2C 31 D2 01 44 24 28 8B 44 24 40 11 54 24 2C 8B 54 24 44 01 44 24 28 11 54 24 2C 8B 5C 24 2C 39 DA 72 14 77 08 8B 54 24 28 39 D0 76 0A 83 44 24 38 01 83 54 24 3C 00 8B 44 24 20 8B 54 24 24 03 04 24 13 54 24 04 39 54 24 04 89 44 24 20 89 54 24 24 C7 44 24 10 01 00 00 00 C7 44 24 14 00 00 00 00 77 17 72 05 39 04 24 77 10 C7 44 24 10 00 00 00 00 C7 44 24 14 00 00 00 00 8B 44 24 28 8B 54 24 2C 03 44 24 10 13 54 24 14 89 44 24 28 8B 44 24 30 89 54 24 2C 8B 54 24 34 03 44 24 28 13 54 24 2C 39 54 24 2C 89 44 24 30 89 54 24 34 0F 87 AF 02 00 00 72 0A 39 44 24 28 0F 87 A3 02 00 00 8B 5C 24 2C 31 D2 B8 01 00 00 00 39 5C 24 14 77 10 72 0A 8B 5C 24 28 39 5C 24 10 77 04 31 C0 31 D2 03 44 24 38 13 54 24 3C 89 D3 09 C3 75 48 8B 44 24 34 0B 44 24 30 75 3E 8B 5C 24 70 8B 44 24 68 C7 44 24 04 00 00 00 00 89 1C 24 8B 5C 24 24 89 C2 31 C0 03 04 24 13 54 24 04 39 5C 24 18 74 27 8B 44 24 24 39 44 24 18 72 0C 77 37 8B 54 24 20 39 54 24 08 73 2D BA 01 00 00 00 89 C8 C1 E8 1F 31 D0 E9 B5 F7 FF FF 8B 5C 24 20 39 5C 24 08 75 CF 39 F2 0F 84 FD 02 00 00 39 F2 72 06 77 D7 39 E8 77 D3 31 D2 8D B6 00 00 00 00 EB CE 39 F7 73 0F 39 54 24 20 0F 8C 00 FB FF FF E9 68 F8 FF FF 0F 87 C8 F2 FF FF 39 2C 24 66 90 72 E4 E9 E9 FA FF FF B8 01 00 00 00 31 D2 E9 D9 F6 FF FF 8B 0C C5 ?? ?? ?? ?? 8B 04 C5 ?? ?? ?? ?? C7 44 24 4C 00 00 00 00 89 44 24 40 F7 64 24 10 89 44 24 20 8B 44 24 40 89 54 24 24 F7 64 24 28 89 44 24 38 8B 44 24 10 89 54 24 3C F7 E1 89 54 24 14 8B 54 24 20 89 44 24 10 89 54 24 48 8B 54 24 14 89 D0 31 D2 89 44 24 30 8B 44 24 48 01 44 24 30 8B 44 24 28 89 54 24 34 8B 54 24 4C 11 54 24 34 F7 E1 01 44 24 30 11 54 24 34 8B 54 24 24 89 D0 31 D2 89 44 24 20 8B 44 24 38 01 44 24 20 89 54 24 24 8B 54 24 3C 11 54 24 24 8B 54 24 34 C7 44 24 4C 00 00 00 00 89 D0 31 D2 01 44 24 20 8B 44 24 40 11 54 24 24 F7 24 24 89 44 24 28 8B 44 24 40 89 54 24 2C F7 E7 89 44 24 40 8B 04 24 89 54 24 44 F7 E1 89 54 24 04 8B 54 24 28 89 04 24 89 54 24 48 8B 54 24 04 89 D0 31 D2 89 44 }
	condition:
		$1
}

rule file_45_17_0 {
	meta:
		name = "___bid128_signaling_less_unordered"
		size = 4576
		refs = "01f5 ___bid_ten2k128 066a ___bid_IDEC_glbflags 07c6 ___bid_ten2k64"
	strings:
		$1 = { 81 EC BC 00 00 00 8B 8C 24 C8 00 00 00 89 9C 24 AC 00 00 00 8B 9C 24 D0 00 00 00 89 B4 24 B0 00 00 00 8B B4 24 C4 00 00 00 89 BC 24 B4 00 00 00 8B BC 24 D4 00 00 00 89 4C 24 08 8B 8C 24 CC 00 00 00 89 1C 24 8B 9C 24 D8 00 00 00 89 AC 24 B8 00 00 00 8B AC 24 C0 00 00 00 89 C8 25 00 00 00 7C 3D 00 00 00 7C 89 5C 24 10 8B 9C 24 DC 00 00 00 0F 84 F1 05 00 00 89 D8 25 00 00 00 7C 3D 00 00 00 7C 0F 84 DF 05 00 00 8B 04 24 89 FA 31 F2 31 E8 09 C2 0F 84 26 06 00 00 89 C8 25 00 00 00 78 3D 00 00 00 78 0F 84 74 06 00 00 89 D8 25 00 00 00 78 3D 00 00 00 78 0F 84 F2 05 00 00 89 C8 25 FF FF 01 00 3D 09 ED 01 00 89 44 24 18 0F 86 04 06 00 00 C6 44 24 20 01 89 DA 81 E2 FF FF 01 00 81 FA 09 ED 01 00 89 54 24 28 77 14 0F 82 52 06 00 00 81 7C 24 10 C0 87 AD BE 0F 86 44 06 00 00 C6 44 24 30 01 80 7C 24 20 00 BA 01 00 00 00 75 13 8B 44 24 18 31 D2 0B 44 24 08 75 07 89 EA 09 F2 0F 94 C2 80 7C 24 30 00 0F 85 72 05 00 00 8B 44 24 28 0B 44 24 10 0F 84 59 05 00 00 84 D2 0F 85 6A 05 00 00 89 CA 31 DA 0F 88 60 05 00 00 89 C8 89 DA C1 E8 11 C1 EA 11 25 FF 3F 00 00 81 E2 FF 3F 00 00 39 C2 89 44 24 20 0F 84 21 06 00 00 8B 44 24 28 39 44 24 18 0F 87 37 08 00 00 72 0E 8B 44 24 10 39 44 24 08 0F 87 27 08 00 00 8B 44 24 18 33 44 24 28 89 44 24 30 8B 44 24 08 33 44 24 10 0B 44 24 30 0F 84 C9 05 00 00 8B 44 24 28 39 44 24 18 72 0C 77 14 8B 44 24 10 39 44 24 08 73 0A 39 54 24 20 0F 8E FD 07 00 00 8B 44 24 20 29 D0 85 C0 0F 8E 7B 08 00 00 83 F8 21 0F 8F A4 05 00 00 83 F8 13 0F 8E D6 05 00 00 8D 48 EC C1 E1 04 8B 91 ?? ?? ?? ?? 8B 81 ?? ?? ?? ?? C7 44 24 54 00 00 00 00 89 54 24 58 89 44 24 40 89 D0 F7 E6 89 44 24 30 8B 44 24 40 89 54 24 34 F7 E6 89 44 24 38 8B 44 24 58 89 54 24 3C F7 E5 89 54 24 4C 8B 54 24 30 89 44 24 48 89 54 24 50 8B 54 24 4C 89 D0 31 D2 89 44 24 20 8B 44 24 50 01 44 24 20 8B 44 24 40 89 54 24 24 8B 54 24 54 11 54 24 24 F7 E5 01 44 24 20 11 54 24 24 8B 54 24 34 89 D0 31 D2 89 44 24 30 89 54 24 34 8B 44 24 38 01 44 24 30 8B 54 24 3C 11 54 24 34 8B 54 24 24 C7 44 24 74 00 00 00 00 89 D0 31 D2 01 44 24 30 11 54 24 34 8B 91 ?? ?? ?? ?? 8B 89 ?? ?? ?? ?? 89 D0 89 54 24 60 F7 E6 89 44 24 38 89 C8 89 54 24 3C F7 E6 89 44 24 50 8B 44 24 60 89 54 24 54 F7 E5 89 54 24 7C 8B 54 24 38 89 44 24 78 89 54 24 70 8B 54 24 7C 89 D0 31 D2 89 44 24 68 8B 44 24 70 01 44 24 68 89 C8 89 54 24 6C 8B 54 24 74 11 54 24 6C F7 E5 01 44 24 68 11 54 24 6C 8B 54 24 3C C7 44 24 3C 00 00 00 00 89 D0 31 D2 89 44 24 70 8B 44 24 50 01 44 24 70 89 54 24 74 8B 54 24 54 11 54 24 74 8B 54 24 6C 89 D0 31 D2 01 44 24 70 8B 44 24 20 11 54 24 74 89 C2 31 C0 89 54 24 24 8B 54 24 48 89 44 24 20 89 54 24 38 8B 44 24 38 01 44 24 20 8B 54 24 3C 11 54 24 24 8B 44 24 70 01 44 24 20 8B 54 24 74 11 54 24 24 8B 44 24 24 39 C2 72 16 77 0A 8B 54 24 20 39 54 24 70 76 0A 83 44 24 30 01 83 54 24 34 00 8B 44 24 18 F7 64 24 58 C7 44 24 3C 00 00 00 00 89 44 24 48 8B 44 24 18 89 54 24 4C F7 64 24 40 89 44 24 70 8B 44 24 08 89 54 24 74 F7 64 24 58 89 54 24 5C 8B 54 24 48 89 44 24 58 89 54 24 38 8B 54 24 5C 89 D0 31 D2 89 44 24 50 8B 44 24 08 89 54 24 54 F7 64 24 40 01 44 24 50 8B 44 24 38 11 54 24 54 01 44 24 50 8B 54 24 3C 11 54 24 54 8B 54 24 4C 89 D0 31 D2 89 44 24 48 8B 44 24 70 01 44 24 48 89 54 24 4C 8B 54 24 74 11 54 24 4C 8B 54 24 54 C7 44 24 74 00 00 00 00 89 D0 31 D2 01 44 24 48 8B 44 24 18 11 54 24 4C F7 64 24 60 89 44 24 38 8B 44 24 18 89 54 24 3C F7 E1 89 44 24 18 8B 44 24 08 89 54 24 1C F7 64 24 60 89 54 24 64 8B 54 24 38 89 44 24 60 89 54 24 70 8B 54 24 64 89 D0 31 D2 89 44 24 40 8B 44 24 08 89 54 24 44 F7 E1 01 44 24 40 11 54 24 44 8B 54 24 70 01 54 24 40 8B 54 24 3C 8B 4C 24 74 11 4C 24 44 8B 4C 24 1C 89 D0 31 D2 89 54 24 3C 8B 54 24 18 89 44 24 38 01 54 24 38 8B 54 24 44 11 4C 24 3C 89 D0 31 D2 01 44 24 38 8B 44 24 40 11 54 24 3C 89 C2 31 C0 89 44 24 40 8B 44 24 60 89 54 24 44 31 D2 01 44 24 40 11 54 24 44 8B 54 24 50 89 D1 31 D2 89 54 24 18 8B 44 24 58 31 D2 01 44 24 18 8B 44 24 38 89 4C 24 1C 11 54 24 1C 8B 54 24 3C 01 44 24 18 11 54 24 1C 8B 4C 24 1C 39 CA 72 14 77 08 8B 54 24 18 39 D0 76 0A 83 44 24 48 01 83 54 24 4C 00 8B 44 24 20 8B 54 24 24 03 44 24 40 13 54 24 44 39 54 24 44 89 44 24 20 89 54 24 24 C7 44 24 08 01 00 00 00 C7 44 24 0C 00 00 00 00 77 18 72 06 39 44 24 40 77 10 C7 44 24 08 00 00 00 00 C7 44 24 0C 00 00 00 00 8B 54 24 18 03 54 24 08 8B 4C 24 1C 13 4C 24 0C 89 54 24 38 8B 44 24 30 8B 54 24 34 03 44 24 38 89 4C 24 3C 13 54 24 3C 89 44 24 30 39 D1 89 54 24 34 0F 87 4C 09 00 00 72 0A 39 44 24 38 0F 87 40 09 00 00 8B 4C 24 3C 31 D2 B8 01 00 00 00 39 4C 24 0C 77 10 72 0A 8B 4C 24 38 39 4C 24 08 77 04 31 C0 31 D2 03 44 24 48 13 54 24 4C 89 D1 09 C1 75 5E 8B 44 24 34 0B 44 24 30 75 54 8B 54 24 68 8B 44 24 78 89 D1 31 D2 89 54 24 68 31 D2 01 44 24 68 8B 44 24 10 89 4C 24 6C 11 54 24 6C 8B 54 24 28 33 54 24 24 33 44 24 20 09 C2 0F 84 F3 0A 00 00 8B 44 24 24 39 44 24 28 72 14 0F 87 2F 03 00 00 8B 54 24 20 39 54 24 10 0F 83 21 03 00 00 BA 01 00 00 00 89 D8 F7 D0 C1 E8 1F 31 D0 EB 0C 83 0D ?? ?? ?? ?? 01 B8 01 00 00 00 8B 9C 24 AC 00 00 00 8B B4 24 B0 00 00 00 8B BC 24 B4 00 00 00 8B AC 24 B8 00 00 00 81 C4 BC 00 00 00 C3 8B 04 24 09 F8 0F 85 9C FA FF FF 31 C0 84 D2 75 CC 84 D2 0F 84 D8 00 00 00 89 D8 F7 D0 C1 E8 1F EB BB 8D B4 26 00 00 00 00 8B 44 24 10 89 DA 33 44 24 08 31 CA 09 C2 0F 85 C6 F9 FF FF 31 C0 EB 9C 72 0E 81 7C 24 08 C0 87 AD BE 0F 87 EC F9 FF FF 8B 54 24 18 8B 44 24 08 81 F2 09 ED 01 00 35 C0 87 AD BE 09 C2 0F 84 82 02 00 00 89 C8 25 00 00 00 60 3D 00 00 00 60 0F 94 44 24 20 E9 C0 F9 FF FF 8D B4 26 00 00 00 00 31 C0 85 C9 0F 89 4A FF FF FF 89 DA B0 01 81 E2 00 00 00 78 81 FA 00 00 00 78 0F 85 34 FF FF FF E9 6B FF FF FF 8B 54 24 28 8B 44 24 10 81 F2 09 ED 01 00 35 C0 87 AD BE 09 C2 0F 84 40 02 00 00 89 D8 25 00 00 00 60 3D 00 00 00 60 0F 94 44 24 30 E9 90 F9 FF FF 39 F7 0F 83 74 07 00 00 39 54 24 20 0F 8C 78 02 00 00 89 C8 C1 E8 1F E9 E2 FE FF FF 8B 5C 24 28 39 5C 24 18 77 14 0F 82 7E 02 00 00 8B 5C 24 10 39 5C 24 08 0F 86 70 02 00 00 BA 01 00 00 00 89 C8 F7 D0 C1 E8 1F 31 D0 E9 B1 FE FF FF 8B 0C C5 ?? ?? ?? ?? 8B 04 C5 ?? ?? ?? ?? C7 44 24 4C 00 00 00 00 89 44 24 40 F7 64 24 08 89 44 24 20 8B 44 24 40 89 54 24 24 F7 64 24 18 89 44 24 38 8B 44 24 08 89 54 24 3C F7 E1 89 54 24 0C 8B 54 24 20 89 44 24 08 89 54 24 48 8B 54 24 0C 89 D0 31 D2 89 44 24 30 8B 44 24 48 01 44 24 30 8B 44 24 18 89 54 24 34 8B 54 24 4C 11 54 24 34 F7 E1 01 44 24 30 11 54 24 34 8B 54 24 24 89 D0 31 D2 89 44 24 20 8B 44 24 38 01 44 24 20 89 54 24 24 8B 54 24 3C 11 54 24 24 8B 54 24 34 C7 44 24 54 00 00 00 00 89 D0 31 D2 01 44 24 20 8B 44 24 40 11 54 24 24 F7 E5 89 44 24 18 8B 44 24 40 89 54 24 1C F7 E6 89 44 24 40 89 C8 89 54 24 44 F7 E5 89 54 24 4C 8B 54 24 18 89 44 24 48 89 54 24 50 8B 54 24 4C 89 D0 31 D2 89 44 24 38 8B 44 24 50 01 44 24 38 89 C8 89 54 24 3C 8B 54 24 54 11 54 24 3C 8B 4C 24 1C F7 E6 01 44 24 38 11 54 24 3C 8B 44 24 40 89 CA 31 C9 89 54 24 18 8B 54 24 44 01 44 24 18 89 4C 24 1C 8B 4C 24 08 11 54 24 1C 8B 54 24 3C C7 44 24 34 00 00 00 00 89 D0 31 D2 01 44 24 18 8B 44 24 30 11 54 24 1C 89 4C 24 30 89 C2 31 C0 03 44 24 30 13 54 24 34 03 44 24 18 13 54 24 1C 39 54 24 1C 72 12 77 06 39 44 24 18 76 0A 83 44 24 20 01 83 54 24 24 00 8B 4C 24 24 0B 4C 24 20 0F 85 09 FD FF FF 8B 74 24 28 8B 4C 24 10 31 D6 31 C1 09 CE 0F 84 84 07 00 00 39 54 24 28 0F 82 EB FC FF FF 77 0A 39 44 24 10 0F 82 DF FC FF FF 31 D2 90 8D 74 26 00 E9 D8 FC FF FF 81 FE 63 8E 8D 37 C6 44 24 20 01 0F 87 43 F7 FF FF E9 68 FD FF FF 90 8D 74 26 00 81 FF 63 8E 8D 37 C6 44 24 30 01 0F 87 55 F7 FF FF E9 AA FD FF FF 39 54 24 20 0F 8D C8 FD FF FF 8B 44 24 28 39 44 24 18 73 0C 89 C8 F7 D0 C1 E8 1F E9 9E FC FF FF 77 0A 8B 44 24 10 39 44 24 08 72 E8 8B 44 24 18 33 44 24 28 89 44 24 30 8B 44 24 08 33 44 24 10 0B 44 24 30 0F 85 CD F7 FF FF 39 F7 0F 82 C5 F7 FF FF 0F 87 B5 F7 FF FF 39 2C 24 0F 86 B6 F7 FF FF E9 A7 F7 FF FF 8D 74 26 00 8B 54 24 18 8B 44 24 08 33 54 24 28 33 44 24 10 09 C2 74 07 31 D2 E9 7A FD FF FF 39 F7 77 F5 90 0F 82 6A FD FF FF 39 2C 24 0F 86 61 FD FF FF 31 D2 E9 5F FD FF FF 89 D0 2B 44 24 20 83 F8 21 0F 8F 65 FF FF FF 83 F8 13 0F 8E A9 04 00 00 8D 58 EC C1 E3 04 8B 83 ?? ?? ?? ?? 8B 93 ?? ?? ?? ?? C7 44 24 54 00 00 00 00 89 44 24 48 89 54 24 40 F7 E7 89 44 24 30 8B 44 24 40 89 54 24 34 F7 E7 89 44 24 58 8B 44 24 48 89 54 24 5C F7 24 24 89 54 24 3C 8B 54 24 30 89 44 24 38 89 54 24 50 8B 54 24 3C 89 D0 31 D2 89 44 24 20 8B 44 24 50 01 44 24 20 8B 44 24 40 89 54 24 24 8B 54 24 54 11 54 24 24 F7 24 24 01 44 24 20 11 54 24 24 8B 54 24 34 89 D0 31 D2 89 44 24 30 8B 44 24 58 01 44 24 30 89 54 24 34 8B 54 24 5C 11 54 24 34 8B 54 24 24 C7 44 24 7C 00 00 00 00 89 D0 31 D2 01 44 24 30 11 54 24 34 8B 93 ?? ?? ?? ?? 8B 9B ?? ?? ?? ?? 89 D0 89 54 24 58 F7 E7 89 44 24 60 89 D8 89 54 24 64 F7 E7 89 44 24 50 8B 44 24 58 89 54 24 54 F7 24 24 89 54 24 74 8B 54 24 60 89 44 24 70 89 54 24 78 8B 54 24 74 89 D0 31 D2 89 44 24 68 8B 44 24 78 89 54 24 6C 8B 54 24 7C 01 44 24 68 8B 04 24 11 54 24 6C C7 44 24 04 00 00 00 00 F7 E3 01 44 24 68 11 54 24 6C 8B 54 24 64 89 D0 31 D2 89 44 24 60 8B 44 24 50 01 44 24 60 89 54 24 64 8B 54 24 54 11 54 24 64 8B 54 24 6C 89 D0 31 D2 01 44 24 60 8B 44 24 20 11 54 24 64 89 C2 31 C0 89 54 24 24 8B 54 24 38 89 44 24 20 89 14 24 8B 04 24 8B 54 24 04 01 44 24 20 8B 44 24 60 11 54 24 24 01 44 24 20 8B 54 24 64 11 54 24 24 8B 44 24 24 39 C2 72 16 77 0A 8B 54 24 20 39 54 24 60 76 0A 83 44 24 30 01 83 54 24 34 00 8B 44 24 28 F7 64 24 48 C7 44 24 04 00 00 00 00 89 44 24 38 8B 44 24 28 89 54 24 3C F7 64 24 40 89 44 24 50 8B 44 24 10 89 54 24 54 F7 64 24 48 89 54 24 4C 8B 54 24 38 89 44 24 48 89 14 24 8B 54 24 4C 89 D0 31 D2 89 44 24 60 8B 44 24 10 89 54 24 64 F7 64 24 40 01 44 24 60 8B 04 24 11 54 24 64 01 44 24 60 8B 54 24 04 11 54 24 64 8B 54 24 3C 89 D0 31 D2 89 44 24 38 8B 44 24 50 01 44 24 38 89 54 24 3C 8B 54 24 54 11 54 24 3C 8B 54 24 64 C7 44 24 54 00 00 00 00 89 D0 31 D2 01 44 24 38 8B 44 24 28 11 54 24 3C F7 64 24 58 89 44 24 40 8B 44 24 28 89 54 24 44 F7 E3 89 44 24 28 8B 44 24 10 89 54 24 2C F7 64 24 58 89 54 24 5C 8B 54 24 40 89 44 24 58 89 54 24 50 8B 54 24 5C 89 D0 31 D2 89 04 24 8B 44 24 10 89 54 24 04 F7 E3 01 04 24 11 54 24 04 8B 44 24 50 01 04 24 8B 54 24 54 11 54 24 04 8B 54 24 44 89 D0 31 D2 89 44 24 40 8B 44 24 28 01 44 24 40 89 54 24 44 8B 54 24 2C 11 54 24 44 8B 54 24 04 89 D0 31 D2 01 44 24 40 8B 04 24 11 54 24 44 89 C2 31 C0 89 04 24 8B 44 24 58 89 54 24 04 31 D2 01 04 24 8B 44 24 60 11 54 24 04 89 C2 31 C0 89 44 24 28 8B 44 24 48 89 54 24 2C 31 D2 01 44 24 28 8B 44 24 40 11 54 24 2C 8B 54 24 44 01 44 24 28 11 54 24 2C 8B 5C 24 2C 39 DA 72 14 77 08 8B 54 24 28 39 D0 76 0A 83 44 24 38 01 83 54 24 3C 00 8B 44 24 20 8B 54 24 24 03 04 24 13 54 24 04 39 54 24 04 89 44 24 20 89 54 24 24 C7 44 24 10 01 00 00 00 C7 44 24 14 00 00 00 00 77 17 72 05 39 04 24 77 10 C7 44 24 10 00 00 00 00 C7 44 24 14 00 00 00 00 8B 44 24 28 8B 54 24 2C 03 44 24 10 13 54 24 14 89 44 24 28 8B 44 24 30 89 54 24 2C 8B 54 24 34 03 44 24 28 13 54 24 2C 39 54 24 2C 89 44 24 30 89 54 24 34 0F 87 A3 02 00 00 72 0A 39 44 24 28 0F 87 97 02 00 00 8B 5C 24 2C 31 D2 B8 01 00 00 00 39 5C 24 14 77 10 72 0A 8B 5C 24 28 39 5C 24 10 77 04 31 C0 31 D2 03 44 24 38 13 54 24 3C 89 D3 09 C3 75 48 8B 44 24 34 0B 44 24 30 75 3E 8B 5C 24 70 8B 44 24 68 C7 44 24 04 00 00 00 00 89 1C 24 8B 5C 24 24 89 C2 31 C0 03 04 24 13 54 24 04 39 5C 24 18 74 27 8B 44 24 24 39 44 24 18 72 0C 77 37 8B 54 24 20 39 54 24 08 73 2D BA 01 00 00 00 89 C8 C1 E8 1F 31 D0 E9 A8 F7 FF FF 8B 5C 24 20 39 5C 24 08 75 CF 39 F2 0F 84 EF 02 00 00 39 F2 72 06 77 D7 39 E8 77 D3 31 D2 8D B6 00 00 00 00 EB CE 0F 87 CB F2 FF FF 39 2C 24 90 8D 74 26 00 0F 82 78 F8 FF FF E9 F5 FA FF FF B8 01 00 00 00 31 D2 E9 D5 F6 FF FF 8B 0C C5 ?? ?? ?? ?? 8B 04 C5 ?? ?? ?? ?? C7 44 24 4C 00 00 00 00 89 44 24 40 F7 64 24 10 89 44 24 20 8B 44 24 40 89 54 24 24 F7 64 24 28 89 44 24 38 8B 44 24 10 89 54 24 3C F7 E1 89 54 24 14 8B 54 24 20 89 44 24 10 89 54 24 48 8B 54 24 14 89 D0 31 D2 89 44 24 30 8B 44 24 48 01 44 24 30 8B 44 24 28 89 54 24 34 8B 54 24 4C 11 54 24 34 F7 E1 01 44 24 30 11 54 24 34 8B 54 24 24 89 D0 31 D2 89 44 24 20 8B 44 24 38 01 44 24 20 89 54 24 24 8B 54 24 3C 11 54 24 24 8B 54 24 34 C7 44 24 4C 00 00 00 00 89 D0 31 D2 01 44 24 20 8B 44 24 40 11 54 24 24 F7 24 24 89 44 24 28 8B 44 24 40 89 54 24 2C F7 E7 89 44 24 40 8B 04 24 89 54 24 44 F7 E1 89 54 24 04 8B 54 24 28 89 04 24 89 54 24 48 8B 54 24 04 89 D0 }
	condition:
		$1
}

rule file_45_18_0 {
	meta:
		name = "___bid128_signaling_not_greater"
		size = 4576
		refs = "01f5 ___bid_ten2k128 066a ___bid_IDEC_glbflags 07b6 ___bid_ten2k64"
	strings:
		$1 = { 81 EC BC 00 00 00 8B 8C 24 C8 00 00 00 89 9C 24 AC 00 00 00 8B 9C 24 D0 00 00 00 89 B4 24 B0 00 00 00 8B B4 24 C4 00 00 00 89 BC 24 B4 00 00 00 8B BC 24 D4 00 00 00 89 4C 24 08 8B 8C 24 CC 00 00 00 89 1C 24 8B 9C 24 D8 00 00 00 89 AC 24 B8 00 00 00 8B AC 24 C0 00 00 00 89 C8 25 00 00 00 7C 3D 00 00 00 7C 89 5C 24 10 8B 9C 24 DC 00 00 00 0F 84 F1 05 00 00 89 D8 25 00 00 00 7C 3D 00 00 00 7C 0F 84 DF 05 00 00 8B 04 24 89 FA 31 F2 31 E8 09 C2 0F 84 FD 05 00 00 89 C8 25 00 00 00 78 3D 00 00 00 78 0F 84 47 06 00 00 89 D8 25 00 00 00 78 3D 00 00 00 78 0F 84 A9 06 00 00 89 C8 25 FF FF 01 00 3D 09 ED 01 00 89 44 24 18 0F 86 DE 05 00 00 C6 44 24 20 01 89 DA 81 E2 FF FF 01 00 81 FA 09 ED 01 00 89 54 24 28 77 14 0F 82 1D 06 00 00 81 7C 24 10 C0 87 AD BE 0F 86 0F 06 00 00 C6 44 24 30 01 80 7C 24 20 00 BA 01 00 00 00 75 13 8B 44 24 18 31 D2 0B 44 24 08 75 07 89 EA 09 F2 0F 94 C2 80 7C 24 30 00 0F 85 1C 06 00 00 8B 44 24 28 0B 44 24 10 0F 84 03 06 00 00 84 D2 0F 85 21 06 00 00 89 CA 31 DA 0F 88 17 06 00 00 89 C8 89 DA C1 E8 11 C1 EA 11 25 FF 3F 00 00 81 E2 FF 3F 00 00 39 C2 89 44 24 20 0F 84 11 06 00 00 8B 44 24 28 39 44 24 18 0F 87 27 08 00 00 72 0E 8B 44 24 10 39 44 24 08 0F 87 17 08 00 00 8B 44 24 18 33 44 24 28 89 44 24 30 8B 44 24 08 33 44 24 10 0B 44 24 30 0F 84 35 0D 00 00 8B 44 24 28 39 44 24 18 72 0C 77 14 8B 44 24 10 39 44 24 08 73 0A 39 54 24 20 0F 8E ED 07 00 00 8B 44 24 20 29 D0 85 C0 0F 8E 6B 08 00 00 83 F8 21 0F 8F 79 05 00 00 83 F8 13 0F 8E C6 05 00 00 8D 48 EC C1 E1 04 8B 91 ?? ?? ?? ?? 8B 81 ?? ?? ?? ?? C7 44 24 54 00 00 00 00 89 54 24 58 89 44 24 40 89 D0 F7 E6 89 44 24 30 8B 44 24 40 89 54 24 34 F7 E6 89 44 24 38 8B 44 24 58 89 54 24 3C F7 E5 89 54 24 4C 8B 54 24 30 89 44 24 48 89 54 24 50 8B 54 24 4C 89 D0 31 D2 89 44 24 20 8B 44 24 50 01 44 24 20 8B 44 24 40 89 54 24 24 8B 54 24 54 11 54 24 24 F7 E5 01 44 24 20 11 54 24 24 8B 54 24 34 89 D0 31 D2 89 44 24 30 89 54 24 34 8B 44 24 38 01 44 24 30 8B 54 24 3C 11 54 24 34 8B 54 24 24 C7 44 24 74 00 00 00 00 89 D0 31 D2 01 44 24 30 11 54 24 34 8B 91 ?? ?? ?? ?? 8B 89 ?? ?? ?? ?? 89 D0 89 54 24 60 F7 E6 89 44 24 38 89 C8 89 54 24 3C F7 E6 89 44 24 50 8B 44 24 60 89 54 24 54 F7 E5 89 54 24 7C 8B 54 24 38 89 44 24 78 89 54 24 70 8B 54 24 7C 89 D0 31 D2 89 44 24 68 8B 44 24 70 01 44 24 68 89 C8 89 54 24 6C 8B 54 24 74 11 54 24 6C F7 E5 01 44 24 68 11 54 24 6C 8B 54 24 3C C7 44 24 3C 00 00 00 00 89 D0 31 D2 89 44 24 70 8B 44 24 50 01 44 24 70 89 54 24 74 8B 54 24 54 11 54 24 74 8B 54 24 6C 89 D0 31 D2 01 44 24 70 8B 44 24 20 11 54 24 74 89 C2 31 C0 89 54 24 24 8B 54 24 48 89 44 24 20 89 54 24 38 8B 44 24 38 01 44 24 20 8B 54 24 3C 11 54 24 24 8B 44 24 70 01 44 24 20 8B 54 24 74 11 54 24 24 8B 44 24 24 39 C2 72 16 77 0A 8B 54 24 20 39 54 24 70 76 0A 83 44 24 30 01 83 54 24 34 00 8B 44 24 18 F7 64 24 58 C7 44 24 3C 00 00 00 00 89 44 24 48 8B 44 24 18 89 54 24 4C F7 64 24 40 89 44 24 70 8B 44 24 08 89 54 24 74 F7 64 24 58 89 54 24 5C 8B 54 24 48 89 44 24 58 89 54 24 38 8B 54 24 5C 89 D0 31 D2 89 44 24 50 8B 44 24 08 89 54 24 54 F7 64 24 40 01 44 24 50 8B 44 24 38 11 54 24 54 01 44 24 50 8B 54 24 3C 11 54 24 54 8B 54 24 4C 89 D0 31 D2 89 44 24 48 8B 44 24 70 01 44 24 48 89 54 24 4C 8B 54 24 74 11 54 24 4C 8B 54 24 54 C7 44 24 74 00 00 00 00 89 D0 31 D2 01 44 24 48 8B 44 24 18 11 54 24 4C F7 64 24 60 89 44 24 38 8B 44 24 18 89 54 24 3C F7 E1 89 44 24 18 8B 44 24 08 89 54 24 1C F7 64 24 60 89 54 24 64 8B 54 24 38 89 44 24 60 89 54 24 70 8B 54 24 64 89 D0 31 D2 89 44 24 40 8B 44 24 08 89 54 24 44 F7 E1 01 44 24 40 11 54 24 44 8B 54 24 70 01 54 24 40 8B 54 24 3C 8B 4C 24 74 11 4C 24 44 8B 4C 24 1C 89 D0 31 D2 89 54 24 3C 8B 54 24 18 89 44 24 38 01 54 24 38 8B 54 24 44 11 4C 24 3C 89 D0 31 D2 01 44 24 38 8B 44 24 40 11 54 24 3C 89 C2 31 C0 89 44 24 40 8B 44 24 60 89 54 24 44 31 D2 01 44 24 40 11 54 24 44 8B 54 24 50 89 D1 31 D2 89 54 24 18 8B 44 24 58 31 D2 01 44 24 18 8B 44 24 38 89 4C 24 1C 11 54 24 1C 8B 54 24 3C 01 44 24 18 11 54 24 1C 8B 4C 24 1C 39 CA 72 14 77 08 8B 54 24 18 39 D0 76 0A 83 44 24 48 01 83 54 24 4C 00 8B 44 24 20 8B 54 24 24 03 44 24 40 13 54 24 44 39 54 24 44 89 44 24 20 89 54 24 24 C7 44 24 08 01 00 00 00 C7 44 24 0C 00 00 00 00 77 18 72 06 39 44 24 40 77 10 C7 44 24 08 00 00 00 00 C7 44 24 0C 00 00 00 00 8B 54 24 18 03 54 24 08 8B 4C 24 1C 13 4C 24 0C 89 54 24 38 8B 44 24 30 8B 54 24 34 03 44 24 38 89 4C 24 3C 13 54 24 3C 89 44 24 30 39 D1 89 54 24 34 0F 87 48 09 00 00 72 0A 39 44 24 38 0F 87 3C 09 00 00 8B 4C 24 3C 31 D2 B8 01 00 00 00 39 4C 24 0C 77 10 72 0A 8B 4C 24 38 39 4C 24 08 77 04 31 C0 31 D2 03 44 24 48 13 54 24 4C 89 D1 09 C1 75 5E 8B 44 24 34 0B 44 24 30 75 54 8B 54 24 68 8B 44 24 78 89 D1 31 D2 89 54 24 68 31 D2 01 44 24 68 8B 44 24 10 89 4C 24 6C 11 54 24 6C 8B 54 24 28 33 54 24 24 33 44 24 20 09 C2 0F 84 F3 0A 00 00 8B 44 24 24 39 44 24 28 72 14 0F 87 1F 03 00 00 8B 54 24 20 39 54 24 10 0F 83 11 03 00 00 BA 01 00 00 00 89 D8 F7 D0 C1 E8 1F 31 D0 EB 0C 83 0D ?? ?? ?? ?? 01 B8 01 00 00 00 8B 9C 24 AC 00 00 00 8B B4 24 B0 00 00 00 8B BC 24 B4 00 00 00 8B AC 24 B8 00 00 00 81 C4 BC 00 00 00 C3 8B 44 24 10 89 DA 33 44 24 08 31 CA 09 C2 0F 85 EF F9 FF FF B8 01 00 00 00 EB C2 72 0E 81 7C 24 08 C0 87 AD BE 0F 87 12 FA FF FF 8B 54 24 18 8B 44 24 08 81 F2 09 ED 01 00 35 C0 87 AD BE 09 C2 0F 84 B3 02 00 00 89 C8 25 00 00 00 60 3D 00 00 00 60 0F 94 44 24 20 E9 E6 F9 FF FF 85 C9 78 B4 89 D8 25 00 00 00 78 3D 00 00 00 78 74 6E 31 C0 E9 68 FF FF FF 8D 74 26 00 8B 54 24 28 8B 44 24 10 81 F2 09 ED 01 00 35 C0 87 AD BE 09 C2 0F 84 4A 02 00 00 89 D8 25 00 00 00 60 3D 00 00 00 60 0F 94 44 24 30 E9 C5 F9 FF FF 8B 04 24 09 F8 0F 85 F2 F9 FF FF 84 D2 B8 01 00 00 00 0F 85 1B FF FF FF 84 D2 75 0A 89 C8 C1 E8 1F E9 0D FF FF FF 89 D8 F7 D0 C1 E8 1F E9 01 FF FF FF 85 DB B8 01 00 00 00 0F 89 F4 FE FF FF EB 83 8B 5C 24 28 39 5C 24 18 77 14 0F 82 7E 02 00 00 8B 5C 24 10 39 5C 24 08 0F 86 70 02 00 00 BA 01 00 00 00 89 C8 F7 D0 C1 E8 1F 31 D0 E9 C1 FE FF FF 8B 0C C5 ?? ?? ?? ?? 8B 04 C5 ?? ?? ?? ?? C7 44 24 4C 00 00 00 00 89 44 24 40 F7 64 24 08 89 44 24 20 8B 44 24 40 89 54 24 24 F7 64 24 18 89 44 24 38 8B 44 24 08 89 54 24 3C F7 E1 89 54 24 0C 8B 54 24 20 89 44 24 08 89 54 24 48 8B 54 24 0C 89 D0 31 D2 89 44 24 30 8B 44 24 48 01 44 24 30 8B 44 24 18 89 54 24 34 8B 54 24 4C 11 54 24 34 F7 E1 01 44 24 30 11 54 24 34 8B 54 24 24 89 D0 31 D2 89 44 24 20 8B 44 24 38 01 44 24 20 89 54 24 24 8B 54 24 3C 11 54 24 24 8B 54 24 34 C7 44 24 54 00 00 00 00 89 D0 31 D2 01 44 24 20 8B 44 24 40 11 54 24 24 F7 E5 89 44 24 18 8B 44 24 40 89 54 24 1C F7 E6 89 44 24 40 89 C8 89 54 24 44 F7 E5 89 54 24 4C 8B 54 24 18 89 44 24 48 89 54 24 50 8B 54 24 4C 89 D0 31 D2 89 44 24 38 8B 44 24 50 01 44 24 38 89 C8 89 54 24 3C 8B 54 24 54 11 54 24 3C 8B 4C 24 1C F7 E6 01 44 24 38 11 54 24 3C 8B 44 24 40 89 CA 31 C9 89 54 24 18 8B 54 24 44 01 44 24 18 89 4C 24 1C 8B 4C 24 08 11 54 24 1C 8B 54 24 3C C7 44 24 34 00 00 00 00 89 D0 31 D2 01 44 24 18 8B 44 24 30 11 54 24 1C 89 4C 24 30 89 C2 31 C0 03 44 24 30 13 54 24 34 03 44 24 18 13 54 24 1C 39 54 24 1C 72 12 77 06 39 44 24 18 76 0A 83 44 24 20 01 83 54 24 24 00 8B 4C 24 24 0B 4C 24 20 0F 85 19 FD FF FF 8B 74 24 28 8B 4C 24 10 31 D6 31 C1 09 CE 0F 84 90 07 00 00 39 54 24 28 0F 82 FB FC FF FF 77 0A 39 44 24 10 0F 82 EF FC FF FF 31 D2 90 8D 74 26 00 E9 E8 FC FF FF 81 FF 63 8E 8D 37 C6 44 24 30 01 0F 87 80 F7 FF FF E9 A0 FD FF FF 90 8D 74 26 00 81 FE 63 8E 8D 37 C6 44 24 20 01 0F 87 38 F7 FF FF E9 37 FD FF FF 39 54 24 20 0F 8D AD FD FF FF 8B 44 24 28 39 44 24 18 73 0C 89 C8 F7 D0 C1 E8 1F E9 AE FC FF FF 77 0A 8B 44 24 10 39 44 24 08 72 E8 8B 44 24 18 33 44 24 28 89 44 24 30 8B 44 24 08 33 44 24 10 0B 44 24 30 0F 85 DD F7 FF FF 39 F7 0F 82 D5 F7 FF FF 0F 87 C5 F7 FF FF 39 2C 24 0F 86 C6 F7 FF FF E9 B7 F7 FF FF 8D 74 26 00 8B 54 24 18 8B 44 24 08 33 54 24 28 33 44 24 10 09 C2 74 07 31 D2 E9 7A FD FF FF 39 F7 77 F5 90 0F 82 6A FD FF FF 39 2C 24 0F 86 61 FD FF FF 31 D2 E9 5F FD FF FF 89 D0 2B 44 24 20 83 F8 21 0F 8F 65 FF FF FF 83 F8 13 0F 8E B5 04 00 00 8D 58 EC C1 E3 04 8B 83 ?? ?? ?? ?? 8B 93 ?? ?? ?? ?? C7 44 24 54 00 00 00 00 89 44 24 48 89 54 24 40 F7 E7 89 44 24 30 8B 44 24 40 89 54 24 34 F7 E7 89 44 24 58 8B 44 24 48 89 54 24 5C F7 24 24 89 54 24 3C 8B 54 24 30 89 44 24 38 89 54 24 50 8B 54 24 3C 89 D0 31 D2 89 44 24 20 8B 44 24 50 01 44 24 20 8B 44 24 40 89 54 24 24 8B 54 24 54 11 54 24 24 F7 24 24 01 44 24 20 11 54 24 24 8B 54 24 34 89 D0 31 D2 89 44 24 30 8B 44 24 58 01 44 24 30 89 54 24 34 8B 54 24 5C 11 54 24 34 8B 54 24 24 C7 44 24 7C 00 00 00 00 89 D0 31 D2 01 44 24 30 11 54 24 34 8B 93 ?? ?? ?? ?? 8B 9B ?? ?? ?? ?? 89 D0 89 54 24 58 F7 E7 89 44 24 60 89 D8 89 54 24 64 F7 E7 89 44 24 50 8B 44 24 58 89 54 24 54 F7 24 24 89 54 24 74 8B 54 24 60 89 44 24 70 89 54 24 78 8B 54 24 74 89 D0 31 D2 89 44 24 68 8B 44 24 78 89 54 24 6C 8B 54 24 7C 01 44 24 68 8B 04 24 11 54 24 6C C7 44 24 04 00 00 00 00 F7 E3 01 44 24 68 11 54 24 6C 8B 54 24 64 89 D0 31 D2 89 44 24 60 8B 44 24 50 01 44 24 60 89 54 24 64 8B 54 24 54 11 54 24 64 8B 54 24 6C 89 D0 31 D2 01 44 24 60 8B 44 24 20 11 54 24 64 89 C2 31 C0 89 54 24 24 8B 54 24 38 89 44 24 20 89 14 24 8B 04 24 8B 54 24 04 01 44 24 20 8B 44 24 60 11 54 24 24 01 44 24 20 8B 54 24 64 11 54 24 24 8B 44 24 24 39 C2 72 16 77 0A 8B 54 24 20 39 54 24 60 76 0A 83 44 24 30 01 83 54 24 34 00 8B 44 24 28 F7 64 24 48 C7 44 24 04 00 00 00 00 89 44 24 38 8B 44 24 28 89 54 24 3C F7 64 24 40 89 44 24 50 8B 44 24 10 89 54 24 54 F7 64 24 48 89 54 24 4C 8B 54 24 38 89 44 24 48 89 14 24 8B 54 24 4C 89 D0 31 D2 89 44 24 60 8B 44 24 10 89 54 24 64 F7 64 24 40 01 44 24 60 8B 04 24 11 54 24 64 01 44 24 60 8B 54 24 04 11 54 24 64 8B 54 24 3C 89 D0 31 D2 89 44 24 38 8B 44 24 50 01 44 24 38 89 54 24 3C 8B 54 24 54 11 54 24 3C 8B 54 24 64 C7 44 24 54 00 00 00 00 89 D0 31 D2 01 44 24 38 8B 44 24 28 11 54 24 3C F7 64 24 58 89 44 24 40 8B 44 24 28 89 54 24 44 F7 E3 89 44 24 28 8B 44 24 10 89 54 24 2C F7 64 24 58 89 54 24 5C 8B 54 24 40 89 44 24 58 89 54 24 50 8B 54 24 5C 89 D0 31 D2 89 04 24 8B 44 24 10 89 54 24 04 F7 E3 01 04 24 11 54 24 04 8B 44 24 50 01 04 24 8B 54 24 54 11 54 24 04 8B 54 24 44 89 D0 31 D2 89 44 24 40 8B 44 24 28 01 44 24 40 89 54 24 44 8B 54 24 2C 11 54 24 44 8B 54 24 04 89 D0 31 D2 01 44 24 40 8B 04 24 11 54 24 44 89 C2 31 C0 89 04 24 8B 44 24 58 89 54 24 04 31 D2 01 04 24 8B 44 24 60 11 54 24 04 89 C2 31 C0 89 44 24 28 8B 44 24 48 89 54 24 2C 31 D2 01 44 24 28 8B 44 24 40 11 54 24 2C 8B 54 24 44 01 44 24 28 11 54 24 2C 8B 5C 24 2C 39 DA 72 14 77 08 8B 54 24 28 39 D0 76 0A 83 44 24 38 01 83 54 24 3C 00 8B 44 24 20 8B 54 24 24 03 04 24 13 54 24 04 39 54 24 04 89 44 24 20 89 54 24 24 C7 44 24 10 01 00 00 00 C7 44 24 14 00 00 00 00 77 17 72 05 39 04 24 77 10 C7 44 24 10 00 00 00 00 C7 44 24 14 00 00 00 00 8B 44 24 28 8B 54 24 2C 03 44 24 10 13 54 24 14 89 44 24 28 8B 44 24 30 89 54 24 2C 8B 54 24 34 03 44 24 28 13 54 24 2C 39 54 24 2C 89 44 24 30 89 54 24 34 0F 87 AF 02 00 00 72 0A 39 44 24 28 0F 87 A3 02 00 00 8B 5C 24 2C 31 D2 B8 01 00 00 00 39 5C 24 14 77 10 72 0A 8B 5C 24 28 39 5C 24 10 77 04 31 C0 31 D2 03 44 24 38 13 54 24 3C 89 D3 09 C3 75 48 8B 44 24 34 0B 44 24 30 75 3E 8B 5C 24 70 8B 44 24 68 C7 44 24 04 00 00 00 00 89 1C 24 8B 5C 24 24 89 C2 31 C0 03 04 24 13 54 24 04 39 5C 24 18 74 27 8B 44 24 24 39 44 24 18 72 0C 77 37 8B 54 24 20 39 54 24 08 73 2D BA 01 00 00 00 89 C8 C1 E8 1F 31 D0 E9 B8 F7 FF FF 8B 5C 24 20 39 5C 24 08 75 CF 39 F2 0F 84 FD 02 00 00 39 F2 72 06 77 D7 39 E8 77 D3 31 D2 8D B6 00 00 00 00 EB CE 39 F7 73 0F 39 54 24 20 0F 8C 00 FB FF FF E9 68 F8 FF FF 0F 87 C8 F2 FF FF 39 2C 24 66 90 72 E4 E9 E9 FA FF FF B8 01 00 00 00 31 D2 E9 D9 F6 FF FF 8B 0C C5 ?? ?? ?? ?? 8B 04 C5 ?? ?? ?? ?? C7 44 24 4C 00 00 00 00 89 44 24 40 F7 64 24 10 89 44 24 20 8B 44 24 40 89 54 24 24 F7 64 24 28 89 44 24 38 8B 44 24 10 89 54 24 3C F7 E1 89 54 24 14 8B 54 24 20 89 44 24 10 89 54 24 48 8B 54 24 14 89 D0 31 D2 89 44 24 30 8B 44 24 48 01 44 24 30 8B 44 24 28 89 54 24 34 8B 54 24 4C 11 54 24 34 F7 E1 01 44 24 30 11 54 24 34 8B 54 24 24 89 D0 31 D2 89 44 24 20 8B 44 24 38 01 44 24 20 89 54 24 24 8B 54 24 3C 11 54 24 24 8B 54 24 34 C7 44 24 4C 00 00 00 00 89 D0 31 D2 01 44 24 20 8B 44 24 40 11 54 24 24 F7 24 24 89 44 24 28 8B 44 24 40 89 54 24 2C F7 E7 89 44 24 40 8B 04 24 89 54 24 44 F7 E1 89 54 24 04 8B 54 24 28 89 04 24 89 54 24 48 8B 54 24 04 89 D0 31 D2 89 44 }
	condition:
		$1
}

rule file_45_19_0 {
	meta:
		name = "___bid128_signaling_not_less"
		size = 4576
		refs = "01d0 ___bid_ten2k128 0642 ___bid_IDEC_glbflags 07ab ___bid_ten2k64"
	strings:
		$1 = { 81 EC BC 00 00 00 8B 8C 24 C8 00 00 00 89 9C 24 AC 00 00 00 8B 9C 24 D0 00 00 00 89 B4 24 B0 00 00 00 8B B4 24 C4 00 00 00 89 BC 24 B4 00 00 00 8B BC 24 D4 00 00 00 89 4C 24 08 8B 8C 24 CC 00 00 00 89 1C 24 8B 9C 24 D8 00 00 00 89 AC 24 B8 00 00 00 8B AC 24 C0 00 00 00 89 C8 25 00 00 00 7C 3D 00 00 00 7C 89 5C 24 10 8B 9C 24 DC 00 00 00 0F 84 C9 05 00 00 89 D8 25 00 00 00 7C 3D 00 00 00 7C 0F 84 B7 05 00 00 8B 04 24 89 FA 31 F2 31 E8 09 C2 0F 84 D6 05 00 00 89 C8 25 00 00 00 78 3D 00 00 00 78 0F 84 25 06 00 00 89 D8 25 00 00 00 78 3D 00 00 00 78 0F 84 A2 06 00 00 89 C8 25 FF FF 01 00 3D 09 ED 01 00 89 44 24 18 0F 86 BC 05 00 00 C6 44 24 28 01 89 DA 81 E2 FF FF 01 00 81 FA 09 ED 01 00 89 54 24 20 77 14 0F 82 0D 06 00 00 81 7C 24 10 C0 87 AD BE 0F 86 FF 05 00 00 C6 44 24 30 01 80 7C 24 28 00 BA 01 00 00 00 75 13 8B 44 24 18 31 D2 0B 44 24 08 75 07 89 EA 09 F2 0F 94 C2 80 7C 24 30 00 0F 85 0C 06 00 00 8B 44 24 20 0B 44 24 10 0F 84 F3 05 00 00 84 D2 0F 85 1A 06 00 00 89 CA 31 DA 0F 88 10 06 00 00 89 C8 89 DA C1 E8 11 C1 EA 11 25 FF 3F 00 00 81 E2 FF 3F 00 00 39 C2 89 44 24 30 0F 84 F9 05 00 00 8B 44 24 20 39 44 24 18 0F 83 17 08 00 00 39 F7 72 13 77 05 39 2C 24 72 0C 39 54 24 30 66 90 0F 8C FA 0E 00 00 8B 44 24 30 29 D0 85 C0 89 44 24 28 0F 8E 9E 08 00 00 83 F8 21 0F 8F 9C 05 00 00 83 7C 24 28 13 0F 8E 0C 0D 00 00 8B 4C 24 28 C7 44 24 54 00 00 00 00 83 E9 14 C1 E1 04 8B 91 ?? ?? ?? ?? 8B 81 ?? ?? ?? ?? 89 54 24 58 89 44 24 40 89 D0 F7 E6 89 44 24 38 8B 44 24 40 89 54 24 3C F7 E6 89 44 24 30 8B 44 24 58 89 54 24 34 F7 E5 89 54 24 4C 8B 54 24 38 89 44 24 48 89 54 24 50 8B 54 24 4C 89 D0 31 D2 89 44 24 28 8B 44 24 50 01 44 24 28 8B 44 24 40 89 54 24 2C 8B 54 24 54 11 54 24 2C F7 E5 01 44 24 28 11 54 24 2C 8B 54 24 3C 89 D0 31 D2 89 44 24 38 8B 44 24 30 01 44 24 38 89 54 24 3C 8B 54 24 34 11 54 24 3C 8B 54 24 2C C7 44 24 74 00 00 00 00 89 D0 31 D2 01 44 24 38 11 54 24 3C 8B 91 ?? ?? ?? ?? 8B 89 ?? ?? ?? ?? 89 D0 89 54 24 60 F7 E6 89 44 24 30 89 C8 89 54 24 34 F7 E6 89 44 24 50 8B 44 24 60 89 54 24 54 F7 E5 89 54 24 7C 8B 54 24 30 89 44 24 78 89 54 24 70 8B 54 24 7C 89 D0 31 D2 89 44 24 68 8B 44 24 70 01 44 24 68 89 C8 89 54 24 6C 8B 54 24 74 11 54 24 6C F7 E5 01 44 24 68 11 54 24 6C 8B 54 24 34 C7 44 24 34 00 00 00 00 89 D0 31 D2 89 44 24 70 8B 44 24 50 01 44 24 70 89 54 24 74 8B 54 24 54 11 54 24 74 8B 54 24 6C 89 D0 31 D2 01 44 24 70 8B 44 24 28 11 54 24 74 89 C2 31 C0 89 54 24 2C 8B 54 24 48 89 44 24 28 89 54 24 30 8B 44 24 30 01 44 24 28 8B 54 24 34 11 54 24 2C 8B 44 24 70 01 44 24 28 8B 54 24 74 11 54 24 2C 8B 44 24 2C 39 C2 72 16 77 0A 8B 54 24 28 39 54 24 70 76 0A 83 44 24 38 01 83 54 24 3C 00 8B 44 24 18 F7 64 24 58 C7 44 24 34 00 00 00 00 89 44 24 48 8B 44 24 18 89 54 24 4C F7 64 24 40 89 44 24 70 8B 44 24 08 89 54 24 74 F7 64 24 58 89 54 24 5C 8B 54 24 48 89 44 24 58 89 54 24 30 8B 54 24 5C 89 D0 31 D2 89 44 24 50 8B 44 24 08 89 54 24 54 F7 64 24 40 01 44 24 50 8B 44 24 30 11 54 24 54 01 44 24 50 8B 54 24 34 11 54 24 54 8B 54 24 4C 89 D0 31 D2 89 44 24 48 8B 44 24 70 01 44 24 48 89 54 24 4C 8B 54 24 74 11 54 24 4C 8B 54 24 54 C7 44 24 74 00 00 00 00 89 D0 31 D2 01 44 24 48 8B 44 24 18 11 54 24 4C F7 64 24 60 89 44 24 30 8B 44 24 18 89 54 24 34 F7 E1 89 44 24 18 8B 44 24 08 89 54 24 1C F7 64 24 60 89 54 24 64 8B 54 24 30 89 44 24 60 89 54 24 70 8B 54 24 64 89 D0 31 D2 89 44 24 40 8B 44 24 08 89 54 24 44 F7 E1 01 44 24 40 11 54 24 44 8B 54 24 70 01 54 24 40 8B 54 24 34 8B 4C 24 74 11 4C 24 44 8B 4C 24 1C 89 D0 31 D2 89 54 24 34 8B 54 24 18 89 44 24 30 01 54 24 30 8B 54 24 44 11 4C 24 34 89 D0 31 D2 01 44 24 30 8B 44 24 40 11 54 24 34 89 C2 31 C0 89 44 24 40 8B 44 24 60 89 54 24 44 31 D2 01 44 24 40 11 54 24 44 8B 54 24 50 89 D1 31 D2 89 54 24 18 8B 44 24 58 31 D2 01 44 24 18 8B 44 24 30 89 4C 24 1C 11 54 24 1C 8B 54 24 34 01 44 24 18 11 54 24 1C 8B 4C 24 1C 39 CA 72 14 77 08 8B 54 24 18 39 D0 76 0A 83 44 24 48 01 83 54 24 4C 00 8B 44 24 28 8B 54 24 2C 03 44 24 40 13 54 24 44 39 54 24 44 89 44 24 28 89 54 24 2C C7 44 24 08 01 00 00 00 C7 44 24 0C 00 00 00 00 77 18 72 06 39 44 24 40 77 10 C7 44 24 08 00 00 00 00 C7 44 24 0C 00 00 00 00 8B 54 24 18 03 54 24 08 8B 4C 24 1C 13 4C 24 0C 89 54 24 30 8B 44 24 38 8B 54 24 3C 03 44 24 30 89 4C 24 34 13 54 24 34 89 44 24 38 39 D1 89 54 24 3C 0F 87 08 0B 00 00 72 0A 39 44 24 30 0F 87 FC 0A 00 00 8B 4C 24 34 31 D2 B8 01 00 00 00 39 4C 24 0C 77 10 72 0A 8B 4C 24 30 39 4C 24 08 77 04 31 C0 31 D2 03 44 24 48 13 54 24 4C 89 D1 09 C1 75 5E 8B 44 24 3C 0B 44 24 38 75 54 8B 54 24 68 8B 44 24 78 89 D1 31 D2 89 54 24 68 31 D2 01 44 24 68 8B 44 24 10 89 4C 24 6C 11 54 24 6C 8B 54 24 20 33 54 24 2C 33 44 24 28 09 C2 0F 84 F8 0A 00 00 8B 44 24 2C 39 44 24 20 72 14 0F 87 40 03 00 00 8B 54 24 28 39 54 24 10 0F 83 32 03 00 00 BA 01 00 00 00 89 D8 C1 E8 1F 31 D0 EB 13 8D B4 26 00 00 00 00 83 0D ?? ?? ?? ?? 01 B8 01 00 00 00 8B 9C 24 AC 00 00 00 8B B4 24 B0 00 00 00 8B BC 24 B4 00 00 00 8B AC 24 B8 00 00 00 81 C4 BC 00 00 00 C3 90 8B 44 24 10 89 DA 33 44 24 08 31 CA 09 C2 0F 85 16 FA FF FF B8 01 00 00 00 EB C1 90 8D 74 26 00 72 0E 81 7C 24 08 C0 87 AD BE 0F 87 34 FA FF FF 8B 54 24 18 8B 44 24 08 81 F2 09 ED 01 00 35 C0 87 AD BE 09 C2 0F 84 C5 02 00 00 89 C8 25 00 00 00 60 3D 00 00 00 60 0F 94 44 24 28 E9 08 FA FF FF 85 C9 B8 01 00 00 00 0F 89 6E FF FF FF 89 DA 81 E2 00 00 00 78 81 FA 00 00 00 78 0F 84 A7 00 00 00 31 C0 E9 53 FF FF FF 8D B4 26 00 00 00 00 8B 54 24 20 8B 44 24 10 81 F2 09 ED 01 00 35 C0 87 AD BE 09 C2 0F 84 4A 02 00 00 89 D8 25 00 00 00 60 3D 00 00 00 60 0F 94 44 24 30 E9 D5 F9 FF FF 8B 04 24 09 F8 0F 85 02 FA FF FF 84 D2 B8 01 00 00 00 0F 85 03 FF FF FF 84 D2 75 13 89 C8 F7 D0 C1 E8 1F E9 F3 FE FF FF 8D B4 26 00 00 00 00 89 D8 C1 E8 1F E9 E2 FE FF FF 8B 5C 24 20 39 5C 24 18 77 14 0F 82 93 02 00 00 8B 5C 24 10 39 5C 24 08 0F 86 85 02 00 00 BA 01 00 00 00 89 C8 C1 E8 1F 31 D0 E9 B3 FE FF FF 85 DB 0F 88 AB FE FF FF 31 C0 E9 A4 FE FF FF 8B 0C D5 ?? ?? ?? ?? 8B 14 D5 ?? ?? ?? ?? C7 44 24 4C 00 00 00 00 89 54 24 40 89 D0 F7 64 24 10 89 44 24 28 8B 44 24 40 89 54 24 2C F7 64 24 20 89 44 24 30 8B 44 24 10 89 54 24 34 F7 E1 89 54 24 14 8B 54 24 28 89 44 24 10 89 54 24 48 8B 54 24 14 89 D0 31 D2 89 44 24 38 8B 44 24 48 01 44 24 38 8B 44 24 20 89 54 24 3C 8B 54 24 4C 11 54 24 3C F7 E1 01 44 24 38 11 54 24 3C 8B 54 24 2C 89 D0 31 D2 89 44 24 28 8B 44 24 30 01 44 24 28 89 54 24 2C 8B 54 24 34 11 54 24 2C 8B 54 24 3C C7 44 24 4C 00 00 00 00 89 D0 31 D2 01 44 24 28 8B 44 24 40 11 54 24 2C F7 24 24 89 44 24 20 8B 44 24 40 89 54 24 24 F7 E7 89 44 24 40 8B 04 24 89 54 24 44 F7 E1 89 54 24 04 8B 54 24 20 89 04 24 89 54 24 48 8B 54 24 04 89 D0 31 D2 89 44 24 30 8B 44 24 48 01 44 24 30 89 C8 89 54 24 34 8B 54 24 4C 11 54 24 34 8B 4C 24 24 F7 E7 01 44 24 30 11 54 24 34 8B 44 24 40 89 CA 31 C9 89 54 24 20 8B 54 24 44 01 44 24 20 89 4C 24 24 8B 4C 24 10 11 54 24 24 8B 54 24 34 C7 44 24 3C 00 00 00 00 89 D0 31 D2 01 44 24 20 8B 44 24 38 11 54 24 24 89 4C 24 38 89 C2 31 C0 03 44 24 38 13 54 24 3C 03 44 24 20 13 54 24 24 39 54 24 24 72 12 77 06 39 44 24 20 76 0A 83 44 24 28 01 83 54 24 2C 00 8B 4C 24 2C 0B 4C 24 28 75 2A 8B 7C 24 18 8B 4C 24 08 31 D7 31 C1 09 CF 0F 84 EE 07 00 00 39 54 24 18 0F 87 DA FC FF FF 72 0A 39 44 24 08 0F 87 CE FC FF FF 31 D2 90 E9 CB FC FF FF 81 FF 63 8E 8D 37 C6 44 24 30 01 0F 87 90 F7 FF FF E9 A0 FD FF FF 90 8D 74 26 00 81 FE 63 8E 8D 37 C6 44 24 28 01 0F 87 48 F7 FF FF E9 25 FD FF FF 77 0E 8B 44 24 10 39 44 24 08 0F 82 D9 F7 FF FF 39 F7 76 27 8B 44 24 20 39 44 24 18 0F 82 D2 F7 FF FF 0F 87 D8 F7 FF FF 8B 44 24 10 39 44 24 08 0F 86 BE F7 FF FF E9 C5 F7 FF FF 72 05 39 2C 24 77 D2 39 54 24 30 8D 74 26 00 0F 8F 67 FD FF FF 8B 44 24 20 39 44 24 18 0F 87 A2 F7 FF FF 0F 82 85 F7 FF FF 8B 44 24 10 39 44 24 08 0F 87 8E F7 FF FF E9 72 F7 FF FF 8B 54 24 18 8B 44 24 08 33 54 24 20 33 44 24 10 09 C2 74 07 31 D2 E9 65 FD FF FF 39 F7 77 F5 8D 74 26 00 0F 82 52 FD FF FF 39 2C 24 0F 86 49 FD FF FF 31 D2 E9 47 FD FF FF 2B 54 24 30 83 FA 21 0F 8F 3D 06 00 00 83 FA 13 0F 8E 4C FD FF FF 8D 5A EC C1 E3 04 8B 83 ?? ?? ?? ?? 8B 93 ?? ?? ?? ?? C7 44 24 54 00 00 00 00 89 44 24 48 89 54 24 40 F7 E7 89 44 24 38 8B 44 24 40 89 54 24 3C F7 E7 89 44 24 58 8B 44 24 48 89 54 24 5C F7 24 24 89 54 24 34 8B 54 24 38 89 44 24 30 89 54 24 50 8B 54 24 34 89 D0 31 D2 89 44 24 28 8B 44 24 50 01 44 24 28 8B 44 24 40 89 54 24 2C 8B 54 24 54 11 54 24 2C F7 24 24 01 44 24 28 11 54 24 2C 8B 54 24 3C 89 D0 31 D2 89 44 24 38 8B 44 24 58 01 44 24 38 89 54 24 3C 8B 54 24 5C 11 54 24 3C 8B 54 24 2C C7 44 24 7C 00 00 00 00 89 D0 31 D2 01 44 24 38 11 54 24 3C 8B 93 ?? ?? ?? ?? 8B 9B ?? ?? ?? ?? 89 D0 89 54 24 58 F7 E7 89 44 24 60 89 D8 89 54 24 64 F7 E7 89 44 24 50 8B 44 24 58 89 54 24 54 F7 24 24 89 54 24 74 8B 54 24 60 89 44 24 70 89 54 24 78 8B 54 24 74 89 D0 31 D2 89 44 24 68 8B 44 24 78 89 54 24 6C 8B 54 24 7C 01 44 24 68 8B 04 24 11 54 24 6C C7 44 24 04 00 00 00 00 F7 E3 01 44 24 68 11 54 24 6C 8B 54 24 64 89 D0 31 D2 89 44 24 60 8B 44 24 50 01 44 24 60 89 54 24 64 8B 54 24 54 11 54 24 64 8B 54 24 6C 89 D0 31 D2 01 44 24 60 8B 44 24 28 11 54 24 64 89 C2 31 C0 89 54 24 2C 8B 54 24 30 89 44 24 28 89 14 24 8B 04 24 8B 54 24 04 01 44 24 28 8B 44 24 60 11 54 24 2C 01 44 24 28 8B 54 24 64 11 54 24 2C 8B 44 24 2C 39 C2 72 16 77 0A 8B 54 24 28 39 54 24 60 76 0A 83 44 24 38 01 83 54 24 3C 00 8B 44 24 20 F7 64 24 48 C7 44 24 04 00 00 00 00 89 44 24 30 8B 44 24 20 89 54 24 34 F7 64 24 40 89 44 24 50 8B 44 24 10 89 54 24 54 F7 64 24 48 89 54 24 4C 8B 54 24 30 89 44 24 48 89 14 24 8B 54 24 4C 89 D0 31 D2 89 44 24 60 8B 44 24 10 89 54 24 64 F7 64 24 40 01 44 24 60 8B 04 24 11 54 24 64 01 44 24 60 8B 54 24 04 11 54 24 64 8B 54 24 34 89 D0 31 D2 89 44 24 30 8B 44 24 50 01 44 24 30 89 54 24 34 8B 54 24 54 11 54 24 34 8B 54 24 64 C7 44 24 54 00 00 00 00 89 D0 31 D2 01 44 24 30 8B 44 24 20 11 54 24 34 F7 64 24 58 89 44 24 40 8B 44 24 20 89 54 24 44 F7 E3 89 44 24 20 8B 44 24 10 89 54 24 24 F7 64 24 58 89 54 24 5C 8B 54 24 40 89 44 24 58 89 54 24 50 8B 54 24 5C 89 D0 31 D2 89 04 24 8B 44 24 10 89 54 24 04 F7 E3 01 04 24 11 54 24 04 8B 44 24 50 01 04 24 8B 54 24 54 11 54 24 04 8B 54 24 44 89 D0 31 D2 89 44 24 40 8B 44 24 20 01 44 24 40 89 54 24 44 8B 54 24 24 11 54 24 44 8B 54 24 04 89 D0 31 D2 01 44 24 40 8B 04 24 11 54 24 44 89 C2 31 C0 89 04 24 8B 44 24 58 89 54 24 04 31 D2 01 04 24 8B 44 24 60 11 54 24 04 89 C2 31 C0 89 44 24 20 8B 44 24 48 89 54 24 24 31 D2 01 44 24 20 8B 44 24 40 11 54 24 24 8B 54 24 44 01 44 24 20 11 54 24 24 8B 5C 24 24 39 DA 72 14 77 08 8B 54 24 20 39 D0 76 0A 83 44 24 30 01 83 54 24 34 00 8B 44 24 28 8B 54 24 2C 03 04 24 13 54 24 04 39 54 24 04 89 44 24 28 89 54 24 2C C7 44 24 10 01 00 00 00 C7 44 24 14 00 00 00 00 77 17 72 05 39 04 24 77 10 C7 44 24 10 00 00 00 00 C7 44 24 14 00 00 00 00 8B 44 24 20 8B 54 24 24 03 44 24 10 13 54 24 14 89 44 24 20 8B 44 24 38 89 54 24 24 8B 54 24 3C 03 44 24 20 13 54 24 24 39 54 24 24 89 44 24 38 89 54 24 3C 0F 87 80 02 00 00 72 0A 39 44 24 20 0F 87 74 02 00 00 8B 5C 24 24 31 D2 B8 01 00 00 00 39 5C 24 14 77 10 72 0A 8B 5C 24 20 39 5C 24 10 77 04 31 C0 31 D2 03 44 24 30 13 54 24 34 89 D3 09 C3 0F 85 BC FB FF FF 8B 44 24 3C 0B 44 24 38 0F 85 AE FB FF FF 8B 5C 24 70 8B 44 24 68 C7 44 24 04 00 00 00 00 89 1C 24 8B 5C 24 2C 89 C2 31 C0 03 04 24 13 54 24 04 39 5C 24 18 0F 84 D6 02 00 00 8B 44 24 2C 39 44 24 18 0F 82 74 FB FF FF 0F 87 D5 F8 FF FF 8B 54 24 28 39 54 24 08 0F 87 C7 F8 FF FF 31 D2 E9 C5 F8 FF FF 8B 44 24 28 C7 44 24 4C 00 00 00 00 8B 14 C5 ?? ?? ?? ?? 8B 0C C5 ?? ?? ?? ?? 89 54 24 40 89 D0 F7 64 24 08 89 44 24 28 8B 44 24 40 89 54 24 2C F7 64 24 18 89 44 24 30 8B 44 24 08 89 54 24 34 F7 E1 89 54 24 0C 8B 54 24 28 89 44 24 08 89 54 24 48 8B 54 24 0C 89 D0 31 D2 89 44 24 38 8B 44 24 48 01 44 24 38 8B 44 24 18 89 54 24 3C 8B 54 24 4C 11 54 24 3C F7 E1 01 44 24 38 11 54 24 3C 8B 54 24 2C 89 D0 31 D2 89 44 24 28 8B 44 24 30 01 44 24 28 89 54 24 2C 8B 54 24 34 11 54 24 2C 8B 54 24 3C C7 44 24 54 00 00 00 00 89 D0 31 D2 01 44 24 28 8B 44 24 40 11 54 24 2C F7 E5 89 44 24 18 8B 44 24 40 89 54 24 1C F7 E6 89 44 24 40 89 C8 89 54 24 44 F7 E5 89 54 24 4C 8B 54 24 18 89 44 24 48 89 54 24 50 8B 54 24 4C 89 D0 31 D2 89 44 24 30 8B 44 24 50 01 44 24 30 89 C8 89 54 24 34 8B 54 24 54 11 54 24 34 8B 4C 24 1C F7 E6 01 44 24 30 11 54 24 34 8B 44 24 40 89 CA 31 C9 89 54 24 18 8B 54 24 44 01 44 24 18 89 4C 24 1C 8B 4C 24 08 11 54 24 1C }
	condition:
		$1
}

rule file_46_0_0 {
	meta:
		name = "___negdi2"
		size = 32
	strings:
		$1 = { 8B 4C 24 04 8B 54 24 08 89 C8 F7 D8 F7 DA 85 C9 0F 95 C1 0F B6 C9 29 CA C3 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_47_0_0 {
	meta:
		name = "___extendsftf2"
		size = 608
	strings:
		$1 = { 83 EC 5C 8B 4C 24 64 8B 44 24 60 89 6C 24 58 89 5C 24 4C 89 7C 24 54 D9 7C 24 1E 89 74 24 50 89 CD 89 CF C1 ED 17 89 CA 81 E5 FF 00 00 00 81 E7 FF FF 7F 00 8D 5D 01 81 E3 FF 00 00 00 C1 EA 1F 83 FB 01 89 7C 24 30 C7 44 24 3C 00 00 00 00 C7 44 24 38 00 00 00 00 C7 44 24 34 00 00 00 00 7E 65 89 F9 66 81 C5 80 3F C1 E1 19 31 DB C1 EF 07 31 F6 66 89 7C 24 2C 0F B7 7C 24 2E 66 81 E5 FF 7F C1 E2 07 66 81 E7 00 80 09 EF 89 D5 66 89 7C 24 2E 66 C1 EF 08 89 FA 89 CF 83 E2 7F 09 EA 88 54 24 2F 8B 54 24 2C 89 30 8B 6C 24 58 89 58 04 8B 74 24 50 89 78 08 8B 5C 24 4C 89 50 0C 8B 7C 24 54 83 C4 5C C3 85 ED 74 4D 85 FF 0F 84 EE 00 00 00 89 FB 31 F6 C1 EB 07 66 89 5C 24 2C 0F B7 5C 24 2E C1 E2 07 C1 E7 19 66 81 CB FF 7F 66 89 5C 24 2E 66 C1 EB 08 83 E3 7F 09 D3 88 5C 24 2F 31 DB 81 E1 00 00 40 00 8B 54 24 2C 75 99 D9 EE D8 F0 DD D8 9B EB 90 85 FF 89 FE 0F 84 B1 00 00 00 0F BD CF 83 F1 1F 89 0C 24 8B 1C 24 83 C1 70 83 C3 51 89 DF 0F 48 F9 89 D9 C1 F9 1F C1 E9 1B 01 CB 83 E3 1F C1 FF 05 29 CB 89 5C 24 04 0F 85 8D 00 00 00 83 FF 03 BB 03 00 00 00 8D 6C 24 30 7F 26 89 FB F7 DB 8D 4C 24 3C 8D 74 BC 2C C1 E3 02 8B 2C 19 89 29 83 E9 04 39 F1 75 F4 8D 5F FF 85 DB 8D 6C 24 30 78 0D C7 44 9D 00 00 00 00 00 83 EB 01 79 F3 BD 89 3F 00 00 8B 74 24 30 66 2B 2C 24 8B 5C 24 34 8B 4C 24 38 0F B7 7C 24 3C 66 81 E5 FF 7F E9 B9 FE FF FF 8D B4 26 00 00 00 00 BD FF 7F 00 00 31 FF 31 C9 31 DB 31 F6 E9 A0 FE FF FF 31 ED 31 FF 31 C9 31 DB 31 F6 E9 91 FE FF FF 83 FF 02 7F 66 B9 03 00 00 00 89 D6 29 F9 8D 6C 24 30 8D 5C 8D 00 8B 4C 24 04 C7 44 24 08 20 00 00 00 29 4C 24 08 89 44 24 0C 90 8D 74 26 00 8B 43 FC 0F B6 4C 24 08 8B 13 D3 E8 0F B6 4C 24 04 D3 E2 09 D0 89 04 BB 83 EB 04 39 EB 75 E1 89 F2 8B 44 24 0C 8B 74 24 30 8D 5F FF 0F B6 4C 24 04 D3 E6 89 74 BC 30 E9 34 FF FF FF BB 02 00 00 00 BF 03 00 00 00 EB E4 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_48_0_0 {
	meta:
		name = "___floatdixf"
		size = 48
		refs = "0013 .rdata"
	strings:
		$1 = { 83 EC 14 31 D2 DB 44 24 1C 89 54 24 04 8B 44 24 18 D8 0D ?? ?? ?? ?? 89 04 24 DF 2C 24 83 C4 14 DE C1 C3 90 90 90 90 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_50_0_0 {
	meta:
		name = "___bid_extendsfdd"
		size = 32
		refs = "000b ___binary32_to_bid64"
	strings:
		$1 = { 83 EC 1C D9 44 24 20 D9 1C 24 E8 ?? ?? ?? ?? 83 C4 1C C3 90 90 90 90 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_103_0_0 {
	meta:
		name = "___bid_extendsfsd"
		size = 32
		refs = "000b ___binary32_to_bid32"
	strings:
		$1 = { 83 EC 1C D9 44 24 20 D9 1C 24 E8 ?? ?? ?? ?? 83 C4 1C C3 90 90 90 90 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_51_0_0 {
	meta:
		name = "___do_global_dtors"
		size = 48
		refs = "0002 .data"
	strings:
		$1 = { 8B 15 ?? ?? ?? ?? 8B 02 85 C0 74 1E 83 EC 0C 90 83 C2 04 89 15 ?? ?? ?? ?? FF D0 8B 15 ?? ?? ?? ?? 8B 02 85 C0 75 E9 83 C4 0C F3 C3 8D 74 26 00 }
	condition:
		$1
}

rule file_51_1_0 {
	meta:
		name = "___do_global_ctors"
		size = 80
		refs = "0006 ___CTOR_LIST__ 0025 .text 002a _atexit"
	strings:
		$1 = { 53 83 EC 18 8B 1D ?? ?? ?? ?? 83 FB FF 74 24 85 DB 74 0F FF 14 9D ?? ?? ?? ?? 83 EB 01 8D 76 00 75 F1 C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 18 5B C3 31 DB EB 02 89 C3 8D 43 01 8B 14 85 ?? ?? ?? ?? 85 D2 75 F0 EB C6 8D B4 26 00 00 00 00 }
	condition:
		$1
}

rule file_51_2_0 {
	meta:
		name = "___main"
		size = 32
		refs = "0002 .bss"
	strings:
		$1 = { 8B 0D ?? ?? ?? ?? 85 C9 74 06 F3 C3 8D 74 26 00 C7 05 ?? ?? ?? ?? 01 00 00 00 EB 94 90 90 90 90 }
	condition:
		$1
}

rule file_54_0_0 {
	meta:
		name = "___floatditf"
		size = 464
	strings:
		$1 = { 55 57 56 53 83 EC 4C 8B 5C 24 68 8B 4C 24 64 8B 44 24 60 89 DA 09 CA 0F 84 03 01 00 00 89 DA C1 EA 1F 84 D2 88 14 24 74 07 F7 D9 83 D3 00 F7 DB 85 DB 89 DA 0F 85 3C 01 00 00 0F BD F9 89 CB 83 F7 1F 83 C7 20 8D 77 50 C7 44 24 14 3E 40 00 00 29 7C 24 14 83 C7 31 0F 49 F7 89 54 24 34 89 FA C1 FA 1F C1 EA 1B 01 D7 83 E7 1F C1 FE 05 29 D7 89 5C 24 30 C7 44 24 38 00 00 00 00 C7 44 24 3C 00 00 00 00 89 7C 24 18 0F 84 F5 00 00 00 83 FE 02 0F 8F 21 01 00 00 8B 4C 24 18 BA 03 00 00 00 89 C7 C7 44 24 1C 20 00 00 00 8D 6C 24 30 29 F2 29 4C 24 1C 8D 54 95 00 8B 42 FC 0F B6 4C 24 1C 8B 1A D3 E8 0F B6 4C 24 18 D3 E3 09 D8 89 04 B2 83 EA 04 39 EA 75 E1 8B 5C 24 30 89 F8 8D 56 FF 0F B6 4C 24 18 D3 E3 89 5C B4 30 85 D2 8D 6C 24 30 78 0D C7 44 95 00 00 00 00 00 83 EA 01 79 F3 0F B7 7C 24 14 8B 74 24 30 8B 5C 24 34 8B 6C 24 38 0F B7 54 24 3C 66 81 E7 FF 7F EB 11 8D 76 00 C6 04 24 00 31 FF 31 D2 31 ED 31 DB 31 F6 66 89 54 24 2C 0F B7 54 24 2E 66 81 E7 FF 7F 0F B6 0C 24 66 81 E2 00 80 09 FA 66 89 54 24 2E C1 E1 07 66 C1 EA 08 89 CF 83 E2 7F 09 FA 88 54 24 2F 89 30 89 58 04 89 68 08 8B 54 24 2C 89 50 0C 83 C4 4C 5B 5E 5F 5D C3 0F BD FB 89 CB 83 F7 1F E9 C2 FE FF FF 83 FE 03 BA 03 00 00 00 8D 6C 24 30 0F 8F 5E FF FF FF 89 F1 F7 D9 8D 54 24 3C 8D 5C B4 2C C1 E1 02 8B 3C 0A 89 3A 83 EA 04 39 DA 75 F4 8D 56 FF E9 33 FF FF FF BA 02 00 00 00 BE 03 00 00 00 E9 19 FF FF FF 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_55_0_0 {
	meta:
		name = "___floatsitf"
		size = 448
	strings:
		$1 = { 55 57 56 53 83 EC 4C 8B 5C 24 64 8B 44 24 60 85 DB 0F 84 C9 00 00 00 89 DA C1 EA 1F 88 14 24 89 DA F7 DA 80 3C 24 00 C7 44 24 14 1E 40 00 00 C7 44 24 34 00 00 00 00 0F 45 DA 0F BD D3 83 F2 1F 8D 72 70 29 54 24 14 83 C2 51 89 D1 0F 49 F2 C1 F9 1F C1 E9 1B 01 CA 83 E2 1F C1 FE 05 29 CA 89 5C 24 30 C7 44 24 38 00 00 00 00 C7 44 24 3C 00 00 00 00 89 54 24 18 0F 85 B9 00 00 00 83 FE 03 BA 03 00 00 00 8D 6C 24 30 7F 26 89 F1 F7 D9 8D 54 24 3C 8D 5C B4 2C C1 E1 02 8B 3C 0A 89 3A 83 EA 04 39 DA 75 F4 8D 56 FF 85 D2 8D 6C 24 30 78 0D C7 44 95 00 00 00 00 00 83 EA 01 79 F3 0F B7 7C 24 14 8B 74 24 30 8B 5C 24 34 8B 6C 24 38 0F B7 54 24 3C 66 81 E7 FF 7F EB 13 90 8D 74 26 00 C6 04 24 00 31 FF 31 D2 31 ED 31 DB 31 F6 66 89 54 24 2C 0F B7 54 24 2E 66 81 E7 FF 7F 0F B6 0C 24 66 81 E2 00 80 09 FA 66 89 54 24 2E C1 E1 07 66 C1 EA 08 89 CF 83 E2 7F 09 FA 88 54 24 2F 89 30 89 58 04 89 68 08 8B 54 24 2C 89 50 0C 83 C4 4C 5B 5E 5F 5D C3 83 FE 02 7F 76 8B 4C 24 18 BA 03 00 00 00 89 C7 C7 44 24 1C 20 00 00 00 8D 6C 24 30 29 F2 29 4C 24 1C 8D 54 95 00 8B 42 FC 0F B6 4C 24 1C 8B 1A D3 E8 0F B6 4C 24 18 D3 E3 09 D8 89 04 B2 83 EA 04 39 EA 75 E1 8B 5C 24 30 89 F8 8D 56 FF 0F B6 4C 24 18 8D 6C 24 30 D3 E3 85 D2 89 5C B4 30 0F 88 23 FF FF FF C7 44 95 00 00 00 00 00 83 EA 01 0F 89 05 FF FF FF E9 0D FF FF FF BA 02 00 00 00 BE 03 00 00 00 EB C7 90 90 90 }
	condition:
		$1
}

rule file_56_0_0 {
	meta:
		name = "___bid32_to_bid64"
		size = 320
		refs = "0108 ___bid_IDEC_glbflags"
	strings:
		$1 = { 83 EC 1C 89 5C 24 0C 8B 5C 24 20 89 74 24 10 89 7C 24 14 89 6C 24 18 89 D8 89 DE 25 00 00 00 60 81 E6 00 00 00 80 3D 00 00 00 60 74 59 89 DF 89 D9 C1 EF 17 81 E7 FF 00 00 00 81 E1 FF FF 7F 00 75 3E 89 DD 31 C0 81 E5 00 00 00 78 31 D2 81 FD 00 00 00 78 0F 84 9E 00 00 00 8D 9F 29 01 00 00 09 F2 C1 E3 15 09 DA 8B 5C 24 0C 8B 74 24 10 8B 7C 24 14 8B 6C 24 18 83 C4 1C C3 90 8D 74 26 00 89 C8 31 D2 EB D4 89 D8 25 00 00 00 78 3D 00 00 00 78 74 2C 89 D9 31 C0 81 E1 FF FF 1F 00 31 D2 81 C9 00 00 80 00 81 F9 7F 96 98 00 76 08 C1 EB 15 0F B6 FB EB A4 89 C8 31 D2 EB F2 8D 74 26 00 89 DA 89 D9 81 E2 FF FF 0F 00 89 D8 25 00 00 00 FE 81 E1 FF FF 0F FE 81 FA 3F 42 0F 00 89 DA 0F 47 C8 81 E2 00 00 00 7C 89 D8 25 00 00 00 F8 81 FA 00 00 00 78 0F 44 C8 81 E3 00 00 00 7E 81 FB 00 00 00 7E 75 07 83 0D ?? ?? ?? ?? 01 89 CB BE 00 CA 9A 3B 81 E3 FF FF 0F 00 89 D8 F7 E6 89 54 24 04 89 CA 89 04 24 81 E2 00 00 00 FC 8B 04 24 0B 54 24 04 E9 2E FF FF FF 8D B4 26 00 00 00 00 }
	condition:
		$1
}

rule file_56_1_0 {
	meta:
		name = "___bid64_to_bid32"
		size = 2480
		refs = "005f ___bid_IDEC_glbround 0104 ___bid_estimate_decimal_digits 010b ___bid_power10_index_binexp 019a ___bid_round_const_table 01b4 ___bid_reciprocals10_64 0258 ___bid_short_recip_scale 047a ___bid_IDEC_glbflags 0840 ___bid_power10_table_128"
	strings:
		$1 = { 55 57 56 53 83 EC 5C 8B 4C 24 74 8B 44 24 70 89 CA 89 CB 81 E2 00 00 00 60 81 E3 00 00 00 80 81 FA 00 00 00 60 89 5C 24 40 0F 84 91 03 00 00 89 CB 89 CF C1 EB 15 89 C6 81 E3 FF 03 00 00 81 E7 FF FF 1F 00 89 FD 09 F5 0F 84 32 03 00 00 83 FF 00 8D 83 D7 FE FF FF 0F 87 84 00 00 00 8B 1D ?? ?? ?? ?? 81 FE 7F 96 98 00 89 5C 24 20 77 72 90 3D BF 00 00 00 76 49 85 C0 0F 88 71 05 00 00 83 FF 00 0F 87 28 04 00 00 81 FE 3F 42 0F 00 0F 87 1C 04 00 00 89 F1 89 FB 0F A4 F3 03 0F A4 F7 01 01 F6 C1 E1 03 01 CE 11 DF 83 E8 01 83 FF 00 0F 86 40 04 00 00 3D BF 00 00 00 0F 87 F0 03 00 00 83 FF 00 0F 87 48 04 00 00 81 FE FF FF 7F 00 0F 87 3C 04 00 00 89 C2 C1 E2 17 09 F2 E9 CE 02 00 00 89 74 24 50 89 7C 24 54 DF 6C 24 50 D9 5C 24 10 8B 54 24 10 C1 EA 17 81 E2 FF 00 00 00 83 EA 7F 8B 0C 95 ?? ?? ?? ?? 39 3C D5 ?? ?? ?? ?? 8D 59 F9 89 5C 24 10 77 18 0F 82 82 03 00 00 39 34 D5 ?? ?? ?? ?? 0F 86 75 03 00 00 90 8D 74 26 00 8B 54 24 40 8B 2D ?? ?? ?? ?? 85 D2 89 6C 24 20 74 0E 89 EA 83 EA 01 83 FA 01 0F 86 81 06 00 00 8B 5C 24 10 C7 44 24 44 20 00 00 00 01 C3 89 DA 83 C2 07 83 FA 06 89 5C 24 30 77 1F 83 FB FF 0F 84 A1 06 00 00 C7 44 24 44 30 00 00 00 F7 D8 89 44 24 10 C7 44 24 30 00 00 00 00 8D 44 ED 00 8D 44 45 00 03 44 24 10 8B 14 C5 ?? ?? ?? ?? 8B 04 C5 ?? ?? ?? ?? 01 F0 11 FA 89 C6 89 D3 8B 54 24 10 8B 04 D5 ?? ?? ?? ?? 8B 14 D5 ?? ?? ?? ?? 89 C1 89 44 24 28 89 D8 89 D7 89 54 24 2C F7 E1 89 44 24 18 89 D8 89 54 24 1C F7 E7 89 44 24 48 89 F0 89 54 24 4C F7 E1 89 54 24 3C 8B 5C 24 3C 31 D2 89 44 24 38 8B 44 24 18 89 D9 31 DB 01 C1 89 F0 11 D3 F7 E7 8B 7C 24 1C 01 C1 89 FE 11 D3 31 FF 89 34 24 8B 74 24 48 01 34 24 89 7C 24 04 8B 7C 24 4C 11 7C 24 04 31 FF 01 1C 24 11 7C 24 04 31 C0 31 DB 89 4C 24 1C 8B 4C 24 38 89 44 24 18 01 4C 24 18 8B 4C 24 10 8B 7C 24 04 8B 34 24 11 5C 24 1C 31 DB 8B 0C 8D ?? ?? ?? ?? 89 4C 24 48 0F B6 4C 24 48 0F AD FE D3 EF F6 C1 20 0F 45 F7 0F 45 FB 85 ED 0F 84 8B 01 00 00 8B 4C 24 48 31 DB C7 44 24 0C 40 00 00 00 8B 04 24 29 4C 24 0C 0F B6 4C 24 0C 8B 54 24 04 0F A5 C2 D3 E0 F6 C1 20 0F 45 D0 0F 45 C3 83 FD 01 89 44 24 38 89 54 24 3C 0F 84 FE 02 00 00 0F 8E C2 05 00 00 83 FD 03 0F 84 EF 02 00 00 83 FD 04 0F 84 90 01 00 00 8B 4C 24 18 8B 5C 24 1C 03 4C 24 28 13 5C 24 2C 39 5C 24 1C C7 44 24 10 01 00 00 00 C7 44 24 14 00 00 00 00 77 18 72 06 39 4C 24 18 77 10 C7 44 24 10 00 00 00 00 C7 44 24 14 00 00 00 00 0F B6 4C 24 0C 31 ED 8B 54 24 3C 8B 44 24 38 0F AD D0 D3 EA F6 C1 20 0F B6 4C 24 48 0F 45 C2 0F 45 D5 03 44 24 10 13 54 24 14 31 DB 0F AD D0 D3 EA F6 C1 20 0F 45 C2 0F 45 D3 89 D3 09 C3 0F 84 22 01 00 00 83 FF 00 77 10 81 FE 7F 96 98 00 8B 44 24 30 0F 86 09 FD FF FF 8B 44 24 30 BE 40 42 0F 00 31 FF 83 C0 01 E9 F6 FC FF FF 8D B6 00 00 00 00 89 C8 25 00 00 00 78 3D 00 00 00 78 0F 84 EE 01 00 00 31 D2 81 EB 29 01 00 00 78 13 89 D8 BA 00 00 80 5F C1 E0 17 81 FB BF 00 00 00 0F 4E D0 0B 54 24 40 83 C4 5C 89 D0 5B 5E 5F 5D C3 8D 76 00 89 CA 81 E2 00 00 00 78 81 FA 00 00 00 78 0F 84 60 01 00 00 89 CA 89 C6 81 E2 FF FF 07 00 89 D7 81 CF 00 00 20 00 81 FF F2 86 23 00 0F 86 91 00 00 00 31 F6 31 FF 89 CB C1 EB 13 81 E3 FF 03 00 00 E9 3E FC FF FF 89 F1 83 E1 01 85 C9 0F 84 4F 03 00 00 8B 04 24 66 BD 40 00 8B 54 24 04 2B 6C 24 48 89 E9 31 ED 0F A5 C2 D3 E0 F6 C1 20 0F 45 D0 0F 45 C5 89 54 24 3C 09 C2 89 44 24 38 75 20 8B 54 24 1C 39 54 24 2C 72 16 77 0A 8B 4C 24 18 39 4C 24 28 76 0A 83 C6 FF 83 D7 FF 8D 74 26 00 8B 54 24 3C 81 C2 00 00 00 80 0B 54 24 38 0F 84 6C 03 00 00 8B 6C 24 44 09 2D ?? ?? ?? ?? E9 CF FE FF FF 0F 82 6D FF FF FF 3D FF FF C0 6F 0F 86 62 FF FF FF E9 59 FF FF FF 8D B4 26 00 00 00 00 83 E9 06 89 4C 24 10 E9 84 FC FF FF 8D 74 26 00 8B 54 24 40 83 0D ?? ?? ?? ?? 28 81 CA 00 00 00 78 83 7C 24 20 02 0F 84 99 03 00 00 83 7C 24 20 03 0F 84 30 03 00 00 83 7C 24 20 01 0F 85 D1 FE FF FF 8B 7C 24 40 B8 7F 96 F8 77 85 FF 0F 44 D0 E9 BE FE FF FF 81 FE 3F 42 0F 00 0F 87 B4 FB FF FF 3D BF 00 00 00 0F 8F 88 FB FF FF E9 A4 FB FF FF 8B 54 24 40 C1 E0 15 89 F7 81 E7 FF FF 1F 00 83 C4 5C 5B 5E 81 CA 00 00 00 60 09 C2 09 FA 89 D0 5F 5D C3 89 CA 89 CF 81 E2 FF FF 03 00 81 E7 FF FF 03 FE 81 FA 7E 8D 03 00 89 C6 72 13 77 07 3D FF 7F C6 A4 76 0A 89 CF 31 F6 81 E7 00 00 00 FE 89 C8 25 00 00 00 7C 3D 00 00 00 78 75 11 89 CF 31 F6 81 E7 00 00 00 F8 8D B4 26 00 00 00 00 89 F0 BA 83 4B 04 00 C1 E8 09 81 E1 00 00 00 7E F7 E2 89 F8 25 00 00 00 FC C1 EA 07 09 C2 81 F9 00 00 00 7E 0F 85 09 FE FF FF 83 0D ?? ?? ?? ?? 01 E9 FD FD FF FF 8B 5C 24 3C 0B 5C 24 38 0F 85 B0 FE FF FF 8B 6C 24 1C 39 6C 24 2C 0F 87 80 FD FF FF 0F 82 9C FE FF FF 8B 44 24 18 39 44 24 28 0F 87 6C FD FF FF E9 89 FE FF FF 90 8D 74 26 00 83 F8 F9 0F 8C 98 01 00 00 8B 54 24 40 85 D2 90 74 10 8B 54 24 20 83 EA 01 83 FA 01 0F 86 80 03 00 00 8B 6C 24 20 89 C1 F7 D9 8D 44 ED 00 8D 44 45 00 01 C8 8B 14 C5 ?? ?? ?? ?? 8B 04 C5 ?? ?? ?? ?? 01 F0 11 FA 89 C7 8B 04 CD ?? ?? ?? ?? 89 D6 8B 14 CD ?? ?? ?? ?? 8B 0C 8D ?? ?? ?? ?? 89 C3 89 44 24 10 89 F0 89 D5 89 54 24 14 F7 E3 89 44 24 28 89 F0 89 54 24 2C F7 E5 89 44 24 18 89 F8 89 54 24 1C F7 E3 89 54 24 34 8B 74 24 34 31 D2 89 44 24 30 8B 44 24 28 89 4C 24 28 0F B6 4C 24 28 89 F3 31 F6 01 C3 89 F8 11 D6 F7 E5 8B 6C 24 2C 01 C3 89 EF 11 D6 31 ED 03 7C 24 18 89 F2 89 D0 89 DE 13 6C 24 1C 31 D2 01 C7 8B 44 24 30 11 D5 31 DB 31 D2 01 C3 89 F8 11 D6 89 EA 0F AD D0 D3 EA F6 C1 20 74 04 89 D0 31 D2 89 44 24 30 8B 44 24 20 89 54 24 34 85 C0 75 4C 8B 44 24 30 83 E0 01 85 C0 74 41 B9 40 00 00 00 BA FF FF FF FF 2B 4C 24 28 B8 FF FF FF FF 0F AD D0 D3 EA F6 C1 20 74 04 89 D0 31 D2 21 F8 21 EA 09 C2 75 18 39 74 24 14 72 12 77 06 39 5C 24 10 76 0A 83 44 24 30 FF 83 54 24 34 FF 8B 15 ?? ?? ?? ?? F6 C2 20 89 54 24 44 0F 84 42 01 00 00 89 D0 83 C8 10 A3 ?? ?? ?? ?? 8B 54 24 40 0B 54 24 30 E9 51 FC FF FF 8B 04 24 BD 40 00 00 00 31 DB 2B 6C 24 48 8B 54 24 04 89 E9 0F A5 C2 D3 E0 F6 C1 20 0F 45 D0 0F 45 C3 89 44 24 38 89 54 24 3C E9 CF FC FF FF 8B 5C 24 40 83 0D ?? ?? ?? ?? 30 85 DB 74 10 83 7C 24 20 01 BA 01 00 00 80 0F 84 03 FC FF FF 8B 4C 24 40 85 C9 75 10 83 7C 24 20 02 BA 01 00 00 00 0F 84 EB FB FF FF 8B 54 24 40 E9 E2 FB FF FF BD 03 00 00 00 2B 6C 24 20 E9 71 F9 FF FF 90 8B 54 24 1C 39 54 24 2C 0F 87 64 FB FF FF 0F 82 80 FC FF FF 8B 4C 24 18 39 4C 24 28 0F 87 50 FB FF FF E9 6D FC FF FF 8B 54 24 40 81 CA 7F 96 F8 77 E9 9D FB FF FF 8D 54 ED 00 89 F1 8D 54 55 00 89 FB 03 54 24 10 03 0C D5 ?? ?? ?? ?? 13 1C D5 ?? ?? ?? ?? 8B 54 24 10 83 C2 07 C1 E2 04 3B 9A ?? ?? ?? ?? 0F 82 2B F9 FF FF 77 0C 3B 8A ?? ?? ?? ?? 0F 82 1D F9 FF FF C7 44 24 44 20 00 00 00 E9 18 F9 FF FF 8B 44 24 40 8B 74 24 40 0D 7F 96 F8 77 85 F6 0F 45 D0 E9 37 FB FF FF 8D 74 26 00 85 ED 0F 84 D8 FB FF FF E9 43 FA FF FF 8B 4C 24 28 89 EA 89 F8 C7 44 24 38 40 00 00 00 31 ED 29 4C 24 38 0F B6 4C 24 38 D3 E0 0F A5 FA F6 C1 20 0F 45 D0 0F 45 C5 83 7C 24 20 01 89 44 24 18 89 54 24 1C 0F 84 BA 00 00 00 0F 8E 84 00 00 00 83 7C 24 20 03 0F 84 A9 00 00 00 83 7C 24 20 04 74 7A 8B 7C 24 10 B8 01 00 00 00 8B 6C 24 14 01 DF 11 F5 31 D2 39 EE 77 0A 72 04 39 FB 77 04 31 C0 31 D2 0F B6 4C 24 38 31 DB 8B 6C 24 1C 8B 7C 24 18 0F AD EF D3 ED F6 C1 20 0F B6 4C 24 28 0F 45 FD 0F 45 EB 01 C7 11 D5 31 F6 0F AD EF D3 ED F6 C1 20 0F 45 FD 0F 45 EE 89 EB 09 FB 0F 85 13 FE FF FF 8B 44 24 44 83 C8 30 A3 ?? ?? ?? ?? E9 02 FE FF FF 8B 7C 24 20 85 FF 75 86 8B 54 24 1C 81 C2 00 00 00 80 0B 54 24 18 75 D7 39 74 24 14 0F 87 E0 FD FF FF 72 CB 39 5C 24 10 0F 87 D4 FD FF FF EB BF 8B 54 24 1C 0B 54 24 18 75 B5 8D 76 00 EB D9 BA 03 00 00 00 2B 54 24 20 89 54 24 20 E9 6E FC FF FF 90 90 90 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_57_0_0 {
	meta:
		name = "___enable_execute_stack"
		size = 96
		refs = "001c __imp__VirtualQuery@12 0048 __imp__VirtualProtect@16 0054 _abort"
	strings:
		$1 = { 83 EC 3C 8D 44 24 14 89 44 24 04 8B 44 24 40 C7 44 24 08 1C 00 00 00 89 04 24 FF 15 ?? ?? ?? ?? 83 EC 0C 85 C0 74 2C 8D 44 24 28 89 44 24 0C 8B 44 24 20 C7 44 24 08 40 00 00 00 89 44 24 04 8B 44 24 14 89 04 24 FF 15 ?? ?? ?? ?? 83 EC 10 83 C4 3C C3 E8 ?? ?? ?? ?? 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_58_0_0 {
	meta:
		name = "___paritysi2"
		size = 48
	strings:
		$1 = { 8B 44 24 04 89 C2 C1 EA 10 31 C2 89 D0 C1 E8 08 31 D0 89 C1 C1 E9 04 31 C1 B8 96 69 00 00 83 E1 0F D3 F8 83 E0 01 C3 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_60_0_0 {
	meta:
		name = "___divsc3"
		size = 768
		refs = "00fb .rdata"
	strings:
		$1 = { 83 EC 04 D9 44 24 08 D9 44 24 0C D9 44 24 10 D9 44 24 14 D9 C1 D9 E1 D9 C1 D9 E1 DF E9 DD D8 76 6F D9 C1 D8 F1 D9 C2 D8 C9 D8 C2 D9 C5 D8 CA D8 C5 D8 F1 D9 CA D8 CD D8 E6 DE F1 D9 C9 DB E8 7A 6D DD DC DD DC DD D8 DD D8 EB 35 DD DD DD DB DD D8 DD D8 EB 2B DD D8 DD DC DD DA DD D8 EB 21 DD D8 DD DC DD DA DD D8 EB 17 DD D8 DD DC DD DA DD D8 EB 0D DD D8 DD DC DD DA DD D8 90 8D 74 26 00 D9 1C 24 8B 04 24 D9 1C 24 8B 14 24 83 C4 04 C3 D9 C0 D8 F2 D9 C1 D8 C9 D8 C3 D9 C4 D8 CA D8 C6 D8 F1 D9 CA D8 CE D8 ED DE F1 D9 C9 EB 8F D9 C9 DB E8 7B 97 D9 EE D9 CB DB EB 0F 8A 42 01 00 00 0F 85 44 01 00 00 D9 CC DB EB DD DB 0F 8A 40 01 00 00 0F 85 42 01 00 00 D9 CD DB E8 7A 36 DD DB DD D8 DD DB D9 C9 D9 CA EB 06 DD DD DD D8 DD D9 D9 E5 DF E0 DD D8 F6 C4 02 D9 05 ?? ?? ?? ?? 74 08 DD D8 D9 05 ?? ?? ?? ?? D9 C0 DE CA DE CA E9 6C FF FF FF D9 CC DB E8 7B D0 D9 C4 31 C0 D8 E5 DF E8 D9 CC D9 CD D9 C9 D9 CA D9 CB 0F 9A C0 EB 02 D9 CC D9 C3 D8 E4 D9 C9 D9 CD D9 C9 DF E8 0F 8A A7 00 00 00 D9 C4 D8 E5 DF E8 0F 8B 04 FF FF FF D9 CC DB E8 0F 8A 04 FF FF FF D9 CC D9 CB 31 D2 85 C0 0F 85 00 FF FF FF D9 C3 D8 E4 DF E8 0F 8A FE FE FF FF DD DA DD D8 85 D2 D9 EE 74 08 DD D8 D9 E8 D9 C9 EB 02 D9 C9 D9 E5 DF E0 DD D8 F6 C4 02 D9 E1 74 02 D9 E0 D9 C2 D8 E3 DF E8 7B 04 EB 3C D9 CA D9 EE D9 CB D9 E5 DF E0 DD D8 D9 CA F6 C4 02 D9 E1 74 02 D9 E0 D9 C3 D8 CB D9 C2 D8 CA DE C1 D9 EE DC C9 D9 CC DE CB D9 C9 DE CC D9 C9 DE E3 D9 CA DE C9 D9 C9 E9 A2 FE FF FF D9 CA DB E8 7A BE D9 E8 D9 CB D9 C9 EB BC D9 CB DB E8 BA 01 00 00 00 0F 8B 66 FF FF FF D9 CB E9 43 FF FF FF DD DB D9 C9 D9 CA EB 16 DD DB D9 C9 D9 CA EB 0E D9 C9 D9 CA D9 CB EB 06 D9 C9 D9 CA D9 CB D9 C5 D8 E6 DF E8 0F 9A C2 84 D2 0F B6 C2 74 07 E9 AF 00 00 00 D9 CD D9 C4 D8 E5 DF E8 0F 8B F0 FE FF FF D9 CC 31 D2 DB E8 0F 8A E2 FE FF FF D9 C3 D8 E4 DB E8 0F 8A E2 FE FF FF DD D8 D9 C4 D8 E5 DB E8 0F 8A E0 FE FF FF DD D8 DD DA DD D8 85 D2 D9 EE 74 08 DD D8 D9 E8 D9 CC EB 02 D9 CC D9 E5 DF E0 DD D8 D9 CB F6 C4 02 D9 E1 74 02 D9 E0 D9 C3 D8 E4 DF E8 7B 04 EB 3C D9 CB D9 EE D9 CC D9 E5 DF E0 DD D8 D9 CB F6 C4 02 D9 E1 74 02 D9 E0 D9 C3 D8 CA D9 C1 D8 CC DE C1 D9 05 ?? ?? ?? ?? DC C9 D9 CA DE CB D9 CB DE CC D9 C9 DE E3 DE CA E9 AA FD FF FF D9 CB DB E8 7A BE D9 E8 D9 CC D9 C9 EB BC D9 CD DB E8 0F 8A 47 FF FF FF D9 CD D9 CC BA 01 00 00 00 E9 53 FF FF FF 90 90 90 90 }
	condition:
		$1
}

rule file_61_0_0 {
	meta:
		name = "___bid_unordtd2"
		size = 80
		refs = "0043 ___bid128_quiet_unordered"
	strings:
		$1 = { 83 EC 4C 8B 44 24 60 89 44 24 10 8B 44 24 64 89 44 24 14 8B 44 24 68 89 44 24 18 8B 44 24 6C 89 44 24 1C 8B 44 24 50 89 04 24 8B 44 24 54 89 44 24 04 8B 44 24 58 89 44 24 08 8B 44 24 5C 89 44 24 0C E8 ?? ?? ?? ?? 83 C4 4C C3 90 90 90 90 90 }
	condition:
		$1
}

rule file_139_0_0 {
	meta:
		name = "___bid_gttd2"
		size = 80
		refs = "0043 ___bid128_quiet_greater"
	strings:
		$1 = { 83 EC 4C 8B 44 24 60 89 44 24 10 8B 44 24 64 89 44 24 14 8B 44 24 68 89 44 24 18 8B 44 24 6C 89 44 24 1C 8B 44 24 50 89 04 24 8B 44 24 54 89 44 24 04 8B 44 24 58 89 44 24 08 8B 44 24 5C 89 44 24 0C E8 ?? ?? ?? ?? 83 C4 4C C3 90 90 90 90 90 }
	condition:
		$1
}

rule file_196_0_0 {
	meta:
		name = "___bid_netd2"
		size = 80
		refs = "0043 ___bid128_quiet_not_equal"
	strings:
		$1 = { 83 EC 4C 8B 44 24 60 89 44 24 10 8B 44 24 64 89 44 24 14 8B 44 24 68 89 44 24 18 8B 44 24 6C 89 44 24 1C 8B 44 24 50 89 04 24 8B 44 24 54 89 44 24 04 8B 44 24 58 89 44 24 08 8B 44 24 5C 89 44 24 0C E8 ?? ?? ?? ?? 83 C4 4C C3 90 90 90 90 90 }
	condition:
		$1
}

rule file_62_0_0 {
	meta:
		name = "___fixxfdi"
		size = 64
		refs = "0026 ___fixunsxfdi"
	strings:
		$1 = { 83 EC 1C DB 6C 24 20 D9 EE DF E9 77 13 DB 7C 24 20 83 C4 1C E9 ?? ?? ?? ?? 8D B4 26 00 00 00 00 D9 E0 DB 3C 24 E8 ?? ?? ?? ?? F7 D8 83 D2 00 83 C4 1C F7 DA C3 90 90 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_63_0_0 {
	meta:
		name = "___gcc_bcmp"
		size = 80
	strings:
		$1 = { 57 56 53 8B 7C 24 18 8B 5C 24 10 8B 74 24 14 85 FF 74 26 0F B6 03 83 EF 01 31 D2 0F B6 0E 38 C8 74 13 EB 1C 0F B6 44 13 01 0F B6 4C 16 01 83 C2 01 38 C8 75 0B 39 FA 75 EB 5B 31 C0 5E 5F C3 90 5B 29 C8 5E 5F C3 90 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_64_0_0 {
	meta:
		name = "___bid_trunctdxf"
		size = 48
		refs = "0023 ___bid128_to_binary80"
	strings:
		$1 = { 83 EC 2C 8B 44 24 30 89 04 24 8B 44 24 34 89 44 24 04 8B 44 24 38 89 44 24 08 8B 44 24 3C 89 44 24 0C E8 ?? ?? ?? ?? 83 C4 2C C3 90 90 90 90 90 }
	condition:
		$1
}

rule file_209_0_0 {
	meta:
		name = "___bid_fixtddi"
		size = 48
		refs = "0023 ___bid128_to_int64_xint"
	strings:
		$1 = { 83 EC 2C 8B 44 24 30 89 04 24 8B 44 24 34 89 44 24 04 8B 44 24 38 89 44 24 08 8B 44 24 3C 89 44 24 0C E8 ?? ?? ?? ?? 83 C4 2C C3 90 90 90 90 90 }
	condition:
		$1
}

rule file_194_0_0 {
	meta:
		name = "___bid_fixtdsi"
		size = 48
		refs = "0023 ___bid128_to_int32_xint"
	strings:
		$1 = { 83 EC 2C 8B 44 24 30 89 04 24 8B 44 24 34 89 44 24 04 8B 44 24 38 89 44 24 08 8B 44 24 3C 89 44 24 0C E8 ?? ?? ?? ?? 83 C4 2C C3 90 90 90 90 90 }
	condition:
		$1
}

rule file_130_0_0 {
	meta:
		name = "___bid_trunctddd2"
		size = 48
		refs = "0023 ___bid128_to_bid64"
	strings:
		$1 = { 83 EC 2C 8B 44 24 30 89 04 24 8B 44 24 34 89 44 24 04 8B 44 24 38 89 44 24 08 8B 44 24 3C 89 44 24 0C E8 ?? ?? ?? ?? 83 C4 2C C3 90 90 90 90 90 }
	condition:
		$1
}

rule file_156_0_0 {
	meta:
		name = "___bid_trunctddf"
		size = 48
		refs = "0023 ___bid128_to_binary64"
	strings:
		$1 = { 83 EC 2C 8B 44 24 30 89 04 24 8B 44 24 34 89 44 24 04 8B 44 24 38 89 44 24 08 8B 44 24 3C 89 44 24 0C E8 ?? ?? ?? ?? 83 C4 2C C3 90 90 90 90 90 }
	condition:
		$1
}

rule file_70_0_0 {
	meta:
		name = "___bid_trunctdsd2"
		size = 48
		refs = "0023 ___bid128_to_bid32"
	strings:
		$1 = { 83 EC 2C 8B 44 24 30 89 04 24 8B 44 24 34 89 44 24 04 8B 44 24 38 89 44 24 08 8B 44 24 3C 89 44 24 0C E8 ?? ?? ?? ?? 83 C4 2C C3 90 90 90 90 90 }
	condition:
		$1
}

rule file_101_0_0 {
	meta:
		name = "___bid_trunctdsf"
		size = 48
		refs = "0023 ___bid128_to_binary32"
	strings:
		$1 = { 83 EC 2C 8B 44 24 30 89 04 24 8B 44 24 34 89 44 24 04 8B 44 24 38 89 44 24 08 8B 44 24 3C 89 44 24 0C E8 ?? ?? ?? ?? 83 C4 2C C3 90 90 90 90 90 }
	condition:
		$1
}

rule file_201_0_0 {
	meta:
		name = "___bid_trunctfdd"
		size = 48
		refs = "0023 ___binary128_to_bid64"
	strings:
		$1 = { 83 EC 2C 8B 44 24 30 89 04 24 8B 44 24 34 89 44 24 04 8B 44 24 38 89 44 24 08 8B 44 24 3C 89 44 24 0C E8 ?? ?? ?? ?? 83 C4 2C C3 90 90 90 90 90 }
	condition:
		$1
}

rule file_79_0_0 {
	meta:
		name = "___bid_trunctfsd"
		size = 48
		refs = "0023 ___binary128_to_bid32"
	strings:
		$1 = { 83 EC 2C 8B 44 24 30 89 04 24 8B 44 24 34 89 44 24 04 8B 44 24 38 89 44 24 08 8B 44 24 3C 89 44 24 0C E8 ?? ?? ?? ?? 83 C4 2C C3 90 90 90 90 90 }
	condition:
		$1
}

rule file_168_0_0 {
	meta:
		name = "_isinfd128"
		size = 48
		refs = "0023 ___bid128_isInf"
	strings:
		$1 = { 83 EC 2C 8B 44 24 30 89 04 24 8B 44 24 34 89 44 24 04 8B 44 24 38 89 44 24 08 8B 44 24 3C 89 44 24 0C E8 ?? ?? ?? ?? 83 C4 2C C3 90 90 90 90 90 }
	condition:
		$1
}

rule file_65_0_0 {
	meta:
		name = "___bid64_quiet_equal"
		size = 768
		refs = "0149 ___bid_IDEC_glbflags"
	strings:
		$1 = { 83 EC 34 89 5C 24 24 8B 5C 24 3C 89 74 24 28 8B 44 24 40 89 7C 24 2C 8B 74 24 44 89 6C 24 30 8B 7C 24 38 89 DA 81 E2 00 00 00 7C 81 FA 00 00 00 7C 0F 84 DE 00 00 00 89 F2 81 E2 00 00 00 7C 81 FA 00 00 00 7C 0F 84 CA 00 00 00 89 DA 89 F9 31 F2 31 C1 09 D1 0F 84 F7 00 00 00 89 D9 81 E1 00 00 00 78 81 F9 00 00 00 78 0F 84 31 02 00 00 89 F2 81 E2 00 00 00 78 81 FA 00 00 00 78 0F 84 8E 00 00 00 89 DA 89 DD 81 E2 00 00 00 60 81 FA 00 00 00 60 0F 84 C7 00 00 00 89 DA 81 E5 00 00 E0 7F 81 E2 FF FF 1F 00 89 54 24 10 C1 ED 15 09 FA 0F 94 44 24 1A 0F B6 54 24 1A 89 7C 24 14 88 54 24 1B 89 F2 89 F1 81 E2 00 00 00 60 81 FA 00 00 00 60 0F 84 D0 00 00 00 89 04 24 89 F0 81 E1 00 00 E0 7F 25 FF FF 1F 00 C1 E9 15 89 C2 0B 14 24 89 44 24 04 0F 85 E6 00 00 00 80 7C 24 1A 00 B8 01 00 00 00 75 2D 80 7C 24 1B 00 0F 85 DC 00 00 00 31 C0 EB 1E 81 E3 00 00 00 7E 81 FB 00 00 00 7E 74 24 81 E6 00 00 00 7E 31 C0 81 FE 00 00 00 7E 74 14 8B 5C 24 24 8B 74 24 28 8B 7C 24 2C 8B 6C 24 30 83 C4 34 C3 83 0D ?? ?? ?? ?? 01 31 C0 EB E1 B8 01 00 00 00 EB DA 8D B4 26 00 00 00 00 89 DA 81 E5 00 00 F8 1F 81 E2 FF FF 07 00 81 CA 00 00 20 00 C1 ED 13 81 FA F2 86 23 00 89 7C 24 14 89 54 24 10 0F 87 35 01 00 00 72 0C 81 FF FF FF C0 6F 0F 87 27 01 00 00 C6 44 24 1B 00 C6 44 24 1A 00 E9 1A FF FF FF 89 F2 81 E1 00 00 F8 1F 81 E2 FF FF 07 00 81 CA 00 00 20 00 C1 E9 13 81 FA F2 86 23 00 89 04 24 89 54 24 04 0F 87 28 FF FF FF 72 0C 3D FF FF C0 6F 0F 87 1B FF FF FF 90 31 C0 80 7C 24 1A 00 0F 85 46 FF FF FF 31 DE 0F 88 1C FF FF FF 39 CD 7E 20 8B 14 24 8B 44 24 10 89 3C 24 89 54 24 14 8B 54 24 04 89 44 24 04 89 E8 89 CD 89 C1 89 54 24 10 89 CF 31 C0 29 EF 83 FF 0F 0F 8F 0B FF FF FF 85 FF 0F 8E A6 00 00 00 8B 04 24 B9 0A 00 00 00 6B 5C 24 04 0A F7 E1 01 DA 81 FA F2 86 23 00 89 04 24 89 54 24 04 0F 87 BD FE FF FF 72 0D 81 3C 24 FF FF C0 6F 0F 87 AE FE FF FF 8B 04 24 83 EF 01 31 DB 8B 54 24 04 BD 0A 00 00 00 39 FB 74 57 6B CA 0A 83 C3 01 F7 E5 01 CA 81 FA F2 86 23 00 0F 87 83 FE FF FF 72 E4 3D FF FF C0 6F 76 DD 31 C0 E9 95 FE FF FF 66 90 81 E6 00 00 00 78 31 C0 81 FE 00 00 00 78 0F 85 7F FE FF FF 89 D0 F7 D0 C1 E8 1F E9 73 FE FF FF C6 44 24 1B 01 C6 44 24 1A 01 E9 F3 FD FF FF 89 04 24 89 54 24 04 8B 14 24 8B 44 24 10 33 44 24 04 33 54 24 14 09 C2 0F 94 C0 0F B6 C0 E9 41 FE FF FF 8D B4 26 00 00 00 00 8D BC 27 00 00 00 00 }
	condition:
		$1
}

rule file_65_1_0 {
	meta:
		name = "___bid64_quiet_greater"
		size = 1120
		refs = "0142 .rdata 0244 ___bid_IDEC_glbflags"
	strings:
		$1 = { 83 EC 3C 8B 4C 24 44 89 5C 24 2C 8B 54 24 4C 89 74 24 30 8B 5C 24 40 89 7C 24 34 8B 74 24 48 89 C8 25 00 00 00 7C 3D 00 00 00 7C 89 6C 24 38 0F 84 DB 01 00 00 89 D0 25 00 00 00 7C 3D 00 00 00 7C 0F 84 C9 01 00 00 89 CF 89 D8 31 D7 31 F0 09 C7 0F 84 F9 01 00 00 89 C8 25 00 00 00 78 3D 00 00 00 78 0F 84 8F 02 00 00 89 D0 25 00 00 00 78 3D 00 00 00 78 0F 84 25 02 00 00 89 C8 25 00 00 00 60 3D 00 00 00 60 0F 84 C7 01 00 00 89 CF 89 CD 81 E7 00 00 E0 7F 89 D8 81 E5 FF FF 1F 00 C1 EF 15 09 E8 0F 94 44 24 08 0F B6 44 24 08 89 7C 24 18 88 44 24 10 89 D7 81 E7 00 00 00 60 81 FF 00 00 00 60 89 D7 0F 84 DB 01 00 00 89 D0 81 E7 00 00 E0 7F 25 FF FF 1F 00 C1 EF 15 89 04 24 09 F0 0F 84 F1 01 00 00 80 7C 24 10 00 0F 85 AE 01 00 00 89 D0 31 C8 0F 88 A4 01 00 00 39 7C 24 18 0F 9F C2 0F 8F 2D 02 00 00 39 7C 24 18 0F 8C 42 02 00 00 8B 44 24 18 29 F8 83 F8 0F 89 44 24 08 0F 8F C6 01 00 00 2B 7C 24 18 83 FF 0F 0F 8F 3B 02 00 00 84 D2 0F 84 3D 02 00 00 8B 54 24 08 8B 3C D5 ?? ?? ?? ?? 8B 04 D5 ?? ?? ?? ?? 89 44 24 10 89 F8 F7 E5 89 44 24 08 8B 44 24 10 89 54 24 0C F7 E5 89 44 24 20 89 F8 89 54 24 24 F7 E3 89 54 24 1C 8B 6C 24 1C 31 D2 89 44 24 18 8B 44 24 08 89 EF 31 ED 01 C7 8B 44 24 10 11 D5 F7 E3 01 C7 11 D5 8B 54 24 0C 89 D0 31 D2 89 44 24 10 8B 44 24 20 89 54 24 14 8B 54 24 24 01 44 24 10 11 54 24 14 31 D2 01 6C 24 10 11 54 24 14 8B 54 24 14 0B 54 24 10 0F 85 8A 02 00 00 89 FA 8B 7C 24 18 31 C0 31 ED 89 F3 01 F8 8B 3C 24 11 EA 31 C3 31 D7 09 DF 74 6A 39 14 24 BB 01 00 00 00 72 0E 0F 87 39 01 00 00 39 C6 0F 83 31 01 00 00 89 DA 89 C8 C1 E8 1F 31 D0 EB 25 8D B4 26 00 00 00 00 81 E1 00 00 00 7E 81 F9 00 00 00 7E 74 24 81 E2 00 00 00 7E 31 C0 81 FA 00 00 00 7E 74 14 8B 5C 24 2C 8B 74 24 30 8B 7C 24 34 8B 6C 24 38 83 C4 3C C3 83 0D ?? ?? ?? ?? 01 31 C0 EB E1 8D 76 00 31 C0 EB DA 89 CD 89 C8 81 E5 FF FF 07 00 25 00 00 F8 1F 81 CD 00 00 20 00 C1 E8 13 81 FD F2 86 23 00 89 44 24 18 0F 87 A4 00 00 00 72 0C 81 FB FF FF C0 6F 0F 87 96 00 00 00 C6 44 24 10 00 C6 44 24 08 00 E9 1D FE FF FF 8D B4 26 00 00 00 00 89 D0 C1 E8 1F EB 87 89 D0 81 E7 00 00 F8 1F 25 FF FF 07 00 0D 00 00 20 00 C1 EF 13 3D F2 86 23 00 89 04 24 77 12 0F 82 1B FE FF FF 81 FE FF FF C0 6F 0F 86 0F FE FF FF 31 C0 80 7C 24 08 00 0F 85 49 FF FF FF 80 7C 24 10 00 75 B4 89 C8 F7 D0 C1 E8 1F E9 36 FF FF FF 85 C9 0F 88 50 FF FF FF 89 D1 B8 01 00 00 00 81 E1 00 00 00 78 C1 EA 1F 81 F9 00 00 00 78 0F 44 C2 E9 10 FF FF FF 66 90 C6 44 24 10 01 C6 44 24 08 01 E9 87 FD FF FF 31 DB E9 C8 FE FF FF 3B 2C 24 77 B1 90 8D 74 26 00 0F 82 C3 FD FF FF 39 F3 77 A2 8D B6 00 00 00 00 E9 B4 FD FF FF 3B 2C 24 72 14 8D B6 00 00 00 00 0F 87 AD FD FF FF 39 F3 0F 83 A5 FD FF FF 89 C8 C1 E8 1F E9 B6 FE FF FF 8B 04 FD ?? ?? ?? ?? 8B 3C FD ?? ?? ?? ?? C7 44 24 24 00 00 00 00 89 44 24 10 F7 24 24 89 44 24 18 8B 04 24 89 54 24 1C F7 E7 89 04 24 8B 44 24 10 89 54 24 04 F7 E6 89 54 24 14 8B 54 24 18 89 44 24 10 89 54 24 20 8B 54 24 14 89 D0 31 D2 89 44 24 08 8B 44 24 20 89 54 24 0C 8B 54 24 24 01 44 24 08 89 F8 11 54 24 0C F7 E6 8B 7C 24 1C 01 44 24 08 11 54 24 0C 8B 54 24 0C 89 FE 31 FF 03 34 24 13 7C 24 04 89 D0 31 D2 01 C6 11 D7 89 FA 09 F2 75 42 8B 44 24 08 31 FF 8B 74 24 10 89 C2 31 C0 01 F0 89 DE 11 FA 89 EF 31 D7 31 C6 09 F7 0F 84 22 FE FF FF 39 D5 BE 01 00 00 00 77 06 72 0C 39 C3 76 08 89 F2 90 E9 BB FD FF FF 31 F6 89 F2 E9 B2 FD FF FF 31 D2 E9 AB FD FF FF BA 01 00 00 00 E9 A1 FD FF FF 90 }
	condition:
		$1
}

rule file_65_2_0 {
	meta:
		name = "___bid64_quiet_greater_equal"
		size = 1168
		refs = "013f .rdata 0242 ___bid_IDEC_glbflags"
	strings:
		$1 = { 83 EC 3C 8B 4C 24 44 89 5C 24 2C 8B 54 24 4C 89 74 24 30 8B 5C 24 40 89 7C 24 34 8B 74 24 48 89 C8 25 00 00 00 7C 3D 00 00 00 7C 89 6C 24 38 0F 84 D3 01 00 00 89 D0 25 00 00 00 7C 3D 00 00 00 7C 0F 84 C1 01 00 00 89 CF 89 D8 31 D7 31 F0 09 C7 0F 84 F9 01 00 00 89 C8 25 00 00 00 78 3D 00 00 00 78 0F 84 9B 02 00 00 89 D0 25 00 00 00 78 3D 00 00 00 78 0F 84 25 02 00 00 89 C8 25 00 00 00 60 3D 00 00 00 60 0F 84 CA 01 00 00 89 CF 89 CD 81 E7 00 00 E0 7F 89 D8 81 E5 FF FF 1F 00 C1 EF 15 09 E8 0F 94 44 24 08 0F B6 44 24 08 89 7C 24 18 88 44 24 10 89 D7 81 E7 00 00 00 60 81 FF 00 00 00 60 89 D7 0F 84 E4 01 00 00 89 D0 81 E7 00 00 E0 7F 25 FF FF 1F 00 C1 EF 15 89 04 24 09 F0 0F 84 FA 01 00 00 80 7C 24 10 00 0F 85 AE 01 00 00 89 D0 31 C8 0F 88 A4 01 00 00 39 7C 24 18 0F 8D 4A 02 00 00 39 7C 24 18 0F 8E 57 02 00 00 8B 54 24 18 29 FA 83 FA 0F 0F 8F D9 01 00 00 89 F8 2B 44 24 18 83 F8 0F 89 44 24 08 0F 8F 54 02 00 00 39 7C 24 18 0F 8E 54 02 00 00 8B 3C D5 ?? ?? ?? ?? 8B 14 D5 ?? ?? ?? ?? 89 F8 89 54 24 10 F7 E5 89 44 24 08 8B 44 24 10 89 54 24 0C F7 E5 89 44 24 20 89 F8 89 54 24 24 F7 E3 89 54 24 1C 8B 6C 24 1C 31 D2 89 44 24 18 8B 44 24 08 89 EF 31 ED 01 C7 8B 44 24 10 11 D5 F7 E3 01 C7 11 D5 8B 54 24 0C 89 D0 31 D2 89 44 24 10 8B 44 24 20 89 54 24 14 8B 54 24 24 01 44 24 10 11 54 24 14 31 D2 01 6C 24 10 11 54 24 14 8B 54 24 14 0B 54 24 10 0F 85 B7 02 00 00 89 FA 8B 7C 24 18 31 C0 31 ED 89 F3 01 F8 8B 3C 24 11 EA 31 C3 31 D7 09 DF 74 6D 3B 14 24 BB 01 00 00 00 72 0E 0F 87 53 01 00 00 39 F0 0F 83 4B 01 00 00 89 DA 89 C8 F7 D0 C1 E8 1F 31 D0 EB 1E 81 E1 00 00 00 7E 81 F9 00 00 00 7E 74 2A 81 E2 00 00 00 7E 31 C0 81 FA 00 00 00 7E 74 1A 8B 5C 24 2C 8B 74 24 30 8B 7C 24 34 8B 6C 24 38 83 C4 3C C3 8D B6 00 00 00 00 83 0D ?? ?? ?? ?? 01 31 C0 EB DB 90 8D 74 26 00 B8 01 00 00 00 EB CF 89 CD 89 C8 81 E5 FF FF 07 00 25 00 00 F8 1F 81 CD 00 00 20 00 C1 E8 13 81 FD F2 86 23 00 89 44 24 18 0F 87 A9 00 00 00 72 0C 81 FB FF FF C0 6F 0F 87 9B 00 00 00 C6 44 24 10 00 C6 44 24 08 00 E9 1A FE FF FF 8D 74 26 00 89 D0 C1 E8 1F E9 7C FF FF FF 8D B6 00 00 00 00 89 D0 81 E7 00 00 F8 1F 25 FF FF 07 00 0D 00 00 20 00 C1 EF 13 3D F2 86 23 00 89 04 24 77 12 0F 82 12 FE FF FF 81 FE FF FF C0 6F 0F 86 06 FE FF FF 80 7C 24 08 00 B8 01 00 00 00 0F 85 35 FF FF FF 80 7C 24 10 00 75 A8 89 C8 F7 D0 C1 E8 1F E9 22 FF FF FF 85 C9 B8 01 00 00 00 0F 89 15 FF FF FF 89 D1 81 E1 00 00 00 78 81 F9 00 00 00 78 74 16 31 C0 E9 FE FE FF FF C6 44 24 10 01 C6 44 24 08 01 E9 7F FD FF FF 85 D2 0F 88 E7 FE FF FF 31 C0 E9 E0 FE FF FF 31 DB E9 AE FE FF FF 8D 76 00 3B 2C 24 77 A3 0F 82 AB FD FF FF 39 F3 8D 76 00 77 96 E9 9F FD FF FF 3B 2C 24 8D B6 00 00 00 00 72 14 0F 87 98 FD FF FF 39 F3 8D B6 00 00 00 00 0F 83 8A FD FF FF 89 C8 C1 E8 1F E9 96 FE FF FF 8B 7C 24 08 8B 44 24 08 C7 44 24 24 00 00 00 00 8B 3C FD ?? ?? ?? ?? 89 7C 24 10 8B 3C C5 ?? ?? ?? ?? 8B 44 24 10 F7 24 24 89 44 24 18 8B 04 24 89 54 24 1C F7 E7 89 04 24 8B 44 24 10 89 54 24 04 F7 E6 89 54 24 14 8B 54 24 18 89 44 24 10 89 54 24 20 8B 54 24 14 89 D0 31 D2 89 44 24 08 8B 44 24 20 89 54 24 0C 8B 54 24 24 01 44 24 08 89 F8 11 54 24 0C F7 E6 8B 7C 24 1C 01 44 24 08 11 54 24 0C 8B 54 24 0C 89 FE 31 FF 03 34 24 13 7C 24 04 89 D0 31 D2 01 C6 11 D7 89 FA 09 F2 75 45 8B 44 24 08 31 FF 8B 74 24 10 89 C2 31 C0 01 F0 89 DE 11 FA 89 EF 31 D7 31 C6 09 F7 0F 84 FE FD FF FF 39 D5 BE 01 00 00 00 72 07 77 0C 39 C3 90 73 07 89 F2 E9 94 FD FF FF 31 F6 89 F2 8D 76 00 E9 88 FD FF FF BA 01 00 00 00 E9 7E FD FF FF 31 D2 E9 77 FD FF FF 8D 76 00 8D BC 27 00 00 00 00 }
	condition:
		$1
}

rule file_65_3_0 {
	meta:
		name = "___bid64_quiet_greater_unordered"
		size = 1136
		refs = "013f .rdata 0242 ___bid_IDEC_glbflags"
	strings:
		$1 = { 83 EC 3C 8B 4C 24 44 89 5C 24 2C 8B 54 24 4C 89 74 24 30 8B 5C 24 40 89 7C 24 34 8B 74 24 48 89 C8 25 00 00 00 7C 3D 00 00 00 7C 89 6C 24 38 0F 84 D1 01 00 00 89 D0 25 00 00 00 7C 3D 00 00 00 7C 0F 84 BF 01 00 00 89 CF 89 D8 31 D7 31 F0 09 C7 0F 84 F9 01 00 00 89 C8 25 00 00 00 78 3D 00 00 00 78 0F 84 8F 02 00 00 89 D0 25 00 00 00 78 3D 00 00 00 78 0F 84 25 02 00 00 89 C8 25 00 00 00 60 3D 00 00 00 60 0F 84 C7 01 00 00 89 CF 89 CD 81 E7 00 00 E0 7F 89 D8 81 E5 FF FF 1F 00 C1 EF 15 09 E8 0F 94 44 24 08 0F B6 44 24 08 89 7C 24 18 88 44 24 10 89 D7 81 E7 00 00 00 60 81 FF 00 00 00 60 89 D7 0F 84 DB 01 00 00 89 D0 81 E7 00 00 E0 7F 25 FF FF 1F 00 C1 EF 15 89 04 24 09 F0 0F 84 F1 01 00 00 80 7C 24 10 00 0F 85 AE 01 00 00 89 D0 31 C8 0F 88 A4 01 00 00 39 7C 24 18 0F 8D 30 02 00 00 39 7C 24 18 0F 8E 45 02 00 00 8B 54 24 18 29 FA 83 FA 0F 0F 8F CD 01 00 00 89 F8 2B 44 24 18 83 F8 0F 89 44 24 08 0F 8F 3C 02 00 00 39 7C 24 18 0F 8E 3C 02 00 00 8B 3C D5 ?? ?? ?? ?? 8B 14 D5 ?? ?? ?? ?? 89 F8 89 54 24 10 F7 E5 89 44 24 08 8B 44 24 10 89 54 24 0C F7 E5 89 44 24 20 89 F8 89 54 24 24 F7 E3 89 54 24 1C 8B 6C 24 1C 31 D2 89 44 24 18 8B 44 24 08 89 EF 31 ED 01 C7 8B 44 24 10 11 D5 F7 E3 01 C7 11 D5 8B 54 24 0C 89 D0 31 D2 89 44 24 10 8B 44 24 20 89 54 24 14 8B 54 24 24 01 44 24 10 11 54 24 14 31 D2 01 6C 24 10 11 54 24 14 8B 54 24 14 0B 54 24 10 0F 85 9D 02 00 00 89 FA 8B 7C 24 18 31 C0 31 ED 89 F3 01 F8 8B 3C 24 11 EA 31 C3 31 D7 09 DF 74 6D 39 14 24 BB 01 00 00 00 72 0E 0F 87 3C 01 00 00 39 C6 0F 83 34 01 00 00 89 DA 89 C8 C1 E8 1F 31 D0 EB 21 81 E1 00 00 00 7E 81 F9 00 00 00 7E 74 2C 81 E2 00 00 00 7E B8 01 00 00 00 81 FA 00 00 00 7E 74 19 8B 5C 24 2C 8B 74 24 30 8B 7C 24 34 8B 6C 24 38 83 C4 3C C3 90 8D 74 26 00 83 0D ?? ?? ?? ?? 01 B8 01 00 00 00 EB D9 66 90 31 C0 EB D3 89 CD 89 C8 81 E5 FF FF 07 00 25 00 00 F8 1F 81 CD 00 00 20 00 C1 E8 13 81 FD F2 86 23 00 89 44 24 18 0F 87 A4 00 00 00 72 0C 81 FB FF FF C0 6F 0F 87 96 00 00 00 C6 44 24 10 00 C6 44 24 08 00 E9 1D FE FF FF 8D B4 26 00 00 00 00 89 D0 C1 E8 1F EB 80 89 D0 81 E7 00 00 F8 1F 25 FF FF 07 00 0D 00 00 20 00 C1 EF 13 3D F2 86 23 00 89 04 24 77 12 0F 82 1B FE FF FF 81 FE FF FF C0 6F 0F 86 0F FE FF FF 31 C0 80 7C 24 08 00 0F 85 42 FF FF FF 80 7C 24 10 00 75 B4 89 C8 F7 D0 C1 E8 1F E9 2F FF FF FF 85 C9 0F 88 50 FF FF FF 89 D1 B8 01 00 00 00 81 E1 00 00 00 78 C1 EA 1F 81 F9 00 00 00 78 0F 44 C2 E9 09 FF FF FF 66 90 C6 44 24 10 01 C6 44 24 08 01 E9 87 FD FF FF 31 DB E9 C5 FE FF FF 3B 2C 24 77 B1 90 8D 74 26 00 0F 82 C0 FD FF FF 39 F3 77 A2 8D B6 00 00 00 00 E9 B1 FD FF FF 3B 2C 24 72 14 8D B6 00 00 00 00 0F 87 AA FD FF FF 39 F3 0F 83 A2 FD FF FF 89 C8 C1 E8 1F E9 AF FE FF FF 8B 7C 24 08 8B 44 24 08 C7 44 24 24 00 00 00 00 8B 3C FD ?? ?? ?? ?? 89 7C 24 10 8B 3C C5 ?? ?? ?? ?? 8B 44 24 10 F7 24 24 89 44 24 18 8B 04 24 89 54 24 1C F7 E7 89 04 24 8B 44 24 10 89 54 24 04 F7 E6 89 54 24 14 8B 54 24 18 89 44 24 10 89 54 24 20 8B 54 24 14 89 D0 31 D2 89 44 24 08 8B 44 24 20 89 54 24 0C 8B 54 24 24 01 44 24 08 89 F8 11 54 24 0C F7 E6 8B 7C 24 1C 01 44 24 08 11 54 24 0C 8B 54 24 0C 89 FE 31 FF 03 34 24 13 7C 24 04 89 D0 31 D2 01 C6 11 D7 89 FA 09 F2 75 46 8B 44 24 08 31 FF 8B 74 24 10 89 C2 31 C0 01 F0 89 DE 11 FA 89 EF 31 D7 31 C6 09 F7 0F 84 16 FE FF FF 39 D5 BE 01 00 00 00 77 06 72 10 39 C3 76 0C 89 F2 90 8D 74 26 00 E9 A8 FD FF FF 31 F6 89 F2 E9 9F FD FF FF 31 D2 E9 98 FD FF FF BA 01 00 00 00 E9 8E FD FF FF 90 }
	condition:
		$1
}

rule file_65_4_0 {
	meta:
		name = "___bid64_quiet_less"
		size = 1120
		refs = "013f .rdata 023a ___bid_IDEC_glbflags"
	strings:
		$1 = { 83 EC 3C 8B 4C 24 44 89 5C 24 2C 8B 54 24 4C 89 74 24 30 8B 5C 24 40 89 7C 24 34 8B 74 24 48 89 C8 25 00 00 00 7C 3D 00 00 00 7C 89 6C 24 38 0F 84 D1 01 00 00 89 D0 25 00 00 00 7C 3D 00 00 00 7C 0F 84 BF 01 00 00 89 CF 89 D8 31 D7 31 F0 09 C7 0F 84 EC 01 00 00 89 C8 25 00 00 00 78 3D 00 00 00 78 0F 84 27 02 00 00 89 D0 25 00 00 00 78 3D 00 00 00 78 0F 84 35 02 00 00 89 C8 25 00 00 00 60 3D 00 00 00 60 0F 84 BA 01 00 00 89 CF 89 CD 81 E7 00 00 E0 7F 89 D8 81 E5 FF FF 1F 00 C1 EF 15 09 E8 0F 94 44 24 08 0F B6 44 24 08 89 7C 24 18 88 44 24 10 89 D7 81 E7 00 00 00 60 81 FF 00 00 00 60 89 D7 0F 84 F4 01 00 00 89 D0 81 E7 00 00 E0 7F 25 FF FF 1F 00 C1 EF 15 89 04 24 09 F0 0F 84 0A 02 00 00 80 7C 24 10 00 0F 85 BE 01 00 00 89 D0 31 C8 0F 88 B4 01 00 00 39 7C 24 18 0F 8D 20 02 00 00 39 7C 24 18 0F 8E 35 02 00 00 8B 54 24 18 29 FA 83 FA 0F 0F 8F E6 01 00 00 89 F8 2B 44 24 18 83 F8 0F 89 44 24 08 0F 8F 2C 02 00 00 39 7C 24 18 0F 8E 2E 02 00 00 8B 3C D5 ?? ?? ?? ?? 8B 14 D5 ?? ?? ?? ?? 89 F8 89 54 24 10 F7 E5 89 44 24 08 8B 44 24 10 89 54 24 0C F7 E5 89 44 24 20 89 F8 89 54 24 24 F7 E3 89 54 24 1C 8B 6C 24 1C 31 D2 89 44 24 18 8B 44 24 08 89 EF 31 ED 01 C7 8B 44 24 10 11 D5 F7 E3 01 C7 11 D5 8B 54 24 0C 89 D0 31 D2 89 44 24 10 8B 44 24 20 89 54 24 14 8B 54 24 24 01 44 24 10 11 54 24 14 31 D2 01 6C 24 10 11 54 24 14 8B 54 24 14 0B 54 24 10 0F 85 90 02 00 00 89 FA 8B 7C 24 18 31 C0 31 ED 89 F3 01 F8 8B 3C 24 11 EA 31 C3 31 D7 09 DF 74 60 3B 14 24 BB 01 00 00 00 72 0E 0F 87 2C 01 00 00 39 F0 0F 83 24 01 00 00 89 DA 89 C8 C1 E8 1F 31 D0 EB 1E 81 E1 00 00 00 7E 81 F9 00 00 00 7E 74 24 81 E2 00 00 00 7E 31 C0 81 FA 00 00 00 7E 74 14 8B 5C 24 2C 8B 74 24 30 8B 7C 24 34 8B 6C 24 38 83 C4 3C C3 83 0D ?? ?? ?? ?? 01 31 C0 EB E1 31 C0 EB DD 89 CD 89 C8 81 E5 FF FF 07 00 25 00 00 F8 1F 81 CD 00 00 20 00 C1 E8 13 81 FD F2 86 23 00 89 44 24 18 0F 87 A1 00 00 00 72 0C 81 FB FF FF C0 6F 0F 87 93 00 00 00 C6 44 24 10 00 C6 44 24 08 00 E9 2A FE FF FF 8D 74 26 00 31 C0 85 C9 79 8E 89 D1 B0 01 81 E1 00 00 00 78 81 F9 00 00 00 78 0F 85 78 FF FF FF 8D 74 26 00 89 D0 F7 D0 C1 E8 1F E9 68 FF FF FF 8D 74 26 00 89 D0 81 E7 00 00 F8 1F 25 FF FF 07 00 0D 00 00 20 00 C1 EF 13 3D F2 86 23 00 89 04 24 77 12 0F 82 02 FE FF FF 81 FE FF FF C0 6F 0F 86 F6 FD FF FF 31 C0 80 7C 24 08 00 0F 85 26 FF FF FF 80 7C 24 10 00 75 AB 89 C8 C1 E8 1F E9 15 FF FF FF 90 C6 44 24 10 01 C6 44 24 08 01 E9 97 FD FF FF 31 DB E9 D5 FE FF FF 3B 2C 24 77 DA 90 8D 74 26 00 0F 82 D0 FD FF FF 39 F3 77 CB 8D B6 00 00 00 00 E9 C1 FD FF FF 3B 2C 24 72 14 8D B6 00 00 00 00 0F 87 BA FD FF FF 39 F3 0F 83 B2 FD FF FF 89 C8 F7 D0 C1 E8 1F E9 BA FE FF FF 8B 7C 24 08 8B 44 24 08 C7 44 24 24 00 00 00 00 8B 3C FD ?? ?? ?? ?? 89 7C 24 10 8B 3C C5 ?? ?? ?? ?? 8B 44 24 10 F7 24 24 89 44 24 18 8B 04 24 89 54 24 1C F7 E7 89 04 24 8B 44 24 10 89 54 24 04 F7 E6 89 54 24 14 8B 54 24 18 89 44 24 10 89 54 24 20 8B 54 24 14 89 D0 31 D2 89 44 24 08 8B 44 24 20 89 54 24 0C 8B 54 24 24 01 44 24 08 89 F8 11 54 24 0C F7 E6 8B 7C 24 1C 01 44 24 08 11 54 24 0C 8B 54 24 0C 89 FE 31 FF 03 34 24 13 7C 24 04 89 D0 31 D2 01 C6 11 D7 89 FA 09 F2 75 44 8B 44 24 08 31 FF 8B 74 24 10 89 C2 31 C0 01 F0 89 DE 11 FA 89 EF 31 D7 31 C6 09 F7 0F 84 17 FE FF FF 39 D5 BE 01 00 00 00 72 06 77 0E 39 C3 73 0A 89 F2 8D 76 00 E9 B8 FD FF FF 31 F6 89 F2 E9 AF FD FF FF BA 01 00 00 00 E9 A5 FD FF FF 31 D2 E9 9E FD FF FF 90 }
	condition:
		$1
}

rule file_65_5_0 {
	meta:
		name = "___bid64_quiet_less_equal"
		size = 1136
		refs = "013f .rdata 023a ___bid_IDEC_glbflags"
	strings:
		$1 = { 83 EC 3C 8B 4C 24 44 89 5C 24 2C 8B 54 24 4C 89 74 24 30 8B 5C 24 40 89 7C 24 34 8B 74 24 48 89 C8 25 00 00 00 7C 3D 00 00 00 7C 89 6C 24 38 0F 84 D1 01 00 00 89 D0 25 00 00 00 7C 3D 00 00 00 7C 0F 84 BF 01 00 00 89 CF 89 D8 31 D7 31 F0 09 C7 0F 84 EC 01 00 00 89 C8 25 00 00 00 78 3D 00 00 00 78 0F 84 89 02 00 00 89 D0 25 00 00 00 78 3D 00 00 00 78 0F 84 1A 02 00 00 89 C8 25 00 00 00 60 3D 00 00 00 60 0F 84 C3 01 00 00 89 CF 89 CD 81 E7 00 00 E0 7F 89 D8 81 E5 FF FF 1F 00 C1 EF 15 09 E8 0F 94 44 24 08 0F B6 44 24 08 89 7C 24 18 88 44 24 10 89 D7 81 E7 00 00 00 60 81 FF 00 00 00 60 89 D7 0F 84 D4 01 00 00 89 D0 81 E7 00 00 E0 7F 25 FF FF 1F 00 C1 EF 15 89 04 24 09 F0 0F 84 EA 01 00 00 80 7C 24 10 00 0F 85 A3 01 00 00 89 D0 31 C8 0F 88 99 01 00 00 39 7C 24 18 0F 8D 30 02 00 00 39 7C 24 18 0F 8E 45 02 00 00 8B 54 24 18 29 FA 83 FA 0F 0F 8F C9 01 00 00 89 F8 2B 44 24 18 83 F8 0F 89 44 24 08 0F 8F 3C 02 00 00 39 7C 24 18 0F 8E 3E 02 00 00 8B 3C D5 ?? ?? ?? ?? 8B 14 D5 ?? ?? ?? ?? 89 F8 89 54 24 10 F7 E5 89 44 24 08 8B 44 24 10 89 54 24 0C F7 E5 89 44 24 20 89 F8 89 54 24 24 F7 E3 89 54 24 1C 8B 6C 24 1C 31 D2 89 44 24 18 8B 44 24 08 89 EF 31 ED 01 C7 8B 44 24 10 11 D5 F7 E3 01 C7 11 D5 8B 54 24 0C 89 D0 31 D2 89 44 24 10 8B 44 24 20 89 54 24 14 8B 54 24 24 01 44 24 10 11 54 24 14 31 D2 01 6C 24 10 11 54 24 14 8B 54 24 14 0B 54 24 10 0F 85 A0 02 00 00 89 FA 8B 7C 24 18 31 C0 31 ED 89 F3 01 F8 8B 3C 24 11 EA 31 C3 31 D7 09 DF 74 60 3B 14 24 BB 01 00 00 00 72 0E 0F 87 3C 01 00 00 39 F0 0F 83 34 01 00 00 89 DA 89 C8 C1 E8 1F 31 D0 EB 1E 81 E1 00 00 00 7E 81 F9 00 00 00 7E 74 24 81 E2 00 00 00 7E 31 C0 81 FA 00 00 00 7E 74 14 8B 5C 24 2C 8B 74 24 30 8B 7C 24 34 8B 6C 24 38 83 C4 3C C3 83 0D ?? ?? ?? ?? 01 31 C0 EB E1 B8 01 00 00 00 EB DA 8D B6 00 00 00 00 89 CD 89 C8 81 E5 FF FF 07 00 25 00 00 F8 1F 81 CD 00 00 20 00 C1 E8 13 81 FD F2 86 23 00 89 44 24 18 0F 87 98 00 00 00 72 0C 81 FB FF FF C0 6F 0F 87 8A 00 00 00 C6 44 24 10 00 C6 44 24 08 00 E9 21 FE FF FF 89 D0 F7 D0 C1 E8 1F EB 86 66 90 89 D0 81 E7 00 00 F8 1F 25 FF FF 07 00 0D 00 00 20 00 C1 EF 13 3D F2 86 23 00 89 04 24 77 12 0F 82 22 FE FF FF 81 FE FF FF C0 6F 0F 86 16 FE FF FF 80 7C 24 08 00 B8 01 00 00 00 0F 85 43 FF FF FF 80 7C 24 10 00 75 AD 89 C8 C1 E8 1F E9 32 FF FF FF 85 C9 0F 88 49 FF FF FF 89 D0 25 00 00 00 78 3D 00 00 00 78 74 18 31 C0 E9 15 FF FF FF 90 C6 44 24 10 01 C6 44 24 08 01 E9 97 FD FF FF 90 85 D2 B8 01 00 00 00 0F 89 F7 FE FF FF EB D9 31 DB E9 C5 FE FF FF 3B 2C 24 77 AD 90 8D 74 26 00 0F 82 C0 FD FF FF 39 F3 77 9E 8D B6 00 00 00 00 E9 B1 FD FF FF 3B 2C 24 72 14 8D B6 00 00 00 00 0F 87 AA FD FF FF 39 F3 0F 83 A2 FD FF FF 89 C8 F7 D0 C1 E8 1F E9 AA FE FF FF 8B 7C 24 08 8B 44 24 08 C7 44 24 24 00 00 00 00 8B 3C FD ?? ?? ?? ?? 89 7C 24 10 8B 3C C5 ?? ?? ?? ?? 8B 44 24 10 F7 24 24 89 44 24 18 8B 04 24 89 54 24 1C F7 E7 89 04 24 8B 44 24 10 89 54 24 04 F7 E6 89 54 24 14 8B 54 24 18 89 44 24 10 89 54 24 20 8B 54 24 14 89 D0 31 D2 89 44 24 08 8B 44 24 20 89 54 24 0C 8B 54 24 24 01 44 24 08 89 F8 11 54 24 0C F7 E6 8B 7C 24 1C 01 44 24 08 11 54 24 0C 8B 54 24 0C 89 FE 31 FF 03 34 24 13 7C 24 04 89 D0 31 D2 01 C6 11 D7 89 FA 09 F2 75 44 8B 44 24 08 31 FF 8B 74 24 10 89 C2 31 C0 01 F0 89 DE 11 FA 89 EF 31 D7 31 C6 09 F7 0F 84 07 FE FF FF 39 D5 BE 01 00 00 00 72 06 77 0E 39 C3 73 0A 89 F2 8D 76 00 E9 A8 FD FF FF 31 F6 89 F2 E9 9F FD FF FF BA 01 00 00 00 E9 95 FD FF FF 31 D2 E9 8E FD FF FF 90 }
	condition:
		$1
}

rule file_65_6_0 {
	meta:
		name = "___bid64_quiet_less_unordered"
		size = 1136
		refs = "013f .rdata 0242 ___bid_IDEC_glbflags"
	strings:
		$1 = { 83 EC 3C 8B 4C 24 44 89 5C 24 2C 8B 54 24 4C 89 74 24 30 8B 5C 24 40 89 7C 24 34 8B 74 24 48 89 C8 25 00 00 00 7C 3D 00 00 00 7C 89 6C 24 38 0F 84 D1 01 00 00 89 D0 25 00 00 00 7C 3D 00 00 00 7C 0F 84 BF 01 00 00 89 CF 89 D8 31 D7 31 F0 09 C7 0F 84 F9 01 00 00 89 C8 25 00 00 00 78 3D 00 00 00 78 0F 84 37 02 00 00 89 D0 25 00 00 00 78 3D 00 00 00 78 0F 84 45 02 00 00 89 C8 25 00 00 00 60 3D 00 00 00 60 0F 84 C7 01 00 00 89 CF 89 CD 81 E7 00 00 E0 7F 89 D8 81 E5 FF FF 1F 00 C1 EF 15 09 E8 0F 94 44 24 08 0F B6 44 24 08 89 7C 24 18 88 44 24 10 89 D7 81 E7 00 00 00 60 81 FF 00 00 00 60 89 D7 0F 84 04 02 00 00 89 D0 81 E7 00 00 E0 7F 25 FF FF 1F 00 C1 EF 15 89 04 24 09 F0 0F 84 1A 02 00 00 80 7C 24 10 00 0F 85 CE 01 00 00 89 D0 31 C8 0F 88 C4 01 00 00 39 7C 24 18 0F 8D 30 02 00 00 39 7C 24 18 0F 8E 45 02 00 00 8B 54 24 18 29 FA 83 FA 0F 0F 8F F6 01 00 00 89 F8 2B 44 24 18 83 F8 0F 89 44 24 08 0F 8F 3C 02 00 00 39 7C 24 18 0F 8E 3E 02 00 00 8B 3C D5 ?? ?? ?? ?? 8B 14 D5 ?? ?? ?? ?? 89 F8 89 54 24 10 F7 E5 89 44 24 08 8B 44 24 10 89 54 24 0C F7 E5 89 44 24 20 89 F8 89 54 24 24 F7 E3 89 54 24 1C 8B 6C 24 1C 31 D2 89 44 24 18 8B 44 24 08 89 EF 31 ED 01 C7 8B 44 24 10 11 D5 F7 E3 01 C7 11 D5 8B 54 24 0C 89 D0 31 D2 89 44 24 10 8B 44 24 20 89 54 24 14 8B 54 24 24 01 44 24 10 11 54 24 14 31 D2 01 6C 24 10 11 54 24 14 8B 54 24 14 0B 54 24 10 0F 85 A0 02 00 00 89 FA 8B 7C 24 18 31 C0 31 ED 89 F3 01 F8 8B 3C 24 11 EA 31 C3 31 D7 09 DF 74 6D 3B 14 24 BB 01 00 00 00 72 0E 0F 87 3C 01 00 00 39 F0 0F 83 34 01 00 00 89 DA 89 C8 C1 E8 1F 31 D0 EB 21 81 E1 00 00 00 7E 81 F9 00 00 00 7E 74 2C 81 E2 00 00 00 7E B8 01 00 00 00 81 FA 00 00 00 7E 74 19 8B 5C 24 2C 8B 74 24 30 8B 7C 24 34 8B 6C 24 38 83 C4 3C C3 90 8D 74 26 00 83 0D ?? ?? ?? ?? 01 B8 01 00 00 00 EB D9 66 90 31 C0 EB D3 89 CD 89 C8 81 E5 FF FF 07 00 25 00 00 F8 1F 81 CD 00 00 20 00 C1 E8 13 81 FD F2 86 23 00 89 44 24 18 0F 87 A4 00 00 00 72 0C 81 FB FF FF C0 6F 0F 87 96 00 00 00 C6 44 24 10 00 C6 44 24 08 00 E9 1D FE FF FF 8D B4 26 00 00 00 00 31 C0 85 C9 79 81 89 D1 B0 01 81 E1 00 00 00 78 81 F9 00 00 00 78 0F 85 6B FF FF FF 8D 74 26 00 89 D0 F7 D0 C1 E8 1F E9 5B FF FF FF 8D 74 26 00 89 D0 81 E7 00 00 F8 1F 25 FF FF 07 00 0D 00 00 20 00 C1 EF 13 3D F2 86 23 00 89 04 24 77 12 0F 82 F2 FD FF FF 81 FE FF FF C0 6F 0F 86 E6 FD FF FF 31 C0 80 7C 24 08 00 0F 85 19 FF FF FF 80 7C 24 10 00 75 AB 89 C8 C1 E8 1F E9 08 FF FF FF 90 C6 44 24 10 01 C6 44 24 08 01 E9 87 FD FF FF 31 DB E9 C5 FE FF FF 3B 2C 24 77 DA 90 8D 74 26 00 0F 82 C0 FD FF FF 39 F3 77 CB 8D B6 00 00 00 00 E9 B1 FD FF FF 3B 2C 24 72 14 8D B6 00 00 00 00 0F 87 AA FD FF FF 39 F3 0F 83 A2 FD FF FF 89 C8 F7 D0 C1 E8 1F E9 AD FE FF FF 8B 7C 24 08 8B 44 24 08 C7 44 24 24 00 00 00 00 8B 3C FD ?? ?? ?? ?? 89 7C 24 10 8B 3C C5 ?? ?? ?? ?? 8B 44 24 10 F7 24 24 89 44 24 18 8B 04 24 89 54 24 1C F7 E7 89 04 24 8B 44 24 10 89 54 24 04 F7 E6 89 54 24 14 8B 54 24 18 89 44 24 10 89 54 24 20 8B 54 24 14 89 D0 31 D2 89 44 24 08 8B 44 24 20 89 54 24 0C 8B 54 24 24 01 44 24 08 89 F8 11 54 24 0C F7 E6 8B 7C 24 1C 01 44 24 08 11 54 24 0C 8B 54 24 0C 89 FE 31 FF 03 34 24 13 7C 24 04 89 D0 31 D2 01 C6 11 D7 89 FA 09 F2 75 44 8B 44 24 08 31 FF 8B 74 24 10 89 C2 31 C0 01 F0 89 DE 11 FA 89 EF 31 D7 31 C6 09 F7 0F 84 14 FE FF FF 39 D5 BE 01 00 00 00 72 06 77 0E 39 C3 73 0A 89 F2 8D 76 00 E9 A8 FD FF FF 31 F6 89 F2 E9 9F FD FF FF BA 01 00 00 00 E9 95 FD FF FF 31 D2 E9 8E FD FF FF 90 }
	condition:
		$1
}

rule file_65_7_0 {
	meta:
		name = "___bid64_quiet_not_equal"
		size = 784
		refs = "0152 ___bid_IDEC_glbflags"
	strings:
		$1 = { 83 EC 34 89 5C 24 24 8B 5C 24 3C 89 74 24 28 8B 44 24 40 89 7C 24 2C 8B 74 24 44 89 6C 24 30 8B 7C 24 38 89 DA 81 E2 00 00 00 7C 81 FA 00 00 00 7C 0F 84 E0 00 00 00 89 F2 81 E2 00 00 00 7C 81 FA 00 00 00 7C 0F 84 CC 00 00 00 89 DA 89 F9 31 F2 31 C1 09 D1 0F 84 05 01 00 00 89 D9 81 E1 00 00 00 78 81 F9 00 00 00 78 0F 84 41 02 00 00 89 F2 81 E2 00 00 00 78 81 FA 00 00 00 78 0F 84 8D 00 00 00 89 DA 89 DD 81 E2 00 00 00 60 81 FA 00 00 00 60 0F 84 CB 00 00 00 89 DA 81 E5 00 00 E0 7F 81 E2 FF FF 1F 00 89 54 24 10 C1 ED 15 09 FA 0F 94 44 24 1A 0F B6 54 24 1A 89 7C 24 14 88 54 24 1B 89 F2 89 F1 81 E2 00 00 00 60 81 FA 00 00 00 60 0F 84 D8 00 00 00 89 04 24 89 F0 81 E1 00 00 E0 7F 25 FF FF 1F 00 C1 E9 15 89 C2 0B 14 24 89 44 24 04 0F 85 ED 00 00 00 31 C0 80 7C 24 1A 00 75 35 80 7C 24 1B 00 0F 85 E9 00 00 00 66 90 B8 01 00 00 00 EB 21 81 E3 00 00 00 7E 81 FB 00 00 00 7E 74 2B 81 E6 00 00 00 7E B8 01 00 00 00 81 FE 00 00 00 7E 74 18 8B 5C 24 24 8B 74 24 28 8B 7C 24 2C 8B 6C 24 30 83 C4 34 C3 8D 74 26 00 83 0D ?? ?? ?? ?? 01 B8 01 00 00 00 EB DA 66 90 31 C0 EB D4 89 DA 81 E5 00 00 F8 1F 81 E2 FF FF 07 00 81 CA 00 00 20 00 C1 ED 13 81 FA F2 86 23 00 89 7C 24 14 89 54 24 10 0F 87 41 01 00 00 72 0C 81 FF FF FF C0 6F 0F 87 33 01 00 00 C6 44 24 1B 00 C6 44 24 1A 00 E9 16 FF FF FF 8D 74 26 00 89 F2 81 E1 00 00 F8 1F 81 E2 FF FF 07 00 81 CA 00 00 20 00 C1 E9 13 81 FA F2 86 23 00 89 04 24 89 54 24 04 0F 87 20 FF FF FF 72 0B 3D FF FF C0 6F 0F 87 13 FF FF FF 80 7C 24 1A 00 B8 01 00 00 00 0F 85 41 FF FF FF 31 DE 0F 88 11 FF FF FF 39 CD 7E 20 8B 14 24 8B 44 24 10 89 3C 24 89 54 24 14 8B 54 24 04 89 44 24 04 89 E8 89 CD 89 C1 89 54 24 10 89 CF B8 01 00 00 00 29 EF 83 FF 0F 0F 8F 03 FF FF FF 85 FF 0F 8E A9 00 00 00 8B 04 24 B9 0A 00 00 00 6B 5C 24 04 0A F7 E1 01 DA 81 FA F2 86 23 00 89 04 24 89 54 24 04 0F 87 AF FE FF FF 72 0D 81 3C 24 FF FF C0 6F 0F 87 A0 FE FF FF 8B 04 24 83 EF 01 31 DB 8B 54 24 04 BD 0A 00 00 00 39 FB 74 5A 6B CA 0A 83 C3 01 F7 E5 01 CA 81 FA F2 86 23 00 0F 87 75 FE FF FF 72 E4 3D FF FF C0 6F 0F 87 68 FE FF FF EB D7 8D B6 00 00 00 00 81 E6 00 00 00 78 B8 01 00 00 00 C1 EA 1F 81 FE 00 00 00 78 0F 44 C2 E9 6C FE FF FF 8D 74 26 00 C6 44 24 1B 01 C6 44 24 1A 01 E9 E3 FD FF FF 89 04 24 89 54 24 04 8B 14 24 8B 44 24 10 33 44 24 04 33 54 24 14 09 C2 0F 95 C0 0F B6 C0 E9 36 FE FF FF 8D B4 26 00 00 00 00 8D BC 27 00 00 00 00 }
	condition:
		$1
}

rule file_65_8_0 {
	meta:
		name = "___bid64_quiet_not_greater"
		size = 1152
		refs = "013f .rdata 0242 ___bid_IDEC_glbflags"
	strings:
		$1 = { 83 EC 3C 8B 4C 24 44 89 5C 24 2C 8B 54 24 4C 89 74 24 30 8B 5C 24 40 89 7C 24 34 8B 74 24 48 89 C8 25 00 00 00 7C 3D 00 00 00 7C 89 6C 24 38 0F 84 D1 01 00 00 89 D0 25 00 00 00 7C 3D 00 00 00 7C 0F 84 BF 01 00 00 89 CF 89 D8 31 D7 31 F0 09 C7 0F 84 F9 01 00 00 89 C8 25 00 00 00 78 3D 00 00 00 78 0F 84 99 02 00 00 89 D0 25 00 00 00 78 3D 00 00 00 78 0F 84 25 02 00 00 89 C8 25 00 00 00 60 3D 00 00 00 60 0F 84 CA 01 00 00 89 CF 89 CD 81 E7 00 00 E0 7F 89 D8 81 E5 FF FF 1F 00 C1 EF 15 09 E8 0F 94 44 24 08 0F B6 44 24 08 89 7C 24 18 88 44 24 10 89 D7 81 E7 00 00 00 60 81 FF 00 00 00 60 89 D7 0F 84 E4 01 00 00 89 D0 81 E7 00 00 E0 7F 25 FF FF 1F 00 C1 EF 15 89 04 24 09 F0 0F 84 FA 01 00 00 80 7C 24 10 00 0F 85 AE 01 00 00 89 D0 31 C8 0F 88 A4 01 00 00 39 7C 24 18 0F 8D 40 02 00 00 39 7C 24 18 0F 8E 55 02 00 00 8B 54 24 18 29 FA 83 FA 0F 0F 8F D9 01 00 00 89 F8 2B 44 24 18 83 F8 0F 89 44 24 08 0F 8F 4C 02 00 00 39 7C 24 18 0F 8E 4E 02 00 00 8B 3C D5 ?? ?? ?? ?? 8B 14 D5 ?? ?? ?? ?? 89 F8 89 54 24 10 F7 E5 89 44 24 08 8B 44 24 10 89 54 24 0C F7 E5 89 44 24 20 89 F8 89 54 24 24 F7 E3 89 54 24 1C 8B 6C 24 1C 31 D2 89 44 24 18 8B 44 24 08 89 EF 31 ED 01 C7 8B 44 24 10 11 D5 F7 E3 01 C7 11 D5 8B 54 24 0C 89 D0 31 D2 89 44 24 10 8B 44 24 20 89 54 24 14 8B 54 24 24 01 44 24 10 11 54 24 14 31 D2 01 6C 24 10 11 54 24 14 8B 54 24 14 0B 54 24 10 0F 85 B0 02 00 00 89 FA 8B 7C 24 18 31 C0 31 ED 89 F3 01 F8 8B 3C 24 11 EA 31 C3 31 D7 09 DF 74 6D 3B 14 24 BB 01 00 00 00 72 0E 0F 87 4C 01 00 00 39 F0 0F 83 44 01 00 00 89 DA 89 C8 C1 E8 1F 31 D0 EB 21 81 E1 00 00 00 7E 81 F9 00 00 00 7E 74 2C 81 E2 00 00 00 7E B8 01 00 00 00 81 FA 00 00 00 7E 74 19 8B 5C 24 2C 8B 74 24 30 8B 7C 24 34 8B 6C 24 38 83 C4 3C C3 90 8D 74 26 00 83 0D ?? ?? ?? ?? 01 B8 01 00 00 00 EB D9 66 90 B8 01 00 00 00 EB D0 89 CD 89 C8 81 E5 FF FF 07 00 25 00 00 F8 1F 81 CD 00 00 20 00 C1 E8 13 81 FD F2 86 23 00 89 44 24 18 0F 87 A1 00 00 00 72 0C 81 FB FF FF C0 6F 0F 87 93 00 00 00 C6 44 24 10 00 C6 44 24 08 00 E9 1A FE FF FF 8D 74 26 00 89 D0 F7 D0 C1 E8 1F E9 7B FF FF FF 8D 74 26 00 89 D0 81 E7 00 00 F8 1F 25 FF FF 07 00 0D 00 00 20 00 C1 EF 13 3D F2 86 23 00 89 04 24 77 12 0F 82 12 FE FF FF 81 FE FF FF C0 6F 0F 86 06 FE FF FF 80 7C 24 08 00 B8 01 00 00 00 0F 85 36 FF FF FF 80 7C 24 10 00 75 A8 89 C8 C1 E8 1F E9 25 FF FF FF 85 C9 0F 88 46 FF FF FF 89 D0 25 00 00 00 78 3D 00 00 00 78 74 18 31 C0 E9 08 FF FF FF 90 C6 44 24 10 01 C6 44 24 08 01 E9 87 FD FF FF 90 85 D2 B8 01 00 00 00 0F 89 EA FE FF FF EB D9 31 DB E9 B5 FE FF FF 3B 2C 24 77 AD 90 8D 74 26 00 0F 82 B0 FD FF FF 39 F3 77 9E 8D B6 00 00 00 00 E9 A1 FD FF FF 3B 2C 24 72 14 8D B6 00 00 00 00 0F 87 9A FD FF FF 39 F3 0F 83 92 FD FF FF 89 C8 F7 D0 C1 E8 1F E9 9D FE FF FF 8B 7C 24 08 8B 44 24 08 C7 44 24 24 00 00 00 00 8B 3C FD ?? ?? ?? ?? 89 7C 24 10 8B 3C C5 ?? ?? ?? ?? 8B 44 24 10 F7 24 24 89 44 24 18 8B 04 24 89 54 24 1C F7 E7 89 04 24 8B 44 24 10 89 54 24 04 F7 E6 89 54 24 14 8B 54 24 18 89 44 24 10 89 54 24 20 8B 54 24 14 89 D0 31 D2 89 44 24 08 8B 44 24 20 89 54 24 0C 8B 54 24 24 01 44 24 08 89 F8 11 54 24 0C F7 E6 8B 7C 24 1C 01 44 24 08 11 54 24 0C 8B 54 24 0C 89 FE 31 FF 03 34 24 13 7C 24 04 89 D0 31 D2 01 C6 11 D7 89 FA 09 F2 75 44 8B 44 24 08 31 FF 8B 74 24 10 89 C2 31 C0 01 F0 89 DE 11 FA 89 EF 31 D7 31 C6 09 F7 0F 84 04 FE FF FF 39 D5 BE 01 00 00 00 72 06 77 0E 39 C3 73 0A 89 F2 8D 76 00 E9 98 FD FF FF 31 F6 89 F2 E9 8F FD FF FF BA 01 00 00 00 E9 85 FD FF FF 31 D2 E9 7E FD FF FF 90 }
	condition:
		$1
}

rule file_65_9_0 {
	meta:
		name = "___bid64_quiet_not_less"
		size = 1168
		refs = "013f .rdata 0242 ___bid_IDEC_glbflags"
	strings:
		$1 = { 83 EC 3C 8B 4C 24 44 89 5C 24 2C 8B 54 24 4C 89 74 24 30 8B 5C 24 40 89 7C 24 34 8B 74 24 48 89 C8 25 00 00 00 7C 3D 00 00 00 7C 89 6C 24 38 0F 84 D3 01 00 00 89 D0 25 00 00 00 7C 3D 00 00 00 7C 0F 84 C1 01 00 00 89 CF 89 D8 31 D7 31 F0 09 C7 0F 84 F9 01 00 00 89 C8 25 00 00 00 78 3D 00 00 00 78 0F 84 97 02 00 00 89 D0 25 00 00 00 78 3D 00 00 00 78 0F 84 25 02 00 00 89 C8 25 00 00 00 60 3D 00 00 00 60 0F 84 CA 01 00 00 89 CF 89 CD 81 E7 00 00 E0 7F 89 D8 81 E5 FF FF 1F 00 C1 EF 15 09 E8 0F 94 44 24 08 0F B6 44 24 08 89 7C 24 18 88 44 24 10 89 D7 81 E7 00 00 00 60 81 FF 00 00 00 60 89 D7 0F 84 DB 01 00 00 89 D0 81 E7 00 00 E0 7F 25 FF FF 1F 00 C1 EF 15 89 04 24 09 F0 0F 84 F1 01 00 00 80 7C 24 10 00 0F 85 AE 01 00 00 89 D0 31 C8 0F 88 A4 01 00 00 39 7C 24 18 0F 8D 4A 02 00 00 39 7C 24 18 0F 8E 57 02 00 00 8B 54 24 18 29 FA 83 FA 0F 0F 8F D0 01 00 00 89 F8 2B 44 24 18 83 F8 0F 89 44 24 08 0F 8F 54 02 00 00 39 7C 24 18 0F 8E 54 02 00 00 8B 3C D5 ?? ?? ?? ?? 8B 14 D5 ?? ?? ?? ?? 89 F8 89 54 24 10 F7 E5 89 44 24 08 8B 44 24 10 89 54 24 0C F7 E5 89 44 24 20 89 F8 89 54 24 24 F7 E3 89 54 24 1C 8B 6C 24 1C 31 D2 89 44 24 18 8B 44 24 08 89 EF 31 ED 01 C7 8B 44 24 10 11 D5 F7 E3 01 C7 11 D5 8B 54 24 0C 89 D0 31 D2 89 44 24 10 8B 44 24 20 89 54 24 14 8B 54 24 24 01 44 24 10 11 54 24 14 31 D2 01 6C 24 10 11 54 24 14 8B 54 24 14 0B 54 24 10 0F 85 B7 02 00 00 89 FA 8B 7C 24 18 31 C0 31 ED 89 F3 01 F8 8B 3C 24 11 EA 31 C3 31 D7 09 DF 74 6D 3B 14 24 BB 01 00 00 00 72 0E 0F 87 4F 01 00 00 39 F0 0F 83 47 01 00 00 89 DA 89 C8 F7 D0 C1 E8 1F 31 D0 EB 21 81 E1 00 00 00 7E 81 F9 00 00 00 7E 74 2A 81 E2 00 00 00 7E B8 01 00 00 00 81 FA 00 00 00 7E 74 17 8B 5C 24 2C 8B 74 24 30 8B 7C 24 34 8B 6C 24 38 83 C4 3C C3 8D 76 00 83 0D ?? ?? ?? ?? 01 B8 01 00 00 00 EB DB 66 90 B8 01 00 00 00 EB D2 89 CD 89 C8 81 E5 FF FF 07 00 25 00 00 F8 1F 81 CD 00 00 20 00 C1 E8 13 81 FD F2 86 23 00 89 44 24 18 0F 87 A5 00 00 00 72 0C 81 FB FF FF C0 6F 0F 87 97 00 00 00 C6 44 24 10 00 C6 44 24 08 00 E9 1A FE FF FF 8D 74 26 00 89 D0 C1 E8 1F EB 82 89 D0 81 E7 00 00 F8 1F 25 FF FF 07 00 0D 00 00 20 00 C1 EF 13 3D F2 86 23 00 89 04 24 77 12 0F 82 1B FE FF FF 81 FE FF FF C0 6F 0F 86 0F FE FF FF 80 7C 24 08 00 B8 01 00 00 00 0F 85 41 FF FF FF 80 7C 24 10 00 75 B1 89 C8 F7 D0 C1 E8 1F E9 2E FF FF FF 90 8D 74 26 00 85 C9 B8 01 00 00 00 0F 89 1C FF FF FF 89 D1 81 E1 00 00 00 78 81 F9 00 00 00 78 74 16 31 C0 E9 05 FF FF FF C6 44 24 10 01 C6 44 24 08 01 E9 83 FD FF FF 85 D2 0F 88 EE FE FF FF 31 C0 E9 E7 FE FF FF 31 DB E9 B2 FE FF FF 8D B4 26 00 00 00 00 3B 2C 24 77 9A 0F 82 AB FD FF FF 39 F3 8D 76 00 77 8D E9 9F FD FF FF 3B 2C 24 8D B6 00 00 00 00 72 14 0F 87 98 FD FF FF 39 F3 8D B6 00 00 00 00 0F 83 8A FD FF FF 89 C8 C1 E8 1F E9 99 FE FF FF 8B 7C 24 08 8B 44 24 08 C7 44 24 24 00 00 00 00 8B 3C FD ?? ?? ?? ?? 89 7C 24 10 8B 3C C5 ?? ?? ?? ?? 8B 44 24 10 F7 24 24 89 44 24 18 8B 04 24 89 54 24 1C F7 E7 89 04 24 8B 44 24 10 89 54 24 04 F7 E6 89 54 24 14 8B 54 24 18 89 44 24 10 89 54 24 20 8B 54 24 14 89 D0 31 D2 89 44 24 08 8B 44 24 20 89 54 24 0C 8B 54 24 24 01 44 24 08 89 F8 11 54 24 0C F7 E6 8B 7C 24 1C 01 44 24 08 11 54 24 0C 8B 54 24 0C 89 FE 31 FF 03 34 24 13 7C 24 04 89 D0 31 D2 01 C6 11 D7 89 FA 09 F2 75 45 8B 44 24 08 31 FF 8B 74 24 10 89 C2 31 C0 01 F0 89 DE 11 FA 89 EF 31 D7 31 C6 09 F7 0F 84 FE FD FF FF 39 D5 BE 01 00 00 00 72 07 77 0C 39 C3 90 73 07 89 F2 E9 94 FD FF FF 31 F6 89 F2 8D 76 00 E9 88 FD FF FF BA 01 00 00 00 E9 7E FD FF FF 31 D2 E9 77 FD FF FF 8D 76 00 8D BC 27 00 00 00 00 }
	condition:
		$1
}

rule file_65_10_0 {
	meta:
		name = "___bid64_quiet_ordered"
		size = 96
		refs = "0052 ___bid_IDEC_glbflags"
	strings:
		$1 = { 53 8B 54 24 0C 8B 4C 24 14 89 D0 25 00 00 00 7C 3D 00 00 00 7C 74 19 89 CB B8 01 00 00 00 81 E3 00 00 00 7C 81 FB 00 00 00 7C 74 04 5B C3 66 90 81 E2 00 00 00 7E 81 FA 00 00 00 7E 74 10 81 E1 00 00 00 7E 31 C0 81 F9 00 00 00 7E 75 DE 31 C0 83 0D ?? ?? ?? ?? 01 5B C3 8D B4 26 00 00 00 00 }
	condition:
		$1
}

rule file_65_11_0 {
	meta:
		name = "___bid64_quiet_unordered"
		size = 96
		refs = "0058 ___bid_IDEC_glbflags"
	strings:
		$1 = { 53 8B 54 24 0C 8B 4C 24 14 89 D0 25 00 00 00 7C 3D 00 00 00 7C 74 19 89 CB 31 C0 81 E3 00 00 00 7C 81 FB 00 00 00 7C 74 07 5B C3 90 8D 74 26 00 81 E2 00 00 00 7E 81 FA 00 00 00 7E 74 13 81 E1 00 00 00 7E B8 01 00 00 00 81 F9 00 00 00 7E 75 D8 B8 01 00 00 00 83 0D ?? ?? ?? ?? 01 5B C3 90 }
	condition:
		$1
}

rule file_65_12_0 {
	meta:
		name = "___bid64_signaling_greater"
		size = 1104
		refs = "013f .rdata 0212 ___bid_IDEC_glbflags"
	strings:
		$1 = { 83 EC 3C 8B 4C 24 44 89 5C 24 2C 8B 54 24 4C 89 74 24 30 8B 5C 24 40 89 7C 24 34 8B 74 24 48 89 C8 25 00 00 00 7C 3D 00 00 00 7C 89 6C 24 38 0F 84 DB 01 00 00 89 D0 25 00 00 00 7C 3D 00 00 00 7C 0F 84 C9 01 00 00 89 CF 89 D8 31 D7 31 F0 09 C7 0F 84 59 02 00 00 89 C8 25 00 00 00 78 3D 00 00 00 78 0F 84 C7 01 00 00 89 D0 25 00 00 00 78 3D 00 00 00 78 0F 84 25 02 00 00 89 C8 25 00 00 00 60 3D 00 00 00 60 0F 84 2A 02 00 00 89 CF 89 CD 81 E7 00 00 E0 7F 89 D8 81 E5 FF FF 1F 00 C1 EF 15 09 E8 0F 94 44 24 08 0F B6 44 24 08 89 7C 24 18 88 44 24 10 89 D7 81 E7 00 00 00 60 81 FF 00 00 00 60 89 D7 0F 84 84 01 00 00 89 D0 81 E7 00 00 E0 7F 25 FF FF 1F 00 C1 EF 15 89 04 24 09 F0 0F 84 9A 01 00 00 80 7C 24 10 00 0F 85 AE 01 00 00 89 D0 31 C8 0F 88 A4 01 00 00 39 7C 24 18 0F 8D 0A 02 00 00 39 7C 24 18 0F 8E 25 02 00 00 8B 54 24 18 29 FA 83 FA 0F 0F 8F 72 01 00 00 89 F8 2B 44 24 18 83 F8 0F 89 44 24 08 0F 8F 1C 02 00 00 39 7C 24 18 0F 8E 1C 02 00 00 8B 3C D5 ?? ?? ?? ?? 8B 14 D5 ?? ?? ?? ?? 89 F8 89 54 24 10 F7 E5 89 44 24 08 8B 44 24 10 89 54 24 0C F7 E5 89 44 24 20 89 F8 89 54 24 24 F7 E3 89 54 24 1C 8B 6C 24 1C 31 D2 89 44 24 18 8B 44 24 08 89 EF 31 ED 01 C7 8B 44 24 10 11 D5 F7 E3 01 C7 11 D5 8B 54 24 0C 89 D0 31 D2 89 44 24 10 8B 44 24 20 89 54 24 14 8B 54 24 24 01 44 24 10 11 54 24 14 31 D2 01 6C 24 10 11 54 24 14 8B 54 24 14 0B 54 24 10 0F 85 7D 02 00 00 89 FA 8B 7C 24 18 31 C0 31 ED 89 F3 01 F8 8B 3C 24 11 EA 31 C3 31 D7 09 DF 0F 84 C9 00 00 00 39 14 24 BB 01 00 00 00 72 0E 0F 87 0C 01 00 00 39 C6 0F 83 04 01 00 00 89 DA 89 C8 C1 E8 1F 31 D0 EB 0F 8D B6 00 00 00 00 83 0D ?? ?? ?? ?? 01 31 C0 8B 5C 24 2C 8B 74 24 30 8B 7C 24 34 8B 6C 24 38 83 C4 3C C3 8D 76 00 85 C9 78 7C 89 D1 B8 01 00 00 00 81 E1 00 00 00 78 C1 EA 1F 81 F9 00 00 00 78 0F 44 C2 EB CA 90 89 D0 81 E7 00 00 F8 1F 25 FF FF 07 00 0D 00 00 20 00 C1 EF 13 3D F2 86 23 00 89 04 24 77 12 0F 82 72 FE FF FF 81 FE FF FF C0 6F 0F 86 66 FE FF FF 31 C0 80 7C 24 08 00 75 8F 80 7C 24 10 00 75 0F 89 C8 F7 D0 C1 E8 1F E9 7C FF FF FF 8D 76 00 89 D0 C1 E8 1F E9 6F FF FF FF 8D B6 00 00 00 00 31 C0 E9 62 FF FF FF 89 CD 89 C8 81 E5 FF FF 07 00 25 00 00 F8 1F 81 CD 00 00 20 00 C1 E8 13 81 FD F2 86 23 00 89 44 24 18 77 19 72 08 81 FB FF FF C0 6F 77 0F C6 44 24 10 00 C6 44 24 08 00 E9 C2 FD FF FF C6 44 24 10 01 C6 44 24 08 01 E9 B3 FD FF FF 31 DB E9 F5 FE FF FF 8D B6 00 00 00 00 3B 2C 24 0F 87 78 FF FF FF 0F 82 E7 FD FF FF 39 F3 0F 87 6A FF FF FF 89 F6 8D BC 27 00 00 00 00 E9 D1 FD FF FF 3B 2C 24 72 14 8D B6 00 00 00 00 0F 87 CA FD FF FF 39 F3 0F 83 C2 FD FF FF 89 C8 C1 E8 1F E9 C1 FE FF FF 8B 7C 24 08 8B 44 24 08 C7 44 24 24 00 00 00 00 8B 3C FD ?? ?? ?? ?? 89 7C 24 10 8B 3C C5 ?? ?? ?? ?? 8B 44 24 10 F7 24 24 89 44 24 18 8B 04 24 89 54 24 1C F7 E7 89 04 24 8B 44 24 10 89 54 24 04 F7 E6 89 54 24 14 8B 54 24 18 89 44 24 10 89 54 24 20 8B 54 24 14 89 D0 31 D2 89 44 24 08 8B 44 24 20 89 54 24 0C 8B 54 24 24 01 44 24 08 89 F8 11 54 24 0C F7 E6 8B 7C 24 1C 01 44 24 08 11 54 24 0C 8B 54 24 0C 89 FE 31 FF 03 34 24 13 7C 24 04 89 D0 31 D2 01 C6 11 D7 89 FA 09 F2 0F 85 42 00 00 00 8B 44 24 08 31 FF 8B 74 24 10 89 C2 31 C0 01 F0 89 DE 11 FA 89 EF 31 D7 31 C6 09 F7 0F 84 92 FE FF FF 39 D5 BE 01 00 00 00 77 06 72 0C 39 C3 76 08 89 F2 90 E9 CC FD FF FF 31 F6 89 F2 E9 C3 FD FF FF 31 D2 E9 BC FD FF FF BA 01 00 00 00 E9 B2 FD FF FF 90 }
	condition:
		$1
}

rule file_65_13_0 {
	meta:
		name = "___bid64_signaling_greater_equal"
		size = 1120
		refs = "013f .rdata 0212 ___bid_IDEC_glbflags"
	strings:
		$1 = { 83 EC 3C 8B 4C 24 44 89 5C 24 2C 8B 54 24 4C 89 74 24 30 8B 5C 24 40 89 7C 24 34 8B 74 24 48 89 C8 25 00 00 00 7C 3D 00 00 00 7C 89 6C 24 38 0F 84 DB 01 00 00 89 D0 25 00 00 00 7C 3D 00 00 00 7C 0F 84 C9 01 00 00 89 CF 89 D8 31 D7 31 F0 09 C7 0F 84 59 02 00 00 89 C8 25 00 00 00 78 3D 00 00 00 78 0F 84 C7 01 00 00 89 D0 25 00 00 00 78 3D 00 00 00 78 0F 84 26 02 00 00 89 C8 25 00 00 00 60 3D 00 00 00 60 0F 84 33 02 00 00 89 CF 89 CD 81 E7 00 00 E0 7F 89 D8 81 E5 FF FF 1F 00 C1 EF 15 09 E8 0F 94 44 24 08 0F B6 44 24 08 89 7C 24 18 88 44 24 10 89 D7 81 E7 00 00 00 60 81 FF 00 00 00 60 89 D7 0F 84 85 01 00 00 89 D0 81 E7 00 00 E0 7F 25 FF FF 1F 00 C1 EF 15 89 04 24 09 F0 0F 84 9B 01 00 00 80 7C 24 10 00 0F 85 AF 01 00 00 89 D0 31 C8 0F 88 A5 01 00 00 39 7C 24 18 0F 8D 1F 02 00 00 39 7C 24 18 0F 8E 35 02 00 00 8B 54 24 18 29 FA 83 FA 0F 0F 8F 76 01 00 00 89 F8 2B 44 24 18 83 F8 0F 89 44 24 08 0F 8F 2C 02 00 00 39 7C 24 18 0F 8E 2C 02 00 00 8B 3C D5 ?? ?? ?? ?? 8B 14 D5 ?? ?? ?? ?? 89 F8 89 54 24 10 F7 E5 89 44 24 08 8B 44 24 10 89 54 24 0C F7 E5 89 44 24 20 89 F8 89 54 24 24 F7 E3 89 54 24 1C 8B 6C 24 1C 31 D2 89 44 24 18 8B 44 24 08 89 EF 31 ED 01 C7 8B 44 24 10 11 D5 F7 E3 01 C7 11 D5 8B 54 24 0C 89 D0 31 D2 89 44 24 10 8B 44 24 20 89 54 24 14 8B 54 24 24 01 44 24 10 11 54 24 14 31 D2 01 6C 24 10 11 54 24 14 8B 54 24 14 0B 54 24 10 0F 85 90 02 00 00 89 FA 8B 7C 24 18 31 C0 31 ED 89 F3 01 F8 8B 3C 24 11 EA 31 C3 31 D7 09 DF 0F 84 C9 00 00 00 3B 14 24 BB 01 00 00 00 72 0E 0F 87 27 01 00 00 39 F0 0F 83 1F 01 00 00 89 DA 89 C8 F7 D0 C1 E8 1F 31 D0 EB 0D 8D 74 26 00 83 0D ?? ?? ?? ?? 01 31 C0 8B 5C 24 2C 8B 74 24 30 8B 7C 24 34 8B 6C 24 38 83 C4 3C C3 8D 76 00 85 C9 B8 01 00 00 00 79 E0 89 D1 81 E1 00 00 00 78 81 F9 00 00 00 78 0F 84 C2 00 00 00 31 C0 EB C8 89 D0 81 E7 00 00 F8 1F 25 FF FF 07 00 0D 00 00 20 00 C1 EF 13 3D F2 86 23 00 89 04 24 77 12 0F 82 71 FE FF FF 81 FE FF FF C0 6F 0F 86 65 FE FF FF 80 7C 24 08 00 B8 01 00 00 00 75 8B 80 7C 24 10 00 75 0C 89 C8 F7 D0 C1 E8 1F E9 78 FF FF FF 89 D0 C1 E8 1F E9 6E FF FF FF 90 8D 74 26 00 B8 01 00 00 00 E9 5F FF FF FF 8D B6 00 00 00 00 89 CD 89 C8 81 E5 FF FF 07 00 25 00 00 F8 1F 81 CD 00 00 20 00 C1 E8 13 81 FD F2 86 23 00 89 44 24 18 77 1C 72 08 81 FB FF FF C0 6F 77 12 C6 44 24 10 00 C6 44 24 08 00 E9 B9 FD FF FF 8D 76 00 C6 44 24 10 01 C6 44 24 08 01 E9 A7 FD FF FF 85 D2 0F 88 02 FF FF FF 31 C0 E9 FB FE FF FF 31 DB E9 DA FE FF FF 3B 2C 24 0F 87 67 FF FF FF 66 90 0F 82 D0 FD FF FF 39 F3 0F 87 57 FF FF FF 66 90 E9 C1 FD FF FF 3B 2C 24 72 14 8D B6 00 00 00 00 0F 87 BA FD FF FF 39 F3 0F 83 B2 FD FF FF 89 C8 C1 E8 1F E9 B1 FE FF FF 8B 7C 24 08 8B 44 24 08 C7 44 24 24 00 00 00 00 8B 3C FD ?? ?? ?? ?? 89 7C 24 10 8B 3C C5 ?? ?? ?? ?? 8B 44 24 10 F7 24 24 89 44 24 18 8B 04 24 89 54 24 1C F7 E7 89 04 24 8B 44 24 10 89 54 24 04 F7 E6 89 54 24 14 8B 54 24 18 89 44 24 10 89 54 24 20 8B 54 24 14 89 D0 31 D2 89 44 24 08 8B 44 24 20 89 54 24 0C 8B 54 24 24 01 44 24 08 89 F8 11 54 24 0C F7 E6 8B 7C 24 1C 01 44 24 08 11 54 24 0C 8B 54 24 0C 89 FE 31 FF 03 34 24 13 7C 24 04 89 D0 31 D2 01 C6 11 D7 89 FA 09 F2 75 46 8B 44 24 08 31 FF 8B 74 24 10 89 C2 31 C0 01 F0 89 DE 11 FA 89 EF 31 D7 31 C6 09 F7 0F 84 86 FE FF FF 39 D5 BE 01 00 00 00 72 06 77 10 39 C3 73 0C 89 F2 90 8D 74 26 00 E9 BC FD FF FF 31 F6 89 F2 E9 B3 FD FF FF BA 01 00 00 00 E9 A9 FD FF FF 31 D2 E9 A2 FD FF FF 90 }
	condition:
		$1
}

rule file_65_14_0 {
	meta:
		name = "___bid64_signaling_greater_unordered"
		size = 1104
		refs = "013f .rdata 0212 ___bid_IDEC_glbflags"
	strings:
		$1 = { 83 EC 3C 8B 4C 24 44 89 5C 24 2C 8B 54 24 4C 89 74 24 30 8B 5C 24 40 89 7C 24 34 8B 74 24 48 89 C8 25 00 00 00 7C 3D 00 00 00 7C 89 6C 24 38 0F 84 DB 01 00 00 89 D0 25 00 00 00 7C 3D 00 00 00 7C 0F 84 C9 01 00 00 89 CF 89 D8 31 D7 31 F0 09 C7 0F 84 59 02 00 00 89 C8 25 00 00 00 78 3D 00 00 00 78 0F 84 C7 01 00 00 89 D0 25 00 00 00 78 3D 00 00 00 78 0F 84 25 02 00 00 89 C8 25 00 00 00 60 3D 00 00 00 60 0F 84 2A 02 00 00 89 CF 89 CD 81 E7 00 00 E0 7F 89 D8 81 E5 FF FF 1F 00 C1 EF 15 09 E8 0F 94 44 24 08 0F B6 44 24 08 89 7C 24 18 88 44 24 10 89 D7 81 E7 00 00 00 60 81 FF 00 00 00 60 89 D7 0F 84 84 01 00 00 89 D0 81 E7 00 00 E0 7F 25 FF FF 1F 00 C1 EF 15 89 04 24 09 F0 0F 84 9A 01 00 00 80 7C 24 10 00 0F 85 AE 01 00 00 89 D0 31 C8 0F 88 A4 01 00 00 39 7C 24 18 0F 8D 0A 02 00 00 39 7C 24 18 0F 8E 25 02 00 00 8B 54 24 18 29 FA 83 FA 0F 0F 8F 72 01 00 00 89 F8 2B 44 24 18 83 F8 0F 89 44 24 08 0F 8F 1C 02 00 00 39 7C 24 18 0F 8E 1C 02 00 00 8B 3C D5 ?? ?? ?? ?? 8B 14 D5 ?? ?? ?? ?? 89 F8 89 54 24 10 F7 E5 89 44 24 08 8B 44 24 10 89 54 24 0C F7 E5 89 44 24 20 89 F8 89 54 24 24 F7 E3 89 54 24 1C 8B 6C 24 1C 31 D2 89 44 24 18 8B 44 24 08 89 EF 31 ED 01 C7 8B 44 24 10 11 D5 F7 E3 01 C7 11 D5 8B 54 24 0C 89 D0 31 D2 89 44 24 10 8B 44 24 20 89 54 24 14 8B 54 24 24 01 44 24 10 11 54 24 14 31 D2 01 6C 24 10 11 54 24 14 8B 54 24 14 0B 54 24 10 0F 85 7D 02 00 00 89 FA 8B 7C 24 18 31 C0 31 ED 89 F3 01 F8 8B 3C 24 11 EA 31 C3 31 D7 09 DF 0F 84 C9 00 00 00 39 14 24 BB 01 00 00 00 72 0E 0F 87 0C 01 00 00 39 C6 0F 83 04 01 00 00 89 DA 89 C8 C1 E8 1F 31 D0 EB 12 8D B6 00 00 00 00 83 0D ?? ?? ?? ?? 01 B8 01 00 00 00 8B 5C 24 2C 8B 74 24 30 8B 7C 24 34 8B 6C 24 38 83 C4 3C C3 85 C9 78 7C 89 D1 B8 01 00 00 00 81 E1 00 00 00 78 C1 EA 1F 81 F9 00 00 00 78 0F 44 C2 EB CD 90 89 D0 81 E7 00 00 F8 1F 25 FF FF 07 00 0D 00 00 20 00 C1 EF 13 3D F2 86 23 00 89 04 24 77 12 0F 82 72 FE FF FF 81 FE FF FF C0 6F 0F 86 66 FE FF FF 31 C0 80 7C 24 08 00 75 92 80 7C 24 10 00 75 0F 89 C8 F7 D0 C1 E8 1F EB 82 8D B6 00 00 00 00 89 D0 C1 E8 1F E9 72 FF FF FF 8D B6 00 00 00 00 31 C0 E9 65 FF FF FF 89 CD 89 C8 81 E5 FF FF 07 00 25 00 00 F8 1F 81 CD 00 00 20 00 C1 E8 13 81 FD F2 86 23 00 89 44 24 18 77 19 72 08 81 FB FF FF C0 6F 77 0F C6 44 24 10 00 C6 44 24 08 00 E9 C2 FD FF FF C6 44 24 10 01 C6 44 24 08 01 E9 B3 FD FF FF 31 DB E9 F5 FE FF FF 8D B6 00 00 00 00 3B 2C 24 0F 87 78 FF FF FF 0F 82 E7 FD FF FF 39 F3 0F 87 6A FF FF FF 89 F6 8D BC 27 00 00 00 00 E9 D1 FD FF FF 3B 2C 24 72 14 8D B6 00 00 00 00 0F 87 CA FD FF FF 39 F3 0F 83 C2 FD FF FF 89 C8 C1 E8 1F E9 C4 FE FF FF 8B 7C 24 08 8B 44 24 08 C7 44 24 24 00 00 00 00 8B 3C FD ?? ?? ?? ?? 89 7C 24 10 8B 3C C5 ?? ?? ?? ?? 8B 44 24 10 F7 24 24 89 44 24 18 8B 04 24 89 54 24 1C F7 E7 89 04 24 8B 44 24 10 89 54 24 04 F7 E6 89 54 24 14 8B 54 24 18 89 44 24 10 89 54 24 20 8B 54 24 14 89 D0 31 D2 89 44 24 08 8B 44 24 20 89 54 24 0C 8B 54 24 24 01 44 24 08 89 F8 11 54 24 0C F7 E6 8B 7C 24 1C 01 44 24 08 11 54 24 0C 8B 54 24 0C 89 FE 31 FF 03 34 24 13 7C 24 04 89 D0 31 D2 01 C6 11 D7 89 FA 09 F2 75 46 8B 44 24 08 31 FF 8B 74 24 10 89 C2 31 C0 01 F0 89 DE 11 FA 89 EF 31 D7 31 C6 09 F7 0F 84 96 FE FF FF 39 D5 BE 01 00 00 00 77 06 72 10 39 C3 76 0C 89 F2 90 8D 74 26 00 E9 CC FD FF FF 31 F6 89 F2 E9 C3 FD FF FF 31 D2 E9 BC FD FF FF BA 01 00 00 00 E9 B2 FD FF FF 90 }
	condition:
		$1
}

rule file_65_15_0 {
	meta:
		name = "___bid64_signaling_less"
		size = 1088
		refs = "013f .rdata 0212 ___bid_IDEC_glbflags"
	strings:
		$1 = { 83 EC 3C 8B 4C 24 44 89 5C 24 2C 8B 54 24 4C 89 74 24 30 8B 5C 24 40 89 7C 24 34 8B 74 24 48 89 C8 25 00 00 00 7C 3D 00 00 00 7C 89 6C 24 38 0F 84 DB 01 00 00 89 D0 25 00 00 00 7C 3D 00 00 00 7C 0F 84 C9 01 00 00 89 CF 89 D8 31 D7 31 F0 09 C7 0F 84 49 02 00 00 89 C8 25 00 00 00 78 3D 00 00 00 78 0F 84 C7 01 00 00 89 D0 25 00 00 00 78 3D 00 00 00 78 0F 84 CD 01 00 00 89 C8 25 00 00 00 60 3D 00 00 00 60 0F 84 1A 02 00 00 89 CF 89 CD 81 E7 00 00 E0 7F 89 D8 81 E5 FF FF 1F 00 C1 EF 15 09 E8 0F 94 44 24 08 0F B6 44 24 08 89 7C 24 18 88 44 24 10 89 D7 81 E7 00 00 00 60 81 FF 00 00 00 60 89 D7 0F 84 85 01 00 00 89 D0 81 E7 00 00 E0 7F 25 FF FF 1F 00 C1 EF 15 89 04 24 09 F0 0F 84 9B 01 00 00 80 7C 24 10 00 0F 85 56 01 00 00 89 D0 31 C8 0F 88 4C 01 00 00 39 7C 24 18 0F 8D FA 01 00 00 39 7C 24 18 0F 8E 07 02 00 00 8B 54 24 18 29 FA 83 FA 0F 0F 8F 73 01 00 00 89 F8 2B 44 24 18 83 F8 0F 89 44 24 08 0F 8F 04 02 00 00 39 7C 24 18 0F 8E 06 02 00 00 8B 3C D5 ?? ?? ?? ?? 8B 14 D5 ?? ?? ?? ?? 89 F8 89 54 24 10 F7 E5 89 44 24 08 8B 44 24 10 89 54 24 0C F7 E5 89 44 24 20 89 F8 89 54 24 24 F7 E3 89 54 24 1C 8B 6C 24 1C 31 D2 89 44 24 18 8B 44 24 08 89 EF 31 ED 01 C7 8B 44 24 10 11 D5 F7 E3 01 C7 11 D5 8B 54 24 0C 89 D0 31 D2 89 44 24 10 8B 44 24 20 89 54 24 14 8B 54 24 24 01 44 24 10 11 54 24 14 31 D2 01 6C 24 10 11 54 24 14 8B 54 24 14 0B 54 24 10 0F 85 67 02 00 00 89 FA 8B 7C 24 18 31 C0 31 ED 89 F3 01 F8 8B 3C 24 11 EA 31 C3 31 D7 09 DF 0F 84 B9 00 00 00 3B 14 24 BB 01 00 00 00 72 0E 0F 87 FC 00 00 00 39 F0 0F 83 F4 00 00 00 89 DA 89 C8 C1 E8 1F 31 D0 EB 0F 8D B6 00 00 00 00 83 0D ?? ?? ?? ?? 01 31 C0 8B 5C 24 2C 8B 74 24 30 8B 7C 24 34 8B 6C 24 38 83 C4 3C C3 8D 76 00 31 C0 85 C9 79 E3 89 D1 B0 01 81 E1 00 00 00 78 81 F9 00 00 00 78 75 D1 89 D0 F7 D0 C1 E8 1F EB C8 89 D0 81 E7 00 00 F8 1F 25 FF FF 07 00 0D 00 00 20 00 C1 EF 13 3D F2 86 23 00 89 04 24 77 12 0F 82 71 FE FF FF 81 FE FF FF C0 6F 0F 86 65 FE FF FF 31 C0 80 7C 24 08 00 75 8E 80 7C 24 10 00 75 B6 89 C8 C1 E8 1F EB 80 8D B4 26 00 00 00 00 31 C0 E9 72 FF FF FF 89 CD 89 C8 81 E5 FF FF 07 00 25 00 00 F8 1F 81 CD 00 00 20 00 C1 E8 13 81 FD F2 86 23 00 89 44 24 18 77 19 72 08 81 FB FF FF C0 6F 77 0F C6 44 24 10 00 C6 44 24 08 00 E9 D2 FD FF FF C6 44 24 10 01 C6 44 24 08 01 E9 C3 FD FF FF 31 DB E9 05 FF FF FF 8D B6 00 00 00 00 3B 2C 24 77 8D 0F 82 FB FD FF FF 39 F3 8D 76 00 77 80 E9 EF FD FF FF 3B 2C 24 8D B6 00 00 00 00 72 14 0F 87 E8 FD FF FF 39 F3 8D B6 00 00 00 00 0F 83 DA FD FF FF 89 C8 F7 D0 C1 E8 1F E9 D7 FE FF FF 8B 7C 24 08 8B 44 24 08 C7 44 24 24 00 00 00 00 8B 3C FD ?? ?? ?? ?? 89 7C 24 10 8B 3C C5 ?? ?? ?? ?? 8B 44 24 10 F7 24 24 89 44 24 18 8B 04 24 89 54 24 1C F7 E7 89 04 24 8B 44 24 10 89 54 24 04 F7 E6 89 54 24 14 8B 54 24 18 89 44 24 10 89 54 24 20 8B 54 24 14 89 D0 31 D2 89 44 24 08 8B 44 24 20 89 54 24 0C 8B 54 24 24 01 44 24 08 89 F8 11 54 24 0C F7 E6 8B 7C 24 1C 01 44 24 08 11 54 24 0C 8B 54 24 0C 89 FE 31 FF 03 34 24 13 7C 24 04 89 D0 31 D2 01 C6 11 D7 89 FA 09 F2 75 43 8B 44 24 08 31 FF 8B 74 24 10 89 C2 31 C0 01 F0 89 DE 11 FA 89 EF 31 D7 31 C6 09 F7 0F 84 9C FE FF FF 39 D5 BE 01 00 00 00 72 06 77 0B 39 C3 73 07 89 F2 E9 E7 FD FF FF 31 F6 89 F2 66 90 E9 DC FD FF FF BA 01 00 00 00 E9 D2 FD FF FF 31 D2 E9 CB FD FF FF 8D 76 00 8D BC 27 00 00 00 00 }
	condition:
		$1
}

rule file_65_16_0 {
	meta:
		name = "___bid64_signaling_less_equal"
		size = 1136
		refs = "013f .rdata 0212 ___bid_IDEC_glbflags"
	strings:
		$1 = { 83 EC 3C 8B 4C 24 44 89 5C 24 2C 8B 54 24 4C 89 74 24 30 8B 5C 24 40 89 7C 24 34 8B 74 24 48 89 C8 25 00 00 00 7C 3D 00 00 00 7C 89 6C 24 38 0F 84 DB 01 00 00 89 D0 25 00 00 00 7C 3D 00 00 00 7C 0F 84 C9 01 00 00 89 CF 89 D8 31 D7 31 F0 09 C7 0F 84 59 02 00 00 89 C8 25 00 00 00 78 3D 00 00 00 78 0F 84 C7 01 00 00 89 D0 25 00 00 00 78 3D 00 00 00 78 0F 84 25 02 00 00 89 C8 25 00 00 00 60 3D 00 00 00 60 0F 84 33 02 00 00 89 CF 89 CD 81 E7 00 00 E0 7F 89 D8 81 E5 FF FF 1F 00 C1 EF 15 09 E8 0F 94 44 24 08 0F B6 44 24 08 89 7C 24 18 88 44 24 10 89 D7 81 E7 00 00 00 60 81 FF 00 00 00 60 89 D7 0F 84 84 01 00 00 89 D0 81 E7 00 00 E0 7F 25 FF FF 1F 00 C1 EF 15 89 04 24 09 F0 0F 84 9A 01 00 00 80 7C 24 10 00 0F 85 AE 01 00 00 89 D0 31 C8 0F 88 A4 01 00 00 39 7C 24 18 0F 8D 2A 02 00 00 39 7C 24 18 0F 8E 45 02 00 00 8B 54 24 18 29 FA 83 FA 0F 0F 8F 75 01 00 00 89 F8 2B 44 24 18 83 F8 0F 89 44 24 08 0F 8F 3C 02 00 00 39 7C 24 18 0F 8E 3E 02 00 00 8B 3C D5 ?? ?? ?? ?? 8B 14 D5 ?? ?? ?? ?? 89 F8 89 54 24 10 F7 E5 89 44 24 08 8B 44 24 10 89 54 24 0C F7 E5 89 44 24 20 89 F8 89 54 24 24 F7 E3 89 54 24 1C 8B 6C 24 1C 31 D2 89 44 24 18 8B 44 24 08 89 EF 31 ED 01 C7 8B 44 24 10 11 D5 F7 E3 01 C7 11 D5 8B 54 24 0C 89 D0 31 D2 89 44 24 10 8B 44 24 20 89 54 24 14 8B 54 24 24 01 44 24 10 11 54 24 14 31 D2 01 6C 24 10 11 54 24 14 8B 54 24 14 0B 54 24 10 0F 85 A0 02 00 00 89 FA 8B 7C 24 18 31 C0 31 ED 89 F3 01 F8 8B 3C 24 11 EA 31 C3 31 D7 09 DF 0F 84 C9 00 00 00 3B 14 24 BB 01 00 00 00 72 0E 0F 87 2B 01 00 00 39 F0 0F 83 23 01 00 00 89 DA 89 C8 C1 E8 1F 31 D0 EB 0F 8D B6 00 00 00 00 83 0D ?? ?? ?? ?? 01 31 C0 8B 5C 24 2C 8B 74 24 30 8B 7C 24 34 8B 6C 24 38 83 C4 3C C3 8D 76 00 85 C9 78 7C 89 D0 25 00 00 00 78 3D 00 00 00 78 0F 84 CA 00 00 00 31 C0 EB CF 8D B6 00 00 00 00 89 D0 81 E7 00 00 F8 1F 25 FF FF 07 00 0D 00 00 20 00 C1 EF 13 3D F2 86 23 00 89 04 24 77 12 0F 82 72 FE FF FF 81 FE FF FF C0 6F 0F 86 66 FE FF FF 80 7C 24 08 00 B8 01 00 00 00 75 8C 80 7C 24 10 00 75 0C 89 C8 C1 E8 1F E9 7B FF FF FF 66 90 89 D0 F7 D0 C1 E8 1F E9 6D FF FF FF 8D 74 26 00 B8 01 00 00 00 E9 5F FF FF FF 8D B6 00 00 00 00 89 CD 89 C8 81 E5 FF FF 07 00 25 00 00 F8 1F 81 CD 00 00 20 00 C1 E8 13 81 FD F2 86 23 00 89 44 24 18 77 1C 72 08 81 FB FF FF C0 6F 77 12 C6 44 24 10 00 C6 44 24 08 00 E9 B9 FD FF FF 8D 76 00 C6 44 24 10 01 C6 44 24 08 01 E9 A7 FD FF FF 90 85 D2 B8 01 00 00 00 0F 89 FC FE FF FF E9 24 FF FF FF 31 DB E9 D6 FE FF FF 8D B4 26 00 00 00 00 3B 2C 24 0F 87 5B FF FF FF 0F 82 C7 FD FF FF 39 F3 0F 87 4D FF FF FF 89 F6 8D BC 27 00 00 00 00 E9 B1 FD FF FF 3B 2C 24 72 14 8D B6 00 00 00 00 0F 87 AA FD FF FF 39 F3 0F 83 A2 FD FF FF 89 C8 F7 D0 C1 E8 1F E9 9F FE FF FF 8B 7C 24 08 8B 44 24 08 C7 44 24 24 00 00 00 00 8B 3C FD ?? ?? ?? ?? 89 7C 24 10 8B 3C C5 ?? ?? ?? ?? 8B 44 24 10 F7 24 24 89 44 24 18 8B 04 24 89 54 24 1C F7 E7 89 04 24 8B 44 24 10 89 54 24 04 F7 E6 89 54 24 14 8B 54 24 18 89 44 24 10 89 54 24 20 8B 54 24 14 89 D0 31 D2 89 44 24 08 8B 44 24 20 89 54 24 0C 8B 54 24 24 01 44 24 08 89 F8 11 54 24 0C F7 E6 8B 7C 24 1C 01 44 24 08 11 54 24 0C 8B 54 24 0C 89 FE 31 FF 03 34 24 13 7C 24 04 89 D0 31 D2 01 C6 11 D7 89 FA 09 F2 75 44 8B 44 24 08 31 FF 8B 74 24 10 89 C2 31 C0 01 F0 89 DE 11 FA 89 EF 31 D7 31 C6 09 F7 0F 84 74 FE FF FF 39 D5 BE 01 00 00 00 72 06 77 0E 39 C3 73 0A 89 F2 8D 76 00 E9 AC FD FF FF 31 F6 89 F2 E9 A3 FD FF FF BA 01 00 00 00 E9 99 FD FF FF 31 D2 E9 92 FD FF FF 90 }
	condition:
		$1
}

rule file_65_17_0 {
	meta:
		name = "___bid64_signaling_less_unordered"
		size = 1088
		refs = "013f .rdata 0212 ___bid_IDEC_glbflags"
	strings:
		$1 = { 83 EC 3C 8B 4C 24 44 89 5C 24 2C 8B 54 24 4C 89 74 24 30 8B 5C 24 40 89 7C 24 34 8B 74 24 48 89 C8 25 00 00 00 7C 3D 00 00 00 7C 89 6C 24 38 0F 84 DB 01 00 00 89 D0 25 00 00 00 7C 3D 00 00 00 7C 0F 84 C9 01 00 00 89 CF 89 D8 31 D7 31 F0 09 C7 0F 84 49 02 00 00 89 C8 25 00 00 00 78 3D 00 00 00 78 0F 84 C7 01 00 00 89 D0 25 00 00 00 78 3D 00 00 00 78 0F 84 CD 01 00 00 89 C8 25 00 00 00 60 3D 00 00 00 60 0F 84 1A 02 00 00 89 CF 89 CD 81 E7 00 00 E0 7F 89 D8 81 E5 FF FF 1F 00 C1 EF 15 09 E8 0F 94 44 24 08 0F B6 44 24 08 89 7C 24 18 88 44 24 10 89 D7 81 E7 00 00 00 60 81 FF 00 00 00 60 89 D7 0F 84 85 01 00 00 89 D0 81 E7 00 00 E0 7F 25 FF FF 1F 00 C1 EF 15 89 04 24 09 F0 0F 84 9B 01 00 00 80 7C 24 10 00 0F 85 56 01 00 00 89 D0 31 C8 0F 88 4C 01 00 00 39 7C 24 18 0F 8D FA 01 00 00 39 7C 24 18 0F 8E 0B 02 00 00 8B 54 24 18 29 FA 83 FA 0F 0F 8F 73 01 00 00 89 F8 2B 44 24 18 83 F8 0F 89 44 24 08 0F 8F 04 02 00 00 39 7C 24 18 0F 8E 06 02 00 00 8B 3C D5 ?? ?? ?? ?? 8B 14 D5 ?? ?? ?? ?? 89 F8 89 54 24 10 F7 E5 89 44 24 08 8B 44 24 10 89 54 24 0C F7 E5 89 44 24 20 89 F8 89 54 24 24 F7 E3 89 54 24 1C 8B 6C 24 1C 31 D2 89 44 24 18 8B 44 24 08 89 EF 31 ED 01 C7 8B 44 24 10 11 D5 F7 E3 01 C7 11 D5 8B 54 24 0C 89 D0 31 D2 89 44 24 10 8B 44 24 20 89 54 24 14 8B 54 24 24 01 44 24 10 11 54 24 14 31 D2 01 6C 24 10 11 54 24 14 8B 54 24 14 0B 54 24 10 0F 85 67 02 00 00 89 FA 8B 7C 24 18 31 C0 31 ED 89 F3 01 F8 8B 3C 24 11 EA 31 C3 31 D7 09 DF 0F 84 B9 00 00 00 3B 14 24 BB 01 00 00 00 72 0E 0F 87 FC 00 00 00 39 F0 0F 83 F4 00 00 00 89 DA 89 C8 C1 E8 1F 31 D0 EB 12 8D B6 00 00 00 00 83 0D ?? ?? ?? ?? 01 B8 01 00 00 00 8B 5C 24 2C 8B 74 24 30 8B 7C 24 34 8B 6C 24 38 83 C4 3C C3 31 C0 85 C9 79 E6 89 D1 B0 01 81 E1 00 00 00 78 81 F9 00 00 00 78 75 D4 89 D0 F7 D0 C1 E8 1F EB CB 89 D0 81 E7 00 00 F8 1F 25 FF FF 07 00 0D 00 00 20 00 C1 EF 13 3D F2 86 23 00 89 04 24 77 12 0F 82 71 FE FF FF 81 FE FF FF C0 6F 0F 86 65 FE FF FF 31 C0 80 7C 24 08 00 75 91 80 7C 24 10 00 75 B6 89 C8 C1 E8 1F E9 80 FF FF FF 8D 74 26 00 31 C0 E9 75 FF FF FF 89 CD 89 C8 81 E5 FF FF 07 00 25 00 00 F8 1F 81 CD 00 00 20 00 C1 E8 13 81 FD F2 86 23 00 89 44 24 18 77 19 72 08 81 FB FF FF C0 6F 77 0F C6 44 24 10 00 C6 44 24 08 00 E9 D2 FD FF FF C6 44 24 10 01 C6 44 24 08 01 E9 C3 FD FF FF 31 DB E9 05 FF FF FF 8D B6 00 00 00 00 3B 2C 24 77 8D 0F 82 FB FD FF FF 39 F3 8D 76 00 0F 87 7C FF FF FF E9 EB FD FF FF 3B 2C 24 66 90 72 14 0F 87 E8 FD FF FF 39 F3 8D B6 00 00 00 00 0F 83 DA FD FF FF 89 C8 F7 D0 C1 E8 1F E9 DA FE FF FF 8B 7C 24 08 8B 44 24 08 C7 44 24 24 00 00 00 00 8B 3C FD ?? ?? ?? ?? 89 7C 24 10 8B 3C C5 ?? ?? ?? ?? 8B 44 24 10 F7 24 24 89 44 24 18 8B 04 24 89 54 24 1C F7 E7 89 04 24 8B 44 24 10 89 54 24 04 F7 E6 89 54 24 14 8B 54 24 18 89 44 24 10 89 54 24 20 8B 54 24 14 89 D0 31 D2 89 44 24 08 8B 44 24 20 89 54 24 0C 8B 54 24 24 01 44 24 08 89 F8 11 54 24 0C F7 E6 8B 7C 24 1C 01 44 24 08 11 54 24 0C 8B 54 24 0C 89 FE 31 FF 03 34 24 13 7C 24 04 89 D0 31 D2 01 C6 11 D7 89 FA 09 F2 75 43 8B 44 24 08 31 FF 8B 74 24 10 89 C2 31 C0 01 F0 89 DE 11 FA 89 EF 31 D7 31 C6 09 F7 0F 84 9C FE FF FF 39 D5 BE 01 00 00 00 72 06 77 0B 39 C3 73 07 89 F2 E9 E7 FD FF FF 31 F6 89 F2 66 90 E9 DC FD FF FF BA 01 00 00 00 E9 D2 FD FF FF 31 D2 E9 CB FD FF FF 8D 76 00 8D BC 27 00 00 00 00 }
	condition:
		$1
}

rule file_65_18_0 {
	meta:
		name = "___bid64_signaling_not_greater"
		size = 1136
		refs = "013f .rdata 0212 ___bid_IDEC_glbflags"
	strings:
		$1 = { 83 EC 3C 8B 4C 24 44 89 5C 24 2C 8B 54 24 4C 89 74 24 30 8B 5C 24 40 89 7C 24 34 8B 74 24 48 89 C8 25 00 00 00 7C 3D 00 00 00 7C 89 6C 24 38 0F 84 DB 01 00 00 89 D0 25 00 00 00 7C 3D 00 00 00 7C 0F 84 C9 01 00 00 89 CF 89 D8 31 D7 31 F0 09 C7 0F 84 59 02 00 00 89 C8 25 00 00 00 78 3D 00 00 00 78 0F 84 C7 01 00 00 89 D0 25 00 00 00 78 3D 00 00 00 78 0F 84 25 02 00 00 89 C8 25 00 00 00 60 3D 00 00 00 60 0F 84 33 02 00 00 89 CF 89 CD 81 E7 00 00 E0 7F 89 D8 81 E5 FF FF 1F 00 C1 EF 15 09 E8 0F 94 44 24 08 0F B6 44 24 08 89 7C 24 18 88 44 24 10 89 D7 81 E7 00 00 00 60 81 FF 00 00 00 60 89 D7 0F 84 84 01 00 00 89 D0 81 E7 00 00 E0 7F 25 FF FF 1F 00 C1 EF 15 89 04 24 09 F0 0F 84 9A 01 00 00 80 7C 24 10 00 0F 85 AE 01 00 00 89 D0 31 C8 0F 88 A4 01 00 00 39 7C 24 18 0F 8D 2A 02 00 00 39 7C 24 18 0F 8E 45 02 00 00 8B 54 24 18 29 FA 83 FA 0F 0F 8F 75 01 00 00 89 F8 2B 44 24 18 83 F8 0F 89 44 24 08 0F 8F 3C 02 00 00 39 7C 24 18 0F 8E 3E 02 00 00 8B 3C D5 ?? ?? ?? ?? 8B 14 D5 ?? ?? ?? ?? 89 F8 89 54 24 10 F7 E5 89 44 24 08 8B 44 24 10 89 54 24 0C F7 E5 89 44 24 20 89 F8 89 54 24 24 F7 E3 89 54 24 1C 8B 6C 24 1C 31 D2 89 44 24 18 8B 44 24 08 89 EF 31 ED 01 C7 8B 44 24 10 11 D5 F7 E3 01 C7 11 D5 8B 54 24 0C 89 D0 31 D2 89 44 24 10 8B 44 24 20 89 54 24 14 8B 54 24 24 01 44 24 10 11 54 24 14 31 D2 01 6C 24 10 11 54 24 14 8B 54 24 14 0B 54 24 10 0F 85 A1 02 00 00 89 FA 8B 7C 24 18 31 C0 31 ED 89 F3 01 F8 8B 3C 24 11 EA 31 C3 31 D7 09 DF 0F 84 C9 00 00 00 3B 14 24 BB 01 00 00 00 72 0E 0F 87 2B 01 00 00 39 F0 0F 83 23 01 00 00 89 DA 89 C8 C1 E8 1F 31 D0 EB 12 8D B6 00 00 00 00 83 0D ?? ?? ?? ?? 01 B8 01 00 00 00 8B 5C 24 2C 8B 74 24 30 8B 7C 24 34 8B 6C 24 38 83 C4 3C C3 85 C9 78 7C 89 D0 25 00 00 00 78 3D 00 00 00 78 0F 84 CA 00 00 00 31 C0 EB D2 8D B6 00 00 00 00 89 D0 81 E7 00 00 F8 1F 25 FF FF 07 00 0D 00 00 20 00 C1 EF 13 3D F2 86 23 00 89 04 24 77 12 0F 82 72 FE FF FF 81 FE FF FF C0 6F 0F 86 66 FE FF FF 80 7C 24 08 00 B8 01 00 00 00 75 8F 80 7C 24 10 00 75 0C 89 C8 C1 E8 1F EB 81 90 8D 74 26 00 89 D0 F7 D0 C1 E8 1F E9 70 FF FF FF 8D 74 26 00 B8 01 00 00 00 E9 62 FF FF FF 8D B6 00 00 00 00 89 CD 89 C8 81 E5 FF FF 07 00 25 00 00 F8 1F 81 CD 00 00 20 00 C1 E8 13 81 FD F2 86 23 00 89 44 24 18 77 1C 72 08 81 FB FF FF C0 6F 77 12 C6 44 24 10 00 C6 44 24 08 00 E9 B9 FD FF FF 8D 76 00 C6 44 24 10 01 C6 44 24 08 01 E9 A7 FD FF FF 90 85 D2 B8 01 00 00 00 0F 89 FF FE FF FF E9 24 FF FF FF 31 DB E9 D6 FE FF FF 8D B4 26 00 00 00 00 3B 2C 24 0F 87 5B FF FF FF 0F 82 C7 FD FF FF 39 F3 0F 87 4D FF FF FF 89 F6 8D BC 27 00 00 00 00 E9 B1 FD FF FF 3B 2C 24 72 14 8D B6 00 00 00 00 0F 87 AA FD FF FF 39 F3 0F 83 A2 FD FF FF 89 C8 F7 D0 C1 E8 1F E9 A2 FE FF FF 8B 7C 24 08 8B 44 24 08 C7 44 24 24 00 00 00 00 8B 3C FD ?? ?? ?? ?? 89 7C 24 10 8B 3C C5 ?? ?? ?? ?? 8B 44 24 10 F7 24 24 89 44 24 18 8B 04 24 89 54 24 1C F7 E7 89 04 24 8B 44 24 10 89 54 24 04 F7 E6 89 54 24 14 8B 54 24 18 89 44 24 10 89 54 24 20 8B 54 24 14 89 D0 31 D2 89 44 24 08 8B 44 24 20 89 54 24 0C 8B 54 24 24 01 44 24 08 89 F8 11 54 24 0C F7 E6 8B 7C 24 1C 01 44 24 08 11 54 24 0C 8B 54 24 0C 89 FE 31 FF 03 34 24 13 7C 24 04 89 D0 31 D2 01 C6 11 D7 89 FA 09 F2 0F 85 41 00 00 00 8B 44 24 08 31 FF 8B 74 24 10 89 C2 31 C0 01 F0 89 DE 11 FA 89 EF 31 D7 31 C6 09 F7 0F 84 70 FE FF FF 39 D5 BE 01 00 00 00 72 06 77 0B 39 C3 73 07 89 F2 E9 AB FD FF FF 31 F6 89 F2 E9 A2 FD FF FF BA 01 00 00 00 E9 98 FD FF FF 31 D2 E9 91 FD FF FF }
	condition:
		$1
}

rule file_65_19_0 {
	meta:
		name = "___bid64_signaling_not_less"
		size = 1120
		refs = "013f .rdata 0212 ___bid_IDEC_glbflags"
	strings:
		$1 = { 83 EC 3C 8B 4C 24 44 89 5C 24 2C 8B 54 24 4C 89 74 24 30 8B 5C 24 40 89 7C 24 34 8B 74 24 48 89 C8 25 00 00 00 7C 3D 00 00 00 7C 89 6C 24 38 0F 84 DB 01 00 00 89 D0 25 00 00 00 7C 3D 00 00 00 7C 0F 84 C9 01 00 00 89 CF 89 D8 31 D7 31 F0 09 C7 0F 84 59 02 00 00 89 C8 25 00 00 00 78 3D 00 00 00 78 0F 84 C7 01 00 00 89 D0 25 00 00 00 78 3D 00 00 00 78 0F 84 26 02 00 00 89 C8 25 00 00 00 60 3D 00 00 00 60 0F 84 33 02 00 00 89 CF 89 CD 81 E7 00 00 E0 7F 89 D8 81 E5 FF FF 1F 00 C1 EF 15 09 E8 0F 94 44 24 08 0F B6 44 24 08 89 7C 24 18 88 44 24 10 89 D7 81 E7 00 00 00 60 81 FF 00 00 00 60 89 D7 0F 84 85 01 00 00 89 D0 81 E7 00 00 E0 7F 25 FF FF 1F 00 C1 EF 15 89 04 24 09 F0 0F 84 9B 01 00 00 80 7C 24 10 00 0F 85 AF 01 00 00 89 D0 31 C8 0F 88 A5 01 00 00 39 7C 24 18 0F 8D 1F 02 00 00 39 7C 24 18 0F 8E 35 02 00 00 8B 54 24 18 29 FA 83 FA 0F 0F 8F 76 01 00 00 89 F8 2B 44 24 18 83 F8 0F 89 44 24 08 0F 8F 2C 02 00 00 39 7C 24 18 0F 8E 2C 02 00 00 8B 3C D5 ?? ?? ?? ?? 8B 14 D5 ?? ?? ?? ?? 89 F8 89 54 24 10 F7 E5 89 44 24 08 8B 44 24 10 89 54 24 0C F7 E5 89 44 24 20 89 F8 89 54 24 24 F7 E3 89 54 24 1C 8B 6C 24 1C 31 D2 89 44 24 18 8B 44 24 08 89 EF 31 ED 01 C7 8B 44 24 10 11 D5 F7 E3 01 C7 11 D5 8B 54 24 0C 89 D0 31 D2 89 44 24 10 8B 44 24 20 89 54 24 14 8B 54 24 24 01 44 24 10 11 54 24 14 31 D2 01 6C 24 10 11 54 24 14 8B 54 24 14 0B 54 24 10 0F 85 90 02 00 00 89 FA 8B 7C 24 18 31 C0 31 ED 89 F3 01 F8 8B 3C 24 11 EA 31 C3 31 D7 09 DF 0F 84 C9 00 00 00 3B 14 24 BB 01 00 00 00 72 0E 0F 87 27 01 00 00 39 F0 0F 83 1F 01 00 00 89 DA 89 C8 F7 D0 C1 E8 1F 31 D0 EB 10 8D 74 26 00 83 0D ?? ?? ?? ?? 01 B8 01 00 00 00 8B 5C 24 2C 8B 74 24 30 8B 7C 24 34 8B 6C 24 38 83 C4 3C C3 85 C9 B8 01 00 00 00 79 E3 89 D1 81 E1 00 00 00 78 81 F9 00 00 00 78 0F 84 C2 00 00 00 31 C0 EB CB 89 D0 81 E7 00 00 F8 1F 25 FF FF 07 00 0D 00 00 20 00 C1 EF 13 3D F2 86 23 00 89 04 24 77 12 0F 82 71 FE FF FF 81 FE FF FF C0 6F 0F 86 65 FE FF FF 80 7C 24 08 00 B8 01 00 00 00 75 8E 80 7C 24 10 00 75 0C 89 C8 F7 D0 C1 E8 1F E9 7B FF FF FF 89 D0 C1 E8 1F E9 71 FF FF FF 90 8D 74 26 00 B8 01 00 00 00 E9 62 FF FF FF 8D B6 00 00 00 00 89 CD 89 C8 81 E5 FF FF 07 00 25 00 00 F8 1F 81 CD 00 00 20 00 C1 E8 13 81 FD F2 86 23 00 89 44 24 18 77 1C 72 08 81 FB FF FF C0 6F 77 12 C6 44 24 10 00 C6 44 24 08 00 E9 B9 FD FF FF 8D 76 00 C6 44 24 10 01 C6 44 24 08 01 E9 A7 FD FF FF 85 D2 0F 88 05 FF FF FF 31 C0 E9 FE FE FF FF 31 DB E9 DA FE FF FF 3B 2C 24 0F 87 67 FF FF FF 66 90 0F 82 D0 FD FF FF 39 F3 0F 87 57 FF FF FF 66 90 E9 C1 FD FF FF 3B 2C 24 72 14 8D B6 00 00 00 00 0F 87 BA FD FF FF 39 F3 0F 83 B2 FD FF FF 89 C8 C1 E8 1F E9 B4 FE FF FF 8B 7C 24 08 8B 44 24 08 C7 44 24 24 00 00 00 00 8B 3C FD ?? ?? ?? ?? 89 7C 24 10 8B 3C C5 ?? ?? ?? ?? 8B 44 24 10 F7 24 24 89 44 24 18 8B 04 24 89 54 24 1C F7 E7 89 04 24 8B 44 24 10 89 54 24 04 F7 E6 89 54 24 14 8B 54 24 18 89 44 24 10 89 54 24 20 8B 54 24 14 89 D0 31 D2 89 44 24 08 8B 44 24 20 89 54 24 0C 8B 54 24 24 01 44 24 08 89 F8 11 54 24 0C F7 E6 8B 7C 24 1C 01 44 24 08 11 54 24 0C 8B 54 24 0C 89 FE 31 FF 03 34 24 13 7C 24 04 89 D0 31 D2 01 C6 11 D7 89 FA 09 F2 75 46 8B 44 24 08 31 FF 8B 74 24 10 89 C2 31 C0 01 F0 89 DE 11 FA 89 EF 31 D7 31 C6 09 F7 0F 84 86 FE FF FF 39 D5 BE 01 00 00 00 72 06 77 10 39 C3 73 0C 89 F2 90 8D 74 26 00 E9 BC FD FF FF 31 F6 89 F2 E9 B3 FD FF FF BA 01 00 00 00 E9 A9 FD FF FF 31 D2 E9 A2 FD FF FF 90 }
	condition:
		$1
}

rule file_66_1_0 {
	meta:
		name = "___bid128_isNormal"
		size = 496
		refs = "0115 ___bid_nr_digits"
	strings:
		$1 = { 83 EC 4C 8B 44 24 50 89 74 24 40 8B 74 24 5C 89 5C 24 3C 8B 54 24 58 89 7C 24 44 89 44 24 20 8B 44 24 54 89 6C 24 48 89 44 24 24 89 F0 25 00 00 00 78 3D 00 00 00 78 0F 84 73 01 00 00 8B 6C 24 24 89 F3 89 D1 8B 7C 24 20 81 E3 FF FF 01 00 89 D8 09 E8 89 44 24 08 09 FA 31 C0 0B 54 24 08 0F 84 2B 01 00 00 81 FB 09 ED 01 00 0F 87 3F 01 00 00 0F 83 2D 01 00 00 89 CA 89 D8 81 F2 C0 87 AD BE 35 09 ED 01 00 09 C2 0F 84 26 01 00 00 89 F0 25 00 00 00 60 3D 00 00 00 60 0F 84 10 01 00 00 89 DA 09 CA 75 3A 81 FD FF FF 1F 00 0F 86 11 01 00 00 89 EA 89 D0 31 D2 89 44 24 18 89 54 24 1C DF 6C 24 18 DD 5C 24 08 8B 54 24 0C 89 D0 C1 E8 14 25 FF 07 00 00 2D DE 03 00 00 EB 26 8D 76 00 89 4C 24 18 89 5C 24 1C DF 6C 24 18 DD 5C 24 08 8B 54 24 0C 89 D0 C1 E8 14 25 FF 07 00 00 2D BE 03 00 00 83 E8 01 89 44 24 08 C1 E0 05 89 44 24 04 89 C2 8B 80 ?? ?? ?? ?? 85 C0 75 56 8B 82 ?? ?? ?? ?? 8B 92 ?? ?? ?? ?? 89 54 24 14 8B 54 24 04 8B 92 ?? ?? ?? ?? 39 D3 89 54 24 04 77 31 72 06 3B 4C 24 14 77 29 8B 54 24 04 33 4C 24 14 31 DA 09 CA 75 1E 8B 54 24 08 C1 E2 05 81 C2 ?? ?? ?? ?? 3B 6A 14 72 0C 77 07 3B 7A 10 72 05 66 90 83 C0 01 81 E6 00 00 FE 7F C1 EE 11 8D 84 30 E0 E7 FF FF 3D 02 E8 FF FF 0F 9D C0 0F B6 C0 66 90 8B 5C 24 3C 8B 74 24 40 8B 7C 24 44 8B 6C 24 48 83 C4 4C C3 81 F9 C0 87 AD BE 0F 86 C7 FE FF FF 31 C0 EB DC 31 C0 81 FD 63 8E 8D 37 77 D2 E9 CB FE FF FF 89 7C 24 18 89 6C 24 1C DF 6C 24 18 DD 5C 24 08 8B 54 24 0C 89 D0 C1 E8 14 25 FF 07 00 00 2D FE 03 00 00 E9 18 FF FF FF 90 8D 74 26 00 }
	condition:
		$1
}

rule file_66_2_0 {
	meta:
		name = "___bid128_isSubnormal"
		size = 496
		refs = "0115 ___bid_nr_digits"
	strings:
		$1 = { 83 EC 4C 8B 44 24 50 89 74 24 40 8B 74 24 5C 89 5C 24 3C 8B 54 24 58 89 7C 24 44 89 44 24 20 8B 44 24 54 89 6C 24 48 89 44 24 24 89 F0 25 00 00 00 78 3D 00 00 00 78 0F 84 73 01 00 00 8B 6C 24 24 89 F3 89 D1 8B 7C 24 20 81 E3 FF FF 01 00 89 D8 09 E8 89 44 24 08 09 FA 31 C0 0B 54 24 08 0F 84 2B 01 00 00 81 FB 09 ED 01 00 0F 87 3F 01 00 00 0F 83 2D 01 00 00 89 CA 89 D8 81 F2 C0 87 AD BE 35 09 ED 01 00 09 C2 0F 84 26 01 00 00 89 F0 25 00 00 00 60 3D 00 00 00 60 0F 84 10 01 00 00 89 DA 09 CA 75 3A 81 FD FF FF 1F 00 0F 86 11 01 00 00 89 EA 89 D0 31 D2 89 44 24 18 89 54 24 1C DF 6C 24 18 DD 5C 24 08 8B 54 24 0C 89 D0 C1 E8 14 25 FF 07 00 00 2D DE 03 00 00 EB 26 8D 76 00 89 4C 24 18 89 5C 24 1C DF 6C 24 18 DD 5C 24 08 8B 54 24 0C 89 D0 C1 E8 14 25 FF 07 00 00 2D BE 03 00 00 83 E8 01 89 44 24 08 C1 E0 05 89 44 24 04 89 C2 8B 80 ?? ?? ?? ?? 85 C0 75 56 8B 82 ?? ?? ?? ?? 8B 92 ?? ?? ?? ?? 89 54 24 14 8B 54 24 04 8B 92 ?? ?? ?? ?? 39 D3 89 54 24 04 77 31 72 06 3B 4C 24 14 77 29 8B 54 24 04 33 4C 24 14 31 DA 09 CA 75 1E 8B 54 24 08 C1 E2 05 81 C2 ?? ?? ?? ?? 3B 6A 14 72 0C 77 07 3B 7A 10 72 05 66 90 83 C0 01 81 E6 00 00 FE 7F C1 EE 11 8D 84 30 E0 E7 FF FF 3D 02 E8 FF FF 0F 9C C0 0F B6 C0 66 90 8B 5C 24 3C 8B 74 24 40 8B 7C 24 44 8B 6C 24 48 83 C4 4C C3 81 F9 C0 87 AD BE 0F 86 C7 FE FF FF 31 C0 EB DC 31 C0 81 FD 63 8E 8D 37 77 D2 E9 CB FE FF FF 89 7C 24 18 89 6C 24 1C DF 6C 24 18 DD 5C 24 08 8B 54 24 0C 89 D0 C1 E8 14 25 FF 07 00 00 2D FE 03 00 00 E9 18 FF FF FF 90 8D 74 26 00 }
	condition:
		$1
}

rule file_66_3_0 {
	meta:
		name = "___bid128_isFinite"
		size = 32
	strings:
		$1 = { 83 EC 1C 8B 44 24 2C 25 00 00 00 78 3D 00 00 00 78 0F 95 C0 83 C4 1C 0F B6 C0 C3 90 8D 74 26 00 }
	condition:
		$1
}

rule file_66_4_0 {
	meta:
		name = "___bid128_isZero"
		size = 192
	strings:
		$1 = { 83 EC 2C 8B 54 24 3C 89 5C 24 1C 8B 4C 24 38 89 74 24 20 8B 5C 24 34 89 7C 24 24 8B 74 24 30 89 D0 25 00 00 00 78 3D 00 00 00 78 89 6C 24 28 74 5B 89 D0 25 FF FF 01 00 3D 09 ED 01 00 76 19 B8 01 00 00 00 8B 5C 24 1C 8B 74 24 20 8B 7C 24 24 8B 6C 24 28 83 C4 2C C3 72 08 81 F9 C0 87 AD BE 77 DD 89 C5 89 CF 81 F5 09 ED 01 00 81 F7 C0 87 AD BE 09 FD 74 1C 81 E2 00 00 00 60 81 FA 00 00 00 60 74 BB 09 C8 75 04 09 F3 74 B3 31 C0 66 90 EB B2 81 FB 63 8E 8D 37 B8 01 00 00 00 77 A5 81 E2 00 00 00 60 81 FA 00 00 00 60 74 97 31 C0 EB 93 EB 0D 90 90 90 90 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_66_5_0 {
	meta:
		name = "___bid128_isInf"
		size = 64
	strings:
		$1 = { 83 EC 1C 31 C0 8B 54 24 2C 89 D1 81 E1 00 00 00 78 81 F9 00 00 00 78 74 07 83 C4 1C C3 8D 76 00 81 E2 00 00 00 7C 31 C0 81 FA 00 00 00 7C 0F 95 C0 83 C4 1C C3 8D 74 26 00 8D BC 27 00 00 00 00 }
	condition:
		$1
}

rule file_66_6_0 {
	meta:
		name = "___bid128_isSignaling"
		size = 32
	strings:
		$1 = { 83 EC 1C 8B 44 24 2C 25 00 00 00 7E 3D 00 00 00 7E 0F 94 C0 83 C4 1C 0F B6 C0 C3 90 8D 74 26 00 }
	condition:
		$1
}

rule file_66_7_0 {
	meta:
		name = "___bid128_isCanonical"
		size = 288
	strings:
		$1 = { 83 EC 1C 8B 54 24 2C 89 5C 24 14 8B 4C 24 28 89 74 24 18 8B 5C 24 24 8B 74 24 20 89 D0 25 00 00 00 7C 3D 00 00 00 7C 74 58 89 D0 25 00 00 00 78 3D 00 00 00 78 74 69 89 D0 25 FF FF 01 00 3D 09 ED 01 00 76 0E 31 C0 8B 5C 24 14 8B 74 24 18 83 C4 1C C3 73 6B 35 09 ED 01 00 81 F1 C0 87 AD BE 09 C8 74 6C 81 E2 00 00 00 60 31 C0 8B 5C 24 14 81 FA 00 00 00 60 8B 74 24 18 0F 95 C0 83 C4 1C C3 31 C0 F7 C2 00 C0 FF 01 75 BC 81 E2 FF 3F 00 00 81 FA 4D 31 00 00 73 49 B8 01 00 00 00 EB A7 81 E2 FF FF FF 03 31 C0 09 CA 75 9B 09 DE 8B 5C 24 14 0F 94 C0 8B 74 24 18 83 C4 1C 0F B6 C0 C3 81 F9 C0 87 AD BE 0F 87 79 FF FF FF EB 87 66 90 31 C0 81 FB 63 8E 8D 37 0F 87 69 FF FF FF 66 90 EB 82 76 2C 81 F2 4D 31 00 00 81 F1 93 8D 44 C6 09 CA 0F 85 4D FF FF FF 81 FB 09 5B C1 38 B8 01 00 00 00 0F 87 3C FF FF FF E9 39 FF FF FF 66 90 81 F9 92 8D 44 C6 76 81 EB CA 8D B6 00 00 00 00 }
	condition:
		$1
}

rule file_66_8_0 {
	meta:
		name = "___bid128_isNaN"
		size = 32
	strings:
		$1 = { 83 EC 1C 8B 44 24 2C 25 00 00 00 7C 3D 00 00 00 7C 0F 94 C0 83 C4 1C 0F B6 C0 C3 90 8D 74 26 00 }
	condition:
		$1
}

rule file_66_9_0 {
	meta:
		name = "___bid128_copy"
		size = 48
	strings:
		$1 = { 83 EC 1C 8B 44 24 20 8B 54 24 24 89 10 8B 54 24 28 89 50 04 8B 54 24 2C 89 50 08 8B 54 24 30 89 50 0C 83 C4 1C C3 8D 76 00 8D BC 27 00 00 00 00 }
	condition:
		$1
}

rule file_66_10_0 {
	meta:
		name = "___bid128_negate"
		size = 48
	strings:
		$1 = { 83 EC 1C 8B 44 24 20 8B 4C 24 24 8B 54 24 30 89 08 8B 4C 24 28 81 C2 00 00 00 80 89 50 0C 89 48 04 8B 4C 24 2C 89 48 08 83 C4 1C C3 8D 74 26 00 }
	condition:
		$1
}

rule file_66_11_0 {
	meta:
		name = "___bid128_abs"
		size = 48
	strings:
		$1 = { 83 EC 1C 8B 44 24 20 8B 4C 24 24 8B 54 24 30 89 08 8B 4C 24 28 81 E2 FF FF FF 7F 89 50 0C 89 48 04 8B 4C 24 2C 89 48 08 83 C4 1C C3 8D 74 26 00 }
	condition:
		$1
}

rule file_66_12_0 {
	meta:
		name = "___bid128_copySign"
		size = 64
	strings:
		$1 = { 83 EC 2C 8B 4C 24 40 8B 54 24 50 8B 44 24 30 81 E1 FF FF FF 7F 81 E2 00 00 00 80 09 CA 8B 4C 24 34 89 50 0C 89 08 8B 4C 24 38 89 48 04 8B 4C 24 3C 89 48 08 83 C4 2C C3 90 8D B4 26 00 00 00 00 }
	condition:
		$1
}

rule file_66_13_0 {
	meta:
		name = "___bid128_class"
		size = 1824
		refs = "0103 ___bid_ten2k128 0537 ___bid_ten2k64"
	strings:
		$1 = { 81 EC 9C 00 00 00 8B 8C 24 AC 00 00 00 89 9C 24 8C 00 00 00 8B 9C 24 A8 00 00 00 89 BC 24 94 00 00 00 8B BC 24 A4 00 00 00 89 AC 24 98 00 00 00 8B AC 24 A0 00 00 00 89 C8 25 00 00 00 7C 3D 00 00 00 7C 89 B4 24 90 00 00 00 0F 84 78 04 00 00 89 C8 25 00 00 00 78 3D 00 00 00 78 0F 84 7E 04 00 00 89 CE 81 E6 FF FF 01 00 81 FE 09 ED 01 00 76 2E 89 C8 C1 F8 1F 83 C0 06 8B 9C 24 8C 00 00 00 8B B4 24 90 00 00 00 8B BC 24 94 00 00 00 8B AC 24 98 00 00 00 81 C4 9C 00 00 00 C3 8D 76 00 0F 83 4A 04 00 00 89 F2 89 D8 81 F2 09 ED 01 00 35 C0 87 AD BE 09 C2 0F 84 44 04 00 00 89 C8 25 00 00 00 60 3D 00 00 00 60 74 A7 89 F0 09 D8 75 06 89 FA 09 EA 74 9B 89 C8 C1 E8 11 25 FF 3F 00 00 83 F8 20 0F 8F 3A 04 00 00 83 F8 13 0F 8E 41 04 00 00 83 E8 14 C1 E0 04 89 44 24 10 8B 54 24 10 8B 80 ?? ?? ?? ?? C7 44 24 44 00 00 00 00 8B 92 ?? ?? ?? ?? 89 44 24 48 89 54 24 38 F7 E7 89 44 24 20 8B 44 24 38 89 54 24 24 F7 E7 89 44 24 30 8B 44 24 48 89 54 24 34 F7 E5 89 54 24 2C 8B 54 24 20 89 44 24 28 89 54 24 40 8B 54 24 2C 89 D0 31 D2 89 44 24 18 8B 44 24 40 01 44 24 18 8B 44 24 38 89 54 24 1C 8B 54 24 44 11 54 24 1C F7 E5 01 44 24 18 11 54 24 1C 8B 54 24 24 89 D0 31 D2 89 44 24 20 8B 44 24 30 01 44 24 20 89 54 24 24 8B 54 24 34 11 54 24 24 8B 54 24 1C C7 44 24 6C 00 00 00 00 89 D0 31 D2 01 44 24 20 11 54 24 24 8B 44 24 10 8B 54 24 10 8B 80 ?? ?? ?? ?? 8B 92 ?? ?? ?? ?? 89 44 24 5C 89 D0 89 54 24 30 F7 E7 89 44 24 10 8B 44 24 5C 89 54 24 14 F7 E7 89 44 24 40 8B 44 24 30 89 54 24 44 F7 E5 89 54 24 64 8B 54 24 10 89 44 24 60 89 54 24 68 8B 54 24 64 89 D0 31 D2 89 44 24 50 89 54 24 54 8B 44 24 68 01 44 24 50 8B 44 24 5C 8B 54 24 6C 11 54 24 54 F7 E5 8B 6C 24 14 01 44 24 50 11 54 24 54 8B 54 24 54 89 EF 31 ED 03 7C 24 40 13 6C 24 44 89 D0 31 D2 01 C7 8B 44 24 18 11 D5 89 C2 B8 00 00 00 00 89 44 24 18 8B 44 24 28 89 54 24 1C 31 D2 01 44 24 18 11 54 24 1C 01 7C 24 18 11 6C 24 1C 3B 6C 24 1C 72 12 77 06 3B 7C 24 18 76 0A 83 44 24 20 01 83 54 24 24 00 8B 44 24 48 31 ED F7 E6 89 44 24 28 8B 44 24 38 89 54 24 2C 8B 7C 24 28 F7 E6 89 44 24 10 8B 44 24 48 89 54 24 14 F7 E3 89 44 24 48 89 D0 89 44 24 40 8B 44 24 38 89 54 24 4C 31 D2 89 54 24 44 F7 E3 01 44 24 40 11 54 24 44 8B 54 24 2C 01 7C 24 40 11 6C 24 44 89 D0 31 D2 89 44 24 28 8B 44 24 10 01 44 24 28 89 54 24 2C 8B 54 24 14 11 54 24 2C 8B 54 24 44 89 D0 31 D2 01 44 24 28 8B 44 24 30 11 54 24 2C C7 44 24 3C 00 00 00 00 F7 E6 89 44 24 10 8B 44 24 5C 89 54 24 14 F7 E6 89 44 24 68 8B 44 24 30 89 54 24 6C F7 E3 89 54 24 34 8B 54 24 10 89 44 24 30 8B 44 24 5C 8B 7C 24 34 89 54 24 38 F7 E3 89 FE 31 FF 01 C6 11 D7 8B 54 24 14 03 74 24 38 13 7C 24 3C 89 D0 31 D2 89 44 24 10 8B 44 24 68 01 44 24 10 89 54 24 14 8B 54 24 6C 11 54 24 14 31 D2 01 7C 24 10 11 54 24 14 31 C0 31 D2 89 44 24 38 8B 44 24 30 01 44 24 38 8B 44 24 40 89 74 24 3C 8B 74 24 48 11 54 24 3C 31 FF 89 C2 31 C0 01 F0 11 FA 03 44 24 10 13 54 24 14 39 54 24 14 72 12 77 06 39 44 24 10 76 0A 83 44 24 28 01 83 54 24 2C 00 8B 5C 24 18 BF 01 00 00 00 8B 74 24 1C 03 5C 24 38 13 74 24 3C 31 ED 39 74 24 3C 89 5C 24 18 89 74 24 1C 77 0C 72 06 39 5C 24 38 77 04 31 FF 31 ED 8B 5C 24 20 01 F8 8B 74 24 24 11 EA 01 C3 11 D6 39 F2 89 5C 24 20 89 74 24 24 0F 87 E5 02 00 00 72 08 39 D8 0F 87 DB 02 00 00 31 F6 39 D5 BB 01 00 00 00 77 0A 72 04 39 C7 77 04 31 DB 31 F6 89 F7 89 DE 03 74 24 28 13 7C 24 2C 89 F8 09 F0 0F 85 CC 00 00 00 8B 54 24 24 0B 54 24 20 0F 85 BE 00 00 00 81 7C 24 1C 4D 31 00 00 72 41 77 0A 81 7C 24 18 92 8D 44 C6 76 35 8B 54 24 1C 8B 44 24 18 81 F2 4D 31 00 00 35 93 8D 44 C6 09 C2 0F 85 8D 00 00 00 8B 44 24 50 31 FF 8B 74 24 60 89 C2 31 C0 01 F0 11 FA 81 FA 09 5B C1 38 77 73 85 C9 B8 07 00 00 00 0F 89 BC FB FF FF B8 04 00 00 00 E9 B2 FB FF FF 81 E1 00 00 00 7E 31 C0 81 F9 00 00 00 7E 0F 95 C0 E9 9C FB FF FF 66 90 89 C8 C1 F8 1F 83 E0 F9 83 C0 09 E9 8A FB FF FF 81 FB C0 87 AD BE 0F 87 76 FB FF FF E9 A5 FB FF FF 81 FF 63 8E 8D 37 0F 87 65 FB FF FF 89 C8 25 00 00 00 60 3D 00 00 00 60 0F 85 B8 FB FF FF E9 4E FB FF FF 89 C8 C1 F8 1F 83 E0 FB 83 C0 08 E9 46 FB FF FF 8B 14 C5 ?? ?? ?? ?? 8B 04 C5 ?? ?? ?? ?? C7 44 24 3C 00 00 00 00 89 54 24 28 89 44 24 20 F7 E3 89 44 24 10 8B 44 24 20 89 54 24 14 F7 E6 89 44 24 30 8B 44 24 28 89 54 24 34 F7 E3 89 54 24 4C 8B 54 24 10 89 44 24 48 89 54 24 38 8B 54 24 4C 89 D0 31 D2 89 44 24 18 8B 44 24 38 01 44 24 18 8B 44 24 28 89 54 24 1C 8B 54 24 3C 11 54 24 1C F7 E6 8B 74 24 14 01 44 24 18 11 54 24 1C 8B 54 24 1C 89 F3 31 F6 03 5C 24 30 13 74 24 34 89 D0 31 D2 01 C3 8B 44 24 20 11 D6 F7 E5 89 44 24 30 8B 44 24 20 89 54 24 34 C7 44 24 3C 00 00 00 00 F7 E7 89 44 24 20 8B 44 24 28 89 54 24 24 F7 E5 8B 6C 24 34 89 54 24 44 8B 54 24 30 89 44 24 40 89 54 24 38 8B 54 24 44 89 D0 31 D2 89 44 24 10 8B 44 24 38 01 44 24 10 8B 44 24 28 89 54 24 14 8B 54 24 3C 11 54 24 14 F7 E7 89 EF 01 44 24 10 11 54 24 14 31 ED 8B 54 24 14 03 7C 24 20 13 6C 24 24 89 D0 31 D2 01 C7 8B 44 24 18 11 D5 89 C2 B8 00 00 00 00 89 44 24 20 89 54 24 24 8B 54 24 48 C7 44 24 1C 00 00 00 00 89 54 24 18 8B 44 24 18 01 44 24 20 8B 54 24 1C 11 54 24 24 01 7C 24 20 11 6C 24 24 3B 6C 24 24 72 0E 77 06 3B 7C 24 20 76 06 83 C3 01 83 D6 00 89 F2 09 DA 0F 85 7D FE FF FF 81 7C 24 24 4D 31 00 00 72 45 77 0A 81 7C 24 20 92 8D 44 C6 76 39 8B 54 24 24 8B 44 24 20 81 F2 4D 31 00 00 35 93 8D 44 C6 09 C2 0F 85 4C FE FF FF 8B 44 24 10 31 FF 8B 74 24 40 89 C2 31 C0 01 F0 11 FA 81 FA 09 5B C1 38 0F 87 2E FE FF FF 85 C9 0F 88 C0 FD FF FF B8 07 00 00 00 E9 72 F9 FF FF BE 01 00 00 00 31 FF E9 32 FD FF FF 8D B6 00 00 00 00 8D BF 00 00 00 00 }
	condition:
		$1
}

rule file_66_14_0 {
	meta:
		name = "___bid128_sameQuantum"
		size = 288
	strings:
		$1 = { 83 EC 2C 8B 44 24 38 89 5C 24 20 89 7C 24 28 89 74 24 24 89 44 24 18 8B 44 24 3C 8B 4C 24 18 89 44 24 1C 8B 44 24 48 8B 5C 24 1C 89 44 24 08 8B 44 24 4C 8B 74 24 08 89 44 24 0C 8B 7C 24 0C 89 D8 25 00 00 00 7C 89 FA 81 E2 00 00 00 7C 3D 00 00 00 7C B8 00 00 00 00 0F 84 A2 00 00 00 81 FA 00 00 00 7C 74 53 89 DA 81 E2 00 00 00 78 81 FA 00 00 00 78 89 FA 74 58 81 E2 00 00 00 78 81 FA 00 00 00 78 74 33 89 D8 89 DA 25 00 00 00 60 81 E2 00 00 FE 7F 3D 00 00 00 60 74 56 89 F8 25 00 00 00 60 3D 00 00 00 60 74 3B 89 F8 25 00 00 FE 7F 39 C2 0F 94 C0 0F B6 C0 8B 5C 24 20 8B 74 24 24 8B 7C 24 28 83 C4 2C C3 8D B4 26 00 00 00 00 81 E2 00 00 00 78 81 FA 00 00 00 78 75 DB B8 01 00 00 00 EB D4 0F A4 F7 02 89 F8 25 00 00 FE 7F EB BF 0F A4 CB 02 89 DA 81 E2 00 00 FE 7F EB 9C 81 FA 00 00 00 7C 74 D6 8B 5C 24 20 8B 74 24 24 8B 7C 24 28 83 C4 2C C3 90 8D B4 26 00 00 00 00 }
	condition:
		$1
}

rule file_66_15_0 {
	meta:
		name = "___bid128_totalOrder"
		size = 5024
		refs = "0237 ___bid_ten2k128 0f18 ___bid_ten2k64"
	strings:
		$1 = { 81 EC CC 00 00 00 8B 8C 24 D0 00 00 00 89 9C 24 BC 00 00 00 8B 9C 24 E0 00 00 00 89 AC 24 C8 00 00 00 8B AC 24 E4 00 00 00 89 B4 24 C0 00 00 00 8B 94 24 EC 00 00 00 89 4C 24 20 8B 8C 24 DC 00 00 00 89 BC 24 C4 00 00 00 8B B4 24 D4 00 00 00 89 6C 24 18 8B BC 24 D8 00 00 00 89 5C 24 28 8B AC 24 E8 00 00 00 89 C8 25 00 00 00 7C 3D 00 00 00 7C 0F 84 A8 05 00 00 89 D0 25 00 00 00 7C 3D 00 00 00 7C 0F 84 87 05 00 00 89 D3 89 E8 31 CB 31 F8 09 C3 0F 84 4B 06 00 00 89 CB 89 D0 C1 EB 1F C1 E8 1F 38 D8 88 5C 24 08 0F 85 30 05 00 00 89 C8 25 00 00 00 78 3D 00 00 00 78 0F 84 CE 06 00 00 89 D0 25 00 00 00 78 3D 00 00 00 78 0F 84 3D 05 00 00 89 CB 89 C8 81 E3 FF FF 01 00 C1 E8 11 25 FF 3F 00 00 81 FB 09 ED 01 00 89 5C 24 38 89 44 24 10 0F 87 66 06 00 00 0F 83 50 06 00 00 8B 5C 24 38 89 F8 35 C0 87 AD BE 81 F3 09 ED 01 00 09 C3 0F 84 07 0D 00 00 89 C8 25 00 00 00 60 3D 00 00 00 60 0F 84 4C 06 00 00 8B 5C 24 38 C6 44 24 58 00 09 FB 0F 84 E4 07 00 00 8D 74 26 00 89 D0 89 D3 C1 E8 11 81 E3 FF FF 01 00 25 FF 3F 00 00 81 FB 09 ED 01 00 89 44 24 40 89 5C 24 30 0F 87 AB 05 00 00 0F 83 99 05 00 00 8B 5C 24 30 81 F3 09 ED 01 00 89 5C 24 48 89 EB 81 F3 C0 87 AD BE 89 5C 24 50 8B 5C 24 48 0B 5C 24 50 0F 84 C1 0B 00 00 89 D3 81 E3 00 00 00 60 81 FB 00 00 00 60 0F 84 CF 0B 00 00 8B 5C 24 30 09 EB 75 0E 8B 5C 24 18 0B 5C 24 28 0F 84 65 05 00 00 80 7C 24 58 00 0F 85 48 04 00 00 8B 5C 24 30 39 5C 24 38 0F 87 71 0C 00 00 72 08 39 EF 0F 87 67 0C 00 00 8B 5C 24 38 89 FA 33 5C 24 30 31 EA 09 D3 0F 84 D9 0C 00 00 8B 5C 24 30 39 5C 24 38 72 0E 0F 87 69 07 00 00 39 EF 0F 83 61 07 00 00 39 44 24 10 0F 8E 49 0C 00 00 8B 4C 24 10 29 C1 83 F9 21 0F 8F 6F 0B 00 00 83 F9 13 0F 8E E6 0C 00 00 83 E9 14 C1 E1 04 8B 99 ?? ?? ?? ?? C7 44 24 64 00 00 00 00 89 5C 24 50 8B 44 24 50 8B 99 ?? ?? ?? ?? F7 E6 89 5C 24 70 89 44 24 40 89 D8 89 54 24 44 F7 E6 89 44 24 58 8B 44 24 50 89 54 24 5C F7 64 24 20 89 54 24 4C 8B 54 24 40 89 44 24 48 89 54 24 60 8B 54 24 4C 89 D0 31 D2 89 44 24 10 8B 44 24 60 01 44 24 10 89 D8 89 54 24 14 8B 54 24 64 11 54 24 14 F7 64 24 20 01 44 24 10 11 54 24 14 8B 54 24 44 89 D0 31 D2 89 44 24 40 8B 44 24 58 01 44 24 40 8B 99 ?? ?? ?? ?? 89 54 24 44 8B 54 24 5C 11 54 24 44 8B 54 24 14 8B 89 ?? ?? ?? ?? 89 5C 24 58 89 D0 31 D2 01 44 24 40 89 D8 11 54 24 44 F7 E6 89 4C 24 78 89 44 24 60 89 C8 89 54 24 64 F7 E6 89 84 24 88 00 00 00 89 D8 89 94 24 8C 00 00 00 F7 64 24 20 89 94 24 84 00 00 00 8B 9C 24 84 00 00 00 31 D2 89 84 24 80 00 00 00 8B 44 24 60 89 D9 31 DB 89 4C 24 68 01 44 24 68 8B 44 24 78 89 5C 24 6C 11 54 24 6C F7 64 24 20 01 44 24 68 8B 5C 24 64 11 54 24 6C 8B 54 24 6C 89 D9 31 DB 03 8C 24 88 00 00 00 89 D0 13 9C 24 8C 00 00 00 31 D2 01 C1 8B 44 24 10 11 D3 89 C2 31 C0 89 44 24 10 8B 44 24 48 89 54 24 14 31 D2 01 44 24 10 11 54 24 14 01 4C 24 10 11 5C 24 14 3B 5C 24 14 72 12 77 06 3B 4C 24 10 76 0A 83 44 24 40 01 83 54 24 44 00 8B 44 24 38 31 DB F7 64 24 50 89 44 24 48 8B 44 24 38 89 54 24 4C 8B 4C 24 48 F7 64 24 70 89 44 24 20 8B 44 24 50 89 54 24 24 8B 74 24 24 F7 E7 89 44 24 50 89 D0 89 44 24 60 8B 44 24 70 89 54 24 54 31 D2 89 54 24 64 F7 E7 01 44 24 60 11 54 24 64 01 4C 24 60 11 5C 24 64 8B 5C 24 4C 89 D9 31 DB 89 5C 24 4C 8B 5C 24 20 89 4C 24 48 01 5C 24 48 11 74 24 4C 8B 54 24 64 C7 44 24 74 00 00 00 00 89 D0 31 D2 01 44 24 48 8B 44 24 38 11 54 24 4C F7 64 24 58 89 44 24 20 8B 44 24 38 89 54 24 24 F7 64 24 78 89 44 24 38 8B 44 24 58 89 54 24 3C F7 E7 89 54 24 5C 8B 54 24 20 89 44 24 58 8B 44 24 78 8B 5C 24 5C 89 54 24 70 F7 E7 89 D9 31 DB 01 C1 11 D3 8B 54 24 24 03 4C 24 70 13 5C 24 74 89 D0 31 D2 89 44 24 20 8B 44 24 38 01 44 24 20 89 54 24 24 8B 54 24 3C 11 54 24 24 31 D2 8B 44 24 58 01 5C 24 20 89 CB 11 54 24 24 31 C9 8B 74 24 60 31 D2 01 C1 8B 44 24 50 11 D3 31 D2 89 F7 31 F6 01 C6 11 D7 03 74 24 20 13 7C 24 24 39 7C 24 24 72 12 77 06 39 74 24 20 76 0A 83 44 24 48 01 83 54 24 4C 00 8B 44 24 10 8B 54 24 14 01 C8 11 DA 89 54 24 14 31 D2 3B 5C 24 14 89 44 24 10 B8 01 00 00 00 77 0C 72 06 3B 4C 24 10 77 04 31 C0 31 D2 8B 4C 24 40 01 C6 8B 5C 24 44 11 D7 01 F1 11 FB 39 DF 0F 87 12 0D 00 00 72 08 39 CE 0F 87 08 0D 00 00 39 FA C7 44 24 20 01 00 00 00 C7 44 24 24 00 00 00 00 77 16 72 04 39 F0 77 10 C7 44 24 20 00 00 00 00 C7 44 24 24 00 00 00 00 8B 44 24 20 8B 54 24 24 03 44 24 48 13 54 24 4C 89 D6 09 C6 75 43 89 D8 09 C8 75 3D 8B 44 24 68 31 DB 8B 8C 24 80 00 00 00 89 C2 31 C0 01 C8 8B 4C 24 14 11 DA 39 4C 24 30 0F 84 5E 0D 00 00 8B 5C 24 14 39 5C 24 30 72 10 0F 87 82 07 00 00 3B 6C 24 10 0F 87 78 07 00 00 31 D2 0F B6 44 24 08 31 D0 EB 06 8D 76 00 0F B6 C3 8B 9C 24 BC 00 00 00 8B B4 24 C0 00 00 00 8B BC 24 C4 00 00 00 8B AC 24 C8 00 00 00 81 C4 CC 00 00 00 C3 80 7C 24 58 00 0F 84 84 07 00 00 89 D0 F7 D0 C1 E8 1F EB C9 8D B6 00 00 00 00 89 D3 81 E3 00 00 00 7C 85 C9 0F 88 87 01 00 00 31 C0 81 FB 00 00 00 7C 75 A9 85 D2 78 A5 89 CB 81 E3 FF 3F 00 00 89 6C 24 10 89 D5 81 E5 FF 3F 00 00 81 FB 4D 31 00 00 89 7C 24 08 89 5C 24 0C 89 6C 24 14 0F 86 7B 02 00 00 31 FF 31 ED C7 44 24 08 00 00 00 00 C7 44 24 0C 00 00 00 00 81 7C 24 14 4D 31 00 00 0F 86 14 07 00 00 81 E1 00 00 00 7E 81 F9 00 00 00 7E 0F 94 C0 81 E2 00 00 00 7E 81 FA 00 00 00 7E 0F 95 C2 38 C2 0F 84 FD 00 00 00 C7 44 24 10 00 00 00 00 31 C0 31 D2 C7 44 24 14 00 00 00 00 8B 4C 24 14 8B 74 24 10 33 4C 24 0C 33 74 24 08 09 F1 0F 84 52 02 00 00 31 C0 E9 FE FE FF FF 8B 5C 24 18 8B 44 24 28 33 44 24 20 31 F3 09 C3 0F 85 9F F9 FF FF B8 01 00 00 00 E9 DE FE FF FF 81 FD C0 87 AD BE 0F 86 5B FA FF FF 89 D0 25 00 00 00 60 3D 00 00 00 60 0F 84 54 06 00 00 80 7C 24 58 00 0F 84 D8 FE FF FF 8B 6C 24 40 B8 01 00 00 00 39 6C 24 10 0F 84 A2 FE FF FF 0F 9E C0 32 44 24 08 0F B6 C0 E9 93 FE FF FF 81 FF C0 87 AD BE 0F 86 A4 F9 FF FF 8D 74 26 00 89 C8 25 00 00 00 60 3D 00 00 00 60 C6 44 24 58 01 0F 85 C9 F9 FF FF 89 C8 C1 E8 0F 25 FF 3F 00 00 89 44 24 10 C6 44 24 58 01 E9 B1 F9 FF FF 90 80 7C 24 08 00 B8 01 00 00 00 0F 85 43 FE FF FF 81 E2 00 00 00 78 81 FA 00 00 00 78 0F 94 C0 0F B6 C0 E9 2C FE FF FF 81 FB 00 00 00 7C B8 01 00 00 00 0F 85 1B FE FF FF 85 D2 0F 89 13 FE FF FF 89 C8 89 D3 25 FF 3F 00 00 81 E3 FF 3F 00 00 3D 4D 31 00 00 89 7C 24 08 89 44 24 0C 89 6C 24 10 89 5C 24 14 0F 87 A2 06 00 00 72 0C 81 FF 93 8D 44 C6 0F 87 94 06 00 00 8B 5C 24 0C 8B 44 24 08 81 F3 4D 31 00 00 35 93 8D 44 C6 09 C3 0F 84 6D 06 00 00 8B 7C 24 20 89 F5 81 7C 24 14 4D 31 00 00 0F 87 7E 06 00 00 72 0E 81 7C 24 10 93 8D 44 C6 0F 87 6E 06 00 00 8B 5C 24 14 8B 44 24 10 81 F3 4D 31 00 00 35 93 8D 44 C6 09 C3 0F 84 01 0A 00 00 8B 5C 24 28 8B 74 24 18 81 E1 00 00 00 7E 81 E2 00 00 00 7E 81 F9 00 00 00 7E 0F 94 C1 81 FA 00 00 00 7E 0F 95 C0 38 C1 0F 84 75 06 00 00 8B 44 24 0C 39 44 24 14 0F 82 5D FE FF FF 77 0E 8B 54 24 08 39 54 24 10 0F 82 4D FE FF FF 8B 44 24 14 8B 54 24 10 33 44 24 0C 33 54 24 08 09 D0 0F 85 18 FE FF FF 39 F5 0F 87 2D FE FF FF 0F 82 0A FE FF FF 39 DF 0F 83 1F FE FF FF 8D 74 26 00 E9 F9 FD FF FF 72 0F 81 FF 93 8D 44 C6 8D 76 00 0F 87 74 FD FF FF 8B 5C 24 0C 8B 44 24 08 81 F3 4D 31 00 00 35 93 8D 44 C6 09 C3 0F 84 5B 05 00 00 8B 7C 24 20 89 F5 E9 62 FD FF FF 8D 74 26 00 8B 5C 24 20 09 F3 0F 94 44 24 58 E9 10 F8 FF FF 39 D5 0F 82 C3 FD FF FF 0F 87 A0 FD FF FF 39 C7 0F 86 B5 FD FF FF E9 93 FD FF FF 90 8D 74 26 00 77 08 39 EF 0F 82 06 05 00 00 8B 5C 24 38 89 FA 33 5C 24 30 31 EA 09 D3 0F 84 74 05 00 00 39 44 24 10 0F 8F 9F F8 FF FF 2B 44 24 10 83 F8 21 0F 8F DB 04 00 00 83 F8 13 0F 8E 07 07 00 00 8D 48 EC C1 E1 04 8B 99 ?? ?? ?? ?? C7 44 24 64 00 00 00 00 89 5C 24 48 8B 44 24 48 8B 99 ?? ?? ?? ?? F7 64 24 18 89 5C 24 68 89 44 24 40 89 D8 89 54 24 44 F7 64 24 18 89 44 24 50 8B 44 24 48 89 54 24 54 F7 64 24 28 89 54 24 5C 8B 54 24 40 89 44 24 58 89 54 24 60 8B 54 24 5C 89 D0 31 D2 89 44 24 10 8B 44 24 60 01 44 24 10 89 D8 89 54 24 14 8B 54 24 64 11 54 24 14 F7 64 24 28 01 44 24 10 11 54 24 14 8B 54 24 44 89 D0 31 D2 89 44 24 40 8B 44 24 50 01 44 24 40 8B 99 ?? ?? ?? ?? 89 54 24 44 8B 54 24 54 11 54 24 44 8B 54 24 14 8B 89 ?? ?? ?? ?? 89 5C 24 50 89 D0 31 D2 01 44 24 40 89 D8 11 54 24 44 F7 64 24 18 89 4C 24 70 89 44 24 78 89 C8 89 54 24 7C F7 64 24 18 89 44 24 18 89 D8 89 54 24 1C F7 64 24 28 89 94 24 84 00 00 00 8B 9C 24 84 00 00 00 31 D2 89 84 24 80 00 00 00 8B 44 24 78 89 D9 31 DB 89 4C 24 60 01 44 24 60 89 5C 24 64 11 54 24 64 8B 44 24 70 F7 64 24 28 01 44 24 60 8B 5C 24 7C 11 54 24 64 8B 54 24 64 89 D9 31 DB 03 4C 24 18 89 D0 13 5C 24 1C 31 D2 01 C1 8B 44 24 10 11 D3 89 C2 B8 00 00 00 00 89 44 24 10 8B 44 24 58 89 54 24 14 31 D2 01 44 24 10 11 54 24 14 01 4C 24 10 11 5C 24 14 3B 5C 24 14 72 12 77 06 3B 4C 24 10 76 0A 83 44 24 40 01 83 54 24 44 00 8B 44 24 30 31 DB F7 64 24 48 89 44 24 28 8B 44 24 30 89 54 24 2C 8B 4C 24 28 F7 64 24 68 89 44 24 18 8B 44 24 48 89 54 24 1C F7 E5 89 44 24 48 89 D0 89 44 24 58 8B 44 24 68 89 54 24 4C 31 D2 89 54 24 5C F7 E5 01 44 24 58 11 54 24 5C 01 4C 24 58 11 5C 24 5C 8B 5C 24 2C 89 D9 31 DB 89 4C 24 28 8B 4C 24 18 01 4C 24 28 89 5C 24 2C 8B 5C 24 1C 11 5C 24 2C 8B 54 24 5C C7 44 24 6C 00 00 00 00 89 D0 31 D2 01 44 24 28 8B 44 24 30 11 54 24 2C F7 64 24 50 89 44 24 18 8B 44 24 30 89 54 24 1C F7 64 24 70 89 44 24 30 8B 44 24 50 89 54 24 34 F7 E5 89 54 24 54 8B 54 24 18 89 44 24 50 8B 44 24 70 8B 5C 24 54 89 54 24 68 F7 E5 89 D9 31 DB 01 C1 11 D3 8B 54 24 1C 03 4C 24 68 13 5C 24 6C 89 D0 31 D2 89 44 24 18 8B 44 24 30 01 44 24 18 89 54 24 1C 8B 54 24 34 11 54 24 1C 31 D2 01 5C 24 18 11 54 24 1C 31 C0 31 D2 89 44 24 30 8B 44 24 50 89 4C 24 34 8B 4C 24 58 01 44 24 30 8B 44 24 48 11 54 24 34 31 D2 89 CB 31 C9 01 C1 11 D3 03 4C 24 18 13 5C 24 1C 39 5C 24 1C 72 12 77 06 39 4C 24 18 76 0A 83 44 24 28 01 83 54 24 2C 00 8B 44 24 10 8B 54 24 14 03 44 24 30 13 54 24 34 39 54 24 34 89 44 24 10 89 54 24 14 C7 44 24 48 01 00 00 00 C7 44 24 4C 00 00 00 00 77 18 72 06 39 44 24 30 77 10 C7 44 24 48 00 00 00 00 C7 44 24 4C 00 00 00 00 8B 44 24 40 03 4C 24 48 8B 54 24 44 13 5C 24 4C 01 C8 89 44 24 40 11 DA 39 D3 89 54 24 44 0F 87 79 05 00 00 72 08 39 C1 0F 87 6F 05 00 00 31 D2 B8 01 00 00 00 39 5C 24 4C 77 0C 72 06 39 4C 24 48 77 04 31 C0 31 D2 03 44 24 28 13 54 24 2C 89 D1 09 C1 75 47 8B 5C 24 44 0B 5C 24 40 75 3D 8B 44 24 60 31 DB 8B 8C 24 80 00 00 00 8B 6C 24 14 89 C2 31 C0 01 C8 11 DA 39 6C 24 38 0F 84 08 06 00 00 8B 44 24 14 39 44 24 38 72 10 0F 87 92 F8 FF FF 3B 7C 24 10 0F 83 88 F8 FF FF BA 01 00 00 00 90 E9 7F F8 FF FF 81 7C 24 18 63 8E 8D 37 0F 87 AE F9 FF FF 89 D3 81 E3 00 00 00 60 81 FB 00 00 00 60 0F 85 47 F4 FF FF 89 D6 C1 EE 0F 81 E6 FF 3F 00 00 89 74 24 40 E9 98 F9 FF FF 3B 44 24 28 0F 85 62 05 00 00 0F B6 44 24 08 E9 44 F8 FF FF 90 72 0E 81 7C 24 10 93 8D 44 C6 0F 87 DC F8 FF FF 8B 5C 24 14 8B 44 24 10 81 F3 4D 31 00 00 35 93 8D 44 C6 09 C3 0F 84 B2 00 00 00 81 E1 00 00 00 7E 81 F9 00 00 00 7E 0F 94 C0 81 E2 00 00 00 7E 81 FA 00 00 00 7E 0F 95 C2 38 D0 0F 84 BE F9 FF FF 8B 44 24 0C 39 44 24 14 0F 87 FC F8 FF FF 72 0E 8B 54 24 08 39 54 24 10 0F 87 EC F8 FF FF 8B 44 24 28 8B 54 24 18 E9 AA F8 FF FF 8D 74 26 00 81 FE 63 8E 8D 37 0F 87 34 F9 FF FF 89 C8 25 00 00 00 60 3D 00 00 00 60 0F 84 39 F9 FF FF C6 44 24 58 00 E9 F8 F2 FF FF 39 44 24 10 0F 8D 43 FF FF FF 8B 5C 24 30 39 5C 24 38 0F 83 F0 FA FF FF 89 C8 F7 D0 C1 E8 1F E9 77 F7 FF FF 81 FE 09 5B C1 38 0F 87 F2 F7 FF FF E9 94 FA FF FF 81 7C 24 18 09 5B C1 38 0F 87 01 F8 FF FF E9 3B FF FF FF 81 FE 09 5B C1 38 0F 86 87 F9 FF FF 31 FF 31 ED C7 44 24 08 00 00 00 00 C7 44 24 0C 00 00 00 00 E9 74 F9 FF FF 31 DB 31 F6 C7 44 24 10 00 00 00 00 C7 44 24 14 00 00 00 00 E9 9C F9 FF FF 39 74 24 18 0F 83 58 03 00 00 39 44 24 10 0F 8D B3 FE FF FF 39 74 24 18 0F 82 82 FA FF FF 0F 87 1B F3 FF FF 8B 5C 24 20 39 5C 24 28 0F 86 6E FA FF FF E9 08 F3 FF FF 31 C0 81 FA 00 00 00 7E 0F 94 C0 E9 CE F6 FF FF 8B 1C CD ?? ?? ?? ?? 8B 0C CD ?? ?? ?? ?? C7 44 24 5C 00 00 00 00 89 5C 24 60 89 C8 F7 E7 89 44 24 10 8B 44 24 38 89 54 24 14 F7 E1 89 44 24 50 89 D8 89 54 24 54 F7 E7 89 54 24 4C 8B 54 24 10 89 44 24 48 89 54 24 58 8B 54 24 4C 89 D0 31 D2 89 44 24 40 8B 44 24 58 01 44 24 40 8B 44 24 38 89 54 24 44 8B 54 24 5C 11 54 24 44 F7 E3 01 44 24 40 11 54 24 44 8B 54 24 14 89 D0 31 D2 89 44 24 10 8B 44 24 50 89 54 24 14 8B 54 24 54 01 44 24 10 11 54 24 14 8B 54 24 44 89 D0 31 D2 01 44 24 10 8B 44 24 20 11 54 24 14 F7 E1 89 44 24 50 89 C8 89 54 24 54 F7 E6 89 44 24 58 8B 44 24 20 89 54 24 5C F7 E3 89 54 24 24 8B 5C 24 24 31 D2 89 44 24 20 8B 44 24 50 89 D9 31 DB 89 4C 24 38 01 44 24 38 8B 44 24 60 89 5C 24 }
	condition:
		$1
}

rule file_66_16_0 {
	meta:
		name = "___bid128_totalOrderMag"
		size = 4432
		refs = "0209 ___bid_ten2k128 0d1f ___bid_ten2k64"
	strings:
		$1 = { 81 EC BC 00 00 00 8B 8C 24 C0 00 00 00 89 9C 24 AC 00 00 00 8B 9C 24 C4 00 00 00 89 B4 24 B0 00 00 00 8B B4 24 D0 00 00 00 89 AC 24 B8 00 00 00 8B 94 24 DC 00 00 00 89 4C 24 30 8B 8C 24 CC 00 00 00 89 5C 24 18 8B 9C 24 D4 00 00 00 89 74 24 38 8B B4 24 D8 00 00 00 89 BC 24 B4 00 00 00 8B AC 24 C8 00 00 00 89 C8 25 00 00 00 7C 3D 00 00 00 7C 89 5C 24 20 89 74 24 08 0F 84 50 05 00 00 89 D0 25 00 00 00 7C 3D 00 00 00 7C 0F 84 15 05 00 00 8B 74 24 08 89 CB 89 D0 81 E3 FF FF FF 7F 25 FF FF FF 7F 89 DF 31 C7 31 EE 09 F7 0F 84 E5 05 00 00 89 CE 81 E6 00 00 00 78 81 FE 00 00 00 78 0F 84 FD 05 00 00 89 D6 81 E6 00 00 00 78 81 FE 00 00 00 78 0F 84 CC 04 00 00 89 CE 81 E6 FF FF 01 00 89 74 24 10 89 DE C1 EE 11 81 7C 24 10 09 ED 01 00 89 74 24 28 0F 86 42 05 00 00 89 CE B9 01 00 00 00 81 E6 00 00 00 60 81 FE 00 00 00 60 0F 84 FC 05 00 00 89 D7 89 C3 81 E7 FF FF 01 00 C1 EB 11 81 FF 09 ED 01 00 89 5C 24 50 0F 87 AC 05 00 00 72 0E 81 7C 24 08 C0 87 AD BE 0F 87 9C 05 00 00 89 FE 81 F6 09 ED 01 00 89 74 24 40 8B 74 24 08 81 F6 C0 87 AD BE 89 74 24 48 8B 74 24 40 0B 74 24 48 0F 84 C4 05 00 00 81 E2 00 00 00 60 81 FA 00 00 00 60 0F 84 D2 05 00 00 8B 74 24 08 09 FE 0F 84 46 06 00 00 84 C9 B8 01 00 00 00 0F 85 15 04 00 00 39 7C 24 10 0F 87 C0 06 00 00 72 0A 3B 6C 24 08 0F 87 B4 06 00 00 8B 54 24 10 8B 44 24 08 31 FA 31 E8 09 C2 0F 84 16 0B 00 00 39 7C 24 10 72 10 0F 87 CE 06 00 00 3B 6C 24 08 0F 83 C4 06 00 00 8B 74 24 50 39 74 24 28 0F 8E C2 03 00 00 8B 4C 24 28 31 C0 2B 4C 24 50 83 F9 21 0F 8F B4 03 00 00 83 F9 13 0F 8E 8F 0C 00 00 83 E9 14 C1 E1 04 8B 99 ?? ?? ?? ?? 8B B1 ?? ?? ?? ?? 89 D8 F7 64 24 18 89 74 24 60 89 5C 24 48 89 44 24 40 89 F0 89 54 24 44 F7 64 24 18 89 44 24 50 89 D8 89 54 24 54 F7 64 24 30 89 54 24 5C 8B 74 24 5C 31 D2 89 44 24 58 8B 44 24 40 89 F3 31 F6 89 74 24 2C 8B 74 24 44 89 5C 24 28 01 44 24 28 8B 44 24 60 11 54 24 2C 89 F3 F7 64 24 30 01 44 24 28 11 54 24 2C 31 F6 89 5C 24 40 8B 5C 24 50 89 74 24 44 8B 74 24 54 01 5C 24 40 11 74 24 44 8B 54 24 2C 8B B1 ?? ?? ?? ?? 89 D0 31 D2 89 74 24 50 8B B1 ?? ?? ?? ?? 01 44 24 40 8B 44 24 50 11 54 24 44 F7 64 24 18 89 44 24 70 8B 44 24 18 89 54 24 74 F7 E6 89 44 24 18 8B 44 24 50 89 54 24 1C F7 64 24 30 89 54 24 7C 8B 5C 24 7C 31 D2 89 44 24 78 8B 44 24 70 89 D9 31 DB 89 4C 24 68 01 44 24 68 8B 44 24 30 89 5C 24 6C 11 54 24 6C F7 E6 01 44 24 68 8B 5C 24 74 11 54 24 6C 8B 54 24 6C 89 D9 31 DB 03 4C 24 18 89 D0 13 5C 24 1C 31 D2 01 C1 8B 44 24 28 11 D3 89 C2 B8 00 00 00 00 89 44 24 28 8B 44 24 58 89 54 24 2C 31 D2 01 44 24 28 11 54 24 2C 01 4C 24 28 11 5C 24 2C 3B 5C 24 2C 72 12 77 06 3B 4C 24 28 76 0A 83 44 24 40 01 83 54 24 44 00 8B 44 24 10 31 DB F7 64 24 48 89 44 24 30 8B 44 24 10 89 54 24 34 8B 4C 24 30 F7 64 24 60 89 44 24 18 8B 44 24 48 89 54 24 1C F7 E5 89 44 24 48 89 D0 89 44 24 58 8B 44 24 60 89 54 24 4C 31 D2 89 54 24 5C F7 E5 01 44 24 58 11 54 24 5C 01 4C 24 58 11 5C 24 5C 8B 5C 24 34 89 D9 31 DB 89 4C 24 30 8B 4C 24 18 01 4C 24 30 89 5C 24 34 8B 5C 24 1C 11 5C 24 34 8B 54 24 5C C7 44 24 64 00 00 00 00 89 D0 31 D2 01 44 24 30 8B 44 24 10 11 54 24 34 F7 64 24 50 89 44 24 18 8B 44 24 10 89 54 24 1C F7 E6 89 44 24 10 8B 44 24 50 89 54 24 14 F7 E5 89 54 24 54 8B 54 24 18 8B 5C 24 54 89 44 24 50 89 E8 89 54 24 60 F7 E6 89 D9 31 DB 01 C1 11 D3 8B 54 24 1C 03 4C 24 60 13 5C 24 64 89 D0 31 D2 89 44 24 18 8B 44 24 10 01 44 24 18 89 54 24 1C 8B 54 24 14 11 54 24 1C 31 D2 01 5C 24 18 11 54 24 1C 31 C0 31 D2 89 44 24 10 8B 44 24 50 89 4C 24 14 8B 4C 24 58 01 44 24 10 8B 44 24 48 11 54 24 14 31 D2 89 CB 31 C9 01 C1 11 D3 03 4C 24 18 13 5C 24 1C 39 5C 24 1C 72 12 77 06 39 4C 24 18 76 0A 83 44 24 30 01 83 54 24 34 00 8B 44 24 28 8B 54 24 2C 03 44 24 10 13 54 24 14 39 54 24 14 89 44 24 28 89 54 24 2C C7 44 24 48 01 00 00 00 C7 44 24 4C 00 00 00 00 77 18 72 06 39 44 24 10 77 10 C7 44 24 48 00 00 00 00 C7 44 24 4C 00 00 00 00 8B 44 24 40 03 4C 24 48 8B 54 24 44 13 5C 24 4C 01 C8 89 44 24 40 11 DA 39 D3 89 54 24 44 0F 87 18 0B 00 00 72 08 39 C1 0F 87 0E 0B 00 00 31 D2 B8 01 00 00 00 39 5C 24 4C 77 0C 72 06 39 4C 24 48 77 04 31 C0 31 D2 03 44 24 30 13 54 24 34 89 D1 09 C1 0F 85 03 03 00 00 8B 5C 24 44 0B 5C 24 40 0F 85 F5 02 00 00 8B 4C 24 68 31 D2 8B 44 24 78 89 CB 31 C9 01 C1 8B 44 24 08 11 D3 8B 54 24 2C 33 44 24 28 31 FA 09 C2 0F 84 31 0B 00 00 3B 7C 24 2C 77 14 0F 82 C1 02 00 00 8B 74 24 28 39 74 24 08 0F 86 B3 02 00 00 B8 01 00 00 00 8B 9C 24 AC 00 00 00 8B B4 24 B0 00 00 00 8B BC 24 B4 00 00 00 8B AC 24 B8 00 00 00 81 C4 BC 00 00 00 C3 90 89 D3 31 C0 81 E3 00 00 00 7C 81 FB 00 00 00 7C 75 CA 8B 5C 24 08 89 CF 89 D0 81 E7 FF 3F 00 00 25 FF 3F 00 00 81 FF 4D 31 00 00 89 EE 89 44 24 14 89 5C 24 10 0F 87 65 01 00 00 0F 83 52 06 00 00 89 FB 89 F0 81 F3 4D 31 00 00 35 93 8D 44 C6 09 C3 0F 84 35 01 00 00 8B 5C 24 30 89 5C 24 08 8B 5C 24 18 89 5C 24 0C E9 47 01 00 00 8D 76 00 72 0C 81 FD C0 87 AD BE 0F 87 B0 FA FF FF 8B 7C 24 10 89 EE 81 F6 C0 87 AD BE 81 F7 09 ED 01 00 09 F7 0F 84 48 06 00 00 81 E1 00 00 00 60 81 F9 00 00 00 60 0F 84 99 00 00 00 8B 5C 24 10 31 C9 09 EB 0F 85 8F FA FF FF 8B 74 24 18 0B 74 24 30 0F 94 C1 E9 7F FA FF FF 8B 7C 24 20 8B 74 24 38 33 7C 24 18 33 74 24 30 09 F7 0F 84 F7 FE FF FF 89 CE 81 E6 00 00 00 78 81 FE 00 00 00 78 0F 85 03 FA FF FF 81 E2 00 00 00 78 81 FA 00 00 00 78 0F 94 C0 0F B6 C0 E9 D1 FE FF FF 90 8D 74 26 00 81 E2 00 00 00 60 81 FA 00 00 00 60 74 62 84 C9 0F BE C1 0F 84 B3 FE FF FF 31 D2 B8 01 00 00 00 39 5C 24 28 0F 9E C2 39 5C 24 28 0F 45 C2 E9 99 FE FF FF C1 EB 0F B9 01 00 00 00 81 E3 FF 3F 00 00 89 5C 24 28 E9 ED F9 FF FF 8D B6 00 00 00 00 81 7C 24 20 63 8E 8D 37 77 A6 81 E2 00 00 00 60 81 FA 00 00 00 60 0F 85 3E FA FF FF 8D 74 26 00 89 C3 C1 EB 0F 81 E3 FF 3F 00 00 EB 91 81 7C 24 18 09 5B C1 38 0F 86 BD FE FF FF 90 8D 74 26 00 C7 44 24 08 00 00 00 00 31 F6 31 FF C7 44 24 0C 00 00 00 00 81 7C 24 14 4D 31 00 00 76 55 81 E1 00 00 00 7E 81 F9 00 00 00 7E 0F 94 C0 81 E2 00 00 00 7E 81 FA 00 00 00 7E 0F 95 C2 38 C2 0F 84 1F FF FF FF C7 44 24 10 00 00 00 00 31 C0 31 D2 C7 44 24 14 00 00 00 00 EB 7E 8D B6 00 00 00 00 8B 74 24 20 0B 74 24 38 0F 84 10 FF FF FF E9 A7 F9 FF FF 0F 83 67 04 00 00 8B 5C 24 14 8B 44 24 10 81 F3 4D 31 00 00 35 93 8D 44 C6 09 C3 0F 84 71 04 00 00 81 E1 00 00 00 7E 81 F9 00 00 00 7E 0F 94 C0 81 E2 00 00 00 7E 81 FA 00 00 00 7E 0F 95 C2 38 D0 0F 84 A9 FE FF FF 39 7C 24 14 0F 87 73 FD FF FF 72 0A 39 74 24 10 0F 87 67 FD FF FF 8B 44 24 38 8B 54 24 20 8B 4C 24 14 33 74 24 10 31 F9 09 F1 0F 84 2E 04 00 00 31 C0 E9 4B FD FF FF 8B 74 24 50 31 C0 39 74 24 28 0F 8D 3B FD FF FF 39 7C 24 10 0F 82 2C FD FF FF 77 0A 3B 6C 24 08 0F 82 20 FD FF FF 8B 54 24 10 8B 44 24 08 31 FA 31 E8 09 C2 0F 84 5A 04 00 00 8B 44 24 50 39 44 24 28 0F 8F 3C F9 FF FF 8B 74 24 50 B8 01 00 00 00 2B 74 24 28 83 FE 21 0F 8F ED FC FF FF 83 FE 13 0F 8E 54 04 00 00 8D 4E EC 8B 44 24 20 C1 E1 04 8B 99 ?? ?? ?? ?? 8B B1 ?? ?? ?? ?? F7 E3 89 74 24 58 89 5C 24 04 89 44 24 40 89 F0 89 54 24 44 F7 64 24 20 89 44 24 48 8B 44 24 38 89 54 24 4C F7 E3 89 54 24 64 8B 74 24 64 31 D2 89 44 24 60 8B 44 24 40 89 F3 31 F6 89 74 24 2C 8B 74 24 44 89 5C 24 28 01 44 24 28 8B 44 24 58 11 54 24 2C 89 F3 F7 64 24 38 01 44 24 28 11 54 24 2C 31 F6 89 5C 24 40 8B 5C 24 48 89 74 24 44 8B 74 24 4C 01 5C 24 40 8B 54 24 2C 11 74 24 44 8B B1 ?? ?? ?? ?? 8B 89 ?? ?? ?? ?? 89 D0 31 D2 01 44 24 40 8B 44 24 20 11 54 24 44 89 4C 24 68 F7 E6 89 44 24 70 89 C8 89 54 24 74 F7 64 24 20 89 44 24 20 8B 44 24 38 89 54 24 24 F7 E6 89 54 24 7C 8B 5C 24 7C 31 D2 89 44 24 78 8B 44 24 70 89 D9 31 DB 89 4C 24 50 01 44 24 50 8B 44 24 68 89 5C 24 54 11 54 24 54 F7 64 24 38 01 44 24 50 8B 5C 24 74 11 54 24 54 8B 54 24 54 89 D9 31 DB 03 4C 24 20 89 D0 13 5C 24 24 31 D2 01 C1 8B 44 24 28 11 D3 89 C2 B8 00 00 00 00 89 44 24 28 8B 44 24 60 89 54 24 2C 31 D2 01 44 24 28 11 54 24 2C 01 4C 24 28 11 5C 24 2C 3B 5C 24 2C 72 12 77 06 3B 4C 24 28 76 0A 83 44 24 40 01 83 54 24 44 00 8B 44 24 04 31 DB F7 E7 89 44 24 20 8B 44 24 58 89 54 24 24 8B 4C 24 20 F7 E7 89 44 24 70 8B 44 24 08 89 54 24 74 F7 64 24 04 89 44 24 60 89 D0 89 44 24 38 8B 44 24 08 89 54 24 64 31 D2 89 54 24 3C F7 64 24 58 01 44 24 38 11 54 24 3C 01 4C 24 38 11 5C 24 3C 8B 5C 24 24 89 D9 31 DB 89 4C 24 20 8B 4C 24 70 01 4C 24 20 89 5C 24 24 8B 5C 24 74 11 5C 24 24 8B 54 24 3C 89 D0 31 D2 01 44 24 20 89 F0 11 54 24 24 31 DB F7 E7 89 44 24 58 8B 44 24 68 89 54 24 5C F7 E7 31 FF 89 44 24 70 8B 44 24 08 89 54 24 74 F7 E6 8B 74 24 58 89 44 24 48 8B 44 24 08 89 D1 89 54 24 4C F7 64 24 68 01 C1 11 D3 01 F1 11 FB 8B 7C 24 5C 89 DA 89 D0 89 4C 24 0C 8B 4C 24 38 89 FE 31 FF 03 74 24 70 13 7C 24 74 31 D2 89 CB 01 C6 11 D7 31 C0 89 44 24 08 8B 44 24 48 31 D2 01 44 24 08 8B 44 24 60 11 54 24 0C 31 C9 31 D2 01 C1 11 D3 01 F1 11 FB 39 DF 72 10 77 04 39 CE 76 0A 83 44 24 20 01 83 54 24 24 00 8B 44 24 28 8B 54 24 2C 03 44 24 08 13 54 24 0C 89 44 24 28 B8 01 00 00 00 89 54 24 2C 8B 74 24 2C 31 D2 39 74 24 0C 77 10 72 0A 8B 74 24 28 39 74 24 08 77 04 31 C0 31 D2 8B 74 24 40 01 C1 8B 7C 24 44 11 D3 01 CE 11 DF 39 FB 0F 87 8A 04 00 00 72 08 39 F1 0F 87 80 04 00 00 39 DA C7 44 24 08 01 00 00 00 C7 44 24 0C 00 00 00 00 77 16 72 04 39 C8 77 10 C7 44 24 08 00 00 00 00 C7 44 24 0C 00 00 00 00 8B 4C 24 08 8B 5C 24 0C 03 4C 24 20 B8 01 00 00 00 13 5C 24 24 89 DA 09 CA 0F 85 B5 F9 FF FF 89 F9 09 F1 0F 85 AB F9 FF FF 8B 74 24 50 31 DB 8B 4C 24 78 8B 54 24 28 89 F7 31 F6 01 CE 8B 4C 24 10 11 DF 31 EA 33 4C 24 2C 09 D1 0F 84 BE 04 00 00 8B 5C 24 2C 39 5C 24 10 0F 82 70 F9 FF FF 0F 87 1D FC FF FF 3B 6C 24 28 0F 82 60 F9 FF FF 31 C0 E9 5E F9 FF FF 66 90 81 7C 24 10 93 8D 44 C6 0F 87 30 FB FF FF E9 86 FB FF FF 81 FD 93 8D 44 C6 0F 87 01 FB FF FF 90 E9 9C F9 FF FF 81 7C 24 20 09 5B C1 38 0F 87 0B FB FF FF E9 7C FB FF FF 39 54 24 0C 0F 82 15 F9 FF FF 0F 87 C2 FB FF FF 39 44 24 08 0F 86 05 F9 FF FF 31 C0 E9 03 F9 FF FF 8D B4 26 00 00 00 00 81 7C 24 18 63 8E 8D 37 0F 87 40 F4 FF FF 81 E1 00 00 00 60 81 F9 00 00 00 60 0F 84 43 FA FF FF 31 C9 E9 40 F4 FF FF 8B 4C 24 18 39 4C 24 20 0F 83 30 03 00 00 8B 5C 24 50 31 C0 39 5C 24 28 0F 8D B7 F8 FF FF 8B 4C 24 18 39 4C 24 20 0F 82 98 FB FF FF 0F 87 CE F4 FF FF 8B 5C 24 30 39 5C 24 38 0F 86 84 FB FF FF E9 BB F4 FF FF 8B 0C F5 ?? ?? ?? ?? 8B 44 24 08 89 4C 24 58 8B 0C F5 ?? ?? ?? ?? F7 E1 89 44 24 40 89 C8 89 54 24 44 F7 E7 89 44 24 48 8B 44 24 08 89 54 24 4C F7 64 24 58 89 54 24 0C 8B 74 24 0C 31 D2 89 44 24 08 8B 44 24 40 89 F3 31 F6 89 5C 24 28 01 44 24 28 8B 44 24 58 89 74 24 2C 11 54 24 2C F7 E7 8B 7C 24 44 01 44 24 28 11 54 24 2C 8B 54 24 2C 89 FE 31 FF 03 74 24 48 13 7C 24 4C 89 D0 31 D2 01 C6 8B 44 24 38 11 D7 F7 E1 89 44 24 48 8B 44 24 20 89 54 24 4C F7 E1 89 44 24 50 8B 44 24 38 89 54 24 54 F7 64 24 58 89 54 24 3C 8B 5C 24 3C 31 D2 89 44 24 38 8B 44 24 48 89 D9 31 DB 89 4C 24 40 01 44 24 40 8B 44 24 20 89 5C 24 44 8B 5C 24 4C 11 54 24 44 F7 64 24 58 01 44 24 40 11 54 24 44 89 D9 8B 54 24 44 31 DB 03 4C 24 50 13 5C 24 54 89 D0 31 D2 01 C1 8B 44 24 28 11 D3 89 C2 B8 00 00 00 00 89 44 24 28 8B 44 24 08 89 54 24 2C 31 D2 01 44 24 28 11 54 24 2C 01 4C 24 28 11 5C 24 2C 3B 5C 24 2C 72 0E 77 06 3B 4C 24 28 76 06 83 C6 01 83 D7 00 89 FA B8 01 00 00 00 09 F2 0F 85 4A F7 FF FF 8B 54 24 28 8B 4C 24 10 33 4C 24 2C 31 EA 09 D1 0F 84 CE 01 00 00 8B 4C 24 2C 39 4C 24 10 0F 82 21 F7 FF FF E9 AC FD FF FF 90 8D 74 26 00 8B 1C CD ?? ?? ?? ?? 8B 0C CD ?? ?? ?? ?? 89 5C 24 60 89 C8 F7 E5 89 44 24 28 8B 44 24 10 89 54 24 2C F7 E1 89 44 24 50 89 D8 89 54 24 54 F7 E5 89 54 24 4C 8B 74 24 4C 31 D2 89 44 24 48 8B 44 24 28 89 F3 31 F6 89 74 24 44 8B 74 24 2C 89 5C 24 40 01 44 24 40 8B 44 24 10 11 54 24 44 89 F3 F7 64 24 60 01 44 24 40 11 54 24 44 31 F6 89 5C 24 28 8B 5C 24 50 01 5C 24 28 89 74 24 2C 8B 74 24 54 11 74 24 2C 8B 54 24 44 8B 74 24 48 89 D0 31 D2 01 44 24 28 8B 44 24 30 11 54 24 2C F7 E1 89 44 24 50 8B 44 24 18 89 54 24 54 F7 E1 89 44 24 58 8B 44 24 30 89 54 24 5C F7 64 24 60 89 54 24 34 8B 5C 24 34 31 D2 89 44 24 30 8B 44 24 50 89 D9 31 DB 89 4C 24 10 01 44 24 10 8B 44 24 18 89 5C 24 14 8B 5C 24 54 11 54 24 14 F7 64 24 60 01 44 24 10 11 54 24 14 89 D9 8B 54 24 14 31 DB 03 4C 24 58 13 5C 24 5C 89 D0 31 D2 01 C1 8B 44 24 40 11 D3 89 74 24 18 C7 44 24 1C 00 00 00 00 89 C2 31 C0 03 44 24 18 13 54 24 1C 01 C8 11 DA 39 D3 72 10 77 04 39 C1 76 0A 83 44 24 28 01 83 54 24 2C 00 8B 4C 24 2C 0B 4C 24 28 0F 85 78 F8 FF FF 8B 4C 24 08 89 FB 31 D3 31 C1 09 CB 0F 84 91 00 00 00 39 D7 0F 87 AB F5 FF FF 0F 82 58 F8 }
	condition:
		$1
}

rule file_67_0_0 {
	meta:
		name = "___bid_adddd3"
		size = 48
		refs = "0024 ___bid64_add"
	strings:
		$1 = { 53 83 EC 18 8B 5C 24 2C 8B 44 24 20 8B 54 24 24 8B 4C 24 28 89 5C 24 0C 89 04 24 89 54 24 04 89 4C 24 08 E8 ?? ?? ?? ?? 83 C4 18 5B C3 8D 76 00 }
	condition:
		$1
}

rule file_67_1_0 {
	meta:
		name = "___bid_subdd3"
		size = 48
		refs = "0024 ___bid64_sub"
	strings:
		$1 = { 53 83 EC 18 8B 5C 24 2C 8B 44 24 20 8B 54 24 24 8B 4C 24 28 89 5C 24 0C 89 04 24 89 54 24 04 89 4C 24 08 E8 ?? ?? ?? ?? 83 C4 18 5B C3 90 90 90 }
	condition:
		$1
}

rule file_182_0_0 {
	meta:
		name = "___bid_divdd3"
		size = 48
		refs = "0024 ___bid64_div"
	strings:
		$1 = { 53 83 EC 18 8B 5C 24 2C 8B 44 24 20 8B 54 24 24 8B 4C 24 28 89 5C 24 0C 89 04 24 89 54 24 04 89 4C 24 08 E8 ?? ?? ?? ?? 83 C4 18 5B C3 90 90 90 }
	condition:
		$1
}

rule file_82_0_0 {
	meta:
		name = "___bid_muldd3"
		size = 48
		refs = "0024 ___bid64_mul"
	strings:
		$1 = { 53 83 EC 18 8B 5C 24 2C 8B 44 24 20 8B 54 24 24 8B 4C 24 28 89 5C 24 0C 89 04 24 89 54 24 04 89 4C 24 08 E8 ?? ?? ?? ?? 83 C4 18 5B C3 90 90 90 }
	condition:
		$1
}

rule file_68_0_0 {
	meta:
		name = "___multf3"
		size = 4448
		refs = "0389 .rdata"
	strings:
		$1 = { 55 57 56 53 81 EC FC 00 00 00 8B B4 24 34 01 00 00 8B 84 24 2C 01 00 00 8B AC 24 38 01 00 00 8B 94 24 20 01 00 00 89 74 24 10 8B B4 24 3C 01 00 00 8B 9C 24 24 01 00 00 8B 8C 24 28 01 00 00 89 6C 24 0C 89 C5 8B BC 24 30 01 00 00 89 74 24 04 0F B7 F0 89 44 24 5C C1 ED 10 66 89 44 24 18 C1 E8 18 C0 E8 07 D9 7C 24 4E 88 44 24 14 81 E5 FF 7F 00 00 0F B6 C0 89 54 24 50 89 5C 24 54 89 4C 24 58 89 54 24 08 89 94 24 80 00 00 00 89 9C 24 84 00 00 00 89 8C 24 88 00 00 00 89 B4 24 8C 00 00 00 89 44 24 1C 89 2C 24 0F 85 F8 00 00 00 8B 44 24 08 09 D8 09 C8 09 F0 0F 84 59 05 00 00 85 F6 0F 84 5A 0A 00 00 0F BD F6 83 F6 1F 89 74 24 18 8B 6C 24 18 8B 54 24 18 83 C5 13 83 EA 0C 89 D0 0F 49 EA C1 F8 1F C1 E8 1B 01 C2 83 E2 1F C1 FD 05 29 C2 89 14 24 0F 84 E9 09 00 00 83 FD 02 0F 8F 41 0E 00 00 8B 0C 24 8D B4 24 80 00 00 00 B8 03 00 00 00 C7 44 24 08 20 00 00 00 89 F2 29 E8 29 4C 24 08 8D 04 86 89 FE 89 D7 8B 50 FC 0F B6 4C 24 08 8B 18 D3 EA 0F B6 0C 24 D3 E3 09 DA 89 14 A8 83 E8 04 39 F8 75 E2 8B 9C 24 80 00 00 00 89 F7 8D 45 FF 89 5C 24 08 8B 54 24 08 0F B6 0C 24 D3 E2 89 94 AC 80 00 00 00 85 C0 8D B4 24 80 00 00 00 78 0C C7 04 86 00 00 00 00 83 E8 01 79 F4 8B 5C 24 18 BD 02 00 00 00 C7 04 24 11 C0 FF FF C7 44 24 08 00 00 00 00 29 1C 24 C7 44 24 18 00 00 00 00 EB 66 81 FD FF 7F 00 00 0F 84 DD 01 00 00 89 C8 81 CE 00 00 01 00 C1 E8 1D 81 ED FF 3F 00 00 C1 E6 03 09 C6 89 D8 C1 A4 24 80 00 00 00 03 C1 E8 1D C1 E1 03 C1 EA 1D 09 C8 C1 E3 03 09 DA 89 2C 24 31 ED 89 B4 24 8C 00 00 00 89 84 24 88 00 00 00 89 94 24 84 00 00 00 C7 44 24 08 00 00 00 00 C7 44 24 18 00 00 00 00 8B 74 24 10 8B 44 24 0C 8B 4C 24 04 8B 54 24 04 89 74 24 64 89 B4 24 94 00 00 00 8B 74 24 04 89 44 24 68 C1 E9 10 89 84 24 98 00 00 00 89 D3 89 54 24 6C 0F B7 D2 C1 EE 18 89 F0 C0 E8 07 81 E1 FF 7F 00 00 0F B6 F0 89 7C 24 60 89 7C 24 24 89 BC 24 90 00 00 00 89 94 24 9C 00 00 00 88 44 24 04 89 74 24 20 0F 85 DF 02 00 00 8B 5C 24 10 BE 01 00 00 00 0B 5C 24 24 0B 5C 24 0C 09 D3 0F 84 DF 00 00 00 85 D2 0F 84 E8 08 00 00 0F BD D2 83 F2 1F 89 54 24 0C 8B 5C 24 0C 8B 4C 24 0C 83 C3 13 83 E9 0C 89 CA 0F 49 D9 C1 FA 1F C1 EA 1B 01 D1 83 E1 1F C1 FB 05 29 D1 89 4C 24 10 0F 84 73 08 00 00 83 FB 02 0F 8F 5F 0C 00 00 8B 4C 24 10 8D BC 24 90 00 00 00 B8 03 00 00 00 C7 44 24 28 20 00 00 00 89 FA 29 D8 29 4C 24 28 8D 04 87 89 EF 89 D5 8B 50 FC 0F B6 4C 24 28 8B 30 D3 EA 0F B6 4C 24 10 D3 E6 09 F2 89 14 98 83 E8 04 39 E8 75 E1 8B B4 24 90 00 00 00 89 FD 8D 53 FF 89 74 24 24 8B 44 24 24 0F B6 4C 24 10 D3 E0 89 84 9C 90 00 00 00 85 D2 8D BC 24 90 00 00 00 78 10 8D 74 26 00 C7 04 97 00 00 00 00 83 EA 01 79 F4 B9 11 C0 FF FF 83 CD 02 2B 4C 24 0C 31 F6 8D B6 00 00 00 00 0F B6 44 24 04 32 44 24 14 0F B6 C0 89 44 24 0C 8B 44 24 08 09 F0 FF 24 85 ?? ?? ?? ?? 8D 76 00 09 DA 09 CA 09 F2 0F 85 54 02 00 00 C7 44 24 08 08 00 00 00 31 ED C7 44 24 18 02 00 00 00 E9 5A FE FF FF 8B 54 24 1C 89 54 24 0C 8B 84 24 80 00 00 00 8B 74 24 18 89 84 24 A0 00 00 00 8B 84 24 84 00 00 00 83 FE 02 89 84 24 A4 00 00 00 8B 84 24 88 00 00 00 89 84 24 A8 00 00 00 8B 84 24 8C 00 00 00 89 84 24 AC 00 00 00 0F 84 39 01 00 00 83 FE 03 0F 84 1C 0D 00 00 83 FE 01 0F 84 1E 06 00 00 8B 7C 24 38 81 C7 FF 3F 00 00 85 FF 0F 8E EC 08 00 00 8B 84 24 A0 00 00 00 89 E9 0F B7 5C 24 4E 83 C9 20 89 C2 83 E2 07 0F 45 E9 66 81 E3 00 0C 66 81 FB 00 04 0F 84 59 0A 00 00 66 81 FB 00 08 0F 84 28 0A 00 00 66 85 DB 0F 84 F5 07 00 00 8B 84 24 AC 00 00 00 A9 00 00 10 00 74 16 8B 7C 24 38 25 FF FF EF FF 89 84 24 AC 00 00 00 81 C7 00 40 00 00 8D 84 24 A0 00 00 00 8D B4 24 AC 00 00 00 8B 08 8B 50 04 C1 E9 03 C1 E2 1D 09 CA 89 10 83 C0 04 39 F0 75 EA 8B 84 24 AC 00 00 00 C1 E8 03 81 FF FE 7F 00 00 0F 8F F1 06 00 00 89 C6 0F B6 44 24 0C 66 81 E7 FF 7F 8B 94 24 A0 00 00 00 8B 9C 24 A4 00 00 00 8B 8C 24 A8 00 00 00 83 E0 01 88 44 24 14 E9 5C 01 00 00 8D 74 26 00 8B 5C 24 20 89 5C 24 0C 8B 84 24 90 00 00 00 83 FE 02 89 84 24 A0 00 00 00 8B 84 24 94 00 00 00 89 84 24 A4 00 00 00 8B 84 24 98 00 00 00 89 84 24 A8 00 00 00 8B 84 24 9C 00 00 00 89 84 24 AC 00 00 00 0F 85 C7 FE FF FF 0F B6 54 24 0C BF FF 7F 00 00 31 F6 31 C9 31 DB 83 E2 01 88 54 24 14 31 D2 E9 F1 00 00 00 81 F9 FF 7F 00 00 74 61 8B 44 24 0C 81 CA 00 00 01 00 81 E9 FF 3F 00 00 C1 E2 03 31 F6 C1 A4 24 90 00 00 00 03 C1 E8 1D 09 C2 8B 44 24 10 89 94 24 9C 00 00 00 8B 54 24 0C C1 E8 1D C1 E2 03 09 D0 8B 54 24 10 89 84 24 98 00 00 00 89 F8 C1 E8 1D C1 E2 03 09 D0 89 84 24 94 00 00 00 E9 B7 FD FF FF 8D B4 26 00 00 00 00 8B 44 24 10 BE 02 00 00 00 09 F8 0B 44 24 0C 09 D0 0F 84 99 FD FF FF 89 E8 66 BE 03 00 83 C8 01 66 85 DB 0F 49 E8 E9 85 FD FF FF 90 8D 74 26 00 0F B7 6C 24 18 C7 44 24 08 0C 00 00 00 C7 44 24 18 03 00 00 00 66 81 E5 00 80 66 83 FD 01 19 ED 83 E5 01 E9 F5 FB FF FF C7 44 24 08 04 00 00 00 31 ED C7 44 24 18 01 00 00 00 E9 DE FB FF FF 90 83 CD 01 BE 00 80 FF FF C6 44 24 14 01 31 C9 31 DB 31 D2 BF FF 7F 00 00 66 89 74 24 7C 0F B7 74 24 7E 66 81 E7 FF 7F 0F B6 44 24 14 89 54 24 70 89 5C 24 74 66 81 E6 00 80 09 FE 66 89 74 24 7E 66 C1 EE 08 C1 E0 07 83 E6 7F 09 C6 F7 C5 01 00 00 00 89 F0 88 44 24 7F 8B 44 24 7C 89 4C 24 78 74 07 D9 EE D8 F0 DD D8 9B F7 C5 08 00 00 00 74 18 D9 B4 24 D0 00 00 00 66 83 8C 24 D4 00 00 00 08 D9 A4 24 D0 00 00 00 9B F7 C5 10 00 00 00 74 18 D9 B4 24 D0 00 00 00 66 83 8C 24 D4 00 00 00 10 D9 A4 24 D0 00 00 00 9B 83 E5 20 74 18 D9 B4 24 D0 00 00 00 66 83 8C 24 D4 00 00 00 20 D9 A4 24 D0 00 00 00 9B 8B B4 24 10 01 00 00 89 46 0C 89 F0 89 16 89 5E 04 89 4E 08 81 C4 FC 00 00 00 5B 5E 5F 5D C3 8B 9C 24 80 00 00 00 03 0C 24 89 D8 89 4C 24 38 8B 8C 24 94 00 00 00 F7 A4 24 90 00 00 00 89 54 24 2C 89 44 24 28 89 84 24 B0 00 00 00 89 D8 8B 9C 24 90 00 00 00 F7 E1 89 D7 89 C6 8B 84 24 84 00 00 00 F7 E3 89 44 24 04 8B 84 24 84 00 00 00 89 54 24 30 F7 E1 8B 8C 24 80 00 00 00 89 44 24 20 89 54 24 08 89 C8 31 C9 F7 A4 24 98 00 00 00 89 54 24 34 89 04 24 8B 84 24 88 00 00 00 F7 E3 89 CB 89 54 24 18 8B 54 24 04 03 74 24 2C 83 D7 00 83 D3 00 89 74 24 1C 8B 74 24 30 03 54 24 1C 11 FE 11 CB 89 54 24 04 89 5C 24 10 8B 7C 24 08 89 CB 89 94 24 B4 00 00 00 8B 54 24 20 01 F2 13 7C 24 10 83 D3 00 89 CE 89 54 24 20 8B 14 24 89 7C 24 08 8B 7C 24 34 03 54 24 20 13 7C 24 08 11 DE 8B 5C 24 18 89 7C 24 34 89 CF 01 D0 13 5C 24 34 11 F7 8B B4 24 80 00 00 00 89 44 24 20 89 5C 24 18 89 84 24 B8 00 00 00 89 F0 F7 A4 24 9C 00 00 00 89 D3 89 C6 8B 84 24 8C 00 00 00 F7 A4 24 90 00 00 00 89 54 24 08 89 44 24 24 8B 84 24 84 00 00 00 F7 A4 24 98 00 00 00 89 54 24 30 89 04 24 8B 84 24 88 00 00 00 F7 A4 24 94 00 00 00 89 54 24 34 89 CA 03 74 24 18 11 FB 83 D2 00 8B 7C 24 24 89 74 24 1C 89 CE 89 5C 24 10 8B 5C 24 08 03 7C 24 1C 13 5C 24 10 11 D6 8B 54 24 30 89 7C 24 24 8B 3C 24 89 5C 24 08 89 CB 03 7C 24 24 13 54 24 08 11 F3 89 CE 89 3C 24 8B 7C 24 34 03 04 24 11 D7 11 DE 89 44 24 08 8B 9C 24 88 00 00 00 89 84 24 BC 00 00 00 8B 84 24 98 00 00 00 F7 E3 89 54 24 30 89 C3 8B 84 24 84 00 00 00 F7 A4 24 9C 00 00 00 89 14 24 89 44 24 14 8B 84 24 8C 00 00 00 F7 A4 24 94 00 00 00 89 54 24 34 89 44 24 24 8B 84 24 88 00 00 00 F7 A4 24 9C 00 00 00 89 54 24 3C 89 44 24 10 8B 84 24 8C 00 00 00 F7 A4 24 98 00 00 00 89 54 24 18 8B 54 24 30 89 44 24 1C 89 C8 01 FB 11 F2 83 D0 00 8B 7C 24 14 89 CE 89 54 24 30 8B 14 24 01 DF 13 54 24 30 11 C6 89 CB 8B 44 24 24 89 14 24 8B 54 24 34 89 7C 24 14 01 F8 13 14 24 11 F3 89 84 24 C0 00 00 00 89 C8 8B 7C 24 3C 8B 74 24 10 01 D6 11 DF 83 D0 00 8B 5C 24 18 8B 54 24 1C 01 F2 11 FB 11 C1 8B 84 24 8C 00 00 00 8D BC 24 CC 00 00 00 89 94 24 C4 00 00 00 F7 A4 24 9C 00 00 00 01 D8 11 CA 89 84 24 C8 00 00 00 8B 44 24 08 8B 5C 24 04 0B 5C 24 28 0B 5C 24 20 89 94 24 CC 00 00 00 89 C2 C1 E2 0D 09 D3 8D 94 24 C0 00 00 00 8B 32 C1 E8 13 89 F1 C1 E1 0D 09 C1 39 FA 89 4A F0 74 5F 89 F0 83 C2 04 EB E6 8B 84 24 8C 00 00 00 8B B4 24 9C 00 00 00 39 F0 0F 86 E2 01 00 00 8B 9C 24 84 00 00 00 8B 8C 24 88 00 00 00 8B 94 24 80 00 00 00 89 C6 66 81 CE 00 80 E9 14 FC FF FF 90 0F B6 44 24 0C 31 FF 31 F6 31 C9 31 DB 31 D2 83 E0 01 88 44 24 14 E9 FD FB FF FF 90 8D 74 26 00 8B 94 24 BC 00 00 00 31 C0 85 DB 8B 8C 24 B8 00 00 00 0F 95 C0 8B 9C 24 B4 00 00 00 0B 84 24 B0 00 00 00 F7 C2 00 00 10 00 89 94 24 AC 00 00 00 89 8C 24 A8 00 00 00 89 9C 24 A4 00 00 00 89 84 24 A0 00 00 00 0F 84 77 F9 FF FF 89 C6 89 DF D1 EE 83 E0 01 C1 E7 1F 09 FE 89 B4 24 A0 00 00 00 89 CE C1 E6 1F D1 EB C1 E2 1F 09 DE D1 E9 09 CA 89 B4 24 A4 00 00 00 89 94 24 A8 00 00 00 83 44 24 38 01 D1 AC 24 AC 00 00 00 09 84 24 A0 00 00 00 E9 2C F9 FF FF 83 FD 03 B8 03 00 00 00 8D B4 24 80 00 00 00 0F 8F 7B F6 FF FF 89 EA F7 DA 8D 84 24 8C 00 00 00 8D 4C AC 7C C1 E2 02 8B 1C 10 89 18 83 E8 04 39 C8 75 F4 8D 45 FF E9 4A F6 FF FF 85 C9 0F 85 07 01 00 00 85 DB 0F 84 DF 03 00 00 0F BD DB 83 F3 1F 83 C3 40 89 5C 24 18 E9 8E F5 FF FF 83 FB 03 BA 03 00 00 00 8D BC 24 90 00 00 00 0F 8F F8 F7 FF FF 89 DA F7 DA 8D 84 24 9C 00 00 00 8D 8C 9C 8C 00 00 00 C1 E2 02 8B 34 10 89 30 83 E8 04 39 C8 75 F4 8D 53 FF E9 C0 F7 FF FF 8B 44 24 0C 85 C0 0F 85 B5 00 00 00 8B 7C 24 10 85 FF 0F 84 8B 03 00 00 0F BD 54 24 10 83 F2 1F 83 C2 40 89 54 24 0C E9 F6 F6 FF FF 8D 76 00 66 81 FB 00 04 0F 84 05 01 00 00 66 81 FB 00 08 0F 84 AA 03 00 00 66 85 DB 0F 85 FD 00 00 00 BF FF 7F 00 00 31 F6 31 D2 0F B6 5C 24 0C 83 CD 28 89 D1 83 E3 01 88 5C 24 14 89 D3 E9 58 FA FF FF 0F 84 EA 00 00 00 8B 8C 24 98 00 00 00 8B BC 24 94 00 00 00 8B 94 24 90 00 00 00 89 FB 39 94 24 80 00 00 00 0F 84 67 03 00 00 0F B6 44 24 04 66 81 CE 00 80 88 44 24 14 E9 16 FA FF FF 8D 76 00 0F BD C9 83 F1 1F 83 C1 20 89 4C 24 18 E9 8F F4 FF FF 0F BD 54 24 0C 83 F2 1F 83 C2 20 89 54 24 0C E9 4D F6 FF FF 89 C2 83 E2 0F 83 FA 04 0F 84 FD F7 FF FF 83 C0 04 89 84 24 A0 00 00 00 83 F8 03 8B 84 24 A4 00 00 00 0F 96 C2 0F B6 D2 01 D0 39 C2 89 84 24 A4 00 00 00 8B 84 24 A8 00 00 00 0F 97 C2 0F B6 D2 01 D0 39 C2 89 84 24 A8 00 00 00 0F 97 C0 0F B6 C0 03 84 24 AC 00 00 00 89 84 24 AC 00 00 00 E9 AE F7 FF FF 8D B6 00 00 00 00 8B 5C 24 0C 85 DB 0F 85 03 FF FF FF BF FE 7F 00 00 BE FF FF FF FF BA FF FF FF FF E9 F8 FE FF FF 8B 94 24 88 00 00 00 8B 8C 24 98 00 00 00 39 CA 0F 86 93 03 00 00 89 D1 8B 9C 24 84 00 00 00 8B 94 24 80 00 00 00 E9 18 FD FF FF 90 8D 74 26 00 B9 02 C0 FF FF 2B 4C 24 38 83 F9 74 0F 8F 91 01 00 00 85 C9 89 CA 8D 41 1F 0F 49 C1 C1 FA 1F C1 EA 1B 01 D1 83 E1 1F C1 F8 05 29 D1 85 C0 89 0C 24 0F 8E 8C 03 00 00 8D 94 24 A0 00 00 00 31 FF 8D 0C 82 0B 3A 83 C2 04 39 CA 75 F7 89 C2 8B 0C 24 85 C9 0F 85 3F 02 00 00 B9 03 00 00 00 29 C1 8D 94 24 A0 00 00 00 8D 8C 8C A4 00 00 00 8B 1C 82 89 1A 83 C2 04 39 CA 75 F4 BA 04 00 00 00 29 C2 EB 0E C7 84 94 A0 00 00 00 00 00 00 00 83 C2 01 83 FA 03 7E ED 31 C0 85 FF 0F 95 C0 89 EA 0B 84 24 A0 00 00 00 83 CA 20 89 C1 83 E1 07 0F 45 EA 0F B7 54 24 4E 89 84 24 A0 00 00 00 66 81 E2 00 0C 66 81 FA 00 04 0F 84 79 01 00 00 66 81 FA 00 08 0F 84 C5 02 00 00 66 85 D2 0F 85 71 01 00 00 89 C2 83 E2 0F 83 FA 04 0F 84 63 01 00 00 83 C0 04 89 84 24 A0 00 00 00 83 F8 03 8B 84 24 A4 00 00 00 0F 96 C2 0F B6 D2 01 D0 39 C2 89 84 24 A4 00 00 00 8B 84 24 A8 00 00 00 0F 97 C2 0F B6 D2 01 D0 39 C2 89 84 24 A8 00 00 00 0F 97 C0 0F B6 C0 03 84 24 AC 00 00 00 89 84 24 AC 00 00 00 A9 00 00 08 00 0F 84 D5 01 00 00 0F B6 44 24 0C BF 01 00 00 00 31 F6 31 C9 31 DB 31 D2 83 E0 01 88 44 24 14 E9 CF F7 FF FF 8D B4 26 00 00 00 00 8B 74 24 0C 85 F6 0F 85 D5 F5 FF FF 85 D2 0F 84 CD F5 FF FF 83 C0 08 89 84 24 A0 00 00 00 83 F8 07 E9 CB FD FF FF 8B 4C 24 0C 85 C9 75 DE E9 AE F5 FF FF 8B 84 24 A4 00 00 00 31 D2 0B 84 24 A0 00 00 00 0B 84 24 A8 00 00 00 0B 84 24 AC 00 00 00 74 20 0F B7 44 24 4E 83 CD 20 66 25 00 0C 66 3D 00 04 0F 84 03 02 00 00 66 3D 00 08 0F 84 E9 01 00 00 0F B6 5C 24 0C 83 CD 10 31 FF 31 F6 31 C9 83 E3 01 88 5C 24 14 31 DB E9 39 F7 FF FF 90 0F BD 44 24 08 83 F0 1F 83 C0 60 89 44 24 18 E9 AD F1 FF FF 0F BD 54 24 24 83 F2 1F 83 C2 60 89 54 24 0C E9 6B F3 FF FF BA 02 00 00 00 BB 03 00 00 00 E9 E8 F3 FF FF B8 02 00 00 00 BD 03 00 00 00 E9 04 F2 FF FF 8B 5C 24 0C 85 DB 0F 85 57 01 00 00 8B 84 24 AC 00 00 00 E9 E2 FE FF FF 66 90 8B 74 24 0C 85 F6 0F 84 53 FC FF FF E9 4B FD FF FF 39 BC 24 84 00 00 00 0F 85 8C FC FF FF 39 8C 24 88 00 00 00 0F 85 7F FC FF FF 39 F0 0F 85 77 FC FF FF E9 7B FA FF FF 8B 0C 24 C7 44 24 04 20 00 00 00 8B 94 94 A0 00 00 00 29 4C 24 04 0F B6 4C 24 04 D3 E2 09 D7 BA 03 00 00 00 29 C2 89 54 24 10 0F 84 24 01 00 00 8B 5C 24 10 8D 94 24 A0 00 00 00 8D 1C 9A 89 5C 24 14 8B 5C 82 04 0F B6 4C 24 04 8B 34 82 D3 E3 0F B6 0C 24 D3 EE 09 F3 }
	condition:
		$1
}

rule file_71_0_0 {
	meta:
		name = "___copysigntf3"
		size = 80
	strings:
		$1 = { 83 EC 2C 8B 54 24 4C 8B 4C 24 5C 8B 44 24 30 89 54 24 0C C1 EA 18 C1 E9 18 83 E2 7F 83 E1 80 09 CA 88 54 24 0F 8B 54 24 40 89 10 8B 54 24 44 89 50 04 8B 54 24 48 89 50 08 8B 54 24 0C 89 50 0C 83 C4 2C C3 8D B6 00 00 00 00 8D BF 00 00 00 00 }
	condition:
		$1
}

rule file_71_1_0 {
	meta:
		name = "___fabstf2"
		size = 64
	strings:
		$1 = { 83 EC 1C 8B 54 24 3C 8B 44 24 20 89 54 24 0C C1 EA 18 83 E2 7F 88 54 24 0F 8B 54 24 30 89 10 8B 54 24 34 89 50 04 8B 54 24 38 89 50 08 8B 54 24 0C 89 50 0C 83 C4 1C C3 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_72_0_0 {
	meta:
		name = "___fixsfdi"
		size = 64
		refs = "0026 ___fixunssfdi"
	strings:
		$1 = { 83 EC 1C D9 44 24 20 D9 EE DF E9 77 13 D9 5C 24 20 83 C4 1C E9 ?? ?? ?? ?? 8D B4 26 00 00 00 00 D9 E0 D9 1C 24 E8 ?? ?? ?? ?? F7 D8 83 D2 00 83 C4 1C F7 DA C3 90 90 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_73_0_0 {
	meta:
		name = "___fixunssfdi"
		size = 96
		refs = "0012 .rdata"
	strings:
		$1 = { 53 31 DB 83 EC 10 D9 44 24 18 D9 7C 24 0E D9 C0 D8 0D ?? ?? ?? ?? 0F B7 44 24 0E B4 0C 66 89 44 24 0C D9 6C 24 0C DF 3C 24 D9 6C 24 0E 89 5C 24 04 8B 14 24 89 14 24 DF 2C 24 D8 0D ?? ?? ?? ?? DE E9 D9 6C 24 0C DF 3C 24 D9 6C 24 0E 8B 0C 24 83 C4 10 5B 89 C8 C3 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_74_0_0 {
	meta:
		name = "___floatunditf"
		size = 432
	strings:
		$1 = { 55 57 56 53 83 EC 3C 8B 54 24 58 8B 4C 24 54 8B 44 24 50 89 D3 09 CB 0F 84 F3 00 00 00 85 D2 0F 85 32 01 00 00 0F BD F9 89 CB 83 F7 1F 83 C7 20 8D 77 50 C7 44 24 04 3E 40 00 00 29 7C 24 04 83 C7 31 0F 49 F7 89 54 24 24 89 FA C1 FA 1F C1 EA 1B 01 D7 83 E7 1F C1 FE 05 29 D7 89 4C 24 20 C7 44 24 28 00 00 00 00 C7 44 24 2C 00 00 00 00 89 7C 24 08 0F 84 EB 00 00 00 83 FE 02 0F 8F 1E 01 00 00 8B 4C 24 08 BA 03 00 00 00 89 C7 C7 44 24 0C 20 00 00 00 8D 6C 24 20 29 F2 29 4C 24 0C 8D 54 95 00 8B 42 FC 0F B6 4C 24 0C 8B 1A D3 E8 0F B6 4C 24 08 D3 E3 09 D8 89 04 B2 83 EA 04 39 EA 75 E1 8B 5C 24 20 89 F8 8D 56 FF 0F B6 4C 24 08 D3 E3 89 5C B4 20 85 D2 8D 6C 24 20 78 0F 66 90 C7 44 95 00 00 00 00 00 83 EA 01 79 F3 0F B7 7C 24 04 8B 74 24 20 8B 5C 24 24 8B 4C 24 28 0F B7 54 24 2C 66 81 E7 FF 7F EB 10 8D B6 00 00 00 00 31 FF 31 D2 31 C9 31 DB 31 F6 66 89 54 24 1C 0F B7 54 24 1E 66 81 E7 FF 7F 66 81 E2 00 80 09 FA 66 89 54 24 1E 66 C1 EA 08 83 E2 7F 88 54 24 1F 89 30 89 58 04 89 48 08 8B 54 24 1C 89 50 0C 83 C4 3C 5B 5E 5F 5D C3 0F BD FA 89 CB 83 F7 1F E9 CC FE FF FF 83 FE 03 BA 03 00 00 00 8D 6C 24 20 0F 8F 6A FF FF FF 89 F3 F7 DB 8D 54 24 2C 8D 7C B4 1C C1 E3 02 8B 0C 1A 89 0A 83 EA 04 39 FA 75 F4 8D 56 FF E9 3D FF FF FF 8D B4 26 00 00 00 00 BA 02 00 00 00 BE 03 00 00 00 E9 1C FF FF FF 90 }
	condition:
		$1
}

rule file_75_0_0 {
	meta:
		name = "___bid64_add"
		size = 5776
		refs = "0195 ___bid_estimate_decimal_digits 01a4 ___bid_power10_table_128 0229 ___bid_IDEC_glbround 03f4 ___bid_estimate_bin_expon 04db ___bid_round_const_table 050c ___bid_reciprocals10_64 0580 ___bid_short_recip_scale 0a9c ___bid_IDEC_glbflags 0b18 .rdata"
	strings:
		$1 = { 55 57 56 53 81 EC 9C 00 00 00 8B 84 24 B0 00 00 00 8B B4 24 B4 00 00 00 8B 94 24 B8 00 00 00 8B 8C 24 BC 00 00 00 89 44 24 28 89 F0 89 F3 25 00 00 00 60 81 E3 00 00 00 80 3D 00 00 00 60 89 54 24 50 89 4C 24 40 89 5C 24 30 0F 84 20 08 00 00 8B 4C 24 28 89 F2 89 F3 C1 EA 15 81 E3 FF FF 1F 00 81 E2 FF 03 00 00 89 5C 24 1C 89 4C 24 18 8B 44 24 40 8B 7C 24 40 25 00 00 00 60 81 E7 00 00 00 80 3D 00 00 00 60 8B 44 24 40 89 7C 24 38 0F 84 73 07 00 00 8B 7C 24 40 C1 E8 15 8B 6C 24 50 25 FF 03 00 00 81 E7 FF FF 1F 00 89 6C 24 10 89 7C 24 14 8B 7C 24 10 8B 6C 24 14 89 7C 24 20 89 6C 24 24 8B 6C 24 1C 0B 6C 24 18 75 53 89 F5 81 E5 00 00 00 7C 81 FD 00 00 00 7C 0F 84 1F 09 00 00 89 F5 81 E5 00 00 00 78 81 FD 00 00 00 78 0F 84 CB 09 00 00 8B 6C 24 40 81 E5 00 00 00 78 81 FD 00 00 00 78 74 19 8B 7C 24 14 0B 7C 24 10 74 0F 39 D0 0F 8E 27 10 00 00 8D B4 26 00 00 00 00 8B 6C 24 24 0B 6C 24 20 0F 84 48 02 00 00 39 D0 0F 8E 8A 07 00 00 89 4C 24 20 8B 4C 24 38 31 FF 8B 6C 24 30 89 54 24 50 89 44 24 28 89 5C 24 24 C7 44 24 18 00 00 00 00 89 4C 24 1C 8B 44 24 14 8B 5C 24 28 2B 5C 24 50 DF 6C 24 10 85 C0 0F 88 A2 09 00 00 DD 5C 24 30 8B 44 24 34 25 00 00 F0 7F C1 E8 14 2D FF 03 00 00 83 FB 10 0F 8E 5F 02 00 00 8B 04 85 ?? ?? ?? ?? 8B 74 24 14 89 C2 C1 E2 04 3B B2 ?? ?? ?? ?? 72 16 0F 87 D0 08 00 00 8B 4C 24 10 3B 8A ?? ?? ?? ?? 0F 83 C0 08 00 00 BE 10 00 00 00 8B 4C 24 14 29 C6 8B 54 24 10 89 F0 29 F3 C1 E0 04 0F AF 88 ?? ?? ?? ?? 0F AF 90 ?? ?? ?? ?? 89 44 24 30 8B 44 24 10 01 CA 8B 4C 24 30 89 54 24 38 F7 A1 ?? ?? ?? ?? 8B 4C 24 38 89 44 24 10 01 CA 83 FB 10 89 54 24 14 0F 8E BD 01 00 00 8B 4C 24 28 29 F1 8B 74 24 24 0B 74 24 20 0F 85 3E 0E 00 00 8B 35 ?? ?? ?? ?? 8D 76 00 83 FB 11 75 4B 8B 54 24 10 8B 44 24 14 81 F2 00 80 C6 A4 35 7E 8D 03 00 09 C2 75 34 81 7C 24 24 79 C3 11 00 0F 86 96 0F 00 00 8B 54 24 18 8B 44 24 1C 31 FA 31 E8 09 C2 0F 85 62 0E 00 00 C7 44 24 10 00 80 C6 A4 C7 44 24 14 7E 8D 03 00 66 90 81 F9 FE 02 00 00 0F 86 94 00 00 00 8B 54 24 10 8B 44 24 14 81 F2 00 00 C1 6F 35 F2 86 23 00 09 C2 0F 84 FC 0E 00 00 81 F9 FF 02 00 00 74 71 81 7C 24 14 7E 8D 03 00 72 0C 77 57 81 7C 24 10 FF 7F C6 A4 77 4D 81 F9 FF 02 00 00 7E 45 8B 44 24 10 89 CF 8B 54 24 14 89 C1 89 D3 0F A4 C3 03 83 EF 01 0F A4 C2 01 01 C0 C1 E1 03 01 C8 11 DA 81 FA 7E 8D 03 00 0F 82 35 0F 00 00 77 0B 3D FF 7F C6 A4 0F 86 28 0F 00 00 89 44 24 10 89 F9 89 54 24 14 81 F9 FF 02 00 00 0F 8F 91 0E 00 00 66 90 81 7C 24 14 FF FF 1F 00 0F 86 35 11 00 00 8B 54 24 14 8B 44 24 10 81 F2 F2 86 23 00 35 00 00 C1 6F 09 C2 0F 84 C2 0E 00 00 8B 5C 24 1C C1 E1 13 8B 44 24 14 8B 74 24 18 8B 7C 24 10 81 CB 00 00 00 60 25 FF FF 07 00 09 C3 89 F0 89 DA 09 F8 09 CA E9 BC 06 00 00 8B 6C 24 40 81 E5 00 00 00 78 81 FD 00 00 00 78 0F 84 FC 06 00 00 89 DF 09 CF 0F 85 AA 06 00 00 39 D0 0F 8C A5 0C 00 00 31 C0 C1 E2 15 8B 6C 24 38 39 6C 24 30 0F 84 CF 10 00 00 83 3D ?? ?? ?? ?? 01 0F 85 74 06 00 00 89 D1 81 C9 00 00 00 80 89 CA E9 65 06 00 00 8D 76 00 85 D2 DF 6C 24 10 0F 88 F7 10 00 00 DD 5C 24 28 8B 44 24 2C 25 00 00 F0 7F C1 E8 14 2D FF 03 00 00 8B 14 9D ?? ?? ?? ?? 01 C2 83 FA 3B 0F 8E FD 04 00 00 8B 35 ?? ?? ?? ?? 8B 54 24 1C 0B 54 24 18 89 74 24 54 89 74 24 28 74 0E 89 F2 83 EA 01 83 FA 01 0F 86 B7 10 00 00 8B 04 85 ?? ?? ?? ?? B9 10 00 00 00 8B 54 24 1C 29 D9 C1 E1 04 8B B9 ?? ?? ?? ?? 89 44 24 60 31 EA 8B A9 ?? ?? ?? ?? 8B 4C 24 60 C1 FA 1F 89 D0 89 7C 24 70 89 6C 24 74 8B 6C 24 14 C1 E1 04 3B A9 ?? ?? ?? ?? 72 0B 0F 86 72 0C 00 00 83 44 24 60 01 8B 7C 24 60 89 DD 8B 74 24 10 C7 44 24 40 10 00 00 00 29 7C 24 40 2B 74 24 70 8B 7C 24 14 1B 7C 24 74 89 74 24 68 89 74 24 64 8B 74 24 20 2B 6C 24 40 89 7C 24 6C 89 BC 24 84 00 00 00 8B 7C 24 24 01 C6 89 F1 8B 74 24 28 11 D7 31 C1 89 4C 24 48 89 F9 8D 04 F6 31 D1 8D 04 46 01 E8 8B 34 C5 ?? ?? ?? ?? 8B 3C C5 ?? ?? ?? ?? 8B 44 24 48 89 4C 24 4C 8B 54 24 4C 89 74 24 78 89 7C 24 7C 05 00 00 C1 6F 81 D2 F2 86 23 00 01 F0 11 FA 8B 3C ED ?? ?? ?? ?? 89 C1 89 D6 89 7C 24 58 8B 44 24 58 8B 3C ED ?? ?? ?? ?? F7 E2 89 BC 24 80 00 00 00 89 44 24 20 89 F8 89 54 24 24 F7 E6 89 44 24 30 89 54 24 34 8B 44 24 58 F7 E1 89 54 24 3C 8B 7C 24 3C 31 D2 89 44 24 38 8B 44 24 20 89 FE 31 FF 01 C6 8B 84 24 80 00 00 00 11 D7 F7 E1 8B 4C 24 24 01 C6 8B 44 24 30 11 D7 89 CA 31 C9 89 4C 24 24 8B 0C AD ?? ?? ?? ?? 89 54 24 20 8B 54 24 34 01 44 24 20 11 54 24 24 31 D2 01 7C 24 20 11 54 24 24 31 D2 8B 44 24 38 89 74 24 34 8B 7C 24 24 89 4C 24 38 8B 74 24 20 0F B6 4C 24 38 89 54 24 30 31 D2 01 44 24 30 11 54 24 34 31 C0 0F AD FE D3 EF F6 C1 20 0F 45 F7 0F 45 F8 8B 44 24 40 C1 E0 04 89 44 24 08 8B 8C 24 84 00 00 00 8B 54 24 64 0F AF 88 ?? ?? ?? ?? 0F AF 90 ?? ?? ?? ?? 8B 44 24 64 01 CA 8B 4C 24 08 89 54 24 04 F7 A1 ?? ?? ?? ?? 8B 4C 24 04 89 44 24 08 01 CA 03 74 24 08 89 54 24 0C 13 7C 24 0C 89 F0 05 FF 7F 39 5B 89 FA 81 D2 81 72 FC FF 81 FA 73 F9 1F 00 0F 82 EC 04 00 00 0F 86 DB 04 00 00 81 FF F2 86 23 00 72 14 66 90 0F 87 EB 0B 00 00 81 FE FF FF C0 6F 0F 87 DF 0B 00 00 8B 4C 24 48 8B 44 24 48 8B 5C 24 4C 8B 54 24 4C 0F A4 CB 03 0F A4 C2 01 01 C0 C1 E1 03 01 C1 8B 44 24 58 11 D3 81 C1 00 00 8A 5D 81 D3 78 45 63 01 03 4C 24 78 13 5C 24 7C 89 4C 24 68 F7 E3 89 44 24 10 8B 84 24 80 00 00 00 89 54 24 14 F7 E3 89 44 24 48 8B 44 24 58 89 54 24 4C F7 E1 89 54 24 5C 8B 5C 24 5C 31 D2 89 44 24 58 8B 44 24 10 89 D9 31 DB 89 4C 24 40 8B 4C 24 14 01 44 24 40 8B 84 24 80 00 00 00 89 5C 24 44 11 54 24 44 F7 64 24 68 01 44 24 40 11 54 24 44 89 CA 31 C9 89 54 24 10 8B 54 24 44 89 4C 24 14 8B 4C 24 48 01 4C 24 10 8B 5C 24 4C 11 5C 24 14 89 D0 31 D2 0F B6 4C 24 38 01 44 24 10 11 54 24 14 31 DB 8B 54 24 14 8B 44 24 10 0F AD D0 D3 EA F6 C1 20 0F 45 C2 B9 11 00 00 00 0F 45 D3 2B 4C 24 60 89 44 24 68 8B 84 24 84 00 00 00 89 54 24 6C 8B 54 24 64 C1 E1 04 0F AF 81 ?? ?? ?? ?? 0F AF 91 ?? ?? ?? ?? 8D 1C 02 8B 44 24 64 F7 A1 ?? ?? ?? ?? 01 DA 89 54 24 74 8B 4C 24 74 89 44 24 70 8B 54 24 70 01 54 24 68 11 4C 24 6C 81 7C 24 6C F2 86 23 00 0F 87 C3 0D 00 00 72 0E 81 7C 24 68 FF FF C0 6F 0F 87 B3 0D 00 00 8B 5C 24 40 31 D2 8B 44 24 58 83 6C 24 50 01 8B 7C 24 14 89 DE 31 DB 89 5C 24 30 01 44 24 30 8B 44 24 18 89 74 24 34 8B 74 24 10 11 54 24 34 8B 54 24 1C 89 7C 24 24 8B 7C 24 6C 89 74 24 20 8B 74 24 68 89 44 24 10 89 54 24 14 E9 34 03 00 00 25 00 00 00 78 3D 00 00 00 78 8B 44 24 40 0F 84 44 07 00 00 8B 7C 24 50 25 FF FF 07 00 0D 00 00 20 00 3D F2 86 23 00 89 44 24 14 89 7C 24 10 0F 86 13 02 00 00 C7 44 24 10 00 00 00 00 C7 44 24 14 00 00 00 00 8B 44 24 40 8B 7C 24 10 8B 6C 24 14 C1 E8 13 25 FF 03 00 00 89 7C 24 20 89 6C 24 24 E9 55 F8 FF FF 66 90 89 F0 25 00 00 00 78 3D 00 00 00 78 89 F0 0F 84 54 07 00 00 25 FF FF 07 00 8B 4C 24 28 89 C3 81 CB 00 00 20 00 81 FB F2 86 23 00 0F 86 C6 01 00 00 31 C9 31 DB 89 F2 C1 EA 13 81 E2 FF 03 00 00 89 4C 24 18 89 5C 24 1C E9 B2 F7 FF FF 8D 76 00 89 54 24 28 8B 54 24 14 31 FF 89 44 24 50 8B 44 24 10 89 5C 24 14 8B 6C 24 38 89 4C 24 10 89 54 24 24 8B 54 24 30 89 44 24 20 C7 44 24 18 00 00 00 00 89 54 24 1C E9 61 F8 FF FF 90 8D 74 26 00 8B 4C 24 1C 89 EA C1 FA 1F 8B 44 24 10 89 D6 89 D7 03 74 24 20 13 7C 24 24 C1 F9 1F C1 E3 04 89 4C 24 18 89 4C 24 1C 8B 4C 24 14 0F AF 83 ?? ?? ?? ?? 0F AF 8B ?? ?? ?? ?? 89 54 24 28 89 54 24 2C 01 C1 8B 44 24 10 F7 A3 ?? ?? ?? ?? 8B 5C 24 1C 01 CA 8B 4C 24 18 89 44 24 10 8B 44 24 10 03 44 24 18 89 54 24 14 8B 54 24 14 13 54 24 1C 31 C1 8B 44 24 28 C7 44 24 10 00 00 00 00 31 D3 8B 54 24 2C 31 F0 31 FA 01 C1 11 D3 89 DA C1 FA 1F 01 D1 11 D3 89 CE 89 DF 89 D1 81 E1 00 00 00 80 31 D6 31 D7 3B 3D ?? ?? ?? ?? 89 4C 24 14 0F 87 38 04 00 00 0F 83 26 04 00 00 83 3D ?? ?? ?? ?? 01 0F 84 90 07 00 00 81 FF FF FF 1F 00 0F 86 B6 07 00 00 8B 4C 24 50 89 F5 89 FE 8B 5C 24 10 81 E6 FF FF 07 00 C1 E1 13 81 C9 00 00 00 60 89 D8 0B 4C 24 14 09 E8 89 CA 09 F2 EB 36 8D 74 26 00 81 E6 00 00 00 7E 81 FE 00 00 00 7E 0F 84 25 06 00 00 8B 7C 24 40 81 E7 00 00 00 7E 81 FF 00 00 00 7E 0F 84 0F 06 00 00 89 DA 89 C8 81 E2 FF FF FF FD 81 C4 9C 00 00 00 5B 5E 5F 5D C3 8D 76 00 39 D0 0F 8C 78 FE FF FF 8B 44 24 28 89 F2 EB E2 0F 82 F7 FD FF FF 81 FF FF FF C0 6F 0F 86 EB FD FF FF E9 D6 FD FF FF 0F 82 38 FE FF FF 81 F9 FF FF C0 6F 0F 86 2C FE FF FF E9 23 FE FF FF 66 90 83 C0 01 E9 38 F7 FF FF 8B 7C 24 40 81 E7 00 00 00 7E 81 FF 00 00 00 7E 75 07 83 0D ?? ?? ?? ?? 01 8B 54 24 14 8B 44 24 10 81 C4 9C 00 00 00 5B 5E 81 E2 FF FF FF FD 5F 5D C3 8D B6 00 00 00 00 8B 74 24 40 81 E6 00 00 00 7C 81 FE 00 00 00 78 0F 84 BA 09 00 00 81 FE 00 00 00 7C 89 C8 89 DA 0F 85 4C FF FF FF 8B 7C 24 40 8B 54 24 14 8B 44 24 10 81 E7 00 00 00 7E 81 E2 FF FF FF FD 81 FF 00 00 00 7E 0F 85 28 FF FF FF 83 0D ?? ?? ?? ?? 01 E9 1C FF FF FF D8 05 ?? ?? ?? ?? E9 53 F6 FF FF 3D FE 7F FA CA 0F 87 1A FB FF FF 8B 54 24 18 8B 4C 24 1C 89 54 24 10 89 4C 24 14 8B 44 24 28 85 C0 0F 85 98 01 00 00 89 F0 B9 40 00 00 00 8B 54 24 24 83 E0 01 2B 4C 24 38 85 C0 8B 44 24 20 0F 84 EA 04 00 00 0F A5 C2 31 DB D3 E0 F6 C1 20 0F 45 D0 0F 45 C3 89 D3 09 C3 75 24 8B 4C 24 34 39 0C ED ?? ?? ?? ?? 72 17 77 0D 8B 5C 24 30 39 1C ED ?? ?? ?? ?? 76 08 83 C6 FF 83 D7 FF 66 90 81 C2 00 00 00 80 BB 20 00 00 00 09 C2 0F 84 7E 03 00 00 8B 4C 24 50 0B 1D ?? ?? ?? ?? 01 E9 81 F9 FE 02 00 00 89 1D ?? ?? ?? ?? 76 7B 89 F2 89 F8 81 F2 00 00 C1 6F 35 F2 86 23 00 09 C2 75 60 81 F9 FF 02 00 00 75 58 8B 54 24 14 83 CB 28 89 1D ?? ?? ?? ?? 8B 44 24 10 81 CA 00 00 00 78 83 7C 24 54 02 0F 84 2A 0A 00 00 83 7C 24 54 03 0F 84 07 0A 00 00 83 7C 24 54 01 0F 85 12 FE FF FF 8B 5C 24 14 09 C3 0F 85 06 FE FF FF B8 FF FF C0 6F BA F2 86 FB 77 E9 F7 FD FF FF 90 8D 74 26 00 81 F9 FF 02 00 00 75 78 81 FF FF FF 1F 00 0F 86 73 01 00 00 89 FA 89 F0 81 F2 F2 86 23 00 35 00 00 C1 6F 09 C2 0F 84 46 08 00 00 8B 6C 24 14 89 F8 8B 5C 24 10 25 FF FF 07 00 81 C4 9C 00 00 00 C1 E1 13 81 CD 00 00 00 60 09 C5 89 D8 89 EA 09 F0 5B 09 CA 5E 5F 5D C3 81 FE FF 7F C6 A4 77 2A 81 F9 FF 02 00 00 7E 22 89 F0 89 FA 0F A4 F2 03 83 E9 01 0F A4 F7 01 01 F6 C1 E0 03 01 C6 11 D7 81 FF 7E 8D 03 00 72 D8 76 CE 81 F9 FF 02 00 00 0F 8E 72 FF FF FF E9 0D FF FF FF 90 8D 74 26 00 8B 4C 24 38 31 DB C7 44 24 40 40 00 00 00 8B 44 24 20 29 4C 24 40 0F B6 4C 24 40 8B 54 24 24 0F A5 C2 D3 E0 F6 C1 20 0F 45 D0 0F 45 C3 83 7C 24 28 01 0F 84 0A 02 00 00 0F 82 82 FE FF FF 83 7C 24 28 03 0F 84 F9 01 00 00 83 7C 24 28 04 0F 84 6C FE FF FF 8B 4C 24 30 03 0C ED ?? ?? ?? ?? 8B 5C 24 34 13 1C ED ?? ?? ?? ?? 89 4C 24 20 8B 4C 24 34 C7 44 24 18 01 00 00 00 89 5C 24 24 C7 44 24 1C 00 00 00 00 39 CB 72 1C 77 0A 8B 5C 24 30 39 5C 24 20 72 10 C7 44 24 18 00 00 00 00 C7 44 24 1C 00 00 00 00 0F B6 4C 24 40 31 DB 0F AD D0 D3 EA F6 C1 20 0F B6 4C 24 38 0F 45 C2 0F 45 D3 03 44 24 18 13 54 24 1C 31 DB 0F AD D0 D3 EA F6 C1 20 0F 45 C2 0F 45 D3 09 D0 83 F8 01 19 DB 83 E3 20 E9 EC FD FF FF 8B 5C 24 14 C1 E1 15 8B 44 24 10 09 FB 89 DA 09 F0 09 CA E9 53 FC FF FF 90 3B 35 ?? ?? ?? ?? 0F 82 CE FB FF FF 3B 3D ?? ?? ?? ?? 0F 82 08 03 00 00 77 0C 3B 35 ?? ?? ?? ?? 0F 82 FA 02 00 00 3B 3D ?? ?? ?? ?? 0F 87 3E 07 00 00 72 0C 3B 35 ?? ?? ?? ?? 0F 83 30 07 00 00 BD 02 00 00 00 8B 1D ?? ?? ?? ?? 8B 44 24 14 0B 44 24 10 89 5C 24 54 89 5C 24 28 74 0E 89 D8 83 E8 01 83 F8 01 0F 86 0F 07 00 00 8B 5C 24 28 8B 0C ED ?? ?? ?? ?? 8D 04 DB 8D 04 43 01 E8 03 34 C5 ?? ?? ?? ?? 13 3C C5 ?? ?? ?? ?? 89 FB 8B 3C ED ?? ?? ?? ?? 89 D8 F7 E1 89 44 24 20 89 D8 89 54 24 24 F7 E7 89 44 24 30 89 F0 89 54 24 34 F7 E1 89 54 24 1C 8B 5C 24 1C 31 D2 89 44 24 18 8B 44 24 20 89 D9 31 DB 01 C1 89 F0 11 D3 F7 E7 8B 7C 24 24 01 C1 89 FE 8B 44 24 18 11 D3 31 FF 89 74 24 20 8B 74 24 30 01 74 24 20 89 7C 24 24 8B 7C 24 34 11 7C 24 24 31 D2 01 5C 24 20 11 54 24 24 31 F6 31 D2 89 74 24 30 01 44 24 30 89 4C 24 34 11 54 24 34 31 C0 8B 0C AD ?? ?? ?? ?? 8B 7C 24 24 8B 74 24 20 89 4C 24 38 0F B6 4C 24 38 0F AD FE D3 EF 83 E1 20 0F 45 F7 0F 45 F8 E9 1A FC FF FF 89 D1 BB 20 00 00 00 09 C1 0F 85 82 FC FF FF 8B 5C 24 34 39 1C ED ?? ?? ?? ?? 0F 87 0E 02 00 00 72 11 8B 44 24 30 39 04 ED ?? ?? ?? ?? 0F 87 FB 01 00 00 BB 20 00 00 00 E9 54 FC FF FF 90 25 FF FF 03 00 3D 7E 8D 03 00 0F 87 B0 01 00 00 72 0E 81 7C 24 50 FF 7F C6 A4 0F 87 A0 01 00 00 8B 44 24 40 8B 6C 24 50 25 FF FF 03 FE 89 6C 24 10 89 44 24 14 8B 6C 24 40 31 C0 C7 44 24 20 00 00 00 00 C7 44 24 24 00 00 00 00 81 E5 00 00 00 7C 81 FD 00 00 00 78 0F 85 06 F1 FF FF 8B 6C 24 40 C7 44 24 10 00 00 00 00 81 E5 00 00 00 F8 89 6C 24 14 E9 EB F0 FF FF 25 FF FF 03 00 3D 7E 8D 03 00 0F 87 28 01 00 00 72 0E 81 7C 24 28 FF 7F C6 A4 0F 87 18 01 00 00 8B 4C 24 28 89 F3 81 E3 }
	condition:
		$1
}

rule file_75_1_0 {
	meta:
		name = "___bid64_sub"
		size = 48
	strings:
		$1 = { 8B 44 24 10 89 C2 81 E2 00 00 00 7C 8D 88 00 00 00 80 81 FA 00 00 00 7C 0F 45 C1 89 44 24 10 E9 4C E9 FF FF 90 90 90 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_76_0_0 {
	meta:
		name = "___divtc3"
		size = 7616
		refs = "0108 ___fabstf2 0194 ___lttf2 01e8 ___divtf3 0240 ___multf3 02a3 ___addtf3 04ce ___subtf3 059e ___netf2 0985 ___eqtf2 0a95 ___copysigntf3"
	strings:
		$1 = { 55 57 56 53 81 EC FC 00 00 00 8B 94 24 20 01 00 00 8D B4 24 E0 00 00 00 8B 8C 24 10 01 00 00 89 94 24 98 00 00 00 8B 94 24 24 01 00 00 89 94 24 9C 00 00 00 8B 94 24 28 01 00 00 89 94 24 A0 00 00 00 8B 94 24 2C 01 00 00 89 94 24 A4 00 00 00 8B 94 24 30 01 00 00 89 94 24 84 00 00 00 8B 94 24 34 01 00 00 89 94 24 8C 00 00 00 8B 94 24 38 01 00 00 89 94 24 90 00 00 00 8B 94 24 3C 01 00 00 89 94 24 94 00 00 00 8B 94 24 40 01 00 00 89 54 24 6C 8B 94 24 44 01 00 00 89 54 24 64 8B 94 24 48 01 00 00 89 54 24 68 8B 94 24 4C 01 00 00 89 54 24 50 8B 94 24 50 01 00 00 89 54 24 54 8B 94 24 54 01 00 00 89 54 24 58 8B 94 24 58 01 00 00 89 34 24 89 4C 24 40 89 54 24 5C 8B 94 24 5C 01 00 00 89 54 24 60 8B 54 24 6C 89 54 24 10 8B 54 24 64 89 54 24 14 8B 54 24 68 89 54 24 18 8B 54 24 50 89 54 24 1C E8 ?? ?? ?? ?? 8B 44 24 54 8B 94 24 E8 00 00 00 89 34 24 8B AC 24 E0 00 00 00 8B BC 24 E4 00 00 00 89 44 24 10 8B 44 24 58 8B 9C 24 EC 00 00 00 89 54 24 44 89 44 24 14 8B 44 24 5C 89 44 24 18 8B 44 24 60 89 44 24 1C E8 ?? ?? ?? ?? 8B 84 24 E0 00 00 00 8B 54 24 44 89 2C 24 89 7C 24 04 89 44 24 10 8B 84 24 E4 00 00 00 89 54 24 08 89 5C 24 0C 89 44 24 14 8B 84 24 E8 00 00 00 89 44 24 18 8B 84 24 EC 00 00 00 89 44 24 1C E8 ?? ?? ?? ?? 8B 4C 24 40 85 C0 0F 89 42 04 00 00 8B 54 24 54 89 34 24 89 54 24 20 8B 54 24 58 89 54 24 24 8B 54 24 5C 89 54 24 28 8B 54 24 60 89 54 24 2C 8B 54 24 6C 89 54 24 10 8B 54 24 64 89 54 24 14 8B 54 24 68 89 54 24 18 8B 54 24 50 89 54 24 1C E8 ?? ?? ?? ?? 8B 44 24 6C 8B 94 24 E0 00 00 00 8B AC 24 E4 00 00 00 8B BC 24 E8 00 00 00 89 44 24 10 8B 44 24 64 8B 9C 24 EC 00 00 00 89 54 24 20 89 6C 24 24 89 44 24 14 8B 44 24 68 89 7C 24 28 89 5C 24 2C 89 34 24 89 44 24 18 8B 44 24 50 89 54 24 44 89 44 24 1C E8 ?? ?? ?? ?? 8D 84 24 D0 00 00 00 89 44 24 78 8B 44 24 54 89 44 24 20 8B 44 24 58 89 44 24 24 8B 44 24 5C 89 44 24 28 8B 44 24 60 89 44 24 2C 8B 84 24 E0 00 00 00 89 44 24 10 8B 84 24 E4 00 00 00 89 44 24 14 8B 84 24 E8 00 00 00 89 44 24 18 8B 84 24 EC 00 00 00 89 44 24 1C 8B 44 24 78 89 04 24 E8 ?? ?? ?? ?? 8B 84 24 D0 00 00 00 8B 54 24 44 89 6C 24 24 89 7C 24 28 89 44 24 4C 8B 84 24 D4 00 00 00 89 54 24 20 89 5C 24 2C 89 34 24 89 84 24 A8 00 00 00 8B 84 24 D8 00 00 00 89 84 24 80 00 00 00 8B 84 24 DC 00 00 00 89 84 24 88 00 00 00 8B 84 24 98 00 00 00 89 44 24 10 8B 84 24 9C 00 00 00 89 44 24 14 8B 84 24 A0 00 00 00 89 44 24 18 8B 84 24 A4 00 00 00 89 44 24 1C E8 ?? ?? ?? ?? 8B 84 24 84 00 00 00 89 44 24 20 8B 84 24 8C 00 00 00 89 44 24 24 8B 84 24 90 00 00 00 89 44 24 28 8B 84 24 94 00 00 00 89 44 24 2C 8B 84 24 E0 00 00 00 89 44 24 10 8B 84 24 E4 00 00 00 89 44 24 14 8B 84 24 E8 00 00 00 89 44 24 18 8B 84 24 EC 00 00 00 89 44 24 1C 8B 44 24 78 89 04 24 E8 ?? ?? ?? ?? 8D 84 24 C0 00 00 00 89 84 24 AC 00 00 00 8B 44 24 4C 89 44 24 20 8B 84 24 A8 00 00 00 89 44 24 24 8B 84 24 80 00 00 00 89 44 24 28 8B 84 24 88 00 00 00 89 44 24 2C 8B 84 24 D0 00 00 00 89 44 24 10 8B 84 24 D4 00 00 00 89 44 24 14 8B 84 24 D8 00 00 00 89 44 24 18 8B 84 24 DC 00 00 00 89 44 24 1C 8B 84 24 AC 00 00 00 89 04 24 E8 ?? ?? ?? ?? 8B 54 24 44 8B 84 24 C0 00 00 00 89 6C 24 24 89 7C 24 28 89 54 24 20 8B 94 24 84 00 00 00 89 44 24 48 8B 84 24 C4 00 00 00 89 5C 24 2C 89 34 24 89 54 24 10 8B 94 24 8C 00 00 00 89 44 24 74 8B 84 24 C8 00 00 00 89 54 24 14 8B 94 24 90 00 00 00 89 44 24 70 8B 84 24 CC 00 00 00 89 54 24 18 8B 94 24 94 00 00 00 89 44 24 7C 89 54 24 1C E8 ?? ?? ?? ?? 8B 94 24 98 00 00 00 8B 84 24 E0 00 00 00 89 54 24 20 8B 94 24 9C 00 00 00 89 44 24 10 8B 84 24 E4 00 00 00 89 54 24 24 8B 94 24 A0 00 00 00 89 44 24 14 8B 84 24 E8 00 00 00 89 54 24 28 8B 94 24 A4 00 00 00 89 44 24 18 8B 84 24 EC 00 00 00 89 54 24 2C 89 44 24 1C 8B 54 24 78 89 14 24 E8 ?? ?? ?? ?? 8B 44 24 4C 8B 94 24 A8 00 00 00 89 44 24 20 8B 84 24 80 00 00 00 89 54 24 24 8B 94 24 88 00 00 00 89 44 24 28 8B 84 24 D0 00 00 00 89 54 24 2C 8B 94 24 AC 00 00 00 89 44 24 10 8B 84 24 D4 00 00 00 89 14 24 89 44 24 14 8B 84 24 D8 00 00 00 89 44 24 18 8B 84 24 DC 00 00 00 89 44 24 1C E8 ?? ?? ?? ?? 8B 94 24 C8 00 00 00 8B 4C 24 40 8B AC 24 C0 00 00 00 8B BC 24 C4 00 00 00 89 54 24 4C 8B 54 24 48 89 4C 24 40 8B 9C 24 CC 00 00 00 89 54 24 10 8B 54 24 74 89 54 24 14 8B 54 24 70 89 54 24 18 8B 54 24 7C 89 54 24 1C 8B 54 24 48 89 14 24 8B 54 24 74 89 54 24 04 8B 54 24 70 89 54 24 08 8B 54 24 7C 89 54 24 0C E8 ?? ?? ?? ?? 8B 4C 24 40 85 C0 0F 85 63 03 00 00 8B 54 24 48 89 C8 89 69 10 89 79 14 89 59 1C 89 11 8B 54 24 74 89 51 04 8B 54 24 70 89 51 08 8B 54 24 7C 89 51 0C 8B 54 24 4C 89 51 18 81 C4 FC 00 00 00 5B 5E 5F 5D C3 8B 54 24 6C 89 34 24 89 4C 24 40 89 54 24 20 8B 54 24 64 89 54 24 24 8B 54 24 68 89 54 24 28 8B 54 24 50 89 54 24 2C 8B 54 24 54 89 54 24 10 8B 54 24 58 89 54 24 14 8B 54 24 5C 89 54 24 18 8B 54 24 60 89 54 24 1C E8 ?? ?? ?? ?? 8B 44 24 54 8B 94 24 E0 00 00 00 8B AC 24 E4 00 00 00 8B BC 24 E8 00 00 00 89 44 24 10 8B 44 24 58 8B 9C 24 EC 00 00 00 89 54 24 20 89 6C 24 24 89 44 24 14 8B 44 24 5C 89 7C 24 28 89 5C 24 2C 89 34 24 89 44 24 18 8B 44 24 60 89 54 24 44 89 44 24 1C E8 ?? ?? ?? ?? 8D 84 24 D0 00 00 00 89 44 24 78 8B 44 24 6C 89 44 24 20 8B 44 24 64 89 44 24 24 8B 44 24 68 89 44 24 28 8B 44 24 50 89 44 24 2C 8B 84 24 E0 00 00 00 89 44 24 10 8B 84 24 E4 00 00 00 89 44 24 14 8B 84 24 E8 00 00 00 89 44 24 18 8B 84 24 EC 00 00 00 89 44 24 1C 8B 44 24 78 89 04 24 E8 ?? ?? ?? ?? 8B 84 24 D0 00 00 00 8B 54 24 44 89 6C 24 24 89 7C 24 28 89 44 24 4C 8B 84 24 D4 00 00 00 89 54 24 20 89 5C 24 2C 89 34 24 89 84 24 A8 00 00 00 8B 84 24 D8 00 00 00 89 84 24 80 00 00 00 8B 84 24 DC 00 00 00 89 84 24 88 00 00 00 8B 84 24 84 00 00 00 89 44 24 10 8B 84 24 8C 00 00 00 89 44 24 14 8B 84 24 90 00 00 00 89 44 24 18 8B 84 24 94 00 00 00 89 44 24 1C E8 ?? ?? ?? ?? 8B 84 24 98 00 00 00 89 44 24 20 8B 84 24 9C 00 00 00 89 44 24 24 8B 84 24 A0 00 00 00 89 44 24 28 8B 84 24 A4 00 00 00 89 44 24 2C 8B 84 24 E0 00 00 00 89 44 24 10 8B 84 24 E4 00 00 00 89 44 24 14 8B 84 24 E8 00 00 00 89 44 24 18 8B 84 24 EC 00 00 00 89 44 24 1C 8B 44 24 78 89 04 24 E8 ?? ?? ?? ?? 8D 84 24 C0 00 00 00 89 84 24 AC 00 00 00 8B 44 24 4C 89 44 24 20 8B 84 24 A8 00 00 00 89 44 24 24 8B 84 24 80 00 00 00 89 44 24 28 8B 84 24 88 00 00 00 89 44 24 2C 8B 84 24 D0 00 00 00 89 44 24 10 8B 84 24 D4 00 00 00 89 44 24 14 8B 84 24 D8 00 00 00 89 44 24 18 8B 84 24 DC 00 00 00 89 44 24 1C 8B 84 24 AC 00 00 00 89 04 24 E8 ?? ?? ?? ?? 8B 54 24 44 8B 84 24 C0 00 00 00 89 6C 24 24 89 7C 24 28 89 54 24 20 8B 94 24 98 00 00 00 89 44 24 48 8B 84 24 C4 00 00 00 89 5C 24 2C 89 34 24 89 54 24 10 8B 94 24 9C 00 00 00 89 44 24 74 8B 84 24 C8 00 00 00 89 54 24 14 8B 94 24 A0 00 00 00 89 44 24 70 8B 84 24 CC 00 00 00 89 54 24 18 8B 94 24 A4 00 00 00 89 44 24 7C 89 54 24 1C E8 ?? ?? ?? ?? 8B 84 24 E0 00 00 00 8B 94 24 84 00 00 00 89 44 24 20 8B 84 24 E4 00 00 00 89 54 24 10 8B 94 24 8C 00 00 00 89 44 24 24 8B 84 24 E8 00 00 00 89 54 24 14 8B 94 24 90 00 00 00 89 44 24 28 8B 84 24 EC 00 00 00 89 54 24 18 8B 94 24 94 00 00 00 89 44 24 2C 89 54 24 1C E9 B5 FB FF FF 8B 54 24 4C 89 6C 24 10 89 7C 24 14 89 5C 24 1C 89 54 24 18 89 2C 24 89 7C 24 04 89 54 24 08 89 5C 24 0C E8 ?? ?? ?? ?? 8B 4C 24 40 85 C0 0F 84 69 FC FF FF 8B 54 24 54 C7 44 24 10 00 00 00 00 C7 44 24 14 00 00 00 00 C7 44 24 18 00 00 00 00 89 14 24 8B 54 24 58 C7 44 24 1C 00 00 00 00 89 54 24 04 8B 54 24 5C 89 54 24 08 8B 54 24 60 89 54 24 0C E8 ?? ?? ?? ?? 8B 4C 24 40 85 C0 0F 85 05 02 00 00 8B 54 24 6C C7 44 24 10 00 00 00 00 C7 44 24 14 00 00 00 00 C7 44 24 18 00 00 00 00 89 14 24 8B 54 24 64 C7 44 24 1C 00 00 00 00 89 54 24 04 8B 54 24 68 89 54 24 08 8B 54 24 50 89 54 24 0C E8 ?? ?? ?? ?? 8B 4C 24 40 85 C0 0F 85 B5 01 00 00 8B 94 24 98 00 00 00 89 54 24 10 8B 94 24 9C 00 00 00 89 54 24 14 8B 94 24 A0 00 00 00 89 54 24 18 8B 94 24 A4 00 00 00 89 54 24 1C 8B 94 24 98 00 00 00 89 14 24 8B 94 24 9C 00 00 00 89 54 24 04 8B 94 24 A0 00 00 00 89 54 24 08 8B 94 24 A4 00 00 00 89 54 24 0C E8 ?? ?? ?? ?? 8B 4C 24 40 85 C0 0F 85 BB 10 00 00 8B 54 24 6C C7 44 24 10 00 00 00 00 C7 44 24 14 00 00 00 00 C7 44 24 18 00 00 00 00 89 54 24 20 8B 54 24 64 C7 44 24 1C 00 00 FF 7F 89 34 24 89 4C 24 40 89 54 24 24 8B 54 24 68 89 54 24 28 8B 54 24 50 89 54 24 2C E8 ?? ?? ?? ?? 8B 94 24 98 00 00 00 8B 84 24 E0 00 00 00 8B 9C 24 E4 00 00 00 8B BC 24 E8 00 00 00 89 54 24 20 8B 94 24 9C 00 00 00 8B AC 24 EC 00 00 00 89 44 24 10 89 5C 24 14 89 54 24 24 8B 94 24 A0 00 00 00 89 7C 24 18 89 6C 24 1C 89 34 24 89 54 24 28 8B 94 24 A4 00 00 00 89 44 24 44 89 54 24 2C E8 ?? ?? ?? ?? 8B 94 24 E0 00 00 00 8B 44 24 44 89 5C 24 24 89 7C 24 28 89 54 24 48 8B 94 24 E4 00 00 00 89 6C 24 2C 89 44 24 20 89 34 24 89 54 24 74 8B 94 24 E8 00 00 00 89 54 24 70 8B 94 24 EC 00 00 00 89 54 24 7C 8B 94 24 84 00 00 00 89 54 24 10 8B 94 24 8C 00 00 00 89 54 24 14 8B 94 24 90 00 00 00 89 54 24 18 8B 94 24 94 00 00 00 89 54 24 1C E8 ?? ?? ?? ?? 8B 94 24 E8 00 00 00 8B AC 24 E0 00 00 00 8B BC 24 E4 00 00 00 8B 9C 24 EC 00 00 00 89 54 24 4C 8B 4C 24 40 E9 14 FA FF FF 8B 94 24 98 00 00 00 89 34 24 89 4C 24 40 89 54 24 20 8B 94 24 9C 00 00 00 89 54 24 24 8B 94 24 A0 00 00 00 89 54 24 28 8B 94 24 A4 00 00 00 89 54 24 2C 8B 94 24 98 00 00 00 89 54 24 10 8B 94 24 9C 00 00 00 89 54 24 14 8B 94 24 A0 00 00 00 89 54 24 18 8B 94 24 A4 00 00 00 89 54 24 1C E8 ?? ?? ?? ?? 8B 84 24 E4 00 00 00 8B 94 24 E0 00 00 00 89 44 24 14 8B 84 24 E8 00 00 00 89 54 24 10 89 14 24 8B 94 24 E4 00 00 00 89 44 24 18 8B 84 24 EC 00 00 00 89 54 24 04 8B 94 24 EC 00 00 00 89 44 24 1C 8B 84 24 E8 00 00 00 89 54 24 0C 89 44 24 08 E8 ?? ?? ?? ?? 8B 4C 24 40 85 C0 0F 95 C0 0F B6 D0 84 C0 89 94 24 A8 00 00 00 0F 85 DA 10 00 00 8B 94 24 84 00 00 00 89 34 24 89 4C 24 40 89 54 24 20 8B 94 24 8C 00 00 00 89 54 24 24 8B 94 24 90 00 00 00 89 54 24 28 8B 94 24 94 00 00 00 89 54 24 2C 8B 94 24 84 00 00 00 89 54 24 10 8B 94 24 8C 00 00 00 89 54 24 14 8B 94 24 90 00 00 00 89 54 24 18 8B 94 24 94 00 00 00 89 54 24 1C E8 ?? ?? ?? ?? 8B 84 24 E4 00 00 00 8B 94 24 E0 00 00 00 89 44 24 14 8B 84 24 E8 00 00 00 89 54 24 10 89 14 24 8B 94 24 E4 00 00 00 89 44 24 18 8B 84 24 EC 00 00 00 89 54 24 04 8B 94 24 EC 00 00 00 89 44 24 1C 8B 84 24 E8 00 00 00 89 54 24 0C 89 44 24 08 E8 ?? ?? ?? ?? 8B 4C 24 40 85 C0 0F 84 08 0F 00 00 8B 94 24 84 00 00 00 89 54 24 10 8B 94 24 8C 00 00 00 89 54 24 14 8B 94 24 90 00 00 00 89 54 24 18 8B 94 24 94 00 00 00 89 54 24 1C 8B 94 24 84 00 00 00 89 14 24 8B 94 24 8C 00 00 00 89 54 24 04 8B 94 24 90 00 00 00 89 54 24 08 8B 94 24 94 00 00 00 89 54 24 0C E8 ?? ?? ?? ?? 8B 4C 24 40 85 C0 0F 85 A0 0E 00 00 C7 84 24 80 00 00 00 00 00 00 00 8B 54 24 6C 89 34 24 89 4C 24 40 89 54 24 20 8B 54 24 64 89 54 24 24 8B 54 24 68 89 54 24 28 8B 54 24 50 89 54 24 2C 8B 54 24 6C 89 54 24 10 8B 54 24 64 89 54 24 14 8B 54 24 68 89 54 24 18 8B 54 24 50 89 54 24 1C E8 ?? ?? ?? ?? 8B 84 24 E4 00 00 00 8B 94 24 E0 00 00 00 89 44 24 14 8B 84 24 E8 00 00 00 89 54 24 10 89 14 24 8B 94 24 E4 00 00 00 89 44 24 18 8B 84 24 EC 00 00 00 89 54 24 04 8B 94 24 EC 00 00 00 89 44 24 1C 8B 84 24 E8 00 00 00 89 54 24 0C 89 44 24 08 E8 ?? ?? ?? ?? 8B 4C 24 40 85 C0 0F 85 E8 0D 00 00 8B 54 24 54 89 34 24 89 54 24 20 8B 54 24 58 89 54 24 24 8B 54 24 5C 89 54 24 28 8B 54 24 60 89 54 24 2C 8B 54 24 54 89 54 24 10 8B 54 24 58 89 54 24 14 8B 54 24 5C 89 54 24 18 8B 54 24 60 89 54 24 1C E8 ?? ?? ?? ?? 8B 84 24 E4 00 00 00 8B 94 24 E0 00 00 00 89 44 24 14 8B 84 24 E8 00 00 00 89 54 24 10 89 14 24 8B 94 24 E4 00 00 00 89 44 24 18 8B 84 24 EC 00 00 00 89 54 24 04 8B 94 24 EC 00 00 00 89 44 24 1C 8B 84 24 E8 00 00 00 89 54 24 0C 89 44 24 08 E8 ?? ?? ?? ?? 8B 4C 24 40 85 C0 0F 85 48 05 00 00 8B 94 24 98 00 00 00 8B 84 24 80 00 00 00 C7 44 24 10 00 00 00 00 C7 44 24 14 00 00 00 00 89 54 24 20 8B 94 24 9C 00 00 00 F7 D8 25 00 00 FF 3F 89 44 24 1C 89 54 24 24 8B 94 24 A0 00 00 00 C7 44 24 18 00 00 00 00 89 34 24 89 54 24 28 8B 94 24 A4 00 00 00 89 54 24 2C E8 ?? ?? ?? ?? 8B 94 24 E0 00 00 00 89 34 24 89 94 24 98 00 00 00 8B 94 24 E4 00 00 00 89 94 24 9C 00 00 00 8B 94 24 E8 00 00 00 89 94 24 A0 00 00 00 8B 94 24 EC 00 00 00 89 94 24 A4 00 00 00 8B 94 24 84 00 00 00 89 54 24 20 8B 94 24 8C 00 00 00 89 54 24 24 8B 94 24 90 00 00 00 89 54 24 28 8B 94 24 94 00 00 00 89 54 24 2C 8B 94 24 84 00 00 00 89 54 24 10 8B 94 24 8C 00 00 00 89 54 24 14 8B 94 24 90 00 00 00 89 54 24 18 8B 94 24 94 00 00 00 89 54 24 1C E8 ?? ?? ?? ?? 8B 94 24 E0 00 00 00 8B 84 24 E4 00 00 00 }
	condition:
		$1
}

rule file_77_0_0 {
	meta:
		name = "___bid_getd2"
		size = 96
		refs = "0043 ___bid128_quiet_greater_equal"
	strings:
		$1 = { 83 EC 4C 8B 44 24 60 89 44 24 10 8B 44 24 64 89 44 24 14 8B 44 24 68 89 44 24 18 8B 44 24 6C 89 44 24 1C 8B 44 24 50 89 04 24 8B 44 24 54 89 44 24 04 8B 44 24 58 89 44 24 08 8B 44 24 5C 89 44 24 0C E8 ?? ?? ?? ?? BA FF FF FF FF 85 C0 0F 44 C2 83 C4 4C C3 90 90 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_78_0_0 {
	meta:
		name = "___udivdi3"
		size = 272
	strings:
		$1 = { 83 EC 2C 8B 54 24 3C 89 7C 24 24 8B 4C 24 38 8B 7C 24 30 89 5C 24 1C 8B 5C 24 34 85 D2 89 74 24 20 89 CE 89 6C 24 28 89 FD 75 25 39 D9 77 59 85 C9 75 0B B8 01 00 00 00 31 D2 F7 F1 89 C1 89 D8 31 D2 F7 F1 89 C3 89 F8 F7 F1 89 DA EB 26 66 90 39 DA 77 1C 0F BD FA 83 F7 1F 75 36 39 E9 0F 86 8F 00 00 00 39 DA 0F 82 87 00 00 00 8D 74 26 00 31 D2 31 C0 8B 5C 24 1C 8B 74 24 20 8B 7C 24 24 8B 6C 24 28 83 C4 2C C3 89 F8 89 DA F7 F1 31 D2 EB E2 89 F9 B8 20 00 00 00 29 F8 D3 E2 89 C1 89 54 24 0C 89 F2 D3 EA 8B 4C 24 0C 09 CA 89 F9 D3 E6 89 C1 89 74 24 0C 89 DE D3 EE 89 F9 89 54 24 08 89 DA 89 EB D3 E2 89 C1 D3 EB 09 D3 89 F2 89 D8 F7 74 24 08 89 D6 89 C3 F7 64 24 0C 39 D6 72 1F 89 F9 D3 E5 39 C5 73 04 39 D6 74 13 89 D8 31 D2 EB 81 31 D2 B8 01 00 00 00 E9 75 FF FF FF 90 8D 43 FF 31 D2 E9 6A FF FF FF 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_80_0_0 {
	meta:
		name = "___bid_extendtftd"
		size = 96
		refs = "0030 ___binary128_to_bid128"
	strings:
		$1 = { 53 83 EC 48 8B 54 24 60 8D 44 24 20 89 04 24 8B 5C 24 50 89 54 24 04 8B 54 24 64 89 54 24 08 8B 54 24 68 89 54 24 0C 8B 54 24 6C 89 54 24 10 E8 ?? ?? ?? ?? 8B 44 24 20 89 03 8B 44 24 24 89 43 04 8B 44 24 28 89 43 08 8B 44 24 2C 89 43 0C 83 C4 48 89 D8 5B C3 90 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_208_0_0 {
	meta:
		name = "___bid_trunctdtf"
		size = 96
		refs = "0030 ___bid128_to_binary128"
	strings:
		$1 = { 53 83 EC 48 8B 54 24 60 8D 44 24 20 89 04 24 8B 5C 24 50 89 54 24 04 8B 54 24 64 89 54 24 08 8B 54 24 68 89 54 24 0C 8B 54 24 6C 89 54 24 10 E8 ?? ?? ?? ?? 8B 44 24 20 89 03 8B 44 24 24 89 43 04 8B 44 24 28 89 43 08 8B 44 24 2C 89 43 0C 83 C4 48 89 D8 5B C3 90 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_81_0_0 {
	meta:
		name = "___floatdidf"
		size = 48
		refs = "000b .rdata"
	strings:
		$1 = { 83 EC 14 31 D2 DB 44 24 1C D8 0D ?? ?? ?? ?? 8B 44 24 18 89 54 24 04 89 04 24 DF 2C 24 83 C4 14 DE C1 C3 90 90 90 90 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_83_0_0 {
	meta:
		name = "___floatundidf"
		size = 48
		refs = "001b .rdata"
	strings:
		$1 = { 83 EC 0C 31 D2 8B 44 24 14 89 54 24 04 31 D2 89 04 24 8B 44 24 10 DF 2C 24 D8 0D ?? ?? ?? ?? 89 54 24 04 89 04 24 DF 2C 24 83 C4 0C DE C1 C3 90 }
	condition:
		$1
}

rule file_84_0_0 {
	meta:
		name = "___bid_eqsd2"
		size = 96
		refs = "001b ___bid32_to_bid64 003b ___bid64_quiet_equal"
	strings:
		$1 = { 83 EC 1C 8B 44 24 20 89 5C 24 10 8B 5C 24 24 89 74 24 14 89 7C 24 18 89 04 24 E8 ?? ?? ?? ?? 89 1C 24 89 C6 89 D7 E8 ?? ?? ?? ?? 89 34 24 89 7C 24 04 89 44 24 08 89 54 24 0C E8 ?? ?? ?? ?? 8B 5C 24 10 8B 74 24 14 8B 7C 24 18 85 C0 0F 94 C0 83 C4 1C 0F B6 C0 C3 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_85_0_0 {
	meta:
		name = "___ashrdi3"
		size = 96
	strings:
		$1 = { 83 EC 0C 89 1C 24 8B 5C 24 18 89 74 24 04 8B 44 24 10 89 7C 24 08 8B 54 24 14 85 DB 74 1F BE 20 00 00 00 89 D7 29 DE 85 F6 7E 25 89 D9 D3 FF 89 F1 D3 E2 89 D9 D3 E8 09 C2 89 D0 89 FA 8B 1C 24 8B 74 24 04 8B 7C 24 08 83 C4 0C C3 8D 74 26 00 89 F1 F7 D9 C1 FF 1F D3 FA EB DE 90 90 90 90 90 }
	condition:
		$1
}

rule file_87_0_0 {
	meta:
		name = "___bid_truncxfdd"
		size = 32
		refs = "000b ___binary80_to_bid64"
	strings:
		$1 = { 83 EC 1C DB 6C 24 20 DB 3C 24 E8 ?? ?? ?? ?? 83 C4 1C C3 90 90 90 90 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_107_0_0 {
	meta:
		name = "___bid_truncxfsd"
		size = 32
		refs = "000b ___binary80_to_bid32"
	strings:
		$1 = { 83 EC 1C DB 6C 24 20 DB 3C 24 E8 ?? ?? ?? ?? 83 C4 1C C3 90 90 90 90 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_88_0_0 {
	meta:
		name = "___mulxc3"
		size = 1088
		refs = "019b .rdata"
	strings:
		$1 = { 53 83 EC 24 DB 6C 24 3C 8B 54 24 2C DB 6C 24 48 DB 6C 24 30 DC C9 DB 6C 24 54 D8 CB DB 6C 24 54 DE CA DB 6C 24 48 D8 CC D9 C3 D8 E2 D9 C3 D8 C2 D9 C9 DB E8 7A 2E DD DD DD DD DD D8 DD D8 DD D8 EB 16 DD DE DD DC DD D8 DD D8 DD D8 EB 0A DD DB DD D9 EB 04 DD DA D9 C9 DB 3A 89 D0 DB 7A 0C 83 C4 24 5B C3 D9 C9 DB E8 7B D8 DB 6C 24 30 D8 E0 DB 7C 24 18 DB 6C 24 18 DF E8 7B 07 E9 B7 02 00 00 DD D8 D9 C6 D8 E7 DB 7C 24 18 DB 6C 24 18 DF E8 7B 07 E9 EF 01 00 00 D9 CE 31 C0 DB 6C 24 48 DB E8 D8 E0 0F 9A C3 DB 7C 24 18 DB 6C 24 18 DF E8 0F 8A 90 01 00 00 DB 6C 24 54 DB E8 D8 E0 0F 9A C1 DB 7C 24 18 DB 6C 24 18 DF E8 0F 8A E6 00 00 00 84 C0 0F 85 A1 00 00 00 D9 C5 D8 E6 DB 7C 24 18 DB 6C 24 18 DF E8 0F 8A 36 03 00 00 DD DD D9 C9 D9 CA D9 CB D9 CC D9 C3 D8 E4 DF E8 0F 8A 0D 03 00 00 DD DB D9 C9 D9 CA D9 C3 D8 E4 DF E8 0F 8A E8 02 00 00 DD DB D9 C9 D9 CA D9 C2 D8 E3 DF E8 0F 8B 26 FF FF FF D9 CA DF E8 0F 8A 22 FF FF FF DD D8 DD D8 EB 1C DD D8 DD D8 DD D8 EB 14 DD D8 DD D8 DD D8 DD D8 EB 0A DD D8 DD D8 DD D8 DD D8 DD D8 DB 6C 24 30 DB E8 0F 8A 82 02 00 00 DD D8 DB E8 0F 8A 5C 02 00 00 84 DB 0F 85 34 02 00 00 84 C9 74 11 E9 FD 01 00 00 DD D8 DD D8 DD D8 DD D8 DD D8 DD D8 DB 6C 24 48 DB 6C 24 30 DC C9 DB 6C 24 54 D8 CB DE EA D9 05 ?? ?? ?? ?? DC CA DB 6C 24 54 DE CA DB 6C 24 48 DE CC D9 C9 DE C3 DE CA E9 A0 FE FF FF 84 C9 0F 85 12 FF FF FF DD D8 DD D8 DD D8 DD D8 DD D8 DD D8 DB 6C 24 48 D9 E5 DF E0 DD D8 F6 C4 02 D9 EE 74 06 DD D8 D9 EE D9 E0 DB 7C 24 48 D9 E8 DB 6C 24 54 D9 E5 DF E0 DD D8 F6 C4 02 D9 E1 74 02 D9 E0 DB 7C 24 54 DB 6C 24 30 DB E8 7A 26 DD D8 DB E8 0F 8B 75 FF FF FF D9 E5 DF E0 DD D8 F6 C4 02 D9 EE 0F 84 64 FF FF FF DD D8 D9 EE D9 E0 E9 59 FF FF FF D9 E5 DF E0 DD D8 F6 C4 02 D9 EE 74 06 DD D8 D9 EE D9 E0 DB 7C 24 30 EB C3 84 DB 0F 85 68 FE FF FF DD D8 DD D8 DD D8 DD D8 DD D8 DD D8 DB 6C 24 48 D9 E5 DF E0 DD D8 F6 C4 02 D9 E8 74 06 DD D8 D9 E8 D9 E0 DB 7C 24 48 DB 6C 24 54 D8 E0 DF E8 7A 63 D9 EE E9 62 FF FF FF D9 CE DB E8 0F 8A 07 FE FF FF DB 6C 24 30 D9 E5 DF E0 DD D8 F6 C4 02 D9 EE 74 06 DD D8 D9 EE D9 E0 DB 7C 24 30 D9 E8 DB 7C 24 18 D9 E5 DF E0 DD D8 DB 6C 24 18 F6 C4 02 D9 E1 74 02 D9 E0 DB 6C 24 48 DB E8 7A 48 DD D8 DB 6C 24 54 DF E8 7A 1A D9 CE B8 01 00 00 00 E9 B9 FD FF FF DB 6C 24 54 DF E8 0F 8B F8 FE FF FF EB 8F DB 6C 24 54 D9 E5 DF E0 DD D8 D9 EE F6 C4 02 DB 3C 24 74 07 D9 EE D9 E0 DB 3C 24 DB 2C 24 DB 7C 24 54 EB C2 D9 E5 DF E0 DD D8 D9 EE F6 C4 02 DB 7C 24 0C 74 08 D9 EE D9 E0 DB 7C 24 0C DB 6C 24 0C DB 7C 24 48 EB 97 DB 6C 24 30 DB E8 0F 8A 3D FD FF FF D9 E5 DF E0 DD D8 F6 C4 02 D9 E8 74 06 DD D8 D9 E8 D9 E0 DB 7C 24 30 D9 C6 D8 E7 DB 7C 24 18 DB 6C 24 18 DF E8 7A 2D D9 EE DB 7C 24 18 D9 CE E9 3A FF FF FF DB 6C 24 54 D9 E5 DF E0 DD D8 F6 C4 02 D9 EE 74 06 DD D8 D9 EE D9 E0 DB 7C 24 54 E9 EF FD FF FF D9 CE DB E8 0F 8B 0A FF FF FF D9 CE EB C5 DB 6C 24 48 D9 E5 DF E0 DD D8 F6 C4 02 D9 EE 74 06 DD D8 D9 EE D9 E0 DB 7C 24 48 E9 AC FD FF FF D9 E5 DF E0 DD D8 F6 C4 02 D9 EE 0F 84 93 FD FF FF DD D8 D9 EE D9 E0 E9 88 FD FF FF D9 E5 DF E0 DD D8 F6 C4 02 D9 EE 74 06 DD D8 D9 EE D9 E0 DB 7C 24 30 E9 64 FD FF FF D9 CB DF E8 0F 8B 30 FD FF FF D9 C9 D9 CA E9 0B FD FF FF D9 CB DF E8 0F 8B 25 FD FF FF D9 C9 D9 CA E9 E6 FC FF FF D9 CD DF E8 0F 8B 1C FD FF FF D9 C9 D9 CA D9 CB D9 CC E9 BD FC FF FF 90 90 90 90 90 }
	condition:
		$1
}

rule file_89_0_0 {
	meta:
		name = "___bid64_to_int32_rnint"
		size = 1152
		refs = "009d ___bid_nr_digits 00eb ___bid_midpoint64 019c ___bid_ten2k64 0231 ___bid_ten2mk64 02ae ___bid_shiftright128 02da ___bid_maskhigh128 0309 ___bid_ten2mk128trunc 03d2 ___bid_IDEC_glbflags"
	strings:
		$1 = { 83 EC 4C 89 74 24 40 8B 74 24 54 89 5C 24 3C 8B 54 24 50 89 7C 24 44 89 6C 24 48 89 F0 25 00 00 00 7C 3D 00 00 00 7C 0F 84 A3 03 00 00 89 F0 25 00 00 00 78 3D 00 00 00 78 0F 84 91 03 00 00 89 F0 25 00 00 00 60 3D 00 00 00 60 0F 84 CF 00 00 00 89 F3 89 D1 81 E3 FF FF 1F 00 31 C0 89 DA 09 CA 0F 84 9F 00 00 00 89 4C 24 30 89 F7 89 5C 24 34 81 E7 00 00 E0 7F DF 6C 24 30 C1 EF 15 DD 5C 24 10 8B 54 24 14 89 D0 C1 E8 14 25 FF 07 00 00 2D FE 03 00 00 83 E8 01 C1 E0 05 8B 90 ?? ?? ?? ?? 85 D2 75 12 39 98 ?? ?? ?? ?? 8B 90 ?? ?? ?? ?? 0F 86 49 01 00 00 81 EF 8E 01 00 00 8D 2C 3A 83 FD 0A 0F 8F 07 03 00 00 81 E6 00 00 00 80 83 FD 0A 0F 84 A0 00 00 00 31 C0 83 FD 00 7C 27 0F 85 FB 00 00 00 83 EA 01 39 1C D5 ?? ?? ?? ?? 77 13 0F 82 4C 02 00 00 39 0C D5 ?? ?? ?? ?? 0F 82 3F 02 00 00 31 C0 8B 5C 24 3C 8B 74 24 40 8B 7C 24 44 8B 6C 24 48 83 C4 4C C3 8D B6 00 00 00 00 89 F0 89 D1 25 FF FF 07 00 89 C3 81 CB 00 00 20 00 81 FB F2 86 23 00 77 CB 72 08 81 FA FF FF C0 6F 77 C1 31 D2 89 F7 89 54 24 34 81 E7 00 00 F8 1F 89 5C 24 30 C1 EF 13 DF 6C 24 30 DD 5C 24 10 8B 54 24 14 89 D0 C1 E8 14 25 FF 07 00 00 2D DE 03 00 00 E9 1D FF FF FF 85 F6 0F 84 F0 01 00 00 83 FA 0B 0F 8F 67 02 00 00 C7 44 24 10 0B 00 00 00 29 54 24 10 8B 44 24 10 8B 2C C5 ?? ?? ?? ?? 8B 14 C5 ?? ?? ?? ?? 8B 04 C5 ?? ?? ?? ?? 0F AF EB 0F AF D1 01 EA 89 54 24 18 F7 E1 8B 6C 24 18 01 EA 83 FA 05 89 44 24 10 89 54 24 14 72 11 0F 87 FB 01 00 00 83 7C 24 10 05 0F 87 F0 01 00 00 83 FF 00 7C 31 0F 85 68 01 00 00 85 F6 89 C8 90 0F 84 10 FF FF FF F7 D8 E9 09 FF FF FF 8D 76 00 72 0C 39 88 ?? ?? ?? ?? 0F 87 A9 FE FF FF 83 C2 01 E9 A1 FE FF FF F7 D7 03 0C FD ?? ?? ?? ?? 13 1C FD ?? ?? ?? ?? 89 7C 24 10 89 DD 89 FB 8B 3C FD ?? ?? ?? ?? 89 E8 8B 1C DD ?? ?? ?? ?? F7 E7 89 44 24 18 89 E8 89 54 24 1C F7 E3 89 44 24 28 89 C8 89 54 24 2C F7 E7 89 54 24 24 8B 6C 24 24 31 D2 89 44 24 20 8B 44 24 18 89 EF 31 ED 89 3C 24 01 04 24 89 C8 89 6C 24 04 11 54 24 04 F7 E3 01 04 24 11 54 24 04 8B 54 24 1C 8B 5C 24 04 89 D0 31 D2 03 44 24 28 89 D9 13 54 24 2C 31 DB 01 C8 11 DA 8B 5C 24 10 89 C7 89 D5 8B 1C 9D ?? ?? ?? ?? 89 5C 24 0C 0F B6 4C 24 0C 31 DB 0F AD D7 D3 ED F6 C1 20 0F 45 FD 0F 45 EB 89 6C 24 1C 8B 6C 24 10 89 7C 24 18 23 04 ED ?? ?? ?? ?? 23 14 ED ?? ?? ?? ?? 09 C2 75 47 8B 04 24 31 ED 8B 7C 24 20 89 C2 31 C0 01 F8 11 EA 89 D1 09 C1 74 30 8B 7C 24 10 C1 E7 04 3B 97 ?? ?? ?? ?? 77 21 72 08 3B 87 ?? ?? ?? ?? 77 17 8B 44 24 18 83 E0 01 85 C0 74 0C 83 44 24 18 FF 83 54 24 1C FF 66 90 85 F6 8B 44 24 18 0F 84 CA FD FF FF F7 D8 E9 C3 FD FF FF 83 FE 01 19 C0 83 E0 02 83 E8 01 E9 B3 FD FF FF 85 F6 0F 84 86 00 00 00 8B 04 FD ?? ?? ?? ?? F7 D9 0F AF C1 E9 9A FD FF FF 8D 74 26 00 83 FA 0B 0F 8F B9 00 00 00 C7 44 24 10 0B 00 00 00 29 54 24 10 8B 44 24 10 8B 2C C5 ?? ?? ?? ?? 8B 14 C5 ?? ?? ?? ?? 8B 04 C5 ?? ?? ?? ?? 0F AF EB 0F AF D1 01 EA 89 54 24 18 F7 E1 8B 6C 24 18 01 EA 83 FA 04 89 44 24 10 89 54 24 14 0F 82 1D FE FF FF 77 0B 83 7C 24 10 FA 0F 86 10 FE FF FF 83 0D ?? ?? ?? ?? 01 B8 00 00 00 80 E9 25 FD FF FF 8B 04 FD ?? ?? ?? ?? 0F AF C1 E9 16 FD FF FF 83 EA 0B 8B 2C D5 ?? ?? ?? ?? 8B 04 D5 ?? ?? ?? ?? 8D 6C AD 00 8D 04 80 01 C5 B8 05 00 00 00 F7 24 D5 ?? ?? ?? ?? 01 EA 39 DA 0F 87 C0 FD FF FF 72 AE 39 C8 0F 83 B6 FD FF FF 8D B6 00 00 00 00 EB 9E 83 EA 0B 6B 04 D5 ?? ?? ?? ?? FB 8B 2C D5 ?? ?? ?? ?? 8D 2C A8 B8 FB FF FF FF F7 24 D5 ?? ?? ?? ?? 01 EA 39 DA 0F 87 83 FD FF FF 0F 82 6D FF FF FF 39 C8 0F 87 75 FD FF FF 90 8D 74 26 00 E9 5B FF FF FF 8D 74 26 00 8D BC 27 00 00 00 00 }
	condition:
		$1
}

rule file_89_1_0 {
	meta:
		name = "___bid64_to_int32_xrnint"
		size = 1472
		refs = "009d ___bid_nr_digits 00e9 ___bid_midpoint64 00f7 ___bid_IDEC_glbflags 0169 ___bid_ten2k64 0222 ___bid_ten2mk64 02ce ___bid_shiftright128 02e0 ___bid_maskhigh128 0321 ___bid_onehalf128 0376 ___bid_ten2mk128trunc"
	strings:
		$1 = { 83 EC 4C 89 74 24 40 8B 74 24 54 89 5C 24 3C 8B 54 24 50 89 7C 24 44 89 6C 24 48 89 F0 25 00 00 00 7C 3D 00 00 00 7C 0F 84 43 04 00 00 89 F0 25 00 00 00 78 3D 00 00 00 78 0F 84 31 04 00 00 89 F0 25 00 00 00 60 3D 00 00 00 60 0F 84 BF 00 00 00 89 F3 89 D1 81 E3 FF FF 1F 00 31 C0 89 DA 09 CA 0F 84 95 00 00 00 89 4C 24 30 89 F7 89 5C 24 34 81 E7 00 00 E0 7F DF 6C 24 30 C1 EF 15 DD 5C 24 10 8B 54 24 14 89 D0 C1 E8 14 25 FF 07 00 00 2D FE 03 00 00 83 E8 01 C1 E0 05 8B 90 ?? ?? ?? ?? 85 D2 75 12 39 98 ?? ?? ?? ?? 8B 90 ?? ?? ?? ?? 0F 86 19 01 00 00 81 EF 8E 01 00 00 8D 04 3A 83 F8 0A 0F 8F A7 03 00 00 81 E6 00 00 00 80 83 F8 0A 74 6E 83 F8 00 0F 8C 0B 03 00 00 0F 85 CD 00 00 00 83 EA 01 39 1C D5 ?? ?? ?? ?? 0F 86 F3 00 00 00 31 C0 83 0D ?? ?? ?? ?? 20 8B 5C 24 3C 8B 74 24 40 8B 7C 24 44 8B 6C 24 48 83 C4 4C C3 89 F0 89 D1 25 FF FF 07 00 89 C3 81 CB 00 00 20 00 81 FB F2 86 23 00 77 12 0F 82 84 02 00 00 81 FA FF FF C0 6F 0F 86 78 02 00 00 31 C0 8D 76 00 EB BA 85 F6 0F 84 C6 02 00 00 83 FA 0B 8D 76 00 0F 8F 3A 03 00 00 C7 44 24 10 0B 00 00 00 29 54 24 10 8B 44 24 10 8B 2C C5 ?? ?? ?? ?? 8B 14 C5 ?? ?? ?? ?? 8B 04 C5 ?? ?? ?? ?? 0F AF EB 0F AF D1 01 EA 89 54 24 18 F7 E1 8B 6C 24 18 01 EA 83 FA 05 89 44 24 10 89 54 24 14 72 14 0F 87 CE 02 00 00 83 7C 24 10 05 0F 87 C3 02 00 00 8D 76 00 83 FF 00 7C 50 0F 85 3B 02 00 00 85 F6 89 C8 90 0F 84 36 FF FF FF F7 D8 E9 2F FF FF FF 8D 76 00 72 0C 39 88 ?? ?? ?? ?? 0F 87 D9 FE FF FF 83 C2 01 E9 D1 FE FF FF 72 0D 39 0C D5 ?? ?? ?? ?? 0F 83 FE FE FF FF 83 FE 01 19 C0 83 E0 02 83 E8 01 E9 F0 FE FF FF 89 FD F7 D5 03 0C ED ?? ?? ?? ?? 13 1C ED ?? ?? ?? ?? 89 4C 24 2C 89 5C 24 10 8B 1C ED ?? ?? ?? ?? 8B 44 24 10 F7 E3 89 44 24 18 8B 44 24 10 89 54 24 1C F7 24 ED ?? ?? ?? ?? 89 44 24 10 89 C8 89 54 24 14 F7 E3 89 54 24 24 8B 5C 24 24 31 D2 89 44 24 20 8B 44 24 18 89 D9 31 DB 89 4C 24 08 8B 4C 24 1C 01 44 24 08 8B 04 ED ?? ?? ?? ?? 89 5C 24 0C 11 54 24 0C F7 64 24 2C 01 44 24 08 11 54 24 0C 89 CA 31 C9 89 14 24 89 4C 24 04 8B 54 24 0C 8B 4C 24 10 01 0C 24 8B 5C 24 14 11 5C 24 04 89 D0 31 D2 8B 4C 24 20 01 04 24 8B 44 24 08 11 54 24 04 31 DB 89 C2 31 C0 89 44 24 10 8B 04 24 01 4C 24 10 0F B6 0C AD ?? ?? ?? ?? 89 54 24 14 8B 14 24 11 5C 24 14 23 14 ED ?? ?? ?? ?? 8B 5C 24 04 23 1C ED ?? ?? ?? ?? 89 54 24 18 8B 54 24 04 89 5C 24 2C 31 DB 0F AD D0 D3 EA F6 C1 20 0F 45 C2 0F 45 D3 F7 DF 83 FF 03 89 44 24 08 89 54 24 0C 0F 8E F7 01 00 00 8B 04 ED ?? ?? ?? ?? 39 44 24 2C 8B 3C ED ?? ?? ?? ?? 77 1E 72 06 39 7C 24 18 77 16 33 44 24 2C 33 7C 24 18 09 F8 0F 84 1F 02 00 00 8D B6 00 00 00 00 83 0D ?? ?? ?? ?? 20 8B 44 24 2C 0B 44 24 18 75 3F 8B 54 24 14 0B 54 24 10 74 35 89 E8 8B 4C 24 14 C1 E0 04 3B 88 ?? ?? ?? ?? 77 24 72 0C 8B 5C 24 10 3B 98 ?? ?? ?? ?? 77 16 8B 44 24 08 83 E0 01 85 C0 74 0B 83 44 24 08 FF 83 54 24 0C FF 90 85 F6 8B 44 24 08 0F 84 50 FD FF FF F7 D8 E9 49 FD FF FF 31 D2 89 F7 89 54 24 34 81 E7 00 00 F8 1F 89 5C 24 30 C1 EF 13 DF 6C 24 30 DD 5C 24 10 8B 54 24 14 89 D0 C1 E8 14 25 FF 07 00 00 2D DE 03 00 00 E9 AD FC FF FF 83 0D ?? ?? ?? ?? 20 31 C0 E9 06 FD FF FF 85 F6 0F 84 83 00 00 00 8B 04 FD ?? ?? ?? ?? F7 D9 0F AF C1 E9 ED FC FF FF 90 83 FA 0B 0F 8F B9 00 00 00 C7 44 24 10 0B 00 00 00 29 54 24 10 8B 44 24 10 8B 2C C5 ?? ?? ?? ?? 8B 14 C5 ?? ?? ?? ?? 8B 04 C5 ?? ?? ?? ?? 0F AF EB 0F AF D1 01 EA 89 54 24 18 F7 E1 8B 6C 24 18 01 EA 83 FA 04 89 44 24 10 89 54 24 14 0F 82 4D FD FF FF 77 0B 83 7C 24 10 FA 0F 86 40 FD FF FF 83 0D ?? ?? ?? ?? 01 B8 00 00 00 80 E9 7B FC FF FF 8B 04 FD ?? ?? ?? ?? 0F AF C1 E9 6C FC FF FF 83 EA 0B 8B 2C D5 ?? ?? ?? ?? 8B 04 D5 ?? ?? ?? ?? 8D 6C AD 00 8D 04 80 01 C5 B8 05 00 00 00 F7 24 D5 ?? ?? ?? ?? 01 EA 39 DA 0F 87 F0 FC FF FF 72 AE 39 C8 0F 83 E6 FC FF FF 8D B6 00 00 00 00 EB 9E 83 EA 0B 6B 04 D5 ?? ?? ?? ?? FB 8B 2C D5 ?? ?? ?? ?? 8D 2C A8 B8 FB FF FF FF F7 24 D5 ?? ?? ?? ?? 01 EA 39 DA 0F 87 B3 FC FF FF 0F 82 6D FF FF FF 39 C8 0F 87 A5 FC FF FF 90 8D 74 26 00 E9 5B FF FF FF 81 7C 24 14 00 00 00 80 0F 82 2D FE FF FF 77 0B 83 7C 24 10 00 0F 86 20 FE FF FF 8B 4C 24 10 89 E8 8B 5C 24 14 83 C1 00 81 D3 00 00 00 80 C1 E0 04 3B 98 ?? ?? ?? ?? 0F 82 05 FE FF FF 0F 87 F8 FD FF FF 3B 88 ?? ?? ?? ?? 0F 86 F3 FD FF FF E9 E7 FD FF FF 8B 54 24 14 0B 54 24 10 0F 84 D9 FD FF FF 89 E8 8B 4C 24 14 C1 E0 04 3B 88 ?? ?? ?? ?? 73 18 8B 44 24 2C 0B 44 24 18 0F 84 D5 FD FF FF E9 05 FE FF FF 90 8D 74 26 00 0F 87 AA FD FF FF 8B 5C 24 10 3B 98 ?? ?? ?? ?? 76 D6 E9 99 FD FF FF 89 F6 8D BC 27 00 00 00 00 }
	condition:
		$1
}

rule file_89_2_0 {
	meta:
		name = "___bid64_to_int32_floor"
		size = 1136
		refs = "009d ___bid_nr_digits 014b ___bid_ten2k64 0212 ___bid_IDEC_glbflags 0239 ___bid_ten2mk64 02dd ___bid_maskhigh128 02e4 ___bid_shiftright128 0326 ___bid_ten2mk128trunc"
	strings:
		$1 = { 83 EC 4C 89 74 24 40 8B 74 24 54 89 5C 24 3C 8B 54 24 50 89 7C 24 44 89 6C 24 48 89 F0 25 00 00 00 7C 3D 00 00 00 7C 0F 84 E3 01 00 00 89 F0 25 00 00 00 78 3D 00 00 00 78 0F 84 D1 01 00 00 89 F0 25 00 00 00 60 3D 00 00 00 60 0F 84 C3 00 00 00 89 F3 89 D1 81 E3 FF FF 1F 00 31 C0 89 DA 09 CA 0F 84 99 00 00 00 89 4C 24 30 89 F7 89 5C 24 34 81 E7 00 00 E0 7F DF 6C 24 30 C1 EF 15 DD 5C 24 08 8B 54 24 0C 89 D0 C1 E8 14 25 FF 07 00 00 2D FE 03 00 00 83 E8 01 C1 E0 05 8B A8 ?? ?? ?? ?? 85 ED 75 12 39 98 ?? ?? ?? ?? 8B A8 ?? ?? ?? ?? 0F 86 9F 00 00 00 81 EF 8E 01 00 00 8D 44 3D 00 83 F8 0A 0F 8F 46 01 00 00 81 E6 00 00 00 80 83 F8 0A 0F 84 CC 00 00 00 85 C0 0F 8E 40 01 00 00 83 FF 00 0F 8C 46 01 00 00 8D B6 00 00 00 00 75 4E 85 F6 89 C8 74 08 F7 D8 8D B6 00 00 00 00 8B 5C 24 3C 8B 74 24 40 8B 7C 24 44 8B 6C 24 48 83 C4 4C C3 89 F0 89 D1 25 FF FF 07 00 89 C3 81 CB 00 00 20 00 81 FB F2 86 23 00 77 0A 72 41 81 FA FF FF C0 6F 76 39 31 C0 EB C5 90 8D 74 26 00 85 F6 0F 84 3D 02 00 00 8B 04 FD ?? ?? ?? ?? F7 D9 0F AF C1 EB AA 72 0C 39 88 ?? ?? ?? ?? 0F 87 53 FF FF FF 83 C5 01 E9 4B FF FF FF 8D 74 26 00 31 D2 89 F7 89 54 24 34 81 E7 00 00 F8 1F 89 5C 24 30 C1 EF 13 DF 6C 24 30 DD 5C 24 08 8B 54 24 0C 89 D0 C1 E8 14 25 FF 07 00 00 2D DE 03 00 00 E9 F0 FE FF FF 85 F6 0F 84 A6 01 00 00 83 FD 0B 0F 8F 8A 02 00 00 C7 44 24 08 0B 00 00 00 29 6C 24 08 8B 44 24 08 8B 2C C5 ?? ?? ?? ?? 8B 14 C5 ?? ?? ?? ?? 8B 04 C5 ?? ?? ?? ?? 0F AF EB 0F AF D1 01 EA 89 54 24 10 F7 E1 8B 6C 24 10 01 EA 83 FA 05 89 44 24 08 89 54 24 0C 0F 82 E1 FE FF FF 77 0E 83 7C 24 08 00 0F 86 D4 FE FF FF 8D 76 00 83 0D ?? ?? ?? ?? 01 B8 00 00 00 80 E9 DF FE FF FF 83 FE 01 19 C0 F7 D0 E9 D3 FE FF FF 8D 76 00 89 F8 89 CD F7 D0 8B 0C C5 ?? ?? ?? ?? 8B 14 C5 ?? ?? ?? ?? 89 44 24 1C 89 C8 89 54 24 18 F7 E3 89 44 24 08 8B 44 24 18 89 54 24 0C F7 E3 89 44 24 28 89 C8 89 54 24 2C F7 E5 89 54 24 24 8B 5C 24 24 31 D2 89 44 24 20 8B 44 24 08 89 D9 31 DB 01 C1 8B 44 24 18 11 D3 F7 E5 01 C1 11 D3 8B 54 24 0C 89 4C 24 14 89 D0 31 D2 89 44 24 08 8B 44 24 28 01 44 24 08 89 54 24 0C 8B 54 24 2C 11 54 24 0C 31 D2 01 5C 24 08 11 54 24 0C 31 C0 31 D2 89 44 24 10 8B 44 24 20 01 44 24 10 11 54 24 14 8B 6C 24 1C 8B 54 24 0C 89 E8 8B 1C ED ?? ?? ?? ?? 8B 0C 85 ?? ?? ?? ?? 8B 44 24 08 8B 2C ED ?? ?? ?? ?? 89 4C 24 04 0F B6 4C 24 04 0F AD D0 D3 EA F6 C1 20 74 04 89 D0 31 D2 F7 DF 83 FF 03 89 44 24 20 89 54 24 24 7F 7B 8B 5C 24 1C 8B 54 24 14 C1 E3 04 3B 93 ?? ?? ?? ?? 72 16 0F 87 9E 00 00 00 8B 4C 24 10 3B 8B ?? ?? ?? ?? 0F 87 8E 00 00 00 85 F6 0F 85 98 00 00 00 8B 44 24 20 E9 AD FD FF FF 83 FD 0B 0F 8E 94 00 00 00 8B 14 ED ?? ?? ?? ?? 31 C0 8D 14 92 39 DA 0F 87 71 FD FF FF 0F 82 9A FE FF FF 39 C8 0F 87 63 FD FF FF 66 90 E9 8B FE FF FF 8B 04 FD ?? ?? ?? ?? 0F AF C1 E9 6C FD FF FF 8B 44 24 08 21 D8 8B 5C 24 0C 21 EB 09 C3 75 2C 8B 5C 24 1C 8B 6C 24 14 C1 E3 04 3B AB ?? ?? ?? ?? 72 8B 77 17 8B 44 24 10 3B 83 ?? ?? ?? ?? 0F 86 79 FF FF FF 8D B4 26 00 00 00 00 85 F6 0F 84 72 FF FF FF 83 44 24 20 01 83 54 24 24 00 8B 44 24 20 F7 D8 E9 13 FD FF FF 8D 76 00 C7 44 24 08 0B 00 00 00 29 6C 24 08 8B 44 24 08 8B 2C C5 ?? ?? ?? ?? 8B 14 C5 ?? ?? ?? ?? 8B 04 C5 ?? ?? ?? ?? 0F AF EB 0F AF D1 01 EA 89 54 24 10 F7 E1 8B 6C 24 10 01 EA 83 FA 04 89 44 24 08 89 54 24 0C 0F 86 A7 FC FF FF E9 D1 FD FF FF 90 8B 14 ED ?? ?? ?? ?? 31 C0 8D 14 92 39 DA 0F 87 8D FC FF FF 0F 82 B6 FD FF FF 39 C8 0F 83 7F FC FF FF E9 A9 FD FF FF 89 F6 8D BC 27 00 00 00 00 }
	condition:
		$1
}

rule file_89_3_0 {
	meta:
		name = "___bid64_to_int32_xfloor"
		size = 1120
		refs = "009b ___bid_nr_digits 00f9 ___bid_ten2k64 0106 ___bid_IDEC_glbflags 022a ___bid_ten2mk64 02ce ___bid_maskhigh128 02d5 ___bid_shiftright128 0317 ___bid_ten2mk128trunc"
	strings:
		$1 = { 83 EC 4C 89 74 24 40 8B 74 24 54 89 5C 24 3C 8B 54 24 50 89 7C 24 44 89 6C 24 48 89 F0 25 00 00 00 7C 3D 00 00 00 7C 0F 84 E3 01 00 00 89 F0 25 00 00 00 78 3D 00 00 00 78 0F 84 D1 01 00 00 89 F0 25 00 00 00 60 3D 00 00 00 60 0F 84 DF 00 00 00 89 F3 89 D1 81 E3 FF FF 1F 00 89 D8 09 D0 0F 84 AF 00 00 00 89 54 24 30 89 F7 89 5C 24 34 81 E7 00 00 E0 7F DF 6C 24 30 C1 EF 15 DD 5C 24 08 8B 54 24 0C 89 D0 C1 E8 14 25 FF 07 00 00 2D FE 03 00 00 83 E8 01 C1 E0 05 8B A8 ?? ?? ?? ?? 85 ED 75 12 3B 98 ?? ?? ?? ?? 8B A8 ?? ?? ?? ?? 0F 83 DD 00 00 00 81 EF 8E 01 00 00 8D 44 3D 00 83 F8 0A 0F 8F 48 01 00 00 81 E6 00 00 00 80 83 F8 0A 0F 84 D1 00 00 00 85 C0 7E 29 83 FF 00 0F 8C 3D 01 00 00 0F 84 9E 00 00 00 85 F6 8D 74 26 00 0F 84 80 02 00 00 8B 04 FD ?? ?? ?? ?? F7 D9 0F AF C1 EB 12 83 0D ?? ?? ?? ?? 20 85 F6 B8 FF FF FF FF 75 02 31 C0 8B 5C 24 3C 8B 74 24 40 8B 7C 24 44 8B 6C 24 48 83 C4 4C C3 8D B6 00 00 00 00 89 F0 89 D1 25 FF FF 07 00 89 C3 81 CB 00 00 20 00 81 FB F2 86 23 00 77 CB 72 08 81 FA FF FF C0 6F 77 C1 31 D2 89 F7 89 54 24 34 81 E7 00 00 F8 1F 89 5C 24 30 C1 EF 13 DF 6C 24 30 DD 5C 24 08 8B 54 24 0C 89 D0 C1 E8 14 25 FF 07 00 00 2D DE 03 00 00 E9 0B FF FF FF 85 F6 89 C8 74 88 F7 D8 EB 84 77 0C 3B 88 ?? ?? ?? ?? 0F 82 15 FF FF FF 83 C5 01 E9 0D FF FF FF 85 F6 0F 84 96 01 00 00 83 FD 0B 0F 8F 77 02 00 00 C7 44 24 08 0B 00 00 00 29 6C 24 08 8B 44 24 08 8B 2C C5 ?? ?? ?? ?? 8B 14 C5 ?? ?? ?? ?? 8B 04 C5 ?? ?? ?? ?? 0F AF EB 0F AF D1 01 EA 89 54 24 10 F7 E1 8B 6C 24 10 01 EA 83 FA 05 89 44 24 08 89 54 24 0C 0F 82 D8 FE FF FF 77 0B 83 7C 24 08 00 0F 86 CB FE FF FF 83 0D ?? ?? ?? ?? 01 B8 00 00 00 80 E9 F5 FE FF FF 89 F8 89 CD F7 D0 8B 0C C5 ?? ?? ?? ?? 8B 14 C5 ?? ?? ?? ?? 89 44 24 1C 89 C8 89 54 24 18 F7 E3 89 44 24 08 8B 44 24 18 89 54 24 0C F7 E3 89 44 24 28 89 C8 89 54 24 2C F7 E5 89 54 24 24 8B 5C 24 24 31 D2 89 44 24 20 8B 44 24 08 89 D9 31 DB 01 C1 8B 44 24 18 11 D3 F7 E5 01 C1 11 D3 8B 54 24 0C 89 4C 24 14 89 D0 31 D2 89 44 24 08 8B 44 24 28 01 44 24 08 89 54 24 0C 8B 54 24 2C 11 54 24 0C 31 D2 01 5C 24 08 11 54 24 0C 31 C0 31 D2 89 44 24 10 8B 44 24 20 01 44 24 10 11 54 24 14 8B 6C 24 1C 8B 54 24 0C 89 E8 8B 1C ED ?? ?? ?? ?? 8B 0C 85 ?? ?? ?? ?? 8B 44 24 08 8B 2C ED ?? ?? ?? ?? 89 4C 24 04 0F B6 4C 24 04 0F AD D0 D3 EA F6 C1 20 74 04 89 D0 31 D2 F7 DF 83 FF 03 89 44 24 20 89 54 24 24 7F 7B 8B 5C 24 1C 8B 54 24 14 C1 E3 04 3B 93 ?? ?? ?? ?? 72 16 0F 87 9D 00 00 00 8B 4C 24 10 3B 8B ?? ?? ?? ?? 0F 87 8D 00 00 00 85 F6 8B 44 24 20 0F 84 D7 FD FF FF F7 D8 E9 D0 FD FF FF 83 FD 0B 0F 8E 91 00 00 00 8B 14 ED ?? ?? ?? ?? 31 C0 8D 14 92 39 D3 0F 82 78 FD FF FF 0F 87 A7 FE FF FF 39 C1 0F 82 6A FD FF FF E9 9A FE FF FF 8B 04 FD ?? ?? ?? ?? 0F AF C1 E9 91 FD FF FF 8B 44 24 08 21 D8 8B 5C 24 0C 21 EB 09 C3 75 2B 8B 5C 24 1C 8B 6C 24 14 C1 E3 04 3B AB ?? ?? ?? ?? 72 8B 77 16 8B 44 24 10 3B 83 ?? ?? ?? ?? 0F 86 79 FF FF FF 8D B6 00 00 00 00 85 F6 74 0A 83 44 24 20 01 83 54 24 24 00 83 0D ?? ?? ?? ?? 20 E9 59 FF FF FF 8D B6 00 00 00 00 C7 44 24 08 0B 00 00 00 29 6C 24 08 8B 44 24 08 8B 2C C5 ?? ?? ?? ?? 8B 14 C5 ?? ?? ?? ?? 8B 04 C5 ?? ?? ?? ?? 0F AF EB 0F AF D1 01 EA 89 54 24 10 F7 E1 8B 6C 24 10 01 EA 83 FA 04 89 44 24 08 89 54 24 0C 0F 86 B1 FC FF FF E9 E1 FD FF FF 90 8B 14 ED ?? ?? ?? ?? 31 C0 8D 14 92 39 D3 0F 82 97 FC FF FF 0F 87 C6 FD FF FF 39 C1 0F 86 89 FC FF FF E9 B9 FD FF FF 89 F6 8D BC 27 00 00 00 00 }
	condition:
		$1
}

rule file_89_4_0 {
	meta:
		name = "___bid64_to_int32_ceil"
		size = 1088
		refs = "009c ___bid_nr_digits 014b ___bid_ten2k64 0209 ___bid_IDEC_glbflags 0233 ___bid_ten2mk64 02c8 ___bid_maskhigh128 02cf ___bid_shiftright128 0323 ___bid_ten2mk128trunc"
	strings:
		$1 = { 83 EC 44 8B 4C 24 4C 89 5C 24 34 8B 54 24 48 89 74 24 38 89 7C 24 3C 89 C8 25 00 00 00 7C 3D 00 00 00 7C 89 6C 24 40 0F 84 DA 01 00 00 89 C8 25 00 00 00 78 3D 00 00 00 78 0F 84 C8 01 00 00 89 C8 25 00 00 00 60 3D 00 00 00 60 0F 84 C3 00 00 00 89 CF 89 D6 81 E7 FF FF 1F 00 31 C0 89 FA 09 F2 0F 84 99 00 00 00 89 74 24 28 89 CB 89 7C 24 2C 81 E3 00 00 E0 7F DF 6C 24 28 C1 EB 15 DD 1C 24 8B 54 24 04 89 D0 C1 E8 14 25 FF 07 00 00 2D FE 03 00 00 83 E8 01 C1 E0 05 8B 90 ?? ?? ?? ?? 85 D2 75 12 39 B8 ?? ?? ?? ?? 8B 90 ?? ?? ?? ?? 0F 86 A0 00 00 00 81 EB 8E 01 00 00 8D 04 1A 83 F8 0A 0F 8F 3F 01 00 00 89 CD 81 E5 00 00 00 80 83 F8 0A 0F 84 CB 00 00 00 85 C0 0F 8E 37 01 00 00 83 FB 00 0F 8C 3A 01 00 00 8D B6 00 00 00 00 75 4E 85 ED 89 F0 74 08 F7 D8 8D B6 00 00 00 00 8B 5C 24 34 8B 74 24 38 8B 7C 24 3C 8B 6C 24 40 83 C4 44 C3 89 C8 89 D6 25 FF FF 07 00 89 C7 81 CF 00 00 20 00 81 FF F2 86 23 00 77 0A 72 41 81 FA FF FF C0 6F 76 39 31 C0 EB C5 90 8D 74 26 00 85 ED 0F 84 60 02 00 00 8B 04 DD ?? ?? ?? ?? F7 DE 0F AF C6 EB AA 72 0C 39 B0 ?? ?? ?? ?? 0F 87 52 FF FF FF 83 C2 01 E9 4A FF FF FF 8D 74 26 00 31 D2 89 CB 89 54 24 2C 81 E3 00 00 F8 1F 89 7C 24 28 C1 EB 13 DF 6C 24 28 DD 1C 24 8B 54 24 04 89 D0 C1 E8 14 25 FF 07 00 00 2D DE 03 00 00 E9 F0 FE FF FF 85 ED 0F 84 98 01 00 00 83 FA 0B 0F 8F 02 02 00 00 C7 04 24 0B 00 00 00 29 14 24 8B 04 24 8B 0C C5 ?? ?? ?? ?? 8B 14 C5 ?? ?? ?? ?? 8B 04 C5 ?? ?? ?? ?? 0F AF CF 0F AF D6 01 CA 89 54 24 08 F7 E6 8B 4C 24 08 01 CA 83 FA 05 89 04 24 89 54 24 04 0F 82 E6 FE FF FF 77 0A 83 3C 24 09 0F 86 DA FE FF FF 83 0D ?? ?? ?? ?? 01 B8 00 00 00 80 E9 E8 FE FF FF 31 C0 85 ED 0F 94 C0 E9 DC FE FF FF 89 F1 89 DE F7 D6 89 F0 89 74 24 14 8B 34 F5 ?? ?? ?? ?? 8B 14 C5 ?? ?? ?? ?? 89 F0 89 54 24 10 F7 E7 89 04 24 8B 44 24 10 89 54 24 04 F7 E7 89 44 24 20 89 F0 89 54 24 24 F7 E1 89 54 24 1C 8B 7C 24 1C 31 D2 89 44 24 18 8B 04 24 89 FE 31 FF 01 C6 8B 44 24 10 11 D7 F7 E1 8B 4C 24 04 01 C6 8B 44 24 20 11 D7 89 CA 89 14 24 31 C9 8B 54 24 24 01 04 24 8B 44 24 18 89 4C 24 04 11 54 24 04 31 D2 01 3C 24 11 54 24 04 31 D2 89 54 24 08 31 D2 01 44 24 08 89 74 24 0C 11 54 24 0C 8B 74 24 14 8B 3C F5 ?? ?? ?? ?? 8B 0C B5 ?? ?? ?? ?? 8B 04 F5 ?? ?? ?? ?? 8B 34 24 89 7C 24 18 8B 7C 24 04 0F AD FE D3 EF F6 C1 20 0F 45 F7 F7 DB 83 FB 03 89 F2 7E 1D 8B 5C 24 04 23 04 24 23 5C 24 18 09 C3 74 0E 85 ED 75 2F 83 C2 01 89 D0 E9 EA FD FF FF 8B 7C 24 14 8B 44 24 0C C1 E7 04 3B 87 ?? ?? ?? ?? 72 0E 77 DD 8B 74 24 08 3B B7 ?? ?? ?? ?? 77 D1 85 ED 74 D4 89 D0 F7 D8 E9 BC FD FF FF 83 FA 0B 0F 8F A9 00 00 00 C7 04 24 0B 00 00 00 29 14 24 8B 04 24 8B 0C C5 ?? ?? ?? ?? 8B 14 C5 ?? ?? ?? ?? 8B 04 C5 ?? ?? ?? ?? 0F AF CF 0F AF D6 01 CA 89 54 24 08 F7 E6 8B 4C 24 08 01 CA 83 FA 04 89 04 24 89 54 24 04 0F 82 4E FD FF FF 0F 87 6E FE FF FF 83 3C 24 F6 0F 86 3E FD FF FF E9 5F FE FF FF 8B 04 DD ?? ?? ?? ?? 0F AF C6 E9 49 FD FF FF 83 EA 0B 6B 0C D5 ?? ?? ?? ?? 0A 89 0C 24 8B 0C D5 ?? ?? ?? ?? F7 24 D5 ?? ?? ?? ?? 8D 0C 89 03 0C 24 01 CA 39 FA 0F 87 FE FC FF FF 0F 82 1E FE FF FF 39 F0 0F 87 F0 FC FF FF E9 11 FE FF FF 83 EA 0B 6B 04 D5 ?? ?? ?? ?? F6 8B 0C D5 ?? ?? ?? ?? 8D 0C 88 B8 F6 FF FF FF F7 24 D5 ?? ?? ?? ?? 01 CA 39 FA 0F 87 C0 FC FF FF 0F 82 E0 FD FF FF 39 F0 0F 83 B2 FC FF FF 90 E9 D2 FD FF FF 8D 74 26 00 8D BC 27 00 00 00 00 }
	condition:
		$1
}

rule file_89_5_0 {
	meta:
		name = "___bid64_to_int32_xceil"
		size = 1104
		refs = "009c ___bid_nr_digits 00fd ___bid_ten2k64 0205 ___bid_IDEC_glbflags 0236 ___bid_ten2mk64 02cb ___bid_maskhigh128 02d2 ___bid_shiftright128 033d ___bid_ten2mk128trunc"
	strings:
		$1 = { 83 EC 44 8B 4C 24 4C 89 5C 24 34 8B 54 24 48 89 74 24 38 89 7C 24 3C 89 C8 25 00 00 00 7C 3D 00 00 00 7C 89 6C 24 40 0F 84 D6 01 00 00 89 C8 25 00 00 00 78 3D 00 00 00 78 0F 84 C4 01 00 00 89 C8 25 00 00 00 60 3D 00 00 00 60 0F 84 CF 00 00 00 89 CF 89 D6 81 E7 FF FF 1F 00 31 C0 89 FA 09 F2 0F 84 9F 00 00 00 89 74 24 28 89 CB 89 7C 24 2C 81 E3 00 00 E0 7F DF 6C 24 28 C1 EB 15 DD 1C 24 8B 54 24 04 89 D0 C1 E8 14 25 FF 07 00 00 2D FE 03 00 00 83 E8 01 C1 E0 05 8B 90 ?? ?? ?? ?? 85 D2 75 12 3B B8 ?? ?? ?? ?? 8B 90 ?? ?? ?? ?? 0F 83 9C 00 00 00 81 EB 8E 01 00 00 8D 04 1A 83 F8 0A 0F 8F 3B 01 00 00 89 CD 81 E5 00 00 00 80 83 F8 0A 0F 84 C7 00 00 00 85 C0 0F 8E 33 01 00 00 83 FB 00 0F 8C 3D 01 00 00 8D B6 00 00 00 00 74 55 85 ED 0F 84 BD 02 00 00 8B 04 DD ?? ?? ?? ?? F7 DE 0F AF C6 8B 5C 24 34 8B 74 24 38 8B 7C 24 3C 8B 6C 24 40 83 C4 44 C3 8D B6 00 00 00 00 89 C8 89 D6 25 FF FF 07 00 89 C7 81 CF 00 00 20 00 81 FF F2 86 23 00 77 0A 72 2D 81 FA FF FF C0 6F 76 25 31 C0 EB BF 85 ED 89 F0 74 B9 F7 D8 90 EB B4 77 0C 3B B0 ?? ?? ?? ?? 0F 82 56 FF FF FF 83 C2 01 E9 4E FF FF FF 31 D2 89 CB 89 54 24 2C 81 E3 00 00 F8 1F 89 7C 24 28 C1 EB 13 DF 6C 24 28 DD 1C 24 8B 54 24 04 89 D0 C1 E8 14 25 FF 07 00 00 2D DE 03 00 00 E9 F8 FE FF FF 8D 74 26 00 85 ED 0F 84 AB 01 00 00 83 FA 0B 0F 8F 15 02 00 00 C7 04 24 0B 00 00 00 29 14 24 8B 04 24 8B 0C C5 ?? ?? ?? ?? 8B 14 C5 ?? ?? ?? ?? 8B 04 C5 ?? ?? ?? ?? 0F AF CF 0F AF D6 01 CA 89 54 24 08 F7 E6 8B 4C 24 08 01 CA 83 FA 05 89 04 24 89 54 24 04 0F 82 EA FE FF FF 77 0A 83 3C 24 09 0F 86 DE FE FF FF 83 0D ?? ?? ?? ?? 01 B8 00 00 00 80 E9 F2 FE FF FF 31 C0 83 0D ?? ?? ?? ?? 20 85 ED 0F 94 C0 E9 DF FE FF FF 89 F1 89 DE F7 D6 89 F0 89 74 24 14 8B 34 F5 ?? ?? ?? ?? 8B 14 C5 ?? ?? ?? ?? 89 F0 89 54 24 10 F7 E7 89 04 24 8B 44 24 10 89 54 24 04 F7 E7 89 44 24 20 89 F0 89 54 24 24 F7 E1 89 54 24 1C 8B 7C 24 1C 31 D2 89 44 24 18 8B 04 24 89 FE 31 FF 01 C6 8B 44 24 10 11 D7 F7 E1 8B 4C 24 04 01 C6 8B 44 24 20 11 D7 89 CA 89 14 24 31 C9 8B 54 24 24 01 04 24 8B 44 24 18 89 4C 24 04 11 54 24 04 31 D2 01 3C 24 11 54 24 04 31 D2 89 54 24 08 31 D2 01 44 24 08 89 74 24 0C 11 54 24 0C 8B 74 24 14 8B 3C F5 ?? ?? ?? ?? 8B 0C B5 ?? ?? ?? ?? 8B 04 F5 ?? ?? ?? ?? 8B 34 24 89 7C 24 18 8B 7C 24 04 0F AD FE D3 EF F6 C1 20 0F 45 F7 F7 DB 83 FB 03 89 F2 7E 34 8B 5C 24 04 23 04 24 23 5C 24 18 09 C3 74 25 85 ED 75 03 83 C2 01 83 0D ?? ?? ?? ?? 20 85 ED 89 D0 0F 84 E3 FD FF FF F7 D8 E9 DC FD FF FF 8D B6 00 00 00 00 8B 7C 24 14 8B 44 24 0C C1 E7 04 3B 87 ?? ?? ?? ?? 72 D6 77 C6 8B 74 24 08 3B B7 ?? ?? ?? ?? 76 C8 EB B8 83 FA 0B 0F 8F A9 00 00 00 C7 04 24 0B 00 00 00 29 14 24 8B 04 24 8B 0C C5 ?? ?? ?? ?? 8B 14 C5 ?? ?? ?? ?? 8B 04 C5 ?? ?? ?? ?? 0F AF CF 0F AF D6 01 CA 89 54 24 08 F7 E6 8B 4C 24 08 01 CA 83 FA 04 89 04 24 89 54 24 04 0F 82 3F FD FF FF 0F 87 5B FE FF FF 83 3C 24 F6 0F 86 2F FD FF FF E9 4C FE FF FF 8B 04 DD ?? ?? ?? ?? 0F AF C6 E9 40 FD FF FF 83 EA 0B 6B 0C D5 ?? ?? ?? ?? 0A 89 0C 24 8B 0C D5 ?? ?? ?? ?? F7 24 D5 ?? ?? ?? ?? 8D 0C 89 03 0C 24 01 CA 39 D7 0F 82 EF FC FF FF 0F 87 0B FE FF FF 39 C6 0F 82 E1 FC FF FF E9 FE FD FF FF 83 EA 0B 6B 04 D5 ?? ?? ?? ?? F6 8B 0C D5 ?? ?? ?? ?? 8D 0C 88 B8 F6 FF FF FF F7 24 D5 ?? ?? ?? ?? 01 CA 39 D7 0F 82 B1 FC FF FF 0F 87 CD FD FF FF 39 C6 0F 86 A3 FC FF FF 66 90 E9 BE FD FF FF 8D 74 26 00 8D BC 27 00 00 00 00 }
	condition:
		$1
}

rule file_89_6_0 {
	meta:
		name = "___bid64_to_int32_int"
		size = 928
		refs = "009c ___bid_nr_digits 0103 ___bid_ten2k64 0212 ___bid_IDEC_glbflags 0228 ___bid_ten2mk64 022f ___bid_shiftright128"
	strings:
		$1 = { 83 EC 3C 8B 4C 24 44 89 5C 24 2C 8B 54 24 40 89 74 24 30 89 7C 24 34 89 C8 25 00 00 00 7C 3D 00 00 00 7C 89 6C 24 38 0F 84 E3 01 00 00 89 C8 25 00 00 00 78 3D 00 00 00 78 0F 84 D1 01 00 00 89 C8 25 00 00 00 60 3D 00 00 00 60 0F 84 D3 00 00 00 89 CF 89 D6 81 E7 FF FF 1F 00 31 C0 89 FA 09 F2 0F 84 A9 00 00 00 89 74 24 20 89 CB 89 7C 24 24 81 E3 00 00 E0 7F DF 6C 24 20 C1 EB 15 DD 1C 24 8B 54 24 04 89 D0 C1 E8 14 25 FF 07 00 00 2D FE 03 00 00 83 E8 01 C1 E0 05 8B A8 ?? ?? ?? ?? 85 ED 75 12 39 B8 ?? ?? ?? ?? 8B A8 ?? ?? ?? ?? 0F 86 AA 00 00 00 81 EB 8E 01 00 00 8D 44 1D 00 83 F8 0A 89 04 24 0F 8F 44 01 00 00 81 E1 00 00 00 80 83 3C 24 0A 89 4C 24 0C 0F 84 D0 00 00 00 8B 2C 24 31 C0 85 ED 7E 27 83 FB 00 0F 8C 2F 01 00 00 74 5C 8B 44 24 0C 85 C0 0F 84 C0 01 00 00 8B 04 DD ?? ?? ?? ?? F7 DE 0F AF C6 8D 74 26 00 8B 5C 24 2C 8B 74 24 30 8B 7C 24 34 8B 6C 24 38 83 C4 3C C3 89 C8 89 D6 25 FF FF 07 00 89 C7 81 CF 00 00 20 00 81 FF F2 86 23 00 77 0A 72 37 81 FA FF FF C0 6F 76 2F 31 C0 EB C5 90 8D 74 26 00 8B 54 24 0C 89 F0 85 D2 74 B6 F7 D8 EB B2 66 90 72 0C 39 B0 ?? ?? ?? ?? 0F 87 48 FF FF FF 83 C5 01 E9 40 FF FF FF 31 D2 89 CB 89 54 24 24 81 E3 00 00 F8 1F 89 7C 24 20 C1 EB 13 DF 6C 24 20 DD 1C 24 8B 54 24 04 89 D0 C1 E8 14 25 FF 07 00 00 2D DE 03 00 00 E9 EA FE FF FF 8D B6 00 00 00 00 85 C9 0F 84 18 01 00 00 83 FD 0B 0F 8F 8F 01 00 00 C7 04 24 0B 00 00 00 29 2C 24 8B 14 24 8B 0C D5 ?? ?? ?? ?? 89 D5 8B 14 D5 ?? ?? ?? ?? 8B 04 ED ?? ?? ?? ?? 0F AF CF 0F AF D6 01 D1 F7 E6 01 CA 83 FA 05 89 04 24 89 54 24 04 0F 82 E8 FE FF FF 77 0D 83 3C 24 09 0F 86 DC FE FF FF 8D 76 00 83 0D ?? ?? ?? ?? 01 B8 00 00 00 80 E9 EF FE FF FF F7 D3 89 F5 8B 04 DD ?? ?? ?? ?? 8B 0C 9D ?? ?? ?? ?? F7 E7 89 44 24 10 8B 04 DD ?? ?? ?? ?? 89 54 24 14 8B 74 24 10 F7 E7 31 FF 89 44 24 18 8B 04 DD ?? ?? ?? ?? 89 54 24 1C F7 E5 89 D0 31 D2 89 04 24 8B 04 DD ?? ?? ?? ?? 01 34 24 89 54 24 04 11 7C 24 04 8B 7C 24 14 89 FE 31 FF 03 74 24 18 13 7C 24 1C F7 E5 01 04 24 11 54 24 04 8B 54 24 04 89 D0 31 D2 01 C6 11 D7 0F AD FE D3 EF F6 C1 20 0F 45 F7 89 F0 8B 74 24 0C 85 F6 0F 84 5C FE FF FF F7 D8 E9 55 FE FF FF 90 8D 74 26 00 8B 04 DD ?? ?? ?? ?? 0F AF C6 E9 41 FE FF FF 90 83 FD 0B 7E 30 8B 14 ED ?? ?? ?? ?? 31 C0 8D 14 92 39 FA 0F 87 00 FE FF FF 0F 82 21 FF FF FF 39 F0 0F 87 F2 FD FF FF 89 F6 8D BC 27 00 00 00 00 E9 0B FF FF FF C7 04 24 0B 00 00 00 29 2C 24 8B 14 24 8B 0C D5 ?? ?? ?? ?? 89 D5 8B 14 D5 ?? ?? ?? ?? 8B 04 ED ?? ?? ?? ?? 0F AF CF 0F AF D6 01 D1 F7 E6 01 CA 83 FA 04 89 04 24 89 54 24 04 0F 86 A4 FD FF FF E9 C6 FE FF FF 8D B6 00 00 00 00 83 ED 0B 8B 04 ED ?? ?? ?? ?? 6B 0C ED ?? ?? ?? ?? 0A 8D 04 80 01 C1 8B 04 24 F7 24 ED ?? ?? ?? ?? 01 CA 39 FA 89 04 24 89 54 24 04 0F 87 67 FD FF FF 0F 82 88 FE FF FF 39 34 24 0F 87 58 FD FF FF E9 7A FE FF FF 8D 76 00 8D BC 27 00 00 00 00 }
	condition:
		$1
}

rule file_89_7_0 {
	meta:
		name = "___bid64_to_int32_xint"
		size = 1040
		refs = "009d ___bid_nr_digits 0101 ___bid_ten2k64 0212 ___bid_IDEC_glbflags 022c ___bid_ten2mk64 02cc ___bid_shiftright128 02d3 ___bid_maskhigh128 0331 ___bid_ten2mk128trunc"
	strings:
		$1 = { 83 EC 4C 8B 4C 24 54 89 5C 24 3C 8B 54 24 50 89 74 24 40 89 7C 24 44 89 C8 25 00 00 00 7C 3D 00 00 00 7C 89 6C 24 48 0F 84 E3 01 00 00 89 C8 25 00 00 00 78 3D 00 00 00 78 0F 84 D1 01 00 00 89 C8 25 00 00 00 60 3D 00 00 00 60 0F 84 D3 00 00 00 89 CF 89 D6 81 E7 FF FF 1F 00 31 C0 89 FA 09 F2 0F 84 A9 00 00 00 89 74 24 30 89 CB 89 7C 24 34 81 E3 00 00 E0 7F DF 6C 24 30 C1 EB 15 DD 5C 24 08 8B 54 24 0C 89 D0 C1 E8 14 25 FF 07 00 00 2D FE 03 00 00 83 E8 01 C1 E0 05 8B A8 ?? ?? ?? ?? 85 ED 75 12 39 B8 ?? ?? ?? ?? 8B A8 ?? ?? ?? ?? 0F 86 A9 00 00 00 81 EB 8E 01 00 00 8D 44 1D 00 83 F8 0A 0F 8F 46 01 00 00 81 E1 00 00 00 80 83 F8 0A 89 4C 24 18 0F 84 D3 00 00 00 85 C0 0F 8E 62 02 00 00 83 FB 00 0F 8C 33 01 00 00 66 90 74 5E 8B 44 24 18 85 C0 0F 84 57 02 00 00 8B 04 DD ?? ?? ?? ?? F7 DE 0F AF C6 8D B6 00 00 00 00 8B 5C 24 3C 8B 74 24 40 8B 7C 24 44 8B 6C 24 48 83 C4 4C C3 89 C8 89 D6 25 FF FF 07 00 89 C7 81 CF 00 00 20 00 81 FF F2 86 23 00 77 0A 72 37 81 FA FF FF C0 6F 76 2F 31 C0 EB C5 90 8D 74 26 00 8B 54 24 18 89 F0 85 D2 74 B6 F7 D8 EB B2 66 90 72 0C 39 B0 ?? ?? ?? ?? 0F 87 49 FF FF FF 83 C5 01 E9 41 FF FF FF 31 D2 89 CB 89 54 24 34 81 E3 00 00 F8 1F 89 7C 24 30 C1 EB 13 DF 6C 24 30 DD 5C 24 08 8B 54 24 0C 89 D0 C1 E8 14 25 FF 07 00 00 2D DE 03 00 00 E9 EA FE FF FF 90 8D 74 26 00 85 C9 0F 84 AC 01 00 00 83 FD 0B 0F 8F F3 01 00 00 C7 44 24 08 0B 00 00 00 29 6C 24 08 8B 44 24 08 8B 0C C5 ?? ?? ?? ?? 8B 14 C5 ?? ?? ?? ?? 8B 04 C5 ?? ?? ?? ?? 0F AF CF 0F AF D6 01 D1 F7 E6 01 CA 83 FA 05 89 44 24 08 89 54 24 0C 0F 82 E2 FE FF FF 77 0B 83 7C 24 08 09 0F 86 D5 FE FF FF 83 0D ?? ?? ?? ?? 01 B8 00 00 00 80 E9 EF FE FF FF 89 F9 89 DF F7 D7 89 F5 8B 34 FD ?? ?? ?? ?? 89 7C 24 1C 8B 3C FD ?? ?? ?? ?? 89 F0 F7 E1 89 7C 24 04 89 44 24 08 89 F8 89 54 24 0C F7 E1 89 44 24 28 89 F0 89 54 24 2C F7 E5 89 54 24 24 8B 7C 24 24 31 D2 89 44 24 20 8B 44 24 08 89 FE 31 FF 01 C6 8B 44 24 04 11 D7 F7 E5 01 C6 11 D7 8B 54 24 0C 89 74 24 14 89 D0 31 D2 89 44 24 08 8B 44 24 28 01 44 24 08 89 54 24 0C 8B 54 24 2C 11 54 24 0C 31 D2 01 7C 24 08 11 54 24 0C 31 C0 31 D2 89 44 24 10 8B 44 24 20 01 44 24 10 11 54 24 14 8B 7C 24 1C 8B 6C 24 0C 8B 0C BD ?? ?? ?? ?? 8B 04 FD ?? ?? ?? ?? 8B 34 FD ?? ?? ?? ?? 8B 7C 24 08 0F AD EF D3 ED F6 C1 20 0F 45 FD F7 DB 83 FB 03 89 FA 0F 8E 2A 00 00 00 8B 5C 24 0C 23 44 24 08 21 F3 09 C3 74 1C 83 0D ?? ?? ?? ?? 20 8B 4C 24 18 89 D0 85 C9 0F 84 F3 FD FF FF F7 D8 E9 EC FD FF FF 8B 7C 24 1C 8B 6C 24 14 C1 E7 04 3B AF ?? ?? ?? ?? 72 D8 77 CF 8B 44 24 10 3B 87 ?? ?? ?? ?? 76 CA EB C1 83 0D ?? ?? ?? ?? 20 31 C0 E9 BB FD FF FF 8B 04 DD ?? ?? ?? ?? 0F AF C6 E9 AC FD FF FF 83 FD 0B 0F 8F 88 00 00 00 C7 44 24 08 0B 00 00 00 29 6C 24 08 8B 44 24 08 8B 0C C5 ?? ?? ?? ?? 8B 14 C5 ?? ?? ?? ?? 8B 04 C5 ?? ?? ?? ?? 0F AF CF 0F AF D6 01 D1 F7 E6 01 CA 83 FA 04 89 44 24 08 89 54 24 0C 0F 86 36 FD FF FF E9 5C FE FF FF 83 ED 0B 8B 14 ED ?? ?? ?? ?? 6B 0C ED ?? ?? ?? ?? 0A 8D 14 92 01 D1 F7 24 ED ?? ?? ?? ?? 01 CA 39 FA 0F 87 09 FD FF FF 0F 82 2E FE FF FF 39 F0 0F 87 FB FC FF FF 8D B6 00 00 00 00 E9 1B FE FF FF 8B 14 ED ?? ?? ?? ?? 31 C0 8D 14 92 39 FA 0F 87 DC FC FF FF EB D1 90 8D 74 26 00 }
	condition:
		$1
}

rule file_89_8_0 {
	meta:
		name = "___bid64_to_int32_rninta"
		size = 1008
		refs = "009d ___bid_nr_digits 00eb ___bid_midpoint64 019c ___bid_ten2k64 021b ___bid_ten2mk64 02ab ___bid_shiftright128 0362 ___bid_IDEC_glbflags"
	strings:
		$1 = { 83 EC 44 89 74 24 38 8B 74 24 4C 89 5C 24 34 8B 54 24 48 89 7C 24 3C 89 6C 24 40 89 F0 25 00 00 00 7C 3D 00 00 00 7C 0F 84 33 03 00 00 89 F0 25 00 00 00 78 3D 00 00 00 78 0F 84 21 03 00 00 89 F0 25 00 00 00 60 3D 00 00 00 60 0F 84 CF 00 00 00 89 F3 89 D1 81 E3 FF FF 1F 00 31 C0 89 DA 09 CA 0F 84 9F 00 00 00 89 4C 24 28 89 F7 89 5C 24 2C 81 E7 00 00 E0 7F DF 6C 24 28 C1 EF 15 DD 5C 24 08 8B 54 24 0C 89 D0 C1 E8 14 25 FF 07 00 00 2D FE 03 00 00 83 E8 01 C1 E0 05 8B 90 ?? ?? ?? ?? 85 D2 75 12 39 98 ?? ?? ?? ?? 8B 90 ?? ?? ?? ?? 0F 86 49 01 00 00 81 EF 8E 01 00 00 8D 2C 3A 83 FD 0A 0F 8F 97 02 00 00 81 E6 00 00 00 80 83 FD 0A 0F 84 A0 00 00 00 31 C0 83 FD 00 7C 27 0F 85 FB 00 00 00 83 EA 01 39 1C D5 ?? ?? ?? ?? 77 13 0F 82 D9 01 00 00 39 0C D5 ?? ?? ?? ?? 0F 86 CC 01 00 00 31 C0 8B 5C 24 34 8B 74 24 38 8B 7C 24 3C 8B 6C 24 40 83 C4 44 C3 8D B6 00 00 00 00 89 F0 89 D1 25 FF FF 07 00 89 C3 81 CB 00 00 20 00 81 FB F2 86 23 00 77 CB 72 08 81 FA FF FF C0 6F 77 C1 31 D2 89 F7 89 54 24 2C 81 E7 00 00 F8 1F 89 5C 24 28 C1 EF 13 DF 6C 24 28 DD 5C 24 08 8B 54 24 0C 89 D0 C1 E8 14 25 FF 07 00 00 2D DE 03 00 00 E9 1D FF FF FF 85 F6 0F 84 80 01 00 00 83 FA 0B 0F 8F F7 01 00 00 C7 44 24 08 0B 00 00 00 29 54 24 08 8B 44 24 08 8B 2C C5 ?? ?? ?? ?? 8B 14 C5 ?? ?? ?? ?? 8B 04 C5 ?? ?? ?? ?? 0F AF EB 0F AF D1 01 EA 89 54 24 14 F7 E1 8B 6C 24 14 01 EA 83 FA 05 89 44 24 08 89 54 24 0C 72 11 0F 87 8B 01 00 00 83 7C 24 08 04 0F 87 80 01 00 00 83 FF 00 7C 31 0F 85 F5 00 00 00 85 F6 89 C8 90 0F 84 10 FF FF FF F7 D8 E9 09 FF FF FF 8D 76 00 72 0C 39 88 ?? ?? ?? ?? 0F 87 A9 FE FF FF 83 C2 01 E9 A1 FE FF FF F7 D7 8B 2C FD ?? ?? ?? ?? 03 0C FD ?? ?? ?? ?? 13 1C FD ?? ?? ?? ?? 89 7C 24 14 89 6C 24 10 8B 44 24 10 8B 2C FD ?? ?? ?? ?? F7 E3 89 6C 24 04 89 44 24 18 89 E8 8B 7C 24 18 89 54 24 1C F7 E3 31 ED 89 44 24 20 8B 44 24 10 89 54 24 24 F7 E1 89 D0 31 D2 89 44 24 08 8B 44 24 04 01 7C 24 08 89 54 24 0C 11 6C 24 0C 8B 6C 24 1C 89 EF 31 ED 03 7C 24 20 13 6C 24 24 F7 E1 01 44 24 08 11 54 24 0C 8B 54 24 0C 89 D0 31 D2 01 C7 11 D5 8B 54 24 14 8B 0C 95 ?? ?? ?? ?? 0F AD EF D3 ED F6 C1 20 0F 45 FD 85 F6 89 F8 0F 84 42 FE FF FF F7 D8 E9 3B FE FF FF 90 8D 74 26 00 83 FE 01 19 C0 83 E0 02 83 E8 01 E9 26 FE FF FF 85 F6 0F 84 89 00 00 00 8B 04 FD ?? ?? ?? ?? F7 D9 0F AF C1 E9 0D FE FF FF 8D B4 26 00 00 00 00 83 FA 0B 0F 8F B9 00 00 00 C7 44 24 08 0B 00 00 00 29 54 24 08 8B 44 24 08 8B 2C C5 ?? ?? ?? ?? 8B 14 C5 ?? ?? ?? ?? 8B 04 C5 ?? ?? ?? ?? 0F AF EB 0F AF D1 01 EA 89 54 24 14 F7 E1 8B 6C 24 14 01 EA 83 FA 04 89 44 24 08 89 54 24 0C 0F 82 8D FE FF FF 77 0B 83 7C 24 08 FA 0F 86 80 FE FF FF 83 0D ?? ?? ?? ?? 01 B8 00 00 00 80 E9 95 FD FF FF 8B 04 FD ?? ?? ?? ?? 0F AF C1 E9 86 FD FF FF 83 EA 0B 8B 2C D5 ?? ?? ?? ?? 8B 04 D5 ?? ?? ?? ?? 8D 6C AD 00 8D 04 80 01 C5 B8 05 00 00 00 F7 24 D5 ?? ?? ?? ?? 01 EA 39 DA 0F 87 30 FE FF FF 72 AE 39 C8 0F 87 26 FE FF FF 8D B6 00 00 00 00 EB 9E 83 EA 0B 6B 04 D5 ?? ?? ?? ?? FB 8B 2C D5 ?? ?? ?? ?? 8D 2C A8 B8 FB FF FF FF F7 24 D5 ?? ?? ?? ?? 01 EA 39 DA 0F 87 F3 FD FF FF EB C1 90 }
	condition:
		$1
}

rule file_89_9_0 {
	meta:
		name = "___bid64_to_int32_xrninta"
		size = 1328
		refs = "009d ___bid_nr_digits 00e9 ___bid_midpoint64 00f7 ___bid_IDEC_glbflags 0169 ___bid_ten2k64 0222 ___bid_ten2mk64 02be ___bid_shiftright128 02c9 ___bid_maskhigh128 032f ___bid_ten2mk128trunc 04bb ___bid_onehalf128"
	strings:
		$1 = { 83 EC 44 89 74 24 38 8B 74 24 4C 89 5C 24 34 8B 54 24 48 89 7C 24 3C 89 6C 24 40 89 F0 25 00 00 00 7C 3D 00 00 00 7C 0F 84 F3 03 00 00 89 F0 25 00 00 00 78 3D 00 00 00 78 0F 84 E1 03 00 00 89 F0 25 00 00 00 60 3D 00 00 00 60 0F 84 BF 00 00 00 89 F3 89 D1 81 E3 FF FF 1F 00 31 C0 89 DA 09 CA 0F 84 95 00 00 00 89 4C 24 28 89 F7 89 5C 24 2C 81 E7 00 00 E0 7F DF 6C 24 28 C1 EF 15 DD 5C 24 08 8B 54 24 0C 89 D0 C1 E8 14 25 FF 07 00 00 2D FE 03 00 00 83 E8 01 C1 E0 05 8B 90 ?? ?? ?? ?? 85 D2 75 12 39 98 ?? ?? ?? ?? 8B 90 ?? ?? ?? ?? 0F 86 19 01 00 00 81 EF 8E 01 00 00 8D 04 3A 83 F8 0A 0F 8F 57 03 00 00 81 E6 00 00 00 80 83 F8 0A 74 6E 83 F8 00 0F 8C B3 02 00 00 0F 85 CD 00 00 00 83 EA 01 39 1C D5 ?? ?? ?? ?? 0F 86 F3 00 00 00 31 C0 83 0D ?? ?? ?? ?? 20 8B 5C 24 34 8B 74 24 38 8B 7C 24 3C 8B 6C 24 40 83 C4 44 C3 89 F0 89 D1 25 FF FF 07 00 89 C3 81 CB 00 00 20 00 81 FB F2 86 23 00 77 12 0F 82 26 02 00 00 81 FA FF FF C0 6F 0F 86 1A 02 00 00 31 C0 8D 76 00 EB BA 85 F6 0F 84 76 02 00 00 83 FA 0B 8D 76 00 0F 8F EA 02 00 00 C7 44 24 08 0B 00 00 00 29 54 24 08 8B 44 24 08 8B 2C C5 ?? ?? ?? ?? 8B 14 C5 ?? ?? ?? ?? 8B 04 C5 ?? ?? ?? ?? 0F AF EB 0F AF D1 01 EA 89 54 24 10 F7 E1 8B 6C 24 10 01 EA 83 FA 05 89 44 24 08 89 54 24 0C 72 14 0F 87 7E 02 00 00 83 7C 24 08 04 0F 87 73 02 00 00 8D 76 00 83 FF 00 7C 50 0F 85 E5 01 00 00 85 F6 89 C8 90 0F 84 36 FF FF FF F7 D8 E9 2F FF FF FF 8D 76 00 72 0C 39 88 ?? ?? ?? ?? 0F 87 D9 FE FF FF 83 C2 01 E9 D1 FE FF FF 72 0D 39 0C D5 ?? ?? ?? ?? 0F 87 FE FE FF FF 83 FE 01 19 C0 83 E0 02 83 E8 01 E9 F0 FE FF FF 89 FD F7 D5 03 0C ED ?? ?? ?? ?? 13 1C ED ?? ?? ?? ?? 89 4C 24 24 89 5C 24 10 8B 1C ED ?? ?? ?? ?? 8B 44 24 10 F7 E3 89 44 24 08 8B 44 24 10 89 54 24 0C F7 24 ED ?? ?? ?? ?? 89 44 24 10 89 C8 89 54 24 14 F7 E3 89 54 24 1C 8B 5C 24 1C 31 D2 89 44 24 18 8B 44 24 08 89 D9 31 DB 01 C1 8B 44 24 24 11 D3 F7 24 ED ?? ?? ?? ?? 01 C1 11 D3 8B 54 24 0C 89 D0 31 D2 89 44 24 08 8B 44 24 10 01 44 24 08 89 54 24 0C 8B 54 24 14 11 54 24 0C 89 DA 89 D0 31 D2 01 44 24 08 11 54 24 0C 31 C0 31 D2 89 44 24 10 8B 44 24 18 01 44 24 10 8B 44 24 08 89 4C 24 14 0F B6 0C AD ?? ?? ?? ?? 11 54 24 14 8B 14 ED ?? ?? ?? ?? 8B 1C ED ?? ?? ?? ?? 89 54 24 24 8B 54 24 0C 0F AD D0 D3 EA F6 C1 20 74 04 89 D0 31 D2 F7 DF 83 FF 03 89 04 24 89 54 24 04 0F 8F B4 01 00 00 81 7C 24 14 00 00 00 80 0F 82 D6 01 00 00 77 0B 83 7C 24 10 00 0F 86 C9 01 00 00 8B 44 24 10 89 EF 8B 54 24 14 83 C0 00 81 D2 00 00 00 80 C1 E7 04 3B 97 ?? ?? ?? ?? 0F 82 AE 01 00 00 0F 87 A1 01 00 00 3B 87 ?? ?? ?? ?? 0F 86 9C 01 00 00 90 8D 74 26 00 E9 8B 01 00 00 31 D2 89 F7 89 54 24 2C 81 E7 00 00 F8 1F 89 5C 24 28 C1 EF 13 DF 6C 24 28 DD 5C 24 08 8B 54 24 0C 89 D0 C1 E8 14 25 FF 07 00 00 2D DE 03 00 00 E9 0B FD FF FF 8D B6 00 00 00 00 83 0D ?? ?? ?? ?? 20 31 C0 E9 5E FD FF FF 66 90 85 F6 0F 84 89 00 00 00 8B 04 FD ?? ?? ?? ?? F7 D9 0F AF C1 E9 43 FD FF FF 8D B4 26 00 00 00 00 83 FA 0B 0F 8F B9 00 00 00 C7 44 24 08 0B 00 00 00 29 54 24 08 8B 44 24 08 8B 2C C5 ?? ?? ?? ?? 8B 14 C5 ?? ?? ?? ?? 8B 04 C5 ?? ?? ?? ?? 0F AF EB 0F AF D1 01 EA 89 54 24 10 F7 E1 8B 6C 24 10 01 EA 83 FA 04 89 44 24 08 89 54 24 0C 0F 82 9D FD FF FF 77 0B 83 7C 24 08 FA 0F 86 90 FD FF FF 83 0D ?? ?? ?? ?? 01 B8 00 00 00 80 E9 CB FC FF FF 8B 04 FD ?? ?? ?? ?? 0F AF C1 E9 BC FC FF FF 83 EA 0B 8B 2C D5 ?? ?? ?? ?? 8B 04 D5 ?? ?? ?? ?? 8D 6C AD 00 8D 04 80 01 C5 B8 05 00 00 00 F7 24 D5 ?? ?? ?? ?? 01 EA 39 DA 0F 87 40 FD FF FF 72 AE 39 C8 0F 87 36 FD FF FF 8D B6 00 00 00 00 EB 9E 83 EA 0B 6B 04 D5 ?? ?? ?? ?? FB 8B 2C D5 ?? ?? ?? ?? 8D 2C A8 B8 FB FF FF FF F7 24 D5 ?? ?? ?? ?? 01 EA 39 DA 0F 87 03 FD FF FF EB C1 90 8B 4C 24 08 8B 54 24 24 8B 3C ED ?? ?? ?? ?? 23 54 24 0C 21 D9 8B 04 ED ?? ?? ?? ?? 39 FA 77 10 72 04 39 C1 77 0A 31 FA 31 C8 09 C2 74 1B 66 90 83 0D ?? ?? ?? ?? 20 85 F6 8B 04 24 0F 84 0A FC FF FF F7 D8 E9 03 FC FF FF 8B 54 24 14 0B 54 24 10 74 DD 89 E8 8B 4C 24 14 C1 E0 04 3B 88 ?? ?? ?? ?? 72 D3 77 CA 8B 5C 24 10 3B 98 ?? ?? ?? ?? 76 C5 EB BC 90 90 90 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_90_0_0 {
	meta:
		name = "___umoddi3"
		size = 320
	strings:
		$1 = { 83 EC 2C 89 74 24 20 8B 74 24 3C 8B 44 24 30 89 5C 24 1C 8B 4C 24 38 8B 5C 24 34 85 F6 89 7C 24 24 89 6C 24 28 89 CF 89 C5 89 44 24 08 89 DA 75 1F 39 D9 76 3D F7 F1 89 D0 31 D2 8B 5C 24 1C 8B 74 24 20 8B 7C 24 24 8B 6C 24 28 83 C4 2C C3 90 39 DE 77 3C 0F BD C6 83 F0 1F 89 44 24 04 75 34 39 E9 0F 87 C0 00 00 00 89 DA 29 CD 19 F2 89 E8 EB C9 85 C9 75 0B B8 01 00 00 00 31 D2 F7 F1 89 C1 89 D8 31 D2 F7 F1 89 E8 F7 F1 EB AA 8D 76 00 89 DA EB A7 0F B6 4C 24 04 89 F0 BE 20 00 00 00 2B 74 24 04 89 FD 89 DA D3 E0 89 F1 D3 ED 0F B6 4C 24 04 09 C5 8B 44 24 08 D3 E7 89 F1 D3 EA 0F B6 4C 24 04 89 7C 24 0C D3 E3 89 F1 D3 E8 0F B6 4C 24 04 09 D8 8B 5C 24 08 F7 F5 D3 E3 89 5C 24 08 89 D3 F7 E7 39 D3 89 C7 89 D1 72 2F 39 44 24 08 72 25 8B 44 24 08 29 F8 19 CB 0F B6 4C 24 04 89 DA D3 E8 89 F1 D3 E2 0F B6 4C 24 04 09 D0 89 DA D3 EA E9 23 FF FF FF 39 D3 75 D7 89 D1 89 C7 2B 7C 24 0C 19 E9 EB CB 39 DE 0F 82 38 FF FF FF 89 E8 E9 04 FF FF FF 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_91_0_0 {
	meta:
		name = "___udivmoddi4"
		size = 496
	strings:
		$1 = { 83 EC 3C 89 6C 24 38 8B 6C 24 4C 8B 54 24 40 89 5C 24 2C 8B 4C 24 48 8B 5C 24 44 85 ED 89 74 24 30 89 D0 89 7C 24 34 89 CE 89 D7 89 5C 24 0C 75 27 39 D9 0F 86 97 00 00 00 89 DA F7 F1 89 D3 31 D2 8B 74 24 50 85 F6 74 2C 8B 4C 24 50 89 19 C7 41 04 00 00 00 00 EB 1D 39 DD 76 34 8B 4C 24 50 85 C9 0F 84 68 01 00 00 8B 44 24 50 89 10 31 D2 89 58 04 31 C0 8B 5C 24 2C 8B 74 24 30 8B 7C 24 34 8B 6C 24 38 83 C4 3C C3 8D B4 26 00 00 00 00 0F BD D5 83 F2 1F 89 54 24 10 75 58 39 C8 0F 83 F3 00 00 00 31 C0 39 EB 0F 87 E9 00 00 00 8B 54 24 50 85 D2 0F 84 26 01 00 00 8B 5C 24 50 8B 54 24 0C 89 3B 89 53 04 31 D2 EB AA 90 8D 74 26 00 85 C9 75 0B B8 01 00 00 00 31 D2 F7 F1 89 C1 89 D8 31 D2 F7 F1 89 C6 89 F8 F7 F1 89 D3 89 F2 E9 4D FF FF FF 0F B6 4C 24 10 BF 20 00 00 00 89 F2 2B 7C 24 10 D3 E5 89 F9 D3 EA 0F B6 4C 24 10 09 EA 89 54 24 0C 89 DA D3 E6 89 F9 D3 EA 0F B6 4C 24 10 89 74 24 14 89 C6 D3 E3 89 F9 D3 EE 0F B6 4C 24 10 09 DE D3 E0 89 44 24 1C 89 F0 F7 74 24 0C 89 D5 89 C1 89 44 24 18 F7 64 24 14 39 D5 89 C6 89 D3 72 5F 3B 44 24 1C 77 55 8B 44 24 50 85 C0 74 29 0F B6 4C 24 10 89 EA 8B 44 24 1C 29 F0 19 DA 89 D3 D3 E8 89 F9 D3 E3 0F B6 4C 24 10 09 D8 8B 5C 24 50 D3 EA 89 03 89 53 04 8B 44 24 18 31 D2 E9 DE FE FF FF 29 CF 19 EB B8 01 00 00 00 89 5C 24 0C E9 05 FF FF FF 8D B4 26 00 00 00 00 39 EA 75 A7 83 E9 01 89 D3 89 C6 89 4C 24 18 2B 74 24 14 1B 5C 24 0C EB 92 8D B4 26 00 00 00 00 31 D2 31 C0 E9 9C FE FF FF 8D B4 26 00 00 00 00 31 D2 E9 8E FE FF FF 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_92_0_0 {
	meta:
		name = "___bid128_to_uint64_rnint"
		size = 3200
		refs = "0112 ___bid_nr_digits 016f ___bid_IDEC_glbflags 0265 ___bid_midpoint64 0337 ___bid_ten2k64 036e ___bid_midpoint128 05d7 ___bid_ten2k128 071b ___bid_ten2mk128 0a32 ___bid_shiftright128 0a39 ___bid_maskhigh128 0acc ___bid_ten2mk128trunc"
	strings:
		$1 = { 81 EC 9C 00 00 00 8B 84 24 A0 00 00 00 8B 8C 24 AC 00 00 00 89 9C 24 8C 00 00 00 89 B4 24 90 00 00 00 89 44 24 70 8B 84 24 A4 00 00 00 8B 5C 24 70 89 CA 81 E2 00 00 00 78 89 BC 24 94 00 00 00 89 44 24 74 8B 74 24 74 89 5C 24 08 89 CB 8B 84 24 A8 00 00 00 81 E3 00 00 00 80 81 FA 00 00 00 78 89 AC 24 98 00 00 00 89 74 24 0C 0F 84 0E 01 00 00 89 CD 89 C7 81 E5 FF FF 01 00 81 FD 09 ED 01 00 76 2C 31 C0 31 D2 8B 9C 24 8C 00 00 00 8B B4 24 90 00 00 00 8B BC 24 94 00 00 00 8B AC 24 98 00 00 00 81 C4 9C 00 00 00 C3 90 8D 74 26 00 0F 83 EF 00 00 00 89 EA 89 F8 81 F2 09 ED 01 00 35 C0 87 AD BE 09 C2 0F 84 38 01 00 00 89 C8 25 00 00 00 60 3D 00 00 00 60 74 A9 89 EE 09 FE 0F 84 D0 00 00 00 89 7C 24 68 89 6C 24 6C DF 6C 24 68 DD 5C 24 10 8B 54 24 14 89 D0 C1 E8 14 25 FF 07 00 00 2D BE 03 00 00 83 E8 01 89 C6 C1 E6 05 8B 96 ?? ?? ?? ?? 89 44 24 18 85 D2 75 34 8B 86 ?? ?? ?? ?? 8B 96 ?? ?? ?? ?? 8B B6 ?? ?? ?? ?? 89 44 24 10 39 F5 0F 87 95 01 00 00 0F 83 BE 01 00 00 8B 44 24 10 31 EE 31 F8 09 C6 0F 84 57 01 00 00 81 E1 00 00 FE 7F C1 E9 11 8D B1 E0 E7 FF FF 8D 04 32 83 F8 14 0F 8E C3 00 00 00 83 0D ?? ?? ?? ?? 01 31 C0 BA 00 00 00 80 E9 08 FF FF FF 89 C8 25 00 00 00 7C 3D 00 00 00 7C 0F 84 04 01 00 00 83 0D ?? ?? ?? ?? 01 31 C0 BA 00 00 00 80 E9 E3 FE FF FF 3D C0 87 AD BE 0F 87 D4 FE FF FF E9 01 FF FF FF 8B 74 24 0C 31 C0 31 D2 0B 74 24 08 0F 84 C1 FE FF FF 81 7C 24 0C FF FF 1F 00 0F 86 0B 01 00 00 8B 54 24 0C 89 D0 31 D2 89 44 24 68 89 54 24 6C DF 6C 24 68 DD 5C 24 10 8B 54 24 14 89 D0 C1 E8 14 25 FF 07 00 00 2D DE 03 00 00 E9 03 FF FF FF 31 C0 31 D2 81 7C 24 0C 63 8E 8D 37 0F 87 71 FE FF FF 89 CE 81 E6 00 00 00 60 81 FE 00 00 00 60 0F 85 BA FE FF FF E9 58 FE FF FF 0F 84 22 01 00 00 83 F8 00 8D B4 26 00 00 00 00 0F 8C 3E FE FF FF 0F 85 C4 00 00 00 8D 42 FF 83 F8 12 0F 8F 0C 01 00 00 89 E9 09 F9 75 24 8B 74 24 0C 39 34 C5 ?? ?? ?? ?? 0F 87 15 FE FF FF 72 11 8B 7C 24 08 39 3C C5 ?? ?? ?? ?? 0F 83 02 FE FF FF 31 D2 85 DB B8 01 00 00 00 0F 84 F7 FD FF FF E9 D7 FE FF FF 83 0D ?? ?? ?? ?? 01 31 C0 BA 00 00 00 80 E9 DF FD FF FF 8B 44 24 18 8B 74 24 0C C1 E0 05 05 ?? ?? ?? ?? 39 70 14 0F 87 90 FE FF FF 72 0D 8B 74 24 08 39 70 10 0F 87 81 FE FF FF 83 C2 01 E9 79 FE FF FF 8D B4 26 00 00 00 00 DF 6C 24 08 DD 5C 24 10 8B 54 24 14 89 D0 C1 E8 14 25 FF 07 00 00 2D FE 03 00 00 E9 08 FE FF FF 39 C7 77 CD E9 39 FE FF FF 8D B4 26 00 00 00 00 85 DB 0F 85 55 FE FF FF 83 FE 00 90 8D 74 26 00 0F 8C 9F 03 00 00 8B 44 24 08 8B 54 24 0C 0F 84 54 FD FF FF 8B 0C F5 ?? ?? ?? ?? 0F AF CA 8B 14 F5 ?? ?? ?? ?? 0F AF D0 01 D1 F7 24 F5 ?? ?? ?? ?? 01 CA E9 30 FD FF FF 85 DB 74 68 83 FA 15 E9 09 FE FF FF 8D 4A EC 89 C8 C1 E0 04 8B 90 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 39 C5 0F 82 04 FD FF FF 77 08 39 D7 0F 82 FA FC FF FF 31 E8 31 FA 09 D0 0F 85 EC FE FF FF C1 E1 04 8B 6C 24 0C 39 A9 ?? ?? ?? ?? 0F 87 DB FC FF FF 0F 82 D3 FE FF FF 8B 44 24 08 39 81 ?? ?? ?? ?? 0F 83 C5 FC FF FF E9 BE FE FF FF 83 FA 01 0F 84 08 02 00 00 83 FA 13 0F 8F EA 00 00 00 8B 4C 24 08 B8 15 00 00 00 29 D0 8B 5C 24 0C 89 4C 24 18 8B 0C C5 ?? ?? ?? ?? 8B 04 C5 ?? ?? ?? ?? 89 44 24 20 89 C8 F7 E3 89 44 24 10 8B 44 24 20 89 54 24 14 F7 E3 89 44 24 30 8B 44 24 18 89 54 24 34 F7 E1 89 54 24 2C 8B 5C 24 2C 31 D2 89 44 24 28 8B 44 24 10 89 D9 31 DB 01 C1 8B 44 24 20 11 D3 F7 64 24 18 01 C1 11 D3 8B 54 24 14 89 D0 31 D2 89 44 24 18 8B 44 24 30 89 54 24 1C 8B 54 24 34 01 44 24 18 11 54 24 1C 89 DA 89 D0 31 D2 01 44 24 18 11 54 24 1C 83 7C 24 1C 00 0F 87 F3 FC FF FF 83 7C 24 18 09 0F 87 E8 FC FF FF 8B 44 24 18 83 F0 09 0B 44 24 1C 0F 85 82 FE FF FF 89 CA 8B 4C 24 28 31 C0 31 DB 01 C8 11 DA 83 FA FF 0F 82 6B FE FF FF 83 F8 FA 0F 86 62 FE FF FF E9 B2 FC FF FF 90 8D 74 26 00 83 FA 14 0F 84 42 06 00 00 83 FA 15 8D 74 26 00 0F 84 22 07 00 00 83 EA 15 8B 0C D5 ?? ?? ?? ?? 8B 14 D5 ?? ?? ?? ?? 89 4C 24 18 B9 FB FF FF FF 89 D0 89 54 24 20 F7 E1 89 44 24 28 B8 FF FF FF FF 89 54 24 2C F7 64 24 20 89 44 24 10 8B 44 24 18 89 54 24 14 F7 E1 89 54 24 34 8B 5C 24 34 31 D2 89 44 24 30 8B 44 24 28 89 D9 31 DB 01 C1 B8 FF FF FF FF 11 D3 F7 64 24 18 01 C1 B8 09 00 00 00 11 D3 8B 54 24 20 8D 14 D2 89 54 24 20 F7 64 24 18 03 54 24 20 01 44 24 10 11 54 24 14 8B 54 24 2C 89 D0 31 D2 01 44 24 10 11 54 24 14 89 DA 89 D0 31 D2 01 44 24 10 11 54 24 14 3B 6C 24 14 0F 87 E7 FB FF FF 72 0A 3B 7C 24 10 0F 87 DB FB FF FF 3B 6C 24 14 0F 85 7C FD FF FF 3B 7C 24 10 0F 85 72 FD FF FF 89 CA 8B 4C 24 30 31 C0 31 DB 01 C8 11 DA 3B 54 24 0C 0F 87 5A FD FF FF 0F 82 A9 FB FF FF 3B 44 24 08 0F 87 4A FD FF FF 66 90 E9 98 FB FF FF 8B 1D ?? ?? ?? ?? 8B 4C 24 0C 8B 54 24 08 89 D8 89 54 24 20 F7 E1 89 44 24 18 A1 ?? ?? ?? ?? 89 54 24 1C F7 E1 89 44 24 10 8B 44 24 20 89 54 24 14 F7 E3 89 54 24 34 8B 5C 24 34 31 D2 89 44 24 30 8B 44 24 18 89 D9 31 DB 01 C1 A1 ?? ?? ?? ?? 11 D3 F7 64 24 20 01 C1 8B 44 24 08 11 D3 8B 54 24 0C 0F AF 15 ?? ?? ?? ?? 0F AF 05 ?? ?? ?? ?? 01 D0 89 44 24 20 8B 44 24 08 F7 25 ?? ?? ?? ?? 89 44 24 28 8B 44 24 20 01 C2 8B 44 24 28 01 44 24 10 89 54 24 2C 8B 54 24 2C 11 54 24 14 8B 54 24 1C 89 D0 31 D2 01 44 24 10 11 54 24 14 89 DA 89 D0 31 D2 01 44 24 10 11 54 24 14 83 7C 24 14 00 0F 87 D1 FA FF FF 83 7C 24 10 09 0F 87 C6 FA FF FF 8B 44 24 10 83 F0 09 0B 44 24 14 0F 85 60 FC FF FF 89 CA 31 C0 8B 4C 24 30 E9 D9 FD FF FF 89 F1 F7 D9 83 F9 13 89 4C 24 54 0F 8F ED 04 00 00 F7 D6 8B 4C 24 08 8B 5C 24 0C 03 0C F5 ?? ?? ?? ?? 13 1C F5 ?? ?? ?? ?? 89 74 24 30 39 5C 24 0C 72 0E 77 06 39 4C 24 08 76 06 83 C7 01 83 D5 00 89 4C 24 18 8B 4C 24 30 C7 44 24 44 00 00 00 00 C1 E1 04 8B 81 ?? ?? ?? ?? 8B B1 ?? ?? ?? ?? 89 44 24 38 89 D8 F7 E6 89 44 24 10 8B 44 24 38 89 54 24 14 F7 E3 89 44 24 28 8B 44 24 18 89 54 24 2C F7 E6 89 54 24 24 8B 54 24 10 89 44 24 20 89 54 24 40 8B 54 24 24 89 D0 31 D2 89 44 24 08 8B 44 24 40 01 44 24 08 8B 44 24 18 89 54 24 0C 8B 54 24 44 11 54 24 0C F7 64 24 38 01 44 24 08 11 54 24 0C 8B 54 24 14 89 D0 31 D2 89 44 24 10 8B 44 24 28 01 44 24 10 89 54 24 14 8B 54 24 2C 11 54 24 14 8B 54 24 0C 89 D0 31 D2 01 44 24 10 11 54 24 14 8B 91 ?? ?? ?? ?? 8B 89 ?? ?? ?? ?? 89 D0 89 54 24 28 F7 E3 89 4C 24 50 89 44 24 48 89 C8 89 54 24 4C F7 E3 89 44 24 60 8B 44 24 18 89 54 24 64 F7 64 24 28 89 54 24 5C 8B 5C 24 5C 31 D2 89 44 24 58 8B 44 24 48 89 D9 31 DB 89 4C 24 40 01 44 24 40 89 5C 24 44 11 54 24 44 8B 44 24 18 F7 64 24 50 01 44 24 40 8B 5C 24 4C 11 54 24 44 8B 54 24 44 89 D9 31 DB 03 4C 24 60 89 D0 13 5C 24 64 31 D2 01 C1 8B 44 24 08 11 D3 89 C2 B8 00 00 00 00 89 44 24 08 8B 44 24 20 89 54 24 0C 31 D2 01 44 24 08 11 54 24 0C 01 4C 24 08 11 5C 24 0C 3B 5C 24 0C 72 12 77 06 3B 4C 24 08 76 0A 83 44 24 10 01 83 54 24 14 00 89 E9 89 FD 89 C8 F7 E6 89 44 24 20 8B 44 24 38 89 54 24 24 F7 E1 89 44 24 18 89 F8 89 54 24 1C F7 E6 89 54 24 4C 8B 7C 24 4C 31 D2 89 44 24 48 8B 44 24 20 89 FE 31 FF 01 C6 8B 44 24 38 11 D7 F7 E5 01 C6 11 D7 8B 54 24 24 89 D0 31 D2 89 44 24 20 8B 44 24 18 01 44 24 20 8B 44 24 28 89 54 24 24 8B 54 24 1C 11 54 24 24 31 D2 01 7C 24 20 89 F7 11 54 24 24 F7 E1 89 44 24 18 8B 44 24 50 89 54 24 1C F7 E1 89 44 24 38 8B 44 24 28 89 54 24 3C F7 E5 89 44 24 28 89 54 24 2C 8B 5C 24 2C 31 D2 8B 44 24 18 89 D9 31 DB 01 C1 8B 44 24 50 11 D3 F7 E5 01 C1 11 D3 8B 54 24 1C 89 D0 31 D2 89 44 24 18 8B 44 24 38 01 44 24 18 8B 44 24 28 89 54 24 1C 8B 54 24 3C 11 54 24 1C 31 D2 01 5C 24 18 89 CB 11 54 24 1C 31 C9 31 D2 01 C1 8B 44 24 48 11 D3 31 F6 31 D2 01 C6 11 D7 03 74 24 18 13 7C 24 1C 39 7C 24 1C 72 12 77 06 39 74 24 18 76 0A 83 44 24 20 01 83 54 24 24 00 8B 44 24 08 8B 54 24 0C 01 C8 11 DA 89 54 24 0C 31 D2 3B 5C 24 0C 89 44 24 08 B8 01 00 00 00 77 0C 72 06 3B 4C 24 08 77 04 31 C0 31 D2 8B 4C 24 10 01 C6 8B 5C 24 14 11 D7 01 F1 11 FB 39 DF 89 4C 24 10 89 5C 24 14 0F 87 16 01 00 00 72 08 39 CE 0F 87 0C 01 00 00 31 DB 39 FA B9 01 00 00 00 77 0A 72 04 39 F0 77 04 31 C9 31 DB 89 C8 89 DA 03 44 24 20 13 54 24 24 83 7C 24 54 16 0F 8F 51 01 00 00 8B 74 24 30 8B 5C 24 30 8B 6C 24 10 8B 7C 24 14 8B 0C B5 ?? ?? ?? ?? 23 2C DD ?? ?? ?? ?? 8B 5C 24 14 23 1C F5 ?? ?? ?? ?? 89 0C 24 8B 74 24 10 0F B6 0C 24 0F AD FE D3 EF F6 C1 20 74 04 89 FE 31 FF B9 40 00 00 00 2B 0C 24 89 74 24 10 31 F6 89 7C 24 14 8B 7C 24 14 0F A5 C2 D3 E0 F6 C1 20 0F 45 D0 0F 45 C6 8B 74 24 10 09 D7 09 C6 09 EB 89 F0 89 FA 0F 85 EF F5 FF FF 8B 4C 24 40 31 D2 8B 44 24 58 89 CB 31 C9 01 C1 8B 44 24 0C 11 D3 0B 44 24 08 75 0E 89 DD 89 F0 09 CD 89 FA 0F 84 C5 F5 FF FF 8B 44 24 30 C1 E0 04 8B 90 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 39 44 24 0C 0F 82 7D 01 00 00 77 0A 39 54 24 08 0F 82 71 01 00 00 39 44 24 0C 0F 84 3C 01 00 00 89 F0 89 FA E9 89 F5 FF FF B8 01 00 00 00 31 D2 E9 01 FF FF FF 8B 4C 24 08 89 F8 89 EA 8B 5C 24 0C 0F A4 C2 01 01 C0 0F A4 CB 01 01 C9 3B 5C 24 0C 77 0E 72 06 3B 4C 24 08 73 06 83 C0 01 83 D2 00 83 FA 00 0F 87 2D F6 FF FF 83 F8 01 0F 87 24 F6 FF FF 83 F0 01 09 D0 0F 85 C4 F7 FF FF 83 C3 01 0F 85 BB F7 FF FF 83 C1 01 0F 85 B2 F7 FF FF E9 02 F6 FF FF 90 8D 74 26 00 8B 7C 24 30 89 C6 31 DB 8B 6C 24 30 8B 3C BD ?? ?? ?? ?? 89 F9 89 D7 83 E9 40 0F AD D6 D3 EF F6 C1 20 8B 0C ED ?? ?? ?? ?? 0F 45 F7 0F 45 FB 8B 1C ED ?? ?? ?? ?? 21 C1 89 F0 21 D3 89 FA 09 CB 0F 85 D2 F4 FF FF 8B 6C 24 10 8B 5C 24 14 E9 CA FE FF FF B8 EC FF FF FF 8B 4C 24 08 29 F0 8B 5C 24 0C F7 D6 C1 E0 04 03 88 ?? ?? ?? ?? 89 74 24 30 13 98 ?? ?? ?? ?? 03 B8 ?? ?? ?? ?? 13 A8 ?? ?? ?? ?? E9 FA FA FF FF 83 FD 00 0F 87 6C F5 FF FF 83 FF 09 0F 87 63 F5 FF FF 89 F8 83 F0 09 09 E8 0F 85 01 F7 FF FF 83 7C 24 0C FF 0F 82 F6 F6 FF FF 83 7C 24 08 FA 0F 86 EB F6 FF FF E9 3B F5 FF FF 39 54 24 08 0F 85 BA FE FF FF 8B 6C 24 30 C1 E5 04 3B 9D ?? ?? ?? ?? 0F 87 A7 FE FF FF 72 0C 3B 8D ?? ?? ?? ?? 0F 87 99 FE FF FF 89 F1 89 F0 83 E1 01 89 FA 85 C9 0F 84 1A F4 FF FF 83 C0 FF 83 D2 FF E9 0F F4 FF FF 8D B4 26 00 00 00 00 }
	condition:
		$1
}

rule file_92_1_0 {
	meta:
		name = "___bid128_to_uint64_xrnint"
		size = 4032
		refs = "0112 ___bid_nr_digits 016f ___bid_IDEC_glbflags 0269 ___bid_midpoint64 0337 ___bid_ten2k64 037e ___bid_midpoint128 05e7 ___bid_ten2k128 072b ___bid_ten2mk128 0a71 ___bid_shiftright128 0a7c ___bid_maskhigh128 0b07 ___bid_ten2mk128trunc 0b9e ___bid_onehalf128"
	strings:
		$1 = { 81 EC 9C 00 00 00 8B 84 24 A0 00 00 00 8B 8C 24 AC 00 00 00 89 9C 24 8C 00 00 00 89 B4 24 90 00 00 00 89 44 24 70 8B 84 24 A4 00 00 00 8B 5C 24 70 89 CA 81 E2 00 00 00 78 89 BC 24 94 00 00 00 89 44 24 74 8B 74 24 74 89 5C 24 10 89 CB 8B 84 24 A8 00 00 00 81 E3 00 00 00 80 81 FA 00 00 00 78 89 AC 24 98 00 00 00 89 74 24 14 0F 84 0E 01 00 00 89 CD 89 C7 81 E5 FF FF 01 00 81 FD 09 ED 01 00 76 2C 31 C0 31 D2 8B 9C 24 8C 00 00 00 8B B4 24 90 00 00 00 8B BC 24 94 00 00 00 8B AC 24 98 00 00 00 81 C4 9C 00 00 00 C3 90 8D 74 26 00 0F 83 EF 00 00 00 89 EA 89 F8 81 F2 09 ED 01 00 35 C0 87 AD BE 09 C2 0F 84 38 01 00 00 89 C8 25 00 00 00 60 3D 00 00 00 60 74 A9 89 EE 09 FE 0F 84 D0 00 00 00 89 7C 24 68 89 6C 24 6C DF 6C 24 68 DD 5C 24 18 8B 54 24 1C 89 D0 C1 E8 14 25 FF 07 00 00 2D BE 03 00 00 83 E8 01 89 C6 C1 E6 05 8B 96 ?? ?? ?? ?? 89 44 24 20 85 D2 75 34 8B 86 ?? ?? ?? ?? 8B 96 ?? ?? ?? ?? 8B B6 ?? ?? ?? ?? 89 44 24 18 39 F5 0F 87 95 01 00 00 0F 83 BE 01 00 00 8B 44 24 18 31 EE 31 F8 09 C6 0F 84 57 01 00 00 81 E1 00 00 FE 7F C1 E9 11 8D B1 E0 E7 FF FF 8D 04 32 83 F8 14 0F 8E C3 00 00 00 83 0D ?? ?? ?? ?? 01 31 C0 BA 00 00 00 80 E9 08 FF FF FF 89 C8 25 00 00 00 7C 3D 00 00 00 7C 0F 84 04 01 00 00 83 0D ?? ?? ?? ?? 01 31 C0 BA 00 00 00 80 E9 E3 FE FF FF 3D C0 87 AD BE 0F 87 D4 FE FF FF E9 01 FF FF FF 8B 74 24 14 31 C0 31 D2 0B 74 24 10 0F 84 C1 FE FF FF 81 7C 24 14 FF FF 1F 00 0F 86 0B 01 00 00 8B 54 24 14 89 D0 31 D2 89 44 24 68 89 54 24 6C DF 6C 24 68 DD 5C 24 18 8B 54 24 1C 89 D0 C1 E8 14 25 FF 07 00 00 2D DE 03 00 00 E9 03 FF FF FF 31 C0 31 D2 81 7C 24 14 63 8E 8D 37 0F 87 71 FE FF FF 89 CE 81 E6 00 00 00 60 81 FE 00 00 00 60 0F 85 BA FE FF FF E9 58 FE FF FF 0F 84 32 01 00 00 83 F8 00 8D B4 26 00 00 00 00 0F 8C 12 01 00 00 0F 85 C4 00 00 00 8D 42 FF 83 F8 12 0F 8F 1C 01 00 00 89 E9 09 F9 0F 85 65 01 00 00 8B 74 24 14 39 34 C5 ?? ?? ?? ?? 77 17 0F 82 52 01 00 00 8B 6C 24 10 39 2C C5 ?? ?? ?? ?? 0F 82 41 01 00 00 31 C0 31 D2 83 0D ?? ?? ?? ?? 20 E9 F2 FD FF FF 83 0D ?? ?? ?? ?? 01 31 C0 BA 00 00 00 80 E9 DF FD FF FF 8B 44 24 20 8B 74 24 14 C1 E0 05 05 ?? ?? ?? ?? 39 70 14 0F 87 90 FE FF FF 72 0D 8B 74 24 10 39 70 10 0F 87 81 FE FF FF 83 C2 01 E9 79 FE FF FF 8D B4 26 00 00 00 00 DF 6C 24 10 DD 5C 24 18 8B 54 24 1C 89 D0 C1 E8 14 25 FF 07 00 00 2D FE 03 00 00 E9 08 FE FF FF 39 C7 77 CD E9 39 FE FF FF 8D B4 26 00 00 00 00 85 DB 0F 85 55 FE FF FF 83 FE 00 90 8D 74 26 00 0F 8C AF 03 00 00 8B 44 24 10 8B 54 24 14 0F 84 54 FD FF FF 8B 0C F5 ?? ?? ?? ?? 0F AF CA 8B 14 F5 ?? ?? ?? ?? 0F AF D0 01 D1 F7 24 F5 ?? ?? ?? ?? 01 CA E9 30 FD FF FF 83 0D ?? ?? ?? ?? 20 31 C0 31 D2 E9 20 FD FF FF 85 DB 74 6F 83 FA 15 E9 F9 FD FF FF 8D 4A EC 89 C8 C1 E0 04 8B 90 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 39 C5 0F 82 F6 FE FF FF 77 08 39 D7 0F 82 EC FE FF FF 31 E8 31 FA 09 D0 75 25 C1 E1 04 8B 44 24 14 39 81 ?? ?? ?? ?? 0F 87 D1 FE FF FF 72 10 8B 54 24 10 39 91 ?? ?? ?? ?? 0F 83 BF FE FF FF 85 DB 0F 85 9E FD FF FF B8 01 00 00 00 31 D2 E9 AF FE FF FF 83 FA 01 0F 84 01 02 00 00 83 FA 13 0F 8F E5 00 00 00 8B 4C 24 10 B8 15 00 00 00 29 D0 8B 5C 24 14 89 4C 24 30 8B 0C C5 ?? ?? ?? ?? 8B 04 C5 ?? ?? ?? ?? 89 44 24 28 89 C8 F7 E3 89 44 24 18 8B 44 24 28 89 54 24 1C F7 E3 89 44 24 38 8B 44 24 30 89 54 24 3C F7 E1 89 54 24 24 8B 5C 24 24 31 D2 89 44 24 20 8B 44 24 18 89 D9 31 DB 01 C1 8B 44 24 28 11 D3 F7 64 24 30 01 C1 11 D3 8B 54 24 1C 89 D0 31 D2 89 44 24 28 8B 44 24 38 89 54 24 2C 8B 54 24 3C 01 44 24 28 11 54 24 2C 89 DA 89 D0 31 D2 01 44 24 28 11 54 24 2C 83 7C 24 2C 00 0F 87 DC FC FF FF 83 7C 24 28 09 0F 87 D1 FC FF FF 8B 44 24 28 83 F0 09 0B 44 24 2C 0F 85 6B FE FF FF 89 CA 8B 4C 24 20 31 C0 31 DB 01 C8 11 DA 83 FA FF 0F 82 54 FE FF FF 83 F8 FA 0F 86 4B FE FF FF E9 9B FC FF FF 83 FA 14 0F 84 7E 07 00 00 83 FA 15 66 90 0F 84 99 08 00 00 83 EA 15 8B 0C D5 ?? ?? ?? ?? 8B 14 D5 ?? ?? ?? ?? 89 4C 24 30 B9 FB FF FF FF 89 D0 89 54 24 28 F7 E1 89 44 24 20 B8 FF FF FF FF 89 54 24 24 F7 64 24 28 89 44 24 18 8B 44 24 30 89 54 24 1C F7 E1 89 54 24 3C 8B 5C 24 3C 31 D2 89 44 24 38 8B 44 24 20 89 D9 31 DB 01 C1 B8 FF FF FF FF 11 D3 F7 64 24 30 01 C1 B8 09 00 00 00 11 D3 8B 54 24 28 8D 14 D2 89 54 24 28 F7 64 24 30 03 54 24 28 01 44 24 18 11 54 24 1C 8B 54 24 24 89 D0 31 D2 01 44 24 18 11 54 24 1C 89 DA 89 D0 31 D2 01 44 24 18 11 54 24 1C 3B 6C 24 1C 0F 87 D7 FB FF FF 72 0A 3B 7C 24 18 0F 87 CB FB FF FF 3B 6C 24 1C 0F 85 6C FD FF FF 3B 7C 24 18 0F 85 62 FD FF FF 89 CA 8B 4C 24 38 31 C0 31 DB 01 C8 11 DA 3B 54 24 14 0F 87 4A FD FF FF 0F 82 99 FB FF FF 3B 44 24 10 0F 87 3A FD FF FF 66 90 E9 88 FB FF FF 8B 1D ?? ?? ?? ?? 8B 4C 24 14 8B 54 24 10 89 D8 89 54 24 28 F7 E1 89 44 24 30 A1 ?? ?? ?? ?? 89 54 24 34 F7 E1 89 44 24 18 8B 44 24 28 89 54 24 1C F7 E3 89 54 24 3C 8B 5C 24 3C 31 D2 89 44 24 38 8B 44 24 30 89 D9 31 DB 01 C1 A1 ?? ?? ?? ?? 11 D3 F7 64 24 28 01 C1 8B 44 24 10 11 D3 8B 54 24 14 0F AF 15 ?? ?? ?? ?? 0F AF 05 ?? ?? ?? ?? 01 D0 89 44 24 28 8B 44 24 10 F7 25 ?? ?? ?? ?? 89 44 24 20 8B 44 24 28 01 C2 8B 44 24 20 01 44 24 18 89 54 24 24 8B 54 24 24 11 54 24 1C 8B 54 24 34 89 D0 31 D2 01 44 24 18 11 54 24 1C 89 DA 89 D0 31 D2 01 44 24 18 11 54 24 1C 83 7C 24 1C 00 0F 87 C1 FA FF FF 83 7C 24 18 09 0F 87 B6 FA FF FF 8B 44 24 18 83 F0 09 0B 44 24 1C 0F 85 50 FC FF FF 89 CA 31 C0 8B 4C 24 38 E9 E0 FD FF FF 89 F3 F7 DB 83 FB 13 89 5C 24 5C 0F 8F DA 05 00 00 F7 D6 8B 4C 24 10 8B 5C 24 14 03 0C F5 ?? ?? ?? ?? 13 1C F5 ?? ?? ?? ?? 89 74 24 30 39 5C 24 14 72 0E 77 06 39 4C 24 10 76 06 83 C7 01 83 D5 00 89 4C 24 28 8B 4C 24 30 C7 44 24 44 00 00 00 00 C1 E1 04 8B 81 ?? ?? ?? ?? 8B B1 ?? ?? ?? ?? 89 44 24 48 89 D8 F7 E6 89 44 24 18 8B 44 24 48 89 54 24 1C F7 E3 89 44 24 20 8B 44 24 28 89 54 24 24 F7 E6 89 54 24 3C 8B 54 24 18 89 44 24 38 89 54 24 40 8B 54 24 3C 89 D0 31 D2 89 44 24 10 8B 44 24 40 01 44 24 10 8B 44 24 28 89 54 24 14 8B 54 24 44 11 54 24 14 F7 64 24 48 01 44 24 10 11 54 24 14 8B 54 24 1C 89 D0 31 D2 89 44 24 18 8B 44 24 20 01 44 24 18 89 54 24 1C 8B 54 24 24 11 54 24 1C 8B 54 24 14 89 D0 31 D2 01 44 24 18 11 54 24 1C 8B 91 ?? ?? ?? ?? 8B 89 ?? ?? ?? ?? 89 D0 89 54 24 40 F7 E3 89 4C 24 58 89 44 24 20 89 C8 89 54 24 24 F7 E3 89 44 24 60 8B 44 24 28 89 54 24 64 F7 64 24 40 89 54 24 54 8B 5C 24 54 31 D2 89 44 24 50 8B 44 24 20 89 D9 31 DB 01 C1 8B 44 24 28 11 D3 F7 64 24 58 01 C1 11 D3 8B 54 24 24 89 D0 31 D2 89 44 24 20 8B 44 24 60 89 54 24 24 8B 54 24 64 01 44 24 20 11 54 24 24 89 DA 89 D0 31 D2 89 4C 24 2C 8B 4C 24 10 01 44 24 20 11 54 24 24 31 C0 31 D2 89 44 24 28 8B 44 24 50 89 CB 01 44 24 28 11 54 24 2C 31 C9 8B 44 24 38 31 D2 89 4C 24 10 01 44 24 10 8B 44 24 20 89 5C 24 14 11 54 24 14 8B 54 24 24 01 44 24 10 11 54 24 14 8B 4C 24 14 39 CA 72 14 77 08 8B 5C 24 10 39 D8 76 0A 83 44 24 18 01 83 54 24 1C 00 89 E9 89 FD 89 C8 F7 E6 89 44 24 38 8B 44 24 48 89 54 24 3C F7 E1 89 44 24 20 89 F8 89 54 24 24 F7 E6 89 54 24 54 8B 7C 24 54 31 D2 89 44 24 50 8B 44 24 38 89 FE 31 FF 01 C6 8B 44 24 48 11 D7 F7 E5 01 C6 11 D7 8B 54 24 3C 89 D0 31 D2 89 44 24 38 8B 44 24 20 01 44 24 38 8B 44 24 40 89 54 24 3C 8B 54 24 24 11 54 24 3C 31 D2 01 7C 24 38 89 F7 11 54 24 3C F7 E1 89 44 24 20 8B 44 24 58 89 54 24 24 F7 E1 89 44 24 48 8B 44 24 40 89 54 24 4C F7 E5 89 44 24 40 89 54 24 44 8B 5C 24 44 31 D2 8B 44 24 20 89 D9 31 DB 01 C1 8B 44 24 58 11 D3 F7 E5 01 C1 11 D3 8B 54 24 24 89 D0 31 D2 89 44 24 20 8B 44 24 48 01 44 24 20 8B 44 24 40 89 54 24 24 8B 54 24 4C 11 54 24 24 31 D2 01 5C 24 20 89 CB 11 54 24 24 31 C9 31 D2 01 C1 8B 44 24 50 11 D3 31 F6 31 D2 01 C6 11 D7 03 74 24 20 13 7C 24 24 39 7C 24 24 72 12 77 06 39 74 24 20 76 0A 83 44 24 38 01 83 54 24 3C 00 8B 44 24 10 8B 54 24 14 01 C8 11 DA 89 54 24 14 31 D2 3B 5C 24 14 89 44 24 10 B8 01 00 00 00 77 0C 72 06 3B 4C 24 10 77 04 31 C0 31 D2 8B 4C 24 18 01 C6 8B 5C 24 1C 11 D7 01 F1 11 FB 39 DF 89 4C 24 18 89 5C 24 1C 0F 87 31 02 00 00 72 08 39 CE 0F 87 27 02 00 00 31 DB 39 FA B9 01 00 00 00 77 0A 72 04 39 F0 77 04 31 C9 31 DB 89 C8 89 DA 8B 5C 24 38 8B 74 24 3C 01 C3 11 D6 83 7C 24 5C 16 89 5C 24 40 89 74 24 44 0F 8F 97 02 00 00 8B 6C 24 30 8B 54 24 1C 8B 44 24 18 8B 74 24 18 8B 1C AD ?? ?? ?? ?? 8B 7C 24 1C 23 34 ED ?? ?? ?? ?? 23 3C ED ?? ?? ?? ?? 31 ED 89 D9 0F AD D0 D3 EA F6 C3 20 0F 45 C2 0F 45 D5 89 44 24 18 8B 44 24 40 B9 40 00 00 00 89 54 24 1C 8B 54 24 44 29 D9 31 DB 0F A5 C2 D3 E0 F6 C1 20 8B 4C 24 18 0F 45 D0 0F 45 C3 8B 5C 24 1C 09 C1 09 D3 83 7C 24 5C 03 0F 8F C0 00 00 00 81 7C 24 14 00 00 00 80 0F 86 D9 02 00 00 8B 44 24 10 8B 54 24 14 83 C0 00 89 44 24 18 8B 44 24 30 81 D2 00 00 00 80 89 54 24 1C C1 E0 04 8B 90 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 39 44 24 1C 0F 87 26 01 00 00 72 0A 39 54 24 18 0F 87 1A 01 00 00 39 44 24 1C 0F 84 A4 03 00 00 89 FD 89 C8 09 F5 89 DA 0F 85 49 F5 FF FF 8B 44 24 14 0B 44 24 10 75 12 8B 74 24 2C 89 C8 89 DA 0B 74 24 28 0F 84 2D F5 FF FF 8B 44 24 30 C1 E0 04 8B 90 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 39 44 24 14 0F 82 41 03 00 00 77 0A 39 54 24 10 0F 82 35 03 00 00 39 44 24 14 0F 84 F8 02 00 00 89 C8 89 DA E9 F1 F4 FF FF 8B 54 24 30 8B 04 D5 ?? ?? ?? ?? 8B 14 D5 ?? ?? ?? ?? 89 44 24 18 39 D7 89 54 24 1C 0F 87 58 03 00 00 72 08 39 C6 0F 87 4E 03 00 00 3B 7C 24 1C 75 78 3B 74 24 18 75 72 8B 44 24 14 0B 44 24 10 75 0A 8B 54 24 2C 0B 54 24 28 74 5E 8B 44 24 30 C1 E0 04 8B 90 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 39 44 24 14 77 45 72 06 39 54 24 10 77 3D 39 44 24 14 0F 85 23 FF FF FF 39 54 24 10 0F 85 19 FF FF FF 8B 44 24 30 8B 6C 24 2C C1 E0 04 3B A8 ?? ?? ?? ?? 0F 82 02 FF FF FF 77 10 8B 54 24 28 3B 90 ?? ?? ?? ?? 0F 86 F0 FE FF FF 83 0D ?? ?? ?? ?? 20 E9 E4 FE FF FF B8 01 00 00 00 31 D2 E9 E6 FD FF FF 8B 4C 24 10 89 F8 89 EA 8B 5C 24 14 0F A4 C2 01 01 C0 0F A4 CB 01 01 C9 3B 5C 24 14 77 0E 72 06 3B 4C 24 10 73 06 83 C0 01 83 D2 00 83 FA 00 0F 87 DF F4 FF FF 83 F8 01 0F 87 D6 F4 FF FF 83 F0 01 09 D0 0F 85 76 F6 FF FF 83 C3 01 0F 85 6D F6 FF FF 83 C1 01 0F 85 64 F6 FF FF E9 B4 F4 FF FF 8D B4 26 00 00 00 00 B8 EC FF FF FF 8B 4C 24 10 29 F0 8B 5C 24 14 F7 D6 C1 E0 04 03 88 ?? ?? ?? ?? 89 74 24 30 13 98 ?? ?? ?? ?? 03 B8 ?? ?? ?? ?? 13 A8 ?? ?? ?? ?? E9 0D FA FF FF 8B 5C 24 30 31 FF 8B 74 24 40 8B 54 24 44 8B 6C 24 44 8B 04 9D ?? ?? ?? ?? 23 34 DD ?? ?? ?? ?? 23 2C DD ?? ?? ?? ?? 89 C1 8B 44 24 40 89 74 24 20 8B 74 24 30 83 E9 40 89 6C 24 38 0F AD D0 D3 EA F6 C1 20 0F 45 C2 0F 45 D7 89 C1 8B 04 F5 ?? ?? ?? ?? 89 D3 8B 14 F5 ?? ?? ?? ?? 39 C5 0F 86 BD 00 00 00 83 0D ?? ?? ?? ?? 20 8B 74 24 18 8B 7C 24 1C 8B 6C 24 38 89 C8 89 DA 0B 6C 24 20 0F 85 0E F3 FF FF E9 B2 FD FF FF 83 FD 00 0F 87 E5 F3 FF FF 83 FF 09 90 8D 74 26 00 0F 87 D7 F3 FF FF 89 F8 83 F0 09 09 E8 0F 85 75 F5 FF FF 83 7C 24 14 FF 0F 82 6A F5 FF FF 83 7C 24 10 FA 0F 86 5F F5 FF FF E9 AF F3 FF FF 66 90 72 0B 83 7C 24 10 00 0F 87 18 FD FF FF 8B 44 24 14 05 00 00 00 80 0B 44 24 10 0F 85 61 FE FF FF 8B 6C 24 2C 0B 6C 24 28 0F 84 53 FE FF FF 8B 44 24 30 C7 44 24 18 00 00 00 00 C7 44 24 1C 00 00 00 00 C1 E0 04 8B 90 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? E9 11 FD FF FF 72 0A 39 54 24 20 0F 87 37 FF FF FF 39 44 24 38 0F 85 2D FF FF FF 39 54 24 20 0F 85 23 FF FF FF 8B 74 24 1C 0B 74 24 18 0F 85 15 FF FF FF 8B 6C 24 14 0B 6C 24 10 0F 85 34 01 00 00 8B 44 24 2C 0B 44 24 28 0F 84 F9 FE FF FF 8B 44 24 30 C1 E0 04 8B 90 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 39 44 24 14 0F 84 CD 00 00 00 31 F6 31 FF E9 E2 FE FF FF 39 54 24 10 0F 85 FE FC FF FF 8B 6C 24 30 8B 44 24 2C C1 E5 04 3B 85 ?? ?? ?? ?? 0F 87 E7 FC FF FF 72 10 8B 54 24 28 3B 95 ?? ?? ?? ?? 0F 87 D5 FC FF FF 89 CE 89 C8 83 E6 01 89 DA 85 F6 0F 84 BE F1 FF FF 83 C0 FF 83 D2 FF E9 B3 F1 FF FF 39 54 24 18 0F 85 52 FC FF FF 8B 44 24 30 8B 54 24 2C C1 E0 04 3B 90 ?? ?? ?? ?? 0F 82 3B FC FF FF 0F 87 45 FD FF FF 8B 6C 24 28 3B A8 ?? ?? ?? ?? 0F 82 25 FC FF FF E9 30 FD FF FF 89 F0 89 FA 2B 44 24 18 1B 54 24 1C 89 44 24 18 39 D7 89 54 24 1C 0F 82 14 FD FF FF 77 08 39 C6 0F 82 0A FD FF FF 8B 54 24 1C 0B 54 24 18 0F 84 9E FC FF FF E9 F7 FC FF FF 39 54 24 10 0F 85 29 FF FF FF 8B 44 24 30 8B 54 24 2C C1 E0 04 3B 90 ?? ?? ?? ?? 0F 82 12 FF FF FF 0F 87 E8 FD FF FF 8B 74 24 28 3B B0 ?? ?? ?? ?? 0F 86 FC FE FF FF E9 D3 FD FF FF 8B 44 24 30 C1 E0 04 8B 90 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 39 44 24 14 0F 87 B6 FD FF FF 0F 82 CA FE FF FF 39 54 24 10 0F 87 A6 FD FF FF E9 BB FE FF FF 90 8D B4 26 00 00 00 00 }
	condition:
		$1
}

rule file_92_2_0 {
	meta:
		name = "___bid128_to_uint64_floor"
		size = 2208
		refs = "00f5 ___bid_IDEC_glbflags 0161 ___bid_nr_digits 01ea ___bid_ten2k64 03ad ___bid_ten2mk128 06c9 ___bid_shiftright128 07a3 ___bid_ten2k128"
	strings:
		$1 = { 81 EC 9C 00 00 00 8B 84 24 A0 00 00 00 8B 8C 24 A8 00 00 00 89 B4 24 90 00 00 00 8B B4 24 AC 00 00 00 89 9C 24 8C 00 00 00 89 44 24 70 8B 84 24 A4 00 00 00 89 4C 24 10 8B 4C 24 70 89 AC 24 98 00 00 00 89 F5 81 E5 00 00 00 80 89 44 24 74 8B 5C 24 74 89 F0 25 00 00 00 78 3D 00 00 00 78 89 BC 24 94 00 00 00 89 4C 24 40 89 5C 24 44 0F 84 9C 01 00 00 89 F3 8B 4C 24 10 81 E3 FF FF 01 00 81 FB 09 ED 01 00 76 28 31 C0 31 D2 8B 9C 24 8C 00 00 00 8B B4 24 90 00 00 00 8B BC 24 94 00 00 00 8B AC 24 98 00 00 00 81 C4 9C 00 00 00 C3 90 0F 83 7B 01 00 00 89 DA 89 C8 81 F2 09 ED 01 00 35 C0 87 AD BE 09 C2 74 3A 89 F0 25 00 00 00 60 3D 00 00 00 60 74 B1 89 DF 09 CF 75 53 8B 7C 24 44 31 C0 31 D2 0B 7C 24 40 74 A1 85 ED 0F 84 62 01 00 00 83 0D ?? ?? ?? ?? 01 31 C0 BA 00 00 00 80 EB 89 31 C0 31 D2 81 7C 24 44 63 8E 8D 37 0F 87 77 FF FF FF 89 F7 81 E7 00 00 00 60 81 FF 00 00 00 60 0F 84 63 FF FF FF 8D B4 26 00 00 00 00 85 ED 75 BF 89 4C 24 68 89 5C 24 6C DF 6C 24 68 DD 5C 24 08 8B 54 24 0C 89 D0 C1 E8 14 25 FF 07 00 00 2D BE 03 00 00 8D 68 FF 89 EA C1 E2 05 8B 82 ?? ?? ?? ?? 85 C0 75 3A 8B BA ?? ?? ?? ?? 8B 82 ?? ?? ?? ?? 8B 92 ?? ?? ?? ?? 89 7C 24 18 39 D3 0F 87 2F 01 00 00 72 08 39 F9 0F 87 25 01 00 00 89 D7 8B 54 24 18 31 DF 31 CA 09 FA 0F 84 EC 00 00 00 81 E6 00 00 FE 7F C1 EE 11 81 EE 20 18 00 00 8D 3C 30 83 FF 14 0F 8F 35 FF FF FF 0F 84 1C 01 00 00 31 C0 31 D2 85 FF 0F 8E BC FE FF FF 83 FE 00 0F 8C BF 01 00 00 8B 44 24 40 8B 54 24 44 0F 84 A5 FE FF FF 8B 0C F5 ?? ?? ?? ?? 0F AF CA 8B 14 F5 ?? ?? ?? ?? 0F AF D0 01 D1 F7 24 F5 ?? ?? ?? ?? 01 CA E9 81 FE FF FF 90 8D 74 26 00 89 F0 25 00 00 00 7C 3D 00 00 00 7C 74 24 83 0D ?? ?? ?? ?? 01 31 C0 BA 00 00 00 80 E9 5B FE FF FF 81 F9 C0 87 AD BE 0F 87 4B FE FF FF E9 74 FE FF FF 83 0D ?? ?? ?? ?? 01 31 C0 BA 00 00 00 80 E9 37 FE FF FF 81 7C 24 44 FF FF 1F 00 76 61 8B 54 24 44 89 D0 31 D2 89 44 24 68 89 54 24 6C DF 6C 24 68 DD 5C 24 08 8B 54 24 0C 89 D0 C1 E8 14 25 FF 07 00 00 2D DE 03 00 00 E9 C8 FE FF FF 89 EA 8B 7C 24 44 C1 E2 05 81 C2 ?? ?? ?? ?? 39 7A 14 0F 87 FC FE FF FF 72 0D 8B 7C 24 40 39 7A 10 0F 87 ED FE FF FF 83 C0 01 E9 E5 FE FF FF 66 90 DF 6C 24 40 DD 5C 24 08 8B 54 24 0C 89 D0 C1 E8 14 25 FF 07 00 00 2D FE 03 00 00 E9 77 FE FF FF 83 F8 01 0F 84 AB 04 00 00 83 F8 13 0F 8F 29 04 00 00 8B 54 24 40 31 ED 8B 7C 24 44 89 54 24 38 BA 15 00 00 00 29 C2 8B 04 D5 ?? ?? ?? ?? 8B 14 D5 ?? ?? ?? ?? 89 44 24 08 89 54 24 28 F7 E7 89 44 24 18 8B 44 24 28 89 54 24 1C F7 E7 8B 7C 24 18 89 44 24 20 8B 44 24 08 89 54 24 24 F7 64 24 38 89 D0 31 D2 89 44 24 08 8B 44 24 28 01 7C 24 08 89 54 24 0C 11 6C 24 0C 8B 6C 24 1C 89 EF 31 ED 03 7C 24 20 13 6C 24 24 F7 64 24 38 01 44 24 08 11 54 24 0C 8B 54 24 0C 89 D0 31 D2 01 C7 11 D5 83 FD 00 0F 87 69 FD FF FF 83 FF 09 0F 86 3D FE FF FF E9 5B FD FF FF 89 F7 F7 D6 8B 44 24 44 89 F5 F7 DF C1 E5 04 89 74 24 60 8B B5 ?? ?? ?? ?? 89 44 24 28 89 7C 24 64 8B BD ?? ?? ?? ?? 89 F0 F7 64 24 28 89 7C 24 48 89 74 24 30 89 44 24 08 89 F8 89 54 24 0C F7 64 24 28 89 44 24 18 89 F0 89 54 24 1C F7 64 24 40 89 54 24 5C 8B 7C 24 5C 31 D2 89 44 24 58 8B 44 24 08 89 FE 31 FF 01 C6 8B 44 24 48 11 D7 F7 64 24 40 01 C6 11 D7 8B 54 24 0C 89 D0 31 D2 89 44 24 08 8B 44 24 18 01 44 24 08 89 54 24 0C 8B 54 24 1C 11 54 24 0C 31 D2 01 7C 24 08 11 54 24 0C 8B 95 ?? ?? ?? ?? 8B AD ?? ?? ?? ?? C7 44 24 54 00 00 00 00 89 54 24 38 89 D0 F7 64 24 28 89 44 24 18 8B 44 24 28 89 54 24 1C F7 E5 89 54 24 2C 8B 54 24 18 89 44 24 28 8B 44 24 38 89 54 24 50 F7 64 24 40 89 D0 31 D2 89 44 24 20 8B 44 24 50 01 44 24 20 89 54 24 24 8B 54 24 54 11 54 24 24 8B 54 24 1C 89 D0 31 D2 89 44 24 18 8B 44 24 28 01 44 24 18 8B 44 24 40 89 54 24 1C 8B 54 24 2C 11 54 24 1C F7 E5 01 44 24 20 11 54 24 24 8B 54 24 24 89 74 24 24 89 D0 31 D2 01 44 24 18 11 54 24 1C 31 C0 31 D2 8B 74 24 18 89 44 24 20 8B 44 24 58 01 44 24 20 11 54 24 24 8B 7C 24 1C 01 74 24 20 11 7C 24 24 8B 44 24 24 39 C7 72 14 77 08 8B 54 24 20 39 D6 76 0A 83 44 24 08 01 83 54 24 0C 00 8B 44 24 30 89 DE F7 E3 89 44 24 18 8B 44 24 48 89 54 24 1C 8B 4C 24 18 F7 E3 31 DB 89 44 24 40 8B 44 24 10 89 54 24 44 F7 64 24 30 89 44 24 30 89 D0 89 44 24 28 8B 44 24 10 89 54 24 34 31 D2 89 54 24 2C F7 64 24 48 01 44 24 28 11 54 24 2C 01 4C 24 28 11 5C 24 2C 8B 5C 24 1C 89 D9 31 DB 89 4C 24 18 8B 4C 24 40 01 4C 24 18 89 5C 24 1C 8B 5C 24 44 11 5C 24 1C 8B 54 24 2C 89 D0 31 D2 01 44 24 18 8B 44 24 38 11 54 24 1C 31 FF 31 DB F7 E6 89 44 24 40 89 F0 8B 74 24 40 89 54 24 44 F7 E5 89 44 24 48 8B 44 24 10 89 54 24 4C F7 64 24 38 89 44 24 38 8B 44 24 10 89 D1 89 54 24 3C F7 E5 01 C1 11 D3 01 F1 11 FB 8B 7C 24 44 89 4C 24 14 8B 4C 24 28 89 FE 31 FF 03 74 24 48 13 7C 24 4C 31 D2 01 DE 89 CB 11 D7 31 C0 89 44 24 10 8B 44 24 38 31 D2 01 44 24 10 8B 44 24 30 11 54 24 14 31 C9 31 D2 01 C1 11 D3 01 F1 11 FB 39 DF 72 10 77 04 39 CE 76 0A 83 44 24 18 01 83 54 24 1C 00 8B 44 24 20 BE 01 00 00 00 8B 54 24 24 03 44 24 10 13 54 24 14 31 FF 39 54 24 14 77 0C 72 06 39 44 24 10 77 04 31 F6 31 FF 8B 44 24 08 01 F1 8B 54 24 0C 11 FB 01 C8 11 DA 39 D3 89 44 24 08 89 54 24 0C 0F 87 DF 00 00 00 72 08 39 C1 0F 87 D5 00 00 00 31 D2 39 DF B8 01 00 00 00 77 0A 72 04 39 CE 77 04 31 C0 31 D2 03 44 24 18 13 54 24 1C 83 7C 24 64 16 0F 8F B9 00 00 00 8B 5C 24 60 31 ED 8B 7C 24 0C 8B 74 24 08 8B 0C 9D ?? ?? ?? ?? 89 C3 0F AD FE D3 EF F6 C1 20 0F 45 F7 0F 45 FD BD 40 00 00 00 29 CD 89 E9 89 74 24 10 89 D6 0F A5 C6 31 C0 D3 E3 F6 C1 20 0F 45 F3 0F 45 D8 89 74 24 0C 8B 54 24 0C 89 5C 24 08 8B 44 24 08 89 7C 24 14 0B 44 24 10 09 FA E9 71 F9 FF FF 83 F8 14 0F 84 46 01 00 00 83 F8 15 0F 84 4E 01 00 00 8D 50 EB B8 0A 00 00 00 6B 3C D5 ?? ?? ?? ?? 0A F7 24 D5 ?? ?? ?? ?? 01 FA 39 D3 0F 82 82 FA FF FF 0F 87 9F F9 FF FF 39 C1 0F 82 74 FA FF FF 8D 74 26 00 E9 8E F9 FF FF B8 01 00 00 00 31 D2 E9 34 FF FF FF 8B 74 24 60 31 FF 8B 0C B5 ?? ?? ?? ?? 83 E9 40 0F AD D0 D3 EA 83 E1 20 0F 45 C2 0F 45 D7 E9 F8 F8 FF FF 8B 44 24 40 31 ED 8B 7C 24 44 89 44 24 38 A1 ?? ?? ?? ?? F7 E7 89 44 24 30 A1 ?? ?? ?? ?? 89 54 24 34 F7 E7 8B 7C 24 30 89 44 24 18 A1 ?? ?? ?? ?? 89 54 24 1C F7 64 24 38 89 D0 31 D2 89 44 24 08 8B 44 24 40 01 7C 24 08 89 54 24 0C 8B 54 24 44 11 6C 24 0C 0F AF 15 ?? ?? ?? ?? 0F AF 05 ?? ?? ?? ?? 8D 3C 02 8B 44 24 40 F7 25 ?? ?? ?? ?? 01 FA 89 44 24 28 8B 44 24 28 01 44 24 18 89 54 24 2C 8B 54 24 2C 11 54 24 1C 8B 54 24 34 89 D0 31 D2 01 44 24 18 A1 ?? ?? ?? ?? 11 54 24 1C F7 64 24 38 01 44 24 08 11 54 24 0C 8B 54 24 0C 89 D0 31 D2 01 44 24 18 11 54 24 1C 83 7C 24 1C 00 0F 87 99 F8 FF FF 83 7C 24 18 09 0F 86 6B F9 FF FF E9 89 F8 FF FF 89 DA 09 CA 66 90 0F 85 7D F8 FF FF E9 55 F9 FF FF 83 FB 00 66 90 0F 87 6D F8 FF FF 83 F9 09 0F 86 41 F9 FF FF 90 E9 5E F8 FF FF 8D 74 26 00 8D BC 27 00 00 00 00 }
	condition:
		$1
}

rule file_92_3_0 {
	meta:
		name = "___bid128_to_uint64_xfloor"
		size = 2768
		refs = "00f8 ___bid_IDEC_glbflags 0169 ___bid_nr_digits 01f7 ___bid_ten2k64 03d7 ___bid_ten2mk128 0769 ___bid_maskhigh128 0777 ___bid_shiftright128 07da ___bid_ten2mk128trunc 0991 ___bid_ten2k128"
	strings:
		$1 = { 81 EC 9C 00 00 00 8B 84 24 A0 00 00 00 8B 8C 24 AC 00 00 00 89 BC 24 94 00 00 00 89 B4 24 90 00 00 00 89 44 24 70 8B 84 24 A4 00 00 00 8B 74 24 70 89 9C 24 8C 00 00 00 8B 9C 24 A8 00 00 00 89 AC 24 98 00 00 00 89 44 24 74 8B 7C 24 74 89 C8 25 00 00 00 78 89 74 24 08 89 7C 24 0C 89 CF 81 E7 00 00 00 80 3D 00 00 00 78 89 7C 24 18 0F 84 A4 01 00 00 89 CF 89 DE 81 E7 FF FF 01 00 81 FF 09 ED 01 00 76 2A 31 C0 31 D2 8B 9C 24 8C 00 00 00 8B B4 24 90 00 00 00 8B BC 24 94 00 00 00 8B AC 24 98 00 00 00 81 C4 9C 00 00 00 C3 8D 76 00 0F 83 8A 01 00 00 89 FA 89 F0 81 F2 09 ED 01 00 35 C0 87 AD BE 09 C2 74 3D 89 C8 25 00 00 00 60 3D 00 00 00 60 74 AF 89 FD 09 F5 75 53 8B 6C 24 0C 31 C0 31 D2 0B 6C 24 08 74 9F 83 7C 24 18 00 0F 84 5B 01 00 00 83 0D ?? ?? ?? ?? 01 31 C0 BA 00 00 00 80 EB 84 31 C0 31 D2 81 7C 24 0C 63 8E 8D 37 0F 87 72 FF FF FF 89 CD 81 E5 00 00 00 60 81 FD 00 00 00 60 0F 84 5E FF FF FF 8D 74 26 00 8B 44 24 18 85 C0 75 BE 89 74 24 68 89 7C 24 6C DF 6C 24 68 DD 5C 24 10 8B 54 24 14 89 D0 C1 E8 14 25 FF 07 00 00 2D BE 03 00 00 83 E8 01 89 C2 C1 E2 05 89 44 24 20 8B 82 ?? ?? ?? ?? 85 C0 75 3F 8B AA ?? ?? ?? ?? 8B 82 ?? ?? ?? ?? 8B 92 ?? ?? ?? ?? 89 6C 24 10 39 D7 0F 87 25 01 00 00 72 08 39 EE 0F 87 1B 01 00 00 89 D5 8B 54 24 10 31 FD 31 F2 09 EA 0F 84 E0 00 00 00 90 8D 74 26 00 81 E1 00 00 FE 7F C1 E9 11 8D A9 E0 E7 FF FF 8D 14 28 83 FA 14 0F 8F 2B FF FF FF 0F 84 0F 01 00 00 85 D2 0F 8E 3A 06 00 00 83 FD 00 8D 74 26 00 0F 8C DC 01 00 00 8B 44 24 08 8B 54 24 0C 0F 84 96 FE FF FF 8B 0C ED ?? ?? ?? ?? 0F AF CA 8B 14 ED ?? ?? ?? ?? 0F AF D0 01 D1 F7 24 ED ?? ?? ?? ?? 01 CA E9 72 FE FF FF 89 C8 25 00 00 00 7C 3D 00 00 00 7C 0F 85 CC FE FF FF 83 0D ?? ?? ?? ?? 01 31 C0 BA 00 00 00 80 E9 4D FE FF FF 8D 76 00 81 FB C0 87 AD BE 0F 87 3A FE FF FF E9 65 FE FF FF 81 7C 24 0C FF FF 1F 00 76 65 8B 54 24 0C 89 D0 31 D2 89 44 24 68 89 54 24 6C DF 6C 24 68 DD 5C 24 10 8B 54 24 14 89 D0 C1 E8 14 25 FF 07 00 00 2D DE 03 00 00 E9 D0 FE FF FF 8B 54 24 20 8B 6C 24 0C C1 E2 05 81 C2 ?? ?? ?? ?? 39 6A 14 0F 87 0B FF FF FF 72 0D 8B 6C 24 08 39 6A 10 0F 87 FC FE FF FF 83 C0 01 E9 F4 FE FF FF 8D 74 26 00 DF 6C 24 08 DD 5C 24 10 8B 54 24 14 89 D0 C1 E8 14 25 FF 07 00 00 2D FE 03 00 00 E9 7B FE FF FF 83 F8 01 0F 84 93 06 00 00 83 F8 13 0F 8F 31 05 00 00 BA 15 00 00 00 8B 4C 24 0C 29 C2 8B 04 D5 ?? ?? ?? ?? 8B 14 D5 ?? ?? ?? ?? 89 4C 24 28 8B 4C 24 08 C7 44 24 24 00 00 00 00 89 44 24 10 89 54 24 38 F7 64 24 28 89 44 24 18 8B 44 24 38 89 54 24 1C F7 64 24 28 89 44 24 28 8B 44 24 10 89 54 24 2C 8B 54 24 18 89 54 24 20 F7 E1 89 D0 31 D2 89 44 24 10 8B 44 24 20 01 44 24 10 89 54 24 14 8B 54 24 24 11 54 24 14 8B 54 24 1C 89 D0 31 D2 89 44 24 18 8B 44 24 28 01 44 24 18 89 54 24 1C 8B 54 24 2C 11 54 24 1C 8B 44 24 38 F7 E1 01 44 24 10 11 54 24 14 8B 4C 24 14 89 CA 31 C9 01 54 24 18 11 4C 24 1C 83 7C 24 1C 00 0F 87 44 FD FF FF 83 7C 24 18 09 0F 86 1C FE FF FF E9 34 FD FF FF 8B 54 24 0C 89 E8 F7 D5 89 E9 F7 D8 C1 E1 04 89 44 24 64 8B 81 ?? ?? ?? ?? 89 54 24 30 8B 91 ?? ?? ?? ?? C7 44 24 24 00 00 00 00 89 44 24 38 89 54 24 50 F7 64 24 30 89 44 24 18 8B 44 24 50 89 54 24 1C F7 64 24 30 89 44 24 28 8B 44 24 38 89 54 24 2C F7 64 24 08 89 54 24 44 8B 54 24 18 89 44 24 40 89 54 24 20 8B 54 24 44 89 D0 31 D2 89 44 24 10 8B 44 24 20 01 44 24 10 8B 44 24 50 89 54 24 14 8B 54 24 24 11 54 24 14 F7 64 24 08 01 44 24 10 11 54 24 14 8B 54 24 1C 89 D0 31 D2 89 44 24 18 8B 44 24 28 01 44 24 18 89 54 24 1C 8B 54 24 2C 11 54 24 1C 8B 54 24 14 89 D0 31 D2 01 44 24 18 11 54 24 1C 8B 91 ?? ?? ?? ?? 8B 89 ?? ?? ?? ?? 89 54 24 48 89 D0 F7 64 24 30 89 44 24 20 8B 44 24 30 89 54 24 24 F7 E1 89 44 24 30 8B 44 24 48 89 54 24 34 F7 64 24 08 89 54 24 5C 8B 54 24 20 89 44 24 58 89 14 24 8B 54 24 5C C7 44 24 04 00 00 00 00 89 D0 31 D2 89 44 24 28 8B 04 24 01 44 24 28 8B 44 24 08 89 54 24 2C 8B 54 24 04 11 54 24 2C F7 E1 01 44 24 28 11 54 24 2C 8B 54 24 24 89 D0 31 D2 89 44 24 20 8B 44 24 30 01 44 24 20 89 54 24 24 8B 54 24 34 11 54 24 24 8B 54 24 2C 89 D0 31 D2 01 44 24 20 8B 44 24 28 11 54 24 24 89 C2 31 C0 89 44 24 28 8B 44 24 58 89 54 24 2C 31 D2 01 44 24 28 8B 44 24 10 11 54 24 2C 89 C2 31 C0 89 44 24 10 8B 44 24 40 89 54 24 14 31 D2 01 44 24 10 8B 44 24 20 11 54 24 14 01 44 24 10 8B 54 24 24 11 54 24 14 8B 44 24 14 39 C2 72 16 77 0A 8B 54 24 10 39 54 24 20 76 0A 83 44 24 18 01 83 54 24 1C 00 89 F8 F7 64 24 38 89 7C 24 40 89 44 24 20 89 F8 8B 74 24 20 89 54 24 24 31 FF F7 64 24 50 89 44 24 08 8B 44 24 38 89 54 24 0C F7 E3 89 44 24 38 89 D0 89 44 24 30 8B 44 24 50 89 54 24 3C 31 D2 89 54 24 34 F7 E3 01 44 24 30 11 54 24 34 01 74 24 30 11 7C 24 34 8B 7C 24 24 8B 54 24 34 89 FE 31 FF 89 74 24 20 8B 74 24 08 89 D0 01 74 24 20 89 7C 24 24 8B 7C 24 0C 11 7C 24 24 31 D2 01 44 24 20 8B 44 24 40 11 54 24 24 F7 64 24 48 C7 44 24 54 00 00 00 00 89 44 24 08 8B 44 24 40 89 54 24 0C F7 E1 89 44 24 40 8B 44 24 48 89 54 24 44 F7 E3 89 54 24 4C 8B 54 24 08 8B 7C 24 4C 89 44 24 48 89 D8 8B 5C 24 0C 89 54 24 50 F7 E1 89 FE 31 FF 89 D9 89 4C 24 08 8B 4C 24 40 01 C6 11 D7 03 74 24 50 13 7C 24 54 31 DB 89 5C 24 0C 8B 5C 24 44 01 4C 24 08 11 5C 24 0C 31 D2 01 7C 24 08 89 F7 11 54 24 0C 31 F6 8B 44 24 48 31 D2 8B 4C 24 30 01 C6 8B 44 24 38 11 D7 89 CB 31 C9 31 D2 01 C1 11 D3 03 4C 24 08 13 5C 24 0C 39 5C 24 0C 72 12 77 06 39 4C 24 08 76 0A 83 44 24 20 01 83 54 24 24 00 8B 44 24 10 8B 54 24 14 01 F0 11 FA 89 54 24 14 31 D2 3B 7C 24 14 89 44 24 10 B8 01 00 00 00 77 0C 72 06 3B 74 24 10 77 04 31 C0 31 D2 8B 74 24 18 01 C1 8B 7C 24 1C 11 D3 01 CE 11 DF 39 FB 89 74 24 18 89 7C 24 1C 0F 87 C8 01 00 00 72 08 39 F1 0F 87 BE 01 00 00 31 FF 39 DA BE 01 00 00 00 77 0A 72 04 39 C8 77 04 31 F6 31 FF 89 F0 89 FA 8B 74 24 20 8B 7C 24 24 01 C6 11 D7 83 7C 24 64 16 0F 8F 0A 01 00 00 8B 04 ED ?? ?? ?? ?? 8B 14 ED ?? ?? ?? ?? 8B 1C AD ?? ?? ?? ?? 89 44 24 30 8B 44 24 18 89 54 24 20 8B 54 24 1C 89 D9 0F AD D0 D3 EA F6 C1 20 74 04 89 D0 31 D2 89 44 24 08 B8 40 00 00 00 29 D8 8B 5C 24 08 89 C1 31 C0 0F A5 F7 89 54 24 0C D3 E6 F6 C1 20 8B 4C 24 0C 0F 45 FE 0F 45 F0 09 F3 09 F9 83 7C 24 64 03 0F 8F 2D 01 00 00 89 E8 C1 E0 04 8B 90 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 39 44 24 14 0F 87 7E 01 00 00 72 0A 39 54 24 10 0F 87 72 01 00 00 33 44 24 14 33 54 24 10 09 D0 0F 84 91 02 00 00 89 D8 89 CA E9 77 F8 FF FF 83 0D ?? ?? ?? ?? 20 31 C0 31 D2 E9 67 F8 FF FF 83 F8 14 0F 84 49 02 00 00 83 F8 15 0F 84 4F 02 00 00 8D 50 EB B8 0A 00 00 00 6B 0C D5 ?? ?? ?? ?? 0A F7 24 D5 ?? ?? ?? ?? 01 CA 39 D7 0F 82 83 F9 FF FF 0F 87 9A F8 FF FF 39 C6 0F 82 75 F9 FF FF E9 8D F8 FF FF 8D B4 26 00 00 00 00 8B 0C AD ?? ?? ?? ?? 89 F0 89 FA 31 DB 83 E9 40 D3 EA 0F AD F8 F6 C1 20 0F 45 C2 0F 45 D3 89 C1 89 D3 8B 04 ED ?? ?? ?? ?? 8B 14 ED ?? ?? ?? ?? 21 F0 21 FA 09 C2 0F 85 B9 01 00 00 8B 54 24 1C 0B 54 24 18 0F 85 AB 01 00 00 89 E8 C1 E0 04 8B 90 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 39 44 24 14 0F 87 90 01 00 00 72 0A 39 54 24 10 0F 87 84 01 00 00 39 44 24 14 0F 84 4B 01 00 00 89 C8 89 DA E9 96 F7 FF FF B8 01 00 00 00 31 D2 E9 4F FE FF FF 8B 44 24 18 8B 54 24 1C 23 44 24 30 23 54 24 20 09 C2 75 58 89 E8 C1 E0 04 8B 90 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 39 44 24 14 77 41 72 06 39 54 24 10 77 39 39 44 24 14 0F 85 CD FE FF FF 39 54 24 10 0F 85 C3 FE FF FF C1 E5 04 8B 7C 24 2C 3B BD ?? ?? ?? ?? 0F 82 B0 FE FF FF 77 10 8B 44 24 28 3B 85 ?? ?? ?? ?? 0F 86 9E FE FF FF 83 0D ?? ?? ?? ?? 20 89 D8 89 CA E9 0E F7 FF FF 8B 44 24 08 8B 4C 24 0C C7 44 24 2C 00 00 00 00 89 44 24 38 A1 ?? ?? ?? ?? F7 E1 89 44 24 20 A1 ?? ?? ?? ?? 89 54 24 24 F7 E1 8B 4C 24 2C 89 54 24 1C 8B 54 24 20 89 44 24 18 A1 ?? ?? ?? ?? 89 54 24 28 F7 64 24 38 89 D0 31 D2 89 54 24 14 8B 54 24 28 89 44 24 10 8B 44 24 08 01 54 24 10 8B 54 24 0C 11 4C 24 14 0F AF 15 ?? ?? ?? ?? 0F AF 05 ?? ?? ?? ?? 8D 0C 02 8B 44 24 08 F7 25 ?? ?? ?? ?? 01 CA 89 44 24 28 89 54 24 2C 8B 54 24 28 8B 4C 24 2C 01 54 24 18 8B 54 24 24 11 4C 24 1C 89 D0 31 D2 01 44 24 18 A1 ?? ?? ?? ?? 11 54 24 1C F7 64 24 38 E9 59 F9 FF FF 39 54 24 10 0F 85 AB FE FF FF C1 E5 04 8B 74 24 2C 3B B5 ?? ?? ?? ?? 0F 82 98 FE FF FF 77 10 8B 7C 24 28 3B BD ?? ?? ?? ?? 0F 86 86 FE FF FF 83 0D ?? ?? ?? ?? 20 89 C8 89 DA E9 15 F6 FF FF 89 F9 09 F1 0F 85 77 F6 FF FF E9 55 F7 FF FF 83 FF 00 0F 87 69 F6 FF FF 83 FE 09 0F 86 43 F7 FF FF E9 5B F6 FF FF C1 E5 04 8B 54 24 2C 3B 95 ?? ?? ?? ?? 0F 82 5C FD FF FF 0F 87 B8 FE FF FF 8B 74 24 28 3B B5 ?? ?? ?? ?? 0F 86 46 FD FF FF E9 A3 FE FF FF 8D B4 26 00 00 00 00 }
	condition:
		$1
}

rule file_92_4_0 {
	meta:
		name = "___bid128_to_uint64_ceil"
		size = 3184
		refs = "0114 ___bid_nr_digits 019c ___bid_ten2k64 01d4 ___bid_IDEC_glbflags 0584 ___bid_ten2mk128 08e5 ___bid_maskhigh128 08fc ___bid_shiftright128 096b ___bid_ten2mk128trunc 09ce ___bid_ten2k128"
	strings:
		$1 = { 81 EC 9C 00 00 00 8B 84 24 A0 00 00 00 8B 8C 24 AC 00 00 00 89 AC 24 98 00 00 00 8B AC 24 A8 00 00 00 89 9C 24 8C 00 00 00 89 44 24 70 8B 84 24 A4 00 00 00 89 B4 24 90 00 00 00 89 BC 24 94 00 00 00 89 44 24 74 8B 44 24 70 8B 54 24 74 89 44 24 08 89 C8 89 54 24 0C 25 00 00 00 78 89 CA 81 E2 00 00 00 80 3D 00 00 00 78 89 54 24 28 0F 84 4C 01 00 00 89 CF 89 EE 81 E7 FF FF 01 00 81 FF 09 ED 01 00 76 2A 31 C0 31 D2 8B 9C 24 8C 00 00 00 8B B4 24 90 00 00 00 8B BC 24 94 00 00 00 8B AC 24 98 00 00 00 81 C4 9C 00 00 00 C3 8D 76 00 0F 83 2F 01 00 00 89 FA 89 F0 81 F2 09 ED 01 00 35 C0 87 AD BE 09 C2 0F 84 79 01 00 00 89 C8 25 00 00 00 60 3D 00 00 00 60 74 AB 89 FB 09 F3 0F 84 11 01 00 00 89 74 24 68 89 7C 24 6C DF 6C 24 68 DD 5C 24 10 8B 54 24 14 89 D0 C1 E8 14 25 FF 07 00 00 2D BE 03 00 00 83 E8 01 89 44 24 10 C1 E0 05 8B 90 ?? ?? ?? ?? 85 D2 75 36 8B 98 ?? ?? ?? ?? 8B 90 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 89 5C 24 18 39 C7 0F 87 76 01 00 00 0F 83 98 01 00 00 89 C3 8B 44 24 18 31 FB 31 F0 09 D8 0F 84 32 01 00 00 81 E1 00 00 FE 7F C1 E9 11 81 E9 20 18 00 00 8D 04 0A 83 F8 14 7F 69 0F 84 84 01 00 00 85 C0 0F 8E 6A 01 00 00 8B 44 24 28 85 C0 8D 76 00 75 50 83 F9 00 0F 8C EA 03 00 00 8B 44 24 08 8B 54 24 0C 0F 84 F1 FE FF FF 8B 1C CD ?? ?? ?? ?? 0F AF DA 8B 14 CD ?? ?? ?? ?? 0F AF D0 01 D3 F7 24 CD ?? ?? ?? ?? 01 DA E9 CD FE FF FF 8D 76 00 89 C8 25 00 00 00 7C 3D 00 00 00 7C 0F 84 9F 00 00 00 83 0D ?? ?? ?? ?? 01 31 C0 BA 00 00 00 80 E9 A5 FE FF FF 81 FD C0 87 AD BE 0F 87 95 FE FF FF E9 C0 FE FF FF 8B 5C 24 0C 31 C0 31 D2 0B 5C 24 08 0F 84 82 FE FF FF 81 7C 24 0C FF FF 1F 00 0F 86 A2 00 00 00 8B 54 24 0C 89 D0 31 D2 89 44 24 68 89 54 24 6C DF 6C 24 68 DD 5C 24 10 8B 54 24 14 89 D0 C1 E8 14 25 FF 07 00 00 2D DE 03 00 00 E9 C2 FE FF FF 31 C0 31 D2 81 7C 24 0C 63 8E 8D 37 0F 87 32 FE FF FF 89 CB 81 E3 00 00 00 60 81 FB 00 00 00 60 0F 85 79 FE FF FF E9 19 FE FF FF 83 0D ?? ?? ?? ?? 01 31 C0 BA 00 00 00 80 E9 06 FE FF FF 8B 44 24 10 8B 5C 24 0C C1 E0 05 05 ?? ?? ?? ?? 39 58 14 0F 87 B5 FE FF FF 72 11 8B 5C 24 08 39 58 10 0F 87 A6 FE FF FF 8D 74 26 00 83 C2 01 E9 9A FE FF FF DF 6C 24 08 DD 5C 24 10 8B 54 24 14 89 D0 C1 E8 14 25 FF 07 00 00 2D FE 03 00 00 E9 30 FE FF FF 39 DE 77 D4 E9 5F FE FF FF 8B 54 24 28 31 C0 85 D2 0F 94 C0 31 D2 E9 97 FD FF FF 8B 44 24 28 85 C0 74 08 83 FA 15 E9 CF FE FF FF 83 FA 01 0F 84 BD 06 00 00 83 FA 13 90 0F 8F 21 01 00 00 8B 44 24 0C 8B 5C 24 08 C7 44 24 3C 00 00 00 00 89 44 24 20 B8 15 00 00 00 29 D0 8B 14 C5 ?? ?? ?? ?? 8B 04 C5 ?? ?? ?? ?? 89 54 24 18 89 44 24 30 89 D0 F7 64 24 20 89 44 24 28 8B 44 24 30 89 54 24 2C F7 64 24 20 89 44 24 20 8B 44 24 18 89 54 24 24 F7 E3 89 54 24 1C 8B 54 24 28 89 44 24 18 89 54 24 38 8B 54 24 1C 89 D0 31 D2 89 44 24 10 8B 44 24 38 01 44 24 10 8B 44 24 30 89 54 24 14 8B 54 24 3C 11 54 24 14 F7 E3 01 44 24 10 11 54 24 14 8B 54 24 2C 89 D0 31 D2 89 44 24 28 8B 44 24 20 89 54 24 2C 8B 54 24 24 01 44 24 28 11 54 24 2C 8B 54 24 14 89 D0 31 D2 01 44 24 28 11 54 24 2C 83 7C 24 2C 00 0F 87 EE FD FF FF 83 7C 24 28 09 0F 87 E3 FD FF FF 8B 44 24 28 83 F0 09 0B 44 24 2C 0F 85 82 FD FF FF 8B 44 24 10 8B 5C 24 18 89 C2 31 C0 89 5C 24 10 C7 44 24 14 00 00 00 00 03 44 24 10 13 54 24 14 83 FA FF 0F 82 59 FD FF FF 83 F8 F6 0F 86 50 FD FF FF E9 9B FD FF FF 83 FA 14 0F 84 00 07 00 00 83 FA 15 0F 84 15 07 00 00 83 EA 15 B8 F6 FF FF FF 8B 1C D5 ?? ?? ?? ?? C7 44 24 3C 00 00 00 00 89 5C 24 20 8B 1C D5 ?? ?? ?? ?? F7 E3 89 44 24 28 B8 FF FF FF FF 89 54 24 2C F7 E3 8D 1C DB 89 44 24 10 B8 F6 FF FF FF 89 54 24 14 F7 64 24 20 89 54 24 34 8B 54 24 28 89 44 24 30 89 54 24 38 8B 54 24 34 89 D0 31 D2 89 44 24 18 8B 44 24 38 01 44 24 18 B8 FF FF FF FF 89 54 24 1C 8B 54 24 3C 11 54 24 1C F7 64 24 20 01 44 24 18 B8 09 00 00 00 11 54 24 1C F7 64 24 20 01 DA 01 44 24 10 11 54 24 14 8B 54 24 2C 89 D0 31 D2 01 44 24 10 11 54 24 14 8B 54 24 1C 89 D0 31 D2 01 44 24 10 11 54 24 14 3B 7C 24 14 0F 87 C4 FC FF FF 72 0A 3B 74 24 10 0F 87 B8 FC FF FF 3B 7C 24 14 66 90 0F 85 5C FC FF FF 3B 74 24 10 0F 85 52 FC FF FF 8B 44 24 18 8B 5C 24 30 C7 44 24 14 00 00 00 00 89 C2 31 C0 89 5C 24 10 03 44 24 10 13 54 24 14 3B 54 24 0C 0F 87 28 FC FF FF 0F 82 72 FC FF FF 3B 44 24 08 0F 83 18 FC FF FF 8D B6 00 00 00 00 E9 5D FC FF FF 89 CB F7 D1 89 4C 24 4C C1 E1 04 F7 DB 8B 91 ?? ?? ?? ?? 8B 81 ?? ?? ?? ?? 89 5C 24 64 8B 5C 24 0C C7 44 24 34 00 00 00 00 89 54 24 28 89 44 24 38 89 D0 F7 E3 89 44 24 18 8B 44 24 38 89 54 24 1C F7 E3 89 44 24 20 8B 44 24 28 89 54 24 24 F7 64 24 08 89 54 24 44 8B 54 24 18 89 44 24 40 89 54 24 30 8B 54 24 44 89 D0 31 D2 89 44 24 10 8B 44 24 30 01 44 24 10 8B 44 24 38 89 54 24 14 8B 54 24 34 11 54 24 14 F7 64 24 08 01 44 24 10 11 54 24 14 8B 54 24 1C 89 D0 31 D2 89 44 24 18 8B 44 24 20 01 44 24 18 89 54 24 1C 8B 54 24 24 11 54 24 1C 8B 54 24 14 89 D0 31 D2 01 44 24 18 11 54 24 1C 8B 91 ?? ?? ?? ?? 8B 89 ?? ?? ?? ?? 89 D0 89 54 24 30 F7 E3 89 4C 24 60 89 44 24 20 89 C8 89 54 24 24 F7 E3 89 44 24 50 8B 44 24 30 89 54 24 54 F7 64 24 08 89 54 24 5C 8B 5C 24 5C 31 D2 89 44 24 58 8B 44 24 20 89 D9 31 DB 01 C1 8B 44 24 60 11 D3 F7 64 24 08 01 C1 11 D3 8B 54 24 24 89 D0 31 D2 89 44 24 20 8B 44 24 50 01 44 24 20 89 54 24 24 8B 54 24 54 11 54 24 24 31 D2 01 5C 24 20 11 54 24 24 31 C0 31 D2 89 4C 24 54 8B 4C 24 10 89 44 24 50 8B 44 24 58 01 44 24 50 11 54 24 54 31 D2 8B 44 24 40 89 CB 31 C9 89 4C 24 10 01 44 24 10 8B 44 24 20 89 5C 24 14 11 54 24 14 8B 54 24 24 01 44 24 10 11 54 24 14 8B 4C 24 14 39 CA 72 14 77 08 8B 5C 24 10 39 D8 76 0A 83 44 24 18 01 83 54 24 1C 00 8B 44 24 28 31 DB F7 E7 89 44 24 08 8B 44 24 38 89 54 24 0C 8B 4C 24 08 F7 E7 89 44 24 40 8B 44 24 28 89 54 24 44 F7 E5 89 44 24 28 89 D0 89 44 24 20 8B 44 24 38 89 54 24 2C 31 D2 89 54 24 24 F7 E5 01 44 24 20 11 54 24 24 01 4C 24 20 11 5C 24 24 8B 5C 24 0C 8B 54 24 24 89 D9 31 DB 89 4C 24 08 8B 4C 24 40 89 D0 01 4C 24 08 89 5C 24 0C 8B 5C 24 44 11 5C 24 0C 31 D2 01 44 24 08 8B 44 24 30 11 54 24 0C 31 DB F7 E7 89 44 24 38 8B 44 24 60 89 54 24 3C 8B 74 24 38 F7 E7 31 FF 89 44 24 40 8B 44 24 30 89 54 24 44 F7 E5 89 44 24 30 8B 44 24 60 89 D1 89 54 24 34 F7 E5 01 C1 11 D3 01 F1 11 FB 8B 7C 24 3C 89 4C 24 3C 8B 4C 24 20 89 FE 31 FF 03 74 24 40 13 7C 24 44 31 D2 01 DE 89 CB 11 D7 31 C0 89 44 24 38 8B 44 24 30 31 D2 01 44 24 38 8B 44 24 28 11 54 24 3C 31 C9 31 D2 01 C1 11 D3 01 F1 11 FB 39 DF 72 10 77 04 39 CE 76 0A 83 44 24 08 01 83 54 24 0C 00 8B 74 24 10 8B 7C 24 14 03 74 24 38 13 7C 24 3C 39 7C 24 3C C7 44 24 20 01 00 00 00 C7 44 24 24 00 00 00 00 77 18 72 06 39 74 24 38 77 10 C7 44 24 20 00 00 00 00 C7 44 24 24 00 00 00 00 8B 44 24 18 03 4C 24 20 8B 54 24 1C 13 5C 24 24 01 C8 89 44 24 18 11 DA 39 D3 89 54 24 1C 0F 87 98 02 00 00 72 08 39 C1 0F 87 8E 02 00 00 31 D2 B8 01 00 00 00 39 5C 24 24 77 0C 72 06 39 4C 24 20 77 04 31 C0 31 D2 8B 4C 24 08 8B 5C 24 0C 01 C1 11 D3 83 7C 24 64 16 89 5C 24 24 8B 5C 24 4C 89 4C 24 20 0F 8F F3 01 00 00 8B 1C DD ?? ?? ?? ?? 8B 54 24 1C 8B 44 24 18 89 5C 24 10 8B 5C 24 4C 8B 0C 9D ?? ?? ?? ?? 8B 2C DD ?? ?? ?? ?? 31 DB 89 4C 24 04 0F B6 4C 24 04 0F AD D0 D3 EA F6 C1 20 0F 45 C2 0F 45 D3 89 44 24 08 BB 40 00 00 00 8B 44 24 20 2B 5C 24 04 89 54 24 0C 8B 54 24 24 89 D9 31 DB 0F A5 C2 D3 E0 F6 C1 20 8B 4C 24 08 0F 45 D0 0F 45 C3 8B 5C 24 0C 09 C1 09 D3 83 7C 24 64 03 0F 8F 7D 02 00 00 8B 44 24 4C C1 E0 04 8B 90 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 39 C7 0F 87 D2 01 00 00 72 08 39 D6 0F 87 C8 01 00 00 31 C7 31 D6 09 F7 89 C8 89 DA 0F 85 F3 F6 FF FF 8B 44 24 4C 8B 54 24 54 C1 E0 04 3B 90 ?? ?? ?? ?? 72 16 0F 87 9F 01 00 00 8B 54 24 50 3B 90 ?? ?? ?? ?? 0F 87 8F 01 00 00 89 C8 89 DA E9 C1 F6 FF FF 8B 54 24 0C A1 ?? ?? ?? ?? 8B 5C 24 08 C7 44 24 34 00 00 00 00 89 54 24 10 F7 E2 89 44 24 28 A1 ?? ?? ?? ?? 89 54 24 2C F7 64 24 10 89 44 24 10 A1 ?? ?? ?? ?? 89 54 24 14 F7 E3 89 54 24 24 8B 54 24 28 89 44 24 20 89 54 24 30 8B 54 24 24 89 D0 31 D2 89 44 24 18 8B 44 24 30 01 44 24 18 A1 ?? ?? ?? ?? 89 54 24 1C 8B 54 24 34 11 54 24 1C F7 E3 01 44 24 18 A1 ?? ?? ?? ?? 11 54 24 1C 8B 54 24 0C 0F AF 15 ?? ?? ?? ?? 0F AF C3 8D 1C 02 8B 44 24 08 F7 25 ?? ?? ?? ?? 89 44 24 30 01 DA 8B 44 24 30 01 44 24 10 89 54 24 34 8B 54 24 34 11 54 24 14 8B 54 24 2C 89 D0 31 D2 01 44 24 10 11 54 24 14 8B 54 24 1C 89 D0 31 D2 01 44 24 10 11 54 24 14 83 7C 24 14 00 0F 87 2A F7 FF FF 83 7C 24 10 09 0F 87 1F F7 FF FF 8B 44 24 10 83 F0 09 0B 44 24 14 0F 85 BE F6 FF FF 8B 44 24 18 8B 5C 24 20 89 C2 31 C0 E9 37 F9 FF FF 8B 1C 9D ?? ?? ?? ?? 8B 54 24 24 8B 44 24 20 89 DD 31 DB 83 ED 40 89 E9 0F AD D0 D3 EA F6 C1 20 0F 45 C2 0F 45 D3 8B 5C 24 4C 89 44 24 08 8B 44 24 20 89 54 24 0C 8B 54 24 24 23 04 DD ?? ?? ?? ?? 23 14 DD ?? ?? ?? ?? 09 C2 74 77 8B 44 24 08 8B 54 24 0C 83 C0 01 83 D2 00 E9 56 F5 FF FF B8 01 00 00 00 31 D2 E9 7F FD FF FF 89 F8 09 F0 0F 85 88 F6 FF FF E9 33 F6 FF FF 89 C8 89 DA 83 C0 01 83 D2 00 E9 2C F5 FF FF 83 FF 00 0F 87 6B F6 FF FF 83 FE 09 0F 87 62 F6 FF FF 89 F0 83 F0 09 09 F8 0F 85 05 F6 FF FF 83 7C 24 0C FF 0F 82 FA F5 FF FF 83 7C 24 08 F6 0F 86 EF F5 FF FF E9 3A F6 FF FF 8B 4C 24 1C 0B 4C 24 18 0F 85 7B FF FF FF 8B 44 24 4C C1 E0 04 8B 90 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 39 C7 0F 87 60 FF FF FF 72 08 39 D6 0F 87 56 FF FF FF 39 C7 8D 76 00 74 63 8B 44 24 08 8B 54 24 0C E9 AB F4 FF FF 8B 54 24 1C 8B 44 24 18 23 44 24 10 21 EA 09 C2 0F 85 5A FF FF FF 8B 44 24 4C C1 E0 04 8B 90 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 39 C7 0F 87 3F FF FF FF 72 08 39 D6 0F 87 35 FF FF FF 39 C7 8D 74 26 00 0F 85 9A FD FF FF 39 D6 0F 85 92 FD FF FF 66 90 E9 62 FD FF FF 39 D6 75 99 8B 44 24 4C 8B 5C 24 54 C1 E0 04 3B 98 ?? ?? ?? ?? 72 86 0F 87 CF FE FF FF 8B 54 24 50 3B 90 ?? ?? ?? ?? 0F 86 70 FF FF FF E9 BA FE FF FF 89 F6 8D BC 27 00 00 00 00 }
	condition:
		$1
}

rule file_92_5_0 {
	meta:
		name = "___bid128_to_uint64_xceil"
		size = 3216
		refs = "0114 ___bid_nr_digits 019c ___bid_ten2k64 01d4 ___bid_IDEC_glbflags 058f ___bid_ten2mk128 08f0 ___bid_maskhigh128 0907 ___bid_shiftright128 0976 ___bid_ten2mk128trunc 09d9 ___bid_ten2k128"
	strings:
		$1 = { 81 EC 9C 00 00 00 8B 84 24 A0 00 00 00 8B 8C 24 AC 00 00 00 89 AC 24 98 00 00 00 8B AC 24 A8 00 00 00 89 9C 24 8C 00 00 00 89 44 24 70 8B 84 24 A4 00 00 00 89 B4 24 90 00 00 00 89 BC 24 94 00 00 00 89 44 24 74 8B 44 24 70 8B 54 24 74 89 44 24 08 89 C8 89 54 24 0C 25 00 00 00 78 89 CA 81 E2 00 00 00 80 3D 00 00 00 78 89 54 24 28 0F 84 4C 01 00 00 89 CF 89 EE 81 E7 FF FF 01 00 81 FF 09 ED 01 00 76 2A 31 C0 31 D2 8B 9C 24 8C 00 00 00 8B B4 24 90 00 00 00 8B BC 24 94 00 00 00 8B AC 24 98 00 00 00 81 C4 9C 00 00 00 C3 8D 76 00 0F 83 2F 01 00 00 89 FA 89 F0 81 F2 09 ED 01 00 35 C0 87 AD BE 09 C2 0F 84 79 01 00 00 89 C8 25 00 00 00 60 3D 00 00 00 60 74 AB 89 FB 09 F3 0F 84 11 01 00 00 89 74 24 68 89 7C 24 6C DF 6C 24 68 DD 5C 24 10 8B 54 24 14 89 D0 C1 E8 14 25 FF 07 00 00 2D BE 03 00 00 83 E8 01 89 44 24 10 C1 E0 05 8B 90 ?? ?? ?? ?? 85 D2 75 36 8B 98 ?? ?? ?? ?? 8B 90 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 89 5C 24 18 39 C7 0F 87 76 01 00 00 0F 83 98 01 00 00 89 C3 8B 44 24 18 31 FB 31 F0 09 D8 0F 84 32 01 00 00 81 E1 00 00 FE 7F C1 E9 11 81 E9 20 18 00 00 8D 04 0A 83 F8 14 7F 69 0F 84 91 01 00 00 85 C0 0F 8E 6A 01 00 00 8B 44 24 28 85 C0 8D 76 00 75 50 83 F9 00 0F 8C F5 03 00 00 8B 44 24 08 8B 54 24 0C 0F 84 F1 FE FF FF 8B 1C CD ?? ?? ?? ?? 0F AF DA 8B 14 CD ?? ?? ?? ?? 0F AF D0 01 D3 F7 24 CD ?? ?? ?? ?? 01 DA E9 CD FE FF FF 8D 76 00 89 C8 25 00 00 00 7C 3D 00 00 00 7C 0F 84 9F 00 00 00 83 0D ?? ?? ?? ?? 01 31 C0 BA 00 00 00 80 E9 A5 FE FF FF 81 FD C0 87 AD BE 0F 87 95 FE FF FF E9 C0 FE FF FF 8B 5C 24 0C 31 C0 31 D2 0B 5C 24 08 0F 84 82 FE FF FF 81 7C 24 0C FF FF 1F 00 0F 86 A2 00 00 00 8B 54 24 0C 89 D0 31 D2 89 44 24 68 89 54 24 6C DF 6C 24 68 DD 5C 24 10 8B 54 24 14 89 D0 C1 E8 14 25 FF 07 00 00 2D DE 03 00 00 E9 C2 FE FF FF 31 C0 31 D2 81 7C 24 0C 63 8E 8D 37 0F 87 32 FE FF FF 89 CB 81 E3 00 00 00 60 81 FB 00 00 00 60 0F 85 79 FE FF FF E9 19 FE FF FF 83 0D ?? ?? ?? ?? 01 31 C0 BA 00 00 00 80 E9 06 FE FF FF 8B 44 24 10 8B 5C 24 0C C1 E0 05 05 ?? ?? ?? ?? 39 58 14 0F 87 B5 FE FF FF 72 11 8B 5C 24 08 39 58 10 0F 87 A6 FE FF FF 8D 74 26 00 83 C2 01 E9 9A FE FF FF DF 6C 24 08 DD 5C 24 10 8B 54 24 14 89 D0 C1 E8 14 25 FF 07 00 00 2D FE 03 00 00 E9 30 FE FF FF 39 DE 77 D4 E9 5F FE FF FF 8B 54 24 28 31 C0 83 0D ?? ?? ?? ?? 20 85 D2 0F 94 C0 31 D2 E9 90 FD FF FF 8D B6 00 00 00 00 8B 44 24 28 85 C0 74 08 83 FA 15 E9 C2 FE FF FF 83 FA 01 0F 84 BB 06 00 00 83 FA 13 0F 8F 21 01 00 00 8B 44 24 0C 8B 5C 24 08 C7 44 24 3C 00 00 00 00 89 44 24 20 B8 15 00 00 00 29 D0 8B 14 C5 ?? ?? ?? ?? 8B 04 C5 ?? ?? ?? ?? 89 54 24 18 89 44 24 30 89 D0 F7 64 24 20 89 44 24 28 8B 44 24 30 89 54 24 2C F7 64 24 20 89 44 24 20 8B 44 24 18 89 54 24 24 F7 E3 89 54 24 1C 8B 54 24 28 89 44 24 18 89 54 24 38 8B 54 24 1C 89 D0 31 D2 89 44 24 10 8B 44 24 38 01 44 24 10 8B 44 24 30 89 54 24 14 8B 54 24 3C 11 54 24 14 F7 E3 01 44 24 10 11 54 24 14 8B 54 24 2C 89 D0 31 D2 89 44 24 28 8B 44 24 20 89 54 24 2C 8B 54 24 24 01 44 24 28 11 54 24 2C 8B 54 24 14 89 D0 31 D2 01 44 24 28 11 54 24 2C 83 7C 24 2C 00 0F 87 E2 FD FF FF 83 7C 24 28 09 0F 87 D7 FD FF FF 8B 44 24 28 83 F0 09 0B 44 24 2C 0F 85 76 FD FF FF 8B 44 24 10 8B 5C 24 18 89 C2 31 C0 89 5C 24 10 C7 44 24 14 00 00 00 00 03 44 24 10 13 54 24 14 83 FA FF 0F 82 4D FD FF FF 83 F8 F6 0F 86 44 FD FF FF E9 8F FD FF FF 83 FA 14 0F 84 0A 07 00 00 83 FA 15 90 0F 84 25 07 00 00 83 EA 15 B8 F6 FF FF FF 8B 1C D5 ?? ?? ?? ?? C7 44 24 3C 00 00 00 00 89 5C 24 20 8B 1C D5 ?? ?? ?? ?? F7 E3 89 44 24 28 B8 FF FF FF FF 89 54 24 2C F7 E3 8D 1C DB 89 44 24 10 B8 F6 FF FF FF 89 54 24 14 F7 64 24 20 89 54 24 34 8B 54 24 28 89 44 24 30 89 54 24 38 8B 54 24 34 89 D0 31 D2 89 44 24 18 8B 44 24 38 01 44 24 18 B8 FF FF FF FF 89 54 24 1C 8B 54 24 3C 11 54 24 1C F7 64 24 20 01 44 24 18 B8 09 00 00 00 11 54 24 1C F7 64 24 20 01 DA 01 44 24 10 11 54 24 14 8B 54 24 2C 89 D0 31 D2 01 44 24 10 11 54 24 14 8B 54 24 1C 89 D0 31 D2 01 44 24 10 11 54 24 14 3B 7C 24 14 0F 87 B7 FC FF FF 72 0A 3B 74 24 10 0F 87 AB FC FF FF 3B 7C 24 14 0F 85 51 FC FF FF 3B 74 24 10 0F 85 47 FC FF FF 8B 44 24 18 8B 5C 24 30 C7 44 24 14 00 00 00 00 89 C2 31 C0 89 5C 24 10 03 44 24 10 13 54 24 14 3B 54 24 0C 0F 87 1D FC FF FF 0F 82 67 FC FF FF 3B 44 24 08 0F 83 0D FC FF FF E9 58 FC FF FF 8D B6 00 00 00 00 89 CB F7 D1 89 4C 24 4C C1 E1 04 F7 DB 8B 91 ?? ?? ?? ?? 8B 81 ?? ?? ?? ?? 89 5C 24 64 8B 5C 24 0C C7 44 24 34 00 00 00 00 89 54 24 28 89 44 24 38 89 D0 F7 E3 89 44 24 18 8B 44 24 38 89 54 24 1C F7 E3 89 44 24 20 8B 44 24 28 89 54 24 24 F7 64 24 08 89 54 24 44 8B 54 24 18 89 44 24 40 89 54 24 30 8B 54 24 44 89 D0 31 D2 89 44 24 10 8B 44 24 30 01 44 24 10 8B 44 24 38 89 54 24 14 8B 54 24 34 11 54 24 14 F7 64 24 08 01 44 24 10 11 54 24 14 8B 54 24 1C 89 D0 31 D2 89 44 24 18 8B 44 24 20 01 44 24 18 89 54 24 1C 8B 54 24 24 11 54 24 1C 8B 54 24 14 89 D0 31 D2 01 44 24 18 11 54 24 1C 8B 91 ?? ?? ?? ?? 8B 89 ?? ?? ?? ?? 89 D0 89 54 24 30 F7 E3 89 4C 24 60 89 44 24 20 89 C8 89 54 24 24 F7 E3 89 44 24 50 8B 44 24 30 89 54 24 54 F7 64 24 08 89 54 24 5C 8B 5C 24 5C 31 D2 89 44 24 58 8B 44 24 20 89 D9 31 DB 01 C1 8B 44 24 60 11 D3 F7 64 24 08 01 C1 11 D3 8B 54 24 24 89 D0 31 D2 89 44 24 20 8B 44 24 50 01 44 24 20 89 54 24 24 8B 54 24 54 11 54 24 24 31 D2 01 5C 24 20 11 54 24 24 31 C0 31 D2 89 4C 24 54 8B 4C 24 10 89 44 24 50 8B 44 24 58 01 44 24 50 11 54 24 54 31 D2 8B 44 24 40 89 CB 31 C9 89 4C 24 10 01 44 24 10 8B 44 24 20 89 5C 24 14 11 54 24 14 8B 54 24 24 01 44 24 10 11 54 24 14 8B 4C 24 14 39 CA 72 14 77 08 8B 5C 24 10 39 D8 76 0A 83 44 24 18 01 83 54 24 1C 00 8B 44 24 28 31 DB F7 E7 89 44 24 08 8B 44 24 38 89 54 24 0C 8B 4C 24 08 F7 E7 89 44 24 40 8B 44 24 28 89 54 24 44 F7 E5 89 44 24 28 89 D0 89 44 24 20 8B 44 24 38 89 54 24 2C 31 D2 89 54 24 24 F7 E5 01 44 24 20 11 54 24 24 01 4C 24 20 11 5C 24 24 8B 5C 24 0C 8B 54 24 24 89 D9 31 DB 89 4C 24 08 8B 4C 24 40 89 D0 01 4C 24 08 89 5C 24 0C 8B 5C 24 44 11 5C 24 0C 31 D2 01 44 24 08 8B 44 24 30 11 54 24 0C 31 DB F7 E7 89 44 24 38 8B 44 24 60 89 54 24 3C 8B 74 24 38 F7 E7 31 FF 89 44 24 40 8B 44 24 30 89 54 24 44 F7 E5 89 44 24 30 8B 44 24 60 89 D1 89 54 24 34 F7 E5 01 C1 11 D3 01 F1 11 FB 8B 7C 24 3C 89 4C 24 3C 8B 4C 24 20 89 FE 31 FF 03 74 24 40 13 7C 24 44 31 D2 01 DE 89 CB 11 D7 31 C0 89 44 24 38 8B 44 24 30 31 D2 01 44 24 38 8B 44 24 28 11 54 24 3C 31 C9 31 D2 01 C1 11 D3 01 F1 11 FB 39 DF 72 10 77 04 39 CE 76 0A 83 44 24 08 01 83 54 24 0C 00 8B 74 24 10 8B 7C 24 14 03 74 24 38 13 7C 24 3C 39 7C 24 3C C7 44 24 20 01 00 00 00 C7 44 24 24 00 00 00 00 77 18 72 06 39 74 24 38 77 10 C7 44 24 20 00 00 00 00 C7 44 24 24 00 00 00 00 8B 44 24 18 03 4C 24 20 8B 54 24 1C 13 5C 24 24 01 C8 89 44 24 18 11 DA 39 D3 89 54 24 1C 0F 87 A3 02 00 00 72 08 39 C1 0F 87 99 02 00 00 31 D2 B8 01 00 00 00 39 5C 24 24 77 0C 72 06 39 4C 24 20 77 04 31 C0 31 D2 8B 4C 24 08 8B 5C 24 0C 01 C1 11 D3 83 7C 24 64 16 89 5C 24 24 8B 5C 24 4C 89 4C 24 20 0F 8F F3 01 00 00 8B 1C DD ?? ?? ?? ?? 8B 54 24 1C 8B 44 24 18 89 5C 24 10 8B 5C 24 4C 8B 0C 9D ?? ?? ?? ?? 8B 2C DD ?? ?? ?? ?? 31 DB 89 4C 24 04 0F B6 4C 24 04 0F AD D0 D3 EA F6 C1 20 0F 45 C2 0F 45 D3 89 44 24 08 BB 40 00 00 00 8B 44 24 20 2B 5C 24 04 89 54 24 0C 8B 54 24 24 89 D9 31 DB 0F A5 C2 D3 E0 F6 C1 20 8B 4C 24 08 0F 45 D0 0F 45 C3 8B 5C 24 0C 09 C1 09 D3 83 7C 24 64 03 0F 8F 92 02 00 00 8B 44 24 4C C1 E0 04 8B 90 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 39 C7 0F 87 DD 01 00 00 72 08 39 D6 0F 87 D3 01 00 00 31 C7 31 D6 09 F7 89 C8 89 DA 0F 85 E8 F6 FF FF 8B 44 24 4C 8B 54 24 54 C1 E0 04 3B 90 ?? ?? ?? ?? 72 16 0F 87 AA 01 00 00 8B 54 24 50 3B 90 ?? ?? ?? ?? 0F 87 9A 01 00 00 89 C8 89 DA E9 B6 F6 FF FF 8B 54 24 0C A1 ?? ?? ?? ?? 8B 5C 24 08 C7 44 24 34 00 00 00 00 89 54 24 10 F7 E2 89 44 24 28 A1 ?? ?? ?? ?? 89 54 24 2C F7 64 24 10 89 44 24 10 A1 ?? ?? ?? ?? 89 54 24 14 F7 E3 89 54 24 24 8B 54 24 28 89 44 24 20 89 54 24 30 8B 54 24 24 89 D0 31 D2 89 44 24 18 8B 44 24 30 01 44 24 18 A1 ?? ?? ?? ?? 89 54 24 1C 8B 54 24 34 11 54 24 1C F7 E3 01 44 24 18 A1 ?? ?? ?? ?? 11 54 24 1C 8B 54 24 0C 0F AF 15 ?? ?? ?? ?? 0F AF C3 8D 1C 02 8B 44 24 08 F7 25 ?? ?? ?? ?? 89 44 24 30 01 DA 8B 44 24 30 01 44 24 10 89 54 24 34 8B 54 24 34 11 54 24 14 8B 54 24 2C 89 D0 31 D2 01 44 24 10 11 54 24 14 8B 54 24 1C 89 D0 31 D2 01 44 24 10 11 54 24 14 83 7C 24 14 00 0F 87 1F F7 FF FF 83 7C 24 10 09 0F 87 14 F7 FF FF 8B 44 24 10 83 F0 09 0B 44 24 14 0F 85 B3 F6 FF FF 8B 44 24 18 8B 5C 24 20 89 C2 31 C0 E9 38 F9 FF FF 8B 1C 9D ?? ?? ?? ?? 8B 54 24 24 8B 44 24 20 89 DD 8B 5C 24 4C 83 ED 40 89 E9 31 ED 0F AD D0 D3 EA F6 C1 20 0F 45 C2 0F 45 D5 89 44 24 08 8B 44 24 20 89 54 24 0C 8B 54 24 24 23 04 DD ?? ?? ?? ?? 23 14 DD ?? ?? ?? ?? 09 C2 0F 84 85 00 00 00 8B 44 24 08 8B 54 24 0C 83 0D ?? ?? ?? ?? 20 83 C0 01 83 D2 00 E9 40 F5 FF FF B8 01 00 00 00 31 D2 E9 74 FD FF FF 89 F8 09 F0 0F 85 72 F6 FF FF E9 1D F6 FF FF 89 C8 89 DA 83 0D ?? ?? ?? ?? 20 83 C0 01 83 D2 00 E9 0F F5 FF FF 83 FF 00 0F 87 4E F6 FF FF 83 FE 09 0F 87 45 F6 FF FF 89 F0 83 F0 09 09 F8 0F 85 E8 F5 FF FF 83 7C 24 0C FF 0F 82 DD F5 FF FF 83 7C 24 08 F6 0F 86 D2 F5 FF FF E9 1D F6 FF FF 8B 4C 24 1C 0B 4C 24 18 0F 85 6D FF FF FF 8B 44 24 4C C1 E0 04 8B 90 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 39 C7 0F 87 52 FF FF FF 72 08 39 D6 0F 87 48 FF FF FF 39 C7 8D B6 00 00 00 00 74 63 8B 44 24 08 8B 54 24 0C E9 8B F4 FF FF 8B 54 24 1C 8B 44 24 18 23 44 24 10 21 EA 09 C2 0F 85 50 FF FF FF 8B 44 24 4C C1 E0 04 8B 90 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 39 C7 0F 87 35 FF FF FF 72 08 39 D6 0F 87 2B FF FF FF 39 C7 8D 74 26 00 0F 85 85 FD FF FF 39 D6 0F 85 7D FD FF FF 66 90 E9 4D FD FF FF 39 D6 75 99 8B 44 24 4C 8B 5C 24 54 C1 E0 04 3B 98 ?? ?? ?? ?? 72 86 0F 87 BE FE FF FF 8B 54 24 50 3B 90 ?? ?? ?? ?? 0F 86 70 FF FF FF E9 A9 FE FF FF 89 F6 8D BC 27 00 00 00 00 }
	condition:
		$1
}

rule file_92_6_0 {
	meta:
		name = "___bid128_to_uint64_int"
		size = 2224
		refs = "0114 ___bid_nr_digits 019c ___bid_ten2k64 01d4 ___bid_IDEC_glbflags 03e4 ___bid_ten2mk128 06f9 ___bid_shiftright128 079e ___bid_ten2k128"
	strings:
		$1 = { 81 EC 9C 00 00 00 8B 84 24 A0 00 00 00 8B 8C 24 AC 00 00 00 89 B4 24 90 00 00 00 89 9C 24 8C 00 00 00 89 44 24 70 8B 84 24 A4 00 00 00 8B 5C 24 70 89 AC 24 98 00 00 00 8B AC 24 A8 00 00 00 89 BC 24 94 00 00 00 89 44 24 74 8B 74 24 74 89 C8 25 00 00 00 78 89 5C 24 08 89 74 24 0C 89 CE 81 E6 00 00 00 80 3D 00 00 00 78 89 74 24 28 0F 84 4C 01 00 00 89 CF 89 EE 81 E7 FF FF 01 00 81 FF 09 ED 01 00 76 2A 31 C0 31 D2 8B 9C 24 8C 00 00 00 8B B4 24 90 00 00 00 8B BC 24 94 00 00 00 8B AC 24 98 00 00 00 81 C4 9C 00 00 00 C3 8D 76 00 0F 83 2F 01 00 00 89 FA 89 F0 81 F2 09 ED 01 00 35 C0 87 AD BE 09 C2 0F 84 79 01 00 00 89 C8 25 00 00 00 60 3D 00 00 00 60 74 AB 89 F8 09 F0 0F 84 11 01 00 00 89 74 24 68 89 7C 24 6C DF 6C 24 68 DD 5C 24 10 8B 54 24 14 89 D0 C1 E8 14 25 FF 07 00 00 2D BE 03 00 00 83 E8 01 89 44 24 10 C1 E0 05 8B 90 ?? ?? ?? ?? 85 D2 75 36 8B 98 ?? ?? ?? ?? 8B 90 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 89 5C 24 18 39 C7 0F 87 76 01 00 00 0F 83 98 01 00 00 89 C3 8B 44 24 18 31 FB 31 F0 09 D8 0F 84 32 01 00 00 81 E1 00 00 FE 7F C1 E9 11 81 E9 20 18 00 00 8D 04 0A 83 F8 14 7F 69 0F 84 72 01 00 00 85 C0 0F 8E 0F FF FF FF 8B 44 24 28 85 C0 8D 76 00 75 50 83 F9 00 0F 8C 4A 02 00 00 8B 44 24 08 8B 54 24 0C 0F 84 F1 FE FF FF 8B 1C CD ?? ?? ?? ?? 0F AF DA 8B 14 CD ?? ?? ?? ?? 0F AF D0 01 D3 F7 24 CD ?? ?? ?? ?? 01 DA E9 CD FE FF FF 8D 76 00 89 C8 25 00 00 00 7C 3D 00 00 00 7C 0F 84 9F 00 00 00 83 0D ?? ?? ?? ?? 01 31 C0 BA 00 00 00 80 E9 A5 FE FF FF 81 FD C0 87 AD BE 0F 87 95 FE FF FF E9 C0 FE FF FF 8B 5C 24 0C 31 C0 31 D2 0B 5C 24 08 0F 84 82 FE FF FF 81 7C 24 0C FF FF 1F 00 0F 86 A2 00 00 00 8B 54 24 0C 89 D0 31 D2 89 44 24 68 89 54 24 6C DF 6C 24 68 DD 5C 24 10 8B 54 24 14 89 D0 C1 E8 14 25 FF 07 00 00 2D DE 03 00 00 E9 C2 FE FF FF 31 C0 31 D2 81 7C 24 0C 63 8E 8D 37 0F 87 32 FE FF FF 89 CB 81 E3 00 00 00 60 81 FB 00 00 00 60 0F 85 79 FE FF FF E9 19 FE FF FF 83 0D ?? ?? ?? ?? 01 31 C0 BA 00 00 00 80 E9 06 FE FF FF 8B 44 24 10 8B 5C 24 0C C1 E0 05 05 ?? ?? ?? ?? 39 58 14 0F 87 B5 FE FF FF 72 11 8B 5C 24 08 39 58 10 0F 87 A6 FE FF FF 8D 74 26 00 83 C2 01 E9 9A FE FF FF DF 6C 24 08 DD 5C 24 10 8B 54 24 14 89 D0 C1 E8 14 25 FF 07 00 00 2D FE 03 00 00 E9 30 FE FF FF 39 DE 77 D4 E9 5F FE FF FF 8B 44 24 28 85 C0 74 08 83 FA 15 E9 E1 FE FF FF 83 FA 01 0F 84 9B 04 00 00 83 FA 13 0F 8F 49 04 00 00 B8 15 00 00 00 8B 5C 24 0C 29 D0 8B 14 C5 ?? ?? ?? ?? 8B 04 C5 ?? ?? ?? ?? 89 5C 24 20 8B 5C 24 08 C7 44 24 34 00 00 00 00 89 54 24 10 89 44 24 38 89 D0 F7 64 24 20 89 44 24 18 8B 44 24 38 89 54 24 1C F7 64 24 20 89 44 24 20 8B 44 24 10 89 54 24 24 8B 54 24 18 89 54 24 30 F7 E3 89 D0 31 D2 89 44 24 10 8B 44 24 30 01 44 24 10 89 54 24 14 8B 54 24 34 11 54 24 14 8B 54 24 1C 89 D0 31 D2 89 44 24 18 8B 44 24 20 01 44 24 18 89 54 24 1C 8B 54 24 24 11 54 24 1C 8B 44 24 38 F7 E3 01 44 24 10 11 54 24 14 8B 54 24 14 89 D0 31 D2 01 44 24 18 11 54 24 1C 83 7C 24 1C 00 0F 87 0D FE FF FF 83 7C 24 18 09 0F 86 B2 FD FF FF E9 FD FD FF FF 89 CB F7 D1 89 4C 24 58 C1 E1 04 F7 DB 8B 91 ?? ?? ?? ?? 8B 81 ?? ?? ?? ?? 89 5C 24 5C 8B 5C 24 0C C7 44 24 3C 00 00 00 00 89 54 24 30 89 44 24 28 89 D0 F7 E3 89 44 24 18 8B 44 24 28 89 54 24 1C F7 E3 89 44 24 20 8B 44 24 30 89 54 24 24 F7 64 24 08 89 54 24 44 8B 54 24 18 89 44 24 40 89 54 24 38 8B 54 24 44 89 D0 31 D2 89 44 24 10 8B 44 24 38 01 44 24 10 8B 44 24 28 89 54 24 14 8B 54 24 3C 11 54 24 14 F7 64 24 08 01 44 24 10 11 54 24 14 8B 54 24 1C 89 D0 31 D2 89 44 24 18 8B 44 24 20 01 44 24 18 89 54 24 1C 8B 54 24 24 11 54 24 1C 8B 54 24 14 89 D0 31 D2 01 44 24 18 11 54 24 1C 8B 91 ?? ?? ?? ?? 8B 89 ?? ?? ?? ?? 89 D0 89 54 24 38 F7 E3 89 4C 24 4C 89 44 24 50 89 C8 8B 4C 24 50 89 54 24 54 F7 E3 31 DB 89 44 24 60 8B 44 24 38 89 54 24 64 F7 64 24 08 89 D0 31 D2 89 44 24 20 01 4C 24 20 89 54 24 24 11 5C 24 24 8B 5C 24 54 8B 44 24 4C 89 D9 31 DB 03 4C 24 60 13 5C 24 64 F7 64 24 08 01 44 24 20 11 54 24 24 8B 54 24 24 89 D0 31 D2 01 C1 8B 44 24 10 11 D3 89 C2 31 C0 89 44 24 10 8B 44 24 40 89 54 24 14 31 D2 01 44 24 10 11 54 24 14 01 4C 24 10 11 5C 24 14 3B 5C 24 14 72 12 77 06 3B 4C 24 10 76 0A 83 44 24 18 01 83 54 24 1C 00 8B 44 24 30 31 DB F7 E7 89 44 24 08 8B 44 24 28 89 54 24 0C 8B 4C 24 08 F7 E7 89 44 24 40 8B 44 24 30 89 54 24 44 8B 74 24 44 F7 E5 89 44 24 30 89 D0 89 44 24 20 8B 44 24 28 89 54 24 34 31 D2 89 54 24 24 F7 E5 01 44 24 20 11 54 24 24 01 4C 24 20 11 5C 24 24 8B 5C 24 0C 8B 54 24 24 89 D9 31 DB 89 5C 24 0C 8B 5C 24 40 89 D0 89 4C 24 08 01 5C 24 08 11 74 24 0C 31 D2 01 44 24 08 8B 44 24 38 11 54 24 0C 31 DB F7 E7 89 44 24 28 8B 44 24 4C 89 54 24 2C 8B 74 24 28 F7 E7 31 FF 89 44 24 40 8B 44 24 38 89 54 24 44 F7 E5 89 44 24 38 8B 44 24 4C 89 D1 89 54 24 3C F7 E5 01 C1 11 D3 01 F1 11 FB 8B 7C 24 2C 89 4C 24 2C 8B 4C 24 20 89 FE 31 FF 03 74 24 40 13 7C 24 44 31 D2 01 DE 89 CB 11 D7 31 C0 89 44 24 28 8B 44 24 38 31 D2 01 44 24 28 8B 44 24 30 11 54 24 2C 31 C9 31 D2 01 C1 11 D3 01 F1 11 FB 39 DF 72 10 77 04 39 CE 76 0A 83 44 24 08 01 83 54 24 0C 00 8B 44 24 10 BE 01 00 00 00 8B 54 24 14 03 44 24 28 13 54 24 2C 31 FF 39 54 24 2C 77 0C 72 06 39 44 24 28 77 04 31 F6 31 FF 8B 44 24 18 01 F1 8B 54 24 1C 11 FB 01 C8 11 DA 39 D3 89 44 24 18 89 54 24 1C 0F 87 98 01 00 00 72 08 39 C1 0F 87 8E 01 00 00 31 D2 39 DF B8 01 00 00 00 77 0A 72 04 39 CE 77 04 31 C0 31 D2 03 44 24 08 13 54 24 0C 83 7C 24 5C 16 0F 8F 72 01 00 00 8B 5C 24 58 31 FF BD 40 00 00 00 8B 74 24 1C 8B 0C 9D ?? ?? ?? ?? 8B 5C 24 18 0F AD F3 D3 EE F6 C1 20 0F 45 DE 0F 45 F7 29 CD 89 E9 31 ED 89 5C 24 10 89 C3 89 74 24 14 89 D6 0F A5 C6 D3 E3 F6 C1 20 0F 45 F3 0F 45 DD 89 5C 24 08 8B 44 24 08 89 74 24 0C 8B 54 24 0C 0B 44 24 10 0B 54 24 14 E9 3E F9 FF FF 83 FA 14 0F 84 27 01 00 00 83 FA 15 0F 84 2D 01 00 00 83 EA 15 B8 0A 00 00 00 6B 1C D5 ?? ?? ?? ?? 0A F7 24 D5 ?? ?? ?? ?? 01 DA 39 D7 0F 82 03 FA FF FF 0F 87 4D FA FF FF 39 C6 0F 82 F5 F9 FF FF 8D 76 00 E9 3D FA FF FF 8B 5C 24 0C 8B 54 24 08 A1 ?? ?? ?? ?? C7 44 24 24 00 00 00 00 89 54 24 38 F7 E3 89 44 24 30 A1 ?? ?? ?? ?? 89 54 24 34 F7 E3 89 54 24 1C 8B 54 24 30 89 44 24 18 A1 ?? ?? ?? ?? 89 54 24 20 F7 64 24 38 89 D0 31 D2 89 44 24 10 8B 44 24 20 01 44 24 10 8B 44 24 08 89 54 24 14 8B 54 24 24 11 54 24 14 8B 15 ?? ?? ?? ?? 0F AF 05 ?? ?? ?? ?? 0F AF D3 8D 1C 02 8B 44 24 08 F7 25 ?? ?? ?? ?? 01 DA 89 44 24 20 8B 44 24 20 01 44 24 18 89 54 24 24 8B 54 24 24 11 54 24 1C 8B 54 24 34 89 D0 31 D2 01 44 24 18 A1 ?? ?? ?? ?? 11 54 24 1C F7 64 24 38 E9 55 FB FF FF B8 01 00 00 00 31 D2 E9 7B FE FF FF 8B 74 24 58 8B 0C B5 ?? ?? ?? ?? 31 F6 83 E9 40 0F AD D0 D3 EA 83 E1 20 0F 45 C2 0F 45 D6 E9 0E F8 FF FF 89 FA 09 F2 0F 85 4C F9 FF FF E9 F7 F8 FF FF 83 FF 00 66 90 0F 87 3C F9 FF FF 83 FE 09 0F 86 E3 F8 FF FF 90 E9 2D F9 FF FF 8D 74 26 00 8D BC 27 00 00 00 00 }
	condition:
		$1
}

rule file_92_7_0 {
	meta:
		name = "___bid128_to_uint64_xint"
		size = 2720
		refs = "0114 ___bid_nr_digits 019c ___bid_ten2k64 01d4 ___bid_IDEC_glbflags 03f4 ___bid_ten2mk128 0755 ___bid_maskhigh128 0779 ___bid_shiftright128 07da ___bid_ten2mk128trunc 085e ___bid_ten2k128"
	strings:
		$1 = { 81 EC 9C 00 00 00 8B 84 24 A0 00 00 00 8B 8C 24 AC 00 00 00 89 B4 24 90 00 00 00 8B B4 24 A8 00 00 00 89 9C 24 8C 00 00 00 89 44 24 70 8B 84 24 A4 00 00 00 89 BC 24 94 00 00 00 89 AC 24 98 00 00 00 89 44 24 74 8B 44 24 70 8B 54 24 74 89 44 24 08 89 C8 89 54 24 0C 25 00 00 00 78 89 CA 81 E2 00 00 00 80 3D 00 00 00 78 89 54 24 28 0F 84 4C 01 00 00 89 CD 89 F7 81 E5 FF FF 01 00 81 FD 09 ED 01 00 76 2A 31 C0 31 D2 8B 9C 24 8C 00 00 00 8B B4 24 90 00 00 00 8B BC 24 94 00 00 00 8B AC 24 98 00 00 00 81 C4 9C 00 00 00 C3 8D 76 00 0F 83 2F 01 00 00 89 EA 89 F8 81 F2 09 ED 01 00 35 C0 87 AD BE 09 C2 0F 84 79 01 00 00 89 C8 25 00 00 00 60 3D 00 00 00 60 74 AB 89 EB 09 FB 0F 84 11 01 00 00 89 7C 24 68 89 6C 24 6C DF 6C 24 68 DD 5C 24 10 8B 54 24 14 89 D0 C1 E8 14 25 FF 07 00 00 2D BE 03 00 00 83 E8 01 89 44 24 10 C1 E0 05 8B 90 ?? ?? ?? ?? 85 D2 75 36 8B 98 ?? ?? ?? ?? 8B 90 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 89 5C 24 18 39 C5 0F 87 76 01 00 00 0F 83 98 01 00 00 89 C3 8B 44 24 18 31 EB 31 F8 09 D8 0F 84 32 01 00 00 81 E1 00 00 FE 7F C1 E9 11 81 E9 20 18 00 00 8D 04 0A 83 F8 14 7F 69 0F 84 82 01 00 00 85 C0 0F 8E 6A 01 00 00 8B 44 24 28 85 C0 8D 76 00 75 50 83 F9 00 0F 8C 5A 02 00 00 8B 44 24 08 8B 54 24 0C 0F 84 F1 FE FF FF 8B 1C CD ?? ?? ?? ?? 0F AF DA 8B 14 CD ?? ?? ?? ?? 0F AF D0 01 D3 F7 24 CD ?? ?? ?? ?? 01 DA E9 CD FE FF FF 8D 76 00 89 C8 25 00 00 00 7C 3D 00 00 00 7C 0F 84 9F 00 00 00 83 0D ?? ?? ?? ?? 01 31 C0 BA 00 00 00 80 E9 A5 FE FF FF 81 FE C0 87 AD BE 0F 87 95 FE FF FF E9 C0 FE FF FF 8B 5C 24 0C 31 C0 31 D2 0B 5C 24 08 0F 84 82 FE FF FF 81 7C 24 0C FF FF 1F 00 0F 86 A2 00 00 00 8B 54 24 0C 89 D0 31 D2 89 44 24 68 89 54 24 6C DF 6C 24 68 DD 5C 24 10 8B 54 24 14 89 D0 C1 E8 14 25 FF 07 00 00 2D DE 03 00 00 E9 C2 FE FF FF 31 C0 31 D2 81 7C 24 0C 63 8E 8D 37 0F 87 32 FE FF FF 89 CB 81 E3 00 00 00 60 81 FB 00 00 00 60 0F 85 79 FE FF FF E9 19 FE FF FF 83 0D ?? ?? ?? ?? 01 31 C0 BA 00 00 00 80 E9 06 FE FF FF 8B 44 24 10 8B 5C 24 0C C1 E0 05 05 ?? ?? ?? ?? 39 58 14 0F 87 B5 FE FF FF 72 11 8B 5C 24 08 39 58 10 0F 87 A6 FE FF FF 8D 74 26 00 83 C2 01 E9 9A FE FF FF DF 6C 24 08 DD 5C 24 10 8B 54 24 14 89 D0 C1 E8 14 25 FF 07 00 00 2D FE 03 00 00 E9 30 FE FF FF 39 DF 77 D4 E9 5F FE FF FF 83 0D ?? ?? ?? ?? 20 31 C0 31 D2 E9 99 FD FF FF 8B 44 24 28 85 C0 74 08 83 FA 15 E9 D1 FE FF FF 83 FA 01 0F 84 4B 05 00 00 83 FA 13 0F 8F F8 04 00 00 B8 15 00 00 00 8B 5C 24 0C 29 D0 8B 14 C5 ?? ?? ?? ?? 8B 04 C5 ?? ?? ?? ?? 89 5C 24 20 8B 5C 24 08 C7 44 24 2C 00 00 00 00 89 54 24 10 89 44 24 30 89 D0 F7 64 24 20 89 44 24 18 8B 44 24 30 89 54 24 1C F7 64 24 20 89 44 24 20 8B 44 24 10 89 54 24 24 8B 54 24 18 89 54 24 28 F7 E3 89 D0 31 D2 89 44 24 10 8B 44 24 28 01 44 24 10 89 54 24 14 8B 54 24 2C 11 54 24 14 8B 54 24 1C 89 D0 31 D2 89 44 24 18 8B 44 24 20 01 44 24 18 89 54 24 1C 8B 54 24 24 11 54 24 1C 8B 44 24 30 F7 E3 01 44 24 10 11 54 24 14 8B 54 24 14 89 D0 31 D2 01 44 24 18 11 54 24 1C 83 7C 24 1C 00 0F 87 FD FD FF FF 83 7C 24 18 09 0F 86 A2 FD FF FF E9 ED FD FF FF 89 CB F7 D1 89 4C 24 44 C1 E1 04 F7 DB 8B 91 ?? ?? ?? ?? 8B 81 ?? ?? ?? ?? 89 5C 24 64 8B 5C 24 0C C7 44 24 34 00 00 00 00 89 54 24 28 89 44 24 38 89 D0 F7 E3 89 44 24 18 8B 44 24 38 89 54 24 1C F7 E3 89 44 24 20 8B 44 24 28 89 54 24 24 F7 64 24 08 89 54 24 4C 8B 54 24 18 89 44 24 48 89 54 24 30 8B 54 24 4C 89 D0 31 D2 89 44 24 10 8B 44 24 30 01 44 24 10 8B 44 24 38 89 54 24 14 8B 54 24 34 11 54 24 14 F7 64 24 08 01 44 24 10 11 54 24 14 8B 54 24 1C 89 D0 31 D2 89 44 24 18 8B 44 24 20 01 44 24 18 89 54 24 1C 8B 54 24 24 11 54 24 1C 8B 54 24 14 89 D0 31 D2 01 44 24 18 11 54 24 1C 8B 91 ?? ?? ?? ?? 8B 89 ?? ?? ?? ?? 89 D0 89 54 24 30 F7 E3 89 4C 24 60 89 44 24 20 89 C8 89 54 24 24 F7 E3 89 44 24 50 8B 44 24 30 89 54 24 54 F7 64 24 08 89 54 24 5C 8B 5C 24 5C 31 D2 89 44 24 58 8B 44 24 20 89 D9 31 DB 01 C1 8B 44 24 60 11 D3 F7 64 24 08 01 C1 11 D3 8B 54 24 24 89 D0 31 D2 89 44 24 20 8B 44 24 50 01 44 24 20 89 54 24 24 8B 54 24 54 11 54 24 24 31 D2 01 5C 24 20 11 54 24 24 31 C0 31 D2 89 4C 24 54 8B 4C 24 10 89 44 24 50 8B 44 24 58 01 44 24 50 11 54 24 54 31 D2 8B 44 24 48 89 CB 31 C9 89 4C 24 10 01 44 24 10 8B 44 24 20 89 5C 24 14 11 54 24 14 8B 54 24 24 01 44 24 10 11 54 24 14 8B 4C 24 14 39 CA 72 14 77 08 8B 5C 24 10 39 D8 76 0A 83 44 24 18 01 83 54 24 1C 00 8B 44 24 28 31 DB F7 E5 89 44 24 08 8B 44 24 38 89 54 24 0C 8B 4C 24 08 F7 E5 89 44 24 48 8B 44 24 28 89 54 24 4C F7 E6 89 44 24 28 89 D0 89 44 24 20 8B 44 24 38 89 54 24 2C 31 D2 89 54 24 24 F7 E6 01 44 24 20 11 54 24 24 01 4C 24 20 11 5C 24 24 8B 5C 24 0C 8B 54 24 24 89 D9 31 DB 89 4C 24 08 8B 4C 24 48 89 D0 01 4C 24 08 89 5C 24 0C 8B 5C 24 4C 11 5C 24 0C 31 D2 01 44 24 08 8B 44 24 30 11 54 24 0C 31 DB F7 E5 89 44 24 38 8B 44 24 60 89 54 24 3C 8B 7C 24 38 F7 E5 31 ED 89 44 24 48 8B 44 24 30 89 54 24 4C F7 E6 89 44 24 30 8B 44 24 60 89 D1 89 54 24 34 F7 E6 01 C1 11 D3 01 F9 8B 7C 24 3C 11 EB 89 4C 24 3C 8B 4C 24 20 89 FE 31 FF 03 74 24 48 13 7C 24 4C 31 D2 01 DE 89 CB 11 D7 31 C0 89 44 24 38 8B 44 24 30 31 D2 01 44 24 38 8B 44 24 28 11 54 24 3C 31 C9 31 D2 01 C1 11 D3 01 F1 11 FB 39 DF 72 10 77 04 39 CE 76 0A 83 44 24 08 01 83 54 24 0C 00 8B 74 24 10 8B 7C 24 14 03 74 24 38 13 7C 24 3C 39 7C 24 3C C7 44 24 20 01 00 00 00 C7 44 24 24 00 00 00 00 77 18 72 06 39 74 24 38 77 10 C7 44 24 20 00 00 00 00 C7 44 24 24 00 00 00 00 8B 44 24 18 03 4C 24 20 8B 54 24 1C 13 5C 24 24 01 C8 89 44 24 18 11 DA 39 D3 89 54 24 1C 0F 87 99 02 00 00 72 08 39 C1 0F 87 8F 02 00 00 31 D2 B8 01 00 00 00 39 5C 24 24 77 0C 72 06 39 4C 24 20 77 04 31 C0 31 D2 8B 4C 24 08 8B 5C 24 0C 01 C1 11 D3 83 7C 24 64 16 89 5C 24 2C 8B 5C 24 44 89 4C 24 28 0F 8F BB 01 00 00 8B 1C DD ?? ?? ?? ?? 31 ED 8B 44 24 44 8B 54 24 1C 89 5C 24 10 8B 5C 24 44 8B 1C DD ?? ?? ?? ?? 89 5C 24 20 8B 1C 85 ?? ?? ?? ?? 8B 44 24 18 89 D9 0F AD D0 D3 EA F6 C3 20 0F 45 C2 0F 45 D5 89 44 24 08 8B 44 24 28 BD 40 00 00 00 89 54 24 0C 8B 54 24 2C 29 DD 89 E9 31 DB 8B 6C 24 08 0F A5 C2 D3 E0 F6 C1 20 8B 4C 24 0C 0F 45 D0 0F 45 C3 09 C5 09 D1 83 7C 24 64 03 0F 8F E0 01 00 00 8B 44 24 44 C1 E0 04 8B 90 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 39 C7 0F 87 33 02 00 00 72 08 39 D6 0F 87 29 02 00 00 31 F8 31 D6 09 F0 0F 84 F4 01 00 00 89 E8 89 CA E9 7F F8 FF FF 83 FA 14 0F 84 1B 02 00 00 83 FA 15 0F 84 66 02 00 00 83 EA 15 B8 0A 00 00 00 6B 1C D5 ?? ?? ?? ?? 0A F7 24 D5 ?? ?? ?? ?? 01 DA 39 D5 0F 82 44 F9 FF FF 0F 87 8E F9 FF FF 39 C7 0F 82 36 F9 FF FF 8D 74 26 00 E9 7D F9 FF FF 8B 5C 24 0C 8B 54 24 08 A1 ?? ?? ?? ?? C7 44 24 24 00 00 00 00 89 54 24 30 F7 E3 89 44 24 28 A1 ?? ?? ?? ?? 89 54 24 2C F7 E3 89 54 24 1C 8B 54 24 28 89 44 24 18 A1 ?? ?? ?? ?? 89 54 24 20 F7 64 24 30 89 D0 31 D2 89 44 24 10 8B 44 24 20 01 44 24 10 8B 44 24 08 89 54 24 14 8B 54 24 24 11 54 24 14 8B 15 ?? ?? ?? ?? 0F AF 05 ?? ?? ?? ?? 0F AF D3 8D 1C 02 8B 44 24 08 F7 25 ?? ?? ?? ?? 01 DA 89 44 24 20 8B 44 24 20 01 44 24 18 89 54 24 24 8B 54 24 24 11 54 24 1C 8B 54 24 2C 89 D0 31 D2 01 44 24 18 A1 ?? ?? ?? ?? 11 54 24 1C F7 64 24 30 E9 A5 FA FF FF 8B 1C 9D ?? ?? ?? ?? 8B 54 24 2C 8B 44 24 28 89 DD 8B 5C 24 44 83 ED 40 89 E9 31 ED 0F AD D0 D3 EA F6 C1 20 0F 45 C2 0F 45 D5 89 44 24 08 8B 44 24 28 89 54 24 0C 8B 54 24 2C 23 04 DD ?? ?? ?? ?? 23 14 DD ?? ?? ?? ?? 09 C2 0F 85 12 01 00 00 8B 44 24 1C 0B 44 24 18 0F 85 04 01 00 00 8B 44 24 44 C1 E0 04 8B 90 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 39 C7 0F 87 E9 00 00 00 72 08 39 D6 0F 87 DF 00 00 00 39 C7 0F 84 A6 00 00 00 8B 44 24 08 8B 54 24 0C E9 E5 F6 FF FF B8 01 00 00 00 31 D2 E9 7E FD FF FF 8B 44 24 18 8B 54 24 1C 23 44 24 10 23 54 24 20 09 C2 75 5A 8B 44 24 44 C1 E0 04 8B 90 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 39 C7 77 43 72 04 39 D6 77 3D 39 C7 0F 85 18 FE FF FF 39 D6 8D 74 26 00 0F 85 0C FE FF FF 8B 44 24 44 8B 54 24 54 C1 E0 04 3B 90 ?? ?? ?? ?? 0F 82 F5 FD FF FF 77 10 8B 5C 24 50 3B 98 ?? ?? ?? ?? 0F 86 E3 FD FF FF 83 0D ?? ?? ?? ?? 20 89 E8 89 CA E9 5B F6 FF FF 89 EA 09 FA 0F 85 99 F7 FF FF E9 44 F7 FF FF 39 D6 0F 85 52 FF FF FF 8B 44 24 44 8B 54 24 54 C1 E0 04 3B 90 ?? ?? ?? ?? 0F 82 3B FF FF FF 77 10 8B 4C 24 50 3B 88 ?? ?? ?? ?? 0F 86 29 FF FF FF 83 0D ?? ?? ?? ?? 20 8B 44 24 08 8B 54 24 0C E9 07 F6 FF FF 83 FD 00 0F 87 46 F7 FF FF 83 FF 09 0F 86 ED F6 FF FF E9 38 F7 FF FF 8D B6 00 00 00 00 }
	condition:
		$1
}

rule file_92_8_0 {
	meta:
		name = "___bid128_to_uint64_rninta"
		size = 2896
		refs = "0106 ___bid_nr_digits 0163 ___bid_IDEC_glbflags 0265 ___bid_midpoint64 0326 ___bid_ten2k64 035d ___bid_midpoint128 05c7 ___bid_ten2k128 0706 ___bid_ten2mk128 0a0c ___bid_shiftright128"
	strings:
		$1 = { 81 EC 8C 00 00 00 8B 84 24 90 00 00 00 8B 8C 24 9C 00 00 00 89 5C 24 7C 89 B4 24 80 00 00 00 89 44 24 60 8B 84 24 94 00 00 00 8B 5C 24 60 89 CA 81 E2 00 00 00 78 89 BC 24 84 00 00 00 89 44 24 64 8B 74 24 64 89 1C 24 89 CB 8B 84 24 98 00 00 00 81 E3 00 00 00 80 81 FA 00 00 00 78 89 AC 24 88 00 00 00 89 74 24 04 0F 84 06 01 00 00 89 CD 89 C7 81 E5 FF FF 01 00 81 FD 09 ED 01 00 76 24 31 C0 31 D2 8B 5C 24 7C 8B B4 24 80 00 00 00 8B BC 24 84 00 00 00 8B AC 24 88 00 00 00 81 C4 8C 00 00 00 C3 0F 83 F6 00 00 00 89 EA 89 F8 81 F2 09 ED 01 00 35 C0 87 AD BE 09 C2 0F 84 3F 01 00 00 89 C8 25 00 00 00 60 3D 00 00 00 60 74 B1 89 EE 09 FE 0F 84 D7 00 00 00 89 7C 24 58 89 6C 24 5C DF 6C 24 58 DD 5C 24 08 8B 54 24 0C 89 D0 C1 E8 14 25 FF 07 00 00 2D BE 03 00 00 83 E8 01 89 C6 C1 E6 05 8B 96 ?? ?? ?? ?? 89 44 24 10 85 D2 75 34 8B 86 ?? ?? ?? ?? 8B 96 ?? ?? ?? ?? 8B B6 ?? ?? ?? ?? 89 44 24 08 39 F5 0F 87 A0 01 00 00 0F 83 C1 01 00 00 8B 44 24 08 31 EE 31 F8 09 C6 0F 84 62 01 00 00 81 E1 00 00 FE 7F C1 E9 11 8D B1 E0 E7 FF FF 8D 04 32 83 F8 14 0F 8E CF 00 00 00 83 0D ?? ?? ?? ?? 01 31 C0 BA 00 00 00 80 E9 10 FF FF FF 89 C8 25 00 00 00 7C 3D 00 00 00 7C 0F 84 0F 01 00 00 83 0D ?? ?? ?? ?? 01 31 C0 BA 00 00 00 80 E9 EB FE FF FF 8D B4 26 00 00 00 00 3D C0 87 AD BE 0F 87 D5 FE FF FF E9 FA FE FF FF 8B 74 24 04 31 C0 31 D2 0B 34 24 0F 84 C3 FE FF FF 81 7C 24 04 FF FF 1F 00 0F 86 09 01 00 00 8B 54 24 04 89 D0 31 D2 89 44 24 58 89 54 24 5C DF 6C 24 58 DD 5C 24 08 8B 54 24 0C 89 D0 C1 E8 14 25 FF 07 00 00 2D DE 03 00 00 E9 FD FE FF FF 90 31 C0 31 D2 81 7C 24 04 63 8E 8D 37 0F 87 72 FE FF FF 89 CE 81 E6 00 00 00 60 81 FE 00 00 00 60 0F 85 B3 FE FF FF E9 59 FE FF FF 90 8D 74 26 00 0F 84 11 01 00 00 83 F8 00 8D B4 26 00 00 00 00 0F 8C 3A FE FF FF 0F 85 B4 00 00 00 8D 42 FF 83 F8 12 0F 8F FB 00 00 00 89 E9 09 F9 75 23 8B 74 24 04 39 34 C5 ?? ?? ?? ?? 0F 87 11 FE FF FF 72 10 8B 14 24 39 14 C5 ?? ?? ?? ?? 0F 87 FF FD FF FF 31 D2 85 DB B8 01 00 00 00 0F 85 D1 FE FF FF E9 EF FD FF FF 83 0D ?? ?? ?? ?? 01 31 C0 BA 00 00 00 80 E9 DC FD FF FF 8B 44 24 10 8B 74 24 04 C1 E0 05 05 ?? ?? ?? ?? 39 70 14 0F 87 85 FE FF FF 72 0D 8B 34 24 39 70 10 0F 87 77 FE FF FF 90 83 C2 01 E9 6E FE FF FF DF 2C 24 DD 5C 24 08 8B 54 24 0C 89 D0 C1 E8 14 25 FF 07 00 00 2D FE 03 00 00 E9 05 FE FF FF 39 C7 77 D5 E9 36 FE FF FF 85 DB 0F 85 59 FE FF FF 83 FE 00 90 8D 74 26 00 0F 8C 9C 03 00 00 8B 04 24 8B 54 24 04 0F 84 61 FD FF FF 8B 0C F5 ?? ?? ?? ?? 0F AF CA 8B 14 F5 ?? ?? ?? ?? 0F AF D0 01 D1 F7 24 F5 ?? ?? ?? ?? 01 CA E9 3D FD FF FF 85 DB 74 6A 83 FA 15 E9 0E FE FF FF 8D 4A EC 89 C8 C1 E0 04 8B 90 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 39 C5 0F 82 11 FD FF FF 77 08 39 D7 0F 82 07 FD FF FF 31 E8 31 FA 09 D0 90 0F 85 FB FE FF FF C1 E1 04 8B 74 24 04 39 B1 ?? ?? ?? ?? 0F 87 E7 FC FF FF 0F 82 E2 FE FF FF 8B 04 24 39 81 ?? ?? ?? ?? 0F 87 D2 FC FF FF 66 90 E9 CC FE FF FF 83 FA 01 0F 84 07 02 00 00 83 FA 13 0F 8F E9 00 00 00 8B 0C 24 B8 15 00 00 00 29 D0 8B 5C 24 04 89 4C 24 10 8B 0C C5 ?? ?? ?? ?? 8B 04 C5 ?? ?? ?? ?? 89 44 24 18 89 C8 F7 E3 89 44 24 08 8B 44 24 18 89 54 24 0C F7 E3 89 44 24 28 8B 44 24 10 89 54 24 2C F7 E1 89 54 24 24 8B 5C 24 24 31 D2 89 44 24 20 8B 44 24 08 89 D9 31 DB 01 C1 8B 44 24 18 11 D3 F7 64 24 10 01 C1 11 D3 8B 54 24 0C 89 D0 31 D2 89 44 24 10 8B 44 24 28 89 54 24 14 8B 54 24 2C 01 44 24 10 11 54 24 14 89 DA 89 D0 31 D2 01 44 24 10 11 54 24 14 83 7C 24 14 00 0F 87 F7 FC FF FF 83 7C 24 10 09 0F 87 EC FC FF FF 8B 44 24 10 83 F0 09 0B 44 24 14 0F 85 82 FE FF FF 89 CA 8B 4C 24 20 31 C0 31 DB 01 C8 11 DA 83 FA FF 0F 82 6B FE FF FF 83 F8 FA 0F 86 62 FE FF FF E9 B6 FC FF FF 90 8D 74 26 00 83 FA 14 0F 84 A2 05 00 00 83 FA 15 8D 74 26 00 0F 84 51 06 00 00 83 EA 15 8B 0C D5 ?? ?? ?? ?? 8B 14 D5 ?? ?? ?? ?? 89 4C 24 10 B9 FB FF FF FF 89 D0 89 54 24 18 F7 E1 89 44 24 20 B8 FF FF FF FF 89 54 24 24 F7 64 24 18 89 44 24 08 8B 44 24 10 89 54 24 0C F7 E1 89 54 24 2C 8B 5C 24 2C 31 D2 89 44 24 28 8B 44 24 20 89 D9 31 DB 01 C1 B8 FF FF FF FF 11 D3 F7 64 24 10 01 C1 B8 09 00 00 00 11 D3 8B 54 24 18 8D 14 D2 89 54 24 18 F7 64 24 10 03 54 24 18 01 44 24 08 11 54 24 0C 8B 54 24 24 89 D0 31 D2 01 44 24 08 11 54 24 0C 89 DA 89 D0 31 D2 01 44 24 08 11 54 24 0C 3B 6C 24 0C 0F 87 EB FB FF FF 72 0A 3B 7C 24 08 0F 87 DF FB FF FF 3B 6C 24 0C 0F 85 7C FD FF FF 3B 7C 24 08 0F 85 72 FD FF FF 89 CA 8B 4C 24 28 31 C0 31 DB 01 C8 11 DA 3B 54 24 04 0F 87 5A FD FF FF 0F 82 AD FB FF FF 3B 04 24 0F 87 4B FD FF FF 8D 76 00 E9 9C FB FF FF 8B 1D ?? ?? ?? ?? 8B 4C 24 04 8B 14 24 89 D8 89 54 24 18 F7 E1 89 44 24 10 A1 ?? ?? ?? ?? 89 54 24 14 F7 E1 89 44 24 08 8B 44 24 18 89 54 24 0C F7 E3 89 54 24 2C 8B 5C 24 2C 31 D2 89 44 24 28 8B 44 24 10 89 D9 31 DB 01 C1 A1 ?? ?? ?? ?? 11 D3 F7 64 24 18 01 C1 8B 04 24 11 D3 8B 54 24 04 0F AF 15 ?? ?? ?? ?? 0F AF 05 ?? ?? ?? ?? 01 D0 89 44 24 18 8B 04 24 F7 25 ?? ?? ?? ?? 89 44 24 20 8B 44 24 18 01 C2 8B 44 24 20 01 44 24 08 89 54 24 24 8B 54 24 24 11 54 24 0C 8B 54 24 14 89 D0 31 D2 01 44 24 08 11 54 24 0C 89 DA 89 D0 31 D2 01 44 24 08 11 54 24 0C 83 7C 24 0C 00 0F 87 D8 FA FF FF 83 7C 24 08 09 0F 87 CD FA FF FF 8B 44 24 08 83 F0 09 0B 44 24 0C 0F 85 63 FC FF FF 89 CA 31 C0 8B 4C 24 28 E9 DC FD FF FF 89 F1 F7 D9 83 F9 13 89 4C 24 44 0F 8F FD 03 00 00 F7 D6 8B 0C 24 8B 5C 24 04 03 0C F5 ?? ?? ?? ?? 13 1C F5 ?? ?? ?? ?? 89 74 24 40 39 5C 24 04 72 0D 77 05 39 0C 24 76 06 83 C7 01 83 D5 00 89 4C 24 18 8B 4C 24 40 C7 44 24 24 00 00 00 00 C1 E1 04 8B 81 ?? ?? ?? ?? 8B B1 ?? ?? ?? ?? 89 44 24 28 89 D8 F7 E6 89 44 24 08 8B 44 24 28 89 54 24 0C F7 E3 89 44 24 10 8B 44 24 18 89 54 24 14 F7 E6 89 54 24 34 8B 54 24 08 89 44 24 30 89 54 24 20 8B 54 24 34 89 D0 31 D2 89 04 24 8B 44 24 20 01 04 24 8B 44 24 18 89 54 24 04 8B 54 24 24 11 54 24 04 F7 64 24 28 01 04 24 11 54 24 04 8B 54 24 0C 89 D0 31 D2 89 44 24 08 8B 44 24 10 01 44 24 08 89 54 24 0C 8B 54 24 14 11 54 24 0C 8B 54 24 04 89 D0 31 D2 01 44 24 08 11 54 24 0C 8B 91 ?? ?? ?? ?? 8B 89 ?? ?? ?? ?? 89 D0 89 54 24 20 F7 E3 89 4C 24 3C 89 44 24 48 89 C8 8B 4C 24 48 89 54 24 4C F7 E3 31 DB 89 44 24 50 8B 44 24 18 89 54 24 54 F7 64 24 20 89 D0 31 D2 89 44 24 10 8B 44 24 18 01 4C 24 10 89 54 24 14 11 5C 24 14 8B 5C 24 4C 89 D9 31 DB 03 4C 24 50 13 5C 24 54 F7 64 24 3C 01 44 24 10 11 54 24 14 8B 54 24 14 89 D0 31 D2 01 C1 8B 04 24 11 D3 89 C2 B8 00 00 00 00 89 04 24 8B 44 24 30 89 54 24 04 31 D2 01 04 24 11 54 24 04 01 0C 24 11 5C 24 04 3B 5C 24 04 72 11 77 05 3B 0C 24 76 0A 83 44 24 08 01 83 54 24 0C 00 89 E9 89 FD 89 C8 F7 E6 89 44 24 18 8B 44 24 28 89 54 24 1C F7 E1 89 44 24 10 89 F8 89 54 24 14 F7 E6 89 54 24 34 8B 7C 24 34 31 D2 89 44 24 30 8B 44 24 18 89 FE 31 FF 01 C6 8B 44 24 28 11 D7 F7 E5 01 C6 11 D7 8B 54 24 1C 89 D0 31 D2 89 44 24 18 8B 44 24 10 01 44 24 18 8B 44 24 20 89 54 24 1C 8B 54 24 14 11 54 24 1C 31 D2 01 7C 24 18 89 F7 11 54 24 1C F7 E1 89 44 24 10 8B 44 24 3C 89 54 24 14 F7 E1 89 44 24 28 8B 44 24 20 89 54 24 2C F7 E5 89 44 24 20 89 54 24 24 8B 5C 24 24 31 D2 8B 44 24 10 89 D9 31 DB 01 C1 8B 44 24 3C 11 D3 F7 E5 01 C1 11 D3 8B 54 24 14 89 D0 31 D2 89 44 24 10 8B 44 24 28 01 44 24 10 8B 44 24 20 89 54 24 14 8B 54 24 2C 11 54 24 14 31 D2 01 5C 24 10 89 CB 11 54 24 14 31 C9 31 D2 01 C1 8B 44 24 30 11 D3 31 F6 31 D2 01 C6 11 D7 03 74 24 10 13 7C 24 14 39 7C 24 14 72 12 77 06 39 74 24 10 76 0A 83 44 24 18 01 83 54 24 1C 00 8B 04 24 8B 54 24 04 01 C8 11 DA 89 54 24 04 31 D2 3B 5C 24 04 89 04 24 B8 01 00 00 00 77 0B 72 05 3B 0C 24 77 04 31 C0 31 D2 8B 4C 24 08 01 C6 8B 5C 24 0C 11 D7 01 F1 11 FB 39 DF 89 4C 24 08 89 5C 24 0C 0F 87 95 00 00 00 72 08 39 CE 0F 87 8B 00 00 00 31 DB 39 FA B9 01 00 00 00 77 0A 72 04 39 F0 77 04 31 C9 31 DB 89 C8 89 DA 03 44 24 18 13 54 24 1C 83 7C 24 44 16 0F 8F 01 01 00 00 8B 5C 24 40 89 D6 8B 7C 24 08 8B 6C 24 0C C7 44 24 08 40 00 00 00 8B 0C 9D ?? ?? ?? ?? 31 DB 0F AD EF D3 ED F6 C1 20 0F 45 FD 0F 45 EB 29 4C 24 08 89 C3 0F B6 4C 24 08 0F A5 C6 31 C0 D3 E3 F6 C1 20 0F 45 F3 0F 45 D8 89 1C 24 8B 04 24 89 74 24 04 8B 54 24 04 09 F8 09 EA E9 32 F6 FF FF B8 01 00 00 00 31 D2 EB 85 8B 0C 24 89 F8 89 EA 8B 5C 24 04 0F A4 C2 01 01 C0 0F A4 CB 01 01 C9 3B 5C 24 04 77 0D 72 05 3B 0C 24 73 06 83 C0 01 83 D2 00 83 FA 00 0F 87 D3 F6 FF FF 83 F8 01 0F 87 CA F6 FF FF 83 F0 01 09 D0 0F 85 66 F8 FF FF 83 C3 01 0F 85 5D F8 FF FF 83 C1 01 0F 85 54 F8 FF FF E9 A8 F6 FF FF 8D B4 26 00 00 00 00 B8 EC FF FF FF 8B 0C 24 29 F0 8B 5C 24 04 F7 D6 C1 E0 04 03 88 ?? ?? ?? ?? 89 74 24 40 13 98 ?? ?? ?? ?? 03 B8 ?? ?? ?? ?? 13 A8 ?? ?? ?? ?? E9 EA FB FF FF 8B 74 24 40 8B 0C B5 ?? ?? ?? ?? 31 F6 83 E9 40 0F AD D0 D3 EA 83 E1 20 0F 45 C2 0F 45 D6 E9 6D F5 FF FF 83 FD 00 0F 87 41 F6 FF FF 83 FF 09 0F 87 38 F6 FF FF 89 F8 83 F0 09 09 E8 0F 85 D2 F7 FF FF 83 7C 24 04 FF 0F 82 C7 F7 FF FF 83 3C 24 FA 0F 86 BD F7 FF FF E9 11 F6 FF FF }
	condition:
		$1
}

rule file_92_9_0 {
	meta:
		name = "___bid128_to_uint64_xrninta"
		size = 3776
		refs = "0112 ___bid_nr_digits 016f ___bid_IDEC_glbflags 0269 ___bid_midpoint64 0337 ___bid_ten2k64 037e ___bid_midpoint128 05e7 ___bid_ten2k128 072b ___bid_ten2mk128 0a69 ___bid_maskhigh128 0a83 ___bid_shiftright128 0af8 ___bid_ten2mk128trunc 0b3c ___bid_onehalf128"
	strings:
		$1 = { 81 EC 9C 00 00 00 8B 84 24 A0 00 00 00 8B 8C 24 AC 00 00 00 89 9C 24 8C 00 00 00 89 B4 24 90 00 00 00 89 44 24 70 8B 84 24 A4 00 00 00 8B 5C 24 70 89 CA 81 E2 00 00 00 78 89 BC 24 94 00 00 00 89 44 24 74 8B 74 24 74 89 5C 24 10 89 CB 8B 84 24 A8 00 00 00 81 E3 00 00 00 80 81 FA 00 00 00 78 89 AC 24 98 00 00 00 89 74 24 14 0F 84 0E 01 00 00 89 CD 89 C7 81 E5 FF FF 01 00 81 FD 09 ED 01 00 76 2C 31 C0 31 D2 8B 9C 24 8C 00 00 00 8B B4 24 90 00 00 00 8B BC 24 94 00 00 00 8B AC 24 98 00 00 00 81 C4 9C 00 00 00 C3 90 8D 74 26 00 0F 83 EF 00 00 00 89 EA 89 F8 81 F2 09 ED 01 00 35 C0 87 AD BE 09 C2 0F 84 38 01 00 00 89 C8 25 00 00 00 60 3D 00 00 00 60 74 A9 89 EE 09 FE 0F 84 D0 00 00 00 89 7C 24 68 89 6C 24 6C DF 6C 24 68 DD 5C 24 18 8B 54 24 1C 89 D0 C1 E8 14 25 FF 07 00 00 2D BE 03 00 00 83 E8 01 89 C6 C1 E6 05 8B 96 ?? ?? ?? ?? 89 44 24 20 85 D2 75 34 8B 86 ?? ?? ?? ?? 8B 96 ?? ?? ?? ?? 8B B6 ?? ?? ?? ?? 89 44 24 18 39 F5 0F 87 95 01 00 00 0F 83 BE 01 00 00 8B 44 24 18 31 EE 31 F8 09 C6 0F 84 57 01 00 00 81 E1 00 00 FE 7F C1 E9 11 8D B1 E0 E7 FF FF 8D 04 32 83 F8 14 0F 8E C3 00 00 00 83 0D ?? ?? ?? ?? 01 31 C0 BA 00 00 00 80 E9 08 FF FF FF 89 C8 25 00 00 00 7C 3D 00 00 00 7C 0F 84 04 01 00 00 83 0D ?? ?? ?? ?? 01 31 C0 BA 00 00 00 80 E9 E3 FE FF FF 3D C0 87 AD BE 0F 87 D4 FE FF FF E9 01 FF FF FF 8B 74 24 14 31 C0 31 D2 0B 74 24 10 0F 84 C1 FE FF FF 81 7C 24 14 FF FF 1F 00 0F 86 0B 01 00 00 8B 54 24 14 89 D0 31 D2 89 44 24 68 89 54 24 6C DF 6C 24 68 DD 5C 24 18 8B 54 24 1C 89 D0 C1 E8 14 25 FF 07 00 00 2D DE 03 00 00 E9 03 FF FF FF 31 C0 31 D2 81 7C 24 14 63 8E 8D 37 0F 87 71 FE FF FF 89 CE 81 E6 00 00 00 60 81 FE 00 00 00 60 0F 85 BA FE FF FF E9 58 FE FF FF 0F 84 32 01 00 00 83 F8 00 8D B4 26 00 00 00 00 0F 8C 12 01 00 00 0F 85 C4 00 00 00 8D 42 FF 83 F8 12 0F 8F 1C 01 00 00 89 E9 09 F9 0F 85 65 01 00 00 8B 74 24 14 39 34 C5 ?? ?? ?? ?? 77 17 0F 82 52 01 00 00 8B 7C 24 10 39 3C C5 ?? ?? ?? ?? 0F 86 41 01 00 00 31 C0 31 D2 83 0D ?? ?? ?? ?? 20 E9 F2 FD FF FF 83 0D ?? ?? ?? ?? 01 31 C0 BA 00 00 00 80 E9 DF FD FF FF 8B 44 24 20 8B 74 24 14 C1 E0 05 05 ?? ?? ?? ?? 39 70 14 0F 87 90 FE FF FF 72 0D 8B 74 24 10 39 70 10 0F 87 81 FE FF FF 83 C2 01 E9 79 FE FF FF 8D B4 26 00 00 00 00 DF 6C 24 10 DD 5C 24 18 8B 54 24 1C 89 D0 C1 E8 14 25 FF 07 00 00 2D FE 03 00 00 E9 08 FE FF FF 39 C7 77 CD E9 39 FE FF FF 8D B4 26 00 00 00 00 85 DB 0F 85 55 FE FF FF 83 FE 00 90 8D 74 26 00 0F 8C AF 03 00 00 8B 44 24 10 8B 54 24 14 0F 84 54 FD FF FF 8B 0C F5 ?? ?? ?? ?? 0F AF CA 8B 14 F5 ?? ?? ?? ?? 0F AF D0 01 D1 F7 24 F5 ?? ?? ?? ?? 01 CA E9 30 FD FF FF 83 0D ?? ?? ?? ?? 20 31 C0 31 D2 E9 20 FD FF FF 85 DB 74 6F 83 FA 15 E9 F9 FD FF FF 8D 4A EC 89 C8 C1 E0 04 8B 90 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 39 C5 0F 82 F6 FE FF FF 77 08 39 D7 0F 82 EC FE FF FF 31 E8 31 FA 09 D0 75 25 C1 E1 04 8B 6C 24 14 39 A9 ?? ?? ?? ?? 0F 87 D1 FE FF FF 72 10 8B 44 24 10 39 81 ?? ?? ?? ?? 0F 87 BF FE FF FF 85 DB 0F 85 9E FD FF FF B8 01 00 00 00 31 D2 E9 AF FE FF FF 83 FA 01 0F 84 01 02 00 00 83 FA 13 0F 8F E5 00 00 00 8B 4C 24 10 B8 15 00 00 00 29 D0 8B 5C 24 14 89 4C 24 30 8B 0C C5 ?? ?? ?? ?? 8B 04 C5 ?? ?? ?? ?? 89 44 24 20 89 C8 F7 E3 89 44 24 18 8B 44 24 20 89 54 24 1C F7 E3 89 44 24 38 8B 44 24 30 89 54 24 3C F7 E1 89 54 24 2C 8B 5C 24 2C 31 D2 89 44 24 28 8B 44 24 18 89 D9 31 DB 01 C1 8B 44 24 20 11 D3 F7 64 24 30 01 C1 11 D3 8B 54 24 1C 89 D0 31 D2 89 44 24 20 8B 44 24 38 89 54 24 24 8B 54 24 3C 01 44 24 20 11 54 24 24 89 DA 89 D0 31 D2 01 44 24 20 11 54 24 24 83 7C 24 24 00 0F 87 DC FC FF FF 83 7C 24 20 09 0F 87 D1 FC FF FF 8B 44 24 20 83 F0 09 0B 44 24 24 0F 85 6B FE FF FF 89 CA 8B 4C 24 28 31 C0 31 DB 01 C8 11 DA 83 FA FF 0F 82 54 FE FF FF 83 F8 FA 0F 86 4B FE FF FF E9 9B FC FF FF 83 FA 14 0F 84 1E 07 00 00 83 FA 15 66 90 0F 84 07 08 00 00 83 EA 15 8B 0C D5 ?? ?? ?? ?? 8B 14 D5 ?? ?? ?? ?? 89 4C 24 30 B9 FB FF FF FF 89 D0 89 54 24 20 F7 E1 89 44 24 28 B8 FF FF FF FF 89 54 24 2C F7 64 24 20 89 44 24 18 8B 44 24 30 89 54 24 1C F7 E1 89 54 24 3C 8B 5C 24 3C 31 D2 89 44 24 38 8B 44 24 28 89 D9 31 DB 01 C1 B8 FF FF FF FF 11 D3 F7 64 24 30 01 C1 B8 09 00 00 00 11 D3 8B 54 24 20 8D 14 D2 89 54 24 20 F7 64 24 30 03 54 24 20 01 44 24 18 11 54 24 1C 8B 54 24 2C 89 D0 31 D2 01 44 24 18 11 54 24 1C 89 DA 89 D0 31 D2 01 44 24 18 11 54 24 1C 3B 6C 24 1C 0F 87 D7 FB FF FF 72 0A 3B 7C 24 18 0F 87 CB FB FF FF 3B 6C 24 1C 0F 85 6C FD FF FF 3B 7C 24 18 0F 85 62 FD FF FF 89 CA 8B 4C 24 38 31 C0 31 DB 01 C8 11 DA 3B 54 24 14 0F 87 4A FD FF FF 0F 82 99 FB FF FF 3B 44 24 10 0F 87 3A FD FF FF 66 90 E9 88 FB FF FF 8B 1D ?? ?? ?? ?? 8B 4C 24 14 8B 54 24 10 89 D8 89 54 24 20 F7 E1 89 44 24 30 A1 ?? ?? ?? ?? 89 54 24 34 F7 E1 89 44 24 18 8B 44 24 20 89 54 24 1C F7 E3 89 54 24 3C 8B 5C 24 3C 31 D2 89 44 24 38 8B 44 24 30 89 D9 31 DB 01 C1 A1 ?? ?? ?? ?? 11 D3 F7 64 24 20 01 C1 8B 44 24 10 11 D3 8B 54 24 14 0F AF 15 ?? ?? ?? ?? 0F AF 05 ?? ?? ?? ?? 01 D0 89 44 24 20 8B 44 24 10 F7 25 ?? ?? ?? ?? 89 44 24 28 8B 44 24 20 01 C2 8B 44 24 28 01 44 24 18 89 54 24 2C 8B 54 24 2C 11 54 24 1C 8B 54 24 34 89 D0 31 D2 01 44 24 18 11 54 24 1C 89 DA 89 D0 31 D2 01 44 24 18 11 54 24 1C 83 7C 24 1C 00 0F 87 C1 FA FF FF 83 7C 24 18 09 0F 87 B6 FA FF FF 8B 44 24 18 83 F0 09 0B 44 24 1C 0F 85 50 FC FF FF 89 CA 31 C0 8B 4C 24 38 E9 E0 FD FF FF 89 F3 F7 DB 83 FB 13 89 5C 24 5C 0F 8F 7A 05 00 00 F7 D6 8B 4C 24 10 8B 5C 24 14 03 0C F5 ?? ?? ?? ?? 13 1C F5 ?? ?? ?? ?? 89 74 24 30 39 5C 24 14 72 0E 77 06 39 4C 24 10 76 06 83 C7 01 83 D5 00 89 4C 24 28 8B 4C 24 30 C7 44 24 3C 00 00 00 00 C1 E1 04 8B 81 ?? ?? ?? ?? 8B B1 ?? ?? ?? ?? 89 44 24 48 89 D8 F7 E6 89 44 24 18 8B 44 24 48 89 54 24 1C F7 E3 89 44 24 20 8B 44 24 28 89 54 24 24 F7 E6 89 54 24 54 8B 54 24 18 89 44 24 50 89 54 24 38 8B 54 24 54 89 D0 31 D2 89 44 24 10 8B 44 24 38 01 44 24 10 8B 44 24 28 89 54 24 14 8B 54 24 3C 11 54 24 14 F7 64 24 48 01 44 24 10 11 54 24 14 8B 54 24 1C 89 D0 31 D2 89 44 24 18 8B 44 24 20 01 44 24 18 89 54 24 1C 8B 54 24 24 11 54 24 1C 8B 54 24 14 89 D0 31 D2 01 44 24 18 11 54 24 1C 8B 91 ?? ?? ?? ?? 8B 89 ?? ?? ?? ?? 89 D0 89 54 24 40 F7 E3 89 4C 24 58 89 44 24 20 89 C8 89 54 24 24 F7 E3 89 44 24 38 8B 44 24 28 89 54 24 3C F7 64 24 40 89 54 24 64 8B 5C 24 64 31 D2 89 44 24 60 8B 44 24 20 89 D9 31 DB 01 C1 8B 44 24 28 11 D3 F7 64 24 58 01 C1 11 D3 8B 54 24 24 89 D0 31 D2 89 44 24 20 8B 44 24 38 89 54 24 24 8B 54 24 3C 01 44 24 20 11 54 24 24 89 DA 89 D0 31 D2 89 4C 24 3C 8B 4C 24 10 01 44 24 20 11 54 24 24 31 C0 31 D2 89 44 24 38 8B 44 24 60 89 CB 01 44 24 38 11 54 24 3C 31 C9 8B 44 24 50 31 D2 89 4C 24 10 01 44 24 10 8B 44 24 20 89 5C 24 14 11 54 24 14 8B 54 24 24 01 44 24 10 11 54 24 14 8B 4C 24 14 39 CA 72 14 77 08 8B 5C 24 10 39 D8 76 0A 83 44 24 18 01 83 54 24 1C 00 89 E9 89 FD 89 C8 F7 E6 89 44 24 28 8B 44 24 48 89 54 24 2C F7 E1 89 44 24 20 89 F8 89 54 24 24 F7 E6 89 54 24 54 8B 7C 24 54 31 D2 89 44 24 50 8B 44 24 28 89 FE 31 FF 01 C6 8B 44 24 48 11 D7 F7 E5 01 C6 11 D7 8B 54 24 2C 89 D0 31 D2 89 44 24 28 8B 44 24 20 01 44 24 28 8B 44 24 40 89 54 24 2C 8B 54 24 24 11 54 24 2C 31 D2 01 7C 24 28 89 F7 11 54 24 2C F7 E1 89 44 24 20 8B 44 24 58 89 54 24 24 F7 E1 89 44 24 48 8B 44 24 40 89 54 24 4C F7 E5 89 44 24 40 89 54 24 44 8B 5C 24 44 31 D2 8B 44 24 20 89 D9 31 DB 01 C1 8B 44 24 58 11 D3 F7 E5 01 C1 11 D3 8B 54 24 24 89 D0 31 D2 89 44 24 20 8B 44 24 48 01 44 24 20 8B 44 24 40 89 54 24 24 8B 54 24 4C 11 54 24 24 31 D2 01 5C 24 20 89 CB 11 54 24 24 31 C9 31 D2 01 C1 8B 44 24 50 11 D3 31 F6 31 D2 01 C6 11 D7 03 74 24 20 13 7C 24 24 39 7C 24 24 72 12 77 06 39 74 24 20 76 0A 83 44 24 28 01 83 54 24 2C 00 8B 44 24 10 8B 54 24 14 01 C8 11 DA 89 54 24 14 31 D2 3B 5C 24 14 89 44 24 10 B8 01 00 00 00 77 0C 72 06 3B 4C 24 10 77 04 31 C0 31 D2 8B 4C 24 18 01 C6 8B 5C 24 1C 11 D7 01 F1 11 FB 39 DF 89 4C 24 18 89 5C 24 1C 0F 87 D1 01 00 00 72 08 39 CE 0F 87 C7 01 00 00 31 DB 39 FA B9 01 00 00 00 77 0A 72 04 39 F0 77 04 31 C9 31 DB 89 C8 89 DA 8B 74 24 28 8B 7C 24 2C 01 C6 11 D7 83 7C 24 5C 16 0F 8F 3F 02 00 00 8B 5C 24 30 8B 6C 24 30 8B 54 24 1C 8B 44 24 18 8B 1C DD ?? ?? ?? ?? 8B 2C ED ?? ?? ?? ?? 89 5C 24 48 8B 5C 24 30 89 6C 24 40 8B 2C 9D ?? ?? ?? ?? 31 DB 89 E9 0F AD D0 D3 EA F6 C1 20 0F 45 C2 0F 45 D3 89 44 24 28 B8 40 00 00 00 8B 5C 24 28 29 E8 31 ED 89 C1 0F A5 F7 D3 E6 A8 20 0F 45 FE 0F 45 F5 09 F3 89 54 24 2C 09 FA 83 7C 24 5C 03 89 5C 24 20 89 54 24 28 7F 59 81 7C 24 14 00 00 00 80 0F 86 49 02 00 00 8B 74 24 10 8B 7C 24 14 8B 44 24 30 83 C6 00 81 D7 00 00 00 80 C1 E0 04 8B 90 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 39 C7 0F 87 CF 00 00 00 72 08 39 D6 0F 87 C5 00 00 00 39 C7 0F 84 BE 02 00 00 8B 44 24 20 8B 54 24 28 E9 5F F5 FF FF 8B 74 24 30 8B 5C 24 1C 23 5C 24 40 8B 4C 24 18 8B 14 F5 ?? ?? ?? ?? 23 4C 24 48 8B 04 F5 ?? ?? ?? ?? 39 D3 0F 87 C1 02 00 00 72 08 39 C1 0F 87 B7 02 00 00 39 D3 90 75 77 39 C1 75 73 8B 7C 24 14 0B 7C 24 10 75 0A 8B 6C 24 3C 0B 6C 24 38 74 5F 8B 44 24 30 C1 E0 04 8B 90 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 39 44 24 14 77 46 72 06 39 54 24 10 77 3E 39 44 24 14 90 0F 85 76 FF FF FF 39 54 24 10 0F 85 6C FF FF FF 8B 6C 24 30 8B 44 24 3C C1 E5 04 3B 85 ?? ?? ?? ?? 0F 82 55 FF FF FF 77 10 8B 54 24 38 3B 95 ?? ?? ?? ?? 0F 86 43 FF FF FF 83 0D ?? ?? ?? ?? 20 8B 44 24 20 8B 54 24 28 E9 9B F4 FF FF B8 01 00 00 00 31 D2 E9 46 FE FF FF 8B 4C 24 10 89 F8 89 EA 8B 5C 24 14 0F A4 C2 01 01 C0 0F A4 CB 01 01 C9 3B 5C 24 14 77 0E 72 06 3B 4C 24 10 73 06 83 C0 01 83 D2 00 83 FA 00 0F 87 3F F5 FF FF 83 F8 01 0F 87 36 F5 FF FF 83 F0 01 09 D0 0F 85 D6 F6 FF FF 83 C3 01 0F 85 CD F6 FF FF 83 C1 01 0F 85 C4 F6 FF FF E9 14 F5 FF FF 8D B4 26 00 00 00 00 B8 EC FF FF FF 8B 4C 24 10 29 F0 8B 5C 24 14 F7 D6 C1 E0 04 03 88 ?? ?? ?? ?? 89 74 24 30 13 98 ?? ?? ?? ?? 03 B8 ?? ?? ?? ?? 13 A8 ?? ?? ?? ?? E9 6D FA FF FF 8B 6C 24 30 8B 14 AD ?? ?? ?? ?? 8B 1C ED ?? ?? ?? ?? 8B 04 ED ?? ?? ?? ?? 89 D1 31 D2 83 E9 40 21 F3 21 F8 0F AD FE D3 EF F6 C1 20 8B 0C ED ?? ?? ?? ?? 0F 45 F7 0F 45 FA 8B 14 ED ?? ?? ?? ?? 39 D0 0F 86 96 00 00 00 83 0D ?? ?? ?? ?? 20 89 F0 89 FA E9 9B F3 FF FF 83 FD 00 0F 87 77 F4 FF FF 83 FF 09 0F 87 6E F4 FF FF 89 F8 83 F0 09 09 E8 0F 85 0C F6 FF FF 83 7C 24 14 FF 0F 82 01 F6 FF FF 83 7C 24 10 FA 0F 86 F6 F5 FF FF E9 46 F4 FF FF 72 0D 83 7C 24 10 00 66 90 0F 87 A8 FD FF FF 8B 44 24 14 05 00 00 00 80 0B 44 24 10 0F 85 90 FE FF FF 8B 4C 24 3C 0B 4C 24 38 0F 84 82 FE FF FF 8B 44 24 30 31 F6 31 FF C1 E0 04 8B 90 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? E9 A1 FD FF FF 72 08 39 CB 0F 87 60 FF FF FF 39 D0 90 0F 85 57 FF FF FF 39 CB 0F 85 4F FF FF FF 8B 4C 24 1C 0B 4C 24 18 0F 85 41 FF FF FF 8B 5C 24 14 0B 5C 24 10 0F 85 D3 00 00 00 8B 6C 24 3C 0B 6C 24 38 0F 84 25 FF FF FF 8B 44 24 30 C1 E0 04 8B 90 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 39 44 24 14 74 74 89 F0 89 FA E9 AE F2 FF FF 39 D6 0F 85 3A FD FF FF 8B 6C 24 30 8B 5C 24 3C C1 E5 04 3B 9D ?? ?? ?? ?? 0F 82 23 FD FF FF 0F 87 DA FD FF FF 8B 74 24 38 3B B5 ?? ?? ?? ?? 0F 82 0D FD FF FF E9 C5 FD FF FF 89 CE 89 DF 29 C6 19 D7 89 F0 39 FB 89 FA 0F 82 B1 FD FF FF 77 08 39 F1 0F 82 A7 FD FF FF 89 D7 09 C7 0F 84 3E FD FF FF 8D 74 26 00 E9 94 FD FF FF 39 54 24 10 75 86 8B 6C 24 30 8B 44 24 3C C1 E5 04 3B 85 ?? ?? ?? ?? 0F 82 6F FF FF FF 0F 87 75 FE FF FF 8B 54 24 38 3B 95 ?? ?? ?? ?? 0F 86 59 FF FF FF E9 60 FE FF FF 8B 44 24 30 C1 E0 04 8B 90 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 39 44 24 14 0F 87 43 FE FF FF 0F 82 2B FF FF FF 39 54 24 10 0F 87 33 FE FF FF 8D B6 00 00 00 00 E9 16 FF FF FF 90 90 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_94_0_0 {
	meta:
		name = "___bid_extenddfdd"
		size = 32
		refs = "000b ___binary64_to_bid64"
	strings:
		$1 = { 83 EC 1C DD 44 24 20 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 1C C3 90 90 90 90 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_166_0_0 {
	meta:
		name = "___bid_truncdfsd"
		size = 32
		refs = "000b ___binary64_to_bid32"
	strings:
		$1 = { 83 EC 1C DD 44 24 20 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 1C C3 90 90 90 90 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_95_0_0 {
	meta:
		name = "___trunctfxf2"
		size = 1648
	strings:
		$1 = { 55 57 56 53 81 EC 8C 00 00 00 8B 84 24 AC 00 00 00 8B 94 24 A8 00 00 00 8B B4 24 A4 00 00 00 8B 9C 24 A0 00 00 00 0F B7 C8 89 C7 89 44 24 3C C1 E8 18 C0 E8 07 88 44 24 0B 0F B6 C0 89 44 24 04 89 D0 C1 E8 1D C1 E1 03 09 C1 89 F0 C1 EF 10 C1 E8 1D 81 E7 FF 7F 00 00 89 54 24 38 C1 E2 03 09 D0 89 DA C1 EA 1D 89 5C 24 30 8D 2C DD 00 00 00 00 89 74 24 34 C1 E6 03 89 5C 24 40 8D 5F 01 09 F2 89 DE 81 E6 FF 7F 00 00 D9 7C 24 1E 83 FE 01 89 4C 24 4C 89 44 24 48 89 54 24 44 0F 8E 2E 03 00 00 81 FF FF 7F 00 00 0F 84 16 01 00 00 85 FF 0F 84 4A 05 00 00 89 CE C1 E6 0F 89 74 24 0C 89 C6 C1 EE 11 09 74 24 0C 89 C6 89 D0 C1 E8 11 C1 E6 0F C1 E2 0F 09 C6 C1 E9 11 09 EA 0F 95 C0 0F B6 C0 09 C6 89 3C 24 8B 54 24 0C 31 ED 89 74 24 50 89 4C 24 58 C7 44 24 5C 00 00 00 00 89 54 24 54 89 F2 83 E2 07 74 03 83 CD 20 0F B7 44 24 1E 66 25 00 0C 66 3D 00 04 0F 84 12 01 00 00 66 3D 00 08 0F 84 0E 03 00 00 66 85 C0 0F 85 0F 01 00 00 89 F2 83 E2 0F 83 FA 04 0F 84 01 01 00 00 83 C6 04 89 74 24 50 83 FE 03 8B 54 24 54 0F 96 C1 0F B6 C9 8B 7C 24 58 01 CA 39 D1 89 54 24 54 0F 97 C2 0F B6 D2 01 D7 89 D6 31 D2 39 FE 0F 97 C2 89 F9 89 D6 01 74 24 5C F7 C7 04 00 00 00 89 7C 24 58 0F 84 CA 00 00 00 89 F9 83 E1 FB 81 FB FF 7F 00 00 89 4C 24 58 0F 84 17 03 00 00 8B 7C 24 54 89 DA 66 81 E2 FF 7F 8D 73 01 66 89 54 24 04 81 E6 FF 7F 00 00 8B 54 24 50 89 F8 89 1C 24 E9 AD 00 00 00 0F B7 44 24 1E 66 25 00 0C 0F 84 8D 01 00 00 66 3D 00 08 0F 84 73 01 00 00 66 3D 00 04 0F 84 6A 04 00 00 66 3D 00 04 BB FF 7F 00 00 C7 44 24 5C FF FF FF FF BD 28 00 00 00 BA 07 00 00 00 C7 44 24 58 FF FF FF FF BE FF FF FF FF C7 44 24 54 FF FF FF FF C7 44 24 50 FF FF FF FF C7 04 24 FE 7F 00 00 0F 85 F2 FE FF FF 8D 74 26 00 8B 4C 24 04 85 C9 0F 85 06 02 00 00 8D 74 26 00 8B 4C 24 58 89 CF F7 C7 04 00 00 00 0F 85 36 FF FF FF 0F B7 04 24 89 DE 8B 7C 24 54 81 E6 FF 7F 00 00 8B 54 24 50 66 25 FF 7F 66 89 44 24 04 89 F8 C1 E0 1D C1 EA 03 09 C2 89 C8 C1 EF 03 C1 E0 1D 09 F8 8B 7C 24 5C C1 E9 03 89 54 24 50 89 44 24 54 89 FB C1 E3 1D 09 CB 83 FE 01 0F 8E FE 00 00 00 8B 0C 24 85 C9 0F 84 13 01 00 00 0D 00 00 00 80 89 54 24 20 0F B7 54 24 04 89 44 24 24 0F B7 44 24 28 66 81 E2 FF 7F 66 25 00 80 09 D0 0F B6 54 24 0B 66 89 44 24 28 66 C1 E8 08 83 E0 7F C1 E2 07 09 D0 F7 C5 01 00 00 00 88 44 24 29 DB 6C 24 20 74 07 D9 EE D8 F0 DD D8 9B F7 C5 08 00 00 00 74 0F D9 74 24 60 66 83 4C 24 64 08 D9 64 24 60 9B F7 C5 10 00 00 00 74 0F D9 74 24 60 66 83 4C 24 64 10 D9 64 24 60 9B 83 E5 20 74 0F D9 74 24 60 66 83 4C 24 64 20 D9 64 24 60 9B 81 C4 8C 00 00 00 5B 5E 5F 5D C3 8D B4 26 00 00 00 00 8B 54 24 04 85 D2 0F 85 8B FE FF FF 8D 74 26 00 C7 44 24 5C 00 00 00 00 BB 00 80 00 00 BD 28 00 00 00 C7 44 24 58 00 00 00 00 C7 44 24 54 00 00 00 00 C7 44 24 50 00 00 00 00 C7 04 24 FF 7F 00 00 31 D2 31 F6 E9 7A FD FF FF 8D B6 00 00 00 00 89 C1 09 D1 09 D9 C1 EF 03 09 F9 0F 84 AF 00 00 00 8B 1C 24 85 DB 0F 85 C4 01 00 00 83 CD 10 90 25 FF FF FF 7F E9 E8 FE FF FF 8D B6 00 00 00 00 89 C3 09 D3 09 CB 85 FF 0F 85 92 00 00 00 09 EB 0F 84 5A 01 00 00 89 C6 89 D3 C1 EB 11 C1 E6 0F C1 E2 0F 09 DE 09 EA BB 01 00 00 00 0F 95 C2 BD 02 00 00 00 0F B6 D2 09 D6 89 CA C1 E2 0F C1 E8 11 09 C2 C1 E9 11 89 74 24 50 89 54 24 54 89 4C 24 58 C7 44 24 5C 00 00 00 00 C7 04 24 00 00 00 00 E9 CB FC FF FF 8B 7C 24 04 85 FF 0F 85 FE FD FF FF 85 D2 0F 84 F6 FD FF FF 83 C6 08 89 74 24 50 83 FE 07 E9 F0 FC FF FF 8D B4 26 00 00 00 00 31 C0 31 D2 E9 39 FE FF FF 8D B4 26 00 00 00 00 09 EB 0F 85 18 01 00 00 0F B7 44 24 1E BB 00 80 00 00 31 ED C7 44 24 5C 00 00 00 00 C7 44 24 58 00 00 00 00 C7 44 24 54 00 00 00 00 C7 44 24 50 00 00 00 00 66 25 00 0C C7 04 24 FF 7F 00 00 E9 DD FE FF FF 66 85 C0 74 5A 66 3D 00 08 74 4C 66 3D 00 04 0F 84 1F 01 00 00 C7 44 24 5C FF FF FF FF BA FF FF FF FF BE FF 7F 00 00 C7 44 24 58 FF FF FF FF C7 44 24 54 FF FF FF FF 66 C7 44 24 04 FE 7F C7 04 24 FE 7F 00 00 83 CD 28 89 D0 8B 4C 24 58 8B 7C 24 54 E9 66 FD FF FF 8B 7C 24 04 85 FF 75 B6 C7 44 24 5C 00 00 00 00 31 D2 31 F6 C7 44 24 58 00 00 00 00 C7 44 24 54 00 00 00 00 C7 04 24 FF 7F 00 00 66 C7 44 24 04 FF 7F EB BA 90 0F B7 44 24 1E BB 01 00 00 00 31 ED C7 44 24 5C 00 00 00 00 C7 44 24 58 00 00 00 00 C7 44 24 54 00 00 00 00 C7 44 24 50 00 00 00 00 66 25 00 0C C7 04 24 00 00 00 00 E9 15 FE FF FF 8D 74 26 00 0D 00 00 00 40 E9 23 FD FF FF 8D B6 00 00 00 00 31 ED 81 FF FF 7F 00 00 74 44 89 CB 89 C6 C1 EE 11 C1 E3 0F 09 F3 89 C6 C1 E6 0F C1 EA 11 09 D6 C1 E9 11 83 E6 F8 83 C9 02 89 5C 24 54 BB 00 80 00 00 C7 44 24 5C 00 00 00 00 89 74 24 50 89 4C 24 58 C7 04 24 FF 7F 00 00 E9 23 FB FF FF 89 CD C1 ED 12 83 F5 01 EB B2 8B 74 24 04 85 F6 0F 84 D5 FE FF FF E9 1A FF FF FF 8D B4 26 00 00 00 00 89 C3 89 D1 C1 E9 12 81 4C 24 4C 00 00 08 00 C1 E3 0E 09 CB 8B 4C 24 4C C1 E8 12 C1 E2 0E 89 5C 24 40 89 CF C1 E7 0E 09 C7 C1 E9 12 09 EA 0F 95 C0 0F B6 C0 89 C6 09 DE BB 01 00 00 00 89 7C 24 44 89 7C 24 0C C7 04 24 00 00 00 00 E9 96 FA FF FF 8B 6C 24 04 85 ED 0F 84 8A FB FF FF E9 FE FC FF FF 90 90 90 90 90 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_96_0_0 {
	meta:
		name = "___bid_letd2"
		size = 96
		refs = "0043 ___bid128_quiet_less_equal"
	strings:
		$1 = { 83 EC 4C 8B 44 24 60 89 44 24 10 8B 44 24 64 89 44 24 14 8B 44 24 68 89 44 24 18 8B 44 24 6C 89 44 24 1C 8B 44 24 50 89 04 24 8B 44 24 54 89 44 24 04 8B 44 24 58 89 44 24 08 8B 44 24 5C 89 44 24 0C E8 ?? ?? ?? ?? 83 F8 01 19 C0 83 C4 4C 83 E0 02 83 E8 01 C3 90 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_97_0_0 {
	meta:
		name = "___bid32_to_bid128"
		size = 464
		refs = "0120 ___bid_IDEC_glbflags 0129 ___bid_power10_table_128"
	strings:
		$1 = { 83 EC 3C 8B 44 24 44 89 74 24 30 8B 74 24 40 89 5C 24 2C 89 7C 24 34 89 C1 89 C2 81 E1 00 00 00 60 81 E2 00 00 00 80 81 F9 00 00 00 60 89 6C 24 38 74 6D 89 C7 89 C5 C1 EF 17 81 E7 FF 00 00 00 81 E5 FF FF 7F 00 75 4E 89 C1 31 DB 81 E1 00 00 00 78 89 4C 24 08 31 C9 81 7C 24 08 00 00 00 78 0F 84 AC 00 00 00 81 C7 BB 17 00 00 C1 E7 11 09 D7 89 0E 89 5E 04 C7 46 08 00 00 00 00 89 7E 0C 89 F0 8B 5C 24 2C 8B 74 24 30 8B 7C 24 34 8B 6C 24 38 83 C4 3C C3 89 E9 31 DB EB CA 8D 74 26 00 89 C1 81 E1 00 00 00 78 81 F9 00 00 00 78 74 28 89 C7 31 C9 81 E7 FF FF 1F 00 31 DB 81 CF 00 00 80 00 81 FF 7F 96 98 00 76 08 C1 E8 15 0F B6 F8 EB 94 89 F9 31 DB EB F2 89 C1 89 C5 81 E1 FF FF 0F 00 89 C2 81 E2 00 00 00 FE 81 E5 FF FF 0F FE 81 F9 3F 42 0F 00 89 C1 0F 47 EA 81 E1 00 00 00 7C 89 C2 81 E2 00 00 00 F8 81 F9 00 00 00 78 0F 44 EA 25 00 00 00 7E 3D 00 00 00 7E 75 07 83 0D ?? ?? ?? ?? 01 89 EF 8B 0D ?? ?? ?? ?? 81 E7 FF FF 0F 00 89 F8 F7 25 ?? ?? ?? ?? 89 4C 24 24 89 44 24 10 89 F8 89 54 24 14 F7 25 ?? ?? ?? ?? 89 44 24 18 89 D0 8B 4C 24 18 89 54 24 1C 31 D2 89 44 24 08 89 F8 89 54 24 0C F7 25 ?? ?? ?? ?? 01 44 24 08 8B 44 24 08 11 54 24 0C 31 DB 89 C2 31 C0 01 C8 89 06 8B 44 24 24 11 DA 8B 5C 24 14 89 56 04 F7 E7 8B 54 24 0C 89 D9 01 C1 89 D0 89 CB 31 C9 31 D2 01 C1 8B 44 24 10 11 D3 31 D2 01 C1 89 E8 11 D3 25 00 00 00 FC 09 D8 89 4E 08 89 46 0C E9 BA FE FF FF 8D 76 00 8D BC 27 00 00 00 00 }
	condition:
		$1
}

rule file_97_1_0 {
	meta:
		name = "___bid128_to_bid32"
		size = 6032
		refs = "0075 ___bid_power10_table_128 01bf .rdata 01f2 ___bid_estimate_decimal_digits 020e ___bid_power10_index_binexp_128 0247 ___bid_IDEC_glbround 02b9 ___bid_round_const_table_128 0319 ___bid_reciprocals10_128 062d ___bid_recip_scale 0896 ___bid_IDEC_glbflags 11a2 ___bid_round_const_table 11c0 ___bid_reciprocals10_64 1234 ___bid_short_recip_scale"
	strings:
		$1 = { 55 57 56 53 81 EC DC 00 00 00 8B 84 24 F0 00 00 00 8B 9C 24 FC 00 00 00 8B 94 24 F8 00 00 00 89 84 24 C0 00 00 00 8B 84 24 F4 00 00 00 8B B4 24 C0 00 00 00 89 84 24 C4 00 00 00 8B BC 24 C4 00 00 00 89 D8 25 00 00 00 78 89 74 24 10 89 7C 24 14 89 DF 81 E7 00 00 00 80 3D FF FF FF 5F 89 7C 24 38 0F 86 88 00 00 00 3D 00 00 00 78 0F 85 81 08 00 00 8B 35 ?? ?? ?? ?? 89 D9 8B 2D ?? ?? ?? ?? 81 E1 FF 3F 00 00 8B 3D ?? ?? ?? ?? 39 CE 89 6C 24 18 8B 2D ?? ?? ?? ?? 0F 83 C9 0B 00 00 89 DE 31 FF 81 E6 00 00 00 FE 89 74 24 1C 31 F6 C7 44 24 18 00 00 00 00 89 D9 31 D2 81 E1 00 00 00 7C 81 F9 00 00 00 78 0F 85 46 08 00 00 89 DD 31 F6 81 E5 00 00 00 F8 31 FF C7 44 24 18 00 00 00 00 89 6C 24 1C E9 29 08 00 00 8D B6 00 00 00 00 A1 ?? ?? ?? ?? 89 DF 89 D6 81 E7 FF FF 01 00 8B 2D ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 39 C7 76 3B 89 DA C1 EA 11 81 E2 FF 3F 00 00 31 C0 81 EA BB 17 00 00 78 13 89 D1 B8 00 00 80 5F C1 E1 17 81 FA BF 00 00 00 0F 4E C1 0B 44 24 38 81 C4 DC 00 00 00 5B 5E 5F 5D C3 8D 74 26 00 0F 83 4A 0B 00 00 31 F8 31 F2 09 D0 0F 84 1E 0C 00 00 8B 44 24 10 C1 EB 11 8B 4C 24 14 81 E3 FF 3F 00 00 89 DA 09 F0 09 F9 09 C1 74 A3 89 FD 09 F5 75 0B 83 7C 24 14 00 0F 86 22 0B 00 00 89 B4 24 B0 00 00 00 85 FF 89 BC 24 B4 00 00 00 DF AC 24 B0 00 00 00 0F 88 9C 0F 00 00 D9 9C 24 BC 00 00 00 8B 44 24 14 D9 84 24 BC 00 00 00 D9 05 ?? ?? ?? ?? DC C9 85 C0 DF 6C 24 10 0F 88 6F 0F 00 00 DD D9 D9 5C 24 18 D8 44 24 18 D9 5C 24 18 8B 4C 24 18 C1 E9 17 81 E1 FF 00 00 00 83 E9 7F 8B 04 8D ?? ?? ?? ?? 89 CA C1 E2 04 89 D5 89 FA 89 44 24 20 83 E8 07 89 44 24 30 89 F0 2B 85 ?? ?? ?? ?? 1B 95 ?? ?? ?? ?? 89 44 24 18 83 FA 00 89 54 24 1C 0F 8E CE 0E 00 00 8B 6C 24 20 83 ED 06 89 6C 24 30 8B 6C 24 30 8B 44 24 38 01 DD 89 AC 24 80 00 00 00 8B 2D ?? ?? ?? ?? 85 C0 89 6C 24 40 89 6C 24 58 74 19 89 E8 83 E8 01 83 F8 01 77 0F C7 44 24 58 03 00 00 00 29 6C 24 58 8D 76 00 81 BC 24 80 00 00 00 BA 17 00 00 0F 8E B2 09 00 00 8B 9C 24 80 00 00 00 C7 84 24 B8 00 00 00 00 00 00 00 81 EB BB 17 00 00 89 5C 24 0C 8B 6C 24 58 8B 5C 24 30 8B 4C 24 10 8D 44 ED 00 8D 2C 83 8B 5C 24 14 C1 E5 04 8B 85 ?? ?? ?? ?? 8B 95 ?? ?? ?? ?? 01 C1 11 D3 89 5C 24 14 03 B5 ?? ?? ?? ?? 13 BD ?? ?? ?? ?? 31 DB 39 54 24 14 89 4C 24 10 B9 01 00 00 00 72 10 0F 87 02 0C 00 00 39 44 24 10 0F 83 F8 0B 00 00 89 F0 89 FA 8B 74 24 14 01 C8 8B 7C 24 10 11 DA 89 54 24 1C 8B 54 24 30 89 44 24 18 C1 E2 04 8D 82 ?? ?? ?? ?? 8B 92 ?? ?? ?? ?? 8B 58 08 8B 48 04 8B 40 0C 89 94 24 A8 00 00 00 89 5C 24 20 89 4C 24 68 89 44 24 60 89 D8 F7 E6 89 84 24 88 00 00 00 8B 44 24 60 89 94 24 8C 00 00 00 F7 E6 89 84 24 A0 00 00 00 89 D8 89 94 24 A4 00 00 00 F7 E7 89 94 24 94 00 00 00 8B 9C 24 94 00 00 00 31 D2 89 84 24 90 00 00 00 8B 84 24 88 00 00 00 89 D9 31 DB 89 4C 24 28 01 44 24 28 8B 44 24 60 89 5C 24 2C 11 54 24 2C F7 E7 01 44 24 28 11 54 24 2C 8B 54 24 18 8B 44 24 68 8B 6C 24 1C 89 54 24 08 F7 E2 89 84 24 98 00 00 00 8B 44 24 08 89 94 24 9C 00 00 00 F7 A4 24 A8 00 00 00 89 54 24 14 8B 5C 24 14 31 D2 89 44 24 10 8B 84 24 98 00 00 00 89 D9 31 DB 89 4C 24 48 01 44 24 48 8B 84 24 A8 00 00 00 89 5C 24 4C 11 54 24 4C F7 E5 01 44 24 48 8B 4C 24 48 11 54 24 4C 31 D2 8B 44 24 10 89 CB 31 C9 89 4C 24 50 01 44 24 50 89 5C 24 54 11 54 24 54 8B 84 24 A8 00 00 00 F7 E6 89 44 24 18 8B 44 24 68 89 54 24 1C 8B 4C 24 1C F7 E6 89 44 24 78 8B 84 24 A8 00 00 00 89 54 24 7C F7 E7 89 54 24 14 8B 74 24 14 31 D2 89 44 24 10 8B 44 24 18 89 F3 31 F6 01 C3 8B 44 24 68 11 D6 F7 E7 01 C3 8B 44 24 78 11 D6 89 CA 89 54 24 18 31 C9 8B 54 24 7C 01 44 24 18 8B 44 24 10 89 4C 24 1C 11 54 24 1C 31 D2 01 74 24 18 11 54 24 1C 31 D2 89 54 24 78 31 D2 01 44 24 78 89 5C 24 7C 11 54 24 7C 8B 44 24 20 F7 E5 89 44 24 10 8B 44 24 60 89 54 24 14 8B 4C 24 14 F7 E5 89 84 24 A8 00 00 00 8B 44 24 20 89 94 24 AC 00 00 00 8B 9C 24 AC 00 00 00 F7 64 24 08 89 54 24 24 8B 7C 24 24 31 D2 89 44 24 20 8B 44 24 10 89 FE 31 FF 01 C6 8B 44 24 60 11 D7 F7 64 24 08 01 C6 8B 44 24 20 11 D7 89 CA 31 C9 89 4C 24 14 8B 8C 24 A8 00 00 00 89 54 24 10 01 4C 24 10 11 5C 24 14 31 D2 01 7C 24 10 11 54 24 14 31 C9 31 D2 89 4C 24 60 89 74 24 64 01 44 24 60 8B BC 24 8C 00 00 00 8B 44 24 68 11 54 24 64 8B 8C 24 90 00 00 00 89 FE 31 FF 03 B4 24 A0 00 00 00 13 BC 24 A4 00 00 00 F7 E5 01 C6 11 D7 8B 54 24 2C 89 D0 31 D2 01 C6 11 D7 8B 94 24 9C 00 00 00 89 D0 31 D2 01 C6 11 D7 8B 54 24 4C 89 D0 31 D2 01 C6 8B 44 24 28 11 D7 31 DB 89 C2 31 C0 01 C8 11 DA 03 44 24 50 13 54 24 54 39 54 24 54 72 11 0F 87 E0 07 00 00 39 44 24 50 0F 87 D6 07 00 00 90 8B 4C 24 18 8B 5C 24 1C 01 C1 11 D3 39 5C 24 1C 89 4C 24 20 89 5C 24 24 72 16 0F 87 C0 07 00 00 39 4C 24 18 0F 87 B6 07 00 00 8D B6 00 00 00 00 8B 44 24 60 8B 54 24 64 01 F0 11 FA 39 D7 89 44 24 60 89 54 24 64 72 0E 0F 87 A2 07 00 00 39 C6 0F 87 9A 07 00 00 8B 5C 24 30 8B 2C 9D ?? ?? ?? ?? 83 FD 3F 0F 8E A4 07 00 00 8B 7C 24 14 8D 4D C0 31 C0 8B 74 24 10 0F AD FE D3 EF 83 E1 20 0F 45 F7 0F 45 F8 8B 44 24 40 85 C0 0F 84 D6 07 00 00 BB 80 00 00 00 29 EB 83 FB 3F 0F 8E B6 08 00 00 8B 44 24 60 B9 40 00 00 00 8B 54 24 64 29 E9 0F A5 C2 D3 E0 F6 C1 20 74 04 89 C2 31 C0 89 44 24 70 89 54 24 74 83 7C 24 58 01 C7 44 24 10 00 00 00 00 C7 44 24 14 00 00 00 00 0F 84 E8 08 00 00 0F 82 69 09 00 00 83 7C 24 58 03 0F 84 D7 08 00 00 83 7C 24 58 04 0F 84 53 09 00 00 8B 44 24 30 C7 44 24 28 01 00 00 00 C7 44 24 2C 00 00 00 00 C1 E0 04 8B 90 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 03 44 24 78 13 54 24 7C 39 54 24 7C 77 16 0F 83 81 0D 00 00 C7 44 24 28 00 00 00 00 C7 44 24 2C 00 00 00 00 8B 44 24 20 03 44 24 28 8B 54 24 24 13 54 24 2C 89 44 24 20 8B 44 24 30 89 54 24 24 C1 E0 04 8B 90 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 03 44 24 20 13 54 24 24 39 54 24 24 0F 87 A9 0B 00 00 0F 83 99 0B 00 00 8B 4C 24 24 31 D2 B8 01 00 00 00 39 4C 24 2C 0F 86 39 0D 00 00 89 44 24 20 89 54 24 24 83 FB 3F 0F 8F C4 0B 00 00 8B 44 24 70 8D 4D C0 8B 54 24 74 0F A5 C2 D3 E0 F6 C1 20 74 04 89 C2 31 C0 89 44 24 30 8B 44 24 10 89 D9 89 54 24 34 8B 54 24 14 0F AD D0 D3 EA F6 C1 20 74 04 89 D0 31 D2 8B 4C 24 30 09 C1 8B 44 24 70 89 4C 24 10 8B 4C 24 34 09 D1 8B 54 24 74 89 4C 24 14 89 D9 31 DB 0F AD D0 D3 EA F6 C1 20 0F 45 C2 0F 45 D3 89 44 24 70 89 54 24 74 83 FD 3F 0F 8F 1B 0B 00 00 B9 40 00 00 00 31 D2 29 E9 B8 01 00 00 00 0F AD D0 31 DB D3 EA F6 C1 20 0F 45 C2 89 E9 0F 45 D3 89 44 24 28 31 C0 89 54 24 2C 31 D2 F6 C1 20 0F 94 C0 0F 95 C2 D3 E2 D3 E0 89 44 24 18 89 54 24 1C 8B 4C 24 10 8B 5C 24 14 03 4C 24 20 13 5C 24 24 3B 5C 24 24 77 10 0F 83 43 0C 00 00 83 44 24 70 01 83 54 24 74 00 8B 54 24 74 39 54 24 2C 72 34 0F 86 54 0C 00 00 8B 54 24 2C 8B 44 24 28 33 54 24 74 33 44 24 70 09 C2 0F 84 5D 0C 00 00 83 BC 24 B8 00 00 00 01 19 C0 83 E0 F0 83 C0 30 09 05 ?? ?? ?? ?? 83 FF 00 77 0C 81 FE 7F 96 98 00 0F 86 2F 04 00 00 8B 9C 24 80 00 00 00 31 FF BE 40 42 0F 00 81 EB BA 17 00 00 89 5C 24 0C 81 7C 24 0C BF 00 00 00 0F 87 17 04 00 00 83 FF 00 0F 87 26 06 00 00 81 FE FF FF 7F 00 0F 87 1A 06 00 00 8B 44 24 0C C1 E0 17 09 F0 E9 49 F8 FF FF 89 DA 31 F6 C1 EA 0F 31 FF 81 E2 FF 3F 00 00 C7 44 24 18 00 00 00 00 C7 44 24 1C 00 00 00 00 3D 00 00 00 78 0F 85 02 F8 FF FF A1 ?? ?? ?? ?? 89 F9 89 74 24 38 8B 6C 24 18 F7 E7 89 44 24 60 89 F0 89 54 24 64 F7 25 ?? ?? ?? ?? 89 54 24 6C 8B 7C 24 6C 31 D2 89 44 24 68 8B 44 24 60 89 FE 31 FF 89 74 24 40 8B 74 24 1C 01 44 24 40 8B 44 24 38 89 7C 24 44 11 54 24 44 F7 25 ?? ?? ?? ?? 01 44 24 40 A1 ?? ?? ?? ?? 11 54 24 44 81 E6 FF 3F 00 00 31 FF 89 74 24 5C F7 E5 89 44 24 70 A1 ?? ?? ?? ?? 89 54 24 74 8B 74 24 70 F7 E5 89 44 24 20 8B 44 24 5C 89 54 24 24 F7 25 ?? ?? ?? ?? 89 44 24 28 89 54 24 2C 8B 54 24 24 01 74 24 28 11 7C 24 2C 89 D0 31 D2 01 44 24 28 8B 74 24 28 11 54 24 2C 31 D2 8B 44 24 20 89 F7 31 F6 89 74 24 48 01 44 24 48 A1 ?? ?? ?? ?? 89 7C 24 4C 11 54 24 4C 31 FF F7 E1 89 44 24 20 A1 ?? ?? ?? ?? 89 54 24 24 8B 74 24 20 F7 E1 89 84 24 80 00 00 00 8B 44 24 38 89 94 24 84 00 00 00 F7 25 ?? ?? ?? ?? 89 D0 31 D2 89 44 24 10 01 74 24 10 89 54 24 14 11 7C 24 14 8B 7C 24 24 8B 44 24 38 89 FE 31 FF 89 74 24 20 8B B4 24 80 00 00 00 01 74 24 20 89 7C 24 24 8B BC 24 84 00 00 00 11 7C 24 24 F7 25 ?? ?? ?? ?? 01 44 24 10 11 54 24 14 8B 7C 24 14 8B 44 24 5C 89 FE 31 FF 01 74 24 20 11 7C 24 24 F7 25 ?? ?? ?? ?? 89 44 24 10 8B 44 24 5C 89 54 24 14 F7 25 ?? ?? ?? ?? 89 84 24 80 00 00 00 A1 ?? ?? ?? ?? 89 94 24 84 00 00 00 F7 E5 89 44 24 30 A1 ?? ?? ?? ?? 89 54 24 34 8B 54 24 10 8B 7C 24 34 C7 44 24 3C 00 00 00 00 89 54 24 38 F7 E5 89 FE 31 FF 01 C6 11 D7 8B 54 24 14 03 74 24 38 13 7C 24 3C 89 D0 31 D2 89 44 24 10 8B 84 24 80 00 00 00 01 44 24 10 89 54 24 14 8B 94 24 84 00 00 00 11 54 24 14 31 D2 01 7C 24 10 11 54 24 14 31 C0 31 D2 8B 7C 24 64 89 44 24 38 8B 44 24 30 01 44 24 38 8B 44 24 5C 89 74 24 3C 89 FE 11 54 24 3C 31 FF F7 25 ?? ?? ?? ?? 01 C6 A1 ?? ?? ?? ?? 11 D7 F7 E1 8B 4C 24 68 01 C6 11 D7 8B 54 24 74 89 D0 31 D2 01 C6 11 D7 8B 54 24 44 89 D0 31 D2 01 C6 11 D7 8B 54 24 2C 89 D0 31 D2 01 C6 8B 44 24 40 11 D7 89 4C 24 30 C7 44 24 34 00 00 00 00 89 C2 31 C0 03 44 24 30 13 54 24 34 03 44 24 48 13 54 24 4C 39 54 24 4C 72 0C 0F 86 8A 08 00 00 83 C6 01 83 D7 00 03 44 24 20 13 54 24 24 39 54 24 24 0F 82 A1 05 00 00 0F 86 91 05 00 00 89 F0 89 FA 83 C0 01 83 D2 00 8B 74 24 38 8B 7C 24 3C 01 C6 11 D7 39 FA 72 10 0F 86 3F 08 00 00 83 44 24 10 01 83 54 24 14 00 8B 0D ?? ?? ?? ?? 8B 7C 24 14 8B 74 24 10 8B 44 24 1C 83 E9 40 0F AD FE D3 EF F6 C1 20 0F 45 F7 25 00 00 00 FC 81 E3 00 00 00 7E 09 F0 81 FB 00 00 00 7E 0F 85 1A F5 FF FF 83 0D ?? ?? ?? ?? 01 E9 0E F5 FF FF 81 FB 97 17 00 00 0F 8F 71 04 00 00 8B 9C 24 80 00 00 00 C7 44 24 58 03 00 00 00 C7 84 24 B8 00 00 00 01 00 00 00 81 EB BB 17 00 00 89 5C 24 0C E9 35 F6 FF FF 77 08 39 D7 0F 82 2D F4 FF FF 31 F1 31 D7 09 F9 0F 84 A4 08 00 00 89 DF 8B 74 24 10 81 E7 FF 3F 00 FE 89 7C 24 1C 8B 7C 24 14 89 54 24 18 E9 1C F4 FF FF 90 8D 74 26 00 39 D6 0F 87 6D F4 FF FF E9 A9 F4 FF FF 8D 76 00 81 7C 24 10 7F 96 98 00 0F 87 D0 F4 FF FF 8B 35 ?? ?? ?? ?? 81 EB BB 17 00 00 8B 7C 24 14 89 5C 24 0C 89 74 24 40 8B 74 24 10 81 7C 24 0C BF 00 00 00 0F 86 E9 FB FF FF 8B 6C 24 0C 85 ED 0F 88 74 04 00 00 83 FF 00 77 3D 81 FE 3F 42 0F 00 77 35 8B 6C 24 0C 89 F0 89 FA 0F A4 F2 03 0F A4 F7 01 01 F6 C1 E0 03 01 C6 11 D7 83 ED 01 83 FF 00 0F 86 DF 07 00 00 81 FD BF 00 00 00 89 6C 24 0C 0F 86 9B FB FF FF 8B 44 24 38 83 0D ?? ?? ?? ?? 28 0D 00 00 00 78 83 7C 24 40 02 0F 84 EF 08 00 00 83 7C 24 40 03 0F 84 77 07 00 00 83 7C 24 40 01 0F 85 DA F3 FF FF 8B 54 24 38 85 D2 BA 7F 96 F8 77 0F 44 C2 E9 C7 F3 FF FF 8D B6 00 00 00 00 3B 4C 24 14 0F 82 8B F3 FF FF 0F 87 D2 F3 FF FF 3B 6C 24 10 0F 86 7B F3 FF FF 8D B6 00 00 00 00 E9 BD F3 FF FF 83 C6 01 83 D7 00 E9 20 F8 FF FF 83 C6 01 83 D7 00 E9 45 F8 FF FF 90 8D 74 26 00 8B 5C 24 30 83 44 24 10 01 83 54 24 14 00 8B 2C 9D ?? ?? ?? ?? 83 FD 3F 0F 8F 5C F8 FF FF 8B 44 24 10 B9 40 00 00 00 31 DB 8B 54 24 14 29 E9 8B 74 24 64 0F A5 C2 D3 E0 F6 C1 20 0F 45 D0 0F 45 C3 8B 5C 24 60 89 E9 31 FF 0F AD F3 D3 EE F6 C1 20 0F 45 DE 0F 45 F7 89 74 24 2C 8B 7C 24 2C 89 5C 24 28 8B 74 24 28 09 D7 09 C6 8B 44 24 40 85 C0 0F 85 2A F8 FF FF 89 F1 BB 80 00 00 00 83 E1 01 29 EB 85 C9 0F 84 1D F8 FF FF 83 FB 3F 0F 8E 2C 05 00 00 8B 44 24 60 B9 40 00 00 00 8B 54 24 64 29 E9 0F A5 C2 D3 E0 F6 C1 20 74 04 89 C2 31 C0 89 54 24 74 09 C2 89 44 24 70 0F 85 15 F8 FF FF 8B 4C 24 30 C1 E1 04 8B 91 ?? ?? ?? ?? 8B 89 ?? ?? ?? ?? 39 4C 24 24 72 45 77 06 39 54 24 20 72 3D 8B 44 24 24 31 C8 8B 4C 24 20 31 D1 09 C1 0F 85 B2 F7 FF FF 8B 4C 24 30 8B 44 24 7C C1 E1 04 3B 81 ?? ?? ?? ?? 0F 87 9B F7 FF FF 72 10 8B 54 24 78 3B 91 ?? ?? ?? ?? 0F 83 89 F7 FF FF 83 C6 FF 83 D7 FF E9 7E F7 FF FF 8D B6 00 00 00 00 31 C9 31 DB E9 FF F3 FF FF 8D B4 26 00 00 00 00 8B 5C 24 0C 89 F7 8B 44 24 38 81 E7 FF FF 1F 00 81 C4 DC 00 00 00 C1 E3 15 0D 00 00 00 60 09 D8 09 F8 5B 5E 5F 5D C3 8B 54 24 64 8D 4D C0 8B 44 24 60 0F AD D0 D3 EA F6 C1 20 74 04 89 D0 31 D2 89 44 24 28 89 54 24 2C 8B 44 24 10 89 D9 8B 54 24 14 0F A5 C2 D3 E0 F6 C1 20 74 04 89 C2 31 C0 0B 44 24 28 0B 54 24 2C 89 44 24 70 8B 44 24 60 89 54 24 74 8B 54 24 64 0F A5 C2 D3 E0 F6 C1 20 74 04 89 C2 31 C0 83 7C 24 58 01 89 44 24 10 89 54 24 14 0F 85 18 F7 FF FF 8B 6C 24 74 0B 6C 24 70 0F 85 DD F8 FF FF 8B 44 24 14 0B 44 24 10 0F 85 CF F8 FF FF 8B 54 24 30 C1 E2 04 8B 82 ?? ?? ?? ?? 8B 92 ?? ?? ?? ?? 39 54 24 24 0F 82 C8 F8 FF FF 77 0A 39 44 24 20 0F 82 BC F8 FF FF 33 54 24 24 33 44 24 20 09 C2 0F 85 96 F8 FF FF 8B 44 24 30 8B 54 24 7C C1 E0 04 3B 90 ?? ?? ?? ?? 0F }
	condition:
		$1
}

rule file_98_0_0 {
	meta:
		name = "___trunctfdf2"
		size = 1632
	strings:
		$1 = { 55 57 56 53 83 EC 7C 8B 8C 24 9C 00 00 00 8B 9C 24 98 00 00 00 8B 94 24 94 00 00 00 8B 84 24 90 00 00 00 0F B7 F9 89 CD 89 4C 24 3C C1 E9 18 C0 E9 07 88 4C 24 13 0F B6 C9 89 4C 24 14 89 D9 C1 E9 1D C1 E7 03 09 CF 89 D1 C1 E9 1D 89 5C 24 38 C1 E3 03 09 D9 89 C3 C1 ED 10 81 E5 FF 7F 00 00 C1 EB 1D 89 54 24 34 C1 E2 03 09 D3 8D 55 01 81 E2 FF 7F 00 00 D9 7C 24 2E 89 44 24 30 C1 E0 03 83 FA 01 89 7C 24 4C 89 4C 24 48 89 5C 24 44 89 44 24 40 0F 8E 67 02 00 00 8D 95 00 C4 FF FF 81 FA FE 07 00 00 89 54 24 08 0F 8F 51 01 00 00 8B 54 24 08 85 D2 0F 8E 39 03 00 00 89 CE 89 FA C1 EE 1C C1 E2 04 09 F2 89 CE 89 D9 C1 E6 04 C1 E9 1C C1 E3 04 09 CE 09 C3 0F 95 C0 81 ED FF 3B 00 00 0F B6 C0 09 C6 89 F3 83 E3 07 31 C0 85 DB 74 05 B8 20 00 00 00 0F B7 4C 24 2E 66 81 E1 00 0C 66 81 F9 00 04 0F 84 68 01 00 00 66 81 F9 00 08 0F 84 4B 02 00 00 66 85 C9 75 10 89 F3 83 E3 0F 83 FB 04 74 06 83 C6 04 83 D2 00 F7 C2 00 00 80 00 0F 85 69 01 00 00 89 D1 89 EB C1 EE 03 81 E3 FF 07 00 00 C1 E1 1D 09 F1 0F B7 74 24 08 C1 EA 03 66 81 E6 FF 07 83 FB 01 0F 8E 7D 01 00 00 89 D3 81 E3 FF FF 0F 00 C7 44 24 0C 00 00 00 00 8B 54 24 0C 81 E3 FF FF 0F 00 89 4C 24 08 0F B6 4C 24 13 81 E6 FF 07 00 00 C1 E6 14 81 E2 00 00 F0 FF 09 DA 81 E2 FF FF 0F 80 09 F2 C1 E1 1F 81 E2 FF FF FF 7F 09 CA A8 01 89 54 24 0C DD 44 24 08 74 07 D9 EE D8 F0 DD D8 9B A8 08 74 0F D9 74 24 50 66 83 4C 24 54 08 D9 64 24 50 9B A8 10 74 0F D9 74 24 50 66 83 4C 24 54 10 D9 64 24 50 9B A8 20 74 0F D9 74 24 50 66 83 4C 24 54 20 D9 64 24 50 9B 83 C4 7C 5B 5E 5F 5D C3 8D B6 00 00 00 00 0F B7 4C 24 2E 66 81 E1 00 0C 74 44 66 81 F9 00 08 74 31 66 81 F9 00 04 0F 84 72 03 00 00 BD FF 07 00 00 B8 28 00 00 00 BB 07 00 00 00 BA FF FF FF FF BE FF FF FF FF C7 44 24 08 FE 07 00 00 E9 BC FE FF FF 8B 74 24 14 85 F6 0F 85 F0 00 00 00 BD 00 08 00 00 B8 28 00 00 00 C7 44 24 08 FF 07 00 00 31 DB 31 D2 31 F6 66 81 F9 00 04 0F 85 98 FE FF FF 8B 7C 24 14 85 FF 0F 84 AC FE FF FF 85 DB 0F 84 A4 FE FF FF 83 C6 08 83 D2 00 F7 C2 00 00 80 00 0F 84 9E FE FF FF 8D B4 26 00 00 00 00 81 FD FF 07 00 00 0F 84 04 01 00 00 81 E2 FF FF 7F FF 89 D1 C1 EE 03 C1 E1 1D 8D 5D 01 09 F1 81 E3 FF 07 00 00 89 EE C1 EA 03 66 81 E6 FF 07 83 FB 01 89 6C 24 08 0F 8F 83 FE FF FF 89 D7 31 DB 09 CF 0F 84 7F FE FF FF 8B 5C 24 08 85 DB 0F 85 EF 01 00 00 83 C8 10 E9 63 FE FF FF 8D 74 26 00 85 ED 75 7C 09 D9 0B 4C 24 4C 09 C1 0F B7 4C 24 2E 0F 84 DF 01 00 00 66 81 E1 00 0C 66 BD 01 00 B8 22 00 00 00 BB 01 00 00 00 31 D2 BE 01 00 00 00 C7 44 24 08 00 00 00 00 E9 C2 FD FF FF 66 90 BD FF 07 00 00 B8 28 00 00 00 BB 07 00 00 00 BA FF FF FF FF BE FF FF FF FF C7 44 24 08 FE 07 00 00 8B 7C 24 14 85 FF 0F 85 BE FD FF FF 85 DB 0F 84 B6 FD FF FF E9 0D FF FF FF 8D B6 00 00 00 00 89 CA 09 DA 09 FA 09 C2 0F 85 82 01 00 00 0F B7 4C 24 2E BD 00 08 00 00 31 C0 C7 44 24 08 FF 07 00 00 66 81 E1 00 0C E9 B6 FE FF FF 8D 74 26 00 66 85 C9 0F 84 1A 01 00 00 66 81 F9 00 08 0F 84 03 01 00 00 66 81 F9 00 04 0F 84 A9 01 00 00 BE FE 07 00 00 BB FF 07 00 00 B9 FF FF FF FF BA FF FF FF 1F BD FE 07 00 00 83 C8 28 89 6C 24 08 E9 62 FD FF FF 83 7C 24 08 CC 0F 8C 51 01 00 00 89 FE BF 3D 3C 00 00 29 EF 81 CE 00 00 08 00 8D 57 1F 85 FF 89 F9 0F 49 D7 C1 F9 1F C1 E9 1B 01 CF 83 E7 1F C1 FA 05 29 CF 85 D2 89 74 24 4C 0F 8E 09 02 00 00 31 ED 8D 4C 24 44 09 C5 8D 5C 94 40 39 D9 74 0B 8B 01 83 C1 04 09 C5 39 D9 75 F5 89 D0 85 FF 0F 85 67 01 00 00 B8 03 00 00 00 89 C1 29 D1 0F 88 ED 01 00 00 8D 44 24 40 8D 5C 8C 44 8B 0C 90 89 08 83 C0 04 39 D8 75 F4 B8 04 00 00 00 29 D0 83 F8 03 8D 54 24 40 7F 13 8D 74 26 00 C7 04 82 00 00 00 00 83 C0 01 83 F8 03 7E F1 8B 74 24 40 31 C0 85 ED 0F 95 C0 8B 54 24 44 BD 01 00 00 00 C7 44 24 08 00 00 00 00 09 C6 89 F3 83 E3 07 E9 24 FC FF FF 8B 7C 24 14 85 FF 0F 85 FC FE FF FF BE FF 07 00 00 31 DB 31 C9 31 D2 E9 05 FF FF FF 89 D3 81 CB 00 00 08 00 81 E3 FF FF 0F 00 E9 71 FC FF FF 66 81 E1 00 0C BD 01 00 00 00 C7 44 24 08 00 00 00 00 31 C0 E9 53 FD FF FF 90 31 C0 81 FD FF 7F 00 00 74 54 89 CE 89 CA C1 EB 1C BD 00 08 00 00 C1 E6 04 C1 EA 1C 09 DE C1 E7 04 83 E6 F8 09 FA 31 DB 81 CA 00 00 40 00 C7 44 24 08 FF 07 00 00 E9 AB FB FF FF 90 8D 74 26 00 BD 01 00 00 00 BB 01 00 00 00 31 D2 BE 01 00 00 00 C7 44 24 08 00 00 00 00 E9 7D FB FF FF 89 F8 C1 E8 12 83 F0 01 EB A2 8B 74 24 14 85 F6 0F 84 4B FE FF FF E9 4A FF FF FF 8D B4 26 00 00 00 00 8B 5C 24 14 85 DB 0F 85 B4 FC FF FF BD FF 07 00 00 B8 28 00 00 00 BA FF FF FF FF BE FF FF FF FF C7 44 24 08 FE 07 00 00 E9 6E FB FF FF 8D 76 00 C7 44 24 08 20 00 00 00 8B 44 84 40 29 7C 24 08 0F B6 4C 24 08 C7 44 24 18 03 00 00 00 29 54 24 18 D3 E0 09 C5 8B 44 24 18 85 C0 7E 59 8B 5C 24 18 8D 44 24 40 89 6C 24 1C 8D 0C 98 89 CD 66 90 8B 5C 90 04 0F B6 4C 24 08 8B 34 90 D3 E3 89 F9 D3 EE 09 F3 89 18 83 C0 04 39 E8 75 E3 8B 6C 24 1C B8 04 00 00 00 8B 74 24 4C 29 D0 8B 5C 24 18 89 F9 D3 EE 89 74 9C 40 E9 46 FE FF FF 31 ED 31 C0 E9 0B FE FF FF B8 01 00 00 00 C7 44 24 18 00 00 00 00 EB D7 30 C0 8D 54 24 40 E9 30 FE FF FF }
	condition:
		$1
}

rule file_99_0_0 {
	meta:
		name = "___lttf2"
		size = 608
	strings:
		$1 = { 83 EC 6C 8B 54 24 74 8B 44 24 70 89 7C 24 64 8B 7C 24 7C 89 5C 24 5C 8B 5C 24 78 89 54 24 18 8B 94 24 84 00 00 00 89 44 24 14 8B 84 24 80 00 00 00 89 74 24 60 8B B4 24 8C 00 00 00 89 F9 89 5C 24 1C 8B 9C 24 88 00 00 00 89 54 24 28 89 FA C1 EA 18 C0 EA 07 89 44 24 24 0F B7 C7 89 44 24 10 89 F8 89 D7 0F B7 D6 C1 E8 10 66 89 74 24 0E 25 FF 7F 00 00 89 54 24 20 89 F2 C1 EE 18 C1 EA 10 89 5C 24 2C 89 F3 81 E2 FF 7F 00 00 C0 EB 07 3D FF 7F 00 00 89 6C 24 68 89 DE 0F 84 87 00 00 00 81 FA FF 7F 00 00 0F 84 B7 00 00 00 31 DB 85 C0 75 16 8B 4C 24 18 0B 4C 24 14 0B 4C 24 1C 0B 4C 24 10 0F 94 C3 0F B6 DB 81 E7 FF 00 00 00 81 E6 FF 00 00 00 85 D2 74 1F 85 DB 0F 85 BD 00 00 00 39 F7 0F 84 CC 00 00 00 85 FF 0F 84 BA 00 00 00 B8 FF FF FF FF EB 1C 8B 4C 24 28 0B 4C 24 24 0B 4C 24 2C 0B 4C 24 20 75 CF 85 DB 0F 84 11 01 00 00 31 C0 8B 5C 24 5C 8B 74 24 60 8B 7C 24 64 8B 6C 24 68 83 C4 6C C3 8B 6C 24 18 0B 6C 24 14 0B 6C 24 1C 0B 6C 24 10 0F 84 63 FF FF FF 66 85 C9 79 4A 81 FA FF 7F 00 00 75 49 8B 54 24 28 B8 02 00 00 00 0B 54 24 24 0B 54 24 2C 0B 54 24 20 74 B2 EB 21 8B 6C 24 28 0B 6C 24 24 0B 6C 24 2C 0B 6C 24 20 0F 84 33 FF FF FF 3D FF 7F 00 00 0F 84 B8 00 00 00 66 83 7C 24 0E 00 78 07 D9 EE D8 F0 DD D8 9B B8 02 00 00 00 E9 76 FF FF FF 85 F6 B8 FF FF FF FF 0F 84 69 FF FF FF B8 01 00 00 00 E9 5F FF FF FF 39 D0 0F 8F 2C FF FF FF 8D 74 26 00 7C 16 8B 44 24 20 39 44 24 10 0F 87 18 FF FF FF 74 15 0F 83 39 FF FF FF 85 FF 8D B6 00 00 00 00 75 C8 E9 09 FF FF FF 8B 54 24 2C 39 54 24 1C 0F 87 F3 FE FF FF 75 DB 8B 5C 24 28 39 5C 24 18 0F 87 E3 FE FF FF 75 CB 8B 44 24 24 39 44 24 14 0F 87 D3 FE FF FF B8 00 00 00 00 0F 83 F3 FE FF FF EB B6 85 DB 0F 85 73 FF FF FF 85 FF B8 01 00 00 00 0F 84 DC FE FF FF E9 B4 FE FF FF 8B 44 24 18 0B 44 24 14 0B 44 24 1C 0B 44 24 10 0F 84 F8 FE FF FF E9 E6 FE FF FF 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_100_0_0 {
	meta:
		name = "___bid_addsd3"
		size = 96
		refs = "001b ___bid32_to_bid64 003b ___bid64_add 0047 ___bid64_to_bid32"
	strings:
		$1 = { 83 EC 1C 8B 44 24 20 89 5C 24 10 8B 5C 24 24 89 74 24 14 89 7C 24 18 89 04 24 E8 ?? ?? ?? ?? 89 1C 24 89 C6 89 D7 E8 ?? ?? ?? ?? 89 34 24 89 7C 24 04 89 44 24 08 89 54 24 0C E8 ?? ?? ?? ?? 89 04 24 89 54 24 04 E8 ?? ?? ?? ?? 8B 5C 24 10 8B 74 24 14 8B 7C 24 18 83 C4 1C C3 90 8D 74 26 00 }
	condition:
		$1
}

rule file_100_1_0 {
	meta:
		name = "___bid_subsd3"
		size = 96
		refs = "001b ___bid32_to_bid64 003b ___bid64_sub 0047 ___bid64_to_bid32"
	strings:
		$1 = { 83 EC 1C 8B 44 24 20 89 5C 24 10 8B 5C 24 24 89 74 24 14 89 7C 24 18 89 04 24 E8 ?? ?? ?? ?? 89 1C 24 89 C6 89 D7 E8 ?? ?? ?? ?? 89 34 24 89 7C 24 04 89 44 24 08 89 54 24 0C E8 ?? ?? ?? ?? 89 04 24 89 54 24 04 E8 ?? ?? ?? ?? 8B 5C 24 10 8B 74 24 14 8B 7C 24 18 83 C4 1C C3 90 90 90 90 90 }
	condition:
		$1
}

rule file_142_0_0 {
	meta:
		name = "___bid_divsd3"
		size = 96
		refs = "001b ___bid32_to_bid64 003b ___bid64_div 0047 ___bid64_to_bid32"
	strings:
		$1 = { 83 EC 1C 8B 44 24 20 89 5C 24 10 8B 5C 24 24 89 74 24 14 89 7C 24 18 89 04 24 E8 ?? ?? ?? ?? 89 1C 24 89 C6 89 D7 E8 ?? ?? ?? ?? 89 34 24 89 7C 24 04 89 44 24 08 89 54 24 0C E8 ?? ?? ?? ?? 89 04 24 89 54 24 04 E8 ?? ?? ?? ?? 8B 5C 24 10 8B 74 24 14 8B 7C 24 18 83 C4 1C C3 90 90 90 90 90 }
	condition:
		$1
}

rule file_121_0_0 {
	meta:
		name = "___bid_mulsd3"
		size = 96
		refs = "001b ___bid32_to_bid64 003b ___bid64_mul 0047 ___bid64_to_bid32"
	strings:
		$1 = { 83 EC 1C 8B 44 24 20 89 5C 24 10 8B 5C 24 24 89 74 24 14 89 7C 24 18 89 04 24 E8 ?? ?? ?? ?? 89 1C 24 89 C6 89 D7 E8 ?? ?? ?? ?? 89 34 24 89 7C 24 04 89 44 24 08 89 54 24 0C E8 ?? ?? ?? ?? 89 04 24 89 54 24 04 E8 ?? ?? ?? ?? 8B 5C 24 10 8B 74 24 14 8B 7C 24 18 83 C4 1C C3 90 90 90 90 90 }
	condition:
		$1
}

rule file_102_0_0 {
	meta:
		name = "___bid128_to_int32_rnint"
		size = 3616
		refs = "0115 ___bid_nr_digits 01ae ___bid_midpoint128 01fc ___bid_IDEC_glbflags 02a4 ___bid_ten2k64 04ad ___bid_midpoint64 05b9 ___bid_ten2mk128 08d6 ___bid_maskhigh128 08e4 ___bid_shiftright128 0952 ___bid_ten2mk128trunc 0b90 ___bid_ten2k128"
	strings:
		$1 = { 81 EC AC 00 00 00 8B 84 24 B0 00 00 00 89 B4 24 A0 00 00 00 8B B4 24 BC 00 00 00 89 9C 24 9C 00 00 00 89 BC 24 A4 00 00 00 89 84 24 80 00 00 00 8B 84 24 B4 00 00 00 89 F2 89 F3 8B BC 24 80 00 00 00 81 E2 00 00 00 78 81 E3 00 00 00 80 81 FA 00 00 00 78 89 84 24 84 00 00 00 8B 84 24 B8 00 00 00 89 AC 24 A8 00 00 00 8B AC 24 84 00 00 00 89 5C 24 68 0F 84 6E 01 00 00 89 F3 89 C1 81 E3 FF FF 01 00 81 FB 09 ED 01 00 76 25 31 C0 8B 9C 24 9C 00 00 00 8B B4 24 A0 00 00 00 8B BC 24 A4 00 00 00 8B AC 24 A8 00 00 00 81 C4 AC 00 00 00 C3 0F 83 59 01 00 00 89 DA 89 C8 81 F2 09 ED 01 00 35 C0 87 AD BE 09 C2 0F 84 98 01 00 00 89 F0 25 00 00 00 60 3D 00 00 00 60 74 B0 89 D8 09 C8 0F 84 3A 01 00 00 89 4C 24 78 89 5C 24 7C DF 6C 24 78 DD 5C 24 18 8B 54 24 1C 89 D0 C1 E8 14 25 FF 07 00 00 2D BE 03 00 00 83 E8 01 89 44 24 18 C1 E0 05 8B 90 ?? ?? ?? ?? 89 44 24 28 85 D2 75 46 8B 90 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 89 44 24 20 8B 44 24 28 8B 80 ?? ?? ?? ?? 39 C3 89 44 24 28 0F 87 AC 02 00 00 0F 83 08 04 00 00 8B 44 24 28 31 D8 89 44 24 28 8B 44 24 20 31 C8 0B 44 24 28 0F 84 6C 02 00 00 81 E6 00 00 FE 7F C1 EE 11 81 EE 20 18 00 00 89 74 24 18 01 D6 83 FE 0A 7F 79 0F 84 79 02 00 00 31 C0 83 FE 00 0F 8C FC FE FF FF 0F 85 F8 01 00 00 8D 42 FF 83 F8 12 0F 8E FC 02 00 00 83 EA 14 89 D0 C1 E0 04 8B B0 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 39 C3 0F 82 CC FE FF FF 77 08 39 F1 0F 82 C2 FE FF FF 31 D8 31 F1 09 C8 0F 84 E4 0B 00 00 83 7C 24 68 01 19 C0 83 E0 02 83 E8 01 E9 A6 FE FF FF 89 F0 25 00 00 00 7C 3D 00 00 00 7C 0F 84 C8 01 00 00 83 0D ?? ?? ?? ?? 01 B8 00 00 00 80 E9 83 FE FF FF 90 8D 74 26 00 3D C0 87 AD BE 0F 87 71 FE FF FF E9 97 FE FF FF 89 EA 31 C0 09 FA 0F 84 62 FE FF FF 81 FD FF FF 1F 00 0F 86 3F 02 00 00 89 EA 89 D0 31 D2 89 44 24 78 89 54 24 7C DF 6C 24 78 DD 5C 24 18 8B 54 24 1C 89 D0 C1 E8 14 25 FF 07 00 00 2D DE 03 00 00 E9 A3 FE FF FF 31 C0 81 FD 63 8E 8D 37 0F 87 1A FE FF FF 89 F2 81 E2 00 00 00 60 81 FA 00 00 00 60 0F 85 5E FE FF FF E9 01 FE FF FF 8D 76 00 83 FA 1E 0F 8F 1C 0A 00 00 8D 72 F5 B8 05 00 00 00 F7 24 F5 ?? ?? ?? ?? C7 44 24 2C 00 00 00 00 89 54 24 24 89 44 24 20 B8 05 00 00 00 F7 24 F5 ?? ?? ?? ?? 89 54 24 34 8B 54 24 24 89 44 24 30 89 D0 31 D2 89 54 24 3C 8B 54 24 20 89 44 24 38 89 54 24 28 8B 44 24 28 03 44 24 38 8B 54 24 2C 13 54 24 3C 89 44 24 20 8B 44 24 30 01 44 24 20 8B 44 24 38 89 54 24 24 8B 54 24 34 11 54 24 24 8B 54 24 3C 03 44 24 30 13 54 24 34 89 44 24 38 89 54 24 3C 8B 54 24 24 89 D0 31 D2 01 44 24 38 8B 44 24 20 11 54 24 3C 89 C2 31 C0 89 44 24 20 8B 44 24 28 89 54 24 24 8B 54 24 2C 01 44 24 20 11 54 24 24 3B 5C 24 3C 0F 87 9C FE FF FF 72 0A 3B 4C 24 38 0F 87 90 FE FF FF 8B 54 24 3C 8B 74 24 38 31 DA 31 CE 09 F2 75 16 3B 6C 24 24 72 10 0F 87 74 FE FF FF 3B 7C 24 20 0F 87 6A FE FF FF 83 7C 24 18 00 0F 8C CA 01 00 00 0F 84 2F 01 00 00 8B 44 24 68 85 C0 0F 84 EA 05 00 00 8B 4C 24 18 89 F8 F7 D8 0F AF 04 CD ?? ?? ?? ?? E9 CC FC FF FF 83 0D ?? ?? ?? ?? 01 B8 00 00 00 80 E9 BB FC FF FF 8B 44 24 18 C1 E0 05 05 ?? ?? ?? ?? 39 68 14 0F 87 7F FD FF FF 72 09 39 78 10 0F 87 74 FD FF FF 83 C2 01 E9 6C FD FF FF 90 8D 74 26 00 8B 44 24 68 85 C0 0F 84 D9 00 00 00 83 FA 0B 0F 8F 7B FE FF FF C7 44 24 20 0B 00 00 00 29 54 24 20 8B 54 24 20 8B 34 D5 ?? ?? ?? ?? 89 D0 8B 14 D5 ?? ?? ?? ?? 8B 04 C5 ?? ?? ?? ?? 0F AF F5 0F AF D7 01 F2 89 54 24 28 F7 E7 8B 74 24 28 01 F2 83 FA 05 89 44 24 20 89 54 24 24 0F 82 2F FF FF FF 0F 87 93 FD FF FF 83 7C 24 20 05 0F 86 1E FF FF FF E9 83 FD FF FF 89 7C 24 78 89 6C 24 7C DF 6C 24 78 DD 5C 24 18 8B 54 24 1C 89 D0 C1 E8 14 25 FF 07 00 00 2D FE 03 00 00 E9 6A FC FF FF 90 89 DA 09 CA 0F 85 2C FD FF FF 39 2C C5 ?? ?? ?? ?? 0F 87 D5 FB FF FF 0F 82 19 FD FF FF 39 3C C5 ?? ?? ?? ?? 0F 83 C2 FB FF FF E9 07 FD FF FF 90 8B 54 24 68 89 F8 85 D2 0F 84 B0 FB FF FF F7 D8 E9 A9 FB FF FF 83 FA 0B 0F 8F BC 04 00 00 C7 44 24 20 0B 00 00 00 29 54 24 20 8B 54 24 20 8B 34 D5 ?? ?? ?? ?? 89 D0 8B 14 D5 ?? ?? ?? ?? 8B 04 C5 ?? ?? ?? ?? 0F AF F5 0F AF D7 01 F2 89 54 24 28 F7 E7 8B 74 24 28 01 F2 83 FA 04 89 44 24 20 89 54 24 24 0F 82 56 FE FF FF 0F 87 BA FC FF FF 83 7C 24 20 FA 0F 86 45 FE FF FF 90 8D 74 26 00 E9 A5 FC FF FF 3B 4C 24 20 0F 87 94 FE FF FF 90 E9 E8 FB FF FF 8B 74 24 18 F7 DE 83 FE 13 89 74 24 6C 0F 8F 89 05 00 00 8B 74 24 18 89 F8 89 EA F7 D6 03 04 F5 ?? ?? ?? ?? 13 14 F5 ?? ?? ?? ?? 89 74 24 18 39 D5 72 0C 77 04 39 C7 76 06 83 C1 01 83 D3 00 8B 6C 24 18 89 D7 89 C6 C7 44 24 4C 00 00 00 00 C1 E5 04 8B 85 ?? ?? ?? ?? 8B 95 ?? ?? ?? ?? 89 44 24 40 89 54 24 50 F7 E7 89 44 24 28 8B 44 24 50 89 54 24 2C F7 E7 89 44 24 38 8B 44 24 40 89 54 24 3C F7 E6 89 54 24 34 8B 54 24 28 89 44 24 30 89 54 24 48 8B 54 24 34 89 D0 31 D2 89 44 24 20 8B 44 24 48 01 44 24 20 8B 44 24 50 89 54 24 24 8B 54 24 4C 11 54 24 24 F7 E6 01 44 24 20 11 54 24 24 8B 54 24 2C 89 D0 31 D2 89 44 24 28 8B 44 24 38 01 44 24 28 89 54 24 2C 8B 54 24 3C 11 54 24 2C 8B 54 24 24 89 D0 31 D2 01 44 24 28 11 54 24 2C 8B 95 ?? ?? ?? ?? 8B AD ?? ?? ?? ?? 89 D0 89 54 24 38 F7 E7 89 6C 24 10 89 44 24 48 89 E8 89 54 24 4C F7 E7 89 44 24 60 8B 44 24 38 89 54 24 64 F7 E6 89 54 24 74 8B 6C 24 74 31 D2 89 44 24 70 8B 44 24 48 89 EF 31 ED 89 7C 24 58 01 44 24 58 8B 44 24 10 89 6C 24 5C 11 54 24 5C F7 E6 01 44 24 58 8B 7C 24 4C 11 54 24 5C 8B 54 24 5C 89 FE 31 FF 03 74 24 60 89 D0 13 7C 24 64 31 D2 01 C6 8B 44 24 20 11 D7 89 C2 31 C0 89 44 24 20 8B 44 24 30 89 54 24 24 31 D2 01 44 24 20 11 54 24 24 01 74 24 20 11 7C 24 24 3B 7C 24 24 72 12 77 06 3B 74 24 20 76 0A 83 44 24 28 01 83 54 24 2C 00 8B 44 24 40 F7 E3 89 44 24 30 8B 44 24 50 89 54 24 34 F7 E3 89 44 24 60 8B 44 24 40 89 54 24 64 8B 6C 24 64 F7 E1 89 54 24 44 8B 7C 24 44 31 D2 89 44 24 40 8B 44 24 30 89 FE 31 FF 89 74 24 48 01 44 24 48 8B 44 24 50 89 7C 24 4C 8B 7C 24 34 11 54 24 4C F7 E1 01 44 24 48 89 FE 11 54 24 4C 31 FF 8B 54 24 4C 89 7C 24 34 8B 7C 24 60 89 74 24 30 01 7C 24 30 11 6C 24 34 89 D0 31 D2 01 44 24 30 8B 44 24 38 11 54 24 34 8B 6C 24 40 F7 E3 89 44 24 50 8B 44 24 10 89 54 24 54 F7 E3 8B 5C 24 54 89 44 24 60 8B 44 24 38 89 54 24 64 F7 E1 89 54 24 3C 8B 7C 24 3C 31 D2 89 44 24 38 8B 44 24 50 C7 44 24 3C 00 00 00 00 89 FE 31 FF 01 C6 8B 44 24 10 11 D7 F7 E1 89 D9 01 C6 8B 44 24 38 11 D7 31 DB 03 4C 24 60 13 5C 24 64 31 D2 89 6C 24 38 01 F9 89 F7 11 D3 31 F6 31 D2 01 C6 8B 44 24 48 11 D7 89 C2 31 C0 03 44 24 38 13 54 24 3C 01 C8 11 DA 39 D3 72 10 77 04 39 C1 76 0A 83 44 24 30 01 83 54 24 34 00 8B 4C 24 20 8B 5C 24 24 01 F1 11 FB 89 5C 24 24 31 DB 3B 7C 24 24 89 4C 24 20 B9 01 00 00 00 77 0C 72 06 3B 74 24 20 77 04 31 C9 31 DB 8B 74 24 28 01 C8 8B 7C 24 2C 11 DA 01 C6 11 D7 39 FA 89 74 24 28 89 7C 24 2C 0F 87 69 02 00 00 72 08 39 F0 0F 87 5F 02 00 00 31 FF 39 D3 BE 01 00 00 00 77 0F 72 04 39 C1 77 09 31 F6 31 FF 90 8D 74 26 00 03 74 24 30 13 7C 24 34 83 7C 24 6C 16 0F 8F 75 02 00 00 8B 5C 24 18 8B 44 24 2C 8B 6C 24 28 8B 54 24 2C 23 04 DD ?? ?? ?? ?? 23 2C DD ?? ?? ?? ?? 8B 1C 9D ?? ?? ?? ?? 89 44 24 30 8B 44 24 28 89 D9 0F AD D0 D3 EA F6 C1 20 74 04 89 D0 31 D2 89 44 24 28 B8 40 00 00 00 29 D8 89 C1 31 C0 D3 E6 F6 C1 20 8B 4C 24 28 0F 45 F0 89 54 24 2C 09 F1 0B 6C 24 30 75 5B 8B 74 24 58 31 D2 8B 44 24 70 89 F7 31 F6 01 C6 11 D7 8B 54 24 24 0B 54 24 20 75 06 89 FD 09 F5 74 39 8B 44 24 18 C1 E0 04 8B 90 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 39 44 24 24 0F 82 A0 04 00 00 77 0A 39 54 24 20 0F 82 94 04 00 00 33 44 24 24 33 54 24 20 09 D0 0F 84 63 04 00 00 89 C8 8B 4C 24 68 85 C9 0F 84 FE F6 FF FF F7 D8 E9 F7 F6 FF FF 8B 5C 24 18 8B 04 DD ?? ?? ?? ?? 0F AF C7 E9 E4 F6 FF FF 83 FA 1E 0F 8F D5 01 00 00 8D 72 F5 8B 04 F5 ?? ?? ?? ?? 8B 34 F5 ?? ?? ?? ?? C7 44 24 2C 00 00 00 00 8B 54 24 2C C7 44 24 34 00 00 00 00 89 44 24 30 89 74 24 28 8B 44 24 28 BE FB FF FF FF C7 44 24 4C 00 00 00 00 0F A4 C2 02 C1 E0 02 89 44 24 20 8B 44 24 30 89 54 24 24 8B 54 24 34 0F A4 C2 02 C1 E0 02 89 44 24 38 8B 44 24 28 89 54 24 3C F7 E6 89 54 24 44 8B 54 24 20 89 44 24 40 89 54 24 48 8B 54 24 44 89 D0 31 D2 89 44 24 28 8B 44 24 48 01 44 24 28 8B 44 24 30 89 54 24 2C 8B 54 24 4C 11 54 24 2C F7 E6 01 44 24 28 11 54 24 2C 8B 54 24 24 89 D0 31 D2 89 44 24 20 8B 44 24 38 01 44 24 20 89 54 24 24 8B 54 24 3C 11 54 24 24 8B 54 24 2C 89 D0 31 D2 01 44 24 20 8B 44 24 28 11 54 24 24 89 C2 31 C0 89 44 24 28 8B 44 24 40 89 54 24 2C 31 D2 01 44 24 28 11 54 24 2C 3B 5C 24 24 0F 87 47 F7 FF FF 72 0A 3B 4C 24 20 0F 87 3B F7 FF FF 8B 54 24 24 8B 44 24 20 31 DA 31 C8 09 C2 0F 85 BD F8 FF FF 3B 6C 24 2C 0F 82 B3 F8 FF FF 0F 87 17 F7 FF FF 3B 7C 24 28 0F 82 A3 F8 FF FF 8D 76 00 E9 05 F7 FF FF BE 01 00 00 00 31 FF E9 AF FD FF FF BE EC FF FF FF 89 F8 2B 74 24 18 89 EA C1 E6 04 03 86 ?? ?? ?? ?? 13 96 ?? ?? ?? ?? 03 8E ?? ?? ?? ?? 13 9E ?? ?? ?? ?? 8B 74 24 18 F7 D6 89 74 24 18 E9 5C FA FF FF 8B 5C 24 18 89 F0 89 FA 8B 6C 24 18 8B 1C 9D ?? ?? ?? ?? 89 D9 83 E9 40 D3 EA 0F AD F8 F6 C1 20 0F 45 C2 8B 14 ED ?? ?? ?? ?? 89 C1 8B 04 ED ?? ?? ?? ?? 21 FA 21 F0 09 C2 0F 85 0B FE FF FF 8B 44 24 2C 8B 6C 24 28 89 44 24 30 E9 99 FD FF FF 8D 72 E1 C1 E6 04 8B 96 ?? ?? ?? ?? 8B 86 ?? ?? ?? ?? C7 44 24 34 00 00 00 00 C7 44 24 2C 00 00 00 00 89 54 24 28 8B 54 24 34 89 44 24 30 8B 44 24 30 C7 44 24 4C 00 00 00 00 0F A4 C2 02 C1 E0 02 89 44 24 40 8B 44 24 28 89 54 24 44 8B 54 24 2C 0F A4 C2 02 C1 E0 02 89 44 24 20 B8 FB FF FF FF 89 54 24 24 F7 64 24 30 89 54 24 3C 8B 54 24 40 89 44 24 38 89 54 24 48 8B 54 24 3C 89 D0 31 D2 89 44 24 30 8B 44 24 48 01 44 24 30 B8 FB FF FF FF 89 54 24 34 8B 54 24 4C 11 54 24 34 F7 64 24 28 01 44 24 30 11 54 24 34 8B 44 24 30 89 C2 B8 00 00 00 00 89 44 24 28 8B 44 24 38 89 54 24 2C 31 D2 01 44 24 28 11 54 24 2C 6B 86 ?? ?? ?? ?? FB 8B 96 ?? ?? ?? ?? 8D 14 90 B8 FB FF FF FF 89 54 24 38 F7 A6 ?? ?? ?? ?? 8B 74 24 38 89 44 24 48 8B 44 24 48 01 F2 89 54 24 4C 8B 54 24 4C 01 44 24 20 11 54 24 24 8B 54 24 44 89 D0 31 D2 01 44 24 20 11 54 24 24 8B 54 24 34 89 D0 31 D2 01 44 24 20 11 54 24 24 E9 F4 FD FF FF 8D 72 E1 B8 05 00 00 00 C1 E6 04 F7 A6 ?? ?? ?? ?? C7 44 24 3C 00 00 00 00 89 44 24 20 B8 05 00 00 00 89 54 24 24 F7 A6 ?? ?? ?? ?? 89 54 24 34 8B 54 24 24 89 44 24 30 89 D0 31 D2 89 54 24 44 8B 54 24 20 89 44 24 40 8B 44 24 40 89 54 24 38 8B 54 24 44 03 44 24 38 13 54 24 3C 89 44 24 28 8B 44 24 30 01 44 24 28 8B 44 24 28 89 54 24 2C 8B 54 24 34 11 54 24 2C 89 C2 B8 00 00 00 00 89 44 24 20 8B 44 24 38 01 44 24 20 89 54 24 24 8B 54 24 3C 11 54 24 24 8B 96 ?? ?? ?? ?? 8B 86 ?? ?? ?? ?? 8D 14 92 8D 04 80 01 D0 89 44 24 38 B8 05 00 00 00 F7 A6 ?? ?? ?? ?? 8B 74 24 38 89 44 24 48 8B 44 24 48 01 F2 89 54 24 4C 8B 54 24 4C 03 44 24 30 13 54 24 34 89 44 24 38 8B 44 24 40 01 44 24 38 89 54 24 3C 8B 54 24 44 11 54 24 3C 8B 54 24 2C 89 D0 31 D2 01 44 24 38 11 54 24 3C E9 9A F5 FF FF C1 E2 04 39 AA ?? ?? ?? ?? 0F 87 C3 F2 FF FF 0F 82 07 F4 FF FF 39 BA ?? ?? ?? ?? 0F 83 B1 F2 FF FF 90 8D 74 26 00 E9 F1 F3 FF FF 8B 44 24 18 C1 E0 04 3B B8 ?? ?? ?? ?? 0F 87 8A FB FF FF 72 0C 3B B0 ?? ?? ?? ?? 0F 87 7C FB FF FF 89 C8 83 E0 01 85 C0 0F 84 6F FB FF FF 83 C1 FF E9 67 FB FF FF 90 8D 74 26 00 }
	condition:
		$1
}

rule file_102_1_0 {
	meta:
		name = "___bid128_to_int32_xrnint"
		size = 4480
		refs = "0112 ___bid_nr_digits 019c ___bid_midpoint128 01d3 ___bid_IDEC_glbflags 02a4 ___bid_ten2k64 04c2 ___bid_midpoint64 05eb ___bid_ten2mk128 0943 ___bid_maskhigh128 0951 ___bid_shiftright128 09ee ___bid_ten2mk128trunc 0bd4 ___bid_onehalf128 0c61 ___bid_ten2k128"
	strings:
		$1 = { 81 EC 9C 00 00 00 8B 84 24 A0 00 00 00 89 B4 24 90 00 00 00 8B B4 24 AC 00 00 00 89 9C 24 8C 00 00 00 89 AC 24 98 00 00 00 89 44 24 70 8B 84 24 A4 00 00 00 8B 4C 24 70 89 F2 89 F5 81 E2 00 00 00 78 81 E5 00 00 00 80 81 FA 00 00 00 78 89 44 24 74 8B 5C 24 74 89 BC 24 94 00 00 00 8B 84 24 A8 00 00 00 89 4C 24 08 89 5C 24 0C 0F 84 6E 01 00 00 89 F3 89 C1 81 E3 FF FF 01 00 81 FB 09 ED 01 00 76 2C 31 C0 8B 9C 24 8C 00 00 00 8B B4 24 90 00 00 00 8B BC 24 94 00 00 00 8B AC 24 98 00 00 00 81 C4 9C 00 00 00 C3 8D B4 26 00 00 00 00 0F 83 4D 01 00 00 89 DA 89 C8 81 F2 09 ED 01 00 35 C0 87 AD BE 09 C2 0F 84 94 01 00 00 89 F0 25 00 00 00 60 3D 00 00 00 60 74 A9 89 DF 09 CF 0F 84 2E 01 00 00 89 4C 24 68 89 5C 24 6C DF 6C 24 68 DD 5C 24 10 8B 54 24 14 89 D0 C1 E8 14 25 FF 07 00 00 2D BE 03 00 00 83 E8 01 89 C7 C1 E7 05 8B 97 ?? ?? ?? ?? 89 44 24 18 85 D2 75 34 8B 87 ?? ?? ?? ?? 8B 97 ?? ?? ?? ?? 8B BF ?? ?? ?? ?? 89 44 24 10 39 FB 0F 87 C4 02 00 00 0F 83 2E 04 00 00 8B 44 24 10 31 DF 31 C8 09 C7 0F 84 81 02 00 00 81 E6 00 00 FE 7F C1 EE 11 8D BE E0 E7 FF FF 8D 04 3A 83 F8 0A 0F 8F 13 03 00 00 0F 84 95 02 00 00 83 F8 00 0F 8C 09 04 00 00 8D 74 26 00 0F 85 12 02 00 00 8D 42 FF 83 F8 12 0F 8E 1F 03 00 00 83 EA 14 89 D0 C1 E0 04 8B B0 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 39 C3 0F 82 32 03 00 00 77 08 39 F1 0F 82 28 03 00 00 31 D8 31 F1 09 C8 66 90 0F 84 C0 0C 00 00 83 FD 01 19 C0 83 E0 02 83 E8 01 83 0D ?? ?? ?? ?? 20 E9 A9 FE FF FF 8D 76 00 89 F0 25 00 00 00 7C 3D 00 00 00 7C 0F 84 D0 01 00 00 83 0D ?? ?? ?? ?? 01 B8 00 00 00 80 E9 83 FE FF FF 3D C0 87 AD BE 0F 87 76 FE FF FF E9 A3 FE FF FF 8B 54 24 0C 31 C0 0B 54 24 08 0F 84 63 FE FF FF 81 7C 24 0C FF FF 1F 00 0F 86 60 02 00 00 8B 54 24 0C 89 D0 31 D2 89 44 24 68 89 54 24 6C DF 6C 24 68 DD 5C 24 10 8B 54 24 14 89 D0 C1 E8 14 25 FF 07 00 00 2D DE 03 00 00 E9 A7 FE FF FF 31 C0 81 7C 24 0C 63 8E 8D 37 0F 87 15 FE FF FF 89 F2 81 E2 00 00 00 60 81 FA 00 00 00 60 0F 85 60 FE FF FF E9 FC FD FF FF 8D B6 00 00 00 00 83 FA 1E 0F 8F BB 09 00 00 8D 72 F5 B8 05 00 00 00 F7 24 F5 ?? ?? ?? ?? C7 44 24 1C 00 00 00 00 89 54 24 14 89 44 24 10 B8 05 00 00 00 F7 24 F5 ?? ?? ?? ?? 89 54 24 24 8B 54 24 14 89 44 24 20 89 D0 31 D2 89 54 24 2C 8B 54 24 10 89 44 24 28 89 54 24 18 8B 44 24 18 03 44 24 28 8B 54 24 1C 13 54 24 2C 89 44 24 10 8B 44 24 20 01 44 24 10 8B 44 24 28 89 54 24 14 8B 54 24 24 11 54 24 14 8B 54 24 2C 03 44 24 20 13 54 24 24 89 44 24 30 89 54 24 34 8B 54 24 14 89 D0 31 D2 01 44 24 30 8B 44 24 10 11 54 24 34 89 C2 31 C0 89 44 24 10 8B 44 24 18 89 54 24 14 8B 54 24 1C 01 44 24 10 11 54 24 14 3B 5C 24 34 0F 87 22 01 00 00 72 0A 3B 4C 24 30 0F 87 16 01 00 00 8B 54 24 34 8B 74 24 30 31 DA 31 CE 09 F2 75 1E 8B 54 24 14 39 54 24 0C 72 14 0F 87 F6 00 00 00 8B 74 24 10 39 74 24 08 0F 87 E8 00 00 00 83 FF 00 0F 8C F2 01 00 00 8B 44 24 08 0F 84 3C 01 00 00 85 ED 0F 84 7C 06 00 00 F7 D8 0F AF 04 FD ?? ?? ?? ?? E9 C4 FC FF FF 83 0D ?? ?? ?? ?? 01 B8 00 00 00 80 E9 B3 FC FF FF 8B 44 24 18 8B 7C 24 0C C1 E0 05 05 ?? ?? ?? ?? 39 78 14 0F 87 66 FD FF FF 72 12 8B 7C 24 08 39 78 10 0F 87 57 FD FF FF 90 8D 74 26 00 83 C2 01 E9 4A FD FF FF 85 ED 0F 85 E6 00 00 00 83 FA 0B 0F 8F 23 06 00 00 C7 44 24 10 0B 00 00 00 8B 74 24 0C 29 54 24 10 8B 44 24 10 8B 54 24 08 0F AF 34 C5 ?? ?? ?? ?? 0F AF 14 C5 ?? ?? ?? ?? 8B 44 24 08 01 F2 8B 74 24 10 89 54 24 18 F7 24 F5 ?? ?? ?? ?? 8B 74 24 18 89 44 24 10 01 F2 83 FA 04 89 54 24 14 0F 82 2B FF FF FF 77 11 83 7C 24 10 FA 0F 86 1E FF FF FF 8D B6 00 00 00 00 83 0D ?? ?? ?? ?? 01 B8 00 00 00 80 E9 F5 FB FF FF DF 6C 24 08 DD 5C 24 10 8B 54 24 14 89 D0 C1 E8 14 25 FF 07 00 00 2D FE 03 00 00 E9 57 FC FF FF 89 DF 09 CF 0F 85 0B FD FF FF 8B 54 24 0C 39 14 C5 ?? ?? ?? ?? 77 18 0F 82 F8 FC FF FF 8B 4C 24 08 39 0C C5 ?? ?? ?? ?? 0F 82 E7 FC FF FF 90 31 C0 E9 EA FC FF FF 85 ED 0F 84 97 FB FF FF F7 D8 E9 90 FB FF FF 83 FA 0B 0F 8F 91 FD FF FF C7 44 24 10 0B 00 00 00 8B 74 24 0C 29 54 24 10 8B 44 24 10 8B 54 24 08 0F AF 34 C5 ?? ?? ?? ?? 0F AF 14 C5 ?? ?? ?? ?? 8B 44 24 08 01 F2 8B 74 24 10 89 54 24 18 F7 24 F5 ?? ?? ?? ?? 8B 74 24 18 89 44 24 10 01 F2 83 FA 05 89 54 24 14 0F 82 45 FE FF FF 0F 87 27 FF FF FF 83 7C 24 10 05 0F 86 34 FE FF FF E9 17 FF FF FF 8D B4 26 00 00 00 00 39 C1 0F 87 88 FE FF FF 90 8D B4 26 00 00 00 00 E9 BD FB FF FF 83 0D ?? ?? ?? ?? 20 31 C0 E9 F3 FA FF FF 89 FE F7 DE 83 FE 13 89 74 24 5C 0F 8F 7B 06 00 00 F7 D7 8B 44 24 08 8B 54 24 0C 03 04 FD ?? ?? ?? ?? 13 14 FD ?? ?? ?? ?? 89 7C 24 38 39 54 24 0C 72 0E 77 06 39 44 24 08 76 06 83 C1 01 83 D3 00 8B 7C 24 38 89 D6 89 44 24 30 C7 44 24 2C 00 00 00 00 C1 E7 04 8B 87 ?? ?? ?? ?? 8B 97 ?? ?? ?? ?? 89 44 24 20 89 54 24 40 F7 E6 89 44 24 10 8B 44 24 40 89 54 24 14 F7 E6 89 44 24 18 8B 44 24 30 89 54 24 1C F7 64 24 20 89 54 24 4C 8B 54 24 10 89 44 24 48 89 54 24 28 8B 54 24 4C 89 D0 31 D2 89 44 24 08 8B 44 24 28 01 44 24 08 8B 44 24 30 89 54 24 0C 8B 54 24 2C 11 54 24 0C F7 64 24 40 01 44 24 08 11 54 24 0C 8B 54 24 14 89 D0 31 D2 89 44 24 10 8B 44 24 18 01 44 24 10 89 54 24 14 8B 54 24 1C 11 54 24 14 8B 54 24 0C 89 D0 31 D2 01 44 24 10 11 54 24 14 8B 97 ?? ?? ?? ?? 8B BF ?? ?? ?? ?? 89 D0 89 54 24 28 F7 E6 89 7C 24 58 89 44 24 18 89 F8 89 54 24 1C F7 E6 89 44 24 50 8B 44 24 30 89 54 24 54 F7 64 24 28 89 54 24 64 8B 7C 24 64 31 D2 89 44 24 60 8B 44 24 18 89 FE 31 FF 01 C6 8B 44 24 30 11 D7 F7 64 24 58 01 C6 11 D7 8B 54 24 1C 89 D0 31 D2 89 44 24 18 8B 44 24 50 01 44 24 18 89 54 24 1C 8B 54 24 54 11 54 24 1C 89 FA 89 D0 31 D2 89 74 24 54 8B 74 24 08 01 44 24 18 11 54 24 1C 31 C0 31 D2 89 44 24 50 8B 44 24 60 89 F7 01 44 24 50 11 54 24 54 31 F6 8B 44 24 48 31 D2 89 74 24 08 01 44 24 08 8B 44 24 18 89 7C 24 0C 11 54 24 0C 8B 54 24 1C 01 44 24 08 11 54 24 0C 8B 74 24 0C 39 F2 72 14 77 08 8B 7C 24 08 39 F8 76 0A 83 44 24 10 01 83 54 24 14 00 8B 44 24 20 F7 E3 89 44 24 18 8B 44 24 40 89 54 24 1C F7 E3 89 44 24 48 8B 44 24 20 89 54 24 4C F7 E1 89 54 24 24 8B 7C 24 24 31 D2 89 44 24 20 8B 44 24 18 89 FE 31 FF 89 74 24 30 01 44 24 30 8B 44 24 40 89 7C 24 34 8B 7C 24 1C 11 54 24 34 F7 E1 01 44 24 30 89 FE 11 54 24 34 31 FF 8B 54 24 34 89 74 24 18 8B 74 24 48 01 74 24 18 89 7C 24 1C 8B 7C 24 4C 89 D0 11 7C 24 1C 31 D2 01 44 24 18 8B 44 24 28 11 54 24 1C F7 E3 89 44 24 40 8B 44 24 58 89 54 24 44 F7 E3 8B 5C 24 44 89 44 24 48 8B 44 24 28 89 54 24 4C F7 E1 89 54 24 2C 8B 7C 24 2C 31 D2 89 44 24 28 8B 44 24 40 C7 44 24 2C 00 00 00 00 89 FE 31 FF 01 C6 8B 44 24 58 11 D7 F7 E1 89 D9 01 C6 11 D7 31 DB 03 4C 24 48 89 FA 13 5C 24 4C 89 D0 31 D2 01 C1 11 D3 31 C0 89 44 24 40 8B 44 24 28 31 D2 89 74 24 44 8B 74 24 20 01 44 24 40 8B 44 24 30 11 54 24 44 89 74 24 28 89 C2 31 C0 03 44 24 28 13 54 24 2C 01 C8 11 DA 39 D3 72 10 77 04 39 C1 76 0A 83 44 24 18 01 83 54 24 1C 00 8B 5C 24 08 B9 01 00 00 00 03 5C 24 40 8B 74 24 0C 13 74 24 44 89 5C 24 08 31 DB 39 74 24 44 89 74 24 0C 77 10 72 0A 8B 74 24 08 39 74 24 40 77 04 31 C9 31 DB 8B 74 24 10 01 C8 8B 7C 24 14 11 DA 01 C6 11 D7 39 FA 89 74 24 10 89 7C 24 14 0F 87 11 03 00 00 72 08 39 F0 0F 87 07 03 00 00 31 FF 39 D3 BE 01 00 00 00 77 0A 72 04 39 C1 77 04 31 F6 31 FF 03 74 24 18 13 7C 24 1C 83 7C 24 5C 16 0F 8F 5C 02 00 00 8B 5C 24 38 8B 44 24 10 8B 54 24 14 23 04 DD ?? ?? ?? ?? 23 14 DD ?? ?? ?? ?? 8B 0C 9D ?? ?? ?? ?? BB 40 00 00 00 89 44 24 18 8B 44 24 10 89 54 24 1C 8B 54 24 14 0F AD D0 D3 EA F6 C1 20 0F 45 C2 29 CB 89 D9 31 D2 D3 E6 F6 C3 20 0F 45 F2 89 F1 09 C1 83 7C 24 5C 03 0F 8F F0 06 00 00 81 7C 24 0C 00 00 00 80 0F 87 52 05 00 00 72 0B 83 7C 24 08 00 0F 87 45 05 00 00 8B 44 24 0C 05 00 00 00 80 0B 44 24 08 0F 84 E6 05 00 00 83 0D ?? ?? ?? ?? 20 8B 44 24 1C 0B 44 24 18 75 4D 8B 54 24 0C 0B 54 24 08 75 0A 8B 74 24 54 0B 74 24 50 74 39 8B 44 24 38 C1 E0 04 8B 90 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 39 44 24 0C 0F 82 8F 05 00 00 77 0A 39 54 24 08 0F 82 83 05 00 00 33 44 24 0C 33 54 24 08 09 D0 0F 84 4A 05 00 00 85 ED 89 C8 0F 84 5E F6 FF FF F7 D8 E9 57 F6 FF FF 0F AF 04 FD ?? ?? ?? ?? E9 4A F6 FF FF 83 FA 1E 0F 8F 14 03 00 00 8D 72 F5 8B 04 F5 ?? ?? ?? ?? 8B 34 F5 ?? ?? ?? ?? C7 44 24 1C 00 00 00 00 8B 54 24 1C C7 44 24 24 00 00 00 00 89 44 24 20 89 74 24 18 8B 44 24 18 BE FB FF FF FF C7 44 24 34 00 00 00 00 0F A4 C2 02 C1 E0 02 89 44 24 10 8B 44 24 20 89 54 24 14 8B 54 24 24 0F A4 C2 02 C1 E0 02 89 44 24 38 8B 44 24 18 89 54 24 3C F7 E6 89 54 24 2C 8B 54 24 10 89 44 24 28 89 54 24 30 8B 54 24 2C 89 D0 31 D2 89 44 24 18 8B 44 24 30 01 44 24 18 8B 44 24 20 89 54 24 1C 8B 54 24 34 11 54 24 1C F7 E6 01 44 24 18 11 54 24 1C 8B 54 24 14 89 D0 31 D2 89 44 24 10 8B 44 24 38 01 44 24 10 89 54 24 14 8B 54 24 3C 11 54 24 14 8B 54 24 1C 89 D0 31 D2 01 44 24 10 8B 44 24 18 11 54 24 14 89 C2 31 C0 89 44 24 18 8B 44 24 28 89 54 24 1C 31 D2 01 44 24 18 11 54 24 1C 3B 5C 24 14 0F 87 3B F9 FF FF 72 0A 3B 4C 24 10 0F 87 2F F9 FF FF 8B 54 24 14 8B 44 24 10 31 DA 31 C8 09 C2 0F 85 33 F8 FF FF 8B 54 24 1C 39 54 24 0C 0F 82 25 F8 FF FF 0F 87 07 F9 FF FF 8B 74 24 18 39 74 24 08 0F 82 11 F8 FF FF E9 F4 F8 FF FF 8D 74 26 00 8B 5C 24 38 8B 04 DD ?? ?? ?? ?? 8B 0C 9D ?? ?? ?? ?? 8B 14 DD ?? ?? ?? ?? 21 F0 89 44 24 20 89 F0 21 FA 89 4C 24 04 83 E9 40 0F AD F8 89 54 24 28 89 FA 8B 7C 24 38 D3 EA F6 C1 20 0F 45 C2 89 C1 8B 04 FD ?? ?? ?? ?? 39 44 24 28 8B 34 FD ?? ?? ?? ?? 0F 86 CD 02 00 00 8B 44 24 10 8B 54 24 14 83 0D ?? ?? ?? ?? 20 89 44 24 18 89 54 24 1C 8B 7C 24 28 0B 7C 24 20 0F 85 10 FE FF FF E9 B4 FD FF FF BE 01 00 00 00 31 FF E9 02 FD FF FF BE EC FF FF FF 8B 44 24 08 29 FE 8B 54 24 0C F7 D7 C1 E6 04 03 86 ?? ?? ?? ?? 89 7C 24 38 13 96 ?? ?? ?? ?? 03 8E ?? ?? ?? ?? 13 9E ?? ?? ?? ?? E9 6C F9 FF FF 8D 72 E1 B8 05 00 00 00 C1 E6 04 F7 A6 ?? ?? ?? ?? C7 44 24 34 00 00 00 00 89 44 24 10 B8 05 00 00 00 89 54 24 14 F7 A6 ?? ?? ?? ?? 89 54 24 24 8B 54 24 14 89 44 24 20 89 D0 31 D2 89 54 24 2C 8B 54 24 10 89 44 24 28 8B 44 24 28 89 54 24 30 8B 54 24 2C 03 44 24 30 13 54 24 34 89 44 24 18 8B 44 24 20 01 44 24 18 8B 44 24 18 89 54 24 1C 8B 54 24 24 11 54 24 1C 89 C2 B8 00 00 00 00 89 44 24 10 8B 44 24 30 01 44 24 10 89 54 24 14 8B 54 24 34 11 54 24 14 8B 96 ?? ?? ?? ?? 8B 86 ?? ?? ?? ?? 8D 14 92 8D 04 80 01 D0 89 44 24 38 B8 05 00 00 00 F7 A6 ?? ?? ?? ?? 8B 74 24 38 89 44 24 30 8B 44 24 30 01 F2 89 54 24 34 8B 54 24 34 03 44 24 20 13 54 24 24 89 44 24 30 8B 44 24 28 01 44 24 30 89 54 24 34 8B 54 24 2C 11 54 24 34 8B 54 24 1C 89 D0 31 D2 01 44 24 30 11 54 24 34 E9 FB F5 FF FF 8D 72 E1 C1 E6 04 8B 96 ?? ?? ?? ?? 8B 86 ?? ?? ?? ?? C7 44 24 24 00 00 00 00 C7 44 24 1C 00 00 00 00 89 54 24 18 8B 54 24 24 89 44 24 20 8B 44 24 20 C7 44 24 34 00 00 00 00 0F A4 C2 02 C1 E0 02 89 44 24 28 8B 44 24 18 89 54 24 2C 8B 54 24 1C 0F A4 C2 02 C1 E0 02 89 44 24 10 B8 FB FF FF FF 89 54 24 14 F7 64 24 20 89 54 24 3C 8B 54 24 28 89 44 24 38 89 54 24 30 8B 54 24 3C 89 D0 31 D2 89 44 24 20 8B 44 24 30 01 44 24 20 B8 FB FF FF FF 89 54 24 24 8B 54 24 34 11 54 24 24 F7 64 24 18 01 44 24 20 11 54 24 24 8B 44 24 20 89 C2 B8 00 00 00 00 89 44 24 18 8B 44 24 38 89 54 24 1C 31 D2 01 44 24 18 11 54 24 1C 6B 86 ?? ?? ?? ?? FB 8B 96 ?? ?? ?? ?? 8D 14 90 B8 FB FF FF FF 89 54 24 38 F7 A6 ?? ?? ?? ?? 8B 74 24 38 89 44 24 30 8B 44 24 30 01 F2 89 54 24 34 8B 54 24 34 01 44 24 10 11 54 24 14 8B 54 24 2C 89 D0 31 D2 01 44 24 10 11 54 24 14 8B 54 24 24 89 D0 31 D2 01 44 24 10 11 54 24 14 E9 B5 FC FF FF C1 E2 04 8B 5C 24 0C 39 9A ?? ?? ?? ?? 0F 87 47 F6 FF FF 0F 82 27 F3 FF FF 8B 74 24 08 39 B2 ?? ?? ?? ?? 0F 82 17 F3 FF FF 31 C0 E9 1B F3 FF FF 72 0E 39 74 24 20 8D 74 26 00 0F 87 23 FD FF FF 33 44 24 28 33 74 24 20 09 F0 0F 84 FA 00 00 00 8B 74 24 10 8B 7C 24 14 83 0D ?? ?? ?? ?? 20 89 74 24 18 89 7C 24 1C E9 0E FD FF FF 8B 74 24 08 8B 7C 24 0C 8B 44 24 38 83 C6 00 81 D7 00 00 00 80 C1 E0 04 8B 90 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 39 C7 0F 87 A2 FA FF FF 72 08 39 D6 0F 87 98 FA FF FF 31 F8 31 F2 09 D0 66 90 0F 85 91 FA FF FF 8B 44 24 38 8B 54 24 54 C1 E0 04 3B 90 ?? ?? ?? ?? 0F 82 7A FA FF FF 0F 87 6D FA FF FF 8B 74 24 50 3B B0 ?? ?? ?? ?? 0F 82 64 FA FF FF E9 58 FA FF FF 8B 44 24 38 8B 7C 24 54 C1 E0 04 3B B8 ?? ?? ?? ?? 0F 87 9F FA FF FF 72 10 8B 54 24 50 3B 90 ?? ?? ?? ?? 0F 87 8D FA FF FF 89 C8 83 E0 01 85 C0 0F 84 80 FA FF FF 83 C1 FF E9 78 FA FF FF 8B 44 24 54 0B 44 24 50 0F 84 0C FA FF FF 8B 44 24 38 31 F6 31 FF C1 E0 04 8B 90 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? E9 58 FF FF FF 8B 7C 24 14 0B 7C 24 10 0F 85 0B FC FF FF 8B 44 24 0C 0B 44 24 08 75 3C 8B 54 24 54 0B 54 24 50 0F 84 E0 FE FF FF 8B 44 24 38 C1 E0 04 8B B0 ?? }
	condition:
		$1
}

rule file_102_2_0 {
	meta:
		name = "___bid128_to_int32_floor"
		size = 3792
		refs = "0112 ___bid_nr_digits 01b4 ___bid_IDEC_glbflags 02c5 ___bid_ten2k64 03fe ___bid_midpoint64 0438 ___bid_ten2mk128 07a9 ___bid_maskhigh128 07b0 ___bid_shiftright128 085d ___bid_ten2mk128trunc 091c ___bid_onehalf128 09c6 ___bid_midpoint128 0bb3 ___bid_ten2k128"
	strings:
		$1 = { 81 EC 9C 00 00 00 8B 84 24 A0 00 00 00 89 B4 24 90 00 00 00 8B B4 24 AC 00 00 00 89 9C 24 8C 00 00 00 89 AC 24 98 00 00 00 89 44 24 70 8B 84 24 A4 00 00 00 8B 4C 24 70 89 F2 89 F5 81 E2 00 00 00 78 81 E5 00 00 00 80 81 FA 00 00 00 78 89 44 24 74 8B 5C 24 74 89 BC 24 94 00 00 00 8B 84 24 A8 00 00 00 89 4C 24 08 89 5C 24 0C 0F 84 2E 01 00 00 89 F3 89 C1 81 E3 FF FF 01 00 81 FB 09 ED 01 00 76 2C 31 C0 8B 9C 24 8C 00 00 00 8B B4 24 90 00 00 00 8B BC 24 94 00 00 00 8B AC 24 98 00 00 00 81 C4 9C 00 00 00 C3 8D B4 26 00 00 00 00 0F 83 0D 01 00 00 89 DA 89 C8 81 F2 09 ED 01 00 35 C0 87 AD BE 09 C2 0F 84 54 01 00 00 89 F0 25 00 00 00 60 3D 00 00 00 60 74 A9 89 DF 09 CF 0F 84 EE 00 00 00 89 4C 24 68 89 5C 24 6C DF 6C 24 68 DD 5C 24 10 8B 54 24 14 89 D0 C1 E8 14 25 FF 07 00 00 2D BE 03 00 00 83 E8 01 89 C7 C1 E7 05 8B 97 ?? ?? ?? ?? 89 44 24 18 85 D2 75 34 8B 87 ?? ?? ?? ?? 8B 97 ?? ?? ?? ?? 8B BF ?? ?? ?? ?? 89 44 24 10 39 FB 0F 87 54 01 00 00 0F 83 91 02 00 00 8B 44 24 10 31 DF 31 C8 09 C7 0F 84 0F 01 00 00 81 E6 00 00 FE 7F C1 EE 11 81 EE 20 18 00 00 8D 04 32 83 F8 0A 0F 8F 48 02 00 00 0F 84 25 01 00 00 85 C0 0F 8E 9A 01 00 00 83 FE 00 66 90 0F 8C 5A 02 00 00 8B 44 24 08 0F 85 91 01 00 00 85 ED 0F 84 EE FE FF FF F7 D8 E9 E7 FE FF FF 90 89 F0 25 00 00 00 7C 3D 00 00 00 7C 0F 84 9E 00 00 00 83 0D ?? ?? ?? ?? 01 B8 00 00 00 80 E9 C3 FE FF FF 3D C0 87 AD BE 0F 87 B6 FE FF FF E9 E3 FE FF FF 8B 54 24 0C 31 C0 0B 54 24 08 0F 84 A3 FE FF FF 81 7C 24 0C FF FF 1F 00 0F 86 47 01 00 00 8B 54 24 0C 89 D0 31 D2 89 44 24 68 89 54 24 6C DF 6C 24 68 DD 5C 24 10 8B 54 24 14 89 D0 C1 E8 14 25 FF 07 00 00 2D DE 03 00 00 E9 E7 FE FF FF 31 C0 81 7C 24 0C 63 8E 8D 37 0F 87 55 FE FF FF 89 F2 81 E2 00 00 00 60 81 FA 00 00 00 60 0F 85 A0 FE FF FF E9 3C FE FF FF 8D B6 00 00 00 00 83 0D ?? ?? ?? ?? 01 B8 00 00 00 80 E9 25 FE FF FF 8B 44 24 18 8B 7C 24 0C C1 E0 05 05 ?? ?? ?? ?? 39 78 14 0F 87 D8 FE FF FF 72 14 8B 7C 24 08 39 78 10 0F 87 C9 FE FF FF 8D B4 26 00 00 00 00 83 C2 01 E9 BA FE FF FF 85 ED 0F 84 B8 00 00 00 83 FA 0B 0F 8F 3C 07 00 00 C7 44 24 10 0B 00 00 00 8B 7C 24 0C 29 54 24 10 8B 44 24 10 8B 54 24 08 0F AF 3C C5 ?? ?? ?? ?? 0F AF 14 C5 ?? ?? ?? ?? 8B 44 24 08 01 FA 8B 7C 24 10 89 54 24 18 F7 24 FD ?? ?? ?? ?? 8B 7C 24 18 89 44 24 10 01 FA 83 FA 05 89 54 24 14 0F 82 7E FE FF FF 0F 87 B2 00 00 00 83 7C 24 10 00 0F 86 6D FE FF FF 66 90 E9 A0 00 00 00 83 FD 01 19 C0 F7 D0 E9 65 FD FF FF 85 ED 0F 84 9D 00 00 00 F7 D8 0F AF 04 F5 ?? ?? ?? ?? E9 4E FD FF FF DF 6C 24 08 DD 5C 24 10 8B 54 24 14 89 D0 C1 E8 14 25 FF 07 00 00 2D FE 03 00 00 E9 B0 FD FF FF 83 FA 0B 0F 8F 26 07 00 00 C7 44 24 10 0B 00 00 00 8B 7C 24 0C 29 54 24 10 8B 44 24 10 8B 54 24 08 0F AF 3C C5 ?? ?? ?? ?? 0F AF 14 C5 ?? ?? ?? ?? 8B 44 24 08 01 FA 8B 7C 24 10 89 54 24 18 F7 24 FD ?? ?? ?? ?? 8B 7C 24 18 89 44 24 10 01 FA 83 FA 04 89 54 24 14 0F 86 C6 FD FF FF 83 0D ?? ?? ?? ?? 01 B8 00 00 00 80 E9 C0 FC FF FF 0F AF 04 F5 ?? ?? ?? ?? E9 B3 FC FF FF 39 C1 0F 87 B5 FE FF FF E9 62 FD FF FF 89 F7 F7 DF 83 FF 13 89 7C 24 5C 0F 8F BF 05 00 00 F7 D6 8B 44 24 08 8B 54 24 0C 03 04 F5 ?? ?? ?? ?? 13 14 F5 ?? ?? ?? ?? 89 74 24 44 39 54 24 0C 72 0E 77 06 39 44 24 08 76 06 83 C1 01 83 D3 00 8B 7C 24 44 89 D6 89 44 24 28 C7 44 24 24 00 00 00 00 C1 E7 04 8B 87 ?? ?? ?? ?? 8B 97 ?? ?? ?? ?? 89 44 24 30 89 54 24 38 F7 E6 89 44 24 18 8B 44 24 38 89 54 24 1C F7 E6 89 44 24 10 8B 44 24 28 89 54 24 14 F7 64 24 30 89 54 24 4C 8B 54 24 18 89 44 24 48 89 54 24 20 8B 54 24 4C 89 D0 31 D2 89 44 24 08 8B 44 24 20 01 44 24 08 8B 44 24 28 89 54 24 0C 8B 54 24 24 11 54 24 0C F7 64 24 38 01 44 24 08 11 54 24 0C 8B 54 24 1C 89 D0 31 D2 89 44 24 18 8B 44 24 10 01 44 24 18 89 54 24 1C 8B 54 24 14 11 54 24 1C 8B 54 24 0C 89 D0 31 D2 01 44 24 18 11 54 24 1C 8B 97 ?? ?? ?? ?? 8B BF ?? ?? ?? ?? 89 D0 89 54 24 20 F7 E6 89 7C 24 58 89 44 24 10 89 F8 89 54 24 14 F7 E6 89 44 24 50 8B 44 24 28 89 54 24 54 F7 64 24 20 89 54 24 64 8B 7C 24 64 31 D2 89 44 24 60 8B 44 24 10 89 FE 31 FF 01 C6 8B 44 24 28 11 D7 F7 64 24 58 01 C6 11 D7 8B 54 24 14 89 D0 31 D2 89 44 24 10 8B 44 24 50 01 44 24 10 89 54 24 14 8B 54 24 54 11 54 24 14 89 FA 89 D0 31 D2 89 74 24 54 8B 74 24 08 01 44 24 10 11 54 24 14 31 C0 31 D2 89 44 24 50 8B 44 24 60 89 F7 01 44 24 50 11 54 24 54 31 F6 8B 44 24 48 31 D2 89 74 24 08 01 44 24 08 8B 44 24 10 89 7C 24 0C 11 54 24 0C 8B 54 24 14 01 44 24 08 11 54 24 0C 8B 74 24 0C 39 F2 72 14 77 08 8B 7C 24 08 39 F8 76 0A 83 44 24 18 01 83 54 24 1C 00 8B 44 24 30 F7 E3 89 44 24 10 8B 44 24 38 89 54 24 14 F7 E3 89 44 24 48 8B 44 24 30 89 54 24 4C F7 E1 89 54 24 34 8B 7C 24 34 31 D2 89 44 24 30 8B 44 24 10 89 FE 31 FF 89 74 24 28 01 44 24 28 8B 44 24 38 89 7C 24 2C 8B 7C 24 14 11 54 24 2C F7 E1 01 44 24 28 89 FE 11 54 24 2C 31 FF 8B 54 24 2C 89 74 24 10 8B 74 24 48 01 74 24 10 89 7C 24 14 8B 7C 24 4C 89 D0 11 7C 24 14 31 D2 01 44 24 10 8B 44 24 20 11 54 24 14 F7 E3 89 44 24 38 8B 44 24 58 89 54 24 3C F7 E3 8B 5C 24 3C 89 44 24 48 8B 44 24 20 89 54 24 4C F7 E1 89 54 24 24 8B 7C 24 24 31 D2 89 44 24 20 8B 44 24 38 C7 44 24 24 00 00 00 00 89 FE 31 FF 01 C6 8B 44 24 58 11 D7 F7 E1 89 D9 01 C6 11 D7 31 DB 03 4C 24 48 89 FA 13 5C 24 4C 89 D0 31 D2 01 C1 11 D3 31 C0 89 44 24 38 8B 44 24 20 31 D2 89 74 24 3C 8B 74 24 30 01 44 24 38 8B 44 24 28 11 54 24 3C 89 74 24 20 89 C2 31 C0 03 44 24 20 13 54 24 24 01 C8 11 DA 39 D3 72 10 77 04 39 C1 76 0A 83 44 24 10 01 83 54 24 14 00 8B 5C 24 08 B9 01 00 00 00 03 5C 24 38 8B 74 24 0C 13 74 24 3C 89 5C 24 08 31 DB 39 74 24 3C 89 74 24 0C 77 10 72 0A 8B 74 24 08 39 74 24 38 77 04 31 C9 31 DB 8B 74 24 18 01 C8 8B 7C 24 1C 11 DA 01 C6 11 D7 39 FA 0F 87 59 02 00 00 72 08 39 F0 0F 87 4F 02 00 00 39 D3 C7 44 24 18 01 00 00 00 C7 44 24 1C 00 00 00 00 77 16 72 04 39 C1 77 10 C7 44 24 18 00 00 00 00 C7 44 24 1C 00 00 00 00 8B 44 24 18 8B 54 24 1C 8B 4C 24 10 8B 5C 24 14 01 C1 11 D3 83 7C 24 5C 16 89 4C 24 20 89 5C 24 24 0F 8F 2E 01 00 00 8B 5C 24 44 8B 04 DD ?? ?? ?? ?? 8B 0C 9D ?? ?? ?? ?? 8B 14 DD ?? ?? ?? ?? BB 40 00 00 00 21 F0 89 44 24 10 8B 44 24 20 0F AD FE 21 FA D3 EF F6 C1 20 0F 45 F7 29 CB 89 D9 31 DB D3 E0 F6 C1 20 0F 45 C3 89 C1 09 F1 83 7C 24 5C 03 89 54 24 14 0F 8F D0 05 00 00 81 7C 24 0C 00 00 00 80 0F 87 26 03 00 00 72 0B 83 7C 24 08 00 0F 87 19 03 00 00 8B 54 24 0C 31 C0 BF 01 00 00 00 81 C2 00 00 00 80 0B 54 24 08 0F 84 87 04 00 00 8B 54 24 14 0B 54 24 10 0F 85 3E 01 00 00 8B 74 24 0C 0B 74 24 08 75 0E 8B 54 24 54 0B 54 24 50 0F 84 26 01 00 00 8B 54 24 44 C1 E2 04 8B B2 ?? ?? ?? ?? 89 74 24 10 8B B2 ?? ?? ?? ?? 39 74 24 0C 0F 82 1E 04 00 00 77 0E 8B 54 24 10 39 54 24 08 0F 82 0E 04 00 00 33 74 24 0C 31 D2 89 74 24 18 8B 74 24 08 33 74 24 10 C7 44 24 10 00 00 00 00 89 74 24 08 8B 74 24 18 0B 74 24 08 0F 84 B9 03 00 00 85 ED 0F 85 D7 00 00 00 0B 7C 24 10 74 03 83 C1 FF 89 C8 E9 BD F7 FF FF 8D B4 26 00 00 00 00 8B 5C 24 44 8B 44 24 20 8B 54 24 24 23 04 DD ?? ?? ?? ?? 23 14 DD ?? ?? ?? ?? 8B 0C 9D ?? ?? ?? ?? 89 44 24 30 8B 44 24 20 89 54 24 18 8B 54 24 24 89 4C 24 40 83 E9 40 0F AD D0 D3 EA F6 C1 20 0F 45 C2 8B 54 24 44 89 C1 8B 14 D5 ?? ?? ?? ?? 89 54 24 10 8B 54 24 44 8B 04 D5 ?? ?? ?? ?? 39 44 24 18 0F 87 DF 01 00 00 72 0E 8B 54 24 10 39 54 24 30 0F 87 CF 01 00 00 8B 54 24 10 33 44 24 18 33 54 24 30 09 D0 0F 84 95 03 00 00 89 7C 24 14 31 C0 BF 01 00 00 00 89 74 24 10 8B 74 24 18 0B 74 24 30 0F 84 B4 FE FF FF 31 D2 C7 44 24 10 00 00 00 00 E9 28 FF FF FF 8D B4 26 00 00 00 00 09 C2 74 03 83 C1 01 89 C8 F7 D8 E9 E6 F6 FF FF B8 01 00 00 00 31 D2 E9 D7 FD FF FF 8D 74 26 00 BF EC FF FF FF 8B 44 24 08 29 F7 8B 54 24 0C F7 D6 C1 E7 04 03 87 ?? ?? ?? ?? 89 74 24 44 13 97 ?? ?? ?? ?? 03 8F ?? ?? ?? ?? 13 9F ?? ?? ?? ?? E9 28 FA FF FF 83 FA 1E 0F 8F 14 02 00 00 8D 7A F5 B8 05 00 00 00 F7 24 FD ?? ?? ?? ?? 89 54 24 14 89 44 24 10 B8 05 00 00 00 F7 24 FD ?? ?? ?? ?? 89 54 24 1C 8B 54 24 14 89 44 24 18 89 D0 31 D2 89 44 24 20 8B 44 24 18 89 54 24 24 8B 54 24 1C 01 44 24 20 11 54 24 24 3B 5C 24 24 0F 87 72 F9 FF FF 72 0A 3B 4C 24 20 0F 87 66 F9 FF FF 8B 54 24 24 8B 44 24 20 31 DA 31 C8 09 C2 0F 85 18 F7 FF FF 8B 54 24 10 39 54 24 0C 0F 82 0A F7 FF FF 0F 87 3E F9 FF FF 83 7C 24 08 00 0F 86 F9 F6 FF FF E9 2E F9 FF FF 83 FA 1E 0F 8F 16 01 00 00 8D 7A F5 B8 05 00 00 00 F7 24 FD ?? ?? ?? ?? 89 54 24 14 89 44 24 10 B8 05 00 00 00 F7 24 FD ?? ?? ?? ?? 89 54 24 1C 8B 54 24 14 89 44 24 18 89 D0 31 D2 89 44 24 20 8B 44 24 18 89 54 24 24 8B 54 24 1C 01 44 24 20 11 54 24 24 3B 5C 24 24 0F 87 D0 F8 FF FF 72 0A 3B 4C 24 20 0F 87 C4 F8 FF FF 8B 54 24 24 8B 44 24 20 31 DA 31 C8 09 C2 0F 85 76 F6 FF FF 8B 54 24 10 39 54 24 0C 0F 82 68 F6 FF FF E9 9D F8 FF FF 89 7C 24 14 B8 01 00 00 00 31 FF 89 74 24 10 E9 40 FE FF FF 8B 44 24 08 8B 54 24 0C 8B 74 24 44 83 C0 00 81 D2 00 00 00 80 C1 E6 04 8B BE ?? ?? ?? ?? 8B B6 ?? ?? ?? ?? 39 F2 0F 87 06 01 00 00 72 08 39 F8 0F 87 FC 00 00 00 31 D6 89 C2 31 FA 31 C0 31 FF 09 D6 0F 85 BA FC FF FF 8B 44 24 44 8B 7C 24 54 C1 E0 04 3B B8 ?? ?? ?? ?? 0F 87 D3 00 00 00 72 10 8B 54 24 50 3B 90 ?? ?? ?? ?? 0F 83 C1 00 00 00 31 FF 31 C0 E9 88 FC FF FF 8D 7A E1 B8 05 00 00 00 C1 E7 04 F7 A7 ?? ?? ?? ?? 89 44 24 18 B8 05 00 00 00 89 54 24 1C F7 A7 ?? ?? ?? ?? 89 54 24 24 8B 54 24 18 89 44 24 20 31 C0 01 44 24 20 89 54 24 10 8B 97 ?? ?? ?? ?? 8D 14 92 11 54 24 24 8B 54 24 1C 89 D0 31 D2 01 44 24 20 11 54 24 24 E9 D9 FE FF FF 8D 7A E1 B8 05 00 00 00 C1 E7 04 F7 A7 ?? ?? ?? ?? 89 44 24 18 B8 05 00 00 00 89 54 24 1C F7 A7 ?? ?? ?? ?? 89 54 24 24 8B 54 24 18 89 44 24 20 31 C0 01 44 24 20 89 54 24 10 8B 97 ?? ?? ?? ?? 8D 14 92 11 54 24 24 8B 54 24 1C 89 D0 31 D2 01 44 24 20 11 54 24 24 E9 DB FD FF FF 31 FF B8 01 00 00 00 E9 C4 FB FF FF 8B 54 24 44 8B 74 24 54 C1 E2 04 3B B2 ?? ?? ?? ?? 0F 87 F9 FC FF FF 72 10 8B 74 24 50 3B B2 ?? ?? ?? ?? 0F 87 E7 FC FF FF 89 C8 83 E0 01 85 C0 74 43 83 C1 FF BA 01 00 00 00 C7 44 24 10 00 00 00 00 31 FF 31 C0 E9 FC FB FF FF 8B 74 24 54 0B 74 24 50 0F 84 6B FB FF FF 8B 44 24 44 31 D2 C1 E0 04 8B B8 ?? ?? ?? ?? 8B B0 ?? ?? ?? ?? 31 C0 E9 83 FE FF FF 31 D2 31 FF C7 44 24 10 01 00 00 00 31 C0 E9 BF FB FF FF 89 F8 09 F0 0F 85 1C FE FF FF 8B 54 24 0C 0B 54 24 08 75 2A 8B 74 24 54 0B 74 24 50 0F 85 9F 00 00 00 C7 44 24 10 00 00 00 00 BF 01 00 00 00 31 C0 C7 44 24 14 00 00 00 00 E9 3C FC FF FF 8B 44 24 44 C1 E0 04 8B 90 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 39 44 24 0C 77 4E 72 06 39 54 24 08 77 46 39 44 24 0C 74 19 C7 44 24 10 00 00 00 00 31 FF 31 C0 C7 44 24 14 00 00 00 00 E9 FC FB FF FF 39 54 24 08 75 E1 8B 44 24 44 8B 7C 24 54 C1 E0 04 3B B8 ?? ?? ?? ?? 77 0E 72 CC 8B 54 24 50 3B 90 ?? ?? ?? ?? 76 C0 C7 44 24 10 00 00 00 00 31 FF B8 01 00 00 00 C7 44 24 14 00 00 00 00 E9 B9 FB FF FF 8B 44 24 44 C1 E0 04 8B 90 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? EB 89 8B 7C 24 44 8B 14 FD ?? ?? ?? ?? 39 54 24 14 8B 04 FD ?? ?? ?? ?? 0F 87 AC 00 00 00 72 0A 39 44 24 10 0F 87 A0 00 00 00 8B 74 24 14 BF 01 00 00 00 31 D6 8B 54 24 10 31 C2 31 C0 09 D6 0F 85 23 FA FF FF 8B 74 24 0C 0B 74 24 08 75 0E 8B 54 24 54 0B 54 24 50 0F 84 57 FB FF FF 8B 44 24 44 C1 E0 04 8B 90 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 39 44 24 0C 77 7C 72 06 39 54 24 08 77 74 8B 74 24 0C 33 54 24 08 31 C6 31 C0 09 D6 74 07 31 FF E9 D3 F9 FF FF 8B 44 24 44 BA 01 00 00 00 8B 74 24 54 C1 E0 04 3B B0 ?? ?? ?? ?? 77 0E 72 15 8B 7C 24 50 3B B8 ?? ?? ?? ?? 76 09 89 D0 31 FF E9 A4 F9 FF FF 31 D2 89 D0 EB F3 8B 74 24 10 8B 7C 24 14 29 C6 19 D7 89 F0 39 7C 24 14 89 FA 72 12 77 06 39 74 24 10 72 0A 89 D7 09 C7 0F 84 6B FF FF FF B8 01 00 00 00 31 FF E9 6A F9 FF FF 8D B6 00 00 00 00 8D BF 00 00 00 00 }
	condition:
		$1
}

rule file_102_3_0 {
	meta:
		name = "___bid128_to_int32_xfloor"
		size = 3744
		refs = "00e8 ___bid_nr_digits 01ab ___bid_IDEC_glbflags 02a5 ___bid_ten2k64 03ee ___bid_midpoint64 0428 ___bid_ten2mk128 0799 ___bid_maskhigh128 07a0 ___bid_shiftright128 086e ___bid_ten2mk128trunc 0918 ___bid_onehalf128 09a6 ___bid_midpoint128 0bb6 ___bid_ten2k128"
	strings:
		$1 = { 81 EC 9C 00 00 00 8B 84 24 A0 00 00 00 89 B4 24 90 00 00 00 8B B4 24 AC 00 00 00 89 9C 24 8C 00 00 00 89 AC 24 98 00 00 00 89 44 24 70 8B 84 24 A4 00 00 00 8B 4C 24 70 89 F2 89 F5 81 E2 00 00 00 78 81 E5 00 00 00 80 81 FA 00 00 00 78 89 44 24 74 8B 5C 24 74 89 BC 24 94 00 00 00 8B 84 24 A8 00 00 00 89 4C 24 08 89 5C 24 0C 0F 84 25 01 00 00 89 F3 89 C1 81 E3 FF FF 01 00 81 FB 09 ED 01 00 0F 83 E8 00 00 00 89 DA 89 C8 81 F2 09 ED 01 00 35 C0 87 AD BE 09 C2 0F 84 71 01 00 00 89 F0 25 00 00 00 60 3D 00 00 00 60 0F 84 C1 00 00 00 89 DF 09 CF 0F 84 09 01 00 00 89 4C 24 68 89 5C 24 6C DF 6C 24 68 DD 5C 24 10 8B 54 24 14 89 D0 C1 E8 14 25 FF 07 00 00 2D BE 03 00 00 83 E8 01 89 C7 C1 E7 05 8B 97 ?? ?? ?? ?? 89 44 24 18 85 D2 75 34 8B 87 ?? ?? ?? ?? 8B 97 ?? ?? ?? ?? 8B BF ?? ?? ?? ?? 89 44 24 10 39 FB 0F 87 5E 01 00 00 0F 83 AA 02 00 00 8B 44 24 10 31 DF 31 C8 09 C7 0F 84 1E 01 00 00 81 E6 00 00 FE 7F C1 EE 11 81 EE 20 18 00 00 8D 04 32 83 F8 0A 0F 8F 61 02 00 00 0F 84 2F 01 00 00 85 C0 0F 8E A4 01 00 00 83 FE 00 0F 8C 76 02 00 00 8B 44 24 08 66 90 0F 85 AA 01 00 00 85 ED 74 0A F7 D8 EB 06 66 90 76 45 31 C0 8B 9C 24 8C 00 00 00 8B B4 24 90 00 00 00 8B BC 24 94 00 00 00 8B AC 24 98 00 00 00 81 C4 9C 00 00 00 C3 89 F0 25 00 00 00 7C 3D 00 00 00 7C 0F 84 8C 00 00 00 83 0D ?? ?? ?? ?? 01 B8 00 00 00 80 EB BD 3D C0 87 AD BE 0F 86 C6 FE FF FF EB AE 8B 44 24 0C 0B 44 24 08 74 A4 81 7C 24 0C FF FF 1F 00 0F 86 4B 01 00 00 8B 54 24 0C 89 D0 31 D2 89 44 24 68 89 54 24 6C DF 6C 24 68 DD 5C 24 10 8B 54 24 14 89 D0 C1 E8 14 25 FF 07 00 00 2D DE 03 00 00 E9 D2 FE FF FF 8D 74 26 00 81 7C 24 0C 63 8E 8D 37 0F 87 54 FF FF FF 89 F0 25 00 00 00 60 3D 00 00 00 60 0F 85 8B FE FF FF E9 3D FF FF FF 83 0D ?? ?? ?? ?? 01 B8 00 00 00 80 E9 2E FF FF FF 8B 44 24 18 8B 7C 24 0C C1 E0 05 05 ?? ?? ?? ?? 39 78 14 0F 87 C9 FE FF FF 72 0F 8B 7C 24 08 39 78 10 0F 87 BA FE FF FF 66 90 83 C2 01 E9 B0 FE FF FF 85 ED 0F 84 C7 00 00 00 83 FA 0B 0F 8F 3C 07 00 00 C7 44 24 10 0B 00 00 00 8B 7C 24 0C 29 54 24 10 8B 44 24 10 8B 54 24 08 0F AF 3C C5 ?? ?? ?? ?? 0F AF 14 C5 ?? ?? ?? ?? 8B 44 24 08 01 FA 8B 7C 24 10 89 54 24 18 F7 24 FD ?? ?? ?? ?? 8B 7C 24 18 89 44 24 10 01 FA 83 FA 05 89 54 24 14 0F 82 74 FE FF FF 0F 87 C1 00 00 00 83 7C 24 10 00 0F 86 63 FE FF FF 66 90 E9 AF 00 00 00 83 0D ?? ?? ?? ?? 20 85 ED B8 FF FF FF FF 0F 84 69 FE FF FF E9 66 FE FF FF 66 90 85 ED 0F 84 9D 00 00 00 F7 D8 0F AF 04 F5 ?? ?? ?? ?? E9 4D FE FF FF DF 6C 24 08 DD 5C 24 10 8B 54 24 14 89 D0 C1 E8 14 25 FF 07 00 00 2D FE 03 00 00 E9 97 FD FF FF 83 FA 0B 0F 8F 17 07 00 00 C7 44 24 10 0B 00 00 00 8B 7C 24 0C 29 54 24 10 8B 44 24 10 8B 54 24 08 0F AF 3C C5 ?? ?? ?? ?? 0F AF 14 C5 ?? ?? ?? ?? 8B 44 24 08 01 FA 8B 7C 24 10 89 54 24 18 F7 24 FD ?? ?? ?? ?? 8B 7C 24 18 89 44 24 10 01 FA 83 FA 04 89 54 24 14 0F 86 AD FD FF FF 83 0D ?? ?? ?? ?? 01 B8 00 00 00 80 E9 BF FD FF FF 0F AF 04 F5 ?? ?? ?? ?? E9 B2 FD FF FF 39 C1 0F 87 A6 FE FF FF E9 49 FD FF FF 90 89 F7 F7 DF 83 FF 13 89 7C 24 5C 0F 8F AF 05 00 00 F7 D6 8B 44 24 08 8B 54 24 0C 03 04 F5 ?? ?? ?? ?? 13 14 F5 ?? ?? ?? ?? 89 74 24 44 39 54 24 0C 72 0E 77 06 39 44 24 08 76 06 83 C1 01 83 D3 00 8B 7C 24 44 89 D6 89 44 24 28 C7 44 24 24 00 00 00 00 C1 E7 04 8B 87 ?? ?? ?? ?? 8B 97 ?? ?? ?? ?? 89 44 24 30 89 54 24 38 F7 E6 89 44 24 18 8B 44 24 38 89 54 24 1C F7 E6 89 44 24 10 8B 44 24 28 89 54 24 14 F7 64 24 30 89 54 24 4C 8B 54 24 18 89 44 24 48 89 54 24 20 8B 54 24 4C 89 D0 31 D2 89 44 24 08 8B 44 24 20 01 44 24 08 8B 44 24 28 89 54 24 0C 8B 54 24 24 11 54 24 0C F7 64 24 38 01 44 24 08 11 54 24 0C 8B 54 24 1C 89 D0 31 D2 89 44 24 18 8B 44 24 10 01 44 24 18 89 54 24 1C 8B 54 24 14 11 54 24 1C 8B 54 24 0C 89 D0 31 D2 01 44 24 18 11 54 24 1C 8B 97 ?? ?? ?? ?? 8B BF ?? ?? ?? ?? 89 D0 89 54 24 20 F7 E6 89 7C 24 58 89 44 24 10 89 F8 89 54 24 14 F7 E6 89 44 24 50 8B 44 24 28 89 54 24 54 F7 64 24 20 89 54 24 64 8B 7C 24 64 31 D2 89 44 24 60 8B 44 24 10 89 FE 31 FF 01 C6 8B 44 24 28 11 D7 F7 64 24 58 01 C6 11 D7 8B 54 24 14 89 D0 31 D2 89 44 24 10 8B 44 24 50 01 44 24 10 89 54 24 14 8B 54 24 54 11 54 24 14 89 FA 89 D0 31 D2 89 74 24 54 8B 74 24 08 01 44 24 10 11 54 24 14 31 C0 31 D2 89 44 24 50 8B 44 24 60 89 F7 01 44 24 50 11 54 24 54 31 F6 8B 44 24 48 31 D2 89 74 24 08 01 44 24 08 8B 44 24 10 89 7C 24 0C 11 54 24 0C 8B 54 24 14 01 44 24 08 11 54 24 0C 8B 74 24 0C 39 F2 72 14 77 08 8B 7C 24 08 39 F8 76 0A 83 44 24 18 01 83 54 24 1C 00 8B 44 24 30 F7 E3 89 44 24 10 8B 44 24 38 89 54 24 14 F7 E3 89 44 24 48 8B 44 24 30 89 54 24 4C F7 E1 89 54 24 34 8B 7C 24 34 31 D2 89 44 24 30 8B 44 24 10 89 FE 31 FF 89 74 24 28 01 44 24 28 8B 44 24 38 89 7C 24 2C 8B 7C 24 14 11 54 24 2C F7 E1 01 44 24 28 89 FE 11 54 24 2C 31 FF 8B 54 24 2C 89 74 24 10 8B 74 24 48 01 74 24 10 89 7C 24 14 8B 7C 24 4C 89 D0 11 7C 24 14 31 D2 01 44 24 10 8B 44 24 20 11 54 24 14 F7 E3 89 44 24 38 8B 44 24 58 89 54 24 3C F7 E3 8B 5C 24 3C 89 44 24 48 8B 44 24 20 89 54 24 4C F7 E1 89 54 24 24 8B 7C 24 24 31 D2 89 44 24 20 8B 44 24 38 C7 44 24 24 00 00 00 00 89 FE 31 FF 01 C6 8B 44 24 58 11 D7 F7 E1 89 D9 01 C6 11 D7 31 DB 03 4C 24 48 89 FA 13 5C 24 4C 89 D0 31 D2 01 C1 11 D3 31 C0 89 44 24 38 8B 44 24 20 31 D2 89 74 24 3C 8B 74 24 30 01 44 24 38 8B 44 24 28 11 54 24 3C 89 74 24 20 89 C2 31 C0 03 44 24 20 13 54 24 24 01 C8 11 DA 39 D3 72 10 77 04 39 C1 76 0A 83 44 24 10 01 83 54 24 14 00 8B 5C 24 08 B9 01 00 00 00 03 5C 24 38 8B 74 24 0C 13 74 24 3C 89 5C 24 08 31 DB 39 74 24 3C 89 74 24 0C 77 10 72 0A 8B 74 24 08 39 74 24 38 77 04 31 C9 31 DB 8B 74 24 18 01 C8 8B 7C 24 1C 11 DA 01 C6 11 D7 39 FA 0F 87 49 02 00 00 72 08 39 F0 0F 87 3F 02 00 00 39 D3 C7 44 24 18 01 00 00 00 C7 44 24 1C 00 00 00 00 77 16 72 04 39 C1 77 10 C7 44 24 18 00 00 00 00 C7 44 24 1C 00 00 00 00 8B 44 24 18 8B 54 24 1C 8B 4C 24 10 8B 5C 24 14 01 C1 11 D3 83 7C 24 5C 16 89 4C 24 28 89 5C 24 2C 0F 8F 2F 01 00 00 8B 5C 24 44 8B 04 DD ?? ?? ?? ?? 8B 0C 9D ?? ?? ?? ?? 8B 14 DD ?? ?? ?? ?? BB 40 00 00 00 21 F0 89 44 24 18 0F AD FE 31 C0 21 FA D3 EF F6 C1 20 0F 45 F7 0F 45 F8 8B 44 24 28 89 54 24 1C 8B 54 24 2C 29 CB 89 D9 31 DB 0F A5 C2 D3 E0 F6 C1 20 0F 45 D0 0F 45 C3 89 C3 89 D1 09 F3 09 F9 83 7C 24 5C 03 89 5C 24 10 89 4C 24 14 0F 8F AF 05 00 00 81 7C 24 0C 00 00 00 80 0F 87 20 03 00 00 72 0B 83 7C 24 08 00 0F 87 13 03 00 00 8B 44 24 0C 05 00 00 00 80 0B 44 24 08 0F 84 91 04 00 00 83 0D ?? ?? ?? ?? 20 BA 01 00 00 00 31 C0 8B 7C 24 1C 0B 7C 24 18 0F 85 04 01 00 00 8B 4C 24 0C 0B 4C 24 08 75 0E 8B 5C 24 54 0B 5C 24 50 0F 84 EC 00 00 00 8B 4C 24 44 C1 E1 04 8B B9 ?? ?? ?? ?? 39 7C 24 0C 8B B1 ?? ?? ?? ?? 0F 82 1B 04 00 00 77 0A 39 74 24 08 0F 82 0F 04 00 00 33 7C 24 0C 31 C9 33 74 24 08 31 DB 09 F7 0F 84 D2 03 00 00 85 ED 0F 85 B6 00 00 00 09 D3 74 0A 83 44 24 10 FF 83 54 24 14 FF 8B 44 24 10 E9 B3 F8 FF FF 8B 5C 24 44 8B 44 24 28 8B 54 24 2C 23 04 DD ?? ?? ?? ?? 23 14 DD ?? ?? ?? ?? 8B 0C 9D ?? ?? ?? ?? 89 44 24 30 8B 44 24 28 89 54 24 20 8B 54 24 2C 89 CB 83 EB 40 89 D9 31 DB 0F AD D0 D3 EA F6 C1 20 0F 45 C2 0F 45 D3 8B 5C 24 44 89 44 24 10 89 54 24 14 8B 04 DD ?? ?? ?? ?? 39 44 24 20 8B 14 DD ?? ?? ?? ?? 0F 86 CB 01 00 00 83 0D ?? ?? ?? ?? 20 31 D2 B8 01 00 00 00 89 74 24 18 89 7C 24 1C 8B 74 24 20 0B 74 24 30 0F 84 EE FE FF FF 31 C9 31 DB E9 48 FF FF FF 8D B6 00 00 00 00 09 C1 74 0A 83 44 24 10 01 83 54 24 14 00 8B 44 24 10 F7 D8 E9 FB F7 FF FF 8D B4 26 00 00 00 00 B8 01 00 00 00 31 D2 E9 E7 FD FF FF 8D 74 26 00 BF EC FF FF FF 8B 44 24 08 29 F7 8B 54 24 0C F7 D6 C1 E7 04 03 87 ?? ?? ?? ?? 89 74 24 44 13 97 ?? ?? ?? ?? 03 8F ?? ?? ?? ?? 13 9F ?? ?? ?? ?? E9 38 FA FF FF 83 FA 1E 0F 8F 37 02 00 00 8D 7A F5 B8 05 00 00 00 F7 24 FD ?? ?? ?? ?? 89 54 24 14 89 44 24 10 B8 05 00 00 00 F7 24 FD ?? ?? ?? ?? 89 54 24 1C 8B 54 24 14 89 44 24 18 89 D0 31 D2 89 44 24 20 8B 44 24 18 89 54 24 24 8B 54 24 1C 01 44 24 20 11 54 24 24 3B 5C 24 24 0F 87 81 F9 FF FF 72 0A 3B 4C 24 20 0F 87 75 F9 FF FF 8B 54 24 24 8B 44 24 20 31 DA 31 C8 09 C2 0F 85 0E F7 FF FF 8B 54 24 10 39 54 24 0C 0F 82 00 F7 FF FF 0F 87 4D F9 FF FF 83 7C 24 08 00 0F 86 EF F6 FF FF E9 3D F9 FF FF 83 FA 1E 0F 8F 39 01 00 00 8D 7A F5 B8 05 00 00 00 F7 24 FD ?? ?? ?? ?? 89 54 24 14 89 44 24 10 B8 05 00 00 00 F7 24 FD ?? ?? ?? ?? 89 54 24 1C 8B 54 24 14 89 44 24 18 89 D0 31 D2 89 44 24 20 8B 44 24 18 89 54 24 24 8B 54 24 1C 01 44 24 20 11 54 24 24 3B 5C 24 24 0F 87 DF F8 FF FF 72 0A 3B 4C 24 20 0F 87 D3 F8 FF FF 8B 54 24 24 8B 44 24 20 31 DA 31 C8 09 C2 0F 85 6C F6 FF FF 8B 54 24 10 39 54 24 0C 0F 82 5E F6 FF FF E9 AC F8 FF FF 72 0C 39 54 24 30 66 90 0F 87 27 FE FF FF 33 44 24 20 33 54 24 30 09 D0 0F 84 E6 01 00 00 83 0D ?? ?? ?? ?? 20 BA 01 00 00 00 31 C0 89 74 24 18 89 7C 24 1C E9 12 FE FF FF 8B 44 24 08 8B 54 24 0C 8B 4C 24 44 83 C0 00 81 D2 00 00 00 80 C1 E1 04 8B 99 ?? ?? ?? ?? 8B 89 ?? ?? ?? ?? 39 CA 0F 87 04 01 00 00 72 08 39 D8 0F 87 FA 00 00 00 31 D1 31 C3 31 D2 31 C0 09 D9 0F 85 C8 FC FF FF 8B 44 24 44 8B 7C 24 54 C1 E0 04 3B B8 ?? ?? ?? ?? 72 16 0F 87 D1 00 00 00 8B 54 24 50 3B 90 ?? ?? ?? ?? 0F 83 C1 00 00 00 31 D2 31 C0 E9 96 FC FF FF 8D 7A E1 B8 05 00 00 00 C1 E7 04 F7 A7 ?? ?? ?? ?? 89 44 24 18 B8 05 00 00 00 89 54 24 1C F7 A7 ?? ?? ?? ?? 89 54 24 24 8B 54 24 18 89 44 24 20 31 C0 01 44 24 20 89 54 24 10 8B 97 ?? ?? ?? ?? 8D 14 92 11 54 24 24 8B 54 24 1C 89 D0 31 D2 01 44 24 20 11 54 24 24 E9 B6 FE FF FF 8D 7A E1 B8 05 00 00 00 C1 E7 04 F7 A7 ?? ?? ?? ?? 89 44 24 18 B8 05 00 00 00 89 54 24 1C F7 A7 ?? ?? ?? ?? 89 54 24 24 8B 54 24 18 89 44 24 20 31 C0 01 44 24 20 89 54 24 10 8B 97 ?? ?? ?? ?? 8D 14 92 11 54 24 24 8B 54 24 1C 89 D0 31 D2 01 44 24 20 11 54 24 24 E9 B8 FD FF FF 83 0D ?? ?? ?? ?? 20 31 D2 B8 01 00 00 00 E9 CB FB FF FF 8B 4C 24 44 8B 74 24 54 C1 E1 04 3B B1 ?? ?? ?? ?? 0F 87 C6 FC FF FF 72 10 8B 7C 24 50 3B B9 ?? ?? ?? ?? 0F 87 B4 FC FF FF 8B 44 24 10 83 E0 01 85 C0 74 44 83 44 24 10 FF B9 01 00 00 00 83 54 24 14 FF 31 DB 31 D2 31 C0 E9 E0 FB FF FF 8B 74 24 54 0B 74 24 50 0F 84 61 FB FF FF 8B 44 24 44 31 D2 C1 E0 04 8B 98 ?? ?? ?? ?? 8B 88 ?? ?? ?? ?? 31 C0 E9 7B FE FF FF 31 C9 BB 01 00 00 00 31 D2 31 C0 E9 A6 FB FF FF 89 FB 09 F3 0F 85 27 FC FF FF 8B 44 24 0C 0B 44 24 08 75 40 8B 54 24 54 0B 54 24 50 0F 84 F8 FD FF FF 8B 44 24 44 C1 E0 04 8B 90 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 39 44 24 0C 74 4B C7 44 24 18 00 00 00 00 31 D2 31 C0 C7 44 24 1C 00 00 00 00 E9 F3 FB FF FF 8B 44 24 44 C1 E0 04 8B 90 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 39 44 24 0C 0F 87 C0 FB FF FF 72 C2 39 54 24 08 0F 87 B4 FB FF FF 8D B4 26 00 00 00 00 EB AF 39 54 24 08 75 AF 8B 44 24 44 8B 4C 24 54 C1 E0 04 3B 88 ?? ?? ?? ?? 72 9C 0F 87 8C FB FF FF 8B 5C 24 50 3B 98 ?? ?? ?? ?? 76 8A E9 7B FB FF FF 8B 5C 24 44 8B 14 DD ?? ?? ?? ?? 39 54 24 1C 8B 04 DD ?? ?? ?? ?? 0F 87 96 00 00 00 72 0A 39 44 24 18 0F 87 8A 00 00 00 33 54 24 1C 33 44 24 18 09 C2 0F 85 47 FA FF FF 8B 4C 24 0C 0B 4C 24 08 75 0E 8B 5C 24 54 0B 5C 24 50 0F 84 2F FA FF FF 8B 44 24 44 C1 E0 04 8B 90 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 39 44 24 0C 77 71 72 06 39 54 24 08 77 69 8B 4C 24 0C 33 54 24 08 31 C1 31 C0 09 D1 74 07 31 D2 E9 05 FA FF FF 8B 44 24 44 8B 54 24 54 C1 E0 04 3B 90 ?? ?? ?? ?? 72 0E 77 3D 8B 4C 24 50 3B 88 ?? ?? ?? ?? 77 31 31 C0 31 D2 E9 DB F9 FF FF 8B 74 24 18 8B 7C 24 1C 29 C6 19 D7 89 F0 39 7C 24 1C 89 FA 72 12 77 06 39 74 24 18 72 0A 89 D7 09 C7 0F 84 76 FF FF FF 83 0D ?? ?? ?? ?? 20 B8 01 00 00 00 31 D2 E9 A0 F9 FF FF 90 }
	condition:
		$1
}

rule file_102_4_0 {
	meta:
		name = "___bid128_to_int32_ceil"
		size = 4352
		refs = "0112 ___bid_nr_digits 01a7 ___bid_IDEC_glbflags 02a8 ___bid_ten2k64 03de ___bid_midpoint64 0418 ___bid_ten2mk128 075a ___bid_maskhigh128 0761 ___bid_shiftright128 081d ___bid_ten2mk128trunc 08a3 ___bid_onehalf128 0936 ___bid_midpoint128 0c6c ___bid_ten2k128"
	strings:
		$1 = { 81 EC 9C 00 00 00 8B 84 24 A0 00 00 00 8B 8C 24 AC 00 00 00 89 B4 24 90 00 00 00 89 9C 24 8C 00 00 00 89 44 24 70 8B 84 24 A4 00 00 00 8B 5C 24 70 89 CA 81 E2 00 00 00 78 89 BC 24 94 00 00 00 89 44 24 74 8B 74 24 74 89 AC 24 98 00 00 00 8B 84 24 A8 00 00 00 89 5C 24 08 89 74 24 0C 89 CE 81 E6 00 00 00 80 81 FA 00 00 00 78 89 74 24 58 0F 84 1D 01 00 00 89 CF 89 C6 81 E7 FF FF 01 00 81 FF 09 ED 01 00 76 28 31 C0 8B 9C 24 8C 00 00 00 8B B4 24 90 00 00 00 8B BC 24 94 00 00 00 8B AC 24 98 00 00 00 81 C4 9C 00 00 00 C3 8D 76 00 0F 83 00 01 00 00 89 FA 89 F0 81 F2 09 ED 01 00 35 C0 87 AD BE 09 C2 0F 84 47 01 00 00 89 C8 25 00 00 00 60 3D 00 00 00 60 74 AD 89 FD 09 F5 0F 84 E1 00 00 00 89 74 24 68 89 7C 24 6C DF 6C 24 68 DD 5C 24 18 8B 54 24 1C 89 D0 C1 E8 14 25 FF 07 00 00 2D BE 03 00 00 83 E8 01 89 C3 C1 E3 05 8B 93 ?? ?? ?? ?? 85 D2 75 2C 8B 93 ?? ?? ?? ?? 8B AB ?? ?? ?? ?? 8B 9B ?? ?? ?? ?? 39 DF 0F 87 41 01 00 00 0F 83 76 02 00 00 31 FB 31 F5 09 EB 0F 84 0B 01 00 00 81 E1 00 00 FE 7F C1 E9 11 81 E9 20 18 00 00 8D 1C 0A 83 FB 0A 7F 48 0F 84 1D 01 00 00 85 DB 0F 8E 85 01 00 00 83 F9 00 66 90 0F 8C 4A 02 00 00 8B 44 24 08 0F 85 80 01 00 00 8B 54 24 58 85 D2 0F 84 FE FE FF FF F7 D8 E9 F7 FE FF FF 89 C8 25 00 00 00 7C 3D 00 00 00 7C 0F 84 9B 00 00 00 83 0D ?? ?? ?? ?? 01 B8 00 00 00 80 E9 D4 FE FF FF 3D C0 87 AD BE 0F 87 C7 FE FF FF E9 F0 FE FF FF 8B 54 24 0C 31 C0 0B 54 24 08 0F 84 B4 FE FF FF 81 7C 24 0C FF FF 1F 00 0F 86 3C 01 00 00 8B 54 24 0C 89 D0 31 D2 89 44 24 68 89 54 24 6C DF 6C 24 68 DD 5C 24 18 8B 54 24 1C 89 D0 C1 E8 14 25 FF 07 00 00 2D DE 03 00 00 E9 F4 FE FF FF 31 C0 81 7C 24 0C 63 8E 8D 37 0F 87 66 FE FF FF 89 CA 81 E2 00 00 00 60 81 FA 00 00 00 60 0F 85 AD FE FF FF E9 4D FE FF FF 8D 76 00 83 0D ?? ?? ?? ?? 01 B8 00 00 00 80 E9 39 FE FF FF C1 E0 05 8B 5C 24 0C 05 ?? ?? ?? ?? 39 58 14 0F 87 E0 FE FF FF 72 0D 8B 6C 24 08 39 68 10 0F 87 D1 FE FF FF 83 C2 01 E9 C9 FE FF FF 8D 76 00 8B 6C 24 58 85 ED 0F 84 B4 00 00 00 83 FA 0B 0F 8F C0 06 00 00 BD 0B 00 00 00 8B 5C 24 0C 29 D5 8B 54 24 08 0F AF 14 ED ?? ?? ?? ?? 0F AF 1C ED ?? ?? ?? ?? 8B 44 24 08 01 D3 F7 24 ED ?? ?? ?? ?? 01 DA 83 FA 05 89 44 24 10 89 54 24 14 0F 82 97 FE FF FF 0F 87 CB FE FF FF 83 7C 24 10 09 0F 86 86 FE FF FF E9 BB FE FF FF 8D B6 00 00 00 00 8B 54 24 58 31 C0 85 D2 0F 94 C0 E9 8A FD FF FF 8B 6C 24 58 85 ED 0F 84 94 00 00 00 F7 D8 0F AF 04 CD ?? ?? ?? ?? E9 6F FD FF FF 90 8D 74 26 00 DF 6C 24 08 DD 5C 24 18 8B 54 24 1C 89 D0 C1 E8 14 25 FF 07 00 00 2D FE 03 00 00 E9 C8 FD FF FF 83 FA 0B 0F 8F 37 07 00 00 BD 0B 00 00 00 8B 5C 24 0C 29 D5 8B 54 24 08 0F AF 14 ED ?? ?? ?? ?? 0F AF 1C ED ?? ?? ?? ?? 8B 44 24 08 01 D3 F7 24 ED ?? ?? ?? ?? 01 DA 83 FA 04 89 44 24 10 89 54 24 14 0F 82 E3 FD FF FF 0F 87 17 FE FF FF 83 7C 24 10 F6 0F 86 D2 FD FF FF E9 07 FE FF FF 66 90 0F AF 04 CD ?? ?? ?? ?? E9 DD FC FF FF 8D 76 00 39 EE 0F 87 BD FE FF FF E9 7D FD FF FF 8D 76 00 89 CD F7 DD 83 FD 13 89 6C 24 5C 0F 8F 4F 05 00 00 F7 D1 8B 44 24 08 8B 54 24 0C 03 04 CD ?? ?? ?? ?? 13 14 CD ?? ?? ?? ?? 89 4C 24 38 39 54 24 0C 72 0E 77 06 39 44 24 08 76 06 83 C6 01 83 D7 00 8B 5C 24 38 89 D1 89 44 24 30 C7 44 24 24 00 00 00 00 C1 E3 04 8B AB ?? ?? ?? ?? 89 6C 24 28 8B 44 24 28 8B AB ?? ?? ?? ?? F7 E2 89 6C 24 40 89 44 24 18 89 E8 89 54 24 1C F7 E1 89 44 24 10 8B 44 24 30 89 54 24 14 F7 64 24 28 89 54 24 4C 8B 54 24 18 89 44 24 48 89 54 24 20 8B 54 24 4C 89 D0 31 D2 89 44 24 08 8B 44 24 20 01 44 24 08 8B 44 24 30 89 54 24 0C 8B 54 24 24 11 54 24 0C F7 E5 01 44 24 08 11 54 24 0C 8B 54 24 1C 89 D0 31 D2 89 44 24 18 8B 44 24 10 01 44 24 18 8B AB ?? ?? ?? ?? 89 54 24 1C 8B 54 24 14 11 54 24 1C 8B 54 24 0C 89 6C 24 20 8B AB ?? ?? ?? ?? 89 D0 31 D2 01 44 24 18 8B 44 24 20 11 54 24 1C F7 E1 89 44 24 10 89 C8 89 54 24 14 F7 E5 89 44 24 50 8B 44 24 30 89 54 24 54 F7 64 24 20 89 54 24 64 8B 5C 24 64 31 D2 89 44 24 60 8B 44 24 10 89 D9 31 DB 01 C1 8B 44 24 30 11 D3 F7 E5 01 C1 11 D3 8B 54 24 14 89 D0 31 D2 89 44 24 10 8B 44 24 50 89 54 24 14 8B 54 24 54 01 44 24 10 11 54 24 14 89 DA 89 D0 31 D2 89 4C 24 54 8B 4C 24 08 01 44 24 10 11 54 24 14 31 C0 31 D2 89 44 24 50 8B 44 24 60 89 CB 01 44 24 50 11 54 24 54 31 C9 8B 44 24 48 31 D2 89 4C 24 08 01 44 24 08 8B 44 24 10 89 5C 24 0C 11 54 24 0C 8B 54 24 14 01 44 24 08 11 54 24 0C 8B 4C 24 0C 39 CA 72 14 77 08 8B 5C 24 08 39 D8 76 0A 83 44 24 18 01 83 54 24 1C 00 8B 44 24 28 89 F9 89 F7 F7 E1 89 44 24 10 8B 44 24 40 89 54 24 14 F7 E1 89 44 24 48 8B 44 24 28 89 54 24 4C F7 E6 89 54 24 2C 8B 74 24 2C 31 D2 89 44 24 28 8B 44 24 10 89 F3 31 F6 89 5C 24 30 01 44 24 30 8B 44 24 40 89 74 24 34 8B 74 24 14 11 54 24 34 F7 E7 01 44 24 30 89 F3 11 54 24 34 31 F6 8B 54 24 34 89 5C 24 10 8B 5C 24 48 01 5C 24 10 89 74 24 14 8B 74 24 4C 89 D0 11 74 24 14 31 D2 01 44 24 10 8B 44 24 20 11 54 24 14 F7 E1 89 44 24 40 89 C8 89 54 24 44 F7 E5 89 44 24 48 8B 44 24 20 89 54 24 4C F7 E7 89 54 24 24 8B 5C 24 24 31 D2 89 44 24 20 8B 44 24 40 C7 44 24 24 00 00 00 00 89 D9 31 DB 01 C1 89 F8 8B 7C 24 44 11 D3 F7 E5 8B 6C 24 28 89 FE 01 C1 8B 44 24 20 11 D3 31 FF 03 74 24 48 13 7C 24 4C 31 D2 89 6C 24 20 01 DE 89 CB 11 D7 31 C9 31 D2 01 C1 8B 44 24 30 11 D3 89 C2 31 C0 03 44 24 20 13 54 24 24 01 F0 11 FA 39 D7 72 10 77 04 39 C6 76 0A 83 44 24 10 01 83 54 24 14 00 8B 74 24 08 8B 7C 24 0C 01 CE 11 DF 89 7C 24 0C 31 FF 3B 5C 24 0C 89 74 24 08 BE 01 00 00 00 77 0C 72 06 3B 4C 24 08 77 04 31 F6 31 FF 8B 4C 24 18 01 F0 8B 5C 24 1C 11 FA 01 C1 11 D3 39 DA 89 4C 24 18 89 5C 24 1C 0F 87 FB 01 00 00 72 08 39 C8 0F 87 F1 01 00 00 31 DB 39 D7 B9 01 00 00 00 77 0A 72 04 39 C6 77 04 31 C9 31 DB 89 C8 89 DA 03 44 24 10 13 54 24 14 83 7C 24 5C 16 0F 8F 26 01 00 00 8B 5C 24 38 8B 74 24 18 8B 7C 24 1C 23 34 DD ?? ?? ?? ?? 8B 0C 9D ?? ?? ?? ?? 23 3C DD ?? ?? ?? ?? 89 74 24 10 8B 5C 24 18 8B 74 24 1C 89 7C 24 14 31 FF 0F AD F3 D3 EE F6 C1 20 0F 45 DE 0F 45 F7 89 5C 24 18 BB 40 00 00 00 8B 7C 24 18 29 CB 31 ED 89 D9 D3 E0 F6 C3 20 0F 45 C5 09 C7 83 7C 24 5C 03 89 74 24 1C 0F 8F 3B 08 00 00 81 7C 24 0C 00 00 00 80 0F 87 26 04 00 00 72 0B 83 7C 24 08 00 0F 87 19 04 00 00 8B 54 24 0C 31 C0 B9 01 00 00 00 81 C2 00 00 00 80 0B 54 24 08 0F 84 EE 06 00 00 8B 54 24 14 0B 54 24 10 0F 85 F9 00 00 00 8B 5C 24 0C 0B 5C 24 08 75 0E 8B 74 24 54 0B 74 24 50 0F 84 E1 00 00 00 8B 54 24 38 C1 E2 04 8B B2 ?? ?? ?? ?? 39 74 24 0C 8B 9A ?? ?? ?? ?? 0F 82 8F 06 00 00 77 0A 39 5C 24 08 0F 82 83 06 00 00 33 5C 24 08 31 D2 33 74 24 0C 89 5C 24 08 31 DB 0B 74 24 08 0F 84 40 06 00 00 8B 74 24 58 85 F6 0F 85 9D 00 00 00 09 C3 74 03 83 C7 01 89 F8 E9 19 F8 FF FF 8B 5C 24 38 8B 34 DD ?? ?? ?? ?? 89 DF 8B 2C BD ?? ?? ?? ?? 89 C7 8B 1C DD ?? ?? ?? ?? 21 C6 8B 44 24 38 89 E9 89 D5 83 E9 40 21 D3 0F AD D7 8B 14 C5 ?? ?? ?? ?? D3 ED F6 C1 20 8B 04 C5 ?? ?? ?? ?? 0F 45 FD 39 C3 0F 87 12 03 00 00 72 08 39 D6 0F 87 08 03 00 00 31 D8 31 F2 09 D0 66 90 0F 84 40 06 00 00 8B 4C 24 1C 31 C0 8B 54 24 18 89 4C 24 14 B9 01 00 00 00 89 54 24 10 09 F3 0F 84 F9 FE FF FF 31 DB 31 D2 E9 59 FF FF FF 66 90 09 CA 74 03 83 C7 FF 89 F8 F7 D8 E9 7A F7 FF FF B8 01 00 00 00 31 D2 E9 1C FE FF FF 8D 74 26 00 BB EC FF FF FF 8B 44 24 08 29 CB 8B 54 24 0C F7 D1 C1 E3 04 03 83 ?? ?? ?? ?? 89 4C 24 38 13 93 ?? ?? ?? ?? 03 B3 ?? ?? ?? ?? 13 BB ?? ?? ?? ?? E9 98 FA FF FF 83 FA 1E 0F 8F 2F 04 00 00 83 EA 0B B8 05 00 00 00 8B 2C D5 ?? ?? ?? ?? C7 44 24 34 00 00 00 00 89 6C 24 28 8B 2C D5 ?? ?? ?? ?? F7 64 24 28 89 44 24 18 B8 05 00 00 00 89 54 24 1C F7 E5 89 44 24 20 8B 44 24 28 89 54 24 24 F7 E3 89 54 24 2C 8B 54 24 18 89 44 24 28 89 54 24 30 8B 54 24 2C 89 D0 31 D2 89 44 24 10 8B 44 24 30 01 44 24 10 89 E8 89 54 24 14 8B 54 24 34 11 54 24 14 F7 E3 01 44 24 10 11 54 24 14 8B 54 24 1C 89 D0 31 D2 89 44 24 18 8B 44 24 20 89 54 24 1C 8B 54 24 24 01 44 24 18 11 54 24 1C 8B 54 24 14 89 D0 31 D2 01 44 24 18 8B 44 24 10 11 54 24 1C 89 C2 31 C0 89 44 24 10 8B 44 24 28 89 54 24 14 31 D2 01 44 24 10 11 54 24 14 3B 7C 24 1C 0F 87 70 F7 FF FF 72 0A 3B 74 24 18 0F 87 64 F7 FF FF 8B 44 24 1C 8B 54 24 18 31 F8 31 F2 09 D0 0F 85 16 F7 FF FF 8B 54 24 14 39 54 24 0C 0F 82 08 F7 FF FF 0F 87 3C F7 FF FF 8B 5C 24 10 39 5C 24 08 0F 82 F4 F6 FF FF E9 29 F7 FF FF 8D 74 26 00 83 FA 1E 0F 8F DB 01 00 00 8D 5A F5 8B 14 DD ?? ?? ?? ?? 8B 1C DD ?? ?? ?? ?? C7 44 24 14 00 00 00 00 C7 44 24 2C 00 00 00 00 89 54 24 28 8B 54 24 14 89 5C 24 10 8B 44 24 10 BB F6 FF FF FF C7 44 24 34 00 00 00 00 0F A4 C2 02 C1 E0 02 89 44 24 18 8B 44 24 28 89 54 24 1C 8B 54 24 2C 0F A4 C2 02 C1 E0 02 89 44 24 38 8B 44 24 10 89 54 24 3C F7 E3 89 54 24 24 8B 54 24 18 89 44 24 20 89 54 24 30 8B 54 24 24 89 D0 31 D2 89 44 24 10 8B 44 24 30 01 44 24 10 8B 44 24 28 89 54 24 14 8B 54 24 34 11 54 24 14 F7 E3 01 44 24 10 11 54 24 14 8B 54 24 1C 89 D0 31 D2 89 44 24 18 8B 44 24 38 01 44 24 18 89 54 24 1C 8B 54 24 3C 11 54 24 1C 8B 54 24 14 89 D0 31 D2 01 44 24 18 8B 44 24 10 11 54 24 1C 89 C2 31 C0 89 44 24 10 8B 44 24 20 89 54 24 14 31 D2 01 44 24 10 11 54 24 14 3B 7C 24 1C 0F 87 1C F6 FF FF 72 0A 3B 74 24 18 0F 87 10 F6 FF FF 8B 54 24 1C 8B 44 24 18 31 FA 31 F0 09 C2 0F 85 C2 F5 FF FF 8B 54 24 14 39 54 24 0C 0F 82 B4 F5 FF FF 0F 87 E8 F5 FF FF 8B 5C 24 10 39 5C 24 08 0F 86 A0 F5 FF FF E9 D5 F5 FF FF 8B 44 24 18 31 C9 8B 54 24 1C 89 44 24 10 B8 01 00 00 00 89 54 24 14 E9 01 FD FF FF 8B 44 24 08 8B 54 24 0C 8B 4C 24 38 83 C0 00 81 D2 00 00 00 80 C1 E1 04 8B 99 ?? ?? ?? ?? 8B 89 ?? ?? ?? ?? 39 CA 0F 87 73 02 00 00 72 08 39 D8 0F 87 69 02 00 00 31 CA 31 C3 31 C9 31 C0 09 DA 0F 85 BC FB FF FF 8B 44 24 38 8B 74 24 54 C1 E0 04 3B B0 ?? ?? ?? ?? 0F 87 42 02 00 00 72 10 8B 54 24 50 3B 90 ?? ?? ?? ?? 0F 83 30 02 00 00 31 C9 31 C0 E9 8A FB FF FF 8D 5A E1 C1 E3 04 8B 93 ?? ?? ?? ?? 8B AB ?? ?? ?? ?? C7 44 24 2C 00 00 00 00 C7 44 24 14 00 00 00 00 89 54 24 10 8B 54 24 2C 89 6C 24 28 8B 44 24 28 BD F6 FF FF FF C7 44 24 34 00 00 00 00 0F A4 C2 02 C1 E0 02 89 44 24 20 8B 44 24 10 89 54 24 24 8B 54 24 14 0F A4 C2 02 C1 E0 02 89 44 24 18 8B 44 24 28 89 54 24 1C F7 E5 89 54 24 3C 8B 54 24 20 89 44 24 38 89 54 24 30 8B 54 24 3C 89 D0 31 D2 89 44 24 28 8B 44 24 30 01 44 24 28 8B 44 24 10 89 54 24 2C 8B 54 24 34 11 54 24 2C F7 E5 01 44 24 28 11 54 24 2C 8B 44 24 28 89 C2 B8 00 00 00 00 89 44 24 10 8B 44 24 38 89 54 24 14 31 D2 01 44 24 10 11 54 24 14 6B 83 ?? ?? ?? ?? F6 8B 93 ?? ?? ?? ?? 8D 14 90 8B 83 ?? ?? ?? ?? 89 54 24 38 8B 5C 24 38 F7 E5 01 DA 89 44 24 30 8B 44 24 30 01 44 24 18 89 54 24 34 8B 54 24 34 11 54 24 1C 8B 54 24 24 89 D0 31 D2 01 44 24 18 11 54 24 1C 8B 54 24 2C 89 D0 31 D2 01 44 24 18 11 54 24 1C E9 F2 FD FF FF 8D 6A E1 B8 05 00 00 00 C1 E5 04 F7 A5 ?? ?? ?? ?? C7 44 24 14 00 00 00 00 89 44 24 38 B8 05 00 00 00 89 54 24 3C F7 A5 ?? ?? ?? ?? 89 44 24 18 8B 85 ?? ?? ?? ?? 89 54 24 1C F7 E3 89 54 24 24 8B 54 24 38 89 44 24 20 89 54 24 10 8B 54 24 24 89 D0 31 D2 89 44 24 28 8B 44 24 10 01 44 24 28 8B 85 ?? ?? ?? ?? 89 54 24 2C 8B 54 24 14 11 54 24 2C F7 E3 01 44 24 28 8B 44 24 28 11 54 24 2C 89 C2 B8 00 00 00 00 89 44 24 10 8B 44 24 20 89 54 24 14 31 D2 01 44 24 10 11 54 24 14 8B 85 ?? ?? ?? ?? 6B 95 ?? ?? ?? ?? 0A 8D 04 80 01 D0 89 44 24 20 8B 85 ?? ?? ?? ?? F7 E3 8B 5C 24 20 89 44 24 30 01 DA 8B 44 24 30 01 44 24 18 89 54 24 34 8B 54 24 34 11 54 24 1C 8B 54 24 3C 89 D0 31 D2 01 44 24 18 11 54 24 1C 8B 54 24 2C 89 D0 31 D2 01 44 24 18 11 54 24 1C E9 A0 FB FF FF 31 C9 B8 01 00 00 00 E9 57 F9 FF FF 8B 54 24 38 8B 5C 24 54 C1 E2 04 3B 9A ?? ?? ?? ?? 0F 87 47 FA FF FF 72 10 8B 74 24 50 3B B2 ?? ?? ?? ?? 0F 87 35 FA FF FF 89 F8 83 E0 01 85 C0 74 3D 83 C7 FF BB 01 00 00 00 31 D2 31 C9 31 C0 E9 7B F9 FF FF 8B 5C 24 54 0B 5C 24 50 0F 84 04 F9 FF FF 8B 44 24 38 31 D2 C1 E0 04 8B 98 ?? ?? ?? ?? 8B 88 ?? ?? ?? ?? 31 C0 E9 1C FD FF FF 31 DB BA 01 00 00 00 31 C9 31 C0 E9 41 F9 FF FF 8B 44 24 1C 0B 44 24 18 0F 85 AC FC FF FF 8B 54 24 0C 0B 54 24 08 75 2A 8B 4C 24 54 0B 4C 24 50 0F 85 A2 00 00 00 C7 44 24 10 00 00 00 00 B9 01 00 00 00 31 C0 C7 44 24 14 00 00 00 00 E9 95 F9 FF FF 8B 44 24 38 C1 E0 04 8B 90 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 39 44 24 0C 77 51 72 06 39 54 24 08 77 49 39 44 24 0C 8D 76 00 74 19 C7 44 24 10 00 00 00 00 31 C9 31 C0 C7 44 24 14 00 00 00 00 E9 52 F9 FF FF 39 54 24 08 75 E1 8B 44 24 38 8B 54 24 54 C1 E0 04 3B 90 ?? ?? ?? ?? 77 0E 72 CC 8B 4C 24 50 3B 88 ?? ?? ?? ?? 76 C0 C7 44 24 10 00 00 00 00 31 C9 B8 01 00 00 00 C7 44 24 14 00 00 00 00 E9 0F F9 FF FF 8B 44 24 38 C1 E0 04 8B 90 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? EB 86 8B 5C 24 38 8B 14 DD ?? ?? ?? ?? 39 54 }
	condition:
		$1
}

rule file_102_5_0 {
	meta:
		name = "___bid128_to_int32_xceil"
		size = 4320
		refs = "0112 ___bid_nr_digits 01a7 ___bid_IDEC_glbflags 02a8 ___bid_ten2k64 03de ___bid_midpoint64 0418 ___bid_ten2mk128 075a ___bid_maskhigh128 0761 ___bid_shiftright128 0823 ___bid_ten2mk128trunc 08b2 ___bid_onehalf128 0936 ___bid_midpoint128 0c89 ___bid_ten2k128"
	strings:
		$1 = { 81 EC 9C 00 00 00 8B 84 24 A0 00 00 00 8B 8C 24 AC 00 00 00 89 B4 24 90 00 00 00 89 9C 24 8C 00 00 00 89 44 24 70 8B 84 24 A4 00 00 00 8B 5C 24 70 89 CA 81 E2 00 00 00 78 89 BC 24 94 00 00 00 89 44 24 74 8B 74 24 74 89 AC 24 98 00 00 00 8B 84 24 A8 00 00 00 89 5C 24 08 89 74 24 0C 89 CE 81 E6 00 00 00 80 81 FA 00 00 00 78 89 74 24 58 0F 84 1D 01 00 00 89 CF 89 C6 81 E7 FF FF 01 00 81 FF 09 ED 01 00 76 28 31 C0 8B 9C 24 8C 00 00 00 8B B4 24 90 00 00 00 8B BC 24 94 00 00 00 8B AC 24 98 00 00 00 81 C4 9C 00 00 00 C3 8D 76 00 0F 83 00 01 00 00 89 FA 89 F0 81 F2 09 ED 01 00 35 C0 87 AD BE 09 C2 0F 84 47 01 00 00 89 C8 25 00 00 00 60 3D 00 00 00 60 74 AD 89 FD 09 F5 0F 84 E1 00 00 00 89 74 24 68 89 7C 24 6C DF 6C 24 68 DD 5C 24 18 8B 54 24 1C 89 D0 C1 E8 14 25 FF 07 00 00 2D BE 03 00 00 83 E8 01 89 C3 C1 E3 05 8B 93 ?? ?? ?? ?? 85 D2 75 2C 8B 93 ?? ?? ?? ?? 8B AB ?? ?? ?? ?? 8B 9B ?? ?? ?? ?? 39 DF 0F 87 41 01 00 00 0F 83 78 02 00 00 31 FB 31 F5 09 EB 0F 84 0B 01 00 00 81 E1 00 00 FE 7F C1 E9 11 81 E9 20 18 00 00 8D 1C 0A 83 FB 0A 7F 48 0F 84 1D 01 00 00 85 DB 0F 8E 85 01 00 00 83 F9 00 66 90 0F 8C 4A 02 00 00 8B 44 24 08 0F 85 87 01 00 00 8B 4C 24 58 85 C9 0F 84 FE FE FF FF F7 D8 E9 F7 FE FF FF 89 C8 25 00 00 00 7C 3D 00 00 00 7C 0F 84 9B 00 00 00 83 0D ?? ?? ?? ?? 01 B8 00 00 00 80 E9 D4 FE FF FF 3D C0 87 AD BE 0F 87 C7 FE FF FF E9 F0 FE FF FF 8B 54 24 0C 31 C0 0B 54 24 08 0F 84 B4 FE FF FF 81 7C 24 0C FF FF 1F 00 0F 86 3E 01 00 00 8B 54 24 0C 89 D0 31 D2 89 44 24 68 89 54 24 6C DF 6C 24 68 DD 5C 24 18 8B 54 24 1C 89 D0 C1 E8 14 25 FF 07 00 00 2D DE 03 00 00 E9 F4 FE FF FF 31 C0 81 7C 24 0C 63 8E 8D 37 0F 87 66 FE FF FF 89 CA 81 E2 00 00 00 60 81 FA 00 00 00 60 0F 85 AD FE FF FF E9 4D FE FF FF 8D 76 00 83 0D ?? ?? ?? ?? 01 B8 00 00 00 80 E9 39 FE FF FF C1 E0 05 8B 5C 24 0C 05 ?? ?? ?? ?? 39 58 14 0F 87 E0 FE FF FF 72 0D 8B 6C 24 08 39 68 10 0F 87 D1 FE FF FF 83 C2 01 E9 C9 FE FF FF 8D 76 00 8B 6C 24 58 85 ED 0F 84 B6 00 00 00 83 FA 0B 0F 8F C0 06 00 00 BD 0B 00 00 00 8B 5C 24 0C 29 D5 8B 54 24 08 0F AF 14 ED ?? ?? ?? ?? 0F AF 1C ED ?? ?? ?? ?? 8B 44 24 08 01 D3 F7 24 ED ?? ?? ?? ?? 01 DA 83 FA 05 89 44 24 10 89 54 24 14 0F 82 97 FE FF FF 0F 87 CB FE FF FF 83 7C 24 10 09 0F 86 86 FE FF FF E9 BB FE FF FF 8D B6 00 00 00 00 8B 54 24 58 31 C0 83 0D ?? ?? ?? ?? 20 85 D2 0F 94 C0 E9 83 FD FF FF 8B 54 24 58 85 D2 0F 84 92 00 00 00 F7 D8 0F AF 04 CD ?? ?? ?? ?? E9 68 FD FF FF DF 6C 24 08 DD 5C 24 18 8B 54 24 1C 89 D0 C1 E8 14 25 FF 07 00 00 2D FE 03 00 00 E9 C6 FD FF FF 83 FA 0B 0F 8F 35 07 00 00 BD 0B 00 00 00 8B 5C 24 0C 29 D5 8B 54 24 08 0F AF 14 ED ?? ?? ?? ?? 0F AF 1C ED ?? ?? ?? ?? 8B 44 24 08 01 D3 F7 24 ED ?? ?? ?? ?? 01 DA 83 FA 04 89 44 24 10 89 54 24 14 0F 82 E1 FD FF FF 0F 87 15 FE FF FF 83 7C 24 10 F6 0F 86 D0 FD FF FF 90 8D 74 26 00 E9 00 FE FF FF 0F AF 04 CD ?? ?? ?? ?? E9 D8 FC FF FF 39 EE 0F 87 BB FE FF FF E9 7B FD FF FF 90 89 CD F7 DD 83 FD 13 89 6C 24 5C 0F 8F 4F 05 00 00 F7 D1 8B 44 24 08 8B 54 24 0C 03 04 CD ?? ?? ?? ?? 13 14 CD ?? ?? ?? ?? 89 4C 24 38 39 54 24 0C 72 0E 77 06 39 44 24 08 76 06 83 C6 01 83 D7 00 8B 5C 24 38 89 D1 89 44 24 30 C7 44 24 24 00 00 00 00 C1 E3 04 8B AB ?? ?? ?? ?? 89 6C 24 28 8B 44 24 28 8B AB ?? ?? ?? ?? F7 E2 89 6C 24 40 89 44 24 18 89 E8 89 54 24 1C F7 E1 89 44 24 10 8B 44 24 30 89 54 24 14 F7 64 24 28 89 54 24 4C 8B 54 24 18 89 44 24 48 89 54 24 20 8B 54 24 4C 89 D0 31 D2 89 44 24 08 8B 44 24 20 01 44 24 08 8B 44 24 30 89 54 24 0C 8B 54 24 24 11 54 24 0C F7 E5 01 44 24 08 11 54 24 0C 8B 54 24 1C 89 D0 31 D2 89 44 24 18 8B 44 24 10 01 44 24 18 8B AB ?? ?? ?? ?? 89 54 24 1C 8B 54 24 14 11 54 24 1C 8B 54 24 0C 89 6C 24 20 8B AB ?? ?? ?? ?? 89 D0 31 D2 01 44 24 18 8B 44 24 20 11 54 24 1C F7 E1 89 44 24 10 89 C8 89 54 24 14 F7 E5 89 44 24 50 8B 44 24 30 89 54 24 54 F7 64 24 20 89 54 24 64 8B 5C 24 64 31 D2 89 44 24 60 8B 44 24 10 89 D9 31 DB 01 C1 8B 44 24 30 11 D3 F7 E5 01 C1 11 D3 8B 54 24 14 89 D0 31 D2 89 44 24 10 8B 44 24 50 89 54 24 14 8B 54 24 54 01 44 24 10 11 54 24 14 89 DA 89 D0 31 D2 89 4C 24 54 8B 4C 24 08 01 44 24 10 11 54 24 14 31 C0 31 D2 89 44 24 50 8B 44 24 60 89 CB 01 44 24 50 11 54 24 54 31 C9 8B 44 24 48 31 D2 89 4C 24 08 01 44 24 08 8B 44 24 10 89 5C 24 0C 11 54 24 0C 8B 54 24 14 01 44 24 08 11 54 24 0C 8B 4C 24 0C 39 CA 72 14 77 08 8B 5C 24 08 39 D8 76 0A 83 44 24 18 01 83 54 24 1C 00 8B 44 24 28 89 F9 89 F7 F7 E1 89 44 24 10 8B 44 24 40 89 54 24 14 F7 E1 89 44 24 48 8B 44 24 28 89 54 24 4C F7 E6 89 54 24 2C 8B 74 24 2C 31 D2 89 44 24 28 8B 44 24 10 89 F3 31 F6 89 5C 24 30 01 44 24 30 8B 44 24 40 89 74 24 34 8B 74 24 14 11 54 24 34 F7 E7 01 44 24 30 89 F3 11 54 24 34 31 F6 8B 54 24 34 89 5C 24 10 8B 5C 24 48 01 5C 24 10 89 74 24 14 8B 74 24 4C 89 D0 11 74 24 14 31 D2 01 44 24 10 8B 44 24 20 11 54 24 14 F7 E1 89 44 24 40 89 C8 89 54 24 44 F7 E5 89 44 24 48 8B 44 24 20 89 54 24 4C F7 E7 89 54 24 24 8B 5C 24 24 31 D2 89 44 24 20 8B 44 24 40 C7 44 24 24 00 00 00 00 89 D9 31 DB 01 C1 89 F8 8B 7C 24 44 11 D3 F7 E5 8B 6C 24 28 89 FE 01 C1 8B 44 24 20 11 D3 31 FF 03 74 24 48 13 7C 24 4C 31 D2 89 6C 24 20 01 DE 89 CB 11 D7 31 C9 31 D2 01 C1 8B 44 24 30 11 D3 89 C2 31 C0 03 44 24 20 13 54 24 24 01 F0 11 FA 39 D7 72 10 77 04 39 C6 76 0A 83 44 24 10 01 83 54 24 14 00 8B 74 24 08 8B 7C 24 0C 01 CE 11 DF 89 7C 24 0C 31 FF 3B 5C 24 0C 89 74 24 08 BE 01 00 00 00 77 0C 72 06 3B 4C 24 08 77 04 31 F6 31 FF 8B 4C 24 18 01 F0 8B 5C 24 1C 11 FA 01 C1 11 D3 39 DA 89 4C 24 18 89 5C 24 1C 0F 87 FB 01 00 00 72 08 39 C8 0F 87 F1 01 00 00 31 DB 39 D7 B9 01 00 00 00 77 0A 72 04 39 C6 77 04 31 C9 31 DB 89 C8 89 DA 03 44 24 10 13 54 24 14 83 7C 24 5C 16 0F 8F 35 01 00 00 8B 5C 24 38 8B 74 24 18 8B 7C 24 1C 23 34 DD ?? ?? ?? ?? 8B 0C 9D ?? ?? ?? ?? 23 3C DD ?? ?? ?? ?? 89 74 24 10 8B 5C 24 18 8B 74 24 1C 89 7C 24 14 31 FF 0F AD F3 D3 EE F6 C1 20 0F 45 DE 0F 45 F7 89 5C 24 18 BB 40 00 00 00 8B 7C 24 18 29 CB 31 ED 89 D9 D3 E0 F6 C3 20 0F 45 C5 09 C7 83 7C 24 5C 03 89 74 24 1C 0F 8F 3A 08 00 00 81 7C 24 0C 00 00 00 80 0F 87 43 04 00 00 72 0B 83 7C 24 08 00 0F 87 36 04 00 00 8B 44 24 0C 05 00 00 00 80 0B 44 24 08 0F 84 1A 07 00 00 83 0D ?? ?? ?? ?? 20 B8 01 00 00 00 31 D2 8B 4C 24 14 0B 4C 24 10 0F 85 F1 00 00 00 8B 5C 24 0C 0B 5C 24 08 75 0E 8B 74 24 54 0B 74 24 50 0F 84 D9 00 00 00 8B 4C 24 38 C1 E1 04 8B B1 ?? ?? ?? ?? 8B 89 ?? ?? ?? ?? 39 4C 24 0C 0F 82 AD 06 00 00 77 0A 39 74 24 08 0F 82 A1 06 00 00 33 4C 24 0C 31 DB 33 74 24 08 89 4C 24 18 31 C9 0B 74 24 18 0F 84 5E 06 00 00 8D 76 00 8B 74 24 58 85 F6 0F 85 94 00 00 00 09 D3 74 03 83 C7 01 89 F8 E9 10 F8 FF FF 8D B6 00 00 00 00 8B 5C 24 38 8B 34 DD ?? ?? ?? ?? 89 DF 8B 2C BD ?? ?? ?? ?? 89 C7 8B 1C DD ?? ?? ?? ?? 21 C6 8B 44 24 38 89 E9 89 D5 83 E9 40 21 D3 0F AD D7 8B 14 C5 ?? ?? ?? ?? D3 ED F6 C1 20 8B 04 C5 ?? ?? ?? ?? 0F 45 FD 39 C3 0F 86 03 03 00 00 8B 44 24 18 8B 54 24 1C 83 0D ?? ?? ?? ?? 20 89 44 24 10 31 C0 89 54 24 14 BA 01 00 00 00 09 F3 0F 84 01 FF FF FF 31 DB 31 C9 E9 64 FF FF FF 8D 74 26 00 09 C1 74 03 83 C7 FF 89 F8 F7 D8 E9 7A F7 FF FF B8 01 00 00 00 31 D2 E9 1C FE FF FF 8D 74 26 00 BB EC FF FF FF 8B 44 24 08 29 CB 8B 54 24 0C F7 D1 C1 E3 04 03 83 ?? ?? ?? ?? 89 4C 24 38 13 93 ?? ?? ?? ?? 03 B3 ?? ?? ?? ?? 13 BB ?? ?? ?? ?? E9 98 FA FF FF 83 FA 1E 0F 8F 4C 04 00 00 83 EA 0B B8 05 00 00 00 8B 2C D5 ?? ?? ?? ?? C7 44 24 34 00 00 00 00 89 6C 24 28 8B 2C D5 ?? ?? ?? ?? F7 64 24 28 89 44 24 18 B8 05 00 00 00 89 54 24 1C F7 E5 89 44 24 20 8B 44 24 28 89 54 24 24 F7 E3 89 54 24 2C 8B 54 24 18 89 44 24 28 89 54 24 30 8B 54 24 2C 89 D0 31 D2 89 44 24 10 8B 44 24 30 01 44 24 10 89 E8 89 54 24 14 8B 54 24 34 11 54 24 14 F7 E3 01 44 24 10 11 54 24 14 8B 54 24 1C 89 D0 31 D2 89 44 24 18 8B 44 24 20 89 54 24 1C 8B 54 24 24 01 44 24 18 11 54 24 1C 8B 54 24 14 89 D0 31 D2 01 44 24 18 8B 44 24 10 11 54 24 1C 89 C2 31 C0 89 44 24 10 8B 44 24 28 89 54 24 14 31 D2 01 44 24 10 11 54 24 14 3B 7C 24 1C 0F 87 70 F7 FF FF 72 0A 3B 74 24 18 0F 87 64 F7 FF FF 8B 44 24 1C 8B 54 24 18 31 F8 31 F2 09 D0 0F 85 16 F7 FF FF 8B 54 24 14 39 54 24 0C 0F 82 08 F7 FF FF 0F 87 3C F7 FF FF 8B 5C 24 10 39 5C 24 08 0F 82 F4 F6 FF FF E9 29 F7 FF FF 8D 74 26 00 83 FA 1E 0F 8F F8 01 00 00 8D 5A F5 8B 14 DD ?? ?? ?? ?? 8B 1C DD ?? ?? ?? ?? C7 44 24 14 00 00 00 00 C7 44 24 2C 00 00 00 00 89 54 24 28 8B 54 24 14 89 5C 24 10 8B 44 24 10 BB F6 FF FF FF C7 44 24 34 00 00 00 00 0F A4 C2 02 C1 E0 02 89 44 24 18 8B 44 24 28 89 54 24 1C 8B 54 24 2C 0F A4 C2 02 C1 E0 02 89 44 24 38 8B 44 24 10 89 54 24 3C F7 E3 89 54 24 24 8B 54 24 18 89 44 24 20 89 54 24 30 8B 54 24 24 89 D0 31 D2 89 44 24 10 8B 44 24 30 01 44 24 10 8B 44 24 28 89 54 24 14 8B 54 24 34 11 54 24 14 F7 E3 01 44 24 10 11 54 24 14 8B 54 24 1C 89 D0 31 D2 89 44 24 18 8B 44 24 38 01 44 24 18 89 54 24 1C 8B 54 24 3C 11 54 24 1C 8B 54 24 14 89 D0 31 D2 01 44 24 18 8B 44 24 10 11 54 24 1C 89 C2 31 C0 89 44 24 10 8B 44 24 20 89 54 24 14 31 D2 01 44 24 10 11 54 24 14 3B 7C 24 1C 0F 87 1C F6 FF FF 72 0A 3B 74 24 18 0F 87 10 F6 FF FF 8B 54 24 1C 8B 44 24 18 31 FA 31 F0 09 C2 0F 85 C2 F5 FF FF 8B 54 24 14 39 54 24 0C 0F 82 B4 F5 FF FF 0F 87 E8 F5 FF FF 8B 5C 24 10 39 5C 24 08 0F 86 A0 F5 FF FF E9 D5 F5 FF FF 72 08 39 D6 0F 87 F3 FC FF FF 31 D8 31 F2 09 D0 0F 84 54 03 00 00 8B 54 24 18 B8 01 00 00 00 8B 4C 24 1C 83 0D ?? ?? ?? ?? 20 89 54 24 10 31 D2 89 4C 24 14 E9 E2 FC FF FF 8B 44 24 08 8B 54 24 0C 8B 4C 24 38 83 C0 00 81 D2 00 00 00 80 C1 E1 04 8B 99 ?? ?? ?? ?? 8B 89 ?? ?? ?? ?? 39 CA 0F 87 73 02 00 00 72 08 39 D8 0F 87 69 02 00 00 31 D1 31 C3 31 D2 31 C0 09 D9 0F 85 A5 FB FF FF 8B 44 24 38 8B 74 24 54 C1 E0 04 3B B0 ?? ?? ?? ?? 72 16 0F 87 40 02 00 00 8B 54 24 50 3B 90 ?? ?? ?? ?? 0F 83 30 02 00 00 31 C0 31 D2 E9 73 FB FF FF 8D 5A E1 C1 E3 04 8B 93 ?? ?? ?? ?? 8B AB ?? ?? ?? ?? C7 44 24 2C 00 00 00 00 C7 44 24 14 00 00 00 00 89 54 24 10 8B 54 24 2C 89 6C 24 28 8B 44 24 28 BD F6 FF FF FF C7 44 24 34 00 00 00 00 0F A4 C2 02 C1 E0 02 89 44 24 20 8B 44 24 10 89 54 24 24 8B 54 24 14 0F A4 C2 02 C1 E0 02 89 44 24 18 8B 44 24 28 89 54 24 1C F7 E5 89 54 24 3C 8B 54 24 20 89 44 24 38 89 54 24 30 8B 54 24 3C 89 D0 31 D2 89 44 24 28 8B 44 24 30 01 44 24 28 8B 44 24 10 89 54 24 2C 8B 54 24 34 11 54 24 2C F7 E5 01 44 24 28 11 54 24 2C 8B 44 24 28 89 C2 B8 00 00 00 00 89 44 24 10 8B 44 24 38 89 54 24 14 31 D2 01 44 24 10 11 54 24 14 6B 83 ?? ?? ?? ?? F6 8B 93 ?? ?? ?? ?? 8D 14 90 8B 83 ?? ?? ?? ?? 89 54 24 38 8B 5C 24 38 F7 E5 01 DA 89 44 24 30 8B 44 24 30 01 44 24 18 89 54 24 34 8B 54 24 34 11 54 24 1C 8B 54 24 24 89 D0 31 D2 01 44 24 18 11 54 24 1C 8B 54 24 2C 89 D0 31 D2 01 44 24 18 11 54 24 1C E9 D5 FD FF FF 8D 6A E1 B8 05 00 00 00 C1 E5 04 F7 A5 ?? ?? ?? ?? C7 44 24 14 00 00 00 00 89 44 24 38 B8 05 00 00 00 89 54 24 3C F7 A5 ?? ?? ?? ?? 89 44 24 18 8B 85 ?? ?? ?? ?? 89 54 24 1C F7 E3 89 54 24 24 8B 54 24 38 89 44 24 20 89 54 24 10 8B 54 24 24 89 D0 31 D2 89 44 24 28 8B 44 24 10 01 44 24 28 8B 85 ?? ?? ?? ?? 89 54 24 2C 8B 54 24 14 11 54 24 2C F7 E3 01 44 24 28 8B 44 24 28 11 54 24 2C 89 C2 B8 00 00 00 00 89 44 24 10 8B 44 24 20 89 54 24 14 31 D2 01 44 24 10 11 54 24 14 8B 85 ?? ?? ?? ?? 6B 95 ?? ?? ?? ?? 0A 8D 04 80 01 D0 89 44 24 20 8B 85 ?? ?? ?? ?? F7 E3 8B 5C 24 20 89 44 24 30 01 DA 8B 44 24 30 01 44 24 18 89 54 24 34 8B 54 24 34 11 54 24 1C 8B 54 24 3C 89 D0 31 D2 01 44 24 18 11 54 24 1C 8B 54 24 2C 89 D0 31 D2 01 44 24 18 11 54 24 1C E9 83 FB FF FF 83 0D ?? ?? ?? ?? 20 31 C0 BA 01 00 00 00 E9 39 F9 FF FF 8B 4C 24 38 8B 5C 24 54 C1 E1 04 3B 99 ?? ?? ?? ?? 0F 87 21 FA FF FF 72 10 8B 74 24 50 3B B1 ?? ?? ?? ?? 0F 87 0F FA FF FF 89 F8 83 E0 01 85 C0 74 3D 83 C7 FF BB 01 00 00 00 31 C9 31 C0 31 D2 E9 60 F9 FF FF 8B 5C 24 54 0B 5C 24 50 0F 84 D8 F8 FF FF 8B 44 24 38 31 D2 C1 E0 04 8B 98 ?? ?? ?? ?? 8B 88 ?? ?? ?? ?? 31 C0 E9 15 FD FF FF 31 DB B9 01 00 00 00 31 C0 31 D2 E9 26 F9 FF FF 8B 44 24 1C 0B 44 24 18 0F 85 85 F9 FF FF 8B 54 24 0C 0B 54 24 08 75 40 8B 4C 24 54 0B 4C 24 50 0F 84 86 FC FF FF 8B 44 24 38 C1 E0 04 8B 90 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 39 44 24 0C 74 49 C7 44 24 10 00 00 00 00 31 C0 31 D2 C7 44 24 14 00 00 00 00 E9 59 F9 FF FF 8B 44 24 38 C1 E0 04 8B 90 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 39 44 24 0C 0F 87 1E F9 FF FF 72 C2 39 54 24 08 0F 87 12 F9 FF FF 90 8D 74 26 00 EB B1 39 54 24 08 75 B1 8B 44 24 38 8B 54 24 54 C1 E0 04 3B 90 ?? ?? ?? ?? 72 9E 0F 87 EC F8 FF FF 8B 4C 24 50 3B 88 ?? ?? ?? ?? 76 8C E9 DB F8 FF FF 8B 5C 24 38 8B 14 DD ?? ?? ?? ?? 39 54 24 }
	condition:
		$1
}

rule file_102_6_0 {
	meta:
		name = "___bid128_to_int32_int"
		size = 3344
		refs = "0112 ___bid_nr_digits 01a7 ___bid_IDEC_glbflags 0292 ___bid_ten2k64 0357 ___bid_midpoint128 039c ___bid_ten2mk128 06e2 ___bid_shiftright128 06e9 ___bid_maskhigh128 078b ___bid_ten2mk128trunc 0852 ___bid_midpoint64 08a4 ___bid_onehalf128 0b30 ___bid_ten2k128"
	strings:
		$1 = { 81 EC 9C 00 00 00 8B 84 24 A0 00 00 00 8B 8C 24 AC 00 00 00 89 B4 24 90 00 00 00 89 9C 24 8C 00 00 00 89 44 24 70 8B 84 24 A4 00 00 00 8B 5C 24 70 89 CA 81 E2 00 00 00 78 89 BC 24 94 00 00 00 89 44 24 74 8B 74 24 74 89 AC 24 98 00 00 00 8B 84 24 A8 00 00 00 89 5C 24 08 89 74 24 0C 89 CE 81 E6 00 00 00 80 81 FA 00 00 00 78 89 74 24 1C 0F 84 1D 01 00 00 89 CF 89 C6 81 E7 FF FF 01 00 81 FF 09 ED 01 00 76 28 31 C0 8B 9C 24 8C 00 00 00 8B B4 24 90 00 00 00 8B BC 24 94 00 00 00 8B AC 24 98 00 00 00 81 C4 9C 00 00 00 C3 8D 76 00 0F 83 00 01 00 00 89 FA 89 F0 81 F2 09 ED 01 00 35 C0 87 AD BE 09 C2 0F 84 47 01 00 00 89 C8 25 00 00 00 60 3D 00 00 00 60 74 AD 89 FD 09 F5 0F 84 E1 00 00 00 89 74 24 68 89 7C 24 6C DF 6C 24 68 DD 5C 24 10 8B 54 24 14 89 D0 C1 E8 14 25 FF 07 00 00 2D BE 03 00 00 83 E8 01 89 C3 C1 E3 05 8B 93 ?? ?? ?? ?? 85 D2 75 2C 8B 93 ?? ?? ?? ?? 8B AB ?? ?? ?? ?? 8B 9B ?? ?? ?? ?? 39 DF 0F 87 41 01 00 00 0F 83 F6 06 00 00 31 FB 31 F5 09 EB 0F 84 0B 01 00 00 81 E1 00 00 FE 7F C1 E9 11 81 E9 20 18 00 00 8D 1C 0A 83 FB 0A 7F 48 0F 84 3D 01 00 00 31 C0 85 DB 0F 8E 1D FF FF FF 83 F9 00 0F 8C BA 01 00 00 8B 44 24 08 0F 85 00 01 00 00 8B 4C 24 1C 85 C9 0F 84 FE FE FF FF F7 D8 E9 F7 FE FF FF 89 C8 25 00 00 00 7C 3D 00 00 00 7C 0F 84 9B 00 00 00 83 0D ?? ?? ?? ?? 01 B8 00 00 00 80 E9 D4 FE FF FF 3D C0 87 AD BE 0F 87 C7 FE FF FF E9 F0 FE FF FF 8B 54 24 0C 31 C0 0B 54 24 08 0F 84 B4 FE FF FF 81 7C 24 0C FF FF 1F 00 0F 86 2C 01 00 00 8B 54 24 0C 89 D0 31 D2 89 44 24 68 89 54 24 6C DF 6C 24 68 DD 5C 24 10 8B 54 24 14 89 D0 C1 E8 14 25 FF 07 00 00 2D DE 03 00 00 E9 F4 FE FF FF 31 C0 81 7C 24 0C 63 8E 8D 37 0F 87 66 FE FF FF 89 CA 81 E2 00 00 00 60 81 FA 00 00 00 60 0F 85 AD FE FF FF E9 4D FE FF FF 8D 76 00 83 0D ?? ?? ?? ?? 01 B8 00 00 00 80 E9 39 FE FF FF C1 E0 05 8B 5C 24 0C 05 ?? ?? ?? ?? 39 58 14 0F 87 E0 FE FF FF 72 0D 8B 6C 24 08 39 68 10 0F 87 D1 FE FF FF 83 C2 01 E9 C9 FE FF FF 8D 76 00 8B 54 24 1C 85 D2 0F 84 47 05 00 00 F7 D8 0F AF 04 CD ?? ?? ?? ?? E9 EF FD FF FF 90 8D 74 26 00 8B 6C 24 1C 85 ED 0F 84 34 05 00 00 83 FA 0B 0F 8F D7 06 00 00 BD 0B 00 00 00 8B 5C 24 0C 29 D5 8B 54 24 08 0F AF 14 ED ?? ?? ?? ?? 0F AF 1C ED ?? ?? ?? ?? 8B 44 24 08 01 D3 F7 24 ED ?? ?? ?? ?? 01 DA 83 FA 05 89 44 24 10 89 54 24 14 0F 82 79 FE FF FF 0F 87 AB FE FF FF 83 7C 24 10 09 0F 86 68 FE FF FF E9 9B FE FF FF 8D B6 00 00 00 00 DF 6C 24 08 DD 5C 24 10 8B 54 24 14 89 D0 C1 E8 14 25 FF 07 00 00 2D FE 03 00 00 E9 D8 FD FF FF 89 CB F7 DB 83 FB 13 89 5C 24 5C 0F 8E 04 05 00 00 BB EC FF FF FF 8B 44 24 08 29 CB 8B 54 24 0C F7 D1 C1 E3 04 03 83 ?? ?? ?? ?? 13 93 ?? ?? ?? ?? 03 B3 ?? ?? ?? ?? 13 BB ?? ?? ?? ?? 89 4C 24 58 39 54 24 0C 72 0E 77 06 39 44 24 08 76 06 83 C6 01 83 D7 00 8B 5C 24 58 89 D1 89 44 24 30 C7 44 24 2C 00 00 00 00 C1 E3 04 8B AB ?? ?? ?? ?? 89 6C 24 38 8B 44 24 38 8B AB ?? ?? ?? ?? F7 E2 89 6C 24 40 89 44 24 10 89 E8 89 54 24 14 F7 E1 89 44 24 20 8B 44 24 30 89 54 24 24 F7 64 24 38 89 54 24 4C 8B 54 24 10 89 44 24 48 89 54 24 28 8B 54 24 4C 89 D0 31 D2 89 44 24 08 8B 44 24 28 01 44 24 08 8B 44 24 30 89 54 24 0C 8B 54 24 2C 11 54 24 0C F7 E5 01 44 24 08 11 54 24 0C 8B 54 24 14 89 D0 31 D2 89 44 24 10 8B 44 24 20 01 44 24 10 8B AB ?? ?? ?? ?? 89 54 24 14 8B 54 24 24 11 54 24 14 8B 54 24 0C 89 6C 24 28 8B AB ?? ?? ?? ?? 89 D0 31 D2 01 44 24 10 8B 44 24 28 11 54 24 14 F7 E1 89 44 24 20 89 C8 89 54 24 24 F7 E5 89 44 24 50 8B 44 24 30 89 54 24 54 F7 64 24 28 89 54 24 64 8B 5C 24 64 31 D2 89 44 24 60 8B 44 24 20 89 D9 31 DB 01 C1 8B 44 24 30 11 D3 F7 E5 01 C1 11 D3 8B 54 24 24 89 D0 31 D2 89 44 24 20 8B 44 24 50 89 54 24 24 8B 54 24 54 01 44 24 20 11 54 24 24 89 DA 89 D0 31 D2 89 4C 24 54 8B 4C 24 08 01 44 24 20 11 54 24 24 31 C0 31 D2 89 44 24 50 8B 44 24 60 89 CB 01 44 24 50 11 54 24 54 31 C9 8B 44 24 48 31 D2 89 4C 24 08 01 44 24 08 8B 44 24 20 89 5C 24 0C 11 54 24 0C 8B 54 24 24 01 44 24 08 11 54 24 0C 8B 4C 24 0C 39 CA 72 14 77 08 8B 5C 24 08 39 D8 76 0A 83 44 24 10 01 83 54 24 14 00 8B 44 24 38 89 F9 89 F7 F7 E1 89 44 24 20 8B 44 24 40 89 54 24 24 F7 E1 89 44 24 48 8B 44 24 38 89 54 24 4C F7 E6 89 54 24 3C 8B 74 24 3C 31 D2 89 44 24 38 8B 44 24 20 89 F3 31 F6 89 5C 24 30 01 44 24 30 8B 44 24 40 89 74 24 34 8B 74 24 24 11 54 24 34 F7 E7 01 44 24 30 89 F3 11 54 24 34 31 F6 8B 54 24 34 89 5C 24 20 8B 5C 24 48 01 5C 24 20 89 74 24 24 8B 74 24 4C 89 D0 11 74 24 24 31 D2 01 44 24 20 8B 44 24 28 11 54 24 24 F7 E1 89 44 24 40 89 C8 89 54 24 44 F7 E5 89 44 24 48 8B 44 24 28 89 54 24 4C F7 E7 89 54 24 2C 8B 5C 24 2C 31 D2 89 44 24 28 8B 44 24 40 C7 44 24 2C 00 00 00 00 89 D9 31 DB 01 C1 89 F8 8B 7C 24 44 11 D3 F7 E5 8B 6C 24 38 89 FE 01 C1 8B 44 24 28 11 D3 31 FF 03 74 24 48 13 7C 24 4C 31 D2 89 6C 24 28 01 DE 89 CB 11 D7 31 C9 31 D2 01 C1 8B 44 24 30 11 D3 89 C2 31 C0 03 44 24 28 13 54 24 2C 01 F0 11 FA 39 D7 72 10 77 04 39 C6 76 0A 83 44 24 20 01 83 54 24 24 00 8B 74 24 08 8B 7C 24 0C 01 CE 11 DF 89 7C 24 0C 31 FF 3B 5C 24 0C 89 74 24 08 BE 01 00 00 00 77 0C 72 06 3B 4C 24 08 77 04 31 F6 31 FF 8B 4C 24 10 01 F0 8B 5C 24 14 11 FA 01 C1 11 D3 39 DA 89 4C 24 10 89 5C 24 14 0F 87 57 02 00 00 72 08 39 C8 0F 87 4D 02 00 00 31 DB 39 D7 B9 01 00 00 00 77 0A 72 04 39 C6 77 04 31 C9 31 DB 89 C8 89 DA 03 44 24 20 13 54 24 24 83 7C 24 5C 16 0F 8F 97 01 00 00 8B 5C 24 58 8B 7C 24 10 8B 6C 24 14 8B 74 24 14 8B 0C 9D ?? ?? ?? ?? 23 3C DD ?? ?? ?? ?? 23 2C DD ?? ?? ?? ?? 8B 5C 24 10 0F AD F3 D3 EE F6 C1 20 74 04 89 F3 31 F6 89 5C 24 10 BB 40 00 00 00 29 CB 89 D9 31 DB D3 E0 F6 C1 20 8B 4C 24 10 0F 45 C3 89 74 24 14 09 C1 83 7C 24 5C 03 0F 8F 83 03 00 00 81 7C 24 0C 00 00 00 80 0F 87 C1 03 00 00 72 0B 83 7C 24 08 00 0F 87 B4 03 00 00 8B 44 24 0C C7 44 24 10 01 00 00 00 05 00 00 00 80 0B 44 24 08 0F 84 10 05 00 00 89 E8 09 F8 75 45 8B 54 24 0C 0B 54 24 08 75 0A 8B 74 24 54 0B 74 24 50 74 31 8B 44 24 58 C1 E0 04 8B 90 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 39 44 24 0C 72 20 77 06 39 54 24 08 72 18 33 44 24 0C 33 54 24 08 09 D0 0F 84 0E 05 00 00 8B 74 24 10 85 F6 74 03 83 C1 FF 8B 5C 24 1C 89 C8 85 DB 0F 84 BE F8 FF FF F7 D8 E9 B7 F8 FF FF 0F AF 04 CD ?? ?? ?? ?? E9 AA F8 FF FF 83 FA 0B 0F 8F 13 01 00 00 BD 0B 00 00 00 8B 5C 24 0C 29 D5 8B 54 24 08 0F AF 14 ED ?? ?? ?? ?? 0F AF 1C ED ?? ?? ?? ?? 8B 44 24 08 01 D3 F7 24 ED ?? ?? ?? ?? 01 DA 83 FA 04 89 44 24 10 89 54 24 14 0F 86 45 F9 FF FF E9 78 F9 FF FF 8D 76 00 39 EE 0F 87 3D FA FF FF 90 8D B4 26 00 00 00 00 E9 F5 F8 FF FF F7 D1 8B 44 24 08 8B 54 24 0C 03 04 CD ?? ?? ?? ?? 89 4C 24 58 13 14 CD ?? ?? ?? ?? E9 0B FB FF FF 8B 5C 24 58 89 D5 8B 34 DD ?? ?? ?? ?? 8B 3C 9D ?? ?? ?? ?? 21 C6 89 74 24 20 8B 34 DD ?? ?? ?? ?? 89 F9 83 E9 40 89 C7 0F AD D7 D3 ED 21 D6 F6 C1 20 0F 45 FD 8B 6C 24 58 89 F9 8B 04 ED ?? ?? ?? ?? 8B 14 ED ?? ?? ?? ?? 39 C6 0F 87 57 02 00 00 72 0A 39 54 24 20 0F 87 4B 02 00 00 33 54 24 20 31 F0 8B 7C 24 10 8B 6C 24 14 09 D0 C7 44 24 10 01 00 00 00 0F 84 AE 03 00 00 0B 74 24 20 0F 85 C8 FE FF FF E9 78 FE FF FF B8 01 00 00 00 31 D2 E9 C0 FD FF FF 83 FA 1E 0F 8F 1C 03 00 00 8D 6A F5 BB 05 00 00 00 8B 04 ED ?? ?? ?? ?? F7 E3 89 44 24 10 8B 04 ED ?? ?? ?? ?? 89 54 24 14 8B 6C 24 10 F7 E3 89 54 24 24 8B 54 24 14 89 44 24 20 89 D0 31 D2 89 44 24 28 8B 44 24 20 89 54 24 2C 8B 54 24 24 01 44 24 28 11 54 24 2C 3B 7C 24 2C 0F 87 48 F8 FF FF 72 0A 3B 74 24 28 0F 87 3C F8 FF FF 8B 54 24 2C 8B 44 24 28 31 FA 31 F0 09 C2 0F 85 F0 F7 FF FF 39 6C 24 0C 0F 82 E6 F7 FF FF E9 19 F8 FF FF 83 FA 1E 90 0F 8F 8D 01 00 00 83 EA 0B B8 05 00 00 00 8B 2C D5 ?? ?? ?? ?? C7 44 24 34 00 00 00 00 89 6C 24 38 8B 2C D5 ?? ?? ?? ?? F7 64 24 38 89 44 24 10 B8 05 00 00 00 89 54 24 14 F7 E5 89 44 24 28 8B 44 24 38 89 54 24 2C F7 E3 89 54 24 3C 8B 54 24 10 89 44 24 38 89 54 24 30 8B 54 24 3C 89 D0 31 D2 89 44 24 20 8B 44 24 30 01 44 24 20 89 E8 89 54 24 24 8B 54 24 34 11 54 24 24 F7 E3 01 44 24 20 11 54 24 24 8B 54 24 14 89 D0 31 D2 89 44 24 10 8B 44 24 28 89 54 24 14 8B 54 24 2C 01 44 24 10 11 54 24 14 8B 54 24 24 89 D0 31 D2 01 44 24 10 8B 44 24 20 11 54 24 14 89 C2 31 C0 89 44 24 20 8B 44 24 38 89 54 24 24 31 D2 01 44 24 20 11 54 24 24 3B 7C 24 14 0F 87 38 F7 FF FF 72 0A 3B 74 24 10 0F 87 2C F7 FF FF 8B 44 24 14 8B 54 24 10 31 F8 31 F2 09 D0 0F 85 E0 F6 FF FF 8B 54 24 24 39 54 24 0C 0F 82 D2 F6 FF FF 0F 87 04 F7 FF FF 8B 5C 24 20 39 5C 24 08 0F 82 BE F6 FF FF 90 E9 F0 F6 FF FF 8B 74 24 58 8B 04 F5 ?? ?? ?? ?? 8B 14 F5 ?? ?? ?? ?? 39 C5 77 36 72 04 39 D7 77 30 89 EE 31 C6 89 F8 31 D0 09 C6 C7 44 24 10 01 00 00 00 0F 85 7F FC FF FF 8B 74 24 0C 0B 74 24 08 75 0E 8B 44 24 54 0B 44 24 50 0F 84 BA FC FF FF C7 44 24 10 00 00 00 00 E9 5A FC FF FF 8B 7C 24 10 8B 6C 24 14 C7 44 24 10 00 00 00 00 E9 BE FD FF FF 8D 6A E1 B8 05 00 00 00 C1 E5 04 F7 A5 ?? ?? ?? ?? C7 44 24 24 00 00 00 00 89 44 24 30 B8 05 00 00 00 89 54 24 34 F7 A5 ?? ?? ?? ?? 89 44 24 10 8B 85 ?? ?? ?? ?? 89 54 24 14 F7 E3 89 54 24 2C 8B 54 24 30 89 44 24 28 89 54 24 20 8B 54 24 2C 89 D0 31 D2 89 44 24 38 8B 44 24 20 01 44 24 38 8B 85 ?? ?? ?? ?? 89 54 24 3C 8B 54 24 24 11 54 24 3C F7 E3 01 44 24 38 8B 44 24 38 11 54 24 3C 89 C2 B8 00 00 00 00 89 44 24 20 8B 44 24 28 89 54 24 24 31 D2 01 44 24 20 11 54 24 24 8B 85 ?? ?? ?? ?? 6B 95 ?? ?? ?? ?? 0A 8D 04 80 01 D0 89 44 24 28 8B 85 ?? ?? ?? ?? F7 E3 8B 5C 24 28 89 44 24 40 01 DA 8B 44 24 40 01 44 24 10 89 54 24 44 8B 54 24 44 11 54 24 14 8B 54 24 34 89 D0 31 D2 01 44 24 10 11 54 24 14 8B 54 24 3C 89 D0 31 D2 01 44 24 10 11 54 24 14 E9 42 FE FF FF 8D 5A E1 BD 05 00 00 00 C1 E3 04 8B 83 ?? ?? ?? ?? F7 E5 89 44 24 10 8B 83 ?? ?? ?? ?? 89 54 24 14 F7 E5 8B 6C 24 10 89 54 24 2C 8B 93 ?? ?? ?? ?? 89 44 24 28 31 C0 01 44 24 28 8D 14 92 11 54 24 2C 8B 54 24 14 89 D0 31 D2 01 44 24 28 11 54 24 2C E9 DB FC FF FF 8B 44 24 50 0B 44 24 54 0F 94 C2 0F B6 D2 89 54 24 10 E9 D9 FA FF FF 89 EA 09 FA 75 1F 8B 7C 24 0C 0B 7C 24 08 75 54 8B 6C 24 54 31 FF 0B 6C 24 50 BD 00 00 00 00 0F 84 2D FC FF FF C7 44 24 10 00 00 00 00 E9 20 FC FF FF 8B 44 24 58 8B 7C 24 54 C1 E0 04 3B B8 ?? ?? ?? ?? 0F 87 DB FA FF FF 0F 82 DD FA FF FF 8B 6C 24 50 3B A8 ?? ?? ?? ?? 0F 87 C5 FA FF FF E9 C8 FA FF FF 31 FF 31 ED C7 44 24 10 00 00 00 00 E9 DD FB FF FF 8D B6 00 00 00 00 8D BF 00 00 00 00 }
	condition:
		$1
}

rule file_102_7_0 {
	meta:
		name = "___bid128_to_int32_xint"
		size = 3776
		refs = "0112 ___bid_nr_digits 01a7 ___bid_IDEC_glbflags 0292 ___bid_ten2k64 0357 ___bid_midpoint128 039c ___bid_ten2mk128 06de ___bid_maskhigh128 06e5 ___bid_shiftright128 079d ___bid_ten2mk128trunc 0862 ___bid_midpoint64 08c2 ___bid_onehalf128 0c23 ___bid_ten2k128"
	strings:
		$1 = { 81 EC 9C 00 00 00 8B 84 24 A0 00 00 00 8B 8C 24 AC 00 00 00 89 B4 24 90 00 00 00 89 9C 24 8C 00 00 00 89 44 24 70 8B 84 24 A4 00 00 00 8B 5C 24 70 89 CA 81 E2 00 00 00 78 89 BC 24 94 00 00 00 89 44 24 74 8B 74 24 74 89 AC 24 98 00 00 00 8B 84 24 A8 00 00 00 89 5C 24 08 89 74 24 0C 89 CE 81 E6 00 00 00 80 81 FA 00 00 00 78 89 74 24 58 0F 84 1D 01 00 00 89 CF 89 C6 81 E7 FF FF 01 00 81 FF 09 ED 01 00 76 28 31 C0 8B 9C 24 8C 00 00 00 8B B4 24 90 00 00 00 8B BC 24 94 00 00 00 8B AC 24 98 00 00 00 81 C4 9C 00 00 00 C3 8D 76 00 0F 83 00 01 00 00 89 FA 89 F0 81 F2 09 ED 01 00 35 C0 87 AD BE 09 C2 0F 84 47 01 00 00 89 C8 25 00 00 00 60 3D 00 00 00 60 74 AD 89 FD 09 F5 0F 84 E1 00 00 00 89 74 24 68 89 7C 24 6C DF 6C 24 68 DD 5C 24 18 8B 54 24 1C 89 D0 C1 E8 14 25 FF 07 00 00 2D BE 03 00 00 83 E8 01 89 C3 C1 E3 05 8B 93 ?? ?? ?? ?? 85 D2 75 2C 8B 93 ?? ?? ?? ?? 8B AB ?? ?? ?? ?? 8B 9B ?? ?? ?? ?? 39 DF 0F 87 41 01 00 00 0F 83 06 07 00 00 31 FB 31 F5 09 EB 0F 84 0B 01 00 00 81 E1 00 00 FE 7F C1 E9 11 81 E9 20 18 00 00 8D 1C 0A 83 FB 0A 7F 48 0F 84 3D 01 00 00 85 DB 0F 8E 0B 07 00 00 83 F9 00 66 90 0F 8C BA 01 00 00 8B 44 24 08 0F 85 00 01 00 00 8B 4C 24 58 85 C9 0F 84 FE FE FF FF F7 D8 E9 F7 FE FF FF 89 C8 25 00 00 00 7C 3D 00 00 00 7C 0F 84 9B 00 00 00 83 0D ?? ?? ?? ?? 01 B8 00 00 00 80 E9 D4 FE FF FF 3D C0 87 AD BE 0F 87 C7 FE FF FF E9 F0 FE FF FF 8B 54 24 0C 31 C0 0B 54 24 08 0F 84 B4 FE FF FF 81 7C 24 0C FF FF 1F 00 0F 86 2C 01 00 00 8B 54 24 0C 89 D0 31 D2 89 44 24 68 89 54 24 6C DF 6C 24 68 DD 5C 24 18 8B 54 24 1C 89 D0 C1 E8 14 25 FF 07 00 00 2D DE 03 00 00 E9 F4 FE FF FF 31 C0 81 7C 24 0C 63 8E 8D 37 0F 87 66 FE FF FF 89 CA 81 E2 00 00 00 60 81 FA 00 00 00 60 0F 85 AD FE FF FF E9 4D FE FF FF 8D 76 00 83 0D ?? ?? ?? ?? 01 B8 00 00 00 80 E9 39 FE FF FF C1 E0 05 8B 5C 24 0C 05 ?? ?? ?? ?? 39 58 14 0F 87 E0 FE FF FF 72 0D 8B 6C 24 08 39 68 10 0F 87 D1 FE FF FF 83 C2 01 E9 C9 FE FF FF 8D 76 00 8B 54 24 58 85 D2 0F 84 55 05 00 00 F7 D8 0F AF 04 CD ?? ?? ?? ?? E9 EF FD FF FF 90 8D 74 26 00 8B 6C 24 58 85 ED 0F 84 44 05 00 00 83 FA 0B 0F 8F 4E 06 00 00 BD 0B 00 00 00 8B 5C 24 0C 29 D5 8B 54 24 08 0F AF 14 ED ?? ?? ?? ?? 0F AF 1C ED ?? ?? ?? ?? 8B 44 24 08 01 D3 F7 24 ED ?? ?? ?? ?? 01 DA 83 FA 05 89 44 24 10 89 54 24 14 0F 82 77 FE FF FF 0F 87 AB FE FF FF 83 7C 24 10 09 0F 86 66 FE FF FF E9 9B FE FF FF 8D B6 00 00 00 00 DF 6C 24 08 DD 5C 24 18 8B 54 24 1C 89 D0 C1 E8 14 25 FF 07 00 00 2D FE 03 00 00 E9 D8 FD FF FF 89 CB F7 DB 83 FB 13 89 5C 24 5C 0F 8E 14 05 00 00 BB EC FF FF FF 8B 44 24 08 29 CB 8B 54 24 0C F7 D1 C1 E3 04 03 83 ?? ?? ?? ?? 13 93 ?? ?? ?? ?? 03 B3 ?? ?? ?? ?? 13 BB ?? ?? ?? ?? 89 4C 24 40 39 54 24 0C 72 0E 77 06 39 44 24 08 76 06 83 C6 01 83 D7 00 8B 5C 24 40 89 D1 89 44 24 28 C7 44 24 24 00 00 00 00 C1 E3 04 8B AB ?? ?? ?? ?? 89 6C 24 30 8B 44 24 30 8B AB ?? ?? ?? ?? F7 E2 89 6C 24 38 89 44 24 18 89 E8 89 54 24 1C F7 E1 89 44 24 10 8B 44 24 28 89 54 24 14 F7 64 24 30 89 54 24 4C 8B 54 24 18 89 44 24 48 89 54 24 20 8B 54 24 4C 89 D0 31 D2 89 44 24 08 8B 44 24 20 01 44 24 08 8B 44 24 28 89 54 24 0C 8B 54 24 24 11 54 24 0C F7 E5 01 44 24 08 11 54 24 0C 8B 54 24 1C 89 D0 31 D2 89 44 24 18 8B 44 24 10 01 44 24 18 8B AB ?? ?? ?? ?? 89 54 24 1C 8B 54 24 14 11 54 24 1C 8B 54 24 0C 89 6C 24 20 8B AB ?? ?? ?? ?? 89 D0 31 D2 01 44 24 18 8B 44 24 20 11 54 24 1C F7 E1 89 44 24 10 89 C8 89 54 24 14 F7 E5 89 44 24 50 8B 44 24 28 89 54 24 54 F7 64 24 20 89 54 24 64 8B 5C 24 64 31 D2 89 44 24 60 8B 44 24 10 89 D9 31 DB 01 C1 8B 44 24 28 11 D3 F7 E5 01 C1 11 D3 8B 54 24 14 89 D0 31 D2 89 44 24 10 8B 44 24 50 89 54 24 14 8B 54 24 54 01 44 24 10 11 54 24 14 89 DA 89 D0 31 D2 89 4C 24 54 8B 4C 24 08 01 44 24 10 11 54 24 14 31 C0 31 D2 89 44 24 50 8B 44 24 60 89 CB 01 44 24 50 11 54 24 54 31 C9 8B 44 24 48 31 D2 89 4C 24 08 01 44 24 08 8B 44 24 10 89 5C 24 0C 11 54 24 0C 8B 54 24 14 01 44 24 08 11 54 24 0C 8B 4C 24 0C 39 CA 72 14 77 08 8B 5C 24 08 39 D8 76 0A 83 44 24 18 01 83 54 24 1C 00 8B 44 24 30 89 F9 89 F7 F7 E1 89 44 24 10 8B 44 24 38 89 54 24 14 F7 E1 89 44 24 48 8B 44 24 30 89 54 24 4C F7 E6 89 54 24 34 8B 74 24 34 31 D2 89 44 24 30 8B 44 24 10 89 F3 31 F6 89 5C 24 28 01 44 24 28 8B 44 24 38 89 74 24 2C 8B 74 24 14 11 54 24 2C F7 E7 01 44 24 28 89 F3 11 54 24 2C 31 F6 8B 54 24 2C 89 5C 24 10 8B 5C 24 48 01 5C 24 10 89 74 24 14 8B 74 24 4C 89 D0 11 74 24 14 31 D2 01 44 24 10 8B 44 24 20 11 54 24 14 F7 E1 89 44 24 38 89 C8 89 54 24 3C F7 E5 89 44 24 48 8B 44 24 20 89 54 24 4C F7 E7 89 54 24 24 8B 5C 24 24 31 D2 89 44 24 20 8B 44 24 38 C7 44 24 24 00 00 00 00 89 D9 31 DB 01 C1 89 F8 8B 7C 24 3C 11 D3 F7 E5 8B 6C 24 30 89 FE 01 C1 8B 44 24 20 11 D3 31 FF 03 74 24 48 13 7C 24 4C 31 D2 89 6C 24 20 01 DE 89 CB 11 D7 31 C9 31 D2 01 C1 8B 44 24 28 11 D3 89 C2 31 C0 03 44 24 20 13 54 24 24 01 F0 11 FA 39 D7 72 10 77 04 39 C6 76 0A 83 44 24 10 01 83 54 24 14 00 8B 74 24 08 8B 7C 24 0C 01 CE 11 DF 89 7C 24 0C 31 FF 3B 5C 24 0C 89 74 24 08 BE 01 00 00 00 77 0C 72 06 3B 4C 24 08 77 04 31 F6 31 FF 8B 4C 24 18 01 F0 8B 5C 24 1C 11 FA 01 C1 11 D3 39 DA 89 4C 24 18 89 5C 24 1C 0F 87 EB 01 00 00 72 08 39 C8 0F 87 E1 01 00 00 31 DB 39 D7 B9 01 00 00 00 77 0A 72 04 39 C6 77 04 31 C9 31 DB 89 C8 89 DA 03 44 24 10 13 54 24 14 83 7C 24 5C 16 0F 8F C1 01 00 00 8B 5C 24 40 8B 74 24 18 8B 7C 24 1C 23 34 DD ?? ?? ?? ?? 8B 0C 9D ?? ?? ?? ?? 23 3C DD ?? ?? ?? ?? 89 74 24 10 8B 5C 24 18 8B 74 24 1C 89 7C 24 14 31 FF 0F AD F3 D3 EE F6 C1 20 0F 45 DE 0F 45 F7 89 5C 24 18 BB 40 00 00 00 31 ED 29 CB 89 74 24 1C 8B 74 24 18 89 D9 D3 E0 F6 C3 20 0F 45 C5 09 C6 83 7C 24 5C 03 0F 8F 2E 04 00 00 81 7C 24 0C 00 00 00 80 0F 87 AD 03 00 00 72 0B 83 7C 24 08 00 0F 87 A0 03 00 00 8B 44 24 0C 05 00 00 00 80 0B 44 24 08 0F 84 01 06 00 00 83 0D ?? ?? ?? ?? 20 BA 01 00 00 00 8B 4C 24 14 0B 4C 24 10 75 45 8B 5C 24 0C 0B 5C 24 08 75 0A 8B 6C 24 54 0B 6C 24 50 74 31 8B 44 24 40 C1 E0 04 8B 88 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 39 44 24 0C 72 1C 77 06 39 4C 24 08 72 14 33 44 24 0C 33 4C 24 08 09 C8 0F 84 26 06 00 00 85 D2 74 03 83 C6 FF 8B 5C 24 58 89 F0 85 DB 0F 84 B0 F8 FF FF F7 D8 E9 A9 F8 FF FF 0F AF 04 CD ?? ?? ?? ?? E9 9C F8 FF FF 66 90 83 FA 0B 0F 8F 37 02 00 00 BD 0B 00 00 00 8B 5C 24 0C 29 D5 8B 54 24 08 0F AF 14 ED ?? ?? ?? ?? 0F AF 1C ED ?? ?? ?? ?? 8B 44 24 08 01 D3 F7 24 ED ?? ?? ?? ?? 01 DA 83 FA 04 89 44 24 10 89 54 24 14 0F 86 33 F9 FF FF E9 68 F9 FF FF 8D 76 00 39 EE 0F 87 2D FA FF FF 90 8D B4 26 00 00 00 00 E9 E5 F8 FF FF F7 D1 8B 44 24 08 8B 54 24 0C 03 04 CD ?? ?? ?? ?? 89 4C 24 40 13 14 CD ?? ?? ?? ?? E9 FB FA FF FF 83 0D ?? ?? ?? ?? 20 31 C0 E9 06 F8 FF FF B8 01 00 00 00 31 D2 E9 2C FE FF FF 8B 5C 24 40 8B 2C DD ?? ?? ?? ?? 89 DE 8B 3C B5 ?? ?? ?? ?? 89 C6 8B 1C DD ?? ?? ?? ?? 21 C5 8B 44 24 40 89 F9 89 D7 83 E9 40 21 D3 0F AD D6 8B 14 C5 ?? ?? ?? ?? D3 EF F6 C1 20 8B 04 C5 ?? ?? ?? ?? 0F 45 F7 39 C3 0F 86 E3 01 00 00 8B 54 24 1C 8B 44 24 18 83 0D ?? ?? ?? ?? 20 89 54 24 14 31 D2 89 44 24 10 09 EB 0F 85 C7 FE FF FF E9 73 FE FF FF 83 FA 1E 0F 8F 61 03 00 00 83 EA 0B B8 05 00 00 00 8B 2C D5 ?? ?? ?? ?? C7 44 24 2C 00 00 00 00 89 6C 24 30 8B 2C D5 ?? ?? ?? ?? F7 64 24 30 89 44 24 18 B8 05 00 00 00 89 54 24 1C F7 E5 89 44 24 20 8B 44 24 30 89 54 24 24 F7 E3 89 54 24 34 8B 54 24 18 89 44 24 30 89 54 24 28 8B 54 24 34 89 D0 31 D2 89 44 24 10 8B 44 24 28 01 44 24 10 89 E8 89 54 24 14 8B 54 24 2C 11 54 24 14 F7 E3 01 44 24 10 11 54 24 14 8B 54 24 1C 89 D0 31 D2 89 44 24 18 8B 44 24 20 89 54 24 1C 8B 54 24 24 01 44 24 18 11 54 24 1C 8B 54 24 14 89 D0 31 D2 01 44 24 18 8B 44 24 10 11 54 24 1C 89 C2 31 C0 89 44 24 10 8B 44 24 30 89 54 24 14 31 D2 01 44 24 10 11 54 24 14 3B 7C 24 1C 0F 87 C2 F7 FF FF 72 0A 3B 74 24 18 0F 87 B6 F7 FF FF 8B 44 24 1C 8B 54 24 18 31 F8 31 F2 09 D0 0F 85 68 F7 FF FF 8B 54 24 14 39 54 24 0C 0F 82 5A F7 FF FF 0F 87 8E F7 FF FF 8B 5C 24 10 39 5C 24 08 0F 82 46 F7 FF FF E9 7B F7 FF FF 8D B6 00 00 00 00 83 FA 1E 0F 8F DD 01 00 00 8D 6A F5 BB 05 00 00 00 8B 04 ED ?? ?? ?? ?? F7 E3 89 44 24 18 8B 04 ED ?? ?? ?? ?? 89 54 24 1C 8B 6C 24 18 F7 E3 89 54 24 14 8B 54 24 1C 89 44 24 10 89 D0 31 D2 89 44 24 20 8B 44 24 10 89 54 24 24 8B 54 24 14 01 44 24 20 11 54 24 24 3B 7C 24 24 0F 87 14 F7 FF FF 72 0A 3B 74 24 20 0F 87 08 F7 FF FF 8B 54 24 24 8B 44 24 20 31 FA 31 F0 09 C2 0F 85 BA F6 FF FF 39 6C 24 0C 0F 82 B0 F6 FF FF E9 E5 F6 FF FF 72 08 39 D5 0F 87 13 FE FF FF 31 D8 31 EA 09 D0 0F 84 BF 02 00 00 8B 54 24 18 8B 4C 24 1C 83 0D ?? ?? ?? ?? 20 89 54 24 10 BA 01 00 00 00 89 4C 24 14 E9 FF FD FF FF 8B 44 24 08 8B 54 24 0C 8B 4C 24 40 83 C0 00 81 D2 00 00 00 80 C1 E1 04 8B 99 ?? ?? ?? ?? 8B 89 ?? ?? ?? ?? 39 CA 77 3D 72 04 39 D8 77 37 31 D1 31 D8 31 D2 09 C1 0F 85 43 FC FF FF 8B 44 24 40 8B 6C 24 54 C1 E0 04 3B A8 ?? ?? ?? ?? 0F 82 C5 00 00 00 77 10 8B 54 24 50 3B 90 ?? ?? ?? ?? 0F 82 B3 00 00 00 83 0D ?? ?? ?? ?? 20 31 D2 E9 0C FC FF FF 8B 6C 24 40 8B 14 ED ?? ?? ?? ?? 39 54 24 14 8B 04 ED ?? ?? ?? ?? 0F 87 FA 02 00 00 72 0A 39 44 24 10 0F 87 EE 02 00 00 33 54 24 14 33 44 24 10 09 C2 0F 85 C8 FB FF FF 8B 4C 24 0C 0B 4C 24 08 75 0E 8B 5C 24 54 0B 5C 24 50 0F 84 B0 FB FF FF 8B 44 24 40 C1 E0 04 8B 90 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 39 44 24 0C 77 35 72 06 39 54 24 08 77 2D 33 44 24 0C 33 54 24 08 09 D0 75 28 8B 44 24 40 8B 6C 24 54 C1 E0 04 3B A8 ?? ?? ?? ?? 72 15 77 0C 8B 54 24 50 3B 90 ?? ?? ?? ?? 76 07 83 0D ?? ?? ?? ?? 20 31 D2 E9 60 FB FF FF 8D 5A E1 BD 05 00 00 00 C1 E3 04 8B 83 ?? ?? ?? ?? F7 E5 89 44 24 18 8B 83 ?? ?? ?? ?? 89 54 24 1C F7 E5 8B 6C 24 18 89 54 24 24 8B 93 ?? ?? ?? ?? 89 44 24 20 31 C0 01 44 24 20 8D 14 92 11 54 24 24 8B 54 24 1C 89 D0 31 D2 01 44 24 20 11 54 24 24 E9 1A FE FF FF 8D 6A E1 B8 05 00 00 00 C1 E5 04 F7 A5 ?? ?? ?? ?? C7 44 24 14 00 00 00 00 89 44 24 40 B8 05 00 00 00 89 54 24 44 F7 A5 ?? ?? ?? ?? 89 44 24 18 8B 85 ?? ?? ?? ?? 89 54 24 1C F7 E3 89 54 24 24 8B 54 24 40 89 44 24 20 89 54 24 10 8B 54 24 24 89 D0 31 D2 89 44 24 30 8B 44 24 10 01 44 24 30 8B 85 ?? ?? ?? ?? 89 54 24 34 8B 54 24 14 11 54 24 34 F7 E3 01 44 24 30 8B 44 24 30 11 54 24 34 89 C2 B8 00 00 00 00 89 44 24 10 8B 44 24 20 89 54 24 14 31 D2 01 44 24 10 11 54 24 14 8B 85 ?? ?? ?? ?? 6B 95 ?? ?? ?? ?? 0A 8D 04 80 01 D0 89 44 24 20 8B 85 ?? ?? ?? ?? F7 E3 8B 5C 24 20 89 44 24 28 01 DA 8B 44 24 28 01 44 24 18 89 54 24 2C 8B 54 24 2C 11 54 24 1C 8B 54 24 44 89 D0 31 D2 01 44 24 18 11 54 24 1C 8B 54 24 34 89 D0 31 D2 01 44 24 18 11 54 24 1C E9 6E FC FF FF 8B 5C 24 54 0B 5C 24 50 0F 84 F1 F9 FF FF 8B 44 24 40 31 D2 C1 E0 04 8B 98 ?? ?? ?? ?? 8B 88 ?? ?? ?? ?? 31 C0 E9 90 FD FF FF 8B 4C 24 1C 0B 4C 24 18 0F 85 3A FB FF FF 8B 44 24 0C 0B 44 24 08 75 70 8B 54 24 54 0B 54 24 50 0F 84 1B FD FF FF 8B 44 24 40 C1 E0 04 8B 90 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 39 44 24 0C 74 74 C7 44 24 10 00 00 00 00 31 D2 C7 44 24 14 00 00 00 00 E9 0B FB FF FF 8B 44 24 40 8B 4C 24 54 C1 E0 04 3B 88 ?? ?? ?? ?? 0F 87 C3 F9 FF FF 0F 82 C1 F9 FF FF 8B 5C 24 50 3B 98 ?? ?? ?? ?? 0F 87 AD F9 FF FF E9 AC F9 FF FF 8B 44 24 40 C1 E0 04 8B 90 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 39 44 24 0C 0F 87 A3 FA FF FF 72 92 39 54 24 08 0F 87 97 FA FF FF EB 86 39 54 24 08 75 86 8B 44 24 40 8B 4C 24 54 C1 E0 04 3B 88 ?? ?? ?? ?? 0F 82 6F FF FF FF 0F 87 72 FA FF FF 8B 54 24 50 3B 90 ?? ?? ?? ?? 0F 86 59 FF FF FF E9 5D FA FF FF 8B 4C 24 10 8B 5C 24 14 29 C1 19 D3 89 C8 39 5C 24 14 89 DA 0F 82 6E FD FF FF 77 0A 39 4C 24 10 0F 82 62 FD FF FF 89 D3 09 C3 0F 84 0A FD FF FF E9 53 FD FF FF 8D 74 26 00 8D BC 27 00 00 00 00 }
	condition:
		$1
}

rule file_102_8_0 {
	meta:
		name = "___bid128_to_int32_rninta"
		size = 3344
		refs = "0112 ___bid_nr_digits 019c ___bid_midpoint128 01e5 ___bid_ten2k64 0322 ___bid_IDEC_glbflags 050e ___bid_midpoint64 0546 ___bid_ten2mk128 085b ___bid_shiftright128 0aa9 ___bid_ten2k128"
	strings:
		$1 = { 81 EC 9C 00 00 00 8B 84 24 A0 00 00 00 8B 8C 24 AC 00 00 00 89 9C 24 8C 00 00 00 89 B4 24 90 00 00 00 89 44 24 70 8B 84 24 A4 00 00 00 8B 5C 24 70 89 CA 89 AC 24 98 00 00 00 81 E2 00 00 00 78 89 CD 81 E5 00 00 00 80 81 FA 00 00 00 78 89 44 24 74 8B 74 24 74 89 BC 24 94 00 00 00 8B 84 24 A8 00 00 00 89 5C 24 08 89 74 24 0C 0F 84 AE 02 00 00 89 CF 89 C6 81 E7 FF FF 01 00 81 FF 09 ED 01 00 76 2C 31 C0 8B 9C 24 8C 00 00 00 8B B4 24 90 00 00 00 8B BC 24 94 00 00 00 8B AC 24 98 00 00 00 81 C4 9C 00 00 00 C3 8D B4 26 00 00 00 00 0F 83 7B 02 00 00 89 FA 89 F0 81 F2 09 ED 01 00 35 C0 87 AD BE 09 C2 0F 84 C3 02 00 00 89 C8 25 00 00 00 60 3D 00 00 00 60 74 A9 89 F8 09 F0 0F 84 5C 02 00 00 89 74 24 68 89 7C 24 6C DF 6C 24 68 DD 5C 24 10 8B 54 24 14 89 D0 C1 E8 14 25 FF 07 00 00 2D BE 03 00 00 83 E8 01 89 C3 C1 E3 05 8B 93 ?? ?? ?? ?? 89 44 24 18 85 D2 75 34 8B 83 ?? ?? ?? ?? 8B 93 ?? ?? ?? ?? 8B 9B ?? ?? ?? ?? 89 44 24 10 39 DF 0F 87 94 07 00 00 0F 83 E3 08 00 00 8B 44 24 10 31 FB 31 F0 09 C3 0F 84 51 07 00 00 81 E1 00 00 FE 7F C1 E9 11 8D 99 E0 E7 FF FF 8D 0C 1A 83 F9 0A 0F 8F B3 01 00 00 0F 84 65 07 00 00 31 C0 83 F9 00 0F 8C 08 FF FF FF 66 90 0F 85 42 03 00 00 8D 42 FF 83 F8 12 0F 8E E3 07 00 00 83 EA 14 89 D0 C1 E0 04 8B 88 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 39 C7 0F 82 D6 FE FF FF 77 08 39 CE 0F 82 CC FE FF FF 31 F8 31 CE 09 F0 66 90 0F 84 0D 0B 00 00 83 FD 01 19 C0 83 E0 02 83 E8 01 E9 B0 FE FF FF 83 FA 1E 0F 8F C2 08 00 00 8D 4A F5 8B 04 CD ?? ?? ?? ?? 8B 0C CD ?? ?? ?? ?? C7 44 24 1C 00 00 00 00 C7 44 24 2C 00 00 00 00 89 44 24 28 8B 44 24 28 89 4C 24 18 8B 4C 24 1C 8B 54 24 18 C7 44 24 34 00 00 00 00 0F A4 D1 02 C1 E2 02 89 54 24 10 8B 54 24 2C 89 4C 24 14 B9 FB FF FF FF 0F A4 C2 02 C1 E0 02 89 44 24 20 8B 44 24 18 89 54 24 24 F7 E1 89 54 24 3C 8B 54 24 10 89 44 24 38 89 54 24 30 8B 54 24 3C 89 D0 31 D2 89 44 24 18 8B 44 24 30 01 44 24 18 8B 44 24 28 89 54 24 1C 8B 54 24 34 11 54 24 1C F7 E1 01 44 24 18 11 54 24 1C 8B 4C 24 14 8B 44 24 20 89 CA 31 C9 89 54 24 10 8B 54 24 24 01 44 24 10 89 4C 24 14 11 54 24 14 8B 54 24 1C 89 D0 31 D2 01 44 24 10 11 54 24 14 8B 54 24 18 8B 44 24 38 89 D1 31 D2 89 54 24 18 31 D2 01 44 24 18 89 4C 24 1C 11 54 24 1C 3B 7C 24 14 0F 87 41 00 00 00 72 06 3B 74 24 10 77 39 8B 54 24 14 8B 44 24 10 31 FA 31 F0 09 C2 0F 85 CD 01 00 00 8B 54 24 1C 39 54 24 0C 0F 82 BF 01 00 00 77 15 8B 4C 24 18 39 4C 24 08 0F 82 AF 01 00 00 8D B4 26 00 00 00 00 83 0D ?? ?? ?? ?? 01 B8 00 00 00 80 E9 55 FD FF FF 3D C0 87 AD BE 0F 87 48 FD FF FF E9 75 FD FF FF 8B 54 24 0C 31 C0 0B 54 24 08 0F 84 35 FD FF FF 81 7C 24 0C FF FF 1F 00 0F 86 F6 05 00 00 8B 54 24 0C 89 D0 31 D2 89 44 24 68 89 54 24 6C DF 6C 24 68 DD 5C 24 10 8B 54 24 14 89 D0 C1 E8 14 25 FF 07 00 00 2D DE 03 00 00 E9 79 FD FF FF 90 31 C0 81 7C 24 0C 63 8E 8D 37 0F 87 E6 FC FF FF 89 CA 81 E2 00 00 00 60 81 FA 00 00 00 60 0F 85 31 FD FF FF E9 CD FC FF FF 8D B4 26 00 00 00 00 83 FA 1E 0F 8F 05 08 00 00 8D 4A F5 B8 05 00 00 00 F7 24 CD ?? ?? ?? ?? C7 44 24 1C 00 00 00 00 89 54 24 14 89 44 24 10 B8 05 00 00 00 F7 24 CD ?? ?? ?? ?? 8B 4C 24 14 89 54 24 2C 89 CA 31 C9 89 4C 24 24 8B 4C 24 10 89 54 24 20 8B 54 24 1C 89 44 24 28 89 4C 24 18 8B 44 24 18 03 44 24 20 13 54 24 24 8B 4C 24 2C 89 44 24 10 8B 44 24 20 89 54 24 14 8B 54 24 28 01 54 24 10 11 4C 24 14 8B 54 24 24 8B 4C 24 14 03 44 24 28 13 54 24 2C 89 44 24 20 89 54 24 24 89 CA 31 C9 01 54 24 20 8B 44 24 10 11 4C 24 24 8B 4C 24 1C 89 C2 31 C0 89 54 24 14 8B 54 24 18 89 44 24 10 01 54 24 10 11 4C 24 14 3B 7C 24 24 0F 87 92 FE FF FF 72 0A 3B 74 24 20 0F 87 86 FE FF FF 8B 54 24 24 8B 4C 24 20 31 FA 31 F1 09 CA 75 1E 8B 54 24 14 39 54 24 0C 72 14 0F 87 66 FE FF FF 8B 4C 24 10 39 4C 24 08 0F 83 58 FE FF FF 83 FB 00 7C 23 8B 44 24 08 0F 84 BD 03 00 00 85 ED 0F 84 56 05 00 00 F7 D8 0F AF 04 DD ?? ?? ?? ?? E9 98 FB FF FF 66 90 89 D9 F7 D9 83 F9 13 89 4C 24 54 0F 8F 4D 05 00 00 F7 D3 8B 54 24 08 8B 4C 24 0C 03 14 DD ?? ?? ?? ?? 13 0C DD ?? ?? ?? ?? 89 5C 24 50 39 4C 24 0C 72 0E 77 06 39 54 24 08 76 06 83 C6 01 83 D7 00 8B 5C 24 50 89 54 24 20 C7 44 24 3C 00 00 00 00 C1 E3 04 8B 83 ?? ?? ?? ?? 8B 93 ?? ?? ?? ?? 89 44 24 28 89 54 24 30 F7 E1 89 44 24 10 8B 44 24 30 89 54 24 14 F7 E1 89 44 24 18 8B 44 24 20 89 54 24 1C F7 64 24 28 89 54 24 44 8B 54 24 10 89 44 24 40 89 54 24 38 8B 54 24 44 89 D0 31 D2 89 44 24 08 8B 44 24 38 01 44 24 08 8B 44 24 20 89 54 24 0C 8B 54 24 3C 11 54 24 0C F7 64 24 30 01 44 24 08 11 54 24 0C 8B 54 24 14 89 D0 31 D2 89 44 24 10 8B 44 24 18 01 44 24 10 89 54 24 14 8B 54 24 1C 11 54 24 14 8B 54 24 0C 89 D0 31 D2 01 44 24 10 11 54 24 14 8B 93 ?? ?? ?? ?? 8B 9B ?? ?? ?? ?? 89 D0 89 54 24 38 F7 E1 89 5C 24 4C 89 44 24 58 89 D8 31 DB 89 54 24 5C F7 E1 8B 4C 24 58 89 44 24 60 8B 44 24 20 89 54 24 64 F7 64 24 38 89 D0 31 D2 89 44 24 18 01 4C 24 18 89 54 24 1C 11 5C 24 1C 8B 5C 24 5C 8B 44 24 20 89 D9 31 DB 03 4C 24 60 13 5C 24 64 F7 64 24 4C 01 44 24 18 11 54 24 1C 8B 54 24 1C 89 D0 31 D2 01 C1 8B 44 24 08 11 D3 89 C2 B8 00 00 00 00 89 44 24 08 8B 44 24 40 89 54 24 0C 31 D2 01 44 24 08 11 54 24 0C 01 4C 24 08 11 5C 24 0C 3B 5C 24 0C 72 12 77 06 3B 4C 24 08 76 0A 83 44 24 10 01 83 54 24 14 00 8B 44 24 28 89 F9 89 F7 F7 E1 89 44 24 18 8B 44 24 30 89 54 24 1C F7 E1 89 44 24 40 8B 44 24 28 89 54 24 44 F7 E6 89 54 24 2C 8B 74 24 2C 31 D2 89 44 24 28 8B 44 24 18 89 F3 31 F6 89 5C 24 20 01 44 24 20 8B 44 24 30 89 74 24 24 8B 74 24 1C 11 54 24 24 F7 E7 01 44 24 20 89 F3 11 54 24 24 31 F6 8B 54 24 24 89 5C 24 18 8B 5C 24 40 01 5C 24 18 89 74 24 1C 8B 74 24 44 89 D0 11 74 24 1C 31 D2 01 44 24 18 8B 44 24 38 11 54 24 1C F7 E1 89 44 24 30 8B 44 24 4C 89 54 24 34 F7 E1 89 44 24 40 8B 44 24 38 89 54 24 44 F7 E7 89 54 24 3C 8B 5C 24 3C 31 D2 89 44 24 38 8B 44 24 30 89 D9 31 DB 01 C1 8B 44 24 4C 11 D3 F7 E7 8B 7C 24 34 01 C1 89 FE 11 D3 31 FF 03 74 24 40 89 DA 13 7C 24 44 89 D0 31 D2 01 C6 11 D7 31 C0 89 44 24 30 8B 44 24 38 31 D2 01 44 24 30 8B 44 24 20 89 4C 24 34 8B 4C 24 28 11 54 24 34 31 DB 89 C2 31 C0 01 C8 11 DA 01 F0 11 FA 39 D7 72 10 77 04 39 C6 76 0A 83 44 24 18 01 83 54 24 1C 00 8B 4C 24 30 BE 01 00 00 00 8B 5C 24 34 03 4C 24 08 13 5C 24 0C 31 FF 39 5C 24 34 77 0C 72 06 39 4C 24 30 77 04 31 F6 31 FF 8B 4C 24 10 01 F0 8B 5C 24 14 11 FA 01 C1 11 D3 39 DA 89 4C 24 10 89 5C 24 14 0F 87 2A 02 00 00 72 08 39 C8 0F 87 20 02 00 00 31 DB 39 D7 B9 01 00 00 00 77 0A 72 04 39 C6 77 04 31 C9 31 DB 89 C8 89 DA 03 44 24 18 13 54 24 1C 83 7C 24 54 16 0F 8F 35 02 00 00 8B 5C 24 50 31 FF 8B 74 24 14 8B 0C 9D ?? ?? ?? ?? 8B 5C 24 10 0F AD F3 D3 EE F6 C1 20 0F 45 DE 0F 45 F7 89 5C 24 10 BB 40 00 00 00 29 CB 89 74 24 14 89 D9 89 C6 D3 E6 31 C0 F6 C3 20 0F 45 F0 8B 44 24 10 09 F0 85 ED 0F 84 EA F7 FF FF F7 D8 E9 E3 F7 FF FF 8B 44 24 18 8B 5C 24 0C C1 E0 05 05 ?? ?? ?? ?? 39 58 14 0F 87 96 F8 FF FF 72 12 8B 5C 24 08 39 58 10 0F 87 87 F8 FF FF 90 8D 74 26 00 83 C2 01 E9 7A F8 FF FF 85 ED 0F 84 D0 00 00 00 83 FA 0B 0F 8F D7 FA FF FF C7 44 24 10 0B 00 00 00 8B 4C 24 0C 29 54 24 10 8B 44 24 10 8B 54 24 08 0F AF 0C C5 ?? ?? ?? ?? 0F AF 14 C5 ?? ?? ?? ?? 8B 44 24 08 01 CA 8B 4C 24 10 89 54 24 18 F7 24 CD ?? ?? ?? ?? 8B 4C 24 18 89 44 24 10 01 CA 83 FA 05 89 54 24 14 0F 82 8B FB FF FF 0F 87 DD F9 FF FF 83 7C 24 10 04 0F 86 7A FB FF FF 66 90 E9 CB F9 FF FF DF 6C 24 08 DD 5C 24 10 8B 54 24 14 89 D0 C1 E8 14 25 FF 07 00 00 2D FE 03 00 00 E9 93 F7 FF FF 89 FB 09 F3 0F 85 47 F8 FF FF 8B 74 24 0C 39 34 C5 ?? ?? ?? ?? 0F 87 F4 F6 FF FF 0F 82 30 F8 FF FF 8B 54 24 08 39 14 C5 ?? ?? ?? ?? 0F 87 DD F6 FF FF E9 1A F8 FF FF 8D 74 26 00 83 FA 0B 0F 8F 1D F8 FF FF C7 44 24 10 0B 00 00 00 8B 4C 24 0C 29 54 24 10 8B 44 24 10 8B 54 24 08 0F AF 0C C5 ?? ?? ?? ?? 0F AF 14 C5 ?? ?? ?? ?? 8B 44 24 08 01 CA 8B 4C 24 10 89 54 24 18 F7 24 CD ?? ?? ?? ?? 8B 4C 24 18 89 44 24 10 01 CA 83 FA 04 89 54 24 14 0F 82 BB FA FF FF 0F 87 0D F9 FF FF 83 7C 24 10 FA 0F 86 AA FA FF FF 66 90 E9 FB F8 FF FF 39 C6 0F 87 A3 FE FF FF 8D 76 00 E9 0D F7 FF FF 0F AF 04 DD ?? ?? ?? ?? E9 44 F6 FF FF B8 01 00 00 00 31 D2 E9 ED FD FF FF B8 EC FF FF FF 8B 54 24 08 29 D8 8B 4C 24 0C F7 D3 C1 E0 04 03 90 ?? ?? ?? ?? 89 5C 24 50 13 88 ?? ?? ?? ?? 03 B0 ?? ?? ?? ?? 13 B8 ?? ?? ?? ?? E9 9A FA FF FF 8B 5C 24 50 8B 0C 9D ?? ?? ?? ?? 83 E9 40 0F AD D0 D3 EA 83 E1 20 0F 45 C2 E9 F3 FD FF FF 8D 4A E1 C1 E1 04 8B 81 ?? ?? ?? ?? 8B 91 ?? ?? ?? ?? C7 44 24 24 00 00 00 00 C7 44 24 1C 00 00 00 00 89 44 24 18 89 54 24 20 8B 54 24 24 8B 44 24 20 C7 44 24 34 00 00 00 00 0F A4 C2 02 C1 E0 02 89 44 24 38 8B 44 24 18 89 54 24 3C 8B 54 24 1C 0F A4 C2 02 C1 E0 02 89 44 24 10 B8 FB FF FF FF 89 54 24 14 F7 64 24 20 89 54 24 24 8B 54 24 38 89 44 24 20 89 54 24 30 8B 54 24 24 89 D0 31 D2 89 44 24 28 8B 44 24 30 01 44 24 28 B8 FB FF FF FF 89 54 24 2C 8B 54 24 34 11 54 24 2C F7 64 24 18 01 44 24 28 11 54 24 2C 8B 44 24 28 89 C2 B8 00 00 00 00 89 44 24 18 8B 44 24 20 89 54 24 1C 31 D2 01 44 24 18 11 54 24 1C 6B 81 ?? ?? ?? ?? FB 8B 91 ?? ?? ?? ?? 8D 14 90 B8 FB FF FF FF 89 54 24 20 F7 A1 ?? ?? ?? ?? 8B 4C 24 20 89 44 24 30 8B 44 24 30 01 CA 89 54 24 34 8B 54 24 34 01 44 24 10 11 54 24 14 8B 54 24 3C 89 D0 31 D2 01 44 24 10 11 54 24 14 8B 54 24 2C 89 D0 31 D2 01 44 24 10 11 54 24 14 E9 07 F7 FF FF 8D 4A E1 B8 05 00 00 00 C1 E1 04 F7 A1 ?? ?? ?? ?? C7 44 24 24 00 00 00 00 89 44 24 10 B8 05 00 00 00 89 54 24 14 F7 A1 ?? ?? ?? ?? 89 54 24 2C 8B 54 24 14 89 44 24 28 89 D0 31 D2 89 54 24 3C 8B 54 24 10 89 44 24 38 8B 44 24 38 89 54 24 20 8B 54 24 3C 03 44 24 20 13 54 24 24 89 44 24 18 8B 44 24 28 01 44 24 18 8B 44 24 18 89 54 24 1C 8B 54 24 2C 11 54 24 1C 89 C2 B8 00 00 00 00 89 44 24 10 8B 44 24 20 01 44 24 10 89 54 24 14 8B 54 24 24 11 54 24 14 8B 91 ?? ?? ?? ?? 8B 81 ?? ?? ?? ?? 8D 14 92 8D 04 80 01 D0 89 44 24 20 B8 05 00 00 00 F7 A1 ?? ?? ?? ?? 8B 4C 24 20 89 44 24 30 8B 44 24 30 01 CA 8B 4C 24 3C 89 54 24 34 8B 54 24 34 03 44 24 28 13 54 24 2C 89 44 24 20 89 54 24 24 8B 54 24 38 01 54 24 20 8B 54 24 1C 11 4C 24 24 89 D0 31 D2 01 44 24 20 11 54 24 24 E9 B1 F7 FF FF C1 E2 04 8B 4C 24 0C 39 8A ?? ?? ?? ?? 0F 87 9E F3 FF FF 0F 82 DA F4 FF FF 8B 5C 24 08 39 9A ?? ?? ?? ?? 0F 87 88 F3 FF FF E9 C5 F4 FF FF EB 0D 90 90 90 90 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_102_9_0 {
	meta:
		name = "___bid128_to_int32_xrninta"
		size = 4384
		refs = "0112 ___bid_nr_digits 019c ___bid_midpoint128 01d3 ___bid_IDEC_glbflags 02a4 ___bid_ten2k64 04c2 ___bid_midpoint64 05eb ___bid_ten2mk128 094b ___bid_shiftright128 0952 ___bid_maskhigh128 0a18 ___bid_ten2mk128trunc 0be0 ___bid_onehalf128 0d2c ___bid_ten2k128"
	strings:
		$1 = { 81 EC 9C 00 00 00 8B 84 24 A0 00 00 00 89 B4 24 90 00 00 00 8B B4 24 AC 00 00 00 89 9C 24 8C 00 00 00 89 AC 24 98 00 00 00 89 44 24 70 8B 84 24 A4 00 00 00 8B 4C 24 70 89 F2 89 F5 81 E2 00 00 00 78 81 E5 00 00 00 80 81 FA 00 00 00 78 89 44 24 74 8B 5C 24 74 89 BC 24 94 00 00 00 8B 84 24 A8 00 00 00 89 4C 24 08 89 5C 24 0C 0F 84 6E 01 00 00 89 F3 89 C1 81 E3 FF FF 01 00 81 FB 09 ED 01 00 76 2C 31 C0 8B 9C 24 8C 00 00 00 8B B4 24 90 00 00 00 8B BC 24 94 00 00 00 8B AC 24 98 00 00 00 81 C4 9C 00 00 00 C3 8D B4 26 00 00 00 00 0F 83 4D 01 00 00 89 DA 89 C8 81 F2 09 ED 01 00 35 C0 87 AD BE 09 C2 0F 84 94 01 00 00 89 F0 25 00 00 00 60 3D 00 00 00 60 74 A9 89 DF 09 CF 0F 84 2E 01 00 00 89 4C 24 68 89 5C 24 6C DF 6C 24 68 DD 5C 24 10 8B 54 24 14 89 D0 C1 E8 14 25 FF 07 00 00 2D BE 03 00 00 83 E8 01 89 C7 C1 E7 05 8B 97 ?? ?? ?? ?? 89 44 24 18 85 D2 75 34 8B 87 ?? ?? ?? ?? 8B 97 ?? ?? ?? ?? 8B BF ?? ?? ?? ?? 89 44 24 10 39 FB 0F 87 C4 02 00 00 0F 83 33 04 00 00 8B 44 24 10 31 DF 31 C8 09 C7 0F 84 7F 02 00 00 81 E6 00 00 FE 7F C1 EE 11 8D BE E0 E7 FF FF 8D 04 3A 83 F8 0A 0F 8F 13 03 00 00 0F 84 95 02 00 00 83 F8 00 0F 8C 09 04 00 00 8D 74 26 00 0F 85 12 02 00 00 8D 42 FF 83 F8 12 0F 8E 1F 03 00 00 83 EA 14 89 D0 C1 E0 04 8B B0 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 39 C3 0F 82 32 03 00 00 77 08 39 F1 0F 82 28 03 00 00 31 D8 31 F1 09 C8 66 90 0F 84 8B 0D 00 00 83 FD 01 19 C0 83 E0 02 83 E8 01 83 0D ?? ?? ?? ?? 20 E9 A9 FE FF FF 8D 76 00 89 F0 25 00 00 00 7C 3D 00 00 00 7C 0F 84 CE 01 00 00 83 0D ?? ?? ?? ?? 01 B8 00 00 00 80 E9 83 FE FF FF 3D C0 87 AD BE 0F 87 76 FE FF FF E9 A3 FE FF FF 8B 54 24 0C 31 C0 0B 54 24 08 0F 84 63 FE FF FF 81 7C 24 0C FF FF 1F 00 0F 86 60 02 00 00 8B 54 24 0C 89 D0 31 D2 89 44 24 68 89 54 24 6C DF 6C 24 68 DD 5C 24 10 8B 54 24 14 89 D0 C1 E8 14 25 FF 07 00 00 2D DE 03 00 00 E9 A7 FE FF FF 31 C0 81 7C 24 0C 63 8E 8D 37 0F 87 15 FE FF FF 89 F2 81 E2 00 00 00 60 81 FA 00 00 00 60 0F 85 60 FE FF FF E9 FC FD FF FF 8D B6 00 00 00 00 83 FA 1E 0F 8F 86 0A 00 00 8D 72 F5 B8 05 00 00 00 F7 24 F5 ?? ?? ?? ?? C7 44 24 1C 00 00 00 00 89 54 24 14 89 44 24 10 B8 05 00 00 00 F7 24 F5 ?? ?? ?? ?? 89 54 24 34 8B 54 24 14 89 44 24 30 89 D0 31 D2 89 54 24 24 8B 54 24 10 89 44 24 20 89 54 24 18 8B 44 24 18 03 44 24 20 8B 54 24 1C 13 54 24 24 89 44 24 10 8B 44 24 30 01 44 24 10 8B 44 24 20 89 54 24 14 8B 54 24 34 11 54 24 14 8B 54 24 24 03 44 24 30 13 54 24 34 89 44 24 28 89 54 24 2C 8B 54 24 14 89 D0 31 D2 01 44 24 28 8B 44 24 10 11 54 24 2C 89 C2 31 C0 89 44 24 10 8B 44 24 18 89 54 24 14 8B 54 24 1C 01 44 24 10 11 54 24 14 3B 5C 24 2C 0F 87 22 01 00 00 72 0A 3B 4C 24 28 0F 87 16 01 00 00 8B 54 24 2C 8B 74 24 28 31 DA 31 CE 09 F2 75 1E 8B 54 24 14 39 54 24 0C 72 14 0F 87 F6 00 00 00 8B 74 24 10 39 74 24 08 0F 83 E8 00 00 00 83 FF 00 0F 8C F2 01 00 00 8B 44 24 08 0F 85 3C 01 00 00 85 ED 0F 84 D3 FC FF FF F7 D8 E9 CC FC FF FF 8D B6 00 00 00 00 83 0D ?? ?? ?? ?? 01 B8 00 00 00 80 E9 B5 FC FF FF 8B 44 24 18 8B 7C 24 0C C1 E0 05 05 ?? ?? ?? ?? 39 78 14 0F 87 68 FD FF FF 72 14 8B 7C 24 08 39 78 10 0F 87 59 FD FF FF 8D B4 26 00 00 00 00 83 C2 01 E9 4A FD FF FF 85 ED 0F 85 F0 00 00 00 83 FA 0B 0F 8F 54 06 00 00 C7 44 24 10 0B 00 00 00 8B 74 24 0C 29 54 24 10 8B 44 24 10 8B 54 24 08 0F AF 34 C5 ?? ?? ?? ?? 0F AF 14 C5 ?? ?? ?? ?? 8B 44 24 08 01 F2 8B 74 24 10 89 54 24 18 F7 24 F5 ?? ?? ?? ?? 8B 74 24 18 89 44 24 10 01 F2 83 FA 04 89 54 24 14 0F 82 2B FF FF FF 77 11 83 7C 24 10 FA 0F 86 1E FF FF FF 8D B6 00 00 00 00 83 0D ?? ?? ?? ?? 01 B8 00 00 00 80 E9 F5 FB FF FF DF 6C 24 08 DD 5C 24 10 8B 54 24 14 89 D0 C1 E8 14 25 FF 07 00 00 2D FE 03 00 00 E9 57 FC FF FF 89 DF 09 CF 0F 85 0B FD FF FF 8B 54 24 0C 39 14 C5 ?? ?? ?? ?? 77 18 0F 82 F8 FC FF FF 8B 4C 24 08 39 0C C5 ?? ?? ?? ?? 0F 86 E7 FC FF FF 90 31 C0 E9 EA FC FF FF 85 ED 0F 84 71 05 00 00 F7 D8 0F AF 04 FD ?? ?? ?? ?? E9 88 FB FF FF 66 90 83 FA 0B 0F 8F 87 FD FF FF C7 44 24 10 0B 00 00 00 8B 74 24 0C 29 54 24 10 8B 44 24 10 8B 54 24 08 0F AF 34 C5 ?? ?? ?? ?? 0F AF 14 C5 ?? ?? ?? ?? 8B 44 24 08 01 F2 8B 74 24 10 89 54 24 18 F7 24 F5 ?? ?? ?? ?? 8B 74 24 18 89 44 24 10 01 F2 83 FA 05 89 54 24 14 0F 82 3B FE FF FF 0F 87 1D FF FF FF 83 7C 24 10 04 0F 86 2A FE FF FF 66 90 E9 0B FF FF FF 39 C1 0F 87 83 FE FF FF 8D 76 00 E9 BD FB FF FF 83 0D ?? ?? ?? ?? 20 31 C0 E9 F3 FA FF FF 89 FE F7 DE 83 FE 13 89 74 24 5C 0F 8F 46 07 00 00 F7 D7 8B 44 24 08 8B 54 24 0C 03 04 FD ?? ?? ?? ?? 13 14 FD ?? ?? ?? ?? 89 7C 24 4C 39 54 24 0C 72 0E 77 06 39 44 24 08 76 06 83 C1 01 83 D3 00 8B 7C 24 4C 89 D6 89 44 24 28 C7 44 24 24 00 00 00 00 C1 E7 04 8B 87 ?? ?? ?? ?? 8B 97 ?? ?? ?? ?? 89 44 24 30 89 54 24 38 F7 E6 89 44 24 18 8B 44 24 38 89 54 24 1C F7 E6 89 44 24 10 8B 44 24 28 89 54 24 14 F7 64 24 30 89 54 24 44 8B 54 24 18 89 44 24 40 89 54 24 20 8B 54 24 44 89 D0 31 D2 89 44 24 08 8B 44 24 20 01 44 24 08 8B 44 24 28 89 54 24 0C 8B 54 24 24 11 54 24 0C F7 64 24 38 01 44 24 08 11 54 24 0C 8B 54 24 1C 89 D0 31 D2 89 44 24 18 8B 44 24 10 01 44 24 18 89 54 24 1C 8B 54 24 14 11 54 24 1C 8B 54 24 0C 89 D0 31 D2 01 44 24 18 11 54 24 1C 8B 97 ?? ?? ?? ?? 8B BF ?? ?? ?? ?? 89 D0 89 54 24 20 F7 E6 89 7C 24 58 89 44 24 10 89 F8 89 54 24 14 F7 E6 89 44 24 50 8B 44 24 28 89 54 24 54 F7 64 24 20 89 54 24 64 8B 7C 24 64 31 D2 89 44 24 60 8B 44 24 10 89 FE 31 FF 01 C6 8B 44 24 28 11 D7 F7 64 24 58 01 C6 11 D7 8B 54 24 14 89 D0 31 D2 89 44 24 10 8B 44 24 50 01 44 24 10 89 54 24 14 8B 54 24 54 11 54 24 14 89 FA 89 D0 31 D2 89 74 24 54 8B 74 24 08 01 44 24 10 11 54 24 14 31 C0 31 D2 89 44 24 50 8B 44 24 60 89 F7 01 44 24 50 11 54 24 54 31 F6 8B 44 24 40 31 D2 89 74 24 08 01 44 24 08 8B 44 24 10 89 7C 24 0C 11 54 24 0C 8B 54 24 14 01 44 24 08 11 54 24 0C 8B 74 24 0C 39 F2 72 14 77 08 8B 7C 24 08 39 F8 76 0A 83 44 24 18 01 83 54 24 1C 00 8B 44 24 30 F7 E3 89 44 24 10 8B 44 24 38 89 54 24 14 F7 E3 89 44 24 40 8B 44 24 30 89 54 24 44 F7 E1 89 54 24 34 8B 7C 24 34 31 D2 89 44 24 30 8B 44 24 10 89 FE 31 FF 89 74 24 28 01 44 24 28 8B 44 24 38 89 7C 24 2C 8B 7C 24 14 11 54 24 2C F7 E1 01 44 24 28 89 FE 11 54 24 2C 31 FF 8B 54 24 2C 89 74 24 10 8B 74 24 40 01 74 24 10 89 7C 24 14 8B 7C 24 44 89 D0 11 7C 24 14 31 D2 01 44 24 10 8B 44 24 20 11 54 24 14 F7 E3 89 44 24 38 8B 44 24 58 89 54 24 3C F7 E3 8B 5C 24 3C 89 44 24 40 8B 44 24 20 89 54 24 44 F7 E1 89 54 24 24 8B 7C 24 24 31 D2 89 44 24 20 8B 44 24 38 C7 44 24 24 00 00 00 00 89 FE 31 FF 01 C6 8B 44 24 58 11 D7 F7 E1 89 D9 01 C6 11 D7 31 DB 03 4C 24 40 89 FA 13 5C 24 44 89 D0 31 D2 01 C1 11 D3 31 C0 89 44 24 38 8B 44 24 20 31 D2 89 74 24 3C 8B 74 24 30 01 44 24 38 8B 44 24 28 11 54 24 3C 89 74 24 20 89 C2 31 C0 03 44 24 20 13 54 24 24 01 C8 11 DA 39 D3 72 10 77 04 39 C1 76 0A 83 44 24 10 01 83 54 24 14 00 8B 5C 24 08 B9 01 00 00 00 03 5C 24 38 8B 74 24 0C 13 74 24 3C 89 5C 24 08 31 DB 39 74 24 3C 89 74 24 0C 77 10 72 0A 8B 74 24 08 39 74 24 38 77 04 31 C9 31 DB 89 CE 89 DF 01 C6 8B 44 24 18 11 D7 8B 54 24 1C 01 F0 11 FA 39 D7 89 44 24 20 89 54 24 24 0F 87 D8 03 00 00 72 08 39 C6 0F 87 CE 03 00 00 31 D2 39 FB B8 01 00 00 00 77 0A 72 04 39 F1 77 04 31 C0 31 D2 89 C6 89 D7 03 74 24 10 13 7C 24 14 83 7C 24 5C 16 0F 8F 56 03 00 00 8B 5C 24 4C 8B 44 24 20 8B 54 24 24 8B 0C 9D ?? ?? ?? ?? 23 04 DD ?? ?? ?? ?? 23 14 DD ?? ?? ?? ?? 31 DB 89 4C 24 04 0F B6 4C 24 04 89 44 24 18 8B 44 24 20 89 54 24 1C 8B 54 24 24 0F AD D0 D3 EA F6 C1 20 0F 45 C2 0F 45 D3 BB 40 00 00 00 2B 5C 24 04 89 44 24 10 89 F0 31 F6 89 54 24 14 89 D9 D3 E0 F6 C3 20 0F 45 C6 8B 74 24 10 C7 44 24 14 00 00 00 00 C7 44 24 10 00 00 00 00 09 C6 85 ED 89 F0 74 02 F7 D8 83 7C 24 5C 03 0F 8F F2 01 00 00 81 7C 24 0C 00 00 00 80 0F 87 A5 05 00 00 72 0B 83 7C 24 08 00 0F 87 98 05 00 00 8B 54 24 0C 81 C2 00 00 00 80 0B 54 24 08 0F 85 D4 F7 FF FF 8B 54 24 54 0B 54 24 50 0F 84 C6 F7 FF FF 8B 54 24 4C 31 C9 31 DB C1 E2 04 8B B2 ?? ?? ?? ?? 8B 92 ?? ?? ?? ?? 31 DA 31 F1 09 CA 0F 85 58 F6 FF FF 8B 54 24 4C 8B 4C 24 54 C1 E2 04 3B 8A ?? ?? ?? ?? 0F 82 41 F6 FF FF 0F 87 86 F7 FF FF 8B 5C 24 50 3B 9A ?? ?? ?? ?? 0F 82 2B F6 FF FF E9 71 F7 FF FF 0F AF 04 FD ?? ?? ?? ?? E9 19 F6 FF FF 83 FA 1E 0F 8F AE 03 00 00 8D 72 F5 8B 04 F5 ?? ?? ?? ?? 8B 34 F5 ?? ?? ?? ?? C7 44 24 1C 00 00 00 00 8B 54 24 1C C7 44 24 34 00 00 00 00 89 44 24 30 89 74 24 18 8B 44 24 18 BE FB FF FF FF C7 44 24 3C 00 00 00 00 0F A4 C2 02 C1 E0 02 89 44 24 10 8B 44 24 30 89 54 24 14 8B 54 24 34 0F A4 C2 02 C1 E0 02 89 44 24 28 8B 44 24 18 89 54 24 2C F7 E6 89 54 24 24 8B 54 24 10 89 44 24 20 89 54 24 38 8B 54 24 24 89 D0 31 D2 89 44 24 18 8B 44 24 38 01 44 24 18 8B 44 24 30 89 54 24 1C 8B 54 24 3C 11 54 24 1C F7 E6 01 44 24 18 11 54 24 1C 8B 54 24 14 89 D0 31 D2 89 44 24 10 8B 44 24 28 01 44 24 10 89 54 24 14 8B 54 24 2C 11 54 24 14 8B 54 24 1C 89 D0 31 D2 01 44 24 10 8B 44 24 18 11 54 24 14 89 C2 31 C0 89 44 24 18 8B 44 24 20 89 54 24 1C 31 D2 01 44 24 18 11 54 24 1C 3B 5C 24 14 0F 87 0A F9 FF FF 72 0A 3B 4C 24 10 0F 87 FE F8 FF FF 8B 54 24 14 8B 44 24 10 31 DA 31 C8 09 C2 0F 85 02 F8 FF FF 8B 54 24 1C 39 54 24 0C 0F 82 F4 F7 FF FF 0F 87 D6 F8 FF FF 8B 74 24 18 39 74 24 08 0F 82 E0 F7 FF FF E9 C3 F8 FF FF 8D 76 00 83 7C 24 5C 16 0F 8F FA 03 00 00 8B 74 24 14 0B 74 24 10 0F 85 A7 04 00 00 8B 7C 24 4C 8B 1C FD ?? ?? ?? ?? 39 5C 24 1C 8B 0C FD ?? ?? ?? ?? 0F 87 9D 04 00 00 0F 83 DE 04 00 00 3B 5C 24 1C 0F 85 CC F5 FF FF 3B 4C 24 18 0F 85 C2 F5 FF FF 8B 54 24 0C 0B 54 24 08 75 0E 8B 4C 24 54 0B 4C 24 50 0F 84 AA F5 FF FF 8B 54 24 4C C1 E2 04 8B 8A ?? ?? ?? ?? 8B 92 ?? ?? ?? ?? 39 54 24 0C 0F 87 8D F5 FF FF 72 0A 39 4C 24 08 0F 87 81 F5 FF FF 33 54 24 0C 33 4C 24 08 09 CA 0F 85 26 F4 FF FF 8B 54 24 4C 8B 7C 24 54 C1 E2 04 3B BA ?? ?? ?? ?? 0F 82 0F F4 FF FF 0F 87 54 F5 FF FF 8B 4C 24 50 3B 8A ?? ?? ?? ?? 0F 86 F9 F3 FF FF E9 3F F5 FF FF 8B 5C 24 4C 8B 04 DD ?? ?? ?? ?? 8B 14 DD ?? ?? ?? ?? 8B 0C 9D ?? ?? ?? ?? 21 F0 21 FA 89 44 24 10 8B 44 24 20 89 54 24 14 8B 54 24 24 89 4C 24 48 83 E9 40 0F AD FE D3 EF F6 C1 20 0F 45 F7 89 44 24 18 89 54 24 1C E9 DD FC FF FF BE 01 00 00 00 31 FF E9 3F FC FF FF BE EC FF FF FF 8B 44 24 08 29 FE 8B 54 24 0C F7 D7 C1 E6 04 03 86 ?? ?? ?? ?? 89 7C 24 4C 13 96 ?? ?? ?? ?? 03 8E ?? ?? ?? ?? 13 9E ?? ?? ?? ?? E9 A1 F8 FF FF 8D 72 E1 B8 05 00 00 00 C1 E6 04 F7 A6 ?? ?? ?? ?? C7 44 24 2C 00 00 00 00 89 44 24 10 B8 05 00 00 00 89 54 24 14 F7 A6 ?? ?? ?? ?? 89 54 24 34 8B 54 24 14 89 44 24 30 89 D0 31 D2 89 54 24 24 8B 54 24 10 89 44 24 20 8B 44 24 20 89 54 24 28 8B 54 24 24 03 44 24 28 13 54 24 2C 89 44 24 18 8B 44 24 30 01 44 24 18 8B 44 24 18 89 54 24 1C 8B 54 24 34 11 54 24 1C 89 C2 B8 00 00 00 00 89 44 24 10 8B 44 24 28 01 44 24 10 89 54 24 14 8B 54 24 2C 11 54 24 14 8B 96 ?? ?? ?? ?? 8B 86 ?? ?? ?? ?? 8D 14 92 8D 04 80 01 D0 89 44 24 28 B8 05 00 00 00 F7 A6 ?? ?? ?? ?? 8B 74 24 28 89 44 24 38 8B 44 24 38 01 F2 89 54 24 3C 8B 54 24 3C 03 44 24 30 13 54 24 34 89 44 24 28 8B 44 24 20 01 44 24 28 89 54 24 2C 8B 54 24 24 11 54 24 2C 8B 54 24 1C 89 D0 31 D2 01 44 24 28 11 54 24 2C E9 30 F5 FF FF 8D 72 E1 C1 E6 04 8B 96 ?? ?? ?? ?? 8B 86 ?? ?? ?? ?? C7 44 24 2C 00 00 00 00 C7 44 24 1C 00 00 00 00 89 54 24 18 8B 54 24 2C 89 44 24 28 8B 44 24 28 C7 44 24 3C 00 00 00 00 0F A4 C2 02 C1 E0 02 89 44 24 20 8B 44 24 18 89 54 24 24 8B 54 24 1C 0F A4 C2 02 C1 E0 02 89 44 24 10 B8 FB FF FF FF 89 54 24 14 F7 64 24 28 89 54 24 2C 8B 54 24 20 89 44 24 28 89 54 24 38 8B 54 24 2C 89 D0 31 D2 89 44 24 30 8B 44 24 38 01 44 24 30 B8 FB FF FF FF 89 54 24 34 8B 54 24 3C 11 54 24 34 F7 64 24 18 01 44 24 30 11 54 24 34 8B 44 24 30 89 C2 B8 00 00 00 00 89 44 24 18 8B 44 24 28 89 54 24 1C 31 D2 01 44 24 18 11 54 24 1C 6B 86 ?? ?? ?? ?? FB 8B 96 ?? ?? ?? ?? 8D 14 90 B8 FB FF FF FF 89 54 24 28 F7 A6 ?? ?? ?? ?? 8B 74 24 28 89 44 24 38 8B 44 24 38 01 F2 89 54 24 3C 8B 54 24 3C 01 44 24 10 11 54 24 14 8B 54 24 24 89 D0 31 D2 01 44 24 10 11 54 24 14 8B 54 24 34 89 D0 31 D2 01 44 24 10 11 54 24 14 E9 1B FC FF FF C1 E2 04 8B 5C 24 0C 39 9A ?? ?? ?? ?? 0F 87 7C F5 FF FF 0F 82 5C F2 FF FF 8B 74 24 08 39 B2 ?? ?? ?? ?? 0F 86 4C F2 FF FF 31 C0 E9 50 F2 FF FF 8B 4C 24 08 8B 5C 24 0C 8B 54 24 4C 83 C1 00 81 D3 00 00 00 80 C1 E2 04 8B B2 ?? ?? ?? ?? 8B 92 ?? ?? ?? ?? 39 D3 0F 87 24 F2 FF FF 0F 82 6F FA FF FF 39 F1 0F 87 16 F2 FF FF 90 8D 74 26 00 E9 5D FA FF FF 8B 5C 24 4C 8B 14 DD ?? ?? ?? ?? 39 54 24 14 8B 0C DD ?? ?? ?? ?? 0F 87 F0 F1 FF FF 72 0A 39 4C 24 10 0F 87 E4 F1 FF FF 33 54 24 14 33 4C 24 10 09 CA 0F 85 D4 F1 FF FF 8B 74 24 }
	condition:
		$1
}

rule file_104_0_0 {
	meta:
		name = "___subtf3"
		size = 10080
	strings:
		$1 = { 55 57 56 53 81 EC DC 00 00 00 8B 8C 24 0C 01 00 00 8B B4 24 08 01 00 00 8B 9C 24 04 01 00 00 8B 84 24 00 01 00 00 89 CD 0F B7 F9 8B 94 24 1C 01 00 00 89 4C 24 5C C1 ED 10 C1 E9 18 81 E5 FF 7F 00 00 C0 E9 07 89 6C 24 1C 0F B6 E9 88 4C 24 20 89 F1 C1 E9 1D C1 E7 03 09 CF 89 D9 89 74 24 58 C1 E9 1D C1 E6 03 09 F1 8B B4 24 14 01 00 00 89 8C 24 88 00 00 00 89 C1 89 5C 24 54 C1 E9 1D C1 E3 03 09 D9 8B 9C 24 18 01 00 00 89 8C 24 84 00 00 00 8B 8C 24 14 01 00 00 C1 E6 03 89 44 24 50 89 BC 24 8C 00 00 00 8D 3C C5 00 00 00 00 8B 84 24 10 01 00 00 89 5C 24 68 C1 EB 1D 89 4C 24 64 0F B7 CA C1 E1 03 09 D9 8B 9C 24 18 01 00 00 89 8C 24 9C 00 00 00 8B 8C 24 14 01 00 00 D9 7C 24 4E 89 6C 24 24 C1 E3 03 C1 E9 1D 09 D9 8B 9C 24 10 01 00 00 89 44 24 60 89 D0 89 54 24 6C C1 E8 10 89 BC 24 80 00 00 00 C1 EA 18 25 FF 7F 00 00 C1 EB 1D 09 F3 89 8C 24 98 00 00 00 C0 EA 07 89 9C 24 94 00 00 00 8B AC 24 10 01 00 00 C1 E5 03 3D FF 7F 00 00 89 AC 24 90 00 00 00 0F 84 63 04 00 00 83 F2 01 0F B6 D2 89 54 24 18 8B 74 24 1C 8B 54 24 18 29 C6 39 54 24 24 0F 84 52 03 00 00 83 FE 00 0F 8E 19 06 00 00 85 C0 0F 85 5F 02 00 00 8B 8C 24 94 00 00 00 8B 94 24 9C 00 00 00 89 4C 24 28 8B 8C 24 98 00 00 00 8B 44 24 28 09 C8 09 D0 09 E8 0F 85 28 04 00 00 81 7C 24 1C FF 7F 00 00 0F 84 48 0E 00 00 8B B4 24 8C 00 00 00 8B 84 24 88 00 00 00 8B 94 24 84 00 00 00 C7 44 24 10 00 00 00 00 8B 6C 24 1C 89 FB 89 94 24 A4 00 00 00 0F B7 4C 24 4E 83 E3 07 8B 54 24 1C 89 BC 24 A0 00 00 00 89 6C 24 14 8B 6C 24 24 89 84 24 A8 00 00 00 66 81 E1 00 0C 89 B4 24 AC 00 00 00 83 C2 01 8B 44 24 10 83 C8 20 85 DB 0F 44 44 24 10 89 44 24 10 66 81 F9 00 04 0F 84 58 05 00 00 66 81 F9 00 08 0F 84 2B 05 00 00 66 85 C9 75 56 89 F8 83 E0 0F 83 F8 04 74 4C 8D 47 04 89 84 24 A0 00 00 00 83 F8 03 8B 84 24 A4 00 00 00 0F 96 C3 0F B6 DB 01 D8 39 C3 89 84 24 A4 00 00 00 8B 84 24 A8 00 00 00 0F 97 C3 0F B6 DB 01 D8 39 C3 89 84 24 A8 00 00 00 0F 97 C0 0F B6 C0 01 C6 89 B4 24 AC 00 00 00 F7 C6 00 00 08 00 0F 85 5E 04 00 00 0F B7 6C 24 14 89 D7 8B 84 24 A4 00 00 00 81 E7 FF 7F 00 00 8B 9C 24 A0 00 00 00 66 81 E5 FF 7F 89 C1 8B B4 24 A8 00 00 00 C1 EB 03 C1 E1 1D 09 D9 8B 9C 24 AC 00 00 00 C1 E8 03 89 F2 C1 E2 1D 09 C2 89 D8 C1 E0 1D C1 EE 03 09 F0 C1 EB 03 83 FF 01 89 8C 24 A0 00 00 00 89 CF 89 94 24 A4 00 00 00 89 84 24 A8 00 00 00 0F 8E 31 04 00 00 66 89 5C 24 7C 0F B7 5C 24 7E 66 81 E5 FF 7F 0F B6 4C 24 20 89 7C 24 70 89 54 24 74 66 81 E3 00 80 09 EB 66 89 5C 24 7E C1 E1 07 66 C1 EB 08 89 CE 83 E3 7F 09 F3 F6 44 24 10 01 88 5C 24 7F 8B 5C 24 7C 89 44 24 78 74 07 D9 EE D8 F0 DD D8 9B F6 44 24 10 08 74 18 D9 B4 24 B0 00 00 00 66 83 8C 24 B4 00 00 00 08 D9 A4 24 B0 00 00 00 9B F6 44 24 10 10 74 18 D9 B4 24 B0 00 00 00 66 83 8C 24 B4 00 00 00 10 D9 A4 24 B0 00 00 00 9B F6 44 24 10 20 74 18 D9 B4 24 B0 00 00 00 66 83 8C 24 B4 00 00 00 20 D9 A4 24 B0 00 00 00 9B 8B B4 24 F0 00 00 00 89 46 08 89 F0 89 3E 89 56 04 89 5E 0C 81 C4 DC 00 00 00 5B 5E 5F 5D C3 8D 76 00 81 7C 24 1C FF 7F 00 00 0F 84 49 0C 00 00 81 8C 24 9C 00 00 00 00 00 08 00 C7 44 24 10 00 00 00 00 83 FE 74 0F 8F E9 06 00 00 89 F3 83 E6 1F C1 FB 05 85 DB 89 74 24 14 0F 84 22 11 00 00 31 F6 8D 84 24 94 00 00 00 09 EE 8D 94 9C 90 00 00 00 39 D0 74 0B 8B 28 83 C0 04 09 EE 39 D0 75 F5 89 D8 8B 6C 24 14 85 ED 0F 85 77 09 00 00 BA 03 00 00 00 29 DA 8D 84 24 90 00 00 00 8D 94 94 94 00 00 00 8B 0C 98 89 08 83 C0 04 39 D0 75 F4 B8 04 00 00 00 29 D8 83 F8 04 74 16 8D 94 24 90 00 00 00 C7 04 82 00 00 00 00 83 C0 01 83 F8 03 7E F1 31 C0 8B 94 24 9C 00 00 00 85 F6 8B 8C 24 98 00 00 00 0F 95 C0 8B B4 24 90 00 00 00 8B AC 24 94 00 00 00 89 54 24 14 89 4C 24 18 09 C6 E9 62 06 00 00 83 FE 00 0F 8E EC 06 00 00 85 C0 0F 84 9D 01 00 00 81 7C 24 1C FF 7F 00 00 0F 84 56 0B 00 00 81 8C 24 9C 00 00 00 00 00 08 00 C7 44 24 10 00 00 00 00 83 FE 74 0F 8F B3 0B 00 00 89 F3 83 E6 1F C1 FB 05 85 DB 89 74 24 14 0F 84 B5 17 00 00 31 F6 8D 84 24 94 00 00 00 09 EE 8D 94 9C 90 00 00 00 39 D0 74 0B 8B 28 83 C0 04 09 EE 39 D0 75 F5 89 D8 8B 4C 24 14 85 C9 0F 85 10 10 00 00 BA 03 00 00 00 29 DA 8D 84 24 90 00 00 00 8D 94 94 94 00 00 00 8B 0C 98 89 08 83 C0 04 39 D0 75 F4 B8 04 00 00 00 29 D8 83 F8 04 74 16 8D 94 24 90 00 00 00 C7 04 82 00 00 00 00 83 C0 01 83 F8 03 7E F1 31 C0 8B 94 24 9C 00 00 00 85 F6 8B 8C 24 98 00 00 00 0F 95 C0 8B B4 24 90 00 00 00 8B AC 24 94 00 00 00 89 54 24 14 89 4C 24 18 09 C6 E9 2C 0B 00 00 09 D9 0F B6 F2 0B 8C 24 9C 00 00 00 89 74 24 18 09 E9 0F 85 8F FB FF FF E9 80 FB FF FF 83 EE 01 0F 85 85 06 00 00 8B B4 24 84 00 00 00 8B 84 24 8C 00 00 00 8B 9C 24 88 00 00 00 89 7C 24 20 89 74 24 18 29 EF 1B 74 24 28 19 CB 19 D0 89 BC 24 A0 00 00 00 8B 7C 24 1C 8B 6C 24 24 89 84 24 AC 00 00 00 89 9C 24 A8 00 00 00 89 B4 24 A4 00 00 00 89 7C 24 14 C7 44 24 10 02 00 00 00 8B B4 24 AC 00 00 00 F7 C6 00 00 08 00 0F 85 7C 03 00 00 8B BC 24 A0 00 00 00 89 EB 0F B7 4C 24 4E 83 E3 01 8B 54 24 14 88 5C 24 20 89 FB 66 81 E1 00 0C 83 E3 07 83 C2 01 E9 A3 FB FF FF 8B 8C 24 98 00 00 00 8B 9C 24 94 00 00 00 8B 94 24 9C 00 00 00 89 C8 09 D8 09 D0 09 E8 0F 84 17 FB FF FF 83 EE 01 0F 84 A7 0B 00 00 81 7C 24 1C FF 7F 00 00 C7 44 24 10 02 00 00 00 0F 85 42 FE FF FF 8B 8C 24 88 00 00 00 8B 94 24 84 00 00 00 8B B4 24 8C 00 00 00 89 C8 09 D0 09 F0 09 F8 74 0F 89 F0 C1 E0 0D C1 F8 1F 83 C0 03 89 44 24 10 89 BC 24 A0 00 00 00 89 94 24 A4 00 00 00 89 8C 24 A8 00 00 00 E9 88 09 00 00 8D B6 00 00 00 00 81 E6 FF FF F7 FF 81 FA FF 7F 00 00 89 B4 24 AC 00 00 00 0F 84 DA 02 00 00 8B 84 24 A4 00 00 00 8D 7A 01 89 D5 81 E7 FF 7F 00 00 66 81 E5 FF 7F 8B 9C 24 A0 00 00 00 89 54 24 14 89 C1 E9 82 FB FF FF 89 D6 09 CE 09 C6 09 DE 0F 84 10 03 00 00 8B 4C 24 14 85 C9 0F 85 F5 04 00 00 83 4C 24 10 10 E9 AB FB FF FF 85 ED 0F 85 28 FB FF FF 85 DB 0F 84 20 FB FF FF 8D 47 08 89 84 24 A0 00 00 00 83 F8 07 E9 CF FA FF FF 85 ED 0F 84 06 FB FF FF EB DC 0F 85 C8 06 00 00 8B 54 24 1C 83 C2 01 81 E2 FF 7F 00 00 83 FA 01 0F 8E D2 0C 00 00 8B 94 24 8C 00 00 00 89 F8 8B 9C 24 88 00 00 00 8B 8C 24 84 00 00 00 29 E8 1B 8C 24 94 00 00 00 1B 9C 24 98 00 00 00 1B 94 24 9C 00 00 00 F7 C2 00 00 08 00 89 D6 89 94 24 AC 00 00 00 89 9C 24 A8 00 00 00 89 8C 24 A4 00 00 00 89 84 24 A0 00 00 00 0F 84 9A 07 00 00 8B B4 24 9C 00 00 00 8B 8C 24 98 00 00 00 8B 94 24 94 00 00 00 8B 84 24 90 00 00 00 2B 84 24 80 00 00 00 1B 94 24 84 00 00 00 1B 8C 24 88 00 00 00 1B B4 24 8C 00 00 00 89 94 24 A4 00 00 00 8B 54 24 1C 8B 6C 24 18 89 B4 24 AC 00 00 00 89 8C 24 A8 00 00 00 89 84 24 A0 00 00 00 89 54 24 14 C7 44 24 10 00 00 00 00 85 F6 0F 84 60 01 00 00 0F BD C6 83 F0 1F 8D 70 13 83 E8 0C 89 44 24 18 8B 54 24 18 0F 49 F0 C1 F8 1F C1 E8 1B C1 FE 05 01 C2 83 E2 1F 29 C2 89 54 24 1C 0F 84 0E 02 00 00 83 FE 02 0F 8F 80 0C 00 00 8B 4C 24 1C B8 03 00 00 00 89 EF C7 44 24 20 20 00 00 00 8D 9C 24 A0 00 00 00 29 F0 29 4C 24 20 89 DD 8D 04 83 8B 50 FC 0F B6 4C 24 20 8B 18 D3 EA 0F B6 4C 24 1C D3 E3 09 DA 89 14 B0 83 E8 04 39 E8 75 E1 89 FD 8D 46 FF 8B 94 24 A0 00 00 00 0F B6 4C 24 1C D3 E2 89 94 B4 A0 00 00 00 85 C0 8D 9C 24 A0 00 00 00 78 13 8D B4 26 00 00 00 00 C7 04 83 00 00 00 00 83 E8 01 79 F4 8B 5C 24 18 39 5C 24 14 0F 8F 36 01 00 00 8B 7C 24 18 2B 7C 24 14 8D 47 20 83 C7 01 89 FA 0F 49 C7 C1 FA 1F C1 EA 1B 01 D7 83 E7 1F C1 F8 05 29 D7 85 C0 89 7C 24 14 0F 8E BB 0B 00 00 8D 94 24 A0 00 00 00 31 F6 8D 0C 82 0B 32 83 C2 04 39 CA 75 F7 89 C2 8B 7C 24 14 85 FF 0F 85 24 03 00 00 BA 03 00 00 00 89 D1 29 C1 0F 88 C7 09 00 00 8D 94 24 A0 00 00 00 8D 8C 8C A4 00 00 00 8B 1C 82 89 1A 83 C2 04 39 CA 75 F4 BA 04 00 00 00 29 C2 E9 7F 03 00 00 81 E6 FF FF 07 00 85 F6 89 B4 24 AC 00 00 00 0F 85 A0 FE FF FF 8B 84 24 A8 00 00 00 85 C0 0F 84 C2 03 00 00 0F BD C0 83 F0 1F 83 C0 20 E9 89 FE FF FF 66 85 C9 0F 84 84 01 00 00 66 81 F9 00 08 0F 84 6D 01 00 00 66 81 F9 00 04 0F 84 8F 08 00 00 C7 84 24 AC 00 00 00 FF FF FF FF BB FF FF FF FF BD FE 7F 00 00 C7 84 24 A8 00 00 00 FF FF FF FF BF FF 7F 00 00 C7 84 24 A4 00 00 00 FF FF FF FF C7 44 24 14 FE 7F 00 00 83 4C 24 10 28 89 D9 8B 84 24 A4 00 00 00 E9 67 F8 FF FF 8D 76 00 31 DB 31 C0 31 D2 31 FF E9 A4 F8 FF FF 8D 76 00 8B 5C 24 18 89 E8 29 5C 24 14 83 E0 01 8B BC 24 A0 00 00 00 0F B7 4C 24 4E 8B 54 24 14 81 A4 24 AC 00 00 00 FF FF F7 FF 89 FB 8B B4 24 AC 00 00 00 66 81 E1 00 0C 83 E3 07 83 C2 01 88 44 24 20 E9 5E F7 FF FF 83 FE 03 B8 03 00 00 00 8D 9C 24 A0 00 00 00 0F 8F 56 FE FF FF 89 F2 F7 DA 8D 84 24 AC 00 00 00 8D 8C B4 9C 00 00 00 C1 E2 02 8B 1C 10 89 18 83 E8 04 39 C8 75 F4 8D 46 FF E9 1B FE FF FF 8B 84 24 98 00 00 00 0B 84 24 94 00 00 00 0B 84 24 9C 00 00 00 C7 44 24 18 00 00 00 00 C7 44 24 14 00 00 00 00 09 E8 83 F8 01 19 F6 31 ED 83 C6 01 8B 9C 24 8C 00 00 00 89 F8 8B 8C 24 88 00 00 00 8B 94 24 84 00 00 00 29 F0 19 EA 1B 4C 24 18 1B 5C 24 14 89 9C 24 AC 00 00 00 8B 5C 24 1C 89 8C 24 A8 00 00 00 8B 6C 24 24 89 94 24 A4 00 00 00 89 84 24 A0 00 00 00 89 5C 24 14 E9 BE FA FF FF 85 ED 0F 85 96 FE FF FF 8D 74 26 00 C7 84 24 AC 00 00 00 00 00 00 00 31 DB BD FF 7F 00 00 C7 84 24 A8 00 00 00 00 00 00 00 31 FF C7 84 24 A4 00 00 00 00 00 00 00 C7 44 24 14 FF 7F 00 00 E9 93 FE FF FF 0F 85 25 0A 00 00 8B 54 24 1C 83 C2 01 89 54 24 14 81 E2 FF 7F 00 00 83 FA 01 0F 8E D9 06 00 00 89 F8 8B 9C 24 8C 00 00 00 8B 8C 24 88 00 00 00 8D B4 24 AC 00 00 00 8B 94 24 84 00 00 00 01 E8 13 94 24 94 00 00 00 13 8C 24 98 00 00 00 13 9C 24 9C 00 00 00 89 C7 89 94 24 A4 00 00 00 C1 E7 1F 89 9C 24 AC 00 00 00 8D 94 24 A4 00 00 00 89 8C 24 A8 00 00 00 89 84 24 A0 00 00 00 8B 1A D1 E8 89 D9 C1 E1 1F 09 C1 39 F2 89 4A FC 0F 84 D6 07 00 00 89 D8 83 C2 04 EB E3 80 CF 80 E9 B8 F6 FF FF 8D B4 26 00 00 00 00 81 7C 24 1C FF 7F 00 00 C7 44 24 10 02 00 00 00 0F 85 8B F7 FF FF 8B 8C 24 88 00 00 00 8B 94 24 84 00 00 00 8B B4 24 8C 00 00 00 89 C8 09 D0 09 F0 09 F8 0F 84 47 FA FF FF 89 F5 C1 E5 0D C1 FD 1F 83 C5 03 89 6C 24 10 E9 33 FA FF FF 8D 76 00 8B 4C 24 14 C7 44 24 18 20 00 00 00 8B 94 94 A0 00 00 00 29 4C 24 18 0F B6 4C 24 18 C7 44 24 1C 03 00 00 00 29 44 24 1C 8B 5C 24 1C D3 E2 09 D6 85 DB 0F 8E 68 06 00 00 8B 5C 24 1C 8D 94 24 A0 00 00 00 89 F7 8D 1C 9A 89 5C 24 20 8B 5C 82 04 0F B6 4C 24 18 8B 34 82 D3 E3 0F B6 4C 24 14 D3 EE 09 F3 89 1A 83 C2 04 3B 54 24 20 75 DE BA 04 00 00 00 89 FE 29 C2 8B 84 24 AC 00 00 00 0F B6 4C 24 14 8B 5C 24 1C D3 E8 89 84 9C A0 00 00 00 83 FA 03 8D 9C 24 A0 00 00 00 7F 13 8D 74 26 00 C7 04 93 00 00 00 00 83 C2 01 83 FA 03 7E F1 8B BC 24 A0 00 00 00 31 C0 85 F6 0F B7 4C 24 4E 0F 95 C0 89 EA 83 E2 01 8B B4 24 AC 00 00 00 88 54 24 20 BA 01 00 00 00 09 C7 89 FB 66 81 E1 00 0C 89 BC 24 A0 00 00 00 83 E3 07 C7 44 24 14 00 00 00 00 E9 6C F4 FF FF 8B 84 24 A4 00 00 00 85 C0 0F 84 AB 03 00 00 0F BD C0 83 F0 1F 83 C0 40 E9 B8 FA FF FF 8B 4C 24 14 C7 44 24 18 20 00 00 00 8B 84 84 90 00 00 00 29 4C 24 18 0F B6 4C 24 18 D3 E0 09 C6 B8 03 00 00 00 29 D8 89 44 24 28 0F 84 7B 05 00 00 8B 6C 24 28 8D 84 24 90 00 00 00 8D 2C A8 89 6C 24 20 89 F5 8D B4 26 00 00 00 00 8B 54 98 04 0F B6 4C 24 18 8B 34 98 D3 E2 0F B6 4C 24 14 D3 EE 09 F2 89 10 83 C0 04 3B 44 24 20 75 DE B8 04 00 00 00 89 EE 29 D8 8B 94 24 9C 00 00 00 0F B6 4C 24 14 8B 5C 24 28 D3 EA 89 94 9C 90 00 00 00 E9 1C F6 FF FF 8D B4 26 00 00 00 00 8B 5C 24 1C F7 DE 85 DB 0F 84 06 03 00 00 3D FF 7F 00 00 0F 84 B0 16 00 00 81 8C 24 8C 00 00 00 00 00 08 00 C7 44 24 10 00 00 00 00 83 FE 74 0F 8F C2 09 00 00 89 F3 83 E6 1F C1 FB 05 85 DB 89 74 24 14 0F 84 B5 15 00 00 31 F6 8D 94 24 84 00 00 00 09 FE 8D 8C 9C 80 00 00 00 39 CA 74 0B 8B 3A 83 C2 04 09 FE 39 CA 75 F5 89 DA 8B 4C 24 14 85 C9 0F 85 F3 0F 00 00 B9 03 00 00 00 29 D9 8D 94 24 80 00 00 00 8D 8C 8C 84 00 00 00 8B 3C 9A 89 3A 83 C2 04 39 CA 75 F4 BA 04 00 00 00 29 DA 83 FA 04 74 1A 8D 8C 24 80 00 00 00 8D 74 26 00 C7 04 91 00 00 00 00 83 C2 01 83 FA 03 7E F1 31 D2 8B 8C 24 8C 00 00 00 85 F6 8B 9C 24 88 00 00 00 0F 95 C2 8B B4 24 84 00 00 00 0B 94 24 80 00 00 00 89 4C 24 14 89 5C 24 1C 89 74 24 20 89 EF 8B B4 24 9C 00 00 00 8B 9C 24 98 00 00 00 8B 8C 24 94 00 00 00 8B 6C 24 18 29 D7 1B 4C 24 20 1B 5C 24 1C 1B 74 24 14 89 44 24 14 89 B4 24 AC 00 00 00 89 9C 24 A8 00 00 00 89 8C 24 A4 00 00 00 89 BC 24 A0 00 00 00 E9 96 F6 FF FF 8D 74 26 00 0B 94 24 A0 00 00 00 0B 94 24 A4 00 00 00 0B 94 24 A8 00 00 00 0F 85 55 02 00 00 0F B7 4C 24 4E 66 81 E1 00 0C 66 81 F9 00 04 0F 94 44 24 20 0F B6 6C 24 20 C7 44 24 10 00 00 00 00 BA 01 00 00 00 31 DB 8B B4 24 AC 00 00 00 31 FF C7 44 24 14 00 00 00 00 E9 2C F2 FF FF 8D B4 26 00 00 00 00 8B 84 24 88 00 00 00 8B 94 24 84 00 00 00 8B B4 }
	condition:
		$1
}

rule file_105_0_0 {
	meta:
		name = "___clzdi2"
		size = 32
	strings:
		$1 = { 8B 54 24 08 31 C9 8B 44 24 04 85 D2 75 07 89 C2 B9 20 00 00 00 0F BD C2 83 F0 1F 01 C8 C3 90 90 }
	condition:
		$1
}

rule file_106_0_0 {
	meta:
		name = "___subvsi3"
		size = 48
		refs = "0028 _abort"
	strings:
		$1 = { 83 EC 0C 8B 54 24 10 8B 4C 24 14 89 D0 29 C8 85 C9 78 0D 39 D0 0F 9F C2 84 D2 75 0B 83 C4 0C C3 39 D0 0F 9C C2 EB F1 E8 ?? ?? ?? ?? 90 90 90 90 }
	condition:
		$1
}

rule file_109_0_0 {
	meta:
		name = "___floatdisf"
		size = 112
		refs = "0048 .rdata"
	strings:
		$1 = { 53 83 EC 10 8B 44 24 18 8B 54 24 1C 89 C1 83 C1 FF 89 D3 81 D3 FF FF 1F 00 81 FB FF FF 3F 00 72 1B 76 42 89 C1 81 E1 FF 07 00 00 85 C9 74 0D 89 C3 81 E3 00 F8 FF FF 89 D8 80 CC 08 89 54 24 08 31 DB DB 44 24 08 D8 0D ?? ?? ?? ?? 89 04 24 89 5C 24 04 DF 2C 24 DE C1 D9 5C 24 0C D9 44 24 0C 83 C4 10 5B C3 83 F9 FE 76 D2 EB B7 90 90 90 90 }
	condition:
		$1
}

rule file_110_0_0 {
	meta:
		name = "___fixunsxfsi"
		size = 96
		refs = "0009 .rdata"
	strings:
		$1 = { 83 EC 08 DB 6C 24 0C D9 05 ?? ?? ?? ?? D9 C9 DB E9 73 24 DD D9 D9 7C 24 06 0F B7 44 24 06 B4 0C 66 89 44 24 04 D9 6C 24 04 DB 1C 24 D9 6C 24 06 8B 04 24 83 C4 08 C3 D9 7C 24 06 DE E1 0F B7 44 24 06 B4 0C 66 89 44 24 04 D9 6C 24 04 DB 1C 24 D9 6C 24 06 8B 04 24 83 C4 08 05 00 00 00 80 C3 }
	condition:
		$1
}

rule file_111_0_0 {
	meta:
		name = "___bid_lttd2"
		size = 80
		refs = "0043 ___bid128_quiet_less"
	strings:
		$1 = { 83 EC 4C 8B 44 24 60 89 44 24 10 8B 44 24 64 89 44 24 14 8B 44 24 68 89 44 24 18 8B 44 24 6C 89 44 24 1C 8B 44 24 50 89 04 24 8B 44 24 54 89 44 24 04 8B 44 24 58 89 44 24 08 8B 44 24 5C 89 44 24 0C E8 ?? ?? ?? ?? 83 C4 4C F7 D8 C3 90 90 90 }
	condition:
		$1
}

rule file_112_0_0 {
	meta:
		name = "___bid_fixunsddsi"
		size = 48
		refs = "0013 ___bid64_to_uint32_xint"
	strings:
		$1 = { 83 EC 1C 8B 54 24 24 8B 44 24 20 89 54 24 04 89 04 24 E8 ?? ?? ?? ?? BA 00 00 00 00 3D 00 00 00 80 0F 44 C2 83 C4 1C C3 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_116_0_0 {
	meta:
		name = "___bid_fixunstdsi"
		size = 64
		refs = "0023 ___bid128_to_uint32_xint"
	strings:
		$1 = { 83 EC 2C 8B 44 24 30 89 04 24 8B 44 24 34 89 44 24 04 8B 44 24 38 89 44 24 08 8B 44 24 3C 89 44 24 0C E8 ?? ?? ?? ?? BA 00 00 00 00 3D 00 00 00 80 0F 44 C2 83 C4 2C C3 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_117_0_0 {
	meta:
		name = "___bid_floatdidd"
		size = 32
		refs = "0013 ___bid64_from_int64"
	strings:
		$1 = { 83 EC 1C 8B 44 24 20 8B 54 24 24 89 04 24 89 54 24 04 E8 ?? ?? ?? ?? 83 C4 1C C3 90 90 90 90 90 }
	condition:
		$1
}

rule file_147_0_0 {
	meta:
		name = "___bid_floatunsdidd"
		size = 32
		refs = "0013 ___bid64_from_uint64"
	strings:
		$1 = { 83 EC 1C 8B 44 24 20 8B 54 24 24 89 04 24 89 54 24 04 E8 ?? ?? ?? ?? 83 C4 1C C3 90 90 90 90 90 }
	condition:
		$1
}

rule file_154_0_0 {
	meta:
		name = "___bid_truncddsd2"
		size = 32
		refs = "0013 ___bid64_to_bid32"
	strings:
		$1 = { 83 EC 1C 8B 44 24 20 8B 54 24 24 89 04 24 89 54 24 04 E8 ?? ?? ?? ?? 83 C4 1C C3 90 90 90 90 90 }
	condition:
		$1
}

rule file_118_0_0 {
	meta:
		name = "___eprintf"
		size = 80
		refs = "0024 __imp___iob 002f _fprintf 003f _fflush 0044 _abort"
	strings:
		$1 = { 83 EC 2C 8B 44 24 3C 89 44 24 10 8B 44 24 38 89 44 24 0C 8B 44 24 34 89 44 24 08 8B 44 24 30 89 44 24 04 A1 ?? ?? ?? ?? 83 C0 40 89 04 24 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 83 C0 40 89 04 24 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_119_0_0 {
	meta:
		name = "___floatunsitf"
		size = 416
	strings:
		$1 = { 55 57 56 53 83 EC 3C 8B 5C 24 54 8B 44 24 50 85 DB 0F 84 B9 00 00 00 0F BD D3 83 F2 1F 8D 72 70 C7 44 24 04 1E 40 00 00 29 54 24 04 83 C2 51 89 D1 0F 49 F2 C1 F9 1F C1 E9 1B 01 CA 83 E2 1F C1 FE 05 29 CA 89 5C 24 20 C7 44 24 24 00 00 00 00 C7 44 24 28 00 00 00 00 C7 44 24 2C 00 00 00 00 89 54 24 08 0F 85 AD 00 00 00 83 FE 03 BA 03 00 00 00 8D 6C 24 20 7F 28 89 F3 F7 DB 8D 54 24 2C 8D 7C B4 1C C1 E3 02 8B 0C 1A 89 0A 83 EA 04 39 FA 75 F4 8D 56 FF 85 D2 8D 6C 24 20 78 0F 66 90 C7 44 95 00 00 00 00 00 83 EA 01 79 F3 0F B7 7C 24 04 8B 74 24 20 8B 5C 24 24 8B 4C 24 28 0F B7 54 24 2C 66 81 E7 FF 7F EB 10 8D B6 00 00 00 00 31 FF 31 D2 31 C9 31 DB 31 F6 66 89 54 24 1C 0F B7 54 24 1E 66 81 E7 FF 7F 66 81 E2 00 80 09 FA 66 89 54 24 1E 66 C1 EA 08 83 E2 7F 88 54 24 1F 89 30 89 58 04 89 48 08 8B 54 24 1C 89 50 0C 83 C4 3C 5B 5E 5F 5D C3 83 FE 02 7F 76 8B 4C 24 08 BA 03 00 00 00 89 C7 C7 44 24 0C 20 00 00 00 8D 6C 24 20 29 F2 29 4C 24 0C 8D 54 95 00 8B 42 FC 0F B6 4C 24 0C 8B 1A D3 E8 0F B6 4C 24 08 D3 E3 09 D8 89 04 B2 83 EA 04 39 EA 75 E1 8B 5C 24 20 89 F8 8D 56 FF 0F B6 4C 24 08 8D 6C 24 20 D3 E3 85 D2 89 5C B4 20 0F 88 31 FF FF FF C7 44 95 00 00 00 00 00 83 EA 01 0F 89 13 FF FF FF E9 1B FF FF FF BA 02 00 00 00 BE 03 00 00 00 EB C7 90 90 }
	condition:
		$1
}

rule file_122_0_0 {
	meta:
		name = "___fixunsdfsi"
		size = 96
		refs = "0009 .rdata"
	strings:
		$1 = { 83 EC 0C DD 44 24 10 D9 05 ?? ?? ?? ?? D9 C9 DB E9 73 24 DD D9 D9 7C 24 06 0F B7 44 24 06 B4 0C 66 89 44 24 04 D9 6C 24 04 DB 1C 24 D9 6C 24 06 8B 04 24 83 C4 0C C3 D9 7C 24 06 DE E1 0F B7 44 24 06 B4 0C 66 89 44 24 04 D9 6C 24 04 DB 1C 24 D9 6C 24 06 8B 04 24 83 C4 0C 05 00 00 00 80 C3 }
	condition:
		$1
}

rule file_123_0_0 {
	meta:
		name = "___divxc3"
		size = 752
		refs = "00f3 .rdata"
	strings:
		$1 = { DB 6C 24 08 8B 54 24 04 DB 6C 24 14 DB 6C 24 20 DB 6C 24 2C D9 C1 D9 E1 D9 C1 D9 E1 DF E9 DD D8 76 66 D9 C1 D8 F1 D9 C2 D8 C9 D8 C2 D9 C5 D8 CA D8 C5 D8 F1 D9 CA D8 CD D8 E6 DE F1 D9 C9 DB E8 7A 64 DD DC DD DC DD D8 DD D8 EB 34 DD DD DD DB DD D8 DD D8 EB 2A DD D8 DD DC DD DA DD D8 EB 20 DD D8 DD DC DD DA DD D8 EB 16 DD D8 DD DC DD DA DD D8 EB 0C DD D8 DD DC DD DA DD D8 8D 74 26 00 DB 3A 89 D0 DB 7A 0C C3 D9 C0 D8 F2 D9 C1 D8 C9 D8 C3 D9 C4 D8 CA D8 C6 D8 F1 D9 CA D8 CE D8 ED DE F1 D9 C9 EB 98 D9 C9 DB E8 7B A0 D9 EE D9 CB DB EB 0F 8A 40 01 00 00 0F 85 42 01 00 00 D9 CC DB EB DD DB 0F 8A 3E 01 00 00 0F 85 40 01 00 00 D9 CD DB E8 7A 36 DD DB DD D8 DD DB D9 C9 D9 CA EB 06 DD DD DD D8 DD D9 D9 E5 DF E0 DD D8 F6 C4 02 D9 05 ?? ?? ?? ?? 74 08 DD D8 D9 05 ?? ?? ?? ?? D9 C0 DE CA DE CA E9 74 FF FF FF D9 CC DB E8 7B D0 D9 C4 31 C0 D8 E5 DF E8 D9 CC D9 CD D9 C9 D9 CA D9 CB 0F 9A C0 EB 02 D9 CC D9 C3 D8 E4 D9 C9 D9 CD D9 C9 DF E8 0F 8A A5 00 00 00 D9 C4 D8 E5 DF E8 0F 8B 0D FF FF FF D9 CC DB E8 0F 8A 0D FF FF FF D9 CC D9 CB 31 C9 85 C0 0F 85 09 FF FF FF D9 C3 D8 E4 DF E8 0F 8A 07 FF FF FF DD DA DD D8 85 C9 75 67 D9 EE D9 C9 D9 E5 DF E0 DD D8 F6 C4 02 D9 E1 74 02 D9 E0 D9 C2 D8 E3 DF E8 7B 04 EB 3C D9 CA D9 EE D9 CB D9 E5 DF E0 DD D8 D9 CA F6 C4 02 D9 E1 74 02 D9 E0 D9 C3 D8 CB D9 C2 D8 CA DE C1 D9 EE DC C9 D9 CC DE CB D9 C9 DE CC D9 C9 DE E3 D9 CA DE C9 D9 C9 E9 B2 FE FF FF D9 CA DB E8 7A BE D9 E8 D9 CB D9 C9 EB BC D9 E8 D9 C9 EB 97 D9 CB DB E8 B9 01 00 00 00 0F 8B 68 FF FF FF D9 CB E9 45 FF FF FF DD DB D9 C9 D9 CA EB 16 DD DB D9 C9 D9 CA EB 0E D9 C9 D9 CA D9 CB EB 06 D9 C9 D9 CA D9 CB D9 C5 D8 E6 DF E8 0F 9A C1 84 C9 0F B6 C1 74 07 E9 AD 00 00 00 D9 CD D9 C4 D8 E5 DF E8 0F 8B F2 FE FF FF D9 CC 31 C9 DB E8 0F 8A E4 FE FF FF D9 C3 D8 E4 DB E8 0F 8A E4 FE FF FF DD D8 D9 C4 D8 E5 DB E8 0F 8A E2 FE FF FF DD D8 DD DA DD D8 85 C9 75 69 D9 EE D9 CC D9 E5 DF E0 DD D8 D9 CB F6 C4 02 D9 E1 74 02 D9 E0 D9 C3 D8 E4 DF E8 7B 04 EB 3C D9 CB D9 EE D9 CC D9 E5 DF E0 DD D8 D9 CB F6 C4 02 D9 E1 74 02 D9 E0 D9 C3 D8 CA D9 C1 D8 CC DE C1 D9 05 ?? ?? ?? ?? DC C9 D9 CA DE CB D9 CB DE CC D9 C9 DE E3 DE CA E9 BC FD FF FF D9 CB DB E8 7A BE D9 E8 D9 CC D9 C9 EB BC D9 E8 D9 CC EB 95 D9 CD DB E8 0F 8A 49 FF FF FF D9 CD D9 CC B9 01 00 00 00 E9 55 FF FF FF }
	condition:
		$1
}

rule file_125_0_0 {
	meta:
		name = "___mulvdi3"
		size = 528
		refs = "00ff _abort"
	strings:
		$1 = { 83 EC 3C 8B 44 24 48 89 74 24 30 8B 74 24 40 89 7C 24 34 8B 7C 24 44 8B 54 24 4C 89 44 24 10 89 C1 89 F0 C1 F8 1F 39 C7 89 5C 24 2C 89 6C 24 38 89 54 24 14 89 7C 24 1C 89 54 24 18 75 31 89 C8 C1 F8 1F 39 C2 75 7F 89 F0 F7 E9 89 44 24 08 89 54 24 0C 8B 44 24 08 8B 54 24 0C 8B 5C 24 2C 8B 74 24 30 8B 7C 24 34 8B 6C 24 38 83 C4 3C C3 8B 6C 24 10 89 E8 C1 F8 1F 39 44 24 18 0F 85 B0 00 00 00 89 E8 F7 E6 89 C3 8B 44 24 1C 89 D1 F7 E5 83 7C 24 1C 00 89 44 24 10 89 54 24 14 0F 88 84 00 00 00 85 ED 78 76 31 FF 89 CE 03 74 24 10 13 7C 24 14 89 F0 C1 F8 1F 39 F8 75 42 89 5C 24 08 89 74 24 0C EB 8D 89 C8 89 F5 F7 E6 89 C3 8B 44 24 18 89 D1 F7 E6 83 7C 24 18 00 89 44 24 08 89 54 24 0C 78 30 85 ED 78 1A 31 FF 89 CE 03 74 24 08 13 7C 24 0C 89 F0 C1 F8 1F 39 F8 74 BE E8 ?? ?? ?? ?? 8B 44 24 10 8B 54 24 14 29 44 24 08 19 54 24 0C EB D4 29 F2 89 54 24 0C EB C8 29 74 24 10 19 7C 24 14 EB 80 29 EA 89 54 24 14 E9 71 FF FF FF 83 7C 24 1C 00 78 2B 83 7C 24 18 00 78 56 83 7C 24 1C 00 75 B7 83 7C 24 18 00 75 B0 89 C8 F7 E6 85 D2 89 44 24 08 89 54 24 0C 0F 89 F1 FE FF FF EB 9A 83 7C 24 18 00 78 68 83 7C 24 1C FF 75 8C 83 7C 24 18 00 75 85 89 C8 F7 E6 89 C3 89 D0 29 C8 0F 89 75 FF FF FF 89 5C 24 08 89 44 24 0C E9 BD FE FF FF 83 7C 24 1C 00 0F 85 5D FF FF FF 83 7C 24 18 FF 0F 85 52 FF FF FF 89 C8 F7 E6 89 D1 29 F1 89 44 24 10 89 54 24 14 0F 89 3C FF FF FF 8B 54 24 10 89 4C 24 0C 89 54 24 08 E9 80 FE FF FF 83 7C 24 1C FF 0F 85 20 FF FF FF 83 7C 24 18 FF 0F 85 15 FF FF FF 89 C8 F7 E6 89 44 24 10 89 D0 29 F0 29 C8 89 54 24 14 89 C1 79 C3 E9 FA FE FF FF 90 90 90 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_127_0_0 {
	meta:
		name = "___bid64qq_add"
		size = 160
		refs = "008f ___bid64qqq_fma"
	strings:
		$1 = { 83 EC 6C 8B 84 24 80 00 00 00 C7 44 24 54 00 00 00 00 C7 44 24 5C 00 00 40 30 C7 44 24 50 01 00 00 00 89 44 24 20 8B 84 24 84 00 00 00 C7 44 24 58 00 00 00 00 C7 04 24 01 00 00 00 C7 44 24 08 00 00 00 00 89 44 24 24 8B 84 24 88 00 00 00 89 44 24 28 8B 84 24 8C 00 00 00 89 44 24 2C 8B 44 24 70 89 44 24 10 8B 44 24 74 89 44 24 14 8B 44 24 78 89 44 24 18 8B 44 24 7C 89 44 24 1C 8B 44 24 54 89 44 24 04 8B 44 24 5C 89 44 24 0C E8 ?? ?? ?? ?? 83 C4 6C C3 89 F6 8D BC 27 00 00 00 00 }
	condition:
		$1
}

rule file_127_1_0 {
	meta:
		name = "___bid64qd_add"
		size = 144
		refs = "003b ___bid64_to_bid128"
	strings:
		$1 = { 83 EC 4C 8B 44 24 50 8D 4C 24 30 8B 54 24 64 89 0C 24 89 44 24 20 8B 44 24 54 89 54 24 08 89 44 24 24 8B 44 24 58 89 44 24 28 8B 44 24 5C 89 44 24 2C 8B 44 24 60 89 44 24 04 E8 ?? ?? ?? ?? 8B 44 24 30 89 44 24 10 8B 44 24 34 89 44 24 14 8B 44 24 38 89 44 24 18 8B 44 24 3C 89 44 24 1C 8B 44 24 20 89 04 24 8B 44 24 24 89 44 24 04 8B 44 24 28 89 44 24 08 8B 44 24 2C 89 44 24 0C E8 DD FE FF FF 83 C4 4C C3 89 F6 8D BC 27 00 00 00 00 }
	condition:
		$1
}

rule file_127_2_0 {
	meta:
		name = "___bid64dq_add"
		size = 144
		refs = "003b ___bid64_to_bid128"
	strings:
		$1 = { 83 EC 4C 8B 44 24 58 8D 4C 24 30 8B 54 24 54 89 0C 24 89 44 24 20 8B 44 24 5C 89 54 24 08 89 44 24 24 8B 44 24 60 89 44 24 28 8B 44 24 64 89 44 24 2C 8B 44 24 50 89 44 24 04 E8 ?? ?? ?? ?? 8B 44 24 20 89 44 24 10 8B 44 24 24 89 44 24 14 8B 44 24 28 89 44 24 18 8B 44 24 2C 89 44 24 1C 8B 44 24 30 89 04 24 8B 44 24 34 89 44 24 04 8B 44 24 38 89 44 24 08 8B 44 24 3C 89 44 24 0C E8 4D FE FF FF 83 C4 4C C3 89 F6 8D BC 27 00 00 00 00 }
	condition:
		$1
}

rule file_127_3_0 {
	meta:
		name = "___bid64qq_sub"
		size = 240
		refs = "00e5 ___bid64qqq_fma"
	strings:
		$1 = { 53 83 EC 68 8B 44 24 70 8B 8C 24 88 00 00 00 C7 44 24 50 01 00 00 00 C7 44 24 54 00 00 00 00 89 44 24 40 8B 44 24 74 C7 44 24 58 00 00 00 00 C7 44 24 5C 00 00 40 30 89 44 24 44 8B 44 24 78 89 44 24 48 8B 44 24 7C 89 44 24 4C 8B 84 24 80 00 00 00 89 44 24 30 8B 84 24 84 00 00 00 89 44 24 34 8B 84 24 8C 00 00 00 89 C2 81 E2 00 00 00 7C 81 FA 00 00 00 7C 89 C2 74 13 89 C3 81 E2 FF FF FF 7F 81 CB 00 00 00 80 85 C0 0F 49 D3 8B 44 24 30 89 4C 24 28 89 54 24 2C 89 44 24 20 8B 44 24 34 89 44 24 24 8B 44 24 40 89 44 24 10 8B 44 24 44 89 44 24 14 8B 44 24 48 89 44 24 18 8B 44 24 4C 89 44 24 1C 8B 44 24 50 89 04 24 8B 44 24 54 89 44 24 04 8B 44 24 58 89 44 24 08 8B 44 24 5C 89 44 24 0C E8 ?? ?? ?? ?? 83 C4 68 5B C3 66 90 }
	condition:
		$1
}

rule file_127_4_0 {
	meta:
		name = "___bid64qd_sub"
		size = 144
		refs = "003b ___bid64_to_bid128"
	strings:
		$1 = { 83 EC 4C 8B 44 24 50 8D 4C 24 30 8B 54 24 64 89 0C 24 89 44 24 20 8B 44 24 54 89 54 24 08 89 44 24 24 8B 44 24 58 89 44 24 28 8B 44 24 5C 89 44 24 2C 8B 44 24 60 89 44 24 04 E8 ?? ?? ?? ?? 8B 44 24 30 89 44 24 10 8B 44 24 34 89 44 24 14 8B 44 24 38 89 44 24 18 8B 44 24 3C 89 44 24 1C 8B 44 24 20 89 04 24 8B 44 24 24 89 44 24 04 8B 44 24 28 89 44 24 08 8B 44 24 2C 89 44 24 0C E8 8D FE FF FF 83 C4 4C C3 89 F6 8D BC 27 00 00 00 00 }
	condition:
		$1
}

rule file_127_5_0 {
	meta:
		name = "___bid64dq_sub"
		size = 144
		refs = "003b ___bid64_to_bid128"
	strings:
		$1 = { 83 EC 4C 8B 44 24 58 8D 4C 24 30 8B 54 24 54 89 0C 24 89 44 24 20 8B 44 24 5C 89 54 24 08 89 44 24 24 8B 44 24 60 89 44 24 28 8B 44 24 64 89 44 24 2C 8B 44 24 50 89 44 24 04 E8 ?? ?? ?? ?? 8B 44 24 20 89 44 24 10 8B 44 24 24 89 44 24 14 8B 44 24 28 89 44 24 18 8B 44 24 2C 89 44 24 1C 8B 44 24 30 89 04 24 8B 44 24 34 89 44 24 04 8B 44 24 38 89 44 24 08 8B 44 24 3C 89 44 24 0C E8 FD FD FF FF 83 C4 4C C3 89 F6 8D BC 27 00 00 00 00 }
	condition:
		$1
}

rule file_127_6_0 {
	meta:
		name = "___bid128_add"
		size = 35776
		refs = "0495 ___bid_IDEC_glbflags 0556 ___bid_IDEC_glbround 0658 ___bid_nr_digits 07e2 ___bid_ten2k64 0b0c ___bid_midpoint128 0e8d ___bid_ten2k128 1155 ___bid_midpoint64 15a4 ___bid_ten2mk128trunc 15aa ___bid_ten2mk128 1cfd ___bid_maskhigh128 1d28 ___bid_shiftright128 1dcc ___bid_onehalf128"
	strings:
		$1 = { 55 57 56 53 81 EC EC 01 00 00 8B 84 24 04 02 00 00 8B AC 24 00 02 00 00 89 84 24 D0 01 00 00 8B 84 24 08 02 00 00 89 84 24 D4 01 00 00 8B 84 24 0C 02 00 00 8B 94 24 D4 01 00 00 89 84 24 D8 01 00 00 8B 84 24 10 02 00 00 89 54 24 7C 89 84 24 DC 01 00 00 8B 84 24 14 02 00 00 8B 94 24 DC 01 00 00 89 84 24 C0 01 00 00 8B 84 24 18 02 00 00 8B 8C 24 C0 01 00 00 89 84 24 C4 01 00 00 8B 84 24 1C 02 00 00 8B 9C 24 C4 01 00 00 89 4C 24 60 89 D1 81 E1 00 00 00 78 89 84 24 C8 01 00 00 8B 84 24 20 02 00 00 89 5C 24 64 89 D3 8B B4 24 C8 01 00 00 81 E3 00 00 00 80 89 84 24 CC 01 00 00 8B 84 24 D0 01 00 00 8B BC 24 CC 01 00 00 89 44 24 78 8B 84 24 D8 01 00 00 89 9C 24 88 00 00 00 89 FB 81 E3 00 00 00 80 81 F9 00 00 00 78 89 9C 24 90 00 00 00 0F 84 75 01 00 00 89 F9 81 E1 00 00 00 78 81 F9 00 00 00 78 0F 84 61 01 00 00 89 D1 81 E1 00 00 00 60 81 F9 00 00 00 60 0F 84 3D 02 00 00 89 D3 89 D1 81 E3 FF FF 01 00 81 E1 00 00 FE 7F 81 FB 09 ED 01 00 89 44 24 50 89 5C 24 54 C7 44 24 68 00 00 00 00 89 4C 24 6C 0F 86 9D 01 00 00 C7 84 24 98 00 00 00 00 00 00 00 C7 84 24 9C 00 00 00 00 00 00 00 C7 84 24 80 00 00 00 00 00 00 00 C7 84 24 84 00 00 00 00 00 00 00 C7 44 24 50 00 00 00 00 C7 44 24 54 00 00 00 00 89 F9 81 E1 00 00 00 60 81 F9 00 00 00 60 0F 84 64 02 00 00 89 F9 89 FB 81 E1 FF FF 01 00 81 E3 00 00 FE 7F 81 F9 09 ED 01 00 89 74 24 58 89 4C 24 5C C7 44 24 70 00 00 00 00 89 5C 24 74 0F 87 4E 02 00 00 72 0C 81 FE C0 87 AD BE 0F 87 40 02 00 00 8B 5C 24 58 8B 4C 24 5C 81 F3 C0 87 AD BE 81 F1 09 ED 01 00 09 CB 75 0E 81 7C 24 64 63 8E 8D 37 0F 87 1A 02 00 00 8B 4C 24 58 0B 4C 24 60 8B 5C 24 5C 0B 5C 24 64 89 8C 24 A0 00 00 00 8B 8C 24 9C 00 00 00 0B 8C 24 98 00 00 00 0F 84 7E 01 00 00 0B 9C 24 A0 00 00 00 0F 85 81 02 00 00 8B 4C 24 74 39 4C 24 6C 0F 83 79 0A 00 00 8B 4C 24 78 8B 5C 24 7C 89 45 08 89 E8 89 4D 00 89 5D 04 89 55 0C 81 C4 EC 01 00 00 5B 5E 5F 5D C3 66 90 89 D3 81 E3 00 00 00 7C 81 FB 00 00 00 7C 0F 84 B2 01 00 00 89 F9 81 E1 00 00 00 7C 81 F9 00 00 00 7C 89 4C 24 58 0F 84 04 03 00 00 8B 8C 24 90 00 00 00 C7 44 24 60 00 00 00 00 81 C9 00 00 00 78 81 FB 00 00 00 78 89 4C 24 64 0F 84 BF 00 00 00 8B 44 24 60 8B 54 24 64 C7 45 00 00 00 00 00 C7 45 04 00 00 00 00 89 45 08 89 55 0C 81 C4 EC 01 00 00 89 E8 5B 5E 5F 5D C3 8D B6 00 00 00 00 72 0B 3D C0 87 AD BE 0F 87 56 FE FF FF 8B 5C 24 50 8B 4C 24 54 81 F3 C0 87 AD BE 81 F1 09 ED 01 00 09 CB 75 0E 81 7C 24 7C 63 8E 8D 37 0F 87 30 FE FF FF 8B 5C 24 50 8B 4C 24 54 0B 5C 24 78 0B 4C 24 7C 89 9C 24 98 00 00 00 8B 5C 24 7C 89 8C 24 9C 00 00 00 8B 4C 24 78 89 9C 24 84 00 00 00 89 8C 24 80 00 00 00 E9 33 FE FF FF 8D 74 26 00 89 C1 89 D3 0F A4 CB 02 81 E3 00 00 FE 7F C7 44 24 68 00 00 00 00 89 5C 24 6C E9 D4 FD FF FF 90 81 7C 24 58 00 00 00 78 0F 84 92 22 00 00 8B BC 24 88 00 00 00 C7 44 24 60 00 00 00 00 81 CF 00 00 00 78 89 7C 24 64 E9 15 FF FF FF 8D 74 26 00 0B 9C 24 A0 00 00 00 0F 85 C3 01 00 00 8B 54 24 74 3B 54 24 6C 8B 44 24 70 72 0E 0F 86 24 0D 00 00 8B 44 24 68 8B 54 24 6C 8B BC 24 90 00 00 00 85 FF 0F 84 68 01 00 00 8B B4 24 88 00 00 00 85 F6 0F 84 59 01 00 00 0B 94 24 88 00 00 00 31 C9 31 DB E9 4E FE FF FF 89 FB 0F A4 F3 02 89 DE 81 E6 00 00 FE 7F C7 44 24 70 00 00 00 00 89 74 24 74 8B 8C 24 9C 00 00 00 0B 8C 24 98 00 00 00 74 8C E9 09 FE FF FF 89 D1 89 C3 81 E1 FF 3F 00 00 81 F9 4D 31 00 00 0F 87 C5 01 00 00 0F 83 7E 0C 00 00 81 F1 4D 31 00 00 81 F3 93 8D 44 C6 09 D9 0F 84 9D 01 00 00 89 D1 81 E1 00 00 00 7E 81 F9 00 00 00 7E 0F 84 BB 10 00 00 89 C1 89 D0 89 FA 25 FF 3F 00 FC 81 E2 00 00 00 7E 81 FA 00 00 00 7E 75 07 83 0D ?? ?? ?? ?? 01 8B 74 24 78 8B 7C 24 7C 89 45 0C 89 E8 89 4D 08 89 75 00 89 7D 04 81 C4 EC 01 00 00 5B 5E 5F 5D C3 90 8D 74 26 00 8B 54 24 74 39 54 24 6C 0F 82 65 07 00 00 0F 86 51 07 00 00 8B 5C 24 60 8B 74 24 64 89 9C 24 C0 00 00 00 89 B4 24 C4 00 00 00 8B 44 24 54 0B 44 24 50 0F 85 3A 01 00 00 81 BC 24 84 00 00 00 FF FF 1F 00 0F 86 17 0E 00 00 8B 94 24 84 00 00 00 89 D0 31 D2 89 84 24 B8 01 00 00 89 94 24 BC 01 00 00 DF AC 24 B8 01 00 00 DD 5C 24 60 8B 54 24 64 89 D0 C1 E8 14 89 C2 81 E2 FF 07 00 00 81 EA DF 03 00 00 E9 08 01 00 00 8D B4 26 00 00 00 00 31 C9 31 DB 83 3D ?? ?? ?? ?? 01 0F 85 F4 FC FF FF 89 D6 8B BC 24 90 00 00 00 81 CE 00 00 00 80 39 BC 24 88 00 00 00 0F 45 D6 E9 D6 FC FF FF 90 8B 44 24 74 39 44 24 6C 0F 86 99 01 00 00 89 F0 89 FA 8B 4C 24 60 8B 5C 24 64 E9 B6 FC FF FF 90 89 F8 89 F2 25 FF 3F 00 00 3D 4D 31 00 00 0F 86 4C 0A 00 00 89 F8 31 F6 25 00 C0 FF FF 89 C7 C7 44 24 60 00 00 00 00 C7 44 24 64 00 00 00 00 89 F8 25 00 00 00 7E 3D 00 00 00 7E 0F 84 6F 0F 00 00 89 F8 89 F2 25 FF 3F 00 FC 8B 5C 24 60 8B 74 24 64 89 55 08 89 45 0C 89 5D 00 89 75 04 E9 DA FC FF FF 81 7C 24 7C 09 5B C1 38 0F 86 55 FE FF FF 89 D1 31 C0 81 E1 00 C0 FF FF 89 CA C7 44 24 78 00 00 00 00 C7 44 24 7C 00 00 00 00 E9 34 FE FF FF DF 6C 24 50 DD 5C 24 60 8B 54 24 64 89 D0 C1 E8 14 89 C2 81 E2 FF 07 00 00 81 EA BF 03 00 00 89 D0 C1 E0 05 8B 98 ?? ?? ?? ?? 85 DB 89 5C 24 78 75 64 8B B0 ?? ?? ?? ?? 8B 88 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 39 44 24 54 89 74 24 78 0F 87 64 0A 00 00 72 0A 39 4C 24 50 0F 87 58 0A 00 00 33 44 24 54 33 4C 24 50 09 C8 75 2C 89 D0 8B BC 24 84 00 00 00 C1 E0 05 05 ?? ?? ?? ?? 3B 78 14 72 16 0F 87 30 0A 00 00 8B 94 24 80 00 00 00 3B 50 10 0F 83 20 0A 00 00 8B 4C 24 5C 0B 4C 24 58 0F 85 CF 01 00 00 81 BC 24 C4 00 00 00 FF FF 1F 00 0F 86 10 0C 00 00 8B 94 24 C4 00 00 00 89 D0 31 D2 89 84 24 B8 01 00 00 89 94 24 BC 01 00 00 DF AC 24 B8 01 00 00 DD 5C 24 60 8B 54 24 64 89 D0 C1 E8 14 89 C2 81 E2 FF 07 00 00 81 EA DF 03 00 00 E9 9D 01 00 00 0F 83 B7 0B 00 00 8B 4C 24 5C 0B 4C 24 58 0F 84 48 09 00 00 DF 6C 24 58 DD 5C 24 50 8B 54 24 54 89 D0 C1 E8 14 25 FF 07 00 00 2D BF 03 00 00 89 C2 C1 E2 05 8B 9A ?? ?? ?? ?? 85 DB 75 3B 8B 9A ?? ?? ?? ?? 8B 8A ?? ?? ?? ?? 8B 92 ?? ?? ?? ?? 39 54 24 5C 0F 87 6F 1C 00 00 72 0A 39 4C 24 58 0F 87 63 1C 00 00 33 54 24 5C 33 4C 24 58 09 CA 0F 84 2F 1C 00 00 8D 76 00 B9 22 00 00 00 8B 44 24 70 8B 54 24 74 29 D9 2B 44 24 68 1B 54 24 6C 89 D0 C1 E8 11 39 C1 0F 4E C1 85 C0 89 44 24 68 0F 84 53 0D 00 00 83 FB 13 0F 8F 22 1C 00 00 83 F8 13 0F 8F F3 2F 00 00 8B 1C C5 ?? ?? ?? ?? 8B 4C 24 64 8B 34 C5 ?? ?? ?? ?? 8B 7C 24 60 89 D8 F7 E1 89 44 24 50 89 F0 89 54 24 54 F7 E1 89 84 24 80 00 00 00 89 D8 89 94 24 84 00 00 00 F7 E7 89 54 24 5C 8B 5C 24 5C 31 D2 89 44 24 58 8B 44 24 50 89 D9 31 DB 01 C1 89 F0 11 D3 F7 E7 8B 7C 24 54 01 C1 89 FE 8B 44 24 58 11 D3 31 FF 89 74 24 50 8B B4 24 80 00 00 00 89 7C 24 54 8B BC 24 84 00 00 00 01 74 24 50 11 7C 24 54 31 D2 01 5C 24 50 89 CB 11 54 24 54 31 C9 31 D2 01 C1 11 D3 8B 44 24 68 BE 00 00 00 00 8B 54 24 74 89 C7 8B 44 24 70 C1 E7 11 29 F0 19 FA 0B 44 24 50 0B 94 24 90 00 00 00 0B 54 24 54 E9 B0 F9 FF FF DF 6C 24 58 DD 5C 24 60 8B 54 24 64 89 D0 C1 E8 14 89 C2 81 E2 FF 07 00 00 81 EA BF 03 00 00 89 D0 C1 E0 05 8B B0 ?? ?? ?? ?? 85 F6 75 60 8B B0 ?? ?? ?? ?? 8B 88 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 39 44 24 5C 0F 87 F1 07 00 00 72 0A 39 4C 24 58 0F 87 E5 07 00 00 33 44 24 5C 33 4C 24 58 09 C8 75 2C 89 D0 8B 94 24 C4 00 00 00 C1 E0 05 05 ?? ?? ?? ?? 3B 50 14 72 16 0F 87 BD 07 00 00 8B 8C 24 C0 00 00 00 3B 48 10 0F 83 AD 07 00 00 8B 4C 24 6C 8B 44 24 74 C1 E9 11 03 4C 24 78 C1 E8 11 29 F1 29 C1 83 F9 21 0F 8E FE 04 00 00 83 F9 22 0F 84 AA 07 00 00 83 7C 24 78 21 0F 8F 36 01 00 00 BF 22 00 00 00 2B 7C 24 78 83 7C 24 78 13 0F 8F 98 30 00 00 83 FF 13 0F 8F 9A 3B 00 00 8B 04 FD ?? ?? ?? ?? F7 A4 24 80 00 00 00 8B 9C 24 84 00 00 00 C7 44 24 7C 00 00 00 00 89 44 24 70 8B 04 FD ?? ?? ?? ?? 89 54 24 74 F7 E3 89 44 24 50 8B 04 FD ?? ?? ?? ?? 89 54 24 54 F7 A4 24 80 00 00 00 89 54 24 64 8B 54 24 70 89 44 24 60 89 54 24 78 8B 54 24 64 89 D0 31 D2 89 84 24 80 00 00 00 8B 44 24 78 01 84 24 80 00 00 00 8B 04 FD ?? ?? ?? ?? 89 94 24 84 00 00 00 8B 54 24 7C 11 94 24 84 00 00 00 F7 E3 01 84 24 80 00 00 00 11 94 24 84 00 00 00 8B 54 24 74 89 D0 31 D2 89 44 24 70 8B 44 24 50 01 44 24 70 89 54 24 74 8B 54 24 54 11 54 24 74 8B 94 24 84 00 00 00 89 D0 31 D2 01 44 24 70 8B 84 24 80 00 00 00 11 54 24 74 89 C2 31 C0 89 84 24 80 00 00 00 8B 44 24 60 89 94 24 84 00 00 00 31 D2 01 84 24 80 00 00 00 11 94 24 84 00 00 00 89 FA B8 00 00 00 00 C1 E2 11 29 44 24 68 19 54 24 6C 8B 44 24 70 8B 54 24 74 89 44 24 50 89 54 24 54 A1 ?? ?? ?? ?? A9 FB FF FF FF 0F 85 B8 00 00 00 8B 5C 24 50 8B 54 24 54 81 F3 93 8D 44 C6 81 F2 4D 31 00 00 09 D3 0F 85 94 00 00 00 83 F9 23 0F 85 8B 00 00 00 8B 94 24 84 00 00 00 8B 8C 24 80 00 00 00 81 F2 0A 5B C1 38 09 D1 75 63 8B 9C 24 90 00 00 00 39 9C 24 88 00 00 00 74 53 83 FE 13 0F 8E BF 46 00 00 83 EE 14 89 F2 C1 E2 04 8B 8A ?? ?? ?? ?? 8B 92 ?? ?? ?? ?? 39 54 24 5C 0F 87 CE 46 00 00 72 0A 39 4C 24 58 0F 87 C2 46 00 00 39 54 24 5C 0F 84 20 76 00 00 C7 84 24 80 00 00 00 00 00 00 00 C7 84 24 84 00 00 00 0A 5B C1 38 C7 44 24 50 93 8D 44 C6 C7 44 24 54 4D 31 00 00 85 C0 0F 84 3C 07 00 00 83 F8 01 0F 84 43 37 00 00 83 F8 02 0F 84 84 3A 00 00 83 F8 03 0F 85 21 07 00 00 8B 9C 24 90 00 00 00 39 9C 24 88 00 00 00 0F 84 0D 07 00 00 83 84 24 80 00 00 00 FF 83 94 24 84 00 00 00 FF 8B 94 24 84 00 00 00 8B 84 24 80 00 00 00 F7 D2 F7 D0 09 C2 0F 84 82 54 00 00 8B 94 24 84 00 00 00 81 F2 09 5B C1 38 09 D0 0F 85 CE 06 00 00 8B 54 24 50 8B 44 24 54 81 F2 93 8D 44 C6 35 4D 31 00 00 09 C2 0F 85 B3 06 00 00 83 44 24 68 00 81 54 24 6C 00 00 FE FF C7 84 24 80 00 00 00 FF FF FF FF C7 84 24 84 00 00 00 63 8E 8D 37 C7 44 24 50 C0 87 AD BE C7 44 24 54 09 ED 01 00 E9 7B 06 00 00 8B 4C 24 70 39 4C 24 68 0F 83 A1 F8 FF FF 8B B4 24 80 00 00 00 8B BC 24 84 00 00 00 8B 44 24 50 8B 5C 24 64 8B 54 24 54 89 B4 24 C0 00 00 00 8B 74 24 5C 89 BC 24 C4 00 00 00 8B 7C 24 74 89 9C 24 84 00 00 00 8B 5C 24 58 89 44 24 58 8B 44 24 68 8B 4C 24 60 89 74 24 54 8B 74 24 70 89 54 24 5C 8B 54 24 6C 89 44 24 70 8B 84 24 88 00 00 00 89 7C 24 6C 8B BC 24 90 00 00 00 89 8C 24 80 00 00 00 89 5C 24 50 89 74 24 68 89 54 24 74 89 BC 24 88 00 00 00 89 84 24 90 00 00 00 E9 24 F8 FF FF 0F 86 05 06 00 00 8B 74 24 54 0B 74 24 50 0F 84 5A 03 00 00 DF 6C 24 50 DD 5C 24 58 8B 5C 24 5C 89 D9 C1 E9 14 81 E1 FF 07 00 00 81 E9 BF 03 00 00 89 CB C1 E3 05 8B BB ?? ?? ?? ?? 85 FF 75 3A 8B BB ?? ?? ?? ?? 8B B3 ?? ?? ?? ?? 8B 9B ?? ?? ?? ?? 39 5C 24 54 0F 87 A2 16 00 00 72 0A 39 74 24 50 0F 87 96 16 00 00 33 5C 24 54 33 74 24 50 09 F3 0F 84 5B 16 00 00 66 90 BE 22 00 00 00 8B 4C 24 68 8B 5C 24 6C 29 FE 2B 4C 24 70 1B 5C 24 74 89 D9 C1 E9 11 39 CE 0F 4F F1 85 F6 0F 84 9B 07 00 00 83 FF 13 0F 8F 8E 17 00 00 83 FE 13 0F 8F 5B 29 00 00 8B 0C F5 ?? ?? ?? ?? 8B 9C 24 84 00 00 00 8B BC 24 80 00 00 00 89 C8 F7 E3 89 44 24 58 8B 04 F5 ?? ?? ?? ?? 89 54 24 5C F7 E3 89 84 24 80 00 00 00 89 C8 89 94 24 84 00 00 00 F7 E7 89 54 24 54 8B 5C 24 54 31 D2 89 44 24 50 8B 44 24 58 89 D9 31 DB 01 C1 8B 04 F5 ?? ?? ?? ?? 11 D3 F7 E7 01 C1 11 D3 8B 54 24 5C 89 D0 31 D2 89 44 24 58 8B 84 24 80 00 00 00 01 44 24 58 8B 44 24 50 89 54 24 5C 8B 94 24 84 00 00 00 11 54 24 5C 31 D2 01 5C 24 58 89 CB 11 54 24 5C 31 C9 31 D2 01 C1 11 D3 8D 74 26 00 8B 44 24 68 89 F7 BE 00 00 00 00 8B 54 24 6C C1 E7 11 29 F0 19 FA 0B 44 24 58 0B 94 24 88 00 00 00 0B 54 24 5C E9 0B F4 FF FF 8D B6 00 00 00 00 85 C9 0F 88 EF 04 00 00 B8 21 00 00 00 29 F0 39 C1 0F 8F FE 06 00 00 2B 4C 24 78 01 CE 83 FE 13 0F 8E 5D 1E 00 00 8D 5E EC 8B 8C 24 84 00 00 00 C1 E3 04 8B 84 24 80 00 00 00 0F AF 83 ?? ?? ?? ?? 0F AF 8B ?? ?? ?? ?? 8B B3 ?? ?? ?? ?? 8B BC 24 80 00 00 00 01 C1 8B 84 24 80 00 00 00 F7 A3 ?? ?? ?? ?? 01 CA 8B 8B ?? ?? ?? ?? 89 54 24 64 8B 94 24 84 00 00 00 89 44 24 60 89 D0 89 54 24 50 F7 E1 89 44 24 78 8B 44 24 50 89 54 24 7C F7 E6 89 44 24 50 89 F8 89 54 24 54 F7 E1 89 94 24 9C 00 00 00 8B 9C 24 9C 00 00 00 31 D2 89 84 24 98 00 00 00 8B 44 24 78 89 D9 31 DB 01 C1 89 F8 8B 7C 24 64 11 D3 F7 E6 01 C1 8B 84 24 98 00 00 00 11 D3 31 F6 89 B4 24 80 00 00 00 31 D2 8B 74 24 60 01 84 24 80 00 00 00 89 8C 24 84 00 00 00 89 D9 11 94 24 84 00 00 00 01 74 24 50 11 7C 24 54 8B 54 24 7C 89 D0 31 D2 01 44 24 50 11 54 24 54 31 DB 01 4C 24 50 11 5C 24 54 8B 9C 24 90 00 00 00 39 9C 24 88 00 00 00 8B B4 24 80 00 00 00 8B BC 24 84 00 00 00 0F 84 C2 2F 00 00 8B 4C 24 50 8B 5C 24 54 2B B4 24 C0 00 00 00 1B BC 24 C4 00 00 00 2B 4C 24 58 1B 5C 24 5C 39 BC 24 84 00 00 00 77 11 72 09 39 B4 24 80 00 00 00 73 06 83 C1 FF 83 D3 FF 89 C8 89 DA 09 F0 09 FA 09 C2 0F 84 DB 18 00 00 85 DB 0F 88 EB 40 00 00 8B 94 24 88 00 00 00 89 C8 89 F1 0B 44 24 70 09 DA 89 FB 0B 54 24 74 E9 5C F2 FF FF 8D B4 26 00 00 00 00 }
	condition:
		$1
}

rule file_127_7_0 {
	meta:
		name = "___bid128qd_add"
		size = 192
		refs = "0049 ___bid64_to_bid128"
	strings:
		$1 = { 53 83 EC 68 8B 44 24 74 8D 4C 24 50 8B 94 24 88 00 00 00 89 0C 24 8B 5C 24 70 89 44 24 30 8B 44 24 78 89 54 24 08 89 44 24 34 8B 44 24 7C 89 44 24 38 8B 84 24 80 00 00 00 89 44 24 3C 8B 84 24 84 00 00 00 89 44 24 04 E8 ?? ?? ?? ?? 8B 54 24 50 8D 44 24 40 89 04 24 89 54 24 14 8B 54 24 54 89 54 24 18 8B 54 24 58 89 54 24 1C 8B 54 24 5C 89 54 24 20 8B 54 24 30 89 54 24 04 8B 54 24 34 89 54 24 08 8B 54 24 38 89 54 24 0C 8B 54 24 3C 89 54 24 10 E8 A7 73 FF FF 8B 44 24 40 8B 54 24 44 89 03 8B 44 24 48 89 53 04 8B 54 24 4C 89 43 08 89 D8 89 53 0C 83 C4 68 5B C3 90 8D 74 26 00 }
	condition:
		$1
}

rule file_127_8_0 {
	meta:
		name = "___bid128dq_add"
		size = 192
		refs = "0049 ___bid64_to_bid128"
	strings:
		$1 = { 53 83 EC 68 8B 44 24 7C 8D 4C 24 50 8B 54 24 78 89 0C 24 8B 5C 24 70 89 44 24 30 8B 84 24 80 00 00 00 89 54 24 08 89 44 24 34 8B 84 24 84 00 00 00 89 44 24 38 8B 84 24 88 00 00 00 89 44 24 3C 8B 44 24 74 89 44 24 04 E8 ?? ?? ?? ?? 8B 54 24 30 8D 44 24 40 89 04 24 89 54 24 14 8B 54 24 34 89 54 24 18 8B 54 24 38 89 54 24 1C 8B 54 24 3C 89 54 24 20 8B 54 24 50 89 54 24 04 8B 54 24 54 89 54 24 08 8B 54 24 58 89 54 24 0C 8B 54 24 5C 89 54 24 10 E8 E7 72 FF FF 8B 44 24 40 8B 54 24 44 89 03 8B 44 24 48 89 53 04 8B 54 24 4C 89 43 08 89 D8 89 53 0C 83 C4 68 5B C3 90 8D 74 26 00 }
	condition:
		$1
}

rule file_127_9_0 {
	meta:
		name = "___bid128dd_add"
		size = 208
		refs = "0036 ___bid64_to_bid128"
	strings:
		$1 = { 83 EC 6C 8B 54 24 74 8D 44 24 40 8B 4C 24 78 89 74 24 64 8B 74 24 7C 89 7C 24 68 8B BC 24 80 00 00 00 89 54 24 04 89 4C 24 08 89 04 24 89 5C 24 60 8B 5C 24 70 E8 ?? ?? ?? ?? 8D 44 24 50 89 74 24 04 89 7C 24 08 89 04 24 E8 ?? ?? ?? ?? 8B 54 24 50 8D 44 24 30 89 04 24 89 54 24 14 8B 54 24 54 89 54 24 18 8B 54 24 58 89 54 24 1C 8B 54 24 5C 89 54 24 20 8B 54 24 40 89 54 24 04 8B 54 24 44 89 54 24 08 8B 54 24 48 89 54 24 0C 8B 54 24 4C 89 54 24 10 E8 26 72 FF FF 8B 44 24 30 8B 54 24 34 8B 74 24 64 8B 7C 24 68 89 03 8B 44 24 38 89 53 04 8B 54 24 3C 89 43 08 89 D8 89 53 0C 8B 5C 24 60 83 C4 6C C3 89 F6 8D BC 27 00 00 00 00 }
	condition:
		$1
}

rule file_127_10_0 {
	meta:
		name = "___bid128_sub"
		size = 192
	strings:
		$1 = { 56 53 83 EC 54 8B 44 24 64 8B 94 24 80 00 00 00 8B 5C 24 60 89 44 24 40 8B 44 24 68 89 D1 81 E1 00 00 00 7C 81 F9 00 00 00 7C 89 D1 89 44 24 44 8B 44 24 6C 89 44 24 48 8B 44 24 70 89 44 24 4C 8B 44 24 74 89 44 24 30 8B 44 24 78 89 44 24 34 8B 44 24 7C 74 13 89 D6 81 E1 FF FF FF 7F 81 CE 00 00 00 80 85 D2 0F 49 CE 89 44 24 1C 8B 44 24 40 8B 54 24 30 89 1C 24 89 4C 24 20 89 44 24 04 8B 44 24 44 89 54 24 14 8B 54 24 34 89 44 24 08 8B 44 24 48 89 54 24 18 89 44 24 0C 8B 44 24 4C 89 44 24 10 E8 47 71 FF FF 83 C4 54 89 D8 5B 5E C3 EB 0D 90 90 90 90 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_127_11_0 {
	meta:
		name = "___bid128qd_sub"
		size = 192
		refs = "0049 ___bid64_to_bid128"
	strings:
		$1 = { 53 83 EC 68 8B 44 24 74 8D 4C 24 50 8B 94 24 88 00 00 00 89 0C 24 8B 5C 24 70 89 44 24 30 8B 44 24 78 89 54 24 08 89 44 24 34 8B 44 24 7C 89 44 24 38 8B 84 24 80 00 00 00 89 44 24 3C 8B 84 24 84 00 00 00 89 44 24 04 E8 ?? ?? ?? ?? 8B 54 24 50 8D 44 24 40 89 04 24 89 54 24 14 8B 54 24 54 89 54 24 18 8B 54 24 58 89 54 24 1C 8B 54 24 5C 89 54 24 20 8B 54 24 30 89 54 24 04 8B 54 24 34 89 54 24 08 8B 54 24 38 89 54 24 0C 8B 54 24 3C 89 54 24 10 E8 A7 FE FF FF 8B 44 24 40 8B 54 24 44 89 03 8B 44 24 48 89 53 04 8B 54 24 4C 89 43 08 89 D8 89 53 0C 83 C4 68 5B C3 90 8D 74 26 00 }
	condition:
		$1
}

rule file_127_12_0 {
	meta:
		name = "___bid128dq_sub"
		size = 192
		refs = "0049 ___bid64_to_bid128"
	strings:
		$1 = { 53 83 EC 68 8B 44 24 7C 8D 4C 24 50 8B 54 24 78 89 0C 24 8B 5C 24 70 89 44 24 30 8B 84 24 80 00 00 00 89 54 24 08 89 44 24 34 8B 84 24 84 00 00 00 89 44 24 38 8B 84 24 88 00 00 00 89 44 24 3C 8B 44 24 74 89 44 24 04 E8 ?? ?? ?? ?? 8B 54 24 30 8D 44 24 40 89 04 24 89 54 24 14 8B 54 24 34 89 54 24 18 8B 54 24 38 89 54 24 1C 8B 54 24 3C 89 54 24 20 8B 54 24 50 89 54 24 04 8B 54 24 54 89 54 24 08 8B 54 24 58 89 54 24 0C 8B 54 24 5C 89 54 24 10 E8 E7 FD FF FF 8B 44 24 40 8B 54 24 44 89 03 8B 44 24 48 89 53 04 8B 54 24 4C 89 43 08 89 D8 89 53 0C 83 C4 68 5B C3 90 8D 74 26 00 }
	condition:
		$1
}

rule file_127_13_0 {
	meta:
		name = "___bid128dd_sub"
		size = 208
		refs = "0036 ___bid64_to_bid128"
	strings:
		$1 = { 83 EC 6C 8B 54 24 74 8D 44 24 40 8B 4C 24 78 89 74 24 64 8B 74 24 7C 89 7C 24 68 8B BC 24 80 00 00 00 89 54 24 04 89 4C 24 08 89 04 24 89 5C 24 60 8B 5C 24 70 E8 ?? ?? ?? ?? 8D 44 24 50 89 74 24 04 89 7C 24 08 89 04 24 E8 ?? ?? ?? ?? 8B 54 24 50 8D 44 24 30 89 04 24 89 54 24 14 8B 54 24 54 89 54 24 18 8B 54 24 58 89 54 24 1C 8B 54 24 5C 89 54 24 20 8B 54 24 40 89 54 24 04 8B 54 24 44 89 54 24 08 8B 54 24 48 89 54 24 0C 8B 54 24 4C 89 54 24 10 E8 26 FD FF FF 8B 44 24 30 8B 54 24 34 8B 74 24 64 8B 7C 24 68 89 03 8B 44 24 38 89 53 04 8B 54 24 3C 89 43 08 89 D8 89 53 0C 8B 5C 24 60 83 C4 6C C3 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_128_0_0 {
	meta:
		name = "___bid_gedd2"
		size = 64
		refs = "0024 ___bid64_quiet_greater_equal"
	strings:
		$1 = { 53 83 EC 18 8B 54 24 24 8B 5C 24 2C 8B 44 24 20 8B 4C 24 28 89 54 24 04 89 5C 24 0C 89 04 24 89 4C 24 08 E8 ?? ?? ?? ?? BA FF FF FF FF 85 C0 0F 44 C2 83 C4 18 5B C3 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_129_0_0 {
	meta:
		name = "___ucmpdi2"
		size = 80
	strings:
		$1 = { 83 EC 08 31 C0 8B 4C 24 10 8B 54 24 18 89 1C 24 8B 5C 24 14 89 74 24 04 8B 74 24 0C 39 D1 72 07 76 10 B8 02 00 00 00 8B 1C 24 8B 74 24 04 83 C4 08 C3 39 DE 72 F1 77 EA B8 01 00 00 00 8D 76 00 EB E5 90 90 90 90 90 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_132_0_0 {
	meta:
		name = "___mulsc3"
		size = 1104
		refs = "01ca .rdata"
	strings:
		$1 = { 83 EC 24 D9 44 24 28 D9 44 24 2C D9 44 24 30 D9 44 24 34 D9 C3 D8 CA D9 5C 24 14 D9 C2 D8 C9 D9 5C 24 18 D9 C3 D8 C9 D9 5C 24 1C D9 C2 D8 CA D9 5C 24 20 D9 44 24 14 D9 44 24 18 D9 C1 D8 E1 D9 44 24 1C D9 5C 24 0C D9 44 24 20 D9 1C 24 D9 44 24 0C D8 04 24 D9 54 24 08 D9 C9 DB E8 7A 41 DD DE DD D8 DD D8 DD D8 DD D8 DD D8 DD D9 EB 21 DD DD DD D8 DD D8 DD D8 DD D8 DD D9 EB 13 DD D8 DD D8 DD D9 DD D9 EB 09 DD D8 DD D8 DD D9 DD D9 90 D9 5C 24 04 8B 44 24 04 8B 54 24 08 83 C4 24 C3 D9 C9 DF E8 7B C9 D9 C6 D8 E7 D9 54 24 10 DF E8 7B 07 E9 98 02 00 00 D9 CE D9 C5 D8 E6 D9 54 24 10 DF E8 7B 07 E9 C4 01 00 00 D9 CD D9 CC 31 C0 DB E8 D9 C0 0F 9A C1 D8 E1 D9 54 24 10 DF E8 0F 8A 74 01 00 00 D9 CB EB 02 D9 CB DB E8 D9 C0 0F 9A C2 D8 E1 D9 54 24 10 DF E8 0F 8A E7 00 00 00 84 C0 0F 85 9A 00 00 00 D9 C2 D8 E3 D9 54 24 10 DF E8 0F 8A 1D 03 00 00 DD DA D9 C9 D9 C1 D8 E2 DF E8 0F 8A FC 02 00 00 DD D9 D9 44 24 0C D8 E0 DF E8 0F 8A DB 02 00 00 D9 04 24 D8 E0 DF E8 0F 8B 38 FF FF FF D9 04 24 DF E8 0F 8A 37 FF FF FF DD DA D9 C9 D9 CB EB 18 DD DA D9 C9 D9 CB EB 10 DD DA D9 C9 D9 CB EB 08 DD D8 DD DA D9 C9 D9 CB DB E8 0F 8A 7D 02 00 00 D9 CA EB 02 D9 CA DB E8 0F 8A 53 02 00 00 84 C9 74 07 E9 2A 02 00 00 D9 C9 84 D2 0F 85 EE 01 00 00 D9 CA D9 CB 8D 76 00 EB 1C DD DC DD D8 DD D8 D9 C9 EB 12 D9 CA D9 CB EB 0C D9 CA D9 CB EB 06 D9 CA D9 CB D9 CA D9 C3 D8 CA D9 C3 D8 CA DE E9 D9 05 ?? ?? ?? ?? DC C9 D9 CD DE CA D9 CB DE CA DE C1 DE CA D9 C9 D9 5C 24 08 E9 A9 FE FF FF 84 D2 0F 85 11 FF FF FF DD DC DD D8 DD D8 D9 E5 DF E0 DD D8 F6 C4 02 D9 EE 74 0A DD D8 D9 EE D9 E0 EB 02 D9 C9 D9 E8 D9 CA D9 E5 DF E0 DD D8 D9 C9 F6 C4 02 D9 E1 74 02 D9 E0 D9 CB DB E8 0F 8A C9 00 00 00 D9 CA EB 02 D9 CA DB E8 0F 8B 73 FF FF FF D9 E5 DF E0 DD D8 F6 C4 02 D9 EE 0F 84 68 FF FF FF DD D8 D9 EE D9 E0 D9 CA D9 CB E9 65 FF FF FF 84 C9 0F 85 88 FE FF FF DD DC DD D8 DD D8 D9 C9 D9 E5 DF E0 DD D8 F6 C4 02 D9 E8 74 06 DD D8 D9 E8 D9 E0 D9 C1 D8 E2 DF E8 0F 8A 8A 00 00 00 D9 EE D9 CA EB 82 D9 CD DB E8 0F 8A 32 FE FF FF D9 CE D9 E5 DF E0 DD D8 F6 C4 02 D9 EE 74 0C DD D8 D9 EE D9 E0 EB 04 D9 CE D9 CD D9 E8 D9 5C 24 10 D9 CE D9 E5 DF E0 DD D8 D9 44 24 10 F6 C4 02 D9 E1 74 06 D9 E0 D9 CC EB 02 D9 CC DB E8 7A 60 D9 CB EB 02 D9 CB DB E8 7A 41 D9 CB D9 CC D9 CD D9 CC B8 01 00 00 00 E9 DC FD FF FF D9 E5 DF E0 DD D8 F6 C4 02 D9 EE 0F 84 2A FF FF FF DD D8 D9 EE D9 E0 D9 CA E9 1F FF FF FF D9 C9 DB E8 0F 8B EE FE FF FF D9 C9 E9 65 FF FF FF D9 E5 DF E0 DD D8 F6 C4 02 D9 EE 74 B2 DD D8 D9 EE D9 E0 EB AA D9 E5 DF E0 DD D8 F6 C4 02 D9 EE 74 97 DD D8 D9 EE D9 E0 D9 CB EB 8F D9 CE DB E8 0F 8A 5E FD FF FF D9 E5 DF E0 DD D8 F6 C4 02 D9 E8 74 06 DD D8 D9 E8 D9 E0 D9 C5 D8 E6 D9 54 24 10 DF E8 7A 33 D9 EE D9 5C 24 10 D9 CE D9 CD E9 34 FF FF FF D9 CB D9 E5 DF E0 DD D8 F6 C4 02 D9 EE 0F 84 1E FE FF FF DD D8 D9 EE D9 E0 D9 CA D9 CB D9 CA E9 13 FE FF FF D9 CD DB E8 0F 8B FA FE FF FF D9 CD EB BF D9 C9 D9 E5 DF E0 DD D8 F6 C4 02 D9 EE 0F 84 C3 FD FF FF DD D8 D9 EE D9 E0 D9 C9 E9 B8 FD FF FF D9 E5 DF E0 DD D8 F6 C4 02 D9 EE 0F 84 9C FD FF FF DD D8 D9 EE D9 E0 E9 91 FD FF FF D9 E5 DF E0 DD D8 F6 C4 02 D9 EE 0F 84 76 FD FF FF DD D8 D9 EE D9 E0 D9 CA E9 6B FD FF FF D9 44 24 0C DF E8 0F 8B 39 FD FF FF E9 14 FD FF FF D9 C9 DF E8 0F 8B 32 FD FF FF 66 90 E9 F5 FC FF FF D9 CA DF E8 0F 8B 29 FD FF FF D9 C9 E9 D6 FC FF FF 90 90 90 90 90 90 90 90 90 90 }
	condition:
		$1
}

rule file_133_0_0 {
	meta:
		name = "___floatundisf"
		size = 80
		refs = "0033 .rdata"
	strings:
		$1 = { 53 83 EC 10 8B 4C 24 1C 8B 44 24 18 81 F9 FF FF 1F 00 76 0F A9 FF 07 00 00 74 08 25 00 F8 FF FF 80 CC 08 31 DB 31 D2 89 0C 24 89 5C 24 04 DF 2C 24 D8 0D ?? ?? ?? ?? 89 04 24 89 54 24 04 DF 2C 24 DE C1 D9 5C 24 0C D9 44 24 0C 83 C4 10 5B C3 }
	condition:
		$1
}

rule file_134_0_0 {
	meta:
		name = "___bid64_isSigned"
		size = 16
	strings:
		$1 = { 8B 44 24 08 C1 E8 1F C3 90 8D B4 26 00 00 00 00 }
	condition:
		$1
}

rule file_134_1_0 {
	meta:
		name = "___bid64_isNormal"
		size = 336
		refs = "0073 .rdata"
	strings:
		$1 = { 83 EC 2C 31 C0 89 74 24 20 8B 74 24 34 89 7C 24 24 8B 7C 24 30 89 5C 24 1C 89 6C 24 28 89 F2 81 E2 00 00 00 78 81 FA 00 00 00 78 0F 84 C1 00 00 00 89 F2 81 E2 00 00 00 60 81 FA 00 00 00 60 0F 84 C1 00 00 00 89 F3 89 F9 81 E3 FF FF 1F 00 89 DA 09 FA 0F 84 99 00 00 00 81 E6 00 00 E0 7F C1 EE 15 83 FE 0E B8 01 00 00 00 0F 87 82 00 00 00 8B 2C F5 ?? ?? ?? ?? 89 DF 8B 1C F5 ?? ?? ?? ?? 89 E8 F7 E7 89 04 24 89 D8 89 54 24 04 F7 E7 89 44 24 10 89 E8 89 54 24 14 F7 E1 89 54 24 0C 8B 7C 24 0C 31 D2 89 44 24 08 8B 04 24 89 FE 31 FF 01 C6 89 D8 11 D7 F7 E1 01 C6 11 D7 8B 54 24 04 89 D0 31 D2 03 44 24 10 13 54 24 14 31 DB 01 F8 11 DA 89 D1 09 C1 75 70 8B 44 24 08 89 F7 31 F6 31 D2 01 C6 11 D7 81 FF 7E 8D 03 00 77 5A 73 50 31 C0 8B 5C 24 1C 8B 74 24 20 8B 7C 24 24 8B 6C 24 28 83 C4 2C C3 89 F0 89 F9 25 FF FF 07 00 89 C3 89 F8 81 CB 00 00 20 00 83 C0 FF 89 DA 83 D2 FF 81 FA F2 86 23 00 77 C7 72 07 3D FE FF C0 6F 77 BE 81 E6 00 00 F8 1F C1 EE 13 E9 22 FF FF FF 81 FE FF 7F C6 A4 76 A8 B8 01 00 00 00 EB A3 90 }
	condition:
		$1
}

rule file_134_2_0 {
	meta:
		name = "___bid64_isSubnormal"
		size = 352
		refs = "006d .rdata"
	strings:
		$1 = { 83 EC 2C 89 74 24 20 8B 74 24 34 89 6C 24 28 31 ED 8B 54 24 30 89 5C 24 1C 89 7C 24 24 89 F0 25 00 00 00 78 3D 00 00 00 78 0F 84 C5 00 00 00 89 F0 25 00 00 00 60 3D 00 00 00 60 0F 84 CF 00 00 00 89 F3 89 D1 81 E3 FF FF 1F 00 89 D8 09 D0 0F 84 9F 00 00 00 89 F0 25 00 00 E0 7F C1 E8 15 31 ED 83 F8 0E 0F 87 8A 00 00 00 8B 34 C5 ?? ?? ?? ?? 89 DF 8B 1C C5 ?? ?? ?? ?? 89 F0 F7 E7 89 04 24 89 D8 89 54 24 04 F7 E7 89 44 24 10 89 F0 89 54 24 14 F7 E1 89 54 24 0C 8B 7C 24 0C 31 D2 89 44 24 08 8B 04 24 89 FE 31 FF 01 C6 89 D8 8B 5C 24 04 11 D7 F7 E1 89 D9 01 C6 11 D7 31 DB 03 4C 24 10 89 FA 13 5C 24 14 89 D0 31 D2 01 C1 11 D3 89 DA 09 CA 75 1E 8B 4C 24 08 31 C0 31 DB 89 F2 66 BD 01 00 01 C8 11 DA 81 FA 7E 8D 03 00 72 04 76 5E 31 ED 89 E8 8B 5C 24 1C 8B 74 24 20 8B 7C 24 24 8B 6C 24 28 83 C4 2C C3 8D B6 00 00 00 00 89 F0 89 D1 25 FF FF 07 00 89 C3 89 D0 81 CB 00 00 20 00 83 C0 FF 89 DA 83 D2 FF 81 FA F2 86 23 00 77 BF 72 07 3D FE FF C0 6F 77 B6 89 F0 25 00 00 F8 1F C1 E8 13 E9 14 FF FF FF 90 8D 74 26 00 3D FF 7F C6 A4 76 9D EB 99 8D B4 26 00 00 00 00 }
	condition:
		$1
}

rule file_134_3_0 {
	meta:
		name = "___bid64_isFinite"
		size = 32
	strings:
		$1 = { 8B 44 24 08 25 00 00 00 78 3D 00 00 00 78 0F 95 C0 0F B6 C0 C3 8D 74 26 00 8D BC 27 00 00 00 00 }
	condition:
		$1
}

rule file_134_4_0 {
	meta:
		name = "___bid64_isZero"
		size = 112
	strings:
		$1 = { 8B 44 24 08 8B 4C 24 04 89 C2 81 E2 00 00 00 78 81 FA 00 00 00 78 74 3B 89 C2 81 E2 00 00 00 60 81 FA 00 00 00 60 74 0E 25 FF FF 1F 00 09 C1 0F 94 C0 0F B6 C0 C3 89 C2 B8 01 00 00 00 81 E2 FF FF 07 00 81 CA 00 00 20 00 81 FA F2 86 23 00 77 04 73 04 31 C0 F3 C3 81 F9 FF FF C0 6F 8D 76 00 76 F1 F3 C3 8D B6 00 00 00 00 8D BF 00 00 00 00 }
	condition:
		$1
}

rule file_134_5_0 {
	meta:
		name = "___bid64_isInf"
		size = 48
	strings:
		$1 = { 8B 54 24 08 31 C0 89 D1 81 E1 00 00 00 78 81 F9 00 00 00 78 74 02 F3 C3 81 E2 00 00 00 7C 31 C0 81 FA 00 00 00 7C 0F 95 C0 C3 8D B6 00 00 00 00 }
	condition:
		$1
}

rule file_134_6_0 {
	meta:
		name = "___bid64_isSignaling"
		size = 32
	strings:
		$1 = { 8B 44 24 08 25 00 00 00 7E 3D 00 00 00 7E 0F 94 C0 0F B6 C0 C3 8D 74 26 00 8D BC 27 00 00 00 00 }
	condition:
		$1
}

rule file_134_7_0 {
	meta:
		name = "___bid64_isCanonical"
		size = 160
	strings:
		$1 = { 53 8B 54 24 0C 8B 4C 24 08 89 D0 25 00 00 00 7C 3D 00 00 00 7C 74 29 89 D0 25 00 00 00 78 3D 00 00 00 78 74 3B 89 D3 B8 01 00 00 00 81 E3 00 00 00 60 81 FB 00 00 00 60 74 36 5B C3 8D 74 26 00 31 C0 F7 C2 00 00 FC 01 75 F0 81 E2 FF FF 03 00 B0 01 81 FA 7E 8D 03 00 72 E0 76 35 31 C0 5B C3 81 E2 FF FF FF 03 09 D1 0F 94 C0 0F B6 C0 5B C3 81 E2 FF FF 07 00 81 CA 00 00 20 00 81 FA F2 86 23 00 72 B6 77 D6 81 F9 FF FF C0 6F 77 CE 5B 90 C3 81 F9 FF 7F C6 A4 77 C3 5B C3 90 8D 74 26 00 }
	condition:
		$1
}

rule file_134_8_0 {
	meta:
		name = "___bid64_isNaN"
		size = 32
	strings:
		$1 = { 8B 44 24 08 25 00 00 00 7C 3D 00 00 00 7C 0F 94 C0 0F B6 C0 C3 8D 74 26 00 8D BC 27 00 00 00 00 }
	condition:
		$1
}

rule file_134_9_0 {
	meta:
		name = "___bid64_copy"
		size = 16
	strings:
		$1 = { 8B 44 24 04 8B 54 24 08 C3 8D B4 26 00 00 00 00 }
	condition:
		$1
}

rule file_134_12_0 {
	meta:
		name = "___bid64_copySign"
		size = 32
	strings:
		$1 = { 8B 44 24 08 8B 54 24 10 25 FF FF FF 7F 81 E2 00 00 00 80 09 C2 8B 44 24 04 C3 8D B6 00 00 00 00 }
	condition:
		$1
}

rule file_134_13_0 {
	meta:
		name = "___bid64_class"
		size = 432
		refs = "007b .rdata"
	strings:
		$1 = { 83 EC 2C 89 6C 24 28 8B 6C 24 34 89 5C 24 1C 8B 54 24 30 89 74 24 20 89 7C 24 24 89 E8 25 00 00 00 7C 3D 00 00 00 7C 0F 84 33 01 00 00 89 E8 25 00 00 00 78 3D 00 00 00 78 89 E8 0F 84 32 01 00 00 25 00 00 00 60 3D 00 00 00 60 0F 84 C7 00 00 00 89 EB 89 D1 81 E3 FF FF 1F 00 89 D8 09 D0 0F 84 DB 00 00 00 89 E8 25 00 00 E0 7F C1 E8 15 83 F8 0E 0F 8F 08 01 00 00 8B 34 C5 ?? ?? ?? ?? 89 DF 8B 1C C5 ?? ?? ?? ?? 89 F0 F7 E7 89 04 24 89 D8 89 54 24 04 F7 E7 89 44 24 10 89 F0 89 54 24 14 F7 E1 89 54 24 0C 8B 7C 24 0C 31 D2 89 44 24 08 8B 04 24 89 FE 31 FF 01 C6 89 D8 8B 5C 24 04 11 D7 F7 E1 89 D9 01 C6 11 D7 31 DB 03 4C 24 10 89 FA 13 5C 24 14 89 D0 31 D2 01 C1 11 D3 89 DA 09 CA 0F 85 98 00 00 00 8B 4C 24 08 31 C0 31 DB 89 F2 01 C8 11 DA 81 FA 7E 8D 03 00 0F 87 7E 00 00 00 72 07 3D FF 7F C6 A4 77 75 89 E8 C1 F8 1F 83 E0 FD 83 C0 07 EB 30 89 E8 89 D1 25 FF FF 07 00 89 C3 89 D0 81 CB 00 00 20 00 83 C0 FF 89 DA 83 D2 FF 81 FA F2 86 23 00 72 5C 76 53 8D 76 00 89 E8 C1 F8 1F 83 C0 06 8B 5C 24 1C 8B 74 24 20 8B 7C 24 24 8B 6C 24 28 83 C4 2C C3 8D 74 26 00 81 E5 00 00 00 7E 31 C0 81 FD 00 00 00 7E 0F 95 C0 EB D5 C1 F8 1F 83 E0 F9 83 C0 09 EB CA 66 90 89 E8 C1 F8 1F 83 E0 FB 83 C0 08 EB BB 8D 76 00 3D FE FF C0 6F 77 A9 89 E8 25 00 00 F8 1F C1 E8 13 E9 C9 FE FF FF 8D 76 00 8D BC 27 00 00 00 00 }
	condition:
		$1
}

rule file_134_14_0 {
	meta:
		name = "___bid64_sameQuantum"
		size = 224
	strings:
		$1 = { 53 8B 54 24 0C 8B 4C 24 14 89 D0 25 00 00 00 7C 3D 00 00 00 7C 0F 84 A5 00 00 00 89 CB 31 C0 81 E3 00 00 00 7C 81 FB 00 00 00 7C 74 5B 89 D3 81 E3 00 00 00 78 81 FB 00 00 00 78 74 53 89 CB 81 E3 00 00 00 78 81 FB 00 00 00 78 74 3B 89 D0 89 D3 81 E3 00 00 E0 7F 25 00 00 00 60 C1 EB 15 3D 00 00 00 60 74 4B 89 CA 89 C8 25 00 00 E0 7F 81 E2 00 00 00 60 C1 E8 15 81 FA 00 00 00 60 74 25 39 C3 0F 94 C0 0F B6 C0 5B C3 8D B6 00 00 00 00 81 E1 00 00 00 78 81 F9 00 00 00 78 75 EA B8 01 00 00 00 5B C3 89 C8 25 00 00 F8 1F C1 E8 13 EB CF 89 D3 81 E3 00 00 F8 1F C1 EB 13 EB A8 66 90 81 E1 00 00 00 7C 31 C0 81 F9 00 00 00 7C 74 CE 5B C3 8D B4 26 00 00 00 00 8D BC 27 00 00 00 00 }
	condition:
		$1
}

rule file_134_15_0 {
	meta:
		name = "___bid64_totalOrder"
		size = 1584
		refs = "0399 .rdata"
	strings:
		$1 = { 83 EC 44 89 5C 24 34 8B 5C 24 4C 89 74 24 38 8B 74 24 54 89 7C 24 3C 8B 7C 24 50 89 6C 24 40 8B 6C 24 48 89 D8 25 00 00 00 7C 3D 00 00 00 7C 0F 84 6B 01 00 00 89 F0 25 00 00 00 7C 3D 00 00 00 7C 0F 84 39 01 00 00 89 DA 89 E8 31 F2 31 F8 09 C2 0F 84 11 02 00 00 89 D9 89 F0 C1 E8 1F C1 E9 1F 38 C8 88 44 24 28 0F 85 F3 01 00 00 89 D8 25 00 00 00 78 3D 00 00 00 78 0F 84 F3 01 00 00 89 F0 25 00 00 00 78 3D 00 00 00 78 0F 84 EF 00 00 00 89 D8 89 DA 25 00 00 00 60 3D 00 00 00 60 0F 84 AB 04 00 00 81 E2 00 00 E0 7F 89 D8 C1 EA 15 25 FF FF 1F 00 89 54 24 10 89 C2 09 EA 89 6C 24 08 89 44 24 0C 0F 94 44 24 20 89 F5 81 E5 00 00 00 60 81 FD 00 00 00 60 89 F5 74 4C 89 F2 81 E5 00 00 E0 7F 81 E2 FF FF 1F 00 89 D0 C1 ED 15 09 F8 89 3C 24 89 54 24 04 75 76 80 7C 24 20 00 0F 84 50 01 00 00 F7 D3 0F B6 C1 C1 EB 1F 38 5C 24 28 74 74 39 6C 24 10 B8 01 00 00 00 74 69 0F 9E C0 31 C8 0F B6 C0 EB 5F 89 F0 81 E5 00 00 F8 1F 25 FF FF 07 00 0D 00 00 20 00 89 44 24 04 8B 54 24 04 C1 ED 13 89 3C 24 8B 04 24 83 C0 FF 83 D2 FF 81 FA F2 86 23 00 89 44 24 18 89 54 24 1C 77 99 72 0D 3D FE FF C0 6F 77 90 8D B6 00 00 00 00 80 7C 24 20 00 0F 84 DA 01 00 00 90 8D 74 26 00 89 F0 F7 D0 C1 E8 1F 8B 5C 24 34 8B 74 24 38 8B 7C 24 3C 8B 6C 24 40 83 C4 44 C3 90 8D 74 26 00 89 F2 81 E2 00 00 00 7C 85 DB 0F 88 E5 00 00 00 31 C0 81 FA 00 00 00 7C 75 CD 85 F6 78 C9 89 D8 25 00 00 00 7E 3D 00 00 00 7E 89 F0 0F 94 C2 25 00 00 00 7E 3D 00 00 00 7E 0F B6 C2 0F 95 C1 38 D1 74 A4 89 DA 89 E9 81 E2 FF FF 03 00 83 C1 FF 89 D3 89 E8 83 D3 FF 81 FB 7E 8D 03 00 77 69 72 08 81 F9 FE 7F C6 A4 77 5F 89 F3 89 FE 81 E3 FF FF 03 00 89 F9 83 C6 FF 89 DF 83 D7 FF 81 FF 7E 8D 03 00 0F 87 82 03 00 00 72 0C 81 FE FE 7F C6 A4 0F 87 74 03 00 00 39 DA BE 01 00 00 00 72 0E 0F 87 25 02 00 00 39 C8 0F 87 1D 02 00 00 89 F0 E9 32 FF FF FF 80 7C 24 20 00 0F 85 20 FF FF FF 0F B6 C1 E9 1F FF FF FF B8 01 00 00 00 E9 15 FF FF FF 84 C9 B8 01 00 00 00 0F 85 08 FF FF FF 81 E6 00 00 00 78 31 C0 81 FE 00 00 00 78 0F 94 C0 E9 F2 FE FF FF 81 FA 00 00 00 7C B8 01 00 00 00 0F 85 E1 FE FF FF 85 F6 0F 89 D9 FE FF FF 89 F0 89 DA 25 00 00 00 7E 35 00 00 00 7E 0F 95 C1 81 E2 00 00 00 7E 81 FA 00 00 00 7E 0F 94 C2 38 D1 0F 84 2B 03 00 00 89 F2 89 FE 81 E2 FF FF 03 00 89 F8 83 C6 FF 89 D7 83 D7 FF 81 FF 7E 8D 03 00 0F 87 72 FF FF FF 72 0C 81 FE FE 7F C6 A4 0F 87 64 FF FF FF 89 DF 89 E9 81 E7 FF FF 03 00 83 C1 FF 89 FB 89 EE 83 D3 FF 81 FB 7E 8D 03 00 0F 87 87 02 00 00 72 0C 81 F9 FE 7F C6 A4 0F 87 79 02 00 00 39 D7 B9 01 00 00 00 77 0E 0F 82 33 01 00 00 39 C6 0F 82 2B 01 00 00 89 C8 90 8D 74 26 00 E9 32 FE FF FF 39 6C 24 10 0F 8D 53 02 00 00 39 6C 24 10 0F 9E 44 24 18 0F 8E 6A 02 00 00 8B 44 24 10 29 E8 83 F8 0F 0F 8F E3 FE FF FF 89 EA 2B 54 24 10 83 FA 0F 0F 8F 69 02 00 00 39 6C 24 10 0F 8E E7 00 00 00 8B 34 C5 ?? ?? ?? ?? 8B 5C 24 0C 8B 3C C5 ?? ?? ?? ?? 8B 6C 24 08 89 F0 F7 E3 89 44 24 10 89 F8 89 54 24 14 F7 E3 89 44 24 28 89 F0 89 54 24 2C F7 E5 89 54 24 24 8B 74 24 24 31 D2 89 44 24 20 8B 44 24 10 89 F3 31 F6 89 5C 24 08 01 44 24 08 89 F8 8B 7C 24 14 89 74 24 0C 11 54 24 0C F7 E5 01 44 24 08 89 FE 11 54 24 0C 31 FF 8B 54 24 0C 03 74 24 28 13 7C 24 2C 89 D0 31 D2 01 C6 11 D7 89 FA 09 F2 0F 85 EE 01 00 00 8B 44 24 08 31 FF 8B 74 24 20 8B 1C 24 89 C2 31 C0 01 F0 8B 74 24 04 11 FA 31 C3 31 D6 09 DE 0F 84 DA 01 00 00 3B 54 24 04 BB 01 00 00 00 72 0F 0F 87 ED 00 00 00 3B 04 24 0F 83 E4 00 00 00 89 DA 0F B6 C1 31 D0 E9 1C FD FF FF 31 F6 89 F0 E9 13 FD FF FF 31 C9 89 C8 E9 0A FD FF FF 8B 34 D5 ?? ?? ?? ?? 8B 5C 24 04 8B 3C D5 ?? ?? ?? ?? 8B 2C 24 89 F0 F7 E3 89 44 24 10 89 F8 89 54 24 14 F7 E3 89 44 24 28 89 F0 89 54 24 2C F7 E5 89 54 24 24 8B 74 24 24 31 D2 89 44 24 20 8B 44 24 10 89 F3 31 F6 89 1C 24 01 04 24 89 F8 8B 7C 24 14 89 74 24 04 11 54 24 04 F7 E5 01 04 24 89 FE 11 54 24 04 31 FF 8B 54 24 04 03 74 24 28 13 7C 24 2C 89 D0 31 D2 01 C6 11 D7 89 FA 09 F2 0F 85 12 01 00 00 8B 04 24 31 FF 8B 74 24 20 8B 5C 24 08 89 C2 31 C0 01 F0 8B 74 24 0C 11 FA 31 C3 31 D6 09 DE 0F 84 F7 00 00 00 39 54 24 0C BB 01 00 00 00 0F 82 28 FF FF FF 77 0A 39 44 24 08 0F 82 1C FF FF FF 31 DB E9 15 FF FF FF 8D B6 00 00 00 00 89 D8 81 E2 00 00 F8 1F 25 FF FF 07 00 0D 00 00 20 00 C1 EA 13 89 44 24 0C 89 6C 24 08 8B 44 24 08 89 54 24 10 8B 54 24 0C 83 C0 FF 83 D2 FF 81 FA F2 86 23 00 89 04 24 89 54 24 04 77 13 72 07 3D FE FF C0 6F 77 0A C6 44 24 20 00 E9 29 FB FF FF C6 44 24 20 01 E9 1F FB FF FF 31 C0 E9 D5 FB FF FF 8B 54 24 04 39 54 24 0C 0F 87 A0 FC FF FF 0F 82 99 FD FF FF 8B 34 24 39 74 24 08 0F 86 8C FD FF FF E9 88 FC FF FF 8B 44 24 04 39 44 24 0C 72 13 0F 87 86 FD FF FF 8B 14 24 39 54 24 08 0F 83 79 FD FF FF 89 D8 F7 D0 C1 E8 1F E9 86 FB FF FF 85 C0 0F 94 C0 0F B6 C0 E9 79 FB FF FF 31 D2 E9 4C FE FF FF BA 01 00 00 00 E9 42 FE FF FF 0F B6 44 24 18 31 C8 0F B6 C0 E9 59 FB FF FF 66 90 }
	condition:
		$1
}

rule file_134_16_0 {
	meta:
		name = "___bid64_totalOrderMag"
		size = 1216
		refs = "02b2 .rdata"
	strings:
		$1 = { 83 EC 44 8B 54 24 4C 89 74 24 38 8B 44 24 48 89 7C 24 3C 8B 74 24 54 89 5C 24 34 8B 7C 24 50 89 D1 81 E1 00 00 00 7C 81 F9 00 00 00 7C 89 6C 24 40 0F 84 E1 00 00 00 89 F1 81 E1 00 00 00 7C 81 F9 00 00 00 7C 0F 84 08 03 00 00 89 F3 89 FD 31 D3 31 C5 81 E3 FF FF FF 7F B9 01 00 00 00 09 EB 0F 84 9C 00 00 00 89 D3 81 E3 00 00 00 78 81 FB 00 00 00 78 0F 84 E6 02 00 00 89 F3 81 E3 00 00 00 78 81 FB 00 00 00 78 74 78 89 D1 89 D3 81 E1 00 00 00 60 81 F9 00 00 00 60 0F 84 35 01 00 00 81 E2 FF FF 1F 00 81 E3 00 00 E0 7F 89 44 24 10 C1 EB 15 89 D0 0B 44 24 10 89 54 24 14 0F 94 C2 89 F0 25 00 00 00 60 3D 00 00 00 60 89 F0 0F 84 4F 01 00 00 81 E6 FF FF 1F 00 25 00 00 E0 7F 89 F1 C1 E8 15 09 F9 89 7C 24 08 89 74 24 0C 0F 85 73 01 00 00 84 D2 0F BE CA 74 07 31 C9 39 C3 0F 9E C1 89 C8 8B 5C 24 34 8B 74 24 38 8B 7C 24 3C 8B 6C 24 40 83 C4 44 C3 89 F3 31 C9 81 E3 00 00 00 7C 81 FB 00 00 00 7C 75 D8 89 D1 81 E1 00 00 00 7E 81 F9 00 00 00 7E 89 F1 0F 94 44 24 08 81 E1 00 00 00 7E 81 F9 00 00 00 7E 0F 95 C1 89 CD 0F B6 4C 24 08 89 EB 3A 5C 24 08 74 A5 89 D3 89 C1 81 E3 FF FF 03 00 83 C0 FF 89 DA 83 D2 FF 81 FA 7E 8D 03 00 0F 87 D8 01 00 00 72 0B 3D FE 7F C6 A4 0F 87 CB 01 00 00 89 F2 89 FE 81 E2 FF FF 03 00 89 F8 83 C6 FF 89 D7 83 D7 FF 81 FF 7E 8D 03 00 0F 87 EC 01 00 00 72 0C 81 FE FE 7F C6 A4 0F 87 DE 01 00 00 39 D3 BE 01 00 00 00 72 0E 0F 87 E2 01 00 00 39 C1 0F 87 DA 01 00 00 89 F1 90 E9 2D FF FF FF 81 E2 FF FF 07 00 81 E3 00 00 F8 1F 81 CA 00 00 20 00 89 44 24 10 8B 44 24 10 C1 EB 13 89 54 24 14 8B 54 24 14 83 C0 FF 83 D2 FF 81 FA F2 86 23 00 77 11 0F 82 92 01 00 00 3D FE FF C0 6F 0F 86 87 01 00 00 BA 01 00 00 00 E9 9D FE FF FF 81 E6 FF FF 07 00 25 00 00 F8 1F 81 CE 00 00 20 00 89 7C 24 08 C1 E8 13 89 74 24 0C 8B 74 24 08 8B 7C 24 0C 83 C6 FF 83 D7 FF 81 FF F2 86 23 00 0F 87 9B FE FF FF 72 0C 81 FE FE FF C0 6F 0F 87 8D FE FF FF 84 D2 B9 01 00 00 00 0F 85 8E FE FF FF 39 C3 0F 8D FA 00 00 00 39 C3 0F 9E C2 89 D5 0F 8E 27 01 00 00 89 DA 31 C9 29 C2 83 FA 0F 0F 8F 6A FE FF FF 89 C6 B1 01 29 DE 83 FE 0F 0F 8F 5B FE FF FF 39 C3 0F 8E 20 01 00 00 8B 34 D5 ?? ?? ?? ?? 8B 7C 24 14 8B 1C D5 ?? ?? ?? ?? 8B 4C 24 10 89 F0 F7 E7 89 44 24 10 89 D8 89 54 24 14 F7 E7 89 44 24 20 89 F0 89 54 24 24 F7 E1 89 54 24 1C 8B 7C 24 1C 31 D2 89 44 24 18 8B 44 24 10 89 FE 31 FF 01 C6 89 D8 8B 5C 24 14 11 D7 F7 E1 89 D9 01 C6 11 D7 31 DB 03 4C 24 20 89 FA 13 5C 24 24 89 D0 31 D2 01 C1 11 D3 89 DA 09 CA 75 71 8B 4C 24 18 31 C0 31 DB 89 F2 01 C8 8B 4C 24 08 11 DA 8B 5C 24 0C 31 C1 31 D3 09 CB 0F 84 68 01 00 00 3B 54 24 0C 72 08 77 47 3B 44 24 08 73 41 B9 01 00 00 00 E9 A5 FD FF FF 8D 76 00 81 E6 00 00 00 78 31 C9 81 FE 00 00 00 78 0F 94 C1 E9 8C FD FF FF 8B 74 24 0C 39 74 24 14 77 14 0F 82 F6 FE FF FF 8B 7C 24 08 39 7C 24 10 0F 86 E8 FE FF FF 31 C9 E9 67 FD FF FF 90 8D 74 26 00 31 D2 E9 19 FD FF FF 31 F6 89 F1 E9 52 FD FF FF 8B 4C 24 0C 39 4C 24 14 72 99 0F 87 C9 FE FF FF 8B 74 24 08 39 74 24 10 72 89 E9 BA FE FF FF 8B 7C 24 0C 8B 5C 24 08 89 7C 24 18 8B 3C F5 ?? ?? ?? ?? 8B 44 24 18 8B 34 F5 ?? ?? ?? ?? F7 E7 89 74 24 04 89 44 24 20 8B 44 24 18 89 54 24 24 F7 E6 89 44 24 18 89 F8 89 54 24 1C F7 E3 89 54 24 2C 8B 7C 24 2C 31 D2 89 44 24 28 8B 44 24 20 89 FE 31 FF 89 74 24 08 01 44 24 08 8B 44 24 04 89 7C 24 0C 8B 7C 24 24 11 54 24 0C F7 E3 01 44 24 08 89 FE 11 54 24 0C 31 FF 8B 54 24 0C 03 74 24 18 13 7C 24 1C 89 D0 31 D2 01 C6 11 D7 89 FA 09 F2 0F 85 9B FC FF FF 8B 44 24 08 31 DB 8B 4C 24 28 89 C2 31 C0 01 C8 8B 4C 24 10 11 DA 8B 5C 24 14 31 C1 31 D3 09 CB 74 24 39 54 24 14 B9 01 00 00 00 0F 82 6A FC FF FF 0F 87 F6 FE FF FF 39 44 24 10 0F 82 5A FC FF FF E9 E7 FE FF FF 89 EB 0F B6 CB E9 4B FC FF FF 89 F6 8D BC 27 00 00 00 00 }
	condition:
		$1
}

rule file_135_0_0 {
	meta:
		name = "___fixtfdi"
		size = 624
	strings:
		$1 = { 83 EC 7C 8B 94 24 8C 00 00 00 8B 8C 24 80 00 00 00 89 5C 24 6C 89 74 24 70 8B B4 24 84 00 00 00 89 D3 89 7C 24 74 8B BC 24 88 00 00 00 C1 EB 10 89 6C 24 78 81 E3 FF 7F 00 00 0F B7 EA 89 54 24 2C C1 EA 18 C0 EA 07 81 FB FE 3F 00 00 89 4C 24 20 89 74 24 24 89 7C 24 28 89 4C 24 30 89 74 24 34 89 7C 24 38 89 6C 24 3C 88 54 24 0C 7F 31 85 DB 0F 84 F1 00 00 00 31 C0 31 D2 D9 74 24 40 66 83 4C 24 44 20 D9 64 24 40 9B 8B 5C 24 6C 8B 74 24 70 8B 7C 24 74 8B 6C 24 78 83 C4 7C C3 66 90 81 FB 3D 40 00 00 0F B6 54 24 0C 0F 8F CF 00 00 00 89 C8 B9 6F 40 00 00 29 D9 31 F6 89 CB 31 FF C1 FB 05 83 C6 01 81 CD 00 00 01 00 09 C7 39 F3 89 6C 24 3C 7E 0D 8B 44 B4 30 83 C6 01 09 C7 39 F3 7F F3 85 DB B8 01 00 00 00 0F 4F C3 83 E1 1F 89 4C 24 0C 0F 85 E6 00 00 00 B9 03 00 00 00 29 D9 8D 44 24 30 8D 74 8C 34 8B 0C 98 89 08 83 C0 04 39 F0 75 F4 B8 04 00 00 00 29 D8 8D 74 26 00 C7 44 84 30 00 00 00 00 83 C0 01 83 F8 03 7E F0 8B 4C 24 34 83 FF 01 8B 74 24 30 19 ED 31 FF F7