private rule architecture {
	meta:
		bits = 64
		endianness = "little"
		architecture = "x64"
	condition:
		true
}

rule file_0_0_0 {
	meta:
		name = "__fsetlocking"
		size = 46
	strings:
		$1 = { 8B 17 89 D0 25 00 80 00 00 83 F8 01 19 C0 83 C0 02 85 F6 74 0A 80 E6 7F 83 FE 02 89 17 74 09 F3 C3 0F 1F 80 00 00 00 00 80 CE 80 89 17 C3 }
	condition:
		$1
}

rule file_1_0_0 {
	meta:
		name = "prefixcmp"
		size = 24
	strings:
		$1 = { 8B 56 10 39 57 10 B8 01 00 00 00 72 09 0F 94 C0 0F B6 C0 83 E8 01 F3 C3 }
	condition:
		$1
}

rule file_1_1_0 {
	meta:
		name = "scopecmp"
		size = 20
	strings:
		$1 = { 8B 46 04 31 D2 39 47 04 B8 FF FF FF FF 0F 95 C2 0F 46 C2 C3 }
	condition:
		$1
}

rule file_1_2_0 {
	meta:
		name = "free_prefixlist"
		size = 36
		refs = "0015 free"
	strings:
		$1 = { 48 85 FF 74 1D 53 66 2E 0F 1F 84 00 00 00 00 00 48 8B 5F 18 E8 ?? ?? ?? ?? 48 85 DB 48 89 DF 75 EF 5B F3 C3 }
	condition:
		$1
}

rule file_92_20_4 {
	meta:
		name = "_ZN12_GLOBAL__N_110detach_allEPN11__gnu_debug19_Safe_iterator_baseE"
		size = 36
		refs = "0015 _ZN11__gnu_debug19_Safe_iterator_base8_M_resetEv"
	strings:
		$1 = { 48 85 FF 74 1D 53 66 2E 0F 1F 84 00 00 00 00 00 48 8B 5F 18 E8 ?? ?? ?? ?? 48 85 DB 48 89 DF 75 EF 5B F3 C3 }
	condition:
		$1
}

rule file_1_3_0 {
	meta:
		name = "in6aicmp"
		size = 18
		refs = "000e memcmp"
	strings:
		$1 = { 48 83 C6 08 48 83 C7 08 BA 10 00 00 00 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1_4_0 {
	meta:
		name = "match_prefix"
		size = 179
	strings:
		$1 = { 53 89 D0 0F B7 17 66 83 FA 02 74 08 66 83 FA 0A 74 47 5B C3 0F B7 47 02 48 C7 44 24 F0 00 00 00 00 66 C7 44 24 E0 0A 00 C7 44 24 E4 00 00 00 00 48 C7 44 24 E8 00 00 00 00 66 C7 44 24 F2 FF FF C7 44 24 F8 00 00 00 00 66 89 44 24 E2 8B 47 04 48 8D 7C 24 E0 89 44 24 F4 4C 8D 47 08 41 B9 00 FF 00 00 0F 1F 44 00 00 8B 4E 10 48 89 F0 4C 89 C2 83 F9 07 76 21 0F B6 5F 08 38 1E 74 09 EB 28 0F B6 1A 38 18 75 21 83 E9 08 48 83 C0 01 48 83 C2 01 83 F9 07 77 E9 0F B6 12 32 10 44 89 C8 D3 F8 0F B6 D2 85 C2 74 06 48 83 C6 18 EB BA 8B 46 14 5B C3 }
	condition:
		$1
}

rule file_1_6_0 {
	meta:
		name = "gaih_inet_serv.isra.1"
		size = 214
		refs = "0057 __getservbyname_r"
	strings:
		$1 = { 55 48 89 E5 41 57 49 89 FF 41 56 4C 8D 76 0A 41 55 49 89 F5 41 54 49 89 CC 53 BB 00 04 00 00 48 83 EC 48 48 89 55 98 48 8D 43 1E B9 10 00 00 00 31 D2 4C 8D 4D A8 49 89 D8 4C 89 F6 48 F7 F1 48 8D 55 B0 4C 89 FF 48 C1 E0 04 48 29 C4 48 8D 4C 24 0F 48 83 E1 F0 E8 ?? ?? ?? ?? 85 C0 75 49 48 8B 45 A8 48 85 C0 74 50 41 8B 55 00 49 C7 04 24 00 00 00 00 41 89 54 24 08 41 F6 45 08 02 74 50 48 8B 4D 98 8B 11 8B 40 10 41 89 54 24 0C 41 89 44 24 10 48 8D 65 D8 31 C0 5B 41 5C 41 5D 41 5E 41 5F 5D C3 0F 1F 40 00 83 F8 22 75 0B 48 01 DB E9 72 FF FF FF 0F 1F 00 48 8D 65 D8 B8 08 01 00 00 5B 41 5C 41 5D 41 5E 41 5F 5D C3 0F 1F 40 00 41 8B 55 04 EB B0 }
	condition:
		$1
}

rule file_1_7_0 {
	meta:
		name = "gaih_inet"
		size = 9903
		refs = "01bf __idna_to_ascii_lz 0303 __inet_aton 03b9 free 03f5 strchr 0421 inet_pton 0489 strtoul 04e1 __nss_not_use_nscd_hosts 0508 __nss_database_custom 0516 __nss_hosts_database 052c _res_hconf 053b __libc_resp 0546 __res_maybe_init 0634 __nss_lookup_function 065b _dl_mcount_wrapper_check 0859 malloc 094a realloc 0ad9 in6addr_loopback 0bac __idna_to_unicode_lzlz 0f62 __libc_h_errno 1496 __gethostbyname2_r 1574 __nscd_getai 16e5 memcpy 17bf strlen 18ec if_nametoindex 1912 __libc_alloca_cutoff 19b1 __strdup 1d20 __gethostbyaddr_r 2058 __nss_database_lookup 2379 __libc_errno 24c2 mempcpy 2549 __strndup 268c __assert_fail 2691 _res_hconf_init"
	strings:
		$1 = { 55 48 89 E5 41 57 41 56 49 89 F6 41 55 41 54 53 48 89 D3 48 81 EC 08 01 00 00 48 89 BD 48 FF FF FF 48 89 8D 78 FF FF FF 4C 89 85 40 FF FF FF 48 C7 45 90 ?? ?? ?? ?? 48 C7 45 98 00 00 00 00 48 8B 4A 08 48 85 C9 74 68 8B 52 08 BE ?? ?? ?? ?? 85 D2 74 14 39 16 74 10 48 83 C6 14 80 7E 0A 00 75 EE EB 29 0F 1F 40 00 8B 43 0C 85 C0 74 46 F6 46 08 02 75 40 3B 46 04 74 3B 48 83 C6 14 80 7E 0A 00 75 CC 85 D2 B8 08 01 00 00 74 0B B8 07 01 00 00 66 0F 1F 44 00 00 48 8D 65 D8 5B 41 5C 41 5D 41 5E 41 5F 5D C3 66 0F 1F 84 00 00 00 00 00 BE ?? ?? ?? ?? 4D 85 F6 0F 84 02 02 00 00 F6 46 08 01 B8 08 01 00 00 75 CF 41 8B 7E 08 85 FF 0F 88 1E 01 00 00 66 C1 CF 08 0F B7 FF 48 85 C9 0F 85 3B 06 00 00 80 7E 1E 00 48 8D 46 14 0F 84 5E 0C 00 00 48 8D 75 90 45 31 FF EB 0E 0F 1F 40 00 48 83 C0 14 80 78 0A 00 74 46 80 78 09 00 74 F0 48 89 E1 48 83 EC 30 48 8D 54 24 27 48 83 E2 F0 48 29 E1 49 01 CF 8B 08 48 83 C0 14 48 C7 02 00 00 00 00 89 7A 10 89 4A 08 8B 48 F0 80 78 0A 00 89 4A 0C 48 89 16 48 89 D6 75 BF 0F 1F 44 00 00 48 83 BD 48 FF FF FF 00 0F 84 0A 09 00 00 49 89 E4 48 83 EC 40 48 8D 74 24 27 48 83 E6 F0 49 29 E4 8B 0B 48 89 75 98 C7 46 10 00 00 00 00 C7 46 24 00 00 00 00 48 C7 06 00 00 00 00 F6 C1 40 0F 84 C6 05 00 00 89 C8 4C 8D 55 A8 48 8B BD 48 FF FF FF C1 E8 08 48 C7 45 A8 00 00 00 00 83 E0 01 4C 89 D6 89 C2 83 CA 02 80 E5 02 0F 44 D0 E8 ?? ?? ?? ?? 85 C0 89 C2 89 45 88 0F 84 00 01 00 00 3D C9 00 00 00 0F 84 7E 0B 00 00 81 FA CA 00 00 00 B8 0B 00 00 00 BA 69 00 00 00 0F 45 C2 E9 A5 FE FF FF 80 7E 0A 00 0F 85 0E 07 00 00 80 7E 1E 00 4C 8D 66 14 0F 84 8D FE FF FF 4C 8D 45 90 45 31 FF 49 89 DD 4C 89 85 68 FF FF FF 4C 8D 43 0C 4C 89 85 70 FF FF FF EB 27 0F 1F 80 00 00 00 00 41 3B 14 24 74 2C 66 2E 0F 1F 84 00 00 00 00 00 49 83 C4 14 41 80 7C 24 0A 00 0F 84 E6 0A 00 00 41 0F B6 44 24 08 A8 01 75 E6 41 8B 55 08 85 D2 75 CE 41 8B 55 0C 85 D2 74 0E A8 02 75 0A 41 3B 54 24 04 75 CB 0F 1F 00 48 89 E0 48 83 EC 30 48 8D 5C 24 27 48 83 E3 F0 48 29 E0 48 8B 95 70 FF FF FF 49 8B 3E 48 89 D9 4C 89 E6 49 01 C7 E8 7D FC FF FF 85 C0 89 45 88 0F 84 4B 07 00 00 F6 C4 01 75 8D E9 E0 FD FF FF 0F 1F 84 00 00 00 00 00 31 FF E9 15 FE FF FF 66 0F 1F 84 00 00 00 00 00 48 8B 7D A8 48 39 BD 48 FF FF FF 48 8B 75 98 48 89 BD 50 FF FF FF 0F 95 85 3A FF FF FF 48 8B BD 50 FF FF FF 4D 01 FC 48 83 C6 14 4C 89 A5 58 FF FF FF E8 ?? ?? ?? ?? 85 C0 0F 84 C1 00 00 00 F7 43 04 FD FF FF FF 0F 84 C8 05 00 00 48 B8 08 00 00 00 FF FF FF FF 48 23 03 48 BA 08 00 00 00 0A 00 00 00 48 39 D0 0F 84 1C 0D 00 00 B8 09 00 00 00 48 C7 85 28 FF FF FF 00 00 00 00 C6 85 30 FF FF FF 00 48 C7 85 18 FF FF FF 00 00 00 00 C6 85 3B FF FF FF 00 48 C7 85 20 FF FF FF 00 00 00 00 C6 85 3C FF FF FF 00 80 BD 3A FF FF FF 00 0F 85 58 06 00 00 80 BD 3C FF FF FF 00 0F 85 2E 06 00 00 80 BD 3B FF FF FF 00 0F 85 04 06 00 00 80 BD 30 FF FF FF 00 0F 84 ED FC FF FF 48 8B BD 28 FF FF FF 89 85 10 FF FF FF E8 ?? ?? ?? ?? 8B 85 10 FF FF FF E9 D0 FC FF FF 0F 1F 84 00 00 00 00 00 4C 8B 5D 98 45 8B 63 10 45 85 E4 0F 85 94 03 00 00 48 8B BD 50 FF FF FF BE 25 00 00 00 4C 89 9D F0 FE FF FF E8 ?? ?? ?? ?? 48 85 C0 49 89 C4 4C 8B 9D F0 FE FF FF 41 0F 95 C6 0F 85 16 20 00 00 48 8B B5 50 FF FF FF 49 8D 53 14 BF 0A 00 00 00 E8 ?? ?? ?? ?? 85 C0 0F 8E 5C 0C 00 00 8B 43 04 83 F8 0A 74 08 85 C0 0F 85 B9 09 00 00 4C 8B 5D 98 41 C7 43 10 0A 00 00 00 45 84 F6 74 5B 41 8B 43 14 25 FF C0 00 00 3D FE 80 00 00 0F 84 7A 14 00 00 41 80 7B 14 FF 4D 8D 7C 24 01 0F 84 5A 14 00 00 4C 8D 55 A8 BA 0A 00 00 00 4C 89 FF 4C 89 9D F0 FE FF FF 4C 89 D6 E8 ?? ?? ?? ?? 4C 8B 9D F0 FE FF FF 41 89 43 24 48 8B 45 A8 80 38 00 0F 85 BC 06 00 00 4C 8B 5D 98 45 31 FF F6 03 02 41 8B 43 10 74 07 4C 8B BD 50 FF FF FF 85 C0 0F 85 B4 02 00 00 F6 03 04 0F 85 94 06 00 00 83 7B 04 02 48 C7 45 A0 00 00 00 00 0F 84 53 0F 00 00 8B 05 ?? ?? ?? ?? 83 F8 00 0F 8E 23 0F 00 00 83 C0 01 83 F8 64 89 05 ?? ?? ?? ?? 7E 17 C7 05 ?? ?? ?? ?? 00 00 00 00 80 3D ?? ?? ?? ?? 00 0F 84 43 10 00 00 48 8B 05 ?? ?? ?? ?? 48 85 C0 0F 84 24 1B 00 00 48 89 45 A0 45 31 E4 8B 3D ?? ?? ?? ?? 85 FF 0F 84 58 21 00 00 48 8B 15 ?? ?? ?? ?? 31 F6 64 48 8B 3A E8 ?? ?? ?? ?? 48 8B 35 ?? ?? ?? ?? 83 F8 FF B8 01 00 00 00 44 0F 44 E0 64 4C 8B 2E 49 8B 7D 08 49 89 FE 48 89 BD 20 FF FF FF 48 8B BD 58 FF FF FF 49 81 E6 FF DF FF FF 4D 89 75 08 48 81 C7 00 04 00 00 48 81 FF 00 10 00 00 0F 87 FB 1B 00 00 48 89 E2 48 81 EC 10 04 00 00 48 8D 44 24 27 48 83 E0 F0 48 29 E2 48 01 95 58 FF FF FF 48 89 85 28 FF FF FF C6 85 30 FF FF FF 00 45 85 E4 0F 85 FA 1A 00 00 44 0F B6 B5 30 FF FF FF 4C 8D 55 98 48 89 9D 70 FF FF FF 48 8B 7D A0 48 8B 9D 28 FF FF FF 41 BB FF FF FF FF 4C 89 BD 60 FF FF FF 41 BD 00 04 00 00 44 89 9D 3C FF FF FF C7 85 68 FF FF FF 00 00 00 00 48 C7 85 18 FF FF FF 00 00 00 00 4D 89 D7 C6 85 3B FF FF FF 00 C6 85 39 FF FF FF 00 BE ?? ?? ?? ?? 44 89 9D F0 FE FF FF E8 ?? ?? ?? ?? 48 85 C0 49 89 C4 44 8B 9D F0 FE FF FF 0F 84 18 07 00 00 0F 1F 44 00 00 4C 89 E7 C7 45 88 00 00 00 00 E8 ?? ?? ?? ?? 48 C7 04 24 00 00 00 00 4C 8D 4D 8C 4C 8D 45 88 4C 89 E9 48 89 DA 4C 89 FE 48 8B BD 50 FF FF FF 41 FF D4 83 F8 01 0F 84 A9 05 00 00 83 F8 FE 0F 85 5E 05 00 00 83 7D 88 22 0F 85 75 06 00 00 8B 55 8C 83 FA FF 0F 85 85 06 00 00 45 84 F6 0F 85 8D 02 00 00 48 8B BD 58 FF FF FF 4B 8D 4C 2D 00 48 01 CF 48 81 FF 00 10 00 00 0F 87 87 1B 00 00 48 89 E6 48 83 C1 0F 41 B8 10 00 00 00 31 D2 48 83 E1 F0 48 8D 41 1E 49 01 CD 49 F7 F0 48 C1 E0 04 48 29 C4 48 8D 44 24 27 48 83 E0 F0 48 8D 14 08 48 39 D3 4C 0F 45 E9 48 29 E6 48 01 B5 58 FF FF FF 48 89 C3 E9 37 FF FF FF 0F 1F 80 00 00 00 00 49 89 E7 48 83 EC 30 48 8D 44 24 27 48 83 E0 F0 49 29 E7 F6 46 08 02 8B 16 48 89 45 90 48 C7 00 00 00 00 00 89 50 08 0F 85 B6 01 00 00 8B 56 04 89 50 0C 89 78 10 E9 F5 F9 FF FF 48 8B BD 48 FF FF FF C6 85 3A FF FF FF 00 48 89 BD 50 FF FF FF E9 78 FB FF FF 45 31 FF 48 C7 85 28 FF FF FF 00 00 00 00 C6 85 30 FF FF FF 00 48 C7 85 18 FF FF FF 00 00 00 00 C6 85 3B FF FF FF 00 48 C7 85 20 FF FF FF 00 00 00 00 C6 85 3C FF FF FF 00 C6 85 39 FF FF FF 00 48 89 D8 4D 89 DE 4C 89 FB 49 89 C7 4D 39 F3 0F 84 A1 03 00 00 41 8B 56 10 48 C7 85 70 FF FF FF 10 00 00 00 66 83 FA 0A 41 89 D4 0F 84 29 02 00 00 4C 8B 6D 90 4D 85 ED 0F 84 7E 01 00 00 48 8B B5 70 FF FF FF 4C 89 F8 81 E2 FF FF 00 00 4D 89 F7 89 95 60 FF FF FF 49 89 DE 4C 89 EB 45 89 E5 49 89 C4 48 83 C6 30 48 89 B5 68 FF FF FF EB 2C 0F 1F 00 41 8B 4F 14 48 C7 40 38 00 00 00 00 89 48 34 48 8B 1B 48 83 C0 28 45 31 F6 48 89 85 78 FF FF FF 48 85 DB 0F 84 17 01 00 00 48 8B BD 68 FF FF FF E8 ?? ?? ?? ?? 48 8B BD 78 FF FF FF 48 85 C0 48 89 07 0F 84 20 01 00 00 41 8B 34 24 44 8B 85 60 FF FF FF 66 41 83 FD 0A 8B 95 70 FF FF FF 8B 4B 10 89 30 8B 73 08 44 89 40 04 89 70 08 8B 73 0C 89 50 10 4C 89 70 20 66 44 89 68 30 48 C7 40 28 00 00 00 00 89 70 0C 48 8D 70 30 66 89 48 32 48 89 70 18 0F 85 67 FF FF FF C7 40 34 00 00 00 00 49 8B 4F 14 48 89 48 38 49 8B 4F 1C 48 89 48 40 41 8B 4F 24 89 48 48 E9 53 FF FF FF 4C 8B 5D 98 41 C7 43 10 02 00 00 00 45 31 FF F6 03 02 4C 0F 45 BD 50 FF FF FF E9 75 FE FF FF 8B 53 0C E9 45 FE FF FF 49 89 E7 48 83 EC 30 48 8D 4C 24 27 48 83 E1 F0 49 29 E7 49 8B 3E 48 8D 53 0C 48 89 4D 90 E8 F2 F5 FF FF 85 C0 89 45 88 0F 84 17 F8 FF FF E9 5A F7 FF FF 66 90 4D 01 ED 48 89 DF 4C 89 EE E8 ?? ?? ?? ?? 48 85 C0 0F 84 59 04 00 00 48 89 C3 41 BE 01 00 00 00 E9 EB FC FF FF 0F 1F 00 4C 89 F3 4D 89 FE 4D 89 E7 48 8B B5 40 FF FF FF 83 06 01 4D 8B 36 4D 85 F6 0F 84 6F 15 00 00 4C 8B 5D 98 E9 31 FE FF FF 4C 89 F7 E8 ?? ?? ?? ?? B8 0A 00 00 00 E9 D5 F9 FF FF 48 8B BD 18 FF FF FF 89 85 10 FF FF FF E8 ?? ?? ?? ?? 8B 85 10 FF FF FF E9 DF F9 FF FF 48 8B BD 20 FF FF FF 89 85 10 FF FF FF E8 ?? ?? ?? ?? 8B 85 10 FF FF FF E9 B5 F9 FF FF 48 8B BD 50 FF FF FF 89 85 10 FF FF FF E8 ?? ?? ?? ?? 8B 85 10 FF FF FF E9 8B F9 FF FF 4C 8B 85 68 FF FF FF 48 89 9D 68 FF FF FF 49 89 18 E9 31 F8 FF FF 80 BD 39 FF FF FF 00 0F 84 C6 01 00 00 41 8B 07 48 C7 85 70 FF FF FF 1C 00 00 00 83 E0 18 83 F8 08 0F 85 B0 FD FF FF 41 8B 4E 14 85 C9 0F 85 A4 FD FF FF 41 8B 46 18 85 C0 0F 85 98 FD FF FF 41 81 7E 1C 00 00 FF FF 0F 85 8A FD FF FF E9 1A FF FF FF 0F 1F 80 00 00 00 00 48 89 E2 48 83 EC 40 48 8D 44 24 27 48 83 E0 F0 49 89 C3 48 29 E2 4C 01 FA 48 89 45 98 48 89 95 58 FF FF FF 48 C7 00 00 00 00 00 48 C7 40 08 00 00 00 00 48 C7 40 10 00 00 00 00 48 C7 40 18 00 00 00 00 48 C7 40 20 00 00 00 00 8B 53 04 85 D2 0F 84 5B 05 00 00 83 FA 0A 74 07 85 D2 48 89 C1 75 28 F6 03 01 C7 40 10 0A 00 00 00 75 19 48 8B 15 ?? ?? ?? ?? 48 89 50 14 48 8B 15 ?? ?? ?? ?? 48 89 50 1C 8B 53 04 48 8B 08 83 E2 FD 75 13 F6 03 01 C7 41 10 02 00 00 00 75 07 C7 41 14 7F 00 00 01 48 C7 85 50 FF FF FF 00 00 00 00 48 C7 85 28 FF FF FF 00 00 00 00 45 31 FF C6 85 30 FF FF FF 00 48 C7 85 18 FF FF FF 00 00 00 00 C6 85 3B FF FF FF 00 48 C7 85 20 FF FF FF 00 00 00 00 C6 85 3C FF FF FF 00 C6 85 3A FF FF FF 00 C6 85 39 FF FF FF 00 E9 54 FC FF FF B8 02 01 00 00 E9 D6 F7 FF FF 41 8B 07 A8 02 0F 84 54 FC FF FF 45 31 E4 48 85 DB C6 85 70 FF FF FF 00 0F 84 D3 10 00 00 A8 80 0F 84 08 05 00 00 89 C2 48 89 DF C1 EA 08 83 E2 01 89 D6 83 CE 02 F6 C4 02 0F 45 D6 48 8D 75 A8 E8 ?? ?? ?? ?? 85 C0 0F 85 ED 19 00 00 48 8B 45 A8 48 39 D8 0F 84 D4 04 00 00 48 89 C3 80 BD 70 FF FF FF 00 0F 84 F5 FB FF FF 4C 89 E7 E8 ?? ?? ?? ?? E9 E8 FB FF FF 48 C7 85 70 FF FF FF 1C 00 00 00 E9 F4 FB FF FF 41 89 C3 8B 45 8C 41 8D 53 02 45 31 D2 83 F8 04 41 0F 94 C2 44 89 95 68 FF FF FF 48 8B 45 A0 48 63 D2 83 7C 90 08 01 0F 84 45 14 00 00 48 8B 38 48 85 FF 0F 84 65 03 00 00 48 89 7D A0 E9 F3 F9 FF FF 48 8B 95 70 FF FF FF 41 89 C3 49 8B 07 F6 02 02 74 0E 48 83 BD 60 FF FF FF 00 0F 84 E3 13 00 00 41 BA 01 00 00 00 48 BF 08 00 00 00 FF FF FF FF 48 BE 08 00 00 00 0A 00 00 00 66 90 48 85 C0 74 26 8B 50 10 83 FA 02 74 36 4C 8B 85 70 FF FF FF 41 8B 48 04 85 C9 74 1C 39 CA 74 65 48 8B 00 48 85 C0 49 89 07 75 DA BA 03 00 00 00 E9 61 FF FF FF 0F 1F 00 49 89 C7 45 31 D2 48 8B 00 EB BD 4C 8B 85 70 FF FF FF 48 89 F9 49 23 08 48 39 F1 75 B8 8B 50 14 C7 40 10 0A 00 00 00 49 89 C7 C7 40 1C 00 00 FF FF C7 40 18 00 00 00 00 45 31 D2 C7 40 14 00 00 00 00 89 50 20 48 8B 00 E9 7B FF FF FF 45 31 D2 83 FA 0A 49 89 C7 48 8B 00 0F 85 69 FF FF FF C6 85 39 FF FF FF 01 E9 5D FF FF FF 41 89 C3 8B 45 8C 31 D2 83 F8 02 41 BA FD FF FF FF 0F 85 D2 FE FF FF E9 D7 FE FF FF 41 89 C3 89 D0 EB E3 48 81 7D 90 ?? ?? ?? ?? 4C 89 EB 0F 85 09 F4 FF FF B8 08 01 00 00 E9 47 F3 FF FF 45 31 FF E9 F7 F3 FF FF B8 0A 00 00 00 E9 35 F3 FF FF 48 8B 95 70 FF FF FF F6 02 02 0F 85 D5 00 00 00 48 8B 7D A0 BE ?? ?? ?? ?? 44 89 9D F0 FE FF FF E8 ?? ?? ?? ?? 48 85 C0 49 89 C4 44 8B 9D F0 FE FF FF 0F 85 D5 00 00 00 BA 01 00 00 00 41 BB FF FF FF FF 45 31 D2 E9 5F FE FF FF 66 90 48 8B 15 ?? ?? ?? ?? 44 88 B5 30 FF FF FF 48 89 9D 28 FF FF FF 64 48 8B 02 48 8B 95 20 FF FF FF 81 E2 00 20 00 00 48 09 50 08 B8 0A 00 00 00 48 C7 85 20 FF FF FF 00 00 00 00 C6 85 3C FF FF FF 00 E9 81 F5 FF FF 83 F8 02 0F 85 3D F5 FF FF 4C 8B 5D 98 45 8B 53 14 45 85 D2 0F 85 2C F5 FF FF 45 8B 4B 18 45 85 C9 0F 85 1F F5 FF FF 41 81 7B 1C 00 00 FF FF B0 09 0F 85 14 F5 FF FF 41 8B 43 20 41 C7 43 10 02 00 00 00 41 89 43 14 E9 07 F6 FF FF 66 0F 1F 44 00 00 48 8B 7D A0 BE ?? ?? ?? ?? 44 89 9D F0 FE FF FF E8 ?? ?? ?? ?? 48 85 C0 49 89 C4 44 8B 9D F0 FE FF FF 0F 84 03 FF FF FF 48 8B 95 70 FF FF FF 8B 42 04 85 C0 74 09 83 F8 0A 0F 85 2B 02 00 00 44 88 B5 68 FF FF FF 48 C7 45 A8 00 00 00 00 4C 8B B5 50 FF FF FF EB 44 90 83 7D 8C FF 0F 85 F3 09 00 00 4B 8D 4C 2D 0F 31 D2 41 B8 10 00 00 00 48 83 E1 F0 48 8D 41 1E 49 01 CD 49 F7 F0 48 C1 E0 04 48 29 C4 48 8D 44 24 27 48 83 E0 F0 48 8D 14 08 48 39 D3 48 89 C3 4C 0F 45 E9 4C 89 E7 C7 45 88 00 00 00 00 E8 ?? ?? ?? ?? 48 8D 75 A8 48 8D 7D 8C 48 8D 55 B0 48 C7 44 24 08 00 00 00 00 4C 8D 4D 88 4D 89 E8 48 89 74 24 10 48 89 3C 24 48 89 D9 BE 0A 00 00 00 4C 89 F7 41 FF D4 8B 55 88 83 FA 22 0F 84 6F FF FF FF 83 F8 01 44 0F B6 B5 68 FF FF FF 41 89 C0 41 89 C3 0F 84 B5 0F 00 00 45 31 D2 85 D2 0F 84 A1 04 00 00 8B 45 8C 83 F8 FF 0F 85 3B 17 00 00 48 8B 15 ?? ?? ?? ?? 64 89 02 48 8B 15 ?? ?? ?? ?? 64 48 8B 02 48 8B 95 20 FF FF FF 81 E2 00 20 00 00 48 09 50 08 B8 0B 00 00 00 E9 09 F1 FF FF 90 48 8B 05 ?? ?? ?? ?? 48 89 9D 28 FF FF FF 4C 8B BD 60 FF FF FF 48 8B 9D 70 FF FF FF 44 88 B5 30 FF FF FF 64 4C 8B 28 8B B5 68 FF FF FF 45 85 D2 4D 8B 75 08 0F 95 C0 85 F6 0F 95 C2 21 D0 48 8B 95 20 FF FF FF 81 E2 00 20 00 00 4C 09 F2 84 C0 49 89 55 08 0F 84 72 0D 00 00 83 BD 68 FF FF FF FD 75 0A 41 83 FA FD 0F 84 AA 10 00 00 B8 05 01 }
	condition:
		$1
}

rule file_1_8_0 {
	meta:
		name = "get_scope"
		size = 184
	strings:
		$1 = { 0F B7 17 66 83 FA 0A 74 4F 66 83 FA 02 B8 0F 00 00 00 74 0C F3 C3 66 2E 0F 1F 84 00 00 00 00 00 48 8B 15 ?? ?? ?? ?? 8B 77 04 8B 4A 04 48 8D 42 0C 21 F1 3B 0A 74 1A 66 0F 1F 84 00 00 00 00 00 48 89 C2 48 83 C0 0C 8B 4A 04 21 F1 3B 48 F4 75 EF 8B 42 08 C3 0F 1F 00 80 7F 08 FF 74 52 8B 57 08 B8 02 00 00 00 89 D1 81 E1 FF C0 00 00 81 F9 FE 80 00 00 74 9E 85 D2 75 1E 8B 77 0C 85 F6 75 17 8B 57 10 85 D2 75 10 81 7F 14 00 00 00 01 75 07 F3 C3 0F 1F 44 00 00 31 C0 81 F9 FE C0 00 00 0F 95 C0 8D 44 C0 05 C3 0F 1F 84 00 00 00 00 00 0F B6 47 09 83 E0 0F C3 }
	condition:
		$1
}

rule file_1_9_0 {
	meta:
		name = "rfc3484_sort"
		size = 1476
		refs = "0213 __check_native 0544 __assert_fail"
	strings:
		$1 = { 48 89 5C 24 D0 48 89 6C 24 D8 4C 89 64 24 E0 4C 89 74 24 F0 49 89 D6 4C 89 7C 24 F8 4C 89 6C 24 E8 48 83 EC 68 4C 8B 3F 4C 8B 26 48 8B 1A 4F 8D 04 7F 4B 8D 04 64 49 C1 E0 04 48 C1 E0 04 4A 8D 2C 03 48 01 C3 80 7D 25 00 0F 84 E9 00 00 00 80 7B 25 00 0F 84 CF 02 00 00 48 8B 45 00 4C 8D 6D 08 48 8B 48 18 48 89 CF 48 89 0C 24 E8 CF FE FF FF 89 44 24 0C 48 8B 03 48 8B 78 18 E8 BF FE FF FF 4C 89 EF 89 44 24 08 E8 B3 FE FF FF 89 44 24 18 48 8D 43 08 48 89 C7 48 89 44 24 10 E8 9E FE FF FF 39 44 24 08 48 8B 0C 24 0F 85 65 02 00 00 39 44 24 08 0F 84 46 02 00 00 0F B6 45 26 0F B6 53 26 A8 01 0F 85 26 02 00 00 F6 C2 01 0F 85 55 02 00 00 A8 02 0F 84 5D 02 00 00 83 E2 02 66 90 0F 84 42 02 00 00 48 89 CF E8 A2 D6 FF FF 4C 89 EF 89 44 24 18 E8 96 D6 FF FF 89 44 24 1C 48 8B 03 48 8B 78 18 E8 86 D6 FF FF 48 8B 7C 24 10 41 89 C5 E8 79 D6 FF FF 41 39 C5 0F 85 A5 02 00 00 41 39 C5 0F 84 27 02 00 00 48 8B 45 00 4C 8B 68 18 EB 33 0F 1F 44 00 00 80 7B 25 00 0F 85 3E 01 00 00 48 8B 45 00 4C 8B 68 18 4C 89 EF E8 EE FD FF FF 89 44 24 0C 48 8B 03 48 8B 78 18 E8 DE FD FF FF 89 44 24 08 48 8B 0D ?? ?? ?? ?? 31 D2 4C 89 EF 48 89 CE 48 89 0C 24 E8 52 D5 FF FF 41 89 C5 48 8B 03 48 8B 0C 24 31 D2 48 8B 78 18 48 89 CE E8 3A D5 FF FF 41 39 C5 0F 8F 89 01 00 00 0F 8C DB 00 00 00 80 7D 25 00 0F 84 09 01 00 00 44 8B 6D 28 44 8B 43 28 45 39 C5 0F 84 F8 00 00 00 8B 75 2C 8B 7B 2C 83 FE FF 89 74 24 28 89 7C 24 2C 0F 94 C0 83 FF FF 0F 94 C2 0F 84 88 01 00 00 84 C0 0F 84 88 00 00 00 C7 44 24 28 00 00 00 00 84 D2 0F 85 C0 01 00 00 41 B8 FF FF FF FF 48 8D 74 24 28 48 8D 4C 24 2C 44 89 C2 44 89 EF 44 89 04 24 E8 ?? ?? ?? ?? 41 8B 46 08 8B 74 24 28 8B 7C 24 2C 44 8B 04 24 85 C0 7E 45 83 E8 01 49 8B 0E 48 8D 04 40 48 C1 E0 04 48 8D 54 01 30 EB 12 41 39 C0 0F 84 57 01 00 00 48 83 C1 30 48 39 D1 74 1E 8B 41 28 44 39 E8 75 E6 8B 41 2C 83 F8 FF 74 08 39 F0 0F 85 DE 02 00 00 89 71 2C EB DA 90 85 F6 75 3C 85 FF 74 40 0F 1F 84 00 00 00 00 00 B8 01 00 00 00 48 8B 5C 24 38 48 8B 6C 24 40 4C 8B 64 24 48 4C 8B 6C 24 50 4C 8B 74 24 58 4C 8B 7C 24 60 48 83 C4 68 C3 0F 1F 84 00 00 00 00 00 85 FF 74 74 0F 1F 40 00 8B 44 24 0C 39 44 24 08 7F 66 7C BC 80 7D 25 00 74 13 48 8B 7D 00 48 8B 33 8B 47 04 3B 46 04 0F 84 9E 00 00 00 4D 39 E7 19 C0 83 C8 01 EB 9E 66 0F 1F 84 00 00 00 00 00 F6 C2 01 0F 85 DA FD FF FF EB 85 0F 1F 44 00 00 8B 44 24 18 39 44 24 0C 0F 84 AC FD FF FF 66 90 E9 6B FF FF FF 8B 54 24 18 39 54 24 0C 0F 85 8D FD FF FF 0F 1F 44 00 00 B8 FF FF FF FF E9 53 FF FF FF 66 0F 1F 44 00 00 83 E2 02 0F 84 A5 FD FF FF E9 3A FF FF FF 66 2E 0F 1F 84 00 00 00 00 00 8B 44 24 1C 39 44 24 18 0F 84 CB FD FF FF 66 90 E9 1B FF FF FF 0F 1F 00 84 C0 0F 85 78 FE FF FF 41 BD FF FF FF FF E9 75 FE FF FF 83 F8 02 74 60 31 C9 31 D2 83 F8 0A 0F 84 FF 00 00 00 39 D1 B8 01 00 00 00 0F 8E 43 FF FF FF E9 E6 FE FF FF 90 8B 41 2C 83 F8 FF 74 08 39 F8 0F 85 7F 01 00 00 89 79 2C E9 91 FE FF FF C7 44 24 2C 00 00 00 00 E9 39 FE FF FF 8B 54 24 1C 39 54 24 18 0F 85 4D FD FF FF E9 50 FF FF FF 0F 1F 84 00 00 00 00 00 66 83 7D 08 02 0F 85 C0 01 00 00 66 83 7B 08 02 0F 85 9C 01 00 00 48 8B 47 18 8B 7D 0C B9 20 00 00 00 31 D2 8B 40 04 0F CF 0F C8 31 C7 0F B6 45 27 29 C1 B8 FF FF FF FF D3 E0 85 C7 75 18 B8 00 00 00 80 EB 0D 0F 1F 00 83 C2 01 D1 E8 83 FA 20 74 04 85 F8 74 F2 48 8B 46 18 8B 73 0C B9 20 00 00 00 8B 40 04 0F CE 0F C8 31 C6 0F B6 43 27 29 C1 B8 FF FF FF FF D3 E0 31 C9 85 C6 75 1C B8 00 00 00 80 EB 11 0F 1F 00 83 C1 01 D1 E8 83 F9 20 0F 84 17 FF FF FF 85 F0 74 EE 39 CA B8 FF FF FF FF 0F 8E 06 FF FF FF E9 F9 FD FF FF 66 83 7D 08 0A 0F 85 E3 00 00 00 66 83 7B 08 0A 0F 85 BF 00 00 00 4C 8B 5F 18 48 8B 7E 18 4C 8D 6D 08 31 C0 41 8B 4C 83 08 41 8B 54 85 08 89 C6 39 D1 75 1F 8B 54 83 10 39 54 87 08 75 13 48 83 C0 01 48 83 F8 04 75 DC 31 C9 31 D2 E9 B0 FE FF FF 89 CA 31 D1 B8 00 00 00 80 31 D2 0F C9 EB 0E 0F 1F 40 00 83 C2 01 D1 E8 83 FA 20 74 04 85 C8 74 F2 48 63 C6 31 C9 8B 74 83 10 33 74 87 08 B8 00 00 00 80 0F CE EB 12 0F 1F 40 00 83 C1 01 D1 E8 83 F9 20 0F 84 67 FE FF FF 85 F0 74 EE E9 4B FF FF FF B9 ?? ?? ?? ?? BA BF 06 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? B9 ?? ?? ?? ?? BA B9 06 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? B9 ?? ?? ?? ?? BA FC 06 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? B9 ?? ?? ?? ?? 66 BA FB 06 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? B9 ?? ?? ?? ?? BA DD 06 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? B9 ?? ?? ?? ?? BA DC 06 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1_10_0 {
	meta:
		name = "gaiconf_init"
		size = 2936
		refs = "004a _IO_new_fopen 005e fileno 0072 __fxstat64 00ce __getline 00e9 strchr 00fd __libc_tsd_CTYPE_B 0231 free 023e _IO_new_fclose 0289 malloc 0327 qsort 0425 __libc_errno 045a inet_pton 0485 strtoul"
	strings:
		$1 = { 41 57 BE ?? ?? ?? ?? BF ?? ?? ?? ?? 41 56 41 55 41 54 55 53 48 81 EC 28 01 00 00 48 C7 44 24 38 00 00 00 00 48 C7 44 24 40 00 00 00 00 C6 44 24 36 00 48 C7 44 24 48 00 00 00 00 48 C7 44 24 50 00 00 00 00 C6 44 24 37 00 E8 ?? ?? ?? ?? 48 85 C0 0F 84 06 0A 00 00 48 89 C7 48 89 C5 E8 ?? ?? ?? ?? 48 8D 94 24 90 00 00 00 89 C6 BF 01 00 00 00 E8 ?? ?? ?? ?? 85 C0 0F 85 12 09 00 00 8B 45 00 48 8D 94 24 8C 00 00 00 31 DB 48 C7 44 24 58 00 00 00 00 48 C7 44 24 60 00 00 00 00 C6 44 24 27 00 48 C7 44 24 18 00 00 00 00 80 CC 80 48 89 54 24 28 A8 10 89 45 00 0F 85 6D 01 00 00 66 90 48 8D 74 24 60 48 8D 7C 24 58 48 89 EA E8 ?? ?? ?? ?? 48 85 C0 0F 8E 50 01 00 00 4C 8B 64 24 58 BE 23 00 00 00 4C 89 E7 E8 ?? ?? ?? ?? 48 85 C0 74 08 C6 00 00 4C 8B 64 24 58 48 8B 35 ?? ?? ?? ?? 41 0F B6 14 24 64 48 8B 06 48 0F BE CA F6 44 48 01 20 74 17 0F 1F 00 49 83 C4 01 41 0F B6 14 24 48 0F BE CA F6 44 48 01 20 75 EC 84 D2 4D 89 E6 75 18 E9 2F 06 00 00 0F 1F 84 00 00 00 00 00 F6 44 50 01 20 0F 85 65 02 00 00 49 83 C6 01 49 0F BE 16 84 D2 75 E9 0F B7 08 4C 89 F7 4C 29 E7 66 81 E1 00 20 31 D2 66 85 C9 74 17 0F 1F 40 00 49 83 C6 01 41 0F B6 16 48 0F BE CA F6 44 48 01 20 75 ED 84 D2 0F 84 D4 05 00 00 48 0F BE CA 4D 89 F7 F6 44 48 01 20 74 12 EB 1C 0F 1F 44 00 00 48 0F BE CA F6 44 48 01 20 75 0C 49 83 C7 01 41 0F B6 17 84 D2 75 E9 4D 39 FC 74 64 84 D2 74 14 41 C6 07 00 49 83 C7 01 64 48 8B 06 EB 06 66 90 49 83 C7 01 41 0F B6 17 48 0F BE CA F6 44 48 01 20 75 ED 84 D2 4C 89 FA 75 12 EB 17 0F 1F 40 00 48 83 C2 01 48 0F BE 0A 84 C9 74 07 F6 44 48 01 20 74 ED 48 83 FF 06 C6 02 00 0F 84 B0 04 00 00 0F 87 CA 01 00 00 48 83 FF 05 0F 84 0C 05 00 00 8B 45 00 A8 10 0F 84 95 FE FF FF 48 8B 7C 24 58 E8 ?? ?? ?? ?? 48 89 EF BD ?? ?? ?? ?? E8 ?? ?? ?? ?? 4C 8B 64 24 40 4D 85 E4 0F 85 20 05 00 00 4C 8B 6C 24 50 4D 85 ED 0F 85 CA 05 00 00 48 83 7C 24 18 00 41 BC ?? ?? ?? ?? 0F 84 6E 06 00 00 80 7C 24 27 01 48 83 54 24 18 00 48 8B 44 24 18 48 8D 3C 40 48 C1 E7 02 E8 ?? ?? ?? ?? 48 85 C0 49 89 C5 0F 84 DD 07 00 00 80 7C 24 27 00 8B 44 24 18 0F 84 2A 07 00 00 85 C0 8D 50 FF 7E 44 89 D0 48 89 C1 48 F7 D9 48 8D 04 88 48 8D 3C 85 F4 FF FF FF 48 63 C2 48 89 DA 48 8D 04 40 49 8D 4C 85 00 31 C0 0F 1F 40 00 48 8B 32 48 89 34 01 8B 72 08 89 74 01 08 48 83 E8 0C 48 8B 52 10 48 39 F8 75 E5 48 85 DB 74 1C 0F 1F 84 00 00 00 00 00 4C 8B 73 10 48 89 DF E8 ?? ?? ?? ?? 4D 85 F6 4C 89 F3 75 EC 48 8B 74 24 18 B9 ?? ?? ?? ?? BA 0C 00 00 00 4C 89 EF E8 ?? ?? ?? ?? 48 8B 3D ?? ?? ?? ?? 48 89 2D ?? ?? ?? ?? 48 81 FF ?? ?? ?? ?? 74 05 E8 ?? ?? ?? ?? 48 8B 3D ?? ?? ?? ?? 4C 89 25 ?? ?? ?? ?? 48 81 FF ?? ?? ?? ?? 74 05 E8 ?? ?? ?? ?? 48 8B 3D ?? ?? ?? ?? 4C 89 2D ?? ?? ?? ?? 48 81 FF ?? ?? ?? ?? 74 05 E8 ?? ?? ?? ?? 48 8B 84 24 E8 00 00 00 48 89 05 ?? ?? ?? ?? 48 8B 84 24 F0 00 00 00 48 89 05 ?? ?? ?? ?? 48 81 C4 28 01 00 00 5B 5D 41 5C 41 5D 41 5E 41 5F C3 90 41 0F B6 56 01 41 C6 06 00 4C 89 F7 64 48 8B 06 4C 29 E7 49 83 C6 01 48 0F BE CA 0F B7 0C 48 66 81 E1 00 20 E9 8E FD FF FF 0F 1F 80 00 00 00 00 48 83 FF 07 0F 84 66 01 00 00 48 83 FF 0A 0F 85 2C FE FF FF BF ?? ?? ?? ?? B9 0B 00 00 00 4C 89 E6 F3 A6 0F 85 17 FE FF FF 48 8D 44 24 37 48 8D 54 24 50 4C 8D 64 24 48 48 89 44 24 10 48 89 54 24 08 48 8B 05 ?? ?? ?? ?? BE 2F 00 00 00 4C 89 F7 64 C7 00 00 00 00 00 E8 ?? ?? ?? ?? 48 85 C0 49 89 C5 0F 84 BA 06 00 00 48 8D 54 24 70 C6 00 00 4C 89 F6 BF 0A 00 00 00 E8 ?? ?? ?? ?? 85 C0 0F 84 BA FD FF FF 4C 89 EF 48 83 C7 01 0F 84 AA 06 00 00 4C 8D 44 24 68 BA 0A 00 00 00 4C 89 C6 4C 89 04 24 E8 ?? ?? ?? ?? 48 83 F8 FF 48 89 C1 4C 8B 04 24 0F 84 86 FD FF FF 48 8B 44 24 68 80 38 00 0F 85 78 FD FF FF 48 81 F9 80 00 00 00 0F 87 6B FD FF FF BA 0A 00 00 00 4C 89 C6 4C 89 FF 48 89 0C 24 E8 ?? ?? ?? ?? 48 83 F8 FF 49 89 C6 0F 84 4A FD FF FF 48 8B 44 24 68 80 38 00 0F 85 3C FD FF FF 49 81 FE FF FF FF 7F 0F 87 2F FD FF FF BF 20 00 00 00 E8 ?? ?? ?? ?? 48 85 C0 48 8B 0C 24 0F 84 59 06 00 00 48 8B 54 24 70 89 48 10 44 89 70 14 48 89 10 48 8B 54 24 78 48 89 50 08 49 8B 14 24 49 89 04 24 48 89 50 18 48 8B 44 24 08 48 8B 54 24 10 48 83 00 01 48 85 C9 0F 94 C0 08 02 E9 D9 FC FF FF 66 0F 1F 84 00 00 00 00 00 BF ?? ?? ?? ?? B9 08 00 00 00 4C 89 E6 F3 A6 0F 85 BB FC FF FF 4C 8B 25 ?? ?? ?? ?? BE 2F 00 00 00 4C 89 F7 64 41 C7 04 24 00 00 00 00 E8 ?? ?? ?? ?? 48 85 C0 49 89 C5 74 07 C6 00 00 49 83 C5 01 48 8D 94 24 80 00 00 00 4C 89 F6 BF 0A 00 00 00 E8 ?? ?? ?? ?? 85 C0 0F 84 3B 03 00 00 44 8B 84 24 80 00 00 00 45 85 C0 0F 85 61 FC FF FF 8B BC 24 84 00 00 00 85 FF 0F 85 52 FC FF FF 81 BC 24 88 00 00 00 00 00 FF FF 0F 85 41 FC FF FF 4D 85 ED 0F 84 10 05 00 00 4C 8D 44 24 68 4C 89 EF BA 0A 00 00 00 4C 89 C6 E8 ?? ?? ?? ?? 48 83 F8 FF 49 89 C5 0F 84 C7 04 00 00 48 8B 44 24 68 80 38 00 0F 85 08 FC FF FF 49 8D 45 A0 48 83 F8 20 0F 87 FA FB FF FF 4C 8D 44 24 68 BA 0A 00 00 00 4C 89 FF 4C 89 C6 E8 ?? ?? ?? ?? 48 83 F8 FF 49 89 C4 0F 84 D8 FB FF FF 48 8B 44 24 68 80 38 00 0F 85 CA FB FF FF 49 81 FC FF FF FF 7F 0F 87 BD FB FF FF BF 18 00 00 00 E8 ?? ?? ?? ?? 48 85 C0 0F 84 EB 04 00 00 49 83 FD 60 0F 84 D8 04 00 00 B9 80 00 00 00 BA FF FF FF FF 44 29 E9 D3 E2 8B 8C 24 8C 00 00 00 0F CA 21 D1 48 83 44 24 18 01 49 83 FD 60 89 50 04 48 89 58 10 0F 94 C2 89 08 44 89 60 08 08 54 24 27 48 89 C3 E9 60 FB FF FF BF ?? ?? ?? ?? B9 07 00 00 00 4C 89 E6 F3 A6 0F 85 4B FB FF FF 41 0F B6 06 83 E8 79 75 3B 41 0F B6 46 01 83 E8 65 75 31 41 0F B6 46 02 83 E8 73 75 27 31 C0 41 80 7E 03 00 0F 94 C0 85 C0 89 05 ?? ?? ?? ?? 0F 84 16 FB FF FF C7 05 ?? ?? ?? ?? 01 00 00 00 E9 07 FB FF FF 85 C0 0F 94 C0 0F B6 C0 89 05 ?? ?? ?? ?? E9 F4 FA FF FF BF ?? ?? ?? ?? B9 06 00 00 00 4C 89 E6 F3 A6 0F 85 DF FA FF FF 48 8D 44 24 36 48 8D 54 24 40 4C 8D 64 24 38 48 89 44 24 10 48 89 54 24 08 E9 C3 FC FF FF 4D 89 F7 E9 50 FA FF FF 31 C9 31 FF E9 F5 F9 FF FF 44 0F B6 6C 24 36 45 84 ED 0F 84 37 02 00 00 4B 8D 3C 64 48 C1 E7 03 E8 ?? ?? ?? ?? 48 85 C0 48 89 C5 0F 84 00 03 00 00 45 84 ED 0F 84 59 02 00 00 45 85 E4 48 8B 7C 24 38 41 8D 44 24 FF 7E 4E 89 C2 48 98 48 89 D1 48 8D 04 40 48 F7 D9 48 8D 14 8A 48 8D 4C C5 00 48 89 F8 4C 8D 04 D5 E8 FF FF FF 31 D2 0F 1F 40 00 48 8B 30 48 89 34 11 48 8B 70 08 48 89 74 11 08 48 8B 70 10 48 89 74 11 10 48 83 EA 18 48 8B 40 18 4C 39 C2 75 DA E8 AD C8 FF FF 48 8B 74 24 40 B9 ?? ?? ?? ?? BA 18 00 00 00 48 89 EF E8 ?? ?? ?? ?? 4C 8B 6C 24 50 4D 85 ED 0F 84 36 FA FF FF 44 0F B6 74 24 37 45 84 F6 0F 84 8D 01 00 00 4B 8D 7C 6D 00 48 C1 E7 03 E8 ?? ?? ?? ?? 48 85 C0 49 89 C4 0F 84 94 02 00 00 45 84 F6 0F 84 D2 01 00 00 45 85 ED 48 8B 7C 24 48 41 8D 45 FF 7E 4E 89 C2 48 98 48 89 D1 48 8D 04 40 48 F7 D9 48 8D 14 8A 49 8D 0C C4 48 89 F8 4C 8D 04 D5 E8 FF FF FF 31 D2 0F 1F 44 00 00 48 8B 30 48 89 34 11 48 8B 70 08 48 89 74 11 08 48 8B 70 10 48 89 74 11 10 48 83 EA 18 48 8B 40 18 4C 39 C2 75 DA E8 F5 C7 FF FF 48 8B 74 24 50 B9 ?? ?? ?? ?? BA 18 00 00 00 4C 89 E7 E8 ?? ?? ?? ?? 48 83 7C 24 18 00 0F 85 92 F9 FF FF 41 BD ?? ?? ?? ?? E9 42 FA FF FF 48 8B 54 24 28 4C 89 F6 BF 02 00 00 00 E8 ?? ?? ?? ?? 85 C0 0F 84 1D F9 FF FF 4D 85 ED 0F 84 2E 02 00 00 4C 8D 44 24 68 4C 89 EF BA 0A 00 00 00 4C 89 C6 4C 89 04 24 E8 ?? ?? ?? ?? 48 83 F8 FF 49 89 C5 4C 8B 04 24 0F 84 EA F8 FF FF 48 8B 44 24 68 80 38 00 0F 85 DC F8 FF FF 49 83 FD 20 0F 87 D2 F8 FF FF BA 0A 00 00 00 4C 89 C6 4C 89 FF E8 ?? ?? ?? ?? 48 83 F8 FF 49 89 C4 0F 84 B5 F8 FF FF 48 8B 44 24 68 80 38 00 0F 85 A7 F8 FF FF 49 83 C5 60 49 81 FC FF FF FF 7F 0F 86 D9 FC FF FF E9 91 F8 FF FF 90 48 89 EF E8 ?? ?? ?? ?? 48 8B 7C 24 38 E8 0E C7 FF FF 48 8B 7C 24 48 E8 04 C7 FF FF E8 ?? ?? ?? ?? E9 E7 F9 FF FF 49 83 C4 01 4C 89 64 24 40 E9 BB FD FF FF 49 83 C5 01 4C 89 6C 24 50 E9 65 FE FF FF 83 E8 01 48 63 D0 48 8D 14 52 49 8D 54 95 00 C7 02 00 00 00 00 C7 42 04 00 00 00 00 C7 42 08 0E 00 00 00 E9 AE F8 FF FF 41 83 EC 01 49 63 C4 48 8D 04 40 48 8D 44 C5 00 48 C7 00 00 00 00 00 48 C7 40 08 00 00 00 00 C7 40 10 00 00 00 00 C7 40 14 01 00 00 00 E9 75 FD FF FF 41 83 ED 01 49 63 C5 48 8D 04 40 49 8D 04 C4 48 C7 00 00 00 00 00 48 C7 40 08 00 00 00 00 C7 40 10 00 00 00 00 C7 40 14 28 00 00 00 E9 FD FD FF FF 48 8B 7C 24 38 E8 49 C6 FF FF 48 8B 7C 24 48 E8 3F C6 FF FF E9 36 FF FF FF 48 81 FD ?? ?? ?? ?? 74 08 48 89 EF E8 ?? ?? ?? ?? 49 81 FC ?? ?? ?? ?? 74 08 4C 89 E7 E8 ?? ?? ?? ?? 48 8B 7C 24 38 E8 0E C6 FF FF 48 8B 7C 24 48 E8 04 C6 FF FF 48 85 DB 0F 84 F7 FE FF FF 0F 1F 00 48 8B 6B 10 48 89 DF E8 ?? ?? ?? ?? 48 85 ED 48 89 EB 75 EC E9 DB FE FF FF 64 41 83 3C 24 22 0F 85 2D FB FF FF 0F 1F 00 E9 3B F7 FF FF 48 81 FD ?? ?? ?? ?? 74 AA 48 89 EF E8 ?? ?? ?? ?? EB A0 41 BD 80 00 00 00 E9 07 FB FF FF 48 8D 54 24 70 4C 89 F6 BF 0A 00 00 00 E8 ?? ?? ?? ?? 85 C0 0F 84 03 F7 FF FF 48 8B 44 24 68 80 38 00 0F 85 F5 F6 FF FF B9 80 00 00 00 4C 8D 44 24 68 E9 7B F9 FF FF 48 8B 44 24 68 80 38 00 0F 85 D8 F6 FF FF 41 BD 20 00 00 00 4C 8D 44 24 68 E9 F6 FD FF FF 31 D2 31 C9 E9 39 FB FF FF 48 8B 7C 24 58 E8 ?? ?? ?? ?? 48 89 EF E8 ?? ?? ?? ?? E9 20 FF FF FF }
	condition:
		$1
}

rule file_1_11_0 {
	meta:
		name = "_L_lock_12387"
		size = 31
		refs = "000f __lll_lock_wait_private"
	strings:
		$1 = { 48 8D 3D ?? ?? ?? ?? 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 41 FF FF FF }
	condition:
		$1
}

rule file_1_12_0 {
	meta:
		name = "_L_unlock_12412"
		size = 31
		refs = "000f __lll_unlock_wake_private"
		altNames = "_L_unlock_44 _L_unlock_95"
	strings:
		$1 = { 48 8D 3D ?? ?? ?? ?? 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 7A FF FF FF }
	condition:
		$1
}

rule file_1_13_0 {
	meta:
		name = "freeaddrinfo"
		size = 52
		refs = "0019 free"
	strings:
		$1 = { 55 53 48 89 FB 48 83 EC 08 48 85 FF 74 1F 66 90 48 8B 7B 20 48 8B 6B 28 E8 ?? ?? ?? ?? 48 89 DF 48 89 EB E8 ?? ?? ?? ?? 48 85 ED 75 E3 48 83 C4 08 5B 5D C3 }
	condition:
		$1
}

rule file_1_14_0 {
	meta:
		name = "getaddrinfo"
		size = 2789
		refs = "0153 __pthread_once 01da qsort 0262 __connect 028b __libc_errno 0364 __socket 03ef memcmp 0424 memcpy 0496 __getsockname 050b bsearch 0602 qsort_r 0692 __free_in6ai 0705 __check_pf 07c7 strtoul 088f __assert_fail 08a6 freeaddrinfo 0a21 __libc_multiple_threads 0ab4 __xstat64"
	strings:
		$1 = { 55 48 89 E5 41 57 41 56 49 89 FE 41 55 49 89 F5 41 54 49 89 D4 53 48 81 EC A8 01 00 00 48 85 FF 48 89 8D 58 FE FF FF 48 C7 85 A0 FE FF FF 00 00 00 00 0F 84 D8 08 00 00 31 D2 80 3F 2A 0F 84 4D 07 00 00 4D 85 ED 0F 84 87 06 00 00 41 80 7D 00 2A 0F 84 71 06 00 00 4D 85 E4 B8 ?? ?? ?? ?? 4C 0F 44 E0 41 8B 04 24 A9 00 F8 FF FF 0F 85 56 03 00 00 A8 02 0F 85 46 03 00 00 31 DB A8 20 48 C7 85 A8 FE FF FF 00 00 00 00 48 C7 85 B0 FE FF FF 00 00 00 00 C6 85 96 FE FF FF 00 C6 85 97 FE FF FF 00 0F 85 40 06 00 00 31 F6 4D 85 ED 74 0B 41 80 7D 00 00 0F 85 F6 06 00 00 41 8B 44 24 04 C7 85 98 FE FF FF 00 00 00 00 A9 FD FF FF FF 74 09 83 F8 0A 0F 85 F1 08 00 00 4C 8D 85 98 FE FF FF 48 8D 8D A0 FE FF FF 4C 89 E2 4C 89 F7 E8 0E C6 FF FF 85 C0 0F 85 9E 07 00 00 48 8B 85 A0 FE FF FF C7 85 78 FE FF FF 00 00 00 00 8B 95 78 FE FF FF 48 85 C0 74 1C 66 2E 0F 1F 84 00 00 00 00 00 48 8B 40 28 83 C2 01 48 85 C0 75 F4 89 95 78 FE FF FF 83 BD 98 FE FF FF 01 0F 86 4B 05 00 00 8B 05 ?? ?? ?? ?? 48 89 A5 48 FE FF FF 89 85 44 FE FF FF B8 ?? ?? ?? ?? 48 85 C0 0F 84 99 08 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? FF D0 48 63 95 78 FE FF FF 48 8D 04 52 48 89 95 60 FE FF FF 48 C1 E0 04 48 83 C0 10 48 29 C4 48 8D 04 D5 16 00 00 00 49 89 E4 48 83 E0 F0 48 29 C4 48 89 E0 48 C1 E8 03 48 89 85 50 FE FF FF 48 C1 E0 03 84 DB 48 89 85 70 FE FF FF 0F 84 44 06 00 00 48 8B BD A8 FE FF FF 48 85 FF 74 16 48 8B B5 B0 FE FF FF B9 ?? ?? ?? ?? BA 18 00 00 00 E8 ?? ?? ?? ?? 4C 8B B5 A0 FE FF FF 4D 85 F6 0F 84 A1 07 00 00 4C 89 A5 88 FE FF FF 31 DB C7 85 7C FE FF FF 00 00 00 00 C7 85 68 FE FF FF FF FF FF FF 48 C7 85 80 FE FF FF 00 00 00 00 31 C0 41 BD FF FF FF FF E9 C9 00 00 00 0F 1F 44 00 00 83 BD 7C FE FF FF 02 75 0B 41 83 7E 04 0A 0F 84 74 01 00 00 48 8D B5 D0 FE FF FF BA 10 00 00 00 44 89 EF 48 C7 85 D0 FE FF FF 00 00 00 00 48 C7 85 D8 FE FF FF 00 00 00 00 E8 ?? ?? ?? ?? C7 85 9C FE FF FF 1C 00 00 00 41 8B 56 10 49 8B 76 18 44 89 EF E8 ?? ?? ?? ?? 85 C0 0F 84 E0 01 00 00 48 8B 05 ?? ?? ?? ?? 64 83 38 61 0F 84 F6 00 00 00 4B 8D 04 7F 48 C1 E0 04 41 C6 44 04 24 00 49 8B 46 20 48 85 C0 74 1D 48 83 BD 80 FE FF FF 00 0F 85 22 07 00 00 49 C7 46 20 00 00 00 00 48 89 85 80 FE FF FF 49 8B 56 28 48 83 C3 01 48 83 85 88 FE FF FF 30 4C 89 F0 48 85 D2 0F 84 BF 02 00 00 49 89 D6 4C 63 FB 48 8B 95 70 FE FF FF 4B 8D 3C 7F 48 C1 E7 04 48 85 C0 4A 89 1C FA 49 8D 0C 3C 4C 89 31 4C 8D 41 20 C7 41 2C FF FF FF FF 74 0D 8B 50 10 41 3B 56 10 0F 84 B2 00 00 00 4B 8D 04 7F 48 C1 E0 04 41 83 FD FF 49 8D 44 04 20 C6 40 05 00 C6 40 06 00 C6 40 07 00 C7 40 08 FF FF FF FF 0F 85 D8 FE FF FF 41 8B 46 04 31 D2 BE 02 00 00 00 89 C7 89 85 7C FE FF FF E8 ?? ?? ?? ?? 83 F8 FF 41 89 C5 C7 85 9C FE FF FF 1C 00 00 00 0F 85 F2 FE FF FF 48 8B 05 ?? ?? ?? ?? 64 83 38 61 0F 85 0A FF FF FF 83 BD 7C FE FF FF 0A 0F 85 FD FE FF FF 41 83 7E 04 02 0F 85 F2 FE FF FF 66 0F 1F 84 00 00 00 00 00 49 63 FD B8 03 00 00 00 0F 05 EB 94 0F 1F 40 00 84 D2 0F 84 B2 FC FF FF B8 FF FF FF FF E9 E0 02 00 00 66 0F 1F 44 00 00 49 8B 76 18 48 8B 78 18 48 89 8D 38 FE FF FF 4C 89 85 30 FE FF FF E8 ?? ?? ?? ?? 85 C0 48 8B 8D 38 FE FF FF 0F 85 24 FF FF FF 48 8B 85 88 FE FF FF 48 8D 79 08 0F B6 50 F4 8D 43 FF 48 98 48 8D 04 40 48 C1 E0 04 49 8D 74 04 08 E8 ?? ?? ?? ?? 48 8B 95 88 FE FF FF 4C 8B 85 30 FE FF FF 0F B6 42 F4 41 88 40 04 0F B6 42 F5 41 88 40 05 0F B6 42 F6 41 88 40 06 0F B6 42 F7 41 88 40 07 8B 42 F8 41 89 40 08 E9 45 FE FF FF 66 0F 1F 44 00 00 4B 8D 04 7F 48 8D 95 9C FE FF FF 44 89 EF 48 C1 E0 04 4C 01 E0 49 89 C3 48 89 85 68 FE FF FF 49 83 C3 08 4C 89 DE 4C 89 9D 38 FE FF FF E8 ?? ?? ?? ?? 85 C0 4C 8B 9D 38 FE FF FF 0F 85 DF FD FF FF 48 8B B5 A8 FE FF FF 48 8B 85 68 FE FF FF 8B 95 9C FE FF FF 48 85 F6 C6 40 25 01 88 50 24 74 72 41 83 7E 04 02 0F 84 FC 03 00 00 49 8B 43 08 48 89 85 F8 FE FF FF 49 8B 43 10 48 89 85 00 FF FF FF 48 8B 95 B0 FE FF FF 48 8D BD F0 FE FF FF 41 B8 ?? ?? ?? ?? B9 18 00 00 00 4C 89 9D 38 FE FF FF E8 ?? ?? ?? ?? 48 85 C0 4C 8B 9D 38 FE FF FF 74 20 4B 8D 14 7F 0F B6 08 48 C1 E2 04 49 8D 54 14 20 88 4A 06 0F B6 48 01 88 4A 07 8B 40 04 89 42 08 41 83 7E 04 02 0F 85 61 FD FF FF 83 BD 7C FE FF FF 0A 0F 85 54 FD FF FF 41 8B 43 08 85 C0 0F 85 1B 03 00 00 41 8B 43 0C 85 C0 0F 85 0F 03 00 00 41 81 7B 10 00 00 FF FF 0F 85 01 03 00 00 48 8B 85 68 FE FF FF 66 C7 40 08 02 00 41 8B 43 14 41 89 43 04 4B 8D 04 7F 48 C1 E0 04 41 C6 44 04 24 10 E9 06 FD FF FF 0F 1F 80 00 00 00 00 41 83 FD FF 44 89 AD 68 FE FF FF 74 0A 49 63 FD B8 03 00 00 00 0F 05 44 8B 1D ?? ?? ?? ?? 8B 95 78 FE FF FF 4C 89 A5 E0 FE FF FF 45 85 DB 89 95 E8 FE FF FF 0F 85 36 04 00 00 48 8B B5 60 FE FF FF 48 8B BD 70 FE FF FF 4C 8D 85 E0 FE FF FF B9 ?? ?? ?? ?? BA 08 00 00 00 E8 ?? ?? ?? ?? 48 8B 95 50 FE FF FF 48 8B 04 D5 00 00 00 00 48 8D 04 40 48 C1 E0 04 83 BD 78 FE FF FF 01 49 8B 3C 04 48 89 BD A0 FE FF FF 0F 8E 8D 03 00 00 8B 95 78 FE FF FF 48 8B 85 70 FE FF FF 48 89 F9 83 EA 02 48 8D 74 D0 08 0F 1F 00 48 8B 50 08 48 83 C0 08 48 8D 14 52 48 C1 E2 04 48 39 F0 49 8B 14 14 48 89 51 28 48 89 D1 75 E0 48 8B 85 80 FE FF FF 48 C7 42 28 00 00 00 00 48 89 47 20 48 8B A5 48 FE FF FF 48 8B BD A8 FE FF FF E8 ?? ?? ?? ?? 48 8B 85 A0 FE FF FF 48 85 C0 0F 84 12 03 00 00 48 8B 95 58 FE FF FF 48 89 02 31 C0 48 8D 65 D8 5B 41 5C 41 5D 41 5E 41 5F 5D C3 0F 1F 80 00 00 00 00 41 80 7D 01 00 0F 85 84 F9 FF FF 84 D2 0F 85 DD 02 00 00 45 31 ED E9 74 F9 FF FF 0F 1F 44 00 00 48 8D 8D B0 FE FF FF 48 8D 95 A8 FE FF FF 48 8D B5 97 FE FF FF 48 8D BD 96 FE FF FF E8 ?? ?? ?? ?? 41 8B 44 24 04 85 C0 0F 85 2A 01 00 00 80 BD 96 FE FF FF 00 0F 84 F7 01 00 00 80 BD 97 FE FF FF 00 BB 01 00 00 00 0F 85 73 F9 FF FF 49 8B 04 24 48 89 85 10 FF FF FF 49 8B 44 24 08 48 89 85 18 FF FF FF 49 8B 44 24 10 48 89 85 20 FF FF FF 49 8B 44 24 18 48 89 85 28 FF FF FF 49 8B 44 24 20 48 89 85 30 FF FF FF 49 8B 44 24 28 48 89 85 38 FF FF FF B8 02 00 00 00 E9 F2 01 00 00 66 2E 0F 1F 84 00 00 00 00 00 80 7F 01 00 0F 85 A9 F8 FF FF BA 01 00 00 00 45 31 F6 E9 9C F8 FF FF 66 0F 1F 84 00 00 00 00 00 48 8D B5 B8 FE FF FF BA 0A 00 00 00 4C 89 EF 4C 89 AD C0 FE FF FF E8 ?? ?? ?? ?? 89 85 C8 FE FF FF 48 8B 85 B8 FE FF FF 80 38 00 74 14 41 F7 04 24 00 04 00 00 75 7D C7 85 C8 FE FF FF FF FF FF FF 48 8D B5 C0 FE FF FF E9 BD F8 FF FF 0F 1F 00 48 8D BD 96 FE FF FF 48 8D 8D B0 FE FF FF 48 8D 95 A8 FE FF FF 48 8D B5 97 FE FF FF E8 ?? ?? ?? ?? 48 8B BD A8 FE FF FF 48 85 FF 0F 85 97 F9 FF FF E9 A8 F9 FF FF 66 2E 0F 1F 84 00 00 00 00 00 83 F8 02 BB 01 00 00 00 0F 84 51 01 00 00 83 F8 0A 0F 85 51 F8 FF FF 80 BD 97 FE FF FF 00 0F 85 44 F8 FF FF 48 8B BD A8 FE FF FF E8 ?? ?? ?? ?? B8 FE FF FF FF E9 38 FE FF FF B9 ?? ?? ?? ?? BA 02 0A 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 0F 1F 44 00 00 48 8B BD A0 FE FF FF 89 85 38 FE FF FF E8 ?? ?? ?? ?? 48 8B BD A8 FE FF FF E8 ?? ?? ?? ?? 8B 85 38 FE FF FF 48 8D 65 D8 5B 41 5C 41 5D 41 5E 80 E4 FE 41 5F F7 D8 5D C3 83 BD 7C FE FF FF 02 0F 85 F7 FB FF FF 41 8B 43 04 C7 85 F8 FE FF FF 00 00 00 00 C7 85 FC FE FF FF 00 00 00 00 C7 85 00 FF FF FF 00 00 FF FF 89 85 04 FF FF FF E9 E0 FB FF FF 66 0F 1F 44 00 00 BA 01 00 00 00 E9 29 F7 FF FF 80 BD 97 FE FF FF 00 BB 01 00 00 00 0F 84 7C F7 FF FF 49 8B 04 24 48 89 85 10 FF FF FF 49 8B 44 24 08 48 89 85 18 FF FF FF 49 8B 44 24 10 48 89 85 20 FF FF FF 49 8B 44 24 18 48 89 85 28 FF FF FF 49 8B 44 24 20 48 89 85 30 FF FF FF 49 8B 44 24 28 48 89 85 38 FF FF FF B8 0A 00 00 00 89 85 14 FF FF FF BB 01 00 00 00 4C 8D A5 10 FF FF FF E9 19 F7 FF FF 48 C7 85 80 FE FF FF 00 00 00 00 E9 20 FC FF FF 80 BD 96 FE FF FF 00 0F 85 FC F6 FF FF E9 B3 FE FF FF 0F 1F 80 00 00 00 00 B8 FE FF FF FF E9 F0 FC FF FF 48 89 FA E9 A6 FC FF FF 48 8B BD A8 FE FF FF E8 ?? ?? ?? ?? B8 FA FF FF FF E9 D2 FC FF FF B9 ?? ?? ?? ?? BA 1D 0A 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 85 44 FE FF FF 85 C0 0F 85 65 F7 FF FF E8 34 EA FF FF 83 0D ?? ?? ?? ?? 02 E9 54 F7 FF FF BE 01 00 00 00 31 C0 83 3D ?? ?? ?? ?? 00 74 10 F0 0F B1 35 ?? ?? ?? ?? 0F 85 AF 00 00 00 EB 0D 0F B1 35 ?? ?? ?? ?? 0F 85 A0 00 00 00 44 8B 95 44 FE FF FF 45 85 D2 74 0C 44 8B 0D ?? ?? ?? ?? 45 85 C9 75 45 48 8B B5 60 FE FF FF 48 8B BD 70 FE FF FF 4C 8D 85 E0 FE FF FF B9 ?? ?? ?? ?? BA 08 00 00 00 E8 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 74 0B F0 FF 0D ?? ?? ?? ?? 75 71 EB 08 FF 0D ?? ?? ?? ?? 75 67 E9 64 FB FF FF 48 8D 95 40 FF FF FF BE ?? ?? ?? ?? BF 01 00 00 00 E8 ?? ?? ?? ?? 85 C0 75 1E 48 8D BD 40 FF FF FF BA 10 00 00 00 BE ?? ?? ?? ?? 48 83 C7 58 E8 ?? ?? ?? ?? 85 C0 74 83 E8 61 E9 FF FF 90 E9 78 FF FF FF }
	condition:
		$1
}

rule file_1_15_0 {
	meta:
		name = "fini"
		size = 117
		refs = "0020 free"
	strings:
		$1 = { 48 83 EC 08 48 8B 3D ?? ?? ?? ?? 48 81 FF ?? ?? ?? ?? 74 10 48 C7 05 ?? ?? ?? ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 3D ?? ?? ?? ?? 48 81 FF ?? ?? ?? ?? 74 10 48 C7 05 ?? ?? ?? ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 3D ?? ?? ?? ?? 48 81 FF ?? ?? ?? ?? 74 1C 48 C7 05 ?? ?? ?? ?? ?? ?? ?? ?? 48 83 C4 08 E9 ?? ?? ?? ?? 0F 1F 84 00 00 00 00 00 48 83 C4 08 C3 }
	condition:
		$1
}

rule file_3_0_0 {
	meta:
		name = "bcopy"
		size = 362
		refs = "0070 _wordcopy_fwd_dest_aligned 010d _wordcopy_bwd_dest_aligned 0151 _wordcopy_bwd_aligned 0161 _wordcopy_fwd_aligned"
	strings:
		$1 = { 41 54 48 89 F0 48 29 F8 55 48 39 D0 53 0F 82 A5 00 00 00 48 83 FA 0F 48 89 F3 48 89 FD 48 89 D0 76 65 49 89 F0 49 89 D4 49 F7 D8 41 83 E0 07 4D 29 C4 4D 85 C0 74 21 31 C9 0F 1F 80 00 00 00 00 0F B6 04 0F 88 04 0E 48 83 C1 01 4C 39 C1 75 F0 48 8D 2C 0F 48 8D 1C 0E 4C 89 E2 48 89 EE 48 89 DF 48 C1 EA 03 40 F6 C5 07 0F 84 F1 00 00 00 E8 ?? ?? ?? ?? 4C 89 E0 48 83 E0 F8 48 01 C5 48 01 C3 4C 89 E0 83 E0 07 48 89 EE 4C 8D 04 03 48 89 DF 48 29 DE 48 85 C0 74 17 0F 1F 80 00 00 00 00 0F B6 04 3E 48 83 C7 01 88 47 FF 4C 39 C7 75 F0 5B 5D 41 5C C3 0F 1F 00 48 83 FA 0F 48 8D 1C 3A 48 8D 2C 32 76 60 48 89 EE 49 89 D4 83 E6 07 49 29 F4 48 85 F6 74 23 49 89 D8 48 89 E9 49 29 F0 48 29 D9 0F 1F 44 00 00 48 83 EB 01 0F B6 03 4C 39 C3 88 04 19 75 F1 48 29 F5 4C 89 E2 48 89 DE 48 89 EF 48 C1 EA 03 F6 C3 07 74 44 E8 ?? ?? ?? ?? 4C 89 E0 4C 89 E2 48 83 E0 F8 48 29 C3 48 29 C5 83 E2 07 74 8A 48 89 D9 48 89 EE 48 89 D8 48 29 D1 48 29 DE 0F 1F 00 48 83 E8 01 0F B6 10 48 39 C8 88 14 06 75 F1 5B 5D 41 5C C3 0F 1F 40 00 E8 ?? ?? ?? ?? EB BA 66 0F 1F 84 00 00 00 00 00 E8 ?? ?? ?? ?? E9 0A FF FF FF }
	condition:
		$1
}

rule file_4_0_0 {
	meta:
		name = "__libc_cleanup_routine"
		size = 28
		altNames = "__pthread_cleanup_routine"
	strings:
		$1 = { 8B 47 10 85 C0 75 09 F3 C3 0F 1F 80 00 00 00 00 48 8B 57 08 48 8B 07 48 89 D7 FF E0 }
	condition:
		$1
}

rule file_6_0_0 {
	meta:
		name = "decode_name"
		size = 204
	strings:
		$1 = { 48 89 F8 48 8D 4F 01 48 89 FA EB 18 0F 1F 40 00 40 88 71 FF 0F B6 32 48 83 C1 01 48 83 C2 01 40 84 F6 74 3C 0F B6 32 40 80 FE 5C 75 E3 44 0F B6 42 01 41 80 F8 30 74 30 41 80 F8 5C 74 5A 41 80 F8 31 75 CC 80 7A 02 33 75 C6 80 7A 03 34 75 C0 C6 41 FF 5C 48 83 C2 03 EB BA 66 0F 1F 44 00 00 F3 C3 66 0F 1F 44 00 00 0F B6 7A 02 40 80 FF 34 74 36 40 80 FF 31 75 98 0F B6 7A 03 40 80 FF 31 74 3D 40 80 FF 32 75 88 C6 41 FF 0A 48 83 C2 03 EB 82 66 0F 1F 44 00 00 C6 41 FF 5C 48 83 C2 01 E9 6F FF FF FF 0F 1F 00 80 7A 03 30 0F 85 5E FF FF FF C6 41 FF 20 48 83 C2 03 E9 55 FF FF FF C6 41 FF 09 48 83 C2 03 E9 48 FF FF FF }
	condition:
		$1
}

rule file_6_1_0 {
	meta:
		name = "_L_lock_287"
		size = 27
		refs = "000b __lll_lock_wait_private"
	strings:
		$1 = { 48 8D 3A 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 69 F6 FF FF }
	condition:
		$1
}

rule file_6_2_0 {
	meta:
		name = "_L_unlock_601"
		size = 27
		refs = "000b __lll_unlock_wake_private"
	strings:
		$1 = { 48 8D 3A 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 F0 F7 FF FF }
	condition:
		$1
}

rule file_6_3_0 {
	meta:
		name = "_L_unlock_1035"
		size = 27
		refs = "000b __lll_unlock_wake_private"
	strings:
		$1 = { 48 8D 3A 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 5F F9 FF FF }
	condition:
		$1
}

rule file_6_4_0 {
	meta:
		name = "__setmntent"
		size = 86
		refs = "0011 strlen 002a mempcpy 003e _IO_new_fopen"
	strings:
		$1 = { 55 48 89 E5 41 54 49 89 FC 48 89 F7 53 48 89 F3 E8 ?? ?? ?? ?? 48 8D 48 12 48 89 C2 48 89 DE 48 83 E1 F0 48 29 CC 48 89 E7 E8 ?? ?? ?? ?? 48 89 E6 66 C7 00 63 65 C6 40 02 00 4C 89 E7 E8 ?? ?? ?? ?? 48 85 C0 74 06 81 08 00 80 00 00 48 8D 65 F0 5B 41 5C 5D C3 }
	condition:
		$1
}

rule file_6_5_0 {
	meta:
		name = "__endmntent"
		size = 30
		refs = "000a _IO_new_fclose"
	strings:
		$1 = { 48 85 FF 74 13 48 83 EC 08 E8 ?? ?? ?? ?? B8 01 00 00 00 48 83 C4 08 C3 B8 01 00 00 00 C3 }
	condition:
		$1
}

rule file_6_6_0 {
	meta:
		name = "__getmntent_r"
		size = 934
		refs = "003f __libc_multiple_threads 007a fgets_unlocked 0090 strchr 0333 sscanf"
	strings:
		$1 = { 41 55 41 89 CD 41 54 49 89 F4 55 48 89 FD 53 48 89 D3 48 81 EC 08 04 00 00 8B 07 25 00 80 00 00 75 4E 48 8B 97 88 00 00 00 64 4C 8B 04 25 10 00 00 00 4C 3B 42 08 74 2E BE 01 00 00 00 83 3D ?? ?? ?? ?? 00 74 0C F0 0F B1 32 0F 85 87 09 00 00 EB 09 0F B1 32 0F 85 7C 09 00 00 48 8B 95 88 00 00 00 4C 89 42 08 83 42 04 01 66 0F 1F 44 00 00 48 89 EA 44 89 EE 48 89 DF E8 ?? ?? ?? ?? 48 85 C0 0F 84 C6 02 00 00 BE 0A 00 00 00 48 89 DF E8 ?? ?? ?? ?? 48 85 C0 74 3F C6 00 00 48 89 DF EB 0B 0F 1F 80 00 00 00 00 48 83 C7 01 0F B6 07 48 89 FA 44 0F BE C8 41 83 F9 20 74 EC 41 83 F9 09 74 E6 3C 23 74 AA 84 C0 74 A6 66 0F 1F 44 00 00 EB 49 66 0F 1F 44 00 00 48 89 EA BE 00 04 00 00 48 89 E7 E8 ?? ?? ?? ?? 48 85 C0 74 AF BE 0A 00 00 00 48 89 E7 E8 ?? ?? ?? ?? 48 85 C0 74 D9 EB 9B 0F 1F 80 00 00 00 00 3C 09 74 13 48 83 C2 01 0F B6 02 84 C0 0F 84 74 02 00 00 3C 20 75 E9 48 8D 5A 01 C6 02 00 E8 85 FD FF FF 48 85 DB 49 89 04 24 0F 84 60 02 00 00 48 89 DF EB 07 0F 1F 00 48 83 C7 01 0F B6 0F 48 89 F8 0F BE D1 83 FA 20 74 EE 83 FA 09 74 E9 84 C9 74 3A 80 F9 20 66 90 0F 84 AB 00 00 00 80 F9 09 75 1F 0F 1F 44 00 00 E9 9C 00 00 00 0F 1F 00 80 FA 20 0F 84 90 00 00 00 80 FA 09 0F 84 87 00 00 00 48 83 C0 01 0F B6 10 84 D2 75 E3 E8 16 FD FF FF 49 89 44 24 08 49 C7 44 24 10 ?? ?? ?? ?? 49 C7 44 24 18 ?? ?? ?? ?? 41 C7 44 24 20 00 00 00 00 41 C7 44 24 24 00 00 00 00 F7 45 00 00 80 00 00 75 34 48 8B 95 88 00 00 00 83 6A 04 01 75 27 48 C7 42 08 00 00 00 00 83 3D ?? ?? ?? ?? 00 74 0B F0 FF 0A 0F 85 FF 07 00 00 EB 08 FF 0A 0F 85 F5 07 00 00 0F 1F 00 48 81 C4 08 04 00 00 4C 89 E0 5B 5D 41 5C 41 5D C3 48 8D 58 01 C6 00 00 E8 93 FC FF FF 48 85 DB 49 89 44 24 08 0F 84 74 FF FF FF 48 89 DF EB 04 48 83 C7 01 0F B6 0F 48 89 F8 0F BE D1 83 FA 20 74 EE 83 FA 09 74 E9 84 C9 74 2A 80 F9 20 66 90 74 3E 80 F9 09 75 13 EB 37 0F 1F 80 00 00 00 00 80 FA 20 74 2B 80 FA 09 74 26 48 83 C0 01 0F B6 10 84 D2 75 EB E8 36 FC FF FF 49 89 44 24 10 49 C7 44 24 18 ?? ?? ?? ?? E9 24 FF FF FF 0F 1F 00 48 8D 58 01 C6 00 00 E8 14 FC FF FF 48 85 DB 49 89 44 24 10 74 D9 48 89 DF EB 09 0F 1F 44 00 00 48 83 C7 01 0F B6 37 48 89 FA 40 0F BE CE 83 F9 20 74 ED 83 F9 09 74 E8 40 84 F6 74 28 40 80 FE 20 74 31 40 80 FE 09 75 11 EB 29 0F 1F 44 00 00 80 F9 20 74 1F 80 F9 09 74 1A 48 83 C2 01 0F B6 0A 84 C9 75 EB E8 B6 FB FF FF 49 89 44 24 18 E9 AD FE FF FF 48 8D 5A 01 C6 02 00 E8 A0 FB FF FF 48 85 DB 49 89 44 24 18 0F 84 93 FE FF FF 49 8D 4C 24 24 49 8D 54 24 20 31 C0 BE ?? ?? ?? ?? 48 89 DF E8 ?? ?? ?? ?? 85 C0 0F 84 72 FE FF FF 83 F8 01 0F 85 7B FE FF FF E9 6D FE FF FF F7 45 00 00 80 00 00 75 31 48 8B 95 88 00 00 00 83 6A 04 01 75 24 48 C7 42 08 00 00 00 00 83 3D ?? ?? ?? ?? 00 74 0B F0 FF 0A 0F 85 90 06 00 00 EB 08 FF 0A 0F 85 86 06 00 00 45 31 E4 E9 71 FE FF FF E8 1C FB FF FF 49 89 04 24 49 C7 44 24 08 ?? ?? ?? ?? E9 F9 FD FF FF }
	condition:
		$1
}

rule file_6_7_0 {
	meta:
		name = "__addmntent"
		size = 1456
		refs = "0037 fseek 01d9 fprintf 01e5 fflush 021f strlen"
	strings:
		$1 = { 55 BA 02 00 00 00 48 89 E5 41 57 49 89 FF 41 56 41 55 41 54 53 48 83 EC 28 8B 46 20 4C 8B 36 4C 8B 6E 08 4C 8B 66 10 48 8B 5E 18 8B 76 24 89 45 CC 89 75 C8 31 F6 E8 ?? ?? ?? ?? 85 C0 0F 85 BD 01 00 00 41 0F B6 0E 84 C9 74 58 80 F9 09 0F 84 84 03 00 00 80 F9 20 0F 84 7B 03 00 00 80 F9 0A 0F 84 72 03 00 00 80 F9 5C 0F 84 69 03 00 00 4C 89 F2 EB 24 0F 1F 40 00 3C 09 0F 84 58 03 00 00 3C 20 0F 84 50 03 00 00 3C 0A 0F 84 48 03 00 00 3C 5C 0F 84 40 03 00 00 48 83 C2 01 0F B6 02 84 C0 75 D5 41 0F B6 4D 00 84 C9 74 57 80 F9 09 0F 84 F3 01 00 00 80 F9 20 0F 84 EA 01 00 00 80 F9 0A 0F 84 E1 01 00 00 80 F9 5C 0F 84 D8 01 00 00 4C 89 EA EB 23 0F 1F 00 3C 09 0F 84 C8 01 00 00 3C 20 0F 84 C0 01 00 00 3C 0A 0F 84 B8 01 00 00 3C 5C 0F 84 B0 01 00 00 48 83 C2 01 0F B6 02 84 C0 75 D5 41 0F B6 0C 24 84 C9 74 57 80 F9 20 0F 84 2B 02 00 00 80 F9 09 0F 84 22 02 00 00 80 F9 0A 0F 84 19 02 00 00 80 F9 5C 0F 84 10 02 00 00 4C 89 E2 EB 23 0F 1F 00 3C 09 0F 84 00 02 00 00 3C 20 0F 84 F8 01 00 00 3C 0A 0F 84 F0 01 00 00 3C 5C 0F 84 E8 01 00 00 48 83 C2 01 0F B6 02 84 C0 75 D5 0F B6 0B 84 C9 74 4B 80 F9 09 0F 84 A5 00 00 00 80 F9 20 0F 84 9C 00 00 00 80 F9 0A 90 0F 84 92 00 00 00 80 F9 5C 0F 84 89 00 00 00 48 89 DA EB 16 0F 1F 40 00 3C 09 74 7C 3C 20 66 90 74 76 3C 0A 74 72 3C 5C 74 6E 48 83 C2 01 0F B6 02 84 C0 75 E3 8B 45 C8 49 89 D9 4D 89 E0 4C 89 E9 4C 89 F2 BE ?? ?? ?? ?? 4C 89 FF 89 44 24 08 8B 45 CC 89 04 24 31 C0 E8 ?? ?? ?? ?? 85 C0 78 1F 4C 89 FF E8 ?? ?? ?? ?? 85 C0 0F 95 C0 48 8D 65 D8 0F B6 C0 5B 41 5C 41 5D 41 5E 41 5F 5D C3 48 8D 65 D8 B8 01 00 00 00 5B 41 5C 41 5D 41 5E 41 5F 5D C3 0F 1F 40 00 48 89 DF 88 4D C0 E8 ?? ?? ?? ?? 48 8D 04 85 1F 00 00 00 0F B6 4D C0 48 83 E0 F0 48 29 C4 48 8D 74 24 1F 48 83 E6 F0 48 89 F0 EB 33 0F 1F 40 00 80 F9 09 0F 84 1F 02 00 00 80 F9 0A 0F 84 96 02 00 00 80 F9 5C 0F 84 3D 03 00 00 88 08 48 83 C0 01 0F B6 13 48 83 C3 01 84 D2 74 27 0F B6 0B 80 F9 20 75 CC C6 00 5C C6 40 01 30 48 83 C3 01 C6 40 02 34 C6 40 03 30 48 83 C0 04 0F B6 53 FF 84 D2 75 D9 48 89 F3 E9 12 FF FF FF 0F 1F 44 00 00 4C 89 EF 88 4D C0 E8 ?? ?? ?? ?? 48 8D 04 85 1F 00 00 00 0F B6 4D C0 48 83 E0 F0 48 29 C4 48 8D 74 24 1F 48 83 E6 F0 48 89 F0 EB 37 0F 1F 40 00 80 F9 09 0F 84 CF 01 00 00 80 F9 0A 0F 84 66 02 00 00 80 F9 5C 0F 84 9D 02 00 00 88 08 48 83 C0 01 41 0F B6 55 00 49 83 C5 01 84 D2 74 2A 41 0F B6 4D 00 80 F9 20 75 C8 C6 00 5C C6 40 01 30 49 83 C5 01 C6 40 02 34 C6 40 03 30 48 83 C0 04 41 0F B6 55 FF 84 D2 75 D6 49 89 F5 E9 CB FD FF FF 0F 1F 84 00 00 00 00 00 4C 89 E7 88 4D C0 E8 ?? ?? ?? ?? 48 8D 04 85 1F 00 00 00 0F B6 4D C0 48 83 E0 F0 48 29 C4 48 8D 74 24 1F 48 83 E6 F0 48 89 F0 EB 37 0F 1F 40 00 80 F9 09 0F 84 17 01 00 00 80 F9 0A 0F 84 AE 01 00 00 80 F9 5C 0F 84 F5 01 00 00 88 08 48 83 C0 01 41 0F B6 14 24 49 83 C4 01 84 D2 74 2B 41 0F B6 0C 24 80 F9 20 75 C8 C6 00 5C C6 40 01 30 49 83 C4 01 C6 40 02 34 C6 40 03 30 48 83 C0 04 41 0F B6 54 24 FF 84 D2 75 D5 49 89 F4 E9 92 FD FF FF 0F 1F 80 00 00 00 00 4C 89 F7 88 4D C0 E8 ?? ?? ?? ?? 48 8D 04 85 1F 00 00 00 0F B6 4D C0 48 83 E0 F0 48 29 C4 48 8D 74 24 1F 48 83 E6 F0 48 89 F0 EB 35 0F 1F 40 00 80 F9 09 0F 84 BF 00 00 00 80 F9 0A 0F 84 F6 00 00 00 80 F9 5C 0F 84 4D 01 00 00 88 08 48 83 C0 01 41 0F B6 16 49 83 C6 01 84 D2 74 29 41 0F B6 0E 80 F9 20 75 CA C6 00 5C C6 40 01 30 49 83 C6 01 C6 40 02 34 C6 40 03 30 48 83 C0 04 41 0F B6 56 FF 84 D2 75 D7 49 89 F6 E9 3D FC FF FF 66 2E 0F 1F 84 00 00 00 00 00 C6 00 5C C6 40 01 30 48 83 C0 04 C6 40 FE 31 C6 40 FF 31 E9 E1 FD FF FF 0F 1F 84 00 00 00 00 00 C6 00 5C C6 40 01 30 48 83 C0 04 C6 40 FE 31 C6 40 FF 31 E9 E9 FE FF FF 0F 1F 84 00 00 00 00 00 C6 00 5C C6 40 01 30 48 83 C0 04 C6 40 FE 31 C6 40 FF 31 E9 31 FE FF FF 0F 1F 84 00 00 00 00 00 C6 00 5C C6 40 01 30 48 83 C0 04 C6 40 FE 31 C6 40 FF 31 E9 41 FF FF FF 0F 1F 84 00 00 00 00 00 C6 00 5C C6 40 01 30 48 83 C0 04 C6 40 FE 31 C6 40 FF 32 E9 61 FD FF FF 0F 1F 84 00 00 00 00 00 C6 00 5C C6 40 01 30 48 83 C0 04 C6 40 FE 31 C6 40 FF 32 E9 01 FF FF FF 0F 1F 84 00 00 00 00 00 C6 00 5C C6 40 01 30 48 83 C0 04 C6 40 FE 31 C6 40 FF 32 E9 49 FE FF FF 0F 1F 84 00 00 00 00 00 C6 00 5C C6 40 01 30 48 83 C0 04 C6 40 FE 31 C6 40 FF 32 E9 91 FD FF FF 0F 1F 84 00 00 00 00 00 C6 00 5C C6 40 01 5C 48 83 C0 02 E9 A9 FE FF FF C6 00 5C C6 40 01 5C 48 83 C0 02 E9 01 FE FF FF C6 00 5C C6 40 01 5C 48 83 C0 02 E9 59 FD FF FF C6 00 5C C6 40 01 5C 48 83 C0 02 E9 B9 FC FF FF }
	condition:
		$1
}

rule file_6_8_0 {
	meta:
		name = "__hasmntopt"
		size = 119
		refs = "000e strlen 0029 strchr 003d strstr"
	strings:
		$1 = { 41 54 55 48 89 F5 53 48 89 FB 48 89 F7 E8 ?? ?? ?? ?? 48 8B 5B 18 49 89 C4 EB 1B 0F 1F 44 00 00 BE 2C 00 00 00 48 89 C7 E8 ?? ?? ?? ?? 48 85 C0 74 3E 48 8D 58 01 48 89 EE 48 89 DF E8 ?? ?? ?? ?? 48 85 C0 74 22 48 39 D8 74 06 80 78 FF 2C 75 CF 42 0F B6 14 20 80 FA 3D 74 0D 84 D2 74 09 80 FA 2C 75 BC 0F 1F 40 00 5B 5D 41 5C C3 0F 1F 00 5B 5D 31 C0 41 5C C3 }
	condition:
		$1
}

rule file_7_0_0 {
	meta:
		name = "__setitimer"
		size = 20
		refs = "000f __syscall_error"
	strings:
		$1 = { B8 26 00 00 00 0F 05 48 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_8_0_0 {
	meta:
		name = "_L_lock_44"
		size = 27
		refs = "000b __lll_lock_wait_private"
	strings:
		$1 = { 49 8D 38 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 36 FF FF FF }
	condition:
		$1
}

rule file_8_1_0 {
	meta:
		name = "_L_unlock_97"
		size = 27
		refs = "000b __lll_unlock_wake_private"
	strings:
		$1 = { 48 8D 3E 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 77 FF FF FF }
	condition:
		$1
}

rule file_8_2_0 {
	meta:
		name = "_L_unlock_166"
		size = 24
		refs = "000b __lll_unlock_wake_private"
		altNames = "_L_unlock_113 _L_unlock_146 _L_unlock_150 _L_unlock_155 _L_unlock_157 _L_unlock_159 _L_unlock_162 _L_unlock_167 _L_unlock_175 _L_unlock_180 _L_unlock_182 _L_unlock_186 _L_unlock_187 _L_unlock_198 _L_unlock_229 _L_unlock_230 _L_unlock_234 _L_unlock_237 _L_unlock_257 _L_unlock_264 _L_unlock_266 _L_unlock_269 _L_unlock_379 _L_unlock_389 _L_unlock_438"
	strings:
		$1 = { 48 8D 3A 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 EB AA }
	condition:
		$1
}

rule file_8_3_0 {
	meta:
		name = "__isoc99_vwscanf"
		size = 269
		refs = "000f stdin 0040 __libc_multiple_threads 007f _IO_vfwscanf 0109 _Unwind_Resume"
	strings:
		$1 = { 55 49 89 FA 48 89 F2 53 48 83 EC 08 48 8B 1D ?? ?? ?? ?? 8B 03 48 89 DF 25 00 80 00 00 75 56 4C 8B 83 88 00 00 00 64 48 8B 2C 25 10 00 00 00 49 3B 68 08 0F 84 8F 00 00 00 BE 01 00 00 00 83 3D ?? ?? ?? ?? 00 74 0D F0 41 0F B1 30 0F 85 BB 00 00 00 EB 0A 41 0F B1 30 0F 85 AF 00 00 00 4C 8B 83 88 00 00 00 48 8B 3D ?? ?? ?? ?? 49 89 68 08 41 83 40 04 01 83 4F 74 10 31 C9 4C 89 D6 E8 ?? ?? ?? ?? 83 63 74 EB F7 03 00 80 00 00 89 C2 75 29 48 8B B3 88 00 00 00 83 6E 04 01 75 1C 48 C7 46 08 00 00 00 00 83 3D ?? ?? ?? ?? 00 74 07 F0 FF 0E 75 74 EB 04 FF 0E 75 6E 48 83 C4 08 89 D0 5B 5D C3 0F 1F 44 00 00 48 89 DF EB A3 83 63 74 EB F7 03 00 80 00 00 48 89 C6 75 29 48 8B 93 88 00 00 00 83 6A 04 01 75 1C 48 C7 42 08 00 00 00 00 83 3D ?? ?? ?? ?? 00 74 07 F0 FF 0A 75 44 EB 04 FF 0A 75 3E 48 89 F7 E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1159_3_0 {
	meta:
		name = "__isoc99_vscanf"
		size = 269
		refs = "000f stdin 0040 __libc_multiple_threads 007f _IO_vfscanf 0109 _Unwind_Resume"
	strings:
		$1 = { 55 49 89 FA 48 89 F2 53 48 83 EC 08 48 8B 1D ?? ?? ?? ?? 8B 03 48 89 DF 25 00 80 00 00 75 56 4C 8B 83 88 00 00 00 64 48 8B 2C 25 10 00 00 00 49 3B 68 08 0F 84 8F 00 00 00 BE 01 00 00 00 83 3D ?? ?? ?? ?? 00 74 0D F0 41 0F B1 30 0F 85 BB 00 00 00 EB 0A 41 0F B1 30 0F 85 AF 00 00 00 4C 8B 83 88 00 00 00 48 8B 3D ?? ?? ?? ?? 49 89 68 08 41 83 40 04 01 83 4F 74 10 31 C9 4C 89 D6 E8 ?? ?? ?? ?? 83 63 74 EB F7 03 00 80 00 00 89 C2 75 29 48 8B B3 88 00 00 00 83 6E 04 01 75 1C 48 C7 46 08 00 00 00 00 83 3D ?? ?? ?? ?? 00 74 07 F0 FF 0E 75 74 EB 04 FF 0E 75 6E 48 83 C4 08 89 D0 5B 5D C3 0F 1F 44 00 00 48 89 DF EB A3 83 63 74 EB F7 03 00 80 00 00 48 89 C6 75 29 48 8B 93 88 00 00 00 83 6A 04 01 75 1C 48 C7 42 08 00 00 00 00 83 3D ?? ?? ?? ?? 00 74 07 F0 FF 0A 75 44 EB 04 FF 0A 75 3E 48 89 F7 E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_9_0_0 {
	meta:
		name = "allocate"
		size = 26
		refs = "000a malloc"
	strings:
		$1 = { 48 83 EC 08 BF 00 04 00 00 E8 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 48 83 C4 08 C3 }
	condition:
		$1
}

rule file_9_1_0 {
	meta:
		name = "getnetgrent"
		size = 165
		refs = "0001 __pthread_once 006b __libc_errno 0060 __getnetgrent_r"
	strings:
		$1 = { B8 ?? ?? ?? ?? 48 89 5C 24 E8 48 89 6C 24 F0 4C 89 64 24 F8 48 83 EC 18 48 85 C0 48 89 FB 48 89 F5 49 89 D4 74 68 BE ?? ?? ?? ?? BF ?? ?? ?? ?? FF D0 48 8B 0D ?? ?? ?? ?? 48 85 C9 74 2A 4C 89 E2 48 89 EE 48 89 DF 48 8B 6C 24 08 48 8B 1C 24 41 B8 00 04 00 00 4C 8B 64 24 10 48 83 C4 18 E9 ?? ?? ?? ?? 0F 1F 40 00 48 8B 05 ?? ?? ?? ?? 48 8B 1C 24 48 8B 6C 24 08 4C 8B 64 24 10 64 C7 00 0C 00 00 00 B8 FF FF FF FF 48 83 C4 18 C3 83 3D ?? ?? ?? ?? 00 75 9B E8 44 FF FF FF 83 0D ?? ?? ?? ?? 02 EB 8D }
	condition:
		$1
}

rule file_10_0_0 {
	meta:
		name = "_L_lock_37"
		size = 27
		refs = "000b __lll_lock_wait_private"
	strings:
		$1 = { 48 8D 3A 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 32 FF FF FF }
	condition:
		$1
}

rule file_10_1_0 {
	meta:
		name = "_L_unlock_89"
		size = 27
		refs = "000b __lll_unlock_wake_private"
		altNames = "_L_unlock_113 _L_unlock_14365 _L_unlock_14654"
	strings:
		$1 = { 48 8D 3A 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 7B FF FF FF }
	condition:
		$1
}

rule file_10_3_0 {
	meta:
		name = "putwc"
		size = 252
		refs = "002d __libc_multiple_threads 00b8 __woverflow 00f8 _Unwind_Resume"
	strings:
		$1 = { 53 8B 06 41 89 F8 48 89 F3 25 00 80 00 00 75 48 48 8B 96 88 00 00 00 64 4C 8B 0C 25 10 00 00 00 4C 3B 4A 08 74 2E BE 01 00 00 00 83 3D ?? ?? ?? ?? 00 74 0C F0 0F B1 32 0F 85 BE 00 00 00 EB 09 0F B1 32 0F 85 B3 00 00 00 48 8B 93 88 00 00 00 4C 89 4A 08 83 42 04 01 48 8B 93 A0 00 00 00 48 85 D2 74 4D 48 8B 4A 20 48 3B 4A 28 73 43 44 89 01 48 83 C1 04 44 89 C6 48 89 4A 20 F7 03 00 80 00 00 75 29 48 8B 93 88 00 00 00 83 6A 04 01 75 1C 48 C7 42 08 00 00 00 00 83 3D ?? ?? ?? ?? 00 74 07 F0 FF 0A 75 70 EB 04 FF 0A 75 6A 89 F0 5B C3 44 89 C6 48 89 DF E8 ?? ?? ?? ?? 89 C6 EB BC F7 03 00 80 00 00 48 89 C6 75 29 48 8B 93 88 00 00 00 83 6A 04 01 75 1C 48 C7 42 08 00 00 00 00 83 3D ?? ?? ?? ?? 00 74 07 F0 FF 0A 75 44 EB 04 FF 0A 75 3E 48 89 F7 E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_11_0_0 {
	meta:
		name = "parse_printf_format"
		size = 246
		refs = "001f __strchrnul 004e __parse_one_specmb 00af __printf_arginfo_table"
	strings:
		$1 = { 41 55 41 54 49 89 D4 55 48 89 F5 BE 25 00 00 00 53 48 83 EC 68 48 C7 44 24 08 00 00 00 00 E8 ?? ?? ?? ?? 80 38 00 0F 84 C6 00 00 00 4C 8D 6C 24 50 48 89 C7 31 DB 66 2E 0F 1F 84 00 00 00 00 00 48 8D 4C 24 08 48 8D 54 24 10 48 89 DE E8 ?? ?? ?? ?? 48 01 C3 48 63 44 24 3C 83 F8 FF 74 0D 48 39 E8 73 08 41 C7 04 84 00 00 00 00 48 63 44 24 38 83 F8 FF 74 0D 48 39 C5 76 08 41 C7 04 84 00 00 00 00 48 63 44 24 40 48 39 C5 76 33 48 8B 54 24 48 48 85 D2 74 29 48 83 FA 01 74 4B 48 89 EE 4C 63 44 24 18 49 8D 14 84 48 29 C6 48 8B 05 ?? ?? ?? ?? 4C 89 E9 48 8D 7C 24 10 42 FF 14 C0 90 48 8B 7C 24 30 80 3F 00 0F 85 72 FF FF FF 48 8B 44 24 08 48 39 C3 48 0F 43 C3 48 83 C4 68 5B 5D 41 5C 41 5D C3 0F 1F 00 8B 54 24 44 41 89 14 84 EB CE 31 C0 EB E4 }
	condition:
		$1
}

rule file_12_0_0 {
	meta:
		name = "getwchar_unlocked"
		size = 43
		refs = "0003 _IO_stdin 0027 __wuflow"
	strings:
		$1 = { 48 8B 3D ?? ?? ?? ?? 48 8B 97 A0 00 00 00 48 85 D2 74 13 48 8B 0A 48 3B 4A 08 73 0A 8B 01 48 83 C1 04 48 89 0A C3 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_13_0_0 {
	meta:
		name = "rename"
		size = 20
		refs = "000f __syscall_error"
	strings:
		$1 = { B8 52 00 00 00 0F 05 48 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_14_0_0 {
	meta:
		name = "posix_spawn_file_actions_destroy"
		size = 20
		refs = "0009 free"
	strings:
		$1 = { 48 83 EC 08 48 8B 7F 08 E8 ?? ?? ?? ?? 31 C0 48 83 C4 08 C3 }
	condition:
		$1
}

rule file_15_0_0 {
	meta:
		name = "__mmap"
		size = 23
		refs = "0012 __syscall_error"
	strings:
		$1 = { 49 89 CA B8 09 00 00 00 0F 05 48 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_16_0_0 {
	meta:
		name = "__nl_langinfo_l"
		size = 89
	strings:
		$1 = { 89 FA C1 FA 10 83 FA 06 74 36 89 D0 C1 E8 1F 84 C0 75 2D 83 FA 0C B8 ?? ?? ?? ?? 7F 28 81 E7 FF FF 00 00 48 63 D2 81 FF FF FF 00 00 74 22 48 8B 14 D6 3B 7A 38 73 0E 48 8B 44 FA 40 C3 0F 1F 00 B8 ?? ?? ?? ?? F3 C3 66 0F 1F 84 00 00 00 00 00 48 8B 84 D6 80 00 00 00 C3 }
	condition:
		$1
}

rule file_17_0_0 {
	meta:
		name = "strerror_l"
		size = 260
		refs = "001b _sys_nerr_internal 0028 _sys_errlist_internal 0035 __uselocale 003a _libc_intl_domainname 004a __dcgettext 0075 last_value 007f free 00cf __asprintf"
	strings:
		$1 = { 48 89 5C 24 E8 48 89 6C 24 F0 89 FB 4C 89 64 24 F8 48 83 EC 28 85 FF 78 57 3B 3D ?? ?? ?? ?? 7D 4F 48 63 C7 48 8B 2C C5 ?? ?? ?? ?? 48 85 ED 74 3F 48 89 F7 E8 ?? ?? ?? ?? BF ?? ?? ?? ?? 49 89 C4 BA 05 00 00 00 48 89 EE E8 ?? ?? ?? ?? 4C 89 E7 48 89 C3 E8 ?? ?? ?? ?? 48 89 D8 48 8B 6C 24 18 48 8B 5C 24 10 4C 8B 64 24 20 48 83 C4 28 C3 64 48 8B 3C 25 ?? ?? ?? ?? 48 89 74 24 08 E8 ?? ?? ?? ?? 48 8B 74 24 08 48 89 F7 E8 ?? ?? ?? ?? BA 05 00 00 00 BE ?? ?? ?? ?? 48 89 C5 BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 EF 49 89 C4 E8 ?? ?? ?? ?? 64 48 8B 3C 25 00 00 00 00 31 C0 89 D9 4C 89 E2 BE ?? ?? ?? ?? 48 81 C7 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 F8 FF 74 18 64 48 8B 1C 25 ?? ?? ?? ?? E9 73 FF FF FF 66 2E 0F 1F 84 00 00 00 00 00 64 48 C7 04 25 ?? ?? ?? ?? 00 00 00 00 31 DB E9 55 FF FF FF }
	condition:
		$1
}

rule file_18_0_0 {
	meta:
		name = "__scanf"
		size = 160
		refs = "0070 stdin 0094 _IO_vfscanf"
	strings:
		$1 = { 48 81 EC D8 00 00 00 84 C0 48 89 74 24 28 48 89 54 24 30 48 89 4C 24 38 4C 89 44 24 40 4C 89 4C 24 48 74 37 0F 29 44 24 50 0F 29 4C 24 60 0F 29 54 24 70 0F 29 9C 24 80 00 00 00 0F 29 A4 24 90 00 00 00 0F 29 AC 24 A0 00 00 00 0F 29 B4 24 B0 00 00 00 0F 29 BC 24 C0 00 00 00 48 8D 84 24 E0 00 00 00 48 89 FE 48 8D 54 24 08 31 C9 48 8B 3D ?? ?? ?? ?? 48 89 44 24 10 48 8D 44 24 20 C7 44 24 08 08 00 00 00 C7 44 24 0C 30 00 00 00 48 89 44 24 18 E8 ?? ?? ?? ?? 48 81 C4 D8 00 00 00 C3 }
	condition:
		$1
}

rule file_933_0_0 {
	meta:
		name = "__wscanf"
		size = 160
		refs = "0070 stdin 0094 _IO_vfwscanf"
	strings:
		$1 = { 48 81 EC D8 00 00 00 84 C0 48 89 74 24 28 48 89 54 24 30 48 89 4C 24 38 4C 89 44 24 40 4C 89 4C 24 48 74 37 0F 29 44 24 50 0F 29 4C 24 60 0F 29 54 24 70 0F 29 9C 24 80 00 00 00 0F 29 A4 24 90 00 00 00 0F 29 AC 24 A0 00 00 00 0F 29 B4 24 B0 00 00 00 0F 29 BC 24 C0 00 00 00 48 8D 84 24 E0 00 00 00 48 89 FE 48 8D 54 24 08 31 C9 48 8B 3D ?? ?? ?? ?? 48 89 44 24 10 48 8D 44 24 20 C7 44 24 08 08 00 00 00 C7 44 24 0C 30 00 00 00 48 89 44 24 18 E8 ?? ?? ?? ?? 48 81 C4 D8 00 00 00 C3 }
	condition:
		$1
}

rule file_19_0_0 {
	meta:
		name = "fstatvfs"
		size = 135
		refs = "001f __fstatfs 003a __fxstat64 0050 __internal_statvfs"
	strings:
		$1 = { 48 89 5C 24 E8 4C 89 64 24 F8 49 89 F4 48 89 6C 24 F0 48 81 EC 28 01 00 00 89 FB 48 89 E6 E8 ?? ?? ?? ?? 85 C0 78 59 48 8D AC 24 80 00 00 00 89 DE BF 01 00 00 00 48 89 EA E8 ?? ?? ?? ?? 31 C9 83 F8 FF 48 89 E2 48 0F 45 CD 4C 89 E6 31 FF E8 ?? ?? ?? ?? 31 C0 48 8B 9C 24 10 01 00 00 48 8B AC 24 18 01 00 00 4C 8B A4 24 20 01 00 00 48 81 C4 28 01 00 00 C3 66 2E 0F 1F 84 00 00 00 00 00 B8 FF FF FF FF EB CF }
	condition:
		$1
}

rule file_20_0_0 {
	meta:
		name = "syscall"
		size = 38
		refs = "0021 __syscall_error"
	strings:
		$1 = { 48 89 F8 48 89 F7 48 89 D6 48 89 CA 4D 89 C2 4D 89 C8 4C 8B 4C 24 08 0F 05 48 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_21_0_0 {
	meta:
		name = "__strverscmp"
		size = 276
	strings:
		$1 = { 48 39 F7 0F 84 F7 00 00 00 0F B6 17 44 0F B6 06 45 31 C9 48 83 C7 01 48 83 C6 01 0F B6 C2 80 FA 30 8D 48 D0 41 0F 94 C1 83 F9 09 0F 96 C1 0F B6 C9 41 01 C9 41 0F B6 C8 29 C8 75 59 84 D2 75 10 E9 CD 00 00 00 0F 1F 00 84 D2 0F 84 A8 00 00 00 0F B6 17 4D 63 C9 44 0F B6 06 41 0F B6 89 ?? ?? ?? ?? 45 31 D2 48 83 C7 01 48 83 C6 01 0F B6 C2 80 FA 30 44 8D 48 D0 41 0F 94 C2 41 83 F9 09 41 0F 96 C1 45 0F B6 C9 45 01 D1 41 01 C9 41 0F B6 C8 29 C8 74 B3 43 8D 0C 49 45 31 C9 41 80 F8 30 41 0F 94 C1 41 83 E8 30 31 D2 41 83 F8 09 0F 96 C2 44 01 CA 01 CA 48 63 D2 0F B6 92 ?? ?? ?? ?? 80 FA 02 74 33 80 FA 03 74 06 0F BE C2 C3 66 90 0F B6 17 48 83 C7 01 83 EA 30 83 FA 09 0F B6 16 77 21 83 EA 30 48 83 C6 01 83 FA 09 76 E2 B8 01 00 00 00 0F 1F 44 00 00 F3 C3 66 0F 1F 44 00 00 31 C0 C3 83 EA 30 83 FA 09 BA FF FF FF FF 0F 46 C2 C3 F3 C3 }
	condition:
		$1
}

rule file_22_0_0 {
	meta:
		name = "_L_lock_13"
		size = 31
		refs = "000f __lll_lock_wait_private"
	strings:
		$1 = { 48 8D 3D ?? ?? ?? ?? 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 7C FF FF FF }
	condition:
		$1
}

rule file_22_1_0 {
	meta:
		name = "_L_unlock_33"
		size = 28
		refs = "000f __lll_unlock_wake_private"
	strings:
		$1 = { 48 8D 3D ?? ?? ?? ?? 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 EB B9 }
	condition:
		$1
}

rule file_22_2_0 {
	meta:
		name = "getnetent"
		size = 142
		refs = "000d __libc_multiple_threads 002c __libc_h_errno 004f __getnetent_r 0054 __nss_getent 005b __libc_errno"
	strings:
		$1 = { 48 83 EC 08 BE 01 00 00 00 31 C0 83 3D ?? ?? ?? ?? 00 74 0C F0 0F B1 35 ?? ?? ?? ?? 75 70 EB 09 0F B1 35 ?? ?? ?? ?? 75 65 4C 8B 0D ?? ?? ?? ?? 64 4C 03 0C 25 00 00 00 00 41 B8 ?? ?? ?? ?? B9 00 04 00 00 BA ?? ?? ?? ?? BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 15 ?? ?? ?? ?? 48 89 C6 64 44 8B 02 83 3D ?? ?? ?? ?? 00 74 0B F0 FF 0D ?? ?? ?? ?? 75 35 EB 08 FF 0D ?? ?? ?? ?? 75 2B 64 44 89 02 48 89 F0 48 83 C4 08 C3 }
	condition:
		$1
}

rule file_310_2_0 {
	meta:
		name = "gethostent"
		size = 142
		refs = "000d __libc_multiple_threads 002c __libc_h_errno 004f __gethostent_r 0054 __nss_getent 005b __libc_errno"
	strings:
		$1 = { 48 83 EC 08 BE 01 00 00 00 31 C0 83 3D ?? ?? ?? ?? 00 74 0C F0 0F B1 35 ?? ?? ?? ?? 75 70 EB 09 0F B1 35 ?? ?? ?? ?? 75 65 4C 8B 0D ?? ?? ?? ?? 64 4C 03 0C 25 00 00 00 00 41 B8 ?? ?? ?? ?? B9 00 04 00 00 BA ?? ?? ?? ?? BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 15 ?? ?? ?? ?? 48 89 C6 64 44 8B 02 83 3D ?? ?? ?? ?? 00 74 0B F0 FF 0D ?? ?? ?? ?? 75 35 EB 08 FF 0D ?? ?? ?? ?? 75 2B 64 44 89 02 48 89 F0 48 83 C4 08 C3 }
	condition:
		$1
}

rule file_23_0_0 {
	meta:
		name = "__dup2"
		size = 20
		refs = "000f __syscall_error"
	strings:
		$1 = { B8 21 00 00 00 0F 05 48 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_24_0_0 {
	meta:
		name = "__wctrans"
		size = 133
		refs = "000d _nl_current_LC_CTYPE 003a __rawmemchr 004f strcmp"
	strings:
		$1 = { 41 55 41 54 55 53 48 83 EC 08 48 8B 05 ?? ?? ?? ?? 64 48 8B 00 4C 8B 28 49 8B 9D 98 00 00 00 80 3B 00 74 54 49 89 FC 31 ED EB 1D 0F 1F 44 00 00 31 F6 48 89 DF 48 83 C5 01 E8 ?? ?? ?? ?? 80 78 01 00 48 8D 58 01 74 30 48 89 DE 4C 89 E7 E8 ?? ?? ?? ?? 85 C0 75 D9 41 8B 85 D0 00 00 00 48 8D 44 05 08 49 8B 44 C5 00 48 83 C4 08 5B 5D 41 5C 41 5D C3 0F 1F 44 00 00 48 83 C4 08 31 C0 5B 5D 41 5C 41 5D C3 }
	condition:
		$1
}

rule file_25_0_0 {
	meta:
		name = "critical_factorization"
		size = 369
		refs = "001b __libc_tsd_CTYPE_TOLOWER"
	strings:
		$1 = { 41 56 B9 01 00 00 00 49 89 D6 45 31 C0 49 C7 C3 FF FF FF FF 41 55 41 54 4C 8B 25 ?? ?? ?? ?? 55 BD 01 00 00 00 53 64 4D 8B 0C 24 0F 1F 44 00 00 4A 8D 04 01 48 39 F0 73 33 4E 8D 14 1F 0F B6 1C 07 45 0F B6 14 0A 43 0F B6 14 91 41 38 14 99 0F 83 9B 00 00 00 49 89 C0 B9 01 00 00 00 48 89 C5 4A 8D 04 01 4C 29 DD 48 39 F0 72 CD 64 4D 8B 14 24 49 89 2E 41 BD 01 00 00 00 41 B8 01 00 00 00 45 31 C9 48 C7 C0 FF FF FF FF 66 0F 1F 44 00 00 4B 8D 0C 08 48 39 CE 76 31 48 8D 1C 07 44 0F B6 24 0F 42 0F B6 1C 03 41 0F B6 14 9A 43 38 14 A2 76 5E 49 89 C9 41 B8 01 00 00 00 49 89 CD 4B 8D 0C 08 49 29 C5 48 39 CE 77 CF 48 83 C0 01 49 83 C3 01 4C 39 D8 73 06 49 89 ED 4C 89 D8 5B 5D 41 5C 4D 89 2E 41 5D 41 5E C3 0F 1F 80 00 00 00 00 74 3E 4D 89 C3 BD 01 00 00 00 49 83 C0 01 B9 01 00 00 00 E9 28 FF FF FF 0F 1F 84 00 00 00 00 00 74 2E 4C 89 C8 41 BD 01 00 00 00 49 83 C1 01 41 B8 01 00 00 00 E9 66 FF FF FF 66 0F 1F 44 00 00 48 39 E9 74 1B 48 83 C1 01 E9 F2 FE FF FF 66 90 4D 39 E8 74 1B 49 83 C0 01 E9 42 FF FF FF 66 90 48 89 CD 49 89 C0 B9 01 00 00 00 E9 D0 FE FF FF 4D 89 C5 49 89 C9 41 B8 01 00 00 00 E9 1F FF FF FF }
	condition:
		$1
}

rule file_25_1_0 {
	meta:
		name = "two_way_long_needle"
		size = 1110
		refs = "0052 __libc_tsd_CTYPE_TOLOWER 009c __strncasecmp 0151 memchr"
	strings:
		$1 = { 41 57 49 89 D7 41 56 41 55 49 89 FD 4C 89 FF 41 54 49 89 F4 48 89 CE 55 53 48 89 CB 48 81 EC 68 08 00 00 48 8D 54 24 58 E8 53 FE FF FF 48 8D 94 24 60 08 00 00 49 89 C6 48 8D 44 24 60 0F 1F 00 48 89 18 48 83 C0 08 48 39 D0 75 F4 48 85 DB 48 8B 2D ?? ?? ?? ?? 74 2D 64 48 8B 7D 00 48 8D 73 FF 31 C0 0F 1F 44 00 00 41 0F B6 14 07 48 89 F1 48 29 C1 48 83 C0 01 48 39 D8 48 63 14 97 48 89 4C D4 60 75 E3 48 8B 4C 24 58 4C 89 F2 4C 89 FF 48 89 CE 48 89 4C 24 18 4C 01 FE E8 ?? ?? ?? ?? 85 C0 0F 85 F4 01 00 00 49 8D 76 FF 48 89 DF 48 2B 7C 24 18 4C 89 F0 48 8D 4B FF 45 31 C0 48 89 74 24 20 4C 01 FE 48 F7 D8 49 89 F3 45 31 D2 48 C7 44 24 38 01 00 00 00 49 01 C3 48 89 7C 24 30 4C 29 74 24 38 4C 89 74 24 08 4C 89 E7 4D 89 EE 4C 89 7C 24 28 48 89 5C 24 10 4D 89 C5 64 48 8B 6D 00 4D 89 D7 48 89 CB 48 89 74 24 40 4D 89 DC 48 89 44 24 48 EB 22 66 0F 1F 84 00 00 00 00 00 4D 85 ED 74 0B 48 39 44 24 18 48 0F 47 44 24 30 49 01 C7 45 31 ED 48 89 CF 48 8B 4C 24 10 31 F6 4C 01 F9 48 89 CA 48 89 0C 24 48 29 FA 4C 01 F7 E8 ?? ?? ?? ?? 48 85 C0 48 8B 0C 24 0F 85 0C 01 00 00 48 85 C9 0F 84 05 01 00 00 41 0F B6 44 0E FF 48 63 44 85 00 48 8B 44 C4 60 48 85 C0 75 A0 4C 3B 6C 24 08 48 8B 44 24 08 4C 8B 4C 24 28 49 0F 43 C5 4A 8D 14 38 49 01 C1 4C 01 F2 48 39 D8 73 50 41 0F B6 39 0F B6 32 44 8B 44 B5 00 44 39 44 BD 00 0F 85 CF 00 00 00 48 89 C7 48 F7 DF 49 01 F9 48 01 D7 EB 22 66 0F 1F 84 00 00 00 00 00 41 0F B6 34 01 0F B6 14 07 44 8B 44 95 00 44 39 44 B5 00 0F 85 9F 00 00 00 48 83 C0 01 48 39 D8 72 DE 48 8B 44 24 20 49 89 C1 4D 01 F9 4D 01 F1 4C 3B 6C 24 08 0F 83 38 02 00 00 4C 8B 44 24 40 41 0F B6 11 4C 03 4C 24 48 41 0F B6 30 8B 7C 95 00 39 7C B5 00 74 26 E9 17 02 00 00 0F 1F 40 00 41 0F B6 34 04 41 0F B6 14 01 48 8D 78 FF 44 8B 44 95 00 44 39 44 B5 00 75 08 48 89 F8 4C 39 E8 75 DE 49 83 C5 01 49 39 C5 0F 87 EE 01 00 00 4C 03 7C 24 18 4C 8B 6C 24 30 E9 C8 FE FF FF 31 C0 48 81 C4 68 08 00 00 5B 5D 41 5C 41 5D 41 5E 41 5F C3 66 0F 1F 44 00 00 4C 8B 54 24 38 45 31 ED 4D 01 FA 4D 8D 3C 02 E9 9A FE FF FF 4D 8D 46 FF 48 89 D8 4B 8D 0C 37 4C 29 F0 41 BA 01 00 00 00 4C 89 74 24 08 4C 39 F0 4D 89 C3 4C 89 44 24 18 4D 89 F0 49 0F 42 C6 48 89 4C 24 20 49 F7 D8 48 8D 4B FF 48 83 C0 01 4C 89 44 24 28 4C 8B 44 24 20 4D 01 FB 4C 03 44 24 28 4D 29 F2 45 31 C9 4C 89 E7 48 89 44 24 40 4D 89 EC 48 89 44 24 58 64 48 8B 6D 00 4D 89 CD 48 89 5C 24 10 49 89 CF 4D 89 DE 4C 89 54 24 30 4C 89 44 24 38 EB 08 66 90 49 01 C5 48 89 DF 48 8B 5C 24 10 31 F6 4C 01 EB 48 89 DA 48 29 FA 4C 01 E7 E8 ?? ?? ?? ?? 48 85 C0 0F 85 27 FF FF FF 48 85 DB 0F 84 20 FF FF FF 41 0F B6 44 1C FF 48 63 44 85 00 48 8B 44 C4 60 48 85 C0 75 BB 48 8B 7C 24 08 4C 01 EF 4C 01 E7 4C 39 7C 24 08 73 4D 48 8B 4C 24 20 0F B6 07 0F B6 11 8B 74 85 00 48 8B 44 24 08 39 74 95 00 0F 85 93 00 00 00 48 03 7C 24 28 4C 8B 44 24 38 EB 1A 0F 1F 80 00 00 00 00 41 0F B6 0C 00 0F B6 14 07 8B 74 95 00 39 74 8D 00 75 6D 48 83 C0 01 4C 39 F8 72 E4 48 8B 7C 24 18 4C 01 EF 4C 01 E7 48 83 7C 24 18 FF 74 3F 41 0F B6 16 0F B6 07 44 8B 44 85 00 44 39 44 95 00 75 4F 31 C0 4C 8B 54 24 30 EB 1E 0F 1F 44 00 00 41 0F B6 4C 06 FF 0F B6 54 07 FF 48 83 E8 01 8B 74 95 00 39 74 8D 00 75 28 4C 39 D0 75 E2 4D 89 E9 4B 8D 04 0C E9 4E FE FF FF 66 0F 1F 44 00 00 4C 8B 4C 24 30 4D 01 E9 4D 8D 2C 01 E9 EA FE FF FF 4C 03 6C 24 40 E9 E0 FE FF FF 48 8B 44 24 08 E9 05 FE FF FF 4B 8D 04 3E E9 1A FE FF FF }
	condition:
		$1
}

rule file_25_2_0 {
	meta:
		name = "__strcasestr"
		size = 1229
		refs = "0029 __libc_tsd_CTYPE_TOLOWER 00e1 __strncasecmp 017d memchr"
	strings:
		$1 = { 41 57 48 89 F8 49 89 F0 41 56 41 55 41 54 55 53 48 83 EC 78 0F B6 17 84 D2 0F 84 77 04 00 00 0F B6 0E 84 C9 74 70 48 8B 35 ?? ?? ?? ?? 4C 89 C5 41 B9 01 00 00 00 64 4C 8B 1E 48 89 FE EB 09 90 0F B6 4D 00 84 C9 74 27 41 8B 3C 8B 41 39 3C 93 0F 94 C2 48 83 C6 01 48 83 C5 01 41 21 D1 0F B6 16 84 D2 75 DB 80 7D 00 00 0F 85 11 02 00 00 45 84 C9 75 22 4C 29 C5 4C 8D 78 01 48 83 FD 1F 4C 8D 4D FF 76 23 48 89 E9 4C 89 C2 4C 89 CE 4C 89 FF E8 0A FB FF FF 48 83 C4 78 5B 5D 41 5C 41 5D 41 5E 41 5F C3 0F 1F 00 48 8D 54 24 68 4C 89 C7 48 89 EE 4C 89 4C 24 10 4C 89 04 24 E8 5F F9 FF FF 4C 8B 54 24 68 4C 8B 04 24 48 89 C2 48 89 44 24 08 4C 89 D6 4C 89 C7 4C 89 54 24 38 4C 01 C6 E8 ?? ?? ?? ?? 85 C0 4C 8B 04 24 4C 8B 4C 24 10 4C 8B 5C 24 08 0F 85 96 01 00 00 49 8D 4B FF 48 8B 05 ?? ?? ?? ?? 49 89 EA 4C 2B 54 24 38 48 C7 44 24 40 01 00 00 00 45 31 E4 48 89 4C 24 28 4C 01 C1 4C 29 5C 24 40 48 89 4C 24 48 4C 8B 6C 24 48 4C 89 D9 48 F7 D9 64 48 8B 18 49 89 EE 4C 89 54 24 58 49 01 CD 48 89 4C 24 50 4C 89 E8 4C 89 7C 24 18 4C 89 5C 24 20 4C 89 44 24 30 4D 89 E5 48 89 C5 0F 1F 44 00 00 4F 8D 3C 34 48 8B 7C 24 18 31 F6 4C 89 FA 4C 29 CA 4C 01 CF E8 ?? ?? ?? ?? 48 85 C0 0F 85 F6 00 00 00 4D 85 FF 0F 84 03 FF FF FF 4C 3B 6C 24 20 48 8B 44 24 20 4C 8B 4C 24 30 49 0F 43 C5 49 01 C1 4A 8D 3C 20 48 03 7C 24 18 49 39 C6 76 47 41 0F B6 31 0F B6 17 44 8B 14 93 44 39 14 B3 0F 85 44 02 00 00 48 89 C2 48 F7 DA 49 01 D1 48 01 D7 EB 1B 66 0F 1F 44 00 00 41 0F B6 0C 01 0F B6 14 07 8B 34 93 39 34 8B 0F 85 1B 02 00 00 48 83 C0 01 49 39 C6 77 E2 48 8B 44 24 28 49 89 C1 4D 01 E1 4C 03 4C 24 18 4C 39 6C 24 20 0F 86 73 02 00 00 4C 8B 54 24 48 41 0F B6 11 4C 03 4C 24 50 41 0F B6 32 8B 0C 93 39 0C B3 74 26 E9 54 02 00 00 0F 1F 84 00 00 00 00 00 0F B6 4C 05 00 41 0F B6 14 01 48 8D 70 FF 8B 3C 93 39 3C 8B 75 08 48 89 F0 4C 39 E8 75 E2 49 8D 4D 01 48 39 C1 0F 87 39 02 00 00 4C 03 64 24 38 4C 8B 6C 24 58 4D 89 F9 E9 EB FE FF FF 0F 1F 00 48 83 C4 78 31 C0 5B 5D 41 5C 41 5D 41 5E 41 5F C3 48 8B 05 ?? ?? ?? ?? 4F 8D 14 1F 41 BD 01 00 00 00 4C 89 5C 24 40 4C 89 54 24 20 4C 89 D1 4D 8D 53 01 64 48 8B 18 43 0F B6 04 18 4C 89 54 24 18 44 0F B6 34 83 48 89 E8 4C 29 D8 4C 39 D8 49 0F 42 C3 4D 01 C2 4D 29 DD 48 83 C0 01 4C 89 54 24 28 4C 8B 64 24 28 4D 8D 53 FF 48 89 44 24 48 48 89 44 24 68 4C 89 D8 48 F7 D8 4C 89 54 24 30 4D 01 C2 49 01 C4 45 89 F0 48 89 44 24 38 4D 89 EE 4D 89 E5 4D 89 FC 4D 89 D7 EB 0F 0F 1F 40 00 84 C0 0F 84 58 FF FF FF 48 89 F9 0F B6 01 48 8D 79 01 0F B6 04 83 41 38 C0 75 E5 48 2B 7C 24 20 48 8B 44 24 18 48 83 EF 01 48 39 C5 76 5B 0F B6 51 01 4C 8B 54 24 28 4C 8D 59 02 4C 03 5C 24 38 41 0F B6 0A 8B 14 93 89 D6 81 E2 FF 00 00 00 39 14 8B 74 2C E9 3F 01 00 00 0F 1F 80 00 00 00 00 41 0F B6 54 03 FE 41 0F B6 4C 05 FF 8B 14 93 89 D6 81 E2 FF 00 00 00 39 14 8B 0F 85 18 01 00 00 48 83 C0 01 48 39 C5 77 D7 48 8B 74 24 30 48 01 FE 4C 01 E6 48 83 7C 24 30 FF 74 49 0F B6 06 41 0F B6 17 8B 04 83 41 89 C3 25 FF 00 00 00 39 04 93 75 51 31 C0 EB 29 66 0F 1F 84 00 00 00 00 00 0F B6 54 06 FF 41 0F B6 4C 07 FF 48 83 E8 01 8B 14 93 41 89 D3 81 E2 FF 00 00 00 39 14 8B 75 24 4C 39 F0 75 DB 49 8D 04 3C E9 88 FC FF FF 66 90 4C 8B 54 24 40 45 31 ED 4D 01 E2 4D 8D 24 02 E9 51 FE FF FF 45 84 DB 0F 84 53 FE FF FF 4C 8B 5C 24 48 49 01 FB 49 8D 0C 2B 4B 8D 3C 0C 31 F6 44 88 04 24 4C 89 5C 24 08 48 89 CA 48 89 4C 24 10 4C 29 CA E8 ?? ?? ?? ?? 48 85 C0 48 8B 4C 24 10 44 0F B6 04 24 4C 8B 5C 24 08 0F 85 10 FE FF FF 48 85 C9 0F 84 07 FE FF FF 48 8B 7C 24 40 49 89 C9 4C 01 DF 4C 01 E7 E9 9C FE FF FF 48 8B 44 24 20 E9 C8 FD FF FF 48 89 F5 41 B9 01 00 00 00 E9 C1 FB FF FF 4C 8B 7C 24 18 4B 8D 04 27 E9 E4 FB FF FF 66 0F 1F 44 00 00 40 84 F6 0F 84 BF FD FF FF 4C 01 F7 4C 8D 1C 07 E9 68 FF FF FF }
	condition:
		$1
}

rule file_26_1_0 {
	meta:
		name = "__libc_csu_init"
		size = 137
		refs = "0004 __preinit_array_end 000b __preinit_array_start 004a __init_array_end 0053 __init_array_start 005c _init"
	strings:
		$1 = { 41 56 41 BE ?? ?? ?? ?? 49 81 EE ?? ?? ?? ?? 41 55 49 C1 FE 03 49 89 D5 41 54 49 89 F4 55 89 FD 53 31 DB 4D 85 F6 74 20 0F 1F 84 00 00 00 00 00 4C 89 EA 4C 89 E6 89 EF FF 14 DD ?? ?? ?? ?? 48 83 C3 01 4C 39 F3 75 E8 41 BE ?? ?? ?? ?? 31 DB 49 81 EE ?? ?? ?? ?? 49 C1 FE 03 E8 ?? ?? ?? ?? 4D 85 F6 74 1B 0F 1F 00 4C 89 EA 4C 89 E6 89 EF FF 14 DD ?? ?? ?? ?? 48 83 C3 01 4C 39 F3 75 E8 5B 5D 41 5C 41 5D 41 5E C3 }
	condition:
		$1
}

rule file_26_2_0 {
	meta:
		name = "__libc_csu_fini"
		size = 51
		refs = "0002 __fini_array_end 0009 __fini_array_start 002f _fini"
	strings:
		$1 = { 53 BB ?? ?? ?? ?? 48 81 EB ?? ?? ?? ?? 48 C1 FB 03 48 85 DB 74 17 66 2E 0F 1F 84 00 00 00 00 00 FF 14 DD ?? ?? ?? ?? 48 83 EB 01 75 F3 5B E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_27_0_0 {
	meta:
		name = "xdr_rmtcallres"
		size = 99
		refs = "0002 xdr_u_long 0024 xdr_reference"
	strings:
		$1 = { 55 B9 ?? ?? ?? ?? BA 08 00 00 00 48 89 FD 53 48 89 F3 48 83 EC 18 48 8B 06 48 8D 74 24 08 48 89 44 24 08 E8 ?? ?? ?? ?? 85 C0 75 0C 48 83 C4 18 31 C0 5B 5D C3 0F 1F 00 48 8D 73 08 48 89 EF E8 ?? ?? ?? ?? 85 C0 74 E4 48 8B 44 24 08 48 8B 73 10 48 89 EF 48 89 03 31 C0 FF 53 18 48 83 C4 18 5B 5D C3 }
	condition:
		$1
}

rule file_27_1_0 {
	meta:
		name = "xdr_rmtcall_args"
		size = 262
		refs = "0024 xdr_u_long"
	strings:
		$1 = { 48 89 5C 24 D8 48 89 6C 24 E0 48 89 FB 4C 89 64 24 E8 4C 89 6C 24 F0 48 89 F5 4C 89 74 24 F8 48 83 EC 38 E8 ?? ?? ?? ?? 85 C0 75 24 31 C0 48 8B 5C 24 10 48 8B 6C 24 18 4C 8B 64 24 20 4C 8B 6C 24 28 4C 8B 74 24 30 48 83 C4 38 C3 0F 1F 40 00 48 8D 75 08 48 89 DF E8 ?? ?? ?? ?? 85 C0 74 CC 48 8D 75 10 48 89 DF E8 ?? ?? ?? ?? 85 C0 74 BC 48 8B 43 08 48 89 DF 48 C7 44 24 08 00 00 00 00 FF 50 20 48 8D 74 24 08 48 89 DF 41 89 C4 E8 ?? ?? ?? ?? 85 C0 74 95 48 8B 43 08 48 89 DF FF 50 20 48 8B 75 20 41 89 C5 48 89 DF 31 C0 FF 55 28 85 C0 0F 84 74 FF FF FF 48 8B 43 08 48 89 DF FF 50 20 89 C2 41 89 C6 48 8B 43 08 4C 29 EA 44 89 E6 48 89 DF 48 89 55 18 FF 50 28 48 8D 75 18 48 89 DF E8 ?? ?? ?? ?? 85 C0 0F 84 3D FF FF FF 48 8B 43 08 44 89 F6 48 89 DF FF 50 28 B8 01 00 00 00 E9 28 FF FF FF }
	condition:
		$1
}

rule file_27_2_0 {
	meta:
		name = "pmap_rmtcall"
		size = 331
		refs = "0065 clntudp_create 008e xdr_rmtcallres 00f5 xdr_rmtcall_args"
	strings:
		$1 = { 48 89 5C 24 D0 48 89 6C 24 D8 48 89 FD 4C 89 64 24 E0 4C 89 6C 24 E8 49 89 CD 4C 89 74 24 F0 4C 89 7C 24 F8 48 81 EC B8 00 00 00 4C 89 44 24 18 48 8B 0D ?? ?? ?? ?? 4D 89 CC 4C 8B 05 ?? ?? ?? ?? 4C 8D 4C 24 2C 49 89 F7 49 89 D6 66 C7 47 02 00 6F BA 02 00 00 00 BE A0 86 01 00 C7 44 24 2C FF FF FF FF E8 ?? ?? ?? ?? 48 89 C3 B8 10 00 00 00 48 85 DB 0F 84 93 00 00 00 48 8B 44 24 18 48 8B 94 24 D0 00 00 00 4C 8D 4C 24 30 41 B8 ?? ?? ?? ?? 48 8D 4C 24 50 BE 05 00 00 00 48 89 DF 4C 89 7C 24 50 4C 89 74 24 58 48 89 44 24 78 48 8B 84 24 E0 00 00 00 4C 89 6C 24 60 4C 89 64 24 70 48 89 44 24 30 48 8B 84 24 C8 00 00 00 48 89 44 24 40 48 8B 84 24 C0 00 00 00 48 89 44 24 48 48 8B 43 08 48 89 14 24 48 8B 94 24 D8 00 00 00 48 89 54 24 08 BA ?? ?? ?? ?? FF 10 48 8B 53 08 48 89 DF 89 44 24 10 FF 52 20 8B 44 24 10 66 C7 45 02 00 00 48 8B 9C 24 88 00 00 00 48 8B AC 24 90 00 00 00 4C 8B A4 24 98 00 00 00 4C 8B AC 24 A0 00 00 00 4C 8B B4 24 A8 00 00 00 4C 8B BC 24 B0 00 00 00 48 81 C4 B8 00 00 00 C3 }
	condition:
		$1
}

rule file_27_3_0 {
	meta:
		name = "clnt_broadcast"
		size = 1452
		refs = "0029 authunix_create_default 0048 __socket 0078 __setsockopt 0095 getifaddrs 0111 freeifaddrs 0136 _create_xid 0239 xdrmem_create 024e xdr_callmsg 026b _libc_intl_domainname 0276 __dcgettext 027e perror 0285 __close 02c1 xdr_rmtcall_args 0353 __sendto 039a _null_auth 03b3 xdr_rmtcallres 03eb __poll 0444 __recvfrom 044f __libc_errno 04e1 xdr_replymsg 0519 xdr_void"
	strings:
		$1 = { 41 57 41 56 49 89 F6 41 55 49 89 D5 41 54 4D 89 C4 55 53 48 81 EC 88 29 00 00 48 89 3C 24 48 89 4C 24 08 4C 89 4C 24 10 E8 ?? ?? ?? ?? BA 11 00 00 00 BE 02 00 00 00 BF 02 00 00 00 48 89 C3 C7 44 24 2C 01 00 00 00 E8 ?? ?? ?? ?? 85 C0 89 C5 BA 05 00 00 00 BE ?? ?? ?? ?? 0F 88 0A 02 00 00 48 8D 4C 24 2C 41 B8 04 00 00 00 BA 06 00 00 00 BE 01 00 00 00 89 C7 E8 ?? ?? ?? ?? 85 C0 0F 88 DC 01 00 00 48 8D 7C 24 48 89 6C 24 30 66 C7 44 24 34 01 00 E8 ?? ?? ?? ?? 85 C0 0F 85 CF 02 00 00 48 8B 7C 24 48 48 85 FF 0F 84 D1 03 00 00 48 89 F8 45 31 FF EB 17 66 0F 1F 84 00 00 00 00 00 41 83 FF 13 48 8B 00 7F 47 48 85 C0 74 42 8B 50 10 83 E2 03 83 FA 03 75 E7 48 8B 50 18 48 85 D2 74 DE 66 83 3A 02 75 D8 48 8B 48 28 49 63 D7 41 83 C7 01 41 83 FF 13 48 8B 00 8B 49 04 89 8C 94 F0 00 00 00 7E C3 66 2E 0F 1F 84 00 00 00 00 00 E8 ?? ?? ?? ?? 48 C7 44 24 50 00 00 00 00 48 C7 44 24 58 00 00 00 00 66 C7 44 24 50 02 00 66 C7 44 24 52 00 6F E8 ?? ?? ?? ?? 48 C7 84 24 68 01 00 00 05 00 00 00 48 C7 84 24 60 01 00 00 02 00 00 00 48 8D B4 24 A0 01 00 00 48 C7 84 24 58 01 00 00 A0 86 01 00 48 C7 84 24 50 01 00 00 02 00 00 00 48 8D BC 24 90 00 00 00 48 89 44 24 18 48 89 84 24 40 01 00 00 31 C9 48 8B 03 48 8B 54 24 08 C7 84 24 48 01 00 00 00 00 00 00 48 89 84 24 70 01 00 00 48 8B 43 08 4C 89 B4 24 C8 00 00 00 48 89 84 24 78 01 00 00 48 8B 43 10 4C 89 AC 24 D0 00 00 00 48 89 84 24 80 01 00 00 48 8B 43 18 48 89 84 24 88 01 00 00 48 8B 43 20 4C 89 A4 24 E0 00 00 00 48 89 84 24 90 01 00 00 48 8B 43 28 48 89 94 24 E8 00 00 00 48 8B 94 24 C0 29 00 00 48 89 84 24 98 01 00 00 48 8B 04 24 48 89 94 24 80 00 00 00 BA 78 05 00 00 48 89 84 24 C0 00 00 00 48 8D 44 24 40 48 89 44 24 70 48 8B 44 24 10 48 89 84 24 88 00 00 00 E8 ?? ?? ?? ?? 48 8D B4 24 40 01 00 00 48 8D BC 24 90 00 00 00 E8 ?? ?? ?? ?? 85 C0 75 5A 41 BC 01 00 00 00 EB 24 66 90 BA 05 00 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? 41 BC 03 00 00 00 E8 ?? ?? ?? ?? 48 89 C7 E8 ?? ?? ?? ?? 89 EF E8 ?? ?? ?? ?? 48 8B 53 38 48 89 DF FF 52 20 48 81 C4 88 29 00 00 44 89 E0 5B 5D 41 5C 41 5D 41 5E 41 5F C3 0F 1F 84 00 00 00 00 00 48 8D B4 24 C0 00 00 00 48 8D BC 24 90 00 00 00 E8 ?? ?? ?? ?? 85 C0 74 8D 48 8B 84 24 98 00 00 00 48 8D BC 24 90 00 00 00 FF 50 20 89 44 24 08 48 8B 84 24 98 00 00 00 48 8B 40 38 48 85 C0 74 0A 48 8D BC 24 90 00 00 00 FF D0 41 8D 47 FF C7 04 24 A0 0F 00 00 4C 8D AC 84 F4 00 00 00 45 85 FF 74 75 4C 63 64 24 08 4C 8D B4 24 F0 00 00 00 EB 0F 66 0F 1F 44 00 00 49 83 C6 04 4D 39 EE 74 57 41 8B 06 4C 8D 44 24 50 48 8D B4 24 A0 01 00 00 31 C9 41 B9 10 00 00 00 4C 89 E2 89 EF 89 44 24 54 E8 ?? ?? ?? ?? 4C 39 E0 74 CC BA 05 00 00 00 BE ?? ?? ?? ?? E9 FF FE FF FF 0F 1F 44 00 00 BF ?? ?? ?? ?? 45 31 FF E8 ?? ?? ?? ?? E9 93 FD FF FF 66 0F 1F 44 00 00 48 83 BC 24 C8 29 00 00 00 0F 84 C8 01 00 00 48 8B 05 ?? ?? ?? ?? 8B 14 24 48 8D 7C 24 30 BE 01 00 00 00 48 C7 84 24 80 01 00 00 ?? ?? ?? ?? 48 89 84 24 58 01 00 00 48 8B 05 ?? ?? ?? ?? 48 89 84 24 60 01 00 00 48 8B 05 ?? ?? ?? ?? 48 89 84 24 68 01 00 00 48 8D 44 24 70 48 89 84 24 78 01 00 00 E8 ?? ?? ?? ?? 83 F8 FF 0F 84 90 00 00 00 85 C0 75 24 81 04 24 D0 07 00 00 81 3C 24 80 3E 00 00 0F 85 FE FE FF FF 41 BC 05 00 00 00 E9 67 FE FF FF 0F 1F 44 00 00 4C 8D 4C 24 28 4C 8D 44 24 60 48 8D B4 24 20 07 00 00 31 C9 BA 60 22 00 00 89 EF C7 44 24 28 10 00 00 00 E8 ?? ?? ?? ?? 85 C0 79 5C 48 8B 15 ?? ?? ?? ?? 64 83 3A 04 74 C7 BA 05 00 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? 41 BC 04 00 00 00 E8 ?? ?? ?? ?? 48 89 C7 E8 ?? ?? ?? ?? E9 02 FE FF FF 45 31 FF E9 88 FC FF FF 48 8B 05 ?? ?? ?? ?? 64 83 38 04 0F 84 FE FE FF FF BA 05 00 00 00 BE ?? ?? ?? ?? EB BE 0F 1F 00 83 F8 07 0F 86 E6 FE FF FF 48 8D B4 24 20 07 00 00 48 8D BC 24 90 00 00 00 B9 01 00 00 00 89 C2 45 31 E4 E8 ?? ?? ?? ?? 48 8D B4 24 40 01 00 00 48 8D BC 24 90 00 00 00 E8 ?? ?? ?? ?? 85 C0 74 0D 8B 54 24 18 39 94 24 40 01 00 00 74 71 48 8D B4 24 40 01 00 00 48 8D BC 24 90 00 00 00 C7 84 24 90 00 00 00 02 00 00 00 48 C7 84 24 80 01 00 00 ?? ?? ?? ?? E8 ?? ?? ?? ?? 31 C0 48 8B B4 24 C0 29 00 00 48 8D BC 24 90 00 00 00 48 8B 54 24 10 FF D2 48 8B 84 24 98 00 00 00 48 8B 40 38 48 85 C0 74 0A 48 8D BC 24 90 00 00 00 FF D0 45 85 E4 0F 84 38 FE FF FF 45 31 E4 E9 1B FD FF FF 83 BC 24 50 01 00 00 00 75 85 83 BC 24 70 01 00 00 00 0F 85 77 FF FF FF 0F B7 44 24 40 48 8D 74 24 60 48 8B BC 24 C0 29 00 00 66 C1 C8 08 48 8B 94 24 C8 29 00 00 66 89 44 24 62 FF D2 41 89 C4 E9 4A FF FF FF }
	condition:
		$1
}

rule file_28_0_0 {
	meta:
		name = "compute_tzname_max"
		size = 74
		refs = "0032 __tzname_cur_max"
	strings:
		$1 = { 48 8B 15 ?? ?? ?? ?? 48 8D 0C 3A 0F 1F 44 00 00 80 3A 00 48 89 D0 74 27 0F 1F 84 00 00 00 00 00 48 83 C0 01 80 38 00 75 F7 48 89 C6 48 29 D6 48 39 35 ?? ?? ?? ?? 73 07 48 89 35 ?? ?? ?? ?? 48 8D 50 01 48 39 CA 72 C8 F3 C3 }
	condition:
		$1
}

rule file_28_1_0 {
	meta:
		name = "__tzfile_read"
		size = 3730
		refs = "001d __use_tzfile 0047 __libc_enable_secure 0066 getenv 009a strlen 00cf mempcpy 00e4 memcpy 00fd __xstat64 0112 _IO_new_fopen 0126 fileno 0139 __fxstat64 0153 free 01a5 fread_unlocked 01c5 memcmp 0269 fseek 0279 _IO_new_fclose 02bb strstr 0450 malloc 08de __tzstring 08f5 __tzname 09ce __daylight 09d5 __timezone 0b83 ftello 0cd4 __uflow 0e1c __assert_fail"
	strings:
		$1 = { 55 48 89 E5 41 57 41 56 41 55 41 54 49 89 F4 53 48 81 EC 18 01 00 00 48 85 FF 44 8B 35 ?? ?? ?? ?? 48 89 95 F8 FE FF FF C7 05 ?? ?? ?? ?? 00 00 00 00 0F 84 48 03 00 00 44 0F B6 2F 45 84 ED 0F 84 38 02 00 00 8B 05 ?? ?? ?? ?? 48 89 FB 85 C0 0F 85 52 02 00 00 41 80 FD 2F 0F 84 88 00 00 00 BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 85 C0 74 09 80 38 00 0F 85 A8 02 00 00 BA 13 00 00 00 41 BD 14 00 00 00 BE ?? ?? ?? ?? 48 89 DF 48 89 95 E8 FE FF FF 48 89 B5 E0 FE FF FF E8 ?? ?? ?? ?? 44 8D 78 01 48 8B 95 E8 FE FF FF 48 8B B5 E0 FE FF FF 45 01 FD 49 83 C5 1E 49 C1 ED 04 49 C1 E5 04 4C 29 EC 4C 8D 6C 24 0F 49 83 E5 F0 4C 89 EF E8 ?? ?? ?? ?? 48 8D 78 01 48 89 DE C6 00 2F 44 89 FA 4C 89 EB E8 ?? ?? ?? ?? 45 85 F6 74 1C 48 8D 95 40 FF FF FF 48 89 DE BF 01 00 00 00 E8 ?? ?? ?? ?? 85 C0 0F 84 C7 01 00 00 48 89 DF BE ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 85 C0 48 89 C3 0F 84 5B 01 00 00 48 89 C7 E8 ?? ?? ?? ?? 48 8D 95 40 FF FF FF 89 C6 BF 01 00 00 00 E8 ?? ?? ?? ?? 85 C0 0F 85 30 01 00 00 48 8B 3D ?? ?? ?? ?? 41 BE 04 00 00 00 E8 ?? ?? ?? ?? 48 8B 85 40 FF FF FF 48 C7 05 ?? ?? ?? ?? 00 00 00 00 48 89 05 ?? ?? ?? ?? 48 8B 85 48 FF FF FF 48 89 05 ?? ?? ?? ?? 48 8B 45 98 81 0B 00 80 00 00 48 89 05 ?? ?? ?? ?? 90 48 8D BD 10 FF FF FF 48 89 D9 BA 01 00 00 00 BE 2C 00 00 00 E8 ?? ?? ?? ?? 48 83 F8 01 0F 85 C2 00 00 00 48 8D BD 10 FF FF FF BA 04 00 00 00 BE ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 0F 85 A4 00 00 00 8B 85 30 FF FF FF 8B 95 34 FF FF FF 41 83 FE 04 8B 8D 2C FF FF FF 44 8B AD 38 FF FF FF 44 8B 95 28 FF FF FF 44 8B BD 24 FF FF FF 0F C8 0F CA 0F C9 48 98 48 63 D2 41 0F CD 48 63 C9 41 0F CA 41 0F CF 48 89 05 ?? ?? ?? ?? 48 89 15 ?? ?? ?? ?? 4D 63 ED 48 89 0D ?? ?? ?? ?? 4D 63 D2 4D 63 FF 0F 85 53 01 00 00 80 BD 14 FF FF FF 00 0F 84 46 01 00 00 4D 01 D5 48 8D 04 80 48 89 DF 4D 01 EF 41 B6 08 49 01 C7 48 8D 04 52 BA 01 00 00 00 49 8D 04 47 48 8D 34 C8 E8 ?? ?? ?? ?? 85 C0 0F 84 1B FF FF FF 48 89 DF E8 ?? ?? ?? ?? 48 8B 3D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 C7 05 ?? ?? ?? ?? 00 00 00 00 48 8D 65 D8 5B 41 5C 41 5D 41 5E 41 5F 5D C3 0F 1F 44 00 00 41 80 FD 2F 0F 84 96 00 00 00 BE ?? ?? ?? ?? 48 89 DF E8 ?? ?? ?? ?? 48 85 C0 75 B9 E9 8D FD FF FF 0F 1F 80 00 00 00 00 48 8B 05 ?? ?? ?? ?? 48 39 85 48 FF FF FF 0F 85 25 FE FF FF 48 8B 15 ?? ?? ?? ?? 48 39 95 40 FF FF FF 0F 85 11 FE FF FF 48 8B 0D ?? ?? ?? ?? 48 39 4D 98 0F 85 00 FE FF FF C7 05 ?? ?? ?? ?? 01 00 00 00 E9 7C FF FF FF 0F 1F 84 00 00 00 00 00 48 89 C7 48 89 85 E0 FE FF FF E8 ?? ?? ?? ?? 48 8B B5 E0 FE FF FF 44 8D 68 01 89 C2 E9 47 FD FF FF 0F 1F 80 00 00 00 00 BA 0F 00 00 00 BE ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 0F 84 53 FF FF FF BA 13 00 00 00 BE ?? ?? ?? ?? 48 89 DF E8 ?? ?? ?? ?? 85 C0 0F 84 39 FF FF FF E9 FF FE FF FF 66 90 BB ?? ?? ?? ?? E9 5E FD FF FF 48 BE 70 1C C7 71 1C C7 71 1C 48 39 F0 0F 87 D8 FE FF FF 4C 8D 44 C0 07 49 83 E0 F8 4C 89 C0 48 F7 D0 48 C1 E8 04 48 39 D0 0F 82 BC FE FF FF 48 C1 E2 04 49 8D 34 10 48 89 F0 48 F7 D0 4C 39 E8 0F 82 A5 FE FF FF 4C 01 EE 48 83 FE F8 0F 87 98 FE FF FF 48 83 C6 07 48 83 E6 F8 48 89 F0 48 F7 D0 48 C1 E8 04 48 39 C8 0F 82 7D FE FF FF 48 89 CA 48 C1 E2 04 48 01 F2 41 83 FE 08 0F 84 49 07 00 00 48 89 D0 48 C7 85 F0 FE FF FF 00 00 00 00 48 F7 D0 48 2B 85 F0 FE FF FF 4C 39 E0 0F 82 48 FE FF FF 48 8B BD F0 FE FF FF 4C 01 E2 48 89 B5 E0 FE FF FF 4C 89 85 D0 FE FF FF 4C 89 95 C8 FE FF FF 48 01 D7 E8 ?? ?? ?? ?? 48 85 C0 48 89 05 ?? ?? ?? ?? 48 8B B5 E0 FE FF FF 4C 8B 85 D0 FE FF FF 4C 8B 95 C8 FE FF FF 0F 84 FC FD FF FF 48 8B 15 ?? ?? ?? ?? 49 01 C0 48 01 C6 4C 89 05 ?? ?? ?? ?? 48 89 35 ?? ?? ?? ?? 48 8D 0C D0 48 89 0D ?? ?? ?? ?? 48 8B 0D ?? ?? ?? ?? 48 C1 E1 04 4C 01 C1 41 83 FE 08 48 89 0D ?? ?? ?? ?? 0F 84 25 06 00 00 48 C7 05 ?? ?? ?? ?? 00 00 00 00 4D 85 E4 74 18 48 8B 0D ?? ?? ?? ?? 48 C1 E1 04 48 01 F1 48 8B B5 F8 FE FF FF 48 89 0E 41 83 FE 08 48 89 D9 0F 85 2D 09 00 00 BE 09 00 00 00 48 89 C7 4C 89 95 C8 FE FF FF E8 ?? ?? ?? ?? 48 8B 35 ?? ?? ?? ?? 4C 8B 95 C8 FE FF FF 48 39 F0 0F 85 57 FD FF FF 48 85 F6 0F 84 77 05 00 00 48 8B 0D ?? ?? ?? ?? 48 8B 3D ?? ?? ?? ?? 0F B6 01 48 39 F8 0F 83 34 FD FF FF 48 8D 41 01 48 01 F1 EB 16 66 0F 1F 44 00 00 0F B6 10 48 83 C0 01 48 39 D7 0F 86 15 FD FF FF 48 39 C8 75 EB 41 83 FE 04 0F 84 40 05 00 00 48 8B 05 ?? ?? ?? ?? 48 8D 0C F0 66 0F 1F 44 00 00 48 8B 10 48 83 C0 08 48 0F CA 48 89 50 F8 48 39 C8 75 ED 4C 8D 85 00 FF FF FF 31 C9 48 85 FF 49 8D 70 04 0F 84 B3 00 00 00 0F 1F 80 00 00 00 00 48 8B 53 08 48 8B 7B 10 4D 89 C4 48 39 D7 0F 86 F0 06 00 00 0F B6 02 48 83 C2 01 48 89 53 08 41 88 04 24 49 83 C4 01 49 39 F4 75 DF 48 39 D7 0F 86 D0 07 00 00 0F B6 02 48 83 C2 01 48 89 53 08 83 F8 01 0F 87 7C FC FF FF 48 8B 15 ?? ?? ?? ?? 49 89 CC 49 C1 E4 04 42 88 44 22 08 48 8B 53 08 48 3B 53 10 0F 83 56 07 00 00 0F B6 02 48 83 C2 01 48 89 53 08 48 63 D0 49 39 D5 0F 82 44 FC FF FF 4C 03 25 ?? ?? ?? ?? 48 83 C1 01 48 39 0D ?? ?? ?? ?? 41 88 44 24 09 8B 85 00 FF FF FF 0F C8 48 98 49 89 04 24 0F 87 54 FF FF FF 48 8B 3D ?? ?? ?? ?? 48 89 D9 4C 89 EA BE 01 00 00 00 4C 89 95 C8 FE FF FF E8 ?? ?? ?? ?? 49 39 C5 4C 8B 95 C8 FE FF FF 0F 85 EB FB FF FF 48 83 3D ?? ?? ?? ?? 00 0F 84 ED 00 00 00 4C 8D 85 00 FF FF FF 49 63 C6 45 31 E4 48 89 85 F8 FE FF FF 45 31 DB 4D 8D 48 04 0F 1F 44 00 00 48 8B 95 F8 FE FF FF 4C 89 C7 48 89 D9 BE 01 00 00 00 4C 89 85 D0 FE FF FF 4C 89 8D D8 FE FF FF 4C 89 95 C8 FE FF FF 4C 89 9D E0 FE FF FF E8 ?? ?? ?? ?? 48 3B 85 F8 FE FF FF 4C 8B 85 D0 FE FF FF 4C 8B 8D D8 FE FF FF 4C 8B 95 C8 FE FF FF 4C 8B 9D E0 FE FF FF 0F 85 61 FB FF FF 41 83 FE 04 0F 84 C2 02 00 00 48 8B 85 00 FF FF FF 48 8B 15 ?? ?? ?? ?? 48 0F C8 4A 89 04 22 4C 89 C2 48 8B 4B 08 48 3B 4B 10 0F 83 CC 05 00 00 0F B6 01 48 83 C1 01 48 89 4B 08 88 02 48 83 C2 01 4C 39 CA 75 DC 8B 85 00 FF FF FF 48 8B 15 ?? ?? ?? ?? 49 83 C3 01 0F C8 48 98 4A 89 44 22 08 49 83 C4 10 4C 39 1D ?? ?? ?? ?? 0F 87 33 FF FF FF 45 31 E4 4D 85 D2 74 39 0F 1F 00 48 8B 53 08 48 3B 53 10 0F 83 D0 06 00 00 0F B6 02 48 83 C2 01 48 89 53 08 4C 89 E2 48 C1 E2 04 48 03 15 ?? ?? ?? ?? 85 C0 0F 95 42 0A 49 83 C4 01 4D 39 D4 75 CA 48 8B 0D ?? ?? ?? ?? 4C 39 E1 76 2A 48 8B 15 ?? ?? ?? ?? 48 89 CE 49 C1 E4 04 48 C1 E6 04 4A 8D 44 22 0A 48 8D 54 32 0A 66 90 C6 00 00 48 83 C0 10 48 39 D0 75 F4 45 31 E4 4D 85 FF 74 41 0F 1F 40 00 48 8B 53 08 48 3B 53 10 0F 83 42 06 00 00 0F B6 02 48 83 C2 01 48 89 53 08 4C 89 E2 48 C1 E2 04 48 03 15 ?? ?? ?? ?? 85 C0 0F 95 42 0B 49 83 C4 01 4D 39 FC 75 CA 48 8B 0D ?? ?? ?? ?? 4C 39 E1 76 2A 48 8B 15 ?? ?? ?? ?? 49 C1 E4 04 48 C1 E1 04 4A 8D 44 22 0B 48 8D 54 0A 0B 0F 1F 44 00 00 C6 00 00 48 83 C0 10 48 39 D0 75 F4 48 83 3D ?? ?? ?? ?? 00 74 2D 48 8B 53 08 48 3B 53 10 0F 83 6E 05 00 00 0F B6 02 48 83 C2 01 48 89 53 08 83 F8 0A 0F 84 60 02 00 00 48 C7 05 ?? ?? ?? ?? 00 00 00 00 48 89 DF E8 ?? ?? ?? ?? 48 83 3D ?? ?? ?? ?? 00 74 2E 31 DB 90 48 89 D8 48 83 C3 01 48 C1 E0 04 48 03 05 ?? ?? ?? ?? 0F B6 78 09 48 03 3D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 39 1D ?? ?? ?? ?? 77 D5 48 8B 1D ?? ?? ?? ?? 48 C7 05 ?? ?? ?? ?? 00 00 00 00 48 C7 05 ?? ?? ?? ?? 00 00 00 00 48 85 DB 0F 84 3F 03 00 00 41 BE 01 00 00 00 EB 0C 0F 1F 80 00 00 00 00 48 85 DB 74 58 48 8B 05 ?? ?? ?? ?? 48 83 EB 01 0F B6 04 18 48 C1 E0 04 48 03 05 ?? ?? ?? ?? 44 0F B6 60 08 4D 63 FC 4A 83 3C FD ?? ?? ?? ?? 00 75 CE 0F B6 78 09 48 03 3D ?? ?? ?? ?? E8 ?? ?? ?? ?? 4A 89 04 FD ?? ?? ?? ?? 44 89 F0 44 29 E0 48 98 48 83 3C C5 ?? ?? ?? ?? 00 74 A3 48 8B 05 ?? ?? ?? ?? 48 85 C0 0F 84 C3 02 00 00 48 83 3D ?? ?? ?? ?? 00 0F 84 DB 02 00 00 4C 89 EF E8 0D F6 FF FF 48 8B 05 ?? ?? ?? ?? 48 85 C0 75 4B 48 8B 05 ?? ?? ?? ?? 31 D2 48 8B 00 48 89 05 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 48 F7 D8 89 15 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? E9 2B F9 FF FF 66 90 8B 85 00 FF FF FF 48 8B 15 ?? ?? ?? ?? 0F C8 48 98 4A 89 04 22 E9 39 FD FF FF 48 C7 05 ?? ?? ?? ?? 00 00 00 00 48 C7 05 ?? ?? ?? ?? 00 00 00 00 45 31 D2 4C 8B 05 ?? ?? ?? ?? 48 8B 3D ?? ?? ?? ?? 45 31 C9 31 D2 31 C9 EB 25 0F B6 74 07 FF 48 C1 E6 04 4C 01 C6 80 7E 08 00 75 17 4C 8B 0E B1 01 85 CA 0F 85 40 02 00 00 48 83 E8 01 74 28 85 C9 74 D7 85 D2 75 19 0F B6 74 07 FF 48 C1 E6 04 4C 01 C6 80 7E 08 00 74 E0 4C 8B 16 B2 01 EB D1 BA 01 00 00 00 EB CA 85 D2 4C 89 0D ?? ?? ?? ?? 4C 89 15 ?? ?? ?? ?? 4C 89 C8 0F 85 17 02 00 00 4C 89 0D ?? ?? ?? ?? 31 D2 E9 2B FF FF FF 41 83 FE 04 48 8B 3D ?? ?? ?? ?? 0F 85 E4 FA FF FF 48 85 F6 48 8D 46 FF 0F 84 D7 FA FF FF 48 8B 0D ?? ?? ?? ?? 0F 1F 44 00 00 8B 14 81 0F CA 48 63 D2 48 89 14 C1 48 83 E8 01 48 83 F8 FF 75 EA E9 B0 FA FF FF 48 8B 0D ?? ?? ?? ?? 48 C1 E1 04 4C 01 E1 48 01 F1 48 89 0D ?? ?? ?? ?? E9 C9 F9 FF FF 4C 8B A5 F0 FE FF FF 48 8B 3D ?? ?? ?? ?? 48 89 D9 BE 01 00 00 00 49 83 EC 01 4C 89 E2 E8 ?? ?? ?? ?? 49 39 C4 0F 85 75 FD FF FF 48 8B 05 ?? ?? ?? ?? 48 8B 95 F0 FE FF FF 48 85 C0 C6 44 10 FF 00 0F 84 64 FD FF FF 80 38 00 0F 85 5B FD FF FF E9 4B FD FF FF 48 8B 8D 70 FF FF FF 48 89 DF 48 89 95 E8 FE FF FF 48 89 B5 E0 FE FF FF 4C 89 85 D0 FE FF FF 4C 89 95 C8 FE FF FF 48 89 8D F0 FE FF FF E8 ?? ?? ?? ?? 48 8B 8D F0 FE FF FF 48 8B 95 E8 FE FF FF 48 8B B5 E0 FE FF FF 4C 8B 85 D0 FE FF FF 4C 8B 95 C8 FE FF FF 48 29 C1 48 89 C8 0F 88 BF F6 FF FF 48 8B 0D ?? ?? ?? ?? 48 8D 3C 49 48 8B 0D ?? ?? ?? ?? 48 8D 0C C9 48 8D 0C 79 4C 01 E9 48 39 C8 0F 82 99 F6 FF FF 48 29 C8 48 8B 0D ?? ?? ?? ?? 48 BF 55 55 55 55 55 55 55 15 48 39 F9 0F 87 7C F6 FF FF 48 8D 0C 49 48 C1 E1 02 48 39 C8 0F 82 6B F6 FF FF 48 29 C8 49 39 C2 0F 87 5F F6 FF FF 4C 29 D0 0F 84 56 F6 FF FF 48 8D 48 FF 49 39 CF 0F 87 49 F6 FF FF 4C 89 F9 48 F7 D1 48 01 C1 48 89 D0 48 F7 D0 48 89 8D F0 FE FF FF 48 39 C1 0F 86 D2 F7 FF FF E9 25 F6 FF FF 48 83 3D ?? ?? ?? ?? 01 0F 85 A9 01 00 00 48 8B 3D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? E9 17 FD FF FF 48 8B 05 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? E9 12 FD FF FF 31 D2 4D 39 D1 4C 89 0D ?? ?? ?? ?? 4C 89 15 ?? ?? ?? ?? 4C 89 C8 0F 95 C2 E9 22 FD FF FF 31 D2 4D 39 D1 0F 95 C2 E9 15 FD FF FF 48 89 DF 48 89 8D E8 FE FF FF 48 89 B5 E0 FE FF FF 4C 89 85 D0 FE FF FF 4C 89 95 C8 FE FF FF E8 ?? ?? ?? ?? 83 F8 FF 48 8B 8D E8 FE FF FF 48 8B B5 E0 FE FF FF 4C 8B 85 D0 FE FF FF 4C 8B 95 C8 FE FF FF 0F 84 78 F5 FF FF 48 8B 53 08 48 8B 7B 10 E9 C5 F8 FF FF 66 0F 1F 44 00 00 48 89 DF 48 89 95 E8 FE FF FF 4C 89 85 D0 FE FF FF 4C 89 8D D8 FE FF FF 4C 89 95 C8 FE FF FF 4C 89 9D E0 FE FF FF E8 ?? ?? ?? ?? 83 F8 FF 48 8B 95 E8 FE FF FF 4C 8B 85 D0 FE FF FF 4C 8B 8D D8 FE FF FF 4C 8B 95 C8 FE FF FF 4C 8B 9D E0 FE FF FF 0F 84 0E F5 FF FF E9 E3 F9 FF FF 0F 1F 40 00 48 89 DF 48 89 8D E8 FE FF FF 48 89 B5 E0 FE FF FF 4C 89 85 D0 FE FF FF 4C 89 95 C8 FE FF FF E8 ?? ?? ?? ?? 48 8B 8D E8 FE FF FF 48 8B B5 E0 FE FF FF 4C 8B 85 D0 FE FF FF 4C 8B 95 C8 FE FF FF E9 70 F8 FF FF 48 89 DF 48 89 8D E8 FE FF FF 48 89 B5 E0 FE FF FF 4C 89 85 D0 FE FF FF 4C 89 95 C8 FE FF FF E8 ?? ?? ?? ?? 48 8B 8D E8 FE FF FF 48 8B B5 E0 FE FF FF 4C 8B 85 D0 FE FF FF 4C 8B 95 C8 FE FF FF E9 F6 F7 FF FF 48 89 DF E8 ?? ?? ?? ?? E9 90 FA FF FF B9 ?? ?? ?? ?? BA EA 01 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? BE 04 00 00 00 48 89 C7 4C 89 95 C8 FE FF FF E8 ?? ?? ?? ?? 48 3B 05 ?? ?? ?? ?? 0F 85 34 F4 FF FF 48 89 D9 48 89 C2 BE 01 00 00 00 48 8B 3D ?? ?? ?? ?? E9 AA F6 FF FF 48 89 DF E8 ?? ?? ?? ?? 83 F8 FF 0F 84 0C F4 FF FF E9 B3 F9 FF FF 48 89 DF 4C 89 95 C8 FE FF FF E8 ?? ?? ?? ?? 83 F8 FF 4C 8B 95 C8 FE FF FF 0F 85 1C F9 FF FF E9 E3 F3 FF FF }
	condition:
		$1
}

rule file_28_2_0 {
	meta:
		name = "__tzfile_default"
		size = 444
		refs = "0031 strlen 0057 __tzfile_read 005d __use_tzfile 0083 mempcpy 0091 memcpy 016f __tzname 017d __timezone"
	strings:
		$1 = { 48 89 5C 24 D0 48 89 6C 24 D8 48 89 F3 4C 89 64 24 E0 4C 89 6C 24 E8 48 89 FD 4C 89 74 24 F0 4C 89 7C 24 F8 48 83 EC 58 49 89 D7 48 89 4C 24 08 E8 ?? ?? ?? ?? 48 89 DF 4C 8D 60 01 E8 ?? ?? ?? ?? 4C 8D 70 01 48 8D 54 24 18 BF ?? ?? ?? ?? 4F 8D 2C 26 4C 89 EE E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 85 D2 0F 84 1D 01 00 00 48 83 3D ?? ?? ?? ?? 01 0F 86 39 01 00 00 48 8B 7C 24 18 4C 89 E2 48 89 EE E8 ?? ?? ?? ?? 48 89 DE 4C 89 F2 48 89 C7 E8 ?? ?? ?? ?? 4C 8B 05 ?? ?? ?? ?? 48 8B 44 24 18 48 C7 05 ?? ?? ?? ?? 02 00 00 00 48 8B 35 ?? ?? ?? ?? 4D 85 C0 48 89 05 ?? ?? ?? ?? 74 7D 4C 8B 5C 24 08 4D 89 FA 48 8B 0D ?? ?? ?? ?? 4C 8B 0D ?? ?? ?? ?? 4C 2B 1D ?? ?? ?? ?? 31 FF 4C 2B 15 ?? ?? ?? ?? 31 C0 EB 24 0F 1F 80 00 00 00 00 80 7A 0A 00 75 35 4D 01 1C C1 66 0F 1F 44 00 00 48 83 C0 01 0F B6 7A 08 4C 39 C0 74 2F 0F B6 14 01 48 C1 E2 04 48 01 F2 44 0F B6 72 08 44 88 34 01 80 7A 0B 00 75 D9 85 FF 75 C5 4D 01 14 C1 48 83 C0 01 4C 39 C0 0F B6 7A 08 75 D1 48 8B 44 24 08 4C 89 3E 4C 89 EF C6 46 09 00 C6 46 08 00 4C 89 3D ?? ?? ?? ?? 44 88 66 19 49 F7 DF 48 89 46 10 C6 46 18 01 48 89 05 ?? ?? ?? ?? 48 89 2D ?? ?? ?? ?? 48 89 1D ?? ?? ?? ?? 4C 89 3D ?? ?? ?? ?? E8 8A EF FF FF 48 8B 5C 24 28 48 8B 6C 24 30 4C 8B 64 24 38 4C 8B 6C 24 40 4C 8B 74 24 48 4C 8B 7C 24 50 48 83 C4 58 C3 0F 1F 80 00 00 00 00 C7 05 ?? ?? ?? ?? 00 00 00 00 EB CA }
	condition:
		$1
}

rule file_28_3_0 {
	meta:
		name = "__tzfile_compute"
		size = 1698
		refs = "002e __tzname 00fc __tzstring 01d7 __daylight 01de __timezone 0216 strcmp 043e __assert_fail 0453 __tzset_parse_tz 0462 __offtime 047c __tz_compute 04ca strlen"
	strings:
		$1 = { 41 57 41 56 41 55 49 89 CD 41 54 55 48 89 D5 53 48 83 EC 18 85 F6 48 89 7C 24 08 0F 84 0E 02 00 00 4C 8B 0D ?? ?? ?? ?? 4D 89 C4 48 C7 05 ?? ?? ?? ?? 00 00 00 00 48 C7 05 ?? ?? ?? ?? 00 00 00 00 4D 85 C9 0F 84 A8 04 00 00 48 8B 3D ?? ?? ?? ?? 48 8B 74 24 08 48 39 37 0F 8F 93 04 00 00 4D 8D 41 FF 4A 8B 04 C7 48 39 C6 0F 8D D2 03 00 00 4C 89 C1 49 89 C0 48 BA 75 FD DA E5 EE 22 1A 88 49 29 F0 4C 89 C0 48 F7 EA 4C 01 C2 49 C1 F8 3F 48 C1 FA 17 4C 29 C2 49 39 D1 0F 87 A0 02 00 00 31 D2 EB 07 0F 1F 40 00 48 89 C2 4C 8D 42 01 4C 39 C1 76 15 48 8D 04 11 48 D1 E8 48 3B 34 C7 7D E7 48 89 C1 4C 39 C1 77 EB 4C 8D 41 FF 48 89 CB 48 8B 05 ?? ?? ?? ?? 42 0F B6 04 00 48 C1 E0 04 48 03 05 ?? ?? ?? ?? 0F B6 78 09 44 0F B6 70 08 48 03 3D ?? ?? ?? ?? 4C 89 04 24 E8 ?? ?? ?? ?? 48 3B 1D ?? ?? ?? ?? 4A 89 04 F5 ?? ?? ?? ?? 48 8B 35 ?? ?? ?? ?? 48 8B 0D ?? ?? ?? ?? 4C 8B 04 24 72 12 EB 7B 0F 1F 00 48 83 C3 01 48 39 1D ?? ?? ?? ?? 76 6B 0F B6 04 1E 48 C1 E0 04 48 01 C8 44 0F B6 78 08 0F B6 78 09 4D 63 F7 4A 83 3C F5 ?? ?? ?? ?? 00 75 D1 48 03 3D ?? ?? ?? ?? 4C 89 04 24 E8 ?? ?? ?? ?? 4A 89 04 F5 ?? ?? ?? ?? B8 01 00 00 00 48 8B 35 ?? ?? ?? ?? 44 29 F8 48 8B 0D ?? ?? ?? ?? 4C 8B 04 24 48 98 48 83 3C C5 ?? ?? ?? ?? 00 74 92 66 2E 0F 1F 84 00 00 00 00 00 48 8B 05 ?? ?? ?? ?? 48 85 C0 0F 84 C6 04 00 00 42 0F B6 1C 06 48 C1 E3 04 48 01 CB 48 8B 15 ?? ?? ?? ?? 31 C9 48 3B 15 ?? ?? ?? ?? 0F 95 C1 48 F7 DA 48 85 C0 89 0D ?? ?? ?? ?? 48 89 15 ?? ?? ?? ?? 0F 84 03 02 00 00 48 83 3D ?? ?? ?? ?? 00 0F 84 17 02 00 00 0F B6 43 08 41 89 44 24 20 0F B6 7B 09 4C 8B 34 C5 ?? ?? ?? ?? 48 03 3D ?? ?? ?? ?? 4C 89 F6 E8 ?? ?? ?? ?? 85 C0 0F 85 67 04 00 00 48 8B 03 4D 89 74 24 30 49 89 44 24 28 48 8B 15 ?? ?? ?? ?? 4C 8B 05 ?? ?? ?? ?? 48 8D 42 FF 48 C1 E2 04 48 C7 45 00 00 00 00 00 48 8B 7C 24 08 41 C7 45 00 00 00 00 00 49 8D 54 10 F0 EB 0A 0F 1F 80 00 00 00 00 48 89 C8 48 83 F8 FF 74 1D 48 89 D6 48 83 EA 10 48 8D 48 FF 48 39 3E 7F E7 48 8B 56 08 48 89 55 00 48 3B 3E 74 12 48 83 C4 18 5B 5D 41 5C 41 5D 41 5E 41 5F C3 0F 1F 00 48 85 C0 48 8B 56 08 0F 84 F3 00 00 00 49 89 C9 49 C1 E1 04 4D 01 C1 49 8B 71 08 48 39 D6 7D CE 48 85 C0 41 C7 45 00 01 00 00 00 74 C1 4D 8B 09 49 83 C1 01 4C 39 CF 75 B5 48 83 C6 01 48 39 D6 75 AC 48 C1 E0 04 BA 02 00 00 00 49 8D 44 00 F8 EB 33 66 0F 1F 44 00 00 48 8B 78 E8 48 89 C6 48 83 C7 01 48 39 78 F8 75 24 48 8B 7E F0 83 C2 01 48 83 E8 10 48 83 C7 01 48 39 3E 0F 85 FF 00 00 00 48 83 E9 01 48 85 C9 41 89 D0 75 CB 41 89 55 00 48 83 C4 18 5B 5D 41 5C 41 5D 41 5E 41 5F C3 4C 89 C8 48 29 D0 48 8D 58 FF 48 89 C2 48 3B 34 DF 7D 6D 48 83 FB 09 76 0E 48 8D 48 F5 48 3B 34 CF 0F 8C 39 FD FF FF 48 83 EA 02 48 8D 43 FF 48 3B 34 D7 49 89 D0 0F 8D 54 FD FF FF 0F 1F 40 00 48 89 C3 48 83 E8 01 48 3B 74 DF F8 49 89 C0 7C EF E9 3A FD FF FF 66 2E 0F 1F 84 00 00 00 00 00 48 85 D2 0F 8E 04 FF FF FF 41 C7 45 00 01 00 00 00 48 83 C4 18 5B 5D 41 5C 41 5D 41 5E 41 5F C3 48 83 C2 09 49 39 D1 76 0F 48 3B 34 D7 0F 8D D8 FC FF FF 0F 1F 44 00 00 48 83 C3 01 48 3B 34 DF 7D F6 4C 8D 43 FF E9 E5 FC FF FF 48 83 3D ?? ?? ?? ?? 01 75 34 48 8B 3D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? E9 DB FD FF FF 48 8B 05 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? E9 D6 FD FF FF 45 89 45 00 E9 65 FE FF FF B9 ?? ?? ?? ?? BA 15 03 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 3D ?? ?? ?? ?? 48 85 FF 0F 84 1C 02 00 00 E8 ?? ?? ?? ?? 48 8D 7C 24 08 31 F6 4C 89 E2 E8 ?? ?? ?? ?? 85 C0 0F 84 F5 01 00 00 48 8B 7C 24 08 BA 01 00 00 00 4C 89 E6 E8 ?? ?? ?? ?? 48 8B 15 ?? ?? ?? ?? 4C 8B 05 ?? ?? ?? ?? 48 89 D7 48 C1 E7 04 4C 01 C7 48 3B 3D ?? ?? ?? ?? 0F 85 98 FD FF FF 48 83 3D ?? ?? ?? ?? 02 0F 85 CC 00 00 00 E8 ?? ?? ?? ?? 48 8B 1D ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 48 89 DF E8 ?? ?? ?? ?? 48 8D 7C 03 01 E8 ?? ?? ?? ?? 48 8B 15 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 4C 8B 05 ?? ?? ?? ?? E9 4B FD FF FF 45 31 FF 45 31 F6 48 83 3D ?? ?? ?? ?? 00 48 8B 05 ?? ?? ?? ?? 0F 84 9A 00 00 00 48 8B 0D ?? ?? ?? ?? 80 79 08 00 48 89 CA 0F 84 32 01 00 00 31 C0 45 31 F6 EB 32 0F 1F 84 00 00 00 00 00 48 8B 35 ?? ?? ?? ?? 49 83 C6 01 48 89 C8 4C 39 F6 76 55 4C 89 F2 48 C1 E2 04 48 01 CA 80 7A 08 00 74 45 48 8B 05 ?? ?? ?? ?? 48 85 C0 75 D1 0F B6 7A 09 48 03 3D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 0D ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? EB B1 B9 ?? ?? ?? ?? BA B7 02 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 4C 39 F6 74 3C 4D 89 F7 49 C1 E7 04 48 89 C8 42 0F B6 7C 38 09 48 03 3D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 3D ?? ?? ?? ?? 00 48 89 05 ?? ?? ?? ?? 74 17 48 8B 1D ?? ?? ?? ?? 4C 01 FB E9 E3 FB FF FF 45 31 FF 45 31 F6 EB C6 48 8B 35 ?? ?? ?? ?? 49 39 F6 73 DD 48 8B 0D ?? ?? ?? ?? 4A 8D 1C 39 80 7B 08 00 75 60 49 8D 56 01 48 C1 E2 04 48 8D 54 11 08 49 83 C6 01 4C 39 F6 0F 86 A4 FB FF FF 48 8D 4A F8 48 83 C2 10 80 7A F0 00 74 E5 0F B6 79 09 48 03 3D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 1D ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? 4C 01 FB E9 69 FB FF FF 45 31 FF 45 31 F6 E9 46 FF FF FF 48 89 D9 EB C3 4C 8B 0D ?? ?? ?? ?? 4D 8D 41 FF 4C 89 CB E9 5A FA FF FF 48 8B 05 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? E9 27 FB FF FF B9 ?? ?? ?? ?? BA 1C 03 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_29_0_0 {
	meta:
		name = "__strcasecmp_l_nonascii"
		size = 67
	strings:
		$1 = { 48 39 F7 74 3B 48 8B 52 70 0F 1F 80 00 00 00 00 44 0F B6 07 0F B6 0E 48 83 C6 01 41 0F B6 C0 8B 04 82 2B 04 8A 75 11 48 83 C7 01 45 84 C0 75 E0 F3 C3 66 0F 1F 44 00 00 F3 C3 66 0F 1F 44 00 00 31 C0 C3 }
	condition:
		$1
}

rule file_30_0_0 {
	meta:
		name = "_L_lock_36"
		size = 31
		refs = "000f __lll_lock_wait_private"
	strings:
		$1 = { 48 8D 3D ?? ?? ?? ?? 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 93 FE FF FF }
	condition:
		$1
}

rule file_30_1_0 {
	meta:
		name = "_L_unlock_122"
		size = 31
		refs = "000f __lll_unlock_wake_private"
	strings:
		$1 = { 48 8D 3D ?? ?? ?? ?? 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 63 FF FF FF }
	condition:
		$1
}

rule file_30_2_0 {
	meta:
		name = "fgetpwent"
		size = 408
		refs = "0013 _IO_new_fgetpos 0026 __libc_multiple_threads 005d __libc_errno 0078 _IO_new_fsetpos 00a5 __fgetpwent_r 00d2 realloc 00e9 free 017e malloc"
	strings:
		$1 = { 41 55 41 54 55 53 48 89 FB 48 83 EC 38 48 8D 74 24 20 E8 ?? ?? ?? ?? 85 C0 0F 85 41 01 00 00 BE 01 00 00 00 83 3D ?? ?? ?? ?? 00 74 10 F0 0F B1 35 ?? ?? ?? ?? 0F 85 5D 01 00 00 EB 0D 0F B1 35 ?? ?? ?? ?? 0F 85 4E 01 00 00 48 8B 15 ?? ?? ?? ?? 48 85 D2 0F 84 13 01 00 00 4C 8B 25 ?? ?? ?? ?? EB 2D 0F 1F 44 00 00 48 8D 74 24 20 48 89 DF 48 89 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 0F 85 7C 00 00 00 48 8B 15 ?? ?? ?? ?? 48 85 D2 74 7B 48 8B 0D ?? ?? ?? ?? 4C 8D 44 24 18 BE ?? ?? ?? ?? 48 89 DF E8 ?? ?? ?? ?? 83 F8 22 0F 85 9E 00 00 00 48 8B 35 ?? ?? ?? ?? 48 8B 2D ?? ?? ?? ?? 48 81 C6 00 04 00 00 48 89 EF 48 89 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 85 C0 75 8D 64 45 8B 2C 24 48 89 EF 48 89 44 24 08 E8 ?? ?? ?? ?? 48 8B 44 24 08 64 45 89 2C 24 E9 6C FF FF FF 0F 1F 40 00 48 C7 05 ?? ?? ?? ?? 00 00 00 00 48 C7 44 24 18 00 00 00 00 64 41 8B 14 24 83 3D ?? ?? ?? ?? 00 74 0F F0 FF 0D ?? ?? ?? ?? 0F 85 88 00 00 00 EB 08 FF 0D ?? ?? ?? ?? 75 7E 64 41 89 14 24 48 8B 44 24 18 48 83 C4 38 5B 5D 41 5C 41 5D C3 66 90 48 83 3D ?? ?? ?? ?? 00 75 BA EB AF 0F 1F 40 00 48 83 C4 38 31 C0 5B 5D 41 5C 41 5D C3 BF 00 04 00 00 48 C7 05 ?? ?? ?? ?? 00 04 00 00 E8 ?? ?? ?? ?? 4C 8B 25 ?? ?? ?? ?? 48 89 C2 48 89 05 ?? ?? ?? ?? E9 F3 FE FF FF }
	condition:
		$1
}

rule file_31_0_0 {
	meta:
		name = "__getclktck"
		size = 17
		refs = "0002 _dl_clktck"
	strings:
		$1 = { 8B 05 ?? ?? ?? ?? BA 64 00 00 00 85 C0 0F 44 C2 C3 }
	condition:
		$1
}

rule file_32_0_0 {
	meta:
		name = "__libc_pause"
		size = 81
		refs = "0002 __libc_multiple_threads 0022 __libc_enable_asynccancel 0039 __libc_disable_asynccancel 0018 __syscall_error"
		altNames = "pause"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 75 14 B8 22 00 00 00 0F 05 48 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 48 83 EC 08 E8 ?? ?? ?? ?? 48 89 04 24 B8 22 00 00 00 0F 05 48 8B 3C 24 48 89 C2 E8 ?? ?? ?? ?? 48 89 D0 48 83 C4 08 48 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_4_0_3 {
	meta:
		name = "__libc_pause"
		size = 81
		refs = "0002 __pthread_multiple_threads 0022 __pthread_enable_asynccancel 0039 __pthread_disable_asynccancel 0018 __syscall_error"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 75 14 B8 22 00 00 00 0F 05 48 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 48 83 EC 08 E8 ?? ?? ?? ?? 48 89 04 24 B8 22 00 00 00 0F 05 48 8B 3C 24 48 89 C2 E8 ?? ?? ?? ?? 48 89 D0 48 83 C4 08 48 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_4_2_3 {
	meta:
		name = "pause"
		size = 81
		refs = "0002 __pthread_multiple_threads 0022 __pthread_enable_asynccancel 0039 __pthread_disable_asynccancel 0018 __syscall_error"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 75 14 B8 22 00 00 00 0F 05 48 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 48 83 EC 08 E8 ?? ?? ?? ?? 48 89 04 24 B8 22 00 00 00 0F 05 48 8B 3C 24 48 89 C2 E8 ?? ?? ?? ?? 48 89 D0 48 83 C4 08 48 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_32_1_0 {
	meta:
		name = "__pause_nocancel"
		size = 20
		refs = "000f __syscall_error"
	strings:
		$1 = { B8 22 00 00 00 0F 05 48 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_33_0_0 {
	meta:
		name = "getsubopt"
		size = 294
		refs = "0031 __strchrnul 0048 memchr 007a strncmp"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 53 48 83 EC 28 48 8B 2F 48 89 7C 24 10 48 89 54 24 18 80 7D 00 00 0F 84 F9 00 00 00 49 89 F5 48 89 EF BE 2C 00 00 00 E8 ?? ?? ?? ?? 48 89 C2 BE 3D 00 00 00 48 89 EF 48 29 EA 48 89 04 24 E8 ?? ?? ?? ?? 48 8B 14 24 4D 8B 75 00 48 85 C0 48 0F 45 D0 4D 85 F6 48 89 54 24 08 74 35 48 89 D3 45 31 FF 48 29 EB 66 90 48 89 DA 4C 89 F6 48 89 EF E8 ?? ?? ?? ?? 85 C0 45 89 FC 75 07 41 80 3C 1E 00 74 54 49 83 C7 01 4F 8B 74 FD 00 4D 85 F6 75 D6 48 8B 54 24 18 48 8B 04 24 48 89 2A 80 38 00 75 25 48 8B 04 24 48 8B 54 24 10 41 BC FF FF FF FF 48 89 02 48 83 C4 28 44 89 E0 5B 5D 41 5C 41 5D 41 5E 41 5F C3 90 C6 00 00 48 83 C0 01 48 89 04 24 EB CE 0F 1F 00 48 8B 54 24 08 31 C0 48 8B 0C 24 48 83 C2 01 48 39 4C 24 08 48 0F 45 C2 48 8B 54 24 18 48 89 02 80 39 00 74 0B C6 01 00 48 83 C1 01 48 89 0C 24 48 8B 04 24 48 8B 4C 24 10 48 89 01 EB 9F 41 BC FF FF FF FF EB 97 }
	condition:
		$1
}

rule file_34_0_0 {
	meta:
		name = "day_of_the_week"
		size = 213
		refs = "0077 __mon_yday"
	strings:
		$1 = { 4C 63 4F 10 8B 47 14 31 D2 BE 1F 85 EB 51 53 8D 88 6C 07 00 00 41 83 F9 01 0F 9E C2 29 D1 44 8D 59 03 85 C9 44 0F 49 D9 69 C0 6D 01 00 00 45 89 D8 41 C1 FB 1F 41 C1 F8 02 41 8D 9C 00 59 9A FF FF 89 C8 C1 F9 1F F7 EE 89 D0 41 89 D2 89 CA C1 F8 05 29 C2 44 89 C0 01 D3 F7 EE C1 FA 03 44 29 DA 8D 04 92 44 89 D2 C1 FA 07 8D 04 80 29 CA 41 29 C0 43 0F B7 84 09 ?? ?? ?? ?? 41 C1 E8 1F 41 01 D8 41 8D 34 10 41 B8 93 24 49 92 5B 01 C6 03 77 0C 83 EE 01 89 F0 41 F7 E8 89 F0 C1 F8 1F 8D 0C 32 C1 F9 02 29 C1 8D 04 CD 00 00 00 00 29 C8 29 C6 8D 4E 07 89 C8 41 F7 E8 89 C8 C1 F8 1F 01 CA C1 FA 02 29 C2 8D 04 D5 00 00 00 00 29 D0 29 C1 89 4F 18 C3 }
	condition:
		$1
}

rule file_34_1_0 {
	meta:
		name = "__strptime_internal"
		size = 12645
		refs = "0416 _nl_C_LC_TIME 0436 __strptime_internal 0892 strlen 08ac __strncasecmp_l 08d5 strcmp 0914 _nl_select_era_entry 1195 __localtime_r 1d2f __mon_yday 1f6b _nl_parse_alt_digit 2fea __assert_fail"
	strings:
		$1 = { 41 57 49 89 D7 41 56 49 89 CE 41 55 4D 89 C5 41 54 49 89 F4 55 53 48 81 EC B8 00 00 00 49 8B 70 10 48 85 C9 48 89 7C 24 58 48 89 74 24 18 0F 84 A0 04 00 00 48 8B 01 4C 8D 54 24 70 4C 89 54 24 10 48 89 44 24 60 48 8B 02 48 89 44 24 70 48 8B 42 08 48 89 44 24 78 48 8B 42 10 48 89 84 24 80 00 00 00 48 8B 42 18 48 89 84 24 88 00 00 00 48 8B 42 20 48 89 84 24 90 00 00 00 48 8B 42 28 48 89 84 24 98 00 00 00 48 8B 42 30 48 89 84 24 A0 00 00 00 48 BD 10 00 00 00 00 00 04 80 41 0F B6 04 24 84 C0 74 4E 49 8B 75 68 48 0F BE D0 F6 44 56 01 20 0F 84 A7 00 00 00 48 8B 44 24 58 48 0F BE 10 F6 44 56 01 20 74 1E 48 83 C0 01 0F 1F 00 48 89 C2 48 89 44 24 58 48 83 C0 01 48 0F BE 12 F6 44 56 01 20 75 E9 49 83 C4 01 41 0F B6 04 24 84 C0 75 B2 4D 85 F6 0F 84 E1 18 00 00 48 8B 44 24 60 49 89 06 48 8B 44 24 70 49 89 07 48 8B 44 24 78 49 89 47 08 48 8B 84 24 80 00 00 00 49 89 47 10 48 8B 84 24 88 00 00 00 49 89 47 18 48 8B 84 24 90 00 00 00 49 89 47 20 48 8B 84 24 98 00 00 00 49 89 47 28 48 8B 84 24 A0 00 00 00 49 89 47 30 48 8B 44 24 58 EB 2A 0F 1F 80 00 00 00 00 3C 25 74 34 48 8B 54 24 58 49 83 C4 01 0F B6 0A 48 83 C2 01 48 89 54 24 58 38 C8 0F 84 1C FF FF FF 31 C0 48 81 C4 B8 00 00 00 5B 5D 41 5C 41 5D 41 5E 41 5F C3 0F 1F 00 4D 85 F6 49 8D 44 24 01 75 1D E9 22 03 00 00 66 0F 1F 84 00 00 00 00 00 49 89 EB 49 D3 E3 4D 85 DB 79 2C 48 83 C0 01 0F B6 10 80 FA 5F 74 F4 80 FA 2D 74 EF 8D 4A DD 80 F9 3B 76 DC 8D 4A D0 80 F9 09 77 13 0F 1F 40 00 48 83 C0 01 0F B6 10 8D 4A D0 80 F9 09 76 F1 83 EA 25 48 8B 5C 24 58 4C 8D 60 01 80 FA 55 76 10 31 C0 E9 7C FF FF FF 66 0F 1F 84 00 00 00 00 00 0F B6 D2 FF 24 D5 ?? ?? ?? ?? 48 83 C3 01 48 89 5C 24 58 48 0F BE 03 F6 44 46 01 20 75 EC E9 6A FE FF FF 0F 1F 44 00 00 48 83 C3 01 48 89 5C 24 58 0F BE 03 3C 20 74 F0 8D 50 D0 80 FA 09 0F 87 81 2E 00 00 83 E8 30 48 8D 53 01 48 98 48 8D 0C 80 48 89 54 24 58 48 01 C9 48 83 F9 0C 77 22 0F B6 53 01 80 FA 2F 7E 19 80 FA 39 7F 14 0F BE C2 48 83 C3 02 83 E8 30 48 89 5C 24 58 48 98 48 01 C8 48 8D 50 FF 48 83 FA 0B 0F 87 16 2E 00 00 4C 8B 54 24 10 83 E8 01 41 89 42 10 80 4C 24 60 08 80 4C 24 61 04 E9 E3 FD FF FF 66 0F 1F 44 00 00 48 83 C3 01 48 89 5C 24 58 0F B6 03 3C 20 74 F0 83 E8 30 3C 09 0F 87 F1 2D 00 00 48 8B 44 24 58 0F BE 10 48 8D 48 01 48 89 4C 24 58 B9 03 00 00 00 83 EA 30 48 63 D2 48 8D 34 92 48 01 F6 48 81 FE 0F 27 00 00 77 2B 0F B6 40 01 3C 2F 7E 23 3C 39 7F 1F 48 8B 44 24 58 0F BE 10 83 EA 30 48 63 D2 48 01 F2 48 8D 70 01 83 E9 01 48 89 74 24 58 75 C5 48 81 FA 0F 27 00 00 0F 87 63 29 00 00 4C 8B 5C 24 10 81 EA 6C 07 00 00 41 89 53 14 0F B6 44 24 61 83 E0 FE 83 C8 04 88 44 24 61 E9 3B FD FF FF 66 0F 1F 44 00 00 48 83 C3 01 48 89 5C 24 58 0F BE 03 3C 20 74 F0 8D 50 D0 80 FA 09 0F 87 41 2D 00 00 83 E8 30 48 8D 53 01 48 98 48 8D 0C 80 48 89 54 24 58 48 01 C9 48 83 F9 35 77 2C 0F B6 53 01 80 FA 2F 7E 23 80 FA 39 7F 1E 0F BE C2 48 83 C3 02 83 E8 30 48 89 5C 24 58 48 98 48 01 C8 48 83 F8 35 0F 87 F1 2C 00 00 88 44 24 62 80 4C 24 60 20 E9 C4 FC FF FF 0F B6 54 24 61 89 D0 83 E0 18 3C 10 74 2C 4C 8B 5C 24 18 49 8B B3 90 01 00 00 80 3E 00 0F 85 0E 1D 00 00 3C 08 0F 84 18 29 00 00 83 E2 E7 48 89 5C 24 58 83 CA 10 88 54 24 61 48 8B 35 ?? ?? ?? ?? 80 3E 00 0F 84 B9 2C 00 00 48 8B 54 24 10 48 8B 7C 24 58 48 8D 4C 24 60 4D 89 E8 E8 ?? ?? ?? ?? 48 85 C0 48 89 44 24 58 0F 85 55 FC FF FF 31 C0 E9 34 FD FF FF 90 0F B6 54 24 61 89 D0 83 E0 18 3C 10 74 2C 4C 8B 5C 24 18 49 8B B3 88 01 00 00 80 3E 00 0F 85 E5 21 00 00 3C 08 0F 84 9A 28 00 00 83 E2 E7 48 89 5C 24 58 83 CA 10 88 54 24 61 48 8B 35 ?? ?? ?? ?? 80 3E 00 0F 84 1B 29 00 00 48 8B 54 24 10 48 8B 7C 24 58 48 8D 4C 24 60 4D 89 E8 E8 ?? ?? ?? ?? 48 85 C0 48 89 44 24 58 0F 84 ED 28 00 00 80 4C 24 61 04 E9 D4 FB FF FF 41 0F B6 54 24 01 E9 1B FD FF FF 48 C7 44 24 60 00 00 00 00 48 89 54 24 10 C6 44 24 63 FF C7 44 24 64 FF FF FF FF E9 9F FB FF FF 4C 8D 60 02 0F B6 40 01 83 E8 43 3C 36 0F 86 1D 10 00 00 31 C0 E9 75 FC FF FF 0F B6 13 48 8D 43 01 80 FA 20 75 15 48 89 C3 48 89 44 24 58 48 83 C0 01 0F B6 50 FF 80 FA 20 74 EB 83 EA 30 80 FA 09 0F 87 71 2B 00 00 48 8D 43 01 48 89 44 24 58 0F B6 43 01 3C 2F 0F 8E 4D FB FF FF 3C 39 0F 8F 45 FB FF FF 48 83 C3 02 48 89 5C 24 58 E9 37 FB FF FF 0F B6 13 48 8D 43 01 80 FA 20 75 15 48 89 C3 48 89 44 24 58 48 83 C0 01 0F B6 50 FF 80 FA 20 74 EB 8D 42 D0 3C 09 0F 87 13 2B 00 00 0F BE C2 48 8D 53 01 83 E8 30 48 98 48 89 54 24 58 48 8D 0C 80 48 01 C9 48 83 F9 1F 77 22 0F B6 53 01 80 FA 2F 7E 19 80 FA 39 7F 14 0F BE C2 48 83 C3 02 83 E8 30 48 89 5C 24 58 48 98 48 01 C8 48 8D 50 FF 48 83 FA 1E 0F 87 D5 26 00 00 4C 8B 54 24 10 41 89 42 0C 80 4C 24 60 10 80 4C 24 61 04 E9 A5 FA FF FF 0F B6 13 48 8D 43 01 80 FA 20 75 15 48 89 C3 48 89 44 24 58 48 83 C0 01 0F B6 50 FF 80 FA 20 74 EB 8D 42 D0 3C 09 0F 87 C1 2A 00 00 0F BE C2 48 8D 53 01 83 E8 30 48 98 48 89 54 24 58 48 8D 0C 80 48 01 C9 48 83 F9 3B 77 2C 0F B6 53 01 80 FA 2F 7E 23 80 FA 39 7F 1E 0F BE C2 48 83 C3 02 83 E8 30 48 89 5C 24 58 48 98 48 01 C8 48 83 F8 3B 0F 87 7E 2A 00 00 4C 8B 5C 24 10 41 89 43 04 E9 21 FA FF FF 0F B6 13 48 8D 43 01 80 FA 20 75 15 48 89 C3 48 89 44 24 58 48 83 C0 01 0F B6 50 FF 80 FA 20 74 EB 8D 42 D0 3C 09 0F 87 E4 29 00 00 0F BE C2 48 83 C3 01 83 E8 30 48 89 5C 24 58 48 63 D0 48 83 FA 06 0F 87 C1 29 00 00 4C 8B 5C 24 10 41 89 43 18 80 4C 24 60 02 E9 C6 F9 FF FF 0F BE 13 48 8D 43 01 80 FA 20 75 15 48 89 C3 48 89 44 24 58 48 83 C0 01 0F BE 50 FF 80 FA 20 74 EB 8D 42 D0 3C 09 0F 87 F9 29 00 00 8D 4A D0 48 83 C3 01 48 89 5C 24 58 48 63 C9 48 8D 41 FF 48 83 F8 06 0F 87 D5 29 00 00 48 89 C8 48 BA 93 24 49 92 24 49 92 24 4C 8B 54 24 10 48 F7 E2 48 89 C8 48 29 D0 48 D1 E8 48 01 D0 48 C1 E8 02 48 8D 14 C5 00 00 00 00 48 29 C2 48 29 D1 41 89 4A 18 80 4C 24 60 02 E9 3C F9 FF FF 0F B6 0B 48 8D 43 01 80 F9 20 75 15 48 89 C3 48 89 44 24 58 48 83 C0 01 0F B6 48 FF 80 F9 20 74 EB 80 F9 2D 0F 85 B1 25 00 00 48 83 C3 01 31 C0 31 F6 48 89 5C 24 58 48 0F BE 13 80 FA 2F 0F 8E 4B 19 00 00 80 FA 39 0F 8F 42 19 00 00 48 8D 34 B6 83 C0 01 48 83 C3 01 83 F8 04 48 89 5C 24 58 48 8D 74 72 D0 75 D0 48 89 F0 48 BA C3 F5 28 5C 8F C2 F5 28 48 C1 E8 02 48 F7 E2 48 C1 EA 02 48 89 D0 48 8D 14 92 48 8D 14 92 48 C1 E2 02 48 29 D6 48 83 FE 3B 48 89 F2 0F 87 9D 28 00 00 48 8D 04 80 48 8D 34 80 48 8D 04 92 48 BA 89 88 88 88 88 88 88 88 48 8D 04 80 48 01 C0 48 F7 E2 48 C1 EA 04 48 8D 04 B2 48 3D B0 04 00 00 0F 87 62 28 00 00 48 69 C0 10 0E 00 00 48 BA C3 F5 28 5C 8F C2 F5 28 4C 8B 54 24 10 48 C1 E8 02 48 F7 E2 48 C1 EA 02 80 F9 2D 49 89 52 28 0F 85 3C F8 FF FF 48 F7 DA 49 89 52 28 E9 30 F8 FF FF 0F B6 44 24 61 83 E0 18 3C 10 0F 84 EB 13 00 00 48 8B 74 24 18 4C 8B 86 70 01 00 00 4C 89 C7 4C 89 44 24 08 E8 ?? ?? ?? ?? 4C 8B 44 24 08 4C 89 E9 48 89 C2 48 89 DE 48 89 04 24 4C 89 C7 E8 ?? ?? ?? ?? 85 C0 4C 8B 0C 24 0F 85 5F 13 00 00 48 8B 74 24 18 4C 01 4C 24 58 48 8B BE 70 01 00 00 48 8B 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 0F 0F B6 44 24 61 83 E0 E7 83 C8 08 88 44 24 61 80 64 24 60 7F E9 A7 F7 FF FF 8B B6 D0 01 00 00 31 FF C7 44 24 64 00 00 00 00 85 F6 89 74 24 20 7E 64 48 8B 74 24 18 E8 ?? ?? ?? ?? 48 85 C0 0F 84 4F 24 00 00 4C 8B 48 20 4C 89 CF 4C 89 0C 24 E8 ?? ?? ?? ?? 4C 8B 0C 24 48 8B 74 24 58 4C 89 E9 48 89 C2 48 89 44 24 08 4C 89 CF E8 ?? ?? ?? ?? 85 C0 4C 8B 44 24 08 0F 85 16 24 00 00 0F B6 44 24 61 4C 01 44 24 58 8B 7C 24 64 83 E0 E7 83 C8 08 88 44 24 61 3B 7C 24 20 0F 85 21 F7 FF FF 0F B6 44 24 61 C7 44 24 64 FF FF FF FF 89 C2 83 E2 18 80 FA 08 0F 84 F8 23 00 00 83 E0 E7 48 8B 5C 24 58 83 C8 10 88 44 24 61 0F B6 13 80 FA 20 75 19 48 8D 43 01 48 89 C3 48 89 44 24 58 48 83 C0 01 0F B6 50 FF 80 FA 20 74 EB 8D 42 D0 3C 09 0F 87 D3 23 00 00 0F BE C2 48 8D 53 01 83 E8 30 48 89 54 24 58 0F B6 53 01 48 98 48 8D 0C 80 48 01 C9 80 FA 2F 7E 19 80 FA 39 7F 14 0F BE C2 48 83 C3 02 83 E8 30 48 89 5C 24 58 48 98 48 01 C8 88 44 24 63 80 4C 24 61 04 E9 83 F6 FF FF 0F B6 13 48 8D 43 01 80 FA 20 75 15 48 89 C3 48 89 44 24 58 48 83 C0 01 0F B6 50 FF 80 FA 20 74 EB 8D 42 D0 3C 09 0F 87 1F 26 00 00 48 8D 43 01 48 89 44 24 58 0F BE C2 83 E8 30 48 98 48 8D 14 80 48 01 D2 48 83 FA 35 0F 87 35 F6 FF FF 0F BE 43 01 3C 2F 0F 8E 29 F6 FF FF 3C 39 0F 8F 21 F6 FF FF 83 E8 30 48 83 C3 02 48 98 48 89 5C 24 58 48 01 C2 48 83 FA 35 0F 86 06 F6 FF FF 31 C0 E9 E5 F6 FF FF 66 90 0F B6 13 48 8D 43 01 80 FA 20 75 15 48 89 C3 48 89 44 24 58 48 83 C0 01 0F B6 50 FF 80 FA 20 74 EB 8D 42 D0 3C 09 0F 87 F9 21 00 00 0F BE C2 48 8D 53 01 83 E8 30 48 98 48 89 54 24 58 48 8D 0C 80 48 01 C9 48 83 F9 3D 77 2C 0F B6 53 01 80 FA 2F 7E 23 80 FA 39 7F 1E 0F BE C2 48 83 C3 02 83 E8 30 48 89 5C 24 58 48 98 48 01 C8 48 83 F8 3D 0F 87 56 25 00 00 4C 8B 54 24 10 41 89 02 E9 7A F5 FF FF 48 8B 54 24 10 48 8D 4C 24 60 4D 89 E8 BE ?? ?? ?? ?? 48 89 DF E8 ?? ?? ?? ?? 48 85 C0 48 89 44 24 58 0F 85 74 F9 FF FF 31 C0 E9 31 F6 FF FF 66 0F 1F 44 00 00 0F B6 54 24 61 89 D0 83 E0 18 3C 10 74 2C 48 8B 7C 24 18 48 8B B7 98 01 00 00 80 3E 00 0F 85 6F 13 00 00 3C 08 0F 84 18 21 00 00 83 E2 E7 48 89 5C 24 58 83 CA 10 88 54 24 61 48 8B 35 ?? ?? ?? ?? 80 3E 00 0F 84 D3 24 00 00 48 8B 54 24 10 48 8B 7C 24 58 48 8D 4C 24 60 4D 89 E8 E8 ?? ?? ?? ?? 48 85 C0 48 89 44 24 58 0F 85 D6 F4 FF FF 31 C0 E9 B5 F5 FF FF 66 90 0F B6 13 48 8D 43 01 80 FA 20 75 15 48 89 C3 48 89 44 24 58 48 83 C0 01 0F B6 50 FF 80 FA 20 74 EB 8D 42 D0 3C 09 0F 87 AD 20 00 00 0F BE C2 48 8D 53 01 83 E8 30 48 98 48 89 54 24 58 48 8D 0C 80 48 01 C9 48 83 F9 17 77 2C 0F B6 53 01 80 FA 2F 7E 23 80 FA 39 7F 1E 0F BE C2 48 83 C3 02 83 E8 30 48 89 5C 24 58 48 98 48 01 C8 48 83 F8 17 0F 87 86 20 00 00 4C 8B 54 24 10 41 89 42 08 80 64 24 60 FE E9 44 F4 FF FF 0F B6 54 24 61 45 31 DB 4C 89 74 24 50 C7 44 24 2C FF FF FF FF 48 C7 44 24 20 00 00 00 00 4D 89 DE 4C 89 64 24 40 4C 89 7C 24 48 89 D0 C0 E8 03 41 89 C0 41 83 E0 03 44 89 44 24 38 E9 C0 00 00 00 49 01 D9 4C 39 4C 24 20 0F B6 54 24 61 0F 83 A3 01 00 00 83 E2 18 0F 85 D0 0E 00 00 4C 8B 44 24 18 4A 8B 34 F5 ?? ?? ?? ?? 4B 8B 3C F8 4C 89 0C 24 E8 ?? ?? ?? ?? 4C 8B 0C 24 85 C0 48 8B 5C 24 58 44 89 64 24 2C 4C 89 4C 24 20 74 08 C7 44 24 38 01 00 00 00 4E 8B 3C F5 ?? ?? ?? ?? 4C 89 FF E8 ?? ?? ?? ?? 4C 89 E9 48 89 C2 48 89 DE 4C 89 FF 48 89 44 24 08 E8 ?? ?? ?? ?? 85 C0 4C 8B 44 24 08 0F 85 0E 0C 00 00 49 01 D8 4C 3B 44 24 20 0F 86 00 0C 00 00 44 89 64 24 2C 4C 89 44 24 20 C7 44 24 38 02 00 00 00 49 83 C6 01 49 83 FE 0C 0F 84 CC 0D 00 00 0F B6 54 24 61 48 8B 5C 24 58 83 E2 18 45 89 F4 80 FA 10 74 8A 45 8D 96 1A 00 02 00 48 8B 74 24 18 44 89 74 24 30 45 0F B7 D2 4D 8D 7A 08 4E 8B 04 FE 4C 89 C7 4C 89 44 24 08 E8 ?? ?? ?? ?? 4C 8B 44 24 08 4C 89 E9 48 89 C2 48 89 DE 48 89 04 24 4C 89 C7 E8 ?? ?? ?? ?? 85 C0 4C 8B 0C 24 75 45 4C 01 CB 48 3B 5C 24 20 76 3B F6 44 24 61 18 0F 85 B1 0D 00 00 4C 8B 44 24 18 4A 8B 34 F5 ?? ?? ?? ?? 4B 8B 3C F8 E8 ?? ?? ?? ?? 85 C0 B8 01 00 00 00 0F 44 44 24 38 44 89 74 24 2C 48 89 5C 24 20 89 44 24 38 44 8B 7C 24 30 48 8B 74 24 18 48 8B 5C 24 58 41 81 C7 0E 00 02 00 45 0F B7 FF 49 83 C7 08 4E 8B 04 FE 4C 89 C7 4C 89 44 24 08 E8 ?? ?? ?? ?? 4C 8B 44 24 08 4C 89 E9 48 89 C2 48 89 DE 48 89 04 24 4C 89 C7 E8 ?? ?? ?? ?? 85 C0 4C 8B 0C 24 0F 84 4F FE FF FF 0F B6 54 24 61 83 E2 18 80 FA 08 0F 84 E6 FE FF FF 48 8B 5C 24 58 E9 89 FE FF FF 66 2E 0F 1F 84 00 00 00 00 00 0F B6 54 24 61 45 31 DB 4C 89 64 24 30 4C 89 74 24 40 C7 44 24 20 FF FF FF FF 4D 89 DE 4C 89 7C 24 38 89 D0 C0 E8 03 41 89 C0 41 83 E0 03 44 89 44 24 2C 45 31 C0 4D 89 C4 E9 C1 00 00 00 49 01 D9 0F B6 54 24 61 4D 39 CC 0F 83 94 01 00 00 83 E2 18 0F 85 18 0D 00 00 4C 8B 44 24 18 4A 8B 34 F5 ?? ?? ?? ?? 4B 8B 7C F0 40 4C 89 0C 24 E8 ?? ?? ?? ?? 4C 8B 0C 24 85 C0 48 8B 5C 24 58 44 89 7C 24 20 4D 89 CC 74 08 C7 44 24 2C 01 00 00 00 4E 8B 04 F5 ?? ?? ?? ?? 4C 89 C7 4C 89 44 24 08 E8 ?? ?? ?? ?? 4C 8B 44 24 08 4C 89 E9 48 89 C2 48 89 DE 48 89 04 24 4C 89 C7 E8 ?? ?? ?? ?? 85 C0 4C 8B 0C 24 0F 85 40 0A 00 00 49 01 D9 4D 39 E1 0F 86 34 0A 00 00 44 89 7C 24 20 4D 89 CC C7 44 24 2C 02 00 00 00 49 83 C6 01 49 83 FE 07 0F 84 66 0B 00 00 0F B6 54 24 61 48 8B 5C 24 58 83 E2 18 45 89 F7 80 FA 10 74 86 45 8D 8E 07 00 02 00 48 8B 74 24 18 45 0F B7 C9 49 83 C1 08 4E 8B 04 CE 4C 89 0C 24 4C 89 C7 4C 89 44 24 08 E8 ?? ?? ?? ?? 4C 8B 44 24 08 4C 89 E9 48 89 C2 48 89 DE 48 89 44 24 08 4C 89 C7 E8 ?? ?? ?? ?? 85 C0 4C 8B 0C 24 4C 8B 54 24 08 75 41 4C 01 D3 4C 39 E3 76 39 F6 44 24 61 18 0F 85 0F 0C 00 00 4C 8B 44 24 18 4A 8B 34 F5 ?? ?? ?? ?? 49 89 DC 4B 8B 3C C8 E8 ?? ?? ?? ?? 85 C0 B8 01 00 00 00 0F 44 }
	condition:
		$1
}

rule file_35_0_0 {
	meta:
		name = "jrand48"
		size = 29
		refs = "0005 __libc_drand48_data 000f __jrand48_r"
	strings:
		$1 = { 48 83 EC 18 BE ?? ?? ?? ?? 48 8D 54 24 08 E8 ?? ?? ?? ?? 48 8B 44 24 08 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_445_0_0 {
	meta:
		name = "nrand48"
		size = 29
		refs = "0005 __libc_drand48_data 000f __nrand48_r"
	strings:
		$1 = { 48 83 EC 18 BE ?? ?? ?? ?? 48 8D 54 24 08 E8 ?? ?? ?? ?? 48 8B 44 24 08 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_37_0_0 {
	meta:
		name = "mabort"
		size = 141
		refs = "0020 _libc_intl_domainname 0025 __dcgettext 002d __libc_fatal"
	strings:
		$1 = { 48 83 EC 08 83 FF 01 74 54 7E 68 83 FF 02 74 21 83 FF 03 74 32 BA 05 00 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 C7 E8 ?? ?? ?? ?? BA 05 00 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? EB E2 BA 05 00 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? EB CC BA 05 00 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? EB B6 85 FF 75 9E BA 05 00 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 9C }
	condition:
		$1
}

rule file_37_1_0 {
	meta:
		name = "checkhdr"
		size = 146
	strings:
		$1 = { 48 83 EC 18 8B 15 ?? ?? ?? ?? 31 C0 85 D2 74 49 48 8B 57 18 48 03 57 10 B8 09 53 67 D8 48 33 57 08 48 39 C2 74 3A B8 EB BE DA FE 48 39 C2 74 40 B8 02 00 00 00 89 C7 89 44 24 08 C7 05 ?? ?? ?? ?? 00 00 00 00 FF 15 ?? ?? ?? ?? 8B 44 24 08 C7 05 ?? ?? ?? ?? 01 00 00 00 48 83 C4 18 C3 66 90 B8 01 00 00 00 EB CE 66 0F 1F 84 00 00 00 00 00 48 8B 0F B8 03 00 00 00 80 7C 0F 30 D7 75 B6 48 8B 4F 20 48 33 4F 28 B0 02 48 39 D1 75 A7 30 C0 EB C7 }
	condition:
		$1
}

rule file_37_2_0 {
	meta:
		name = "unlink_blk.isra.1"
		size = 72
	strings:
		$1 = { 48 85 F6 74 17 48 8B 07 BA EB BE DA FE 48 89 46 10 48 03 46 18 48 31 D0 48 89 46 08 48 8B 07 48 85 C0 74 1C 48 89 70 18 48 03 70 10 BA EB BE DA FE 48 31 D6 48 89 70 08 C3 0F 1F 80 00 00 00 00 48 89 35 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_37_3_0 {
	meta:
		name = "memalignhook"
		size = 316
		refs = "0046 __memalign_hook 00d3 memset 00f2 mcheck_check_all 0109 memalign 011b __libc_errno"
	strings:
		$1 = { 55 48 89 F5 53 48 83 EC 18 8B 0D ?? ?? ?? ?? 85 C9 0F 85 D1 00 00 00 48 8D 47 2F 48 89 FB 48 F7 DB 48 21 C3 48 8D 43 01 48 F7 D0 48 39 E8 0F 82 E4 00 00 00 48 8B 05 ?? ?? ?? ?? 48 8D 74 2B 01 48 85 C0 48 89 05 ?? ?? ?? ?? 0F 84 B8 00 00 00 FF D0 48 85 C0 48 C7 05 ?? ?? ?? ?? ?? ?? ?? ?? 0F 84 D2 00 00 00 48 8B 0D ?? ?? ?? ?? 48 8D 7C 18 D0 BE EB BE DA FE 48 89 2F 48 C7 47 10 00 00 00 00 48 89 CA 48 89 4F 18 48 89 3D ?? ?? ?? ?? 48 31 F2 48 85 C9 48 89 57 08 74 12 48 89 FA 48 03 51 18 48 89 79 10 48 31 F2 48 89 51 08 48 8D 4F 30 BA EB BE DA FE 48 89 47 20 48 31 C2 BE 93 FF FF FF 48 89 57 28 C6 44 2F 30 D7 48 89 EA 48 89 CF E8 ?? ?? ?? ?? 48 89 C1 48 83 C4 18 48 89 C8 5B 5D C3 0F 1F 40 00 48 89 14 24 48 89 7C 24 08 E8 ?? ?? ?? ?? 48 8B 7C 24 08 48 8B 14 24 E9 13 FF FF FF 0F 1F 40 00 E8 ?? ?? ?? ?? E9 40 FF FF FF 66 0F 1F 44 00 00 48 8B 05 ?? ?? ?? ?? 31 C9 64 C7 00 0C 00 00 00 48 83 C4 18 48 89 C8 5B 5D C3 66 0F 1F 44 00 00 31 C9 EB 9E }
	condition:
		$1
}

rule file_37_4_0 {
	meta:
		name = "mallochook"
		size = 284
		refs = "0031 __malloc_hook 00b9 memset 00d6 mcheck_check_all 00ec __libc_errno 0109 malloc"
	strings:
		$1 = { 53 48 89 FB 48 83 EC 10 8B 3D ?? ?? ?? ?? 85 FF 0F 85 BA 00 00 00 48 83 FB CE 0F 87 C9 00 00 00 48 8B 05 ?? ?? ?? ?? 48 8D 7B 31 48 85 C0 48 89 05 ?? ?? ?? ?? 0F 84 CD 00 00 00 FF D0 48 85 C0 48 C7 05 ?? ?? ?? ?? ?? ?? ?? ?? 0F 84 C7 00 00 00 48 8B 0D ?? ?? ?? ?? BE EB BE DA FE 48 89 18 48 C7 40 10 00 00 00 00 48 89 05 ?? ?? ?? ?? 48 89 CA 48 89 48 18 48 31 F2 48 85 C9 48 89 50 08 74 12 48 89 C2 48 03 51 18 48 89 41 10 48 31 F2 48 89 51 08 48 8D 48 30 BA EB BE DA FE 48 89 40 20 48 31 C2 BE 93 FF FF FF 48 89 50 28 48 89 CF C6 44 18 30 D7 48 89 DA E8 ?? ?? ?? ?? 48 89 C1 48 83 C4 10 48 89 C8 5B C3 0F 1F 80 00 00 00 00 48 89 74 24 08 E8 ?? ?? ?? ?? 48 83 FB CE 48 8B 74 24 08 0F 86 37 FF FF FF 48 8B 05 ?? ?? ?? ?? 31 C9 64 C7 00 0C 00 00 00 48 83 C4 10 48 89 C8 5B C3 66 0F 1F 44 00 00 E8 ?? ?? ?? ?? E9 2B FF FF FF 66 0F 1F 44 00 00 31 C9 EB A4 }
	condition:
		$1
}

rule file_37_5_0 {
	meta:
		name = "freehook"
		size = 186
		refs = "0068 memset 007d __free_hook 00a1 mcheck_check_all 00b4 free"
	strings:
		$1 = { 55 48 89 F5 53 48 89 FB 48 83 EC 08 44 8B 15 ?? ?? ?? ?? 45 85 D2 0F 85 84 00 00 00 48 85 DB 74 4F 48 8D 7B D0 E8 46 FC FF FF 48 8B 73 E8 41 B8 09 53 67 D8 41 B9 09 53 67 D8 48 8D 7B E0 4C 89 43 D8 4C 89 4B F8 E8 C5 FC FF FF 48 8B 53 D0 48 C7 43 E8 00 00 00 00 48 89 DF 48 C7 43 E0 00 00 00 00 BE 95 FF FF FF E8 ?? ?? ?? ?? 48 8B 5B F0 48 8B 05 ?? ?? ?? ?? 48 85 C0 48 89 05 ?? ?? ?? ?? 74 2D 48 89 EE 48 89 DF FF D0 48 C7 05 ?? ?? ?? ?? ?? ?? ?? ?? 48 83 C4 08 5B 5D C3 0F 1F 00 E8 ?? ?? ?? ?? E9 72 FF FF FF 66 0F 1F 44 00 00 48 89 DF E8 ?? ?? ?? ?? EB D1 }
	condition:
		$1
}

rule file_37_6_0 {
	meta:
		name = "reallochook"
		size = 551
		refs = "0086 __free_hook 0094 __malloc_hook 00a2 __memalign_hook 00b3 __realloc_hook 0181 mcheck_check_all 01b1 memset 01e4 realloc 01f3 __libc_errno"
	strings:
		$1 = { 48 89 5C 24 D8 48 89 6C 24 E0 4C 89 64 24 E8 4C 89 6C 24 F0 4C 89 74 24 F8 48 83 EC 28 48 85 F6 0F 84 E2 01 00 00 44 8B 1D ?? ?? ?? ?? 48 89 FB 48 89 F5 49 89 D6 45 85 DB 0F 85 41 01 00 00 48 83 FD CE 0F 87 A7 01 00 00 48 85 DB 0F 84 3E 01 00 00 4C 8D 6B D0 4C 8B 63 D0 4C 89 EF E8 4E FB FF FF 48 8B 73 E8 48 8D 7B E0 E8 E1 FB FF FF 4C 39 E5 0F 82 48 01 00 00 48 8B 05 ?? ?? ?? ?? 48 8D 75 31 48 89 05 ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? 48 85 C0 48 89 05 ?? ?? ?? ?? 0F 84 23 01 00 00 4C 89 F2 4C 89 EF FF D0 48 89 C3 48 85 DB 48 C7 05 ?? ?? ?? ?? ?? ?? ?? ?? 48 C7 05 ?? ?? ?? ?? ?? ?? ?? ?? 48 C7 05 ?? ?? ?? ?? ?? ?? ?? ?? 48 C7 05 ?? ?? ?? ?? ?? ?? ?? ?? 0F 84 23 01 00 00 48 8B 05 ?? ?? ?? ?? B9 EB BE DA FE 48 89 2B 48 C7 43 10 00 00 00 00 48 89 1D ?? ?? ?? ?? 48 89 C2 48 89 43 18 48 31 CA 48 85 C0 48 89 53 08 74 12 48 89 DA 48 03 50 18 48 89 58 10 48 31 CA 48 89 50 08 B8 EB BE DA FE 48 89 5B 20 48 31 D8 49 39 EC 48 89 43 28 C6 44 2B 30 D7 72 46 48 8D 43 30 48 8B 1C 24 48 8B 6C 24 08 4C 8B 64 24 10 4C 8B 6C 24 18 4C 8B 74 24 20 48 83 C4 28 C3 0F 1F 44 00 00 E8 ?? ?? ?? ?? E9 B5 FE FF FF 66 0F 1F 44 00 00 45 31 E4 45 31 ED E9 DD FE FF FF 0F 1F 44 00 00 48 89 EA 4A 8D 7C 23 30 BE 93 FF FF FF 4C 29 E2 E8 ?? ?? ?? ?? EB A3 66 0F 1F 84 00 00 00 00 00 4C 89 E2 48 8D 3C 2B BE 95 FF FF FF 48 29 EA E8 ?? ?? ?? ?? E9 9F FE FF FF 0F 1F 80 00 00 00 00 4C 89 EF E8 ?? ?? ?? ?? 48 89 C3 E9 D8 FE FF FF 48 8B 05 ?? ?? ?? ?? 64 C7 00 0C 00 00 00 31 C0 E9 59 FF FF FF 0F 1F 00 48 89 D6 E8 30 FD FF FF 31 C0 E9 47 FF FF FF 66 0F 1F 84 00 00 00 00 00 31 C0 E9 37 FF FF FF }
	condition:
		$1
}

rule file_37_7_0 {
	meta:
		name = "mcheck_check_all"
		size = 61
	strings:
		$1 = { 53 48 8B 1D ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 00 00 00 00 48 85 DB 74 1A 66 0F 1F 84 00 00 00 00 00 48 89 DF E8 E8 FE FF FF 48 8B 5B 18 48 85 DB 75 EF C7 05 ?? ?? ?? ?? 01 00 00 00 5B C3 }
	condition:
		$1
}

rule file_37_8_0 {
	meta:
		name = "mcheck"
		size = 207
		refs = "000e __libc_malloc_initialized 0047 malloc 0056 free 005d __free_hook 0080 __malloc_hook 0099 __memalign_hook 00b2 __realloc_hook"
	strings:
		$1 = { 48 85 FF B8 ?? ?? ?? ?? 48 0F 44 F8 8B 05 ?? ?? ?? ?? 48 89 3D ?? ?? ?? ?? 85 C0 7E 13 83 3D ?? ?? ?? ?? 01 19 C0 C3 66 0F 1F 84 00 00 00 00 00 8B 05 ?? ?? ?? ?? 85 C0 74 06 31 C0 C3 0F 1F 00 48 83 EC 18 31 FF E8 ?? ?? ?? ?? 48 89 44 24 08 48 8B 7C 24 08 E8 ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 01 00 00 00 48 C7 05 ?? ?? ?? ?? ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? 48 C7 05 ?? ?? ?? ?? ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? 48 C7 05 ?? ?? ?? ?? ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? 48 C7 05 ?? ?? ?? ?? ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 31 C0 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_37_9_0 {
	meta:
		name = "mcheck_pedantic"
		size = 28
		refs = "0005 mcheck"
	strings:
		$1 = { 48 83 EC 08 E8 ?? ?? ?? ?? 85 C0 75 0A C7 05 ?? ?? ?? ?? 01 00 00 00 48 83 C4 08 C3 }
	condition:
		$1
}

rule file_37_10_0 {
	meta:
		name = "mprobe"
		size = 30
	strings:
		$1 = { 8B 05 ?? ?? ?? ?? 85 C0 74 0E 48 83 EF 30 E9 7D F8 FF FF 0F 1F 44 00 00 B8 FF FF FF FF C3 }
	condition:
		$1
}

rule file_40_0_0 {
	meta:
		name = "_L_lock_17"
		size = 31
		refs = "000f __lll_lock_wait_private"
	strings:
		$1 = { 48 8D 3D ?? ?? ?? ?? 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 70 FF FF FF }
	condition:
		$1
}

rule file_40_1_0 {
	meta:
		name = "_L_unlock_55"
		size = 28
		refs = "000f __lll_unlock_wake_private"
	strings:
		$1 = { 48 8D 3D ?? ?? ?? ?? 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 EB BA }
	condition:
		$1
}

rule file_40_2_0 {
	meta:
		name = "_create_xid"
		size = 155
		refs = "000e __libc_multiple_threads 002b getpid 0041 __gettimeofday 005b __srand48_r 0070 lrand48_r"
	strings:
		$1 = { 53 BE 01 00 00 00 31 C0 48 83 EC 20 83 3D ?? ?? ?? ?? 00 74 0C F0 0F B1 35 ?? ?? ?? ?? 75 7C EB 09 0F B1 35 ?? ?? ?? ?? 75 71 E8 ?? ?? ?? ?? 39 05 ?? ?? ?? ?? 74 2E 48 8D 7C 24 10 31 F6 89 C3 E8 ?? ?? ?? ?? 48 8B 7C 24 18 48 33 7C 24 10 48 63 C3 BE ?? ?? ?? ?? 48 31 C7 E8 ?? ?? ?? ?? 89 1D ?? ?? ?? ?? 48 8D 74 24 08 BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 74 0B F0 FF 0D ?? ?? ?? ?? 75 34 EB 08 FF 0D ?? ?? ?? ?? 75 2A 48 8B 44 24 08 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_42_0_0 {
	meta:
		name = "lrand48"
		size = 32
		refs = "0005 __libc_drand48_data 0012 __nrand48_r"
	strings:
		$1 = { 48 83 EC 18 BE ?? ?? ?? ?? 48 8D 54 24 08 48 89 F7 E8 ?? ?? ?? ?? 48 8B 44 24 08 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_1308_0_0 {
	meta:
		name = "mrand48"
		size = 32
		refs = "0005 __libc_drand48_data 0012 __jrand48_r"
	strings:
		$1 = { 48 83 EC 18 BE ?? ?? ?? ?? 48 8D 54 24 08 48 89 F7 E8 ?? ?? ?? ?? 48 8B 44 24 08 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_43_0_0 {
	meta:
		name = "__realpath_chk"
		size = 20
		refs = "0010 __chk_fail 000a __realpath"
	strings:
		$1 = { 48 81 FA FF 0F 00 00 76 05 E9 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_0_0 {
	meta:
		name = "psignal"
		size = 239
		refs = "003d _sys_siglist 0047 _libc_intl_domainname 004c __dcgettext 0063 __fxprintf 00a3 __asprintf 00c4 free"
	strings:
		$1 = { 48 89 6C 24 F0 48 89 5C 24 E8 89 FD 4C 89 64 24 F8 48 83 EC 28 48 85 F6 74 09 80 3E 00 0F 85 AD 00 00 00 41 BC ?? ?? ?? ?? 4C 89 E3 83 FD 40 BA 05 00 00 00 77 4A 48 63 C5 48 8B 34 C5 ?? ?? ?? ?? 48 85 F6 74 3A BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 4C 89 E1 49 89 C0 48 89 DA BE ?? ?? ?? ?? 31 FF 31 C0 E8 ?? ?? ?? ?? 48 8B 5C 24 10 48 8B 6C 24 18 4C 8B 64 24 20 48 83 C4 28 C3 0F 1F 44 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 7C 24 08 48 89 C6 41 89 E8 31 C0 4C 89 E1 48 89 DA E8 ?? ?? ?? ?? 85 C0 78 35 48 8B 54 24 08 31 FF BE ?? ?? ?? ?? 31 C0 E8 ?? ?? ?? ?? 48 8B 7C 24 08 E8 ?? ?? ?? ?? EB 9D 66 0F 1F 44 00 00 48 89 F3 41 BC ?? ?? ?? ?? E9 4E FF FF FF 66 90 BA 05 00 00 00 BE ?? ?? ?? ?? E9 57 FF FF FF }
	condition:
		$1
}

rule file_45_0_0 {
	meta:
		name = "__lcong48_r"
		size = 58
	strings:
		$1 = { 8B 07 89 06 0F B7 47 04 66 89 46 04 0F B7 47 0A 0F B7 57 06 48 C1 E0 20 48 09 D0 0F B7 57 08 C1 E2 10 48 09 D0 48 89 46 10 0F B7 47 0C 66 C7 46 0E 01 00 66 89 46 0C 31 C0 C3 }
	condition:
		$1
}

rule file_46_0_0 {
	meta:
		name = "grantpt"
		size = 1148
		refs = "0041 realloc 0063 __ptsname_internal 0078 memchr 008d malloc 00a3 __libc_errno 00b7 free 00ca __libc_fcntl 00f1 __getuid 010b __chown 0153 __chmod 0189 __fork 01bd __setrlimit 01d0 __dup2 01e2 __opendir 01fc __readdir64 0226 strtol 025c __waitpid 0294 __assert_fail 02ce __closedir 02dc __open_nocancel 0317 basename 032a execle 0334 _exit 03f3 __sysconf 042f __getgrnam_r 0458 __getgid"
	strings:
		$1 = { 55 48 89 E5 41 56 41 89 FE 41 55 4C 8D AD E0 EF FF FF 41 54 4D 89 EC 53 BB 00 10 00 00 48 81 EC E0 10 00 00 EB 27 66 2E 0F 1F 84 00 00 00 00 00 4D 39 EC BB 80 00 00 00 74 4F 48 89 DE 4C 89 E7 E8 ?? ?? ?? ?? 48 85 C0 74 56 49 89 C4 48 85 DB 74 DE 48 8D 8D 50 EF FF FF 48 89 DA 4C 89 E6 44 89 F7 E8 ?? ?? ?? ?? 85 C0 0F 85 41 02 00 00 31 F6 48 89 DA 4C 89 E7 E8 ?? ?? ?? ?? 48 85 C0 75 6F 48 01 DB 4D 39 EC 75 B1 48 89 DF E8 ?? ?? ?? ?? 48 85 C0 75 B4 66 2E 0F 1F 84 00 00 00 00 00 48 8B 1D ?? ?? ?? ?? 64 C7 03 0C 00 00 00 4D 39 EC 74 08 4C 89 E7 E8 ?? ?? ?? ?? 31 C0 BE 01 00 00 00 44 89 F7 64 44 8B 23 E8 ?? ?? ?? ?? 83 F8 FF 0F 84 61 02 00 00 41 83 FC 19 0F 84 E2 02 00 00 64 44 89 23 B8 FF FF FF FF E9 87 00 00 00 90 E8 ?? ?? ?? ?? 39 85 6C EF FF FF 89 C3 74 14 8B 95 70 EF FF FF 89 C6 4C 89 E7 E8 ?? ?? ?? ?? 85 C0 78 75 8B 15 ?? ?? ?? ?? 83 FA FF 0F 84 CB 02 00 00 3B 95 70 EF FF FF 74 0E 89 DE 4C 89 E7 E8 ?? ?? ?? ?? 85 C0 78 50 8B 85 68 EF FF FF 25 FF 01 00 00 3D 90 01 00 00 74 11 BE 90 01 00 00 4C 89 E7 E8 ?? ?? ?? ?? 85 C0 78 2D 31 C0 4D 39 EC 74 14 4C 89 E7 89 85 08 EF FF FF E8 ?? ?? ?? ?? 8B 85 08 EF FF FF 48 8D 65 E0 5B 41 5C 41 5D 41 5E 5D C3 0F 1F 44 00 00 E8 ?? ?? ?? ?? 83 F8 FF 74 CB 85 C0 0F 85 B6 00 00 00 48 8D B5 20 EF FF FF BF 04 00 00 00 48 C7 85 20 EF FF FF 00 00 00 00 48 C7 85 28 EF FF FF 00 00 00 00 E8 ?? ?? ?? ?? 41 83 FE 03 74 15 BE 03 00 00 00 44 89 F7 E8 ?? ?? ?? ?? 85 C0 0F 88 DD 01 00 00 BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 85 C0 48 89 C3 0F 84 1F 01 00 00 66 0F 1F 44 00 00 48 89 DF E8 ?? ?? ?? ?? 48 85 C0 0F 84 C1 00 00 00 0F BE 48 13 83 E9 30 83 F9 09 77 E3 48 8D 78 13 48 8D B5 18 EF FF FF BA 0A 00 00 00 E8 ?? ?? ?? ?? 48 8B 95 18 EF FF FF 80 3A 00 75 C2 48 83 F8 03 74 BC 48 63 13 48 39 D0 74 B4 48 89 C7 B8 03 00 00 00 0F 05 EB A8 48 8D B5 14 EF FF FF 31 D2 89 C7 E8 ?? ?? ?? ?? 83 F8 FF 0F 84 F4 FE FF FF 8B 85 14 EF FF FF A8 7F 75 25 0F B6 C4 83 F8 05 0F 86 D1 00 00 00 B9 ?? ?? ?? ?? BA E9 00 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? 64 C7 00 08 00 00 00 B8 FF FF FF FF E9 AD FE FF FF 48 8B 1D ?? ?? ?? ?? 83 F8 19 BA 16 00 00 00 0F 44 C2 64 89 03 E9 E4 FD FF FF 48 89 DF E8 ?? ?? ?? ?? 31 F6 31 C0 BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 0F 85 EC 00 00 00 31 C0 BE 01 00 00 00 BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 F8 01 0F 85 61 01 00 00 BE 02 00 00 00 BF 01 00 00 00 E8 ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? BF ?? ?? ?? ?? 48 89 C6 31 C9 31 D2 31 C0 E8 ?? ?? ?? ?? BF 04 00 00 00 E8 ?? ?? ?? ?? 64 83 3B 09 0F 85 95 FD FF FF E9 2F FE FF FF 66 0F 1F 84 00 00 00 00 00 89 C0 FF 24 C5 ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? 64 C7 00 0D 00 00 00 B8 FF FF FF FF E9 EC FD FF FF 48 8B 05 ?? ?? ?? ?? 64 C7 00 16 00 00 00 B8 FF FF FF FF E9 D4 FD FF FF 48 8B 05 ?? ?? ?? ?? 64 C7 00 09 00 00 00 B8 FF FF FF FF E9 BC FD FF FF 48 8B 05 ?? ?? ?? ?? 64 C7 00 0C 00 00 00 B8 FF FF FF FF E9 A4 FD FF FF BF 01 00 00 00 E8 ?? ?? ?? ?? 64 C7 03 16 00 00 00 B8 FF FF FF FF E9 A2 FD FF FF B9 ?? ?? ?? ?? BA 23 00 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? BF 45 00 00 00 E8 ?? ?? ?? ?? BA 00 04 00 00 48 83 F8 FF 4C 8D 85 18 EF FF FF 48 0F 44 C2 48 8D B5 30 EF FF FF BF ?? ?? ?? ?? 48 8D 50 1E 48 89 C1 48 83 E2 F0 48 29 D4 48 8D 54 24 0F 48 83 E2 F0 E8 ?? ?? ?? ?? 48 8B 85 18 EF FF FF 8B 15 ?? ?? ?? ?? 48 85 C0 74 09 8B 50 10 89 15 ?? ?? ?? ?? 83 FA FF 0F 85 CB FC FF FF E8 ?? ?? ?? ?? 89 C2 E9 BF FC FF FF B9 ?? ?? ?? ?? BA 25 00 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_48_0_0 {
	meta:
		name = "__getpwuid_r"
		size = 625
		refs = "001b __nss_not_use_nscd_passwd 0093 __libc_errno 00b6 _dl_mcount_wrapper_check 00fa __nss_next2 014c __nss_database_custom 0168 __nscd_getpwuid_r 01e2 __nss_passwd_lookup2"
	strings:
		$1 = { 41 57 41 56 41 55 49 89 CD 41 54 49 89 D4 55 89 FD 53 48 89 F3 48 83 EC 28 8B 05 ?? ?? ?? ?? 4C 89 44 24 08 83 F8 00 0F 8E 93 01 00 00 83 C0 01 83 F8 64 0F 8F 07 01 00 00 89 05 ?? ?? ?? ?? 80 3D ?? ?? ?? ?? 00 0F 84 84 01 00 00 48 8B 05 ?? ?? ?? ?? 48 C1 C8 11 64 48 33 04 25 30 00 00 00 48 89 44 24 10 48 8B 05 ?? ?? ?? ?? 48 C1 C8 11 64 48 33 04 25 30 00 00 00 48 83 F8 FF 48 89 44 24 18 0F 94 C0 0F B6 C0 85 C0 0F 85 E5 00 00 00 48 8B 05 ?? ?? ?? ?? 49 89 C6 64 4C 03 34 25 00 00 00 00 48 89 04 24 66 0F 1F 84 00 00 00 00 00 48 8B 7C 24 10 E8 ?? ?? ?? ?? 4D 89 F0 4C 89 E9 4C 89 E2 48 89 DE 89 EF FF 54 24 10 83 F8 FE 41 89 C7 75 0E 48 8B 14 24 64 83 3A 22 0F 84 AE 00 00 00 48 8D 4C 24 10 48 8D 7C 24 18 45 31 C9 31 D2 45 89 F8 BE ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 AE 41 83 FF 01 48 8B 44 24 08 0F 84 1F 01 00 00 48 C7 00 00 00 00 00 0F 86 4F 01 00 00 48 8B 14 24 64 8B 02 83 F8 22 74 7E 48 83 C4 28 5B 5D 41 5C 41 5D 41 5E 41 5F C3 0F 1F 80 00 00 00 00 C7 05 ?? ?? ?? ?? 00 00 00 00 80 3D ?? ?? ?? ?? 00 0F 85 E8 FE FF FF 4C 8B 44 24 08 4C 89 E9 4C 89 E2 48 89 DE 89 EF E8 ?? ?? ?? ?? 85 C0 79 BA E9 CA FE FF FF 48 8B 15 ?? ?? ?? ?? 41 BF FF FF FF FF 48 89 14 24 66 2E 0F 1F 84 00 00 00 00 00 48 8B 44 24 08 48 8B 14 24 48 C7 00 00 00 00 00 64 8B 02 83 F8 22 75 82 41 83 FF FE 0F 84 78 FF FF FF B0 16 EB 7F 66 2E 0F 1F 84 00 00 00 00 00 74 88 80 3D ?? ?? ?? ?? 00 0F 85 7D FE FF FF 90 48 8D 4C 24 10 48 8D 7C 24 18 31 D2 BE ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 75 66 48 8B 54 24 10 64 48 33 14 25 30 00 00 00 48 C1 C2 11 48 89 15 ?? ?? ?? ?? 48 8B 54 24 18 64 48 33 14 25 30 00 00 00 48 C1 C2 11 48 89 15 ?? ?? ?? ?? C6 05 ?? ?? ?? ?? 01 E9 60 FE FF FF 0F 1F 84 00 00 00 00 00 48 89 18 31 C0 48 8B 14 24 64 89 02 48 83 C4 28 5B 5D 41 5C 41 5D 41 5E 41 5F C3 0F 1F 44 00 00 48 C7 C2 FF FF FF FF 64 48 33 14 25 30 00 00 00 48 C1 C2 11 48 89 15 ?? ?? ?? ?? EB AF 31 C0 EB C4 }
	condition:
		$1
}

rule file_215_0_0 {
	meta:
		name = "__getgrgid_r"
		size = 625
		refs = "001b __nss_not_use_nscd_group 0093 __libc_errno 00b6 _dl_mcount_wrapper_check 00fa __nss_next2 014c __nss_database_custom 0168 __nscd_getgrgid_r 01e2 __nss_group_lookup2"
	strings:
		$1 = { 41 57 41 56 41 55 49 89 CD 41 54 49 89 D4 55 89 FD 53 48 89 F3 48 83 EC 28 8B 05 ?? ?? ?? ?? 4C 89 44 24 08 83 F8 00 0F 8E 93 01 00 00 83 C0 01 83 F8 64 0F 8F 07 01 00 00 89 05 ?? ?? ?? ?? 80 3D ?? ?? ?? ?? 00 0F 84 84 01 00 00 48 8B 05 ?? ?? ?? ?? 48 C1 C8 11 64 48 33 04 25 30 00 00 00 48 89 44 24 10 48 8B 05 ?? ?? ?? ?? 48 C1 C8 11 64 48 33 04 25 30 00 00 00 48 83 F8 FF 48 89 44 24 18 0F 94 C0 0F B6 C0 85 C0 0F 85 E5 00 00 00 48 8B 05 ?? ?? ?? ?? 49 89 C6 64 4C 03 34 25 00 00 00 00 48 89 04 24 66 0F 1F 84 00 00 00 00 00 48 8B 7C 24 10 E8 ?? ?? ?? ?? 4D 89 F0 4C 89 E9 4C 89 E2 48 89 DE 89 EF FF 54 24 10 83 F8 FE 41 89 C7 75 0E 48 8B 14 24 64 83 3A 22 0F 84 AE 00 00 00 48 8D 4C 24 10 48 8D 7C 24 18 45 31 C9 31 D2 45 89 F8 BE ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 AE 41 83 FF 01 48 8B 44 24 08 0F 84 1F 01 00 00 48 C7 00 00 00 00 00 0F 86 4F 01 00 00 48 8B 14 24 64 8B 02 83 F8 22 74 7E 48 83 C4 28 5B 5D 41 5C 41 5D 41 5E 41 5F C3 0F 1F 80 00 00 00 00 C7 05 ?? ?? ?? ?? 00 00 00 00 80 3D ?? ?? ?? ?? 00 0F 85 E8 FE FF FF 4C 8B 44 24 08 4C 89 E9 4C 89 E2 48 89 DE 89 EF E8 ?? ?? ?? ?? 85 C0 79 BA E9 CA FE FF FF 48 8B 15 ?? ?? ?? ?? 41 BF FF FF FF FF 48 89 14 24 66 2E 0F 1F 84 00 00 00 00 00 48 8B 44 24 08 48 8B 14 24 48 C7 00 00 00 00 00 64 8B 02 83 F8 22 75 82 41 83 FF FE 0F 84 78 FF FF FF B0 16 EB 7F 66 2E 0F 1F 84 00 00 00 00 00 74 88 80 3D ?? ?? ?? ?? 00 0F 85 7D FE FF FF 90 48 8D 4C 24 10 48 8D 7C 24 18 31 D2 BE ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 75 66 48 8B 54 24 10 64 48 33 14 25 30 00 00 00 48 C1 C2 11 48 89 15 ?? ?? ?? ?? 48 8B 54 24 18 64 48 33 14 25 30 00 00 00 48 C1 C2 11 48 89 15 ?? ?? ?? ?? C6 05 ?? ?? ?? ?? 01 E9 60 FE FF FF 0F 1F 84 00 00 00 00 00 48 89 18 31 C0 48 8B 14 24 64 89 02 48 83 C4 28 5B 5D 41 5C 41 5D 41 5E 41 5F C3 0F 1F 44 00 00 48 C7 C2 FF FF FF FF 64 48 33 14 25 30 00 00 00 48 C1 C2 11 48 89 15 ?? ?? ?? ?? EB AF 31 C0 EB C4 }
	condition:
		$1
}

rule file_49_0_0 {
	meta:
		name = "__futimes"
		size = 428
		refs = "009b __libc_errno 00df _itoa_word"
	strings:
		$1 = { 55 89 FD 53 48 89 F3 48 83 EC 48 48 85 F6 0F 84 5C 01 00 00 48 8B 56 08 48 81 FA 3F 42 0F 00 77 77 48 8B 46 18 48 85 C0 78 6E 48 3D 3F 42 0F 00 7F 66 48 69 C0 E8 03 00 00 48 8B 0E 48 69 D2 E8 03 00 00 48 89 4C 24 20 48 89 44 24 38 8B 05 ?? ?? ?? ?? 48 89 54 24 28 48 8B 56 10 85 C0 48 89 54 24 30 75 66 48 8D 54 24 20 45 31 D2 31 F6 48 63 FD B8 18 01 00 00 0F 05 48 3D 00 F0 FF FF 77 2C 83 F8 FF 0F 84 D3 00 00 00 48 83 C4 48 5B 5D C3 0F 1F 80 00 00 00 00 48 8B 05 ?? ?? ?? ?? 64 C7 00 16 00 00 00 B8 FF FF FF FF EB DD 4C 8B 05 ?? ?? ?? ?? F7 D8 64 41 89 00 64 41 83 38 26 75 71 C7 05 ?? ?? ?? ?? 01 00 00 00 48 8D 74 24 1A 89 EF 31 C9 BA 0A 00 00 00 C6 44 24 1A 00 E8 ?? ?? ?? ?? 48 83 E8 0E BE ?? ?? ?? ?? B9 0E 00 00 00 48 89 C7 F3 A4 48 89 C7 48 89 DE B8 EB 00 00 00 0F 05 48 3D 00 F0 FF FF 77 43 83 F8 FF 0F 85 76 FF FF FF 4C 8B 05 ?? ?? ?? ?? 64 41 8B 00 83 F8 14 74 20 7F 14 83 F8 02 74 5A 83 F8 0D 66 90 74 37 83 C8 FF E9 50 FF FF FF 83 F8 24 74 05 83 F8 28 75 EE 64 41 C7 00 26 00 00 00 EB E4 4C 8B 05 ?? ?? ?? ?? F7 D8 64 41 89 00 EB BE 4C 8B 05 ?? ?? ?? ?? E9 51 FF FF FF 48 85 DB 75 D6 EB C2 31 D2 83 3D ?? ?? ?? ?? 00 0F 84 EB FE FF FF 90 E9 46 FF FF FF 31 D2 BE 01 00 00 00 48 63 FD B8 48 00 00 00 0F 05 48 3D 00 F0 FF FF 76 A6 F7 D8 64 41 89 00 83 C8 FF E9 DE FE FF FF }
	condition:
		$1
}

rule file_50_0_0 {
	meta:
		name = "wmemset"
		size = 90
	strings:
		$1 = { 48 83 FA 03 48 89 F8 48 89 F9 76 33 49 89 D0 90 49 83 E8 04 89 31 89 71 04 89 71 08 89 71 0C 48 83 C1 10 49 83 F8 03 77 E7 48 8D 4A FC 83 E2 03 48 C1 E9 02 48 83 C1 01 48 C1 E1 04 48 01 C1 48 85 D2 74 14 48 83 FA 01 89 31 74 0C 48 83 FA 03 89 71 04 75 03 89 71 08 F3 C3 }
	condition:
		$1
}

rule file_51_0_0 {
	meta:
		name = "fdatasync"
		size = 81
		refs = "0002 __libc_multiple_threads 0022 __libc_enable_asynccancel 0039 __libc_disable_asynccancel 0018 __syscall_error"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 75 14 B8 4B 00 00 00 0F 05 48 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 48 83 EC 08 E8 ?? ?? ?? ?? 48 89 04 24 B8 4B 00 00 00 0F 05 48 8B 3C 24 48 89 C2 E8 ?? ?? ?? ?? 48 89 D0 48 83 C4 08 48 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_51_1_0 {
	meta:
		name = "__fdatasync_nocancel"
		size = 20
		refs = "000f __syscall_error"
	strings:
		$1 = { B8 4B 00 00 00 0F 05 48 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_52_0_0 {
	meta:
		name = "_dl_add_to_namespace_list"
		size = 155
		refs = "0002 __pthread_mutex_lock 0017 _dl_load_write_lock 0028 _dl_ns 005e _dl_load_adds 0075 __pthread_mutex_unlock"
	strings:
		$1 = { 55 B8 ?? ?? ?? ?? 48 89 FD 53 48 89 F3 48 83 EC 08 48 85 C0 74 07 BF ?? ?? ?? ?? FF D0 48 8D 04 DB 48 C1 E0 04 48 8B 90 ?? ?? ?? ?? 48 85 D2 75 0A EB 58 0F 1F 44 00 00 48 89 C2 48 8B 42 18 48 85 C0 75 F4 48 89 55 20 48 89 6A 18 48 8D 04 DB 48 C1 E0 04 83 80 ?? ?? ?? ?? 01 48 8B 05 ?? ?? ?? ?? 48 89 85 60 04 00 00 48 83 C0 01 48 89 05 ?? ?? ?? ?? B8 ?? ?? ?? ?? 48 85 C0 74 16 48 83 C4 08 BF ?? ?? ?? ?? 5B 5D FF E0 48 89 A8 ?? ?? ?? ?? EB B8 48 83 C4 08 5B 5D C3 }
	condition:
		$1
}

rule file_52_1_0 {
	meta:
		name = "_dl_new_object"
		size = 738
		refs = "0026 strlen 0040 calloc 0080 memcpy 00a8 _dl_debug_mask 00e8 _dl_ns 0196 realloc 01af __getcwd 01bf __libc_errno 01da free 0264 malloc 0281 mempcpy 02b6 strchr"
	strings:
		$1 = { 41 57 41 89 D7 41 56 4D 89 CE 41 55 49 89 FD 48 89 F7 41 54 49 89 F4 55 48 89 CD 53 48 83 EC 28 44 89 44 24 10 E8 ?? ?? ?? ?? 48 8D 50 01 48 8D B8 89 04 00 00 BE 01 00 00 00 48 89 54 24 08 E8 ?? ?? ?? ?? 48 85 C0 48 89 C3 48 8B 54 24 08 0F 84 90 01 00 00 48 89 40 28 48 05 68 04 00 00 48 8D BB 88 04 00 00 48 89 83 C8 02 00 00 48 8D 83 70 04 00 00 4C 89 E6 41 83 E7 03 48 89 43 38 E8 ?? ?? ?? ?? 48 89 83 70 04 00 00 0F B6 83 14 03 00 00 C7 83 80 04 00 00 01 00 00 00 4C 89 6B 08 83 E0 FC 44 09 F8 F6 05 ?? ?? ?? ?? 01 88 83 14 03 00 00 0F 84 77 01 00 00 48 8D 83 58 03 00 00 48 89 AB D8 02 00 00 4C 89 73 30 48 C7 83 78 03 00 00 04 00 00 00 48 89 83 80 03 00 00 4B 8D 04 F6 48 C1 E0 04 48 8B 80 ?? ?? ?? ?? 48 85 C0 0F 84 5B 01 00 00 48 05 B8 02 00 00 BA 01 00 00 00 48 89 83 58 03 00 00 48 85 ED 75 0F E9 2E 01 00 00 0F 1F 80 00 00 00 00 48 89 C5 48 8B 85 D8 02 00 00 48 85 C0 75 F1 85 D2 0F 85 D1 00 00 00 31 C0 48 81 C5 B8 02 00 00 48 89 AC 03 58 03 00 00 41 0F B6 6D 00 48 8D 83 B8 02 00 00 48 89 83 88 03 00 00 40 84 ED 0F 84 89 00 00 00 4C 89 EF 45 31 FF E8 ?? ?? ?? ?? 48 89 44 24 10 48 83 C0 01 40 80 FD 2F 48 89 44 24 18 49 89 C6 0F 84 DE 00 00 00 66 0F 1F 44 00 00 4D 8D A6 80 00 00 00 4C 89 FF 4C 89 E6 E8 ?? ?? ?? ?? 48 85 C0 48 89 C5 74 2D 49 8D 76 7F 48 2B 74 24 10 48 89 C7 E8 ?? ?? ?? ?? 48 85 C0 0F 85 F4 00 00 00 48 8B 05 ?? ?? ?? ?? 49 89 EF 4D 89 E6 64 83 38 22 74 B9 4C 89 FF 48 C7 C5 FF FF FF FF E8 ?? ?? ?? ?? 48 89 AB 38 03 00 00 48 83 C4 28 48 89 D8 5B 5D 41 5C 41 5D 41 5E 41 5F C3 66 0F 1F 84 00 00 00 00 00 48 8B 83 58 03 00 00 48 81 C5 B8 02 00 00 48 39 E8 0F 84 29 FF FF FF F6 44 24 10 08 0F 84 B6 00 00 00 48 89 83 60 03 00 00 31 C0 E9 08 FF FF FF C7 83 CC 03 00 00 01 00 00 00 E9 7A FE FF FF 85 D2 48 89 DD 0F 84 E5 FE FF FF EB B4 0F 1F 40 00 31 D2 E9 B0 FE FF FF 66 0F 1F 84 00 00 00 00 00 48 89 C7 E8 ?? ?? ?? ?? 48 85 C0 48 89 C5 74 5C 48 89 C7 0F 1F 44 00 00 48 8B 54 24 18 4C 89 EE E8 ?? ?? ?? ?? EB 0C 66 0F 1F 84 00 00 00 00 00 48 89 C8 80 78 FF 2F 48 8D 48 FF 75 F3 48 39 CD 48 0F 44 C8 C6 01 00 E9 32 FF FF FF 0F 1F 40 00 31 F6 48 89 EF E8 ?? ?? ?? ?? 80 78 FF 2F 48 89 C7 74 B5 C6 07 2F 48 83 C7 01 EB AC 48 C7 C5 FF FF FF FF E9 06 FF FF FF B8 08 00 00 00 E9 56 FE FF FF }
	condition:
		$1
}

rule file_54_0_0 {
	meta:
		name = "__atfct_seterrno_2"
		size = 605
		refs = "0031 __libc_errno 0081 strchr 0096 __lxstat64 00e3 __fxstat64 014d __xstat64"
	strings:
		$1 = { 48 89 5C 24 E8 48 89 6C 24 F0 89 FB 4C 89 64 24 F8 48 81 EC B8 00 00 00 48 85 D2 0F 95 C0 4D 85 C0 48 89 D5 41 0F 95 C4 75 36 84 C0 75 32 48 8B 2D ?? ?? ?? ?? 64 89 5D 00 48 8B 9C 24 A0 00 00 00 48 8B AC 24 A8 00 00 00 4C 8B A4 24 B0 00 00 00 48 81 C4 B8 00 00 00 C3 0F 1F 80 00 00 00 00 83 FB 14 74 6B 83 FB 02 75 C4 84 C0 0F 84 16 01 00 00 48 8D 7D 0E BE 2F 00 00 00 4C 89 44 24 08 E8 ?? ?? ?? ?? 48 8D 54 24 10 C6 00 00 48 89 EE BF 01 00 00 00 E8 ?? ?? ?? ?? 83 F8 FF 4C 8B 44 24 08 0F 84 60 01 00 00 85 C0 0F 85 D8 00 00 00 8B 44 24 28 25 00 F0 00 00 3D 00 A0 00 00 0F 84 C4 00 00 00 BB 09 00 00 00 E9 60 FF FF FF 66 90 84 C0 74 33 48 8D 54 24 10 BF 01 00 00 00 89 4C 24 08 E8 ?? ?? ?? ?? 85 C0 8B 4C 24 08 0F 85 46 FF FF FF 8B 44 24 28 25 00 F0 00 00 3D 00 40 00 00 0F 84 1D 01 00 00 45 84 E4 0F 84 1E FF FF FF 48 8D 54 24 10 89 CE BF 01 00 00 00 E8 ?? ?? ?? ?? 85 C0 0F 85 10 FF FF FF 8B 44 24 28 25 00 F0 00 00 3D 00 40 00 00 0F 85 F1 FE FF FF 48 8D 54 24 10 BE ?? ?? ?? ?? BF 01 00 00 00 E8 ?? ?? ?? ?? 85 C0 75 1B 8B 44 24 28 25 00 F0 00 00 3D 00 40 00 00 0F 84 C5 FE FF FF 0F 1F 80 00 00 00 00 BB 26 00 00 00 48 8B 2D ?? ?? ?? ?? E9 B4 FE FF FF 0F 1F 80 00 00 00 00 48 8B 2D ?? ?? ?? ?? 45 84 E4 0F 84 9D FE FF FF 49 8D 78 0E BE 2F 00 00 00 4C 89 44 24 08 E8 ?? ?? ?? ?? C6 00 00 4C 8B 44 24 08 48 8D 54 24 10 BF 01 00 00 00 4C 89 C6 E8 ?? ?? ?? ?? 83 F8 FF 74 26 85 C0 0F 85 63 FE FF FF 8B 44 24 28 25 00 F0 00 00 3D 00 A0 00 00 B8 09 00 00 00 0F 45 D8 E9 48 FE FF FF 0F 1F 00 64 83 7D 00 02 B8 09 00 00 00 0F 44 D8 E9 33 FE FF FF 66 0F 1F 44 00 00 48 8B 2D ?? ?? ?? ?? 64 83 7D 00 02 0F 85 75 FF FF FF BB 09 00 00 00 E9 11 FE FF FF 48 8D 54 24 10 BE ?? ?? ?? ?? BF 01 00 00 00 E8 ?? ?? ?? ?? 85 C0 8B 4C 24 08 0F 85 2C FF FF FF 8B 44 24 28 25 00 F0 00 00 3D 00 40 00 00 0F 85 18 FF FF FF E9 AA FE FF FF }
	condition:
		$1
}

rule file_54_1_0 {
	meta:
		name = "renameat"
		size = 425
		refs = "0024 __have_atfcts 0073 __libc_errno 009f strlen 00d8 __snprintf 0163 __atfct_seterrno_2"
	strings:
		$1 = { 55 48 89 E5 48 89 5D D8 4C 89 65 E0 48 89 F3 4C 89 6D E8 4C 89 7D F8 41 89 D5 4C 89 75 F0 48 83 EC 40 8B 05 ?? ?? ?? ?? 41 89 FF 49 89 CC 85 C0 78 56 49 89 CA 48 63 D2 48 63 FF B8 08 01 00 00 0F 05 48 3D 00 F0 FF FF 0F 87 34 01 00 00 83 F8 FF 74 1D 48 8B 5D D8 4C 8B 65 E0 4C 8B 6D E8 4C 8B 75 F0 4C 8B 7D F8 C9 C3 0F 1F 80 00 00 00 00 48 8B 15 ?? ?? ?? ?? 64 83 3A 26 B8 FF FF FF FF 75 D1 89 05 ?? ?? ?? ?? 41 83 FF 9C 0F 84 DE 00 00 00 80 3B 2F 0F 84 D5 00 00 00 48 89 DF E8 ?? ?? ?? ?? 48 85 C0 0F 84 E7 00 00 00 48 8D 70 20 48 83 C0 3E 49 89 D8 48 83 E0 F0 44 89 F9 BA ?? ?? ?? ?? 48 29 C4 31 C0 4C 8D 74 24 0F 49 83 E6 F0 4C 89 F7 4C 89 F3 E8 ?? ?? ?? ?? 41 83 FD 9C 0F 84 97 00 00 00 41 80 3C 24 2F 0F 84 8C 00 00 00 4C 89 E7 E8 ?? ?? ?? ?? 48 85 C0 0F 84 91 00 00 00 48 8D 70 20 48 83 C0 3E 4D 89 E0 48 83 E0 F0 44 89 E9 BA ?? ?? ?? ?? 48 29 C4 31 C0 4C 8D 4C 24 0F 49 83 E1 F0 4C 89 CF 4C 89 4D C8 E8 ?? ?? ?? ?? 4C 8B 4D C8 4D 89 CC 4C 89 E6 48 89 DF B8 52 00 00 00 0F 05 3D 00 F0 FF FF 0F 86 01 FF FF FF 89 C7 4D 89 F0 44 89 F9 F7 DF 4C 89 CA 44 89 EE E8 ?? ?? ?? ?? 83 C8 FF E9 E4 FE FF FF 90 45 31 F6 41 83 FD 9C 0F 85 69 FF FF FF 45 31 C9 EB B8 48 8B 15 ?? ?? ?? ?? F7 D8 64 89 02 E9 E4 FE FF FF 48 8B 05 ?? ?? ?? ?? 64 C7 00 02 00 00 00 83 C8 FF E9 AA FE FF FF }
	condition:
		$1
}

rule file_55_0_0 {
	meta:
		name = "__getdate_r"
		size = 1284
		refs = "002c getenv 008f __xstat64 00b6 __access 00d1 _IO_new_fopen 0160 strptime 0184 __getline 01b3 free 01c0 _IO_new_fclose 01f1 time 0200 __localtime_r 033e mktime"
	strings:
		$1 = { 48 89 6C 24 E0 4C 89 64 24 E8 49 89 F4 4C 89 6C 24 F0 48 89 5C 24 D8 49 89 FD 4C 89 74 24 F8 BF ?? ?? ?? ?? 48 81 EC 58 01 00 00 E8 ?? ?? ?? ?? 48 85 C0 BD 01 00 00 00 74 05 80 38 00 75 39 89 E8 48 8B 9C 24 30 01 00 00 48 8B AC 24 38 01 00 00 4C 8B A4 24 40 01 00 00 4C 8B AC 24 48 01 00 00 4C 8B B4 24 50 01 00 00 48 81 C4 58 01 00 00 C3 0F 1F 80 00 00 00 00 48 8D 94 24 A0 00 00 00 48 89 C6 BF 01 00 00 00 48 89 C3 40 B5 03 E8 ?? ?? ?? ?? 85 C0 78 A8 8B 84 24 B8 00 00 00 40 B5 04 25 00 F0 00 00 3D 00 80 00 00 75 92 BE 04 00 00 00 48 89 DF E8 ?? ?? ?? ?? 85 C0 79 0A BD 02 00 00 00 E9 77 FF FF FF 48 89 DF BE ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 85 C0 48 89 C3 74 E1 81 08 00 80 00 00 45 31 F6 48 C7 44 24 08 00 00 00 00 48 C7 44 24 10 00 00 00 00 EB 7C 66 0F 1F 44 00 00 41 C7 44 24 18 00 00 00 80 41 C7 44 24 0C 00 00 00 80 4C 89 E2 41 C7 44 24 10 00 00 00 80 41 C7 44 24 14 00 00 00 80 4C 89 EF 41 C7 44 24 04 00 00 00 80 41 C7 04 24 00 00 00 80 41 C7 44 24 08 00 00 00 80 41 C7 44 24 20 FF FF FF FF 49 C7 44 24 28 00 00 00 00 49 C7 44 24 30 00 00 00 00 E8 ?? ?? ?? ?? 48 85 C0 49 89 C6 74 05 80 38 00 74 3C F6 03 10 75 37 48 8D 74 24 10 48 8D 7C 24 08 48 89 DA E8 ?? ?? ?? ?? 48 85 C0 78 20 48 8B 74 24 08 48 8D 44 06 FF 80 38 0A 0F 85 60 FF FF FF C6 00 00 48 8B 74 24 08 E9 53 FF FF FF 48 8B 7C 24 08 E8 ?? ?? ?? ?? F6 03 20 48 89 DF 74 0F E8 ?? ?? ?? ?? BD 05 00 00 00 E9 71 FE FF FF E8 ?? ?? ?? ?? 4D 85 F6 BD 07 00 00 00 0F 84 5E FE FF FF 41 80 3E 00 0F 85 54 FE FF FF 48 8D 7C 24 18 E8 ?? ?? ?? ?? 48 8D 74 24 20 48 8D 7C 24 18 E8 ?? ?? ?? ?? 41 8B 5C 24 18 31 D2 83 FB 06 77 15 48 B8 00 00 00 80 00 00 00 80 49 39 44 24 10 0F 84 1B 02 00 00 41 8B 74 24 10 83 FE 0B 77 0F 41 81 7C 24 0C 00 00 00 80 0F 84 46 02 00 00 41 81 7C 24 08 00 00 00 80 0F 84 6E 01 00 00 41 81 7C 24 04 00 00 00 80 0F 84 51 01 00 00 41 81 3C 24 00 00 00 80 0F 84 36 01 00 00 41 8B 44 24 08 83 F8 17 77 0F 41 81 7C 24 10 00 00 00 80 0F 84 56 01 00 00 41 81 7C 24 14 00 00 00 80 0F 84 EA 00 00 00 41 81 7C 24 10 00 00 00 80 0F 84 CD 00 00 00 85 D2 0F 85 8F 00 00 00 41 83 7C 24 10 0B 41 8B 74 24 0C 41 8B 54 24 14 0F 87 9B 00 00 00 49 63 4C 24 10 48 B8 00 00 00 00 00 00 50 AB 48 D3 E0 48 85 C0 0F 88 8A 00 00 00 48 B8 00 00 00 00 00 00 A0 14 48 D3 E0 48 85 C0 78 66 48 B8 00 00 00 00 00 00 00 40 48 D3 E0 48 85 C0 79 5C 85 F6 7E 58 8D 8A 6C 07 00 00 BF 1C 00 00 00 F6 C1 03 75 19 89 CA 41 B8 64 00 00 00 89 C8 C1 FA 1F 41 F7 F8 85 D2 74 64 BF 1D 00 00 00 39 FE BD 08 00 00 00 0F 8F 07 FD FF FF 4C 89 E7 31 ED E8 ?? ?? ?? ?? 48 83 C0 01 40 0F 94 C5 C1 E5 03 E9 ED FC FF FF 83 EE 01 83 FE 1D 76 DE BD 08 00 00 00 E9 DB FC FF FF 83 EE 01 83 FE 1E 77 EE EB CA 8B 44 24 30 41 89 44 24 10 E9 25 FF FF FF 8B 44 24 34 41 89 44 24 14 E9 08 FF FF FF 89 CA 41 B8 90 01 00 00 89 C8 C1 FA 1F 41 F7 F8 85 D2 74 88 EB 8B 41 C7 04 24 00 00 00 00 E9 BD FE FF FF 41 C7 44 24 04 00 00 00 00 E9 A1 FE FF FF 48 B8 00 00 00 80 00 00 00 80 49 39 04 24 74 4F 41 C7 44 24 08 00 00 00 00 E9 74 FE FF FF 41 81 7C 24 0C 00 00 00 80 0F 85 9B FE FF FF 41 81 7C 24 18 00 00 00 80 0F 85 8C FE FF FF 2B 44 24 28 8B 54 24 30 41 89 54 24 10 BA 01 00 00 00 C1 E8 1F 03 44 24 2C 41 89 44 24 0C E9 69 FE FF FF 8B 4C 24 24 8B 44 24 28 41 89 4C 24 04 8B 4C 24 20 3D 00 00 00 80 41 89 44 24 08 41 89 0C 24 74 90 E9 0D FE FF FF 41 81 7C 24 0C 00 00 00 80 0F 85 D6 FD FF FF 8B 44 24 34 41 89 44 24 14 8B 44 24 30 41 89 44 24 10 89 D8 2B 44 24 38 83 C0 07 89 C2 C1 FA 1F F7 FD 03 54 24 2C 41 89 54 24 0C BA 01 00 00 00 E9 A1 FD FF FF 41 81 7C 24 14 00 00 00 80 75 12 89 F0 2B 44 24 30 C1 E8 1F 03 44 24 34 41 89 44 24 14 81 FB 00 00 00 80 45 8B 44 24 14 B8 01 00 00 00 74 42 48 8D 54 24 60 30 C0 B9 0E 00 00 00 48 89 D7 F3 AB 48 89 D7 44 89 44 24 74 89 74 24 70 C7 44 24 6C 01 00 00 00 E8 ?? ?? ?? ?? 89 D8 2B 44 24 78 B9 07 00 00 00 83 C0 07 89 C2 C1 FA 1F F7 F9 8D 42 01 41 89 44 24 0C BA 01 00 00 00 E9 3A FD FF FF }
	condition:
		$1
}

rule file_55_1_0 {
	meta:
		name = "getdate"
		size = 48
		refs = "000a __getdate_r 0024 getdate_err"
	strings:
		$1 = { 48 83 EC 08 BE ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 BA ?? ?? ?? ?? 75 09 48 89 D0 48 83 C4 08 C3 90 31 D2 89 05 ?? ?? ?? ?? 48 83 C4 08 48 89 D0 C3 }
	condition:
		$1
}

rule file_56_0_0 {
	meta:
		name = "__nss_ethers_lookup2"
		size = 158
		refs = "001e __nss_ethers_database 006f __nss_database_lookup 0058 __nss_lookup"
	strings:
		$1 = { 48 89 5C 24 E0 48 89 6C 24 E8 48 89 FB 4C 89 64 24 F0 4C 89 6C 24 F8 48 83 EC 28 48 8B 05 ?? ?? ?? ?? 48 89 F5 49 89 D4 49 89 CD 48 85 C0 74 30 48 89 03 4C 89 E9 4C 89 E2 48 89 EE 48 89 DF 48 8B 6C 24 10 48 8B 5C 24 08 4C 8B 64 24 18 4C 8B 6C 24 20 48 83 C4 28 E9 ?? ?? ?? ?? 0F 1F 40 00 31 D2 31 F6 B9 ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 78 09 48 8B 05 ?? ?? ?? ?? EB B0 B8 FF FF FF FF 48 8B 5C 24 08 48 8B 6C 24 10 4C 8B 64 24 18 4C 8B 6C 24 20 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_879_0_0 {
	meta:
		name = "__nss_aliases_lookup2"
		size = 158
		refs = "001e __nss_aliases_database 006f __nss_database_lookup 0058 __nss_lookup"
	strings:
		$1 = { 48 89 5C 24 E0 48 89 6C 24 E8 48 89 FB 4C 89 64 24 F0 4C 89 6C 24 F8 48 83 EC 28 48 8B 05 ?? ?? ?? ?? 48 89 F5 49 89 D4 49 89 CD 48 85 C0 74 30 48 89 03 4C 89 E9 4C 89 E2 48 89 EE 48 89 DF 48 8B 6C 24 10 48 8B 5C 24 08 4C 8B 64 24 18 4C 8B 6C 24 20 48 83 C4 28 E9 ?? ?? ?? ?? 0F 1F 40 00 31 D2 31 F6 B9 ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 78 09 48 8B 05 ?? ?? ?? ?? EB B0 B8 FF FF FF FF 48 8B 5C 24 08 48 8B 6C 24 10 4C 8B 64 24 18 4C 8B 6C 24 20 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_828_0_0 {
	meta:
		name = "__nss_netgroup_lookup2"
		size = 158
		refs = "001e __nss_netgroup_database 006f __nss_database_lookup 0058 __nss_lookup"
	strings:
		$1 = { 48 89 5C 24 E0 48 89 6C 24 E8 48 89 FB 4C 89 64 24 F0 4C 89 6C 24 F8 48 83 EC 28 48 8B 05 ?? ?? ?? ?? 48 89 F5 49 89 D4 49 89 CD 48 85 C0 74 30 48 89 03 4C 89 E9 4C 89 E2 48 89 EE 48 89 DF 48 8B 6C 24 10 48 8B 5C 24 08 4C 8B 64 24 18 4C 8B 6C 24 20 48 83 C4 28 E9 ?? ?? ?? ?? 0F 1F 40 00 31 D2 31 F6 B9 ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 78 09 48 8B 05 ?? ?? ?? ?? EB B0 B8 FF FF FF FF 48 8B 5C 24 08 48 8B 6C 24 10 4C 8B 64 24 18 4C 8B 6C 24 20 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_662_0_0 {
	meta:
		name = "__nss_protocols_lookup2"
		size = 158
		refs = "001e __nss_protocols_database 006f __nss_database_lookup 0058 __nss_lookup"
	strings:
		$1 = { 48 89 5C 24 E0 48 89 6C 24 E8 48 89 FB 4C 89 64 24 F0 4C 89 6C 24 F8 48 83 EC 28 48 8B 05 ?? ?? ?? ?? 48 89 F5 49 89 D4 49 89 CD 48 85 C0 74 30 48 89 03 4C 89 E9 4C 89 E2 48 89 EE 48 89 DF 48 8B 6C 24 10 48 8B 5C 24 08 4C 8B 64 24 18 4C 8B 6C 24 20 48 83 C4 28 E9 ?? ?? ?? ?? 0F 1F 40 00 31 D2 31 F6 B9 ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 78 09 48 8B 05 ?? ?? ?? ?? EB B0 B8 FF FF FF FF 48 8B 5C 24 08 48 8B 6C 24 10 4C 8B 64 24 18 4C 8B 6C 24 20 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_280_0_0 {
	meta:
		name = "__nss_rpc_lookup2"
		size = 158
		refs = "001e __nss_rpc_database 006f __nss_database_lookup 0058 __nss_lookup"
	strings:
		$1 = { 48 89 5C 24 E0 48 89 6C 24 E8 48 89 FB 4C 89 64 24 F0 4C 89 6C 24 F8 48 83 EC 28 48 8B 05 ?? ?? ?? ?? 48 89 F5 49 89 D4 49 89 CD 48 85 C0 74 30 48 89 03 4C 89 E9 4C 89 E2 48 89 EE 48 89 DF 48 8B 6C 24 10 48 8B 5C 24 08 4C 8B 64 24 18 4C 8B 6C 24 20 48 83 C4 28 E9 ?? ?? ?? ?? 0F 1F 40 00 31 D2 31 F6 B9 ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 78 09 48 8B 05 ?? ?? ?? ?? EB B0 B8 FF FF FF FF 48 8B 5C 24 08 48 8B 6C 24 10 4C 8B 64 24 18 4C 8B 6C 24 20 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_658_0_0 {
	meta:
		name = "__nss_services_lookup2"
		size = 158
		refs = "001e __nss_services_database 006f __nss_database_lookup 0058 __nss_lookup"
	strings:
		$1 = { 48 89 5C 24 E0 48 89 6C 24 E8 48 89 FB 4C 89 64 24 F0 4C 89 6C 24 F8 48 83 EC 28 48 8B 05 ?? ?? ?? ?? 48 89 F5 49 89 D4 49 89 CD 48 85 C0 74 30 48 89 03 4C 89 E9 4C 89 E2 48 89 EE 48 89 DF 48 8B 6C 24 10 48 8B 5C 24 08 4C 8B 64 24 18 4C 8B 6C 24 20 48 83 C4 28 E9 ?? ?? ?? ?? 0F 1F 40 00 31 D2 31 F6 B9 ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 78 09 48 8B 05 ?? ?? ?? ?? EB B0 B8 FF FF FF FF 48 8B 5C 24 08 48 8B 6C 24 10 4C 8B 64 24 18 4C 8B 6C 24 20 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_58_0_0 {
	meta:
		name = "__setstate_r"
		size = 228
		refs = "00d3 __libc_errno"
	strings:
		$1 = { 48 85 F6 48 8D 4F 04 0F 84 C3 00 00 00 48 85 FF 0F 84 BA 00 00 00 8B 56 18 48 8B 46 10 85 D2 0F 84 9B 00 00 00 4C 8B 46 08 49 29 C0 49 C1 E8 02 47 8D 04 80 44 01 C2 89 50 FC 44 8B 07 41 B9 67 66 66 66 44 89 C0 41 F7 E9 44 89 C0 C1 F8 1F D1 FA 29 C2 8D 04 92 44 89 C2 29 C2 83 FA 04 77 70 48 63 C2 85 D2 89 56 18 4C 63 04 85 ?? ?? ?? ?? 44 8B 14 85 ?? ?? ?? ?? 44 89 56 20 44 89 46 1C 74 2F 8B 3F 89 F8 C1 FF 1F 41 F7 E9 D1 FA 29 FA 48 63 C2 48 8D 04 81 48 89 46 08 42 8D 04 12 89 C2 C1 FA 1F 41 F7 F8 48 63 D2 48 8D 04 91 48 89 06 4A 8D 04 81 48 89 4E 10 48 89 46 28 31 C0 C3 C7 40 FC 00 00 00 00 E9 6E FF FF FF 0F 1F 40 00 48 8B 05 ?? ?? ?? ?? 64 C7 00 16 00 00 00 B8 FF FF FF FF C3 }
	condition:
		$1
}

rule file_58_1_0 {
	meta:
		name = "__random_r"
		size = 148
		refs = "0083 __libc_errno"
	strings:
		$1 = { 48 85 F6 74 7B 48 85 FF 74 76 8B 57 18 48 8B 4F 10 85 D2 74 4B 48 8B 17 4C 8B 47 08 4C 8B 4F 28 8B 02 41 03 00 48 83 C2 04 89 42 FC D1 E8 49 39 D1 89 06 49 8D 40 04 76 17 49 39 C1 48 89 17 48 0F 46 C1 48 89 47 08 31 C0 C3 66 0F 1F 44 00 00 48 89 CA 48 89 47 08 31 C0 48 89 17 C3 0F 1F 00 8B 01 69 C0 6D 4E C6 41 05 39 30 00 00 25 FF FF FF 7F 89 01 89 06 31 C0 C3 0F 1F 80 00 00 00 00 48 8B 05 ?? ?? ?? ?? 64 C7 00 16 00 00 00 B8 FF FF FF FF C3 }
	condition:
		$1
}

rule file_58_2_0 {
	meta:
		name = "__srandom_r"
		size = 212
		refs = "00bc __random_r"
	strings:
		$1 = { 48 85 F6 0F 84 C5 00 00 00 8B 46 18 83 F8 04 0F 87 B9 00 00 00 55 48 89 F5 B9 01 00 00 00 53 48 83 EC 10 48 8B 76 10 85 FF 0F 45 CF 85 C0 89 0E 0F 84 8F 00 00 00 44 8B 55 1C 41 B8 01 00 00 00 41 B9 5F 0B 4E 83 49 63 FA 48 83 FF 01 7E 40 90 89 C8 41 F7 E9 89 C8 C1 F8 1F 01 CA C1 FA 10 29 C2 69 C2 EC F4 FF FF 69 D2 1D F3 01 00 29 D1 69 C9 A7 41 00 00 01 C1 8D 81 FF FF FF 7F 85 C9 0F 48 C8 42 89 0C 86 49 83 C0 01 49 39 F8 7C C1 48 63 45 20 48 89 75 08 48 8D 04 86 48 89 45 00 43 8D 04 92 8D 5C 00 FF 85 DB 78 1A 0F 1F 44 00 00 48 8D 74 24 0C 48 89 EF 83 EB 01 E8 ?? ?? ?? ?? 83 FB FF 75 EB 48 83 C4 10 31 C0 5B 5D C3 B8 FF FF FF FF C3 }
	condition:
		$1
}

rule file_58_3_0 {
	meta:
		name = "__initstate_r"
		size = 341
		refs = "0081 __srandom_r 0140 __libc_errno"
	strings:
		$1 = { 48 89 5C 24 E0 48 89 6C 24 E8 4C 89 64 24 F0 4C 89 6C 24 F8 48 83 EC 20 48 85 C9 0F 84 1C 01 00 00 48 8B 41 10 49 89 F5 48 89 CB 48 85 C0 74 12 8B 49 18 85 C9 0F 85 D5 00 00 00 C7 40 FC 00 00 00 00 48 83 FA 7F 77 68 48 83 FA 1F 0F 87 DE 00 00 00 48 83 FA 07 0F 86 E1 00 00 00 49 8D 45 04 C7 43 18 00 00 00 00 C7 43 20 00 00 00 00 C7 43 1C 00 00 00 00 48 89 DE 48 89 43 28 48 89 43 10 E8 ?? ?? ?? ?? 41 C7 45 00 00 00 00 00 31 C0 48 8B 1C 24 48 8B 6C 24 08 4C 8B 64 24 10 4C 8B 6C 24 18 48 83 C4 20 C3 66 0F 1F 84 00 00 00 00 00 48 81 FA 00 01 00 00 19 ED 83 C5 04 89 E8 48 63 C8 4D 8D 65 04 89 43 18 48 63 14 8D ?? ?? ?? ?? 8B 0C 8D ?? ?? ?? ?? 48 89 DE 4C 89 63 10 89 4B 20 49 8D 04 94 89 53 1C 48 89 43 28 E8 ?? ?? ?? ?? 48 8B 43 08 4C 29 E0 48 C1 E8 02 8D 04 80 01 C5 31 C0 41 89 6D 00 EB 86 0F 1F 80 00 00 00 00 48 8B 73 08 48 29 C6 48 C1 EE 02 8D 34 B6 01 F1 48 83 FA 7F 89 48 FC 0F 86 1B FF FF FF EB 81 90 48 83 FA 40 19 ED 83 C5 02 89 E8 EB 81 48 8B 05 ?? ?? ?? ?? 64 C7 00 16 00 00 00 B8 FF FF FF FF E9 3A FF FF FF }
	condition:
		$1
}

rule file_59_0_0 {
	meta:
		name = "_L_lock_42"
		size = 27
		refs = "000b __lll_lock_wait_private"
	strings:
		$1 = { 48 8D 3A 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 11 FF FF FF }
	condition:
		$1
}

rule file_59_1_0 {
	meta:
		name = "_L_unlock_106"
		size = 27
		refs = "000b __lll_unlock_wake_private"
		altNames = "_L_unlock_114"
	strings:
		$1 = { 48 8D 3E 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 6D FF FF FF }
	condition:
		$1
}

rule file_59_3_0 {
	meta:
		name = "fputwc"
		size = 289
		refs = "0031 __libc_multiple_threads 0065 _IO_fwide 00dd __woverflow 011d _Unwind_Resume"
	strings:
		$1 = { 55 89 FD 53 48 89 F3 48 83 EC 08 8B 06 25 00 80 00 00 75 48 48 8B 96 88 00 00 00 64 4C 8B 04 25 10 00 00 00 4C 3B 42 08 74 2E BE 01 00 00 00 83 3D ?? ?? ?? ?? 00 74 0C F0 0F B1 32 0F 85 DF 00 00 00 EB 09 0F B1 32 0F 85 D4 00 00 00 48 8B 93 88 00 00 00 4C 89 42 08 83 42 04 01 BE 01 00 00 00 48 89 DF E8 ?? ?? ?? ?? 85 C0 78 63 48 8B 83 A0 00 00 00 48 85 C0 74 5E 48 8B 48 20 48 3B 48 28 73 54 89 29 48 83 C1 04 89 EA 48 89 48 20 F7 03 00 80 00 00 75 2D 48 8B B3 88 00 00 00 83 6E 04 01 75 20 48 C7 46 08 00 00 00 00 83 3D ?? ?? ?? ?? 00 74 0B F0 FF 0E 0F 85 7E 00 00 00 EB 04 FF 0E 75 78 48 83 C4 08 89 D0 5B 5D C3 0F 1F 00 BA FF FF FF FF EB B8 89 EE 48 89 DF E8 ?? ?? ?? ?? 89 C2 EB AA F7 03 00 80 00 00 48 89 C6 75 29 48 8B 93 88 00 00 00 83 6A 04 01 75 1C 48 C7 42 08 00 00 00 00 83 3D ?? ?? ?? ?? 00 74 07 F0 FF 0A 75 44 EB 04 FF 0A 75 3E 48 89 F7 E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_60_0_0 {
	meta:
		name = "__towctrans_l"
		size = 66
		altNames = "__towctrans"
	strings:
		$1 = { 48 85 F6 89 F8 74 39 8B 0E 89 FA D3 EA 3B 56 04 73 2E 83 C2 05 8B 14 96 85 D2 74 24 8B 4E 08 D3 EF 89 F9 23 4E 0C 48 8D 14 8A 8B 14 16 85 D2 74 0F 89 C1 23 4E 10 48 8D 14 8A 03 04 16 0F 1F 00 F3 C3 }
	condition:
		$1
}

rule file_61_0_0 {
	meta:
		name = "wcscmp"
		size = 3268
	strings:
		$1 = { 89 F0 89 FA 66 0F EF C0 88 C5 88 D1 83 E0 3F 83 E2 3F 80 E1 0F 0F 84 45 02 00 00 83 FA 10 0F 82 09 01 00 00 83 FA 20 0F 82 53 04 00 00 83 FA 30 0F 82 1A 03 00 00 80 E5 0F 0F 84 11 07 00 00 83 F8 10 0F 82 18 01 00 00 83 F8 20 0F 82 5F 04 00 00 83 F8 30 0F 82 26 03 00 00 66 0F 1F 44 00 00 8B 0E 39 0F 0F 85 46 0C 00 00 85 C9 0F 84 4E 0C 00 00 8B 4E 04 39 4F 04 0F 85 32 0C 00 00 85 C9 0F 84 3A 0C 00 00 8B 4E 08 39 4F 08 0F 85 1E 0C 00 00 85 C9 0F 84 26 0C 00 00 8B 4E 0C 39 4F 0C 0F 85 0A 0C 00 00 85 C9 0F 84 12 0C 00 00 F3 0F 6F 4F 10 F3 0F 6F 56 10 66 0F 76 C1 66 0F 76 CA 66 0F F8 C8 66 0F D7 D1 81 EA FF FF 00 00 0F 85 DC 0A 00 00 F3 0F 6F 4F 20 F3 0F 6F 56 20 66 0F 76 C1 66 0F 76 CA 66 0F F8 C8 66 0F D7 D1 81 EA FF FF 00 00 0F 85 16 0B 00 00 F3 0F 6F 4F 30 F3 0F 6F 56 30 66 0F 76 C1 66 0F 76 CA 66 0F F8 C8 66 0F D7 D1 81 EA FF FF 00 00 0F 85 40 0B 00 00 48 83 C6 40 48 83 C7 40 E9 33 FF FF FF 80 E5 0F 0F 84 5A 07 00 00 83 F8 10 0F 82 71 08 00 00 83 F8 20 0F 82 E8 08 00 00 83 F8 30 0F 82 3F 09 00 00 66 66 66 66 66 66 2E 0F 1F 84 00 00 00 00 00 8B 0E 39 0F 0F 85 46 0B 00 00 85 C9 0F 84 4E 0B 00 00 8B 4E 04 39 4F 04 0F 85 32 0B 00 00 85 C9 0F 84 3A 0B 00 00 8B 4E 08 39 4F 08 0F 85 1E 0B 00 00 85 C9 0F 84 26 0B 00 00 8B 4E 0C 39 4F 0C 0F 85 0A 0B 00 00 85 C9 0F 84 12 0B 00 00 F3 0F 6F 4F 10 F3 0F 6F 56 10 66 0F 76 C1 66 0F 76 CA 66 0F F8 C8 66 0F D7 D1 81 EA FF FF 00 00 0F 85 DC 09 00 00 F3 0F 6F 4F 20 F3 0F 6F 56 20 66 0F 76 C1 66 0F 76 CA 66 0F F8 C8 66 0F D7 D1 81 EA FF FF 00 00 0F 85 16 0A 00 00 8B 4E 30 39 4F 30 0F 85 AA 0A 00 00 85 C9 0F 84 B2 0A 00 00 8B 4E 34 39 4F 34 0F 85 96 0A 00 00 85 C9 0F 84 9E 0A 00 00 8B 4E 38 39 4F 38 0F 85 82 0A 00 00 85 C9 0F 84 8A 0A 00 00 8B 4E 3C 39 4F 3C 0F 85 6E 0A 00 00 85 C9 0F 84 76 0A 00 00 48 83 C6 40 48 83 C7 40 E9 09 FF FF FF 66 0F 1F 84 00 00 00 00 00 80 E5 0F 0F 84 47 03 00 00 83 F8 10 0F 82 5E 04 00 00 83 F8 20 0F 82 05 04 00 00 83 F8 30 0F 82 CC 03 00 00 66 66 66 2E 0F 1F 84 00 00 00 00 00 66 0F 76 07 8B 07 66 0F D7 C8 85 C9 0F 85 5E 08 00 00 3B 06 0F 85 06 0A 00 00 8B 47 04 3B 46 04 0F 85 FA 09 00 00 8B 47 08 3B 46 08 0F 85 EE 09 00 00 8B 47 0C 3B 46 0C 0F 85 E2 09 00 00 F3 0F 6F 56 10 66 0F 76 C2 66 0F 76 57 10 66 0F F8 D0 66 0F D7 D2 81 EA FF FF 00 00 0F 85 C0 08 00 00 F3 0F 6F 56 20 66 0F 76 C2 66 0F 76 57 20 66 0F F8 D0 66 0F D7 D2 81 EA FF FF 00 00 0F 85 FE 08 00 00 F3 0F 6F 56 30 66 0F 76 C2 66 0F 76 57 30 66 0F F8 D0 66 0F D7 D2 81 EA FF FF 00 00 0F 85 2C 09 00 00 48 83 C6 40 48 83 C7 40 E9 4F FF FF FF 66 66 66 66 66 66 2E 0F 1F 84 00 00 00 00 00 80 E5 0F 0F 84 B7 04 00 00 83 F8 10 0F 82 2E 07 00 00 83 F8 20 0F 82 65 07 00 00 83 F8 30 0F 82 9C 05 00 00 66 66 66 2E 0F 1F 84 00 00 00 00 00 8B 0E 39 0F 0F 85 26 09 00 00 85 C9 0F 84 2E 09 00 00 8B 4E 04 39 4F 04 0F 85 12 09 00 00 85 C9 0F 84 1A 09 00 00 8B 4E 08 39 4F 08 0F 85 FE 08 00 00 85 C9 0F 84 06 09 00 00 8B 4E 0C 39 4F 0C 0F 85 EA 08 00 00 85 C9 0F 84 F2 08 00 00 8B 4E 10 39 4F 10 0F 85 D6 08 00 00 85 C9 0F 84 DE 08 00 00 8B 4E 14 39 4F 14 0F 85 C2 08 00 00 85 C9 0F 84 CA 08 00 00 8B 4E 18 39 4F 18 0F 85 AE 08 00 00 85 C9 0F 84 B6 08 00 00 8B 4E 1C 39 4F 1C 0F 85 9A 08 00 00 85 C9 0F 84 A2 08 00 00 F3 0F 6F 4F 20 F3 0F 6F 56 20 66 0F 76 C1 66 0F 76 CA 66 0F F8 C8 66 0F D7 D1 81 EA FF FF 00 00 0F 85 CC 07 00 00 F3 0F 6F 4F 30 F3 0F 6F 56 30 66 0F 76 C1 66 0F 76 CA 66 0F F8 C8 66 0F D7 D1 81 EA FF FF 00 00 0F 85 F6 07 00 00 48 83 C6 40 48 83 C7 40 E9 09 FF FF FF 66 0F 1F 84 00 00 00 00 00 80 E5 0F 0F 84 B7 03 00 00 83 F8 10 0F 82 9E 05 00 00 83 F8 20 0F 82 B5 04 00 00 83 F8 30 0F 82 2C 06 00 00 66 66 66 2E 0F 1F 84 00 00 00 00 00 8B 0E 39 0F 0F 85 F6 07 00 00 85 C9 0F 84 FE 07 00 00 8B 4E 04 39 4F 04 0F 85 E2 07 00 00 85 C9 0F 84 EA 07 00 00 8B 4E 08 39 4F 08 0F 85 CE 07 00 00 85 C9 0F 84 D6 07 00 00 8B 4E 0C 39 4F 0C 0F 85 BA 07 00 00 85 C9 0F 84 C2 07 00 00 F3 0F 6F 4F 10 F3 0F 6F 56 10 66 0F 76 C1 66 0F 76 CA 66 0F F8 C8 66 0F D7 D1 81 EA FF FF 00 00 0F 85 8C 06 00 00 8B 4E 20 39 4F 20 0F 85 80 07 00 00 85 C9 0F 84 88 07 00 00 8B 4E 24 39 4F 24 0F 85 6C 07 00 00 85 C9 0F 84 74 07 00 00 8B 4E 28 39 4F 28 0F 85 58 07 00 00 85 C9 0F 84 60 07 00 00 8B 4E 2C 39 4F 2C 0F 85 44 07 00 00 85 C9 0F 84 4C 07 00 00 F3 0F 6F 4F 30 F3 0F 6F 56 30 66 0F 76 C1 66 0F 76 CA 66 0F F8 C8 66 0F D7 D1 81 EA FF FF 00 00 0F 85 C6 06 00 00 48 83 C6 40 48 83 C7 40 E9 09 FF FF FF 66 0F 1F 84 00 00 00 00 00 66 0F 6F 0F 66 0F 76 C1 66 0F 76 0E 66 0F F8 C8 66 0F D7 D1 81 EA FF FF 00 00 0F 85 80 05 00 00 66 0F 6F 5F 10 66 0F 76 C3 66 0F 76 5E 10 66 0F F8 D8 66 0F D7 D3 81 EA FF FF 00 00 0F 85 BE 05 00 00 66 0F 6F 6F 20 66 0F 76 C5 66 0F 76 6E 20 66 0F F8 E8 66 0F D7 D5 81 EA FF FF 00 00 0F 85 FC 05 00 00 66 0F 6F 4F 30 66 0F 76 C1 66 0F 76 4E 30 66 0F F8 C8 66 0F D7 D1 81 EA FF FF 00 00 0F 85 2A 06 00 00 48 83 C6 40 48 83 C7 40 E9 6D FF FF FF 66 66 66 66 2E 0F 1F 84 00 00 00 00 00 F3 0F 6F 16 66 0F 76 C2 66 0F 76 17 66 0F F8 D0 66 0F D7 D2 81 EA FF FF 00 00 0F 85 E0 04 00 00 48 83 C6 10 48 83 C7 10 E9 13 FC FF FF 0F 1F 00 F3 0F 6F 16 66 0F 76 C2 66 0F 76 17 66 0F F8 D0 66 0F D7 D2 81 EA FF FF 00 00 0F 85 B0 04 00 00 F3 0F 6F 56 10 66 0F 76 C2 66 0F 76 57 10 66 0F F8 D0 66 0F D7 D2 81 EA FF FF 00 00 0F 85 EE 04 00 00 48 83 C6 20 48 83 C7 20 E9 C1 FB FF FF 90 F3 0F 6F 16 66 0F 76 C2 66 0F 76 17 66 0F F8 D0 66 0F D7 D2 81 EA FF FF 00 00 0F 85 60 04 00 00 F3 0F 6F 56 10 66 0F 76 C2 66 0F 76 57 10 66 0F F8 D0 66 0F D7 D2 81 EA FF FF 00 00 0F 85 9E 04 00 00 F3 0F 6F 56 20 66 0F 76 C2 66 0F 76 57 20 66 0F F8 D0 66 0F D7 D2 81 EA FF FF 00 00 0F 85 DC 04 00 00 48 83 C6 30 48 83 C7 30 E9 4F FB FF FF 66 66 66 66 66 66 2E 0F 1F 84 00 00 00 00 00 66 0F 76 06 8B 07 66 0F D7 C8 85 C9 0F 85 9E 03 00 00 3B 06 0F 85 46 05 00 00 8B 47 04 3B 46 04 0F 85 3A 05 00 00 8B 47 08 3B 46 08 0F 85 2E 05 00 00 8B 47 0C 3B 46 0C 0F 85 22 05 00 00 F3 0F 6F 4F 10 66 0F 76 C1 66 0F 76 4E 10 66 0F F8 C8 66 0F D7 D1 81 EA FF FF 00 00 0F 85 00 04 00 00 F3 0F 6F 4F 20 66 0F 76 C1 66 0F 76 4E 20 66 0F F8 C8 66 0F D7 D1 81 EA FF FF 00 00 0F 85 3E 04 00 00 F3 0F 6F 4F 30 66 0F 76 C1 66 0F 76 4E 30 66 0F F8 C8 66 0F D7 D1 81 EA FF FF 00 00 0F 85 6C 04 00 00 48 83 C6 40 48 83 C7 40 E9 4F FF FF FF 66 66 66 66 66 66 2E 0F 1F 84 00 00 00 00 00 F3 0F 6F 0F 66 0F 76 C1 66 0F 76 0E 66 0F F8 C8 66 0F D7 D1 81 EA FF FF 00 00 0F 85 20 03 00 00 48 83 C6 10 48 83 C7 10 E9 13 FF FF FF 0F 1F 00 F3 0F 6F 0F 66 0F 76 C1 66 0F 76 0E 66 0F F8 C8 66 0F D7 D1 81 EA FF FF 00 00 0F 85 F0 02 00 00 F3 0F 6F 4F 10 66 0F 76 C1 66 0F 76 4E 10 66 0F F8 C8 66 0F D7 D1 81 EA FF FF 00 00 0F 85 2E 03 00 00 48 83 C6 20 48 83 C7 20 E9 C1 FE FF FF 90 F3 0F 6F 0F 66 0F 76 C1 66 0F 76 0E 66 0F F8 C8 66 0F D7 D1 81 EA FF FF 00 00 0F 85 A0 02 00 00 F3 0F 6F 4F 10 66 0F 76 C1 66 0F 76 4E 10 66 0F F8 C8 66 0F D7 D1 81 EA FF FF 00 00 0F 85 DE 02 00 00 F3 0F 6F 4F 20 66 0F 76 C1 66 0F 76 4E 20 66 0F F8 C8 66 0F D7 D1 81 EA FF FF 00 00 0F 85 1C 03 00 00 48 83 C6 30 48 83 C7 30 E9 4F FE FF FF 66 66 66 66 66 66 2E 0F 1F 84 00 00 00 00 00 F3 0F 6F 0F F3 0F 6F 16 66 0F 76 C1 66 0F 76 CA 66 0F F8 C8 66 0F D7 D1 81 EA FF FF 00 00 0F 85 1C 02 00 00 48 83 C6 10 48 83 C7 10 E9 1F F7 FF FF 66 66 66 66 66 66 2E 0F 1F 84 00 00 00 00 00 F3 0F 6F 0F F3 0F 6F 16 66 0F 76 C1 66 0F 76 CA 66 0F F8 C8 66 0F D7 D1 81 EA FF FF 00 00 0F 85 DC 01 00 00 F3 0F 6F 5F 10 F3 0F 6F 66 10 66 0F 76 C3 66 0F 76 DC 66 0F F8 D8 66 0F D7 D3 81 EA FF FF 00 00 0F 85 16 02 00 00 48 83 C6 20 48 83 C7 20 E9 B9 F6 FF FF 66 0F 1F 84 00 00 00 00 00 F3 0F 6F 0F F3 0F 6F 16 66 0F 76 C1 66 0F 76 CA 66 0F F8 C8 66 0F D7 D1 81 EA FF FF 00 00 0F 85 7C 01 00 00 F3 0F 6F 5F 10 F3 0F 6F 66 10 66 0F 76 C3 66 0F 76 DC 66 0F F8 D8 66 0F D7 D3 81 EA FF FF 00 00 0F 85 B6 01 00 00 F3 0F 6F 4F 20 F3 0F 6F 56 20 66 0F 76 C1 66 0F 76 CA 66 0F F8 C8 66 0F D7 D1 81 EA FF FF 00 00 0F 85 F0 01 00 00 48 83 C6 30 48 83 C7 30 E9 33 F6 FF FF 0F 1F 00 F3 0F 6F 0F F3 0F 6F 16 66 0F 76 C1 66 0F 76 CA 66 0F F8 C8 66 0F D7 D1 81 EA FF FF 00 00 0F 85 FC 00 00 00 F3 0F 6F 4F 10 F3 0F 6F 56 10 66 0F 76 C1 66 0F 76 CA 66 0F F8 C8 66 0F D7 D1 81 EA FF FF 00 00 0F 85 36 01 00 00 48 83 C6 20 48 83 C7 20 E9 F9 F8 FF FF 66 0F 1F 84 00 00 00 00 00 F3 0F 6F 0F F3 0F 6F 16 66 0F 76 C1 66 0F 76 CA 66 0F F8 C8 66 0F D7 D1 81 EA FF FF 00 00 0F 85 9C 00 00 00 48 83 C6 10 48 83 C7 10 E9 EF F9 FF FF 66 66 66 66 66 66 2E 0F 1F 84 00 00 00 00 00 F3 0F 6F 0F F3 0F 6F 16 66 0F 76 C1 66 0F 76 CA 66 0F F8 C8 66 0F D7 D1 81 EA FF FF 00 00 75 60 48 83 C6 10 48 83 C7 10 E9 83 F8 FF FF 0F 1F 00 3B 06 0F 85 A8 01 00 00 85 C0 0F 84 B0 01 00 00 8B 4E 04 39 4F 04 0F 85 94 01 00 00 85 C9 0F 84 9C 01 00 00 8B 4E 08 39 4F 08 0F 85 80 01 00 00 85 C9 0F 84 88 01 00 00 8B 4E 0C 39 4F 0C 0F 85 6C 01 00 00 31 C0 C3 66 0F 1F 84 00 00 00 00 00 31 C0 84 D2 74 2A 80 E2 0F 74 15 8B 07 3B 06 0F 85 4B 01 00 00 C3 66 2E 0F 1F 84 00 00 00 00 00 8B 47 04 3B 46 04 0F 85 34 01 00 00 C3 0F 1F 00 80 E6 0F 74 1B 8B 47 08 3B 46 08 0F 85 1F 01 00 00 C3 66 66 66 66 66 2E 0F 1F 84 00 00 00 00 00 8B 47 0C 3B 46 0C 0F 85 04 01 00 00 C3 0F 1F 00 31 C0 84 D2 74 2A 80 E2 0F 74 15 8B 47 10 3B 46 10 0F 85 E9 00 00 00 C3 0F 1F 84 00 00 00 00 00 8B 47 14 3B 46 14 0F 85 D4 00 00 00 C3 0F 1F 00 80 E6 0F 74 1B 8B 47 18 3B 46 18 0F 85 BF 00 00 00 C3 66 66 66 66 66 2E 0F 1F 84 00 00 00 00 00 8B 47 1C 3B 46 1C 0F 85 A4 00 00 00 C3 0F 1F 00 31 C0 84 D2 74 2A 80 E2 0F 74 15 8B 47 20 3B 46 20 0F 85 89 00 00 00 C3 0F 1F 84 00 00 00 00 00 8B 47 24 3B 46 24 75 78 C3 0F 1F 80 00 00 00 00 80 E6 0F 74 0B 8B 47 28 3B 46 28 75 63 C3 66 90 8B 47 2C 3B 46 2C 75 58 C3 0F 1F 80 00 00 00 00 31 C0 84 D2 74 2A 80 E2 0F 74 15 8B 47 30 3B 46 30 75 3D C3 66 66 66 2E 0F 1F 84 00 00 00 00 00 8B 47 34 3B 46 34 75 28 C3 0F 1F 80 00 00 00 00 80 E6 0F 74 0B 8B 47 38 3B 46 38 75 13 C3 66 90 8B 47 3C 3B 46 3C 75 08 C3 0F 1F 80 00 00 00 00 B8 01 00 00 00 7F 02 F7 D8 C3 66 0F 1F 44 00 00 48 31 C0 C3 }
	condition:
		$1
}

rule file_62_0_0 {
	meta:
		name = "__iswalnum_l"
		size = 130
	strings:
		$1 = { F7 C7 80 FF FF FF 74 68 48 8B 06 8B 90 C8 00 00 00 83 C2 0B 48 8B 54 D0 40 89 F8 8B 0A D3 E8 89 C1 31 C0 3B 4A 04 73 40 83 C1 05 8B 0C 8A 85 C9 74 36 89 CE 8B 4A 08 41 89 F8 41 D3 E8 44 89 C1 23 4A 0C 48 8D 0C 8E 8B 0C 0A 85 C9 74 1A 89 F8 C1 E8 05 23 42 10 48 8D 04 81 89 F9 8B 04 02 D3 E8 83 E0 01 0F 1F 40 00 F3 C3 66 0F 1F 44 00 00 48 8B 46 68 48 63 FF 0F B7 04 78 83 E0 08 0F B7 C0 C3 }
	condition:
		$1
}

rule file_62_1_0 {
	meta:
		name = "__iswalpha_l"
		size = 131
	strings:
		$1 = { F7 C7 80 FF FF FF 74 68 48 8B 06 8B 90 C8 00 00 00 83 C2 02 48 8B 54 D0 40 89 F8 8B 0A D3 E8 89 C1 31 C0 3B 4A 04 73 40 83 C1 05 8B 0C 8A 85 C9 74 36 89 CE 8B 4A 08 41 89 F8 41 D3 E8 44 89 C1 23 4A 0C 48 8D 0C 8E 8B 0C 0A 85 C9 74 1A 89 F8 C1 E8 05 23 42 10 48 8D 04 81 89 F9 8B 04 02 D3 E8 83 E0 01 0F 1F 40 00 F3 C3 66 0F 1F 44 00 00 48 8B 46 68 48 63 FF 0F B7 04 78 66 25 00 04 0F B7 C0 C3 }
	condition:
		$1
}

rule file_62_2_0 {
	meta:
		name = "__iswblank_l"
		size = 127
	strings:
		$1 = { F7 C7 80 FF FF FF 74 68 48 8B 06 8B 90 C8 00 00 00 83 C2 08 48 8B 54 D0 40 89 F8 8B 0A D3 E8 89 C1 31 C0 3B 4A 04 73 40 83 C1 05 8B 0C 8A 85 C9 74 36 89 CE 8B 4A 08 41 89 F8 41 D3 E8 44 89 C1 23 4A 0C 48 8D 0C 8E 8B 0C 0A 85 C9 74 1A 89 F8 C1 E8 05 23 42 10 48 8D 04 81 89 F9 8B 04 02 D3 E8 83 E0 01 0F 1F 40 00 F3 C3 66 0F 1F 44 00 00 48 8B 46 68 48 63 FF 0F B7 04 78 83 E0 01 C3 }
	condition:
		$1
}

rule file_62_3_0 {
	meta:
		name = "__iswcntrl_l"
		size = 130
	strings:
		$1 = { F7 C7 80 FF FF FF 74 68 48 8B 06 8B 90 C8 00 00 00 83 C2 09 48 8B 54 D0 40 89 F8 8B 0A D3 E8 89 C1 31 C0 3B 4A 04 73 40 83 C1 05 8B 0C 8A 85 C9 74 36 89 CE 8B 4A 08 41 89 F8 41 D3 E8 44 89 C1 23 4A 0C 48 8D 0C 8E 8B 0C 0A 85 C9 74 1A 89 F8 C1 E8 05 23 42 10 48 8D 04 81 89 F9 8B 04 02 D3 E8 83 E0 01 0F 1F 40 00 F3 C3 66 0F 1F 44 00 00 48 8B 46 68 48 63 FF 0F B7 04 78 83 E0 02 0F B7 C0 C3 }
	condition:
		$1
}

rule file_62_4_0 {
	meta:
		name = "__iswdigit_l"
		size = 124
	strings:
		$1 = { F7 C7 80 FF FF FF 74 68 48 8B 06 8B 90 C8 00 00 00 83 C2 03 48 8B 54 D0 40 89 F8 8B 0A D3 E8 89 C1 31 C0 3B 4A 04 73 40 83 C1 05 8B 0C 8A 85 C9 74 36 89 CE 8B 4A 08 41 89 F8 41 D3 E8 44 89 C1 23 4A 0C 48 8D 0C 8E 8B 0C 0A 85 C9 74 1A 89 F8 C1 E8 05 23 42 10 48 8D 04 81 89 F9 8B 04 02 D3 E8 83 E0 01 0F 1F 40 00 F3 C3 66 0F 1F 44 00 00 83 EF 30 31 C0 83 FF 09 0F 96 C0 C3 }
	condition:
		$1
}

rule file_62_5_0 {
	meta:
		name = "__iswlower_l"
		size = 131
	strings:
		$1 = { F7 C7 80 FF FF FF 74 68 48 8B 06 8B 90 C8 00 00 00 83 C2 01 48 8B 54 D0 40 89 F8 8B 0A D3 E8 89 C1 31 C0 3B 4A 04 73 40 83 C1 05 8B 0C 8A 85 C9 74 36 89 CE 8B 4A 08 41 89 F8 41 D3 E8 44 89 C1 23 4A 0C 48 8D 0C 8E 8B 0C 0A 85 C9 74 1A 89 F8 C1 E8 05 23 42 10 48 8D 04 81 89 F9 8B 04 02 D3 E8 83 E0 01 0F 1F 40 00 F3 C3 66 0F 1F 44 00 00 48 8B 46 68 48 63 FF 0F B7 04 78 66 25 00 02 0F B7 C0 C3 }
	condition:
		$1
}

rule file_62_6_0 {
	meta:
		name = "__iswgraph_l"
		size = 131
	strings:
		$1 = { F7 C7 80 FF FF FF 74 68 48 8B 06 8B 90 C8 00 00 00 83 C2 07 48 8B 54 D0 40 89 F8 8B 0A D3 E8 89 C1 31 C0 3B 4A 04 73 40 83 C1 05 8B 0C 8A 85 C9 74 36 89 CE 8B 4A 08 41 89 F8 41 D3 E8 44 89 C1 23 4A 0C 48 8D 0C 8E 8B 0C 0A 85 C9 74 1A 89 F8 C1 E8 05 23 42 10 48 8D 04 81 89 F9 8B 04 02 D3 E8 83 E0 01 0F 1F 40 00 F3 C3 66 0F 1F 44 00 00 48 8B 46 68 48 63 FF 0F B7 04 78 66 25 00 80 0F B7 C0 C3 }
	condition:
		$1
}

rule file_62_7_0 {
	meta:
		name = "__iswprint_l"
		size = 131
	strings:
		$1 = { F7 C7 80 FF FF FF 74 68 48 8B 06 8B 90 C8 00 00 00 83 C2 06 48 8B 54 D0 40 89 F8 8B 0A D3 E8 89 C1 31 C0 3B 4A 04 73 40 83 C1 05 8B 0C 8A 85 C9 74 36 89 CE 8B 4A 08 41 89 F8 41 D3 E8 44 89 C1 23 4A 0C 48 8D 0C 8E 8B 0C 0A 85 C9 74 1A 89 F8 C1 E8 05 23 42 10 48 8D 04 81 89 F9 8B 04 02 D3 E8 83 E0 01 0F 1F 40 00 F3 C3 66 0F 1F 44 00 00 48 8B 46 68 48 63 FF 0F B7 04 78 66 25 00 40 0F B7 C0 C3 }
	condition:
		$1
}

rule file_62_8_0 {
	meta:
		name = "__iswpunct_l"
		size = 130
	strings:
		$1 = { F7 C7 80 FF FF FF 74 68 48 8B 06 8B 90 C8 00 00 00 83 C2 0A 48 8B 54 D0 40 89 F8 8B 0A D3 E8 89 C1 31 C0 3B 4A 04 73 40 83 C1 05 8B 0C 8A 85 C9 74 36 89 CE 8B 4A 08 41 89 F8 41 D3 E8 44 89 C1 23 4A 0C 48 8D 0C 8E 8B 0C 0A 85 C9 74 1A 89 F8 C1 E8 05 23 42 10 48 8D 04 81 89 F9 8B 04 02 D3 E8 83 E0 01 0F 1F 40 00 F3 C3 66 0F 1F 44 00 00 48 8B 46 68 48 63 FF 0F B7 04 78 83 E0 04 0F B7 C0 C3 }
	condition:
		$1
}

rule file_62_9_0 {
	meta:
		name = "__iswspace_l"
		size = 131
	strings:
		$1 = { F7 C7 80 FF FF FF 74 68 48 8B 06 8B 90 C8 00 00 00 83 C2 05 48 8B 54 D0 40 89 F8 8B 0A D3 E8 89 C1 31 C0 3B 4A 04 73 40 83 C1 05 8B 0C 8A 85 C9 74 36 89 CE 8B 4A 08 41 89 F8 41 D3 E8 44 89 C1 23 4A 0C 48 8D 0C 8E 8B 0C 0A 85 C9 74 1A 89 F8 C1 E8 05 23 42 10 48 8D 04 81 89 F9 8B 04 02 D3 E8 83 E0 01 0F 1F 40 00 F3 C3 66 0F 1F 44 00 00 48 8B 46 68 48 63 FF 0F B7 04 78 66 25 00 20 0F B7 C0 C3 }
	condition:
		$1
}

rule file_62_10_0 {
	meta:
		name = "__iswupper_l"
		size = 131
	strings:
		$1 = { F7 C7 80 FF FF FF 74 68 48 8B 06 8B 90 C8 00 00 00 48 8B 54 D0 40 89 F8 8B 0A D3 E8 89 C1 31 C0 3B 4A 04 73 43 83 C1 05 8B 0C 8A 85 C9 74 39 89 CE 8B 4A 08 41 89 F8 41 D3 E8 44 89 C1 23 4A 0C 48 8D 0C 8E 8B 0C 0A 85 C9 74 1D 89 F8 C1 E8 05 23 42 10 48 8D 04 81 89 F9 8B 04 02 D3 E8 83 E0 01 0F 1F 80 00 00 00 00 F3 C3 66 0F 1F 44 00 00 48 8B 46 68 48 63 FF 0F B7 04 78 66 25 00 01 0F B7 C0 C3 }
	condition:
		$1
}

rule file_62_11_0 {
	meta:
		name = "__iswxdigit_l"
		size = 131
	strings:
		$1 = { F7 C7 80 FF FF FF 74 68 48 8B 06 8B 90 C8 00 00 00 83 C2 04 48 8B 54 D0 40 89 F8 8B 0A D3 E8 89 C1 31 C0 3B 4A 04 73 40 83 C1 05 8B 0C 8A 85 C9 74 36 89 CE 8B 4A 08 41 89 F8 41 D3 E8 44 89 C1 23 4A 0C 48 8D 0C 8E 8B 0C 0A 85 C9 74 1A 89 F8 C1 E8 05 23 42 10 48 8D 04 81 89 F9 8B 04 02 D3 E8 83 E0 01 0F 1F 40 00 F3 C3 66 0F 1F 44 00 00 48 8B 46 68 48 63 FF 0F B7 04 78 66 25 00 10 0F B7 C0 C3 }
	condition:
		$1
}

rule file_62_12_0 {
	meta:
		name = "__towlower_l"
		size = 79
	strings:
		$1 = { 48 8B 16 89 FE 89 F8 8B 8A D0 00 00 00 83 C1 01 48 8B 54 CA 40 8B 0A D3 EE 3B 72 04 89 F1 73 2D 83 C1 05 8B 0C 8A 85 C9 74 23 89 CE 8B 4A 08 D3 EF 89 F9 23 4A 0C 48 8D 0C 8E 8B 0C 0A 85 C9 74 0C 89 C6 23 72 10 48 8D 0C B1 03 04 0A F3 C3 }
	condition:
		$1
}

rule file_62_13_0 {
	meta:
		name = "__towupper_l"
		size = 76
	strings:
		$1 = { 48 8B 16 89 FE 89 F8 8B 8A D0 00 00 00 48 8B 54 CA 40 8B 0A D3 EE 3B 72 04 89 F1 73 2D 83 C1 05 8B 0C 8A 85 C9 74 23 89 CE 8B 4A 08 D3 EF 89 F9 23 4A 0C 48 8D 0C 8E 8B 0C 0A 85 C9 74 0C 89 C6 23 72 10 48 8D 0C B1 03 04 0A F3 C3 }
	condition:
		$1
}

rule file_63_0_0 {
	meta:
		name = "__strnlen"
		size = 109
	strings:
		$1 = { 48 89 F0 48 85 F6 74 53 66 0F EF D2 48 89 F9 49 89 F8 49 C7 C1 10 00 00 00 48 83 E7 F0 66 0F 6F CA 66 0F 74 17 41 83 CA FF 48 29 F9 41 D3 E2 49 29 C9 66 0F D7 D2 44 21 D2 75 21 4C 29 CE 76 1B 66 0F 6F 47 10 48 8D 7F 10 66 0F 74 C1 66 0F D7 D0 85 D2 75 07 48 83 EE 10 77 E5 C3 4C 29 C7 0F BC D2 48 01 FA 48 39 D0 48 0F 43 C2 C3 }
	condition:
		$1
}

rule file_64_0_0 {
	meta:
		name = "__posix_spawnp"
		size = 21
		refs = "000c __spawni"
	strings:
		$1 = { 48 83 EC 18 C7 04 24 01 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_65_0_0 {
	meta:
		name = "wait_on_socket"
		size = 258
		refs = "002b __poll 0053 __libc_errno 0067 __gettimeofday"
	strings:
		$1 = { 48 89 5C 24 E8 48 89 6C 24 F0 89 F2 4C 89 64 24 F8 48 83 EC 38 48 89 F3 89 3C 24 BE 01 00 00 00 48 89 E7 66 C7 44 24 04 19 00 E8 ?? ?? ?? ?? 83 F8 FF 74 1C 48 8B 5C 24 20 48 8B 6C 24 28 4C 8B 64 24 30 48 83 C4 38 C3 0F 1F 84 00 00 00 00 00 4C 8B 25 ?? ?? ?? ?? 64 41 83 3C 24 04 75 D5 48 8D 7C 24 10 31 F6 E8 ?? ?? ?? ?? 48 8B 44 24 18 B9 E8 03 00 00 48 69 74 24 10 E8 03 00 00 48 05 F4 01 00 00 48 89 C2 48 C1 FA 3F 48 F7 F9 48 89 DA 48 01 DE 48 BB CF F7 53 E3 A5 9B C4 20 48 8D 2C 06 EB 47 64 41 83 3C 24 04 75 88 48 8D 7C 24 10 31 F6 E8 ?? ?? ?? ?? 48 8B 4C 24 18 48 81 C1 F4 01 00 00 48 89 C8 48 F7 EB 48 89 C8 48 C1 F8 3F 48 C1 FA 07 48 29 D0 48 8B 54 24 10 48 69 D2 18 FC FF FF 48 01 D0 48 8D 14 28 BE 01 00 00 00 48 89 E7 E8 ?? ?? ?? ?? 83 F8 FF 74 A7 E9 32 FF FF FF }
	condition:
		$1
}

rule file_65_1_0 {
	meta:
		name = "open_socket"
		size = 765
		refs = "0028 __have_sock_cloexec 0049 __socket 00f3 __connect 0137 memcpy 014d __send 01c3 __libc_errno 0218 __gettimeofday 0266 __poll 02af __fcntl"
	strings:
		$1 = { 55 48 89 E5 4C 89 75 F0 4C 89 7D F8 49 89 D6 48 89 5D D8 4C 89 65 E0 41 89 FF 4C 89 6D E8 48 81 EC E0 00 00 00 44 8B 05 ?? ?? ?? ?? 48 89 B5 20 FF FF FF 45 85 C0 0F 88 64 01 00 00 31 D2 BE 01 08 08 00 BF 01 00 00 00 E8 ?? ?? ?? ?? 89 C3 8B 05 ?? ?? ?? ?? 85 C0 0F 84 23 01 00 00 85 C0 0F 88 3B 01 00 00 85 DB 0F 88 53 02 00 00 49 8D 46 0F 8B 3D ?? ?? ?? ?? 48 83 E0 FC 48 83 C0 12 48 83 E0 F0 48 29 C4 49 8D 46 0C 49 89 E5 49 C1 ED 02 85 FF 48 89 85 28 FF FF FF 4E 8D 24 AD 00 00 00 00 0F 88 F8 01 00 00 48 BE 2F 6E 73 63 64 2F 73 6F 48 B9 2F 76 61 72 2F 72 75 6E BA 6E 00 00 00 48 89 B5 6A FF FF FF 48 8D B5 60 FF FF FF 89 DF 66 C7 85 60 FF FF FF 01 00 48 89 8D 62 FF FF FF C7 85 72 FF FF FF 63 6B 65 74 C6 85 76 FF FF FF 00 E8 ?? ?? ?? ?? 85 C0 0F 88 C1 00 00 00 48 8B B5 20 FF FF FF 49 8D 7C 24 0C 46 89 3C AD 04 00 00 00 46 89 34 AD 08 00 00 00 4C 89 F2 42 C7 04 AD 00 00 00 00 02 00 00 00 41 BF 01 00 00 00 41 BE E8 03 00 00 E8 ?? ?? ?? ?? 48 8B 95 28 FF FF FF B9 00 40 00 00 4C 89 E6 89 DF E8 ?? ?? ?? ?? 48 83 F8 FF 0F 84 8D 00 00 00 48 3B 85 28 FF FF FF 75 6D 0F 1F 40 00 89 D8 4C 8B 65 E0 48 8B 5D D8 4C 8B 6D E8 4C 8B 75 F0 4C 8B 7D F8 C9 C3 83 FB FF 0F 84 F7 00 00 00 B8 01 00 00 00 89 05 ?? ?? ?? ?? E9 C4 FE FF FF 0F 1F 80 00 00 00 00 31 D2 BE 01 00 00 00 BF 01 00 00 00 E8 ?? ?? ?? ?? 89 C3 E9 AD FE FF FF 0F 1F 84 00 00 00 00 00 48 8B 05 ?? ?? ?? ?? 64 83 38 73 0F 84 2E FF FF FF 48 63 FB B8 03 00 00 00 0F 05 BB FF FF FF FF E9 83 FF FF FF 0F 1F 00 48 8B 05 ?? ?? ?? ?? 64 8B 00 83 F8 04 0F 84 40 FF FF FF 48 83 BD 28 FF FF FF FF 0F 84 5F FF FF FF 83 F8 0B 75 C3 48 8D BD 50 FF FF FF 31 F6 E8 ?? ?? ?? ?? 45 84 FF 0F 84 A5 00 00 00 48 8B 85 58 FF FF FF BA 88 13 00 00 48 89 85 48 FF FF FF 48 8B 85 50 FF FF FF 48 83 C0 05 48 89 85 40 FF FF FF 48 8D BD 30 FF FF FF BE 01 00 00 00 89 9D 30 FF FF FF 66 C7 85 34 FF FF FF 1C 00 E8 ?? ?? ?? ?? 85 C0 0F 8E 5F FF FF FF 45 31 FF E9 C1 FE FF FF 66 0F 1F 44 00 00 48 8B 05 ?? ?? ?? ?? 64 83 38 16 0F 85 F8 FE FF FF 89 D8 E9 F6 FE FF FF 0F 1F 84 00 00 00 00 00 BA 02 08 00 00 BE 04 00 00 00 89 DF 31 C0 E8 ?? ?? ?? ?? E9 F0 FD FF FF 0F 1F 84 00 00 00 00 00 BB FF FF FF FF E9 9E FE FF FF 48 8B 85 48 FF FF FF 48 2B 85 58 FF FF FF 48 89 C2 48 C1 FA 3F 49 F7 FE 48 8B 95 40 FF FF FF 48 2B 95 50 FF FF FF 69 D2 E8 03 00 00 01 C2 E9 4D FF FF FF }
	condition:
		$1
}

rule file_65_2_0 {
	meta:
		name = "__readall"
		size = 189
		refs = "0033 __read 007b __libc_errno"
	strings:
		$1 = { 48 89 6C 24 E0 4C 89 64 24 E8 48 89 D5 4C 89 6C 24 F0 4C 89 74 24 F8 41 89 FD 48 89 5C 24 D8 49 89 F4 48 83 EC 28 49 89 D6 48 89 EA 4C 89 E6 44 89 EF E8 ?? ?? ?? ?? 48 83 F8 FF 48 89 C3 74 38 48 83 F8 00 7E 52 49 01 C4 48 29 C5 75 DB 4C 89 F0 48 29 E8 48 8B 1C 24 48 8B 6C 24 08 4C 8B 64 24 10 4C 8B 6C 24 18 4C 8B 74 24 20 48 83 C4 28 C3 0F 1F 80 00 00 00 00 48 8B 05 ?? ?? ?? ?? 64 8B 00 83 F8 04 74 A2 83 F8 0B 74 1A 48 89 D8 EB C3 0F 1F 80 00 00 00 00 74 B4 48 8B 05 ?? ?? ?? ?? 64 8B 00 EB E1 BE C8 00 00 00 44 89 EF E8 3D FB FF FF 85 C0 0F 8F 6E FF FF FF EB CF }
	condition:
		$1
}

rule file_65_3_0 {
	meta:
		name = "__readvall"
		size = 387
		refs = "002a __readv 0037 __libc_errno 00bc memcpy"
	strings:
		$1 = { 55 48 89 E5 41 57 41 56 41 89 FE 41 55 49 89 F5 41 54 41 89 D4 53 48 83 EC 18 66 0F 1F 44 00 00 44 89 E2 4C 89 EE 44 89 F7 E8 ?? ?? ?? ?? 48 83 F8 FF 75 1C 48 8B 15 ?? ?? ?? ?? 64 8B 12 83 FA 04 74 DD 83 FA 0B 49 89 C7 75 3F 45 31 FF EB 0D 48 83 F8 00 0F 8E E3 00 00 00 49 89 C7 45 85 E4 7E 28 41 8D 44 24 FF 4C 89 E9 31 DB 48 C1 E0 04 49 8D 54 05 10 0F 1F 00 48 03 59 08 48 83 C1 10 48 39 D1 75 F3 49 39 DF 72 16 48 8D 65 D8 4C 89 F8 5B 41 5C 41 5D 41 5E 41 5F 5D C3 0F 1F 40 00 49 63 D4 48 89 65 C8 4C 89 EE 48 C1 E2 04 48 8D 42 10 48 29 C4 48 89 E7 49 89 E5 E8 ?? ?? ?? ?? 4C 89 F8 49 8B 55 08 48 39 C2 76 34 49 01 45 00 48 29 C2 49 89 55 08 44 89 E2 4C 89 EE 44 89 F7 E8 ?? ?? ?? ?? 48 83 F8 FF 48 89 C2 74 1F 48 83 F8 00 7F 3C 75 62 48 8B 65 C8 EB 8E 0F 1F 40 00 48 29 D0 41 83 EC 01 49 83 C5 10 EB B6 48 8B 05 ?? ?? ?? ?? 64 8B 00 83 F8 04 74 BB 83 F8 0B 74 43 49 89 D7 EB D0 66 2E 0F 1F 84 00 00 00 00 00 49 01 C7 49 39 DF 73 BE 48 89 D0 EB 86 41 BF 00 00 00 00 0F 84 41 FF FF FF 48 8B 15 ?? ?? ?? ?? 64 8B 12 E9 EB FE FF FF 48 8B 05 ?? ?? ?? ?? 64 8B 00 EB B8 BE C8 00 00 00 44 89 F7 48 89 55 C0 E8 BB F9 FF FF 85 C0 48 8B 55 C0 0F 8F 56 FF FF FF EB 9E }
	condition:
		$1
}

rule file_65_4_0 {
	meta:
		name = "__nscd_unmap"
		size = 59
		refs = "0015 __munmap 0037 __assert_fail 001e free"
	strings:
		$1 = { 53 44 8B 4F 18 45 85 C9 75 18 48 89 FB 48 8B 77 10 48 8B 3F E8 ?? ?? ?? ?? 48 89 DF 5B E9 ?? ?? ?? ?? B9 ?? ?? ?? ?? BA 0F 01 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_65_5_0 {
	meta:
		name = "__nscd_get_mapping"
		size = 982
		refs = "002b strlen 0032 __libc_errno 014f __recvmsg 01a5 strcmp 01c4 __fxstat64 0201 __close 0250 __nscd_unmap 027b __munmap 02e8 __mmap 0360 malloc 03aa time"
	strings:
		$1 = { 55 48 89 E5 48 89 5D D8 4C 89 65 E0 89 FB 4C 89 6D E8 4C 89 75 F0 48 89 F7 4C 89 7D F8 48 81 EC 80 01 00 00 49 89 F5 49 89 D7 E8 ?? ?? ?? ?? 4C 8B 25 ?? ?? ?? ?? 49 89 C6 48 83 C0 01 48 89 85 A0 FE FF FF 49 8D 46 10 4C 89 EE 89 DF 64 41 8B 14 24 48 83 E0 F0 48 29 C4 89 95 9C FE FF FF 48 8B 95 A0 FE FF FF E8 05 FA FF FF 85 C0 48 C7 C2 FF FF FF FF 0F 88 92 01 00 00 89 C3 48 8B 85 A0 FE FF FF B9 07 00 00 00 BE 88 13 00 00 48 89 A5 90 FE FF FF 48 89 A5 E0 FE FF FF 48 C7 85 F8 FE FF FF 08 00 00 00 C7 85 C8 FE FF FF 01 00 00 00 48 89 85 E8 FE FF FF 48 8D 85 B8 FE FF FF C7 85 CC FE FF FF 01 00 00 00 48 C7 85 C0 FE FF FF 14 00 00 00 89 95 D0 FE FF FF 48 89 85 F0 FE FF FF 48 8D 85 00 FF FF FF 48 89 85 A8 FE FF FF 48 8B BD A8 FE FF FF 31 C0 F3 48 AB 48 8D 85 E0 FE FF FF 89 DF 48 C7 85 18 FF FF FF 02 00 00 00 48 C7 85 28 FF FF FF 14 00 00 00 48 89 85 10 FF FF FF 48 8D 85 C0 FE FF FF 48 89 85 20 FF FF FF E8 2D F8 FF FF 85 C0 0F 8E B5 00 00 00 0F 1F 44 00 00 48 8D B5 00 FF FF FF BA 00 00 00 40 89 DF E8 ?? ?? ?? ?? 48 83 F8 FF 75 08 64 41 83 3C 24 04 74 DF 48 83 BD 28 FF FF FF 0F 0F 86 81 00 00 00 48 8B 95 20 FF FF FF 48 85 D2 74 75 48 83 3A 14 75 6F 48 39 85 A0 FE FF FF 8B 95 D0 FE FF FF 89 95 98 FE FF FF 0F 85 14 01 00 00 48 8B BD 90 FE FF FF 4C 89 EE E8 ?? ?? ?? ?? 85 C0 0F 85 CE 00 00 00 8B B5 98 FE FF FF 48 8D 95 40 FF FF FF BF 01 00 00 00 E8 ?? ?? ?? ?? 85 C0 0F 85 AF 00 00 00 48 8B 85 70 FF FF FF 48 83 F8 77 0F 86 9E 00 00 00 48 89 85 B8 FE FF FF E9 DD 00 00 00 0F 1F 00 48 C7 C2 FF FF FF FF 89 DF 48 89 95 80 FE FF FF E8 ?? ?? ?? ?? 48 8B 95 80 FE FF FF 49 8B 3F 8B 85 9C FE FF FF 48 85 FF 64 41 89 04 24 49 89 17 74 07 F0 83 6F 18 01 74 1F 48 89 D0 48 8B 5D D8 4C 8B 65 E0 4C 8B 6D E8 4C 8B 75 F0 4C 8B 7D F8 C9 C3 66 0F 1F 44 00 00 48 89 95 80 FE FF FF E8 ?? ?? ?? ?? 48 8B 95 80 FE FF FF EB CC 48 8B 85 B8 FE FF FF 48 89 85 A0 FE FF FF 0F 1F 44 00 00 48 8B B5 A0 FE FF FF 4C 89 F7 E8 ?? ?? ?? ?? 48 C7 C2 FF FF FF FF 66 2E 0F 1F 84 00 00 00 00 00 8B BD 98 FE FF FF 48 89 95 80 FE FF FF E8 ?? ?? ?? ?? 48 8B 95 80 FE FF FF E9 49 FF FF FF 49 83 C6 09 4C 39 F0 75 C8 48 8B BD 90 FE FF FF 4C 89 EE E8 ?? ?? ?? ?? 85 C0 75 B5 44 8B 85 98 FE FF FF 48 8B B5 B8 FE FF FF 45 31 C9 31 FF B9 01 00 00 00 BA 01 00 00 00 E8 ?? ?? ?? ?? 48 83 F8 FF 49 89 C6 74 8A 83 38 02 0F 85 5F FF FF FF 83 78 04 78 0F 85 BB 00 00 00 48 63 40 28 85 C0 0F 84 49 FF FF FF 41 8B 56 0C 85 D2 0F 84 83 00 00 00 4D 63 6E 2C 48 8D 14 85 0F 00 00 00 48 8B 85 B8 FE FF FF 48 83 E2 F0 48 89 85 A0 FE FF FF 49 8D 74 15 78 48 39 C6 0F 87 24 FF FF FF BF 28 00 00 00 48 89 95 80 FE FF FF 48 89 B5 88 FE FF FF E8 ?? ?? ?? ?? 48 85 C0 48 8B 95 80 FE FF FF 48 8B B5 88 FE FF FF 0F 84 F5 FE FF FF 49 63 7E 04 4C 89 30 48 89 70 10 4C 89 68 20 C7 40 18 01 00 00 00 48 01 FA 49 01 D6 48 89 C2 4C 89 70 08 E9 ED FE FF FF 4D 8B 6E 10 31 FF E8 ?? ?? ?? ?? 49 81 C5 2C 01 00 00 49 39 C5 72 09 49 63 46 28 E9 5D FF FF FF 48 8B 95 B8 FE FF FF 48 89 95 A0 FE FF FF E9 9A FE FF FF }
	condition:
		$1
}

rule file_65_6_0 {
	meta:
		name = "__nscd_get_map_ref"
		size = 294
		refs = "00c0 __nscd_get_mapping 00f4 time"
	strings:
		$1 = { 48 89 6C 24 E0 4C 89 64 24 E8 48 89 D5 4C 89 6C 24 F0 48 89 5C 24 D8 45 31 C9 4C 89 74 24 F8 48 83 EC 38 48 8B 52 08 49 89 CC 41 89 FD B9 06 00 00 00 41 B8 01 00 00 00 48 83 FA FF 0F 84 96 00 00 00 44 89 C8 F0 44 0F B1 45 00 85 C0 0F 85 C7 00 00 00 48 8B 5D 08 48 83 FB FF 0F 84 B0 00 00 00 48 85 DB 74 52 48 8B 03 8B 50 0C 85 D2 74 78 48 63 50 2C 48 3B 53 20 77 3E 8B 40 08 A8 01 41 89 04 24 0F 85 88 00 00 00 F0 FF 43 18 C7 45 00 00 00 00 00 48 89 D8 48 8B 6C 24 18 48 8B 5C 24 10 4C 8B 64 24 20 4C 8B 6C 24 28 4C 8B 74 24 30 48 83 C4 38 C3 0F 1F 00 48 8D 55 08 44 89 EF E8 ?? ?? ?? ?? 48 83 F8 FF 48 89 C3 74 44 48 8B 00 EB A8 66 0F 1F 44 00 00 48 C7 C3 FF FF FF FF EB B3 0F 1F 80 00 00 00 00 4C 8B 70 10 31 FF 48 89 74 24 08 E8 ?? ?? ?? ?? 48 8B 74 24 08 49 81 C6 2C 01 00 00 49 39 C6 72 AF 48 8B 03 E9 5F FF FF FF 48 83 CB FF E9 73 FF FF FF 83 E9 01 74 B9 F3 90 E9 1C FF FF FF }
	condition:
		$1
}

rule file_65_7_0 {
	meta:
		name = "__nscd_cache_search"
		size = 401
		refs = "0028 __nis_hash 0121 memcmp"
	strings:
		$1 = { 41 57 41 89 FF 41 56 4D 89 C6 41 55 49 89 D5 41 54 55 48 89 CD 53 48 83 EC 38 48 89 74 24 20 48 8B 7C 24 20 48 89 D6 E8 ?? ?? ?? ?? 48 8B 75 00 31 D2 4C 8B 45 20 F7 76 28 4C 89 C0 89 D2 8B 5C 96 78 48 BA CD CC CC CC CC CC CC CC 48 F7 E2 48 C1 EA 05 83 FB FF 0F 84 24 01 00 00 89 D8 48 8D 48 1C 49 39 C8 0F 82 15 01 00 00 49 83 C6 18 4C 8B 55 08 4C 8D 62 FF 4C 89 74 24 28 31 ED 41 BE 01 00 00 00 EB 5C 66 2E 0F 1F 84 00 00 00 00 00 8B 49 10 39 CB 0F 84 E5 00 00 00 49 83 FC FF 0F 84 DB 00 00 00 85 ED 74 16 89 DB 49 8D 04 1A 48 83 C3 1C 49 39 D8 0F 82 C4 00 00 00 8B 58 10 44 89 F0 29 E8 83 F9 FF 89 C5 0F 84 B1 00 00 00 89 C8 49 83 EC 01 48 8D 50 1C 49 39 D0 0F 82 9E 00 00 00 49 8D 0C 02 0F B6 01 44 39 F8 75 A2 48 63 41 04 4C 39 E8 75 99 8B 41 08 89 C0 4A 8D 14 28 49 39 D0 72 8B 48 8B 7C 24 20 49 8D 34 02 4C 89 EA 48 89 4C 24 10 4C 89 44 24 18 4C 89 54 24 08 E8 ?? ?? ?? ?? 85 C0 48 8B 4C 24 10 4C 8B 44 24 18 4C 8B 54 24 08 0F 85 54 FF FF FF 8B 51 14 89 D6 48 8D 46 18 49 39 C0 0F 82 42 FF FF FF 49 8D 04 32 80 78 12 00 0F 84 34 FF FF FF 03 10 49 39 D0 0F 82 29 FF FF FF 48 03 74 24 28 49 39 F0 0F 82 1B FF FF FF EB 0B 66 0F 1F 84 00 00 00 00 00 31 C0 48 83 C4 38 5B 5D 41 5C 41 5D 41 5E 41 5F C3 }
	condition:
		$1
}

rule file_65_8_0 {
	meta:
		name = "__nscd_open_socket"
		size = 198
		refs = "002e __libc_errno 0071 __read"
	strings:
		$1 = { 48 89 5C 24 D8 48 89 6C 24 E0 BB FF FF FF FF 4C 89 64 24 E8 4C 89 6C 24 F0 4C 89 74 24 F8 48 83 EC 28 48 81 FE 00 04 00 00 77 5D 4C 8B 25 ?? ?? ?? ?? 48 89 F8 89 D7 48 89 F2 48 89 C6 49 89 CD 4C 89 C5 64 45 8B 34 24 E8 73 F3 FF FF 85 C0 89 C3 78 67 BE 88 13 00 00 89 C7 E8 51 F2 FF FF 85 C0 7E 4D 0F 1F 44 00 00 48 89 EA 4C 89 EE 89 DF E8 ?? ?? ?? ?? 48 83 F8 FF 75 08 64 41 83 3C 24 04 74 E5 48 39 E8 75 28 89 D8 48 8B 6C 24 08 48 8B 1C 24 4C 8B 64 24 10 4C 8B 6C 24 18 4C 8B 74 24 20 48 83 C4 28 C3 66 0F 1F 84 00 00 00 00 00 48 63 FB B8 03 00 00 00 0F 05 64 45 89 34 24 BB FF FF FF FF EB C2 }
	condition:
		$1
}

rule file_67_0_0 {
	meta:
		name = "convert_and_print"
		size = 256
		refs = "0028 strlen 005f realloc 0086 __mbsrtowcs 00c0 stderr 00cc __vfwprintf 00ed fputws_unlocked"
	strings:
		$1 = { 55 48 89 E5 41 57 41 56 41 55 41 54 53 48 83 EC 28 48 85 FF 48 89 75 B0 0F 84 B2 00 00 00 49 89 FC 45 31 FF 45 31 F6 E8 ?? ?? ?? ?? 48 8D 58 01 4C 8D 2C 9D 00 00 00 00 49 8D 45 1E 48 89 45 B8 EB 4D 66 0F 1F 44 00 00 4D 85 FF 74 0B 48 81 FB 9F 0F 00 00 4D 0F 46 FE 4C 89 FF 4C 89 EE E8 ?? ?? ?? ?? 48 85 C0 49 89 C7 74 75 48 8D 4D C0 48 8D 75 C8 48 89 DA 4C 89 FF 48 C7 45 C0 00 00 00 00 4C 89 65 C8 E8 ?? ?? ?? ?? 48 39 C3 75 21 48 81 FB CF 07 00 00 77 B0 48 8B 45 B8 48 83 E0 F0 48 29 C4 4C 8D 7C 24 0F 49 83 E7 F0 EB BD 66 90 48 83 F8 FF 48 8B 55 B0 B8 ?? ?? ?? ?? 48 8B 3D ?? ?? ?? ?? 4C 0F 44 F8 4C 89 FE E8 ?? ?? ?? ?? 48 8D 65 D8 5B 41 5C 41 5D 41 5E 41 5F 5D C3 90 48 8B 35 ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 65 D8 5B 41 5C 41 5D 41 5E 41 5F 5D C3 }
	condition:
		$1
}

rule file_67_1_0 {
	meta:
		name = "vwarnx"
		size = 206
		refs = "0014 stderr 001e __progname 0034 __fwprintf 0070 fprintf 0087 vfprintf 005e putwc_unlocked 00ca __overflow"
	strings:
		$1 = { 48 89 5C 24 F0 48 89 6C 24 F8 48 89 FB 48 83 EC 18 48 8B 3D ?? ?? ?? ?? 48 89 F5 48 8B 15 ?? ?? ?? ?? 8B 87 C0 00 00 00 85 C0 7E 3C BE ?? ?? ?? ?? 31 C0 E8 ?? ?? ?? ?? 48 89 EE 48 89 DF E8 BD FE FF FF 48 8B 35 ?? ?? ?? ?? 48 8B 5C 24 08 BF 0A 00 00 00 48 8B 6C 24 10 48 83 C4 18 E9 ?? ?? ?? ?? 66 0F 1F 44 00 00 31 C0 BE ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 85 DB 74 12 48 8B 3D ?? ?? ?? ?? 48 89 EA 48 89 DE E8 ?? ?? ?? ?? 48 8B 3D ?? ?? ?? ?? 48 8B 47 28 48 3B 47 30 73 1A C6 00 0A 48 83 C0 01 48 8B 5C 24 08 48 89 47 28 48 8B 6C 24 10 48 83 C4 18 C3 48 8B 5C 24 08 48 8B 6C 24 10 BE 0A 00 00 00 48 83 C4 18 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_67_2_0 {
	meta:
		name = "vwarn"
		size = 269
		refs = "001e stderr 0025 __libc_errno 002f __progname 0049 __fwprintf 006a fputws_unlocked 00a8 fprintf 00bf vfprintf 00da fwrite_unlocked"
	strings:
		$1 = { 48 89 5C 24 E0 48 89 6C 24 E8 48 89 FD 4C 89 64 24 F0 4C 89 6C 24 F8 48 83 EC 28 48 8B 3D ?? ?? ?? ?? 48 8B 1D ?? ?? ?? ?? 49 89 F5 48 8B 15 ?? ?? ?? ?? 8B 8F C0 00 00 00 64 44 8B 23 85 C9 7E 5F 31 C0 BE ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 85 ED 74 1C 4C 89 EE 48 89 EF E8 D3 FD FF FF 48 8B 35 ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 64 44 89 23 48 8B 3D ?? ?? ?? ?? BE ?? ?? ?? ?? 48 8B 5C 24 08 48 8B 6C 24 10 31 C0 4C 8B 64 24 18 4C 8B 6C 24 20 48 83 C4 28 E9 ?? ?? ?? ?? 0F 1F 00 31 C0 BE ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 85 ED 74 2D 48 8B 3D ?? ?? ?? ?? 4C 89 EA 48 89 EE E8 ?? ?? ?? ?? 48 8B 0D ?? ?? ?? ?? BA 02 00 00 00 BE 01 00 00 00 BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 64 44 89 23 48 8B 3D ?? ?? ?? ?? BE ?? ?? ?? ?? 48 8B 5C 24 08 48 8B 6C 24 10 31 C0 4C 8B 64 24 18 4C 8B 6C 24 20 48 83 C4 28 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_67_3_0 {
	meta:
		name = "warn"
		size = 148
		refs = "0088 vwarn"
		altNames = "warnx"
	strings:
		$1 = { 48 81 EC D8 00 00 00 84 C0 48 89 74 24 28 48 89 54 24 30 48 89 4C 24 38 4C 89 44 24 40 4C 89 4C 24 48 74 37 0F 29 44 24 50 0F 29 4C 24 60 0F 29 54 24 70 0F 29 9C 24 80 00 00 00 0F 29 A4 24 90 00 00 00 0F 29 AC 24 A0 00 00 00 0F 29 B4 24 B0 00 00 00 0F 29 BC 24 C0 00 00 00 48 8D 84 24 E0 00 00 00 48 8D 74 24 08 48 89 44 24 10 48 8D 44 24 20 C7 44 24 08 08 00 00 00 C7 44 24 0C 30 00 00 00 48 89 44 24 18 E8 ?? ?? ?? ?? 48 81 C4 D8 00 00 00 C3 }
	condition:
		$1
}

rule file_67_5_0 {
	meta:
		name = "verr"
		size = 21
		refs = "000a vwarn 0011 exit"
	strings:
		$1 = { 53 89 FB 48 89 F7 48 89 D6 E8 ?? ?? ?? ?? 89 DF E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_67_6_0 {
	meta:
		name = "verrx"
		size = 21
		refs = "000a vwarnx 0011 exit"
	strings:
		$1 = { 53 89 FB 48 89 F7 48 89 D6 E8 ?? ?? ?? ?? 89 DF E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_67_7_0 {
	meta:
		name = "err"
		size = 135
		refs = "0083 verr"
		altNames = "errx"
	strings:
		$1 = { 48 81 EC D8 00 00 00 84 C0 48 89 54 24 30 48 89 4C 24 38 4C 89 44 24 40 4C 89 4C 24 48 74 37 0F 29 44 24 50 0F 29 4C 24 60 0F 29 54 24 70 0F 29 9C 24 80 00 00 00 0F 29 A4 24 90 00 00 00 0F 29 AC 24 A0 00 00 00 0F 29 B4 24 B0 00 00 00 0F 29 BC 24 C0 00 00 00 48 8D 84 24 E0 00 00 00 48 8D 54 24 08 48 89 44 24 10 48 8D 44 24 20 C7 44 24 08 10 00 00 00 C7 44 24 0C 30 00 00 00 48 89 44 24 18 E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_201_3_0 {
	meta:
		name = "_IO_obstack_printf"
		size = 143
		refs = "0083 _IO_obstack_vprintf"
	strings:
		$1 = { 48 81 EC D8 00 00 00 84 C0 48 89 54 24 30 48 89 4C 24 38 4C 89 44 24 40 4C 89 4C 24 48 74 37 0F 29 44 24 50 0F 29 4C 24 60 0F 29 54 24 70 0F 29 9C 24 80 00 00 00 0F 29 A4 24 90 00 00 00 0F 29 AC 24 A0 00 00 00 0F 29 B4 24 B0 00 00 00 0F 29 BC 24 C0 00 00 00 48 8D 84 24 E0 00 00 00 48 8D 54 24 08 48 89 44 24 10 48 8D 44 24 20 C7 44 24 08 10 00 00 00 C7 44 24 0C 30 00 00 00 48 89 44 24 18 E8 ?? ?? ?? ?? 48 81 C4 D8 00 00 00 C3 }
	condition:
		$1
}

rule file_1399_0_0 {
	meta:
		name = "___asprintf"
		size = 143
		refs = "0083 _IO_vasprintf"
	strings:
		$1 = { 48 81 EC D8 00 00 00 84 C0 48 89 54 24 30 48 89 4C 24 38 4C 89 44 24 40 4C 89 4C 24 48 74 37 0F 29 44 24 50 0F 29 4C 24 60 0F 29 54 24 70 0F 29 9C 24 80 00 00 00 0F 29 A4 24 90 00 00 00 0F 29 AC 24 A0 00 00 00 0F 29 B4 24 B0 00 00 00 0F 29 BC 24 C0 00 00 00 48 8D 84 24 E0 00 00 00 48 8D 54 24 08 48 89 44 24 10 48 8D 44 24 20 C7 44 24 08 10 00 00 00 C7 44 24 0C 30 00 00 00 48 89 44 24 18 E8 ?? ?? ?? ?? 48 81 C4 D8 00 00 00 C3 }
	condition:
		$1
}

rule file_1260_0_0 {
	meta:
		name = "__dprintf"
		size = 143
		refs = "0083 _IO_vdprintf"
	strings:
		$1 = { 48 81 EC D8 00 00 00 84 C0 48 89 54 24 30 48 89 4C 24 38 4C 89 44 24 40 4C 89 4C 24 48 74 37 0F 29 44 24 50 0F 29 4C 24 60 0F 29 54 24 70 0F 29 9C 24 80 00 00 00 0F 29 A4 24 90 00 00 00 0F 29 AC 24 A0 00 00 00 0F 29 B4 24 B0 00 00 00 0F 29 BC 24 C0 00 00 00 48 8D 84 24 E0 00 00 00 48 8D 54 24 08 48 89 44 24 10 48 8D 44 24 20 C7 44 24 08 10 00 00 00 C7 44 24 0C 30 00 00 00 48 89 44 24 18 E8 ?? ?? ?? ?? 48 81 C4 D8 00 00 00 C3 }
	condition:
		$1
}

rule file_881_0_0 {
	meta:
		name = "__fprintf"
		size = 143
		refs = "0083 vfprintf"
	strings:
		$1 = { 48 81 EC D8 00 00 00 84 C0 48 89 54 24 30 48 89 4C 24 38 4C 89 44 24 40 4C 89 4C 24 48 74 37 0F 29 44 24 50 0F 29 4C 24 60 0F 29 54 24 70 0F 29 9C 24 80 00 00 00 0F 29 A4 24 90 00 00 00 0F 29 AC 24 A0 00 00 00 0F 29 B4 24 B0 00 00 00 0F 29 BC 24 C0 00 00 00 48 8D 84 24 E0 00 00 00 48 8D 54 24 08 48 89 44 24 10 48 8D 44 24 20 C7 44 24 08 10 00 00 00 C7 44 24 0C 30 00 00 00 48 89 44 24 18 E8 ?? ?? ?? ?? 48 81 C4 D8 00 00 00 C3 }
	condition:
		$1
}

rule file_1274_0_0 {
	meta:
		name = "__fscanf"
		size = 143
		refs = "0083 __vfscanf"
	strings:
		$1 = { 48 81 EC D8 00 00 00 84 C0 48 89 54 24 30 48 89 4C 24 38 4C 89 44 24 40 4C 89 4C 24 48 74 37 0F 29 44 24 50 0F 29 4C 24 60 0F 29 54 24 70 0F 29 9C 24 80 00 00 00 0F 29 A4 24 90 00 00 00 0F 29 AC 24 A0 00 00 00 0F 29 B4 24 B0 00 00 00 0F 29 BC 24 C0 00 00 00 48 8D 84 24 E0 00 00 00 48 8D 54 24 08 48 89 44 24 10 48 8D 44 24 20 C7 44 24 08 10 00 00 00 C7 44 24 0C 30 00 00 00 48 89 44 24 18 E8 ?? ?? ?? ?? 48 81 C4 D8 00 00 00 C3 }
	condition:
		$1
}

rule file_866_0_0 {
	meta:
		name = "__fwprintf"
		size = 143
		refs = "0083 __vfwprintf"
	strings:
		$1 = { 48 81 EC D8 00 00 00 84 C0 48 89 54 24 30 48 89 4C 24 38 4C 89 44 24 40 4C 89 4C 24 48 74 37 0F 29 44 24 50 0F 29 4C 24 60 0F 29 54 24 70 0F 29 9C 24 80 00 00 00 0F 29 A4 24 90 00 00 00 0F 29 AC 24 A0 00 00 00 0F 29 B4 24 B0 00 00 00 0F 29 BC 24 C0 00 00 00 48 8D 84 24 E0 00 00 00 48 8D 54 24 08 48 89 44 24 10 48 8D 44 24 20 C7 44 24 08 10 00 00 00 C7 44 24 0C 30 00 00 00 48 89 44 24 18 E8 ?? ?? ?? ?? 48 81 C4 D8 00 00 00 C3 }
	condition:
		$1
}

rule file_894_0_0 {
	meta:
		name = "__fwscanf"
		size = 143
		refs = "0083 __vfwscanf"
	strings:
		$1 = { 48 81 EC D8 00 00 00 84 C0 48 89 54 24 30 48 89 4C 24 38 4C 89 44 24 40 4C 89 4C 24 48 74 37 0F 29 44 24 50 0F 29 4C 24 60 0F 29 54 24 70 0F 29 9C 24 80 00 00 00 0F 29 A4 24 90 00 00 00 0F 29 AC 24 A0 00 00 00 0F 29 B4 24 B0 00 00 00 0F 29 BC 24 C0 00 00 00 48 8D 84 24 E0 00 00 00 48 8D 54 24 08 48 89 44 24 10 48 8D 44 24 20 C7 44 24 08 10 00 00 00 C7 44 24 0C 30 00 00 00 48 89 44 24 18 E8 ?? ?? ?? ?? 48 81 C4 D8 00 00 00 C3 }
	condition:
		$1
}

rule file_548_0_0 {
	meta:
		name = "__isoc99_sscanf"
		size = 143
		refs = "0083 __isoc99_vsscanf"
	strings:
		$1 = { 48 81 EC D8 00 00 00 84 C0 48 89 54 24 30 48 89 4C 24 38 4C 89 44 24 40 4C 89 4C 24 48 74 37 0F 29 44 24 50 0F 29 4C 24 60 0F 29 54 24 70 0F 29 9C 24 80 00 00 00 0F 29 A4 24 90 00 00 00 0F 29 AC 24 A0 00 00 00 0F 29 B4 24 B0 00 00 00 0F 29 BC 24 C0 00 00 00 48 8D 84 24 E0 00 00 00 48 8D 54 24 08 48 89 44 24 10 48 8D 44 24 20 C7 44 24 08 10 00 00 00 C7 44 24 0C 30 00 00 00 48 89 44 24 18 E8 ?? ?? ?? ?? 48 81 C4 D8 00 00 00 C3 }
	condition:
		$1
}

rule file_1059_0_0 {
	meta:
		name = "__isoc99_swscanf"
		size = 143
		refs = "0083 __isoc99_vswscanf"
	strings:
		$1 = { 48 81 EC D8 00 00 00 84 C0 48 89 54 24 30 48 89 4C 24 38 4C 89 44 24 40 4C 89 4C 24 48 74 37 0F 29 44 24 50 0F 29 4C 24 60 0F 29 54 24 70 0F 29 9C 24 80 00 00 00 0F 29 A4 24 90 00 00 00 0F 29 AC 24 A0 00 00 00 0F 29 B4 24 B0 00 00 00 0F 29 BC 24 C0 00 00 00 48 8D 84 24 E0 00 00 00 48 8D 54 24 08 48 89 44 24 10 48 8D 44 24 20 C7 44 24 08 10 00 00 00 C7 44 24 0C 30 00 00 00 48 89 44 24 18 E8 ?? ?? ?? ?? 48 81 C4 D8 00 00 00 C3 }
	condition:
		$1
}

rule file_622_0_0 {
	meta:
		name = "__sprintf"
		size = 143
		refs = "0083 _IO_vsprintf"
	strings:
		$1 = { 48 81 EC D8 00 00 00 84 C0 48 89 54 24 30 48 89 4C 24 38 4C 89 44 24 40 4C 89 4C 24 48 74 37 0F 29 44 24 50 0F 29 4C 24 60 0F 29 54 24 70 0F 29 9C 24 80 00 00 00 0F 29 A4 24 90 00 00 00 0F 29 AC 24 A0 00 00 00 0F 29 B4 24 B0 00 00 00 0F 29 BC 24 C0 00 00 00 48 8D 84 24 E0 00 00 00 48 8D 54 24 08 48 89 44 24 10 48 8D 44 24 20 C7 44 24 08 10 00 00 00 C7 44 24 0C 30 00 00 00 48 89 44 24 18 E8 ?? ?? ?? ?? 48 81 C4 D8 00 00 00 C3 }
	condition:
		$1
}

rule file_344_0_0 {
	meta:
		name = "__sscanf"
		size = 143
		refs = "0083 _IO_vsscanf"
	strings:
		$1 = { 48 81 EC D8 00 00 00 84 C0 48 89 54 24 30 48 89 4C 24 38 4C 89 44 24 40 4C 89 4C 24 48 74 37 0F 29 44 24 50 0F 29 4C 24 60 0F 29 54 24 70 0F 29 9C 24 80 00 00 00 0F 29 A4 24 90 00 00 00 0F 29 AC 24 A0 00 00 00 0F 29 B4 24 B0 00 00 00 0F 29 BC 24 C0 00 00 00 48 8D 84 24 E0 00 00 00 48 8D 54 24 08 48 89 44 24 10 48 8D 44 24 20 C7 44 24 08 10 00 00 00 C7 44 24 0C 30 00 00 00 48 89 44 24 18 E8 ?? ?? ?? ?? 48 81 C4 D8 00 00 00 C3 }
	condition:
		$1
}

rule file_865_0_0 {
	meta:
		name = "__swscanf"
		size = 143
		refs = "0083 vswscanf"
	strings:
		$1 = { 48 81 EC D8 00 00 00 84 C0 48 89 54 24 30 48 89 4C 24 38 4C 89 44 24 40 4C 89 4C 24 48 74 37 0F 29 44 24 50 0F 29 4C 24 60 0F 29 54 24 70 0F 29 9C 24 80 00 00 00 0F 29 A4 24 90 00 00 00 0F 29 AC 24 A0 00 00 00 0F 29 B4 24 B0 00 00 00 0F 29 BC 24 C0 00 00 00 48 8D 84 24 E0 00 00 00 48 8D 54 24 08 48 89 44 24 10 48 8D 44 24 20 C7 44 24 08 10 00 00 00 C7 44 24 0C 30 00 00 00 48 89 44 24 18 E8 ?? ?? ?? ?? 48 81 C4 D8 00 00 00 C3 }
	condition:
		$1
}

rule file_69_0_0 {
	meta:
		name = "ether_ntohost"
		size = 330
		refs = "0050 __libc_errno 00a7 __nss_next2 00db strcpy 00f9 __nss_ethers_lookup"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 48 89 F5 53 48 81 EC 38 04 00 00 48 8B 15 ?? ?? ?? ?? 48 89 7C 24 08 48 85 D2 0F 84 BA 00 00 00 48 8B 05 ?? ?? ?? ?? 48 83 FA FF 48 89 54 24 18 48 89 44 24 10 0F 84 C8 00 00 00 64 48 8B 0C 25 00 00 00 00 48 8B 15 ?? ?? ?? ?? 4C 8D 64 24 10 4C 8D 6C 24 18 4C 8D 74 24 30 4C 8D 7C 24 20 48 01 D1 48 89 0C 24 EB 0C 0F 1F 80 00 00 00 00 48 8B 44 24 10 4C 8B 04 24 B9 00 04 00 00 4C 89 F2 4C 89 FE 48 89 EF FF D0 45 31 C9 31 D2 41 89 C0 4C 89 E1 BE ?? ?? ?? ?? 4C 89 EF 89 C3 E8 ?? ?? ?? ?? 85 C0 74 C9 83 FB 01 B8 FF FF FF FF 74 17 48 81 C4 38 04 00 00 5B 5D 41 5C 41 5D 41 5E 41 5F C3 0F 1F 44 00 00 48 8B 74 24 20 48 8B 7C 24 08 E8 ?? ?? ?? ?? 31 C0 EB D6 4C 8D 64 24 10 4C 8D 6C 24 18 BE ?? ?? ?? ?? 4C 89 E2 4C 89 EF E8 ?? ?? ?? ?? 85 C0 74 12 48 C7 05 ?? ?? ?? ?? FF FF FF FF B8 FF FF FF FF EB A6 48 8B 44 24 18 64 48 8B 0C 25 00 00 00 00 4C 8D 74 24 30 48 8B 15 ?? ?? ?? ?? 4C 8D 7C 24 20 48 89 05 ?? ?? ?? ?? 48 8B 44 24 10 48 89 05 ?? ?? ?? ?? E9 1E FF FF FF }
	condition:
		$1
}

rule file_70_0_0 {
	meta:
		name = "clnttcp_geterr"
		size = 28
	strings:
		$1 = { 48 8B 47 10 48 8B 50 30 48 89 16 48 8B 50 38 48 89 56 08 48 8B 40 40 48 89 46 10 C3 }
	condition:
		$1
}

rule file_70_1_0 {
	meta:
		name = "clnttcp_freeres"
		size = 25
	strings:
		$1 = { 48 8B 7F 10 48 89 F1 31 C0 48 89 D6 C7 47 68 02 00 00 00 48 83 C7 68 FF E1 }
	condition:
		$1
}

rule file_70_3_0 {
	meta:
		name = "clnttcp_destroy"
		size = 89
		refs = "0033 free 0053 __close"
	strings:
		$1 = { 48 89 5C 24 F0 48 89 6C 24 F8 48 83 EC 18 48 8B 5F 10 48 89 FD 8B 43 04 85 C0 75 34 48 8B 43 70 48 8B 40 38 48 85 C0 74 06 48 8D 7B 68 FF D0 48 89 DF E8 ?? ?? ?? ?? 48 89 EF 48 8B 5C 24 08 48 8B 6C 24 10 48 83 C4 18 E9 ?? ?? ?? ?? 0F 1F 00 8B 3B E8 ?? ?? ?? ?? EB C3 }
	condition:
		$1
}

rule file_70_4_0 {
	meta:
		name = "clnttcp_control"
		size = 297
	strings:
		$1 = { 83 FE 0F 48 8B 47 10 76 07 31 C0 C3 0F 1F 40 00 89 F6 FF 24 F5 ?? ?? ?? ?? 0F 1F 80 00 00 00 00 48 8B 12 0F CA 89 D2 48 89 50 54 B8 01 00 00 00 C3 0F 1F 80 00 00 00 00 48 8B 0A 48 89 48 08 48 8B 52 08 C7 40 18 01 00 00 00 48 89 50 10 B8 01 00 00 00 C3 0F 1F 40 00 48 8B 48 08 48 89 0A 48 8B 40 10 48 89 42 08 B8 01 00 00 00 C3 0F 1F 00 48 8B 48 1C 48 89 0A 48 8B 40 24 48 89 42 08 B8 01 00 00 00 C3 0F 1F 00 8B 00 89 02 B8 01 00 00 00 C3 66 0F 1F 44 00 00 C7 40 04 01 00 00 00 B8 01 00 00 00 C3 0F 1F 00 C7 40 04 00 00 00 00 B8 01 00 00 00 C3 0F 1F 00 48 8B 40 48 0F C8 89 C0 48 89 02 B8 01 00 00 00 C3 0F 1F 80 00 00 00 00 48 8B 12 83 EA 01 0F CA 89 D2 48 89 50 48 B8 01 00 00 00 C3 0F 1F 40 00 48 8B 40 58 0F C8 89 C0 48 89 02 B8 01 00 00 00 C3 0F 1F 80 00 00 00 00 48 8B 12 0F CA 89 D2 48 89 50 58 B8 01 00 00 00 C3 0F 1F 80 00 00 00 00 48 8B 40 54 0F C8 89 C0 48 89 02 B8 01 00 00 00 C3 }
	condition:
		$1
}

rule file_70_5_0 {
	meta:
		name = "clnttcp_call"
		size = 706
		refs = "00ff xdrrec_endofrecord 0129 _null_auth 0141 xdr_void 0163 xdrrec_skiprecord 0174 xdr_replymsg 01aa _seterr_reply 0296 xdr_opaque_auth"
	strings:
		$1 = { 41 57 4D 89 C7 41 56 41 55 41 54 49 89 FC 55 53 48 81 EC A8 00 00 00 48 8B 5F 10 48 89 4C 24 18 48 89 74 24 38 48 89 54 24 10 4C 89 4C 24 30 8B 4B 18 48 8D 6B 68 85 C9 75 18 48 8B 84 24 E0 00 00 00 48 89 43 08 48 8B 84 24 E8 00 00 00 48 89 43 10 4D 85 FF 41 BD 01 00 00 00 0F 84 9F 01 00 00 48 8D 43 48 48 8D 53 30 C7 44 24 24 03 00 00 00 48 89 44 24 08 48 89 54 24 28 44 8B 73 48 48 8B 43 70 48 89 EF C7 43 68 00 00 00 00 C7 43 30 00 00 00 00 8B 53 60 48 8B 74 24 08 41 83 EE 01 44 89 73 48 41 0F CE FF 50 18 85 C0 0F 84 6E 01 00 00 48 8B 43 70 48 8D 74 24 38 48 89 EF FF 50 08 85 C0 0F 84 57 01 00 00 49 8B 3C 24 48 89 EE 48 8B 47 38 FF 50 08 85 C0 0F 84 41 01 00 00 31 C0 48 8B 74 24 18 48 89 EF 48 8B 54 24 10 FF D2 85 C0 0F 84 28 01 00 00 44 89 EE 48 89 EF E8 ?? ?? ?? ?? 85 C0 0F 84 38 01 00 00 45 85 ED 0F 84 3D 01 00 00 48 83 7B 08 00 0F 84 C1 00 00 00 C7 43 68 01 00 00 00 48 8B 05 ?? ?? ?? ?? 48 89 EF 48 C7 44 24 78 00 00 00 00 48 C7 84 24 80 00 00 00 ?? ?? ?? ?? 48 89 44 24 58 48 8B 05 ?? ?? ?? ?? 48 89 44 24 60 48 8B 05 ?? ?? ?? ?? 48 89 44 24 68 E8 ?? ?? ?? ?? 85 C0 74 6D 48 8D 74 24 40 48 89 EF E8 ?? ?? ?? ?? 85 C0 75 1C 8B 43 30 85 C0 74 A3 48 81 C4 A8 00 00 00 5B 5D 41 5C 41 5D 41 5E 41 5F C3 0F 1F 00 44 3B 74 24 40 75 87 48 8B 74 24 28 48 8D 7C 24 40 E8 ?? ?? ?? ?? 8B 43 30 85 C0 0F 84 9F 00 00 00 83 6C 24 24 01 74 C3 49 8B 3C 24 48 8B 47 38 FF 50 18 85 C0 0F 85 A8 FE FF FF 0F 1F 44 00 00 8B 43 30 EB A6 0F 1F 00 48 83 7B 10 00 0F 85 34 FF FF FF C7 43 30 05 00 00 00 B8 05 00 00 00 EB 8A 0F 1F 80 00 00 00 00 48 83 7B 08 00 0F 85 56 FE FF FF 45 31 ED 48 83 7B 10 00 41 0F 95 C5 E9 45 FE FF FF 0F 1F 40 00 8B 53 30 85 D2 75 07 C7 43 30 01 00 00 00 BE 01 00 00 00 48 89 EF E8 ?? ?? ?? ?? 8B 43 30 E9 40 FF FF FF C7 43 30 03 00 00 00 B0 03 E9 32 FF FF FF 31 C0 E9 2B FF FF FF 49 8B 3C 24 48 8D 74 24 58 48 8B 47 38 FF 50 10 85 C0 75 36 C7 43 30 07 00 00 00 C7 43 38 06 00 00 00 48 83 7C 24 60 00 0F 84 52 FF FF FF 48 8D 74 24 58 C7 43 68 02 00 00 00 48 89 EF E8 ?? ?? ?? ?? 8B 43 30 E9 E1 FE FF FF 31 C0 48 8B 74 24 30 48 89 EF 41 FF D7 85 C0 75 C7 83 7B 30 00 75 C1 C7 43 30 02 00 00 00 EB B8 }
	condition:
		$1
}

rule file_70_6_0 {
	meta:
		name = "writetcp"
		size = 105
		refs = "0037 __write 0043 __libc_errno"
	strings:
		$1 = { 41 55 41 89 D5 41 54 49 89 FC 55 48 89 F5 53 89 D3 48 83 EC 08 85 D2 7F 13 EB 40 0F 1F 44 00 00 29 C3 48 63 C8 48 01 CD 85 DB 7E 2F 41 8B 3C 24 48 63 D3 48 89 EE E8 ?? ?? ?? ?? 83 F8 FF 75 E0 48 8B 15 ?? ?? ?? ?? 41 C7 44 24 30 03 00 00 00 41 89 C5 64 8B 12 41 89 54 24 38 48 83 C4 08 44 89 E8 5B 5D 41 5C 41 5D C3 }
	condition:
		$1
}

rule file_70_7_0 {
	meta:
		name = "readtcp"
		size = 286
		refs = "0069 __poll 007f __read 00e3 __libc_errno"
	strings:
		$1 = { 48 89 6C 24 E8 4C 89 64 24 F0 89 D5 48 89 5C 24 E0 4C 89 6C 24 F8 48 83 EC 38 85 D2 49 89 F4 48 8B 4F 10 48 8B 77 08 74 7F 8B 07 48 BA CF F7 53 E3 A5 9B C4 20 48 89 FB 69 F6 E8 03 00 00 66 C7 44 24 04 01 00 89 04 24 48 89 C8 48 C1 F9 3F 48 F7 EA 48 C1 FA 07 48 29 CA 44 8D 2C 16 44 89 EA BE 01 00 00 00 48 89 E7 E8 ?? ?? ?? ?? 83 F8 FF 74 6E 85 C0 74 52 8B 3B 48 63 D5 4C 89 E6 E8 ?? ?? ?? ?? 83 F8 FF 89 C5 74 7E 85 C0 75 1A C7 43 38 68 00 00 00 C7 43 30 04 00 00 00 BD FF FF FF FF 0F 1F 80 00 00 00 00 89 E8 48 8B 5C 24 18 48 8B 6C 24 20 4C 8B 64 24 28 4C 8B 6C 24 30 48 83 C4 38 C3 0F 1F 44 00 00 C7 43 30 05 00 00 00 BD FF FF FF FF EB D2 66 2E 0F 1F 84 00 00 00 00 00 48 8B 15 ?? ?? ?? ?? 64 8B 12 83 FA 04 0F 84 6A FF FF FF C7 43 30 04 00 00 00 89 53 38 89 C5 EB A7 0F 1F 80 00 00 00 00 48 8B 05 ?? ?? ?? ?? C7 43 30 04 00 00 00 64 8B 00 89 43 38 EB 8A }
	condition:
		$1
}

rule file_70_8_0 {
	meta:
		name = "clnttcp_create"
		size = 688
		refs = "0041 malloc 00ac _create_xid 00e3 xdrmem_create 00f0 xdr_callhdr 0137 xdrrec_create 0148 authnone_create 019f pmap_getport 01cc __socket 01d8 bindresvport 01f0 __connect 021c __close 0224 free 0241 __rpc_thread_createerr 0250 _libc_intl_domainname 0258 __dcgettext 026e __fxprintf 0290 __libc_errno"
	strings:
		$1 = { 48 89 5C 24 D0 48 89 6C 24 D8 48 89 CD 4C 89 64 24 E0 4C 89 6C 24 E8 49 89 D4 4C 89 74 24 F0 4C 89 7C 24 F8 48 81 EC A8 00 00 00 49 89 FF BF 18 00 00 00 49 89 F5 44 89 44 24 08 44 89 4C 24 0C E8 ?? ?? ?? ?? BF 98 00 00 00 48 89 C3 E8 ?? ?? ?? ?? 48 85 C0 49 89 C6 0F 84 E2 01 00 00 48 85 DB 0F 84 D9 01 00 00 66 41 83 7F 02 00 0F 84 1D 01 00 00 8B 7D 00 85 FF 0F 88 3E 01 00 00 41 C7 46 04 00 00 00 00 8B 45 00 49 C7 46 10 00 00 00 00 41 C7 46 18 00 00 00 00 41 89 06 49 8B 07 49 89 46 1C 49 8B 47 08 49 89 46 24 E8 ?? ?? ?? ?? 4C 89 64 24 30 4D 8D 66 68 49 8D 76 48 31 C9 BA 18 00 00 00 48 89 44 24 10 4C 89 E7 C7 44 24 18 00 00 00 00 48 C7 44 24 20 02 00 00 00 4C 89 6C 24 28 E8 ?? ?? ?? ?? 48 8D 74 24 10 4C 89 E7 E8 ?? ?? ?? ?? 85 C0 0F 84 14 01 00 00 49 8B 46 70 4C 89 E7 FF 50 20 41 89 46 60 49 8B 46 70 48 8B 40 38 48 85 C0 74 05 4C 89 E7 FF D0 8B 54 24 0C 8B 74 24 08 41 B9 ?? ?? ?? ?? 41 B8 ?? ?? ?? ?? 4C 89 F1 4C 89 E7 E8 ?? ?? ?? ?? 48 C7 43 08 ?? ?? ?? ?? 4C 89 73 10 E8 ?? ?? ?? ?? 48 89 03 48 89 D8 48 8B AC 24 80 00 00 00 48 8B 5C 24 78 4C 8B A4 24 88 00 00 00 4C 8B AC 24 90 00 00 00 4C 8B B4 24 98 00 00 00 4C 8B BC 24 A0 00 00 00 48 81 C4 A8 00 00 00 C3 66 0F 1F 84 00 00 00 00 00 B9 06 00 00 00 4C 89 E2 4C 89 EE 4C 89 FF E8 ?? ?? ?? ?? 66 85 C0 74 78 8B 7D 00 66 C1 C8 08 66 41 89 47 02 85 FF 0F 89 C2 FE FF FF BA 06 00 00 00 BE 01 00 00 00 BF 02 00 00 00 E8 ?? ?? ?? ?? 31 F6 89 C7 89 45 00 E8 ?? ?? ?? ?? 8B 7D 00 85 FF 0F 88 A1 00 00 00 BA 10 00 00 00 4C 89 FE E8 ?? ?? ?? ?? 85 C0 0F 88 8C 00 00 00 41 C7 46 04 01 00 00 00 E9 7D FE FF FF 0F 1F 80 00 00 00 00 41 8B 76 04 85 F6 74 08 8B 7D 00 E8 ?? ?? ?? ?? 4C 89 F7 E8 ?? ?? ?? ?? 48 89 DF 31 DB E8 ?? ?? ?? ?? E9 18 FF FF FF 66 0F 1F 84 00 00 00 00 00 E8 ?? ?? ?? ?? BA 05 00 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? 48 89 C5 E8 ?? ?? ?? ?? BA ?? ?? ?? ?? 48 89 C1 BE ?? ?? ?? ?? 31 FF 31 C0 E8 ?? ?? ?? ?? C7 45 00 0C 00 00 00 C7 45 10 0C 00 00 00 EB 9E 66 0F 1F 44 00 00 E8 ?? ?? ?? ?? 48 8B 15 ?? ?? ?? ?? C7 00 0C 00 00 00 64 8B 12 89 50 10 8B 7D 00 85 FF 0F 89 70 FF FF FF E9 70 FF FF FF }
	condition:
		$1
}

rule file_71_0_0 {
	meta:
		name = "__libc_siglongjmp"
		size = 61
		refs = "000c _longjmp_unwind 0027 __longjmp 0037 __sigprocmask"
	strings:
		$1 = { 55 48 89 FD 53 89 F3 48 83 EC 08 E8 ?? ?? ?? ?? 8B 45 40 85 C0 75 14 85 DB B8 01 00 00 00 48 89 EF 0F 44 D8 89 DE E8 ?? ?? ?? ?? 48 8D 75 48 31 D2 BF 02 00 00 00 E8 ?? ?? ?? ?? EB DA }
	condition:
		$1
}

rule file_1410_0_0 {
	meta:
		name = "__longjmp_chk"
		size = 61
		refs = "000c _longjmp_unwind 0027 ____longjmp_chk 0037 __sigprocmask"
	strings:
		$1 = { 55 48 89 FD 53 89 F3 48 83 EC 08 E8 ?? ?? ?? ?? 8B 45 40 85 C0 75 14 85 DB B8 01 00 00 00 48 89 EF 0F 44 D8 89 DE E8 ?? ?? ?? ?? 48 8D 75 48 31 D2 BF 02 00 00 00 E8 ?? ?? ?? ?? EB DA }
	condition:
		$1
}

rule file_72_0_0 {
	meta:
		name = "__getgrnam_r"
		size = 625
		refs = "001c __nss_not_use_nscd_group 0094 __libc_errno 00b6 _dl_mcount_wrapper_check 00fb __nss_next2 014c __nss_database_custom 0169 __nscd_getgrnam_r 01e2 __nss_group_lookup2"
	strings:
		$1 = { 41 57 41 56 41 55 49 89 CD 41 54 49 89 D4 55 48 89 FD 53 48 89 F3 48 83 EC 28 8B 05 ?? ?? ?? ?? 4C 89 44 24 08 83 F8 00 0F 8E 92 01 00 00 83 C0 01 83 F8 64 0F 8F 06 01 00 00 89 05 ?? ?? ?? ?? 80 3D ?? ?? ?? ?? 00 0F 84 83 01 00 00 48 8B 05 ?? ?? ?? ?? 48 C1 C8 11 64 48 33 04 25 30 00 00 00 48 89 44 24 10 48 8B 05 ?? ?? ?? ?? 48 C1 C8 11 64 48 33 04 25 30 00 00 00 48 83 F8 FF 48 89 44 24 18 0F 94 C0 0F B6 C0 85 C0 0F 85 E5 00 00 00 48 8B 05 ?? ?? ?? ?? 49 89 C6 64 4C 03 34 25 00 00 00 00 48 89 04 24 0F 1F 84 00 00 00 00 00 48 8B 7C 24 10 E8 ?? ?? ?? ?? 4D 89 F0 4C 89 E9 4C 89 E2 48 89 DE 48 89 EF FF 54 24 10 83 F8 FE 41 89 C7 75 0E 48 8B 14 24 64 83 3A 22 0F 84 AD 00 00 00 48 8D 4C 24 10 48 8D 7C 24 18 45 31 C9 31 D2 45 89 F8 BE ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 AD 41 83 FF 01 48 8B 44 24 08 0F 84 1E 01 00 00 48 C7 00 00 00 00 00 0F 86 4E 01 00 00 48 8B 14 24 64 8B 02 83 F8 22 74 7D 48 83 C4 28 5B 5D 41 5C 41 5D 41 5E 41 5F C3 66 0F 1F 44 00 00 C7 05 ?? ?? ?? ?? 00 00 00 00 80 3D ?? ?? ?? ?? 00 0F 85 E9 FE FF FF 4C 8B 44 24 08 4C 89 E9 4C 89 E2 48 89 DE 48 89 EF E8 ?? ?? ?? ?? 85 C0 79 BA E9 CA FE FF FF 48 8B 15 ?? ?? ?? ?? 41 BF FF FF FF FF 48 89 14 24 66 0F 1F 84 00 00 00 00 00 48 8B 44 24 08 48 8B 14 24 48 C7 00 00 00 00 00 64 8B 02 83 F8 22 75 83 41 83 FF FE 0F 84 79 FF FF FF B0 16 EB 7F 66 2E 0F 1F 84 00 00 00 00 00 74 88 80 3D ?? ?? ?? ?? 00 0F 85 7E FE FF FF 90 48 8D 4C 24 10 48 8D 7C 24 18 31 D2 BE ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 75 66 48 8B 54 24 10 64 48 33 14 25 30 00 00 00 48 C1 C2 11 48 89 15 ?? ?? ?? ?? 48 8B 54 24 18 64 48 33 14 25 30 00 00 00 48 C1 C2 11 48 89 15 ?? ?? ?? ?? C6 05 ?? ?? ?? ?? 01 E9 61 FE FF FF 0F 1F 84 00 00 00 00 00 48 89 18 31 C0 48 8B 14 24 64 89 02 48 83 C4 28 5B 5D 41 5C 41 5D 41 5E 41 5F C3 0F 1F 44 00 00 48 C7 C2 FF FF FF FF 64 48 33 14 25 30 00 00 00 48 C1 C2 11 48 89 15 ?? ?? ?? ?? EB AF 31 C0 EB C4 }
	condition:
		$1
}

rule file_325_0_0 {
	meta:
		name = "__getpwnam_r"
		size = 625
		refs = "001c __nss_not_use_nscd_passwd 0094 __libc_errno 00b6 _dl_mcount_wrapper_check 00fb __nss_next2 014c __nss_database_custom 0169 __nscd_getpwnam_r 01e2 __nss_passwd_lookup2"
	strings:
		$1 = { 41 57 41 56 41 55 49 89 CD 41 54 49 89 D4 55 48 89 FD 53 48 89 F3 48 83 EC 28 8B 05 ?? ?? ?? ?? 4C 89 44 24 08 83 F8 00 0F 8E 92 01 00 00 83 C0 01 83 F8 64 0F 8F 06 01 00 00 89 05 ?? ?? ?? ?? 80 3D ?? ?? ?? ?? 00 0F 84 83 01 00 00 48 8B 05 ?? ?? ?? ?? 48 C1 C8 11 64 48 33 04 25 30 00 00 00 48 89 44 24 10 48 8B 05 ?? ?? ?? ?? 48 C1 C8 11 64 48 33 04 25 30 00 00 00 48 83 F8 FF 48 89 44 24 18 0F 94 C0 0F B6 C0 85 C0 0F 85 E5 00 00 00 48 8B 05 ?? ?? ?? ?? 49 89 C6 64 4C 03 34 25 00 00 00 00 48 89 04 24 0F 1F 84 00 00 00 00 00 48 8B 7C 24 10 E8 ?? ?? ?? ?? 4D 89 F0 4C 89 E9 4C 89 E2 48 89 DE 48 89 EF FF 54 24 10 83 F8 FE 41 89 C7 75 0E 48 8B 14 24 64 83 3A 22 0F 84 AD 00 00 00 48 8D 4C 24 10 48 8D 7C 24 18 45 31 C9 31 D2 45 89 F8 BE ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 AD 41 83 FF 01 48 8B 44 24 08 0F 84 1E 01 00 00 48 C7 00 00 00 00 00 0F 86 4E 01 00 00 48 8B 14 24 64 8B 02 83 F8 22 74 7D 48 83 C4 28 5B 5D 41 5C 41 5D 41 5E 41 5F C3 66 0F 1F 44 00 00 C7 05 ?? ?? ?? ?? 00 00 00 00 80 3D ?? ?? ?? ?? 00 0F 85 E9 FE FF FF 4C 8B 44 24 08 4C 89 E9 4C 89 E2 48 89 DE 48 89 EF E8 ?? ?? ?? ?? 85 C0 79 BA E9 CA FE FF FF 48 8B 15 ?? ?? ?? ?? 41 BF FF FF FF FF 48 89 14 24 66 0F 1F 84 00 00 00 00 00 48 8B 44 24 08 48 8B 14 24 48 C7 00 00 00 00 00 64 8B 02 83 F8 22 75 83 41 83 FF FE 0F 84 79 FF FF FF B0 16 EB 7F 66 2E 0F 1F 84 00 00 00 00 00 74 88 80 3D ?? ?? ?? ?? 00 0F 85 7E FE FF FF 90 48 8D 4C 24 10 48 8D 7C 24 18 31 D2 BE ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 75 66 48 8B 54 24 10 64 48 33 14 25 30 00 00 00 48 C1 C2 11 48 89 15 ?? ?? ?? ?? 48 8B 54 24 18 64 48 33 14 25 30 00 00 00 48 C1 C2 11 48 89 15 ?? ?? ?? ?? C6 05 ?? ?? ?? ?? 01 E9 61 FE FF FF 0F 1F 84 00 00 00 00 00 48 89 18 31 C0 48 8B 14 24 64 89 02 48 83 C4 28 5B 5D 41 5C 41 5D 41 5E 41 5F C3 0F 1F 44 00 00 48 C7 C2 FF FF FF FF 64 48 33 14 25 30 00 00 00 48 C1 C2 11 48 89 15 ?? ?? ?? ?? EB AF 31 C0 EB C4 }
	condition:
		$1
}

rule file_73_0_0 {
	meta:
		name = "__vwprintf"
		size = 18
		refs = "0009 stdout 000e __vfwprintf"
	strings:
		$1 = { 48 89 F2 48 89 FE 48 8B 3D ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_822_0_0 {
	meta:
		name = "__vprintf"
		size = 18
		refs = "0009 stdout 000e vfprintf"
	strings:
		$1 = { 48 89 F2 48 89 FE 48 8B 3D ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_74_0_0 {
	meta:
		name = "__link"
		size = 20
		refs = "000f __syscall_error"
	strings:
		$1 = { B8 56 00 00 00 0F 05 48 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_75_0_0 {
	meta:
		name = "getpass"
		size = 530
		refs = "002e _IO_new_fopen 004e fileno 005a __tcgetattr 0077 __fxprintf 007f fflush_unlocked 0091 __getline 00c4 stdin 00ce _IO_new_fclose 017a tcsetattr 01ea stderr 020e _Unwind_Resume"
	strings:
		$1 = { 48 89 5C 24 D8 4C 89 74 24 F8 BE ?? ?? ?? ?? 48 89 6C 24 E0 4C 89 64 24 E8 49 89 FE 4C 89 6C 24 F0 BF ?? ?? ?? ?? 48 81 EC A8 00 00 00 E8 ?? ?? ?? ?? 48 85 C0 48 89 C3 0F 84 A2 01 00 00 81 08 00 80 00 00 49 89 C4 48 89 C5 48 89 EF E8 ?? ?? ?? ?? 48 8D 74 24 40 89 C7 E8 ?? ?? ?? ?? 45 31 ED 85 C0 0F 84 A7 00 00 00 4C 89 F2 BE ?? ?? ?? ?? 4C 89 E7 31 C0 E8 ?? ?? ?? ?? 4C 89 E7 E8 ?? ?? ?? ?? 48 89 EA BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 15 ?? ?? ?? ?? 48 85 D2 74 17 48 85 C0 0F 88 26 01 00 00 48 8D 44 02 FF 80 38 0A 0F 84 D8 00 00 00 45 85 ED 0F 85 EF 00 00 00 48 3B 2D ?? ?? ?? ?? 74 08 48 89 EF E8 ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? 48 8B 9C 24 80 00 00 00 48 8B AC 24 88 00 00 00 4C 8B A4 24 90 00 00 00 4C 8B AC 24 98 00 00 00 4C 8B B4 24 A0 00 00 00 48 81 C4 A8 00 00 00 C3 0F 1F 80 00 00 00 00 48 8B 44 24 40 48 89 EF 45 31 ED 48 89 04 24 48 8B 44 24 48 83 64 24 4C F6 48 89 44 24 08 48 8B 44 24 50 48 89 44 24 10 48 8B 44 24 58 48 89 44 24 18 48 8B 44 24 60 48 89 44 24 20 48 8B 44 24 68 48 89 44 24 28 48 8B 44 24 70 48 89 44 24 30 8B 44 24 78 89 44 24 38 E8 ?? ?? ?? ?? 48 8D 54 24 40 BE 02 00 00 00 89 C7 E8 ?? ?? ?? ?? 85 C0 41 0F 94 C5 E9 E0 FE FF FF 0F 1F 80 00 00 00 00 45 85 ED C6 00 00 0F 84 25 FF FF FF BE ?? ?? ?? ?? 4C 89 E7 31 C0 E8 ?? ?? ?? ?? 0F 1F 44 00 00 48 89 EF E8 ?? ?? ?? ?? 48 89 E2 BE 02 00 00 00 89 C7 E8 ?? ?? ?? ?? E9 F5 FE FF FF 0F 1F 40 00 C6 02 00 E9 E0 FE FF FF 0F 1F 84 00 00 00 00 00 48 8B 2D ?? ?? ?? ?? 4C 8B 25 ?? ?? ?? ?? 4C 39 E5 48 0F 44 DD E9 50 FE FF FF 48 85 DB 48 89 C5 74 08 48 89 DF E8 ?? ?? ?? ?? 48 89 EF E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_76_0_0 {
	meta:
		name = "_L_lock_55"
		size = 27
		refs = "000b __lll_lock_wait_private"
	strings:
		$1 = { 48 8D 3A 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 17 FF FF FF }
	condition:
		$1
}

rule file_76_1_0 {
	meta:
		name = "_L_unlock_118"
		size = 24
		refs = "000b __lll_unlock_wake_private"
	strings:
		$1 = { 48 8D 3E 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 EB 82 }
	condition:
		$1
}

rule file_76_2_0 {
	meta:
		name = "_L_unlock_170"
		size = 24
		refs = "000b __lll_unlock_wake_private"
		altNames = "_L_unlock_130 _L_unlock_138 _L_unlock_142 _L_unlock_147 _L_unlock_152 _L_unlock_184 _L_unlock_192 _L_unlock_223 _L_unlock_246 _L_unlock_57"
	strings:
		$1 = { 48 8D 3A 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 EB AD }
	condition:
		$1
}

rule file_76_3_0 {
	meta:
		name = "__isoc99_fscanf"
		size = 365
		refs = "0083 __libc_multiple_threads 00e7 _IO_vfscanf 0169 _Unwind_Resume"
	strings:
		$1 = { 53 48 89 FB 48 81 EC D0 00 00 00 84 C0 48 89 54 24 30 48 89 4C 24 38 4C 89 44 24 40 4C 89 4C 24 48 74 37 0F 29 44 24 50 0F 29 4C 24 60 0F 29 54 24 70 0F 29 9C 24 80 00 00 00 0F 29 A4 24 90 00 00 00 0F 29 AC 24 A0 00 00 00 0F 29 B4 24 B0 00 00 00 0F 29 BC 24 C0 00 00 00 49 89 F1 8B 03 25 00 80 00 00 75 48 48 8B 93 88 00 00 00 64 4C 8B 14 25 10 00 00 00 4C 3B 52 08 74 2E BE 01 00 00 00 83 3D ?? ?? ?? ?? 00 74 0C F0 0F B1 32 0F 85 D9 00 00 00 EB 09 0F B1 32 0F 85 CE 00 00 00 48 8B 93 88 00 00 00 4C 89 52 08 83 42 04 01 48 8D 84 24 E0 00 00 00 83 4B 74 10 48 8D 54 24 08 31 C9 4C 89 CE 48 89 DF 48 89 44 24 10 48 8D 44 24 20 C7 44 24 08 10 00 00 00 C7 44 24 0C 30 00 00 00 48 89 44 24 18 E8 ?? ?? ?? ?? 83 63 74 EB F7 03 00 80 00 00 89 C2 75 29 48 8B B3 88 00 00 00 83 6E 04 01 75 1C 48 C7 46 08 00 00 00 00 83 3D ?? ?? ?? ?? 00 74 07 F0 FF 0E 75 6C EB 04 FF 0E 75 66 48 81 C4 D0 00 00 00 89 D0 5B C3 83 63 74 EB F7 03 00 80 00 00 48 89 C6 75 29 48 8B 93 88 00 00 00 83 6A 04 01 75 1C 48 C7 42 08 00 00 00 00 83 3D ?? ?? ?? ?? 00 74 07 F0 FF 0A 75 41 EB 04 FF 0A 75 3B 48 89 F7 E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_826_3_0 {
	meta:
		name = "__isoc99_fwscanf"
		size = 365
		refs = "0083 __libc_multiple_threads 00e7 _IO_vfwscanf 0169 _Unwind_Resume"
	strings:
		$1 = { 53 48 89 FB 48 81 EC D0 00 00 00 84 C0 48 89 54 24 30 48 89 4C 24 38 4C 89 44 24 40 4C 89 4C 24 48 74 37 0F 29 44 24 50 0F 29 4C 24 60 0F 29 54 24 70 0F 29 9C 24 80 00 00 00 0F 29 A4 24 90 00 00 00 0F 29 AC 24 A0 00 00 00 0F 29 B4 24 B0 00 00 00 0F 29 BC 24 C0 00 00 00 49 89 F1 8B 03 25 00 80 00 00 75 48 48 8B 93 88 00 00 00 64 4C 8B 14 25 10 00 00 00 4C 3B 52 08 74 2E BE 01 00 00 00 83 3D ?? ?? ?? ?? 00 74 0C F0 0F B1 32 0F 85 D9 00 00 00 EB 09 0F B1 32 0F 85 CE 00 00 00 48 8B 93 88 00 00 00 4C 89 52 08 83 42 04 01 48 8D 84 24 E0 00 00 00 83 4B 74 10 48 8D 54 24 08 31 C9 4C 89 CE 48 89 DF 48 89 44 24 10 48 8D 44 24 20 C7 44 24 08 10 00 00 00 C7 44 24 0C 30 00 00 00 48 89 44 24 18 E8 ?? ?? ?? ?? 83 63 74 EB F7 03 00 80 00 00 89 C2 75 29 48 8B B3 88 00 00 00 83 6E 04 01 75 1C 48 C7 46 08 00 00 00 00 83 3D ?? ?? ?? ?? 00 74 07 F0 FF 0E 75 6C EB 04 FF 0E 75 66 48 81 C4 D0 00 00 00 89 D0 5B C3 83 63 74 EB F7 03 00 80 00 00 48 89 C6 75 29 48 8B 93 88 00 00 00 83 6A 04 01 75 1C 48 C7 42 08 00 00 00 00 83 3D ?? ?? ?? ?? 00 74 07 F0 FF 0A 75 41 EB 04 FF 0A 75 3B 48 89 F7 E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_78_0_0 {
	meta:
		name = "mktemp"
		size = 30
		refs = "000e __gen_tempname"
	strings:
		$1 = { 53 31 D2 31 F6 B9 02 00 00 00 48 89 FB E8 ?? ?? ?? ?? 85 C0 79 03 C6 03 00 48 89 D8 5B C3 }
	condition:
		$1
}

rule file_80_0_0 {
	meta:
		name = "strftime"
		size = 16
		refs = "0003 __libc_tsd_LOCALE 000c __strftime_l"
	strings:
		$1 = { 48 8B 05 ?? ?? ?? ?? 64 4C 8B 00 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_935_0_0 {
	meta:
		name = "__strtol_internal"
		size = 16
		refs = "0003 __libc_tsd_LOCALE 000c ____strtol_l_internal"
	strings:
		$1 = { 48 8B 05 ?? ?? ?? ?? 64 4C 8B 00 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_801_0_0 {
	meta:
		name = "__strtoul_internal"
		size = 16
		refs = "0003 __libc_tsd_LOCALE 000c ____strtoul_l_internal"
	strings:
		$1 = { 48 8B 05 ?? ?? ?? ?? 64 4C 8B 00 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_82_0_0 {
	meta:
		name = "__wcstol_internal"
		size = 16
		refs = "0003 __libc_tsd_LOCALE 000c ____wcstol_l_internal"
	strings:
		$1 = { 48 8B 05 ?? ?? ?? ?? 64 4C 8B 00 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_208_0_0 {
	meta:
		name = "__wcstoul_internal"
		size = 16
		refs = "0003 __libc_tsd_LOCALE 000c ____wcstoul_l_internal"
	strings:
		$1 = { 48 8B 05 ?? ?? ?? ?? 64 4C 8B 00 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_342_0_0 {
	meta:
		name = "wcsftime"
		size = 16
		refs = "0003 __libc_tsd_LOCALE 000c __wcsftime_l"
	strings:
		$1 = { 48 8B 05 ?? ?? ?? ?? 64 4C 8B 00 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_81_0_0 {
	meta:
		name = "__socketpair"
		size = 23
		refs = "0012 __syscall_error"
	strings:
		$1 = { 49 89 CA B8 35 00 00 00 0F 05 48 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_82_1_0 {
	meta:
		name = "wcstol"
		size = 18
		refs = "0003 __libc_tsd_LOCALE 000e ____wcstol_l_internal"
	strings:
		$1 = { 48 8B 05 ?? ?? ?? ?? 31 C9 64 4C 8B 00 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_136_0_0 {
	meta:
		name = "strptime"
		size = 18
		refs = "0003 __libc_tsd_LOCALE 000e __strptime_internal"
	strings:
		$1 = { 48 8B 05 ?? ?? ?? ?? 31 C9 64 4C 8B 00 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_935_1_0 {
	meta:
		name = "strtol"
		size = 18
		refs = "0003 __libc_tsd_LOCALE 000e ____strtol_l_internal"
	strings:
		$1 = { 48 8B 05 ?? ?? ?? ?? 31 C9 64 4C 8B 00 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_801_1_0 {
	meta:
		name = "strtoul"
		size = 18
		refs = "0003 __libc_tsd_LOCALE 000e ____strtoul_l_internal"
	strings:
		$1 = { 48 8B 05 ?? ?? ?? ?? 31 C9 64 4C 8B 00 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_208_1_0 {
	meta:
		name = "wcstoul"
		size = 18
		refs = "0003 __libc_tsd_LOCALE 000e ____wcstoul_l_internal"
	strings:
		$1 = { 48 8B 05 ?? ?? ?? ?? 31 C9 64 4C 8B 00 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_83_0_0 {
	meta:
		name = "nfsservctl"
		size = 20
		refs = "000f __syscall_error"
	strings:
		$1 = { B8 B4 00 00 00 0F 05 48 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_84_0_0 {
	meta:
		name = "listxattr"
		size = 20
		refs = "000f __syscall_error"
	strings:
		$1 = { B8 C2 00 00 00 0F 05 48 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_85_0_0 {
	meta:
		name = "memfrob"
		size = 30
	strings:
		$1 = { 48 85 F6 48 89 F8 48 8D 0C 37 48 89 FA 74 0D 90 80 32 2A 48 83 C2 01 48 39 CA 75 F4 F3 C3 }
	condition:
		$1
}

rule file_86_0_0 {
	meta:
		name = "__exit_thread"
		size = 19
		refs = "000f __syscall_error"
	strings:
		$1 = { B8 3C 00 00 00 0F 05 48 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_87_0_0 {
	meta:
		name = "sigignore"
		size = 68
		refs = "0038 __sigaction"
	strings:
		$1 = { 48 81 EC A8 00 00 00 41 89 F8 31 C0 48 8D 54 24 08 B9 10 00 00 00 48 89 E6 48 C7 04 24 01 00 00 00 C7 84 24 88 00 00 00 00 00 00 00 48 89 D7 31 D2 F3 48 AB 44 89 C7 E8 ?? ?? ?? ?? 48 81 C4 A8 00 00 00 C3 }
	condition:
		$1
}

rule file_88_0_0 {
	meta:
		name = "seteuid"
		size = 121
		refs = "0006 __nptl_setxid 0043 __libc_errno"
	strings:
		$1 = { 83 FF FF 74 3B B8 ?? ?? ?? ?? 48 85 C0 74 42 48 83 EC 38 89 FF 48 89 7C 24 10 C7 04 24 75 00 00 00 48 89 E7 48 C7 44 24 08 FF FF FF FF 48 C7 44 24 18 FF FF FF FF FF D0 48 83 C4 38 F3 C3 66 90 48 8B 05 ?? ?? ?? ?? 64 C7 00 16 00 00 00 89 F8 C3 48 83 CA FF 89 FE B8 75 00 00 00 48 89 D7 0F 05 48 3D 00 F0 FF FF 76 D3 48 8B 15 ?? ?? ?? ?? F7 D8 64 89 02 48 89 F8 C3 }
	condition:
		$1
}

rule file_90_0_0 {
	meta:
		name = "__libc_init_secure"
		size = 69
		refs = "0002 __libc_enable_secure_decided 0012 __geteuid 0019 __getuid 0028 __libc_enable_secure 0031 __getegid 0038 __getgid"
	strings:
		$1 = { 8B 05 ?? ?? ?? ?? 85 C0 74 06 F3 C3 0F 1F 40 00 53 E8 ?? ?? ?? ?? 89 C3 E8 ?? ?? ?? ?? 39 C3 BA 01 00 00 00 74 0A 89 15 ?? ?? ?? ?? 5B C3 66 90 E8 ?? ?? ?? ?? 89 C3 E8 ?? ?? ?? ?? 31 D2 39 C3 0F 95 C2 EB E1 }
	condition:
		$1
}

rule file_91_0_0 {
	meta:
		name = "fchmodat"
		size = 355
		refs = "0032 __have_atfcts 0073 __libc_errno 0097 strlen 00d0 __snprintf 00f7 __atfct_seterrno"
	strings:
		$1 = { F7 C1 FF FE FF FF 0F 85 04 01 00 00 80 E5 01 0F 85 13 01 00 00 55 48 89 E5 48 89 5D E0 4C 89 65 E8 48 89 F3 4C 89 6D F0 4C 89 75 F8 48 83 EC 20 8B 05 ?? ?? ?? ?? 41 89 FC 41 89 D5 85 C0 78 48 89 D2 48 63 FF B8 0C 01 00 00 0F 05 48 3D 00 F0 FF FF 0F 87 E4 00 00 00 83 F8 FF 74 13 48 8B 5D E0 4C 8B 65 E8 4C 8B 6D F0 4C 8B 75 F8 C9 C3 90 48 8B 15 ?? ?? ?? ?? 64 83 3A 26 B8 FF FF FF FF 75 DB 89 05 ?? ?? ?? ?? 41 83 FC 9C 74 7A 80 3B 2F 74 75 48 89 DF E8 ?? ?? ?? ?? 48 85 C0 0F 84 A9 00 00 00 48 8D 70 20 48 83 C0 3E 49 89 D8 48 83 E0 F0 44 89 E1 BA ?? ?? ?? ?? 48 29 C4 31 C0 4C 8D 74 24 0F 49 83 E6 F0 4C 89 F7 4C 89 F3 E8 ?? ?? ?? ?? 44 89 EE 48 89 DF B8 5A 00 00 00 0F 05 3D 00 F0 FF FF 0F 86 71 FF FF FF 89 C7 4C 89 F2 44 89 E6 F7 DF E8 ?? ?? ?? ?? 83 C8 FF E9 5A FF FF FF 0F 1F 44 00 00 45 31 F6 EB C7 0F 1F 00 48 8B 05 ?? ?? ?? ?? 64 C7 00 16 00 00 00 B8 FF FF FF FF C3 0F 1F 40 00 48 8B 05 ?? ?? ?? ?? 64 C7 00 5F 00 00 00 B8 FF FF FF FF C3 48 8B 15 ?? ?? ?? ?? F7 D8 64 89 02 E9 2A FF FF FF 48 8B 05 ?? ?? ?? ?? 64 C7 00 02 00 00 00 83 C8 FF E9 FA FE FF FF }
	condition:
		$1
}

rule file_92_1_0 {
	meta:
		name = "__dlclose"
		size = 29
		refs = "000d _dlerror_run"
	strings:
		$1 = { 48 83 EC 08 48 89 FE BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 F8 01 19 C0 48 83 C4 08 F7 D0 C3 }
	condition:
		$1
}

rule file_93_0_0 {
	meta:
		name = "__ptsname_internal"
		size = 718
		refs = "0025 __libc_errno 003f __isatty 00a0 __ioctl 00ba __xstat64 0136 _itoa_word 0167 memcpy 01c2 __fxstat64 0211 __libc_ptyname1 0232 strlen 0267 __libc_ptyname2"
	strings:
		$1 = { 48 89 5C 24 D0 4C 89 7C 24 F8 48 89 6C 24 D8 4C 89 64 24 E0 4C 89 6C 24 E8 4C 89 74 24 F0 48 83 EC 68 48 8B 1D ?? ?? ?? ?? 48 85 F6 64 44 8B 3B 74 46 41 89 FC 48 89 F5 49 89 D6 49 89 CD E8 ?? ?? ?? ?? 85 C0 75 49 64 C7 03 19 00 00 00 B0 19 48 8B 5C 24 38 48 8B 6C 24 40 4C 8B 64 24 48 4C 8B 6C 24 50 4C 8B 74 24 58 4C 8B 7C 24 60 48 83 C4 68 C3 0F 1F 44 00 00 64 C7 03 16 00 00 00 B8 16 00 00 00 EB CA 66 2E 0F 1F 84 00 00 00 00 00 48 8D 54 24 0C 31 C0 BE 30 54 04 80 44 89 E7 E8 ?? ?? ?? ?? 85 C0 74 78 64 83 3B 16 74 42 4C 89 EA 48 89 EE BF 01 00 00 00 E8 ?? ?? ?? ?? 85 C0 78 4E 41 8B 45 18 25 00 F0 00 00 3D 00 20 00 00 0F 84 9A 00 00 00 64 C7 03 19 00 00 00 B8 19 00 00 00 E9 69 FF FF FF 66 0F 1F 84 00 00 00 00 00 49 83 FE 0A 0F 87 BC 00 00 00 64 C7 03 22 00 00 00 B8 22 00 00 00 E9 45 FF FF FF 0F 1F 44 00 00 64 8B 03 E9 38 FF FF FF 0F 1F 84 00 00 00 00 00 8B 7C 24 0C 48 8D 74 24 24 31 C9 BA 0A 00 00 00 C6 44 24 24 00 E8 ?? ?? ?? ?? 48 8D 54 24 25 48 29 C2 48 8D 4A 09 4C 39 F1 77 AF 48 B9 2F 64 65 76 2F 70 74 73 48 8D 7D 09 66 C7 45 08 2F 00 48 89 4D 00 48 89 C6 E8 ?? ?? ?? ?? E9 3E FF FF FF 49 8B 4D 28 48 89 CA 48 89 C8 48 C1 EA 20 48 C1 E8 08 81 E2 00 F0 FF FF 25 FF 0F 00 00 09 D0 83 F8 03 74 17 83 F8 04 0F 84 D6 00 00 00 2D 88 00 00 00 83 F8 07 0F 87 2B FF FF FF 64 44 89 3B 31 C0 E9 9A FE FF FF 4C 89 EA 44 89 E6 BF 01 00 00 00 E8 ?? ?? ?? ?? 85 C0 0F 88 42 FF FF FF 49 8B 45 28 48 89 C1 48 89 C2 48 C1 E9 20 48 C1 EA 08 81 E1 00 F0 FF FF 81 E2 FF 0F 00 00 09 CA 83 FA 02 74 15 83 FA 04 0F 84 A6 00 00 00 83 C2 80 83 FA 07 0F 87 CE FE FF FF 48 89 C2 25 FF 00 00 00 BF ?? ?? ?? ?? 48 C1 EA 0C 81 E2 00 FF FF FF 41 89 D4 41 09 C4 45 89 E6 44 89 64 24 0C 41 C1 EE 04 E8 ?? ?? ?? ?? 44 89 F2 48 39 C2 0F 83 94 FE FF FF 48 B8 2F 64 65 76 2F 74 74 79 41 83 E4 0F C6 45 0A 00 48 89 45 00 0F B6 82 ?? ?? ?? ?? 88 45 08 41 0F B6 84 24 ?? ?? ?? ?? 88 45 09 E9 3B FE FF FF 48 89 C8 81 E1 FF 00 00 00 48 C1 E8 0C 25 00 FF FF FF 09 C8 3D BF 00 00 00 0F 86 44 FE FF FF 3D FF 00 00 00 0F 87 39 FE FF FF E9 09 FF FF FF 48 89 C2 0F B6 C8 48 C1 EA 0C 81 E2 00 FF FF FF 09 CA 83 FA 7F 0F 86 19 FE FF FF 81 FA BF 00 00 00 0F 87 0D FE FF FF E9 3A FF FF FF }
	condition:
		$1
}

rule file_93_1_0 {
	meta:
		name = "__ptsname_r"
		size = 23
		refs = "000b __ptsname_internal"
	strings:
		$1 = { 48 81 EC 98 00 00 00 48 89 E1 E8 ?? ?? ?? ?? 48 81 C4 98 00 00 00 C3 }
	condition:
		$1
}

rule file_93_2_0 {
	meta:
		name = "ptsname"
		size = 40
		refs = "000f __ptsname_r"
	strings:
		$1 = { 48 83 EC 08 BA 1E 00 00 00 BE ?? ?? ?? ?? E8 ?? ?? ?? ?? 31 D2 85 C0 B8 ?? ?? ?? ?? 48 0F 44 D0 48 83 C4 08 48 89 D0 C3 }
	condition:
		$1
}

rule file_94_0_0 {
	meta:
		name = "cbc_crypt"
		size = 378
		refs = "0121 _des_crypt"
	strings:
		$1 = { 4C 89 74 24 F8 48 89 5C 24 D8 49 89 F6 48 89 6C 24 E0 4C 89 64 24 E8 89 D6 4C 89 6C 24 F0 48 83 EC 68 41 0F B6 10 45 0F B6 68 01 45 0F B6 60 02 40 F6 C6 07 41 0F B6 68 03 41 0F B6 58 04 B8 03 00 00 00 45 0F B6 58 05 45 0F B6 50 06 45 0F B6 48 07 C7 44 24 1C 00 00 00 00 88 54 24 20 44 88 6C 24 21 44 88 64 24 22 40 88 6C 24 23 88 5C 24 24 44 88 5C 24 25 44 88 54 24 26 44 88 4C 24 27 74 3E 41 88 10 45 88 68 01 45 88 60 02 41 88 68 03 41 88 58 04 45 88 58 05 45 88 50 06 45 88 48 07 48 8B 5C 24 40 48 8B 6C 24 48 4C 8B 64 24 50 4C 8B 6C 24 58 4C 8B 74 24 60 48 83 C4 68 C3 90 81 FE 00 20 00 00 77 BA 89 C8 48 8D 54 24 10 83 E0 01 89 44 24 18 0F B6 07 88 44 24 10 0F B6 47 01 88 44 24 11 0F B6 47 02 88 44 24 12 0F B6 47 03 88 44 24 13 0F B6 47 04 88 44 24 14 0F B6 47 05 88 44 24 15 0F B6 47 06 88 44 24 16 0F B6 47 07 4C 89 F7 89 4C 24 08 4C 89 04 24 88 44 24 17 E8 ?? ?? ?? ?? 89 C2 8B 4C 24 08 B8 02 00 00 00 85 D2 4C 8B 04 24 75 38 0F B6 54 24 20 44 0F B6 6C 24 21 44 0F B6 64 24 22 0F B6 6C 24 23 0F B6 5C 24 24 44 0F B6 5C 24 25 44 0F B6 54 24 26 44 0F B6 4C 24 27 E9 18 FF FF FF 66 0F 1F 44 00 00 31 C0 83 E1 02 0F 94 C0 EB BE }
	condition:
		$1
}

rule file_94_1_0 {
	meta:
		name = "ecb_crypt"
		size = 162
		refs = "0082 _des_crypt"
	strings:
		$1 = { 48 83 EC 48 F6 C2 07 B8 03 00 00 00 C7 44 24 1C 01 00 00 00 74 0A 48 83 C4 48 C3 0F 1F 44 00 00 81 FA 00 20 00 00 77 EE 89 C8 49 89 F1 89 D6 83 E0 01 48 8D 54 24 10 89 44 24 18 0F B6 07 88 44 24 10 0F B6 47 01 88 44 24 11 0F B6 47 02 88 44 24 12 0F B6 47 03 88 44 24 13 0F B6 47 04 88 44 24 14 0F B6 47 05 88 44 24 15 0F B6 47 06 88 44 24 16 0F B6 47 07 4C 89 CF 89 4C 24 08 88 44 24 17 E8 ?? ?? ?? ?? 89 C2 8B 4C 24 08 B8 02 00 00 00 85 D2 74 81 31 C0 83 E1 02 0F 94 C0 E9 74 FF FF FF }
	condition:
		$1
}

rule file_95_0_0 {
	meta:
		name = "strxfrm"
		size = 16
		refs = "0003 __libc_tsd_LOCALE 000c __strxfrm_l"
	strings:
		$1 = { 48 8B 05 ?? ?? ?? ?? 64 48 8B 08 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1103_0_0 {
	meta:
		name = "__strtod_internal"
		size = 16
		refs = "0003 __libc_tsd_LOCALE 000c ____strtod_l_internal"
	strings:
		$1 = { 48 8B 05 ?? ?? ?? ?? 64 48 8B 08 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_742_0_0 {
	meta:
		name = "__strtof_internal"
		size = 16
		refs = "0003 __libc_tsd_LOCALE 000c ____strtof_l_internal"
	strings:
		$1 = { 48 8B 05 ?? ?? ?? ?? 64 48 8B 08 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_562_0_0 {
	meta:
		name = "__strtold_internal"
		size = 16
		refs = "0003 __libc_tsd_LOCALE 000c ____strtold_l_internal"
	strings:
		$1 = { 48 8B 05 ?? ?? ?? ?? 64 48 8B 08 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1093_0_0 {
	meta:
		name = "__wcstod_internal"
		size = 16
		refs = "0003 __libc_tsd_LOCALE 000c ____wcstod_l_internal"
	strings:
		$1 = { 48 8B 05 ?? ?? ?? ?? 64 48 8B 08 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1027_0_0 {
	meta:
		name = "__wcstof_internal"
		size = 16
		refs = "0003 __libc_tsd_LOCALE 000c ____wcstof_l_internal"
	strings:
		$1 = { 48 8B 05 ?? ?? ?? ?? 64 48 8B 08 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_950_0_0 {
	meta:
		name = "__wcstold_internal"
		size = 16
		refs = "0003 __libc_tsd_LOCALE 000c ____wcstold_l_internal"
	strings:
		$1 = { 48 8B 05 ?? ?? ?? ?? 64 48 8B 08 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_231_0_0 {
	meta:
		name = "wcsxfrm"
		size = 16
		refs = "0003 __libc_tsd_LOCALE 000c __wcsxfrm_l"
	strings:
		$1 = { 48 8B 05 ?? ?? ?? ?? 64 48 8B 08 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_96_0_0 {
	meta:
		name = "endnetgrent_hook"
		size = 54
		refs = "001e __nss_lookup_function"
	strings:
		$1 = { 53 48 89 FB 48 8B 7F 50 48 8D 47 FF 48 83 F8 FD 76 06 5B C3 0F 1F 40 00 BE ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 85 C0 74 05 48 89 DF FF D0 48 C7 43 50 00 00 00 00 5B C3 }
	condition:
		$1
}

rule file_96_1_0 {
	meta:
		name = "setup"
		size = 135
		refs = "004c __nss_netgroup_lookup 0039 __nss_lookup"
	strings:
		$1 = { 80 3D ?? ?? ?? ?? 00 53 48 89 F3 74 33 48 8B 05 ?? ?? ?? ?? 48 C1 C8 11 64 48 33 04 25 30 00 00 00 48 83 F8 FF 74 59 48 89 06 48 89 F9 48 89 DF 5B 31 D2 BE ?? ?? ?? ?? E9 ?? ?? ?? ?? 0F 1F 00 48 89 FA BE ?? ?? ?? ?? 48 89 DF E8 ?? ?? ?? ?? 85 C0 48 C7 C2 FF FF FF FF 75 03 48 8B 13 64 48 33 14 25 30 00 00 00 48 C1 C2 11 48 89 15 ?? ?? ?? ?? C6 05 ?? ?? ?? ?? 01 5B C3 0F 1F 44 00 00 B8 01 00 00 00 5B C3 }
	condition:
		$1
}

rule file_96_2_0 {
	meta:
		name = "__internal_setnetgrent_reuse"
		size = 329
		refs = "0050 _dl_mcount_wrapper_check 0077 __nss_next2 0083 strlen 0090 malloc 00b0 memcpy 00e2 __nss_lookup_function 010b __libc_errno 0145 __assert_fail"
	strings:
		$1 = { 41 57 49 89 D7 41 56 41 55 49 89 FD 48 89 F7 41 54 55 53 48 89 F3 4C 8D 73 50 48 83 EC 18 E8 0D FF FF FF 4C 89 F6 48 89 E7 E8 42 FF FF FF 85 C0 0F 85 F0 00 00 00 66 2E 0F 1F 84 00 00 00 00 00 48 83 7B 20 00 0F 85 E5 00 00 00 48 8B 3C 24 E8 ?? ?? ?? ?? 48 89 DE 4C 89 EF FF 14 24 45 31 C9 31 D2 41 89 C0 48 89 E1 BE ?? ?? ?? ?? 4C 89 F7 89 C5 4C 8B 63 50 E8 ?? ?? ?? ?? 85 C0 74 51 4C 89 EF E8 ?? ?? ?? ?? 48 8D 78 09 4C 8D 70 01 E8 ?? ?? ?? ?? 48 85 C0 49 89 C4 74 6C 48 8B 43 40 49 8D 7C 24 08 4C 89 F2 4C 89 EE 49 89 04 24 E8 ?? ?? ?? ?? 31 C0 83 FD 01 4C 89 63 40 0F 94 C0 48 83 C4 18 5B 5D 41 5C 41 5D 41 5E 41 5F C3 90 83 FD 01 0F 85 67 FF FF FF BE ?? ?? ?? ?? 4C 89 E7 E8 ?? ?? ?? ?? 48 85 C0 48 89 C5 0F 84 4E FF FF FF 48 89 C7 E8 ?? ?? ?? ?? 48 89 DF FF D5 90 E9 3B FF FF FF 0F 1F 00 48 8B 05 ?? ?? ?? ?? 64 8B 00 41 89 07 48 83 C4 18 31 C0 5B 5D 41 5C 41 5D 41 5E 41 5F C3 BD FF FF FF FF E9 4F FF FF FF B9 ?? ?? ?? ?? BA 85 00 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_96_3_0 {
	meta:
		name = "nscd_getnetgrent"
		size = 103
		refs = "0022 __rawmemchr"
	strings:
		$1 = { 53 48 89 FB 48 8B 7F 30 48 8B 43 20 48 03 43 28 48 39 C7 73 4B 48 89 7B 08 C7 03 00 00 00 00 31 F6 E8 ?? ?? ?? ?? 48 8D 78 01 31 F6 48 89 7B 30 48 89 7B 10 E8 ?? ?? ?? ?? 48 8D 78 01 31 F6 48 89 7B 30 48 89 7B 18 E8 ?? ?? ?? ?? 48 83 C0 01 48 89 43 30 B8 01 00 00 00 5B C3 0F 1F 44 00 00 B8 FF FF FF FF 5B C3 }
	condition:
		$1
}

rule file_96_4_0 {
	meta:
		name = "free_memory.isra.0"
		size = 82
		refs = "0020 free"
	strings:
		$1 = { 55 48 89 FD 53 48 89 F3 48 83 EC 08 48 8B 3F 48 85 FF 74 2F 0F 1F 40 00 48 8B 17 48 89 55 00 E8 ?? ?? ?? ?? 48 8B 7D 00 48 85 FF 75 EB 48 8B 3B 48 85 FF 74 16 0F 1F 00 48 8B 07 48 89 03 E8 ?? ?? ?? ?? 48 8B 3B 48 85 FF 75 ED 48 83 C4 08 5B 5D C3 }
	condition:
		$1
}

rule file_96_5_0 {
	meta:
		name = "_L_lock_624"
		size = 31
		refs = "000f __lll_lock_wait_private"
	strings:
		$1 = { 48 8D 3D ?? ?? ?? ?? 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 6F F8 FF FF }
	condition:
		$1
}

rule file_96_6_0 {
	meta:
		name = "_L_unlock_679"
		size = 31
		refs = "000f __lll_unlock_wake_private"
	strings:
		$1 = { 48 8D 3D ?? ?? ?? ?? 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 C8 F8 FF FF }
	condition:
		$1
}

rule file_96_7_0 {
	meta:
		name = "_L_lock_739"
		size = 31
		refs = "000f __lll_lock_wait_private"
	strings:
		$1 = { 48 8D 3D ?? ?? ?? ?? 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 11 F9 FF FF }
	condition:
		$1
}

rule file_96_8_0 {
	meta:
		name = "_L_unlock_748"
		size = 31
		refs = "000f __lll_unlock_wake_private"
	strings:
		$1 = { 48 8D 3D ?? ?? ?? ?? 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 20 F9 FF FF }
	condition:
		$1
}

rule file_96_9_0 {
	meta:
		name = "_L_lock_1137"
		size = 31
		refs = "000f __lll_lock_wait_private"
	strings:
		$1 = { 48 8D 3D ?? ?? ?? ?? 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 7B FB FF FF }
	condition:
		$1
}

rule file_96_10_0 {
	meta:
		name = "_L_unlock_1160"
		size = 31
		refs = "000f __lll_unlock_wake_private"
	strings:
		$1 = { 48 8D 3D ?? ?? ?? ?? 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 AC FB FF FF }
	condition:
		$1
}

rule file_96_11_0 {
	meta:
		name = "internal_setnetgrent"
		size = 74
		refs = "0024 __libc_errno"
	strings:
		$1 = { 48 89 5C 24 F0 48 89 F3 48 89 6C 24 F8 48 89 FD 48 8D 7B 40 48 83 EC 18 48 83 C6 48 E8 7F FF FF FF 48 8B 15 ?? ?? ?? ?? 64 48 03 14 25 00 00 00 00 48 89 DE 48 89 EF 48 8B 5C 24 08 48 8B 6C 24 10 48 83 C4 18 E9 96 FD FF FF }
	condition:
		$1
}

rule file_96_12_0 {
	meta:
		name = "setnetgrent"
		size = 180
		refs = "000d __libc_multiple_threads 0033 __nss_not_use_nscd_netgroup 0050 __nss_database_custom 0060 __nscd_setnetgrent 007f internal_setnetgrent"
	strings:
		$1 = { 53 BE 01 00 00 00 48 89 FB 31 C0 83 3D ?? ?? ?? ?? 00 74 10 F0 0F B1 35 ?? ?? ?? ?? 0F 85 81 07 00 00 EB 0D 0F B1 35 ?? ?? ?? ?? 0F 85 72 07 00 00 8B 05 ?? ?? ?? ?? 83 F8 00 7E 74 83 C0 01 83 F8 64 7E 2C C7 05 ?? ?? ?? ?? 00 00 00 00 80 3D ?? ?? ?? ?? 00 75 1F BE ?? ?? ?? ?? 48 89 DF E8 ?? ?? ?? ?? 85 C0 89 C2 79 1B EB 0A 0F 1F 40 00 89 05 ?? ?? ?? ?? BE ?? ?? ?? ?? 48 89 DF E8 ?? ?? ?? ?? 89 C2 83 3D ?? ?? ?? ?? 00 74 0F F0 FF 0D ?? ?? ?? ?? 0F 85 27 07 00 00 EB 0C FF 0D ?? ?? ?? ?? 0F 85 19 07 00 00 89 D0 5B C3 0F 1F 00 74 9C EB C2 }
	condition:
		$1
}

rule file_96_13_0 {
	meta:
		name = "internal_endnetgrent"
		size = 23
	strings:
		$1 = { 53 48 89 FB E8 F7 FB FF FF 48 8D 73 48 48 8D 7B 40 5B E9 79 FE FF FF }
	condition:
		$1
}

rule file_96_14_0 {
	meta:
		name = "endnetgrent"
		size = 100
		refs = "000d __libc_multiple_threads 0037 internal_endnetgrent"
	strings:
		$1 = { 48 83 EC 08 BE 01 00 00 00 31 C0 83 3D ?? ?? ?? ?? 00 74 10 F0 0F B1 35 ?? ?? ?? ?? 0F 85 DF 06 00 00 EB 0D 0F B1 35 ?? ?? ?? ?? 0F 85 D0 06 00 00 BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 74 0F F0 FF 0D ?? ?? ?? ?? 0F 85 CF 06 00 00 EB 0C FF 0D ?? ?? ?? ?? 0F 85 C1 06 00 00 48 83 C4 08 C3 }
	condition:
		$1
}

rule file_96_15_0 {
	meta:
		name = "internal_getnetgrent_r"
		size = 533
		refs = "004f __nss_lookup_function 006b __libc_errno 0084 _dl_mcount_wrapper_check 00d0 strcmp 0108 strlen 0116 malloc 013c memcpy"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 53 48 83 EC 48 48 89 7C 24 28 48 8B 79 50 48 89 74 24 30 48 89 54 24 38 4C 89 44 24 18 4C 89 4C 24 20 48 85 FF 4C 8B A4 24 80 00 00 00 0F 84 75 01 00 00 48 83 FF FF 48 89 CB 0F 84 B1 01 00 00 BE ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 85 C0 49 89 C5 0F 84 52 01 00 00 64 48 8B 14 25 00 00 00 00 48 8B 05 ?? ?? ?? ?? 48 01 C2 48 89 54 24 10 66 0F 1F 84 00 00 00 00 00 4C 89 EF E8 ?? ?? ?? ?? 48 8B 4C 24 10 48 8B 54 24 20 48 89 DF 48 8B 74 24 18 41 FF D5 83 F8 02 0F 84 AA 00 00 00 83 F8 01 0F 85 02 01 00 00 83 3B 01 0F 85 0A 01 00 00 4C 8B 7B 40 48 8B 6B 08 4D 85 FF 74 1B 0F 1F 00 49 8D 77 08 48 89 EF E8 ?? ?? ?? ?? 85 C0 74 A8 4D 8B 3F 4D 85 FF 75 E8 4C 8B 7B 48 4D 85 FF 4D 89 FE 74 18 49 8D 76 08 48 89 EF E8 ?? ?? ?? ?? 85 C0 74 84 4D 8B 36 4D 85 F6 75 E8 48 89 EF E8 ?? ?? ?? ?? 48 8D 78 09 48 89 44 24 08 E8 ?? ?? ?? ?? 48 85 C0 48 89 C5 48 8B 54 24 08 0F 84 86 00 00 00 4C 89 7D 00 48 8B 73 08 48 8D 7D 08 48 83 C2 01 E8 ?? ?? ?? ?? 48 89 6B 48 E9 37 FF FF FF 0F 1F 80 00 00 00 00 48 8B 7B 48 48 85 FF 75 0B EB 56 0F 1F 44 00 00 85 C0 75 2E 48 8B 07 4C 89 E2 48 89 DE 48 89 43 48 48 8B 43 40 48 89 07 48 89 7B 40 48 83 C7 08 E8 BB FA FF FF 48 8B 7B 48 48 85 FF 75 D2 85 C0 74 1F 48 8B 7B 50 48 85 FF 74 16 BE ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 85 C0 49 89 C5 0F 85 CF FE FF FF 48 83 C4 48 31 C0 5B 5D 41 5C 41 5D 41 5E 41 5F C3 48 8B 43 08 48 8B 54 24 28 48 89 02 48 8B 54 24 30 48 8B 43 10 48 89 02 48 8B 54 24 38 48 8B 43 18 48 89 02 48 83 C4 48 B8 01 00 00 00 5B 5D 41 5C 41 5D 41 5E 41 5F C3 41 BD ?? ?? ?? ?? 64 48 8B 14 25 00 00 00 00 48 8B 05 ?? ?? ?? ?? E9 5A FE FF FF }
	condition:
		$1
}

rule file_96_16_0 {
	meta:
		name = "__getnetgrent_r"
		size = 175
		refs = "0025 __libc_multiple_threads 004c __libc_errno 006f internal_getnetgrent_r"
	strings:
		$1 = { 48 89 5C 24 E8 48 89 6C 24 F0 48 89 FB 4C 89 64 24 F8 48 89 F5 48 83 EC 28 49 89 CC BE 01 00 00 00 31 C0 83 3D ?? ?? ?? ?? 00 74 10 F0 0F B1 35 ?? ?? ?? ?? 0F 85 75 04 00 00 EB 0D 0F B1 35 ?? ?? ?? ?? 0F 85 66 04 00 00 48 8B 05 ?? ?? ?? ?? 64 48 03 04 25 00 00 00 00 4D 89 C1 B9 ?? ?? ?? ?? 4D 89 E0 48 89 EE 48 89 DF 48 89 04 24 E8 ?? ?? ?? ?? 89 C2 83 3D ?? ?? ?? ?? 00 74 0F F0 FF 0D ?? ?? ?? ?? 0F 85 43 04 00 00 EB 0C FF 0D ?? ?? ?? ?? 0F 85 35 04 00 00 89 D0 48 8B 5C 24 10 48 8B 6C 24 18 4C 8B 64 24 20 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_96_17_0 {
	meta:
		name = "innetgr"
		size = 899
		refs = "0016 __nss_not_use_nscd_netgroup 00a2 _dl_mcount_wrapper_check 00cd __nss_lookup_function 0107 __nss_next2 0176 __libc_errno 01c0 __strcasecmp 01e0 strcmp 029e strlen 02af malloc 02d3 memcpy 0326 __nss_database_custom 0344 __nscd_innetgr 037f __assert_fail"
	strings:
		$1 = { 41 57 41 56 41 55 49 89 F5 41 54 55 53 48 81 EC B8 04 00 00 8B 05 ?? ?? ?? ?? 48 89 7C 24 38 48 89 54 24 08 48 89 4C 24 10 83 F8 00 0F 8E 1F 03 00 00 83 C0 01 83 F8 64 89 05 ?? ?? ?? ?? 0F 8F D6 02 00 00 4C 8D 64 24 50 31 C0 B9 0B 00 00 00 4C 89 E7 F3 48 AB 48 8B 44 24 38 48 89 44 24 20 49 8D 44 24 50 48 89 44 24 28 64 48 8B 04 25 00 00 00 00 48 89 44 24 30 48 8B 74 24 28 48 8D 7C 24 40 E8 59 F8 FF FF 85 C0 0F 85 80 00 00 00 90 48 83 7C 24 70 00 0F 85 CE 02 00 00 48 8B 7C 24 40 E8 ?? ?? ?? ?? 4C 89 E6 48 8B 7C 24 20 FF 54 24 40 83 F8 01 89 C3 0F 84 93 00 00 00 31 ED 48 8B BC 24 A0 00 00 00 BE ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 85 C0 49 89 C6 74 0E 48 89 C7 E8 ?? ?? ?? ?? 4C 89 E7 41 FF D6 85 ED 0F 85 FC 01 00 00 48 8B 7C 24 28 48 8D 4C 24 40 45 31 C9 31 D2 41 89 D8 BE ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 81 48 8B 84 24 98 00 00 00 48 85 C0 0F 84 D3 01 00 00 48 8B 10 48 89 94 24 98 00 00 00 48 8B 94 24 90 00 00 00 48 89 10 48 89 84 24 90 00 00 00 48 83 C0 08 48 89 44 24 20 E9 2C FF FF FF 0F 1F 40 00 48 8B BC 24 A0 00 00 00 BE ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 85 C0 48 89 C5 0F 84 4F FF FF FF 4C 8B 74 24 30 4C 03 35 ?? ?? ?? ?? 66 0F 1F 44 00 00 48 89 EF E8 ?? ?? ?? ?? 4C 89 F1 BA 00 04 00 00 48 8D B4 24 B0 00 00 00 4C 89 E7 FF D5 83 F8 01 0F 85 3E 01 00 00 83 7C 24 50 01 74 73 48 8B 7C 24 58 48 85 FF 74 11 4D 85 ED 74 0C 4C 89 EE E8 ?? ?? ?? ?? 85 C0 75 B8 48 8B 7C 24 60 48 85 FF 74 16 48 83 7C 24 08 00 74 0E 48 8B 74 24 08 E8 ?? ?? ?? ?? 85 C0 75 98 48 8B 7C 24 68 48 85 FF 74 1A 48 83 7C 24 10 00 74 12 48 8B 74 24 10 E8 ?? ?? ?? ?? 85 C0 0F 85 74 FF FF FF BD 01 00 00 00 BB 02 00 00 00 E9 A4 FE FF FF 0F 1F 44 00 00 4C 8B BC 24 90 00 00 00 48 8B 5C 24 58 4D 85 FF 74 22 66 0F 1F 44 00 00 49 8D 77 08 48 89 DF E8 ?? ?? ?? ?? 85 C0 0F 84 34 FF FF FF 4D 8B 3F 4D 85 FF 75 E4 48 8B 84 24 98 00 00 00 48 85 C0 48 89 44 24 18 49 89 C7 74 1C 49 8D 77 08 48 89 DF E8 ?? ?? ?? ?? 85 C0 0F 84 03 FF FF FF 4D 8B 3F 4D 85 FF 75 E4 48 8B 7C 24 38 48 89 DE E8 ?? ?? ?? ?? 85 C0 0F 84 E6 FE FF FF 48 89 DF E8 ?? ?? ?? ?? 48 8D 50 01 48 8D 78 09 48 89 14 24 E8 ?? ?? ?? ?? 48 85 C0 49 89 C7 48 8B 14 24 0F 84 9D 00 00 00 48 8B 44 24 18 49 8D 7F 08 48 89 DE 49 89 07 E8 ?? ?? ?? ?? 4C 89 BC 24 98 00 00 00 E9 9C FE FF FF 31 ED E9 26 FF FF FF 31 C0 83 FD 01 0F 94 C0 49 8D 74 24 48 49 8D 7C 24 40 89 04 24 E8 2B F8 FF FF 8B 04 24 48 81 C4 B8 04 00 00 5B 5D 41 5C 41 5D 41 5E 41 5F C3 C7 05 ?? ?? ?? ?? 00 00 00 00 80 3D ?? ?? ?? ?? 00 0F 85 13 FD FF FF 48 8B 4C 24 10 48 8B 54 24 08 4C 89 EE 48 8B 7C 24 38 E8 ?? ?? ?? ?? 85 C0 79 BC E9 F3 FC FF FF 74 D1 E9 EC FC FF FF 0F 1F 84 00 00 00 00 00 BD FF FF FF FF E9 A7 FE FF FF B9 ?? ?? ?? ?? BA A5 01 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_97_0_0 {
	meta:
		name = "__getsgnam_r"
		size = 500
		refs = "0073 __libc_errno 0096 _dl_mcount_wrapper_check 00db __nss_next2 018a __nss_gshadow_lookup2"
	strings:
		$1 = { 41 57 41 56 41 55 49 89 CD 41 54 49 89 D4 55 48 89 FD 53 48 89 F3 48 83 EC 28 80 3D ?? ?? ?? ?? 00 4C 89 44 24 08 0F 84 4C 01 00 00 48 8B 05 ?? ?? ?? ?? 48 C1 C8 11 64 48 33 04 25 30 00 00 00 48 89 44 24 10 48 8B 05 ?? ?? ?? ?? 48 C1 C8 11 64 48 33 04 25 30 00 00 00 48 83 F8 FF 48 89 44 24 18 0F 94 C0 0F B6 C0 85 C0 0F 85 CB 00 00 00 48 8B 05 ?? ?? ?? ?? 49 89 C6 64 4C 03 34 25 00 00 00 00 48 89 04 24 66 0F 1F 84 00 00 00 00 00 48 8B 7C 24 10 E8 ?? ?? ?? ?? 4D 89 F0 4C 89 E9 4C 89 E2 48 89 DE 48 89 EF FF 54 24 10 83 F8 FE 41 89 C7 75 0E 48 8B 14 24 64 83 3A 22 0F 84 8D 00 00 00 48 8D 4C 24 10 48 8D 7C 24 18 45 31 C9 31 D2 45 89 F8 BE ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 AD 41 83 FF 01 48 8B 44 24 08 74 32 48 C7 00 00 00 00 00 0F 86 F2 00 00 00 48 8B 14 24 64 8B 02 83 F8 22 74 61 48 83 C4 28 5B 5D 41 5C 41 5D 41 5E 41 5F C3 66 2E 0F 1F 84 00 00 00 00 00 48 89 18 31 C0 48 8B 14 24 64 89 02 48 83 C4 28 5B 5D 41 5C 41 5D 41 5E 41 5F C3 48 8B 15 ?? ?? ?? ?? 41 BF FF FF FF FF 48 89 14 24 0F 1F 40 00 48 8B 44 24 08 48 8B 14 24 48 C7 00 00 00 00 00 64 8B 02 83 F8 22 75 9F 41 83 FF FE 74 99 B0 16 EB B3 66 0F 1F 44 00 00 48 8D 4C 24 10 48 8D 7C 24 18 31 D2 BE ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 75 3E 48 8B 54 24 10 64 48 33 14 25 30 00 00 00 48 C1 C2 11 48 89 15 ?? ?? ?? ?? 48 8B 54 24 18 64 48 33 14 25 30 00 00 00 48 C1 C2 11 48 89 15 ?? ?? ?? ?? C6 05 ?? ?? ?? ?? 01 E9 98 FE FF FF 48 C7 C2 FF FF FF FF 64 48 33 14 25 30 00 00 00 48 C1 C2 11 48 89 15 ?? ?? ?? ?? EB D7 31 C0 E9 31 FF FF FF }
	condition:
		$1
}

rule file_808_0_0 {
	meta:
		name = "__getaliasbyname_r"
		size = 500
		refs = "0073 __libc_errno 0096 _dl_mcount_wrapper_check 00db __nss_next2 018a __nss_aliases_lookup2"
	strings:
		$1 = { 41 57 41 56 41 55 49 89 CD 41 54 49 89 D4 55 48 89 FD 53 48 89 F3 48 83 EC 28 80 3D ?? ?? ?? ?? 00 4C 89 44 24 08 0F 84 4C 01 00 00 48 8B 05 ?? ?? ?? ?? 48 C1 C8 11 64 48 33 04 25 30 00 00 00 48 89 44 24 10 48 8B 05 ?? ?? ?? ?? 48 C1 C8 11 64 48 33 04 25 30 00 00 00 48 83 F8 FF 48 89 44 24 18 0F 94 C0 0F B6 C0 85 C0 0F 85 CB 00 00 00 48 8B 05 ?? ?? ?? ?? 49 89 C6 64 4C 03 34 25 00 00 00 00 48 89 04 24 66 0F 1F 84 00 00 00 00 00 48 8B 7C 24 10 E8 ?? ?? ?? ?? 4D 89 F0 4C 89 E9 4C 89 E2 48 89 DE 48 89 EF FF 54 24 10 83 F8 FE 41 89 C7 75 0E 48 8B 14 24 64 83 3A 22 0F 84 8D 00 00 00 48 8D 4C 24 10 48 8D 7C 24 18 45 31 C9 31 D2 45 89 F8 BE ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 AD 41 83 FF 01 48 8B 44 24 08 74 32 48 C7 00 00 00 00 00 0F 86 F2 00 00 00 48 8B 14 24 64 8B 02 83 F8 22 74 61 48 83 C4 28 5B 5D 41 5C 41 5D 41 5E 41 5F C3 66 2E 0F 1F 84 00 00 00 00 00 48 89 18 31 C0 48 8B 14 24 64 89 02 48 83 C4 28 5B 5D 41 5C 41 5D 41 5E 41 5F C3 48 8B 15 ?? ?? ?? ?? 41 BF FF FF FF FF 48 89 14 24 0F 1F 40 00 48 8B 44 24 08 48 8B 14 24 48 C7 00 00 00 00 00 64 8B 02 83 F8 22 75 9F 41 83 FF FE 74 99 B0 16 EB B3 66 0F 1F 44 00 00 48 8D 4C 24 10 48 8D 7C 24 18 31 D2 BE ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 75 3E 48 8B 54 24 10 64 48 33 14 25 30 00 00 00 48 C1 C2 11 48 89 15 ?? ?? ?? ?? 48 8B 54 24 18 64 48 33 14 25 30 00 00 00 48 C1 C2 11 48 89 15 ?? ?? ?? ?? C6 05 ?? ?? ?? ?? 01 E9 98 FE FF FF 48 C7 C2 FF FF FF FF 64 48 33 14 25 30 00 00 00 48 C1 C2 11 48 89 15 ?? ?? ?? ?? EB D7 31 C0 E9 31 FF FF FF }
	condition:
		$1
}

rule file_1409_0_0 {
	meta:
		name = "__getprotobyname_r"
		size = 500
		refs = "0073 __libc_errno 0096 _dl_mcount_wrapper_check 00db __nss_next2 018a __nss_protocols_lookup2"
	strings:
		$1 = { 41 57 41 56 41 55 49 89 CD 41 54 49 89 D4 55 48 89 FD 53 48 89 F3 48 83 EC 28 80 3D ?? ?? ?? ?? 00 4C 89 44 24 08 0F 84 4C 01 00 00 48 8B 05 ?? ?? ?? ?? 48 C1 C8 11 64 48 33 04 25 30 00 00 00 48 89 44 24 10 48 8B 05 ?? ?? ?? ?? 48 C1 C8 11 64 48 33 04 25 30 00 00 00 48 83 F8 FF 48 89 44 24 18 0F 94 C0 0F B6 C0 85 C0 0F 85 CB 00 00 00 48 8B 05 ?? ?? ?? ?? 49 89 C6 64 4C 03 34 25 00 00 00 00 48 89 04 24 66 0F 1F 84 00 00 00 00 00 48 8B 7C 24 10 E8 ?? ?? ?? ?? 4D 89 F0 4C 89 E9 4C 89 E2 48 89 DE 48 89 EF FF 54 24 10 83 F8 FE 41 89 C7 75 0E 48 8B 14 24 64 83 3A 22 0F 84 8D 00 00 00 48 8D 4C 24 10 48 8D 7C 24 18 45 31 C9 31 D2 45 89 F8 BE ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 AD 41 83 FF 01 48 8B 44 24 08 74 32 48 C7 00 00 00 00 00 0F 86 F2 00 00 00 48 8B 14 24 64 8B 02 83 F8 22 74 61 48 83 C4 28 5B 5D 41 5C 41 5D 41 5E 41 5F C3 66 2E 0F 1F 84 00 00 00 00 00 48 89 18 31 C0 48 8B 14 24 64 89 02 48 83 C4 28 5B 5D 41 5C 41 5D 41 5E 41 5F C3 48 8B 15 ?? ?? ?? ?? 41 BF FF FF FF FF 48 89 14 24 0F 1F 40 00 48 8B 44 24 08 48 8B 14 24 48 C7 00 00 00 00 00 64 8B 02 83 F8 22 75 9F 41 83 FF FE 74 99 B0 16 EB B3 66 0F 1F 44 00 00 48 8D 4C 24 10 48 8D 7C 24 18 31 D2 BE ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 75 3E 48 8B 54 24 10 64 48 33 14 25 30 00 00 00 48 C1 C2 11 48 89 15 ?? ?? ?? ?? 48 8B 54 24 18 64 48 33 14 25 30 00 00 00 48 C1 C2 11 48 89 15 ?? ?? ?? ?? C6 05 ?? ?? ?? ?? 01 E9 98 FE FF FF 48 C7 C2 FF FF FF FF 64 48 33 14 25 30 00 00 00 48 C1 C2 11 48 89 15 ?? ?? ?? ?? EB D7 31 C0 E9 31 FF FF FF }
	condition:
		$1
}

rule file_376_0_0 {
	meta:
		name = "__getrpcbyname_r"
		size = 500
		refs = "0073 __libc_errno 0096 _dl_mcount_wrapper_check 00db __nss_next2 018a __nss_rpc_lookup2"
	strings:
		$1 = { 41 57 41 56 41 55 49 89 CD 41 54 49 89 D4 55 48 89 FD 53 48 89 F3 48 83 EC 28 80 3D ?? ?? ?? ?? 00 4C 89 44 24 08 0F 84 4C 01 00 00 48 8B 05 ?? ?? ?? ?? 48 C1 C8 11 64 48 33 04 25 30 00 00 00 48 89 44 24 10 48 8B 05 ?? ?? ?? ?? 48 C1 C8 11 64 48 33 04 25 30 00 00 00 48 83 F8 FF 48 89 44 24 18 0F 94 C0 0F B6 C0 85 C0 0F 85 CB 00 00 00 48 8B 05 ?? ?? ?? ?? 49 89 C6 64 4C 03 34 25 00 00 00 00 48 89 04 24 66 0F 1F 84 00 00 00 00 00 48 8B 7C 24 10 E8 ?? ?? ?? ?? 4D 89 F0 4C 89 E9 4C 89 E2 48 89 DE 48 89 EF FF 54 24 10 83 F8 FE 41 89 C7 75 0E 48 8B 14 24 64 83 3A 22 0F 84 8D 00 00 00 48 8D 4C 24 10 48 8D 7C 24 18 45 31 C9 31 D2 45 89 F8 BE ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 AD 41 83 FF 01 48 8B 44 24 08 74 32 48 C7 00 00 00 00 00 0F 86 F2 00 00 00 48 8B 14 24 64 8B 02 83 F8 22 74 61 48 83 C4 28 5B 5D 41 5C 41 5D 41 5E 41 5F C3 66 2E 0F 1F 84 00 00 00 00 00 48 89 18 31 C0 48 8B 14 24 64 89 02 48 83 C4 28 5B 5D 41 5C 41 5D 41 5E 41 5F C3 48 8B 15 ?? ?? ?? ?? 41 BF FF FF FF FF 48 89 14 24 0F 1F 40 00 48 8B 44 24 08 48 8B 14 24 48 C7 00 00 00 00 00 64 8B 02 83 F8 22 75 9F 41 83 FF FE 74 99 B0 16 EB B3 66 0F 1F 44 00 00 48 8D 4C 24 10 48 8D 7C 24 18 31 D2 BE ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 75 3E 48 8B 54 24 10 64 48 33 14 25 30 00 00 00 48 C1 C2 11 48 89 15 ?? ?? ?? ?? 48 8B 54 24 18 64 48 33 14 25 30 00 00 00 48 C1 C2 11 48 89 15 ?? ?? ?? ?? C6 05 ?? ?? ?? ?? 01 E9 98 FE FF FF 48 C7 C2 FF FF FF FF 64 48 33 14 25 30 00 00 00 48 C1 C2 11 48 89 15 ?? ?? ?? ?? EB D7 31 C0 E9 31 FF FF FF }
	condition:
		$1
}

rule file_849_0_0 {
	meta:
		name = "__getspnam_r"
		size = 500
		refs = "0073 __libc_errno 0096 _dl_mcount_wrapper_check 00db __nss_next2 018a __nss_shadow_lookup2"
	strings:
		$1 = { 41 57 41 56 41 55 49 89 CD 41 54 49 89 D4 55 48 89 FD 53 48 89 F3 48 83 EC 28 80 3D ?? ?? ?? ?? 00 4C 89 44 24 08 0F 84 4C 01 00 00 48 8B 05 ?? ?? ?? ?? 48 C1 C8 11 64 48 33 04 25 30 00 00 00 48 89 44 24 10 48 8B 05 ?? ?? ?? ?? 48 C1 C8 11 64 48 33 04 25 30 00 00 00 48 83 F8 FF 48 89 44 24 18 0F 94 C0 0F B6 C0 85 C0 0F 85 CB 00 00 00 48 8B 05 ?? ?? ?? ?? 49 89 C6 64 4C 03 34 25 00 00 00 00 48 89 04 24 66 0F 1F 84 00 00 00 00 00 48 8B 7C 24 10 E8 ?? ?? ?? ?? 4D 89 F0 4C 89 E9 4C 89 E2 48 89 DE 48 89 EF FF 54 24 10 83 F8 FE 41 89 C7 75 0E 48 8B 14 24 64 83 3A 22 0F 84 8D 00 00 00 48 8D 4C 24 10 48 8D 7C 24 18 45 31 C9 31 D2 45 89 F8 BE ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 AD 41 83 FF 01 48 8B 44 24 08 74 32 48 C7 00 00 00 00 00 0F 86 F2 00 00 00 48 8B 14 24 64 8B 02 83 F8 22 74 61 48 83 C4 28 5B 5D 41 5C 41 5D 41 5E 41 5F C3 66 2E 0F 1F 84 00 00 00 00 00 48 89 18 31 C0 48 8B 14 24 64 89 02 48 83 C4 28 5B 5D 41 5C 41 5D 41 5E 41 5F C3 48 8B 15 ?? ?? ?? ?? 41 BF FF FF FF FF 48 89 14 24 0F 1F 40 00 48 8B 44 24 08 48 8B 14 24 48 C7 00 00 00 00 00 64 8B 02 83 F8 22 75 9F 41 83 FF FE 74 99 B0 16 EB B3 66 0F 1F 44 00 00 48 8D 4C 24 10 48 8D 7C 24 18 31 D2 BE ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 75 3E 48 8B 54 24 10 64 48 33 14 25 30 00 00 00 48 C1 C2 11 48 89 15 ?? ?? ?? ?? 48 8B 54 24 18 64 48 33 14 25 30 00 00 00 48 C1 C2 11 48 89 15 ?? ?? ?? ?? C6 05 ?? ?? ?? ?? 01 E9 98 FE FF FF 48 C7 C2 FF FF FF FF 64 48 33 14 25 30 00 00 00 48 C1 C2 11 48 89 15 ?? ?? ?? ?? EB D7 31 C0 E9 31 FF FF FF }
	condition:
		$1
}

rule file_98_0_0 {
	meta:
		name = "__getsockname"
		size = 20
		refs = "000f __syscall_error"
	strings:
		$1 = { B8 33 00 00 00 0F 05 48 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_100_0_0 {
	meta:
		name = "__getlogin_r_chk"
		size = 16
		refs = "000c __chk_fail 0006 getlogin_r"
	strings:
		$1 = { 48 39 D6 77 05 E9 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1441_0_0 {
	meta:
		name = "__getcwd_chk"
		size = 16
		refs = "000c __chk_fail 0006 __getcwd"
	strings:
		$1 = { 48 39 D6 77 05 E9 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_852_0_0 {
	meta:
		name = "__getdomainname_chk"
		size = 16
		refs = "000c __chk_fail 0006 getdomainname"
	strings:
		$1 = { 48 39 D6 77 05 E9 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_847_0_0 {
	meta:
		name = "__gethostname_chk"
		size = 16
		refs = "000c __chk_fail 0006 __gethostname"
	strings:
		$1 = { 48 39 D6 77 05 E9 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_101_0_0 {
	meta:
		name = "semtimedop"
		size = 23
		refs = "0012 __syscall_error"
	strings:
		$1 = { 49 89 CA B8 DC 00 00 00 0F 05 48 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_102_0_0 {
	meta:
		name = "__vswprintf_chk"
		size = 278
		refs = "005e _IO_wstrn_jumps 0066 _IO_no_init 0078 _IO_fwide 00a3 _IO_wstr_init_static 00b6 _IO_vfwprintf 0112 __chk_fail"
	strings:
		$1 = { 48 89 5C 24 D8 48 89 6C 24 E0 4C 89 64 24 E8 4C 89 6C 24 F0 4C 89 74 24 F8 48 81 EC 68 03 00 00 48 39 F1 0F 82 E8 00 00 00 48 85 F6 48 C7 84 24 D8 01 00 00 00 00 00 00 0F 84 CC 00 00 00 48 89 FD 48 8D BC 24 50 01 00 00 41 89 D6 48 89 E1 31 D2 48 89 F3 4D 89 C4 BE 00 80 00 00 41 B8 ?? ?? ?? ?? 4D 89 CD E8 ?? ?? ?? ?? 48 8D BC 24 50 01 00 00 BE 01 00 00 00 E8 ?? ?? ?? ?? 45 85 F6 C7 45 00 00 00 00 00 7E 08 83 8C 24 C4 01 00 00 04 48 8D 53 FF 48 8D BC 24 50 01 00 00 48 89 E9 48 89 EE E8 ?? ?? ?? ?? 48 8D BC 24 50 01 00 00 4C 89 EA 4C 89 E6 E8 ?? ?? ?? ?? 48 8B 94 24 F0 01 00 00 48 8D 8C 24 40 02 00 00 48 39 4A 30 74 3A 48 8B 52 20 C7 02 00 00 00 00 48 8B 9C 24 40 03 00 00 48 8B AC 24 48 03 00 00 4C 8B A4 24 50 03 00 00 4C 8B AC 24 58 03 00 00 4C 8B B4 24 60 03 00 00 48 81 C4 68 03 00 00 C3 B8 FF FF FF FF EB C9 E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_103_0_0 {
	meta:
		name = "__swapoff"
		size = 20
		refs = "000f __syscall_error"
	strings:
		$1 = { B8 A8 00 00 00 0F 05 48 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_105_0_0 {
	meta:
		name = "__rmdir"
		size = 20
		refs = "000f __syscall_error"
	strings:
		$1 = { B8 54 00 00 00 0F 05 48 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_106_0_0 {
	meta:
		name = "read_int"
		size = 98
	strings:
		$1 = { 48 8B 17 41 B9 FF FF FF 7F 0F B6 02 83 E8 30 90 48 83 C2 01 48 89 17 0F B6 0A 83 E9 30 83 F9 09 77 3E 85 C0 78 EA 3D CC CC CC 0C 7F 23 8D 34 80 45 89 C8 B8 FF FF FF FF 41 29 C8 01 F6 01 F1 44 39 C6 0F 4E C1 EB C9 66 0F 1F 84 00 00 00 00 00 B8 FF FF FF FF EB B9 66 0F 1F 84 00 00 00 00 00 F3 C3 }
	condition:
		$1
}

rule file_106_1_0 {
	meta:
		name = "__parse_one_specmb"
		size = 1701
		refs = "00ba __printf_modifier_table 01af __printf_function_table 0239 __strchrnul 04f4 __handle_registered_modifier_mb 05cd __printf_arginfo_table"
	strings:
		$1 = { 41 57 41 56 49 89 F6 41 55 41 54 49 89 CC 55 48 8D 6F 01 53 48 89 D3 48 83 EC 18 C7 42 30 FF FF FF FF 0F B6 43 0D 48 89 6C 24 08 0F B6 52 0C C7 43 10 20 00 00 00 83 E0 F2 83 E2 07 88 43 0D 88 53 0C 0F B6 47 01 0F B6 C8 83 E9 30 83 F9 09 0F 86 03 02 00 00 0F 1F 00 83 E8 20 3C 29 0F 86 95 00 00 00 83 E2 20 74 07 C7 43 10 20 00 00 00 C7 43 2C FF FF FF FF C7 43 04 00 00 00 00 0F B6 45 00 3C 2A 0F 84 07 02 00 00 83 E8 30 45 31 ED 83 F8 09 0F 86 58 02 00 00 C7 43 28 FF FF FF FF C7 03 FF FF FF FF 80 7D 00 2E 0F 84 11 02 00 00 80 63 0C F8 80 63 0D FD 48 8B 05 ?? ?? ?? ?? 66 C7 43 0E 00 00 48 85 C0 0F 85 0F 04 00 00 0F B6 55 00 48 8D 45 01 48 89 44 24 08 83 EA 4C 80 FA 2E 0F 86 AA 00 00 00 48 89 6C 24 08 0F B6 4D 00 E9 B8 00 00 00 0F 1F 40 00 0F B6 C0 FF 24 C5 ?? ?? ?? ?? 66 0F 1F 44 00 00 80 4B 0D 08 0F 1F 40 00 48 83 C5 01 48 89 6C 24 08 0F B6 45 00 84 C0 0F 85 33 FF FF FF E9 39 FF FF FF 66 0F 1F 44 00 00 C7 43 10 30 00 00 00 EB D7 0F 1F 80 00 00 00 00 83 CA 20 88 53 0C EB C8 0F 1F 84 00 00 00 00 00 83 CA 40 88 53 0C EB B8 0F 1F 84 00 00 00 00 00 83 CA 80 88 53 0C EB A8 0F 1F 84 00 00 00 00 00 83 CA 08 88 53 0C EB 98 0F 1F 84 00 00 00 00 00 83 CA 10 88 53 0C EB 88 0F 1F 84 00 00 00 00 00 0F B6 D2 FF 24 D5 ?? ?? ?? ?? 66 0F 1F 44 00 00 80 4B 0C 04 48 8D 45 02 0F B6 4D 01 48 83 3D ?? ?? ?? ?? 00 0F B6 D1 89 53 08 48 89 44 24 08 C7 43 40 FF FF FF FF 0F 85 FE 03 00 00 8B 43 08 48 C7 43 38 01 00 00 00 83 F8 64 0F 84 AF 03 00 00 0F 8F 41 04 00 00 83 F8 47 0F 8F 18 04 00 00 83 F8 45 0F 8D 6D 03 00 00 83 F8 41 0F 84 64 03 00 00 83 F8 43 0F 84 4F 03 00 00 48 C7 43 38 00 00 00 00 66 0F 1F 44 00 00 83 7B 30 FF 0F 84 1E 03 00 00 85 C0 0F 84 F6 02 00 00 48 8B 7C 24 08 BE 25 00 00 00 48 89 7B 18 E8 ?? ?? ?? ?? 48 89 43 20 48 83 C4 18 4C 89 E8 5B 5D 41 5C 41 5D 41 5E 41 5F C3 0F 1F 44 00 00 49 89 FD 48 8D 7C 24 08 E8 2B FD FF FF 85 C0 74 0E 48 8B 54 24 08 80 3A 24 0F 84 B9 01 00 00 48 89 6C 24 08 0F B6 53 0C 41 0F B6 45 01 E9 CE FD FF FF 66 0F 1F 44 00 00 4C 8D 6D 01 4C 89 6C 24 08 0F B6 45 01 83 E8 30 83 F8 09 76 6B 44 89 73 2C 4C 89 6C 24 08 4C 89 ED 49 83 C6 01 41 BD 01 00 00 00 E9 D8 FD FF FF 48 8D 55 01 48 89 54 24 08 0F B6 45 01 3C 2A 0F 84 2B 01 00 00 83 E8 30 83 F8 09 0F 86 DF 00 00 00 C7 03 00 00 00 00 48 89 D5 E9 C0 FD FF FF 90 48 8D 7C 24 08 E8 96 FC FF FF 83 F8 FF 74 03 89 43 04 48 8B 6C 24 08 E9 8C FD FF FF 0F 1F 40 00 48 8D 7C 24 08 E8 76 FC FF FF 85 C0 0F 84 BE 00 00 00 48 8B 4C 24 08 80 39 24 0F 85 B0 00 00 00 83 F8 FF 0F 84 96 01 00 00 49 8B 34 24 8D 50 FF 89 C0 89 53 2C 48 39 F0 48 0F 42 C6 49 89 04 24 48 83 C1 01 48 89 4C 24 08 E9 85 00 00 00 66 90 0F B6 53 0C 48 8D 45 02 83 CA 04 88 53 0C 0F B6 4D 01 80 F9 6C 0F 85 31 FE FF FF 48 89 44 24 08 EB 2A 66 0F 1F 44 00 00 80 7D 01 68 0F 84 D0 00 00 00 80 4B 0C 02 48 8D 45 02 0F B6 4D 01 E9 09 FE FF FF 0F 1F 44 00 00 0F B6 53 0C 83 CA 01 48 83 C0 01 88 53 0C 0F B6 48 FF E9 ED FD FF FF 90 48 8D 7C 24 08 E8 C6 FB FF FF 83 F8 FF 74 02 89 03 48 8B 6C 24 08 E9 D4 FC FF FF 0F 1F 44 00 00 8B 53 2C 85 D2 0F 88 BA FE FF FF 48 8B 6C 24 08 45 31 ED E9 A0 FC FF FF 0F 1F 84 00 00 00 00 00 4C 8D 7D 02 4C 89 7C 24 08 0F B6 45 02 83 E8 30 83 F8 09 76 67 44 89 73 28 49 83 C5 01 49 83 C6 01 4C 89 7C 24 08 4C 89 FD E9 81 FC FF FF 66 90 48 8D 6A 01 83 F8 FF 48 89 6C 24 08 74 17 8D 48 FF 89 C0 89 4B 30 49 8B 0C 24 48 39 C8 48 0F 42 C1 49 89 04 24 0F B6 42 01 0F B6 53 0C E9 F6 FB FF FF 48 8D 45 02 80 4B 0D 02 48 89 44 24 08 48 8D 45 03 0F B6 4D 02 E9 30 FD FF FF 48 8D 7C 24 08 E8 0A FB FF FF 85 C0 74 0A 48 8B 4C 24 08 80 39 24 74 14 8B 53 28 85 D2 0F 89 32 FF FF FF E9 71 FF FF FF 0F 1F 40 00 83 F8 FF 74 2A 49 8B 34 24 8D 50 FF 89 C0 89 53 28 48 39 F0 48 0F 42 C6 49 89 04 24 48 83 C1 01 48 89 4C 24 08 EB C8 8B 53 2C E9 79 FE FF FF 8B 53 28 EB E8 0F B6 55 00 48 83 3C D0 00 0F 84 E2 FB FF FF 48 8D 7C 24 08 48 89 DE E8 ?? ?? ?? ?? 85 C0 74 0A 48 8B 6C 24 08 E9 C7 FB FF FF 48 8B 44 24 08 0F B6 08 48 83 C0 01 E9 95 FC FF FF 66 0F 1F 84 00 00 00 00 00 48 8B 44 24 08 48 83 E8 01 48 89 43 20 48 89 43 18 E9 0B FD FF FF 66 2E 0F 1F 84 00 00 00 00 00 48 8B 53 38 48 85 D2 0F 84 D5 FC FF FF 44 89 73 30 49 01 D5 E9 C9 FC FF FF C7 43 34 02 00 00 00 E9 B3 FC FF FF 0F B6 53 0C 83 E2 01 80 FA 01 19 D2 30 D2 81 C2 07 01 00 00 89 53 34 E9 97 FC FF FF 83 F8 75 74 09 83 F8 78 0F 85 7B FC FF FF 0F B6 53 0C F6 C2 04 74 10 C7 43 34 00 02 00 00 E9 74 FC FF FF 0F 1F 40 00 83 E2 02 74 0C C7 43 34 00 04 00 00 E9 5F FC FF FF 31 D2 F6 43 0D 02 0F 95 C2 89 53 34 E9 4E FC FF FF 48 8B 05 ?? ?? ?? ?? 48 8B 04 C8 48 85 C0 0F 84 EE FB FF FF 48 8D 53 34 48 8D 4B 40 BE 01 00 00 00 48 89 DF FF D0 48 63 D0 85 C0 48 89 53 38 0F 88 CD FB FF FF 8B 43 08 E9 11 FC FF FF 83 F8 58 74 83 0F 1F 40 00 7F 49 83 F8 53 0F 85 EF FB FF FF C7 43 34 04 00 00 00 E9 F1 FB FF FF 83 F8 6F 0F 84 5F FF FF FF 7F 47 83 F8 67 0F 8E 2A FF FF FF 83 F8 69 66 90 0F 84 49 FF FF FF 83 F8 6E 0F 85 BB FB FF FF C7 43 34 00 08 00 00 E9 BD FB FF FF 83 F8 61 0F 84 01 FF FF FF 83 F8 63 0F 85 9D FB FF FF C7 43 34 01 00 00 00 E9 9F FB FF FF 83 F8 73 74 1B 0F 8F FD FE FF FF 83 F8 70 0F 85 7D FB FF FF C7 43 34 05 00 00 00 E9 7F FB FF FF C7 43 34 03 00 00 00 E9 73 FB FF FF }
	condition:
		$1
}

rule file_107_0_0 {
	meta:
		name = "__flock"
		size = 20
		refs = "000f __syscall_error"
	strings:
		$1 = { B8 49 00 00 00 0F 05 48 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_108_0_0 {
	meta:
		name = "_L_lock_49"
		size = 27
		refs = "000b __lll_lock_wait_private"
	strings:
		$1 = { 48 8D 3A 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 46 FE FF FF }
	condition:
		$1
}

rule file_108_1_0 {
	meta:
		name = "_L_unlock_132"
		size = 27
		refs = "000b __lll_unlock_wake_private"
	strings:
		$1 = { 48 8D 3A 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 06 FF FF FF }
	condition:
		$1
}

rule file_108_2_0 {
	meta:
		name = "_L_unlock_207"
		size = 27
		refs = "000b __lll_unlock_wake_private"
	strings:
		$1 = { 48 8D 3A 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 77 FF FF FF }
	condition:
		$1
}

rule file_829_0_0 {
	meta:
		name = "_L_lock_27"
		size = 27
		refs = "000b __lll_lock_wait_private"
	strings:
		$1 = { 48 8D 3A 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 77 FF FF FF }
	condition:
		$1
}

rule file_108_3_0 {
	meta:
		name = "putgrent"
		size = 513
		refs = "0046 __libc_multiple_threads 009f fprintf 01df __libc_errno 01f9 __overflow"
	strings:
		$1 = { 48 85 FF 0F 84 D3 01 00 00 48 85 F6 0F 84 CA 01 00 00 41 56 49 89 FE 41 55 41 54 49 89 F4 55 53 8B 06 25 00 80 00 00 75 49 48 8B 96 88 00 00 00 64 4C 8B 04 25 10 00 00 00 4C 3B 42 08 74 2F BE 01 00 00 00 83 3D ?? ?? ?? ?? 00 74 0C F0 0F B1 32 0F 85 AA 01 00 00 EB 09 0F B1 32 0F 85 9F 01 00 00 49 8B 94 24 88 00 00 00 4C 89 42 08 83 42 04 01 49 8B 16 49 8B 4E 08 0F B6 02 3C 2D 74 08 3C 2B 0F 85 C8 00 00 00 48 85 C9 B8 ?? ?? ?? ?? BE ?? ?? ?? ?? 48 0F 44 C8 4C 89 E7 31 C0 E8 ?? ?? ?? ?? 85 C0 78 5A 49 8B 46 18 48 85 C0 0F 84 C4 00 00 00 48 8B 10 48 85 D2 0F 84 B8 00 00 00 BD 08 00 00 00 31 DB 41 BD ?? ?? ?? ?? EB 19 90 49 8B 46 18 83 C3 01 48 8B 14 28 48 83 C5 08 48 85 D2 0F 84 90 00 00 00 85 DB BE ?? ?? ?? ?? 4C 89 E7 49 0F 45 F5 31 C0 E8 ?? ?? ?? ?? 85 C0 79 CF 41 F7 04 24 00 80 00 00 75 32 49 8B 94 24 88 00 00 00 83 6A 04 01 75 24 48 C7 42 08 00 00 00 00 83 3D ?? ?? ?? ?? 00 74 0B F0 FF 0A 0F 85 E9 00 00 00 EB 08 FF 0A 0F 85 DF 00 00 00 5B 5D 41 5C 41 5D B8 FF FF FF FF 41 5E C3 0F 1F 44 00 00 45 8B 46 10 48 85 C9 B8 ?? ?? ?? ?? 48 0F 44 C8 BE ?? ?? ?? ?? 4C 89 E7 31 C0 E8 ?? ?? ?? ?? E9 2F FF FF FF 0F 1F 40 00 49 8B 44 24 28 49 3B 44 24 30 73 6C C6 00 0A 48 83 C0 01 BE 0A 00 00 00 49 89 44 24 28 41 F7 04 24 00 80 00 00 75 2A 49 8B 94 24 88 00 00 00 83 6A 04 01 75 1C 48 C7 42 08 00 00 00 00 83 3D ?? ?? ?? ?? 00 74 07 F0 FF 0A 75 74 EB 04 FF 0A 75 6E 85 F6 0F 88 6C FF FF FF 5B 5D 41 5C 41 5D 31 C0 41 5E C3 48 8B 05 ?? ?? ?? ?? 64 C7 00 16 00 00 00 B8 FF FF FF FF C3 BE 0A 00 00 00 4C 89 E7 E8 ?? ?? ?? ?? 89 C6 EB 94 }
	condition:
		$1
}

rule file_109_0_0 {
	meta:
		name = "svc_exit"
		size = 37
		refs = "0002 __rpc_thread_svc_pollfd 000d free 0019 __rpc_thread_svc_max_pollfd"
	strings:
		$1 = { 53 E8 ?? ?? ?? ?? 48 8B 38 48 89 C3 E8 ?? ?? ?? ?? 48 C7 03 00 00 00 00 E8 ?? ?? ?? ?? C7 00 00 00 00 00 5B C3 }
	condition:
		$1
}

rule file_109_1_0 {
	meta:
		name = "svc_run"
		size = 313
		refs = "000e __rpc_thread_svc_max_pollfd 0022 __rpc_thread_svc_pollfd 0048 realloc 00a4 __poll 00bb svc_getreq_poll 00d3 __libc_errno 00e2 _libc_intl_domainname 00f1 __dcgettext 00f9 perror 0109 free"
	strings:
		$1 = { 41 56 41 55 41 54 45 31 E4 55 53 31 DB E8 ?? ?? ?? ?? 49 89 C5 0F 1F 00 45 8B 75 00 45 85 F6 75 0F E8 ?? ?? ?? ?? 48 83 38 00 0F 84 CD 00 00 00 45 39 F4 0F 84 8F 00 00 00 49 63 EE 48 89 DF 48 8D 34 ED 00 00 00 00 E8 ?? ?? ?? ?? 48 85 C0 0F 84 B8 00 00 00 45 89 F4 48 89 C3 45 85 F6 7E 38 E8 ?? ?? ?? ?? 48 8B 10 41 83 EE 01 48 89 D9 4A 8D 74 F2 08 0F 1F 40 00 8B 02 48 83 C2 08 48 83 C1 08 89 41 F8 0F B7 42 FC 66 C7 41 FE 00 00 66 89 41 FC 48 39 F2 75 E0 BA FF FF FF FF 48 89 EE 48 89 DF E8 ?? ?? ?? ?? 83 F8 FF 74 23 85 C0 0F 84 63 FF FF FF 89 C6 48 89 DF E8 ?? ?? ?? ?? E9 54 FF FF FF 0F 1F 40 00 49 63 EC EB 8E 0F 1F 00 48 8B 05 ?? ?? ?? ?? 64 83 38 04 0F 84 37 FF FF FF BF ?? ?? ?? ?? BA 05 00 00 00 BE ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 C7 E8 ?? ?? ?? ?? 48 89 DF 5B 5D 41 5C 41 5D 41 5E E9 ?? ?? ?? ?? BA 05 00 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 C7 E8 ?? ?? ?? ?? 48 89 DF 5B 5D 41 5C 41 5D 41 5E E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_110_0_0 {
	meta:
		name = "getchar_unlocked"
		size = 34
		refs = "0003 _IO_stdin 001e __uflow"
	strings:
		$1 = { 48 8B 3D ?? ?? ?? ?? 48 8B 57 08 48 3B 57 10 73 0C 0F B6 02 48 83 C2 01 48 89 57 08 C3 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_111_0_0 {
	meta:
		name = "inotify_init"
		size = 20
		refs = "000f __syscall_error"
	strings:
		$1 = { B8 FD 00 00 00 0F 05 48 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_112_0_0 {
	meta:
		name = "__mpn_mul"
		size = 944
		refs = "004e __mpn_mul_1 009b __mpn_addmul_1 00d4 __mpn_add_n 010e __mpn_impn_mul_n 01e8 __mpn_mul"
	strings:
		$1 = { 55 48 89 E5 41 57 41 56 41 55 41 54 49 89 D4 53 4C 89 C3 48 83 EC 78 49 83 F8 1F 48 89 7D C0 48 89 75 C8 48 89 4D B8 0F 8F B3 00 00 00 31 C0 4D 85 C0 0F 84 19 01 00 00 48 8B 09 48 83 F9 01 0F 86 1B 01 00 00 48 8B 75 C8 48 8B 7D C0 E8 ?? ?? ?? ?? 48 8B 55 C0 4E 8D 34 E5 00 00 00 00 49 89 D5 4A 89 04 E2 49 83 C5 08 48 83 FB 01 0F 8E DE 00 00 00 4C 8B 7D B8 4C 89 E0 48 8D 1C DA 49 83 C7 08 4D 89 FC 49 89 C7 EB 2B 66 0F 1F 44 00 00 48 8B 75 C8 4C 89 FA 4C 89 EF E8 ?? ?? ?? ?? 4B 89 44 35 00 49 83 C5 08 49 83 C4 08 49 39 DD 0F 84 9C 00 00 00 49 8B 0C 24 48 83 F9 01 77 D1 B8 00 00 00 00 75 D9 48 8B 55 C8 4C 89 F9 4C 89 EE 4C 89 EF E8 ?? ?? ?? ?? EB C5 66 0F 1F 44 00 00 4D 89 C6 48 8B 75 C8 48 8B 55 B8 49 C1 E6 04 48 8B 7D C0 49 83 C6 10 4C 29 F4 48 8D 4C 24 0F 48 83 E1 F0 48 89 4D A8 49 89 C8 48 89 D9 E8 ?? ?? ?? ?? 4C 8B 4D C0 48 8B 75 C8 4C 8D 14 DD 00 00 00 00 4D 89 E3 49 29 DB 4C 01 D6 4D 01 D1 4C 39 DB 48 89 75 B0 0F 8E 5D 01 00 00 4D 85 DB 0F 85 7C 00 00 00 48 8B 55 C0 49 8D 44 1C FF 48 8B 04 C2 48 8D 65 D8 5B 41 5C 41 5D 41 5E 41 5F 5D C3 74 2E 4D 85 E4 48 89 F8 48 8D 14 D7 7E 12 66 90 48 C7 00 00 00 00 00 48 83 C0 08 48 39 D0 75 F0 31 C0 E9 CB FE FF FF 66 0F 1F 84 00 00 00 00 00 48 85 D2 7E EB 48 8B 4D C0 48 8B 75 C8 31 C0 90 48 8B 14 C6 48 89 14 C1 48 83 C0 01 4C 39 E0 75 EF 31 C0 E9 9A FE FF FF 0F 1F 84 00 00 00 00 00 48 8B 4D B0 48 8B 75 B8 4D 89 D8 48 8B 7D A8 48 89 DA 4C 89 95 68 FF FF FF 4C 89 9D 70 FF FF FF 4C 89 8D 78 FF FF FF E8 ?? ?? ?? ?? 4C 8B 8D 78 FF FF FF 48 8B 55 A8 48 89 D9 4C 89 CE 4C 89 CF E8 ?? ?? ?? ?? 4C 8B 95 68 FF FF FF 48 8B 55 A8 4C 8B 8D 78 FF FF FF 4C 8B 9D 70 FF FF FF 4C 01 D2 48 8B 0A 4D 01 CA 48 83 C2 08 49 83 C2 08 48 01 C8 49 89 42 F8 48 39 C1 77 35 49 39 D2 0F 84 00 FF FF FF 49 83 EB 01 4D 85 DB 0F 8E F3 FE FF FF 31 C0 0F 1F 44 00 00 48 8B 0C C2 49 89 0C C2 48 83 C0 01 4C 39 D8 75 EF E9 D6 FE FF FF 66 90 49 83 EB 01 0F 84 CA FE FF FF 48 8B 02 49 83 C2 08 48 83 C2 08 48 83 C0 01 49 89 42 F8 48 85 C0 74 DE EB A7 0F 1F 40 00 4C 29 F4 48 89 DA 4D 89 DE 48 8D 44 24 0F 49 29 DE 48 F7 DA 4F 8D 2C 11 4C 89 65 80 48 89 55 90 48 83 E0 F0 4D 89 F4 49 89 DE 48 89 45 A0 4C 01 D0 4C 89 D3 48 89 45 98 48 83 C0 08 48 89 45 88 0F 1F 84 00 00 00 00 00 4C 8B 45 A8 48 8B 55 B8 4C 89 F1 48 8B 75 B0 48 8B 7D A0 4D 89 EF 49 29 DF E8 ?? ?? ?? ?? 48 8B 55 A0 4C 89 F1 4C 89 FE 4C 89 FF E8 ?? ?? ?? ?? 48 8B 75 98 4C 89 EF 49 8D 55 08 48 8B 0E 48 01 C8 48 39 C1 49 89 45 00 48 8B 4D 88 4C 89 F0 77 77 48 39 CA 74 23 4C 8D 40 FF 4D 85 C0 7E 1A 31 C0 0F 1F 80 00 00 00 00 48 8B 34 C1 48 89 34 C2 48 83 C0 01 4C 39 C0 75 EF 4C 89 E2 4C 03 65 90 48 01 5D B0 49 01 DD 4B 8D 04 26 49 39 C6 0F 8E 6C FF FF FF 49 89 DA 49 89 F9 49 89 D3 4C 8B 65 80 4C 89 F3 E9 B2 FD FF FF 0F 1F 80 00 00 00 00 48 8B 31 48 83 C2 08 48 83 C1 08 48 83 C6 01 48 89 72 F8 48 85 F6 75 89 48 83 E8 01 75 E2 EB A9 }
	condition:
		$1
}

rule file_113_0_0 {
	meta:
		name = "__dup"
		size = 20
		refs = "000f __syscall_error"
	strings:
		$1 = { B8 20 00 00 00 0F 05 48 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_114_0_0 {
	meta:
		name = "_L_lock_47"
		size = 27
		refs = "000b __lll_lock_wait_private"
	strings:
		$1 = { 48 8D 3A 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 92 FE FF FF }
	condition:
		$1
}

rule file_114_1_0 {
	meta:
		name = "_L_unlock_151"
		size = 27
		refs = "000b __lll_unlock_wake_private"
	strings:
		$1 = { 48 8D 3A 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 43 FF FF FF }
	condition:
		$1
}

rule file_268_0_0 {
	meta:
		name = "_L_lock_31"
		size = 27
		refs = "000b __lll_lock_wait_private"
	strings:
		$1 = { 48 8D 3A 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 43 FF FF FF }
	condition:
		$1
}

rule file_114_2_0 {
	meta:
		name = "_L_unlock_259"
		size = 24
		refs = "000b __lll_unlock_wake_private"
	strings:
		$1 = { 48 8D 3A 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 EB A5 }
	condition:
		$1
}

rule file_114_3_0 {
	meta:
		name = "__gets_chk"
		size = 458
		refs = "0024 _IO_stdin 005b __libc_multiple_threads 00e0 _IO_getline 0171 __uflow 0185 __chk_fail 01c1 _Unwind_Resume"
	strings:
		$1 = { 48 89 5C 24 E0 48 89 6C 24 E8 4C 89 64 24 F0 4C 89 6C 24 F8 48 83 EC 28 48 85 F6 0F 84 A4 01 00 00 48 8B 1D ?? ?? ?? ?? 48 89 FD 49 89 F4 8B 03 48 89 DF 25 00 80 00 00 75 53 48 8B 93 88 00 00 00 64 4C 8B 04 25 10 00 00 00 4C 3B 42 08 0F 84 14 01 00 00 BE 01 00 00 00 83 3D ?? ?? ?? ?? 00 74 0C F0 0F B1 32 0F 85 5E 01 00 00 EB 09 0F B1 32 0F 85 53 01 00 00 48 8B 93 88 00 00 00 48 8B 3D ?? ?? ?? ?? 4C 89 42 08 83 42 04 01 48 8B 57 08 48 3B 57 10 0F 83 D5 00 00 00 0F B6 02 48 83 C2 01 48 89 57 08 83 F8 0A 0F 84 B1 00 00 00 48 8B 15 ?? ?? ?? ?? 48 8D 75 01 45 31 C0 8B 0A 41 89 CD 83 E1 DF 89 0A 88 45 00 49 8D 54 24 FF 48 8B 3D ?? ?? ?? ?? B9 0A 00 00 00 41 83 E5 20 E8 ?? ?? ?? ?? 48 8B 15 ?? ?? ?? ?? 48 83 C0 01 8B 0A F6 C1 20 0F 85 86 00 00 00 41 09 CD 44 89 2A 4C 39 E0 73 7F C6 44 05 00 00 F7 03 00 80 00 00 75 31 48 8B 93 88 00 00 00 83 6A 04 01 75 24 48 C7 42 08 00 00 00 00 83 3D ?? ?? ?? ?? 00 74 0B F0 FF 0A 0F 85 AC 00 00 00 EB 08 FF 0A 0F 85 A2 00 00 00 48 89 E8 48 8B 5C 24 08 48 8B 6C 24 10 4C 8B 64 24 18 4C 8B 6C 24 20 48 83 C4 28 C3 90 31 C0 EB 9C 0F 1F 40 00 48 89 DF E9 19 FF FF FF E8 ?? ?? ?? ?? 83 F8 FF 0F 85 28 FF FF FF 66 90 31 ED EB 86 E8 ?? ?? ?? ?? F7 03 00 80 00 00 48 89 C6 75 29 48 8B 93 88 00 00 00 83 6A 04 01 75 1C 48 C7 42 08 00 00 00 00 83 3D ?? ?? ?? ?? 00 74 07 F0 FF 0A 75 49 EB 04 FF 0A 75 43 48 89 F7 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_116_0_0 {
	meta:
		name = "__libc_fork"
		size = 708
		refs = "0010 __fork_handlers 0072 _IO_list_lock 00e0 __fork_generation_pointer 0112 __nptl_set_robust 0119 _dl_cpuclock_offset 012b _IO_iter_begin 013c _IO_iter_file 0160 _IO_iter_next 0168 _IO_iter_end 0172 _IO_list_resetlock 017c _dl_load_lock 01e3 __fork_lock 01fc __libc_errno 0227 _IO_list_unlock 02a7 __assert_fail"
	strings:
		$1 = { 55 48 89 E5 41 55 41 54 53 48 83 EC 08 48 8B 1D ?? ?? ?? ?? 48 85 DB 74 58 8B 43 28 85 C0 74 ED 48 8B 15 ?? ?? ?? ?? 8D 48 01 F0 0F B1 4A 28 75 DC 45 31 E4 EB 11 66 2E 0F 1F 84 00 00 00 00 00 F0 FF 43 28 49 89 C4 48 8B 43 08 48 85 C0 74 02 FF D0 48 83 EC 20 48 8D 44 24 0F 48 83 E0 F0 48 89 18 48 8B 1B 4C 89 60 08 48 85 DB 75 D2 48 89 C3 E8 ?? ?? ?? ?? 64 44 8B 24 25 D0 02 00 00 64 44 8B 04 25 D4 02 00 00 44 89 C0 F7 D8 64 89 04 25 D4 02 00 00 64 4C 8B 0C 25 10 00 00 00 31 D2 4D 8D 91 D0 02 00 00 31 F6 BF 11 00 20 01 B8 38 00 00 00 0F 05 48 3D 00 F0 FF FF 0F 87 38 01 00 00 85 C0 41 89 C5 0F 85 44 01 00 00 64 8B 04 25 D0 02 00 00 41 39 C4 0F 84 CE 01 00 00 48 8B 05 ?? ?? ?? ?? 48 85 C0 74 04 48 83 00 04 64 8B 04 25 D0 02 00 00 64 89 04 25 D4 02 00 00 0F 31 48 C1 E2 20 89 C0 48 09 C2 64 48 89 14 25 20 06 00 00 B8 ?? ?? ?? ?? 48 89 15 ?? ?? ?? ?? 48 85 C0 74 08 4C 89 CF E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 49 89 C4 EB 33 0F 1F 40 00 4C 89 E7 E8 ?? ?? ?? ?? 48 8B 90 88 00 00 00 4C 89 E7 C7 02 00 00 00 00 C7 42 04 00 00 00 00 48 C7 42 08 00 00 00 00 E8 ?? ?? ?? ?? 49 89 C4 E8 ?? ?? ?? ?? 49 39 C4 75 C7 E8 ?? ?? ?? ?? 48 85 DB 48 C7 05 ?? ?? ?? ?? 00 00 00 00 48 C7 05 ?? ?? ?? ?? 00 00 00 00 48 C7 05 ?? ?? ?? ?? 00 00 00 00 48 C7 05 ?? ?? ?? ?? 00 00 00 00 48 C7 05 ?? ?? ?? ?? 00 00 00 00 C7 05 ?? ?? ?? ?? 01 00 00 00 74 25 0F 1F 40 00 48 8B 03 48 8B 50 18 48 85 D2 74 05 FF D2 48 8B 03 48 8B 5B 08 C7 40 28 01 00 00 00 48 85 DB 75 DF C7 05 ?? ?? ?? ?? 00 00 00 00 48 8D 65 E8 44 89 E8 5B 41 5C 41 5D 5D C3 48 8B 15 ?? ?? ?? ?? F7 D8 41 83 CD FF 64 89 02 0F 1F 80 00 00 00 00 64 8B 04 25 D0 02 00 00 41 39 C4 75 75 64 44 89 04 25 D4 02 00 00 E8 ?? ?? ?? ?? 48 85 DB 74 BB 41 BC CA 00 00 00 66 2E 0F 1F 84 00 00 00 00 00 48 8B 0B 48 8B 41 10 48 85 C0 74 05 FF D0 48 8B 0B F0 FF 49 28 0F 94 C0 84 C0 74 1F 8B 41 2C 85 C0 74 18 BA 01 00 00 00 64 8B 34 25 48 00 00 00 8B 79 28 83 CE 01 44 89 E0 0F 05 48 8B 5B 08 48 85 DB 75 BC 48 8D 65 E8 44 89 E8 5B 41 5C 41 5D 5D C3 B9 ?? ?? ?? ?? BA D3 00 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? B9 ?? ?? ?? ?? BA 8D 00 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_117_0_0 {
	meta:
		name = "_IO_vasprintf"
		size = 395
		refs = "002f malloc 005e _IO_no_init 0078 _IO_str_jumps 007d _IO_str_init_static_internal 00a2 free 00a7 _IO_vfprintf 00e0 realloc 0148 memcpy"
	strings:
		$1 = { 48 89 6C 24 E0 4C 89 64 24 E8 49 89 FC 4C 89 6C 24 F0 48 89 5C 24 D8 BF 64 00 00 00 4C 89 74 24 F8 48 81 EC 18 01 00 00 48 89 F5 49 89 D5 E8 ?? ?? ?? ?? 48 85 C0 0F 84 44 01 00 00 48 89 C3 45 31 C0 31 C9 BA FF FF FF FF BE 00 80 00 00 48 89 E7 48 C7 84 24 88 00 00 00 00 00 00 00 E8 ?? ?? ?? ?? 48 89 D9 BA 64 00 00 00 48 89 DE 48 89 E7 48 C7 84 24 D8 00 00 00 ?? ?? ?? ?? E8 ?? ?? ?? ?? 4C 89 EA 48 89 EE 48 89 E7 83 24 24 FE 48 C7 84 24 E0 00 00 00 ?? ?? ?? ?? 48 C7 84 24 E8 00 00 00 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 41 89 C5 0F 88 BA 00 00 00 48 8B 44 24 20 48 8B 5C 24 28 48 8B 4C 24 30 48 29 C3 48 29 C1 48 8D 6B 01 48 D1 E9 48 39 CD 72 51 48 8B 7C 24 38 48 89 EE E8 ?? ?? ?? ?? 48 85 C0 49 89 04 24 74 70 C6 44 28 FF 00 44 89 E8 48 8B 9C 24 F0 00 00 00 48 8B AC 24 F8 00 00 00 4C 8B A4 24 00 01 00 00 4C 8B AC 24 08 01 00 00 4C 8B B4 24 10 01 00 00 48 81 C4 18 01 00 00 C3 0F 1F 00 48 89 EF E8 ?? ?? ?? ?? 48 85 C0 49 89 04 24 74 9E 4C 8B 74 24 38 48 89 DA 48 89 C7 4C 89 F6 E8 ?? ?? ?? ?? 4C 89 F7 E8 ?? ?? ?? ?? 49 8B 04 24 48 85 C0 75 90 48 8B 44 24 38 49 89 04 24 EB 85 0F 1F 84 00 00 00 00 00 48 8B 7C 24 38 E8 ?? ?? ?? ?? E9 73 FF FF FF 90 41 BD FF FF FF FF E9 67 FF FF FF }
	condition:
		$1
}

rule file_118_0_0 {
	meta:
		name = "_L_lock_37"
		size = 31
		refs = "000f __lll_lock_wait_private"
	strings:
		$1 = { 48 8D 3D ?? ?? ?? ?? 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 DC FE FF FF }
	condition:
		$1
}

rule file_118_1_0 {
	meta:
		name = "_L_unlock_106"
		size = 31
		refs = "000f __lll_unlock_wake_private"
	strings:
		$1 = { 48 8D 3D ?? ?? ?? ?? 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 71 FF FF FF }
	condition:
		$1
}

rule file_28_2_3 {
	meta:
		name = "_L_unlock_67"
		size = 31
		refs = "0003 __sem_mappings_lock 000f __lll_unlock_wake_private"
	strings:
		$1 = { 48 8D 3D ?? ?? ?? ?? 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 71 FF FF FF }
	condition:
		$1
}

rule file_118_2_0 {
	meta:
		name = "getservbyport"
		size = 322
		refs = "0019 __libc_multiple_threads 0073 __getservbyport_r 009f realloc 00af free 00b6 __libc_errno 0125 malloc"
	strings:
		$1 = { 41 55 31 C0 49 89 F5 BE 01 00 00 00 41 54 41 89 FC 55 53 48 83 EC 18 83 3D ?? ?? ?? ?? 00 74 10 F0 0F B1 35 ?? ?? ?? ?? 0F 85 14 01 00 00 EB 0D 0F B1 35 ?? ?? ?? ?? 0F 85 05 01 00 00 48 8B 0D ?? ?? ?? ?? 48 8B 1D ?? ?? ?? ?? 48 85 C9 75 0F E9 BF 00 00 00 0F 1F 00 48 89 05 ?? ?? ?? ?? 4C 8D 4C 24 08 49 89 D8 BA ?? ?? ?? ?? 4C 89 EE 44 89 E7 E8 ?? ?? ?? ?? 83 F8 22 0F 85 88 00 00 00 48 8B 1D ?? ?? ?? ?? 48 8B 2D ?? ?? ?? ?? 48 01 DB 48 89 EF 48 89 DE 48 89 1D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 85 C0 48 89 C1 75 AD 48 89 EF E8 ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? 48 C7 05 ?? ?? ?? ?? 00 00 00 00 64 C7 00 0C 00 00 00 48 C7 44 24 08 00 00 00 00 83 3D ?? ?? ?? ?? 00 74 0B F0 FF 0D ?? ?? ?? ?? 75 7A EB 08 FF 0D ?? ?? ?? ?? 75 70 48 8B 44 24 08 48 83 C4 18 5B 5D 41 5C 41 5D C3 0F 1F 80 00 00 00 00 48 83 3D ?? ?? ?? ?? 00 75 C3 EB B8 BF 00 04 00 00 48 C7 05 ?? ?? ?? ?? 00 04 00 00 E8 ?? ?? ?? ?? 48 85 C0 48 89 C1 48 89 05 ?? ?? ?? ?? 74 94 BB 00 04 00 00 E9 1D FF FF FF }
	condition:
		$1
}

rule file_119_0_0 {
	meta:
		name = "_IO_helper_overflow"
		size = 250
		refs = "00ad __wmemmove 00e3 __woverflow"
	strings:
		$1 = { 48 89 5C 24 E0 48 89 FB 48 89 6C 24 E8 4C 89 64 24 F0 4C 89 6C 24 F8 48 83 EC 28 48 8B 8B A0 00 00 00 89 F5 48 8B BF 28 02 00 00 48 8B 71 18 48 8B 51 20 48 29 F2 48 C1 EA 02 85 D2 75 32 48 8B 51 20 48 3B 51 28 73 7D 89 2A 48 83 C2 04 48 89 51 20 89 E8 48 8B 5C 24 08 48 8B 6C 24 10 4C 8B 64 24 18 4C 8B 6C 24 20 48 83 C4 28 C3 0F 1F 00 48 8B 87 D8 00 00 00 4C 63 E2 4C 89 E2 FF 50 38 BA FF FF FF FF 48 39 D0 74 66 48 85 C0 74 61 48 8B 93 A0 00 00 00 4C 8D 2C 85 00 00 00 00 48 8B 7A 18 4C 89 E2 48 29 C2 4A 8D 34 2F E8 ?? ?? ?? ?? 48 8B 8B A0 00 00 00 4C 29 69 20 48 85 C9 0F 85 79 FF FF FF 89 EE 48 89 DF 48 8B 6C 24 10 48 8B 5C 24 08 4C 8B 64 24 18 4C 8B 6C 24 20 48 83 C4 28 E9 ?? ?? ?? ?? 66 0F 1F 84 00 00 00 00 00 BD FF FF FF FF E9 58 FF FF FF }
	condition:
		$1
}

rule file_119_1_0 {
	meta:
		name = "_L_lock_791"
		size = 27
		refs = "000b __lll_lock_wait_private"
	strings:
		$1 = { 48 8D 3A 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 3D AD FF FF }
	condition:
		$1
}

rule file_119_2_0 {
	meta:
		name = "buffered_vfprintf"
		size = 498
		refs = "003b _IO_fwide 00c3 _IO_vfwprintf 00cb _pthread_cleanup_push_defer 00e7 _IO_funlockfile 0116 __libc_multiple_threads 0192 _pthread_cleanup_pop_restore"
	strings:
		$1 = { 55 48 89 E5 48 89 5D D8 4C 89 65 E0 48 89 FB 4C 89 75 F0 4C 89 7D F8 49 89 F6 4C 89 6D E8 48 81 EC 90 02 00 00 BE 01 00 00 00 48 81 EC 10 80 00 00 49 89 D7 41 BC FF FF FF FF E8 ?? ?? ?? ?? 83 F8 01 0F 85 4E 01 00 00 48 8D 85 90 FD FF FF 49 89 E5 48 8D BD 90 FD FF FF 49 81 C5 00 20 00 00 4C 89 FA 4C 89 F6 48 05 E0 00 00 00 4C 89 AD 98 FE FF FF 48 89 5D B8 48 89 85 30 FE FF FF 8B 43 74 45 31 ED 48 89 A5 90 FE FF FF 48 89 A5 88 FE FF FF C7 85 50 FE FF FF 01 00 00 00 C7 85 90 FD FF FF 04 80 AD FB 48 C7 85 18 FE FF FF 00 00 00 00 89 85 04 FE FF FF 48 C7 85 68 FE FF FF ?? ?? ?? ?? E8 ?? ?? ?? ?? 41 89 C4 B8 ?? ?? ?? ?? 48 85 C0 41 0F 95 C5 0F 84 FF 00 00 00 48 8D BD 70 FD FF FF 48 89 DA BE ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 03 25 00 80 00 00 75 48 48 8B 93 88 00 00 00 64 4C 8B 04 25 10 00 00 00 4C 3B 42 08 74 2E BE 01 00 00 00 83 3D ?? ?? ?? ?? 00 74 0C F0 0F B1 32 0F 85 01 01 00 00 EB 09 0F B1 32 0F 85 F6 00 00 00 48 8B 93 88 00 00 00 4C 89 42 08 83 42 04 01 48 8B 85 30 FE FF FF 48 8B 70 18 48 8B 40 20 48 29 F0 49 89 C6 49 C1 EE 02 45 85 F6 7E 1C 48 8B 83 D8 00 00 00 49 63 D6 48 89 DF FF 50 38 41 39 C6 B8 FF FF FF FF 44 0F 45 E0 F7 03 00 80 00 00 74 2D 45 85 ED 74 0E 48 8D BD 70 FD FF FF 31 F6 E8 ?? ?? ?? ?? 44 89 E0 48 8B 5D D8 4C 8B 65 E0 4C 8B 6D E8 4C 8B 75 F0 4C 8B 7D F8 C9 C3 90 48 8B 93 88 00 00 00 83 6A 04 01 75 C6 48 C7 42 08 00 00 00 00 83 3D ?? ?? ?? ?? 00 74 07 F0 FF 0A 75 70 EB 04 FF 0A 75 6A EB A8 48 C7 85 70 FD FF FF ?? ?? ?? ?? 48 89 9D 78 FD FF FF E9 FE FE FF FF }
	condition:
		$1
}

rule file_119_3_0 {
	meta:
		name = "_L_unlock_1210"
		size = 27
		refs = "000b __lll_unlock_wake_private"
	strings:
		$1 = { 48 8D 3A 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 4D AF FF FF }
	condition:
		$1
}

rule file_119_4_0 {
	meta:
		name = "_L_lock_14552"
		size = 27
		refs = "000b __lll_lock_wait_private"
	strings:
		$1 = { 48 8D 3A 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 EF FE FF FF }
	condition:
		$1
}

rule file_119_6_0 {
	meta:
		name = "_IO_vfwprintf"
		size = 20977
		refs = "0028 __libc_errno 003e _IO_fwide 00ad __wcschrnul 00d7 _pthread_cleanup_push_defer 00ef _IO_funlockfile 012e __libc_multiple_threads 01b6 __printf_function_table 01c4 __printf_modifier_table 01d2 __printf_va_arg_table 0330 free 038d _pthread_cleanup_pop_restore 04cf __parse_one_specwc 0567 memmove 05fd _IO_wpadn 1388 __printf_fphex 13b9 __assert_fail 148e __strnlen 14ef __mbsrtowcs 1871 _itowa_lower_digits 1ebb __strerror_r 2191 __btowc 24e8 __printf_fp 285b memset 28ce __printf_arginfo_table 2b2e __libc_fatal 2b35 _nl_current_LC_NUMERIC 2c18 _itowa_upper_digits 390f __wcsnlen 3c26 __woverflow 44bb __libc_alloca_cutoff 44d9 malloc 47c8 __wcslen 47d8 __readonly_area"
	strings:
		$1 = { 55 48 89 E5 48 89 5D D8 4C 89 65 E0 48 89 FB 4C 89 7D F8 4C 89 6D E8 49 89 F7 4C 89 75 F0 48 81 EC B0 11 00 00 48 8B 05 ?? ?? ?? ?? BE 01 00 00 00 49 89 D4 64 8B 00 89 85 3C EF FF FF E8 ?? ?? ?? ?? 83 F8 01 0F 85 6D 03 00 00 8B 03 A8 08 0F 85 4B 27 00 00 4D 85 FF 0F 84 69 2A 00 00 BE 01 00 00 00 48 89 DF E8 ?? ?? ?? ?? 83 F8 01 0F 85 44 03 00 00 44 8B 2B 41 F6 C5 02 0F 85 57 02 00 00 49 8B 04 24 BE 25 00 00 00 4C 89 FF 48 89 85 C8 EF FF FF 49 8B 44 24 08 48 89 85 D0 EF FF FF 49 8B 44 24 10 48 89 85 D8 EF FF FF E8 ?? ?? ?? ?? 41 F7 C5 00 80 00 00 48 89 85 40 EF FF FF 48 89 85 70 EF FF FF C7 85 48 EF FF FF 00 00 00 00 0F 85 83 00 00 00 B8 ?? ?? ?? ?? 48 85 C0 0F 84 0A 36 00 00 48 8D BD E0 EF FF FF 48 89 DA BE ?? ?? ?? ?? E8 ?? ?? ?? ?? 44 8B 2B C7 85 48 EF FF FF 01 00 00 00 41 81 E5 00 80 00 00 75 4B 48 8B 93 88 00 00 00 64 4C 8B 04 25 10 00 00 00 4C 3B 42 08 74 31 BE 01 00 00 00 44 89 E8 83 3D ?? ?? ?? ?? 00 74 0C F0 0F B1 32 0F 85 B3 52 00 00 EB 09 0F B1 32 0F 85 A8 52 00 00 48 8B 93 88 00 00 00 4C 89 42 08 83 42 04 01 4C 8B AD 40 EF FF FF 48 8B 83 D8 00 00 00 4C 89 FE 48 89 DF 4D 29 FD 4D 89 EE 49 C1 FE 02 4C 89 F2 FF 50 38 49 39 C6 0F 85 8A 01 00 00 48 B8 FF FF FF FF 01 00 00 00 49 39 C5 0F 8F CB 31 00 00 48 8B 95 70 EF FF FF 44 89 B5 4C EF FF FF 44 8B 02 45 85 C0 0F 84 ED 01 00 00 48 83 3D ?? ?? ?? ?? 00 0F 85 36 02 00 00 48 83 3D ?? ?? ?? ?? 00 0F 85 28 02 00 00 48 83 3D ?? ?? ?? ?? 00 0F 85 1A 02 00 00 48 C7 85 30 EF FF FF 00 00 00 00 C7 85 F4 EE FF FF 00 00 00 00 C7 85 FC EE FF FF 00 00 00 00 48 C7 85 10 EF FF FF FF FF FF FF C7 85 F8 EE FF FF 00 00 00 00 48 8D 42 04 8B 52 04 45 31 ED C7 85 C0 EE FF FF 00 00 00 00 C7 85 C8 EE FF FF 00 00 00 00 48 89 85 70 EF FF FF C7 85 D8 EE FF FF 00 00 00 00 89 D0 89 95 38 EF FF FF C7 85 CC EE FF FF 00 00 00 00 83 E8 20 C7 85 B8 EE FF FF 00 00 00 00 C7 85 DC EE FF FF 00 00 00 00 83 F8 5A C7 85 D0 EE FF FF 00 00 00 00 C7 85 E8 EE FF FF 00 00 00 00 C7 85 B4 EE FF FF 00 00 00 00 C7 85 F0 EE FF FF 00 00 00 00 C7 85 E0 EE FF FF FF FF FF FF C7 85 B0 EE FF FF 00 00 00 00 C7 85 C4 EE FF FF 20 00 00 00 0F 87 23 01 00 00 0F B6 80 ?? ?? ?? ?? 4C 8D 45 D0 48 8B 04 C5 ?? ?? ?? ?? 41 BE 10 00 00 00 FF E0 0F 1F 44 00 00 4C 89 E2 4C 89 FE 48 89 DF E8 1A 4F 00 00 89 85 4C EF FF FF 8B 85 4C EF FF FF 48 8B 5D D8 4C 8B 65 E0 4C 8B 6D E8 4C 8B 75 F0 4C 8B 7D F8 C9 C3 0F 1F 84 00 00 00 00 00 48 C7 85 30 EF FF FF 00 00 00 00 45 31 ED C7 85 4C EF FF FF FF FF FF FF 48 8B BD 30 EF FF FF E8 ?? ?? ?? ?? 4C 89 EF E8 ?? ?? ?? ?? F7 03 00 80 00 00 75 31 48 8B 93 88 00 00 00 83 6A 04 01 75 24 48 C7 42 08 00 00 00 00 83 3D ?? ?? ?? ?? 00 74 0B F0 FF 0A 0F 85 A2 50 00 00 EB 08 FF 0A 0F 85 98 50 00 00 8B 95 48 EF FF FF 85 D2 0F 84 69 FF FF FF 48 8D BD E0 EF FF FF 31 F6 E8 ?? ?? ?? ?? E9 56 FF FF FF 66 2E 0F 1F 84 00 00 00 00 00 48 C7 85 30 EF FF FF 00 00 00 00 45 31 ED E9 75 FF FF FF 0F 1F 44 00 00 C7 85 4C EF FF FF FF FF FF FF E9 25 FF FF FF C7 85 E8 EE FF FF 01 00 00 00 C7 85 DC EE FF FF 00 00 00 00 83 BD 38 EF FF FF 00 75 4A 48 8B 0D ?? ?? ?? ?? 64 C7 01 16 00 00 00 E9 27 FF FF FF 48 C7 85 30 EF FF FF 00 00 00 00 C7 85 F4 EE FF FF 00 00 00 00 45 31 ED C7 85 FC EE FF FF 00 00 00 00 48 C7 85 10 EF FF FF FF FF FF FF C7 85 F8 EE FF FF 00 00 00 00 48 81 EC 10 09 00 00 4C 89 EF 48 C7 85 78 EF FF FF 00 00 00 00 48 8D 74 24 0F 48 83 E6 F0 48 89 B5 20 EF FF FF E8 ?? ?? ?? ?? 48 83 BD 10 EF FF FF FF 0F 84 CC 26 00 00 48 8B 85 40 EF FF FF 8B 38 48 89 85 70 EF FF FF 85 FF 0F 84 20 27 00 00 4C 8B 85 40 EF FF FF 31 C9 48 C7 85 08 EF FF FF 00 00 00 00 45 31 ED 48 C7 85 28 EF FF FF 00 09 00 00 45 31 F6 48 89 9D 18 EF FF FF 66 0F 1F 44 00 00 48 8B 9D 20 EF FF FF 4C 89 EE 4C 89 C7 49 83 C6 01 48 01 CB 48 8D 8D 78 EF FF FF 48 89 DA E8 ?? ?? ?? ?? 4C 8B 43 20 49 01 C5 41 8B 30 4C 89 85 70 EF FF FF 85 F6 0F 84 DC 22 00 00 4B 8D 0C F6 48 C1 E1 03 48 39 8D 28 EF FF FF 77 B3 48 8B 95 28 EF FF FF BF 10 00 00 00 48 89 8D 58 EE FF FF 4C 89 85 50 EE FF FF 48 8D 74 12 0F 31 D2 48 83 E6 F0 48 8D 46 1E 48 F7 F7 48 C1 E0 04 48 29 C4 48 8B 85 28 EF FF FF 4C 8D 4C 24 0F 49 83 E1 F0 48 01 F0 49 8D 14 31 48 39 95 20 EF FF FF 4C 89 CF 48 89 CA 48 0F 44 F0 48 89 B5 28 EF FF FF 48 8B B5 20 EF FF FF E8 ?? ?? ?? ?? 48 8B 8D 58 EE FF FF 48 89 85 20 EF FF FF 4C 8B 85 50 EE FF FF E9 2B FF FF FF 48 8B 85 70 EF FF FF 48 8D 50 04 8B 40 04 48 89 95 70 EF FF FF 89 85 38 EF FF FF 83 E8 20 83 F8 5A 0F 87 1B FE FF FF 0F B6 80 ?? ?? ?? ?? C7 85 E8 EE FF FF 01 00 00 00 C7 85 DC EE FF FF 00 00 00 00 48 8B 04 C5 ?? ?? ?? ?? FF E0 44 8B 85 F0 EE FF FF 41 83 E8 01 83 BD D8 EE FF FF 00 75 4E 45 85 C0 7E 49 49 63 D0 BE 20 00 00 00 48 89 DF 44 89 85 50 EE FF FF E8 ?? ?? ?? ?? 81 BD 4C EF FF FF FE FF FF 7F 89 C2 44 8B 85 50 EE FF FF 0F 87 B0 39 00 00 B8 FF FF FF 7F 2B 85 4C EF FF FF 01 95 4C EF FF FF 39 C2 0F 87 F0 2A 00 00 41 8B 14 24 83 FA 30 0F 83 E2 32 00 00 89 D0 49 03 44 24 10 83 C2 08 41 89 14 24 8B 30 48 8B 83 A0 00 00 00 48 85 C0 0F 84 4E 47 00 00 48 8B 50 20 48 3B 50 28 0F 83 40 47 00 00 89 32 48 83 C2 04 83 C6 01 48 89 50 20 0F 84 9D FC FF FF 81 BD 4C EF FF FF FF FF FF 7F 0F 84 8D FC FF FF 8B 8D 4C EF FF FF 83 C1 01 83 BD D8 EE FF FF 00 74 44 45 85 C0 7E 3F 49 63 D0 BE 20 00 00 00 48 89 DF 89 8D 58 EE FF FF E8 ?? ?? ?? ?? 8B 8D 58 EE FF FF 89 C2 81 F9 FE FF FF 7F 0F 87 F8 38 00 00 B8 FE FF FF 7F 2B 85 4C EF FF FF 01 D1 39 C2 0F 87 0C 47 00 00 4D 85 ED 0F 85 61 42 00 00 4C 8B AD 70 EF FF FF BE 25 00 00 00 89 8D 58 EE FF FF 49 83 C5 04 4C 89 EF 4C 89 AD 70 EF FF FF E8 ?? ?? ?? ?? 8B 8D 58 EE FF FF 48 89 85 70 EF FF FF 85 C9 0F 88 56 41 00 00 4C 8B 83 D8 00 00 00 48 89 C2 4C 89 EE 4C 29 EA 89 8D 58 EE FF FF 48 89 DF 48 C1 FA 02 41 FF 50 38 48 8B 95 70 EF FF FF 8B 8D 58 EE FF FF 48 89 D6 4C 29 EE 45 31 ED 48 C1 FE 02 48 39 F0 0F 85 B0 FB FF FF BE FF FF FF 7F 29 CE 48 63 F6 48 39 F0 0F 8F 9E 1D 00 00 01 C8 83 85 FC EE FF FF 01 83 3A 00 89 85 4C EF FF FF 0F 85 78 FA FF FF E9 8A FB FF FF 44 8B B5 18 EF FF FF 41 83 EE 01 83 BD 84 EE FF FF 00 75 40 45 85 F6 7E 3B 49 63 D6 BE 20 00 00 00 48 89 DF E8 ?? ?? ?? ?? 81 BD 4C EF FF FF FE FF FF 7F 89 C2 0F 87 58 45 00 00 B8 FF FF FF 7F 2B 85 4C EF FF FF 01 95 4C EF FF FF 39 C2 0F 87 2D 12 00 00 48 63 85 FC EE FF FF 48 6B C0 48 48 03 85 20 EF FF FF 0F 84 F5 3C 00 00 48 63 40 30 48 8B BD 28 EF FF FF 48 C1 E0 04 8B 34 07 48 8B 83 A0 00 00 00 48 85 C0 0F 84 2C 3D 00 00 48 8B 50 20 48 3B 50 28 0F 83 1E 3D 00 00 89 32 48 83 C2 04 83 C6 01 48 89 50 20 0F 84 D1 FA FF FF 81 BD 4C EF FF FF FF FF FF 7F 0F 84 C1 FA FF FF 83 85 4C EF FF FF 01 83 BD 84 EE FF FF 00 74 40 45 85 F6 7E 3B 49 63 D6 BE 20 00 00 00 48 89 DF E8 ?? ?? ?? ?? 81 BD 4C EF FF FF FE FF FF 7F 89 C2 0F 87 9D 44 00 00 B8 FF FF FF 7F 2B 85 4C EF FF FF 01 95 4C EF FF FF 39 C2 0F 87 5E 06 00 00 4C 89 EF E8 ?? ?? ?? ?? 8B 8D 4C EF FF FF 85 C9 0F 88 96 46 00 00 48 63 85 FC EE FF FF 48 8B B5 20 EF FF FF 48 89 DF 48 8D 04 C0 4C 8D 2C C6 48 8B 83 D8 00 00 00 49 8B 75 18 49 8B 55 20 48 29 F2 48 C1 FA 02 FF 50 38 49 8B 55 20 49 2B 55 18 45 31 ED 48 C1 FA 02 48 39 D0 0F 85 11 FA FF FF BA FF FF FF 7F 2B 95 4C EF FF FF 83 85 FC EE FF FF 01 01 85 4C EF FF FF 48 63 D2 48 39 D0 0F 8F E7 31 00 00 48 63 85 FC EE FF FF 48 39 85 08 EF FF FF 0F 86 66 FA FF FF 48 8B 95 20 EF FF FF 48 8D 04 C0 48 8D 34 C2 0F B6 46 0C 89 C2 C0 EA 03 89 D1 89 C2 C0 EA 04 83 E1 01 89 D7 89 C2 89 8D 7C EE FF FF C0 EA 05 83 E7 01 89 D1 89 C2 89 BD 98 EE FF FF C0 EA 06 83 E1 01 89 D7 89 C2 89 8D 84 EE FF FF C0 EA 07 83 E7 01 0F B6 D2 89 BD 90 EE FF FF 89 95 74 EE FF FF 89 C2 83 E2 01 89 95 94 EE FF FF 89 C2 D0 EA 89 D1 83 E1 01 89 8D 88 EE FF FF 0F B6 56 0D 89 D1 C0 EA 03 D0 E9 89 CF 89 C1 83 E7 01 C0 E9 02 89 BD 80 EE FF FF 89 CF 8B 4E 04 83 E7 01 89 BD A8 EE FF FF 8B 3E 89 8D 18 EF FF FF 89 D1 8B 56 08 83 E1 01 89 BD 00 EF FF FF 0F B6 7E 10 89 95 A0 EE FF FF 48 63 56 2C 89 8D 70 EE FF FF 40 88 BD 7B EE FF FF 83 FA FF 74 1F 48 8B 8D 28 EF FF FF 48 C1 E2 04 8B 14 11 85 D2 89 95 18 EF FF FF 89 56 04 0F 88 97 21 00 00 48 63 46 28 83 F8 FF 74 1E 48 8B BD 28 EF FF FF 48 C1 E0 04 8B 04 07 85 C0 89 85 00 EF FF FF 89 06 0F 88 5B 21 00 00 8B 85 18 EF FF FF 39 85 00 EF FF FF 0F 4D 85 00 EF FF FF 3D C8 03 00 00 0F 8E 31 21 00 00 83 C0 20 4C 63 E8 49 C1 E5 02 49 81 FD 00 10 00 00 0F 87 73 41 00 00 49 83 C5 1E 8B 8D 00 EF FF FF 49 83 E5 F0 4C 29 EC 48 8D 44 24 0F 48 83 E0 F0 39 8D 18 EF FF FF 0F 8D 35 21 00 00 48 63 95 00 EF FF FF 4C 8D 04 95 80 00 00 00 49 01 C0 45 31 ED 81 BD A0 EE FF FF FF 00 00 00 0F 8F 8E 20 00 00 48 8B 05 ?? ?? ?? ?? 48 85 C0 0F 84 7E 20 00 00 4C 63 9D A0 EE FF FF 4A 83 3C D8 00 0F 84 6C 20 00 00 4C 8B 4E 38 4A 8D 14 CD 1E 00 00 00 48 83 E2 F0 48 29 D4 48 8D 54 24 0F 48 83 E2 F0 4D 85 C9 74 2F 44 8B 56 30 4C 8B B5 28 EF FF FF 31 FF 31 C0 42 8D 0C 10 83 C0 01 48 C1 E1 04 4C 01 F1 48 89 0C FA 89 C7 49 39 F9 77 E7 48 8B 05 ?? ?? ?? ?? 4C 89 85 50 EE FF FF 48 89 DF 42 FF 14 D8 83 F8 FE 4C 8B 85 50 EE FF FF 0F 84 FE 1F 00 00 85 C0 0F 88 A1 F7 FF FF 81 BD 4C EF FF FF FE FF FF 7F 0F 87 1E 3C 00 00 BA FF FF FF 7F 2B 95 4C EF FF FF 01 85 4C EF FF FF 39 D0 0F 86 07 FD FF FF 48 8B 15 ?? ?? ?? ?? 64 C7 02 4B 00 00 00 E9 65 F7 FF FF 48 8B 85 70 EF FF FF 48 8D 50 04 8B 40 04 48 89 95 70 EF FF FF 89 85 38 EF FF FF 83 E8 20 83 F8 5A 0F 87 AF 27 00 00 0F B6 80 ?? ?? ?? ?? C7 85 E8 EE FF FF 01 00 00 00 48 8B 04 C5 ?? ?? ?? ?? FF E0 48 8B 85 70 EF FF FF 48 8D 50 04 8B 40 04 48 89 95 70 EF FF FF 89 85 38 EF FF FF 83 E8 20 83 F8 5A 0F 87 68 2E 00 00 0F B6 80 ?? ?? ?? ?? C7 85 C8 EE FF FF 01 00 00 00 48 8B 04 C5 ?? ?? ?? ?? FF E0 C7 85 94 EE FF FF 0A 00 00 00 48 63 85 FC EE FF FF 48 6B C0 48 48 03 85 20 EF FF FF 0F 84 3E 29 00 00 48 63 40 30 48 C1 E0 04 83 BD A8 EE FF FF 00 0F 84 F4 28 00 00 48 8B 8D 28 EF FF FF C7 85 90 EE FF FF 00 00 00 00 45 31 D2 C7 85 98 EE FF FF 00 00 00 00 4C 8B 0C 01 83 BD 00 EF FF FF 00 0F 8C 89 25 00 00 0F 85 60 1F 00 00 4D 85 C9 0F 85 57 1F 00 00 83 BD 7C EE FF FF 00 0F 84 FE 27 00 00 83 BD 94 EE FF FF 08 0F 85 F1 27 00 00 49 8D 40 FC 41 C7 40 FC 30 00 00 00 48 89 85 A8 EE FF FF C6 85 7B EE FF FF 20 31 D2 4C 2B 85 A8 EE FF FF 31 C0 4D 89 C6 4C 89 85 88 EE FF FF 49 C1 FE 02 49 F7 DE 4C 01 F2 48 0F 49 C2 83 BD 84 EE FF FF 00 48 89 85 00 EF FF FF 89 85 80 EE FF FF 0F 85 CA 1F 00 00 44 03 B5 18 EF FF FF 44 2B B5 00 EF FF FF 4D 85 C9 74 1D 83 BD 94 EE FF FF 10 75 14 83 BD 7C EE FF FF 00 41 8D 46 FE 0F 95 C2 84 D2 44 0F 45 F0 8B 85 98 EE FF FF 44 09 D0 0B 85 90 EE FF FF 83 F8 01 41 83 D6 FF 80 BD 7B EE FF FF 20 0F 84 04 29 00 00 45 85 D2 0F 84 BD 28 00 00 48 8B 83 A0 00 00 00 48 85 C0 0F 84 CD 35 00 00 48 8B 50 20 48 3B 50 28 0F 83 BF 35 00 00 C7 02 2D 00 00 00 48 83 C2 04 48 89 50 20 81 BD 4C EF FF FF FF FF FF 7F 0F 84 63 F5 FF FF 83 85 4C EF FF FF 01 4D 85 C9 0F 84 A4 00 00 00 83 BD 94 EE FF FF 10 0F 85 97 00 00 00 83 BD 7C EE FF FF 00 0F 84 8A 00 00 00 48 8B 83 A0 00 00 00 48 85 C0 0F 84 23 35 00 00 48 8B 50 20 48 3B 50 28 0F 83 15 35 00 00 C7 02 30 00 00 00 48 83 C2 04 48 89 50 20 81 BD 4C EF FF FF FF FF FF 7F 0F 84 FD F4 FF FF 48 8B 83 A0 00 00 00 8B B5 A0 EE FF FF 48 85 C0 0F 84 CB 34 00 00 48 8B 50 20 48 3B 50 28 0F 83 BD 34 00 00 89 32 48 83 C2 04 83 C6 01 48 89 50 20 0F 84 C6 F4 FF FF 81 BD 4C EF FF FF FE FF FF 7F 0F 84 B6 F4 FF FF 83 85 4C EF FF FF 02 44 03 B5 80 EE FF FF 45 85 F6 7E 3B 49 63 D6 BE 30 00 00 00 48 89 DF E8 ?? ?? ?? ?? 81 BD 4C EF FF FF FE FF FF 7F 89 C2 0F 87 07 05 00 00 B8 FF FF FF 7F 2B 85 4C EF FF FF 01 95 4C EF FF FF 39 C2 0F 87 62 2C 00 00 83 BD 4C EF FF FF 00 0F 88 D2 3E 00 00 4C 8B B5 88 EE FF FF 48 8B 83 D8 00 00 00 48 89 DF 48 8B B5 A8 EE FF FF 49 C1 FE 02 4C 89 F2 FF 50 38 49 39 C6 0F 85 30 F4 FF FF B8 FF FF FF 7F 2B 85 4C EF FF FF 44 01 B5 4C EF FF FF 48 98 49 39 C6 0F 8E A2 F9 FF FF 48 8B 05 ?? ?? ?? ?? 64 C7 00 4B 00 00 00 E9 00 F4 FF FF 48 8B 83 A0 00 00 00 48 85 C0 0F 84 9C 2E 00 00 48 8B 50 20 48 3B 50 28 0F 83 8E 2E 00 00 C7 02 25 00 00 00 48 83 C2 04 48 89 50 20 81 BD 4C EF FF FF FF FF FF 7F 0F 84 C4 F3 FF FF 8B 8D 4C EF FF FF 83 C1 01 E9 7F F7 FF FF 83 BD E8 EE FF FF 00 41 8B 14 24 0F 84 53 28 00 00 83 FA 30 0F 83 44 33 00 00 89 D0 49 03 44 24 10 83 C2 08 41 89 14 24 48 8B 00 48 85 C0 49 89 C6 0F 89 27 24 00 00 49 F7 DE C7 85 DC EE FF FF 0A 00 00 00 41 B9 01 00 00 00 83 BD E0 EE FF FF 00 0F 8C 5E 22 00 00 0F 85 71 21 00 00 4D 85 F6 0F 85 68 21 00 00 83 BD C0 EE FF FF 00 0F 84 07 27 00 00 83 BD DC EE FF FF 08 0F 85 FA 26 00 00 49 8D 40 FC 41 C7 40 FC 30 00 00 00 48 89 85 E8 EE FF FF C7 85 C4 EE FF }
	condition:
		$1
}

rule file_119_7_0 {
	meta:
		name = "read_int"
		size = 70
	strings:
		$1 = { 48 8B 17 41 B9 FF FF FF 7F 8B 02 83 E8 30 EB 24 85 C0 78 20 3D CC CC CC 0C 7F 16 6B F0 0A 45 89 C8 83 C8 FF 41 29 C8 01 F1 41 39 F0 0F 4D C1 EB 03 83 C8 FF 48 83 C2 04 8B 0A 83 E9 30 83 F9 09 76 CE 48 89 17 C3 }
	condition:
		$1
}

rule file_119_8_0 {
	meta:
		name = "group_number"
		size = 197
		refs = "004f mempcpy"
	strings:
		$1 = { 55 48 89 E5 41 57 41 56 41 89 CE 41 55 41 54 53 50 0F BE 1A 48 89 F8 8D 4B FF 80 F9 7D 0F 87 93 00 00 00 4C 8D 6A 01 48 89 F2 49 89 F7 48 29 FA 48 89 FE 48 83 E2 FC 48 8D 4A 1E 48 83 E1 F0 48 29 CC 4C 8D 64 24 0F 49 83 E4 F0 4C 89 E7 E8 ?? ?? ?? ?? 49 89 C0 4C 89 F8 EB 56 49 83 E8 04 45 8B 08 FF CB 48 8D 70 FC 44 89 48 FC 75 40 4D 39 E0 76 3B 44 89 70 F8 41 0F BE 5D 00 48 8D 70 F8 84 DB 78 05 80 FB 7F 75 17 48 89 F0 49 83 E8 04 41 8B 10 48 83 E8 04 4D 39 E0 89 10 77 EE EB 16 84 DB 74 05 49 FF C5 EB 05 41 0F BE 5D FF 48 89 F0 4D 39 E0 77 A5 48 8D 65 D8 5B 41 5C 41 5D 41 5E 41 5F 5D C3 }
	condition:
		$1
}

rule file_119_9_0 {
	meta:
		name = "_i18n_number_rewrite"
		size = 313
		refs = "0028 __wctrans 0038 __towctrans 0062 __libc_alloca_cutoff 0091 malloc 00ab mempcpy 00b9 _nl_current_LC_CTYPE 0123 free"
	strings:
		$1 = { 55 48 89 E5 41 57 41 56 49 89 F6 41 55 41 54 53 48 89 FB BF ?? ?? ?? ?? 49 29 DE 48 83 EC 18 48 89 55 C8 49 83 E6 FC E8 ?? ?? ?? ?? BF 2E 00 00 00 49 89 C7 48 89 C6 E8 ?? ?? ?? ?? 4C 89 FE BF 2C 00 00 00 89 45 C4 E8 ?? ?? ?? ?? 49 81 FE 00 10 00 00 89 45 C0 41 BA 01 00 00 00 76 11 4C 89 F7 E8 ?? ?? ?? ?? 45 31 D2 85 C0 41 0F 95 C2 45 84 D2 45 88 D4 74 16 49 8D 46 1E 48 83 E0 F0 48 29 C4 4C 8D 6C 24 0F 49 83 E5 F0 EB 14 4C 89 F7 E8 ?? ?? ?? ?? 48 85 C0 49 89 C5 0F 84 86 00 00 00 4C 89 F2 48 89 DE 4C 89 EF E8 ?? ?? ?? ?? 48 8B 55 C8 48 89 C1 48 8B 05 ?? ?? ?? ?? 48 83 EA 04 64 48 8B 30 EB 46 44 8B 01 45 8D 48 D0 41 83 F9 09 77 13 48 8B 06 41 83 C0 03 4D 63 C0 42 8B 44 C0 40 89 02 EB 22 4D 85 FF 74 0B 44 89 C0 83 E0 FD 83 F8 2C 74 05 44 89 02 EB 0D 8B 45 C4 41 83 F8 2E 0F 45 45 C0 89 02 48 83 EA 04 48 83 E9 04 48 8D 5A 04 4C 39 E9 73 AD 45 84 E4 75 08 4C 89 EF E8 ?? ?? ?? ?? 48 8D 65 D8 48 89 D8 5B 41 5C 41 5D 41 5E 41 5F 5D C3 }
	condition:
		$1
}

rule file_120_0_0 {
	meta:
		name = "__sched_setparam"
		size = 20
		refs = "000f __syscall_error"
	strings:
		$1 = { B8 8E 00 00 00 0F 05 48 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_121_0_0 {
	meta:
		name = "__vswscanf"
		size = 148
		refs = "000c _IO_wstr_jumps 0044 _IO_no_init 0051 _IO_fwide 0060 _IO_wstr_init_static 0070 _IO_vfwscanf"
	strings:
		$1 = { 48 89 5C 24 E8 48 89 6C 24 F0 41 B8 ?? ?? ?? ?? 4C 89 64 24 F8 48 81 EC 58 02 00 00 49 89 FC 48 8D 8C 24 F0 00 00 00 48 89 F3 48 89 D5 48 89 E7 31 D2 BE 00 80 00 00 48 C7 84 24 88 00 00 00 00 00 00 00 E8 ?? ?? ?? ?? 48 89 E7 BE 01 00 00 00 E8 ?? ?? ?? ?? 4C 89 E6 48 89 E7 31 C9 31 D2 E8 ?? ?? ?? ?? 48 89 EA 48 89 DE 48 89 E7 31 C9 E8 ?? ?? ?? ?? 48 8B 9C 24 40 02 00 00 48 8B AC 24 48 02 00 00 4C 8B A4 24 50 02 00 00 48 81 C4 58 02 00 00 C3 }
	condition:
		$1
}

rule file_122_0_0 {
	meta:
		name = "insque"
		size = 48
	strings:
		$1 = { 48 85 F6 74 1B 48 8B 06 48 89 3E 48 85 C0 74 04 48 89 78 08 48 89 07 48 89 77 08 C3 0F 1F 40 00 48 C7 07 00 00 00 00 48 C7 47 08 00 00 00 00 C3 }
	condition:
		$1
}

rule file_122_1_0 {
	meta:
		name = "remque"
		size = 26
	strings:
		$1 = { 48 8B 17 48 8B 47 08 48 85 D2 74 04 48 89 42 08 48 85 C0 74 03 48 89 10 F3 C3 }
	condition:
		$1
}

rule file_123_0_0 {
	meta:
		name = "strcat"
		size = 444
	strings:
		$1 = { 48 89 F9 83 E1 07 48 89 F8 49 B8 FF FE FE FE FE FE FE FE 74 1B F7 D9 83 C1 08 80 38 00 0F 84 C2 00 00 00 48 FF C0 FF C9 75 F0 66 0F 1F 44 00 00 48 8B 08 48 83 C0 08 4C 89 C2 48 01 CA 73 61 48 31 CA 4C 09 C2 48 FF C2 75 56 48 8B 08 48 83 C0 08 4C 89 C2 48 01 CA 73 47 48 31 CA 4C 09 C2 48 FF C2 75 3C 48 8B 08 48 83 C0 08 4C 89 C2 48 01 CA 73 2D 48 31 CA 4C 09 C2 48 FF C2 75 22 48 8B 08 48 83 C0 08 4C 89 C2 48 01 CA 73 13 48 31 CA 4C 09 C2 48 FF C2 74 98 0F 1F 84 00 00 00 00 00 48 83 E8 08 84 C9 74 3D 48 FF C0 84 ED 74 36 48 FF C0 F7 C1 00 00 FF 00 74 2B 48 FF C0 F7 C1 00 00 00 FF 74 20 48 FF C0 48 C1 E9 20 84 C9 74 15 48 FF C0 84 ED 74 0E 48 FF C0 F7 C1 00 00 FF 00 74 03 48 FF C0 48 89 F1 83 E1 07 48 89 C2 74 20 F7 D9 83 C1 08 8A 06 84 C0 88 02 0F 84 B7 00 00 00 48 FF C6 48 FF C2 FF C9 75 EA 0F 1F 44 00 00 48 8B 06 48 83 C6 08 49 89 C1 4D 01 C1 0F 83 7D 00 00 00 49 31 C1 4D 09 C1 49 FF C1 75 72 48 89 02 48 83 C2 08 48 8B 06 48 83 C6 08 49 89 C1 4D 01 C1 73 5C 49 31 C1 4D 09 C1 49 FF C1 75 51 48 89 02 48 83 C2 08 48 8B 06 48 83 C6 08 49 89 C1 4D 01 C1 73 3B 49 31 C1 4D 09 C1 49 FF C1 75 30 48 89 02 48 83 C2 08 48 8B 06 48 83 C6 08 49 89 C1 4D 01 C1 73 1A 49 31 C1 4D 09 C1 49 FF C1 75 0F 48 89 02 48 83 C2 08 E9 73 FF FF FF 0F 1F 00 88 02 84 C0 74 12 48 FF C2 88 22 84 E4 74 09 48 FF C2 48 C1 E8 10 EB E8 48 89 F8 C3 }
	condition:
		$1
}

rule file_124_0_0 {
	meta:
		name = "__libc_tcdrain"
		size = 144
		refs = "0002 __libc_multiple_threads 002b __libc_errno 0042 __libc_enable_asynccancel 006f __libc_disable_asynccancel"
	strings:
		$1 = { 8B 05 ?? ?? ?? ?? 85 C0 75 2F BA 01 00 00 00 BE 09 54 00 00 48 63 FF B8 10 00 00 00 0F 05 48 3D 00 F0 FF FF 77 02 F3 C3 48 8B 15 ?? ?? ?? ?? F7 D8 64 89 02 48 83 C8 FF C3 48 83 EC 18 89 7C 24 08 E8 ?? ?? ?? ?? BA 01 00 00 00 41 89 C0 BE 09 54 00 00 48 63 7C 24 08 B8 10 00 00 00 0F 05 48 3D 00 F0 FF FF 77 15 44 89 C7 89 44 24 08 E8 ?? ?? ?? ?? 8B 44 24 08 48 83 C4 18 C3 89 C2 48 8B 05 ?? ?? ?? ?? F7 DA 64 89 10 48 83 C8 FF EB D7 }
	condition:
		$1
}

rule file_71_0_3 {
	meta:
		name = "__libc_tcdrain"
		size = 144
		refs = "0002 __pthread_multiple_threads 002b errno 0042 __pthread_enable_asynccancel 006f __pthread_disable_asynccancel"
	strings:
		$1 = { 8B 05 ?? ?? ?? ?? 85 C0 75 2F BA 01 00 00 00 BE 09 54 00 00 48 63 FF B8 10 00 00 00 0F 05 48 3D 00 F0 FF FF 77 02 F3 C3 48 8B 15 ?? ?? ?? ?? F7 D8 64 89 02 48 83 C8 FF C3 48 83 EC 18 89 7C 24 08 E8 ?? ?? ?? ?? BA 01 00 00 00 41 89 C0 BE 09 54 00 00 48 63 7C 24 08 B8 10 00 00 00 0F 05 48 3D 00 F0 FF FF 77 15 44 89 C7 89 44 24 08 E8 ?? ?? ?? ?? 8B 44 24 08 48 83 C4 18 C3 89 C2 48 8B 05 ?? ?? ?? ?? F7 DA 64 89 10 48 83 C8 FF EB D7 }
	condition:
		$1
}

rule file_125_0_0 {
	meta:
		name = "__sched_rr_get_interval"
		size = 20
		refs = "000f __syscall_error"
	strings:
		$1 = { B8 94 00 00 00 0F 05 48 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_126_0_0 {
	meta:
		name = "fileno"
		size = 44
		refs = "001b __libc_errno"
	strings:
		$1 = { F7 07 00 20 00 00 74 10 8B 47 70 85 C0 78 09 F3 C3 0F 1F 80 00 00 00 00 48 8B 05 ?? ?? ?? ?? 64 C7 00 09 00 00 00 B8 FF FF FF FF C3 }
	condition:
		$1
}

rule file_127_0_0 {
	meta:
		name = "__default_morecore"
		size = 24
		refs = "0005 __sbrk"
	strings:
		$1 = { 48 83 EC 08 E8 ?? ?? ?? ?? 31 D2 48 83 F8 FF 48 0F 44 C2 48 83 C4 08 C3 }
	condition:
		$1
}

rule file_128_0_0 {
	meta:
		name = "_L_lock_11"
		size = 31
		refs = "000f __lll_lock_wait_private"
	strings:
		$1 = { 48 8D 3D ?? ?? ?? ?? 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 08 FE FF FF }
	condition:
		$1
}

rule file_128_1_0 {
	meta:
		name = "_L_unlock_30"
		size = 31
		refs = "000f __lll_unlock_wake_private"
		altNames = "_L_unlock_33"
	strings:
		$1 = { 48 8D 3D ?? ?? ?? ?? 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 49 FE FF FF }
	condition:
		$1
}

rule file_128_2_0 {
	meta:
		name = "_L_lock_54"
		size = 31
		refs = "000f __lll_lock_wait_private"
		altNames = "_L_lock_57"
	strings:
		$1 = { 48 8D 3D ?? ?? ?? ?? 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 78 FE FF FF }
	condition:
		$1
}

rule file_128_3_0 {
	meta:
		name = "_L_unlock_71"
		size = 31
		refs = "000f __lll_unlock_wake_private"
		altNames = "_L_unlock_74"
	strings:
		$1 = { 48 8D 3D ?? ?? ?? ?? 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 A9 FE FF FF }
	condition:
		$1
}

rule file_128_4_0 {
	meta:
		name = "_L_lock_113"
		size = 31
		refs = "000f __lll_lock_wait_private"
		altNames = "_L_lock_1102 _L_lock_116"
	strings:
		$1 = { 48 8D 3D ?? ?? ?? ?? 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 D6 FE FF FF }
	condition:
		$1
}

rule file_128_5_0 {
	meta:
		name = "_L_unlock_146"
		size = 31
		refs = "000f __lll_unlock_wake_private"
		altNames = "_L_unlock_149 _L_unlock_154"
	strings:
		$1 = { 48 8D 3D ?? ?? ?? ?? 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 3A FF FF FF }
	condition:
		$1
}

rule file_128_6_0 {
	meta:
		name = "setsgent"
		size = 153
		refs = "000d __libc_multiple_threads 0055 __nss_gshadow_lookup2 005f __nss_setent 0066 __libc_errno"
	strings:
		$1 = { 48 83 EC 18 BE 01 00 00 00 31 C0 83 3D ?? ?? ?? ?? 00 74 10 F0 0F B1 35 ?? ?? ?? ?? 0F 85 E8 01 00 00 EB 0D 0F B1 35 ?? ?? ?? ?? 0F 85 D9 01 00 00 45 31 C9 C7 44 24 08 00 00 00 00 48 C7 04 24 00 00 00 00 41 B8 ?? ?? ?? ?? B9 ?? ?? ?? ?? BA ?? ?? ?? ?? BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 15 ?? ?? ?? ?? 64 8B 32 83 3D ?? ?? ?? ?? 00 74 0F F0 FF 0D ?? ?? ?? ?? 0F 85 A6 01 00 00 EB 0C FF 0D ?? ?? ?? ?? 0F 85 98 01 00 00 64 89 32 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_1074_6_0 {
	meta:
		name = "setaliasent"
		size = 153
		refs = "000d __libc_multiple_threads 0055 __nss_aliases_lookup2 005f __nss_setent 0066 __libc_errno"
	strings:
		$1 = { 48 83 EC 18 BE 01 00 00 00 31 C0 83 3D ?? ?? ?? ?? 00 74 10 F0 0F B1 35 ?? ?? ?? ?? 0F 85 E8 01 00 00 EB 0D 0F B1 35 ?? ?? ?? ?? 0F 85 D9 01 00 00 45 31 C9 C7 44 24 08 00 00 00 00 48 C7 04 24 00 00 00 00 41 B8 ?? ?? ?? ?? B9 ?? ?? ?? ?? BA ?? ?? ?? ?? BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 15 ?? ?? ?? ?? 64 8B 32 83 3D ?? ?? ?? ?? 00 74 0F F0 FF 0D ?? ?? ?? ?? 0F 85 A6 01 00 00 EB 0C FF 0D ?? ?? ?? ?? 0F 85 98 01 00 00 64 89 32 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_1121_6_0 {
	meta:
		name = "setgrent"
		size = 153
		refs = "000d __libc_multiple_threads 0055 __nss_group_lookup2 005f __nss_setent 0066 __libc_errno"
	strings:
		$1 = { 48 83 EC 18 BE 01 00 00 00 31 C0 83 3D ?? ?? ?? ?? 00 74 10 F0 0F B1 35 ?? ?? ?? ?? 0F 85 E8 01 00 00 EB 0D 0F B1 35 ?? ?? ?? ?? 0F 85 D9 01 00 00 45 31 C9 C7 44 24 08 00 00 00 00 48 C7 04 24 00 00 00 00 41 B8 ?? ?? ?? ?? B9 ?? ?? ?? ?? BA ?? ?? ?? ?? BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 15 ?? ?? ?? ?? 64 8B 32 83 3D ?? ?? ?? ?? 00 74 0F F0 FF 0D ?? ?? ?? ?? 0F 85 A6 01 00 00 EB 0C FF 0D ?? ?? ?? ?? 0F 85 98 01 00 00 64 89 32 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_734_6_0 {
	meta:
		name = "setpwent"
		size = 153
		refs = "000d __libc_multiple_threads 0055 __nss_passwd_lookup2 005f __nss_setent 0066 __libc_errno"
	strings:
		$1 = { 48 83 EC 18 BE 01 00 00 00 31 C0 83 3D ?? ?? ?? ?? 00 74 10 F0 0F B1 35 ?? ?? ?? ?? 0F 85 E8 01 00 00 EB 0D 0F B1 35 ?? ?? ?? ?? 0F 85 D9 01 00 00 45 31 C9 C7 44 24 08 00 00 00 00 48 C7 04 24 00 00 00 00 41 B8 ?? ?? ?? ?? B9 ?? ?? ?? ?? BA ?? ?? ?? ?? BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 15 ?? ?? ?? ?? 64 8B 32 83 3D ?? ?? ?? ?? 00 74 0F F0 FF 0D ?? ?? ?? ?? 0F 85 A6 01 00 00 EB 0C FF 0D ?? ?? ?? ?? 0F 85 98 01 00 00 64 89 32 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_537_6_0 {
	meta:
		name = "setspent"
		size = 153
		refs = "000d __libc_multiple_threads 0055 __nss_shadow_lookup2 005f __nss_setent 0066 __libc_errno"
	strings:
		$1 = { 48 83 EC 18 BE 01 00 00 00 31 C0 83 3D ?? ?? ?? ?? 00 74 10 F0 0F B1 35 ?? ?? ?? ?? 0F 85 E8 01 00 00 EB 0D 0F B1 35 ?? ?? ?? ?? 0F 85 D9 01 00 00 45 31 C9 C7 44 24 08 00 00 00 00 48 C7 04 24 00 00 00 00 41 B8 ?? ?? ?? ?? B9 ?? ?? ?? ?? BA ?? ?? ?? ?? BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 15 ?? ?? ?? ?? 64 8B 32 83 3D ?? ?? ?? ?? 00 74 0F F0 FF 0D ?? ?? ?? ?? 0F 85 A6 01 00 00 EB 0C FF 0D ?? ?? ?? ?? 0F 85 98 01 00 00 64 89 32 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_128_7_0 {
	meta:
		name = "endsgent"
		size = 152
		refs = "001b __libc_multiple_threads 0053 __nss_gshadow_lookup2 005d __nss_endent 0064 __libc_errno"
	strings:
		$1 = { 48 83 3D ?? ?? ?? ?? 00 0F 84 88 00 00 00 48 83 EC 08 BE 01 00 00 00 31 C0 83 3D ?? ?? ?? ?? 00 74 10 F0 0F B1 35 ?? ?? ?? ?? 0F 85 78 01 00 00 EB 0D 0F B1 35 ?? ?? ?? ?? 0F 85 69 01 00 00 45 31 C9 41 B8 ?? ?? ?? ?? B9 ?? ?? ?? ?? BA ?? ?? ?? ?? BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 15 ?? ?? ?? ?? 64 8B 32 83 3D ?? ?? ?? ?? 00 74 0F F0 FF 0D ?? ?? ?? ?? 0F 85 46 01 00 00 EB 0C FF 0D ?? ?? ?? ?? 0F 85 38 01 00 00 64 89 32 48 83 C4 08 F3 C3 }
	condition:
		$1
}

rule file_1074_7_0 {
	meta:
		name = "endaliasent"
		size = 152
		refs = "001b __libc_multiple_threads 0053 __nss_aliases_lookup2 005d __nss_endent 0064 __libc_errno"
	strings:
		$1 = { 48 83 3D ?? ?? ?? ?? 00 0F 84 88 00 00 00 48 83 EC 08 BE 01 00 00 00 31 C0 83 3D ?? ?? ?? ?? 00 74 10 F0 0F B1 35 ?? ?? ?? ?? 0F 85 78 01 00 00 EB 0D 0F B1 35 ?? ?? ?? ?? 0F 85 69 01 00 00 45 31 C9 41 B8 ?? ?? ?? ?? B9 ?? ?? ?? ?? BA ?? ?? ?? ?? BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 15 ?? ?? ?? ?? 64 8B 32 83 3D ?? ?? ?? ?? 00 74 0F F0 FF 0D ?? ?? ?? ?? 0F 85 46 01 00 00 EB 0C FF 0D ?? ?? ?? ?? 0F 85 38 01 00 00 64 89 32 48 83 C4 08 F3 C3 }
	condition:
		$1
}

rule file_1121_7_0 {
	meta:
		name = "endgrent"
		size = 152
		refs = "001b __libc_multiple_threads 0053 __nss_group_lookup2 005d __nss_endent 0064 __libc_errno"
	strings:
		$1 = { 48 83 3D ?? ?? ?? ?? 00 0F 84 88 00 00 00 48 83 EC 08 BE 01 00 00 00 31 C0 83 3D ?? ?? ?? ?? 00 74 10 F0 0F B1 35 ?? ?? ?? ?? 0F 85 78 01 00 00 EB 0D 0F B1 35 ?? ?? ?? ?? 0F 85 69 01 00 00 45 31 C9 41 B8 ?? ?? ?? ?? B9 ?? ?? ?? ?? BA ?? ?? ?? ?? BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 15 ?? ?? ?? ?? 64 8B 32 83 3D ?? ?? ?? ?? 00 74 0F F0 FF 0D ?? ?? ?? ?? 0F 85 46 01 00 00 EB 0C FF 0D ?? ?? ?? ?? 0F 85 38 01 00 00 64 89 32 48 83 C4 08 F3 C3 }
	condition:
		$1
}

rule file_1022_7_0 {
	meta:
		name = "endprotoent"
		size = 152
		refs = "001b __libc_multiple_threads 0053 __nss_protocols_lookup2 005d __nss_endent 0064 __libc_errno"
	strings:
		$1 = { 48 83 3D ?? ?? ?? ?? 00 0F 84 88 00 00 00 48 83 EC 08 BE 01 00 00 00 31 C0 83 3D ?? ?? ?? ?? 00 74 10 F0 0F B1 35 ?? ?? ?? ?? 0F 85 78 01 00 00 EB 0D 0F B1 35 ?? ?? ?? ?? 0F 85 69 01 00 00 45 31 C9 41 B8 ?? ?? ?? ?? B9 ?? ?? ?? ?? BA ?? ?? ?? ?? BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 15 ?? ?? ?? ?? 64 8B 32 83 3D ?? ?? ?? ?? 00 74 0F F0 FF 0D ?? ?? ?? ?? 0F 85 46 01 00 00 EB 0C FF 0D ?? ?? ?? ?? 0F 85 38 01 00 00 64 89 32 48 83 C4 08 F3 C3 }
	condition:
		$1
}

rule file_734_7_0 {
	meta:
		name = "endpwent"
		size = 152
		refs = "001b __libc_multiple_threads 0053 __nss_passwd_lookup2 005d __nss_endent 0064 __libc_errno"
	strings:
		$1 = { 48 83 3D ?? ?? ?? ?? 00 0F 84 88 00 00 00 48 83 EC 08 BE 01 00 00 00 31 C0 83 3D ?? ?? ?? ?? 00 74 10 F0 0F B1 35 ?? ?? ?? ?? 0F 85 78 01 00 00 EB 0D 0F B1 35 ?? ?? ?? ?? 0F 85 69 01 00 00 45 31 C9 41 B8 ?? ?? ?? ?? B9 ?? ?? ?? ?? BA ?? ?? ?? ?? BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 15 ?? ?? ?? ?? 64 8B 32 83 3D ?? ?? ?? ?? 00 74 0F F0 FF 0D ?? ?? ?? ?? 0F 85 46 01 00 00 EB 0C FF 0D ?? ?? ?? ?? 0F 85 38 01 00 00 64 89 32 48 83 C4 08 F3 C3 }
	condition:
		$1
}

rule file_370_7_0 {
	meta:
		name = "endrpcent"
		size = 152
		refs = "001b __libc_multiple_threads 0053 __nss_rpc_lookup2 005d __nss_endent 0064 __libc_errno"
	strings:
		$1 = { 48 83 3D ?? ?? ?? ?? 00 0F 84 88 00 00 00 48 83 EC 08 BE 01 00 00 00 31 C0 83 3D ?? ?? ?? ?? 00 74 10 F0 0F B1 35 ?? ?? ?? ?? 0F 85 78 01 00 00 EB 0D 0F B1 35 ?? ?? ?? ?? 0F 85 69 01 00 00 45 31 C9 41 B8 ?? ?? ?? ?? B9 ?? ?? ?? ?? BA ?? ?? ?? ?? BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 15 ?? ?? ?? ?? 64 8B 32 83 3D ?? ?? ?? ?? 00 74 0F F0 FF 0D ?? ?? ?? ?? 0F 85 46 01 00 00 EB 0C FF 0D ?? ?? ?? ?? 0F 85 38 01 00 00 64 89 32 48 83 C4 08 F3 C3 }
	condition:
		$1
}

rule file_1390_7_0 {
	meta:
		name = "endservent"
		size = 152
		refs = "001b __libc_multiple_threads 0053 __nss_services_lookup2 005d __nss_endent 0064 __libc_errno"
	strings:
		$1 = { 48 83 3D ?? ?? ?? ?? 00 0F 84 88 00 00 00 48 83 EC 08 BE 01 00 00 00 31 C0 83 3D ?? ?? ?? ?? 00 74 10 F0 0F B1 35 ?? ?? ?? ?? 0F 85 78 01 00 00 EB 0D 0F B1 35 ?? ?? ?? ?? 0F 85 69 01 00 00 45 31 C9 41 B8 ?? ?? ?? ?? B9 ?? ?? ?? ?? BA ?? ?? ?? ?? BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 15 ?? ?? ?? ?? 64 8B 32 83 3D ?? ?? ?? ?? 00 74 0F F0 FF 0D ?? ?? ?? ?? 0F 85 46 01 00 00 EB 0C FF 0D ?? ?? ?? ?? 0F 85 38 01 00 00 64 89 32 48 83 C4 08 F3 C3 }
	condition:
		$1
}

rule file_537_7_0 {
	meta:
		name = "endspent"
		size = 152
		refs = "001b __libc_multiple_threads 0053 __nss_shadow_lookup2 005d __nss_endent 0064 __libc_errno"
	strings:
		$1 = { 48 83 3D ?? ?? ?? ?? 00 0F 84 88 00 00 00 48 83 EC 08 BE 01 00 00 00 31 C0 83 3D ?? ?? ?? ?? 00 74 10 F0 0F B1 35 ?? ?? ?? ?? 0F 85 78 01 00 00 EB 0D 0F B1 35 ?? ?? ?? ?? 0F 85 69 01 00 00 45 31 C9 41 B8 ?? ?? ?? ?? B9 ?? ?? ?? ?? BA ?? ?? ?? ?? BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 15 ?? ?? ?? ?? 64 8B 32 83 3D ?? ?? ?? ?? 00 74 0F F0 FF 0D ?? ?? ?? ?? 0F 85 46 01 00 00 EB 0C FF 0D ?? ?? ?? ?? 0F 85 38 01 00 00 64 89 32 48 83 C4 08 F3 C3 }
	condition:
		$1
}

rule file_128_8_0 {
	meta:
		name = "__getsgent_r"
		size = 202
		refs = "0017 __libc_multiple_threads 007a __nss_gshadow_lookup2 0089 __nss_getent_r 0090 __libc_errno"
	strings:
		$1 = { 53 49 89 F2 49 89 F9 48 89 CB BE 01 00 00 00 31 C0 48 83 EC 40 83 3D ?? ?? ?? ?? 00 74 10 F0 0F B1 35 ?? ?? ?? ?? 0F 85 1A 01 00 00 EB 0D 0F B1 35 ?? ?? ?? ?? 0F 85 0B 01 00 00 41 B8 ?? ?? ?? ?? 48 89 54 24 20 4C 89 4C 24 10 48 C7 44 24 30 00 00 00 00 48 89 5C 24 28 41 B9 ?? ?? ?? ?? 4C 89 54 24 18 C7 44 24 08 00 00 00 00 B9 ?? ?? ?? ?? 48 C7 04 24 00 00 00 00 BA ?? ?? ?? ?? BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 15 ?? ?? ?? ?? 89 C6 64 44 8B 02 83 3D ?? ?? ?? ?? 00 74 0F F0 FF 0D ?? ?? ?? ?? 0F 85 B5 00 00 00 EB 0C FF 0D ?? ?? ?? ?? 0F 85 A7 00 00 00 64 44 89 02 48 83 C4 40 89 F0 5B C3 }
	condition:
		$1
}

rule file_1074_8_0 {
	meta:
		name = "__getaliasent_r"
		size = 202
		refs = "0017 __libc_multiple_threads 007a __nss_aliases_lookup2 0089 __nss_getent_r 0090 __libc_errno"
	strings:
		$1 = { 53 49 89 F2 49 89 F9 48 89 CB BE 01 00 00 00 31 C0 48 83 EC 40 83 3D ?? ?? ?? ?? 00 74 10 F0 0F B1 35 ?? ?? ?? ?? 0F 85 1A 01 00 00 EB 0D 0F B1 35 ?? ?? ?? ?? 0F 85 0B 01 00 00 41 B8 ?? ?? ?? ?? 48 89 54 24 20 4C 89 4C 24 10 48 C7 44 24 30 00 00 00 00 48 89 5C 24 28 41 B9 ?? ?? ?? ?? 4C 89 54 24 18 C7 44 24 08 00 00 00 00 B9 ?? ?? ?? ?? 48 C7 04 24 00 00 00 00 BA ?? ?? ?? ?? BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 15 ?? ?? ?? ?? 89 C6 64 44 8B 02 83 3D ?? ?? ?? ?? 00 74 0F F0 FF 0D ?? ?? ?? ?? 0F 85 B5 00 00 00 EB 0C FF 0D ?? ?? ?? ?? 0F 85 A7 00 00 00 64 44 89 02 48 83 C4 40 89 F0 5B C3 }
	condition:
		$1
}

rule file_1121_8_0 {
	meta:
		name = "__getgrent_r"
		size = 202
		refs = "0017 __libc_multiple_threads 007a __nss_group_lookup2 0089 __nss_getent_r 0090 __libc_errno"
	strings:
		$1 = { 53 49 89 F2 49 89 F9 48 89 CB BE 01 00 00 00 31 C0 48 83 EC 40 83 3D ?? ?? ?? ?? 00 74 10 F0 0F B1 35 ?? ?? ?? ?? 0F 85 1A 01 00 00 EB 0D 0F B1 35 ?? ?? ?? ?? 0F 85 0B 01 00 00 41 B8 ?? ?? ?? ?? 48 89 54 24 20 4C 89 4C 24 10 48 C7 44 24 30 00 00 00 00 48 89 5C 24 28 41 B9 ?? ?? ?? ?? 4C 89 54 24 18 C7 44 24 08 00 00 00 00 B9 ?? ?? ?? ?? 48 C7 04 24 00 00 00 00 BA ?? ?? ?? ?? BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 15 ?? ?? ?? ?? 89 C6 64 44 8B 02 83 3D ?? ?? ?? ?? 00 74 0F F0 FF 0D ?? ?? ?? ?? 0F 85 B5 00 00 00 EB 0C FF 0D ?? ?? ?? ?? 0F 85 A7 00 00 00 64 44 89 02 48 83 C4 40 89 F0 5B C3 }
	condition:
		$1
}

rule file_1022_8_0 {
	meta:
		name = "__getprotoent_r"
		size = 202
		refs = "0017 __libc_multiple_threads 007a __nss_protocols_lookup2 0089 __nss_getent_r 0090 __libc_errno"
	strings:
		$1 = { 53 49 89 F2 49 89 F9 48 89 CB BE 01 00 00 00 31 C0 48 83 EC 40 83 3D ?? ?? ?? ?? 00 74 10 F0 0F B1 35 ?? ?? ?? ?? 0F 85 1A 01 00 00 EB 0D 0F B1 35 ?? ?? ?? ?? 0F 85 0B 01 00 00 41 B8 ?? ?? ?? ?? 48 89 54 24 20 4C 89 4C 24 10 48 C7 44 24 30 00 00 00 00 48 89 5C 24 28 41 B9 ?? ?? ?? ?? 4C 89 54 24 18 C7 44 24 08 00 00 00 00 B9 ?? ?? ?? ?? 48 C7 04 24 ?? ?? ?? ?? BA ?? ?? ?? ?? BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 15 ?? ?? ?? ?? 89 C6 64 44 8B 02 83 3D ?? ?? ?? ?? 00 74 0F F0 FF 0D ?? ?? ?? ?? 0F 85 B5 00 00 00 EB 0C FF 0D ?? ?? ?? ?? 0F 85 A7 00 00 00 64 44 89 02 48 83 C4 40 89 F0 5B C3 }
	condition:
		$1
}

rule file_734_8_0 {
	meta:
		name = "__getpwent_r"
		size = 202
		refs = "0017 __libc_multiple_threads 007a __nss_passwd_lookup2 0089 __nss_getent_r 0090 __libc_errno"
	strings:
		$1 = { 53 49 89 F2 49 89 F9 48 89 CB BE 01 00 00 00 31 C0 48 83 EC 40 83 3D ?? ?? ?? ?? 00 74 10 F0 0F B1 35 ?? ?? ?? ?? 0F 85 1A 01 00 00 EB 0D 0F B1 35 ?? ?? ?? ?? 0F 85 0B 01 00 00 41 B8 ?? ?? ?? ?? 48 89 54 24 20 4C 89 4C 24 10 48 C7 44 24 30 00 00 00 00 48 89 5C 24 28 41 B9 ?? ?? ?? ?? 4C 89 54 24 18 C7 44 24 08 00 00 00 00 B9 ?? ?? ?? ?? 48 C7 04 24 00 00 00 00 BA ?? ?? ?? ?? BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 15 ?? ?? ?? ?? 89 C6 64 44 8B 02 83 3D ?? ?? ?? ?? 00 74 0F F0 FF 0D ?? ?? ?? ?? 0F 85 B5 00 00 00 EB 0C FF 0D ?? ?? ?? ?? 0F 85 A7 00 00 00 64 44 89 02 48 83 C4 40 89 F0 5B C3 }
	condition:
		$1
}

rule file_370_8_0 {
	meta:
		name = "__getrpcent_r"
		size = 202
		refs = "0017 __libc_multiple_threads 007a __nss_rpc_lookup2 0089 __nss_getent_r 0090 __libc_errno"
	strings:
		$1 = { 53 49 89 F2 49 89 F9 48 89 CB BE 01 00 00 00 31 C0 48 83 EC 40 83 3D ?? ?? ?? ?? 00 74 10 F0 0F B1 35 ?? ?? ?? ?? 0F 85 1A 01 00 00 EB 0D 0F B1 35 ?? ?? ?? ?? 0F 85 0B 01 00 00 41 B8 ?? ?? ?? ?? 48 89 54 24 20 4C 89 4C 24 10 48 C7 44 24 30 00 00 00 00 48 89 5C 24 28 41 B9 ?? ?? ?? ?? 4C 89 54 24 18 C7 44 24 08 00 00 00 00 B9 ?? ?? ?? ?? 48 C7 04 24 ?? ?? ?? ?? BA ?? ?? ?? ?? BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 15 ?? ?? ?? ?? 89 C6 64 44 8B 02 83 3D ?? ?? ?? ?? 00 74 0F F0 FF 0D ?? ?? ?? ?? 0F 85 B5 00 00 00 EB 0C FF 0D ?? ?? ?? ?? 0F 85 A7 00 00 00 64 44 89 02 48 83 C4 40 89 F0 5B C3 }
	condition:
		$1
}

rule file_1390_8_0 {
	meta:
		name = "__getservent_r"
		size = 202
		refs = "0017 __libc_multiple_threads 007a __nss_services_lookup2 0089 __nss_getent_r 0090 __libc_errno"
	strings:
		$1 = { 53 49 89 F2 49 89 F9 48 89 CB BE 01 00 00 00 31 C0 48 83 EC 40 83 3D ?? ?? ?? ?? 00 74 10 F0 0F B1 35 ?? ?? ?? ?? 0F 85 1A 01 00 00 EB 0D 0F B1 35 ?? ?? ?? ?? 0F 85 0B 01 00 00 41 B8 ?? ?? ?? ?? 48 89 54 24 20 4C 89 4C 24 10 48 C7 44 24 30 00 00 00 00 48 89 5C 24 28 41 B9 ?? ?? ?? ?? 4C 89 54 24 18 C7 44 24 08 00 00 00 00 B9 ?? ?? ?? ?? 48 C7 04 24 ?? ?? ?? ?? BA ?? ?? ?? ?? BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 15 ?? ?? ?? ?? 89 C6 64 44 8B 02 83 3D ?? ?? ?? ?? 00 74 0F F0 FF 0D ?? ?? ?? ?? 0F 85 B5 00 00 00 EB 0C FF 0D ?? ?? ?? ?? 0F 85 A7 00 00 00 64 44 89 02 48 83 C4 40 89 F0 5B C3 }
	condition:
		$1
}

rule file_537_8_0 {
	meta:
		name = "__getspent_r"
		size = 202
		refs = "0017 __libc_multiple_threads 007a __nss_shadow_lookup2 0089 __nss_getent_r 0090 __libc_errno"
	strings:
		$1 = { 53 49 89 F2 49 89 F9 48 89 CB BE 01 00 00 00 31 C0 48 83 EC 40 83 3D ?? ?? ?? ?? 00 74 10 F0 0F B1 35 ?? ?? ?? ?? 0F 85 1A 01 00 00 EB 0D 0F B1 35 ?? ?? ?? ?? 0F 85 0B 01 00 00 41 B8 ?? ?? ?? ?? 48 89 54 24 20 4C 89 4C 24 10 48 C7 44 24 30 00 00 00 00 48 89 5C 24 28 41 B9 ?? ?? ?? ?? 4C 89 54 24 18 C7 44 24 08 00 00 00 00 B9 ?? ?? ?? ?? 48 C7 04 24 00 00 00 00 BA ?? ?? ?? ?? BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 15 ?? ?? ?? ?? 89 C6 64 44 8B 02 83 3D ?? ?? ?? ?? 00 74 0F F0 FF 0D ?? ?? ?? ?? 0F 85 B5 00 00 00 EB 0C FF 0D ?? ?? ?? ?? 0F 85 A7 00 00 00 64 44 89 02 48 83 C4 40 89 F0 5B C3 }
	condition:
		$1
}

rule file_129_0_0 {
	meta:
		name = "__gethostname"
		size = 165
		refs = "0025 uname 003b strlen 0054 memcpy 0093 __libc_errno"
	strings:
		$1 = { 48 89 5C 24 E0 4C 89 6C 24 F8 49 89 FD 48 89 6C 24 E8 4C 89 64 24 F0 48 81 EC B8 01 00 00 48 89 E7 48 89 F3 E8 ?? ?? ?? ?? 85 C0 BA FF FF FF FF 75 2D 4C 8D 64 24 41 4C 89 E7 E8 ?? ?? ?? ?? 48 8D 68 01 48 89 DA 4C 89 E6 4C 89 EF 48 39 DD 48 0F 46 D5 E8 ?? ?? ?? ?? 31 D2 48 39 DD 77 31 89 D0 48 8B 9C 24 98 01 00 00 48 8B AC 24 A0 01 00 00 4C 8B A4 24 A8 01 00 00 4C 8B AC 24 B0 01 00 00 48 81 C4 B8 01 00 00 C3 0F 1F 80 00 00 00 00 48 8B 05 ?? ?? ?? ?? BA FF FF FF FF 64 C7 00 24 00 00 00 EB BA }
	condition:
		$1
}

rule file_130_0_0 {
	meta:
		name = "posix_spawnattr_setsigdefault"
		size = 133
	strings:
		$1 = { 48 8B 16 31 C0 48 89 57 08 48 8B 56 08 48 89 57 10 48 8B 56 10 48 89 57 18 48 8B 56 18 48 89 57 20 48 8B 56 20 48 89 57 28 48 8B 56 28 48 89 57 30 48 8B 56 30 48 89 57 38 48 8B 56 38 48 89 57 40 48 8B 56 40 48 89 57 48 48 8B 56 48 48 89 57 50 48 8B 56 50 48 89 57 58 48 8B 56 58 48 89 57 60 48 8B 56 60 48 89 57 68 48 8B 56 68 48 89 57 70 48 8B 56 70 48 89 57 78 48 8B 56 78 48 89 97 80 00 00 00 C3 }
	condition:
		$1
}

rule file_131_0_0 {
	meta:
		name = "fchflags"
		size = 45
		refs = "0005 __libc_errno"
	strings:
		$1 = { 85 FF 48 8B 05 ?? ?? ?? ?? 78 15 64 C7 00 26 00 00 00 B8 FF FF FF FF C3 0F 1F 84 00 00 00 00 00 64 C7 00 16 00 00 00 B8 FF FF FF FF C3 }
	condition:
		$1
}

rule file_132_0_0 {
	meta:
		name = "__socket"
		size = 20
		refs = "000f __syscall_error"
	strings:
		$1 = { B8 29 00 00 00 0F 05 48 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_133_0_0 {
	meta:
		name = "open_translit"
		size = 184
		refs = "000e __libc_dlopen_mode 0029 __libc_dlsym 0048 __libc_dlclose"
	strings:
		$1 = { 53 48 89 FB 48 8B 7F 40 BE 01 00 00 80 E8 ?? ?? ?? ?? 48 89 C7 48 89 43 48 B8 01 00 00 00 48 85 FF 74 36 BE ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 85 C0 74 11 48 8D 53 18 48 8D 73 10 48 8B 3B FF D0 85 C0 74 1D 48 8B 7B 48 E8 ?? ?? ?? ?? 48 C7 43 48 00 00 00 00 B8 01 00 00 00 5B C3 0F 1F 44 00 00 48 8B 7B 48 BE ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 85 C0 48 89 43 20 74 CC 48 8B 7B 48 BE ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 7B 48 48 89 43 30 BE ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 7B 48 48 89 43 28 BE ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 43 50 01 00 00 00 48 89 43 38 31 C0 5B C3 }
	condition:
		$1
}

rule file_133_2_0 {
	meta:
		name = "_L_lock_770"
		size = 31
		refs = "000f __lll_lock_wait_private"
	strings:
		$1 = { 48 8D 3D ?? ?? ?? ?? 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 A9 FD FF FF }
	condition:
		$1
}

rule file_133_3_0 {
	meta:
		name = "_L_unlock_801"
		size = 31
		refs = "000f __lll_unlock_wake_private"
	strings:
		$1 = { 48 8D 3D ?? ?? ?? ?? 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 DC FD FF FF }
	condition:
		$1
}

rule file_133_4_0 {
	meta:
		name = "__gconv_transliterate"
		size = 1149
		refs = "004f _nl_current_LC_CTYPE 02f2 _dl_mcount_wrapper_check"
	strings:
		$1 = { 41 57 4D 89 CB 41 56 41 55 41 54 55 53 48 81 EC 98 00 00 00 48 83 3F 00 49 8B 00 48 8B 57 28 48 89 7C 24 18 48 89 74 24 28 4C 89 44 24 48 48 89 44 24 30 48 89 54 24 40 74 12 48 C1 CA 11 64 48 33 14 25 30 00 00 00 48 89 54 24 40 48 8B 0D ?? ?? ?? ?? 64 4C 8B 01 49 8B 30 8B 86 28 02 00 00 48 85 C0 0F 84 E7 00 00 00 48 8B 96 30 02 00 00 48 8B 8E 40 02 00 00 4C 8B AE 38 02 00 00 4C 8B BE 48 02 00 00 48 89 54 24 50 48 8B 54 24 30 48 89 4C 24 58 48 83 C2 04 49 39 D3 0F 82 9F 01 00 00 48 89 44 24 38 48 C7 44 24 20 00 00 00 00 90 4C 8B 54 24 38 4C 03 54 24 20 31 ED 48 8B 44 24 50 49 D1 EA 46 8B 24 90 44 89 E0 41 8B 54 85 00 48 8B 44 24 30 EB 2B 66 0F 1F 84 00 00 00 00 00 83 C5 01 42 8D 54 25 00 41 8B 54 95 00 85 D2 0F 84 7D 01 00 00 48 83 C0 04 49 39 C3 0F 86 4F 01 00 00 39 10 48 89 C1 74 D7 85 ED 0F 85 5D 01 00 00 49 39 CB 0F 86 46 01 00 00 44 01 E5 8B 01 41 39 44 AD 00 0F 82 36 01 00 00 4C 89 54 24 38 48 8B 54 24 38 48 39 54 24 20 0F 82 71 FF FF FF 48 8B 0D ?? ?? ?? ?? 64 4C 8B 01 49 8B 30 0F 1F 00 8B 86 60 02 00 00 85 C0 75 2B 8B 86 50 02 00 00 41 BA 06 00 00 00 85 C0 0F 85 91 00 00 00 66 90 48 81 C4 98 00 00 00 44 89 D0 5B 5D 41 5C 41 5D 41 5E 41 5F C3 48 8B 54 24 48 48 8B 8E 68 02 00 00 4C 8B 12 48 8B 54 24 30 48 83 C2 04 41 8B 3A 49 39 D3 0F 82 97 00 00 00 85 C0 7E AD 83 E8 01 48 8D 44 40 03 4C 8D 0C 81 EB 2A 0F 1F 44 00 00 3B 79 04 77 13 89 FA 29 C2 89 D0 31 D2 F7 71 08 85 D2 0F 84 85 02 00 00 48 83 C1 0C 4C 39 C9 0F 84 75 FF FF FF 8B 01 39 C7 73 D5 8B 86 50 02 00 00 41 BA 06 00 00 00 85 C0 0F 84 71 FF FF FF 48 8B 9E 58 02 00 00 48 89 9C 24 80 00 00 00 49 8B 00 8B A8 50 02 00 00 48 8B 44 24 30 48 83 C0 04 49 39 C3 0F 83 98 01 00 00 31 C0 4C 39 5C 24 30 0F 95 C0 8D 44 40 04 41 89 C2 E9 31 FF FF FF 90 4C 39 5C 24 30 41 BA 04 00 00 00 0F 84 1F FF FF FF 41 BA 07 00 00 00 E9 14 FF FF FF 0F 1F 40 00 49 83 C2 01 4C 89 54 24 20 E9 C1 FE FF FF 85 D2 75 DF 48 8B 54 24 58 4C 89 6C 24 60 44 89 64 24 74 4C 8B A4 24 D0 00 00 00 89 6C 24 70 4C 89 54 24 68 46 8B 34 92 4C 89 5C 24 78 44 89 F0 45 89 F5 4C 8B 74 24 40 41 8B 14 87 66 0F 1F 44 00 00 85 D2 49 8D 34 87 0F 84 AE 00 00 00 49 8D 44 87 04 31 DB 0F 1F 44 00 00 48 89 C5 48 83 C0 04 8B 50 FC 48 83 C3 01 85 D2 75 EE 49 8B 04 24 4C 89 F7 48 89 B4 24 80 00 00 00 48 89 84 24 88 00 00 00 E8 ?? ?? ?? ?? 45 31 C9 C7 44 24 08 00 00 00 00 C7 04 24 00 00 00 00 4C 8D 84 24 88 00 00 00 48 89 E9 48 8D 94 24 80 00 00 00 48 8B 74 24 28 48 8B 7C 24 18 41 FF D6 83 F8 06 75 47 45 8D 6C 1D 01 44 89 E8 41 8B 14 87 85 D2 0F 85 6F FF FF FF 8B 6C 24 70 48 8B 54 24 30 4C 8B 6C 24 60 4C 8B 54 24 68 44 8B 64 24 74 4C 8B 5C 24 78 48 63 C5 48 8D 0C 82 E9 A7 FD FF FF 48 89 F5 31 DB E9 66 FF FF FF 83 F8 04 8B 6C 24 70 41 89 C2 74 21 83 F8 05 0F 84 E7 FD FF FF 48 8B 84 24 88 00 00 00 4C 8B 9C 24 D0 00 00 00 49 89 03 E9 CF FD FF FF 4C 8B 5C 24 48 48 63 C5 45 30 D2 48 C1 E0 02 49 01 03 48 8B 84 24 D8 00 00 00 48 83 00 01 EB C8 4C 8B 9C 24 D0 00 00 00 48 8B 7C 24 40 49 8B 03 44 89 54 24 10 48 89 84 24 88 00 00 00 E8 ?? ?? ?? ?? 45 31 C9 48 8D 0C AB C7 44 24 08 00 00 00 00 C7 04 24 00 00 00 00 4C 8D 84 24 88 00 00 00 48 8D 94 24 80 00 00 00 48 8B 74 24 28 48 8B 7C 24 18 4C 8B 5C 24 40 41 FF D3 83 F8 06 44 8B 54 24 10 0F 84 47 FD FF FF 83 F8 04 75 17 48 8B 84 24 D8 00 00 00 4C 8B 5C 24 48 48 83 00 01 49 83 03 04 31 C0 48 8B 94 24 88 00 00 00 4C 8B 9C 24 D0 00 00 00 49 89 13 E9 DA FD FF FF 4C 8B 5C 24 48 48 8B 84 24 D8 00 00 00 49 83 C2 04 4D 89 13 48 83 00 01 45 31 D2 E9 F3 FC FF FF }
	condition:
		$1
}

rule file_133_5_0 {
	meta:
		name = "__gconv_translit_find"
		size = 660
		refs = "0038 __libc_multiple_threads 006a __tfind 00f4 strlen 00fb __gconv_path_elem 012c memcmp 0139 __gconv_max_path_elem_len 0143 malloc 016c mempcpy 01b2 stpcpy 01f4 __tsearch 026d __gconv_get_path 0290 __assert_fail"
	strings:
		$1 = { 48 89 5C 24 D0 48 89 6C 24 D8 4C 89 64 24 E0 4C 89 6C 24 E8 4C 89 74 24 F0 4C 89 7C 24 F8 48 83 EC 48 48 83 3F 00 0F 84 4F 02 00 00 48 89 FB BE 01 00 00 00 31 C0 83 3D ?? ?? ?? ?? 00 74 10 F0 0F B1 35 ?? ?? ?? ?? 0F 85 47 02 00 00 EB 0D 0F B1 35 ?? ?? ?? ?? 0F 85 38 02 00 00 BA ?? ?? ?? ?? BE ?? ?? ?? ?? 48 89 DF E8 ?? ?? ?? ?? 48 85 C0 49 89 C4 74 7A 48 8B 38 48 8B 47 48 48 85 C0 74 63 31 ED 48 83 F8 FF 74 4E 83 3D ?? ?? ?? ?? 00 74 0F F0 FF 0D ?? ?? ?? ?? 0F 85 13 02 00 00 EB 0C FF 0D ?? ?? ?? ?? 0F 85 05 02 00 00 89 E8 48 8B 5C 24 18 48 8B 6C 24 20 4C 8B 64 24 28 4C 8B 6C 24 30 4C 8B 74 24 38 4C 8B 7C 24 40 48 83 C4 48 C3 0F 1F 44 00 00 E8 D3 F9 FF FF 85 C0 0F 84 33 01 00 00 BD 01 00 00 00 EB 9E 0F 1F 40 00 48 8B 3B E8 ?? ?? ?? ?? 48 83 3D ?? ?? ?? ?? 00 4C 8D 70 01 0F 84 5D 01 00 00 49 83 FE 04 41 BF 01 00 00 00 76 20 48 8B 13 BE ?? ?? ?? ?? 45 31 FF 48 8D 7C 02 FD BA 03 00 00 00 E8 ?? ?? ?? ?? 85 C0 41 0F 95 C7 48 8B 05 ?? ?? ?? ?? 4A 8D 7C 70 5B E8 ?? ?? ?? ?? 48 85 C0 49 89 C4 74 96 31 C0 B9 0B 00 00 00 4C 89 E7 F3 48 AB 49 8D 7C 24 58 4C 89 F2 49 89 3C 24 48 8B 33 E8 ?? ?? ?? ?? 48 8B 2D ?? ?? ?? ?? 48 89 C7 49 89 44 24 40 48 8B 75 00 48 85 F6 75 26 EB 4E 66 0F 1F 44 00 00 4C 89 E7 E8 18 F9 FF FF 85 C0 74 74 48 83 C5 10 48 8B 75 00 48 85 F6 74 2F 49 8B 7C 24 40 4C 8B 2B E8 ?? ?? ?? ?? 4C 89 F2 48 89 C7 4C 89 EE E8 ?? ?? ?? ?? 45 85 FF 74 C7 C7 00 2E 73 6F 00 EB BF 0F 1F 80 00 00 00 00 49 C7 44 24 40 00 00 00 00 BD 01 00 00 00 BA ?? ?? ?? ?? BE ?? ?? ?? ?? 4C 89 E7 E8 ?? ?? ?? ?? 48 85 C0 B8 01 00 00 00 0F 44 E8 E9 82 FE FF FF 0F 1F 84 00 00 00 00 00 31 ED EB D2 0F 1F 40 00 49 8B 04 24 48 8B 10 48 89 13 48 8B 50 08 48 89 53 08 48 8B 50 10 48 89 53 10 48 8B 50 18 48 89 53 18 48 8B 50 20 48 89 53 20 48 8B 50 28 48 89 53 28 48 8B 50 30 48 89 53 30 48 8B 40 38 48 89 43 38 49 8B 04 24 83 40 50 01 E9 23 FE FF FF 48 89 44 24 08 E8 ?? ?? ?? ?? 48 8B 44 24 08 E9 8F FE FF FF B9 ?? ?? ?? ?? BA 4C 01 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_134_0_0 {
	meta:
		name = "_itoa_word"
		size = 203
		refs = "0004 _itoa_upper_digits 0009 _itoa_lower_digits"
	strings:
		$1 = { 85 C9 41 B8 ?? ?? ?? ?? B8 ?? ?? ?? ?? 4C 0F 44 C0 83 FA 0A 74 7A 83 FA 10 74 35 83 FA 08 89 D1 74 4E 66 0F 1F 44 00 00 48 89 F8 31 D2 48 83 EE 01 48 F7 F1 41 0F B6 14 10 48 85 C0 48 89 C7 88 16 75 E5 48 89 F0 C3 66 0F 1F 84 00 00 00 00 00 48 89 F8 48 C1 EF 04 48 83 EE 01 83 E0 0F 48 85 FF 41 0F B6 04 00 88 06 75 E6 EB D7 0F 1F 40 00 48 89 F8 48 C1 EF 03 48 83 EE 01 83 E0 07 48 85 FF 41 0F B6 04 00 88 06 75 E6 EB B7 0F 1F 40 00 48 B9 CD CC CC CC CC CC CC CC 66 0F 1F 44 00 00 48 89 F8 48 83 EE 01 48 F7 E1 48 C1 EA 03 48 8D 04 92 48 01 C0 48 29 C7 48 85 D2 41 0F B6 04 38 48 89 D7 88 06 75 D9 48 89 F0 C3 }
	condition:
		$1
}

rule file_134_1_0 {
	meta:
		name = "_fitoa_word"
		size = 83
		refs = "000e _itoa_word"
	strings:
		$1 = { 53 48 89 F3 48 83 EC 20 48 8D 74 24 20 E8 ?? ?? ?? ?? 48 8D 54 24 20 48 39 D0 73 2E 48 89 C2 48 89 D9 66 0F 1F 44 00 00 0F B6 3A 48 8D 74 24 20 48 83 C2 01 48 83 C1 01 40 88 79 FF 48 39 F2 75 E7 48 89 F2 48 29 C2 48 01 D3 48 83 C4 20 48 89 D8 5B C3 }
	condition:
		$1
}

rule file_135_0_0 {
	meta:
		name = "__setsid"
		size = 20
		refs = "000f __syscall_error"
	strings:
		$1 = { B8 70 00 00 00 0F 05 48 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_137_0_0 {
	meta:
		name = "__nscd_getgrouplist"
		size = 848
		refs = "001d strlen 002b __gr_map_handle 003f __nscd_get_map_ref 0067 __nscd_cache_search 0179 __nscd_open_socket 01d8 memcpy 0239 __nscd_unmap 0266 realloc 02a7 __readall 02e7 __nss_not_use_nscd_group 030c __assert_fail"
	strings:
		$1 = { 41 57 41 56 49 89 D6 41 55 41 89 F5 41 54 49 89 FC 55 48 89 CD 53 31 DB 48 83 EC 48 E8 ?? ?? ?? ?? 48 8D 4C 24 2C 48 83 C0 01 BA ?? ?? ?? ?? BE ?? ?? ?? ?? BF 0C 00 00 00 48 89 44 24 18 E8 ?? ?? ?? ?? 49 89 C7 49 83 FF FF 0F 84 10 01 00 00 48 8B 54 24 18 41 B8 0C 00 00 00 4C 89 F9 4C 89 E6 BF 0F 00 00 00 E8 ?? ?? ?? ?? 48 85 C0 0F 84 EC 00 00 00 48 8B 50 18 48 63 48 20 4C 8D 40 24 48 89 54 24 30 48 63 50 04 89 4C 24 38 48 8D 7C 10 18 49 8B 17 8B 44 24 2C 8B 72 08 39 C6 0F 85 2B 02 00 00 49 8D 0C 88 48 39 CF 0F 82 29 02 00 00 44 8B 54 24 34 B9 FF FF FF FF 41 83 FA 01 0F 84 D5 00 00 00 41 83 FA FF 0F 84 41 02 00 00 49 83 3E 00 0F 8E 5E 02 00 00 48 8B 45 00 45 31 C0 49 63 D0 45 8D 50 01 44 89 2C 90 83 F9 FF 74 0A 48 63 F9 B8 03 00 00 00 0F 05 49 83 FF FF 74 1A 49 8B 17 8B 44 24 2C 8B 52 08 39 C2 75 1E F0 41 83 6F 18 01 0F 84 16 01 00 00 48 83 C4 48 44 89 D0 5B 5D 41 5C 41 5D 41 5E 41 5F C3 89 54 24 2C 83 E2 01 75 12 83 C3 01 83 FB 05 74 0A 41 83 FA FF 0F 85 FF FE FF FF F0 41 83 6F 18 01 0F 84 CD 01 00 00 41 83 FA FF 74 C1 49 C7 C7 FF FF FF FF 48 8B 74 24 18 48 8D 4C 24 30 41 B8 0C 00 00 00 BA 0F 00 00 00 4C 89 E7 E8 ?? ?? ?? ?? 83 F8 FF 89 C1 0F 84 5D 01 00 00 44 8B 54 24 34 45 31 C0 41 83 FA 01 0F 85 2B FF FF FF 44 8B 54 24 38 45 85 D2 0F 88 4F 01 00 00 41 8D 42 01 48 98 49 39 06 0F 8C 99 00 00 00 49 63 D2 48 8B 7D 00 48 C1 E2 02 4D 85 C0 0F 84 D2 00 00 00 4C 89 C6 89 4C 24 08 44 89 54 24 10 E8 ?? ?? ?? ?? 8B 4C 24 08 44 8B 54 24 10 41 83 FA 00 0F 8C FC FE FF FF 0F 84 E4 FE FF FF 48 8B 45 00 44 39 28 0F 84 E9 FE FF FF 48 8D 50 04 45 31 C0 EB 13 0F 1F 44 00 00 48 83 C2 04 44 39 6A FC 0F 84 CD FE FF FF 41 83 C0 01 45 39 D0 75 E9 E9 B4 FE FF FF 0F 1F 40 00 4C 89 FF 44 89 54 24 10 E8 ?? ?? ?? ?? 44 8B 54 24 10 E9 D3 FE FF FF 66 0F 1F 84 00 00 00 00 00 48 8B 7D 00 48 8D 34 85 00 00 00 00 89 4C 24 08 4C 89 44 24 10 E8 ?? ?? ?? ?? 48 85 C0 48 89 C7 8B 4C 24 08 4C 8B 44 24 10 74 49 44 8B 54 24 38 48 89 45 00 41 8D 42 01 49 63 D2 48 C1 E2 02 4D 85 C0 48 98 49 89 06 0F 85 2E FF FF FF 48 89 FE 89 CF 89 4C 24 08 E8 ?? ?? ?? ?? 44 8B 54 24 38 8B 4C 24 08 49 63 D2 48 C1 E2 02 48 39 D0 0F 84 21 FF FF FF 41 BA FF FF FF FF E9 1C FE FF FF 41 BA FE FF FF FF E9 2D FE FF FF 41 BA FF FF FF FF E9 22 FE FF FF C7 05 ?? ?? ?? ?? 01 00 00 00 41 89 CA E9 03 FE FF FF B9 ?? ?? ?? ?? BA 64 00 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 01 00 00 00 E9 CC FD FF FF 90 4C 89 FF 44 89 54 24 10 E8 ?? ?? ?? ?? 44 8B 54 24 10 E9 1C FE FF FF B9 ?? ?? ?? ?? BA 8F 00 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_138_0_0 {
	meta:
		name = "__uselocale"
		size = 396
		refs = "0003 __libc_tsd_LOCALE 0019 _nl_global_locale 0026 _nl_current_LC_COLLATE_used 0032 _nl_current_LC_COLLATE 003f _nl_current_LC_CTYPE_used 004b _nl_current_LC_CTYPE 0054 _nl_current_LC_MONETARY_used 0060 _nl_current_LC_MONETARY 006d _nl_current_LC_NUMERIC_used 0079 _nl_current_LC_NUMERIC 0086 _nl_current_LC_TIME_used 0092 _nl_current_LC_TIME 009f _nl_current_LC_MESSAGES_used 00ab _nl_current_LC_MESSAGES 00b8 _nl_current_LC_PAPER_used 00c4 _nl_current_LC_PAPER 00d1 _nl_current_LC_NAME_used 00dd _nl_current_LC_NAME 00ea _nl_current_LC_ADDRESS_used 00f6 _nl_current_LC_ADDRESS 0103 _nl_current_LC_TELEPHONE_used 010f _nl_current_LC_TELEPHONE 011c _nl_current_LC_MEASUREMENT_used 0128 _nl_current_LC_MEASUREMENT 0135 _nl_current_LC_IDENTIFICATION_used 0141 _nl_current_LC_IDENTIFICATION 0154 __libc_tsd_CTYPE_B 0163 __libc_tsd_CTYPE_TOLOWER 0172 __libc_tsd_CTYPE_TOUPPER"
	strings:
		$1 = { 48 8B 15 ?? ?? ?? ?? 48 85 FF 64 48 8B 02 0F 84 66 01 00 00 48 83 FF FF B9 ?? ?? ?? ?? 48 0F 44 F9 64 48 89 3A BA ?? ?? ?? ?? 48 85 D2 74 0F 48 8B 15 ?? ?? ?? ?? 48 8D 4F 18 64 48 89 0A BA ?? ?? ?? ?? 48 85 D2 74 0B 48 8B 15 ?? ?? ?? ?? 64 48 89 3A BA ?? ?? ?? ?? 48 85 D2 74 0F 48 8B 15 ?? ?? ?? ?? 48 8D 4F 20 64 48 89 0A BA ?? ?? ?? ?? 48 85 D2 74 0F 48 8B 15 ?? ?? ?? ?? 48 8D 4F 08 64 48 89 0A BA ?? ?? ?? ?? 48 85 D2 74 0F 48 8B 15 ?? ?? ?? ?? 48 8D 4F 10 64 48 89 0A BA ?? ?? ?? ?? 48 85 D2 74 0F 48 8B 15 ?? ?? ?? ?? 48 8D 4F 28 64 48 89 0A BA ?? ?? ?? ?? 48 85 D2 74 0F 48 8B 15 ?? ?? ?? ?? 48 8D 4F 38 64 48 89 0A BA ?? ?? ?? ?? 48 85 D2 74 0F 48 8B 15 ?? ?? ?? ?? 48 8D 4F 40 64 48 89 0A BA ?? ?? ?? ?? 48 85 D2 74 0F 48 8B 15 ?? ?? ?? ?? 48 8D 4F 48 64 48 89 0A BA ?? ?? ?? ?? 48 85 D2 74 0F 48 8B 15 ?? ?? ?? ?? 48 8D 4F 50 64 48 89 0A BA ?? ?? ?? ?? 48 85 D2 74 0F 48 8B 15 ?? ?? ?? ?? 48 8D 4F 58 64 48 89 0A BA ?? ?? ?? ?? 48 85 D2 74 0F 48 8B 15 ?? ?? ?? ?? 48 8D 4F 60 64 48 89 0A 48 8B 4F 68 48 8B 15 ?? ?? ?? ?? 64 48 89 0A 48 8B 4F 70 48 8B 15 ?? ?? ?? ?? 64 48 89 0A 48 8B 4F 78 48 8B 15 ?? ?? ?? ?? 64 48 89 0A 48 3D ?? ?? ?? ?? 48 C7 C2 FF FF FF FF 48 0F 44 C2 C3 }
	condition:
		$1
}

rule file_139_0_0 {
	meta:
		name = "xdr_int64_t"
		size = 212
	strings:
		$1 = { 48 89 5C 24 F0 48 89 6C 24 F8 48 83 EC 28 8B 07 48 89 FB 83 F8 01 74 58 72 1E 83 F8 02 0F 94 C0 0F B6 C0 48 8B 5C 24 18 48 8B 6C 24 20 48 83 C4 28 C3 66 0F 1F 44 00 00 48 8B 06 48 8D 74 24 08 48 89 C2 89 44 24 0C 48 8B 47 08 48 C1 FA 20 89 54 24 08 FF 50 48 85 C0 75 5E 31 C0 48 8B 5C 24 18 48 8B 6C 24 20 48 83 C4 28 C3 0F 1F 44 00 00 48 8B 47 08 48 89 F5 48 8D 74 24 08 FF 50 40 85 C0 74 D7 48 8B 43 08 48 8D 74 24 0C 48 89 DF FF 50 40 85 C0 74 C4 48 63 54 24 08 8B 44 24 0C 48 C1 E2 20 48 09 D0 48 89 45 00 B8 01 00 00 00 E9 6F FF FF FF 0F 1F 40 00 48 8B 43 08 48 8D 74 24 0C 48 89 DF FF 50 48 85 C0 0F 95 C0 0F B6 C0 E9 4F FF FF FF }
	condition:
		$1
}

rule file_139_2_0 {
	meta:
		name = "xdr_uint64_t"
		size = 212
	strings:
		$1 = { 48 89 5C 24 F0 48 89 6C 24 F8 48 83 EC 28 8B 07 48 89 FB 83 F8 01 74 58 72 1E 83 F8 02 0F 94 C0 0F B6 C0 48 8B 5C 24 18 48 8B 6C 24 20 48 83 C4 28 C3 66 0F 1F 44 00 00 48 8B 06 48 8D 74 24 08 48 89 C2 89 44 24 0C 48 8B 47 08 48 C1 EA 20 89 54 24 08 FF 50 48 85 C0 75 5E 31 C0 48 8B 5C 24 18 48 8B 6C 24 20 48 83 C4 28 C3 0F 1F 44 00 00 48 8B 47 08 48 89 F5 48 8D 74 24 08 FF 50 40 85 C0 74 D7 48 8B 43 08 48 8D 74 24 0C 48 89 DF FF 50 40 85 C0 74 C4 8B 44 24 08 8B 54 24 0C 48 C1 E0 20 48 09 D0 48 89 45 00 B8 01 00 00 00 E9 70 FF FF FF 0F 1F 44 00 00 48 8B 43 08 48 8D 74 24 0C 48 89 DF FF 50 48 85 C0 0F 95 C0 0F B6 C0 E9 4F FF FF FF }
	condition:
		$1
}

rule file_139_4_0 {
	meta:
		name = "xdr_int32_t"
		size = 50
		altNames = "xdr_uint32_t"
	strings:
		$1 = { 8B 07 83 F8 01 74 21 73 0F 48 8B 47 08 48 8B 40 48 FF E0 0F 1F 44 00 00 83 F8 02 0F 94 C0 0F B6 C0 C3 66 0F 1F 44 00 00 48 8B 47 08 48 8B 40 40 FF E0 }
	condition:
		$1
}

rule file_139_6_0 {
	meta:
		name = "xdr_int16_t"
		size = 105
	strings:
		$1 = { 53 48 83 EC 10 8B 07 83 F8 01 74 34 72 12 83 F8 02 0F 94 C0 0F B6 C0 48 83 C4 10 5B C3 0F 1F 00 0F BF 06 48 8D 74 24 0C 89 44 24 0C 48 8B 47 08 FF 50 48 48 83 C4 10 5B C3 0F 1F 80 00 00 00 00 48 8B 47 08 48 89 F3 48 8D 74 24 0C FF 50 40 89 C2 31 C0 85 D2 74 C0 8B 44 24 0C 66 89 03 48 83 C4 10 B8 01 00 00 00 5B C3 }
	condition:
		$1
}

rule file_139_7_0 {
	meta:
		name = "xdr_uint16_t"
		size = 105
	strings:
		$1 = { 53 48 83 EC 10 8B 07 83 F8 01 74 34 72 12 83 F8 02 0F 94 C0 0F B6 C0 48 83 C4 10 5B C3 0F 1F 00 0F B7 06 48 8D 74 24 0C 89 44 24 0C 48 8B 47 08 FF 50 48 48 83 C4 10 5B C3 0F 1F 80 00 00 00 00 48 8B 47 08 48 89 F3 48 8D 74 24 0C FF 50 40 89 C2 31 C0 85 D2 74 C0 8B 44 24 0C 66 89 03 48 83 C4 10 B8 01 00 00 00 5B C3 }
	condition:
		$1
}

rule file_139_8_0 {
	meta:
		name = "xdr_int8_t"
		size = 104
	strings:
		$1 = { 53 48 83 EC 10 8B 07 83 F8 01 74 34 72 12 83 F8 02 0F 94 C0 0F B6 C0 48 83 C4 10 5B C3 0F 1F 00 0F BE 06 48 8D 74 24 0C 89 44 24 0C 48 8B 47 08 FF 50 48 48 83 C4 10 5B C3 0F 1F 80 00 00 00 00 48 8B 47 08 48 89 F3 48 8D 74 24 0C FF 50 40 89 C2 31 C0 85 D2 74 C0 8B 44 24 0C 88 03 48 83 C4 10 B8 01 00 00 00 5B C3 }
	condition:
		$1
}

rule file_139_9_0 {
	meta:
		name = "xdr_uint8_t"
		size = 104
	strings:
		$1 = { 53 48 83 EC 10 8B 07 83 F8 01 74 34 72 12 83 F8 02 0F 94 C0 0F B6 C0 48 83 C4 10 5B C3 0F 1F 00 0F B6 06 48 8D 74 24 0C 89 44 24 0C 48 8B 47 08 FF 50 48 48 83 C4 10 5B C3 0F 1F 80 00 00 00 00 48 8B 47 08 48 89 F3 48 8D 74 24 0C FF 50 40 89 C2 31 C0 85 D2 74 C0 8B 44 24 0C 88 03 48 83 C4 10 B8 01 00 00 00 5B C3 }
	condition:
		$1
}

rule file_140_0_0 {
	meta:
		name = "__remap_file_pages"
		size = 23
		refs = "0012 __syscall_error"
	strings:
		$1 = { 49 89 CA B8 D8 00 00 00 0F 05 48 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_141_0_0 {
	meta:
		name = "_L_lock_46"
		size = 27
		refs = "000b __lll_lock_wait_private"
	strings:
		$1 = { 49 8D 38 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 27 FF FF FF }
	condition:
		$1
}

rule file_141_1_0 {
	meta:
		name = "_L_unlock_113"
		size = 27
		refs = "000b __lll_unlock_wake_private"
		altNames = "_L_unlock_78"
	strings:
		$1 = { 48 8D 3A 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 75 FF FF FF }
	condition:
		$1
}

rule file_141_3_0 {
	meta:
		name = "___vfprintf_chk"
		size = 288
		refs = "0044 __libc_multiple_threads 0081 vfprintf 011c _Unwind_Resume"
	strings:
		$1 = { 48 89 5C 24 E8 48 89 6C 24 F0 49 89 D2 4C 89 64 24 F8 48 83 EC 18 8B 07 48 89 FB 89 F5 48 89 CA 25 00 80 00 00 75 4B 4C 8B 87 88 00 00 00 64 4C 8B 24 25 10 00 00 00 4D 3B 60 08 74 30 BE 01 00 00 00 83 3D ?? ?? ?? ?? 00 74 0D F0 41 0F B1 30 0F 85 CA 00 00 00 EB 0A 41 0F B1 30 0F 85 BE 00 00 00 4C 8B 83 88 00 00 00 4D 89 60 08 41 83 40 04 01 85 ED 7E 04 83 4B 74 04 4C 89 D6 48 89 DF E8 ?? ?? ?? ?? 85 ED 89 C6 8B 53 74 7E 06 83 E2 FB 89 53 74 83 E2 EB F7 03 00 80 00 00 89 53 74 75 29 48 8B 93 88 00 00 00 83 6A 04 01 75 1C 48 C7 42 08 00 00 00 00 83 3D ?? ?? ?? ?? 00 74 07 F0 FF 0A 75 76 EB 04 FF 0A 75 70 89 F0 48 8B 1C 24 48 8B 6C 24 08 4C 8B 64 24 10 48 83 C4 18 C3 83 63 74 EB F7 03 00 80 00 00 48 89 C6 75 29 48 8B 93 88 00 00 00 83 6A 04 01 75 1C 48 C7 42 08 00 00 00 00 83 3D ?? ?? ?? ?? 00 74 07 F0 FF 0A 75 44 EB 04 FF 0A 75 3E 48 89 F7 E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1261_3_0 {
	meta:
		name = "__vfwprintf_chk"
		size = 288
		refs = "0044 __libc_multiple_threads 0081 _IO_vfwprintf 011c _Unwind_Resume"
	strings:
		$1 = { 48 89 5C 24 E8 48 89 6C 24 F0 49 89 D2 4C 89 64 24 F8 48 83 EC 18 8B 07 48 89 FB 89 F5 48 89 CA 25 00 80 00 00 75 4B 4C 8B 87 88 00 00 00 64 4C 8B 24 25 10 00 00 00 4D 3B 60 08 74 30 BE 01 00 00 00 83 3D ?? ?? ?? ?? 00 74 0D F0 41 0F B1 30 0F 85 CA 00 00 00 EB 0A 41 0F B1 30 0F 85 BE 00 00 00 4C 8B 83 88 00 00 00 4D 89 60 08 41 83 40 04 01 85 ED 7E 04 83 4B 74 04 4C 89 D6 48 89 DF E8 ?? ?? ?? ?? 85 ED 89 C6 8B 53 74 7E 06 83 E2 FB 89 53 74 83 E2 EB F7 03 00 80 00 00 89 53 74 75 29 48 8B 93 88 00 00 00 83 6A 04 01 75 1C 48 C7 42 08 00 00 00 00 83 3D ?? ?? ?? ?? 00 74 07 F0 FF 0A 75 76 EB 04 FF 0A 75 70 89 F0 48 8B 1C 24 48 8B 6C 24 08 4C 8B 64 24 10 48 83 C4 18 C3 83 63 74 EB F7 03 00 80 00 00 48 89 C6 75 29 48 8B 93 88 00 00 00 83 6A 04 01 75 1C 48 C7 42 08 00 00 00 00 83 3D ?? ?? ?? ?? 00 74 07 F0 FF 0A 75 44 EB 04 FF 0A 75 3E 48 89 F7 E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_142_0_0 {
	meta:
		name = "sigemptyset"
		size = 204
		refs = "00bb __libc_errno"
	strings:
		$1 = { 48 85 FF 0F 84 AF 00 00 00 40 F6 C7 01 BA 80 00 00 00 75 7C 40 F6 C7 02 0F 85 82 00 00 00 40 F6 C7 04 75 54 89 D1 31 C0 C1 E9 03 F6 C2 04 F3 48 AB 75 2D F6 C2 02 75 18 83 E2 01 75 0B 31 C0 90 C3 0F 1F 80 00 00 00 00 C6 07 00 31 C0 C3 66 90 66 C7 07 00 00 48 83 C7 02 83 E2 01 74 DF EB E8 C7 07 00 00 00 00 48 83 C7 04 F6 C2 02 74 C9 EB DF 0F 1F 80 00 00 00 00 C7 07 00 00 00 00 83 EA 04 48 83 C7 04 EB 9D 66 0F 1F 84 00 00 00 00 00 C6 07 00 B2 7F 48 83 C7 01 E9 76 FF FF FF 66 90 66 C7 07 00 00 83 EA 02 48 83 C7 02 E9 6D FF FF FF 0F 1F 80 00 00 00 00 48 8B 05 ?? ?? ?? ?? 64 C7 00 16 00 00 00 B8 FF FF FF FF C3 }
	condition:
		$1
}

rule file_143_0_0 {
	meta:
		name = "w_addword"
		size = 201
		refs = "0032 realloc 008b calloc 00be free"
	strings:
		$1 = { 48 89 5C 24 E8 48 89 6C 24 F0 48 89 FB 4C 89 64 24 F8 48 83 EC 18 48 85 F6 74 65 48 8B 07 48 03 47 10 48 89 F5 48 8B 7F 08 48 8D 34 C5 10 00 00 00 E8 ?? ?? ?? ?? 48 85 C0 48 89 C1 0F 84 80 00 00 00 48 8B 03 48 8B 53 10 48 89 4B 08 48 8D 34 10 48 83 C0 01 48 01 C2 48 89 2C F1 48 8B 4B 08 48 89 03 31 C0 48 C7 04 D1 00 00 00 00 48 8B 1C 24 48 8B 6C 24 08 4C 8B 64 24 10 48 83 C4 18 C3 BE 01 00 00 00 BF 01 00 00 00 E8 ?? ?? ?? ?? 48 85 C0 49 89 C4 48 89 C5 74 28 48 8B 03 48 03 43 10 48 8B 7B 08 48 8D 34 C5 10 00 00 00 E8 ?? ?? ?? ?? 48 85 C0 48 89 C1 75 88 4C 89 E7 E8 ?? ?? ?? ?? B8 01 00 00 00 EB A4 }
	condition:
		$1
}

rule file_143_1_0 {
	meta:
		name = "w_addchar"
		size = 173
		refs = "0071 realloc 008e free 00a9 __assert_fail"
	strings:
		$1 = { 48 89 5C 24 E8 48 89 6C 24 F0 48 89 F5 4C 89 64 24 F8 48 83 EC 18 48 8B 36 48 3B 32 48 89 FB 41 89 CC 74 34 48 85 FF 74 15 44 88 24 33 48 8B 45 00 48 8D 50 01 48 89 55 00 C6 44 03 01 00 48 89 D8 48 8B 6C 24 08 48 8B 1C 24 4C 8B 64 24 10 48 83 C4 18 C3 0F 1F 40 00 48 85 FF 74 05 48 85 F6 74 32 48 8D 46 64 48 89 DF 48 83 C6 65 48 89 02 E8 ?? ?? ?? ?? 48 85 C0 74 0E 48 8B 75 00 48 89 C3 EB A6 0F 1F 44 00 00 48 89 DF 31 DB E8 ?? ?? ?? ?? EB AA B9 ?? ?? ?? ?? BA 65 00 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_143_2_0 {
	meta:
		name = "parse_backslash"
		size = 103
	strings:
		$1 = { 53 48 89 FB 48 83 EC 10 49 8B 00 0F BE 4C 01 01 48 8D 78 01 B8 05 00 00 00 84 C9 74 25 80 F9 0A 74 2E 48 8B 3B 4C 89 44 24 08 E8 21 FF FF FF 48 85 C0 48 89 03 4C 8B 44 24 08 74 24 49 83 00 01 31 C0 48 83 C4 10 5B C3 0F 1F 84 00 00 00 00 00 49 89 38 48 83 C4 10 30 C0 5B C3 0F 1F 44 00 00 B8 01 00 00 00 EB DB }
	condition:
		$1
}

rule file_143_3_0 {
	meta:
		name = "parse_qtd_backslash"
		size = 255
	strings:
		$1 = { 48 89 5C 24 D8 4C 89 64 24 E8 4C 89 C3 4C 89 6C 24 F0 4C 89 74 24 F8 49 89 FC 48 89 6C 24 E0 48 83 EC 28 4D 8B 00 49 89 D6 49 89 F5 46 0F B6 4C 01 01 49 8D 50 01 41 80 F9 24 0F 84 80 00 00 00 48 89 CD 7E 5B 41 80 F9 5C 74 75 41 80 F9 60 74 6F 42 0F BE 4C 05 00 49 8B 3C 24 4C 89 F2 4C 89 EE E8 7A FE FF FF 48 85 C0 49 89 04 24 74 21 48 8B 13 4C 89 EE 48 89 C7 0F BE 4C 15 01 4C 89 F2 E8 5B FE FF FF 48 85 C0 49 89 04 24 75 4E 66 90 B8 01 00 00 00 EB 4B 66 0F 1F 84 00 00 00 00 00 41 80 F9 22 74 1A 7F A9 45 84 C9 B8 05 00 00 00 74 30 41 80 F9 0A 75 99 48 89 13 31 C0 EB 23 90 49 8B 3C 24 41 0F BE C9 4C 89 F2 4C 89 EE E8 0D FE FF FF 48 85 C0 49 89 04 24 74 B4 48 83 03 01 31 C0 48 8B 1C 24 48 8B 6C 24 08 4C 8B 64 24 10 4C 8B 6C 24 18 4C 8B 74 24 20 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_143_4_0 {
	meta:
		name = "w_addmem"
		size = 213
		refs = "0060 realloc 007a mempcpy 00b6 free 00d1 __assert_fail"
	strings:
		$1 = { 48 89 5C 24 E0 48 89 6C 24 E8 48 89 FB 4C 89 64 24 F0 4C 89 6C 24 F8 48 83 EC 28 48 8B 3E 48 8B 02 4C 89 C5 49 89 F4 49 89 CD 49 01 F8 49 39 C0 76 76 48 85 DB 74 09 48 85 C0 0F 84 7C 00 00 00 48 8D 7C 2D 00 B9 64 00 00 00 48 83 FF 64 48 0F 42 F9 48 01 F8 48 89 DF 48 8D 70 01 48 89 02 E8 ?? ?? ?? ?? 48 85 C0 74 47 49 8B 3C 24 48 89 C3 48 01 DF 48 89 EA 4C 89 EE E8 ?? ?? ?? ?? C6 00 00 49 01 2C 24 48 89 D8 48 8B 6C 24 10 48 8B 5C 24 08 4C 8B 64 24 18 4C 8B 6C 24 20 48 83 C4 28 C3 0F 1F 80 00 00 00 00 48 85 DB 75 C3 EB D6 90 48 89 DF 31 DB E8 ?? ?? ?? ?? EB C9 B9 ?? ?? ?? ?? BA 80 00 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_143_5_0 {
	meta:
		name = "exec_comm"
		size = 1754
		refs = "004b __have_sock_cloexec 0064 __pipe2 00b4 __pipe 00c2 __fork 00e9 __close 0110 __read 013c strchr 0203 __libc_errno 022b __waitpid 02b3 free 03ea __kill 0547 __dup2 0573 __open 0595 __fxstat64 05c8 _exit 064d __unsetenv 065d __environ 066c __execve 0671 abort 06d1 __fcntl"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 53 48 81 EC 88 01 00 00 48 85 FF 48 89 7C 24 20 48 89 54 24 08 48 89 4C 24 10 44 89 44 24 2C 4C 89 4C 24 18 C7 44 24 3C 00 00 00 00 0F 84 C5 02 00 00 48 8B 44 24 20 80 38 00 0F 84 B7 02 00 00 8B 0D ?? ?? ?? ?? 49 89 F6 48 8D 5C 24 40 85 C9 78 55 BE 00 00 08 00 48 89 DF E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 85 D2 75 14 83 F8 FF 0F 84 55 04 00 00 BA 01 00 00 00 89 15 ?? ?? ?? ?? 83 FA 00 7E 1C 85 C0 79 2D 90 B8 01 00 00 00 48 81 C4 88 01 00 00 5B 5D 41 5C 41 5D 41 5E 41 5F C3 7D 13 0F 1F 80 00 00 00 00 48 89 DF E8 ?? ?? ?? ?? 85 C0 78 D4 31 DB 45 31 FF E8 ?? ?? ?? ?? 83 F8 00 89 44 24 28 0F 8C F9 04 00 00 0F 84 27 04 00 00 85 DB 0F 85 07 05 00 00 8B 7C 24 44 45 31 E4 E8 ?? ?? ?? ?? 48 83 7C 24 18 00 C7 44 24 44 FF FF FF FF 0F 84 8C 02 00 00 8B 7C 24 40 48 8D 74 24 70 BA 80 00 00 00 E8 ?? ?? ?? ?? 48 83 F8 FF 0F 84 E2 00 00 00 85 C0 89 44 24 04 0F 8E E7 00 00 00 31 DB EB 6D 66 90 48 8B BC 24 C8 01 00 00 44 89 EE E8 ?? ?? ?? ?? 48 85 C0 0F 85 C7 01 00 00 41 83 FC 02 41 BC 00 00 00 00 74 38 49 8B 36 48 8B 7C 24 18 E8 CE FA FF FF 83 F8 01 0F 84 75 02 00 00 48 8B 44 24 10 45 31 FF 48 C7 00 00 00 00 00 48 8B 44 24 08 48 C7 00 00 00 00 00 49 C7 06 00 00 00 00 48 83 C3 01 39 5C 24 04 0F 8E 66 FF FF FF 0F B6 6C 1C 70 48 8B BC 24 C0 01 00 00 44 0F BE ED 44 89 EE E8 ?? ?? ?? ?? 48 85 C0 0F 85 73 FF FF FF 41 83 FC 03 0F 84 81 01 00 00 49 8B 3E 48 8B 54 24 10 48 8B 74 24 08 49 83 C7 01 31 C0 40 80 FD 0A 44 89 E9 4C 0F 45 F8 E8 16 FB FF FF 48 85 C0 49 89 06 0F 84 EA 01 00 00 41 BC 01 00 00 00 EB 8F 66 90 48 8B 05 ?? ?? ?? ?? 64 83 38 04 0F 84 F0 FE FF FF 8B 6C 24 28 48 8D 5C 24 3C 66 0F 1F 44 00 00 BA 01 00 00 00 48 89 DE 89 EF E8 ?? ?? ?? ?? 48 63 D0 48 83 FA FF 0F 85 7C 02 00 00 48 8B 05 ?? ?? ?? ?? 64 83 38 04 74 D7 8B 7C 24 40 48 8D 74 24 70 BA 80 00 00 00 E8 ?? ?? ?? ?? 48 83 F8 FF 0F 85 82 02 00 00 48 8B 05 ?? ?? ?? ?? 64 83 38 04 74 D6 49 83 EF 01 48 8B 54 24 08 EB 03 49 89 C7 49 83 FF FF 74 4F 48 8B 02 48 85 C0 74 47 49 8B 0E 80 7C 01 FF 0A 75 3D 48 8D 70 FF 48 89 32 C6 44 01 FF 00 49 8D 47 FF 48 83 3A 00 75 CF 49 8B 3E E8 ?? ?? ?? ?? 48 8B 44 24 10 48 C7 00 00 00 00 00 48 8B 44 24 08 48 C7 00 00 00 00 00 49 C7 06 00 00 00 00 8B 7C 24 40 BB 01 00 00 00 E8 ?? ?? ?? ?? 8B 44 24 3C C7 44 24 40 FF FF FF FF 85 C0 0F 85 C9 FD FF FF 0F 1F 84 00 00 00 00 00 31 C0 E9 8E FD FF FF 66 0F 1F 84 00 00 00 00 00 40 80 FD 0A 74 1A 44 89 E0 83 E0 FD 83 F8 01 0F 85 68 FE FF FF 41 BC 02 00 00 00 E9 25 FE FF FF 41 83 FC 01 B8 03 00 00 00 44 0F 44 E0 E9 4B FE FF FF 66 0F 1F 44 00 00 49 8B 36 48 8B 7C 24 18 E8 DB F8 FF FF 83 F8 01 0F 84 82 00 00 00 48 8B 44 24 10 0F B6 6C 1C 70 31 FF 48 C7 00 00 00 00 00 48 8B 44 24 08 44 0F BE ED 48 C7 00 00 00 00 00 49 C7 06 00 00 00 00 E9 3D FE FF FF 8B 6C 24 28 0F 1F 80 00 00 00 00 8B 7C 24 40 48 8D 74 24 70 BA 80 00 00 00 E8 ?? ?? ?? ?? 48 83 F8 FF 74 77 85 C0 0F 8E 80 00 00 00 48 8B 54 24 10 48 8B 74 24 08 48 8D 4C 24 70 49 8B 3E 4C 63 C0 4D 01 C7 E8 4A FB FF FF 48 85 C0 49 89 06 75 BA 66 90 8B 7C 24 28 BE 09 00 00 00 E8 ?? ?? ?? ?? 8B 5C 24 28 66 0F 1F 44 00 00 31 D2 31 F6 89 DF E8 ?? ?? ?? ?? 83 F8 FF 75 0D 48 8B 15 ?? ?? ?? ?? 64 83 3A 04 74 E3 8B 7C 24 40 E8 ?? ?? ?? ?? E9 6D FC FF FF 0F 1F 44 00 00 48 8B 05 ?? ?? ?? ?? 64 83 38 04 0F 84 5F FF FF FF 48 8D 5C 24 3C 66 90 BA 01 00 00 00 48 89 DE 89 EF E8 ?? ?? ?? ?? 48 63 D0 48 83 FA FF 75 38 48 8B 05 ?? ?? ?? ?? 64 83 38 04 74 DB 8B 7C 24 40 48 8D 74 24 70 BA 80 00 00 00 E8 ?? ?? ?? ?? 48 83 F8 FF 75 2A 48 8B 05 ?? ?? ?? ?? 64 83 38 04 74 DA E9 E3 FD FF FF 48 85 D2 0F 84 FF FE FF FF 0F 1F 80 00 00 00 00 EB C3 66 0F 1F 44 00 00 85 C0 0F 8F 09 FF FF FF E9 BE FD FF FF 0F 1F 00 48 85 D2 0F 84 40 FC FF FF E9 83 FD FF FF 66 2E 0F 1F 84 00 00 00 00 00 48 8B 15 ?? ?? ?? ?? 64 83 3A 26 0F 85 9A FB FF FF 89 C2 E9 98 FB FF FF 85 C0 89 44 24 04 0F 8F 36 FC FF FF E9 7A FD FF FF 0F 1F 80 00 00 00 00 85 DB 0F 85 13 01 00 00 8B 5C 24 2C 48 8B 44 24 20 48 C7 44 24 50 ?? ?? ?? ?? 48 C7 44 24 58 ?? ?? ?? ?? 48 C7 44 24 68 00 00 00 00 83 E3 10 48 89 44 24 60 8B 7C 24 44 83 FF 01 0F 84 73 01 00 00 BE 01 00 00 00 E8 ?? ?? ?? ?? 8B 7C 24 44 E8 ?? ?? ?? ?? 85 DB 0F 85 EB 00 00 00 BF 02 00 00 00 E8 ?? ?? ?? ?? 31 C0 BE 01 00 00 00 BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 F8 02 89 C3 0F 85 F3 00 00 00 48 8D 94 24 F0 00 00 00 BE 02 00 00 00 BF 01 00 00 00 E8 ?? ?? ?? ?? 85 C0 75 25 8B 84 24 08 01 00 00 25 00 F0 00 00 3D 00 20 00 00 75 12 48 81 BC 24 18 01 00 00 03 01 00 00 0F 84 85 00 00 00 BF 5A 00 00 00 E8 ?? ?? ?? ?? 8B 7C 24 40 E8 ?? ?? ?? ?? 8B 7C 24 44 E8 ?? ?? ?? ?? B8 01 00 00 00 E9 AD FA FF FF 48 8D 5C 24 3C 8B 7C 24 28 31 D2 48 89 DE E8 ?? ?? ?? ?? 48 98 48 83 F8 FF 0F 85 8E 00 00 00 48 8B 05 ?? ?? ?? ?? 64 83 38 04 74 D9 31 C0 E9 7A FA FF FF 48 8B 44 24 20 48 C7 44 24 50 ?? ?? ?? ?? 31 DB 48 C7 44 24 68 00 00 00 00 48 C7 44 24 58 ?? ?? ?? ?? 48 89 44 24 60 E9 ED FE FF FF BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 7C 24 40 E8 ?? ?? ?? ?? 48 8B 15 ?? ?? ?? ?? 48 8D 74 24 50 BF ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 0F 88 05 FF FF FF BE 02 00 00 00 89 C7 E8 ?? ?? ?? ?? 89 DF E8 ?? ?? ?? ?? E9 ED FE FF FF 48 63 54 24 28 48 39 D0 0F 85 5D FC FF FF 83 7C 24 3C 01 19 C0 F7 D0 83 E0 05 E9 E1 F9 FF FF 8B 15 ?? ?? ?? ?? 85 D2 0F 8E 92 FE FF FF 31 D2 BE 02 00 00 00 BF 01 00 00 00 31 C0 E8 ?? ?? ?? ?? E9 7A FE FF FF }
	condition:
		$1
}

rule file_143_6_0 {
	meta:
		name = "parse_backtick"
		size = 450
		refs = "00bb free"
	strings:
		$1 = { 48 89 5C 24 D0 4C 89 74 24 F0 49 89 D6 48 89 6C 24 D8 4C 89 64 24 E0 48 89 CB 4C 89 6C 24 E8 4C 89 7C 24 F8 48 83 EC 78 49 8B 10 48 89 7C 24 18 48 C7 44 24 30 00 00 00 00 48 C7 44 24 28 00 00 00 00 48 C7 44 24 38 00 00 00 00 0F BE 0C 11 84 C9 0F 84 64 01 00 00 49 89 F5 4D 89 C4 45 89 CF 31 ED 80 F9 5C 0F 84 D5 00 00 00 80 F9 60 74 60 80 F9 27 75 09 B8 01 00 00 00 29 E8 89 C5 48 8B 7C 24 38 48 8D 54 24 30 48 8D 74 24 28 E8 8E F5 FF FF 48 85 C0 48 89 44 24 38 0F 84 11 01 00 00 49 8B 04 24 48 8D 50 01 49 89 14 24 0F BE 4C 03 01 84 C9 75 AD 48 8B 7C 24 38 E8 ?? ?? ?? ?? B8 05 00 00 00 EB 55 66 2E 0F 1F 84 00 00 00 00 00 48 8B 84 24 90 00 00 00 4C 8B 8C 24 80 00 00 00 45 89 F8 48 8B 74 24 18 48 8B 7C 24 38 4C 89 F1 4C 89 EA 48 89 44 24 08 48 8B 84 24 88 00 00 00 48 89 04 24 E8 17 F8 FF FF 48 8B 7C 24 38 89 44 24 10 E8 ?? ?? ?? ?? 8B 44 24 10 48 8B 5C 24 48 48 8B 6C 24 50 4C 8B 64 24 58 4C 8B 6C 24 60 4C 8B 74 24 68 4C 8B 7C 24 70 48 83 C4 78 C3 66 90 85 ED 74 2C 48 8D 54 24 30 48 8D 74 24 28 48 8D 7C 24 38 4D 89 E0 48 89 D9 E8 E2 F5 FF FF 85 C0 75 38 BD 01 00 00 00 E9 34 FF FF FF 0F 1F 40 00 48 83 C2 01 48 8D 74 24 28 48 8D 7C 24 38 49 89 14 24 48 8D 54 24 30 4D 89 E0 48 89 D9 E8 3E F5 FF FF 85 C0 0F 84 06 FF FF FF 48 8B 7C 24 38 89 44 24 10 E8 ?? ?? ?? ?? 8B 44 24 10 E9 6A FF FF FF B8 01 00 00 00 E9 60 FF FF FF 31 FF E9 F8 FE FF FF }
	condition:
		$1
}

rule file_143_7_0 {
	meta:
		name = "eval_expr_multdiv"
		size = 277
		refs = "007a __libc_tsd_CTYPE_B"
	strings:
		$1 = { 55 48 89 F5 53 48 89 FB 48 83 EC 18 E8 0F 02 00 00 85 C0 BA 05 00 00 00 74 53 48 83 C4 18 89 D0 5B 5D C3 0F B6 0C 25 00 00 00 00 80 F9 2A 0F 84 AC 00 00 00 80 F9 2F 0F 85 93 00 00 00 48 83 C2 01 48 8D 74 24 08 48 89 DF 48 89 13 E8 CF 01 00 00 85 C0 0F 85 B2 00 00 00 48 8B 45 00 48 89 C2 48 C1 FA 3F 48 F7 7C 24 08 48 89 45 00 48 8B 13 0F B6 0A 84 C9 74 59 48 8B 3D ?? ?? ?? ?? 48 0F BE F1 64 48 8B 07 F6 44 70 01 20 74 9E 48 8D 42 01 EB 24 0F 1F 44 00 00 0F B6 08 84 C9 74 31 64 4C 8B 07 4C 0F BE C9 48 83 C0 01 43 F6 44 48 01 20 0F 84 74 FF FF FF 48 85 C0 48 89 C2 48 89 03 75 D6 E9 5C FF FF FF 66 0F 1F 84 00 00 00 00 00 48 83 C4 18 31 D2 5B 89 D0 5D C3 0F 1F 44 00 00 48 83 C2 01 48 8D 74 24 08 48 89 DF 48 89 13 E8 2C 01 00 00 85 C0 75 13 48 8B 45 00 48 0F AF 44 24 08 48 89 45 00 E9 62 FF FF FF BA 05 00 00 00 E9 05 FF FF FF }
	condition:
		$1
}

rule file_143_8_0 {
	meta:
		name = "eval_expr_val"
		size = 253
		refs = "0025 __libc_tsd_CTYPE_B 00b9 strtol"
	strings:
		$1 = { 41 54 49 89 F4 55 48 89 FD 53 4C 8B 07 4D 85 C0 0F 84 D8 00 00 00 41 0F B6 00 84 C0 0F 84 83 00 00 00 48 8B 15 ?? ?? ?? ?? 4C 89 C3 64 48 8B 0A 48 0F BE D0 F6 44 51 01 20 75 17 EB 23 0F 1F 00 0F B6 03 84 C0 74 69 48 0F BE D0 F6 44 51 01 20 74 0E 48 83 C3 01 75 E8 0F B6 04 25 00 00 00 00 3C 28 75 4C 41 0F B6 10 84 D2 74 2B 80 FA 29 74 26 49 8D 40 01 EB 0D 66 0F 1F 84 00 00 00 00 00 84 D2 74 13 48 89 45 00 0F B6 10 49 89 C0 48 83 C0 01 80 FA 29 75 E9 84 D2 75 33 5B 5D B8 05 00 00 00 41 5C C3 4C 89 C3 0F 1F 84 00 00 00 00 00 31 D2 48 89 EE 48 89 DF E8 ?? ?? ?? ?? 48 39 5D 00 49 89 04 24 74 D4 31 C0 5B 5D 41 5C C3 41 C6 00 00 48 8D 7B 01 49 83 C0 01 4C 89 45 00 4C 89 E6 E8 1A FE FF FF 85 C0 75 B1 31 C0 EB DB 0F B6 04 25 00 00 00 00 31 DB E9 63 FF FF FF }
	condition:
		$1
}

rule file_143_9_0 {
	meta:
		name = "eval_expr"
		size = 253
		refs = "0073 __libc_tsd_CTYPE_B"
	strings:
		$1 = { 53 48 89 F3 48 83 EC 20 48 89 7C 24 08 48 8D 7C 24 08 E8 C9 FE FF FF 85 C0 74 49 48 83 C4 20 B8 05 00 00 00 5B C3 0F B6 0C 25 00 00 00 00 80 F9 2B 0F 84 99 00 00 00 80 F9 2D 0F 85 80 00 00 00 48 8D 74 24 18 48 8D 7C 24 08 48 83 C2 01 48 89 54 24 08 E8 88 FE FF FF 85 C0 75 BF 48 8B 44 24 18 48 29 03 48 8B 54 24 08 0F B6 0A 84 C9 74 50 48 8B 05 ?? ?? ?? ?? 64 4C 8B 00 48 0F BE C1 41 F6 44 40 01 20 74 A7 48 8D 42 01 EB 1A 0F 1F 00 0F B6 08 84 C9 74 29 48 0F BE F9 48 83 C0 01 41 F6 44 78 01 20 74 87 48 85 C0 48 89 C2 48 89 44 24 08 75 DC E9 6D FF FF FF 0F 1F 80 00 00 00 00 48 83 C4 20 31 C0 5B C3 0F 1F 84 00 00 00 00 00 48 8D 74 24 18 48 8D 7C 24 08 48 83 C2 01 48 89 54 24 08 E8 F8 FD FF FF 85 C0 0F 85 2B FF FF FF 48 8B 44 24 18 48 01 03 E9 67 FF FF FF }
	condition:
		$1
}

rule file_143_10_0 {
	meta:
		name = "w_addstr"
		size = 118
		refs = "002d strlen 0072 __assert_fail"
	strings:
		$1 = { 48 89 5C 24 E0 48 89 6C 24 E8 4C 89 64 24 F0 4C 89 6C 24 F8 48 83 EC 28 48 85 C9 74 40 48 89 FD 49 89 F4 49 89 D5 48 89 CB 48 89 CF E8 ?? ?? ?? ?? 48 89 D9 4C 89 EA 4C 89 E6 48 89 EF 48 8B 5C 24 08 48 8B 6C 24 10 4C 8B 64 24 18 4C 8B 6C 24 20 49 89 C0 48 83 C4 28 E9 F3 F2 FF FF B9 ?? ?? ?? ?? BA 9A 00 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_143_11_0 {
	meta:
		name = "parse_tilde"
		size = 1007
		refs = "005a strchr 010d __strnlen 0134 memcpy 016b __libc_errno 01c7 __getpwnam_r 0266 getenv 031d __getuid 03a2 __getpwuid_r"
	strings:
		$1 = { 55 48 89 E5 41 57 41 56 41 55 41 54 53 48 89 CB 48 81 EC 88 00 00 00 48 8B 06 48 89 7D 88 48 89 75 80 48 89 95 78 FF FF FF 4C 89 85 70 FF FF FF 48 85 C0 74 42 4C 8B 27 41 0F B6 44 04 FF 3C 3D 74 2C 3C 3A 0F 85 D6 01 00 00 BE 3D 00 00 00 4C 89 E7 4C 89 8D 58 FF FF FF E8 ?? ?? ?? ?? 48 85 C0 4C 8B 8D 58 FF FF FF 0F 84 B2 01 00 00 4D 85 C9 0F 85 A9 01 00 00 48 8B 85 70 FF FF FF 48 8B 38 48 8D 77 01 4C 8D 24 33 41 0F B6 0C 24 84 C9 0F 84 CA 01 00 00 80 F9 3A 0F 84 C1 01 00 00 80 F9 2F 0F 84 B8 01 00 00 49 89 F7 48 BA 00 00 00 80 00 00 40 80 EB 29 66 0F 1F 84 00 00 00 00 00 80 F9 5C 0F 84 37 02 00 00 49 83 C7 01 42 0F B6 0C 3B 84 C9 74 1A 80 F9 2F 74 15 80 F9 3A 74 10 80 F9 20 77 DB 48 89 D0 48 D3 E0 48 85 C0 79 D0 49 39 F7 0F 84 67 01 00 00 48 F7 D7 BB E8 03 00 00 4C 8D 6D 98 49 8D 34 3F 4C 89 E7 E8 ?? ?? ?? ?? 48 8D 50 1F 4C 89 E6 4C 8D 65 A0 48 83 E2 F0 48 29 D4 48 89 C2 48 8D 7C 24 0F 48 83 E7 F0 C6 04 07 00 E8 ?? ?? ?? ?? 48 81 EC 00 04 00 00 4C 89 BD 60 FF FF FF 48 89 85 68 FF FF FF 4C 8D 74 24 0F 49 83 E6 F0 4D 89 F7 41 89 DE 48 89 C3 EB 56 0F 1F 80 00 00 00 00 48 8B 05 ?? ?? ?? ?? 64 83 38 22 0F 85 27 01 00 00 41 8D 8E F7 03 00 00 31 D2 BF 10 00 00 00 83 E1 F0 48 63 F1 41 01 CE 48 8D 46 1E 48 F7 F7 48 C1 E0 04 48 29 C4 48 8D 44 24 0F 48 83 E0 F0 48 01 C6 49 39 F7 49 89 C7 41 0F 44 CE 41 89 CE 49 63 CE 4D 89 E8 4C 89 FA 4C 89 E6 48 89 DF E8 ?? ?? ?? ?? 85 C0 75 99 48 83 7D 98 00 4C 8B BD 60 FF FF FF 0F 84 C6 00 00 00 48 8B 4D C0 48 85 C9 0F 84 B9 00 00 00 48 8B 45 88 48 8B 95 78 FF FF FF 48 8B 75 80 48 8B 38 E8 7B FD FF FF 48 8B 7D 88 48 89 07 48 8B 95 70 FF FF FF 4D 8D 4F FF 4C 89 0A EB 23 0F 1F 40 00 48 8B 95 78 FF FF FF 48 8B 75 80 B9 7E 00 00 00 4C 89 E7 E8 78 EE FF FF 48 8B 7D 88 48 89 07 48 85 C0 0F 94 C0 0F B6 C0 48 8D 65 D8 5B 41 5C 41 5D 41 5E 41 5F 5D C3 66 0F 1F 84 00 00 00 00 00 BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 85 C0 0F 84 A9 00 00 00 48 89 C1 48 8B 45 88 48 8B 95 78 FF FF FF 48 8B 75 80 48 8B 38 E8 F3 FC FF FF 48 8B 7D 88 48 85 C0 48 89 07 75 A6 B8 01 00 00 00 EB A8 4C 8B BD 60 FF FF FF 48 8B 45 88 48 8B 95 78 FF FF FF B9 7E 00 00 00 48 8B 75 80 48 8B 38 E8 ED ED FF FF 48 8B 55 88 48 89 C7 48 89 02 31 C0 48 85 FF 0F 84 34 FF FF FF 48 8B 8D 68 FF FF FF 48 8B 95 78 FF FF FF 48 8B 75 80 E8 91 FC FF FF 48 8B 7D 88 48 89 07 E9 11 FF FF FF 0F 1F 44 00 00 48 8B 45 88 B9 7E 00 00 00 48 8B 95 78 FF FF FF 48 8B 75 80 48 8B 38 E9 17 FF FF FF E8 ?? ?? ?? ?? 48 81 EC 00 04 00 00 89 C3 41 BF E8 03 00 00 4C 8D 74 24 0F 4C 8D 6D 98 4C 8D 65 A0 49 83 E6 F0 EB 50 0F 1F 44 00 00 48 8B 05 ?? ?? ?? ?? 64 83 38 22 75 69 41 8D 8F F7 03 00 00 31 D2 BF 10 00 00 00 83 E1 F0 48 63 F1 41 01 CF 48 8D 46 1E 48 F7 F7 48 C1 E0 04 48 29 C4 4C 8D 4C 24 0F 49 83 E1 F0 4C 01 CE 49 39 F6 4D 89 CE 41 0F 44 CF 41 89 CF 49 63 CF 4D 89 E8 4C 89 F2 4C 89 E6 89 DF E8 ?? ?? ?? ?? 85 C0 75 9E 48 83 7D 98 00 74 0D 48 8B 4D C0 48 85 C9 0F 85 B8 FE FF FF 48 8B 45 88 48 8B 95 78 FF FF FF B9 7E 00 00 00 48 8B 75 80 48 8B 38 E8 D6 EC FF FF 48 8B 7D 88 48 85 C0 48 89 07 0F 85 55 FE FF FF E9 AA FE FF FF }
	condition:
		$1
}

rule file_143_12_0 {
	meta:
		name = "parse_arith"
		size = 950
		refs = "0098 free 0276 _itoa_word"
	strings:
		$1 = { 4C 89 74 24 F0 48 89 5C 24 D0 49 89 D6 48 89 6C 24 D8 4C 89 64 24 E0 4C 89 6C 24 E8 4C 89 7C 24 F8 48 81 EC A8 00 00 00 49 8B 10 48 89 74 24 28 48 C7 44 24 38 00 00 00 00 48 C7 44 24 30 00 00 00 00 48 C7 44 24 40 00 00 00 00 0F B6 04 11 84 C0 0F 84 BE 02 00 00 49 89 FC 49 89 CD 4D 89 C7 44 89 CD BB 01 00 00 00 3C 5C 0F 84 70 02 00 00 7F 6E 3C 28 0F 84 5E 02 00 00 66 0F 1F 44 00 00 0F 8E E2 00 00 00 3C 29 0F 84 92 01 00 00 3C 3B 75 64 48 8B 7C 24 40 E8 ?? ?? ?? ?? B8 02 00 00 00 48 8B 5C 24 78 48 8B AC 24 80 00 00 00 4C 8B A4 24 88 00 00 00 4C 8B AC 24 90 00 00 00 4C 8B B4 24 98 00 00 00 4C 8B BC 24 A0 00 00 00 48 81 C4 A8 00 00 00 C3 66 2E 0F 1F 84 00 00 00 00 00 3C 60 0F 84 F0 00 00 00 7F 66 3C 5D 0F 1F 40 00 0F 84 42 01 00 00 0F BE C8 48 8B 7C 24 40 48 8D 54 24 38 48 8D 74 24 30 E8 B3 EB FF FF 48 85 C0 48 89 44 24 40 0F 84 EC 01 00 00 49 8B 07 48 8D 50 01 49 89 17 41 0F B6 44 05 01 84 C0 0F 85 35 FF FF FF 48 8B 7C 24 40 E8 ?? ?? ?? ?? B8 05 00 00 00 E9 5A FF FF FF 66 0F 1F 84 00 00 00 00 00 3C 7B 0F 84 3A FF FF FF 3C 7D 75 9A 0F 1F 40 00 E9 2D FF FF FF 0F 1F 00 3C 0A 0F 84 22 FF FF FF 3C 24 75 82 48 8D 54 24 38 48 8D 74 24 30 48 8D 7C 24 40 C7 44 24 18 01 00 00 00 48 C7 44 24 10 00 00 00 00 41 89 E9 48 C7 44 24 08 00 00 00 00 48 C7 04 24 00 00 00 00 4D 89 F8 4C 89 E9 E8 0D 02 00 00 85 C0 0F 84 60 FF FF FF 48 8B 7C 24 40 89 44 24 20 E8 ?? ?? ?? ?? 8B 44 24 20 E9 CF FE FF FF 66 0F 1F 44 00 00 48 83 C2 01 48 8D 74 24 30 48 8D 7C 24 40 49 89 17 48 8D 54 24 38 48 C7 44 24 10 00 00 00 00 48 C7 44 24 08 00 00 00 00 48 C7 04 24 00 00 00 00 41 89 E9 4D 89 F8 4C 89 E9 E8 8A F4 FF FF 85 C0 0F 84 FD FE FF FF EB 9B 83 EB 01 0F 84 F3 00 00 00 B9 29 00 00 00 66 90 E9 C4 FE FF FF 0F 1F 00 83 FB 01 0F 85 7F 00 00 00 8B B4 24 B0 00 00 00 85 F6 74 74 48 8B 7C 24 40 48 C7 44 24 48 00 00 00 00 80 3F 00 75 51 48 8B 7C 24 48 48 8D 74 24 64 C6 44 24 64 00 31 C9 BA 0A 00 00 00 E8 ?? ?? ?? ?? 48 8B 74 24 28 49 8B 3C 24 48 89 C1 4C 89 F2 E8 02 F9 FF FF 48 8B 7C 24 40 49 89 04 24 E8 ?? ?? ?? ?? 31 C0 49 83 3C 24 00 0F 94 C0 E9 F6 FD FF FF 0F 1F 44 00 00 48 8D 74 24 48 E8 D6 F6 FF FF 85 C0 74 A1 66 90 48 8B 7C 24 40 E8 ?? ?? ?? ?? B8 05 00 00 00 E9 CD FD FF FF 0F 1F 40 00 83 C3 01 E9 16 FE FF FF 48 8D 54 24 38 48 8D 74 24 30 48 8D 7C 24 40 4D 89 F8 4C 89 E9 E8 E6 EA FF FF 85 C0 0F 84 19 FE FF FF E9 B4 FE FF FF B8 01 00 00 00 0F 1F 40 00 E9 8C FD FF FF 31 FF E9 1C FE FF FF 8B BC 24 B0 00 00 00 48 C7 44 24 48 00 00 00 00 85 FF 75 90 41 80 7C 15 01 29 48 8D 42 01 75 84 48 8B 7C 24 40 49 89 07 31 DB 80 3F 00 75 19 C6 44 24 64 00 31 C9 BA 0A 00 00 00 48 8D 74 24 64 48 89 DF E9 11 FF FF FF 48 8D 74 24 48 E8 22 F6 FF FF 85 C0 0F 85 4A FF FF FF 48 8B 5C 24 48 48 85 DB 79 CB 48 8B 74 24 28 49 8B 3C 24 B9 2D 00 00 00 4C 89 F2 48 F7 DB E8 27 E9 FF FF 48 85 C0 49 89 04 24 75 A9 48 8B 7C 24 40 E8 ?? ?? ?? ?? B8 01 00 00 00 E9 EB FC FF FF }
	condition:
		$1
}

rule file_143_13_0 {
	meta:
		name = "parse_dollars"
		size = 6712
		refs = "00c1 __libc_tsd_CTYPE_B 0319 pthread_setcancelstate 0389 free 0561 __assert_fail 05e1 strchr 06c0 strtol 06c6 __libc_argc 07c2 __strdup 07ee __setenv 083d strlen 0854 _itoa_word 0df2 getenv 0ed4 __libc_argv 1036 fnmatch 104c malloc 1070 mempcpy 118f stpcpy 129c strspn 12c2 strcspn 13f7 __getpid 162a __fxprintf 1776 _libc_intl_domainname 1780 __dcgettext"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 53 48 81 EC 08 01 00 00 49 8B 28 48 89 54 24 50 48 89 7C 24 40 48 89 74 24 48 44 89 4C 24 5C 48 8D 55 01 4C 8D 34 11 41 0F B6 06 3C 27 0F 84 7C 01 00 00 48 89 CB 4D 89 C7 0F 8E 68 01 00 00 3C 28 0F 84 E0 01 00 00 3C 5B 0F 84 A8 01 00 00 49 89 17 41 0F B6 06 31 C9 48 C7 84 24 88 00 00 00 00 00 00 00 48 C7 84 24 80 00 00 00 00 00 00 00 48 C7 84 24 98 00 00 00 00 00 00 00 48 C7 84 24 90 00 00 00 00 00 00 00 3C 7B 0F 94 C1 85 C9 89 4C 24 60 0F 84 11 05 00 00 48 8D 55 02 C7 44 24 64 00 00 00 00 49 89 17 0F B6 44 2B 02 3C 23 0F 84 A2 05 00 00 4C 8B 25 ?? ?? ?? ?? 48 0F BE F0 64 49 8B 0C 24 F6 44 71 01 04 0F 85 87 03 00 00 3C 5F 0F 84 7F 03 00 00 0F BE C8 8D 41 D0 83 F8 09 0F 87 E0 04 00 00 45 31 ED 48 8D 84 24 88 00 00 00 48 8D 94 24 80 00 00 00 4C 89 EF 4D 89 FD 49 89 EF 8B 6C 24 60 4C 89 74 24 68 49 89 D4 49 89 DE 48 89 C3 66 90 48 89 DA 4C 89 E6 E8 D5 E7 FF FF 48 85 C0 48 89 C7 0F 84 51 04 00 00 85 ED 0F 84 60 12 00 00 49 8B 45 00 48 8D 50 01 49 89 55 00 41 0F BE 44 06 01 0F BE C8 8D 71 D0 83 FE 09 76 C4 4C 89 F3 4C 8B 74 24 68 4C 89 FD C7 44 24 38 01 00 00 00 4D 89 EF 49 89 FD 3C 2D 0F 84 53 10 00 00 0F 8F 6C 08 00 00 3C 25 0F 84 87 10 00 00 3C 2B 0F 1F 00 0F 84 3A 10 00 00 3C 23 0F 84 4B 10 00 00 41 BE 05 00 00 00 45 31 D2 E9 E8 03 00 00 0F 1F 40 00 84 C0 0F 85 E0 01 00 00 48 8B 44 24 40 48 8B 54 24 50 B9 24 00 00 00 48 8B 74 24 48 48 8B 38 E8 2C E7 FF FF 48 8B 54 24 40 48 89 02 45 31 F6 48 85 C0 41 0F 94 C6 48 81 C4 08 01 00 00 44 89 F0 5B 5D 41 5C 41 5D 41 5E 41 5F C3 0F 1F 44 00 00 44 8B 4C 24 5C 48 83 C5 02 49 89 28 C7 04 24 01 00 00 00 48 8B 54 24 50 48 8B 74 24 48 48 8B 7C 24 40 E8 19 FA FF FF 41 89 C6 EB BA 0F 1F 40 00 48 8D 7D 02 4C 8D 0C 39 41 80 39 28 0F 84 66 01 00 00 F6 44 24 5C 04 41 BE 04 00 00 00 75 97 44 8B 94 24 58 01 00 00 49 89 3F 31 C0 41 0F BE 09 48 C7 84 24 B8 00 00 00 00 00 00 00 48 C7 84 24 B0 00 00 00 00 00 00 00 45 85 D2 48 0F 44 84 24 40 01 00 00 45 31 ED 84 C9 48 89 84 24 40 01 00 00 0F 84 A4 03 00 00 41 BC 01 00 00 00 31 ED 4C 89 E8 EB 45 0F 1F 40 00 80 F9 22 0F 84 7F 01 00 00 48 8D 94 24 B8 00 00 00 48 8D B4 24 B0 00 00 00 48 89 C7 E8 37 E6 FF FF 48 85 C0 0F 84 7E 03 00 00 49 8B 17 48 8D 4A 01 49 89 0F 0F BE 4C 13 01 84 C9 0F 84 4F 03 00 00 80 F9 27 0F 84 1E 01 00 00 7E B4 80 F9 28 0F 84 53 01 00 00 80 F9 29 75 AF 85 ED 75 AB 41 83 EC 01 75 A5 48 85 C0 49 89 C5 0F 84 B0 11 00 00 B8 ?? ?? ?? ?? C7 44 24 7C 00 00 00 00 48 85 C0 0F 84 96 16 00 00 48 8D 74 24 7C BF 01 00 00 00 FF D0 48 8B 8C 24 50 01 00 00 48 8B 84 24 48 01 00 00 4C 89 EF 48 8B 74 24 40 4C 8B 8C 24 40 01 00 00 44 8B 44 24 5C 48 8B 54 24 48 48 89 4C 24 08 48 8B 4C 24 50 48 89 04 24 E8 89 E8 FF FF 8B 7C 24 7C 31 F6 41 89 C6 E8 ?? ?? ?? ?? 4C 89 EF E8 ?? ?? ?? ?? E9 54 FE FF FF 66 0F 1F 44 00 00 3C 22 0F 85 B8 FC FF FF E9 13 FE FF FF 0F 1F 00 44 8D 55 03 4D 63 D2 42 0F B6 04 11 84 C0 0F 84 86 FE FF FF 49 8D 4A 01 31 D2 66 0F 1F 44 00 00 85 D2 75 1C 3C 29 0F 84 CC 04 00 00 3C 28 75 1E 0F 1F 84 00 00 00 00 00 83 C2 01 EB 11 0F 1F 00 3C 28 74 F4 3C 29 0F 94 C0 0F B6 C0 29 C2 0F B6 04 0B 48 8D 71 01 49 89 CA 84 C0 0F 84 39 FE FF FF 48 89 F1 EB BA 66 90 85 ED 0F 84 50 01 00 00 83 FD 01 40 0F 95 C5 40 0F B6 ED 01 ED E9 87 FE FF FF 66 0F 1F 44 00 00 85 ED 0F 84 40 01 00 00 83 FD 02 40 0F 95 C5 40 0F B6 ED E9 69 FE FF FF 0F 1F 84 00 00 00 00 00 83 FD 01 41 83 D4 00 E9 55 FE FF FF 0F 1F 40 00 48 8D 8C 24 80 00 00 00 48 8D 94 24 88 00 00 00 45 31 ED 48 89 4C 24 30 48 89 54 24 38 0F BE C8 4C 89 E8 0F 1F 44 00 00 48 8B 54 24 38 48 8B 74 24 30 48 89 C7 E8 66 E4 FF FF 48 85 C0 0F 84 E5 00 00 00 49 8B 0F 64 49 8B 34 24 48 8D 51 01 49 89 17 0F BE 4C 0B 01 48 0F BE F9 F6 04 7E 08 75 C7 80 F9 5F 74 C2 49 89 C5 C7 44 24 38 00 00 00 00 44 8B 44 24 60 45 85 C0 0F 85 C1 01 00 00 C7 44 24 60 00 00 00 00 C7 44 24 30 00 00 00 00 45 31 D2 48 83 EA 01 49 89 17 41 80 3E 7B 0F 84 7D 01 00 00 4D 85 ED 0F 84 30 09 00 00 41 0F B6 45 00 0F BE D0 83 EA 30 83 FA 09 0F 86 90 01 00 00 8B 74 24 38 85 F6 0F 84 BD 08 00 00 3C 24 0F 84 B5 0E 00 00 3C 2A 0F 94 C2 3C 40 0F 94 C0 0F 84 8C 06 00 00 84 D2 0F 85 84 06 00 00 B9 ?? ?? ?? ?? BA D7 05 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 0F 1F 00 BD 01 00 00 00 E9 3F FD FF FF 66 0F 1F 44 00 00 BD 02 00 00 00 E9 2F FD FF FF 66 0F 1F 44 00 00 49 89 C5 41 BE 01 00 00 00 45 31 D2 4C 89 EF 4C 89 54 24 28 E8 ?? ?? ?? ?? 4C 8B 54 24 28 4C 89 D7 E8 ?? ?? ?? ?? E9 33 FC FF FF 3C 23 0F 84 DE 13 00 00 C7 44 24 64 00 00 00 00 E9 F6 FA FF FF 0F 1F 84 00 00 00 00 00 89 CE BF ?? ?? ?? ?? 48 89 54 24 28 89 4C 24 20 E8 ?? ?? ?? ?? 48 85 C0 48 8B 54 24 28 8B 4C 24 20 0F 84 A9 08 00 00 48 8D 94 24 88 00 00 00 48 8D B4 24 80 00 00 00 31 FF E8 F2 E2 FF FF 48 85 C0 49 89 C5 0F 84 32 0E 00 00 49 8B 17 C7 44 24 38 01 00 00 00 48 83 C2 01 49 89 17 E9 A0 FE FF FF 0F 1F 80 00 00 00 00 49 89 C5 4C 89 EF 41 BE 05 00 00 00 E8 ?? ?? ?? ?? E9 98 FB FF FF 66 90 41 BE 01 00 00 00 E9 8B FB FF FF 0F 1F 44 00 00 48 8D 55 03 C7 44 24 64 01 00 00 00 49 89 17 0F B6 44 2B 03 E9 45 FA FF FF 0F 1F 80 00 00 00 00 49 8B 07 41 BE 05 00 00 00 80 3C 03 7D 0F 85 01 FF FF FF E9 6B FE FF FF 0F 1F 84 00 00 00 00 00 0F BE 04 13 E9 CC FA FF FF 0F 1F 80 00 00 00 00 31 F6 BA 0A 00 00 00 4C 89 EF 4C 89 54 24 28 E8 ?? ?? ?? ?? 3B 05 ?? ?? ?? ?? 4C 8B 54 24 28 0F 8C FC 07 00 00 F6 44 24 5C 20 0F 85 3F 0D 00 00 45 31 E4 31 DB 0F 1F 00 8B 44 24 30 85 C0 0F 84 0C 01 00 00 44 8B 7C 24 30 41 83 EF 23 41 83 FF 2F 0F 87 DC 07 00 00 44 89 F9 48 B8 00 00 41 00 00 00 00 A0 48 D3 E0 48 85 C0 0F 88 B0 01 00 00 48 B8 00 00 00 00 28 00 20 00 48 D3 E0 48 85 C0 0F 88 C6 07 00 00 48 B8 00 00 00 00 00 00 80 00 48 D3 E0 48 85 C0 0F 89 97 07 00 00 48 85 DB 74 15 80 3B 00 0F 85 76 01 00 00 8B 44 24 60 85 C0 0F 84 6A 01 00 00 45 31 F6 45 85 E4 0F 84 22 FE FF FF 48 89 DF 4C 89 54 24 28 E8 ?? ?? ?? ?? 4C 8B 54 24 28 E9 0B FE FF FF 48 85 DB 74 13 80 3B 00 0F 85 C2 07 00 00 44 8B 5C 24 60 45 85 DB 74 C5 45 85 E4 0F 85 E4 0F 00 00 4D 85 D2 0F 84 1F 0F 00 00 4C 89 D7 4C 89 54 24 28 41 BE 01 00 00 00 E8 ?? ?? ?? ?? 48 85 C0 48 89 C3 4C 8B 54 24 28 0F 84 BD FD FF FF BA 01 00 00 00 48 89 DE 4C 89 EF 4C 89 54 24 28 41 BC 01 00 00 00 E8 ?? ?? ?? ?? 4C 8B 54 24 28 66 0F 1F 84 00 00 00 00 00 4C 89 EF 4C 89 54 24 28 E8 ?? ?? ?? ?? 4C 8B 54 24 28 4C 89 D7 E8 ?? ?? ?? ?? 44 8B 4C 24 64 45 85 C9 0F 84 E7 05 00 00 48 85 DB C6 84 24 F4 00 00 00 00 0F 84 EC 10 00 00 48 89 DF E8 ?? ?? ?? ?? 48 8D B4 24 F4 00 00 00 31 C9 BA 0A 00 00 00 48 89 C7 E8 ?? ?? ?? ?? 48 89 C1 48 8B 44 24 40 48 8B 54 24 50 48 8B 74 24 48 48 8B 38 E8 5E EF FF FF 48 8B 54 24 40 45 85 E4 48 89 02 0F 84 59 F9 FF FF 48 89 DF E8 ?? ?? ?? ?? 48 8B 4C 24 40 48 8B 01 E9 44 F9 FF FF 0F 1F 84 00 00 00 00 00 42 80 7C 13 01 29 0F 85 96 F9 FF FF 48 83 C5 03 44 8B 4C 24 5C 4D 89 F8 49 89 2F 48 89 D9 C7 04 24 00 00 00 00 E9 49 F9 FF FF 66 0F 1F 44 00 00 4D 85 D2 48 C7 84 24 B0 00 00 00 00 00 00 00 48 C7 84 24 A8 00 00 00 00 00 00 00 48 C7 84 24 A0 00 00 00 00 00 00 00 0F 84 3A 0B 00 00 41 0F B6 02 84 C0 0F 84 2E 0B 00 00 44 89 7C 24 68 4C 89 D5 45 31 F6 48 89 5C 24 38 4D 89 D7 EB 68 66 90 3C 24 0F 84 7B 03 00 00 3C 27 0F 84 58 03 00 00 3C 22 0F 84 25 03 00 00 41 0F BE 0F 48 8B BC 24 A0 00 00 00 4C 89 FB 48 8D 94 24 B0 00 00 00 48 8D B4 24 A8 00 00 00 E8 A4 DF FF FF 48 85 C0 48 89 84 24 A0 00 00 00 0F 84 74 04 00 00 49 89 DF 49 83 C7 01 0F 84 B0 0A 00 00 0F B6 43 01 84 C0 0F 84 A4 0A 00 00 3C 2A 74 1E 7E 94 3C 5C 66 90 0F 84 04 04 00 00 3C 7E 0F 84 98 03 00 00 3C 3F 75 96 66 0F 1F 44 00 00 45 85 F6 74 8B 48 8B BC 24 A0 00 00 00 48 8D 94 24 B0 00 00 00 48 8D B4 24 A8 00 00 00 B9 5C 00 00 00 E8 31 DF FF FF 48 85 C0 48 89 C7 48 89 84 24 A0 00 00 00 0F 84 FE 03 00 00 41 0F BE 0F 4C 89 FB E9 58 FF FF FF 3C 3D 0F 84 D9 07 00 00 0F 8F 3E 08 00 00 3C 3A 90 0F 85 98 F7 FF FF 48 8D 4A 01 BF ?? ?? ?? ?? 4C 8D 24 0B 41 0F BE 34 24 48 89 54 24 28 48 89 4C 24 20 E8 ?? ?? ?? ?? 48 85 C0 48 8B 54 24 28 48 8B 4C 24 20 0F 84 64 F7 FF FF 49 89 0F 45 0F BE 24 24 48 83 C2 02 48 8D 04 13 C7 44 24 60 01 00 00 00 44 89 64 24 30 49 89 17 0F B6 00 45 31 D2 84 C0 0F 84 8A FA FF FF 4C 89 FE 45 31 C0 48 89 6C 24 68 89 C1 4D 89 F7 45 31 E4 4C 89 D0 44 89 C5 49 89 F6 EB 61 66 2E 0F 1F 84 00 00 00 00 00 80 F9 22 0F 84 F7 00 00 00 80 F9 27 0F 84 CE 00 00 00 66 0F 1F 44 00 00 49 8B 16 48 8D B4 24 90 00 00 00 48 89 C7 0F BE 0C 13 48 8D 94 24 98 00 00 00 E8 39 DE FF FF 48 85 C0 0F 84 7D 00 00 00 49 8B 0E 48 8D 51 01 49 89 16 0F B6 4C 0B 01 84 C9 0F 84 A3 03 00 00 80 F9 5C 74 24 7E A2 80 F9 7B 74 6D 80 F9 7D 75 B0 45 85 E4 75 AB 85 ED 90 0F 84 40 0B 00 00 83 ED 01 EB 9D 0F 1F 44 00 00 45 85 E4 75 93 48 8D 4A 01 49 89 0E 80 7C 13 01 00 0F 84 11 0B 00 00 48 8D 94 24 98 00 00 00 48 8D B4 24 90 00 00 00 B9 5C 00 00 00 48 89 C7 E8 BC DD FF FF 48 85 C0 0F 85 5B FF FF FF 49 89 C2 41 BE 01 00 00 00 E9 39 FA FF FF 0F 1F 44 00 00 41 83 FC 01 83 D5 00 E9 3C FF FF FF 0F 1F 40 00 45 85 E4 74 3B 41 83 FC 01 41 0F 95 C4 45 0F B6 E4 45 01 E4 E9 1F FF FF FF 0F 1F 80 00 00 00 00 45 85 E4 74 2B 41 83 FC 02 41 0F 95 C4 45 0F B6 E4 E9 02 FF FF FF 66 2E 0F 1F 84 00 00 00 00 00 41 BC 01 00 00 00 E9 ED FE FF FF 0F 1F 44 00 00 41 BC 02 00 00 00 E9 DD FE FF FF 0F 1F 44 00 00 8B 4C 24 64 85 C9 0F 84 3C 05 00 00 8B 05 ?? ?? ?? ?? C6 84 24 D4 00 00 00 00 85 C0 0F 8E DE 08 00 00 83 E8 01 48 63 F8 48 8D B4 24 D4 00 00 00 31 C9 BA 0A 00 00 00 4C 89 54 24 28 45 31 F6 E8 ?? ?? ?? ?? 48 89 C1 48 8B 44 24 40 48 8B 74 24 48 48 8B 54 24 50 48 8B 38 E8 A2 EB FF FF 48 8B 54 24 40 4C 89 EF 48 89 02 E8 ?? ?? ?? ?? 4C 8B 54 24 28 4C 89 D7 E8 ?? ?? ?? ?? 48 8B 4C 24 40 48 83 39 00 41 0F 94 C6 E9 89 F5 FF FF 41 83 FE 02 0F 84 CE 02 00 00 45 85 F6 0F 85 C8 FC FF FF 41 BE 02 00 00 00 66 2E 0F 1F 84 00 00 00 00 00 4C 89 FB E9 E5 FC FF FF 41 83 FE 01 0F 84 A3 02 00 00 45 85 F6 0F 85 9D FC FF FF 41 BE 01 00 00 00 EB DD 44 8B 4C 24 5C 4C 8D 84 24 B8 00 00 00 48 8D 94 24 B0 00 00 00 48 8D B4 24 A8 00 00 00 48 8D BC 24 A0 00 00 00 C7 44 24 18 01 00 00 00 48 C7 44 24 10 00 00 00 00 48 C7 44 24 08 00 00 00 00 4C 89 F9 48 C7 04 24 00 00 00 00 48 C7 84 24 B8 00 00 00 00 00 00 00 E8 02 F3 FF FF 85 C0 0F 84 87 00 00 00 45 85 E4 41 89 C6 49 89 EA 48 8B 5C 24 38 0F 85 50 07 00 00 48 8B BC 24 A0 00 00 00 4C 89 54 24 28 E8 ?? ?? ?? ?? 4C 8B 54 24 28 E9 5E F8 FF FF 45 85 F6 0F 85 F9 FB FF FF 48 83 BC 24 A8 00 00 00 00 0F 85 EA FB FF FF 4C 8D 84 24 B8 00 00 00 48 8D 94 24 B0 00 00 00 48 8D B4 24 A8 00 00 00 48 8D BC 24 A0 00 00 00 45 31 C9 4C 89 F9 48 C7 84 24 B8 00 00 00 00 00 00 00 E8 CB EA FF FF 85 C0 0F 85 79 FF FF FF 4C 03 BC 24 B8 00 00 00 E9 E6 FE FF FF 48 8B BC 24 A0 00 00 00 48 8D 94 24 B0 00 00 00 48 8D B4 24 A8 00 00 00 B9 5C 00 00 00 49 8D 5F 01 E8 40 DB FF FF 48 89 84 24 A0 00 00 00 41 0F BE 4F 01 48 89 C7 84 C9 0F 84 79 0A 00 00 48 85 C0 0F 85 66 FB FF FF 49 89 EA E9 67 FD FF FF 4C 89 EF 4C 89 54 24 28 E8 ?? ?? ?? ?? 4C 8B 54 24 28 48 89 C3 48 85 DB 0F 84 CE F8 FF FF 45 31 E4 E9 D9 F8 FF FF 48 85 DB 0F 84 B0 06 00 00 44 8B 84 24 58 01 00 00 45 85 C0 75 0F 48 83 BC 24 40 01 00 00 00 0F 85 2B 04 00 00 48 89 D9 E9 1F FA FF FF 8B 7C 24 64 85 FF 0F 84 99 05 00 00 8B 3D ?? ?? ?? ?? 48 8D B4 24 D4 00 00 00 31 C9 BA 0A 00 00 00 4C 89 54 24 28 C6 84 24 D4 00 00 00 00 83 EF 01 48 63 FF E8 ?? ?? ?? ?? C7 44 24 64 00 00 00 00 48 89 C3 4C 8B 54 24 28 E9 74 FF FF FF 49 89 C2 4C 89 F0 48 8B 6C 24 68 4D 89 FE 49 89 C7 E9 52 F6 FF FF 44 8B 4C 24 60 45 85 C9 0F 85 22 05 00 00 C7 44 24 38 00 00 00 00 45 31 ED C7 44 24 60 00 00 00 00 C7 44 24 30 00 00 00 00 45 31 D2 E9 21 F6 FF FF 48 8B 15 ?? ?? ?? ?? 48 98 48 8B 1C C2 E9 1B FF FF FF B9 ?? ?? ?? ?? BA 26 06 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 85 DB 0F 84 CB F9 FF FF 80 3B 00 75 0C 8B 44 24 60 85 C0 0F 85 BA F9 FF FF 41 83 FF 2F 76 21 B9 ?? ?? ?? ?? BA 73 07 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 45 31 F6 E9 43 FD FF FF 44 89 F8 FF 24 C5 ?? ?? ?? ?? 48 85 DB 0F 84 B8 06 00 00 80 3B 00 0F 84 A1 06 00 00 4C 89 EF 4C 89 54 24 28 E8 ?? ?? ?? ?? 4C 8B 54 24 28 4C 89 D7 E8 ?? ?? ?? ?? 83 7C 24 64 00 0F 85 AA F8 FF FF E9 95 FE FF FF 0F 1F 44 00 00 48 85 DB 74 05 80 3B 00 75 C7 45 85 E4 0F 85 20 07 00 00 48 85 DB 66 90 0F 84 10 01 00 00 44 8B 64 24 60 45 85 E4 0F 85 02 01 00 00 45 31 F6 E9 D8 F5 FF FF 4D 85 D2 0F 84 3B F8 FF FF 48 85 DB 0F 84 32 F8 FF FF 41 80 3A 00 74 85 48 89 DF 4C 89 54 24 28 E8 ?? ?? ?? ?? 83 7C 24 30 4C 48 8D 2C 03 4C 8B 54 24 28 0F 84 B0 07 00 00 0F 87 DE 06 00 00 83 7C 24 30 23 }
	condition:
		$1
}

rule file_143_14_0 {
	meta:
		name = "wordfree"
		size = 93
		refs = "0035 free"
	strings:
		$1 = { 48 85 FF 74 56 48 8B 57 08 48 85 D2 74 4D 55 48 89 FD 53 48 83 EC 08 48 8B 47 10 48 8D 1C C2 48 8B 3B 48 85 FF 74 1E 66 0F 1F 84 00 00 00 00 00 48 83 C3 08 E8 ?? ?? ?? ?? 48 8B 3B 48 85 FF 75 EF 48 8B 55 08 48 89 D7 E8 ?? ?? ?? ?? 48 C7 45 08 00 00 00 00 48 83 C4 08 5B 5D F3 C3 }
	condition:
		$1
}

rule file_143_15_0 {
	meta:
		name = "wordexp"
		size = 3256
		refs = "008a calloc 00ab getenv 0182 strchr 036b wordfree 0387 free 0945 glob 0a33 globfree 0b23 __strdup 0b62 __assert_fail"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 49 89 F4 55 53 48 89 FB 48 81 EC 08 01 00 00 48 8B 06 89 54 24 2C 83 E2 08 48 C7 84 24 80 00 00 00 00 00 00 00 48 C7 44 24 78 00 00 00 00 48 C7 84 24 88 00 00 00 00 00 00 00 48 89 44 24 58 48 8B 46 08 48 89 44 24 40 48 8B 46 10 48 89 44 24 50 0F 85 A9 0B 00 00 8B 44 24 2C 83 E0 02 89 44 24 4C 75 39 F6 44 24 2C 01 49 C7 04 24 00 00 00 00 0F 85 DD 09 00 00 BE 08 00 00 00 BF 01 00 00 00 E8 ?? ?? ?? ?? 48 85 C0 49 89 44 24 08 0F 84 E1 09 00 00 49 C7 44 24 10 00 00 00 00 BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 85 C0 48 89 44 24 20 0F 84 61 0B 00 00 0F B6 10 84 D2 0F 84 72 0B 00 00 48 8D 44 24 60 48 8B 74 24 20 48 89 44 24 30 48 89 C1 48 89 C7 EB 16 90 80 FA 20 74 15 80 FA 0A 74 10 48 83 C6 01 0F B6 16 84 D2 74 4B 80 FA 09 75 E6 48 39 F9 0F 86 7F 0A 00 00 3A 54 24 60 0F 84 75 0A 00 00 48 89 F8 EB 0A 66 0F 1F 44 00 00 3A 10 74 CE 48 83 C0 01 48 39 C8 75 F3 48 83 C6 01 88 10 48 8D 48 01 0F B6 16 84 D2 75 BF 66 2E 0F 1F 84 00 00 00 00 00 C6 01 00 0F BE 2B 48 C7 44 24 70 00 00 00 00 40 84 ED 0F 84 40 0A 00 00 31 D2 E9 8D 00 00 00 90 40 80 FD 24 0F 84 46 05 00 00 0F 8F E8 02 00 00 40 80 FD 22 0F 84 36 04 00 00 89 EE BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 85 C0 0F 84 2D 0A 00 00 48 8B B4 24 88 00 00 00 48 85 F6 74 13 4C 89 E7 E8 EC CB FF FF 85 C0 41 89 C7 0F 85 5E 02 00 00 48 C7 84 24 80 00 00 00 00 00 00 00 48 C7 44 24 78 00 00 00 00 48 C7 84 24 88 00 00 00 00 00 00 00 48 8B 44 24 70 0F BE 6C 03 01 48 8D 50 01 48 89 54 24 70 40 84 ED 0F 84 AC 09 00 00 40 80 FD 3F 74 26 0F 8E 68 FF FF FF 40 80 FD 5C 0F 84 0E 05 00 00 0F 8F C0 01 00 00 40 80 FD 5B 0F 85 68 FF FF FF 66 0F 1F 44 00 00 4C 8B 6C 24 70 48 C7 84 24 90 00 00 00 00 00 00 00 48 C7 84 24 98 00 00 00 00 00 00 00 48 C7 84 24 A0 00 00 00 00 00 00 00 42 0F B6 2C 2B 40 84 ED 0F 84 6E 06 00 00 41 BF 01 00 00 00 45 31 D2 4C 89 64 24 38 44 89 7C 24 48 4D 89 EC 45 89 D6 E9 8A 00 00 00 0F 1F 00 40 80 FD 22 0F 84 2E 01 00 00 41 83 FE 01 0F 84 0C 0A 00 00 40 80 FD 24 0F 84 C2 05 00 00 40 80 FD 5C 0F 85 96 00 00 00 45 85 F6 0F 84 37 05 00 00 4C 8D 44 24 70 48 8D 94 24 80 00 00 00 48 8D 74 24 78 48 8D BC 24 88 00 00 00 48 89 D9 E8 BD CC FF FF 89 44 24 48 8B 6C 24 48 85 ED 0F 85 37 05 00 00 0F 1F 44 00 00 4C 8B 6C 24 70 4D 8D 65 01 42 0F B6 2C 23 4D 89 E5 4C 89 64 24 70 40 84 ED 0F 84 C1 05 00 00 48 8B 7C 24 20 44 0F BE FD 44 89 FE E8 ?? ?? ?? ?? 48 85 C0 0F 85 A4 05 00 00 40 80 FD 27 0F 85 55 FF FF FF 45 85 F6 0F 84 0C 05 00 00 41 83 FE 01 0F 84 8D 00 00 00 48 8B BC 24 88 00 00 00 48 8D 94 24 80 00 00 00 48 8D 74 24 78 44 89 F9 E8 15 CB FF FF 48 85 C0 48 89 84 24 88 00 00 00 75 80 44 8B 7C 24 48 48 8D BC 24 90 00 00 00 4C 8B 64 24 38 E8 ?? ?? ?? ?? 45 85 FF 0F 84 58 FE FF FF 48 8B BC 24 88 00 00 00 41 BF 01 00 00 00 E8 ?? ?? ?? ?? 0F 1F 44 00 00 48 81 C4 08 01 00 00 44 89 F8 5B 5D 41 5C 41 5D 41 5E 41 5F C3 0F 1F 00 45 85 F6 0F 84 8F 04 00 00 41 83 FE 02 0F 85 73 FF FF FF 45 31 F6 E9 1A FF FF FF 0F 1F 44 00 00 40 80 FD 60 0F 84 9E 00 00 00 40 80 FD 7E 0F 85 9E FD FF FF 4D 8B 0C 24 4C 8D 44 24 70 48 8D 94 24 80 00 00 00 48 8D 74 24 78 48 8D BC 24 88 00 00 00 48 89 D9 E8 AE D9 FF FF 85 C0 41 89 C7 0F 84 C3 FD FF FF 48 8B BC 24 88 00 00 00 E8 ?? ?? ?? ?? 41 83 FF 01 0F 84 6C FF FF FF 44 8B 5C 24 4C 45 85 DB 0F 84 3B 01 00 00 48 8B 44 24 58 49 89 04 24 48 8B 44 24 40 49 89 44 24 08 48 8B 44 24 50 49 89 44 24 10 E9 3C FF FF FF 0F 1F 40 00 40 80 FD 27 74 7A 40 80 FD 2A 0F 85 12 FD FF FF E9 AB FD FF FF 0F 1F 00 F6 44 24 2C 04 0F 85 D1 07 00 00 48 8B 44 24 30 48 83 C2 01 44 8B 4C 24 2C 48 89 54 24 70 4C 8D 44 24 70 48 8D 94 24 80 00 00 00 48 8D 74 24 78 48 8D BC 24 88 00 00 00 4C 89 24 24 48 89 44 24 10 48 8B 44 24 20 48 89 D9 48 89 44 24 08 E8 7D D3 FF FF 85 C0 41 89 C7 0F 84 02 FD FF FF E9 3A FF FF FF 0F 1F 44 00 00 0F BE 4C 13 01 48 8D 42 01 48 89 44 24 70 84 C9 0F 84 2D 01 00 00 80 F9 27 0F 84 89 00 00 00 48 8B BC 24 88 00 00 00 EB 27 0F 1F 80 00 00 00 00 48 8B 44 24 70 0F BE 4C 03 01 48 8D 50 01 48 89 54 24 70 84 C9 0F 84 00 01 00 00 80 F9 27 74 58 48 8D 94 24 80 00 00 00 48 8D 74 24 78 E8 26 C9 FF FF 48 85 C0 48 89 C7 48 89 84 24 88 00 00 00 75 BE 41 BF 01 00 00 00 E8 ?? ?? ?? ?? 41 83 FF 01 0F 84 31 FE FF FF 44 8B 5C 24 4C 45 85 DB 0F 85 C5 FE FF FF 4C 89 E7 E8 ?? ?? ?? ?? E9 B8 FE FF FF 66 0F 1F 44 00 00 48 83 7C 24 78 00 0F 85 44 FC FF FF 31 F6 4C 89 E7 E8 FA C7 FF FF 85 C0 41 89 C7 0F 84 2F FC FF FF E9 EA FD FF FF 66 2E 0F 1F 84 00 00 00 00 00 0F B6 4C 13 01 48 8D 72 01 48 89 74 24 70 84 C9 74 59 8B 6C 24 2C 89 C8 3C 24 0F 84 B0 01 00 00 7F 5E 3C 22 74 AA 48 8B BC 24 88 00 00 00 48 8D 94 24 80 00 00 00 48 8D 74 24 78 0F BE C8 E8 6D C8 FF FF 48 85 C0 48 89 84 24 88 00 00 00 0F 84 60 06 00 00 48 8B 44 24 70 48 8D 70 01 0F B6 44 03 01 48 89 74 24 70 84 C0 75 AD 48 8B BC 24 88 00 00 00 41 BF 05 00 00 00 E9 22 FF FF FF 66 90 3C 5C 0F 84 10 01 00 00 3C 60 75 9A 40 F6 C5 04 0F 85 2B 06 00 00 48 83 C6 01 4C 8D 44 24 70 48 8D 94 24 80 00 00 00 48 89 74 24 70 48 8D BC 24 88 00 00 00 48 8D 74 24 78 48 C7 44 24 10 00 00 00 00 48 C7 44 24 08 00 00 00 00 41 89 E9 48 C7 04 24 00 00 00 00 48 89 D9 E8 B2 D1 FF FF 85 C0 0F 84 6E FF FF FF 41 89 C7 48 8B BC 24 88 00 00 00 E9 AA FE FF FF 66 2E 0F 1F 84 00 00 00 00 00 48 8B 44 24 30 44 8B 4C 24 2C 4C 8D 44 24 70 48 8D 94 24 80 00 00 00 48 8D 74 24 78 48 8D BC 24 88 00 00 00 C7 44 24 18 00 00 00 00 4C 89 24 24 48 89 D9 48 89 44 24 10 48 8B 44 24 20 48 89 44 24 08 E8 69 DE FF FF 85 C0 41 89 C7 0F 84 CE FA FF FF E9 06 FD FF FF 66 0F 1F 84 00 00 00 00 00 4C 8D 44 24 70 48 8D 94 24 80 00 00 00 48 8D 74 24 78 48 8D BC 24 88 00 00 00 48 89 D9 E8 DE C7 FF FF 85 C0 41 89 C7 0F 84 93 FA FF FF E9 CB FC FF FF 66 0F 1F 44 00 00 4C 8D 44 24 70 48 8D 94 24 80 00 00 00 48 8D 74 24 78 48 8D BC 24 88 00 00 00 48 89 D9 E8 16 C8 FF FF 85 C0 0F 84 92 FE FF FF E9 1F FF FF FF 66 0F 1F 84 00 00 00 00 00 48 8B 44 24 30 4C 8D 44 24 70 48 8D 94 24 80 00 00 00 48 8D 74 24 78 48 8D BC 24 88 00 00 00 C7 44 24 18 01 00 00 00 4C 89 24 24 41 89 E9 48 89 D9 48 89 44 24 10 48 8B 44 24 20 48 89 44 24 08 E8 9B DD FF FF 85 C0 0F 84 37 FE FF FF E9 C4 FE FF FF 66 0F 1F 44 00 00 4C 8D 44 24 70 48 8D 94 24 80 00 00 00 48 8D 74 24 78 48 8D BC 24 88 00 00 00 48 89 D9 E8 16 C7 FF FF 89 44 24 48 8B 6C 24 48 85 ED 0F 84 CE FA FF FF 44 8B 7C 24 48 4C 8B 64 24 38 48 8D BC 24 90 00 00 00 E8 ?? ?? ?? ?? 48 8B BC 24 88 00 00 00 E9 22 FD FF FF 66 90 41 BE 01 00 00 00 E9 A2 FA FF FF 0F 1F 44 00 00 41 BE 02 00 00 00 E9 92 FA FF FF 0F 1F 44 00 00 31 C0 41 83 FE 02 44 8B 4C 24 2C 0F 94 C0 4C 8D 44 24 70 48 8D 94 24 80 00 00 00 89 44 24 18 48 8B 44 24 30 48 8D 74 24 78 48 8D BC 24 88 00 00 00 48 89 D9 48 89 44 24 10 48 8B 44 24 20 48 89 44 24 08 48 8D 84 24 90 00 00 00 48 89 04 24 E8 BC DC FF FF 85 C0 89 44 24 48 0F 84 28 FA FF FF E9 55 FF FF FF 4D 89 E5 4C 8B 64 24 38 48 8B B4 24 88 00 00 00 4D 8D 4D FF 48 8D BC 24 90 00 00 00 4C 89 4C 24 70 E8 B5 C4 FF FF 85 C0 41 89 C7 48 C7 84 24 80 00 00 00 00 00 00 00 48 C7 44 24 78 00 00 00 00 48 C7 84 24 88 00 00 00 00 00 00 00 0F 85 0D FF FF FF 48 83 BC 24 90 00 00 00 00 0F 84 7F 01 00 00 4C 8B 6C 24 20 41 BE 01 00 00 00 0F 1F 80 00 00 00 00 48 8B 84 24 98 00 00 00 48 8D 8C 24 B0 00 00 00 31 D2 BE 10 00 00 00 4A 8B 7C F0 F8 E8 ?? ?? ?? ?? 85 C0 0F 85 F7 01 00 00 41 80 7D 00 00 0F 85 54 01 00 00 48 8B 84 24 B8 00 00 00 48 8B 08 48 85 C9 0F 84 2F 03 00 00 48 8B BC 24 88 00 00 00 48 8D 94 24 80 00 00 00 48 8D 74 24 78 E8 A6 D3 FF FF 48 83 BC 24 B0 00 00 00 01 48 89 C7 48 89 84 24 88 00 00 00 0F 86 86 00 00 00 48 85 C0 0F 84 7D 00 00 00 BD 01 00 00 00 41 BF 01 00 00 00 EB 13 66 0F 1F 44 00 00 48 8B BC 24 88 00 00 00 48 85 FF 74 5D 48 8D 94 24 80 00 00 00 48 8D 74 24 78 B9 20 00 00 00 E8 7C C4 FF FF 48 85 C0 48 89 84 24 88 00 00 00 74 29 48 8B 94 24 B8 00 00 00 48 8D 74 24 78 48 89 C7 4A 8B 0C FA 48 8D 94 24 80 00 00 00 E8 1E D3 FF FF 48 89 84 24 88 00 00 00 83 C5 01 41 89 EF 4C 3B BC 24 B0 00 00 00 72 96 48 8D BC 24 B0 00 00 00 E8 ?? ?? ?? ?? 48 83 BC 24 88 00 00 00 00 0F 84 F3 00 00 00 4C 39 B4 24 90 00 00 00 49 8D 46 01 76 41 49 89 C6 E9 CC FE FF FF 49 8B 7C 24 10 BE 08 00 00 00 48 83 C7 01 E8 ?? ?? ?? ?? 48 85 C0 49 89 44 24 08 0F 85 28 F6 FF FF 48 8B BC 24 88 00 00 00 E8 ?? ?? ?? ?? 41 BF 01 00 00 00 E9 FB F8 FF FF 48 8D BC 24 90 00 00 00 E8 ?? ?? ?? ?? E9 29 F7 FF FF 66 0F 1F 84 00 00 00 00 00 48 8B BC 24 88 00 00 00 48 85 FF 74 26 E8 ?? ?? ?? ?? 48 C7 84 24 80 00 00 00 00 00 00 00 48 C7 44 24 78 00 00 00 00 48 C7 84 24 88 00 00 00 00 00 00 00 31 ED 31 C0 48 83 BC 24 B0 00 00 00 00 75 24 EB 7C 0F 1F 40 00 48 89 C6 4C 89 E7 E8 8D C2 FF FF 85 C0 75 25 83 C5 01 89 E8 48 3B 84 24 B0 00 00 00 73 5A 48 8B 94 24 B8 00 00 00 48 8B 3C C2 E8 ?? ?? ?? ?? 48 85 C0 75 CC 48 8D BC 24 B0 00 00 00 E8 ?? ?? ?? ?? 41 BF 01 00 00 00 E9 D0 FC FF FF 0F 1F 40 00 83 F8 01 74 EC B9 ?? ?? ?? ?? BA 8B 01 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 66 2E 0F 1F 84 00 00 00 00 00 48 8D BC 24 B0 00 00 00 E8 ?? ?? ?? ?? E9 C4 FE FF FF 48 39 F9 0F 85 5F F5 FF FF 48 89 F8 66 90 E9 90 F5 FF FF 0F 1F 00 48 8B B4 24 88 00 00 00 45 31 FF 48 85 F6 0F 84 E4 F7 FF FF 4C 89 E7 E8 DC C1 FF FF 41 89 C7 E9 D4 F7 FF FF 89 EE BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 85 C0 0F 85 B3 00 00 00 48 8B BC 24 88 00 00 00 48 8D 94 24 80 00 00 00 48 8D 74 24 78 89 E9 E8 73 C2 FF FF 48 85 C0 48 89 84 24 88 00 00 00 0F 85 D2 F5 FF FF 31 FF E9 80 FE FF FF 0F 1F 00 48 89 F7 E8 ?? ?? ?? ?? 48 C7 44 24 40 00 00 00 00 E9 41 F4 FF FF 48 8D 44 24 60 C7 44 24 60 20 09 0A 00 48 89 44 24 30 48 89 44 24 20 E9 09 F5 FF FF 48 8D 44 24 60 48 89 44 24 30 48 89 C1 E9 F4 F4 FF FF 41 BF 04 00 00 00 48 8B BC 24 88 00 00 00 E8 ?? ?? ?? ?? E9 C0 F7 FF FF 31 FF 41 BF 01 00 00 00 E9 DF F8 FF FF 48 8B BC 24 88 00 00 00 41 BF 04 00 00 00 E9 CC F8 FF FF 41 BF 02 00 00 00 EB C6 0F 1F 40 00 40 80 FD 5C 0F 85 94 F6 FF FF E9 02 F6 FF FF B9 ?? ?? ?? ?? BA 92 01 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_144_0_0 {
	meta:
		name = "__wcrtomb_chk"
		size = 36
		refs = "0003 _nl_current_LC_CTYPE 0020 __chk_fail 001a __wcrtomb"
	strings:
		$1 = { 48 8B 05 ?? ?? ?? ?? 64 48 8B 00 48 8B 00 8B 80 A8 00 00 00 48 39 C8 77 05 E9 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_145_0_0 {
	meta:
		name = "critical_factorization"
		size = 321
	strings:
		$1 = { 41 54 B9 01 00 00 00 49 89 D4 45 31 C0 49 C7 C2 FF FF FF FF 55 BD 01 00 00 00 53 0F 1F 44 00 00 4A 8D 04 01 48 39 F0 73 29 4E 8D 0C 17 41 0F B6 14 09 38 14 07 0F 83 85 00 00 00 49 89 C0 B9 01 00 00 00 48 89 C5 4A 8D 04 01 4C 29 D5 48 39 F0 72 D7 49 89 2C 24 BB 01 00 00 00 41 B8 01 00 00 00 45 31 C9 48 C7 C0 FF FF FF FF 0F 1F 44 00 00 4B 8D 0C 08 48 39 CE 76 26 4C 8D 1C 07 43 0F B6 14 03 38 14 0F 76 59 49 89 C9 41 B8 01 00 00 00 48 89 CB 4B 8D 0C 08 48 29 C3 48 39 CE 77 DA 48 83 C0 01 49 83 C2 01 4C 39 D0 73 06 48 89 EB 4C 89 D0 49 89 1C 24 5B 5D 41 5C C3 0F 1F 44 00 00 74 3E 4D 89 C2 BD 01 00 00 00 49 83 C0 01 B9 01 00 00 00 E9 48 FF FF FF 0F 1F 84 00 00 00 00 00 74 2E 4C 89 C8 BB 01 00 00 00 49 83 C1 01 41 B8 01 00 00 00 E9 77 FF FF FF 0F 1F 80 00 00 00 00 48 39 E9 74 1B 48 83 C1 01 E9 12 FF FF FF 66 90 49 39 D8 74 1B 49 83 C0 01 E9 52 FF FF FF 66 90 48 89 CD 49 89 C0 B9 01 00 00 00 E9 F0 FE FF FF 4C 89 C3 49 89 C9 41 B8 01 00 00 00 E9 2F FF FF FF }
	condition:
		$1
}

rule file_145_1_0 {
	meta:
		name = "two_way_long_needle"
		size = 1006
		refs = "009d memcmp 0145 memchr"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 49 89 FC 55 48 89 F5 48 89 CE 53 48 89 CB 48 81 EC 68 08 00 00 48 89 54 24 10 48 8B 7C 24 10 48 8D 54 24 58 E8 7F FE FF FF 48 8D 94 24 60 08 00 00 48 89 44 24 08 48 8D 44 24 60 0F 1F 44 00 00 48 89 18 48 83 C0 08 48 39 D0 75 F4 31 C0 48 85 DB 48 8D 73 FF 48 8B 7C 24 10 74 1C 0F 1F 40 00 0F B6 14 07 48 89 F1 48 29 C1 48 83 C0 01 48 39 D8 48 89 4C D4 60 75 E8 48 8B 4C 24 58 48 8B 74 24 10 48 8B 54 24 08 48 8B 7C 24 10 48 01 CE 48 89 4C 24 20 E8 ?? ?? ?? ?? 85 C0 0F 85 AF 01 00 00 48 8B 44 24 08 48 8B 54 24 10 48 89 D9 48 2B 4C 24 20 45 31 FF 4C 8D 73 FF 48 C7 44 24 38 01 00 00 00 48 89 5C 24 18 48 89 EF 48 83 E8 01 48 01 C2 48 89 44 24 28 48 8B 44 24 08 49 89 D5 48 89 54 24 40 48 89 4C 24 30 48 F7 D8 49 01 C5 48 89 44 24 48 48 8B 44 24 08 4C 89 EB 48 29 44 24 38 4D 89 E5 4D 89 FC EB 20 0F 1F 80 00 00 00 00 4D 85 E4 74 0B 48 39 44 24 20 48 0F 47 44 24 30 49 01 C7 45 31 E4 48 89 EF 48 8B 6C 24 18 31 F6 4C 01 FD 48 89 EA 48 29 FA 4C 01 EF E8 ?? ?? ?? ?? 48 85 C0 0F 85 F2 00 00 00 48 85 ED 0F 84 E9 00 00 00 41 0F B6 44 2D FF 48 8B 44 C4 60 48 85 C0 75 AD 4C 3B 64 24 08 48 8B 44 24 08 48 8B 74 24 10 49 0F 43 C4 4A 8D 14 38 48 01 C6 4C 01 EA 4C 39 F0 73 35 0F B6 0A 38 0E 0F 85 98 00 00 00 48 89 C7 48 F7 DF 48 01 FE 48 01 FA EB 13 66 2E 0F 1F 84 00 00 00 00 00 0F B6 0C 02 38 0C 06 75 77 48 83 C0 01 4C 39 F0 72 EE 48 8B 44 24 28 48 89 C6 4C 01 FE 4C 01 EE 4C 3B 64 24 08 0F 83 FF 01 00 00 48 8B 4C 24 40 0F B6 16 48 03 74 24 48 38 11 74 1C E9 E9 01 00 00 0F 1F 80 00 00 00 00 0F B6 0C 06 48 8D 50 FF 38 0C 03 75 08 48 89 D0 4C 39 E0 75 EB 49 8D 4C 24 01 48 39 C1 0F 87 C9 01 00 00 4C 03 7C 24 20 4C 8B 64 24 30 E9 04 FF FF FF 66 0F 1F 44 00 00 4C 8B 44 24 38 45 31 E4 4D 01 F8 4D 8D 3C 00 E9 EA FE FF FF 31 C0 48 81 C4 68 08 00 00 5B 5D 41 5C 41 5D 41 5E 41 5F C3 48 89 D8 48 2B 44 24 08 48 8B 54 24 10 48 3B 44 24 08 48 8B 4C 24 08 41 BA 01 00 00 00 48 0F 42 44 24 08 48 03 54 24 08 45 31 F6 4C 8B 5C 24 10 4C 2B 54 24 08 48 89 EF 48 83 E9 01 4C 8D 6B FF 48 89 5C 24 10 48 89 4C 24 18 48 83 C0 01 49 89 D7 49 01 CB 48 89 44 24 38 48 89 44 24 58 4C 89 DD 48 8B 44 24 08 48 89 54 24 20 48 F7 D8 49 01 C7 48 89 44 24 28 4C 89 E0 4C 89 7C 24 30 4D 89 F4 4D 89 D7 49 89 C6 EB 0D 0F 1F 80 00 00 00 00 49 01 C4 48 89 DF 48 8B 5C 24 10 31 F6 4C 01 E3 48 89 DA 48 29 FA 4C 01 F7 E8 ?? ?? ?? ?? 48 85 C0 0F 85 35 FF FF FF 48 85 DB 0F 84 2C FF FF FF 41 0F B6 44 1E FF 48 8B 44 C4 60 48 85 C0 75 C0 48 8B 54 24 08 4C 01 E2 4C 01 F2 4C 39 6C 24 08 73 3B 48 8B 44 24 20 0F B6 0A 38 08 48 8B 44 24 08 75 78 48 03 54 24 28 48 89 DE 48 8B 4C 24 30 EB 0F 66 0F 1F 44 00 00 0F B6 1C 02 38 1C 01 75 57 48 83 C0 01 4C 39 E8 72 EE 48 89 F3 48 8B 7C 24 18 4C 01 E7 4C 01 F7 48 83 7C 24 18 FF 74 28 0F B6 07 38 45 00 75 40 31 C0 EB 17 0F 1F 40 00 0F B6 74 05 FF 0F B6 54 07 FF 48 83 E8 01 40 38 D6 75 25 4C 39 F8 75 E8 4C 89 F0 4D 89 E6 4C 01 F0 E9 88 FE FF FF 66 90 48 89 F3 4F 8D 04 27 4D 8D 24 00 E9 1B FF FF FF 4C 03 64 24 38 E9 11 FF FF FF 48 8B 44 24 08 E9 29 FE FF FF 4B 8D 44 3D 00 E9 58 FE FF FF }
	condition:
		$1
}

rule file_145_2_0 {
	meta:
		name = "strstr"
		size = 1081
		refs = "0073 strchr 0117 memcmp 0191 memchr"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 48 89 FD 53 48 83 EC 68 0F B6 17 84 D2 0F 84 E9 03 00 00 0F B6 0E 84 C9 0F 84 9C 00 00 00 49 89 F5 49 89 F9 41 BA 01 00 00 00 EB 0C 0F 1F 00 41 0F B6 4D 00 84 C9 74 1F 38 CA 0F 94 C0 49 83 C1 01 41 0F B6 11 41 21 C2 49 83 C5 01 84 D2 75 DF 41 80 7D 00 00 75 78 45 84 D2 75 5E 4C 89 EB 48 8D 7D 01 48 29 F3 0F BE 36 E8 ?? ?? ?? ?? 48 85 C0 49 89 C4 74 59 48 83 FB 01 0F 84 A8 03 00 00 48 01 DD 49 29 DD 41 BA 01 00 00 00 49 89 E9 4C 89 6C 24 18 49 29 C1 48 39 E8 4D 0F 47 CA 48 83 FB 1F 76 33 48 8B 54 24 18 48 89 D9 4C 89 CE 48 89 C7 E8 50 FB FF FF 48 89 C5 48 83 C4 68 48 89 E8 5B 5D 41 5C 41 5D 41 5E 41 5F C3 0F 1F 00 31 ED EB E7 0F 1F 40 00 48 8D 54 24 58 48 89 DE 4C 89 EF 4C 89 0C 24 4C 89 54 24 08 E8 C7 F9 FF FF 48 8B 4C 24 58 48 8B 74 24 18 48 89 C2 48 8B 7C 24 18 49 89 C7 48 01 CE 48 89 4C 24 28 E8 ?? ?? ?? ?? 85 C0 4C 8B 0C 24 4C 8B 54 24 08 0F 85 4D 01 00 00 48 8B 44 24 18 49 8D 4F FF 31 ED 4D 29 FA 49 89 DD 4C 89 CF 48 89 4C 24 20 4C 89 54 24 40 48 01 C8 48 89 D9 48 2B 4C 24 28 49 89 C6 48 89 44 24 30 4C 89 7C 24 10 48 89 4C 24 48 4C 89 F9 48 F7 D9 49 01 CE 48 89 4C 24 38 4C 89 F0 49 89 EE 48 89 C3 66 90 4E 8D 7C 2D 00 31 F6 4C 89 FA 48 29 FA 4C 01 E7 E8 ?? ?? ?? ?? 48 85 C0 0F 85 3A FF FF FF 4D 85 FF 0F 84 31 FF FF FF 4C 3B 74 24 10 48 8B 44 24 10 48 8B 74 24 18 49 0F 43 C6 48 8D 14 28 48 01 C6 4C 01 E2 49 39 C5 76 31 0F B6 0A 38 0E 0F 85 94 00 00 00 48 89 C7 48 F7 DF 48 01 FE 48 01 FA EB 0F 66 0F 1F 44 00 00 0F B6 0C 02 38 0C 06 75 77 48 83 C0 01 49 39 C5 77 EE 48 8B 44 24 20 48 89 C6 48 01 EE 4C 01 E6 4C 39 74 24 10 0F 86 E8 01 00 00 48 8B 4C 24 30 0F B6 16 48 03 74 24 38 38 11 74 1C E9 D2 01 00 00 0F 1F 80 00 00 00 00 0F B6 0C 06 48 8D 50 FF 38 0C 03 75 08 48 89 D0 4C 39 F0 75 EB 4D 8D 46 01 4C 39 C0 0F 82 C1 01 00 00 48 03 6C 24 28 4C 8B 74 24 48 4C 89 FF E9 1C FF FF FF 0F 1F 40 00 4C 8B 5C 24 40 45 31 F6 49 01 EB 49 8D 2C 03 EB E3 4B 8D 0C 3C 48 89 D8 48 8B 54 24 18 4C 29 F8 4C 8B 6C 24 18 4D 89 D6 4C 39 F8 48 89 4C 24 20 48 89 CE 49 8D 4F 01 49 0F 42 C7 46 0F B6 1C 3A 48 83 C0 01 4D 29 FE 4C 89 7C 24 38 48 01 CA 48 89 44 24 40 48 89 44 24 58 48 89 54 24 28 49 8D 47 FF 48 8B 6C 24 28 4C 89 FA 4C 89 CF 45 89 DF 49 01 C5 48 F7 DA 48 89 44 24 30 4C 89 F0 48 89 54 24 18 4D 89 EE 48 01 D5 4D 89 E5 48 89 4C 24 10 49 89 C4 EB 0D 66 90 84 C0 0F 84 D0 FD FF FF 4C 89 CE 0F B6 06 4C 8D 4E 01 41 38 C7 75 E9 4C 2B 4C 24 20 48 8B 44 24 10 48 39 C3 4D 8D 41 FF 76 36 48 8B 4C 24 28 0F B6 56 01 48 83 C6 02 48 03 74 24 18 38 11 74 17 E9 DB 00 00 00 0F 1F 00 0F B6 54 06 FE 38 54 05 FF 0F 85 C9 00 00 00 48 83 C0 01 48 39 C3 77 E8 4C 8B 4C 24 30 4D 01 C1 4D 01 E9 48 83 7C 24 30 FF 74 26 41 0F B6 11 31 C0 41 38 16 74 16 EB 23 41 0F B6 4C 06 FF 41 0F B6 54 01 FF 48 83 E8 01 38 D1 75 0F 4C 39 E0 75 E7 4B 8D 6C 05 00 E9 20 FD FF FF 84 D2 0F 84 2D FD FF FF 4C 8B 4C 24 40 4D 01 C1 4D 8D 04 19 31 F6 4C 89 0C 24 4C 89 C2 4C 89 44 24 08 48 29 FA 4C 01 EF E8 ?? ?? ?? ?? 48 85 C0 4C 8B 44 24 08 4C 8B 0C 24 0F 85 F6 FC FF FF 4D 85 C0 0F 84 ED FC FF FF 4C 03 4C 24 38 4C 89 C7 4D 01 E9 E9 0D FF FF FF 48 8B 44 24 10 E9 40 FE FF FF 49 89 F5 41 BA 01 00 00 00 E9 46 FC FF FF 49 8D 2C 2C E9 A7 FC FF FF 0F 1F 40 00 84 D2 0F 84 B0 FC FF FF 4D 01 E0 4D 8D 0C 00 EB 82 48 89 C5 E9 8A FC FF FF }
	condition:
		$1
}

rule file_146_2_0 {
	meta:
		name = "__libc_allocate_rtsig"
		size = 60
	strings:
		$1 = { 8B 05 ?? ?? ?? ?? 83 F8 FF 74 22 8B 15 ?? ?? ?? ?? 39 D0 7F 13 85 FF 74 17 8D 50 01 89 15 ?? ?? ?? ?? C3 0F 1F 44 00 00 B8 FF FF FF FF F3 C3 90 8D 42 FF 89 05 ?? ?? ?? ?? 89 D0 C3 }
	condition:
		$1
}

rule file_148_0_0 {
	meta:
		name = "_L_lock_33"
		size = 27
		refs = "000b __lll_lock_wait_private"
	strings:
		$1 = { 48 8D 3A 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 F2 FE FF FF }
	condition:
		$1
}

rule file_148_1_0 {
	meta:
		name = "_L_unlock_155"
		size = 27
		refs = "000b __lll_unlock_wake_private"
		altNames = "_L_unlock_106"
	strings:
		$1 = { 48 8D 3E 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 75 FF FF FF }
	condition:
		$1
}

rule file_148_3_0 {
	meta:
		name = "_IO_ftell"
		size = 313
		refs = "002a __libc_multiple_threads 0062 _IO_seekoff_unlocked 00ab __libc_errno 0135 _Unwind_Resume"
		altNames = "ftello"
	strings:
		$1 = { 53 8B 07 48 89 FB 25 00 80 00 00 75 48 48 8B 97 88 00 00 00 64 4C 8B 04 25 10 00 00 00 4C 3B 42 08 74 2E BE 01 00 00 00 83 3D ?? ?? ?? ?? 00 74 0C F0 0F B1 32 0F 85 FE 00 00 00 EB 09 0F B1 32 0F 85 F3 00 00 00 48 8B 93 88 00 00 00 4C 89 42 08 83 42 04 01 31 C9 BA 01 00 00 00 31 F6 48 89 DF E8 ?? ?? ?? ?? 48 89 C2 8B 03 F6 C4 01 74 10 48 83 FA FF 74 0A 8B B3 C0 00 00 00 85 F6 7E 70 F6 C4 80 75 13 48 8B B3 88 00 00 00 83 6E 04 01 74 36 66 0F 1F 44 00 00 48 83 FA FF 74 0A 48 89 D0 5B C3 0F 1F 44 00 00 48 8B 05 ?? ?? ?? ?? 64 8B 08 85 C9 75 E8 64 C7 00 05 00 00 00 48 89 D0 5B C3 66 0F 1F 44 00 00 48 C7 46 08 00 00 00 00 83 3D ?? ?? ?? ?? 00 74 07 F0 FF 0E 75 76 EB 04 FF 0E 75 70 EB B2 66 2E 0F 1F 84 00 00 00 00 00 48 8B 4B 48 48 2B 4B 58 48 01 CA EB 83 F7 03 00 80 00 00 48 89 C6 75 29 48 8B 93 88 00 00 00 83 6A 04 01 75 1C 48 C7 42 08 00 00 00 00 83 3D ?? ?? ?? ?? 00 74 07 F0 FF 0A 75 44 EB 04 FF 0A 75 3E 48 89 F7 E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_150_0_0 {
	meta:
		name = "_L_lock_26"
		size = 31
		refs = "000f __lll_lock_wait_private"
	strings:
		$1 = { 48 8D 3D ?? ?? ?? ?? 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 3D FE FF FF }
	condition:
		$1
}

rule file_1004_1_0 {
	meta:
		name = "_L_unlock_33"
		size = 31
		refs = "000f __lll_unlock_wake_private"
	strings:
		$1 = { 48 8D 3D ?? ?? ?? ?? 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 3D FE FF FF }
	condition:
		$1
}

rule file_150_1_0 {
	meta:
		name = "_L_unlock_130"
		size = 31
		refs = "000f __lll_unlock_wake_private"
	strings:
		$1 = { 48 8D 3D ?? ?? ?? ?? 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 E5 FE FF FF }
	condition:
		$1
}

rule file_150_2_0 {
	meta:
		name = "__new_exitfn"
		size = 339
		refs = "0012 __libc_multiple_threads 00d4 __new_exitfn_called 0125 calloc 014b __assert_fail"
	strings:
		$1 = { 55 BE 01 00 00 00 31 C0 53 48 89 FB 48 83 EC 08 83 3D ?? ?? ?? ?? 00 74 10 F0 0F B1 35 ?? ?? ?? ?? 0F 85 B3 01 00 00 EB 0D 0F B1 35 ?? ?? ?? ?? 0F 85 A4 01 00 00 48 8B 2B 48 85 ED 0F 84 F4 00 00 00 49 89 E8 31 C0 66 0F 1F 84 00 00 00 00 00 49 8B 70 08 48 85 F6 74 3E 48 8D 56 FF 48 89 D1 48 C1 E1 05 49 83 7C 08 10 00 75 44 48 C1 E6 05 49 8D 4C 30 D0 EB 18 66 0F 1F 84 00 00 00 00 00 48 83 E9 20 48 83 79 20 00 75 25 48 83 EA 01 48 85 D2 48 89 D6 75 E9 49 8B 10 49 C7 40 08 00 00 00 00 4C 89 C0 48 85 D2 74 62 49 89 D0 EB A1 90 48 83 FE 20 74 51 48 89 F0 48 83 C6 01 48 C1 E0 05 49 89 70 08 49 8D 54 00 10 48 C7 02 01 00 00 00 48 83 05 ?? ?? ?? ?? 01 83 3D ?? ?? ?? ?? 00 74 0F F0 FF 0D ?? ?? ?? ?? 0F 85 0A 01 00 00 EB 0C FF 0D ?? ?? ?? ?? 0F 85 FC 00 00 00 48 83 C4 08 48 89 D0 5B 5D C3 48 85 C0 74 0E 48 8D 50 10 48 C7 40 08 01 00 00 00 EB B0 BE 10 04 00 00 BF 01 00 00 00 E8 ?? ?? ?? ?? 48 85 C0 74 21 48 89 28 48 89 03 EB D6 B9 ?? ?? ?? ?? BA 63 00 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 31 D2 EB 86 }
	condition:
		$1
}

rule file_150_3_0 {
	meta:
		name = "__internal_atexit"
		size = 104
		refs = "0020 __new_exitfn"
	strings:
		$1 = { 48 89 5C 24 E8 48 89 6C 24 F0 48 89 FB 4C 89 64 24 F8 48 89 CF 48 83 EC 18 49 89 F4 48 89 D5 E8 ?? ?? ?? ?? 48 85 C0 74 38 48 89 DF 4C 89 60 10 48 89 68 18 64 48 33 3C 25 30 00 00 00 48 C1 C7 11 48 89 78 08 48 C7 00 04 00 00 00 31 C0 48 8B 1C 24 48 8B 6C 24 08 4C 8B 64 24 10 48 83 C4 18 C3 B8 FF FF FF FF EB E6 }
	condition:
		$1
}

rule file_151_0_0 {
	meta:
		name = "__sched_getscheduler"
		size = 20
		refs = "000f __syscall_error"
	strings:
		$1 = { B8 91 00 00 00 0F 05 48 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_152_0_0 {
	meta:
		name = "putmsg"
		size = 20
		refs = "0003 __libc_errno"
		altNames = "__sigreturn fattach fdetach getmsg lchmod revoke setlogin"
	strings:
		$1 = { 48 8B 05 ?? ?? ?? ?? 64 C7 00 26 00 00 00 B8 FF FF FF FF C3 }
	condition:
		$1
}

rule file_153_0_0 {
	meta:
		name = "__wcscat_chk"
		size = 84
		refs = "0050 __chk_fail"
	strings:
		$1 = { 48 83 EC 08 49 89 F8 EB 0A 0F 1F 80 00 00 00 00 4C 89 CA 48 85 D2 74 37 41 8B 08 49 83 C0 04 4C 8D 4A FF 85 C9 75 E9 31 C9 EB 0E 0F 1F 44 00 00 48 83 C1 01 48 39 D1 74 16 44 8B 0C 8E 45 85 C9 45 89 4C 88 FC 75 E9 48 89 F8 48 83 C4 08 C3 E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_154_0_0 {
	meta:
		name = "__readlinkat_chk"
		size = 16
		refs = "000c __chk_fail 0006 readlinkat"
	strings:
		$1 = { 4C 39 C1 77 05 E9 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_155_0_0 {
	meta:
		name = "_IO_wpadn"
		size = 177
	strings:
		$1 = { 41 55 41 BD ?? ?? ?? ?? 41 54 49 89 FC 55 53 48 83 EC 48 83 FE 20 74 26 83 FE 30 41 BD ?? ?? ?? ?? 74 1B 48 8D 44 24 3C 48 8D 4C 24 FC 0F 1F 00 89 30 48 83 E8 04 48 39 C8 75 F5 49 89 E5 31 ED 83 FA 0F 89 D3 7F 11 EB 3F 0F 1F 80 00 00 00 00 83 EB 10 83 FB 0F 7E 30 49 8B 84 24 D8 00 00 00 BA 10 00 00 00 4C 89 EE 4C 89 E7 FF 50 38 48 01 C5 48 83 F8 10 74 D9 48 83 C4 48 48 89 E8 5B 5D 41 5C 41 5D C3 0F 1F 00 85 DB 7E EB 49 8B 84 24 D8 00 00 00 48 63 D3 4C 89 EE 4C 89 E7 FF 50 38 48 83 C4 48 48 01 C5 5B 48 89 E8 5D 41 5C 41 5D C3 }
	condition:
		$1
}

rule file_156_0_0 {
	meta:
		name = "mkostemps"
		size = 36
		refs = "0013 __libc_errno 0007 __gen_tempname"
		altNames = "mkostemps64"
	strings:
		$1 = { 85 F6 78 0C 31 C9 E9 ?? ?? ?? ?? 0F 1F 44 00 00 48 8B 05 ?? ?? ?? ?? 64 C7 00 16 00 00 00 B8 FF FF FF FF C3 }
	condition:
		$1
}

rule file_157_0_0 {
	meta:
		name = "fgets_unlocked"
		size = 185
		refs = "0050 _IO_getline 0065 __libc_errno"
	strings:
		$1 = { 48 89 5C 24 E8 48 89 6C 24 F0 4C 89 64 24 F8 48 83 EC 18 85 F6 0F 8E 95 00 00 00 83 FE 01 48 89 FD 0F 84 8D 00 00 00 8B 02 48 89 D3 83 EE 01 B9 0A 00 00 00 41 B8 01 00 00 00 41 89 C4 83 E0 DF 89 02 48 63 D6 48 89 FE 48 89 DF 41 83 E4 20 E8 ?? ?? ?? ?? 31 C9 48 85 C0 8B 13 74 1B F6 C2 20 74 3E 48 8B 35 ?? ?? ?? ?? 31 C9 64 83 3E 0B 74 2F 0F 1F 80 00 00 00 00 44 09 E2 48 89 CD 89 13 48 89 E8 48 8B 1C 24 48 8B 6C 24 08 4C 8B 64 24 10 48 83 C4 18 C3 66 2E 0F 1F 84 00 00 00 00 00 C6 44 05 00 00 48 89 E9 8B 13 EB CC 0F 1F 40 00 31 ED EB CC C6 07 00 EB C7 }
	condition:
		$1
}

rule file_158_0_0 {
	meta:
		name = "enlarge_userbuf.part.0"
		size = 482
		refs = "00ba __wmemcpy 00ea _IO_wsetb 0160 wmemset 01de __assert_fail"
	strings:
		$1 = { 4C 89 6C 24 E8 4C 89 74 24 F0 48 89 5C 24 D0 48 89 6C 24 D8 4C 89 64 24 E0 4C 89 7C 24 F8 48 83 EC 58 4C 8B AF A0 00 00 00 F6 47 74 08 89 54 24 14 49 8B 45 18 4D 8B 75 28 48 89 44 24 08 74 30 B8 01 00 00 00 48 8B 5C 24 28 48 8B 6C 24 30 4C 8B 64 24 38 4C 8B 6C 24 40 4C 8B 74 24 48 4C 8B 7C 24 50 48 83 C4 58 C3 0F 1F 84 00 00 00 00 00 48 8D 04 B5 90 01 00 00 49 89 FC 48 89 F5 49 8B 5D 30 48 89 44 24 18 48 89 C7 41 FF 94 24 E0 00 00 00 48 85 C0 49 89 C7 74 A6 48 85 DB 74 32 49 8B 84 24 A0 00 00 00 48 89 DE 4C 89 FF 48 8B 50 38 48 2B 50 30 48 C1 FA 02 E8 ?? ?? ?? ?? 48 89 DF 41 FF 94 24 E8 00 00 00 49 C7 45 30 00 00 00 00 48 8B 54 24 18 4C 2B 74 24 08 B9 01 00 00 00 4C 89 FE 4C 89 E7 4C 01 FA E8 ?? ?? ?? ?? 8B 44 24 14 49 C1 FE 02 85 C0 75 76 49 8B 45 10 4D 89 7D 18 48 29 D8 48 83 E0 FC 4C 01 F8 49 89 45 10 49 8B 45 00 48 29 D8 48 83 E0 FC 4C 01 F8 49 89 45 00 49 8B 45 08 48 29 D8 48 83 E0 FC 4C 01 F8 49 89 45 08 49 8B 45 20 48 29 D8 48 83 E0 FC 4C 01 F8 49 39 EE 49 89 45 20 49 8B 45 38 49 89 45 28 7F 76 48 89 EA 4B 8D 3C B7 31 F6 4C 29 F2 E8 ?? ?? ?? ?? 31 C0 E9 DA FE FF FF 0F 1F 44 00 00 49 8B 45 18 4D 89 7D 10 48 29 D8 48 83 E0 FC 4C 01 F8 49 89 45 18 49 8B 45 20 48 29 D8 48 83 E0 FC 4C 01 F8 49 89 45 20 49 8B 45 28 48 29 D8 48 83 E0 FC 4C 01 F8 49 89 45 28 49 8B 45 00 48 29 D8 48 83 E0 FC 4C 01 F8 49 39 EE 49 89 45 00 49 8B 45 38 49 89 45 08 7E 8A B9 ?? ?? ?? ?? BA E6 00 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_158_1_0 {
	meta:
		name = "_IO_wstr_underflow"
		size = 91
	strings:
		$1 = { 48 8B 87 A0 00 00 00 48 8B 50 20 48 8B 70 08 48 39 F2 76 07 48 89 50 08 48 89 D6 8B 0F 81 E1 00 0C 00 00 81 F9 00 0C 00 00 74 1D 48 8B 10 48 39 D6 B8 FF FF FF FF 77 08 F3 C3 66 0F 1F 44 00 00 8B 02 C3 0F 1F 44 00 00 48 8B 48 28 81 27 FF F7 FF FF 48 89 10 48 89 48 20 EB D3 }
	condition:
		$1
}

rule file_158_2_0 {
	meta:
		name = "_IO_wstr_finish"
		size = 58
		refs = "0036 _IO_wdefault_finish"
	strings:
		$1 = { 53 48 8B 87 A0 00 00 00 48 89 FB 48 8B 78 30 48 85 FF 74 13 F6 43 74 08 75 0D FF 93 E8 00 00 00 48 8B 83 A0 00 00 00 48 C7 40 30 00 00 00 00 48 89 DF 31 F6 5B E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_158_3_0 {
	meta:
		name = "_IO_wstr_pbackfail"
		size = 21
		refs = "0011 _IO_wdefault_pbackfail"
	strings:
		$1 = { F6 07 08 74 0B 83 FE FF 74 06 B8 FF FF FF FF C3 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_158_4_0 {
	meta:
		name = "_IO_wstr_overflow"
		size = 511
		refs = "0100 __wmemcpy 0130 wmemset 0148 _IO_wsetb"
	strings:
		$1 = { 4C 89 6C 24 E8 48 89 5C 24 D0 48 89 6C 24 D8 4C 89 64 24 E0 4C 89 74 24 F0 4C 89 7C 24 F8 48 83 EC 48 8B 07 83 FE FF 0F 94 C2 44 0F B6 EA A8 08 74 2E 41 83 FD 01 19 DB 89 D8 48 8B 6C 24 20 48 8B 5C 24 18 4C 8B 64 24 28 4C 8B 6C 24 30 4C 8B 74 24 38 4C 8B 7C 24 40 48 83 C4 48 C3 0F 1F 00 89 C1 49 89 FC 89 F3 81 E1 00 0C 00 00 81 F9 00 04 00 00 0F 84 67 01 00 00 48 8B 8F A0 00 00 00 48 8B 41 20 4C 8B 71 30 48 8B 69 38 0F B6 D2 48 2B 41 18 4C 29 F5 48 C1 FD 02 48 C1 F8 02 48 01 EA 48 39 D0 0F 82 06 01 00 00 41 F6 44 24 74 08 74 0E BB FF FF FF FF E9 7C FF FF FF 0F 1F 40 00 48 8D 45 32 48 8D 0C 00 48 39 CD 77 E5 48 C1 E0 03 48 89 0C 24 48 89 44 24 08 48 89 C7 41 FF 94 24 E0 00 00 00 48 85 C0 49 89 C7 48 8B 0C 24 74 C1 4D 85 F6 74 2D 48 89 EA 4C 89 F6 48 89 C7 E8 ?? ?? ?? ?? 4C 89 F7 41 FF 94 24 E8 00 00 00 49 8B 84 24 A0 00 00 00 48 8B 0C 24 48 C7 40 30 00 00 00 00 48 89 CA 49 8D 3C AF 31 F6 48 29 EA E8 ?? ?? ?? ?? 48 8B 54 24 08 B9 01 00 00 00 4C 89 FE 4C 89 E7 4C 01 FA E8 ?? ?? ?? ?? 49 8B 8C 24 A0 00 00 00 48 8B 41 10 4C 89 79 18 4C 29 F0 48 83 E0 FC 4C 01 F8 48 89 41 10 48 8B 01 4C 29 F0 48 83 E0 FC 4C 01 F8 48 89 01 48 8B 41 08 4C 29 F0 48 83 E0 FC 4C 01 F8 48 89 41 08 48 8B 41 20 4C 29 F0 48 83 E0 FC 4C 01 F8 48 89 41 20 48 8B 41 38 48 89 41 28 66 2E 0F 1F 84 00 00 00 00 00 45 85 ED 48 8B 41 20 75 0A 89 18 48 83 C0 04 48 89 41 20 48 3B 41 08 0F 86 6B FE FF FF 48 89 41 08 E9 62 FE FF FF 66 2E 0F 1F 84 00 00 00 00 00 48 8B 8F A0 00 00 00 80 CC 08 89 07 48 8B 71 08 48 8B 01 48 89 31 48 89 41 20 E9 85 FE FF FF }
	condition:
		$1
}

rule file_158_5_0 {
	meta:
		name = "_IO_wstr_seekoff"
		size = 573
	strings:
		$1 = { 48 89 6C 24 E8 4C 89 64 24 F0 48 89 F5 4C 89 6C 24 F8 48 89 5C 24 E0 48 83 EC 38 85 C9 49 89 FC 41 89 D5 75 6B 8B 07 F6 C4 04 0F 84 20 01 00 00 F6 C4 08 0F 84 A7 00 00 00 4C 8B 87 A0 00 00 00 49 8B 58 08 49 39 58 20 49 0F 43 58 20 49 2B 58 10 48 C1 FB 02 41 83 FD 01 0F 84 49 01 00 00 48 8D 44 1D 00 41 83 FD 02 48 0F 44 E8 48 85 ED 0F 88 BC 01 00 00 48 39 DD 0F 8F 82 01 00 00 49 8B 40 18 48 8D 04 A8 49 89 40 20 48 89 E8 EB 33 90 4C 8B 87 A0 00 00 00 49 8B 58 08 49 39 58 20 49 0F 43 58 20 49 8B 40 10 48 29 C3 48 C1 FB 02 F6 C1 01 75 50 83 E1 02 48 C7 C0 FF FF FF FF 85 C9 75 93 48 8B 5C 24 18 48 8B 6C 24 20 4C 8B 64 24 28 4C 8B 6C 24 30 48 83 C4 38 C3 0F 1F 44 00 00 4C 8B 87 A0 00 00 00 B9 01 00 00 00 49 8B 58 20 49 39 58 08 49 0F 43 58 08 49 8B 40 10 48 29 C3 48 C1 FB 02 41 83 FD 01 0F 84 82 00 00 00 48 8D 44 1D 00 41 83 FD 02 48 0F 44 E8 48 85 ED 0F 88 0D 01 00 00 48 39 DD 0F 8F 93 00 00 00 49 8B 40 10 83 E1 02 48 8D 14 A8 48 8D 04 98 49 89 10 49 89 40 08 48 89 E8 E9 73 FF FF FF 0F 1F 44 00 00 A8 08 74 1C 49 8B 94 24 A0 00 00 00 48 8B 02 48 2B 42 10 48 C1 F8 02 E9 56 FF FF FF 0F 1F 40 00 49 8B 94 24 A0 00 00 00 48 8B 42 20 48 2B 42 18 48 C1 F8 02 E9 39 FF FF FF 0F 1F 80 00 00 00 00 49 8B 10 48 29 C2 48 C1 FA 02 48 01 D5 E9 79 FF FF FF 66 0F 1F 44 00 00 49 8B 40 20 49 2B 40 18 48 C1 F8 02 48 01 C5 E9 B0 FE FF FF 0F 1F 40 00 49 8B 44 24 40 49 2B 44 24 38 48 39 C5 0F 8E 5A FF FF FF BA 01 00 00 00 48 89 EE 4C 89 E7 89 4C 24 08 E8 29 FC FF FF 85 C0 8B 4C 24 08 75 42 4D 8B 84 24 A0 00 00 00 E9 31 FF FF FF 0F 1F 40 00 49 8B 44 24 40 49 2B 44 24 38 48 39 C5 0F 8E 6B FE FF FF 31 D2 48 89 EE 4C 89 E7 E8 F0 FB FF FF 85 C0 75 0D 4D 8B 84 24 A0 00 00 00 E9 4D FE FF FF 48 C7 C0 FF FF FF FF E9 85 FE FF FF }
	condition:
		$1
}

rule file_158_6_0 {
	meta:
		name = "_IO_wstr_init_static"
		size = 190
		refs = "002a __wcslen 003e _IO_wsetb"
	strings:
		$1 = { 48 89 5C 24 E0 48 89 6C 24 E8 48 89 F3 4C 89 64 24 F0 4C 89 6C 24 F8 48 83 EC 28 48 85 D2 48 89 FD 49 89 CC 75 6A 48 89 F7 E8 ?? ?? ?? ?? 4C 8D 2C 83 31 C9 4C 89 EA 48 89 DE 48 89 EF E8 ?? ?? ?? ?? 48 8B 85 A0 00 00 00 4D 85 E4 48 89 58 18 48 89 58 10 48 89 18 74 57 4C 89 60 20 4C 89 68 28 4C 89 60 08 48 C7 85 E0 00 00 00 00 00 00 00 48 8B 5C 24 08 48 8B 6C 24 10 4C 8B 64 24 18 4C 8B 6C 24 20 48 83 C4 28 C3 0F 1F 80 00 00 00 00 4C 8D 2C 96 4C 39 EE 72 99 49 89 F5 49 F7 D5 49 83 E5 FC 49 01 F5 EB 8A 0F 1F 84 00 00 00 00 00 48 89 58 20 48 89 58 28 4C 89 68 08 EB A7 }
	condition:
		$1
}

rule file_158_7_0 {
	meta:
		name = "_IO_wstr_count"
		size = 29
	strings:
		$1 = { 48 8B 97 A0 00 00 00 48 8B 42 08 48 39 42 20 48 0F 43 42 20 48 2B 42 10 48 C1 F8 02 C3 }
	condition:
		$1
}

rule file_159_0_0 {
	meta:
		name = "_L_lock_31"
		size = 24
		refs = "000b __lll_lock_wait_private"
	strings:
		$1 = { 48 8D 3A 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 EB 8A }
	condition:
		$1
}

rule file_159_1_0 {
	meta:
		name = "_L_unlock_63"
		size = 24
		refs = "000b __lll_unlock_wake_private"
	strings:
		$1 = { 48 8D 3A 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 EB C1 }
	condition:
		$1
}

rule file_159_2_0 {
	meta:
		name = "_IO_ungetc"
		size = 168
		refs = "0036 __libc_multiple_threads 0061 _IO_sputbackc"
	strings:
		$1 = { 83 FF FF 41 89 F8 0F 84 99 00 00 00 53 8B 06 48 89 F3 25 00 80 00 00 75 40 48 8B 96 88 00 00 00 64 4C 8B 0C 25 10 00 00 00 4C 3B 4A 08 74 26 BE 01 00 00 00 83 3D ?? ?? ?? ?? 00 74 08 F0 0F B1 32 75 65 EB 05 0F B1 32 75 5E 48 8B 93 88 00 00 00 4C 89 4A 08 83 42 04 01 41 0F B6 F0 48 89 DF E8 ?? ?? ?? ?? F7 03 00 80 00 00 41 89 C0 75 30 48 8B 93 88 00 00 00 83 6A 04 01 75 23 48 C7 42 08 00 00 00 00 83 3D ?? ?? ?? ?? 00 74 07 F0 FF 0A 75 2D EB 04 FF 0A 75 27 0F 1F 80 00 00 00 00 44 89 C0 5B C3 89 F8 C3 }
	condition:
		$1
}

rule file_160_0_0 {
	meta:
		name = "__dladdr1"
		size = 37
		refs = "0012 _dl_addr"
	strings:
		$1 = { 83 F9 01 74 1B 83 F9 02 B9 00 00 00 00 74 02 31 D2 E9 ?? ?? ?? ?? 66 2E 0F 1F 84 00 00 00 00 00 48 89 D1 EB EA }
	condition:
		$1
}

rule file_161_0_0 {
	meta:
		name = "__fxprintf"
		size = 323
		refs = "0067 stderr 00a6 strlen 00f8 __vfwprintf 011b _IO_vfprintf 013f __assert_fail"
	strings:
		$1 = { 55 48 89 E5 41 55 49 89 FD 41 54 53 48 81 EC D8 00 00 00 84 C0 48 89 95 40 FF FF FF 48 89 8D 48 FF FF FF 4C 89 85 50 FF FF FF 4C 89 8D 58 FF FF FF 74 26 0F 29 85 60 FF FF FF 0F 29 8D 70 FF FF FF 0F 29 55 80 0F 29 5D 90 0F 29 65 A0 0F 29 6D B0 0F 29 75 C0 0F 29 7D D0 4D 85 ED 48 8D 45 10 49 89 F4 4C 0F 44 2D ?? ?? ?? ?? 48 89 85 20 FF FF FF 48 8D 85 30 FF FF FF C7 85 18 FF FF FF 10 00 00 00 C7 85 1C FF FF FF 30 00 00 00 48 89 85 28 FF FF FF 41 8B 85 C0 00 00 00 85 C0 7E 71 48 89 F7 48 89 E3 E8 ?? ?? ?? ?? 48 83 C0 01 48 8D 14 85 12 00 00 00 48 83 E2 F0 48 29 D4 48 85 C0 48 89 E6 74 28 41 0F BE 0C 24 84 C9 78 5C 31 D2 EB 0F 66 0F 1F 44 00 00 41 0F BE 0C 14 84 C9 78 49 89 0C 96 48 83 C2 01 48 39 D0 75 EB 48 8D 95 18 FF FF FF 4C 89 EF E8 ?? ?? ?? ?? 48 89 DC 48 8D 65 E8 5B 41 5C 41 5D 5D C3 66 0F 1F 44 00 00 48 8D 95 18 FF FF FF 4C 89 EF E8 ?? ?? ?? ?? 48 8D 65 E8 5B 41 5C 41 5D 5D C3 B9 ?? ?? ?? ?? BA 2E 00 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_162_0_0 {
	meta:
		name = "__vdprintf_chk"
		size = 227
		refs = "000c _IO_wfile_jumps 004b _IO_no_init 005a _IO_file_jumps 005f _IO_file_init 0069 _IO_file_attach 0094 _IO_vfprintf 00dd _IO_un_link"
	strings:
		$1 = { 48 89 5C 24 E0 48 89 6C 24 E8 41 B8 ?? ?? ?? ?? 4C 89 64 24 F0 4C 89 6C 24 F8 48 81 EC 58 02 00 00 49 89 CC 48 8D 8C 24 E0 00 00 00 89 FB 41 89 F5 48 89 E7 BE 00 80 00 00 48 89 D5 31 D2 48 C7 84 24 88 00 00 00 00 00 00 00 E8 ?? ?? ?? ?? 48 89 E7 48 C7 84 24 D8 00 00 00 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 DE 48 89 E7 E8 ?? ?? ?? ?? 48 85 C0 74 62 8B 04 24 25 F3 EF FF FF 83 C8 44 45 85 ED 89 04 24 7E 05 83 4C 24 74 04 48 89 EE 48 89 E7 4C 89 E2 E8 ?? ?? ?? ?? 89 C3 48 8B 84 24 D8 00 00 00 31 F6 48 89 E7 FF 50 10 89 D8 48 8B AC 24 40 02 00 00 48 8B 9C 24 38 02 00 00 4C 8B A4 24 48 02 00 00 4C 8B AC 24 50 02 00 00 48 81 C4 58 02 00 00 C3 48 89 E7 BB FF FF FF FF E8 ?? ?? ?? ?? EB C7 }
	condition:
		$1
}

rule file_163_0_0 {
	meta:
		name = "__tcgetattr"
		size = 164
		refs = "0097 __libc_errno"
	strings:
		$1 = { 49 89 F0 48 8D 54 24 C8 BE 01 54 00 00 48 63 FF B8 10 00 00 00 0F 05 48 3D 00 F0 FF FF 77 75 85 C0 75 70 8B 4C 24 D4 8B 54 24 C8 41 89 48 0C 0F B6 4C 24 D8 41 89 10 8B 54 24 CC 41 88 48 10 48 8B 4C 24 D9 41 89 50 04 8B 54 24 D0 49 89 48 11 48 8B 4C 24 E1 41 89 50 08 81 E2 0F 10 00 00 41 89 50 34 41 89 50 38 49 89 48 19 0F B7 4C 24 E9 66 41 89 48 21 0F B6 4C 24 EB 49 C7 40 24 00 00 00 00 41 C7 40 2C 00 00 00 00 41 C6 40 30 00 41 88 48 23 C3 48 8B 15 ?? ?? ?? ?? F7 D8 64 89 02 83 C8 FF C3 }
	condition:
		$1
}

rule file_164_0_0 {
	meta:
		name = "ptrace"
		size = 137
		refs = "0066 __libc_errno"
	strings:
		$1 = { 48 8D 44 24 08 4C 8D 54 24 B0 48 89 74 24 D8 41 89 F8 48 89 54 24 E0 48 89 4C 24 E8 48 89 44 24 C0 48 8D 44 24 D0 48 63 74 24 D8 C7 44 24 B8 18 00 00 00 48 89 44 24 C8 8D 47 FF 89 FF 83 F8 02 B8 65 00 00 00 4C 0F 47 D1 0F 05 48 3D 00 F0 FF FF 77 25 48 85 C0 78 1E 45 85 C0 74 19 41 83 F8 03 77 13 48 8B 05 ?? ?? ?? ?? 64 C7 00 00 00 00 00 48 8B 44 24 B0 F3 C3 48 8B 15 ?? ?? ?? ?? F7 D8 64 89 02 48 83 C8 FF C3 }
	condition:
		$1
}

rule file_165_0_0 {
	meta:
		name = "__inet_aton"
		size = 315
		refs = "0025 __libc_errno 006b strtoul 0126 __libc_tsd_CTYPE_B"
	strings:
		$1 = { 4C 89 74 24 F0 48 89 5C 24 D0 48 89 6C 24 D8 4C 89 64 24 E0 4C 89 6C 24 E8 4C 89 7C 24 F8 48 83 EC 58 48 8B 05 ?? ?? ?? ?? 48 89 74 24 08 C7 44 24 10 00 00 00 00 64 44 8B 30 64 C7 00 00 00 00 00 0F BE 07 83 E8 30 83 F8 09 77 64 4C 8D 6C 24 10 48 89 FD BB FF FF FF FF 4D 8D 65 03 4D 89 EF 48 8D 74 24 18 31 D2 48 89 EF E8 ?? ?? ?? ?? 48 39 D8 77 3C 48 8B 54 24 18 89 C7 48 0F BE 32 40 80 FE 2E 75 5B 4D 39 E7 74 26 3D FF 00 00 00 77 1F 41 88 07 0F BE 42 01 49 83 C7 01 48 8D 6A 01 83 E8 30 83 F8 09 76 B8 0F 1F 84 00 00 00 00 00 48 8B 05 ?? ?? ?? ?? 64 44 89 30 31 C0 48 8B 5C 24 28 48 8B 6C 24 30 4C 8B 64 24 38 4C 8B 6C 24 40 4C 8B 74 24 48 4C 8B 7C 24 50 48 83 C4 58 C3 40 80 FE 00 75 3B 48 39 EA 74 C5 4C 89 F9 4C 29 E9 3B 3C 8D ?? ?? ?? ?? 77 B6 48 83 7C 24 08 00 74 0D 0F CF 0B 7C 24 10 48 8B 44 24 08 89 38 48 8B 05 ?? ?? ?? ?? 64 44 89 30 B8 01 00 00 00 EB 9C 7C 8D 48 8B 05 ?? ?? ?? ?? 64 48 8B 00 F6 44 70 01 20 0F 84 77 FF FF FF EB AB }
	condition:
		$1
}

rule file_165_1_0 {
	meta:
		name = "inet_addr"
		size = 30
		refs = "0008 __inet_aton"
	strings:
		$1 = { 48 83 EC 18 48 89 E6 E8 ?? ?? ?? ?? BA FF FF FF FF 85 C0 0F 45 14 24 48 83 C4 18 89 D0 C3 }
	condition:
		$1
}

rule file_166_1_0 {
	meta:
		name = "svcunix_getargs"
		size = 18
		altNames = "svctcp_getargs"
	strings:
		$1 = { 48 8B 7F 40 48 89 F1 31 C0 48 89 D6 48 83 C7 10 FF E1 }
	condition:
		$1
}

rule file_166_2_0 {
	meta:
		name = "svcunix_freeargs"
		size = 25
		altNames = "svctcp_freeargs"
	strings:
		$1 = { 48 8B 7F 40 48 89 F1 31 C0 48 89 D6 C7 47 10 02 00 00 00 48 83 C7 10 FF E1 }
	condition:
		$1
}

rule file_166_3_0 {
	meta:
		name = "makefd_xprt"
		size = 270
		refs = "002c malloc 0072 xdrrec_create 00a6 xprt_register 00db _libc_intl_domainname 00e0 __dcgettext 00f6 __fxprintf 0100 free"
	strings:
		$1 = { 48 89 5C 24 D8 48 89 6C 24 E0 4C 89 64 24 E8 4C 89 6C 24 F0 41 89 FC 4C 89 74 24 F8 BF 50 01 00 00 48 83 EC 28 41 89 F5 41 89 D6 E8 ?? ?? ?? ?? BF D0 01 00 00 48 89 C3 E8 ?? ?? ?? ?? 48 85 C0 48 89 C5 0F 84 87 00 00 00 48 85 DB 0F 84 7E 00 00 00 48 8D 78 10 C7 00 02 00 00 00 41 B9 ?? ?? ?? ?? 41 B8 ?? ?? ?? ?? 48 89 D9 44 89 F2 44 89 EE E8 ?? ?? ?? ?? 48 89 6B 40 48 83 C5 40 48 C7 43 48 00 00 00 00 48 89 6B 30 C7 43 10 00 00 00 00 48 89 DF 48 C7 43 08 ?? ?? ?? ?? 66 C7 43 04 00 00 44 89 23 E8 ?? ?? ?? ?? 48 89 D8 48 8B 6C 24 08 48 8B 1C 24 4C 8B 64 24 10 4C 8B 6C 24 18 4C 8B 74 24 20 48 83 C4 28 C3 66 0F 1F 44 00 00 BA 05 00 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? BA ?? ?? ?? ?? 48 89 C1 BE ?? ?? ?? ?? 31 FF 31 C0 E8 ?? ?? ?? ?? 48 89 DF 31 DB E8 ?? ?? ?? ?? 48 89 EF E8 ?? ?? ?? ?? EB 9C }
	condition:
		$1
}

rule file_166_4_0 {
	meta:
		name = "writeunix"
		size = 284
		refs = "0028 __getpid 0030 __geteuid 0038 __getegid 00ca __sendmsg 00d5 __libc_errno"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 41 89 D4 55 53 48 83 EC 68 85 D2 48 89 74 24 08 0F 8E D1 00 00 00 49 89 FD 89 D5 41 8B 5D 00 E8 ?? ?? ?? ?? 41 89 C6 E8 ?? ?? ?? ?? 41 89 C7 E8 ?? ?? ?? ?? 89 05 ?? ?? ?? ?? 48 8B 44 24 08 44 89 35 ?? ?? ?? ?? 44 89 3D ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 01 00 00 00 C7 05 ?? ?? ?? ?? 02 00 00 00 48 89 44 24 10 48 63 C5 48 C7 05 ?? ?? ?? ?? 1C 00 00 00 48 89 44 24 18 48 8D 44 24 10 48 C7 44 24 38 01 00 00 00 48 C7 44 24 20 00 00 00 00 C7 44 24 28 00 00 00 00 48 89 44 24 30 48 C7 44 24 40 ?? ?? ?? ?? 48 C7 44 24 48 20 00 00 00 C7 44 24 50 00 00 00 00 90 48 8D 74 24 20 31 D2 89 DF E8 ?? ?? ?? ?? 85 C0 79 36 48 8B 05 ?? ?? ?? ?? 64 83 38 04 74 E1 49 8B 45 40 41 BC FF FF FF FF C7 00 00 00 00 00 48 83 C4 68 44 89 E0 5B 5D 41 5C 41 5D 41 5E 41 5F C3 0F 1F 80 00 00 00 00 29 C5 48 63 C8 48 01 4C 24 08 85 ED 0F 8F 09 FF FF FF EB D3 }
	condition:
		$1
}

rule file_166_5_0 {
	meta:
		name = "readunix"
		size = 349
		refs = "0041 __poll 00cf __setsockopt 00ea __recvmsg 00f5 __libc_errno"
	strings:
		$1 = { 48 89 5C 24 E0 48 89 6C 24 E8 48 89 FD 4C 89 64 24 F0 4C 89 6C 24 F8 48 81 EC 98 00 00 00 8B 1F 49 89 F5 4C 63 E2 48 8D 7C 24 10 BA B8 88 00 00 BE 01 00 00 00 89 5C 24 10 66 C7 44 24 14 01 00 E8 ?? ?? ?? ?? 83 F8 FF 0F 84 EA 00 00 00 85 C0 0F 84 AA 00 00 00 0F B7 44 24 16 A8 38 0F 85 9D 00 00 00 A8 01 74 BF 48 8D 44 24 20 48 8D 4C 24 0C 41 B8 04 00 00 00 BA 10 00 00 00 BE 01 00 00 00 89 DF 4C 89 6C 24 20 4C 89 64 24 28 48 89 44 24 40 48 C7 44 24 48 01 00 00 00 48 C7 44 24 30 00 00 00 00 C7 44 24 38 00 00 00 00 48 C7 44 24 50 ?? ?? ?? ?? 48 C7 44 24 58 28 00 00 00 C7 44 24 60 00 00 00 00 C7 44 24 0C 01 00 00 00 E8 ?? ?? ?? ?? 85 C0 75 29 66 0F 1F 84 00 00 00 00 00 48 8D 74 24 30 31 D2 89 DF E8 ?? ?? ?? ?? 85 C0 79 5E 48 8B 05 ?? ?? ?? ?? 64 83 38 04 74 E1 90 48 8B 45 40 C7 00 00 00 00 00 B8 FF FF FF FF 48 8B 5C 24 78 48 8B AC 24 80 00 00 00 4C 8B A4 24 88 00 00 00 4C 8B AC 24 90 00 00 00 48 81 C4 98 00 00 00 C3 0F 1F 40 00 48 8B 05 ?? ?? ?? ?? 64 83 38 04 75 BB 0F B7 44 24 16 E9 14 FF FF FF 90 F6 44 24 60 08 75 A9 85 C0 74 A5 EB B2 }
	condition:
		$1
}

rule file_166_6_0 {
	meta:
		name = "svcunix_destroy"
		size = 104
		refs = "0016 xprt_unregister 001d __close 003f free"
		altNames = "svctcp_destroy"
	strings:
		$1 = { 48 89 5C 24 F0 48 89 6C 24 F8 48 89 FB 48 83 EC 18 48 8B 6F 40 E8 ?? ?? ?? ?? 8B 3B E8 ?? ?? ?? ?? 66 83 7B 04 00 75 38 48 8B 45 18 48 8B 40 38 48 85 C0 74 06 48 8D 7D 10 FF D0 48 89 EF E8 ?? ?? ?? ?? 48 89 DF 48 8B 6C 24 10 48 8B 5C 24 08 48 83 C4 18 E9 ?? ?? ?? ?? 0F 1F 80 00 00 00 00 66 C7 43 04 00 00 EB D3 }
	condition:
		$1
}

rule file_166_7_0 {
	meta:
		name = "svcunix_reply"
		size = 76
		refs = "0028 xdr_replymsg 0037 xdrrec_endofrecord"
		altNames = "svctcp_reply"
	strings:
		$1 = { 48 89 5C 24 F0 48 89 6C 24 F8 48 83 EC 18 48 8B 47 40 48 8D 58 10 C7 40 10 00 00 00 00 48 8B 40 08 48 89 DF 48 89 06 E8 ?? ?? ?? ?? 48 89 DF 89 C5 BE 01 00 00 00 E8 ?? ?? ?? ?? 89 E8 48 8B 5C 24 08 48 8B 6C 24 10 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_166_8_0 {
	meta:
		name = "svcunix_stat"
		size = 42
		refs = "0019 xdrrec_eof"
		altNames = "svctcp_stat"
	strings:
		$1 = { 48 8B 7F 40 31 C0 8B 17 85 D2 75 04 F3 C3 66 90 48 83 EC 08 48 83 C7 10 E8 ?? ?? ?? ?? 83 F8 01 19 C0 48 83 C4 08 83 C0 02 C3 }
	condition:
		$1
}

rule file_166_9_0 {
	meta:
		name = "svcunix_recv"
		size = 133
		refs = "0029 xdrrec_skiprecord 0034 xdr_callmsg"
	strings:
		$1 = { 48 89 5C 24 E8 48 89 6C 24 F0 48 89 F5 4C 89 64 24 F8 48 83 EC 18 48 8B 5F 40 4C 8D 63 10 C7 43 10 01 00 00 00 4C 89 E7 E8 ?? ?? ?? ?? 48 89 EE 4C 89 E7 E8 ?? ?? ?? ?? 85 C0 75 24 C7 03 00 00 00 00 31 C0 48 8B 1C 24 48 8B 6C 24 08 4C 8B 64 24 10 48 83 C4 18 C3 66 0F 1F 84 00 00 00 00 00 48 8B 45 00 48 89 43 08 C7 45 48 01 00 00 00 B8 01 00 00 00 48 C7 45 50 ?? ?? ?? ?? C7 45 58 28 00 00 00 EB BF }
	condition:
		$1
}

rule file_166_11_0 {
	meta:
		name = "rendezvous_request"
		size = 141
		refs = "001b __libc_errno 003a accept"
	strings:
		$1 = { 55 53 48 89 FB 48 81 EC 98 00 00 00 48 8B 6F 40 EB 13 66 0F 1F 44 00 00 48 8B 05 ?? ?? ?? ?? 64 83 38 04 75 5C 8B 3B 48 8D 54 24 0C 48 8D 74 24 20 C7 44 24 0C 6E 00 00 00 E8 ?? ?? ?? ?? 85 C0 78 D6 8B 55 04 8B 75 00 89 C7 48 C7 44 24 10 00 00 00 00 48 C7 44 24 18 00 00 00 00 66 C7 44 24 10 01 00 E8 78 FA FF FF 48 8B 54 24 10 48 89 50 14 48 8B 54 24 18 48 89 50 1C 8B 54 24 0C 89 50 10 48 81 C4 98 00 00 00 31 C0 5B 5D C3 }
	condition:
		$1
}

rule file_166_12_0 {
	meta:
		name = "svcunix_create"
		size = 580
		refs = "006e strlen 0080 memcpy 0092 __bind 00a1 __getsockname 00b4 _libc_intl_domainname 00b9 __dcgettext 00c1 perror 0118 __listen 0126 malloc 0179 _null_auth 019a xprt_register 01ab __close 01c5 __socket 0206 __fxprintf 020e free"
	strings:
		$1 = { 48 89 6C 24 D8 4C 89 64 24 E0 89 FD 4C 89 6C 24 E8 4C 89 7C 24 F8 45 31 ED 48 89 5C 24 D0 4C 89 74 24 F0 48 81 EC C8 00 00 00 83 FF FF 41 89 F7 89 54 24 0C 49 89 CC C7 44 24 1C 10 00 00 00 0F 84 73 01 00 00 48 8D 5C 24 20 31 C0 B9 0D 00 00 00 48 89 DF F3 48 AB 66 C7 44 24 20 01 00 C7 07 00 00 00 00 66 C7 47 04 00 00 4C 89 E7 E8 ?? ?? ?? ?? 48 8D 7B 02 8D 50 01 41 89 C6 4C 89 E6 E8 ?? ?? ?? ?? 41 8D 56 03 48 89 DE 89 EF 89 54 24 1C E8 ?? ?? ?? ?? 48 8D 54 24 1C 48 89 DE 89 EF E8 ?? ?? ?? ?? 85 C0 74 67 BA 05 00 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 C7 E8 ?? ?? ?? ?? 45 85 ED 0F 85 DA 00 00 00 31 DB 48 89 D8 48 8B AC 24 A0 00 00 00 48 8B 9C 24 98 00 00 00 4C 8B A4 24 A8 00 00 00 4C 8B AC 24 B0 00 00 00 4C 8B B4 24 B8 00 00 00 4C 8B BC 24 C0 00 00 00 48 81 C4 C8 00 00 00 C3 0F 1F 44 00 00 BE 80 00 00 00 89 EF E8 ?? ?? ?? ?? 85 C0 75 89 BF 08 00 00 00 E8 ?? ?? ?? ?? BF 50 01 00 00 49 89 C4 E8 ?? ?? ?? ?? 48 85 C0 48 89 C3 0F 84 9D 00 00 00 4D 85 E4 0F 84 94 00 00 00 8B 44 24 0C 45 89 3C 24 48 89 DF 48 C7 43 48 00 00 00 00 4C 89 63 40 48 C7 43 08 ?? ?? ?? ?? 66 C7 43 04 FF FF 41 89 44 24 04 48 8B 05 ?? ?? ?? ?? 89 2B 48 89 43 28 48 8B 05 ?? ?? ?? ?? 48 89 43 30 48 8B 05 ?? ?? ?? ?? 48 89 43 38 E8 ?? ?? ?? ?? E9 2D FF FF FF 0F 1F 44 00 00 89 EF E8 ?? ?? ?? ?? 90 E9 19 FF FF FF 0F 1F 00 31 D2 BE 01 00 00 00 BF 01 00 00 00 E8 ?? ?? ?? ?? 85 C0 89 C5 78 52 41 BD 01 00 00 00 E9 6B FE FF FF 66 0F 1F 44 00 00 BA 05 00 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? BA ?? ?? ?? ?? 48 89 C1 BE ?? ?? ?? ?? 31 FF 31 C0 E8 ?? ?? ?? ?? 4C 89 E7 E8 ?? ?? ?? ?? 48 89 DF 31 DB E8 ?? ?? ?? ?? E9 AF FE FF FF BA 05 00 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 C7 31 DB E8 ?? ?? ?? ?? E9 8C FE FF FF }
	condition:
		$1
}

rule file_167_0_0 {
	meta:
		name = "strerror"
		size = 180
		refs = "001a __strerror_r 0041 __libc_errno 0081 malloc 00a7 _libc_intl_domainname 00b0 __dcgettext"
	strings:
		$1 = { 48 89 5C 24 E8 48 89 6C 24 F0 31 D2 4C 89 64 24 F8 31 F6 48 83 EC 18 89 FB E8 ?? ?? ?? ?? 48 85 C0 74 13 48 8B 1C 24 48 8B 6C 24 08 4C 8B 64 24 10 48 83 C4 18 C3 48 83 3D ?? ?? ?? ?? 00 4C 8B 25 ?? ?? ?? ?? 64 41 8B 2C 24 74 2F 48 8B 35 ?? ?? ?? ?? 64 41 89 2C 24 48 85 F6 74 31 89 DF 48 8B 6C 24 08 48 8B 1C 24 4C 8B 64 24 10 BA 00 04 00 00 48 83 C4 18 E9 ?? ?? ?? ?? BF 00 04 00 00 E8 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? EB BE 48 8B 1C 24 48 8B 6C 24 08 BA 05 00 00 00 4C 8B 64 24 10 BE ?? ?? ?? ?? BF ?? ?? ?? ?? 48 83 C4 18 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_169_0_0 {
	meta:
		name = "__syscall_error"
		size = 16
		refs = "0007 errno"
	strings:
		$1 = { 48 F7 D8 64 89 04 25 ?? ?? ?? ?? 48 83 C8 FF C3 }
	condition:
		$1
}

rule file_170_0_0 {
	meta:
		name = "__libc_chown"
		size = 20
		refs = "000f __syscall_error"
	strings:
		$1 = { B8 5C 00 00 00 0F 05 48 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_171_0_0 {
	meta:
		name = "_L_lock_61"
		size = 27
		refs = "000b __lll_lock_wait_private"
	strings:
		$1 = { 49 8D 38 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 04 FF FF FF }
	condition:
		$1
}

rule file_171_1_0 {
	meta:
		name = "_L_unlock_135"
		size = 24
		refs = "000b __lll_unlock_wake_private"
		altNames = "_L_unlock_80 _L_unlock_84"
	strings:
		$1 = { 48 8D 3A 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 EB 81 }
	condition:
		$1
}

rule file_171_3_0 {
	meta:
		name = "___fprintf_chk"
		size = 384
		refs = "0081 __libc_multiple_threads 00ea vfprintf 017c _Unwind_Resume"
	strings:
		$1 = { 55 89 F5 53 48 89 FB 48 81 EC D8 00 00 00 84 C0 48 89 4C 24 38 4C 89 44 24 40 4C 89 4C 24 48 74 37 0F 29 44 24 50 0F 29 4C 24 60 0F 29 54 24 70 0F 29 9C 24 80 00 00 00 0F 29 A4 24 90 00 00 00 0F 29 AC 24 A0 00 00 00 0F 29 B4 24 B0 00 00 00 0F 29 BC 24 C0 00 00 00 49 89 D2 8B 03 25 00 80 00 00 75 4B 4C 8B 83 88 00 00 00 64 48 8B 14 25 10 00 00 00 49 3B 50 08 74 30 BE 01 00 00 00 83 3D ?? ?? ?? ?? 00 74 0D F0 41 0F B1 30 0F 85 ED 00 00 00 EB 0A 41 0F B1 30 0F 85 E1 00 00 00 4C 8B 83 88 00 00 00 49 89 50 08 41 83 40 04 01 85 ED 7E 04 83 4B 74 04 48 8D 84 24 F0 00 00 00 48 8D 54 24 08 4C 89 D6 48 89 DF C7 44 24 08 18 00 00 00 48 89 44 24 10 48 8D 44 24 20 C7 44 24 0C 30 00 00 00 48 89 44 24 18 E8 ?? ?? ?? ?? 85 ED 89 C6 8B 53 74 7E 06 83 E2 FB 89 53 74 83 E2 EB F7 03 00 80 00 00 89 53 74 75 29 48 8B 93 88 00 00 00 83 6A 04 01 75 1C 48 C7 42 08 00 00 00 00 83 3D ?? ?? ?? ?? 00 74 07 F0 FF 0A 75 6D EB 04 FF 0A 75 67 48 81 C4 D8 00 00 00 89 F0 5B 5D C3 83 63 74 EB F7 03 00 80 00 00 48 89 C6 75 29 48 8B 93 88 00 00 00 83 6A 04 01 75 1C 48 C7 42 08 00 00 00 00 83 3D ?? ?? ?? ?? 00 74 07 F0 FF 0A 75 41 EB 04 FF 0A 75 3B 48 89 F7 E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_328_3_0 {
	meta:
		name = "__fwprintf_chk"
		size = 384
		refs = "0081 __libc_multiple_threads 00ea _IO_vfwprintf 017c _Unwind_Resume"
	strings:
		$1 = { 55 89 F5 53 48 89 FB 48 81 EC D8 00 00 00 84 C0 48 89 4C 24 38 4C 89 44 24 40 4C 89 4C 24 48 74 37 0F 29 44 24 50 0F 29 4C 24 60 0F 29 54 24 70 0F 29 9C 24 80 00 00 00 0F 29 A4 24 90 00 00 00 0F 29 AC 24 A0 00 00 00 0F 29 B4 24 B0 00 00 00 0F 29 BC 24 C0 00 00 00 49 89 D2 8B 03 25 00 80 00 00 75 4B 4C 8B 83 88 00 00 00 64 48 8B 14 25 10 00 00 00 49 3B 50 08 74 30 BE 01 00 00 00 83 3D ?? ?? ?? ?? 00 74 0D F0 41 0F B1 30 0F 85 ED 00 00 00 EB 0A 41 0F B1 30 0F 85 E1 00 00 00 4C 8B 83 88 00 00 00 49 89 50 08 41 83 40 04 01 85 ED 7E 04 83 4B 74 04 48 8D 84 24 F0 00 00 00 48 8D 54 24 08 4C 89 D6 48 89 DF C7 44 24 08 18 00 00 00 48 89 44 24 10 48 8D 44 24 20 C7 44 24 0C 30 00 00 00 48 89 44 24 18 E8 ?? ?? ?? ?? 85 ED 89 C6 8B 53 74 7E 06 83 E2 FB 89 53 74 83 E2 EB F7 03 00 80 00 00 89 53 74 75 29 48 8B 93 88 00 00 00 83 6A 04 01 75 1C 48 C7 42 08 00 00 00 00 83 3D ?? ?? ?? ?? 00 74 07 F0 FF 0A 75 6D EB 04 FF 0A 75 67 48 81 C4 D8 00 00 00 89 F0 5B 5D C3 83 63 74 EB F7 03 00 80 00 00 48 89 C6 75 29 48 8B 93 88 00 00 00 83 6A 04 01 75 1C 48 C7 42 08 00 00 00 00 83 3D ?? ?? ?? ?? 00 74 07 F0 FF 0A 75 41 EB 04 FF 0A 75 3B 48 89 F7 E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_172_0_0 {
	meta:
		name = "gethostid"
		size = 373
		refs = "001c __open_nocancel 0035 __read_nocancel 0058 __gethostname 009b __libc_errno 00f8 __gethostbyname_r 0161 memcpy"
	strings:
		$1 = { 55 31 D2 31 F6 31 C0 BF ?? ?? ?? ?? 48 89 E5 41 55 41 54 53 48 81 EC 98 00 00 00 E8 ?? ?? ?? ?? 85 C0 78 2A 48 8D B5 60 FF FF FF 89 C3 BA 04 00 00 00 89 C7 E8 ?? ?? ?? ?? 48 63 FB 89 C2 B8 03 00 00 00 0F 05 83 FA 04 0F 84 D2 00 00 00 48 8D 7D 90 BE 40 00 00 00 E8 ?? ?? ?? ?? 85 C0 78 06 80 7D 90 00 75 12 31 C0 48 8D 65 E8 5B 41 5C 41 5D 5D C3 0F 1F 44 00 00 48 81 EC 10 04 00 00 BB 00 04 00 00 41 BC 10 00 00 00 4C 8D 6C 24 0F 49 83 E5 F0 EB 43 0F 1F 00 48 8B 05 ?? ?? ?? ?? 64 83 38 22 75 C1 48 8D 74 1B 0F 31 D2 48 83 E6 F0 48 8D 46 1E 48 01 F3 49 F7 F4 48 C1 E0 04 48 29 C4 48 8D 44 24 0F 48 83 E0 F0 48 8D 14 30 49 39 D5 49 89 C5 48 0F 45 DE 4C 8D 8D 64 FF FF FF 4C 8D 85 68 FF FF FF 48 8D B5 70 FF FF FF 48 8D 7D 90 48 89 D9 4C 89 EA E8 ?? ?? ?? ?? 85 C0 75 0C 48 8B 85 68 FF FF FF 48 85 C0 75 2C 83 BD 64 FF FF FF FF 74 83 E9 4C FF FF FF 66 0F 1F 44 00 00 48 63 85 60 FF FF FF 48 8D 65 E8 5B 41 5C 41 5D 5D C3 66 0F 1F 44 00 00 83 78 14 04 BA 04 00 00 00 48 8D BD 50 FF FF FF 0F 4E 50 14 48 8B 40 18 C7 85 50 FF FF FF 00 00 00 00 48 8B 30 48 63 D2 E8 ?? ?? ?? ?? 8B 85 50 FF FF FF C1 C0 10 48 98 E9 F3 FE FF FF }
	condition:
		$1
}

rule file_173_0_0 {
	meta:
		name = "__atomic_writev_replacement"
		size = 410
		refs = "00d8 mempcpy 00ec __write 00f9 free 0113 __libc_errno 013f __libc_alloca_cutoff 014f malloc 0175 _Unwind_Resume"
	strings:
		$1 = { 55 48 89 E5 41 57 41 56 41 55 49 89 F5 41 54 41 89 D4 53 48 83 EC 28 85 D2 89 7D C4 0F 8E 12 01 00 00 48 8B 46 08 48 BF FF FF FF FF FF FF FF 7F 31 D2 31 DB 48 89 F1 48 39 F8 76 23 E9 CF 00 00 00 0F 1F 80 00 00 00 00 48 83 C1 10 48 8B 41 08 48 89 FE 48 29 DE 48 39 C6 0F 82 B1 00 00 00 83 C2 01 48 01 C3 44 39 E2 75 DE 48 81 FB 00 10 00 00 0F 87 C4 00 00 00 48 8D 43 1E 48 C7 45 B8 00 00 00 00 48 83 E0 F0 48 29 C4 48 8D 44 24 0F 48 83 E0 F0 45 85 E4 48 89 45 C8 7E 45 41 83 EC 01 48 8B 45 C8 49 89 DF 49 C1 E4 04 4F 8D 64 25 10 EB 0F 66 0F 1F 44 00 00 49 83 C5 10 4D 39 E5 74 20 4D 39 7D 08 4D 89 FE 49 8B 75 00 4D 0F 46 75 08 48 89 C7 4C 89 F2 E8 ?? ?? ?? ?? 4D 29 F7 75 D7 48 8B 75 C8 8B 7D C4 48 89 DA E8 ?? ?? ?? ?? 48 8B 7D B8 48 89 45 B0 E8 ?? ?? ?? ?? 48 8B 45 B0 48 8D 65 D8 5B 41 5C 41 5D 41 5E 41 5F 5D C3 48 8B 05 ?? ?? ?? ?? 64 C7 00 16 00 00 00 48 8D 65 D8 48 C7 C0 FF FF FF FF 5B 41 5C 41 5D 41 5E 41 5F 5D C3 31 DB E9 3C FF FF FF 48 89 DF E8 ?? ?? ?? ?? 85 C0 0F 85 2C FF FF FF 48 89 DF E8 ?? ?? ?? ?? 48 85 C0 48 89 45 C8 74 1D 48 89 45 B8 E9 37 FF FF FF 48 89 C3 48 8B 7D B8 E8 ?? ?? ?? ?? 48 89 DF E8 ?? ?? ?? ?? 48 C7 45 B8 00 00 00 00 48 C7 C0 FF FF FF FF E9 63 FF FF FF 48 89 C3 48 C7 45 B8 00 00 00 00 EB CE }
	condition:
		$1
}

rule file_173_1_0 {
	meta:
		name = "__libc_writev"
		size = 241
		refs = "0017 __libc_multiple_threads 0063 __libc_errno 0092 __libc_enable_asynccancel 00ba __libc_disable_asynccancel"
	strings:
		$1 = { 48 89 5C 24 E8 48 89 6C 24 F0 89 D3 4C 89 64 24 F8 48 83 EC 28 8B 05 ?? ?? ?? ?? 89 FD 49 89 F4 85 C0 75 6D 48 63 D2 48 63 FF B8 14 00 00 00 0F 05 48 3D 00 F0 FF FF 0F 87 8B 00 00 00 48 85 C0 78 1E 48 8B 5C 24 10 48 8B 6C 24 18 4C 8B 64 24 20 48 83 C4 28 C3 66 2E 0F 1F 84 00 00 00 00 00 48 8B 15 ?? ?? ?? ?? 64 83 3A 16 75 D5 83 FB 08 7E D0 89 DA 4C 89 E6 89 EF 48 8B 5C 24 10 48 8B 6C 24 18 4C 8B 64 24 20 48 83 C4 28 E9 CF FD FF FF E8 ?? ?? ?? ?? 48 63 D3 41 89 C0 4C 89 E6 48 63 FD B8 14 00 00 00 0F 05 48 3D 00 F0 FF FF 77 2C 44 89 C7 48 89 44 24 08 E8 ?? ?? ?? ?? 48 8B 44 24 08 E9 75 FF FF FF 48 8B 15 ?? ?? ?? ?? F7 D8 64 89 02 48 83 C8 FF E9 60 FF FF FF 89 C2 48 8B 05 ?? ?? ?? ?? F7 DA 64 89 10 48 83 C8 FF EB C0 }
	condition:
		$1
}

rule file_174_0_0 {
	meta:
		name = "fexecve"
		size = 164
		refs = "0038 __snprintf 0046 __execve 004d __libc_errno 0064 __xstat"
	strings:
		$1 = { 48 85 F6 0F 84 87 00 00 00 89 F8 C1 E8 1F 84 C0 75 7E 48 85 D2 74 79 55 89 F9 48 89 D5 31 C0 BA ?? ?? ?? ?? 53 48 89 F3 BE 1B 00 00 00 48 81 EC B8 00 00 00 48 89 E7 E8 ?? ?? ?? ?? 48 89 EA 48 89 DE 48 89 E7 E8 ?? ?? ?? ?? 48 8B 1D ?? ?? ?? ?? 48 8D 54 24 20 BE ?? ?? ?? ?? BF 01 00 00 00 64 8B 2B E8 ?? ?? ?? ?? 85 C0 74 0C 64 83 3B 02 B8 26 00 00 00 0F 44 E8 64 89 2B 48 81 C4 B8 00 00 00 B8 FF FF FF FF 5B 5D C3 66 0F 1F 44 00 00 48 8B 05 ?? ?? ?? ?? 64 C7 00 16 00 00 00 B8 FF FF FF FF C3 }
	condition:
		$1
}

rule file_175_0_0 {
	meta:
		name = "__getdtablesize"
		size = 35
		refs = "000d __getrlimit"
	strings:
		$1 = { 48 83 EC 18 BF 07 00 00 00 48 89 E6 E8 ?? ?? ?? ?? BA 00 01 00 00 85 C0 0F 49 14 24 48 83 C4 18 89 D0 C3 }
	condition:
		$1
}

rule file_176_0_0 {
	meta:
		name = "__frexp"
		size = 118
		refs = "001c .LC0 0058 .LC1"
	strings:
		$1 = { 66 48 0F 7E C2 48 89 D0 48 C1 F8 34 25 FF 07 00 00 3D FF 07 00 00 74 38 66 0F 2E 05 ?? ?? ?? ?? 7A 02 74 2C 85 C0 8D 88 02 FC FF FF 74 26 48 B8 FF FF FF FF FF FF 0F 80 48 21 D0 48 BA 00 00 00 00 00 00 E0 3F 48 09 D0 66 48 0F 6E C0 89 0F C3 31 C9 EB F9 F2 0F 59 05 ?? ?? ?? ?? 66 48 0F 7E C2 48 89 D1 48 C1 F9 34 81 E1 FF 07 00 00 81 E9 34 04 00 00 EB B8 }
	condition:
		$1
}

rule file_177_0_0 {
	meta:
		name = "_L_lock_11"
		size = 28
		refs = "000f __lll_lock_wait_private"
	strings:
		$1 = { 48 8D 3D ?? ?? ?? ?? 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 EB 8C }
	condition:
		$1
}

rule file_177_1_0 {
	meta:
		name = "_L_unlock_30"
		size = 28
		refs = "000f __lll_unlock_wake_private"
	strings:
		$1 = { 48 8D 3D ?? ?? ?? ?? 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 EB BC }
	condition:
		$1
}

rule file_177_2_0 {
	meta:
		name = "getgrent"
		size = 129
		refs = "000d __libc_multiple_threads 0042 __getgrent_r 0047 __nss_getent 004e __libc_errno"
	strings:
		$1 = { 48 83 EC 08 BE 01 00 00 00 31 C0 83 3D ?? ?? ?? ?? 00 74 0C F0 0F B1 35 ?? ?? ?? ?? 75 63 EB 09 0F B1 35 ?? ?? ?? ?? 75 58 45 31 C9 41 B8 ?? ?? ?? ?? B9 00 04 00 00 BA ?? ?? ?? ?? BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 15 ?? ?? ?? ?? 48 89 C6 64 44 8B 02 83 3D ?? ?? ?? ?? 00 74 0B F0 FF 0D ?? ?? ?? ?? 75 32 EB 08 FF 0D ?? ?? ?? ?? 75 28 64 44 89 02 48 89 F0 48 83 C4 08 C3 }
	condition:
		$1
}

rule file_275_2_0 {
	meta:
		name = "getaliasent"
		size = 129
		refs = "000d __libc_multiple_threads 0042 __getaliasent_r 0047 __nss_getent 004e __libc_errno"
	strings:
		$1 = { 48 83 EC 08 BE 01 00 00 00 31 C0 83 3D ?? ?? ?? ?? 00 74 0C F0 0F B1 35 ?? ?? ?? ?? 75 63 EB 09 0F B1 35 ?? ?? ?? ?? 75 58 45 31 C9 41 B8 ?? ?? ?? ?? B9 00 04 00 00 BA ?? ?? ?? ?? BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 15 ?? ?? ?? ?? 48 89 C6 64 44 8B 02 83 3D ?? ?? ?? ?? 00 74 0B F0 FF 0D ?? ?? ?? ?? 75 32 EB 08 FF 0D ?? ?? ?? ?? 75 28 64 44 89 02 48 89 F0 48 83 C4 08 C3 }
	condition:
		$1
}

rule file_286_2_0 {
	meta:
		name = "getprotoent"
		size = 129
		refs = "000d __libc_multiple_threads 0042 __getprotoent_r 0047 __nss_getent 004e __libc_errno"
	strings:
		$1 = { 48 83 EC 08 BE 01 00 00 00 31 C0 83 3D ?? ?? ?? ?? 00 74 0C F0 0F B1 35 ?? ?? ?? ?? 75 63 EB 09 0F B1 35 ?? ?? ?? ?? 75 58 45 31 C9 41 B8 ?? ?? ?? ?? B9 00 04 00 00 BA ?? ?? ?? ?? BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 15 ?? ?? ?? ?? 48 89 C6 64 44 8B 02 83 3D ?? ?? ?? ?? 00 74 0B F0 FF 0D ?? ?? ?? ?? 75 32 EB 08 FF 0D ?? ?? ?? ?? 75 28 64 44 89 02 48 89 F0 48 83 C4 08 C3 }
	condition:
		$1
}

rule file_601_2_0 {
	meta:
		name = "getpwent"
		size = 129
		refs = "000d __libc_multiple_threads 0042 __getpwent_r 0047 __nss_getent 004e __libc_errno"
	strings:
		$1 = { 48 83 EC 08 BE 01 00 00 00 31 C0 83 3D ?? ?? ?? ?? 00 74 0C F0 0F B1 35 ?? ?? ?? ?? 75 63 EB 09 0F B1 35 ?? ?? ?? ?? 75 58 45 31 C9 41 B8 ?? ?? ?? ?? B9 00 04 00 00 BA ?? ?? ?? ?? BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 15 ?? ?? ?? ?? 48 89 C6 64 44 8B 02 83 3D ?? ?? ?? ?? 00 74 0B F0 FF 0D ?? ?? ?? ?? 75 32 EB 08 FF 0D ?? ?? ?? ?? 75 28 64 44 89 02 48 89 F0 48 83 C4 08 C3 }
	condition:
		$1
}

rule file_707_2_0 {
	meta:
		name = "getrpcent"
		size = 129
		refs = "000d __libc_multiple_threads 0042 __getrpcent_r 0047 __nss_getent 004e __libc_errno"
	strings:
		$1 = { 48 83 EC 08 BE 01 00 00 00 31 C0 83 3D ?? ?? ?? ?? 00 74 0C F0 0F B1 35 ?? ?? ?? ?? 75 63 EB 09 0F B1 35 ?? ?? ?? ?? 75 58 45 31 C9 41 B8 ?? ?? ?? ?? B9 00 04 00 00 BA ?? ?? ?? ?? BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 15 ?? ?? ?? ?? 48 89 C6 64 44 8B 02 83 3D ?? ?? ?? ?? 00 74 0B F0 FF 0D ?? ?? ?? ?? 75 32 EB 08 FF 0D ?? ?? ?? ?? 75 28 64 44 89 02 48 89 F0 48 83 C4 08 C3 }
	condition:
		$1
}

rule file_1030_2_0 {
	meta:
		name = "getservent"
		size = 129
		refs = "000d __libc_multiple_threads 0042 __getservent_r 0047 __nss_getent 004e __libc_errno"
	strings:
		$1 = { 48 83 EC 08 BE 01 00 00 00 31 C0 83 3D ?? ?? ?? ?? 00 74 0C F0 0F B1 35 ?? ?? ?? ?? 75 63 EB 09 0F B1 35 ?? ?? ?? ?? 75 58 45 31 C9 41 B8 ?? ?? ?? ?? B9 00 04 00 00 BA ?? ?? ?? ?? BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 15 ?? ?? ?? ?? 48 89 C6 64 44 8B 02 83 3D ?? ?? ?? ?? 00 74 0B F0 FF 0D ?? ?? ?? ?? 75 32 EB 08 FF 0D ?? ?? ?? ?? 75 28 64 44 89 02 48 89 F0 48 83 C4 08 C3 }
	condition:
		$1
}

rule file_1282_2_0 {
	meta:
		name = "getsgent"
		size = 129
		refs = "000d __libc_multiple_threads 0042 __getsgent_r 0047 __nss_getent 004e __libc_errno"
	strings:
		$1 = { 48 83 EC 08 BE 01 00 00 00 31 C0 83 3D ?? ?? ?? ?? 00 74 0C F0 0F B1 35 ?? ?? ?? ?? 75 63 EB 09 0F B1 35 ?? ?? ?? ?? 75 58 45 31 C9 41 B8 ?? ?? ?? ?? B9 00 04 00 00 BA ?? ?? ?? ?? BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 15 ?? ?? ?? ?? 48 89 C6 64 44 8B 02 83 3D ?? ?? ?? ?? 00 74 0B F0 FF 0D ?? ?? ?? ?? 75 32 EB 08 FF 0D ?? ?? ?? ?? 75 28 64 44 89 02 48 89 F0 48 83 C4 08 C3 }
	condition:
		$1
}

rule file_536_2_0 {
	meta:
		name = "getspent"
		size = 129
		refs = "000d __libc_multiple_threads 0042 __getspent_r 0047 __nss_getent 004e __libc_errno"
	strings:
		$1 = { 48 83 EC 08 BE 01 00 00 00 31 C0 83 3D ?? ?? ?? ?? 00 74 0C F0 0F B1 35 ?? ?? ?? ?? 75 63 EB 09 0F B1 35 ?? ?? ?? ?? 75 58 45 31 C9 41 B8 ?? ?? ?? ?? B9 00 04 00 00 BA ?? ?? ?? ?? BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 15 ?? ?? ?? ?? 48 89 C6 64 44 8B 02 83 3D ?? ?? ?? ?? 00 74 0B F0 FF 0D ?? ?? ?? ?? 75 32 EB 08 FF 0D ?? ?? ?? ?? 75 28 64 44 89 02 48 89 F0 48 83 C4 08 C3 }
	condition:
		$1
}

rule file_178_0_0 {
	meta:
		name = "__shmat"
		size = 20
		refs = "000f __syscall_error"
	strings:
		$1 = { B8 1E 00 00 00 0F 05 48 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_179_0_0 {
	meta:
		name = "__posix_spawn_file_actions_realloc"
		size = 73
		refs = "0022 realloc"
	strings:
		$1 = { 48 89 5C 24 F0 48 89 6C 24 F8 48 83 EC 18 8B 2F 48 89 FB 48 8B 7F 08 83 C5 08 48 63 F5 48 C1 E6 05 E8 ?? ?? ?? ?? 48 85 C0 BA 0C 00 00 00 74 08 48 89 43 08 89 2B 30 D2 89 D0 48 8B 5C 24 08 48 8B 6C 24 10 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_179_1_0 {
	meta:
		name = "posix_spawn_file_actions_init"
		size = 135
	strings:
		$1 = { 40 F6 C7 01 BA 50 00 00 00 75 45 40 F6 C7 02 75 4F 40 F6 C7 04 75 61 89 D1 31 C0 C1 E9 03 F6 C2 04 F3 48 AB 74 0A C7 07 00 00 00 00 48 83 C7 04 F6 C2 02 74 09 66 C7 07 00 00 48 83 C7 02 83 E2 01 74 03 C6 07 00 31 C0 C3 0F 1F 80 00 00 00 00 C6 07 00 48 83 C7 01 B2 4F 40 F6 C7 02 74 B2 90 66 C7 07 00 00 48 83 C7 02 83 EA 02 40 F6 C7 04 74 A5 66 0F 1F 44 00 00 C7 07 00 00 00 00 83 EA 04 48 83 C7 04 EB 90 }
	condition:
		$1
}

rule file_180_0_0 {
	meta:
		name = "_L_lock_33"
		size = 27
		refs = "000b __lll_lock_wait_private"
	strings:
		$1 = { 48 8D 3A 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 3B FF FF FF }
	condition:
		$1
}

rule file_180_3_0 {
	meta:
		name = "_IO_getwc"
		size = 240
		refs = "002a __libc_multiple_threads 00ac __wuflow 00ec _Unwind_Resume"
	strings:
		$1 = { 53 8B 07 48 89 FB 25 00 80 00 00 75 48 48 8B 97 88 00 00 00 64 4C 8B 04 25 10 00 00 00 4C 3B 42 08 74 2E BE 01 00 00 00 83 3D ?? ?? ?? ?? 00 74 0C F0 0F B1 32 0F 85 B5 00 00 00 EB 09 0F B1 32 0F 85 AA 00 00 00 48 8B 93 88 00 00 00 4C 89 42 08 83 42 04 01 48 8B 93 A0 00 00 00 48 85 D2 74 47 48 8B 0A 48 3B 4A 08 73 3E 8B 31 48 83 C1 04 48 89 0A F7 03 00 80 00 00 75 29 48 8B 93 88 00 00 00 83 6A 04 01 75 1C 48 C7 42 08 00 00 00 00 83 3D ?? ?? ?? ?? 00 74 07 F0 FF 0A 75 6D EB 04 FF 0A 75 67 89 F0 5B C3 48 89 DF E8 ?? ?? ?? ?? 89 C6 EB BF F7 03 00 80 00 00 48 89 C6 75 29 48 8B 93 88 00 00 00 83 6A 04 01 75 1C 48 C7 42 08 00 00 00 00 83 3D ?? ?? ?? ?? 00 74 07 F0 FF 0A 75 41 EB 04 FF 0A 75 3B 48 89 F7 E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_181_0_0 {
	meta:
		name = "round_and_return"
		size = 508
		refs = "007f .LC1 00f4 __mpn_rshift 0103 __libc_errno 0124 .LC2 0166 __mpn_construct_double"
	strings:
		$1 = { 48 89 6C 24 E8 4C 89 64 24 F0 48 89 FD 4C 89 6C 24 F8 48 89 5C 24 E0 48 83 EC 38 81 FE 02 FC FF FF 41 89 D5 49 89 CC 7C 7F 89 F3 44 89 C1 49 0F A3 CC 73 38 45 85 C9 48 8B 45 00 75 08 A8 01 0F 84 4B 01 00 00 48 83 C0 01 48 BA 00 00 00 00 00 00 20 00 48 85 D0 48 89 45 00 0F 85 50 01 00 00 81 FB 01 FC FF FF 0F 84 C4 00 00 00 81 FB 00 04 00 00 0F 8E CD 00 00 00 45 85 ED F2 0F 10 05 ?? ?? ?? ?? 0F 85 97 00 00 00 48 8B 5C 24 18 48 8B 6C 24 20 4C 8B 64 24 28 4C 8B 6C 24 30 48 83 C4 38 C3 66 0F 1F 44 00 00 B8 02 FC FF FF 29 F0 48 63 D8 48 83 FB 35 0F 8F B4 00 00 00 BA 01 00 00 00 44 89 C1 48 D3 E2 48 83 EA 01 4C 85 E2 4C 8B 27 0F 95 C2 0F B6 D2 41 09 D1 48 83 FB 35 0F 84 FC 00 00 00 89 C1 BA 01 00 00 00 48 89 FE 44 89 4C 24 08 E8 ?? ?? ?? ?? 44 8B 4C 24 08 8D 4B FF 48 8B 05 ?? ?? ?? ?? BB 01 FC FF FF 64 C7 00 22 00 00 00 E9 16 FF FF FF 0F 1F 84 00 00 00 00 00 F2 0F 10 05 ?? ?? ?? ?? E9 5C FF FF FF 0F 1F 00 48 BA 00 00 00 00 00 00 10 00 48 85 D0 B8 02 FC FF FF 0F 45 D8 44 89 EA 89 DE 48 89 EF 48 8B 5C 24 18 48 8B 6C 24 20 4C 8B 64 24 28 4C 8B 6C 24 30 48 83 C4 38 E9 ?? ?? ?? ?? 66 0F 1F 44 00 00 48 8B 05 ?? ?? ?? ?? 66 0F 57 C0 64 C7 00 22 00 00 00 E9 02 FF FF FF 66 0F 1F 84 00 00 00 00 00 BA 01 00 00 00 48 D3 E2 48 83 EA 01 4C 85 E2 0F 84 C7 FE FF FF E9 9B FE FF FF 66 0F 1F 44 00 00 B9 01 00 00 00 BA 01 00 00 00 48 89 EE 48 89 EF 83 C3 01 E8 ?? ?? ?? ?? 48 B8 00 00 00 00 00 00 10 00 48 09 45 00 E9 91 FE FF FF 0F 1F 44 00 00 31 C0 4D 85 E4 48 C7 07 00 00 00 00 0F 95 C0 B9 34 00 00 00 41 09 C1 E9 04 FF FF FF }
	condition:
		$1
}

rule file_181_1_0 {
	meta:
		name = "str_to_mpn.isra.0"
		size = 591
		refs = "00ad _tens_in_limb 013a __mpn_mul_1"
	strings:
		$1 = { 41 57 49 89 CF 41 56 49 89 D6 31 D2 41 55 41 54 41 89 F4 31 F6 55 31 ED 53 48 89 FB 48 83 EC 18 48 C7 01 00 00 00 00 4C 8B 6C 24 50 0F 1F 40 00 48 0F BE 03 8D 48 D0 80 F9 09 76 16 4D 85 ED 74 0A 41 3A 45 00 0F 84 8D 00 00 00 4C 01 CB 48 0F BE 03 48 8D 4C AD 00 41 83 EC 01 48 83 C3 01 83 C6 01 45 85 E4 48 8D 6C 48 D0 7E 24 83 FE 13 75 BF 48 85 D2 0F 85 A6 00 00 00 49 89 2E B2 01 49 C7 07 01 00 00 00 31 ED 40 30 F6 EB A3 0F 1F 00 49 63 00 85 C0 7E 0C 8D 0C 06 83 F9 13 0F 8E FD 00 00 00 48 63 F6 48 85 D2 48 8B 0C F5 ?? ?? ?? ?? 0F 85 0D 01 00 00 49 89 2E 49 C7 07 01 00 00 00 48 83 C4 18 48 89 D8 5B 5D 41 5C 41 5D 41 5E 41 5F C3 0F 1F 44 00 00 41 0F B6 45 01 84 C0 0F 84 60 01 00 00 38 43 01 0F 85 5D FF FF FF B8 02 00 00 00 EB 11 0F 1F 00 48 83 C0 01 38 4C 03 FF 0F 85 45 FF FF FF 41 0F B6 4C 05 00 84 C9 75 E8 48 01 C3 48 0F BE 03 E9 36 FF FF FF 0F 1F 40 00 48 B9 00 00 E8 89 04 23 C7 8A 4C 89 F6 4C 89 F7 4C 89 44 24 08 4C 89 0C 24 E8 ?? ?? ?? ?? 48 89 C1 49 8B 06 49 8B 17 4C 8B 44 24 08 4C 8B 0C 24 48 01 C5 48 39 E8 49 89 2E 76 1D 49 8D 7E 08 90 48 83 EA 01 0F 84 CA 00 00 00 48 8B 07 48 83 C0 01 48 85 C0 48 AB 74 E8 31 D2 48 01 CA 0F 84 A5 00 00 00 49 8B 07 31 ED 31 F6 49 89 14 C6 49 8B 17 48 83 C2 01 49 89 17 E9 93 FE FF FF 0F 1F 00 48 0F AF 2C C5 ?? ?? ?? ?? 48 63 C9 48 85 D2 41 C7 00 00 00 00 00 48 8B 0C CD ?? ?? ?? ?? 0F 84 F3 FE FF FF 4C 89 F6 4C 89 F7 E8 ?? ?? ?? ?? 48 89 C1 49 8B 06 49 8B 17 48 01 C5 48 39 E8 49 89 2E 76 21 49 8D 7E 08 66 0F 1F 84 00 00 00 00 00 48 83 EA 01 74 48 48 8B 07 48 83 C0 01 48 85 C0 48 AB 74 EC 31 D2 48 01 CA 0F 84 B2 FE FF FF 49 8B 07 49 89 14 C6 48 83 C0 01 49 89 07 E9 9F FE FF FF 66 0F 1F 44 00 00 49 8B 17 31 ED 31 F6 E9 FC FD FF FF BA 01 00 00 00 E9 3C FF FF FF BA 01 00 00 00 EB C1 B8 01 00 00 00 E9 C1 FE FF FF }
	condition:
		$1
}

rule file_181_2_0 {
	meta:
		name = "____strtod_l_internal"
		size = 7187
		refs = "0042 strlen 0267 _nl_C_locobj 0508 _fpioconst_pow10 0533 __tens 0544 __mpn_mul 0770 __correctly_grouped_prefixmb 07b6 .LC4 0857 memcpy 0add __mpn_lshift 0b58 __mpn_cmp 0cec __mpn_submul_1 0d0f __mpn_add_n 0f66 __strncasecmp_l 0fb0 .LC1 0fc1 .LC2 0ff5 .LC3 1761 __mpn_rshift 1800 ____strtoull_l_internal 193c __libc_errno"
	strings:
		$1 = { 41 57 49 89 CF 41 56 41 55 41 54 55 53 48 81 EC 08 02 00 00 85 D2 48 8B 41 08 48 89 7C 24 40 48 89 74 24 38 0F 85 4C 1A 00 00 31 C9 48 C7 44 24 48 00 00 00 00 48 8B 68 40 48 89 4C 24 20 48 89 EF E8 ?? ?? ?? ?? 48 8B 5C 24 40 49 8B 57 68 48 8B 4C 24 20 48 89 44 24 50 C7 84 24 9C 00 00 00 00 00 00 00 48 83 EB 01 0F 1F 84 00 00 00 00 00 48 83 C3 01 4C 0F BE 2B 49 0F BE C5 F6 44 42 01 20 75 ED 41 80 FD 2D 48 89 D8 0F 84 10 03 00 00 41 80 FD 2B C7 44 24 58 00 00 00 00 0F 84 46 03 00 00 0F B6 7D 00 40 84 FF 0F 84 31 11 00 00 40 3A 3B 0F 85 A0 01 00 00 B8 01 00 00 00 EB 0F 90 48 83 C0 01 3A 54 03 FF 0F 85 8A 01 00 00 0F B6 54 05 00 84 D2 75 E9 0F B6 04 03 3C 2F 0F 8E 75 01 00 00 3C 39 0F 8F 6D 01 00 00 41 80 FD 30 49 8B 77 70 0F 84 77 05 00 00 45 31 C9 48 83 7C 24 48 00 41 0F 94 C1 0F 85 94 19 00 00 49 89 DB 41 BE 0A 00 00 00 49 0F BE C5 44 8B 04 86 41 8D 45 D0 3C 09 76 53 41 83 FE 10 41 0F 95 C2 41 80 F8 60 0F 8F 69 05 00 00 40 84 FF 74 2A 40 3A 3B 0F 85 EF 05 00 00 31 C0 EB 14 0F 1F 80 00 00 00 00 48 83 C0 01 3A 14 03 0F 85 D7 05 00 00 0F B6 54 05 01 84 D2 75 EA 49 39 DB 75 0D 41 83 FE 10 0F 84 76 06 00 00 0F 1F 00 49 89 DC 45 31 C0 41 8D 45 D0 3C 09 0F 86 3E 01 00 00 41 83 FE 10 0F 84 1C 01 00 00 4D 85 C9 0F 84 1F 18 00 00 48 85 C9 0F 85 05 19 00 00 41 83 F8 01 19 D2 40 84 FF 74 26 31 C0 41 38 3C 24 74 15 E9 22 01 00 00 66 90 48 83 C0 01 41 3A 0C 04 0F 85 12 01 00 00 0F B6 4C 05 01 84 C9 75 E9 4C 8B 4C 24 50 45 89 C5 4D 01 E1 49 0F BE 01 4D 89 CC EB 3B 0F 1F 44 00 00 48 0F BE C8 8B 0C 8E 8D 79 9F 40 80 FF 05 0F 87 E3 00 00 00 83 FA FF 75 10 3C 30 44 89 E0 0F 95 C1 44 29 C8 84 C9 0F 45 D0 49 83 C4 01 49 0F BE 04 24 41 83 C5 01 8D 48 D0 80 F9 09 76 D6 41 83 FE 10 74 BC 0F B6 04 86 4C 89 E1 31 FF 3C 65 0F 85 BE 01 00 00 41 83 FE 10 0F 84 B4 01 00 00 E9 B4 00 00 00 0F 1F 40 00 41 8D 45 D0 3C 09 0F 86 87 FE FF FF 48 8B 05 ?? ?? ?? ?? 42 0F B6 04 A8 3C 69 0F 84 DB 0C 00 00 3C 6E 0F 84 4A 0D 00 00 48 83 7C 24 38 00 0F 84 50 01 00 00 4C 8B 54 24 40 4C 8B 44 24 38 66 0F 57 C0 4D 89 10 48 81 C4 08 02 00 00 5B 5D 41 5C 41 5D 41 5E 41 5F C3 90 49 0F BE C5 8B 04 86 83 E8 61 3C 05 0F 87 D2 FE FF FF 66 0F 1F 44 00 00 41 83 C0 01 4C 89 E0 4C 8D 60 01 4C 0F BE 68 01 E9 A1 FE FF FF 0F 1F 00 42 8B 0C AE 45 89 C5 41 83 FE 10 89 C8 40 0F 94 C7 80 F9 70 0F 85 C6 04 00 00 40 84 FF 0F 84 BD 04 00 00 BF 01 00 00 00 41 0F BE 74 24 01 40 80 FE 2D 0F 84 FC 04 00 00 45 31 DB 40 80 FE 2B 49 8D 4C 24 01 0F 84 13 0B 00 00 8D 46 D0 3C 09 0F 87 CB 00 00 00 40 84 FF 0F 85 8A 04 00 00 45 85 DB 45 8D 90 68 01 00 00 75 0D 41 89 D2 45 29 C2 41 81 C2 35 01 00 00 8B 84 24 9C 00 00 00 66 90 8D 04 80 8D 44 46 D0 44 39 D0 89 84 24 9C 00 00 00 0F 8F 10 18 00 00 48 83 C1 01 0F BE 31 44 8D 4E D0 41 80 F9 09 76 D8 45 85 DB 74 76 F7 D8 89 84 24 9C 00 00 00 EB 6B 0F 1F 84 00 00 00 00 00 48 83 C3 01 4C 0F BE 68 01 C7 44 24 58 01 00 00 00 E9 EC FC FF FF 48 83 7C 24 38 00 74 12 48 8B 54 24 38 48 89 02 66 2E 0F 1F 84 00 00 00 00 00 8B 74 24 58 85 F6 0F 85 D6 03 00 00 66 0F 57 C0 E9 B8 FE FF FF 0F 1F 00 48 83 C3 01 4C 0F BE 68 01 E9 AC FC FF FF 66 2E 0F 1F 84 00 00 00 00 00 4C 89 E1 45 39 C5 0F 8F C4 01 00 00 45 85 ED 7E 0F 45 39 E8 0F 84 C3 01 00 00 66 0F 1F 44 00 00 48 83 7C 24 38 00 74 08 4C 8B 54 24 38 49 89 0A 45 85 ED 74 9B 85 D2 0F 85 7B 02 00 00 8B B4 24 9C 00 00 00 41 83 FE 10 0F 84 FF 09 00 00 85 F6 0F 88 C3 0B 00 00 44 89 E8 44 29 C0 39 F0 0F 4F C6 45 8D 3C 00 29 C6 89 B4 24 9C 00 00 00 41 8D 04 37 3D 35 01 00 00 0F 8F E3 16 00 00 81 FE BD FE FF FF 0F 8C B0 14 00 00 45 85 FF 0F 8E A5 04 00 00 48 8D AC 24 9C 00 00 00 48 8B 54 24 48 4C 8B 4C 24 50 48 8D 8C 24 B0 00 00 00 48 89 DF 44 89 FE 48 89 6C 24 70 48 8D AC 24 C0 00 00 00 4C 8B 44 24 70 48 89 14 24 48 89 4C 24 78 48 89 EA 48 89 6C 24 38 E8 D6 F8 FF FF 48 89 C3 8B 84 24 9C 00 00 00 48 8B AC 24 B0 00 00 00 85 C0 0F 8E 67 03 00 00 4C 8D 94 24 60 01 00 00 48 89 5C 24 68 44 89 6C 24 5C 41 BE ?? ?? ?? ?? 41 BC 01 00 00 00 44 89 BC 24 80 00 00 00 4D 89 D3 4C 89 54 24 40 4C 8B 54 24 38 4D 89 DD 4C 89 D3 EB 5C 48 8D 0C C5 ?? ?? ?? ?? 4D 89 F8 48 89 EA 48 89 DE 4C 89 EF E8 ?? ?? ?? ?? 4C 89 FD 48 03 AC 24 B0 00 00 00 48 85 C0 48 89 AC 24 B0 00 00 00 75 0C 48 83 ED 01 48 89 AC 24 B0 00 00 00 8B 84 24 9C 00 00 00 48 89 DA 4C 89 EB 49 89 D5 45 01 E4 49 83 C6 18 85 C0 0F 84 9F 02 00 00 44 85 E0 74 EC 4D 8B 7E 08 44 31 E0 89 84 24 9C 00 00 00 49 8B 06 49 83 EF 01 49 39 EF 7E 85 48 8D 34 C5 ?? ?? ?? ?? 49 89 E8 48 89 D9 4C 89 FA 4C 89 EF E8 ?? ?? ?? ?? EB 83 0F 1F 00 49 83 EC 01 41 83 ED 01 41 80 7C 24 FF 30 74 F0 E9 2F FE FF FF 44 8B 8C 24 9C 00 00 00 49 8D 44 24 FF 45 85 C9 0F 89 2D FE FF FF EB 5C 0F 1F 00 0F BE 30 83 EE 30 83 FE 09 40 0F 97 C6 40 84 F6 75 43 80 38 30 0F 85 0D FE FF FF 44 8B 8C 24 9C 00 00 00 41 83 ED 01 41 83 E8 01 40 80 FF 01 19 F6 83 E6 FD 42 8D 74 0E 04 89 B4 24 9C 00 00 00 C1 EE 1F 40 84 F6 0F 84 DC FD FF FF 45 85 ED 0F 8E D3 FD FF FF 48 83 E8 01 40 84 FF 74 A2 4C 0F BE 08 49 8B 77 68 42 0F B7 34 4E 66 C1 EE 0C 83 F6 01 83 E6 01 EB 96 90 48 0F BE 43 01 83 3C 86 78 0F 84 68 0B 00 00 45 31 C9 48 83 7C 24 48 00 41 0F 94 C1 0F 85 0E 14 00 00 49 89 DB 41 BE 0A 00 00 00 E9 71 0B 00 00 45 84 D2 0F 85 8E FA FF FF 41 80 F8 66 0F 8E C5 FA FF FF E9 7F FA FF FF 0F B6 7D 00 0F B6 33 44 0F B6 4D 01 EB 12 66 2E 0F 1F 84 00 00 00 00 00 0F B6 73 01 48 83 C3 01 40 38 F7 75 F3 45 84 C9 74 21 0F B6 73 01 44 38 CE 75 E9 31 C0 EB 0B 90 48 83 C0 01 3A 4C 03 01 75 DA 0F B6 4C 05 02 84 C9 75 ED 48 63 C2 48 03 44 24 50 8B B4 24 9C 00 00 00 48 01 C3 8D 04 95 00 00 00 00 41 83 FE 10 0F 45 C2 41 29 D5 29 C6 89 B4 24 9C 00 00 00 E9 10 FD FF FF 45 84 D2 0F 84 4E 0F 00 00 41 83 FE 10 41 0F 94 C2 41 80 F8 65 75 0F 45 31 C0 45 84 D2 49 89 DC 0F 84 24 FA FF FF 48 8B 54 24 48 4C 89 DF 48 89 DE 44 88 54 24 20 4C 89 5C 24 18 E8 ?? ?? ?? ?? 48 83 7C 24 38 00 44 0F B6 54 24 20 4C 8B 5C 24 18 74 1B 49 39 C3 0F 84 2C 11 00 00 48 89 44 24 40 48 8B 6C 24 40 48 8B 4C 24 38 48 89 29 8B 6C 24 58 66 0F 57 C0 85 ED 0F 84 EB FA FF FF F2 0F 10 05 ?? ?? ?? ?? E9 DE FA FF FF 90 4C 89 E1 E9 75 FA FF FF 45 85 DB 46 8D 14 85 32 04 00 00 0F 85 7E FB FF FF 89 D0 44 29 C0 44 8D 14 85 03 04 00 00 E9 6C FB FF FF 48 8B 54 24 50 48 0F BE 04 13 8D 50 D0 80 FA 09 0F 86 77 F9 FF FF 8B 04 86 83 E8 61 3C 05 0F 86 69 F9 FF FF E9 29 FF FF FF 49 8D 4C 24 02 41 0F BE 74 24 02 41 BB 01 00 00 00 E9 00 FB FF FF 49 89 DA 4C 3B 54 24 40 44 8B 6C 24 5C 48 8B 5C 24 68 44 8B BC 24 80 00 00 00 75 15 48 8B 7C 24 38 48 8D 14 ED 00 00 00 00 4C 89 D6 E8 ?? ?? ?? ?? 48 8D 55 FF 89 EE C1 E6 06 48 0F BD 84 D4 C0 00 00 00 83 F0 3F 29 C6 81 FE 00 04 00 00 41 89 F4 0F 8F DF 12 00 00 83 FE 35 0F 8E 9E 07 00 00 44 8D 4E CB 44 89 CF 41 83 E1 3F 4D 63 C1 C1 FF 06 4D 85 C0 48 63 C7 0F 84 97 08 00 00 49 83 E8 01 48 39 C2 4C 8B 94 C4 C0 00 00 00 0F 8F FC 0D 00 00 44 89 C9 49 D3 EA 48 89 C1 4C 89 94 24 A0 00 00 00 48 83 BC 24 C0 00 00 00 00 0F 85 D9 0F 00 00 48 8B 44 24 38 31 D2 48 83 C0 08 66 0F 1F 84 00 00 00 00 00 48 83 C0 08 83 C2 01 48 83 78 F8 00 74 F2 45 39 FD 41 B9 01 00 00 00 7F 0D 48 63 D2 45 31 C9 48 39 CA 41 0F 9C C1 48 8B 8C CC C0 00 00 00 8B 54 24 58 48 8D BC 24 A0 00 00 00 83 EE 01 E8 7E F2 FF FF E9 66 F9 FF FF 48 8D 8C 24 A0 00 00 00 48 8D AC 24 9C 00 00 00 B8 14 00 00 00 BA 12 00 00 00 45 31 E4 48 89 4C 24 60 48 89 6C 24 70 48 8D 8C 24 B0 00 00 00 48 8D AC 24 C0 00 00 00 48 89 4C 24 78 48 89 6C 24 38 45 29 FD C6 84 24 80 00 00 00 00 41 39 C5 44 89 6C 24 68 7E 0F 83 C2 02 C6 84 24 80 00 00 00 01 89 54 24 68 44 8B 4C 24 68 4C 8B 54 24 38 4C 8D 9C 24 60 01 00 00 31 ED 44 89 A4 24 84 00 00 00 48 89 9C 24 88 00 00 00 49 89 EC 41 BF ?? ?? ?? ?? 4C 89 5C 24 40 41 29 F1 4D 89 DE 41 BD 01 00 00 00 44 89 CB 4C 89 D5 EB 34 66 0F 1F 44 00 00 4D 8B 67 08 49 8B 07 4C 89 F7 49 83 EC 01 48 8D 34 C5 ?? ?? ?? ?? 4A 8D 14 E5 00 00 00 00 E8 ?? ?? ?? ?? 45 01 ED 49 83 C7 18 85 DB 74 58 44 85 EB 74 F0 44 31 EB 4D 85 E4 74 C5 49 8B 07 49 8B 57 08 4D 89 E0 4C 89 F1 48 89 EF 48 8D 34 C5 ?? ?? ?? ?? 48 83 EA 01 E8 ?? ?? ?? ?? 49 8B 57 08 48 85 C0 4D 8D 64 14 FF 0F 85 D9 03 00 00 4C 89 F0 49 83 EC 01 45 01 ED 49 83 C7 18 85 DB 49 89 EE 48 89 C5 75 A8 4C 3B 74 24 38 4C 89 E5 48 8B 9C 24 88 00 00 00 44 8B A4 24 84 00 00 00 0F 84 95 0D 00 00 48 8B 54 24 48 4C 8B 44 24 70 48 89 DF 4C 8B 4C 24 50 48 8B 4C 24 78 8B 74 24 68 48 89 14 24 48 8B 54 24 38 E8 FB F2 FF FF 4C 8D 45 FF 4A 0F BD 9C C4 60 01 00 00 4C 89 44 24 50 48 83 F3 3F 85 DB 7E 32 48 8B 74 24 40 89 D9 48 89 EA 48 89 F7 E8 ?? ?? ?? ?? 48 8B 74 24 38 48 8B 94 24 B0 00 00 00 89 D9 48 89 F7 E8 ?? ?? ?? ?? 48 85 C0 0F 85 7F 05 00 00 48 83 FD 01 44 89 A4 24 9C 00 00 00 0F 84 28 07 00 00 48 83 FD 02 0F 84 52 08 00 00 48 8B 94 24 B0 00 00 00 4C 8B 54 24 40 48 89 E8 4C 8B 44 24 50 48 8B 7C 24 38 4C 8D 4D FE 48 29 D0 4E 8B BC CC 60 01 00 00 49 8D 34 C2 4E 8B B4 C4 60 01 00 00 4C 89 4C 24 20 E8 ?? ?? ?? ?? 85 C0 4C 8B 4C 24 20 48 8B 84 24 B0 00 00 00 7E 18 48 C7 84 C4 C0 00 00 00 00 00 00 00 48 83 C0 01 48 89 84 24 B0 00 00 00 48 39 E8 0F 8D A4 0A 00 00 48 89 EB 48 29 C3 45 85 E4 0F 8E DD 0C 00 00 48 89 DA 49 63 CC 48 C1 E2 06 48 01 CA 48 83 FA 35 0F 8F 89 0C 00 00 48 C7 84 24 A0 00 00 00 00 00 00 00 C7 44 24 5C 00 00 00 00 89 DA C1 E2 06 41 01 D4 85 C0 48 63 D0 7E 34 4C 8B 5C 24 38 48 01 DA 83 E8 01 49 8D 14 D3 66 2E 0F 1F 84 00 00 00 00 00 48 63 C8 83 E8 01 48 83 EA 08 48 8B 8C CC C0 00 00 00 48 89 4A 08 83 F8 FF 75 E5 48 85 DB 78 2B 48 8B 54 24 38 48 89 D0 48 83 C0 08 48 8D 0C D8 EB 0A 66 0F 1F 44 00 00 48 83 C0 08 48 39 C8 48 C7 02 00 00 00 00 48 89 C2 75 ED 41 83 FC 35 48 C7 84 EC 60 01 00 00 00 00 00 00 48 8B 8C EC C0 00 00 00 0F 8F 3A 0C 00 00 44 8D 6D 01 4C 8D 45 01 44 8D 55 FF 44 89 64 24 48 41 29 ED 4C 89 44 24 70 44 89 54 24 78 45 89 EC 4D 89 CD 0F 1F 00 4C 39 F1 48 C7 C3 FF FF FF FF 74 4D 4C 8B 5C 24 50 48 89 CA 4E 8B 9C DC C0 00 00 00 4C 89 D8 49 F7 F6 48 89 C3 48 89 D1 4C 89 F8 48 F7 E3 EB 0F 31 F6 4C 39 F8 40 0F 92 C6 4C 29 F8 48 29 F2 48 39 CA 77 0C 75 13 4A 3B 84 EC C0 00 00 00 76 09 48 83 EB 01 4C 01 F1 73 D7 48 8B 54 24 70 48 8B 74 24 40 48 89 D9 48 8B 7C 24 38 E8 ?? ?? ?? ?? 48 39 84 EC C0 00 00 00 74 19 48 8B 74 24 38 48 8B 54 24 40 48 89 E9 48 83 EB 01 48 89 F7 E8 ?? ?? ?? ?? 4C 8B 44 24 50 8B 54 24 78 4A 8B 8C C4 C0 00 00 00 85 D2 48 89 8C EC C0 00 00 00 7E 29 8D 45 FE 0F 1F 44 00 00 48 63 D0 85 C0 48 8B B4 D4 C0 00 00 00 41 8D 14 04 8D 40 FF 48 63 D2 48 89 B4 D4 C0 00 00 00 7F DF 8B 44 24 48 48 C7 84 24 C0 00 00 00 00 00 00 00 85 C0 0F 85 EF 03 00 00 48 85 DB 0F 84 FF 03 00 00 48 0F BD C3 8B B4 24 9C 00 00 00 BA 40 00 00 00 83 F0 3F 29 C2 29 C6 83 FA 35 89 B4 24 9C 00 00 00 0F 8E AB 0B 00 00 B9 0B 00 00 00 44 8D 50 35 29 C1 48 89 D8 48 D3 E8 44 89 54 24 5C 48 89 84 24 A0 00 00 00 48 63 D5 89 E8 48 83 BC D4 C0 00 00 00 00 75 26 85 ED 78 22 89 E9 29 E9 83 E9 01 EB 08 0F 1F 40 00 39 C8 74 11 83 E8 01 48 63 D0 48 83 BC D4 C0 00 00 00 00 74 EB F7 D0 41 B8 3F 00 00 00 44 2B 44 24 5C C1 E8 1F 0A 84 24 80 00 00 00 41 89 C1 83 EE 01 41 83 E1 01 8B 54 24 58 48 8B 7C 24 60 4D 63 C0 48 89 D9 E8 86 ED FF FF E9 6E F4 FF FF 4C 89 F0 49 89 EE 48 89 C5 E9 CE FB FF FF 49 8D 4C 24 02 41 0F BE 74 24 02 E9 DD F4 FF FF 48 0F BE 03 4D 8B 4F 68 48 0F BE D0 41 F6 44 51 01 10 75 27 0F 1F 80 00 00 00 00 48 83 C3 01 48 0F BE 03 48 0F BE D0 41 F6 44 51 01 10 74 EC EB 0A 66 90 48 83 C3 01 48 0F BE 03 3C 30 74 F4 0F BE F8 83 EF 30 83 FF 09 0F 86 D9 01 00 00 49 8B 57 70 48 83 C3 01 8B 3C 82 83 EF 57 48 63 FF 8B 14 BD ?? ?? ?? ?? B9 35 00 00 00 B8 34 00 00 00 41 83 ED 01 29 D1 29 D0 42 8D 54 82 FB 48 D3 E7 01 D6 45 85 ED 48 89 BC 24 A0 00 00 00 89 B4 24 9C 00 00 00 0F 8E 6A 04 00 00 4C 8B 44 24 50 EB 30 66 90 48 63 D1 48 83 C3 01 83 F8 02 0F 8E 97 06 00 00 8D 48 FD 83 E8 04 48 D3 E2 48 09 D7 41 83 ED 01 48 89 BC 24 A0 00 00 00 0F 84 33 04 00 00 48 0F BE 13 48 0F BE CA 41 F6 44 49 01 10 75 07 4C 01 C3 48 0F BE 13 0F BE CA 83 E9 30 83 F9 09 76 B0 49 8B 4F 70 48 83 C3 01 8B 14 91 83 EA 57 48 63 D2 EB A4 B9 ?? ?? ?? ?? BA 03 00 00 00 BE ?? ?? ?? ?? 48 89 DF E8 ?? ?? ?? ?? 85 C0 0F 85 0E F3 FF FF 48 83 7C 24 38 00 74 2D 48 8D 6B 03 B9 ?? ?? ?? ?? BA 05 00 00 00 BE ?? ?? ?? ?? 48 83 C3 08 48 89 EF E8 ?? ?? ?? ?? 48 8B 4C 24 38 85 C0 48 0F 44 EB 48 89 29 44 8B 64 24 58 F2 0F 10 05 ?? ?? ?? ?? 45 85 E4 0F 84 E0 F2 FF FF F2 0F 10 05 ?? ?? ?? ?? E9 D3 F2 FF FF B9 ?? ?? ?? ?? BA 03 00 00 00 BE ?? ?? ?? ?? 48 89 DF E8 ?? ?? ?? ?? 85 C0 0F 85 97 F2 FF FF 80 7B 03 28 48 8D 73 03 F2 0F 10 05 ?? ?? ?? ?? 0F 84 9F 07 00 00 48 }
	condition:
		$1
}

rule file_182_0_0 {
	meta:
		name = "__xpg_basename"
		size = 194
		refs = "001d strrchr"
	strings:
		$1 = { 48 85 FF B8 ?? ?? ?? ?? 0F 84 B2 00 00 00 80 3F 00 74 58 53 BE 2F 00 00 00 48 89 FB E8 ?? ?? ?? ?? 48 85 C0 74 5A 80 78 01 00 75 44 48 39 C3 73 39 80 78 FF 2F 74 12 EB 4D 0F 1F 80 00 00 00 00 80 7A FF 2F 48 89 D0 75 47 48 8D 50 FF 48 39 DA 75 EE 80 38 00 48 89 D8 74 10 66 0F 1F 44 00 00 48 83 C0 01 80 78 01 00 75 F6 5B F3 C3 0F 1F 00 48 83 C0 01 5B EB F4 66 0F 1F 84 00 00 00 00 00 48 89 D8 5B EB E5 48 89 C2 0F 1F 80 00 00 00 00 48 8D 42 FF C6 02 00 48 39 C3 73 CE 80 7A FE 2F 75 0C EB C6 0F 1F 40 00 80 78 FF 2F 74 BC 48 83 E8 01 48 39 D8 75 F1 5B EB B1 66 0F 1F 44 00 00 F3 C3 }
	condition:
		$1
}

rule file_183_0_0 {
	meta:
		name = "__ppoll_chk"
		size = 20
		refs = "0010 __chk_fail 000a ppoll"
	strings:
		$1 = { 49 C1 E8 03 49 39 F0 72 05 E9 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_184_0_0 {
	meta:
		name = "execl"
		size = 403
		refs = "00c9 realloc 00ff __environ 010a __execve 011b free 0184 memcpy"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 53 48 81 EC 68 20 00 00 48 85 F6 48 8D 84 24 A0 20 00 00 48 89 94 24 40 20 00 00 48 89 8C 24 48 20 00 00 4C 89 84 24 50 20 00 00 4C 89 8C 24 58 20 00 00 48 89 44 24 20 48 8D 84 24 30 20 00 00 48 89 74 24 30 C7 44 24 18 10 00 00 00 48 89 44 24 28 0F 84 D4 00 00 00 4C 8D 74 24 30 49 89 FC BB 01 00 00 00 BD 01 00 00 00 BA 00 04 00 00 4D 89 F5 0F 1F 44 00 00 8B 4C 24 18 4D 8D 44 ED 00 83 F9 30 73 52 89 C8 48 03 44 24 28 83 C1 08 83 C3 01 89 4C 24 18 48 8B 00 48 85 C0 49 89 00 74 52 89 DD 48 39 EA 75 CF 48 89 D6 4C 8D 3C 12 48 C1 E6 04 4D 39 F5 0F 84 9B 00 00 00 4C 89 EF E8 ?? ?? ?? ?? 48 85 C0 74 76 49 89 C5 4C 89 FA EB A6 66 0F 1F 44 00 00 48 8B 44 24 20 83 C3 01 48 8D 48 08 48 8B 00 48 89 4C 24 20 48 85 C0 49 89 00 75 AE 48 8B 15 ?? ?? ?? ?? 4C 89 EE 4C 89 E7 E8 ?? ?? ?? ?? 4D 39 F5 74 10 4C 89 EF 89 44 24 08 E8 ?? ?? ?? ?? 8B 44 24 08 48 81 C4 68 20 00 00 5B 5D 41 5C 41 5D 41 5E 41 5F C3 48 8B 15 ?? ?? ?? ?? 48 8D 74 24 30 E8 ?? ?? ?? ?? EB DB 4C 89 EF E8 ?? ?? ?? ?? B8 FF FF FF FF EB CC 66 0F 1F 84 00 00 00 00 00 31 FF 48 89 54 24 08 E8 ?? ?? ?? ?? 48 85 C0 48 89 C1 48 8B 54 24 08 74 D7 48 C1 E2 03 4C 89 EE 48 89 CF E8 ?? ?? ?? ?? 4C 89 FA 49 89 C5 E9 ED FE FF FF }
	condition:
		$1
}

rule file_185_0_0 {
	meta:
		name = "_rpc_dtablesize"
		size = 36
		refs = "0015 __getdtablesize"
	strings:
		$1 = { 8B 05 ?? ?? ?? ?? 85 C0 74 06 F3 C3 0F 1F 40 00 48 83 EC 08 E8 ?? ?? ?? ?? 89 05 ?? ?? ?? ?? 48 83 C4 08 C3 }
	condition:
		$1
}

rule file_186_0_0 {
	meta:
		name = "__mpn_mod_1"
		size = 60
	strings:
		$1 = { 49 89 D0 31 D2 48 85 F6 74 27 48 8D 4E FF 48 8B 14 CF 4C 39 C2 73 21 48 8D 4E FE 48 85 C9 78 11 48 8B 04 CF 48 83 E9 01 49 F7 F0 48 83 F9 FF 75 EF 48 89 D0 C3 0F 1F 00 31 D2 EB DF }
	condition:
		$1
}

rule file_187_0_0 {
	meta:
		name = "_L_lock_37"
		size = 27
		refs = "000b __lll_lock_wait_private"
	strings:
		$1 = { 48 8D 3A 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 3C FF FF FF }
	condition:
		$1
}

rule file_187_1_0 {
	meta:
		name = "_L_unlock_85"
		size = 27
		refs = "000b __lll_unlock_wake_private"
		altNames = "_L_unlock_231"
	strings:
		$1 = { 48 8D 3A 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 7A FF FF FF }
	condition:
		$1
}

rule file_584_0_0 {
	meta:
		name = "_L_lock_42"
		size = 27
		refs = "000b __lll_lock_wait_private"
	strings:
		$1 = { 48 8D 3A 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 7A FF FF FF }
	condition:
		$1
}

rule file_187_3_0 {
	meta:
		name = "fputc"
		size = 242
		refs = "002d __libc_multiple_threads 00ae __overflow 00ee _Unwind_Resume"
		altNames = "_IO_putc"
	strings:
		$1 = { 53 8B 06 41 89 F8 48 89 F3 25 00 80 00 00 75 48 48 8B 96 88 00 00 00 64 4C 8B 0C 25 10 00 00 00 4C 3B 4A 08 74 2E BE 01 00 00 00 83 3D ?? ?? ?? ?? 00 74 0C F0 0F B1 32 0F 85 B4 00 00 00 EB 09 0F B1 32 0F 85 A9 00 00 00 48 8B 93 88 00 00 00 4C 89 4A 08 83 42 04 01 48 8B 53 28 48 3B 53 30 73 44 44 88 02 48 83 C2 01 41 0F B6 F0 48 89 53 28 F7 03 00 80 00 00 75 29 48 8B 93 88 00 00 00 83 6A 04 01 75 1C 48 C7 42 08 00 00 00 00 83 3D ?? ?? ?? ?? 00 74 07 F0 FF 0A 75 71 EB 04 FF 0A 75 6B 89 F0 5B C3 41 0F B6 F0 48 89 DF E8 ?? ?? ?? ?? 89 C6 EB BB F7 03 00 80 00 00 48 89 C6 75 29 48 8B 93 88 00 00 00 83 6A 04 01 75 1C 48 C7 42 08 00 00 00 00 83 3D ?? ?? ?? ?? 00 74 07 F0 FF 0A 75 44 EB 04 FF 0A 75 3E 48 89 F7 E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_188_0_0 {
	meta:
		name = "__finite"
		size = 36
	strings:
		$1 = { 48 BA FF FF FF FF FF FF FF 7F 66 48 0F 7E C0 48 21 D0 48 BA 00 00 00 00 00 00 10 80 48 01 D0 48 C1 E8 3F C3 }
	condition:
		$1
}

rule file_190_0_0 {
	meta:
		name = "_nl_intern_locale_data"
		size = 801
		refs = "0078 malloc 016b __assert_fail 02c7 free 02ce __libc_errno"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 53 48 83 EC 08 48 83 FA 07 0F 86 B3 02 00 00 83 FF 03 49 89 D5 89 FD 48 89 F3 8B 16 B8 17 10 05 20 74 12 89 F9 B8 20 07 09 20 81 F1 15 11 03 20 85 FF 0F 45 C1 39 D0 0F 85 85 02 00 00 44 8B 7B 04 4C 63 F5 45 89 FC 4E 3B 24 F5 ?? ?? ?? ?? 0F 82 6D 02 00 00 4A 8D 04 A5 08 00 00 00 49 39 C5 0F 86 5C 02 00 00 4A 8D 3C E5 40 00 00 00 E8 ?? ?? ?? ?? 48 85 C0 0F 84 5B 02 00 00 4D 85 E4 48 89 58 08 4C 89 68 10 48 C7 40 28 00 00 00 00 48 C7 40 20 00 00 00 00 C7 40 30 00 00 00 00 C7 40 34 00 00 00 00 44 89 78 38 0F 84 28 02 00 00 8B 73 08 41 89 F0 4D 39 C5 0F 82 FC 01 00 00 31 C9 EB 3A 0F 1F 44 00 00 85 ED 0F 85 30 02 00 00 48 83 F9 46 76 4A 66 90 49 01 D8 4C 89 44 C8 40 48 83 C1 01 49 39 CC 0F 86 EB 01 00 00 8B 74 8B 08 41 89 F0 4D 39 C5 0F 82 BE 01 00 00 83 FD 0C 77 C6 89 EA FF 24 D5 ?? ?? ?? ?? 0F 1F 44 00 00 48 83 F9 0F 0F 87 CD 01 00 00 66 0F 1F 44 00 00 4A 8B 14 F5 ?? ?? ?? ?? 83 3C 8A 05 75 AA 83 E6 03 0F 85 84 01 00 00 42 8B 14 03 89 54 C8 40 EB 9F 0F 1F 80 00 00 00 00 48 83 F9 01 76 D2 B9 ?? ?? ?? ?? BA 89 00 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 90 48 83 F9 04 76 B2 B9 ?? ?? ?? ?? BA 88 00 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 90 48 83 F9 0C 76 92 B9 ?? ?? ?? ?? BA 87 00 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 90 48 83 F9 06 0F 86 6E FF FF FF B9 ?? ?? ?? ?? BA 86 00 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 0F 1F 44 00 00 48 83 F9 02 0F 86 46 FF FF FF B9 ?? ?? ?? ?? BA 85 00 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 0F 1F 44 00 00 48 83 F9 04 0F 86 1E FF FF FF B9 ?? ?? ?? ?? BA 84 00 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 0F 1F 44 00 00 48 83 F9 2D 0F 86 F6 FE FF FF B9 ?? ?? ?? ?? BA 83 00 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 0F 1F 44 00 00 48 83 F9 12 0F 86 CE FE FF FF B9 ?? ?? ?? ?? BA 82 00 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 0F 1F 44 00 00 48 83 F9 05 0F 86 A6 FE FF FF B9 ?? ?? ?? ?? BA 80 00 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 0F 1F 44 00 00 48 83 F9 6E 0F 86 7E FE FF FF B9 ?? ?? ?? ?? BA 81 00 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 C7 E8 ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? 64 C7 00 16 00 00 00 31 C0 0F 1F 44 00 00 48 83 C4 08 5B 5D 41 5C 41 5D 41 5E 41 5F C3 B9 ?? ?? ?? ?? BA 8A 00 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? B9 ?? ?? ?? ?? BA 8C 00 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_190_1_0 {
	meta:
		name = "_nl_load_locale"
		size = 699
		refs = "003f __open_nocancel 0061 __fxstat64 0086 __libc_errno 00ad __mmap 00e1 _nl_intern_locale_data 011a free 0155 __munmap 017e malloc 01b5 __read_nocancel 021a _nl_category_name_sizes 0222 _nl_category_name_idxs 022d _nl_category_names 024a mempcpy 0264 memcpy"
	strings:
		$1 = { 55 31 C0 48 89 E5 48 89 5D D8 4C 89 6D E8 48 89 FB 4C 89 75 F0 4C 89 65 E0 41 89 F6 4C 89 7D F8 48 81 EC E0 00 00 00 C7 47 08 01 00 00 00 48 C7 47 10 00 00 00 00 48 8B 3F BE 00 00 08 00 E8 ?? ?? ?? ?? 4C 63 E8 4D 85 ED 0F 88 AA 00 00 00 48 8D 95 40 FF FF FF 89 C6 BF 01 00 00 00 41 89 C4 E8 ?? ?? ?? ?? 85 C0 0F 88 CB 00 00 00 8B 85 58 FF FF FF 25 00 F0 00 00 3D 00 40 00 00 0F 84 72 01 00 00 48 8B 05 ?? ?? ?? ?? 48 8B B5 70 FF FF FF 45 31 C9 31 FF 45 89 E0 B9 02 00 00 00 BA 01 00 00 00 64 8B 00 89 85 3C FF FF FF E8 ?? ?? ?? ?? 48 83 F8 FF 49 89 C7 0F 84 9D 00 00 00 41 BC 01 00 00 00 4C 89 EF B8 03 00 00 00 0F 05 4D 85 FF 74 26 48 8B 95 70 FF FF FF 4C 89 FE 44 89 F7 E8 ?? ?? ?? ?? 48 85 C0 74 5A 48 C7 00 00 00 00 00 44 89 60 18 48 89 43 10 48 8B 5D D8 4C 8B 65 E0 4C 8B 6D E8 4C 8B 75 F0 4C 8B 7D F8 C9 C3 4C 89 FF 48 89 85 30 FF FF FF E8 ?? ?? ?? ?? 48 8B 85 30 FF FF FF 48 85 C0 75 0E 48 8B 05 ?? ?? ?? ?? 64 C7 00 16 00 00 00 49 63 FC B8 03 00 00 00 0F 05 EB B5 41 83 EC 01 75 AF 48 8B B5 70 FF FF FF 4C 89 FF E8 ?? ?? ?? ?? EB 9E 48 8B 15 ?? ?? ?? ?? 64 83 3A 26 0F 85 41 01 00 00 48 8B 8D 70 FF FF FF 48 89 CF 48 89 8D 28 FF FF FF E8 ?? ?? ?? ?? 48 85 C0 49 89 C7 48 8B 8D 28 FF FF FF 0F 84 10 01 00 00 48 85 C9 49 89 C1 7E 40 48 89 CA 4C 89 CE 44 89 E7 48 89 8D 28 FF FF FF 4C 89 8D 30 FF FF FF E8 ?? ?? ?? ?? 48 98 48 8B 8D 28 FF FF FF 4C 8B 8D 30 FF FF FF 48 85 C0 0F 8E 3D FF FF FF 48 29 C1 49 01 C1 48 85 C9 7F C0 8B 95 3C FF FF FF 48 8B 05 ?? ?? ?? ?? 45 31 E4 64 89 10 E9 CF FE FF FF 4C 89 EF 66 B8 03 00 0F 05 48 8B 33 31 C0 48 83 C9 FF 48 89 F7 F2 AE 48 F7 D1 48 8D 51 FF 49 63 CE 44 0F B6 B9 ?? ?? ?? ?? 44 0F B6 A9 ?? ?? ?? ?? 41 0F B6 C7 49 81 C5 ?? ?? ?? ?? 48 8D 44 02 24 48 83 E0 F0 48 29 C4 4C 8D 64 24 0F 49 83 E4 F0 4C 89 E7 E8 ?? ?? ?? ?? 49 8D 57 01 48 8D 78 05 4C 89 EE C7 00 2F 53 59 53 C6 40 04 5F E8 ?? ?? ?? ?? 4C 89 E7 31 C0 BE 00 00 08 00 E8 ?? ?? ?? ?? 85 C0 41 89 C4 0F 88 77 FE FF FF 48 8D 95 40 FF FF FF 89 C6 BF 01 00 00 00 E8 ?? ?? ?? ?? 85 C0 0F 88 9B FE FF FF 4D 63 EC E9 DE FD FF FF 45 31 E4 E9 17 FE FF FF 41 BC 01 00 00 00 45 31 FF E9 09 FE FF FF }
	condition:
		$1
}

rule file_190_2_0 {
	meta:
		name = "_nl_unload_locale"
		size = 87
		refs = "001b free 004e __munmap"
	strings:
		$1 = { 53 48 8B 47 20 48 89 FB 48 85 C0 74 02 FF D0 8B 43 18 85 C0 75 2A 48 8B 7B 08 E8 ?? ?? ?? ?? 8B 43 18 83 F8 02 74 08 48 8B 3B E8 ?? ?? ?? ?? 48 89 DF 5B E9 ?? ?? ?? ?? 0F 1F 84 00 00 00 00 00 83 F8 01 75 DD 48 8B 73 10 48 8B 7B 08 E8 ?? ?? ?? ?? 8B 43 18 EB CB }
	condition:
		$1
}

rule file_191_0_0 {
	meta:
		name = "round_and_return"
		size = 468
		refs = "006e __mpn_rshift 0097 .LC1 0113 __libc_errno 0132 .LC2 0178 __mpn_construct_long_double"
	strings:
		$1 = { 48 89 6C 24 E8 4C 89 64 24 F0 48 89 FD 4C 89 6C 24 F8 48 89 5C 24 E0 48 83 EC 38 81 FE 02 C0 FF FF 41 89 D5 49 89 CC 0F 8C 8B 00 00 00 89 F3 44 89 C1 49 0F A3 CC 73 48 45 85 C9 48 8B 45 00 75 08 A8 01 0F 84 4F 01 00 00 48 8D 50 01 48 39 D0 48 89 55 00 0F 86 E6 00 00 00 B9 01 00 00 00 BA 01 00 00 00 48 89 EE 48 89 EF 83 C3 01 E8 ?? ?? ?? ?? 48 B8 00 00 00 00 00 00 00 80 48 09 45 00 81 FB 00 40 00 00 0F 8E CB 00 00 00 45 85 ED 0F 85 9B 00 00 00 D9 05 ?? ?? ?? ?? 48 8B 5C 24 18 48 8B 6C 24 20 4C 8B 64 24 28 4C 8B 6C 24 30 48 83 C4 38 C3 0F 1F 40 00 B8 02 C0 FF FF 29 F0 48 63 D8 48 83 FB 40 0F 8F B4 00 00 00 BA 01 00 00 00 44 89 C1 48 D3 E2 48 83 EA 01 4C 85 E2 4C 8B 27 0F 95 C2 0F B6 D2 41 09 D1 48 83 FB 40 0F 84 C4 00 00 00 89 C1 BA 01 00 00 00 48 89 FE 44 89 4C 24 08 E8 ?? ?? ?? ?? 44 8B 4C 24 08 8D 4B FF 48 8B 05 ?? ?? ?? ?? BB 01 C0 FF FF 64 C7 00 22 00 00 00 E9 0A FF FF FF 0F 1F 84 00 00 00 00 00 D9 05 ?? ?? ?? ?? E9 60 FF FF FF 0F 1F 44 00 00 81 FB 01 C0 FF FF 0F 85 34 FF FF FF 48 85 D2 B8 02 C0 FF FF 0F 48 D8 44 89 EA 89 DE 48 89 EF 48 8B 5C 24 18 48 8B 6C 24 20 4C 8B 64 24 28 4C 8B 6C 24 30 48 83 C4 38 E9 ?? ?? ?? ?? 0F 1F 40 00 48 8B 05 ?? ?? ?? ?? D9 EE 64 C7 00 22 00 00 00 E9 06 FF FF FF 0F 1F 00 BA 01 00 00 00 48 D3 E2 48 83 EA 01 4C 85 E2 0F 84 D3 FE FF FF E9 97 FE FF FF 66 0F 1F 44 00 00 31 C0 4D 85 E4 48 C7 07 00 00 00 00 0F 95 C0 B9 3F 00 00 00 41 09 C1 E9 3C FF FF FF }
	condition:
		$1
}

rule file_191_2_0 {
	meta:
		name = "____strtold_l_internal"
		size = 6911
		refs = "0042 strlen 0267 _nl_C_locobj 03e1 __correctly_grouped_prefixmb 05b8 _fpioconst_pow10 05e7 __tens 05f4 memcpy 062e __mpn_mul 06c6 __mpn_lshift 0741 __mpn_cmp 08d3 __mpn_submul_1 08f6 __mpn_add_n 0b12 __libc_errno 0ef6 __strncasecmp_l 0f45 .LC1 0f7d .LC3 16dc .LC2 1742 ____strtoull_l_internal"
	strings:
		$1 = { 41 57 49 89 CF 41 56 41 55 41 54 55 53 48 81 EC 08 11 00 00 85 D2 48 8B 41 08 48 89 7C 24 30 48 89 74 24 28 0F 85 2E 1A 00 00 31 C9 48 C7 44 24 38 00 00 00 00 48 8B 68 40 48 89 4C 24 18 48 89 EF E8 ?? ?? ?? ?? 48 8B 5C 24 30 49 8B 57 68 48 8B 4C 24 18 48 89 44 24 40 C7 84 24 8C 00 00 00 00 00 00 00 48 83 EB 01 0F 1F 84 00 00 00 00 00 48 83 C3 01 4C 0F BE 2B 49 0F BE C5 F6 44 42 01 20 75 ED 41 80 FD 2D 48 89 D8 0F 84 FF 02 00 00 41 80 FD 2B C7 44 24 48 00 00 00 00 0F 84 84 03 00 00 0F B6 75 00 40 84 F6 0F 84 04 11 00 00 40 3A 33 0F 85 A0 01 00 00 B8 01 00 00 00 EB 0F 90 48 83 C0 01 3A 54 03 FF 0F 85 8A 01 00 00 0F B6 54 05 00 84 D2 75 E9 0F B6 04 03 3C 2F 0F 8E 75 01 00 00 3C 39 0F 8F 6D 01 00 00 41 80 FD 30 49 8B 7F 70 0F 84 BB 09 00 00 45 31 D2 48 83 7C 24 38 00 41 0F 94 C2 0F 85 21 18 00 00 49 89 DB 41 BE 0A 00 00 00 49 0F BE C5 8B 14 87 41 8D 45 D0 3C 09 76 54 41 83 FE 10 41 89 D0 41 0F 95 C4 80 FA 60 0F 8F B0 09 00 00 40 84 F6 74 29 40 3A 33 0F 85 5F 02 00 00 31 C0 EB 13 66 0F 1F 44 00 00 48 83 C0 01 3A 14 03 0F 85 48 02 00 00 0F B6 54 05 01 84 D2 75 EA 49 39 DB 75 0D 41 83 FE 10 0F 84 E4 09 00 00 0F 1F 00 49 89 DC 45 31 C0 41 8D 45 D0 3C 09 0F 86 36 01 00 00 41 83 FE 10 0F 84 19 01 00 00 4D 85 D2 0F 84 FF 17 00 00 48 85 C9 0F 85 43 18 00 00 41 83 F8 01 19 D2 40 84 F6 74 26 31 C0 41 38 34 24 74 15 E9 15 01 00 00 66 90 48 83 C0 01 41 3A 0C 04 0F 85 05 01 00 00 0F B6 4C 05 01 84 C9 75 E9 4C 8B 54 24 40 45 89 C5 4D 01 E2 49 0F BE 02 4D 89 D4 EB 3B 0F 1F 44 00 00 48 0F BE C8 8B 0C 8F 8D 71 9F 40 80 FE 05 0F 87 D6 00 00 00 83 FA FF 75 10 3C 30 44 89 E0 0F 95 C1 44 29 D0 84 C9 0F 45 D0 49 83 C4 01 49 0F BE 04 24 41 83 C5 01 8D 48 D0 80 F9 09 76 D6 41 83 FE 10 74 BC 0F B6 0C 87 4C 89 E6 31 FF 80 F9 65 0F 85 F1 01 00 00 41 83 FE 10 0F 84 E7 01 00 00 E9 A4 00 00 00 0F 1F 00 41 8D 45 D0 3C 09 0F 86 87 FE FF FF 48 8B 05 ?? ?? ?? ?? 42 0F B6 04 A8 3C 69 0F 84 6B 0C 00 00 3C 6E 0F 84 CE 0C 00 00 48 83 7C 24 28 00 0F 84 93 01 00 00 48 8B 44 24 30 4C 8B 4C 24 28 D9 EE 49 89 01 48 81 C4 08 11 00 00 5B 5D 41 5C 41 5D 41 5E 41 5F C3 49 0F BE C5 8B 04 87 83 E8 61 3C 05 0F 87 D5 FE FF FF 90 41 83 C0 01 4D 0F BE 6C 24 01 49 83 C4 01 E9 AB FE FF FF 42 8B 0C AF 45 89 C5 41 83 FE 10 40 0F 94 C7 80 F9 70 0F 85 43 08 00 00 40 84 FF 0F 84 3A 08 00 00 BF 01 00 00 00 41 0F BE 4C 24 01 80 F9 2D 0F 84 7A 08 00 00 45 31 C9 80 F9 2B 49 8D 74 24 01 0F 84 B0 0A 00 00 8D 41 D0 3C 09 0F 87 10 01 00 00 40 84 FF 0F 85 09 08 00 00 45 85 C9 45 8D 98 83 13 00 00 75 0D 41 89 D3 45 29 C3 41 81 C3 45 13 00 00 8B 84 24 8C 00 00 00 0F 1F 00 8D 04 80 8D 44 41 D0 44 39 D8 89 84 24 8C 00 00 00 0F 8F 0F 15 00 00 48 83 C6 01 0F BE 0E 44 8D 51 D0 41 80 FA 09 76 D8 45 85 C9 0F 84 B6 00 00 00 F7 D8 89 84 24 8C 00 00 00 E9 A8 00 00 00 48 83 C3 01 4C 0F BE 68 01 C7 44 24 48 01 00 00 00 E9 FD FC FF FF 45 84 E4 0F 84 70 12 00 00 41 83 FE 10 41 0F 94 C1 41 80 F8 65 75 0F 45 31 C0 45 84 C9 49 89 DC 0F 84 B3 FD FF FF 48 8B 54 24 38 4C 89 DF 48 89 DE 44 88 4C 24 18 4C 89 5C 24 10 E8 ?? ?? ?? ?? 48 83 7C 24 28 00 44 0F B6 4C 24 18 4C 8B 5C 24 10 74 1B 49 39 C3 0F 84 EA 13 00 00 48 89 44 24 30 48 8B 6C 24 30 48 8B 4C 24 28 48 89 29 8B 5C 24 48 85 DB 0F 85 06 07 00 00 D9 EE E9 75 FE FF FF 48 83 C3 01 4C 0F BE 68 01 E9 6E FC FF FF 4C 89 E6 45 39 C5 0F 8F D8 05 00 00 45 85 ED 7E 0B 45 39 E8 0F 84 D7 05 00 00 66 90 48 83 7C 24 28 00 74 08 4C 8B 4C 24 28 49 89 31 45 85 ED 74 AE 85 D2 0F 84 92 06 00 00 0F B6 7D 00 0F B6 33 44 0F B6 4D 01 EB 0D 0F 1F 44 00 00 0F B6 73 01 48 83 C3 01 40 38 F7 75 F3 45 84 C9 74 21 0F B6 73 01 44 38 CE 75 E9 31 C0 EB 0B 90 48 83 C0 01 3A 4C 03 01 75 DA 0F B6 4C 05 02 84 C9 75 ED 48 63 C2 48 03 44 24 40 8B B4 24 8C 00 00 00 48 01 C3 8D 04 95 00 00 00 00 41 83 FE 10 0F 45 C2 41 29 D5 29 C6 89 B4 24 8C 00 00 00 41 83 FE 10 0F 84 F0 08 00 00 85 F6 0F 88 A9 0A 00 00 44 89 E8 44 29 C0 39 F0 0F 4F C6 41 01 C0 29 C6 44 89 C0 44 89 44 24 4C 89 B4 24 8C 00 00 00 01 F0 3D 45 13 00 00 0F 8F A3 11 00 00 81 FE AA EC FF FF 0F 8C E2 05 00 00 8B 4C 24 4C 85 C9 0F 8F 71 06 00 00 48 8D 8C 24 90 00 00 00 4C 8D 84 24 8C 00 00 00 B8 18 00 00 00 BA 16 00 00 00 31 ED 48 89 4C 24 50 4C 89 44 24 60 48 8D 8C 24 A0 00 00 00 4C 8D 84 24 C0 00 00 00 48 89 4C 24 68 4C 89 44 24 28 44 2B 6C 24 4C C6 44 24 70 00 41 39 C5 44 89 6C 24 4C 7E 0C 83 C2 02 C6 44 24 70 01 89 54 24 4C 44 8B 7C 24 4C 4C 8B 54 24 28 4C 8D 8C 24 E0 08 00 00 45 31 E4 89 6C 24 74 48 89 5C 24 78 4C 89 E5 41 BE ?? ?? ?? ?? 4C 89 4C 24 30 41 29 F7 41 BD 01 00 00 00 4C 89 D3 45 89 FC 4D 89 CF EB 2F 49 8B 6E 08 49 8B 06 4C 89 FF 48 83 ED 01 48 8D 34 C5 ?? ?? ?? ?? 48 8D 14 ED 00 00 00 00 E8 ?? ?? ?? ?? 45 01 ED 49 83 C6 18 45 85 E4 74 59 45 85 EC 74 EF 45 31 EC 48 85 ED 74 C4 49 8B 06 49 8B 56 08 49 89 E8 4C 89 F9 48 89 DF 48 8D 34 C5 ?? ?? ?? ?? 48 83 EA 01 E8 ?? ?? ?? ?? 49 8B 56 08 48 85 C0 48 8D 6C 15 FF 0F 85 54 05 00 00 4C 89 F8 48 83 ED 01 45 01 ED 49 83 C6 18 45 85 E4 49 89 DF 48 89 C3 75 A7 4C 3B 7C 24 28 49 89 EC 48 8B 5C 24 78 8B 6C 24 74 0F 84 30 11 00 00 48 8B 54 24 38 4C 8B 44 24 60 48 89 DF 4C 8B 4C 24 40 48 8B 4C 24 68 8B 74 24 4C 48 89 14 24 48 8B 54 24 28 E8 13 F7 FF FF 4D 8D 44 24 FF 4A 0F BD 9C C4 E0 08 00 00 4C 89 44 24 38 48 83 F3 3F 85 DB 7E 32 48 8B 74 24 30 89 D9 4C 89 E2 48 89 F7 E8 ?? ?? ?? ?? 48 8B 74 24 28 48 8B 94 24 A0 00 00 00 89 D9 48 89 F7 E8 ?? ?? ?? ?? 48 85 C0 0F 85 1C 09 00 00 49 83 FC 01 89 AC 24 8C 00 00 00 0F 84 FC 0C 00 00 49 83 FC 02 0F 84 B5 0A 00 00 4C 8B 44 24 38 48 8B 94 24 A0 00 00 00 4D 8D 6C 24 FE 4C 8B 4C 24 30 4C 89 E0 48 8B 7C 24 28 4E 8B BC C4 E0 08 00 00 48 29 D0 4E 8B 84 EC E0 08 00 00 49 8D 34 C1 4C 89 44 24 18 E8 ?? ?? ?? ?? 85 C0 4C 8B 44 24 18 48 8B 84 24 A0 00 00 00 7E 18 48 C7 84 C4 C0 00 00 00 00 00 00 00 48 83 C0 01 48 89 84 24 A0 00 00 00 4C 39 E0 0F 8D 46 0E 00 00 4C 89 E3 48 29 C3 85 ED 0F 8E 4D 10 00 00 48 89 DA 48 63 CD 48 C1 E2 06 48 01 CA 48 83 FA 40 0F 8F CC 0F 00 00 48 C7 84 24 90 00 00 00 00 00 00 00 C7 44 24 4C 00 00 00 00 89 DA C1 E2 06 01 D5 85 C0 48 63 D0 7E 2D 48 8B 4C 24 28 48 01 DA 83 E8 01 48 8D 14 D1 0F 1F 00 48 63 C8 83 E8 01 48 83 EA 08 48 8B 8C CC C0 00 00 00 48 89 4A 08 83 F8 FF 75 E5 48 85 DB 78 2B 48 8B 54 24 28 48 89 D0 48 83 C0 08 48 8D 0C D8 EB 0A 66 0F 1F 44 00 00 48 83 C0 08 48 39 C8 48 C7 02 00 00 00 00 48 89 C2 75 ED 83 FD 40 4A C7 84 E4 E0 08 00 00 00 00 00 00 4A 8B B4 E4 C0 00 00 00 0F 8F DE 0F 00 00 4D 8D 4C 24 01 41 8D 5C 24 01 4C 89 E8 89 6C 24 40 4D 89 FD 4C 89 C5 4C 89 4C 24 60 45 8D 4C 24 FF 44 29 E3 49 89 C7 44 89 4C 24 68 4C 39 EE 49 C7 C6 FF FF FF FF 74 50 4C 8B 44 24 38 48 89 F2 4E 8B 84 C4 C0 00 00 00 4C 89 C0 49 F7 F5 49 89 C6 48 89 D6 48 89 E8 49 F7 E6 EB 12 0F 1F 40 00 31 C9 48 39 E8 0F 92 C1 48 29 E8 48 29 CA 48 39 F2 77 0C 75 13 4A 3B 84 FC C0 00 00 00 76 09 49 83 EE 01 4C 01 EE 73 D8 48 8B 54 24 60 48 8B 74 24 30 4C 89 F1 48 8B 7C 24 28 E8 ?? ?? ?? ?? 4A 39 84 E4 C0 00 00 00 74 19 48 8B 74 24 28 48 8B 54 24 30 4C 89 E1 49 83 EE 01 48 89 F7 E8 ?? ?? ?? ?? 4C 8B 44 24 38 8B 44 24 68 4A 8B B4 C4 C0 00 00 00 85 C0 4A 89 B4 E4 C0 00 00 00 7E 29 41 8D 44 24 FE 0F 1F 40 00 48 63 D0 85 C0 48 8B 8C D4 C0 00 00 00 8D 14 03 8D 40 FF 48 63 D2 48 89 8C D4 C0 00 00 00 7F E0 83 7C 24 40 00 48 C7 84 24 C0 00 00 00 00 00 00 00 0F 85 7F 07 00 00 4D 85 F6 0F 84 C8 07 00 00 49 0F BD CE 8B BC 24 8C 00 00 00 B8 40 00 00 00 83 F1 3F 29 C8 29 CF 83 F8 40 89 BC 24 8C 00 00 00 0F 8E 9D 0F 00 00 44 8D 49 40 4C 89 F0 F7 D9 48 D3 E8 44 89 4C 24 4C 48 89 84 24 90 00 00 00 49 63 D4 44 89 E0 48 83 BC D4 C0 00 00 00 00 75 25 45 85 E4 78 20 44 89 E1 44 29 E1 83 E9 01 EB 04 39 C8 74 11 83 E8 01 48 63 D0 48 83 BC D4 C0 00 00 00 00 74 EB F7 D0 41 B8 3F 00 00 00 44 2B 44 24 4C C1 E8 1F 0A 44 24 70 8D 77 FF 8B 54 24 48 48 8B 7C 24 50 4C 89 F1 4D 63 C0 41 89 C1 41 83 E1 01 E8 C8 F1 FF FF E9 8E F8 FF FF 0F 1F 00 49 83 EC 01 41 83 ED 01 41 80 7C 24 FF 30 74 F0 E9 1B FA FF FF 44 8B 8C 24 8C 00 00 00 49 8D 44 24 FF 45 85 C9 0F 89 15 FA FF FF EB 59 0F 1F 00 0F BE 08 83 E9 30 83 F9 09 0F 97 C1 84 C9 75 42 80 38 30 0F 85 F7 F9 FF FF 44 8B 8C 24 8C 00 00 00 41 83 ED 01 41 83 E8 01 40 80 FF 01 19 C9 83 E1 FD 42 8D 4C 09 04 89 8C 24 8C 00 00 00 C1 E9 1F 84 C9 0F 84 C7 F9 FF FF 45 85 ED 0F 8E BE F9 FF FF 48 83 E8 01 40 84 FF 74 A5 4C 0F BE 08 49 8B 4F 68 42 0F B7 0C 49 66 C1 E9 0C 83 F1 01 83 E1 01 EB 98 48 0F BE 43 01 83 3C 87 78 0F 84 97 06 00 00 45 31 D2 48 83 7C 24 38 00 41 0F 94 C2 0F 85 57 0E 00 00 49 89 DB 41 BE 0A 00 00 00 E9 A0 06 00 00 0F 1F 40 00 45 84 E4 0F 85 47 F6 FF FF 80 FA 66 0F 8E 7E F6 FF FF E9 39 F6 FF FF 8B B4 24 8C 00 00 00 E9 D4 F9 FF FF 8B 74 24 48 48 8B 05 ?? ?? ?? ?? 85 F6 64 C7 00 22 00 00 00 0F 84 FA F8 FF FF D9 EE D9 E0 E9 6D F7 FF FF 4C 89 E6 E9 07 F7 FF FF 45 85 C9 46 8D 1C 85 3D 40 00 00 0F 85 FF F7 FF FF 89 D0 44 29 C0 44 8D 1C 85 03 40 00 00 E9 ED F7 FF FF 48 8B 54 24 40 48 0F BE 04 13 8D 50 D0 80 FA 09 0F 86 09 F6 FF FF 8B 04 87 83 E8 61 3C 05 0F 86 FB F5 FF FF E9 2C F8 FF FF 49 8D 74 24 02 41 0F BE 4C 24 02 41 B9 01 00 00 00 E9 81 F7 FF FF 4C 89 F8 49 89 DF 48 89 C3 E9 52 FA FF FF 48 8D AC 24 8C 00 00 00 48 8B 54 24 38 4C 8B 4C 24 40 8B 74 24 4C 48 8D 8C 24 A0 00 00 00 48 89 DF 48 89 6C 24 60 48 8D AC 24 C0 00 00 00 4C 8B 44 24 60 48 89 14 24 48 89 4C 24 68 48 89 EA 48 89 6C 24 28 E8 C1 F1 FF FF 48 89 C3 8B 84 24 8C 00 00 00 4C 8B A4 24 A0 00 00 00 85 C0 0F 8E E7 00 00 00 4C 8B 4C 24 28 48 8D 8C 24 E0 08 00 00 48 89 5C 24 58 44 89 6C 24 70 41 BE ?? ?? ?? ?? BD 01 00 00 00 48 89 4C 24 30 49 89 CD 4C 89 CB EB 57 48 8D 0C C5 ?? ?? ?? ?? 4D 89 F8 4C 89 E2 48 89 DE 4C 89 EF E8 ?? ?? ?? ?? 4D 89 FC 4C 03 A4 24 A0 00 00 00 48 85 C0 4C 89 A4 24 A0 00 00 00 75 0C 49 83 EC 01 4C 89 A4 24 A0 00 00 00 8B 84 24 8C 00 00 00 48 89 DA 4C 89 EB 49 89 D5 01 ED 49 83 C6 18 85 C0 74 38 85 E8 74 F2 4D 8B 7E 08 31 E8 89 84 24 8C 00 00 00 49 8B 06 49 83 EF 01 4D 39 E7 7E 8C 48 8D 34 C5 ?? ?? ?? ?? 4D 89 E0 48 89 D9 4C 89 FA 4C 89 EF E8 ?? ?? ?? ?? EB 8A 49 89 D9 4C 3B 4C 24 30 44 8B 6C 24 70 48 8B 5C 24 58 75 15 48 8B 7C 24 28 4A 8D 14 E5 00 00 00 00 4C 89 CE E8 ?? ?? ?? ?? 4D 8D 4C 24 FF 44 89 E6 C1 E6 06 4A 0F BD 84 CC C0 00 00 00 83 F0 3F 29 C6 81 FE 00 40 00 00 89 F5 0F 8F A9 09 00 00 83 FE 40 0F 8E 89 02 00 00 44 8D 56 C0 44 89 D7 41 83 E2 3F 4D 63 C2 C1 FF 06 4D 85 C0 48 63 C7 0F 84 EA 02 00 00 49 83 E8 01 49 39 C1 48 8B 94 C4 C0 00 00 00 0F 8F F6 08 00 00 44 89 D1 48 D3 EA 48 89 C1 48 89 94 24 90 00 00 00 48 83 BC 24 C0 00 00 00 00 0F 85 6F 0D 00 00 48 8B 44 24 28 31 D2 48 83 C0 08 0F 1F 00 48 83 C0 08 83 C2 01 48 83 78 F8 00 74 F2 44 3B 6C 24 4C 41 B9 01 00 00 00 7F 0D 48 63 D2 45 31 C9 48 39 CA 41 0F 9C C1 48 8B 8C CC C0 00 00 00 8B 54 24 48 48 8D BC 24 90 00 00 00 83 EE 01 E8 0C EE FF FF E9 D2 F4 FF FF 49 8D 74 24 02 41 0F BE 4C 24 02 E9 40 F5 FF FF 48 0F BE 03 4D 8B 4F 68 48 0F BE D0 41 F6 44 51 01 10 75 2B 0F 1F 00 48 83 C3 01 48 0F BE 03 48 0F BE D0 41 F6 44 51 01 10 74 EC EB 12 66 2E 0F 1F 84 00 00 00 00 00 48 83 C3 01 48 0F BE 03 3C 30 74 F4 0F BE D0 83 EA 30 83 FA 09 0F 86 CF 01 00 00 49 8B 57 70 48 83 C3 01 8B 04 82 83 E8 57 48 98 8B 14 85 ?? ?? ?? ?? 48 89 C7 B9 40 00 00 00 B8 3F 00 00 00 41 83 ED 01 29 D1 29 D0 42 8D 54 82 FB 48 D3 E7 01 D6 45 85 ED 48 89 BC 24 90 00 00 00 89 B4 24 8C 00 00 00 0F 8E 9F 06 00 00 4C 8B 44 24 40 EB 2E 48 63 D1 48 83 C3 01 83 F8 02 0F 8E A6 06 00 00 8D 48 FD 83 E8 04 48 D3 E2 48 09 D7 41 83 ED 01 48 89 BC 24 90 00 00 00 0F 84 6A 06 00 00 48 0F BE 13 48 0F BE CA 41 F6 44 49 01 10 75 07 4C 01 C3 48 0F BE 13 0F BE CA 83 E9 30 83 F9 09 76 B0 49 8B 4F 70 48 83 C3 01 8B 14 91 83 EA 57 48 63 D2 EB A4 B9 ?? ?? ?? ?? BA 03 00 00 00 BE ?? ?? ?? ?? 48 89 DF E8 ?? ?? ?? ?? 85 C0 0F 85 7E F3 FF FF 48 83 7C 24 28 00 74 2D 48 8D 6B 03 B9 ?? ?? ?? ?? BA 05 00 00 00 BE ?? ?? ?? ?? 48 83 C3 08 48 89 EF E8 ?? ?? ?? ?? 48 8B 4C 24 28 85 C0 48 0F 44 EB 48 89 29 8B 6C 24 48 85 ED 0F 85 97 07 00 00 D9 05 ?? ?? ?? ?? E9 4D F3 FF FF B9 ?? ?? ?? ?? BA 03 00 00 00 BE ?? ?? ?? ?? 48 89 DF E8 ?? ?? ?? ?? 85 C0 0F 85 13 F3 FF FF 80 7B 03 28 48 8D 73 03 0F 84 72 07 00 00 D9 05 ?? ?? ?? ?? 48 83 7C 24 28 00 0F 84 0E F3 FF FF 4C 8B 44 24 28 49 89 30 E9 01 F3 FF FF 44 89 C0 F7 D8 39 C6 0F 4D C6 E9 53 F5 FF FF 44 3B 6C 24 4C 0F 84 8F 00 00 00 4C 8D 84 24 90 00 00 00 48 8B 74 24 28 4A 8D 14 E5 00 00 00 00 4C 89 C7 4C 89 44 24 50 E8 ?? ?? ?? ?? B9 42 00 00 00 BA 56 55 55 55 8B B4 24 8C 00 00 00 29 E9 89 C8 C1 F9 1F F7 EA 29 CA 8D 42 02 E9 7B F5 FF FF 48 63 C2 48 83 C3 }
	condition:
		$1
}

rule file_192_0_0 {
	meta:
		name = "getutmp"
		size = 165
	strings:
		$1 = { 48 89 F0 BA 80 01 00 00 48 89 FE A8 01 75 49 A8 02 75 5D A8 04 75 79 89 D1 48 89 C7 C1 E9 03 F6 C2 04 F3 48 A5 48 89 F8 74 09 8B 0E 89 0F B9 04 00 00 00 F6 C2 02 74 0C 0F B7 3C 0E 66 89 3C 08 48 83 C1 02 83 E2 01 74 07 0F B6 14 0E 88 14 08 F3 C3 66 0F 1F 44 00 00 0F B6 17 48 83 C0 01 48 83 C6 01 88 50 FF A8 02 BA 7F 01 00 00 74 A4 90 0F B7 0E 48 83 C0 02 48 83 C6 02 83 EA 02 66 89 48 FE A8 04 74 91 66 2E 0F 1F 84 00 00 00 00 00 8B 0E 48 83 C0 04 48 83 C6 04 83 EA 04 89 48 FC E9 72 FF FF FF }
	condition:
		$1
}

rule file_193_0_0 {
	meta:
		name = "__sysv_signal"
		size = 130
		refs = "0012 __libc_errno 0062 __sigaction"
	strings:
		$1 = { 48 83 FE FF 74 09 85 FF 7E 05 83 FF 40 7E 19 48 8B 05 ?? ?? ?? ?? 64 C7 00 16 00 00 00 48 C7 C0 FF FF FF FF C3 0F 1F 00 48 81 EC 48 01 00 00 41 89 F8 31 C0 48 8D 54 24 08 B9 10 00 00 00 48 89 34 24 48 89 E6 C7 84 24 88 00 00 00 00 00 00 E0 48 89 D7 48 8D 94 24 A0 00 00 00 F3 48 AB 44 89 C7 E8 ?? ?? ?? ?? 89 C2 48 C7 C0 FF FF FF FF 85 D2 48 0F 49 84 24 A0 00 00 00 48 81 C4 48 01 00 00 C3 }
	condition:
		$1
}

rule file_195_0_0 {
	meta:
		name = "__getsockopt"
		size = 23
		refs = "0012 __syscall_error"
	strings:
		$1 = { 49 89 CA B8 37 00 00 00 0F 05 48 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_196_0_0 {
	meta:
		name = "posix_spawnattr_setschedpolicy"
		size = 25
	strings:
		$1 = { 83 FE 02 B8 16 00 00 00 76 06 F3 C3 0F 1F 40 00 89 B7 0C 01 00 00 30 C0 C3 }
	condition:
		$1
}

rule file_198_0_0 {
	meta:
		name = "erand48"
		size = 30
		refs = "0005 __libc_drand48_data 000f __erand48_r"
	strings:
		$1 = { 48 83 EC 18 BE ?? ?? ?? ?? 48 8D 54 24 08 E8 ?? ?? ?? ?? F2 0F 10 44 24 08 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_201_0_0 {
	meta:
		name = "_IO_obstack_xsputn"
		size = 214
		refs = "0061 memcpy 00b7 _obstack_newchunk 00cc mempcpy"
	strings:
		$1 = { 48 89 5C 24 D8 48 89 6C 24 E0 48 89 FD 4C 89 64 24 E8 4C 89 6C 24 F0 49 89 D4 4C 89 74 24 F8 48 83 EC 28 48 8B 9F E0 00 00 00 48 8B 7F 28 48 8B 45 30 48 8D 14 17 48 39 D0 0F 83 89 00 00 00 48 29 C7 48 03 7B 18 4D 63 EC 49 89 F6 4A 8D 04 2F 48 39 43 20 48 89 7B 18 72 56 4C 89 EA 4C 89 F6 E8 ?? ?? ?? ?? 48 8B 43 10 4C 03 6B 18 48 89 45 20 48 8B 43 20 4C 89 6D 28 4C 29 E8 48 98 49 01 C5 4C 89 6D 30 4C 89 6B 18 4C 89 E0 48 8B 1C 24 48 8B 6C 24 08 4C 8B 64 24 10 4C 8B 6C 24 18 4C 8B 74 24 20 48 83 C4 28 C3 0F 1F 80 00 00 00 00 48 89 DF 44 89 E6 E8 ?? ?? ?? ?? 48 8B 7B 18 EB 99 0F 1F 80 00 00 00 00 4C 89 E2 E8 ?? ?? ?? ?? 48 89 45 28 EB B3 }
	condition:
		$1
}

rule file_201_1_0 {
	meta:
		name = "_IO_obstack_overflow"
		size = 154
		refs = "003c _obstack_newchunk 0096 __assert_fail"
	strings:
		$1 = { 48 89 5C 24 E8 48 89 6C 24 F0 4C 89 64 24 F8 48 83 EC 18 83 FE FF 48 8B 9F E0 00 00 00 74 62 48 8B 43 18 48 89 FD 41 89 F4 48 8D 50 01 48 3B 53 20 76 15 BE 01 00 00 00 48 89 DF E8 ?? ?? ?? ?? 48 8B 43 18 48 8D 50 01 44 88 20 48 8B 43 10 48 89 55 28 48 89 45 20 48 8B 43 20 48 29 D0 48 98 48 01 C2 44 89 E0 4C 8B 64 24 10 48 89 55 30 48 89 53 18 48 8B 6C 24 08 48 8B 1C 24 48 83 C4 18 C3 B9 ?? ?? ?? ?? BA 2F 00 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_201_2_0 {
	meta:
		name = "_IO_obstack_vprintf"
		size = 408
		refs = "0048 _IO_no_init 0060 _IO_obstack_jumps 0098 _IO_str_init_static_internal 00e5 _IO_vfprintf 0139 _obstack_newchunk 0162 __assert_fail"
	strings:
		$1 = { 48 89 5C 24 D8 48 89 6C 24 E0 48 89 FB 4C 89 64 24 E8 4C 89 6C 24 F0 31 C9 4C 89 74 24 F8 48 81 EC 18 01 00 00 45 31 C0 48 89 F5 49 89 D4 BE 00 80 00 00 BA FF FF FF FF 48 89 E7 48 C7 84 24 88 00 00 00 00 00 00 00 E8 ?? ?? ?? ?? 48 8B 4B 18 48 8B 43 20 48 8B 73 10 48 C7 84 24 D8 00 00 00 ?? ?? ?? ?? 48 89 CA 48 29 C8 48 29 F2 41 89 C5 01 C2 75 1A 48 83 F8 3F 0F 8E B2 00 00 00 45 85 ED 0F 84 F8 00 00 00 48 8B 73 10 44 89 EA 4C 63 F2 48 89 E7 4C 89 F2 E8 ?? ?? ?? ?? 48 8B 54 24 20 48 8B 44 24 30 48 29 D0 49 39 C6 0F 85 B4 00 00 00 48 8B 43 18 89 C1 2B 4B 10 48 01 CA 48 39 54 24 28 0F 85 84 00 00 00 4D 63 ED 4C 89 E2 48 89 EE 4C 01 E8 48 89 E7 48 89 9C 24 E0 00 00 00 48 89 43 18 E8 ?? ?? ?? ?? 48 8B 54 24 28 48 2B 54 24 30 48 01 53 18 48 8B AC 24 F8 00 00 00 48 8B 9C 24 F0 00 00 00 4C 8B A4 24 00 01 00 00 4C 8B AC 24 08 01 00 00 4C 8B B4 24 10 01 00 00 48 81 C4 18 01 00 00 C3 66 0F 1F 84 00 00 00 00 00 BE 40 00 00 00 48 89 DF E8 ?? ?? ?? ?? 48 8B 4B 18 44 8B 6B 20 41 29 CD E9 31 FF FF FF B9 ?? ?? ?? ?? BA A2 00 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? B9 ?? ?? ?? ?? BA 9F 00 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? B9 ?? ?? ?? ?? BA 97 00 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_202_0_0 {
	meta:
		name = "skip"
		size = 238
	strings:
		$1 = { 0F B6 0F 48 89 F8 48 89 FE 0F BE D1 85 D2 74 5E 31 FF EB 40 0F 1F 40 00 83 FF 01 74 5B 44 0F B6 00 48 83 C6 01 44 88 46 FF 83 FA 23 0F 84 AE 00 00 00 83 FA 20 74 71 83 FA 09 74 6C 83 FA 0A 90 74 66 48 89 C2 0F B6 4A 01 48 8D 42 01 0F BE D1 85 D2 74 1A 83 FA 22 75 BF 48 89 C2 83 F7 01 0F B6 4A 01 48 8D 42 01 0F BE D1 85 D2 75 E6 C6 46 FF 00 C3 0F 1F 44 00 00 80 F9 5C 74 13 0F B6 08 48 89 C2 88 0E 48 83 C6 01 EB BA 0F 1F 44 00 00 80 78 01 22 75 E7 48 8D 50 01 B9 22 00 00 00 EB E2 0F 1F 80 00 00 00 00 C6 00 00 88 0D ?? ?? ?? ?? 48 83 C0 01 EB 0D 66 0F 1F 84 00 00 00 00 00 48 83 C0 01 0F BE 10 83 FA 09 74 F4 83 FA 0A 74 EF 83 FA 20 74 EA EB 96 0F 1F 84 00 00 00 00 00 C6 00 00 88 0D ?? ?? ?? ?? C6 46 FF 00 C3 }
	condition:
		$1
}

rule file_202_1_0 {
	meta:
		name = "setttyent"
		size = 84
		refs = "0011 rewind 002b _IO_new_fopen"
	strings:
		$1 = { 48 83 EC 08 48 8B 3D ?? ?? ?? ?? 48 85 FF 74 10 E8 ?? ?? ?? ?? B8 01 00 00 00 48 83 C4 08 C3 90 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 85 C0 48 89 05 ?? ?? ?? ?? 74 15 81 08 00 80 00 00 B8 01 00 00 00 48 83 C4 08 C3 0F 1F 44 00 00 31 C0 EB C6 }
	condition:
		$1
}

rule file_202_2_0 {
	meta:
		name = "getttyent"
		size = 756
		refs = "002b fgets_unlocked 0043 strchr 004f __libc_tsd_CTYPE_B 00cb __uflow 00e1 setttyent"
	strings:
		$1 = { 41 55 41 54 55 53 48 83 EC 08 48 8B 15 ?? ?? ?? ?? 48 85 D2 0F 84 C6 00 00 00 66 0F 1F 44 00 00 BE 64 00 00 00 BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 85 C0 0F 84 B1 00 00 00 BE 0A 00 00 00 BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 85 C0 74 44 48 8B 2D ?? ?? ?? ?? 0F B6 05 ?? ?? ?? ?? BF ?? ?? ?? ?? 64 48 8B 4D 00 48 0F BE D0 F6 44 51 01 20 74 13 90 48 83 C7 01 0F B6 07 48 0F BE D0 F6 44 51 01 20 75 EE 3C 23 75 70 48 8B 15 ?? ?? ?? ?? EB 91 90 48 8B 15 ?? ?? ?? ?? EB 24 0F 1F 80 00 00 00 00 0F B6 01 48 83 C1 01 48 89 4A 08 83 F8 0A 0F 84 6C FF FF FF 83 F8 FF 0F 84 63 FF FF FF 48 8B 4A 08 48 3B 4A 10 72 D9 48 89 D7 E8 ?? ?? ?? ?? 48 8B 15 ?? ?? ?? ?? EB D3 0F 1F 84 00 00 00 00 00 E8 ?? ?? ?? ?? 85 C0 75 9D 31 C0 48 83 C4 08 5B 5D 41 5C 41 5D C3 84 C0 74 8C C6 05 ?? ?? ?? ?? 00 48 89 3D ?? ?? ?? ?? E8 A3 FD FF FF 48 89 05 ?? ?? ?? ?? 80 38 00 48 89 C3 0F 85 93 01 00 00 48 C7 05 ?? ?? ?? ?? 00 00 00 00 48 C7 05 ?? ?? ?? ?? 00 00 00 00 C7 05 ?? ?? ?? ?? 00 00 00 00 48 C7 05 ?? ?? ?? ?? 00 00 00 00 44 0F B6 03 45 84 C0 0F 84 3B 01 00 00 41 BD ?? ?? ?? ?? 41 BC 03 00 00 00 EB 3A 66 2E 0F 1F 84 00 00 00 00 00 48 0F BE 53 03 64 48 8B 45 00 F6 44 50 01 20 74 2C 83 25 ?? ?? ?? ?? FE 48 89 DF E8 20 FD FF FF 44 0F B6 00 48 89 C3 45 84 C0 0F 84 F3 00 00 00 48 89 DE 4C 89 EF 4C 89 E1 F3 A6 74 C3 BF ?? ?? ?? ?? B9 02 00 00 00 48 89 DE F3 A6 75 22 48 0F BE 53 02 64 48 8B 45 00 F6 44 50 01 20 74 11 83 0D ?? ?? ?? ?? 01 EB B0 0F 1F 84 00 00 00 00 00 BF ?? ?? ?? ?? B9 06 00 00 00 48 89 DE F3 A6 75 1F 48 0F BE 53 06 64 48 8B 45 00 F6 44 50 01 20 74 0E 83 0D ?? ?? ?? ?? 02 E9 7A FF FF FF 66 90 BF ?? ?? ?? ?? B9 06 00 00 00 48 89 DE F3 A6 75 27 80 7B 06 3D 75 21 BE 3D 00 00 00 48 89 DF E8 ?? ?? ?? ?? 48 83 F8 01 48 83 D8 FF 48 89 05 ?? ?? ?? ?? E9 40 FF FF FF 80 3D ?? ?? ?? ?? 23 74 4F 41 80 F8 23 74 49 48 89 1D ?? ?? ?? ?? 80 3B 00 75 0B 48 C7 05 ?? ?? ?? ?? 00 00 00 00 BE 0A 00 00 00 48 89 DF E8 ?? ?? ?? ?? 48 85 C0 74 5A C6 00 00 48 83 C4 08 B8 ?? ?? ?? ?? 5B 5D 41 5C 41 5D C3 80 3D ?? ?? ?? ?? 23 75 BB 0F 1F 40 00 48 83 C3 01 0F BE 03 83 F8 20 74 F4 83 F8 09 74 EF EB A4 48 89 C7 E8 F5 FB FF FF 48 89 05 ?? ?? ?? ?? 80 38 00 48 89 C3 75 1A 48 C7 05 ?? ?? ?? ?? 00 00 00 00 E9 5C FE FF FF B8 ?? ?? ?? ?? E9 07 FE FF FF 48 89 C7 E8 C4 FB FF FF 48 89 C3 E9 42 FE FF FF }
	condition:
		$1
}

rule file_202_3_0 {
	meta:
		name = "endttyent"
		size = 52
		refs = "0016 _IO_new_fclose"
	strings:
		$1 = { 48 8B 3D ?? ?? ?? ?? B8 01 00 00 00 48 85 FF 74 21 48 83 EC 08 E8 ?? ?? ?? ?? 83 F8 FF 48 C7 05 ?? ?? ?? ?? 00 00 00 00 0F 95 C0 48 83 C4 08 0F B6 C0 F3 C3 }
	condition:
		$1
}

rule file_202_4_0 {
	meta:
		name = "getttynam"
		size = 59
		refs = "000a setttyent 0017 strcmp 0020 getttyent 002d endttyent"
	strings:
		$1 = { 55 48 89 FD 53 48 83 EC 08 E8 ?? ?? ?? ?? EB 0F 48 8B 33 48 89 EF E8 ?? ?? ?? ?? 85 C0 74 0D E8 ?? ?? ?? ?? 48 85 C0 48 89 C3 75 E4 E8 ?? ?? ?? ?? 48 83 C4 08 48 89 D8 5B 5D C3 }
	condition:
		$1
}

rule file_203_0_0 {
	meta:
		name = "quotactl"
		size = 23
		refs = "0012 __syscall_error"
	strings:
		$1 = { 49 89 CA B8 B3 00 00 00 0F 05 48 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_204_0_0 {
	meta:
		name = "__strchrnul"
		size = 111
	strings:
		$1 = { 66 0F 6E CE 48 89 F9 66 0F 60 C9 48 83 E7 F0 66 0F EF D2 66 0F 60 C9 83 CE FF 66 0F 6F 07 66 0F 70 C9 00 48 29 F9 66 0F 6F D8 48 8D 7F 10 66 0F 74 C1 66 0F 74 DA D3 E6 66 0F D7 D0 66 0F D7 CB 09 D1 21 F1 75 20 66 0F 6F 07 48 8D 7F 10 66 0F 6F D8 66 0F 74 C1 66 0F 74 DA 66 0F D7 D0 66 0F D7 CB 09 D1 74 E0 0F BC D1 48 8D 44 17 F0 C3 }
	condition:
		$1
}

rule file_205_0_0 {
	meta:
		name = "__waitid"
		size = 160
		refs = "0002 __libc_multiple_threads 0028 __libc_errno 004b __libc_enable_asynccancel 007f __libc_disable_asynccancel"
	strings:
		$1 = { 8B 05 ?? ?? ?? ?? 85 C0 75 2C 45 31 C0 4C 63 D1 89 F6 89 FF B8 F7 00 00 00 0F 05 48 3D 00 F0 FF FF 77 02 F3 C3 48 8B 15 ?? ?? ?? ?? F7 D8 64 89 02 48 83 C8 FF C3 48 83 EC 28 48 89 54 24 08 89 0C 24 89 74 24 10 89 7C 24 18 E8 ?? ?? ?? ?? 8B 0C 24 41 89 C1 45 31 C0 48 8B 54 24 08 8B 74 24 10 B8 F7 00 00 00 8B 7C 24 18 4C 63 D1 0F 05 48 3D 00 F0 FF FF 77 15 44 89 CF 89 44 24 18 E8 ?? ?? ?? ?? 8B 44 24 18 48 83 C4 28 C3 89 C2 48 8B 05 ?? ?? ?? ?? F7 DA 64 89 10 48 83 C8 FF EB D7 }
	condition:
		$1
}

rule file_206_0_0 {
	meta:
		name = "__snprintf"
		size = 138
		refs = "007e _IO_vsnprintf"
	strings:
		$1 = { 48 81 EC D8 00 00 00 84 C0 48 89 4C 24 38 4C 89 44 24 40 4C 89 4C 24 48 74 37 0F 29 44 24 50 0F 29 4C 24 60 0F 29 54 24 70 0F 29 9C 24 80 00 00 00 0F 29 A4 24 90 00 00 00 0F 29 AC 24 A0 00 00 00 0F 29 B4 24 B0 00 00 00 0F 29 BC 24 C0 00 00 00 48 8D 84 24 E0 00 00 00 48 8D 4C 24 08 48 89 44 24 10 48 8D 44 24 20 C7 44 24 08 18 00 00 00 C7 44 24 0C 30 00 00 00 48 89 44 24 18 E8 ?? ?? ?? ?? 48 81 C4 D8 00 00 00 C3 }
	condition:
		$1
}

rule file_213_0_0 {
	meta:
		name = "__asprintf_chk"
		size = 138
		refs = "007e __vasprintf_chk"
	strings:
		$1 = { 48 81 EC D8 00 00 00 84 C0 48 89 4C 24 38 4C 89 44 24 40 4C 89 4C 24 48 74 37 0F 29 44 24 50 0F 29 4C 24 60 0F 29 54 24 70 0F 29 9C 24 80 00 00 00 0F 29 A4 24 90 00 00 00 0F 29 AC 24 A0 00 00 00 0F 29 B4 24 B0 00 00 00 0F 29 BC 24 C0 00 00 00 48 8D 84 24 E0 00 00 00 48 8D 4C 24 08 48 89 44 24 10 48 8D 44 24 20 C7 44 24 08 18 00 00 00 C7 44 24 0C 30 00 00 00 48 89 44 24 18 E8 ?? ?? ?? ?? 48 81 C4 D8 00 00 00 C3 }
	condition:
		$1
}

rule file_1066_0_0 {
	meta:
		name = "__dprintf_chk"
		size = 138
		refs = "007e __vdprintf_chk"
	strings:
		$1 = { 48 81 EC D8 00 00 00 84 C0 48 89 4C 24 38 4C 89 44 24 40 4C 89 4C 24 48 74 37 0F 29 44 24 50 0F 29 4C 24 60 0F 29 54 24 70 0F 29 9C 24 80 00 00 00 0F 29 A4 24 90 00 00 00 0F 29 AC 24 A0 00 00 00 0F 29 B4 24 B0 00 00 00 0F 29 BC 24 C0 00 00 00 48 8D 84 24 E0 00 00 00 48 8D 4C 24 08 48 89 44 24 10 48 8D 44 24 20 C7 44 24 08 18 00 00 00 C7 44 24 0C 30 00 00 00 48 89 44 24 18 E8 ?? ?? ?? ?? 48 81 C4 D8 00 00 00 C3 }
	condition:
		$1
}

rule file_1389_1_0 {
	meta:
		name = "__obstack_printf_chk"
		size = 138
		refs = "007e __obstack_vprintf_chk"
	strings:
		$1 = { 48 81 EC D8 00 00 00 84 C0 48 89 4C 24 38 4C 89 44 24 40 4C 89 4C 24 48 74 37 0F 29 44 24 50 0F 29 4C 24 60 0F 29 54 24 70 0F 29 9C 24 80 00 00 00 0F 29 A4 24 90 00 00 00 0F 29 AC 24 A0 00 00 00 0F 29 B4 24 B0 00 00 00 0F 29 BC 24 C0 00 00 00 48 8D 84 24 E0 00 00 00 48 8D 4C 24 08 48 89 44 24 10 48 8D 44 24 20 C7 44 24 08 18 00 00 00 C7 44 24 0C 30 00 00 00 48 89 44 24 18 E8 ?? ?? ?? ?? 48 81 C4 D8 00 00 00 C3 }
	condition:
		$1
}

rule file_1426_0_0 {
	meta:
		name = "__swprintf"
		size = 138
		refs = "007e __vswprintf"
	strings:
		$1 = { 48 81 EC D8 00 00 00 84 C0 48 89 4C 24 38 4C 89 44 24 40 4C 89 4C 24 48 74 37 0F 29 44 24 50 0F 29 4C 24 60 0F 29 54 24 70 0F 29 9C 24 80 00 00 00 0F 29 A4 24 90 00 00 00 0F 29 AC 24 A0 00 00 00 0F 29 B4 24 B0 00 00 00 0F 29 BC 24 C0 00 00 00 48 8D 84 24 E0 00 00 00 48 8D 4C 24 08 48 89 44 24 10 48 8D 44 24 20 C7 44 24 08 18 00 00 00 C7 44 24 0C 30 00 00 00 48 89 44 24 18 E8 ?? ?? ?? ?? 48 81 C4 D8 00 00 00 C3 }
	condition:
		$1
}

rule file_893_10_0 {
	meta:
		name = "__syslog_chk"
		size = 138
		refs = "007e __vsyslog_chk"
	strings:
		$1 = { 48 81 EC D8 00 00 00 84 C0 48 89 4C 24 38 4C 89 44 24 40 4C 89 4C 24 48 74 37 0F 29 44 24 50 0F 29 4C 24 60 0F 29 54 24 70 0F 29 9C 24 80 00 00 00 0F 29 A4 24 90 00 00 00 0F 29 AC 24 A0 00 00 00 0F 29 B4 24 B0 00 00 00 0F 29 BC 24 C0 00 00 00 48 8D 84 24 E0 00 00 00 48 8D 4C 24 08 48 89 44 24 10 48 8D 44 24 20 C7 44 24 08 18 00 00 00 C7 44 24 0C 30 00 00 00 48 89 44 24 18 E8 ?? ?? ?? ?? 48 81 C4 D8 00 00 00 C3 }
	condition:
		$1
}

rule file_207_0_0 {
	meta:
		name = "wcwidth"
		size = 94
		refs = "0003 _nl_current_LC_CTYPE"
	strings:
		$1 = { 48 8B 05 ?? ?? ?? ?? 89 FA 64 48 8B 00 48 8B 00 48 8B 80 A0 00 00 00 8B 08 D3 EA 3B 50 04 73 38 83 C2 05 8B 14 90 85 D2 74 2E 8B 48 08 89 FE D3 EE 89 F1 23 48 0C 48 8D 14 8A 8B 14 10 85 D2 74 17 23 78 10 48 01 D0 0F B6 14 38 80 FA FF 0F B6 C2 74 05 F3 C3 0F 1F 00 B8 FF FF FF FF C3 }
	condition:
		$1
}

rule file_209_0_0 {
	meta:
		name = "__fcvt"
		size = 185
		refs = "003e __fcvt_r 009b malloc"
	strings:
		$1 = { 48 89 5C 24 E8 48 89 6C 24 F0 89 FB 4C 89 64 24 F8 48 83 EC 28 48 8B 0D ?? ?? ?? ?? 66 0F 28 C8 48 89 F5 49 89 D4 48 85 C9 74 35 66 0F 28 C1 41 B8 48 01 00 00 4C 89 E2 48 89 EE 89 DF E8 ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? 48 8B 5C 24 10 48 8B 6C 24 18 4C 8B 64 24 20 48 83 C4 28 C3 0F 1F 00 41 B8 14 00 00 00 B9 ?? ?? ?? ?? F2 0F 11 04 24 E8 ?? ?? ?? ?? 83 F8 FF F2 0F 10 0C 24 74 11 B8 ?? ?? ?? ?? EB C3 66 2E 0F 1F 84 00 00 00 00 00 BF 48 01 00 00 F2 0F 11 0C 24 E8 ?? ?? ?? ?? 48 85 C0 48 89 C1 48 89 05 ?? ?? ?? ?? F2 0F 10 0C 24 0F 85 74 FF FF FF EB C6 }
	condition:
		$1
}

rule file_209_1_0 {
	meta:
		name = "__ecvt"
		size = 30
		refs = "0010 __ecvt_r"
	strings:
		$1 = { 48 83 EC 08 41 B8 14 00 00 00 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? 48 83 C4 08 C3 }
	condition:
		$1
}

rule file_209_2_0 {
	meta:
		name = "__gcvt"
		size = 38
		refs = "001d sprintf"
	strings:
		$1 = { 53 83 FF 11 48 89 F3 BA 11 00 00 00 BE ?? ?? ?? ?? B8 01 00 00 00 0F 4E D7 48 89 DF E8 ?? ?? ?? ?? 48 89 D8 5B C3 }
	condition:
		$1
}

rule file_210_0_0 {
	meta:
		name = "ualarm"
		size = 80
		refs = "002e __setitimer"
	strings:
		$1 = { 48 83 EC 48 89 FF 89 F6 48 8D 54 24 20 48 89 7C 24 18 48 89 74 24 08 31 FF 48 89 E6 48 C7 44 24 10 00 00 00 00 48 C7 04 24 00 00 00 00 E8 ?? ?? ?? ?? 85 C0 BA FF FF FF FF 78 0E 8B 44 24 30 69 D0 40 42 0F 00 03 54 24 38 89 D0 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_211_2_0 {
	meta:
		name = "svcraw_freeargs"
		size = 97
		refs = "0015 __rpc_thread_variables"
	strings:
		$1 = { 48 89 5C 24 F0 48 89 6C 24 F8 48 83 EC 18 48 89 F3 48 89 D5 E8 ?? ?? ?? ?? 48 8B B8 F0 00 00 00 48 85 FF 74 2B C7 87 B0 23 00 00 02 00 00 00 48 89 EE 48 89 DA 48 8B 6C 24 10 48 8B 5C 24 08 48 81 C7 B0 23 00 00 31 C0 48 83 C4 18 FF E2 66 90 31 C0 48 8B 5C 24 08 48 8B 6C 24 10 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_211_3_0 {
	meta:
		name = "svcraw_getargs"
		size = 89
		refs = "0015 __rpc_thread_variables"
	strings:
		$1 = { 48 89 5C 24 F0 48 89 6C 24 F8 48 83 EC 18 48 89 F3 48 89 D5 E8 ?? ?? ?? ?? 48 8B B8 F0 00 00 00 48 85 FF 74 23 48 89 EE 48 89 DA 48 8B 6C 24 10 48 8B 5C 24 08 48 81 C7 B0 23 00 00 31 C0 48 83 C4 18 FF E2 0F 1F 40 00 31 C0 48 8B 5C 24 08 48 8B 6C 24 10 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_211_4_0 {
	meta:
		name = "svcraw_reply"
		size = 132
		refs = "0017 __rpc_thread_variables 004e xdr_replymsg"
	strings:
		$1 = { 48 89 5C 24 E8 4C 89 64 24 F8 49 89 F4 48 89 6C 24 F0 48 83 EC 18 E8 ?? ?? ?? ?? 48 8B 98 F0 00 00 00 48 85 DB 74 2F 48 8B 83 B8 23 00 00 48 8D AB B0 23 00 00 31 F6 C7 83 B0 23 00 00 00 00 00 00 48 89 EF FF 50 28 4C 89 E6 48 89 EF E8 ?? ?? ?? ?? 85 C0 75 1A 31 C0 48 8B 1C 24 48 8B 6C 24 08 4C 8B 64 24 10 48 83 C4 18 C3 0F 1F 44 00 00 48 8B 83 B8 23 00 00 48 89 EF FF 50 20 B8 01 00 00 00 EB D4 }
	condition:
		$1
}

rule file_211_5_0 {
	meta:
		name = "svcraw_recv"
		size = 102
		refs = "0012 __rpc_thread_variables 004b xdr_callmsg"
	strings:
		$1 = { 48 89 6C 24 F8 48 89 5C 24 F0 48 83 EC 18 48 89 F5 E8 ?? ?? ?? ?? 48 8B 90 F0 00 00 00 31 C0 48 85 D2 74 33 48 8B 82 B8 23 00 00 48 8D 9A B0 23 00 00 31 F6 C7 82 B0 23 00 00 01 00 00 00 48 89 DF FF 50 28 48 89 EE 48 89 DF E8 ?? ?? ?? ?? 85 C0 0F 95 C0 0F B6 C0 48 8B 5C 24 08 48 8B 6C 24 10 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_211_6_0 {
	meta:
		name = "svcraw_create"
		size = 123
		refs = "0002 __rpc_thread_variables 0053 xdrmem_create 006b calloc"
	strings:
		$1 = { 53 E8 ?? ?? ?? ?? 48 8B 98 F0 00 00 00 48 85 DB 74 4E 48 8D 83 E0 23 00 00 48 8D BB B0 23 00 00 C7 83 60 22 00 00 00 00 00 00 66 C7 83 64 22 00 00 00 00 48 C7 83 68 22 00 00 ?? ?? ?? ?? 48 89 DE 48 89 83 90 22 00 00 B9 02 00 00 00 BA 60 22 00 00 E8 ?? ?? ?? ?? 48 8D 83 60 22 00 00 5B C3 BE 70 25 00 00 BF 01 00 00 00 E8 ?? ?? ?? ?? 48 85 C0 48 89 C3 75 9B 31 C0 5B C3 }
	condition:
		$1
}

rule file_212_0_0 {
	meta:
		name = "raise"
		size = 100
		refs = "0052 __libc_errno"
	strings:
		$1 = { 64 8B 04 25 D4 02 00 00 64 8B 34 25 D0 02 00 00 85 F6 75 2C B8 BA 00 00 00 0F 05 89 C6 64 89 04 25 D0 02 00 00 48 63 D7 48 63 F6 48 63 F8 B8 EA 00 00 00 0F 05 48 3D 00 F0 FF FF 77 12 F3 C3 90 85 C0 7F E1 A9 FF FF FF 7F 74 15 F7 D8 EB D6 48 8B 15 ?? ?? ?? ?? F7 D8 64 89 02 48 83 C8 FF C3 89 F0 EB C1 }
	condition:
		$1
}

rule file_214_0_0 {
	meta:
		name = "plural_eval"
		size = 483
	strings:
		$1 = { 48 89 5C 24 E0 48 89 FB 48 89 6C 24 E8 4C 89 64 24 F0 4C 89 6C 24 F8 48 83 EC 28 8B 03 48 89 F5 83 F8 01 0F 84 A0 00 00 00 0F 8E D1 00 00 00 83 F8 02 74 2C 83 F8 03 74 67 31 ED 48 89 E8 48 8B 5C 24 08 48 8B 6C 24 10 4C 8B 64 24 18 4C 8B 6C 24 20 48 83 C4 28 C3 66 0F 1F 84 00 00 00 00 00 48 8B 7B 08 48 89 EE E8 94 FF FF FF 44 8B 63 04 49 89 C5 41 83 FC 0F 74 6F 41 83 FC 0E 0F 85 A5 00 00 00 48 85 C0 74 B1 48 8B 7B 10 48 89 EE 31 ED E8 6A FF FF FF 48 85 C0 40 0F 95 C5 EB 9C 90 48 8B 7B 08 48 89 EE E8 54 FF FF FF 48 83 F8 01 19 C0 F7 D0 83 C0 02 48 98 48 8B 5C C3 08 8B 03 83 F8 01 0F 85 60 FF FF FF 48 8B 7B 08 48 89 EE 31 ED E8 29 FF FF FF 48 85 C0 40 0F 94 C5 E9 58 FF FF FF 0F 1F 44 00 00 48 85 C0 74 9B BD 01 00 00 00 E9 44 FF FF FF 66 0F 1F 84 00 00 00 00 00 85 C0 0F 85 31 FF FF FF 8B 43 04 85 C0 0F 84 28 FF FF FF 83 F8 01 0F 85 1D FF FF FF 48 8B 6B 08 E9 16 FF FF FF 0F 1F 00 48 8B 7B 10 48 89 EE 41 83 EC 03 31 ED E8 C6 FE FF FF 41 83 FC 0A 48 89 C1 0F 87 F4 FE FF FF 42 FF 24 E5 ?? ?? ?? ?? 31 ED 49 39 C5 40 0F 94 C5 E9 DE FE FF FF 31 ED 49 39 C5 40 0F 93 C5 E9 D0 FE FF FF 31 ED 49 39 C5 40 0F 96 C5 E9 C2 FE FF FF 31 ED 49 39 C5 40 0F 97 C5 E9 B4 FE FF FF 31 ED 49 39 C5 40 0F 92 C5 E9 A6 FE FF FF 4C 89 ED 48 29 C5 E9 9B FE FF FF 4A 8D 2C 28 E9 92 FE FF FF 4C 89 E8 31 D2 48 F7 F1 48 89 D5 E9 82 FE FF FF 4C 89 E8 31 D2 48 F7 F1 48 89 C5 E9 72 FE FF FF 48 89 C5 49 0F AF ED E9 66 FE FF FF 31 ED 49 39 C5 40 0F 95 C5 E9 58 FE FF FF }
	condition:
		$1
}

rule file_214_1_0 {
	meta:
		name = "transcmp"
		size = 118
		refs = "0023 strcmp"
	strings:
		$1 = { 55 48 89 FD 53 48 89 F3 48 83 EC 08 48 83 7E 20 00 74 5D 48 83 C6 38 48 83 7D 20 00 74 42 48 8D 7D 38 E8 ?? ?? ?? ?? 85 C0 75 27 48 8B 33 48 8B 7D 00 E8 ?? ?? ?? ?? 85 C0 75 17 48 8B 73 10 48 8B 7D 10 E8 ?? ?? ?? ?? 85 C0 75 06 8B 45 08 2B 43 08 48 83 C4 08 5B 5D C3 0F 1F 80 00 00 00 00 48 8B 7D 38 EB BC 66 2E 0F 1F 84 00 00 00 00 00 48 8B 76 38 EB A1 }
	condition:
		$1
}

rule file_214_2_0 {
	meta:
		name = "plural_lookup.isra.2"
		size = 129
		refs = "004c __rawmemchr"
	strings:
		$1 = { 41 55 49 89 FD 41 54 49 89 D4 55 48 89 CD 53 48 83 EC 08 48 8B BF B8 00 00 00 E8 71 FD FF FF 49 3B 85 C0 00 00 00 48 89 C3 B8 00 00 00 00 4C 89 E7 48 0F 43 D8 4C 01 E5 0F 1F 84 00 00 00 00 00 48 85 DB 74 2B 31 F6 48 83 EB 01 E8 ?? ?? ?? ?? 48 8D 78 01 48 39 EF 72 E7 48 83 C4 08 4C 89 E0 5B 5D 41 5C 41 5D C3 66 0F 1F 84 00 00 00 00 00 48 83 C4 08 49 89 FC 5B 5D 4C 89 E0 41 5C 41 5D C3 }
	condition:
		$1
}

rule file_214_3_0 {
	meta:
		name = "_L_lock_1459"
		size = 31
		refs = "000f __lll_lock_wait_private"
	strings:
		$1 = { 48 8D 3D ?? ?? ?? ?? 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 3D F2 FF FF }
	condition:
		$1
}

rule file_214_4_0 {
	meta:
		name = "_L_unlock_1603"
		size = 31
		refs = "000f __lll_unlock_wake_private"
	strings:
		$1 = { 48 8D 3D ?? ?? ?? ?? 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 80 F3 FF FF }
	condition:
		$1
}

rule file_214_5_0 {
	meta:
		name = "_L_unlock_1685"
		size = 31
		refs = "000f __lll_unlock_wake_private"
	strings:
		$1 = { 48 8D 3D ?? ?? ?? ?? 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 10 F4 FF FF }
	condition:
		$1
}

rule file_214_6_0 {
	meta:
		name = "_L_unlock_1700"
		size = 31
		refs = "000f __lll_unlock_wake_private"
	strings:
		$1 = { 48 8D 3D ?? ?? ?? ?? 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 22 F4 FF FF }
	condition:
		$1
}

rule file_214_7_0 {
	meta:
		name = "_L_lock_2352"
		size = 31
		refs = "000f __lll_lock_wait_private"
	strings:
		$1 = { 48 8D 3D ?? ?? ?? ?? 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 24 F7 FF FF }
	condition:
		$1
}

rule file_214_8_0 {
	meta:
		name = "_L_unlock_2362"
		size = 31
		refs = "000f __lll_unlock_wake_private"
	strings:
		$1 = { 48 8D 3D ?? ?? ?? ?? 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 30 F7 FF FF }
	condition:
		$1
}

rule file_214_9_0 {
	meta:
		name = "_nl_find_msg"
		size = 2876
		refs = "0064 strlen 0076 __hash_string 0102 strcmp 0231 __pthread_rwlock_rdlock 029f __pthread_rwlock_unlock 0411 _nl_load_domain 0441 _nl_current_LC_CTYPE 046c __pthread_rwlock_wrlock 0525 __libc_multiple_threads 05a9 realloc 0609 __gconv 0645 malloc 066d free 06bd getenv 07d4 __strdup 0814 _nl_find_msg 082a strstr 0894 mempcpy 08e6 _nl_C_locobj 098e __gconv_open 09d3 memcpy 0af4 calloc"
	strings:
		$1 = { 55 48 89 E5 41 57 41 56 41 55 41 54 53 48 81 EC 98 00 00 00 4C 89 85 70 FF FF FF 44 8B 47 08 48 89 7D 88 48 89 B5 68 FF FF FF 48 89 55 90 89 8D 78 FF FF FF 45 85 C0 0F 8E D3 03 00 00 48 8B 45 88 48 8B 58 10 48 85 DB 0F 84 D2 02 00 00 48 83 7B 60 00 8B 53 28 89 55 AC 0F 84 D9 02 00 00 48 8B 7D 90 E8 ?? ?? ?? ?? 48 8B 7D 90 49 89 C5 89 45 A0 45 89 ED E8 ?? ?? ?? ?? 8B 4B 58 31 D2 41 89 C7 44 8B 43 68 4C 89 6D 98 F7 F1 8D 71 FE 44 89 F8 41 89 CE 41 89 D4 31 D2 F7 F6 44 8D 7A 01 48 8B 53 60 45 89 FB 45 29 FE 41 29 CB E9 88 00 00 00 66 0F 1F 44 00 00 8B 7B 18 4C 8B 53 30 44 89 EE 85 FF 41 8B 04 F2 74 02 0F C8 3B 45 A0 72 57 85 FF 48 8B 03 0F 84 24 02 00 00 41 8B 74 F2 04 0F CE 89 F6 48 8B 7D 90 48 01 C6 48 89 95 50 FF FF FF 44 89 85 58 FF FF FF 44 89 9D 48 FF FF FF E8 ?? ?? ?? ?? 85 C0 48 8B 95 50 FF FF FF 44 8B 85 58 FF FF FF 0F 94 C0 44 8B 9D 48 FF FF FF 84 C0 0F 85 93 00 00 00 43 8D 04 1C 43 8D 34 3C 45 39 F4 41 89 C4 44 0F 42 E6 44 89 E0 45 85 C0 44 8B 2C 82 74 03 41 0F CD 45 85 ED 0F 84 CE 01 00 00 41 83 ED 01 44 39 6D AC 0F 87 58 FF FF FF 44 89 E8 2B 45 AC 48 8B 4D 98 48 C1 E0 04 48 03 43 48 48 39 08 76 B1 48 8B 70 08 48 8B 7D 90 48 89 95 50 FF FF FF 44 89 85 58 FF FF FF 44 89 9D 48 FF FF FF E8 ?? ?? ?? ?? 85 C0 44 8B 9D 48 FF FF FF 44 8B 85 58 FF FF FF 0F 94 C0 48 8B 95 50 FF FF FF 84 C0 0F 84 6D FF FF FF 44 8B 45 AC 45 89 EF 4C 89 45 80 4C 3B 7D 80 0F 83 E0 01 00 00 8B 7B 18 48 8B 03 48 8B 53 38 85 FF 0F 84 0E 02 00 00 4A 8D 0C FA 8B B5 78 FF FF FF 8B 51 04 0F CA 89 D2 4C 8D 24 10 8B 01 0F C8 83 C0 01 85 F6 48 89 45 90 0F 84 CE 01 00 00 48 83 BD 68 FF FF FF 00 0F 84 02 02 00 00 4C 8B 85 68 FF FF FF 4D 8B 40 10 4D 85 C0 4C 89 45 A0 0F 84 EA 01 00 00 B8 ?? ?? ?? ?? 48 85 C0 74 09 48 8D BB 80 00 00 00 FF D0 48 8B 53 78 48 85 D2 0F 84 43 05 00 00 48 8B 43 70 48 8D 0C 52 49 89 D6 4C 89 65 98 4C 8D 6C C8 E8 4C 89 EA 49 89 DD 48 8B 5D A0 EB 0E 4D 85 F6 49 8D 54 24 E8 0F 84 DE 01 00 00 48 8B 3A 48 89 DE 49 83 EE 01 49 89 D4 E8 ?? ?? ?? ?? 85 C0 75 DC 4C 89 EB 4D 89 E5 4C 8B 65 98 BA ?? ?? ?? ?? 48 85 D2 74 09 48 8D BB 80 00 00 00 FF D2 4D 85 ED 0F 84 B1 01 00 00 49 83 7D 08 FF 0F 84 13 01 00 00 49 8B 45 10 48 85 C0 0F 84 AF 07 00 00 48 83 F8 FF 0F 84 04 08 00 00 4A 8B 04 F8 48 85 C0 0F 84 35 02 00 00 4C 8D 60 08 48 8B 00 48 89 45 90 E9 DF 00 00 00 0F 1F 80 00 00 00 00 41 8B 74 F2 04 E9 DB FD FF FF 66 0F 1F 44 00 00 4D 39 EF 4D 89 FE 77 79 0F 1F 84 00 00 00 00 00 45 31 E4 48 8D 65 D8 4C 89 E0 5B 41 5C 41 5D 41 5E 41 5F 5D C3 0F 1F 00 8B 55 AC 45 31 ED 48 89 55 80 49 89 D6 EB 32 66 0F 1F 84 00 00 00 00 00 48 8B 55 98 42 8B 74 FA 04 0F CE 89 F6 48 03 75 A0 48 8B 7D 90 E8 ?? ?? ?? ?? 83 F8 00 7C A1 0F 84 51 FE FF FF 4D 8D 6F 01 4D 39 F5 73 A2 48 8B 0B 4C 8B 43 30 44 8B 63 18 48 89 4D A0 4C 89 45 98 4F 8D 3C 2E 49 D1 EF 45 85 E4 75 B3 48 8B 4D 98 42 8B 74 F9 04 EB B5 0F 1F 84 00 00 00 00 00 4C 89 F8 48 2B 45 80 48 C1 E0 04 48 03 43 50 4C 8B 60 08 48 8B 00 48 89 45 90 8B B5 78 FF FF FF 85 F6 0F 85 32 FE FF FF 4C 8B 45 90 48 8B 8D 70 FF FF FF 4C 89 01 E9 38 FF FF FF 0F 1F 44 00 00 4A 8D 14 FA 44 8B 62 04 49 01 C4 8B 02 83 C0 01 48 89 45 90 EB C4 66 2E 0F 1F 84 00 00 00 00 00 E8 ?? ?? ?? ?? E9 23 FC FF FF 8B 0D ?? ?? ?? ?? 85 C9 0F 84 8F 02 00 00 48 8B 05 ?? ?? ?? ?? 48 89 45 A0 48 83 7D A0 00 0F 85 F2 FD FF FF 48 8B 05 ?? ?? ?? ?? 64 48 8B 00 48 8B 00 48 8B 80 B0 00 00 00 48 89 45 A0 E9 D4 FD FF FF 4C 89 EB 4C 8B 65 98 45 31 ED E9 33 FE FF FF B8 ?? ?? ?? ?? 48 85 C0 74 09 48 8D BB 80 00 00 00 FF D0 48 8B 4B 78 48 85 C9 48 89 4D 98 0F 84 58 05 00 00 48 8B 43 70 48 8B 55 98 4C 89 A5 78 FF FF FF 48 89 9D 60 FF FF FF 4C 8B 75 A0 48 89 45 80 48 8B 4D 80 48 8D 04 52 48 8D 54 C1 E8 48 8B 4D 98 49 89 D4 48 89 CB EB 17 66 2E 0F 1F 84 00 00 00 00 00 49 83 EC 18 48 85 DB 0F 84 BE 02 00 00 49 8B 3C 24 4C 89 F6 48 83 EB 01 4D 89 E5 E8 ?? ?? ?? ?? 85 C0 75 DC 4C 8B A5 78 FF FF FF 48 8B 9D 60 FF FF FF BA ?? ?? ?? ?? 48 85 D2 0F 84 AA FD FF FF 48 8D BB 80 00 00 00 FF D2 E9 9C FD FF FF BE 01 00 00 00 83 3D ?? ?? ?? ?? 00 74 10 F0 0F B1 35 ?? ?? ?? ?? 0F 85 B3 0D 00 00 EB 0D 0F B1 35 ?? ?? ?? ?? 0F 85 A4 0D 00 00 48 8B 05 ?? ?? ?? ?? 45 31 F6 4C 89 65 B8 4C 89 7D A0 48 8B 0D ?? ?? ?? ?? 45 89 F7 4D 89 E6 4C 8B 65 90 48 83 C0 08 48 89 45 C0 EB 6C 66 2E 0F 1F 84 00 00 00 00 00 45 85 FF 0F 84 A5 00 00 00 41 83 C7 01 48 8B 1D ?? ?? ?? ?? 41 69 F7 F0 0F 00 00 48 89 DF 48 63 F6 48 89 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 85 C0 0F 84 A9 00 00 00 48 89 05 ?? ?? ?? ?? 48 8B 0D ?? ?? ?? ?? 48 8D 50 08 48 83 C0 10 48 89 45 C0 48 89 15 ?? ?? ?? ?? 48 83 E9 08 48 89 0D ?? ?? ?? ?? 48 83 F9 07 76 98 48 8B 45 C0 48 8B 55 B8 4C 8D 4D C8 49 8B 7D 08 48 8D 75 B8 4C 8D 44 08 F8 48 8D 4D C0 4C 01 E2 E8 ?? ?? ?? ?? A9 FB FF FF FF 0F 84 D4 00 00 00 83 F8 05 0F 85 46 01 00 00 45 85 FF 4C 89 75 B8 0F 85 5B FF FF FF BF F0 0F 00 00 48 C7 05 ?? ?? ?? ?? F0 0F 00 00 41 BF 01 00 00 00 E8 ?? ?? ?? ?? 48 8B 15 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 48 89 10 E9 5E FF FF FF 48 8B 03 48 89 DF 48 89 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 C7 05 ?? ?? ?? ?? 00 00 00 00 48 C7 05 ?? ?? ?? ?? 00 00 00 00 83 3D ?? ?? ?? ?? 00 74 0F F0 FF 0D ?? ?? ?? ?? 0F 85 6F 0C 00 00 EB 0C FF 0D ?? ?? ?? ?? 0F 85 61 0C 00 00 49 C7 C4 FF FF FF FF E9 6C FC FF FF BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 85 C0 49 89 C5 74 09 80 38 00 0F 85 DA 02 00 00 48 8B 05 ?? ?? ?? ?? 48 89 45 A0 C7 05 ?? ?? ?? ?? 01 00 00 00 E9 47 FD FF FF 48 8B 05 ?? ?? ?? ?? 48 8B 55 C0 4C 8B 7D A0 48 29 C2 48 83 EA 08 48 89 10 49 8B 55 10 4A 89 04 FA 48 8B 55 C0 48 29 D0 48 03 05 ?? ?? ?? ?? 48 89 C1 48 83 E0 F8 83 E1 07 48 89 05 ?? ?? ?? ?? 48 01 CA 48 89 15 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 74 0F F0 FF 0D ?? ?? ?? ?? 0F 85 DF 0B 00 00 EB 0C FF 0D ?? ?? ?? ?? 0F 85 D1 0B 00 00 49 8B 45 10 4A 8B 04 F8 E9 82 FB FF FF 83 3D ?? ?? ?? ?? 00 74 0F F0 FF 0D ?? ?? ?? ?? 0F 85 CD 0B 00 00 EB 0C FF 0D ?? ?? ?? ?? 0F 85 BF 0B 00 00 45 31 E4 E9 90 FB FF FF 45 31 ED E9 03 FB FF FF 4C 8B A5 78 FF FF FF 48 8B 9D 60 FF FF FF 4C 8B 45 98 48 8B 7D 80 4B 8D 74 40 03 48 C1 E6 03 E8 ?? ?? ?? ?? 48 85 C0 49 89 C5 0F 84 4C 03 00 00 48 8B 7D A0 48 89 43 70 E8 ?? ?? ?? ?? 48 85 C0 49 89 C6 0F 84 33 03 00 00 48 8B 55 98 48 8B B5 68 FF FF FF 4C 8D 45 C8 48 8B 7D 88 31 C9 48 8D 04 52 BA ?? ?? ?? ?? 4D 8D 6C C5 00 4D 89 75 00 49 C7 45 08 FF FF FF FF E8 ?? ?? ?? ?? 48 85 C0 0F 84 79 01 00 00 BE ?? ?? ?? ?? 48 89 C7 E8 ?? ?? ?? ?? 48 85 C0 0F 84 63 01 00 00 0F B6 48 08 31 D2 48 8D 70 08 48 BF 00 00 00 80 00 00 60 00 84 C9 75 16 EB 24 0F 1F 80 00 00 00 00 48 83 C2 01 0F B6 4C 10 08 84 C9 74 10 80 F9 20 77 EE 49 89 F8 49 D3 E0 4D 85 C0 79 E3 48 8D 42 1F 48 83 E0 F0 48 29 C4 48 8D 4C 24 0F 48 83 E1 F0 48 89 CF 48 89 8D 58 FF FF FF E8 ?? ?? ?? ?? 31 F6 C6 00 00 4C 89 F0 48 8B 8D 58 FF FF FF EB 10 48 83 C0 01 80 FA 2F 0F 94 C2 0F B6 D2 48 01 D6 0F B6 10 84 D2 75 E9 4C 29 F0 49 0F BE 16 48 83 C0 29 48 83 E0 F0 48 29 C4 48 8D 7C 24 0F 48 83 E7 F0 84 D2 0F 84 46 01 00 00 4C 8B 1D ?? ?? ?? ?? 48 89 F8 4D 89 F0 41 8B 14 93 49 83 C0 01 48 83 C0 01 88 50 FF 49 0F BE 10 84 D2 75 E9 48 83 FE 01 0F 86 E3 00 00 00 C6 00 00 45 31 C0 48 89 C8 EB 10 48 83 C0 01 80 FA 2F 0F 94 C2 0F B6 D2 49 01 D0 0F B6 10 84 D2 75 E9 48 29 C8 48 0F BE 11 48 83 C0 21 48 83 E0 F0 48 29 C4 48 8D 74 24 0F 48 83 E6 F0 84 D2 0F 84 B9 01 00 00 4C 8B 1D ?? ?? ?? ?? 48 89 F0 41 8B 14 93 48 83 C1 01 48 83 C0 01 88 50 FF 48 0F BE 11 84 D2 75 E9 49 83 F8 01 0F 86 87 00 00 00 49 8D 55 08 C6 00 00 B9 01 00 00 00 E8 ?? ?? ?? ?? 85 C0 0F 85 97 00 00 00 49 C7 45 10 00 00 00 00 48 83 43 78 01 E9 56 FB FF FF 48 89 C7 E8 ?? ?? ?? ?? 4C 8D 70 01 4C 89 F7 E8 ?? ?? ?? ?? 48 85 C0 48 89 45 A0 74 0E 4C 89 F2 4C 89 EE 48 89 C7 E8 ?? ?? ?? ?? 48 8B 45 A0 48 89 05 ?? ?? ?? ?? E9 F6 FC FF FF 4C 8B 43 70 4C 89 45 80 E9 B5 FD FF FF 48 85 F6 C6 00 2F 48 8D 50 01 74 66 48 89 D0 E9 09 FF FF FF 4D 85 C0 C6 00 2F 48 8D 50 01 75 0D C6 40 01 2F 48 83 C0 02 E9 60 FF FF FF 48 89 D0 E9 58 FF FF FF 48 89 F8 E9 D6 FE FF FF 83 C0 01 74 23 B8 ?? ?? ?? ?? 48 85 C0 74 09 48 8D BB 80 00 00 00 FF D0 4C 89 F7 45 31 E4 E8 ?? ?? ?? ?? E9 CA F8 FF FF 49 C7 45 08 FF FF FF FF E9 34 FF FF FF 48 BA 54 52 41 4E 53 4C 49 54 C6 40 01 2F 48 83 C0 0A 48 89 50 F8 E9 90 FE FF FF BE 01 00 00 00 83 3D ?? ?? ?? ?? 00 74 10 F0 0F B1 35 ?? ?? ?? ?? 0F 85 CC 08 00 00 EB 0D 0F B1 35 ?? ?? ?? ?? 0F 85 BD 08 00 00 49 83 7D 10 00 74 35 83 3D ?? ?? ?? ?? 00 74 0F F0 FF 0D ?? ?? ?? ?? 0F 85 BF 08 00 00 EB 0C FF 0D ?? ?? ?? ?? 0F 85 B1 08 00 00 49 8B 45 10 E9 F2 F7 FF FF 49 89 C4 E9 3B F8 FF FF 8B 7D AC 03 7B 40 BE 08 00 00 00 E8 ?? ?? ?? ?? 48 85 C0 49 89 45 10 0F 85 44 FA FF FF 49 C7 45 10 FF FF FF FF EB A4 48 89 F0 E9 60 FE FF FF B8 ?? ?? ?? ?? 48 85 C0 74 12 48 8D BB 80 00 00 00 49 83 CC FF FF D0 E9 F0 F7 FF FF 49 83 CC FF E9 E7 F7 FF FF }
	condition:
		$1
}

rule file_214_10_0 {
	meta:
		name = "__dcigettext"
		size = 1965
		refs = "0079 __pthread_rwlock_rdlock 0083 __libc_setlocale_lock 008a _nl_state_lock 00a9 _nl_current_default_domain 00ca __current_locale_name 00d5 strlen 00f5 memcpy 0122 __tfind 0127 __pthread_rwlock_unlock 0151 _nl_msg_cat_cntr 0164 __libc_errno 016b _nl_domain_bindings 01aa strcmp 0230 __getcwd 024a __rawmemchr 0259 strcpy 0268 _nl_default_dirname 027c _nl_category_name_idxs 0281 getenv 028b _nl_category_names 02f0 stpcpy 030c mempcpy 038e _nl_find_domain 03ad _nl_find_msg 04a6 __libc_enable_secure 04bb strchr 0699 malloc 072a __pthread_rwlock_wrlock 0756 __tsearch 0795 free"
	strings:
		$1 = { 55 48 89 E5 41 57 41 56 41 55 41 54 49 89 F4 53 48 81 EC B8 00 00 00 48 85 F6 48 89 BD 60 FF FF FF 48 89 95 48 FF FF FF 89 8D 68 FF FF FF 4C 89 85 50 FF FF FF 44 89 8D 6C FF FF FF 74 28 41 83 F9 0C 77 06 41 83 F9 06 75 2E 44 8B AD 68 FF FF FF 45 85 ED 74 10 48 83 BD 50 FF FF FF 01 4C 0F 45 A5 48 FF FF FF 48 8D 65 D8 4C 89 E0 5B 41 5C 41 5D 41 5E 41 5F 5D C3 BB ?? ?? ?? ?? 48 85 DB 74 0E BF ?? ?? ?? ?? FF D3 BF ?? ?? ?? ?? FF D3 48 83 BD 60 FF FF FF 00 8B 95 6C FF FF FF 48 8B 85 60 FF FF FF 48 0F 44 05 ?? ?? ?? ?? 48 C7 45 B0 00 00 00 00 4C 89 65 C8 89 D7 89 55 98 48 89 85 60 FF FF FF 48 89 45 90 E8 ?? ?? ?? ?? 48 89 C7 49 89 C5 E8 ?? ?? ?? ?? 48 8D 48 1F 48 8D 50 01 4C 89 EE 48 83 E1 F0 48 29 CC 48 8D 7C 24 0F 48 83 E7 F0 E8 ?? ?? ?? ?? 48 85 DB 48 89 85 40 FF FF FF 48 89 45 A0 74 0A BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 7D 90 BA ?? ?? ?? ?? BE ?? ?? ?? ?? E8 ?? ?? ?? ?? B9 ?? ?? ?? ?? 48 89 85 58 FF FF FF 48 85 C9 74 07 BF ?? ?? ?? ?? FF D1 48 83 BD 58 FF FF FF 00 74 19 48 8B 95 58 FF FF FF 8B 0D ?? ?? ?? ?? 48 8B 02 39 48 18 0F 84 54 04 00 00 48 8B 15 ?? ?? ?? ?? 48 8B 1D ?? ?? ?? ?? 64 8B 12 48 85 DB 89 95 34 FF FF FF 0F 84 E0 00 00 00 4C 8B AD 60 FF FF FF EB 18 66 0F 1F 44 00 00 0F 8C C9 00 00 00 48 8B 1B 48 85 DB 0F 84 BF 00 00 00 48 8D 73 18 4C 89 EF E8 ?? ?? ?? ?? 83 F8 00 75 DD 48 8B 43 08 80 38 2F 48 89 85 70 FF FF FF 0F 84 A5 00 00 00 48 8B BD 70 FF FF FF 41 BE 02 10 00 00 E8 ?? ?? ?? ?? 4C 8D 78 01 EB 1D 90 48 8B 15 ?? ?? ?? ?? 64 83 3A 22 0F 85 67 03 00 00 4C 89 F0 48 D1 E8 4D 8D 74 06 20 4B 8D 44 3E 1E B9 10 00 00 00 31 D2 4C 89 F6 48 F7 F1 48 C1 E0 04 48 29 C4 48 8B 05 ?? ?? ?? ?? 48 8D 7C 24 0F 48 83 E7 F0 64 C7 00 00 00 00 00 49 89 FD E8 ?? ?? ?? ?? 48 85 C0 74 A7 4C 8B 73 08 31 F6 4C 89 EF 4C 89 AD 70 FF FF FF E8 ?? ?? ?? ?? 48 8D 78 01 4C 89 F6 C6 00 2F E8 ?? ?? ?? ?? EB 0D 31 DB 48 C7 85 70 FF FF FF ?? ?? ?? ?? 48 63 85 6C FF FF FF BF ?? ?? ?? ?? 44 0F B6 B0 ?? ?? ?? ?? E8 ?? ?? ?? ?? 49 89 C7 49 81 C6 ?? ?? ?? ?? 48 85 C0 74 09 80 38 00 0F 85 BD 01 00 00 8B BD 6C FF FF FF E8 ?? ?? ?? ?? 49 89 C5 48 8B BD 60 FF FF FF E8 ?? ?? ?? ?? 4C 89 F7 48 89 85 38 FF FF FF E8 ?? ?? ?? ?? 48 8B 95 38 FF FF FF 4C 89 F6 48 8D 44 02 23 48 83 E0 F0 48 29 C4 48 8D 4C 24 0F 48 83 E1 F0 48 89 CF 48 89 8D 78 FF FF FF E8 ?? ?? ?? ?? 66 C7 00 2F 00 48 8B 95 38 FF FF FF 48 8D 78 01 48 8B B5 60 FF FF FF E8 ?? ?? ?? ?? 4C 89 EF C7 00 2E 6D 6F 00 E8 ?? ?? ?? ?? 48 83 C0 1F 48 83 E0 F0 48 29 C4 4C 8D 74 24 0F 49 83 E6 F0 66 0F 1F 44 00 00 45 0F B6 45 00 41 80 F8 3A 0F 84 A1 01 00 00 45 84 C0 0F 85 30 01 00 00 41 C6 06 43 41 C6 46 01 00 41 80 7E 01 00 0F 84 F4 01 00 00 BF ?? ?? ?? ?? B9 06 00 00 00 4C 89 F6 F3 A6 0F 84 DF 01 00 00 48 8B 95 78 FF FF FF 48 8B BD 70 FF FF FF 48 89 D9 4C 89 F6 E8 ?? ?? ?? ?? 48 85 C0 49 89 C7 74 9E 4C 8D 45 88 B9 01 00 00 00 4C 89 E2 48 89 DE 48 89 C7 E8 ?? ?? ?? ?? 48 85 C0 0F 84 3E 01 00 00 49 89 C0 49 83 F8 FF 0F 84 91 01 00 00 48 83 BD 58 FF FF FF 00 0F 84 52 02 00 00 48 8B 95 58 FF FF FF 48 8B 8D 58 FF FF FF 48 8B 02 8B 15 ?? ?? ?? ?? 4C 89 78 20 89 50 18 48 8B 01 48 8B 55 88 4C 89 40 28 48 8B 01 48 89 50 30 44 8B 8D 68 FF FF FF 8B 95 34 FF FF FF 48 8B 05 ?? ?? ?? ?? 45 85 C9 64 89 10 0F 85 E3 01 00 00 B9 ?? ?? ?? ?? 48 85 C9 0F 84 72 03 00 00 4C 89 85 20 FF FF FF BF ?? ?? ?? ?? FF D1 BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 4C 8B 85 20 FF FF FF 4D 89 C4 E9 0C FC FF FF 8B BD 6C FF FF FF E8 ?? ?? ?? ?? 80 38 43 49 89 C5 0F 84 36 01 00 00 4D 89 FD E9 32 FE FF FF 0F 1F 80 00 00 00 00 4C 89 F0 EB 08 0F 1F 00 45 84 C0 74 16 49 83 C5 01 44 88 00 48 83 C0 01 45 0F B6 45 00 41 80 F8 3A 75 E5 44 8B 1D ?? ?? ?? ?? C6 00 00 45 85 DB 74 1E BE 2F 00 00 00 4C 89 F7 E8 ?? ?? ?? ?? 48 85 C0 0F 85 70 FE FF FF 0F 1F 84 00 00 00 00 00 41 0F B6 06 3C 43 0F 85 88 FE FF FF E9 78 FE FF FF 0F 1F 80 00 00 00 00 49 83 C5 01 E9 47 FE FF FF 0F 1F 80 00 00 00 00 49 8B 7F 20 48 85 FF 0F 84 33 FE FF FF 45 31 DB 4C 89 AD 28 FF FF FF 45 89 DD EB 15 0F 1F 40 00 41 83 C5 01 49 63 C5 49 8B 7C C7 20 48 85 FF 74 72 4C 8D 45 88 B9 01 00 00 00 4C 89 E2 48 89 DE E8 ?? ?? ?? ?? 48 85 C0 74 D6 4D 63 DD 49 89 C0 4F 8B 7C DF 20 E9 6B FE FF FF 66 0F 1F 44 00 00 B9 ?? ?? ?? ?? 48 85 C9 74 14 BF ?? ?? ?? ?? E8 ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 44 8B 95 68 FF FF FF 8B 95 34 FF FF FF 48 8B 05 ?? ?? ?? ?? 45 85 D2 64 89 10 0F 85 C0 FA FF FF E9 CB FA FF FF 4C 8B AD 28 FF FF FF E9 91 FD FF FF 41 80 7D 01 00 4D 0F 45 EF E9 F6 FC FF FF 8B 9D 68 FF FF FF 85 DB 75 28 4C 8B 60 28 B8 ?? ?? ?? ?? 48 85 C0 0F 84 95 FA FF FF BF ?? ?? ?? ?? FF D0 BF ?? ?? ?? ?? E8 ?? ?? ?? ?? E9 7F FA FF FF 48 8B 48 30 48 8B 50 28 48 8B 40 20 48 8B B5 50 FF FF FF 48 8B 78 10 E8 2D EE FF FF 49 89 C4 EB BB 49 8B 7F 10 48 8B 4D 88 4C 89 C2 48 8B B5 50 FF FF FF E8 11 EE FF FF 49 89 C0 E9 FE FD FF FF 4C 89 E7 4C 89 85 20 FF FF FF E8 ?? ?? ?? ?? 4C 8B B5 40 FF FF FF 4C 8B 85 20 FF FF FF 48 8D 58 01 41 8B 16 49 83 C6 04 8D 82 FF FE FE FE F7 D2 21 D0 25 80 80 80 80 74 E8 89 C2 4C 89 85 20 FF FF FF C1 EA 10 A9 80 80 00 00 0F 44 C2 49 8D 56 02 4C 0F 44 F2 00 C0 48 8B 85 38 FF FF FF 49 83 DE 03 4C 2B B5 40 FF FF FF 49 8D 7C 06 3A 48 01 DF E8 ?? ?? ?? ?? 48 85 C0 49 89 C5 4C 8B 85 20 FF FF FF 0F 84 55 FD FF FF 48 8D 78 38 48 89 DA 4C 89 E6 E8 ?? ?? ?? ?? 4C 8B A5 38 FF FF FF 48 8B B5 60 FF FF FF 48 89 C3 48 89 C7 49 83 C4 01 4C 89 E2 E8 ?? ?? ?? ?? 4A 8D 0C 23 48 8B B5 40 FF FF FF 49 8D 56 01 48 89 CF E8 ?? ?? ?? ?? 49 89 45 10 8B 05 ?? ?? ?? ?? 4C 8B 85 20 FF FF FF 8B 95 6C FF FF FF 49 89 5D 00 4D 89 7D 20 41 89 45 18 48 8B 45 88 41 89 55 08 4D 89 45 28 49 89 45 30 B8 ?? ?? ?? ?? 48 85 C0 74 0E BF ?? ?? ?? ?? FF D0 4C 8B 85 20 FF FF FF BA ?? ?? ?? ?? BE ?? ?? ?? ?? 4C 89 EF 4C 89 85 20 FF FF FF E8 ?? ?? ?? ?? B9 ?? ?? ?? ?? 48 89 C3 4C 8B 85 20 FF FF FF 48 85 C9 74 0E BF ?? ?? ?? ?? FF D1 4C 8B 85 20 FF FF FF 48 85 DB 74 09 4C 3B 2B 0F 84 7B FC FF FF 4C 89 EF 4C 89 85 20 FF FF FF E8 ?? ?? ?? ?? 4C 8B 85 20 FF FF FF E9 60 FC FF FF 4D 89 C4 E9 B9 F8 FF FF }
	condition:
		$1
}

rule file_214_11_0 {
	meta:
		name = "free_mem"
		size = 169
		refs = "0004 _nl_domain_bindings 001a _nl_default_dirname 0028 free 004c _nl_current_default_domain 0053 _nl_default_default_domain 006b __tdestroy"
	strings:
		$1 = { 53 48 8B 1D ?? ?? ?? ?? 48 85 DB 74 3C 0F 1F 00 48 8B 7B 08 48 8B 03 48 81 FF ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 74 05 E8 ?? ?? ?? ?? 48 8B 7B 10 E8 ?? ?? ?? ?? 48 89 DF E8 ?? ?? ?? ?? 48 8B 1D ?? ?? ?? ?? 48 85 DB 75 C7 48 8B 3D ?? ?? ?? ?? 48 81 FF ?? ?? ?? ?? 74 05 E8 ?? ?? ?? ?? 48 8B 3D ?? ?? ?? ?? BE ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 3D ?? ?? ?? ?? 48 C7 05 ?? ?? ?? ?? 00 00 00 00 48 85 FF 74 21 66 2E 0F 1F 84 00 00 00 00 00 48 8B 1F 48 89 1D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 85 DB 48 89 DF 75 E9 5B C3 }
	condition:
		$1
}

rule file_216_0_0 {
	meta:
		name = "__gconv"
		size = 577
		refs = "00d7 _dl_mcount_wrapper_check 0224 __assert_fail"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 53 48 83 EC 38 48 83 FF FF 48 89 4C 24 20 0F 84 43 01 00 00 48 8B 07 48 83 E8 01 4D 85 C9 48 89 44 24 18 0F 84 F6 01 00 00 48 83 7C 24 20 00 49 89 FF 48 89 F3 49 89 D4 4D 89 CE 49 C7 01 00 00 00 00 0F 84 B7 01 00 00 48 8B 4C 24 20 48 8B 11 48 8B 4C 24 18 48 8B 44 24 18 48 C1 E1 03 48 C1 E0 06 48 29 C8 4C 01 F8 48 89 50 10 4C 89 40 18 49 8B 47 08 48 83 38 00 48 8B 68 28 74 0D 48 C1 CD 11 64 48 33 2C 25 30 00 00 00 48 85 DB 0F 84 DB 00 00 00 4C 8B 2B 4D 85 ED 0F 84 CF 00 00 00 48 83 7C 24 20 00 0F 84 5A 01 00 00 48 8B 4C 24 20 48 83 39 00 0F 84 4B 01 00 00 49 8D 47 10 48 89 44 24 28 EB 04 90 49 89 D5 48 89 EF E8 ?? ?? ?? ?? 49 8B 7F 08 45 31 C0 C7 44 24 08 00 00 00 00 C7 04 24 00 00 00 00 4D 89 F1 4C 89 E1 48 89 DA 48 8B 74 24 28 FF D5 83 F8 04 75 18 48 8B 13 4C 39 EA 74 10 49 8B 4F 08 48 63 49 48 48 01 D1 49 39 CC 73 B2 48 8B 4C 24 20 48 83 39 00 74 22 48 8B 4C 24 18 48 8B 54 24 18 48 C1 E1 03 48 C1 E2 06 48 29 CA 48 8B 4C 24 20 49 8B 54 17 10 48 89 11 48 83 C4 38 5B 5D 41 5C 41 5D 41 5E 41 5F C3 66 0F 1F 44 00 00 48 83 C4 38 B8 08 00 00 00 5B 5D 41 5C 41 5D 41 5E 41 5F C3 0F 1F 40 00 48 89 EF E8 ?? ?? ?? ?? 48 8B 54 24 18 48 8B 44 24 18 49 8D 77 10 49 8B 7F 08 4D 89 F1 48 C1 E2 03 48 C1 E0 06 48 29 D0 4C 01 F8 48 83 78 10 01 C7 44 24 08 00 00 00 00 19 C0 45 31 C0 31 C9 F7 D0 31 D2 83 C0 02 89 04 24 FF D5 85 C0 75 1F 4C 89 F9 31 D2 0F 1F 40 00 C7 41 24 00 00 00 00 48 83 C2 01 48 83 C1 38 48 39 54 24 18 73 EA 48 83 7C 24 20 00 0F 85 2C FF FF FF 48 83 C4 38 5B 5D 41 5C 41 5D 41 5E 41 5F C3 0F 1F 80 00 00 00 00 31 D2 E9 4A FE FF FF B9 ?? ?? ?? ?? BA 4A 00 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? B9 ?? ?? ?? ?? BA 2C 00 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_217_0_0 {
	meta:
		name = "_L_lock_74"
		size = 27
		refs = "000b __lll_lock_wait_private"
	strings:
		$1 = { 49 8D 38 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 96 FD FF FF }
	condition:
		$1
}

rule file_217_1_0 {
	meta:
		name = "_L_unlock_277"
		size = 27
		refs = "000b __lll_unlock_wake_private"
	strings:
		$1 = { 48 8D 3A 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 FC FE FF FF }
	condition:
		$1
}

rule file_461_0_0 {
	meta:
		name = "_L_lock_55"
		size = 27
		refs = "000b __lll_lock_wait_private"
	strings:
		$1 = { 48 8D 3A 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 FC FE FF FF }
	condition:
		$1
}

rule file_217_3_0 {
	meta:
		name = "_IO_getdelim"
		size = 711
		refs = "005a __libc_multiple_threads 00ba malloc 00ff realloc 012c memcpy 0141 __underflow 016c memchr 025a __libc_errno 02c3 _Unwind_Resume"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 53 48 83 EC 28 48 85 F6 48 89 74 24 10 89 54 24 1C 0F 84 37 02 00 00 48 85 FF 0F 84 2E 02 00 00 8B 11 49 89 FD 48 89 CB 89 D0 41 89 D4 25 00 80 00 00 75 50 4C 8B 81 88 00 00 00 64 4C 8B 0C 25 10 00 00 00 4D 3B 48 08 74 32 BE 01 00 00 00 83 3D ?? ?? ?? ?? 00 74 0D F0 41 0F B1 30 0F 85 5B 02 00 00 EB 0A 41 0F B1 30 0F 85 4F 02 00 00 4C 8B 83 88 00 00 00 8B 13 4D 89 48 08 41 83 40 04 01 41 89 D4 83 E2 20 0F 85 22 01 00 00 49 83 7D 00 00 74 0B 48 8B 44 24 10 48 83 38 00 75 23 48 8B 4C 24 10 BF 78 00 00 00 48 C7 01 78 00 00 00 E8 ?? ?? ?? ?? 48 85 C0 49 89 45 00 0F 84 ED 00 00 00 4C 8B 43 08 4C 8B 7B 10 4D 29 C7 4D 85 FF 0F 8E 46 01 00 00 45 31 E4 EB 78 0F 1F 40 00 48 01 D2 49 8B 7D 00 48 39 D0 48 0F 43 D0 48 89 D6 48 89 54 24 08 E8 ?? ?? ?? ?? 48 85 C0 48 8B 54 24 08 0F 84 27 01 00 00 48 8B 4C 24 10 49 89 45 00 4C 8B 43 08 48 89 11 4A 8D 3C 20 4C 89 FA 4C 89 C6 E8 ?? ?? ?? ?? 4C 01 7B 08 4D 85 F6 0F 85 DB 00 00 00 48 89 DF E8 ?? ?? ?? ?? 83 F8 FF 0F 84 CA 00 00 00 4C 8B 43 08 4C 8B 7B 10 49 89 EC 4D 29 C7 8B 74 24 1C 4C 89 C7 4C 89 FA 4C 89 44 24 08 E8 ?? ?? ?? ?? 48 85 C0 49 89 C6 4C 8B 44 24 08 74 0A 48 89 C1 4C 29 C1 4C 8D 79 01 4B 8D 2C 3C 48 83 FD FF 0F 8C D9 00 00 00 48 8B 4C 24 10 48 8D 45 01 48 8B 11 48 39 D0 0F 87 3E FF FF FF 49 8B 45 00 E9 6E FF FF FF 0F 1F 44 00 00 48 C7 C5 FF FF FF FF 41 81 E4 00 80 00 00 75 38 48 8B 93 88 00 00 00 83 6A 04 01 75 2B 48 C7 42 08 00 00 00 00 83 3D ?? ?? ?? ?? 00 74 0B F0 FF 0A 0F 85 F3 00 00 00 EB 08 FF 0A 0F 85 E9 00 00 00 0F 1F 80 00 00 00 00 48 83 C4 28 48 89 E8 5B 5D 41 5C 41 5D 41 5E 41 5F C3 66 0F 1F 44 00 00 49 8B 45 00 C6 04 28 00 44 8B 23 EB 9A 48 89 DF E8 ?? ?? ?? ?? 83 F8 FF 75 15 66 0F 1F 44 00 00 44 8B 23 48 C7 C5 FF FF FF FF E9 78 FF FF FF 4C 8B 43 08 4C 8B 7B 10 4D 29 C7 E9 88 FE FF FF 48 8B 05 ?? ?? ?? ?? 48 C7 C5 FF FF FF FF 64 C7 00 16 00 00 00 EB 92 48 8B 05 ?? ?? ?? ?? 44 8B 23 48 C7 C5 FF FF FF FF 64 C7 00 4B 00 00 00 E9 34 FF FF FF F7 03 00 80 00 00 48 89 C6 75 29 48 8B 93 88 00 00 00 83 6A 04 01 75 1C 48 C7 42 08 00 00 00 00 83 3D ?? ?? ?? ?? 00 74 07 F0 FF 0A 75 44 EB 04 FF 0A 75 3E 48 89 F7 E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_218_0_0 {
	meta:
		name = "check_match.11274"
		size = 393
		refs = "0062 strcmp 0164 _dl_name_match_p 0185 __assert_fail"
	strings:
		$1 = { 48 89 5C 24 E0 48 89 6C 24 E8 48 89 FB 4C 89 64 24 F0 4C 89 6C 24 F8 48 83 EC 28 0F B6 47 04 4C 89 D5 83 E0 0F 48 83 7F 08 00 0F 84 15 01 00 00 31 D2 66 83 7B 06 00 0F 94 C2 85 55 3C 0F 85 E5 00 00 00 BA 67 04 00 00 0F A3 C2 0F 83 D7 00 00 00 48 3B 5D 28 74 17 8B 3B 48 8B 75 18 48 03 7D 20 E8 ?? ?? ?? ?? 85 C0 0F 85 BA 00 00 00 4C 8B 65 08 48 8B 75 10 4D 85 E4 48 8B 86 30 03 00 00 74 66 48 85 C0 0F 84 CA 00 00 00 8B 55 38 44 0F B7 2C 50 4C 89 E8 25 FF 7F 00 00 48 8D 14 40 48 8B 86 E0 02 00 00 48 8D 04 D0 8B 68 08 41 3B 6C 24 08 74 7C 41 8B 44 24 0C 85 C0 75 6B 85 ED 75 67 66 45 85 ED 78 61 48 89 D8 48 8B 6C 24 10 48 8B 5C 24 08 4C 8B 64 24 18 4C 8B 6C 24 20 48 83 C4 28 C3 0F 1F 44 00 00 48 85 C0 74 DA 8B 55 38 0F B7 14 50 8B 45 34 C1 E0 1E C1 F8 1F 89 D1 81 E1 FF 7F 00 00 83 C0 03 39 C8 7F BB 66 85 D2 78 17 8B 45 30 8D 50 01 85 C0 89 55 30 75 0A 48 89 5D 00 66 0F 1F 44 00 00 31 DB EB 9B 0F 1F 40 00 49 8B 34 24 48 8B 38 E8 ?? ?? ?? ?? 85 C0 74 87 E9 6F FF FF FF 3C 06 0F 84 E3 FE FF FF 31 DB 90 E9 72 FF FF FF 49 8B 7C 24 10 48 85 FF 0F 84 64 FF FF FF E8 ?? ?? ?? ?? 85 C0 0F 84 57 FF FF FF B9 ?? ?? ?? ?? BA A7 00 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_218_1_0 {
	meta:
		name = "do_lookup_x"
		size = 2245
		refs = "00c8 _dl_debug_mask 0188 _dl_name_match_p 0222 _dl_dynamic_weak 0263 __pthread_mutex_lock 026e _dl_ns 0323 strcmp 035a __pthread_mutex_unlock 04fb _dl_higher_prime_number 050b calloc 05f3 free 0674 _dl_argv 0697 _dl_debug_printf 0827 _dl_dprintf 0831 _exit"
	strings:
		$1 = { 41 57 49 89 D7 41 56 41 55 41 54 55 53 48 89 F3 48 81 EC A8 00 00 00 45 8B 69 08 48 8B 84 24 E8 00 00 00 4C 89 44 24 30 4C 8B A4 24 E0 00 00 00 4C 8B 84 24 F8 00 00 00 48 89 7C 24 78 48 89 8C 24 88 00 00 00 48 89 44 24 68 8B 84 24 F0 00 00 00 89 84 24 94 00 00 00 8B 84 24 00 01 00 00 89 84 24 9C 00 00 00 89 F0 4D 8B 31 49 89 F1 83 E0 3F 49 C1 E9 06 41 89 C3 4B 8B 04 E6 C7 84 24 90 00 00 00 00 00 00 00 48 C7 44 24 60 00 00 00 00 48 8B 78 28 4C 39 C7 48 89 7C 24 70 0F 84 06 01 00 00 F6 84 24 9C 00 00 00 02 74 0D F6 87 14 03 00 00 03 0F 84 EF 00 00 00 F6 87 15 03 00 00 20 0F 85 E2 00 00 00 F6 05 ?? ?? ?? ?? 08 0F 85 91 05 00 00 8B 87 EC 02 00 00 85 C0 0F 84 C7 00 00 00 48 8B 57 70 48 8B 6A 08 48 8B 57 68 48 8B 52 08 48 89 94 24 80 00 00 00 48 8B 97 F8 02 00 00 48 85 D2 0F 84 65 06 00 00 8B 8F F0 02 00 00 49 89 DA 44 21 C9 48 8B 34 CA 44 89 D9 48 89 F2 48 D3 EA 8B 8F F4 02 00 00 49 D3 EA 4C 89 D1 83 E1 3F 48 D3 EE 48 21 F2 83 E2 01 0F 85 7D 05 00 00 C7 84 24 98 00 00 00 00 00 00 00 83 BC 24 90 00 00 00 01 74 7B 8B 94 24 98 00 00 00 85 D2 75 48 48 8B 44 24 68 48 85 C0 74 3E 48 8B 78 10 48 85 FF 74 35 48 8B 74 24 70 4C 89 44 24 10 4C 89 4C 24 18 44 88 5C 24 08 E8 ?? ?? ?? ?? 85 C0 4C 8B 44 24 10 4C 8B 4C 24 18 44 0F B6 5C 24 08 0F 85 11 05 00 00 0F 1F 40 00 49 83 C4 01 4D 39 E5 0F 87 C3 FE FF FF 31 C0 48 81 C4 A8 00 00 00 5B 5D 41 5C 41 5D 41 5E 41 5F C3 0F 1F 80 00 00 00 00 48 8B 44 24 60 48 85 C0 0F 84 77 FF FF FF 0F B6 50 04 C0 EA 04 80 FA 02 74 36 80 FA 0A 74 61 80 FA 01 0F 85 5D FF FF FF 48 89 44 24 50 48 8B 44 24 50 48 8B 4C 24 30 48 89 01 48 8B 44 24 70 48 89 41 08 B8 01 00 00 00 EB 9D 66 0F 1F 44 00 00 8B 0D ?? ?? ?? ?? 85 C9 74 CE 48 8B 54 24 30 48 83 3A 00 0F 85 1C FF FF FF 48 89 02 48 8B 44 24 70 48 89 42 08 E9 0B FF FF FF 66 0F 1F 44 00 00 48 89 44 24 50 48 8B 44 24 70 48 8B 40 30 4C 8D 2C C0 B8 ?? ?? ?? ?? 49 C1 E5 04 49 81 C5 ?? ?? ?? ?? 48 85 C0 4C 89 6C 24 40 74 05 4C 89 EF FF D0 48 8B 54 24 40 48 8B 4C 24 40 48 8B 52 28 4C 8B 69 30 48 85 D2 48 89 54 24 48 0F 84 79 03 00 00 48 89 D8 31 D2 49 8D 4D FE 49 F7 F5 48 89 D8 4C 8B 54 24 78 48 89 4C 24 58 4C 89 54 24 38 49 89 D7 31 D2 48 F7 F1 48 89 D9 4C 89 EB 4C 8D 62 01 4D 89 E6 4D 89 E5 49 C1 E6 05 4B 8D 6C 3D 00 49 C1 E7 05 4C 03 7C 24 48 EB 1E 0F 1F 44 00 00 4D 85 E4 0F 84 97 00 00 00 4D 01 F7 48 39 EB 4A 8D 44 2D 00 76 7A 48 89 C5 41 8B 07 4D 8B 67 08 48 39 C8 75 DB 48 8B 74 24 38 4C 89 E7 48 89 4C 24 20 E8 ?? ?? ?? ?? 85 C0 48 8B 4C 24 20 75 C0 F6 84 24 9C 00 00 00 02 0F 84 C3 02 00 00 48 8B 44 24 30 48 8B 54 24 50 48 8B 4C 24 30 48 89 10 48 8B 44 24 70 48 89 41 08 B8 ?? ?? ?? ?? 48 85 C0 0F 84 CE 04 00 00 48 8B 7C 24 40 FF D0 B8 01 00 00 00 E9 3F FE FF FF 0F 1F 84 00 00 00 00 00 49 89 EF 49 29 DF E9 50 FF FF FF 0F 1F 44 00 00 48 8B 44 24 40 49 89 DD 48 89 CB 4B 8D 54 6D 00 48 8B 40 38 48 89 44 24 28 48 C1 E0 02 48 39 C2 0F 86 40 01 00 00 48 8B 44 24 50 41 89 D9 8B 38 48 03 BC 24 80 00 00 00 F6 84 24 9C 00 00 00 02 0F 84 95 00 00 00 89 DB 31 D2 4C 8B 84 24 88 00 00 00 48 89 D8 48 8B 4C 24 48 49 F7 F5 48 89 D8 48 89 D6 31 D2 48 F7 74 24 58 4C 8D 52 01 4D 89 D3 49 C1 E3 05 48 89 F0 48 C1 E0 05 48 8D 44 01 08 0F 1F 80 00 00 00 00 48 83 38 00 48 8D 50 F8 74 10 4C 01 D6 4C 01 D8 49 39 F5 77 EB 4C 29 EE EB D3 44 89 48 F8 48 89 38 4C 89 40 08 48 8B 84 24 08 01 00 00 48 89 42 18 48 8B 54 24 40 B8 ?? ?? ?? ?? 48 83 42 38 01 48 85 C0 0F 84 9C FD FF FF 48 89 D7 FF D0 E9 92 FD FF FF 89 DB 31 D2 4C 8B 44 24 70 48 89 D8 48 8B 4C 24 48 49 F7 F5 48 89 D8 48 89 D6 31 D2 48 F7 74 24 58 4C 8D 52 01 4D 89 D3 49 C1 E3 05 48 89 F0 48 C1 E0 05 48 8D 44 01 08 0F 1F 44 00 00 48 83 38 00 48 8D 50 F8 74 10 4C 01 D6 4C 01 D8 49 39 F5 77 EB 4C 29 EE EB D5 44 89 48 F8 48 89 38 48 8B 44 24 50 4C 89 42 18 48 89 42 10 41 0F B6 80 14 03 00 00 83 E0 03 3C 02 0F 85 60 FF FF FF 41 83 88 D4 03 00 00 08 E9 53 FF FF FF 49 8D 7D 01 E8 ?? ?? ?? ?? BF 20 00 00 00 48 89 C6 49 89 C6 E8 ?? ?? ?? ?? 48 85 C0 49 89 C2 0F 84 EE 02 00 00 49 8D 4E FE 4D 85 ED 48 89 4C 24 58 0F 84 9B 00 00 00 48 8B 74 24 48 4C 89 E9 4C 8B 5C 24 58 48 C1 E1 05 49 89 F5 49 01 CD 0F 1F 40 00 4C 8B 46 08 4D 85 C0 74 6E 44 8B 0E 31 D2 48 8B 6E 18 4C 8B 66 10 44 89 CF 48 89 F8 49 F7 F6 48 89 F8 48 89 D1 31 D2 49 F7 F3 48 83 C2 01 49 89 D7 49 C1 E7 05 48 89 C8 48 C1 E0 05 49 8D 44 02 08 0F 1F 80 00 00 00 00 48 83 38 00 74 1A 48 01 D1 4C 01 F8 49 39 CE 77 EF 4C 29 F1 EB D7 66 2E 0F 1F 84 00 00 00 00 00 44 89 48 F8 4C 89 00 4C 89 60 08 48 89 68 10 48 83 C6 20 4C 39 EE 75 80 48 8B 4C 24 40 4C 89 54 24 20 4D 89 F5 48 8B 7C 24 48 FF 51 40 48 8B 44 24 40 4C 8B 54 24 20 4C 89 70 30 4C 89 50 28 48 C7 40 40 ?? ?? ?? ?? 4C 89 54 24 48 E9 B5 FD FF FF 49 8B 47 10 4C 8B 54 24 30 49 89 02 49 8B 47 18 49 89 42 08 E9 3F FD FF FF BE 1F 00 00 00 BF 20 00 00 00 E8 ?? ?? ?? ?? 48 85 C0 48 89 44 24 48 0F 84 D2 01 00 00 48 8B 54 24 40 48 C7 44 24 58 1D 00 00 00 41 BD 1F 00 00 00 48 89 42 28 48 C7 42 30 1F 00 00 00 48 C7 42 40 ?? ?? ?? ?? E9 52 FD FF FF 48 8B 57 08 48 8B 4F 30 80 3A 00 75 0A 48 8B 05 ?? ?? ?? ?? 48 8B 10 48 8B 74 24 78 BF ?? ?? ?? ?? 31 C0 4C 89 44 24 10 4C 89 4C 24 18 44 88 5C 24 08 E8 ?? ?? ?? ?? 48 8B 7C 24 70 44 0F B6 5C 24 08 4C 8B 4C 24 18 4C 8B 44 24 10 E9 1E FA FF FF 83 C8 FF E9 FA FA FF FF 89 C1 31 D2 48 89 D8 48 F7 F1 48 8B 87 00 03 00 00 8B 04 90 85 C0 0F 84 67 FA FF FF 48 8B 97 08 03 00 00 48 8D 14 82 EB 16 66 2E 0F 1F 84 00 00 00 00 00 48 83 C2 04 A8 01 0F 85 44 FA FF FF 8B 02 89 C1 48 31 D9 48 D1 E9 75 E8 48 8B 44 24 70 48 89 D1 4C 8D 54 24 60 48 2B 88 08 03 00 00 48 89 54 24 20 4C 89 44 24 10 4C 89 4C 24 18 44 88 5C 24 08 48 89 C8 48 C1 F8 02 89 84 24 98 00 00 00 89 C0 48 6B F8 18 48 01 EF E8 24 F7 FF FF 48 85 C0 48 8B 54 24 20 4C 8B 44 24 10 4C 8B 4C 24 18 44 0F B6 5C 24 08 0F 85 74 FA FF FF 8B 02 EB 82 41 BA FF FF FF FF 4D 39 17 0F 84 C2 00 00 00 89 C1 49 8B 07 31 D2 48 F7 F1 48 8B 87 08 03 00 00 8B 04 90 85 C0 89 84 24 98 00 00 00 75 31 E9 AA F9 FF FF 0F 1F 80 00 00 00 00 48 8B 44 24 70 8B 94 24 98 00 00 00 48 8B 80 00 03 00 00 8B 04 90 85 C0 89 84 24 98 00 00 00 0F 84 7E F9 FF FF 48 8D 04 40 4C 8D 54 24 60 4C 89 44 24 10 4C 89 4C 24 18 44 88 5C 24 08 48 8D 7C C5 00 E8 81 F6 FF FF 48 85 C0 4C 8B 44 24 10 4C 8B 4C 24 18 44 0F B6 5C 24 08 74 A4 E9 D5 F9 FF FF B8 ?? ?? ?? ?? 48 85 C0 74 07 48 8B 7C 24 40 FF D0 BF 02 00 00 00 BE ?? ?? ?? ?? 31 C0 E8 ?? ?? ?? ?? BF 7F 00 00 00 E8 ?? ?? ?? ?? B8 01 00 00 00 E9 78 F9 FF FF 48 8B 4C 24 78 0F B6 11 48 85 D2 74 6F 0F B6 71 01 40 84 F6 74 66 48 C1 E2 04 48 01 F2 0F B6 71 02 40 84 F6 74 56 48 C1 E2 04 48 01 F2 0F B6 71 03 40 84 F6 74 46 48 C1 E2 04 48 01 F2 0F B6 71 04 40 84 F6 74 36 48 C1 E2 04 48 83 C1 05 48 01 F2 0F B6 31 40 84 F6 74 1D 48 C1 E2 04 48 83 C1 01 48 01 D6 48 89 F2 81 E2 00 00 00 F0 48 C1 EA 18 48 31 F2 EB DB 81 E2 FF FF FF 0F 89 D2 49 89 17 E9 B8 FE FF FF }
	condition:
		$1
}

rule file_218_2_0 {
	meta:
		name = "_dl_lookup_symbol_x"
		size = 2908
		refs = "0191 _dl_debug_mask 036f strlen 03ac stpcpy 03bf _dl_argv 03e0 _dl_signal_cerror 0520 _dl_debug_printf 0539 _dl_debug_printf_c 061b __assert_fail 06b8 __pthread_mutex_lock 06d0 _dl_load_lock 06f3 _dl_ns 072e __pthread_mutex_unlock 07b9 _dl_lookup_symbol_x 09e1 malloc 0a44 memcpy 0a9c _dl_scope_free"
	strings:
		$1 = { 55 48 89 E5 41 57 45 89 CF 41 56 41 55 49 89 F5 41 54 4D 89 C4 53 48 89 D3 48 81 EC 08 01 00 00 0F B6 07 48 89 BD 58 FF FF FF 48 89 8D 48 FF FF FF 84 C0 0F 84 5F 02 00 00 48 89 FA 41 BE 05 15 00 00 66 0F 1F 44 00 00 4C 89 F1 48 83 C2 01 48 C1 E1 05 49 01 CE 49 01 C6 0F B6 02 84 C0 75 E8 45 89 F6 4C 89 B5 50 FF FF FF 41 B8 FF FF FF FF 4D 85 E4 48 C7 85 70 FF FF FF 00 00 00 00 4C 89 85 68 FF FF FF 48 C7 85 78 FF FF FF 00 00 00 00 74 0D F7 45 10 FA FF FF FF 0F 85 67 05 00 00 48 83 7D 18 00 48 8B 8D 48 FF FF FF 4C 8B 09 0F 85 3C 03 00 00 4D 85 C9 48 C7 85 40 FF FF FF 00 00 00 00 0F 84 81 04 00 00 48 8B 85 40 FF FF FF 4C 8B B5 48 FF FF FF EB 1C 0F 1F 84 00 00 00 00 00 0F 85 EA 01 00 00 49 83 C6 08 4D 8B 0E 31 C0 4D 85 C9 74 4C 48 8B 75 18 8B 55 10 4C 8D 85 70 FF FF FF 48 8B 0B 48 8B BD 58 FF FF FF 4C 89 6C 24 28 44 89 7C 24 20 48 89 74 24 18 48 8B B5 50 FF FF FF 89 54 24 10 48 8D 95 68 FF FF FF 4C 89 64 24 08 48 89 04 24 E8 F5 F5 FF FF 83 F8 00 7E A0 48 8B 85 70 FF FF FF 48 85 C0 0F 84 F9 03 00 00 48 8B 0B 48 85 C9 74 0B 0F B6 41 05 83 E0 03 3C 03 74 5D 4C 8B B5 78 FF FF FF 45 31 C9 41 0F B6 86 14 03 00 00 83 E0 03 3C 02 0F 84 B4 02 00 00 41 8B B6 CC 03 00 00 85 F6 0F 84 95 02 00 00 8B 05 ?? ?? ?? ?? A9 04 08 00 00 0F 85 17 03 00 00 48 8B 85 70 FF FF FF 48 89 03 48 8D 65 D8 4C 89 F0 5B 41 5C 41 5D 41 5E 41 5F 5D C3 0F 1F 40 00 41 83 FF 01 0F 84 DE 00 00 00 48 8B 85 48 FF FF FF 48 C7 45 80 00 00 00 00 48 C7 45 88 00 00 00 00 4C 8B 08 4D 85 C9 0F 84 2B 02 00 00 48 8B 85 40 FF FF FF 4C 8B B5 48 FF FF FF EB 14 0F 1F 00 49 83 C6 08 4D 8B 0E 4D 85 C9 74 51 48 8B 0B 31 C0 8B 75 10 48 8B 55 18 4C 8D 45 80 48 8B BD 58 FF FF FF 48 C7 44 24 28 00 00 00 00 C7 44 24 20 01 00 00 00 4C 89 64 24 08 89 74 24 10 48 8B B5 50 FF FF FF 48 89 54 24 18 48 8D 95 68 FF FF FF 48 89 04 24 E8 D7 F4 FF FF 85 C0 74 A3 48 8B 45 80 48 85 C0 0F 84 AE 01 00 00 4C 39 6D 88 0F 84 A4 01 00 00 48 8B 03 4C 89 AD 78 FF FF FF 4D 89 EE 48 89 85 70 FF FF FF 41 B9 01 00 00 00 E9 DA FE FF FF 0F 1F 44 00 00 48 C7 85 50 FF FF FF 05 15 00 00 E9 C2 FD FF FF 4C 8B B5 78 FF FF FF 4D 39 EE 74 D4 48 89 8D 70 FF FF FF 4C 89 AD 78 FF FF FF 4D 89 EE 41 B9 01 00 00 00 E9 9D FE FF FF 48 83 7D 18 00 0F 85 0B FE FF FF 4D 85 E4 0F 84 43 03 00 00 4D 85 ED 0F 84 32 03 00 00 4D 8B 6D 08 49 8B 14 24 48 8B 8D 58 FF FF FF 83 F8 FE B8 ?? ?? ?? ?? 48 C7 45 90 ?? ?? ?? ?? 48 C7 45 A0 ?? ?? ?? ?? 48 C7 45 B0 ?? ?? ?? ?? 48 C7 45 C0 ?? ?? ?? ?? 4C 8D 7D D0 48 89 55 A8 49 8B 54 24 10 4C 8D 65 98 48 89 4D 98 4D 89 E6 48 89 55 B8 BA ?? ?? ?? ?? 48 0F 45 D0 B8 07 00 00 00 48 89 55 C8 BA 01 00 00 00 EB 21 0F 1F 80 00 00 00 00 49 8B 3E 48 89 95 20 FF FF FF 49 83 C6 08 E8 ?? ?? ?? ?? 48 8B 95 20 FF FF FF 48 01 C2 4D 39 FE 75 DE 48 83 C2 1E BE ?? ?? ?? ?? 48 83 E2 F0 48 29 D4 4C 8D 74 24 3F 49 83 E6 F0 4C 89 F0 EB 08 49 8B 34 24 49 83 C4 08 48 89 C7 E8 ?? ?? ?? ?? 4D 39 FC 75 EB 41 80 7D 00 00 75 16 48 8B 05 ?? ?? ?? ?? 4C 8B 28 B8 ?? ?? ?? ?? 4D 85 ED 4C 0F 44 E8 4C 89 F1 BA ?? ?? ?? ?? 4C 89 EE 31 FF E8 ?? ?? ?? ?? E9 7A 01 00 00 0F 1F 80 00 00 00 00 49 8B 01 48 8B 75 18 31 D2 48 39 30 74 0E 48 83 C2 01 48 8B 4D 18 48 39 0C D0 75 F2 48 89 95 40 FF FF FF E9 B0 FC FF FF 4C 8B B5 78 FF FF FF E9 64 FE FF FF 41 C7 86 CC 03 00 00 01 00 00 00 E9 5B FD FF FF F6 45 10 01 0F 84 42 FD FF FF 4D 39 F5 0F 84 38 02 00 00 41 F6 86 D4 03 00 00 08 0F 85 2B FD FF FF 49 8B 85 C0 03 00 00 48 89 85 50 FF FF FF 49 8B 95 B8 03 00 00 48 85 D2 48 89 95 40 FF FF FF 0F 84 C6 01 00 00 48 8B 12 48 85 D2 0F 84 BA 01 00 00 31 C0 49 39 D6 74 1E 48 8B B5 40 FF FF FF 83 C0 01 89 C2 48 8B 14 D6 48 85 D2 0F 84 9A 01 00 00 49 39 D6 75 E2 4C 8B B5 78 FF FF FF E9 C9 FC FF FF A8 04 49 8B 75 08 0F 84 DD FC FF FF 49 8B 4E 08 45 85 C9 BF ?? ?? ?? ?? B8 ?? ?? ?? ?? 4D 8B 46 30 48 0F 44 F8 80 39 00 75 0A 48 8B 05 ?? ?? ?? ?? 48 8B 08 80 3E 00 49 8B 55 30 75 16 48 8B 05 ?? ?? ?? ?? 48 8B 30 B8 ?? ?? ?? ?? 48 85 F6 48 0F 44 F0 48 8B 85 58 FF FF FF 49 89 F9 BF ?? ?? ?? ?? 48 89 04 24 31 C0 E8 ?? ?? ?? ?? 4D 85 E4 0F 84 B8 03 00 00 49 8B 34 24 BF ?? ?? ?? ?? 31 C0 E8 ?? ?? ?? ?? 4C 8B B5 78 FF FF FF E9 57 FC FF FF 48 8B 03 48 85 C0 74 0B 0F B6 40 04 C0 E8 04 3C 02 74 07 48 83 7D 18 00 74 0F 48 C7 03 00 00 00 00 45 31 F6 E9 38 FC FF FF F6 05 ?? ?? ?? ?? 01 75 E8 4D 85 ED 0F 84 49 05 00 00 4D 8B 6D 08 4D 85 E4 0F 84 2F 05 00 00 49 8B 04 24 B9 ?? ?? ?? ?? BA ?? ?? ?? ?? 48 85 C0 48 0F 44 C1 48 8B B5 58 FF FF FF 4C 8D 65 90 4C 8D 7D 90 48 89 55 A0 48 89 45 A8 BA 01 00 00 00 49 83 C4 08 48 C7 45 90 ?? ?? ?? ?? 49 83 C7 20 48 89 75 98 4D 89 E6 B8 12 00 00 00 48 01 C2 4D 39 FE 0F 84 9E 02 00 00 49 8B 3E 48 89 95 20 FF FF FF 49 83 C6 08 E8 ?? ?? ?? ?? 48 8B 95 20 FF FF FF EB D8 B9 ?? ?? ?? ?? BA D7 02 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 45 31 ED E9 CA FC FF FF B9 ?? ?? ?? ?? BA ED 02 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 BD 50 FF FF FF 00 74 3D 48 8B 85 50 FF FF FF 44 8B 00 45 85 C0 74 31 4C 3B 70 08 0F 84 48 FE FF FF 48 89 C2 31 C0 83 C0 01 44 39 C0 74 1A 48 83 C2 08 4C 3B 72 08 75 EE E9 2C FE FF FF 4D 89 EE E9 F9 FA FF FF 45 31 C0 8B 4D 10 49 8B 96 60 04 00 00 83 E1 04 48 89 95 38 FF FF FF 48 63 F1 89 8D 34 FF FF FF 48 85 F6 48 89 B5 28 FF FF FF 0F 85 0E 01 00 00 B8 ?? ?? ?? ?? 48 85 C0 74 23 44 89 85 10 FF FF FF 44 89 8D 08 FF FF FF BF ?? ?? ?? ?? FF D0 44 8B 8D 08 FF FF FF 44 8B 85 10 FF FF FF 49 8B 45 30 48 8D 04 C0 48 C1 E0 04 48 8B 80 ?? ?? ?? ?? 4C 39 F0 74 0E 48 85 C0 74 09 48 8B 40 18 4C 39 F0 75 F2 48 85 C0 BA FF FF FF FF 74 19 48 8B 85 38 FF FF FF 49 3B 86 60 04 00 00 0F 84 D5 01 00 00 BA FF FF FF FF B8 ?? ?? ?? ?? 48 85 C0 74 21 89 95 20 FF FF FF 44 89 8D 08 FF FF FF BF ?? ?? ?? ?? FF D0 44 8B 8D 08 FF FF FF 8B 95 20 FF FF FF 48 83 BD 28 FF FF FF 00 74 0C 64 C7 04 25 1C 00 00 00 01 00 00 00 83 FA FF 0F 85 34 FD FF FF 8B BD 34 FF FF FF 85 FF 74 0E 49 8B 8D 80 03 00 00 48 89 8D 48 FF FF FF 48 8B 75 18 8B 45 10 45 89 F9 48 8B 8D 48 FF FF FF 48 8B BD 58 FF FF FF 4D 89 E0 48 89 DA 48 89 74 24 08 89 04 24 4C 89 EE E8 ?? ?? ?? ?? 49 89 C6 E9 E5 F9 FF FF 31 C0 64 87 04 25 1C 00 00 00 83 F8 02 75 21 BA 01 00 00 00 64 48 8B 3C 25 10 00 00 00 64 8B 34 25 48 00 00 00 48 83 C7 1C 83 CE 01 B0 CA 0F 05 B8 ?? ?? ?? ?? 48 85 C0 74 23 44 89 85 10 FF FF FF 44 89 8D 08 FF FF FF BF ?? ?? ?? ?? FF D0 44 8B 8D 08 FF FF FF 44 8B 85 10 FF FF FF 4C 89 F0 49 8B 95 B8 03 00 00 48 39 95 40 FF FF FF 49 89 C6 0F 84 9C 02 00 00 48 85 D2 0F 84 93 02 00 00 48 8B 0A 48 85 C9 0F 84 87 02 00 00 48 39 C8 74 19 31 C9 83 C1 01 89 CE 48 8B 34 F2 48 85 F6 0F 84 6E 02 00 00 48 39 F0 75 E9 48 8B B5 38 FF FF FF 48 3B B0 60 04 00 00 0F 85 A5 FE FF FF E9 9A 00 00 00 48 83 C2 1E BE ?? ?? ?? ?? 48 83 E2 F0 48 29 D4 4C 8D 74 24 3F 49 83 E6 F0 4C 89 F0 48 89 C7 E8 ?? ?? ?? ?? 4D 39 FC 74 0A 49 8B 34 24 49 83 C4 08 EB E9 41 80 7D 00 00 75 16 48 8B 05 ?? ?? ?? ?? 4C 8B 28 B8 ?? ?? ?? ?? 4D 85 ED 4C 0F 44 E8 4C 89 F1 BA ?? ?? ?? ?? E9 F5 FA FF FF BF ?? ?? ?? ?? 31 C0 E8 ?? ?? ?? ?? 4C 8B B5 78 FF FF FF E9 A3 F8 FF FF 41 8B 96 D4 03 00 00 F6 C2 08 75 19 41 0F B6 85 14 03 00 00 83 E0 03 3C 02 74 11 83 CA 08 41 89 96 D4 03 00 00 31 D2 E9 04 FE FF FF 41 F6 85 D4 03 00 00 08 75 E5 41 8B 85 C8 03 00 00 44 39 C0 76 75 49 8B 85 C0 03 00 00 44 89 C2 4C 89 74 D0 08 49 8B 85 C0 03 00 00 41 83 C0 01 44 89 00 F6 05 ?? ?? ?? ?? 40 74 BD 49 8B 4D 08 4D 8B 45 30 80 39 00 75 0A 48 8B 05 ?? ?? ?? ?? 48 8B 08 49 8B 76 08 49 8B 56 30 80 3E 00 75 0A 48 8B 05 ?? ?? ?? ?? 48 8B 30 BF ?? ?? ?? ?? 31 C0 44 89 8D 08 FF FF FF E8 ?? ?? ?? ?? 31 D2 44 8B 8D 08 FF FF FF E9 79 FD FF FF 85 C0 0F 84 F0 00 00 00 01 C0 48 8D 3C C5 08 00 00 00 89 85 50 FF FF FF 89 95 20 FF FF FF 44 89 85 10 FF FF FF 44 89 8D 08 FF FF FF E8 ?? ?? ?? ?? 48 85 C0 48 89 C1 8B 95 20 FF FF FF 44 8B 85 10 FF FF FF 44 8B 8D 08 FF FF FF 0F 84 13 FF FF FF 45 31 D2 45 85 C0 74 57 49 8B B5 C0 03 00 00 45 89 C2 48 8D 78 08 4A 8D 14 D5 00 00 00 00 44 89 85 10 FF FF FF 44 89 8D 08 FF FF FF 4C 89 95 18 FF FF FF 48 89 85 20 FF FF FF 48 83 C6 08 E8 ?? ?? ?? ?? 4C 8B 95 18 FF FF FF 44 8B 8D 08 FF FF FF 44 8B 85 10 FF FF FF 48 8B 8D 20 FF FF FF 41 83 C0 01 4E 89 74 D1 08 44 89 01 49 8B BD C0 03 00 00 49 89 8D C0 03 00 00 8B 8D 50 FF FF FF 48 85 FF 41 89 8D C8 03 00 00 0F 84 C8 FE FF FF 44 89 8D 08 FF FF FF E8 ?? ?? ?? ?? 44 8B 8D 08 FF FF FF E9 B0 FE FF FF BF 58 00 00 00 C7 85 50 FF FF FF 0A 00 00 00 E9 0C FF FF FF BA ?? ?? ?? ?? 48 89 D0 E9 D9 FA FF FF 41 BD ?? ?? ?? ?? E9 B0 FA FF FF 49 8B 95 C0 03 00 00 48 85 D2 0F 84 FC FB FF FF 48 39 95 50 FF FF FF 74 33 44 8B 02 45 85 C0 0F 84 E7 FB FF FF 48 3B 42 08 0F 84 68 FD FF FF 31 C9 83 C1 01 44 39 C1 0F 84 CF FB FF FF 48 83 C2 08 48 3B 42 08 75 EA E9 4B FD FF FF 48 8B 8D 50 FF FF FF 8B 11 44 39 C2 0F 86 AE FB FF FF 48 8B B5 50 FF FF FF 44 89 C1 48 3B 44 CE 08 0F 84 24 FD FF FF 41 83 C0 01 44 39 C2 77 E2 41 89 D0 E9 88 FB FF FF }
	condition:
		$1
}

rule file_218_3_0 {
	meta:
		name = "_dl_setup_hash"
		size = 170
		refs = "00a6 __assert_fail"
	strings:
		$1 = { 48 8B 87 98 02 00 00 48 85 C0 74 57 48 8B 40 08 8B 08 89 8F EC 02 00 00 8B 50 08 44 8B 40 04 8D 72 FF 85 D6 75 69 48 83 C0 10 01 D2 89 B7 F0 02 00 00 8B 70 FC 48 89 87 F8 02 00 00 48 8D 04 90 44 89 C2 48 89 87 00 03 00 00 48 8D 04 88 48 C1 E2 02 89 B7 F4 02 00 00 48 29 D0 48 89 87 08 03 00 00 C3 48 8B 47 60 48 85 C0 74 22 48 8B 40 08 8B 10 48 83 C0 08 48 89 87 08 03 00 00 48 8D 04 90 89 97 EC 02 00 00 48 89 87 00 03 00 00 C3 41 51 B9 ?? ?? ?? ?? BA 6C 03 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_219_0_0 {
	meta:
		name = "capset"
		size = 20
		refs = "000f __syscall_error"
	strings:
		$1 = { B8 7E 00 00 00 0F 05 48 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_221_0_0 {
	meta:
		name = "__strftime_internal"
		size = 7300
		refs = "01d2 memset 031f memcpy 0375 strlen 08cf __tzname 10f9 mktime 14d7 _nl_get_alt_digit 1961 _nl_get_era_entry 1acf __tzset"
	strings:
		$1 = { 41 57 49 89 F2 41 56 41 55 41 54 4D 89 CC 55 53 48 81 EC 08 01 00 00 49 8B 41 10 48 89 4C 24 68 8B 49 08 4C 89 84 24 88 00 00 00 48 89 44 24 78 89 4C 24 74 48 8B 4C 24 68 83 7C 24 74 0C 48 8B 49 30 48 89 8C 24 90 00 00 00 0F 8E 78 02 00 00 83 6C 24 74 0C 0F B6 02 84 C0 0F 84 47 16 00 00 48 89 D3 45 31 ED 48 89 FD 4C 89 54 24 60 EB 35 48 8B 54 24 60 4C 29 EA 48 83 FA 01 0F 86 EE 01 00 00 48 85 ED 74 07 88 45 00 48 83 C5 01 49 83 C5 01 48 89 D8 0F B6 40 01 48 83 C3 01 84 C0 0F 84 8F 01 00 00 3C 25 75 C7 31 D2 C7 44 24 70 00 00 00 00 45 31 DB 48 83 C3 01 0F B6 0B 80 F9 30 74 7E 7F 6C 80 F9 23 0F 84 83 01 00 00 80 F9 2D 74 6E 44 0F BE F1 41 BF FF FF FF FF 41 8D 46 D0 83 F8 09 77 6B 45 31 FF EB 2C 66 0F 1F 44 00 00 0F BE 03 0F 84 97 01 00 00 43 8D 0C BF 44 8D 7C 48 D0 48 83 C3 01 0F B6 0B 44 0F BE F1 41 8D 46 D0 83 F8 09 77 3A 41 81 FF CC CC CC 0C 7E D1 41 BF FF FF FF 7F EB DB 66 0F 1F 84 00 00 00 00 00 80 F9 5E 0F 84 27 01 00 00 80 F9 5F 75 94 66 90 44 0F BE D9 E9 6D FF FF FF 0F 1F 80 00 00 00 00 80 F9 45 0F 84 5F 01 00 00 80 F9 4F 0F 84 56 01 00 00 45 31 F6 80 F9 7A 0F 86 3A 01 00 00 80 F9 25 0F 85 71 01 00 00 49 89 DE 41 B8 01 00 00 00 45 89 FA 31 C0 45 29 C2 41 0F 49 C2 45 8D 3C 00 48 8B 44 24 60 4D 63 FF 4C 29 E8 49 39 C7 0F 83 CC 00 00 00 48 85 ED 74 75 45 85 D2 7E 35 4D 63 D2 41 83 FB 30 BE 30 00 00 00 4C 89 D2 74 05 BE 20 00 00 00 48 89 EF 44 89 44 24 18 4C 89 54 24 10 E8 ?? ?? ?? ?? 4C 8B 54 24 10 44 8B 44 24 18 4C 01 D5 8B 44 24 70 4D 63 C0 85 C0 0F 84 1E 01 00 00 4D 85 C0 49 8D 40 FF 74 20 0F 1F 44 00 00 41 0F B6 0C 06 49 8B 54 24 78 8B 14 8A 88 54 05 00 48 83 E8 01 48 83 F8 FF 75 E5 4C 01 C5 4D 01 FD 48 89 D8 48 83 C3 01 0F B6 40 01 84 C0 0F 85 71 FE FF FF 4C 8B 54 24 60 49 89 EB 4D 85 DB 74 32 4D 85 D2 74 2D 41 C6 03 00 EB 27 0F 1F 40 00 BA 01 00 00 00 E9 5C FE FF FF 66 0F 1F 44 00 00 C7 44 24 70 01 00 00 00 E9 49 FE FF FF 0F 1F 00 45 31 ED 48 81 C4 08 01 00 00 4C 89 E8 5B 5D 41 5C 41 5D 41 5E 41 5F C3 0F 1F 84 00 00 00 00 00 3C 37 0F 8E 61 FE FF FF 41 BF FF FF FF 7F E9 5F FE FF FF 0F 1F 44 00 00 0F B6 C1 FF 24 C5 ?? ?? ?? ?? 66 0F 1F 44 00 00 0F B6 4B 01 48 83 C3 01 E9 A0 FE FF FF 0F 1F 00 8B 44 24 74 85 C0 B8 0C 00 00 00 0F 45 44 24 74 89 44 24 74 E9 74 FD FF FF 0F 1F 80 00 00 00 00 48 8D 43 FF 41 B8 01 00 00 00 49 89 C6 48 83 E8 01 41 83 C0 01 80 78 01 25 75 EF E9 78 FE FF FF 0F 1F 84 00 00 00 00 00 4C 89 C2 4C 89 F6 48 89 EF 4C 89 44 24 18 E8 ?? ?? ?? ?? 4C 8B 44 24 18 E9 EE FE FF FF B9 01 00 00 00 48 8B 7C 24 68 45 31 F6 8B 74 24 70 85 D2 B8 01 00 00 00 4C 8B 44 24 78 0F 45 C8 8B 57 08 41 0F 45 F6 31 C0 89 74 24 70 83 FA 0B 0F 9F C0 48 83 C0 2E 49 8B 3C C0 89 54 24 18 89 4C 24 08 44 89 1C 24 E8 ?? ?? ?? ?? 41 29 C7 41 89 C0 8B 54 24 18 45 0F 49 F7 8B 4C 24 08 44 8B 1C 24 41 01 C6 48 8B 44 24 60 4D 63 F6 4C 29 E8 49 39 C6 0F 83 CA FE FF FF 48 85 ED 0F 84 8E 00 00 00 45 85 FF 7E 3A 4D 63 FF 41 83 FB 30 4C 89 FA 0F 84 33 13 00 00 BE 20 00 00 00 48 89 EF 89 4C 24 08 44 89 44 24 18 4C 01 FD E8 ?? ?? ?? ?? 48 8B 74 24 68 44 8B 44 24 18 8B 4C 24 08 8B 56 08 31 C0 83 FA 0C 4D 63 F8 0F 9D C0 48 83 C0 2E 85 C9 0F 84 61 12 00 00 4C 8B 44 24 78 4D 85 FF 49 8D 4F FF 49 8B 3C C0 74 23 66 0F 1F 84 00 00 00 00 00 0F B6 14 0F 49 8B 44 24 70 8B 04 90 88 44 0D 00 48 83 E9 01 48 83 F9 FF 75 E6 4C 01 FD 4D 01 F5 48 89 D8 E9 4D FC FF FF 31 C9 E9 E3 FE FF FF 48 C7 84 24 80 00 00 00 ?? ?? ?? ?? 0F 1F 44 00 00 48 8B 94 24 80 00 00 00 4C 8B 84 24 88 00 00 00 48 C7 C6 FF FF FF FF 48 8B 4C 24 68 31 FF 4D 89 E1 44 89 1C 24 E8 76 FB FF FF 44 89 FA 4C 63 F0 48 8B 74 24 60 31 C0 44 29 F2 44 8B 1C 24 0F 49 C2 44 01 F0 4C 29 EE 4C 63 F8 48 89 B4 24 98 00 00 00 49 39 F7 0F 83 B5 FD FF FF 48 85 ED 0F 84 5A FD FF FF 85 D2 49 89 EA 7E 2B 4C 63 D2 41 83 FB 30 BE 30 00 00 00 4C 89 D2 74 05 BE 20 00 00 00 48 89 EF 4C 89 54 24 10 E8 ?? ?? ?? ?? 4C 8B 54 24 10 49 01 EA 4C 8B 84 24 88 00 00 00 48 8B 4C 24 68 4C 89 D7 48 8B 94 24 80 00 00 00 48 8B B4 24 98 00 00 00 4D 89 E1 4C 89 54 24 10 4D 01 FD E8 DA FA FF FF 4C 8B 54 24 10 44 8B 5C 24 70 4D 01 F2 45 85 DB 74 20 49 39 EA 76 1B 0F 1F 00 0F B6 55 00 49 8B 44 24 78 48 83 C5 01 8B 04 90 88 45 FF 49 39 EA 75 E8 48 89 D8 4C 89 D5 E9 32 FB FF FF 48 C7 84 24 80 00 00 00 ?? ?? ?? ?? E9 EC FE FF FF 41 83 FE 4F 0F 84 6A FD FF FF 41 83 FE 45 0F 84 0F 12 00 00 48 8B 4C 24 78 48 8B 89 90 01 00 00 48 89 8C 24 80 00 00 00 E9 BF FE FF FF 45 85 F6 0F 85 3E FD FF FF 85 D2 B8 01 00 00 00 0F 44 44 24 70 48 8B 4C 24 68 48 8B 7C 24 78 89 44 24 70 0F B7 41 18 48 8B 74 C7 40 44 89 1C 24 48 89 F7 48 89 74 24 18 E8 ?? ?? ?? ?? 41 29 C7 89 C1 48 8B 74 24 18 45 0F 49 F7 44 8B 1C 24 41 01 C6 48 8B 44 24 60 4D 63 F6 4C 29 E8 49 39 C6 0F 83 69 FC FF FF 48 85 ED 0F 84 2D FE FF FF 45 85 FF 7E 3B 4D 63 FF 41 83 FB 30 4C 89 FA 0F 84 26 15 00 00 48 89 EF BE 20 00 00 00 89 4C 24 08 E8 ?? ?? ?? ?? 48 8B 74 24 68 48 8B 7C 24 78 4C 01 FD 8B 4C 24 08 0F B7 46 18 48 8B 74 C7 40 8B 44 24 70 4C 63 F9 85 C0 0F 84 F7 0F 00 00 4D 85 FF 49 8D 47 FF 0F 84 CE FD FF FF 0F 1F 40 00 0F B6 0C 06 49 8B 54 24 78 8B 14 8A 88 54 05 00 48 83 E8 01 48 83 F8 FF 75 E6 E9 AB FD FF FF 41 83 FE 45 0F 84 4F FC FF FF 48 8B 4C 24 68 41 83 FF 02 41 B9 02 00 00 00 45 0F 4D CF BE 93 24 49 92 48 8B 7C 24 68 8B 49 18 89 4C 24 28 83 C1 06 89 C8 F7 EE 89 C8 C1 F8 1F 01 CA C1 FA 02 29 C2 8D 04 D5 00 00 00 00 29 D0 8B 57 1C 29 C8 8D 4C 10 07 89 C8 F7 EE 01 CA C1 F9 1F C1 FA 02 29 CA 85 D2 0F 89 C0 0D 00 00 41 89 D2 89 D6 4C 8D B4 24 B6 00 00 00 41 C1 EA 1F F7 DE B9 CD CC CC CC 45 85 D2 0F 44 F2 66 2E 0F 1F 84 00 00 00 00 00 89 F0 49 83 EE 01 F7 E1 C1 EA 03 8D 04 92 01 C0 29 C6 83 C6 30 85 D2 41 88 36 89 D6 75 E2 45 85 D2 74 09 41 C6 46 FF 2D 49 83 EE 01 41 83 FB 2D 48 8D 8C 24 B6 00 00 00 74 79 4D 89 F0 49 29 C8 45 01 C8 45 85 C0 7E 6B 41 83 FB 5F 0F 84 6E 0E 00 00 48 8B 44 24 60 4D 63 C9 4C 29 E8 49 39 C1 0F 83 EA FA FF FF 45 85 D2 74 15 49 83 C6 01 48 85 ED 74 08 C6 45 00 2D 48 83 C5 01 49 83 C5 01 48 85 ED 4D 63 F8 74 25 48 89 EF 4C 89 FA BE 30 00 00 00 48 89 4C 24 08 44 89 1C 24 4C 01 FD E8 ?? ?? ?? ?? 44 8B 1C 24 48 8B 4C 24 08 4D 01 FD 45 31 FF 44 29 F1 45 89 FA 31 C0 41 29 CA 41 0F 49 C2 44 8D 3C 08 48 8B 44 24 60 4D 63 FF 4C 29 E8 49 39 C7 0F 83 76 FA FF FF 48 85 ED 0F 84 1B FA FF FF 45 85 D2 7E 33 4D 63 D2 41 83 FB 30 BE 30 00 00 00 4C 89 D2 74 05 BE 20 00 00 00 48 89 EF 89 4C 24 08 4C 89 54 24 10 E8 ?? ?? ?? ?? 4C 8B 54 24 10 8B 4C 24 08 4C 01 D5 8B 74 24 70 48 63 C9 85 F6 0F 84 76 0D 00 00 48 85 C9 48 8D 41 FF 74 20 0F 1F 44 00 00 41 0F B6 34 06 49 8B 54 24 78 8B 14 B2 88 54 05 00 48 83 E8 01 48 83 F8 FF 75 E5 48 01 CD E9 A3 F9 FF FF 83 FA 01 B8 00 00 00 00 45 19 F6 41 83 C6 01 85 D2 0F 44 44 24 70 48 83 BC 24 90 00 00 00 00 89 44 24 70 74 0D 48 8B 94 24 90 00 00 00 80 3A 00 75 3D 48 8B 4C 24 68 48 63 41 20 85 C0 78 21 48 8B B4 24 88 00 00 00 80 3E 00 0F 84 FF 11 00 00 48 8B 04 C5 ?? ?? ?? ?? 48 89 84 24 90 00 00 00 48 83 BC 24 90 00 00 00 00 0F 84 88 11 00 00 48 8B BC 24 90 00 00 00 44 89 1C 24 E8 ?? ?? ?? ?? 44 8B 1C 24 41 89 C0 31 C0 45 29 C7 41 0F 49 C7 44 01 C0 4C 63 C8 48 8B 44 24 60 4C 29 E8 49 39 C1 0F 83 4E F9 FF FF 48 85 ED 74 76 45 85 FF 7E 34 4D 63 FF 41 83 FB 30 4C 89 FA 0F 84 C3 0F 00 00 48 89 EF BE 20 00 00 00 44 89 44 24 18 4C 89 4C 24 10 4C 01 FD E8 ?? ?? ?? ?? 4C 8B 4C 24 10 44 8B 44 24 18 45 85 F6 4D 63 F8 0F 84 46 0D 00 00 4D 85 FF 49 8D 47 FF 74 25 48 8B B4 24 90 00 00 00 0F 1F 00 0F B6 0C 06 49 8B 54 24 70 8B 14 8A 88 54 05 00 48 83 E8 01 48 83 F8 FF 75 E6 4C 01 FD 4D 01 CD 48 89 D8 E9 ED F6 FF FF 41 83 FE 45 0F 84 A0 0F 00 00 41 83 FE 4F 0F 84 2C F9 FF FF 48 8B 4C 24 68 45 85 FF 41 B9 01 00 00 00 45 0F 4F CF 8B 49 14 89 CA 81 C2 6C 07 00 00 E9 12 FD FF FF 48 8B 4C 24 68 45 85 FF 41 B9 01 00 00 00 45 0F 4F CF BA 93 24 49 92 8B 49 18 89 CE 83 C6 06 89 F0 F7 EA 89 F0 C1 F8 1F 8D 0C 32 C1 F9 02 29 C1 8D 04 CD 00 00 00 00 29 C8 29 C6 8D 56 01 E9 CF FC FF FF 45 85 F6 0F 85 BE F8 FF FF 48 C7 84 24 80 00 00 00 ?? ?? ?? ?? E9 25 FA FF FF 45 85 F6 0F 85 A4 F8 FF FF 48 C7 84 24 80 00 00 00 ?? ?? ?? ?? E9 0B FA FF FF 41 83 FE 45 0F 84 24 0F 00 00 48 8B 4C 24 68 41 B9 01 00 00 00 BA 1F 85 EB 51 41 B8 64 00 00 00 8B 49 14 89 4C 24 38 81 C1 6C 07 00 00 45 85 FF 89 C8 45 0F 4F CF F7 EA 89 C8 C1 F8 1F C1 FA 05 29 C2 89 D0 41 0F AF C0 29 C1 C1 E9 1F 29 CA E9 47 FC FF FF 45 85 F6 0F 85 36 F8 FF FF 48 8B 4C 24 68 85 D2 B8 01 00 00 00 0F 44 44 24 70 48 8B 7C 24 78 8B 49 10 89 44 24 70 89 C8 05 1A 00 02 00 0F B7 C0 48 8B 74 C7 40 44 89 1C 24 48 89 F7 48 89 74 24 18 E8 ?? ?? ?? ?? 41 29 C7 89 C1 48 8B 74 24 18 45 0F 49 F7 44 8B 1C 24 41 01 C6 48 8B 44 24 60 4D 63 F6 4C 29 E8 49 39 C6 0F 83 58 F7 FF FF 48 85 ED 0F 84 1C F9 FF FF 45 85 FF 7E 44 4D 63 FF 41 83 FB 30 4C 89 FA 0F 84 D4 10 00 00 48 89 EF BE 20 00 00 00 89 4C 24 08 E8 ?? ?? ?? ?? 48 8B 74 24 68 48 8B 7C 24 78 4C 01 FD 8B 4C 24 08 8B 76 10 89 F0 05 1A 00 02 00 0F B7 C0 48 8B 74 C7 40 8B 44 24 70 4C 63 F9 85 C0 0F 84 DD 0A 00 00 4D 85 FF 49 8D 47 FF 0F 84 B4 F8 FF FF 66 2E 0F 1F 84 00 00 00 00 00 0F B6 0C 06 49 8B 54 24 78 8B 14 8A 88 54 05 00 48 83 E8 01 48 83 F8 FF 75 E6 E9 8B F8 FF FF 45 85 F6 0F 85 30 F7 FF FF 48 8B 4C 24 68 85 D2 B8 01 00 00 00 0F 44 44 24 70 48 8B 7C 24 78 8B 49 18 89 44 24 70 89 C8 05 07 00 02 00 0F B7 C0 48 8B 74 C7 40 44 89 1C 24 48 89 F7 48 89 74 24 18 E8 ?? ?? ?? ?? 41 29 C7 89 C1 48 8B 74 24 18 45 0F 49 F7 44 8B 1C 24 41 01 C6 48 8B 44 24 60 4D 63 F6 4C 29 E8 49 39 C6 0F 83 52 F6 FF FF 48 85 ED 0F 84 16 F8 FF FF 45 85 FF 7E 44 4D 63 FF 41 83 FB 30 4C 89 FA 0F 84 93 0F 00 00 48 89 EF BE 20 00 00 00 89 4C 24 08 E8 ?? ?? ?? ?? 48 8B 74 24 68 48 8B 7C 24 78 4C 01 FD 8B 4C 24 08 8B 76 18 89 F0 05 07 00 02 00 0F B7 C0 48 8B 74 C7 40 8B 44 24 70 4C 63 F9 85 C0 0F 84 D7 09 00 00 4D 85 FF 49 8D 47 FF 0F 84 AE F7 FF FF 0F 1F 40 00 0F B6 0C 06 49 8B 54 24 78 8B 14 8A 88 54 05 00 48 83 E8 01 48 83 F8 FF 75 E6 E9 8B F7 FF FF 45 85 F6 0F 85 BF F4 FF FF 41 83 EF 01 48 8B 44 24 60 45 0F 49 F7 41 83 C6 01 4D 63 F6 4C 29 E8 49 39 C6 0F 83 98 F5 FF FF 48 85 ED 0F 84 5C F7 FF FF 45 85 FF B8 25 00 00 00 7E 23 4D 63 FF 41 83 FB 30 4C 89 FA 0F 84 81 0E 00 00 48 89 EF BE 20 00 00 00 4C 01 FD E8 ?? ?? ?? ?? 0F B6 03 88 45 00 48 83 C5 01 E9 23 F7 FF FF 0F B6 4B FF 48 83 EB 01 E9 47 F4 FF FF 31 C0 41 83 EF 01 41 0F 49 C7 83 C0 01 4C 63 F0 48 8B 44 24 60 4C 29 E8 49 39 C6 0F 83 28 F5 FF FF 48 85 ED 0F 84 EC F6 FF FF 45 85 FF 7E 20 4D 63 FF 41 83 FB 30 4C 89 FA 0F 84 D7 0B 00 00 48 89 EF BE 20 00 00 00 4C 01 FD E8 ?? ?? ?? ?? C6 45 00 0A 48 83 C5 01 E9 BA F6 FF FF 41 83 FE 45 0F 84 5B F5 FF FF 48 8B 4C 24 68 41 83 FF 02 41 B9 02 00 00 00 45 0F 4D CF 8B 49 10 89 CA 83 C2 01 E9 43 F9 FF FF 41 83 FE 45 0F 84 31 F5 FF FF 8B 54 24 74 41 B9 02 00 00 00 41 83 FF 02 45 0F 4D CF 41 83 FB 2D 0F 84 1D F9 FF FF 41 83 FB 30 B8 5F 00 00 00 44 0F 45 D8 E9 0B F9 FF FF 48 8B 74 24 78 B8 ?? ?? ?? ?? 48 8B B6 98 01 00 00 80 3E 00 48 0F 45 C6 48 89 84 24 80 00 00 00 E9 56 F6 FF FF 41 83 FE 45 0F 84 D4 F4 FF FF 48 8B 54 24 68 41 83 FF 02 41 B9 02 00 00 00 45 0F 4D CF 8B 4A 1C 2B 4A 18 BA 93 24 49 92 83 C1 07 89 C8 F7 EA 01 CA C1 F9 1F C1 FA 02 29 CA E9 A8 F8 FF FF 41 83 FE 45 0F 84 96 F4 FF FF 48 8B 4C 24 68 41 B9 02 00 00 00 41 83 FF 02 45 0F 4D CF 8B 11 E9 84 F8 FF FF 41 83 FE 45 0F 84 72 F4 FF FF 48 8B 4C 24 68 41 B9 02 00 00 00 41 83 FF 02 45 0F 4D CF 8B 51 04 E9 5F F8 FF FF 41 83 FE 45 0F 84 4D F4 FF FF 41 B9 02 00 00 00 41 83 FF 02 8B 54 24 74 45 0F 4D CF E9 3E F8 FF FF 41 83 FE 45 0F 84 2C F4 FF FF 48 8B 4C 24 68 41 B9 02 00 00 00 41 83 FF 02 45 0F 4D CF 8B 51 08 E9 19 F8 FF FF 48 8B 4C 24 68 8B 71 20 85 F6 0F 88 3A F3 FF FF 8B 49 28 85 C9 0F 88 84 09 00 00 45 89 F8 31 C0 41 83 E8 01 41 0F 49 C0 83 C0 01 4C 63 C8 48 8B 44 24 60 4C 29 E8 49 39 C1 0F 83 5A F3 FF FF 48 85 ED 74 51 45 85 C0 7E 44 4D 63 C0 41 83 FB 30 4C 89 C2 0F 84 E2 0B 00 00 48 89 EF BE 20 00 00 00 89 4C 24 08 4C 89 44 24 18 4C 89 4C 24 10 44 89 1C 24 E8 ?? ?? ?? ?? 4C 8B 44 24 18 44 8B 1C 24 4C 8B 4C 24 10 8B 4C 24 08 4C 01 C5 C6 45 00 2B 48 83 C5 01 4D 01 CD B8 89 88 88 88 41 B9 04 00 00 00 F7 E9 B8 89 88 88 88 8D 34 0A C1 F9 1F C1 FE 05 29 CE 41 83 FF 04 45 0F 4D CF F7 EE 8D 04 32 89 F2 C1 FA 1F C1 F8 05 29 D0 BA 28 00 00 00 0F AF C2 8D 14 30 E9 3D F7 FF FF 41 83 FE 45 0F 84 C9 0A 00 00 48 8B 74 24 68 41 83 FF 02 41 B9 02 00 00 00 45 0F 4D CF 41 B8 64 00 00 00 41 BA 64 00 00 00 8B 4E 14 BE 1F 85 EB 51 89 C8 F7 EE 89 C8 C1 F8 1F C1 FA 05 29 C2 41 0F AF D0 29 D1 83 C1 64 89 C8 F7 EE 89 }
	condition:
		$1
}

rule file_221_1_0 {
	meta:
		name = "__strftime_l"
		size = 27
	strings:
		$1 = { 48 83 EC 18 4D 89 C1 4C 8D 44 24 0F C6 44 24 0F 00 E8 5A E3 FF FF 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_223_0_0 {
	meta:
		name = "__wcsncpy"
		size = 214
	strings:
		$1 = { 48 83 FA 03 48 89 F8 48 8D 4F FC 76 53 49 89 D1 49 C1 E9 02 44 8B 06 45 85 C0 44 89 41 04 0F 84 7C 00 00 00 44 8B 46 04 45 85 C0 44 89 41 08 0F 84 8B 00 00 00 44 8B 46 08 45 85 C0 44 89 41 0C 0F 84 8A 00 00 00 44 8B 46 0C 48 83 C1 10 48 83 C6 10 45 85 C0 44 89 01 74 4A 49 83 E9 01 75 B4 83 E2 03 74 33 0F 1F 00 44 8B 06 48 83 C1 04 48 83 C6 04 48 83 EA 01 44 89 01 74 1C 45 85 C0 75 E7 0F 1F 80 00 00 00 00 48 83 C1 04 48 83 EA 01 C7 01 00 00 00 00 75 F0 F3 C3 66 0F 1F 44 00 00 48 83 C1 04 48 89 CE 48 29 C6 48 C1 FE 02 48 F7 DE 48 8D 54 32 FF 48 85 D2 75 CD F3 C3 0F 1F 00 48 83 C1 08 EB DE 66 2E 0F 1F 84 00 00 00 00 00 48 83 C1 0C EB CE }
	condition:
		$1
}

rule file_224_0_0 {
	meta:
		name = "__wcschrnul"
		size = 34
	strings:
		$1 = { 8B 17 48 89 F8 85 D2 74 15 39 F2 75 07 EB 11 90 39 F2 74 0A 48 83 C0 04 8B 10 85 D2 75 F2 F3 C3 F3 C3 }
	condition:
		$1
}

rule file_225_0_0 {
	meta:
		name = "timerfd_create"
		size = 20
		refs = "000f __syscall_error"
	strings:
		$1 = { B8 1B 01 00 00 0F 05 48 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_227_0_0 {
	meta:
		name = "lrand48_r"
		size = 22
		refs = "000c __nrand48_r"
	strings:
		$1 = { 48 85 FF 74 0B 48 89 F2 48 89 FE E9 ?? ?? ?? ?? B8 FF FF FF FF C3 }
	condition:
		$1
}

rule file_1023_0_0 {
	meta:
		name = "mrand48_r"
		size = 22
		refs = "000c __jrand48_r"
	strings:
		$1 = { 48 85 FF 74 0B 48 89 F2 48 89 FE E9 ?? ?? ?? ?? B8 FF FF FF FF C3 }
	condition:
		$1
}

rule file_228_0_0 {
	meta:
		name = "getw"
		size = 48
		refs = "0017 _IO_fread"
	strings:
		$1 = { 48 83 EC 18 48 89 F9 BA 01 00 00 00 48 8D 7C 24 0C BE 04 00 00 00 E8 ?? ?? ?? ?? BA FF FF FF FF 48 83 F8 01 0F 44 54 24 0C 48 83 C4 18 89 D0 C3 }
	condition:
		$1
}

rule file_230_0_0 {
	meta:
		name = "tcsendbreak"
		size = 54
		refs = "0020 __ioctl"
	strings:
		$1 = { 85 F6 7E 24 83 C6 63 BA 1F 85 EB 51 89 F0 C1 FE 1F F7 EA 31 C0 C1 FA 05 29 F2 BE 25 54 00 00 E9 ?? ?? ?? ?? 0F 1F 40 00 31 D2 BE 09 54 00 00 31 C0 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_233_0_0 {
	meta:
		name = "_IO_mem_sync"
		size = 70
		refs = "003b _IO_str_overflow"
	strings:
		$1 = { 48 8B 47 28 48 3B 47 30 53 48 89 FB 74 2A C6 00 00 48 8B 83 F0 00 00 00 48 8B 53 20 48 89 10 48 8B 43 28 48 2B 43 20 48 8B 93 F8 00 00 00 48 89 02 31 C0 5B C3 0F 1F 00 31 F6 E8 ?? ?? ?? ?? 48 83 6B 28 01 EB CB }
	condition:
		$1
}

rule file_233_1_0 {
	meta:
		name = "_IO_mem_finish"
		size = 109
		refs = "0020 realloc 0069 _IO_str_finish"
	strings:
		$1 = { 55 53 48 89 FB 48 83 EC 08 48 8B AF F0 00 00 00 48 8B 73 28 48 8B 7F 20 48 29 FE 48 83 C6 01 E8 ?? ?? ?? ?? 48 89 45 00 48 8B 83 F0 00 00 00 48 8B 10 48 85 D2 74 26 48 8B 43 28 48 2B 43 20 C6 04 02 00 48 8B 43 28 48 2B 43 20 48 8B 93 F8 00 00 00 48 89 02 48 C7 43 38 00 00 00 00 48 83 C4 08 48 89 DF 31 F6 5B 5D E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_233_2_0 {
	meta:
		name = "open_memstream"
		size = 204
		refs = "0024 malloc 004c calloc 005e _IO_init 007c _IO_str_init_static_internal 0098 free"
	strings:
		$1 = { 4C 89 64 24 F0 4C 89 6C 24 F8 49 89 FD 48 89 5C 24 E0 48 89 6C 24 E8 BF 58 02 00 00 48 83 EC 28 49 89 F4 E8 ?? ?? ?? ?? 48 85 C0 0F 84 97 00 00 00 48 89 C3 48 05 00 01 00 00 BE 00 20 00 00 48 89 83 88 00 00 00 BF 01 00 00 00 E8 ?? ?? ?? ?? 48 85 C0 48 89 C5 74 70 31 F6 48 89 DF E8 ?? ?? ?? ?? 48 C7 83 D8 00 00 00 ?? ?? ?? ?? 48 89 E9 BA 00 20 00 00 48 89 EE 48 89 DF E8 ?? ?? ?? ?? 83 23 FE 48 C7 83 E0 00 00 00 ?? ?? ?? ?? 48 89 D8 48 C7 83 E8 00 00 00 ?? ?? ?? ?? 4C 89 AB F0 00 00 00 4C 89 A3 F8 00 00 00 48 8B 5C 24 08 48 8B 6C 24 10 4C 8B 64 24 18 4C 8B 6C 24 20 48 83 C4 28 C3 0F 1F 44 00 00 31 C0 EB DE }
	condition:
		$1
}

rule file_234_0_0 {
	meta:
		name = "__getrusage"
		size = 20
		refs = "000f __syscall_error"
	strings:
		$1 = { B8 62 00 00 00 0F 05 48 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_235_0_0 {
	meta:
		name = "profil_count"
		size = 286
	strings:
		$1 = { 48 8B 15 ?? ?? ?? ?? 48 3B 7A 20 72 09 48 3B 7A 28 48 89 D0 72 51 44 8B 05 ?? ?? ?? ?? 4C 8B 0D ?? ?? ?? ?? 31 C9 41 83 E8 01 EB 13 0F 1F 40 00 48 3B 7A 28 72 7A 48 8D 48 01 49 39 C8 72 21 4A 8D 04 01 48 D1 E8 48 8D 14 40 48 C1 E2 04 4C 01 CA 48 3B 7A 20 73 D9 4C 8D 40 FF 49 39 C8 73 DF 48 8B 05 ?? ?? ?? ?? 48 2B 38 85 F6 8B 48 10 74 5F 48 89 F8 48 C1 EF 12 48 C1 E8 02 25 FF FF 00 00 48 0F AF C1 48 0F AF F9 48 C1 E8 10 48 01 F8 48 39 42 08 76 2A 48 8B 52 18 48 8D 14 82 8B 02 83 F8 FF 74 78 83 C0 01 89 02 C3 0F 1F 44 00 00 48 89 15 ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? EB A7 48 8B 05 ?? ?? ?? ?? 48 8B 40 18 83 00 01 C3 90 48 89 F8 48 C1 EF 11 48 D1 E8 25 FF FF 00 00 48 0F AF C1 48 0F AF F9 48 C1 E8 10 48 01 F8 48 3B 42 08 73 19 48 8B 52 18 48 8D 14 42 0F B7 02 66 83 F8 FF 74 07 83 C0 01 66 89 02 C3 C3 48 8B 05 ?? ?? ?? ?? 48 8B 40 18 66 83 00 01 C3 C3 }
	condition:
		$1
}

rule file_235_2_0 {
	meta:
		name = "profil_counter_uint"
		size = 18
	strings:
		$1 = { 48 8B BA A8 00 00 00 BE 01 00 00 00 E8 BF FE FF FF C3 }
	condition:
		$1
}

rule file_235_3_0 {
	meta:
		name = "pcmp"
		size = 31
	strings:
		$1 = { 48 8B 07 48 8B 50 10 48 8B 06 48 8B 48 10 B8 01 00 00 00 48 39 CA 72 05 48 39 D1 19 C0 F3 C3 }
	condition:
		$1
}

rule file_235_4_0 {
	meta:
		name = "insert.part.0"
		size = 351
		refs = "0045 malloc 0103 realloc 0146 memmove"
	strings:
		$1 = { 48 89 5C 24 D0 48 89 6C 24 D8 48 63 DF 4C 89 6C 24 E8 4C 89 74 24 F0 49 89 D5 4C 89 7C 24 F8 4C 89 64 24 E0 48 83 EC 38 8B 05 ?? ?? ?? ?? 49 89 F6 48 89 CD 45 89 C7 85 C0 0F 85 B1 00 00 00 BF 30 00 00 00 E8 ?? ?? ?? ?? 49 89 C4 4D 85 E4 0F 84 00 01 00 00 8B 0D ?? ?? ?? ?? 89 C8 29 D8 48 85 C0 0F 85 B8 00 00 00 48 8D 1C 5B 48 C1 E3 04 4C 01 E3 41 83 FF 01 48 8B 45 08 48 8B 75 10 48 19 FF 31 D2 83 C1 01 48 83 E7 FE 48 83 C7 04 48 89 33 48 F7 F7 48 8B 55 18 89 53 10 48 89 43 08 48 8B 45 00 4C 89 73 20 4C 89 6B 28 4C 89 25 ?? ?? ?? ?? 89 0D ?? ?? ?? ?? 48 89 43 18 31 C0 48 85 F6 75 06 48 83 FA 02 74 46 48 8B 5C 24 08 48 8B 6C 24 10 4C 8B 64 24 18 4C 8B 6C 24 20 4C 8B 74 24 28 4C 8B 7C 24 30 48 83 C4 38 C3 0F 1F 00 83 C0 01 48 8B 3D ?? ?? ?? ?? 48 8D 34 40 48 C1 E6 04 E8 ?? ?? ?? ?? 49 89 C4 E9 3D FF FF FF 90 4C 89 25 ?? ?? ?? ?? EB B1 0F 1F 80 00 00 00 00 48 63 CB 48 8D 14 40 48 8D 1C 49 48 8D 7C 49 03 48 C1 E2 04 48 C1 E3 04 48 C1 E7 04 4C 01 E3 4C 01 E7 48 89 DE E8 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? E9 1E FF FF FF B8 FF FF FF FF E9 6B FF FF FF }
	condition:
		$1
}

rule file_235_5_0 {
	meta:
		name = "__sprofil"
		size = 1126
		refs = "003d __profile_frequency 00d4 qsort 030b __sigaction 0355 __setitimer 03b8 free 0462 __assert_fail"
	strings:
		$1 = { 55 48 89 E5 41 57 49 89 FF 41 56 41 55 4C 63 EE 4A 8D 04 ED 16 00 00 00 41 54 48 83 E0 F0 53 89 F3 48 81 EC E8 00 00 00 89 8D FC FE FF FF 48 29 C4 48 85 D2 49 89 E6 74 40 49 89 D4 E8 ?? ?? ?? ?? 89 C6 B8 40 42 0F 00 89 C2 C1 FA 1F F7 FE 48 BA DB 34 B6 D7 82 DE 1B 43 48 63 C8 48 89 C8 48 F7 E2 48 C1 EA 12 49 89 14 24 48 69 D2 40 42 0F 00 48 29 D1 49 89 4C 24 08 44 8B 05 ?? ?? ?? ?? 45 85 C0 0F 85 5C 03 00 00 85 DB 48 C7 05 ?? ?? ?? ?? 00 00 00 00 48 C7 05 ?? ?? ?? ?? ?? ?? ?? ?? 0F 8E 8C 03 00 00 4C 89 FA 31 C0 0F 1F 40 00 49 89 14 C6 48 83 C0 01 48 83 C2 20 39 C3 7F F0 4C 89 EE B9 ?? ?? ?? ?? BA 08 00 00 00 4C 89 F7 83 EB 01 E8 ?? ?? ?? ?? 44 8B AD FC FE FF FF 49 8D 5C DE 08 4C 89 B5 08 FF FF FF 48 89 9D 00 FF FF FF 41 83 E5 01 66 2E 0F 1F 84 00 00 00 00 00 48 8B 85 08 FF FF FF 4C 8B 20 49 8B 4C 24 18 48 83 F9 01 0F 86 6C 01 00 00 45 85 ED 4D 8B 44 24 08 0F 84 49 02 00 00 49 C1 E8 02 89 C9 31 D2 4A 8D 04 85 00 00 00 00 49 8B 74 24 10 41 B9 04 00 00 00 48 F7 F1 48 C1 E0 10 48 8D 3C 30 48 89 D0 31 D2 48 C1 E0 10 48 F7 F1 48 8D 1C 07 48 89 D8 48 29 F0 31 D2 49 F7 F1 0F B7 F8 48 C1 E8 10 48 0F AF F9 48 0F AF C1 48 C1 EF 10 48 01 F8 4C 39 C0 48 89 F0 48 83 D3 00 48 F7 D0 48 01 D8 41 83 FD 01 48 19 FF 31 D2 48 83 E7 FE 48 83 C7 04 48 F7 F7 0F B7 F8 48 C1 E8 10 48 0F AF F9 48 0F AF C1 48 C1 EF 10 48 01 F8 4C 39 C0 0F 83 8C 02 00 00 48 89 D8 48 29 F0 41 83 FD 01 48 19 FF 31 D2 48 83 E7 FE 48 83 C7 04 48 F7 F7 0F B7 F8 48 C1 E8 10 48 0F AF F9 48 0F AF C1 48 C1 EF 10 48 01 F8 4C 39 C0 0F 82 53 02 00 00 8B 3D ?? ?? ?? ?? 45 31 FF 48 8B 0D ?? ?? ?? ?? 85 FF 0F 84 1A 02 00 00 66 0F 1F 44 00 00 44 89 F8 4C 8D 34 40 49 C1 E6 04 4A 8D 04 31 48 8B 50 20 48 39 F2 76 26 48 39 DA 77 32 45 89 E8 4C 89 E1 44 89 FF E8 5D FC FF FF 85 C0 0F 88 65 01 00 00 48 8B 0D ?? ?? ?? ?? 4A 8D 04 31 41 83 C7 01 44 3B 3D ?? ?? ?? ?? 48 8B 70 28 72 B1 44 89 FF 48 39 DE 73 16 45 89 E8 4C 89 E1 48 89 DA E8 23 FC FF FF 85 C0 0F 88 2B 01 00 00 48 83 85 08 FF FF FF 08 48 8B 85 00 FF FF FF 48 39 85 08 FF FF FF 0F 85 5F FE FF FF 8B 15 ?? ?? ?? ?? 31 C0 85 D2 0F 84 25 01 00 00 48 8B 05 ?? ?? ?? ?? F6 85 FC FE FF FF 01 BA ?? ?? ?? ?? C7 45 B8 00 00 00 10 48 89 05 ?? ?? ?? ?? B8 ?? ?? ?? ?? 48 0F 44 C2 48 89 85 30 FF FF FF 48 8D 85 30 FF FF FF 48 8D B0 80 00 00 00 48 C7 06 FF FF FF FF 48 83 EE 08 48 39 C6 75 F0 BA ?? ?? ?? ?? BF 1B 00 00 00 E8 ?? ?? ?? ?? 85 C0 0F 88 BA 00 00 00 48 8D B5 10 FF FF FF BA ?? ?? ?? ?? BF 02 00 00 00 48 C7 85 20 FF FF FF 00 00 00 00 48 C7 85 28 FF FF FF 01 00 00 00 48 C7 85 10 FF FF FF 00 00 00 00 48 C7 85 18 FF FF FF 01 00 00 00 E8 ?? ?? ?? ?? 48 8D 65 D8 5B 41 5C 41 5D 41 5E 41 5F 5D C3 0F 1F 84 00 00 00 00 00 49 D1 E8 89 C9 31 D2 4B 8D 04 00 49 8B 74 24 10 41 B9 02 00 00 00 48 F7 F1 48 C1 E0 10 48 8D 3C 30 48 89 D0 31 D2 48 C1 E0 10 48 F7 F1 48 8D 1C 07 48 89 D8 48 29 F0 E9 B7 FD FF FF 0F 1F 40 00 48 8B 3D ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 00 00 00 00 48 C7 05 ?? ?? ?? ?? 00 00 00 00 B8 FF FF FF FF 48 8D 65 D8 5B 41 5C 41 5D 41 5E 41 5F 5D C3 31 D2 BE ?? ?? ?? ?? BF 02 00 00 00 E8 ?? ?? ?? ?? 85 C0 78 D7 31 D2 BE ?? ?? ?? ?? BF 1B 00 00 00 E8 ?? ?? ?? ?? 85 C0 78 C2 48 8B 3D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 65 D8 31 C0 5B 41 5C 41 5D 41 5E 41 5F 5D C3 31 FF E9 37 FE FF FF B9 ?? ?? ?? ?? BA 08 00 00 00 4C 89 EE 4C 89 F7 E8 ?? ?? ?? ?? E9 54 FE FF FF B9 ?? ?? ?? ?? BA 65 00 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_236_0_0 {
	meta:
		name = "memrchr"
		size = 1001
	strings:
		$1 = { 66 48 0F 6E CE 48 83 EA 10 0F 86 31 03 00 00 66 0F 60 C9 66 0F 60 C9 48 01 D7 66 0F 70 C9 00 F3 0F 6F 07 66 0F 74 C1 66 0F D7 C0 85 C0 0F 85 1D 02 00 00 48 83 EF 40 48 89 F9 48 83 E1 0F 74 10 48 83 C7 10 48 83 C2 10 48 83 E7 F0 48 29 CA 90 48 83 EA 40 0F 86 56 01 00 00 66 0F 6F 47 30 66 0F 74 C1 66 0F D7 C0 85 C0 0F 85 11 02 00 00 66 0F 6F 57 20 66 0F 74 D1 66 0F D7 C2 85 C0 0F 85 EC 01 00 00 66 0F 6F 5F 10 66 0F 74 D9 66 0F D7 C3 85 C0 0F 85 C7 01 00 00 66 0F 6F 27 66 0F 74 E1 66 0F D7 C4 85 C0 0F 85 A3 01 00 00 48 83 EF 40 48 83 EA 40 0F 86 F5 00 00 00 66 0F 6F 47 30 66 0F 74 C1 66 0F D7 C0 85 C0 0F 85 B0 01 00 00 66 0F 6F 57 20 66 0F 74 D1 66 0F D7 C2 85 C0 0F 85 8B 01 00 00 66 0F 6F 5F 10 66 0F 74 D9 66 0F D7 C3 85 C0 0F 85 66 01 00 00 66 0F 6F 1F 66 0F 74 D9 66 0F D7 C3 85 C0 0F 85 42 01 00 00 48 89 F9 48 83 E1 3F 74 19 48 83 C7 40 48 83 C2 40 48 83 E7 C0 48 29 CA 66 2E 0F 1F 84 00 00 00 00 00 48 83 EF 40 48 83 EA 40 76 76 66 0F 6F 07 66 0F 6F 57 10 66 0F 6F 5F 20 66 0F 6F 67 30 66 0F 74 C1 66 0F 74 D1 66 0F 74 D9 66 0F 74 E1 66 0F DE C3 66 0F DE D4 66 0F DE D0 66 0F D7 C2 85 C0 74 BF 66 0F D7 C4 85 C0 0F 85 03 01 00 00 66 0F D7 C3 85 C0 0F 85 E7 00 00 00 66 0F 6F 57 10 66 0F 74 D1 66 0F 74 0F 66 0F D7 C2 85 C0 0F 85 BE 00 00 00 66 0F D7 C1 0F BD C0 48 01 F8 C3 0F 1F 00 48 83 C2 40 48 83 FA 20 76 66 66 0F 6F 47 30 66 0F 74 C1 66 0F D7 C0 85 C0 0F 85 B1 00 00 00 66 0F 6F 57 20 66 0F 74 D1 66 0F D7 C2 85 C0 0F 85 8C 00 00 00 66 0F 6F 5F 10 66 0F 74 D9 66 0F D7 C3 85 C0 0F 85 A7 00 00 00 48 83 FA 30 0F 86 FD 00 00 00 66 0F 74 0F 66 0F D7 C1 85 C0 0F 85 7D 00 00 00 31 C0 C3 66 2E 0F 1F 84 00 00 00 00 00 66 0F 6F 47 30 66 0F 74 C1 66 0F D7 C0 85 C0 0F 85 AB 00 00 00 48 83 FA 10 0F 86 C1 00 00 00 66 0F 74 4F 20 66 0F D7 C1 85 C0 75 74 31 C0 C3 90 0F BD C0 48 01 F8 C3 66 0F 1F 84 00 00 00 00 00 0F BD C0 48 8D 44 38 10 C3 0F 1F 80 00 00 00 00 0F BD C0 48 8D 44 38 20 C3 0F 1F 80 00 00 00 00 0F BD C0 48 8D 44 38 30 C3 0F 1F 80 00 00 00 00 0F BD C0 48 83 EA 40 48 01 C2 7C 64 48 01 F8 C3 0F BD C0 48 83 EA 30 48 01 C2 7C 54 48 8D 44 07 10 C3 66 66 66 66 66 2E 0F 1F 84 00 00 00 00 00 0F BD C0 48 83 EA 20 48 01 C2 7C 34 48 8D 44 07 20 C3 66 66 66 66 66 2E 0F 1F 84 00 00 00 00 00 0F BD C0 48 83 EA 10 48 01 C2 7C 14 48 8D 44 07 30 C3 66 66 66 66 66 2E 0F 1F 84 00 00 00 00 00 48 31 C0 C3 66 66 66 2E 0F 1F 84 00 00 00 00 00 85 D2 74 EC 88 D1 66 0F 74 0F BA 01 00 00 00 D3 E2 83 EA 01 66 0F D7 C1 21 D0 85 C0 74 D2 0F BD C0 48 01 F8 C3 66 66 2E 0F 1F 84 00 00 00 00 00 66 0F 60 C9 66 0F 60 C9 48 83 C2 10 66 0F 70 C9 00 48 89 F9 48 83 E1 0F 74 B6 48 89 F9 48 83 E1 0F 88 CE 49 89 C8 00 D6 48 83 E7 F0 80 EE 10 77 2F 66 0F 74 0F 66 0F D7 C1 D3 F8 88 D1 BA 01 00 00 00 D3 E2 83 EA 01 21 D0 85 C0 0F 84 6F FF FF FF 0F BD C0 48 01 F8 4C 01 C0 C3 0F 1F 44 00 00 66 0F 6F 57 10 66 0F 74 D1 66 0F D7 C2 88 F1 BA 01 00 00 00 D3 E2 83 EA 01 21 D0 85 C0 75 21 66 0F 74 0F 66 0F D7 C1 4C 89 C1 D3 F8 85 C0 0F 84 2C FF FF FF 0F BD C0 48 01 F8 4C 01 C0 C3 66 90 0F BD C0 48 8D 44 38 10 C3 }
	condition:
		$1
}

rule file_237_0_0 {
	meta:
		name = "_L_lock_16"
		size = 25
		refs = "000c __lll_lock_wait_private"
	strings:
		$1 = { 48 8D 7B 04 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 EB AC }
	condition:
		$1
}

rule file_237_1_0 {
	meta:
		name = "_L_unlock_31"
		size = 25
		refs = "000c __lll_unlock_wake_private"
	strings:
		$1 = { 48 8D 7B 04 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 EB CC }
	condition:
		$1
}

rule file_237_2_0 {
	meta:
		name = "rewinddir"
		size = 94
		refs = "000d __libc_multiple_threads 002a __lseek"
	strings:
		$1 = { 53 BE 01 00 00 00 48 89 FB 31 C0 83 3D ?? ?? ?? ?? 00 74 09 F0 0F B1 73 04 75 43 EB 06 0F B1 73 04 75 3B 8B 3B 31 D2 31 F6 E8 ?? ?? ?? ?? 48 C7 43 20 00 00 00 00 48 C7 43 18 00 00 00 00 48 C7 43 10 00 00 00 00 83 3D ?? ?? ?? ?? 00 74 08 F0 FF 4B 04 75 22 EB 05 FF 4B 04 75 1B 5B C3 }
	condition:
		$1
}

rule file_238_0_0 {
	meta:
		name = "__fgets_unlocked_chk"
		size = 200
		refs = "0057 _IO_getline 0098 __libc_errno 00c4 __chk_fail"
	strings:
		$1 = { 85 D2 0F 8E B8 00 00 00 48 89 5C 24 E0 48 89 6C 24 E8 48 63 D2 4C 89 64 24 F0 4C 89 6C 24 F8 48 83 EC 28 8B 01 48 83 EA 01 48 89 CB 49 89 FD 48 89 F5 41 B8 01 00 00 00 41 89 C4 83 E0 DF 41 83 E4 20 48 39 F2 89 01 48 0F 47 D6 B9 0A 00 00 00 48 89 FE 48 89 DF E8 ?? ?? ?? ?? 48 85 C0 48 89 C1 8B 13 75 2B 31 C0 41 09 D4 48 8B 6C 24 10 4C 8B 6C 24 20 44 89 23 48 8B 5C 24 08 4C 8B 64 24 18 48 83 C4 28 C3 66 2E 0F 1F 84 00 00 00 00 00 F6 C2 20 74 0F 48 8B 35 ?? ?? ?? ?? 31 C0 64 83 3E 0B 75 C3 48 39 CD 76 1A 41 C6 44 0D 00 00 4C 89 E8 8B 13 EB B1 66 2E 0F 1F 84 00 00 00 00 00 31 C0 C3 E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_239_0_0 {
	meta:
		name = "ntp_gettimex"
		size = 114
		refs = "0016 __adjtimex"
	strings:
		$1 = { 53 48 89 FB 48 81 EC D0 00 00 00 48 89 E7 C7 04 24 00 00 00 00 E8 ?? ?? ?? ?? 48 8B 54 24 48 48 C7 43 28 00 00 00 00 48 C7 43 30 00 00 00 00 48 C7 43 38 00 00 00 00 48 C7 43 40 00 00 00 00 48 89 13 48 8B 54 24 50 48 89 53 08 48 8B 54 24 18 48 89 53 10 48 8B 54 24 20 48 89 53 18 48 63 94 24 A0 00 00 00 48 89 53 20 48 81 C4 D0 00 00 00 5B C3 }
	condition:
		$1
}

rule file_240_0_0 {
	meta:
		name = "__stpcpy"
		size = 220
	strings:
		$1 = { 48 89 F1 83 E1 07 48 89 FA 74 1B F7 D9 83 C1 08 8A 06 84 C0 88 02 0F 84 BC 00 00 00 48 FF C6 48 FF C2 FF C9 75 EA 49 B8 FF FE FE FE FE FE FE FE 48 8B 06 48 83 C6 08 49 89 C1 4D 01 C1 0F 83 7D 00 00 00 49 31 C1 4D 09 C1 49 FF C1 75 72 48 89 02 48 83 C2 08 48 8B 06 48 83 C6 08 49 89 C1 4D 01 C1 73 5C 49 31 C1 4D 09 C1 49 FF C1 75 51 48 89 02 48 83 C2 08 48 8B 06 48 83 C6 08 49 89 C1 4D 01 C1 73 3B 49 31 C1 4D 09 C1 49 FF C1 75 30 48 89 02 48 83 C2 08 48 8B 06 48 83 C6 08 49 89 C1 4D 01 C1 73 1A 49 31 C1 4D 09 C1 49 FF C1 75 0F 48 89 02 48 83 C2 08 E9 73 FF FF FF 0F 1F 00 88 02 84 C0 74 12 48 FF C2 88 22 84 E4 74 09 48 FF C2 48 C1 E8 10 EB E8 48 89 D0 C3 }
	condition:
		$1
}

rule file_241_0_0 {
	meta:
		name = "_dl_build_local_scope"
		size = 125
	strings:
		$1 = { 41 54 49 89 FC 55 48 8D 6F 08 53 48 89 37 0F B6 86 14 03 00 00 83 E0 9F 83 C8 20 88 86 14 03 00 00 48 8B 86 B8 03 00 00 48 85 C0 74 41 48 8B 70 08 48 8D 58 08 48 85 F6 75 12 EB 32 0F 1F 40 00 48 83 C3 08 48 8B 33 48 85 F6 74 22 F6 86 14 03 00 00 60 75 EB 48 89 EF 48 83 C3 08 E8 9F FF FF FF 48 8B 33 48 8D 6C C5 00 48 85 F6 75 DE 48 89 E8 5B 4C 29 E0 5D 48 C1 F8 03 41 5C C3 }
	condition:
		$1
}

rule file_241_1_0 {
	meta:
		name = "openaux"
		size = 56
		refs = "002e _dl_map_object"
	strings:
		$1 = { 53 48 89 FB 48 8B 3F BA 01 00 00 00 8B 4B 08 44 8B 43 0C 0F B6 87 14 03 00 00 4C 8B 4F 30 83 E0 03 0F B6 F0 84 C0 0F 45 D6 48 8B 73 18 E8 ?? ?? ?? ?? 48 89 43 20 5B C3 }
	condition:
		$1
}

rule file_241_2_0 {
	meta:
		name = "_dl_map_object_deps"
		size = 4560
		refs = "00f8 __libc_errno 01ff strchr 0229 _dl_catch_error 02da malloc 0307 memcpy 0402 strlen 0576 _dl_debug_mask 0755 memset 0882 memmove 0904 _dl_scope_free 0a86 _dl_dst_count 0a9c __libc_enable_secure 0ae6 _dl_platformlen 0b29 _dl_dst_substitute 0b4e _dl_debug_printf 0b75 _dl_get_origin 0bc4 _dl_signal_error 0beb __assert_fail 0ca1 free 0da8 _dl_ns 1116 _dl_argv"
	strings:
		$1 = { 55 8D 42 02 48 89 E5 41 57 48 8D 04 40 41 56 48 8D 04 C5 1E 00 00 00 41 55 48 C1 E8 04 48 C1 E0 04 41 54 53 48 81 EC E8 00 00 00 89 8D 44 FF FF FF 48 89 BD 48 FF FF FF 48 29 C4 44 89 85 40 FF FF FF 48 8D 4C 24 0F 48 83 E1 F0 48 8D 41 18 48 89 8D 20 FF FF FF C7 01 00 00 00 00 48 89 79 08 48 89 41 10 0F B6 87 14 03 00 00 83 E0 9F 83 C8 20 85 D2 88 87 14 03 00 00 0F 84 70 0B 00 00 44 8D 52 01 49 89 F0 C7 85 68 FF FF FF 01 00 00 00 BE 01 00 00 00 BF 01 00 00 00 83 C7 01 48 8D 04 76 4D 8B 08 89 FE 49 83 C0 08 4C 8D 1C 76 48 8D 04 C1 4E 8D 1C D9 C7 00 00 00 00 00 4C 89 48 08 4C 89 58 10 41 0F B6 81 14 03 00 00 83 E0 9F 83 C8 20 44 39 D7 41 88 81 14 03 00 00 75 BC 89 D2 4C 8B 71 08 89 BD 68 FF FF FF 48 8D 04 52 48 C1 E0 03 48 01 C8 48 8B 15 ?? ?? ?? ?? 48 C7 45 90 00 00 00 00 48 89 85 60 FF FF FF 48 C7 40 10 00 00 00 00 48 8B 05 ?? ?? ?? ?? 48 89 8D 58 FF FF FF 48 C7 85 30 FF FF FF 00 00 00 00 48 C7 85 38 FF FF FF 00 00 00 00 64 8B 00 64 C7 02 00 00 00 00 89 85 2C FF FF FF 45 31 ED 49 83 BE B8 02 00 00 00 48 8B B5 58 FF FF FF C7 06 01 00 00 00 0F 84 07 02 00 00 49 83 7E 48 00 0F 84 2B 01 00 00 49 8B 46 68 49 8B 5E 10 8B 8D 44 FF FF FF 8B B5 40 FF FF FF 4C 89 75 A0 48 8B 40 08 89 4D A8 89 75 AC 48 89 85 78 FF FF FF 48 89 45 B0 48 8B 03 48 85 C0 0F 84 0E 01 00 00 48 8B BD 58 FF FF FF 45 31 E4 48 89 BD 50 FF FF FF EB 25 0F 1F 40 00 4D 85 ED 74 0C 44 89 E2 41 83 C4 01 49 89 44 D5 00 48 83 C3 10 48 8B 03 48 85 C0 0F 84 D9 00 00 00 48 83 F8 01 0F 85 6F 07 00 00 4C 8B BD 78 FF FF FF 4C 03 7B 08 BE 24 00 00 00 4C 89 FF E8 ?? ?? ?? ?? 48 85 C0 0F 85 74 08 00 00 4C 89 F8 4C 8D 45 A0 48 8D 55 8F 48 8D 75 90 48 8D 7D 98 B9 ?? ?? ?? ?? 48 89 45 B8 E8 ?? ?? ?? ?? 4C 8B 7D 90 4D 85 FF 0F 85 BE 01 00 00 48 8B 45 C0 F6 80 14 03 00 00 60 0F 85 75 FF FF FF 48 83 EC 30 48 8B 8D 60 FF FF FF 83 85 68 FF FF FF 01 48 8D 54 24 0F 48 83 E2 F0 48 C7 42 10 00 00 00 00 48 89 42 08 C7 02 00 00 00 00 48 89 51 10 0F B6 88 14 03 00 00 83 E1 9F 83 C9 20 88 88 14 03 00 00 48 89 95 60 FF FF FF E9 25 FF FF FF 49 83 BE E0 01 00 00 00 0F 85 C7 FE FF FF 49 83 BE D0 01 00 00 00 0F 85 B9 FE FF FF 45 31 E4 4D 85 ED 74 6A 45 8D 7C 24 01 44 89 E0 49 C7 44 C5 00 00 00 00 00 43 8D 7C 3F 01 48 C1 E7 03 E8 ?? ?? ?? ?? 48 85 C0 48 89 C3 0F 84 1D 09 00 00 4C 89 30 44 89 F8 48 8D 7B 08 4C 8D 3C C5 00 00 00 00 4C 89 EE 41 83 C4 02 4C 89 FA E8 ?? ?? ?? ?? 4A 8D 3C E3 4C 89 FA 48 89 DE E8 ?? ?? ?? ?? 41 80 8E 16 03 00 00 01 49 89 9E B8 03 00 00 48 8B B5 58 FF FF FF 8B 06 85 C0 74 26 48 8B 85 58 FF FF FF 0F 1F 00 48 8B 40 10 48 85 C0 0F 84 23 0C 00 00 44 8B 08 45 85 C9 75 EB 48 89 85 58 FF FF FF 48 8B 8D 58 FF FF FF 4C 8B 71 08 E9 DB FD FF FF 49 83 BE B8 03 00 00 00 0F 85 EB FD FF FF 4C 39 B5 48 FF FF FF 0F 84 DE FD FF FF 41 0F B7 86 B2 02 00 00 66 85 C0 0F 84 CD FD FF FF 48 C1 E0 03 48 3B 85 30 FF FF FF 4C 8B AD 38 FF FF FF 0F 86 B5 FD FF FF 48 83 C0 0F 48 83 E0 F0 48 8D 50 1E 81 E2 F0 FF 1F 00 48 29 D4 48 8D 54 24 0F 48 83 E2 F0 48 8D 0C 02 49 39 CD 0F 84 A4 0B 00 00 49 89 D5 48 89 85 30 FF FF FF 48 89 95 38 FF FF FF E9 74 FD FF FF 0F 1F 80 00 00 00 00 4C 89 FF 89 85 F0 FE FF FF E8 ?? ?? ?? ?? 48 8D 50 01 48 83 C0 1F 4C 89 FE 48 83 E0 F0 48 29 C4 48 8D 7C 24 0F 48 83 E7 F0 E8 ?? ?? ?? ?? 4C 8B 65 98 48 89 C3 4C 89 E7 E8 ?? ?? ?? ?? 48 8D 50 01 48 83 C0 1F 4C 89 E6 48 83 E0 F0 48 29 C4 48 8D 7C 24 0F 48 83 E7 F0 E8 ?? ?? ?? ?? 80 7D 8F 00 48 89 45 98 8B 8D F0 FE FF FF 0F 85 F4 0A 00 00 C7 85 78 FF FF FF FF FF FF FF 85 C9 0F 44 8D 78 FF FF FF 48 89 5D 90 89 8D 78 FF FF FF 48 8B 05 ?? ?? ?? ?? 64 44 8B 00 45 85 C0 75 13 8B BD 2C FF FF FF 85 FF 74 09 8B 95 2C FF FF FF 64 89 10 48 8B BD 48 FF FF FF 48 8B BF B8 03 00 00 48 85 FF 48 89 BD 58 FF FF FF 74 24 48 8B BD 48 FF FF FF 0F B6 87 14 03 00 00 83 E0 03 3C 02 0F 84 EC 06 00 00 48 C7 85 58 FF FF FF 00 00 00 00 8B 85 68 FF FF FF 8D 7C 00 01 48 C1 E7 03 E8 ?? ?? ?? ?? 48 85 C0 49 89 C7 0F 84 3B 0A 00 00 8B 85 68 FF FF FF 48 8B BD 48 FF FF FF 45 31 F6 48 8B 95 20 FF FF FF 44 8B 85 44 FF FF FF 83 C0 01 48 89 F9 49 8D 04 C7 48 89 87 B8 02 00 00 8B 85 68 FF FF FF 89 87 C0 02 00 00 45 85 C0 48 8B 42 08 0F 85 D3 08 00 00 48 8B B1 B8 02 00 00 44 89 F7 41 83 C6 01 48 89 04 FE 48 8B 42 08 80 A0 14 03 00 00 9F 48 8B 52 10 48 85 D2 75 CD F6 05 ?? ?? ?? ?? 08 0F 85 24 08 00 00 48 8B BD 48 FF FF FF 48 8B B7 B8 02 00 00 48 8B 0E 48 39 F9 48 89 8D 70 FF FF FF 0F 85 EA 07 00 00 48 8B BD 48 FF FF FF 4C 8B AF C0 03 00 00 4D 85 ED 0F 84 A7 07 00 00 41 83 FE 01 76 2C 41 8D 46 FE 48 8D 56 08 48 8D 74 C6 10 48 8B 0A 48 83 C2 08 0F B6 81 14 03 00 00 83 E0 9F 83 C8 20 48 39 F2 88 81 14 03 00 00 75 E1 49 8D 4D 08 48 89 8D 68 FF FF FF 41 8B 4D 00 85 C9 0F 84 D7 00 00 00 45 31 E4 4C 89 EB EB 14 48 8B B9 C0 03 00 00 41 83 C4 01 44 39 27 0F 86 BB 00 00 00 44 89 E2 48 8B 8D 70 FF FF FF 48 8B 44 D3 08 F6 80 14 03 00 00 60 74 D4 8B 81 C8 03 00 00 48 89 95 10 FF FF FF 48 8D 3C C5 08 00 00 00 E8 ?? ?? ?? ?? 48 85 C0 49 89 C5 48 8B 95 10 FF FF FF 0F 84 DB 01 00 00 48 8B B5 68 FF FF FF 48 8D 78 08 48 C1 E2 03 E8 ?? ?? ?? ?? 48 8B 8D 70 FF FF FF 45 8D 4C 24 01 44 89 E6 48 8B B9 C0 03 00 00 8B 07 44 39 C8 0F 86 51 0A 00 00 44 89 CA 89 D1 48 8B 4C CB 08 F6 81 14 03 00 00 60 75 0B 41 89 F0 83 C6 01 4B 89 4C C5 08 83 C2 01 39 C2 75 DE 42 8D 44 0A FF 44 29 E0 41 89 C4 41 89 75 00 41 83 C4 01 44 39 27 0F 87 45 FF FF FF 41 83 FE 01 0F 86 DD 09 00 00 48 8B 8D 70 FF FF FF 41 8D 56 FE 48 8B B1 B8 02 00 00 48 8D 46 08 48 8D 4C D6 10 48 8B 10 48 83 C0 08 80 A2 14 03 00 00 9F 48 39 C8 75 ED 44 89 F3 4C 89 FF 48 8D 0C DD 00 00 00 00 48 89 CA 48 89 8D 68 FF FF FF E8 ?? ?? ?? ?? 48 8D 14 1B 48 89 A5 48 FF FF FF 31 F6 48 8D 42 10 48 C1 E8 04 48 C1 E0 04 48 29 C4 48 89 E7 48 89 A5 F8 FE FF FF E8 ?? ?? ?? ?? 41 8D 4E FF 4C 8B 8D F8 FE FF FF 44 89 B5 60 FF FF FF 41 B8 01 00 00 00 41 BA 02 00 00 00 89 8D 50 FF FF FF B9 01 00 00 00 41 89 CE 66 43 83 04 41 01 44 3B B5 50 FF FF FF 4B 8D 3C C7 48 8B 1F 73 46 8B B5 50 FF FF FF 0F 1F 80 00 00 00 00 41 89 F4 4F 8D 2C E7 49 8B 45 00 48 8B 80 B8 03 00 00 48 85 C0 75 12 EB 18 0F 1F 80 00 00 00 00 48 83 C0 08 48 39 D3 74 79 48 8B 10 48 85 D2 75 EF 83 EE 01 41 39 F6 72 C7 44 39 95 60 FF FF FF 45 89 D6 0F 84 D6 00 00 00 8B 95 60 FF FF FF 45 89 D0 31 F6 4B 8D 3C 41 4C 89 85 08 FF FF FF 4C 89 8D F8 FE FF FF 44 89 95 00 FF FF FF 44 29 D2 48 01 D2 E8 ?? ?? ?? ?? 44 8B 95 00 FF FF FF 4C 8B 85 08 FF FF FF 4C 8B 8D F8 FE FF FF 41 83 C2 01 E9 47 FF FF FF 48 8B 8D 70 FF FF FF E9 C0 FD FF FF 89 F1 45 89 D3 4C 89 85 08 FF FF FF 44 29 F1 4B 8D 34 DF 4C 89 8D F8 FE FF FF 48 8D 14 CD 00 00 00 00 48 89 8D F0 FE FF FF 44 89 95 00 FF FF FF 4C 89 9D 10 FF FF FF E8 ?? ?? ?? ?? 4C 8B 8D F8 FE FF FF 4C 8B 9D 10 FF FF FF 8B 85 60 FF FF FF 49 89 5D 00 48 8B 8D F0 FE FF FF 4C 8B 85 08 FF FF FF 43 0F B7 14 59 44 8B 95 00 FF FF FF 44 29 F0 39 C2 76 66 45 89 D6 E9 2A FF FF FF 48 8B A5 48 FF FF FF 48 8B 8D 68 FF FF FF 49 C7 04 0F 00 00 00 00 48 8B 8D 70 FF FF FF 80 89 16 03 00 00 01 4C 89 B9 B8 03 00 00 48 83 BD 58 FF FF FF 00 74 0C 48 8B BD 58 FF FF FF E8 ?? ?? ?? ?? 8B 95 78 FF FF FF 85 D2 0F 85 52 07 00 00 48 8D 65 D8 5B 41 5C 41 5D 41 5E 41 5F 5D C3 4B 8D 3C 41 4B 8D 34 59 48 8D 14 09 43 0F B7 1C 41 E8 ?? ?? ?? ?? 4C 8B 8D F8 FE FF FF 4C 8B 85 08 FF FF FF 44 8B 95 00 FF FF FF 66 43 89 1C 61 E9 2B FE FF FF 48 83 E0 FD 48 3D FD FF FF 7F 0F 85 67 F8 FF FF 4C 8B BD 78 FF FF FF 4C 03 7B 08 BE 24 00 00 00 4C 89 FF E8 ?? ?? ?? ?? 48 85 C0 0F 85 0A 06 00 00 4C 89 FE 48 81 3B FD FF FF 7F 48 89 75 B8 0F 84 8F 07 00 00 F6 05 ?? ?? ?? ?? 01 0F 85 5E 07 00 00 4C 8D 45 A0 48 8D 55 8F 48 8D 75 90 48 8D 7D 98 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 4C 8B 7D 90 89 85 70 FF FF FF 4D 85 FF 0F 85 63 02 00 00 48 8B 8D 50 FF FF FF 48 83 EC 30 48 8D 54 24 0F 48 8B 01 48 83 E2 F0 4D 85 ED 48 89 02 48 8B 41 08 48 89 42 08 48 8B 41 10 48 89 42 10 48 8B 45 C0 C7 01 00 00 00 00 48 89 41 08 74 10 44 89 E1 41 83 C4 01 49 89 44 CD 00 48 8B 45 C0 F6 80 14 03 00 00 60 0F 84 42 07 00 00 48 89 D1 EB 15 0F 1F 84 00 00 00 00 00 48 3B 46 08 0F 84 80 02 00 00 48 89 F1 48 8B 71 10 48 85 F6 75 EA 48 8B 02 48 8B 8D 50 FF FF FF 48 89 01 48 8B 42 08 48 89 41 08 48 8B 42 10 48 89 41 10 E9 59 F7 FF FF 0F 1F 84 00 00 00 00 00 31 F6 48 89 C7 E8 ?? ?? ?? ?? 48 85 C0 48 89 85 70 FF FF FF 0F 84 72 F7 FF FF 8B 05 ?? ?? ?? ?? 85 C0 0F 85 0F 01 00 00 4C 89 FF E8 ?? ?? ?? ?? 49 8B BE 38 03 00 00 48 89 C6 48 85 FF 0F 84 9D 00 00 00 48 83 FF FF 0F 84 E3 00 00 00 48 89 85 10 FF FF FF E8 ?? ?? ?? ?? 48 8B B5 10 FF FF FF 48 89 C1 48 83 3D ?? ?? ?? ?? 05 BA 05 00 00 00 4C 89 F7 48 0F 43 15 ?? ?? ?? ?? 48 39 CA 48 0F 42 D1 31 C9 48 83 EA 04 48 0F AF 95 70 FF FF FF 48 8D 44 16 1E 4C 89 FE 48 83 E0 F0 48 29 C4 48 8D 54 24 0F 48 83 E2 F0 E8 ?? ?? ?? ?? 80 38 00 0F 85 D9 F6 FF FF F6 05 ?? ?? ?? ?? 01 0F 84 8E F6 FF FF 4C 89 FE BF ?? ?? ?? ?? 31 C0 E8 ?? ?? ?? ?? E9 7A F6 FF FF 66 0F 1F 84 00 00 00 00 00 49 8B 46 08 80 38 00 0F 85 B6 00 00 00 48 89 B5 10 FF FF FF E8 ?? ?? ?? ?? 48 8D 50 FF 31 C9 49 89 86 38 03 00 00 48 8B B5 10 FF FF FF 48 83 FA FD 0F 87 4C FF FF FF 48 89 C7 E8 ?? ?? ?? ?? 48 8B B5 10 FF FF FF 48 89 C1 E9 35 FF FF FF 66 90 31 C9 E9 2C FF FF FF B9 ?? ?? ?? ?? 31 D2 4C 89 FE 31 FF E8 ?? ?? ?? ?? 48 83 BF B8 02 00 00 00 0F 84 11 F9 FF FF B9 ?? ?? ?? ?? BA FD 01 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 4C 8B B5 48 FF FF FF 31 C0 C7 85 68 FF FF FF 01 00 00 00 E9 EB F4 FF FF 48 8B BD 48 FF FF FF B9 ?? ?? ?? ?? 31 D2 48 8B 77 08 BF 0C 00 00 00 E8 ?? ?? ?? ?? B9 ?? ?? ?? ?? BA FB 00 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 4C 89 FF E8 ?? ?? ?? ?? 48 8D 50 01 48 83 C0 1F 4C 89 FE 48 83 E0 F0 48 29 C4 48 8D 7C 24 0F 48 83 E7 F0 E8 ?? ?? ?? ?? 4C 8B 65 98 48 89 C3 4C 89 E7 E8 ?? ?? ?? ?? 48 8D 50 01 48 83 C0 1F 4C 89 E6 48 83 E0 F0 48 29 C4 48 8D 7C 24 0F 48 83 E7 F0 E8 ?? ?? ?? ?? 80 7D 8F 00 48 89 45 98 74 08 4C 89 FF E8 ?? ?? ?? ?? 44 8B 95 70 FF FF FF BF FF FF FF FF 48 89 5D 90 45 85 D2 0F 45 BD 70 FF FF FF 89 BD 78 FF FF FF E9 BC F7 FF FF 48 8B B5 50 FF FF FF 48 8B BD 60 FF FF FF 48 89 56 10 48 8B 71 10 48 3B B5 60 FF FF FF 48 8B 76 10 48 0F 44 F9 48 89 71 10 48 8B 48 20 48 89 BD 60 FF FF FF 48 85 C9 74 08 48 8B 70 18 48 89 71 18 48 8B 70 18 48 85 F6 74 04 48 89 4E 20 48 8B 4A 08 48 8B 71 20 48 89 70 20 48 89 41 20 48 8B 70 20 48 85 F6 74 04 48 89 46 18 48 8B BD 60 FF FF FF 48 39 BD 50 FF FF FF 48 89 48 18 48 89 95 50 FF FF FF 0F 85 7D F4 FF FF 48 89 95 60 FF FF FF E9 71 F4 FF FF 44 89 F3 4C 89 FF 48 8D 0C DD 00 00 00 00 48 89 CA 48 89 8D 68 FF FF FF E8 ?? ?? ?? ?? 41 83 FE 01 0F 86 47 FB FF FF E9 A2 F9 FF FF B9 ?? ?? ?? ?? BA 4E 02 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 1D ?? ?? ?? ?? 48 3B 9D 48 FF FF FF 0F 85 C8 F7 FF FF 45 85 F6 0F 84 BF F7 FF FF 41 8D 46 FF 44 89 B5 70 FF FF FF 45 31 E4 4D 89 FE 48 8D 04 C5 08 00 00 00 48 89 85 68 FF FF FF 48 8B 83 B8 02 00 00 4E 8B 2C 20 4C 39 EB 74 13 49 8B 85 88 03 00 00 48 85 C0 74 3C 8B 70 08 85 F6 74 35 49 83 C4 08 4C 3B A5 68 FF FF FF 75 D0 4D 89 F7 44 8B B5 70 FF FF FF E9 60 F7 FF FF F6 80 15 03 00 00 02 0F 84 20 F7 FF FF 83 A9 C0 02 00 00 01 E9 2A F7 FF FF 49 83 BD E0 01 00 00 00 0F 85 E4 00 00 00 49 83 BD D0 01 00 00 00 0F 85 D6 00 00 00 4C 89 EE 4C 89 F7 E8 DF F0 FF FF 3B 85 70 FF FF FF 41 89 C7 0F 87 8E 00 00 00 85 C0 74 41 49 8B 16 49 8D 4E 08 80 A2 14 03 00 00 9F 31 D2 83 C2 01 41 39 D7 76 29 48 8B 31 80 A6 14 03 00 00 9F 85 D2 74 15 48 8B 31 48 83 BE C0 00 00 00 00 74 08 41 80 8D 15 03 00 00 80 48 83 C1 08 EB CF 89 C1 48 8D 3C CD 10 00 00 00 48 89 8D F0 FE FF FF E8 ?? ?? ?? ?? 48 85 C0 49 89 85 88 03 00 00 48 8B 8D F0 FE FF FF 74 39 48 8D 78 10 48 8D 14 CD 00 00 00 00 44 89 78 08 4C 89 F6 48 89 38 E8 ?? ?? ?? ?? E9 07 FF FF FF B9 ?? ?? ?? ?? BA 35 02 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 73 08 B9 ?? ?? ?? ?? 31 D2 BF 0C 00 00 00 E8 ?? ?? ?? ?? 49 8B 75 08 B9 ?? ?? ?? ?? 31 D2 BF 16 00 00 00 E8 ?? ?? ?? ?? 48 8B BD 48 FF FF FF B9 ?? ?? ?? ?? 31 D2 48 8B 77 08 BF 0C 00 00 00 E8 ?? ?? ?? ?? 4C 89 FF E8 ?? ?? ?? ?? 8B 8D F0 FE FF FF E9 F9 F4 FF FF C7 85 78 FF FF FF 00 00 00 00 E9 07 F5 FF FF 48 01 85 30 FF FF FF 48 89 95 38 FF FF FF 49 89 D5 E9 D0 F1 FF FF 31 F6 48 89 C7 E8 ?? ?? ?? ?? 48 85 C0 48 89 85 70 FF FF FF 0F 84 DC F9 FF FF 44 8B 1D ?? ?? ?? ?? 45 85 DB 0F 85 F8 FB FF FF 4C 89 FF E8 ?? ?? ?? ?? 49 8B BE 38 03 00 00 48 89 85 18 FF FF FF 48 85 FF 0F 84 B5 00 00 00 48 83 FF FF 0F 84 A4 00 00 00 E8 ?? ?? ?? ?? 48 83 3D ?? ?? ?? ?? 05 BA 05 00 00 00 48 8B B5 18 FF FF }
	condition:
		$1
}

rule file_242_0_0 {
	meta:
		name = "dlinfo_doit"
		size = 202
		refs = "001a _dl_signal_error 00c1 _dl_tls_get_addr_soft 0078 _dl_rtld_di_serinfo 009d strcpy"
	strings:
		$1 = { 53 48 89 FB 48 8B 7F 08 83 7B 10 0A 76 12 B9 ?? ?? ?? ?? 31 D2 31 F6 31 FF E8 ?? ?? ?? ?? 66 90 8B 43 10 FF 24 C5 ?? ?? ?? ?? 66 0F 1F 44 00 00 31 C0 48 83 BF 48 04 00 00 00 0F 85 80 00 00 00 48 8B 53 18 48 89 02 5B C3 0F 1F 80 00 00 00 00 48 8B 43 18 48 8B 57 30 48 89 10 5B C3 0F 1F 00 48 8B 43 18 48 89 38 5B C3 0F 1F 80 00 00 00 00 48 8B 73 18 31 D2 5B E9 ?? ?? ?? ?? 0F 1F 40 00 48 8B 73 18 BA 01 00 00 00 5B E9 ?? ?? ?? ?? 90 48 8B B7 38 03 00 00 48 8B 7B 18 5B E9 ?? ?? ?? ?? 0F 1F 80 00 00 00 00 48 8B 43 18 48 C7 00 00 00 00 00 48 8B 97 48 04 00 00 48 89 10 5B C3 90 E8 ?? ?? ?? ?? E9 76 FF FF FF }
	condition:
		$1
}

rule file_242_1_0 {
	meta:
		name = "__dlinfo"
		size = 47
		refs = "001f _dlerror_run"
	strings:
		$1 = { 48 83 EC 28 48 89 7C 24 08 89 74 24 10 BF ?? ?? ?? ?? 48 89 E6 48 89 0C 24 48 89 54 24 18 E8 ?? ?? ?? ?? 83 F8 01 19 C0 48 83 C4 28 F7 D0 C3 }
	condition:
		$1
}

rule file_244_0_0 {
	meta:
		name = "_nl_init_alt_digit"
		size = 173
		refs = "0034 malloc 0063 __rawmemchr 00a4 _nl_cleanup_time"
	strings:
		$1 = { 41 54 55 53 4C 8B 67 28 48 89 FB 4D 85 E4 74 69 41 8B 44 24 28 85 C0 75 5B 48 8B AB B8 01 00 00 41 C7 44 24 28 01 00 00 00 48 85 ED 74 46 BF 20 03 00 00 E8 ?? ?? ?? ?? 48 85 C0 49 89 44 24 18 74 32 31 DB EB 0F 66 2E 0F 1F 84 00 00 00 00 00 49 8B 44 24 18 48 89 2C 18 31 F6 48 89 EF 48 83 C3 08 E8 ?? ?? ?? ?? 48 81 FB 20 03 00 00 48 8D 68 01 75 DC 5B 5D 41 5C C3 BF 30 00 00 00 E8 ?? ?? ?? ?? 48 85 C0 48 89 C2 48 89 43 28 74 E5 48 89 C7 B9 06 00 00 00 4C 89 E0 F3 48 AB 49 89 D4 48 C7 43 20 ?? ?? ?? ?? E9 63 FF FF FF }
	condition:
		$1
}

rule file_244_1_0 {
	meta:
		name = "_nl_get_alt_digit"
		size = 140
		refs = "001a __pthread_rwlock_wrlock 0027 __libc_setlocale_lock 004b __pthread_rwlock_unlock"
	strings:
		$1 = { 55 89 FD 53 48 83 EC 08 83 FF 63 77 73 48 8B 86 B8 01 00 00 80 38 00 74 67 B8 ?? ?? ?? ?? 48 89 F3 48 85 C0 74 07 BF ?? ?? ?? ?? FF D0 48 8B 43 28 48 85 C0 74 32 8B 50 28 85 D2 74 2B 48 8B 40 18 48 85 C0 74 33 48 8B 1C E8 B8 ?? ?? ?? ?? 48 85 C0 74 07 BF ?? ?? ?? ?? FF D0 48 83 C4 08 48 89 D8 5B 5D C3 0F 1F 00 48 89 DF E8 E0 FE FF FF 48 8B 43 28 48 85 C0 75 C4 31 DB EB CD 0F 1F 00 31 DB 48 83 C4 08 48 89 D8 5B 5D C3 }
	condition:
		$1
}

rule file_244_2_0 {
	meta:
		name = "_nl_get_walt_digit"
		size = 281
		refs = "0028 __pthread_rwlock_wrlock 0035 __libc_setlocale_lock 006c malloc 0093 wcschr 00b3 __pthread_rwlock_unlock 0110 _nl_cleanup_time"
	strings:
		$1 = { 41 55 41 89 FD 41 54 55 53 48 83 EC 08 83 FF 63 0F 87 BB 00 00 00 48 8B 86 50 03 00 00 8B 38 85 FF 0F 84 AA 00 00 00 B8 ?? ?? ?? ?? 48 89 F3 48 85 C0 74 07 BF ?? ?? ?? ?? FF D0 4C 8B 63 28 4D 85 E4 0F 84 99 00 00 00 41 8B 4C 24 2C 85 C9 75 53 48 8B AB 50 03 00 00 41 C7 44 24 2C 01 00 00 00 48 85 ED 74 3E BF 20 03 00 00 E8 ?? ?? ?? ?? 48 85 C0 49 89 44 24 20 74 7D 31 DB EB 07 66 90 49 8B 44 24 20 48 89 2C 18 31 F6 48 89 EF 48 83 C3 08 E8 ?? ?? ?? ?? 48 81 FB 20 03 00 00 48 8D 68 04 75 DC 49 8B 44 24 20 48 85 C0 74 49 4A 8B 1C E8 B8 ?? ?? ?? ?? 48 85 C0 74 07 BF ?? ?? ?? ?? FF D0 48 83 C4 08 48 89 D8 5B 5D 41 5C 41 5D C3 48 83 C4 08 31 DB 48 89 D8 5B 5D 41 5C 41 5D C3 BF 30 00 00 00 E8 ?? ?? ?? ?? 48 85 C0 48 89 C2 48 89 43 28 75 04 31 DB EB B7 48 89 C7 B9 06 00 00 00 4C 89 E0 F3 48 AB 49 89 D4 48 C7 43 20 ?? ?? ?? ?? E9 2F FF FF FF }
	condition:
		$1
}

rule file_244_3_0 {
	meta:
		name = "_nl_parse_alt_digit"
		size = 264
		refs = "002e __pthread_rwlock_wrlock 003b __libc_setlocale_lock 0081 strlen 0098 strncmp 00b1 __pthread_rwlock_unlock"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 53 48 83 EC 18 48 8B 07 48 89 7C 24 08 48 89 04 24 48 8B 86 50 03 00 00 44 8B 08 45 85 C9 0F 84 D3 00 00 00 B8 ?? ?? ?? ?? 48 89 F3 48 85 C0 74 07 BF ?? ?? ?? ?? FF D0 48 8B 43 28 48 85 C0 0F 84 93 00 00 00 44 8B 40 28 45 85 C0 0F 84 86 00 00 00 4C 8B 68 18 4D 85 ED 0F 84 8E 00 00 00 31 ED 31 DB 41 BC FF FF FF FF 66 0F 1F 44 00 00 4D 8B 74 DD 00 4C 89 F7 E8 ?? ?? ?? ?? 48 39 E8 49 89 C7 76 19 48 8B 34 24 48 89 C2 4C 89 F7 E8 ?? ?? ?? ?? 85 C0 44 0F 44 E3 49 0F 44 EF 48 83 C3 01 48 83 FB 64 75 C8 B8 ?? ?? ?? ?? 48 85 C0 74 07 BF ?? ?? ?? ?? FF D0 41 83 FC FF 74 39 48 8B 44 24 08 48 01 28 48 83 C4 18 44 89 E0 5B 5D 41 5C 41 5D 41 5E 41 5F C3 48 89 DF E8 B7 FC FF FF 48 8B 43 28 48 85 C0 0F 85 65 FF FF FF 31 ED 41 BC FF FF FF FF EB B0 41 BC FF FF FF FF EB C7 }
	condition:
		$1
}

rule file_246_0_0 {
	meta:
		name = "is_dst"
		size = 219
	strings:
		$1 = { 44 0F B6 0E 45 31 D2 41 80 F9 7B 74 7B 31 C0 44 3A 0A 74 1B EB 32 66 2E 0F 1F 84 00 00 00 00 00 48 83 C0 01 44 0F B6 0C 06 44 3A 0C 02 75 19 45 84 C9 75 EC 45 84 D2 74 22 0F 1F 80 00 00 00 00 31 C0 C3 0F 1F 44 00 00 45 84 D2 74 1B 41 80 F9 7D 75 ED 48 83 EE 01 48 83 C0 02 45 85 C0 75 3C F3 C3 66 0F 1F 44 00 00 41 80 F9 2F 74 ED 45 84 C9 74 E8 85 C9 74 C9 41 80 F9 3A 75 C3 0F 1F 00 EB D9 66 0F 1F 44 00 00 44 0F B6 4E 01 41 BA 01 00 00 00 48 83 C6 01 E9 71 FF FF FF 0F B6 14 06 80 FA 2F 74 24 84 D2 74 20 85 C9 74 93 80 FA 3A 75 8E 48 83 C7 01 48 39 FE 74 A5 80 7E FE 3A BA 00 00 00 00 48 0F 45 C2 C3 48 83 C7 01 48 39 FE 74 8E 85 C9 75 E5 E9 65 FF FF FF }
	condition:
		$1
}

rule file_246_1_0 {
	meta:
		name = "local_strdup"
		size = 89
		refs = "0012 strlen 001e malloc 003f memcpy"
		altNames = "__strdup"
	strings:
		$1 = { 48 89 5C 24 F0 48 89 6C 24 F8 48 83 EC 18 48 89 FB E8 ?? ?? ?? ?? 48 8D 68 01 48 89 EF E8 ?? ?? ?? ?? 48 85 C0 74 21 48 89 EA 48 89 DE 48 8B 6C 24 10 48 8B 5C 24 08 48 89 C7 48 83 C4 18 E9 ?? ?? ?? ?? 0F 1F 44 00 00 31 C0 48 8B 5C 24 08 48 8B 6C 24 10 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_246_2_0 {
	meta:
		name = "fillin_rpath"
		size = 769
		refs = "003b __strsep_g 004f strlen 00ad _dl_all_dirs 00da memcmp 0182 malloc 01ae mempcpy 0216 memcpy 02de _dl_signal_error"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 48 89 F5 53 31 DB 48 83 EC 48 48 89 7C 24 38 48 89 54 24 18 89 4C 24 24 4C 89 44 24 30 4C 89 4C 24 10 0F 1F 44 00 00 48 8B 74 24 18 48 8D 7C 24 38 E8 ?? ?? ?? ?? 48 85 C0 49 89 C7 0F 84 21 02 00 00 4C 89 FF E8 ?? ?? ?? ?? 48 85 C0 49 89 C6 0F 84 E1 01 00 00 48 83 F8 01 76 29 41 80 7C 07 FF 2F 74 17 E9 DE 01 00 00 66 0F 1F 44 00 00 43 80 7C 37 FF 2F 0F 85 CC 01 00 00 49 83 EE 01 49 83 FE 01 75 EA 41 80 3F 2F 41 BE 01 00 00 00 0F 85 B2 01 00 00 8B 44 24 24 85 C0 0F 85 E9 01 00 00 4C 8B 25 ?? ?? ?? ?? 4D 85 E4 0F 84 86 00 00 00 4D 89 E5 EB 0A 90 4D 8B 6D 00 4D 85 ED 74 77 4D 39 75 20 75 F1 49 8B 75 18 4C 89 F2 4C 89 FF E8 ?? ?? ?? ?? 85 C0 75 DE 48 85 DB 0F 84 9C 01 00 00 4C 3B 6D 00 90 0F 84 3A FF FF FF 31 C0 0F 1F 84 00 00 00 00 00 48 83 C0 01 48 39 D8 74 17 4C 39 6C C5 00 75 F0 48 39 C3 0F 85 17 FF FF FF 0F 1F 80 00 00 00 00 48 8D 14 C5 00 00 00 00 48 8D 58 01 4C 89 6C 15 00 E9 FA FE FF FF 66 2E 0F 1F 84 00 00 00 00 00 48 83 7C 24 10 00 0F 84 12 01 00 00 48 8B 7C 24 10 E8 ?? ?? ?? ?? 48 83 C0 01 48 89 44 24 28 4C 8B 15 ?? ?? ?? ?? 4A 8D 14 95 28 00 00 00 4C 89 14 24 49 8D 7C 16 01 48 03 7C 24 28 48 89 54 24 08 E8 ?? ?? ?? ?? 48 85 C0 49 89 C5 48 8B 54 24 08 4C 8B 14 24 0F 84 34 01 00 00 48 8D 3C 10 4C 89 FE 4C 89 F2 48 89 78 18 4C 89 14 24 E8 ?? ?? ?? ?? 4C 3B 35 ?? ?? ?? ?? C6 00 00 4D 89 75 20 4C 8B 14 24 76 07 4C 89 35 ?? ?? ?? ?? 31 C0 41 80 3F 2F 0F 95 C0 31 D2 01 C0 4D 85 D2 74 0F 90 41 89 44 95 28 48 83 C2 01 4C 39 D2 75 F2 48 83 7C 24 10 00 48 8B 44 24 30 49 89 45 08 0F 84 BF 00 00 00 4B 8D 7C 96 29 48 8B 54 24 28 48 8B 74 24 10 4C 01 EF E8 ?? ?? ?? ?? 49 89 45 10 4D 89 65 00 4C 89 2D ?? ?? ?? ?? 4C 89 6C DD 00 48 83 C3 01 E9 F9 FD FF FF 66 0F 1F 84 00 00 00 00 00 41 BF ?? ?? ?? ?? E9 53 FE FF FF 0F 1F 44 00 00 43 C6 04 37 2F 49 83 C6 01 E9 40 FE FF FF 48 C7 44 24 28 00 00 00 00 E9 F3 FE FF FF 48 C7 44 DD 00 00 00 00 00 48 83 C4 48 48 89 E8 5B 5D 41 5C 41 5D 41 5E 41 5F C3 BB 01 00 00 00 31 D2 E9 99 FE FF FF 49 83 FE 07 74 49 49 83 FE 0B 0F 85 8D FD FF FF BA 0B 00 00 00 4C 89 FE BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 0F 85 73 FD FF FF E9 E8 FD FF FF 49 C7 45 10 00 00 00 00 E9 4F FF FF FF B9 ?? ?? ?? ?? 31 D2 31 F6 BF 0C 00 00 00 E8 ?? ?? ?? ?? BA 07 00 00 00 4C 89 FE BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 0F 85 34 FD FF FF E9 A9 FD FF FF }
	condition:
		$1
}

rule file_246_3_0 {
	meta:
		name = "lose"
		size = 118
		refs = "002a __close 0041 free 0062 _dl_debug_state 0072 _dl_signal_error"
	strings:
		$1 = { 41 57 49 89 CF 41 56 4D 89 CE 41 55 49 89 D5 41 54 41 89 FC 55 53 4C 89 C3 48 83 EC 08 83 FE FF 48 8B 6C 24 40 74 07 89 F7 E8 ?? ?? ?? ?? 48 85 DB 74 12 48 8B BB 38 03 00 00 48 83 FF FF 74 05 E8 ?? ?? ?? ?? 48 89 DF E8 ?? ?? ?? ?? 4C 89 FF E8 ?? ?? ?? ?? 48 85 ED 74 0C C7 45 18 00 00 00 00 E8 ?? ?? ?? ?? 4C 89 F1 31 D2 4C 89 EE 44 89 E7 E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_246_4_0 {
	meta:
		name = "add_name_to_object.isra.2"
		size = 228
		refs = "0033 strcmp 0054 strlen 0061 malloc 0078 memcpy 00cc __assert_fail 00e0 _dl_signal_error"
	strings:
		$1 = { 41 55 41 54 55 48 89 F5 53 48 89 FB 48 83 EC 08 48 85 FF 75 17 E9 87 00 00 00 66 0F 1F 44 00 00 48 8B 43 08 48 85 C0 74 27 48 89 C3 48 8B 33 48 89 EF E8 ?? ?? ?? ?? 85 C0 75 E5 48 83 C4 08 5B 5D 41 5C 41 5D C3 66 2E 0F 1F 84 00 00 00 00 00 48 89 EF E8 ?? ?? ?? ?? 48 8D 78 19 4C 8D 68 01 E8 ?? ?? ?? ?? 48 85 C0 49 89 C4 74 63 48 8D 78 18 4C 89 EA 48 89 EE E8 ?? ?? ?? ?? 49 C7 44 24 08 00 00 00 00 49 89 04 24 4C 89 63 08 41 C7 44 24 10 00 00 00 00 48 83 C4 08 5B 5D 41 5C 41 5D C3 48 89 F7 E8 ?? ?? ?? ?? 48 8D 78 19 E8 ?? ?? ?? ?? 48 85 C0 74 19 B9 ?? ?? ?? ?? BA DA 01 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? B9 ?? ?? ?? ?? 31 D2 48 89 EE BF 0C 00 00 00 E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_246_5_0 {
	meta:
		name = "_dl_map_object_from_fd"
		size = 3803
		refs = "003c _dl_debug_initialize 005a __fxstat64 0075 _dl_ns 00bb __close 00c7 free 00ec _dl_debug_mask 0137 _dl_new_object 02eb _dl_next_tls_modid 0333 _dl_pagesize 045e _dl_use_load_bias 0490 __mmap 0554 memset 083b _dl_stack_flags 08b4 _dl_setup_hash 08e3 _dl_profile 090b _dl_add_to_namespace_list 0936 __mprotect 094f _dl_debug_state 0978 __lseek 098d __libc_read 0a0b _dl_initfirst 0b25 malloc 0b3c memcpy 0bb5 memmove 0bd8 __libc_errno 0c31 _dl_tls_dtv_slotinfo_list 0c3d _dl_tls_setup 0c48 _dl_allocate_tls 0c83 _dl_deallocate_tls 0c9d _dl_tls_max_dtv_idx 0ce2 __assert_fail 0d26 _dl_debug_printf 0da5 __munmap 0e46 __stack_prot 0e51 _dl_make_stack_executable_hook"
	strings:
		$1 = { 55 48 89 E5 41 57 41 56 41 55 4D 89 C5 41 54 45 89 CC 53 48 81 EC 38 01 00 00 89 B5 1C FF FF FF 48 8B 75 20 48 89 BD 08 FF FF FF 31 FF 48 89 95 20 FF FF FF 48 89 8D 00 FF FF FF E8 ?? ?? ?? ?? 8B B5 1C FF FF FF 48 8D 95 40 FF FF FF BF 01 00 00 00 48 89 85 10 FF FF FF E8 ?? ?? ?? ?? 85 C0 0F 88 99 0C 00 00 48 8B 75 20 48 8D 04 F6 48 C1 E0 04 48 8B 98 ?? ?? ?? ?? 48 85 DB 74 62 48 8B 85 48 FF FF FF 48 8B 95 40 FF FF FF EB 0B 66 90 48 8B 5B 18 48 85 DB 74 47 F6 83 15 03 00 00 20 75 EE 48 39 83 A0 03 00 00 75 E5 48 39 93 98 03 00 00 75 DC 8B BD 1C FF FF FF E8 ?? ?? ?? ?? 48 8B BD 00 FF FF FF E8 ?? ?? ?? ?? 48 8B 7B 38 48 8B B5 08 FF FF FF E8 35 FE FF FF E9 2F 08 00 00 F6 45 10 04 0F 85 EC 09 00 00 F6 05 ?? ?? ?? ?? 40 0F 85 1C 0C 00 00 4C 8B 8D 10 FF FF FF 41 8B 41 18 85 C0 0F 84 3C 08 00 00 83 F8 01 0F 85 1C 0C 00 00 C6 85 19 FF FF FF 00 4C 8B 4D 20 44 8B 45 10 4C 89 E9 48 8B B5 08 FF FF FF 48 8B BD 00 FF FF FF 44 89 E2 E8 ?? ?? ?? ?? 48 85 C0 48 89 C3 0F 84 01 0C 00 00 48 8B 95 20 FF FF FF 48 8B 42 20 0F B7 4A 18 48 89 83 A8 02 00 00 0F B7 42 40 66 89 8D 1A FF FF FF 48 8B 8D 20 FF FF FF 48 8D 14 C5 00 00 00 00 49 89 C5 66 89 83 B0 02 00 00 49 C1 E5 06 49 29 D5 48 8B 95 20 FF FF FF 48 8B 72 28 49 8D 54 35 00 48 3B 11 0F 87 BE 07 00 00 4C 8D 64 31 08 48 8D 04 40 48 89 A5 F8 FE FF FF 4D 01 E5 48 C1 E0 04 48 83 C0 16 25 F0 FF FF 00 48 29 C4 4C 8D 7C 24 3F 49 C1 EF 03 4D 39 EC 4A 8D 34 FD 00 00 00 00 48 89 B5 38 FF FF FF 0F 83 0F 09 00 00 4C 89 E2 45 31 F6 45 31 ED 4C 89 BD 28 FF FF FF 48 C7 85 30 FF FF FF 07 00 00 00 4D 89 EF 45 89 F5 4D 89 E6 49 89 DC 48 89 D3 EB 57 0F 1F 80 00 00 00 00 83 F8 01 0F 84 0F 01 00 00 83 F8 02 75 1A 48 8B 43 10 49 89 44 24 10 48 8B 43 28 48 C1 E8 04 66 41 89 84 24 B2 02 00 00 41 0F B7 84 24 B0 02 00 00 48 83 C3 38 48 8D 14 C5 00 00 00 00 48 C1 E0 06 48 29 D0 4C 01 F0 48 39 C3 0F 83 A0 01 00 00 8B 03 83 F8 06 0F 84 65 01 00 00 76 A3 3D 51 E5 74 64 0F 84 A0 00 00 00 3D 52 E5 74 64 74 79 83 F8 07 75 B4 48 8B 43 28 48 85 C0 74 AB 49 89 84 24 28 04 00 00 48 8B 43 30 48 85 C0 49 89 84 24 30 04 00 00 0F 85 3E 01 00 00 49 C7 84 24 38 04 00 00 00 00 00 00 48 8B 43 20 49 89 84 24 20 04 00 00 48 8B 43 10 49 89 84 24 18 04 00 00 41 0F B6 84 24 14 03 00 00 83 E0 03 3C 01 0F 85 44 09 00 00 E8 ?? ?? ?? ?? 49 89 84 24 48 04 00 00 E9 44 FF FF FF 0F 1F 40 00 48 8B 43 10 49 89 84 24 50 04 00 00 48 8B 43 28 49 89 84 24 58 04 00 00 E9 23 FF FF FF 0F 1F 00 44 8B 4B 04 4C 89 8D 30 FF FF FF E9 10 FF FF FF 48 8B 0D ?? ?? ?? ?? 48 8B 43 30 48 8D 71 FF 48 85 F0 0F 85 0B 08 00 00 48 8B 53 10 48 8B 7B 08 48 83 E8 01 49 89 D0 49 29 F8 4C 85 C0 0F 85 FE 07 00 00 4B 8D 04 7F 49 89 D0 4C 03 43 20 49 89 D3 48 03 53 28 48 F7 D9 48 C1 E0 04 48 03 85 38 FF FF FF 49 83 C7 01 49 21 CB 4C 01 C6 48 21 CE 48 21 F9 49 83 FF 01 4C 89 18 48 89 70 08 4C 89 40 10 48 89 50 18 48 89 48 20 76 0D 4C 3B 58 D8 BA 01 00 00 00 44 0F 45 EA 8B 4B 04 BA 40 62 51 73 83 E1 07 C1 E1 02 D3 FA 83 E2 0F 89 50 28 E9 6C FE FF FF 0F 1F 40 00 48 8B 43 10 49 89 84 24 A0 02 00 00 E9 57 FE FF FF 0F 1F 80 00 00 00 00 48 83 E8 01 48 23 43 10 49 89 84 24 38 04 00 00 E9 B9 FE FF FF 0F 1F 00 4C 89 E3 4D 89 F4 45 89 EE 4D 89 FD 4C 8B BD 28 FF FF FF 4D 85 ED 0F 84 D0 06 00 00 4C 8B 95 38 FF FF FF 4F 8D 5C 6D FD 4A 8B 3C FD 00 00 00 00 49 C1 E3 04 4D 01 D3 49 8B 43 18 48 29 F8 66 83 BD 1A FF FF FF 03 48 89 85 28 FF FF FF 0F 85 8A 07 00 00 48 23 3D ?? ?? ?? ?? 42 8B 14 FD 28 00 00 00 B9 02 08 00 00 4E 8B 0C FD 20 00 00 00 44 8B 85 1C FF FF FF 48 89 C6 4C 89 95 E8 FE FF FF 4C 89 9D F0 FE FF FF E8 ?? ?? ?? ?? 48 83 F8 FF 48 89 83 40 03 00 00 4C 8B 95 E8 FE FF FF 4C 8B 9D F0 FE FF FF 0F 84 30 01 00 00 48 8B 95 28 FF FF FF 48 01 C2 4A 2B 04 FD 00 00 00 00 45 84 F6 48 89 93 48 03 00 00 48 89 03 0F 85 49 04 00 00 80 8B 15 03 00 00 40 41 8B 52 28 F6 C2 04 0F 85 04 01 00 00 48 83 BB A0 02 00 00 00 0F 84 12 01 00 00 49 8B 42 18 49 8B 4A 10 48 39 C8 76 75 4C 8B 3B 48 8B 35 ?? ?? ?? ?? 4C 01 F9 49 01 C7 48 89 F0 4C 8D 74 31 FF 48 F7 D8 49 21 C6 4D 39 FE 4D 0F 47 F7 4C 39 F1 73 42 F6 C2 02 0F 84 3C 09 00 00 4C 89 F2 31 F6 48 89 CF 48 29 CA 48 89 8D F0 FE FF FF 4C 89 95 E8 FE FF FF E8 ?? ?? ?? ?? 4C 8B 95 E8 FE FF FF 48 8B 8D F0 FE FF FF 41 8B 52 28 F6 C2 02 0F 84 40 09 00 00 4D 39 F7 0F 87 3C 04 00 00 49 83 C2 30 4B 8D 44 6D 00 48 C1 E0 04 48 03 85 38 FF FF FF 49 39 C2 0F 83 D1 00 00 00 49 8B 72 08 49 8B 02 48 39 C6 0F 86 36 FF FF FF 48 89 C7 48 03 3B 41 8B 52 28 4D 8B 4A 20 44 8B 85 1C FF FF FF 48 29 C6 B9 12 08 00 00 4C 89 95 E8 FE FF FF E8 ?? ?? ?? ?? 48 83 F8 FF 4C 8B 95 E8 FE FF FF 0F 85 FC FE FF FF 41 BC ?? ?? ?? ?? E9 08 04 00 00 66 90 49 8B 42 08 48 03 03 48 83 BB A0 02 00 00 00 48 89 83 50 03 00 00 0F 85 EE FE FF FF 48 8B B5 20 FF FF FF 49 8B 42 20 48 8B 4E 28 48 39 C8 0F 87 D6 FE FF FF 4C 8B 8D 20 FF FF FF 4D 8B 02 48 89 C6 41 0F B7 79 40 4C 29 C6 49 03 72 08 4C 8D 0C FD 00 00 00 00 48 C1 E7 06 4C 29 CF 48 01 CF 48 39 FE 0F 82 A2 FE FF FF 4C 01 C1 48 29 C1 48 89 8B A0 02 00 00 E9 90 FE FF FF 44 0F B7 AD 1A FF FF FF 48 8B 53 10 48 8B A5 F8 FE FF FF 48 85 D2 0F 84 03 04 00 00 48 8B 33 48 01 F2 48 85 D2 48 89 53 10 0F 84 79 01 00 00 48 8B 02 4C 8D 53 40 48 85 C0 74 59 BF FF FF FF 6F 41 B9 FF FD FF 6F 41 BB FF FE FF 6F 41 B8 21 00 00 70 EB 29 66 90 48 89 F9 48 29 C1 48 83 F9 0F 0F 87 60 03 00 00 4C 89 C1 48 29 C1 48 89 54 CB 40 48 83 C2 10 48 8B 02 48 85 C0 74 17 48 83 F8 21 77 D3 48 89 54 C3 40 48 83 C2 10 48 8B 02 48 85 C0 75 E9 48 85 F6 74 71 48 8B 43 60 48 85 C0 74 04 48 01 70 08 48 8B 43 58 48 85 C0 74 04 48 01 70 08 48 8B 43 68 48 85 C0 74 04 48 01 70 08 48 8B 43 70 48 85 C0 74 04 48 01 70 08 48 8B 43 78 48 85 C0 74 04 48 01 70 08 48 8B 83 F8 00 00 00 48 85 C0 74 04 48 01 70 08 48 8B 83 C8 01 00 00 48 85 C0 74 04 48 01 70 08 48 8B 83 98 02 00 00 48 85 C0 74 04 48 01 70 08 48 8B 83 E0 00 00 00 48 85 C0 74 0B 48 83 78 08 07 0F 85 42 05 00 00 48 83 7B 78 00 74 12 48 8B 83 88 00 00 00 48 83 78 08 18 0F 85 42 05 00 00 48 8B 93 30 01 00 00 48 85 D2 74 2B 48 8B 42 08 A8 02 89 83 D8 03 00 00 74 07 48 89 93 C0 00 00 00 A8 04 74 07 48 89 93 F0 00 00 00 A8 08 74 07 48 89 93 00 01 00 00 48 8B 83 70 01 00 00 48 85 C0 74 16 48 8B 50 08 89 93 D4 03 00 00 83 E2 01 74 07 48 89 83 00 01 00 00 48 83 BB 28 01 00 00 00 74 0B 48 C7 83 B8 00 00 00 00 00 00 00 F6 83 D4 03 00 00 40 0F 85 69 05 00 00 48 8B 83 A0 02 00 00 48 85 C0 0F 84 D7 02 00 00 48 03 03 48 89 83 A0 02 00 00 8B 05 ?? ?? ?? ?? F7 D0 83 E0 01 48 85 85 30 FF FF FF 0F 85 F3 05 00 00 48 8B 83 18 04 00 00 48 85 C0 74 0A 48 03 03 48 89 83 18 04 00 00 8B BD 1C FF FF FF E8 ?? ?? ?? ?? 85 C0 0F 85 F1 05 00 00 0F B6 83 14 03 00 00 89 C2 83 E2 03 80 FA 01 0F 84 85 01 00 00 4C 8B 03 4C 89 C0 48 03 83 A8 02 00 00 F6 05 ?? ?? ?? ?? 40 48 89 83 A8 02 00 00 0F 85 30 05 00 00 48 89 DF E8 ?? ?? ?? ?? F6 45 10 08 75 0E 48 83 BB C0 00 00 00 00 0F 85 A3 02 00 00 F6 83 D4 03 00 00 20 0F 85 2F 01 00 00 48 8B 85 40 FF FF FF 48 83 3D ?? ?? ?? ?? 00 48 89 83 98 03 00 00 48 8B 85 48 FF FF FF 48 89 83 A0 03 00 00 0F 85 50 04 00 00 48 8B 75 20 48 89 DF E8 ?? ?? ?? ?? 48 8D 65 D8 48 89 D8 5B 41 5C 41 5D 41 5E 41 5F 5D C3 4A 8B 14 FD 08 00 00 00 49 8B 33 48 8D 3C 10 48 29 D6 31 D2 E8 ?? ?? ?? ?? 4C 8B 95 E8 FE FF FF E9 92 FB FF FF 41 C7 41 18 01 00 00 00 E8 ?? ?? ?? ?? C6 85 19 FF FF FF 01 E9 BB F7 FF FF 49 8D 45 1E 8B BD 1C FF FF FF 31 D2 48 83 E0 F0 48 29 C4 4C 8D 64 24 47 E8 ?? ?? ?? ?? 8B BD 1C FF FF FF 49 83 E4 F0 4C 89 EA 4C 89 E6 E8 ?? ?? ?? ?? 4C 39 E8 0F 85 E3 03 00 00 0F B7 83 B0 02 00 00 48 8D 14 C5 00 00 00 00 49 89 C5 49 C1 E5 06 49 29 D5 E9 EE F7 FF FF 41 8B 52 28 4C 89 FE 45 31 C9 4C 29 F6 41 B8 FF FF FF FF B9 32 00 00 00 4C 89 F7 4C 89 95 E8 FE FF FF E8 ?? ?? ?? ?? 48 83 F8 FF 4C 8B 95 E8 FE FF FF 0F 85 8C FB FF FF 41 BC ?? ?? ?? ?? 48 8B A5 F8 FE FF FF E9 D3 01 00 00 66 0F 1F 44 00 00 48 89 1D ?? ?? ?? ?? E9 C5 FE FF FF 41 83 FD 02 0F 85 71 FE FF FF 83 E0 FC 88 83 14 03 00 00 E9 63 FE FF FF 0F 1F 40 00 8D 0C 00 D1 F9 83 F9 FC 76 0F F7 D1 8D 41 32 48 89 54 C3 40 E9 A9 FC FF FF 4C 89 C9 48 29 C1 48 83 F9 0B 77 12 48 2D 34 FE FF 6F 48 F7 D8 49 89 14 C2 E9 74 FC FF FF 4C 89 D9 48 29 C1 48 83 F9 0A 0F 87 64 FC FF FF 48 2D 40 FF FF 6F 48 F7 D8 49 89 14 C2 E9 52 FC FF FF 41 83 FD 03 0F 85 7F FD FF FF 45 31 F6 41 BC ?? ?? ?? ?? 80 BD 19 FF FF FF 00 B8 00 00 00 00 4D 89 E1 48 0F 45 85 10 FF FF FF 49 89 D8 44 89 F7 48 89 04 24 48 8B 8D 00 FF FF FF 48 8B 95 08 FF FF FF 8B B5 1C FF FF FF E8 BA F3 FF FF 48 8B BD 00 FF FF FF 31 DB E8 ?? ?? ?? ?? 8B BD 1C FF FF FF E8 ?? ?? ?? ?? E9 1B FE FF FF 45 31 F6 41 BC ?? ?? ?? ?? 48 8B A5 F8 FE FF FF EB 96 48 8B 95 20 FF FF FF 44 0F B7 72 40 4A 8D 04 F5 00 00 00 00 49 C1 E6 06 49 29 C6 4C 89 F7 E8 ?? ?? ?? ?? 48 85 C0 0F 84 9D 00 00 00 4C 89 F2 4C 89 E6 48 89 C7 E8 ?? ?? ?? ?? 80 8B 14 03 00 00 80 48 89 83 A0 02 00 00 E9 E6 FC FF FF 4C 89 E3 45 31 F6 41 BC ?? ?? ?? ?? EB 9C 4C 89 E3 45 31 F6 41 BC ?? ?? ?? ?? EB 8E 48 8B 93 80 03 00 00 48 8D 83 B8 02 00 00 48 39 02 0F 84 46 FD FF FF 48 8B 83 C8 02 00 00 48 89 18 48 8B 83 78 03 00 00 48 8B B3 80 03 00 00 C7 83 D0 02 00 00 01 00 00 00 48 8D 14 C5 F8 FF FF FF 48 8D 7E 08 E8 ?? ?? ?? ?? 48 8B 83 80 03 00 00 48 8D 93 C8 02 00 00 48 89 10 E9 FD FC FF FF 41 BC ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? 64 44 8B 30 E9 B7 FE FF FF F7 45 10 00 00 00 20 0F 84 9A 00 00 00 48 03 3B 0F B6 83 15 03 00 00 41 83 F6 01 41 83 E6 01 41 C1 E6 06 48 89 BB 40 03 00 00 48 03 BD 28 FF FF FF 83 E0 BF 44 09 F0 88 83 15 03 00 00 48 89 BB 48 03 00 00 E9 52 F9 FF FF 48 83 3D ?? ?? ?? ?? 00 0F 85 AE F6 FF FF E8 ?? ?? ?? ?? 85 C0 75 74 31 FF E8 ?? ?? ?? ?? 48 85 C0 48 89 C6 74 65 48 89 00 48 89 40 10 BF 02 10 00 00 B8 9E 00 00 00 0F 05 85 C0 74 2F 49 89 F0 BE 01 00 00 00 4C 89 E3 4C 89 C7 45 31 F6 41 BC ?? ?? ?? ?? E8 ?? ?? ?? ?? E9 71 FE FF FF 45 31 F6 41 BC ?? ?? ?? ?? E9 63 FE FF FF 48 8B 05 ?? ?? ?? ?? 48 83 C0 01 48 89 05 ?? ?? ?? ?? 49 89 84 24 48 04 00 00 E9 87 F5 FF FF 4C 89 E3 41 BE 0C 00 00 00 41 BC ?? ?? ?? ?? E9 30 FE FF FF B9 ?? ?? ?? ?? BA BC 00 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? B9 ?? ?? ?? ?? BA C4 00 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? C6 85 19 FF FF FF 00 41 BC ?? ?? ?? ?? 31 DB E9 C2 FE FF FF 48 8B 55 20 48 8B B5 08 FF FF FF BF ?? ?? ?? ?? 31 C0 E8 ?? ?? ?? ?? E9 C8 F3 FF FF B9 ?? ?? ?? ?? BA 17 04 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 41 BC ?? ?? ?? ?? E9 82 FE FF FF 48 8B 83 B0 00 00 00 48 85 C0 0F 84 A0 FB FF FF 48 8B 53 68 48 8B 7B 38 48 8B 72 08 48 03 70 08 E8 98 F1 FF FF E9 86 FB FF FF 41 BC ?? ?? ?? ?? E9 4D FE FF FF 8B 4D 10 85 C9 0F 89 8C FA FF FF 48 8B BB 40 03 00 00 48 8B B3 48 03 00 00 48 29 FE E8 ?? ?? ?? ?? 48 8B 7B 38 8B 57 10 85 D2 75 05 E8 ?? ?? ?? ?? 45 31 F6 80 BB 14 03 00 00 00 41 BC ?? ?? ?? ?? 0F 89 CD FC FF FF 48 8B BB A0 02 00 00 E8 ?? ?? ?? ?? E9 BC FC FF FF 0F B7 8B B0 02 00 00 48 8B 53 10 41 B9 10 00 00 00 C7 44 24 28 10 00 00 00 BE 10 00 00 00 BF ?? ?? ?? ?? 89 4C 24 30 48 8B 8B A0 02 00 00 48 89 44 24 10 C7 44 24 18 10 00 00 00 31 C0 C7 44 24 08 10 00 00 00 48 89 4C 24 20 48 8B 8D 28 FF FF FF 48 89 0C 24 B9 10 00 00 00 E8 ?? ?? ?? ?? E9 6C FA FF FF 83 0D ?? ?? ?? ?? 07 48 8B 7D 18 FF 15 ?? ?? ?? ?? 85 C0 41 89 C6 0F 84 F1 F9 FF FF 41 BC ?? ?? ?? ?? E9 31 FC FF FF 41 BC ?? ?? ?? ?? E9 5F FD FF FF 48 89 C7 83 CA 02 48 89 8D F0 FE FF FF 48 21 CF 4C 89 95 E8 FE FF FF E8 ?? ?? ?? ?? 85 C0 48 8B 8D F0 FE FF FF 4C 8B 95 E8 FE FF FF 0F 89 92 F6 FF FF 41 BC ?? ?? ?? ?? E9 43 FB FF FF 48 8B 35 ?? ?? ?? ?? 4C 89 95 E8 FE FF FF 48 89 F7 48 F7 DF 48 21 CF E8 ?? ?? ?? ?? 4C 8B 95 E8 FE FF FF E9 98 F6 FF FF }
	condition:
		$1
}

rule file_246_6_0 {
	meta:
		name = "open_verify.isra.3"
		size = 1135
		refs = "0026 __open 0039 __libc_errno 0054 __libc_read 0076 memcmp 01d7 _dl_osversion 023f __close 0287 __lseek 03a1 memcpy 03ad free"
	strings:
		$1 = { 55 31 C0 48 89 E5 41 57 49 89 D7 41 56 41 55 41 54 53 48 89 F3 BE 00 00 08 00 48 83 EC 28 48 89 7D C0 88 4D CB E8 ?? ?? ?? ?? 83 F8 FF 89 45 CC 0F 84 CA 01 00 00 48 8B 05 ?? ?? ?? ?? 4C 8D 63 08 8B 7D CC BA 40 03 00 00 4C 89 E6 64 C7 00 00 00 00 00 E8 ?? ?? ?? ?? 48 83 F8 3F 49 89 C6 48 89 03 0F 8E C3 02 00 00 BA 08 00 00 00 BE ?? ?? ?? ?? 4C 89 E7 E8 ?? ?? ?? ?? 85 C0 0F 85 8A 02 00 00 0F B6 43 10 84 C0 0F 85 84 01 00 00 48 8D 7B 11 BA 07 00 00 00 BE ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 0F 85 77 01 00 00 83 7B 1C 01 0F 85 4B 03 00 00 66 83 7B 1A 3E 0F 85 7D 01 00 00 0F B7 43 18 48 83 F8 03 0F 85 1B 03 00 00 66 83 7B 3E 38 0F 85 F0 02 00 00 0F B7 4B 40 48 8B 73 28 48 8D 04 CD 00 00 00 00 49 89 CF 49 C1 E7 06 49 29 C7 49 8D 04 37 4C 39 F0 0F 87 C2 01 00 00 4C 8D 74 33 08 4D 01 F7 4D 39 FE 0F 83 F1 00 00 00 4D 89 F7 EB 26 0F 1F 40 00 48 8D 14 CD 00 00 00 00 48 89 C8 49 83 C7 38 48 C1 E0 06 48 29 D0 4C 01 F0 49 39 C7 0F 83 C6 00 00 00 41 83 3F 04 75 D8 4D 8B 67 20 49 83 FC 1F 76 CE 49 83 7F 30 03 76 C7 49 8B 77 08 4A 8D 04 26 48 3B 03 0F 87 0E 01 00 00 4C 8D 6C 33 08 EB 38 0F 1F 80 00 00 00 00 41 8B 75 00 41 8B 45 04 49 8D 54 24 E0 48 83 C6 03 48 83 C0 03 48 83 E6 FC 48 83 E0 FC 48 8D 44 06 0C 48 39 D0 0F 87 C5 00 00 00 49 29 C4 49 01 C5 BA 10 00 00 00 BE ?? ?? ?? ?? 4C 89 EF E8 ?? ?? ?? ?? 85 C0 75 B9 4D 85 E4 0F 84 A0 00 00 00 45 8B 45 10 41 8B 7D 14 41 8B 55 18 41 8B 75 1C 45 85 C0 75 66 8B 05 ?? ?? ?? ?? 85 C0 74 21 40 0F B6 CF 81 E2 FF 00 00 00 81 E6 FF 00 00 00 C1 E1 08 01 CA C1 E2 08 01 F2 39 C2 77 3E 0F 1F 00 8B 45 CC 48 8D 65 D8 5B 41 5C 41 5D 41 5E 41 5F 5D C3 80 7B 0F 03 75 08 3C 02 0F 86 6E FE FF FF 81 7B 08 7F 45 4C 46 0F 85 3F 01 00 00 80 7B 0C 02 0F 84 80 01 00 00 41 C6 07 01 8B 7D CC E8 ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? C7 45 CC FF FF FF FF 64 C7 00 02 00 00 00 EB A6 66 0F 1F 44 00 00 0F B7 4B 40 E9 AF FE FF FF 0F 1F 80 00 00 00 00 49 8D 44 24 1E 8B 7D CC 31 D2 48 83 E0 F0 48 29 C4 4C 8D 6C 24 17 E8 ?? ?? ?? ?? 8B 7D CC 49 83 E5 F0 4C 89 E2 4C 89 EE E8 ?? ?? ?? ?? 49 39 C4 0F 84 FB FE FF FF 48 8B 05 ?? ?? ?? ?? BB ?? ?? ?? ?? 64 44 8B 30 E9 8C 00 00 00 0F 1F 44 00 00 49 8D 47 1E 8B 7D CC 31 D2 48 83 E0 F0 48 29 C4 4C 8D 74 24 17 E8 ?? ?? ?? ?? 8B 7D CC 49 83 E6 F0 4C 89 FA 4C 89 F6 E8 ?? ?? ?? ?? 49 39 C7 75 B5 0F B7 4B 40 48 8D 04 CD 00 00 00 00 49 89 CF 49 C1 E7 06 49 29 C7 E9 F7 FD FF FF BA 08 00 00 00 BE ?? ?? ?? ?? 4C 89 E7 E8 ?? ?? ?? ?? 85 C0 0F 84 5C FD FF FF E9 F5 FE FF FF 48 8B 05 ?? ?? ?? ?? BB ?? ?? ?? ?? 64 44 8B 30 B8 ?? ?? ?? ?? 45 85 F6 48 0F 45 D8 80 7D CB 00 75 29 48 8B 55 C0 8B 75 CC 49 89 D9 48 C7 04 24 00 00 00 00 45 31 C0 31 C9 44 89 F7 E8 44 EC FF FF 45 31 F6 BB ?? ?? ?? ?? EB D1 48 8B 7D C0 31 C0 48 83 C9 FF 48 8B 75 C0 F2 AE 48 89 CA 48 F7 D2 48 8D 42 1E 48 83 E0 F0 48 29 C4 48 8D 7C 24 17 48 83 E7 F0 E8 ?? ?? ?? ?? 48 8B 7D C0 49 89 C7 E8 ?? ?? ?? ?? 4C 89 7D C0 EB 96 80 7B 0D 01 74 17 45 31 F6 BB ?? ?? ?? ?? EB 80 45 31 F6 BB ?? ?? ?? ?? E9 73 FF FF FF 80 7B 0E 01 74 31 45 31 F6 BB ?? ?? ?? ?? E9 60 FF FF FF 48 83 F8 02 0F 84 DB FC FF FF 45 31 F6 BB ?? ?? ?? ?? E9 49 FF FF FF 45 31 F6 BB ?? ?? ?? ?? E9 3C FF FF FF 0F B6 43 0F 3C 03 0F 95 C2 74 04 84 C0 75 19 0F B6 43 10 84 C0 74 22 84 D2 74 1A 45 31 F6 BB ?? ?? ?? ?? E9 14 FF FF FF 45 31 F6 BB ?? ?? ?? ?? E9 07 FF FF FF 3C 02 77 E2 48 8D 7B 11 BA 07 00 00 00 BE ?? ?? ?? ?? 45 31 F6 BB ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 B8 ?? ?? ?? ?? 48 0F 44 D8 E9 D8 FE FF FF }
	condition:
		$1
}

rule file_246_7_0 {
	meta:
		name = "open_path.isra.4"
		size = 1434
		refs = "00b2 _dl_debug_mask 00c9 mempcpy 01e0 __libc_errno 024a _dl_ns 027c __xstat64 02b7 malloc 02d8 memcpy 0315 _dl_debug_printf 0321 __libc_enable_secure 0343 __fxstat64 0361 __close 0470 _dl_debug_printf_c 04f8 _dl_argv 055f free"
	strings:
		$1 = { 55 48 89 E5 41 57 41 56 41 55 41 54 53 48 81 EC 18 01 00 00 48 8B 01 48 89 BD 28 FF FF FF 48 89 B5 30 FF FF FF 89 95 1C FF FF FF 48 89 8D F8 FE FF FF 4C 89 85 08 FF FF FF 48 85 C0 4C 89 8D 20 FF FF FF 48 89 85 10 FF FF FF 0F 84 D3 01 00 00 48 8B 85 30 FF FF FF 48 03 05 ?? ?? ?? ?? 48 03 05 ?? ?? ?? ?? 48 8B 95 10 FF FF FF 48 8B 8D 30 FF FF FF C7 85 18 FF FF FF 00 00 00 00 48 C7 85 F0 FE FF FF 00 00 00 00 48 8B 1A 48 83 C0 1E 48 F7 D1 48 83 E0 F0 48 89 8D 00 FF FF FF 48 29 C4 4C 8D 64 24 0F 49 83 E4 F0 0F 1F 80 00 00 00 00 F6 05 ?? ?? ?? ?? 01 0F 85 BB 02 00 00 48 8B 53 20 48 8B 73 18 4C 89 E7 E8 ?? ?? ?? ?? 48 83 3D ?? ?? ?? ?? 00 48 89 85 38 FF FF FF 0F 84 20 02 00 00 41 BD 01 00 00 00 45 31 FF 4D 89 EE EB 43 83 F9 FF 0F 84 37 01 00 00 42 C7 44 B3 24 02 00 00 00 41 BF 01 00 00 00 8B 85 1C FF FF FF 85 C0 0F 85 08 02 00 00 83 F9 FF 0F 85 91 01 00 00 4C 39 35 ?? ?? ?? ?? 49 8D 46 01 0F 86 A8 00 00 00 49 89 C6 42 83 7C B3 24 01 74 E4 48 8B 15 ?? ?? ?? ?? 4C 89 F0 48 8B BD 38 FF FF FF 48 C1 E0 04 48 8D 44 02 F0 48 8B 50 08 48 8B 30 E8 ?? ?? ?? ?? 48 8B 95 30 FF FF FF 48 8B B5 28 FF FF FF 48 89 C7 E8 ?? ?? ?? ?? 49 89 C5 4D 29 E5 F6 05 ?? ?? ?? ?? 01 0F 85 80 01 00 00 48 8B 55 18 48 8B B5 20 FF FF FF 31 C9 4C 89 E7 E8 F1 F9 FF FF 89 C1 42 8B 44 B3 24 85 C0 0F 84 42 FF FF FF 83 F8 01 0F 95 C0 0F B6 C0 41 09 C7 83 F9 FF 0F 85 45 FF FF FF 4C 39 35 ?? ?? ?? ?? 49 8D 46 01 0F 87 5C FF FF FF 0F 1F 40 00 45 85 FF 74 14 48 8B 05 ?? ?? ?? ?? 64 8B 00 83 F8 02 74 05 83 F8 0D 75 32 48 83 85 10 FF FF FF 08 44 09 BD 18 FF FF FF 48 8B 85 10 FF FF FF 48 8B 18 48 85 DB 0F 85 9D FE FF FF 44 8B 95 18 FF FF FF 45 85 D2 0F 84 28 03 00 00 41 BE FF FF FF FF E9 B2 00 00 00 66 90 48 83 7D 10 00 74 25 48 8B 55 10 48 8B 42 30 48 8D 04 C0 48 C1 E0 04 48 8B 90 ?? ?? ?? ?? B8 01 00 00 00 F6 82 15 03 00 00 08 75 45 48 8B 8D 00 FF FF FF 4F 8D 0C 2C 48 8D 95 40 FF FF FF 4C 89 E6 BF 01 00 00 00 41 C6 04 09 00 E8 ?? ?? ?? ?? 85 C0 75 12 8B 85 58 FF FF FF 25 00 F0 00 00 3D 00 40 00 00 74 5C 42 C7 44 B3 24 01 00 00 00 31 C0 41 09 C7 E9 76 FE FF FF 0F 1F 80 00 00 00 00 4C 89 EF 41 89 CE E8 ?? ?? ?? ?? 48 8B 95 08 FF FF FF 48 85 C0 48 89 02 0F 84 BF 02 00 00 4C 89 EA 4C 89 E6 48 89 C7 E8 ?? ?? ?? ?? 0F 1F 40 00 48 8D 65 D8 44 89 F0 5B 41 5C 41 5D 41 5E 41 5F 5D C3 42 C7 44 B3 24 02 00 00 00 B8 01 00 00 00 EB 9F 45 31 FF E9 E7 FE FF FF 4C 89 E6 BF ?? ?? ?? ?? 31 C0 E8 ?? ?? ?? ?? E9 6C FE FF FF 44 8B 1D ?? ?? ?? ?? 45 85 DB 0F 84 E8 FD FF FF 48 8D 95 40 FF FF FF 89 CE BF 01 00 00 00 89 8D C8 FE FF FF E8 ?? ?? ?? ?? 85 C0 8B 8D C8 FE FF FF 75 0D F6 85 59 FF FF FF 08 0F 85 B8 FD FF FF 89 CF E8 ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? 64 C7 00 02 00 00 00 E9 A7 FD FF FF 4C 8B 7B 08 4C 3B BD F0 FE FF FF 0F 84 34 FD FF FF 48 8B 05 ?? ?? ?? ?? 48 03 05 ?? ?? ?? ?? B9 10 00 00 00 31 D2 48 89 A5 E0 FE FF FF BF ?? ?? ?? ?? 4C 8B 6B 10 48 83 C0 0F 48 F7 F1 48 C1 E0 04 48 29 C4 31 C0 48 89 A5 38 FF FF FF E8 ?? ?? ?? ?? 48 8B 95 10 FF FF FF 48 8B 02 48 85 C0 0F 84 0C 01 00 00 4C 3B 78 08 0F 85 02 01 00 00 4C 8B B5 10 FF FF FF 48 8D 4C 24 01 48 89 9D E8 FE FF FF C7 85 F0 FE FF FF 01 00 00 00 48 89 8D D0 FE FF FF 4C 89 F3 4D 89 E6 48 8B 50 20 48 8B 70 18 48 8B BD 38 FF FF FF E8 ?? ?? ?? ?? 48 83 3D ?? ?? ?? ?? 00 48 89 85 D8 FE FF FF 0F 84 8F 00 00 00 45 31 E4 EB 4C 48 3B 85 D0 FE FF FF 0F 84 DC 00 00 00 C6 40 FF 00 8B 85 F0 FE FF FF 48 8B B5 38 FF FF FF BF ?? ?? ?? ?? 85 C0 B8 ?? ?? ?? ?? 48 0F 44 F8 31 C0 E8 ?? ?? ?? ?? C7 85 F0 FE FF FF 00 00 00 00 49 83 C4 01 4C 3B 25 ?? ?? ?? ?? 73 3E 48 8B 03 42 83 7C A0 28 01 74 E8 4C 89 E0 48 8B BD D8 FE FF FF 48 C1 E0 04 48 03 05 ?? ?? ?? ?? 48 8B 50 08 48 8B 30 E8 ?? ?? ?? ?? 48 39 85 38 FF FF FF 0F 85 7B FF FF FF C6 00 00 EB 87 48 83 C3 08 48 8B 03 48 85 C0 74 0A 4C 3B 78 08 0F 84 32 FF FF FF 48 8B 9D E8 FE FF FF 4D 89 F4 4D 85 ED 74 4C 41 80 7D 00 00 75 0A 48 8B 05 ?? ?? ?? ?? 4C 8B 28 4C 89 EA 4C 89 FE BF ?? ?? ?? ?? 31 C0 E8 ?? ?? ?? ?? 4C 89 BD F0 FE FF FF 48 8B A5 E0 FE FF FF E9 99 FB FF FF 0F 1F 40 00 48 8B 8D 38 FF FF FF 80 39 2F 0F 85 14 FF FF FF EB 8A 4C 89 FE BF ?? ?? ?? ?? 31 C0 E8 ?? ?? ?? ?? EB C6 48 8B 8D F8 FE FF FF 44 8B 49 08 45 85 C9 74 08 48 8B 39 E8 ?? ?? ?? ?? 48 81 BD F8 FE FF FF ?? ?? ?? ?? 0F 84 AF FC FF FF 48 8B 8D F8 FE FF FF 41 BE FF FF FF FF 48 C7 01 FF FF FF FF E9 53 FD FF FF 44 89 F7 E8 ?? ?? ?? ?? E9 89 FC FF FF }
	condition:
		$1
}

rule file_246_8_0 {
	meta:
		name = "add_path.11507.isra.1.constprop.6"
		size = 195
		refs = "0084 mempcpy"
	strings:
		$1 = { 48 83 FF FF 0F 84 A2 00 00 00 41 55 41 BD 02 00 00 00 41 54 49 89 FC 55 53 4C 89 D3 48 83 EC 08 48 8B 07 EB 24 0F 1F 00 48 8B 53 08 83 42 08 01 48 83 78 20 02 48 8B 40 20 49 0F 42 C5 48 01 02 49 8B 04 24 48 85 C0 74 59 49 83 C4 08 80 7B 14 00 75 D5 8B 53 10 48 8B 3B 89 D5 83 C2 01 48 83 C5 01 89 53 10 48 8B 50 20 48 C1 E5 04 48 03 6B 08 48 83 FA 01 48 89 7D 00 76 35 48 8B 70 18 48 83 EA 01 E8 ?? ?? ?? ?? 48 89 03 C6 00 00 49 8B 04 24 48 83 03 01 C7 45 08 00 00 00 00 48 85 C0 75 A7 48 83 C4 08 5B 5D 41 5C 41 5D F3 C3 66 90 19 C0 83 C0 2F 88 07 48 8B 03 48 83 C0 01 48 89 03 EB C8 }
	condition:
		$1
}

rule file_246_9_0 {
	meta:
		name = "expand_dynamic_string_token"
		size = 434
		refs = "0033 strchr 006c _dl_dst_count 00ca _dl_platformlen 00f6 malloc 0132 _dl_get_origin 01ae __assert_fail 012d _dl_dst_substitute"
	strings:
		$1 = { 4C 89 7C 24 F8 49 89 F7 48 89 5C 24 D0 48 89 6C 24 D8 4C 89 64 24 E0 48 89 FB 4C 89 6C 24 E8 4C 89 74 24 F0 BE 24 00 00 00 48 83 EC 48 4C 89 FF 89 D5 E8 ?? ?? ?? ?? 48 85 C0 75 2A 4C 89 FF 48 8B 5C 24 18 48 8B 6C 24 20 4C 8B 64 24 28 4C 8B 6C 24 30 4C 8B 74 24 38 4C 8B 7C 24 40 48 83 C4 48 E9 6A DD FF FF 89 EE 48 89 C7 E8 ?? ?? ?? ?? 48 85 C0 49 89 C6 74 C4 49 83 CD FF 45 31 E4 4C 89 FF 4C 89 E9 44 89 E0 F2 AE 48 F7 D1 4C 01 E9 48 85 DB 48 89 4C 24 08 0F 84 93 00 00 00 48 8B BB 38 03 00 00 48 85 FF 0F 84 C4 00 00 00 48 83 FF FF 0F 84 8E 00 00 00 44 89 E0 4C 89 E9 F2 AE 48 F7 D1 48 8D 41 FF 48 83 3D ?? ?? ?? ?? 05 BA 05 00 00 00 48 0F 43 15 ?? ?? ?? ?? 48 39 C2 48 0F 43 C2 48 8B 54 24 08 48 83 E8 04 49 0F AF C6 48 8D 7C 02 01 E8 ?? ?? ?? ?? 48 85 C0 74 4E 89 E9 4C 89 FE 48 89 DF 48 8B 6C 24 20 48 8B 5C 24 18 48 89 C2 4C 8B 64 24 28 4C 8B 6C 24 30 4C 8B 74 24 38 4C 8B 7C 24 40 48 83 C4 48 E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 C7 4C 01 E8 48 83 F8 FD 0F 86 72 FF FF FF 31 C0 E9 7A FF FF FF 31 C0 48 8B 5C 24 18 48 8B 6C 24 20 4C 8B 64 24 28 4C 8B 6C 24 30 4C 8B 74 24 38 4C 8B 7C 24 40 48 83 C4 48 C3 48 8B 43 08 80 38 00 75 1E E8 ?? ?? ?? ?? 48 89 C7 48 89 83 38 03 00 00 48 83 E8 01 48 83 F8 FD 77 B2 E9 1F FF FF FF B9 ?? ?? ?? ?? BA B5 01 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_246_10_0 {
	meta:
		name = "cache_rpath"
		size = 469
		refs = "0057 _dl_inhibit_rpath 00c6 malloc 00f3 free 015a _dl_signal_error 0167 __libc_enable_secure"
	strings:
		$1 = { 4C 8B 0E 49 83 F9 FF 0F 84 13 01 00 00 4D 85 C9 B8 01 00 00 00 74 09 C3 0F 1F 84 00 00 00 00 00 48 63 D2 48 8B 44 D7 40 48 85 C0 0F 84 F7 00 00 00 48 89 5C 24 E0 48 89 6C 24 E8 48 89 F3 4C 89 64 24 F0 4C 89 6C 24 F8 48 83 EC 38 48 8B 70 08 48 8B 57 68 48 8B 05 ?? ?? ?? ?? 48 8B 6F 08 48 03 72 08 48 85 C0 0F 85 F9 00 00 00 BA 01 00 00 00 48 89 4C 24 08 E8 C5 FD FF FF 48 85 C0 49 89 C4 48 8B 4C 24 08 0F 84 D2 00 00 00 0F B6 10 45 31 DB 49 89 C2 84 D2 0F 84 93 00 00 00 0F 1F 00 80 FA 3A 0F 94 C2 49 83 C2 01 0F B6 D2 49 01 D3 41 0F B6 12 84 D2 75 E8 4A 8D 3C DD 10 00 00 00 48 89 4C 24 08 E8 ?? ?? ?? ?? 48 85 C0 49 89 C5 48 8B 4C 24 08 74 6C 49 89 C8 49 89 E9 31 C9 BA ?? ?? ?? ?? 48 89 C6 4C 89 E7 E8 81 DB FF FF 4C 89 E7 E8 ?? ?? ?? ?? 4C 89 2B C7 43 08 01 00 00 00 B8 01 00 00 00 48 8B 5C 24 18 48 8B 6C 24 20 4C 8B 64 24 28 4C 8B 6C 24 30 48 83 C4 38 C3 90 31 C0 C3 0F 1F 44 00 00 48 C7 06 FF FF FF FF C3 48 89 C7 E8 ?? ?? ?? ?? 48 C7 03 FF FF FF FF 31 C0 EB C3 4C 89 E7 E8 ?? ?? ?? ?? B9 ?? ?? ?? ?? 31 D2 31 F6 BF 0C 00 00 00 E8 ?? ?? ?? ?? B9 ?? ?? ?? ?? EB EB 83 3D ?? ?? ?? ?? 00 0F 85 FA FE FF FF 48 89 EA EB 16 66 0F 1F 84 00 00 00 00 00 45 84 C0 74 B3 48 83 C0 01 48 83 C2 01 44 0F B6 00 44 0F B6 0A 45 38 C8 74 E6 45 84 C9 74 1E 0F B6 10 84 D2 0F 84 C2 FE FF FF 48 83 C0 01 80 FA 3A 75 EC 80 38 00 75 BA E9 AF FE FF FF 41 80 F8 3A 0F 84 71 FF FF FF 45 84 C0 75 D3 0F 1F 40 00 E9 63 FF FF FF }
	condition:
		$1
}

rule file_246_11_0 {
	meta:
		name = "_dl_dst_count"
		size = 156
		refs = "0008 __libc_enable_secure 002e strchr"
	strings:
		$1 = { 41 56 48 89 F8 44 8B 35 ?? ?? ?? ?? 41 55 41 89 F5 41 54 49 89 FC 55 31 ED 53 EB 1B 0F 1F 40 00 48 83 C5 01 48 8D 3C 03 BE 24 00 00 00 E8 ?? ?? ?? ?? 48 85 C0 74 59 48 8D 58 01 45 89 F0 44 89 E9 BA ?? ?? ?? ?? 4C 89 E7 48 89 DE E8 2F E0 FF FF 48 85 C0 75 CA 45 31 C0 44 89 E9 BA ?? ?? ?? ?? 48 89 DE 4C 89 E7 E8 14 E0 FF FF 48 85 C0 75 AF 45 31 C0 44 89 E9 BA ?? ?? ?? ?? 48 89 DE 4C 89 E7 E8 F9 DF FF FF 48 85 C0 74 98 EB 92 66 90 5B 48 89 E8 5D 41 5C 41 5D 41 5E C3 }
	condition:
		$1
}

rule file_246_12_0 {
	meta:
		name = "_dl_dst_substitute"
		size = 737
		refs = "0088 __libc_enable_secure 0183 stpcpy 01fc _dl_platform 02bf _dl_get_origin"
	strings:
		$1 = { 41 57 49 89 FB 49 89 F7 45 31 C9 41 56 49 89 D6 4D 89 F2 41 55 41 89 CD 41 54 55 48 89 F5 53 4C 89 F3 48 83 EC 38 0F B6 16 EB 08 0F 1F 44 00 00 4C 89 E5 80 FA 24 74 4E 88 13 48 83 C3 01 45 85 ED 4C 8D 65 01 0F B6 55 01 74 05 80 FA 3A 74 28 84 D2 75 DC 45 84 C9 0F 85 E1 01 00 00 C6 03 00 48 83 C4 38 4C 89 F0 5B 5D 41 5C 41 5D 41 5E 41 5F C3 66 0F 1F 44 00 00 45 84 C9 0F 85 84 01 00 00 49 89 DA EB AA 8B 05 ?? ?? ?? ?? 4C 8D 65 01 BA ?? ?? ?? ?? 44 89 E9 4C 89 FF 44 88 4C 24 18 4C 89 E6 4C 89 54 24 08 4C 89 5C 24 10 41 89 C0 89 44 24 2C E8 27 DF FF FF 48 85 C0 48 89 C2 44 0F B6 4C 24 18 4C 8B 54 24 08 4C 8B 5C 24 10 0F 84 E7 00 00 00 4D 85 DB 0F 84 DB 01 00 00 49 8B 83 38 03 00 00 8B 4C 24 2C 45 31 C9 85 C9 74 0C 41 F6 83 14 03 00 00 03 41 0F 94 C1 48 8D 48 FF 48 83 F9 FD 76 62 48 83 FA 01 0F 86 9C 00 00 00 49 01 D4 41 0F B6 04 24 84 C0 75 11 EB 42 66 90 49 83 C4 01 41 0F B6 04 24 84 C0 74 33 45 85 ED 74 EE 3C 3A 75 EA 4D 39 F2 0F 85 6D 01 00 00 41 0F B6 54 24 01 84 D2 0F 84 5F 01 00 00 49 83 C4 01 4C 89 F3 E9 28 FF FF FF 0F 1F 80 00 00 00 00 4C 89 D3 E9 EC FE FF FF 48 89 DF 48 89 C6 48 89 54 24 20 44 88 4C 24 18 4C 89 54 24 08 4C 89 5C 24 10 E8 ?? ?? ?? ?? 48 8B 54 24 20 48 89 C3 44 0F B6 4C 24 18 4C 8B 54 24 08 4C 8B 5C 24 10 49 01 D4 41 0F B6 14 24 E9 A4 FE FF FF C6 03 24 48 83 C3 01 0F B6 55 01 E9 94 FE FF FF 45 31 C0 BA ?? ?? ?? ?? 44 89 E9 4C 89 E6 4C 89 FF 44 88 4C 24 18 4C 89 54 24 08 4C 89 5C 24 10 E8 FF DD FF FF 48 85 C0 48 89 C2 44 0F B6 4C 24 18 4C 8B 54 24 08 4C 8B 5C 24 10 74 68 48 8B 05 ?? ?? ?? ?? E9 F7 FE FF FF 48 89 DE 4C 89 D7 88 54 24 20 4C 29 D6 4C 89 54 24 08 4C 89 5C 24 10 E8 ?? ?? ?? ?? 4C 8B 54 24 08 45 31 C9 84 C0 0F B6 54 24 20 4C 8B 5C 24 10 49 0F 44 DA E9 43 FE FF FF 48 89 DE 4C 89 D7 4C 89 54 24 08 4C 29 D6 E8 ?? ?? ?? ?? 4C 8B 54 24 08 84 C0 49 0F 44 DA E9 FC FD FF FF 45 31 C0 BA ?? ?? ?? ?? 44 89 E9 4C 89 E6 4C 89 FF 44 88 4C 24 18 4C 89 54 24 08 4C 89 5C 24 10 E8 5A DD FF FF 48 85 C0 48 89 C2 44 0F B6 4C 24 18 4C 8B 54 24 08 4C 8B 5C 24 10 0F 84 0A FF FF FF B8 ?? ?? ?? ?? E9 50 FE FF FF 41 0F B6 14 24 4C 89 D3 E9 97 FD FF FF 48 89 44 24 20 E8 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 48 8B 54 24 20 4C 8B 54 24 08 4C 8B 5C 24 10 89 4C 24 2C E9 04 FE FF FF }
	condition:
		$1
}

rule file_246_13_0 {
	meta:
		name = "_dl_init_paths"
		size = 641
		refs = "0004 _dl_platformlen 0021 _dl_platform 0027 _dl_important_hwcaps 0038 malloc 0097 _dl_all_dirs 0184 strlen 01a4 memcpy 01f4 __libc_enable_secure 0236 free 025d _dl_signal_error 0276 __assert_fail"
	strings:
		$1 = { 55 48 8B 35 ?? ?? ?? ?? B9 ?? ?? ?? ?? BA ?? ?? ?? ?? 48 89 E5 41 56 41 55 41 54 49 89 FC 48 8B 3D ?? ?? ?? ?? 53 E8 ?? ?? ?? ?? BF 18 00 00 00 48 89 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 85 C0 48 89 05 ?? ?? ?? ?? 0F 84 02 02 00 00 48 8B 1D ?? ?? ?? ?? 49 89 C5 48 BA CD CC CC CC CC CC CC CC 48 8D 04 9D 4F 00 00 00 48 F7 E2 48 C1 EA 05 4C 8D 34 92 4B 8D 3C B6 48 C1 E7 05 E8 ?? ?? ?? ?? 48 85 C0 48 89 C1 49 89 45 00 0F 84 EA 01 00 00 49 C1 E6 03 48 89 05 ?? ?? ?? ?? 49 8D 45 08 4D 89 F0 C7 05 ?? ?? ?? ?? 00 00 00 00 48 C7 41 08 ?? ?? ?? ?? 48 C7 41 10 00 00 00 00 48 C7 41 18 ?? ?? ?? ?? BE ?? ?? ?? ?? 48 C7 41 20 07 00 00 00 31 FF 49 F7 D8 31 D2 48 85 DB 74 14 0F 1F 00 C7 44 91 28 00 00 00 00 48 83 C2 01 48 39 DA 75 EF 48 83 FF 01 74 49 4C 01 F1 48 83 C0 08 48 8D 56 0C 48 89 48 F8 80 3E 2F BF 01 00 00 00 4A 89 0C 01 48 C7 41 08 ?? ?? ?? ?? 48 C7 41 10 00 00 00 00 48 89 71 18 48 C7 41 20 0B 00 00 00 0F 85 2D 01 00 00 48 89 D6 EB 9D 0F 1F 80 00 00 00 00 4D 85 E4 48 C7 01 00 00 00 00 48 C7 05 ?? ?? ?? ?? 0B 00 00 00 48 C7 00 00 00 00 00 74 07 41 80 3C 24 00 75 1B 48 C7 05 ?? ?? ?? ?? FF FF FF FF 48 8D 65 E0 5B 41 5C 41 5D 41 5E 5D C3 0F 1F 00 4C 89 E7 E8 ?? ?? ?? ?? 48 8D 50 01 48 83 C0 1F 4C 89 E6 48 83 E0 F0 48 29 C4 48 8D 7C 24 0F 48 83 E7 F0 E8 ?? ?? ?? ?? 41 0F B6 14 24 48 89 C3 84 D2 0F 84 8F 00 00 00 4C 89 E1 BE 01 00 00 00 83 EA 3A 80 FA 02 48 83 D6 00 48 83 C1 01 0F B6 11 84 D2 75 EB 48 8D 3C F5 08 00 00 00 E8 ?? ?? ?? ?? 48 85 C0 48 89 05 ?? ?? ?? ?? 0F 84 88 00 00 00 8B 0D ?? ?? ?? ?? 45 31 C9 48 89 DF 41 B8 ?? ?? ?? ?? BA ?? ?? ?? ?? 48 89 C6 E8 7F D8 FF FF 48 8B 3D ?? ?? ?? ?? 48 83 3F 00 74 17 C7 05 ?? ?? ?? ?? 00 00 00 00 48 8D 65 E0 5B 41 5C 41 5D 41 5E 5D C3 E8 ?? ?? ?? ?? 48 C7 05 ?? ?? ?? ?? FF FF FF FF EB D7 BF 10 00 00 00 EB 8F B9 ?? ?? ?? ?? 31 D2 31 F6 BF 0C 00 00 00 E8 ?? ?? ?? ?? B9 ?? ?? ?? ?? BA 03 03 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? B9 ?? ?? ?? ?? EB D2 }
	condition:
		$1
}

rule file_246_14_0 {
	meta:
		name = "_dl_map_object"
		size = 2110
		refs = "0021 _dl_nns 0045 _dl_ns 007e _dl_name_match_p 00a3 _dl_debug_mask 00bf strchr 013a __libc_stack_end 018a strlen 0244 _dl_debug_printf 02c6 _dl_inhibit_cache 02d3 _dl_load_cache_lookup 033d __close 059e strcmp 0655 _dl_new_object 0694 _dl_add_to_namespace_list 06b4 _dl_argv 0739 free 074d _dl_signal_error 076c __libc_enable_secure 0790 memcmp 07c8 __libc_errno 080a __assert_fail"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 53 48 81 EC D8 03 00 00 4D 85 C9 89 4C 24 40 0F 88 F0 07 00 00 4C 3B 0D ?? ?? ?? ?? 0F 83 CA 07 00 00 4B 8D 04 C9 49 89 FC 48 89 F3 41 89 D6 45 89 C5 4C 89 CD 48 C1 E0 04 4C 8B B8 ?? ?? ?? ?? 4D 85 FF 75 19 EB 50 41 F6 87 15 03 00 00 01 0F 84 20 05 00 00 4D 8B 7F 18 4D 85 FF 74 39 41 0F B6 87 15 03 00 00 A8 02 75 EB A8 20 75 E7 4C 89 FE 48 89 DF E8 ?? ?? ?? ?? 85 C0 74 CA 48 81 C4 D8 03 00 00 4C 89 F8 5B 5D 41 5C 41 5D 41 5E 41 5F C3 0F 1F 44 00 00 44 8B 3D ?? ?? ?? ?? 41 F6 C7 40 0F 85 EC 05 00 00 BE 2F 00 00 00 48 89 DF C6 44 24 6F 00 E8 ?? ?? ?? ?? 48 85 C0 0F 84 AD 00 00 00 4D 85 E4 0F 84 83 01 00 00 44 89 E8 25 00 00 00 10 89 44 24 34 31 D2 48 89 DE 4C 89 E7 E8 E2 F8 FF FF 48 85 C0 48 89 44 24 70 BE FF FF FF FF 74 25 48 8D B4 24 80 00 00 00 48 8D 54 24 6F B9 01 00 00 00 48 89 C7 E8 49 EA FF FF 83 F8 FF 89 C6 0F 84 05 07 00 00 8B 7C 24 34 31 C0 85 FF 4C 0F 45 E0 83 FE FF 0F 84 D9 04 00 00 48 8B 05 ?? ?? ?? ?? 48 8B 4C 24 70 48 8D 94 24 80 00 00 00 48 89 6C 24 10 44 89 2C 24 45 89 F1 4D 89 E0 48 89 DF 48 89 44 24 78 48 8D 44 24 78 48 89 44 24 08 E8 0F DB FF FF 49 89 C7 E9 0D FF FF FF 44 89 EA 81 E2 00 00 00 10 89 54 24 34 48 89 DF E8 ?? ?? ?? ?? 48 83 C0 01 41 83 E7 01 48 89 44 24 48 0F 85 3D 06 00 00 4D 85 E4 0F 84 78 02 00 00 49 83 BC 24 28 01 00 00 00 0F 84 17 03 00 00 48 83 3D ?? ?? ?? ?? FF 0F 84 DA 00 00 00 4D 85 E4 4C 89 E0 48 0F 44 05 ?? ?? ?? ?? 48 8D 4C 24 6F 48 8B 74 24 48 44 89 EA 4C 8D 8C 24 80 00 00 00 4C 8D 44 24 70 81 E2 00 00 00 04 48 89 4C 24 08 48 89 04 24 B9 ?? ?? ?? ?? 48 89 DF E8 C5 ED FF FF 83 F8 FF 89 C6 0F 94 C0 4D 85 E4 41 0F 95 C7 84 C0 0F 85 87 01 00 00 83 FE FF 0F 84 85 00 00 00 F6 05 ?? ?? ?? ?? 01 0F 84 EA FE FF FF BF ?? ?? ?? ?? 31 C0 89 74 24 28 E8 ?? ?? ?? ?? 8B 74 24 28 E9 D1 FE FF FF 0F 1F 80 00 00 00 00 48 89 DF E8 40 D5 FF FF 44 89 EA 81 E2 00 00 00 10 89 54 24 34 E9 7C FE FF FF 41 89 DA 44 8B 74 24 50 48 89 EB 45 84 D2 44 8B 6C 24 54 48 8B 6C 24 58 0F 84 9E 01 00 00 48 83 3D ?? ?? ?? ?? FF 4C 89 E0 0F 85 34 FF FF FF B8 01 00 00 00 BE FF FF FF FF E9 63 FF FF FF 44 89 EA 81 E2 00 00 00 04 89 54 24 50 0F 85 A6 04 00 00 44 8B 05 ?? ?? ?? ?? 45 85 C0 75 72 48 89 DF E8 ?? ?? ?? ?? 48 85 C0 48 89 44 24 38 74 60 45 84 FF 74 14 41 8B 8C 24 D4 03 00 00 81 E1 00 08 00 00 0F 85 84 04 00 00 48 8B 7C 24 38 48 8D B4 24 80 00 00 00 48 8D 54 24 6F 31 C9 E8 4D E8 FF FF 83 F8 FF 89 C6 74 27 48 8B 7C 24 38 89 74 24 28 E8 78 D4 FF FF 48 85 C0 48 89 44 24 70 8B 74 24 28 0F 85 F1 FE FF FF 89 F7 E8 ?? ?? ?? ?? 45 84 FF 0F 84 9C 02 00 00 41 8B 8C 24 D4 03 00 00 81 E1 00 08 00 00 4C 89 E0 85 C9 0F 85 60 02 00 00 48 83 3D ?? ?? ?? ?? FF 0F 84 52 02 00 00 48 8D 54 24 6F 48 8B 74 24 48 4C 8D 8C 24 80 00 00 00 4C 8D 44 24 70 48 89 04 24 B9 ?? ?? ?? ?? 48 89 54 24 08 8B 54 24 50 48 89 DF E8 2E EC FF FF 89 C6 E9 82 FE FF FF 45 84 FF 0F 84 70 FE FF FF 4D 8D 94 24 A8 03 00 00 B9 ?? ?? ?? ?? BA 1D 00 00 00 4C 89 E7 41 BF 01 00 00 00 4C 89 D6 4C 89 54 24 28 E8 B6 F7 FF FF 84 C0 4C 8B 54 24 28 0F 84 C9 FE FF FF 48 8D 44 24 6F 48 8B 74 24 48 44 89 EA 4C 8D 8C 24 80 00 00 00 4C 8D 44 24 70 81 E2 00 00 00 04 48 89 44 24 08 4C 89 24 24 4C 89 D1 48 89 DF E8 B5 EB FF FF 89 C6 E9 00 FE FF FF 48 8B 15 ?? ?? ?? ?? 48 89 54 24 38 48 83 7C 24 38 00 0F 84 7F FD FF FF 48 8B 54 24 38 0F B6 82 14 03 00 00 83 E0 03 3C 02 0F 84 68 FD FF FF 49 89 D7 48 8B 7C 24 38 B9 ?? ?? ?? ?? 49 81 C7 18 03 00 00 BA 0F 00 00 00 4C 89 FE E8 1E F7 FF FF 84 C0 0F 84 3F FD FF FF 48 8B 44 24 38 4D 85 E4 48 8D 4C 24 6F 48 8B 74 24 48 44 89 EA 4C 8D 8C 24 80 00 00 00 4C 8D 44 24 70 48 89 4C 24 08 48 89 DF 49 0F 45 C4 4C 89 F9 81 E2 00 00 00 04 48 89 04 24 E8 16 EB FF FF 83 F8 FF 89 C6 0F 85 66 FD FF FF E9 EF FC FF FF 66 0F 1F 44 00 00 48 8B 15 ?? ?? ?? ?? 44 89 E8 45 31 D2 25 00 00 00 04 44 89 6C 24 54 48 89 6C 24 58 4D 89 E7 48 89 DD 89 44 24 44 48 89 54 24 38 44 89 74 24 50 44 89 D3 4C 8B 6C 24 48 EB 16 66 0F 1F 44 00 00 4D 8B BF D8 02 00 00 4D 85 FF 0F 84 52 FD FF FF 4D 8D B7 18 03 00 00 B9 ?? ?? ?? ?? BA 0F 00 00 00 4C 89 FF 4C 89 F6 E8 54 F6 FF FF 84 C0 74 D0 48 8D 44 24 6F 8B 54 24 44 4C 8D 8C 24 80 00 00 00 4C 8D 44 24 70 4C 89 24 24 4C 89 F1 48 89 44 24 08 4C 89 EE 48 89 EF E8 63 EA FF FF 83 F8 FF 75 5B 4C 3B 7C 24 38 0F 94 C0 09 C3 EB 92 49 8B 87 B0 00 00 00 48 85 C0 0F 84 D0 FA FF FF 49 8B 57 68 48 89 DF 48 8B 72 08 48 03 70 08 E8 ?? ?? ?? ?? 85 C0 0F 85 B4 FA FF FF 49 8B 7F 38 48 89 DE E8 DA D5 FF FF 41 80 8F 15 03 00 00 01 E9 C3 FA FF FF BE FF FF FF FF E9 5E FC FF FF 48 89 EB 89 C6 44 8B 74 24 50 44 8B 6C 24 54 48 8B 6C 24 58 E9 45 FC FF FF 48 8D 44 ED 00 48 C1 E0 04 48 8B 80 ?? ?? ?? ?? 48 85 C0 0F 84 64 FD FF FF 8B 88 D4 03 00 00 81 E1 00 08 00 00 E9 4B FD FF FF 8B 74 24 40 85 F6 0F 84 35 01 00 00 F6 05 ?? ?? ?? ?? 08 0F 85 28 01 00 00 48 89 DF E8 6F D1 FF FF 48 85 C0 49 89 C2 0F 84 F8 00 00 00 49 89 E9 45 89 E8 4C 89 E1 44 89 F2 48 89 DE 48 89 C7 48 89 44 24 28 E8 ?? ?? ?? ?? 48 85 C0 49 89 C7 4C 8B 54 24 28 0F 84 CB 00 00 00 80 88 15 03 00 00 02 80 88 14 03 00 00 04 48 89 EE 48 C7 80 08 03 00 00 ?? ?? ?? ?? C7 80 EC 02 00 00 01 00 00 00 48 89 C7 E8 ?? ?? ?? ?? E9 E9 F9 FF FF 4D 85 E4 74 67 49 8B 4C 24 08 4D 8B 44 24 30 80 39 00 75 0A 48 8B 05 ?? ?? ?? ?? 48 8B 08 44 89 E8 BF ?? ?? ?? ?? 48 89 EA 25 00 00 00 10 48 89 DE 89 44 24 34 B8 ?? ?? ?? ?? 48 0F 44 F8 31 C0 E8 ?? ?? ?? ?? BE 2F 00 00 00 48 89 DF C6 44 24 6F 00 E8 ?? ?? ?? ?? 48 85 C0 44 8B 3D ?? ?? ?? ?? 0F 85 DD F9 FF FF E9 7D FA FF FF BE 2F 00 00 00 48 89 DF C6 44 24 6F 00 E8 ?? ?? ?? ?? 48 85 C0 0F 85 34 FB FF FF 44 89 E8 25 00 00 00 10 89 44 24 34 E9 51 FA FF FF 4C 89 D7 E8 ?? ?? ?? ?? B9 ?? ?? ?? ?? 31 D2 48 89 DE BF 0C 00 00 00 E8 ?? ?? ?? ?? 80 7C 24 6F 00 74 6D B9 ?? ?? ?? ?? 31 D2 48 89 DE 31 FF E8 ?? ?? ?? ?? 44 8B 0D ?? ?? ?? ?? 45 85 C9 0F 85 C8 FB FF FF E9 45 FB FF FF BA 07 00 00 00 BE ?? ?? ?? ?? 48 89 C7 89 4C 24 28 E8 ?? ?? ?? ?? 85 C0 8B 4C 24 28 0F 84 B8 FB FF FF 48 8B 7C 24 38 BA 0B 00 00 00 BE ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 8B 4C 24 28 0F 85 3A FB FF FF E9 93 FB FF FF 48 8B 05 ?? ?? ?? ?? B9 ?? ?? ?? ?? 31 D2 48 89 DE 64 8B 38 E8 ?? ?? ?? ?? 48 89 EA 48 89 DE BF ?? ?? ?? ?? 31 C0 E8 ?? ?? ?? ?? E9 AC F9 FF FF B9 ?? ?? ?? ?? BA 12 08 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? B9 ?? ?? ?? ?? BA 11 08 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 7C 24 70 89 44 24 28 E8 ?? ?? ?? ?? 8B 74 24 28 E9 E4 F8 FF FF }
	condition:
		$1
}

rule file_246_15_0 {
	meta:
		name = "_dl_rtld_di_serinfo"
		size = 415
		refs = "0142 _dl_ns"
	strings:
		$1 = { 41 54 55 48 89 FD 53 48 83 EC 20 84 D2 48 89 74 24 08 88 54 24 14 0F 85 84 00 00 00 8B 46 08 48 83 C0 01 C7 44 24 10 00 00 00 00 48 C1 E0 04 48 01 C6 48 83 BD 28 01 00 00 00 48 89 34 24 0F 84 A4 00 00 00 48 8B 3D ?? ?? ?? ?? 49 89 E2 E8 DD EC FF FF 48 8D B5 A8 03 00 00 B9 ?? ?? ?? ?? BA 1D 00 00 00 48 89 EF E8 E4 F2 FF FF 84 C0 75 48 F6 85 D5 03 00 00 08 74 57 80 7C 24 14 00 74 13 48 8B 44 24 08 8B 50 08 48 83 C2 01 48 C1 E2 04 48 01 10 48 83 C4 20 5B 5D 41 5C C3 0F 1F 40 00 C7 46 08 00 00 00 00 48 C7 06 00 00 00 00 31 C0 E9 6A FF FF FF 0F 1F 00 48 8B BD A8 03 00 00 49 89 E2 E8 69 EC FF FF F6 85 D5 03 00 00 08 75 A9 48 8B 3D ?? ?? ?? ?? 49 89 E2 E8 51 EC FF FF EB 98 0F 1F 80 00 00 00 00 48 89 EB EB 0F 0F 1F 00 48 8B 9B D8 02 00 00 48 85 DB 74 38 48 8D B3 18 03 00 00 B9 ?? ?? ?? ?? BA 0F 00 00 00 48 89 DF E8 3B F2 FF FF 84 C0 74 D7 48 8B BB 18 03 00 00 49 89 E2 E8 08 EC FF FF 48 8B 9B D8 02 00 00 48 85 DB 75 C8 48 83 7D 30 00 0F 85 05 FF FF FF 48 8B 1D ?? ?? ?? ?? 48 85 DB 0F 84 F5 FE FF FF 0F B6 83 14 03 00 00 83 E0 03 3C 02 0F 84 E3 FE FF FF 48 39 EB 0F 84 DA FE FF FF 48 8D B3 18 03 00 00 B9 ?? ?? ?? ?? BA 0F 00 00 00 48 89 DF E8 CD F1 FF FF 84 C0 0F 84 B9 FE FF FF 48 8B BB 18 03 00 00 49 89 E2 E8 96 EB FF FF E9 A5 FE FF FF }
	condition:
		$1
}

rule file_246_16_0 {
	meta:
		name = "is_trusted_path_normalize"
		size = 255
		refs = "00c5 memcmp"
	strings:
		$1 = { 48 85 F6 75 0C E9 F2 00 00 00 31 C0 E9 E2 00 00 00 55 48 89 E5 41 54 53 80 3F 3A 75 06 48 FF C7 48 FF CE 48 83 C6 20 48 83 E6 F0 48 29 F4 48 8D 5C 24 0F 48 83 E3 F0 48 89 DA EB 58 3C 2F 75 4C 80 7F 01 2E 75 39 8A 4F 02 80 F9 2E 75 22 40 8A 77 03 40 84 F6 74 06 40 80 FE 2F 75 13 48 39 DA 76 08 48 FF CA 80 3A 2F 75 F3 48 83 C7 03 EB 24 84 C9 74 05 80 F9 2F 75 06 48 83 C7 02 EB 15 48 39 DA 76 08 80 7A FF 2F 75 02 EB 05 88 02 48 FF C2 48 FF C7 8A 07 84 C0 75 A2 48 39 DA 74 06 80 7A FF 2F 74 06 C6 02 2F 48 FF C2 49 89 D4 49 29 DC 49 83 FC 06 76 16 BA 07 00 00 00 48 89 DE BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 24 49 83 FC 0A 0F 86 33 FF FF FF BA 0B 00 00 00 48 89 DE BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 0F 85 19 FF FF FF B0 01 48 8D 65 F0 5B 41 5C 5D C3 31 C0 C3 }
	condition:
		$1
}

rule file_247_0_0 {
	meta:
		name = "ppoll"
		size = 524
		refs = "004d __libc_multiple_threads 00bb __libc_errno 013c __sigprocmask 0149 __poll 01ac __libc_enable_asynccancel 01dc __libc_disable_asynccancel"
	strings:
		$1 = { 4C 89 64 24 E8 4C 89 6C 24 F0 49 89 CC 4C 89 74 24 F8 48 89 5C 24 D8 49 89 FD 48 89 6C 24 E0 48 81 EC C8 00 00 00 48 85 D2 49 89 F6 0F 84 36 01 00 00 48 8B 02 48 89 44 24 10 48 8B 42 08 48 8D 54 24 10 48 89 D3 48 89 44 24 18 8B 05 ?? ?? ?? ?? 85 C0 0F 85 4D 01 00 00 41 B8 08 00 00 00 4D 89 E2 4C 89 F6 4C 89 EF B8 0F 01 00 00 0F 05 48 3D 00 F0 FF FF 0F 87 6A 01 00 00 48 89 C5 83 FD FF 74 35 89 E8 48 8B 9C 24 A0 00 00 00 48 8B AC 24 A8 00 00 00 4C 8B A4 24 B0 00 00 00 4C 8B AC 24 B8 00 00 00 4C 8B B4 24 C0 00 00 00 48 81 C4 C8 00 00 00 C3 0F 1F 00 48 8B 05 ?? ?? ?? ?? 64 83 38 26 75 BE 48 85 DB 74 5F 48 8B 33 48 85 F6 0F 88 C4 00 00 00 48 8B 4B 08 48 85 C9 0F 88 B7 00 00 00 48 81 F9 FF C9 9A 3B 0F 8F AA 00 00 00 48 81 FE 9B C4 20 00 7F 30 0F 84 8D 00 00 00 48 81 C1 3F 42 0F 00 48 BA DB 34 B6 D7 82 DE 1B 43 48 89 C8 48 C1 F9 3F 48 F7 EA 69 EE E8 03 00 00 48 C1 FA 12 48 29 CA 01 D5 4D 85 E4 74 4A 48 8D 54 24 20 4C 89 E6 BF 02 00 00 00 E8 ?? ?? ?? ?? 89 EA 4C 89 F6 4C 89 EF E8 ?? ?? ?? ?? 48 8D 74 24 20 31 D2 BF 02 00 00 00 89 C5 E8 ?? ?? ?? ?? E9 1E FF FF FF 0F 1F 00 48 89 D3 31 D2 E9 D9 FE FF FF 66 0F 1F 44 00 00 89 EA 4C 89 F6 4C 89 EF E8 ?? ?? ?? ?? 89 C5 E9 F7 FE FF FF 48 81 F9 C0 6F 90 26 7F 94 E9 65 FF FF FF 64 C7 00 16 00 00 00 E9 DD FE FF FF 48 89 54 24 08 E8 ?? ?? ?? ?? 41 B8 08 00 00 00 41 89 C1 4D 89 E2 48 8B 54 24 08 4C 89 F6 4C 89 EF B8 0F 01 00 00 0F 05 48 3D 00 F0 FF FF 77 24 44 89 CF 89 C5 E8 ?? ?? ?? ?? E9 99 FE FF FF 48 8B 15 ?? ?? ?? ?? F7 D8 48 83 CD FF 64 89 02 E9 84 FE FF FF 48 8B 15 ?? ?? ?? ?? F7 D8 64 89 02 48 83 C8 FF EB CA }
	condition:
		$1
}

rule file_248_0_0 {
	meta:
		name = "__atomic_readv_replacement"
		size = 410
		refs = "009d __read 00f3 memcpy 0101 free 0123 __libc_errno 0154 __libc_alloca_cutoff 0164 malloc 0189 _Unwind_Resume"
	strings:
		$1 = { 55 48 89 E5 41 57 41 89 FF 41 56 49 89 F6 41 55 41 89 D5 41 54 53 48 83 EC 18 85 D2 0F 8E 27 01 00 00 48 8B 46 08 48 BF FF FF FF FF FF FF FF 7F 31 D2 31 DB 48 89 F1 48 39 F8 76 23 E9 DF 00 00 00 0F 1F 80 00 00 00 00 48 83 C1 10 48 8B 41 08 48 89 FE 48 29 DE 48 39 C6 0F 82 C1 00 00 00 83 C2 01 48 01 C3 44 39 EA 75 DE 48 81 FB 00 10 00 00 0F 87 D9 00 00 00 48 8D 43 1E 48 C7 45 C0 00 00 00 00 48 83 E0 F0 48 29 C4 4C 8D 64 24 0F 49 83 E4 F0 48 89 DA 4C 89 E6 44 89 FF E8 ?? ?? ?? ?? 48 85 C0 48 89 C3 0F 88 93 00 00 00 45 85 ED 49 89 C7 7E 47 41 83 ED 01 49 C1 E5 04 4F 8D 6C 2E 10 4C 89 6D C8 EB 12 0F 1F 84 00 00 00 00 00 49 83 C6 10 4C 3B 75 C8 74 22 4D 39 7E 08 4D 89 FD 49 8B 3E 4D 0F 46 6E 08 4C 89 E6 4C 89 EA 4D 01 EC E8 ?? ?? ?? ?? 4D 29 EF 75 D4 48 8B 7D C0 E8 ?? ?? ?? ?? 48 8D 65 D8 48 89 D8 5B 41 5C 41 5D 41 5E 41 5F 5D C3 66 0F 1F 84 00 00 00 00 00 48 8B 05 ?? ?? ?? ?? 48 C7 C3 FF FF FF FF 64 C7 00 16 00 00 00 EB CE 48 C7 45 C0 00 00 00 00 90 48 C7 C3 FF FF FF FF EB B3 31 DB E9 27 FF FF FF 48 89 DF E8 ?? ?? ?? ?? 85 C0 0F 85 17 FF FF FF 48 89 DF E8 ?? ?? ?? ?? 48 85 C0 49 89 C4 74 C7 48 89 45 C0 E9 1A FF FF FF 48 89 C3 48 8B 7D C0 E8 ?? ?? ?? ?? 48 89 DF E8 ?? ?? ?? ?? 48 89 C3 48 C7 45 C0 00 00 00 00 EB E2 }
	condition:
		$1
}

rule file_248_1_0 {
	meta:
		name = "__libc_readv"
		size = 241
		refs = "0017 __libc_multiple_threads 0063 __libc_errno 0092 __libc_enable_asynccancel 00ba __libc_disable_asynccancel"
	strings:
		$1 = { 48 89 5C 24 E8 48 89 6C 24 F0 89 D3 4C 89 64 24 F8 48 83 EC 28 8B 05 ?? ?? ?? ?? 89 FD 49 89 F4 85 C0 75 6D 48 63 D2 48 63 FF B8 13 00 00 00 0F 05 48 3D 00 F0 FF FF 0F 87 8B 00 00 00 48 85 C0 78 1E 48 8B 5C 24 10 48 8B 6C 24 18 4C 8B 64 24 20 48 83 C4 28 C3 66 2E 0F 1F 84 00 00 00 00 00 48 8B 15 ?? ?? ?? ?? 64 83 3A 16 75 D5 83 FB 08 7E D0 89 DA 4C 89 E6 89 EF 48 8B 5C 24 10 48 8B 6C 24 18 4C 8B 64 24 20 48 83 C4 28 E9 CF FD FF FF E8 ?? ?? ?? ?? 48 63 D3 41 89 C0 4C 89 E6 48 63 FD B8 13 00 00 00 0F 05 48 3D 00 F0 FF FF 77 2C 44 89 C7 48 89 44 24 08 E8 ?? ?? ?? ?? 48 8B 44 24 08 E9 75 FF FF FF 48 8B 15 ?? ?? ?? ?? F7 D8 64 89 02 48 83 C8 FF E9 60 FF FF FF 89 C2 48 8B 05 ?? ?? ?? ?? F7 DA 64 89 10 48 83 C8 FF EB C0 }
	condition:
		$1
}

rule file_250_0_0 {
	meta:
		name = "__seed48_r"
		size = 64
	strings:
		$1 = { 8B 06 89 46 06 0F B7 46 04 66 89 46 0A 0F B7 47 04 66 89 46 04 0F B7 47 02 66 89 46 02 0F B7 07 66 C7 46 0C 0B 00 66 C7 46 0E 01 00 66 89 06 48 B8 6D E6 EC DE 05 00 00 00 48 89 46 10 31 C0 C3 }
	condition:
		$1
}

rule file_251_0_0 {
	meta:
		name = "sethostname"
		size = 20
		refs = "000f __syscall_error"
	strings:
		$1 = { B8 AA 00 00 00 0F 05 48 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_252_0_0 {
	meta:
		name = "__validuser2_sa"
		size = 1064
		refs = "005e __getline 008b __libc_tsd_CTYPE_B 00db __libc_tsd_CTYPE_TOLOWER 01b8 free 01d9 strcmp 028f getnameinfo 02dd getaddrinfo 0336 memcmp 0349 freeaddrinfo 0383 innetgr"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 49 89 FC 55 53 48 81 EC D8 00 00 00 48 8D 84 24 A0 00 00 00 48 89 74 24 20 48 89 54 24 30 48 89 4C 24 28 4C 89 44 24 40 4C 89 4C 24 38 48 C7 44 24 58 00 00 00 00 48 C7 44 24 60 00 00 00 00 48 89 44 24 10 0F 1F 40 00 48 8D 74 24 60 48 8D 7C 24 58 4C 89 E2 E8 ?? ?? ?? ?? 48 85 C0 0F 8E 86 01 00 00 48 8B 44 24 60 48 8B 54 24 58 C6 44 02 FF 00 48 8B 44 24 58 44 0F B6 08 45 84 C9 74 C8 4C 8B 15 ?? ?? ?? ?? 49 0F BE D1 64 49 8B 3A 44 0F B7 1C 57 66 41 81 E3 00 20 0F 84 33 03 00 00 48 89 C1 0F 1F 44 00 00 48 83 C1 01 0F B6 31 40 84 F6 74 94 4C 0F BE C6 42 F6 44 47 01 20 75 E8 40 80 FE 23 74 82 66 45 85 DB 0F 85 28 01 00 00 48 8B 35 ?? ?? ?? ?? EB 1A 0F 1F 80 00 00 00 00 64 49 8B 0A 49 0F BE D1 F6 44 51 01 20 0F 85 05 01 00 00 64 48 8B 0E 48 83 C0 01 8B 14 91 88 50 FF 44 0F B6 08 45 84 C9 75 D6 48 89 C5 C6 00 00 48 8B 5C 24 58 41 BD ?? ?? ?? ?? 4C 89 EE B9 02 00 00 00 48 89 DF F3 A6 0F 84 3F 02 00 00 BE ?? ?? ?? ?? 48 89 DF B9 02 00 00 00 F3 A6 0F 84 50 02 00 00 0F B6 03 3C 2D 0F 84 36 02 00 00 3C 2B 0F 85 0A 01 00 00 80 7B 01 00 0F 85 00 01 00 00 80 7D 00 00 4C 89 EE B9 02 00 00 00 48 0F 44 6C 24 28 48 89 EF F3 A6 0F 84 3F 02 00 00 BE ?? ?? ?? ?? 48 89 EF B9 02 00 00 00 F3 A6 0F 84 49 02 00 00 0F B6 45 00 3C 2D 0F 84 56 02 00 00 3C 2B 75 26 80 7D 01 00 75 20 31 DB 48 8B 7C 24 58 E8 ?? ?? ?? ?? 48 81 C4 D8 00 00 00 89 D8 5B 5D 41 5C 41 5D 41 5E 41 5F C3 48 8B 7C 24 40 48 89 EE E8 ?? ?? ?? ?? 85 C0 0F 94 C0 0F B6 C0 85 C0 7F C7 85 C0 0F 84 5F FE FF FF BB FF FF FF FF EB BA 0F 1F 84 00 00 00 00 00 41 80 F9 09 0F 85 0F 02 00 00 C6 00 00 48 8D 78 01 48 0F BE 40 01 84 C0 0F 84 4A 01 00 00 64 49 8B 0A EB 14 0F 1F 40 00 48 83 C7 01 48 0F BE 07 84 C0 0F 84 30 01 00 00 F6 44 41 01 20 75 E9 48 89 F8 EB 0B 0F 1F 40 00 F6 44 51 01 20 75 0C 48 83 C0 01 48 0F BE 10 84 D2 75 ED 48 89 FD E9 B2 FE FF FF 0F 1F 44 00 00 41 BE 01 00 00 00 8B 74 24 30 48 8B 7C 24 20 48 8D 54 24 70 45 31 C9 45 31 C0 C7 04 24 01 00 00 00 B9 2E 00 00 00 E8 ?? ?? ?? ?? 85 C0 75 15 48 8D 7C 24 70 48 89 DE E8 ?? ?? ?? ?? 85 C0 0F 84 A4 00 00 00 48 8B 7C 24 10 31 C0 B9 06 00 00 00 48 8B 54 24 20 31 F6 F3 48 AB 48 8D 4C 24 68 48 89 DF 0F B7 02 48 8D 94 24 A0 00 00 00 89 84 24 A4 00 00 00 E8 ?? ?? ?? ?? 85 C0 0F 85 67 FD FF FF 48 8B 4C 24 68 48 85 C9 48 89 4C 24 18 0F 84 B9 00 00 00 48 8B 44 24 20 44 89 74 24 4C 48 89 CB 44 0F B7 38 49 89 C6 EB 13 66 0F 1F 44 00 00 48 8B 5B 28 48 85 DB 0F 84 90 00 00 00 44 39 7B 04 75 ED 8B 53 10 48 8B 7B 18 4C 89 F6 E8 ?? ?? ?? ?? 85 C0 75 DA 48 8B 7C 24 18 44 8B 74 24 4C E8 ?? ?? ?? ?? 0F 1F 00 41 83 FE 00 0F 8C 97 FE FF FF 0F 84 F0 FC FF FF E9 03 FE FF FF 0F 1F 00 48 89 F8 48 89 FD 66 90 E9 A0 FD FF FF 48 8B 74 24 38 48 8D 7B 02 31 C9 31 D2 E8 ?? ?? ?? ?? 41 89 C6 EB C4 48 83 C3 01 41 BE FF FF FF FF E9 D3 FE FF FF 48 8B 74 24 38 48 8D 7B 02 31 C9 31 D2 E8 ?? ?? ?? ?? 41 89 C6 41 F7 DE EB 9B 48 8B 7C 24 18 45 31 F6 E8 ?? ?? ?? ?? EB 8C 48 8B 54 24 40 48 8D 7D 02 31 C9 31 F6 E8 ?? ?? ?? ?? E9 0A FE FF FF 44 89 CE E9 E5 FC FF FF 48 8B 54 24 40 48 8D 7D 02 31 C9 31 F6 E8 ?? ?? ?? ?? F7 D8 E9 E9 FD FF FF 48 8B 74 24 40 48 8D 7D 01 E8 ?? ?? ?? ?? 85 C0 0F 94 C0 0F B6 C0 F7 D8 E9 D0 FD FF FF 41 80 F9 20 0F 84 E7 FD FF FF E9 EA FC FF FF }
	condition:
		$1
}

rule file_252_1_0 {
	meta:
		name = "iruserfopen"
		size = 393
		refs = "001a __lxstat64 003d _libc_intl_domainname 0044 __dcgettext 0053 __rcmd_errstr 005f _IO_new_fclose 00a9 _IO_new_fopen 00bd fileno 00cc __fxstat64"
	strings:
		$1 = { 55 89 F5 48 89 FE 53 48 89 FB BF 01 00 00 00 48 81 EC 98 00 00 00 48 89 E2 E8 ?? ?? ?? ?? 85 C0 75 4E 8B 44 24 18 25 00 F0 00 00 3D 00 80 00 00 74 6E BA 05 00 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? 31 DB E8 ?? ?? ?? ?? 48 85 C0 74 3E 48 85 DB 48 89 05 ?? ?? ?? ?? 74 0A 48 89 DF 31 DB E8 ?? ?? ?? ?? 48 81 C4 98 00 00 00 48 89 D8 5B 5D C3 BA 05 00 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 31 DB 48 85 C0 75 C2 81 0B 00 80 00 00 48 81 C4 98 00 00 00 48 89 D8 5B 5D C3 66 90 48 89 DF BE ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 85 C0 48 89 C3 0F 84 97 00 00 00 48 89 C7 E8 ?? ?? ?? ?? 48 89 E2 89 C6 BF 01 00 00 00 E8 ?? ?? ?? ?? 85 C0 0F 88 98 00 00 00 8B 44 24 1C 85 C0 74 20 39 E8 74 1C BA 05 00 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? E9 4B FF FF FF 0F 1F 00 F6 44 24 18 12 75 29 48 83 7C 24 10 01 0F 86 78 FF FF FF BA 05 00 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? E9 1C FF FF FF 0F 1F 40 00 BA 05 00 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? E9 FF FE FF FF 0F 1F 80 00 00 00 00 BA 05 00 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? E9 DF FE FF FF 0F 1F 80 00 00 00 00 BA 05 00 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? E9 BF FE FF FF }
	condition:
		$1
}

rule file_252_2_0 {
	meta:
		name = "ruserok2_sa"
		size = 467
		refs = "0043 __check_rhosts_file 004f __sysconf 0076 __getpwnam_r 00b8 strlen 00f2 mempcpy 0108 __geteuid 011a seteuid 0166 _IO_new_fclose"
	strings:
		$1 = { 55 48 89 E5 4C 89 65 E0 4C 89 6D E8 4D 89 C4 4C 89 75 F0 4C 89 7D F8 41 89 D5 48 89 5D D8 48 81 EC 90 00 00 00 85 D2 48 89 7D 88 48 89 75 80 49 89 CE 4D 89 CF 0F 84 45 01 00 00 BB FF FF FF FF 44 0B 2D ?? ?? ?? ?? 74 35 BF 46 00 00 00 E8 ?? ?? ?? ?? 48 8D 50 1E 4C 8D 45 98 48 8D 75 A0 48 89 C1 4C 89 E7 48 83 E2 F0 48 29 D4 48 8D 54 24 0F 48 83 E2 F0 E8 ?? ?? ?? ?? 85 C0 74 22 BB FF FF FF FF 89 D8 4C 8B 65 E0 48 8B 5D D8 4C 8B 6D E8 4C 8B 75 F0 4C 8B 7D F8 C9 C3 0F 1F 44 00 00 48 8B 45 98 48 85 C0 74 D5 48 8B 70 20 48 89 F7 48 89 B5 70 FF FF FF E8 ?? ?? ?? ?? B9 10 00 00 00 48 89 C7 31 D2 48 83 C0 27 48 8B B5 70 FF FF FF 48 F7 F1 48 89 FA 48 C1 E0 04 48 29 C4 48 8D 4C 24 0F 48 83 E1 F0 48 89 CF 48 89 8D 70 FF FF FF E8 ?? ?? ?? ?? 48 BA 2F 2E 72 68 6F 73 74 73 C6 40 08 00 48 89 10 E8 ?? ?? ?? ?? 89 85 7C FF FF FF 48 8B 45 98 8B 78 10 E8 ?? ?? ?? ?? 48 8B 45 98 48 8B 8D 70 FF FF FF 8B 70 10 48 89 CF E8 3C FD FF FF 48 85 C0 74 31 48 8B 55 80 48 8B 75 88 48 89 C7 4D 89 F9 4D 89 F0 4C 89 E1 48 89 85 70 FF FF FF E8 E7 F8 FF FF 4C 8B 95 70 FF FF FF 89 C3 4C 89 D7 E8 ?? ?? ?? ?? 8B BD 7C FF FF FF E8 ?? ?? ?? ?? E9 09 FF FF FF 66 0F 1F 44 00 00 31 F6 BF ?? ?? ?? ?? E8 E4 FC FF FF 48 85 C0 0F 84 A6 FE FF FF 48 8B 55 80 48 8B 75 88 4D 89 F9 4D 89 F0 4C 89 E1 48 89 C7 48 89 85 70 FF FF FF E8 8B F8 FF FF 4C 8B 9D 70 FF FF FF 89 C3 4C 89 DF E8 ?? ?? ?? ?? 85 DB 0F 85 72 FE FF FF E9 B0 FE FF FF }
	condition:
		$1
}

rule file_252_3_0 {
	meta:
		name = "rresvport_af"
		size = 411
		refs = "003d __libc_errno 00a1 __socket 00f2 __bind 0130 __close"
	strings:
		$1 = { 48 89 6C 24 D8 4C 89 7C 24 F8 89 F5 48 89 5C 24 D0 4C 89 64 24 E0 49 89 FF 4C 89 6C 24 E8 4C 89 74 24 F0 48 81 EC B8 00 00 00 66 83 FE 02 74 60 66 83 FE 0A 0F 84 0E 01 00 00 48 8B 05 ?? ?? ?? ?? BB FF FF FF FF 64 C7 00 61 00 00 00 89 D8 48 8B AC 24 90 00 00 00 48 8B 9C 24 88 00 00 00 4C 8B A4 24 98 00 00 00 4C 8B AC 24 A0 00 00 00 4C 8B B4 24 A8 00 00 00 4C 8B BC 24 B0 00 00 00 48 81 C4 B8 00 00 00 C3 66 0F 1F 84 00 00 00 00 00 41 BE 10 00 00 00 31 D2 0F B7 FD BE 01 00 00 00 E8 ?? ?? ?? ?? 85 C0 89 C3 0F 88 E2 00 00 00 31 C0 B9 10 00 00 00 48 89 E7 F3 48 AB 66 89 2C 24 45 8B 27 41 81 FC FF 01 00 00 0F 8F 88 00 00 00 41 C7 07 00 02 00 00 41 BC 00 02 00 00 44 89 E0 44 89 F2 48 89 E6 89 DF 66 C1 C8 08 66 89 44 24 02 E8 ?? ?? ?? ?? 85 C0 0F 89 4F FF FF FF 48 8B 2D ?? ?? ?? ?? 64 83 7D 00 62 75 74 41 8B 17 8D 42 FF 81 FA 00 02 00 00 BA FF 03 00 00 0F 44 C2 41 39 C4 41 89 07 75 B8 89 DF BB FF FF FF FF E8 ?? ?? ?? ?? 64 C7 45 00 0B 00 00 00 E9 0C FF FF FF 0F 1F 80 00 00 00 00 41 BE 1C 00 00 00 E9 43 FF FF FF 0F 1F 44 00 00 41 81 FC FF 03 00 00 0F 8E 78 FF FF FF 41 C7 07 FF 03 00 00 41 BC FF 03 00 00 E9 66 FF FF FF 66 0F 1F 84 00 00 00 00 00 89 DF BB FF FF FF FF E8 ?? ?? ?? ?? E9 BC FE FF FF BB FF FF FF FF E9 B2 FE FF FF }
	condition:
		$1
}

rule file_252_4_0 {
	meta:
		name = "rcmd_af"
		size = 2427
		refs = "0058 __getpid 009b __snprintf 00b5 getaddrinfo 00e7 free 00f5 __strdup 0125 __sigblock 0142 rresvport_af 015d __fcntl 016b __connect 017a __close 0181 __libc_errno 01d4 getnameinfo 01e3 _libc_intl_domainname 01e8 __dcgettext 01ff __asprintf 0216 __fxprintf 022b perror 0325 __sleep 03a4 __sigsetmask 03ae freeaddrinfo 0403 __listen 0461 __write 04d4 __poll 04ff accept 056d strlen 05cb __writev 05f3 __read 06a8 gai_strerror 06fc __strerror_r"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 53 89 F3 48 81 EC E8 01 00 00 44 0F B7 A4 24 20 02 00 00 48 89 7C 24 10 48 89 54 24 20 48 89 4C 24 28 4C 89 44 24 30 4C 89 4C 24 18 44 89 E0 83 E0 F7 66 83 F8 02 0F 84 F3 02 00 00 66 45 85 E4 0F 85 80 07 00 00 48 8D AC 24 B0 00 00 00 E8 ?? ?? ?? ?? B9 06 00 00 00 41 89 C5 48 89 EF 31 C0 F3 48 AB C7 84 24 B0 00 00 00 02 00 00 00 C7 84 24 B8 00 00 00 01 00 00 00 48 8D 7C 24 50 BA ?? ?? ?? ?? BE 08 00 00 00 66 C1 CB 08 31 C0 0F B7 CB E8 ?? ?? ?? ?? 48 8B 44 24 10 48 8D 4C 24 60 48 8D 74 24 50 48 89 EA 48 8B 38 E8 ?? ?? ?? ?? 85 C0 0F 85 EF 01 00 00 48 8B 5C 24 60 66 C7 44 24 74 01 00 66 C7 44 24 7C 01 00 48 83 7B 20 00 0F 84 E9 05 00 00 48 8B 3D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 44 24 60 48 8B 78 20 E8 ?? ?? ?? ?? 48 85 C0 48 89 05 ?? ?? ?? ?? 0F 84 0A 08 00 00 48 8B 54 24 10 48 8B 5C 24 60 48 89 02 BF 00 00 40 00 45 31 E4 41 BE 01 00 00 00 E8 ?? ?? ?? ?? C7 44 24 48 FF 03 00 00 89 44 24 3C 0F 1F 00 0F B7 73 04 48 8D 7C 24 48 E8 ?? ?? ?? ?? 85 C0 89 C5 0F 88 30 02 00 00 89 C7 44 89 EA BE 08 00 00 00 31 C0 E8 ?? ?? ?? ?? 8B 53 10 48 8B 73 18 89 EF E8 ?? ?? ?? ?? 85 C0 0F 89 49 02 00 00 89 EF E8 ?? ?? ?? ?? 4C 8B 3D ?? ?? ?? ?? 64 41 8B 2F 83 FD 62 0F 84 66 01 00 00 83 FD 6F B8 01 00 00 00 44 0F 44 E0 48 83 7B 28 00 0F 84 5F 01 00 00 8B 73 10 48 C7 44 24 68 00 00 00 00 48 8D 94 24 80 00 00 00 48 8B 7B 18 45 31 C9 45 31 C0 B9 2E 00 00 00 C7 04 24 01 00 00 00 E8 ?? ?? ?? ?? BA 05 00 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 94 24 80 00 00 00 48 8D 7C 24 68 48 89 C6 31 C0 E8 ?? ?? ?? ?? 85 C0 78 1D 48 8B 54 24 68 31 FF BE ?? ?? ?? ?? 31 C0 E8 ?? ?? ?? ?? 48 8B 7C 24 68 E8 ?? ?? ?? ?? 31 FF 64 41 89 2F E8 ?? ?? ?? ?? 48 8B 5B 28 48 8D 94 24 80 00 00 00 45 31 C9 45 31 C0 B9 2E 00 00 00 8B 73 10 48 8B 7B 18 C7 04 24 01 00 00 00 E8 ?? ?? ?? ?? BA 05 00 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 94 24 80 00 00 00 48 8D 7C 24 68 48 89 C6 31 C0 E8 ?? ?? ?? ?? 85 C0 0F 88 AC FE FF FF 48 8B 54 24 68 31 FF BE ?? ?? ?? ?? 31 C0 E8 ?? ?? ?? ?? 48 8B 7C 24 68 E8 ?? ?? ?? ?? E9 8A FE FF FF 66 90 83 F8 FE 0F 85 E7 03 00 00 48 8B 4C 24 10 48 8B 11 48 85 D2 0F 84 D6 03 00 00 BE ?? ?? ?? ?? 31 FF 31 C0 BD FF FF FF FF E8 ?? ?? ?? ?? 48 81 C4 E8 01 00 00 89 E8 5B 5D 41 5C 41 5D 41 5E 41 5F C3 0F 1F 80 00 00 00 00 83 6C 24 48 01 E9 36 FE FF FF 66 0F 1F 44 00 00 45 85 E4 0F 84 CF 03 00 00 41 83 FE 10 0F 8F C5 03 00 00 44 89 F7 45 31 E4 45 01 F6 E8 ?? ?? ?? ?? 48 8B 5C 24 60 E9 05 FE FF FF 0F 1F 44 00 00 48 8D AC 24 B0 00 00 00 E8 ?? ?? ?? ?? B9 06 00 00 00 41 89 C5 48 89 EF 31 C0 F3 48 AB C7 84 24 B0 00 00 00 02 00 00 00 44 89 A4 24 B4 00 00 00 C7 84 24 B8 00 00 00 01 00 00 00 E9 0A FD FF FF 0F 1F 84 00 00 00 00 00 48 8B 05 ?? ?? ?? ?? 64 83 38 0B 0F 84 E0 02 00 00 BE ?? ?? ?? ?? 31 FF 31 C0 E8 ?? ?? ?? ?? 8B 7C 24 3C E8 ?? ?? ?? ?? 48 8B 7C 24 60 E8 ?? ?? ?? ?? BD FF FF FF FF E9 21 FF FF FF 0F 1F 40 00 83 6C 24 48 01 48 83 7C 24 18 00 0F 84 56 03 00 00 0F B7 73 04 48 8D 7C 24 48 E8 ?? ?? ?? ?? 41 89 C4 8B 43 10 45 85 E4 89 44 24 4C 0F 88 73 02 00 00 BE 01 00 00 00 44 89 E7 4C 8D AC 24 E0 00 00 00 E8 ?? ?? ?? ?? 8B 4C 24 48 BA ?? ?? ?? ?? BE 08 00 00 00 4C 89 EF 31 C0 E8 ?? ?? ?? ?? 4C 89 EA 8B 0A 48 83 C2 04 8D 81 FF FE FE FE F7 D1 21 C8 25 80 80 80 80 74 E9 89 C1 4C 89 EE 89 EF C1 E9 10 A9 80 80 00 00 0F 44 C1 48 8D 4A 02 48 0F 44 D1 00 C0 48 83 DA 03 4C 29 EA 48 83 C2 01 E8 ?? ?? ?? ?? 4C 89 E9 8B 31 48 83 C1 04 8D 96 FF FE FE FE F7 D6 21 F2 81 E2 80 80 80 80 74 E8 89 D6 C1 EE 10 F7 C2 80 80 00 00 0F 44 D6 48 8D 71 02 48 0F 44 CE 00 D2 48 83 D9 03 4C 29 E9 48 83 C1 01 48 39 C8 0F 85 3B 03 00 00 4C 8B 3D ?? ?? ?? ?? 48 8D 7C 24 70 BA FF FF FF FF BE 02 00 00 00 89 6C 24 70 44 89 64 24 78 64 41 C7 07 00 00 00 00 E8 ?? ?? ?? ?? 85 C0 0F 8E 61 03 00 00 F6 44 24 7E 01 48 8D 5C 24 4C 0F 84 51 03 00 00 48 8D B4 24 10 01 00 00 48 89 DA 44 89 E7 E8 ?? ?? ?? ?? 83 F8 FF 75 07 64 41 83 3F 04 74 E1 41 89 C6 0F B7 84 24 10 01 00 00 66 83 F8 02 0F 84 34 02 00 00 45 31 FF 66 83 F8 0A 0F 84 27 02 00 00 44 89 E7 E8 ?? ?? ?? ?? 45 85 F6 0F 88 B6 03 00 00 48 8B 54 24 18 66 41 81 EF 00 02 66 41 81 FF FF 01 44 89 32 0F 87 22 03 00 00 48 8B 54 24 20 48 89 D7 48 89 94 24 E0 00 00 00 E8 ?? ?? ?? ?? 48 8B 4C 24 28 48 83 C0 01 48 89 84 24 E8 00 00 00 48 89 CF 48 89 8C 24 F0 00 00 00 E8 ?? ?? ?? ?? 48 83 C0 01 48 89 84 24 F8 00 00 00 48 8B 44 24 30 48 89 C7 48 89 84 24 00 01 00 00 E8 ?? ?? ?? ?? 48 83 C0 01 48 89 84 24 08 01 00 00 90 BA 03 00 00 00 4C 89 EE 89 EF E8 ?? ?? ?? ?? 48 83 F8 FF 75 13 48 8B 15 ?? ?? ?? ?? 64 83 3A 04 74 DE 66 0F 1F 44 00 00 BA 01 00 00 00 48 89 DE 89 EF E8 ?? ?? ?? ?? 48 83 F8 FF 0F 85 6A 01 00 00 48 8B 15 ?? ?? ?? ?? 64 83 3A 04 74 DA 48 C7 44 24 68 00 00 00 00 48 8B 44 24 10 BE ?? ?? ?? ?? 48 8B 10 48 8D 7C 24 68 31 C0 E8 ?? ?? ?? ?? 85 C0 78 1D 48 8B 54 24 68 31 FF BE ?? ?? ?? ?? 31 C0 E8 ?? ?? ?? ?? 48 8B 7C 24 68 E8 ?? ?? ?? ?? 8B 4C 24 48 85 C9 74 0C 48 8B 4C 24 18 8B 39 E8 ?? ?? ?? ?? 89 EF E8 ?? ?? ?? ?? E9 2E FD FF FF BA 05 00 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? BE ?? ?? ?? ?? 48 89 C2 31 FF 31 C0 E8 ?? ?? ?? ?? E9 04 FD FF FF 0F 1F 44 00 00 89 C7 BD FF FF FF FF E8 ?? ?? ?? ?? BE ?? ?? ?? ?? 48 89 C2 31 FF 31 C0 E8 ?? ?? ?? ?? E9 1B FC FF FF 66 0F 1F 44 00 00 48 8B 4C 24 10 48 C7 01 00 00 00 00 E9 3D FA FF FF 0F 1F 80 00 00 00 00 48 8B 7C 24 60 E8 ?? ?? ?? ?? 64 41 8B 3F 48 8D B4 24 10 01 00 00 BA C8 00 00 00 E8 ?? ?? ?? ?? 48 89 C1 48 8B 44 24 10 31 FF BE ?? ?? ?? ?? 48 8B 10 31 C0 E8 ?? ?? ?? ?? 8B 7C 24 3C E8 ?? ?? ?? ?? E9 8B FC FF FF BA 01 00 00 00 BE ?? ?? ?? ?? 89 EF E8 ?? ?? ?? ?? 4C 8D AC 24 E0 00 00 00 C7 44 24 48 00 00 00 00 48 8D 5C 24 4C E9 0A FE FF FF 66 0F 1F 44 00 00 44 0F B7 BC 24 12 01 00 00 66 41 C1 CF 08 E9 C6 FD FF FF 48 83 F8 01 0F 85 CD 01 00 00 80 7C 24 4C 00 75 1C 8B 7C 24 3C E8 ?? ?? ?? ?? 48 8B 7C 24 60 E8 ?? ?? ?? ?? E9 49 FB FF FF 0F 1F 40 00 BA 01 00 00 00 48 89 DE 89 EF E8 ?? ?? ?? ?? 48 83 F8 01 0F 85 A0 FE FF FF BA 01 00 00 00 48 89 DE BF 02 00 00 00 E8 ?? ?? ?? ?? 80 7C 24 4C 0A 75 CE E9 82 FE FF FF 48 8B 05 ?? ?? ?? ?? BD FF FF FF FF 64 C7 00 61 00 00 00 E9 F6 FA FF FF BA 05 00 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? 48 C7 44 24 68 00 00 00 00 E8 ?? ?? ?? ?? 48 8D 7C 24 68 48 89 C6 31 C0 E8 ?? ?? ?? ?? 85 C0 78 1D 48 8B 54 24 68 31 FF BE ?? ?? ?? ?? 31 C0 E8 ?? ?? ?? ?? 48 8B 7C 24 68 E8 ?? ?? ?? ?? 44 89 E7 E8 ?? ?? ?? ?? E9 24 FE FF FF 64 41 8B 37 48 C7 44 24 68 00 00 00 00 85 F6 75 65 48 8D 5C 24 68 BA 05 00 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 DF 48 89 C6 31 C0 E8 ?? ?? ?? ?? 85 C0 79 9B EB B6 BA 05 00 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? 48 C7 44 24 68 00 00 00 00 E8 ?? ?? ?? ?? 48 8D 7C 24 68 48 89 C6 31 C0 E8 ?? ?? ?? ?? 85 C0 0F 89 82 FD FF FF E9 9A FD FF FF 48 8D 5C 24 68 BA 05 00 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 DF 48 89 C6 31 C0 E8 ?? ?? ?? ?? 85 C0 0F 89 32 FF FF FF 64 41 83 3F 00 0F 85 44 FF FF FF E9 62 FF FF FF 0F 1F 00 BE ?? ?? ?? ?? 31 FF 31 C0 E8 ?? ?? ?? ?? C7 44 24 48 00 00 00 00 E9 52 FD FF FF BA 05 00 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? BE ?? ?? ?? ?? 48 89 C2 31 FF 31 C0 BD FF FF FF FF E8 ?? ?? ?? ?? E9 9B F9 FF FF 48 85 C0 48 C7 44 24 68 00 00 00 00 0F 85 C3 FC FF FF 48 8B 54 24 10 BE ?? ?? ?? ?? BF ?? ?? ?? ?? 48 8B 1A BA 05 00 00 00 E8 ?? ?? ?? ?? 48 89 C6 48 89 DA E9 A9 FC FF FF }
	condition:
		$1
}

rule file_252_5_0 {
	meta:
		name = "rcmd"
		size = 24
		refs = "000f rcmd_af"
	strings:
		$1 = { 48 83 EC 18 0F B7 F6 C7 04 24 02 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_252_7_0 {
	meta:
		name = "ruserok_af"
		size = 188
		refs = "003e getaddrinfo 0085 freeaddrinfo"
	strings:
		$1 = { 41 56 31 C0 49 89 CE B9 06 00 00 00 45 0F B7 C0 41 55 49 89 D5 41 54 41 89 F4 31 F6 55 48 89 FD 53 48 83 EC 40 48 8D 54 24 10 48 89 D7 F3 48 AB 48 8D 4C 24 08 48 89 EF 44 89 44 24 14 E8 ?? ?? ?? ?? 85 C0 75 6F 48 8B 5C 24 08 48 85 DB 75 11 EB 5A 66 0F 1F 44 00 00 48 8B 5B 28 48 85 DB 74 3F 8B 73 10 48 8B 7B 18 49 89 E9 4D 89 F0 4C 89 E9 44 89 E2 E8 57 F2 FF FF 85 C0 75 DB 48 8B 7C 24 08 31 DB E8 ?? ?? ?? ?? 48 83 C4 40 89 D8 5B 5D 41 5C 41 5D 41 5E C3 0F 1F 84 00 00 00 00 00 48 8B 7C 24 08 BB FF FF FF FF EB D8 31 FF BB FF FF FF FF EB CF BB FF FF FF FF EB CD }
	condition:
		$1
}

rule file_252_9_0 {
	meta:
		name = "iruserok_af"
		size = 142
	strings:
		$1 = { 53 31 C0 49 89 F9 48 89 CB B9 10 00 00 00 41 89 F3 48 83 C4 80 66 41 83 F8 02 48 89 E7 F3 48 AB 74 16 31 C0 66 41 83 F8 0A 74 45 48 83 EC 80 5B C3 0F 1F 80 00 00 00 00 66 C7 04 24 02 00 41 8B 01 BE 10 00 00 00 89 44 24 04 49 89 D8 48 89 D1 48 89 E7 41 B9 ?? ?? ?? ?? 44 89 DA E8 9F F1 FF FF 48 83 EC 80 5B C3 66 0F 1F 84 00 00 00 00 00 66 C7 04 24 0A 00 49 8B 01 BE 1C 00 00 00 48 89 44 24 08 49 8B 41 08 48 89 44 24 10 EB BC }
	condition:
		$1
}

rule file_252_10_0 {
	meta:
		name = "iruserok"
		size = 29
		refs = "0014 iruserok_af"
	strings:
		$1 = { 48 83 EC 18 41 B8 02 00 00 00 89 7C 24 0C 48 8D 7C 24 0C E8 ?? ?? ?? ?? 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_252_11_0 {
	meta:
		name = "__ivaliduser"
		size = 61
	strings:
		$1 = { 48 83 EC 18 49 89 C8 41 B9 ?? ?? ?? ?? 48 C7 04 24 00 00 00 00 48 89 D1 89 74 24 04 BA 10 00 00 00 48 89 E6 48 C7 44 24 08 00 00 00 00 66 C7 04 24 02 00 E8 58 EB FF FF 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_253_1_0 {
	meta:
		name = "hsearch"
		size = 30
		refs = "0010 hsearch_r"
	strings:
		$1 = { 48 83 EC 28 41 B8 ?? ?? ?? ?? 48 8D 4C 24 18 E8 ?? ?? ?? ?? 48 8B 44 24 18 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_254_0_0 {
	meta:
		name = "psiginfo"
		size = 1148
		refs = "0034 fmemopen 006c _sys_siglist 007f _libc_intl_domainname 0084 __dcgettext 0096 fprintf 0199 __libc_current_sigrtmin 01a7 __libc_current_sigrtmax 01e8 _IO_new_fclose 022d __write_nocancel 02f2 __fxprintf 0453 fwrite"
	strings:
		$1 = { 48 89 6C 24 E0 4C 89 6C 24 F0 48 89 FD 48 89 5C 24 D8 4C 89 64 24 E8 49 89 F5 4C 89 74 24 F8 48 81 EC 28 02 00 00 BA ?? ?? ?? ?? BE 00 02 00 00 48 89 E7 E8 ?? ?? ?? ?? 48 85 C0 0F 84 8F 02 00 00 4D 85 ED 49 89 E4 48 89 C3 74 0B 41 80 7D 00 00 0F 85 11 02 00 00 44 8B 6D 00 41 83 FD 40 0F 87 5B 01 00 00 49 63 C5 48 8B 34 C5 ?? ?? ?? ?? 48 85 F6 0F 84 1F 01 00 00 BA 05 00 00 00 BF ?? ?? ?? ?? E8 ?? ?? ?? ?? BE ?? ?? ?? ?? 48 89 C2 48 89 DF 31 C0 E8 ?? ?? ?? ?? 8B 45 00 83 E8 04 83 F8 19 76 43 8B 55 08 83 FA FD 0F 84 DF 02 00 00 0F 8E C9 01 00 00 83 FA FF 0F 84 B0 02 00 00 0F 8C 9A 02 00 00 85 D2 0F 84 82 02 00 00 81 FA 80 00 00 00 0F 85 26 02 00 00 BE ?? ?? ?? ?? EB 41 0F 1F 80 00 00 00 00 48 8B 0C C5 ?? ?? ?? ?? 48 8B 34 C5 ?? ?? ?? ?? 48 8B 3C C5 ?? ?? ?? ?? 8B 55 08 48 85 C9 74 A0 85 D2 7E 9C 48 63 C2 48 39 F8 77 94 0F B6 44 01 FF 48 01 C6 0F 84 DE 01 00 00 BA 05 00 00 00 BF ?? ?? ?? ?? E8 ?? ?? ?? ?? BE ?? ?? ?? ?? 48 89 C2 48 89 DF 31 C0 E8 ?? ?? ?? ?? 8B 45 00 83 F8 08 0F 84 61 01 00 00 83 F8 04 0F 84 58 01 00 00 83 F8 0B 0F 84 4F 01 00 00 83 F8 07 0F 84 46 01 00 00 83 F8 11 0F 84 3D 02 00 00 83 F8 1D 0F 84 AC 01 00 00 8B 4D 14 48 63 55 10 BE ?? ?? ?? ?? 48 89 DF 31 C0 E8 ?? ?? ?? ?? EB 50 0F 1F 40 00 E8 ?? ?? ?? ?? 41 39 C5 44 8B 6D 00 7C 1A E8 ?? ?? ?? ?? 41 39 C5 0F 8C 1B 02 00 00 44 8B 6D 00 0F 1F 84 00 00 00 00 00 BA 05 00 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 44 89 EA 48 89 C6 48 89 DF 31 C0 E8 ?? ?? ?? ?? 48 89 DF E8 ?? ?? ?? ?? 48 89 E2 8B 0A 48 83 C2 04 8D 81 FF FE FE FE F7 D1 21 C8 25 80 80 80 80 74 E9 89 C1 48 89 E6 BF 02 00 00 00 C1 E9 10 A9 80 80 00 00 0F 44 C1 48 8D 4A 02 48 0F 44 D1 00 C0 48 83 DA 03 4C 29 E2 E8 ?? ?? ?? ?? 48 8B 9C 24 00 02 00 00 48 8B AC 24 08 02 00 00 4C 8B A4 24 10 02 00 00 4C 8B AC 24 18 02 00 00 4C 8B B4 24 20 02 00 00 48 81 C4 28 02 00 00 C3 0F 1F 80 00 00 00 00 48 89 C7 4C 89 EA BE ?? ?? ?? ?? 31 C0 E8 ?? ?? ?? ?? E9 D8 FD FF FF 90 83 FA FA 0F 84 17 01 00 00 0F 1F 80 00 00 00 00 0F 8E AA 00 00 00 83 FA FB 0F 84 E1 00 00 00 83 FA FC 75 5C BE ?? ?? ?? ?? E9 74 FE FF FF 66 90 48 8B 55 10 BE ?? ?? ?? ?? 48 89 DF 31 C0 E8 ?? ?? ?? ?? E9 1C FF FF FF 0F 1F 84 00 00 00 00 00 4D 85 ED 74 43 41 80 7D 00 00 74 3C B9 ?? ?? ?? ?? 44 8B 45 00 4C 89 EA BE ?? ?? ?? ?? 31 FF 31 C0 E8 ?? ?? ?? ?? E9 36 FF FF FF 0F 1F 44 00 00 BE ?? ?? ?? ?? 48 89 DF 31 C0 E8 ?? ?? ?? ?? E9 2F FE FF FF 0F 1F 40 00 B9 ?? ?? ?? ?? 49 89 CD EB BF 66 0F 1F 44 00 00 48 8B 55 10 BE ?? ?? ?? ?? 48 89 DF 31 C0 E8 ?? ?? ?? ?? E9 A4 FE FF FF 83 FA C4 75 BB BE ?? ?? ?? ?? E9 D3 FD FF FF 90 BE ?? ?? ?? ?? E9 C8 FD FF FF 66 0F 1F 44 00 00 BE ?? ?? ?? ?? E9 B8 FD FF FF 66 0F 1F 44 00 00 BE ?? ?? ?? ?? E9 A8 FD FF FF 66 0F 1F 44 00 00 BE ?? ?? ?? ?? E9 98 FD FF FF 66 0F 1F 44 00 00 BE ?? ?? ?? ?? E9 88 FD FF FF 66 0F 1F 44 00 00 BE ?? ?? ?? ?? E9 78 FD FF FF 66 0F 1F 44 00 00 48 63 55 10 44 8B 45 14 BE ?? ?? ?? ?? 8B 4D 18 48 89 DF 31 C0 E8 ?? ?? ?? ?? E9 15 FE FF FF 44 8B 75 00 E8 ?? ?? ?? ?? 41 29 C6 E8 ?? ?? ?? ?? 44 8B 6D 00 44 29 E8 41 39 C6 7D 2C E8 ?? ?? ?? ?? 41 39 C5 74 4A 44 8B 6D 00 E8 ?? ?? ?? ?? BE ?? ?? ?? ?? 48 89 DF 44 89 EA 29 C2 31 C0 E8 ?? ?? ?? ?? E9 82 FC FF FF E8 ?? ?? ?? ?? 41 39 C5 74 3E E8 ?? ?? ?? ?? 2B 45 00 BE ?? ?? ?? ?? 48 89 DF 89 C2 31 C0 E8 ?? ?? ?? ?? E9 5A FC FF FF 48 89 D9 BA 0A 00 00 00 BE 01 00 00 00 BF ?? ?? ?? ?? E8 ?? ?? ?? ?? E9 3E FC FF FF 0F 1F 40 00 48 89 D9 BA 0A 00 00 00 BE 01 00 00 00 BF ?? ?? ?? ?? E8 ?? ?? ?? ?? E9 1E FC FF FF }
	condition:
		$1
}

rule file_255_0_0 {
	meta:
		name = "__strndup"
		size = 97
		refs = "0012 __strnlen 001e malloc 0043 memcpy"
	strings:
		$1 = { 48 89 5C 24 F0 48 89 6C 24 F8 48 83 EC 18 48 89 FD E8 ?? ?? ?? ?? 48 8D 78 01 48 89 C3 E8 ?? ?? ?? ?? 48 85 C0 74 29 C6 04 18 00 48 89 DA 48 89 EE 48 8B 5C 24 08 48 8B 6C 24 10 48 89 C7 48 83 C4 18 E9 ?? ?? ?? ?? 66 0F 1F 84 00 00 00 00 00 31 C0 48 8B 5C 24 08 48 8B 6C 24 10 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_256_0_0 {
	meta:
		name = "__libc_init_first"
		size = 156
		refs = "0001 _dl_starting_up 0032 __fpu_control 0038 __libc_multiple_libcs 0041 __setfpucw 0047 __libc_argc 004e __libc_argv 0055 __environ 005a __libc_init_secure 005f _dl_non_dynamic_init 006c __init_misc 0083 __ctype_init"
	strings:
		$1 = { B8 ?? ?? ?? ?? 48 89 5C 24 E8 48 89 6C 24 F0 4C 89 64 24 F8 48 83 EC 18 48 85 C0 89 FB 48 89 F5 49 89 D4 74 0A 8B 05 ?? ?? ?? ?? 85 C0 74 61 0F B7 3D ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 00 00 00 00 E8 ?? ?? ?? ?? 89 1D ?? ?? ?? ?? 48 89 2D ?? ?? ?? ?? 4C 89 25 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 4C 89 E2 48 89 EE 89 DF E8 ?? ?? ?? ?? 48 8B 1C 24 48 8B 6C 24 08 4C 8B 64 24 10 48 83 C4 18 E9 ?? ?? ?? ?? 66 0F 1F 84 00 00 00 00 00 C7 05 ?? ?? ?? ?? 01 00 00 00 EB A9 }
	condition:
		$1
}

rule file_257_0_0 {
	meta:
		name = "_L_lock_30"
		size = 31
		refs = "000f __lll_lock_wait_private"
	strings:
		$1 = { 48 8D 3D ?? ?? ?? ?? 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 EF FE FF FF }
	condition:
		$1
}

rule file_257_2_0 {
	meta:
		name = "getspnam"
		size = 298
		refs = "0014 __libc_multiple_threads 0068 __getspnam_r 0090 realloc 00a0 free 00a7 __libc_errno 010d malloc"
	strings:
		$1 = { 41 54 BE 01 00 00 00 49 89 FC 31 C0 55 53 48 83 EC 10 83 3D ?? ?? ?? ?? 00 74 10 F0 0F B1 35 ?? ?? ?? ?? 0F 85 01 01 00 00 EB 0D 0F B1 35 ?? ?? ?? ?? 0F 85 F2 00 00 00 48 8B 15 ?? ?? ?? ?? 48 8B 1D ?? ?? ?? ?? 48 85 D2 75 0C E9 AC 00 00 00 48 89 05 ?? ?? ?? ?? 4C 8D 44 24 08 48 89 D9 BE ?? ?? ?? ?? 4C 89 E7 E8 ?? ?? ?? ?? 83 F8 22 75 7F 48 8B 1D ?? ?? ?? ?? 48 8B 2D ?? ?? ?? ?? 48 01 DB 48 89 EF 48 89 DE 48 89 1D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 85 C0 48 89 C2 75 B4 48 89 EF E8 ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? 48 C7 05 ?? ?? ?? ?? 00 00 00 00 64 C7 00 0C 00 00 00 48 C7 44 24 08 00 00 00 00 83 3D ?? ?? ?? ?? 00 74 0B F0 FF 0D ?? ?? ?? ?? 75 71 EB 08 FF 0D ?? ?? ?? ?? 75 67 48 8B 44 24 08 48 83 C4 10 5B 5D 41 5C C3 48 83 3D ?? ?? ?? ?? 00 75 CC EB C1 BF 00 04 00 00 48 C7 05 ?? ?? ?? ?? 00 04 00 00 E8 ?? ?? ?? ?? 48 85 C0 48 89 C2 48 89 05 ?? ?? ?? ?? 74 9D BB 00 04 00 00 E9 2D FF FF FF }
	condition:
		$1
}

rule file_1350_2_0 {
	meta:
		name = "getaliasbyname"
		size = 298
		refs = "0014 __libc_multiple_threads 0068 __getaliasbyname_r 0090 realloc 00a0 free 00a7 __libc_errno 010d malloc"
	strings:
		$1 = { 41 54 BE 01 00 00 00 49 89 FC 31 C0 55 53 48 83 EC 10 83 3D ?? ?? ?? ?? 00 74 10 F0 0F B1 35 ?? ?? ?? ?? 0F 85 01 01 00 00 EB 0D 0F B1 35 ?? ?? ?? ?? 0F 85 F2 00 00 00 48 8B 15 ?? ?? ?? ?? 48 8B 1D ?? ?? ?? ?? 48 85 D2 75 0C E9 AC 00 00 00 48 89 05 ?? ?? ?? ?? 4C 8D 44 24 08 48 89 D9 BE ?? ?? ?? ?? 4C 89 E7 E8 ?? ?? ?? ?? 83 F8 22 75 7F 48 8B 1D ?? ?? ?? ?? 48 8B 2D ?? ?? ?? ?? 48 01 DB 48 89 EF 48 89 DE 48 89 1D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 85 C0 48 89 C2 75 B4 48 89 EF E8 ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? 48 C7 05 ?? ?? ?? ?? 00 00 00 00 64 C7 00 0C 00 00 00 48 C7 44 24 08 00 00 00 00 83 3D ?? ?? ?? ?? 00 74 0B F0 FF 0D ?? ?? ?? ?? 75 71 EB 08 FF 0D ?? ?? ?? ?? 75 67 48 8B 44 24 08 48 83 C4 10 5B 5D 41 5C C3 48 83 3D ?? ?? ?? ?? 00 75 CC EB C1 BF 00 04 00 00 48 C7 05 ?? ?? ?? ?? 00 04 00 00 E8 ?? ?? ?? ?? 48 85 C0 48 89 C2 48 89 05 ?? ?? ?? ?? 74 9D BB 00 04 00 00 E9 2D FF FF FF }
	condition:
		$1
}

rule file_519_2_0 {
	meta:
		name = "getgrnam"
		size = 298
		refs = "0014 __libc_multiple_threads 0068 __getgrnam_r 0090 realloc 00a0 free 00a7 __libc_errno 010d malloc"
	strings:
		$1 = { 41 54 BE 01 00 00 00 49 89 FC 31 C0 55 53 48 83 EC 10 83 3D ?? ?? ?? ?? 00 74 10 F0 0F B1 35 ?? ?? ?? ?? 0F 85 01 01 00 00 EB 0D 0F B1 35 ?? ?? ?? ?? 0F 85 F2 00 00 00 48 8B 15 ?? ?? ?? ?? 48 8B 1D ?? ?? ?? ?? 48 85 D2 75 0C E9 AC 00 00 00 48 89 05 ?? ?? ?? ?? 4C 8D 44 24 08 48 89 D9 BE ?? ?? ?? ?? 4C 89 E7 E8 ?? ?? ?? ?? 83 F8 22 75 7F 48 8B 1D ?? ?? ?? ?? 48 8B 2D ?? ?? ?? ?? 48 01 DB 48 89 EF 48 89 DE 48 89 1D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 85 C0 48 89 C2 75 B4 48 89 EF E8 ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? 48 C7 05 ?? ?? ?? ?? 00 00 00 00 64 C7 00 0C 00 00 00 48 C7 44 24 08 00 00 00 00 83 3D ?? ?? ?? ?? 00 74 0B F0 FF 0D ?? ?? ?? ?? 75 71 EB 08 FF 0D ?? ?? ?? ?? 75 67 48 8B 44 24 08 48 83 C4 10 5B 5D 41 5C C3 48 83 3D ?? ?? ?? ?? 00 75 CC EB C1 BF 00 04 00 00 48 C7 05 ?? ?? ?? ?? 00 04 00 00 E8 ?? ?? ?? ?? 48 85 C0 48 89 C2 48 89 05 ?? ?? ?? ?? 74 9D BB 00 04 00 00 E9 2D FF FF FF }
	condition:
		$1
}

rule file_436_2_0 {
	meta:
		name = "getprotobyname"
		size = 298
		refs = "0014 __libc_multiple_threads 0068 __getprotobyname_r 0090 realloc 00a0 free 00a7 __libc_errno 010d malloc"
	strings:
		$1 = { 41 54 BE 01 00 00 00 49 89 FC 31 C0 55 53 48 83 EC 10 83 3D ?? ?? ?? ?? 00 74 10 F0 0F B1 35 ?? ?? ?? ?? 0F 85 01 01 00 00 EB 0D 0F B1 35 ?? ?? ?? ?? 0F 85 F2 00 00 00 48 8B 15 ?? ?? ?? ?? 48 8B 1D ?? ?? ?? ?? 48 85 D2 75 0C E9 AC 00 00 00 48 89 05 ?? ?? ?? ?? 4C 8D 44 24 08 48 89 D9 BE ?? ?? ?? ?? 4C 89 E7 E8 ?? ?? ?? ?? 83 F8 22 75 7F 48 8B 1D ?? ?? ?? ?? 48 8B 2D ?? ?? ?? ?? 48 01 DB 48 89 EF 48 89 DE 48 89 1D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 85 C0 48 89 C2 75 B4 48 89 EF E8 ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? 48 C7 05 ?? ?? ?? ?? 00 00 00 00 64 C7 00 0C 00 00 00 48 C7 44 24 08 00 00 00 00 83 3D ?? ?? ?? ?? 00 74 0B F0 FF 0D ?? ?? ?? ?? 75 71 EB 08 FF 0D ?? ?? ?? ?? 75 67 48 8B 44 24 08 48 83 C4 10 5B 5D 41 5C C3 48 83 3D ?? ?? ?? ?? 00 75 CC EB C1 BF 00 04 00 00 48 C7 05 ?? ?? ?? ?? 00 04 00 00 E8 ?? ?? ?? ?? 48 85 C0 48 89 C2 48 89 05 ?? ?? ?? ?? 74 9D BB 00 04 00 00 E9 2D FF FF FF }
	condition:
		$1
}

rule file_303_2_0 {
	meta:
		name = "getpwnam"
		size = 298
		refs = "0014 __libc_multiple_threads 0068 __getpwnam_r 0090 realloc 00a0 free 00a7 __libc_errno 010d malloc"
	strings:
		$1 = { 41 54 BE 01 00 00 00 49 89 FC 31 C0 55 53 48 83 EC 10 83 3D ?? ?? ?? ?? 00 74 10 F0 0F B1 35 ?? ?? ?? ?? 0F 85 01 01 00 00 EB 0D 0F B1 35 ?? ?? ?? ?? 0F 85 F2 00 00 00 48 8B 15 ?? ?? ?? ?? 48 8B 1D ?? ?? ?? ?? 48 85 D2 75 0C E9 AC 00 00 00 48 89 05 ?? ?? ?? ?? 4C 8D 44 24 08 48 89 D9 BE ?? ?? ?? ?? 4C 89 E7 E8 ?? ?? ?? ?? 83 F8 22 75 7F 48 8B 1D ?? ?? ?? ?? 48 8B 2D ?? ?? ?? ?? 48 01 DB 48 89 EF 48 89 DE 48 89 1D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 85 C0 48 89 C2 75 B4 48 89 EF E8 ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? 48 C7 05 ?? ?? ?? ?? 00 00 00 00 64 C7 00 0C 00 00 00 48 C7 44 24 08 00 00 00 00 83 3D ?? ?? ?? ?? 00 74 0B F0 FF 0D ?? ?? ?? ?? 75 71 EB 08 FF 0D ?? ?? ?? ?? 75 67 48 8B 44 24 08 48 83 C4 10 5B 5D 41 5C C3 48 83 3D ?? ?? ?? ?? 00 75 CC EB C1 BF 00 04 00 00 48 C7 05 ?? ?? ?? ?? 00 04 00 00 E8 ?? ?? ?? ?? 48 85 C0 48 89 C2 48 89 05 ?? ?? ?? ?? 74 9D BB 00 04 00 00 E9 2D FF FF FF }
	condition:
		$1
}

rule file_355_2_0 {
	meta:
		name = "getrpcbyname"
		size = 298
		refs = "0014 __libc_multiple_threads 0068 __getrpcbyname_r 0090 realloc 00a0 free 00a7 __libc_errno 010d malloc"
	strings:
		$1 = { 41 54 BE 01 00 00 00 49 89 FC 31 C0 55 53 48 83 EC 10 83 3D ?? ?? ?? ?? 00 74 10 F0 0F B1 35 ?? ?? ?? ?? 0F 85 01 01 00 00 EB 0D 0F B1 35 ?? ?? ?? ?? 0F 85 F2 00 00 00 48 8B 15 ?? ?? ?? ?? 48 8B 1D ?? ?? ?? ?? 48 85 D2 75 0C E9 AC 00 00 00 48 89 05 ?? ?? ?? ?? 4C 8D 44 24 08 48 89 D9 BE ?? ?? ?? ?? 4C 89 E7 E8 ?? ?? ?? ?? 83 F8 22 75 7F 48 8B 1D ?? ?? ?? ?? 48 8B 2D ?? ?? ?? ?? 48 01 DB 48 89 EF 48 89 DE 48 89 1D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 85 C0 48 89 C2 75 B4 48 89 EF E8 ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? 48 C7 05 ?? ?? ?? ?? 00 00 00 00 64 C7 00 0C 00 00 00 48 C7 44 24 08 00 00 00 00 83 3D ?? ?? ?? ?? 00 74 0B F0 FF 0D ?? ?? ?? ?? 75 71 EB 08 FF 0D ?? ?? ?? ?? 75 67 48 8B 44 24 08 48 83 C4 10 5B 5D 41 5C C3 48 83 3D ?? ?? ?? ?? 00 75 CC EB C1 BF 00 04 00 00 48 C7 05 ?? ?? ?? ?? 00 04 00 00 E8 ?? ?? ?? ?? 48 85 C0 48 89 C2 48 89 05 ?? ?? ?? ?? 74 9D BB 00 04 00 00 E9 2D FF FF FF }
	condition:
		$1
}

rule file_501_2_0 {
	meta:
		name = "getsgnam"
		size = 298
		refs = "0014 __libc_multiple_threads 0068 __getsgnam_r 0090 realloc 00a0 free 00a7 __libc_errno 010d malloc"
	strings:
		$1 = { 41 54 BE 01 00 00 00 49 89 FC 31 C0 55 53 48 83 EC 10 83 3D ?? ?? ?? ?? 00 74 10 F0 0F B1 35 ?? ?? ?? ?? 0F 85 01 01 00 00 EB 0D 0F B1 35 ?? ?? ?? ?? 0F 85 F2 00 00 00 48 8B 15 ?? ?? ?? ?? 48 8B 1D ?? ?? ?? ?? 48 85 D2 75 0C E9 AC 00 00 00 48 89 05 ?? ?? ?? ?? 4C 8D 44 24 08 48 89 D9 BE ?? ?? ?? ?? 4C 89 E7 E8 ?? ?? ?? ?? 83 F8 22 75 7F 48 8B 1D ?? ?? ?? ?? 48 8B 2D ?? ?? ?? ?? 48 01 DB 48 89 EF 48 89 DE 48 89 1D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 85 C0 48 89 C2 75 B4 48 89 EF E8 ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? 48 C7 05 ?? ?? ?? ?? 00 00 00 00 64 C7 00 0C 00 00 00 48 C7 44 24 08 00 00 00 00 83 3D ?? ?? ?? ?? 00 74 0B F0 FF 0D ?? ?? ?? ?? 75 71 EB 08 FF 0D ?? ?? ?? ?? 75 67 48 8B 44 24 08 48 83 C4 10 5B 5D 41 5C C3 48 83 3D ?? ?? ?? ?? 00 75 CC EB C1 BF 00 04 00 00 48 C7 05 ?? ?? ?? ?? 00 04 00 00 E8 ?? ?? ?? ?? 48 85 C0 48 89 C2 48 89 05 ?? ?? ?? ?? 74 9D BB 00 04 00 00 E9 2D FF FF FF }
	condition:
		$1
}

rule file_258_0_0 {
	meta:
		name = "timerfd_settime"
		size = 23
		refs = "0012 __syscall_error"
	strings:
		$1 = { 49 89 CA B8 1E 01 00 00 0F 05 48 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_259_0_0 {
	meta:
		name = "init_module"
		size = 23
		refs = "0012 __syscall_error"
	strings:
		$1 = { 49 89 CA B8 AF 00 00 00 0F 05 48 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_260_0_0 {
	meta:
		name = "print_errno_message"
		size = 45
		refs = "0010 __strerror_r 0021 __fxprintf"
	strings:
		$1 = { 48 81 EC 08 04 00 00 BA 00 04 00 00 48 89 E6 E8 ?? ?? ?? ?? BE ?? ?? ?? ?? 48 89 C2 31 FF 31 C0 E8 ?? ?? ?? ?? 48 81 C4 08 04 00 00 C3 }
	condition:
		$1
}

rule file_260_1_0 {
	meta:
		name = "error_tail"
		size = 481
		refs = "001a stderr 003d strlen 00af __mbsrtowcs 00cd __vfwprintf 00da free 00e3 error_message_count 00f6 __fxprintf 0102 _IO_fflush 015a vfprintf 017a __libc_alloca_cutoff 019a realloc 01c6 fputws_unlocked 01dd exit"
	strings:
		$1 = { 55 48 89 E5 41 57 41 56 41 55 41 54 49 89 D4 53 48 83 EC 38 89 7D B8 48 8B 3D ?? ?? ?? ?? 48 89 4D B0 89 75 BC 8B 8F C0 00 00 00 85 C9 0F 8E 1F 01 00 00 48 89 D7 45 31 F6 45 31 FF E8 ?? ?? ?? ?? BB 10 00 00 00 4C 8D 68 01 EB 1A 0F 1F 40 00 48 B8 FE FF FF FF FF FF FF 7F 49 39 C5 0F 87 BD 00 00 00 4D 01 ED 4A 8D 34 AD 00 00 00 00 48 81 FE 00 10 00 00 0F 87 F7 00 00 00 48 8D 46 1E 31 D2 48 F7 F3 48 C1 E0 04 48 29 C4 4C 8D 7C 24 0F 49 83 E7 F0 48 8D 4D C0 48 8D 75 C8 4C 89 EA 4C 89 FF 48 C7 45 C0 00 00 00 00 4C 89 65 C8 E8 ?? ?? ?? ?? 49 39 C5 74 98 48 83 F8 FF 74 62 48 8B 55 B0 48 8B 3D ?? ?? ?? ?? 4C 89 FE E8 ?? ?? ?? ?? 45 84 F6 74 08 4C 89 FF E8 ?? ?? ?? ?? 8B 55 BC 83 05 ?? ?? ?? ?? 01 85 D2 75 5C 31 FF BE ?? ?? ?? ?? 31 C0 E8 ?? ?? ?? ?? 48 8B 3D ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 B8 85 C0 0F 85 C8 00 00 00 48 8D 65 D8 5B 41 5C 41 5D 41 5E 41 5F 5D C3 45 84 F6 75 3E 48 8B 55 B0 48 8B 3D ?? ?? ?? ?? BE ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 BC 83 05 ?? ?? ?? ?? 01 85 D2 74 A4 8B 7D BC E8 80 FE FF FF EB 9A 48 8B 55 B0 4C 89 E6 E8 ?? ?? ?? ?? E9 7B FF FF FF 4C 89 FF E8 ?? ?? ?? ?? 0F 1F 44 00 00 EB B3 48 89 F7 48 89 75 A8 E8 ?? ?? ?? ?? 85 C0 48 8B 75 A8 0F 85 F1 FE FF FF 45 84 F6 B8 00 00 00 00 4C 0F 44 F8 4C 89 FF E8 ?? ?? ?? ?? 48 85 C0 74 0E 49 89 C7 41 BE 01 00 00 00 E9 E3 FE FF FF 4C 89 FF E8 ?? ?? ?? ?? 48 8B 35 ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 65 D8 5B 41 5C 41 5D 41 5E 41 5F 5D C3 8B 7D B8 E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_260_2_0 {
	meta:
		name = "__error"
		size = 314
		refs = "006b pthread_setcancelstate 008e stdout 0093 _IO_fflush 009a error_print_progname 0123 program_invocation_name 0131 __fxprintf"
	strings:
		$1 = { 48 89 6C 24 E8 4C 89 64 24 F0 89 FD 48 89 5C 24 E0 4C 89 6C 24 F8 48 81 EC F8 00 00 00 84 C0 41 89 F4 48 89 4C 24 38 4C 89 44 24 40 4C 89 4C 24 48 74 37 0F 29 44 24 50 0F 29 4C 24 60 0F 29 54 24 70 0F 29 9C 24 80 00 00 00 0F 29 A4 24 90 00 00 00 0F 29 AC 24 A0 00 00 00 0F 29 B4 24 B0 00 00 00 0F 29 BC 24 C0 00 00 00 BB ?? ?? ?? ?? 49 89 D5 48 85 DB C7 44 24 04 00 00 00 00 74 0C 48 8D 74 24 04 BF 01 00 00 00 FF D3 48 8B 3D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? 48 85 C0 74 7D FF D0 48 8D 84 24 00 01 00 00 48 8D 4C 24 08 4C 89 EA 44 89 E6 89 EF C7 44 24 08 18 00 00 00 48 89 44 24 10 48 8D 44 24 20 C7 44 24 0C 30 00 00 00 48 89 44 24 18 E8 32 FD FF FF 48 85 DB 74 0B 8B 7C 24 04 31 F6 E8 ?? ?? ?? ?? 48 8B 9C 24 D8 00 00 00 48 8B AC 24 E0 00 00 00 4C 8B A4 24 E8 00 00 00 4C 8B AC 24 F0 00 00 00 48 81 C4 F8 00 00 00 C3 66 2E 0F 1F 84 00 00 00 00 00 48 8B 15 ?? ?? ?? ?? BE ?? ?? ?? ?? 31 FF 31 C0 E8 ?? ?? ?? ?? E9 6B FF FF FF }
	condition:
		$1
}

rule file_260_3_0 {
	meta:
		name = "__error_at_line"
		size = 458
		refs = "0075 error_one_per_line 0098 pthread_setcancelstate 00b9 stdout 00be _IO_fflush 00c5 error_print_progname 00ef __fxprintf 019a strcmp 01b3 program_invocation_name"
	strings:
		$1 = { 48 89 5C 24 D0 48 89 6C 24 D8 48 89 D3 4C 89 6C 24 E8 4C 89 74 24 F0 41 89 FD 4C 89 64 24 E0 4C 89 7C 24 F8 48 81 EC 08 01 00 00 84 C0 41 89 F6 89 CD 4C 89 4C 24 48 74 37 0F 29 44 24 50 0F 29 4C 24 60 0F 29 54 24 70 0F 29 9C 24 80 00 00 00 0F 29 A4 24 90 00 00 00 0F 29 AC 24 A0 00 00 00 0F 29 B4 24 B0 00 00 00 0F 29 BC 24 C0 00 00 00 4D 89 C7 8B 35 ?? ?? ?? ?? 85 F6 74 19 39 2D ?? ?? ?? ?? 0F 84 EF 00 00 00 48 89 1D ?? ?? ?? ?? 89 2D ?? ?? ?? ?? 41 BC ?? ?? ?? ?? C7 44 24 04 00 00 00 00 4D 85 E4 74 0D 48 8D 74 24 04 BF 01 00 00 00 41 FF D4 48 8B 3D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? 48 85 C0 0F 84 DE 00 00 00 FF D0 48 85 DB B8 ?? ?? ?? ?? BE ?? ?? ?? ?? 48 0F 44 F0 89 E9 31 FF 48 89 DA 31 C0 E8 ?? ?? ?? ?? 48 8D 84 24 10 01 00 00 48 8D 4C 24 08 4C 89 FA 44 89 F6 44 89 EF C7 44 24 08 28 00 00 00 48 89 44 24 10 48 8D 44 24 20 C7 44 24 0C 30 00 00 00 48 89 44 24 18 E8 A3 FB FF FF 4D 85 E4 74 0B 8B 7C 24 04 31 F6 E8 ?? ?? ?? ?? 48 8B 9C 24 D8 00 00 00 48 8B AC 24 E0 00 00 00 4C 8B A4 24 E8 00 00 00 4C 8B AC 24 F0 00 00 00 4C 8B B4 24 F8 00 00 00 4C 8B BC 24 00 01 00 00 48 81 C4 08 01 00 00 C3 0F 1F 00 48 8B 3D ?? ?? ?? ?? 48 39 FB 74 B9 48 85 FF 0F 84 FC FE FF FF 48 85 DB 0F 84 F3 FE FF FF 48 89 DE E8 ?? ?? ?? ?? 85 C0 74 9B E9 E2 FE FF FF 66 0F 1F 84 00 00 00 00 00 48 8B 15 ?? ?? ?? ?? BE ?? ?? ?? ?? 31 FF 31 C0 E8 ?? ?? ?? ?? E9 0A FF FF FF }
	condition:
		$1
}

rule file_261_0_0 {
	meta:
		name = "__sched_getparam"
		size = 20
		refs = "000f __syscall_error"
	strings:
		$1 = { B8 8F 00 00 00 0F 05 48 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_262_0_0 {
	meta:
		name = "object_compare"
		size = 50
	strings:
		$1 = { 48 8B 56 08 48 8B 4F 08 31 C0 48 39 D1 0F 92 C2 0F 97 C0 0F B6 D2 29 D0 75 16 48 8B 16 48 8B 0F 31 C0 48 39 D1 0F 92 C2 0F 97 C0 0F B6 D2 29 D0 F3 C3 }
	condition:
		$1
}

rule file_262_1_0 {
	meta:
		name = "add_object.isra.1"
		size = 111
		refs = "0022 malloc 0047 __tsearch"
	strings:
		$1 = { 48 89 5C 24 E8 48 89 6C 24 F0 48 89 FB 4C 89 64 24 F8 BF 10 00 00 00 48 83 EC 18 48 89 F5 49 89 D4 E8 ?? ?? ?? ?? 48 85 C0 74 3D 48 8B 55 00 48 8D 73 50 48 89 C7 48 89 10 49 8B 14 24 48 89 50 08 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 F8 01 19 C0 48 8B 1C 24 48 8B 6C 24 08 4C 8B 64 24 10 48 83 C4 18 C3 0F 1F 40 00 B8 FF FF FF FF EB E2 }
	condition:
		$1
}

rule file_262_2_0 {
	meta:
		name = "process_entry"
		size = 786
		refs = "0059 mempcpy 0090 __fxstatat 011c realloc 0172 __tfind 01dc __lxstat 01f3 __libc_errno 0269 __xstat"
	strings:
		$1 = { 48 89 5C 24 D8 48 89 6C 24 E0 48 89 FB 4C 89 64 24 E8 4C 89 6C 24 F0 48 89 D5 4C 89 74 24 F8 48 81 EC C8 00 00 00 80 3A 2E 49 89 F5 49 89 CC 45 89 C6 0F 84 58 01 00 00 48 63 7B 28 4A 8D 74 27 02 48 3B 73 20 0F 87 C5 00 00 00 48 8B 43 18 48 01 C7 48 89 EE 4C 89 E2 E8 ?? ?? ?? ?? C6 00 00 41 8B 75 08 83 FE FF 0F 84 4B 01 00 00 44 8B 43 30 4C 8D 64 24 10 48 89 EA BF 01 00 00 00 4C 89 E1 41 83 E0 01 41 F7 D8 41 81 E0 00 01 00 00 E8 ?? ?? ?? ?? 85 C0 0F 88 54 01 00 00 8B 44 24 28 8B 53 30 B9 01 00 00 00 25 00 F0 00 00 3D 00 40 00 00 74 0E 3D 00 A0 00 00 B9 04 00 00 00 74 02 31 C9 F6 C2 02 74 79 31 C0 48 8B 73 48 48 39 74 24 10 74 6C 0F 1F 40 00 48 8B 9C 24 A0 00 00 00 48 8B AC 24 A8 00 00 00 4C 8B A4 24 B0 00 00 00 4C 8B AC 24 B8 00 00 00 4C 8B B4 24 C0 00 00 00 48 81 C4 C8 00 00 00 C3 0F 1F 84 00 00 00 00 00 48 8B 7B 18 48 01 F6 48 89 73 20 E8 ?? ?? ?? ?? 48 85 C0 0F 84 DF 01 00 00 48 89 43 18 48 63 7B 28 E9 19 FF FF FF 66 2E 0F 1F 84 00 00 00 00 00 83 F9 01 0F 85 97 01 00 00 83 E2 01 0F 85 76 01 00 00 48 8B 44 24 10 48 8D 73 50 BA ?? ?? ?? ?? 48 89 E7 48 89 04 24 48 8B 44 24 18 48 89 44 24 08 E8 ?? ?? ?? ?? 48 85 C0 0F 84 31 01 00 00 90 31 C0 E9 51 FF FF FF 66 0F 1F 84 00 00 00 00 00 0F B6 42 01 84 C0 74 E8 3C 2E 0F 85 98 FE FF FF 80 7A 02 00 0F 85 8E FE FF FF 31 C0 E9 27 FF FF FF 0F 1F 80 00 00 00 00 8B 43 30 A8 04 75 04 48 8B 6B 18 4C 8D 64 24 10 A8 01 48 89 EE BF 01 00 00 00 4C 89 E2 0F 84 8D 00 00 00 E8 ?? ?? ?? ?? 85 C0 0F 89 B4 FE FF FF 0F 1F 84 00 00 00 00 00 48 8B 05 ?? ?? ?? ?? 64 8B 10 83 FA 02 74 0E 83 FA 0D B8 FF FF FF FF 0F 85 CB FE FF FF 8B 53 30 F6 C2 01 75 63 41 83 FE 0A 0F 84 CA 00 00 00 41 8B 75 08 83 FE FF 0F 84 C7 00 00 00 41 B8 00 01 00 00 4C 89 E1 48 89 EA BF 01 00 00 00 E8 ?? ?? ?? ?? 85 C0 75 32 8B 44 24 28 25 00 F0 00 00 3D 00 A0 00 00 75 22 8B 53 30 B9 06 00 00 00 E9 5F FE FF FF 0F 1F 44 00 00 E8 ?? ?? ?? ?? E9 22 FE FF FF 66 0F 1F 44 00 00 BA 0C 00 00 00 48 8B 43 38 48 8D 4B 28 48 8B 7B 18 4C 89 E6 8B 14 10 FF 53 40 F6 43 30 10 0F 84 3C FE FF FF 83 F8 02 0F 85 33 FE FF FF E9 D6 FE FF FF 66 0F 1F 44 00 00 49 8D 54 24 08 4C 89 E6 48 89 DF E8 D0 FC FF FF 85 C0 75 CE 0F 1F 40 00 4C 89 EA 4C 89 E6 48 89 DF E8 4A 00 00 00 EB BA 0F 1F 84 00 00 00 00 00 48 63 D1 48 C1 E2 02 EB 94 B9 06 00 00 00 E9 CF FD FF FF 4C 89 E2 48 89 EE BF 01 00 00 00 E8 ?? ?? ?? ?? E9 3A FF FF FF B8 FF FF FF FF E9 C6 FD FF FF }
	condition:
		$1
}

rule file_262_3_0 {
	meta:
		name = "ftw_dir"
		size = 1554
		refs = "005a malloc 0088 strlen 00bd realloc 00dd mempcpy 00ea __readdir64 012f __closedir 0193 __openat64_nocancel 01ae __fdopendir 0214 __rawmemchr 029c __libc_errno 0360 __fchdir 037d __chdir 03a0 __opendir 03f7 free 05ca __assert_fail"
	strings:
		$1 = { 41 57 41 56 49 89 FE 41 55 41 54 55 53 48 83 EC 58 8B 47 28 48 C7 44 24 10 00 00 00 00 48 89 54 24 18 48 89 74 24 28 89 44 24 24 48 89 D0 48 83 C0 08 48 85 D2 48 0F 44 44 24 10 48 8B 57 08 48 89 44 24 10 48 8B 07 48 8B 1C D0 48 85 DB 0F 84 13 01 00 00 BF 00 04 00 00 E8 ?? ?? ?? ?? 48 85 C0 49 89 C7 0F 84 4E 03 00 00 48 8B 1B 41 BD 00 04 00 00 48 89 5C 24 08 31 DB EB 68 0F 1F 40 00 4C 8D 60 13 4C 89 E7 E8 ?? ?? ?? ?? 48 8D 2C 18 48 89 C2 48 8D 45 02 4C 39 E8 72 35 48 8D 04 12 B9 00 04 00 00 4C 89 FF 48 89 14 24 48 3D 00 04 00 00 48 0F 42 C1 49 01 C5 4C 89 EE E8 ?? ?? ?? ?? 48 85 C0 48 8B 14 24 0F 84 1A 03 00 00 49 89 C7 49 8D 3C 1F 4C 89 E6 48 8D 5D 01 E8 ?? ?? ?? ?? C6 00 00 48 8B 7C 24 08 E8 ?? ?? ?? ?? 48 85 C0 75 8D 41 C6 04 1F 00 49 8B 56 08 48 8D 73 01 49 8B 06 4C 89 FF 48 8B 2C D0 E8 ?? ?? ?? ?? 49 8B 56 08 48 89 45 10 49 8B 06 48 8B 04 D0 48 83 78 10 00 0F 84 BF 02 00 00 48 8B 7C 24 08 E8 ?? ?? ?? ?? 49 8B 56 08 49 8B 06 48 8D 04 D0 48 8B 08 48 C7 01 00 00 00 00 48 8B 08 C7 41 08 FF FF FF FF 48 C7 00 00 00 00 00 49 8B 06 48 83 3C D0 00 0F 85 67 04 00 00 48 83 7C 24 10 00 0F 84 1D 02 00 00 48 8B 4C 24 10 8B 39 83 FF FF 0F 84 0D 02 00 00 49 63 76 28 31 C9 BA 00 08 01 00 49 03 76 18 E8 ?? ?? ?? ?? 83 F8 FF 89 C3 48 C7 44 24 30 00 00 00 00 0F 84 0D 02 00 00 89 C7 E8 ?? ?? ?? ?? 48 85 C0 48 89 44 24 30 0F 84 E0 03 00 00 8B 00 49 8B 16 48 8D 4C 24 30 48 C7 44 24 40 00 00 00 00 89 44 24 38 49 8B 46 08 48 89 0C C2 48 83 C0 01 49 3B 46 10 49 89 46 08 0F 84 1F 03 00 00 41 8B 46 30 A8 08 0F 84 83 02 00 00 A8 04 0F 85 A3 02 00 00 41 83 46 2C 01 49 8B 5E 18 31 F6 48 89 DF E8 ?? ?? ?? ?? 48 39 C3 0F 84 94 03 00 00 80 78 FF 2F 74 0B C6 00 2F 49 8B 5E 18 48 83 C0 01 48 29 D8 41 89 46 28 0F 1F 80 00 00 00 00 48 8B 7C 24 30 48 85 FF 0F 84 CF 02 00 00 E8 ?? ?? ?? ?? 48 85 C0 48 89 C3 74 2A 48 8D 6B 13 48 89 EF E8 ?? ?? ?? ?? 44 0F B6 43 12 48 8D 74 24 30 48 89 C1 48 89 EA 4C 89 F7 E8 61 FA FF FF 85 C0 89 C3 74 BB 48 8B 7C 24 30 48 85 FF 0F 84 6D 03 00 00 48 83 7C 24 40 00 48 8B 2D ?? ?? ?? ?? 64 44 8B 65 00 0F 85 3C 03 00 00 E8 ?? ?? ?? ?? 49 8B 56 08 C7 44 24 38 FF FF FF FF 64 44 89 65 00 48 8D 42 FF 48 85 D2 49 89 46 08 75 0C 49 8B 46 10 48 83 E8 01 49 89 46 08 49 8B 16 48 C7 04 C2 00 00 00 00 41 F6 46 30 10 74 09 83 FB 03 0F 84 44 01 00 00 49 63 46 28 49 8B 56 18 C6 44 02 FF 00 8B 44 24 24 41 83 6E 2C 01 85 DB 41 89 46 28 0F 84 3C 01 00 00 48 83 7C 24 18 00 0F 84 E6 00 00 00 41 8B 46 30 A8 04 0F 84 DA 00 00 00 85 DB 74 1D A8 10 0F 84 CE 00 00 00 83 FB 01 66 90 0F 84 C3 00 00 00 83 FB FF 0F 84 BA 00 00 00 90 48 8B 54 24 18 48 8B 02 48 85 C0 74 0F 8B 38 E8 ?? ?? ?? ?? 85 C0 0F 84 9D 00 00 00 41 83 7E 28 01 0F 84 12 02 00 00 BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 0F 89 80 00 00 00 EB 79 0F 1F 44 00 00 41 F6 46 30 04 0F 85 85 00 00 00 49 8B 7E 18 E8 ?? ?? ?? ?? 48 89 44 24 30 48 85 C0 0F 85 0E FE FF FF 66 0F 1F 44 00 00 48 8B 05 ?? ?? ?? ?? 64 8B 18 83 FB 0D 75 3D 49 8D 4E 28 49 8B 7E 18 BA 02 00 00 00 48 8B 74 24 28 41 FF 56 40 89 C3 EB 28 0F 1F 80 00 00 00 00 48 8B 2D ?? ?? ?? ?? 4C 89 FF 64 8B 5D 00 E8 ?? ?? ?? ?? 83 FB 0D 64 89 5D 00 74 C3 BB FF FF FF FF 48 83 C4 58 89 D8 5B 5D 41 5C 41 5D 41 5E 41 5F C3 66 0F 1F 44 00 00 49 63 7E 28 B8 ?? ?? ?? ?? 49 03 7E 18 80 3F 00 48 0F 44 F8 E9 66 FF FF FF 49 63 46 28 49 8B 56 18 C6 44 02 FF 00 8B 4C 24 24 41 83 6E 2C 01 41 89 4E 28 31 DB 41 F6 46 30 08 0F 84 B7 FE FF FF 49 8D 4E 28 49 8B 7E 18 BA 05 00 00 00 48 8B 74 24 28 41 FF 56 40 89 C3 E9 9A FE FF FF 0F 1F 00 49 8D 4E 28 49 8B 7E 18 BA 01 00 00 00 48 8B 74 24 28 41 FF 56 40 85 C0 89 C3 75 25 41 8B 46 30 E9 58 FD FF FF 0F 1F 00 48 8B 44 24 30 8B 38 E8 ?? ?? ?? ?? 85 C0 0F 89 49 FD FF FF BB FF FF FF FF 48 8B 2D ?? ?? ?? ?? 48 8B 7C 24 30 64 44 8B 65 00 E8 ?? ?? ?? ?? 49 8B 56 08 64 44 89 65 00 48 8D 42 FF 48 85 D2 49 89 46 08 75 0C 49 8B 46 10 48 83 E8 01 49 89 46 08 49 8B 16 48 C7 04 C2 00 00 00 00 E9 00 FF FF FF 0F 1F 80 00 00 00 00 49 C7 46 08 00 00 00 00 E9 D4 FC FF FF 4C 8B 64 24 40 41 80 3C 24 00 75 0D E9 83 00 00 00 66 90 80 7D 01 00 74 30 31 F6 4C 89 E7 E8 ?? ?? ?? ?? 48 8D 74 24 30 48 89 C1 45 31 C0 4C 29 E1 4C 89 E2 4C 89 F7 48 89 C5 E8 84 F7 FF FF 85 C0 89 C3 4C 8D 65 01 74 CA 4C 8B 64 24 40 48 8B 2D ?? ?? ?? ?? 4C 89 E7 64 44 8B 6D 00 E8 ?? ?? ?? ?? 64 44 89 6D 00 E9 5C FD FF FF BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 0F 89 6E FE FF FF E9 64 FE FF FF 48 63 FB B0 03 0F 05 48 8B 44 24 30 E9 F8 FD FF FF 31 DB EB B6 B9 ?? ?? ?? ?? BA 1A 02 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? B9 ?? ?? ?? ?? BA 52 01 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? B9 ?? ?? ?? ?? BA 2C 02 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 DB 4C 8B 64 24 40 0F 85 5E FF FF FF E9 10 FF FF FF }
	condition:
		$1
}

rule file_262_4_0 {
	meta:
		name = "ftw_startup"
		size = 1267
		refs = "006a memset 0072 strlen 0090 malloc 00b2 stpcpy 014c __libc_errno 0184 __lxstat 01bf __xstat 02b4 __chdir 02c0 free 02dd __open 0384 __fchdir 03a4 __tdestroy 03e5 __getcwd"
	strings:
		$1 = { 55 48 89 E5 41 57 41 56 41 55 41 54 53 48 81 EC 18 01 00 00 80 3F 00 0F 84 1B 04 00 00 85 C9 49 89 D5 BA 01 00 00 00 0F 4F D1 49 89 FE 41 89 F4 48 63 D2 31 F6 44 89 C3 48 89 95 F0 FE FF FF 48 C1 E2 03 48 C7 85 E8 FE FF FF 00 00 00 00 48 8D 42 1E 48 83 E0 F0 48 29 C4 48 8D 7C 24 0F 48 83 E7 F0 48 89 BD E0 FE FF FF E8 ?? ?? ?? ?? 4C 89 F7 E8 ?? ?? ?? ?? 48 01 C0 BF 00 10 00 00 48 3D 00 10 00 00 48 0F 43 F8 48 89 BD 00 FF FF FF E8 ?? ?? ?? ?? 48 85 C0 48 89 85 F8 FE FF FF 0F 84 44 04 00 00 4C 89 F6 48 89 C7 48 89 85 C8 FE FF FF E8 ?? ?? ?? ?? 4C 8B 85 C8 FE FF FF 48 89 C1 49 8D 40 01 48 39 C1 77 10 EB 14 0F 1F 44 00 00 48 83 E9 01 48 39 C1 74 06 80 79 FF 2F 74 F1 49 39 C8 C6 01 00 C7 85 0C FF FF FF 00 00 00 00 72 10 EB 14 0F 1F 44 00 00 48 83 E9 01 4C 39 C1 74 06 80 79 FF 2F 75 F1 4C 29 C1 B8 ?? ?? ?? ?? 45 85 E4 BA ?? ?? ?? ?? 89 8D 08 FF FF FF 89 9D 10 FF FF FF 48 0F 44 C2 F6 C3 04 4C 89 AD 20 FF FF FF 48 89 85 18 FF FF FF 48 C7 85 30 FF FF FF 00 00 00 00 0F 85 87 01 00 00 4C 8B 2D ?? ?? ?? ?? 48 C7 85 D8 FE FF FF 00 00 00 00 41 BE FF FF FF FF 41 89 DC 4C 8D 8D 40 FF FF FF 4C 89 C6 41 83 E4 01 BF 01 00 00 00 4C 89 CA 74 34 4C 89 8D D0 FE FF FF E8 ?? ?? ?? ?? 85 C0 4C 8B 8D D0 FE FF FF 0F 89 91 00 00 00 64 45 8B 7D 00 41 BC FF FF FF FF E9 D3 00 00 00 66 0F 1F 84 00 00 00 00 00 4C 89 85 C8 FE FF FF 4C 89 8D D0 FE FF FF E8 ?? ?? ?? ?? 85 C0 4C 8B 85 C8 FE FF FF 4C 8B 8D D0 FE FF FF 79 53 64 45 8B 7D 00 41 BC FF FF FF FF 41 83 FF 02 0F 85 90 00 00 00 4C 89 CA 4C 89 C6 BF 01 00 00 00 E8 ?? ?? ?? ?? 85 C0 4C 8B 8D D0 FE FF FF 75 70 8B 85 58 FF FF FF 25 00 F0 00 00 3D 00 A0 00 00 75 5E 48 8B 85 18 FF FF FF 8B 50 18 EB 38 0F 1F 44 00 00 8B 85 58 FF FF FF 25 00 F0 00 00 3D 00 40 00 00 0F 84 C2 01 00 00 3D 00 A0 00 00 BA 10 00 00 00 B8 00 00 00 00 48 0F 45 D0 48 8B 85 18 FF FF FF 8B 14 10 48 8D 8D 08 FF FF FF 4C 89 CE 48 8B BD F8 FE FF FF FF 95 20 FF FF FF 41 89 C4 64 45 8B 7D 00 83 E3 10 0F 84 F3 00 00 00 41 8D 44 24 FE 83 F8 01 B8 00 00 00 00 44 0F 46 E0 41 83 FE FF 0F 85 E2 00 00 00 48 83 BD D8 FE FF FF 00 0F 84 EB 00 00 00 48 8B BD D8 FE FF FF E8 ?? ?? ?? ?? 48 8B BD D8 FE FF FF E8 ?? ?? ?? ?? 64 45 89 7D 00 E9 C9 00 00 00 66 90 31 C0 BE 00 00 01 00 BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 F8 FF 41 89 C6 0F 84 DE 00 00 00 48 8B 85 F0 FE FF FF 48 83 F8 01 0F 86 87 01 00 00 4C 8B 2D ?? ?? ?? ?? 48 83 E8 01 48 C7 85 D8 FE FF FF 00 00 00 00 48 89 85 F0 FE FF FF 48 63 85 08 FF FF FF 85 C0 0F 8E 27 01 00 00 83 F8 01 0F 84 69 01 00 00 48 8B 95 F8 FE FF FF 48 8D 44 02 FF 44 0F B6 38 C6 00 00 48 8B BD F8 FE FF FF E8 ?? ?? ?? ?? 41 89 C4 48 63 85 08 FF FF FF 48 8B 95 F8 FE FF FF 44 88 7C 02 FF 45 85 E4 0F 84 E0 00 00 00 64 45 8B 7D 00 41 83 FE FF 0F 84 1E FF FF FF 44 89 F7 E8 ?? ?? ?? ?? 49 63 FE B8 03 00 00 00 0F 05 64 45 89 7D 00 48 8B BD 30 FF FF FF BE ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B BD F8 FE FF FF E8 ?? ?? ?? ?? 64 45 89 7D 00 48 8D 65 D8 44 89 E0 5B 41 5C 41 5D 41 5E 41 5F 5D C3 4C 8B 2D ?? ?? ?? ?? 45 31 E4 64 45 8B 7D 00 41 83 FF 0D 75 B7 31 F6 31 FF E8 ?? ?? ?? ?? 48 85 C0 48 89 85 D8 FE FF FF 0F 85 22 FF FF FF 64 45 8B 7D 00 EB 97 48 8B 85 40 FF FF FF 45 85 E4 48 89 85 28 FF FF FF 0F 84 97 00 00 00 4C 8D BD E0 FE FF FF 4C 89 FF 31 D2 4C 89 CE E8 B5 F5 FF FF 64 45 8B 7D 00 41 89 C4 E9 42 FE FF FF 48 8B 05 ?? ?? ?? ?? 41 BC FF FF FF FF 64 C7 00 02 00 00 00 E9 68 FF FF FF 8B 85 10 FF FF FF 4C 8B 85 F8 FE FF FF 83 E0 04 85 C0 0F 84 F8 FC FF FF 48 63 85 08 FF FF FF 49 01 C0 B8 ?? ?? ?? ?? 41 80 38 00 4C 0F 44 C0 E9 DC FC FF FF 48 C7 85 D8 FE FF FF 00 00 00 00 4C 8B 2D ?? ?? ?? ?? E9 7F FE FF FF BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 41 89 C4 E9 BA FE FF FF 4C 8D BD E0 FE FF FF 49 8D 51 08 4C 89 CE 4C 89 8D D0 FE FF FF 4C 89 FF E8 85 F1 FF FF 85 C0 41 89 C4 4C 8B 8D D0 FE FF FF 0F 85 98 FD FF FF E9 3C FF FF FF 66 0F 1F 44 00 00 41 BC FF FF FF FF E9 C6 FE FF FF }
	condition:
		$1
}

rule file_262_6_0 {
	meta:
		name = "__new_nftw"
		size = 52
		refs = "0023 __libc_errno"
	strings:
		$1 = { 41 89 C8 83 E1 E0 75 18 89 D1 48 89 F2 BE 01 00 00 00 E9 D9 FA FF FF 66 0F 1F 84 00 00 00 00 00 48 8B 05 ?? ?? ?? ?? 64 C7 00 16 00 00 00 B8 FF FF FF FF C3 }
	condition:
		$1
}

rule file_263_0_0 {
	meta:
		name = "pmap_getmaps"
		size = 257
		refs = "0038 __get_socket 0062 clnttcp_create 0080 xdr_pmaplist 009b xdr_void 00ba __close_nocancel 00eb _libc_intl_domainname 00f0 __dcgettext 00fb clnt_perror"
	strings:
		$1 = { 48 89 5C 24 E8 4C 89 64 24 F8 48 89 FB 48 89 6C 24 F0 48 83 EC 48 66 C7 47 02 00 6F 48 C7 44 24 18 00 00 00 00 48 C7 44 24 20 3C 00 00 00 48 C7 44 24 28 00 00 00 00 E8 ?? ?? ?? ?? 48 8D 4C 24 14 41 B9 F4 01 00 00 41 B8 32 00 00 00 BA 02 00 00 00 BE A0 86 01 00 48 89 DF 41 89 C4 89 44 24 14 E8 ?? ?? ?? ?? 48 85 C0 74 44 48 8B 54 24 20 48 89 C5 48 8B 40 08 31 C9 4C 8D 4C 24 18 41 B8 ?? ?? ?? ?? BE 04 00 00 00 48 89 EF 48 89 14 24 48 8B 54 24 28 48 89 54 24 08 BA ?? ?? ?? ?? FF 10 85 C0 75 3B 48 8B 45 08 48 89 EF FF 50 20 41 83 FC FF 74 09 8B 7C 24 14 E8 ?? ?? ?? ?? 66 C7 43 02 00 00 48 8B 44 24 18 48 8B 5C 24 30 48 8B 6C 24 38 4C 8B 64 24 40 48 83 C4 48 C3 0F 1F 00 BA 05 00 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 EF 48 89 C6 E8 ?? ?? ?? ?? EB A4 }
	condition:
		$1
}

rule file_264_0_0 {
	meta:
		name = "fputws_unlocked"
		size = 111
		refs = "001a __wcslen 002a _IO_fwide"
	strings:
		$1 = { 48 89 5C 24 E8 48 89 6C 24 F0 48 89 F3 4C 89 64 24 F8 48 83 EC 18 48 89 FD E8 ?? ?? ?? ?? BE 01 00 00 00 48 89 DF 49 89 C4 E8 ?? ?? ?? ?? 83 F8 01 75 35 48 8B 83 D8 00 00 00 4C 89 E2 48 89 EE 48 89 DF FF 50 38 4C 39 E0 75 1D B8 01 00 00 00 48 8B 1C 24 48 8B 6C 24 08 4C 8B 64 24 10 48 83 C4 18 C3 0F 1F 44 00 00 B8 FF FF FF FF EB E1 }
	condition:
		$1
}

rule file_265_1_0 {
	meta:
		name = "updwtmp_file"
		size = 499
		refs = "002b __open_nocancel 0042 alarm 0082 __sigaction 00c6 __fcntl_nocancel 00d8 __lseek64 010f __write_nocancel 0129 __ftruncate64"
	strings:
		$1 = { 4C 89 6C 24 F0 48 89 5C 24 D8 31 C0 48 89 6C 24 E0 4C 89 64 24 E8 49 89 F5 4C 89 74 24 F8 BE 01 00 00 00 48 81 EC 88 01 00 00 E8 ?? ?? ?? ?? 85 C0 0F 88 B1 01 00 00 31 FF 89 C3 41 BE FF FF FF FF E8 ?? ?? ?? ?? 48 8D 54 24 28 48 8D 74 24 20 41 89 C4 B9 10 00 00 00 31 C0 48 C7 44 24 20 ?? ?? ?? ?? 48 89 D7 48 8D 94 24 C0 00 00 00 C7 84 24 A8 00 00 00 00 00 00 00 F3 48 AB BF 0E 00 00 00 E8 ?? ?? ?? ?? BF 0A 00 00 00 E8 ?? ?? ?? ?? 31 C0 48 89 E2 BE 07 00 00 00 89 DF 48 C7 04 24 00 00 00 00 48 C7 44 24 08 00 00 00 00 48 C7 44 24 10 00 00 00 00 48 C7 44 24 18 00 00 00 00 66 C7 04 24 01 00 E8 ?? ?? ?? ?? 85 C0 78 76 BA 02 00 00 00 31 F6 89 DF E8 ?? ?? ?? ?? 48 BA AB AA AA AA AA AA AA AA 48 89 C5 48 F7 E2 48 C1 EA 08 48 8D 04 52 48 89 EA 48 C1 E0 07 48 29 C2 0F 85 A4 00 00 00 BA 80 01 00 00 4C 89 EE 89 DF E8 ?? ?? ?? ?? 45 31 F6 3D 80 01 00 00 74 10 48 89 EE 89 DF 41 BE FF FF FF FF E8 ?? ?? ?? ?? 48 89 E2 BE 07 00 00 00 89 DF 31 C0 66 C7 04 24 02 00 E8 ?? ?? ?? ?? 31 FF E8 ?? ?? ?? ?? 48 8D B4 24 C0 00 00 00 31 D2 BF 0E 00 00 00 E8 ?? ?? ?? ?? 45 85 E4 75 74 48 63 FB B8 03 00 00 00 0F 05 44 89 F0 48 8B 9C 24 60 01 00 00 48 8B AC 24 68 01 00 00 4C 8B A4 24 70 01 00 00 4C 8B AC 24 78 01 00 00 4C 8B B4 24 80 01 00 00 48 81 C4 88 01 00 00 C3 0F 1F 80 00 00 00 00 48 29 D5 89 DF 48 89 EE E8 ?? ?? ?? ?? 31 F6 BA 02 00 00 00 89 DF E8 ?? ?? ?? ?? 48 85 C0 0F 89 38 FF FF FF E9 5C FF FF FF 0F 1F 80 00 00 00 00 44 89 E7 E8 ?? ?? ?? ?? EB 82 66 0F 1F 44 00 00 41 BE FF FF FF FF E9 7B FF FF FF }
	condition:
		$1
}

rule file_265_2_0 {
	meta:
		name = "setutent_file"
		size = 485
		refs = "0013 __lseek64 003b __libc_utmp_file_name 00a5 __open_nocancel 00bc __have_o_cloexec 00d2 __fcntl_nocancel 0118 __access"
	strings:
		$1 = { 48 83 EC 08 8B 3D ?? ?? ?? ?? 85 FF 78 2A 31 D2 31 F6 E8 ?? ?? ?? ?? 48 C7 05 ?? ?? ?? ?? 00 00 00 00 66 C7 05 ?? ?? ?? ?? FF FF B8 01 00 00 00 48 83 C4 08 C3 0F 1F 00 48 8B 15 ?? ?? ?? ?? B9 0E 00 00 00 BF ?? ?? ?? ?? 48 89 D6 F3 A6 0F 84 BC 00 00 00 B9 0E 00 00 00 BF ?? ?? ?? ?? 48 89 D6 F3 A6 0F 84 CF 00 00 00 BF ?? ?? ?? ?? B9 0F 00 00 00 48 89 D6 F3 A6 0F 84 E2 00 00 00 BF ?? ?? ?? ?? B9 0F 00 00 00 48 89 D6 F3 A6 0F 84 FD 00 00 00 48 89 D7 31 C0 BE 00 00 08 00 C6 05 ?? ?? ?? ?? 00 E8 ?? ?? ?? ?? 83 F8 FF 89 C7 89 05 ?? ?? ?? ?? 0F 84 CE 00 00 00 8B 05 ?? ?? ?? ?? 85 C0 0F 8F 46 FF FF FF 31 D2 31 C0 BE 01 00 00 00 E8 ?? ?? ?? ?? 85 C0 0F 88 E9 00 00 00 8B 0D ?? ?? ?? ?? 85 C9 75 13 89 C2 83 E2 01 83 FA 01 19 C9 83 C9 01 89 0D ?? ?? ?? ?? 85 C9 0F 88 AD 00 00 00 8B 3D ?? ?? ?? ?? E9 00 FF FF FF 66 90 31 F6 BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 BA ?? ?? ?? ?? 0F 84 6A FF FF FF 48 8B 15 ?? ?? ?? ?? E9 1F FF FF FF 0F 1F 00 31 F6 BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 BA ?? ?? ?? ?? 0F 84 42 FF FF FF 48 8B 15 ?? ?? ?? ?? E9 0C FF FF FF 0F 1F 00 31 F6 BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 BA ?? ?? ?? ?? 0F 85 1A FF FF FF 48 8B 15 ?? ?? ?? ?? E9 F9 FE FF FF 0F 1F 00 31 C0 E9 A1 FE FF FF 90 31 F6 BF ?? ?? ?? ?? E8 ?? ?? ?? ?? BA ?? ?? ?? ?? 85 C0 48 0F 44 15 ?? ?? ?? ?? E9 E3 FE FF FF 8B 3D ?? ?? ?? ?? 89 C2 BE 02 00 00 00 83 CA 01 31 C0 E8 ?? ?? ?? ?? 83 F8 FF 0F 85 33 FF FF FF 48 63 3D ?? ?? ?? ?? B8 03 00 00 00 0F 05 31 C0 E9 4B FE FF FF }
	condition:
		$1
}

rule file_265_3_0 {
	meta:
		name = "__utmp_equal"
		size = 111
		refs = "0035 strncmp"
	strings:
		$1 = { 53 0F B7 07 31 DB 83 E8 05 66 83 F8 03 77 31 0F B7 06 83 E8 05 66 83 F8 03 77 25 80 7F 28 00 74 27 80 7E 28 00 74 21 48 83 C6 28 48 83 C7 28 BA 04 00 00 00 E8 ?? ?? ?? ?? 85 C0 74 2B 0F 1F 00 89 D8 5B C3 0F 1F 40 00 48 83 C6 08 48 83 C7 08 BA 20 00 00 00 E8 ?? ?? ?? ?? 85 C0 74 0A 31 DB 89 D8 5B C3 0F 1F 40 00 BB 01 00 00 00 EB D1 }
	condition:
		$1
}

rule file_265_4_0 {
	meta:
		name = "internal_getut_r"
		size = 458
		refs = "0019 alarm 0059 __sigaction 009b __fcntl_nocancel 00df __read_nocancel 019b __libc_errno"
	strings:
		$1 = { 41 55 49 89 D5 41 54 55 48 89 FD 31 FF 53 48 89 F3 48 81 EC 68 01 00 00 E8 ?? ?? ?? ?? 48 8D 74 24 28 48 8D 94 24 C0 00 00 00 41 89 C4 B9 10 00 00 00 31 C0 48 C7 44 24 20 ?? ?? ?? ?? 48 89 F7 48 8D 74 24 20 C7 84 24 A8 00 00 00 00 00 00 00 F3 48 AB BF 0E 00 00 00 E8 ?? ?? ?? ?? BF 0A 00 00 00 E8 ?? ?? ?? ?? 8B 3D ?? ?? ?? ?? 31 C0 48 89 E2 BE 07 00 00 00 48 C7 04 24 00 00 00 00 48 C7 44 24 08 00 00 00 00 48 C7 44 24 10 00 00 00 00 48 C7 44 24 18 00 00 00 00 E8 ?? ?? ?? ?? 85 C0 0F 88 14 01 00 00 0F B7 45 00 8D 50 FF 66 83 FA 01 0F 86 A8 00 00 00 66 83 F8 04 0F 84 9E 00 00 00 66 83 F8 03 0F 84 94 00 00 00 0F 1F 40 00 8B 3D ?? ?? ?? ?? BA 80 01 00 00 48 89 DE E8 ?? ?? ?? ?? 3D 80 01 00 00 0F 85 AA 00 00 00 48 89 EE 48 89 DF 48 81 05 ?? ?? ?? ?? 80 01 00 00 E8 8C FE FF FF 85 C0 74 C8 31 DB 8B 3D ?? ?? ?? ?? 48 89 E2 BE 07 00 00 00 31 C0 66 C7 04 24 02 00 E8 ?? ?? ?? ?? 31 FF E8 ?? ?? ?? ?? 48 8D B4 24 C0 00 00 00 31 D2 BF 0E 00 00 00 E8 ?? ?? ?? ?? 45 85 E4 74 08 44 89 E7 E8 ?? ?? ?? ?? 48 81 C4 68 01 00 00 89 D8 5B 5D 41 5C 41 5D C3 0F 1F 00 8B 3D ?? ?? ?? ?? BA 80 01 00 00 48 89 DE E8 ?? ?? ?? ?? 3D 80 01 00 00 75 1E 0F B7 03 48 81 05 ?? ?? ?? ?? 80 01 00 00 66 39 45 00 75 D2 E9 75 FF FF FF 0F 1F 44 00 00 48 8B 05 ?? ?? ?? ?? 48 C7 05 ?? ?? ?? ?? FF FF FF FF BB FF FF FF FF 64 C7 00 03 00 00 00 E9 4F FF FF FF 41 C6 45 00 01 BB FF FF FF FF E9 5B FF FF FF }
	condition:
		$1
}

rule file_265_5_0 {
	meta:
		name = "pututline_file"
		size = 1477
		refs = "0046 __libc_utmp_file_name 00a9 __open_nocancel 00ba __have_o_cloexec 00d4 __lseek64 00f7 __dup2 017b alarm 01b8 __sigaction 0202 __fcntl_nocancel 0246 __write_nocancel 040b __ftruncate64 0420 __access 05ac __assert_fail 05b3 __libc_errno"
	strings:
		$1 = { 48 89 5C 24 D0 48 89 6C 24 D8 4C 89 64 24 E0 4C 89 6C 24 E8 4C 89 74 24 F0 4C 89 7C 24 F8 48 81 EC 28 03 00 00 8B 0D ?? ?? ?? ?? 85 C9 0F 88 64 05 00 00 80 3D ?? ?? ?? ?? 00 48 89 FB 0F 85 D1 00 00 00 48 8B 15 ?? ?? ?? ?? B9 0E 00 00 00 BF ?? ?? ?? ?? 48 89 D6 F3 A6 0F 84 B9 03 00 00 B9 0E 00 00 00 BF ?? ?? ?? ?? 48 89 D6 F3 A6 0F 84 44 04 00 00 BF ?? ?? ?? ?? B9 0F 00 00 00 48 89 D6 F3 A6 0F 84 67 04 00 00 BF ?? ?? ?? ?? B9 0F 00 00 00 48 89 D6 F3 A6 0F 84 7A 04 00 00 31 C0 BE 02 00 08 00 48 89 D7 E8 ?? ?? ?? ?? 83 F8 FF 89 C5 0F 84 D8 04 00 00 8B 15 ?? ?? ?? ?? 85 D2 0F 8E 7A 03 00 00 8B 3D ?? ?? ?? ?? 31 F6 BA 01 00 00 00 E8 ?? ?? ?? ?? 31 D2 48 89 C6 89 EF E8 ?? ?? ?? ?? 48 83 F8 FF 0F 84 52 04 00 00 8B 35 ?? ?? ?? ?? 89 EF E8 ?? ?? ?? ?? 85 C0 0F 88 3D 04 00 00 48 63 FD B8 03 00 00 00 0F 05 C6 05 ?? ?? ?? ?? 01 48 83 3D ?? ?? ?? ?? 00 7E 25 0F B7 05 ?? ?? ?? ?? 66 3B 03 0F 84 B2 01 00 00 48 89 DE BF ?? ?? ?? ?? E8 85 FC FF FF 85 C0 0F 85 B0 01 00 00 48 8D 54 24 0F 48 8D B4 24 70 01 00 00 48 89 DF C6 44 24 0F 00 E8 D3 FC FF FF 80 7C 24 0F 00 41 89 C7 0F 85 45 04 00 00 31 FF 4C 8D A4 24 D0 00 00 00 4C 8D 74 24 10 E8 ?? ?? ?? ?? 48 8D 54 24 38 48 8D 74 24 30 41 89 C5 B9 10 00 00 00 31 C0 48 C7 44 24 30 ?? ?? ?? ?? 48 89 D7 4C 89 E2 C7 84 24 B8 00 00 00 00 00 00 00 F3 48 AB BF 0E 00 00 00 31 ED E8 ?? ?? ?? ?? BF 0A 00 00 00 E8 ?? ?? ?? ?? 8B 3D ?? ?? ?? ?? 31 C0 4C 89 F2 BE 07 00 00 00 48 C7 44 24 10 00 00 00 00 48 C7 44 24 18 00 00 00 00 48 C7 44 24 20 00 00 00 00 48 C7 44 24 28 00 00 00 00 66 C7 44 24 10 01 00 E8 ?? ?? ?? ?? 85 C0 78 6A 45 85 FF 0F 88 8D 01 00 00 48 8B 35 ?? ?? ?? ?? 8B 3D ?? ?? ?? ?? 31 D2 31 ED 48 81 EE 80 01 00 00 48 89 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 3D ?? ?? ?? ?? BA 80 01 00 00 48 89 DE E8 ?? ?? ?? ?? 3D 80 01 00 00 0F 84 33 01 00 00 0F 1F 00 8B 3D ?? ?? ?? ?? 4C 89 F2 BE 07 00 00 00 31 C0 66 C7 44 24 10 02 00 E8 ?? ?? ?? ?? 31 FF E8 ?? ?? ?? ?? 31 D2 4C 89 E6 BF 0E 00 00 00 E8 ?? ?? ?? ?? 45 85 ED 75 41 48 89 E8 48 8B 9C 24 F8 02 00 00 48 8B AC 24 00 03 00 00 4C 8B A4 24 08 03 00 00 4C 8B AC 24 10 03 00 00 4C 8B B4 24 18 03 00 00 4C 8B BC 24 20 03 00 00 48 81 C4 28 03 00 00 C3 66 0F 1F 44 00 00 44 89 EF E8 ?? ?? ?? ?? EB B5 66 0F 1F 44 00 00 8D 50 FF 66 83 FA 01 76 0A 66 83 F8 04 0F 85 ED 01 00 00 31 FF 31 ED 4C 8D A4 24 D0 00 00 00 E8 ?? ?? ?? ?? 48 8D 54 24 38 48 8D 74 24 30 41 89 C5 B9 20 00 00 00 89 E8 4C 8D 74 24 10 48 89 D7 4C 89 E2 48 C7 44 24 30 ?? ?? ?? ?? F3 AB BF 0E 00 00 00 C7 84 24 B8 00 00 00 00 00 00 00 E8 ?? ?? ?? ?? BF 0A 00 00 00 E8 ?? ?? ?? ?? 89 E8 B9 08 00 00 00 4C 89 F7 F3 AB 8B 3D ?? ?? ?? ?? 4C 89 F2 BE 07 00 00 00 66 C7 44 24 10 01 00 E8 ?? ?? ?? ?? 85 C0 0F 89 98 FE FF FF 31 ED E9 F2 FE FF FF 66 0F 1F 44 00 00 48 81 05 ?? ?? ?? ?? 80 01 00 00 48 89 DD E9 BD FE FF FF 0F 1F 44 00 00 8B 3D ?? ?? ?? ?? 31 F6 BA 02 00 00 00 E8 ?? ?? ?? ?? 48 BA AB AA AA AA AA AA AA AA 48 89 C6 48 89 05 ?? ?? ?? ?? 48 F7 E2 48 C1 EA 08 48 8D 04 52 48 89 F2 48 C1 E0 07 48 29 C2 0F 85 77 01 00 00 8B 3D ?? ?? ?? ?? BA 80 01 00 00 48 89 DE E8 ?? ?? ?? ?? 3D 80 01 00 00 74 8D 48 8B 35 ?? ?? ?? ?? 8B 3D ?? ?? ?? ?? 31 ED E8 ?? ?? ?? ?? E9 44 FE FF FF 0F 1F 40 00 31 F6 BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 BA ?? ?? ?? ?? 0F 84 6D FC FF FF 48 8B 15 ?? ?? ?? ?? E9 22 FC FF FF 0F 1F 00 8B 3D ?? ?? ?? ?? 31 D2 31 C0 BE 01 00 00 00 E8 ?? ?? ?? ?? 85 C0 78 3C 8B 0D ?? ?? ?? ?? 85 C9 75 13 89 C2 83 E2 01 83 FA 01 19 C9 83 C9 01 89 0D ?? ?? ?? ?? 85 C9 0F 89 49 FC FF FF 8B 3D ?? ?? ?? ?? 89 C2 BE 02 00 00 00 83 CA 01 31 C0 E8 ?? ?? ?? ?? 83 F8 FF 0F 85 29 FC FF FF 48 63 3D ?? ?? ?? ?? B8 03 00 00 00 0F 05 31 ED E9 DD FD FF FF 66 0F 1F 44 00 00 31 F6 BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 BA ?? ?? ?? ?? 0F 84 CD FB FF FF 48 8B 15 ?? ?? ?? ?? E9 97 FB FF FF 0F 1F 00 66 83 F8 03 0F 85 44 FC FF FF E9 04 FE FF FF 90 31 F6 BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 BA ?? ?? ?? ?? 0F 85 95 FB FF FF 48 8B 15 ?? ?? ?? ?? E9 74 FB FF FF 0F 1F 00 31 F6 BF ?? ?? ?? ?? E8 ?? ?? ?? ?? BA ?? ?? ?? ?? 85 C0 48 0F 44 15 ?? ?? ?? ?? E9 66 FB FF FF 0F 1F 84 00 00 00 00 00 48 63 FD B8 03 00 00 00 0F 05 31 ED E9 3E FD FF FF 0F 1F 80 00 00 00 00 8B 3D ?? ?? ?? ?? 48 29 D6 48 89 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 3D ?? ?? ?? ?? 31 F6 BA 02 00 00 00 E8 ?? ?? ?? ?? 48 85 C0 0F 89 59 FE FF FF E9 CB FC FF FF 0F 1F 00 31 ED E9 F8 FC FF FF B9 ?? ?? ?? ?? BA 90 01 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? 31 ED 64 C7 00 0B 00 00 00 E9 CA FC FF FF }
	condition:
		$1
}

rule file_265_6_0 {
	meta:
		name = "getutline_r_file"
		size = 651
		refs = "003b alarm 007b __sigaction 00bd __fcntl_nocancel 00e1 __read_nocancel 0119 strncmp 018b __libc_errno 0287 __assert_fail"
	strings:
		$1 = { 41 55 41 54 55 53 48 81 EC 68 01 00 00 44 8B 05 ?? ?? ?? ?? 45 85 C0 0F 88 55 02 00 00 48 83 3D ?? ?? ?? ?? FF 0F 84 EF 01 00 00 48 89 FB 31 FF 49 89 F5 48 89 D5 48 83 C3 08 E8 ?? ?? ?? ?? 48 8D 54 24 28 48 8D 74 24 20 41 89 C4 B9 10 00 00 00 31 C0 48 C7 44 24 20 ?? ?? ?? ?? 48 89 D7 48 8D 94 24 C0 00 00 00 C7 84 24 A8 00 00 00 00 00 00 00 F3 48 AB BF 0E 00 00 00 E8 ?? ?? ?? ?? BF 0A 00 00 00 E8 ?? ?? ?? ?? 8B 3D ?? ?? ?? ?? 31 C0 48 89 E2 BE 07 00 00 00 48 C7 04 24 00 00 00 00 48 C7 44 24 08 00 00 00 00 48 C7 44 24 10 00 00 00 00 48 C7 44 24 18 00 00 00 00 E8 ?? ?? ?? ?? 85 C0 0F 88 47 01 00 00 0F 1F 80 00 00 00 00 8B 3D ?? ?? ?? ?? BA 80 01 00 00 BE ?? ?? ?? ?? E8 ?? ?? ?? ?? 3D 80 01 00 00 0F 85 98 00 00 00 0F B7 0D ?? ?? ?? ?? 48 81 05 ?? ?? ?? ?? 80 01 00 00 83 E9 06 66 83 F9 01 77 C5 BA 20 00 00 00 BE ?? ?? ?? ?? 48 89 DF E8 ?? ?? ?? ?? 85 C0 75 AF 41 F6 C5 01 4C 89 EF BE ?? ?? ?? ?? 66 B8 80 01 0F 85 1D 01 00 00 40 F6 C7 02 0F 85 FC 00 00 00 40 F6 C7 04 0F 85 DD 00 00 00 89 C1 31 D2 C1 E9 03 A8 04 F3 48 A5 74 09 8B 16 89 17 BA 04 00 00 00 A8 02 74 0C 0F B7 0C 16 66 89 0C 17 48 83 C2 02 A8 01 74 07 0F B6 04 16 88 04 17 4C 89 6D 00 EB 26 0F 1F 44 00 00 48 8B 05 ?? ?? ?? ?? 48 C7 05 ?? ?? ?? ?? FF FF FF FF 64 C7 00 03 00 00 00 48 C7 45 00 00 00 00 00 8B 3D ?? ?? ?? ?? 48 89 E2 BE 07 00 00 00 31 C0 66 C7 04 24 02 00 E8 ?? ?? ?? ?? 31 FF E8 ?? ?? ?? ?? 48 8D B4 24 C0 00 00 00 31 D2 BF 0E 00 00 00 E8 ?? ?? ?? ?? 45 85 E4 75 1C 48 83 7D 00 01 19 C0 48 81 C4 68 01 00 00 5B 5D 41 5C 41 5D C3 0F 1F 80 00 00 00 00 44 89 E7 E8 ?? ?? ?? ?? EB DA 66 0F 1F 44 00 00 48 C7 45 00 00 00 00 00 EB AA 48 C7 02 00 00 00 00 B8 FF FF FF FF EB C3 8B 16 48 83 C7 04 48 83 C6 04 83 E8 04 89 57 FC E9 0E FF FF FF 0F B7 16 48 83 C7 02 48 83 C6 02 83 E8 02 66 89 57 FE E9 ED FE FF FF 0F B6 05 ?? ?? ?? ?? 49 8D 7D 01 BE ?? ?? ?? ?? 41 88 45 00 B8 7F 01 00 00 E9 C5 FE FF FF B9 ?? ?? ?? ?? BA 59 01 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_265_7_0 {
	meta:
		name = "getutent_r_file"
		size = 666
		refs = "0034 alarm 0077 __sigaction 00b9 __fcntl_nocancel 00d2 __read_nocancel 0296 __assert_fail"
	strings:
		$1 = { 41 55 41 54 55 53 48 81 EC 68 01 00 00 44 8B 0D ?? ?? ?? ?? 45 85 C9 0F 88 64 02 00 00 48 83 3D ?? ?? ?? ?? FF 0F 84 45 02 00 00 48 89 FB 31 FF 48 89 F5 E8 ?? ?? ?? ?? 48 8D 54 24 28 48 8D 74 24 20 41 89 C5 B9 10 00 00 00 31 C0 48 C7 44 24 20 ?? ?? ?? ?? 48 89 D7 48 8D 94 24 C0 00 00 00 C7 84 24 A8 00 00 00 00 00 00 00 F3 48 AB BF 0E 00 00 00 45 31 E4 E8 ?? ?? ?? ?? BF 0A 00 00 00 E8 ?? ?? ?? ?? 8B 3D ?? ?? ?? ?? 31 C0 48 89 E2 BE 07 00 00 00 48 C7 04 24 00 00 00 00 48 C7 44 24 08 00 00 00 00 48 C7 44 24 10 00 00 00 00 48 C7 44 24 18 00 00 00 00 E8 ?? ?? ?? ?? 85 C0 78 33 8B 3D ?? ?? ?? ?? BA 80 01 00 00 BE ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 3D ?? ?? ?? ?? 4C 63 E0 48 89 E2 BE 07 00 00 00 31 C0 66 C7 04 24 02 00 E8 ?? ?? ?? ?? 31 FF E8 ?? ?? ?? ?? 48 8D B4 24 C0 00 00 00 31 D2 BF 0E 00 00 00 E8 ?? ?? ?? ?? 45 85 ED 0F 85 B8 00 00 00 49 81 FC 80 01 00 00 0F 85 C0 00 00 00 48 81 05 ?? ?? ?? ?? 80 01 00 00 F6 C3 01 48 89 DF BE ?? ?? ?? ?? 41 B8 80 01 00 00 0F 85 C9 00 00 00 40 F6 C7 02 0F 85 DF 00 00 00 40 F6 C7 04 0F 85 F5 00 00 00 44 89 C1 C1 E9 03 41 F6 C0 04 F3 48 A5 75 4E 41 F6 C0 02 75 30 41 83 E0 01 75 1A 48 89 5D 00 31 C0 48 81 C4 68 01 00 00 5B 5D 41 5C 41 5D C3 66 0F 1F 44 00 00 0F B6 14 0E 88 14 0F EB DD 0F 1F 80 00 00 00 00 0F B7 04 0E 66 89 04 0F 48 83 C1 02 41 83 E0 01 74 C4 EB DC 0F 1F 40 00 8B 0E 41 F6 C0 02 89 0F B9 04 00 00 00 74 A9 EB D7 0F 1F 80 00 00 00 00 44 89 EF E8 ?? ?? ?? ?? 49 81 FC 80 01 00 00 0F 84 40 FF FF FF 4D 85 E4 74 0B 48 C7 05 ?? ?? ?? ?? FF FF FF FF 48 C7 45 00 00 00 00 00 48 81 C4 68 01 00 00 B8 FF FF FF FF 5B 5D 41 5C 41 5D C3 0F B6 05 ?? ?? ?? ?? 48 8D 7B 01 BE ?? ?? ?? ?? 41 B0 7F 88 03 E9 1D FF FF FF 66 0F 1F 44 00 00 0F B7 0E 48 83 C7 02 48 83 C6 02 41 83 E8 02 66 89 4F FE E9 09 FF FF FF 0F 1F 84 00 00 00 00 00 8B 0E 48 83 C7 04 48 83 C6 04 41 83 E8 04 89 4F FC E9 F5 FE FF FF 66 2E 0F 1F 84 00 00 00 00 00 48 C7 06 00 00 00 00 B8 FF FF FF FF E9 FB FE FF FF B9 ?? ?? ?? ?? BA CC 00 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_265_8_0 {
	meta:
		name = "endutent_file"
		size = 56
		refs = "0034 __assert_fail"
	strings:
		$1 = { 48 63 3D ?? ?? ?? ?? 85 FF 78 12 B8 03 00 00 00 0F 05 C7 05 ?? ?? ?? ?? FF FF FF FF C3 41 52 B9 ?? ?? ?? ?? BA 10 02 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_265_9_0 {
	meta:
		name = "getutid_r_file"
		size = 355
		refs = "015f __assert_fail"
	strings:
		$1 = { 55 53 48 83 EC 18 44 8B 1D ?? ?? ?? ?? 45 85 DB 0F 88 34 01 00 00 48 83 3D ?? ?? ?? ?? FF 0F 84 FC 00 00 00 48 89 D5 48 8D 54 24 0F 48 89 F3 BE ?? ?? ?? ?? C6 44 24 0F 00 E8 B2 F2 FF FF 85 C0 0F 88 F2 00 00 00 F6 C3 01 48 89 DF BE ?? ?? ?? ?? 41 B8 80 01 00 00 0F 85 8B 00 00 00 40 F6 C7 02 0F 85 A1 00 00 00 40 F6 C7 04 75 63 44 89 C1 C1 E9 03 41 F6 C0 04 F3 48 A5 75 44 41 F6 C0 02 75 26 41 83 E0 01 75 10 48 89 5D 00 31 C0 48 83 C4 18 5B 5D C3 0F 1F 00 0F B6 04 0E 88 04 0F EB E7 0F 1F 80 00 00 00 00 0F B7 14 0E 66 89 14 0F 48 83 C1 02 41 83 E0 01 74 CE EB DC 0F 1F 40 00 8B 16 41 F6 C0 02 B1 04 89 17 74 B6 EB DA 66 90 8B 16 48 83 C7 04 48 83 C6 04 41 83 E8 04 89 57 FC EB 8A 0F 1F 44 00 00 0F B6 05 ?? ?? ?? ?? 48 8D 7B 01 BE ?? ?? ?? ?? 41 B0 7F 88 03 E9 5B FF FF FF 66 0F 1F 44 00 00 0F B7 16 48 83 C7 02 48 83 C6 02 41 83 E8 02 66 89 57 FE E9 47 FF FF FF 48 C7 02 00 00 00 00 B8 FF FF FF FF E9 5D FF FF FF 0F 1F 80 00 00 00 00 48 C7 45 00 00 00 00 00 B8 FF FF FF FF E9 44 FF FF FF B9 ?? ?? ?? ?? BA 3B 01 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_266_0_0 {
	meta:
		name = "cfsetspeed"
		size = 139
		refs = "0031 __libc_errno 0056 cfsetispeed 0060 cfsetospeed"
	strings:
		$1 = { 41 54 31 C0 49 89 FC 55 53 89 F3 0F 1F 44 00 00 8B 2C C5 ?? ?? ?? ?? 39 DD 74 35 39 1C C5 ?? ?? ?? ?? 74 4C 48 83 C0 01 48 83 F8 20 75 E2 48 8B 05 ?? ?? ?? ?? 64 C7 00 16 00 00 00 B8 FF FF FF FF 5B 5D 41 5C C3 66 2E 0F 1F 84 00 00 00 00 00 89 DE 4C 89 E7 E8 ?? ?? ?? ?? 89 DE 4C 89 E7 E8 ?? ?? ?? ?? 5B 5D 31 C0 41 5C C3 0F 1F 44 00 00 89 EE 4C 89 E7 E8 ?? ?? ?? ?? 89 EE 4C 89 E7 E8 ?? ?? ?? ?? 5B 5D 31 C0 41 5C C3 }
	condition:
		$1
}

rule file_267_0_0 {
	meta:
		name = "strcpy"
		size = 220
	strings:
		$1 = { 48 89 F1 83 E1 07 48 89 FA 74 1B F7 D9 83 C1 08 8A 06 84 C0 88 02 0F 84 BC 00 00 00 48 FF C6 48 FF C2 FF C9 75 EA 49 B8 FF FE FE FE FE FE FE FE 48 8B 06 48 83 C6 08 49 89 C1 4D 01 C1 0F 83 7D 00 00 00 49 31 C1 4D 09 C1 49 FF C1 75 72 48 89 02 48 83 C2 08 48 8B 06 48 83 C6 08 49 89 C1 4D 01 C1 73 5C 49 31 C1 4D 09 C1 49 FF C1 75 51 48 89 02 48 83 C2 08 48 8B 06 48 83 C6 08 49 89 C1 4D 01 C1 73 3B 49 31 C1 4D 09 C1 49 FF C1 75 30 48 89 02 48 83 C2 08 48 8B 06 48 83 C6 08 49 89 C1 4D 01 C1 73 1A 49 31 C1 4D 09 C1 49 FF C1 75 0F 48 89 02 48 83 C2 08 E9 73 FF FF FF 0F 1F 00 88 02 84 C0 74 12 48 FF C2 88 22 84 E4 74 09 48 FF C2 48 C1 E8 10 EB E8 48 89 F8 C3 }
	condition:
		$1
}

rule file_268_1_0 {
	meta:
		name = "_L_unlock_69"
		size = 27
		refs = "000b __lll_unlock_wake_private"
	strings:
		$1 = { 48 8D 3E 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 7C FF FF FF }
	condition:
		$1
}

rule file_268_3_0 {
	meta:
		name = "_IO_fflush"
		size = 241
		refs = "0033 __libc_multiple_threads 00ed _Unwind_Resume 00b1 _IO_flush_all"
	strings:
		$1 = { 48 85 FF 0F 84 A7 00 00 00 53 8B 07 48 89 FB 25 00 80 00 00 75 48 48 8B 97 88 00 00 00 64 4C 8B 04 25 10 00 00 00 4C 3B 42 08 74 2E BE 01 00 00 00 83 3D ?? ?? ?? ?? 00 74 0C F0 0F B1 32 0F 85 AD 00 00 00 EB 09 0F B1 32 0F 85 A2 00 00 00 48 8B 93 88 00 00 00 4C 89 42 08 83 42 04 01 48 8B 83 D8 00 00 00 48 89 DF FF 50 60 83 F8 01 19 D2 F7 03 00 80 00 00 F7 D2 75 2E 48 8B B3 88 00 00 00 83 6E 04 01 75 21 48 C7 46 08 00 00 00 00 83 3D ?? ?? ?? ?? 00 74 07 F0 FF 0E 75 6F EB 04 FF 0E 75 69 0F 1F 44 00 00 89 D0 5B C3 0F 1F 40 00 E9 ?? ?? ?? ?? F7 03 00 80 00 00 48 89 C6 75 29 48 8B 93 88 00 00 00 83 6A 04 01 75 1C 48 C7 42 08 00 00 00 00 83 3D ?? ?? ?? ?? 00 74 07 F0 FF 0A 75 44 EB 04 FF 0A 75 3E 48 89 F7 E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_269_0_0 {
	meta:
		name = "__setgid"
		size = 73
		refs = "0001 __nptl_setxid 003b __libc_errno"
	strings:
		$1 = { B8 ?? ?? ?? ?? 48 85 C0 74 1D 48 83 EC 38 89 FF 48 89 7C 24 08 C7 04 24 6A 00 00 00 48 89 E7 FF D0 48 83 C4 38 F3 C3 89 FF B8 6A 00 00 00 0F 05 48 3D 00 F0 FF FF 76 ED 48 8B 15 ?? ?? ?? ?? F7 D8 64 89 02 48 83 C8 FF C3 }
	condition:
		$1
}

rule file_270_0_0 {
	meta:
		name = "msort_with_tmp.part.0"
		size = 818
		refs = "00da mempcpy 0220 memcpy"
	strings:
		$1 = { 41 57 41 56 49 89 F6 41 55 41 54 55 48 89 D5 48 D1 ED 53 48 89 E9 48 89 D3 48 29 EB 48 83 EC 38 48 0F AF 0F 48 89 7C 24 18 48 89 74 24 20 48 89 54 24 28 49 01 CE 48 83 FD 01 76 08 48 89 EA E8 BC FF FF FF 48 83 FB 01 76 10 48 8B 7C 24 18 48 89 DA 4C 89 F6 E8 A6 FF FF FF 48 8B 44 24 18 48 8B 10 4C 8B 78 20 4C 8B 68 10 48 8B 40 18 48 89 54 24 10 48 8B 54 24 18 48 89 44 24 08 48 8B 42 08 48 83 F8 01 0F 84 A5 01 00 00 0F 82 9F 00 00 00 48 83 F8 02 0F 84 05 02 00 00 48 83 F8 03 4C 8B 64 24 20 0F 84 D6 00 00 00 48 85 DB 74 41 48 85 ED 74 3C 48 8B 54 24 08 4C 89 F6 4C 89 E7 41 FF D5 85 C0 48 8B 54 24 10 0F 8E 21 01 00 00 4C 89 F6 4C 89 FF 48 83 EB 01 E8 ?? ?? ?? ?? 4C 03 74 24 10 48 85 DB 49 89 C7 75 C4 0F 1F 44 00 00 48 85 ED 0F 85 17 01 00 00 48 8B 54 24 28 48 8B 44 24 18 48 8B 7C 24 20 48 29 DA 48 8B 70 20 48 0F AF 54 24 10 48 83 C4 38 5B 5D 41 5C 41 5D 41 5E 41 5F E9 ?? ?? ?? ?? 0F 1F 84 00 00 00 00 00 48 85 DB 4C 8B 64 24 20 75 1D EB B4 0F 1F 40 00 41 8B 06 48 83 EB 01 49 83 C6 04 41 89 07 49 83 C7 04 48 85 DB 74 99 48 85 ED 74 94 48 8B 54 24 08 4C 89 F6 4C 89 E7 41 FF D5 85 C0 7F D2 41 8B 04 24 48 83 ED 01 49 83 C4 04 41 89 07 EB CF 90 48 85 DB 0F 84 9F 01 00 00 48 85 ED 4C 8B 64 24 20 75 31 E9 90 01 00 00 0F 1F 84 00 00 00 00 00 49 8B 06 48 83 EB 01 49 83 C6 08 49 89 07 49 83 C7 08 48 85 DB 0F 84 35 FF FF FF 48 85 ED 0F 84 2C FF FF FF 48 8B 54 24 08 49 8B 36 49 8B 3C 24 41 FF D5 85 C0 7F C9 49 8B 04 24 48 83 ED 01 49 83 C4 08 49 89 07 EB C6 0F 1F 84 00 00 00 00 00 4C 89 E6 4C 89 FF 48 83 ED 01 E8 ?? ?? ?? ?? 4C 03 64 24 10 49 89 C7 E9 9E FE FF FF 0F 1F 40 00 48 8B 54 24 10 4C 89 E6 4C 89 FF 48 0F AF D5 E8 ?? ?? ?? ?? E9 D0 FE FF FF 0F 1F 80 00 00 00 00 48 85 DB 0F 84 EF 00 00 00 48 85 ED 4C 8B 64 24 20 75 31 E9 E0 00 00 00 0F 1F 84 00 00 00 00 00 49 8B 06 48 83 EB 01 49 83 C6 08 49 89 07 49 83 C7 08 48 85 DB 0F 84 85 FE FF FF 48 85 ED 0F 84 7C FE FF FF 48 8B 54 24 08 4C 89 F6 4C 89 E7 41 FF D5 85 C0 7F CA 49 8B 04 24 48 83 ED 01 49 83 C4 08 49 89 07 EB C7 66 0F 1F 84 00 00 00 00 00 4C 8B 64 24 20 EB 20 66 0F 1F 84 00 00 00 00 00 48 8B 54 24 10 48 83 EB 01 4C 89 F0 49 01 D6 4D 39 CF 72 4B 4D 89 CF 48 85 DB 0F 84 20 FE FF FF 48 85 ED 0F 84 17 FE FF FF 4C 8B 4C 24 10 48 8B 54 24 08 4C 89 F6 4C 89 E7 4D 01 F9 4C 89 0C 24 41 FF D5 85 C0 4C 8B 0C 24 7F B5 48 8B 54 24 10 48 83 ED 01 4C 89 E0 49 01 D4 4D 39 CF 73 B5 48 8B 10 49 83 C7 08 48 83 C0 08 49 89 57 F8 4D 39 F9 76 A1 EB EA 0F 1F 00 4C 8B 64 24 20 E9 BE FD FF FF }
	condition:
		$1
}

rule file_270_1_0 {
	meta:
		name = "qsort_r"
		size = 831
		refs = "0066 __libc_errno 0079 malloc 0150 memcpy 01bc free 021f _quicksort 02ad __sysconf"
	strings:
		$1 = { 55 48 89 E5 41 57 49 89 CF 41 56 41 55 41 54 53 48 89 D3 48 83 EC 68 48 83 FA 20 48 89 7D 98 48 89 75 80 0F 87 A7 01 00 00 49 89 F5 4C 0F AF EA 49 81 FD FF 03 00 00 0F 86 AB 01 00 00 8B 15 ?? ?? ?? ?? 85 D2 0F 84 55 02 00 00 48 63 F2 4C 89 E8 31 D2 48 F7 F6 48 3B 05 ?? ?? ?? ?? 0F 87 AD 01 00 00 4C 8B 35 ?? ?? ?? ?? 4C 89 EF 64 45 8B 26 4C 89 85 70 FF FF FF E8 ?? ?? ?? ?? 48 85 C0 48 89 85 78 FF FF FF 4C 8B 85 70 FF FF FF 64 45 89 26 0F 84 78 01 00 00 48 89 45 C0 48 83 FB 20 48 89 5D A0 48 C7 45 A8 04 00 00 00 4C 89 7D B0 4C 89 45 B8 0F 86 7E 01 00 00 48 8B 4D 80 4C 8B 65 C0 48 C1 E1 03 49 01 CC 49 8D 04 0C 49 39 C4 48 89 45 88 0F 83 50 02 00 00 48 8B 55 98 4C 89 E0 0F 1F 80 00 00 00 00 48 89 10 48 83 C0 08 48 01 DA 48 39 45 88 77 F0 48 8B 75 C0 48 01 CE 48 83 7D 80 01 48 C7 45 A0 08 00 00 00 48 C7 45 A8 03 00 00 00 0F 86 E9 01 00 00 48 8B 55 80 48 8D 7D A0 E8 99 FB FF FF 4C 8B 6D 98 48 C7 45 90 00 00 00 00 0F 1F 44 00 00 48 8B 45 90 4D 8B 3C C4 4D 39 EF 74 5D 48 8B 7D 88 4C 89 EE 48 89 DA E8 ?? ?? ?? ?? 4C 89 EF 48 8B 75 90 EB 06 0F 1F 00 49 89 C7 4C 89 F8 48 2B 45 98 31 D2 49 89 3C F4 4C 89 FE 48 F7 F3 48 89 DA 49 89 C6 E8 ?? ?? ?? ?? 4B 8D 14 F4 4C 89 F6 4C 89 FF 48 8B 02 4C 39 E8 75 CD 48 8B 75 88 4C 89 3A 48 89 DA E8 ?? ?? ?? ?? 48 83 45 90 01 49 01 DD 48 8B 45 80 48 39 45 90 75 84 48 8B BD 78 FF FF FF E8 ?? ?? ?? ?? 48 8D 65 D8 5B 41 5C 41 5D 41 5E 41 5F 5D C3 90 4C 8B 6D 80 49 C1 E5 04 49 01 D5 49 81 FD FF 03 00 00 0F 87 55 FE FF FF 49 83 C5 1E 48 C7 85 78 FF FF FF 00 00 00 00 49 83 E5 F0 4C 29 EC 48 8D 44 24 0F 48 83 E0 F0 48 89 45 C0 E9 8C FE FF FF 48 8B 75 80 48 8B 7D 98 4C 89 F9 48 89 DA E8 ?? ?? ?? ?? 48 8D 65 D8 5B 41 5C 41 5D 41 5E 41 5F 5D C3 66 0F 1F 44 00 00 F6 C3 03 75 33 F6 45 98 03 75 2D 48 83 FB 04 0F 84 E5 00 00 00 48 83 FB 08 0F 84 BC 00 00 00 83 E3 07 75 14 F6 45 98 07 75 0E 48 C7 45 A8 02 00 00 00 66 0F 1F 44 00 00 48 83 7D 80 01 0F 86 39 FF FF FF 48 8B 55 80 48 8B 75 98 48 8D 7D A0 E8 34 FA FF FF 48 8B BD 78 FF FF FF E8 ?? ?? ?? ?? E9 23 FF FF FF 0F 1F 00 BF 55 00 00 00 4C 89 85 70 FF FF FF E8 ?? ?? ?? ?? 48 83 F8 FF 48 BA FF FF FF FF FF FF FF 1F 4C 8B 85 70 FF FF FF 74 0F 48 8D 50 03 48 85 C0 48 0F 49 D0 48 C1 FA 02 48 89 15 ?? ?? ?? ?? BF 1E 00 00 00 4C 89 85 70 FF FF FF E8 ?? ?? ?? ?? 4C 8B 85 70 FF FF FF 89 C2 89 05 ?? ?? ?? ?? E9 48 FD FF FF 48 83 7D 80 00 0F 85 19 FE FF FF E9 A1 FE FF FF F6 45 98 07 0F 85 53 FF FF FF 48 C7 45 A8 01 00 00 00 E9 46 FF FF FF 4C 89 E6 E9 CD FD FF FF 48 C7 45 A8 00 00 00 00 E9 31 FF FF FF }
	condition:
		$1
}

rule file_271_0_0 {
	meta:
		name = "__arch_prctl"
		size = 20
		refs = "000f __syscall_error"
	strings:
		$1 = { B8 9E 00 00 00 0F 05 48 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_272_0_0 {
	meta:
		name = "__nrand48_r"
		size = 71
		refs = "000d __drand48_iterate"
	strings:
		$1 = { 55 48 89 D5 53 48 89 FB 48 83 EC 08 E8 ?? ?? ?? ?? 85 C0 78 2B 0F B7 43 02 0F B7 4B 04 66 D1 E8 C1 E1 0F 0F B7 C0 09 C8 48 98 48 89 45 00 31 C0 48 83 C4 08 5B 5D C3 66 0F 1F 84 00 00 00 00 00 B8 FF FF FF FF EB E9 }
	condition:
		$1
}

rule file_273_0_0 {
	meta:
		name = "__get_sol"
		size = 99
		refs = "005f __assert_fail"
	strings:
		$1 = { BA ?? ?? ?? ?? B8 FF FF FF FF EB 11 0F 1F 40 00 48 83 C2 0C 48 81 FA ?? ?? ?? ?? 74 24 8B 0A 83 F9 FF 74 22 39 72 08 75 E7 39 7A 04 74 15 83 F8 FF 0F 44 C1 48 83 C2 0C 48 81 FA ?? ?? ?? ?? 75 DC F3 C3 89 C8 C3 48 83 EC 08 B9 ?? ?? ?? ?? BA 44 00 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_273_1_0 {
	meta:
		name = "getsourcefilter"
		size = 399
		refs = "0073 memcpy 008b __get_sol 00aa __getsockopt 0121 free 0133 __libc_errno 0150 __libc_alloca_cutoff 016c malloc"
	strings:
		$1 = { 55 48 89 E5 48 89 5D D8 4C 89 65 E0 4D 89 CC 4C 89 75 F0 4C 89 7D F8 41 89 FE 4C 89 6D E8 48 83 EC 60 41 8B 01 49 89 D7 4C 89 45 B8 C1 E0 07 05 90 00 00 00 89 C3 89 45 CC 48 81 FB 00 10 00 00 0F 87 00 01 00 00 48 8D 43 1E 41 BD 01 00 00 00 48 C1 E8 04 48 C1 E0 04 48 29 C4 48 8D 5C 24 0F 48 83 E3 F0 48 8D 7B 08 89 33 89 CA 4C 89 FE 89 4D A8 E8 ?? ?? ?? ?? 41 8B 04 24 8B 4D A8 41 0F B7 3F 89 83 8C 00 00 00 89 CE E8 ?? ?? ?? ?? 83 F8 FF 0F 84 98 00 00 00 4C 8D 45 CC 44 89 F7 48 89 D9 BA 30 00 00 00 89 C6 E8 ?? ?? ?? ?? 85 C0 41 89 C6 74 23 45 85 ED 74 63 44 89 F0 48 8B 5D D8 4C 8B 65 E0 4C 8B 6D E8 4C 8B 75 F0 4C 8B 7D F8 C9 C3 0F 1F 44 00 00 8B 83 88 00 00 00 48 8B 55 B8 89 02 8B 83 8C 00 00 00 41 8B 0C 24 89 C2 48 C1 E2 07 39 C1 73 06 89 CA 48 C1 E2 07 48 8B 7D 10 48 8D B3 90 00 00 00 E8 ?? ?? ?? ?? 8B 83 8C 00 00 00 45 85 ED 41 89 04 24 75 9D 48 89 DF E8 ?? ?? ?? ?? EB 93 66 0F 1F 84 00 00 00 00 00 48 8B 15 ?? ?? ?? ?? 41 89 C6 64 C7 02 16 00 00 00 E9 6F FF FF FF 48 89 DF 89 4D A8 89 75 B0 E8 ?? ?? ?? ?? 85 C0 8B 4D A8 8B 75 B0 0F 85 E4 FE FF FF 48 89 DF 89 4D A8 89 75 B0 E8 ?? ?? ?? ?? 48 85 C0 48 89 C3 8B 4D A8 8B 75 B0 74 08 45 31 ED E9 DE FE FF FF 41 83 CE FF E9 2B FF FF FF }
	condition:
		$1
}

rule file_274_0_0 {
	meta:
		name = "__strfmon"
		size = 155
		refs = "0083 __libc_tsd_LOCALE 008f __vstrfmon_l"
	strings:
		$1 = { 48 81 EC D8 00 00 00 84 C0 48 89 4C 24 38 4C 89 44 24 40 4C 89 4C 24 48 74 37 0F 29 44 24 50 0F 29 4C 24 60 0F 29 54 24 70 0F 29 9C 24 80 00 00 00 0F 29 A4 24 90 00 00 00 0F 29 AC 24 A0 00 00 00 0F 29 B4 24 B0 00 00 00 0F 29 BC 24 C0 00 00 00 48 8D 84 24 E0 00 00 00 4C 8D 44 24 08 48 89 D1 48 89 44 24 10 48 8D 44 24 20 C7 44 24 08 18 00 00 00 C7 44 24 0C 30 00 00 00 48 89 44 24 18 48 8B 05 ?? ?? ?? ?? 64 48 8B 00 48 89 C2 E8 ?? ?? ?? ?? 48 81 C4 D8 00 00 00 C3 }
	condition:
		$1
}

rule file_276_0_0 {
	meta:
		name = "mknodat"
		size = 33
		refs = "0018 __xmknodat"
	strings:
		$1 = { 48 83 EC 18 4C 8D 44 24 08 48 89 4C 24 08 89 D1 48 89 F2 89 FE 31 FF E8 ?? ?? ?? ?? 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_277_0_0 {
	meta:
		name = "__libc_msync"
		size = 81
		refs = "0002 __libc_multiple_threads 0022 __libc_enable_asynccancel 0039 __libc_disable_asynccancel 0018 __syscall_error"
		altNames = "msync"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 75 14 B8 1A 00 00 00 0F 05 48 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 48 83 EC 08 E8 ?? ?? ?? ?? 48 89 04 24 B8 1A 00 00 00 0F 05 48 8B 3C 24 48 89 C2 E8 ?? ?? ?? ?? 48 89 D0 48 83 C4 08 48 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_77_0_3 {
	meta:
		name = "__libc_msync"
		size = 81
		refs = "0002 __pthread_multiple_threads 0022 __pthread_enable_asynccancel 0039 __pthread_disable_asynccancel 0018 __syscall_error"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 75 14 B8 1A 00 00 00 0F 05 48 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 48 83 EC 08 E8 ?? ?? ?? ?? 48 89 04 24 B8 1A 00 00 00 0F 05 48 8B 3C 24 48 89 C2 E8 ?? ?? ?? ?? 48 89 D0 48 83 C4 08 48 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_77_2_3 {
	meta:
		name = "msync"
		size = 81
		refs = "0002 __pthread_multiple_threads 0022 __pthread_enable_asynccancel 0039 __pthread_disable_asynccancel 0018 __syscall_error"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 75 14 B8 1A 00 00 00 0F 05 48 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 48 83 EC 08 E8 ?? ?? ?? ?? 48 89 04 24 B8 1A 00 00 00 0F 05 48 8B 3C 24 48 89 C2 E8 ?? ?? ?? ?? 48 89 D0 48 83 C4 08 48 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_277_1_0 {
	meta:
		name = "__msync_nocancel"
		size = 20
		refs = "000f __syscall_error"
	strings:
		$1 = { B8 1A 00 00 00 0F 05 48 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_278_0_0 {
	meta:
		name = "__libc_sendmsg"
		size = 81
		refs = "0002 __libc_multiple_threads 0022 __libc_enable_asynccancel 0039 __libc_disable_asynccancel 0018 __syscall_error"
		altNames = "__sendmsg"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 75 14 B8 2E 00 00 00 0F 05 48 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 48 83 EC 08 E8 ?? ?? ?? ?? 48 89 04 24 B8 2E 00 00 00 0F 05 48 8B 3C 24 48 89 C2 E8 ?? ?? ?? ?? 48 89 D0 48 83 C4 08 48 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_72_0_3 {
	meta:
		name = "__libc_sendmsg"
		size = 81
		refs = "0002 __pthread_multiple_threads 0022 __pthread_enable_asynccancel 0039 __pthread_disable_asynccancel 0018 __syscall_error"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 75 14 B8 2E 00 00 00 0F 05 48 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 48 83 EC 08 E8 ?? ?? ?? ?? 48 89 04 24 B8 2E 00 00 00 0F 05 48 8B 3C 24 48 89 C2 E8 ?? ?? ?? ?? 48 89 D0 48 83 C4 08 48 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_72_2_3 {
	meta:
		name = "__sendmsg"
		size = 81
		refs = "0002 __pthread_multiple_threads 0022 __pthread_enable_asynccancel 0039 __pthread_disable_asynccancel 0018 __syscall_error"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 75 14 B8 2E 00 00 00 0F 05 48 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 48 83 EC 08 E8 ?? ?? ?? ?? 48 89 04 24 B8 2E 00 00 00 0F 05 48 8B 3C 24 48 89 C2 E8 ?? ?? ?? ?? 48 89 D0 48 83 C4 08 48 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_278_1_0 {
	meta:
		name = "__sendmsg_nocancel"
		size = 20
		refs = "000f __syscall_error"
	strings:
		$1 = { B8 2E 00 00 00 0F 05 48 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_281_0_0 {
	meta:
		name = "posix_spawnattr_setflags"
		size = 22
	strings:
		$1 = { 66 F7 C6 80 FF B8 16 00 00 00 74 04 F3 C3 66 90 66 89 37 30 C0 C3 }
	condition:
		$1
}

rule file_282_0_0 {
	meta:
		name = "__fdelt_chk"
		size = 23
		refs = "0013 __chk_fail"
	strings:
		$1 = { 48 81 FF FF 03 00 00 77 08 48 89 F8 48 C1 F8 06 C3 50 E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_283_0_0 {
	meta:
		name = "__wmemcpy_chk"
		size = 20
		refs = "0010 __chk_fail 000a memcpy"
	strings:
		$1 = { 48 39 D1 72 09 48 C1 E2 02 E9 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1006_0_0 {
	meta:
		name = "__wmemmove_chk"
		size = 20
		refs = "0010 __chk_fail 000a memmove"
	strings:
		$1 = { 48 39 D1 72 09 48 C1 E2 02 E9 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1058_0_0 {
	meta:
		name = "__wmempcpy_chk"
		size = 20
		refs = "0010 __chk_fail 000a mempcpy"
	strings:
		$1 = { 48 39 D1 72 09 48 C1 E2 02 E9 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_284_0_0 {
	meta:
		name = "strcspn"
		size = 151
	strings:
		$1 = { 48 89 FA 49 89 F8 48 81 EC 00 01 00 00 B9 20 00 00 00 48 89 E7 31 C0 FC F3 48 AB 48 89 F0 66 90 8A 08 84 C9 74 28 88 0C 0C 8A 48 01 F6 C1 FF 74 1D 88 0C 0C 8A 48 02 F6 C1 FF 74 12 88 0C 0C 8A 48 03 48 83 C0 04 88 0C 0C F6 C1 FF 75 D2 48 8D 42 FC 66 66 66 66 66 2E 0F 1F 84 00 00 00 00 00 48 83 C0 04 8A 08 38 0C 0C 74 21 8A 48 01 38 0C 0C 74 16 8A 48 02 38 0C 0C 74 0B 8A 48 03 38 0C 0C 75 DD 48 FF C0 48 FF C0 48 FF C0 48 81 C4 00 01 00 00 48 29 D0 C3 }
	condition:
		$1
}

rule file_285_0_0 {
	meta:
		name = "_L_lock_43"
		size = 27
		refs = "000b __lll_lock_wait_private"
	strings:
		$1 = { 49 8D 38 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 1C FF FF FF }
	condition:
		$1
}

rule file_285_3_0 {
	meta:
		name = "__vwprintf_chk"
		size = 300
		refs = "0019 stdout 0045 __libc_multiple_threads 008d _IO_vfwprintf 0128 _Unwind_Resume"
	strings:
		$1 = { 48 89 5C 24 E8 48 89 6C 24 F0 49 89 F2 4C 89 64 24 F8 48 83 EC 18 48 8B 1D ?? ?? ?? ?? 89 FD 8B 03 25 00 80 00 00 75 4B 4C 8B 83 88 00 00 00 64 4C 8B 24 25 10 00 00 00 4D 3B 60 08 74 30 BE 01 00 00 00 83 3D ?? ?? ?? ?? 00 74 0D F0 41 0F B1 30 0F 85 D5 00 00 00 EB 0A 41 0F B1 30 0F 85 C9 00 00 00 4C 8B 83 88 00 00 00 4D 89 60 08 41 83 40 04 01 85 ED 7E 0B 48 8B 05 ?? ?? ?? ?? 83 48 74 04 48 8B 3D ?? ?? ?? ?? 4C 89 D6 E8 ?? ?? ?? ?? 85 ED 89 C2 7E 0B 48 8B 05 ?? ?? ?? ?? 83 60 74 FB 83 63 74 EB F7 03 00 80 00 00 75 29 48 8B B3 88 00 00 00 83 6E 04 01 75 1C 48 C7 46 08 00 00 00 00 83 3D ?? ?? ?? ?? 00 74 07 F0 FF 0E 75 76 EB 04 FF 0E 75 70 89 D0 48 8B 1C 24 48 8B 6C 24 08 4C 8B 64 24 10 48 83 C4 18 C3 83 63 74 EB F7 03 00 80 00 00 48 89 C6 75 29 48 8B 93 88 00 00 00 83 6A 04 01 75 1C 48 C7 42 08 00 00 00 00 83 3D ?? ?? ?? ?? 00 74 07 F0 FF 0A 75 44 EB 04 FF 0A 75 3E 48 89 F7 E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_455_3_0 {
	meta:
		name = "___vprintf_chk"
		size = 300
		refs = "0019 stdout 0045 __libc_multiple_threads 008d vfprintf 0128 _Unwind_Resume"
	strings:
		$1 = { 48 89 5C 24 E8 48 89 6C 24 F0 49 89 F2 4C 89 64 24 F8 48 83 EC 18 48 8B 1D ?? ?? ?? ?? 89 FD 8B 03 25 00 80 00 00 75 4B 4C 8B 83 88 00 00 00 64 4C 8B 24 25 10 00 00 00 4D 3B 60 08 74 30 BE 01 00 00 00 83 3D ?? ?? ?? ?? 00 74 0D F0 41 0F B1 30 0F 85 D5 00 00 00 EB 0A 41 0F B1 30 0F 85 C9 00 00 00 4C 8B 83 88 00 00 00 4D 89 60 08 41 83 40 04 01 85 ED 7E 0B 48 8B 05 ?? ?? ?? ?? 83 48 74 04 48 8B 3D ?? ?? ?? ?? 4C 89 D6 E8 ?? ?? ?? ?? 85 ED 89 C2 7E 0B 48 8B 05 ?? ?? ?? ?? 83 60 74 FB 83 63 74 EB F7 03 00 80 00 00 75 29 48 8B B3 88 00 00 00 83 6E 04 01 75 1C 48 C7 46 08 00 00 00 00 83 3D ?? ?? ?? ?? 00 74 07 F0 FF 0E 75 76 EB 04 FF 0E 75 70 89 D0 48 8B 1C 24 48 8B 6C 24 08 4C 8B 64 24 10 48 83 C4 18 C3 83 63 74 EB F7 03 00 80 00 00 48 89 C6 75 29 48 8B 93 88 00 00 00 83 6A 04 01 75 1C 48 C7 42 08 00 00 00 00 83 3D ?? ?? ?? ?? 00 74 07 F0 FF 0A 75 44 EB 04 FF 0A 75 3E 48 89 F7 E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_288_0_0 {
	meta:
		name = "__alloc_dir"
		size = 331
		refs = "003f __fcntl 0068 malloc 00b2 __have_o_cloexec 0130 __libc_errno"
	strings:
		$1 = { 48 89 5C 24 E8 48 89 6C 24 F0 48 89 CB 4C 89 64 24 F8 48 83 EC 18 40 84 F6 89 FD 41 89 F4 0F 85 8C 00 00 00 81 E2 00 00 08 00 0F 85 80 00 00 00 31 C0 BA 01 00 00 00 BE 02 00 00 00 89 EF E8 ?? ?? ?? ?? 85 C0 0F 88 DD 00 00 00 48 85 DB 74 77 48 8B 43 38 BB 00 80 00 00 48 3D 00 80 00 00 48 0F 43 D8 48 8D 7B 28 E8 ?? ?? ?? ?? 48 85 C0 0F 84 93 00 00 00 89 28 C7 40 04 00 00 00 00 48 89 58 08 48 C7 40 10 00 00 00 00 48 C7 40 18 00 00 00 00 48 C7 40 20 00 00 00 00 48 8B 1C 24 48 8B 6C 24 08 4C 8B 64 24 10 48 83 C4 18 C3 0F 1F 00 8B 05 ?? ?? ?? ?? 85 C0 74 1E 85 C0 0F 8E 6E FF FF FF 48 85 DB 75 89 BF 28 80 00 00 66 BB 00 80 EB 95 66 0F 1F 44 00 00 31 D2 BE 01 00 00 00 89 EF E8 ?? ?? ?? ?? 83 E0 01 83 F8 01 19 C0 83 C8 01 85 C0 89 05 ?? ?? ?? ?? 0F 8E 31 FF FF FF EB C1 0F 1F 80 00 00 00 00 BF 28 20 00 00 E8 ?? ?? ?? ?? 48 85 C0 74 11 BB 00 20 00 00 E9 54 FF FF FF 0F 1F 80 00 00 00 00 45 84 E4 74 17 48 8B 15 ?? ?? ?? ?? 48 63 FD B8 03 00 00 00 64 8B 32 0F 05 64 89 32 31 C0 E9 4F FF FF FF }
	condition:
		$1
}

rule file_288_1_0 {
	meta:
		name = "__opendirat"
		size = 66
		refs = "0011 __openat_nocancel 0034 __libc_errno 0029 __alloc_dir"
	strings:
		$1 = { 80 3E 00 74 2C 48 83 EC 08 31 C9 BA 00 08 09 00 E8 ?? ?? ?? ?? 85 C0 78 14 31 C9 31 D2 BE 01 00 00 00 89 C7 48 83 C4 08 E9 ?? ?? ?? ?? 31 C0 5A C3 48 8B 05 ?? ?? ?? ?? 64 C7 00 02 00 00 00 31 C0 C3 }
	condition:
		$1
}

rule file_289_0_0 {
	meta:
		name = "__updwtmp"
		size = 220
		refs = "0053 __libc_utmp_file_functions 0070 __access"
	strings:
		$1 = { 55 B9 0E 00 00 00 48 89 F5 53 48 89 FB BF ?? ?? ?? ?? 48 89 DE 48 83 EC 08 F3 A6 74 4B B9 0E 00 00 00 BF ?? ?? ?? ?? 48 89 DE F3 A6 74 52 BF ?? ?? ?? ?? B9 0F 00 00 00 48 89 DE F3 A6 74 61 BF ?? ?? ?? ?? B9 0F 00 00 00 48 89 DE F3 A6 74 70 48 8B 05 ?? ?? ?? ?? 48 83 C4 08 48 89 DF 5B 48 89 EE 5D FF E0 0F 1F 00 31 F6 BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 75 A5 BB ?? ?? ?? ?? EB D1 90 31 F6 BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 75 9E BB ?? ?? ?? ?? EB B9 66 0F 1F 84 00 00 00 00 00 31 F6 BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 8F BB ?? ?? ?? ?? EB 99 66 0F 1F 84 00 00 00 00 00 31 F6 BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 B8 ?? ?? ?? ?? 48 0F 45 D8 E9 74 FF FF FF }
	condition:
		$1
}

rule file_290_0_0 {
	meta:
		name = "__fchdir"
		size = 20
		refs = "000f __syscall_error"
	strings:
		$1 = { B8 51 00 00 00 0F 05 48 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_291_0_0 {
	meta:
		name = "__assert_fail_base"
		size = 324
		refs = "0003 pthread_setcancelstate 0040 __progname 0082 __asprintf 009d __fxprintf 00a4 stderr 00a9 _IO_fflush 00af _dl_pagesize 00da __mmap 00f7 strcpy 0101 __abort_msg 010d __munmap 0117 free 011c abort 0130 __libc_write"
	strings:
		$1 = { 41 56 B8 ?? ?? ?? ?? 49 89 F6 41 55 41 89 CD 41 54 49 89 D4 55 48 89 FD 53 4C 89 C3 48 83 EC 30 48 85 C0 74 09 31 F6 BF 01 00 00 00 FF D0 48 85 DB 41 BB ?? ?? ?? ?? 0F 84 F9 00 00 00 4C 8B 15 ?? ?? ?? ?? BA ?? ?? ?? ?? B9 ?? ?? ?? ?? 48 8D 7C 24 28 45 89 E9 4D 89 E0 48 89 EE 41 80 3A 00 4C 89 74 24 10 4C 89 5C 24 08 48 89 1C 24 48 0F 44 CA 48 8D 54 24 24 31 C0 48 89 54 24 18 4C 89 D2 E8 ?? ?? ?? ?? 85 C0 0F 88 92 00 00 00 48 8B 54 24 28 BE ?? ?? ?? ?? 31 FF 31 C0 E8 ?? ?? ?? ?? 48 8B 3D ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 05 ?? ?? ?? ?? 45 31 C9 31 FF 41 B8 FF FF FF FF B9 22 00 00 00 BA 03 00 00 00 89 C6 03 44 24 24 F7 DE 21 C6 89 74 24 24 48 63 F6 E8 ?? ?? ?? ?? 48 83 F8 FF 48 89 C3 74 2A 8B 44 24 24 48 8B 74 24 28 48 8D 7B 04 89 03 E8 ?? ?? ?? ?? 48 89 DF 48 87 3D ?? ?? ?? ?? 48 85 FF 74 07 8B 37 E8 ?? ?? ?? ?? 48 8B 7C 24 28 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? BA 12 00 00 00 BE ?? ?? ?? ?? BF 02 00 00 00 E8 ?? ?? ?? ?? EB E5 41 BB ?? ?? ?? ?? 4C 89 DB E9 F9 FE FF FF }
	condition:
		$1
}

rule file_291_1_0 {
	meta:
		name = "__assert_fail"
		size = 62
		refs = "001d _libc_intl_domainname 0026 __dcgettext 003a __assert_fail_base"
	strings:
		$1 = { 41 55 49 89 CD 41 54 41 89 D4 BA 05 00 00 00 55 48 89 F5 BE ?? ?? ?? ?? 53 48 89 FB BF ?? ?? ?? ?? 48 83 EC 08 E8 ?? ?? ?? ?? 4D 89 E8 44 89 E1 48 89 EA 48 89 DE 48 89 C7 E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_295_0_0 {
	meta:
		name = "__lll_lock_wait_private"
		size = 42
	strings:
		$1 = { 41 52 52 4D 31 D2 BA 02 00 00 00 64 8B 34 25 48 00 00 00 39 D0 75 07 B8 CA 00 00 00 0F 05 89 D0 87 07 85 C0 75 F1 5A 41 5A C3 }
	condition:
		$1
}

rule file_295_1_0 {
	meta:
		name = "__lll_unlock_wake_private"
		size = 34
	strings:
		$1 = { 56 52 C7 07 00 00 00 00 64 8B 34 25 48 00 00 00 83 CE 01 BA 01 00 00 00 B8 CA 00 00 00 0F 05 5A 5E C3 }
	condition:
		$1
}

rule file_296_0_0 {
	meta:
		name = "setegid"
		size = 121
		refs = "0006 __nptl_setxid 0043 __libc_errno"
	strings:
		$1 = { 83 FF FF 74 3B B8 ?? ?? ?? ?? 48 85 C0 74 42 48 83 EC 38 89 FF 48 89 7C 24 10 C7 04 24 77 00 00 00 48 89 E7 48 C7 44 24 08 FF FF FF FF 48 C7 44 24 18 FF FF FF FF FF D0 48 83 C4 38 F3 C3 66 90 48 8B 05 ?? ?? ?? ?? 64 C7 00 16 00 00 00 89 F8 C3 48 83 CA FF 89 FE B8 77 00 00 00 48 89 D7 0F 05 48 3D 00 F0 FF FF 76 D3 48 8B 15 ?? ?? ?? ?? F7 D8 64 89 02 48 89 F8 C3 }
	condition:
		$1
}

rule file_298_0_0 {
	meta:
		name = "__printf_fphex"
		size = 6021
		refs = "003c _nl_current_LC_NUMERIC 0093 __isnan 00a8 __libc_tsd_CTYPE_B 0136 _IO_padn 017b _nl_current_LC_MONETARY 01b5 __isnanl 039b __isinf 03bc _itowa_upper_digits 03e3 _itowa_lower_digits 044e _itoa_word 052a __isinfl 05e9 _IO_wpadn 0874 strlen 10fc __libc_tsd_CTYPE_TOLOWER 12c6 __assert_fail 1313 __woverflow 1399 __overflow"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 49 89 F4 55 53 48 89 FB 48 81 EC 78 01 00 00 8B 06 44 8B 7E 04 89 44 24 48 0F B6 46 0D 89 C1 C0 E9 02 41 89 CD 41 83 E5 01 A8 01 0F 85 3F 01 00 00 48 8B 05 ?? ?? ?? ?? 64 48 8B 00 48 8B 00 4C 8B 70 40 8B 40 58 89 44 24 44 41 80 3E 00 0F 84 55 12 00 00 8B 44 24 44 85 C0 0F 84 49 12 00 00 41 0F B6 6C 24 0C 48 8B 02 40 F6 C5 01 0F 85 25 01 00 00 F2 0F 10 08 66 0F 28 C1 F2 0F 11 8C 24 90 00 00 00 F2 0F 11 4C 24 10 E8 ?? ?? ?? ?? 85 C0 F2 0F 10 4C 24 10 0F 84 EB 02 00 00 48 8B 05 ?? ?? ?? ?? 49 63 54 24 08 B9 ?? ?? ?? ?? 44 0F BE B4 24 97 00 00 00 41 B9 ?? ?? ?? ?? 64 48 8B 00 41 C1 EE 1F 0F B7 04 50 BA ?? ?? ?? ?? 66 25 00 01 B8 ?? ?? ?? ?? 48 0F 44 CA 4C 0F 44 C8 45 85 F6 75 09 40 F6 C5 50 45 89 F8 74 04 45 8D 47 FF 41 83 E8 03 83 E5 20 0F 85 0A 01 00 00 45 85 C0 0F 8E 01 01 00 00 49 63 E8 45 85 ED BE 20 00 00 00 48 89 EA 48 89 DF 48 89 4C 24 28 44 89 44 24 10 4C 89 4C 24 20 0F 85 CB 04 00 00 E8 ?? ?? ?? ?? 4C 8B 4C 24 20 44 8B 44 24 10 48 8B 4C 24 28 48 39 E8 45 89 C7 0F 84 BE 00 00 00 0F 1F 00 41 BF FF FF FF FF 48 81 C4 78 01 00 00 44 89 F8 5B 5D 41 5C 41 5D 41 5E 41 5F C3 0F 1F 44 00 00 48 8B 05 ?? ?? ?? ?? 64 48 8B 00 48 8B 00 4C 8B 70 50 8B 80 98 01 00 00 89 44 24 44 E9 B9 FE FF FF 0F 1F 80 00 00 00 00 DB 28 D9 C0 DB BC 24 90 00 00 00 D9 C0 DB 3C 24 DB 7C 24 10 E8 ?? ?? ?? ?? 85 C0 DB 6C 24 10 0F 84 5B 03 00 00 DD D8 48 8B 05 ?? ?? ?? ?? 49 63 54 24 08 B9 ?? ?? ?? ?? 44 0F BE B4 24 99 00 00 00 41 B9 ?? ?? ?? ?? 64 48 8B 00 41 C1 EE 1F 0F B7 04 50 BA ?? ?? ?? ?? 66 25 00 01 B8 ?? ?? ?? ?? 48 0F 45 CA 4C 0F 45 C8 E9 D9 FE FF FF 66 90 45 31 FF 45 85 F6 0F 84 E4 00 00 00 45 85 ED 0F 84 5B 03 00 00 48 8B 83 A0 00 00 00 48 85 C0 0F 84 8A 11 00 00 48 8B 50 20 48 3B 50 28 0F 83 7C 11 00 00 C7 02 2D 00 00 00 48 83 C2 04 48 89 50 20 41 83 C7 01 45 85 ED 0F 84 F2 00 00 00 45 8D 77 01 31 ED 48 8B 83 A0 00 00 00 8B 34 A9 48 85 C0 0F 84 8E 10 00 00 48 8B 50 20 48 3B 50 28 0F 83 80 10 00 00 83 FE FF 89 32 40 0F 94 C6 48 83 C2 04 48 89 50 20 40 84 F6 0F 85 B9 FE FF FF 45 8D 3C 2E 48 83 C5 01 48 83 FD 03 75 B7 41 F6 44 24 0C 20 0F 84 A5 FE FF FF 45 85 C0 0F 8E 9C FE FF FF 49 63 E8 45 85 ED BE 20 00 00 00 48 89 EA 48 89 DF 44 89 44 24 10 0F 85 0A 03 00 00 E8 ?? ?? ?? ?? 44 8B 44 24 10 48 39 E8 0F 85 67 FE FF FF 45 01 C7 E9 65 FE FF FF 0F 1F 80 00 00 00 00 41 0F B6 44 24 0C A8 40 0F 84 92 02 00 00 45 85 ED 0F 84 59 09 00 00 48 8B 83 A0 00 00 00 48 85 C0 0F 84 E3 10 00 00 48 8B 50 20 48 3B 50 28 0F 83 D5 10 00 00 C7 02 2B 00 00 00 48 83 C2 04 48 89 50 20 E9 09 FF FF FF 0F 1F 84 00 00 00 00 00 45 89 FE 49 8D 49 03 4C 89 CD 45 29 CE 0F B6 55 00 48 8B 43 28 48 83 C5 01 48 3B 43 30 0F 83 6A 10 00 00 88 10 48 83 C0 01 48 89 43 28 48 39 CD 45 8D 3C 2E 75 D7 E9 22 FF FF FF 0F 1F 44 00 00 66 0F 28 C1 F2 0F 11 4C 24 10 E8 ?? ?? ?? ?? 85 C0 F2 0F 10 4C 24 10 0F 85 8F 01 00 00 66 0F D7 F9 C1 EF 07 8B 84 24 94 00 00 00 B9 ?? ?? ?? ?? 83 E7 01 48 8D AC 24 70 01 00 00 89 7C 24 4C 8B BC 24 90 00 00 00 25 FF FF 0F 00 48 C1 E0 20 48 09 C7 B8 ?? ?? ?? ?? 41 0F 94 C1 41 83 7C 24 08 41 45 0F B6 C9 45 89 CB 48 0F 45 C8 48 89 F8 90 48 89 C2 48 C1 E8 04 48 83 ED 04 83 E2 0F 48 85 C0 8B 14 91 89 55 00 75 E7 31 C9 41 83 7C 24 08 41 4C 8D 84 24 D0 00 00 00 48 8D B4 24 F0 00 00 00 BA 10 00 00 00 44 89 4C 24 20 4C 89 44 24 10 44 89 5C 24 30 48 89 6C 24 38 0F 94 C1 E8 ?? ?? ?? ?? 48 8D 94 24 3C 01 00 00 48 89 44 24 50 4C 8B 44 24 10 44 8B 4C 24 20 4C 8B 54 24 38 48 39 D5 44 8B 5C 24 30 76 3D 0F 1F 84 00 00 00 00 00 48 83 ED 04 48 83 E8 01 C7 45 00 30 00 00 00 48 39 D5 C6 00 30 77 E9 48 F7 D2 4A 8D 04 12 48 C1 E8 02 48 89 C2 48 F7 D0 48 01 44 24 50 48 F7 DA 49 8D 6C 92 FC 0F B7 84 24 96 00 00 00 89 C2 66 81 E2 F0 7F 66 83 FA 01 19 D2 66 C1 E8 04 83 C2 31 25 FF 07 00 00 88 54 24 60 0F 85 B0 07 00 00 45 85 C9 41 BA FE 03 00 00 0F 84 4A 02 00 00 45 31 C0 C7 44 24 78 00 00 00 00 83 7C 24 48 FF 4C 8B 5C 24 50 0F 85 99 02 00 00 C7 44 24 48 00 00 00 00 E9 8C 02 00 00 66 0F 1F 84 00 00 00 00 00 D9 C0 DB 3C 24 DB 7C 24 10 E8 ?? ?? ?? ?? 85 C0 DB 6C 24 10 0F 84 E6 00 00 00 DD D8 48 8B 15 ?? ?? ?? ?? 49 63 4C 24 08 BE ?? ?? ?? ?? 41 B9 ?? ?? ?? ?? 41 89 C6 64 48 8B 12 0F B7 14 4A B9 ?? ?? ?? ?? 66 81 E2 00 01 BA ?? ?? ?? ?? 48 0F 44 CE 4C 0F 44 CA 41 C1 EE 1F E9 69 FB FF FF 66 90 48 8B 43 28 48 3B 43 30 0F 83 F3 0D 00 00 C6 00 2D 48 83 C0 01 48 89 43 28 E9 B3 FC FF FF 66 90 A8 10 0F 84 AD FC FF FF 45 85 ED 0F 84 0F 07 00 00 48 8B 83 A0 00 00 00 48 85 C0 0F 84 03 10 00 00 48 8B 50 20 48 3B 50 28 0F 83 F5 0F 00 00 C7 02 20 00 00 00 48 83 C2 04 48 89 50 20 E9 6F FC FF FF 66 0F 1F 44 00 00 E8 ?? ?? ?? ?? 44 8B 44 24 10 E9 F1 FC FF FF 66 0F 1F 84 00 00 00 00 00 E8 ?? ?? ?? ?? 48 8B 4C 24 28 44 8B 44 24 10 4C 8B 4C 24 20 E9 30 FB FF FF 0F 1F 80 00 00 00 00 DB BC 24 A0 00 00 00 8B AC 24 94 00 00 00 8B 84 24 90 00 00 00 31 C9 4C 8D 84 24 D0 00 00 00 BA 10 00 00 00 4C 89 44 24 10 48 C1 E5 20 8B B4 24 A8 00 00 00 48 09 C5 41 83 7C 24 08 41 48 89 EF 89 74 24 4C 48 8D B4 24 F0 00 00 00 0F 94 C1 E8 ?? ?? ?? ?? 41 83 7C 24 08 41 BA ?? ?? ?? ?? BE ?? ?? ?? ?? 4C 8B 44 24 10 48 89 E9 48 0F 45 F2 48 8D 94 24 70 01 00 00 48 89 CF 48 C1 E9 04 48 83 EA 04 83 E7 0F 48 85 C9 8B 3C BE 89 3A 75 E8 49 8D 70 10 48 89 D7 48 39 F0 76 2E 48 89 C1 90 48 83 E9 01 48 83 EA 04 C6 01 30 48 39 F1 C7 02 30 00 00 00 75 EA 48 8D 50 FF 48 29 D0 48 29 D1 4A 8D 44 00 0F 48 8D 54 8F FC 8B 4C 24 4C 0F B6 30 C1 E9 0F 83 E1 01 40 88 74 24 60 89 4C 24 4C 31 C9 48 85 ED 0F 94 C1 48 83 C0 01 48 8D 6A 04 48 89 44 24 50 0F B7 84 24 98 00 00 00 41 89 CB 25 FF 7F 00 00 0F 85 15 08 00 00 85 C9 41 BA 01 40 00 00 0F 85 B6 FD FF FF C7 44 24 78 01 00 00 00 83 BC 24 6C 01 00 00 30 0F 85 A2 0A 00 00 48 8D 84 24 70 01 00 00 4C 8D 9C 24 F0 00 00 00 90 48 83 E8 04 49 83 EB 01 83 78 FC 30 74 F2 83 7C 24 48 FF 0F 84 07 08 00 00 4C 89 DA 48 63 44 24 48 48 2B 54 24 50 48 39 D0 7D 15 48 8B 4C 24 50 80 3C 01 38 0F 8F 3B 09 00 00 0F 84 FA 08 00 00 4D 63 C2 48 8D B4 24 85 00 00 00 31 C9 4C 89 C7 BA 0A 00 00 00 4C 89 44 24 10 4C 89 5C 24 30 E8 ?? ?? ?? ?? 4C 8B 5C 24 30 4C 8B 44 24 10 48 8D 8C 24 C4 00 00 00 49 89 C1 48 BE CD CC CC CC CC CC CC CC 0F 1F 44 00 00 4C 89 C0 48 83 E9 04 48 F7 E6 48 C1 EA 03 48 8D 04 92 48 01 C0 49 29 C0 48 85 D2 42 8B 04 85 ?? ?? ?? ?? 49 89 D0 89 01 75 D6 8B 44 24 4C 48 8D 94 24 85 00 00 00 44 89 CE 29 D6 48 89 54 24 58 41 0F B6 54 24 0C 85 C0 0F 84 1A 05 00 00 B8 FC FF FF FF 2B 44 24 48 45 8D 7C 37 FE 41 01 C7 8B 44 24 48 85 C0 0F 8E C5 05 00 00 45 85 ED B8 01 00 00 00 75 2F 4C 89 F7 88 54 24 38 48 89 4C 24 28 4C 89 4C 24 20 4C 89 5C 24 30 E8 ?? ?? ?? ?? 0F B6 54 24 38 4C 8B 5C 24 30 4C 8B 4C 24 20 48 8B 4C 24 28 41 29 C7 83 E2 20 44 89 7C 24 70 0F 85 A3 04 00 00 41 83 7C 24 10 30 0F 84 97 04 00 00 44 8B 54 24 70 45 85 D2 0F 8E 89 04 00 00 4C 63 7C 24 70 45 85 ED BE 20 00 00 00 48 89 DF 48 89 4C 24 28 4C 89 4C 24 20 4C 89 5C 24 30 4C 89 FA 0F 84 1F 07 00 00 E8 ?? ?? ?? ?? 48 8B 4C 24 28 4C 8B 4C 24 20 4C 8B 5C 24 30 49 39 C7 0F 85 5C F8 FF FF 44 8B 7C 24 70 44 8B 44 24 4C 45 85 C0 0F 84 59 04 00 00 45 85 ED 0F 84 18 05 00 00 48 8B 83 A0 00 00 00 48 85 C0 0F 84 49 0E 00 00 48 8B 50 20 48 3B 50 28 0F 83 3B 0E 00 00 C7 02 2D 00 00 00 48 83 C2 04 48 89 50 20 41 83 C7 01 45 85 ED 0F 84 5F 04 00 00 48 8B 83 A0 00 00 00 48 85 C0 0F 84 88 0B 00 00 48 8B 50 20 48 3B 50 28 0F 83 7A 0B 00 00 C7 02 30 00 00 00 48 83 C2 04 48 89 50 20 41 8B 74 24 08 83 C6 17 45 85 ED 0F 84 42 04 00 00 48 8B 83 A0 00 00 00 48 85 C0 0F 84 3A 0C 00 00 48 8B 50 20 48 3B 50 28 0F 83 2C 0C 00 00 83 FE FF 89 32 40 0F 94 C6 48 83 C2 04 48 89 50 20 40 84 F6 0F 85 92 F7 FF FF 41 F6 44 24 0C 20 45 8D 47 02 75 0C 41 83 7C 24 10 30 0F 84 57 06 00 00 45 85 ED 0F 84 09 04 00 00 48 8B 83 A0 00 00 00 0F BE 74 24 60 48 85 C0 0F 84 61 0C 00 00 48 8B 50 20 48 3B 50 28 0F 83 53 0C 00 00 83 FE FF 89 32 40 0F 94 C6 48 83 C2 04 48 89 50 20 40 84 F6 0F 85 34 F7 FF FF 8B 74 24 48 45 8D 78 01 85 F6 0F 8E 64 04 00 00 45 85 ED 0F 85 BB 02 00 00 4C 89 F7 48 89 4C 24 28 4C 89 4C 24 20 4C 89 5C 24 30 E8 ?? ?? ?? ?? 48 85 C0 48 89 C2 48 8B 4C 24 28 4C 8B 4C 24 20 4C 8B 5C 24 30 74 35 0F 1F 44 00 00 41 0F B6 36 48 8B 43 28 49 83 C6 01 48 3B 43 30 0F 83 8B 09 00 00 40 88 30 48 83 C0 01 48 89 43 28 41 83 C7 01 48 83 EA 01 75 D5 0F 1F 44 00 00 8B 54 24 48 85 D2 0F 8E 98 00 00 00 4C 8B 74 24 50 48 63 44 24 48 4D 29 DE 4C 2B 5C 24 50 49 01 C6 49 39 C3 4C 0F 4F D8 45 85 ED 0F 85 DF 03 00 00 48 8B 6C 24 50 44 89 FA 29 EA 4D 85 DB 74 2B 0F B6 75 00 48 8B 43 28 48 83 C5 01 48 3B 43 30 0F 83 AA 0B 00 00 40 88 30 48 83 C0 01 48 89 43 28 49 83 EB 01 44 8D 3C 2A 75 D5 4D 85 F6 0F 8E FA 03 00 00 4C 89 F2 BE 30 00 00 00 48 89 DF 48 89 4C 24 28 4C 89 4C 24 20 E8 ?? ?? ?? ?? 4C 8B 4C 24 20 48 8B 4C 24 28 4C 39 F0 0F 85 17 F6 FF FF 41 01 C7 41 8B 74 24 08 83 C6 0F 45 85 ED 0F 84 CB 03 00 00 48 8B 83 A0 00 00 00 48 85 C0 0F 84 AF 0A 00 00 48 8B 50 20 48 3B 50 28 0F 83 A1 0A 00 00 83 FE FF 89 32 40 0F 94 C6 48 83 C2 04 48 89 50 20 40 84 F6 0F 85 CB F5 FF FF 83 7C 24 78 01 19 F6 83 E6 FE 83 C6 2D 45 85 ED 0F 84 BD 03 00 00 48 8B 83 A0 00 00 00 48 85 C0 0F 84 90 0B 00 00 48 8B 50 20 48 3B 50 28 0F 83 82 0B 00 00 89 32 48 83 C2 04 48 89 50 20 48 8B 6C 24 58 41 83 C7 02 4C 29 CD 45 85 ED 0F 85 B8 03 00 00 48 85 ED 4D 89 CE 74 32 0F 1F 84 00 00 00 00 00 41 0F B6 16 48 8B 43 28 49 83 C6 01 48 3B 43 30 0F 83 BD 08 00 00 88 10 48 83 C0 01 48 89 43 28 41 83 C7 01 48 83 ED 01 75 D6 41 F6 44 24 0C 20 0F 84 38 F5 FF FF 41 8B 74 24 10 83 FE 30 0F 84 2A F5 FF FF 8B 44 24 70 85 C0 0F 8E 1E F5 FF FF 48 63 6C 24 70 45 85 ED 48 89 DF 48 89 EA 0F 84 06 06 00 00 E8 ?? ?? ?? ?? 48 39 C5 0F 85 F6 F4 FF FF 44 03 7C 24 70 E9 F2 F4 FF FF 0F 1F 40 00 48 8B 43 28 48 3B 43 30 0F 83 50 09 00 00 C6 00 2B 48 83 C0 01 48 89 43 28 E9 C3 F5 FF FF 66 90 3D FE 03 00 00 7E 49 44 8D 90 01 FC FF FF C7 44 24 78 00 00 00 00 45 85 DB 0F 84 92 FA FF FF 4D 63 C2 E9 43 F8 FF FF 66 0F 1F 84 00 00 00 00 00 48 8B 43 28 48 3B 43 30 0F 83 3C 09 00 00 C6 00 20 48 83 C0 01 48 89 43 28 E9 73 F5 FF FF 66 90 41 BA FF 03 00 00 C7 44 24 78 01 00 00 00 41 29 C2 EB B3 0F 1F 44 00 00 48 8B 83 A0 00 00 00 8B 74 24 44 48 85 C0 0F 84 39 06 00 00 48 8B 50 20 48 3B 50 28 0F 83 2B 06 00 00 83 FE FF 89 32 40 0F 94 C6 48 83 C2 04 48 89 50 20 40 84 F6 0F 85 24 F4 FF FF 45 8D 78 02 E9 63 FD FF FF 0F 1F 00 45 31 FF E9 B9 FB FF FF 0F 1F 84 00 00 00 00 00 31 FF F6 C2 50 B8 FD FF FF FF 40 0F 95 C7 29 F8 E9 D6 FA FF FF 0F 1F 00 41 0F B6 44 24 0C A8 40 0F 84 DA 00 00 00 45 85 ED 0F 84 98 02 00 00 48 8B 83 A0 00 00 00 48 85 C0 0F 84 EC 09 00 00 48 8B 50 20 48 3B 50 28 0F 83 DE 09 00 00 C7 02 2B 00 00 00 48 83 C2 04 48 89 50 20 E9 94 FB FF FF 48 8B 43 28 48 3B 43 30 0F 83 69 07 00 00 C6 00 30 48 83 C0 01 48 89 43 28 E9 AF FB FF FF 66 90 48 8B 43 28 48 3B 43 30 0F 83 A0 08 00 00 40 88 30 48 83 C0 01 48 89 43 28 E9 D8 FB FF FF 66 90 48 8B 43 28 48 3B 43 30 0F 83 47 07 00 00 0F B6 54 24 60 48 83 C0 01 88 50 FF 48 89 43 28 E9 11 FC FF FF 0F 1F 44 00 00 F6 C2 08 0F 85 32 FA FF FF E9 69 FA FF FF 66 2E 0F 1F 84 00 00 00 00 00 48 8B 43 28 48 3B 43 30 0F 83 29 09 00 00 C6 00 2D 48 83 C0 01 48 89 43 28 E9 F6 FA FF FF 66 90 A8 10 0F 84 F0 FA FF FF 45 85 ED 0F 84 72 03 00 00 48 8B 83 A0 00 00 00 48 85 C0 0F 84 CB 07 00 00 48 8B 50 20 48 3B 50 28 0F 83 BD 07 00 00 C7 02 20 00 00 00 48 83 C2 04 48 89 50 20 E9 B2 FA FF FF 66 0F 1F 44 00 00 41 F6 44 24 0C 08 0F 84 A0 FC FF FF E9 8B FB FF FF 0F 1F 80 00 00 00 00 4D 85 DB 75 19 E9 DB 05 00 00 66 0F 1F 44 00 00 41 83 C7 01 49 83 EB 01 0F 84 C7 05 00 00 48 8B 83 A0 00 00 00 8B 75 00 48 83 C5 04 48 85 C0 0F 84 7E 05 00 00 48 8B 50 20 48 3B 50 28 0F 83 70 05 00 00 83 FE FF 89 32 40 0F 94 C6 48 83 C2 04 48 89 50 20 40 84 F6 74 B7 E9 4A F2 FF FF 41 8B 74 24 08 83 C6 0F 66 2E 0F 1F 84 00 00 00 00 00 48 8B 43 28 48 3B 43 30 0F 83 DD 07 00 00 40 88 30 48 83 C0 01 48 89 43 28 E9 4F FC FF FF 66 90 3D 01 40 00 00 0F 8E 72 02 00 00 44 8D 90 FE BF FF FF C7 44 24 78 00 00 00 00 E9 47 FD FF FF 90 48 8B 43 28 48 3B 43 30 0F 83 6E 07 00 00 40 88 30 48 83 C0 01 48 89 43 28 E9 4D FC FF FF 66 90 44 89 DF 2B 7C 24 50 4D 63 C2 89 7C 24 48 E9 10 F8 FF FF 0F 1F 44 00 00 48 85 ED 0F 84 79 FC FF FF 49 89 CE EB 18 66 2E 0F 1F 84 00 00 00 00 00 41 83 C7 01 48 83 ED 01 0F 84 5C FC FF FF 48 8B 83 A0 00 00 00 41 8B 36 49 83 C6 04 48 85 C0 0F 84 7A 04 00 00 48 8B 50 20 48 3B 50 28 0F 83 6C 04 00 00 83 FE FF 89 32 40 0F 94 C6 48 83 C2 04 48 89 50 20 40 84 F6 74 B7 E9 5A F1 FF FF E8 ?? }
	condition:
		$1
}

rule file_299_0_0 {
	meta:
		name = "__sched_setscheduler"
		size = 20
		refs = "000f __syscall_error"
	strings:
		$1 = { B8 90 00 00 00 0F 05 48 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_300_0_0 {
	meta:
		name = "_dl_runtime_resolve"
		size = 97
		refs = "0031 _dl_fixup"
	strings:
		$1 = { 48 83 EC 38 48 89 04 24 48 89 4C 24 08 48 89 54 24 10 48 89 74 24 18 48 89 7C 24 20 4C 89 44 24 28 4C 89 4C 24 30 48 8B 74 24 40 48 8B 7C 24 38 E8 ?? ?? ?? ?? 49 89 C3 4C 8B 4C 24 30 4C 8B 44 24 28 48 8B 7C 24 20 48 8B 74 24 18 48 8B 54 24 10 48 8B 4C 24 08 48 8B 04 24 48 83 C4 48 41 FF E3 }
	condition:
		$1
}

rule file_300_1_0 {
	meta:
		name = "_dl_runtime_profile"
		size = 1373
		refs = "0162 _dl_profile_fixup 03e1 _dl_call_pltexit"
	strings:
		$1 = { 48 83 EC 20 48 89 1C 24 48 89 44 24 08 48 89 E3 48 83 E4 F0 48 81 EC 40 03 00 00 48 89 63 18 48 89 14 24 4C 89 44 24 08 4C 89 4C 24 10 48 89 4C 24 18 48 89 74 24 20 48 89 7C 24 28 48 89 6C 24 30 48 8D 43 30 48 89 44 24 38 0F 29 44 24 40 0F 29 4C 24 50 0F 29 54 24 60 0F 29 5C 24 70 0F 29 A4 24 80 00 00 00 0F 29 AC 24 90 00 00 00 0F 29 B4 24 A0 00 00 00 0F 29 BC 24 B0 00 00 00 83 3D ?? ?? ?? ?? 00 75 31 49 89 DB B8 01 00 00 00 0F A2 4C 89 DB 31 C0 81 E1 00 00 00 18 81 F9 00 00 00 18 75 08 31 C9 0F 01 D0 83 E0 06 83 E8 05 89 05 ?? ?? ?? ?? 83 F8 00 0F 88 92 03 00 00 C5 FE 7F 84 24 C0 00 00 00 C5 FE 7F 8C 24 00 01 00 00 C5 FE 7F 94 24 40 01 00 00 C5 FE 7F 9C 24 80 01 00 00 C5 FE 7F A4 24 C0 01 00 00 C5 FE 7F AC 24 00 02 00 00 C5 FE 7F B4 24 40 02 00 00 C5 FE 7F BC 24 80 02 00 00 C5 F9 7F 84 24 C0 02 00 00 C5 F9 7F 8C 24 D0 02 00 00 C5 F9 7F 94 24 E0 02 00 00 C5 F9 7F 9C 24 F0 02 00 00 C5 F9 7F A4 24 00 03 00 00 C5 F9 7F AC 24 10 03 00 00 C5 F9 7F B4 24 20 03 00 00 C5 F9 7F BC 24 30 03 00 00 48 89 E1 48 8B 53 30 48 8B 73 28 48 8B 7B 20 4C 8D 43 10 E8 ?? ?? ?? ?? 49 89 C3 48 8B 43 08 48 8B 14 24 4C 8B 44 24 08 4C 8B 4C 24 10 0F 28 44 24 40 0F 28 4C 24 50 0F 28 54 24 60 0F 28 5C 24 70 0F 28 A4 24 80 00 00 00 0F 28 AC 24 90 00 00 00 0F 28 B4 24 A0 00 00 00 0F 28 BC 24 B0 00 00 00 C4 62 79 29 84 24 C0 02 00 00 C4 C1 79 D7 F0 81 FE FF FF 00 00 74 0B C5 F9 7F 84 24 C0 00 00 00 EB 0F C5 FE 6F 84 24 C0 00 00 00 C5 F9 7F 44 24 40 C4 62 71 29 84 24 D0 02 00 00 C4 C1 79 D7 F0 81 FE FF FF 00 00 74 0B C5 F9 7F 8C 24 00 01 00 00 EB 0F C5 FE 6F 8C 24 00 01 00 00 C5 F9 7F 4C 24 50 C4 62 69 29 84 24 E0 02 00 00 C4 C1 79 D7 F0 81 FE FF FF 00 00 74 0B C5 F9 7F 94 24 40 01 00 00 EB 0F C5 FE 6F 94 24 40 01 00 00 C5 F9 7F 54 24 60 C4 62 61 29 84 24 F0 02 00 00 C4 C1 79 D7 F0 81 FE FF FF 00 00 74 0B C5 F9 7F 9C 24 80 01 00 00 EB 0F C5 FE 6F 9C 24 80 01 00 00 C5 F9 7F 5C 24 70 C4 62 59 29 84 24 00 03 00 00 C4 C1 79 D7 F0 81 FE FF FF 00 00 74 0B C5 F9 7F A4 24 C0 01 00 00 EB 12 C5 FE 6F A4 24 C0 01 00 00 C5 F9 7F A4 24 80 00 00 00 C4 62 51 29 84 24 10 03 00 00 C4 C1 79 D7 F0 81 FE FF FF 00 00 74 0B C5 F9 7F AC 24 00 02 00 00 EB 12 C5 FE 6F AC 24 00 02 00 00 C5 F9 7F AC 24 90 00 00 00 C4 62 49 29 84 24 20 03 00 00 C4 C1 79 D7 F0 81 FE FF FF 00 00 74 0B C5 F9 7F B4 24 40 02 00 00 EB 12 C5 FE 6F B4 24 40 02 00 00 C5 F9 7F B4 24 A0 00 00 00 C4 62 41 29 84 24 30 03 00 00 C4 C1 79 D7 F0 81 FE FF FF 00 00 74 0B C5 F9 7F BC 24 80 02 00 00 EB 12 C5 FE 6F BC 24 80 02 00 00 C5 F9 7F BC 24 B0 00 00 00 4C 8B 53 10 4D 85 D2 79 1D 48 8B 4C 24 18 48 8B 74 24 20 48 8B 7C 24 28 48 89 DC 48 8B 1C 24 48 83 C4 30 41 FF E3 48 8D 73 38 49 83 C2 08 49 83 E2 F0 4C 89 D1 4C 29 D4 48 89 E7 48 C1 E9 03 F3 48 A5 48 8B 4F 18 48 8B 77 20 48 8B 7F 28 41 FF D3 48 8B 63 18 48 81 EC F0 00 00 00 48 89 E1 48 89 01 48 89 51 08 0F 29 41 10 0F 29 49 20 C5 FE 7F 41 50 C5 FE 7F 89 90 00 00 00 C5 F9 7F 81 D0 00 00 00 C5 F9 7F 89 E0 00 00 00 DB 79 30 DB 79 40 48 8B 53 18 48 8B 73 28 48 8B 7B 20 E8 ?? ?? ?? ?? 48 8B 04 24 48 8B 54 24 08 0F 28 44 24 10 0F 28 4C 24 20 C4 E2 79 29 94 24 D0 00 00 00 C5 F9 D7 F2 81 FE FF FF 00 00 75 06 C5 FE 6F 44 24 50 C4 E2 71 29 94 24 E0 00 00 00 C5 F9 D7 F2 81 FE FF FF 00 00 75 09 C5 FE 6F 8C 24 90 00 00 00 DB 6C 24 40 DB 6C 24 30 48 89 DC 48 8B 1C 24 48 83 C4 30 C3 66 0F 1F 84 00 00 00 00 00 48 89 E1 48 8B 53 30 48 8B 73 28 48 8B 7B 20 4C 8D 43 10 E8 ?? ?? ?? ?? 49 89 C3 48 8B 43 08 48 8B 14 24 4C 8B 44 24 08 4C 8B 4C 24 10 0F 28 44 24 40 0F 28 4C 24 50 0F 28 54 24 60 0F 28 5C 24 70 0F 28 A4 24 80 00 00 00 0F 28 AC 24 90 00 00 00 0F 28 B4 24 A0 00 00 00 0F 28 BC 24 B0 00 00 00 4C 8B 53 10 4D 85 D2 79 1D 48 8B 4C 24 18 48 8B 74 24 20 48 8B 7C 24 28 48 89 DC 48 8B 1C 24 48 83 C4 30 41 FF E3 48 8D 73 38 49 83 C2 08 49 83 E2 F0 4C 89 D1 4C 29 D4 48 89 E7 48 C1 E9 03 F3 48 A5 48 8B 4F 18 48 8B 77 20 48 8B 7F 28 41 FF D3 48 8B 63 18 48 81 EC D0 00 00 00 48 89 E1 48 89 01 48 89 51 08 0F 29 41 10 0F 29 49 20 DB 79 30 DB 79 40 48 8B 53 18 48 8B 73 28 48 8B 7B 20 E8 ?? ?? ?? ?? 48 8B 04 24 48 8B 54 24 08 0F 28 44 24 10 0F 28 4C 24 20 DB 6C 24 40 DB 6C 24 30 48 89 DC 48 8B 1C 24 48 83 C4 30 C3 }
	condition:
		$1
}

rule file_301_0_0 {
	meta:
		name = "__difftime"
		size = 31
	strings:
		$1 = { 48 89 7C 24 E8 DF 6C 24 E8 48 89 74 24 E8 DF 6C 24 E8 DE E9 DD 5C 24 F0 F2 0F 10 44 24 F0 C3 }
	condition:
		$1
}

rule file_302_0_0 {
	meta:
		name = "__correctly_grouped_prefixmb"
		size = 613
		refs = "0029 strlen"
	strings:
		$1 = { 41 57 49 89 F7 41 56 41 55 41 54 55 53 48 83 EC 18 48 85 C9 48 89 4C 24 08 0F 84 C1 00 00 00 48 89 FD 48 89 D7 48 89 D3 E8 ?? ?? ?? ?? 49 39 EF 0F 86 A3 00 00 00 4C 8D 60 FF 48 8D 7D FF 4D 8D 57 FF 4C 39 D5 0F 87 95 00 00 00 44 0F B6 0B 4F 8D 04 27 EB 10 0F 1F 00 49 83 EA 01 49 83 E8 01 49 39 FA 74 7B 45 38 48 FF 75 ED 0F B6 43 01 84 C0 74 2D 41 3A 40 FE 75 DF 48 8D 43 02 4C 89 C2 EB 17 66 0F 1F 44 00 00 0F B6 72 FD 48 83 C0 01 48 83 EA 01 40 38 F1 75 BF 0F B6 08 84 C9 75 E8 4C 39 D5 4C 89 14 24 77 37 48 8B 54 24 08 4C 89 F9 4C 29 D1 48 0F BE 02 0F BE D0 83 C2 01 48 63 D2 48 39 D1 74 2C 4D 89 D7 7E 05 4D 8D 7C 02 01 4C 39 FD 0F 82 65 FF FF FF 49 39 EF 4C 0F 42 FD 48 83 C4 18 4C 89 F8 5B 5D 41 5C 41 5D 41 5E 41 5F C3 4C 8B 74 24 08 4D 0F BE 6E 01 49 8D 46 01 45 84 ED 0F 85 ED 00 00 00 0F 1F 80 00 00 00 00 4D 0F BE 2E 45 84 ED 4D 8D 42 FF 78 7B 41 80 FD 7F 74 75 4C 39 C5 0F 87 34 01 00 00 4D 01 E2 45 84 C9 0F 84 0A 01 00 00 4D 89 C3 45 3A 4A FF 0F 85 D3 00 00 00 48 8D 43 01 4C 89 D1 EB 17 66 90 0F B6 71 FE 48 83 C0 01 48 83 E9 01 40 38 F2 0F 85 B3 00 00 00 0F B6 10 84 D2 75 E4 4C 39 DD 4D 89 DA 0F 87 D9 00 00 00 4D 29 D8 4D 39 E8 0F 84 73 FF FF FF 4C 8B 3C 24 49 83 EF 01 E9 3F FF FF FF 0F 1F 80 00 00 00 00 4C 39 C5 0F 87 3F FF FF FF 4D 01 E2 45 84 C9 74 2F 45 3A 4A FF 75 51 48 8D 43 01 4C 89 D1 EB 19 0F 1F 84 00 00 00 00 00 0F B6 71 FE 48 83 C0 01 48 83 E9 01 40 38 F2 75 2F 0F B6 10 84 D2 75 E8 4C 39 C5 4D 89 C2 0F 87 FC FE FF FF 4D 0F BE 6E 01 49 8D 46 01 45 84 ED 0F 84 1A FF FF FF 49 89 C6 E9 16 FF FF FF 66 90 49 83 E8 01 49 83 EA 01 4C 39 C7 75 9C E9 CE FE FF FF 66 0F 1F 44 00 00 49 83 EB 01 49 83 EA 01 4C 39 DF 0F 85 12 FF FF FF 49 29 F8 4D 39 C5 0F 8D AB FE FF FF 4C 8B 3C 24 49 83 EF 01 E9 8E FE FF FF 4D 89 C3 4D 89 C2 4C 39 DD 0F 86 27 FF FF FF 4D 29 D0 EB D6 66 2E 0F 1F 84 00 00 00 00 00 45 31 C0 EB C7 }
	condition:
		$1
}

rule file_304_0_0 {
	meta:
		name = "add_pad"
		size = 111
		refs = "005b memset"
	strings:
		$1 = { 48 89 5C 24 F0 48 89 6C 24 F8 48 83 EC 18 48 8B 07 83 FE 01 48 89 FD 48 63 DE 48 8D 50 F0 74 48 85 F6 75 1C 48 01 D8 48 8B 5C 24 08 48 89 45 00 48 8B 6C 24 10 48 83 C4 18 C3 66 0F 1F 44 00 00 C6 44 17 10 01 8D 56 FE 48 01 F8 48 8D 78 02 88 50 01 8D 56 FE 31 F6 48 63 D2 E8 ?? ?? ?? ?? 48 8B 45 00 EB BF 0F 1F 00 C6 44 17 10 00 EB B5 }
	condition:
		$1
}

rule file_304_1_0 {
	meta:
		name = "option_alloc"
		size = 211
		refs = "00be __assert_fail"
	strings:
		$1 = { 8D 42 FF 48 89 5C 24 E8 4C 89 64 24 F8 48 89 6C 24 F0 48 83 EC 18 48 89 FB 83 F8 01 41 89 F4 76 05 83 FA 04 75 7A 83 F9 07 77 7A 48 8B 3B 89 FE 83 EE 10 0F 84 89 00 00 00 21 C6 48 89 DF 29 F2 21 C2 8D 34 0A E8 46 FF FF FF 48 8B 2B 49 63 F4 48 89 DF 48 01 EE 48 89 33 F7 DE 83 E6 07 E8 2D FF FF FF 48 8B 13 F6 C2 07 75 3E 48 83 EA 10 48 C1 EA 03 83 EA 01 81 FA FF 00 00 00 7F 27 48 8D 04 2B 88 53 11 48 8B 1C 24 48 8B 6C 24 08 4C 8B 64 24 10 48 83 C4 18 C3 0F 1F 84 00 00 00 00 00 83 FA 08 74 81 31 C0 EB DC B9 ?? ?? ?? ?? BA D4 00 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C7 02 BE 02 00 00 00 48 89 3B E9 66 FF FF FF }
	condition:
		$1
}

rule file_304_2_0 {
	meta:
		name = "get_opt_end"
		size = 70
	strings:
		$1 = { 48 39 D6 73 3B 80 3E 00 74 26 48 8D 46 02 48 39 C2 72 2D 0F B6 46 01 48 8D 44 06 02 48 39 C2 72 1F 48 89 07 31 C0 C3 66 0F 1F 84 00 00 00 00 00 48 83 C6 01 31 C0 48 89 37 C3 66 0F 1F 44 00 00 B8 FF FF FF FF C3 }
	condition:
		$1
}

rule file_304_4_0 {
	meta:
		name = "inet6_option_init"
		size = 43
	strings:
		$1 = { 83 FA 3B 75 1B 48 C7 07 10 00 00 00 C7 47 08 29 00 00 00 31 C0 89 57 0C 48 89 3E C3 0F 1F 40 00 83 FA 36 74 E0 B8 FF FF FF FF C3 }
	condition:
		$1
}

rule file_304_5_0 {
	meta:
		name = "inet6_option_append"
		size = 71
		refs = "0030 memcpy"
	strings:
		$1 = { 55 BD 01 00 00 00 53 48 89 F3 48 83 EC 08 80 3E 00 74 07 0F B6 6E 01 83 C5 02 89 EE E8 6F FE FF FF 48 85 C0 74 1A 48 63 D5 48 89 DE 48 89 C7 E8 ?? ?? ?? ?? 31 C0 48 83 C4 08 5B 5D C3 0F 1F 00 B8 FF FF FF FF EB EF }
	condition:
		$1
}

rule file_304_7_0 {
	meta:
		name = "inet6_option_next"
		size = 196
	strings:
		$1 = { 83 7F 08 29 0F 85 B6 00 00 00 48 89 5C 24 E8 48 89 6C 24 F0 48 89 F3 4C 89 64 24 F8 48 83 EC 28 8B 47 0C 83 F8 3B 75 70 48 8B 07 48 83 F8 11 76 6F 0F B6 57 11 48 8D 14 D5 18 00 00 00 48 39 D0 72 5E 48 8B 33 48 8D 2C 17 48 85 F6 74 62 48 83 C7 12 48 39 FE 72 49 4C 8D 64 24 08 48 89 EA 4C 89 E7 E8 A9 FE FF FF 85 C0 75 35 48 8B 74 24 08 48 89 33 48 89 EA 4C 89 E7 E8 92 FE FF FF 48 8B 5C 24 10 48 8B 6C 24 18 4C 8B 64 24 20 48 83 C4 28 C3 66 0F 1F 44 00 00 83 F8 36 74 8B 0F 1F 00 B8 FF FF FF FF EB D7 66 0F 1F 84 00 00 00 00 00 48 8D 77 12 4C 8D 64 24 08 48 89 74 24 08 EB B0 83 C8 FF C3 }
	condition:
		$1
}

rule file_304_8_0 {
	meta:
		name = "inet6_option_find"
		size = 225
	strings:
		$1 = { 83 7F 08 29 0F 85 D1 00 00 00 41 56 49 89 F6 41 55 41 89 D5 41 54 55 53 48 83 EC 10 8B 47 0C 83 F8 3B 0F 85 A8 00 00 00 48 8B 07 48 83 F8 11 76 5E 0F B6 57 11 48 8D 2C D5 18 00 00 00 48 39 E8 72 4D 49 8B 36 48 01 FD 48 85 F6 74 73 48 83 C7 12 48 39 FE 72 39 4C 8D 64 24 08 48 89 EA 4C 89 E7 E8 DA FD FF FF 85 C0 74 0E EB 23 0F 1F 40 00 0F B6 03 44 39 E8 74 30 48 8B 5C 24 08 48 89 EA 48 89 DE 4C 89 E7 E8 B5 FD FF FF 85 C0 74 E1 48 83 C4 10 B8 FF FF FF FF 5B 5D 41 5C 41 5D 41 5E C3 0F 1F 80 00 00 00 00 49 89 1E 48 83 C4 10 31 C0 5B 5D 41 5C 41 5D 41 5E C3 66 0F 1F 44 00 00 48 8D 5F 12 4C 8D 64 24 08 48 89 5C 24 08 EB AD 83 F8 36 0F 84 4F FF FF FF EB B4 83 C8 FF 66 90 C3 }
	condition:
		$1
}

rule file_305_0_0 {
	meta:
		name = "wcsrchr"
		size = 772
	strings:
		$1 = { 66 48 0F 6E CE 48 89 F9 66 0F 62 C9 66 0F EF D2 66 0F 62 C9 48 83 E1 3F 48 83 F9 30 77 52 F3 0F 6F 07 66 0F 76 D0 66 0F 76 C1 66 0F D7 CA 66 0F D7 C0 48 83 C7 10 48 85 C0 75 15 48 85 C9 0F 85 BC 02 00 00 48 83 E7 F0 4D 31 C0 EB 73 0F 1F 00 48 85 C9 0F 85 FD 01 00 00 49 89 C0 48 89 FE 48 83 E7 F0 EB 5B 66 66 2E 0F 1F 84 00 00 00 00 00 48 83 E1 0F 48 83 E7 F0 66 0F EF DB 66 0F 6F 07 66 0F 76 D8 66 0F 76 C1 66 0F D7 D3 66 0F D7 C0 48 D3 EA 48 D3 E8 48 83 C7 10 48 85 C0 75 11 48 85 D2 0F 85 58 02 00 00 4D 31 C0 EB 13 0F 1F 00 48 85 D2 0F 85 97 01 00 00 49 89 C0 48 8D 34 0F 66 0F 6F 07 66 0F 76 D0 48 83 C7 10 66 0F 76 C1 66 0F D7 CA 66 0F D7 C0 48 09 C1 75 63 66 0F 6F 1F 66 0F 76 D3 48 83 C7 10 66 0F 76 D9 66 0F D7 CA 66 0F D7 C3 48 09 C1 75 46 66 0F 6F 27 66 0F 76 D4 48 83 C7 10 66 0F 76 E1 66 0F D7 CA 66 0F D7 C4 48 09 C1 75 29 66 0F 6F 2F 66 0F 76 D5 48 83 C7 10 66 0F 76 E9 66 0F D7 CA 66 0F D7 C5 48 09 C1 74 8C 66 66 66 2E 0F 1F 84 00 00 00 00 00 48 85 C0 75 3B 4D 85 C0 0F 84 B2 01 00 00 4C 89 C0 48 89 F7 F6 C4 F0 0F 85 93 01 00 00 84 E4 0F 85 7B 01 00 00 A8 F0 0F 85 63 01 00 00 48 8D 47 F0 C3 66 66 66 66 66 2E 0F 1F 84 00 00 00 00 00 66 0F D7 CA 48 85 C9 75 17 49 89 C0 48 89 FE E9 2C FF FF FF 66 66 66 2E 0F 1F 84 00 00 00 00 00 F6 C1 0F 75 3B 84 C9 75 57 F6 C5 0F 75 72 48 25 FF 1F 00 00 74 8F F6 C4 F0 0F 85 31 01 00 00 84 E4 0F 85 19 01 00 00 A8 F0 0F 85 01 01 00 00 48 8D 47 F0 C3 66 66 66 2E 0F 1F 84 00 00 00 00 00 48 A9 01 00 00 00 0F 84 59 FF FF FF 48 8D 47 F0 C3 66 66 66 66 66 66 2E 0F 1F 84 00 00 00 00 00 48 83 E0 1F 0F 84 3B FF FF FF A8 F0 0F 85 BE 00 00 00 48 8D 47 F0 C3 66 0F 1F 84 00 00 00 00 00 48 25 FF 01 00 00 0F 84 19 FF FF FF 84 E4 0F 85 AC 00 00 00 A8 F0 0F 85 94 00 00 00 48 8D 47 F0 C3 66 66 66 66 66 66 2E 0F 1F 84 00 00 00 00 00 48 01 CF 48 89 D1 F6 C1 0F 75 35 84 C9 75 41 F6 C5 0F 75 4C 48 25 FF 1F 00 00 0F 84 90 00 00 00 F6 C4 F0 75 7B 84 E4 75 67 A8 F0 75 53 48 8D 47 F0 C3 66 66 66 66 66 2E 0F 1F 84 00 00 00 00 00 48 A9 01 00 00 00 74 68 48 8D 47 F0 C3 0F 1F 00 48 83 E0 1F 74 5A A8 F0 75 26 48 8D 47 F0 C3 90 48 25 FF 01 00 00 74 48 84 E4 75 24 A8 F0 75 10 48 8D 47 F0 C3 66 66 2E 0F 1F 84 00 00 00 00 00 48 8D 47 F4 C3 66 66 2E 0F 1F 84 00 00 00 00 00 48 8D 47 F8 C3 66 66 2E 0F 1F 84 00 00 00 00 00 48 8D 47 FC C3 66 66 2E 0F 1F 84 00 00 00 00 00 48 31 C0 C3 }
	condition:
		$1
}

rule file_306_0_0 {
	meta:
		name = "__getcontext"
		size = 144
		refs = "0089 __syscall_error"
	strings:
		$1 = { 48 89 9F 80 00 00 00 48 89 6F 78 4C 89 67 48 4C 89 6F 50 4C 89 77 58 4C 89 7F 60 48 89 7F 68 48 89 77 70 48 89 97 88 00 00 00 48 89 8F 98 00 00 00 4C 89 47 28 4C 89 4F 30 48 8B 0C 24 48 89 8F A8 00 00 00 48 8D 4C 24 08 48 89 8F A0 00 00 00 48 8D 8F A8 01 00 00 48 89 8F E0 00 00 00 D9 31 D9 21 0F AE 9F C0 01 00 00 48 8D 97 28 01 00 00 31 F6 31 FF 41 BA 08 00 00 00 B8 0E 00 00 00 0F 05 48 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? 31 C0 C3 }
	condition:
		$1
}

rule file_307_0_0 {
	meta:
		name = "splice"
		size = 87
		refs = "0002 __libc_multiple_threads 0025 __libc_enable_asynccancel 003f __libc_disable_asynccancel 001b __syscall_error"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 75 17 49 89 CA B8 13 01 00 00 0F 05 48 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 48 83 EC 08 E8 ?? ?? ?? ?? 48 89 04 24 49 89 CA B8 13 01 00 00 0F 05 48 8B 3C 24 48 89 C2 E8 ?? ?? ?? ?? 48 89 D0 48 83 C4 08 48 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_307_1_0 {
	meta:
		name = "__splice_nocancel"
		size = 23
		refs = "0012 __syscall_error"
	strings:
		$1 = { 49 89 CA B8 13 01 00 00 0F 05 48 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_308_0_0 {
	meta:
		name = "__wcsrtombs"
		size = 749
		refs = "0043 _nl_current_LC_CTYPE 00af __wcsnlen 00c6 _dl_mcount_wrapper_check 012a __libc_errno 018d __wcslen 024a __assert_fail 029a _nl_C_LC_CTYPE 02a4 __wcsmbs_load_conv 02cb __wcsmbs_gconv_fcts_c"
	strings:
		$1 = { 48 89 5C 24 D0 48 89 6C 24 D8 B8 ?? ?? ?? ?? 4C 89 6C 24 E8 4C 89 74 24 F0 49 89 F5 4C 89 64 24 E0 4C 89 7C 24 F8 48 81 EC A8 01 00 00 48 85 C9 48 C7 44 24 60 00 00 00 00 49 89 FE 48 0F 44 C8 48 8B 05 ?? ?? ?? ?? 48 89 D5 48 89 4C 24 50 C7 44 24 44 00 00 00 00 C7 44 24 48 01 00 00 00 C7 44 24 40 01 00 00 00 64 48 8B 00 48 8B 18 48 8B 43 28 48 85 C0 0F 84 1C 02 00 00 4C 8B 60 10 49 83 3C 24 00 49 8B 5C 24 28 74 0D 48 C1 CB 11 64 48 33 1C 25 30 00 00 00 4D 85 F6 0F 84 DF 00 00 00 4D 8B 7D 00 48 89 EE 4C 01 F5 4C 89 FF E8 ?? ?? ?? ?? 4D 8D 7C 87 04 48 89 DF 48 89 6C 24 38 4C 89 74 24 30 E8 ?? ?? ?? ?? 45 31 C0 C7 44 24 08 01 00 00 00 C7 04 24 00 00 00 00 4C 8D 4C 24 28 4C 89 F9 4C 89 EA 48 8D 74 24 30 4C 89 E7 FF D3 41 89 C0 48 8B 44 24 30 48 89 C5 4C 29 F5 41 F7 C0 FB FF FF FF 0F 85 12 01 00 00 80 78 FF 00 0F 84 3A 01 00 00 41 83 F8 05 74 20 45 85 C0 74 1B 41 83 F8 04 74 15 48 8B 05 ?? ?? ?? ?? 48 C7 C5 FF FF FF FF 64 C7 00 54 00 00 00 48 89 E8 48 8B 9C 24 78 01 00 00 48 8B AC 24 80 01 00 00 4C 8B A4 24 88 01 00 00 4C 8B AC 24 90 01 00 00 4C 8B B4 24 98 01 00 00 4C 8B BC 24 A0 01 00 00 48 81 C4 A8 01 00 00 C3 66 0F 1F 84 00 00 00 00 00 49 8B 6D 00 4C 8D 6C 24 70 48 89 EF E8 ?? ?? ?? ?? 4C 8D 74 85 04 48 8B 44 24 50 48 89 6C 24 20 31 ED 48 8B 00 48 89 44 24 10 48 8D 44 24 10 48 89 44 24 50 48 8D 84 24 70 01 00 00 48 89 44 24 38 0F 1F 80 00 00 00 00 48 89 DF 4C 89 6C 24 30 E8 ?? ?? ?? ?? 45 31 C0 48 8D 54 24 20 C7 44 24 08 01 00 00 00 C7 04 24 00 00 00 00 4C 8D 4C 24 28 4C 89 F1 48 8D 74 24 30 4C 89 E7 FF D3 41 89 C0 48 8B 44 24 30 48 89 C2 4C 29 EA 48 01 D5 41 83 F8 05 74 B3 41 F7 C0 FB FF FF FF 74 5A 41 8D 40 FA 83 F8 01 0F 86 EB FE FF FF 41 83 F8 05 0F 84 07 FF FF FF B9 ?? ?? ?? ?? BA 8B 00 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 66 90 49 39 C6 74 5C 48 8B 44 24 50 8B 00 85 C0 75 74 49 C7 45 00 00 00 00 00 48 83 ED 01 E9 A5 FE FF FF 0F 1F 80 00 00 00 00 80 78 FF 00 74 EA B9 ?? ?? ?? ?? BA 63 00 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 81 FB ?? ?? ?? ?? 74 2A 48 89 DF E8 ?? ?? ?? ?? 48 8B 43 28 E9 CA FD FF FF B9 ?? ?? ?? ?? BA 7F 00 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 A7 FD FF FF B9 ?? ?? ?? ?? BA 80 00 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_309_0_0 {
	meta:
		name = "__brk"
		size = 86
		refs = "0015 __curbrk 002b __libc_errno"
	strings:
		$1 = { B8 0C 00 00 00 0F 05 48 3D 00 F0 FF FF 48 89 C2 77 2A 48 89 05 ?? ?? ?? ?? 31 C0 48 39 D7 77 08 F3 C3 66 0F 1F 44 00 00 48 8B 05 ?? ?? ?? ?? 64 C7 00 0C 00 00 00 B8 FF FF FF FF C3 48 8B 05 ?? ?? ?? ?? F7 DA 48 C7 05 ?? ?? ?? ?? FF FF FF FF 64 89 10 31 C0 C3 }
	condition:
		$1
}

rule file_311_0_0 {
	meta:
		name = "putw"
		size = 42
		refs = "001b _IO_fwrite"
	strings:
		$1 = { 48 83 EC 18 48 89 F1 BA 01 00 00 00 89 7C 24 0C 48 8D 7C 24 0C BE 04 00 00 00 E8 ?? ?? ?? ?? 48 83 F8 01 19 C0 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_312_0_0 {
	meta:
		name = "__wctype_l"
		size = 145
		refs = "0018 strlen 0058 memcmp"
	strings:
		$1 = { 41 57 41 56 49 89 FE 41 55 41 54 45 31 E4 55 53 48 89 F3 48 83 EC 08 E8 ?? ?? ?? ?? 4C 8B 3B 49 89 C5 49 8B 9F 90 00 00 00 EB 13 0F 1F 44 00 00 48 8D 5C 2B 01 80 3B 00 74 46 41 83 C4 01 48 89 DF E8 ?? ?? ?? ?? 49 39 C5 48 89 C5 75 E2 4C 89 EA 48 89 DE 4C 89 F7 E8 ?? ?? ?? ?? 85 C0 75 D0 45 03 A7 C8 00 00 00 4B 8B 44 E7 40 48 83 C4 08 5B 5D 41 5C 41 5D 41 5E 41 5F C3 0F 1F 44 00 00 48 83 C4 08 31 C0 5B 5D 41 5C 41 5D 41 5E 41 5F C3 }
	condition:
		$1
}

rule file_313_0_0 {
	meta:
		name = "free_database_entries"
		size = 97
		refs = "002d free 0032 __tdestroy"
	strings:
		$1 = { 41 54 48 85 FF 49 89 FC 55 53 74 50 0F 1F 40 00 49 8B 5C 24 08 48 85 DB 75 09 EB 2A 0F 1F 40 00 48 89 EB 48 8B 7B 28 48 85 FF 74 0A BE ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 2B 48 89 DF E8 ?? ?? ?? ?? 48 85 ED 75 DA 49 8B 1C 24 4C 89 E7 E8 ?? ?? ?? ?? 48 85 DB 74 05 49 89 DC EB B4 5B 5D 41 5C C3 }
	condition:
		$1
}

rule file_313_1_0 {
	meta:
		name = "known_compare"
		size = 19
		refs = "000c strcmp"
	strings:
		$1 = { 48 39 F7 74 0B 48 8B 36 48 8B 3F E9 ?? ?? ?? ?? 31 C0 C3 }
	condition:
		$1
}

rule file_313_2_0 {
	meta:
		name = "nss_parse_service_list"
		size = 1021
		refs = "0014 __libc_tsd_CTYPE_B 008f malloc 00b1 mempcpy 0209 __strncasecmp 03b7 free"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 48 89 FD 53 48 83 EC 28 48 8B 05 ?? ?? ?? ?? 48 8D 54 24 18 48 C7 44 24 18 00 00 00 00 64 4C 8B 20 48 89 54 24 08 90 0F B6 45 00 48 0F BE D0 41 F6 44 54 01 20 0F 85 05 01 00 00 84 C0 0F 84 6F 03 00 00 3C 5B 0F 84 67 03 00 00 48 89 EB EB 17 0F 1F 80 00 00 00 00 48 0F BE D0 41 F6 44 54 01 20 75 0F 3C 5B 74 0B 48 83 C3 01 0F B6 03 84 C0 75 E5 48 39 DD 0F 84 37 03 00 00 49 89 DD 49 29 ED 49 8D 7D 39 E8 ?? ?? ?? ?? 48 85 C0 49 89 C7 0F 84 1C 03 00 00 48 8D 78 38 4C 89 EA 48 89 EE 48 89 DD 48 89 78 30 E8 ?? ?? ?? ?? C6 00 00 49 C7 47 28 00 00 00 00 41 C7 47 08 00 00 00 00 41 C7 47 0C 00 00 00 00 41 C7 47 10 00 00 00 00 41 C7 47 14 01 00 00 00 41 C7 47 18 01 00 00 00 49 C7 47 20 00 00 00 00 49 C7 07 00 00 00 00 0F B6 03 48 0F BE D0 41 F6 44 54 01 20 74 1E 66 2E 0F 1F 84 00 00 00 00 00 48 83 C5 01 0F B6 45 00 48 0F BE D0 41 F6 44 54 01 20 75 EC 3C 5B 74 30 48 8B 44 24 08 4C 89 7C 24 08 4C 89 38 0F B6 45 00 48 0F BE D0 41 F6 44 54 01 20 0F 84 FB FE FF FF 48 83 C5 01 E9 DE FE FF FF 66 0F 1F 44 00 00 48 83 C5 01 0F B6 45 00 84 C0 74 0C 48 0F BE D0 41 F6 44 54 01 20 75 E8 48 8B 15 ?? ?? ?? ?? 64 4C 8B 22 45 31 ED 3C 21 41 0F 94 C5 75 08 0F B6 45 01 48 83 C5 01 84 C0 0F 84 1D 02 00 00 48 0F BE D0 41 F6 44 54 01 20 0F 85 0D 02 00 00 3C 3D 0F 84 05 02 00 00 3C 5D 0F 84 FD 01 00 00 48 89 EB EB 1B 0F 1F 44 00 00 48 0F BE C2 41 F6 44 44 01 20 75 15 80 FA 3D 74 10 80 FA 5D 74 0B 48 83 C3 01 0F B6 13 84 D2 75 DF 48 89 D8 48 29 E8 48 83 F8 07 0F 84 6F 01 00 00 48 83 F8 08 0F 85 B8 01 00 00 BA 08 00 00 00 BE ?? ?? ?? ?? 48 89 EF E8 ?? ?? ?? ?? 45 31 F6 85 C0 74 30 BA 08 00 00 00 BE ?? ?? ?? ?? 48 89 EF E8 ?? ?? ?? ?? 85 C0 0F 85 85 01 00 00 41 BE FE FF FF FF EB 0E 66 2E 0F 1F 84 00 00 00 00 00 48 83 C3 01 0F B6 03 48 0F BE D0 41 F6 44 54 01 20 75 ED 3C 3D 0F 85 58 01 00 00 0F 1F 44 00 00 48 83 C3 01 0F B6 03 48 0F BE D0 41 F6 44 54 01 20 75 ED 84 C0 48 89 DF 0F 84 35 01 00 00 3C 3D 0F 84 2D 01 00 00 3C 5D 75 24 66 0F 1F 44 00 00 E9 1E 01 00 00 0F 1F 00 48 0F BE C2 41 F6 44 44 01 20 75 15 80 FA 3D 74 10 80 FA 5D 74 0B 48 83 C3 01 0F B6 13 84 D2 75 DF 48 89 D8 48 29 F8 48 83 F8 06 0F 84 D7 00 00 00 48 83 F8 08 48 89 DD 0F 85 DD 00 00 00 BA 08 00 00 00 BE ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 0F 85 C6 00 00 00 41 83 C6 02 45 85 ED 4D 63 F6 74 57 43 8B 54 B7 08 41 89 47 08 41 89 47 0C 41 89 47 10 41 89 47 14 43 89 54 B7 08 0F B6 03 48 0F BE D0 41 F6 44 54 01 20 74 1A 66 0F 1F 44 00 00 48 83 C5 01 0F B6 45 00 48 0F BE D0 41 F6 44 54 01 20 75 EC 3C 5D 0F 84 8C 00 00 00 0F B6 45 00 E9 2E FE FF FF 0F 1F 00 43 89 44 B7 08 EB BC 66 0F 1F 84 00 00 00 00 00 BA 07 00 00 00 BE ?? ?? ?? ?? 48 89 EF E8 ?? ?? ?? ?? 85 C0 74 6A BA 07 00 00 00 BE ?? ?? ?? ?? 48 89 EF E8 ?? ?? ?? ?? 85 C0 75 27 41 BE FF FF FF FF E9 AD FE FF FF 66 0F 1F 84 00 00 00 00 00 BA 06 00 00 00 BE ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 3D 4C 89 FF E8 ?? ?? ?? ?? 48 8B 44 24 18 48 83 C4 28 5B 5D 41 5C 41 5D 41 5E 41 5F C3 90 48 83 C5 01 E9 4F FD FF FF 0F 1F 80 00 00 00 00 41 BE 01 00 00 00 E9 59 FE FF FF 0F 1F 44 00 00 48 89 DD B8 01 00 00 00 E9 F0 FE FF FF }
	condition:
		$1
}

rule file_313_3_0 {
	meta:
		name = "_L_lock_854"
		size = 31
		refs = "000f __lll_lock_wait_private"
	strings:
		$1 = { 48 8D 3D ?? ?? ?? ?? 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 99 F6 FF FF }
	condition:
		$1
}

rule file_313_4_0 {
	meta:
		name = "_L_unlock_865"
		size = 31
		refs = "000f __lll_unlock_wake_private"
	strings:
		$1 = { 48 8D 3D ?? ?? ?? ?? 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 A4 F6 FF FF }
	condition:
		$1
}

rule file_313_5_0 {
	meta:
		name = "_L_unlock_954"
		size = 31
		refs = "000f __lll_unlock_wake_private"
	strings:
		$1 = { 48 8D 3D ?? ?? ?? ?? 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 1C F7 FF FF }
	condition:
		$1
}

rule file_313_6_0 {
	meta:
		name = "_L_lock_1421"
		size = 31
		refs = "000f __lll_lock_wait_private"
	strings:
		$1 = { 48 8D 3D ?? ?? ?? ?? 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 57 FA FF FF }
	condition:
		$1
}

rule file_313_7_0 {
	meta:
		name = "_L_unlock_1430"
		size = 31
		refs = "000f __lll_unlock_wake_private"
	strings:
		$1 = { 48 8D 3D ?? ?? ?? ?? 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 6D FA FF FF }
	condition:
		$1
}

rule file_313_8_0 {
	meta:
		name = "_L_lock_1487"
		size = 31
		refs = "000f __lll_lock_wait_private"
	strings:
		$1 = { 48 8D 3D ?? ?? ?? ?? 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 B6 FA FF FF }
	condition:
		$1
}

rule file_313_9_0 {
	meta:
		name = "_L_unlock_1522"
		size = 31
		refs = "000f __lll_unlock_wake_private"
	strings:
		$1 = { 48 8D 3D ?? ?? ?? ?? 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 F9 FA FF FF }
	condition:
		$1
}

rule file_313_10_0 {
	meta:
		name = "__nss_database_lookup"
		size = 960
		refs = "0034 __libc_multiple_threads 00d8 strcmp 0184 malloc 01c1 _IO_new_fopen 0238 __getline 025e __strchrnul 0274 __libc_tsd_CTYPE_B 02fb strlen 0331 memcpy 0383 free 038b _IO_new_fclose"
	strings:
		$1 = { 48 89 5C 24 D0 48 89 6C 24 D8 48 89 CB 4C 89 64 24 E0 4C 89 6C 24 E8 49 89 F4 4C 89 74 24 F0 4C 89 7C 24 F8 48 89 FD 48 83 EC 68 BE 01 00 00 00 31 C0 83 3D ?? ?? ?? ?? 00 74 10 F0 0F B1 35 ?? ?? ?? ?? 0F 85 57 09 00 00 EB 0D 0F B1 35 ?? ?? ?? ?? 0F 85 48 09 00 00 48 83 3B 00 74 52 83 3D ?? ?? ?? ?? 00 74 0F F0 FF 0D ?? ?? ?? ?? 0F 85 4B 09 00 00 EB 0C FF 0D ?? ?? ?? ?? 0F 85 3D 09 00 00 31 C0 48 8B 5C 24 38 48 8B 6C 24 40 4C 8B 64 24 48 4C 8B 6C 24 50 4C 8B 74 24 58 4C 8B 7C 24 60 48 83 C4 68 C3 66 0F 1F 84 00 00 00 00 00 4C 8B 35 ?? ?? ?? ?? 49 89 D5 4D 85 F6 0F 84 F3 00 00 00 4D 8B 3E 4D 85 FF 74 24 0F 1F 44 00 00 49 8B 77 10 48 89 EF E8 ?? ?? ?? ?? 85 C0 75 07 49 8B 47 08 48 89 03 4D 8B 3F 4D 85 FF 75 E1 48 83 3B 00 74 33 83 3D ?? ?? ?? ?? 00 74 0F F0 FF 0D ?? ?? ?? ?? 0F 85 D3 08 00 00 EB 0C FF 0D ?? ?? ?? ?? 0F 85 C5 08 00 00 48 83 3B 01 19 C0 E9 60 FF FF FF 0F 1F 40 00 4D 85 E4 74 31 49 8B 2E 48 85 ED 74 29 0F 1F 00 48 8B 75 10 4C 89 E7 E8 ?? ?? ?? ?? 85 C0 75 07 48 8B 45 08 48 89 03 48 8B 6D 00 48 85 ED 75 E0 48 83 3B 00 75 97 4D 85 ED B8 ?? ?? ?? ?? 4C 0F 44 E8 4C 89 EF E8 8E FA FF FF 48 85 C0 48 89 03 0F 84 77 FF FF FF BF 19 00 00 00 E8 ?? ?? ?? ?? 48 85 C0 0F 84 64 FF FF FF 48 8B 15 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 48 89 10 48 8B 13 48 C7 40 10 ?? ?? ?? ?? 48 89 50 08 E9 3F FF FF FF BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 85 C0 49 89 C7 0F 84 DF 01 00 00 81 08 00 80 00 00 BF 10 00 00 00 E8 ?? ?? ?? ?? 48 85 C0 49 89 C6 0F 84 BB 01 00 00 48 C7 00 00 00 00 00 48 C7 40 08 00 00 00 00 48 C7 44 24 20 00 00 00 00 48 C7 44 24 28 00 00 00 00 48 C7 44 24 10 00 00 00 00 EB 11 0F 1F 80 00 00 00 00 41 F6 07 10 0F 85 53 01 00 00 48 8D 74 24 28 48 8D 7C 24 20 4C 89 FA E8 ?? ?? ?? ?? 48 85 C0 0F 88 38 01 00 00 48 8B 7C 24 20 48 8D 44 07 FF 80 38 0A 0F 84 18 01 00 00 BE 23 00 00 00 E8 ?? ?? ?? ?? C6 00 00 48 8B 74 24 20 0F B6 06 84 C0 74 AF 48 8B 15 ?? ?? ?? ?? 64 48 8B 0A 48 0F BE D0 F6 44 51 01 20 74 23 66 0F 1F 84 00 00 00 00 00 48 83 C6 01 0F B6 06 48 0F BE D0 F6 44 51 01 20 75 EE 84 C0 0F 84 76 FF FF FF 3C 3A 0F 84 6E FF FF FF 48 89 F2 EB 0D 66 0F 1F 84 00 00 00 00 00 3C 3A 74 1A 48 83 C2 01 0F B6 02 84 C0 0F 84 4D FF FF FF 48 0F BE F8 F6 44 79 01 20 74 E2 48 39 F2 0F 84 39 FF FF FF C6 02 00 48 89 F7 48 83 C2 01 48 89 34 24 48 89 54 24 18 E8 ?? ?? ?? ?? 48 8D 50 01 48 8D 78 19 48 89 54 24 08 E8 ?? ?? ?? ?? 48 85 C0 48 8B 54 24 08 48 8B 34 24 0F 84 FD FE FF FF 48 8D 78 18 48 89 78 10 48 89 44 24 08 E8 ?? ?? ?? ?? 48 8B 7C 24 18 E8 C1 F8 FF FF 48 83 7C 24 10 00 48 8B 4C 24 08 48 89 41 08 48 C7 01 00 00 00 00 74 44 48 8B 44 24 10 48 89 4C 24 10 48 89 08 E9 B7 FE FF FF 0F 1F 80 00 00 00 00 C6 00 00 48 8B 7C 24 20 E9 DB FE FF FF 48 8B 7C 24 20 E8 ?? ?? ?? ?? 4C 89 FF E8 ?? ?? ?? ?? 4C 89 35 ?? ?? ?? ?? E9 28 FD FF FF 49 89 0E 48 89 4C 24 10 E9 78 FE FF FF 4C 89 FF E8 ?? ?? ?? ?? 48 C7 05 ?? ?? ?? ?? 00 00 00 00 E9 98 FD FF FF }
	condition:
		$1
}

rule file_313_11_0 {
	meta:
		name = "__nss_configure_lookup"
		size = 246
		refs = "002b strcmp 0043 __libc_errno 008f __libc_multiple_threads 00bf __nss_database_custom"
	strings:
		$1 = { 41 55 49 89 F5 41 54 49 89 FC 55 53 31 DB 48 83 EC 08 66 0F 1F 44 00 00 48 8D 2C 5B 4C 89 E7 48 C1 E5 03 48 8D B5 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 F8 00 74 34 7C 0A 48 83 C3 01 48 83 FB 0E 75 D8 48 8B 05 ?? ?? ?? ?? 41 BC FF FF FF FF 64 C7 00 16 00 00 00 48 83 C4 08 44 89 E0 5B 5D 41 5C 41 5D C3 66 0F 1F 44 00 00 45 31 E4 48 83 BD ?? ?? ?? ?? 00 74 DF 4C 89 EF E8 C3 F7 FF FF 48 85 C0 49 89 C0 74 BB BE 01 00 00 00 44 89 E0 83 3D ?? ?? ?? ?? 00 74 10 F0 0F B1 35 ?? ?? ?? ?? 0F 85 99 05 00 00 EB 0D 0F B1 35 ?? ?? ?? ?? 0F 85 8A 05 00 00 48 8B 85 ?? ?? ?? ?? 4C 89 00 C6 83 ?? ?? ?? ?? 01 83 3D ?? ?? ?? ?? 00 74 0F F0 FF 0D ?? ?? ?? ?? 0F 85 82 05 00 00 EB 0C FF 0D ?? ?? ?? ?? 0F 85 74 05 00 00 48 83 C4 08 44 89 E0 5B 5D 41 5C 41 5D C3 }
	condition:
		$1
}

rule file_313_12_0 {
	meta:
		name = "__nss_lookup_function"
		size = 803
		refs = "002c __libc_multiple_threads 0065 __tsearch 00d6 malloc 0120 strlen 0156 stpcpy 0165 strcpy 0176 __libc_dlsym 01f8 strcmp 021f __tdelete 0227 free 0249 __libc_errno 0291 __libc_dlopen_mode"
	strings:
		$1 = { 55 31 C0 48 89 E5 4C 89 65 E0 48 89 5D D8 49 89 FC 4C 89 6D E8 4C 89 75 F0 4C 89 7D F8 48 83 EC 40 48 89 75 C8 BE 01 00 00 00 83 3D ?? ?? ?? ?? 00 74 10 F0 0F B1 35 ?? ?? ?? ?? 0F 85 3A 05 00 00 EB 0D 0F B1 35 ?? ?? ?? ?? 0F 85 2B 05 00 00 4D 8D 7C 24 28 4C 8D 6D C8 BA ?? ?? ?? ?? 4C 89 FE 4C 89 EF E8 ?? ?? ?? ?? 48 85 C0 0F 84 2E 01 00 00 48 89 C3 48 8B 00 4C 39 E8 74 53 48 8B 50 08 48 C1 CA 11 64 48 33 14 25 30 00 00 00 83 3D ?? ?? ?? ?? 00 74 0F F0 FF 0D ?? ?? ?? ?? 0F 85 F6 04 00 00 EB 0C FF 0D ?? ?? ?? ?? 0F 85 E8 04 00 00 48 89 D0 48 8B 5D D8 4C 8B 65 E0 4C 8B 6D E8 4C 8B 75 F0 4C 8B 7D F8 C9 C3 0F 1F 44 00 00 BF 10 00 00 00 E8 ?? ?? ?? ?? 48 85 C0 49 89 C6 0F 84 2D 01 00 00 48 89 03 49 8B 5C 24 20 48 8B 45 C8 48 85 DB 49 89 06 0F 84 B2 00 00 00 48 8B 43 08 48 85 C0 0F 84 27 01 00 00 31 D2 48 83 F8 FF 74 6E 4D 8B 7C 24 30 48 89 65 C0 4C 89 FF E8 ?? ?? ?? ?? 4C 8B 6D C8 48 89 C3 4C 89 EF E8 ?? ?? ?? ?? 48 8D 44 03 16 4C 89 FE 48 83 E0 F0 48 29 C4 48 8D 7C 24 05 C7 04 24 5F 6E 73 73 66 C7 44 24 04 5F 00 E8 ?? ?? ?? ?? 48 8D 78 01 4C 89 EE C6 00 5F E8 ?? ?? ?? ?? 49 8B 44 24 20 48 89 E6 48 8B 78 08 E8 ?? ?? ?? ?? 48 8B 65 C0 48 89 C2 48 89 D0 64 48 33 04 25 30 00 00 00 48 C1 C0 11 49 89 46 08 E9 F4 FE FF FF 66 0F 1F 44 00 00 31 D2 E9 E7 FE FF FF 66 0F 1F 84 00 00 00 00 00 49 8B 54 24 30 48 8B 05 ?? ?? ?? ?? 48 89 55 C0 48 85 C0 BA ?? ?? ?? ?? 48 0F 44 C2 48 8B 58 08 48 85 DB 75 1B E9 43 01 00 00 66 0F 1F 44 00 00 48 8B 43 10 48 85 C0 0F 84 C9 00 00 00 48 89 C3 48 8B 75 C0 48 8B 3B E8 ?? ?? ?? ?? 85 C0 75 E0 49 89 5C 24 20 E9 F4 FE FF FF 49 C7 44 24 20 00 00 00 00 BA ?? ?? ?? ?? 4C 89 FE 4C 89 EF E8 ?? ?? ?? ?? 4C 89 F7 E8 ?? ?? ?? ?? 31 D2 E9 5C FE FF FF 49 8B 5C 24 30 49 89 E5 48 89 DF E8 ?? ?? ?? ?? 48 83 C0 1C 48 8B 15 ?? ?? ?? ?? 48 89 DE 48 83 E0 F0 48 29 C4 48 B8 6C 69 62 6E 73 73 5F 00 48 8D 7C 24 07 64 44 8B 3A 48 89 04 24 E8 ?? ?? ?? ?? C7 00 2E 73 6F 00 C6 40 05 00 BE 01 00 00 80 66 C7 40 03 2E 32 49 8B 5C 24 20 48 89 E7 E8 ?? ?? ?? ?? 48 89 43 08 49 8B 44 24 20 48 83 78 08 00 74 63 49 8B 44 24 20 4C 89 EC 48 8B 40 08 E9 55 FE FF FF 48 83 C3 10 BF 18 00 00 00 E8 ?? ?? ?? ?? 48 85 C0 48 89 03 0F 84 3A FF FF FF 48 8B 55 C0 48 89 10 48 8B 03 48 C7 40 08 00 00 00 00 48 8B 03 48 C7 40 10 00 00 00 00 48 8B 1B 48 85 DB 49 89 5C 24 20 0F 85 00 FE FF FF E9 10 FF FF FF 0F 1F 44 00 00 48 8B 15 ?? ?? ?? ?? 48 C7 40 08 FF FF FF FF 64 44 89 3A EB 88 48 8D 58 08 EB 97 }
	condition:
		$1
}

rule file_313_13_0 {
	meta:
		name = "__nss_next2"
		size = 230
		refs = "0045 __nss_lookup_function 00e2 __libc_fatal"
	strings:
		$1 = { 41 55 49 89 D5 41 54 49 89 F4 55 48 89 CD 53 48 89 FB 48 83 EC 08 45 85 C9 0F 84 81 00 00 00 48 8B 07 48 BA 01 00 00 00 01 00 00 00 48 39 50 08 0F 84 9A 00 00 00 48 8B 38 48 85 FF 74 4A 48 89 3B 4C 89 E6 E8 ?? ?? ?? ?? 48 85 C0 48 89 45 00 74 0E 48 83 C4 08 31 C0 5B 5D 41 5C 41 5D C3 90 4D 85 ED 74 14 48 8B 3B 4C 89 EE E8 ?? ?? ?? ?? 48 85 C0 48 89 45 00 75 D9 48 8B 03 8B 50 0C 85 D2 74 B3 0F 1F 44 00 00 48 83 C4 08 B8 FF FF FF FF 5B 5D 41 5C 41 5D C3 0F 1F 84 00 00 00 00 00 41 83 C0 02 41 83 F8 04 77 32 48 8B 07 4D 63 C0 42 83 7C 80 08 01 0F 85 7A FF FF FF 48 83 C4 08 B8 01 00 00 00 5B 5D 41 5C 41 5D C3 0F 1F 40 00 48 39 50 10 0F 85 5C FF FF FF EB E0 BF ?? ?? ?? ?? E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_313_14_0 {
	meta:
		name = "__nss_lookup"
		size = 192
		refs = "001a __nss_lookup_function"
	strings:
		$1 = { 41 55 49 89 D5 41 54 49 89 F4 55 48 89 CD 53 48 89 FB 48 83 EC 08 48 8B 3F E8 ?? ?? ?? ?? 48 85 C0 48 89 45 00 74 19 66 0F 1F 84 00 00 00 00 00 48 83 C4 08 31 C0 5B 5D 41 5C 41 5D C3 0F 1F 00 4D 85 ED 75 07 EB 14 4D 85 ED 74 14 48 8B 3B 4C 89 EE E8 ?? ?? ?? ?? 48 89 45 00 48 85 C0 75 D0 48 8B 03 8B 48 0C 85 C9 75 26 48 8B 38 48 85 FF 74 3E 48 89 3B 4C 89 E6 E8 ?? ?? ?? ?? 48 85 C0 48 89 45 00 75 AA EB BF 0F 1F 84 00 00 00 00 00 48 83 38 00 74 1A 48 83 C4 08 B8 FF FF FF FF 5B 5D 41 5C 41 5D C3 66 2E 0F 1F 84 00 00 00 00 00 48 83 C4 08 B8 01 00 00 00 5B 5D 41 5C 41 5D C3 }
	condition:
		$1
}

rule file_313_15_0 {
	meta:
		name = "free_defconfig"
		size = 34
	strings:
		$1 = { 48 8B 3D ?? ?? ?? ?? 48 85 FF 74 14 48 C7 05 ?? ?? ?? ?? 00 00 00 00 E9 ?? ?? ?? ?? 0F 1F 40 00 F3 C3 }
	condition:
		$1
}

rule file_313_16_0 {
	meta:
		name = "free_mem"
		size = 117
		refs = "0038 free 0053 __libc_dlclose"
	strings:
		$1 = { 41 54 4C 8B 25 ?? ?? ?? ?? 55 4D 85 E4 53 74 60 49 8B 3C 24 48 C7 05 ?? ?? ?? ?? 00 00 00 00 E8 ?? ?? ?? ?? 49 8B 5C 24 08 48 85 DB 75 16 EB 30 48 8B 6B 10 48 89 DF E8 ?? ?? ?? ?? 48 85 ED 74 1F 48 89 EB 48 8B 7B 08 48 8D 57 FF 48 83 FA FD 77 DE E8 ?? ?? ?? ?? EB D7 0F 1F 80 00 00 00 00 5B 5D 4C 89 E7 41 5C E9 ?? ?? ?? ?? 0F 1F 40 00 5B 5D 41 5C C3 }
	condition:
		$1
}

rule file_313_17_0 {
	meta:
		name = "__nss_next"
		size = 16
		refs = "000c __nss_next2"
	strings:
		$1 = { 45 89 C1 41 89 C8 48 89 D1 31 D2 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_314_0_0 {
	meta:
		name = "__sleep"
		size = 448
		refs = "005b __sigprocmask 00bb __sigaction 00ed __nanosleep 0123 __libc_errno 01bc __pthread_unwind"
	strings:
		$1 = { 48 89 5C 24 E8 48 89 6C 24 F0 4C 89 64 24 F8 48 81 EC C8 01 00 00 85 FF 0F 84 69 01 00 00 48 8D 5C 24 10 89 FF 31 C0 48 89 3C 24 B9 10 00 00 00 48 8D 94 24 90 00 00 00 48 89 DF 48 89 DE 48 C7 44 24 08 00 00 00 00 F3 48 AB 31 FF 48 C7 44 24 10 00 00 01 00 BD FF FF FF FF E8 ?? ?? ?? ?? 85 C0 74 25 89 E8 48 8B 9C 24 B0 01 00 00 48 8B AC 24 B8 01 00 00 4C 8B A4 24 C0 01 00 00 48 81 C4 C8 01 00 00 C3 0F 1F 00 48 8B 84 24 90 00 00 00 25 00 00 01 00 75 4F B9 10 00 00 00 48 89 DF 48 8D 94 24 10 01 00 00 F3 48 AB 31 F6 BF 11 00 00 00 48 C7 44 24 10 00 00 01 00 E8 ?? ?? ?? ?? 85 C0 78 5D 48 83 BC 24 10 01 00 00 01 0F 84 7E 00 00 00 48 8D B4 24 90 00 00 00 31 D2 BF 02 00 00 00 E8 ?? ?? ?? ?? 48 89 E6 48 89 E7 E8 ?? ?? ?? ?? 89 C3 85 DB 74 19 31 ED 48 81 7C 24 08 FF 64 CD 1D 40 0F 9F C5 03 2C 24 E9 55 FF FF FF 66 90 31 ED E9 4C FF FF FF 66 0F 1F 84 00 00 00 00 00 48 8B 1D ?? ?? ?? ?? 48 8D B4 24 90 00 00 00 31 D2 BF 02 00 00 00 64 44 8B 23 E8 ?? ?? ?? ?? 64 44 89 23 E9 1B FF FF FF 0F 1F 84 00 00 00 00 00 48 89 E6 48 89 E7 E8 ?? ?? ?? ?? 48 8B 2D ?? ?? ?? ?? 48 8D B4 24 90 00 00 00 31 D2 BF 02 00 00 00 89 C3 64 44 8B 65 00 E8 ?? ?? ?? ?? 64 44 89 65 00 E9 6C FF FF FF 64 8B 04 25 08 03 00 00 83 E0 B9 83 F8 08 0F 85 75 FF FF FF 64 48 C7 04 25 30 06 00 00 FF FF FF FF F0 64 83 0C 25 08 03 00 00 10 64 48 8B 3C 25 00 03 00 00 E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_316_0_0 {
	meta:
		name = "skip_string"
		size = 66
		refs = "000d __libc_tsd_CTYPE_B"
	strings:
		$1 = { 0F B6 17 48 89 F8 84 D2 74 36 48 8B 0D ?? ?? ?? ?? 64 48 8B 31 EB 1E 66 0F 1F 84 00 00 00 00 00 80 FA 23 74 1B 80 FA 2C 74 16 48 83 C0 01 0F B6 10 84 D2 74 0B 48 0F BE CA F6 44 4E 01 20 74 E0 F3 C3 }
	condition:
		$1
}

rule file_316_1_0 {
	meta:
		name = "arg_trimdomain_list"
		size = 388
		refs = "001f _res_hconf 0045 __strndup 005b __libc_tsd_CTYPE_B 0107 _libc_intl_domainname 010c __dcgettext 0127 __asprintf 013e __fxprintf 0148 free"
	strings:
		$1 = { 41 57 41 56 41 55 41 89 F5 41 54 49 89 FC 55 BD 30 00 08 00 53 48 89 D3 48 83 EC 18 44 8B 35 ?? ?? ?? ?? 48 89 DF E8 85 FF FF FF 48 89 C6 49 89 C7 48 29 DE 41 83 FE 03 0F 8F BE 00 00 00 48 89 DF 4C 89 FB E8 ?? ?? ?? ?? 49 63 D6 41 83 C6 01 48 89 04 D5 ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? 44 89 35 ?? ?? ?? ?? 41 0F B6 0F 64 48 8B 10 48 0F BE C1 F6 44 42 01 20 74 19 0F 1F 80 00 00 00 00 48 83 C3 01 0F B6 0B 48 0F BE C1 F6 44 42 01 20 75 EE 80 F9 3B 77 43 48 89 E8 48 D3 E0 48 85 C0 79 38 0F B6 43 01 48 8D 73 01 48 89 F3 48 0F BE C8 F6 44 4A 01 20 74 1A 0F 1F 84 00 00 00 00 00 48 83 C3 01 0F B6 03 48 0F BE C8 F6 44 4A 01 20 75 EE 3C 23 74 7A 84 C0 74 76 0F B6 03 3C 23 90 74 08 84 C0 0F 85 39 FF FF FF 48 83 C4 18 48 89 D8 5B 5D 41 5C 41 5D 41 5E 41 5F C3 BA 05 00 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 7C 24 08 48 89 C6 41 B8 04 00 00 00 31 C0 44 89 E9 4C 89 E2 E8 ?? ?? ?? ?? 85 C0 78 1D 48 8B 54 24 08 31 FF BE ?? ?? ?? ?? 31 C0 E8 ?? ?? ?? ?? 48 8B 7C 24 08 E8 ?? ?? ?? ?? 31 DB EB 9A BA 05 00 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 7C 24 08 48 89 C6 44 89 E9 31 C0 4C 89 E2 E8 ?? ?? ?? ?? 85 C0 79 B2 31 DB E9 66 FF FF FF }
	condition:
		$1
}

rule file_316_2_0 {
	meta:
		name = "arg_spoof.isra.1"
		size = 173
		refs = "002d _res_hconf 0052 __strncasecmp"
	strings:
		$1 = { 48 89 5C 24 E8 48 89 6C 24 F0 48 89 FD 4C 89 64 24 F8 48 83 EC 18 E8 05 FE FF FF 48 89 C2 48 89 C3 48 29 EA 48 83 FA 03 74 5E 44 8B 25 ?? ?? ?? ?? 44 89 E0 83 C8 06 48 83 FA 06 89 05 ?? ?? ?? ?? 74 1D 48 83 FA 04 75 17 BE ?? ?? ?? ?? 48 89 EF E8 ?? ?? ?? ?? 85 C0 74 15 66 0F 1F 44 00 00 44 89 E0 83 E0 FB 83 C8 02 89 05 ?? ?? ?? ?? 48 89 D8 48 8B 6C 24 08 48 8B 1C 24 4C 8B 64 24 10 48 83 C4 18 C3 0F 1F 00 BE ?? ?? ?? ?? 48 89 EF E8 ?? ?? ?? ?? 85 C0 44 8B 25 ?? ?? ?? ?? 75 C0 41 83 E4 F9 44 89 25 ?? ?? ?? ?? EB C2 }
	condition:
		$1
}

rule file_316_3_0 {
	meta:
		name = "arg_bool"
		size = 220
		refs = "0031 __strncasecmp 003b _res_hconf 0093 _libc_intl_domainname 0098 __dcgettext 00b0 __asprintf 00c7 __fxprintf 00d1 free"
	strings:
		$1 = { 48 89 5C 24 E0 48 89 D3 48 89 6C 24 E8 4C 89 64 24 F0 4C 89 6C 24 F8 49 89 FC 48 83 EC 38 41 89 F5 BA 02 00 00 00 BE ?? ?? ?? ?? 48 89 DF 89 CD E8 ?? ?? ?? ?? 85 C0 75 27 09 2D ?? ?? ?? ?? 48 8D 43 02 48 8B 5C 24 18 48 8B 6C 24 20 4C 8B 64 24 28 4C 8B 6C 24 30 48 83 C4 38 C3 0F 1F 40 00 BA 03 00 00 00 BE ?? ?? ?? ?? 48 89 DF E8 ?? ?? ?? ?? 85 C0 75 12 F7 D5 48 8D 43 03 21 2D ?? ?? ?? ?? EB BF 0F 1F 40 00 BA 05 00 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 7C 24 08 48 89 C6 49 89 D8 31 C0 44 89 E9 4C 89 E2 E8 ?? ?? ?? ?? 85 C0 78 1D 48 8B 54 24 08 31 FF BE ?? ?? ?? ?? 31 C0 E8 ?? ?? ?? ?? 48 8B 7C 24 08 E8 ?? ?? ?? ?? 31 C0 E9 67 FF FF FF }
	condition:
		$1
}

rule file_316_4_0 {
	meta:
		name = "do_init"
		size = 919
		refs = "0003 _res_hconf 0029 getenv 004e _IO_new_fopen 0080 fgets_unlocked 00a2 __strchrnul 00ac __libc_tsd_CTYPE_B 0120 __strncasecmp 0187 _libc_intl_domainname 018c __dcgettext 01a7 __asprintf 01c2 __fxprintf 01cc free 01db _IO_new_fclose"
	strings:
		$1 = { 41 57 BA ?? ?? ?? ?? 31 C0 48 89 D7 B9 09 00 00 00 41 56 41 55 41 54 55 53 48 81 EC 38 01 00 00 F3 48 AB BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 44 24 18 48 85 C0 B8 ?? ?? ?? ?? 48 0F 45 44 24 18 BE ?? ?? ?? ?? 48 89 C7 48 89 44 24 18 E8 ?? ?? ?? ?? 48 85 C0 48 89 44 24 10 0F 84 7F 01 00 00 81 08 00 80 00 00 C7 44 24 0C 00 00 00 00 66 90 48 8B 54 24 10 48 8D 7C 24 30 BE 00 01 00 00 E8 ?? ?? ?? ?? 48 85 C0 0F 84 48 01 00 00 48 8D 7C 24 30 BE 0A 00 00 00 83 44 24 0C 01 48 8D 5C 24 30 E8 ?? ?? ?? ?? C6 00 00 48 8B 05 ?? ?? ?? ?? 44 0F B6 44 24 30 64 4C 8B 30 49 0F BE C0 41 F6 44 46 01 20 74 1E 66 2E 0F 1F 84 00 00 00 00 00 48 83 C3 01 44 0F B6 03 49 0F BE C0 41 F6 44 46 01 20 75 EC 41 80 F8 23 74 86 45 84 C0 74 81 48 89 DF 45 31 ED E8 96 FB FF FF 49 89 C7 49 89 C4 49 29 DF 0F 1F 44 00 00 4D 89 EB 4C 89 FA 48 89 DF 49 C1 E3 04 49 8D AB ?? ?? ?? ?? 48 89 EE E8 ?? ?? ?? ?? 85 C0 75 4A 48 89 E8 8B 10 48 83 C0 04 44 8D 82 FF FE FE FE F7 D2 41 21 D0 41 81 E0 80 80 80 80 74 E5 44 89 C2 C1 EA 10 41 F7 C0 80 80 00 00 44 0F 44 C2 48 8D 50 02 48 0F 44 C2 45 00 C0 48 83 D8 03 48 29 E8 49 39 C7 0F 84 38 01 00 00 49 83 C5 01 49 83 FD 07 75 8C BA 05 00 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4C 24 0C 48 8B 54 24 18 48 8D 7C 24 28 48 89 C6 49 89 D8 31 C0 E8 ?? ?? ?? ?? 85 C0 0F 88 BD FE FF FF 48 8B 54 24 28 31 FF BE ?? ?? ?? ?? 31 C0 E8 ?? ?? ?? ?? 48 8B 7C 24 28 E8 ?? ?? ?? ?? E9 9B FE FF FF 48 8B 7C 24 10 E8 ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 85 C0 74 08 48 89 C7 E8 7A FC FF FF BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 85 C0 74 17 B9 10 00 00 00 48 89 C2 BE 01 00 00 00 BF ?? ?? ?? ?? E8 04 FD FF FF BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 85 C0 74 17 B9 08 00 00 00 48 89 C2 BE 01 00 00 00 BF ?? ?? ?? ?? E8 DE FC FF FF BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 85 C0 74 12 48 89 C2 BE 01 00 00 00 BF ?? ?? ?? ?? E8 7D FA FF FF BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 85 C0 74 1C 48 89 C2 BE 01 00 00 00 BF ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 00 00 00 00 E8 52 FA FF FF C7 05 ?? ?? ?? ?? 01 00 00 00 48 81 C4 38 01 00 00 5B 5D 41 5C 41 5D 41 5E 41 5F C3 49 0F BE 04 24 4C 89 EA 48 C1 E2 04 48 81 C2 ?? ?? ?? ?? 41 F6 44 46 01 20 74 14 0F 1F 00 49 83 C4 01 49 0F BE 04 24 41 F6 44 46 01 20 75 EF 0F B6 42 0B 3C 01 0F 84 8C 00 00 00 3C 02 0F 84 9A 00 00 00 3C 03 0F 85 7B FD FF FF 8B 4A 0C 8B 74 24 0C 4C 89 E2 48 8B 7C 24 18 E8 17 FC FF FF 48 89 C3 48 85 DB 0F 84 5B FD FF FF 0F B6 03 84 C0 0F 84 50 FD FF FF 48 8B 15 ?? ?? ?? ?? 64 48 8B 0A 48 0F BE D0 F6 44 51 01 20 74 24 66 2E 0F 1F 84 00 00 00 00 00 48 83 C3 01 0F B6 03 84 C0 0F 84 21 FD FF FF 48 0F BE D0 F6 44 51 01 20 75 E6 3C 23 0F 84 0E FD FF FF BA 05 00 00 00 BE ?? ?? ?? ?? E9 15 FE FF FF 8B 74 24 0C 48 8B 7C 24 18 4C 89 E2 E8 5E F9 FF FF 48 89 C3 EB 85 4C 89 E7 E8 E1 FA FF FF 48 89 C3 E9 75 FF FF FF }
	condition:
		$1
}

rule file_316_5_0 {
	meta:
		name = "_L_lock_1312"
		size = 31
		refs = "000f __lll_lock_wait_private"
	strings:
		$1 = { 48 8D 3D ?? ?? ?? ?? 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 04 FD FF FF }
	condition:
		$1
}

rule file_316_6_0 {
	meta:
		name = "_L_unlock_1512"
		size = 31
		refs = "000f __lll_unlock_wake_private"
	strings:
		$1 = { 48 8D 3D ?? ?? ?? ?? 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 90 FE FF FF }
	condition:
		$1
}

rule file_1498_0_0 {
	meta:
		name = "_L_lock_46"
		size = 31
		refs = "000f __lll_lock_wait_private"
	strings:
		$1 = { 48 8D 3D ?? ?? ?? ?? 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 90 FE FF FF }
	condition:
		$1
}

rule file_316_7_0 {
	meta:
		name = "_res_hconf_init"
		size = 47
		refs = "0001 __pthread_once"
	strings:
		$1 = { B8 ?? ?? ?? ?? 48 85 C0 74 0C BE ?? ?? ?? ?? BF ?? ?? ?? ?? FF E0 83 3D ?? ?? ?? ?? 00 74 01 C3 50 E8 3A FC FF FF 83 0D ?? ?? ?? ?? 02 5A C3 }
	condition:
		$1
}

rule file_316_8_0 {
	meta:
		name = "_res_hconf_reorder_addrs"
		size = 801
		refs = "0002 _res_hconf 00eb __libc_errno 0100 __socket 0114 __libc_multiple_threads 0146 __close 016e __ifreq 0193 malloc 0245 __ioctl 0290 realloc 02a6 free 031d __assert_fail"
	strings:
		$1 = { F6 05 ?? ?? ?? ?? 08 74 06 83 7F 10 02 74 01 C3 48 89 5C 24 D0 48 89 6C 24 D8 48 89 FB 4C 89 64 24 E0 4C 89 6C 24 E8 4C 89 74 24 F0 4C 89 7C 24 F8 48 83 EC 78 44 8B 0D ?? ?? ?? ?? 45 85 C9 0F 8E A3 00 00 00 4C 8B 5B 18 4D 8B 23 4D 85 E4 74 5F 41 8D 41 FF 4C 8B 05 ?? ?? ?? ?? 49 8D 6B 08 4D 89 E2 48 8D 04 40 49 8D 3C 80 45 85 C9 7E 2E 41 8B 32 41 8B 40 04 31 F0 41 85 40 08 74 59 4C 89 C0 EB 15 0F 1F 40 00 48 89 C2 48 83 C0 0C 8B 4A 10 31 F1 85 4A 14 74 3F 48 39 F8 75 EA 49 89 EB 48 83 C5 08 4C 8B 55 F8 4D 85 D2 75 BD 66 90 48 8B 5C 24 48 48 8B 6C 24 50 4C 8B 64 24 58 4C 8B 6C 24 60 4C 8B 74 24 68 4C 8B 7C 24 70 48 83 C4 78 C3 0F 1F 44 00 00 4D 89 23 48 8B 43 18 4C 89 10 EB CC 0F 1F 40 00 48 8B 05 ?? ?? ?? ?? 31 D2 BE 02 00 00 00 BF 02 00 00 00 64 44 8B 38 E8 ?? ?? ?? ?? 85 C0 41 89 C5 78 A5 BE 01 00 00 00 31 C0 83 3D ?? ?? ?? ?? 00 74 10 F0 0F B1 35 ?? ?? ?? ?? 0F 85 EC 02 00 00 EB 0D 0F B1 35 ?? ?? ?? ?? 0F 85 DD 02 00 00 8B 35 ?? ?? ?? ?? 85 F6 7E 1E 44 89 EF E8 ?? ?? ?? ?? 44 8B 0D ?? ?? ?? ?? 45 85 C9 0F 84 56 FF FF FF E9 E6 FE FF FF 90 48 8D 74 24 34 48 8D 7C 24 38 44 89 EA E8 ?? ?? ?? ?? 4C 8B 44 24 38 4D 85 C0 0F 84 68 01 00 00 48 63 44 24 34 4C 89 44 24 10 48 8D 3C 40 48 C1 E7 02 E8 ?? ?? ?? ?? 48 85 C0 48 89 05 ?? ?? ?? ?? 4C 8B 44 24 10 0F 84 52 01 00 00 8B 4C 24 34 85 C9 0F 8E 3A 01 00 00 48 89 5C 24 28 4C 89 C5 C7 44 24 1C 00 00 00 00 45 31 E4 45 31 F6 44 89 7C 24 24 44 89 6C 24 20 4C 89 C3 EB 1E 0F 1F 00 4B 8D 0C 76 4C 8D 3C 8D 00 00 00 00 48 83 C5 28 41 83 C4 01 44 39 64 24 34 7E 7C 66 83 7D 10 02 75 DE 4F 8D 0C 76 49 89 EB 8B 7C 24 20 49 29 DB 4C 8D 53 10 BE 1B 89 00 00 4E 8D 2C 8D 00 00 00 00 4C 01 E8 4D 89 EF C7 00 02 00 00 00 42 8B 54 1B 14 89 50 04 31 C0 48 89 EA 4C 89 54 24 08 4C 89 5C 24 10 E8 ?? ?? ?? ?? 85 C0 4C 8B 54 24 08 4C 8B 5C 24 10 48 8B 05 ?? ?? ?? ?? 78 8E 43 8B 54 13 04 83 44 24 1C 01 4C 63 74 24 1C 42 89 54 28 08 E9 69 FF FF FF 4C 89 F9 44 8B 6C 24 20 44 8B 7C 24 24 48 8B 5C 24 28 48 89 CE 48 89 C7 E8 ?? ?? ?? ?? 48 85 C0 48 89 05 ?? ?? ?? ?? 74 68 48 8B 7C 24 38 E8 ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? 64 44 89 38 8B 44 24 1C 89 05 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 74 0F F0 FF 0D ?? ?? ?? ?? 0F 85 5F 01 00 00 EB 0C FF 0D ?? ?? ?? ?? 0F 85 51 01 00 00 E9 5A FE FF FF C7 44 24 1C 00 00 00 00 EB B8 31 C9 C7 44 24 1C 00 00 00 00 EB 8B C7 44 24 1C 00 00 00 00 EB 98 B9 ?? ?? ?? ?? BA C7 01 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_316_9_0 {
	meta:
		name = "_res_hconf_trim_domain"
		size = 139
		refs = "0012 strlen 0019 _res_hconf 0055 __strcasecmp"
	strings:
		$1 = { 41 57 41 56 49 89 FE 41 55 41 54 55 53 48 83 EC 08 E8 ?? ?? ?? ?? 44 8B 2D ?? ?? ?? ?? 45 85 ED 7E 44 49 89 C4 31 DB 66 0F 1F 84 00 00 00 00 00 48 8B 2C DD ?? ?? ?? ?? 48 89 EF E8 ?? ?? ?? ?? 49 39 C4 76 18 4D 89 E7 48 89 EE 49 29 C7 4D 01 F7 4C 89 FF E8 ?? ?? ?? ?? 85 C0 74 1B 48 83 C3 01 41 39 DD 7F CA 48 83 C4 08 5B 5D 41 5C 41 5D 41 5E 41 5F C3 0F 1F 00 41 C6 07 00 48 83 C4 08 5B 5D 41 5C 41 5D 41 5E 41 5F C3 }
	condition:
		$1
}

rule file_316_10_0 {
	meta:
		name = "_res_hconf_trim_domains"
		size = 85
		refs = "0003 _res_hconf 001d _res_hconf_trim_domain"
	strings:
		$1 = { 44 8B 05 ?? ?? ?? ?? 45 85 C0 75 04 C3 0F 1F 00 55 48 89 FD 53 48 83 EC 08 48 8B 3F E8 ?? ?? ?? ?? 48 8B 45 08 48 8B 38 48 85 FF 74 21 BB 08 00 00 00 66 0F 1F 44 00 00 E8 ?? ?? ?? ?? 48 8B 45 08 48 8B 3C 18 48 83 C3 08 48 85 FF 75 EA 48 83 C4 08 5B 5D C3 }
	condition:
		$1
}

rule file_317_0_0 {
	meta:
		name = "__isoc99_vswscanf"
		size = 153
		refs = "000c _IO_wstr_jumps 0044 _IO_no_init 0051 _IO_fwide 0060 _IO_wstr_init_static 0075 _IO_vfwscanf"
	strings:
		$1 = { 48 89 5C 24 E8 48 89 6C 24 F0 41 B8 ?? ?? ?? ?? 4C 89 64 24 F8 48 81 EC 58 02 00 00 49 89 FC 48 8D 8C 24 F0 00 00 00 48 89 F3 48 89 D5 48 89 E7 31 D2 BE 00 80 00 00 48 C7 84 24 88 00 00 00 00 00 00 00 E8 ?? ?? ?? ?? 48 89 E7 BE 01 00 00 00 E8 ?? ?? ?? ?? 4C 89 E6 48 89 E7 31 C9 31 D2 E8 ?? ?? ?? ?? 48 89 EA 48 89 DE 48 89 E7 31 C9 83 4C 24 74 10 E8 ?? ?? ?? ?? 48 8B 9C 24 40 02 00 00 48 8B AC 24 48 02 00 00 4C 8B A4 24 50 02 00 00 48 81 C4 58 02 00 00 C3 }
	condition:
		$1
}

rule file_319_0_0 {
	meta:
		name = "flush_cleanup"
		size = 127
		refs = "002b __libc_multiple_threads"
	strings:
		$1 = { 48 8B 05 ?? ?? ?? ?? 48 85 C0 74 39 F7 00 00 80 00 00 75 31 48 8B 90 88 00 00 00 83 6A 04 01 75 24 48 C7 42 08 00 00 00 00 83 3D ?? ?? ?? ?? 00 74 0B F0 FF 0A 0F 85 05 1B 00 00 EB 08 FF 0A 0F 85 FB 1A 00 00 83 2D ?? ?? ?? ?? 01 75 2F 48 C7 05 ?? ?? ?? ?? 00 00 00 00 83 3D ?? ?? ?? ?? 00 74 0F F0 FF 0D ?? ?? ?? ?? 0F 85 EC 1A 00 00 EB 0C FF 0D ?? ?? ?? ?? 0F 85 DE 1A 00 00 F3 C3 }
	condition:
		$1
}

rule file_319_1_0 {
	meta:
		name = "_L_unlock_22"
		size = 27
		refs = "000b __lll_unlock_wake_private"
	strings:
		$1 = { 48 8D 3A 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 EA E4 FF FF }
	condition:
		$1
}

rule file_319_2_0 {
	meta:
		name = "_L_unlock_35"
		size = 31
		refs = "000f __lll_unlock_wake_private"
	strings:
		$1 = { 48 8D 3D ?? ?? ?? ?? 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 03 E5 FF FF }
	condition:
		$1
}

rule file_319_3_0 {
	meta:
		name = "save_for_backup"
		size = 476
		refs = "00c7 malloc 00fb memcpy 0111 free 0185 memmove 01b1 mempcpy"
	strings:
		$1 = { 41 57 41 56 41 55 49 89 F5 41 54 49 89 F4 55 48 89 FD 53 48 83 EC 28 4C 8B 4F 18 48 8B 47 60 4D 29 CD 48 85 C0 0F 84 30 01 00 00 4C 89 EB 48 89 C1 0F 1F 80 00 00 00 00 4C 63 41 10 48 8B 09 4C 39 C3 49 0F 4F D8 48 85 C9 75 ED 48 8B 75 58 48 8B 7D 48 4D 89 EE 49 29 DE 48 89 F2 48 29 FA 49 39 D6 77 4C 49 89 D7 4D 29 F7 48 85 DB 0F 88 05 01 00 00 4D 85 F6 0F 85 BC 00 00 00 49 01 FF 48 85 C0 4C 89 7D 50 44 89 EA 74 10 0F 1F 44 00 00 29 50 10 48 8B 00 48 85 C0 75 F5 31 C0 48 83 C4 28 5B 5D 41 5C 41 5D 41 5E 41 5F C3 0F 1F 40 00 49 8D 46 64 48 89 74 24 10 4C 89 4C 24 08 48 89 C7 48 89 44 24 18 E8 ?? ?? ?? ?? 48 85 C0 48 8B 74 24 10 4C 8B 4C 24 08 0F 84 F4 00 00 00 48 85 DB 4C 8D 78 64 0F 88 B4 00 00 00 49 8D 34 19 4C 89 F2 4C 89 FF 48 89 44 24 10 E8 ?? ?? ?? ?? 4C 8B 44 24 10 48 8B 7D 48 4C 89 44 24 10 4D 89 E5 E8 ?? ?? ?? ?? 4C 8B 44 24 10 4C 2B 6D 18 48 8B 45 60 4C 89 45 48 4C 03 44 24 18 4C 89 45 58 E9 4B FF FF FF 0F 1F 40 00 49 8D 34 19 4C 01 FF 4C 89 F2 E8 ?? ?? ?? ?? 4D 89 E5 48 8B 45 60 4C 2B 6D 18 4C 03 7D 48 E9 24 FF FF FF 48 8B 77 58 48 8B 7F 48 49 89 F7 49 29 FF 4D 85 ED 0F 89 0A FF FF FF 4C 89 EB 0F 1F 00 48 89 DA 48 01 DE 4C 01 FF 48 F7 DA E8 ?? ?? ?? ?? 48 8B 75 18 4C 89 FF 4C 89 E2 48 29 DF 48 03 7D 48 48 29 F2 EB A3 48 89 DA 48 01 DE 4C 89 FF 48 F7 DA 48 89 44 24 10 E8 ?? ?? ?? ?? 4C 8B 4C 24 08 4C 89 EA 48 89 C7 4C 89 CE E8 ?? ?? ?? ?? 4C 8B 44 24 10 E9 32 FF FF FF B8 FF FF FF FF E9 C1 FE FF FF }
	condition:
		$1
}

rule file_319_4_0 {
	meta:
		name = "_L_lock_481"
		size = 31
		refs = "000f __lll_lock_wait_private"
	strings:
		$1 = { 48 8D 3D ?? ?? ?? ?? 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 3B E7 FF FF }
	condition:
		$1
}

rule file_319_5_0 {
	meta:
		name = "_L_lock_509"
		size = 27
		refs = "000b __lll_lock_wait_private"
	strings:
		$1 = { 48 8D 3A 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 77 E7 FF FF }
	condition:
		$1
}

rule file_319_6_0 {
	meta:
		name = "_L_unlock_564"
		size = 27
		refs = "000b __lll_unlock_wake_private"
	strings:
		$1 = { 48 8D 3A 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 ED E7 FF FF }
	condition:
		$1
}

rule file_319_7_0 {
	meta:
		name = "_L_unlock_611"
		size = 31
		refs = "000f __lll_unlock_wake_private"
	strings:
		$1 = { 48 8D 3D ?? ?? ?? ?? 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 31 E8 FF FF }
	condition:
		$1
}

rule file_319_8_0 {
	meta:
		name = "_L_lock_702"
		size = 31
		refs = "000f __lll_lock_wait_private"
	strings:
		$1 = { 48 8D 3D ?? ?? ?? ?? 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 FC E8 FF FF }
	condition:
		$1
}

rule file_319_9_0 {
	meta:
		name = "_L_unlock_738"
		size = 31
		refs = "000f __lll_unlock_wake_private"
	strings:
		$1 = { 48 8D 3D ?? ?? ?? ?? 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 65 E9 FF FF }
	condition:
		$1
}

rule file_319_10_0 {
	meta:
		name = "_L_lock_785"
		size = 27
		refs = "000b __lll_lock_wait_private"
	strings:
		$1 = { 48 8D 3A 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 A2 E9 FF FF }
	condition:
		$1
}

rule file_319_11_0 {
	meta:
		name = "_L_unlock_814"
		size = 27
		refs = "000b __lll_unlock_wake_private"
	strings:
		$1 = { 48 8D 3A 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 F4 E9 FF FF }
	condition:
		$1
}

rule file_319_12_0 {
	meta:
		name = "_L_lock_2535"
		size = 31
		refs = "000f __lll_lock_wait_private"
	strings:
		$1 = { 48 8D 3D ?? ?? ?? ?? 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 95 F4 FF FF }
	condition:
		$1
}

rule file_319_13_0 {
	meta:
		name = "_L_lock_2614"
		size = 27
		refs = "000b __lll_lock_wait_private"
	strings:
		$1 = { 48 8D 3A 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 0B F5 FF FF }
	condition:
		$1
}

rule file_319_14_0 {
	meta:
		name = "_L_unlock_2670"
		size = 27
		refs = "000b __lll_unlock_wake_private"
	strings:
		$1 = { 48 8D 3A 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 79 F5 FF FF }
	condition:
		$1
}

rule file_319_15_0 {
	meta:
		name = "_L_unlock_2768"
		size = 31
		refs = "000f __lll_unlock_wake_private"
	strings:
		$1 = { 48 8D 3D ?? ?? ?? ?? 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 F9 F5 FF FF }
	condition:
		$1
}

rule file_319_16_0 {
	meta:
		name = "_L_unlock_3004"
		size = 27
		refs = "000b __lll_unlock_wake_private"
	strings:
		$1 = { 48 8D 3A 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 8D F7 FF FF }
	condition:
		$1
}

rule file_319_17_0 {
	meta:
		name = "_L_lock_3089"
		size = 31
		refs = "000f __lll_lock_wait_private"
	strings:
		$1 = { 48 8D 3D ?? ?? ?? ?? 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 0C F8 FF FF }
	condition:
		$1
}

rule file_319_18_0 {
	meta:
		name = "_L_lock_3160"
		size = 27
		refs = "000b __lll_lock_wait_private"
	strings:
		$1 = { 48 8D 3A 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 80 F8 FF FF }
	condition:
		$1
}

rule file_319_19_0 {
	meta:
		name = "_L_unlock_3196"
		size = 27
		refs = "000b __lll_unlock_wake_private"
	strings:
		$1 = { 48 8D 3A 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 BF F8 FF FF }
	condition:
		$1
}

rule file_319_20_0 {
	meta:
		name = "_L_unlock_3231"
		size = 31
		refs = "000f __lll_unlock_wake_private"
	strings:
		$1 = { 48 8D 3D ?? ?? ?? ?? 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 09 F9 FF FF }
	condition:
		$1
}

rule file_319_21_0 {
	meta:
		name = "_L_lock_3922"
		size = 31
		refs = "000f __lll_lock_wait_private"
	strings:
		$1 = { 48 8D 3D ?? ?? ?? ?? 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 4B FD FF FF }
	condition:
		$1
}

rule file_319_22_0 {
	meta:
		name = "_L_unlock_3952"
		size = 31
		refs = "000f __lll_unlock_wake_private"
	strings:
		$1 = { 48 8D 3D ?? ?? ?? ?? 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 75 FD FF FF }
	condition:
		$1
}

rule file_319_23_0 {
	meta:
		name = "_IO_un_link"
		size = 549
		refs = "000b _pthread_cleanup_push_defer 0050 __libc_multiple_threads 00dd _IO_list_all 017a _pthread_cleanup_pop_restore"
	strings:
		$1 = { F6 07 80 0F 84 7B 01 00 00 55 B8 ?? ?? ?? ?? 31 ED 53 48 89 FB 48 83 EC 28 48 85 C0 40 0F 95 C5 0F 84 E9 01 00 00 31 D2 BE ?? ?? ?? ?? 48 89 E7 E8 ?? ?? ?? ?? 64 48 8B 14 25 10 00 00 00 48 3B 15 ?? ?? ?? ?? 74 34 BE 01 00 00 00 31 C0 83 3D ?? ?? ?? ?? 00 74 10 F0 0F B1 35 ?? ?? ?? ?? 0F 85 B5 18 00 00 EB 0D 0F B1 35 ?? ?? ?? ?? 0F 85 A6 18 00 00 48 89 15 ?? ?? ?? ?? 8B 03 83 05 ?? ?? ?? ?? 01 48 89 1D ?? ?? ?? ?? 25 00 80 00 00 75 48 48 8B 93 88 00 00 00 64 4C 8B 04 25 10 00 00 00 4C 3B 42 08 74 2E BE 01 00 00 00 83 3D ?? ?? ?? ?? 00 74 0C F0 0F B1 32 0F 85 79 18 00 00 EB 09 0F B1 32 0F 85 6E 18 00 00 48 8B 93 88 00 00 00 4C 89 42 08 83 42 04 01 48 8B 05 ?? ?? ?? ?? 48 85 C0 74 37 48 39 C3 0F 84 D9 00 00 00 48 8B 50 68 48 85 D2 74 25 48 39 D3 75 17 E9 07 01 00 00 66 0F 1F 44 00 00 48 39 C3 0F 84 CF 00 00 00 48 89 C2 48 8B 42 68 48 85 C0 75 EB 8B 03 89 C2 80 E2 7F F6 C4 80 89 13 75 31 48 8B 93 88 00 00 00 83 6A 04 01 75 24 48 C7 42 08 00 00 00 00 83 3D ?? ?? ?? ?? 00 74 0B F0 FF 0A 0F 85 02 18 00 00 EB 08 FF 0A 0F 85 F8 17 00 00 83 2D ?? ?? ?? ?? 01 48 C7 05 ?? ?? ?? ?? 00 00 00 00 74 20 85 ED 74 0A 31 F6 48 89 E7 E8 ?? ?? ?? ?? 48 83 C4 28 5B 5D F3 C3 66 2E 0F 1F 84 00 00 00 00 00 48 C7 05 ?? ?? ?? ?? 00 00 00 00 83 3D ?? ?? ?? ?? 00 74 0F F0 FF 0D ?? ?? ?? ?? 0F 85 BE 17 00 00 EB 0C FF 0D ?? ?? ?? ?? 0F 85 B0 17 00 00 EB AF 0F 1F 80 00 00 00 00 48 8B 43 68 83 05 ?? ?? ?? ?? 01 48 89 05 ?? ?? ?? ?? E9 3E FF FF FF 90 48 83 C2 68 8B 03 48 8B 4B 68 83 05 ?? ?? ?? ?? 01 48 89 0A 89 C2 80 E2 7F F6 C4 80 89 13 0F 85 58 FF FF FF E9 22 FF FF FF 48 8D 50 68 EB D5 48 C7 04 24 ?? ?? ?? ?? 48 C7 44 24 08 00 00 00 00 E9 10 FE FF FF }
	condition:
		$1
}

rule file_319_24_0 {
	meta:
		name = "_IO_link_in"
		size = 487
		refs = "001a _pthread_cleanup_push_defer 0055 __libc_multiple_threads 00a4 _IO_list_all 010b _pthread_cleanup_pop_restore"
	strings:
		$1 = { 8B 07 A8 80 0F 85 0B 01 00 00 55 0C 80 31 ED 53 48 89 FB 48 83 EC 28 89 07 B8 ?? ?? ?? ?? 48 85 C0 40 0F 95 C5 0F 84 A6 01 00 00 31 D2 BE ?? ?? ?? ?? 48 89 E7 E8 ?? ?? ?? ?? 64 48 8B 14 25 10 00 00 00 48 3B 15 ?? ?? ?? ?? 74 34 BE 01 00 00 00 31 C0 83 3D ?? ?? ?? ?? 00 74 10 F0 0F B1 35 ?? ?? ?? ?? 0F 85 F4 16 00 00 EB 0D 0F B1 35 ?? ?? ?? ?? 0F 85 E5 16 00 00 48 89 15 ?? ?? ?? ?? 8B 33 8B 0D ?? ?? ?? ?? 48 89 1D ?? ?? ?? ?? 89 F0 83 C1 01 25 00 80 00 00 89 0D ?? ?? ?? ?? 74 7F 48 8B 05 ?? ?? ?? ?? 83 05 ?? ?? ?? ?? 01 48 89 1D ?? ?? ?? ?? 48 89 43 68 83 E9 01 48 C7 05 ?? ?? ?? ?? 00 00 00 00 85 C9 89 0D ?? ?? ?? ?? 75 2F 48 C7 05 ?? ?? ?? ?? 00 00 00 00 83 3D ?? ?? ?? ?? 00 74 0F F0 FF 0D ?? ?? ?? ?? 0F 85 8A 16 00 00 EB 0C FF 0D ?? ?? ?? ?? 0F 85 7C 16 00 00 85 ED 74 0A 31 F6 48 89 E7 E8 ?? ?? ?? ?? 48 83 C4 28 5B 5D F3 C3 66 0F 1F 84 00 00 00 00 00 48 8B 93 88 00 00 00 64 4C 8B 04 25 10 00 00 00 4C 3B 42 08 74 30 BE 01 00 00 00 83 3D ?? ?? ?? ?? 00 74 0C F0 0F B1 32 0F 85 4E 16 00 00 EB 09 0F B1 32 0F 85 43 16 00 00 48 8B 93 88 00 00 00 8B 33 4C 89 42 08 48 8B 05 ?? ?? ?? ?? 83 42 04 01 83 05 ?? ?? ?? ?? 01 81 E6 00 80 00 00 48 89 1D ?? ?? ?? ?? 48 89 43 68 75 3B 8B 42 04 83 E8 01 85 C0 89 42 04 8B 0D ?? ?? ?? ?? 0F 85 18 FF FF FF 48 C7 42 08 00 00 00 00 83 3D ?? ?? ?? ?? 00 74 0B F0 FF 0A 0F 85 FB 15 00 00 EB 08 FF 0A 0F 85 F1 15 00 00 8B 0D ?? ?? ?? ?? E9 E9 FE FF FF 48 C7 04 24 ?? ?? ?? ?? 48 C7 44 24 08 00 00 00 00 E9 53 FE FF FF }
	condition:
		$1
}

rule file_319_25_0 {
	meta:
		name = "_IO_least_marker"
		size = 37
	strings:
		$1 = { 48 8B 57 60 48 89 F0 48 2B 47 18 48 85 D2 74 13 48 63 4A 10 48 8B 12 48 39 C8 48 0F 4F C1 48 85 D2 75 ED F3 C3 }
	condition:
		$1
}

rule file_319_26_0 {
	meta:
		name = "_IO_switch_to_main_get_area"
		size = 43
	strings:
		$1 = { 48 8B 47 10 48 8B 57 58 81 27 FF FE FF FF 48 89 57 10 48 89 47 58 48 8B 57 18 48 8B 47 48 48 89 57 48 48 89 47 18 48 89 47 08 C3 }
	condition:
		$1
}

rule file_319_27_0 {
	meta:
		name = "_IO_switch_to_backup_area"
		size = 43
	strings:
		$1 = { 48 8B 57 10 48 8B 47 58 48 8B 4F 48 81 0F 00 01 00 00 48 89 57 58 48 8B 57 18 48 89 47 10 48 89 4F 18 48 89 57 48 48 89 47 08 C3 }
	condition:
		$1
}

rule file_319_28_0 {
	meta:
		name = "_IO_switch_to_get_mode"
		size = 106
	strings:
		$1 = { 48 8B 47 28 48 3B 47 20 53 48 89 FB 77 42 8B 13 F6 C6 01 75 2B 48 39 43 10 48 8B 4B 38 48 89 4B 18 73 04 48 89 43 10 80 E6 F7 48 89 43 08 48 89 43 30 48 89 43 20 89 13 31 C0 5B C3 0F 1F 40 00 48 8B 4B 50 48 89 4B 18 EB DD 66 0F 1F 44 00 00 48 8B 87 D8 00 00 00 BE FF FF FF FF FF 50 18 83 F8 FF 74 D6 48 8B 43 28 EB A4 }
	condition:
		$1
}

rule file_319_29_0 {
	meta:
		name = "_IO_free_backup_area"
		size = 94
		refs = "0035 free"
	strings:
		$1 = { 53 8B 07 48 89 FB F6 C4 01 74 4D 80 E4 FE 48 8B 57 58 89 07 48 8B 47 10 48 89 57 10 48 89 47 58 48 8B 43 48 48 8B 7F 18 48 89 43 08 48 89 43 18 48 89 7B 48 E8 ?? ?? ?? ?? 48 C7 43 48 00 00 00 00 48 C7 43 58 00 00 00 00 48 C7 43 50 00 00 00 00 5B C3 0F 1F 44 00 00 48 8B 7F 48 EB D6 }
	condition:
		$1
}

rule file_319_30_0 {
	meta:
		name = "__overflow"
		size = 33
	strings:
		$1 = { 8B 87 C0 00 00 00 85 C0 75 0A C7 87 C0 00 00 00 FF FF FF FF 48 8B 87 D8 00 00 00 48 8B 40 18 FF E0 }
	condition:
		$1
}

rule file_319_31_0 {
	meta:
		name = "__underflow"
		size = 201
		refs = "00a4 _IO_switch_to_get_mode 00c3 _IO_free_backup_area"
	strings:
		$1 = { 53 8B 87 C0 00 00 00 48 89 FB 85 C0 75 52 C7 87 C0 00 00 00 FF FF FF FF F7 03 00 08 00 00 0F 85 7C 00 00 00 48 8B 43 08 48 8B 53 10 48 39 D0 72 69 8B 03 F6 C4 01 75 38 48 83 7B 60 00 74 79 48 8B 73 10 48 89 DF E8 25 F8 FF FF 85 C0 75 16 48 8B 83 D8 00 00 00 48 89 DF 5B 48 8B 40 20 FF E0 83 F8 FF 74 B3 B8 FF FF FF FF 5B C3 0F 1F 40 00 80 E4 FE 48 8B 4B 58 48 89 53 58 89 03 48 8B 43 48 48 8B 53 18 48 89 4B 10 48 39 C1 48 89 43 18 48 89 43 08 48 89 53 48 76 9E 0F B6 00 5B C3 90 48 89 DF E8 ?? ?? ?? ?? 83 F8 FF 0F 85 73 FF FF FF EB B2 0F 1F 44 00 00 48 83 7B 48 00 74 90 48 89 DF E8 ?? ?? ?? ?? EB 86 }
	condition:
		$1
}

rule file_319_32_0 {
	meta:
		name = "__uflow"
		size = 224
		refs = "00b4 _IO_switch_to_get_mode 00d7 _IO_free_backup_area"
	strings:
		$1 = { 53 8B 87 C0 00 00 00 48 89 FB 85 C0 75 5A C7 87 C0 00 00 00 FF FF FF FF F7 03 00 08 00 00 0F 85 8C 00 00 00 48 8B 53 08 48 8B 43 10 48 39 C2 72 71 8B 13 F6 C6 01 75 40 48 83 7B 60 00 0F 84 85 00 00 00 48 8B 73 10 48 89 DF E8 51 F7 FF FF 85 C0 75 1A 48 8B 83 D8 00 00 00 48 89 DF 5B 48 8B 40 28 FF E0 0F 1F 40 00 83 F8 FF 74 AB B8 FF FF FF FF 5B C3 0F 1F 40 00 80 E6 FE 48 8B 4B 58 48 89 43 58 89 13 48 8B 53 48 48 8B 43 18 48 89 4B 10 48 39 D1 48 89 53 18 48 89 53 08 48 89 43 48 76 96 0F B6 02 48 83 C2 01 48 89 53 08 5B C3 90 48 89 DF E8 ?? ?? ?? ?? 83 F8 FF 0F 85 63 FF FF FF EB AA 0F 1F 44 00 00 48 83 7B 48 00 0F 84 80 FF FF FF 48 89 DF E8 ?? ?? ?? ?? E9 73 FF FF FF }
	condition:
		$1
}

rule file_319_33_0 {
	meta:
		name = "_IO_setb"
		size = 132
		refs = "0076 __munmap"
	strings:
		$1 = { 48 89 5C 24 F0 48 89 6C 24 F8 48 89 FB 48 83 EC 28 48 8B 7F 38 48 89 F5 48 85 FF 74 05 F6 03 01 74 36 85 C9 48 89 6B 38 48 89 53 40 75 12 83 0B 01 48 8B 6C 24 20 48 8B 5C 24 18 48 83 C4 28 C3 83 23 FE 48 8B 6C 24 20 48 8B 5C 24 18 48 83 C4 28 C3 66 0F 1F 44 00 00 48 8B 73 40 48 89 54 24 08 89 0C 24 48 29 FE 48 81 C6 FF 0F 00 00 48 81 E6 00 F0 FF FF E8 ?? ?? ?? ?? 8B 0C 24 48 8B 54 24 08 EB 9E }
	condition:
		$1
}

rule file_319_34_0 {
	meta:
		name = "_IO_doallocbuf"
		size = 89
		refs = "0055 _IO_setb"
	strings:
		$1 = { 48 83 7F 38 00 74 09 C3 0F 1F 84 00 00 00 00 00 53 F6 07 02 48 89 FB 74 0A 8B 97 C0 00 00 00 85 D2 7E 1D 48 8B 83 D8 00 00 00 48 89 DF FF 50 68 83 F8 FF 74 0B 5B C3 66 0F 1F 84 00 00 00 00 00 48 8D 93 84 00 00 00 48 8D B3 83 00 00 00 48 89 DF 5B 31 C9 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_319_36_0 {
	meta:
		name = "_IO_default_uflow"
		size = 36
	strings:
		$1 = { 48 8B 87 D8 00 00 00 53 48 89 FB FF 50 20 83 F8 FF 74 0F 48 8B 53 08 0F B6 02 48 83 C2 01 48 89 53 08 5B C3 }
	condition:
		$1
}

rule file_319_37_0 {
	meta:
		name = "_IO_default_xsputn"
		size = 192
		refs = "00a2 mempcpy"
	strings:
		$1 = { 31 C0 48 85 D2 0F 84 B3 00 00 00 41 56 41 55 49 89 D5 41 54 49 89 FC 55 48 89 D5 53 48 89 F3 90 49 8B 7C 24 28 4D 8B 74 24 30 4C 39 F7 73 40 49 29 FE 4C 39 F5 4C 0F 46 F5 49 83 FE 14 77 59 4D 85 F6 74 28 31 C0 66 2E 0F 1F 84 00 00 00 00 00 0F B6 14 03 88 14 07 48 83 C0 01 4C 39 F0 75 F0 4A 8D 0C 37 4C 01 F3 49 89 4C 24 28 4C 29 F5 48 85 ED 74 3C 49 8B 84 24 D8 00 00 00 0F B6 33 4C 89 E7 48 83 C3 01 FF 50 18 83 F8 FF 74 22 48 83 ED 01 EB 8C 0F 1F 40 00 48 89 DE 4C 89 F2 4C 01 F3 E8 ?? ?? ?? ?? 49 89 44 24 28 EB BF 0F 1F 00 5B 4C 89 E8 48 29 E8 5D 41 5C 41 5D 41 5E F3 C3 }
	condition:
		$1
}

rule file_319_39_0 {
	meta:
		name = "_IO_default_xsgetn"
		size = 172
		refs = "0079 __underflow 009f mempcpy"
	strings:
		$1 = { 41 56 41 55 49 89 F5 41 54 49 89 D4 55 48 89 D5 53 48 89 FB 0F 1F 40 00 48 8B 73 08 48 8B 43 10 48 39 C6 73 4B 48 29 F0 48 39 C5 49 89 C6 4C 0F 46 F5 49 83 FE 14 77 60 4D 85 F6 74 30 41 8D 46 FF 31 C9 48 83 C0 01 66 0F 1F 84 00 00 00 00 00 44 0F B6 04 0E 45 88 44 0D 00 48 83 C1 01 48 39 C1 75 ED 49 01 CD 48 01 F1 48 89 4B 08 4C 29 F5 48 85 ED 74 0D 48 89 DF E8 ?? ?? ?? ?? 83 F8 FF 75 96 5B 4C 89 E0 48 29 E8 5D 41 5C 41 5D 41 5E C3 0F 1F 80 00 00 00 00 4C 89 EF 4C 89 F2 E8 ?? ?? ?? ?? 4C 01 73 08 49 89 C5 EB C1 }
	condition:
		$1
}

rule file_319_40_0 {
	meta:
		name = "_IO_default_setbuf"
		size = 196
		refs = "0050 _IO_setb"
	strings:
		$1 = { 48 89 5C 24 E8 48 89 6C 24 F0 48 89 FB 4C 89 64 24 F8 48 83 EC 18 48 8B 87 D8 00 00 00 48 89 F5 49 89 D4 FF 50 60 83 F8 FF 0F 84 91 00 00 00 4D 85 E4 74 05 48 85 ED 75 67 83 0B 02 48 8D 93 84 00 00 00 48 8D B3 83 00 00 00 31 C9 48 89 DF E8 ?? ?? ?? ?? 48 C7 43 30 00 00 00 00 48 C7 43 28 00 00 00 00 48 C7 43 20 00 00 00 00 48 C7 43 10 00 00 00 00 48 C7 43 08 00 00 00 00 48 C7 43 18 00 00 00 00 48 89 D8 48 8B 6C 24 08 48 8B 1C 24 4C 8B 64 24 10 48 83 C4 18 C3 66 0F 1F 44 00 00 83 23 FD 4A 8D 54 25 00 31 C9 48 89 EE 48 89 DF E8 ?? ?? ?? ?? EB 9D 66 0F 1F 84 00 00 00 00 00 31 DB EB C0 }
	condition:
		$1
}

rule file_319_41_0 {
	meta:
		name = "_IO_default_seekpos"
		size = 17
	strings:
		$1 = { 48 8B 87 D8 00 00 00 89 D1 31 D2 48 8B 40 48 FF E0 }
	condition:
		$1
}

rule file_319_42_0 {
	meta:
		name = "_IO_default_doallocate"
		size = 71
		refs = "001f __mmap 003c _IO_setb"
	strings:
		$1 = { 53 45 31 C9 48 89 FB 41 B8 FF FF FF FF 31 FF B9 22 00 00 00 BA 03 00 00 00 BE 00 20 00 00 E8 ?? ?? ?? ?? 48 83 F8 FF 74 1C 48 8D 90 00 20 00 00 48 89 C6 B9 01 00 00 00 48 89 DF E8 ?? ?? ?? ?? B8 01 00 00 00 5B C3 }
	condition:
		$1
}

rule file_319_43_0 {
	meta:
		name = "_IO_old_init"
		size = 163
	strings:
		$1 = { 48 8B 87 88 00 00 00 81 CE 00 00 AD FB C7 47 74 00 00 00 00 89 37 48 C7 47 38 00 00 00 00 48 C7 47 40 00 00 00 00 48 C7 47 18 00 00 00 00 48 85 C0 48 C7 47 08 00 00 00 00 48 C7 47 10 00 00 00 00 48 C7 47 20 00 00 00 00 48 C7 47 28 00 00 00 00 48 C7 47 30 00 00 00 00 48 C7 47 68 00 00 00 00 48 C7 47 48 00 00 00 00 48 C7 47 50 00 00 00 00 48 C7 47 58 00 00 00 00 48 C7 47 60 00 00 00 00 66 C7 87 80 00 00 00 00 00 74 15 C7 00 00 00 00 00 C7 40 04 00 00 00 00 48 C7 40 08 00 00 00 00 F3 C3 }
	condition:
		$1
}

rule file_319_44_0 {
	meta:
		name = "_IO_init"
		size = 32
		refs = "0005 _IO_old_init"
	strings:
		$1 = { 53 48 89 FB E8 ?? ?? ?? ?? C7 83 C0 00 00 00 FF FF FF FF 48 C7 83 A8 00 00 00 00 00 00 00 5B C3 }
	condition:
		$1
}

rule file_319_45_0 {
	meta:
		name = "_IO_no_init"
		size = 189
		refs = "0025 _IO_old_init"
	strings:
		$1 = { 48 89 5C 24 E0 48 89 6C 24 E8 48 89 CB 4C 89 64 24 F0 4C 89 6C 24 F8 41 89 D4 48 83 EC 20 48 89 FD 4D 89 C5 E8 ?? ?? ?? ?? 45 85 E4 44 89 A5 C0 00 00 00 78 65 48 89 9D A0 00 00 00 48 C7 43 30 00 00 00 00 48 C7 43 38 00 00 00 00 48 C7 43 10 00 00 00 00 48 C7 03 00 00 00 00 48 C7 43 08 00 00 00 00 48 C7 43 18 00 00 00 00 48 C7 43 20 00 00 00 00 48 C7 43 28 00 00 00 00 48 C7 43 40 00 00 00 00 48 C7 43 48 00 00 00 00 48 C7 43 50 00 00 00 00 4C 89 AB 40 01 00 00 48 C7 85 A8 00 00 00 00 00 00 00 48 8B 1C 24 48 8B 6C 24 08 4C 8B 64 24 10 4C 8B 6C 24 18 48 83 C4 20 C3 }
	condition:
		$1
}

rule file_319_47_0 {
	meta:
		name = "_IO_default_finish"
		size = 124
		refs = "003a free 0066 __munmap 004b _IO_un_link"
	strings:
		$1 = { 53 48 89 FB 48 8B 7F 38 48 85 FF 74 05 F6 03 01 74 3E 48 8B 43 60 48 85 C0 74 15 0F 1F 44 00 00 48 C7 40 08 00 00 00 00 48 8B 00 48 85 C0 75 F0 48 8B 7B 48 48 85 FF 74 0D E8 ?? ?? ?? ?? 48 C7 43 48 00 00 00 00 48 89 DF 5B E9 ?? ?? ?? ?? 90 48 8B 73 40 48 29 FE 48 81 C6 FF 0F 00 00 48 81 E6 00 F0 FF FF E8 ?? ?? ?? ?? 48 C7 43 40 00 00 00 00 48 C7 43 38 00 00 00 00 EB 96 }
	condition:
		$1
}

rule file_319_49_0 {
	meta:
		name = "_IO_sputbackc"
		size = 62
	strings:
		$1 = { 53 48 8B 57 08 48 89 FB 48 3B 57 18 76 06 40 38 72 FF 74 1C 48 8B 83 D8 00 00 00 48 89 DF FF 50 30 83 F8 FF 74 03 83 23 EF 5B C3 0F 1F 44 00 00 48 83 EA 01 40 0F B6 C6 48 89 57 08 EB E8 }
	condition:
		$1
}

rule file_319_50_0 {
	meta:
		name = "_IO_sungetc"
		size = 54
	strings:
		$1 = { 48 8B 47 08 48 3B 47 18 53 48 89 FB 76 12 48 8D 50 FF 48 89 57 08 0F B6 40 FF 83 23 EF 5B C3 90 48 8B 87 D8 00 00 00 BE FF FF FF FF FF 50 30 83 F8 FF 75 E6 5B C3 }
	condition:
		$1
}

rule file_319_51_0 {
	meta:
		name = "_IO_adjust_column"
		size = 64
	strings:
		$1 = { 4C 63 C2 49 01 F0 4C 39 C6 73 23 41 80 78 FF 0A 49 8D 48 FF 75 13 EB 20 0F 1F 84 00 00 00 00 00 48 83 E9 01 80 39 0A 74 0F 48 39 F1 75 F2 8D 04 3A C3 66 0F 1F 44 00 00 49 29 C8 41 8D 40 FF C3 }
	condition:
		$1
}

rule file_319_52_0 {
	meta:
		name = "_IO_flush_all_lockp"
		size = 583
		refs = "0018 _pthread_cleanup_push_defer 0052 __libc_multiple_threads 0087 _IO_list_all 01cf _pthread_cleanup_pop_restore"
	strings:
		$1 = { 41 57 41 56 41 55 45 31 ED 41 54 55 89 FD 53 48 83 EC 28 85 FF 74 6D B8 ?? ?? ?? ?? 48 85 C0 0F 84 0C 02 00 00 31 D2 BE ?? ?? ?? ?? 48 89 E7 41 B5 01 E8 ?? ?? ?? ?? 64 48 8B 14 25 10 00 00 00 48 3B 15 ?? ?? ?? ?? 74 34 BE 01 00 00 00 31 C0 83 3D ?? ?? ?? ?? 00 74 10 F0 0F B1 35 ?? ?? ?? ?? 0F 85 5B 0B 00 00 EB 0D 0F B1 35 ?? ?? ?? ?? 0F 85 4C 0B 00 00 48 89 15 ?? ?? ?? ?? 83 05 ?? ?? ?? ?? 01 48 8B 1D ?? ?? ?? ?? 45 31 FF 44 8B 35 ?? ?? ?? ?? 48 85 DB 0F 84 19 01 00 00 64 4C 8B 24 25 10 00 00 00 EB 1A 0F 1F 80 00 00 00 00 48 8B 1D ?? ?? ?? ?? 41 89 D6 48 85 DB 0F 84 F4 00 00 00 85 ED 48 89 1D ?? ?? ?? ?? 74 48 8B 03 25 00 80 00 00 75 3F 48 8B 93 88 00 00 00 4C 3B 62 08 74 2E BE 01 00 00 00 83 3D ?? ?? ?? ?? 00 74 0C F0 0F B1 32 0F 85 E5 0A 00 00 EB 09 0F B1 32 0F 85 DA 0A 00 00 48 8B 93 88 00 00 00 4C 89 62 08 83 42 04 01 8B 8B C0 00 00 00 85 C9 0F 8E C4 00 00 00 48 8B 93 A0 00 00 00 48 8B 42 18 48 39 42 20 76 1E 48 8B 83 D8 00 00 00 BE FF FF FF FF 48 89 DF FF 50 18 83 F8 FF B8 FF FF FF FF 44 0F 44 F8 85 ED 74 39 F7 03 00 80 00 00 75 31 48 8B 93 88 00 00 00 83 6A 04 01 75 24 48 C7 42 08 00 00 00 00 83 3D ?? ?? ?? ?? 00 74 0B F0 FF 0A 0F 85 76 0A 00 00 EB 08 FF 0A 0F 85 6C 0A 00 00 8B 15 ?? ?? ?? ?? 48 C7 05 ?? ?? ?? ?? 00 00 00 00 41 39 D6 0F 85 06 FF FF FF 48 8B 5B 68 48 85 DB 0F 85 0C FF FF FF 85 ED 74 09 83 2D ?? ?? ?? ?? 01 74 3C 45 85 ED 74 0A 31 F6 48 89 E7 E8 ?? ?? ?? ?? 48 83 C4 28 44 89 F8 5B 5D 41 5C 41 5D 41 5E 41 5F C3 0F 1F 00 48 8B 43 20 48 39 43 28 0F 87 3F FF FF FF E9 58 FF FF FF 0F 1F 44 00 00 48 C7 05 ?? ?? ?? ?? 00 00 00 00 83 3D ?? ?? ?? ?? 00 74 0F F0 FF 0D ?? ?? ?? ?? 0F 85 F6 09 00 00 EB 0C FF 0D ?? ?? ?? ?? 0F 85 E8 09 00 00 EB 93 48 C7 04 24 ?? ?? ?? ?? 48 C7 44 24 08 ?? ?? ?? ?? E9 F0 FD FF FF }
	condition:
		$1
}

rule file_319_53_0 {
	meta:
		name = "_IO_cleanup"
		size = 417
		refs = "0016 _IO_flush_all_lockp 001d _IO_list_all 0076 __libc_multiple_threads 00fd __sched_yield"
	strings:
		$1 = { 41 55 31 FF 41 54 55 64 48 8B 2C 25 10 00 00 00 53 48 83 EC 08 E8 ?? ?? ?? ?? 48 8B 1D ?? ?? ?? ?? 41 89 C4 48 85 DB 0F 84 BA 00 00 00 0F 1F 00 8B 13 F6 C2 02 0F 85 95 00 00 00 81 E2 08 10 00 00 83 FA 08 0F 84 86 00 00 00 8B B3 C0 00 00 00 85 F6 74 7C 45 31 ED 48 8B 93 88 00 00 00 48 85 D2 74 39 48 3B 6A 08 0F 84 2B 01 00 00 31 C0 BE 01 00 00 00 83 3D ?? ?? ?? ?? 00 74 06 F0 0F B1 32 EB 03 0F B1 32 85 C0 75 6E 48 8B 83 88 00 00 00 48 89 68 08 C7 40 04 01 00 00 00 80 3D ?? ?? ?? ?? 00 75 06 8B 03 A8 01 74 65 48 8B 83 D8 00 00 00 31 D2 31 F6 48 89 DF FF 50 58 41 83 FD 02 0F 85 8A 00 00 00 66 2E 0F 1F 84 00 00 00 00 00 C7 83 C0 00 00 00 FF FF FF FF 48 8B 5B 68 48 85 DB 0F 85 49 FF FF FF 48 83 C4 08 44 89 E0 5B 5D 41 5C 41 5D C3 0F 1F 00 41 83 C5 01 E8 ?? ?? ?? ?? 41 83 FD 02 74 95 E9 4B FF FF FF 0F 1F 40 00 83 C8 01 48 8B 53 38 89 03 48 8B 05 ?? ?? ?? ?? 48 89 1D ?? ?? ?? ?? 48 89 93 B0 00 00 00 48 89 83 A8 00 00 00 48 8B 43 40 48 29 D0 48 89 83 B8 00 00 00 E9 63 FF FF FF 0F 1F 84 00 00 00 00 00 48 8B 93 88 00 00 00 48 85 D2 0F 84 70 FF FF FF 83 6A 04 01 0F 85 66 FF FF FF 48 C7 42 08 00 00 00 00 83 3D ?? ?? ?? ?? 00 74 0B F0 FF 0A 0F 85 62 08 00 00 EB 08 FF 0A 0F 85 58 08 00 00 E9 3D FF FF FF 0F 1F 44 00 00 83 42 04 01 E9 FB FE FF FF }
	condition:
		$1
}

rule file_319_55_0 {
	meta:
		name = "_IO_flush_all_linebuffered"
		size = 525
		refs = "0003 _pthread_cleanup_push_defer 0048 __libc_multiple_threads 007c _IO_list_all 01c8 _pthread_cleanup_pop_restore"
	strings:
		$1 = { 41 55 B8 ?? ?? ?? ?? 41 54 55 31 ED 53 48 83 EC 28 48 85 C0 40 0F 95 C5 0F 84 D9 01 00 00 31 D2 BE ?? ?? ?? ?? 48 89 E7 E8 ?? ?? ?? ?? 64 48 8B 14 25 10 00 00 00 48 3B 15 ?? ?? ?? ?? 74 34 BE 01 00 00 00 31 C0 83 3D ?? ?? ?? ?? 00 74 10 F0 0F B1 35 ?? ?? ?? ?? 0F 85 E4 07 00 00 EB 0D 0F B1 35 ?? ?? ?? ?? 0F 85 D5 07 00 00 48 89 15 ?? ?? ?? ?? 8B 05 ?? ?? ?? ?? 48 8B 1D ?? ?? ?? ?? 44 8B 25 ?? ?? ?? ?? 83 C0 01 48 85 DB 89 05 ?? ?? ?? ?? 0F 84 E9 00 00 00 64 4C 8B 2C 25 10 00 00 00 EB 17 0F 1F 40 00 48 8B 1D ?? ?? ?? ?? 41 89 C4 48 85 DB 0F 84 C1 00 00 00 8B 03 48 89 1D ?? ?? ?? ?? 25 00 80 00 00 75 3F 48 8B 93 88 00 00 00 4C 3B 6A 08 74 2E BE 01 00 00 00 83 3D ?? ?? ?? ?? 00 74 0C F0 0F B1 32 0F 85 70 07 00 00 EB 09 0F B1 32 0F 85 65 07 00 00 48 8B 93 88 00 00 00 4C 89 6A 08 83 42 04 01 8B 03 25 08 02 00 00 3D 00 02 00 00 0F 84 C4 00 00 00 F7 03 00 80 00 00 75 31 48 8B 93 88 00 00 00 83 6A 04 01 75 24 48 C7 42 08 00 00 00 00 83 3D ?? ?? ?? ?? 00 74 0B F0 FF 0A 0F 85 30 07 00 00 EB 08 FF 0A 0F 85 26 07 00 00 8B 05 ?? ?? ?? ?? 48 C7 05 ?? ?? ?? ?? 00 00 00 00 41 39 C4 0F 85 39 FF FF FF 48 8B 5B 68 48 85 DB 0F 85 3F FF FF FF 8B 05 ?? ?? ?? ?? 83 E8 01 85 C0 89 05 ?? ?? ?? ?? 75 2F 48 C7 05 ?? ?? ?? ?? 00 00 00 00 83 3D ?? ?? ?? ?? 00 74 0F F0 FF 0D ?? ?? ?? ?? 0F 85 E6 06 00 00 EB 0C FF 0D ?? ?? ?? ?? 0F 85 D8 06 00 00 85 ED 74 0A 31 F6 48 89 E7 E8 ?? ?? ?? ?? 48 83 C4 28 5B 5D 41 5C 41 5D C3 66 0F 1F 84 00 00 00 00 00 48 8B 83 D8 00 00 00 BE FF FF FF FF 48 89 DF FF 50 18 E9 25 FF FF FF 48 C7 04 24 ?? ?? ?? ?? 48 C7 44 24 08 00 00 00 00 E9 20 FE FF FF }
	condition:
		$1
}

rule file_319_56_0 {
	meta:
		name = "_IO_init_marker"
		size = 94
		refs = "0051 _IO_switch_to_get_mode"
	strings:
		$1 = { 53 48 89 FB 48 83 EC 10 8B 06 48 89 77 08 F6 C4 08 75 35 F6 C4 01 48 8B 46 08 75 1C 48 2B 46 18 89 43 10 48 8B 46 60 48 89 03 48 89 5E 60 48 83 C4 10 5B C3 0F 1F 40 00 48 2B 46 10 89 43 10 EB E2 0F 1F 80 00 00 00 00 48 89 F7 48 89 74 24 08 E8 ?? ?? ?? ?? 48 8B 74 24 08 8B 06 EB B5 }
	condition:
		$1
}

rule file_319_57_0 {
	meta:
		name = "_IO_remove_marker"
		size = 55
	strings:
		$1 = { 48 8B 47 08 48 8B 50 60 48 85 D2 74 1B 48 39 D7 75 0E EB 16 0F 1F 40 00 48 39 C7 74 13 48 89 C2 48 8B 02 48 85 C0 75 F0 F3 C3 48 8D 50 60 66 90 48 8B 0F 48 89 0A C3 }
	condition:
		$1
}

rule file_319_59_0 {
	meta:
		name = "_IO_marker_delta"
		size = 47
	strings:
		$1 = { 48 8B 47 08 48 85 C0 74 20 F7 00 00 01 00 00 48 8B 50 08 75 0B 2B 50 18 8B 47 10 29 D0 C3 66 90 2B 50 10 8B 47 10 29 D0 C3 B8 FF FF FF FF C3 }
	condition:
		$1
}

rule file_319_60_0 {
	meta:
		name = "_IO_seekmark"
		size = 150
	strings:
		$1 = { 48 8B 56 08 B8 FF FF FF FF 48 39 FA 75 3D 48 63 46 10 8B 0A 85 C0 78 48 F6 C5 01 74 33 80 E5 FE 48 8B 72 58 89 0A 48 8B 4A 10 48 89 72 10 48 8B 72 18 48 89 4A 58 48 8B 4A 48 48 89 72 48 48 89 4A 18 48 01 C1 31 C0 48 89 4A 08 F3 C3 0F 1F 00 48 8B 4A 18 EB EC 66 2E 0F 1F 84 00 00 00 00 00 F6 C5 01 75 2B 48 8B 72 10 80 CD 01 48 8B 7A 48 89 0A 48 8B 4A 58 48 89 72 58 48 8B 72 18 48 89 4A 10 48 89 7A 18 48 89 72 48 EB B6 0F 1F 40 00 48 8B 4A 10 EB AC }
	condition:
		$1
}

rule file_319_61_0 {
	meta:
		name = "_IO_unsave_markers"
		size = 34
		refs = "0017 _IO_free_backup_area"
	strings:
		$1 = { 48 83 7F 60 00 74 08 48 C7 47 60 00 00 00 00 48 83 7F 48 00 74 0A E9 ?? ?? ?? ?? 0F 1F 44 00 00 F3 C3 }
	condition:
		$1
}

rule file_1117_23_0 {
	meta:
		name = "_IO_unsave_wmarkers"
		size = 34
		refs = "0017 _IO_free_wbackup_area"
	strings:
		$1 = { 48 83 7F 60 00 74 08 48 C7 47 60 00 00 00 00 48 83 7F 48 00 74 0A E9 ?? ?? ?? ?? 0F 1F 44 00 00 F3 C3 }
	condition:
		$1
}

rule file_319_62_0 {
	meta:
		name = "_IO_default_pbackfail"
		size = 369
		refs = "00f9 malloc 0115 memcpy 011e free"
	strings:
		$1 = { 48 89 5C 24 D0 48 89 6C 24 D8 48 89 FB 4C 89 64 24 E0 4C 89 6C 24 E8 41 89 F4 4C 89 74 24 F0 4C 89 7C 24 F8 48 83 EC 48 48 8B 6F 08 4C 8B 6F 18 4C 39 ED 77 6B 8B 17 F6 C6 01 0F 85 AA 00 00 00 48 8B 43 48 48 85 C0 0F 84 F3 00 00 00 48 89 E9 48 8B 6B 58 80 CE 01 48 89 43 18 48 89 4B 48 89 13 48 8B 53 10 48 89 6B 10 48 89 53 58 48 8D 45 FF 48 89 43 08 44 88 65 FF 41 0F B6 C4 48 8B 5C 24 18 48 8B 6C 24 20 4C 8B 64 24 28 4C 8B 6C 24 30 4C 8B 74 24 38 4C 8B 7C 24 40 48 83 C4 48 C3 F7 07 00 01 00 00 75 C5 0F B6 45 FF 39 F0 74 30 48 83 7F 48 00 0F 84 85 00 00 00 48 89 EE E8 4D E7 FF FF 85 C0 0F 85 9C 00 00 00 48 8B 4B 08 8B 13 48 8B 6B 58 48 8B 43 48 E9 76 FF FF FF 66 90 48 83 ED 01 48 89 6F 08 EB 8F 4C 8B 73 10 4D 29 EE 4F 8D 3C 36 4C 89 FF E8 ?? ?? ?? ?? 48 85 C0 74 65 4A 8D 2C 30 4C 89 F2 4C 89 EE 48 89 44 24 08 48 89 EF E8 ?? ?? ?? ?? 48 8B 7B 18 E8 ?? ?? ?? ?? 48 8B 4C 24 08 48 89 6B 50 49 01 CF 48 89 4B 18 4C 89 7B 10 E9 32 FF FF FF 0F 1F 44 00 00 BF 80 00 00 00 E8 ?? ?? ?? ?? 48 85 C0 74 18 48 8D B0 80 00 00 00 48 89 E9 8B 13 48 89 73 50 48 89 F5 E9 ED FE FF FF B8 FF FF FF FF E9 0C FF FF FF }
	condition:
		$1
}

rule file_319_73_0 {
	meta:
		name = "_IO_list_lock"
		size = 78
		refs = "001b __libc_multiple_threads"
	strings:
		$1 = { 64 48 8B 14 25 10 00 00 00 48 3B 15 ?? ?? ?? ?? 74 34 BE 01 00 00 00 31 C0 83 3D ?? ?? ?? ?? 00 74 10 F0 0F B1 35 ?? ?? ?? ?? 0F 85 A5 02 00 00 EB 0D 0F B1 35 ?? ?? ?? ?? 0F 85 96 02 00 00 48 89 15 ?? ?? ?? ?? 83 05 ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule file_319_74_0 {
	meta:
		name = "_IO_list_unlock"
		size = 58
		refs = "0016 __libc_multiple_threads"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 75 2F 48 C7 05 ?? ?? ?? ?? 00 00 00 00 83 3D ?? ?? ?? ?? 00 74 0F F0 FF 0D ?? ?? ?? ?? 0F 85 7A 02 00 00 EB 0C FF 0D ?? ?? ?? ?? 0F 85 6C 02 00 00 F3 C3 }
	condition:
		$1
}

rule file_319_75_0 {
	meta:
		name = "_IO_list_resetlock"
		size = 32
	strings:
		$1 = { C7 05 ?? ?? ?? ?? 00 00 00 00 C7 05 ?? ?? ?? ?? 00 00 00 00 48 C7 05 ?? ?? ?? ?? 00 00 00 00 C3 }
	condition:
		$1
}

rule file_319_76_0 {
	meta:
		name = "buffer_free"
		size = 97
		refs = "003d __munmap"
	strings:
		$1 = { 48 8B 05 ?? ?? ?? ?? C6 05 ?? ?? ?? ?? 01 48 85 C0 74 4C 48 83 EC 08 66 0F 1F 84 00 00 00 00 00 48 8B B0 B8 00 00 00 48 8B B8 B0 00 00 00 48 81 C6 FF 0F 00 00 48 81 E6 00 F0 FF FF E8 ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? 48 8B 80 A8 00 00 00 48 85 C0 48 89 05 ?? ?? ?? ?? 75 C5 48 83 C4 08 F3 C3 }
	condition:
		$1
}

rule file_321_0_0 {
	meta:
		name = "__libc_write"
		size = 81
		refs = "0002 __libc_multiple_threads 0022 __libc_enable_asynccancel 0039 __libc_disable_asynccancel 0018 __syscall_error"
		altNames = "__write"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 75 14 B8 01 00 00 00 0F 05 48 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 48 83 EC 08 E8 ?? ?? ?? ?? 48 89 04 24 B8 01 00 00 00 0F 05 48 8B 3C 24 48 89 C2 E8 ?? ?? ?? ?? 48 89 D0 48 83 C4 08 48 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_141_0_3 {
	meta:
		name = "__libc_write"
		size = 81
		refs = "0002 __pthread_multiple_threads 0022 __pthread_enable_asynccancel 0039 __pthread_disable_asynccancel 0018 __syscall_error"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 75 14 B8 01 00 00 00 0F 05 48 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 48 83 EC 08 E8 ?? ?? ?? ?? 48 89 04 24 B8 01 00 00 00 0F 05 48 8B 3C 24 48 89 C2 E8 ?? ?? ?? ?? 48 89 D0 48 83 C4 08 48 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_141_2_3 {
	meta:
		name = "__write"
		size = 81
		refs = "0002 __pthread_multiple_threads 0022 __pthread_enable_asynccancel 0039 __pthread_disable_asynccancel 0018 __syscall_error"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 75 14 B8 01 00 00 00 0F 05 48 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 48 83 EC 08 E8 ?? ?? ?? ?? 48 89 04 24 B8 01 00 00 00 0F 05 48 8B 3C 24 48 89 C2 E8 ?? ?? ?? ?? 48 89 D0 48 83 C4 08 48 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_321_1_0 {
	meta:
		name = "__write_nocancel"
		size = 20
		refs = "000f __syscall_error"
	strings:
		$1 = { B8 01 00 00 00 0F 05 48 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_322_0_0 {
	meta:
		name = "wctomb"
		size = 97
		refs = "0007 __wctomb_state 000c __wcrtomb 001b _nl_current_LC_CTYPE 0046 _nl_C_LC_CTYPE 0050 __wcsmbs_load_conv 005b __wcsmbs_gconv_fcts_c"
	strings:
		$1 = { 48 85 FF 53 74 12 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 66 0F 1F 44 00 00 48 8B 05 ?? ?? ?? ?? 64 48 8B 00 48 8B 18 48 8B 43 28 48 85 C0 74 14 48 8B 40 10 48 C7 05 ?? ?? ?? ?? 00 00 00 00 5B 8B 40 58 C3 48 81 FB ?? ?? ?? ?? 74 0E 48 89 DF E8 ?? ?? ?? ?? 48 8B 43 28 EB D5 B8 ?? ?? ?? ?? EB CE }
	condition:
		$1
}

rule file_323_0_0 {
	meta:
		name = "sigrelse"
		size = 71
		refs = "0012 __sigprocmask 0020 sigdelset"
	strings:
		$1 = { 53 31 F6 89 FB BF 02 00 00 00 48 83 C4 80 48 89 E2 E8 ?? ?? ?? ?? 85 C0 78 26 89 DE 48 89 E7 E8 ?? ?? ?? ?? 85 C0 78 18 31 D2 48 89 E6 BF 02 00 00 00 E8 ?? ?? ?? ?? 48 83 EC 80 5B C3 0F 1F 00 B8 FF FF FF FF EB F0 }
	condition:
		$1
}

rule file_672_0_0 {
	meta:
		name = "sighold"
		size = 71
		refs = "0012 __sigprocmask 0020 sigaddset"
	strings:
		$1 = { 53 31 F6 89 FB BF 02 00 00 00 48 83 C4 80 48 89 E2 E8 ?? ?? ?? ?? 85 C0 78 26 89 DE 48 89 E7 E8 ?? ?? ?? ?? 85 C0 78 18 31 D2 48 89 E6 BF 02 00 00 00 E8 ?? ?? ?? ?? 48 83 EC 80 5B C3 0F 1F 00 B8 FF FF FF FF EB F0 }
	condition:
		$1
}

rule file_324_0_0 {
	meta:
		name = "__mempcpy"
		size = 1106
		refs = "0133 __x86_64_data_cache_size_half 0173 __x86_64_shared_cache_size_half 01a5 __x86_64_prefetchw"
	strings:
		$1 = { 48 83 FA 20 73 7A F6 C2 01 74 0B 0F B6 0E 88 0F 48 FF C6 48 FF C7 F6 C2 02 74 0E 0F B7 0E 66 89 0F 48 83 C6 02 48 83 C7 02 F6 C2 04 74 0C 8B 0E 89 0F 48 83 C6 04 48 83 C7 04 F6 C2 08 74 11 48 8B 0E 48 89 0F 48 83 C6 08 48 83 C7 08 0F 1F 00 81 E2 F0 00 00 00 74 23 0F 1F 84 00 00 00 00 00 48 8B 0E 4C 8B 46 08 48 89 0F 4C 89 47 08 83 EA 10 48 8D 76 10 48 8D 7F 10 75 E5 48 89 F8 C3 90 89 F1 83 E1 07 74 29 48 8D 54 11 F8 83 E9 08 90 0F B6 06 88 07 FF C1 48 8D 76 01 48 8D 7F 01 75 EF 66 66 66 66 66 66 2E 0F 1F 84 00 00 00 00 00 48 81 FA 00 04 00 00 77 77 89 D1 C1 E9 05 74 60 FF C9 48 8B 06 4C 8B 46 08 4C 8B 4E 10 4C 8B 56 18 48 89 07 4C 89 47 08 4C 89 4F 10 4C 89 57 18 48 8D 76 20 48 8D 7F 20 74 36 FF C9 48 8B 06 4C 8B 46 08 4C 8B 4E 10 4C 8B 56 18 48 89 07 4C 89 47 08 4C 89 4F 10 4C 89 57 18 48 8D 76 20 48 8D 7F 20 75 AC 66 66 66 2E 0F 1F 84 00 00 00 00 00 83 E2 1F 0F 85 DD FE FF FF 48 89 F8 C3 0F 1F 00 4C 8B 1D ?? ?? ?? ?? 49 39 D3 4C 0F 47 DA 4C 89 D9 49 83 E3 F8 48 C1 E9 03 74 05 F3 48 A5 66 90 4C 29 DA 48 F7 C2 F8 FF FF FF 75 14 83 E2 07 0F 85 A1 FE FF FF 48 89 F8 C3 0F 1F 80 00 00 00 00 4C 8B 05 ?? ?? ?? ?? 49 39 D0 4C 0F 47 C2 4C 89 C1 49 83 E0 C0 48 C1 E9 06 0F 84 AB 01 00 00 4C 89 74 24 F8 4C 89 6C 24 F0 4C 89 64 24 E8 48 89 5C 24 E0 83 3D ?? ?? ?? ?? 00 0F 84 C0 00 00 00 48 FF C9 48 8B 06 48 8B 5E 08 4C 8B 4E 10 4C 8B 56 18 4C 8B 5E 20 4C 8B 66 28 4C 8B 6E 30 4C 8B 76 38 0F 18 8E 80 03 00 00 0F 18 8E C0 03 00 00 48 89 07 48 89 5F 08 4C 89 4F 10 4C 89 57 18 4C 89 5F 20 4C 89 67 28 4C 89 6F 30 4C 89 77 38 48 8D 76 40 48 8D 7F 40 0F 84 19 01 00 00 48 FF C9 48 8B 06 48 8B 5E 08 4C 8B 4E 10 4C 8B 56 18 4C 8B 5E 20 4C 8B 66 28 4C 8B 6E 30 4C 8B 76 38 48 89 07 48 89 5F 08 4C 89 4F 10 4C 89 57 18 4C 89 5F 20 4C 89 67 28 4C 89 6F 30 4C 89 77 38 0F 0D 8F 40 03 00 00 0F 0D 8F 80 03 00 00 48 8D 76 40 48 8D 7F 40 0F 85 46 FF FF FF E9 B7 00 00 00 90 48 FF C9 48 8B 06 48 8B 5E 08 4C 8B 4E 10 4C 8B 56 18 4C 8B 5E 20 4C 8B 66 28 4C 8B 6E 30 4C 8B 76 38 0F 18 8E 80 03 00 00 0F 18 8E C0 03 00 00 48 89 07 48 89 5F 08 4C 89 4F 10 4C 89 57 18 4C 89 5F 20 4C 89 67 28 4C 89 6F 30 4C 89 77 38 48 8D 76 40 48 8D 7F 40 74 5D 48 FF C9 48 8B 06 48 8B 5E 08 4C 8B 4E 10 4C 8B 56 18 4C 8B 5E 20 4C 8B 66 28 4C 8B 6E 30 4C 8B 76 38 0F 18 8F 40 03 00 00 0F 18 8F 80 03 00 00 48 89 07 48 89 5F 08 4C 89 4F 10 4C 89 57 18 4C 89 5F 20 4C 89 67 28 4C 89 6F 30 4C 89 77 38 48 8D 76 40 48 8D 7F 40 0F 85 4A FF FF FF 48 8B 5C 24 E0 4C 8B 64 24 E8 4C 8B 6C 24 F0 4C 8B 74 24 F8 4C 29 C2 48 F7 C2 C0 FF FF FF 75 1A 83 E2 3F 0F 85 B7 FC FF FF 48 89 F8 C3 66 66 66 66 2E 0F 1F 84 00 00 00 00 00 48 89 D1 48 C1 E9 07 0F 84 D8 00 00 00 4C 89 74 24 F8 4C 89 6C 24 F0 4C 89 64 24 E8 0F 1F 40 00 0F 18 86 00 03 00 00 0F 18 86 40 03 00 00 48 FF C9 48 8B 06 4C 8B 46 08 4C 8B 4E 10 4C 8B 56 18 4C 8B 5E 20 4C 8B 66 28 4C 8B 6E 30 4C 8B 76 38 48 0F C3 07 4C 0F C3 47 08 4C 0F C3 4F 10 4C 0F C3 57 18 4C 0F C3 5F 20 4C 0F C3 67 28 4C 0F C3 6F 30 4C 0F C3 77 38 48 8B 46 40 4C 8B 46 48 4C 8B 4E 50 4C 8B 56 58 4C 8B 5E 60 4C 8B 66 68 4C 8B 6E 70 4C 8B 76 78 48 0F C3 47 40 4C 0F C3 47 48 4C 0F C3 4F 50 4C 0F C3 57 58 4C 0F C3 5F 60 4C 0F C3 67 68 4C 0F C3 6F 70 4C 0F C3 77 78 48 8D B6 80 00 00 00 48 8D BF 80 00 00 00 0F 85 4D FF FF FF 0F AE F8 4C 8B 64 24 E8 4C 8B 6C 24 F0 4C 8B 74 24 F8 83 E2 7F 0F 85 B8 FB FF FF 48 89 F8 C3 }
	condition:
		$1
}

rule file_326_0_0 {
	meta:
		name = "l64a"
		size = 68
	strings:
		$1 = { 89 FF B8 ?? ?? ?? ?? 48 85 FF 74 36 31 C0 66 90 48 89 FA 48 C1 EF 06 83 E2 3F 0F B6 92 ?? ?? ?? ?? 88 90 ?? ?? ?? ?? 8D 50 01 48 83 C0 01 48 85 FF 75 DD 48 63 D2 B8 ?? ?? ?? ?? C6 82 ?? ?? ?? ?? 00 F3 C3 }
	condition:
		$1
}

rule file_327_0_0 {
	meta:
		name = "rexec_af"
		size = 1326
		refs = "004f __snprintf 0099 getaddrinfo 00bd free 00cb __strdup 0101 ruserpass 0113 __socket 012e __connect 0139 __libc_errno 014c __close 0155 __sleep 0170 perror 01d5 __listen 01f1 __getsockname 0206 __libc_sa_len 0235 getnameinfo 025d sprintf 02a4 __write 02d0 accept 030b freeaddrinfo 031e strtol 035f strlen 03bc __writev 0403 __read"
	strings:
		$1 = { 41 57 31 C0 66 C1 CE 08 41 56 4D 89 C6 41 55 4D 89 CD 41 54 49 89 FC 55 53 48 81 EC E8 01 00 00 48 8D 7C 24 60 48 89 54 24 48 48 89 4C 24 40 48 89 54 24 20 48 89 4C 24 28 BA ?? ?? ?? ?? 0F B7 CE BE 20 00 00 00 0F B7 9C 24 20 02 00 00 E8 ?? ?? ?? ?? 48 8D 94 24 80 00 00 00 31 C0 B9 06 00 00 00 48 8D 74 24 60 C6 44 24 7F 00 48 89 D7 F3 48 AB 48 8D 4C 24 58 89 9C 24 84 00 00 00 C7 84 24 88 00 00 00 01 00 00 00 C7 84 24 80 00 00 00 02 00 00 00 49 8B 3C 24 E8 ?? ?? ?? ?? 85 C0 0F 85 8A 02 00 00 48 8B 44 24 58 48 83 78 20 00 0F 84 BF 03 00 00 48 8B 3D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 44 24 58 48 8B 78 20 E8 ?? ?? ?? ?? 48 85 C0 48 89 05 ?? ?? ?? ?? 0F 84 00 04 00 00 49 89 04 24 48 8B 44 24 58 48 8D 54 24 40 48 8D 74 24 48 BB 06 00 00 00 BD 01 00 00 00 48 8B 78 20 E8 ?? ?? ?? ?? 48 8B 44 24 58 31 D2 8B 70 08 8B 78 04 E8 ?? ?? ?? ?? 85 C0 41 89 C7 78 72 48 8B 44 24 58 44 89 FF 8B 50 10 48 8B 70 18 E8 ?? ?? ?? ?? 85 C0 79 72 48 8B 05 ?? ?? ?? ?? 64 83 38 6F 75 1D 83 EB 01 74 18 44 89 FF E8 ?? ?? ?? ?? 89 EF 01 ED E8 ?? ?? ?? ?? EB AA 0F 1F 44 00 00 48 8B 44 24 58 41 BF FF FF FF FF 48 8B 78 20 E8 ?? ?? ?? ?? 48 81 C4 E8 01 00 00 44 89 F8 5B 5D 41 5C 41 5D 41 5E 41 5F C3 0F 1F 80 00 00 00 00 BF ?? ?? ?? ?? 41 BF FF FF FF FF E8 ?? ?? ?? ?? EB D2 66 0F 1F 44 00 00 4D 85 ED 0F 84 E4 02 00 00 48 8B 44 24 58 31 D2 8B 70 08 8B 78 04 E8 ?? ?? ?? ?? 85 C0 89 C3 0F 88 4E 03 00 00 BE 01 00 00 00 89 C7 E8 ?? ?? ?? ?? 48 8D 54 24 50 48 8D B4 24 60 01 00 00 89 DF C7 44 24 50 80 00 00 00 E8 ?? ?? ?? ?? 85 C0 0F 88 08 03 00 00 0F B7 BC 24 60 01 00 00 E8 ?? ?? ?? ?? 3B 44 24 50 0F 85 B1 02 00 00 4C 8D 44 24 60 48 8D BC 24 60 01 00 00 31 D2 31 C9 C7 04 24 02 00 00 00 41 B9 20 00 00 00 89 C6 E8 ?? ?? ?? ?? 31 D2 85 C0 66 C7 44 24 3E 00 00 0F 84 CA 00 00 00 48 8D AC 24 B0 00 00 00 BE ?? ?? ?? ?? 31 C0 48 89 EF E8 ?? ?? ?? ?? 48 89 EA 8B 0A 48 83 C2 04 8D 81 FF FE FE FE F7 D1 21 C8 25 80 80 80 80 74 E9 89 C1 48 89 EE 44 89 FF C1 E9 10 A9 80 80 00 00 0F 44 C1 48 8D 4A 02 48 0F 44 D1 00 C0 48 83 DA 03 48 29 EA 48 83 C2 01 E8 ?? ?? ?? ?? 48 8D 44 24 54 C7 44 24 54 80 00 00 00 48 89 44 24 30 66 0F 1F 44 00 00 48 8B 54 24 30 48 8D B4 24 E0 00 00 00 89 DF E8 ?? ?? ?? ?? 83 F8 FF 75 61 48 8B 05 ?? ?? ?? ?? 64 83 38 04 74 DA 89 DF E8 ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 44 89 FF 41 BF FF FF FF FF E8 ?? ?? ?? ?? 48 8B 7C 24 58 E8 ?? ?? ?? ?? E9 60 FE FF FF 48 8D 7C 24 60 B2 0A 31 F6 E8 ?? ?? ?? ?? 66 89 44 24 3E 0F B7 D0 E9 1B FF FF FF 41 BF FF FF FF FF E9 3A FE FF FF 89 DF 89 44 24 18 E8 ?? ?? ?? ?? 8B 54 24 18 85 D2 78 A0 41 89 55 00 48 8B 7C 24 48 48 89 BC 24 B0 00 00 00 E8 ?? ?? ?? ?? 48 8B 7C 24 40 48 83 C0 01 48 89 84 24 B8 00 00 00 48 89 BC 24 C0 00 00 00 E8 ?? ?? ?? ?? 4C 89 F7 48 83 C0 01 4C 89 B4 24 D0 00 00 00 48 89 84 24 C8 00 00 00 E8 ?? ?? ?? ?? 48 83 C0 01 48 89 84 24 D8 00 00 00 0F 1F 80 00 00 00 00 BA 03 00 00 00 48 89 EE 44 89 FF E8 ?? ?? ?? ?? 48 83 F8 FF 75 0D 48 8B 05 ?? ?? ?? ?? 64 83 38 04 74 DD 48 8B 7C 24 48 48 3B 7C 24 20 74 05 E8 ?? ?? ?? ?? 48 8B 7C 24 40 48 3B 7C 24 28 74 05 E8 ?? ?? ?? ?? 48 8B 74 24 30 BA 01 00 00 00 44 89 FF E8 ?? ?? ?? ?? 48 83 F8 01 0F 85 E3 00 00 00 80 7C 24 54 00 75 0F 48 8B 7C 24 58 E8 ?? ?? ?? ?? E9 4D FD FF FF 48 8B 74 24 30 BA 01 00 00 00 44 89 FF E8 ?? ?? ?? ?? 48 83 F8 01 75 1B 48 8B 74 24 30 BA 01 00 00 00 BF 02 00 00 00 E8 ?? ?? ?? ?? 80 7C 24 54 0A 75 CD 66 83 7C 24 3E 00 0F 84 91 FE FF FF 41 8B 7D 00 E8 ?? ?? ?? ?? E9 83 FE FF FF 48 8B 05 ?? ?? ?? ?? 49 C7 04 24 00 00 00 00 41 BF FF FF FF FF 64 C7 00 02 00 00 00 E9 DF FC FF FF BA 01 00 00 00 BE ?? ?? ?? ?? 44 89 FF E8 ?? ?? ?? ?? 48 8D 44 24 54 66 C7 44 24 3E 00 00 48 8D AC 24 B0 00 00 00 48 89 44 24 30 E9 8C FE FF FF 48 8B 05 ?? ?? ?? ?? 89 DF 64 C7 00 16 00 00 00 E8 ?? ?? ?? ?? E9 18 FE FF FF BF ?? ?? ?? ?? 41 BF FF FF FF FF E8 ?? ?? ?? ?? E9 80 FC FF FF 49 8B 3C 24 E8 ?? ?? ?? ?? 0F 1F 00 E9 55 FF FF FF BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 DF E8 ?? ?? ?? ?? E9 DC FD FF FF 44 89 FF 41 BF FF FF FF FF E8 ?? ?? ?? ?? E9 46 FC FF FF }
	condition:
		$1
}

rule file_327_1_0 {
	meta:
		name = "rexec"
		size = 21
		refs = "000c rexec_af"
	strings:
		$1 = { 48 83 EC 18 C7 04 24 02 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_330_0_0 {
	meta:
		name = "__ctype_get_mb_cur_max"
		size = 21
		refs = "0003 _nl_current_LC_CTYPE"
	strings:
		$1 = { 48 8B 05 ?? ?? ?? ?? 64 48 8B 00 48 8B 00 8B 80 A8 00 00 00 C3 }
	condition:
		$1
}

rule file_331_0_0 {
	meta:
		name = "map_newlink"
		size = 116
	strings:
		$1 = { 85 C9 7E 3A 8B 02 83 F8 FF 74 39 39 F8 74 37 48 83 C2 04 41 B8 01 00 00 00 EB 1B 0F 1F 44 00 00 44 8B 0A 41 83 F9 FF 74 2F 49 83 C0 01 48 83 C2 04 41 39 F9 74 1A 44 39 C1 44 89 C0 7F E2 B8 FF FF FF FF C3 89 3A 31 C0 0F 1F 84 00 00 00 00 00 F3 C3 66 0F 1F 44 00 00 89 3A 49 8D 50 FF 4D 69 C0 B8 00 00 00 48 69 D2 B8 00 00 00 49 01 F0 4C 89 04 16 C3 }
	condition:
		$1
}

rule file_331_1_0 {
	meta:
		name = "getifaddrs_internal"
		size = 2983
		refs = "0049 __netlink_open 005f __netlink_request 0150 __netlink_free_handle 021a calloc 0264 memset 04d3 memcpy 0593 mempcpy 0b80 free 0b9e __assert_fail 0ba3 abort"
	strings:
		$1 = { 55 48 89 E5 41 57 41 56 41 55 41 54 53 48 81 EC A8 00 00 00 48 89 7D 80 48 C7 07 00 00 00 00 48 8D 7D B0 C7 45 B0 00 00 00 00 C7 45 B4 00 00 00 00 C7 45 B8 00 00 00 00 48 C7 45 C0 00 00 00 00 48 C7 45 C8 00 00 00 00 E8 ?? ?? ?? ?? 85 C0 0F 88 17 0B 00 00 48 8D 7D B0 BE 12 00 00 00 E8 ?? ?? ?? ?? 85 C0 0F 88 76 01 00 00 48 8D 7D B0 BE 16 00 00 00 83 45 B8 01 E8 ?? ?? ?? ?? 85 C0 0F 88 5C 01 00 00 4C 8B 6D C0 4D 85 ED 0F 84 64 01 00 00 8B 7D B4 4D 89 E8 45 31 C9 45 31 D2 C7 45 9C 00 00 00 00 31 DB 66 0F 1F 84 00 00 00 00 00 49 8B 40 08 49 8B 50 10 48 85 C0 74 73 48 83 FA 0F 76 6D 8B 08 83 F9 0F 76 66 89 CE 48 39 F2 73 27 EB 5D 0F 1F 44 00 00 83 C1 03 83 E1 FC 48 29 CA 48 01 C8 48 83 FA 0F 76 46 8B 08 83 F9 0F 76 3F 89 CE 48 39 D6 77 38 39 78 0C 75 DB 45 8B 58 18 44 39 58 08 75 D1 44 0F B7 58 04 66 41 83 FB 03 74 1D 66 41 83 FB 10 74 56 31 F6 66 41 83 FB 14 40 0F 94 C6 41 01 F2 EB AE 66 0F 1F 44 00 00 4D 8B 00 4D 85 C0 0F 85 74 FF FF FF 89 5D 9C 31 DB 44 03 55 9C 0F 85 B2 00 00 00 48 8D 7D B0 E8 ?? ?? ?? ?? 48 63 7D B0 B8 03 00 00 00 0F 05 48 8D 65 D8 89 D8 5B 41 5C 41 5D 41 5E 41 5F 5D C3 48 83 EE 20 4C 8D 60 20 48 83 FE 03 76 5B 44 0F B7 58 20 66 41 83 FB 03 76 4F 45 0F B7 F3 4C 39 F6 72 46 49 83 EE 04 66 83 78 22 07 75 24 EB 4B 45 0F B7 1C 24 66 41 83 FB 03 76 2D 45 0F B7 F3 49 39 F6 77 24 49 83 EE 04 66 41 83 7C 24 02 07 74 29 41 83 C3 03 41 81 E3 FC FF 01 00 4C 29 DE 4D 01 DC 48 83 FE 03 77 C7 83 C3 01 E9 F7 FE FF FF BB FF FF FF FF E9 60 FF FF FF 4D 01 F1 83 C3 01 E9 E2 FE FF FF 31 DB E9 4E FF FF FF 45 89 D2 BF 01 00 00 00 49 69 DA B8 00 00 00 49 01 D9 4C 89 CE 4C 89 8D 48 FF FF FF E8 ?? ?? ?? ?? 48 85 C0 48 89 45 A0 74 BA 44 8B 5D 9C BE FF FF FF FF 4D 89 EC 4C 89 DA 4C 89 9D 40 FF FF FF 48 C1 E2 02 48 8D 42 1E 48 C1 E8 04 48 C1 E0 04 48 29 C4 4C 8D 5C 24 0F 49 83 E3 F0 4C 89 DF 4C 89 9D 70 FF FF FF E8 ?? ?? ?? ?? 48 03 5D A0 C7 45 98 00 00 00 00 48 89 9D 68 FF FF FF 66 0F 1F 44 00 00 4D 8B 44 24 08 49 8B 5C 24 10 4D 85 C0 0F 84 50 02 00 00 48 83 FB 0F 0F 86 46 02 00 00 45 8B 10 41 83 FA 0F 0F 86 39 02 00 00 4C 39 D3 0F 82 30 02 00 00 4D 89 C5 4D 89 E6 4D 89 D0 EB 33 66 90 41 8B 45 00 83 C0 03 83 E0 FC 48 29 C3 49 01 C5 48 83 FB 0F 0F 86 06 02 00 00 45 8B 45 00 41 83 F8 0F 0F 86 F8 01 00 00 49 39 D8 0F 87 EF 01 00 00 8B 45 B4 41 39 45 0C 75 C6 41 8B 56 18 41 39 55 08 75 BC 41 0F B7 45 04 66 83 F8 03 0F 84 CD 01 00 00 66 83 F8 10 0F 84 9B 03 00 00 66 83 F8 14 75 9D 41 8B 7D 14 8B 4D 9C 49 83 E8 18 48 8B 95 70 FF FF FF 48 8B 75 A0 4D 8D 7D 18 44 8B 65 98 4C 89 85 38 FF FF FF 83 EF 01 44 03 65 9C E8 5C F8 FF FF 83 F8 FF 4C 8B 85 38 FF FF FF 0F 84 12 08 00 00 48 98 49 63 D4 48 8B 4D A0 48 69 C0 B8 00 00 00 4C 69 D2 B8 00 00 00 4C 03 55 A0 45 85 E4 8B 44 01 10 41 89 42 10 7E 0F 48 8D 42 FF 48 69 C0 B8 00 00 00 4C 89 14 01 83 45 98 01 49 83 F8 03 0F 86 60 05 00 00 41 0F B7 45 18 66 83 F8 03 0F 86 51 05 00 00 49 39 C0 0F 82 48 05 00 00 4D 8D 62 38 4D 8D 9A A4 00 00 00 49 8D 8A 82 00 00 00 48 89 5D 90 4C 89 75 88 4D 89 EE 4C 89 E3 4C 89 5D A8 48 89 8D 78 FF FF FF 4D 89 C5 4D 89 D4 EB 41 0F 1F 40 00 66 83 FF 01 0F 84 5E 02 00 00 41 0F B7 07 83 C0 03 25 FC FF 01 00 49 29 C5 49 01 C7 49 83 FD 03 0F 86 DD 04 00 00 41 0F B7 07 66 83 F8 03 0F 86 CF 04 00 00 4C 39 E8 0F 87 C6 04 00 00 41 0F B7 7F 02 49 8D 77 04 48 8D 50 FC 66 83 FF 02 0F 84 54 01 00 00 76 AA 66 83 FF 03 0F 84 20 01 00 00 66 83 FF 04 75 A4 49 83 7C 24 28 00 49 8D 84 24 80 00 00 00 74 2B 49 C7 84 24 80 00 00 00 00 00 00 00 48 C7 40 08 00 00 00 00 48 C7 40 10 00 00 00 00 48 C7 40 18 00 00 00 00 C7 40 20 00 00 00 00 49 89 44 24 28 41 0F B6 46 10 66 41 89 84 24 80 00 00 00 41 0F B6 46 10 3C 02 0F 84 07 05 00 00 3C 0A 0F 84 9C 04 00 00 48 83 FA 24 0F 87 37 FF FF FF 48 8B BD 78 FF FF FF E8 ?? ?? ?? ?? E9 26 FF FF FF 0F 1F 40 00 4D 89 F4 4D 8B 24 24 4D 85 E4 0F 85 90 FD FF FF 48 8B 45 A0 48 03 85 48 FF FF FF 48 39 85 68 FF FF FF 0F 87 81 06 00 00 8B 7D 98 85 FF 74 50 8B 75 9C 85 F6 74 49 48 8B 8D 40 FF FF FF 48 8B 95 70 FF FF FF B8 FF FF FF FF 4C 8B 45 A0 48 69 F9 B8 00 00 00 8B 4D 9C 48 03 7D A0 83 E9 01 EB 0B 83 C0 01 48 83 C2 04 39 C8 74 14 83 3A FF 75 F0 89 C6 48 69 F6 B8 00 00 00 49 89 3C 30 EB E1 48 8B 55 A0 48 8B 45 80 31 DB 48 89 10 E9 DA FB FF FF 0F 1F 80 00 00 00 00 48 83 E8 03 48 83 F8 11 0F 87 1C 06 00 00 4C 8B 5D A8 4D 89 5C 24 08 4C 89 DF E8 ?? ?? ?? ?? C6 00 00 E9 63 FE FF FF 90 49 83 7C 24 18 00 74 74 49 8B 44 24 38 49 89 84 24 80 00 00 00 49 8B 44 24 40 49 89 84 24 88 00 00 00 49 8B 44 24 48 49 89 84 24 90 00 00 00 49 8B 44 24 50 49 89 84 24 98 00 00 00 41 8B 44 24 58 48 C7 03 00 00 00 00 48 C7 43 08 00 00 00 00 48 C7 43 10 00 00 00 00 48 C7 43 18 00 00 00 00 41 89 84 24 A0 00 00 00 49 8D 84 24 80 00 00 00 C7 43 20 00 00 00 00 49 89 44 24 28 49 89 5C 24 18 41 0F B6 46 10 66 41 89 44 24 38 41 0F B6 46 10 3C 02 0F 84 67 04 00 00 3C 0A 0F 84 03 04 00 00 48 83 FA 24 0F 87 B7 FD FF FF 49 8D 7C 24 3A E8 ?? ?? ?? ?? E9 A8 FD FF FF 66 0F 1F 44 00 00 49 83 7C 24 18 00 0F 84 4A 04 00 00 49 8D 84 24 80 00 00 00 49 89 44 24 28 41 0F B6 7E 10 66 89 38 41 0F B6 7E 10 40 80 FF 02 0F 84 A0 03 00 00 40 80 FF 0A 0F 84 3F 03 00 00 48 83 FA 24 0F 87 5E FD FF FF 48 8D 78 02 E8 ?? ?? ?? ?? E9 50 FD FF FF 66 0F 1F 44 00 00 41 8B 7D 14 8B 4D 9C 49 83 E8 20 48 8B 95 70 FF FF FF 48 8B 75 A0 4D 8D 65 20 4C 89 85 38 FF FF FF 83 EF 01 E8 CF F4 FF FF 83 F8 FF 4C 8B 85 38 FF FF FF 0F 84 85 04 00 00 48 98 4C 8B 7D A0 4C 69 D0 B8 00 00 00 41 8B 45 18 4D 01 D7 49 83 F8 03 41 89 47 10 0F 86 AD FB FF FF 41 0F B7 45 20 66 83 F8 03 0F 86 9E FB FF FF 49 39 C0 0F 82 95 FB FF FF 49 8D 8F A4 00 00 00 4D 8D 5F 44 48 89 5D 88 4C 89 B5 78 FF FF FF 48 8B 9D 68 FF FF FF 4D 89 FE 48 89 4D 90 4C 89 9D 60 FF FF FF 49 8D 4F 38 4D 8D 9F 8C 00 00 00 4D 89 E7 4D 89 C4 48 89 8D 58 FF FF FF 4C 89 9D 50 FF FF FF EB 46 66 0F 1F 84 00 00 00 00 00 66 83 FA 01 0F 84 06 01 00 00 41 0F B7 07 83 C0 03 25 FC FF 01 00 49 29 C4 49 01 C7 49 83 FC 03 0F 86 3E 01 00 00 41 0F B7 07 66 83 F8 03 0F 86 30 01 00 00 4C 39 E0 0F 87 27 01 00 00 41 0F B7 57 02 49 8D 77 04 48 8D 48 FC 66 83 FA 02 74 30 76 AE 66 83 FA 03 0F 84 84 00 00 00 66 83 FA 07 75 A8 4C 8D 1C 0B 49 89 5E 30 48 89 DF 48 89 CA 4C 89 5D A8 E8 ?? ?? ?? ?? 48 8B 5D A8 EB 8B 90 48 83 F9 24 77 84 48 8B BD 50 FF FF FF 66 41 C7 86 80 00 00 00 11 00 48 89 CA 48 89 8D 38 FF FF FF E8 ?? ?? ?? ?? 48 8B 8D 38 FF FF FF 41 88 8E 8B 00 00 00 41 8B 45 14 41 89 86 84 00 00 00 41 0F B7 45 12 66 41 89 86 88 00 00 00 49 8D 86 80 00 00 00 49 89 46 28 E9 2E FF FF FF 0F 1F 40 00 48 83 E8 03 48 83 F8 11 0F 87 1C FF FF FF 4C 8B 5D 90 48 89 CA 4D 89 5E 08 4C 89 DF E8 ?? ?? ?? ?? C6 00 00 E9 01 FF FF FF 0F 1F 80 00 00 00 00 48 83 F9 24 0F 87 F0 FE FF FF 48 8B BD 60 FF FF FF 66 41 C7 46 38 11 00 48 89 CA 48 89 8D 38 FF FF FF E8 ?? ?? ?? ?? 48 8B 8D 38 FF FF FF 41 88 4E 43 41 8B 45 14 48 8B 8D 58 FF FF FF 41 89 46 3C 41 0F B7 45 12 49 89 4E 18 66 41 89 46 40 E9 A6 FE FF FF 48 89 9D 68 FF FF FF 4C 8B B5 78 FF FF FF 48 8B 5D 88 E9 C5 F9 FF FF 4D 89 F5 48 8B 5D 90 4C 8B 75 88 4D 89 E2 49 83 7A 08 00 0F 84 10 02 00 00 49 8B 42 18 48 85 C0 0F 84 9F F9 FF FF 0F B7 10 66 85 D2 0F 84 93 F9 FF FF 66 83 FA 11 0F 84 89 F9 FF FF 49 8D 42 5C 66 83 FA 02 49 89 42 20 0F 84 D0 01 00 00 66 83 FA 0A 0F 84 70 01 00 00 66 41 89 52 5C E9 63 F9 FF FF 48 83 FA 10 0F 85 9B FA FF FF 48 8B 06 49 89 84 24 88 00 00 00 48 8B 46 08 49 89 84 24 90 00 00 00 41 8B 47 04 25 FF C0 00 00 3D FE 80 00 00 74 1B 41 80 7F 04 FF 0F 85 69 FA FF FF 41 0F B6 47 05 83 E0 0F 3C 02 0F 85 59 FA FF FF 41 8B 46 14 41 89 84 24 98 00 00 00 E9 48 FA FF FF 66 0F 1F 44 00 00 48 83 FA 04 0F 85 38 FA FF FF 8B 06 41 89 84 24 84 00 00 00 E9 29 FA FF FF 48 83 FA 10 0F 85 1F FA FF FF 48 8B 16 48 89 50 08 48 8B 56 08 48 89 50 10 41 8B 57 04 81 E2 FF C0 00 00 81 FA FE 80 00 00 74 1C 41 80 7F 04 FF 0F 85 F3 F9 FF FF 41 0F B6 57 05 83 E2 0F 80 FA 02 0F 85 E2 F9 FF FF 41 8B 56 14 89 50 18 E9 D6 F9 FF FF 0F 1F 40 00 48 83 FA 04 0F 85 C8 F9 FF FF 8B 16 89 50 04 E9 BE F9 FF FF 48 83 FA 10 0F 85 B4 F9 FF FF 48 8B 06 49 89 44 24 40 48 8B 46 08 49 89 44 24 48 41 8B 47 04 25 FF C0 00 00 3D FE 80 00 00 74 1B 41 80 7F 04 FF 0F 85 88 F9 FF FF 41 0F B6 47 05 83 E0 0F 3C 02 0F 85 78 F9 FF FF 41 8B 46 14 41 89 44 24 50 E9 6A F9 FF FF 0F 1F 84 00 00 00 00 00 48 83 FA 04 0F 85 58 F9 FF FF 8B 06 41 89 44 24 3C E9 4C F9 FF FF 48 89 D8 49 89 5C 24 18 E9 B6 FB FF FF 49 8D 42 64 B9 80 00 00 00 66 41 89 52 5C 41 0F B6 55 11 39 D1 0F 47 CA 89 CE C1 EE 03 8D 56 FF 85 F6 48 8D 54 10 01 74 10 0F 1F 40 00 C6 00 FF 48 83 C0 01 48 39 D0 75 F4 89 CA B9 08 00 00 00 41 BB FF FF FF FF 83 E2 07 29 D1 41 D3 E3 44 88 18 E9 A7 F7 FF FF 49 8D 42 60 B9 20 00 00 00 EB A8 41 8B 7D 14 8B 4D 9C 48 8B 95 70 FF FF FF 48 8B 75 A0 4C 89 95 38 FF FF FF 83 EF 01 E8 6B F0 FF FF 83 F8 FF 4C 8B 95 38 FF FF FF 74 25 48 98 48 8B 55 A0 48 69 C0 B8 00 00 00 48 8B 44 02 08 49 89 42 08 E9 A8 FD FF FF BB FF FF FF FF E9 E9 F5 FF FF 48 8B 7D A0 BB F5 FF FF FF E8 ?? ?? ?? ?? E9 C2 F5 FF FF B9 ?? ?? ?? ?? BA 31 03 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_331_2_0 {
	meta:
		name = "__netlink_free_handle"
		size = 58
		refs = "0006 __libc_errno 0024 free"
	strings:
		$1 = { 41 54 55 48 8B 2D ?? ?? ?? ?? 53 48 8B 7F 10 64 44 8B 65 00 48 85 FF 74 17 0F 1F 80 00 00 00 00 48 8B 1F E8 ?? ?? ?? ?? 48 85 DB 48 89 DF 75 F0 64 44 89 65 00 5B 5D 41 5C C3 }
	condition:
		$1
}

rule file_331_3_0 {
	meta:
		name = "__netlink_request"
		size = 727
		refs = "00ab __libc_errno 00d3 __sendto 0129 __recvmsg 023b malloc 0261 memcpy 02a5 time"
	strings:
		$1 = { 55 48 89 E5 41 57 41 56 41 55 41 54 53 48 89 FB 48 81 EC 98 00 00 00 8B 57 08 48 C7 85 68 FF FF FF 00 10 00 00 48 81 EC 10 10 00 00 4C 8D 6C 24 0F 49 83 E5 F0 85 D2 4C 89 AD 60 FF FF FF 0F 84 58 02 00 00 48 C7 85 50 FF FF FF 00 00 00 00 C7 85 70 FF FF FF 14 00 00 00 4C 8D A5 50 FF FF FF 66 89 B5 74 FF FF FF 66 C7 85 76 FF FF FF 01 03 C7 85 7C FF FF FF 00 00 00 00 89 95 78 FF FF FF C6 45 80 00 66 C7 45 81 00 00 C6 45 83 00 C7 85 58 FF FF FF 00 00 00 00 66 C7 85 50 FF FF FF 10 00 EB 16 0F 1F 44 00 00 48 8B 15 ?? ?? ?? ?? 64 83 3A 04 0F 85 8F 00 00 00 8B 3B 48 8D B5 70 FF FF FF 31 C9 41 B9 0C 00 00 00 4D 89 E0 BA 14 00 00 00 E8 ?? ?? ?? ?? 48 83 F8 FF 74 CB 85 C0 78 62 4C 8D B5 60 FF FF FF 0F 1F 84 00 00 00 00 00 4C 89 65 90 C7 45 98 0C 00 00 00 4C 89 75 A0 48 C7 45 A8 01 00 00 00 48 C7 45 B0 00 00 00 00 48 C7 45 B8 00 00 00 00 C7 45 C0 00 00 00 00 66 90 8B 3B 48 8D 75 90 31 D2 E8 ?? ?? ?? ?? 48 83 F8 FF 49 89 C7 75 2A 48 8B 05 ?? ?? ?? ?? 64 83 38 04 74 DD B8 FF FF FF FF 48 8D 65 D8 5B 41 5C 41 5D 41 5E 41 5F 5D C3 66 0F 1F 84 00 00 00 00 00 48 85 C0 78 DE 8B 95 54 FF FF FF 85 D2 75 81 F6 45 C0 20 75 CE 48 83 F8 0F 0F 86 71 FF FF FF 41 8B 75 00 83 FE 0F 0F 86 64 FF FF FF 89 F0 49 39 C7 0F 82 59 FF FF FF 8B 53 04 4C 89 FF 4C 89 E9 45 31 C0 EB 23 0F 1F 00 83 C6 03 83 E6 FC 48 29 F7 48 01 F1 48 83 FF 0F 76 56 8B 31 83 FE 0F 76 4F 89 F0 48 39 F8 77 48 3B 51 0C 75 DB 8B 43 08 39 41 08 75 D3 0F B7 41 04 49 83 C0 01 66 83 F8 03 0F 84 D2 00 00 00 66 83 F8 02 75 BB 83 FE 23 0F 87 CD 00 00 00 48 8B 05 ?? ?? ?? ?? 64 C7 00 05 00 00 00 E9 3A FF FF FF 0F 1F 80 00 00 00 00 31 C9 4D 85 C0 75 19 84 C9 0F 84 D1 FE FF FF 48 8D 65 D8 31 C0 5B 41 5C 41 5D 41 5E 41 5F 5D C3 49 8D 7F 20 88 8D 40 FF FF FF E8 ?? ?? ?? ?? 48 85 C0 0F 84 FB FE FF FF 48 8D 78 20 48 C7 00 00 00 00 00 4C 89 FA 4C 89 EE 48 89 85 48 FF FF FF E8 ?? ?? ?? ?? 4C 8B 85 48 FF FF FF 48 83 7B 10 00 0F B6 8D 40 FF FF FF 49 89 40 08 8B 43 08 4D 89 78 10 41 89 40 18 74 0D 48 8B 43 18 4C 89 00 4C 89 43 18 EB 81 4C 89 43 10 EB F4 31 FF 89 B5 48 FF FF FF E8 ?? ?? ?? ?? 8B B5 48 FF FF FF 89 C2 89 43 08 E9 8B FD FF FF B9 01 00 00 00 E9 4F FF FF FF 8B 41 10 48 8B 15 ?? ?? ?? ?? F7 D8 64 89 02 E9 6C FE FF FF }
	condition:
		$1
}

rule file_331_5_0 {
	meta:
		name = "__netlink_open"
		size = 159
		refs = "0015 __socket 0044 __bind 0061 __getsockname"
	strings:
		$1 = { 53 31 D2 48 89 FB BE 03 00 00 00 BF 10 00 00 00 48 83 EC 20 E8 ?? ?? ?? ?? 85 C0 89 03 78 79 48 8D 74 24 10 BA 0C 00 00 00 89 C7 48 C7 44 24 10 00 00 00 00 C7 44 24 18 00 00 00 00 66 C7 44 24 10 10 00 E8 ?? ?? ?? ?? 85 C0 78 34 8B 3B 48 8D 54 24 0C 48 8D 74 24 10 C7 44 24 0C 0C 00 00 00 E8 ?? ?? ?? ?? 85 C0 78 17 8B 44 24 14 89 43 04 31 C0 48 83 C4 20 5B C3 0F 1F 84 00 00 00 00 00 48 63 3B B8 03 00 00 00 0F 05 B8 FF FF FF FF EB E1 0F 1F 80 00 00 00 00 B8 FF FF FF FF EB D3 }
	condition:
		$1
}

rule file_331_6_0 {
	meta:
		name = "getifaddrs"
		size = 23
	strings:
		$1 = { 53 48 89 FB 0F 1F 40 00 48 89 DF E8 40 F4 FF FF 83 F8 F5 74 F3 5B C3 }
	condition:
		$1
}

rule file_332_0_0 {
	meta:
		name = "_L_lock_36"
		size = 27
		refs = "000b __lll_lock_wait_private"
	strings:
		$1 = { 48 8D 3A 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 24 FF FF FF }
	condition:
		$1
}

rule file_332_1_0 {
	meta:
		name = "_L_unlock_89"
		size = 27
		refs = "000b __lll_unlock_wake_private"
	strings:
		$1 = { 48 8D 3A 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 74 FF FF FF }
	condition:
		$1
}

rule file_332_3_0 {
	meta:
		name = "putwchar"
		size = 277
		refs = "0004 _IO_stdout 0038 __libc_multiple_threads 00d1 __woverflow 0111 _Unwind_Resume"
	strings:
		$1 = { 53 48 8B 1D ?? ?? ?? ?? 41 89 F8 8B 03 48 89 DF 25 00 80 00 00 75 53 48 8B 93 88 00 00 00 64 4C 8B 0C 25 10 00 00 00 4C 3B 4A 08 0F 84 97 00 00 00 BE 01 00 00 00 83 3D ?? ?? ?? ?? 00 74 0C F0 0F B1 32 0F 85 CC 00 00 00 EB 09 0F B1 32 0F 85 C1 00 00 00 48 8B 93 88 00 00 00 48 8B 3D ?? ?? ?? ?? 4C 89 4A 08 83 42 04 01 48 8B 97 A0 00 00 00 48 85 D2 74 57 48 8B 4A 20 48 3B 4A 28 73 4D 44 89 01 48 83 C1 04 44 89 C6 48 89 4A 20 F7 03 00 80 00 00 75 29 48 8B 93 88 00 00 00 83 6A 04 01 75 1C 48 C7 42 08 00 00 00 00 83 3D ?? ?? ?? ?? 00 74 07 F0 FF 0A 75 77 EB 04 FF 0A 75 71 89 F0 5B C3 0F 1F 44 00 00 48 89 DF EB 99 44 89 C6 E8 ?? ?? ?? ?? 89 C6 EB B5 F7 03 00 80 00 00 48 89 C6 75 29 48 8B 93 88 00 00 00 83 6A 04 01 75 1C 48 C7 42 08 00 00 00 00 83 3D ?? ?? ?? ?? 00 74 07 F0 FF 0A 75 44 EB 04 FF 0A 75 3E 48 89 F7 E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_333_0_0 {
	meta:
		name = "futimesat"
		size = 375
		refs = "001d __have_atfcts 006b __libc_errno 00a0 strlen 00d9 __snprintf 0100 __atfct_seterrno 011c __futimes"
	strings:
		$1 = { 55 48 89 E5 48 89 5D E0 4C 89 65 E8 48 89 F3 4C 89 6D F0 4C 89 75 F8 48 83 EC 20 8B 05 ?? ?? ?? ?? 41 89 FC 49 89 D5 85 C0 78 5D 48 85 F6 0F 84 E4 00 00 00 48 63 FF B8 05 01 00 00 0F 05 48 3D 00 F0 FF FF 0F 87 06 01 00 00 83 F8 FF 74 19 48 8B 5D E0 4C 8B 65 E8 4C 8B 6D F0 4C 8B 75 F8 C9 C3 0F 1F 80 00 00 00 00 48 8B 15 ?? ?? ?? ?? 64 83 3A 26 B8 FF FF FF FF 75 D5 89 05 ?? ?? ?? ?? EB 0F 66 0F 1F 44 00 00 48 85 F6 0F 84 97 00 00 00 41 83 FC 9C 74 79 80 3B 2F 74 74 48 89 DF E8 ?? ?? ?? ?? 48 85 C0 0F 84 B4 00 00 00 48 8D 70 20 48 83 C0 3E 49 89 D8 48 83 E0 F0 44 89 E1 BA ?? ?? ?? ?? 48 29 C4 31 C0 4C 8D 74 24 0F 49 83 E6 F0 4C 89 F7 4C 89 F3 E8 ?? ?? ?? ?? 4C 89 EE 48 89 DF B8 EB 00 00 00 0F 05 3D 00 F0 FF FF 0F 86 5A FF FF FF 89 C7 4C 89 F2 44 89 E6 F7 DF E8 ?? ?? ?? ?? 83 C8 FF E9 43 FF FF FF 0F 1F 40 00 45 31 F6 EB C8 0F 1F 00 48 89 D6 E8 ?? ?? ?? ?? E9 2A FF FF FF 0F 1F 00 48 83 EC 30 89 F9 BA ?? ?? ?? ?? 4C 8D 74 24 0F BE 1D 00 00 00 31 C0 49 83 E6 F0 4C 89 F7 4C 89 F3 E8 ?? ?? ?? ?? EB 8D 48 8B 15 ?? ?? ?? ?? F7 D8 64 89 02 E9 0E FF FF FF 48 8B 05 ?? ?? ?? ?? 64 C7 00 02 00 00 00 83 C8 FF E9 D8 FE FF FF }
	condition:
		$1
}

rule file_334_0_0 {
	meta:
		name = "__getpeername"
		size = 20
		refs = "000f __syscall_error"
	strings:
		$1 = { B8 34 00 00 00 0F 05 48 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_335_0_0 {
	meta:
		name = "__lxstat"
		size = 69
		refs = "0023 __libc_errno"
	strings:
		$1 = { 83 FF 01 48 89 F0 77 18 48 89 C7 48 89 D6 B8 06 00 00 00 0F 05 48 3D 00 F0 FF FF 77 17 F3 C3 90 48 8B 05 ?? ?? ?? ?? 64 C7 00 16 00 00 00 B8 FF FF FF FF C3 48 8B 15 ?? ?? ?? ?? F7 D8 64 89 02 48 83 C8 FF C3 }
	condition:
		$1
}

rule file_337_0_0 {
	meta:
		name = "do_sigpause"
		size = 119
		refs = "003c __sigsuspend 005a __sigprocmask 0068 sigdelset"
	strings:
		$1 = { 55 53 48 81 EC 88 00 00 00 85 F6 75 43 89 FD 48 8D 44 24 08 48 89 2C 24 0F 1F 84 00 00 00 00 00 48 8D 94 24 80 00 00 00 48 C7 00 00 00 00 00 48 83 C0 08 48 39 D0 75 E8 48 89 E7 E8 ?? ?? ?? ?? 48 81 C4 88 00 00 00 5B 5D C3 66 0F 1F 44 00 00 31 F6 89 FD 48 89 E2 31 FF E8 ?? ?? ?? ?? 85 C0 78 0E 89 EE 48 89 E7 E8 ?? ?? ?? ?? 85 C0 79 C8 B8 FF FF FF FF EB C9 }
	condition:
		$1
}

rule file_337_1_0 {
	meta:
		name = "__sigpause"
		size = 81
		refs = "0002 __libc_multiple_threads 0025 __libc_enable_asynccancel 003c __libc_disable_asynccancel"
	strings:
		$1 = { 8B 05 ?? ?? ?? ?? 85 C0 75 05 E9 71 FF FF FF 48 89 5C 24 F0 48 89 6C 24 F8 48 83 EC 28 89 34 24 89 7C 24 08 E8 ?? ?? ?? ?? 8B 34 24 8B 7C 24 08 89 C3 E8 49 FF FF FF 89 DF 89 C5 E8 ?? ?? ?? ?? 89 E8 48 8B 5C 24 18 48 8B 6C 24 20 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_338_0_0 {
	meta:
		name = "_nl_explode_name"
		size = 651
		refs = "014e _nl_normalize_codeset 0171 strcmp 0223 __rawmemchr 025c free"
	strings:
		$1 = { 41 56 41 55 41 54 55 53 48 83 EC 20 48 C7 02 00 00 00 00 48 C7 01 00 00 00 00 49 C7 00 00 00 00 00 49 C7 01 00 00 00 00 48 89 3E 0F B6 07 3C 5F 0F 84 DA 01 00 00 84 C0 0F 84 D2 01 00 00 3C 40 0F 84 CA 01 00 00 3C 2E 0F 84 C2 01 00 00 48 89 FB EB 1A 0F 1F 44 00 00 40 84 F6 74 1D 40 80 FE 40 0F 84 39 01 00 00 40 80 FE 2E 74 7B 48 83 C3 01 0F B6 33 40 80 FE 5F 75 DE 48 39 DF 48 89 D8 0F 84 8A 01 00 00 31 ED 40 80 FE 40 0F 84 1E 01 00 00 40 80 FE 5F 0F 84 34 01 00 00 40 80 FE 2E 74 51 40 80 FE 40 0F 84 04 01 00 00 48 8B 01 48 85 C0 74 0B 89 EA 83 E2 FB 80 38 00 0F 44 EA 49 8B 00 48 85 C0 74 0B 89 EA 83 E2 FD 80 38 00 0F 44 EA 48 83 C4 20 89 E8 5B 5D 41 5C 41 5D 41 5E C3 0F 1F 80 00 00 00 00 31 ED 48 39 DF 0F 84 1D 01 00 00 48 8D 7B 01 C6 03 00 49 89 38 0F B6 73 01 40 F6 C6 BF 0F 84 3F 01 00 00 49 89 FC EB 03 49 89 DC 41 0F B6 74 24 01 49 8D 5C 24 01 40 F6 C6 BF 75 EC 41 89 ED 41 83 CD 02 48 39 DF 0F 84 45 01 00 00 48 89 DE 4C 89 04 24 4C 89 4C 24 18 48 29 FE 48 89 54 24 10 48 89 4C 24 08 E8 ?? ?? ?? ?? 4C 8B 4C 24 18 48 85 C0 49 89 C6 4C 8B 04 24 49 89 01 0F 84 17 01 00 00 49 8B 38 48 89 C6 E8 ?? ?? ?? ?? 85 C0 48 8B 54 24 10 48 8B 4C 24 08 4C 8B 04 24 0F 84 CA 00 00 00 83 CD 03 41 0F B6 74 24 01 E9 09 FF FF FF 0F 1F 80 00 00 00 00 48 39 DF 74 6B 31 ED 66 0F 1F 84 00 00 00 00 00 48 8D 43 01 C6 03 00 48 89 02 89 E8 83 C8 08 80 7B 01 00 0F 45 E8 E9 E1 FE FF FF 0F 1F 44 00 00 C6 03 00 48 83 C3 01 48 89 19 0F B6 70 01 40 84 F6 74 5D 40 80 FE 2E 75 19 EB 55 0F 1F 44 00 00 48 83 C3 01 0F B6 33 40 80 FE 2E 74 43 40 84 F6 74 3E 40 80 FE 40 75 E8 BD 04 00 00 00 EB A1 90 31 F6 48 89 54 24 10 48 89 4C 24 08 4C 89 04 24 31 ED E8 ?? ?? ?? ?? 48 8B 54 24 10 48 89 C3 0F B6 30 48 8B 4C 24 08 4C 8B 04 24 E9 62 FE FF FF BD 04 00 00 00 E9 52 FE FF FF 83 CD 02 48 89 FB E9 4D FE FF FF 4C 89 F7 44 89 ED E8 ?? ?? ?? ?? 41 0F B6 74 24 01 48 8B 54 24 10 48 8B 4C 24 08 4C 8B 04 24 E9 29 FE FF FF 44 89 ED E9 21 FE FF FF BD FF FF FF FF E9 47 FE FF FF }
	condition:
		$1
}

rule file_339_0_0 {
	meta:
		name = "_L_lock_42"
		size = 27
		refs = "000b __lll_lock_wait_private"
	strings:
		$1 = { 49 8D 38 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 43 FF FF FF }
	condition:
		$1
}

rule file_339_1_0 {
	meta:
		name = "_L_unlock_94"
		size = 24
		refs = "000b __lll_unlock_wake_private"
	strings:
		$1 = { 48 8D 3E 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 EB 88 }
	condition:
		$1
}

rule file_339_3_0 {
	meta:
		name = "fseeko"
		size = 242
		refs = "0032 __libc_multiple_threads 006c _IO_seekoff_unlocked 00ee _Unwind_Resume"
		altNames = "fseek"
	strings:
		$1 = { 55 49 89 F2 53 48 89 FB 48 83 EC 08 8B 07 25 00 80 00 00 75 4B 4C 8B 87 88 00 00 00 64 48 8B 2C 25 10 00 00 00 49 3B 68 08 74 30 BE 01 00 00 00 83 3D ?? ?? ?? ?? 00 74 0D F0 41 0F B1 30 0F 85 AE 00 00 00 EB 0A 41 0F B1 30 0F 85 A2 00 00 00 4C 8B 83 88 00 00 00 49 89 68 08 41 83 40 04 01 B9 03 00 00 00 4C 89 D6 48 89 DF E8 ?? ?? ?? ?? 31 D2 48 83 F8 FF 0F 95 C2 83 EA 01 F7 03 00 80 00 00 75 29 48 8B B3 88 00 00 00 83 6E 04 01 75 1C 48 C7 46 08 00 00 00 00 83 3D ?? ?? ?? ?? 00 74 07 F0 FF 0E 75 66 EB 04 FF 0E 75 60 48 83 C4 08 89 D0 5B 5D C3 F7 03 00 80 00 00 48 89 C6 75 29 48 8B 93 88 00 00 00 83 6A 04 01 75 1C 48 C7 42 08 00 00 00 00 83 3D ?? ?? ?? ?? 00 74 07 F0 FF 0A 75 41 EB 04 FF 0A 75 3B 48 89 F7 E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_340_0_0 {
	meta:
		name = "_dl_discover_osversion"
		size = 261
		refs = "000f __uname 00ba __open 00cf __read 00d9 __close"
	strings:
		$1 = { 55 53 48 81 EC D8 01 00 00 48 8D 7C 24 40 E8 ?? ?? ?? ?? 85 C0 48 8D BC 24 C2 00 00 00 0F 85 8D 00 00 00 45 31 C0 31 C0 0F BE 37 8D 56 D0 80 FA 09 77 5C 0F BE 57 01 48 8D 4F 01 83 EE 30 8D 7A D0 40 80 FF 09 77 20 66 0F 1F 84 00 00 00 00 00 8D 34 B6 48 83 C1 01 8D 74 72 D0 0F BE 11 8D 7A D0 40 80 FF 09 76 E9 C1 E0 08 41 83 C0 01 48 8D 79 01 09 F0 80 FA 2E 75 10 41 83 F8 03 75 A9 48 81 C4 D8 01 00 00 5B 5D C3 41 83 F8 03 74 F0 B9 03 00 00 00 48 81 C4 D8 01 00 00 44 29 C1 C1 E1 03 5B D3 E0 5D C3 66 2E 0F 1F 84 00 00 00 00 00 31 F6 31 C0 BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 89 C3 78 37 BA 40 00 00 00 48 89 E6 89 C7 E8 ?? ?? ?? ?? 89 DF 48 89 C5 E8 ?? ?? ?? ?? 48 85 ED 7E 19 B8 3F 00 00 00 48 83 FD 3F 48 89 E7 48 0F 4E C5 C6 04 04 00 E9 28 FF FF FF B8 FF FF FF FF E9 7A FF FF FF }
	condition:
		$1
}

rule file_341_0_0 {
	meta:
		name = "__gconv_open"
		size = 1908
		refs = "0025 strchr 00a0 _nl_current_LC_CTYPE 00b6 strlen 00d8 mempcpy 010e __gconv_find_transform 013b __gconv_translit_find 0170 malloc 019d memset 0213 _nl_C_locobj 0225 __strcasecmp_l 03b4 __libc_errno 03ca __gconv_close_transform 0460 free 04bb memcpy 055d __gconv_transliterate"
	strings:
		$1 = { 55 48 89 E5 41 57 41 56 49 89 F6 BE 2F 00 00 00 41 55 41 54 53 48 83 EC 68 48 89 7D A8 48 89 55 80 89 4D A0 E8 ?? ?? ?? ?? 48 85 C0 0F 84 CA 05 00 00 48 8D 78 01 BE 2F 00 00 00 45 31 ED E8 ?? ?? ?? ?? 48 85 C0 C7 45 98 00 00 00 00 74 0A 80 78 01 00 0F 85 3A 04 00 00 BE 2F 00 00 00 4C 89 F7 E8 ?? ?? ?? ?? 48 85 C0 74 1D 48 8D 78 01 BE 2F 00 00 00 E8 ?? ?? ?? ?? 48 85 C0 74 0A 80 78 01 00 0F 85 83 05 00 00 48 8B 45 A8 80 38 2F 75 58 80 78 01 2F 75 52 80 78 02 00 75 4C 48 8B 05 ?? ?? ?? ?? 64 48 8B 00 48 8B 00 48 8B 98 B0 00 00 00 48 89 DF E8 ?? ?? ?? ?? 48 8D 48 21 48 89 C2 48 89 DE 48 83 E1 F0 48 29 CC 4C 8D 64 24 0F 49 83 E4 F0 4C 89 E7 E8 ?? ?? ?? ?? 66 C7 00 2F 2F C6 40 02 00 4C 89 65 A8 41 80 3E 2F 75 0B 41 80 7E 01 2F 0F 84 5F 02 00 00 44 8B 45 A0 48 8B 7D A8 48 8D 4D C0 48 8D 55 B8 4C 89 F6 E8 ?? ?? ?? ?? 85 C0 89 45 94 48 C7 45 A0 00 00 00 00 0F 85 17 02 00 00 4D 85 ED 74 2A 4D 89 EC 31 DB 90 49 83 3C 24 00 74 10 4C 89 E7 E8 ?? ?? ?? ?? 85 C0 0F 85 08 06 00 00 4C 89 E3 4D 8B 64 24 08 4D 85 E4 75 DC 48 8B 5D C0 48 8D 04 DD 00 00 00 00 49 89 DC 49 C1 E4 06 49 29 C4 49 8D 7C 24 10 E8 ?? ?? ?? ?? 48 85 C0 48 89 45 A0 0F 84 30 02 00 00 48 8B 55 A0 48 8B 45 B8 31 F6 48 89 D7 48 89 42 08 48 89 1A 48 83 C7 10 4C 89 E2 E8 ?? ?? ?? ?? 48 83 7D C0 00 0F 84 90 01 00 00 4C 8B 65 A0 31 DB 48 C7 45 A8 00 00 00 00 48 8B 55 A8 48 8B 45 A8 4D 89 EF 48 8B 4D A0 48 C1 E2 03 48 C1 E0 06 48 29 D0 48 8D 54 01 38 48 83 C0 40 4D 85 ED 48 89 45 88 49 89 54 24 30 0F 84 D1 00 00 00 90 45 31 F6 49 83 7F 18 00 75 14 E9 B4 00 00 00 90 49 83 C6 01 4D 39 77 18 0F 86 A5 00 00 00 49 8B 47 10 BA ?? ?? ?? ?? 4A 8B 34 F0 48 8B 45 B8 48 8B 7C 18 18 E8 ?? ?? ?? ?? 85 C0 75 D3 49 8B 47 30 48 C7 45 C8 00 00 00 00 48 85 C0 74 13 48 8B 55 B8 48 8D 7D C8 48 8B 74 1A 20 FF D0 85 C0 75 62 BF 28 00 00 00 E8 ?? ?? ?? ?? 48 85 C0 0F 84 95 01 00 00 49 8B 57 20 49 8B 4C 24 40 48 89 10 49 8B 57 28 48 85 C9 48 89 50 08 49 8B 57 38 48 C7 40 20 00 00 00 00 48 89 50 10 48 8B 55 C8 48 89 50 18 75 0E E9 52 01 00 00 66 0F 1F 44 00 00 48 89 D1 48 8B 51 20 48 85 D2 75 F4 48 83 C1 20 48 89 01 4D 8B 7F 08 4D 85 FF 0F 85 30 FF FF FF 48 8B 55 C0 48 8D 42 FF 48 3B 45 A8 0F 86 56 04 00 00 8B 45 98 41 89 44 24 20 48 8B 45 B8 8B 4C 18 54 48 89 95 78 FF FF FF 69 C9 E0 1F 00 00 48 63 C9 48 89 CF 48 89 8D 70 FF FF FF E8 ?? ?? ?? ?? 48 85 C0 49 89 44 24 10 48 8B 95 78 FF FF FF 48 8B 8D 70 FF FF FF 0F 84 DC 00 00 00 48 01 C8 48 83 45 A8 01 49 83 C4 38 49 89 44 24 E0 48 83 C3 68 48 3B 55 A8 0F 87 7E FE FF FF 48 8B 45 A0 48 8B 55 80 48 89 02 8B 45 94 48 8D 65 D8 5B 41 5C 41 5D 41 5E 41 5F 5D C3 41 80 7E 02 00 0F 85 96 FD FF FF 48 8B 05 ?? ?? ?? ?? 64 48 8B 00 48 8B 00 48 8B 98 B0 00 00 00 48 89 DF E8 ?? ?? ?? ?? 48 8D 48 21 48 89 C2 48 89 DE 48 83 E1 F0 48 29 CC 4C 8D 74 24 0F 49 83 E6 F0 4C 89 F7 E8 ?? ?? ?? ?? 66 C7 00 2F 2F C6 40 02 00 E9 49 FD FF FF 48 8B 15 ?? ?? ?? ?? 64 8B 0A 48 89 55 98 89 4D 94 48 8B 7D B8 48 89 DE E8 ?? ?? ?? ?? 8B 55 94 48 8B 4D 98 C7 45 94 03 00 00 00 48 C7 45 A0 00 00 00 00 64 89 11 E9 50 FF FF FF 48 8B 4D A0 48 03 4D 88 E9 B7 FE FF FF 4C 8B 65 A8 48 8B 15 ?? ?? ?? ?? 49 83 EC 01 48 83 7D A8 00 64 8B 0A 48 89 55 98 89 4D 94 74 68 4A 8D 14 E5 00 00 00 00 4C 89 E0 48 C1 E0 06 48 29 D0 48 8B 55 A0 4C 8D 6C 02 40 0F 1F 40 00 4D 8B 75 00 4D 85 F6 74 28 0F 1F 80 00 00 00 00 49 8B 46 10 49 8B 5E 20 48 85 C0 0F 85 C4 02 00 00 4C 89 F7 49 89 DE E8 ?? ?? ?? ?? 48 85 DB 75 DF 49 8B 7D D0 49 83 ED 38 E8 ?? ?? ?? ?? 4D 85 E4 74 06 49 83 EC 01 EB B7 48 8B 7D A0 E8 ?? ?? ?? ?? 48 8B 5D C0 E9 2F FF FF FF 48 8D 58 01 48 8B 75 A8 48 89 DA 48 2B 55 A8 48 8D 42 1F 48 83 E0 F0 48 29 C4 48 8D 7C 24 0F 48 83 E7 F0 C6 04 17 00 E8 ?? ?? ?? ?? 48 89 DF 48 89 45 A8 E8 ?? ?? ?? ?? 48 8D 50 01 48 83 C0 1F 48 89 DE 48 83 E0 F0 48 29 C4 48 8D 7C 24 0F 48 83 E7 F0 E8 ?? ?? ?? ?? 49 89 C7 0F B6 00 3C 2C 75 0F 0F 1F 00 49 83 C7 01 41 0F B6 07 3C 2C 74 F4 84 C0 49 8D 5F 01 0F 84 EC 00 00 00 0F B6 03 84 C0 74 0C 48 83 C3 01 3C 2C 75 F1 C6 43 FF 00 45 31 ED C7 45 98 00 00 00 00 4D 85 FF 0F 84 23 FB FF FF BA ?? ?? ?? ?? BE ?? ?? ?? ?? 4C 89 FF E8 ?? ?? ?? ?? 85 C0 0F 85 EA 00 00 00 4D 85 ED 0F 84 63 01 00 00 49 81 7D 20 ?? ?? ?? ?? 74 57 4C 89 EA EB 15 0F 1F 84 00 00 00 00 00 48 81 78 20 ?? ?? ?? ?? 48 89 C2 74 3D 48 8B 42 08 48 85 C0 75 EA 48 83 EC 50 B9 08 00 00 00 48 8D 74 24 0F 48 83 E6 F0 48 89 F7 F3 48 AB 48 C7 46 10 ?? ?? ?? ?? 48 C7 46 18 01 00 00 00 48 C7 46 20 ?? ?? ?? ?? 48 89 72 08 0F B6 03 49 89 DF 3C 2C 75 10 0F 1F 40 00 49 83 C7 01 41 0F B6 07 3C 2C 74 F4 84 C0 0F 84 7D FA FF FF 49 8D 5F 01 0F B6 03 84 C0 0F 84 42 FF FF FF 48 83 C3 01 3C 2C 75 ED C6 43 FF 00 E9 31 FF FF FF 45 31 ED C7 45 98 00 00 00 00 E9 4E FA FF FF 48 8D 50 01 4C 89 F6 4C 29 F2 48 8D 42 1F 48 83 E0 F0 48 29 C4 48 8D 7C 24 0F 48 83 E7 F0 C6 04 17 00 E8 ?? ?? ?? ?? 49 89 C6 E9 4E FA FF FF BA ?? ?? ?? ?? BE ?? ?? ?? ?? 4C 89 FF E8 ?? ?? ?? ?? 85 C0 74 60 4D 85 ED 0F 84 9E 00 00 00 4D 89 EC EB 05 66 90 49 89 C4 49 8B 34 24 48 85 F6 74 15 BA ?? ?? ?? ?? 4C 89 FF E8 ?? ?? ?? ?? 85 C0 0F 84 39 FF FF FF 49 8B 44 24 08 48 85 C0 75 D5 48 83 EC 50 B9 08 00 00 00 48 8D 54 24 0F 48 83 E2 F0 48 89 D7 F3 48 AB 4C 89 3A 49 89 54 24 08 E9 0A FF FF FF C7 45 98 02 00 00 00 E9 FE FE FF FF 48 83 EC 50 4C 89 E8 B9 08 00 00 00 48 8D 54 24 0F 48 83 E2 F0 48 89 D7 49 89 D5 F3 48 AB 48 C7 42 10 ?? ?? ?? ?? 48 C7 42 18 01 00 00 00 48 C7 42 20 ?? ?? ?? ?? E9 C3 FE FF FF 48 83 EC 50 4C 89 E8 B9 08 00 00 00 48 8D 54 24 0F 48 83 E2 F0 48 89 D7 49 89 D5 F3 48 AB 4C 89 3A E9 9D FE FF FF 49 8B 7E 18 FF D0 E9 31 FD FF FF 48 8B 45 A8 4C 8B 75 A8 48 8B 55 A0 48 C1 E0 03 49 C1 E6 06 49 29 C6 8B 45 98 83 C8 01 42 89 44 32 20 E9 ED FB FF FF 48 85 DB 74 13 49 8B 44 24 08 48 89 43 08 4D 8B 64 24 08 E9 E8 F9 FF FF 4D 8B 64 24 08 4D 89 E5 E9 DB F9 FF FF }
	condition:
		$1
}

rule file_343_0_0 {
	meta:
		name = "__scalbnl"
		size = 17
	strings:
		$1 = { 89 7C 24 FC DB 44 24 FC DB 6C 24 08 D9 FD DD D9 C3 }
	condition:
		$1
}

rule file_345_0_0 {
	meta:
		name = "atexit"
		size = 31
		refs = "0001 __dso_handle 0014 __cxa_atexit"
	strings:
		$1 = { B8 ?? ?? ?? ?? 48 85 C0 74 0E 48 8B 15 ?? ?? ?? ?? 31 F6 E9 ?? ?? ?? ?? BA ?? ?? ?? ?? EB F2 }
	condition:
		$1
}

rule file_346_0_0 {
	meta:
		name = "utime"
		size = 20
		refs = "000f __syscall_error"
	strings:
		$1 = { B8 84 00 00 00 0F 05 48 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_347_0_0 {
	meta:
		name = "strchr"
		size = 124
	strings:
		$1 = { 66 0F 6E CE 48 89 F9 66 0F 60 C9 48 83 E7 F0 66 0F EF D2 66 0F 60 C9 83 CE FF 66 0F 6F 07 66 0F 70 C9 00 48 29 F9 66 0F 6F D8 48 8D 7F 10 66 0F 74 C1 66 0F 74 DA D3 E6 66 0F D7 D0 66 0F D7 CB 21 F2 21 F1 09 D1 75 20 66 0F 6F 07 48 8D 7F 10 66 0F 6F D8 66 0F 74 C1 66 0F 74 DA 66 0F D7 D0 66 0F D7 CB 09 D1 74 E0 0F BC D2 74 0C 0F BC C9 48 8D 44 17 F0 39 D1 74 02 31 C0 C3 }
	condition:
		$1
}

rule file_348_0_0 {
	meta:
		name = "_no_syscall"
		size = 22
		refs = "0003 __libc_errno"
		altNames = "sstk"
	strings:
		$1 = { 48 8B 05 ?? ?? ?? ?? 64 C7 00 26 00 00 00 48 C7 C0 FF FF FF FF C3 }
	condition:
		$1
}

rule file_349_0_0 {
	meta:
		name = "mbrtoc16"
		size = 685
		refs = "0089 _nl_current_LC_CTYPE 00d7 _dl_mcount_wrapper_check 01d1 __libc_errno 0251 __assert_fail 026a _nl_C_LC_CTYPE 0279 __wcsmbs_load_conv 02a4 __wcsmbs_gconv_fcts_c"
	strings:
		$1 = { 48 89 5C 24 D0 B8 ?? ?? ?? ?? 48 89 6C 24 D8 4C 89 64 24 E0 4C 89 6C 24 E8 48 89 CB 4C 89 74 24 F0 4C 89 7C 24 F8 48 81 EC B8 00 00 00 48 85 C9 48 0F 44 D8 8B 03 85 C0 0F 88 2A 01 00 00 48 85 F6 49 89 FE 48 89 F5 C7 44 24 54 00 00 00 00 C7 44 24 58 01 00 00 00 C7 44 24 50 01 00 00 00 48 89 5C 24 60 48 C7 44 24 70 00 00 00 00 0F 84 A5 01 00 00 4C 8D 7C 24 2C 49 8D 47 04 4C 89 7C 24 40 48 89 44 24 48 48 8B 05 ?? ?? ?? ?? 64 48 8B 00 4C 8B 20 4D 8B 6C 24 28 4D 85 ED 0F 84 C5 01 00 00 48 89 E9 48 89 6C 24 38 48 01 D1 0F 82 A2 01 00 00 49 8B 45 00 48 83 38 00 4C 8B 60 28 74 0D 49 C1 CC 11 64 4C 33 24 25 30 00 00 00 4C 89 E7 48 89 4C 24 18 E8 ?? ?? ?? ?? C7 44 24 08 01 00 00 00 C7 04 24 00 00 00 00 45 31 C0 4C 8D 4C 24 30 48 8B 4C 24 18 48 8D 54 24 38 48 8D 74 24 40 49 8B 7D 00 41 FF D4 A9 FB FF FF FF 74 15 8D 50 FA 83 FA 01 0F 86 A5 00 00 00 83 F8 05 0F 85 18 01 00 00 48 8B 44 24 38 8B 54 24 2C 48 29 E8 81 FA FF FF 00 00 0F 8F AC 00 00 00 4D 85 F6 74 04 66 41 89 16 4C 39 7C 24 40 74 37 85 D2 75 33 48 8B 44 24 60 8B 00 85 C0 0F 85 2D 01 00 00 31 C0 EB 20 0F 1F 44 00 00 25 FF FF FF 7F 89 03 8B 43 04 66 89 07 C7 43 04 00 00 00 00 48 C7 C0 FD FF FF FF 48 8B 9C 24 88 00 00 00 48 8B AC 24 90 00 00 00 4C 8B A4 24 98 00 00 00 4C 8B AC 24 A0 00 00 00 4C 8B B4 24 A8 00 00 00 4C 8B BC 24 B0 00 00 00 48 81 C4 B8 00 00 00 C3 0F 1F 44 00 00 83 F8 05 0F 84 5B FF FF FF 83 F8 07 74 62 48 8B 05 ?? ?? ?? ?? 64 C7 00 54 00 00 00 48 C7 C0 FF FF FF FF EB 9E 0F 1F 00 4D 85 F6 74 0E 89 D1 C1 F9 0A 66 81 E9 40 28 66 41 89 0E 81 E2 FF 03 00 00 81 0B 00 00 00 80 81 C2 00 DC 00 00 89 53 04 E9 6E FF FF FF 0F 1F 00 BA 01 00 00 00 BD ?? ?? ?? ?? 45 31 F6 E9 49 FE FF FF 66 0F 1F 44 00 00 48 C7 C0 FE FF FF FF E9 47 FF FF FF B9 ?? ?? ?? ?? BA 71 00 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C9 FF 48 39 CD 0F 85 51 FE FF FF E9 67 FF FF FF 49 81 FC ?? ?? ?? ?? 74 32 4C 89 E7 48 89 54 24 18 E8 ?? ?? ?? ?? 4D 8B 6C 24 28 48 8B 54 24 18 E9 16 FE FF FF B9 ?? ?? ?? ?? B2 80 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 41 BD ?? ?? ?? ?? E9 F5 FD FF FF }
	condition:
		$1
}

rule file_350_0_0 {
	meta:
		name = "__posix_openpt"
		size = 248
		refs = "001d __open 0059 __statfs 008e __close 0095 __libc_errno"
	strings:
		$1 = { 53 48 83 C4 80 8B 15 ?? ?? ?? ?? 85 D2 0F 85 CD 00 00 00 89 FE 31 C0 BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 F8 FF 89 C3 0F 84 84 00 00 00 8B 05 ?? ?? ?? ?? 85 C0 74 1A C7 05 ?? ?? ?? ?? 01 00 00 00 48 83 EC 80 89 D8 5B C3 0F 1F 84 00 00 00 00 00 48 89 E6 BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 75 0A 48 81 3C 24 D1 1C 00 00 74 CB 48 89 E6 BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 75 0A 48 81 3C 24 73 13 00 00 74 B0 89 DF BB FF FF FF FF E8 ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 01 00 00 00 64 C7 00 02 00 00 00 EB 94 0F 1F 40 00 48 8B 05 ?? ?? ?? ?? 64 8B 00 83 F8 13 74 09 83 F8 02 0F 85 78 FF FF FF C7 05 ?? ?? ?? ?? 01 00 00 00 48 83 EC 80 89 D8 5B C3 66 0F 1F 44 00 00 48 8B 05 ?? ?? ?? ?? BB FF FF FF FF 64 C7 00 02 00 00 00 E9 48 FF FF FF }
	condition:
		$1
}

rule file_350_1_0 {
	meta:
		name = "__bsd_getpt"
		size = 150
		refs = "0013 __libc_ptyname1 002e __libc_ptyname2 0043 __libc_errno 0066 __open"
	strings:
		$1 = { 41 54 48 B9 2F 64 65 76 2F 70 74 79 BA 70 00 00 00 41 BC ?? ?? ?? ?? 55 53 48 83 EC 10 48 8D 6C 24 08 48 89 0C 24 C6 45 02 00 88 55 00 BB ?? ?? ?? ?? BA 30 00 00 00 EB 1F 0F 1F 80 00 00 00 00 48 8B 0D ?? ?? ?? ?? 64 83 39 02 74 22 48 83 C3 01 0F B6 13 84 D2 74 28 31 C0 88 55 01 BE 02 00 00 00 48 89 E7 E8 ?? ?? ?? ?? 83 F8 FF 74 D1 48 83 C4 10 5B 5D 41 5C C3 0F 1F 84 00 00 00 00 00 49 83 C4 01 41 0F B6 14 24 84 D2 75 9D 64 C7 01 02 00 00 00 EB D9 }
	condition:
		$1
}

rule file_350_2_0 {
	meta:
		name = "__getpt"
		size = 41
		refs = "000a __posix_openpt 0025 __bsd_getpt"
	strings:
		$1 = { 48 83 EC 08 BF 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 FF 74 0D 48 83 C4 08 C3 0F 1F 84 00 00 00 00 00 48 83 C4 08 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_351_0_0 {
	meta:
		name = "__bb_exit_func"
		size = 535
		refs = "0019 _IO_new_fopen 0052 fwrite_unlocked 0059 __bb_head 00d1 __overflow 018b _IO_new_fclose 01ee perror"
	strings:
		$1 = { 41 57 BE ?? ?? ?? ?? BF ?? ?? ?? ?? 41 56 41 55 41 54 55 53 48 83 EC 38 E8 ?? ?? ?? ?? 48 85 C0 0F 84 C2 01 00 00 81 08 00 80 00 00 48 8D 7C 24 10 48 89 C1 BA 01 00 00 00 BE 14 00 00 00 48 89 C3 C7 44 24 10 67 6D 6F 6E C7 44 24 14 01 00 00 00 E8 ?? ?? ?? ?? 4C 8B 3D ?? ?? ?? ?? 4D 85 FF 0F 84 21 01 00 00 66 2E 0F 1F 84 00 00 00 00 00 49 8B 47 18 89 44 24 0C 48 8B 43 28 48 3B 43 30 0F 83 7B 01 00 00 C6 00 02 48 83 C0 01 48 89 43 28 48 39 43 30 41 BC 04 00 00 00 48 8D 6C 24 0C 76 23 0F B6 55 00 48 83 C0 01 48 83 C5 01 88 50 FF 48 89 43 28 49 83 EC 01 74 25 48 8B 43 28 48 39 43 30 77 DD 0F B6 75 00 48 89 DF 48 83 C5 01 E8 ?? ?? ?? ?? 83 F8 FF 75 DB 66 0F 1F 44 00 00 8B 44 24 0C 45 31 F6 85 C0 0F 84 8B 00 00 00 90 4D 8B 67 28 44 89 F5 48 8B 53 28 48 C1 E5 03 41 BD 08 00 00 00 49 01 EC 49 83 C4 01 0F 1F 40 00 48 39 53 30 0F 86 84 00 00 00 41 0F B6 44 24 FF 48 83 C2 01 88 42 FF 48 89 53 28 49 83 C4 01 49 83 ED 01 75 DB 49 03 6F 10 41 BC 08 00 00 00 48 83 C5 01 EB 07 0F 1F 00 48 8B 53 28 48 39 53 30 76 6E 0F B6 45 FF 48 83 C2 01 88 42 FF 48 89 53 28 48 83 C5 01 49 83 EC 01 75 DD 41 83 C6 01 44 39 74 24 0C 0F 87 76 FF FF FF 4D 8B 7F 20 4D 85 FF 0F 85 E9 FE FF FF 48 89 DF E8 ?? ?? ?? ?? 48 83 C4 38 5B 5D 41 5C 41 5D 41 5E 41 5F C3 41 0F B6 74 24 FF 48 89 DF E8 ?? ?? ?? ?? 83 F8 FF 48 8B 53 28 0F 84 7C FF FF FF E9 6D FF FF FF 66 90 0F B6 75 FF 48 89 DF E8 ?? ?? ?? ?? 83 F8 FF 75 90 41 83 C6 01 44 39 74 24 0C 0F 87 10 FF FF FF EB 98 66 0F 1F 44 00 00 BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 38 5B 5D 41 5C 41 5D 41 5E 41 5F C3 BE 02 00 00 00 48 89 DF E8 ?? ?? ?? ?? 48 8B 43 28 E9 7A FE FF FF }
	condition:
		$1
}

rule file_352_0_0 {
	meta:
		name = "accept4"
		size = 156
		refs = "0002 __libc_multiple_threads 0024 __libc_errno 0048 __libc_enable_asynccancel 007b __libc_disable_asynccancel"
	strings:
		$1 = { 8B 05 ?? ?? ?? ?? 85 C0 75 28 4C 63 D1 48 63 FF B8 20 01 00 00 0F 05 48 3D 00 F0 FF FF 77 02 F3 C3 48 8B 15 ?? ?? ?? ?? F7 D8 64 89 02 48 83 C8 FF C3 48 83 EC 28 48 89 54 24 08 89 0C 24 48 89 74 24 10 89 7C 24 18 E8 ?? ?? ?? ?? 8B 0C 24 41 89 C0 48 8B 54 24 08 48 8B 74 24 10 48 63 7C 24 18 B8 20 01 00 00 4C 63 D1 0F 05 48 3D 00 F0 FF FF 77 15 44 89 C7 89 44 24 18 E8 ?? ?? ?? ?? 8B 44 24 18 48 83 C4 28 C3 89 C2 48 8B 05 ?? ?? ?? ?? F7 DA 64 89 10 48 83 C8 FF EB D7 }
	condition:
		$1
}

rule file_353_0_0 {
	meta:
		name = "dysize"
		size = 72
	strings:
		$1 = { 40 F6 C7 03 B9 6D 01 00 00 75 32 89 F8 BA 1F 85 EB 51 89 FE F7 EA C1 FE 1F 41 B8 64 00 00 00 89 D0 C1 F8 05 29 F0 41 0F AF C0 39 C7 75 12 C1 FA 07 29 F2 69 D2 90 01 00 00 39 D7 74 03 89 C8 C3 B9 6E 01 00 00 89 C8 C3 }
	condition:
		$1
}

rule file_356_0_0 {
	meta:
		name = "__scalbn"
		size = 249
		refs = "0067 .LC2 006f .LC4 0077 .LC5 0088 .LC1 0090 .LC3 00ad .LC0 00f3 .LC6"
	strings:
		$1 = { 66 48 0F 7E C0 48 89 C2 48 C1 FA 34 81 E2 FF 07 00 00 0F 84 82 00 00 00 48 81 FA FF 07 00 00 74 74 81 FF B0 3C FF FF 7C 53 81 FF 50 C3 00 00 7F 32 48 63 FF 48 01 D7 48 81 FF FE 07 00 00 7F 23 48 85 FF 0F 8E 83 00 00 00 48 BA FF FF FF FF FF FF 0F 80 48 C1 E7 34 48 21 D0 48 09 C7 66 48 0F 6E C7 C3 66 0F 54 05 ?? ?? ?? ?? 66 0F 56 05 ?? ?? ?? ?? F2 0F 59 05 ?? ?? ?? ?? C3 66 0F 54 05 ?? ?? ?? ?? 66 0F 56 05 ?? ?? ?? ?? F2 0F 59 05 ?? ?? ?? ?? C3 F2 0F 58 C0 C3 48 BA FF FF FF FF FF FF 0F 00 48 85 D0 74 4E F2 0F 59 05 ?? ?? ?? ?? 66 48 0F 7E C0 48 89 C2 48 C1 FA 34 81 E2 FF 07 00 00 48 83 EA 36 E9 55 FF FF FF 48 83 FF CB 7C AA 48 83 C7 36 48 BA FF FF FF FF FF FF 0F 80 48 C1 E7 34 48 21 D0 48 09 C7 66 48 0F 6E C7 F2 0F 59 05 ?? ?? ?? ?? F3 C3 }
	condition:
		$1
}

rule file_358_0_0 {
	meta:
		name = "svc_find"
		size = 85
		refs = "000e __rpc_thread_variables"
	strings:
		$1 = { 41 54 49 89 D4 55 48 89 F5 53 48 89 FB E8 ?? ?? ?? ?? 48 8B 88 E8 00 00 00 48 85 C9 74 30 45 31 C0 EB 13 0F 1F 44 00 00 48 8B 01 49 89 C8 48 85 C0 74 12 48 89 C1 48 39 59 08 75 EC 48 39 69 10 75 E6 48 89 C8 5B 5D 4D 89 04 24 41 5C C3 31 C0 45 31 C0 EB F0 }
	condition:
		$1
}

rule file_358_1_0 {
	meta:
		name = "xprt_register"
		size = 334
		refs = "0011 __rpc_thread_variables 0027 _rpc_dtablesize 0050 __rpc_thread_svc_max_pollfd 005a __rpc_thread_svc_pollfd 0090 realloc 00dd __rpc_thread_svc_fdset 0135 malloc"
	strings:
		$1 = { 41 55 41 54 55 48 89 FD 53 48 83 EC 08 44 8B 27 E8 ?? ?? ?? ?? 48 83 B8 E0 00 00 00 00 48 89 C3 0F 84 02 01 00 00 E8 ?? ?? ?? ?? 41 39 C4 0F 8D 87 00 00 00 48 8B 83 E0 00 00 00 49 63 D4 41 81 FC FF 03 00 00 48 89 2C D0 0F 8E 81 00 00 00 E8 ?? ?? ?? ?? 49 89 C5 8B 18 E8 ?? ?? ?? ?? 31 D2 48 89 C5 EB 18 0F 1F 00 48 8B 4D 00 48 8D 0C D1 48 83 C2 01 83 39 FF 0F 84 93 00 00 00 39 D3 7F E7 8D 73 01 48 8B 7D 00 48 63 F6 48 C1 E6 03 E8 ?? ?? ?? ?? 48 85 C0 74 22 41 8B 55 00 48 89 45 00 83 C2 01 41 89 55 00 48 63 D2 44 89 64 D0 F8 49 63 55 00 66 C7 44 D0 FC C3 00 48 83 C4 08 5B 5D 41 5C 41 5D C3 66 2E 0F 1F 84 00 00 00 00 00 41 8D 5C 24 3F 45 85 E4 41 0F 49 DC E8 ?? ?? ?? ?? 44 89 E2 C1 FB 06 C1 FA 1F 48 63 DB C1 EA 1A 41 8D 0C 14 83 E1 3F 29 D1 BA 01 00 00 00 48 D3 E2 48 09 14 D8 E9 45 FF FF FF 66 0F 1F 44 00 00 44 89 21 66 C7 41 04 C3 00 48 83 C4 08 5B 5D 41 5C 41 5D C3 0F 1F 40 00 E8 ?? ?? ?? ?? 48 63 F8 48 C1 E7 03 E8 ?? ?? ?? ?? 48 85 C0 48 89 83 E0 00 00 00 0F 85 DD FE FF FF E9 6D FF FF FF }
	condition:
		$1
}

rule file_358_2_0 {
	meta:
		name = "xprt_unregister"
		size = 213
		refs = "001e _rpc_dtablesize 0027 __rpc_thread_variables 0078 __rpc_thread_svc_fdset 00a2 __rpc_thread_svc_max_pollfd 00ba __rpc_thread_svc_pollfd"
	strings:
		$1 = { 48 89 5C 24 E0 48 89 6C 24 E8 48 89 FB 4C 89 64 24 F0 4C 89 6C 24 F8 48 83 EC 28 8B 2F E8 ?? ?? ?? ?? 39 C5 7D 18 E8 ?? ?? ?? ?? 48 8B 80 E0 00 00 00 48 63 D5 48 8D 04 D0 48 39 18 74 22 48 8B 5C 24 08 48 8B 6C 24 10 4C 8B 64 24 18 4C 8B 6C 24 20 48 83 C4 28 C3 66 0F 1F 84 00 00 00 00 00 81 FD FF 03 00 00 48 C7 00 00 00 00 00 7F 32 8D 5D 3F 85 ED 0F 49 DD E8 ?? ?? ?? ?? 89 EA C1 FB 06 C1 FA 1F 48 63 DB C1 EA 1A 8D 4C 15 00 83 E1 3F 29 D1 48 C7 C2 FE FF FF FF 48 D3 C2 48 21 14 D8 E8 ?? ?? ?? ?? 31 DB 49 89 C5 44 8B 20 EB 04 48 83 C3 01 41 39 DC 7E 85 E8 ?? ?? ?? ?? 48 8B 10 48 8D 14 DA 39 2A 75 E7 C7 02 FF FF FF FF 45 8B 65 00 EB DB }
	condition:
		$1
}

rule file_358_3_0 {
	meta:
		name = "svc_register"
		size = 237
		refs = "0086 malloc 009f __rpc_thread_variables 00d5 pmap_set"
	strings:
		$1 = { 48 89 6C 24 D8 4C 89 64 24 E0 48 89 F5 4C 89 6C 24 E8 4C 89 74 24 F0 49 89 D4 4C 89 7C 24 F8 48 89 5C 24 D0 48 83 EC 48 48 8D 54 24 08 49 89 FE 4C 89 E6 48 89 EF 49 89 CD 4D 89 C7 E8 2F FD FF FF 48 85 C0 74 3A 4C 39 68 18 48 89 C3 74 6C 45 31 ED 44 89 E8 48 8B 5C 24 18 48 8B 6C 24 20 4C 8B 64 24 28 4C 8B 6C 24 30 4C 8B 74 24 38 4C 8B 7C 24 40 48 83 C4 48 C3 0F 1F 84 00 00 00 00 00 BF 28 00 00 00 E8 ?? ?? ?? ?? 48 85 C0 48 89 C3 74 BD 48 89 68 08 4C 89 60 10 4C 89 68 18 E8 ?? ?? ?? ?? 48 8B 90 E8 00 00 00 C7 43 20 00 00 00 00 48 89 13 48 89 98 E8 00 00 00 4D 85 FF 41 BD 01 00 00 00 74 8C 41 0F B7 4E 04 44 89 FA 4C 89 E6 48 89 EF E8 ?? ?? ?? ?? 85 C0 0F 84 6E FF FF FF C7 43 20 01 00 00 00 E9 65 FF FF FF }
	condition:
		$1
}

rule file_358_4_0 {
	meta:
		name = "svc_unregister"
		size = 139
		refs = "0037 free 005e pmap_unset 0076 __rpc_thread_variables"
	strings:
		$1 = { 41 54 49 89 F4 55 48 89 FD 48 83 EC 28 48 8D 54 24 10 E8 69 FC FF FF 48 85 C0 74 46 48 89 C7 48 8B 44 24 10 48 85 C0 74 47 48 8B 17 48 89 10 48 C7 07 00 00 00 00 E8 ?? ?? ?? ?? 48 8D 54 24 18 4C 89 E6 48 89 EF E8 35 FC FF FF 48 85 C0 74 07 8B 40 20 85 C0 75 0B 4C 89 E6 48 89 EF E8 ?? ?? ?? ?? 48 83 C4 28 5D 41 5C C3 66 0F 1F 44 00 00 48 89 7C 24 08 E8 ?? ?? ?? ?? 48 8B 7C 24 08 48 8B 17 48 89 90 E8 00 00 00 EB A4 }
	condition:
		$1
}

rule file_358_5_0 {
	meta:
		name = "svc_sendreply"
		size = 80
	strings:
		$1 = { 48 83 EC 68 48 8B 47 28 48 89 74 24 40 C7 44 24 08 01 00 00 00 48 89 E6 C7 44 24 10 00 00 00 00 C7 44 24 30 00 00 00 00 48 89 44 24 18 48 8B 47 30 48 89 54 24 38 48 89 44 24 20 48 8B 47 38 48 89 44 24 28 48 8B 47 08 FF 50 18 48 83 C4 68 C3 }
	condition:
		$1
}

rule file_358_6_0 {
	meta:
		name = "svcerr_noproc"
		size = 70
	strings:
		$1 = { 48 83 EC 68 48 8B 47 28 C7 44 24 08 01 00 00 00 C7 44 24 10 00 00 00 00 48 89 E6 C7 44 24 30 03 00 00 00 48 89 44 24 18 48 8B 47 30 48 89 44 24 20 48 8B 47 38 48 89 44 24 28 48 8B 47 08 FF 50 18 48 83 C4 68 C3 }
	condition:
		$1
}

rule file_358_7_0 {
	meta:
		name = "svcerr_decode"
		size = 70
	strings:
		$1 = { 48 83 EC 68 48 8B 47 28 C7 44 24 08 01 00 00 00 C7 44 24 10 00 00 00 00 48 89 E6 C7 44 24 30 04 00 00 00 48 89 44 24 18 48 8B 47 30 48 89 44 24 20 48 8B 47 38 48 89 44 24 28 48 8B 47 08 FF 50 18 48 83 C4 68 C3 }
	condition:
		$1
}

rule file_358_8_0 {
	meta:
		name = "svcerr_systemerr"
		size = 70
	strings:
		$1 = { 48 83 EC 68 48 8B 47 28 C7 44 24 08 01 00 00 00 C7 44 24 10 00 00 00 00 48 89 E6 C7 44 24 30 05 00 00 00 48 89 44 24 18 48 8B 47 30 48 89 44 24 20 48 8B 47 38 48 89 44 24 28 48 8B 47 08 FF 50 18 48 83 C4 68 C3 }
	condition:
		$1
}

rule file_358_9_0 {
	meta:
		name = "svcerr_auth"
		size = 47
	strings:
		$1 = { 48 83 EC 68 48 8B 47 08 89 74 24 20 C7 44 24 08 01 00 00 00 48 89 E6 C7 44 24 10 01 00 00 00 C7 44 24 18 01 00 00 00 FF 50 18 48 83 C4 68 C3 }
	condition:
		$1
}

rule file_358_10_0 {
	meta:
		name = "svcerr_weakauth"
		size = 51
	strings:
		$1 = { 48 83 EC 68 48 8B 47 08 C7 44 24 08 01 00 00 00 C7 44 24 10 01 00 00 00 48 89 E6 C7 44 24 18 01 00 00 00 C7 44 24 20 05 00 00 00 FF 50 18 48 83 C4 68 C3 }
	condition:
		$1
}

rule file_358_11_0 {
	meta:
		name = "svcerr_noprog"
		size = 70
	strings:
		$1 = { 48 83 EC 68 48 8B 47 28 C7 44 24 08 01 00 00 00 C7 44 24 10 00 00 00 00 48 89 E6 C7 44 24 30 01 00 00 00 48 89 44 24 18 48 8B 47 30 48 89 44 24 20 48 8B 47 38 48 89 44 24 28 48 8B 47 08 FF 50 18 48 83 C4 68 C3 }
	condition:
		$1
}

rule file_358_12_0 {
	meta:
		name = "svcerr_progvers"
		size = 80
	strings:
		$1 = { 48 83 EC 68 48 8B 47 28 48 89 74 24 38 C7 44 24 08 01 00 00 00 48 89 E6 C7 44 24 10 00 00 00 00 C7 44 24 30 02 00 00 00 48 89 44 24 18 48 8B 47 30 48 89 54 24 40 48 89 44 24 20 48 8B 47 38 48 89 44 24 28 48 8B 47 08 FF 50 18 48 83 C4 68 C3 }
	condition:
		$1
}

rule file_358_13_0 {
	meta:
		name = "svc_getreq_common"
		size = 502
		refs = "002c __rpc_thread_variables 00bd _null_auth 0137 svcerr_progvers 0164 svcerr_noprog 0199 _authenticate"
	strings:
		$1 = { 41 54 4C 63 E7 55 53 48 81 EC B0 05 00 00 48 8D 84 24 90 02 00 00 48 8D AC 24 00 01 00 00 48 89 84 24 90 00 00 00 48 89 6C 24 78 E8 ?? ?? ?? ?? 48 89 C3 48 8B 80 E0 00 00 00 4E 8B 24 E0 4D 85 E4 0F 84 0C 01 00 00 48 81 C5 20 03 00 00 66 90 49 8B 44 24 08 48 8D 74 24 40 4C 89 E7 FF 10 85 C0 0F 84 D4 00 00 00 48 8B 44 24 58 8B 54 24 70 48 89 6C 24 30 4C 89 64 24 38 48 89 04 24 48 8B 44 24 60 85 D2 48 89 44 24 08 48 8B 44 24 68 48 89 44 24 10 48 8B 44 24 70 48 89 44 24 18 48 8B 44 24 78 48 89 44 24 20 48 8B 84 24 80 00 00 00 48 89 44 24 28 0F 85 D5 00 00 00 8B 05 ?? ?? ?? ?? 41 C7 44 24 38 00 00 00 00 41 89 44 24 28 48 8B 8B E8 00 00 00 48 85 C9 0F 84 81 00 00 00 4C 8B 0C 24 48 8B 7C 24 08 31 C0 31 D2 48 C7 C6 FF FF FF FF EB 0B 0F 1F 00 48 8B 09 48 85 C9 74 2F 4C 39 49 08 75 F2 4C 8B 41 10 49 39 F8 0F 84 D5 00 00 00 4C 39 C6 49 0F 47 F0 49 39 D0 76 03 4C 89 C2 48 8B 09 B8 01 00 00 00 48 85 C9 75 D1 85 C0 74 2D 4C 89 E7 E8 ?? ?? ?? ?? 49 8B 44 24 08 4C 89 E7 FF 50 08 85 C0 74 2D 83 F8 01 0F 84 FD FE FF FF 48 81 C4 B0 05 00 00 5B 5D 41 5C C3 90 4C 89 E7 E8 ?? ?? ?? ?? 49 8B 44 24 08 4C 89 E7 FF 50 08 85 C0 75 D3 49 8B 44 24 08 4C 89 E7 FF 50 28 48 81 C4 B0 05 00 00 5B 5D 41 5C C3 66 90 48 8D 74 24 40 48 89 E7 E8 ?? ?? ?? ?? 85 C0 0F 84 2A FF FF FF C7 84 24 B0 00 00 00 01 00 00 00 C7 84 24 B8 00 00 00 01 00 00 00 48 8D B4 24 A0 00 00 00 89 84 24 C0 00 00 00 49 8B 44 24 08 4C 89 E7 C7 84 24 A8 00 00 00 01 00 00 00 FF 50 18 E9 56 FF FF FF 0F 1F 00 4C 89 E6 48 89 E7 FF 51 18 E9 45 FF FF FF }
	condition:
		$1
}

rule file_358_14_0 {
	meta:
		name = "svc_getreq_poll"
		size = 152
		refs = "0022 __rpc_thread_svc_max_pollfd 0031 __rpc_thread_variables 0045 xprt_unregister 007b svc_getreq_common"
	strings:
		$1 = { 85 F6 0F 84 8E 00 00 00 41 57 45 31 FF 41 56 41 55 41 89 F5 41 54 55 31 ED 53 48 89 FB 48 83 EC 08 E8 ?? ?? ?? ?? 49 89 C6 8B 00 EB 2B 0F 1F 00 E8 ?? ?? ?? ?? 48 8B 80 E0 00 00 00 41 83 C7 01 4A 8B 3C E0 E8 ?? ?? ?? ?? 45 39 FD 7E 3A 41 8B 06 83 C5 01 48 83 C3 08 39 C5 7D 2C 4C 63 23 41 83 FC FF 74 EC 0F B7 53 06 66 85 D2 74 E3 83 E2 20 75 BD 44 89 E7 41 83 C7 01 E8 ?? ?? ?? ?? 45 39 FD 7F CA 0F 1F 40 00 48 83 C4 08 5B 5D 41 5C 41 5D 41 5E 41 5F F3 C3 }
	condition:
		$1
}

rule file_358_15_0 {
	meta:
		name = "svc_getreqset"
		size = 137
		refs = "001f _rpc_dtablesize 004e svc_getreq_common"
	strings:
		$1 = { 41 57 41 56 41 BE 00 04 00 00 41 55 49 89 FD 41 54 49 C7 C4 FF FF FF FF 55 53 48 83 EC 08 E8 ?? ?? ?? ?? 3D 00 04 00 00 44 0F 4E F0 31 ED 45 85 F6 7E 47 0F 1F 44 00 00 49 8B 5D 00 49 83 C5 08 EB 1F 66 0F 1F 44 00 00 41 8D 7C 2F FF E8 ?? ?? ?? ?? 41 8D 4F FF B8 01 00 00 00 48 D3 E0 48 31 C3 48 0F BC CB 49 0F 44 CC 41 89 CF 41 83 C7 01 75 D6 83 C5 40 44 39 F5 7C BE 48 83 C4 08 5B 5D 41 5C 41 5D 41 5E 41 5F C3 }
	condition:
		$1
}

rule file_358_16_0 {
	meta:
		name = "svc_getreq"
		size = 44
		refs = "0020 svc_getreqset"
	strings:
		$1 = { 48 81 EC 88 00 00 00 48 63 F7 B9 10 00 00 00 31 C0 48 89 E7 FC F3 48 AB 48 89 E7 48 89 34 24 E8 ?? ?? ?? ?? 48 81 C4 88 00 00 00 C3 }
	condition:
		$1
}

rule file_358_17_0 {
	meta:
		name = "__rpc_thread_svc_cleanup"
		size = 43
		refs = "0002 __rpc_thread_variables 0019 svc_unregister"
	strings:
		$1 = { 53 E8 ?? ?? ?? ?? 48 89 C3 EB 12 0F 1F 44 00 00 48 8B 72 10 48 8B 7A 08 E8 ?? ?? ?? ?? 48 8B 93 E8 00 00 00 48 85 D2 75 E7 5B C3 }
	condition:
		$1
}

rule file_360_0_0 {
	meta:
		name = "setdomainname"
		size = 20
		refs = "000f __syscall_error"
	strings:
		$1 = { B8 AB 00 00 00 0F 05 48 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_361_0_0 {
	meta:
		name = "__posix_spawn"
		size = 21
		refs = "000c __spawni"
	strings:
		$1 = { 48 83 EC 18 C7 04 24 00 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_362_1_0 {
	meta:
		name = "svcudp_getargs"
		size = 18
	strings:
		$1 = { 48 8B 7F 48 48 89 F1 31 C0 48 89 D6 48 83 C7 10 FF E1 }
	condition:
		$1
}

rule file_362_2_0 {
	meta:
		name = "svcudp_freeargs"
		size = 25
	strings:
		$1 = { 48 8B 7F 48 48 89 F1 31 C0 48 89 D6 C7 47 10 02 00 00 00 48 83 C7 10 FF E1 }
	condition:
		$1
}

rule file_362_3_0 {
	meta:
		name = "svcudp_destroy"
		size = 91
		refs = "0016 xprt_unregister 001d __close 0039 free"
	strings:
		$1 = { 48 89 5C 24 F0 48 89 6C 24 F8 48 89 FB 48 83 EC 18 48 8B 6F 48 E8 ?? ?? ?? ?? 8B 3B E8 ?? ?? ?? ?? 48 8B 45 18 48 8B 40 38 48 85 C0 74 06 48 8D 7D 10 FF D0 48 8B 7B 40 E8 ?? ?? ?? ?? 48 89 EF E8 ?? ?? ?? ?? 48 89 DF 48 8B 6C 24 10 48 8B 5C 24 08 48 83 C4 18 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_362_4_0 {
	meta:
		name = "svcudp_recv"
		size = 784
		refs = "0084 __recvmsg 012c xdr_callmsg 01d1 memcmp 0201 __sendto 0225 __recvfrom 023d __libc_errno 0302 __sendmsg"
	strings:
		$1 = { 41 57 49 89 FF 41 56 4C 8D 77 50 41 55 4C 8D AF 98 00 00 00 41 54 4C 8D 67 60 55 48 8D 6F 14 53 48 83 EC 28 48 8B 5F 48 48 89 74 24 08 0F 1F 00 49 83 7F 78 00 C7 44 24 1C 10 00 00 00 0F 84 CD 01 00 00 49 8B 47 40 41 8B 3F 31 D2 4C 89 E6 49 89 47 50 8B 03 4D 89 77 70 49 C7 47 78 01 00 00 00 49 89 6F 60 41 C7 47 68 10 00 00 00 4D 89 AF 80 00 00 00 49 C7 87 88 00 00 00 B8 00 00 00 49 89 47 58 E8 ?? ?? ?? ?? 85 C0 0F 88 99 01 00 00 49 8B B7 88 00 00 00 41 8B 4F 68 48 83 FE 0F 89 4C 24 1C 76 44 49 8B 97 80 00 00 00 48 85 D2 74 38 48 8B 3A 48 83 FF 0F 76 1B 4C 8D 47 07 48 01 D6 49 83 E0 F8 49 01 D0 4D 8D 48 10 4C 39 CE 0F 83 8B 01 00 00 48 BE 00 00 00 00 08 00 00 00 48 39 72 08 0F 84 A7 01 00 00 49 C7 87 80 00 00 00 00 00 00 00 49 C7 87 88 00 00 00 00 00 00 00 41 89 4F 10 83 F8 0F 0F 8E 3F 01 00 00 48 8B 43 18 4C 8D 6B 10 31 F6 C7 43 10 01 00 00 00 4C 89 EF FF 50 28 48 8B 74 24 08 4C 89 EF E8 ?? ?? ?? ?? 85 C0 0F 84 13 01 00 00 48 8B 54 24 08 48 83 BB D0 01 00 00 00 48 8B 02 48 89 43 08 B8 01 00 00 00 0F 84 F6 00 00 00 49 8B 47 48 31 D2 4C 8B B0 D0 01 00 00 4C 8B 68 08 49 8B 0E 4C 89 E8 48 C1 E1 02 48 F7 F1 49 8B 46 08 49 8D 4E 38 89 D2 48 8B 1C D0 48 85 DB 75 15 E9 23 01 00 00 0F 1F 00 48 8B 5B 40 48 85 DB 0F 84 13 01 00 00 4C 3B 2B 75 EE 4D 8B 4E 30 4C 39 4B 08 75 E4 49 8B 46 28 48 39 43 10 75 DA 49 8B 56 20 48 39 53 18 75 D0 48 8D 7B 20 48 89 CE BA 10 00 00 00 48 89 0C 24 E8 ?? ?? ?? ?? 85 C0 48 8B 0C 24 75 B3 49 83 7F 78 00 48 8B 73 30 48 8B 53 38 0F 85 01 01 00 00 44 8B 4C 24 1C 41 8B 3F 48 63 D2 49 89 E8 31 C9 E8 ?? ?? ?? ?? B8 01 00 00 00 EB 41 0F 1F 40 00 48 63 13 49 8B 77 40 4C 8D 4C 24 1C 41 8B 3F 49 89 E8 31 C9 E8 ?? ?? ?? ?? 8B 54 24 1C 83 F8 FF 41 89 57 10 0F 85 C9 FE FF FF 48 8B 05 ?? ?? ?? ?? 64 83 38 04 0F 84 E5 FD FF FF 31 C0 48 83 C4 28 5B 5D 41 5C 41 5D 41 5E 41 5F C3 0F 1F 40 00 4D 8B 08 49 83 C1 07 49 83 E1 F8 4D 01 C8 4C 39 C6 0F 83 72 FE FF FF 48 BE 00 00 00 00 08 00 00 00 48 39 72 08 0F 85 5E FE FF FF 0F 1F 44 00 00 48 83 FF 1B 0F 86 4F FE FF FF C7 42 10 00 00 00 00 E9 59 FE FF FF 66 2E 0F 1F 84 00 00 00 00 00 4C 8B 4C 24 08 49 8B 41 28 49 89 46 30 49 8B 41 20 49 89 46 28 49 8B 41 18 49 89 46 20 49 8B 47 14 49 89 46 38 48 8B 45 08 48 89 41 08 48 83 C4 28 B8 01 00 00 00 5B 5D 41 5C 41 5D 41 5E 41 5F C3 41 8B 3F 49 89 77 50 4C 89 E6 49 89 57 58 31 D2 E8 ?? ?? ?? ?? B8 01 00 00 00 E9 3D FF FF FF }
	condition:
		$1
}

rule file_362_5_0 {
	meta:
		name = "svcudp_reply"
		size = 682
		refs = "0052 xdr_replymsg 00b5 __sendto 013c _libc_intl_domainname 0141 __dcgettext 0157 __fxprintf 0179 __sendmsg 01ba xdrmem_create 0244 malloc 027c free"
	strings:
		$1 = { 48 89 5C 24 D0 48 89 6C 24 D8 48 89 FD 4C 89 64 24 E0 4C 89 6C 24 E8 49 89 F5 4C 89 74 24 F0 4C 89 7C 24 F8 48 83 EC 48 48 8B 5F 48 31 F6 48 8B 43 18 4C 8D 63 10 C7 43 10 00 00 00 00 4C 89 E7 FF 50 28 48 8B 43 08 4C 89 EE 4C 89 E7 49 89 45 00 E8 ?? ?? ?? ?? 85 C0 75 2E 31 DB 89 D8 48 8B 6C 24 20 48 8B 5C 24 18 4C 8B 64 24 28 4C 8B 6C 24 30 4C 8B 74 24 38 4C 8B 7C 24 40 48 83 C4 48 C3 0F 1F 80 00 00 00 00 48 8B 43 18 4C 89 E7 FF 50 20 48 83 7D 78 00 41 89 C4 0F 85 C0 00 00 00 48 8B 75 40 44 8B 4D 10 4C 8D 45 14 8B 7D 00 48 63 D0 31 C9 E8 ?? ?? ?? ?? 44 39 E0 75 9C 48 83 BB D0 01 00 00 00 BB 01 00 00 00 74 8F 85 C0 78 8B 4C 8B 75 48 4C 63 F8 4D 8B AE D0 01 00 00 49 8B 45 18 49 8B 55 10 4C 8B 24 C2 4D 85 E4 0F 84 4A 01 00 00 49 8B 4D 00 49 8B 04 24 31 D2 48 C1 E1 02 48 F7 F1 49 8B 4D 08 89 D2 48 8D 14 D1 48 8B 0A 48 85 C9 74 1A 49 39 CC 75 0C EB 6E 66 90 49 39 D4 74 63 48 89 D1 48 8B 51 40 48 85 D2 75 EF BA 05 00 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? BE ?? ?? ?? ?? 48 89 C2 31 FF 31 C0 BB 01 00 00 00 E8 ?? ?? ?? ?? E9 FC FE FF FF 48 8B 45 40 8B 7D 00 48 8D 75 60 31 D2 48 89 45 50 49 63 C4 48 89 45 58 E8 ?? ?? ?? ?? E9 37 FF FF FF 66 0F 1F 44 00 00 48 8D 51 40 49 8B 44 24 40 48 89 02 49 8B 74 24 30 48 8B 45 40 41 8B 16 49 8D 7E 10 4D 89 7C 24 38 31 C9 BB 01 00 00 00 49 89 44 24 30 48 89 75 40 E8 ?? ?? ?? ?? 49 8B 55 30 49 8B 46 08 49 89 54 24 08 49 8B 55 28 49 89 04 24 49 89 54 24 10 49 8B 55 20 49 89 54 24 18 49 8B 55 38 49 89 54 24 20 49 8B 55 40 49 89 54 24 28 48 8B 55 48 48 8B 92 D0 01 00 00 48 8B 0A 31 D2 48 C1 E1 02 48 F7 F1 49 8B 4D 08 89 D2 48 8D 04 D1 48 8B 10 49 89 54 24 40 4C 89 20 49 8B 45 18 49 8B 55 10 4C 89 24 C2 48 83 C0 01 31 D2 49 F7 75 00 49 89 55 18 E9 1E FE FF FF BF 48 00 00 00 E8 ?? ?? ?? ?? 48 89 C2 48 85 C0 49 89 C4 B2 05 BE ?? ?? ?? ?? 74 30 41 8B 3E 48 89 44 24 08 E8 ?? ?? ?? ?? 48 85 C0 48 89 C6 48 8B 54 24 08 0F 85 21 FF FF FF 48 89 D7 E8 ?? ?? ?? ?? BA 05 00 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? BE ?? ?? ?? ?? 48 89 C2 31 FF 31 C0 E8 ?? ?? ?? ?? E9 B2 FD FF FF }
	condition:
		$1
}

rule file_362_6_0 {
	meta:
		name = "svcudp_bufcreate"
		size = 668
		refs = "005a bindresvport 0073 __getsockname 0085 malloc 00e7 xdrmem_create 0137 __setsockopt 0171 xprt_register 01ab _libc_intl_domainname 01b0 __dcgettext 01ba perror 01c6 __close 01e3 __bind 0200 __socket 0256 __fxprintf 0260 free"
	strings:
		$1 = { 48 89 6C 24 E0 4C 89 64 24 E8 45 31 E4 4C 89 6C 24 F0 4C 89 74 24 F8 89 FD 48 89 5C 24 D8 48 83 EC 48 83 FF FF 41 89 F5 41 89 D6 C7 44 24 08 10 00 00 00 0F 84 B7 01 00 00 48 8D 74 24 10 89 EF 48 C7 44 24 10 00 00 00 00 48 C7 44 24 18 00 00 00 00 66 C7 44 24 10 02 00 E8 ?? ?? ?? ?? 85 C0 0F 85 6A 01 00 00 48 8D 54 24 08 48 8D 74 24 10 89 EF E8 ?? ?? ?? ?? 85 C0 0F 85 21 01 00 00 BF 50 01 00 00 E8 ?? ?? ?? ?? BF D8 01 00 00 48 89 C3 E8 ?? ?? ?? ?? 45 39 EE 49 89 C4 45 0F 43 EE 41 83 C5 03 41 83 E5 FC 44 89 EF E8 ?? ?? ?? ?? 4D 85 E4 49 89 C6 0F 84 74 01 00 00 48 85 DB 0F 84 6B 01 00 00 48 85 C0 0F 84 62 01 00 00 49 8D 7C 24 10 45 89 2C 24 48 89 C6 48 89 43 40 B9 01 00 00 00 44 89 EA E8 ?? ?? ?? ?? 49 C7 84 24 D0 01 00 00 00 00 00 00 4C 89 63 48 48 8D 4C 24 0C 49 83 C4 40 0F B7 44 24 12 31 F6 66 C1 C8 08 4C 89 63 30 48 C7 43 08 ?? ?? ?? ?? 41 B8 04 00 00 00 66 89 43 04 89 2B BA 08 00 00 00 89 EF C7 44 24 0C 01 00 00 00 E8 ?? ?? ?? ?? 85 C0 0F 85 D5 00 00 00 C7 44 24 0C FF 00 00 00 B0 FF 48 B9 01 01 01 01 01 01 01 01 0F B6 C0 48 8D 53 50 48 0F AF C1 B9 20 00 00 00 48 89 D7 F3 48 AB 48 89 DF E8 ?? ?? ?? ?? 48 89 D8 48 8B 6C 24 28 48 8B 5C 24 20 4C 8B 64 24 30 4C 8B 6C 24 38 4C 8B 74 24 40 48 83 C4 48 C3 66 2E 0F 1F 84 00 00 00 00 00 BA 05 00 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 C7 31 DB E8 ?? ?? ?? ?? 45 85 E4 74 B2 89 EF E8 ?? ?? ?? ?? EB A9 0F 1F 40 00 8B 54 24 08 48 8D 74 24 10 89 EF 66 C7 44 24 12 00 00 E8 ?? ?? ?? ?? E9 7A FE FF FF 0F 1F 40 00 BA 11 00 00 00 BE 02 00 00 00 BF 02 00 00 00 E8 ?? ?? ?? ?? 85 C0 89 C5 78 6F 41 BC 01 00 00 00 E9 24 FE FF FF 0F 1F 00 C7 44 24 0C 00 00 00 00 31 C0 E9 26 FF FF FF 66 0F 1F 84 00 00 00 00 00 BA 05 00 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? BA ?? ?? ?? ?? 48 89 C1 BE ?? ?? ?? ?? 31 FF 31 C0 E8 ?? ?? ?? ?? 48 89 DF 31 DB E8 ?? ?? ?? ?? 4C 89 E7 E8 ?? ?? ?? ?? 4C 89 F7 E8 ?? ?? ?? ?? E9 FC FE FF FF BA 05 00 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 C7 31 DB E8 ?? ?? ?? ?? E9 D9 FE FF FF }
	condition:
		$1
}

rule file_362_8_0 {
	meta:
		name = "svcudp_enablecache"
		size = 294
		refs = "0031 _libc_intl_domainname 0036 __dcgettext 0047 __fxprintf 0079 malloc 009e calloc 00f4 free"
	strings:
		$1 = { 48 89 5C 24 E0 48 89 6C 24 E8 4C 89 64 24 F0 4C 89 6C 24 F8 48 83 EC 28 48 8B 5F 48 48 83 BB D0 01 00 00 00 74 4A BA 05 00 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? BE ?? ?? ?? ?? 48 89 C2 31 FF 31 C0 E8 ?? ?? ?? ?? 31 C0 48 8B 5C 24 08 48 8B 6C 24 10 4C 8B 64 24 18 4C 8B 6C 24 20 48 83 C4 28 C3 66 2E 0F 1F 84 00 00 00 00 00 BF 48 00 00 00 48 89 F5 E8 ?? ?? ?? ?? 48 85 C0 49 89 C4 74 5B 48 8D 34 AD 00 00 00 00 48 89 28 48 C7 40 18 00 00 00 00 BF 08 00 00 00 E8 ?? ?? ?? ?? 48 85 C0 49 89 C5 49 89 44 24 08 74 41 48 89 EE BF 08 00 00 00 E8 ?? ?? ?? ?? 48 85 C0 49 89 44 24 10 74 41 4C 89 A3 D0 01 00 00 B8 01 00 00 00 E9 76 FF FF FF 66 0F 1F 84 00 00 00 00 00 BA 05 00 00 00 BE ?? ?? ?? ?? E9 41 FF FF FF 90 4C 89 E7 E8 ?? ?? ?? ?? BA 05 00 00 00 BE ?? ?? ?? ?? E9 29 FF FF FF 4C 89 EF E8 ?? ?? ?? ?? 4C 89 E7 E8 ?? ?? ?? ?? BA 05 00 00 00 BE ?? ?? ?? ?? E9 0A FF FF FF }
	condition:
		$1
}

rule file_364_0_0 {
	meta:
		name = "isfdtype"
		size = 107
		refs = "0019 __libc_errno 002e __fxstat64"
	strings:
		$1 = { 48 89 5C 24 E8 48 89 6C 24 F0 4C 89 64 24 F8 48 81 EC A8 00 00 00 48 8B 1D ?? ?? ?? ?? 41 89 F4 48 89 E2 89 FE BF 01 00 00 00 64 8B 2B E8 ?? ?? ?? ?? 85 C0 64 89 2B 75 12 8B 44 24 18 25 00 F0 00 00 44 39 E0 0F 94 C0 0F B6 C0 48 8B 9C 24 90 00 00 00 48 8B AC 24 98 00 00 00 4C 8B A4 24 A0 00 00 00 48 81 C4 A8 00 00 00 C3 }
	condition:
		$1
}

rule file_365_0_0 {
	meta:
		name = "setpriority"
		size = 20
		refs = "000f __syscall_error"
	strings:
		$1 = { B8 8D 00 00 00 0F 05 48 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_366_0_0 {
	meta:
		name = "str_to_mpn"
		size = 489
		refs = "009e _tens_in_limb 00d9 __mpn_mul_1"
	strings:
		$1 = { 41 57 45 31 C9 4D 89 C7 41 56 49 89 CE 41 55 49 89 D5 31 D2 41 54 41 89 F4 55 31 ED 53 48 89 FB 48 83 EC 08 48 C7 01 00 00 00 00 0F 1F 44 00 00 48 63 03 8D 48 D0 83 F9 09 76 08 48 63 43 04 48 83 C3 04 4C 8D 54 AD 00 41 83 EC 01 48 83 C3 04 41 83 C1 01 45 85 E4 4A 8D 6C 50 D0 7E 22 41 83 F9 13 75 CC 48 85 D2 75 5F 49 89 6D 00 B2 01 49 C7 06 01 00 00 00 31 ED 45 30 C9 EB B3 0F 1F 00 49 63 07 85 C0 7E 0D 41 8D 0C 01 83 F9 13 0F 8E AC 00 00 00 4D 63 C9 48 85 D2 4A 8B 0C CD ?? ?? ?? ?? 0F 85 BC 00 00 00 49 89 6D 00 49 C7 06 01 00 00 00 48 83 C4 08 48 89 D8 5B 5D 41 5C 41 5D 41 5E 41 5F C3 0F 1F 00 48 B9 00 00 E8 89 04 23 C7 8A 4C 89 EE 4C 89 EF E8 ?? ?? ?? ?? 48 89 C1 49 8B 45 00 49 8B 16 48 01 C5 48 39 E8 49 89 6D 00 76 25 49 8D 7D 08 66 0F 1F 84 00 00 00 00 00 48 83 EA 01 0F 84 CE 00 00 00 48 8B 07 48 83 C0 01 48 85 C0 48 AB 74 E8 31 D2 48 01 CA 0F 84 A5 00 00 00 49 8B 06 31 ED 45 31 C9 49 89 54 C5 00 49 8B 16 48 83 C2 01 49 89 16 E9 F1 FE FF FF 90 48 0F AF 2C C5 ?? ?? ?? ?? 48 63 C9 48 85 D2 41 C7 07 00 00 00 00 48 8B 0C CD ?? ?? ?? ?? 0F 84 44 FF FF FF 4C 89 EE 4C 89 EF E8 ?? ?? ?? ?? 48 89 C1 49 8B 45 00 49 8B 16 48 01 C5 48 39 E8 49 89 6D 00 76 1F 49 8D 7D 08 0F 1F 80 00 00 00 00 48 83 EA 01 74 4C 48 8B 07 48 83 C0 01 48 85 C0 48 AB 74 EC 31 D2 48 01 CA 0F 84 04 FF FF FF 49 8B 06 49 89 54 C5 00 48 83 C0 01 49 89 06 E9 F0 FE FF FF 0F 1F 44 00 00 49 8B 16 31 ED 45 31 C9 E9 5B FE FF FF 0F 1F 00 BA 01 00 00 00 E9 38 FF FF FF BA 01 00 00 00 EB BD }
	condition:
		$1
}

rule file_366_1_0 {
	meta:
		name = "round_and_return"
		size = 468
		refs = "0071 .LC1 00e4 __mpn_rshift 00f3 __libc_errno 0114 .LC2 014e __mpn_construct_float"
	strings:
		$1 = { 48 89 6C 24 E8 4C 89 64 24 F0 48 89 FD 4C 89 6C 24 F8 48 89 5C 24 E0 48 83 EC 38 83 FE 82 41 89 D5 49 89 CC 7C 72 89 F3 44 89 C1 49 0F A3 CC 73 2D 45 85 C9 48 8B 45 00 75 08 A8 01 0F 84 2E 01 00 00 48 83 C0 01 A9 00 00 00 01 48 89 45 00 0F 85 3B 01 00 00 83 FB 81 0F 84 C2 00 00 00 81 FB 80 00 00 00 0F 8E C3 00 00 00 45 85 ED F3 0F 10 05 ?? ?? ?? ?? 0F 85 95 00 00 00 48 8B 5C 24 18 48 8B 6C 24 20 4C 8B 64 24 28 4C 8B 6C 24 30 48 83 C4 38 C3 0F 1F 40 00 B8 82 FF FF FF 29 F0 48 63 D8 48 83 FB 18 0F 8F AC 00 00 00 BA 01 00 00 00 44 89 C1 48 D3 E2 48 83 EA 01 4C 85 E2 4C 8B 27 0F 95 C2 0F B6 D2 41 09 D1 48 83 FB 18 0F 84 E4 00 00 00 89 C1 BA 01 00 00 00 48 89 FE 44 89 4C 24 08 E8 ?? ?? ?? ?? 44 8B 4C 24 08 8D 4B FF 48 8B 05 ?? ?? ?? ?? BB 81 FF FF FF 64 C7 00 22 00 00 00 E9 23 FF FF FF 0F 1F 84 00 00 00 00 00 F3 0F 10 05 ?? ?? ?? ?? E9 5E FF FF FF 0F 1F 00 A9 00 00 80 00 B8 82 FF FF FF 0F 45 D8 44 89 EA 89 DE 48 89 EF 48 8B 5C 24 18 48 8B 6C 24 20 4C 8B 64 24 28 4C 8B 6C 24 30 48 83 C4 38 E9 ?? ?? ?? ?? 66 0F 1F 44 00 00 48 8B 05 ?? ?? ?? ?? 0F 57 C0 64 C7 00 22 00 00 00 E9 0D FF FF FF 66 90 BA 01 00 00 00 48 D3 E2 48 83 EA 01 4C 85 E2 0F 84 D9 FE FF FF E9 B8 FE FF FF 66 0F 1F 44 00 00 B9 01 00 00 00 BA 01 00 00 00 48 89 EE 48 89 EF 83 C3 01 E8 ?? ?? ?? ?? 48 81 4D 00 00 00 80 00 E9 A9 FE FF FF 0F 1F 00 31 C0 4D 85 E4 48 C7 07 00 00 00 00 0F 95 C0 B9 17 00 00 00 41 09 C1 E9 1C FF FF FF }
	condition:
		$1
}

rule file_366_2_0 {
	meta:
		name = "____wcstof_l_internal"
		size = 6788
		refs = "005d __iswspace_l 00d4 __towlower_l 0291 __correctly_grouped_prefixwc 02d4 .LC4 04b4 _fpioconst_pow10 04d4 __tens 04e5 __mpn_mul 0593 __iswxdigit_l 0781 _nl_C_locobj 08c1 memcpy 0b3c __mpn_lshift 0bb2 __mpn_cmp 1064 __wcsncasecmp_l 107d .LC3 10f2 ____wcstoull_l_internal 12c1 __mpn_submul_1 12e9 __mpn_add_n 168a .LC1 169b .LC2 177b __mpn_rshift 18c1 __libc_errno"
	strings:
		$1 = { 41 57 41 56 49 89 FE 41 55 41 54 55 48 89 CD 53 48 81 EC 28 01 00 00 85 D2 48 8B 41 08 48 89 74 24 58 0F 85 E2 19 00 00 48 C7 44 24 40 00 00 00 00 45 31 E4 8B 40 58 4D 8D 7E FC C7 84 24 9C 00 00 00 00 00 00 00 89 44 24 50 66 0F 1F 44 00 00 49 83 C7 04 41 8B 1F 48 89 EE 89 DF E8 ?? ?? ?? ?? 85 C0 75 EB 83 FB 2D 4C 89 F8 0F 84 D7 06 00 00 83 FB 2B C7 44 24 6C 00 00 00 00 0F 84 3E 07 00 00 3B 5C 24 50 0F 84 D5 06 00 00 8D 43 D0 83 F8 09 0F 87 E8 06 00 00 83 FB 30 C7 44 24 48 0A 00 00 00 0F 84 22 0C 00 00 45 85 E4 4D 89 FD 0F 95 C0 EB 10 0F 1F 40 00 84 C0 74 12 49 83 C5 04 41 8B 5D 00 83 FB 30 74 F3 44 39 E3 74 EA 48 89 EE 89 DF E8 ?? ?? ?? ?? 8D 53 D0 89 C1 83 FA 09 0F 87 52 01 00 00 4D 89 EA 45 31 DB 83 FA 09 0F 86 2B 01 00 00 83 7C 24 48 10 0F 84 F4 00 00 00 45 85 E4 0F 85 55 18 00 00 48 83 7C 24 40 00 4D 89 D0 0F 85 54 18 00 00 41 83 FB 01 45 89 DC 45 19 F6 3B 5C 24 50 0F 84 B4 01 00 00 48 89 EE 89 DF 4C 89 54 24 10 44 89 5C 24 18 E8 ?? ?? ?? ?? 83 7C 24 48 10 4C 8B 54 24 10 44 8B 5C 24 18 0F 94 C2 83 F8 70 0F 85 1E 02 00 00 84 D2 0F 84 16 02 00 00 BA 01 00 00 00 41 8B 4A 04 83 F9 2D 0F 84 F3 06 00 00 45 31 C9 83 F9 2B 4D 8D 7A 04 0F 84 39 0B 00 00 8D 41 D0 83 F8 09 0F 87 F1 01 00 00 84 D2 0F 85 97 06 00 00 45 85 C9 41 8D 7B 3D 75 09 44 89 F7 44 29 DF 83 C7 27 8B 84 24 9C 00 00 00 66 0F 1F 44 00 00 8D 04 80 8D 44 41 D0 39 F8 89 84 24 9C 00 00 00 0F 8F EA 16 00 00 49 83 C7 04 41 8B 0F 8D 71 D0 83 FE 09 76 DB 45 85 C9 0F 84 9F 01 00 00 F7 D8 89 84 24 9C 00 00 00 E9 91 01 00 00 48 89 EE 89 DF 4C 89 54 24 10 44 89 5C 24 18 E8 ?? ?? ?? ?? 83 E8 61 4C 8B 54 24 10 44 8B 5C 24 18 83 F8 05 0F 87 E2 FE FF FF 66 90 41 83 C3 01 49 83 C2 04 41 8B 1A 8D 53 D0 E9 B9 FE FF FF 0F 1F 44 00 00 83 7C 24 48 10 0F 95 C0 83 F9 60 76 0D 84 C0 75 09 83 F9 66 0F 86 94 FE FF FF 3B 5C 24 50 0F 84 84 05 00 00 84 C0 66 90 0F 84 05 0B 00 00 83 7C 24 48 10 41 0F 94 C2 83 F9 65 75 09 45 84 D2 0F 84 69 FE FF FF 48 8B 4C 24 40 44 89 E2 4C 89 EE 4C 89 FF 44 88 54 24 10 E8 ?? ?? ?? ?? 48 83 7C 24 58 00 44 0F B6 54 24 10 74 14 49 39 C7 0F 84 83 15 00 00 49 89 C6 48 8B 74 24 58 4C 89 36 44 8B 54 24 6C 0F 57 C0 45 85 D2 0F 84 67 04 00 00 0F 1F 84 00 00 00 00 00 F3 0F 10 05 ?? ?? ?? ?? E9 52 04 00 00 0F 1F 00 49 83 C2 04 48 89 6C 24 40 41 8B 58 04 44 89 F5 45 31 FF 4C 89 6C 24 60 4D 89 D4 45 89 DE EB 30 48 8B 74 24 40 89 DF E8 ?? ?? ?? ?? 83 E8 61 83 F8 05 0F 87 E6 09 00 00 83 FD FF 75 07 83 FB 30 41 0F 45 EF 49 83 C4 04 41 8B 1C 24 49 83 C7 01 8D 43 D0 47 8D 2C 3E 83 F8 09 76 DC 83 7C 24 48 10 74 BD 45 89 F3 41 89 EE 48 8B 6C 24 40 4D 89 E2 89 DF 44 89 5C 24 18 4C 89 54 24 10 45 89 EC 4C 8B 6C 24 60 48 89 EE E8 ?? ?? ?? ?? 4C 8B 54 24 10 44 8B 5C 24 18 31 D2 83 F8 65 0F 84 4E 04 00 00 4D 89 D7 45 39 DC 0F 8F EA 01 00 00 45 85 E4 44 89 DB 7E 0A 45 39 E3 0F 84 D1 02 00 00 90 48 83 7C 24 58 00 74 08 48 8B 74 24 58 4C 89 3E 45 85 E4 0F 84 67 03 00 00 45 85 F6 4D 89 EF 74 3B 8B 44 24 50 41 39 45 00 4D 89 E8 74 0B 66 90 49 83 C0 04 41 39 00 75 F7 83 7C 24 48 10 49 63 C6 4D 8D 7C 80 04 42 8D 04 B5 00 00 00 00 41 0F 45 C6 29 84 24 9C 00 00 00 45 29 F4 83 7C 24 48 10 0F 84 85 01 00 00 8B 84 24 9C 00 00 00 85 C0 0F 88 3D 04 00 00 44 89 E2 29 DA 39 C2 0F 4F D0 29 D0 01 D3 8D 14 03 89 84 24 9C 00 00 00 83 FA 27 0F 8F 00 15 00 00 83 F8 D4 0F 8C B7 15 00 00 85 DB 0F 8E 58 05 00 00 48 8D 94 24 9C 00 00 00 48 8D B4 24 C0 00 00 00 48 8D 8C 24 B0 00 00 00 4C 89 FF 48 89 54 24 70 48 89 74 24 48 49 89 D0 48 89 F2 89 DE 48 89 4C 24 78 E8 B1 F7 FF FF 49 89 C7 8B 84 24 9C 00 00 00 48 8B AC 24 B0 00 00 00 85 C0 0F 8E 2F 04 00 00 4C 8B 54 24 48 48 8D 94 24 F0 00 00 00 44 89 64 24 60 89 9C 24 80 00 00 00 41 BE ?? ?? ?? ?? 41 BD 01 00 00 00 48 89 54 24 40 4C 89 7C 24 58 49 89 D4 4C 89 D3 EB 5C 48 8D 0C C5 ?? ?? ?? ?? 4D 89 F8 48 89 EA 48 89 DE 4C 89 E7 E8 ?? ?? ?? ?? 4C 89 FD 48 03 AC 24 B0 00 00 00 48 85 C0 48 89 AC 24 B0 00 00 00 75 0C 48 83 ED 01 48 89 AC 24 B0 00 00 00 8B 84 24 9C 00 00 00 48 89 DA 4C 89 E3 49 89 D4 45 01 ED 49 83 C6 18 85 C0 0F 84 69 03 00 00 44 85 E8 74 EC 4D 8B 7E 08 44 31 E8 89 84 24 9C 00 00 00 49 8B 06 49 83 EF 01 49 39 EF 7E 85 48 8D 34 C5 ?? ?? ?? ?? 49 89 E8 48 89 D9 4C 89 FA 4C 89 E7 E8 ?? ?? ?? ?? EB 83 66 2E 0F 1F 84 00 00 00 00 00 49 83 EA 04 41 83 EC 01 41 83 7A FC 30 74 F1 E9 0A FE FF FF 0F 1F 40 00 49 83 C7 04 41 8B 3F 48 89 EE E8 ?? ?? ?? ?? 85 C0 74 ED EB 07 0F 1F 00 49 83 C7 04 41 8B 3F 83 FF 30 74 F4 8D 57 D0 83 FA 09 0F 87 01 11 00 00 48 63 D2 49 83 C7 04 8B 04 95 ?? ?? ?? ?? B9 18 00 00 00 41 BD 17 00 00 00 41 83 EC 01 8D 74 98 FB 03 B4 24 9C 00 00 00 29 C1 48 D3 E2 41 29 C5 45 85 E4 48 89 94 24 A0 00 00 00 89 B4 24 9C 00 00 00 7F 39 E9 9C 0F 00 00 0F 1F 80 00 00 00 00 48 98 49 83 C7 04 41 83 FD 02 0F 8E A3 0F 00 00 41 8D 4D FD 41 83 ED 04 48 D3 E0 48 09 84 24 A0 00 00 00 41 83 EC 01 0F 84 61 0F 00 00 41 8B 3F 48 89 EE E8 ?? ?? ?? ?? 49 8D 57 04 85 C0 4C 0F 44 FA 41 8B 3F 8D 47 D0 83 F8 09 76 B3 48 89 EE 49 83 C7 04 E8 ?? ?? ?? ?? 83 E8 57 EB A8 66 2E 0F 1F 84 00 00 00 00 00 8B B4 24 9C 00 00 00 85 F6 0F 89 21 FD FF FF 49 83 EA 04 4C 89 6C 24 60 44 89 74 24 70 45 89 E5 45 89 DE 4C 89 D3 41 89 D4 EB 58 0F 1F 44 00 00 8B 03 83 E8 30 83 F8 09 0F 97 C0 84 C0 75 40 83 3B 30 0F 85 C8 01 00 00 8B B4 24 9C 00 00 00 41 83 ED 01 41 83 EE 01 41 80 FC 01 19 C0 83 E0 FD 8D 44 30 04 89 84 24 9C 00 00 00 C1 E8 1F 84 C0 0F 84 9A 01 00 00 45 85 ED 0F 8E 91 01 00 00 48 83 EB 04 45 84 E4 74 A8 8B 3B 48 89 EE E8 ?? ?? ?? ?? 85 C0 0F 94 C0 EB A2 48 83 7C 24 58 00 74 0F 48 8B 74 24 58 48 89 06 0F 1F 80 00 00 00 00 8B 4C 24 6C 85 C9 0F 85 A4 FB FF FF 0F 57 C0 48 81 C4 28 01 00 00 5B 5D 41 5C 41 5D 41 5E 41 5F C3 0F 1F 80 00 00 00 00 49 83 C7 04 8B 58 04 3B 5C 24 50 C7 44 24 6C 01 00 00 00 0F 85 2B F9 FF FF 41 8B 47 04 83 F8 2F 0F 86 1E F9 FF FF 83 F8 39 0F 86 21 F9 FF FF E9 10 F9 FF FF 0F 1F 40 00 BE ?? ?? ?? ?? 89 DF E8 ?? ?? ?? ?? 83 F8 69 0F 84 98 0E 00 00 83 F8 6E 0F 84 B3 08 00 00 48 83 7C 24 58 00 74 86 48 8B 74 24 58 0F 57 C0 4C 89 36 E9 79 FF FF FF 66 2E 0F 1F 84 00 00 00 00 00 49 83 C7 04 8B 58 04 E9 B6 F8 FF FF 0F 1F 40 00 83 7C 24 48 10 0F 84 A7 FB FF FF E9 88 F9 FF FF 4D 39 EF 0F 85 FD F8 FF FF 83 7C 24 48 10 66 90 0F 85 F0 F8 FF FF 41 8B 7D 04 8D 47 D0 83 F8 09 0F 86 E0 F8 FF FF 48 89 EE 89 54 24 18 89 4C 24 20 E8 ?? ?? ?? ?? 83 E8 61 8B 54 24 18 8B 4C 24 20 83 F8 05 0F 87 3C FA FF FF E9 B7 F8 FF FF 90 45 85 C9 42 8D 3C 9D 95 00 00 00 0F 85 6A F9 FF FF 44 89 F0 44 29 D8 8D 3C 85 83 00 00 00 E9 58 F9 FF FF 89 DA F7 DA 39 C2 0F 4C D0 E9 BF FB FF FF 0F 1F 80 00 00 00 00 4D 8D 7A 08 41 8B 4A 08 41 B9 01 00 00 00 E9 0A F9 FF FF 0F 1F 44 00 00 45 89 EC 44 89 F3 4C 8B 6C 24 60 44 8B 74 24 70 E9 0B FB FF FF 49 89 DA 4C 3B 54 24 40 4C 8B 7C 24 58 44 8B 64 24 60 8B 9C 24 80 00 00 00 75 18 48 8B 7C 24 48 48 8D 14 ED 00 00 00 00 4C 89 D6 E8 ?? ?? ?? ?? 0F 1F 00 48 8D 4D FF 89 E8 C1 E0 06 48 0F BD 94 CC C0 00 00 00 83 F2 3F 29 D0 3D 80 00 00 00 41 89 C5 0F 8F 4A 10 00 00 83 F8 18 0F 8E 23 04 00 00 8D 78 E8 89 FE 83 E7 3F 4C 63 C7 C1 FE 06 4D 85 C0 48 63 D6 0F 84 08 08 00 00 49 83 E8 01 48 39 D1 4C 8B 94 D4 C0 00 00 00 0F 8F BB 0D 00 00 89 F9 48 89 D6 49 D3 EA 4C 89 94 24 A0 00 00 00 48 83 BC 24 C0 00 00 00 00 0F 85 7C 0E 00 00 48 8B 54 24 48 31 C9 48 83 C2 08 48 83 C2 08 83 C1 01 48 83 7A F8 00 74 F2 41 39 DC 41 B9 01 00 00 00 7F 0D 48 63 C9 45 31 C9 48 39 F1 41 0F 9C C1 48 8B 8C F4 C0 00 00 00 8B 54 24 6C 8D 70 FF 48 8D BC 24 A0 00 00 00 E8 8F F4 FF FF E9 99 FD FF FF 66 2E 0F 1F 84 00 00 00 00 00 48 8D B4 24 A0 00 00 00 B9 0A 00 00 00 BA 08 00 00 00 45 31 ED 48 89 74 24 58 48 8D B4 24 9C 00 00 00 48 89 74 24 70 48 8D B4 24 B0 00 00 00 48 89 74 24 78 48 8D B4 24 C0 00 00 00 48 89 74 24 48 41 29 DC C6 84 24 87 00 00 00 00 41 39 CC 44 89 64 24 50 7E 0F 83 C2 02 C6 84 24 87 00 00 00 01 89 54 24 50 44 8B 4C 24 50 4C 8B 54 24 48 31 DB 44 89 AC 24 80 00 00 00 4C 89 BC 24 88 00 00 00 49 89 DD 41 BE ?? ?? ?? ?? BD 01 00 00 00 41 29 C1 48 8D 84 24 F0 00 00 00 4D 89 D4 44 89 CB 48 89 44 24 40 49 89 C7 EB 33 66 0F 1F 44 00 00 4D 8B 6E 08 49 8B 06 4C 89 FF 49 83 ED 01 48 8D 34 C5 ?? ?? ?? ?? 4A 8D 14 ED 00 00 00 00 E8 ?? ?? ?? ?? 01 ED 49 83 C6 18 85 DB 74 5B 85 EB 74 F2 31 EB 4D 85 ED 74 C8 49 8B 06 49 8B 56 08 4D 89 E8 4C 89 F9 4C 89 E7 48 8D 34 C5 ?? ?? ?? ?? 48 83 EA 01 E8 ?? ?? ?? ?? 49 8B 56 08 48 85 C0 4D 8D 6C 15 FF 0F 85 F5 01 00 00 4C 89 F8 49 83 ED 01 01 ED 49 83 C6 18 85 DB 4D 89 E7 49 89 C4 75 AB 66 0F 1F 44 00 00 4D 89 FC 4C 3B 64 24 48 4C 89 EB 4C 8B BC 24 88 00 00 00 44 8B AC 24 80 00 00 00 0F 84 CE 0C 00 00 48 8B 54 24 48 4C 8B 44 24 70 4C 89 FF 48 8B 4C 24 78 8B 74 24 50 E8 1C F1 FF FF 48 8D 53 FF 48 0F BD AC D4 F0 00 00 00 48 89 54 24 50 48 83 F5 3F 85 ED 7E 32 48 8B 74 24 40 89 E9 48 89 DA 48 89 F7 E8 ?? ?? ?? ?? 48 8B 74 24 48 48 8B 94 24 B0 00 00 00 89 E9 48 89 F7 E8 ?? ?? ?? ?? 48 85 C0 0F 85 D0 04 00 00 48 83 FB 01 44 89 AC 24 9C 00 00 00 0F 84 7A 03 00 00 48 83 FB 02 0F 84 09 02 00 00 48 8B 4C 24 50 48 8B 94 24 B0 00 00 00 48 89 D8 48 8B 7C 24 48 4C 8D 63 FE 4C 8B B4 CC F0 00 00 00 48 8B 4C 24 40 48 29 D0 4E 8B BC E4 F0 00 00 00 48 8D 34 C1 E8 ?? ?? ?? ?? 85 C0 48 8B 84 24 B0 00 00 00 7E 18 48 C7 84 C4 C0 00 00 00 00 00 00 00 48 83 C0 01 48 89 84 24 B0 00 00 00 48 39 D8 0F 8D EE 05 00 00 48 89 DD 48 29 C5 45 85 ED 0F 8E 24 0C 00 00 48 89 EA 49 63 CD 48 C1 E2 06 48 01 CA 48 83 FA 18 0F 8F DA 0B 00 00 48 C7 84 24 A0 00 00 00 00 00 00 00 C7 44 24 70 00 00 00 00 89 EA C1 E2 06 41 01 D5 85 C0 7E 32 48 8B 74 24 48 8D 50 FF 48 98 48 01 E8 48 8D 04 C6 66 0F 1F 44 00 00 48 63 CA 83 EA 01 48 83 E8 08 48 8B 8C CC C0 00 00 00 48 89 48 08 83 FA FF 75 E5 48 85 ED 78 21 48 8B 54 24 48 48 83 C5 01 31 C0 0F 1F 44 00 00 48 C7 04 C2 00 00 00 00 48 83 C0 01 48 39 E8 75 EF 41 83 FD 18 48 C7 84 DC F0 00 00 00 00 00 00 00 48 8B 8C DC C0 00 00 00 0F 8E 7F 05 00 00 8B 94 24 9C 00 00 00 31 ED E9 F8 06 00 00 0F 1F 00 4C 89 F8 4D 89 E7 49 89 C4 E9 B5 FD FF FF 4D 8D 7A 08 41 8B 4A 08 E9 BA F4 FF FF 41 8B 7F 04 48 89 EE E8 ?? ?? ?? ?? 83 F8 78 0F 85 C9 F3 FF FF 41 8B 5F 08 48 C7 44 24 40 00 00 00 00 49 83 C7 08 C7 44 24 48 10 00 00 00 E9 AB F3 FF FF 4D 89 E2 45 89 F3 45 89 EC 41 89 EE 4C 8B 6C 24 60 48 8B 6C 24 40 E9 13 F4 FF FF 41 39 DC 0F 84 12 04 00 00 48 8D B4 24 A0 00 00 00 48 8D 14 ED 00 00 00 00 48 89 74 24 58 48 8B 74 24 48 48 8B 7C 24 58 E8 ?? ?? ?? ?? B9 1A 00 00 00 BA 56 55 55 55 44 29 E9 89 C8 C1 F9 1F F7 EA 8B 84 24 9C 00 00 00 29 CA 8D 4A 02 E9 76 FC FF FF 83 F9 70 0F 85 F2 F4 FF FF 4D 39 EF 0F 85 69 F3 FF FF 0F 1F 00 E9 E1 F4 FF FF 48 83 BC 24 B0 00 00 00 01 4C 8B A4 24 F0 00 00 00 48 8B AC 24 F8 00 00 00 0F 8F 63 06 00 00 4C 8B BC 24 C0 00 00 00 4C 39 FD 0F 86 03 0A 00 00 45 85 ED 0F 8E E7 0A 00 00 41 BA 18 00 00 00 45 29 EA 74 27 48 8B 74 24 58 44 89 D1 BA 01 00 00 00 44 89 54 24 10 48 89 F7 E8 ?? ?? ?? ?? 4C 8B BC 24 C0 00 00 00 44 8B 54 24 10 41 83 C5 40 41 83 FD 18 0F 8F 41 0A 00 00 4D 89 FE 45 31 FF 4D 89 E0 31 C9 BF 40 00 00 00 49 F7 D8 0F 1F 80 00 00 00 00 49 39 EE 0F 84 FF 05 00 00 4C 89 F2 4C 89 F8 48 F7 F5 48 89 C3 49 89 D6 4C 89 E0 48 F7 E3 66 2E 0F 1F 84 00 00 00 00 00 4C 39 F2 77 0A 48 85 C0 74 15 4C 39 F2 75 10 48 83 EB 01 4C 29 E0 48 83 DA 00 49 01 EE 73 E1 49 89 CF 49 29 C7 49 19 D6 45 85 ED 0F 85 DF 05 00 00 48 85 DB 0F 84 16 06 00 00 48 0F BD C3 8B 94 24 9C 00 00 00 41 89 FD 83 F0 3F 41 29 C5 29 C2 41 83 FD 18 89 94 24 9C 00 00 00 0F 8E F7 05 00 00 B9 28 00 00 00 44 8D 50 18 29 C1 48 89 D8 48 D3 E8 48 89 84 24 A0 00 00 00 4D 85 F6 0F 85 12 08 00 00 80 BC 24 87 00 00 00 00 0F 85 04 08 00 00 45 31 C9 4D 85 FF 41 0F 95 C1 41 B8 3F 00 00 00 8D 72 FF 45 29 D0 E9 9A 00 00 00 48 8B 84 24 C0 00 00 00 48 8B 8C 24 F0 00 00 00 31 F6 41 B8 40 00 00 00 49 89 C1 4C 89 CA 48 89 F0 48 F7 F1 45 85 ED 49 89 D1 0F 85 84 00 00 00 48 85 C0 0F 84 92 00 00 00 4C 0F BD D0 8B BC 24 9C 00 00 00 45 89 C5 41 83 F2 3F 45 29 D5 44 29 D7 41 83 FD 18 89 BC 24 9C 00 00 00 7E 75 B9 28 00 00 00 48 89 C3 45 8D 62 18 44 29 D1 48 89 D5 48 D3 E8 48 89 84 24 A0 00 00 00 48 85 ED 41 B8 3F 00 00 00 8D 77 FF 41 0F 95 C1 44 0A 8C 24 87 00 00 00 45 29 E0 41 83 E1 01 8B 54 24 6C 48 8B 7C 24 58 4D 63 C0 48 89 D9 E8 86 EE FF FF E9 90 F7 FF FF 90 41 83 FD D9 7D 3A 48 89 84 24 A0 00 00 00 41 83 C5 40 E9 50 FF FF FF 83 AC 24 9C 00 00 00 40 41 83 FD 18 48 89 84 24 A0 00 00 00 0F 8E 36 FF FF FF 48 89 C3 48 89 D5 45 31 E4 EB 43 0F 1F 40 00 41 BC 18 00 00 00 48 89 C3 48 89 D5 45 29 EC 45 85 E4 7E 2B 48 8B 74 24 58 44 89 E1 BA 01 00 00 }
	condition:
		$1
}

rule file_367_0_0 {
	meta:
		name = "mkstemps"
		size = 36
		refs = "0013 __libc_errno 0009 __gen_tempname"
		altNames = "mkstemps64"
	strings:
		$1 = { 85 F6 78 0C 31 C9 31 D2 E9 ?? ?? ?? ?? 0F 1F 00 48 8B 05 ?? ?? ?? ?? 64 C7 00 16 00 00 00 B8 FF FF FF FF C3 }
	condition:
		$1
}

rule file_368_0_0 {
	meta:
		name = "scandir"
		size = 22
		refs = "0012 scandirat"
	strings:
		$1 = { 49 89 C8 48 89 D1 48 89 F2 48 89 FE BF 9C FF FF FF E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_369_0_0 {
	meta:
		name = "sendfile"
		size = 23
		refs = "0012 __syscall_error"
	strings:
		$1 = { 49 89 CA B8 28 00 00 00 0F 05 48 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_370_0_0 {
	meta:
		name = "_L_lock_13"
		size = 31
		refs = "000f __lll_lock_wait_private"
	strings:
		$1 = { 48 8D 3D ?? ?? ?? ?? 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 0B FE FF FF }
	condition:
		$1
}

rule file_370_6_0 {
	meta:
		name = "setrpcent"
		size = 153
		refs = "0010 __libc_multiple_threads 0055 __nss_rpc_lookup2 005f __nss_setent 0066 __libc_errno"
	strings:
		$1 = { 48 83 EC 18 41 89 F9 BE 01 00 00 00 31 C0 83 3D ?? ?? ?? ?? 00 74 10 F0 0F B1 35 ?? ?? ?? ?? 0F 85 E5 01 00 00 EB 0D 0F B1 35 ?? ?? ?? ?? 0F 85 D6 01 00 00 41 B8 ?? ?? ?? ?? C7 44 24 08 00 00 00 00 48 C7 04 24 ?? ?? ?? ?? B9 ?? ?? ?? ?? BA ?? ?? ?? ?? BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 15 ?? ?? ?? ?? 64 8B 32 83 3D ?? ?? ?? ?? 00 74 0F F0 FF 0D ?? ?? ?? ?? 0F 85 A6 01 00 00 EB 0C FF 0D ?? ?? ?? ?? 0F 85 98 01 00 00 64 89 32 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_1022_6_0 {
	meta:
		name = "setprotoent"
		size = 153
		refs = "0010 __libc_multiple_threads 0055 __nss_protocols_lookup2 005f __nss_setent 0066 __libc_errno"
	strings:
		$1 = { 48 83 EC 18 41 89 F9 BE 01 00 00 00 31 C0 83 3D ?? ?? ?? ?? 00 74 10 F0 0F B1 35 ?? ?? ?? ?? 0F 85 E5 01 00 00 EB 0D 0F B1 35 ?? ?? ?? ?? 0F 85 D6 01 00 00 41 B8 ?? ?? ?? ?? C7 44 24 08 00 00 00 00 48 C7 04 24 ?? ?? ?? ?? B9 ?? ?? ?? ?? BA ?? ?? ?? ?? BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 15 ?? ?? ?? ?? 64 8B 32 83 3D ?? ?? ?? ?? 00 74 0F F0 FF 0D ?? ?? ?? ?? 0F 85 A6 01 00 00 EB 0C FF 0D ?? ?? ?? ?? 0F 85 98 01 00 00 64 89 32 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_1390_6_0 {
	meta:
		name = "setservent"
		size = 153
		refs = "0010 __libc_multiple_threads 0055 __nss_services_lookup2 005f __nss_setent 0066 __libc_errno"
	strings:
		$1 = { 48 83 EC 18 41 89 F9 BE 01 00 00 00 31 C0 83 3D ?? ?? ?? ?? 00 74 10 F0 0F B1 35 ?? ?? ?? ?? 0F 85 E5 01 00 00 EB 0D 0F B1 35 ?? ?? ?? ?? 0F 85 D6 01 00 00 41 B8 ?? ?? ?? ?? C7 44 24 08 00 00 00 00 48 C7 04 24 ?? ?? ?? ?? B9 ?? ?? ?? ?? BA ?? ?? ?? ?? BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 15 ?? ?? ?? ?? 64 8B 32 83 3D ?? ?? ?? ?? 00 74 0F F0 FF 0D ?? ?? ?? ?? 0F 85 A6 01 00 00 EB 0C FF 0D ?? ?? ?? ?? 0F 85 98 01 00 00 64 89 32 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_372_0_0 {
	meta:
		name = "do_fcntl"
		size = 204
		refs = "0095 __libc_errno"
	strings:
		$1 = { 83 FE 09 49 89 D0 74 20 4C 89 C2 48 63 F6 48 63 FF B8 48 00 00 00 0F 05 48 3D 00 F0 FF FF 77 72 F3 C3 66 0F 1F 44 00 00 8B 05 ?? ?? ?? ?? 85 C0 75 D6 4C 63 D7 41 B9 48 00 00 00 48 8D 54 24 E8 BE 10 00 00 00 4C 89 D7 44 89 C8 0F 05 3D 00 F0 FF FF 77 14 8B 44 24 EC 89 C2 F7 DA 83 7C 24 E8 02 0F 44 C2 C3 0F 1F 00 83 F8 EA 89 C2 75 39 4C 89 C2 BE 09 00 00 00 4C 89 D7 44 89 C8 0F 05 48 3D 00 F0 FF FF 77 33 C7 05 ?? ?? ?? ?? 01 00 00 00 C3 48 8B 15 ?? ?? ?? ?? F7 D8 64 89 02 48 83 C8 FF C3 0F 1F 44 00 00 48 8B 05 ?? ?? ?? ?? F7 DA 64 89 10 B8 FF FF FF FF C3 48 8B 15 ?? ?? ?? ?? F7 D8 64 89 02 48 83 C8 FF EB BB }
	condition:
		$1
}

rule file_16_0_3 {
	meta:
		name = "do_fcntl"
		size = 204
		refs = "0095 errno"
	strings:
		$1 = { 83 FE 09 49 89 D0 74 20 4C 89 C2 48 63 F6 48 63 FF B8 48 00 00 00 0F 05 48 3D 00 F0 FF FF 77 72 F3 C3 66 0F 1F 44 00 00 8B 05 ?? ?? ?? ?? 85 C0 75 D6 4C 63 D7 41 B9 48 00 00 00 48 8D 54 24 E8 BE 10 00 00 00 4C 89 D7 44 89 C8 0F 05 3D 00 F0 FF FF 77 14 8B 44 24 EC 89 C2 F7 DA 83 7C 24 E8 02 0F 44 C2 C3 0F 1F 00 83 F8 EA 89 C2 75 39 4C 89 C2 BE 09 00 00 00 4C 89 D7 44 89 C8 0F 05 48 3D 00 F0 FF FF 77 33 C7 05 ?? ?? ?? ?? 01 00 00 00 C3 48 8B 15 ?? ?? ?? ?? F7 D8 64 89 02 48 83 C8 FF C3 0F 1F 44 00 00 48 8B 05 ?? ?? ?? ?? F7 DA 64 89 10 B8 FF FF FF FF C3 48 8B 15 ?? ?? ?? ?? F7 D8 64 89 02 48 83 C8 FF EB BB }
	condition:
		$1
}

rule file_372_1_0 {
	meta:
		name = "__fcntl_nocancel"
		size = 47
	strings:
		$1 = { 48 83 EC 58 48 8D 44 24 60 48 89 54 24 30 C7 44 24 08 10 00 00 00 48 89 44 24 10 48 8D 44 24 20 48 89 44 24 18 E8 06 FF FF FF 48 83 C4 58 C3 }
	condition:
		$1
}

rule file_372_2_0 {
	meta:
		name = "__libc_fcntl"
		size = 114
		refs = "0007 __libc_multiple_threads 0049 __libc_enable_asynccancel 0068 __libc_disable_asynccancel"
	strings:
		$1 = { 53 48 83 EC 60 8B 0D ?? ?? ?? ?? 48 8D 44 24 70 48 89 54 24 40 C7 44 24 18 10 00 00 00 48 89 44 24 20 48 8D 44 24 30 85 C9 48 89 44 24 28 75 0B E8 CB FE FF FF 48 83 C4 60 5B C3 83 FE 07 75 F0 48 89 54 24 08 89 3C 24 E8 ?? ?? ?? ?? 48 8B 54 24 08 8B 3C 24 89 C3 BE 07 00 00 00 E8 9F FE FF FF 89 DF 89 44 24 08 E8 ?? ?? ?? ?? 8B 44 24 08 EB C3 }
	condition:
		$1
}

rule file_16_2_3 {
	meta:
		name = "__libc_fcntl"
		size = 114
		refs = "0007 __pthread_multiple_threads 0049 __pthread_enable_asynccancel 0068 __pthread_disable_asynccancel"
	strings:
		$1 = { 53 48 83 EC 60 8B 0D ?? ?? ?? ?? 48 8D 44 24 70 48 89 54 24 40 C7 44 24 18 10 00 00 00 48 89 44 24 20 48 8D 44 24 30 85 C9 48 89 44 24 28 75 0B E8 CB FE FF FF 48 83 C4 60 5B C3 83 FE 07 75 F0 48 89 54 24 08 89 3C 24 E8 ?? ?? ?? ?? 48 8B 54 24 08 8B 3C 24 89 C3 BE 07 00 00 00 E8 9F FE FF FF 89 DF 89 44 24 08 E8 ?? ?? ?? ?? 8B 44 24 08 EB C3 }
	condition:
		$1
}

rule file_373_0_0 {
	meta:
		name = "xdr_pmap"
		size = 106
		refs = "0015 xdr_u_long"
	strings:
		$1 = { 48 89 5C 24 F0 48 89 6C 24 F8 48 83 EC 18 48 89 FB 48 89 F5 E8 ?? ?? ?? ?? 85 C0 75 13 31 C0 48 8B 5C 24 08 48 8B 6C 24 10 48 83 C4 18 C3 66 90 48 8D 75 08 48 89 DF E8 ?? ?? ?? ?? 85 C0 74 DD 48 8D 75 10 48 89 DF E8 ?? ?? ?? ?? 85 C0 74 CD 48 8D 75 18 48 89 DF 48 8B 6C 24 10 48 8B 5C 24 08 48 83 C4 18 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_374_0_0 {
	meta:
		name = "do_encoding"
		size = 38
	strings:
		$1 = { 48 8B 57 48 8B 42 58 85 C0 75 15 8B 42 48 3B 42 4C BA 00 00 00 00 0F 45 C2 C3 66 0F 1F 44 00 00 B8 FF FF FF FF C3 }
	condition:
		$1
}

rule file_374_3_0 {
	meta:
		name = "do_in"
		size = 208
		refs = "005d _dl_mcount_wrapper_check"
	strings:
		$1 = { 48 89 5C 24 D8 48 89 6C 24 E0 48 89 FB 4C 89 6C 24 F0 4C 89 74 24 F8 49 89 CD 4C 89 64 24 E8 48 83 EC 48 4C 8B 67 48 48 8B 44 24 50 4C 89 4F 50 4D 89 C6 48 89 77 70 48 89 54 24 18 48 89 47 58 49 83 3C 24 00 49 8B 6C 24 28 74 0D 48 C1 CD 11 64 48 33 2C 25 30 00 00 00 48 89 EF E8 ?? ?? ?? ?? 45 31 C0 4C 89 E9 48 8D 54 24 18 48 8D 73 50 C7 44 24 08 00 00 00 00 C7 04 24 00 00 00 00 4C 8D 4C 24 10 4C 89 E7 FF D5 48 8B 54 24 18 83 F8 07 49 89 16 48 8B 54 24 58 48 8B 4B 50 48 89 0A BA 02 00 00 00 77 09 89 C0 8B 14 85 ?? ?? ?? ?? 89 D0 48 8B 5C 24 20 48 8B 6C 24 28 4C 8B 64 24 30 4C 8B 6C 24 38 4C 8B 74 24 40 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_374_4_0 {
	meta:
		name = "do_unshift"
		size = 187
		refs = "0057 _dl_mcount_wrapper_check"
	strings:
		$1 = { 48 89 5C 24 E0 48 89 6C 24 E8 48 89 FB 4C 89 6C 24 F8 4C 89 64 24 F0 48 83 EC 48 4C 8B A7 90 00 00 00 48 89 97 98 00 00 00 4D 89 C5 48 89 8F A0 00 00 00 48 89 B7 B8 00 00 00 49 83 3C 24 00 49 8B 6C 24 28 74 0D 48 C1 CD 11 64 48 33 2C 25 30 00 00 00 48 89 EF E8 ?? ?? ?? ?? 31 D2 45 31 C0 31 C9 48 8D B3 98 00 00 00 C7 44 24 08 00 00 00 00 C7 04 24 01 00 00 00 4C 8D 4C 24 18 4C 89 E7 FF D5 48 8B 93 98 00 00 00 83 F8 07 49 89 55 00 BA 02 00 00 00 77 09 89 C0 8B 14 85 ?? ?? ?? ?? 89 D0 48 8B 5C 24 28 48 8B 6C 24 30 4C 8B 64 24 38 4C 8B 6C 24 40 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_374_5_0 {
	meta:
		name = "do_out"
		size = 226
		refs = "0069 _dl_mcount_wrapper_check"
	strings:
		$1 = { 48 89 5C 24 D8 48 89 6C 24 E0 48 89 FB 4C 89 6C 24 F0 4C 89 74 24 F8 49 89 CD 4C 89 64 24 E8 48 83 EC 48 4C 8B A7 90 00 00 00 48 8B 44 24 50 4C 89 8F 98 00 00 00 4D 89 C6 48 89 B7 B8 00 00 00 48 89 54 24 18 48 89 87 A0 00 00 00 49 83 3C 24 00 49 8B 6C 24 28 74 0D 48 C1 CD 11 64 48 33 2C 25 30 00 00 00 48 89 EF E8 ?? ?? ?? ?? 45 31 C0 4C 89 E9 48 8D 54 24 18 48 8D B3 98 00 00 00 C7 44 24 08 00 00 00 00 C7 04 24 00 00 00 00 4C 8D 4C 24 10 4C 89 E7 FF D5 48 8B 54 24 18 83 F8 07 49 89 16 48 8B 54 24 58 48 8B 8B 98 00 00 00 48 89 0A BA 02 00 00 00 77 09 89 C0 8B 14 85 ?? ?? ?? ?? 89 D0 48 8B 5C 24 20 48 8B 6C 24 28 4C 8B 64 24 30 4C 8B 6C 24 38 4C 8B 74 24 40 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_374_6_0 {
	meta:
		name = "do_length"
		size = 180
		refs = "006c _dl_mcount_wrapper_check"
	strings:
		$1 = { 55 49 C1 E0 02 49 8D 40 12 48 89 E5 48 89 5D D8 4C 89 65 E0 48 83 E0 F0 4C 89 75 F0 4C 89 7D F8 48 89 FB 4C 89 6D E8 48 83 EC 50 4C 8B 6F 48 48 29 C4 48 89 77 70 49 89 D6 48 8D 44 24 10 49 89 CF 48 89 55 C0 49 01 C0 48 89 47 50 4C 89 47 58 49 83 7D 00 00 4D 8B 65 28 74 0D 49 C1 CC 11 64 4C 33 24 25 30 00 00 00 4C 89 E7 E8 ?? ?? ?? ?? 48 8D 73 50 C7 44 24 08 00 00 00 00 C7 04 24 00 00 00 00 4C 8D 4D C8 4C 89 F9 48 8D 55 C0 4C 89 EF 45 31 C0 41 FF D4 48 8B 45 C0 48 8B 5D D8 4C 8B 65 E0 4C 8B 6D E8 4C 8B 7D F8 4C 29 F0 4C 8B 75 F0 C9 C3 }
	condition:
		$1
}

rule file_374_7_0 {
	meta:
		name = "_IO_fwide"
		size = 490
		refs = "0070 __wcsmbs_clone_conv 015f __libio_translit 01c4 __assert_fail"
	strings:
		$1 = { 48 89 6C 24 F0 48 89 5C 24 E8 48 89 FD 4C 89 64 24 F8 48 83 EC 38 85 F6 8B 87 C0 00 00 00 0F 88 BD 01 00 00 85 C0 0F 85 6F 01 00 00 85 F6 0F 84 67 01 00 00 48 8B 9F A0 00 00 00 48 8B 43 08 4C 8D 63 68 4C 89 A7 98 00 00 00 48 C7 43 58 00 00 00 00 48 89 03 48 8B 43 18 48 89 43 20 48 8B 87 A0 00 00 00 48 89 E7 48 C7 40 60 00 00 00 00 E8 ?? ?? ?? ?? 48 83 7C 24 08 01 0F 85 2F 01 00 00 48 83 7C 24 18 01 0F 85 3C 01 00 00 31 C0 B9 1A 00 00 00 4C 89 E7 F3 48 AB 48 C7 83 A8 00 00 00 01 00 00 00 C7 83 D0 00 00 00 01 00 00 00 BA 01 00 00 00 C7 83 C8 00 00 00 01 00 00 00 48 C7 43 70 ?? ?? ?? ?? 31 F6 48 8B 04 24 48 C7 43 78 ?? ?? ?? ?? 48 89 EF 48 C7 83 80 00 00 00 ?? ?? ?? ?? 48 C7 83 88 00 00 00 ?? ?? ?? ?? 48 C7 83 90 00 00 00 ?? ?? ?? ?? 48 C7 83 98 00 00 00 ?? ?? ?? ?? 48 89 83 B0 00 00 00 48 8B 85 A0 00 00 00 48 C7 83 F0 00 00 00 01 00 00 00 C7 83 18 01 00 00 01 00 00 00 C7 83 10 01 00 00 01 00 00 00 48 C7 83 A0 00 00 00 ?? ?? ?? ?? 48 83 C0 58 48 89 83 D8 00 00 00 48 8B 44 24 10 48 89 83 F8 00 00 00 48 8B 85 A0 00 00 00 48 C7 83 30 01 00 00 ?? ?? ?? ?? 48 83 C0 58 48 89 83 20 01 00 00 48 8B 85 A0 00 00 00 48 8B 80 40 01 00 00 48 89 85 D8 00 00 00 FF 90 80 00 00 00 48 89 85 90 00 00 00 B8 01 00 00 00 89 85 C0 00 00 00 48 8B 5C 24 20 48 8B 6C 24 28 4C 8B 64 24 30 48 83 C4 38 C3 B9 ?? ?? ?? ?? BA 8A 00 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? B9 ?? ?? ?? ?? BA 8B 00 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 75 B6 83 C8 FF EB AB }
	condition:
		$1
}

rule file_375_0_0 {
	meta:
		name = "__ldexpl"
		size = 158
		refs = "0015 __finitel 0054 __scalbnl 008d __libc_errno"
	strings:
		$1 = { 53 89 FB 48 83 EC 30 DB 6C 24 40 D9 C0 DB 3C 24 DB 7C 24 10 E8 ?? ?? ?? ?? 85 C0 DB 6C 24 10 74 10 D9 EE D9 C0 D9 CA DB EA DD DA 7A 13 75 19 DD D8 48 83 C4 30 5B C3 66 0F 1F 84 00 00 00 00 00 D9 C9 EB 06 0F 1F 40 00 D9 C9 DB 3C 24 89 DF D9 5C 24 20 E8 ?? ?? ?? ?? D9 C0 DB 3C 24 DB 7C 24 10 E8 ?? ?? ?? ?? 85 C0 DB 6C 24 10 D9 44 24 20 74 16 D9 C9 DB E9 DD D9 7A B7 75 B5 0F 1F 40 00 EB 08 66 0F 1F 44 00 00 DD D8 48 8B 05 ?? ?? ?? ?? 64 C7 00 22 00 00 00 48 83 C4 30 5B C3 }
	condition:
		$1
}

rule file_84_0_2 {
	meta:
		name = "__ldexpl"
		size = 158
		refs = "0015 __finitel 0054 __scalbnl 008d errno"
	strings:
		$1 = { 53 89 FB 48 83 EC 30 DB 6C 24 40 D9 C0 DB 3C 24 DB 7C 24 10 E8 ?? ?? ?? ?? 85 C0 DB 6C 24 10 74 10 D9 EE D9 C0 D9 CA DB EA DD DA 7A 13 75 19 DD D8 48 83 C4 30 5B C3 66 0F 1F 84 00 00 00 00 00 D9 C9 EB 06 0F 1F 40 00 D9 C9 DB 3C 24 89 DF D9 5C 24 20 E8 ?? ?? ?? ?? D9 C0 DB 3C 24 DB 7C 24 10 E8 ?? ?? ?? ?? 85 C0 DB 6C 24 10 D9 44 24 20 74 16 D9 C9 DB E9 DD D9 7A B7 75 B5 0F 1F 40 00 EB 08 66 0F 1F 44 00 00 DD D8 48 8B 05 ?? ?? ?? ?? 64 C7 00 22 00 00 00 48 83 C4 30 5B C3 }
	condition:
		$1
}

rule file_377_0_0 {
	meta:
		name = "__libc_waitpid"
		size = 152
		refs = "0002 __libc_multiple_threads 0027 __libc_errno 0047 __libc_enable_asynccancel 0077 __libc_disable_asynccancel"
	strings:
		$1 = { 8B 05 ?? ?? ?? ?? 85 C0 75 2B 45 31 D2 48 63 D2 48 63 FF B8 3D 00 00 00 0F 05 48 3D 00 F0 FF FF 77 02 F3 C3 48 8B 15 ?? ?? ?? ?? F7 D8 64 89 02 48 83 C8 FF C3 48 83 EC 28 89 54 24 08 48 89 74 24 10 89 7C 24 18 E8 ?? ?? ?? ?? 45 31 D2 41 89 C0 48 63 54 24 08 48 8B 74 24 10 48 63 7C 24 18 B8 3D 00 00 00 0F 05 48 3D 00 F0 FF FF 77 15 44 89 C7 89 44 24 18 E8 ?? ?? ?? ?? 8B 44 24 18 48 83 C4 28 C3 89 C2 48 8B 05 ?? ?? ?? ?? F7 DA 64 89 10 48 83 C8 FF EB D7 }
	condition:
		$1
}

rule file_121_0_3 {
	meta:
		name = "__libc_waitpid"
		size = 152
		refs = "0002 __pthread_multiple_threads 0027 errno 0047 __pthread_enable_asynccancel 0077 __pthread_disable_asynccancel"
	strings:
		$1 = { 8B 05 ?? ?? ?? ?? 85 C0 75 2B 45 31 D2 48 63 D2 48 63 FF B8 3D 00 00 00 0F 05 48 3D 00 F0 FF FF 77 02 F3 C3 48 8B 15 ?? ?? ?? ?? F7 D8 64 89 02 48 83 C8 FF C3 48 83 EC 28 89 54 24 08 48 89 74 24 10 89 7C 24 18 E8 ?? ?? ?? ?? 45 31 D2 41 89 C0 48 63 54 24 08 48 8B 74 24 10 48 63 7C 24 18 B8 3D 00 00 00 0F 05 48 3D 00 F0 FF FF 77 15 44 89 C7 89 44 24 18 E8 ?? ?? ?? ?? 8B 44 24 18 48 83 C4 28 C3 89 C2 48 8B 05 ?? ?? ?? ?? F7 DA 64 89 10 48 83 C8 FF EB D7 }
	condition:
		$1
}

rule file_378_0_0 {
	meta:
		name = "posix_spawn_file_actions_adddup2"
		size = 170
		refs = "0020 __sysconf 0094 __posix_spawn_file_actions_realloc"
	strings:
		$1 = { 48 89 5C 24 E8 48 89 6C 24 F0 89 D3 4C 89 64 24 F8 48 83 EC 18 49 89 FC BF 04 00 00 00 89 F5 E8 ?? ?? ?? ?? 89 DA C1 EA 1F 84 D2 74 1B B8 09 00 00 00 48 8B 1C 24 48 8B 6C 24 08 4C 8B 64 24 10 48 83 C4 18 C3 0F 1F 00 89 EA C1 EA 1F 84 D2 75 DC 39 C3 7D D8 39 C5 7D D4 41 8B 54 24 04 41 3B 14 24 74 2C 48 63 C2 83 C2 01 48 C1 E0 05 49 03 44 24 08 C7 00 01 00 00 00 89 68 08 89 58 0C 41 89 54 24 04 31 C0 EB AA 0F 1F 84 00 00 00 00 00 4C 89 E7 E8 ?? ?? ?? ?? 89 C2 B8 0C 00 00 00 85 D2 75 8F 41 8B 54 24 04 EB BA }
	condition:
		$1
}

rule file_379_0_0 {
	meta:
		name = "wcschr"
		size = 388
	strings:
		$1 = { 66 48 0F 6E CE 66 0F EF D2 48 89 F9 66 0F 62 C9 66 0F 62 C9 48 83 E1 3F 48 83 F9 30 77 48 F3 0F 6F 07 66 0F 76 D0 48 83 C7 10 66 0F 76 C1 66 0F D7 D2 66 0F D7 C0 48 09 C2 0F 85 11 01 00 00 48 83 E7 F0 66 0F 6F 07 66 0F 76 D0 48 83 C7 10 66 0F 76 C1 66 0F D7 D2 66 0F D7 C0 48 09 C2 0F 85 EC 00 00 00 EB 6A 48 83 E1 0F 48 83 E7 F0 66 0F 6F 07 66 0F 76 D0 66 0F 76 C1 66 0F D7 D2 66 0F D7 C0 48 D3 FA 48 D3 F8 48 85 C0 74 23 48 0F BC C0 48 85 D2 74 0D 48 0F BC D2 48 39 D0 0F 87 DD 00 00 00 48 01 F8 48 01 C8 C3 66 0F 1F 44 00 00 48 85 D2 0F 85 C7 00 00 00 66 0F EF D2 48 83 C7 10 66 66 66 66 66 66 2E 0F 1F 84 00 00 00 00 00 66 0F 6F 07 66 0F 76 D0 48 83 C7 10 66 0F 76 C1 66 0F D7 D2 66 0F D7 C0 48 09 C2 75 63 66 0F 6F 07 66 0F 76 D0 48 83 C7 10 66 0F 76 C1 66 0F D7 D2 66 0F D7 C0 48 09 C2 75 46 66 0F 6F 07 66 0F 76 D0 48 83 C7 10 66 0F 76 C1 66 0F D7 D2 66 0F D7 C0 48 09 C2 75 29 66 0F 6F 07 66 0F 76 D0 48 83 C7 10 66 0F 76 C1 66 0F D7 D2 66 0F D7 C0 48 09 C2 75 0C EB 8A 66 2E 0F 1F 84 00 00 00 00 00 66 0F D7 D2 48 85 C0 74 27 48 0F BC C0 48 85 D2 74 09 48 0F BC CA 48 39 C8 77 15 48 83 EF 10 48 01 F8 C3 66 66 66 66 2E 0F 1F 84 00 00 00 00 00 48 31 C0 C3 }
	condition:
		$1
}

rule file_380_0_0 {
	meta:
		name = "clnt_create"
		size = 695
		refs = "0066 strcpy 008f clntunix_create 00cb __libc_errno 010d __gethostbyname_r 012b __rpc_thread_createerr 0199 memcpy 01e2 __getprotobyname_r 0284 clnttcp_create 02ae clntudp_create"
	strings:
		$1 = { 55 48 89 E5 41 57 49 89 D7 41 56 41 55 49 89 CD B9 05 00 00 00 41 54 49 89 FC BF ?? ?? ?? ?? 53 48 81 EC 08 01 00 00 48 89 B5 D8 FE FF FF 4C 89 EE F3 A6 75 73 48 8D 9D 60 FF FF FF 31 C0 B9 0D 00 00 00 4C 89 E6 48 89 DF F3 48 AB 66 C7 85 60 FF FF FF 01 00 C7 07 00 00 00 00 66 C7 47 04 00 00 48 8D 7B 02 E8 ?? ?? ?? ?? 48 8B B5 D8 FE FF FF 48 8D 8D E8 FE FF FF 45 31 C9 45 31 C0 4C 89 FA 48 89 DF C7 85 E8 FE FF FF FF FF FF FF E8 ?? ?? ?? ?? 48 8D 65 D8 5B 41 5C 41 5D 41 5E 41 5F 5D C3 66 0F 1F 44 00 00 48 81 EC 10 04 00 00 41 BE 00 04 00 00 BB 10 00 00 00 48 8D 54 24 0F 48 83 E2 F0 EB 2C 0F 1F 00 48 8B 05 ?? ?? ?? ?? 64 83 38 22 75 55 4D 01 F6 31 D2 49 8D 46 1E 48 F7 F3 48 C1 E0 04 48 29 C4 48 8D 54 24 0F 48 83 E2 F0 4C 8D 8D EC FE FF FF 4C 8D 85 F0 FE FF FF 48 8D B5 40 FF FF FF 4C 89 F1 4C 89 E7 E8 ?? ?? ?? ?? 85 C0 75 0C 48 8B 85 F0 FE FF FF 48 85 C0 75 2F 83 BD EC FE FF FF FF 74 9E E8 ?? ?? ?? ?? C7 00 0D 00 00 00 48 8D 65 D8 31 C0 5B 41 5C 41 5D 41 5E 41 5F 5D C3 66 2E 0F 1F 84 00 00 00 00 00 83 78 10 02 0F 85 C2 00 00 00 48 63 50 14 48 8B 40 18 48 8D BD 00 FF FF FF 48 C7 85 08 FF FF FF 00 00 00 00 66 C7 85 00 FF FF FF 02 00 41 BC 00 04 00 00 48 83 C7 04 66 C7 85 02 FF FF FF 00 00 BB 10 00 00 00 48 8B 30 E8 ?? ?? ?? ?? 48 81 EC 10 04 00 00 48 8D 54 24 0F 48 83 E2 F0 EB 1E 90 4D 01 E4 31 D2 49 8D 44 24 1E 48 F7 F3 48 C1 E0 04 48 29 C4 48 8D 54 24 0F 48 83 E2 F0 4C 8D 85 F8 FE FF FF 48 8D B5 20 FF FF FF 4C 89 E1 4C 89 EF E8 ?? ?? ?? ?? 85 C0 75 0C 48 8B 85 F8 FE FF FF 48 85 C0 75 3F 48 8B 05 ?? ?? ?? ?? 64 83 38 22 74 AD E8 ?? ?? ?? ?? C7 00 11 00 00 00 C7 40 10 60 00 00 00 31 C0 E9 77 FE FF FF E8 ?? ?? ?? ?? C7 00 0C 00 00 00 C7 40 10 61 00 00 00 31 C0 E9 5E FE FF FF 8B 40 10 C7 85 E8 FE FF FF FF FF FF FF 83 F8 06 74 1E 83 F8 11 74 41 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 C7 40 10 60 00 00 00 31 C0 E9 2E FE FF FF 48 8B B5 D8 FE FF FF 48 8D 8D E8 FE FF FF 48 8D BD 00 FF FF FF 45 31 C9 45 31 C0 4C 89 FA E8 ?? ?? ?? ?? E9 06 FE FF FF 48 8B B5 D8 FE FF FF 4C 8D 8D E8 FE FF FF 48 8D BD 00 FF FF FF B9 05 00 00 00 45 31 C0 4C 89 FA E8 ?? ?? ?? ?? E9 DC FD FF FF }
	condition:
		$1
}

rule file_381_0_0 {
	meta:
		name = "__statvfs_getflags"
		size = 1542
		refs = "00d3 __setmntent 0106 __getmntent_r 0121 strcmp 0180 __xstat64 01e2 strchr 021b __endmntent 03b9 rewind 0602 __assert_fail"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 53 48 81 EC D8 04 00 00 48 85 D2 0F 84 A7 02 00 00 81 FE A0 9F 00 00 48 89 FB 49 89 D7 0F 84 09 05 00 00 7E 50 81 FE D0 0B D0 0B 0F 84 E4 04 00 00 0F 8E E4 01 00 00 81 FE 4E 54 46 53 0F 84 73 04 00 00 0F 1F 40 00 0F 8E FB 02 00 00 81 FE 42 53 46 58 0F 84 5D 05 00 00 81 FE 72 65 65 62 75 48 48 C7 44 24 08 00 00 00 00 45 31 F6 41 BC ?? ?? ?? ?? EB 4A 81 FE 73 13 00 00 0F 84 7D 04 00 00 0F 8E D5 01 00 00 81 FE 44 4D 00 00 0F 84 C7 04 00 00 0F 1F 40 00 0F 8F 36 02 00 00 81 FE D1 1C 00 00 0F 84 9A 04 00 00 48 C7 44 24 08 00 00 00 00 45 31 F6 45 31 E4 0F 1F 80 00 00 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 85 C0 48 89 C5 0F 84 C3 01 00 00 81 4D 00 00 80 00 00 66 0F 1F 44 00 00 48 8D 94 24 D0 00 00 00 48 8D 74 24 10 B9 00 04 00 00 48 89 EF E8 ?? ?? ?? ?? 48 85 C0 0F 84 8D 02 00 00 48 85 DB 74 11 48 8B 74 24 18 48 89 DF E8 ?? ?? ?? ?? 85 C0 75 C7 4D 85 E4 74 42 4C 8B 6C 24 20 4C 89 E7 4C 89 EE E8 ?? ?? ?? ?? 85 C0 74 2E 4D 85 F6 74 0F 4C 89 EE 4C 89 F7 E8 ?? ?? ?? ?? 85 C0 74 1A 48 83 7C 24 08 00 74 92 48 8B 7C 24 08 4C 89 EE E8 ?? ?? ?? ?? 85 C0 75 81 90 48 8B 74 24 18 48 8D 54 24 40 BF 01 00 00 00 E8 ?? ?? ?? ?? 85 C0 0F 88 64 FF FF FF 48 8B 44 24 40 49 39 07 0F 85 56 FF FF FF 4C 8B 7C 24 28 31 DB 4D 85 FF 74 71 41 BC 07 00 00 00 41 BD 06 00 00 00 41 BE 05 00 00 00 EB 1F 66 0F 1F 44 00 00 41 80 7F 01 6F 75 35 41 80 7F 02 00 75 2E 83 CB 01 48 85 C0 74 41 49 89 C7 BE 2C 00 00 00 4C 89 FF E8 ?? ?? ?? ?? 48 85 C0 0F 84 D9 01 00 00 C6 00 00 48 83 C0 01 41 80 3F 72 74 C4 BF ?? ?? ?? ?? 4C 89 FE 4C 89 E1 F3 A6 0F 85 71 01 00 00 83 CB 02 48 85 C0 75 BF 48 89 EF E8 ?? ?? ?? ?? E9 A4 00 00 00 81 FE 53 EF 00 00 0F 84 BD 02 00 00 0F 8E F8 00 00 00 81 FE EB E0 27 00 0F 84 66 03 00 00 81 FE 94 19 02 01 0F 85 64 FE FF FF 48 C7 44 24 08 00 00 00 00 45 31 F6 41 BC ?? ?? ?? ?? E9 63 FE FF FF 81 FE 68 81 7E C9 0F 84 20 03 00 00 0F 8E 94 00 00 00 81 FE 49 E8 95 F9 0F 84 F7 02 00 00 81 FE 87 01 00 00 0F 85 23 FE FF FF 48 C7 44 24 08 00 00 00 00 45 31 F6 41 BC ?? ?? ?? ?? E9 22 FE FF FF BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 85 C0 48 89 C5 0F 85 22 FE FF FF 31 DB 0F 1F 44 00 00 48 81 C4 D8 04 00 00 89 D8 5B 5D 41 5C 41 5D 41 5E 41 5F C3 81 FE 69 69 00 00 0F 84 EE 01 00 00 81 FE 60 96 00 00 0F 85 BE FD FF FF 48 C7 44 24 08 00 00 00 00 45 31 F6 41 BC ?? ?? ?? ?? E9 BD FD FF FF 81 FE 3E 68 23 91 0F 85 9B FD FF FF 48 C7 44 24 08 00 00 00 00 45 31 F6 41 BC ?? ?? ?? ?? E9 9A FD FF FF 81 FE A2 9F 00 00 0F 85 78 FD FF FF 48 C7 44 24 08 00 00 00 00 45 31 F6 41 BC ?? ?? ?? ?? E9 77 FD FF FF 81 FE 4A 46 53 31 0F 84 79 02 00 00 81 FE 73 49 65 52 0F 85 49 FD FF FF 48 C7 44 24 08 00 00 00 00 45 31 F6 41 BC ?? ?? ?? ?? E9 48 FD FF FF BF ?? ?? ?? ?? 4C 89 FE 4C 89 E1 F3 A6 75 41 83 CB 08 E9 3A FE FF FF 66 0F 1F 84 00 00 00 00 00 48 85 DB 0F 95 C0 4D 85 E4 0F 84 D3 00 00 00 84 C0 74 3D 48 89 EF 31 DB E8 ?? ?? ?? ?? E9 2E FD FF FF 66 0F 1F 44 00 00 31 C0 E9 27 FE FF FF 90 BF ?? ?? ?? ?? 4C 89 FE 4C 89 E9 F3 A6 75 31 83 CB 04 E9 EA FD FF FF 66 0F 1F 84 00 00 00 00 00 4D 85 E4 0F 84 F4 01 00 00 48 C7 44 24 08 00 00 00 00 45 31 F6 45 31 E4 EB A9 66 0F 1F 44 00 00 BF ?? ?? ?? ?? 4C 89 FE 4C 89 F1 F3 A6 75 11 83 CB 10 E9 AA FD FF FF 66 0F 1F 84 00 00 00 00 00 BF ?? ?? ?? ?? 4C 89 FE 4C 89 F1 F3 A6 75 11 83 CB 40 E9 8A FD FF FF 66 0F 1F 84 00 00 00 00 00 BF ?? ?? ?? ?? 4C 89 FE B9 08 00 00 00 F3 A6 75 08 80 CF 04 E9 68 FD FF FF BF ?? ?? ?? ?? 4C 89 FE B9 0B 00 00 00 F3 A6 75 1F 80 CF 08 E9 4F FD FF FF 84 C0 0F 85 29 FF FF FF 48 89 EF 31 DB E8 ?? ?? ?? ?? E9 2F FE FF FF 4C 89 FE B9 09 00 00 00 BF ?? ?? ?? ?? F3 A6 89 DA 40 0F 97 C6 0F 92 C1 80 CE 10 40 38 CE 0F 44 DA E9 12 FD FF FF 48 C7 44 24 08 00 00 00 00 45 31 F6 41 BC ?? ?? ?? ?? E9 F2 FB FF FF 48 C7 44 24 08 00 00 00 00 45 31 F6 41 BC ?? ?? ?? ?? E9 DB FB FF FF 48 C7 44 24 08 ?? ?? ?? ?? 41 BE ?? ?? ?? ?? 41 BC ?? ?? ?? ?? E9 C1 FB FF FF 48 C7 44 24 08 00 00 00 00 45 31 F6 41 BC ?? ?? ?? ?? E9 AA FB FF FF 48 C7 44 24 08 00 00 00 00 45 31 F6 41 BC ?? ?? ?? ?? E9 93 FB FF FF 48 C7 44 24 08 00 00 00 00 45 31 F6 41 BC ?? ?? ?? ?? E9 7C FB FF FF 48 C7 44 24 08 00 00 00 00 45 31 F6 41 BC ?? ?? ?? ?? E9 65 FB FF FF 48 C7 44 24 08 00 00 00 00 45 31 F6 41 BC ?? ?? ?? ?? E9 4E FB FF FF 48 C7 44 24 08 00 00 00 00 45 31 F6 41 BC ?? ?? ?? ?? E9 37 FB FF FF 48 C7 44 24 08 00 00 00 00 45 31 F6 41 BC ?? ?? ?? ?? E9 20 FB FF FF 48 C7 44 24 08 00 00 00 00 45 31 F6 41 BC ?? ?? ?? ?? E9 09 FB FF FF 48 C7 44 24 08 00 00 00 00 45 31 F6 41 BC ?? ?? ?? ?? E9 F2 FA FF FF 48 C7 44 24 08 00 00 00 00 45 31 F6 41 BC ?? ?? ?? ?? E9 DB FA FF FF B9 ?? ?? ?? ?? BA C7 00 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_381_1_0 {
	meta:
		name = "__internal_statvfs"
		size = 163
		refs = "0097 __statvfs_getflags"
	strings:
		$1 = { 53 48 8B 42 08 48 89 F3 44 8B 42 38 48 89 06 48 8B 72 48 48 85 F6 48 0F 45 C6 48 8B 72 30 48 89 43 08 48 8B 42 10 48 89 43 10 48 8B 42 18 48 89 43 18 48 8B 42 20 48 89 43 20 48 8B 42 28 48 89 73 30 48 89 43 28 48 63 42 3C 48 C1 E0 20 4C 09 C0 48 89 43 40 48 8B 42 40 48 C7 43 58 00 00 00 00 48 C7 43 60 00 00 00 00 48 C7 43 68 00 00 00 00 48 89 73 38 48 89 43 50 48 8B 42 50 A8 20 74 0F 48 83 F0 20 48 89 43 48 5B C3 0F 1F 44 00 00 48 8B 32 48 89 CA E8 ?? ?? ?? ?? 48 98 48 89 43 48 5B C3 }
	condition:
		$1
}

rule file_382_0_0 {
	meta:
		name = "ftok"
		size = 71
		refs = "0016 __xstat64"
	strings:
		$1 = { 53 89 F3 48 89 FE BF 01 00 00 00 48 81 EC 90 00 00 00 48 89 E2 E8 ?? ?? ?? ?? 85 C0 78 22 0F B6 04 24 0F B7 54 24 08 C1 E3 18 C1 E0 10 09 D0 09 D8 48 81 C4 90 00 00 00 5B C3 66 0F 1F 44 00 00 B8 FF FF FF FF EB EA }
	condition:
		$1
}

rule file_383_0_0 {
	meta:
		name = "_L_unlock_13"
		size = 24
		refs = "000b __lll_unlock_wake_private"
	strings:
		$1 = { 48 8D 3A 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 EB E6 }
	condition:
		$1
}

rule file_383_1_0 {
	meta:
		name = "__funlockfile"
		size = 43
		refs = "0017 __libc_multiple_threads"
	strings:
		$1 = { 48 8B 97 88 00 00 00 83 6A 04 01 75 1C 48 C7 42 08 00 00 00 00 83 3D ?? ?? ?? ?? 00 74 07 F0 FF 0A 75 08 EB 04 FF 0A 75 02 F3 C3 }
	condition:
		$1
}

rule file_384_0_0 {
	meta:
		name = "call_dl_lookup"
		size = 62
		refs = "0031 _dl_lookup_symbol_x"
	strings:
		$1 = { 53 48 89 FB 45 31 C9 48 83 EC 10 48 8B 37 8B 43 18 48 8B 57 28 4C 8B 43 10 48 8B 7F 08 48 8B 8E 80 03 00 00 48 C7 44 24 08 00 00 00 00 89 04 24 E8 ?? ?? ?? ?? 48 89 03 48 83 C4 10 5B C3 }
	condition:
		$1
}

rule file_384_1_0 {
	meta:
		name = "do_sym"
		size = 832
		refs = "001d _dl_nns 0042 _dl_ns 008f _dl_addr_inside_object 0115 _dl_lookup_symbol_x 024c _dl_catch_error 02c4 _dl_signal_error 02cc strlen 02ec memcpy 032c free"
	strings:
		$1 = { 55 48 89 E5 41 57 41 56 49 89 D6 41 55 41 54 53 48 89 FB 48 81 EC 88 00 00 00 48 83 3D ?? ?? ?? ?? 00 48 89 B5 70 FF FF FF 48 89 8D 68 FF FF FF 44 89 85 64 FF FF FF 48 C7 45 88 00 00 00 00 4C 8B 2D ?? ?? ?? ?? 0F 84 84 00 00 00 48 C7 85 78 FF FF FF ?? ?? ?? ?? 4C 89 E9 45 31 E4 48 85 C9 74 42 49 89 CF 0F 1F 00 4D 3B B7 40 03 00 00 72 2A 4D 3B B7 48 03 00 00 73 21 41 F6 87 15 03 00 00 40 0F 85 D0 00 00 00 4C 89 F6 4C 89 FF E8 ?? ?? ?? ?? 85 C0 0F 85 BD 00 00 00 4D 8B 7F 18 4D 85 FF 75 C4 49 83 C4 01 4C 3B 25 ?? ?? ?? ?? 73 1F 48 8B 85 78 FF FF FF 48 8B 08 48 05 90 00 00 00 48 89 85 78 FF FF FF EB 93 66 0F 1F 44 00 00 48 85 DB 0F 84 E3 00 00 00 48 83 FB FF 0F 84 7D 00 00 00 8B 85 64 FF FF FF 4C 8B 85 68 FF FF FF 48 8D 8B 88 03 00 00 48 8B BD 70 FF FF FF 48 8D 55 88 48 C7 44 24 08 00 00 00 00 45 31 C9 48 89 DE 89 04 24 E8 ?? ?? ?? ?? 48 8B 55 88 48 85 D2 0F 84 C7 00 00 00 48 85 C0 0F 84 B7 00 00 00 48 8B 00 48 03 42 08 0F B6 52 04 83 E2 0F 80 FA 0A 0F 84 4F 01 00 00 48 8D 65 D8 5B 41 5C 41 5D 41 5E 41 5F 5D C3 0F 1F 00 4D 89 FD E9 44 FF FF FF 4C 3B 2D ?? ?? ?? ?? 0F 84 2F 01 00 00 4C 89 EA EB 09 66 0F 1F 44 00 00 48 89 C2 48 8B 82 D8 02 00 00 48 85 C0 75 F1 48 8D 8A 88 03 00 00 4C 89 6C 24 08 C7 04 24 00 00 00 00 4C 8B 85 68 FF FF FF 48 8B BD 70 FF FF FF 48 8D 55 88 45 31 C9 4C 89 EE E8 ?? ?? ?? ?? E9 5D FF FF FF 64 8B 04 25 18 00 00 00 85 C0 75 2C 8B 85 64 FF FF FF 49 8B 8D 80 03 00 00 48 C7 44 24 08 00 00 00 00 83 C8 01 89 04 24 EB B4 31 C0 E9 45 FF FF FF 31 C0 E9 52 FF FF FF 48 8B 85 70 FF FF FF 4C 89 6D A0 48 89 45 A8 48 8B 85 68 FF FF FF 48 89 45 B0 8B 85 64 FF FF FF 83 C8 05 89 45 B8 48 8D 45 88 48 89 45 C8 64 C7 04 25 1C 00 00 00 01 00 00 00 4C 8D 45 A0 48 8D 55 87 48 8D 75 98 48 8D 7D 90 B9 ?? ?? ?? ?? 48 C7 45 98 00 00 00 00 E8 ?? ?? ?? ?? 41 89 C4 31 C0 64 87 04 25 1C 00 00 00 83 F8 02 75 21 BA 01 00 00 00 64 48 8B 3C 25 10 00 00 00 64 8B 34 25 48 00 00 00 48 83 C7 1C 83 CE 01 B0 CA 0F 05 48 8B 5D 98 48 85 DB 75 3C 48 8B 45 A0 E9 84 FE FF FF FF D0 E9 AA FE FF FF 4D 85 ED 90 74 16 4D 3B B5 40 03 00 00 72 0D 4D 3B B5 48 03 00 00 0F 82 B5 FE FF FF B9 ?? ?? ?? ?? 31 D2 31 F6 31 FF E8 ?? ?? ?? ?? 48 89 DF E8 ?? ?? ?? ?? 48 8D 50 01 48 83 C0 1F 48 89 DE 48 83 E0 F0 48 29 C4 48 8D 7C 24 1F 48 83 E7 F0 E8 ?? ?? ?? ?? 4C 8B 75 90 49 89 C5 4C 89 F7 E8 ?? ?? ?? ?? 4C 8D 40 1F 48 8D 50 01 4C 89 F6 49 83 E0 F0 4C 29 C4 48 8D 7C 24 1F 48 83 E7 F0 E8 ?? ?? ?? ?? 80 7D 87 00 49 89 C6 74 08 48 89 DF E8 ?? ?? ?? ?? 4C 89 E9 31 D2 4C 89 F6 44 89 E7 E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_384_2_0 {
	meta:
		name = "_dl_vsym"
		size = 205
	strings:
		$1 = { 49 89 D0 48 83 EC 28 31 C0 45 0F B6 10 48 89 CA 4C 89 04 24 C7 44 24 0C 01 00 00 00 45 0F B6 CA 4D 85 C9 0F 84 87 00 00 00 41 0F B6 48 01 41 0F B6 C2 84 C9 74 7A 45 0F B6 50 02 4C 89 C8 48 C1 E0 04 48 01 C8 45 84 D2 74 66 41 0F B6 48 03 48 C1 E0 04 4C 01 D0 84 C9 74 56 45 0F B6 48 04 48 C1 E0 04 48 01 C8 45 84 C9 74 45 48 C1 E0 04 4C 01 C8 4D 8D 48 05 45 0F B6 40 05 45 84 C0 74 23 48 C1 E0 04 49 83 C1 01 49 01 C0 4C 89 C0 25 00 00 00 F0 48 C1 E8 18 4C 31 C0 45 0F B6 01 45 84 C0 75 DD 25 FF FF FF 0F 0F 1F 84 00 00 00 00 00 48 89 E1 45 31 C0 89 44 24 08 48 C7 44 24 10 00 00 00 00 E8 F8 FB FF FF 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_385_0_0 {
	meta:
		name = "__libc_poll"
		size = 81
		refs = "0002 __libc_multiple_threads 0022 __libc_enable_asynccancel 0039 __libc_disable_asynccancel 0018 __syscall_error"
		altNames = "__poll"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 75 14 B8 07 00 00 00 0F 05 48 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 48 83 EC 08 E8 ?? ?? ?? ?? 48 89 04 24 B8 07 00 00 00 0F 05 48 8B 3C 24 48 89 C2 E8 ?? ?? ?? ?? 48 89 D0 48 83 C4 08 48 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_385_1_0 {
	meta:
		name = "__poll_nocancel"
		size = 20
		refs = "000f __syscall_error"
	strings:
		$1 = { B8 07 00 00 00 0F 05 48 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_386_0_0 {
	meta:
		name = "_openchild"
		size = 359
		refs = "0025 __pipe 0044 __fork 005e __close 0066 __dup 0080 stderr 0085 _IO_fflush 008a _rpc_dtablesize 00c6 execlp 00d0 perror 00da _exit 00ea _IO_fdopen"
	strings:
		$1 = { 48 89 6C 24 E8 4C 89 64 24 F0 48 89 FD 4C 89 6C 24 F8 48 89 5C 24 E0 48 83 EC 48 48 89 E7 49 89 F5 49 89 D4 E8 ?? ?? ?? ?? 85 C0 0F 88 2F 01 00 00 48 8D 7C 24 10 E8 ?? ?? ?? ?? 85 C0 0F 88 FF 00 00 00 E8 ?? ?? ?? ?? 83 F8 FF 89 C3 0F 84 DD 00 00 00 85 C0 0F 85 85 00 00 00 31 FF E8 ?? ?? ?? ?? 8B 3C 24 E8 ?? ?? ?? ?? BF 01 00 00 00 E8 ?? ?? ?? ?? 8B 7C 24 14 E8 ?? ?? ?? ?? 48 8B 3D ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 58 FF 83 FB 02 7E 19 66 2E 0F 1F 84 00 00 00 00 00 89 DF 83 EB 01 E8 ?? ?? ?? ?? 83 FB 02 75 F1 48 8B 3D ?? ?? ?? ?? E8 ?? ?? ?? ?? 31 D2 48 89 EE 48 89 EF 31 C0 E8 ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? BF FF FF FF FF E8 ?? ?? ?? ?? 66 90 8B 7C 24 04 BE ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 3C 24 49 89 45 00 E8 ?? ?? ?? ?? 8B 7C 24 10 BE ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 7C 24 14 49 89 04 24 E8 ?? ?? ?? ?? 89 D8 48 8B 6C 24 30 48 8B 5C 24 28 4C 8B 64 24 38 4C 8B 6C 24 40 48 83 C4 48 C3 8B 7C 24 10 E8 ?? ?? ?? ?? 8B 7C 24 14 E8 ?? ?? ?? ?? 8B 3C 24 BB FF FF FF FF E8 ?? ?? ?? ?? 8B 7C 24 04 E8 ?? ?? ?? ?? EB BB 66 0F 1F 44 00 00 BB FF FF FF FF EB AE }
	condition:
		$1
}

rule file_387_0_0 {
	meta:
		name = "strrchr"
		size = 159
	strings:
		$1 = { 66 0F 6E CE 48 89 F9 66 0F 60 C9 48 83 E7 F0 66 0F EF D2 66 0F 60 C9 83 CE FF 66 0F 6F 07 66 0F 70 C9 00 48 29 F9 66 0F 6F D8 48 8D 7F 10 66 0F 74 C1 66 0F 74 DA D3 E6 66 0F D7 D0 66 0F D7 CB 21 F2 21 F1 31 C0 89 D6 09 CE 75 22 66 0F 6F 07 48 8D 7F 10 66 0F 6F D8 66 0F 74 C1 66 0F 74 DA 66 0F D7 D0 66 0F D7 CB 89 D6 09 CE 74 DE 44 0F BC C9 41 B8 FF FF FF FF B9 1F 00 00 00 75 0C 0F BD D2 74 C8 48 8D 44 17 F0 EB C1 44 29 C9 41 D3 E8 44 21 C2 0F BD D2 74 05 48 8D 44 17 F0 C3 }
	condition:
		$1
}

rule file_388_0_0 {
	meta:
		name = "__gettext_extract_plural"
		size = 252
		refs = "0030 strstr 005d __libc_tsd_CTYPE_B 009b strtoul 00b9 __gettextparse 00cc __gettext_germanic_plural"
	strings:
		$1 = { 48 89 6C 24 E8 4C 89 64 24 F0 48 89 D5 48 89 5C 24 E0 4C 89 6C 24 F8 48 83 EC 48 48 85 FF 49 89 F4 0F 84 A1 00 00 00 48 89 FB BE ?? ?? ?? ?? E8 ?? ?? ?? ?? BE ?? ?? ?? ?? 48 89 DF 49 89 C5 E8 ?? ?? ?? ?? 48 85 C0 74 7F 4D 85 ED 74 7A 0F B6 48 09 48 8D 58 09 84 C9 74 6E 48 8B 05 ?? ?? ?? ?? 64 48 8B 10 EB 14 66 0F 1F 84 00 00 00 00 00 48 83 C3 01 0F B6 0B 84 C9 74 4D 0F B6 C1 F6 44 42 01 20 75 EB 83 E9 30 80 F9 09 77 3B 48 8D 74 24 08 BA 0A 00 00 00 48 89 DF E8 ?? ?? ?? ?? 48 3B 5C 24 08 74 22 48 8D 7C 24 10 49 83 C5 07 48 89 45 00 4C 89 6C 24 10 E8 ?? ?? ?? ?? 85 C0 74 30 0F 1F 80 00 00 00 00 49 C7 04 24 ?? ?? ?? ?? 48 C7 45 00 02 00 00 00 48 8B 5C 24 28 48 8B 6C 24 30 4C 8B 64 24 38 4C 8B 6C 24 40 48 83 C4 48 C3 48 8B 44 24 18 49 89 04 24 EB DC }
	condition:
		$1
}

rule file_389_0_0 {
	meta:
		name = "basename"
		size = 30
		refs = "000a strrchr"
	strings:
		$1 = { 53 BE 2F 00 00 00 48 89 FB E8 ?? ?? ?? ?? 48 8D 50 01 48 85 C0 48 0F 45 DA 48 89 D8 5B C3 }
	condition:
		$1
}

rule file_393_0_0 {
	meta:
		name = "__gai_sigqueue"
		size = 145
		refs = "0038 __getuid 0082 __libc_errno"
	strings:
		$1 = { 48 89 5C 24 E8 48 89 6C 24 F0 31 C0 4C 89 64 24 F8 48 81 EC 98 00 00 00 89 FD 49 89 F4 48 89 E7 B9 10 00 00 00 F3 48 AB 89 54 24 10 89 2C 24 C7 44 24 08 C4 FF FF FF E8 ?? ?? ?? ?? 4C 89 64 24 18 89 44 24 14 48 89 E2 48 63 7C 24 10 48 63 F5 B8 81 00 00 00 0F 05 48 3D 00 F0 FF FF 77 20 48 8B 9C 24 80 00 00 00 48 8B AC 24 88 00 00 00 4C 8B A4 24 90 00 00 00 48 81 C4 98 00 00 00 C3 48 8B 15 ?? ?? ?? ?? F7 D8 64 89 02 48 83 C8 FF EB CE }
	condition:
		$1
}

rule file_395_0_0 {
	meta:
		name = "allocate_dtv"
		size = 84
		refs = "0011 _dl_tls_max_dtv_idx 0026 calloc"
	strings:
		$1 = { 48 89 5C 24 F0 48 89 6C 24 F8 48 83 EC 18 48 8B 15 ?? ?? ?? ?? 48 89 FB BE 10 00 00 00 48 8D 7A 10 48 8D 6A 0E E8 ?? ?? ?? ?? 48 85 C0 74 21 48 8D 50 10 48 89 28 48 89 53 08 48 89 D8 48 8B 6C 24 10 48 8B 5C 24 08 48 83 C4 18 C3 0F 1F 40 00 31 DB EB E6 }
	condition:
		$1
}

rule file_395_1_0 {
	meta:
		name = "_dl_next_tls_modid"
		size = 216
		refs = "0006 _dl_tls_dtv_gaps 0010 _dl_tls_max_dtv_idx 0027 _dl_tls_static_nelem 0035 _dl_tls_dtv_slotinfo_list 0084 __assert_fail"
	strings:
		$1 = { 48 83 EC 08 80 3D ?? ?? ?? ?? 00 75 17 48 8B 15 ?? ?? ?? ?? 48 8D 42 01 48 89 05 ?? ?? ?? ?? 48 83 C4 08 C3 48 8B 05 ?? ?? ?? ?? 48 8B 15 ?? ?? ?? ?? 48 8B 0D ?? ?? ?? ?? 48 83 C0 01 48 39 D0 77 68 48 8B 39 4C 8D 4A 01 31 F6 49 89 C0 49 29 F0 49 39 F8 73 3A 49 83 C0 01 49 C1 E0 04 4A 83 7C 01 08 00 74 3B 48 83 C0 01 4C 39 C8 76 DC B9 ?? ?? ?? ?? BA 4B 00 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 0F 1F 84 00 00 00 00 00 48 8B 49 08 48 01 FE 48 85 C9 74 05 48 8B 39 EB AA 48 39 C2 0F 83 75 FF FF FF 48 8D 4A 01 48 39 C1 75 0C C6 05 ?? ?? ?? ?? 00 E9 55 FF FF FF B9 ?? ?? ?? ?? BA 59 00 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_395_2_0 {
	meta:
		name = "_dl_get_tls_static_info"
		size = 21
		refs = "0003 _dl_tls_static_size 000d _dl_tls_static_align"
	strings:
		$1 = { 48 8B 05 ?? ?? ?? ?? 48 89 07 48 8B 05 ?? ?? ?? ?? 48 89 06 C3 }
	condition:
		$1
}

rule file_395_3_0 {
	meta:
		name = "_dl_allocate_tls_storage"
		size = 313
		refs = "0009 _dl_tls_static_size 0010 _dl_tls_static_align 0018 __libc_memalign 00a1 free"
	strings:
		$1 = { 55 53 48 83 EC 18 48 8B 2D ?? ?? ?? ?? 48 8B 3D ?? ?? ?? ?? 48 89 EE E8 ?? ?? ?? ?? 48 85 C0 0F 84 0D 01 00 00 4C 8D 84 28 00 F7 FF FF 48 89 C3 BE 00 09 00 00 41 F6 C0 01 4C 89 C7 0F 85 A6 00 00 00 40 F6 C7 02 0F 85 B4 00 00 00 40 F6 C7 04 0F 85 CA 00 00 00 89 F1 31 C0 C1 E9 03 40 F6 C6 04 F3 48 AB 75 6A 40 F6 C6 02 75 4C 83 E6 01 75 17 4C 89 C7 E8 27 FE FF FF 48 85 C0 74 1A 48 83 C4 18 5B 5D C3 0F 1F 00 C6 07 00 4C 89 C7 E8 0D FE FF FF 48 85 C0 75 E6 48 89 DF 48 89 44 24 08 E8 ?? ?? ?? ?? 48 8B 44 24 08 48 83 C4 18 5B 5D C3 0F 1F 80 00 00 00 00 66 C7 07 00 00 48 83 C7 02 83 E6 01 74 AB EB C0 0F 1F 84 00 00 00 00 00 C7 07 00 00 00 00 48 83 C7 04 40 F6 C6 02 74 8C EB D6 66 0F 1F 44 00 00 49 8D 78 01 41 C6 00 00 66 BE FF 08 40 F6 C7 02 0F 84 4E FF FF FF 66 90 66 C7 07 00 00 48 83 C7 02 83 EE 02 40 F6 C7 04 0F 84 40 FF FF FF 66 2E 0F 1F 84 00 00 00 00 00 C7 07 00 00 00 00 83 EE 04 48 83 C7 04 E9 24 FF FF FF 31 C0 E9 45 FF FF FF }
	condition:
		$1
}

rule file_395_4_0 {
	meta:
		name = "_dl_allocate_tls_init"
		size = 503
		refs = "0023 _dl_tls_dtv_slotinfo_list 003b _dl_tls_max_dtv_idx 00d3 mempcpy 00e3 memset 0188 __assert_fail"
	strings:
		$1 = { 41 57 41 56 41 55 41 54 55 53 48 83 EC 28 48 85 FF 48 89 7C 24 18 0F 84 7C 01 00 00 48 8B 47 08 48 8B 2D ?? ?? ?? ?? 45 31 ED 48 C7 44 24 08 00 00 00 00 48 89 44 24 10 48 8B 05 ?? ?? ?? ?? 90 31 DB 48 83 7C 24 08 00 0F 94 C3 48 3B 5D 00 0F 83 05 01 00 00 48 8B 54 24 08 48 01 DA 48 39 D0 0F 82 2A 01 00 00 48 8D 43 01 48 C1 E0 04 4C 8D 7C 05 08 E9 92 00 00 00 0F 1F 84 00 00 00 00 00 48 39 99 48 04 00 00 0F 85 1F 01 00 00 4C 8B A1 28 04 00 00 4C 8B B1 20 04 00 00 4D 39 F4 0F 82 21 01 00 00 4C 39 E0 0F 82 31 01 00 00 48 8B 7C 24 18 4C 89 F2 48 29 C7 48 89 D8 48 C1 E0 04 48 03 44 24 10 48 89 38 C6 40 08 01 48 8B B1 18 04 00 00 E8 ?? ?? ?? ?? 4C 89 E2 31 F6 48 89 C7 4C 29 F2 E8 ?? ?? ?? ?? 48 83 C3 01 48 39 5D 00 76 62 48 8B 44 24 08 49 83 C7 10 48 01 D8 48 39 05 ?? ?? ?? ?? 0F 82 86 00 00 00 49 8B 0F 48 85 C9 74 D5 49 8B 47 F8 49 39 C5 4C 0F 42 E8 48 8B 81 40 04 00 00 48 83 F8 01 0F 87 52 FF FF FF 48 8B 81 48 04 00 00 48 83 C3 01 48 C1 E0 04 48 03 44 24 10 48 C7 00 FF FF FF FF C6 40 08 00 48 39 5D 00 77 9E 48 8B 05 ?? ?? ?? ?? 48 01 5C 24 08 48 39 44 24 08 73 2A 48 8B 6D 08 48 85 ED 0F 85 CD FE FF FF B9 ?? ?? ?? ?? BA BE 01 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 0F 1F 40 00 48 8B 44 24 10 4C 89 28 48 8B 44 24 18 48 83 C4 28 5B 5D 41 5C 41 5D 41 5E 41 5F C3 B9 ?? ?? ?? ?? BA A6 01 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? B9 ?? ?? ?? ?? BA A7 01 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? B9 ?? ?? ?? ?? BA A9 01 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_395_5_0 {
	meta:
		name = "_dl_allocate_tls"
		size = 49
		refs = "0021 _dl_allocate_tls_storage 0016 _dl_allocate_tls_init"
	strings:
		$1 = { 48 83 EC 08 48 85 FF 74 17 E8 52 FB FF FF 48 83 C4 08 48 89 C7 E9 ?? ?? ?? ?? 66 0F 1F 44 00 00 E8 ?? ?? ?? ?? 48 83 C4 08 48 89 C7 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_395_6_0 {
	meta:
		name = "_dl_deallocate_tls"
		size = 123
		refs = "0035 free 0063 _dl_tls_static_size"
	strings:
		$1 = { 41 56 41 89 F6 41 55 49 89 FD 41 54 55 31 ED 53 4C 8B 67 08 49 8B 44 24 F0 4C 89 E3 EB 24 66 90 48 83 C5 01 80 7B 18 00 75 14 48 8B 7B 10 48 83 FF FF 74 0A E8 ?? ?? ?? ?? 49 8B 44 24 F0 48 83 C3 10 48 39 C5 72 D9 49 8D 7C 24 F0 E8 ?? ?? ?? ?? 45 84 F6 75 0A 5B 5D 41 5C 41 5D 41 5E C3 90 4C 2B 2D ?? ?? ?? ?? 5B 5D 41 5C 49 8D BD 00 09 00 00 41 5D 41 5E E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_395_7_0 {
	meta:
		name = "_dl_tls_get_addr_soft"
		size = 108
		refs = "001b _dl_tls_generation 003d _dl_tls_dtv_slotinfo_list"
	strings:
		$1 = { 48 8B 87 48 04 00 00 48 85 C0 74 5D 64 48 8B 14 25 08 00 00 00 48 8B 0A 48 3B 0D ?? ?? ?? ?? 75 13 48 C1 E0 04 48 8B 04 02 31 D2 48 83 F8 FF 48 0F 44 C2 C3 48 3B 42 F0 73 2F 48 8B 35 ?? ?? ?? ?? 48 89 C7 4C 8B 06 4C 39 C0 72 0F 48 8B 76 08 4C 29 C7 4C 8B 06 49 39 F8 76 F1 48 83 C7 01 48 C1 E7 04 48 3B 0C 3E 73 B8 31 C0 C3 }
	condition:
		$1
}

rule file_395_8_0 {
	meta:
		name = "_dl_add_to_slotinfo"
		size = 206
		refs = "0009 _dl_tls_dtv_slotinfo_list 0043 malloc 007a _dl_tls_generation 00b1 _dl_signal_error 00ca __assert_fail"
	strings:
		$1 = { 41 54 49 89 FC 55 48 8B 2D ?? ?? ?? ?? 53 48 8B 9F 48 04 00 00 EB 0C 66 0F 1F 84 00 00 00 00 00 48 89 C5 48 8B 45 00 48 39 C3 72 4B 48 29 C3 48 8B 45 08 48 85 C0 75 E8 48 85 DB 75 78 BF F0 03 00 00 E8 ?? ?? ?? ?? 48 85 C0 48 89 C2 48 89 45 08 74 46 48 8D 70 10 48 C7 00 3E 00 00 00 48 C7 40 08 00 00 00 00 B9 7C 00 00 00 48 89 D8 48 89 D5 48 89 F7 F3 48 AB 48 8B 05 ?? ?? ?? ?? 48 83 C3 01 48 C1 E3 04 48 01 EB 48 83 C0 01 4C 89 63 08 48 89 03 5B 5D 41 5C C3 B9 ?? ?? ?? ?? BE ?? ?? ?? ?? BF 0C 00 00 00 48 83 05 ?? ?? ?? ?? 01 E8 ?? ?? ?? ?? B9 ?? ?? ?? ?? BA 57 03 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_398_0_0 {
	meta:
		name = "epoll_ctl"
		size = 23
		refs = "0012 __syscall_error"
	strings:
		$1 = { 49 89 CA B8 E9 00 00 00 0F 05 48 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_399_0_0 {
	meta:
		name = "_nl_init_era_entries.part.0"
		size = 511
		refs = "0003 __pthread_rwlock_wrlock 0016 __libc_setlocale_lock 0047 free 005c __pthread_rwlock_unlock 0096 realloc 00e8 __rawmemchr 0119 wcschr 01a6 malloc 01cf _nl_cleanup_time"
	strings:
		$1 = { 41 56 B8 ?? ?? ?? ?? 48 85 C0 41 55 41 54 55 48 89 FD 53 74 07 BF ?? ?? ?? ?? FF D0 4C 8B 6D 28 4D 85 ED 0F 84 77 01 00 00 41 8B 45 10 85 C0 75 2A 44 8B B5 D0 01 00 00 4D 85 F6 75 43 49 8B 7D 00 48 85 FF 74 0D E8 ?? ?? ?? ?? 49 C7 45 00 00 00 00 00 41 C7 45 10 01 00 00 00 B8 ?? ?? ?? ?? 48 85 C0 0F 84 8D 01 00 00 5B 5D 41 5C 41 5D 41 5E BF ?? ?? ?? ?? FF E0 0F 1F 84 00 00 00 00 00 4D 3B 75 08 49 8B 45 00 74 10 4B 8D 34 F6 48 89 C7 48 C1 E6 03 E8 ?? ?? ?? ?? 48 85 C0 0F 84 35 01 00 00 48 8B AD D8 01 00 00 48 89 C3 4D 89 75 08 49 89 45 00 45 31 E4 EB 7F 66 0F 1F 44 00 00 0F 84 BA 00 00 00 31 C0 83 3B 2B 0F 95 C0 8D 44 00 FF 89 43 40 48 8D 7D 20 31 F6 49 83 C4 01 48 83 C3 48 48 89 7B D8 E8 ?? ?? ?? ?? 48 8D 78 01 31 F6 48 89 7B E0 E8 ?? ?? ?? ?? 48 8D 78 01 31 F6 48 89 FA 48 29 EA 48 83 C2 03 48 F7 D2 83 E2 03 48 01 D7 48 89 7B E8 E8 ?? ?? ?? ?? 48 8D 78 04 31 F6 48 89 7B F0 E8 ?? ?? ?? ?? 4D 39 E6 48 8D 68 04 0F 86 1A FF FF FF 48 8B 45 00 48 89 03 48 8B 45 08 48 89 43 08 48 8B 45 10 48 89 43 10 48 8B 45 18 48 89 43 18 8B 43 14 39 43 08 0F 8D 5C FF FF FF 31 C0 83 3B 2B 0F 94 C0 8D 44 00 FF 89 43 40 E9 5D FF FF FF 0F 1F 84 00 00 00 00 00 8B 43 18 39 43 0C 7C DC 0F 85 38 FF FF FF 8B 43 1C 39 43 10 0F 8F 2C FF FF FF EB C8 0F 1F 40 00 BF 30 00 00 00 E8 ?? ?? ?? ?? 48 85 C0 48 89 C2 48 89 45 28 0F 84 A1 FE FF FF 48 89 C7 B9 06 00 00 00 4C 89 E8 F3 48 AB 49 89 D5 48 C7 45 20 ?? ?? ?? ?? E9 51 FE FF FF 49 8B 7D 00 E8 ?? ?? ?? ?? 49 C7 45 08 00 00 00 00 49 C7 45 00 00 00 00 00 E9 5D FE FF FF 5B 5D 41 5C 41 5D 41 5E C3 }
	condition:
		$1
}

rule file_399_1_0 {
	meta:
		name = "_nl_get_era_entry"
		size = 345
	strings:
		$1 = { 53 48 89 FB 48 83 EC 10 48 8B 46 28 48 85 C0 0F 84 9B 00 00 00 8B 48 10 85 C9 0F 84 90 00 00 00 4C 8B 40 08 8B 4B 14 44 8B 4B 10 44 8B 5B 0C 4D 85 C0 0F 84 A8 00 00 00 48 8B 10 31 F6 EB 24 90 0F 84 CA 00 00 00 3B 4A 14 7F 35 0F 1F 44 00 00 0F 84 E2 00 00 00 48 83 C6 01 48 83 C2 48 4C 39 C6 74 7D 8B 7A 08 48 89 D0 39 F9 7E D3 3B 4A 14 7C 2E 74 7C 7E E0 66 2E 0F 1F 84 00 00 00 00 00 39 F9 7C 1C 75 D0 44 3B 4A 0C 7C 14 0F 1F 40 00 75 C4 44 3B 5A 10 7F BE 0F 1F 84 00 00 00 00 00 48 83 C4 10 5B C3 66 2E 0F 1F 84 00 00 00 00 00 8B 96 D0 01 00 00 85 D2 74 16 48 89 F7 48 89 74 24 08 E8 39 FD FF FF 48 8B 74 24 08 48 8B 46 28 48 85 C0 0F 85 47 FF FF FF 0F 1F 80 00 00 00 00 48 83 C4 10 31 C0 5B C3 0F 1F 84 00 00 00 00 00 44 8B 52 18 45 39 D1 7C A7 74 45 45 39 D1 7F 80 0F 85 50 FF FF FF EB 42 0F 1F 84 00 00 00 00 00 44 3B 4A 0C 0F 8F 53 FF FF FF 66 0F 1F 44 00 00 0F 85 20 FF FF FF 44 3B 5A 10 0F 8C 16 FF FF FF E9 38 FF FF FF 0F 1F 00 44 8B 52 18 EB BD 66 90 44 3B 5A 1C 0F 8E 56 FF FF FF 44 3B 5A 1C 0F 8C 02 FF FF FF E9 27 FF FF FF }
	condition:
		$1
}

rule file_399_2_0 {
	meta:
		name = "_nl_select_era_entry"
		size = 89
	strings:
		$1 = { 53 89 FB 48 83 EC 10 48 8B 46 28 48 85 C0 74 20 44 8B 40 10 45 85 C0 74 17 48 63 FB 48 8B 00 48 8D 14 FF 48 8D 04 D0 48 83 C4 10 5B C3 0F 1F 00 8B BE D0 01 00 00 85 FF 74 16 48 89 F7 48 89 74 24 08 E8 59 FC FF FF 48 8B 74 24 08 48 8B 46 28 48 85 C0 75 C4 31 C0 EB CE }
	condition:
		$1
}

rule file_400_0_0 {
	meta:
		name = "at_quick_exit"
		size = 29
		refs = "0001 __dso_handle 0012 __cxa_at_quick_exit"
	strings:
		$1 = { B8 ?? ?? ?? ?? 48 85 C0 74 0C 48 8B 35 ?? ?? ?? ?? E9 ?? ?? ?? ?? BE ?? ?? ?? ?? EB F4 }
	condition:
		$1
}

rule file_401_0_0 {
	meta:
		name = "drand48"
		size = 33
		refs = "0005 __libc_drand48_data 0012 __erand48_r"
	strings:
		$1 = { 48 83 EC 18 BE ?? ?? ?? ?? 48 8D 54 24 08 48 89 F7 E8 ?? ?? ?? ?? F2 0F 10 44 24 08 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_402_0_0 {
	meta:
		name = "lock_and_info"
		size = 87
		refs = "000e _dl_addr 0024 __libc_multiple_threads"
	strings:
		$1 = { 48 85 FF 74 4B 53 31 C9 31 D2 48 89 F3 E8 ?? ?? ?? ?? 45 31 C0 85 C0 BE 01 00 00 00 4C 0F 45 C3 31 C0 83 3D ?? ?? ?? ?? 00 74 10 F0 0F B1 35 ?? ?? ?? ?? 0F 85 20 08 00 00 EB 0D 0F B1 35 ?? ?? ?? ?? 0F 85 11 08 00 00 4C 89 C0 5B C3 0F 1F 00 45 31 C0 4C 89 C0 C3 }
	condition:
		$1
}

rule file_402_1_0 {
	meta:
		name = "_L_lock_39"
		size = 31
		refs = "000f __lll_lock_wait_private"
	strings:
		$1 = { 48 8D 3D ?? ?? ?? ?? 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 D0 F7 FF FF }
	condition:
		$1
}

rule file_402_2_0 {
	meta:
		name = "tr_where"
		size = 280
		refs = "0040 strlen 007c mempcpy 00a8 _fitoa_word 00d3 fprintf"
	strings:
		$1 = { 48 85 FF 0F 84 DF 00 00 00 55 48 89 E5 48 89 5D E0 4C 89 65 E8 4C 89 6D F0 4C 89 75 F8 48 83 EC 20 48 85 F6 0F 84 D6 00 00 00 49 89 FC 48 8B 7E 10 48 89 F3 41 BD ?? ?? ?? ?? 48 85 FF 74 72 E8 ?? ?? ?? ?? 48 8D 48 34 BA ?? ?? ?? ?? 41 BE ?? ?? ?? ?? 48 83 E1 F0 48 29 CC 4C 8D 6C 24 0F 49 83 E5 F0 41 C6 45 00 28 4C 3B 63 18 49 8D 7D 01 48 8B 73 10 4C 0F 42 F2 48 89 C2 E8 ?? ?? ?? ?? 41 8B 16 48 8D 70 03 4C 89 E7 89 10 48 8B 53 18 48 89 D0 48 29 D7 4C 29 E0 49 39 D4 BA 10 00 00 00 48 0F 42 F8 31 C9 E8 ?? ?? ?? ?? 66 C7 00 29 00 48 8B 13 B9 ?? ?? ?? ?? 48 85 D2 74 32 48 8B 3D ?? ?? ?? ?? 4D 89 E1 4D 89 E8 BE ?? ?? ?? ?? 31 C0 E8 ?? ?? ?? ?? 48 8B 5D E0 4C 8B 65 E8 4C 8B 6D F0 4C 8B 75 F8 C9 F3 C3 66 0F 1F 44 00 00 B9 ?? ?? ?? ?? 48 89 CA EB C4 66 0F 1F 44 00 00 48 89 FA 48 8B 3D ?? ?? ?? ?? BE ?? ?? ?? ?? 31 C0 E8 ?? ?? ?? ?? EB BF }
	condition:
		$1
}

rule file_402_3_0 {
	meta:
		name = "tr_memalignhook"
		size = 243
		refs = "0043 __memalign_hook 004a __malloc_hook 0099 fprintf 009f __libc_multiple_threads 00e7 memalign"
	strings:
		$1 = { 48 89 5C 24 E0 48 89 6C 24 E8 48 89 FD 4C 89 64 24 F0 4C 89 6C 24 F8 48 83 EC 48 49 89 F4 48 89 D7 48 89 E6 48 89 D3 E8 54 FE FF FF 4C 8B 05 ?? ?? ?? ?? 49 89 C5 48 8B 05 ?? ?? ?? ?? 4D 85 C0 4C 89 05 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 0F 84 8C 00 00 00 48 89 EF 48 89 DA 4C 89 E6 41 FF D0 48 89 C5 4C 89 EE 48 89 DF 48 C7 05 ?? ?? ?? ?? ?? ?? ?? ?? 48 C7 05 ?? ?? ?? ?? ?? ?? ?? ?? E8 5C FE FF FF 48 8B 3D ?? ?? ?? ?? 4C 89 E1 48 89 EA BE ?? ?? ?? ?? 31 C0 E8 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 74 0F F0 FF 0D ?? ?? ?? ?? 0F 85 45 06 00 00 EB 0C FF 0D ?? ?? ?? ?? 0F 85 37 06 00 00 48 89 E8 48 8B 5C 24 28 48 8B 6C 24 30 4C 8B 64 24 38 4C 8B 6C 24 40 48 83 C4 48 C3 0F 1F 00 48 89 EF 4C 89 E6 E8 ?? ?? ?? ?? 48 89 C5 E9 70 FF FF FF }
	condition:
		$1
}

rule file_402_4_0 {
	meta:
		name = "tr_mallochook"
		size = 208
		refs = "0039 __malloc_hook 0079 fprintf 007f __libc_multiple_threads 00c4 malloc"
	strings:
		$1 = { 48 89 5C 24 E0 4C 89 64 24 F0 48 89 F3 4C 89 6C 24 F8 48 89 6C 24 E8 48 83 EC 48 49 89 FC 48 89 E6 48 89 DF E8 57 FD FF FF 48 8B 15 ?? ?? ?? ?? 49 89 C5 48 85 D2 48 89 15 ?? ?? ?? ?? 0F 84 7D 00 00 00 48 89 DE 4C 89 E7 FF D2 48 89 C5 4C 89 EE 48 89 DF 48 C7 05 ?? ?? ?? ?? ?? ?? ?? ?? E8 7C FD FF FF 48 8B 3D ?? ?? ?? ?? 4C 89 E1 48 89 EA BE ?? ?? ?? ?? 31 C0 E8 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 74 0F F0 FF 0D ?? ?? ?? ?? 0F 85 84 05 00 00 EB 0C FF 0D ?? ?? ?? ?? 0F 85 76 05 00 00 48 89 E8 48 8B 5C 24 28 48 8B 6C 24 30 4C 8B 64 24 38 4C 8B 6C 24 40 48 83 C4 48 C3 0F 1F 00 4C 89 E7 E8 ?? ?? ?? ?? 48 89 C5 E9 7E FF FF FF }
	condition:
		$1
}

rule file_402_5_0 {
	meta:
		name = "_L_unlock_283"
		size = 31
		refs = "000f __lll_unlock_wake_private"
	strings:
		$1 = { 48 8D 3D ?? ?? ?? ?? 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 AA F9 FF FF }
	condition:
		$1
}

rule file_402_6_0 {
	meta:
		name = "_L_unlock_386"
		size = 31
		refs = "000f __lll_unlock_wake_private"
	strings:
		$1 = { 48 8D 3D ?? ?? ?? ?? 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 6B FA FF FF }
	condition:
		$1
}

rule file_402_7_0 {
	meta:
		name = "tr_reallochook"
		size = 398
		refs = "0045 __free_hook 0056 __realloc_hook 005d __malloc_hook 00c6 fprintf 00f0 __libc_multiple_threads 013f realloc"
	strings:
		$1 = { 48 89 5C 24 D8 4C 89 64 24 E8 49 89 FC 4C 89 6C 24 F0 4C 89 74 24 F8 49 89 F5 48 89 6C 24 E0 48 83 EC 48 48 89 D7 48 89 E6 48 89 D3 E8 7F FC FF FF 49 89 C6 48 8B 05 ?? ?? ?? ?? 4C 8B 05 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? 4D 85 C0 4C 89 05 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 0F 84 D1 00 00 00 48 89 DA 4C 89 EE 4C 89 E7 41 FF D0 48 89 C5 4C 89 F6 48 89 DF 48 C7 05 ?? ?? ?? ?? ?? ?? ?? ?? 48 C7 05 ?? ?? ?? ?? ?? ?? ?? ?? 48 C7 05 ?? ?? ?? ?? ?? ?? ?? ?? E8 6E FC FF FF 48 85 ED 0F 84 C5 00 00 00 4D 85 E4 0F 84 9C 00 00 00 48 8B 3D ?? ?? ?? ?? 4C 89 E2 BE ?? ?? ?? ?? 31 C0 E8 ?? ?? ?? ?? 4C 89 F6 48 89 DF E8 3B FC FF FF 48 8B 3D ?? ?? ?? ?? 4C 89 E9 48 89 EA BE ?? ?? ?? ?? 31 C0 E8 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 74 0F F0 FF 0D ?? ?? ?? ?? 0F 85 62 04 00 00 EB 0C FF 0D ?? ?? ?? ?? 0F 85 54 04 00 00 48 89 E8 48 8B 5C 24 20 48 8B 6C 24 28 4C 8B 64 24 30 4C 8B 6C 24 38 4C 8B 74 24 40 48 83 C4 48 C3 0F 1F 44 00 00 4C 89 EE 4C 89 E7 E8 ?? ?? ?? ?? 48 89 C5 E9 2B FF FF FF 0F 1F 44 00 00 48 8B 3D ?? ?? ?? ?? 4C 89 E9 48 89 EA BE ?? ?? ?? ?? 31 C0 E8 ?? ?? ?? ?? EB 83 0F 1F 44 00 00 48 8B 3D ?? ?? ?? ?? 4C 89 E9 4C 89 E2 BE ?? ?? ?? ?? 31 C0 E8 ?? ?? ?? ?? E9 60 FF FF FF }
	condition:
		$1
}

rule file_402_8_0 {
	meta:
		name = "tr_freehook"
		size = 269
		refs = "003d fprintf 0044 mallwatch 0057 __free_hook 0076 __libc_multiple_threads 0104 free"
	strings:
		$1 = { 48 85 FF 0F 84 95 00 00 00 55 48 89 F5 53 48 89 FB 48 89 EF 48 83 EC 28 48 89 E6 E8 00 FB FF FF 48 89 EF 48 89 C6 E8 55 FB FF FF 48 8B 3D ?? ?? ?? ?? 31 C0 48 89 DA BE ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 3B 1D ?? ?? ?? ?? 74 56 48 8B 05 ?? ?? ?? ?? 48 85 C0 48 89 05 ?? ?? ?? ?? 0F 84 9F 00 00 00 48 89 EE 48 89 DF FF D0 48 C7 05 ?? ?? ?? ?? ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 74 0F F0 FF 0D ?? ?? ?? ?? 0F 85 6B 03 00 00 EB 0C FF 0D ?? ?? ?? ?? 0F 85 5D 03 00 00 48 83 C4 28 5B 5D F3 C3 83 3D ?? ?? ?? ?? 00 74 0F F0 FF 0D ?? ?? ?? ?? 0F 85 5E 03 00 00 EB 0C FF 0D ?? ?? ?? ?? 0F 85 50 03 00 00 BE 01 00 00 00 31 C0 83 3D ?? ?? ?? ?? 00 74 10 F0 0F B1 35 ?? ?? ?? ?? 0F 85 51 03 00 00 EB 0D 0F B1 35 ?? ?? ?? ?? 0F 85 42 03 00 00 E9 54 FF FF FF 66 2E 0F 1F 84 00 00 00 00 00 48 89 DF E8 ?? ?? ?? ?? E9 5C FF FF FF }
	condition:
		$1
}

rule file_402_9_0 {
	meta:
		name = "_L_unlock_520"
		size = 31
		refs = "000f __lll_unlock_wake_private"
	strings:
		$1 = { 48 8D 3D ?? ?? ?? ?? 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 8D FB FF FF }
	condition:
		$1
}

rule file_402_10_0 {
	meta:
		name = "_L_unlock_647"
		size = 31
		refs = "000f __lll_unlock_wake_private"
	strings:
		$1 = { 48 8D 3D ?? ?? ?? ?? 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 84 FC FF FF }
	condition:
		$1
}

rule file_1140_1_0 {
	meta:
		name = "_L_lock_81"
		size = 31
		refs = "0003 __libc_utmp_lock 000f __lll_lock_wait_private"
	strings:
		$1 = { 48 8D 3D ?? ?? ?? ?? 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 84 FC FF FF }
	condition:
		$1
}

rule file_402_11_0 {
	meta:
		name = "_L_unlock_676"
		size = 31
		refs = "000f __lll_unlock_wake_private"
	strings:
		$1 = { 48 8D 3D ?? ?? ?? ?? 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 91 FC FF FF }
	condition:
		$1
}

rule file_402_12_0 {
	meta:
		name = "_L_lock_681"
		size = 31
		refs = "000f __lll_lock_wait_private"
	strings:
		$1 = { 48 8D 3D ?? ?? ?? ?? 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 9F FC FF FF }
	condition:
		$1
}

rule file_1005_7_0 {
	meta:
		name = "_L_unlock_697"
		size = 31
		refs = "000f __lll_unlock_wake_private"
	strings:
		$1 = { 48 8D 3D ?? ?? ?? ?? 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 9F FC FF FF }
	condition:
		$1
}

rule file_402_14_0 {
	meta:
		name = "mtrace"
		size = 477
		refs = "0024 __secure_getenv 003a malloc 0053 _IO_new_fopen 006b fileno 007b __fcntl 00bd _IO_setvbuf 00d8 fwrite 00df __free_hook 00f8 __malloc_hook 0111 __realloc_hook 012a __memalign_hook 014b __dso_handle 0193 mallwatch 017b __cxa_atexit 01d2 free"
	strings:
		$1 = { 48 83 3D ?? ?? ?? ?? 00 74 06 C3 0F 1F 44 00 00 48 89 5C 24 F0 48 89 6C 24 F8 BF ?? ?? ?? ?? 48 83 EC 18 E8 ?? ?? ?? ?? 48 85 C0 48 89 C3 0F 84 5C 01 00 00 BF 00 02 00 00 E8 ?? ?? ?? ?? 48 85 C0 48 89 C5 0F 84 36 01 00 00 BE ?? ?? ?? ?? 48 89 DF E8 ?? ?? ?? ?? 48 85 C0 48 89 05 ?? ?? ?? ?? 0F 84 59 01 00 00 48 89 C7 E8 ?? ?? ?? ?? 31 D2 89 C7 BE 01 00 00 00 31 C0 E8 ?? ?? ?? ?? 85 C0 89 C3 78 1F 48 8B 3D ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 DA 89 C7 BE 02 00 00 00 83 CA 01 31 C0 E8 ?? ?? ?? ?? 48 8B 3D ?? ?? ?? ?? 31 D2 B9 00 02 00 00 48 89 EE 48 89 2D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 0D ?? ?? ?? ?? BA 08 00 00 00 BE 01 00 00 00 BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? 48 C7 05 ?? ?? ?? ?? ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? 48 C7 05 ?? ?? ?? ?? ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? 48 C7 05 ?? ?? ?? ?? ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? 48 C7 05 ?? ?? ?? ?? ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 8B 05 ?? ?? ?? ?? 85 C0 75 36 B8 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 01 00 00 00 48 85 C0 74 78 48 8B 15 ?? ?? ?? ?? 48 8B 5C 24 08 48 8B 6C 24 10 31 F6 BF ?? ?? ?? ?? 48 83 C4 18 E9 ?? ?? ?? ?? 90 48 8B 5C 24 08 48 8B 6C 24 10 48 83 C4 18 C3 90 48 83 3D ?? ?? ?? ?? 00 74 E6 BF 00 02 00 00 E8 ?? ?? ?? ?? 48 85 C0 48 89 C5 74 D4 BB ?? ?? ?? ?? E9 94 FE FF FF 66 2E 0F 1F 84 00 00 00 00 00 48 89 EF 48 8B 5C 24 08 48 8B 6C 24 10 48 83 C4 18 E9 ?? ?? ?? ?? BA ?? ?? ?? ?? EB 88 }
	condition:
		$1
}

rule file_402_15_0 {
	meta:
		name = "muntrace"
		size = 121
		refs = "0020 fwrite 002c _IO_new_fclose 0045 __free_hook 0053 __malloc_hook 0061 __realloc_hook 006f __memalign_hook"
	strings:
		$1 = { 48 8B 0D ?? ?? ?? ?? 48 85 C9 74 6B 48 83 EC 08 BA 06 00 00 00 BE 01 00 00 00 BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 3D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? 48 C7 05 ?? ?? ?? ?? 00 00 00 00 48 89 05 ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 48 83 C4 08 F3 C3 }
	condition:
		$1
}

rule file_403_0_0 {
	meta:
		name = "bsearch"
		size = 121
	strings:
		$1 = { 41 57 45 31 FF 41 56 49 89 D6 41 55 49 89 CD 41 54 4D 89 C4 55 53 48 83 EC 18 48 85 D2 48 89 3C 24 48 89 74 24 08 75 13 EB 3B 66 0F 1F 44 00 00 74 35 4C 8D 7B 01 4D 39 F7 73 2A 4B 8D 1C 3E 48 8B 3C 24 48 D1 EB 48 89 DD 49 0F AF ED 48 03 6C 24 08 48 89 EE 41 FF D4 83 F8 00 7D D3 49 89 DE 4D 39 F7 72 D6 31 ED 48 83 C4 18 48 89 E8 5B 5D 41 5C 41 5D 41 5E 41 5F C3 }
	condition:
		$1
}

rule file_404_0_0 {
	meta:
		name = "_dl_resolve_conflicts"
		size = 365
		refs = "0004 _dl_debug_mask 004a _dl_num_cache_relocations 007e _dl_reloc_bad_type 0100 _dl_argv 0116 _dl_dprintf 0145 __assert_fail 0164 _dl_debug_printf"
	strings:
		$1 = { 41 56 F6 05 ?? ?? ?? ?? 20 41 55 49 89 FD 41 54 49 89 D4 55 53 48 89 F3 0F 85 2B 01 00 00 49 83 7D 30 00 0F 85 07 01 00 00 4C 89 E0 48 BA AB AA AA AA AA AA AA AA 41 BE FF FF FF FF 48 29 D8 48 C1 F8 03 48 0F AF C2 48 01 05 ?? ?? ?? ?? 49 39 DC 76 4C 8B 73 08 48 8B 2B 48 83 FE 08 0F 84 BC 00 00 00 48 83 FE 26 0F 84 B2 00 00 00 48 85 F6 74 24 48 83 FE 25 76 38 31 D2 4C 89 EF E8 ?? ?? ?? ?? 66 0F 1F 44 00 00 48 8B 43 10 49 03 45 00 FF D0 48 89 45 00 48 83 C3 18 49 39 DC 77 B4 5B 5D 41 5C 41 5D 41 5E C3 0F 1F 84 00 00 00 00 00 FF 24 F5 ?? ?? ?? ?? 66 0F 1F 84 00 00 00 00 00 48 8B 43 10 48 83 C3 18 49 39 DC 48 89 45 00 77 82 EB CC 0F 1F 44 00 00 48 8B 43 10 4C 39 F0 89 45 00 76 B2 49 8B 45 68 8B 0C 25 00 00 00 00 BE ?? ?? ?? ?? BF 02 00 00 00 48 03 48 08 48 8B 05 ?? ?? ?? ?? 48 8B 10 B8 ?? ?? ?? ?? 48 85 D2 48 0F 44 D0 31 C0 E8 ?? ?? ?? ?? E9 77 FF FF FF 48 8B 43 10 49 03 45 00 48 89 45 00 E9 66 FF FF FF B9 ?? ?? ?? ?? BA 38 00 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 77 08 80 3E 00 75 0A 48 8B 05 ?? ?? ?? ?? 48 8B 30 BF ?? ?? ?? ?? 31 C0 E8 ?? ?? ?? ?? E9 B1 FE FF FF }
	condition:
		$1
}

rule file_405_1_0 {
	meta:
		name = "cfgetispeed"
		size = 19
	strings:
		$1 = { 8B 07 85 C0 78 0A 8B 47 08 25 0F 10 00 00 C3 90 31 C0 C3 }
	condition:
		$1
}

rule file_405_2_0 {
	meta:
		name = "cfsetospeed"
		size = 68
		refs = "0033 __libc_errno"
	strings:
		$1 = { F7 C6 F0 EF FF FF 74 0B 8D 86 FF EF FF FF 83 F8 0E 77 1D 8B 47 08 89 77 38 25 F0 EF FF FF 09 F0 89 47 08 31 C0 C3 66 2E 0F 1F 84 00 00 00 00 00 48 8B 05 ?? ?? ?? ?? 64 C7 00 16 00 00 00 B8 FF FF FF FF C3 }
	condition:
		$1
}

rule file_405_3_0 {
	meta:
		name = "cfsetispeed"
		size = 84
		refs = "0043 __libc_errno"
	strings:
		$1 = { F7 C6 F0 EF FF FF 74 28 8D 86 FF EF FF FF 83 F8 0E 77 2D 89 77 34 8B 47 08 81 27 FF FF FF 7F 25 F0 EF FF FF 09 F0 89 47 08 31 C0 C3 0F 1F 40 00 85 F6 89 77 34 75 DF 81 0F 00 00 00 80 31 C0 C3 48 8B 05 ?? ?? ?? ?? 64 C7 00 16 00 00 00 B8 FF FF FF FF C3 }
	condition:
		$1
}

rule file_407_0_0 {
	meta:
		name = "name_to_handle_at"
		size = 23
		refs = "0012 __syscall_error"
	strings:
		$1 = { 49 89 CA B8 2F 01 00 00 0F 05 48 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_408_0_0 {
	meta:
		name = "__read_chk"
		size = 45
		refs = "0019 __libc_errno 0029 __chk_fail"
	strings:
		$1 = { 48 39 CA 77 22 48 63 FF 31 C0 0F 05 48 3D 00 F0 FF FF 77 02 F3 C3 48 8B 15 ?? ?? ?? ?? F7 D8 64 89 02 48 83 C8 FF C3 50 E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_410_0_0 {
	meta:
		name = "nscd_getserv_r"
		size = 2198
		refs = "0005 __serv_map_handle 0048 __nscd_get_map_ref 0063 strlen 00f5 mempcpy 010e memcpy 0170 __nscd_cache_search 022f __nscd_open_socket 0274 __libc_errno 02c1 __nscd_unmap 02e5 free 05cf __readvall 0622 __nss_not_use_nscd_services 0665 __readall 0730 __libc_alloca_cutoff 0752 malloc 0888 __assert_fail"
	strings:
		$1 = { 55 49 89 D2 BA ?? ?? ?? ?? 48 89 E5 41 57 4D 89 C7 41 56 41 55 49 89 FD BF 12 00 00 00 41 54 49 89 F4 BE ?? ?? ?? ?? 53 48 81 EC C8 00 00 00 89 8D 78 FF FF FF 48 8D 4D 8C 4C 89 95 10 FF FF FF 4C 89 8D 60 FF FF FF E8 ?? ?? ?? ?? 4C 8B 95 10 FF FF FF 48 89 C3 4D 85 D2 0F 84 D9 05 00 00 4C 89 D7 E8 ?? ?? ?? ?? 4C 8B 95 10 FF FF FF 49 89 C6 4B 8D 44 26 02 48 3D 00 10 00 00 48 89 85 70 FF FF FF 0F 87 9C 06 00 00 48 89 E2 48 89 95 48 FF FF FF 48 8B 95 70 FF FF FF 48 8B 85 48 FF FF FF 48 83 C2 1E 48 83 E2 F0 48 29 D4 48 8D 54 24 0F 48 83 E2 F0 48 29 E0 48 89 85 48 FF FF FF 48 89 95 68 FF FF FF C7 85 3C FF FF FF 01 00 00 00 48 8B BD 68 FF FF FF 49 83 C6 01 B8 ?? ?? ?? ?? 4D 85 D2 4C 89 E2 4C 89 EE 4C 0F 44 D0 4C 89 95 10 FF FF FF E8 ?? ?? ?? ?? C6 00 2F 4C 8B 95 10 FF FF FF 48 8D 78 01 4C 89 F2 4C 89 D6 E8 ?? ?? ?? ?? 48 8B 95 60 FF FF FF 48 8B 85 60 FF FF FF C7 85 7C FF FF FF 00 00 00 00 48 F7 DA 83 E2 07 48 01 D0 48 89 95 58 FF FF FF 48 89 85 40 FF FF FF 0F 1F 80 00 00 00 00 48 83 FB FF 0F 84 BE 00 00 00 48 8B 95 70 FF FF FF 48 8B B5 68 FF FF FF 41 B8 18 00 00 00 8B BD 78 FF FF FF 48 89 D9 E8 ?? ?? ?? ?? 48 85 C0 0F 84 93 00 00 00 4C 8B 60 20 48 8D 70 30 48 8B 50 18 8B 7D 8C 4C 63 48 04 49 63 CC 4C 89 65 98 49 C1 FC 20 48 01 F1 48 89 55 90 48 8B 50 28 49 01 CC 48 8B 0B 48 89 55 A0 4C 63 D2 BA FE FF FF FF 44 8B 41 08 41 39 F8 0F 84 5B 01 00 00 41 BA 01 00 00 00 8B 41 08 39 F8 0F 85 BB 04 00 00 F0 83 6B 18 01 0F 84 CF 00 00 00 45 85 D2 0F 84 F1 00 00 00 66 0F 1F 44 00 00 8B 85 3C FF FF FF 85 C0 0F 84 FF 00 00 00 48 8D 65 D8 89 D0 5B 41 5C 41 5D 41 5E 41 5F 5D C3 90 8B 95 78 FF FF FF 48 8B B5 70 FF FF FF 48 8D 4D 90 48 8B BD 68 FF FF FF 41 B8 18 00 00 00 E8 ?? ?? ?? ?? 83 F8 FF 41 89 C6 0F 84 E1 03 00 00 49 C7 C1 FF FF FF FF 45 31 C0 45 31 E4 45 31 D2 31 F6 48 8B 55 18 48 C7 02 00 00 00 00 8B 55 94 83 FA FF 0F 84 A4 04 00 00 83 FA 01 0F 84 D7 00 00 00 48 8B 05 ?? ?? ?? ?? 31 D2 64 C7 00 00 00 00 00 41 83 FE FF 74 0A 49 63 FE B8 03 00 00 00 0F 05 48 83 FB FF 0F 84 46 FF FF FF 48 8B 0B 8B 7D 8C E9 25 FF FF FF 66 2E 0F 1F 84 00 00 00 00 00 48 89 DF 89 95 30 FF FF FF 44 89 95 10 FF FF FF E8 ?? ?? ?? ?? 44 8B 95 10 FF FF FF 8B 95 30 FF FF FF 45 85 D2 0F 85 15 FF FF FF 4C 89 E7 89 95 30 FF FF FF E8 ?? ?? ?? ?? 8B 85 3C FF FF FF 8B 95 30 FF FF FF 85 C0 0F 85 01 FF FF FF 48 8B BD 68 FF FF FF 89 95 30 FF FF FF E8 ?? ?? ?? ?? 8B 95 30 FF FF FF E9 E4 FE FF FF 66 0F 1F 44 00 00 4F 8D 04 94 4E 8D 4C 08 18 4D 39 C8 0F 87 E9 03 00 00 41 BA 01 00 00 00 41 BE FF FF FF FF E9 0E FF FF FF 0F 1F 44 00 00 8B 45 98 8B 55 9C 4C 63 5D A0 4C 63 E8 48 63 CA 89 95 50 FF FF FF 4A 8D 14 29 48 03 95 58 FF FF FF 89 85 54 FF FF FF 48 8B 85 60 FF FF FF 41 8D 7B 01 48 63 FF 48 01 D0 48 C1 E7 03 48 F7 D8 48 01 FA 83 E0 07 48 01 C2 48 3B 55 10 76 1A 48 8B 05 ?? ?? ?? ?? BA 22 00 00 00 64 C7 00 22 00 00 00 E9 D3 FE FF FF 66 90 48 8B 95 40 FF FF FF 48 01 C8 48 01 D7 49 89 57 08 49 01 FD 49 89 3F 4D 89 6F 18 49 01 C5 8B 45 A4 48 85 F6 41 89 47 10 0F 84 52 01 00 00 8B 95 54 FF FF FF 03 95 50 FF FF FF 4C 89 85 20 FF FF FF 4C 89 8D 18 FF FF FF 44 89 95 10 FF FF FF 48 63 D2 E8 ?? ?? ?? ?? 44 8B 95 10 FF FF FF 4C 8B 8D 18 FF FF FF 4C 8B 85 20 FF FF FF 48 63 75 A0 85 F6 0F 8E 18 02 00 00 31 C0 31 C9 0F 1F 40 00 49 8B 57 08 4C 89 2C C2 41 8B 14 84 48 83 C0 01 49 01 D5 48 01 D1 48 39 F0 7C E5 48 C1 E6 03 49 8B 47 08 48 C7 04 30 00 00 00 00 49 8D 04 08 49 39 C1 0F 82 F8 03 00 00 48 8B 85 60 FF FF FF 48 03 45 10 49 39 C5 0F 87 0B 03 00 00 4D 85 C0 0F 84 83 01 00 00 49 8B 47 08 48 89 CA 4C 89 C6 48 8B 38 44 89 95 10 FF FF FF E8 ?? ?? ?? ?? 48 63 45 98 49 8B 17 44 8B 95 10 FF FF FF 80 7C 02 FF 00 74 1D 48 8B 03 31 D2 8B 40 08 3B 45 8C 0F 94 C2 83 EA 02 E9 B8 FD FF FF 0F 1F 80 00 00 00 00 48 63 45 9C 49 8B 57 18 80 7C 02 FF 00 75 D4 48 63 75 A0 48 85 F6 7E 32 49 8B 7F 08 41 8B 04 24 48 8B 17 83 E8 01 80 3C 02 00 75 B7 31 C0 EB 11 41 8B 14 84 48 8B 0C C7 83 EA 01 80 3C 11 00 75 A2 48 83 C0 01 48 39 C6 7F E6 48 8B 55 18 4C 89 3A 31 D2 E9 59 FD FF FF 0F 1F 84 00 00 00 00 00 8B 85 54 FF FF FF 03 85 50 FF FF FF 45 85 DB 48 89 7D B0 48 63 C8 48 89 4D B8 0F 8E 37 01 00 00 45 85 D2 0F 85 1A 03 00 00 48 8B BD 48 FF FF FF 49 C1 E3 02 4C 01 DF 48 81 FF 00 10 00 00 0F 87 35 02 00 00 48 89 E0 49 8D 53 1E 48 83 E2 F0 48 29 D4 4C 8D 64 24 0F 49 83 E4 F0 48 29 E0 48 01 85 48 FF FF FF 41 BA 01 00 00 00 4C 89 65 C0 4C 89 5D C8 4C 01 D9 BA 02 00 00 00 48 8D 75 B0 44 89 F7 48 89 8D 28 FF FF FF 4C 89 85 20 FF FF FF 4C 89 8D 18 FF FF FF 44 89 95 10 FF FF FF E8 ?? ?? ?? ?? 48 8B 8D 28 FF FF FF BA FF FF FF FF 4C 8B 85 20 FF FF FF 4C 8B 8D 18 FF FF FF 44 8B 95 10 FF FF FF 48 39 C8 0F 85 84 FC FF FF E9 1A FE FF FF 66 0F 1F 44 00 00 48 85 C9 75 3C 48 8B 45 18 31 D2 4C 89 38 E9 66 FC FF FF 0F 1F 44 00 00 C7 05 ?? ?? ?? ?? 01 00 00 00 44 89 F2 45 31 E4 45 31 D2 E9 59 FC FF FF 45 31 F6 E9 31 FA FF FF 31 F6 31 C9 E9 06 FE FF FF 49 8B 47 08 48 89 CA 44 89 F7 48 8B 30 48 89 8D 28 FF FF FF 44 89 95 10 FF FF FF E8 ?? ?? ?? ?? 48 8B 8D 28 FF FF FF BA FF FF FF FF 44 8B 95 10 FF FF FF 48 39 C8 0F 85 FC FB FF FF EB 86 BA 01 00 00 00 E9 1A FF FF FF A8 01 89 45 8C 75 30 83 85 7C FF FF FF 01 83 BD 7C FF FF FF 05 74 20 83 FA FF 74 1B 45 85 D2 0F 85 92 FA FF FF 4C 89 E7 E8 ?? ?? ?? ?? 66 90 E9 83 FA FF FF 0F 1F 00 F0 83 6B 18 01 74 19 83 FA FF 0F 84 09 FB FF FF 48 C7 C3 FF FF FF FF EB CC 0F 1F 80 00 00 00 00 48 89 DF 89 95 30 FF FF FF 44 89 95 10 FF FF FF E8 ?? ?? ?? ?? 44 8B 95 10 FF FF FF 8B 95 30 FF FF FF EB C3 C7 05 ?? ?? ?? ?? 01 00 00 00 E9 66 FB FF FF BA FF FF FF FF E9 A0 FA FF FF 48 89 C7 4C 89 95 10 FF FF FF E8 ?? ?? ?? ?? 85 C0 4C 8B 95 10 FF FF FF 0F 85 46 F9 FF FF 48 8B BD 70 FF FF FF 4C 89 95 10 FF FF FF E8 ?? ?? ?? ?? 48 85 C0 48 89 85 68 FF FF FF 4C 8B 95 10 FF FF FF 0F 84 1F 01 00 00 C7 85 3C FF FF FF 00 00 00 00 48 C7 85 48 FF FF FF 00 00 00 00 E9 49 F9 FF FF 4D 85 C0 0F 84 06 FC FF FF 48 8B 03 BA FE FF FF FF 8B 40 08 3B 45 8C 0F 85 DD FA FF FF E9 ED FB FF FF 48 89 8D 28 FF FF FF 4C 89 85 20 FF FF FF 4C 89 8D 18 FF FF FF 44 89 95 10 FF FF FF 4C 89 9D 30 FF FF FF E8 ?? ?? ?? ?? 85 C0 48 8B 8D 28 FF FF FF 4C 8B 85 20 FF FF FF 4C 8B 8D 18 FF FF FF 44 8B 95 10 FF FF FF 4C 8B 9D 30 FF FF FF 0F 85 78 FD FF FF 4C 89 DF 48 89 8D 28 FF FF FF 4C 89 85 20 FF FF FF 4C 89 8D 18 FF FF FF 44 89 95 10 FF FF FF 4C 89 9D 30 FF FF FF E8 ?? ?? ?? ?? 48 85 C0 49 89 C4 48 8B 8D 28 FF FF FF 4C 8B 85 20 FF FF FF 4C 8B 8D 18 FF FF FF 44 8B 95 10 FF FF FF 4C 8B 9D 30 FF FF FF 0F 85 45 FD FF FF BA 0C 00 00 00 E9 21 FA FF FF 4D 85 C0 BA FF FF FF FF 0F 85 45 FC FF FF E9 0E FA FF FF B9 ?? ?? ?? ?? BA F8 00 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? BA FF FF FF FF E9 68 F9 FF FF }
	condition:
		$1
}

rule file_410_1_0 {
	meta:
		name = "__nscd_getservbyname_r"
		size = 126
		refs = "0035 strlen"
	strings:
		$1 = { 48 89 5C 24 D0 48 89 6C 24 D8 48 89 FB 48 89 F5 4C 89 64 24 E0 4C 89 6C 24 E8 49 89 D4 49 89 CD 4C 89 74 24 F0 4C 89 7C 24 F8 4D 89 C6 48 83 EC 48 4D 89 CF E8 ?? ?? ?? ?? 4C 89 7C 24 08 4C 89 34 24 4D 89 E9 4D 89 E0 48 89 EA 48 89 DF B9 10 00 00 00 48 89 C6 E8 05 F7 FF FF 48 8B 5C 24 18 48 8B 6C 24 20 4C 8B 64 24 28 4C 8B 6C 24 30 4C 8B 74 24 38 4C 8B 7C 24 40 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_410_2_0 {
	meta:
		name = "__nscd_getservbyport_r"
		size = 138
		refs = "0041 _itoa_word"
	strings:
		$1 = { 48 89 5C 24 D8 48 89 6C 24 E0 48 89 F3 4C 89 64 24 E8 4C 89 6C 24 F0 48 89 D5 4C 89 74 24 F8 48 83 EC 48 49 89 CC 48 8D 74 24 1D 48 63 FF 31 C9 BA 0A 00 00 00 4D 89 C5 4D 89 CE C6 44 24 1D 00 E8 ?? ?? ?? ?? 48 8D 74 24 1E 4C 89 74 24 08 4C 89 2C 24 4D 89 E1 49 89 E8 48 89 DA 48 29 C6 B9 11 00 00 00 48 89 C7 E8 74 F6 FF FF 48 8B 5C 24 20 48 8B 6C 24 28 4C 8B 64 24 30 4C 8B 6C 24 38 4C 8B 74 24 40 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_410_3_0 {
	meta:
		name = "serv_map_free"
		size = 34
		refs = "0003 __serv_map_handle 0019 free"
	strings:
		$1 = { 48 8B 3D ?? ?? ?? ?? 48 83 FF FF 74 13 48 C7 05 ?? ?? ?? ?? FF FF FF FF E9 ?? ?? ?? ?? 0F 1F 00 F3 C3 }
	condition:
		$1
}

rule file_776_3_0 {
	meta:
		name = "gr_map_free"
		size = 34
		refs = "0003 __gr_map_handle 0019 free"
	strings:
		$1 = { 48 8B 3D ?? ?? ?? ?? 48 83 FF FF 74 13 48 C7 05 ?? ?? ?? ?? FF FF FF FF E9 ?? ?? ?? ?? 0F 1F 00 F3 C3 }
	condition:
		$1
}

rule file_825_5_0 {
	meta:
		name = "hst_map_free"
		size = 34
		refs = "0003 __hst_map_handle 0019 free"
	strings:
		$1 = { 48 8B 3D ?? ?? ?? ?? 48 83 FF FF 74 13 48 C7 05 ?? ?? ?? ?? FF FF FF FF E9 ?? ?? ?? ?? 0F 1F 00 F3 C3 }
	condition:
		$1
}

rule file_456_3_0 {
	meta:
		name = "pw_map_free"
		size = 34
		refs = "0019 free"
	strings:
		$1 = { 48 8B 3D ?? ?? ?? ?? 48 83 FF FF 74 13 48 C7 05 ?? ?? ?? ?? FF FF FF FF E9 ?? ?? ?? ?? 0F 1F 00 F3 C3 }
	condition:
		$1
}

rule file_411_0_0 {
	meta:
		name = "inet_nsap_addr"
		size = 228
		refs = "003f __libc_tsd_CTYPE_TOUPPER 004a __libc_tsd_CTYPE_B"
	strings:
		$1 = { 53 31 C0 E9 C2 00 00 00 0F 1F 84 00 00 00 00 00 39 D0 0F 83 C1 00 00 00 80 F9 2B 0F 84 A6 00 00 00 80 F9 2E 0F 84 9D 00 00 00 80 F9 2F 0F 84 94 00 00 00 F6 C1 80 0F 85 A4 00 00 00 4C 8B 05 ?? ?? ?? ?? 64 4D 8B 10 4C 8B 05 ?? ?? ?? ?? 41 8B 0C 8A 64 4D 8B 08 44 0F B6 C1 43 F6 44 41 01 10 74 7E 44 0F B6 C1 44 0F B6 5F 01 41 8D 48 D0 44 89 C3 4C 8D 47 02 83 F9 0A 19 C9 83 E1 F9 83 C1 37 29 CB 45 84 DB 89 D9 74 56 43 8B 3C 9A 44 0F B6 D7 43 F6 44 51 01 10 74 46 C1 E1 04 81 E7 FF 00 00 00 41 89 C9 8D 4F D0 89 FB 83 F9 0A 19 C9 48 83 C6 01 83 C0 01 83 E1 F9 83 C1 37 29 CB 89 D9 44 09 C9 88 4E FF 4C 89 C7 0F B6 0F 4C 8D 47 01 84 C9 0F 85 37 FF FF FF 5B C3 0F 1F 44 00 00 31 C0 5B C3 }
	condition:
		$1
}

rule file_411_1_0 {
	meta:
		name = "inet_nsap_ntoa"
		size = 187
	strings:
		$1 = { 41 54 48 85 D2 48 89 D0 BA ?? ?? ?? ?? 41 BC FF 00 00 00 48 89 F1 48 0F 44 C2 81 FF FF 00 00 00 55 44 0F 4E E7 49 89 C0 41 B9 01 00 00 00 45 85 E4 53 41 BB 37 00 00 00 41 BA 30 00 00 00 48 89 C7 7E 52 0F 1F 44 00 00 0F B6 39 89 CB 29 F3 40 C0 EF 04 40 0F B6 D7 83 FA 09 44 89 D2 41 0F 4F D3 48 83 C1 01 01 D7 44 89 D2 41 88 38 0F B6 79 FF 83 E7 0F 40 0F B6 EF 83 FD 09 41 0F 4F D3 89 D5 01 EF 83 E3 01 41 88 78 01 49 8D 78 02 75 10 45 39 E1 7C 1B C6 07 00 5B 5D 41 5C C3 0F 1F 00 45 39 E1 7D F0 41 83 C1 01 49 89 F8 EB 9A 66 90 41 C6 40 02 2E 49 8D 78 03 EB EA }
	condition:
		$1
}

rule file_412_0_0 {
	meta:
		name = "read_int"
		size = 95
	strings:
		$1 = { 48 8B 17 41 B9 FF FF FF 7F 8B 02 83 E8 30 66 90 48 83 C2 04 8B 0A 83 E9 30 83 F9 09 77 31 85 C0 78 EE 3D CC CC CC 0C 7F 2F 8D 34 80 45 89 C8 B8 FF FF FF FF 41 29 C8 01 F6 01 F1 44 39 C6 0F 4E C1 48 83 C2 04 8B 0A 83 E9 30 83 F9 09 76 CF 48 89 17 C3 0F 1F 44 00 00 B8 FF FF FF FF EB B1 }
	condition:
		$1
}

rule file_412_1_0 {
	meta:
		name = "__parse_one_specwc"
		size = 1615
		refs = "00c8 __printf_modifier_table 0105 __handle_registered_modifier_wc 0123 __printf_function_table 0181 __wcschrnul 0608 __printf_arginfo_table"
	strings:
		$1 = { 41 57 41 56 49 89 FE 41 55 49 89 F5 41 54 49 89 CC 55 48 8D 6F 04 53 48 89 D3 48 89 EF 48 83 EC 18 C7 42 30 FF FF FF FF 0F B6 43 0D 48 89 6C 24 08 0F B6 52 0C C7 43 10 20 00 00 00 83 E0 F6 83 C8 04 83 E2 07 88 53 0C 88 43 0D 41 8B 46 04 8D 48 D0 83 F9 09 0F 86 25 02 00 00 0F 1F 44 00 00 83 E8 20 83 F8 29 0F 86 34 01 00 00 48 89 7C 24 08 83 E2 20 74 07 C7 43 10 20 00 00 00 C7 43 2C FF FF FF FF C7 43 04 00 00 00 00 8B 45 00 83 F8 2A 0F 84 41 02 00 00 83 E8 30 45 31 F6 83 F8 09 0F 86 9A 02 00 00 C7 43 28 FF FF FF FF C7 03 FF FF FF FF 83 7D 00 2E 0F 84 53 02 00 00 80 63 0C F8 80 63 0D FD 48 8B 05 ?? ?? ?? ?? 66 C7 43 0E 00 00 48 85 C0 75 1B 8B 75 00 48 8D 4D 04 48 89 4C 24 08 8D 46 B4 83 F8 2E 77 35 FF 24 C5 ?? ?? ?? ?? 8B 55 00 48 83 3C D0 00 74 DB 48 8D 7C 24 08 48 89 DE E8 ?? ?? ?? ?? 85 C0 0F 85 34 05 00 00 48 8B 4C 24 08 8B 31 48 83 C1 04 0F 1F 40 00 48 83 3D ?? ?? ?? ?? 00 89 73 08 48 89 4C 24 08 C7 43 40 FF FF FF FF 0F 85 BC 04 00 00 8D 56 BF 48 C7 43 38 01 00 00 00 83 FA 37 0F 86 EF 00 00 00 48 C7 43 38 00 00 00 00 0F 1F 80 00 00 00 00 83 7B 30 FF 0F 84 4E 01 00 00 85 F6 0F 84 EE 00 00 00 48 8B 7C 24 08 BE 25 00 00 00 48 89 7B 18 E8 ?? ?? ?? ?? 48 89 43 20 48 83 C4 18 4C 89 F0 5B 5D 41 5C 41 5D 41 5E 41 5F C3 0F 1F 44 00 00 FF 24 C5 ?? ?? ?? ?? 66 0F 1F 84 00 00 00 00 00 80 4B 0D 08 0F 1F 40 00 8B 45 04 48 8D 7D 04 85 C0 74 25 48 89 FD E9 95 FE FF FF 0F 1F 44 00 00 C7 43 10 30 00 00 00 8B 45 04 48 8D 7D 04 85 C0 75 E1 66 0F 1F 44 00 00 48 89 7C 24 08 48 89 FD E9 7C FE FF FF 0F 1F 00 83 CA 20 88 53 0C EB B8 83 CA 40 88 53 0C EB B0 0F 1F 84 00 00 00 00 00 83 CA 80 88 53 0C EB A0 0F 1F 84 00 00 00 00 00 83 CA 08 88 53 0C EB 90 0F 1F 84 00 00 00 00 00 83 CA 10 88 53 0C EB 80 0F 1F 84 00 00 00 00 00 FF 24 D5 ?? ?? ?? ?? 66 0F 1F 84 00 00 00 00 00 80 4B 0C 04 48 8D 4D 08 8B 75 04 E9 C0 FE FF FF 48 8B 44 24 08 48 83 E8 04 48 89 43 20 48 89 43 18 E9 13 FF FF FF 66 2E 0F 1F 84 00 00 00 00 00 48 8D 7C 24 08 E8 16 FD FF FF 85 C0 74 0E 48 8B 54 24 08 83 3A 24 0F 84 A4 02 00 00 48 89 6C 24 08 41 8B 46 04 48 89 EF 0F B6 53 0C E9 AF FD FF FF 0F 1F 80 00 00 00 00 48 8B 43 38 48 85 C0 0F 84 A5 FE FF FF 44 89 6B 30 49 01 C6 E9 99 FE FF FF 0F 1F 80 00 00 00 00 8B 45 04 4C 8D 75 04 4C 89 74 24 08 83 E8 30 83 F8 09 76 74 44 89 6B 2C 4C 89 74 24 08 4C 89 F5 49 83 C5 01 41 BE 01 00 00 00 E9 9F FD FF FF 66 0F 1F 84 00 00 00 00 00 8B 45 04 48 8D 55 04 48 89 54 24 08 83 F8 2A 0F 84 CB 01 00 00 83 E8 30 83 F8 09 0F 86 DF 00 00 00 C7 03 00 00 00 00 48 89 D5 E9 7E FD FF FF 90 48 8D 7C 24 08 E8 56 FC FF FF 83 F8 FF 74 03 89 43 04 48 8B 6C 24 08 E9 4A FD FF FF 0F 1F 40 00 48 8D 7C 24 08 E8 36 FC FF FF 85 C0 0F 84 5E 01 00 00 48 8B 4C 24 08 83 39 24 0F 85 50 01 00 00 83 F8 FF 0F 84 37 02 00 00 49 8B 34 24 8D 50 FF 89 C0 89 53 2C 48 39 F0 48 0F 42 C6 49 89 04 24 48 83 C1 04 48 89 4C 24 08 E9 25 01 00 00 66 90 0F B6 53 0C 48 8D 4D 08 83 CA 04 88 53 0C 8B 75 04 83 FE 6C 0F 85 56 FD FF FF EB 28 0F 1F 40 00 83 7D 04 68 0F 84 AB 01 00 00 80 4B 0C 02 48 8D 4D 08 8B 75 04 E9 36 FD FF FF 66 0F 1F 44 00 00 0F B6 53 0C 83 CA 01 48 83 C1 04 88 53 0C 8B 71 FC E9 1A FD FF FF 66 2E 0F 1F 84 00 00 00 00 00 48 8D 7C 24 08 E8 86 FB FF FF 83 F8 FF 74 02 89 03 48 8B 6C 24 08 E9 92 FC FF FF 0F 1F 44 00 00 0F B6 43 0C 83 E0 01 3C 01 19 C0 30 C0 05 07 01 00 00 89 43 34 E9 16 FD FF FF 66 0F 1F 44 00 00 C7 43 34 02 00 00 00 E9 04 FD FF FF 0F 1F 40 00 C7 43 34 04 00 00 00 E9 F4 FC FF FF 0F 1F 40 00 0F B6 43 0C A8 04 0F 84 AC 00 00 00 C7 43 34 00 02 00 00 E9 D8 FC FF FF 0F 1F 84 00 00 00 00 00 C7 43 34 01 00 00 00 E9 C4 FC FF FF 0F 1F 40 00 C7 43 34 00 08 00 00 E9 B4 FC FF FF 0F 1F 40 00 C7 43 34 05 00 00 00 E9 A4 FC FF FF 0F 1F 40 00 C7 43 34 03 00 00 00 E9 94 FC FF FF 0F 1F 40 00 8B 53 2C 85 D2 0F 88 11 FE FF FF 48 8B 6C 24 08 45 31 F6 E9 BE FB FF FF 0F 1F 84 00 00 00 00 00 8B 45 08 4C 8D 7D 08 4C 89 7C 24 08 83 E8 30 83 F8 09 0F 86 8D 00 00 00 44 89 6B 28 49 83 C6 01 49 83 C5 01 4C 89 7C 24 08 4C 89 FD E9 9C FB FF FF 0F 1F 80 00 00 00 00 A8 02 74 48 C7 43 34 00 04 00 00 E9 28 FC FF FF 0F 1F 84 00 00 00 00 00 48 8D 6A 04 83 F8 FF 48 89 6C 24 08 74 17 8D 48 FF 89 C0 89 4B 30 49 8B 0C 24 48 39 C8 48 0F 42 C1 49 89 04 24 8B 42 04 48 89 EF 0F B6 53 0C E9 EC FA FF FF 31 C0 F6 43 0D 02 0F 95 C0 89 43 34 E9 DB FB FF FF 80 4B 0D 02 48 8D 4D 0C 8B 75 08 E9 8B FB FF FF 48 8D 7C 24 08 E8 01 FA FF FF 85 C0 74 0A 48 8B 4C 24 08 83 39 24 74 1B 8B 53 28 85 D2 0F 89 69 FE FF FF E9 4B FF FF FF 0F 1F 00 8B 53 2C E9 D8 FD FF FF 83 F8 FF 0F 1F 44 00 00 74 22 49 8B 34 24 8D 50 FF 89 C0 89 53 28 48 39 F0 48 0F 42 C6 49 89 04 24 48 83 C1 04 48 89 4C 24 08 EB BC 8B 53 28 EB F0 81 FE FF 00 00 00 0F 8F 38 FB FF FF 48 8B 05 ?? ?? ?? ?? 48 63 D6 48 8B 04 D0 48 85 C0 0F 84 21 FB FF FF 48 8D 53 34 BE 01 00 00 00 48 8D 4B 40 48 89 DF FF D0 48 63 D0 85 C0 8B 73 08 48 89 53 38 0F 89 20 FB FF FF E9 F8 FA FF FF 48 8B 6C 24 08 E9 88 FA FF FF }
	condition:
		$1
}

rule file_413_0_0 {
	meta:
		name = "ttyslot"
		size = 183
		refs = "0013 __sysconf 003b setttyent 004c __ttyname_r 005f endttyent 007e strrchr 0097 strcmp 00a3 getttyent"
	strings:
		$1 = { 55 BF 48 00 00 00 48 89 E5 41 55 41 54 53 48 83 EC 08 E8 ?? ?? ?? ?? 49 89 C4 B8 20 00 00 00 49 83 C4 01 4C 0F 44 E0 31 DB 49 8D 44 24 1E 48 83 E0 F0 48 29 C4 4C 8D 6C 24 0F E8 ?? ?? ?? ?? 49 83 E5 F0 4C 89 E2 4C 89 EE 89 DF E8 ?? ?? ?? ?? 85 C0 74 1C 83 C3 01 83 FB 03 75 E7 31 DB E8 ?? ?? ?? ?? 48 8D 65 E8 89 D8 5B 41 5C 41 5D 5D C3 BE 2F 00 00 00 4C 89 EF BB 01 00 00 00 E8 ?? ?? ?? ?? 4C 8D 60 01 48 85 C0 4D 0F 44 E5 EB 13 90 48 8B 38 4C 89 E6 E8 ?? ?? ?? ?? 85 C0 74 11 83 C3 01 E8 ?? ?? ?? ?? 48 85 C0 75 E4 EB AE 66 90 E8 ?? ?? ?? ?? EB AC }
	condition:
		$1
}

rule file_414_0_0 {
	meta:
		name = "__atomic_pwritev_replacement"
		size = 373
		refs = "00b0 mempcpy 00c6 __pwrite 00d3 free 00f3 __libc_errno 0127 __libc_alloca_cutoff 0145 malloc"
	strings:
		$1 = { 55 48 89 E5 41 57 41 56 49 89 CE 41 55 41 54 53 48 83 EC 28 85 D2 89 7D CC 0F 8E F5 00 00 00 48 8B 46 08 49 BA FF FF FF FF FF FF FF 7F 31 C9 45 31 FF 48 89 F7 4C 39 D0 76 1D E9 B1 00 00 00 90 48 83 C7 10 48 8B 47 08 4D 89 D1 4D 29 F9 49 39 C1 0F 82 99 00 00 00 83 C1 01 49 01 C7 39 D1 75 DF 49 81 FF 00 10 00 00 0F 87 AE 00 00 00 49 8D 47 1E 48 C7 45 C0 00 00 00 00 48 83 E0 F0 48 29 C4 4C 8D 64 24 0F 49 83 E4 F0 85 D2 7E 2B 83 EA 01 49 89 F5 4C 89 E0 48 C1 E2 04 48 8D 5C 16 10 49 8B 55 08 49 8B 75 00 48 89 C7 49 83 C5 10 E8 ?? ?? ?? ?? 49 39 DD 75 E7 8B 7D CC 4C 89 F1 4C 89 FA 4C 89 E6 E8 ?? ?? ?? ?? 48 8B 7D C0 48 89 45 B8 E8 ?? ?? ?? ?? 48 8B 45 B8 48 8D 65 D8 5B 41 5C 41 5D 41 5E 41 5F 5D C3 66 0F 1F 44 00 00 48 8B 05 ?? ?? ?? ?? 64 C7 00 16 00 00 00 48 8D 65 D8 48 C7 C0 FF FF FF FF 5B 41 5C 41 5D 41 5E 41 5F 5D C3 45 31 FF E9 52 FF FF FF 4C 89 FF 89 55 B0 48 89 75 B8 E8 ?? ?? ?? ?? 85 C0 8B 55 B0 48 8B 75 B8 0F 85 34 FF FF FF 4C 89 FF 89 55 B0 48 89 75 B8 E8 ?? ?? ?? ?? 48 85 C0 49 89 C4 8B 55 B0 48 8B 75 B8 74 09 48 89 45 C0 E9 2D FF FF FF 48 C7 45 C0 00 00 00 00 48 C7 C0 FF FF FF FF E9 55 FF FF FF }
	condition:
		$1
}

rule file_414_1_0 {
	meta:
		name = "pwritev"
		size = 264
		refs = "001c __libc_multiple_threads 0073 __libc_errno 00a6 __libc_enable_asynccancel 00d1 __libc_disable_asynccancel"
	strings:
		$1 = { 48 89 5C 24 E0 48 89 6C 24 E8 89 FB 4C 89 64 24 F0 4C 89 6C 24 F8 48 83 EC 38 8B 05 ?? ?? ?? ?? 48 89 F5 41 89 D4 49 89 CD 85 C0 75 78 49 89 CA 48 63 D2 48 63 FF B8 28 01 00 00 0F 05 48 3D 00 F0 FF FF 0F 87 96 00 00 00 48 85 C0 78 22 48 8B 5C 24 18 48 8B 6C 24 20 4C 8B 64 24 28 4C 8B 6C 24 30 48 83 C4 38 C3 66 0F 1F 84 00 00 00 00 00 48 8B 15 ?? ?? ?? ?? 64 83 3A 26 75 D1 4C 89 E9 44 89 E2 48 89 EE 89 DF 48 8B 6C 24 20 48 8B 5C 24 18 4C 8B 64 24 28 4C 8B 6C 24 30 48 83 C4 38 E9 DB FD FF FF E8 ?? ?? ?? ?? 4D 89 EA 41 89 C0 49 63 D4 48 89 EE 48 63 FB B8 28 01 00 00 0F 05 48 3D 00 F0 FF FF 77 2C 44 89 C7 48 89 44 24 08 E8 ?? ?? ?? ?? 48 8B 44 24 08 E9 6A FF FF FF 48 8B 15 ?? ?? ?? ?? F7 D8 64 89 02 48 83 C8 FF E9 55 FF FF FF 89 C2 48 8B 05 ?? ?? ?? ?? F7 DA 64 89 10 48 83 C8 FF EB C0 }
	condition:
		$1
}

rule file_415_0_0 {
	meta:
		name = "_L_lock_67"
		size = 27
		refs = "000b __lll_lock_wait_private"
	strings:
		$1 = { 48 8D 3A 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 E9 59 FF FF FF }
	condition:
		$1
}

rule file_415_1_0 {
	meta:
		name = "_L_unlock_123"
		size = 24
		refs = "000b __lll_unlock_wake_private"
	strings:
		$1 = { 48 8D 3E 48 81 EC 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 80 00 00 00 EB 9C }
	condition:
		$1
}

rule file_415_2_0 {
	meta:
		name = "fwide"
		size = 254
		refs = "0056 __libc_multiple_threads 008e _IO_fwide"
	strings:
		$1 = { 83 FE 00 53 48 89 FB 0F 8C CB 00 00 00 75 11 8B 97 C0 00 00 00 89 D0 5B C3 0F 1F 80 00 00 00 00 41 B8 01 00 00 00 8B 93 C0 00 00 00 85 D2 75 E5 8B 03 25 00 80 00 00 75 48 48 8B 93 88 00 00 00 64 4C 8B 0C 25 10 00 00 00 4C 3B 4A 08 74 2E BE 01 00 00 00 83 3D ?? ?? ?? ?? 00 74 0C F0 0F B1 32 0F 85 97 00 00 00 EB 09 0F B1 32 0F 85 8C 00 00 00 48 8B 93 88 00 00 00 4C 89 4A 08 83 42 04 01 41 83 F8 FF 74 61 44 89 C6 48 89 DF E8 ?? ?? ?? ?? F7 03 00 80 00 00 89 C2 0F 85 75 FF FF FF 48 8B B3 88 00 00 00 83 6E 04 01 0F 85 64 FF FF FF 48 C7 46 08 00 00 00 00 83 3D ?? ?? ?? ?? 00 74 07 F0 FF 0E 75 52 EB 04 FF 0E 75 4C E9 43 FF FF FF 66 0F 1F 44 00 00 41 B8 FF FF FF FF E9 43 FF FF FF 0F 1F 44 00 00 8B 83 C0 00 00 00 85 C0 75 A0 44 89 83 C0 00 00 00 44 89 C0 EB 94 }
	condition:
		$1
}

rule file_416_0_0 {
	meta:
		name = "calc_sizes"
		size = 150
	strings:
		$1 = { 55 53 48 89 F3 48 83 EC 08 48 8B 07 48 8B 6F 20 48 85 C0 74 73 48 83 46 10 01 31 D2 EB 05 66 90 83 C2 01 48 83 C0 30 8B 70 D8 85 F6 75 F2 48 83 78 D0 00 75 EB 48 83 78 F0 00 75 E4 8B 48 F8 85 C9 75 DD 8D 04 52 48 63 D2 48 01 53 08 48 98 48 01 03 48 85 ED 74 23 48 8B 7D 00 48 85 FF 74 1A 48 89 DE 48 83 C5 20 E8 94 FF FF FF 48 83 43 18 01 48 8B 7D 00 48 85 FF 75 E6 48 83 C4 08 5B 5D C3 0F 1F 80 00 00 00 00 48 83 7F 08 00 74 C3 48 83 46 10 01 EB BC }
	condition:
		$1
}

rule file_416_1_0 {
	meta:
		name = "argp_default_parser"
		size = 292
		refs = "0047 __argp_state_help 005b program_invocation_name 0068 strrchr 0084 program_invocation_short_name 00df strtol 00f6 __sleep"
	strings:
		$1 = { 55 53 48 89 D3 48 83 EC 08 83 FF FD 0F 84 96 00 00 00 48 89 F5 7F 19 83 FF FC 0F 84 A8 00 00 00 48 83 C4 08 B8 07 00 00 00 5B 5D C3 0F 1F 40 00 83 FF FE 74 23 83 FF 3F 75 E6 48 8B 72 50 48 89 DF BA 7A 02 00 00 E8 ?? ?? ?? ?? 48 83 C4 08 31 C0 5B 5D C3 0F 1F 40 00 48 89 35 ?? ?? ?? ?? 48 89 EF BE 2F 00 00 00 E8 ?? ?? ?? ?? 48 85 C0 48 89 43 40 0F 84 9F 00 00 00 48 83 C0 01 48 89 43 40 48 89 05 ?? ?? ?? ?? 8B 43 1C 83 E0 03 83 F8 01 75 07 48 8B 43 10 48 89 28 31 C0 48 83 C4 08 5B 5D C3 0F 1F 44 00 00 48 8B 72 50 48 89 DF BA 01 02 00 00 E8 ?? ?? ?? ?? 48 83 C4 08 31 C0 5B 5D C3 66 0F 1F 44 00 00 48 85 F6 B8 ?? ?? ?? ?? BA 0A 00 00 00 48 0F 44 E8 31 F6 48 89 EF E8 ?? ?? ?? ?? 89 05 ?? ?? ?? ?? EB 0F 0F 1F 44 00 00 BF 01 00 00 00 E8 ?? ?? ?? ?? 8B 05 ?? ?? ?? ?? 8D 50 FF 85 C0 89 15 ?? ?? ?? ?? 7F E3 31 C0 EB 8B 0F 1F 80 00 00 00 00 48 89 6B 40 48 89 E8 E9 5D FF FF FF }
	condition:
		$1
}

rule file_416_2_0 {
	meta:
		name = "convert_options"
		size = 763
		refs = "007b __libc_tsd_CTYPE_B 00f4 strcmp"
	strings:
		$1 = { 41 57 41 56 41 55 4D 89 C5 41 54 55 53 48 83 EC 38 4C 8B 37 48 8B 6F 20 48 89 7C 24 18 48 89 74 24 20 89 54 24 2C 48 89 0C 24 4D 85 F6 0F 84 A6 02 00 00 4C 89 F3 66 2E 0F 1F 84 00 00 00 00 00 8B 53 08 85 D2 75 0A 48 83 3B 00 0F 84 87 01 00 00 8B 43 18 A8 04 0F 85 3C 01 00 00 89 C1 49 89 DE 83 E1 08 0F 85 1E 01 00 00 A8 08 75 56 8D 42 FF 3D FE 00 00 00 77 4C 48 8B 05 ?? ?? ?? ?? 48 63 CA 64 48 8B 00 F6 44 48 01 40 74 37 49 8B 4D 08 88 11 49 83 7E 10 00 48 8D 41 01 49 89 45 08 74 1F C6 41 01 3A 41 F6 46 18 01 48 8D 41 02 49 89 45 08 74 0C 48 8D 41 03 C6 41 02 3A 49 89 45 08 C6 00 00 4C 8B 23 4D 85 E4 0F 84 B8 00 00 00 49 8B 4D 00 48 8B 51 10 48 89 4C 24 10 48 8B 3A 48 89 54 24 08 48 85 FF 74 22 49 89 D7 0F 1F 00 4C 89 E6 E8 ?? ?? ?? ?? 85 C0 0F 84 A8 00 00 00 49 83 C7 20 49 8B 3F 48 85 FF 75 E4 49 83 7E 10 00 49 8B 45 10 4C 89 20 0F 84 AC 00 00 00 41 8B 56 18 83 E2 01 83 FA 01 19 D2 83 C2 02 8B 4B 08 89 50 08 48 C7 40 10 00 00 00 00 85 C9 0F 84 8D 01 00 00 48 8B 74 24 10 48 8B 14 24 81 E1 FF FF FF 00 48 2B 56 50 48 BE 39 8E E3 38 8E E3 38 8E 48 C1 FA 03 48 0F AF D6 83 C2 01 C1 E2 18 01 CA 89 50 18 48 8D 50 20 49 89 55 10 48 C7 40 20 00 00 00 00 0F 1F 44 00 00 48 83 C3 30 E9 AF FE FF FF 0F 1F 80 00 00 00 00 41 8B 4E 18 E9 C0 FE FF FF 0F 1F 80 00 00 00 00 4C 89 FA 48 2B 54 24 08 48 C1 FA 05 85 D2 79 D0 49 83 7E 10 00 49 8B 45 10 4C 89 20 0F 85 54 FF FF FF 31 D2 E9 5C FF FF FF 0F 1F 80 00 00 00 00 48 83 7B 20 00 0F 85 6E FE FF FF 8B 7B 28 85 FF 0F 85 63 FE FF FF 48 8B 54 24 18 48 8B 42 08 48 8B 0C 24 48 8B 74 24 18 48 85 ED 8B 54 24 2C 48 89 01 48 89 71 08 49 8B 45 08 48 8B 74 24 20 C7 41 18 00 00 00 00 89 51 28 48 C7 41 30 00 00 00 00 48 C7 41 40 00 00 00 00 48 89 41 10 48 89 71 20 48 C7 41 38 00 00 00 00 74 38 48 83 7D 00 00 0F 84 A6 00 00 00 31 C0 83 C0 01 89 C2 48 89 D1 48 C1 E1 05 48 83 7C 0D 00 00 75 EC 48 C1 E2 03 49 8B 45 18 48 8B 0C 24 48 89 41 38 48 01 D0 49 89 45 18 48 8B 04 24 4C 8B 3C 24 48 83 C0 48 48 85 ED 74 34 48 8B 7D 00 48 85 FF 74 2B 31 D2 66 0F 1F 84 00 00 00 00 00 48 83 C5 20 4D 89 E8 48 89 C1 4C 89 FE 8D 5A 01 E8 4B FD FF FF 48 8B 7D 00 89 DA 48 85 FF 75 E0 48 83 C4 38 5B 5D 41 5C 41 5D 41 5E 41 5F C3 90 41 8B 4E 08 E9 6A FE FF FF 48 8B 54 24 18 48 8B 42 08 48 85 C0 0F 85 0C FF FF FF 48 8B 04 24 45 31 FF EB 93 31 D2 E9 6D FF FF FF }
	condition:
		$1
}

rule file_416_3_0 {
	meta:
		name = "argp_version_parser"
		size = 140
		refs = "0013 argp_program_version_hook 003b argp_program_version 0050 fprintf 0072 __dcgettext 007f __argp_error 0088 exit"
	strings:
		$1 = { 83 FF 56 74 0B B8 07 00 00 00 C3 0F 1F 44 00 00 48 8B 05 ?? ?? ?? ?? 53 48 89 D3 48 85 C0 74 18 48 8B 7A 50 48 89 D6 FF D0 F6 43 1C 20 74 56 31 C0 5B C3 0F 1F 44 00 00 48 8B 15 ?? ?? ?? ?? 48 85 D2 74 1C 48 8B 7B 50 BE ?? ?? ?? ?? 31 C0 E8 ?? ?? ?? ?? EB D3 66 2E 0F 1F 84 00 00 00 00 00 48 8B 03 BA 05 00 00 00 BE ?? ?? ?? ?? 48 8B 78 30 E8 ?? ?? ?? ?? 48 89 DF 48 89 C6 31 C0 E8 ?? ?? ?? ?? EB A4 31 FF E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_416_4_0 {
	meta:
		name = "__argp_parse"
		size = 3706
		refs = "00cf malloc 01ac memset 0298 stderr 02a3 stdout 0417 program_invocation_short_name 04a0 _getopt_long_only_r 04f2 strchr 0674 argp_program_version 08ce free 0996 __dcgettext 09b9 __argp_error 09e3 __argp_state_help 09f9 _getopt_long_r 0d27 strrchr 0d42 argp_program_version_hook 0dd0 fprintf"
	strings:
		$1 = { 55 48 89 E5 41 57 41 56 41 55 49 89 FD 41 54 53 89 CB 48 81 EC 68 01 00 00 F6 C1 10 89 B5 A4 FE FF FF 48 89 95 A8 FE FF FF 4C 89 85 98 FE FF FF 4C 89 8D 90 FE FF FF 0F 84 EB 05 00 00 89 CA 48 C7 85 B8 FE FF FF 00 00 00 00 48 C7 85 C0 FE FF FF 00 00 00 00 83 E2 04 48 C7 85 C8 FE FF FF 00 00 00 00 0F 94 C0 48 85 FF 89 95 A0 FE FF FF 0F B6 C0 48 89 85 B0 FE FF FF 0F 84 21 03 00 00 48 8D B5 B0 FE FF FF 4C 89 EF E8 12 FA FF FF 4C 8B A5 C0 FE FF FF 48 8B 85 B8 FE FF FF 4C 8B BD C8 FE FF FF 49 83 C4 01 4B 8D 34 E4 48 8D 4C 86 04 48 8B 85 B0 FE FF FF 4C 01 F9 4C 8D 34 CD 00 00 00 00 4A 8D 7C 30 01 48 89 B5 88 FE FF FF E8 ?? ?? ?? ?? 48 85 C0 48 89 45 C0 41 B8 0C 00 00 00 48 8B B5 88 FE FF FF 0F 84 9B 02 00 00 4B 8D 3C E4 4C 01 FE 4A 8D 0C 30 4C 8D 0C F0 4A 8D 14 FD 00 00 00 00 31 F6 4C 8D 04 F8 48 89 8D F8 FE FF FF 48 89 8D 80 FE FF FF 4C 89 8D 00 FF FF FF 4C 89 8D 88 FE FF FF 4C 8D A5 F0 FE FF FF 4C 89 C7 4C 89 85 50 FF FF FF 4C 89 85 78 FE FF FF 48 89 85 40 FF FF FF C7 85 08 FF FF FF 01 00 00 00 C7 85 0C FF FF FF 01 00 00 00 C7 85 10 FF FF FF 00 00 00 00 48 C7 85 18 FF FF FF 00 00 00 00 C7 85 20 FF FF FF 00 00 00 00 48 C7 85 28 FF FF FF 00 00 00 00 C7 85 30 FF FF FF 00 00 00 00 C7 85 34 FF FF FF 00 00 00 00 C7 85 38 FF FF FF 00 00 00 00 C7 85 3C FF FF FF 00 00 00 00 E8 ?? ?? ?? ?? 48 8B 8D 80 FE FF FF 4C 8B 8D 88 FE FF FF F6 C3 08 4C 8B 85 78 FE FF FF 4C 89 A5 D0 FE FF FF 48 89 8D D8 FE FF FF 4C 89 8D E0 FE FF FF 4C 89 85 E8 FE FF FF 0F 84 D6 01 00 00 C6 01 2D 48 83 C1 01 48 89 8D D8 FE FF FF C6 01 00 48 8B 85 E0 FE FF FF 4D 85 ED 48 C7 00 00 00 00 00 4C 89 AD F0 FE FF FF 0F 84 D7 04 00 00 48 8B 8D 40 FF FF FF 4C 8D 85 D0 FE FF FF 31 F6 4C 89 EF 31 D2 E8 3D FA FF FF 4C 8B 85 F0 FE FF FF 4C 8B AD 40 FF FF FF 48 89 C6 48 89 85 48 FF FF FF 49 8D 54 24 70 31 C0 B9 0C 00 00 00 4C 39 EE C7 85 58 FF FF FF 01 00 00 00 48 89 D7 F3 48 AB 8B 85 A4 FE FF FF 4C 89 85 60 FF FF FF 89 9D 7C FF FF FF 4C 89 65 B8 89 85 68 FF FF FF 48 8B 85 A8 FE FF FF 48 89 85 70 FF FF FF 48 8B 05 ?? ?? ?? ?? 48 89 45 A8 48 8B 05 ?? ?? ?? ?? 48 89 45 B0 0F 86 37 01 00 00 48 8B 85 90 FE FF FF 48 89 D3 49 89 45 30 EB 54 0F 1F 80 00 00 00 00 49 8B 55 40 31 F6 BF 03 00 00 01 49 83 C5 48 48 89 55 98 49 8B 55 E8 48 89 55 88 49 8B 55 F0 48 89 55 90 41 8B 55 D0 89 55 80 48 89 DA FF D0 41 89 C0 48 8B 45 98 49 89 45 F8 4C 3B AD 48 FF FF FF 73 6D 41 83 F8 07 0F 85 CB 03 00 00 49 8B 45 20 48 85 C0 74 10 41 8B 55 28 48 8B 40 38 48 8B 04 D0 49 89 45 30 49 8B 45 00 48 85 C0 75 91 49 8B 45 08 48 8B 40 20 48 85 C0 74 1E 48 83 38 00 74 18 49 8B 45 38 49 8B 55 30 48 89 10 49 8B 45 00 48 85 C0 0F 85 66 FF FF FF 49 83 C5 48 4C 3B AD 48 FF FF FF 41 B8 07 00 00 00 72 96 0F 1F 00 41 83 F8 07 74 6A 45 85 C0 74 65 0F 1F 44 00 00 48 8D 65 D8 44 89 C0 5B 41 5C 41 5D 41 5E 41 5F 5D C3 66 0F 1F 44 00 00 41 BE 68 00 00 00 45 31 FF BE 09 00 00 00 41 BC 01 00 00 00 E9 09 FD FF FF 0F 1F 80 00 00 00 00 44 8B B5 A0 FE FF FF 45 85 F6 0F 84 28 FE FF FF C6 01 2B 48 83 C1 01 48 89 8D D8 FE FF FF E9 15 FE FF FF 0F 1F 44 00 00 8B 85 7C FF FF FF A8 02 0F 85 1A 03 00 00 48 8B 85 70 FF FF FF C7 85 0C FF FF FF 01 00 00 00 48 39 85 A8 FE FF FF 0F 84 F7 08 00 00 48 8B 05 ?? ?? ?? ?? 48 89 45 A0 49 8D 5C 24 70 4D 8D 74 24 18 8B 45 84 44 8B BD 78 FF FF FF 85 C0 74 0C 44 39 F8 7E 07 C7 45 84 00 00 00 00 44 8B AD 58 FF FF FF 45 85 ED 0F 84 25 03 00 00 44 8B 5D 84 45 85 DB 0F 85 18 03 00 00 45 31 C0 F6 85 7C FF FF FF 40 44 89 BD 08 FF FF FF C7 85 10 FF FF FF FF FF FF FF 4D 89 F1 48 8B 8D 00 FF FF FF 48 8B 95 F8 FE FF FF 48 8B B5 70 FF FF FF 8B BD 68 FF FF FF 0F 84 59 05 00 00 E8 ?? ?? ?? ?? 41 89 C5 44 8B BD 08 FF FF FF 41 83 FD FF 44 89 BD 78 FF FF FF 0F 84 81 02 00 00 41 83 FD 3F 0F 84 3F 06 00 00 41 83 FD 01 0F 84 BD 06 00 00 44 89 E8 C1 F8 18 85 C0 89 85 A8 FE FF FF 0F 85 F9 03 00 00 48 8B BD F8 FE FF FF 44 89 EE E8 ?? ?? ?? ?? 48 85 C0 0F 84 51 06 00 00 4C 8B BD 40 FF FF FF 48 8B 95 48 FF FF FF 49 39 D7 72 1B E9 39 06 00 00 66 0F 1F 84 00 00 00 00 00 49 83 C7 48 49 39 D7 0F 83 23 06 00 00 49 3B 47 10 73 ED 49 8B 07 48 8B B5 18 FF FF FF 48 85 C0 0F 84 0A 06 00 00 49 8B 57 40 44 89 EF 48 89 55 98 49 8B 57 30 48 89 55 88 49 8B 57 38 48 89 55 90 41 8B 57 18 89 55 80 48 89 DA FF D0 41 89 C0 48 8B 45 98 49 89 47 40 41 83 F8 07 0F 84 C1 03 00 00 45 85 C0 0F 84 9E FE FF FF 41 83 F8 07 0F 84 38 04 00 00 4C 8B AD 40 FF FF FF 48 8B 9D 48 FF FF FF 4D 8D 74 24 70 49 39 DD 0F 83 FF 05 00 00 0F 1F 80 00 00 00 00 49 8B 45 00 48 85 C0 74 48 49 8B 55 40 31 F6 BF 05 00 00 01 48 89 55 98 49 8B 55 30 48 89 55 88 49 8B 55 38 48 89 55 90 41 8B 55 18 44 89 85 78 FE FF FF 89 55 80 4C 89 F2 FF D0 48 8B 45 98 48 8B 9D 48 FF FF FF 44 8B 85 78 FE FF FF 49 89 45 40 49 83 C5 48 49 39 DD 72 A6 48 83 EB 48 4C 8B AD 40 FF FF FF E9 2E 02 00 00 66 0F 1F 44 00 00 48 81 EC 90 00 00 00 31 C0 41 B9 10 00 00 00 48 8D 54 24 0F 48 83 EC 50 B9 07 00 00 00 48 8D 74 24 0F 48 83 E2 F0 48 83 E6 F0 4D 85 ED 48 89 F7 F3 48 AB 48 89 D7 4C 89 C9 48 89 56 20 F3 48 AB 74 07 4C 89 2A 48 83 C2 20 48 83 3D ?? ?? ?? ?? 00 48 C7 02 ?? ?? ?? ?? 0F 84 B9 06 00 00 48 8D 42 40 48 C7 42 20 ?? ?? ?? ?? 48 C7 00 00 00 00 00 89 D8 48 C7 85 B8 FE FF FF 00 00 00 00 83 E0 04 48 C7 85 C0 FE FF FF 00 00 00 00 48 C7 85 C8 FE FF FF 00 00 00 00 89 85 A0 FE FF FF 0F 94 C0 49 89 F5 0F B6 C0 48 89 85 B0 FE FF FF E9 A5 F9 FF FF 66 0F 1F 44 00 00 45 85 C0 0F 84 2C FC FF FF E9 9A FC FF FF 66 90 48 8B B5 40 FF FF FF 45 31 C0 48 89 B5 48 FF FF FF 49 89 F5 E9 42 FB FF FF 0F 1F 80 00 00 00 00 A8 01 C7 85 0C FF FF FF 00 00 00 00 48 8B 85 70 FF FF FF 0F 84 DE FC FF FF 48 83 E8 08 83 85 68 FF FF FF 01 48 89 85 70 FF FF FF E9 C7 FC FF FF 41 83 FF 01 C7 85 58 FF FF FF 00 00 00 00 7E 28 48 8B 85 70 FF FF FF 49 63 D7 48 8B 44 D0 F8 80 38 2D 75 14 80 78 01 2D 75 0E 80 78 02 00 75 08 44 89 7D 84 0F 1F 40 00 44 39 BD 68 FF FF FF 0F 8F 83 02 00 00 8B 85 78 FF FF FF 3B 85 68 FF FF FF 0F 84 22 04 00 00 48 83 BD 98 FE FF FF 00 0F 84 DB 05 00 00 48 8B 95 98 FE FF FF 89 02 48 8B 9D 48 FF FF FF 48 8B 95 40 FF FF FF 48 83 EB 48 49 89 D5 48 39 D3 0F 82 14 06 00 00 4D 8D 74 24 70 EB 0F 0F 1F 44 00 00 41 83 F8 07 0F 85 BE 03 00 00 48 8B 03 41 B8 07 00 00 00 48 85 C0 74 3C 48 8B 53 40 31 F6 BF 04 00 00 01 48 89 55 98 48 8B 53 30 48 89 55 88 48 8B 53 38 48 89 55 90 8B 53 18 89 55 80 4C 89 F2 FF D0 41 89 C0 48 8B 45 98 48 8B 95 40 FF FF FF 48 89 43 40 48 83 EB 48 49 89 D5 48 39 D3 73 A0 48 8B 9D 48 FF FF FF 48 83 EB 48 41 83 F8 07 75 07 45 30 C0 0F 1F 40 00 49 39 DD 77 60 49 83 C4 70 0F 1F 80 00 00 00 00 48 8B 03 48 85 C0 74 40 48 8B 53 40 31 F6 BF 07 00 00 01 48 89 55 98 48 8B 53 30 48 89 55 88 48 8B 53 38 48 89 55 90 8B 53 18 44 89 85 78 FE FF FF 89 55 80 4C 89 E2 FF D0 48 8B 45 98 44 8B 85 78 FE FF FF 48 89 43 40 48 83 EB 48 48 3B 9D 40 FF FF FF 73 AB 48 8B 7D C0 41 83 F8 07 B8 16 00 00 00 44 0F 44 C0 44 89 85 78 FE FF FF E8 ?? ?? ?? ?? 44 8B 85 78 FE FF FF E9 AA FA FF FF 66 90 48 63 85 A8 FE FF FF 48 8B B5 18 FF FF FF 48 8D 54 C0 F7 48 8B 85 40 FF FF FF 4C 8D 3C D0 49 8B 07 48 85 C0 74 52 49 8B 57 40 44 89 EF C1 E7 08 C1 FF 08 48 89 55 98 49 8B 57 30 48 89 55 88 49 8B 57 38 48 89 55 90 41 8B 57 18 89 55 80 48 89 DA FF D0 41 89 C0 48 8B 45 98 49 89 47 40 E9 35 FC FF FF 44 8B 95 A8 FE FF FF 45 85 D2 0F 84 FD 01 00 00 0F 1F 44 00 00 48 8B 9D 00 FF FF FF 44 39 6B 18 75 15 EB 19 66 0F 1F 84 00 00 00 00 00 48 83 C3 20 44 39 6B 18 74 06 48 83 3B 00 75 F0 48 8B 85 F0 FE FF FF BA 05 00 00 00 BE ?? ?? ?? ?? 48 8B 78 30 E8 ?? ?? ?? ?? 48 8B 13 B9 ?? ?? ?? ?? 49 8D 7C 24 70 BE ?? ?? ?? ?? 48 85 D2 48 0F 44 D1 48 89 C1 31 C0 E8 ?? ?? ?? ?? 41 83 FD 01 0F 84 BE FD FF FF 41 B8 07 00 00 00 48 8B 75 A8 49 8D 7C 24 70 BA 04 01 00 00 44 89 85 78 FE FF FF E8 ?? ?? ?? ?? 44 8B 85 78 FE FF FF E9 A2 FB FF FF 0F 1F 44 00 00 E8 ?? ?? ?? ?? 41 89 C5 E9 A2 FA FF FF 0F 1F 00 F6 85 7C FF FF FF 04 0F 85 70 FD FF FF 48 8B 85 70 FF FF FF 49 63 D7 41 83 C7 01 4C 8B 2C D0 4C 89 AD 18 FF FF FF 41 83 EF 01 48 8B 8D 40 FF FF FF 48 3B 8D 48 FF FF FF 44 89 BD A8 FE FF FF 44 89 BD 78 FF FF FF 0F 83 AC 02 00 00 8B 95 A8 FE FF FF 4C 8D 79 48 66 90 8D 42 01 89 85 78 FF FF FF 49 8B 47 B8 48 85 C0 74 76 49 8B 57 F8 31 FF 4C 89 EE 48 89 55 98 49 8B 57 E8 48 89 55 88 49 8B 57 F0 48 89 55 90 41 8B 57 D0 89 55 80 48 89 DA FF D0 41 89 C0 48 8B 45 98 41 83 F8 07 49 89 47 F8 0F 84 46 03 00 00 45 85 C0 75 1B 8B 85 78 FF FF FF 3B 85 A8 FE FF FF 7F 65 C7 85 58 FF FF FF 01 00 00 00 45 31 C0 41 83 F8 07 41 BD 01 00 00 00 0F 85 A2 FA FF FF E9 D8 FE FF FF 0F 1F 00 89 95 78 FF FF FF 4C 39 BD 48 FF FF FF 0F 86 05 02 00 00 49 83 C7 48 E9 5C FF FF FF 0F 1F 40 00 83 BD 10 FF FF FF FF 0F 85 B2 FE FF FF C7 85 A8 FE FF FF 00 00 00 00 E9 C3 F9 FF FF 0F 1F 40 00 2B 85 A8 FE FF FF 45 31 C0 41 BD 01 00 00 00 41 01 47 D0 41 83 F8 07 0F 85 3D FA FF FF E9 73 FE FF FF 66 0F 1F 44 00 00 48 8B 85 F0 FE FF FF BA 05 00 00 00 BE ?? ?? ?? ?? 48 8B 78 30 E8 ?? ?? ?? ?? 49 8D 7C 24 70 48 89 C1 44 89 EA BE ?? ?? ?? ?? 31 C0 E8 ?? ?? ?? ?? E9 37 FE FF FF 66 2E 0F 1F 84 00 00 00 00 00 4C 8B AD 18 FF FF FF E9 92 FE FF FF 0F 1F 40 00 45 85 C0 0F 84 39 FC FF FF 48 8B 9D 48 FF FF FF 48 83 EB 48 E9 97 FC FF FF 4C 8B B5 40 FF FF FF 48 8B 9D 48 FF FF FF 45 31 C0 4C 39 F3 76 7F 4D 8D 6C 24 70 EB 14 66 2E 0F 1F 84 00 00 00 00 00 41 83 F8 07 0F 85 6C 01 00 00 45 8B 4E 18 45 85 C9 75 4B 49 8B 06 41 B8 07 00 00 00 48 85 C0 74 3D 49 8B 56 40 31 F6 BF 02 00 00 01 48 89 55 98 49 8B 56 30 48 89 55 88 49 8B 56 38 C7 45 80 00 00 00 00 48 89 55 90 4C 89 EA FF D0 41 89 C0 48 8B 45 98 48 8B 9D 48 FF FF FF 49 89 46 40 49 83 C6 48 49 39 DE 72 99 4C 8B B5 40 FF FF FF 48 83 EB 48 49 39 DE 77 73 41 83 F8 07 0F 85 87 01 00 00 4D 8D 6C 24 70 EB 12 0F 1F 84 00 00 00 00 00 41 83 F8 07 0F 85 EE 00 00 00 48 8B 03 41 B8 07 00 00 00 48 85 C0 74 35 48 8B 53 40 31 F6 BF 01 00 00 01 48 89 55 98 48 8B 53 30 48 89 55 88 48 8B 53 38 48 89 55 90 8B 53 18 89 55 80 4C 89 EA FF D0 41 89 C0 48 8B 45 98 48 89 43 40 48 83 EB 48 48 3B 9D 40 FF FF FF 73 A6 41 83 F8 07 B8 00 00 00 00 44 0F 44 C0 48 83 BD 98 FE FF FF 00 74 0F 8B 85 78 FF FF FF 48 8B 95 98 FE FF FF 89 02 45 85 C0 0F 84 B5 FA FF FF E9 8D F8 FF FF 66 90 41 B8 07 00 00 00 E9 C5 FD FF FF 48 8B 95 A8 FE FF FF 48 8B 1A 48 85 DB 0F 84 F6 F6 FF FF 48 89 DF BE 2F 00 00 00 E8 ?? ?? ?? ?? 48 8D 50 01 48 85 C0 48 0F 45 DA 48 89 5D A0 E9 E0 F6 FF FF 48 83 3D ?? ?? ?? ?? 00 48 8D 42 20 0F 85 35 F9 FF FF E9 3C F9 FF FF 45 85 C0 0F 84 8B FE FF FF 90 E9 E2 FE FF FF 0F 1F 00 45 85 C0 0F 84 09 FF FF FF E9 61 FF FF FF 66 2E 0F 1F 84 00 00 00 00 00 F6 85 7C FF FF FF 02 41 B8 07 00 00 00 0F 85 3A FC FF FF 48 83 7D A8 00 0F 84 2F FC FF FF 48 8B 85 F0 FE FF FF 48 8B 5D A0 BA 05 00 00 00 BE ?? ?? ?? ?? 48 8B 78 30 44 89 85 78 FE FF FF E8 ?? ?? ?? ?? 48 8B 7D A8 48 89 C6 48 89 DA 31 C0 E8 ?? ?? ?? ?? 44 8B 85 78 FE FF FF E9 ED FB FF FF 45 31 C0 E9 68 FA FF FF 45 85 C0 0F 84 70 FE FF FF E9 E1 FE FF FF 4D 8B 47 B8 8B 95 78 FF FF FF 83 EA 01 4D 85 C0 89 95 78 FF FF FF 0F 84 DC FC FF FF 49 8B 47 E8 31 F6 48 89 DA BF 06 00 00 01 48 89 45 88 49 8B 47 F0 48 89 45 90 41 8B 47 D0 89 45 80 41 FF D0 4C 39 BD 48 FF FF FF 41 89 C0 48 8B 45 98 49 89 47 F8 76 16 41 83 F8 07 75 10 8B 95 78 FF FF FF 49 83 C7 48 E9 01 FC FF FF 90 45 85 C0 0F 85 67 FC FF FF 8B 85 68 FF FF FF 89 85 78 FF FF FF E9 41 FC FF FF }
	condition:
		$1
}

rule file_416_5_0 {
	meta:
		name = "__argp_input"
		size = 59
	strings:
		$1 = { 48 85 F6 74 33 48 8B 56 58 48 8B 42 50 48 8B 52 58 48 39 D0 72 13 EB 20 0F 1F 84 00 00 00 00 00 48 83 C0 48 48 39 D0 73 0F 48 39 78 08 75 F1 48 8B 40 30 C3 0F 1F 40 00 31 C0 C3 }
	condition:
		$1
}

rule file_417_1_0 {
	meta:
		name = "do_release_shlib"
		size = 117
		refs = "0032 __libc_dlclose 0071 __assert_fail"
	strings:
		$1 = { 83 FE 03 53 48 8B 1F 75 37 48 3B 1D ?? ?? ?? ?? 8B 43 08 74 3B 8D 50 02 83 FA 02 77 21 83 E8 01 83 F8 FD 89 43 08 75 16 48 8B 7B 10 48 85 FF 74 0D E8 ?? ?? ?? ?? 48 C7 43 10 00 00 00 00 5B C3 85 F6 74 C5 5B C3 66 2E 0F 1F 84 00 00 00 00 00 85 C0 7E 08 83 E8 01 89 43 08 5B C3 B9 ?? ?? ?? ?? BA AE 00 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_417_3_0 {
	meta:
		name = "__gconv_find_shlib"
		size = 487
		refs = "002d __tfind 0066 __libc_dlopen_mode 0080 __libc_dlsym 0151 strlen 015d malloc 0178 memcpy 019d __tsearch 01ae free 01c5 __gconv_release_shlib 01e3 __assert_fail"
	strings:
		$1 = { 48 89 5C 24 E0 48 89 6C 24 E8 BA ?? ?? ?? ?? 4C 89 64 24 F0 4C 89 6C 24 F8 48 83 EC 38 48 89 7C 24 08 48 8D 7C 24 08 BE ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 85 C0 0F 84 0E 01 00 00 48 8B 18 48 85 DB 0F 84 72 01 00 00 8B 43 08 83 F8 FE 0F 8D BE 00 00 00 48 83 7B 10 00 0F 85 71 01 00 00 48 8B 3B BE 01 00 00 80 E8 ?? ?? ?? ?? 48 85 C0 48 89 43 10 0F 84 41 01 00 00 BE ?? ?? ?? ?? 48 89 C7 E8 ?? ?? ?? ?? 48 85 C0 48 89 43 18 0F 84 2E 01 00 00 48 8B 7B 10 BE ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 7B 10 48 89 43 20 BE ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 43 28 48 8B 43 18 64 48 33 04 25 30 00 00 00 48 C1 C0 11 48 89 43 18 48 8B 43 20 48 85 C0 74 11 64 48 33 04 25 30 00 00 00 48 C1 C0 11 48 89 43 20 48 8B 43 28 48 85 C0 74 11 64 48 33 04 25 30 00 00 00 48 C1 C0 11 48 89 43 28 C7 43 08 01 00 00 00 EB 20 66 0F 1F 84 00 00 00 00 00 48 83 7B 10 00 74 10 8D 48 01 BA 01 00 00 00 85 C0 0F 4F D1 89 53 08 48 89 D8 48 8B 6C 24 20 48 8B 5C 24 18 4C 8B 64 24 28 4C 8B 6C 24 30 48 83 C4 38 C3 0F 1F 44 00 00 4C 8B 64 24 08 4C 89 E7 E8 ?? ?? ?? ?? 48 8D 78 31 49 89 C5 E8 ?? ?? ?? ?? 48 85 C0 48 89 C5 48 89 C3 74 4C 48 8D 78 30 49 8D 55 01 4C 89 E6 E8 ?? ?? ?? ?? BA ?? ?? ?? ?? BE ?? ?? ?? ?? 48 89 EF 48 89 45 00 C7 45 08 FD FF FF FF 48 C7 45 10 00 00 00 00 E8 ?? ?? ?? ?? 48 85 C0 0F 85 9C FE FF FF 48 89 EF E8 ?? ?? ?? ?? 66 0F 1F 44 00 00 31 DB E9 68 FF FF FF 48 89 DF 31 DB E8 ?? ?? ?? ?? E9 59 FF FF FF B9 ?? ?? ?? ?? BA 74 00 00 00 BE ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_417_4_0 {
	meta:
		name = "free_mem"
		size = 37