private rule architecture {
	meta:
		bits = 32
		endianness = "little"
		architecture = "MIPS"
	condition:
		true
}

rule file_0_0_0 {
	meta:
		name = "fgetspent"
		size = 76
		refs = "0000 _gp_disp 0018 __GI_fgetspent_r"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 85 8F ?? ?? 86 8F D0 FF BD 27 ?? ?? 99 8F 20 00 A2 27 ?? ?? A5 24 2C 00 BF AF 18 00 BC AF 10 00 A2 AF ?? ?? C6 24 ?? ?? ?? ?? 00 01 07 24 2C 00 BF 8F 20 00 A2 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_92_0_0 {
	meta:
		name = "fgetgrent"
		size = 76
		refs = "0000 _gp_disp 0018 __GI_fgetgrent_r"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 85 8F ?? ?? 86 8F D0 FF BD 27 ?? ?? 99 8F 20 00 A2 27 ?? ?? A5 24 2C 00 BF AF 18 00 BC AF 10 00 A2 AF ?? ?? C6 24 ?? ?? ?? ?? 00 01 07 24 2C 00 BF 8F 20 00 A2 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_639_0_0 {
	meta:
		name = "fgetpwent"
		size = 76
		refs = "0000 _gp_disp 0018 __GI_fgetpwent_r"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 85 8F ?? ?? 86 8F D0 FF BD 27 ?? ?? 99 8F 20 00 A2 27 ?? ?? A5 24 2C 00 BF AF 18 00 BC AF 10 00 A2 AF ?? ?? C6 24 ?? ?? ?? ?? 00 01 07 24 2C 00 BF 8F 20 00 A2 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_459_0_0 {
	meta:
		name = "getgrgid"
		size = 76
		refs = "0000 _gp_disp 0018 __GI_getgrgid_r"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 85 8F ?? ?? 86 8F D0 FF BD 27 ?? ?? 99 8F 20 00 A2 27 ?? ?? A5 24 2C 00 BF AF 18 00 BC AF 10 00 A2 AF ?? ?? C6 24 ?? ?? ?? ?? 00 01 07 24 2C 00 BF 8F 20 00 A2 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_385_0_0 {
	meta:
		name = "getgrnam"
		size = 76
		refs = "0000 _gp_disp 0018 __GI_getgrnam_r"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 85 8F ?? ?? 86 8F D0 FF BD 27 ?? ?? 99 8F 20 00 A2 27 ?? ?? A5 24 2C 00 BF AF 18 00 BC AF 10 00 A2 AF ?? ?? C6 24 ?? ?? ?? ?? 00 01 07 24 2C 00 BF 8F 20 00 A2 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_411_0_0 {
	meta:
		name = "getpwnam"
		size = 76
		refs = "0000 _gp_disp 0018 __GI_getpwnam_r"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 85 8F ?? ?? 86 8F D0 FF BD 27 ?? ?? 99 8F 20 00 A2 27 ?? ?? A5 24 2C 00 BF AF 18 00 BC AF 10 00 A2 AF ?? ?? C6 24 ?? ?? ?? ?? 00 01 07 24 2C 00 BF 8F 20 00 A2 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_853_0_0 {
	meta:
		name = "getpwuid"
		size = 76
		refs = "0000 _gp_disp 0018 __GI_getpwuid_r"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 85 8F ?? ?? 86 8F D0 FF BD 27 ?? ?? 99 8F 20 00 A2 27 ?? ?? A5 24 2C 00 BF AF 18 00 BC AF 10 00 A2 AF ?? ?? C6 24 ?? ?? ?? ?? 00 01 07 24 2C 00 BF 8F 20 00 A2 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_422_0_0 {
	meta:
		name = "getspnam"
		size = 76
		refs = "0000 _gp_disp 0018 __GI_getspnam_r"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 85 8F ?? ?? 86 8F D0 FF BD 27 ?? ?? 99 8F 20 00 A2 27 ?? ?? A5 24 2C 00 BF AF 18 00 BC AF 10 00 A2 AF ?? ?? C6 24 ?? ?? ?? ?? 00 01 07 24 2C 00 BF 8F 20 00 A2 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_246_0_0 {
	meta:
		name = "sgetspent"
		size = 76
		refs = "0000 _gp_disp 0018 __GI_sgetspent_r"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 85 8F ?? ?? 86 8F D0 FF BD 27 ?? ?? 99 8F 20 00 A2 27 ?? ?? A5 24 2C 00 BF AF 18 00 BC AF 10 00 A2 AF ?? ?? C6 24 ?? ?? ?? ?? 00 01 07 24 2C 00 BF 8F 20 00 A2 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_1_0_0 {
	meta:
		name = "__GI_inet_ntoa_r"
		size = 180
		refs = "0000 _gp_disp 0014 _uintmaxtostr"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 C0 FF BD 27 2C 00 B3 AF ?? ?? 93 8F 20 00 B0 AF A0 80 04 7C 38 00 B6 AF 34 00 B5 AF 30 00 B4 AF 28 00 B2 AF 24 00 B1 AF 18 00 BC AF 3C 00 BF AF 02 84 30 00 0F 00 A4 24 21 90 00 00 21 88 00 00 F6 FF 15 24 2E 00 16 24 04 00 14 24 FF 00 06 32 10 00 B5 AF 14 00 A0 AF 21 C8 60 02 ?? ?? ?? ?? 21 38 00 00 FF FF 44 24 02 00 40 12 02 82 10 00 00 00 56 A2 01 00 31 26 F4 FF 34 16 21 90 80 00 3C 00 BF 8F 38 00 B6 8F 34 00 B5 8F 30 00 B4 8F 2C 00 B3 8F 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 08 00 E0 03 40 00 BD 27 }
	condition:
		$1
}

rule file_1_1_0 {
	meta:
		name = "__GI_inet_ntoa"
		size = 28
		refs = "0000 _gp_disp 0010 __GI_inet_ntoa_r"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 85 8F ?? ?? 99 8F ?? ?? ?? ?? ?? ?? A5 24 }
	condition:
		$1
}

rule file_542_0_0 {
	meta:
		name = "__GI_asctime"
		size = 28
		refs = "0000 _gp_disp 0010 __GI_asctime_r"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 85 8F ?? ?? 99 8F ?? ?? ?? ?? ?? ?? A5 24 }
	condition:
		$1
}

rule file_268_0_0 {
	meta:
		name = "__stdio_init_mutex"
		size = 32
		refs = "0000 _gp_disp 0010 __GI_memcpy"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 85 8F ?? ?? 99 8F 18 00 06 24 ?? ?? ?? ?? ?? ?? A5 24 }
	condition:
		$1
}

rule file_598_1_0 {
	meta:
		name = "ether_aton"
		size = 28
		refs = "0000 _gp_disp 0010 __GI_ether_aton_r"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 85 8F ?? ?? 99 8F ?? ?? ?? ?? ?? ?? A5 24 }
	condition:
		$1
}

rule file_598_3_0 {
	meta:
		name = "ether_ntoa"
		size = 28
		refs = "0000 _gp_disp 0010 __GI_ether_ntoa_r"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 85 8F ?? ?? 99 8F ?? ?? ?? ?? ?? ?? A5 24 }
	condition:
		$1
}

rule file_241_1_0 {
	meta:
		name = "hcreate"
		size = 28
		refs = "0000 _gp_disp 0010 __GI_hcreate_r"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 85 8F ?? ?? 99 8F ?? ?? ?? ?? ?? ?? A5 24 }
	condition:
		$1
}

rule file_2_0_0 {
	meta:
		name = "tcflush"
		size = 28
		refs = "0000 _gp_disp 000c __GI_ioctl"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F 21 30 A0 00 ?? ?? ?? ?? 07 54 05 24 }
	condition:
		$1
}

rule file_40_8_3 {
	meta:
		name = "_ZN9__gnu_cxx13stdio_filebufIcSt11char_traitsIcEE2fdEv"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSt12__basic_fileIcE2fdEv"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 38 00 84 24 }
	condition:
		$1
}

rule file_40_9_3 {
	meta:
		name = "_ZN9__gnu_cxx13stdio_filebufIcSt11char_traitsIcEE4fileEv"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSt12__basic_fileIcE4fileEv"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 38 00 84 24 }
	condition:
		$1
}

rule file_40_14_3 {
	meta:
		name = "_ZN9__gnu_cxx13stdio_filebufIwSt11char_traitsIwEE2fdEv"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSt12__basic_fileIcE2fdEv"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 38 00 84 24 }
	condition:
		$1
}

rule file_40_15_3 {
	meta:
		name = "_ZN9__gnu_cxx13stdio_filebufIwSt11char_traitsIwEE4fileEv"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSt12__basic_fileIcE4fileEv"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 38 00 84 24 }
	condition:
		$1
}

rule file_118_14_3 {
	meta:
		name = "_ZN9__gnu_cxx18stdio_sync_filebufIcSt11char_traitsIcEE4syncEv"
		size = 24
		refs = "0000 _gp_disp 000c fflush"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 20 00 84 8C }
	condition:
		$1
}

rule file_118_15_3 {
	meta:
		name = "_ZN9__gnu_cxx18stdio_sync_filebufIwSt11char_traitsIwEE4syncEv"
		size = 24
		refs = "0000 _gp_disp 000c fflush"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 20 00 84 8C }
	condition:
		$1
}

rule file_82_49_3 {
	meta:
		name = "_ZN9__gnu_cxx8__detail13__mini_vectorIPjE10deallocateEPS2_j"
		size = 24
		refs = "0000 _gp_disp 000c _ZdlPv"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 21 20 A0 00 }
	condition:
		$1
}

rule file_82_48_3 {
	meta:
		name = "_ZN9__gnu_cxx8__detail13__mini_vectorIPjE8allocateEj"
		size = 24
		refs = "0000 _gp_disp 000c _Znwj"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 80 20 05 00 }
	condition:
		$1
}

rule file_82_21_3 {
	meta:
		name = "_ZN9__gnu_cxx8__detail13__mini_vectorISt4pairIPNS_16bitmap_allocatorIcE12_Alloc_blockES6_EE10deallocateEPS7_j"
		size = 24
		refs = "0000 _gp_disp 000c _ZdlPv"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 21 20 A0 00 }
	condition:
		$1
}

rule file_82_20_3 {
	meta:
		name = "_ZN9__gnu_cxx8__detail13__mini_vectorISt4pairIPNS_16bitmap_allocatorIcE12_Alloc_blockES6_EE8allocateEj"
		size = 24
		refs = "0000 _gp_disp 000c _Znwj"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? C0 20 05 00 }
	condition:
		$1
}

rule file_82_35_3 {
	meta:
		name = "_ZN9__gnu_cxx8__detail13__mini_vectorISt4pairIPNS_16bitmap_allocatorIwE12_Alloc_blockES6_EE10deallocateEPS7_j"
		size = 24
		refs = "0000 _gp_disp 000c _ZdlPv"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 21 20 A0 00 }
	condition:
		$1
}

rule file_82_34_3 {
	meta:
		name = "_ZN9__gnu_cxx8__detail13__mini_vectorISt4pairIPNS_16bitmap_allocatorIwE12_Alloc_blockES6_EE8allocateEj"
		size = 24
		refs = "0000 _gp_disp 000c _Znwj"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? C0 20 05 00 }
	condition:
		$1
}

rule file_102_60_3 {
	meta:
		name = "_ZNKSbIwSt11char_traitsIwESaIwEE12find_last_ofEwj"
		size = 24
		refs = "0000 _gp_disp 000c _ZNKSbIwSt11char_traitsIwESaIwEE5rfindEwj"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_102_56_3 {
	meta:
		name = "_ZNKSbIwSt11char_traitsIwESaIwEE13find_first_ofEwj"
		size = 24
		refs = "0000 _gp_disp 000c _ZNKSbIwSt11char_traitsIwESaIwEE4findEwj"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_56_59_3 {
	meta:
		name = "_ZNKSs12find_last_ofEcj"
		size = 24
		refs = "0000 _gp_disp 000c _ZNKSs5rfindEcj"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 20 2C 05 7C }
	condition:
		$1
}

rule file_56_55_3 {
	meta:
		name = "_ZNKSs13find_first_ofEcj"
		size = 24
		refs = "0000 _gp_disp 000c _ZNKSs4findEcj"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 20 2C 05 7C }
	condition:
		$1
}

rule file_54_55_3 {
	meta:
		name = "_ZNKSt10ostrstream6pcountEv"
		size = 24
		refs = "0000 _gp_disp 000c _ZNKSt12strstreambuf6pcountEv"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 04 00 84 24 }
	condition:
		$1
}

rule file_119_17_3 {
	meta:
		name = "_ZNKSt13basic_filebufIcSt11char_traitsIcEE7is_openEv"
		size = 24
		refs = "0000 _gp_disp 000c _ZNKSt12__basic_fileIcE7is_openEv"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 38 00 84 24 }
	condition:
		$1
}

rule file_119_90_3 {
	meta:
		name = "_ZNKSt13basic_filebufIwSt11char_traitsIwEE7is_openEv"
		size = 24
		refs = "0000 _gp_disp 000c _ZNKSt12__basic_fileIcE7is_openEv"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 38 00 84 24 }
	condition:
		$1
}

rule file_119_83_3 {
	meta:
		name = "_ZNKSt13basic_fstreamIcSt11char_traitsIcEE7is_openEv"
		size = 24
		refs = "0000 _gp_disp 000c _ZNKSt12__basic_fileIcE7is_openEv"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 44 00 84 24 }
	condition:
		$1
}

rule file_119_156_3 {
	meta:
		name = "_ZNKSt13basic_fstreamIwSt11char_traitsIwEE7is_openEv"
		size = 24
		refs = "0000 _gp_disp 000c _ZNKSt12__basic_fileIcE7is_openEv"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 44 00 84 24 }
	condition:
		$1
}

rule file_119_57_3 {
	meta:
		name = "_ZNKSt14basic_ifstreamIcSt11char_traitsIcEE7is_openEv"
		size = 24
		refs = "0000 _gp_disp 000c _ZNKSt12__basic_fileIcE7is_openEv"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 40 00 84 24 }
	condition:
		$1
}

rule file_119_130_3 {
	meta:
		name = "_ZNKSt14basic_ifstreamIwSt11char_traitsIwEE7is_openEv"
		size = 24
		refs = "0000 _gp_disp 000c _ZNKSt12__basic_fileIcE7is_openEv"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 40 00 84 24 }
	condition:
		$1
}

rule file_119_70_3 {
	meta:
		name = "_ZNKSt14basic_ofstreamIcSt11char_traitsIcEE7is_openEv"
		size = 24
		refs = "0000 _gp_disp 000c _ZNKSt12__basic_fileIcE7is_openEv"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 3C 00 84 24 }
	condition:
		$1
}

rule file_119_143_3 {
	meta:
		name = "_ZNKSt14basic_ofstreamIwSt11char_traitsIwEE7is_openEv"
		size = 24
		refs = "0000 _gp_disp 000c _ZNKSt12__basic_fileIcE7is_openEv"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 3C 00 84 24 }
	condition:
		$1
}

rule file_48_10_3 {
	meta:
		name = "_ZNKSt5ctypeIwE10do_tolowerEw"
		size = 24
		refs = "0000 _gp_disp 000c towlower"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 21 20 A0 00 }
	condition:
		$1
}

rule file_48_8_3 {
	meta:
		name = "_ZNKSt5ctypeIwE10do_toupperEw"
		size = 24
		refs = "0000 _gp_disp 000c towupper"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 21 20 A0 00 }
	condition:
		$1
}

rule file_17_3_3 {
	meta:
		name = "_ZNKSt7codecvtIwc11__mbstate_tE13do_max_lengthEv"
		size = 24
		refs = "0000 _gp_disp 000c _stdlib_mb_cur_max"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_54_63_3 {
	meta:
		name = "_ZNKSt9strstream6pcountEv"
		size = 24
		refs = "0000 _gp_disp 000c _ZNKSt12strstreambuf6pcountEv"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 0C 00 84 24 }
	condition:
		$1
}

rule file_102_87_3 {
	meta:
		name = "_ZNSbIwSt11char_traitsIwESaIwEE18_S_construct_aux_2EjwRKS1_"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSbIwSt11char_traitsIwESaIwEE12_S_constructEjwRKS1_"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_102_88_3 {
	meta:
		name = "_ZNSbIwSt11char_traitsIwESaIwEE4_Rep10_M_destroyERKS1_"
		size = 24
		refs = "0000 _gp_disp 000c _ZdlPv"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_102_142_3 {
	meta:
		name = "_ZNSbIwSt11char_traitsIwESaIwEE6resizeEj"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSbIwSt11char_traitsIwESaIwEE6resizeEjw"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 21 30 00 00 }
	condition:
		$1
}

rule file_102_148_3 {
	meta:
		name = "_ZNSbIwSt11char_traitsIwESaIwEEaSERKS2_"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSbIwSt11char_traitsIwESaIwEE6assignERKS2_"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_102_133_3 {
	meta:
		name = "_ZNSbIwSt11char_traitsIwESaIwEEpLERKS2_"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSbIwSt11char_traitsIwESaIwEE6appendERKS2_"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_107_76_3 {
	meta:
		name = "_ZNSirsERPv"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSi10_M_extractIPvEERSiRT_"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_107_64_3 {
	meta:
		name = "_ZNSirsERb"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSi10_M_extractIbEERSiRT_"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_107_72_3 {
	meta:
		name = "_ZNSirsERd"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSi10_M_extractIdEERSiRT_"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_107_74_3 {
	meta:
		name = "_ZNSirsERe"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSi10_M_extractIeEERSiRT_"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_107_70_3 {
	meta:
		name = "_ZNSirsERf"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSi10_M_extractIfEERSiRT_"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_107_58_3 {
	meta:
		name = "_ZNSirsERj"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSi10_M_extractIjEERSiRT_"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_107_60_3 {
	meta:
		name = "_ZNSirsERl"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSi10_M_extractIlEERSiRT_"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_107_62_3 {
	meta:
		name = "_ZNSirsERm"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSi10_M_extractImEERSiRT_"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_107_56_3 {
	meta:
		name = "_ZNSirsERt"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSi10_M_extractItEERSiRT_"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_107_66_3 {
	meta:
		name = "_ZNSirsERx"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSi10_M_extractIxEERSiRT_"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_107_68_3 {
	meta:
		name = "_ZNSirsERy"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSi10_M_extractIyEERSiRT_"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_92_65_3 {
	meta:
		name = "_ZNSolsEPKv"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSo9_M_insertIPKvEERSoT_"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_92_54_3 {
	meta:
		name = "_ZNSolsEb"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSo9_M_insertIbEERSoT_"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? FF 00 A5 30 }
	condition:
		$1
}

rule file_92_60_3 {
	meta:
		name = "_ZNSolsEd"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSo9_M_insertIdEERSoT_"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_92_63_3 {
	meta:
		name = "_ZNSolsEe"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSo9_M_insertIeEERSoT_"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_92_48_3 {
	meta:
		name = "_ZNSolsEi"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSo9_M_insertIlEERSoT_"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_92_52_3 {
	meta:
		name = "_ZNSolsEj"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSo9_M_insertImEERSoT_"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_92_46_3 {
	meta:
		name = "_ZNSolsEl"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSo9_M_insertIlEERSoT_"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_92_50_3 {
	meta:
		name = "_ZNSolsEm"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSo9_M_insertImEERSoT_"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_92_51_3 {
	meta:
		name = "_ZNSolsEt"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSo9_M_insertImEERSoT_"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? FF FF A5 30 }
	condition:
		$1
}

rule file_92_56_3 {
	meta:
		name = "_ZNSolsEx"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSo9_M_insertIxEERSoT_"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_92_58_3 {
	meta:
		name = "_ZNSolsEy"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSo9_M_insertIyEERSoT_"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_56_86_3 {
	meta:
		name = "_ZNSs18_S_construct_aux_2EjcRKSaIcE"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSs12_S_constructEjcRKSaIcE"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 20 2C 05 7C }
	condition:
		$1
}

rule file_56_87_3 {
	meta:
		name = "_ZNSs4_Rep10_M_destroyERKSaIcE"
		size = 24
		refs = "0000 _gp_disp 000c _ZdlPv"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_56_141_3 {
	meta:
		name = "_ZNSs6resizeEj"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSs6resizeEjc"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 21 30 00 00 }
	condition:
		$1
}

rule file_56_147_3 {
	meta:
		name = "_ZNSsaSERKSs"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSs6assignERKSs"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_56_132_3 {
	meta:
		name = "_ZNSspLERKSs"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSs6appendERKSs"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_54_46_3 {
	meta:
		name = "_ZNSt10istrstream3strEv"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSt12strstreambuf3strEv"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 08 00 84 24 }
	condition:
		$1
}

rule file_54_54_3 {
	meta:
		name = "_ZNSt10ostrstream3strEv"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSt12strstreambuf3strEv"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 04 00 84 24 }
	condition:
		$1
}

rule file_23_6_3 {
	meta:
		name = "_ZNSt12__basic_fileIcE2fdEv"
		size = 24
		refs = "0000 _gp_disp 000c fileno"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 84 8C }
	condition:
		$1
}

rule file_23_14_3 {
	meta:
		name = "_ZNSt12__basic_fileIcE4syncEv"
		size = 24
		refs = "0000 _gp_disp 000c fflush"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 84 8C }
	condition:
		$1
}

rule file_23_9_3 {
	meta:
		name = "_ZNSt12__basic_fileIcED2Ev"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSt12__basic_fileIcE5closeEv"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_119_26_3 {
	meta:
		name = "_ZNSt13basic_filebufIcSt11char_traitsIcEE4openERKSsSt13_Ios_Openmode"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSt13basic_filebufIcSt11char_traitsIcEE4openEPKcSt13_Ios_Openmode"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 A5 8C }
	condition:
		$1
}

rule file_119_99_3 {
	meta:
		name = "_ZNSt13basic_filebufIwSt11char_traitsIwEE4openERKSsSt13_Ios_Openmode"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSt13basic_filebufIwSt11char_traitsIwEE4openEPKcSt13_Ios_Openmode"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 A5 8C }
	condition:
		$1
}

rule file_119_82_3 {
	meta:
		name = "_ZNSt13basic_fstreamIcSt11char_traitsIcEE7is_openEv"
		size = 24
		refs = "0000 _gp_disp 000c _ZNKSt12__basic_fileIcE7is_openEv"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 44 00 84 24 }
	condition:
		$1
}

rule file_119_155_3 {
	meta:
		name = "_ZNSt13basic_fstreamIwSt11char_traitsIwEE7is_openEv"
		size = 24
		refs = "0000 _gp_disp 000c _ZNKSt12__basic_fileIcE7is_openEv"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 44 00 84 24 }
	condition:
		$1
}

rule file_107_138_3 {
	meta:
		name = "_ZNSt13basic_istreamIwSt11char_traitsIwEErsERPv"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSt13basic_istreamIwSt11char_traitsIwEE10_M_extractIPvEERS2_RT_"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_107_126_3 {
	meta:
		name = "_ZNSt13basic_istreamIwSt11char_traitsIwEErsERb"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSt13basic_istreamIwSt11char_traitsIwEE10_M_extractIbEERS2_RT_"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_107_134_3 {
	meta:
		name = "_ZNSt13basic_istreamIwSt11char_traitsIwEErsERd"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSt13basic_istreamIwSt11char_traitsIwEE10_M_extractIdEERS2_RT_"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_107_136_3 {
	meta:
		name = "_ZNSt13basic_istreamIwSt11char_traitsIwEErsERe"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSt13basic_istreamIwSt11char_traitsIwEE10_M_extractIeEERS2_RT_"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_107_132_3 {
	meta:
		name = "_ZNSt13basic_istreamIwSt11char_traitsIwEErsERf"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSt13basic_istreamIwSt11char_traitsIwEE10_M_extractIfEERS2_RT_"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_107_120_3 {
	meta:
		name = "_ZNSt13basic_istreamIwSt11char_traitsIwEErsERj"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSt13basic_istreamIwSt11char_traitsIwEE10_M_extractIjEERS2_RT_"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_107_122_3 {
	meta:
		name = "_ZNSt13basic_istreamIwSt11char_traitsIwEErsERl"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSt13basic_istreamIwSt11char_traitsIwEE10_M_extractIlEERS2_RT_"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_107_124_3 {
	meta:
		name = "_ZNSt13basic_istreamIwSt11char_traitsIwEErsERm"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSt13basic_istreamIwSt11char_traitsIwEE10_M_extractImEERS2_RT_"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_107_118_3 {
	meta:
		name = "_ZNSt13basic_istreamIwSt11char_traitsIwEErsERt"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSt13basic_istreamIwSt11char_traitsIwEE10_M_extractItEERS2_RT_"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_107_128_3 {
	meta:
		name = "_ZNSt13basic_istreamIwSt11char_traitsIwEErsERx"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSt13basic_istreamIwSt11char_traitsIwEE10_M_extractIxEERS2_RT_"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_107_130_3 {
	meta:
		name = "_ZNSt13basic_istreamIwSt11char_traitsIwEErsERy"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSt13basic_istreamIwSt11char_traitsIwEE10_M_extractIyEERS2_RT_"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_92_119_3 {
	meta:
		name = "_ZNSt13basic_ostreamIwSt11char_traitsIwEElsEPKv"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSt13basic_ostreamIwSt11char_traitsIwEE9_M_insertIPKvEERS2_T_"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_92_108_3 {
	meta:
		name = "_ZNSt13basic_ostreamIwSt11char_traitsIwEElsEb"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSt13basic_ostreamIwSt11char_traitsIwEE9_M_insertIbEERS2_T_"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? FF 00 A5 30 }
	condition:
		$1
}

rule file_92_114_3 {
	meta:
		name = "_ZNSt13basic_ostreamIwSt11char_traitsIwEElsEd"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSt13basic_ostreamIwSt11char_traitsIwEE9_M_insertIdEERS2_T_"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_92_117_3 {
	meta:
		name = "_ZNSt13basic_ostreamIwSt11char_traitsIwEElsEe"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSt13basic_ostreamIwSt11char_traitsIwEE9_M_insertIeEERS2_T_"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_92_102_3 {
	meta:
		name = "_ZNSt13basic_ostreamIwSt11char_traitsIwEElsEi"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSt13basic_ostreamIwSt11char_traitsIwEE9_M_insertIlEERS2_T_"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_92_106_3 {
	meta:
		name = "_ZNSt13basic_ostreamIwSt11char_traitsIwEElsEj"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSt13basic_ostreamIwSt11char_traitsIwEE9_M_insertImEERS2_T_"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_92_100_3 {
	meta:
		name = "_ZNSt13basic_ostreamIwSt11char_traitsIwEElsEl"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSt13basic_ostreamIwSt11char_traitsIwEE9_M_insertIlEERS2_T_"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_92_104_3 {
	meta:
		name = "_ZNSt13basic_ostreamIwSt11char_traitsIwEElsEm"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSt13basic_ostreamIwSt11char_traitsIwEE9_M_insertImEERS2_T_"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_92_105_3 {
	meta:
		name = "_ZNSt13basic_ostreamIwSt11char_traitsIwEElsEt"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSt13basic_ostreamIwSt11char_traitsIwEE9_M_insertImEERS2_T_"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? FF FF A5 30 }
	condition:
		$1
}

rule file_92_110_3 {
	meta:
		name = "_ZNSt13basic_ostreamIwSt11char_traitsIwEElsEx"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSt13basic_ostreamIwSt11char_traitsIwEE9_M_insertIxEERS2_T_"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_92_112_3 {
	meta:
		name = "_ZNSt13basic_ostreamIwSt11char_traitsIwEElsEy"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSt13basic_ostreamIwSt11char_traitsIwEE9_M_insertIyEERS2_T_"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_88_10_3 {
	meta:
		name = "_ZNSt13random_device16_M_getval_pretr1Ev"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSt23mersenne_twister_engineIjLj32ELj624ELj397ELj31ELj2567483615ELj11ELj4294967295ELj7ELj2636928640ELj15ELj4022730752ELj18ELj1812433253EEclEv"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_119_56_3 {
	meta:
		name = "_ZNSt14basic_ifstreamIcSt11char_traitsIcEE7is_openEv"
		size = 24
		refs = "0000 _gp_disp 000c _ZNKSt12__basic_fileIcE7is_openEv"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 40 00 84 24 }
	condition:
		$1
}

rule file_119_129_3 {
	meta:
		name = "_ZNSt14basic_ifstreamIwSt11char_traitsIwEE7is_openEv"
		size = 24
		refs = "0000 _gp_disp 000c _ZNKSt12__basic_fileIcE7is_openEv"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 40 00 84 24 }
	condition:
		$1
}

rule file_119_69_3 {
	meta:
		name = "_ZNSt14basic_ofstreamIcSt11char_traitsIcEE7is_openEv"
		size = 24
		refs = "0000 _gp_disp 000c _ZNKSt12__basic_fileIcE7is_openEv"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 3C 00 84 24 }
	condition:
		$1
}

rule file_119_142_3 {
	meta:
		name = "_ZNSt14basic_ofstreamIwSt11char_traitsIwEE7is_openEv"
		size = 24
		refs = "0000 _gp_disp 000c _ZNKSt12__basic_fileIcE7is_openEv"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 3C 00 84 24 }
	condition:
		$1
}

rule file_3_5_3 {
	meta:
		name = "_ZNSt15__exception_ptr13exception_ptrC2EPv"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSt15__exception_ptr13exception_ptr9_M_addrefEv"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 85 AC }
	condition:
		$1
}

rule file_3_8_3 {
	meta:
		name = "_ZNSt15__exception_ptr13exception_ptrD2Ev"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSt15__exception_ptr13exception_ptr10_M_releaseEv"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_22_1_3 {
	meta:
		name = "_ZNSt18condition_variableD2Ev"
		size = 24
		refs = "0000 _gp_disp 000c pthread_cond_destroy"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_22_6_3 {
	meta:
		name = "_ZNSt22condition_variable_anyD2Ev"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSt18condition_variableD1Ev"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_88_7_3 {
	meta:
		name = "_ZNSt23mersenne_twister_engineIjLj32ELj624ELj397ELj31ELj2567483615ELj11ELj4294967295ELj7ELj2636928640ELj15ELj4022730752ELj18ELj1812433253EEC2Ej"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSt23mersenne_twister_engineIjLj32ELj624ELj397ELj31ELj2567483615ELj11ELj4294967295ELj7ELj2636928640ELj15ELj4022730752ELj18ELj1812433253EE4seedEj"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_90_4_3 {
	meta:
		name = "_ZNSt6localeC2ERKS_S1_i"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSt6locale11_M_coalesceERKS_S1_i"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 80 AC }
	condition:
		$1
}

rule file_2_2_3 {
	meta:
		name = "_ZNSt8valarrayIjED2Ev"
		size = 24
		refs = "0000 _gp_disp 000c _ZdlPv"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 04 00 84 8C }
	condition:
		$1
}

rule file_54_64_3 {
	meta:
		name = "_ZNSt9strstream3strEv"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSt12strstreambuf3strEv"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 0C 00 84 24 }
	condition:
		$1
}

rule file_92_30_3 {
	meta:
		name = "_ZSt4endsIcSt11char_traitsIcEERSt13basic_ostreamIT_T0_ES6_"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSo3putEc"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 21 28 00 00 }
	condition:
		$1
}

rule file_92_86_3 {
	meta:
		name = "_ZSt4endsIwSt11char_traitsIwEERSt13basic_ostreamIT_T0_ES6_"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSt13basic_ostreamIwSt11char_traitsIwEE3putEw"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 21 28 00 00 }
	condition:
		$1
}

rule file_92_31_3 {
	meta:
		name = "_ZSt5flushIcSt11char_traitsIcEERSt13basic_ostreamIT_T0_ES6_"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSo5flushEv"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_92_87_3 {
	meta:
		name = "_ZSt5flushIwSt11char_traitsIwEERSt13basic_ostreamIT_T0_ES6_"
		size = 24
		refs = "0000 _gp_disp 000c _ZNSt13basic_ostreamIwSt11char_traitsIwEE5flushEv"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_107_48_3 {
	meta:
		name = "_ZStrsISt11char_traitsIcEERSt13basic_istreamIcT_ES5_Pa"
		size = 24
		refs = "0000 _gp_disp 000c _ZStrsIcSt11char_traitsIcEERSt13basic_istreamIT_T0_ES6_PS3_"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_107_47_3 {
	meta:
		name = "_ZStrsISt11char_traitsIcEERSt13basic_istreamIcT_ES5_Ph"
		size = 24
		refs = "0000 _gp_disp 000c _ZStrsIcSt11char_traitsIcEERSt13basic_istreamIT_T0_ES6_PS3_"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_107_46_3 {
	meta:
		name = "_ZStrsISt11char_traitsIcEERSt13basic_istreamIcT_ES5_Ra"
		size = 24
		refs = "0000 _gp_disp 000c _ZStrsIcSt11char_traitsIcEERSt13basic_istreamIT_T0_ES6_RS3_"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_107_45_3 {
	meta:
		name = "_ZStrsISt11char_traitsIcEERSt13basic_istreamIcT_ES5_Rh"
		size = 24
		refs = "0000 _gp_disp 000c _ZStrsIcSt11char_traitsIcEERSt13basic_istreamIT_T0_ES6_RS3_"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_97_0_3 {
	meta:
		name = "_ZdaPv"
		size = 24
		refs = "0000 _gp_disp 000c _ZdlPv"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_115_0_3 {
	meta:
		name = "_ZdaPvRKSt9nothrow_t"
		size = 24
		refs = "0000 _gp_disp 000c _ZdlPv"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_30_0_3 {
	meta:
		name = "_ZdlPvRKSt9nothrow_t"
		size = 24
		refs = "0000 _gp_disp 000c free"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_52_0_3 {
	meta:
		name = "_ZnajRKSt9nothrow_t"
		size = 24
		refs = "0000 _gp_disp 000c _ZnwjRKSt9nothrow_t"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_66_0_1 {
	meta:
		name = "__GI_cabs"
		size = 24
		refs = "0000 _gp_disp 000c __GI_hypot"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_742_0_0 {
	meta:
		name = "__GI_iswalnum"
		size = 24
		refs = "0000 _gp_disp 000c __GI_iswctype"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 01 00 05 24 }
	condition:
		$1
}

rule file_109_0_0 {
	meta:
		name = "__GI_iswalpha"
		size = 24
		refs = "0000 _gp_disp 000c __GI_iswctype"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 02 00 05 24 }
	condition:
		$1
}

rule file_573_0_0 {
	meta:
		name = "__GI_iswblank"
		size = 24
		refs = "0000 _gp_disp 000c __GI_iswctype"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 03 00 05 24 }
	condition:
		$1
}

rule file_740_0_0 {
	meta:
		name = "__GI_iswcntrl"
		size = 24
		refs = "0000 _gp_disp 000c __GI_iswctype"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 04 00 05 24 }
	condition:
		$1
}

rule file_859_0_0 {
	meta:
		name = "__GI_iswdigit"
		size = 24
		refs = "0000 _gp_disp 000c __GI_iswctype"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 05 00 05 24 }
	condition:
		$1
}

rule file_192_0_0 {
	meta:
		name = "__GI_iswgraph"
		size = 24
		refs = "0000 _gp_disp 000c __GI_iswctype"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 06 00 05 24 }
	condition:
		$1
}

rule file_831_0_0 {
	meta:
		name = "__GI_iswlower"
		size = 24
		refs = "0000 _gp_disp 000c __GI_iswctype"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 07 00 05 24 }
	condition:
		$1
}

rule file_462_0_0 {
	meta:
		name = "__GI_iswprint"
		size = 24
		refs = "0000 _gp_disp 000c __GI_iswctype"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 08 00 05 24 }
	condition:
		$1
}

rule file_416_0_0 {
	meta:
		name = "__GI_iswpunct"
		size = 24
		refs = "0000 _gp_disp 000c __GI_iswctype"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 09 00 05 24 }
	condition:
		$1
}

rule file_47_0_0 {
	meta:
		name = "__GI_iswspace"
		size = 24
		refs = "0000 _gp_disp 000c __GI_iswctype"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 0A 00 05 24 }
	condition:
		$1
}

rule file_424_0_0 {
	meta:
		name = "__GI_iswupper"
		size = 24
		refs = "0000 _gp_disp 000c __GI_iswctype"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 0B 00 05 24 }
	condition:
		$1
}

rule file_404_0_0 {
	meta:
		name = "__GI_iswxdigit"
		size = 24
		refs = "0000 _gp_disp 000c __GI_iswctype"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 0C 00 05 24 }
	condition:
		$1
}

rule file_702_4_0 {
	meta:
		name = "__GI_setmntent"
		size = 24
		refs = "0000 _gp_disp 000c __GI_fopen"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_604_1_0 {
	meta:
		name = "__GI_sigpause"
		size = 24
		refs = "0000 _gp_disp 000c __GI___sigpause"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 21 28 00 00 }
	condition:
		$1
}

rule file_277_0_0 {
	meta:
		name = "__GI_strtol"
		size = 24
		refs = "0000 _gp_disp 000c _stdlib_strto_l"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 01 00 07 24 }
	condition:
		$1
}

rule file_267_0_0 {
	meta:
		name = "__GI_strtold"
		size = 24
		refs = "0000 _gp_disp 000c __strtofpmax"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 21 30 00 00 }
	condition:
		$1
}

rule file_574_0_0 {
	meta:
		name = "__GI_strtoll"
		size = 24
		refs = "0000 _gp_disp 000c _stdlib_strto_ll"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 01 00 07 24 }
	condition:
		$1
}

rule file_371_0_0 {
	meta:
		name = "__GI_strtoul"
		size = 24
		refs = "0000 _gp_disp 000c _stdlib_strto_l"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 21 38 00 00 }
	condition:
		$1
}

rule file_756_0_0 {
	meta:
		name = "__GI_strtoull"
		size = 24
		refs = "0000 _gp_disp 000c _stdlib_strto_ll"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 21 38 00 00 }
	condition:
		$1
}

rule file_532_0_0 {
	meta:
		name = "__GI_wcstol"
		size = 24
		refs = "0000 _gp_disp 000c _stdlib_wcsto_l"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 01 00 07 24 }
	condition:
		$1
}

rule file_808_0_0 {
	meta:
		name = "__GI_wcstold"
		size = 24
		refs = "0000 _gp_disp 000c __wcstofpmax"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 21 30 00 00 }
	condition:
		$1
}

rule file_625_0_0 {
	meta:
		name = "__GI_wcstoll"
		size = 24
		refs = "0000 _gp_disp 000c _stdlib_wcsto_ll"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 01 00 07 24 }
	condition:
		$1
}

rule file_734_0_0 {
	meta:
		name = "__GI_wcstoul"
		size = 24
		refs = "0000 _gp_disp 000c _stdlib_wcsto_l"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 21 38 00 00 }
	condition:
		$1
}

rule file_869_0_0 {
	meta:
		name = "__GI_wcstoull"
		size = 24
		refs = "0000 _gp_disp 000c _stdlib_wcsto_ll"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 21 38 00 00 }
	condition:
		$1
}

rule file_157_15_0 {
	meta:
		name = "__GI_xdr_enum"
		size = 24
		refs = "0000 _gp_disp 000c __GI_xdr_long"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_157_4_0 {
	meta:
		name = "__GI_xdr_int"
		size = 24
		refs = "0000 _gp_disp 000c __GI_xdr_long"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_157_6_0 {
	meta:
		name = "__GI_xdr_u_int"
		size = 24
		refs = "0000 _gp_disp 000c __GI_xdr_u_long"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_30_1_1 {
	meta:
		name = "__ieee754_lgamma"
		size = 24
		refs = "0000 _gp_disp 000c __ieee754_lgamma_r 0014 __GI_signgam"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? ?? ?? 86 8F }
	condition:
		$1
}

rule file_253_0_0 {
	meta:
		name = "__libc_sigaction"
		size = 24
		refs = "0000 _gp_disp 000c __syscall_rt_sigaction"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 10 00 07 24 }
	condition:
		$1
}

rule file_523_0_0 {
	meta:
		name = "__vfork"
		size = 24
		refs = "0000 _gp_disp 000c fork"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_392_0_0 {
	meta:
		name = "_flushlbf"
		size = 24
		refs = "0000 _gp_disp 000c __GI_fflush_unlocked 0014 _stdio_openlist"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? ?? ?? 84 8F }
	condition:
		$1
}

rule file_24_1_3 {
	meta:
		name = "acosl"
		size = 24
		refs = "0000 _gp_disp 000c acos"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_24_2_3 {
	meta:
		name = "asinl"
		size = 24
		refs = "0000 _gp_disp 000c asin"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_24_4_3 {
	meta:
		name = "atan2l"
		size = 24
		refs = "0000 _gp_disp 000c atan2"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_24_3_3 {
	meta:
		name = "atanl"
		size = 24
		refs = "0000 _gp_disp 000c atan"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_690_0_0 {
	meta:
		name = "atof"
		size = 24
		refs = "0000 _gp_disp 000c __GI_strtod"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 21 28 00 00 }
	condition:
		$1
}

rule file_24_5_3 {
	meta:
		name = "ceill"
		size = 24
		refs = "0000 _gp_disp 000c ceil"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_24_7_3 {
	meta:
		name = "coshl"
		size = 24
		refs = "0000 _gp_disp 000c cosh"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_24_6_3 {
	meta:
		name = "cosl"
		size = 24
		refs = "0000 _gp_disp 000c cos"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_24_8_3 {
	meta:
		name = "expl"
		size = 24
		refs = "0000 _gp_disp 000c exp"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_224_0_0 {
	meta:
		name = "flockfile"
		size = 24
		refs = "0000 _gp_disp 000c __pthread_mutex_lock"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 38 00 84 24 }
	condition:
		$1
}

rule file_24_9_3 {
	meta:
		name = "floorl"
		size = 24
		refs = "0000 _gp_disp 000c floor"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_24_10_3 {
	meta:
		name = "fmodl"
		size = 24
		refs = "0000 _gp_disp 000c fmod"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_24_11_3 {
	meta:
		name = "frexpl"
		size = 24
		refs = "0000 _gp_disp 000c frexp"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_789_0_0 {
	meta:
		name = "ftrylockfile"
		size = 24
		refs = "0000 _gp_disp 000c __pthread_mutex_trylock"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 38 00 84 24 }
	condition:
		$1
}

rule file_820_0_0 {
	meta:
		name = "funlockfile"
		size = 24
		refs = "0000 _gp_disp 000c __pthread_mutex_unlock"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 38 00 84 24 }
	condition:
		$1
}

rule file_702_3_0 {
	meta:
		name = "hasmntopt"
		size = 24
		refs = "0000 _gp_disp 000c __GI_strstr"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 0C 00 84 8C }
	condition:
		$1
}

rule file_24_14_3 {
	meta:
		name = "ldexpl"
		size = 24
		refs = "0000 _gp_disp 000c ldexp"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_24_16_3 {
	meta:
		name = "log10l"
		size = 24
		refs = "0000 _gp_disp 000c log10"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_24_15_3 {
	meta:
		name = "logl"
		size = 24
		refs = "0000 _gp_disp 000c log"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_140_0_0 {
	meta:
		name = "mkstemp"
		size = 24
		refs = "0000 _gp_disp 000c __gen_tempname"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 21 28 00 00 }
	condition:
		$1
}

rule file_682_0_0 {
	meta:
		name = "mkstemp64"
		size = 24
		refs = "0000 _gp_disp 000c __gen_tempname"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 01 00 05 24 }
	condition:
		$1
}

rule file_405_0_0 {
	meta:
		name = "mktime"
		size = 24
		refs = "0000 _gp_disp 000c _time_mktime"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 01 00 05 24 }
	condition:
		$1
}

rule file_24_18_3 {
	meta:
		name = "powl"
		size = 24
		refs = "0000 _gp_disp 000c pow"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_66_0_0 {
	meta:
		name = "rand"
		size = 24
		refs = "0000 _gp_disp 000c __GI_random"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_480_0_0 {
	meta:
		name = "sc_getc"
		size = 24
		refs = "0000 _gp_disp 000c __GI_getc_unlocked"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 08 00 84 8C }
	condition:
		$1
}

rule file_440_0_0 {
	meta:
		name = "siggetmask"
		size = 24
		refs = "0000 _gp_disp 000c __GI_sigblock"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 21 20 00 00 }
	condition:
		$1
}

rule file_24_20_3 {
	meta:
		name = "sinhl"
		size = 24
		refs = "0000 _gp_disp 000c sinh"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_24_19_3 {
	meta:
		name = "sinl"
		size = 24
		refs = "0000 _gp_disp 000c sin"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_24_12_3 {
	meta:
		name = "sqrtl"
		size = 24
		refs = "0000 _gp_disp 000c sqrt"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_50_0_0 {
	meta:
		name = "srand48"
		size = 24
		refs = "0000 _gp_disp 000c __GI_srand48_r 0014 __libc_drand48_data"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? ?? ?? 85 8F }
	condition:
		$1
}

rule file_150_9_0 {
	meta:
		name = "svcerr_weakauth"
		size = 24
		refs = "0000 _gp_disp 000c __GI_svcerr_auth"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 05 00 05 24 }
	condition:
		$1
}

rule file_24_22_3 {
	meta:
		name = "tanhl"
		size = 24
		refs = "0000 _gp_disp 000c tanh"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_24_21_3 {
	meta:
		name = "tanl"
		size = 24
		refs = "0000 _gp_disp 000c tan"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_2_3_2 {
	meta:
		name = "vfork"
		size = 24
		refs = "0000 _gp_disp 000c __fork"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_673_3_0 {
	meta:
		name = "xdr_des_block"
		size = 24
		refs = "0000 _gp_disp 000c __GI_xdr_opaque"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 08 00 06 24 }
	condition:
		$1
}

rule file_157_9_0 {
	meta:
		name = "xdr_longlong_t"
		size = 24
		refs = "0000 _gp_disp 000c __GI_xdr_hyper"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_157_18_0 {
	meta:
		name = "xdr_netobj"
		size = 32
		refs = "0000 _gp_disp 000c __GI_xdr_bytes"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F 21 30 A0 00 00 04 07 24 ?? ?? ?? ?? 04 00 A5 24 }
	condition:
		$1
}

rule file_157_10_0 {
	meta:
		name = "xdr_u_longlong_t"
		size = 24
		refs = "0000 _gp_disp 000c __GI_xdr_u_hyper"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_3_0_0 {
	meta:
		name = "getpeername"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 4B 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_4_0_0 {
	meta:
		name = "vwarn_work"
		size = 344
		refs = "0000 _gp_disp 0044 __GI___errno_location 005c __GI___xpg_strerror_r 0080 stderr 0090 __uclibc_progname 0094 _pthread_cleanup_push_defer 0098 __pthread_mutex_unlock 00b0 __pthread_mutex_lock 00c8 __GI_fprintf 00ec __GI_vfprintf 0120 _pthread_cleanup_pop_restore"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 78 FF BD 27 10 00 BC AF 80 00 B6 AF 78 00 B4 AF 74 00 B3 AF 84 00 BF AF 7C 00 B5 AF 70 00 B2 AF 6C 00 B1 AF 68 00 B0 AF 21 A0 80 00 21 B0 A0 00 0E 00 C0 10 18 00 B3 27 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F 00 00 44 8C 21 28 60 02 ?? ?? 99 8F ?? ?? ?? ?? 40 00 06 24 10 00 BC 8F ?? ?? 90 8F 03 00 00 10 ?? ?? 10 26 ?? ?? 90 8F ?? ?? 10 26 ?? ?? 91 8F 00 00 26 8E 34 00 D2 8C 0D 00 40 16 ?? ?? 82 8F ?? ?? 99 8F ?? ?? 85 8F 58 00 A4 27 ?? ?? ?? ?? 38 00 C6 24 10 00 BC 8F 00 00 24 8E ?? ?? 99 8F ?? ?? ?? ?? 38 00 84 24 10 00 BC 8F ?? ?? 82 8F ?? ?? 85 8F ?? ?? 95 8F 00 00 24 8E 00 00 46 8C 21 C8 A0 02 ?? ?? ?? ?? ?? ?? A5 24 08 00 80 12 10 00 BC 8F ?? ?? 82 8F ?? ?? 99 8F 21 28 80 02 00 00 44 8C 21 30 C0 02 ?? ?? ?? ?? FE FF 10 26 00 00 24 8E 21 28 00 02 21 C8 A0 02 ?? ?? ?? ?? 21 30 60 02 05 00 40 16 10 00 BC 8F ?? ?? 99 8F 58 00 A4 27 ?? ?? ?? ?? 01 00 05 24 84 00 BF 8F 80 00 B6 8F 7C 00 B5 8F 78 00 B4 8F 74 00 B3 8F 70 00 B2 8F 6C 00 B1 8F 68 00 B0 8F 08 00 E0 03 88 00 BD 27 }
	condition:
		$1
}

rule file_4_1_0 {
	meta:
		name = "__GI_vwarn"
		size = 28
		refs = "0000 _gp_disp 0014 vwarn_work"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? 39 27 ?? ?? ?? ?? 01 00 06 24 }
	condition:
		$1
}

rule file_4_2_0 {
	meta:
		name = "warn"
		size = 68
		refs = "0000 _gp_disp 0010 __GI_vwarn"
		altNames = "warnx"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D8 FF BD 27 ?? ?? 99 8F 2C 00 A5 AF 2C 00 A5 27 24 00 BF AF 10 00 BC AF 30 00 A6 AF 34 00 A7 AF 18 00 A5 AF ?? ?? ?? ?? 00 00 00 00 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_4_3_0 {
	meta:
		name = "__GI_vwarnx"
		size = 28
		refs = "0000 _gp_disp 0014 vwarn_work"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? 39 27 ?? ?? ?? ?? 21 30 00 00 }
	condition:
		$1
}

rule file_4_5_0 {
	meta:
		name = "__GI_verr"
		size = 64
		refs = "0000 _gp_disp 000c __GI_vwarn 0034 __GI_exit"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F E0 FF BD 27 10 00 BC AF 18 00 B0 AF 1C 00 BF AF 21 80 80 00 21 20 A0 00 ?? ?? ?? ?? 21 28 C0 00 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 00 02 }
	condition:
		$1
}

rule file_4_7_0 {
	meta:
		name = "__GI_verrx"
		size = 64
		refs = "0000 _gp_disp 000c __GI_vwarnx 0034 __GI_exit"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F E0 FF BD 27 10 00 BC AF 18 00 B0 AF 1C 00 BF AF 21 80 80 00 21 20 A0 00 ?? ?? ?? ?? 21 28 C0 00 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 00 02 }
	condition:
		$1
}

rule file_4_6_0 {
	meta:
		name = "err"
		size = 52
		refs = "0000 _gp_disp 0010 __GI_verr"
		altNames = "errx"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D8 FF BD 27 ?? ?? 99 8F 30 00 A6 AF 30 00 A6 27 10 00 BC AF 24 00 BF AF 34 00 A7 AF 18 00 A6 AF ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_5_0_0 {
	meta:
		name = "__GI_vswscanf"
		size = 172
		refs = "0000 _gp_disp 000c __GI_wcslen 0054 __stdio_init_mutex 008c __GI_vfwscanf"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F 88 FF BD 27 74 00 BF AF 70 00 B0 AF 10 00 BC AF 68 00 A5 AF 6C 00 A6 AF 28 00 A4 AF 20 00 A4 AF ?? ?? ?? ?? 21 80 80 00 80 10 02 00 10 00 BC 8F 21 10 02 02 24 00 A2 AF 2C 00 A2 AF FD FF 02 24 1C 00 A2 AF ?? ?? 99 8F 21 08 02 24 18 00 A2 A7 01 00 02 24 30 00 B0 AF 34 00 B0 AF 4C 00 A2 AF 50 00 A4 27 1A 00 A0 A3 ?? ?? ?? ?? 44 00 A0 AF 10 00 BC 8F 68 00 A5 8F 6C 00 A6 8F ?? ?? 99 8F 18 00 A4 27 ?? ?? ?? ?? 38 00 A0 AF 74 00 BF 8F 70 00 B0 8F 08 00 E0 03 78 00 BD 27 }
	condition:
		$1
}

rule file_6_0_0 {
	meta:
		name = "__GI_settimeofday"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF EF 0F 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_7_0_0 {
	meta:
		name = "fsetpos64"
		size = 216
		refs = "0000 _gp_disp 0038 _pthread_cleanup_push_defer 003c __pthread_mutex_unlock 0054 __pthread_mutex_lock 0064 __GI_fseeko64 00a4 _pthread_cleanup_pop_restore"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 B0 FF BD 27 40 00 B1 AF 3C 00 B0 AF 18 00 BC AF 4C 00 BF AF 48 00 B3 AF 44 00 B2 AF 34 00 92 8C 21 80 80 00 0C 00 40 16 21 88 A0 00 ?? ?? 99 8F ?? ?? 85 8F 38 00 93 24 21 30 60 02 ?? ?? ?? ?? 20 00 A4 27 18 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 60 02 18 00 BC 8F ?? ?? 99 8F 00 00 26 8E 04 00 27 8E 10 00 A0 AF ?? ?? ?? ?? 21 20 00 02 07 00 40 14 18 00 BC 8F 08 00 23 8E 2C 00 03 AE 0C 00 23 8E 30 00 03 AE 10 00 23 8E 02 00 03 A2 08 00 40 16 4C 00 BF 8F ?? ?? 99 8F 30 00 A2 AF 20 00 A4 27 ?? ?? ?? ?? 01 00 05 24 30 00 A2 8F 4C 00 BF 8F 48 00 B3 8F 44 00 B2 8F 40 00 B1 8F 3C 00 B0 8F 08 00 E0 03 50 00 BD 27 }
	condition:
		$1
}

rule file_8_0_0 {
	meta:
		name = "timegm"
		size = 128
		refs = "0000 _gp_disp 0010 __GI_memset 0048 __GI_strcpy 0044 $LC0 0060 _time_mktime_tzi"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 A8 FF BD 27 ?? ?? 99 8F 4C 00 B0 AF 18 00 B0 27 54 00 BF AF 50 00 B1 AF 10 00 BC AF 21 88 80 00 30 00 06 24 21 20 00 02 ?? ?? ?? ?? 21 28 00 00 10 00 BC 8F 28 00 A4 27 ?? ?? 85 8F ?? ?? 99 8F ?? ?? ?? ?? ?? ?? A5 24 10 00 BC 8F 21 20 20 02 21 30 00 02 ?? ?? 99 8F ?? ?? ?? ?? 01 00 05 24 54 00 BF 8F 50 00 B1 8F 4C 00 B0 8F 08 00 E0 03 58 00 BD 27 }
	condition:
		$1
}

rule file_9_0_0 {
	meta:
		name = "__GI_fileno_unlocked"
		size = 72
		refs = "0000 _gp_disp 0014 __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 04 00 82 8C 0B 00 41 04 ?? ?? 99 8F E0 FF BD 27 1C 00 BF AF 10 00 BC AF ?? ?? ?? ?? 00 00 00 00 09 00 03 24 00 00 43 AC 1C 00 BF 8F FF FF 02 24 20 00 BD 27 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_10_0_0 {
	meta:
		name = "sc_getc"
		size = 188
		refs = "0000 _gp_disp 0030 __GI_fgetwc_unlocked"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 18 00 B0 AF 10 00 BC AF 1C 00 BF AF 21 80 80 00 08 00 84 8C FD FF 02 24 04 00 83 8C 0D 00 62 14 ?? ?? 99 8F 10 00 83 8C 0C 00 82 8C 2B 10 62 00 05 00 40 50 00 00 82 94 00 00 62 8C 04 00 63 24 09 00 00 10 10 00 83 AC 04 00 42 34 12 00 00 10 00 00 82 A4 ?? ?? ?? ?? 00 00 00 00 FF FF 03 24 0E 00 43 50 FF FF 02 24 01 00 03 24 1A 00 03 A2 08 00 03 8E 28 00 02 AE 02 00 63 90 18 00 03 A2 38 00 03 8E 05 00 43 50 2E 00 02 24 04 00 02 AE 02 00 00 10 24 00 02 AE FF FF 02 24 1C 00 BF 8F 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_10_1_0 {
	meta:
		name = "scan_getwc"
		size = 236
		refs = "0000 _gp_disp 0058 __GI_fgetwc_unlocked"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D8 FF BD 27 20 00 B1 AF 1C 00 B0 AF 10 00 BC AF 24 00 BF AF 10 00 82 8C FF FF 11 24 21 80 80 00 FF FF 42 24 24 00 91 AC 19 00 40 04 10 00 82 AC 19 00 82 80 1F 00 40 54 19 00 80 A0 08 00 84 8C FD FF 02 24 04 00 83 8C 0D 00 62 14 ?? ?? 99 8F 10 00 83 8C 0C 00 82 8C 2B 10 62 00 05 00 40 50 02 00 02 24 00 00 62 8C 04 00 63 24 0B 00 00 10 10 00 83 AC 19 00 02 A2 14 00 00 10 FF FF 02 24 ?? ?? ?? ?? 00 00 00 00 05 00 51 54 04 00 02 AE 19 00 02 92 F7 FF 00 10 02 00 42 34 04 00 02 AE 08 00 02 8E 01 00 03 24 1A 00 03 A2 02 00 42 90 18 00 02 A2 0C 00 02 8E 01 00 42 24 0C 00 02 AE 04 00 02 8E 24 00 02 AE 21 10 00 00 24 00 BF 8F 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_10_2_0 {
	meta:
		name = "__GI_vfwscanf"
		size = 2008
		refs = "0000 _gp_disp 0010 __GI_memset 0078 _pthread_cleanup_push_defer 007c __pthread_mutex_unlock 0094 __pthread_mutex_lock 00a4 __init_scan_cookie 00dc $LC0 00fc __GI_iswspace 01cc __psfs_parse_spec 0270 __scan_getc 029c __scan_ungetc 02ec _store_inttype 0310 __psfs_do_numeric 03c4 scan_getwc 03f4 __GI_wcrtomb 0754 __GI_ungetwc 0794 _pthread_cleanup_pop_restore"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 C8 FE BD 27 ?? ?? 99 8F FF FF 02 24 28 01 B6 AF 18 00 B6 27 10 00 BC AF 24 01 B5 AF 20 01 B4 AF 14 01 B1 AF 21 A8 80 00 34 01 BF AF 30 01 BE AF 2C 01 B7 AF 1C 01 B3 AF 18 01 B2 AF 10 01 B0 AF 21 88 A0 00 21 A0 C0 00 3C 00 A2 AF 21 20 C0 02 21 28 00 00 ?? ?? ?? ?? 24 00 06 24 34 00 A3 8E 10 00 BC 8F 0C 00 60 14 04 01 A3 AF ?? ?? 99 8F ?? ?? 85 8F 38 00 B0 26 E4 00 A4 27 ?? ?? ?? ?? 21 30 00 02 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 00 02 10 00 BC 8F ?? ?? 99 8F A4 00 B3 27 21 20 60 02 ?? ?? ?? ?? 21 28 A0 02 10 00 BC 8F 01 00 12 24 ?? ?? 82 8F ?? ?? 42 24 D0 00 A2 AF AC 00 A2 8F 03 00 42 90 4C 00 A0 AF BC 00 A2 A3 ?? ?? 82 8F ?? ?? 42 24 E0 00 A2 AF 00 00 37 8E 7D 01 E0 12 01 00 02 24 5C 00 A2 A3 BD 00 A2 93 ?? ?? 90 8F FF 7F 19 3C FF FF 39 37 01 00 42 30 58 00 B9 AF B4 00 B9 AF 5D 00 A0 A3 BD 00 A2 A3 21 C8 00 02 ?? ?? ?? ?? 21 20 E0 02 0D 00 40 10 10 00 BC 8F ?? ?? 99 8F 04 00 24 8E ?? ?? ?? ?? 04 00 30 26 03 00 40 10 10 00 BC 8F F9 FF 00 10 21 88 00 02 17 00 02 24 54 00 A2 AF 45 00 00 10 21 80 20 02 25 00 02 24 4D 01 E2 16 21 80 20 02 04 00 22 8E 04 00 57 14 04 00 30 26 16 00 02 24 35 00 00 10 54 00 A2 AF 60 00 A3 27 48 00 A3 AF 21 20 00 02 21 10 60 00 80 FF 08 24 A2 00 A7 27 00 00 85 8C 08 00 A0 10 24 30 A8 00 06 00 C0 14 2B 30 47 00 04 00 C0 10 04 00 84 24 00 00 45 A0 F7 FF 00 10 01 00 42 24 48 01 43 10 00 00 40 A0 ?? ?? 99 8F ?? ?? ?? ?? 21 20 C0 02 43 01 40 04 10 00 BC 8F 80 10 02 00 21 80 02 02 5C 00 A2 93 1A 00 40 10 54 00 A2 8F 3C 00 A3 8F FE FF 02 24 07 00 62 14 40 00 A2 8F 00 00 82 8E 04 00 94 26 11 00 00 10 44 00 A2 AF 40 00 A2 8F 3C 00 A3 8F 2A 20 62 00 08 00 80 10 01 00 63 24 00 00 82 8E 3C 00 A3 AF 80 18 03 00 21 18 C3 02 00 00 62 AC F5 FF 00 10 04 00 94 26 80 10 02 00 21 10 C2 02 00 00 42 8C 44 00 A2 AF 54 00 A2 8F 2D 00 03 3C 01 00 63 34 07 10 43 00 01 00 42 30 14 00 40 14 58 00 A4 8F ?? ?? 91 8F 21 C8 20 02 ?? ?? ?? ?? 21 20 60 02 06 00 40 04 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? C8 00 A4 8F F7 FF 40 14 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 60 02 54 00 A3 8F 17 00 02 24 08 01 62 10 10 00 BC 8F 58 00 A4 8F 0A 01 80 10 B4 00 A4 AF 54 00 A2 8F 16 00 03 24 F4 00 43 10 ?? ?? 99 8F 0C 00 40 14 10 00 43 28 5C 00 A2 93 FD 00 40 50 00 00 A2 96 B0 00 A6 8F ?? ?? 99 8F 44 00 A4 8F 50 00 A5 8F ?? ?? ?? ?? C3 3F 06 00 F4 00 00 10 10 00 BC 8F 13 00 60 10 13 00 43 28 ?? ?? 99 8F 21 20 C0 02 ?? ?? ?? ?? 21 28 60 02 BE 00 A4 83 01 00 03 24 04 00 83 14 10 00 BC 8F CC 00 A3 8F A8 00 A3 AF A4 00 A3 AF FF FF 03 24 EA 00 43 50 00 00 A2 96 E2 00 41 04 21 90 00 00 E6 00 00 10 00 00 A2 96 08 00 60 14 5C 00 A5 93 44 00 A6 8F 60 00 BE 27 F4 00 A0 AF 0B F0 C5 00 FC 00 B1 27 07 00 00 10 13 00 05 24 44 00 A3 8F FC 00 B1 27 0B 88 65 00 60 00 A3 27 10 00 05 24 21 F0 60 00 2A 00 45 54 11 00 04 24 FF 7F 02 3C FF FF 42 34 03 00 82 14 F4 00 A3 27 01 00 02 24 B4 00 A2 AF 10 00 17 24 00 01 A3 AF ?? ?? 82 8F ?? ?? 59 24 ?? ?? ?? ?? 21 20 60 02 14 00 40 04 10 00 BC 8F 54 00 A2 8F 06 00 57 14 C8 00 A5 8F 00 00 25 AE 5C 00 A2 93 80 10 02 00 0A 00 00 10 21 88 22 02 ?? ?? 99 8F 21 20 C0 03 ?? ?? ?? ?? F4 00 A6 27 AD 00 40 04 10 00 BC 8F 5C 00 A4 93 21 10 C2 03 0B F0 44 00 E8 FF 00 10 21 90 00 00 ?? ?? 99 8F ?? ?? ?? ?? 21 20 60 02 B4 00 A2 8F 95 00 40 18 10 00 BC 8F AC 00 00 10 00 00 A2 96 03 00 44 10 14 00 04 24 25 00 44 54 04 00 04 8E F4 00 A3 27 01 00 17 24 00 01 A3 AF ?? ?? 82 8F ?? ?? 59 24 ?? ?? ?? ?? 21 20 60 02 7F 00 40 04 10 00 BC 8F C8 00 B2 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 40 02 78 00 40 14 10 00 BC 8F 54 00 A2 8F 11 00 03 24 06 00 43 14 ?? ?? 99 8F 00 00 32 AE 5C 00 A2 93 80 10 02 00 0A 00 00 10 21 88 22 02 21 20 C0 03 21 28 40 02 ?? ?? ?? ?? F4 00 A6 27 7E 00 40 04 10 00 BC 8F 5C 00 A4 93 21 10 C2 03 0B F0 44 00 21 B8 00 00 E0 FF 00 10 21 90 00 00 5E 00 02 24 03 00 82 10 04 00 07 26 04 00 00 10 00 01 A0 AF 01 00 03 24 08 00 07 26 00 01 A3 AF 00 00 E2 8C 04 00 F0 24 5D 00 04 24 5D 00 42 38 0B 80 E2 00 2D 00 05 24 00 00 02 8E 0E 00 44 10 F4 00 B9 27 71 00 40 50 00 00 A2 96 FA FF 45 54 04 00 10 26 04 00 02 8E F7 FF 44 50 04 00 10 26 FC FF 06 8E 2B 10 C2 00 04 00 06 26 0B 80 C2 00 F1 FF 00 10 04 00 10 26 01 00 17 24 08 01 B9 AF ?? ?? 82 8F 0C 01 A7 AF ?? ?? 59 24 ?? ?? ?? ?? 21 20 60 02 10 00 BC 8F 3C 00 40 04 0C 01 A7 8F 21 10 E0 00 00 00 46 8C 2D 00 03 24 13 00 C3 14 C8 00 A5 8F 2B 20 E2 00 10 00 80 10 04 00 44 24 2B 40 90 00 0D 00 00 11 00 00 00 00 FC FF 49 8C 04 00 48 8C 2A 50 28 01 08 00 40 11 2B 48 A9 00 0A 00 20 15 04 00 82 24 2B 40 05 01 0C 00 00 51 21 10 80 00 06 00 00 10 2B 20 50 00 09 00 A6 10 00 01 B9 8F 21 20 40 00 04 00 82 24 2B 20 50 00 E5 FF 80 54 00 00 46 8C 02 00 00 10 00 01 B9 8F 00 01 B9 8F 26 10 50 00 01 00 42 2C 16 00 59 14 54 00 A2 8F 12 00 03 24 06 00 43 14 ?? ?? 99 8F 00 00 25 AE 5C 00 A2 93 80 10 02 00 0B 00 00 10 21 88 22 02 0C 01 A7 AF 21 20 C0 03 ?? ?? ?? ?? F4 00 A6 27 10 00 BC 8F 1C 00 40 04 0C 01 A7 8F 5C 00 A4 93 21 10 C2 03 0B F0 44 00 21 B8 00 00 BF FF 00 10 21 90 00 00 21 90 00 00 ?? ?? 99 8F ?? ?? ?? ?? 21 20 60 02 1B 00 E0 16 10 00 BC 8F 00 00 20 AE 00 00 C0 A3 4C 00 A3 8F 5C 00 A2 93 21 10 62 00 0F 00 00 10 4C 00 A2 AF ?? ?? 99 8F ?? ?? ?? ?? 21 20 60 02 00 00 03 8E 09 00 43 10 10 00 BC 8F 03 00 00 10 ?? ?? 99 8F 21 90 00 00 ?? ?? 99 8F ?? ?? ?? ?? 21 20 60 02 06 00 00 10 10 00 BC 8F 00 00 A2 96 08 00 42 30 82 FE 40 10 04 00 11 26 21 80 20 02 00 00 A2 96 08 00 43 30 0A 00 60 54 FF FF 02 24 00 00 03 8E 09 00 60 50 BD 00 A2 93 07 00 40 52 BD 00 A2 93 04 00 42 30 04 00 40 10 BD 00 A2 93 FF FF 02 24 4C 00 A2 AF BD 00 A2 93 01 00 42 30 17 00 40 10 BE 00 A2 93 01 00 42 30 14 00 40 10 AC 00 A5 8F FD FF 02 24 04 00 A3 8C 11 00 62 10 04 01 A3 8F 2C 00 A2 8C 0E 00 40 14 ?? ?? 99 8F ?? ?? ?? ?? A8 00 A4 8F B0 00 A3 8F 10 00 BC 8F 04 00 60 14 AC 00 A2 8F B8 00 A3 8F 02 00 00 10 28 00 43 AC 28 00 40 AC BC 00 A3 93 03 00 43 A0 04 01 A3 8F 06 00 60 14 34 01 BF 8F ?? ?? 99 8F E4 00 A4 27 ?? ?? ?? ?? 01 00 05 24 34 01 BF 8F 4C 00 A2 8F 30 01 BE 8F 2C 01 B7 8F 28 01 B6 8F 24 01 B5 8F 20 01 B4 8F 1C 01 B3 8F 18 01 B2 8F 14 01 B1 8F 10 01 B0 8F 08 00 E0 03 38 01 BD 27 }
	condition:
		$1
}

rule file_11_0_0 {
	meta:
		name = "vwscanf"
		size = 40
		refs = "0000 _gp_disp 000c stdin 0014 __GI_vfwscanf"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 83 8F 21 10 80 00 ?? ?? 99 8F 00 00 64 8C 21 30 A0 00 ?? ?? ?? ?? 21 28 40 00 }
	condition:
		$1
}

rule file_266_0_0 {
	meta:
		name = "__GI_vscanf"
		size = 40
		refs = "0000 _gp_disp 000c stdin 0014 __GI_vfscanf"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 83 8F 21 10 80 00 ?? ?? 99 8F 00 00 64 8C 21 30 A0 00 ?? ?? ?? ?? 21 28 40 00 }
	condition:
		$1
}

rule file_706_0_0 {
	meta:
		name = "vprintf"
		size = 40
		refs = "0000 _gp_disp 000c stdout 0014 __GI_vfprintf"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 83 8F 21 10 80 00 ?? ?? 99 8F 00 00 64 8C 21 30 A0 00 ?? ?? ?? ?? 21 28 40 00 }
	condition:
		$1
}

rule file_487_0_0 {
	meta:
		name = "vwprintf"
		size = 40
		refs = "0000 _gp_disp 000c stdout 0014 __GI_vfwprintf"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 83 8F 21 10 80 00 ?? ?? 99 8F 00 00 64 8C 21 30 A0 00 ?? ?? ?? ?? 21 28 40 00 }
	condition:
		$1
}

rule file_12_0_0 {
	meta:
		name = "getgrent"
		size = 72
		refs = "0000 _gp_disp 0014 __GI_getgrent_r"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 84 8F ?? ?? 85 8F ?? ?? 99 8F D8 FF BD 27 18 00 A7 27 ?? ?? 84 24 24 00 BF AF 10 00 BC AF ?? ?? A5 24 ?? ?? ?? ?? 00 01 06 24 24 00 BF 8F 18 00 A2 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_810_0_0 {
	meta:
		name = "getpwent"
		size = 72
		refs = "0000 _gp_disp 0014 __GI_getpwent_r"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 84 8F ?? ?? 85 8F ?? ?? 99 8F D8 FF BD 27 18 00 A7 27 ?? ?? 84 24 24 00 BF AF 10 00 BC AF ?? ?? A5 24 ?? ?? ?? ?? 00 01 06 24 24 00 BF 8F 18 00 A2 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_683_0_0 {
	meta:
		name = "getspent"
		size = 72
		refs = "0000 _gp_disp 0014 __GI_getspent_r"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 84 8F ?? ?? 85 8F ?? ?? 99 8F D8 FF BD 27 18 00 A7 27 ?? ?? 84 24 24 00 BF AF 10 00 BC AF ?? ?? A5 24 ?? ?? ?? ?? 00 01 06 24 24 00 BF 8F 18 00 A2 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_14_0_0 {
	meta:
		name = "__GI_strchr"
		size = 264
	strings:
		$1 = { FF 00 A2 30 03 00 83 30 08 00 60 50 FF 00 A5 30 00 00 83 90 37 00 62 10 00 00 00 00 37 00 60 10 01 00 84 24 F8 FF 00 10 03 00 83 30 00 1A 05 00 25 28 65 00 00 1C 05 00 FE 7E 06 3C 01 81 09 3C 25 28 65 00 FF FE C6 34 00 01 29 25 00 00 83 8C 26 38 65 00 27 50 07 00 21 38 E6 00 26 38 47 01 27 50 03 00 21 18 66 00 26 18 43 01 25 18 E3 00 24 18 69 00 03 00 60 14 04 00 88 24 F3 FF 00 10 21 20 00 01 00 00 83 90 1A 00 62 10 00 00 00 00 1B 00 60 50 21 10 00 00 01 00 83 90 03 00 62 14 00 00 00 00 08 00 E0 03 01 00 82 24 14 00 60 50 21 10 00 00 02 00 83 90 03 00 62 14 00 00 00 00 08 00 E0 03 02 00 82 24 0D 00 60 50 21 10 00 00 03 00 83 90 03 00 62 14 00 00 00 00 08 00 E0 03 03 00 82 24 D9 FF 60 14 21 20 00 01 08 00 E0 03 21 10 00 00 08 00 E0 03 21 10 80 00 21 10 00 00 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_15_0_0 {
	meta:
		name = "rpc_thread_multi"
		size = 56
		refs = "0000 _gp_disp 000c __pthread_internal_tsd_set 0028 __libc_tsd_RPC_VARS_data"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F 05 00 40 10 ?? ?? 85 8F ?? ?? 99 8F 02 00 04 24 ?? ?? ?? ?? ?? ?? A5 24 ?? ?? 82 8F ?? ?? A5 24 08 00 E0 03 00 00 45 AC }
	condition:
		$1
}

rule file_15_1_0 {
	meta:
		name = "__rpc_thread_destroy"
		size = 288
		refs = "0000 _gp_disp 000c __pthread_internal_tsd_get 003c __libc_tsd_RPC_VARS_data 0054 __rpc_thread_svc_cleanup 0064 __rpc_thread_clnt_cleanup 0074 free 00e4 __pthread_internal_tsd_set"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 06 00 40 10 ?? ?? 99 8F ?? ?? ?? ?? 02 00 04 24 10 00 BC 8F 03 00 00 10 21 80 40 00 ?? ?? 82 8F 00 00 50 8C 32 00 00 12 ?? ?? 82 8F ?? ?? 42 24 2F 00 02 12 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 98 00 04 8E 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 9C 00 04 8E 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? A0 00 04 8E 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? BC 00 04 8E 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? AC 00 04 8E 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? B0 00 04 8E 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 00 02 10 00 BC 8F ?? ?? 82 8F 07 00 40 10 1C 00 BF 8F 18 00 B0 8F ?? ?? 99 8F 02 00 04 24 21 28 00 00 ?? ?? ?? ?? 20 00 BD 27 ?? ?? 82 8F 00 00 40 AC 1C 00 BF 8F 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_15_2_0 {
	meta:
		name = "__rpc_thread_variables"
		size = 336
		refs = "0000 _gp_disp 0014 __pthread_internal_tsd_get 0040 __libc_tsd_RPC_VARS_data 0050 __pthread_once 0088 rpc_thread_multi 00c8 calloc 00e4 __pthread_internal_tsd_set"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D8 FF BD 27 20 00 B1 AF ?? ?? 91 8F 10 00 BC AF 24 00 BF AF 1C 00 B0 AF 06 00 20 12 ?? ?? 99 8F ?? ?? ?? ?? 02 00 04 24 10 00 BC 8F 03 00 00 10 21 80 40 00 ?? ?? 82 8F 00 00 50 8C 3C 00 00 16 24 00 BF 8F ?? ?? 82 8F 08 00 40 10 ?? ?? 90 8F ?? ?? 85 8F ?? ?? 99 8F ?? ?? 04 26 ?? ?? ?? ?? ?? ?? A5 24 0A 00 00 10 10 00 BC 8F ?? ?? 02 8E 07 00 40 14 ?? ?? 99 8F ?? ?? 39 27 ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F 01 00 02 24 ?? ?? 02 AE 06 00 20 12 ?? ?? 99 8F ?? ?? ?? ?? 02 00 04 24 10 00 BC 8F 03 00 00 10 21 80 40 00 ?? ?? 82 8F 00 00 50 8C 1E 00 00 16 24 00 BF 8F ?? ?? 99 8F 01 00 04 24 ?? ?? ?? ?? C8 00 05 24 10 00 BC 8F 0C 00 40 10 21 80 40 00 ?? ?? 82 8F 06 00 40 10 ?? ?? 99 8F 02 00 04 24 ?? ?? ?? ?? 21 28 00 02 0F 00 00 10 24 00 BF 8F ?? ?? 82 8F 0B 00 00 10 00 00 50 AC 07 00 20 12 24 00 BF 8F 20 00 B1 8F 1C 00 B0 8F ?? ?? 99 8F 02 00 04 24 ?? ?? ?? ?? 28 00 BD 27 ?? ?? 82 8F 00 00 50 8C 24 00 BF 8F 21 10 00 02 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_15_3_0 {
	meta:
		name = "__GI___rpc_thread_svc_fdset"
		size = 72
		refs = "0000 _gp_disp 000c __rpc_thread_variables 0034 svc_fdset"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F E0 FF BD 27 1C 00 BF AF 10 00 BC AF ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F 1C 00 BF 8F 20 00 BD 27 ?? ?? 84 8F ?? ?? 83 8F ?? ?? 84 24 26 20 44 00 08 00 E0 03 0A 10 64 00 }
	condition:
		$1
}

rule file_15_4_0 {
	meta:
		name = "__GI___rpc_thread_createerr"
		size = 80
		refs = "0000 _gp_disp 000c __rpc_thread_variables 0040 rpc_createerr"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F E0 FF BD 27 1C 00 BF AF 10 00 BC AF ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F 80 00 44 24 1C 00 BF 8F ?? ?? 83 8F 20 00 BD 27 ?? ?? 63 24 26 10 43 00 ?? ?? 83 8F 0B 18 82 00 08 00 E0 03 21 10 60 00 }
	condition:
		$1
}

rule file_15_5_0 {
	meta:
		name = "__GI___rpc_thread_svc_pollfd"
		size = 80
		refs = "0000 _gp_disp 000c __rpc_thread_variables 0040 svc_pollfd"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F E0 FF BD 27 1C 00 BF AF 10 00 BC AF ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F 90 00 44 24 1C 00 BF 8F ?? ?? 83 8F 20 00 BD 27 ?? ?? 63 24 26 10 43 00 ?? ?? 83 8F 0B 18 82 00 08 00 E0 03 21 10 60 00 }
	condition:
		$1
}

rule file_15_6_0 {
	meta:
		name = "__GI___rpc_thread_svc_max_pollfd"
		size = 80
		refs = "0000 _gp_disp 000c __rpc_thread_variables 0040 svc_max_pollfd"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F E0 FF BD 27 1C 00 BF AF 10 00 BC AF ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F 94 00 44 24 1C 00 BF 8F ?? ?? 83 8F 20 00 BD 27 ?? ?? 63 24 26 10 43 00 ?? ?? 83 8F 0B 18 82 00 08 00 E0 03 21 10 60 00 }
	condition:
		$1
}

rule file_16_0_0 {
	meta:
		name = "__GI_strlen"
		size = 156
	strings:
		$1 = { 21 10 80 00 03 00 43 30 06 00 60 10 FE FE 06 3C 00 00 43 80 10 00 60 10 00 00 00 00 F9 FF 00 10 01 00 42 24 80 80 07 3C FF FE C6 34 80 80 E7 34 00 00 43 8C 21 18 66 00 24 18 67 00 03 00 60 14 04 00 45 24 FA FF 00 10 21 10 A0 00 00 00 43 80 03 00 60 54 01 00 43 80 08 00 E0 03 23 10 44 00 04 00 60 54 02 00 43 80 23 10 44 00 08 00 E0 03 01 00 42 24 04 00 60 54 03 00 43 80 23 10 44 00 08 00 E0 03 02 00 42 24 E9 FF 60 54 21 10 A0 00 23 10 44 00 08 00 E0 03 03 00 42 24 }
	condition:
		$1
}

rule file_17_0_0 {
	meta:
		name = "__libc_getpid"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF B4 0F 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_19_0_0 {
	meta:
		name = "_fpmaxtostr"
		size = 2288
		refs = "0000 _gp_disp 00a8 __nedf2 00e8 __eqdf2 010c __divdf3 0108 $LC0 0130 __ltdf2 0188 __muldf3 0184 $LC1 020c $LC2 02a4 $LC3 0310 __gedf2 037c $LC4 03b0 __fixunsdfsi 03c8 __floatunsidf 03e0 __subdf3"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 10 FF BD 27 D8 00 B4 AF 00 01 B4 8F D4 00 B3 AF CC 00 B1 AF C8 00 B0 AF 10 00 BC AF EC 00 BF AF E8 00 BE AF E4 00 B7 AF E0 00 B6 AF DC 00 B5 AF D0 00 B2 AF 08 00 82 8E 04 00 99 8E 65 00 03 24 20 9C 02 7C F0 00 A4 AF 90 00 A3 A3 20 00 64 36 61 00 03 24 21 88 C0 00 21 80 E0 00 AC 00 B9 AF 03 00 83 14 00 00 92 8E 06 00 53 24 20 9C 13 7C 00 00 43 2A 06 00 02 24 0B 90 43 00 0C 00 82 8E 02 00 43 30 03 00 60 10 A0 00 A0 A3 05 00 00 10 2B 00 02 24 01 00 42 30 04 00 40 10 ?? ?? 99 8F 20 00 02 24 A0 00 A2 A3 ?? ?? 99 8F A1 00 A0 A3 2C 00 A0 AF 21 20 20 02 21 28 00 02 21 30 20 02 ?? ?? ?? ?? 21 38 00 02 04 00 40 10 10 00 BC 8F 08 00 02 24 38 00 00 10 2C 00 A2 AF ?? ?? 99 8F 21 20 20 02 21 28 00 02 21 30 00 00 ?? ?? ?? ?? 21 38 00 00 14 00 40 14 10 00 BC 8F ?? ?? 82 8F ?? ?? 99 8F 21 30 20 02 ?? ?? 44 8C ?? ?? 45 8C ?? ?? ?? ?? 21 38 00 02 10 00 BC 8F 21 20 40 00 21 28 60 00 ?? ?? 99 8F 21 30 00 00 ?? ?? ?? ?? 21 38 00 00 9A 00 41 04 10 00 BC 8F 2D 00 02 24 97 00 00 10 A0 00 A2 A3 ?? ?? 99 8F 21 20 20 02 21 28 00 02 21 30 00 00 ?? ?? ?? ?? 21 38 00 00 05 00 41 04 10 00 BC 8F 2D 00 02 24 A0 00 A2 A3 00 80 02 3C 26 80 50 00 ?? ?? 82 8F ?? ?? 99 8F 21 20 20 02 ?? ?? 46 8C ?? ?? 47 8C ?? ?? ?? ?? 21 28 00 02 10 00 BC 8F 21 20 20 02 21 28 00 02 ?? ?? 99 8F 21 30 40 00 ?? ?? ?? ?? 21 38 60 00 13 00 40 14 10 00 BC 8F 20 00 02 24 10 00 82 AE 70 00 02 24 24 00 A2 AF 61 00 73 2A 03 00 02 24 04 00 60 12 28 00 A2 AF 2C 00 A2 8F 04 00 42 24 2C 00 A2 AF ?? ?? 82 8F 2C 00 A3 8F 30 00 B0 27 ?? ?? 42 24 21 10 43 00 75 01 00 10 2C 00 A2 AF ?? ?? 82 8F 09 00 19 24 A8 00 B9 AF ?? ?? 59 8C ?? ?? 42 8C 21 B0 20 02 21 A8 00 02 00 01 17 24 08 00 1E 24 B0 00 B9 AF B4 00 A2 AF B8 00 B9 AF BC 00 A2 AF A8 00 B9 8F B0 00 A6 8F B4 00 A7 8F FF FF 39 27 A8 00 B9 AF ?? ?? 99 8F 21 20 20 02 ?? ?? ?? ?? 21 28 00 02 A8 00 B9 8F 10 00 BC 8F 1C 00 41 04 C0 18 19 00 ?? ?? 82 8F ?? ?? 99 8F 21 20 C0 02 ?? ?? 42 24 21 18 43 00 00 00 66 8C 04 00 67 8C ?? ?? ?? ?? 21 28 A0 02 10 00 BC 8F 21 58 40 00 21 20 40 00 ?? ?? 82 8F ?? ?? 99 8F 21 28 60 00 ?? ?? 42 24 00 00 46 8C 04 00 47 8C C4 00 A3 AF ?? ?? ?? ?? C0 00 AB AF 10 00 BC 8F C4 00 A3 8F 1C 00 41 04 C0 00 AB 8F 18 00 00 10 23 F0 D7 03 ?? ?? 84 8F ?? ?? 99 8F 21 28 A0 02 ?? ?? 84 24 21 18 83 00 00 00 66 8C 04 00 67 8C ?? ?? ?? ?? 21 20 C0 02 10 00 BC 8F B8 00 A6 8F BC 00 A7 8F ?? ?? 99 8F 21 28 60 00 C4 00 A3 AF 21 20 40 00 ?? ?? ?? ?? C0 00 A2 AF 10 00 BC 8F C4 00 A3 8F 04 00 40 04 C0 00 AB 8F 21 F0 D7 03 21 B0 60 01 21 A8 60 00 A8 00 B9 8F BE FF 20 17 43 B8 17 00 ?? ?? 82 8F ?? ?? 99 8F 21 20 C0 02 ?? ?? 46 8C ?? ?? 47 8C 21 28 A0 02 ?? ?? ?? ?? 21 88 C0 02 21 80 A0 02 0E 00 40 04 10 00 BC 8F ?? ?? 82 8F ?? ?? 99 8F 21 20 C0 02 ?? ?? 46 8C ?? ?? 47 8C 21 28 A0 02 ?? ?? ?? ?? 01 00 DE 27 21 88 40 00 10 00 BC 8F 02 00 00 10 21 80 60 00 FF FF 1E 24 ?? ?? 99 8F 21 28 00 02 ?? ?? ?? ?? 21 20 20 02 10 00 BC 8F 21 20 40 00 ?? ?? 99 8F ?? ?? ?? ?? 21 B0 40 00 10 00 BC 8F 21 20 20 02 21 28 00 02 ?? ?? 99 8F 21 30 40 00 ?? ?? ?? ?? 21 38 60 00 10 00 BC 8F 21 20 40 00 21 28 60 00 ?? ?? 82 8F ?? ?? 99 8F ?? ?? 46 8C ?? ?? ?? ?? ?? ?? 47 8C 10 00 BC 8F 21 20 40 00 21 28 60 00 21 10 00 00 83 00 AA 27 0A 00 03 24 09 00 06 24 1B 00 C3 02 F4 01 60 00 01 00 42 24 23 38 42 01 10 48 00 00 30 00 29 25 00 00 E9 A0 F8 FF 46 14 12 B0 00 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F 21 18 00 00 8C 00 A9 27 0A 00 04 24 09 00 05 24 1B 00 44 00 F4 01 80 00 01 00 63 24 23 30 23 01 10 38 00 00 30 00 E7 24 00 00 C7 A0 F8 FF 65 14 12 10 00 00 61 00 62 2A 06 00 40 10 67 00 02 24 45 00 02 24 20 00 73 26 90 00 A2 A3 20 9C 13 7C 67 00 02 24 06 00 62 16 66 00 02 24 FF FF 42 26 0A 10 12 00 21 90 40 00 11 00 00 10 21 20 40 00 0F 00 62 16 21 20 40 02 21 20 5E 02 FF FF 82 28 0C 00 40 10 30 00 02 24 30 30 03 3C 30 30 63 24 78 00 A3 AF 7C 00 A3 AF 80 00 A3 AF 84 00 A3 AF 30 00 03 24 88 00 A3 A3 FF FF 1E 24 FF FF 04 24 30 00 02 24 79 00 A2 A3 11 00 82 28 07 00 40 10 78 00 A0 A3 21 10 A4 03 7B 00 42 24 00 00 45 80 35 00 A5 28 03 00 00 10 01 00 A5 38 21 28 00 00 8B 00 A2 27 30 00 07 24 FF FF 43 90 FF FF 46 24 21 18 A3 00 20 1C 03 7C FF FF 43 A0 FA FF 67 10 21 10 C0 00 3A 00 63 28 F8 FF 60 50 FF FF 43 90 79 00 A3 27 2B 10 66 00 04 00 40 14 7A 00 A5 27 01 00 DE 27 21 30 60 00 21 28 60 00 67 00 02 24 01 00 C3 24 09 00 62 16 01 00 C0 A0 FC FF C2 2B C5 00 40 54 67 00 04 24 2A 10 9E 00 C2 00 40 54 67 00 04 24 04 00 00 10 23 90 9E 00 66 00 02 24 BD 00 62 16 21 20 60 02 05 00 C1 07 21 10 C0 03 30 00 02 24 FF FF A2 A0 21 10 C0 03 FF FF A5 24 66 00 04 24 01 00 06 24 28 00 A6 AF B0 00 07 24 A4 00 A6 27 2C 00 A6 AF 24 00 A7 AF 01 00 A6 24 00 00 A5 80 23 18 66 00 A5 00 A0 A3 17 00 40 04 A4 00 A5 A3 70 00 05 24 30 00 A5 AF 2A 28 43 00 0C 00 A0 14 38 00 A6 AF 23 10 43 00 11 00 40 18 34 00 A3 AF 40 00 A2 AF ?? ?? 82 8F 3C 00 A7 AF 21 18 00 00 ?? ?? 42 24 44 00 A2 AF 0B 00 00 10 48 00 B0 27 09 00 40 50 30 00 B0 27 34 00 A2 AF 21 30 C2 00 04 00 00 10 23 18 62 00 04 00 00 10 30 00 B0 27 21 18 00 00 3C 00 B0 27 FF FF 02 24 0C 00 85 8E 10 00 A7 30 08 00 E0 14 70 00 07 24 07 00 60 54 00 00 07 AE 67 00 07 24 0B 00 67 52 01 00 42 24 08 00 40 1A 70 00 07 24 00 00 07 AE 01 00 07 24 04 00 07 AE ?? ?? 87 8F 0C 00 10 26 ?? ?? E7 24 FC FF 07 AE 01 00 42 24 08 00 40 10 B0 00 07 24 00 00 07 AE 23 38 02 00 04 00 07 AE ?? ?? 87 8F 0C 00 10 26 ?? ?? E7 24 FC FF 07 AE 07 00 60 50 67 00 06 24 70 00 07 24 00 00 07 AE 04 00 03 AE 08 00 06 AE 0C 00 10 26 67 00 06 24 05 00 66 56 23 10 62 00 10 00 A5 30 0E 00 A0 50 66 00 02 24 23 10 62 00 2A 18 52 00 0A 00 60 50 66 00 02 24 23 10 42 02 04 00 02 AE ?? ?? 82 8F B0 00 03 24 00 00 03 AE ?? ?? 42 24 08 00 02 AE 0C 00 10 26 66 00 02 24 20 00 82 10 90 00 A6 83 03 00 C1 07 2B 00 04 24 23 F0 1E 00 2D 00 04 24 9F 00 A0 A3 02 00 03 24 9F 00 A2 27 0A 00 05 24 03 00 09 24 1A 00 C5 03 F4 01 A0 00 01 00 63 24 FF FF 47 24 10 50 00 00 30 00 4A 25 FF FF 4A A0 12 40 00 00 03 00 69 14 12 F0 00 00 F5 FF 00 10 21 10 E0 00 F3 FF 00 55 21 10 E0 00 FE FF 44 A0 FD FF 46 A0 70 00 04 24 FD FF 42 24 00 00 04 AE 04 00 03 AE 08 00 02 AE 0C 00 10 26 28 00 A2 27 00 00 43 8C AC 00 B9 8F 0C 00 42 24 23 C8 23 03 2B 18 50 00 FA FF 60 14 AC 00 B9 AF A0 00 A2 83 A0 00 03 24 A0 00 A4 27 2B 10 02 00 1C 00 A2 AF 23 10 22 03 18 00 A3 AF 14 00 40 18 20 00 A4 AF 0C 00 84 8E 08 00 84 30 08 00 80 50 10 00 84 8E 04 00 02 AE ?? ?? 82 8F 00 00 03 AE 0C 00 10 26 ?? ?? 42 24 09 00 00 10 FC FF 02 AE 30 00 03 24 05 00 83 14 AC 00 B9 8F 28 00 A3 8F 21 10 62 00 02 00 00 10 28 00 A2 AF 1C 00 B9 AF 18 00 B1 27 21 90 00 00 F0 00 A4 8F 00 00 25 8E 04 00 26 8E 04 01 B9 8F 09 F8 20 03 08 00 27 8E 04 00 23 8E 07 00 43 14 0C 00 31 26 21 90 42 02 2B 10 30 02 F5 FF 40 14 F0 00 A4 8F 05 00 00 10 21 10 40 02 03 00 00 10 FF FF 02 24 4A FF 00 10 21 10 00 00 EC 00 BF 8F E8 00 BE 8F E4 00 B7 8F E0 00 B6 8F DC 00 B5 8F D8 00 B4 8F D4 00 B3 8F D0 00 B2 8F CC 00 B1 8F C8 00 B0 8F 08 00 E0 03 F0 00 BD 27 }
	condition:
		$1
}

rule file_20_0_0 {
	meta:
		name = "__sigjmp_save"
		size = 88
		refs = "0000 _gp_disp 0028 __GI_sigprocmask"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 18 00 B0 AF 1C 00 BF AF 21 80 80 00 07 00 A0 10 21 10 00 00 ?? ?? 99 8F 01 00 04 24 21 28 00 00 ?? ?? ?? ?? 6C 00 06 26 01 00 42 2C 1C 00 BF 8F 68 00 02 AE 18 00 B0 8F 21 10 00 00 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_21_0_0 {
	meta:
		name = "getpgid"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 24 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_22_0_0 {
	meta:
		name = "__GI_fread_unlocked"
		size = 500
		refs = "0000 _gp_disp 0068 __stdio_trans2r_o 0114 __GI_memcpy 014c __stdio_READ 0150 _stdio_openlist 0154 __GI_fflush_unlocked 01ac __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 00 00 E2 94 C0 FF BD 27 10 00 BC AF 83 00 42 30 81 00 42 2C 28 00 B3 AF 24 00 B2 AF 20 00 B1 AF 1C 00 B0 AF 3C 00 BF AF 38 00 B7 AF 34 00 B6 AF 30 00 B5 AF 2C 00 B4 AF 21 90 80 00 21 98 A0 00 21 80 C0 00 05 00 40 14 21 88 E0 00 0B 00 60 16 21 10 00 00 5A 00 00 10 3C 00 BF 8F ?? ?? 99 8F 21 20 E0 00 ?? ?? ?? ?? 80 00 05 24 F7 FF 40 10 10 00 BC 8F 51 00 00 10 21 10 00 00 4E 00 00 12 FF FF 02 24 1B 00 53 00 F4 01 60 02 12 10 00 00 2B 10 50 00 42 00 40 54 00 00 22 96 02 B8 70 72 21 80 E0 02 00 00 34 96 02 00 82 32 10 00 40 10 FF FF 83 26 01 00 94 32 08 00 94 26 80 A0 14 00 00 00 23 A6 21 A0 34 02 04 00 83 8E FF FF 10 26 01 00 42 26 00 00 43 A2 03 00 00 16 28 00 20 AE 2A 00 00 10 21 80 00 00 EE FF 00 10 21 90 40 00 10 00 36 8E 14 00 35 8E 23 A8 B6 02 0F 00 A0 52 00 03 94 32 2B 10 B0 02 ?? ?? 99 8F 0A A8 02 02 21 28 C0 02 21 20 40 02 21 30 A0 02 21 B0 D5 02 ?? ?? ?? ?? 23 80 15 02 10 00 BC 8F EC FF 00 12 10 00 36 AE 21 90 55 02 00 03 94 32 07 00 80 12 ?? ?? 94 8F ?? ?? 84 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F ?? ?? 94 8F 21 20 20 02 21 28 40 02 21 C8 80 02 ?? ?? ?? ?? 21 30 00 02 07 00 40 50 23 80 F0 02 23 80 02 02 F7 FF 00 16 21 90 42 02 01 00 00 10 21 80 00 00 23 80 F0 02 1B 00 13 02 F4 01 60 02 08 00 00 10 12 10 00 00 ?? ?? 99 8F 08 00 42 34 ?? ?? ?? ?? 00 00 22 A6 16 00 03 24 00 00 43 AC 21 10 00 00 3C 00 BF 8F 38 00 B7 8F 34 00 B6 8F 30 00 B5 8F 2C 00 B4 8F 28 00 B3 8F 24 00 B2 8F 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 40 00 BD 27 }
	condition:
		$1
}

rule file_23_0_0 {
	meta:
		name = "semtimedop"
		size = 68
		refs = "0000 _gp_disp 000c __syscall_ipc"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F D8 FF BD 27 21 10 80 00 04 00 04 24 24 00 BF AF 18 00 BC AF 10 00 A5 AF 14 00 A7 AF 21 28 40 00 ?? ?? ?? ?? 21 38 00 00 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_24_0_0 {
	meta:
		name = "__GI_statvfs"
		size = 888
		refs = "0000 _gp_disp 000c __libc_statfs 005c __GI_memset 00c0 __GI_stat 00e4 __GI___errno_location 0104 __GI_setmntent 00fc $LC0 0114 $LC1 0124 $LC2 0144 __GI_getmntent_r 01b0 $LC11 01b4 $LC3 01b8 $LC4 01cc __GI_strsep 01e8 __GI_strcmp 0234 $LC5 025c $LC6 0284 $LC7 02ac $LC8 02d4 $LC9 02fc $LC10 0328 __GI_endmntent"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F 30 FA BD 27 10 00 BC AF AC 05 B1 AF A8 05 B0 AF CC 05 BF AF C8 05 BE AF C4 05 B7 AF C0 05 B6 AF BC 05 B5 AF B8 05 B4 AF B4 05 B3 AF B0 05 B2 AF 21 80 A0 00 48 05 A5 27 ?? ?? ?? ?? 21 88 80 00 BA 00 40 04 10 00 BC 8F 4C 05 A2 8F ?? ?? 99 8F 30 00 04 26 00 00 02 AE 04 00 02 AE 54 05 A2 8F 21 28 00 00 18 00 06 24 08 00 02 AE 58 05 A2 8F 24 00 00 AE 0C 00 02 AE 64 05 A2 8F 10 00 02 AE 5C 05 A2 8F 14 00 02 AE 60 05 A2 8F 18 00 02 AE 68 05 A2 8F 20 00 02 AE 70 05 A2 8F ?? ?? ?? ?? 2C 00 02 AE 10 00 BC 8F 18 00 02 8E 21 20 20 02 ?? ?? 91 8F 1C 00 02 AE 28 00 00 AE 21 C8 20 02 ?? ?? ?? ?? B0 04 A5 27 21 B8 20 02 99 00 40 04 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F 21 A0 40 00 00 00 55 8C ?? ?? 84 8F ?? ?? 92 8F ?? ?? 91 8F ?? ?? 84 24 21 C8 20 02 ?? ?? ?? ?? ?? ?? 45 26 21 98 40 00 09 00 40 14 10 00 BC 8F ?? ?? 84 8F ?? ?? 45 26 21 C8 20 02 ?? ?? ?? ?? ?? ?? 84 24 21 98 40 00 7D 00 40 10 10 00 BC 8F ?? ?? 92 8F 8C 05 B1 27 18 00 B6 27 18 04 BE 27 21 20 60 02 21 28 20 02 21 30 C0 02 21 C8 40 02 ?? ?? ?? ?? 00 04 07 24 6E 00 40 10 10 00 BC 8F 90 05 A4 8F 21 C8 E0 02 ?? ?? ?? ?? 21 28 C0 03 F3 FF 40 04 10 00 BC 8F 18 04 A2 8F B0 04 A3 8F F0 FF 62 14 21 20 60 02 1C 04 A2 8F B4 04 A3 8F ED FF 62 14 21 28 20 02 98 05 A2 8F ?? ?? 96 8F ?? ?? 97 8F ?? ?? 9E 8F A4 05 A2 AF ?? ?? D6 26 ?? ?? F7 26 ?? ?? DE 27 ?? ?? 99 8F A4 05 A4 27 ?? ?? ?? ?? 21 28 C0 02 21 88 40 00 51 00 40 10 10 00 BC 8F ?? ?? 92 8F 21 20 20 02 21 C8 40 02 ?? ?? ?? ?? 21 28 E0 02 04 00 40 14 10 00 BC 8F 28 00 02 8E 45 00 00 10 01 00 42 34 21 20 20 02 21 C8 40 02 ?? ?? ?? ?? 21 28 C0 03 04 00 40 14 10 00 BC 8F 28 00 02 8E 3C 00 00 10 02 00 42 34 ?? ?? 85 8F 21 20 20 02 21 C8 40 02 ?? ?? ?? ?? ?? ?? A5 24 04 00 40 14 10 00 BC 8F 28 00 02 8E 32 00 00 10 08 00 42 34 ?? ?? 85 8F 21 20 20 02 21 C8 40 02 ?? ?? ?? ?? ?? ?? A5 24 04 00 40 14 10 00 BC 8F 28 00 02 8E 28 00 00 10 04 00 42 34 ?? ?? 85 8F 21 20 20 02 21 C8 40 02 ?? ?? ?? ?? ?? ?? A5 24 04 00 40 14 10 00 BC 8F 28 00 02 8E 1E 00 00 10 10 00 42 34 ?? ?? 85 8F 21 20 20 02 21 C8 40 02 ?? ?? ?? ?? ?? ?? A5 24 04 00 40 14 10 00 BC 8F 28 00 02 8E 14 00 00 10 40 00 42 34 ?? ?? 85 8F 21 20 20 02 21 C8 40 02 ?? ?? ?? ?? ?? ?? A5 24 04 00 40 14 10 00 BC 8F 28 00 02 8E 0A 00 00 10 00 04 42 34 ?? ?? 85 8F 21 20 20 02 21 C8 40 02 ?? ?? ?? ?? ?? ?? A5 24 AE FF 40 14 10 00 BC 8F 28 00 02 8E 00 08 42 34 AA FF 00 10 28 00 02 AE ?? ?? 99 8F ?? ?? ?? ?? 21 20 60 02 03 00 00 10 00 00 95 AE 02 00 00 10 FF FF 02 24 21 10 00 00 CC 05 BF 8F C8 05 BE 8F C4 05 B7 8F C0 05 B6 8F BC 05 B5 8F B8 05 B4 8F B4 05 B3 8F B0 05 B2 8F AC 05 B1 8F A8 05 B0 8F 08 00 E0 03 D0 05 BD 27 }
	condition:
		$1
}

rule file_25_0_0 {
	meta:
		name = "bsearch"
		size = 192
	strings:
		$1 = { C8 FF BD 27 30 00 B6 AF 2C 00 B5 AF 28 00 B4 AF 1C 00 B1 AF 18 00 B0 AF 34 00 BF AF 24 00 B3 AF 20 00 B2 AF 21 A8 80 00 21 B0 A0 00 21 80 C0 00 21 A0 E0 00 10 00 E0 14 21 88 00 00 16 00 00 10 21 10 00 00 42 90 12 00 21 90 51 02 02 10 54 72 48 00 B9 8F 21 20 A0 02 21 98 56 00 09 F8 20 03 21 28 60 02 09 00 40 18 00 00 00 00 01 00 51 26 21 90 00 02 21 80 40 02 2B 10 30 02 F1 FF 40 14 23 90 11 02 04 00 00 10 21 10 00 00 FA FF 40 14 21 80 40 02 21 10 60 02 34 00 BF 8F 30 00 B6 8F 2C 00 B5 8F 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_26_0_0 {
	meta:
		name = "l64a"
		size = 68
		refs = "0000 _gp_disp"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F ?? ?? 83 8F ?? ?? 42 24 ?? ?? 63 24 07 00 80 10 3F 00 85 30 21 28 A3 00 00 00 A5 90 82 21 04 00 01 00 42 24 F9 FF 00 10 FF FF 45 A0 08 00 E0 03 00 00 40 A0 }
	condition:
		$1
}

rule file_27_0_0 {
	meta:
		name = "getresgid"
		size = 164
		refs = "0000 _gp_disp 0050 __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 C0 FF BD 27 10 00 BC AF 38 00 B3 AF 34 00 B2 AF 30 00 B1 AF 21 98 80 00 21 90 A0 00 21 88 C0 00 3C 00 BF AF 2C 00 B0 AF 20 00 A4 27 1C 00 A5 27 18 00 A6 27 5F 10 02 24 0C 00 00 00 07 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC 08 00 00 10 FF FF 10 24 06 00 40 14 20 00 A2 8F 00 00 62 AE 1C 00 A2 8F 00 00 42 AE 18 00 A2 8F 00 00 22 AE 3C 00 BF 8F 21 10 00 02 38 00 B3 8F 34 00 B2 8F 30 00 B1 8F 2C 00 B0 8F 08 00 E0 03 40 00 BD 27 }
	condition:
		$1
}

rule file_28_0_0 {
	meta:
		name = "clearerr_unlocked"
		size = 16
	strings:
		$1 = { 00 00 82 94 F3 FF 42 30 08 00 E0 03 00 00 82 A4 }
	condition:
		$1
}

rule file_29_0_0 {
	meta:
		name = "_uintmaxtostr"
		size = 252
	strings:
		$1 = { 10 00 A3 8F 21 10 80 00 14 00 AB 8F 08 00 61 04 21 48 00 00 06 00 E1 04 23 18 03 00 23 30 06 00 2B 20 06 00 23 38 07 00 23 38 E4 00 01 00 09 24 FF FF 05 24 1B 00 A3 00 F4 01 60 00 00 00 40 A0 10 40 00 00 01 00 08 25 03 00 03 15 12 28 00 00 01 00 A5 24 21 40 00 00 13 00 E0 10 00 00 00 00 1B 00 E3 00 F4 01 60 00 10 50 00 00 12 38 00 00 1B 00 C3 00 F4 01 60 00 10 20 00 00 12 60 00 00 02 30 48 71 21 20 C4 00 02 30 45 71 1B 00 83 00 F4 01 60 00 21 50 CC 00 12 30 00 00 21 30 46 01 05 00 00 10 10 20 00 00 1B 00 C3 00 F4 01 60 00 10 20 00 00 12 30 00 00 0A 00 8A 2C 03 00 40 11 FF FF 42 24 02 00 00 10 30 00 84 24 21 20 8B 00 20 24 04 7C 00 00 44 A0 25 20 C7 00 DE FF 80 14 00 00 00 00 03 00 20 11 2D 00 03 24 FF FF 43 A0 FF FF 42 24 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_30_0_0 {
	meta:
		name = "umask"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF DC 0F 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_31_0_0 {
	meta:
		name = "__GI_snprintf"
		size = 60
		refs = "0000 _gp_disp 0010 __GI_vsnprintf"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D8 FF BD 27 ?? ?? 99 8F 34 00 A7 AF 34 00 A7 27 24 00 BF AF 10 00 BC AF 18 00 A7 AF ?? ?? ?? ?? 00 00 00 00 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_38_0_0 {
	meta:
		name = "swprintf"
		size = 60
		refs = "0000 _gp_disp 0010 __GI_vswprintf"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D8 FF BD 27 ?? ?? 99 8F 34 00 A7 AF 34 00 A7 27 24 00 BF AF 10 00 BC AF 18 00 A7 AF ?? ?? ?? ?? 00 00 00 00 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_32_0_0 {
	meta:
		name = "__GI_ftruncate"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF FD 0F 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_33_0_0 {
	meta:
		name = "__GI_bind"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 49 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_34_0_0 {
	meta:
		name = "puts"
		size = 224
		refs = "0000 _gp_disp 000c stdout 003c _pthread_cleanup_push_defer 0040 __pthread_mutex_unlock 0058 __pthread_mutex_lock 0068 __GI_fputs_unlocked 0084 __GI___fputc_unlocked 00b0 _pthread_cleanup_pop_restore"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F C0 FF BD 27 38 00 B3 AF 10 00 BC AF 3C 00 BF AF 34 00 B2 AF 30 00 B1 AF 2C 00 B0 AF 00 00 51 8C 34 00 32 8E 0C 00 40 16 21 98 80 00 ?? ?? 99 8F ?? ?? 85 8F 38 00 30 26 18 00 A4 27 ?? ?? ?? ?? 21 30 00 02 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 00 02 10 00 BC 8F ?? ?? 99 8F 21 20 60 02 ?? ?? ?? ?? 21 28 20 02 FF FF 10 24 0A 00 50 10 10 00 BC 8F ?? ?? 99 8F 0A 00 04 24 21 28 20 02 ?? ?? ?? ?? 01 00 50 24 10 00 BC 8F 27 10 02 00 FF FF 03 24 0A 80 62 00 06 00 40 16 3C 00 BF 8F ?? ?? 99 8F 18 00 A4 27 ?? ?? ?? ?? 01 00 05 24 3C 00 BF 8F 21 10 00 02 38 00 B3 8F 34 00 B2 8F 30 00 B1 8F 2C 00 B0 8F 08 00 E0 03 40 00 BD 27 }
	condition:
		$1
}

rule file_35_0_0 {
	meta:
		name = "fchmod"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF FE 0F 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_36_0_0 {
	meta:
		name = "alphasort"
		size = 36
		refs = "0000 _gp_disp 0014 __GI_strcmp"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 00 00 84 8C 00 00 A5 8C ?? ?? 99 8F 0B 00 84 24 ?? ?? ?? ?? 0B 00 A5 24 }
	condition:
		$1
}

rule file_344_0_0 {
	meta:
		name = "versionsort"
		size = 36
		refs = "0000 _gp_disp 0014 __GI_strverscmp"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 00 00 84 8C 00 00 A5 8C ?? ?? 99 8F 0B 00 84 24 ?? ?? ?? ?? 0B 00 A5 24 }
	condition:
		$1
}

rule file_37_0_0 {
	meta:
		name = "lrand48"
		size = 60
		refs = "0000 _gp_disp 000c __libc_drand48_data 0010 __GI_nrand48_r"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 84 8F ?? ?? 99 8F D8 FF BD 27 18 00 A6 27 24 00 BF AF 10 00 BC AF ?? ?? ?? ?? 21 28 80 00 24 00 BF 8F 18 00 A2 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_460_0_0 {
	meta:
		name = "mrand48"
		size = 60
		refs = "0000 _gp_disp 000c __libc_drand48_data 0010 __GI_jrand48_r"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 84 8F ?? ?? 99 8F D8 FF BD 27 18 00 A6 27 24 00 BF AF 10 00 BC AF ?? ?? ?? ?? 21 28 80 00 24 00 BF 8F 18 00 A2 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_39_0_0 {
	meta:
		name = "wcscspn"
		size = 48
	strings:
		$1 = { 21 10 80 00 00 00 46 8C 06 00 C0 10 21 18 A0 00 00 00 67 8C FB FF E0 50 04 00 42 24 FC FF E6 14 04 00 63 24 23 10 44 00 08 00 E0 03 83 10 02 00 }
	condition:
		$1
}

rule file_40_0_0 {
	meta:
		name = "__GI_gethostbyname_r"
		size = 864
		refs = "0000 _gp_disp 0054 __GI___errno_location 0074 __get_hosts_byname_r 00f4 __GI_strlen 0124 __GI_memcpy 0160 __GI_inet_aton 01d4 __dns_lookup 0248 __GI_memmove 02c4 __GI_strcpy 030c free"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 78 FF BD 27 78 00 B6 AF 98 00 B6 8F 20 00 BC AF 74 00 B5 AF 64 00 B1 AF 84 00 BF AF 80 00 BE AF 7C 00 B7 AF 70 00 B4 AF 6C 00 B3 AF 68 00 B2 AF 60 00 B0 AF 21 A8 80 00 9C 00 B1 8F 00 00 C0 AE B8 00 80 10 16 00 02 24 ?? ?? 99 8F 21 80 A0 00 21 A0 C0 00 ?? ?? ?? ?? 21 90 E0 00 20 00 BC 8F 00 00 5E 8C 21 20 A0 02 ?? ?? 99 8F 00 00 40 AC 02 00 05 24 10 00 B2 AF 14 00 B6 AF 18 00 B1 AF 21 30 00 02 21 38 80 02 ?? ?? ?? ?? 21 98 40 00 03 00 40 14 20 00 BC 8F A2 00 00 10 00 00 7E AE 00 00 23 8E 01 00 04 24 07 00 64 10 04 00 04 24 0B 00 64 10 FF FF 04 24 9B 00 64 14 84 00 BF 8F 04 00 00 10 00 00 64 8E 02 00 42 38 05 00 00 10 01 00 57 2C 02 00 03 24 93 00 83 14 84 00 BF 8F 21 B8 00 00 00 00 7E AE ?? ?? 93 8F FF FF 02 24 00 00 22 AE 21 C8 60 02 ?? ?? ?? ?? 21 20 A0 02 01 00 5E 24 2A 10 D2 03 03 00 40 14 20 00 BC 8F 84 00 00 10 22 00 02 24 ?? ?? 99 8F 21 20 80 02 21 30 C0 03 ?? ?? ?? ?? 21 28 A0 02 21 10 9E 02 23 98 02 00 23 90 5E 02 03 00 73 32 23 18 53 02 F8 FF 7E 24 00 01 C4 2B F1 FF 80 14 20 00 BC 8F 21 98 53 00 ?? ?? 99 8F 10 00 66 26 00 00 74 AE 04 00 60 AE 21 28 C0 00 58 00 A3 AF 5C 00 A6 AF ?? ?? ?? ?? 21 20 A0 02 08 00 72 26 20 00 BC 8F 58 00 A3 8F 0E 00 40 10 5C 00 A6 8F 02 00 02 24 08 00 66 AE 0C 00 60 AE 08 00 02 AE 04 00 02 24 0C 00 02 AE 00 00 14 AE 04 00 13 AE 10 00 12 AE 21 10 00 00 00 00 D0 AE 5A 00 00 10 00 00 20 AE 0E 00 E0 16 01 00 02 24 ?? ?? 99 8F EC FF 63 24 44 00 B2 AF 48 00 A3 AF 4C 00 A0 AF 21 20 A0 02 01 00 05 24 50 00 A6 27 ?? ?? ?? ?? 28 00 A7 27 05 00 41 04 20 00 BC 8F 01 00 02 24 00 00 22 AE 48 00 00 10 02 00 02 24 2C 00 A3 8F 01 00 02 24 3A 00 62 54 00 00 22 AE 4C 00 B7 8F 38 00 A6 8F 03 00 F5 26 02 30 E6 72 80 A8 15 00 21 10 A6 02 23 F0 C2 03 32 00 C0 07 22 00 02 24 ?? ?? 99 8F 21 20 55 02 ?? ?? ?? ?? 21 28 40 02 20 00 BC 8F FC FF B5 26 3C 00 A5 8F ?? ?? 99 8F 21 A8 55 02 21 20 A0 02 ?? ?? ?? ?? 04 00 06 24 20 00 BC 8F 21 10 00 00 80 18 02 00 2B 20 E2 02 05 00 80 14 21 18 43 02 00 00 75 AC 01 00 42 24 F9 FF 00 10 04 00 B5 26 28 00 B7 8F 0D 00 E0 12 00 00 60 AC ?? ?? 99 8F ?? ?? ?? ?? 21 20 E0 02 2B 10 5E 00 07 00 40 10 20 00 BC 8F ?? ?? 99 8F 21 20 A0 02 ?? ?? ?? ?? 21 28 E0 02 20 00 BC 8F 21 A0 A0 02 02 00 02 24 08 00 02 AE 04 00 02 24 0C 00 02 AE 00 00 14 AE 04 00 13 AE 10 00 12 AE 21 10 00 00 00 00 D0 AE 02 00 00 10 00 00 20 AE 02 00 02 24 ?? ?? 99 8F 28 00 A4 8F ?? ?? ?? ?? 58 00 A2 AF 20 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 50 00 A4 8F 58 00 A2 8F 84 00 BF 8F 80 00 BE 8F 7C 00 B7 8F 78 00 B6 8F 74 00 B5 8F 70 00 B4 8F 6C 00 B3 8F 68 00 B2 8F 64 00 B1 8F 60 00 B0 8F 08 00 E0 03 88 00 BD 27 }
	condition:
		$1
}

rule file_41_0_0 {
	meta:
		name = "__GI_ioperm"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 05 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_42_0_0 {
	meta:
		name = "usleep"
		size = 92
		refs = "0000 _gp_disp 0024 __GI_nanosleep"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 0F 00 02 3C 40 42 42 24 1B 00 82 00 F4 01 40 00 D8 FF BD 27 E8 03 03 24 ?? ?? 99 8F 24 00 BF AF 10 00 BC AF 21 28 00 00 10 20 00 00 12 10 00 00 18 00 A2 AF 02 10 83 70 18 00 A4 27 ?? ?? ?? ?? 1C 00 A2 AF 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_43_0_0 {
	meta:
		name = "__GI_memrchr"
		size = 240
	strings:
		$1 = { FF 00 A3 30 21 10 86 00 09 00 C0 10 03 00 44 30 08 00 80 50 FF 00 A5 30 FF FF 42 24 00 00 44 90 31 00 83 10 FF FF C6 24 F7 FF 00 10 00 00 00 00 FF 00 A5 30 00 22 05 00 25 28 85 00 00 24 05 00 FE 7E 07 3C 01 81 08 3C 25 28 85 00 FF FE E7 34 00 01 08 25 04 00 C4 2C 20 00 80 14 00 00 00 00 FC FF 42 24 00 00 44 8C 26 20 A4 00 27 48 04 00 21 20 87 00 26 20 24 01 24 20 88 00 F5 FF 80 50 FC FF C6 24 03 00 44 90 03 00 83 54 02 00 44 90 08 00 E0 03 03 00 42 24 03 00 83 54 01 00 44 90 08 00 E0 03 02 00 42 24 03 00 83 54 00 00 44 90 08 00 E0 03 01 00 42 24 0B 00 83 10 FC FF C6 24 E5 FF 00 10 04 00 C4 2C FF FF 42 24 21 30 80 00 00 00 44 90 04 00 83 10 00 00 00 00 FA FF C0 14 FF FF C4 24 21 10 00 00 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_44_0_0 {
	meta:
		name = "__GI_hcreate_r"
		size = 200
		refs = "0000 _gp_disp 0024 __GI___errno_location 0090 calloc"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 18 00 B0 AF 1C 00 BF AF 08 00 A0 14 21 80 A0 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 16 00 03 24 00 00 43 AC 1F 00 00 10 21 10 00 00 00 00 A3 8C 21 10 00 00 1B 00 60 14 01 00 84 34 03 00 02 24 02 18 42 70 2B 18 64 00 08 00 60 10 00 00 00 00 1B 00 82 00 F4 01 40 00 10 18 00 00 06 00 60 10 02 00 42 24 F6 FF 00 10 00 00 00 00 1B 00 82 00 F4 01 40 00 10 18 00 00 03 00 60 14 ?? ?? 99 8F EE FF 00 10 02 00 84 24 04 00 04 AE 08 00 00 AE 01 00 84 24 ?? ?? ?? ?? 0C 00 05 24 00 00 02 AE 2B 10 02 00 1C 00 BF 8F 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_45_0_0 {
	meta:
		name = "wmemmove"
		size = 84
	strings:
		$1 = { 2B 18 A4 00 09 00 60 14 21 10 80 00 21 18 80 00 0E 00 C0 10 FF FF C6 24 00 00 A4 8C 04 00 A5 24 00 00 64 AC FA FF 00 10 04 00 63 24 07 00 C0 10 FF FF C6 24 80 18 06 00 21 20 A3 00 00 00 84 8C 21 18 43 00 F9 FF 00 10 00 00 64 AC 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_46_0_0 {
	meta:
		name = "sched_rr_get_interval"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 45 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_48_0_0 {
	meta:
		name = "setgid"
		size = 120
		refs = "0000 _gp_disp 0024 __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 FF FF 02 24 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 07 00 82 14 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 16 00 03 24 00 00 43 AC 0B 00 00 10 FF FF 02 24 CE 0F 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 21 10 00 02 1C 00 BF 8F 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_49_0_0 {
	meta:
		name = "__malloc_trim.constprop.0"
		size = 260
		refs = "0000 _gp_disp 0014 __malloc_state 0068 __GI_sbrk"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D0 FF BD 27 18 00 B0 AF ?? ?? 90 8F 28 00 B4 AF 20 00 B2 AF 10 00 BC AF 2C 00 BF AF 24 00 B3 AF 1C 00 B1 AF 2C 00 02 8E 5C 03 03 8E FC FF 12 24 04 00 42 8C EF FF 74 24 24 90 42 02 21 A0 92 02 23 20 84 02 1B 00 83 00 F4 01 60 00 12 A0 00 00 FF FF 94 26 02 A0 83 72 03 00 80 1E ?? ?? 91 8F 1D 00 00 10 21 10 00 00 21 C8 20 02 ?? ?? ?? ?? 21 20 00 00 21 98 40 00 2C 00 02 8E 21 10 52 00 15 00 62 16 21 10 00 00 21 C8 20 02 ?? ?? ?? ?? 23 20 14 00 21 C8 20 02 ?? ?? ?? ?? 21 20 00 00 FF FF 03 24 0C 00 43 50 21 10 00 00 23 10 62 02 09 00 40 50 21 10 00 00 68 03 03 8E 23 18 62 00 68 03 03 AE 2C 00 03 8E 23 10 42 02 01 00 42 34 04 00 62 AC 01 00 02 24 2C 00 BF 8F 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_49_1_0 {
	meta:
		name = "__malloc_consolidate"
		size = 476
		refs = "0000 _gp_disp 00b0 __GI_abort 0198 __GI_sysconf"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 18 00 B0 AF 10 00 BC AF 1C 00 BF AF 00 00 82 8C 4E 00 40 10 21 80 80 00 FD FF 03 24 24 10 43 00 C2 50 02 00 FE FF 4A 25 80 50 0A 00 21 50 8A 00 00 00 82 AC 34 00 89 24 04 00 4A 25 04 00 85 24 FE FF 0B 24 FC FF 0C 24 00 00 A2 8C 05 00 40 54 00 00 A0 AC 59 00 AA 10 04 00 A2 24 FA FF 00 10 21 28 40 00 04 00 47 8C 08 00 4D 8C 24 18 EB 00 21 20 43 00 04 00 86 8C 01 00 E7 30 10 00 E0 14 24 30 86 01 00 00 47 8C 23 10 47 00 08 00 48 8C 21 18 67 00 0C 00 0E 8D 04 00 C2 11 0C 00 47 8C ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 08 00 EE 8C FC FF C2 15 ?? ?? 99 8F 0C 00 07 AD 08 00 E8 AC 2C 00 07 8E 19 00 87 10 21 38 86 00 04 00 E7 8C 01 00 E7 30 0B 00 E0 14 04 00 86 AC 08 00 87 8C 21 18 66 00 0C 00 E8 8C ED FF 04 15 0C 00 86 8C 08 00 C8 8C EB FF 04 15 ?? ?? 99 8F 0C 00 E6 AC 08 00 C7 AC 3C 00 04 8E 01 00 66 34 3C 00 02 AE 0C 00 82 AC 04 00 46 AC 0C 00 49 AC 08 00 44 AC 21 10 43 00 05 00 00 10 00 00 43 AC 21 18 66 00 01 00 63 34 04 00 43 AC 2C 00 02 AE C9 FF A0 15 21 10 A0 01 C3 FF 00 10 00 00 00 00 01 00 02 24 60 00 04 24 C0 18 02 00 21 18 03 02 2C 00 63 24 01 00 42 24 0C 00 63 AC FA FF 44 14 08 00 63 AC 01 00 02 3C 54 03 02 AE 04 00 02 3C 4C 03 02 AE 44 03 02 AE 60 03 02 8E ?? ?? 99 8F 48 03 00 AE 01 00 42 34 60 03 02 AE 00 00 02 8E 1E 00 04 24 03 00 42 30 48 00 42 34 00 00 02 AE 34 00 02 26 ?? ?? ?? ?? 2C 00 02 AE 5C 03 02 AE 1C 00 BF 8F 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_49_2_0 {
	meta:
		name = "malloc_trim"
		size = 80
		refs = "0000 _gp_disp 0010 __malloc_consolidate 001c __malloc_state 0048 __malloc_trim.constprop.0"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 ?? ?? 99 8F 18 00 B0 AF 21 80 80 00 ?? ?? 84 8F 10 00 BC AF 1C 00 BF AF ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F 1C 00 BF 8F 21 20 00 02 ?? ?? 99 8F 18 00 B0 8F ?? ?? 39 27 ?? ?? ?? ?? 20 00 BD 27 }
	condition:
		$1
}

rule file_49_3_0 {
	meta:
		name = "free"
		size = 600
		refs = "0000 _gp_disp 002c __pthread_mutex_unlock 0030 __malloc_lock 0034 _pthread_cleanup_push_defer 004c __pthread_mutex_lock 0064 __malloc_state 00f0 __GI_abort 019c _pthread_cleanup_pop_restore 01b4 __malloc_consolidate 01f0 __malloc_trim.constprop.0 0208 __GI_munmap"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 C8 FF BD 27 10 00 BC AF 2C 00 B1 AF 34 00 BF AF 30 00 B2 AF 28 00 B0 AF 86 00 80 10 21 88 80 00 ?? ?? 85 8F ?? ?? 86 8F ?? ?? 99 8F 18 00 B2 27 ?? ?? ?? ?? 21 20 40 02 10 00 BC 8F ?? ?? 84 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F FC FF 27 8E FC FF 06 24 ?? ?? 83 8F 24 28 E6 00 F8 FF 22 26 00 00 64 8C 2B 40 85 00 0B 00 00 15 21 80 60 00 C2 28 05 00 FE FF A5 24 03 00 84 34 80 28 05 00 00 00 64 AC 21 18 65 00 04 00 64 8C 00 00 24 AE 63 00 00 10 04 00 62 AC 02 00 E7 30 54 00 E0 14 01 00 84 34 00 00 64 AC 21 18 45 00 04 00 64 8C 24 30 C4 00 FC FF 24 8E 01 00 84 30 11 00 80 54 2C 00 04 8E F8 FF 24 8E 23 10 44 00 08 00 47 8C 21 28 A4 00 0C 00 E8 8C 04 00 02 11 0C 00 44 8C ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 08 00 88 8C FC FF 02 15 ?? ?? 99 8F 0C 00 E4 AC 08 00 87 AC 2C 00 04 8E 19 00 64 10 21 20 66 00 04 00 84 8C 01 00 84 30 0A 00 80 14 04 00 66 AC 08 00 64 8C 0C 00 88 8C EE FF 03 15 0C 00 67 8C 08 00 E8 8C EB FF 03 15 21 28 A6 00 0C 00 87 AC 08 00 E4 AC 3C 00 03 8E 34 00 04 26 0C 00 44 AC 08 00 43 AC 3C 00 02 AE 0C 00 62 AC 01 00 A3 34 04 00 43 AC 21 10 45 00 06 00 00 10 00 00 45 AC 21 28 A6 00 01 00 A3 34 04 00 43 AC ?? ?? 83 8F 2C 00 62 AC 02 00 02 3C 2B 28 A2 00 26 00 A0 14 ?? ?? 99 8F 00 00 02 8E 02 00 42 30 07 00 40 50 2C 00 02 8E ?? ?? 84 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F 2C 00 02 8E FC FF 03 24 04 00 42 8C 24 10 62 00 44 03 03 8E 2B 10 43 00 15 00 40 14 ?? ?? 99 8F ?? ?? 82 8F ?? ?? 99 8F ?? ?? 39 27 ?? ?? ?? ?? 48 03 44 8C 0D 00 00 10 10 00 BC 8F 50 03 66 8C F8 FF 24 8E ?? ?? 99 8F FF FF C6 24 50 03 66 AC 64 03 66 8C 21 28 A4 00 23 20 44 00 23 30 C5 00 ?? ?? ?? ?? 64 03 66 AC 10 00 BC 8F ?? ?? 99 8F 21 20 40 02 ?? ?? ?? ?? 01 00 05 24 34 00 BF 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_51_0_0 {
	meta:
		name = "__GI_rmdir"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF C8 0F 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_52_0_0 {
	meta:
		name = "__GI_tolower"
		size = 56
		refs = "0000 _gp_disp 001c __GI___ctype_tolower"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 80 00 83 24 80 01 63 2C 06 00 60 10 21 10 80 00 ?? ?? 83 8F 40 10 04 00 00 00 63 8C 21 10 62 00 00 00 42 84 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_191_0_0 {
	meta:
		name = "__GI_toupper"
		size = 56
		refs = "0000 _gp_disp 001c __GI___ctype_toupper"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 80 00 83 24 80 01 63 2C 06 00 60 10 21 10 80 00 ?? ?? 83 8F 40 10 04 00 00 00 63 8C 21 10 62 00 00 00 42 84 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_53_0_0 {
	meta:
		name = "posix_memalign"
		size = 96
		refs = "0000 _gp_disp 0030 memalign"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 18 00 B0 AF 10 00 BC AF 21 80 80 00 03 00 A4 30 1C 00 BF AF 21 18 A0 00 09 00 80 14 16 00 02 24 ?? ?? 99 8F 21 20 60 00 ?? ?? ?? ?? 21 28 C0 00 0C 00 03 24 0B 18 02 00 00 00 02 AE 21 10 60 00 1C 00 BF 8F 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_54_0_0 {
	meta:
		name = "wcstombs"
		size = 56
		refs = "0000 _gp_disp 000c __GI_wcsrtombs"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F D8 FF BD 27 21 38 00 00 24 00 BF AF 10 00 BC AF 18 00 A5 AF ?? ?? ?? ?? 18 00 A5 27 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_55_0_0 {
	meta:
		name = "tcdrain"
		size = 28
		refs = "0000 _gp_disp 000c __GI_ioctl"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F 05 54 05 24 ?? ?? ?? ?? 01 00 06 24 }
	condition:
		$1
}

rule file_56_0_0 {
	meta:
		name = "__GI_random_r"
		size = 136
	strings:
		$1 = { 0C 00 83 80 0A 00 60 14 08 00 82 8C 00 00 44 8C C6 41 03 3C 6D 4E 63 24 02 18 83 70 39 30 63 24 00 F0 63 7C 00 00 43 AC 15 00 00 10 00 00 A3 AC 00 00 83 8C 04 00 87 8C 10 00 86 8C 00 00 69 8C 00 00 E8 8C 04 00 63 24 21 40 28 01 FC FF 68 AC 42 40 08 00 00 00 A8 AC 2B 40 66 00 04 00 00 15 04 00 E5 24 21 18 40 00 03 00 00 10 21 10 A0 00 2B 30 A6 00 0B 10 A6 00 00 00 83 AC 04 00 82 AC 08 00 E0 03 21 10 00 00 }
	condition:
		$1
}

rule file_56_1_0 {
	meta:
		name = "__GI_srandom_r"
		size = 260
		refs = "0000 _gp_disp 00a4 __GI_random_r"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 21 50 A0 00 0C 00 A5 80 05 00 A2 2C 36 00 40 10 00 00 00 00 08 00 43 8D 01 00 02 24 0B 10 84 00 33 00 A0 10 00 00 62 AC 0D 00 46 81 01 00 07 3C FF 7F 0C 3C 21 28 60 00 01 00 04 24 1D F3 E7 34 A7 41 09 24 EC F4 0B 24 FF FF 8C 35 2A 40 86 00 0E 00 00 11 04 00 A5 24 1A 00 47 00 F4 01 E0 00 01 00 84 24 12 10 00 00 10 40 00 00 18 00 4B 00 00 00 09 71 12 10 00 00 21 40 4C 00 00 00 4D 28 0B 10 0D 01 F1 FF 00 10 00 00 A2 AC 0A 00 0B 24 02 58 CB 70 0E 00 42 81 ?? ?? 99 8F D8 FF BD 27 80 10 02 00 21 10 62 00 00 00 42 AD 10 00 BC AF 24 00 BF AF 04 00 43 AD 18 00 AC 27 FF FF 6B 25 05 00 61 05 21 20 40 01 24 00 BF 8F 21 10 00 00 08 00 E0 03 28 00 BD 27 ?? ?? ?? ?? 21 28 80 01 F7 FF 00 10 FF FF 6B 25 08 00 E0 03 FF FF 02 24 08 00 E0 03 21 10 00 00 }
	condition:
		$1
}

rule file_56_2_0 {
	meta:
		name = "__GI_initstate_r"
		size = 260
		refs = "0000 _gp_disp 0054 __GI___errno_location 00a8 __GI_srandom_r"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 80 00 C2 2C 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 21 C0 A0 00 05 00 40 14 21 78 E0 00 00 01 C6 2C 03 00 0E 24 10 00 00 10 04 00 02 24 20 00 C2 2C 0B 00 40 50 40 00 C6 2C 08 00 C6 2C 0B 00 C0 10 21 70 00 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 16 00 03 24 00 00 43 AC 22 00 00 10 FF FF 02 24 01 00 0E 24 02 00 02 24 0A 70 46 00 ?? ?? 83 8F 04 00 C2 25 80 10 02 00 ?? ?? 63 24 21 10 62 00 04 00 42 8C 80 28 0E 00 21 18 A3 00 00 00 63 8C 04 00 10 27 0D 00 E2 A1 ?? ?? 99 8F 80 10 02 00 21 10 02 02 0C 00 EE A1 0E 00 E3 A1 10 00 E2 AD 08 00 F0 AD ?? ?? ?? ?? 21 28 E0 01 00 00 00 AF 08 00 C0 11 21 10 00 00 04 00 E3 8D 23 80 70 00 83 80 10 00 05 00 03 24 02 20 03 72 21 70 8E 00 00 00 0E AF 1C 00 BF 8F 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_56_3_0 {
	meta:
		name = "__GI_setstate_r"
		size = 272
		refs = "0000 _gp_disp 00ec __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 0C 00 A6 80 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 04 00 83 24 03 00 C0 14 08 00 A2 8C 08 00 00 10 FC FF 40 AC 04 00 A8 8C 05 00 07 24 23 40 02 01 83 40 08 00 02 48 07 71 21 30 26 01 FC FF 46 AC 00 00 82 8C 05 00 07 24 1A 00 47 00 F4 01 E0 00 10 10 00 00 05 00 46 2C 21 00 C0 10 ?? ?? 88 8F 04 00 46 24 80 30 06 00 ?? ?? 08 25 80 48 02 00 21 30 06 01 21 40 28 01 04 00 C6 8C 00 00 08 8D 0C 00 A2 A0 0D 00 A6 A0 0F 00 40 10 0E 00 A8 A0 00 00 82 8C 1A 00 47 00 F4 01 E0 00 12 38 00 00 80 10 07 00 21 38 E8 00 1A 00 E6 00 F4 01 C0 00 21 10 62 00 04 00 A2 AC 10 10 00 00 80 38 02 00 21 38 67 00 00 00 A7 AC 80 30 06 00 08 00 A3 AC 21 18 66 00 10 00 A3 AC 07 00 00 10 21 10 00 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 16 00 03 24 00 00 43 AC FF FF 02 24 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_57_0_0 {
	meta:
		name = "sched_setscheduler"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 40 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_59_0_0 {
	meta:
		name = "semop"
		size = 68
		refs = "0000 _gp_disp 000c __syscall_ipc"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F D8 FF BD 27 21 10 80 00 01 00 04 24 24 00 BF AF 18 00 BC AF 10 00 A5 AF 14 00 A0 AF 21 28 40 00 ?? ?? ?? ?? 21 38 00 00 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_60_0_0 {
	meta:
		name = "shmdt"
		size = 68
		refs = "0000 _gp_disp 000c __syscall_ipc"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F D8 FF BD 27 21 28 00 00 21 30 00 00 24 00 BF AF 18 00 BC AF 10 00 A4 AF 14 00 A0 AF 16 00 04 24 ?? ?? ?? ?? 21 38 00 00 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_61_0_0 {
	meta:
		name = "initgroups"
		size = 136
		refs = "0000 _gp_disp 000c __getgrouplist_internal 0044 __GI_setgroups 005c free"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F FF 7F 02 3C D0 FF BD 27 FF FF 42 34 10 00 BC AF 24 00 B0 AF 2C 00 BF AF 28 00 B1 AF 18 00 A2 AF ?? ?? ?? ?? 18 00 A6 27 21 80 40 00 0C 00 40 10 10 00 BC 8F ?? ?? 99 8F 18 00 A4 8F ?? ?? ?? ?? 21 28 40 00 10 00 BC 8F 21 88 40 00 ?? ?? 99 8F ?? ?? ?? ?? 21 20 00 02 02 00 00 10 21 10 20 02 FF FF 02 24 2C 00 BF 8F 28 00 B1 8F 24 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_62_0_0 {
	meta:
		name = "__GI_chmod"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF AF 0F 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_63_0_0 {
	meta:
		name = "__GI_getdtablesize"
		size = 72
		refs = "0000 _gp_disp 000c __GI_getrlimit"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F D8 FF BD 27 18 00 A5 27 24 00 BF AF 10 00 BC AF ?? ?? ?? ?? 05 00 04 24 18 00 A4 8F 24 00 BF 8F 00 00 42 28 00 01 03 24 0A 18 82 00 21 10 60 00 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_64_0_0 {
	meta:
		name = "__GI_getgroups"
		size = 324
		refs = "0000 _gp_disp 0030 __GI___errno_location 004c __GI_sysconf 0080 malloc 00dc free"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D0 FF BD 27 10 00 BC AF 1C 00 B0 AF 2C 00 BF AF 28 00 B3 AF 24 00 B2 AF 20 00 B1 AF 08 00 81 04 21 80 80 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 16 00 03 24 00 00 43 AC 38 00 00 10 FF FF 02 24 ?? ?? 91 8F 03 00 04 24 21 C8 20 02 ?? ?? ?? ?? 21 98 A0 00 2A 10 02 02 06 00 40 14 10 00 BC 8F 21 C8 20 02 ?? ?? ?? ?? 03 00 04 24 10 00 BC 8F 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 80 20 10 00 21 90 40 00 03 00 00 12 10 00 BC 8F E6 FF 40 10 ?? ?? 99 8F 21 20 00 02 21 28 40 02 F0 0F 02 24 0C 00 00 00 08 00 E0 10 21 88 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F 00 00 51 AC 03 00 00 10 FF FF 11 24 06 00 00 16 00 00 00 00 ?? ?? 99 8F ?? ?? ?? ?? 21 20 40 02 0F 00 00 10 21 10 20 02 FB FF 40 18 ?? ?? 99 8F 21 10 00 00 80 18 02 00 21 20 63 02 21 18 43 02 00 00 63 8C 01 00 42 24 00 00 83 AC 2A 18 51 00 F9 FF 60 14 80 18 02 00 EF FF 00 10 ?? ?? 99 8F 2C 00 BF 8F 28 00 B3 8F 24 00 B2 8F 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_65_0_0 {
	meta:
		name = "swscanf"
		size = 64
		refs = "0000 _gp_disp 0010 __GI_vswscanf"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D8 FF BD 27 ?? ?? 99 8F 30 00 A6 AF 30 00 A6 27 24 00 BF AF 10 00 BC AF 34 00 A7 AF 18 00 A6 AF ?? ?? ?? ?? 00 00 00 00 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_272_0_0 {
	meta:
		name = "__GI_asprintf"
		size = 64
		refs = "0000 _gp_disp 0010 __GI_vasprintf"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D8 FF BD 27 ?? ?? 99 8F 30 00 A6 AF 30 00 A6 27 24 00 BF AF 10 00 BC AF 34 00 A7 AF 18 00 A6 AF ?? ?? ?? ?? 00 00 00 00 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_256_0_0 {
	meta:
		name = "__GI_fprintf"
		size = 64
		refs = "0000 _gp_disp 0010 __GI_vfprintf"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D8 FF BD 27 ?? ?? 99 8F 30 00 A6 AF 30 00 A6 27 24 00 BF AF 10 00 BC AF 34 00 A7 AF 18 00 A6 AF ?? ?? ?? ?? 00 00 00 00 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_839_0_0 {
	meta:
		name = "__GI_fscanf"
		size = 64
		refs = "0000 _gp_disp 0010 __GI_vfscanf"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D8 FF BD 27 ?? ?? 99 8F 30 00 A6 AF 30 00 A6 27 24 00 BF AF 10 00 BC AF 34 00 A7 AF 18 00 A6 AF ?? ?? ?? ?? 00 00 00 00 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_467_0_0 {
	meta:
		name = "__GI_fwprintf"
		size = 64
		refs = "0000 _gp_disp 0010 __GI_vfwprintf"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D8 FF BD 27 ?? ?? 99 8F 30 00 A6 AF 30 00 A6 27 24 00 BF AF 10 00 BC AF 34 00 A7 AF 18 00 A6 AF ?? ?? ?? ?? 00 00 00 00 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_564_0_0 {
	meta:
		name = "__GI_sscanf"
		size = 64
		refs = "0000 _gp_disp 0010 __GI_vsscanf"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D8 FF BD 27 ?? ?? 99 8F 30 00 A6 AF 30 00 A6 27 24 00 BF AF 10 00 BC AF 34 00 A7 AF 18 00 A6 AF ?? ?? ?? ?? 00 00 00 00 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_708_3_0 {
	meta:
		name = "__GI_syslog"
		size = 64
		refs = "0000 _gp_disp 0010 __GI_vsyslog"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D8 FF BD 27 ?? ?? 99 8F 30 00 A6 AF 30 00 A6 27 24 00 BF AF 10 00 BC AF 34 00 A7 AF 18 00 A6 AF ?? ?? ?? ?? 00 00 00 00 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_135_0_0 {
	meta:
		name = "dprintf"
		size = 64
		refs = "0000 _gp_disp 0010 __GI_vdprintf"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D8 FF BD 27 ?? ?? 99 8F 30 00 A6 AF 30 00 A6 27 24 00 BF AF 10 00 BC AF 34 00 A7 AF 18 00 A6 AF ?? ?? ?? ?? 00 00 00 00 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_343_0_0 {
	meta:
		name = "fwscanf"
		size = 64
		refs = "0000 _gp_disp 0010 __GI_vfwscanf"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D8 FF BD 27 ?? ?? 99 8F 30 00 A6 AF 30 00 A6 27 24 00 BF AF 10 00 BC AF 34 00 A7 AF 18 00 A6 AF ?? ?? ?? ?? 00 00 00 00 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_67_0_0 {
	meta:
		name = "__GI_strcspn"
		size = 124
		refs = "0000 _gp_disp 0014 __GI_strchr"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D0 FF BD 27 24 00 B2 AF ?? ?? 92 8F 28 00 B3 AF 20 00 B1 AF 1C 00 B0 AF 10 00 BC AF 2C 00 BF AF 21 88 80 00 21 98 A0 00 21 80 00 00 00 00 25 82 07 00 A0 10 21 C8 40 02 ?? ?? ?? ?? 21 20 60 02 03 00 40 14 01 00 31 26 F8 FF 00 10 01 00 10 26 2C 00 BF 8F 21 10 00 02 28 00 B3 8F 24 00 B2 8F 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_68_0_0 {
	meta:
		name = "__GI_statfs64"
		size = 200
		refs = "0000 _gp_disp 000c __libc_statfs 0038 __GI_memcpy"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F 98 FF BD 27 10 00 BC AF 60 00 B0 AF 64 00 BF AF 21 80 A0 00 ?? ?? ?? ?? 18 00 A5 27 21 00 40 04 10 00 BC 8F 18 00 A2 8F ?? ?? 99 8F 14 00 00 AE 00 00 02 AE 1C 00 A2 8F 1C 00 00 AE 34 00 00 AE 04 00 02 AE 24 00 A2 8F 24 00 00 AE 2C 00 00 AE 10 00 02 AE 28 00 A2 8F 44 00 04 26 44 00 A5 27 18 00 02 AE 34 00 A2 8F 18 00 06 24 30 00 02 AE 2C 00 A2 8F 20 00 02 AE 30 00 A2 8F 28 00 02 AE 38 00 A2 8F 38 00 02 AE 3C 00 A2 8F 3C 00 02 AE 40 00 A2 8F ?? ?? ?? ?? 40 00 02 AE 02 00 00 10 21 10 00 00 FF FF 02 24 64 00 BF 8F 60 00 B0 8F 08 00 E0 03 68 00 BD 27 }
	condition:
		$1
}

rule file_79_0_0 {
	meta:
		name = "__GI_fstatfs64"
		size = 200
		refs = "0000 _gp_disp 000c __libc_fstatfs 0038 __GI_memcpy"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F 98 FF BD 27 10 00 BC AF 60 00 B0 AF 64 00 BF AF 21 80 A0 00 ?? ?? ?? ?? 18 00 A5 27 21 00 40 04 10 00 BC 8F 18 00 A2 8F ?? ?? 99 8F 14 00 00 AE 00 00 02 AE 1C 00 A2 8F 1C 00 00 AE 34 00 00 AE 04 00 02 AE 24 00 A2 8F 24 00 00 AE 2C 00 00 AE 10 00 02 AE 28 00 A2 8F 44 00 04 26 44 00 A5 27 18 00 02 AE 34 00 A2 8F 18 00 06 24 30 00 02 AE 2C 00 A2 8F 20 00 02 AE 30 00 A2 8F 28 00 02 AE 38 00 A2 8F 38 00 02 AE 3C 00 A2 8F 3C 00 02 AE 40 00 A2 8F ?? ?? ?? ?? 40 00 02 AE 02 00 00 10 21 10 00 00 FF FF 02 24 64 00 BF 8F 60 00 B0 8F 08 00 E0 03 68 00 BD 27 }
	condition:
		$1
}

rule file_69_0_0 {
	meta:
		name = "__GI_strtod"
		size = 92
		refs = "0000 _gp_disp 000c __strtofpmax 0030 __fp_range_check"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F D8 FF BD 27 24 00 BF AF 10 00 BC AF ?? ?? ?? ?? 21 30 00 00 10 00 BC 8F 21 20 40 00 21 28 60 00 ?? ?? 99 8F 21 30 40 00 21 38 60 00 18 00 A2 AF ?? ?? ?? ?? 1C 00 A3 AF 24 00 BF 8F 18 00 A2 8F 1C 00 A3 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_804_0_0 {
	meta:
		name = "__GI_wcstod"
		size = 92
		refs = "0000 _gp_disp 000c __wcstofpmax 0030 __fp_range_check"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F D8 FF BD 27 24 00 BF AF 10 00 BC AF ?? ?? ?? ?? 21 30 00 00 10 00 BC 8F 21 20 40 00 21 28 60 00 ?? ?? 99 8F 21 30 40 00 21 38 60 00 18 00 A2 AF ?? ?? ?? ?? 1C 00 A3 AF 24 00 BF 8F 18 00 A2 8F 1C 00 A3 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_70_0_0 {
	meta:
		name = "__GI_ispunct"
		size = 40
		refs = "0000 _gp_disp 000c __GI___ctype_b"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F 40 20 04 00 00 00 42 8C 21 10 44 00 00 00 42 94 08 00 E0 03 00 04 42 30 }
	condition:
		$1
}

rule file_71_0_0 {
	meta:
		name = "prctl"
		size = 100
		refs = "0000 _gp_disp 003c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 30 00 A2 8F E0 FF BD 27 10 00 A2 AF 60 10 02 24 0C 00 00 00 20 00 BD 27 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_72_0_0 {
	meta:
		name = "init_module"
		size = 100
		refs = "0000 _gp_disp 003c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 30 00 A2 8F E0 FF BD 27 10 00 A2 AF 20 10 02 24 0C 00 00 00 20 00 BD 27 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_73_0_0 {
	meta:
		name = "_charpad"
		size = 148
		refs = "0000 _gp_disp 0014 __stdio_fwrite"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 C8 FF BD 27 2C 00 B3 AF ?? ?? 93 8F 30 00 B4 AF 28 00 B2 AF 24 00 B1 AF 20 00 B0 AF 10 00 BC AF 34 00 BF AF 21 A0 80 00 21 88 C0 00 18 00 A5 A3 21 80 C0 00 18 00 B2 27 0A 00 00 12 21 20 40 02 01 00 05 24 21 C8 60 02 ?? ?? ?? ?? 21 30 80 02 01 00 03 24 04 00 43 14 34 00 BF 8F F6 FF 00 10 FF FF 10 26 34 00 BF 8F 23 10 30 02 30 00 B4 8F 2C 00 B3 8F 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_73_1_0 {
	meta:
		name = "_fp_out_narrow"
		size = 212
		refs = "0000 _gp_disp 0044 __GI_strlen 0070 _charpad 009c __stdio_fwrite"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D0 FF BD 27 80 00 A2 30 10 00 BC AF 28 00 B4 AF 24 00 B3 AF 20 00 B2 AF 18 00 B0 AF 2C 00 BF AF 1C 00 B1 AF 21 98 80 00 21 80 A0 00 21 90 C0 00 13 00 40 10 21 A0 E0 00 ?? ?? 99 8F ?? ?? ?? ?? 21 20 E0 00 23 90 42 02 10 00 BC 8F 0D 00 40 1A 21 88 40 00 ?? ?? 99 8F 7F 00 05 32 21 20 60 02 ?? ?? 39 27 ?? ?? ?? ?? 21 30 40 02 21 80 40 00 0D 00 12 16 10 00 BC 8F 04 00 00 10 21 10 00 00 21 88 C0 00 21 80 00 00 21 10 00 00 05 00 20 1A ?? ?? 99 8F 21 20 80 02 21 28 20 02 ?? ?? ?? ?? 21 30 60 02 21 10 50 00 2C 00 BF 8F 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_73_2_0 {
	meta:
		name = "_vfprintf_internal"
		size = 1728
		refs = "0000 _gp_disp 0010 _ppfs_init 0070 __GI_strlen 0088 __stdio_fwrite 009c _ppfs_prepargs 011c _ppfs_parsespec 0134 _ppfs_setargs 0198 _store_inttype 025c _load_inttype 0278 _uintmaxtostr 035c $LC0 03a8 _fpmaxtostr 03f0 $LC1 0410 __GI_wcsrtombs 0448 __GI_wcrtomb 0498 __GI_strnlen 055c _charpad 0574 __GI_fputs_unlocked"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 88 FE BD 27 ?? ?? 99 8F 5C 01 B3 AF 20 00 B3 27 18 00 BC AF 58 01 B2 AF 54 01 B1 AF 50 01 B0 AF 74 01 BF AF 70 01 BE AF 6C 01 B7 AF 68 01 B6 AF 64 01 B5 AF 60 01 B4 AF 21 88 80 00 21 20 60 02 21 90 A0 00 ?? ?? ?? ?? 21 80 C0 00 10 00 41 04 18 00 BC 8F 20 00 B2 8F 00 00 42 82 88 01 40 10 FF FF 10 24 ?? ?? 99 8F ?? ?? ?? ?? 21 20 40 02 18 00 BC 8F 21 20 40 02 21 28 40 00 ?? ?? 99 8F ?? ?? ?? ?? 21 30 20 02 7E 01 00 10 74 01 BF 8F ?? ?? 99 8F 21 20 60 02 ?? ?? ?? ?? 21 28 00 02 18 00 BC 8F 21 20 40 02 21 80 00 00 00 00 42 82 05 00 40 10 25 00 03 24 03 00 43 10 00 00 00 00 FA FF 00 10 01 00 52 26 0B 00 44 12 23 A0 44 02 06 00 80 1A 21 10 00 00 ?? ?? 99 8F 21 28 80 02 ?? ?? ?? ?? 21 30 20 02 18 00 BC 8F 64 01 54 54 FF FF 10 24 21 80 02 02 00 00 42 82 60 01 40 10 25 00 02 24 01 00 43 82 59 01 62 10 01 00 44 26 ?? ?? 99 8F 20 00 A4 AF 40 01 A0 AF ?? ?? ?? ?? 21 20 60 02 18 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 60 02 38 00 A3 8F 18 00 BC 8F 46 00 A4 93 04 00 60 18 70 00 A2 27 C0 18 04 00 F8 FF 63 24 21 10 43 00 21 28 00 00 21 18 00 00 3C 00 A6 8F 2A 30 66 00 04 00 C0 10 01 00 63 24 21 28 40 00 FA FF 00 10 08 00 42 24 40 00 A2 8F 0A 00 40 14 08 00 43 2C 00 00 A4 8C 30 00 A5 8F ?? ?? 99 8F 21 30 00 02 00 0F A5 30 ?? ?? ?? ?? C3 3F 10 00 86 00 00 10 18 00 BC 8F 75 00 60 10 10 00 43 2C ?? ?? 83 8F ?? ?? 63 24 21 18 43 00 FF FF 76 80 0A 00 03 24 08 00 C3 16 57 00 12 24 30 00 A3 8F 2C 00 06 24 20 00 68 30 0B 90 C8 00 40 00 63 30 80 00 46 36 0B 90 C3 00 06 00 43 2C 09 00 60 50 23 B0 16 00 03 00 03 24 05 00 43 10 01 00 03 24 04 00 43 14 06 00 15 24 04 00 00 10 24 00 A6 8F 37 00 12 24 0B 00 15 24 24 00 A6 8F 34 00 A3 83 20 00 14 24 00 00 C6 28 0B A0 66 00 01 00 03 24 06 00 43 10 09 00 84 24 80 20 04 00 21 20 64 02 00 00 84 8C 02 00 00 10 00 0F 84 30 00 04 04 24 ?? ?? 99 8F 21 30 C0 02 ?? ?? ?? ?? 37 01 B7 27 18 00 BC 8F 10 00 B6 AF 21 38 60 00 ?? ?? 99 8F 14 00 B2 AF 21 20 E0 02 ?? ?? ?? ?? 21 30 40 00 21 B0 40 00 40 00 A2 8F 06 00 43 2C 10 00 60 14 18 00 BC 8F 00 00 C4 82 2D 00 03 24 06 00 83 14 30 00 A5 8F 02 00 A5 34 30 00 A5 AF 01 00 D6 26 07 00 00 10 02 00 15 24 02 00 A3 30 04 00 60 54 21 A8 00 00 01 00 A5 30 04 00 03 24 0B A8 65 00 24 00 A8 8F 30 00 A6 8F 01 00 05 24 00 00 04 29 10 00 C6 30 0B 40 A4 00 23 B8 F6 02 10 00 C0 10 00 00 C4 82 03 00 46 2C 0D 00 C0 54 06 00 15 24 03 00 06 24 0A 00 46 50 09 00 15 24 04 00 06 24 07 00 46 14 2B 30 E8 02 06 00 C0 54 30 00 05 24 30 00 88 38 01 00 E6 26 0B 28 C8 00 21 40 A0 00 30 00 05 24 0E 00 85 54 2B 10 E8 02 0B 00 04 24 06 00 A5 2A 0A A8 85 00 01 00 04 24 05 00 44 10 ?? ?? 87 8F 06 00 00 55 2B 10 E8 02 60 00 00 10 21 B8 00 00 05 00 17 24 5D 00 00 10 ?? ?? F6 24 5C 00 40 14 23 F0 17 01 5A 00 00 10 21 F0 00 00 10 00 60 10 12 00 43 2C 24 00 A2 27 00 00 A6 8C 04 00 A7 8C 10 00 A2 AF ?? ?? 82 8F ?? ?? 99 8F 21 20 20 02 ?? ?? 42 24 ?? ?? ?? ?? 14 00 A2 AF AA 00 40 04 18 00 BC 8F 21 80 02 02 A8 00 00 10 21 90 00 00 2B 00 60 10 14 00 43 2C 11 00 03 24 1A 00 43 14 38 01 A0 AF 00 00 A2 8C 08 00 40 14 40 01 A2 AF ?? ?? 87 8F 20 00 14 24 0B 00 15 24 ?? ?? F6 24 21 F0 00 00 3A 00 00 10 06 00 17 24 24 00 A2 8F ?? ?? 99 8F FF FF 12 24 00 00 46 28 40 01 A4 27 0B 10 46 02 21 28 80 00 21 30 40 00 ?? ?? ?? ?? 38 01 A7 27 21 B8 40 00 8B 00 52 10 18 00 BC 8F 1F 00 00 10 21 B0 00 00 ?? ?? 99 8F 00 00 A5 8C B8 00 B2 27 21 20 40 02 ?? ?? ?? ?? 38 01 A6 27 21 B8 40 00 FF FF 02 24 7F 00 E2 12 18 00 BC 8F 21 10 77 02 98 00 40 A0 11 00 00 10 21 B0 40 02 79 00 60 10 13 00 03 24 10 00 43 54 00 00 A2 8C 00 00 B6 8C D6 FF C0 12 ?? ?? 99 8F 24 00 A2 8F FF FF 03 24 00 00 45 28 0A 18 45 00 21 20 C0 02 ?? ?? ?? ?? 21 28 60 00 18 00 BC 8F 21 B8 40 00 20 00 14 24 09 00 00 10 0B 00 15 24 B9 00 A0 A3 B8 00 B6 27 B8 00 A2 A3 20 00 14 24 0B 00 15 24 21 F0 00 00 02 00 00 10 01 00 17 24 21 F0 00 00 0B 00 04 24 06 00 A4 12 21 10 D7 03 06 00 A6 2A 01 00 04 24 02 00 05 24 0A 20 A6 00 21 10 44 00 28 00 A4 8F 21 80 50 00 2B 90 44 00 23 20 82 00 0A 20 12 00 30 00 02 24 21 90 80 00 03 00 82 16 21 80 04 02 21 F0 C4 03 21 90 00 00 30 00 A2 8F ?? ?? 83 8F 08 00 42 30 09 00 40 14 ?? ?? 74 24 21 20 20 02 20 00 05 24 21 C8 80 02 ?? ?? ?? ?? 21 30 40 02 40 00 52 14 18 00 BC 8F 21 90 00 00 ?? ?? 82 8F ?? ?? 99 8F 21 28 20 02 ?? ?? 42 24 ?? ?? ?? ?? 21 20 55 00 21 20 20 02 30 00 05 24 21 C8 80 02 ?? ?? ?? ?? 21 30 C0 03 32 00 5E 14 18 00 BC 8F 40 01 A2 8F 15 00 40 14 38 01 A3 27 0B 00 E0 16 ?? ?? 99 8F 21 30 40 02 21 20 20 02 21 C8 80 02 ?? ?? ?? ?? 20 00 05 24 26 10 52 00 2B 90 02 00 18 00 BC 8F 24 00 00 10 23 90 12 00 21 20 C0 02 21 28 E0 02 ?? ?? ?? ?? 21 30 20 02 F1 FF 57 10 18 00 BC 8F 1C 00 00 10 FF FF 12 24 38 01 A0 AF B8 00 B5 27 40 01 BE 27 48 01 A3 AF E9 FF E0 12 ?? ?? 99 8F 81 00 E6 2E 80 00 02 24 0B 10 E6 02 21 20 A0 02 21 28 C0 03 21 30 40 00 ?? ?? ?? ?? 38 01 A7 27 21 B0 40 00 03 00 40 14 18 00 BC 8F F2 FF 00 10 23 B8 F6 02 ?? ?? 99 8F 21 20 A0 02 21 28 40 00 ?? ?? ?? ?? 21 30 20 02 F8 FF 56 10 18 00 BC 8F FF FF 12 24 05 00 40 16 20 00 B2 8F 90 FE 00 10 21 20 40 02 8E FE 00 10 02 00 52 26 01 00 00 10 FF FF 10 24 74 01 BF 8F 21 10 00 02 70 01 BE 8F 6C 01 B7 8F 68 01 B6 8F 64 01 B5 8F 60 01 B4 8F 5C 01 B3 8F 58 01 B2 8F 54 01 B1 8F 50 01 B0 8F 08 00 E0 03 78 01 BD 27 }
	condition:
		$1
}

rule file_74_0_0 {
	meta:
		name = "alphasort64"
		size = 36
		refs = "0000 _gp_disp 0014 __GI_strcmp"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 00 00 84 8C 00 00 A5 8C ?? ?? 99 8F 13 00 84 24 ?? ?? ?? ?? 13 00 A5 24 }
	condition:
		$1
}

rule file_856_0_0 {
	meta:
		name = "versionsort64"
		size = 36
		refs = "0000 _gp_disp 0014 __GI_strverscmp"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 00 00 84 8C 00 00 A5 8C ?? ?? 99 8F 13 00 84 24 ?? ?? ?? ?? 13 00 A5 24 }
	condition:
		$1
}

rule file_76_0_0 {
	meta:
		name = "__GI_getline"
		size = 28
		refs = "0000 _gp_disp 000c __GI_getdelim"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F 21 38 C0 00 ?? ?? ?? ?? 0A 00 06 24 }
	condition:
		$1
}

rule file_511_0_0 {
	meta:
		name = "setbuffer"
		size = 32
		refs = "0000 _gp_disp 000c __GI_setvbuf"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F 21 38 C0 00 02 00 06 24 ?? ?? ?? ?? 0B 30 05 00 }
	condition:
		$1
}

rule file_77_0_0 {
	meta:
		name = "chroot"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF DD 0F 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_78_0_0 {
	meta:
		name = "shmctl"
		size = 76
		refs = "0000 _gp_disp 000c __syscall_ipc"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F D8 FF BD 27 21 18 80 00 00 01 A2 34 18 00 04 24 24 00 BF AF 18 00 BC AF 10 00 A6 AF 14 00 A0 AF 21 28 60 00 21 30 40 00 ?? ?? ?? ?? 21 38 00 00 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_80_0_0 {
	meta:
		name = "__initbuf"
		size = 96
		refs = "0000 _gp_disp 002c malloc 0044 __GI_abort"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 18 00 B0 AF ?? ?? 90 8F 10 00 BC AF 1C 00 BF AF ?? ?? 02 8E 0B 00 40 14 1C 00 BF 8F ?? ?? 99 8F ?? ?? ?? ?? 8D 10 04 24 ?? ?? 02 AE 04 00 40 14 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 1C 00 BF 8F 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_80_1_0 {
	meta:
		name = "__GI_setprotoent"
		size = 208
		refs = "0000 _gp_disp 0018 _pthread_cleanup_push_defer 001c __pthread_mutex_unlock 0048 __pthread_mutex_lock 0064 __GI_rewind 0070 __GI_fopen 0068 $LC0 006c $LC1 00a8 _pthread_cleanup_pop_restore"
		altNames = "__GI_setservent"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 C8 FF BD 27 2C 00 B1 AF ?? ?? 91 8F ?? ?? 99 8F ?? ?? 85 8F 28 00 B0 AF 18 00 B0 27 10 00 BC AF ?? ?? 26 26 34 00 BF AF 30 00 B2 AF 21 90 80 00 ?? ?? ?? ?? 21 20 00 02 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? ?? ?? 24 26 10 00 BC 8F ?? ?? 91 8F ?? ?? 24 8E 0A 00 80 14 ?? ?? 99 8F ?? ?? 84 8F ?? ?? 85 8F ?? ?? 99 8F ?? ?? 84 24 ?? ?? ?? ?? ?? ?? A5 24 ?? ?? 22 AE 04 00 00 10 10 00 BC 8F ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F 03 00 40 12 ?? ?? 82 8F 01 00 03 24 ?? ?? 43 AC ?? ?? 99 8F 21 20 00 02 ?? ?? ?? ?? 01 00 05 24 34 00 BF 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_830_1_0 {
	meta:
		name = "__GI_setnetent"
		size = 208
		refs = "0000 _gp_disp 0018 _pthread_cleanup_push_defer 001c __pthread_mutex_unlock 0048 __pthread_mutex_lock 0064 __GI_rewind 0070 __GI_fopen 006c $LC0 009c _net_stayopen 00a8 _pthread_cleanup_pop_restore"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 C8 FF BD 27 2C 00 B1 AF ?? ?? 91 8F ?? ?? 99 8F ?? ?? 85 8F 28 00 B0 AF 18 00 B0 27 10 00 BC AF ?? ?? 26 26 34 00 BF AF 30 00 B2 AF 21 90 80 00 ?? ?? ?? ?? 21 20 00 02 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? ?? ?? 24 26 10 00 BC 8F ?? ?? 91 8F ?? ?? 24 8E 0A 00 80 14 ?? ?? 99 8F ?? ?? 84 8F ?? ?? 85 8F ?? ?? 99 8F ?? ?? 84 24 ?? ?? ?? ?? ?? ?? A5 24 ?? ?? 22 AE 04 00 00 10 10 00 BC 8F ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F 03 00 40 12 ?? ?? 82 8F 01 00 03 24 00 00 43 AC ?? ?? 99 8F 21 20 00 02 ?? ?? ?? ?? 01 00 05 24 34 00 BF 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_80_2_0 {
	meta:
		name = "__GI_endprotoent"
		size = 156
		refs = "0000 _gp_disp 0018 _pthread_cleanup_push_defer 001c __pthread_mutex_unlock 0040 __pthread_mutex_lock 005c __GI_fclose 0074 _pthread_cleanup_pop_restore"
		altNames = "__GI_endservent"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 C8 FF BD 27 30 00 B1 AF ?? ?? 91 8F ?? ?? 99 8F ?? ?? 85 8F 2C 00 B0 AF 18 00 B0 27 10 00 BC AF ?? ?? 26 26 34 00 BF AF ?? ?? ?? ?? 21 20 00 02 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? ?? ?? 24 26 10 00 BC 8F ?? ?? 91 8F ?? ?? 24 8E 05 00 80 10 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F ?? ?? 20 AE ?? ?? 82 8F ?? ?? 99 8F 21 20 00 02 ?? ?? 40 AC ?? ?? ?? ?? 01 00 05 24 34 00 BF 8F 30 00 B1 8F 2C 00 B0 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_830_2_0 {
	meta:
		name = "__GI_endnetent"
		size = 156
		refs = "0000 _gp_disp 0018 _pthread_cleanup_push_defer 001c __pthread_mutex_unlock 0040 __pthread_mutex_lock 005c __GI_fclose 0070 _net_stayopen 0074 _pthread_cleanup_pop_restore"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 C8 FF BD 27 30 00 B1 AF ?? ?? 91 8F ?? ?? 99 8F ?? ?? 85 8F 2C 00 B0 AF 18 00 B0 27 10 00 BC AF ?? ?? 26 26 34 00 BF AF ?? ?? ?? ?? 21 20 00 02 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? ?? ?? 24 26 10 00 BC 8F ?? ?? 91 8F ?? ?? 24 8E 05 00 80 10 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F ?? ?? 20 AE ?? ?? 82 8F ?? ?? 99 8F 21 20 00 02 00 00 40 AC ?? ?? ?? ?? 01 00 05 24 34 00 BF 8F 30 00 B1 8F 2C 00 B0 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_80_3_0 {
	meta:
		name = "__GI_getprotoent_r"
		size = 728
		refs = "0000 _gp_disp 0050 __GI___errno_location 0070 _pthread_cleanup_push_defer 0078 __pthread_mutex_unlock 009c __pthread_mutex_lock 00e0 $LC2 00e8 __GI_fgets 0118 __GI_fopen 0110 $LC0 0114 $LC1 015c __GI_strpbrk 0174 $LC3 01f0 __GI_atoi 0294 _pthread_cleanup_pop_restore"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 A8 FF BD 27 8C 00 C2 2C 10 00 BC AF 3C 00 B3 AF 38 00 B2 AF 54 00 BF AF 50 00 BE AF 4C 00 B7 AF 48 00 B6 AF 44 00 B5 AF 40 00 B4 AF 34 00 B1 AF 30 00 B0 AF 21 90 C0 00 21 98 E0 00 08 00 40 10 00 00 E0 AC ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 22 00 03 24 00 00 43 AC 90 00 00 10 22 00 02 24 ?? ?? 95 8F ?? ?? 99 8F 21 80 A0 00 ?? ?? 85 8F 18 00 B4 27 ?? ?? A6 26 21 88 80 00 ?? ?? ?? ?? 21 20 80 02 10 00 BC 8F 74 FF 52 26 ?? ?? A4 26 ?? ?? 99 8F ?? ?? ?? ?? 01 10 52 2E 08 00 40 12 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 22 00 10 24 22 00 03 24 10 00 BC 8F 73 00 00 10 00 00 43 AC ?? ?? 92 8F 8C 00 16 26 ?? ?? 42 8E 0D 00 40 10 21 B8 40 02 ?? ?? 9E 8F ?? ?? DE 27 ?? ?? 99 8F ?? ?? E6 8E 21 20 C0 02 ?? ?? ?? ?? 00 10 05 24 21 A8 40 00 12 00 40 14 10 00 BC 8F 62 00 00 10 02 00 10 24 ?? ?? 84 8F ?? ?? 85 8F ?? ?? 99 8F ?? ?? 84 24 ?? ?? ?? ?? ?? ?? A5 24 ?? ?? 42 AE EC FF 40 14 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 8C 53 00 00 10 10 00 BC 8F 00 00 43 80 23 00 02 24 E4 FF 62 10 21 20 A0 02 ?? ?? 92 8F 21 C8 40 02 ?? ?? ?? ?? 21 28 C0 03 DE FF 40 10 10 00 BC 8F ?? ?? 85 8F 00 00 40 A0 21 20 A0 02 00 00 35 AE 21 C8 40 02 ?? ?? ?? ?? ?? ?? A5 24 10 00 BC 8F D4 FF 40 10 ?? ?? 95 8F 01 00 57 24 00 00 40 A0 20 00 04 24 09 00 03 24 00 00 E2 82 03 00 44 14 00 00 00 00 FC FF 00 10 01 00 F7 26 FA FF 43 50 01 00 F7 26 21 20 E0 02 21 C8 40 02 ?? ?? ?? ?? ?? ?? A5 26 04 00 40 10 10 00 BC 8F 01 00 56 24 02 00 00 10 00 00 40 A0 21 B0 00 00 ?? ?? 99 8F 21 20 E0 02 ?? ?? ?? ?? 21 B8 00 02 10 00 BC 8F 08 00 22 AE 1F 00 C0 12 04 00 30 AE 20 00 10 24 09 00 1E 24 88 00 E3 26 ?? ?? B5 26 00 00 C2 82 18 00 40 50 21 80 E0 02 13 00 50 50 01 00 D6 26 03 00 5E 14 2B 10 E3 02 0F 00 00 10 01 00 D6 26 04 00 40 50 28 00 A3 AF 00 00 F6 AE 04 00 F7 26 28 00 A3 AF 21 20 C0 02 21 C8 40 02 ?? ?? ?? ?? 21 28 A0 02 10 00 BC 8F 05 00 40 10 28 00 A3 8F 01 00 56 24 00 00 40 A0 E9 FF C0 56 00 00 C2 82 21 80 E0 02 00 00 00 AE 00 00 71 AE 21 80 00 00 ?? ?? 99 8F 21 20 80 02 ?? ?? ?? ?? 01 00 05 24 21 10 00 02 54 00 BF 8F 50 00 BE 8F 4C 00 B7 8F 48 00 B6 8F 44 00 B5 8F 40 00 B4 8F 3C 00 B3 8F 38 00 B2 8F 34 00 B1 8F 30 00 B0 8F 08 00 E0 03 58 00 BD 27 }
	condition:
		$1
}

rule file_80_4_0 {
	meta:
		name = "getprotoent"
		size = 92
		refs = "0000 _gp_disp 0020 __initbuf 003c __GI_getprotoent_r"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F D8 FF BD 27 24 00 BF AF 10 00 BC AF ?? ?? 39 27 ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F 18 00 A7 27 8D 10 06 24 ?? ?? 82 8F ?? ?? 84 8F ?? ?? 99 8F ?? ?? 45 8C ?? ?? ?? ?? ?? ?? 84 24 24 00 BF 8F 18 00 A2 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_543_4_0 {
	meta:
		name = "getservent"
		size = 92
		refs = "0000 _gp_disp 0020 __initbuf 003c __GI_getservent_r"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F D8 FF BD 27 24 00 BF AF 10 00 BC AF ?? ?? 39 27 ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F 18 00 A7 27 8D 10 06 24 ?? ?? 82 8F ?? ?? 84 8F ?? ?? 99 8F ?? ?? 45 8C ?? ?? ?? ?? ?? ?? 84 24 24 00 BF 8F 18 00 A2 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_80_5_0 {
	meta:
		name = "__GI_getprotobyname_r"
		size = 376
		refs = "0000 _gp_disp 0018 _pthread_cleanup_push_defer 0024 __pthread_mutex_unlock 006c __pthread_mutex_lock 0080 __GI_setprotoent 0090 __GI_getprotoent_r 0094 __GI_strcmp 0114 _pthread_cleanup_pop_restore 0118 __GI_endprotoent"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 A8 FF BD 27 30 00 B0 AF ?? ?? 90 8F ?? ?? 99 8F 34 00 B1 AF 21 88 A0 00 ?? ?? 85 8F 38 00 B2 AF 18 00 B2 27 54 00 BF AF 10 00 BC AF 50 00 BE AF 4C 00 B7 AF 48 00 B6 AF 44 00 B5 AF 40 00 B4 AF 3C 00 B3 AF 21 B8 C0 00 21 98 80 00 ?? ?? 06 26 21 20 40 02 ?? ?? ?? ?? 21 B0 E0 00 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? ?? ?? 04 26 10 00 BC 8F ?? ?? 94 8F ?? ?? 99 8F ?? ?? ?? ?? ?? ?? 84 8E 10 00 BC 8F ?? ?? 95 8F ?? ?? 9E 8F 68 00 A7 8F 21 20 20 02 21 28 E0 02 21 C8 A0 02 ?? ?? ?? ?? 21 30 C0 02 21 80 40 00 15 00 40 14 10 00 BC 8F 00 00 24 8E 21 C8 C0 03 ?? ?? ?? ?? 21 28 60 02 10 00 BC 8F 0E 00 40 10 ?? ?? 99 8F 04 00 30 8E 00 00 04 8E EE FF 80 10 68 00 A7 8F 28 00 B9 AF 09 F8 20 03 21 28 60 02 10 00 BC 8F 03 00 40 10 28 00 B9 8F F6 FF 00 10 04 00 10 26 21 80 00 00 ?? ?? 82 8E 06 00 40 14 ?? ?? 99 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F ?? ?? 99 8F 21 20 40 02 ?? ?? ?? ?? 01 00 05 24 68 00 A3 8F 54 00 BF 8F 50 00 BE 8F 00 00 62 8C 4C 00 B7 8F 48 00 B6 8F 0B 80 02 00 21 10 00 02 44 00 B5 8F 40 00 B4 8F 3C 00 B3 8F 38 00 B2 8F 34 00 B1 8F 30 00 B0 8F 08 00 E0 03 58 00 BD 27 }
	condition:
		$1
}

rule file_80_6_0 {
	meta:
		name = "getprotobyname"
		size = 104
		refs = "0000 _gp_disp 0024 __initbuf 0040 __GI_getprotobyname_r"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F C8 FF BD 27 34 00 BF AF 18 00 BC AF 28 00 A4 AF ?? ?? 39 27 ?? ?? ?? ?? 00 00 00 00 18 00 BC 8F 28 00 A4 8F 8D 10 07 24 ?? ?? 82 8F ?? ?? 85 8F ?? ?? 99 8F ?? ?? 46 8C 20 00 A2 27 10 00 A2 AF ?? ?? ?? ?? ?? ?? A5 24 34 00 BF 8F 20 00 A2 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_80_8_0 {
	meta:
		name = "getprotobynumber"
		size = 104
		refs = "0000 _gp_disp 0024 __initbuf 0040 __GI_getprotobynumber_r"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F C8 FF BD 27 34 00 BF AF 18 00 BC AF 28 00 A4 AF ?? ?? 39 27 ?? ?? ?? ?? 00 00 00 00 18 00 BC 8F 28 00 A4 8F 8D 10 07 24 ?? ?? 82 8F ?? ?? 85 8F ?? ?? 99 8F ?? ?? 46 8C 20 00 A2 27 10 00 A2 AF ?? ?? ?? ?? ?? ?? A5 24 34 00 BF 8F 20 00 A2 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_80_7_0 {
	meta:
		name = "__GI_getprotobynumber_r"
		size = 308
		refs = "0000 _gp_disp 0018 _pthread_cleanup_push_defer 0024 __pthread_mutex_unlock 0070 __pthread_mutex_lock 0084 __GI_setprotoent 0098 __GI_getprotoent_r 00d4 _pthread_cleanup_pop_restore 00d8 __GI_endprotoent"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 B0 FF BD 27 30 00 B2 AF ?? ?? 92 8F ?? ?? 99 8F 34 00 B3 AF 21 98 A0 00 ?? ?? 85 8F 2C 00 B1 AF 18 00 B1 27 4C 00 BF AF 10 00 BC AF 48 00 BE AF 44 00 B7 AF 40 00 B6 AF 3C 00 B5 AF 38 00 B4 AF 28 00 B0 AF 21 B0 80 00 21 A8 C0 00 21 20 20 02 ?? ?? 46 26 21 A0 E0 00 ?? ?? ?? ?? 60 00 B0 8F 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? ?? ?? 44 26 10 00 BC 8F ?? ?? 92 8F ?? ?? 99 8F ?? ?? 44 8E ?? ?? ?? ?? 21 F0 40 02 10 00 BC 8F ?? ?? 97 8F 21 20 60 02 21 28 A0 02 21 30 80 02 21 C8 E0 02 ?? ?? ?? ?? 21 38 00 02 21 90 40 00 04 00 40 14 10 00 BC 8F 08 00 62 8E F6 FF 56 14 21 20 60 02 ?? ?? C2 8F 06 00 40 14 ?? ?? 99 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F ?? ?? 99 8F 21 20 20 02 ?? ?? ?? ?? 01 00 05 24 00 00 02 8E 4C 00 BF 8F 48 00 BE 8F 0B 90 02 00 21 10 40 02 44 00 B7 8F 40 00 B6 8F 3C 00 B5 8F 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 E0 03 50 00 BD 27 }
	condition:
		$1
}

rule file_81_0_0 {
	meta:
		name = "__GI_closedir"
		size = 232
		refs = "0000 _gp_disp 0038 __GI___errno_location 0054 __pthread_mutex_unlock 0058 _pthread_cleanup_push_defer 0074 __pthread_mutex_lock 008c _pthread_cleanup_pop_restore 00a0 free 00c0 __GI_close"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 C0 FF BD 27 34 00 B2 AF 2C 00 B0 AF 10 00 BC AF 3C 00 BF AF 38 00 B3 AF 30 00 B1 AF 00 00 82 8C FF FF 12 24 08 00 52 14 21 80 80 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 09 00 03 24 00 00 43 AC 1F 00 00 10 FF FF 02 24 ?? ?? 85 8F ?? ?? 99 8F 18 00 93 24 18 00 B1 27 21 30 60 02 ?? ?? ?? ?? 21 20 20 02 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 60 02 10 00 BC 8F 01 00 05 24 00 00 13 8E ?? ?? 99 8F 21 20 20 02 ?? ?? ?? ?? 00 00 12 AE 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 0C 00 04 8E 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 00 02 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 60 02 3C 00 BF 8F 38 00 B3 8F 34 00 B2 8F 30 00 B1 8F 2C 00 B0 8F 08 00 E0 03 40 00 BD 27 }
	condition:
		$1
}

rule file_82_0_0 {
	meta:
		name = "__GI___h_errno_location"
		size = 20
		refs = "0000 _gp_disp 0010 __GI_h_errno"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 08 00 E0 03 ?? ?? 82 8F }
	condition:
		$1
}

rule file_102_20_3 {
	meta:
		name = "_ZNSbIwSt11char_traitsIwESaIwEE12_S_empty_repEv"
		size = 20
		refs = "0000 _gp_disp 0010 _ZNSbIwSt11char_traitsIwESaIwEE4_Rep20_S_empty_rep_storageE"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 08 00 E0 03 ?? ?? 82 8F }
	condition:
		$1
}

rule file_102_76_3 {
	meta:
		name = "_ZNSbIwSt11char_traitsIwESaIwEE4_Rep12_S_empty_repEv"
		size = 20
		refs = "0000 _gp_disp 0010 _ZNSbIwSt11char_traitsIwESaIwEE4_Rep20_S_empty_rep_storageE"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 08 00 E0 03 ?? ?? 82 8F }
	condition:
		$1
}

rule file_56_19_3 {
	meta:
		name = "_ZNSs12_S_empty_repEv"
		size = 20
		refs = "0000 _gp_disp 0010 _ZNSs4_Rep20_S_empty_rep_storageE"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 08 00 E0 03 ?? ?? 82 8F }
	condition:
		$1
}

rule file_56_75_3 {
	meta:
		name = "_ZNSs4_Rep12_S_empty_repEv"
		size = 20
		refs = "0000 _gp_disp 0010 _ZNSs4_Rep20_S_empty_rep_storageE"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 08 00 E0 03 ?? ?? 82 8F }
	condition:
		$1
}

rule file_106_16_3 {
	meta:
		name = "_ZNSt6locale5facet13_S_get_c_nameEv"
		size = 20
		refs = "0000 _gp_disp 0010 _ZNSt6locale5facet9_S_c_nameE"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 08 00 E0 03 ?? ?? 82 8F }
	condition:
		$1
}

rule file_291_0_0 {
	meta:
		name = "__GI___errno_location"
		size = 20
		refs = "0000 _gp_disp 0010 __GI_errno"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 08 00 E0 03 ?? ?? 82 8F }
	condition:
		$1
}

rule file_443_0_0 {
	meta:
		name = "__libc_pthread_init"
		size = 20
		refs = "0000 _gp_disp 0010 __libc_multiple_threads"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 08 00 E0 03 ?? ?? 82 8F }
	condition:
		$1
}

rule file_83_0_0 {
	meta:
		name = "swapon"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF F7 0F 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_84_0_0 {
	meta:
		name = "setpwent"
		size = 144
		refs = "0000 _gp_disp 0018 _pthread_cleanup_push_defer 001c __pthread_mutex_unlock 0040 __pthread_mutex_lock 005c __GI_rewind 006c _pthread_cleanup_pop_restore"
		altNames = "setgrent setspent"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 C8 FF BD 27 30 00 B1 AF ?? ?? 91 8F ?? ?? 99 8F ?? ?? 85 8F 2C 00 B0 AF 18 00 B0 27 10 00 BC AF 34 00 BF AF 21 20 00 02 ?? ?? ?? ?? ?? ?? 26 26 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? ?? ?? 24 26 10 00 BC 8F ?? ?? 82 8F ?? ?? 44 8C 04 00 80 10 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F ?? ?? 99 8F 21 20 00 02 ?? ?? ?? ?? 01 00 05 24 34 00 BF 8F 30 00 B1 8F 2C 00 B0 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_84_1_0 {
	meta:
		name = "endpwent"
		size = 148
		refs = "0000 _gp_disp 0018 _pthread_cleanup_push_defer 001c __pthread_mutex_unlock 0040 __pthread_mutex_lock 005c __GI_fclose 0070 _pthread_cleanup_pop_restore"
		altNames = "endgrent endspent"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 C8 FF BD 27 30 00 B1 AF ?? ?? 91 8F ?? ?? 99 8F ?? ?? 85 8F 2C 00 B0 AF 18 00 B0 27 10 00 BC AF ?? ?? 26 26 34 00 BF AF ?? ?? ?? ?? 21 20 00 02 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? ?? ?? 24 26 10 00 BC 8F ?? ?? 91 8F ?? ?? 24 8E 05 00 80 10 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F ?? ?? 20 AE ?? ?? 99 8F 21 20 00 02 ?? ?? ?? ?? 01 00 05 24 34 00 BF 8F 30 00 B1 8F 2C 00 B0 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_84_2_0 {
	meta:
		name = "__GI_getpwent_r"
		size = 312
		refs = "0000 _gp_disp 0018 _pthread_cleanup_push_defer 0024 __pthread_mutex_unlock 0064 __pthread_mutex_lock 0090 __GI_fopen 0088 $LC0 008c $LC1 00ac __GI___errno_location 00d0 __parsepwent 00d4 __pgsreader 00f8 _pthread_cleanup_pop_restore"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 A8 FF BD 27 38 00 B0 AF ?? ?? 90 8F ?? ?? 99 8F 4C 00 B5 AF 21 A8 A0 00 ?? ?? 85 8F 3C 00 B1 AF 20 00 B1 27 18 00 BC AF 54 00 BF AF 50 00 B6 AF 48 00 B4 AF 44 00 B3 AF 40 00 B2 AF 21 98 80 00 21 A0 C0 00 21 20 20 02 ?? ?? 06 26 ?? ?? ?? ?? 21 90 E0 00 18 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? ?? ?? 04 26 18 00 BC 8F 00 00 40 AE ?? ?? 90 8F ?? ?? 02 8E 12 00 40 14 21 B0 00 02 ?? ?? 84 8F ?? ?? 85 8F ?? ?? 99 8F ?? ?? 84 24 ?? ?? ?? ?? ?? ?? A5 24 ?? ?? 02 AE 07 00 40 14 18 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 42 8C 0E 00 00 10 18 00 BC 8F 01 00 03 24 34 00 43 AC ?? ?? C2 8E ?? ?? 84 8F ?? ?? 99 8F 10 00 A2 AF 21 28 60 02 21 30 A0 02 ?? ?? ?? ?? 21 38 80 02 02 00 40 14 18 00 BC 8F 00 00 53 AE ?? ?? 99 8F 21 20 20 02 30 00 A2 AF ?? ?? ?? ?? 01 00 05 24 54 00 BF 8F 30 00 A2 8F 50 00 B6 8F 4C 00 B5 8F 48 00 B4 8F 44 00 B3 8F 40 00 B2 8F 3C 00 B1 8F 38 00 B0 8F 08 00 E0 03 58 00 BD 27 }
	condition:
		$1
}

rule file_728_2_0 {
	meta:
		name = "__GI_getgrent_r"
		size = 312
		refs = "0000 _gp_disp 0018 _pthread_cleanup_push_defer 0024 __pthread_mutex_unlock 0064 __pthread_mutex_lock 0090 __GI_fopen 0088 $LC0 008c $LC1 00ac __GI___errno_location 00d0 __parsegrent 00d4 __pgsreader 00f8 _pthread_cleanup_pop_restore"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 A8 FF BD 27 38 00 B0 AF ?? ?? 90 8F ?? ?? 99 8F 4C 00 B5 AF 21 A8 A0 00 ?? ?? 85 8F 3C 00 B1 AF 20 00 B1 27 18 00 BC AF 54 00 BF AF 50 00 B6 AF 48 00 B4 AF 44 00 B3 AF 40 00 B2 AF 21 98 80 00 21 A0 C0 00 21 20 20 02 ?? ?? 06 26 ?? ?? ?? ?? 21 90 E0 00 18 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? ?? ?? 04 26 18 00 BC 8F 00 00 40 AE ?? ?? 90 8F ?? ?? 02 8E 12 00 40 14 21 B0 00 02 ?? ?? 84 8F ?? ?? 85 8F ?? ?? 99 8F ?? ?? 84 24 ?? ?? ?? ?? ?? ?? A5 24 ?? ?? 02 AE 07 00 40 14 18 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 42 8C 0E 00 00 10 18 00 BC 8F 01 00 03 24 34 00 43 AC ?? ?? C2 8E ?? ?? 84 8F ?? ?? 99 8F 10 00 A2 AF 21 28 60 02 21 30 A0 02 ?? ?? ?? ?? 21 38 80 02 02 00 40 14 18 00 BC 8F 00 00 53 AE ?? ?? 99 8F 21 20 20 02 30 00 A2 AF ?? ?? ?? ?? 01 00 05 24 54 00 BF 8F 30 00 A2 8F 50 00 B6 8F 4C 00 B5 8F 48 00 B4 8F 44 00 B3 8F 40 00 B2 8F 3C 00 B1 8F 38 00 B0 8F 08 00 E0 03 58 00 BD 27 }
	condition:
		$1
}

rule file_857_2_0 {
	meta:
		name = "__GI_getspent_r"
		size = 312
		refs = "0000 _gp_disp 0018 _pthread_cleanup_push_defer 0024 __pthread_mutex_unlock 0064 __pthread_mutex_lock 0090 __GI_fopen 0088 $LC0 008c $LC1 00ac __GI___errno_location 00d0 __parsespent 00d4 __pgsreader 00f8 _pthread_cleanup_pop_restore"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 A8 FF BD 27 38 00 B0 AF ?? ?? 90 8F ?? ?? 99 8F 4C 00 B5 AF 21 A8 A0 00 ?? ?? 85 8F 3C 00 B1 AF 20 00 B1 27 18 00 BC AF 54 00 BF AF 50 00 B6 AF 48 00 B4 AF 44 00 B3 AF 40 00 B2 AF 21 98 80 00 21 A0 C0 00 21 20 20 02 ?? ?? 06 26 ?? ?? ?? ?? 21 90 E0 00 18 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? ?? ?? 04 26 18 00 BC 8F 00 00 40 AE ?? ?? 90 8F ?? ?? 02 8E 12 00 40 14 21 B0 00 02 ?? ?? 84 8F ?? ?? 85 8F ?? ?? 99 8F ?? ?? 84 24 ?? ?? ?? ?? ?? ?? A5 24 ?? ?? 02 AE 07 00 40 14 18 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 42 8C 0E 00 00 10 18 00 BC 8F 01 00 03 24 34 00 43 AC ?? ?? C2 8E ?? ?? 84 8F ?? ?? 99 8F 10 00 A2 AF 21 28 60 02 21 30 A0 02 ?? ?? ?? ?? 21 38 80 02 02 00 40 14 18 00 BC 8F 00 00 53 AE ?? ?? 99 8F 21 20 20 02 30 00 A2 AF ?? ?? ?? ?? 01 00 05 24 54 00 BF 8F 30 00 A2 8F 50 00 B6 8F 4C 00 B5 8F 48 00 B4 8F 44 00 B3 8F 40 00 B2 8F 3C 00 B1 8F 38 00 B0 8F 08 00 E0 03 58 00 BD 27 }
	condition:
		$1
}

rule file_85_0_0 {
	meta:
		name = "wcsrchr"
		size = 32
	strings:
		$1 = { 21 10 00 00 00 00 83 8C 26 30 65 00 0A 10 86 00 FC FF 60 14 04 00 84 24 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_86_0_0 {
	meta:
		name = "personality"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 28 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_87_0_0 {
	meta:
		name = "__GI_opendir"
		size = 356
		refs = "0000 _gp_disp 000c __GI_open 0040 __GI_fstat 0058 __GI___errno_location 0070 __GI_close 0084 __GI_fcntl 00a0 malloc 00dc calloc 00f8 free 0130 __pthread_mutex_init"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F 40 FF BD 27 01 00 05 3C 10 00 BC AF B4 00 B1 AF BC 00 BF AF B8 00 B2 AF B0 00 B0 AF ?? ?? ?? ?? 80 00 A5 24 21 88 40 00 43 00 40 04 10 00 BC 8F ?? ?? 99 8F 21 20 40 00 ?? ?? ?? ?? 18 00 A5 27 0C 00 41 04 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F 00 00 52 8C 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 21 20 20 02 32 00 00 10 00 00 12 AE ?? ?? 99 8F 21 20 20 02 02 00 05 24 ?? ?? ?? ?? 01 00 06 24 EF FF 40 04 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 30 00 04 24 21 80 40 00 15 00 40 10 10 00 BC 8F 00 00 51 AC 10 00 40 AC 08 00 40 AC 04 00 40 AC 6C 00 A2 8F 00 02 43 2C 01 00 60 54 00 02 02 24 14 00 02 AE ?? ?? 99 8F 14 00 05 8E ?? ?? ?? ?? 01 00 04 24 10 00 BC 8F 0F 00 40 14 0C 00 02 AE ?? ?? 99 8F ?? ?? ?? ?? 21 20 00 02 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 20 02 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 0C 00 03 24 07 00 00 10 00 00 43 AC ?? ?? 99 8F 18 00 04 26 ?? ?? ?? ?? 21 28 00 00 02 00 00 10 21 10 00 02 21 10 00 00 BC 00 BF 8F B8 00 B2 8F B4 00 B1 8F B0 00 B0 8F 08 00 E0 03 C0 00 BD 27 }
	condition:
		$1
}

rule file_88_0_0 {
	meta:
		name = "__GI_strsep"
		size = 176
		refs = "0000 _gp_disp 0040 __GI_strpbrk 0064 __GI_strchr"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D8 FF BD 27 20 00 B1 AF 10 00 BC AF 24 00 BF AF 1C 00 B0 AF 00 00 90 8C 1C 00 00 12 21 88 80 00 00 00 A2 80 17 00 40 50 00 00 20 AE 01 00 A3 80 0A 00 60 14 ?? ?? 99 8F 00 00 03 82 0E 00 62 50 21 10 00 02 0F 00 60 50 00 00 20 AE 01 00 04 26 21 28 40 00 02 00 00 10 ?? ?? 99 8F 21 20 00 02 09 F8 20 03 00 00 00 00 04 00 40 54 00 00 40 A0 04 00 00 10 00 00 20 AE 00 00 40 A0 01 00 42 24 00 00 22 AE 02 00 00 10 21 10 00 02 21 10 00 00 24 00 BF 8F 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_89_0_0 {
	meta:
		name = "__sigwait"
		size = 80
		refs = "0000 _gp_disp 000c __GI_sigwaitinfo"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F E0 FF BD 27 18 00 B0 AF 10 00 BC AF 1C 00 BF AF 21 80 A0 00 ?? ?? ?? ?? 21 28 00 00 FF FF 03 24 03 00 43 50 01 00 02 24 00 00 02 AE 21 10 00 00 1C 00 BF 8F 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_90_0_0 {
	meta:
		name = "gethostent"
		size = 92
		refs = "0000 _gp_disp 000c __GI___h_errno_location 0038 __GI_gethostent_r"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F D0 FF BD 27 2C 00 BF AF 18 00 BC AF ?? ?? ?? ?? 00 00 00 00 18 00 BC 8F 20 00 A7 27 10 00 A2 AF ?? ?? 84 8F ?? ?? 85 8F ?? ?? 99 8F ?? ?? 84 24 ?? ?? A5 24 ?? ?? ?? ?? 7E 00 06 24 2C 00 BF 8F 20 00 A2 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_91_0_0 {
	meta:
		name = "__GI_getlogin"
		size = 28
		refs = "0000 _gp_disp 0010 __GI_getenv 000c $LC0"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 84 8F ?? ?? 99 8F ?? ?? ?? ?? ?? ?? 84 24 }
	condition:
		$1
}

rule file_55_1_3 {
	meta:
		name = "__cxa_get_globals"
		size = 28
		refs = "0000 _gp_disp 0010 __emutls_get_address"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 84 8F ?? ?? 99 8F ?? ?? ?? ?? ?? ?? 84 24 }
	condition:
		$1
}

rule file_55_0_3 {
	meta:
		name = "__cxa_get_globals_fast"
		size = 28
		refs = "0000 _gp_disp 0010 __emutls_get_address"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 84 8F ?? ?? 99 8F ?? ?? ?? ?? ?? ?? 84 24 }
	condition:
		$1
}

rule file_15_19_2 {
	meta:
		name = "__pthread_once_fork_child"
		size = 120
		refs = "0000 _gp_disp 0010 __pthread_mutex_init 0038 pthread_cond_init"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 84 8F ?? ?? 99 8F E0 FF BD 27 ?? ?? 84 24 10 00 BC AF 1C 00 BF AF ?? ?? ?? ?? 21 28 00 00 10 00 BC 8F 21 28 00 00 ?? ?? 84 8F ?? ?? 99 8F ?? ?? ?? ?? ?? ?? 84 24 10 00 BC 8F FF 7F 04 3C FC FF 84 34 ?? ?? 82 8F ?? ?? 43 8C 2A 20 64 00 03 00 80 50 ?? ?? 40 AC 04 00 63 24 ?? ?? 43 AC 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_15_18_2 {
	meta:
		name = "__pthread_once_fork_parent"
		size = 28
		refs = "0000 _gp_disp 0010 __pthread_mutex_unlock"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 84 8F ?? ?? 99 8F ?? ?? ?? ?? ?? ?? 84 24 }
	condition:
		$1
}

rule file_15_17_2 {
	meta:
		name = "__pthread_once_fork_prepare"
		size = 28
		refs = "0000 _gp_disp 0010 __pthread_mutex_lock"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 84 8F ?? ?? 99 8F ?? ?? ?? ?? ?? ?? 84 24 }
	condition:
		$1
}

rule file_176_1_0 {
	meta:
		name = "gethostid"
		size = 284
		refs = "0000 _gp_disp 0010 __GI_open 000c $LC0 0040 __GI_read 0060 __GI_close 0080 __GI_gethostname 00ac __GI_gethostbyname_r 00e0 __GI_memcpy"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 84 8F ?? ?? 99 8F 18 FE BD 27 ?? ?? 84 24 18 00 BC AF DC 01 B0 AF E4 01 BF AF E0 01 B1 AF ?? ?? ?? ?? 21 28 00 00 21 80 40 00 11 00 40 04 18 00 BC 8F ?? ?? 99 8F 21 20 40 00 D0 01 A5 27 ?? ?? ?? ?? 04 00 06 24 18 00 BC 8F 21 20 00 02 05 00 40 10 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 25 00 00 10 D0 01 B0 8F ?? ?? ?? ?? 00 00 00 00 18 00 BC 8F ?? ?? 99 8F 6C 01 B1 27 21 20 20 02 ?? ?? ?? ?? 40 00 05 24 1A 00 40 04 18 00 BC 8F 6C 01 A2 83 18 00 40 10 21 80 00 00 CC 01 A2 27 ?? ?? 99 8F 10 00 A2 AF C4 01 A2 27 14 00 A2 AF 21 20 20 02 B0 01 A5 27 20 00 A6 27 ?? ?? ?? ?? 4C 01 07 24 CC 01 A2 8F 0B 00 40 10 18 00 BC 8F 10 00 43 8C ?? ?? 99 8F 0C 00 46 8C 00 00 65 8C ?? ?? ?? ?? C8 01 A4 27 C8 01 B0 8F 02 00 00 10 02 84 30 00 21 80 00 00 E4 01 BF 8F 21 10 00 02 E0 01 B1 8F DC 01 B0 8F 08 00 E0 03 E8 01 BD 27 }
	condition:
		$1
}

rule file_241_2_0 {
	meta:
		name = "hdestroy"
		size = 28
		refs = "0000 _gp_disp 0010 __GI_hdestroy_r"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 84 8F ?? ?? 99 8F ?? ?? ?? ?? ?? ?? 84 24 }
	condition:
		$1
}

rule file_91_1_0 {
	meta:
		name = "getlogin_r"
		size = 124
		refs = "0000 _gp_disp 001c __GI_getenv 0018 $LC0 0040 __GI_strncpy"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D8 FF BD 27 20 00 B1 AF 21 88 80 00 ?? ?? 84 8F ?? ?? 99 8F 10 00 BC AF 1C 00 B0 AF 24 00 BF AF ?? ?? 84 24 ?? ?? ?? ?? 21 80 A0 00 0A 00 40 10 10 00 BC 8F ?? ?? 99 8F 21 30 00 02 21 20 20 02 21 28 40 00 ?? ?? ?? ?? 21 80 30 02 FF FF 00 A2 02 00 00 10 21 10 00 00 FF FF 02 24 24 00 BF 8F 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_91_2_0 {
	meta:
		name = "cuserid"
		size = 96
		refs = "0000 _gp_disp 000c __GI_getlogin 003c $LC1 0048 __GI_strcpy"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F D8 FF BD 27 10 00 BC AF 18 00 A4 AF 24 00 BF AF ?? ?? ?? ?? 00 00 00 00 18 00 A4 8F 09 00 80 10 10 00 BC 8F 03 00 40 14 21 28 40 00 ?? ?? 85 8F ?? ?? A5 24 24 00 BF 8F ?? ?? 99 8F ?? ?? ?? ?? 28 00 BD 27 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_93_0_0 {
	meta:
		name = "__malloc_largebin_index"
		size = 128
	strings:
		$1 = { 02 1A 04 00 01 00 05 3C 2B 28 65 00 1A 00 A0 10 5F 00 02 24 00 FF 66 24 02 34 06 00 08 00 C6 30 04 38 C3 00 00 F0 E5 24 02 2C 05 00 04 00 A5 30 04 38 A7 00 00 C0 E2 24 02 14 02 00 02 00 42 30 04 38 47 00 C2 1B 07 00 82 43 07 00 27 18 03 00 21 28 C5 00 21 10 A2 00 24 18 68 00 23 18 62 00 80 10 03 00 13 00 63 24 06 20 64 00 54 00 42 24 03 00 84 30 21 10 44 00 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_93_1_0 {
	meta:
		name = "malloc"
		size = 2540
		refs = "0000 _gp_disp 0044 _pthread_cleanup_push_defer 0048 __pthread_mutex_unlock 004c __malloc_lock 0068 __pthread_mutex_lock 0080 __GI___errno_location 00b4 __malloc_state 00d0 __malloc_consolidate 0158 __malloc_largebin_index 034c __GI_abort 0548 malloc 059c __GI_mmap 06b8 __GI_sbrk 0754 _pthread_cleanup_pop_restore 0920 free"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 98 FF BD 27 18 00 BC AF 40 00 B0 AF 64 00 BF AF 60 00 BE AF 5C 00 B7 AF 58 00 B6 AF 54 00 B5 AF 50 00 B4 AF 4C 00 B3 AF 48 00 B2 AF 44 00 B1 AF 10 00 80 10 21 80 80 00 ?? ?? 99 8F ?? ?? 85 8F ?? ?? 86 8F 20 00 A3 27 21 20 60 00 ?? ?? ?? ?? 34 00 A3 AF 18 00 BC 8F ?? ?? 84 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 E0 FF 02 2E 08 00 40 14 18 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 0C 00 03 24 00 00 43 AC 49 02 00 10 21 10 00 00 0B 00 10 26 10 00 02 2E 03 00 40 14 10 00 11 24 F8 FF 11 24 24 88 11 02 ?? ?? 82 8F 00 00 49 8C 01 00 23 31 08 00 60 14 21 80 40 00 06 01 20 55 2C 00 02 8E ?? ?? 99 8F ?? ?? ?? ?? 21 20 40 00 00 01 00 10 18 00 BC 8F 2B 18 31 01 0A 00 60 14 00 01 32 2E 42 18 11 00 F8 FF 63 24 21 18 43 00 04 00 62 8C 04 00 40 10 00 00 00 00 08 00 44 8C 51 01 00 10 04 00 64 AC 0F 00 40 12 ?? ?? 99 8F 21 20 11 02 38 00 83 8C 2C 00 84 24 16 00 64 10 C2 98 11 00 21 88 71 00 04 00 25 8E 0C 00 62 8C 08 00 70 24 01 00 A5 34 04 00 25 AE 0C 00 82 AC 81 01 00 10 08 00 44 AC ?? ?? 39 27 ?? ?? ?? ?? 21 20 20 02 02 00 29 31 18 00 BC 8F 06 00 20 11 21 98 40 00 ?? ?? 84 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 18 00 BC 8F ?? ?? 8C 8F ?? ?? 98 8F 34 00 0B 26 21 68 60 01 FC FF 0E 24 10 00 2F 26 01 00 14 24 40 00 09 8E ?? ?? 83 8F 52 00 2B 11 21 38 A0 01 04 00 2A 8D 0C 00 22 8D 17 00 40 12 24 50 CA 01 16 00 4B 54 40 00 02 AE 30 00 84 8D 13 00 24 55 40 00 02 AE 2B 20 EA 01 10 00 80 50 40 00 02 AE 21 10 31 01 23 50 51 01 3C 00 62 AC 40 00 62 AC 30 00 62 AC 01 00 31 36 01 00 43 35 08 00 4B AC 0C 00 4B AC 04 00 31 AD 04 00 43 AC 21 10 4A 00 08 00 00 10 00 00 4A AC 40 00 02 AE 07 00 51 15 08 00 4D AC 21 50 2A 01 04 00 42 8D 01 00 42 34 04 00 42 AD 47 01 00 10 08 00 30 25 00 01 42 2D 07 00 40 10 ?? ?? 02 27 C2 30 0A 00 C0 20 06 00 21 20 84 01 2C 00 84 24 19 00 00 10 08 00 83 8C 21 C8 40 00 ?? ?? ?? ?? 21 20 40 01 C0 18 02 00 21 18 83 01 2C 00 63 24 08 00 65 8C 18 00 BC 8F 0E 00 A3 10 21 30 40 00 0C 00 64 8C 04 00 82 8C 2B 10 42 01 0A 00 40 14 01 00 4A 35 04 00 A2 8C 2B 10 42 01 03 00 40 50 0C 00 A4 8C FB FF 00 10 08 00 A5 8C 02 00 00 10 21 18 A0 00 21 20 60 00 43 11 06 00 CC 00 42 24 80 10 02 00 21 10 02 02 04 00 45 8C 04 30 D4 00 25 30 C5 00 04 00 46 AC 0C 00 24 AD 08 00 23 AD 0C 00 69 AC AC FF 00 10 08 00 89 AC 2E 00 40 56 01 00 73 26 C0 20 13 00 21 18 64 00 2C 00 64 24 0C 00 83 8C FC FF 05 24 27 00 64 50 01 00 73 26 04 00 62 8C 24 10 A2 00 2B 30 51 00 FA FF C0 54 0C 00 63 8C 08 00 66 8C 23 20 51 00 0C 00 C8 8C 04 00 03 15 0C 00 65 8C 08 00 A8 8C 04 00 03 51 0C 00 C5 AC ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 08 00 A6 AC 10 00 86 2C 06 00 C0 10 08 00 65 24 21 18 62 00 04 00 62 8C 01 00 42 34 0C 00 00 10 04 00 62 AC 21 10 71 00 01 00 31 36 3C 00 02 AE 40 00 02 AE 08 00 47 AC 0C 00 47 AC 04 00 71 AC 01 00 83 34 04 00 43 AC 21 10 44 00 00 00 44 AC EA 00 00 10 21 80 A0 00 42 31 13 00 CC 00 C2 24 80 10 02 00 21 10 02 02 C0 18 13 00 ?? ?? 88 8F 21 18 03 02 04 00 45 8C 01 00 02 24 2C 00 63 24 04 10 62 02 2B 20 A2 00 04 00 80 54 01 00 C6 24 0F 00 40 14 24 20 45 00 01 00 C6 24 03 00 C2 2C 39 00 40 10 CC 00 C2 24 80 10 02 00 21 10 02 02 04 00 45 8C F9 FF A0 50 01 00 C6 24 00 1A 06 00 21 18 03 01 2C 00 63 24 01 00 02 24 24 20 45 00 04 00 80 54 0C 00 64 8C 08 00 63 24 FB FF 00 10 40 10 02 00 0A 00 83 54 04 00 82 8C 27 20 02 00 24 28 A4 00 CC 00 C4 24 80 20 04 00 21 20 04 02 04 00 85 AC 08 00 63 24 DE FF 00 10 40 10 02 00 0C 00 86 8C FC FF 05 24 24 10 A2 00 23 28 51 00 0C 00 66 AC 08 00 C3 AC 10 00 A6 2C 06 00 C0 10 08 00 83 24 21 20 82 00 04 00 82 8C 01 00 42 34 0F 00 00 10 04 00 82 AC 21 10 91 00 3C 00 02 AE 40 00 02 AE 08 00 47 AC 03 00 40 12 0C 00 47 AC ?? ?? 86 8F 30 00 C2 AC 01 00 31 36 04 00 91 AC 01 00 A4 34 04 00 44 AC 21 10 45 00 00 00 45 AC 9E 00 00 10 21 80 60 00 2C 00 02 8E FC FF 05 24 04 00 43 8C 24 28 A3 00 10 00 23 26 30 00 A3 AF 2B 18 A3 00 09 00 60 14 ?? ?? 84 8F 21 18 51 00 23 28 B1 00 2C 00 83 AC 01 00 A5 34 01 00 24 36 04 00 44 AC 4D 00 00 10 04 00 65 AC 00 00 82 8C 5C 03 92 8C 02 00 42 30 0B 00 40 10 FF FF 55 26 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 18 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? F9 FF 24 26 21 80 40 00 7E 00 00 10 18 00 BC 8F 4C 03 82 8C 2B 10 22 02 3C 00 40 14 27 B8 15 00 50 03 83 8C 54 03 82 8C 2A 10 62 00 38 00 40 50 2C 00 14 8E 0A 00 52 26 21 90 51 02 24 90 57 02 2B 10 32 02 32 00 40 50 2C 00 14 8E ?? ?? 99 8F 10 00 A0 AF 14 00 A0 AF 21 20 00 00 21 28 40 02 03 00 06 24 ?? ?? ?? ?? 02 08 07 24 FF FF 03 24 26 00 43 10 18 00 BC 8F 07 00 43 30 08 00 60 50 00 00 40 AC 08 00 04 24 23 18 83 00 21 10 43 00 00 00 43 AC 23 18 43 02 02 00 00 10 02 00 63 34 02 00 43 36 04 00 43 AC 50 03 03 8E 58 03 04 8E 01 00 63 24 2A 20 83 00 03 00 80 10 50 03 03 AE ?? ?? 84 8F 58 03 83 AC 64 03 03 8E 21 90 43 02 70 03 03 8E 2B 18 72 00 03 00 60 10 64 03 12 AE ?? ?? 83 8F 70 03 72 AC 68 03 03 8E 21 90 43 02 74 03 03 8E 2B 18 72 00 02 00 60 10 ?? ?? 83 8F 74 03 72 AC 3F 00 00 10 08 00 50 24 2C 00 14 8E FC FF 03 24 48 03 12 8E 04 00 82 8E 10 00 52 26 24 B0 62 00 60 03 02 8E 21 90 51 02 01 00 42 30 02 18 56 70 23 90 43 02 21 90 55 02 24 90 57 02 09 00 40 1E 21 F0 96 02 60 03 02 8E 01 00 42 30 0F 00 40 10 10 00 02 3C 21 10 D5 02 21 90 52 00 0A 00 00 10 24 90 57 02 ?? ?? 99 8F ?? ?? ?? ?? 21 20 40 02 21 98 40 00 FF FF 02 24 27 00 62 16 18 00 BC 8F F1 FF 00 10 60 03 02 8E 10 00 02 3C 2B 20 42 02 0B 90 44 00 2B 10 32 02 14 00 40 10 ?? ?? 99 8F ?? ?? 99 8F 10 00 A0 AF 14 00 A0 AF 21 20 00 00 21 28 40 02 03 00 06 24 ?? ?? ?? ?? 02 08 07 24 21 98 40 00 FF FF 02 24 07 00 62 12 18 00 BC 8F 60 03 05 8E FE FF 04 24 21 10 72 02 24 20 A4 00 0D 00 00 10 60 03 04 AE ?? ?? 99 8F ?? ?? ?? ?? 21 80 00 00 0C 00 03 24 18 00 BC 8F 00 00 43 AC ?? ?? 99 8F 20 00 A4 27 ?? ?? ?? ?? 01 00 05 24 95 00 00 10 21 10 00 02 68 03 04 8E 21 20 44 02 08 00 7E 16 68 03 04 AE FF FF 05 24 06 00 45 54 60 03 05 8E 21 18 56 02 01 00 63 34 6A 00 00 10 04 00 83 AE 60 03 05 8E 01 00 A6 30 0B 00 C0 50 60 03 05 8E 09 00 C0 52 60 03 05 8E 2B 30 7E 02 06 00 C0 50 60 03 05 8E FE FF 06 24 24 28 A6 00 ?? ?? 86 8F 60 03 C5 AC 60 03 05 8E 01 00 A5 30 2A 00 A0 10 ?? ?? 86 8F 04 00 C0 12 07 00 62 32 23 40 7E 02 21 20 04 01 68 03 C4 AC 05 00 40 50 21 F0 60 02 08 00 04 24 23 10 82 00 02 00 00 10 21 F0 62 02 21 10 00 00 21 10 56 00 21 20 52 00 21 20 64 02 21 A8 95 00 24 B8 B7 02 ?? ?? 95 8F 23 10 44 00 21 B8 57 00 21 C8 A0 02 ?? ?? ?? ?? 21 20 E0 02 FF FF 04 24 06 00 44 14 18 00 BC 8F 21 C8 A0 02 ?? ?? ?? ?? 21 20 00 00 09 00 00 10 18 00 BC 8F 2B 20 53 00 18 00 80 10 FF FF 04 24 60 03 06 8E FE FF 04 24 21 10 72 02 24 20 C4 00 60 03 04 AE 10 00 00 10 21 B8 00 00 FF FF 04 24 21 F0 60 02 0F 00 44 14 21 B8 00 00 ?? ?? 99 8F 21 20 00 00 ?? ?? ?? ?? 38 00 A6 AF 38 00 A6 8F 23 20 53 00 23 90 92 00 68 03 C4 8C 18 00 BC 8F 21 90 44 02 68 03 D2 AC FF FF 04 24 1F 00 44 50 68 03 02 8E 23 10 5E 00 21 10 57 00 01 00 42 34 2C 00 1E AE 04 00 C2 AF 68 03 02 8E ?? ?? 93 8F 21 B8 E2 02 14 00 C0 12 68 03 17 AE F8 FF 02 24 F4 FF C3 26 24 18 62 00 01 00 62 34 04 00 82 AE 05 00 04 24 21 10 83 02 10 00 63 2C 04 00 44 AC 09 00 60 14 08 00 44 AC 44 03 72 8E ?? ?? 99 8F FF FF 02 24 44 03 62 AE ?? ?? ?? ?? 08 00 84 26 18 00 BC 8F 44 03 72 AE 68 03 02 8E 6C 03 03 8E 2B 18 62 00 04 00 60 50 64 03 03 8E ?? ?? 83 8F 6C 03 62 AC 64 03 03 8E 21 10 43 00 74 03 03 8E 2B 18 62 00 04 00 60 50 2C 00 10 8E ?? ?? 83 8F 74 03 62 AC 2C 00 10 8E 30 00 B9 8F FC FF 03 24 04 00 02 8E 24 18 62 00 2B F0 79 00 6A FF C0 17 ?? ?? 84 8F 21 10 11 02 23 18 71 00 2C 00 82 AC 01 00 63 34 01 00 24 36 04 00 04 AE 04 00 43 AC 67 FF 00 10 08 00 10 26 64 00 BF 8F 60 00 BE 8F 5C 00 B7 8F 58 00 B6 8F 54 00 B5 8F 50 00 B4 8F 4C 00 B3 8F 48 00 B2 8F 44 00 B1 8F 40 00 B0 8F 08 00 E0 03 68 00 BD 27 }
	condition:
		$1
}

rule file_94_0_0 {
	meta:
		name = "ulimit"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF DA 0F 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_95_0_0 {
	meta:
		name = "__GI_strtof"
		size = 136
		refs = "0000 _gp_disp 000c __strtofpmax 0034 __truncdfsf2 004c __extendsfdf2 0064 __fp_range_check"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F D8 FF BD 27 24 00 BF AF 20 00 B0 AF 10 00 BC AF ?? ?? ?? ?? 21 30 00 00 10 00 BC 8F 21 28 60 00 1C 00 A3 AF ?? ?? 99 8F 21 20 40 00 ?? ?? ?? ?? 18 00 A2 AF 10 00 BC 8F 21 20 40 00 ?? ?? 99 8F ?? ?? ?? ?? 21 80 40 00 10 00 BC 8F 18 00 A6 8F 1C 00 A7 8F ?? ?? 99 8F 21 20 40 00 ?? ?? ?? ?? 21 28 60 00 24 00 BF 8F 21 10 00 02 20 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_607_0_0 {
	meta:
		name = "__GI_wcstof"
		size = 136
		refs = "0000 _gp_disp 000c __wcstofpmax 0034 __truncdfsf2 004c __extendsfdf2 0064 __fp_range_check"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F D8 FF BD 27 24 00 BF AF 20 00 B0 AF 10 00 BC AF ?? ?? ?? ?? 21 30 00 00 10 00 BC 8F 21 28 60 00 1C 00 A3 AF ?? ?? 99 8F 21 20 40 00 ?? ?? ?? ?? 18 00 A2 AF 10 00 BC 8F 21 20 40 00 ?? ?? 99 8F ?? ?? ?? ?? 21 80 40 00 10 00 BC 8F 18 00 A6 8F 1C 00 A7 8F ?? ?? 99 8F 21 20 40 00 ?? ?? ?? ?? 21 28 60 00 24 00 BF 8F 21 10 00 02 20 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_96_0_0 {
	meta:
		name = "__stdio_trans2r_o"
		size = 208
		refs = "0000 _gp_disp 0038 __GI___errno_location 0088 __stdio_wcommit"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 18 00 B0 AF 10 00 BC AF 1C 00 BF AF 00 00 82 94 24 18 A2 00 0B 00 60 14 21 80 80 00 80 08 43 30 07 00 60 50 25 10 A2 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 09 00 03 24 08 00 00 10 00 00 43 AC 00 00 82 A4 00 00 02 96 10 00 43 30 08 00 60 50 40 00 42 30 F5 FF 00 10 ?? ?? 99 8F 00 00 02 96 08 00 42 34 00 00 02 A6 11 00 00 10 FF FF 02 24 0C 00 40 50 00 00 02 96 ?? ?? 99 8F ?? ?? ?? ?? 21 20 00 02 F6 FF 40 54 00 00 02 96 08 00 02 8E 1C 00 02 AE 00 00 02 96 BF FF 42 30 00 00 02 A6 00 00 02 96 01 00 42 34 00 00 02 A6 21 10 00 00 1C 00 BF 8F 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_97_0_0 {
	meta:
		name = "tmpfile"
		size = 192
		refs = "0000 _gp_disp 0014 ___path_search 000c $LC0 0050 __gen_tempname 006c __GI_remove 0084 __GI_fdopen 0080 $LC1 009c __GI_close"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 87 8F D8 EF BD 27 ?? ?? 99 8F 1C 10 B0 AF 18 00 B0 27 10 00 BC AF 24 10 BF AF 20 10 B1 AF 21 20 00 02 FF 0F 05 24 21 30 00 00 ?? ?? ?? ?? ?? ?? E7 24 03 00 40 10 10 00 BC 8F 17 00 00 10 21 80 00 00 ?? ?? 99 8F 21 20 00 02 ?? ?? ?? ?? 21 28 00 00 21 88 40 00 F8 FF 40 04 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 00 02 10 00 BC 8F 21 20 20 02 ?? ?? 85 8F ?? ?? 99 8F ?? ?? ?? ?? ?? ?? A5 24 21 80 40 00 04 00 40 14 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 20 02 24 10 BF 8F 21 10 00 02 20 10 B1 8F 1C 10 B0 8F 08 00 E0 03 28 10 BD 27 }
	condition:
		$1
}

rule file_98_0_0 {
	meta:
		name = "_stdio_fopen"
		size = 840
		refs = "0000 _gp_disp 0054 __GI___errno_location 00a8 malloc 00b8 __GI_open 00f0 free 0120 __stdio_init_mutex 0164 __GI_fcntl 01fc __GI_isatty 027c _stdio_user_locking 0298 __pthread_mutex_unlock 029c _stdio_openlist_del_lock 02a0 _pthread_cleanup_push_defer 02b4 __pthread_mutex_lock 02c8 _stdio_openlist_add_lock 02fc _stdio_openlist 0300 _pthread_cleanup_pop_restore"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 B0 FF BD 27 48 00 B3 AF 44 00 B2 AF 3C 00 B0 AF 10 00 BC AF 4C 00 BF AF 40 00 B1 AF 00 00 A2 80 72 00 03 24 21 90 80 00 21 80 C0 00 0F 00 43 10 21 98 E0 00 77 00 03 24 2F 00 43 10 61 00 03 24 0B 00 43 10 09 01 11 24 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 16 00 03 24 10 00 BC 8F 1D 00 00 16 00 00 43 AC AD 00 00 10 21 80 00 00 21 88 00 00 01 00 A2 80 62 00 42 38 01 00 42 2C 21 28 A2 00 01 00 A3 80 2B 00 02 24 03 00 62 14 00 00 00 00 01 00 31 36 01 00 31 26 19 00 00 12 ?? ?? 99 8F 24 00 61 06 03 20 22 32 00 20 22 36 ?? ?? 99 8F 27 98 13 00 0B 88 53 00 21 20 40 02 21 28 20 02 ?? ?? ?? ?? B6 01 06 24 10 00 BC 8F 2E 00 41 04 04 00 02 AE 00 00 02 96 00 20 42 30 8F 00 40 50 21 80 00 00 ?? ?? 99 8F ?? ?? ?? ?? 21 20 00 02 8A 00 00 10 21 80 00 00 DD FF 00 10 01 03 11 24 ?? ?? ?? ?? 50 00 04 24 21 80 40 00 F8 FF 40 10 10 00 BC 8F ?? ?? 99 8F 00 20 02 24 00 00 02 A6 08 00 00 AE ?? ?? ?? ?? 38 00 04 26 DC FF 00 10 10 00 BC 8F 01 00 42 24 01 00 43 26 24 18 43 00 C1 FF 62 14 04 00 13 AE 27 10 12 00 08 00 42 30 24 10 51 00 04 00 40 14 ?? ?? 99 8F 00 20 52 32 09 00 00 10 25 88 32 02 21 20 60 02 04 00 05 24 ?? ?? ?? ?? 08 00 06 24 B3 FF 40 14 10 00 BC 8F F7 FF 00 10 00 20 52 32 08 00 22 32 00 00 04 96 00 20 25 32 03 00 31 32 01 00 31 26 03 00 31 3A 00 20 84 30 00 04 03 24 00 89 11 00 0A 18 02 00 25 20 91 00 00 80 02 34 0A 10 05 00 25 18 64 00 25 10 43 00 04 00 12 8E 00 00 02 A6 FF 7F 02 3C FF FF 42 34 0F 00 42 12 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F 21 20 40 02 21 88 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 53 8C 04 00 40 10 10 00 BC 8F 00 00 02 96 00 01 42 34 00 00 02 A6 00 00 33 AE 08 00 02 8E 10 00 40 54 02 00 00 A2 ?? ?? 99 8F ?? ?? ?? ?? 00 10 04 24 10 00 BC 8F 07 00 40 10 08 00 02 AE 00 10 42 24 0C 00 02 AE 00 00 02 96 00 40 42 34 02 00 00 10 00 00 02 A6 0C 00 00 AE 08 00 02 8E 02 00 00 A2 2C 00 00 AE 18 00 02 AE 1C 00 02 AE 10 00 02 AE 14 00 02 AE ?? ?? 82 8F 00 00 42 8C 34 00 02 AE 00 00 02 96 00 20 42 30 26 00 40 10 4C 00 BF 8F ?? ?? 85 8F ?? ?? 86 8F ?? ?? 99 8F 28 00 B1 27 ?? ?? ?? ?? 21 20 20 02 10 00 BC 8F ?? ?? 99 8F ?? ?? 84 8F ?? ?? ?? ?? 18 00 B2 27 10 00 BC 8F ?? ?? 86 8F ?? ?? 85 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 40 02 10 00 BC 8F ?? ?? 84 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F 21 20 40 02 01 00 05 24 ?? ?? 82 8F ?? ?? 99 8F 00 00 43 8C 00 00 50 AC ?? ?? ?? ?? 20 00 03 AE 10 00 BC 8F 21 20 20 02 ?? ?? 99 8F ?? ?? ?? ?? 01 00 05 24 4C 00 BF 8F 21 10 00 02 48 00 B3 8F 44 00 B2 8F 40 00 B1 8F 3C 00 B0 8F 08 00 E0 03 50 00 BD 27 }
	condition:
		$1
}

rule file_99_0_0 {
	meta:
		name = "__GI_wcscasecmp"
		size = 180
		refs = "0000 _gp_disp 0014 __GI_towlower"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 C8 FF BD 27 28 00 B3 AF ?? ?? 93 8F 24 00 B2 AF 1C 00 B0 AF 10 00 BC AF 34 00 BF AF 30 00 B5 AF 2C 00 B4 AF 20 00 B1 AF 21 80 80 00 21 90 A0 00 00 00 11 8E 00 00 55 8E 05 00 35 16 21 C8 60 02 0F 00 20 12 04 00 10 26 F9 FF 00 10 04 00 52 26 ?? ?? ?? ?? 21 20 20 02 21 20 A0 02 21 C8 60 02 ?? ?? ?? ?? 21 A0 40 00 F5 FF 82 12 2B A0 82 02 01 00 03 24 FF FF 02 24 02 00 00 10 0A 10 74 00 21 10 00 00 34 00 BF 8F 30 00 B5 8F 2C 00 B4 8F 28 00 B3 8F 24 00 B2 8F 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_100_0_0 {
	meta:
		name = "getnetbyname"
		size = 248
		refs = "0000 _gp_disp 0014 _net_stayopen 0038 __GI_setnetent 0050 __GI_getnetent 0054 __GI_strcmp 00c0 __GI_endnetent"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 C8 FF BD 27 18 00 B0 AF ?? ?? 90 8F 10 00 BC AF 2C 00 B5 AF 28 00 B4 AF 24 00 B3 AF 20 00 B2 AF 34 00 BF AF 30 00 B6 AF 1C 00 B1 AF ?? ?? 99 8F 21 90 80 00 00 00 04 8E ?? ?? ?? ?? 21 98 00 02 10 00 BC 8F ?? ?? 94 8F ?? ?? 95 8F 21 C8 80 02 ?? ?? ?? ?? 00 00 00 00 21 80 40 00 12 00 40 10 10 00 BC 8F 00 00 04 8E 21 C8 A0 02 ?? ?? ?? ?? 21 28 40 02 10 00 BC 8F 0B 00 40 10 ?? ?? 96 8F 04 00 11 8E 00 00 24 8E F0 FF 80 10 21 C8 C0 02 ?? ?? ?? ?? 21 28 40 02 03 00 40 10 10 00 BC 8F F8 FF 00 10 04 00 31 26 00 00 62 8E 05 00 40 14 34 00 BF 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 34 00 BF 8F 21 10 00 02 30 00 B6 8F 2C 00 B5 8F 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_101_0_0 {
	meta:
		name = "__GI_vfprintf"
		size = 244
		refs = "0000 _gp_disp 0040 _pthread_cleanup_push_defer 0044 __pthread_mutex_unlock 005c __pthread_mutex_lock 007c __stdio_trans2w_o 0080 _vfprintf_internal 00bc _pthread_cleanup_pop_restore"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 B8 FF BD 27 40 00 B4 AF 3C 00 B3 AF 30 00 B0 AF 10 00 BC AF 44 00 BF AF 38 00 B2 AF 34 00 B1 AF 34 00 91 8C 21 80 80 00 21 98 A0 00 0C 00 20 16 21 A0 C0 00 ?? ?? 99 8F ?? ?? 85 8F 38 00 92 24 21 30 40 02 ?? ?? ?? ?? 18 00 A4 27 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 40 02 10 00 BC 8F 00 00 03 96 C0 00 02 24 C0 00 63 30 08 00 62 14 ?? ?? 99 8F ?? ?? 99 8F 21 20 00 02 21 28 60 02 ?? ?? ?? ?? 21 30 80 02 07 00 00 10 10 00 BC 8F 21 20 00 02 ?? ?? ?? ?? 80 00 05 24 F5 FF 40 10 10 00 BC 8F FF FF 02 24 08 00 20 16 44 00 BF 8F ?? ?? 99 8F 28 00 A2 AF 18 00 A4 27 ?? ?? ?? ?? 01 00 05 24 28 00 A2 8F 44 00 BF 8F 40 00 B4 8F 3C 00 B3 8F 38 00 B2 8F 34 00 B1 8F 30 00 B0 8F 08 00 E0 03 48 00 BD 27 }
	condition:
		$1
}

rule file_102_0_0 {
	meta:
		name = "tempnam"
		size = 124
		refs = "0000 _gp_disp 0010 ___path_search 0048 __gen_tempname 0060 __GI_strdup"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 EF BD 27 ?? ?? 99 8F 18 10 B0 AF 18 00 B0 27 10 00 BC AF 21 30 80 00 21 38 A0 00 1C 10 BF AF 21 20 00 02 ?? ?? ?? ?? FF 0F 05 24 03 00 40 10 10 00 BC 8F 0A 00 00 10 21 10 00 00 ?? ?? 99 8F 21 20 00 02 ?? ?? ?? ?? 03 00 05 24 F9 FF 40 14 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 00 02 1C 10 BF 8F 18 10 B0 8F 08 00 E0 03 20 10 BD 27 }
	condition:
		$1
}

rule file_103_0_0 {
	meta:
		name = "__freadable"
		size = 16
	strings:
		$1 = { 00 00 82 94 10 00 42 38 08 00 E0 03 00 01 42 7C }
	condition:
		$1
}

rule file_104_0_0 {
	meta:
		name = "sigandset"
		size = 60
	strings:
		$1 = { 04 00 02 24 FF FF 07 24 FF FF 42 24 09 00 47 10 80 18 02 00 21 40 83 00 21 48 C3 00 21 18 A3 00 00 00 29 8D 00 00 63 8C 24 18 23 01 F6 FF 00 10 00 00 03 AD 08 00 E0 03 21 10 00 00 }
	condition:
		$1
}

rule file_105_0_0 {
	meta:
		name = "__GI_isspace"
		size = 40
		refs = "0000 _gp_disp 000c __GI___ctype_b"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F 40 20 04 00 00 00 42 8C 21 10 44 00 00 00 42 94 08 00 E0 03 20 00 42 30 }
	condition:
		$1
}

rule file_106_0_0 {
	meta:
		name = "__GI_adjtimex"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 1C 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_107_0_0 {
	meta:
		name = "__encode_question"
		size = 148
		refs = "0000 _gp_disp 0028 __encode_dotted"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D8 FF BD 27 20 00 B2 AF 1C 00 B1 AF 18 00 B0 AF 10 00 BC AF 24 00 BF AF 21 80 80 00 ?? ?? 99 8F 00 00 84 8C 21 90 A0 00 ?? ?? ?? ?? 21 88 C0 00 0F 00 40 04 23 88 22 02 04 00 31 2A 0B 00 20 16 21 28 42 02 05 00 03 92 04 00 42 24 00 00 A3 A0 04 00 03 8E 01 00 A3 A0 09 00 03 92 02 00 A3 A0 08 00 03 8E 02 00 00 10 03 00 A3 A0 FF FF 02 24 24 00 BF 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_108_0_0 {
	meta:
		name = "msgsnd"
		size = 64
		refs = "0000 _gp_disp 000c __syscall_ipc"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F D8 FF BD 27 21 10 80 00 0B 00 04 24 24 00 BF AF 18 00 BC AF 10 00 A5 AF 14 00 A0 AF ?? ?? ?? ?? 21 28 40 00 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_110_0_0 {
	meta:
		name = "atoll"
		size = 28
		refs = "0000 _gp_disp 000c __GI_strtoll"
		altNames = "__GI_atol"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F 21 28 00 00 ?? ?? ?? ?? 0A 00 06 24 }
	condition:
		$1
}

rule file_668_0_0 {
	meta:
		name = "setlinebuf"
		size = 32
		refs = "0000 _gp_disp 000c __GI_setvbuf"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F 21 28 00 00 01 00 06 24 ?? ?? ?? ?? 21 38 00 00 }
	condition:
		$1
}

rule file_111_0_0 {
	meta:
		name = "__GI_gethostbyaddr"
		size = 128
		refs = "0000 _gp_disp 000c __GI___h_errno_location 0050 __GI_gethostbyaddr_r"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F B8 FF BD 27 44 00 BF AF 20 00 BC AF 30 00 A4 AF 34 00 A5 AF 38 00 A6 AF ?? ?? ?? ?? 00 00 00 00 20 00 BC 8F 30 00 A4 8F 34 00 A5 8F ?? ?? 83 8F ?? ?? 87 8F 38 00 A6 8F ?? ?? 63 24 10 00 A3 AF ?? ?? 99 8F CC 01 03 24 14 00 A3 AF 28 00 A3 27 18 00 A3 AF 1C 00 A2 AF ?? ?? ?? ?? ?? ?? E7 24 44 00 BF 8F 28 00 A2 8F 08 00 E0 03 48 00 BD 27 }
	condition:
		$1
}

rule file_112_0_0 {
	meta:
		name = "__GI_fcntl"
		size = 132
		refs = "0000 _gp_disp 0038 __GI_fcntl64 005c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D8 FF BD 27 30 00 A2 27 18 00 A2 AF DF FF A2 24 10 00 BC AF 03 00 42 2C 24 00 BF AF 20 00 B0 AF 30 00 A6 AF 06 00 40 10 34 00 A7 AF ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 0A 00 00 10 21 80 40 00 D7 0F 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 24 00 BF 8F 21 10 00 02 20 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_113_0_0 {
	meta:
		name = "iopl"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 0E 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_114_0_0 {
	meta:
		name = "wscanf"
		size = 80
		refs = "0000 _gp_disp 000c stdin 002c __GI_vfwscanf"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F D8 FF BD 27 24 00 BF AF 10 00 BC AF 2C 00 A5 AF 30 00 A6 AF 34 00 A7 AF 21 28 80 00 ?? ?? 99 8F 00 00 44 8C 2C 00 A6 27 18 00 A6 AF ?? ?? ?? ?? 00 00 00 00 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_247_0_0 {
	meta:
		name = "__GI_printf"
		size = 80
		refs = "0000 _gp_disp 000c stdout 002c __GI_vfprintf"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F D8 FF BD 27 24 00 BF AF 10 00 BC AF 2C 00 A5 AF 30 00 A6 AF 34 00 A7 AF 21 28 80 00 ?? ?? 99 8F 00 00 44 8C 2C 00 A6 27 18 00 A6 AF ?? ?? ?? ?? 00 00 00 00 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_240_0_0 {
	meta:
		name = "scanf"
		size = 80
		refs = "0000 _gp_disp 000c stdin 002c __GI_vfscanf"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F D8 FF BD 27 24 00 BF AF 10 00 BC AF 2C 00 A5 AF 30 00 A6 AF 34 00 A7 AF 21 28 80 00 ?? ?? 99 8F 00 00 44 8C 2C 00 A6 27 18 00 A6 AF ?? ?? ?? ?? 00 00 00 00 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_503_0_0 {
	meta:
		name = "wprintf"
		size = 80
		refs = "0000 _gp_disp 000c stdout 002c __GI_vfwprintf"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F D8 FF BD 27 24 00 BF AF 10 00 BC AF 2C 00 A5 AF 30 00 A6 AF 34 00 A7 AF 21 28 80 00 ?? ?? 99 8F 00 00 44 8C 2C 00 A6 27 18 00 A6 AF ?? ?? ?? ?? 00 00 00 00 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_115_0_0 {
	meta:
		name = "__stdio_wcommit"
		size = 88
		refs = "0000 _gp_disp 0030 __stdio_WRITE"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 08 00 85 8C 10 00 86 8C E0 FF BD 27 10 00 BC AF 23 30 C5 00 18 00 B0 AF 1C 00 BF AF 04 00 C0 10 21 80 80 00 ?? ?? 99 8F ?? ?? ?? ?? 10 00 85 AC 10 00 03 8E 08 00 02 8E 1C 00 BF 8F 18 00 B0 8F 23 10 62 00 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_116_0_0 {
	meta:
		name = "__GI_sleep"
		size = 424
		refs = "0000 _gp_disp 0044 __GI___sigaddset 0078 __GI_sigprocmask 0098 __GI___sigismember 00ac __GI_nanosleep 00dc __GI_sigaction 010c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 80 FF BD 27 10 00 BC AF 7C 00 BF AF 78 00 B5 AF 74 00 B4 AF 70 00 B3 AF 6C 00 B2 AF 68 00 B1 AF 64 00 B0 AF 54 00 A4 AF 03 00 80 14 58 00 A0 AF 51 00 00 10 21 10 00 00 ?? ?? 95 8F 44 00 B3 27 21 20 60 02 12 00 05 24 21 C8 A0 02 50 00 A0 AF 4C 00 A0 AF 48 00 A0 AF ?? ?? ?? ?? 44 00 A0 AF 10 00 BC 8F 34 00 B0 27 01 00 04 24 ?? ?? 92 8F 21 28 60 02 21 C8 40 02 ?? ?? ?? ?? 21 30 00 02 10 00 BC 8F 21 20 00 02 12 00 05 24 ?? ?? 99 8F ?? ?? ?? ?? 54 00 B1 27 10 00 BC 8F 28 00 40 14 ?? ?? 94 8F 21 20 60 02 12 00 05 24 21 C8 A0 02 50 00 A0 AF 4C 00 A0 AF 48 00 A0 AF ?? ?? ?? ?? 44 00 A0 AF 10 00 BC 8F 12 00 04 24 21 28 00 00 ?? ?? 99 8F ?? ?? ?? ?? 18 00 A6 27 1C 00 A3 8F 01 00 02 24 12 00 62 14 03 00 04 24 21 20 20 02 21 C8 80 02 ?? ?? ?? ?? 21 28 20 02 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 88 40 00 00 00 54 8C 21 98 40 00 03 00 04 24 21 28 00 02 21 C8 40 02 ?? ?? ?? ?? 21 30 00 00 0A 00 00 10 00 00 74 AE 21 28 00 02 21 C8 40 02 ?? ?? ?? ?? 21 30 00 00 21 20 20 02 21 C8 80 02 ?? ?? ?? ?? 21 28 20 02 21 88 40 00 08 00 20 12 21 10 00 00 58 00 A3 8F CD 1D 02 3C 00 65 42 24 2A 10 62 00 54 00 A3 8F 01 00 42 38 21 10 43 00 7C 00 BF 8F 78 00 B5 8F 74 00 B4 8F 70 00 B3 8F 6C 00 B2 8F 68 00 B1 8F 64 00 B0 8F 08 00 E0 03 80 00 BD 27 }
	condition:
		$1
}

rule file_117_0_0 {
	meta:
		name = "__GI_xdr_array"
		size = 444
		refs = "0000 _gp_disp 0010 __GI_xdr_u_int 00d8 malloc 00f4 stderr 00fc __GI_fputs 00f8 $LC0 0118 __GI_memset 0180 free"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 C8 FF BD 27 ?? ?? 99 8F 10 00 BC AF 30 00 B6 AF 2C 00 B5 AF 28 00 B4 AF 24 00 B3 AF 20 00 B2 AF 1C 00 B1 AF 34 00 BF AF 18 00 B0 AF 00 00 B0 8C 21 98 A0 00 21 28 C0 00 21 A0 80 00 21 90 C0 00 21 B0 E0 00 ?? ?? ?? ?? 48 00 B5 8F 21 88 00 00 4C 00 40 10 10 00 BC 8F 00 00 52 8E 2B B0 D2 02 09 00 C0 56 00 00 83 8E FF FF 02 24 1B 00 55 00 F4 01 A0 02 12 10 00 00 2B 10 52 00 05 00 40 10 00 00 00 00 00 00 83 8E 02 00 02 24 3D 00 62 14 21 88 00 00 24 00 00 16 01 00 02 24 00 00 82 8E 01 00 03 24 06 00 43 10 01 00 11 24 02 00 03 24 35 00 43 10 34 00 BF 8F 1B 00 00 10 01 00 02 24 31 00 40 12 34 00 BF 8F 02 88 55 72 ?? ?? 99 8F ?? ?? ?? ?? 21 20 20 02 21 80 40 00 10 00 BC 8F 0A 00 40 14 00 00 62 AE ?? ?? 82 8F ?? ?? 84 8F ?? ?? 99 8F 00 00 45 8C ?? ?? 84 24 ?? ?? ?? ?? 21 88 00 00 20 00 00 10 34 00 BF 8F ?? ?? 99 8F 21 20 40 00 21 28 00 00 ?? ?? ?? ?? 21 30 20 02 10 00 BC 8F 01 00 02 24 21 B0 00 00 2B 18 D2 02 0C 00 60 50 00 00 83 8E 09 00 40 10 4C 00 B9 8F 21 28 00 02 21 20 80 02 09 F8 20 03 FF FF 06 24 21 80 15 02 10 00 BC 8F F4 FF 00 10 01 00 D6 26 00 00 83 8E 21 88 40 00 02 00 02 24 06 00 62 14 34 00 BF 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 64 8E 00 00 60 AE 34 00 BF 8F 21 10 20 02 30 00 B6 8F 2C 00 B5 8F 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_117_1_0 {
	meta:
		name = "xdr_vector"
		size = 136
	strings:
		$1 = { D0 FF BD 27 28 00 B4 AF 24 00 B3 AF 20 00 B2 AF 1C 00 B1 AF 18 00 B0 AF 2C 00 BF AF 21 98 80 00 21 80 A0 00 21 90 C0 00 21 A0 E0 00 21 88 00 00 2B 10 32 02 09 00 40 10 40 00 B9 8F 21 20 60 02 21 28 00 02 09 F8 20 03 FF FF 06 24 05 00 40 10 21 80 14 02 F6 FF 00 10 01 00 31 26 02 00 00 10 01 00 02 24 21 10 00 00 2C 00 BF 8F 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_118_0_0 {
	meta:
		name = "msgrcv"
		size = 80
		refs = "0000 _gp_disp 0010 __syscall_ipc"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D0 FF BD 27 ?? ?? 99 8F 24 00 A7 AF 40 00 A7 8F 20 00 A3 27 21 10 80 00 2C 00 BF AF 18 00 BC AF 20 00 A5 AF 10 00 A3 AF 14 00 A0 AF 0C 00 04 24 ?? ?? ?? ?? 21 28 40 00 2C 00 BF 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_119_0_0 {
	meta:
		name = "__GI_btowc"
		size = 16
		altNames = "wctob"
	strings:
		$1 = { 80 00 83 2C FF FF 02 24 08 00 E0 03 0B 10 83 00 }
	condition:
		$1
}

rule file_120_0_0 {
	meta:
		name = "setrlimit64"
		size = 136
		refs = "0000 _gp_disp 0060 __GI_setrlimit"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D8 FF BD 27 10 00 BC AF 24 00 BF AF 04 00 A3 8C 06 00 60 14 00 00 A2 8C FF 7F 03 3C FF FF 63 34 2B 18 43 00 04 00 60 54 0C 00 A3 8C FF 7F 02 3C FF FF 42 34 0C 00 A3 8C 18 00 A2 AF 06 00 60 14 08 00 A2 8C FF 7F 03 3C FF FF 63 34 2B 18 43 00 04 00 60 14 ?? ?? 99 8F FF 7F 02 3C FF FF 42 34 ?? ?? 99 8F 18 00 A5 27 ?? ?? ?? ?? 1C 00 A2 AF 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_121_0_0 {
	meta:
		name = "__GI_seteuid"
		size = 200
		refs = "0000 _gp_disp 0030 __GI___errno_location 004c __GI_setresuid 009c __GI_setreuid"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D8 FF BD 27 20 00 B2 AF 10 00 BC AF FF FF 12 24 18 00 B0 AF 24 00 BF AF 1C 00 B1 AF 08 00 92 14 21 80 80 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 16 00 03 24 00 00 43 AC 1A 00 00 10 FF FF 02 24 ?? ?? 99 8F FF FF 04 24 21 28 00 02 ?? ?? ?? ?? FF FF 06 24 21 88 40 00 12 00 32 16 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 44 8C 59 00 03 24 10 00 BC 8F 0A 00 83 14 21 10 20 02 24 00 BF 8F 20 00 B2 8F 1C 00 B1 8F 21 28 00 02 ?? ?? 99 8F 18 00 B0 8F FF FF 04 24 ?? ?? ?? ?? 28 00 BD 27 24 00 BF 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_153_0_0 {
	meta:
		name = "setegid"
		size = 200
		refs = "0000 _gp_disp 0030 __GI___errno_location 004c __GI_setresgid 009c __GI_setregid"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D8 FF BD 27 20 00 B2 AF 10 00 BC AF FF FF 12 24 18 00 B0 AF 24 00 BF AF 1C 00 B1 AF 08 00 92 14 21 80 80 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 16 00 03 24 00 00 43 AC 1A 00 00 10 FF FF 02 24 ?? ?? 99 8F FF FF 04 24 21 28 00 02 ?? ?? ?? ?? FF FF 06 24 21 88 40 00 12 00 32 16 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 44 8C 59 00 03 24 10 00 BC 8F 0A 00 83 14 21 10 20 02 24 00 BF 8F 20 00 B2 8F 1C 00 B1 8F 21 28 00 02 ?? ?? 99 8F 18 00 B0 8F FF FF 04 24 ?? ?? ?? ?? 28 00 BD 27 24 00 BF 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_122_0_0 {
	meta:
		name = "__GI_strstr"
		size = 228
	strings:
		$1 = { 00 00 A6 90 35 00 C0 10 21 10 80 00 FF FF 84 24 01 00 84 24 00 00 82 90 30 00 40 50 21 10 00 00 FC FF 46 54 01 00 84 24 01 00 A9 90 2B 00 20 11 21 10 80 00 01 00 82 90 0E 00 49 10 01 00 83 24 FC FF 46 10 21 20 60 00 24 00 40 10 21 10 00 00 01 00 62 90 03 00 46 14 00 00 00 00 F5 FF 00 10 01 00 64 24 1C 00 40 10 02 00 63 24 F4 FF 00 10 02 00 82 90 02 00 A4 90 01 00 67 90 12 00 E4 14 FF FF 62 24 02 00 A8 24 01 00 67 24 13 00 80 10 00 00 00 00 01 00 04 91 01 00 EA 90 0A 00 44 15 00 00 00 00 0D 00 80 10 02 00 EB 24 02 00 04 91 02 00 E7 90 04 00 E4 14 02 00 0A 25 21 38 60 01 F2 FF 00 10 21 40 40 01 04 00 80 10 00 00 00 00 DB FF 00 10 00 00 62 90 21 10 00 00 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_123_0_0 {
	meta:
		name = "bzero"
		size = 28
		refs = "0000 _gp_disp 000c __GI_memset"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F 21 30 A0 00 ?? ?? ?? ?? 21 28 00 00 }
	condition:
		$1
}

rule file_579_0_0 {
	meta:
		name = "gmtime_r"
		size = 28
		refs = "0000 _gp_disp 000c _time_t2tm"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F 21 30 A0 00 ?? ?? ?? ?? 21 28 00 00 }
	condition:
		$1
}

rule file_124_0_0 {
	meta:
		name = "isctype"
		size = 40
		refs = "0000 _gp_disp 000c __GI___ctype_b"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F 40 20 04 00 00 00 42 8C 21 10 44 00 00 00 42 94 08 00 E0 03 24 10 A2 00 }
	condition:
		$1
}

rule file_125_0_0 {
	meta:
		name = "__GI_fputc"
		size = 268
		refs = "0000 _gp_disp 005c __GI___fputc_unlocked 0070 _pthread_cleanup_push_defer 0078 __pthread_mutex_unlock 0090 __pthread_mutex_lock 00dc _pthread_cleanup_pop_restore"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 C0 FF BD 27 30 00 B1 AF 2C 00 B0 AF 10 00 BC AF 3C 00 BF AF 38 00 B3 AF 34 00 B2 AF 34 00 A2 8C 21 88 80 00 0F 00 40 10 21 80 A0 00 10 00 A2 8C 1C 00 A3 8C 2B 18 43 00 05 00 60 10 01 00 43 24 10 00 A3 AC 00 00 44 A0 26 00 00 10 FF 00 82 30 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 22 00 00 10 3C 00 BF 8F ?? ?? 99 8F 38 00 B3 24 ?? ?? 85 8F 18 00 B2 27 21 20 40 02 ?? ?? ?? ?? 21 30 60 02 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 60 02 10 00 02 8E 1C 00 03 8E 2B 18 43 00 06 00 60 10 10 00 BC 8F 01 00 43 24 10 00 03 AE 00 00 51 A0 07 00 00 10 FF 00 31 32 ?? ?? 99 8F 21 20 20 02 ?? ?? ?? ?? 21 28 00 02 10 00 BC 8F 21 88 40 00 ?? ?? 99 8F 21 20 40 02 ?? ?? ?? ?? 01 00 05 24 21 10 20 02 3C 00 BF 8F 38 00 B3 8F 34 00 B2 8F 30 00 B1 8F 2C 00 B0 8F 08 00 E0 03 40 00 BD 27 }
	condition:
		$1
}

rule file_126_0_0 {
	meta:
		name = "__GI_strerror"
		size = 68
		refs = "0000 _gp_disp 0018 __GI___xpg_strerror_r"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 18 00 B0 AF ?? ?? 90 8F ?? ?? 99 8F 1C 00 BF AF 10 00 BC AF ?? ?? 05 26 ?? ?? ?? ?? 32 00 06 24 1C 00 BF 8F ?? ?? 02 26 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_127_0_0 {
	meta:
		name = "__GI_lseek"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF B3 0F 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_128_0_0 {
	meta:
		name = "__GI_stat"
		size = 120
		refs = "0000 _gp_disp 0034 __GI___errno_location 0054 __xstat_conv"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 50 FF BD 27 10 00 BC AF 21 30 A0 00 AC 00 BF AF A8 00 B0 AF 18 00 A5 27 0A 10 02 24 0C 00 00 00 07 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC 07 00 00 10 FF FF 10 24 06 00 40 14 AC 00 BF 8F ?? ?? 99 8F 18 00 A4 27 ?? ?? ?? ?? 21 28 C0 00 AC 00 BF 8F 21 10 00 02 A8 00 B0 8F 08 00 E0 03 B0 00 BD 27 }
	condition:
		$1
}

rule file_129_0_0 {
	meta:
		name = "clntudp_geterr"
		size = 32
	strings:
		$1 = { 08 00 82 8C 2C 00 43 8C 00 00 A3 AC 30 00 43 8C 04 00 A3 AC 34 00 42 8C 08 00 E0 03 08 00 A2 AC }
	condition:
		$1
}

rule file_129_1_0 {
	meta:
		name = "clntudp_freeres"
		size = 28
	strings:
		$1 = { 08 00 84 8C 02 00 02 24 21 C8 A0 00 38 00 82 AC 21 28 C0 00 08 00 20 03 38 00 84 24 }
	condition:
		$1
}

rule file_129_3_0 {
	meta:
		name = "clntudp_control"
		size = 352
		refs = "0000 _gp_disp 00a8 __GI_memcpy"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 FF FF A5 24 0F 00 A3 2C 50 00 60 10 08 00 82 8C ?? ?? 83 8F 80 28 05 00 E0 FF BD 27 ?? ?? 63 24 21 28 65 00 00 00 A3 8C 10 00 BC AF 1C 00 BF AF 21 18 7C 00 08 00 60 00 00 00 00 00 01 00 03 24 36 00 00 10 04 00 43 AC 34 00 00 10 04 00 40 AC 00 00 C3 8C 24 00 43 AC 04 00 C3 8C 2F 00 00 10 28 00 43 AC 24 00 43 8C 00 00 C3 AC 09 00 00 10 28 00 42 8C 00 00 C3 8C 1C 00 43 AC 04 00 C3 8C 26 00 00 10 20 00 43 AC 1C 00 43 8C 00 00 C3 AC 20 00 42 8C 21 00 00 10 04 00 C2 AC ?? ?? 99 8F 21 20 C0 00 08 00 45 24 ?? ?? ?? ?? 10 00 06 24 23 00 00 10 01 00 02 24 17 00 00 10 00 00 42 8C 58 00 42 8C 12 00 00 10 00 00 42 8C 00 00 C3 8C 58 00 44 8C FF FF 63 24 A0 18 03 7C 02 1C 23 00 00 00 83 AC 58 00 42 8C 09 00 00 10 10 00 42 8C 58 00 43 8C 00 00 C2 8C A0 10 02 7C 02 14 22 00 06 00 00 10 10 00 62 AC 58 00 42 8C 0C 00 42 8C A0 10 02 7C 02 14 22 00 00 00 C2 AC 08 00 00 10 01 00 02 24 58 00 43 8C 00 00 C2 8C A0 10 02 7C 02 14 22 00 F9 FF 00 10 0C 00 62 AC 21 10 00 00 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 08 00 E0 03 21 10 00 00 }
	condition:
		$1
}

rule file_129_4_0 {
	meta:
		name = "is_network_up"
		size = 252
		refs = "0000 _gp_disp 0014 __GI_ioctl 0084 __GI_memcpy"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 40 DD BD 27 A4 22 B0 AF ?? ?? 90 8F 60 22 02 24 98 22 A2 AF 18 00 A2 27 10 00 BC AF B0 22 B3 AF BC 22 BF AF B8 22 B5 AF B4 22 B4 AF AC 22 B2 AF A8 22 B1 AF 9C 22 A2 AF 12 89 05 34 98 22 A6 27 21 C8 00 02 ?? ?? ?? ?? 21 98 80 00 03 00 40 10 10 00 BC 8F 1D 00 00 10 21 10 00 00 98 22 B1 8F 21 A0 00 02 9C 22 B0 8F 42 89 11 00 78 22 B2 27 02 00 15 24 F7 FF 20 12 ?? ?? 99 8F 21 20 40 02 21 28 00 02 ?? ?? ?? ?? 20 00 06 24 21 20 60 02 13 89 05 34 21 C8 80 02 09 F8 20 03 21 30 40 02 EC FF 40 04 10 00 BC 8F 88 22 A2 97 01 00 42 30 04 00 40 10 FF FF 31 26 10 00 02 96 03 00 55 10 01 00 02 24 EB FF 00 10 20 00 10 26 BC 22 BF 8F B8 22 B5 8F B4 22 B4 8F B0 22 B3 8F AC 22 B2 8F A8 22 B1 8F A4 22 B0 8F 08 00 E0 03 C0 22 BD 27 }
	condition:
		$1
}

rule file_129_5_0 {
	meta:
		name = "clntudp_destroy"
		size = 136
		refs = "0000 _gp_disp 0030 __GI_close 004c free"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D8 FF BD 27 20 00 B1 AF 10 00 BC AF 24 00 BF AF 1C 00 B0 AF 08 00 90 8C 04 00 02 8E 05 00 40 10 21 88 80 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 04 8E 10 00 BC 8F 3C 00 02 8E 1C 00 59 8C 05 00 20 53 ?? ?? 99 8F 09 F8 20 03 38 00 04 26 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 00 02 10 00 BC 8F 24 00 BF 8F 1C 00 B0 8F 21 20 20 02 ?? ?? 99 8F 20 00 B1 8F ?? ?? ?? ?? 28 00 BD 27 }
	condition:
		$1
}

rule file_129_6_0 {
	meta:
		name = "clntudp_call"
		size = 1568
		refs = "0000 _gp_disp 0168 __GI_sendto 0184 __GI___errno_location 01a4 _null_auth 0208 __GI_poll 0238 is_network_up 02d0 __GI_recvfrom 0320 __GI_recvmsg 0348 __GI_memcmp 03fc __GI___cmsg_nxthdr 04cc __GI_xdrmem_create 050c __GI_xdr_replymsg 0520 __GI__seterr_reply 0574 __GI_xdr_opaque_auth"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 F8 FE BD 27 00 01 BE AF F4 00 B5 AF 04 01 BF AF FC 00 B7 AF F8 00 B6 AF F0 00 B4 AF EC 00 B3 AF E8 00 B2 AF E4 00 B1 AF E0 00 B0 AF 18 00 BC AF 08 00 97 8C 21 A8 80 00 E8 03 02 24 20 00 E4 8E 21 F0 A0 03 0C 01 C5 AF 1A 00 82 00 F4 01 40 00 1C 00 E5 8E 28 00 F9 8E 10 01 C6 AF 14 01 C7 AF B8 00 D9 AF 00 00 45 70 FF FF 02 24 12 18 00 00 05 00 22 17 C8 00 C3 AF 24 01 C3 8F 20 01 D4 8F 02 00 00 10 B8 00 C3 AF 24 00 F4 8E 02 00 19 24 60 00 E3 26 21 88 00 00 21 80 00 00 C0 00 D9 AF 21 98 00 00 C4 00 C3 AF 10 01 D9 8F 3E 00 20 13 38 00 F2 26 3C 00 E2 8E 38 00 E0 AE 50 00 E5 8E 14 00 59 8C 09 F8 20 03 21 20 40 02 58 00 E2 8E 0C 01 C5 27 00 00 44 8C 01 00 84 24 00 00 44 AC 3C 00 E2 8E 04 00 59 8C 09 F8 20 03 21 20 40 02 03 00 40 54 00 00 A4 8E CE 00 00 10 01 00 02 24 20 00 82 8C 04 00 59 8C 09 F8 20 03 21 28 40 02 C8 00 40 10 01 00 02 24 14 01 C5 8F 10 01 D9 8F 09 F8 20 03 21 20 40 02 C2 00 40 10 01 00 02 24 3C 00 E2 8E 10 00 59 8C 09 F8 20 03 21 20 40 02 18 00 DC 8F 21 98 40 00 08 00 E2 26 00 00 E4 8E 58 00 E5 8E 10 00 A2 AF 18 00 E2 8E ?? ?? 99 8F 21 30 60 02 14 00 A2 AF ?? ?? ?? ?? 21 38 00 00 08 00 53 10 18 00 DC 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 42 8C 30 00 E2 AE A9 00 00 10 03 00 02 24 05 00 80 16 ?? ?? 82 8F B8 00 C3 8F A4 00 60 10 05 00 02 24 ?? ?? 82 8F 1C 01 D9 8F 18 01 C3 8F 00 00 44 8C 3C 00 D9 AF 40 00 C3 AF 2C 00 C4 AF 04 00 44 8C 08 00 42 8C AC 00 D9 27 30 00 C4 AF 34 00 C2 AF 00 00 E2 8E D0 00 D9 AF AC 00 C2 AF 01 00 02 24 B0 00 C2 A7 0E 01 62 26 C2 10 02 00 C0 10 02 00 D4 00 C2 AF ?? ?? 99 8F C8 00 C6 8F AC 00 C4 27 ?? ?? ?? ?? 01 00 05 24 FF FF 04 24 20 00 44 10 18 00 DC 8F 27 00 40 14 B2 00 C2 97 ?? ?? 82 8F ?? ?? 59 24 ?? ?? ?? ?? 00 00 E4 8E 7E 00 40 10 18 00 DC 8F 1C 00 E2 8E 21 80 02 02 20 00 E2 8E 21 88 22 02 0F 00 19 3C 40 42 39 37 2A 10 39 02 05 00 40 14 0F 00 03 3C 40 42 63 34 01 00 10 26 F8 FF 00 10 23 88 23 02 2A 10 14 02 B5 FF 40 54 08 00 E2 26 04 00 14 16 B8 00 C3 8F 2A 10 23 02 B0 FF 40 54 08 00 E2 26 68 00 00 10 05 00 02 24 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 44 8C 04 00 02 24 D3 FF 82 10 18 00 DC 8F 5F 00 00 10 30 00 E4 AE 08 00 42 30 5F 00 40 10 ?? ?? 96 8F D4 00 D9 8F 84 00 C4 27 50 00 C4 AF 23 E8 B9 03 18 00 A2 27 A4 00 C4 27 18 01 A8 27 58 00 C4 AF 60 00 C2 AF 01 00 04 24 00 01 02 24 10 00 16 24 A4 00 C8 AF A8 00 D3 AF 54 00 D6 AF 5C 00 C4 AF 68 00 C0 AF 64 00 C2 AF 00 00 E4 8E ?? ?? 99 8F 50 00 C3 27 D8 00 C8 AF BC 00 C3 AF 21 28 60 00 ?? ?? ?? ?? 00 20 06 24 18 00 DC 8F 41 00 40 04 D8 00 C8 8F ?? ?? 99 8F 58 00 E5 8E 21 20 00 01 DC 00 D9 AF 21 30 40 00 ?? ?? ?? ?? D8 00 C2 AF 18 00 DC 8F D8 00 C7 8F 36 00 40 14 DC 00 D9 8F 68 00 C2 8F 00 20 42 30 33 00 40 50 ?? ?? 96 8F 54 00 C2 8F 05 00 40 14 0C 00 E7 28 14 00 E0 10 64 00 C2 8F 2C 00 00 10 ?? ?? 96 8F 2A 00 56 54 ?? ?? 96 8F 84 00 C4 97 02 00 02 24 26 00 82 54 ?? ?? 96 8F 88 00 C4 27 0C 00 E5 26 09 F8 20 03 04 00 06 24 1F 00 40 14 18 00 DC 8F 86 00 C4 97 0A 00 E2 96 1C 00 82 54 ?? ?? 96 8F 64 00 C2 8F 60 00 C4 8F 0B 00 16 24 0C 00 42 2C 0B 20 02 00 21 10 80 00 06 00 00 10 ?? ?? 99 8F 50 00 C4 27 09 F8 20 03 21 28 40 00 18 00 DC 8F DC 00 D9 8F 0D 00 40 50 ?? ?? 96 8F 04 00 44 8C F7 FF 80 54 DC 00 D9 AF 08 00 44 8C F4 FF 96 54 DC 00 D9 AF 0C 00 42 8C 30 00 E2 AE 04 00 02 24 6A 00 00 10 2C 00 E2 AE ?? ?? 96 8F 94 00 D9 27 B4 00 C3 27 BC 00 D9 AF CC 00 C3 AF 10 00 02 24 B4 00 C2 AF 00 00 E4 8E 5C 00 E6 8E C4 00 C5 8F 94 00 D9 27 B4 00 C2 27 10 00 B9 AF 14 00 A2 AF 21 C8 C0 02 ?? ?? ?? ?? 21 38 00 00 0A 00 41 04 18 00 DC 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 42 8C 04 00 04 24 EC FF 44 10 18 00 DC 8F 49 00 00 10 0B 00 05 24 04 00 44 28 53 FF 80 14 ?? ?? 99 8F 10 01 D9 8F 07 00 20 13 ?? ?? 99 8F 58 00 E4 8E 60 00 E5 8E 00 00 84 8C 4B FF A4 14 ?? ?? 99 8F ?? ?? 99 8F C4 00 C5 8F 6C 00 D6 27 21 20 C0 02 21 30 40 00 ?? ?? ?? ?? 01 00 07 24 18 00 DC 8F 21 20 C0 02 20 00 D6 27 ?? ?? 99 8F ?? ?? ?? ?? 21 28 C0 02 2B 00 40 10 18 00 DC 8F ?? ?? 99 8F 21 20 C0 02 ?? ?? ?? ?? 2C 00 E5 26 2C 00 E2 8E 17 00 40 14 C0 00 C3 8F 00 00 A4 8E 2C 00 D0 27 20 00 82 8C 08 00 59 8C 09 F8 20 03 21 28 00 02 05 00 40 14 18 00 DC 8F 07 00 02 24 2C 00 E2 AE 06 00 02 24 30 00 E2 AE 30 00 C2 8F 17 00 40 10 ?? ?? 99 8F 02 00 02 24 38 00 E2 AE 21 20 40 02 ?? ?? ?? ?? 21 28 00 02 17 00 00 10 2C 00 E2 8E 15 00 60 50 2C 00 E2 8E 00 00 A4 8E 20 00 82 8C 0C 00 59 8C 09 F8 20 03 00 00 00 00 07 00 40 10 18 00 DC 8F C0 00 D9 8F FF FF 39 27 BC FE 00 10 C0 00 D9 AF 02 00 02 24 2C 00 E2 AE 06 00 00 10 2C 00 E2 8E 0C FF 45 10 ?? ?? 99 8F 30 00 E2 AE 2C 00 E4 AE 04 00 02 24 21 E8 C0 03 04 01 BF 8F 00 01 BE 8F FC 00 B7 8F F8 00 B6 8F F4 00 B5 8F F0 00 B4 8F EC 00 B3 8F E8 00 B2 8F E4 00 B1 8F E0 00 B0 8F 08 00 E0 03 08 01 BD 27 }
	condition:
		$1
}

rule file_129_7_0 {
	meta:
		name = "__GI_clntudp_bufcreate"
		size = 808
		refs = "0000 _gp_disp 000c malloc 00a4 __GI___rpc_thread_createerr 00b8 stderr 00c0 __GI_fputs 00bc $LC0 00e8 free 0100 __GI_pmap_getport 0134 __GI_memcpy 0170 _create_xid 0198 __GI_xdrmem_create 01cc __GI_xdr_callhdr 0200 __GI_socket 0240 __GI___errno_location 025c __GI_bindresvport 0278 __GI_ioctl 0290 __GI_setsockopt 02c0 __GI_authnone_create"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F 80 FF BD 27 18 00 BC AF 7C 00 BF AF 78 00 B7 AF 74 00 B6 AF 70 00 B5 AF 6C 00 B4 AF 68 00 B3 AF 64 00 B2 AF 60 00 B1 AF 5C 00 B0 AF 8C 00 A7 AF 21 98 80 00 0C 00 04 24 21 B8 A0 00 21 B0 C0 00 ?? ?? ?? ?? 94 00 B2 8F 9C 00 B5 8F 98 00 B4 8F 18 00 BC 8F 03 00 B5 26 03 00 94 26 82 A8 15 00 82 A0 14 00 ?? ?? 99 8F 80 A8 15 00 80 A0 14 00 64 00 A4 26 21 20 94 00 ?? ?? ?? ?? 21 88 40 00 21 80 40 00 03 00 20 12 18 00 BC 8F 13 00 40 14 60 00 A2 26 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 18 00 BC 8F 21 90 40 00 ?? ?? 82 8F ?? ?? 84 8F ?? ?? 99 8F 00 00 45 8C ?? ?? ?? ?? ?? ?? 84 24 0C 00 02 24 18 00 BC 8F 00 00 42 AE 82 00 00 12 08 00 42 AE 7D 00 00 10 ?? ?? 99 8F 21 10 02 02 58 00 02 AE 02 00 62 96 0E 00 40 14 ?? ?? 82 8F ?? ?? 99 8F 21 20 60 02 21 28 E0 02 21 30 C0 02 ?? ?? ?? ?? 11 00 07 24 6F 00 40 10 18 00 BC 8F 00 1A 02 00 00 7A 42 7C 25 10 62 00 02 00 62 A6 ?? ?? 82 8F ?? ?? 99 8F 21 28 60 02 ?? ?? 42 24 08 00 04 26 10 00 06 24 04 00 22 AE ?? ?? ?? ?? 08 00 30 AE 10 00 02 24 18 00 02 AE 8C 00 A2 8F 18 00 BC 8F 54 00 14 AE 1C 00 02 AE 90 00 A2 8F ?? ?? 99 8F 5C 00 15 AE 20 00 02 AE FF FF 02 24 24 00 02 AE ?? ?? ?? ?? 28 00 02 AE 18 00 BC 8F 58 00 05 8E 20 00 A2 AF ?? ?? 99 8F 02 00 02 24 38 00 13 26 28 00 A2 AF 21 20 60 02 21 30 80 02 21 38 00 00 24 00 A0 AF 2C 00 B7 AF ?? ?? ?? ?? 30 00 B6 AF 18 00 BC 8F 21 20 60 02 ?? ?? 99 8F ?? ?? ?? ?? 20 00 A5 27 3F 00 40 10 18 00 BC 8F 3C 00 02 8E 10 00 59 8C 09 F8 20 03 21 20 60 02 50 00 02 AE 00 00 42 8E 2F 00 41 04 18 00 BC 8F ?? ?? 99 8F 01 00 13 24 54 00 B3 AF 02 00 04 24 01 00 05 24 ?? ?? ?? ?? 11 00 06 24 18 00 BC 8F 0E 00 41 04 00 00 42 AE ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 18 00 BC 8F 21 90 40 00 0C 00 02 24 ?? ?? 99 8F ?? ?? ?? ?? 00 00 42 AE 00 00 42 8C 18 00 BC 8F 20 00 00 10 08 00 42 AE ?? ?? 99 8F 21 20 40 00 ?? ?? ?? ?? 21 28 00 00 18 00 BC 8F 00 00 44 8E 7E 66 05 24 ?? ?? 99 8F ?? ?? ?? ?? 54 00 A6 27 18 00 BC 8F 00 00 44 8E 04 00 02 24 ?? ?? 99 8F 50 00 B3 AF 10 00 A2 AF 21 28 00 00 0B 00 06 24 ?? ?? ?? ?? 50 00 A7 27 18 00 BC 8F 02 00 00 10 04 00 13 AE 04 00 00 AE 00 00 42 8E ?? ?? 99 8F ?? ?? ?? ?? 00 00 02 AE 00 00 22 AE 0A 00 00 10 21 10 20 02 ?? ?? 99 8F ?? ?? ?? ?? 21 20 00 02 18 00 BC 8F 03 00 20 12 ?? ?? 99 8F ?? ?? ?? ?? 21 20 20 02 21 10 00 00 7C 00 BF 8F 78 00 B7 8F 74 00 B6 8F 70 00 B5 8F 6C 00 B4 8F 68 00 B3 8F 64 00 B2 8F 60 00 B1 8F 5C 00 B0 8F 08 00 E0 03 80 00 BD 27 }
	condition:
		$1
}

rule file_129_8_0 {
	meta:
		name = "__GI_clntudp_create"
		size = 80
		refs = "0000 _gp_disp 0014 __GI_clntudp_bufcreate"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D0 FF BD 27 44 00 A2 8F ?? ?? 99 8F 2C 00 BF AF 14 00 A2 AF 60 22 02 24 18 00 A2 AF 1C 00 A2 AF 40 00 A2 8F 20 00 BC AF 3C 00 A7 AF 10 00 A2 AF ?? ?? ?? ?? 00 00 00 00 2C 00 BF 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_130_0_0 {
	meta:
		name = "__GI_unlink"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF AA 0F 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_131_0_0 {
	meta:
		name = "umount2"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF D4 0F 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_132_0_0 {
	meta:
		name = "__GI_getchar_unlocked"
		size = 64
		refs = "0000 _gp_disp 000c stdin 0034 __GI___fgetc_unlocked"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F 00 00 44 8C 10 00 82 8C 18 00 83 8C 2B 18 43 00 04 00 60 10 01 00 43 24 10 00 83 AC 08 00 E0 03 00 00 42 90 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_133_0_0 {
	meta:
		name = "__GI_open64"
		size = 84
		refs = "0000 _gp_disp 0038 __GI_open"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D8 FF BD 27 00 01 A3 30 10 00 BC AF 24 00 BF AF 30 00 A6 AF 34 00 A7 AF 04 00 60 10 21 10 00 00 30 00 A2 27 18 00 A2 AF 21 10 C0 00 ?? ?? 99 8F 00 20 A5 34 ?? ?? ?? ?? 21 30 40 00 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_136_0_0 {
	meta:
		name = "__GI_gethostbyname2"
		size = 40
		refs = "0000 _gp_disp 0014 __GI_gethostbyname"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 02 00 02 24 03 00 A2 14 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 08 00 E0 03 21 10 00 00 }
	condition:
		$1
}

rule file_137_0_0 {
	meta:
		name = "__GI_fcntl64"
		size = 100
		refs = "0000 _gp_disp 003c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D8 FF BD 27 30 00 A2 27 10 00 BC AF 24 00 BF AF 20 00 B0 AF 30 00 A6 AF 34 00 A7 AF 18 00 A2 AF 7C 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 24 00 BF 8F 21 10 00 02 20 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_138_0_0 {
	meta:
		name = "shutdown"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 56 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_139_0_0 {
	meta:
		name = "msgget"
		size = 72
		refs = "0000 _gp_disp 000c __syscall_ipc"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F D8 FF BD 27 21 10 80 00 21 30 A0 00 24 00 BF AF 18 00 BC AF 10 00 A0 AF 14 00 A0 AF 0D 00 04 24 21 28 40 00 ?? ?? ?? ?? 21 38 00 00 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_141_0_0 {
	meta:
		name = "__GI_strchrnul"
		size = 240
	strings:
		$1 = { FF 00 A2 30 03 00 83 30 08 00 60 50 FF 00 A5 30 00 00 83 90 32 00 62 10 00 00 00 00 30 00 60 10 00 00 00 00 F7 FF 00 10 01 00 84 24 00 1A 05 00 25 28 65 00 00 1C 05 00 FE 7E 06 3C 01 81 09 3C 25 28 65 00 FF FE C6 34 00 01 29 25 00 00 83 8C 26 38 65 00 27 50 07 00 21 38 E6 00 26 38 47 01 27 50 03 00 21 18 66 00 26 18 43 01 25 18 E3 00 24 18 69 00 03 00 60 14 04 00 88 24 F3 FF 00 10 21 20 00 01 00 00 83 90 15 00 62 10 00 00 00 00 13 00 60 10 00 00 00 00 01 00 87 90 12 00 E2 10 01 00 83 24 10 00 E0 10 00 00 00 00 02 00 83 90 03 00 62 10 00 00 00 00 03 00 60 54 03 00 83 90 08 00 E0 03 02 00 82 24 03 00 62 10 00 00 00 00 DE FF 60 54 21 20 00 01 08 00 E0 03 03 00 82 24 08 00 E0 03 21 10 80 00 08 00 E0 03 21 10 60 00 }
	condition:
		$1
}

rule file_142_0_0 {
	meta:
		name = "__getgrouplist_internal"
		size = 416
		refs = "0000 _gp_disp 0010 malloc 0070 __GI_fopen 0068 $LC0 006c $LC1 0094 __pgsreader 0098 __GI_strcmp 00ac __parsegrent 00e4 __GI_fclose 012c realloc"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 A0 FE BD 27 ?? ?? 99 8F 18 00 BC AF 3C 01 B1 AF 01 00 11 24 54 01 B7 AF 48 01 B4 AF 44 01 B3 AF 38 01 B0 AF 5C 01 BF AF 58 01 BE AF 50 01 B6 AF 4C 01 B5 AF 40 01 B2 AF 21 B8 80 00 00 00 D1 AC 20 00 04 24 21 A0 A0 00 ?? ?? ?? ?? 21 98 C0 00 21 80 40 00 40 00 40 10 18 00 BC 8F ?? ?? 84 8F ?? ?? 85 8F ?? ?? 99 8F 00 00 54 AC ?? ?? 84 24 ?? ?? ?? ?? ?? ?? A5 24 21 90 40 00 38 00 40 10 18 00 BC 8F 20 01 B9 27 ?? ?? 95 8F ?? ?? 9E 8F 30 01 B9 AF 20 00 B9 27 34 00 51 AC 34 01 B9 AF ?? ?? 84 8F 10 00 B2 AF 20 01 A5 27 20 00 A6 27 21 C8 A0 02 ?? ?? ?? ?? 00 01 07 24 06 00 40 14 18 00 BC 8F 28 01 A2 8F F5 FF 54 10 2C 01 B6 8F 0C 00 00 10 00 00 C4 8E ?? ?? 99 8F ?? ?? ?? ?? 21 20 40 02 1E 00 00 10 00 00 71 AE ?? ?? ?? ?? 21 28 E0 02 07 00 40 10 18 00 BC 8F 04 00 D6 26 00 00 C4 8E F9 FF 80 14 21 C8 C0 03 E5 FF 00 10 ?? ?? 84 8F 07 00 22 32 0A 00 40 14 28 01 A3 8F ?? ?? 99 8F 08 00 25 26 21 20 00 02 ?? ?? ?? ?? 80 28 05 00 E8 FF 40 10 18 00 BC 8F 21 80 40 00 28 01 A3 8F 80 10 11 00 21 10 02 02 00 00 43 AC D3 FF 00 10 01 00 31 26 02 00 00 10 21 10 00 00 21 10 00 02 5C 01 BF 8F 58 01 BE 8F 54 01 B7 8F 50 01 B6 8F 4C 01 B5 8F 48 01 B4 8F 44 01 B3 8F 40 01 B2 8F 3C 01 B1 8F 38 01 B0 8F 08 00 E0 03 60 01 BD 27 }
	condition:
		$1
}

rule file_143_0_0 {
	meta:
		name = "__GI_ioctl"
		size = 100
		refs = "0000 _gp_disp 003c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D8 FF BD 27 30 00 A2 27 10 00 BC AF 24 00 BF AF 20 00 B0 AF 30 00 A6 AF 34 00 A7 AF 18 00 A2 AF D6 0F 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 24 00 BF 8F 21 10 00 02 20 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_144_0_0 {
	meta:
		name = "insque"
		size = 28
	strings:
		$1 = { 00 00 A2 8C 02 00 40 10 00 00 A4 AC 04 00 44 AC 00 00 82 AC 08 00 E0 03 04 00 85 AC }
	condition:
		$1
}

rule file_145_0_0 {
	meta:
		name = "__GI___xpg_strerror_r"
		size = 368
		refs = "0000 _gp_disp 0068 _uintmaxtostr 007c _string_syserrmsgs 00d4 __GI_memcpy 00ec __GI_strlen 0140 __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 90 FF BD 27 68 00 B3 AF 21 98 A0 00 ?? ?? 85 8F 64 00 B2 AF 18 00 BC AF 21 10 80 00 6C 00 BF AF 60 00 B1 AF 5C 00 B0 AF 21 90 C0 00 21 18 00 00 ?? ?? A5 24 7E 00 04 24 21 30 65 00 00 00 C6 90 09 00 C2 50 7E 00 64 2C 01 00 63 24 FB FF 64 54 21 30 65 00 6D 04 03 24 10 00 43 14 ?? ?? 99 8F 03 00 00 10 7A 00 03 24 0C 00 80 10 ?? ?? 99 8F ?? ?? 90 8F 06 00 60 50 00 00 03 82 00 00 04 82 01 00 10 26 01 00 84 2C FA FF 00 10 23 18 64 00 13 00 60 14 21 88 00 00 ?? ?? 99 8F F6 FF 03 24 10 00 A3 AF 51 00 A4 27 21 30 40 00 C3 3F 02 00 ?? ?? ?? ?? 14 00 A0 AF 18 00 BC 8F F2 FF 50 24 21 20 00 02 ?? ?? 85 8F ?? ?? 99 8F 0E 00 06 24 ?? ?? ?? ?? ?? ?? A5 24 18 00 BC 8F 16 00 11 24 ?? ?? 99 8F 21 20 00 02 ?? ?? ?? ?? 0A 90 13 00 01 00 42 24 2B 18 42 02 03 00 60 14 18 00 BC 8F 02 00 00 10 21 90 40 00 22 00 11 24 08 00 40 12 ?? ?? 99 8F 21 30 40 02 21 20 60 02 21 28 00 02 ?? ?? ?? ?? 21 90 72 02 18 00 BC 8F FF FF 40 A2 04 00 20 12 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 51 AC 6C 00 BF 8F 21 10 20 02 68 00 B3 8F 64 00 B2 8F 60 00 B1 8F 5C 00 B0 8F 08 00 E0 03 70 00 BD 27 }
	condition:
		$1
}

rule file_146_0_0 {
	meta:
		name = "sigqueue"
		size = 208
		refs = "0000 _gp_disp 0010 __GI_memset 0058 __GI_getpid 0068 __GI_getuid 009c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 50 FF BD 27 ?? ?? 99 8F A0 00 B1 AF 18 00 B1 27 AC 00 BF AF 10 00 BC AF A8 00 B3 AF A4 00 B2 AF 9C 00 B0 AF 21 90 80 00 21 80 A0 00 21 20 20 02 21 28 00 00 21 98 C0 00 ?? ?? ?? ?? 80 00 06 24 10 00 BC 8F FF FF 02 24 18 00 B0 AF ?? ?? 99 8F ?? ?? ?? ?? 1C 00 A2 AF 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 24 00 A2 AF 28 00 A2 AF 10 00 BC 8F 2C 00 B3 AF 21 20 40 02 21 28 00 02 21 30 20 02 66 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 AC 00 BF 8F 21 10 00 02 A8 00 B3 8F A4 00 B2 8F A0 00 B1 8F 9C 00 B0 8F 08 00 E0 03 B0 00 BD 27 }
	condition:
		$1
}

rule file_147_0_0 {
	meta:
		name = "__GI_memmem"
		size = 212
		refs = "0000 _gp_disp 0028 __GI_memcmp"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 2F 00 E0 10 21 10 80 00 2B 10 A7 00 21 00 40 14 23 28 A7 00 C8 FF BD 27 24 00 B3 AF ?? ?? 93 8F 30 00 B6 AF 2C 00 B5 AF 28 00 B4 AF 1C 00 B1 AF 18 00 B0 AF 10 00 BC AF 34 00 BF AF 20 00 B2 AF 21 88 C0 00 21 80 80 00 21 A0 85 00 01 00 D5 24 FF FF F6 24 2B 10 90 02 10 00 40 14 21 10 00 00 00 00 03 82 00 00 22 82 08 00 62 14 01 00 12 26 21 20 40 02 21 28 A0 02 21 C8 60 02 ?? ?? ?? ?? 21 30 C0 02 05 00 40 10 21 10 00 02 F1 FF 00 10 21 80 40 02 08 00 E0 03 21 10 00 00 34 00 BF 8F 30 00 B6 8F 2C 00 B5 8F 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 38 00 BD 27 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_148_0_0 {
	meta:
		name = "sigaltstack"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 6E 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_149_0_0 {
	meta:
		name = "__GI_bindresvport"
		size = 396
		refs = "0000 _gp_disp 0048 __GI___errno_location 00a8 __GI_getpid 00e8 __GI_bind"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 B0 FF BD 27 10 00 BC AF 3C 00 B5 AF 2C 00 B1 AF 28 00 B0 AF 4C 00 BF AF 48 00 BE AF 44 00 B7 AF 40 00 B6 AF 38 00 B4 AF 34 00 B3 AF 30 00 B2 AF 21 A8 80 00 21 80 A0 00 09 00 A0 14 ?? ?? 91 8F 02 00 02 24 18 00 A0 AF 1C 00 A0 AF 20 00 A0 AF 24 00 A0 AF 18 00 A2 A7 0C 00 00 10 18 00 B0 27 00 00 A3 94 02 00 02 24 09 00 62 10 ?? ?? 92 8F 21 C8 20 02 ?? ?? ?? ?? 00 00 00 00 7B 00 03 24 00 00 43 AC 32 00 00 10 FF FF 02 24 ?? ?? 92 8F ?? ?? 42 86 0B 00 40 14 21 C8 20 02 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 A8 01 03 24 1A 00 43 00 F4 01 60 00 10 10 00 00 58 02 43 24 ?? ?? 43 A6 21 C8 20 02 ?? ?? ?? ?? 21 88 00 00 10 00 BC 8F 21 98 40 00 7D 00 02 24 ?? ?? 94 8F ?? ?? 96 8F 00 00 62 AE FF FF 02 24 7D 00 17 24 58 02 1E 24 00 00 63 8E 16 00 77 14 ?? ?? 43 96 00 22 03 00 02 12 03 00 01 00 63 24 25 10 82 00 20 1E 03 7C 02 00 02 A6 00 04 62 28 02 00 40 50 ?? ?? 9E A6 ?? ?? 83 A6 21 20 A0 02 21 28 00 02 21 C8 C0 02 ?? ?? ?? ?? 10 00 06 24 01 00 31 26 A8 01 03 24 04 00 23 12 4C 00 BF 8F EA FF 42 04 00 00 63 8E 4C 00 BF 8F 48 00 BE 8F 44 00 B7 8F 40 00 B6 8F 3C 00 B5 8F 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 E0 03 50 00 BD 27 }
	condition:
		$1
}

rule file_150_0_0 {
	meta:
		name = "__GI_xprt_register"
		size = 476
		refs = "0000 _gp_disp 000c __rpc_thread_variables 0054 __GI__rpc_dtablesize 0088 malloc 00bc __GI___rpc_thread_svc_max_pollfd 00c0 __GI___rpc_thread_svc_fdset 00f0 __GI___rpc_thread_svc_pollfd 0168 realloc"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F C8 FF BD 27 10 00 BC AF 24 00 B3 AF 20 00 B2 AF 1C 00 B1 AF 34 00 BF AF 30 00 B6 AF 2C 00 B5 AF 28 00 B4 AF 18 00 B0 AF 21 90 80 00 ?? ?? ?? ?? 00 00 90 8C 21 88 40 00 10 00 BC 8F B4 00 42 8C 09 00 40 10 ?? ?? 93 8F 21 C8 60 02 ?? ?? ?? ?? 00 00 00 00 2A 10 02 02 0E 00 40 14 10 00 BC 8F 51 00 00 10 34 00 BF 8F 21 C8 60 02 ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 80 20 02 00 F0 FF 40 14 B4 00 22 AE 46 00 00 10 34 00 BF 8F B4 00 23 8E 80 10 10 00 21 10 62 00 00 00 52 AC 00 04 02 2A 0D 00 40 10 ?? ?? 94 8F ?? ?? 99 8F 42 89 10 00 ?? ?? ?? ?? 80 88 11 00 21 10 51 00 00 00 44 8C 01 00 03 24 04 18 03 02 25 18 83 00 10 00 BC 8F 00 00 43 AC ?? ?? 94 8F ?? ?? 95 8F 21 90 00 00 FF FF 16 24 21 C8 80 02 ?? ?? ?? ?? 00 00 00 00 00 00 53 8C 21 88 40 00 2A 10 53 02 0D 00 40 10 10 00 BC 8F 21 C8 A0 02 ?? ?? ?? ?? 00 00 00 00 00 00 44 8C C0 18 12 00 21 20 83 00 00 00 85 8C F0 FF B6 14 01 00 52 26 00 00 90 AC 18 00 00 10 00 00 42 8C ?? ?? 99 8F 01 00 73 26 ?? ?? ?? ?? 00 00 33 AE 10 00 BC 8F 00 00 44 8C C0 28 13 00 ?? ?? 99 8F ?? ?? ?? ?? 21 90 40 00 0F 00 40 10 00 00 42 AE 00 00 24 8E FF 1F 03 3C FF FF 63 34 21 20 83 00 C0 20 04 00 21 10 44 00 00 00 50 AC 00 00 22 8E 21 18 43 00 00 00 42 8E C0 18 03 00 21 18 43 00 C3 00 02 24 04 00 62 A4 34 00 BF 8F 30 00 B6 8F 2C 00 B5 8F 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_150_1_0 {
	meta:
		name = "__GI_xprt_unregister"
		size = 288
		refs = "0000 _gp_disp 0010 __GI__rpc_dtablesize 0048 __rpc_thread_variables 0078 __GI___rpc_thread_svc_max_pollfd 007c __GI___rpc_thread_svc_fdset 00b0 __GI___rpc_thread_svc_pollfd"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D0 FF BD 27 ?? ?? 99 8F 10 00 BC AF 1C 00 B1 AF 2C 00 BF AF 28 00 B4 AF 24 00 B3 AF 20 00 B2 AF 18 00 B0 AF 00 00 90 8C ?? ?? ?? ?? 21 88 80 00 2A 10 02 02 2F 00 40 10 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 B4 00 42 8C 80 18 10 00 21 10 43 00 00 00 43 8C 26 00 71 14 10 00 BC 8F 00 00 40 AC 00 04 02 2A 0E 00 40 10 ?? ?? 92 8F ?? ?? 99 8F 42 89 10 00 ?? ?? ?? ?? 80 88 11 00 21 10 51 00 00 00 44 8C 01 00 03 24 04 18 03 02 27 18 03 00 24 18 64 00 10 00 BC 8F 00 00 43 AC ?? ?? 92 8F ?? ?? 93 8F 21 88 00 00 FF FF 14 24 21 C8 40 02 ?? ?? ?? ?? 00 00 00 00 00 00 42 8C 2A 10 22 02 0B 00 40 10 21 C8 60 02 ?? ?? ?? ?? 00 00 00 00 00 00 42 8C C0 18 11 00 21 10 43 00 00 00 43 8C 01 00 70 50 00 00 54 AC F0 FF 00 10 01 00 31 26 2C 00 BF 8F 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_150_2_0 {
	meta:
		name = "__GI_svc_register"
		size = 284
		refs = "0000 _gp_disp 000c __rpc_thread_variables 005c malloc 00ec __GI_pmap_set"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F C8 FF BD 27 10 00 BC AF 30 00 B5 AF 2C 00 B4 AF 28 00 B3 AF 24 00 B2 AF 20 00 B1 AF 1C 00 B0 AF 34 00 BF AF 21 A8 80 00 21 80 A0 00 21 88 C0 00 21 98 E0 00 ?? ?? ?? ?? 48 00 B4 8F B8 00 43 8C 10 00 BC 8F 21 90 40 00 0D 00 60 10 ?? ?? 99 8F 04 00 62 8C FC FF 50 54 00 00 63 8C 08 00 62 8C 03 00 51 50 0C 00 62 8C F7 FF 00 10 00 00 63 8C 0D 00 53 10 00 00 00 00 1B 00 00 10 21 10 00 00 ?? ?? ?? ?? 10 00 04 24 FB FF 40 10 10 00 BC 8F 04 00 50 AC 08 00 51 AC 0C 00 53 AC B8 00 43 8E 00 00 43 AC B8 00 42 AE 0F 00 80 12 01 00 02 24 34 00 BF 8F 28 00 B3 8F 24 00 B2 8F 21 20 00 02 21 28 20 02 1C 00 B0 8F 20 00 B1 8F 21 30 80 02 04 00 A7 96 2C 00 B4 8F 30 00 B5 8F ?? ?? 99 8F ?? ?? ?? ?? 38 00 BD 27 34 00 BF 8F 30 00 B5 8F 2C 00 B4 8F 28 00 B3 8F 24 00 B2 8F 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_150_3_0 {
	meta:
		name = "__GI_svc_unregister"
		size = 192
		refs = "0000 _gp_disp 000c __rpc_thread_variables 007c free 00a4 __GI_pmap_unset"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F D8 FF BD 27 10 00 BC AF 20 00 B1 AF 1C 00 B0 AF 24 00 BF AF 21 80 80 00 ?? ?? ?? ?? 21 88 A0 00 B8 00 43 8C 10 00 BC 8F 21 30 00 00 1C 00 60 10 24 00 BF 8F 04 00 64 8C 05 00 90 54 21 30 60 00 08 00 64 8C 04 00 91 10 00 00 00 00 21 30 60 00 F6 FF 00 10 00 00 63 8C 03 00 C0 14 00 00 64 8C 02 00 00 10 B8 00 44 AC 00 00 C4 AC ?? ?? 99 8F 21 20 60 00 ?? ?? ?? ?? 00 00 60 AC 10 00 BC 8F 24 00 BF 8F 21 20 00 02 21 28 20 02 1C 00 B0 8F 20 00 B1 8F ?? ?? 99 8F ?? ?? ?? ?? 28 00 BD 27 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_150_4_0 {
	meta:
		name = "__GI_svc_sendreply"
		size = 84
	strings:
		$1 = { B0 FF BD 27 01 00 03 24 1C 00 A3 AF 20 00 83 8C 08 00 82 8C 4C 00 BF AF 24 00 A3 AF 24 00 83 8C 34 00 A6 AF 38 00 A5 AF 28 00 A3 AF 28 00 83 8C 30 00 A0 AF 2C 00 A3 AF 0C 00 59 8C 20 00 A0 AF 09 F8 20 03 18 00 A5 27 4C 00 BF 8F 08 00 E0 03 50 00 BD 27 }
	condition:
		$1
}

rule file_150_5_0 {
	meta:
		name = "svcerr_noproc"
		size = 80
	strings:
		$1 = { B0 FF BD 27 01 00 03 24 1C 00 A3 AF 20 00 83 8C 08 00 82 8C 4C 00 BF AF 24 00 A3 AF 24 00 83 8C 20 00 A0 AF 28 00 A3 AF 28 00 83 8C 2C 00 A3 AF 03 00 03 24 30 00 A3 AF 0C 00 59 8C 09 F8 20 03 18 00 A5 27 4C 00 BF 8F 08 00 E0 03 50 00 BD 27 }
	condition:
		$1
}

rule file_150_6_0 {
	meta:
		name = "__GI_svcerr_decode"
		size = 80
	strings:
		$1 = { B0 FF BD 27 01 00 03 24 1C 00 A3 AF 20 00 83 8C 08 00 82 8C 4C 00 BF AF 24 00 A3 AF 24 00 83 8C 20 00 A0 AF 28 00 A3 AF 28 00 83 8C 2C 00 A3 AF 04 00 03 24 30 00 A3 AF 0C 00 59 8C 09 F8 20 03 18 00 A5 27 4C 00 BF 8F 08 00 E0 03 50 00 BD 27 }
	condition:
		$1
}

rule file_150_7_0 {
	meta:
		name = "svcerr_systemerr"
		size = 80
	strings:
		$1 = { B0 FF BD 27 01 00 03 24 1C 00 A3 AF 20 00 83 8C 08 00 82 8C 4C 00 BF AF 24 00 A3 AF 24 00 83 8C 20 00 A0 AF 28 00 A3 AF 28 00 83 8C 2C 00 A3 AF 05 00 03 24 30 00 A3 AF 0C 00 59 8C 09 F8 20 03 18 00 A5 27 4C 00 BF 8F 08 00 E0 03 50 00 BD 27 }
	condition:
		$1
}

rule file_150_8_0 {
	meta:
		name = "__GI_svcerr_auth"
		size = 56
	strings:
		$1 = { B0 FF BD 27 01 00 02 24 4C 00 BF AF 24 00 A2 AF 1C 00 A2 AF 20 00 A2 AF 08 00 82 8C 28 00 A5 AF 0C 00 59 8C 09 F8 20 03 18 00 A5 27 4C 00 BF 8F 08 00 E0 03 50 00 BD 27 }
	condition:
		$1
}

rule file_150_10_0 {
	meta:
		name = "__GI_svcerr_noprog"
		size = 76
	strings:
		$1 = { 20 00 85 8C B0 FF BD 27 08 00 82 8C 24 00 A5 AF 24 00 85 8C 01 00 03 24 4C 00 BF AF 28 00 A5 AF 28 00 85 8C 30 00 A3 AF 1C 00 A3 AF 2C 00 A5 AF 0C 00 59 8C 20 00 A0 AF 09 F8 20 03 18 00 A5 27 4C 00 BF 8F 08 00 E0 03 50 00 BD 27 }
	condition:
		$1
}

rule file_150_11_0 {
	meta:
		name = "__GI_svcerr_progvers"
		size = 88
	strings:
		$1 = { B0 FF BD 27 01 00 03 24 1C 00 A3 AF 20 00 83 8C 08 00 82 8C 4C 00 BF AF 24 00 A3 AF 24 00 83 8C 34 00 A5 AF 38 00 A6 AF 28 00 A3 AF 28 00 83 8C 20 00 A0 AF 2C 00 A3 AF 02 00 03 24 30 00 A3 AF 0C 00 59 8C 09 F8 20 03 18 00 A5 27 4C 00 BF 8F 08 00 E0 03 50 00 BD 27 }
	condition:
		$1
}

rule file_150_12_0 {
	meta:
		name = "__GI_svc_getreq_common"
		size = 524
		refs = "0000 _gp_disp 0014 __rpc_thread_variables 006c __GI_svcerr_noprog 0070 __GI_svcerr_progvers 00d8 _null_auth 00ec __GI__authenticate 0104 __GI_svcerr_auth"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 C8 FA BD 27 18 00 A2 27 ?? ?? 99 8F E4 04 A2 AF A8 01 A2 27 10 00 BC AF 1C 05 B1 AF 18 05 B0 AF 34 05 BF AF 30 05 B6 AF 2C 05 B5 AF 28 05 B4 AF 24 05 B3 AF 20 05 B2 AF F0 04 A2 AF ?? ?? ?? ?? 21 80 80 00 21 88 40 00 B4 00 42 8C 80 80 10 00 21 80 50 00 00 00 10 8E 5F 00 00 12 10 00 BC 8F ?? ?? 95 8F ?? ?? 96 8F C8 04 B2 27 38 03 B4 27 F8 04 B3 27 08 00 02 8E 21 20 00 02 00 00 59 8C 09 F8 20 03 21 28 40 02 45 00 40 10 10 00 BC 8F D4 04 A2 8F E4 04 A3 8F 10 05 B4 AF F8 04 A2 AF D8 04 A2 8F 08 05 A3 AF E8 04 A3 8F FC 04 A2 AF DC 04 A2 8F 14 05 B0 AF 0C 05 A3 AF 00 05 A2 AF E0 04 A2 8F 06 00 40 14 04 05 A2 AF ?? ?? 82 8F 28 00 00 AE 00 00 42 8C 0D 00 00 10 20 00 02 AE ?? ?? 99 8F 21 20 60 02 ?? ?? ?? ?? 21 28 40 02 07 00 40 10 10 00 BC 8F ?? ?? 99 8F 21 20 00 02 ?? ?? ?? ?? 21 28 40 00 25 00 00 10 00 00 00 00 B8 00 23 8E 21 10 00 00 21 30 00 00 FF FF 05 24 15 00 60 10 00 00 00 00 04 00 67 8C F8 04 A4 8F FB FF E4 54 00 00 63 8C 08 00 67 8C FC 04 A2 8F 07 00 E2 14 2B 10 E5 00 0C 00 79 8C 21 20 60 02 09 F8 20 03 21 28 00 02 11 00 00 10 00 00 00 00 0B 28 E2 00 2B 10 C7 00 0B 30 E2 00 01 00 02 24 EB FF 00 10 00 00 63 8C 06 00 40 10 21 20 00 02 21 C8 C0 02 ?? ?? ?? ?? 00 00 00 00 04 00 00 10 00 00 00 00 21 C8 A0 02 ?? ?? ?? ?? 00 00 00 00 08 00 02 8E 04 00 59 8C 09 F8 20 03 21 20 00 02 07 00 40 14 01 00 03 24 08 00 02 8E 14 00 59 8C 09 F8 20 03 21 20 00 02 04 00 00 10 34 05 BF 8F A9 FF 43 50 08 00 02 8E 34 05 BF 8F 30 05 B6 8F 2C 05 B5 8F 28 05 B4 8F 24 05 B3 8F 20 05 B2 8F 1C 05 B1 8F 18 05 B0 8F 08 00 E0 03 38 05 BD 27 }
	condition:
		$1
}

rule file_150_13_0 {
	meta:
		name = "__GI_svc_getreqset"
		size = 220
		refs = "0000 _gp_disp 000c __GI__rpc_dtablesize 0050 __GI_svc_getreq_common"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F C0 FF BD 27 10 00 BC AF 34 00 B6 AF 30 00 B5 AF 2C 00 B4 AF 28 00 B3 AF 1C 00 B0 AF 3C 00 BF AF 38 00 B7 AF 24 00 B2 AF 20 00 B1 AF ?? ?? ?? ?? 21 80 80 00 10 00 BC 8F 21 20 00 02 21 A0 40 00 ?? ?? 93 8F 21 80 00 00 1F 00 15 24 01 00 16 24 2A 10 14 02 12 00 40 10 04 00 97 24 00 00 91 8C 23 90 11 00 24 90 32 02 20 90 52 72 23 90 B2 02 01 00 44 26 07 00 80 10 21 C8 60 02 21 20 04 02 FF FF 84 24 ?? ?? ?? ?? 04 90 56 02 F4 FF 00 10 26 88 32 02 20 00 10 26 ED FF 00 10 21 20 E0 02 3C 00 BF 8F 38 00 B7 8F 34 00 B6 8F 30 00 B5 8F 2C 00 B4 8F 28 00 B3 8F 24 00 B2 8F 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 40 00 BD 27 }
	condition:
		$1
}

rule file_150_14_0 {
	meta:
		name = "__GI_svc_getreq"
		size = 84
		refs = "0000 _gp_disp 0038 __GI_svc_getreqset"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 60 FF BD 27 21 10 00 00 18 00 A3 27 10 00 BC AF 9C 00 BF AF 20 00 05 24 80 30 02 00 21 30 66 00 01 00 42 24 FC FF 45 14 00 00 C0 AC ?? ?? 99 8F 18 00 A4 AF ?? ?? ?? ?? 21 20 60 00 9C 00 BF 8F 08 00 E0 03 A0 00 BD 27 }
	condition:
		$1
}

rule file_150_15_0 {
	meta:
		name = "__GI_svc_getreq_poll"
		size = 276
		refs = "0000 _gp_disp 0020 __GI_svc_getreq_common 0024 __GI___rpc_thread_svc_max_pollfd 0028 __rpc_thread_variables 002c __GI_xprt_unregister"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 B8 FF BD 27 40 00 BE AF 3C 00 B7 AF 38 00 B6 AF 30 00 B4 AF ?? ?? 96 8F ?? ?? 94 8F ?? ?? 97 8F ?? ?? 9E 8F 34 00 B5 AF 2C 00 B3 AF 28 00 B2 AF 24 00 B1 AF 20 00 B0 AF 10 00 BC AF 44 00 BF AF 21 98 80 00 21 90 A0 00 21 88 00 00 21 80 00 00 FF FF 15 24 21 C8 80 02 ?? ?? ?? ?? 00 00 00 00 00 00 42 8C 2A 10 02 02 1B 00 40 10 2A 10 32 02 19 00 40 10 C0 10 10 00 21 10 62 02 00 00 44 8C F4 FF 95 50 01 00 10 26 06 00 42 84 F1 FF 40 50 01 00 10 26 20 00 42 30 01 00 31 26 0A 00 40 10 21 C8 C0 02 21 C8 E0 02 ?? ?? ?? ?? 18 00 A4 AF 18 00 A4 8F B4 00 42 8C 21 C8 C0 03 80 20 04 00 21 20 44 00 00 00 84 8C 09 F8 20 03 00 00 00 00 E0 FF 00 10 01 00 10 26 44 00 BF 8F 40 00 BE 8F 3C 00 B7 8F 38 00 B6 8F 34 00 B5 8F 30 00 B4 8F 2C 00 B3 8F 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 08 00 E0 03 48 00 BD 27 }
	condition:
		$1
}

rule file_150_16_0 {
	meta:
		name = "__rpc_thread_svc_cleanup"
		size = 104
		refs = "0000 _gp_disp 0018 __GI_svc_unregister 001c __rpc_thread_variables"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D8 FF BD 27 20 00 B1 AF 1C 00 B0 AF ?? ?? 91 8F ?? ?? 90 8F 10 00 BC AF 24 00 BF AF 21 C8 00 02 ?? ?? ?? ?? 00 00 00 00 B8 00 42 8C 06 00 40 10 21 C8 20 02 04 00 44 8C ?? ?? ?? ?? 08 00 45 8C F7 FF 00 10 21 C8 00 02 24 00 BF 8F 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_151_0_0 {
	meta:
		name = "__GI_uname"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 1A 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_152_0_0 {
	meta:
		name = "__GI_tcgetattr"
		size = 172
		refs = "0000 _gp_disp 000c __GI_ioctl 0044 __GI_mempcpy 0088 __GI_memset"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F B0 FF BD 27 18 00 A6 27 10 00 BC AF 48 00 B1 AF 44 00 B0 AF 4C 00 BF AF 21 80 A0 00 ?? ?? ?? ?? 0D 54 05 24 21 88 40 00 16 00 40 14 10 00 BC 8F 18 00 A2 8F ?? ?? 99 8F 11 00 04 26 00 00 02 AE 1C 00 A2 8F 29 00 A5 27 17 00 06 24 04 00 02 AE 20 00 A2 8F 08 00 02 AE 24 00 A2 8F 0C 00 02 AE 28 00 A2 93 ?? ?? ?? ?? 10 00 02 A2 10 00 BC 8F 21 20 40 00 21 28 00 00 ?? ?? 99 8F ?? ?? ?? ?? 09 00 06 24 4C 00 BF 8F 21 10 20 02 44 00 B0 8F 48 00 B1 8F 08 00 E0 03 50 00 BD 27 }
	condition:
		$1
}

rule file_154_0_0 {
	meta:
		name = "a64l"
		size = 92
		refs = "0000 _gp_disp"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 87 8F 06 00 86 24 21 18 00 00 21 10 00 00 ?? ?? E7 24 40 00 08 24 00 00 85 80 D2 FF A5 24 4D 00 A9 2C 08 00 20 11 21 28 A7 00 00 00 A5 80 05 00 A8 10 04 28 65 00 01 00 84 24 25 10 45 00 F5 FF 86 14 06 00 63 24 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_155_0_0 {
	meta:
		name = "putgrent"
		size = 336
		refs = "0000 _gp_disp 003c __GI___errno_location 0060 _pthread_cleanup_push_defer 0068 __pthread_mutex_unlock 007c __pthread_mutex_lock 0090 __GI_fprintf 008c $LC0 00d8 __GI___fputc_unlocked 011c _pthread_cleanup_pop_restore"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 B8 FF BD 27 18 00 BC AF 34 00 B1 AF 44 00 BF AF 40 00 B4 AF 3C 00 B3 AF 38 00 B2 AF 30 00 B0 AF 03 00 80 10 21 88 80 00 07 00 A0 14 21 80 A0 00 ?? ?? 99 8F ?? ?? ?? ?? FF FF 10 24 16 00 03 24 37 00 00 10 00 00 43 AC 34 00 B2 8C 0D 00 40 56 ?? ?? 85 8F ?? ?? 99 8F 38 00 B3 24 ?? ?? 85 8F 20 00 A4 27 ?? ?? ?? ?? 21 30 60 02 18 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 60 02 18 00 BC 8F ?? ?? 85 8F ?? ?? 93 8F 08 00 22 8E 00 00 26 8E 04 00 27 8E 21 20 00 02 10 00 A2 AF 21 C8 60 02 ?? ?? ?? ?? ?? ?? A5 24 16 00 40 04 18 00 BC 8F ?? ?? 85 8F 0C 00 31 8E ?? ?? 94 8F ?? ?? A5 24 00 00 26 8E 08 00 C0 14 21 C8 60 02 ?? ?? 99 8F 21 28 00 02 ?? ?? ?? ?? 0A 00 04 24 C3 87 02 00 09 00 00 10 18 00 BC 8F ?? ?? ?? ?? 21 20 00 02 04 00 40 04 18 00 BC 8F 04 00 31 26 F0 FF 00 10 ?? ?? 85 26 FF FF 10 24 06 00 40 16 44 00 BF 8F ?? ?? 99 8F 20 00 A4 27 ?? ?? ?? ?? 01 00 05 24 44 00 BF 8F 21 10 00 02 40 00 B4 8F 3C 00 B3 8F 38 00 B2 8F 34 00 B1 8F 30 00 B0 8F 08 00 E0 03 48 00 BD 27 }
	condition:
		$1
}

rule file_156_0_0 {
	meta:
		name = "parse_printf_format"
		size = 428
		refs = "0000 _gp_disp 0010 _ppfs_init 00a0 _ppfs_parsespec"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 28 FF BD 27 ?? ?? 99 8F C0 00 B4 AF BC 00 B3 AF 18 00 B4 27 21 98 80 00 10 00 BC AF B4 00 B1 AF B0 00 B0 AF D4 00 BF AF D0 00 BE AF CC 00 B7 AF C8 00 B6 AF C4 00 B5 AF B8 00 B2 AF 21 88 A0 00 21 20 80 02 21 28 60 02 ?? ?? ?? ?? 21 80 C0 00 45 00 40 04 10 00 BC 8F 30 00 B2 8F 0D 00 40 1A 2B 10 51 02 0B 88 42 02 21 10 00 00 2B 18 51 00 3E 00 60 10 0A 00 43 24 80 18 03 00 21 18 83 02 00 00 63 8C 01 00 42 24 04 00 10 26 F7 FF 00 10 FC FF 03 AE ?? ?? 97 8F 21 90 00 00 25 00 15 24 00 80 16 3C 08 00 1E 24 00 00 62 82 30 00 40 10 D4 00 BF 8F FC FF 55 54 01 00 73 26 01 00 63 82 26 00 75 10 01 00 62 26 18 00 A2 AF 21 C8 E0 02 ?? ?? ?? ?? 21 20 80 02 20 00 A2 8F 06 00 56 14 18 00 B3 8F 04 00 20 12 01 00 52 26 00 00 00 AE FF FF 31 26 04 00 10 26 1C 00 A2 8F 07 00 56 14 21 10 00 00 05 00 20 12 01 00 52 26 00 00 00 AE FF FF 31 26 04 00 10 26 21 10 00 00 34 00 A3 8F 2B 18 43 00 E0 FF 60 10 0A 00 43 24 80 18 03 00 21 18 83 02 00 00 63 8C F8 FF 7E 50 01 00 42 24 04 00 20 12 01 00 52 26 00 00 03 AE FF FF 31 26 04 00 10 26 F1 FF 00 10 01 00 42 24 21 98 40 00 D1 FF 00 10 01 00 73 26 21 90 00 00 D4 00 BF 8F 21 10 40 02 D0 00 BE 8F CC 00 B7 8F C8 00 B6 8F C4 00 B5 8F C0 00 B4 8F BC 00 B3 8F B8 00 B2 8F B4 00 B1 8F B0 00 B0 8F 08 00 E0 03 D8 00 BD 27 }
	condition:
		$1
}

rule file_157_0_0 {
	meta:
		name = "xdr_free"
		size = 40
	strings:
		$1 = { C8 FF BD 27 21 C8 80 00 02 00 02 24 34 00 BF AF 18 00 A2 AF 09 F8 20 03 18 00 A4 27 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_157_2_0 {
	meta:
		name = "__GI_xdr_long"
		size = 56
	strings:
		$1 = { 00 00 82 8C 04 00 40 14 01 00 06 24 04 00 82 8C 05 00 00 10 04 00 59 8C 05 00 46 54 02 00 42 38 04 00 82 8C 00 00 59 8C 08 00 20 03 00 00 00 00 08 00 E0 03 01 00 42 2C }
	condition:
		$1
}

rule file_157_3_0 {
	meta:
		name = "__GI_xdr_short"
		size = 132
	strings:
		$1 = { 00 00 83 8C D8 FF BD 27 20 00 B0 AF 21 80 A0 00 01 00 05 24 24 00 BF AF 0D 00 65 50 04 00 82 8C 04 00 60 50 04 00 82 8C 02 00 63 38 10 00 00 10 01 00 63 2C 00 00 03 86 18 00 A5 27 04 00 59 8C 09 F8 20 03 18 00 A3 AF 09 00 00 10 21 18 40 00 00 00 59 8C 09 F8 20 03 18 00 A5 27 04 00 40 10 21 18 00 00 18 00 A2 8F 01 00 03 24 00 00 02 A6 24 00 BF 8F 20 00 B0 8F 21 10 60 00 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_157_5_0 {
	meta:
		name = "__GI_xdr_u_long"
		size = 124
	strings:
		$1 = { 00 00 83 8C D8 FF BD 27 01 00 06 24 24 00 BF AF 20 00 B0 AF 05 00 66 50 04 00 82 8C 0D 00 60 10 02 00 63 38 10 00 00 10 01 00 63 2C 21 80 A0 00 00 00 59 8C 09 F8 20 03 18 00 A5 27 0A 00 40 10 21 18 00 00 18 00 A2 8F 01 00 03 24 06 00 00 10 00 00 02 AE 04 00 82 8C 04 00 59 8C 09 F8 20 03 00 00 00 00 21 18 40 00 24 00 BF 8F 20 00 B0 8F 21 10 60 00 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_157_7_0 {
	meta:
		name = "__GI_xdr_hyper"
		size = 216
		altNames = "__GI_xdr_u_hyper"
	strings:
		$1 = { D0 FF BD 27 28 00 B1 AF 24 00 B0 AF 2C 00 BF AF 00 00 82 8C 21 80 80 00 13 00 40 14 21 88 A0 00 00 00 A2 8C 04 00 A3 8C 18 00 A2 AF 04 00 82 8C 1C 00 A3 AF 04 00 59 8C 09 F8 20 03 1C 00 A5 27 03 00 40 54 04 00 02 8E 1E 00 00 10 21 10 00 00 21 20 00 02 04 00 59 8C 09 F8 20 03 18 00 A5 27 18 00 00 10 2B 10 02 00 01 00 03 24 14 00 43 14 02 00 42 38 04 00 82 8C 00 00 59 8C 09 F8 20 03 1C 00 A5 27 0F 00 40 10 21 10 00 00 04 00 02 8E 21 20 00 02 00 00 59 8C 09 F8 20 03 18 00 A5 27 08 00 40 50 21 10 00 00 18 00 A2 8F 00 00 22 AE 1C 00 A2 8F 04 00 22 AE 02 00 00 10 01 00 02 24 01 00 42 2C 2C 00 BF 8F 28 00 B1 8F 24 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_157_11_0 {
	meta:
		name = "__GI_xdr_u_short"
		size = 132
	strings:
		$1 = { 00 00 83 8C D8 FF BD 27 20 00 B0 AF 21 80 A0 00 01 00 05 24 24 00 BF AF 0D 00 65 50 04 00 82 8C 04 00 60 50 04 00 82 8C 02 00 63 38 10 00 00 10 01 00 63 2C 00 00 03 96 18 00 A5 27 04 00 59 8C 09 F8 20 03 18 00 A3 AF 09 00 00 10 21 18 40 00 00 00 59 8C 09 F8 20 03 18 00 A5 27 04 00 40 10 21 18 00 00 18 00 A2 8F 01 00 03 24 00 00 02 A6 24 00 BF 8F 20 00 B0 8F 21 10 60 00 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_157_12_0 {
	meta:
		name = "xdr_char"
		size = 92
		refs = "0000 _gp_disp 0020 __GI_xdr_long"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D8 FF BD 27 20 00 B0 AF 10 00 BC AF 24 00 BF AF 00 00 A2 80 ?? ?? 99 8F 21 80 A0 00 18 00 A2 AF ?? ?? ?? ?? 18 00 A5 27 04 00 40 10 21 18 00 00 18 00 A2 8F 01 00 03 24 00 00 02 A2 24 00 BF 8F 20 00 B0 8F 21 10 60 00 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_157_13_0 {
	meta:
		name = "xdr_u_char"
		size = 92
		refs = "0000 _gp_disp 0020 __GI_xdr_u_long"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D8 FF BD 27 20 00 B0 AF 10 00 BC AF 24 00 BF AF 00 00 A2 90 ?? ?? 99 8F 21 80 A0 00 18 00 A2 AF ?? ?? ?? ?? 18 00 A5 27 04 00 40 10 21 18 00 00 18 00 A2 8F 01 00 03 24 00 00 02 A2 24 00 BF 8F 20 00 B0 8F 21 10 60 00 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_157_14_0 {
	meta:
		name = "__GI_xdr_bool"
		size = 140
	strings:
		$1 = { 00 00 83 8C D8 FF BD 27 20 00 B0 AF 21 80 A0 00 01 00 05 24 24 00 BF AF 0E 00 65 50 04 00 82 8C 04 00 60 50 04 00 82 8C 02 00 63 38 12 00 00 10 01 00 63 2C 00 00 03 8E 18 00 A5 27 04 00 59 8C 2B 18 03 00 09 F8 20 03 18 00 A3 AF 0A 00 00 10 21 18 40 00 00 00 59 8C 09 F8 20 03 18 00 A5 27 05 00 40 10 21 18 00 00 18 00 A2 8F 01 00 03 24 2B 10 02 00 00 00 02 AE 24 00 BF 8F 20 00 B0 8F 21 10 60 00 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_157_16_0 {
	meta:
		name = "__GI_xdr_opaque"
		size = 264
		refs = "0000 _gp_disp"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 37 00 C0 10 00 00 00 00 D8 FF BD 27 03 00 C2 30 10 00 BC AF 20 00 B1 AF 1C 00 B0 AF 24 00 BF AF 21 80 80 00 03 00 40 10 21 88 00 00 04 00 11 24 23 88 22 02 00 00 02 8E 01 00 03 24 05 00 43 50 04 00 02 8E 13 00 40 10 02 00 42 38 26 00 00 10 01 00 42 2C 08 00 59 8C 09 F8 20 03 21 20 00 02 03 00 40 14 10 00 BC 8F 1F 00 00 10 21 10 00 00 03 00 20 56 04 00 02 8E 1B 00 00 10 01 00 02 24 ?? ?? 85 8F 21 20 00 02 08 00 59 8C 0E 00 00 10 ?? ?? A5 24 04 00 02 8E 0C 00 59 8C 09 F8 20 03 21 20 00 02 F0 FF 40 10 10 00 BC 8F 0E 00 20 52 01 00 02 24 04 00 02 8E ?? ?? 85 8F 21 20 00 02 0C 00 59 8C ?? ?? A5 24 24 00 BF 8F 1C 00 B0 8F 21 30 20 02 20 00 B1 8F 08 00 20 03 28 00 BD 27 08 00 E0 03 01 00 02 24 24 00 BF 8F 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_157_17_0 {
	meta:
		name = "__GI_xdr_bytes"
		size = 340
		refs = "0000 _gp_disp 0010 __GI_xdr_u_long 00a4 malloc 00c0 stderr 00c8 __GI_fputs 00c4 $LC0 0100 __GI_xdr_opaque 0114 free"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D0 FF BD 27 ?? ?? 99 8F 10 00 BC AF 28 00 B4 AF 24 00 B3 AF 20 00 B2 AF 1C 00 B1 AF 2C 00 BF AF 18 00 B0 AF 00 00 B0 8C 21 90 A0 00 21 28 C0 00 21 98 80 00 21 88 C0 00 ?? ?? ?? ?? 21 A0 E0 00 36 00 40 10 10 00 BC 8F 00 00 31 8E 2B A0 91 02 04 00 80 12 00 00 63 8E 02 00 04 24 32 00 64 14 21 10 00 00 01 00 02 24 07 00 62 10 00 00 00 00 18 00 60 10 02 00 02 24 22 00 62 10 21 10 00 00 2A 00 00 10 2C 00 BF 8F 27 00 20 12 01 00 02 24 11 00 00 16 2C 00 BF 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 20 02 21 80 40 00 10 00 BC 8F 09 00 40 14 00 00 42 AE ?? ?? 82 8F ?? ?? 84 8F ?? ?? 99 8F 00 00 45 8C ?? ?? ?? ?? ?? ?? 84 24 16 00 00 10 21 10 00 00 2C 00 BF 8F 28 00 B4 8F 20 00 B2 8F 21 20 60 02 21 28 00 02 24 00 B3 8F 18 00 B0 8F 21 30 20 02 ?? ?? 99 8F 1C 00 B1 8F ?? ?? ?? ?? 30 00 BD 27 07 00 00 12 ?? ?? 99 8F ?? ?? ?? ?? 21 20 00 02 03 00 00 10 00 00 40 AE 02 00 00 10 21 10 00 00 01 00 02 24 2C 00 BF 8F 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_157_19_0 {
	meta:
		name = "__GI_xdr_union"
		size = 212
		refs = "0000 _gp_disp 000c __GI_xdr_long"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F D0 FF BD 27 10 00 BC AF 28 00 B4 AF 24 00 B3 AF 20 00 B2 AF 1C 00 B1 AF 18 00 B0 AF 2C 00 BF AF 21 88 80 00 21 A0 A0 00 21 98 C0 00 21 80 E0 00 ?? ?? ?? ?? 40 00 B2 8F 19 00 40 10 10 00 BC 8F 00 00 82 8E 04 00 19 8E 08 00 20 13 00 00 00 00 00 00 03 8E FB FF 62 14 08 00 10 26 21 20 20 02 21 28 60 02 06 00 00 10 FF FF 06 24 0C 00 40 12 21 20 20 02 21 28 60 02 FF FF 06 24 21 C8 40 02 2C 00 BF 8F 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 20 03 30 00 BD 27 2C 00 BF 8F 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 21 10 00 00 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_157_20_0 {
	meta:
		name = "__GI_xdr_string"
		size = 364
		refs = "0000 _gp_disp 004c __GI_xdr_u_long 0054 __GI_strlen 00bc free 00e0 malloc 00fc stderr 0104 __GI_fputs 0100 $LC1 0128 __GI_xdr_opaque"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 C8 FF BD 27 30 00 B4 AF 28 00 B2 AF 24 00 B1 AF 10 00 BC AF 34 00 BF AF 2C 00 B3 AF 20 00 B0 AF 00 00 82 8C 21 88 80 00 21 90 A0 00 21 A0 C0 00 08 00 40 10 00 00 B0 8C 02 00 03 24 0C 00 43 14 ?? ?? 99 8F 05 00 00 16 ?? ?? 99 8F 3C 00 00 10 01 00 02 24 39 00 00 12 ?? ?? 99 8F ?? ?? ?? ?? 21 20 00 02 10 00 BC 8F 18 00 A2 AF ?? ?? 99 8F 21 20 20 02 ?? ?? ?? ?? 18 00 A5 27 2F 00 40 10 10 00 BC 8F 18 00 B3 8F 2B A0 93 02 2B 00 80 16 01 00 03 24 00 00 22 8E 0A 00 43 10 01 00 64 26 1D 00 40 10 02 00 03 24 25 00 43 54 21 10 00 00 ?? ?? 99 8F ?? ?? ?? ?? 21 20 00 02 1D 00 00 10 00 00 40 AE 1E 00 80 10 01 00 02 24 11 00 00 56 21 98 13 02 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 21 80 40 00 10 00 BC 8F 09 00 40 14 00 00 42 AE ?? ?? 82 8F ?? ?? 84 8F ?? ?? 99 8F 00 00 45 8C ?? ?? ?? ?? ?? ?? 84 24 0D 00 00 10 21 10 00 00 21 98 13 02 00 00 60 A2 18 00 A6 8F ?? ?? 99 8F 21 20 20 02 ?? ?? ?? ?? 21 28 00 02 05 00 00 10 34 00 BF 8F 02 00 00 10 01 00 02 24 21 10 00 00 34 00 BF 8F 30 00 B4 8F 2C 00 B3 8F 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_157_21_0 {
	meta:
		name = "xdr_wrapstring"
		size = 52
		refs = "0000 _gp_disp 000c __GI_xdr_string"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F E0 FF BD 27 1C 00 BF AF 10 00 BC AF ?? ?? ?? ?? FF FF 06 24 1C 00 BF 8F 2B 10 02 00 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_158_0_0 {
	meta:
		name = "__GI_gethostbyaddr_r"
		size = 740
		refs = "0000 _gp_disp 0070 __get_hosts_byaddr_r 00e4 __GI_memcpy 0128 __GI_sprintf 0124 $LC0 0148 __GI_memset 016c __dns_lookup 0198 __GI_strncpy 01bc free 01e4 __decode_dotted"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 70 FF BD 27 7C 00 B5 AF A8 00 B5 8F 20 00 BC AF 80 00 B6 AF 70 00 B2 AF 6C 00 B1 AF 68 00 B0 AF 8C 00 BF AF 88 00 BE AF 84 00 B7 AF 78 00 B4 AF 74 00 B3 AF 21 B0 80 00 A0 00 B1 8F A4 00 B2 8F AC 00 B0 8F 97 00 80 10 00 00 A0 AE 02 00 02 24 95 00 C2 14 16 00 02 24 04 00 03 24 92 00 A3 14 21 A0 A0 00 ?? ?? 99 8F 10 00 B1 AF 14 00 B2 AF 18 00 B5 AF 1C 00 B0 AF ?? ?? ?? ?? 21 98 E0 00 21 18 40 00 20 00 BC 8F 87 00 60 10 21 10 00 00 00 00 02 8E 01 00 04 24 04 00 44 50 FF FF 02 24 81 00 54 54 21 10 60 00 FF FF 02 24 00 00 02 AE 23 10 11 00 03 00 42 30 D4 FF 54 26 21 88 22 02 23 A0 82 02 28 00 23 26 00 01 84 2A 54 00 A3 AF 75 00 80 14 22 00 02 24 ?? ?? 99 8F 2C 00 32 26 20 00 23 AE 21 28 C0 02 54 00 A4 27 04 00 06 24 00 00 32 AE 04 00 20 AE ?? ?? ?? ?? 24 00 20 AE 01 00 C2 92 20 00 BC 8F 03 00 C6 92 02 00 C7 92 10 00 A2 AF 00 00 C2 92 ?? ?? 85 8F ?? ?? 99 8F 21 20 40 02 ?? ?? A5 24 ?? ?? ?? ?? 14 00 A2 AF 20 00 BC 8F 28 00 B7 27 21 20 E0 02 ?? ?? 99 8F 21 28 00 00 ?? ?? ?? ?? 28 00 06 24 20 00 BC 8F 50 00 B9 27 21 B0 00 00 58 00 B9 AF 05 00 1E 24 ?? ?? 99 8F 21 20 40 02 0C 00 05 24 50 00 A6 27 ?? ?? ?? ?? 21 38 E0 02 03 00 41 04 20 00 BC 8F 45 00 00 10 01 00 02 24 28 00 A7 8F ?? ?? 99 8F 21 20 40 02 21 28 E0 00 21 30 80 02 5C 00 A7 AF ?? ?? ?? ?? 60 00 A2 AF 20 00 BC 8F 5C 00 A7 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 E0 00 2C 00 A2 8F 20 00 BC 8F 17 00 5E 14 60 00 A3 8F 01 00 D6 26 06 00 02 24 0F 00 C2 12 ?? ?? 99 8F 50 00 A4 8F 40 00 A5 8F 21 30 60 00 21 38 40 02 ?? ?? ?? ?? 10 00 B4 AF 20 00 BC 8F 50 00 A4 8F ?? ?? 99 8F ?? ?? ?? ?? 5C 00 A2 AF 5C 00 A2 8F D4 FF 41 04 20 00 BC 8F 03 00 02 24 00 00 02 AE 22 00 00 10 FF FF 02 24 0C 00 05 24 17 00 45 14 50 00 A4 8F ?? ?? 99 8F 40 00 A5 8F 21 30 60 00 21 38 40 02 ?? ?? ?? ?? 10 00 B4 AF 20 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 50 00 A4 8F 02 00 02 24 08 00 62 AE 04 00 02 24 0C 00 62 AE 20 00 22 26 10 00 62 AE 00 00 72 AE 04 00 71 AE 00 00 B3 AE 21 10 00 00 09 00 00 10 00 00 00 AE ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 04 00 02 24 00 00 02 AE 02 00 00 10 02 00 02 24 16 00 02 24 8C 00 BF 8F 88 00 BE 8F 84 00 B7 8F 80 00 B6 8F 7C 00 B5 8F 78 00 B4 8F 74 00 B3 8F 70 00 B2 8F 6C 00 B1 8F 68 00 B0 8F 08 00 E0 03 90 00 BD 27 }
	condition:
		$1
}

rule file_159_0_0 {
	meta:
		name = "getpass"
		size = 604
		refs = "0000 _gp_disp 0020 __GI_fopen 001c $LC0 0010 $LC1 0060 stdin 0064 stderr 0070 __GI_fileno 0090 __GI_tcgetattr 00a4 __GI_memcpy 00e0 __GI_tcsetattr 00fc __GI_setvbuf 0118 __GI_fputs 012c __GI_fflush 0148 __GI_fgets 015c __GI_strlen 01a0 __GI_fputc 01d0 __GI___fputc_unlocked 0224 __GI_fclose"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 60 FF BD 27 ?? ?? 85 8F 94 00 B5 AF 21 A8 80 00 ?? ?? 84 8F ?? ?? 99 8F 10 00 BC AF 8C 00 B3 AF 84 00 B1 AF 80 00 B0 AF 9C 00 BF AF 98 00 B6 AF 90 00 B4 AF 88 00 B2 AF ?? ?? 84 24 ?? ?? ?? ?? ?? ?? A5 24 10 00 BC 8F 21 80 40 00 21 88 40 00 04 00 40 14 ?? ?? 93 8F ?? ?? 82 8F 00 00 70 8E 00 00 51 8C ?? ?? 96 8F 21 20 00 02 21 C8 C0 02 ?? ?? ?? ?? 18 00 B2 27 10 00 BC 8F 21 20 40 00 21 28 40 02 ?? ?? 99 8F ?? ?? ?? ?? 21 A0 00 00 1E 00 40 14 10 00 BC 8F ?? ?? 99 8F 21 28 40 02 34 00 06 24 ?? ?? ?? ?? 4C 00 A4 27 24 00 A3 8F F6 FF 02 24 21 20 00 02 24 10 62 00 21 C8 C0 02 ?? ?? ?? ?? 24 00 A2 AF 10 00 BC 8F 21 20 40 00 10 54 05 24 ?? ?? 99 8F ?? ?? ?? ?? 21 30 40 02 01 00 54 2C 00 00 62 8E 08 00 02 12 10 00 BC 8F ?? ?? 99 8F 21 20 00 02 21 28 00 00 02 00 06 24 ?? ?? ?? ?? 21 38 00 00 10 00 BC 8F ?? ?? 99 8F 21 20 A0 02 ?? ?? ?? ?? 21 28 20 02 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 20 02 10 00 BC 8F FF 00 05 24 21 30 00 02 ?? ?? 92 8F ?? ?? 99 8F ?? ?? ?? ?? ?? ?? 44 26 10 00 BC 8F ?? ?? 44 26 ?? ?? 99 8F ?? ?? ?? ?? ?? ?? 55 26 03 00 41 04 10 00 BC 8F 1E 00 00 10 ?? ?? 40 A2 FF FF 42 24 21 10 A2 02 00 00 44 80 0A 00 03 24 18 00 83 14 00 00 00 00 22 00 80 12 00 00 40 A0 34 00 22 8E 0D 00 40 10 ?? ?? 99 8F 10 00 23 8E 1C 00 22 8E 2B 10 62 00 04 00 40 10 01 00 62 24 10 00 22 AE 0D 00 00 10 00 00 64 A0 0A 00 04 24 21 28 20 02 03 00 00 10 ?? ?? 99 8F 0A 00 04 24 21 28 20 02 09 F8 20 03 00 00 00 00 04 00 00 10 21 C8 C0 02 0C 00 80 52 00 00 62 8E 21 C8 C0 02 ?? ?? ?? ?? 21 20 00 02 10 00 BC 8F 21 20 40 00 10 54 05 24 ?? ?? 99 8F ?? ?? ?? ?? 4C 00 A6 27 10 00 BC 8F 00 00 62 8E 03 00 02 12 ?? ?? 99 8F ?? ?? ?? ?? 21 20 00 02 9C 00 BF 8F 21 10 A0 02 98 00 B6 8F 94 00 B5 8F 90 00 B4 8F 8C 00 B3 8F 88 00 B2 8F 84 00 B1 8F 80 00 B0 8F 08 00 E0 03 A0 00 BD 27 }
	condition:
		$1
}

rule file_161_0_0 {
	meta:
		name = "__GI_iswctype"
		size = 84
		refs = "0000 _gp_disp 0024 __GI___ctype_b"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 80 00 83 2C 0E 00 60 10 21 10 00 00 0D 00 A3 2C 0B 00 60 10 40 20 04 00 ?? ?? 82 8F 40 28 05 00 00 00 42 8C 21 20 44 00 ?? ?? 82 8F 00 00 83 94 ?? ?? 42 24 21 28 A2 00 00 00 A2 94 24 10 62 00 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_162_0_0 {
	meta:
		name = "__GI_glob64"
		size = 704
		refs = "0000 _gp_disp 0078 $LC1 0098 $LC0 00a8 __glob_ignore_err 00d0 __glob_match_in_dir 00fc __glob_freelist 014c __GI_strlen 0168 __glob_append 018c malloc 0194 realloc 0270 __glob_sort 0274 __GI_qsort"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 A8 FF BD 27 08 00 A3 30 48 00 B6 AF 18 00 BC AF 20 00 B6 27 40 00 B4 AF 3C 00 B3 AF 34 00 B1 AF 30 00 B0 AF 54 00 BF AF 50 00 BE AF 4C 00 B7 AF 44 00 B5 AF 38 00 B2 AF 21 A0 80 00 21 98 A0 00 21 10 C0 00 21 80 E0 00 20 00 A0 AF 24 00 A0 AF 28 00 B6 AF 02 00 60 10 21 88 00 00 08 00 F1 8C 00 00 84 82 2F 00 03 24 04 00 83 10 ?? ?? 84 8F 21 18 80 02 09 00 00 10 ?? ?? 84 24 21 18 80 02 2F 00 04 24 00 00 65 80 03 00 A4 54 ?? ?? 84 8F FC FF 00 10 01 00 63 24 ?? ?? 84 24 ?? ?? 85 8F 20 00 77 32 04 00 E0 16 0A 10 A2 00 08 00 11 AE 00 00 00 AE 04 00 00 AE 00 00 65 80 12 00 A0 10 21 A8 00 00 ?? ?? 99 8F 28 00 A5 27 10 00 A5 AF 21 30 60 02 21 28 60 00 ?? ?? ?? ?? 21 38 40 00 21 A8 40 00 01 00 02 24 07 00 A2 16 18 00 BC 8F ?? ?? 99 8F 21 20 C0 02 ?? ?? ?? ?? 01 00 1E 24 60 00 00 10 54 00 BF 8F 20 00 A2 8F 21 90 00 00 28 00 A2 AF 28 00 A2 8F 05 00 40 10 00 00 00 00 00 00 42 8C 01 00 52 26 FA FF 00 10 28 00 A2 AF 12 00 40 16 10 00 62 32 51 00 40 10 03 00 1E 24 ?? ?? 99 8F 21 20 80 02 ?? ?? ?? ?? 28 00 B6 AF 18 00 BC 8F 28 00 A4 27 21 28 80 02 ?? ?? 99 8F 21 30 40 00 ?? ?? ?? ?? 21 38 00 00 01 00 1E 24 43 00 40 14 18 00 BC 8F 01 00 12 24 0F 00 E0 12 ?? ?? 99 8F 00 00 05 8E ?? ?? 99 8F 04 00 04 8E 01 00 A5 24 21 28 B1 00 21 28 B2 00 ?? ?? ?? ?? 80 28 05 00 D2 FF 40 10 18 00 BC 8F 04 00 02 AE 00 00 02 8E 12 00 00 10 21 88 22 02 01 00 24 26 21 20 92 00 ?? ?? ?? ?? 80 20 04 00 04 00 02 AE C7 FF 40 10 18 00 BC 8F 21 10 00 00 2B 18 51 00 08 00 60 50 20 00 A2 8F 04 00 04 8E 80 18 02 00 01 00 42 24 21 18 83 00 F8 FF 00 10 00 00 60 AC 20 00 A2 8F 28 00 A2 AF 21 10 00 00 04 00 03 8E 21 20 51 00 80 20 04 00 2B 28 52 00 09 00 A0 10 21 18 64 00 28 00 A4 8F 01 00 42 24 04 00 84 24 00 00 64 AC 28 00 A3 8F 00 00 63 8C F3 FF 00 10 28 00 A3 AF 00 00 60 AC 00 00 02 8E 04 00 73 32 21 F0 A0 02 21 10 52 00 09 00 60 16 00 00 02 AE 04 00 04 8E ?? ?? 87 8F ?? ?? 99 8F 80 88 11 00 21 20 91 00 21 28 40 02 ?? ?? ?? ?? 04 00 06 24 54 00 BF 8F 21 10 C0 03 4C 00 B7 8F 50 00 BE 8F 48 00 B6 8F 44 00 B5 8F 40 00 B4 8F 3C 00 B3 8F 38 00 B2 8F 34 00 B1 8F 30 00 B0 8F 08 00 E0 03 58 00 BD 27 }
	condition:
		$1
}

rule file_822_6_0 {
	meta:
		name = "__GI_glob"
		size = 704
		refs = "0000 _gp_disp 0078 $LC2 0098 $LC0 00a8 __glob_ignore_err 00d0 __glob_match_in_dir 00fc __glob_freelist 014c __GI_strlen 0168 __glob_append 018c malloc 0194 realloc 0270 __glob_sort 0274 __GI_qsort"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 A8 FF BD 27 08 00 A3 30 48 00 B6 AF 18 00 BC AF 20 00 B6 27 40 00 B4 AF 3C 00 B3 AF 34 00 B1 AF 30 00 B0 AF 54 00 BF AF 50 00 BE AF 4C 00 B7 AF 44 00 B5 AF 38 00 B2 AF 21 A0 80 00 21 98 A0 00 21 10 C0 00 21 80 E0 00 20 00 A0 AF 24 00 A0 AF 28 00 B6 AF 02 00 60 10 21 88 00 00 08 00 F1 8C 00 00 84 82 2F 00 03 24 04 00 83 10 ?? ?? 84 8F 21 18 80 02 09 00 00 10 ?? ?? 84 24 21 18 80 02 2F 00 04 24 00 00 65 80 03 00 A4 54 ?? ?? 84 8F FC FF 00 10 01 00 63 24 ?? ?? 84 24 ?? ?? 85 8F 20 00 77 32 04 00 E0 16 0A 10 A2 00 08 00 11 AE 00 00 00 AE 04 00 00 AE 00 00 65 80 12 00 A0 10 21 A8 00 00 ?? ?? 99 8F 28 00 A5 27 10 00 A5 AF 21 30 60 02 21 28 60 00 ?? ?? ?? ?? 21 38 40 00 21 A8 40 00 01 00 02 24 07 00 A2 16 18 00 BC 8F ?? ?? 99 8F 21 20 C0 02 ?? ?? ?? ?? 01 00 1E 24 60 00 00 10 54 00 BF 8F 20 00 A2 8F 21 90 00 00 28 00 A2 AF 28 00 A2 8F 05 00 40 10 00 00 00 00 00 00 42 8C 01 00 52 26 FA FF 00 10 28 00 A2 AF 12 00 40 16 10 00 62 32 51 00 40 10 03 00 1E 24 ?? ?? 99 8F 21 20 80 02 ?? ?? ?? ?? 28 00 B6 AF 18 00 BC 8F 28 00 A4 27 21 28 80 02 ?? ?? 99 8F 21 30 40 00 ?? ?? ?? ?? 21 38 00 00 01 00 1E 24 43 00 40 14 18 00 BC 8F 01 00 12 24 0F 00 E0 12 ?? ?? 99 8F 00 00 05 8E ?? ?? 99 8F 04 00 04 8E 01 00 A5 24 21 28 B1 00 21 28 B2 00 ?? ?? ?? ?? 80 28 05 00 D2 FF 40 10 18 00 BC 8F 04 00 02 AE 00 00 02 8E 12 00 00 10 21 88 22 02 01 00 24 26 21 20 92 00 ?? ?? ?? ?? 80 20 04 00 04 00 02 AE C7 FF 40 10 18 00 BC 8F 21 10 00 00 2B 18 51 00 08 00 60 50 20 00 A2 8F 04 00 04 8E 80 18 02 00 01 00 42 24 21 18 83 00 F8 FF 00 10 00 00 60 AC 20 00 A2 8F 28 00 A2 AF 21 10 00 00 04 00 03 8E 21 20 51 00 80 20 04 00 2B 28 52 00 09 00 A0 10 21 18 64 00 28 00 A4 8F 01 00 42 24 04 00 84 24 00 00 64 AC 28 00 A3 8F 00 00 63 8C F3 FF 00 10 28 00 A3 AF 00 00 60 AC 00 00 02 8E 04 00 73 32 21 F0 A0 02 21 10 52 00 09 00 60 16 00 00 02 AE 04 00 04 8E ?? ?? 87 8F ?? ?? 99 8F 80 88 11 00 21 20 91 00 21 28 40 02 ?? ?? ?? ?? 04 00 06 24 54 00 BF 8F 21 10 C0 03 4C 00 B7 8F 50 00 BE 8F 48 00 B6 8F 44 00 B5 8F 40 00 B4 8F 3C 00 B3 8F 38 00 B2 8F 34 00 B1 8F 30 00 B0 8F 08 00 E0 03 58 00 BD 27 }
	condition:
		$1
}

rule file_162_1_0 {
	meta:
		name = "__GI_globfree64"
		size = 136
		refs = "0000 _gp_disp 0038 free"
		altNames = "__GI_globfree"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D8 FF BD 27 20 00 B1 AF 1C 00 B0 AF 10 00 BC AF 24 00 BF AF 21 80 80 00 21 88 00 00 00 00 02 8E 04 00 04 8E 2B 10 22 02 0B 00 40 10 ?? ?? 99 8F 08 00 02 8E 21 10 22 02 80 10 02 00 21 20 82 00 00 00 84 8C 01 00 31 26 ?? ?? ?? ?? FC FF 84 24 F2 FF 00 10 10 00 BC 8F ?? ?? ?? ?? 00 00 00 00 24 00 BF 8F 20 00 B1 8F 00 00 00 AE 04 00 00 AE 1C 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_163_0_0 {
	meta:
		name = "putwchar_unlocked"
		size = 28
		refs = "0000 _gp_disp 000c stdout 0010 __GI_fputwc_unlocked"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 45 8C }
	condition:
		$1
}

rule file_85_0_3 {
	meta:
		name = "_ZN10__cxxabiv116__enum_type_infoD2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVN10__cxxabiv116__enum_type_infoE 0010 _ZNSt9type_infoD2Ev"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F ?? ?? 99 8F 08 00 42 24 ?? ?? ?? ?? 00 00 82 AC }
	condition:
		$1
}

rule file_129_0_3 {
	meta:
		name = "_ZN10__cxxabiv117__array_type_infoD2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVN10__cxxabiv117__array_type_infoE 0010 _ZNSt9type_infoD2Ev"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F ?? ?? 99 8F 08 00 42 24 ?? ?? ?? ?? 00 00 82 AC }
	condition:
		$1
}

rule file_126_2_3 {
	meta:
		name = "_ZN10__cxxabiv117__class_type_infoD2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVN10__cxxabiv117__class_type_infoE 0010 _ZNSt9type_infoD2Ev"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F ?? ?? 99 8F 08 00 42 24 ?? ?? ?? ?? 00 00 82 AC }
	condition:
		$1
}

rule file_87_1_3 {
	meta:
		name = "_ZN10__cxxabiv117__pbase_type_infoD2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVN10__cxxabiv117__pbase_type_infoE 0010 _ZNSt9type_infoD2Ev"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F ?? ?? 99 8F 08 00 42 24 ?? ?? ?? ?? 00 00 82 AC }
	condition:
		$1
}

rule file_36_1_3 {
	meta:
		name = "_ZN10__cxxabiv119__pointer_type_infoD2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVN10__cxxabiv119__pointer_type_infoE 0010 _ZN10__cxxabiv117__pbase_type_infoD2Ev"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F ?? ?? 99 8F 08 00 42 24 ?? ?? ?? ?? 00 00 82 AC }
	condition:
		$1
}

rule file_27_1_3 {
	meta:
		name = "_ZN10__cxxabiv120__function_type_infoD2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVN10__cxxabiv120__function_type_infoE 0010 _ZNSt9type_infoD2Ev"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F ?? ?? 99 8F 08 00 42 24 ?? ?? ?? ?? 00 00 82 AC }
	condition:
		$1
}

rule file_84_0_3 {
	meta:
		name = "_ZN10__cxxabiv120__si_class_type_infoD2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVN10__cxxabiv120__si_class_type_infoE 0010 _ZN10__cxxabiv117__class_type_infoD2Ev"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F ?? ?? 99 8F 08 00 42 24 ?? ?? ?? ?? 00 00 82 AC }
	condition:
		$1
}

rule file_43_0_3 {
	meta:
		name = "_ZN10__cxxabiv121__vmi_class_type_infoD2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVN10__cxxabiv121__vmi_class_type_infoE 0010 _ZN10__cxxabiv117__class_type_infoD2Ev"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F ?? ?? 99 8F 08 00 42 24 ?? ?? ?? ?? 00 00 82 AC }
	condition:
		$1
}

rule file_112_0_3 {
	meta:
		name = "_ZN10__cxxabiv123__fundamental_type_infoD2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVN10__cxxabiv123__fundamental_type_infoE 0010 _ZNSt9type_infoD2Ev"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F ?? ?? 99 8F 08 00 42 24 ?? ?? ?? ?? 00 00 82 AC }
	condition:
		$1
}

rule file_7_0_3 {
	meta:
		name = "_ZN10__cxxabiv129__pointer_to_member_type_infoD2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVN10__cxxabiv129__pointer_to_member_type_infoE 0010 _ZN10__cxxabiv117__pbase_type_infoD2Ev"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F ?? ?? 99 8F 08 00 42 24 ?? ?? ?? ?? 00 00 82 AC }
	condition:
		$1
}

rule file_125_2_3 {
	meta:
		name = "_ZN12_GLOBAL__N_121future_error_categoryD2Ev"
		size = 32
		refs = "0000 _gp_disp 0010 _ZNSt14error_categoryD2Ev"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F ?? ?? 99 8F ?? ?? 42 24 ?? ?? ?? ?? 00 00 82 AC }
	condition:
		$1
}

rule file_76_6_3 {
	meta:
		name = "_ZN12_GLOBAL__N_121system_error_categoryD2Ev"
		size = 32
		refs = "0000 _gp_disp 0010 _ZNSt14error_categoryD2Ev"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F ?? ?? 99 8F ?? ?? 42 24 ?? ?? ?? ?? 00 00 82 AC }
	condition:
		$1
}

rule file_76_7_3 {
	meta:
		name = "_ZN12_GLOBAL__N_122generic_error_categoryD2Ev"
		size = 32
		refs = "0000 _gp_disp 0010 _ZNSt14error_categoryD2Ev"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F ?? ?? 99 8F ?? ?? 42 24 ?? ?? ?? ?? 00 00 82 AC }
	condition:
		$1
}

rule file_28_0_3 {
	meta:
		name = "_ZN9__gnu_cxx20recursive_init_errorD2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVN9__gnu_cxx20recursive_init_errorE 0010 _ZNSt9exceptionD2Ev"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F ?? ?? 99 8F 08 00 42 24 ?? ?? ?? ?? 00 00 82 AC }
	condition:
		$1
}

rule file_59_3_3 {
	meta:
		name = "_ZN9__gnu_cxx24__concurrence_lock_errorD2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVN9__gnu_cxx24__concurrence_lock_errorE 0010 _ZNSt9exceptionD2Ev"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F ?? ?? 99 8F 08 00 42 24 ?? ?? ?? ?? 00 00 82 AC }
	condition:
		$1
}

rule file_59_2_3 {
	meta:
		name = "_ZN9__gnu_cxx26__concurrence_unlock_errorD2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVN9__gnu_cxx26__concurrence_unlock_errorE 0010 _ZNSt9exceptionD2Ev"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F ?? ?? 99 8F 08 00 42 24 ?? ?? ?? ?? 00 00 82 AC }
	condition:
		$1
}

rule file_51_1_3 {
	meta:
		name = "_ZNSt10bad_typeidD2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt10bad_typeid 0010 _ZNSt9exceptionD2Ev"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F ?? ?? 99 8F 08 00 42 24 ?? ?? ?? ?? 00 00 82 AC }
	condition:
		$1
}

rule file_100_14_3 {
	meta:
		name = "_ZNSt11range_errorD2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt11range_error 0010 _ZNSt13runtime_errorD2Ev"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F ?? ?? 99 8F 08 00 42 24 ?? ?? ?? ?? 00 00 82 AC }
	condition:
		$1
}

rule file_108_0_3 {
	meta:
		name = "_ZNSt11regex_errorD2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt11regex_error 0010 _ZNSt13runtime_errorD2Ev"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F ?? ?? 99 8F 08 00 42 24 ?? ?? ?? ?? 00 00 82 AC }
	condition:
		$1
}

rule file_80_1_3 {
	meta:
		name = "_ZNSt12bad_weak_ptrD2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt12bad_weak_ptr 0010 _ZNSt9exceptionD2Ev"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F ?? ?? 99 8F 08 00 42 24 ?? ?? ?? ?? 00 00 82 AC }
	condition:
		$1
}

rule file_48_4_3 {
	meta:
		name = "_ZNSt12ctype_bynameIcED2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt12ctype_bynameIcE 0010 _ZNSt5ctypeIcED2Ev"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F ?? ?? 99 8F 08 00 42 24 ?? ?? ?? ?? 00 00 82 AC }
	condition:
		$1
}

rule file_101_5_3 {
	meta:
		name = "_ZNSt12ctype_bynameIwED2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt12ctype_bynameIwE 0010 _ZNSt5ctypeIwED2Ev"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F ?? ?? 99 8F 08 00 42 24 ?? ?? ?? ?? 00 00 82 AC }
	condition:
		$1
}

rule file_100_4_3 {
	meta:
		name = "_ZNSt12domain_errorD2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt12domain_error 0010 _ZNSt11logic_errorD2Ev"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F ?? ?? 99 8F 08 00 42 24 ?? ?? ?? ?? 00 00 82 AC }
	condition:
		$1
}

rule file_125_4_3 {
	meta:
		name = "_ZNSt12future_errorD2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt12future_error 0010 _ZNSt11logic_errorD2Ev"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F ?? ?? 99 8F 08 00 42 24 ?? ?? ?? ?? 00 00 82 AC }
	condition:
		$1
}

rule file_100_8_3 {
	meta:
		name = "_ZNSt12length_errorD2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt12length_error 0010 _ZNSt11logic_errorD2Ev"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F ?? ?? 99 8F 08 00 42 24 ?? ?? ?? ?? 00 00 82 AC }
	condition:
		$1
}

rule file_100_10_3 {
	meta:
		name = "_ZNSt12out_of_rangeD2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt12out_of_range 0010 _ZNSt11logic_errorD2Ev"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F ?? ?? 99 8F 08 00 42 24 ?? ?? ?? ?? 00 00 82 AC }
	condition:
		$1
}

rule file_76_11_3 {
	meta:
		name = "_ZNSt12system_errorD2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt12system_error 0010 _ZNSt13runtime_errorD2Ev"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F ?? ?? 99 8F 08 00 42 24 ?? ?? ?? ?? 00 00 82 AC }
	condition:
		$1
}

rule file_33_1_3 {
	meta:
		name = "_ZNSt13bad_exceptionD2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt13bad_exception 0010 _ZNSt9exceptionD2Ev"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F ?? ?? 99 8F 08 00 42 24 ?? ?? ?? ?? 00 00 82 AC }
	condition:
		$1
}

rule file_57_68_3 {
	meta:
		name = "_ZNSt14codecvt_bynameIcc11__mbstate_tED2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt14codecvt_bynameIcc11__mbstate_tE 0010 _ZNSt7codecvtIcc11__mbstate_tED2Ev"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F ?? ?? 99 8F 08 00 42 24 ?? ?? ?? ?? 00 00 82 AC }
	condition:
		$1
}

rule file_20_68_3 {
	meta:
		name = "_ZNSt14codecvt_bynameIwc11__mbstate_tED2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt14codecvt_bynameIwc11__mbstate_tE 0010 _ZNSt7codecvtIwc11__mbstate_tED2Ev"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F ?? ?? 99 8F 08 00 42 24 ?? ?? ?? ?? 00 00 82 AC }
	condition:
		$1
}

rule file_100_16_3 {
	meta:
		name = "_ZNSt14overflow_errorD2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt14overflow_error 0010 _ZNSt13runtime_errorD2Ev"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F ?? ?? 99 8F 08 00 42 24 ?? ?? ?? ?? 00 00 82 AC }
	condition:
		$1
}

rule file_57_57_3 {
	meta:
		name = "_ZNSt15messages_bynameIcED2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt15messages_bynameIcE 0010 _ZNSt8messagesIcED2Ev"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F ?? ?? 99 8F 08 00 42 24 ?? ?? ?? ?? 00 00 82 AC }
	condition:
		$1
}

rule file_20_57_3 {
	meta:
		name = "_ZNSt15messages_bynameIwED2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt15messages_bynameIwE 0010 _ZNSt8messagesIwED2Ev"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F ?? ?? 99 8F 08 00 42 24 ?? ?? ?? ?? 00 00 82 AC }
	condition:
		$1
}

rule file_57_64_3 {
	meta:
		name = "_ZNSt15numpunct_bynameIcED2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt15numpunct_bynameIcE 0010 _ZNSt8numpunctIcED2Ev"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F ?? ?? 99 8F 08 00 42 24 ?? ?? ?? ?? 00 00 82 AC }
	condition:
		$1
}

rule file_20_64_3 {
	meta:
		name = "_ZNSt15numpunct_bynameIwED2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt15numpunct_bynameIwE 0010 _ZNSt8numpunctIwED2Ev"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F ?? ?? 99 8F 08 00 42 24 ?? ?? ?? ?? 00 00 82 AC }
	condition:
		$1
}

rule file_57_24_3 {
	meta:
		name = "_ZNSt15time_get_bynameIcSt19istreambuf_iteratorIcSt11char_traitsIcEEED2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt8time_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE 0010 _ZNSt6locale5facetD2Ev"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F ?? ?? 99 8F 08 00 42 24 ?? ?? ?? ?? 00 00 82 AC }
	condition:
		$1
}

rule file_20_24_3 {
	meta:
		name = "_ZNSt15time_get_bynameIwSt19istreambuf_iteratorIwSt11char_traitsIwEEED2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt8time_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE 0010 _ZNSt6locale5facetD2Ev"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F ?? ?? 99 8F 08 00 42 24 ?? ?? ?? ?? 00 00 82 AC }
	condition:
		$1
}

rule file_57_22_3 {
	meta:
		name = "_ZNSt15time_put_bynameIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEED2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt8time_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEE 0010 _ZNSt6locale5facetD2Ev"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F ?? ?? 99 8F 08 00 42 24 ?? ?? ?? ?? 00 00 82 AC }
	condition:
		$1
}

rule file_20_22_3 {
	meta:
		name = "_ZNSt15time_put_bynameIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEED2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt8time_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE 0010 _ZNSt6locale5facetD2Ev"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F ?? ?? 99 8F 08 00 42 24 ?? ?? ?? ?? 00 00 82 AC }
	condition:
		$1
}

rule file_100_18_3 {
	meta:
		name = "_ZNSt15underflow_errorD2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt15underflow_error 0010 _ZNSt13runtime_errorD2Ev"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F ?? ?? 99 8F 08 00 42 24 ?? ?? ?? ?? 00 00 82 AC }
	condition:
		$1
}

rule file_100_6_3 {
	meta:
		name = "_ZNSt16invalid_argumentD2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt16invalid_argument 0010 _ZNSt11logic_errorD2Ev"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F ?? ?? 99 8F 08 00 42 24 ?? ?? ?? ?? 00 00 82 AC }
	condition:
		$1
}

rule file_57_20_3 {
	meta:
		name = "_ZNSt17__timepunct_cacheIcED2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt17__timepunct_cacheIcE 0010 _ZNSt6locale5facetD2Ev"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F ?? ?? 99 8F 08 00 42 24 ?? ?? ?? ?? 00 00 82 AC }
	condition:
		$1
}

rule file_20_20_3 {
	meta:
		name = "_ZNSt17__timepunct_cacheIwED2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt17__timepunct_cacheIwE 0010 _ZNSt6locale5facetD2Ev"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F ?? ?? 99 8F 08 00 42 24 ?? ?? ?? ?? 00 00 82 AC }
	condition:
		$1
}

rule file_68_1_3 {
	meta:
		name = "_ZNSt17bad_function_callD2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt17bad_function_call 0010 _ZNSt9exceptionD2Ev"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F ?? ?? 99 8F 08 00 42 24 ?? ?? ?? ?? 00 00 82 AC }
	condition:
		$1
}

rule file_57_60_3 {
	meta:
		name = "_ZNSt17moneypunct_bynameIcLb0EED2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt17moneypunct_bynameIcLb0EE 0010 _ZNSt10moneypunctIcLb0EED2Ev"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F ?? ?? 99 8F 08 00 42 24 ?? ?? ?? ?? 00 00 82 AC }
	condition:
		$1
}

rule file_57_62_3 {
	meta:
		name = "_ZNSt17moneypunct_bynameIcLb1EED2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt17moneypunct_bynameIcLb1EE 0010 _ZNSt10moneypunctIcLb1EED2Ev"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F ?? ?? 99 8F 08 00 42 24 ?? ?? ?? ?? 00 00 82 AC }
	condition:
		$1
}

rule file_20_60_3 {
	meta:
		name = "_ZNSt17moneypunct_bynameIwLb0EED2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt17moneypunct_bynameIwLb0EE 0010 _ZNSt10moneypunctIwLb0EED2Ev"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F ?? ?? 99 8F 08 00 42 24 ?? ?? ?? ?? 00 00 82 AC }
	condition:
		$1
}

rule file_20_62_3 {
	meta:
		name = "_ZNSt17moneypunct_bynameIwLb1EED2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt17moneypunct_bynameIwLb1EE 0010 _ZNSt10moneypunctIwLb1EED2Ev"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F ?? ?? 99 8F 08 00 42 24 ?? ?? ?? ?? 00 00 82 AC }
	condition:
		$1
}

rule file_57_25_3 {
	meta:
		name = "_ZNSt21__ctype_abstract_baseIcED2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt21__ctype_abstract_baseIcE 0010 _ZNSt6locale5facetD2Ev"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F ?? ?? 99 8F 08 00 42 24 ?? ?? ?? ?? 00 00 82 AC }
	condition:
		$1
}

rule file_20_26_3 {
	meta:
		name = "_ZNSt21__ctype_abstract_baseIwED2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt21__ctype_abstract_baseIwE 0010 _ZNSt6locale5facetD2Ev"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F ?? ?? 99 8F 08 00 42 24 ?? ?? ?? ?? 00 00 82 AC }
	condition:
		$1
}

rule file_57_26_3 {
	meta:
		name = "_ZNSt23__codecvt_abstract_baseIcc11__mbstate_tED2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt23__codecvt_abstract_baseIcc11__mbstate_tE 0010 _ZNSt6locale5facetD2Ev"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F ?? ?? 99 8F 08 00 42 24 ?? ?? ?? ?? 00 00 82 AC }
	condition:
		$1
}

rule file_20_25_3 {
	meta:
		name = "_ZNSt23__codecvt_abstract_baseIwc11__mbstate_tED2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt23__codecvt_abstract_baseIwc11__mbstate_tE 0010 _ZNSt6locale5facetD2Ev"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F ?? ?? 99 8F 08 00 42 24 ?? ?? ?? ?? 00 00 82 AC }
	condition:
		$1
}

rule file_57_18_3 {
	meta:
		name = "_ZNSt7num_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEED2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt7num_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE 0010 _ZNSt6locale5facetD2Ev"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F ?? ?? 99 8F 08 00 42 24 ?? ?? ?? ?? 00 00 82 AC }
	condition:
		$1
}

rule file_20_18_3 {
	meta:
		name = "_ZNSt7num_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEED2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt7num_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE 0010 _ZNSt6locale5facetD2Ev"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F ?? ?? 99 8F 08 00 42 24 ?? ?? ?? ?? 00 00 82 AC }
	condition:
		$1
}

rule file_57_19_3 {
	meta:
		name = "_ZNSt7num_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEED2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt7num_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEE 0010 _ZNSt6locale5facetD2Ev"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F ?? ?? 99 8F 08 00 42 24 ?? ?? ?? ?? 00 00 82 AC }
	condition:
		$1
}

rule file_20_19_3 {
	meta:
		name = "_ZNSt7num_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEED2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt7num_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE 0010 _ZNSt6locale5facetD2Ev"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F ?? ?? 99 8F 08 00 42 24 ?? ?? ?? ?? 00 00 82 AC }
	condition:
		$1
}

rule file_14_1_3 {
	meta:
		name = "_ZNSt8bad_castD2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt8bad_cast 0010 _ZNSt9exceptionD2Ev"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F ?? ?? 99 8F 08 00 42 24 ?? ?? ?? ?? 00 00 82 AC }
	condition:
		$1
}

rule file_57_23_3 {
	meta:
		name = "_ZNSt8time_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEED2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt8time_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE 0010 _ZNSt6locale5facetD2Ev"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F ?? ?? 99 8F 08 00 42 24 ?? ?? ?? ?? 00 00 82 AC }
	condition:
		$1
}

rule file_20_23_3 {
	meta:
		name = "_ZNSt8time_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEED2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt8time_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE 0010 _ZNSt6locale5facetD2Ev"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F ?? ?? 99 8F 08 00 42 24 ?? ?? ?? ?? 00 00 82 AC }
	condition:
		$1
}

rule file_57_21_3 {
	meta:
		name = "_ZNSt8time_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEED2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt8time_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEE 0010 _ZNSt6locale5facetD2Ev"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F ?? ?? 99 8F 08 00 42 24 ?? ?? ?? ?? 00 00 82 AC }
	condition:
		$1
}

rule file_20_21_3 {
	meta:
		name = "_ZNSt8time_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEED2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt8time_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE 0010 _ZNSt6locale5facetD2Ev"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F ?? ?? 99 8F 08 00 42 24 ?? ?? ?? ?? 00 00 82 AC }
	condition:
		$1
}

rule file_78_1_3 {
	meta:
		name = "_ZNSt9bad_allocD2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt9bad_alloc 0010 _ZNSt9exceptionD2Ev"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F ?? ?? 99 8F 08 00 42 24 ?? ?? ?? ?? 00 00 82 AC }
	condition:
		$1
}

rule file_25_0_3 {
	meta:
		name = "_ZNSt9basic_iosIcSt11char_traitsIcEED2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt9basic_iosIcSt11char_traitsIcEE 0010 _ZNSt8ios_baseD2Ev"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F ?? ?? 99 8F 08 00 42 24 ?? ?? ?? ?? 00 00 82 AC }
	condition:
		$1
}

rule file_25_1_3 {
	meta:
		name = "_ZNSt9basic_iosIwSt11char_traitsIwEED2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt9basic_iosIwSt11char_traitsIwEE 0010 _ZNSt8ios_baseD2Ev"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F ?? ?? 99 8F 08 00 42 24 ?? ?? ?? ?? 00 00 82 AC }
	condition:
		$1
}

rule file_57_16_3 {
	meta:
		name = "_ZNSt9money_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEED2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt9money_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE 0010 _ZNSt6locale5facetD2Ev"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F ?? ?? 99 8F 08 00 42 24 ?? ?? ?? ?? 00 00 82 AC }
	condition:
		$1
}

rule file_20_16_3 {
	meta:
		name = "_ZNSt9money_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEED2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt9money_getIwSt19istreambuf_iteratorIwSt11char_traitsIwEEE 0010 _ZNSt6locale5facetD2Ev"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F ?? ?? 99 8F 08 00 42 24 ?? ?? ?? ?? 00 00 82 AC }
	condition:
		$1
}

rule file_57_17_3 {
	meta:
		name = "_ZNSt9money_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEED2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt9money_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEE 0010 _ZNSt6locale5facetD2Ev"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F ?? ?? 99 8F 08 00 42 24 ?? ?? ?? ?? 00 00 82 AC }
	condition:
		$1
}

rule file_20_17_3 {
	meta:
		name = "_ZNSt9money_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEED2Ev"
		size = 32
		refs = "0000 _gp_disp 000c _ZTVSt9money_putIwSt19ostreambuf_iteratorIwSt11char_traitsIwEEE 0010 _ZNSt6locale5facetD2Ev"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F ?? ?? 99 8F 08 00 42 24 ?? ?? ?? ?? 00 00 82 AC }
	condition:
		$1
}

rule file_164_0_0 {
	meta:
		name = "__GI_poll"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 5C 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_165_0_0 {
	meta:
		name = "__libc_fork"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF A2 0F 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_166_0_0 {
	meta:
		name = "__getdents"
		size = 232
		refs = "0000 _gp_disp 0044 __GI___errno_location 0064 __GI_strlen 0068 __GI_memmove"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 C8 FF BD 27 10 00 BC AF 34 00 BF AF 30 00 B6 AF 2C 00 B5 AF 28 00 B4 AF 24 00 B3 AF 20 00 B2 AF 1C 00 B1 AF 18 00 B0 AF 2D 10 02 24 0C 00 00 00 07 00 E0 10 21 88 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 51 AC 19 00 00 10 FF FF 11 24 FF FF 02 24 16 00 22 12 ?? ?? 94 8F ?? ?? 93 8F 21 80 A0 00 21 A8 B1 00 2B 10 15 02 10 00 40 10 0A 00 12 26 08 00 02 96 21 20 40 02 21 10 02 02 21 C8 80 02 ?? ?? ?? ?? FF FF 56 80 01 00 46 24 0B 00 04 26 21 C8 60 02 ?? ?? ?? ?? 21 28 40 02 08 00 02 96 0A 00 16 A2 EF FF 00 10 21 80 02 02 34 00 BF 8F 21 10 20 02 30 00 B6 8F 2C 00 B5 8F 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_167_0_0 {
	meta:
		name = "__GI_posix_openpt"
		size = 32
		refs = "0000 _gp_disp 0014 __GI_open 0010 $LC0"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 21 28 80 00 ?? ?? 84 8F ?? ?? 99 8F ?? ?? ?? ?? ?? ?? 84 24 }
	condition:
		$1
}

rule file_168_0_0 {
	meta:
		name = "__GI_sigwaitinfo"
		size = 92
		refs = "0000 _gp_disp 0034 __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 21 30 00 00 10 00 07 24 65 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_168_1_0 {
	meta:
		name = "__GI_sigtimedwait"
		size = 88
		refs = "0000 _gp_disp 0030 __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 10 00 07 24 65 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_169_0_0 {
	meta:
		name = "__GI_setregid"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF E7 0F 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_170_0_0 {
	meta:
		name = "__GI_xdr_pmaplist"
		size = 248
		refs = "0000 _gp_disp 0038 __GI_xdr_bool 003c __GI_xdr_reference 008c __GI_xdr_pmap"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 C0 FF BD 27 38 00 B6 AF 34 00 B5 AF 30 00 B4 AF 28 00 B2 AF 24 00 B1 AF 20 00 B0 AF 10 00 BC AF 3C 00 BF AF 2C 00 B3 AF 00 00 93 8C ?? ?? 95 8F ?? ?? 96 8F 02 00 73 3A 21 88 80 00 21 80 A0 00 01 00 73 2E 21 90 00 00 18 00 B4 27 00 00 02 8E 21 20 20 02 21 28 80 02 2B 10 02 00 21 C8 A0 02 ?? ?? ?? ?? 18 00 A2 AF 15 00 40 10 10 00 BC 8F 18 00 A2 8F 13 00 40 10 01 00 02 24 03 00 60 12 ?? ?? 87 8F 00 00 12 8E 10 00 52 26 21 20 20 02 21 28 00 02 21 C8 C0 02 ?? ?? ?? ?? 14 00 06 24 08 00 40 10 21 10 00 00 03 00 60 52 00 00 10 8E E6 FF 00 10 21 80 40 02 E4 FF 00 10 10 00 10 26 21 10 00 00 3C 00 BF 8F 38 00 B6 8F 34 00 B5 8F 30 00 B4 8F 2C 00 B3 8F 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 08 00 E0 03 40 00 BD 27 }
	condition:
		$1
}

rule file_171_0_0 {
	meta:
		name = "__GI_vasprintf"
		size = 212
		refs = "0000 _gp_disp 0014 __GI_vsnprintf 0064 malloc 00a0 free"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D0 FF BD 27 20 00 B2 AF ?? ?? 92 8F 28 00 B4 AF 24 00 B3 AF 21 A0 A0 00 21 98 C0 00 10 00 BC AF 1C 00 B1 AF 18 00 B0 AF 21 88 80 00 2C 00 BF AF 21 20 00 00 21 28 00 00 21 30 80 02 21 C8 40 02 ?? ?? ?? ?? 21 38 60 02 21 80 40 00 10 00 BC 8F 14 00 40 04 00 00 20 AE ?? ?? 99 8F 01 00 50 24 ?? ?? ?? ?? 21 20 00 02 0E 00 40 10 00 00 22 AE 21 28 00 02 21 20 40 00 21 30 80 02 21 C8 40 02 ?? ?? ?? ?? 21 38 60 02 21 80 40 00 05 00 41 04 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 24 8E 00 00 20 AE 2C 00 BF 8F 21 10 00 02 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_172_0_0 {
	meta:
		name = "__GI_fgets"
		size = 192
		refs = "0000 _gp_disp 0040 _pthread_cleanup_push_defer 0044 __pthread_mutex_unlock 005c __pthread_mutex_lock 006c __GI_fgets_unlocked 0088 _pthread_cleanup_pop_restore"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 B8 FF BD 27 40 00 B4 AF 3C 00 B3 AF 30 00 B0 AF 10 00 BC AF 44 00 BF AF 38 00 B2 AF 34 00 B1 AF 34 00 D1 8C 21 A0 80 00 21 98 A0 00 0C 00 20 16 21 80 C0 00 ?? ?? 99 8F ?? ?? 85 8F 38 00 D2 24 18 00 A4 27 ?? ?? ?? ?? 21 30 40 02 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 40 02 10 00 BC 8F ?? ?? 99 8F 21 20 80 02 21 28 60 02 ?? ?? ?? ?? 21 30 00 02 07 00 20 16 10 00 BC 8F ?? ?? 99 8F 28 00 A2 AF 18 00 A4 27 ?? ?? ?? ?? 01 00 05 24 28 00 A2 8F 44 00 BF 8F 40 00 B4 8F 3C 00 B3 8F 38 00 B2 8F 34 00 B1 8F 30 00 B0 8F 08 00 E0 03 48 00 BD 27 }
	condition:
		$1
}

rule file_453_0_0 {
	meta:
		name = "fgetws"
		size = 192
		refs = "0000 _gp_disp 0040 _pthread_cleanup_push_defer 0044 __pthread_mutex_unlock 005c __pthread_mutex_lock 006c __GI_fgetws_unlocked 0088 _pthread_cleanup_pop_restore"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 B8 FF BD 27 40 00 B4 AF 3C 00 B3 AF 30 00 B0 AF 10 00 BC AF 44 00 BF AF 38 00 B2 AF 34 00 B1 AF 34 00 D1 8C 21 A0 80 00 21 98 A0 00 0C 00 20 16 21 80 C0 00 ?? ?? 99 8F ?? ?? 85 8F 38 00 D2 24 18 00 A4 27 ?? ?? ?? ?? 21 30 40 02 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 40 02 10 00 BC 8F ?? ?? 99 8F 21 20 80 02 21 28 60 02 ?? ?? ?? ?? 21 30 00 02 07 00 20 16 10 00 BC 8F ?? ?? 99 8F 28 00 A2 AF 18 00 A4 27 ?? ?? ?? ?? 01 00 05 24 28 00 A2 8F 44 00 BF 8F 40 00 B4 8F 3C 00 B3 8F 38 00 B2 8F 34 00 B1 8F 30 00 B0 8F 08 00 E0 03 48 00 BD 27 }
	condition:
		$1
}

rule file_173_0_0 {
	meta:
		name = "__GI_mallinfo"
		size = 460
		refs = "0000 _gp_disp 0010 _pthread_cleanup_push_defer 0014 __pthread_mutex_unlock 0018 __malloc_lock 0060 __pthread_mutex_lock 0070 __malloc_state 0080 __malloc_consolidate 013c _pthread_cleanup_pop_restore"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 A8 FF BD 27 ?? ?? 99 8F ?? ?? 85 8F ?? ?? 86 8F 40 00 B4 AF 18 00 B4 27 10 00 BC AF 54 00 BF AF 34 00 B1 AF 30 00 B0 AF 50 00 BE AF 4C 00 B7 AF 48 00 B6 AF 44 00 B5 AF 3C 00 B3 AF 38 00 B2 AF 21 80 80 00 ?? ?? ?? ?? 21 20 80 02 10 00 BC 8F ?? ?? 84 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F ?? ?? 91 8F 2C 00 22 8E 07 00 40 14 FC FF 12 24 ?? ?? 99 8F ?? ?? ?? ?? 21 20 20 02 10 00 BC 8F 2C 00 22 8E FC FF 12 24 21 A8 00 00 04 00 57 8C 21 98 00 00 21 10 00 00 24 90 F2 02 FC FF 05 24 0A 00 04 24 80 18 02 00 21 18 23 02 04 00 63 8C 07 00 60 50 01 00 42 24 04 00 66 8C 01 00 B5 26 08 00 63 8C 24 30 A6 00 F9 FF 00 10 21 98 66 02 F5 FF 44 14 80 18 02 00 21 90 72 02 01 00 16 24 01 00 02 24 FC FF 06 24 60 00 05 24 C0 20 02 00 21 20 24 02 2C 00 84 24 0C 00 83 8C 07 00 64 50 01 00 42 24 04 00 67 8C 01 00 D6 26 0C 00 63 8C 24 38 C7 00 F9 FF 00 10 21 90 47 02 F4 FF 45 14 C0 20 02 00 50 03 23 8E 64 03 22 8E ?? ?? 99 8F 68 03 3E 8E 21 20 80 02 74 03 31 8E 01 00 05 24 2C 00 A2 AF ?? ?? ?? ?? 28 00 A3 AF 2C 00 A2 8F 28 00 A3 8F 54 00 BF 8F 10 00 02 AE FC FF 02 24 00 00 1E AE 24 B8 E2 02 23 F0 D2 03 04 00 16 AE 08 00 15 AE 14 00 11 AE 18 00 13 AE 1C 00 1E AE 20 00 12 AE 24 00 17 AE 21 10 00 02 50 00 BE 8F 4C 00 B7 8F 48 00 B6 8F 44 00 B5 8F 40 00 B4 8F 3C 00 B3 8F 38 00 B2 8F 34 00 B1 8F 0C 00 03 AE 30 00 B0 8F 08 00 E0 03 58 00 BD 27 }
	condition:
		$1
}

rule file_173_1_0 {
	meta:
		name = "malloc_stats"
		size = 160
		refs = "0000 _gp_disp 0024 stderr 002c __GI_mallinfo 0060 __GI_fprintf 005c $LC0"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 98 FF BD 27 30 00 BC AF 60 00 B0 AF 64 00 BF AF 03 00 80 14 21 80 80 00 ?? ?? 82 8F 00 00 50 8C ?? ?? 99 8F ?? ?? ?? ?? 38 00 A4 27 44 00 A3 8F 30 00 BC 8F 48 00 A2 8F 14 00 A3 AF 4C 00 A3 8F 38 00 A6 8F 54 00 A7 8F 20 00 A3 AF 58 00 A3 8F ?? ?? 85 8F ?? ?? 99 8F 24 00 A3 AF 5C 00 A3 8F 10 00 A6 AF 1C 00 A7 AF 28 00 A3 AF 21 20 00 02 18 00 A2 AF ?? ?? A5 24 21 30 C2 00 ?? ?? ?? ?? 21 38 E2 00 64 00 BF 8F 60 00 B0 8F 08 00 E0 03 68 00 BD 27 }
	condition:
		$1
}

rule file_174_0_0 {
	meta:
		name = "__GI_fchdir"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 25 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_175_0_0 {
	meta:
		name = "fwide"
		size = 212
		refs = "0000 _gp_disp 0038 _pthread_cleanup_push_defer 003c __pthread_mutex_unlock 0054 __pthread_mutex_lock 00a4 _pthread_cleanup_pop_restore"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 C0 FF BD 27 34 00 B2 AF 2C 00 B0 AF 10 00 BC AF 3C 00 BF AF 38 00 B3 AF 30 00 B1 AF 34 00 91 8C 21 80 80 00 0C 00 20 16 21 90 A0 00 ?? ?? 99 8F ?? ?? 85 8F 38 00 93 24 21 30 60 02 ?? ?? ?? ?? 18 00 A4 27 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 60 02 10 00 BC 8F 0B 00 40 12 00 00 03 96 80 08 62 30 09 00 40 54 00 08 70 30 00 08 02 24 01 00 52 2A 80 00 04 24 0B 10 92 00 25 10 43 00 00 00 02 A6 00 00 03 96 00 08 70 30 80 00 63 30 05 00 20 16 23 80 03 02 ?? ?? 99 8F 18 00 A4 27 ?? ?? ?? ?? 01 00 05 24 3C 00 BF 8F 21 10 00 02 38 00 B3 8F 34 00 B2 8F 30 00 B1 8F 2C 00 B0 8F 08 00 E0 03 40 00 BD 27 }
	condition:
		$1
}

rule file_176_0_0 {
	meta:
		name = "sethostid"
		size = 220
		refs = "0000 _gp_disp 000c __GI_geteuid 0038 __GI___errno_location 0050 __GI_getuid 0068 __GI_open 0064 $LC0 0088 __GI_write 00a8 __GI_close"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F D8 FF BD 27 10 00 BC AF 24 00 BF AF 20 00 B1 AF 1C 00 B0 AF 28 00 A4 AF ?? ?? ?? ?? 00 00 00 00 07 00 40 10 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 01 00 11 24 01 00 03 24 1E 00 00 10 00 00 43 AC ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 F6 FF 40 14 10 00 BC 8F ?? ?? 84 8F ?? ?? 99 8F 01 01 05 24 ?? ?? 84 24 ?? ?? ?? ?? A4 01 06 24 21 80 40 00 0F 00 40 04 10 00 BC 8F ?? ?? 99 8F 21 20 40 00 28 00 A5 27 ?? ?? ?? ?? 04 00 06 24 10 00 BC 8F 04 00 42 38 2B 88 02 00 ?? ?? 99 8F 21 20 00 02 ?? ?? ?? ?? 23 88 11 00 03 00 00 10 24 00 BF 8F 21 88 40 00 24 00 BF 8F 21 10 20 02 1C 00 B0 8F 20 00 B1 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_177_0_0 {
	meta:
		name = "__GI_execle"
		size = 188
		refs = "0000 _gp_disp 009c __GI_execve"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D8 FF BD 27 20 00 BE AF 21 F0 A0 03 34 00 C7 AF 30 00 C7 27 24 00 BF AF 10 00 BC AF 30 00 C6 AF 18 00 C7 AF 21 18 00 00 18 00 C6 8F 04 00 C8 24 18 00 C8 AF 00 00 C8 8C 03 00 00 11 01 00 62 24 F9 FF 00 10 21 18 40 00 80 18 03 00 16 00 63 24 C2 18 03 00 C0 18 03 00 23 E8 A3 03 10 00 A3 27 04 00 C6 8C 18 00 C7 AF 00 00 65 AC 21 28 60 00 18 00 C7 8F 04 00 A5 24 FF FF 42 24 04 00 E8 24 00 00 E7 8C 18 00 C8 AF F9 FF 40 14 00 00 A7 AC ?? ?? 99 8F ?? ?? ?? ?? 21 28 60 00 21 E8 C0 03 24 00 BF 8F 20 00 BE 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_178_0_0 {
	meta:
		name = "__encode_header"
		size = 212
	strings:
		$1 = { 0C 00 C6 28 31 00 C0 14 80 FF 06 24 01 00 82 90 04 00 03 24 00 00 A2 A0 00 00 82 8C 01 00 A2 A0 04 00 88 8C 21 10 C0 00 10 00 87 8C 0A 10 08 00 21 40 40 00 0C 00 82 8C 08 00 89 8C 0A 18 02 00 02 00 02 24 0A 10 07 00 14 00 87 8C 0F 00 29 31 C0 48 09 00 2B 38 07 00 25 38 27 01 25 38 07 01 25 18 67 00 25 10 43 00 02 00 A2 A0 18 00 82 8C 0A 30 02 00 1C 00 82 8C 0F 00 42 30 25 30 C2 00 03 00 A6 A0 21 00 82 90 04 00 A2 A0 20 00 82 8C 05 00 A2 A0 25 00 82 90 06 00 A2 A0 24 00 82 8C 07 00 A2 A0 29 00 82 90 08 00 A2 A0 28 00 82 8C 09 00 A2 A0 2D 00 82 90 0A 00 A2 A0 2C 00 82 8C 0B 00 A2 A0 08 00 E0 03 0C 00 02 24 08 00 E0 03 FF FF 02 24 }
	condition:
		$1
}

rule file_179_0_0 {
	meta:
		name = "posix_fadvise64"
		size = 76
	strings:
		$1 = { F8 FF BD 27 21 28 00 00 04 00 B1 AF 00 00 B0 AF 1C 00 A2 8F 18 00 B0 8F 20 00 B1 8F E0 FF BD 27 10 00 B0 AF 14 00 A2 AF 18 00 B1 AF 9E 10 02 24 0C 00 00 00 20 00 BD 27 04 00 B1 8F 00 00 B0 8F 0A 10 07 00 08 00 E0 03 08 00 BD 27 }
	condition:
		$1
}

rule file_180_0_0 {
	meta:
		name = "klogctl"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 07 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_181_0_0 {
	meta:
		name = "__GI___sigismember"
		size = 40
	strings:
		$1 = { FF FF A5 24 42 11 05 00 80 10 02 00 21 20 82 00 00 00 83 8C 01 00 02 24 04 28 A2 00 24 10 A3 00 08 00 E0 03 2B 10 02 00 }
	condition:
		$1
}

rule file_181_1_0 {
	meta:
		name = "__GI___sigaddset"
		size = 44
	strings:
		$1 = { FF FF A5 24 42 11 05 00 80 10 02 00 21 20 82 00 01 00 02 24 04 28 A2 00 00 00 82 8C 25 28 45 00 00 00 85 AC 08 00 E0 03 21 10 00 00 }
	condition:
		$1
}

rule file_181_2_0 {
	meta:
		name = "__GI___sigdelset"
		size = 48
	strings:
		$1 = { FF FF A5 24 42 11 05 00 80 10 02 00 21 20 82 00 01 00 02 24 04 28 A2 00 00 00 82 8C 27 28 05 00 24 28 A2 00 00 00 85 AC 08 00 E0 03 21 10 00 00 }
	condition:
		$1
}

rule file_182_0_0 {
	meta:
		name = "mkfifo"
		size = 32
		refs = "0000 _gp_disp 000c __GI_mknod"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F 00 10 A5 34 21 30 00 00 ?? ?? ?? ?? 21 38 00 00 }
	condition:
		$1
}

rule file_183_0_0 {
	meta:
		name = "__GI_recv"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 4F 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_184_0_0 {
	meta:
		name = "_time_mktime"
		size = 180
		refs = "0000 _gp_disp 0010 _time_tzlock 0014 _pthread_cleanup_push_defer 0020 __pthread_mutex_unlock 004c __pthread_mutex_lock 005c __GI_tzset 0070 _time_tzinfo 0074 _time_mktime_tzi 008c _pthread_cleanup_pop_restore"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 C0 FF BD 27 ?? ?? 86 8F ?? ?? 99 8F 34 00 B1 AF 21 88 A0 00 ?? ?? 85 8F 30 00 B0 AF 18 00 B0 27 3C 00 BF AF 38 00 B2 AF 10 00 BC AF 21 90 80 00 ?? ?? ?? ?? 21 20 00 02 10 00 BC 8F ?? ?? 84 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F 21 20 40 02 ?? ?? 86 8F ?? ?? 99 8F ?? ?? ?? ?? 21 28 20 02 10 00 BC 8F 21 20 00 02 28 00 A2 AF ?? ?? 99 8F ?? ?? ?? ?? 01 00 05 24 3C 00 BF 8F 28 00 A2 8F 38 00 B2 8F 34 00 B1 8F 30 00 B0 8F 08 00 E0 03 40 00 BD 27 }
	condition:
		$1
}

rule file_185_0_0 {
	meta:
		name = "pivot_root"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 78 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_186_0_0 {
	meta:
		name = "__GI_time"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF AD 0F 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_187_0_0 {
	meta:
		name = "__setutent"
		size = 272
		refs = "0000 _gp_disp 003c __GI_open 005c __GI_fcntl 00b4 __GI_close 00f8 __GI_lseek"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D8 FF BD 27 18 00 B0 AF ?? ?? 90 8F 10 00 BC AF FF FF 02 24 ?? ?? 03 8E 24 00 BF AF 20 00 B2 AF 1C 00 B1 AF 2E 00 62 14 24 00 BF 8F ?? ?? 92 8F ?? ?? 91 8F 02 00 05 24 21 C8 20 02 ?? ?? ?? ?? ?? ?? 44 8E ?? ?? 02 AE 0B 00 40 04 10 00 BC 8F ?? ?? 91 8F ?? ?? 04 8E 01 00 05 24 21 C8 20 02 ?? ?? ?? ?? 21 30 00 00 14 00 41 04 10 00 BC 8F 09 00 00 10 FF FF 02 24 ?? ?? 44 8E 21 C8 20 02 ?? ?? ?? ?? 21 28 00 00 ?? ?? 02 AE F0 FF 41 04 10 00 BC 8F FF FF 02 24 24 00 BF 8F 20 00 B2 8F 1C 00 B1 8F ?? ?? 02 AE ?? ?? 99 8F 18 00 B0 8F FF FF 04 24 ?? ?? ?? ?? 28 00 BD 27 ?? ?? 83 8F 02 00 05 24 01 00 46 34 21 C8 20 02 ?? ?? ?? ?? ?? ?? 64 8C EF FF 40 04 10 00 BC 8F 24 00 BF 8F 20 00 B2 8F 1C 00 B1 8F ?? ?? 04 8E ?? ?? 99 8F 18 00 B0 8F 21 28 00 00 21 30 00 00 ?? ?? ?? ?? 28 00 BD 27 }
	condition:
		$1
}

rule file_187_1_0 {
	meta:
		name = "__getutent"
		size = 112
		refs = "0000 _gp_disp 0030 __setutent 0040 __GI_read"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 FF FF 02 24 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 07 00 82 14 ?? ?? 90 8F ?? ?? 99 8F ?? ?? 39 27 ?? ?? ?? ?? 00 00 00 00 09 00 00 10 21 10 00 00 ?? ?? 99 8F 80 01 06 24 ?? ?? ?? ?? ?? ?? 05 26 80 01 42 38 ?? ?? 10 26 0B 80 02 00 21 10 00 02 1C 00 BF 8F 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_187_2_0 {
	meta:
		name = "__getutid"
		size = 244
		refs = "0000 _gp_disp 0024 __GI_strncmp 0050 __getutent"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 C8 FF BD 27 2C 00 B5 AF 24 00 B3 AF 20 00 B2 AF ?? ?? 93 8F ?? ?? 92 8F ?? ?? 95 8F 30 00 B6 AF 28 00 B4 AF 1C 00 B1 AF 10 00 BC AF 34 00 BF AF 18 00 B0 AF 21 88 80 00 28 00 94 24 05 00 16 24 ?? ?? 59 26 ?? ?? ?? ?? ?? ?? 64 8E 1B 00 40 10 21 80 40 00 00 00 22 86 FF FF 43 30 FF FF 64 24 04 00 84 2C 06 00 80 10 00 00 00 00 00 00 04 86 06 00 82 54 FA FF 63 24 11 00 00 10 21 10 00 02 06 00 56 10 28 00 04 26 FA FF 63 24 03 00 63 2C EC FF 60 10 ?? ?? 59 26 28 00 04 26 21 28 80 02 21 C8 A0 02 ?? ?? ?? ?? 04 00 06 24 E5 FF 40 14 ?? ?? 59 26 02 00 00 10 21 10 00 02 21 10 00 00 34 00 BF 8F 30 00 B6 8F 2C 00 B5 8F 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_187_3_0 {
	meta:
		name = "__GI_setutent"
		size = 136
		refs = "0000 _gp_disp 0018 __pthread_mutex_unlock 001c _pthread_cleanup_push_defer 0040 __pthread_mutex_lock 0058 __setutent 0068 _pthread_cleanup_pop_restore"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 C8 FF BD 27 30 00 B1 AF ?? ?? 91 8F ?? ?? 85 8F ?? ?? 99 8F 2C 00 B0 AF 18 00 B0 27 34 00 BF AF ?? ?? 26 26 10 00 BC AF ?? ?? ?? ?? 21 20 00 02 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? ?? ?? 24 26 10 00 BC 8F ?? ?? 99 8F ?? ?? 39 27 ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F 21 20 00 02 ?? ?? 99 8F ?? ?? ?? ?? 01 00 05 24 34 00 BF 8F 30 00 B1 8F 2C 00 B0 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_187_4_0 {
	meta:
		name = "endutent"
		size = 160
		refs = "0000 _gp_disp 0018 _pthread_cleanup_push_defer 001c __pthread_mutex_unlock 0040 __pthread_mutex_lock 0064 __GI_close 0074 _pthread_cleanup_pop_restore"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 C8 FF BD 27 30 00 B1 AF ?? ?? 91 8F ?? ?? 99 8F ?? ?? 85 8F 2C 00 B0 AF 18 00 B0 27 10 00 BC AF ?? ?? 26 26 34 00 BF AF ?? ?? ?? ?? 21 20 00 02 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? ?? ?? 24 26 10 00 BC 8F ?? ?? 82 8F ?? ?? 44 8C 21 88 40 00 FF FF 02 24 04 00 82 10 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F ?? ?? 99 8F FF FF 02 24 ?? ?? 22 AE 21 20 00 02 ?? ?? ?? ?? 01 00 05 24 34 00 BF 8F 30 00 B1 8F 2C 00 B0 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_187_5_0 {
	meta:
		name = "getutent"
		size = 148
		refs = "0000 _gp_disp 0018 __pthread_mutex_unlock 001c _pthread_cleanup_push_defer 0040 __pthread_mutex_lock 005c __getutent 0070 _pthread_cleanup_pop_restore"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 C0 FF BD 27 38 00 B1 AF ?? ?? 91 8F ?? ?? 85 8F ?? ?? 99 8F 34 00 B0 AF 18 00 B0 27 3C 00 BF AF ?? ?? 26 26 10 00 BC AF ?? ?? ?? ?? 21 20 00 02 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? ?? ?? 24 26 10 00 BC 8F ?? ?? 82 8F ?? ?? 99 8F ?? ?? 39 27 ?? ?? ?? ?? ?? ?? 44 8C 10 00 BC 8F 21 20 00 02 28 00 A2 AF ?? ?? 99 8F ?? ?? ?? ?? 01 00 05 24 3C 00 BF 8F 28 00 A2 8F 38 00 B1 8F 34 00 B0 8F 08 00 E0 03 40 00 BD 27 }
	condition:
		$1
}

rule file_187_6_0 {
	meta:
		name = "__GI_getutid"
		size = 156
		refs = "0000 _gp_disp 0018 __pthread_mutex_unlock 001c _pthread_cleanup_push_defer 0048 __pthread_mutex_lock 0060 __getutid 0074 _pthread_cleanup_pop_restore"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 C0 FF BD 27 34 00 B1 AF ?? ?? 91 8F ?? ?? 85 8F ?? ?? 99 8F 30 00 B0 AF 18 00 B0 27 3C 00 BF AF ?? ?? 26 26 38 00 B2 AF 10 00 BC AF 21 90 80 00 ?? ?? ?? ?? 21 20 00 02 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? ?? ?? 24 26 10 00 BC 8F ?? ?? 99 8F ?? ?? 39 27 ?? ?? ?? ?? 21 20 40 02 10 00 BC 8F 21 20 00 02 28 00 A2 AF ?? ?? 99 8F ?? ?? ?? ?? 01 00 05 24 3C 00 BF 8F 28 00 A2 8F 38 00 B2 8F 34 00 B1 8F 30 00 B0 8F 08 00 E0 03 40 00 BD 27 }
	condition:
		$1
}

rule file_187_7_0 {
	meta:
		name = "getutline"
		size = 244
		refs = "0000 _gp_disp 0018 _pthread_cleanup_push_defer 001c __pthread_mutex_unlock 0058 __pthread_mutex_lock 0070 __GI_strcmp 0078 __getutent 00bc _pthread_cleanup_pop_restore"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 B8 FF BD 27 2C 00 B0 AF ?? ?? 90 8F ?? ?? 99 8F ?? ?? 85 8F 30 00 B1 AF 18 00 B1 27 10 00 BC AF 44 00 BF AF 40 00 B5 AF 3C 00 B4 AF 38 00 B3 AF 34 00 B2 AF 21 A0 80 00 ?? ?? 06 26 ?? ?? ?? ?? 21 20 20 02 10 00 BC 8F ?? ?? 04 26 ?? ?? 99 8F ?? ?? ?? ?? 08 00 94 26 10 00 BC 8F ?? ?? 93 8F ?? ?? 92 8F ?? ?? 95 8F ?? ?? 59 26 ?? ?? ?? ?? ?? ?? 64 8E 21 80 40 00 0D 00 40 10 10 00 BC 8F 00 00 02 96 FA FF 42 24 FF FF 42 30 02 00 42 2C F6 FF 40 10 ?? ?? 59 26 08 00 04 26 21 C8 A0 02 ?? ?? ?? ?? 21 28 80 02 EF FF 40 14 10 00 BC 8F ?? ?? 99 8F 21 20 20 02 ?? ?? ?? ?? 01 00 05 24 44 00 BF 8F 21 10 00 02 40 00 B5 8F 3C 00 B4 8F 38 00 B3 8F 34 00 B2 8F 30 00 B1 8F 2C 00 B0 8F 08 00 E0 03 48 00 BD 27 }
	condition:
		$1
}

rule file_187_8_0 {
	meta:
		name = "pututline"
		size = 264
		refs = "0000 _gp_disp 0018 __pthread_mutex_unlock 001c _pthread_cleanup_push_defer 004c __pthread_mutex_lock 0068 __GI_lseek 0084 __getutid 00c0 __GI_write 00d8 _pthread_cleanup_pop_restore"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 C0 FF BD 27 30 00 B1 AF ?? ?? 91 8F ?? ?? 85 8F ?? ?? 99 8F 38 00 B3 AF 18 00 B3 27 3C 00 BF AF ?? ?? 26 26 10 00 BC AF 34 00 B2 AF 2C 00 B0 AF 21 80 80 00 ?? ?? ?? ?? 21 20 60 02 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? ?? ?? 24 26 10 00 BC 8F 80 FE 05 24 01 00 06 24 ?? ?? 91 8F ?? ?? 92 8F 21 C8 40 02 ?? ?? ?? ?? ?? ?? 24 8E 10 00 BC 8F ?? ?? 99 8F ?? ?? 39 27 ?? ?? ?? ?? 21 20 00 02 04 00 40 10 ?? ?? 24 8E 80 FE 05 24 03 00 00 10 01 00 06 24 21 28 00 00 02 00 06 24 21 C8 40 02 ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F ?? ?? 24 8E 21 28 00 02 ?? ?? 99 8F ?? ?? ?? ?? 80 01 06 24 10 00 BC 8F 80 01 42 38 21 20 60 02 ?? ?? 99 8F 01 00 05 24 ?? ?? ?? ?? 0B 80 02 00 3C 00 BF 8F 21 10 00 02 38 00 B3 8F 34 00 B2 8F 30 00 B1 8F 2C 00 B0 8F 08 00 E0 03 40 00 BD 27 }
	condition:
		$1
}

rule file_187_9_0 {
	meta:
		name = "utmpname"
		size = 260
		refs = "0000 _gp_disp 0018 _pthread_cleanup_push_defer 001c __pthread_mutex_unlock 004c __pthread_mutex_lock 0078 free 0088 __GI_strdup 00bc __GI_close 00cc _pthread_cleanup_pop_restore"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 C0 FF BD 27 30 00 B1 AF ?? ?? 91 8F ?? ?? 99 8F ?? ?? 85 8F 2C 00 B0 AF 18 00 B0 27 10 00 BC AF 3C 00 BF AF 34 00 B2 AF ?? ?? 26 26 38 00 B3 AF 21 90 80 00 ?? ?? ?? ?? 21 20 00 02 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? ?? ?? 24 26 13 00 40 12 10 00 BC 8F ?? ?? 82 8F ?? ?? 91 8F ?? ?? 44 8C ?? ?? 31 26 05 00 91 10 21 98 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 40 02 ?? ?? 62 AE 03 00 40 14 10 00 BC 8F ?? ?? 82 8F ?? ?? 51 AC ?? ?? 82 8F ?? ?? 44 8C 21 88 40 00 FF FF 02 24 04 00 82 10 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F ?? ?? 99 8F FF FF 02 24 ?? ?? 22 AE 21 20 00 02 ?? ?? ?? ?? 01 00 05 24 3C 00 BF 8F 38 00 B3 8F 34 00 B2 8F 30 00 B1 8F 2C 00 B0 8F 21 10 00 00 08 00 E0 03 40 00 BD 27 }
	condition:
		$1
}

rule file_188_0_0 {
	meta:
		name = "__GI_sigaddset"
		size = 88
		refs = "0000 _gp_disp 0028 __GI___sigaddset 0034 __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 FF FF A2 24 80 00 42 2C 10 00 BC AF 1C 00 BF AF 04 00 40 10 1C 00 BF 8F ?? ?? 99 8F ?? ?? ?? ?? 20 00 BD 27 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 16 00 03 24 00 00 43 AC 1C 00 BF 8F FF FF 02 24 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_769_0_0 {
	meta:
		name = "__GI_sigdelset"
		size = 88
		refs = "0000 _gp_disp 0028 __GI___sigdelset 0034 __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 FF FF A2 24 80 00 42 2C 10 00 BC AF 1C 00 BF AF 04 00 40 10 1C 00 BF 8F ?? ?? 99 8F ?? ?? ?? ?? 20 00 BD 27 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 16 00 03 24 00 00 43 AC 1C 00 BF 8F FF FF 02 24 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_249_0_0 {
	meta:
		name = "sigismember"
		size = 88
		refs = "0000 _gp_disp 0028 __GI___sigismember 0034 __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 FF FF A2 24 80 00 42 2C 10 00 BC AF 1C 00 BF AF 04 00 40 10 1C 00 BF 8F ?? ?? 99 8F ?? ?? ?? ?? 20 00 BD 27 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 16 00 03 24 00 00 43 AC 1C 00 BF 8F FF FF 02 24 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_189_0_0 {
	meta:
		name = "sched_getparam"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 3F 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_190_0_0 {
	meta:
		name = "__syscall_ipc"
		size = 108
		refs = "0000 _gp_disp 0044 __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 18 00 B0 AF 1C 00 BF AF 34 00 B0 8F 30 00 A2 8F E0 FF BD 27 10 00 A2 AF 14 00 B0 AF 15 10 02 24 0C 00 00 00 20 00 BD 27 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_193_0_0 {
	meta:
		name = "wcpcpy"
		size = 32
	strings:
		$1 = { 00 00 A3 8C 21 10 80 00 04 00 A5 24 04 00 84 24 FB FF 60 14 00 00 43 AC 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_194_0_0 {
	meta:
		name = "__strtofpmax"
		size = 1152
		refs = "0000 _gp_disp 0020 __GI___ctype_b 0098 $LC0 0104 __muldf3 0144 __floatsidf 0160 __adddf3 022c __divdf3 02c4 __eqdf2 03e8 $LC1 0428 __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 A8 FF BD 27 48 00 B6 AF 38 00 B2 AF 21 B0 80 00 21 90 80 00 ?? ?? 84 8F 50 00 BE AF 10 00 BC AF 54 00 BF AF 4C 00 B7 AF 44 00 B5 AF 40 00 B4 AF 3C 00 B3 AF 34 00 B1 AF 30 00 B0 AF 5C 00 A5 AF 21 F0 C0 00 00 00 C2 82 00 00 8B 8C 40 18 02 00 21 18 63 01 00 00 63 94 20 00 63 30 03 00 60 10 2B 00 03 24 F7 FF 00 10 01 00 D6 26 05 00 43 10 2D 00 03 24 05 00 43 54 21 98 00 00 02 00 00 10 01 00 13 24 21 98 00 00 01 00 D6 26 ?? ?? 82 8F FF FF 17 24 21 48 00 00 ?? ?? 50 8C ?? ?? 51 8C 21 A8 00 00 21 A0 00 00 FF FF 0C 24 30 00 0D 24 2E 00 0E 24 00 00 C8 82 40 10 08 00 21 10 62 01 00 00 42 94 08 00 42 30 30 00 40 10 00 00 00 00 03 00 EC 12 00 00 00 00 04 00 E0 56 01 00 F7 26 28 00 0D 11 21 B8 00 00 01 00 F7 26 12 00 E2 2A F0 FF 40 50 01 00 D6 26 ?? ?? 99 8F 21 28 A0 02 20 00 A9 AF 1C 00 AB AF 24 00 AC AF 28 00 AD AF 2C 00 AE AF 21 20 A0 00 21 30 00 02 21 28 80 02 21 38 20 02 ?? ?? ?? ?? 18 00 A8 AF 10 00 BC 8F 18 00 A8 8F 21 A0 40 00 ?? ?? 99 8F D0 FF 04 25 ?? ?? ?? ?? 21 A8 60 00 10 00 BC 8F 21 20 80 02 21 28 A0 02 ?? ?? 99 8F 21 30 40 00 ?? ?? ?? ?? 21 38 60 00 10 00 BC 8F 20 00 A9 8F 1C 00 AB 8F 24 00 AC 8F 28 00 AD 8F 2C 00 AE 8F 21 A8 40 00 21 A0 60 00 CB FF 00 10 01 00 D6 26 06 00 0E 15 FF FF 02 24 39 00 20 15 00 00 00 00 01 00 D6 26 C4 FF 00 10 21 48 C0 02 36 00 E2 16 12 00 E2 2A A0 00 20 15 5C 00 A6 8F ?? ?? 84 8F 21 80 00 00 ?? ?? 84 24 21 18 80 00 21 10 00 00 01 00 05 26 21 30 C2 02 21 38 A2 00 00 00 C6 80 21 38 E4 00 00 00 E7 80 20 00 C6 34 1B 00 E6 14 21 88 60 00 01 00 42 24 21 30 A2 00 21 30 C4 00 00 00 C6 80 F4 FF C0 14 21 30 C2 02 ?? ?? 99 8F ?? ?? ?? ?? 21 20 00 02 10 00 BC 8F 21 20 40 00 21 28 60 00 ?? ?? 99 8F 21 30 00 00 ?? ?? ?? ?? 21 38 00 00 21 A8 40 00 03 00 60 12 21 A0 60 00 00 80 14 3C 26 A0 83 02 21 80 30 02 00 00 12 82 FE FF 52 26 77 00 00 10 21 90 D2 02 21 10 03 02 00 00 42 80 21 80 02 02 21 10 03 02 00 00 42 80 D7 FF 40 14 21 10 00 00 6F 00 00 10 5C 00 A6 8F 6C 00 E2 12 12 00 E2 2A 03 00 40 14 21 90 C0 02 EF FF F7 26 21 F0 D7 03 02 00 20 11 23 48 36 01 21 F0 C9 03 03 00 60 12 20 00 08 35 00 80 02 3C 26 A0 54 00 65 00 02 24 22 00 02 15 ?? ?? 99 8F 01 00 C2 82 2B 00 03 24 06 00 43 10 2D 00 03 24 05 00 43 50 FF FF 04 24 01 00 D2 26 03 00 00 10 01 00 04 24 01 00 04 24 02 00 D2 26 21 10 40 02 21 18 00 00 0A 00 07 24 00 00 45 80 40 30 05 00 21 30 66 01 00 00 C6 94 08 00 C6 30 07 00 C0 10 55 01 66 28 F8 FF C0 10 01 00 42 24 02 30 67 70 D0 FF A5 24 F4 FF 00 10 21 18 C5 00 26 90 52 00 0A 10 D2 02 21 90 40 00 02 10 83 70 21 F0 5E 00 ?? ?? 99 8F 21 20 A0 02 21 28 80 02 21 30 00 00 ?? ?? ?? ?? 21 38 00 00 36 00 40 10 10 00 BC 8F C3 17 1E 00 26 B0 5E 00 23 B0 C2 02 ?? ?? 82 8F ?? ?? 50 8C ?? ?? 51 8C 19 00 C0 12 01 00 C2 32 0D 00 40 10 ?? ?? 99 8F 03 00 C1 07 21 20 A0 02 01 00 00 10 ?? ?? 99 8F 21 28 80 02 21 30 00 02 09 F8 20 03 21 38 20 02 10 00 BC 8F 21 A8 40 00 21 A0 60 00 ?? ?? 99 8F 21 20 00 02 21 28 20 02 21 30 00 02 ?? ?? ?? ?? 21 38 20 02 43 B0 16 00 10 00 BC 8F 21 80 40 00 E7 FF 00 10 21 88 60 00 ?? ?? 82 8F ?? ?? 99 8F 21 20 A0 02 ?? ?? 46 8C ?? ?? 47 8C ?? ?? ?? ?? 21 28 80 02 10 00 BC 8F 21 20 A0 02 21 28 80 02 ?? ?? 99 8F 21 30 40 00 ?? ?? ?? ?? 21 38 60 00 06 00 40 14 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 22 00 03 24 00 00 43 AC 5C 00 A6 8F 01 00 C0 54 00 00 D2 AC 54 00 BF 8F 21 10 A0 02 21 18 80 02 50 00 BE 8F 4C 00 B7 8F 48 00 B6 8F 44 00 B5 8F 40 00 B4 8F 3C 00 B3 8F 38 00 B2 8F 34 00 B1 8F 30 00 B0 8F 08 00 E0 03 58 00 BD 27 }
	condition:
		$1
}

rule file_195_0_0 {
	meta:
		name = "tmpnam_r"
		size = 116
		refs = "0000 _gp_disp 002c ___path_search 0048 __gen_tempname"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 18 00 B0 AF 1C 00 BF AF 03 00 80 14 21 80 80 00 0F 00 00 10 21 10 00 00 ?? ?? 99 8F 14 00 05 24 21 30 00 00 ?? ?? ?? ?? 21 38 00 00 F8 FF 40 14 10 00 BC 8F ?? ?? 99 8F 21 20 00 02 ?? ?? ?? ?? 03 00 05 24 02 00 40 14 21 10 00 00 21 10 00 02 1C 00 BF 8F 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_196_4_0 {
	meta:
		name = "authnone_marshal"
		size = 108
		refs = "0000 _gp_disp 000c __rpc_thread_variables"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F E0 FF BD 27 10 00 BC AF 18 00 B0 AF 1C 00 BF AF ?? ?? ?? ?? 21 80 A0 00 98 00 42 8C 0A 00 40 10 10 00 BC 8F 04 00 03 8E 1C 00 BF 8F 21 20 00 02 0C 00 79 8C 18 00 B0 8F 3C 00 46 8C 28 00 45 24 08 00 20 03 20 00 BD 27 1C 00 BF 8F 18 00 B0 8F 21 10 00 00 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_196_5_0 {
	meta:
		name = "__GI_authnone_create"
		size = 308
		refs = "0000 _gp_disp 000c __rpc_thread_variables 0040 calloc 006c _null_auth 0070 __GI_xdrmem_create 00c4 __GI_xdr_opaque_auth"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F C0 FF BD 27 10 00 BC AF 34 00 B1 AF 30 00 B0 AF 3C 00 BF AF 38 00 B2 AF ?? ?? ?? ?? 00 00 00 00 98 00 50 8C 10 00 BC 8F 09 00 00 16 21 88 40 00 ?? ?? 99 8F 01 00 04 24 ?? ?? ?? ?? 40 00 05 24 21 80 40 00 30 00 40 10 10 00 BC 8F 98 00 22 AE 3C 00 02 8E 2D 00 40 14 21 10 00 02 ?? ?? 82 8F ?? ?? 99 8F 18 00 B1 27 00 00 44 8C 14 00 06 24 21 38 00 00 0C 00 04 AE 04 00 43 8C 28 00 05 26 10 00 03 AE 08 00 42 8C 04 00 03 AE 00 00 04 AE 14 00 02 AE 08 00 02 AE ?? ?? 82 8F 21 20 20 02 ?? ?? 42 24 ?? ?? ?? ?? 20 00 02 AE 10 00 BC 8F 21 20 20 02 ?? ?? 92 8F 21 C8 40 02 ?? ?? ?? ?? 21 28 00 02 21 20 20 02 21 C8 40 02 ?? ?? ?? ?? 0C 00 05 26 1C 00 A2 8F 10 00 59 8C 09 F8 20 03 21 20 20 02 3C 00 02 AE 1C 00 A2 8F 1C 00 59 8C 06 00 20 53 21 10 00 02 09 F8 20 03 21 20 20 02 02 00 00 10 21 10 00 02 21 10 00 00 3C 00 BF 8F 38 00 B2 8F 34 00 B1 8F 30 00 B0 8F 08 00 E0 03 40 00 BD 27 }
	condition:
		$1
}

rule file_197_0_0 {
	meta:
		name = "sched_yield"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 42 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_198_0_0 {
	meta:
		name = "__GI_towctrans"
		size = 132
		refs = "0000 _gp_disp 005c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 FF FF A2 24 02 00 42 2C 10 00 BC AF 18 00 B0 AF 1C 00 BF AF 0D 00 40 10 21 80 80 00 20 00 83 34 9F FF 64 24 1A 00 84 2C 0E 00 80 10 21 10 00 02 21 10 60 00 02 00 03 24 0B 00 A3 14 1C 00 BF 8F DF FF 02 24 08 00 00 10 24 10 02 02 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 16 00 03 24 00 00 43 AC 21 10 00 02 1C 00 BF 8F 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_199_0_0 {
	meta:
		name = "__GI_qsort"
		size = 324
	strings:
		$1 = { 02 00 A2 2C 4D 00 40 14 00 00 00 00 B8 FF BD 27 24 00 B1 AF 44 00 BF AF 40 00 BE AF 3C 00 B7 AF 38 00 B6 AF 34 00 B5 AF 30 00 B4 AF 2C 00 B3 AF 28 00 B2 AF 20 00 B0 AF 35 00 C0 10 21 88 C0 00 FF FF A3 24 03 00 02 24 1B 00 62 00 F4 01 40 00 21 F0 80 00 21 80 00 00 12 18 00 00 02 80 02 72 01 00 10 26 2B 20 03 02 FD FF 80 54 02 80 02 72 02 80 30 72 03 00 17 24 02 B0 B1 70 21 A0 00 02 21 A8 80 02 23 A8 B0 02 21 90 D5 03 21 98 50 02 18 00 A7 AF 21 C8 E0 00 21 20 40 02 09 F8 20 03 21 28 60 02 07 00 40 1C 18 00 A7 8F 21 A0 91 02 2B 10 96 02 F3 FF 40 14 21 A8 80 02 0F 00 00 10 23 80 11 02 21 10 20 02 00 00 44 82 00 00 65 82 FF FF 42 24 01 00 52 26 FF FF 45 A2 01 00 73 26 F9 FF 40 14 FF FF 64 A2 2B 10 B0 02 E6 FF 40 10 23 A8 B0 02 EE FF 00 10 21 A0 91 02 1B 00 17 02 F4 01 E0 02 12 80 00 00 DD FF 00 16 21 A0 00 02 44 00 BF 8F 40 00 BE 8F 3C 00 B7 8F 38 00 B6 8F 34 00 B5 8F 30 00 B4 8F 2C 00 B3 8F 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 48 00 BD 27 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_200_0_0 {
	meta:
		name = "link"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF A9 0F 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_201_0_0 {
	meta:
		name = "getgrouplist"
		size = 212
		refs = "0000 _gp_disp 000c __getgrouplist_internal 0078 __GI_memcpy 0090 free"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F D0 FF BD 27 10 00 BC AF 28 00 B4 AF 24 00 B3 AF 20 00 B2 AF 1C 00 B1 AF 18 00 B0 AF 2C 00 BF AF 21 A0 C0 00 21 30 E0 00 21 80 A0 00 21 88 E0 00 ?? ?? ?? ?? 00 00 F3 8C 21 90 40 00 05 00 40 14 10 00 BC 8F 16 00 60 12 01 00 02 24 15 00 00 10 00 00 90 AE 00 00 22 8E 2A 80 62 02 0A 98 50 00 07 00 60 12 21 80 60 02 ?? ?? 99 8F 21 20 80 02 21 28 40 02 ?? ?? ?? ?? 80 30 13 00 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 40 02 00 00 23 8E FF FF 02 24 2A 18 03 02 02 00 00 10 0A 10 03 02 FF FF 02 24 2C 00 BF 8F 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_202_0_0 {
	meta:
		name = "freopen64"
		size = 452
		refs = "0000 _gp_disp 0044 _pthread_cleanup_push_defer 0048 __pthread_mutex_unlock 0060 __pthread_mutex_lock 0074 _stdio_openlist_del_lock 00a8 _stdio_openlist_use_count 00ac _pthread_cleanup_pop_restore 00e4 __GI_fclose 0128 _stdio_openlist_del_count 0144 _stdio_fopen 0174 _stdio_openlist_dec_use"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 A8 FF BD 27 4C 00 B4 AF 48 00 B3 AF 3C 00 B0 AF 10 00 BC AF 54 00 BF AF 50 00 B5 AF 44 00 B2 AF 40 00 B1 AF 34 00 D2 8C 21 A0 80 00 21 98 A0 00 0C 00 40 16 21 80 C0 00 ?? ?? 99 8F ?? ?? 85 8F 38 00 D1 24 28 00 A4 27 ?? ?? ?? ?? 21 30 20 02 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 20 02 10 00 BC 8F ?? ?? 85 8F ?? ?? 86 8F ?? ?? 99 8F 18 00 B1 27 ?? ?? ?? ?? 21 20 20 02 10 00 BC 8F ?? ?? 84 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F 21 20 20 02 01 00 05 24 ?? ?? 82 8F ?? ?? 99 8F 00 00 43 8C 01 00 63 24 00 00 43 AC ?? ?? ?? ?? 00 00 00 00 00 00 02 96 10 00 BC 8F FF 9F 43 30 00 60 55 30 00 00 03 A6 30 00 42 30 30 00 03 24 18 00 43 10 ?? ?? 99 8F ?? ?? ?? ?? 21 20 00 02 10 00 BC 8F ?? ?? 85 8F ?? ?? 86 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 20 02 10 00 BC 8F ?? ?? 84 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F 21 20 20 02 01 00 05 24 ?? ?? 82 8F ?? ?? 99 8F 00 00 43 8C FF FF 63 24 ?? ?? ?? ?? 00 00 43 AC 10 00 BC 8F ?? ?? 99 8F 21 20 80 02 21 28 60 02 21 30 00 02 ?? ?? ?? ?? FE FF 07 24 21 88 40 00 03 00 40 14 10 00 BC 8F 30 80 02 24 00 00 02 A6 00 00 02 96 ?? ?? 99 8F 25 A8 A2 02 ?? ?? ?? ?? 00 00 15 A6 05 00 40 16 10 00 BC 8F ?? ?? 99 8F 28 00 A4 27 ?? ?? ?? ?? 01 00 05 24 54 00 BF 8F 21 10 20 02 50 00 B5 8F 4C 00 B4 8F 48 00 B3 8F 44 00 B2 8F 40 00 B1 8F 3C 00 B0 8F 08 00 E0 03 58 00 BD 27 }
	condition:
		$1
}

rule file_203_0_0 {
	meta:
		name = "__GI_setresgid"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 5E 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_204_0_0 {
	meta:
		name = "__getpagesize"
		size = 32
		refs = "0000 _gp_disp 000c __pagesize"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F 01 00 03 3C 00 00 42 8C 08 00 E0 03 0A 10 62 00 }
	condition:
		$1
}

rule file_205_0_0 {
	meta:
		name = "__GI_fgetwc_unlocked"
		size = 536
		refs = "0000 _gp_disp 0060 __stdio_trans2r_o 00f0 __GI_mbrtowc 00f4 __stdio_rfill 01a4 __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 C0 FF BD 27 20 00 B0 AF 10 00 BC AF 3C 00 BF AF 38 00 B6 AF 34 00 B5 AF 30 00 B4 AF 2C 00 B3 AF 28 00 B2 AF 24 00 B1 AF 00 00 82 94 03 08 42 30 01 08 42 2C 07 00 40 14 21 80 80 00 00 00 02 96 02 00 43 30 0A 00 60 14 01 00 43 30 18 00 00 10 08 00 02 8E ?? ?? 99 8F ?? ?? ?? ?? 00 08 05 24 F6 FF 40 10 10 00 BC 8F 5E 00 00 10 FF FF 02 24 07 00 60 54 02 00 00 A2 28 00 04 8E 03 00 80 50 03 00 04 92 02 00 00 10 02 00 00 A2 02 00 04 A2 08 00 63 24 FF FF 42 24 80 18 03 00 00 00 02 A6 21 18 03 02 04 00 62 8C 44 00 00 10 28 00 00 AE 0A 00 40 54 2C 00 02 8E 1C 00 A2 27 08 00 02 AE 10 00 02 AE 14 00 02 AE 18 00 02 AE 1C 00 02 AE 1D 00 A2 27 0C 00 02 AE 2C 00 02 8E 01 00 40 50 02 00 00 A2 ?? ?? 95 8F ?? ?? 92 8F 2C 00 13 26 18 00 B4 27 FE FF 16 24 10 00 05 8E 14 00 11 8E 23 88 25 02 19 00 20 12 21 C8 40 02 21 20 80 02 21 30 20 02 21 C8 A0 02 ?? ?? ?? ?? 21 38 60 02 0A 00 40 04 01 00 03 24 0A 10 62 00 10 00 03 8E 21 18 62 00 10 00 03 AE 02 00 03 92 21 10 43 00 02 00 02 A2 1D 00 00 10 18 00 A2 8F 17 00 56 14 21 C8 40 02 10 00 02 8E 21 10 51 00 10 00 02 AE 02 00 02 92 21 88 22 02 02 00 11 A2 ?? ?? ?? ?? 21 20 00 02 E0 FF 40 14 10 00 BC 8F 00 00 02 96 08 00 42 30 0A 00 40 54 00 00 02 96 2C 00 03 8E 0A 00 60 10 FF FF 02 24 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 58 00 03 24 00 00 43 AC 00 00 02 96 08 00 42 34 00 00 02 A6 FF FF 02 24 08 00 04 8E 1C 00 A3 27 08 00 83 14 3C 00 BF 8F 08 00 00 AE 0C 00 00 AE 10 00 00 AE 14 00 00 AE 18 00 00 AE 1C 00 00 AE 3C 00 BF 8F 38 00 B6 8F 34 00 B5 8F 30 00 B4 8F 2C 00 B3 8F 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 08 00 E0 03 40 00 BD 27 }
	condition:
		$1
}

rule file_206_0_0 {
	meta:
		name = "__GI_strncat"
		size = 192
	strings:
		$1 = { 21 10 80 00 21 18 80 00 00 00 64 80 03 00 80 10 01 00 67 24 FC FF 00 10 21 18 E0 00 04 00 C4 2C FF FF 63 24 18 00 80 14 82 40 06 00 00 00 A4 80 21 00 80 10 01 00 64 A0 01 00 A4 80 1E 00 80 10 02 00 64 A0 02 00 A4 80 1B 00 80 10 03 00 64 A0 03 00 A7 80 04 00 A9 24 04 00 64 24 16 00 E0 10 04 00 67 A0 FF FF 08 25 04 00 00 51 03 00 C6 30 21 28 20 01 ED FF 00 10 21 18 80 00 21 28 20 01 09 00 00 10 21 18 80 00 07 00 00 10 21 38 00 00 01 00 63 24 01 00 A4 24 07 00 E0 10 00 00 67 A0 FF FF C6 24 21 28 80 00 F9 FF C0 54 00 00 A7 80 01 00 E0 54 01 00 60 A0 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_207_0_0 {
	meta:
		name = "mbtowc"
		size = 120
		refs = "0000 _gp_disp 0040 __GI_mbrtowc"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 05 00 A0 54 00 00 A3 80 ?? ?? 82 8F ?? ?? 40 AC 0E 00 00 10 21 10 00 00 0C 00 60 10 21 10 00 00 ?? ?? 90 8F ?? ?? 99 8F ?? ?? ?? ?? ?? ?? 07 26 FE FF 03 24 06 00 43 14 1C 00 BF 8F FF FF 02 34 ?? ?? 10 26 04 00 02 AE FF FF 02 24 1C 00 BF 8F 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_208_0_0 {
	meta:
		name = "getoffset"
		size = 176
		refs = "0000 _gp_disp"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 87 8F FF FF 02 24 21 18 00 00 ?? ?? E7 24 0A 00 08 24 3A 00 09 24 00 00 86 80 D0 FF C6 24 FF 00 CA 30 0A 00 4A 2D 03 00 40 11 01 00 E7 24 01 00 84 24 21 10 C0 00 00 00 86 80 D0 FF C6 24 FF 00 CA 30 0A 00 4A 2D 05 00 40 51 00 00 E6 80 02 50 48 70 01 00 84 24 21 10 46 01 00 00 E6 80 2B 50 46 00 0D 00 40 11 02 50 C3 70 21 18 42 01 00 00 8A 80 03 00 49 15 21 10 00 00 01 00 84 24 FF FF 02 24 02 00 C6 28 E4 FF C0 50 00 00 86 80 00 00 A3 AC 08 00 E0 03 21 10 80 00 08 00 E0 03 21 10 00 00 }
	condition:
		$1
}

rule file_208_1_0 {
	meta:
		name = "_time_tzset"
		size = 1424
		refs = "0000 _gp_disp 0010 __pthread_mutex_unlock 0014 _time_tzlock 0018 _pthread_cleanup_push_defer 005c __pthread_mutex_lock 0070 __GI_getenv 008c __GI_open 0088 $LC0 00a8 __GI_read 0100 __GI_close 0128 _time_tzinfo 0130 __GI_memset 0154 __GI_strcpy 0180 __GI_strcmp 019c __GI_strncpy 02e0 getoffset 0344 __GI_memcpy 01bc __GI___ctype_b 0354 tzname 036c daylight 037c timezone 0558 _pthread_cleanup_pop_restore"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 40 FF BD 27 ?? ?? 85 8F ?? ?? 86 8F ?? ?? 99 8F A8 00 B2 AF 8C 00 B2 27 BC 00 BF AF 10 00 BC AF AC 00 B3 AF A0 00 B0 AF B8 00 B6 AF B4 00 B5 AF B0 00 B4 AF A4 00 B1 AF 21 98 80 00 9C 00 A0 AF ?? ?? ?? ?? 21 20 40 02 10 00 BC 8F ?? ?? 84 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F ?? ?? 84 8F ?? ?? 99 8F ?? ?? ?? ?? ?? ?? 84 24 21 80 40 00 39 00 40 14 10 00 BC 8F ?? ?? 84 8F ?? ?? 99 8F 21 28 00 00 ?? ?? ?? ?? ?? ?? 84 24 21 A0 40 00 21 00 40 04 10 00 BC 8F ?? ?? 96 8F 18 00 B1 27 44 00 10 24 21 A8 20 02 21 20 80 02 21 28 20 02 21 C8 C0 02 ?? ?? ?? ?? 21 30 00 02 10 00 40 04 10 00 BC 8F 05 00 40 50 2B 10 B1 02 23 80 02 02 F5 FF 00 16 21 88 22 02 2B 10 B1 02 09 00 40 10 21 80 00 00 FF FF 23 82 0A 00 02 24 06 00 62 14 ?? ?? 99 8F FF FF 20 A2 03 00 00 10 21 80 A0 02 21 80 00 00 ?? ?? 99 8F ?? ?? ?? ?? 21 20 80 02 11 00 00 16 10 00 BC 8F ?? ?? 90 8F ?? ?? 82 8F ?? ?? 99 8F 21 20 00 02 21 28 00 00 30 00 06 24 ?? ?? ?? ?? ?? ?? 40 A0 10 00 BC 8F 10 00 04 26 ?? ?? 85 8F ?? ?? 99 8F ?? ?? ?? ?? ?? ?? A5 24 7B 00 00 10 10 00 BC 8F 00 00 02 82 EF FF 40 50 ?? ?? 90 8F ?? ?? 91 8F 3A 00 42 38 01 00 42 2C ?? ?? 99 8F 21 80 02 02 21 20 00 02 ?? ?? ?? ?? ?? ?? 25 26 F0 00 40 10 10 00 BC 8F ?? ?? 99 8F ?? ?? 24 26 21 28 00 02 ?? ?? ?? ?? 44 00 06 24 10 00 BC 8F 84 00 A0 A3 21 60 00 00 ?? ?? 98 8F ?? ?? 91 8F 5C 00 AD 27 9C 00 AF 27 18 00 AE 27 00 00 03 82 3C 00 02 24 03 00 62 14 3E 00 03 24 02 00 00 10 01 00 10 26 21 18 00 00 18 00 06 24 02 10 86 71 21 58 00 02 21 20 00 00 2B 00 08 24 2D 00 05 24 07 00 09 24 21 30 4D 00 10 00 C6 24 00 00 62 81 16 00 40 18 40 38 02 00 00 00 0A 8F 21 38 47 01 00 00 E7 94 04 00 EA 30 08 00 40 11 00 00 00 00 01 00 84 24 01 00 C7 24 01 00 6B 25 B9 FF 89 10 00 00 C2 A0 F1 FF 00 10 21 30 E0 00 07 00 60 10 00 08 E7 30 F7 FF E0 54 01 00 84 24 F5 FF 48 50 01 00 84 24 F3 FF 45 50 01 00 84 24 03 00 84 28 AC FF 80 14 00 00 C0 A0 04 00 60 50 00 00 62 81 A8 FF 43 14 01 00 6B 25 00 00 62 81 2D 00 03 24 0E 00 43 10 2B 00 03 24 0D 00 43 10 21 20 60 01 0B 00 80 11 FF FF 64 25 D0 FF 42 24 FF 00 42 30 0A 00 42 2C 06 00 40 14 9C 00 A2 8F 21 80 60 01 F0 F1 42 24 11 00 00 10 9C 00 A2 AF 21 20 60 01 ?? ?? 22 26 01 00 84 24 21 C8 40 00 ?? ?? ?? ?? 21 28 E0 01 21 80 40 00 8E FF 40 10 10 00 BC 8F 00 00 63 81 2D 00 02 24 05 00 62 14 18 00 03 24 9C 00 A2 8F 23 10 02 00 9C 00 A2 AF 18 00 03 24 02 20 83 71 9C 00 A2 8F 21 18 8E 00 19 00 80 15 44 00 62 AC 74 00 A2 AF 00 00 02 82 A7 FF 40 14 01 00 0C 24 ?? ?? 84 8F ?? ?? 99 8F 21 28 A0 01 ?? ?? ?? ?? 30 00 06 24 10 00 BC 8F ?? ?? 82 8F ?? ?? 83 8F 10 00 44 24 00 00 64 AC 28 00 44 24 04 00 64 AC 28 00 44 80 ?? ?? 83 8F 2B 20 04 00 00 00 64 AC 00 00 43 8C ?? ?? 82 8F 75 00 00 10 00 00 43 AC 00 00 02 82 08 00 40 14 ?? ?? 8F 8F 04 00 60 52 ?? ?? 90 8F ?? ?? 90 8F 03 00 00 10 ?? ?? 10 26 ?? ?? 10 26 ?? ?? 8F 8F ?? ?? 98 8F ?? ?? 93 8F ?? ?? 91 8F 21 58 00 00 9C 00 AC 27 00 00 03 82 2C 00 02 24 56 FF 62 14 4D 00 03 24 01 00 02 82 08 00 43 10 02 00 07 26 4A 00 03 24 08 00 43 10 21 18 00 00 01 00 07 26 6D 01 04 24 07 00 00 10 ?? ?? 62 26 0C 00 04 24 04 00 00 10 ?? ?? E2 25 4A 00 03 24 6D 01 04 24 ?? ?? 02 27 18 00 08 24 02 40 68 71 21 80 E0 00 08 00 05 25 21 28 A5 01 21 40 C8 01 06 00 A6 24 52 00 03 A5 02 00 A5 24 4D 00 63 38 0B 30 A3 00 0A 00 05 24 21 18 00 02 03 00 08 24 21 38 00 00 00 00 69 80 D0 FF 29 25 FF 00 2A 31 0A 00 4A 2D 07 00 40 11 02 50 E5 70 FF FF 08 25 01 00 63 24 F7 FF 00 15 21 38 49 01 04 00 00 10 00 00 00 00 03 00 09 24 29 FF 09 11 ?? ?? 90 8F 27 FF 60 10 ?? ?? 90 8F 02 00 48 80 23 40 E8 00 2B 20 88 00 23 FF 80 54 ?? ?? 82 8F 01 00 44 80 07 00 80 10 21 80 60 00 01 00 70 24 00 00 63 80 04 00 64 50 03 00 44 80 19 FF 00 10 ?? ?? 90 8F 03 00 44 80 FE FF C6 24 00 00 C7 A4 03 00 80 18 03 00 43 24 D8 FF 00 10 21 10 60 00 20 1C 02 24 9C 00 A2 AF 00 00 03 82 2F 00 02 24 0A 00 62 14 18 00 02 24 ?? ?? 22 26 01 00 04 26 21 C8 40 00 ?? ?? ?? ?? 21 28 80 01 21 80 40 00 03 FF 40 10 10 00 BC 8F 18 00 02 24 02 18 62 71 01 00 6B 25 21 10 6E 00 9C 00 A3 8F 48 00 43 AC 01 00 02 24 A2 FF 62 51 00 00 03 82 00 00 02 82 F8 FE 40 14 ?? ?? 90 8F 7A FF 00 10 ?? ?? 84 8F ?? ?? 99 8F 21 20 40 02 ?? ?? ?? ?? 01 00 05 24 BC 00 BF 8F B8 00 B6 8F B4 00 B5 8F B0 00 B4 8F AC 00 B3 8F A8 00 B2 8F A4 00 B1 8F A0 00 B0 8F 08 00 E0 03 C0 00 BD 27 }
	condition:
		$1
}

rule file_208_2_0 {
	meta:
		name = "__GI_tzset"
		size = 68
		refs = "0000 _gp_disp 000c __GI_time 0030 _time_tzset"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F E0 FF BD 27 10 00 BC AF 1C 00 BF AF ?? ?? ?? ?? 21 20 00 00 10 00 BC 8F 1C 00 BF 8F 98 45 04 3C ?? ?? 99 8F 00 4F 84 24 2A 20 44 00 ?? ?? ?? ?? 20 00 BD 27 }
	condition:
		$1
}

rule file_209_0_0 {
	meta:
		name = "fsetpos"
		size = 212
		refs = "0000 _gp_disp 0038 _pthread_cleanup_push_defer 003c __pthread_mutex_unlock 0054 __pthread_mutex_lock 0064 __GI_fseek 00a0 _pthread_cleanup_pop_restore"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 B8 FF BD 27 38 00 B1 AF 34 00 B0 AF 10 00 BC AF 44 00 BF AF 40 00 B3 AF 3C 00 B2 AF 34 00 92 8C 21 80 80 00 0C 00 40 16 21 88 A0 00 ?? ?? 99 8F ?? ?? 85 8F 38 00 93 24 21 30 60 02 ?? ?? ?? ?? 18 00 A4 27 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 60 02 10 00 BC 8F ?? ?? 99 8F 00 00 25 8E 21 20 00 02 ?? ?? ?? ?? 21 30 00 00 07 00 40 14 10 00 BC 8F 04 00 23 8E 2C 00 03 AE 08 00 23 8E 30 00 03 AE 0C 00 23 8E 02 00 03 A2 08 00 40 16 44 00 BF 8F ?? ?? 99 8F 28 00 A2 AF 18 00 A4 27 ?? ?? ?? ?? 01 00 05 24 28 00 A2 8F 44 00 BF 8F 40 00 B3 8F 3C 00 B2 8F 38 00 B1 8F 34 00 B0 8F 08 00 E0 03 48 00 BD 27 }
	condition:
		$1
}

rule file_211_0_0 {
	meta:
		name = "__syscall_sync_file_range"
		size = 108
		refs = "0000 _gp_disp 0044 __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 18 00 B0 AF 1C 00 BF AF 34 00 B0 8F 30 00 A2 8F E0 FF BD 27 10 00 A2 AF 14 00 B0 AF D1 10 02 24 0C 00 00 00 20 00 BD 27 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_211_1_0 {
	meta:
		name = "sync_file_range"
		size = 56
		refs = "0000 _gp_disp 0030 __syscall_sync_file_range"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 14 00 A3 8F 10 00 A2 8F ?? ?? 99 8F 10 00 A3 AF 18 00 A3 8F 21 28 C0 00 ?? ?? 39 27 21 30 E0 00 14 00 A3 AF ?? ?? ?? ?? 21 38 40 00 }
	condition:
		$1
}

rule file_213_0_0 {
	meta:
		name = "__GI_read"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF A3 0F 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_214_0_0 {
	meta:
		name = "setjmp"
		size = 24
		refs = "0000 _gp_disp 000c __sigsetjmp"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F 08 00 20 03 01 00 05 24 }
	condition:
		$1
}

rule file_215_0_0 {
	meta:
		name = "madvise"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 7A 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_216_0_0 {
	meta:
		name = "__close_nameservers"
		size = 180
		refs = "0000 _gp_disp 000c __nameserver 0030 __local_nameserver 0038 free 0048 __nameservers 004c __searchdomains 0050 __searchdomain"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F D8 FF BD 27 18 00 B0 AF 10 00 BC AF 24 00 BF AF 20 00 B2 AF 1C 00 B1 AF 00 00 44 8C 21 80 40 00 ?? ?? 82 8F 04 00 82 10 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F ?? ?? 82 8F ?? ?? 91 8F ?? ?? 92 8F 00 00 00 AE 00 00 40 AC 00 00 22 8E ?? ?? 99 8F 0A 00 40 10 ?? ?? 90 8F 00 00 43 8E FF FF 42 24 00 00 22 AE 80 10 02 00 21 10 62 00 ?? ?? ?? ?? 00 00 44 8C F4 FF 00 10 10 00 BC 8F ?? ?? ?? ?? 00 00 04 8E 00 00 00 AE 24 00 BF 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_217_0_0 {
	meta:
		name = "__GI_wctrans"
		size = 148
		refs = "0000 _gp_disp 001c __GI_strcmp"
		altNames = "__GI_wctype"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D0 FF BD 27 18 00 B0 AF ?? ?? 90 8F 24 00 B3 AF ?? ?? 93 8F 28 00 B4 AF 1C 00 B1 AF 10 00 BC AF 2C 00 BF AF 20 00 B2 AF 21 A0 80 00 01 00 11 24 ?? ?? 10 26 01 00 12 26 21 20 80 02 21 C8 60 02 ?? ?? ?? ?? 21 28 40 02 03 00 40 54 00 00 10 92 05 00 00 10 21 10 20 02 21 80 50 02 00 00 02 92 F4 FF 40 14 01 00 31 26 2C 00 BF 8F 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_218_0_0 {
	meta:
		name = "pipe"
		size = 60
		refs = "0000 _gp_disp 0030 __syscall_error"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 CA 0F 02 24 0C 00 00 00 05 00 E0 14 00 00 00 00 00 00 82 AC 04 00 83 AC 08 00 E0 03 00 00 02 24 21 20 40 00 ?? ?? 99 8F 08 00 20 03 00 00 00 00 }
	condition:
		$1
}

rule file_219_0_0 {
	meta:
		name = "ctime_r"
		size = 80
		refs = "0000 _gp_disp 000c __GI_localtime_r 0034 __GI_asctime_r"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F B0 FF BD 27 4C 00 BF AF 48 00 B0 AF 10 00 BC AF 21 80 A0 00 ?? ?? ?? ?? 18 00 A5 27 10 00 BC 8F 21 28 00 02 ?? ?? 99 8F ?? ?? ?? ?? 21 20 40 00 4C 00 BF 8F 48 00 B0 8F 08 00 E0 03 50 00 BD 27 }
	condition:
		$1
}

rule file_220_0_0 {
	meta:
		name = "__GI_inet_aton"
		size = 236
		refs = "0000 _gp_disp 0010 __GI___ctype_b"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 32 00 80 10 ?? ?? 8B 8F 01 00 02 24 21 38 00 00 0A 00 0C 24 04 00 0D 24 2E 00 0E 24 05 00 0A 24 00 00 83 80 00 00 69 8D 40 18 03 00 21 18 23 01 00 00 63 94 08 00 63 30 24 00 60 10 21 18 00 00 00 00 86 80 40 40 06 00 21 40 28 01 00 00 08 95 08 00 0F 31 09 00 E0 11 01 00 84 24 02 40 6C 70 D0 FF C6 24 21 18 06 01 00 01 66 28 F5 FF C0 54 00 00 86 80 08 00 E0 03 21 10 00 00 05 00 4D 10 00 00 00 00 08 00 CE 50 00 3A 07 00 08 00 E0 03 21 10 00 00 04 00 C0 10 00 3A 07 00 20 00 08 31 0A 00 00 11 00 00 00 00 01 00 42 24 DC FF 4A 14 25 38 67 00 08 00 A0 50 01 00 02 24 A0 10 07 7C 02 14 22 00 03 00 00 10 00 00 A2 AC 08 00 E0 03 21 10 00 00 01 00 02 24 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_221_0_0 {
	meta:
		name = "access"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF C1 0F 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_222_0_0 {
	meta:
		name = "cacheflush"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 33 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_222_1_0 {
	meta:
		name = "cachectl"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 34 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_223_0_0 {
	meta:
		name = "__sigsetjmp_aux"
		size = 72
		refs = "0000 _gp_disp 003c __sigjmp_save"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 00 00 9F AC 04 00 86 AC 28 00 87 AC 2C 00 9C AC 08 00 90 AC 0C 00 91 AC 10 00 92 AC 14 00 93 AC 18 00 94 AC 1C 00 95 AC 20 00 96 AC 24 00 97 AC ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_225_0_0 {
	meta:
		name = "__GI_islower"
		size = 40
		refs = "0000 _gp_disp 000c __GI___ctype_b"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F 40 20 04 00 00 00 42 8C 21 10 44 00 00 00 42 94 08 00 E0 03 02 00 42 30 }
	condition:
		$1
}

rule file_226_0_0 {
	meta:
		name = "__GI___cmsg_nxthdr"
		size = 96
	strings:
		$1 = { 00 00 A2 8C 0C 00 43 2C 13 00 60 14 FC FF 06 24 03 00 42 24 24 10 46 00 21 28 A2 00 10 00 83 8C 14 00 82 8C 21 18 62 00 0C 00 A2 24 2B 10 62 00 09 00 40 14 00 00 00 00 00 00 A2 8C 03 00 42 24 24 10 46 00 21 10 A2 00 2B 10 62 00 0B 28 02 00 08 00 E0 03 21 10 A0 00 08 00 E0 03 21 10 00 00 }
	condition:
		$1
}

rule file_227_0_0 {
	meta:
		name = "__stdio_fwrite"
		size = 412
		refs = "0000 _gp_disp 005c __stdio_WRITE 0088 __GI_memcpy 00e4 __GI_memrchr 0108 __stdio_wcommit 0128 __GI_memchr"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D0 FF BD 27 24 00 B2 AF 20 00 B1 AF 1C 00 B0 AF 10 00 BC AF 2C 00 BF AF 28 00 B3 AF 00 00 C2 94 21 90 80 00 21 88 A0 00 00 02 42 30 0C 00 40 10 21 80 C0 00 2C 00 BF 8F 28 00 B3 8F 21 20 00 02 21 28 40 02 1C 00 B0 8F 24 00 B2 8F 21 30 20 02 ?? ?? 99 8F 20 00 B1 8F ?? ?? ?? ?? 30 00 BD 27 10 00 C4 8C 0C 00 D3 8C 04 00 C3 8C FE FF 02 24 0B 00 62 14 23 98 64 02 2B 10 65 02 ?? ?? 99 8F 0A 98 A2 00 21 30 60 02 ?? ?? ?? ?? 21 28 40 02 10 00 02 8E 21 98 53 00 10 00 00 10 10 00 13 AE 2B 98 65 02 2C 00 60 56 08 00 C2 8C ?? ?? 99 8F 21 28 40 02 ?? ?? ?? ?? 21 30 20 02 10 00 02 8E 10 00 BC 8F 21 10 51 00 10 00 02 AE 00 00 02 96 00 01 42 30 03 00 40 14 ?? ?? 99 8F 25 00 00 10 21 10 20 02 21 20 40 02 0A 00 05 24 ?? ?? ?? ?? 21 30 20 02 F9 FF 40 10 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 00 02 F4 FF 40 10 10 00 BC 8F 2B 98 22 02 0B 10 33 02 21 98 40 00 ?? ?? 99 8F 23 10 22 02 21 90 42 02 21 20 40 02 0A 00 05 24 ?? ?? ?? ?? 21 30 60 02 E8 FF 40 10 21 90 53 02 23 90 42 02 10 00 02 8E 23 10 52 00 10 00 02 AE 08 00 00 10 23 10 32 02 B6 FF 44 10 ?? ?? 99 8F ?? ?? ?? ?? 21 20 C0 00 B2 FF 40 10 10 00 BC 8F 21 10 00 00 2C 00 BF 8F 28 00 B3 8F 24 00 B2 8F 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_228_0_0 {
	meta:
		name = "bdflush"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 26 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_229_0_0 {
	meta:
		name = "__GI_fwrite_unlocked"
		size = 244
		refs = "0000 _gp_disp 0058 __stdio_trans2w_o 009c __stdio_fwrite 00bc __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 00 00 E3 94 D0 FF BD 27 C0 00 02 24 C0 00 63 30 10 00 BC AF 28 00 B3 AF 24 00 B2 AF 20 00 B1 AF 1C 00 B0 AF 2C 00 BF AF 21 98 80 00 21 80 A0 00 21 90 C0 00 05 00 62 14 21 88 E0 00 0B 00 00 16 21 10 00 00 22 00 00 10 2C 00 BF 8F ?? ?? 99 8F 21 20 E0 00 ?? ?? ?? ?? 80 00 05 24 F7 FF 40 10 10 00 BC 8F 19 00 00 10 21 10 00 00 16 00 40 12 FF FF 02 24 1B 00 50 00 F4 01 00 02 12 10 00 00 2B 10 52 00 0A 00 40 54 00 00 22 96 02 28 12 72 ?? ?? 99 8F 21 20 60 02 ?? ?? ?? ?? 21 30 20 02 1B 00 50 00 F4 01 00 02 08 00 00 10 12 10 00 00 ?? ?? 99 8F 08 00 42 34 ?? ?? ?? ?? 00 00 22 A6 16 00 03 24 00 00 43 AC 21 10 00 00 2C 00 BF 8F 28 00 B3 8F 24 00 B2 8F 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_230_0_0 {
	meta:
		name = "mallopt"
		size = 324
		refs = "0000 _gp_disp 0010 __malloc_lock 0014 _pthread_cleanup_push_defer 0020 __pthread_mutex_unlock 004c __pthread_mutex_lock 005c __malloc_state 0060 __malloc_consolidate 0118 _pthread_cleanup_pop_restore"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 C8 FF BD 27 ?? ?? 86 8F ?? ?? 99 8F 28 00 B0 AF 21 80 A0 00 ?? ?? 85 8F 30 00 B2 AF 18 00 B2 27 34 00 BF AF 10 00 BC AF 2C 00 B1 AF 21 88 80 00 ?? ?? ?? ?? 21 20 40 02 10 00 BC 8F ?? ?? 84 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F ?? ?? 84 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 04 00 24 26 06 00 82 2C 27 00 40 10 10 00 BC 8F ?? ?? 82 8F 80 20 04 00 ?? ?? 42 24 21 20 44 00 00 00 82 8C 21 10 5C 00 08 00 40 00 00 00 00 00 51 00 02 2E 1D 00 40 10 21 88 00 00 07 00 00 12 08 00 02 24 0B 00 10 26 10 00 03 2E 03 00 60 14 10 00 02 24 F8 FF 02 24 24 10 02 02 ?? ?? 83 8F 00 00 64 8C 03 00 84 30 25 10 44 00 0C 00 00 10 00 00 62 AC ?? ?? 82 8F 09 00 00 10 44 03 50 AC ?? ?? 82 8F 06 00 00 10 48 03 50 AC ?? ?? 82 8F 03 00 00 10 4C 03 50 AC ?? ?? 82 8F 54 03 50 AC 02 00 00 10 01 00 11 24 21 88 00 00 ?? ?? 99 8F 21 20 40 02 ?? ?? ?? ?? 01 00 05 24 34 00 BF 8F 21 10 20 02 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_231_0_0 {
	meta:
		name = "__GI_getnameinfo"
		size = 864
		refs = "0000 _gp_disp 000c __GI___errno_location 00d0 __GI_gethostbyaddr 00fc __GI_getdomainname 0124 __GI_strstr 0168 __GI_strncpy 01c0 __GI_uname 01e8 $LC2 0248 $LC0 0254 $LC1 025c __GI_getservbyport 0294 __GI_snprintf 0290 $LC3 0308 __GI_inet_ntop"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F 30 FE BD 27 10 00 BC AF C8 01 BE AF C4 01 B7 AF C0 01 B6 AF BC 01 B5 AF B8 01 B4 AF B4 01 B3 AF B0 01 B2 AF AC 01 B1 AF A8 01 B0 AF E8 01 B2 8F CC 01 BF AF 21 98 80 00 21 F0 A0 00 21 88 C0 00 21 80 E0 00 E0 01 B4 8F ?? ?? ?? ?? E4 01 B5 8F 21 B0 40 00 00 00 57 8C E0 FF 02 24 24 10 42 02 9F 00 40 14 10 00 BC 8F AD 00 60 12 FA FF 02 24 02 00 C2 2F 9C 00 40 14 01 00 03 24 00 00 62 96 05 00 43 10 02 00 03 24 97 00 43 14 10 00 DE 2F A3 00 C0 57 FA FF 02 24 59 00 20 12 00 00 00 00 57 00 00 12 01 00 03 24 3E 00 43 10 02 00 03 24 53 00 43 14 01 00 42 32 8E 00 40 14 08 00 42 32 ?? ?? 99 8F 04 00 64 26 04 00 05 24 ?? ?? ?? ?? 02 00 06 24 21 F0 40 00 85 00 40 10 10 00 BC 8F 04 00 42 32 2D 00 40 10 21 20 20 02 ?? ?? 99 8F 18 00 A6 27 21 20 C0 00 A0 01 A6 AF ?? ?? ?? ?? 00 01 05 24 10 00 BC 8F 23 00 40 14 A0 01 A6 8F 00 00 C3 8F ?? ?? 99 8F 21 28 C0 00 21 20 60 00 ?? ?? ?? ?? A0 01 A3 AF 10 00 BC 8F 1A 00 40 10 A0 01 A3 8F 19 00 43 10 21 20 20 02 FF FF 45 80 2E 00 04 24 15 00 A4 14 21 20 20 02 FF FF 47 24 23 10 E3 00 2B 30 02 02 ?? ?? 99 8F 0B 10 06 02 21 28 60 00 A0 01 A7 AF ?? ?? ?? ?? 21 30 40 00 00 00 C2 8F A0 01 A7 8F FF FF 03 26 10 00 BC 8F 23 38 E2 00 2B 10 67 00 0B 38 62 00 21 38 27 02 1B 00 00 10 00 00 E0 A0 21 20 20 02 14 00 00 10 00 00 C5 8F 01 00 42 32 0A 00 40 14 08 00 42 32 ?? ?? 99 8F ?? ?? ?? ?? 18 00 A4 27 04 00 40 14 10 00 BC 8F 21 20 20 02 09 00 00 10 59 00 A5 27 08 00 42 32 04 00 40 10 ?? ?? 85 8F 00 00 D7 AE 4F 00 00 10 FE FF 02 24 21 20 20 02 ?? ?? A5 24 ?? ?? 99 8F ?? ?? ?? ?? 21 30 00 02 10 00 BC 8F 29 00 80 12 00 00 00 00 27 00 A0 12 01 00 02 24 00 00 63 96 04 00 62 14 02 00 42 32 21 20 80 02 11 00 00 10 02 00 65 26 14 00 40 14 10 00 52 32 04 00 40 12 02 00 64 96 ?? ?? 85 8F 03 00 00 10 ?? ?? A5 24 ?? ?? 85 8F ?? ?? A5 24 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 08 00 40 10 10 00 BC 8F 00 00 45 8C 21 20 80 02 ?? ?? 99 8F ?? ?? ?? ?? 21 30 A0 02 0C 00 00 10 00 00 00 00 02 00 62 96 ?? ?? 86 8F ?? ?? 99 8F 00 3A 02 00 FF FF E7 30 02 12 02 00 21 20 80 02 21 28 A0 02 ?? ?? C6 24 ?? ?? ?? ?? 25 38 E2 00 04 00 20 12 00 00 00 00 02 00 00 12 21 80 30 02 FF FF 00 A2 06 00 80 52 00 00 D7 AE 04 00 A0 52 00 00 D7 AE 21 A0 95 02 FF FF 80 A2 00 00 D7 AE 11 00 00 10 21 10 00 00 0F 00 00 10 FF FF 02 24 0D 00 00 10 FA FF 02 24 08 00 42 32 B9 FF 40 14 ?? ?? 99 8F 02 00 04 24 04 00 65 26 21 30 20 02 ?? ?? ?? ?? 21 38 00 02 BB FF 40 14 10 00 BC 8F 00 00 D7 AE F5 FF 02 24 CC 01 BF 8F C8 01 BE 8F C4 01 B7 8F C0 01 B6 8F BC 01 B5 8F B8 01 B4 8F B4 01 B3 8F B0 01 B2 8F AC 01 B1 8F A8 01 B0 8F 08 00 E0 03 D0 01 BD 27 }
	condition:
		$1
}

rule file_232_0_0 {
	meta:
		name = "__GI_readdir_r"
		size = 344
		refs = "0000 _gp_disp 0010 _pthread_cleanup_push_defer 001c __pthread_mutex_unlock 0060 __pthread_mutex_lock 0070 __getdents 00b0 __GI___errno_location 00fc __GI_memcpy 011c _pthread_cleanup_pop_restore"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 B8 FF BD 27 ?? ?? 99 8F 3C 00 B4 AF 21 A0 A0 00 ?? ?? 85 8F 34 00 B2 AF 30 00 B1 AF 18 00 B2 27 18 00 91 24 10 00 BC AF 44 00 BF AF 40 00 B5 AF 38 00 B3 AF 2C 00 B0 AF 21 98 C0 00 21 80 80 00 21 30 20 02 ?? ?? ?? ?? 21 20 40 02 10 00 BC 8F 21 20 20 02 ?? ?? 99 8F ?? ?? ?? ?? 21 88 00 00 10 00 BC 8F ?? ?? 95 8F 08 00 03 8E 04 00 02 8E 2B 10 43 00 14 00 40 54 04 00 02 8E 00 00 04 8E 0C 00 05 8E 21 C8 A0 02 ?? ?? ?? ?? 14 00 06 8E 0A 00 40 1C 10 00 BC 8F 00 00 60 AE 1C 00 40 10 21 80 00 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 8C 16 00 00 10 10 00 BC 8F 08 00 02 AE 04 00 00 AE 04 00 02 8E 0C 00 11 8E 21 88 22 02 08 00 23 96 21 10 62 00 04 00 02 AE 04 00 22 8E 10 00 02 AE 00 00 22 8E E0 FF 40 50 08 00 03 8E ?? ?? 99 8F 08 00 26 96 21 20 80 02 ?? ?? ?? ?? 21 28 20 02 10 00 BC 8F 00 00 74 AE 21 80 00 00 ?? ?? 99 8F 21 20 40 02 ?? ?? ?? ?? 01 00 05 24 44 00 BF 8F 21 10 00 00 0A 10 11 02 40 00 B5 8F 3C 00 B4 8F 38 00 B3 8F 34 00 B2 8F 30 00 B1 8F 2C 00 B0 8F 08 00 E0 03 48 00 BD 27 }
	condition:
		$1
}

rule file_233_0_0 {
	meta:
		name = "__GI_isalpha"
		size = 40
		refs = "0000 _gp_disp 000c __GI___ctype_b"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F 40 20 04 00 00 00 42 8C 21 10 44 00 00 00 42 94 08 00 E0 03 04 00 42 30 }
	condition:
		$1
}

rule file_234_0_0 {
	meta:
		name = "__GI_setpriority"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 01 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_235_0_0 {
	meta:
		name = "lchown"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF B0 0F 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_236_0_0 {
	meta:
		name = "dysize"
		size = 68
	strings:
		$1 = { 03 00 83 30 0D 00 60 14 6D 01 02 24 64 00 02 24 1A 00 82 00 F4 01 40 00 10 18 00 00 07 00 60 14 6E 01 02 24 90 01 03 24 1A 00 83 00 F4 01 60 00 6D 01 05 24 10 30 00 00 0B 10 A6 00 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_237_0_0 {
	meta:
		name = "__GI_strcmp"
		size = 48
	strings:
		$1 = { 00 00 83 90 01 00 87 24 01 00 A6 24 03 00 60 14 00 00 A2 90 08 00 E0 03 23 10 02 00 21 20 E0 00 F7 FF 62 10 21 28 C0 00 08 00 E0 03 23 10 62 00 }
	condition:
		$1
}

rule file_238_0_0 {
	meta:
		name = "__GI_localtime"
		size = 60
		refs = "0000 _gp_disp 000c __time_tm 0010 __GI_localtime_r"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 85 8F ?? ?? 99 8F E0 FF BD 27 1C 00 BF AF 10 00 BC AF ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F 1C 00 BF 8F 20 00 BD 27 08 00 E0 03 ?? ?? 82 8F }
	condition:
		$1
}

rule file_239_0_0 {
	meta:
		name = "_ppfs_setargs"
		size = 416
	strings:
		$1 = { 18 00 86 8C 50 00 85 24 08 00 83 8C 47 00 C0 14 04 00 82 8C 00 80 06 3C 08 00 66 14 00 80 03 3C 4C 00 83 8C 04 00 66 24 4C 00 86 AC 00 00 63 8C 50 00 83 AC 08 00 83 AC 00 80 03 3C 08 00 43 14 21 10 00 00 4C 00 82 8C 04 00 43 24 4C 00 83 AC 00 00 42 8C 50 00 82 AC 04 00 82 AC 21 10 00 00 08 00 07 24 00 04 08 24 00 08 09 24 F8 FF 06 24 07 08 0A 24 02 00 0D 24 07 00 0E 24 1C 00 83 8C 2A 18 43 00 39 00 60 10 01 00 4F 24 0A 00 42 24 80 10 02 00 21 10 82 00 00 00 42 8C 21 00 47 10 09 00 58 28 09 00 00 13 4C 00 83 8C 18 00 4D 10 03 00 58 28 17 00 00 57 04 00 62 24 0C 00 4E 50 07 00 63 24 13 00 00 10 04 00 62 24 10 00 48 10 01 04 58 28 0F 00 00 57 04 00 62 24 04 00 49 50 07 00 63 24 0B 00 4A 54 04 00 62 24 07 00 63 24 24 18 66 00 08 00 62 24 4C 00 82 AC 00 00 62 8C 04 00 63 8C 00 00 A2 AC 05 00 00 10 04 00 A3 AC 04 00 62 24 4C 00 82 AC 00 00 62 8C 00 00 A2 AC 08 00 A5 24 D5 FF 00 10 21 10 E0 01 00 80 06 3C 07 00 66 14 00 80 03 3C 24 00 83 90 C0 18 03 00 21 18 A3 00 F8 FF 63 8C 08 00 83 AC 00 80 03 3C 07 00 43 54 08 00 82 8C 25 00 82 90 C0 10 02 00 21 28 A2 00 F8 FF A2 8C 04 00 82 AC 08 00 82 8C 09 00 41 04 23 10 02 00 08 00 82 AC 10 00 82 8C FE FF 03 24 24 10 62 00 08 00 42 34 10 00 82 AC 20 00 02 24 14 00 82 AC 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_241_0_0 {
	meta:
		name = "hsearch"
		size = 72
		refs = "0000 _gp_disp 0010 __GI_hsearch_r"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F ?? ?? 99 8F D0 FF BD 27 ?? ?? 42 24 2C 00 BF AF 18 00 BC AF 30 00 A4 AF 34 00 A5 AF 10 00 A2 AF ?? ?? ?? ?? 20 00 A7 27 2C 00 BF 8F 20 00 A2 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_242_0_0 {
	meta:
		name = "putw"
		size = 68
		refs = "0000 _gp_disp 000c __GI_fwrite_unlocked"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F E0 FF BD 27 21 38 A0 00 04 00 05 24 1C 00 BF AF 10 00 BC AF 20 00 A4 AF 01 00 06 24 ?? ?? ?? ?? 20 00 A4 27 1C 00 BF 8F FF FF 42 24 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_243_0_0 {
	meta:
		name = "__GI_tcsetattr"
		size = 404
		refs = "0000 _gp_disp 0054 __GI___errno_location 0084 __GI_memcpy 00d0 __GI_ioctl"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 A0 FF BD 27 0F 54 02 24 10 00 BC AF 54 00 B5 AF 40 00 B0 AF 5C 00 BF AF 58 00 B6 AF 50 00 B4 AF 4C 00 B3 AF 48 00 B2 AF 44 00 B1 AF 21 A8 80 00 0F 00 A2 10 21 80 C0 00 10 54 02 24 08 00 A2 10 0E 54 02 24 08 00 A2 10 ?? ?? 99 8F ?? ?? ?? ?? FF FF 11 24 16 00 03 24 40 00 00 10 00 00 43 AC 04 00 00 10 10 54 12 24 02 00 00 10 0E 54 12 24 0F 54 12 24 00 00 02 8E ?? ?? 99 8F 29 00 A4 27 00 F0 42 7C 18 00 A2 AF 04 00 02 8E 11 00 05 26 17 00 06 24 1C 00 A2 AF 08 00 02 8E 18 00 B4 27 20 00 A2 AF 0C 00 02 8E 24 00 A2 AF 10 00 02 92 ?? ?? ?? ?? 28 00 A2 A3 10 00 BC 8F 21 20 A0 02 21 28 40 02 ?? ?? 93 8F 21 C8 60 02 ?? ?? ?? ?? 21 30 80 02 21 88 40 00 20 00 40 14 10 00 BC 8F 0E 54 02 24 03 00 42 12 ?? ?? 99 8F 1B 00 00 10 21 88 00 00 ?? ?? ?? ?? 00 00 00 00 21 20 A0 02 0D 54 05 24 21 30 80 02 21 C8 60 02 21 90 40 00 ?? ?? ?? ?? 00 00 56 8C 03 00 40 50 08 00 03 8E 0E 00 00 10 00 00 56 AE 20 00 A2 8F 26 10 62 00 80 01 44 30 07 00 80 54 16 00 02 24 30 00 63 30 06 00 60 10 21 88 00 00 30 00 42 30 03 00 40 10 16 00 02 24 00 00 42 AE FF FF 11 24 5C 00 BF 8F 21 10 20 02 58 00 B6 8F 54 00 B5 8F 50 00 B4 8F 4C 00 B3 8F 48 00 B2 8F 44 00 B1 8F 40 00 B0 8F 08 00 E0 03 60 00 BD 27 }
	condition:
		$1
}

rule file_244_0_0 {
	meta:
		name = "__GI_fseeko64"
		size = 348
		refs = "0000 _gp_disp 003c __GI___errno_location 0060 _pthread_cleanup_push_defer 0064 __pthread_mutex_unlock 007c __pthread_mutex_lock 0098 __stdio_wcommit 00ac __stdio_adjust_position 00dc __stdio_seek 012c _pthread_cleanup_pop_restore"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 B8 FF BD 27 38 00 B1 AF 58 00 B1 8F 10 00 BC AF 44 00 BF AF 03 00 22 2E 40 00 B3 AF 3C 00 B2 AF 34 00 B0 AF 28 00 A6 AF 07 00 40 14 2C 00 A7 AF ?? ?? 99 8F ?? ?? ?? ?? FF FF 10 24 16 00 03 24 3B 00 00 10 00 00 43 AC 34 00 92 8C 0C 00 40 16 21 80 80 00 ?? ?? 99 8F ?? ?? 85 8F 38 00 93 24 21 30 60 02 ?? ?? ?? ?? 18 00 A4 27 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 60 02 10 00 BC 8F 00 00 02 96 40 00 42 30 06 00 40 14 ?? ?? 99 8F 01 00 02 24 0E 00 22 16 28 00 B3 27 07 00 00 10 ?? ?? 99 8F ?? ?? ?? ?? 21 20 00 02 F8 FF 40 10 10 00 BC 8F 18 00 00 10 FF FF 10 24 21 20 00 02 ?? ?? ?? ?? 21 28 60 02 FA FF 40 04 10 00 BC 8F ?? ?? 99 8F 21 20 00 02 21 28 60 02 ?? ?? ?? ?? 21 30 20 02 F3 FF 40 04 10 00 BC 8F 00 00 02 96 2C 00 00 AE 02 00 00 A2 B8 FF 42 30 00 00 02 A6 08 00 02 8E 10 00 02 AE 14 00 02 AE 18 00 02 AE 1C 00 02 AE 21 80 00 00 06 00 40 16 44 00 BF 8F ?? ?? 99 8F 18 00 A4 27 ?? ?? ?? ?? 01 00 05 24 44 00 BF 8F 21 10 00 02 40 00 B3 8F 3C 00 B2 8F 38 00 B1 8F 34 00 B0 8F 08 00 E0 03 48 00 BD 27 }
	condition:
		$1
}

rule file_245_0_0 {
	meta:
		name = "__fpurge"
		size = 48
	strings:
		$1 = { 08 00 82 8C 28 00 80 AC 2C 00 80 AC 18 00 82 AC 1C 00 82 AC 10 00 82 AC 14 00 82 AC 00 00 82 94 02 00 80 A0 BC FF 42 30 08 00 E0 03 00 00 82 A4 }
	condition:
		$1
}

rule file_248_0_0 {
	meta:
		name = "wctomb"
		size = 36
		refs = "0000 _gp_disp 0010 __GI_wcrtomb"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 03 00 80 10 ?? ?? 99 8F ?? ?? ?? ?? 21 30 00 00 08 00 E0 03 21 10 00 00 }
	condition:
		$1
}

rule file_250_0_0 {
	meta:
		name = "gets"
		size = 252
		refs = "0000 _gp_disp 0014 stdin 0044 _pthread_cleanup_push_defer 0048 __pthread_mutex_unlock 0060 __pthread_mutex_lock 0070 __GI_getchar_unlocked 00c4 _pthread_cleanup_pop_restore"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 B8 FF BD 27 2C 00 B0 AF ?? ?? 90 8F 30 00 B1 AF 10 00 BC AF 44 00 BF AF 40 00 B5 AF 3C 00 B4 AF 38 00 B3 AF 34 00 B2 AF 00 00 06 8E 34 00 D2 8C 0C 00 40 16 21 88 80 00 ?? ?? 99 8F ?? ?? 85 8F 18 00 A4 27 ?? ?? ?? ?? 38 00 C6 24 10 00 BC 8F 00 00 04 8E ?? ?? 99 8F ?? ?? ?? ?? 38 00 84 24 10 00 BC 8F ?? ?? 93 8F 21 80 20 02 FF FF 15 24 0A 00 14 24 21 C8 60 02 ?? ?? ?? ?? 00 00 00 00 03 00 55 14 10 00 BC 8F 09 00 00 10 21 88 00 00 20 14 02 7C 03 00 54 10 00 00 02 A2 F5 FF 00 10 01 00 10 26 02 00 30 52 21 88 00 00 00 00 00 A2 06 00 40 16 44 00 BF 8F ?? ?? 99 8F 18 00 A4 27 ?? ?? ?? ?? 01 00 05 24 44 00 BF 8F 21 10 20 02 40 00 B5 8F 3C 00 B4 8F 38 00 B3 8F 34 00 B2 8F 30 00 B1 8F 2C 00 B0 8F 08 00 E0 03 48 00 BD 27 }
	condition:
		$1
}

rule file_251_0_0 {
	meta:
		name = "wcpncpy"
		size = 52
	strings:
		$1 = { 21 38 80 00 21 18 A0 00 07 00 C0 10 04 00 68 24 00 00 62 8C 04 00 E7 24 FC FF E2 AC 0B 18 02 01 F9 FF 00 10 FF FF C6 24 23 10 65 00 08 00 E0 03 21 10 82 00 }
	condition:
		$1
}

rule file_252_0_0 {
	meta:
		name = "__GI_isblank"
		size = 40
		refs = "0000 _gp_disp 000c __GI___ctype_b"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F 40 20 04 00 00 00 42 8C 21 10 44 00 00 00 42 94 08 00 E0 03 00 01 42 30 }
	condition:
		$1
}

rule file_254_0_0 {
	meta:
		name = "putwchar"
		size = 84
		refs = "0000 _gp_disp 000c stdout 0030 __GI___fputc_unlocked 0048 __GI_fputc"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 83 8F 00 00 65 8C 34 00 A3 8C 0B 00 60 10 21 10 80 00 10 00 A3 8C 1C 00 A6 8C 2B 30 66 00 07 00 C0 10 ?? ?? 99 8F 01 00 64 24 10 00 A4 AC 00 00 62 A0 08 00 E0 03 FF 00 42 30 ?? ?? 99 8F 08 00 20 03 00 00 00 00 }
	condition:
		$1
}

rule file_255_0_0 {
	meta:
		name = "setbuf"
		size = 32
		refs = "0000 _gp_disp 000c __GI_setvbuf"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F 02 00 06 24 0B 30 05 00 ?? ?? ?? ?? 00 10 07 24 }
	condition:
		$1
}

rule file_257_0_0 {
	meta:
		name = "tee"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF D2 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_258_0_0 {
	meta:
		name = "symlink"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF F3 0F 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_259_0_0 {
	meta:
		name = "__GI_sigsetmask"
		size = 76
		refs = "0000 _gp_disp 0010 __GI_sigprocmask"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 C0 FF BD 27 ?? ?? 99 8F 28 00 A5 27 10 00 BC AF 3C 00 BF AF 18 00 A6 27 04 00 A0 AC 08 00 A0 AC 0C 00 A0 AC 28 00 A4 AF ?? ?? ?? ?? 03 00 04 24 3C 00 BF 8F 18 00 A2 8F 08 00 E0 03 40 00 BD 27 }
	condition:
		$1
}

rule file_260_0_0 {
	meta:
		name = "__GI_wmemcpy"
		size = 44
	strings:
		$1 = { 21 10 80 00 21 18 80 00 06 00 C0 10 FF FF C6 24 00 00 A4 8C 04 00 A5 24 00 00 64 AC FA FF 00 10 04 00 63 24 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_261_0_0 {
	meta:
		name = "__GI_xdr_pmap"
		size = 176
		refs = "0000 _gp_disp 0014 __GI_xdr_u_long"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D8 FF BD 27 18 00 B0 AF ?? ?? 90 8F 20 00 B2 AF 1C 00 B1 AF 10 00 BC AF 24 00 BF AF 21 C8 00 02 21 90 80 00 ?? ?? ?? ?? 21 88 A0 00 17 00 40 10 24 00 BF 8F 21 20 40 02 21 C8 00 02 ?? ?? ?? ?? 04 00 25 26 11 00 40 10 24 00 BF 8F 21 20 40 02 21 C8 00 02 ?? ?? ?? ?? 08 00 25 26 0A 00 40 10 10 00 BC 8F 24 00 BF 8F 21 20 40 02 0C 00 25 26 20 00 B2 8F 1C 00 B1 8F 21 C8 00 02 18 00 B0 8F ?? ?? ?? ?? 28 00 BD 27 24 00 BF 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 21 10 00 00 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_262_0_0 {
	meta:
		name = "__GI_sigblock"
		size = 76
		refs = "0000 _gp_disp 0010 __GI_sigprocmask"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 C0 FF BD 27 ?? ?? 99 8F 28 00 A5 27 10 00 BC AF 3C 00 BF AF 18 00 A6 27 04 00 A0 AC 08 00 A0 AC 0C 00 A0 AC 28 00 A4 AF ?? ?? ?? ?? 01 00 04 24 3C 00 BF 8F 18 00 A2 8F 08 00 E0 03 40 00 BD 27 }
	condition:
		$1
}

rule file_263_0_0 {
	meta:
		name = "__GI_dirfd"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 18 00 B0 AF 00 00 90 8C 10 00 BC AF FF FF 02 24 1C 00 BF AF 07 00 02 16 1C 00 BF 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 09 00 03 24 00 00 43 AC 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_264_0_0 {
	meta:
		name = "ftime"
		size = 132
		refs = "0000 _gp_disp 000c __GI_gettimeofday"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F D0 FF BD 27 18 00 A5 27 28 00 B0 AF 10 00 BC AF 2C 00 BF AF 21 80 80 00 ?? ?? ?? ?? 20 00 A4 27 0F 00 40 04 20 00 A2 8F 24 00 A3 8F 00 00 02 AE E7 03 63 24 E8 03 02 24 1A 00 62 00 F4 01 40 00 12 10 00 00 04 00 02 A6 18 00 A2 8F 06 00 02 A6 1C 00 A2 8F 08 00 02 A6 02 00 00 10 21 10 00 00 FF FF 02 24 2C 00 BF 8F 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_265_0_0 {
	meta:
		name = "__libc_pselect"
		size = 236
		refs = "0000 _gp_disp 0068 __GI_sigprocmask 0088 __GI_select"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 A8 FF BD 27 40 00 B0 AF 68 00 B0 8F 18 00 BC AF 50 00 B4 AF 4C 00 B3 AF 48 00 B2 AF 44 00 B1 AF 54 00 BF AF 21 A0 80 00 21 98 A0 00 21 90 C0 00 09 00 00 12 6C 00 B1 8F 00 00 02 8E 04 00 03 8E 30 00 A2 AF E8 03 02 24 1A 00 62 00 F4 01 40 00 12 10 00 00 34 00 A2 AF 08 00 20 12 ?? ?? 99 8F 38 00 A7 AF 03 00 04 24 21 28 20 02 ?? ?? ?? ?? 20 00 A6 27 18 00 BC 8F 38 00 A7 8F ?? ?? 99 8F 30 00 A2 27 0A 10 10 00 10 00 A2 AF 21 20 80 02 21 28 60 02 ?? ?? ?? ?? 21 30 40 02 21 80 40 00 06 00 20 12 18 00 BC 8F ?? ?? 99 8F 03 00 04 24 20 00 A5 27 ?? ?? ?? ?? 21 30 00 00 54 00 BF 8F 21 10 00 02 50 00 B4 8F 4C 00 B3 8F 48 00 B2 8F 44 00 B1 8F 40 00 B0 8F 08 00 E0 03 58 00 BD 27 }
	condition:
		$1
}

rule file_268_1_0 {
	meta:
		name = "_stdio_term"
		size = 268
		refs = "0000 _gp_disp 0014 __stdio_init_mutex 0018 _stdio_openlist_add_lock 004c _stdio_openlist_del_lock 005c _stdio_openlist 006c __pthread_mutex_trylock 00bc __stdio_wcommit"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 C8 FF BD 27 20 00 B1 AF ?? ?? 91 8F ?? ?? 84 8F 10 00 BC AF 34 00 BF AF 30 00 B5 AF 2C 00 B4 AF 28 00 B3 AF 1C 00 B0 AF 21 C8 20 02 24 00 B2 AF ?? ?? ?? ?? 30 00 14 24 10 00 BC 8F 21 C8 20 02 ?? ?? 84 8F ?? ?? ?? ?? 01 00 15 24 10 00 BC 8F ?? ?? 82 8F 00 00 50 8C 21 98 40 00 13 00 00 12 ?? ?? 99 8F 38 00 12 26 ?? ?? ?? ?? 21 20 40 02 08 00 40 50 34 00 15 AE 08 00 02 8E 00 00 14 A6 18 00 02 AE 1C 00 02 AE 10 00 02 AE 14 00 02 AE 34 00 15 AE 21 C8 20 02 ?? ?? ?? ?? 21 20 40 02 10 00 BC 8F ED FF 00 10 20 00 10 8E 00 00 70 8E ?? ?? 91 8F 0A 00 00 12 34 00 BF 8F 00 00 02 96 40 00 42 30 FB FF 40 50 20 00 10 8E 21 C8 20 02 ?? ?? ?? ?? 21 20 00 02 F6 FF 00 10 20 00 10 8E 30 00 B5 8F 2C 00 B4 8F 28 00 B3 8F 24 00 B2 8F 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_268_2_0 {
	meta:
		name = "_stdio_init"
		size = 168
		refs = "0000 _gp_disp 000c __GI___errno_location 003c __GI_isatty"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F D8 FF BD 27 10 00 BC AF 24 00 BF AF 20 00 B2 AF 1C 00 B1 AF 18 00 B0 AF ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F 21 20 00 00 21 80 40 00 ?? ?? 91 8F 21 C8 20 02 ?? ?? ?? ?? 00 00 52 8C 10 00 BC 8F 05 00 40 14 21 C8 20 02 ?? ?? 82 8F ?? ?? 43 94 00 01 63 38 ?? ?? 43 A4 ?? ?? ?? ?? 01 00 04 24 06 00 40 14 10 00 BC 8F ?? ?? 82 8F ?? ?? 42 24 50 00 43 94 00 01 63 38 50 00 43 A4 00 00 12 AE 24 00 BF 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_270_0_0 {
	meta:
		name = "__get_hosts_byname_r"
		size = 100
		refs = "0000 _gp_disp 0018 __read_etc_hosts_r"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 C8 FF BD 27 21 18 80 00 48 00 A4 8F ?? ?? 99 8F 21 10 A0 00 18 00 A4 AF 4C 00 A4 8F 34 00 BF AF 28 00 BC AF 1C 00 A4 AF 50 00 A4 8F 10 00 A6 AF 14 00 A7 AF 20 00 A4 AF 21 28 60 00 21 20 00 00 21 30 40 00 ?? ?? ?? ?? 21 38 00 00 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_271_0_0 {
	meta:
		name = "__get_hosts_byaddr_r"
		size = 188
		refs = "0000 _gp_disp 0028 __GI_inet_ntop 006c __read_etc_hosts_r"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 02 00 02 24 26 00 C2 14 21 18 80 00 04 00 04 24 25 00 A4 14 21 10 00 00 B0 FF BD 27 ?? ?? 99 8F 44 00 B0 AF 30 00 B0 27 4C 00 BF AF 48 00 B1 AF 28 00 BC AF 21 28 60 00 21 88 E0 00 21 30 00 02 02 00 04 24 ?? ?? ?? ?? 10 00 07 24 60 00 A2 8F 28 00 BC 8F 10 00 B1 AF 14 00 A2 AF 64 00 A2 8F ?? ?? 99 8F 21 28 00 02 18 00 A2 AF 68 00 A2 8F 21 20 00 00 02 00 06 24 1C 00 A2 AF 6C 00 A2 8F 02 00 07 24 ?? ?? ?? ?? 20 00 A2 AF 4C 00 BF 8F 48 00 B1 8F 44 00 B0 8F 03 00 00 10 50 00 BD 27 08 00 E0 03 21 10 00 00 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_273_0_0 {
	meta:
		name = "_dl_aux_init"
		size = 40
		refs = "0000 _gp_disp 0010 _dl_phdr 001c _dl_phnum"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 1C 00 83 8C ?? ?? 82 8F 00 00 43 AC 2C 00 83 8C ?? ?? 82 8F 08 00 E0 03 00 00 43 AC }
	condition:
		$1
}

rule file_274_0_0 {
	meta:
		name = "__wcstofpmax"
		size = 1168
		refs = "0000 _gp_disp 0014 __GI_iswspace 0098 __GI___ctype_b 0094 $LC0 0108 __muldf3 0148 __floatsidf 0164 __adddf3 0234 __divdf3 02d4 __eqdf2 03f8 $LC1 0438 __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 A8 FF BD 27 34 00 B1 AF ?? ?? 91 8F 44 00 B5 AF 3C 00 B3 AF 38 00 B2 AF 10 00 BC AF 54 00 BF AF 50 00 BE AF 4C 00 B7 AF 48 00 B6 AF 40 00 B4 AF 30 00 B0 AF 21 98 80 00 5C 00 A5 AF 21 90 C0 00 21 A8 80 00 00 00 B0 8E 21 C8 20 02 ?? ?? ?? ?? 21 20 00 02 03 00 40 10 10 00 BC 8F F9 FF 00 10 04 00 B5 26 2B 00 02 24 05 00 02 12 2D 00 02 24 05 00 02 56 21 A0 00 00 02 00 00 10 01 00 14 24 21 A0 00 00 04 00 B5 26 ?? ?? 82 8F ?? ?? 8B 8F FF FF 1E 24 ?? ?? 50 8C ?? ?? 51 8C 21 48 00 00 21 B8 00 00 21 B0 00 00 FF FF 0C 24 30 00 0D 24 2E 00 0E 24 00 00 A8 8E 00 00 65 8D 40 10 08 00 21 10 A2 00 00 00 42 94 08 00 42 30 30 00 40 10 00 00 00 00 03 00 CC 13 00 00 00 00 04 00 C0 57 01 00 DE 27 28 00 0D 11 21 F0 00 00 01 00 DE 27 12 00 C2 2B EF FF 40 50 04 00 B5 26 ?? ?? 99 8F 21 28 E0 02 1C 00 A9 AF 20 00 AB AF 24 00 AC AF 28 00 AD AF 2C 00 AE AF 21 20 A0 00 21 30 00 02 21 28 C0 02 21 38 20 02 ?? ?? ?? ?? 18 00 A8 AF 10 00 BC 8F 18 00 A8 8F 21 B0 40 00 ?? ?? 99 8F D0 FF 04 25 ?? ?? ?? ?? 21 B8 60 00 10 00 BC 8F 21 20 C0 02 21 28 E0 02 ?? ?? 99 8F 21 30 40 00 ?? ?? ?? ?? 21 38 60 00 10 00 BC 8F 1C 00 A9 8F 20 00 AB 8F 24 00 AC 8F 28 00 AD 8F 2C 00 AE 8F 21 B8 40 00 21 B0 60 00 CA FF 00 10 04 00 B5 26 06 00 0E 15 FF FF 02 24 3B 00 20 15 00 00 00 00 04 00 B5 26 C3 FF 00 10 21 48 A0 02 38 00 C2 17 12 00 C2 2B A3 00 20 15 5C 00 B9 8F ?? ?? 84 8F 21 80 00 00 ?? ?? 84 24 21 18 80 00 21 10 00 00 01 00 05 26 80 30 02 00 21 30 A6 02 00 00 C7 8C 21 30 A2 00 21 30 C4 00 00 00 C6 80 20 00 E7 34 1C 00 E6 14 21 88 60 00 01 00 42 24 21 30 A2 00 21 30 C4 00 00 00 C6 80 F3 FF C0 14 80 30 02 00 ?? ?? 99 8F ?? ?? ?? ?? 21 20 00 02 10 00 BC 8F 21 20 40 00 21 28 60 00 ?? ?? 99 8F 21 30 00 00 ?? ?? ?? ?? 21 38 00 00 21 B8 40 00 03 00 80 12 21 B0 60 00 00 80 16 3C 26 B0 C3 02 21 80 30 02 00 00 13 82 80 98 13 00 F8 FF 73 26 78 00 00 10 21 98 B3 02 21 10 03 02 00 00 42 80 21 80 02 02 21 10 03 02 00 00 42 80 D5 FF 40 14 21 10 00 00 70 00 00 10 5C 00 B9 8F 6D 00 C2 13 12 00 C2 2B 03 00 40 14 21 98 A0 02 EF FF DE 27 21 90 5E 02 03 00 20 11 23 48 35 01 83 48 09 00 21 90 49 02 03 00 80 12 20 00 08 35 00 80 02 3C 26 B0 56 00 65 00 02 24 22 00 02 15 ?? ?? 99 8F 04 00 A2 8E 2B 00 03 24 06 00 43 10 2D 00 03 24 05 00 43 50 FF FF 04 24 04 00 B3 26 03 00 00 10 01 00 04 24 01 00 04 24 08 00 B3 26 21 10 60 02 21 18 00 00 0A 00 08 24 00 00 46 8C 40 38 06 00 21 38 A7 00 00 00 E7 94 08 00 E7 30 08 00 E0 50 26 98 53 00 55 01 67 28 F7 FF E0 10 04 00 42 24 02 38 68 70 D0 FF C6 24 F3 FF 00 10 21 18 E6 00 0A 10 B3 02 21 98 40 00 02 10 83 70 21 90 52 00 ?? ?? 99 8F 21 20 E0 02 21 28 C0 02 21 30 00 00 ?? ?? ?? ?? 21 38 00 00 36 00 40 10 10 00 BC 8F C3 17 12 00 26 A8 52 00 23 A8 A2 02 ?? ?? 82 8F ?? ?? 50 8C ?? ?? 51 8C 19 00 A0 12 01 00 A2 32 0D 00 40 10 ?? ?? 99 8F 03 00 41 06 21 20 E0 02 01 00 00 10 ?? ?? 99 8F 21 28 C0 02 21 30 00 02 09 F8 20 03 21 38 20 02 10 00 BC 8F 21 B8 40 00 21 B0 60 00 ?? ?? 99 8F 21 20 00 02 21 28 20 02 21 30 00 02 ?? ?? ?? ?? 21 38 20 02 43 A8 15 00 10 00 BC 8F 21 80 40 00 E7 FF 00 10 21 88 60 00 ?? ?? 82 8F ?? ?? 99 8F 21 20 E0 02 ?? ?? 46 8C ?? ?? 47 8C ?? ?? ?? ?? 21 28 C0 02 10 00 BC 8F 21 20 E0 02 21 28 C0 02 ?? ?? 99 8F 21 30 40 00 ?? ?? ?? ?? 21 38 60 00 06 00 40 14 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 22 00 03 24 00 00 43 AC 5C 00 B9 8F 01 00 20 57 00 00 33 AF 54 00 BF 8F 21 10 E0 02 21 18 C0 02 50 00 BE 8F 4C 00 B7 8F 48 00 B6 8F 44 00 B5 8F 40 00 B4 8F 3C 00 B3 8F 38 00 B2 8F 34 00 B1 8F 30 00 B0 8F 08 00 E0 03 58 00 BD 27 }
	condition:
		$1
}

rule file_275_0_0 {
	meta:
		name = "readahead"
		size = 104
		refs = "0000 _gp_disp 0040 __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 21 28 00 00 30 00 A2 8F E0 FF BD 27 10 00 A2 AF 7F 10 02 24 0C 00 00 00 20 00 BD 27 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_276_0_0 {
	meta:
		name = "delete_module"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 21 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_278_0_0 {
	meta:
		name = "__GI_mbsrtowcs"
		size = 72
		refs = "0000 _gp_disp 0028 __GI_mbsnrtowcs"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D8 FF BD 27 18 00 BC AF 24 00 BF AF 03 00 E0 14 21 10 C0 00 ?? ?? 87 8F ?? ?? E7 24 ?? ?? 99 8F 10 00 A7 AF FF FF 06 24 ?? ?? ?? ?? 21 38 40 00 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_279_0_0 {
	meta:
		name = "__GI_ctime"
		size = 60
		refs = "0000 _gp_disp 000c __GI_localtime 0030 __GI_asctime"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F E0 FF BD 27 10 00 BC AF 1C 00 BF AF ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F 1C 00 BF 8F 21 20 40 00 ?? ?? 99 8F ?? ?? ?? ?? 20 00 BD 27 }
	condition:
		$1
}

rule file_68_0_1 {
	meta:
		name = "ilogbf"
		size = 64
		refs = "0000 _gp_disp 000c __extendsfdf2 0030 __GI_ilogb"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F E0 FF BD 27 10 00 BC AF 1C 00 BF AF ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F 1C 00 BF 8F 21 20 40 00 ?? ?? 99 8F 21 28 60 00 ?? ?? ?? ?? 20 00 BD 27 }
	condition:
		$1
}

rule file_60_0_1 {
	meta:
		name = "llrintf"
		size = 64
		refs = "0000 _gp_disp 000c __extendsfdf2 0030 __GI_llrint"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F E0 FF BD 27 10 00 BC AF 1C 00 BF AF ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F 1C 00 BF 8F 21 20 40 00 ?? ?? 99 8F 21 28 60 00 ?? ?? ?? ?? 20 00 BD 27 }
	condition:
		$1
}

rule file_72_0_1 {
	meta:
		name = "llroundf"
		size = 64
		refs = "0000 _gp_disp 000c __extendsfdf2 0030 __GI_llround"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F E0 FF BD 27 10 00 BC AF 1C 00 BF AF ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F 1C 00 BF 8F 21 20 40 00 ?? ?? 99 8F 21 28 60 00 ?? ?? ?? ?? 20 00 BD 27 }
	condition:
		$1
}

rule file_75_0_1 {
	meta:
		name = "lrintf"
		size = 64
		refs = "0000 _gp_disp 000c __extendsfdf2 0030 __GI_lrint"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F E0 FF BD 27 10 00 BC AF 1C 00 BF AF ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F 1C 00 BF 8F 21 20 40 00 ?? ?? 99 8F 21 28 60 00 ?? ?? ?? ?? 20 00 BD 27 }
	condition:
		$1
}

rule file_0_0_1 {
	meta:
		name = "lroundf"
		size = 64
		refs = "0000 _gp_disp 000c __extendsfdf2 0030 __GI_lround"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F E0 FF BD 27 10 00 BC AF 1C 00 BF AF ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F 1C 00 BF 8F 21 20 40 00 ?? ?? 99 8F 21 28 60 00 ?? ?? ?? ?? 20 00 BD 27 }
	condition:
		$1
}

rule file_280_0_0 {
	meta:
		name = "socketpair"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 58 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_281_0_0 {
	meta:
		name = "sched_get_priority_max"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 43 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_282_0_0 {
	meta:
		name = "capget"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 6C 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_283_0_0 {
	meta:
		name = "__GI_close"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF A6 0F 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_284_0_0 {
	meta:
		name = "__GI_lstat64"
		size = 120
		refs = "0000 _gp_disp 0034 __GI___errno_location 0054 __xstat64_conv"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 78 FF BD 27 10 00 BC AF 21 30 A0 00 84 00 BF AF 80 00 B0 AF 18 00 A5 27 76 10 02 24 0C 00 00 00 07 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC 07 00 00 10 FF FF 10 24 06 00 40 14 84 00 BF 8F ?? ?? 99 8F 18 00 A4 27 ?? ?? ?? ?? 21 28 C0 00 84 00 BF 8F 21 10 00 02 80 00 B0 8F 08 00 E0 03 88 00 BD 27 }
	condition:
		$1
}

rule file_285_0_0 {
	meta:
		name = "__GI_fwrite"
		size = 200
		refs = "0000 _gp_disp 0040 _pthread_cleanup_push_defer 0044 __pthread_mutex_unlock 0060 __pthread_mutex_lock 0074 __GI_fwrite_unlocked 0090 _pthread_cleanup_pop_restore"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 B8 FF BD 27 40 00 B4 AF 3C 00 B3 AF 38 00 B2 AF 10 00 BC AF 44 00 BF AF 34 00 B1 AF 30 00 B0 AF 34 00 F0 8C 21 A0 80 00 21 98 A0 00 0E 00 00 16 21 90 C0 00 ?? ?? 99 8F ?? ?? 85 8F 38 00 F1 24 28 00 A7 AF 18 00 A4 27 ?? ?? ?? ?? 21 30 20 02 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 20 02 10 00 BC 8F 28 00 A7 8F ?? ?? 99 8F 21 20 80 02 21 28 60 02 ?? ?? ?? ?? 21 30 40 02 07 00 00 16 10 00 BC 8F ?? ?? 99 8F 28 00 A2 AF 18 00 A4 27 ?? ?? ?? ?? 01 00 05 24 28 00 A2 8F 44 00 BF 8F 40 00 B4 8F 3C 00 B3 8F 38 00 B2 8F 34 00 B1 8F 30 00 B0 8F 08 00 E0 03 48 00 BD 27 }
	condition:
		$1
}

rule file_435_0_0 {
	meta:
		name = "__GI_fread"
		size = 200
		refs = "0000 _gp_disp 0040 _pthread_cleanup_push_defer 0044 __pthread_mutex_unlock 0060 __pthread_mutex_lock 0074 __GI_fread_unlocked 0090 _pthread_cleanup_pop_restore"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 B8 FF BD 27 40 00 B4 AF 3C 00 B3 AF 38 00 B2 AF 10 00 BC AF 44 00 BF AF 34 00 B1 AF 30 00 B0 AF 34 00 F0 8C 21 A0 80 00 21 98 A0 00 0E 00 00 16 21 90 C0 00 ?? ?? 99 8F ?? ?? 85 8F 38 00 F1 24 28 00 A7 AF 18 00 A4 27 ?? ?? ?? ?? 21 30 20 02 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 20 02 10 00 BC 8F 28 00 A7 8F ?? ?? 99 8F 21 20 80 02 21 28 60 02 ?? ?? ?? ?? 21 30 40 02 07 00 00 16 10 00 BC 8F ?? ?? 99 8F 28 00 A2 AF 18 00 A4 27 ?? ?? ?? ?? 01 00 05 24 28 00 A2 8F 44 00 BF 8F 40 00 B4 8F 3C 00 B3 8F 38 00 B2 8F 34 00 B1 8F 30 00 B0 8F 08 00 E0 03 48 00 BD 27 }
	condition:
		$1
}

rule file_286_0_0 {
	meta:
		name = "__GI_recvfrom"
		size = 108
		refs = "0000 _gp_disp 0044 __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 18 00 B0 AF 1C 00 BF AF 34 00 B0 8F 30 00 A2 8F E0 FF BD 27 10 00 A2 AF 14 00 B0 AF 50 10 02 24 0C 00 00 00 20 00 BD 27 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_287_0_0 {
	meta:
		name = "statvfs64"
		size = 936
		refs = "0000 _gp_disp 000c __GI_statfs64 0060 __GI_memset 00ec __GI_stat64 0114 __GI___errno_location 0134 __GI_setmntent 012c $LC0 0144 $LC1 0154 $LC2 0174 __GI_getmntent_r 01e0 $LC11 01e4 $LC3 01e8 $LC4 01fc __GI_strsep 0218 __GI_strcmp 0264 $LC5 028c $LC6 02b4 $LC7 02dc $LC8 0304 $LC9 032c $LC10 0358 __GI_endmntent"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F 00 FA BD 27 10 00 BC AF DC 05 B1 AF D8 05 B0 AF FC 05 BF AF F8 05 BE AF F4 05 B7 AF F0 05 B6 AF EC 05 B5 AF E8 05 B4 AF E4 05 B3 AF E0 05 B2 AF 21 88 A0 00 58 05 A5 27 ?? ?? ?? ?? 21 80 80 00 C6 00 40 04 10 00 BC 8F 5C 05 A2 8F 6C 05 A3 8F ?? ?? 99 8F 00 00 22 AE 04 00 22 AE 68 05 A2 8F 0C 00 23 AE 74 05 A3 8F 08 00 22 AE 70 05 A2 8F 14 00 23 AE 8C 05 A3 8F 10 00 22 AE 88 05 A2 8F 1C 00 23 AE 7C 05 A3 8F 18 00 22 AE 78 05 A2 8F 24 00 23 AE 84 05 A3 8F 20 00 22 AE 80 05 A2 8F 2C 00 23 AE 48 00 24 26 28 00 22 AE 90 05 A2 8F 21 28 00 00 18 00 06 24 38 00 22 AE 98 05 A2 8F 3C 00 20 AE ?? ?? ?? ?? 44 00 22 AE 10 00 BC 8F 28 00 22 8E 2C 00 23 8E 21 20 00 02 ?? ?? 90 8F 30 00 22 AE 34 00 23 AE 40 00 20 AE 21 C8 00 02 ?? ?? ?? ?? B8 04 A5 27 21 B8 00 02 99 00 40 04 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F 21 A0 40 00 00 00 55 8C ?? ?? 84 8F ?? ?? 92 8F ?? ?? 90 8F ?? ?? 84 24 21 C8 00 02 ?? ?? ?? ?? ?? ?? 45 26 21 98 40 00 09 00 40 14 10 00 BC 8F ?? ?? 84 8F ?? ?? 45 26 21 C8 00 02 ?? ?? ?? ?? ?? ?? 84 24 21 98 40 00 7D 00 40 10 10 00 BC 8F ?? ?? 92 8F B8 05 B0 27 18 00 B6 27 18 04 BE 27 21 20 60 02 21 28 00 02 21 30 C0 02 21 C8 40 02 ?? ?? ?? ?? 00 04 07 24 6E 00 40 10 10 00 BC 8F BC 05 A4 8F 21 C8 E0 02 ?? ?? ?? ?? 21 28 C0 03 F3 FF 40 04 10 00 BC 8F 18 04 A2 8F B8 04 A3 8F F0 FF 62 14 21 20 60 02 1C 04 A2 8F BC 04 A3 8F ED FF 62 14 21 28 00 02 C4 05 A2 8F ?? ?? 96 8F ?? ?? 97 8F ?? ?? 9E 8F D0 05 A2 AF ?? ?? D6 26 ?? ?? F7 26 ?? ?? DE 27 ?? ?? 99 8F D0 05 A4 27 ?? ?? ?? ?? 21 28 C0 02 21 80 40 00 51 00 40 10 10 00 BC 8F ?? ?? 92 8F 21 20 00 02 21 C8 40 02 ?? ?? ?? ?? 21 28 E0 02 04 00 40 14 10 00 BC 8F 40 00 22 8E 45 00 00 10 01 00 42 34 21 20 00 02 21 C8 40 02 ?? ?? ?? ?? 21 28 C0 03 04 00 40 14 10 00 BC 8F 40 00 22 8E 3C 00 00 10 02 00 42 34 ?? ?? 85 8F 21 20 00 02 21 C8 40 02 ?? ?? ?? ?? ?? ?? A5 24 04 00 40 14 10 00 BC 8F 40 00 22 8E 32 00 00 10 08 00 42 34 ?? ?? 85 8F 21 20 00 02 21 C8 40 02 ?? ?? ?? ?? ?? ?? A5 24 04 00 40 14 10 00 BC 8F 40 00 22 8E 28 00 00 10 04 00 42 34 ?? ?? 85 8F 21 20 00 02 21 C8 40 02 ?? ?? ?? ?? ?? ?? A5 24 04 00 40 14 10 00 BC 8F 40 00 22 8E 1E 00 00 10 10 00 42 34 ?? ?? 85 8F 21 20 00 02 21 C8 40 02 ?? ?? ?? ?? ?? ?? A5 24 04 00 40 14 10 00 BC 8F 40 00 22 8E 14 00 00 10 40 00 42 34 ?? ?? 85 8F 21 20 00 02 21 C8 40 02 ?? ?? ?? ?? ?? ?? A5 24 04 00 40 14 10 00 BC 8F 40 00 22 8E 0A 00 00 10 00 04 42 34 ?? ?? 85 8F 21 20 00 02 21 C8 40 02 ?? ?? ?? ?? ?? ?? A5 24 AE FF 40 14 10 00 BC 8F 40 00 22 8E 00 08 42 34 AA FF 00 10 40 00 22 AE ?? ?? 99 8F ?? ?? ?? ?? 21 20 60 02 03 00 00 10 00 00 95 AE 02 00 00 10 FF FF 02 24 21 10 00 00 FC 05 BF 8F F8 05 BE 8F F4 05 B7 8F F0 05 B6 8F EC 05 B5 8F E8 05 B4 8F E4 05 B3 8F E0 05 B2 8F DC 05 B1 8F D8 05 B0 8F 08 00 E0 03 00 06 BD 27 }
	condition:
		$1
}

rule file_288_0_0 {
	meta:
		name = "__GI_isgraph"
		size = 40
		refs = "0000 _gp_disp 000c __GI___ctype_b"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F 40 20 04 00 00 00 42 8C 21 10 44 00 00 00 42 94 08 00 E0 03 80 00 42 30 }
	condition:
		$1
}

rule file_289_0_0 {
	meta:
		name = "__fp_range_check"
		size = 260
		refs = "0000 _gp_disp 0018 __muldf3 002c $LC0 005c __eqdf2 0074 __nedf2 00d0 __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D0 FF BD 27 28 00 B4 AF ?? ?? 94 8F ?? ?? 99 8F 1C 00 B1 AF 18 00 B0 AF 21 88 E0 00 21 80 C0 00 ?? ?? 87 8E ?? ?? 86 8E 10 00 BC AF 2C 00 BF AF 24 00 B3 AF 20 00 B2 AF 21 90 80 00 ?? ?? ?? ?? 21 98 A0 00 10 00 BC 8F 21 20 40 02 21 28 60 02 ?? ?? 99 8F 21 30 40 00 ?? ?? ?? ?? 21 38 60 00 1D 00 40 14 10 00 BC 8F ?? ?? 99 8F 21 20 40 02 21 28 60 02 21 30 00 00 ?? ?? ?? ?? 21 38 00 00 15 00 40 10 10 00 BC 8F ?? ?? 99 8F ?? ?? 86 8E ?? ?? 87 8E 21 20 00 02 ?? ?? ?? ?? 21 28 20 02 10 00 BC 8F 21 20 00 02 21 28 20 02 ?? ?? 99 8F 21 30 40 00 ?? ?? ?? ?? 21 38 60 00 06 00 40 10 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 22 00 03 24 00 00 43 AC 2C 00 BF 8F 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_290_0_0 {
	meta:
		name = "__GI_remove"
		size = 156
		refs = "0000 _gp_disp 000c __GI___errno_location 003c __GI_rmdir 0074 __GI_unlink"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F D8 FF BD 27 10 00 BC AF 24 00 BF AF 20 00 B2 AF 1C 00 B1 AF 18 00 B0 AF ?? ?? ?? ?? 21 88 80 00 10 00 BC 8F 21 20 20 02 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 52 8C 0E 00 41 04 10 00 BC 8F 00 00 04 8E 14 00 03 24 0B 00 83 14 24 00 BF 8F 00 00 12 AE 24 00 BF 8F 20 00 B2 8F 18 00 B0 8F 21 20 20 02 ?? ?? 99 8F 1C 00 B1 8F ?? ?? ?? ?? 28 00 BD 27 24 00 BF 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_293_0_0 {
	meta:
		name = "__GI_setvbuf"
		size = 420
		refs = "0000 _gp_disp 0048 _pthread_cleanup_push_defer 004c __pthread_mutex_unlock 0064 __pthread_mutex_lock 0080 __GI___errno_location 00e0 malloc 0118 free 016c _pthread_cleanup_pop_restore"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 B8 FF BD 27 38 00 B3 AF 34 00 B2 AF 30 00 B1 AF 2C 00 B0 AF 10 00 BC AF 44 00 BF AF 40 00 B5 AF 3C 00 B4 AF 34 00 95 8C 21 80 80 00 21 88 A0 00 21 98 C0 00 0C 00 A0 16 21 90 E0 00 ?? ?? 99 8F ?? ?? 85 8F 38 00 94 24 21 30 80 02 ?? ?? ?? ?? 18 00 A4 27 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 80 02 10 00 BC 8F 03 00 62 2E 08 00 40 54 00 00 02 96 ?? ?? 99 8F ?? ?? ?? ?? FF FF 10 24 16 00 03 24 10 00 BC 8F 33 00 00 10 00 00 43 AC CF 08 43 30 2F 00 60 14 FF FC 42 30 00 A2 13 00 25 A0 82 02 FF FF 94 32 02 00 02 24 11 00 62 12 00 00 14 A6 11 00 40 12 21 98 00 00 11 00 20 16 00 40 82 32 0C 00 03 8E 08 00 02 8E 23 10 62 00 1E 00 52 10 ?? ?? 99 8F ?? ?? ?? ?? 21 20 40 02 21 88 40 00 19 00 40 10 10 00 BC 8F 04 00 00 10 00 40 13 24 21 98 00 00 21 90 00 00 21 88 00 00 00 40 82 32 08 00 40 50 00 00 02 96 ?? ?? 99 8F 08 00 04 8E FF BF 94 32 ?? ?? ?? ?? 00 00 14 A6 10 00 BC 8F 00 00 02 96 21 90 32 02 08 00 11 AE 25 98 62 02 00 00 13 A6 0C 00 12 AE 10 00 11 AE 14 00 11 AE 18 00 11 AE 1C 00 11 AE 02 00 00 10 21 80 00 00 FF FF 10 24 06 00 A0 16 44 00 BF 8F ?? ?? 99 8F 18 00 A4 27 ?? ?? ?? ?? 01 00 05 24 44 00 BF 8F 21 10 00 02 40 00 B5 8F 3C 00 B4 8F 38 00 B3 8F 34 00 B2 8F 30 00 B1 8F 2C 00 B0 8F 08 00 E0 03 48 00 BD 27 }
	condition:
		$1
}

rule file_294_0_0 {
	meta:
		name = "__GI_xdr_callmsg"
		size = 1240
		refs = "0000 _gp_disp 0130 __GI_memcpy 01ac __GI_xdr_u_long 0274 malloc 02b0 __GI_xdr_opaque 02f8 __GI_xdr_enum 0310 __GI_xdr_u_int 0480 __GI_xdr_opaque_auth"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D8 FF BD 27 1C 00 B1 AF 18 00 B0 AF 10 00 BC AF 24 00 BF AF 20 00 B2 AF 00 00 82 8C 21 88 80 00 5C 00 40 14 21 80 A0 00 20 00 A3 8C 91 01 62 2C 03 00 40 54 2C 00 A2 8C 1E 01 00 10 21 10 00 00 91 01 45 2C 1B 01 A0 50 21 10 00 00 04 00 86 8C 03 00 65 24 FC FF 12 24 03 00 42 24 24 10 52 00 24 28 B2 00 18 00 D9 8C 21 28 A2 00 09 F8 20 03 28 00 A5 24 47 00 40 10 10 00 BC 8F 00 00 03 8E A0 18 03 7C 02 1C 23 00 00 00 43 AC 04 00 03 8E A0 18 03 7C 02 1C 23 00 04 00 43 AC 04 00 03 8E 04 01 60 54 21 10 00 00 08 00 03 8E A0 18 03 7C 02 1C 23 00 08 00 43 AC 08 00 04 8E 02 00 03 24 FC 00 83 54 21 10 00 00 0C 00 03 8E A0 18 03 7C 02 1C 23 00 0C 00 43 AC 10 00 03 8E A0 18 03 7C 02 1C 23 00 10 00 43 AC 14 00 03 8E A0 18 03 7C 02 1C 23 00 14 00 43 AC 18 00 03 8E A0 18 03 7C 02 1C 23 00 18 00 43 AC 20 00 04 8E A0 20 04 7C 02 24 24 00 1C 00 44 AC 20 00 06 8E 0B 00 C0 10 20 00 43 24 ?? ?? 99 8F 1C 00 05 8E ?? ?? ?? ?? 21 20 60 00 21 18 40 00 20 00 02 8E 10 00 BC 8F 03 00 42 24 24 90 52 00 21 18 72 00 24 00 02 8E A0 10 02 7C 02 14 22 00 00 00 62 AC 2C 00 02 8E A0 10 02 7C 02 14 22 00 04 00 62 AC 2C 00 06 8E D0 00 C0 50 01 00 02 24 28 00 05 8E 08 00 64 24 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 C9 00 00 10 01 00 02 24 00 00 23 8E 01 00 02 24 8A 00 62 14 ?? ?? 92 8F 04 00 22 8E 21 20 20 02 18 00 59 8C 09 F8 20 03 20 00 05 24 82 00 40 10 10 00 BC 8F 00 00 43 8C A0 18 03 7C 02 1C 23 00 00 00 03 AE 04 00 43 8C A0 18 03 7C 02 1C 23 00 96 FF 60 14 04 00 03 AE 08 00 43 8C 02 00 04 24 A0 18 03 7C 02 1C 23 00 90 FF 64 14 08 00 03 AE 0C 00 43 8C A0 18 03 7C 02 1C 23 00 0C 00 03 AE 10 00 43 8C A0 18 03 7C 02 1C 23 00 10 00 03 AE 14 00 43 8C A0 18 03 7C 02 1C 23 00 14 00 03 AE 18 00 43 8C A0 18 03 7C 02 1C 23 00 18 00 03 AE 1C 00 52 8C A0 90 12 7C 02 94 32 00 21 00 40 12 20 00 12 AE 91 01 42 2E 97 00 40 10 21 10 00 00 1C 00 02 8E 06 00 40 54 04 00 22 8E ?? ?? 99 8F ?? ?? ?? ?? 21 20 40 02 1C 00 02 AE 04 00 22 8E 03 00 45 26 21 20 20 02 18 00 59 8C FC FF 02 24 09 F8 20 03 24 28 A2 00 10 00 BC 8F 20 00 06 8E 08 00 40 14 1C 00 05 8E ?? ?? 99 8F ?? ?? ?? ?? 21 20 20 02 08 00 40 54 04 00 22 8E 7E 00 00 10 21 10 00 00 ?? ?? 99 8F 21 20 A0 00 ?? ?? ?? ?? 21 28 40 00 04 00 22 8E 21 20 20 02 18 00 59 8C 09 F8 20 03 08 00 05 24 0F 00 40 14 10 00 BC 8F ?? ?? 99 8F 21 20 20 02 ?? ?? ?? ?? 24 00 05 26 4E FF 40 10 10 00 BC 8F ?? ?? 99 8F 21 20 20 02 ?? ?? ?? ?? 2C 00 05 26 0B 00 40 14 10 00 BC 8F 65 00 00 10 21 10 00 00 00 00 43 8C A0 18 03 7C 02 1C 23 00 24 00 03 AE 04 00 42 8C A0 10 02 7C 02 14 22 00 2C 00 02 AE 2C 00 12 8E 5A 00 40 12 01 00 02 24 91 01 42 2E 57 00 40 10 21 10 00 00 28 00 02 8E 06 00 40 54 04 00 22 8E ?? ?? 99 8F ?? ?? ?? ?? 21 20 40 02 28 00 02 AE 04 00 22 8E 03 00 45 26 21 20 20 02 18 00 59 8C FC FF 02 24 09 F8 20 03 24 28 A2 00 10 00 BC 8F 2C 00 06 8E 06 00 40 14 28 00 05 8E ?? ?? 99 8F ?? ?? ?? ?? 21 20 20 02 40 00 00 10 2B 10 02 00 21 20 A0 00 70 FF 00 10 21 28 40 00 ?? ?? 92 8F 21 20 20 02 21 C8 40 02 ?? ?? ?? ?? 21 28 00 02 17 FF 40 10 10 00 BC 8F ?? ?? 99 8F 21 20 20 02 ?? ?? ?? ?? 04 00 05 26 30 00 40 10 21 10 00 00 04 00 02 8E 2D 00 40 14 21 10 00 00 21 20 20 02 21 C8 40 02 ?? ?? ?? ?? 08 00 05 26 27 00 40 10 21 10 00 00 08 00 03 8E 02 00 02 24 23 00 62 14 21 10 00 00 21 20 20 02 21 C8 40 02 ?? ?? ?? ?? 0C 00 05 26 1D 00 40 10 21 10 00 00 21 20 20 02 21 C8 40 02 ?? ?? ?? ?? 10 00 05 26 17 00 40 10 21 10 00 00 21 20 20 02 21 C8 40 02 ?? ?? ?? ?? 14 00 05 26 F2 FE 40 10 10 00 BC 8F ?? ?? 92 8F 21 20 20 02 21 C8 40 02 ?? ?? ?? ?? 18 00 05 26 EB FE 40 10 10 00 BC 8F 24 00 BF 8F 21 20 20 02 24 00 05 26 1C 00 B1 8F 18 00 B0 8F 21 C8 40 02 20 00 B2 8F ?? ?? ?? ?? 28 00 BD 27 24 00 BF 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_295_0_0 {
	meta:
		name = "__GI_inet_network"
		size = 336
		refs = "0000 _gp_disp 000c __GI___ctype_b"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 8D 8F F0 FF BD 27 21 18 00 00 21 38 00 00 0C 00 B2 AF 08 00 B1 AF 04 00 B0 AF 30 00 0A 24 DF FF 0B 24 58 00 0C 24 41 00 0E 24 61 00 0F 24 2E 00 18 24 04 00 19 24 00 00 82 80 0B 00 4A 14 0A 00 06 24 01 00 82 90 24 10 4B 00 20 14 02 7C 04 00 4C 10 08 00 06 24 01 00 84 24 04 00 00 10 01 00 08 24 02 00 84 24 10 00 06 24 21 40 00 00 21 10 00 00 10 00 10 24 08 00 11 24 00 00 85 90 1D 00 A0 10 40 48 05 00 00 00 B2 8D 21 48 49 02 00 00 29 95 08 00 32 31 09 00 40 12 00 00 00 00 04 00 D1 14 02 40 46 70 38 00 A8 2C 1F 00 00 11 02 40 46 70 21 10 05 01 0A 00 00 10 D0 FF 42 24 0D 00 D0 14 10 00 32 31 0B 00 40 12 02 00 29 31 00 11 02 00 21 28 E0 01 0A 28 C9 01 0A 00 42 24 23 10 45 00 00 01 45 2C 10 00 A0 10 01 00 84 24 E2 FF 00 10 01 00 08 24 0C 00 00 11 00 32 03 00 0B 18 C7 00 06 00 B8 14 25 18 62 00 01 00 E7 24 06 00 F9 10 01 00 84 24 C8 FF 00 10 00 00 82 80 FF FF 02 24 02 00 00 10 0A 10 65 00 FF FF 02 24 0C 00 B2 8F 08 00 B1 8F 04 00 B0 8F 08 00 E0 03 10 00 BD 27 }
	condition:
		$1
}

rule file_296_0_0 {
	meta:
		name = "__getdents64"
		size = 436
		refs = "0000 _gp_disp 006c __GI___errno_location 00d8 __GI_memcpy 013c __GI_lseek64"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 0E 00 C2 24 C2 10 02 00 B0 FF BD 27 C0 10 02 00 48 00 BE AF 38 00 B4 AF 30 00 B2 AF 21 F0 A0 03 4C 00 BF AF 44 00 B7 AF 40 00 B6 AF 3C 00 B5 AF 34 00 B3 AF 2C 00 B1 AF 28 00 B0 AF 18 00 BC AF 23 E8 A2 03 18 00 B4 27 21 90 A0 00 21 28 80 02 7B 10 02 24 0C 00 00 00 06 00 E0 10 21 B8 40 00 ?? ?? 99 8F ?? ?? ?? ?? FF FF 15 24 3D 00 00 10 00 00 57 AC FF FF 02 24 3D 00 E2 12 FF FF 15 24 21 98 80 00 21 A8 40 02 FF FF 10 24 FF FF 11 24 21 B8 97 02 F8 FF 03 24 1B 00 00 10 21 38 46 02 04 00 89 8E 08 00 90 8E 0C 00 91 8E 00 00 A8 AE 04 00 A9 AE 08 00 88 8E 0C 00 89 8E 10 00 A2 A6 08 00 A8 AE 0C 00 A9 AE 12 00 82 92 ?? ?? 99 8F 13 00 A4 26 12 00 A2 A2 10 00 86 96 13 00 85 26 20 00 C3 AF 24 00 C7 AF ?? ?? ?? ?? ED FF C6 24 10 00 82 96 18 00 DC 8F 24 00 C7 8F 20 00 C3 8F 21 A0 82 02 21 A8 C0 02 2B 10 97 02 18 00 40 50 23 A8 B2 02 10 00 82 96 07 00 42 24 24 10 43 00 21 B0 A2 02 2B 20 F6 00 DD FF 80 50 00 00 88 8E ?? ?? 99 8F 10 00 A0 AF 21 20 60 02 21 30 00 02 ?? ?? ?? ?? 21 38 20 02 08 00 B2 16 18 00 DC 8F ?? ?? 99 8F ?? ?? ?? ?? FF FF 15 24 16 00 03 24 00 00 43 AC 03 00 00 10 21 E8 C0 03 23 A8 B2 02 21 E8 C0 03 4C 00 BF 8F 21 10 A0 02 48 00 BE 8F 44 00 B7 8F 40 00 B6 8F 3C 00 B5 8F 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 E0 03 50 00 BD 27 }
	condition:
		$1
}

rule file_297_0_0 {
	meta:
		name = "__GI_towlower"
		size = 52
		refs = "0000 _gp_disp 0018 __GI___C_ctype_tolower"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 80 00 83 2C 06 00 60 10 21 10 80 00 ?? ?? 83 8F 40 10 04 00 00 00 63 8C 21 10 62 00 00 00 42 84 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_693_0_0 {
	meta:
		name = "__GI_towupper"
		size = 52
		refs = "0000 _gp_disp 0018 __GI___C_ctype_toupper"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 80 00 83 2C 06 00 60 10 21 10 80 00 ?? ?? 83 8F 40 10 04 00 00 00 63 8C 21 10 62 00 00 00 42 84 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_298_0_0 {
	meta:
		name = "psignal"
		size = 152
		refs = "0000 _gp_disp 0038 $LC0 004c stderr 0050 __GI_strsignal 006c __GI_fprintf 0068 $LC1"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D0 FF BD 27 18 00 BC AF 24 00 B1 AF 2C 00 BF AF 28 00 B2 AF 20 00 B0 AF 04 00 A0 10 21 88 A0 00 00 00 A2 80 05 00 40 54 ?? ?? 90 8F ?? ?? 90 8F ?? ?? 10 26 02 00 00 10 21 88 00 02 ?? ?? 10 26 ?? ?? 82 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 52 8C 18 00 BC 8F 21 20 40 02 21 30 20 02 ?? ?? 85 8F ?? ?? 99 8F 21 38 00 02 10 00 A2 AF ?? ?? ?? ?? ?? ?? A5 24 2C 00 BF 8F 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_299_0_0 {
	meta:
		name = "__GI_fgetpwent_r"
		size = 88
		refs = "0000 _gp_disp 0024 __pgsreader 0030 __parsepwent"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D0 FF BD 27 24 00 B0 AF 40 00 B0 8F 18 00 BC AF 28 00 B1 AF 2C 00 BF AF ?? ?? 99 8F 00 00 00 AE 10 00 A4 AF ?? ?? 84 8F ?? ?? ?? ?? 21 88 A0 00 01 00 40 50 00 00 11 AE 2C 00 BF 8F 28 00 B1 8F 24 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_540_0_0 {
	meta:
		name = "__GI_fgetgrent_r"
		size = 88
		refs = "0000 _gp_disp 0024 __pgsreader 0030 __parsegrent"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D0 FF BD 27 24 00 B0 AF 40 00 B0 8F 18 00 BC AF 28 00 B1 AF 2C 00 BF AF ?? ?? 99 8F 00 00 00 AE 10 00 A4 AF ?? ?? 84 8F ?? ?? ?? ?? 21 88 A0 00 01 00 40 50 00 00 11 AE 2C 00 BF 8F 28 00 B1 8F 24 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_301_0_0 {
	meta:
		name = "__GI_fgetspent_r"
		size = 88
		refs = "0000 _gp_disp 0024 __pgsreader 0030 __parsespent"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D0 FF BD 27 24 00 B0 AF 40 00 B0 8F 18 00 BC AF 28 00 B1 AF 2C 00 BF AF ?? ?? 99 8F 00 00 00 AE 10 00 A4 AF ?? ?? 84 8F ?? ?? ?? ?? 21 88 A0 00 01 00 40 50 00 00 11 AE 2C 00 BF 8F 28 00 B1 8F 24 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_300_0_0 {
	meta:
		name = "__GI_fstatvfs"
		size = 884
		refs = "0000 _gp_disp 000c __libc_fstatfs 005c __GI_memset 00c0 __GI_fstat 00dc __GI___errno_location 00fc __GI_setmntent 00f4 $LC0 010c $LC1 011c $LC2 013c __GI_getmntent_r 0140 __GI_stat 01ac $LC11 01b0 $LC3 01b4 $LC4 01c8 __GI_strsep 01e4 __GI_strcmp 0230 $LC5 0258 $LC6 0280 $LC7 02a8 $LC8 02d0 $LC9 02f8 $LC10 0324 __GI_endmntent"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F 30 FA BD 27 10 00 BC AF AC 05 B1 AF A8 05 B0 AF CC 05 BF AF C8 05 BE AF C4 05 B7 AF C0 05 B6 AF BC 05 B5 AF B8 05 B4 AF B4 05 B3 AF B0 05 B2 AF 21 80 A0 00 48 05 A5 27 ?? ?? ?? ?? 21 88 80 00 B9 00 40 04 10 00 BC 8F 4C 05 A2 8F ?? ?? 99 8F 30 00 04 26 00 00 02 AE 04 00 02 AE 54 05 A2 8F 21 28 00 00 18 00 06 24 08 00 02 AE 58 05 A2 8F 24 00 00 AE 0C 00 02 AE 64 05 A2 8F 10 00 02 AE 5C 05 A2 8F 14 00 02 AE 60 05 A2 8F 18 00 02 AE 68 05 A2 8F 20 00 02 AE 70 05 A2 8F ?? ?? ?? ?? 2C 00 02 AE 10 00 BC 8F 18 00 02 8E 28 00 00 AE ?? ?? 99 8F 1C 00 02 AE 21 20 20 02 ?? ?? ?? ?? B0 04 A5 27 9A 00 40 04 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F 21 A0 40 00 00 00 55 8C ?? ?? 84 8F ?? ?? 92 8F ?? ?? 91 8F ?? ?? 84 24 21 C8 20 02 ?? ?? ?? ?? ?? ?? 45 26 21 98 40 00 09 00 40 14 10 00 BC 8F ?? ?? 84 8F ?? ?? 45 26 21 C8 20 02 ?? ?? ?? ?? ?? ?? 84 24 21 98 40 00 7E 00 40 10 10 00 BC 8F ?? ?? 91 8F ?? ?? 9E 8F 8C 05 B6 27 18 00 B2 27 18 04 B7 27 21 20 60 02 21 28 C0 02 21 30 40 02 21 C8 20 02 ?? ?? ?? ?? 00 04 07 24 6E 00 40 10 10 00 BC 8F 90 05 A4 8F 21 C8 C0 03 ?? ?? ?? ?? 21 28 E0 02 F3 FF 40 04 10 00 BC 8F 18 04 A2 8F B0 04 A3 8F F0 FF 62 14 21 20 60 02 1C 04 A2 8F B4 04 A3 8F ED FF 62 14 21 28 C0 02 98 05 A2 8F ?? ?? 96 8F ?? ?? 97 8F ?? ?? 9E 8F A4 05 A2 AF ?? ?? D6 26 ?? ?? F7 26 ?? ?? DE 27 ?? ?? 99 8F A4 05 A4 27 ?? ?? ?? ?? 21 28 C0 02 21 88 40 00 51 00 40 10 10 00 BC 8F ?? ?? 92 8F 21 20 20 02 21 C8 40 02 ?? ?? ?? ?? 21 28 E0 02 04 00 40 14 10 00 BC 8F 28 00 02 8E 45 00 00 10 01 00 42 34 21 20 20 02 21 C8 40 02 ?? ?? ?? ?? 21 28 C0 03 04 00 40 14 10 00 BC 8F 28 00 02 8E 3C 00 00 10 02 00 42 34 ?? ?? 85 8F 21 20 20 02 21 C8 40 02 ?? ?? ?? ?? ?? ?? A5 24 04 00 40 14 10 00 BC 8F 28 00 02 8E 32 00 00 10 08 00 42 34 ?? ?? 85 8F 21 20 20 02 21 C8 40 02 ?? ?? ?? ?? ?? ?? A5 24 04 00 40 14 10 00 BC 8F 28 00 02 8E 28 00 00 10 04 00 42 34 ?? ?? 85 8F 21 20 20 02 21 C8 40 02 ?? ?? ?? ?? ?? ?? A5 24 04 00 40 14 10 00 BC 8F 28 00 02 8E 1E 00 00 10 10 00 42 34 ?? ?? 85 8F 21 20 20 02 21 C8 40 02 ?? ?? ?? ?? ?? ?? A5 24 04 00 40 14 10 00 BC 8F 28 00 02 8E 14 00 00 10 40 00 42 34 ?? ?? 85 8F 21 20 20 02 21 C8 40 02 ?? ?? ?? ?? ?? ?? A5 24 04 00 40 14 10 00 BC 8F 28 00 02 8E 0A 00 00 10 00 04 42 34 ?? ?? 85 8F 21 20 20 02 21 C8 40 02 ?? ?? ?? ?? ?? ?? A5 24 AE FF 40 14 10 00 BC 8F 28 00 02 8E 00 08 42 34 AA FF 00 10 28 00 02 AE ?? ?? 99 8F ?? ?? ?? ?? 21 20 60 02 03 00 00 10 00 00 95 AE 02 00 00 10 FF FF 02 24 21 10 00 00 CC 05 BF 8F C8 05 BE 8F C4 05 B7 8F C0 05 B6 8F BC 05 B5 8F B8 05 B4 8F B4 05 B3 8F B0 05 B2 8F AC 05 B1 8F A8 05 B0 8F 08 00 E0 03 D0 05 BD 27 }
	condition:
		$1
}

rule file_302_0_0 {
	meta:
		name = "__GI_fputs_unlocked"
		size = 120
		refs = "0000 _gp_disp 000c __GI_strlen 0040 __GI_fwrite_unlocked"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F D8 FF BD 27 24 00 BF AF 20 00 B2 AF 1C 00 B1 AF 18 00 B0 AF 10 00 BC AF 21 88 A0 00 ?? ?? ?? ?? 21 90 80 00 10 00 BC 8F 21 20 40 02 21 38 20 02 ?? ?? 99 8F 01 00 05 24 21 30 40 00 ?? ?? ?? ?? 21 80 40 00 24 00 BF 8F 26 80 50 00 FF FF 03 24 0B 10 70 00 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_303_0_0 {
	meta:
		name = "__GI_ptsname_r"
		size = 276
		refs = "0000 _gp_disp 000c __GI___errno_location 0050 __GI_ioctl 0074 _uintmaxtostr 00b8 __GI_strcpy 00d0 __GI_strcat"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F A8 FF BD 27 18 00 BC AF 54 00 BF AF 50 00 B5 AF 4C 00 B4 AF 40 00 B1 AF 3C 00 B0 AF 30 00 A4 AF 48 00 B3 AF 44 00 B2 AF 21 88 A0 00 ?? ?? ?? ?? 21 A8 C0 00 18 00 BC 8F 30 00 A4 8F 04 40 05 3C ?? ?? 99 8F 30 54 A5 24 2C 00 A6 27 21 80 40 00 ?? ?? ?? ?? 00 00 54 8C 1F 00 40 14 18 00 BC 8F 2C 00 A6 8F ?? ?? 99 8F F6 FF 02 24 2B 00 B2 27 21 20 40 02 10 00 A2 AF 14 00 A0 AF ?? ?? ?? ?? C3 3F 06 00 23 90 42 02 0A 00 52 26 2B A8 B2 02 18 00 BC 8F 03 00 A0 12 21 98 40 00 0F 00 00 10 22 00 02 24 ?? ?? 85 8F ?? ?? 99 8F 21 20 20 02 ?? ?? ?? ?? ?? ?? A5 24 18 00 BC 8F 21 20 20 02 ?? ?? 99 8F ?? ?? ?? ?? 21 28 60 02 00 00 14 AE 03 00 00 10 21 10 00 00 19 00 02 24 00 00 02 AE 54 00 BF 8F 50 00 B5 8F 4C 00 B4 8F 48 00 B3 8F 44 00 B2 8F 40 00 B1 8F 3C 00 B0 8F 08 00 E0 03 58 00 BD 27 }
	condition:
		$1
}

rule file_303_1_0 {
	meta:
		name = "ptsname"
		size = 76
		refs = "0000 _gp_disp 0018 __GI_ptsname_r"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 18 00 B0 AF ?? ?? 90 8F ?? ?? 99 8F 1C 00 BF AF 10 00 BC AF ?? ?? 05 26 ?? ?? ?? ?? 1E 00 06 24 1C 00 BF 8F ?? ?? 10 26 0B 80 02 00 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_304_0_0 {
	meta:
		name = "getresuid"
		size = 164
		refs = "0000 _gp_disp 0050 __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 C0 FF BD 27 10 00 BC AF 38 00 B3 AF 34 00 B2 AF 30 00 B1 AF 21 98 80 00 21 90 A0 00 21 88 C0 00 3C 00 BF AF 2C 00 B0 AF 20 00 A4 27 1C 00 A5 27 18 00 A6 27 5A 10 02 24 0C 00 00 00 07 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC 08 00 00 10 FF FF 10 24 06 00 40 14 20 00 A2 8F 00 00 62 AE 1C 00 A2 8F 00 00 42 AE 18 00 A2 8F 00 00 22 AE 3C 00 BF 8F 21 10 00 02 38 00 B3 8F 34 00 B2 8F 30 00 B1 8F 2C 00 B0 8F 08 00 E0 03 40 00 BD 27 }
	condition:
		$1
}

rule file_305_0_0 {
	meta:
		name = "__GI_nanosleep"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 46 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_306_0_0 {
	meta:
		name = "__GI___fsetlocking"
		size = 64
		refs = "0000 _gp_disp 0024 _stdio_user_locking"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 34 00 82 8C 01 00 42 30 08 00 A0 10 01 00 42 24 02 00 03 24 03 00 A3 10 ?? ?? 83 8F 02 00 00 10 00 00 63 8C 01 00 03 24 34 00 83 AC 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_307_0_0 {
	meta:
		name = "__GI_inet_addr"
		size = 64
		refs = "0000 _gp_disp 000c __GI_inet_aton"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F D8 FF BD 27 24 00 BF AF 10 00 BC AF ?? ?? ?? ?? 18 00 A5 27 18 00 A4 8F 24 00 BF 8F FF FF 03 24 0B 18 82 00 21 10 60 00 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_308_0_0 {
	meta:
		name = "gai_strerror"
		size = 76
		refs = "0000 _gp_disp 0040 $LC0"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 86 8F 21 10 00 00 10 00 05 24 ?? ?? C6 24 C0 18 02 00 21 18 66 00 00 00 67 8C 03 00 E4 54 01 00 42 24 08 00 E0 03 04 00 62 8C F9 FF 45 14 C0 18 02 00 ?? ?? 82 8F 08 00 E0 03 ?? ?? 42 24 }
	condition:
		$1
}

rule file_309_0_0 {
	meta:
		name = "__GI_ftello64"
		size = 264
		refs = "0000 _gp_disp 0040 _pthread_cleanup_push_defer 0044 __pthread_mutex_unlock 005c __pthread_mutex_lock 0074 __stdio_seek 00b8 __stdio_adjust_position 00d8 _pthread_cleanup_pop_restore"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 C0 FF BD 27 30 00 B0 AF 10 00 BC AF 3C 00 BF AF 38 00 B2 AF 34 00 B1 AF 34 00 91 8C 21 10 00 00 21 18 00 00 21 80 80 00 28 00 A2 AF 0C 00 20 16 2C 00 A3 AF ?? ?? 99 8F ?? ?? 85 8F 38 00 92 24 21 30 40 02 ?? ?? ?? ?? 18 00 A4 27 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 40 02 10 00 BC 8F 00 00 06 96 01 00 03 24 ?? ?? 99 8F 40 04 C6 30 40 04 C6 38 02 00 02 24 0B 10 66 00 28 00 B2 27 21 20 00 02 21 28 40 02 ?? ?? ?? ?? 21 30 40 00 06 00 41 04 10 00 BC 8F FF FF 02 24 FF FF 03 24 28 00 A2 AF 07 00 00 10 2C 00 A3 AF ?? ?? 99 8F 21 20 00 02 ?? ?? ?? ?? 21 28 40 02 F6 FF 40 04 10 00 BC 8F 06 00 20 16 3C 00 BF 8F ?? ?? 99 8F 18 00 A4 27 ?? ?? ?? ?? 01 00 05 24 3C 00 BF 8F 28 00 A2 8F 2C 00 A3 8F 38 00 B2 8F 34 00 B1 8F 30 00 B0 8F 08 00 E0 03 40 00 BD 27 }
	condition:
		$1
}

rule file_310_0_0 {
	meta:
		name = "__GI_setpgid"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF D9 0F 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_312_0_0 {
	meta:
		name = "__GI_wcrtomb"
		size = 92
		refs = "0000 _gp_disp 001c __GI_wcsnrtombs"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 C0 FF BD 27 18 00 BC AF 3C 00 BF AF 03 00 80 14 ?? ?? 99 8F 21 28 00 00 20 00 A4 27 34 00 A2 27 34 00 A5 AF 10 00 A6 AF 30 00 A5 27 30 00 A2 AF 01 00 06 24 ?? ?? ?? ?? 10 00 07 24 3C 00 BF 8F 01 00 03 24 0A 10 62 00 08 00 E0 03 40 00 BD 27 }
	condition:
		$1
}

rule file_313_0_0 {
	meta:
		name = "__GI_srand48_r"
		size = 64
	strings:
		$1 = { 03 14 04 00 04 00 A2 A4 0E 33 02 24 00 00 A2 A4 EC DE 02 3C 6D E6 42 34 10 00 A2 AC 0B 00 02 24 05 00 03 24 0C 00 A2 A4 01 00 02 24 0E 00 A2 A4 02 00 A4 A4 14 00 A3 AC 08 00 E0 03 21 10 00 00 }
	condition:
		$1
}

rule file_314_0_0 {
	meta:
		name = "__GI_fputs"
		size = 176
		refs = "0000 _gp_disp 0038 _pthread_cleanup_push_defer 0040 __pthread_mutex_unlock 0054 __pthread_mutex_lock 0064 __GI_fputs_unlocked 007c _pthread_cleanup_pop_restore"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 B8 FF BD 27 40 00 B3 AF 34 00 B0 AF 10 00 BC AF 44 00 BF AF 3C 00 B2 AF 38 00 B1 AF 34 00 B1 8C 21 98 80 00 0C 00 20 16 21 80 A0 00 ?? ?? 99 8F 38 00 B2 24 ?? ?? 85 8F 18 00 A4 27 ?? ?? ?? ?? 21 30 40 02 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 40 02 10 00 BC 8F ?? ?? 99 8F 21 20 60 02 ?? ?? ?? ?? 21 28 00 02 07 00 20 16 10 00 BC 8F ?? ?? 99 8F 28 00 A2 AF 18 00 A4 27 ?? ?? ?? ?? 01 00 05 24 28 00 A2 8F 44 00 BF 8F 40 00 B3 8F 3C 00 B2 8F 38 00 B1 8F 34 00 B0 8F 08 00 E0 03 48 00 BD 27 }
	condition:
		$1
}

rule file_501_0_0 {
	meta:
		name = "__GI_fputws"
		size = 176
		refs = "0000 _gp_disp 0038 _pthread_cleanup_push_defer 0040 __pthread_mutex_unlock 0054 __pthread_mutex_lock 0064 __GI_fputws_unlocked 007c _pthread_cleanup_pop_restore"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 B8 FF BD 27 40 00 B3 AF 34 00 B0 AF 10 00 BC AF 44 00 BF AF 3C 00 B2 AF 38 00 B1 AF 34 00 B1 8C 21 98 80 00 0C 00 20 16 21 80 A0 00 ?? ?? 99 8F 38 00 B2 24 ?? ?? 85 8F 18 00 A4 27 ?? ?? ?? ?? 21 30 40 02 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 40 02 10 00 BC 8F ?? ?? 99 8F 21 20 60 02 ?? ?? ?? ?? 21 28 00 02 07 00 20 16 10 00 BC 8F ?? ?? 99 8F 28 00 A2 AF 18 00 A4 27 ?? ?? ?? ?? 01 00 05 24 28 00 A2 8F 44 00 BF 8F 40 00 B3 8F 3C 00 B2 8F 38 00 B1 8F 34 00 B0 8F 08 00 E0 03 48 00 BD 27 }
	condition:
		$1
}

rule file_743_0_0 {
	meta:
		name = "fputwc"
		size = 176
		refs = "0000 _gp_disp 0038 _pthread_cleanup_push_defer 0040 __pthread_mutex_unlock 0054 __pthread_mutex_lock 0064 __GI_fputwc_unlocked 007c _pthread_cleanup_pop_restore"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 B8 FF BD 27 40 00 B3 AF 34 00 B0 AF 10 00 BC AF 44 00 BF AF 3C 00 B2 AF 38 00 B1 AF 34 00 B1 8C 21 98 80 00 0C 00 20 16 21 80 A0 00 ?? ?? 99 8F 38 00 B2 24 ?? ?? 85 8F 18 00 A4 27 ?? ?? ?? ?? 21 30 40 02 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 40 02 10 00 BC 8F ?? ?? 99 8F 21 20 60 02 ?? ?? ?? ?? 21 28 00 02 07 00 20 16 10 00 BC 8F ?? ?? 99 8F 28 00 A2 AF 18 00 A4 27 ?? ?? ?? ?? 01 00 05 24 28 00 A2 8F 44 00 BF 8F 40 00 B3 8F 3C 00 B2 8F 38 00 B1 8F 34 00 B0 8F 08 00 E0 03 48 00 BD 27 }
	condition:
		$1
}

rule file_315_0_0 {
	meta:
		name = "__GI_send"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 52 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_316_0_0 {
	meta:
		name = "wait3"
		size = 44
		refs = "0000 _gp_disp 000c __GI_wait4"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F 21 18 80 00 21 10 A0 00 21 38 C0 00 FF FF 04 24 21 28 60 00 ?? ?? ?? ?? 21 30 40 00 }
	condition:
		$1
}

rule file_317_0_0 {
	meta:
		name = "semget"
		size = 76
		refs = "0000 _gp_disp 000c __syscall_ipc"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F D8 FF BD 27 21 18 80 00 21 10 A0 00 21 38 C0 00 24 00 BF AF 18 00 BC AF 10 00 A0 AF 14 00 A0 AF 02 00 04 24 21 28 60 00 ?? ?? ?? ?? 21 30 40 00 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_318_0_0 {
	meta:
		name = "seekdir"
		size = 176
		refs = "0000 _gp_disp 0010 _pthread_cleanup_push_defer 001c __pthread_mutex_unlock 0050 __pthread_mutex_lock 0068 __GI_lseek 0080 _pthread_cleanup_pop_restore"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 C0 FF BD 27 ?? ?? 99 8F 38 00 B3 AF 21 98 A0 00 ?? ?? 85 8F 34 00 B2 AF 30 00 B1 AF 18 00 92 24 18 00 B1 27 3C 00 BF AF 2C 00 B0 AF 10 00 BC AF 21 80 80 00 21 30 40 02 ?? ?? ?? ?? 21 20 20 02 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 40 02 10 00 BC 8F 00 00 04 8E 21 28 60 02 ?? ?? 99 8F ?? ?? ?? ?? 21 30 00 00 10 00 BC 8F 10 00 02 AE 21 20 20 02 ?? ?? 99 8F 04 00 00 AE 08 00 00 AE ?? ?? ?? ?? 01 00 05 24 3C 00 BF 8F 38 00 B3 8F 34 00 B2 8F 30 00 B1 8F 2C 00 B0 8F 08 00 E0 03 40 00 BD 27 }
	condition:
		$1
}

rule file_319_0_0 {
	meta:
		name = "__GI_strsignal"
		size = 208
		refs = "0000 _gp_disp 0058 _string_syssigmsgs 0080 _uintmaxtostr 00ac __GI_memcpy"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 21 30 80 00 ?? ?? 84 8F D8 FF BD 27 21 18 00 00 ?? ?? 84 24 18 00 BC AF 24 00 BF AF 21 00 02 24 21 28 64 00 00 00 A5 90 07 00 A6 50 20 00 C2 2C 01 00 63 24 FB FF 62 14 21 28 64 00 FF 7F 03 3C FF FF 63 34 20 00 C2 2C 09 00 40 10 ?? ?? 87 8F 05 00 60 10 00 00 E2 80 01 00 42 2C 23 18 62 00 FB FF 00 10 01 00 E7 24 13 00 40 14 24 00 BF 8F ?? ?? 84 8F ?? ?? 99 8F F6 FF 02 24 C3 3F 06 00 ?? ?? 84 24 10 00 A2 AF ?? ?? ?? ?? 14 00 A0 AF 18 00 BC 8F F1 FF 47 24 21 20 E0 00 ?? ?? 85 8F ?? ?? 99 8F 0F 00 06 24 ?? ?? ?? ?? ?? ?? A5 24 21 38 40 00 24 00 BF 8F 21 10 E0 00 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_320_0_0 {
	meta:
		name = "__stdio_adjust_position"
		size = 252
		refs = "0000 _gp_disp 00d4 __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 00 00 83 94 03 00 62 30 12 00 40 50 21 10 00 00 FF FF 42 24 0F 00 40 10 00 08 66 30 0E 00 C0 50 40 00 63 30 02 00 06 24 28 00 46 50 FF FF 10 24 28 00 82 8C 25 00 40 54 FF FF 10 24 03 00 82 90 2C 00 86 8C 03 00 C0 18 23 10 02 00 02 00 86 90 23 10 46 00 40 00 63 30 02 00 60 50 14 00 83 8C 08 00 83 8C 10 00 84 8C 00 00 A6 8C 23 18 64 00 21 10 43 00 04 00 A3 8C 23 38 C2 00 C3 27 02 00 2B 30 C7 00 23 20 64 00 23 20 86 00 00 00 A7 AC 04 00 A4 AC 2A 28 64 00 05 00 A0 54 23 10 02 00 03 00 83 14 00 00 00 00 01 00 C0 54 23 10 02 00 06 00 41 04 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 4F 00 03 24 00 00 43 AC 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_321_0_0 {
	meta:
		name = "__GI_chown"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 6A 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_322_0_0 {
	meta:
		name = "__GI_sgetspent_r"
		size = 208
		refs = "0000 _gp_disp 0040 __GI___errno_location 006c __GI_strlen 0084 __GI_strcpy 0098 __parsespent"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D0 FF BD 27 1C 00 B1 AF 40 00 B1 8F 10 00 BC AF 00 01 E2 2C 28 00 B4 AF 2C 00 BF AF 24 00 B3 AF 20 00 B2 AF 18 00 B0 AF 21 A0 E0 00 08 00 40 10 00 00 20 AE ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 22 00 03 24 00 00 43 AC 16 00 00 10 22 00 02 24 21 98 80 00 21 90 A0 00 0C 00 86 10 21 80 C0 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 2B 10 54 00 F0 FF 40 10 10 00 BC 8F ?? ?? 99 8F 21 20 00 02 ?? ?? ?? ?? 21 28 60 02 10 00 BC 8F ?? ?? 99 8F 21 20 40 02 ?? ?? ?? ?? 21 28 00 02 01 00 40 50 00 00 32 AE 2C 00 BF 8F 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_323_0_0 {
	meta:
		name = "_load_inttype"
		size = 108
	strings:
		$1 = { 0F 00 C0 04 00 08 82 30 04 00 40 50 00 01 03 24 00 00 A2 8C 08 00 E0 03 04 00 A3 8C 03 00 83 14 00 00 A2 8C 04 00 00 10 FF 00 42 30 FF FF 43 30 00 02 84 38 0A 10 64 00 08 00 E0 03 21 18 00 00 F4 FF 40 14 00 00 A2 8C 00 01 03 24 03 00 83 54 20 1E 02 7C 03 00 00 10 20 14 02 7C 00 02 84 38 0A 10 64 00 08 00 E0 03 C3 1F 02 00 }
	condition:
		$1
}

rule file_324_0_0 {
	meta:
		name = "mblen"
		size = 120
		refs = "0000 _gp_disp 0040 __GI_mbrlen"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 05 00 80 54 00 00 83 80 ?? ?? 82 8F ?? ?? 40 AC 0E 00 00 10 21 10 00 00 0C 00 60 10 21 10 00 00 ?? ?? 90 8F ?? ?? 99 8F ?? ?? ?? ?? ?? ?? 06 26 FE FF 03 24 06 00 43 14 1C 00 BF 8F FF FF 02 34 ?? ?? 10 26 04 00 02 AE FF FF 02 24 1C 00 BF 8F 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_325_0_0 {
	meta:
		name = "__GI_vdprintf"
		size = 200
		refs = "0000 _gp_disp 001c __stdio_init_mutex 007c _vfprintf_internal 009c __GI_fflush_unlocked"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 40 FF BD 27 A8 00 A2 27 24 00 A2 AF 68 00 A2 27 ?? ?? 99 8F 20 00 A2 AF 30 00 A2 AF 34 00 A2 AF 28 00 A2 AF 2C 00 A2 AF D0 00 02 24 18 00 A2 A7 01 00 02 24 10 00 BC AF BC 00 BF AF B8 00 B1 AF B4 00 B0 AF 1C 00 A4 AF 4C 00 A2 AF A8 00 A5 AF AC 00 A6 AF 1A 00 A0 A3 44 00 A0 AF ?? ?? ?? ?? 50 00 A4 27 10 00 BC 8F A8 00 A5 8F AC 00 A6 8F ?? ?? 99 8F 18 00 B1 27 38 00 A0 AF ?? ?? ?? ?? 21 20 20 02 21 80 40 00 06 00 40 18 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 20 02 FF FF 03 24 0B 80 62 00 BC 00 BF 8F 21 10 00 02 B8 00 B1 8F B4 00 B0 8F 08 00 E0 03 C0 00 BD 27 }
	condition:
		$1
}

rule file_327_0_0 {
	meta:
		name = "ualarm"
		size = 108
		refs = "0000 _gp_disp 000c __GI_setitimer"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F C0 FF BD 27 28 00 A6 27 10 00 BC AF 1C 00 A5 AF 24 00 A4 AF 3C 00 BF AF 18 00 A0 AF 20 00 A0 AF 21 20 00 00 ?? ?? ?? ?? 18 00 A5 27 07 00 40 04 FF FF 03 24 30 00 A4 8F 0F 00 03 3C 40 42 63 24 02 28 83 70 34 00 A2 8F 21 18 A2 00 3C 00 BF 8F 21 10 60 00 08 00 E0 03 40 00 BD 27 }
	condition:
		$1
}

rule file_328_0_0 {
	meta:
		name = "sendfile64"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 8D 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_329_0_0 {
	meta:
		name = "setfsgid"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 2B 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_330_0_0 {
	meta:
		name = "__parsepwent"
		size = 276
		refs = "0000 _gp_disp 0020 __GI_strchr 0024 __GI_strtoul"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 B8 FF BD 27 2C 00 B3 AF ?? ?? 93 8F 3C 00 B7 AF 38 00 B6 AF ?? ?? 97 8F ?? ?? 96 8F 34 00 B5 AF 30 00 B4 AF 28 00 B2 AF 24 00 B1 AF 20 00 B0 AF 10 00 BC AF 44 00 BF AF 40 00 BE AF 21 90 80 00 21 88 A0 00 21 80 00 00 ?? ?? 73 26 02 00 14 24 18 00 B5 27 21 10 13 02 00 00 5E 90 06 00 02 32 0C 00 54 10 21 F0 5E 02 06 00 02 24 19 00 02 12 00 00 D1 AF 21 20 20 02 21 C8 E0 02 ?? ?? ?? ?? 3A 00 05 24 10 00 40 14 01 00 51 24 12 00 00 10 FF FF 02 24 21 20 20 02 21 28 A0 02 21 C8 C0 02 ?? ?? ?? ?? 0A 00 06 24 21 18 40 00 18 00 A2 8F F6 FF 51 10 3A 00 04 24 00 00 45 80 F3 FF A4 14 01 00 51 24 00 00 C3 AF 00 00 40 A0 E1 FF 00 10 01 00 10 26 21 10 00 00 44 00 BF 8F 40 00 BE 8F 3C 00 B7 8F 38 00 B6 8F 34 00 B5 8F 30 00 B4 8F 2C 00 B3 8F 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 08 00 E0 03 48 00 BD 27 }
	condition:
		$1
}

rule file_331_0_0 {
	meta:
		name = "__GI_readdir"
		size = 256
		refs = "0000 _gp_disp 0010 _pthread_cleanup_push_defer 0014 __pthread_mutex_unlock 004c __pthread_mutex_lock 005c __getdents 00c8 _pthread_cleanup_pop_restore"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 C0 FF BD 27 ?? ?? 99 8F ?? ?? 85 8F 34 00 B2 AF 30 00 B1 AF 18 00 B2 27 18 00 91 24 10 00 BC AF 3C 00 BF AF 38 00 B3 AF 2C 00 B0 AF 21 30 20 02 21 80 80 00 ?? ?? ?? ?? 21 20 40 02 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 20 02 10 00 BC 8F ?? ?? 93 8F 08 00 03 8E 04 00 02 8E 2B 10 43 00 0B 00 40 54 04 00 02 8E 00 00 04 8E 0C 00 05 8E 21 C8 60 02 ?? ?? ?? ?? 14 00 06 8E 10 00 40 18 10 00 BC 8F 08 00 02 AE 04 00 00 AE 04 00 02 8E 0C 00 11 8E 21 88 22 02 08 00 23 96 21 10 62 00 04 00 02 AE 04 00 22 8E 10 00 02 AE 00 00 22 8E E9 FF 40 50 08 00 03 8E 03 00 00 10 ?? ?? 99 8F 21 88 00 00 ?? ?? 99 8F 21 20 40 02 ?? ?? ?? ?? 01 00 05 24 3C 00 BF 8F 21 10 20 02 38 00 B3 8F 34 00 B2 8F 30 00 B1 8F 2C 00 B0 8F 08 00 E0 03 40 00 BD 27 }
	condition:
		$1
}

rule file_333_0_0 {
	meta:
		name = "__encode_answer"
		size = 248
		refs = "0000 _gp_disp 0028 __encode_dotted 0064 __GI_memcpy"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D0 FF BD 27 10 00 BC AF 28 00 B3 AF 24 00 B2 AF 20 00 B1 AF 1C 00 B0 AF 2C 00 BF AF ?? ?? 99 8F 21 80 80 00 00 00 84 8C 21 98 A0 00 ?? ?? ?? ?? 21 90 C0 00 21 88 40 00 25 00 40 04 10 00 BC 8F 21 20 62 02 10 00 02 8E 23 90 51 02 09 00 42 24 2A 90 52 00 1D 00 40 12 ?? ?? 99 8F 05 00 02 92 0A 00 84 24 F6 FF 82 A0 04 00 02 8E 0A 00 31 26 F7 FF 82 A0 09 00 02 92 F8 FF 82 A0 08 00 02 8E F9 FF 82 A0 0F 00 02 92 FA FF 82 A0 0E 00 02 92 FB FF 82 A0 0D 00 02 92 FC FF 82 A0 0C 00 02 8E FD FF 82 A0 11 00 02 92 FE FF 82 A0 10 00 02 8E FF FF 82 A0 14 00 05 8E ?? ?? ?? ?? 10 00 06 8E 10 00 02 8E 02 00 00 10 21 10 22 02 FF FF 02 24 2C 00 BF 8F 28 00 B3 8F 24 00 B2 8F 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_335_0_0 {
	meta:
		name = "__GI_utimes"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF AB 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_336_0_0 {
	meta:
		name = "__GI_basename"
		size = 36
	strings:
		$1 = { 21 10 80 00 00 00 83 80 04 00 60 10 01 00 84 24 2F 00 63 38 FB FF 00 10 0A 10 83 00 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_338_0_0 {
	meta:
		name = "__GI_geteuid"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF D1 0F 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_339_0_0 {
	meta:
		name = "__GI_execlp"
		size = 184
		refs = "0000 _gp_disp 0098 __GI_execvp"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D8 FF BD 27 20 00 BE AF 21 F0 A0 03 30 00 C6 AF 30 00 C6 27 24 00 BF AF 10 00 BC AF 34 00 C7 AF 18 00 C6 AF 21 18 00 00 18 00 C7 8F 01 00 62 24 04 00 E8 24 00 00 E7 8C 03 00 E0 10 18 00 C8 AF F9 FF 00 10 21 18 40 00 80 18 03 00 16 00 63 24 C2 18 03 00 C0 18 03 00 23 E8 A3 03 10 00 A3 27 00 00 65 AC 18 00 C6 AF 21 28 60 00 18 00 C6 8F 04 00 A5 24 FF FF 42 24 04 00 C7 24 00 00 C6 8C 18 00 C7 AF F9 FF 40 14 00 00 A6 AC ?? ?? 99 8F ?? ?? ?? ?? 21 28 60 00 21 E8 C0 03 24 00 BF 8F 20 00 BE 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_340_0_0 {
	meta:
		name = "__GI_times"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF CB 0F 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_341_0_0 {
	meta:
		name = "__GI_socket"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 57 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_342_0_0 {
	meta:
		name = "__GI_rexec_af"
		size = 1480
		refs = "0000 _gp_disp 001c __GI_snprintf 0018 $LC0 008c __GI_memset 00ac __GI_getaddrinfo 00e0 __GI_strncpy 00e4 ahostbuf 0100 __GI_ruserpass 011c __GI_socket 0120 __GI_connect 0124 __GI___errno_location 0128 __GI_close 0130 __GI_sleep 01cc $LC1 01e0 __GI_perror 0204 __GI_write 0200 $LC2 0258 __GI_listen 0274 __GI_getsockname 0294 $LC3 02ac __libc_sa_len 02e8 __GI_getnameinfo 031c __GI_atoi 0334 __GI_sprintf 0330 $LC4 0358 __GI_strlen 0388 __GI_accept 03e8 $LC5 048c free 04b8 __GI_read 04fc __GI_freeaddrinfo"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 30 FE BD 27 D8 01 A6 AF 98 01 A6 AF ?? ?? 86 8F ?? ?? 99 8F DC 01 A7 AF 9C 01 A7 AF 00 3A 05 00 00 3A A2 7C B8 01 B4 AF 00 FF E7 30 48 01 B4 27 CC 01 BF AF 20 00 BC AF 25 38 E2 00 B4 01 B3 AF AC 01 B1 AF A8 01 B0 AF 21 98 80 00 20 00 05 24 21 20 80 02 ?? ?? C6 24 C8 01 BE AF C4 01 B7 AF C0 01 B6 AF BC 01 B5 AF B0 01 B2 AF ?? ?? ?? ?? E8 01 B0 97 20 00 BC 8F 68 01 B1 27 21 20 20 02 ?? ?? 99 8F 21 28 00 00 20 00 06 24 ?? ?? ?? ?? 67 01 A0 A3 20 00 BC 8F 00 00 64 8E 6C 01 B0 AF ?? ?? 99 8F 02 00 10 24 70 01 B0 AF 68 01 B0 AF 21 28 80 02 21 30 20 02 ?? ?? ?? ?? 90 01 A7 27 31 01 40 14 20 00 BC 8F 90 01 B1 8F 18 00 25 8E 15 00 A0 10 ?? ?? 99 8F ?? ?? 84 8F ?? ?? ?? ?? 01 04 06 24 20 00 BC 8F D8 01 A5 27 DC 01 A6 27 ?? ?? 82 8F ?? ?? 99 8F 00 04 40 A0 00 00 62 AE 18 00 24 8E ?? ?? ?? ?? 01 00 11 24 20 00 BC 8F ?? ?? 96 8F ?? ?? 95 8F ?? ?? 92 8F ?? ?? 97 8F 1E 00 00 10 ?? ?? 9E 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 60 AE 14 01 00 10 00 00 50 AC 90 01 A2 8F 21 20 00 02 21 C8 A0 02 14 00 45 8C ?? ?? ?? ?? 10 00 46 8C 24 00 41 04 20 00 BC 8F 21 C8 40 02 ?? ?? ?? ?? 00 00 00 00 00 00 43 8C 92 00 02 24 16 00 62 14 20 00 BC 8F 11 00 22 2A 13 00 40 10 21 C8 E0 02 ?? ?? ?? ?? 21 20 00 02 21 20 20 02 21 C8 C0 03 ?? ?? ?? ?? 40 88 11 00 90 01 A2 8F 21 30 00 00 21 C8 C0 02 04 00 44 8C ?? ?? ?? ?? 08 00 45 8C 21 80 40 00 E0 FF 41 04 20 00 BC 8F ?? ?? 84 8F 03 00 00 10 ?? ?? 84 24 90 01 A2 8F 18 00 44 8C ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 E9 00 00 10 00 00 00 00 E4 01 B9 8F 0A 00 20 17 90 01 A2 8F ?? ?? 85 8F ?? ?? 99 8F 21 20 00 02 ?? ?? A5 24 ?? ?? ?? ?? 01 00 06 24 21 90 00 00 7A 00 00 10 20 00 BC 8F ?? ?? 99 8F 21 30 00 00 04 00 44 8C ?? ?? ?? ?? 08 00 45 8C 21 88 40 00 06 00 41 04 20 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 00 02 D0 00 00 10 00 00 00 00 ?? ?? 99 8F 21 20 40 00 ?? ?? ?? ?? 01 00 05 24 20 00 BC 8F 80 00 02 24 A8 00 B2 27 ?? ?? 99 8F 8C 01 A2 AF 21 20 20 02 21 28 40 02 ?? ?? ?? ?? 8C 01 A6 27 07 00 41 04 20 00 BC 8F ?? ?? 84 8F ?? ?? 99 8F ?? ?? ?? ?? ?? ?? 84 24 0D 00 00 10 20 00 BC 8F ?? ?? 99 8F A8 00 A4 97 ?? ?? ?? ?? 8C 01 B5 8F 09 00 A2 12 20 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 16 00 03 24 20 00 BC 8F 00 00 43 AC A2 00 00 10 21 20 20 02 20 00 02 24 ?? ?? 99 8F 8C 01 A5 8F 14 00 A2 AF 02 00 02 24 21 20 40 02 10 00 B4 AF 18 00 A2 AF 21 30 00 00 ?? ?? ?? ?? 21 38 00 00 21 90 00 00 06 00 40 14 20 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 80 02 20 00 BC 8F FF FF 52 30 ?? ?? 85 8F ?? ?? 99 8F 28 01 B4 27 21 20 80 02 ?? ?? A5 24 ?? ?? ?? ?? 21 30 40 02 20 00 BC 8F 21 20 80 02 88 01 B6 27 ?? ?? 99 8F ?? ?? ?? ?? FF FF 1E 24 20 00 BC 8F 21 28 80 02 21 20 00 02 ?? ?? 99 8F ?? ?? ?? ?? 01 00 46 24 20 00 BC 8F 80 00 02 24 28 00 B9 27 ?? ?? 97 8F ?? ?? 94 8F 88 01 A2 AF A0 01 B9 AF 21 20 20 02 28 00 A5 27 21 C8 E0 02 ?? ?? ?? ?? 21 30 C0 02 21 A8 40 00 08 00 5E 14 20 00 BC 8F 21 C8 80 02 ?? ?? ?? ?? 00 00 00 00 00 00 44 8C 04 00 02 24 F2 FF 82 10 20 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 20 02 07 00 A1 06 20 00 BC 8F ?? ?? 84 8F ?? ?? 99 8F ?? ?? ?? ?? ?? ?? 84 24 5F 00 00 10 20 00 BC 8F E4 01 B9 8F 00 00 35 AF ?? ?? 94 8F D8 01 B1 8F 21 C8 80 02 ?? ?? ?? ?? 21 20 20 02 20 00 BC 8F 21 28 20 02 01 00 46 24 ?? ?? 91 8F 21 C8 20 02 ?? ?? ?? ?? 21 20 00 02 DC 01 B5 8F 21 C8 80 02 ?? ?? ?? ?? 21 20 A0 02 01 00 46 24 21 28 A0 02 21 C8 20 02 ?? ?? ?? ?? 21 20 00 02 21 C8 80 02 ?? ?? ?? ?? E0 01 A4 8F E0 01 A5 8F 21 20 00 02 21 C8 20 02 ?? ?? ?? ?? 01 00 46 24 D8 01 A4 8F 98 01 B9 8F 05 00 99 10 20 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 20 00 BC 8F DC 01 A4 8F 9C 01 B9 8F 04 00 99 10 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 20 00 BC 8F ?? ?? 95 8F 28 01 B4 27 21 20 00 02 21 28 80 02 21 C8 A0 02 ?? ?? ?? ?? 01 00 06 24 01 00 03 24 06 00 43 10 20 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 64 8E 1B 00 00 10 20 00 BC 8F 28 01 A2 83 14 00 40 10 ?? ?? 99 8F 0A 00 13 24 21 20 00 02 21 28 80 02 21 C8 A0 02 ?? ?? ?? ?? 01 00 06 24 01 00 03 24 0F 00 43 14 20 00 BC 8F 02 00 04 24 21 28 80 02 21 C8 20 02 ?? ?? ?? ?? 01 00 06 24 28 01 A2 83 F1 FF 53 14 20 00 BC 8F 05 00 00 10 00 00 00 00 ?? ?? ?? ?? 90 01 A4 8F 10 00 00 10 21 10 00 02 06 00 40 12 E4 01 B9 8F 00 00 24 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 20 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 00 02 20 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 90 01 A4 8F FF FF 02 24 CC 01 BF 8F C8 01 BE 8F C4 01 B7 8F C0 01 B6 8F BC 01 B5 8F B8 01 B4 8F B4 01 B3 8F B0 01 B2 8F AC 01 B1 8F A8 01 B0 8F 08 00 E0 03 D0 01 BD 27 }
	condition:
		$1
}

rule file_342_1_0 {
	meta:
		name = "rexec"
		size = 68
		refs = "0000 _gp_disp 0014 __GI_rexec_af"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D0 FF BD 27 40 00 A2 8F ?? ?? 99 8F 2C 00 BF AF 10 00 A2 AF 44 00 A2 8F 20 00 BC AF 14 00 A2 AF 02 00 02 24 ?? ?? ?? ?? 18 00 A2 AF 2C 00 BF 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_345_0_0 {
	meta:
		name = "__drand48_iterate"
		size = 144
	strings:
		$1 = { 0E 00 A2 94 0B 00 40 54 02 00 82 94 EC DE 02 3C 6D E6 42 34 10 00 A2 AC 0B 00 02 24 05 00 03 24 0C 00 A2 A4 01 00 02 24 14 00 A3 AC 0E 00 A2 A4 02 00 82 94 00 00 83 94 14 00 A6 8C 00 14 02 00 25 10 62 00 18 00 C2 00 10 00 A3 8C 04 00 87 94 00 00 67 70 12 30 00 00 19 00 62 00 10 18 00 00 21 30 C3 00 0C 00 A3 94 12 10 00 00 21 18 43 00 2B 10 62 00 21 10 46 00 00 00 83 A4 02 1C 03 00 04 00 82 A4 02 00 83 A4 08 00 E0 03 21 10 00 00 }
	condition:
		$1
}

rule file_346_0_0 {
	meta:
		name = "valloc"
		size = 100
		refs = "0000 _gp_disp 0030 __GI_getpagesize 0058 memalign"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D8 FF BD 27 1C 00 B0 AF ?? ?? 90 8F 10 00 BC AF 20 00 B1 AF ?? ?? 02 8E 24 00 BF AF 06 00 40 14 21 88 80 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F ?? ?? 02 AE 24 00 BF 8F ?? ?? 04 8E 21 28 20 02 1C 00 B0 8F 20 00 B1 8F ?? ?? 99 8F ?? ?? ?? ?? 28 00 BD 27 }
	condition:
		$1
}

rule file_348_1_0 {
	meta:
		name = "authunix_marshal"
		size = 28
	strings:
		$1 = { 24 00 82 8C 04 00 A3 8C 21 20 A0 00 AC 01 46 8C 0C 00 79 8C 08 00 20 03 1C 00 45 24 }
	condition:
		$1
}

rule file_348_2_0 {
	meta:
		name = "authunix_destroy"
		size = 148
		refs = "0000 _gp_disp 0024 free"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D8 FF BD 27 10 00 BC AF 1C 00 B0 AF 24 00 BF AF 20 00 B1 AF 24 00 91 8C ?? ?? 99 8F 21 80 80 00 ?? ?? ?? ?? 04 00 24 8E 10 00 24 8E 05 00 80 10 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 24 00 04 8E 10 00 04 8E 05 00 80 10 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F 24 00 BF 8F 20 00 B1 8F 21 20 00 02 ?? ?? 99 8F 1C 00 B0 8F ?? ?? ?? ?? 28 00 BD 27 }
	condition:
		$1
}

rule file_348_3_0 {
	meta:
		name = "marshal_new_auth"
		size = 232
		refs = "0000 _gp_disp 002c __GI_xdrmem_create 0054 __GI_xdr_opaque_auth 0070 __GI_perror 006c $LC0"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 B8 FF BD 27 10 00 BC AF 44 00 BF AF 40 00 B3 AF 38 00 B1 AF 34 00 B0 AF 3C 00 B2 AF 24 00 92 8C ?? ?? 99 8F 18 00 B0 27 21 88 80 00 1C 00 45 26 21 20 00 02 90 01 06 24 ?? ?? ?? ?? 21 38 00 00 10 00 BC 8F 21 20 00 02 ?? ?? 93 8F 21 C8 60 02 ?? ?? ?? ?? 21 28 20 02 07 00 40 14 10 00 BC 8F ?? ?? 84 8F ?? ?? 99 8F ?? ?? ?? ?? ?? ?? 84 24 0D 00 00 10 1C 00 A2 8F 21 20 00 02 21 C8 60 02 ?? ?? ?? ?? 0C 00 25 26 F5 FF 40 10 10 00 BC 8F 1C 00 A2 8F 10 00 59 8C 09 F8 20 03 21 20 00 02 AC 01 42 AE 1C 00 A2 8F 1C 00 59 8C 04 00 20 13 44 00 BF 8F 09 F8 20 03 21 20 00 02 44 00 BF 8F 40 00 B3 8F 3C 00 B2 8F 38 00 B1 8F 34 00 B0 8F 01 00 02 24 08 00 E0 03 48 00 BD 27 }
	condition:
		$1
}

rule file_348_4_0 {
	meta:
		name = "authunix_refresh"
		size = 368
		refs = "0000 _gp_disp 0050 __GI_xdrmem_create 0080 __GI_xdr_authunix_parms 009c __GI_gettimeofday 0108 marshal_new_auth"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 90 FF BD 27 5C 00 B2 AF 10 00 BC AF 6C 00 BF AF 68 00 B5 AF 64 00 B4 AF 60 00 B3 AF 58 00 B1 AF 54 00 B0 AF 24 00 90 8C 04 00 83 8C 04 00 02 8E 42 00 62 10 21 90 80 00 18 00 02 8E 44 00 A0 AF 34 00 A0 AF ?? ?? 99 8F 04 00 05 8E 08 00 06 8E 01 00 42 24 18 00 B1 27 18 00 02 AE 21 20 20 02 ?? ?? ?? ?? 01 00 07 24 10 00 BC 8F 30 00 B4 27 21 20 20 02 ?? ?? 95 8F 21 28 80 02 21 C8 A0 02 ?? ?? ?? ?? 21 98 00 00 1E 00 40 10 10 00 BC 8F ?? ?? 99 8F 48 00 A4 27 ?? ?? ?? ?? 21 28 00 00 48 00 A2 8F 21 20 20 02 30 00 A2 AF 1C 00 A2 8F 18 00 A0 AF 14 00 59 8C 09 F8 20 03 21 28 00 00 21 20 20 02 21 C8 A0 02 ?? ?? ?? ?? 21 28 80 02 21 98 40 00 0B 00 40 10 10 00 BC 8F 00 00 02 8E ?? ?? 99 8F 21 20 40 02 00 00 42 AE 04 00 02 8E ?? ?? 39 27 04 00 42 AE 08 00 02 8E ?? ?? ?? ?? 08 00 42 AE 02 00 02 24 21 C8 A0 02 18 00 A2 AF 21 20 20 02 ?? ?? ?? ?? 21 28 80 02 1C 00 A2 8F 1C 00 59 8C 06 00 20 53 21 10 60 02 09 F8 20 03 21 20 20 02 02 00 00 10 21 10 60 02 21 10 00 00 6C 00 BF 8F 68 00 B5 8F 64 00 B4 8F 60 00 B3 8F 5C 00 B2 8F 58 00 B1 8F 54 00 B0 8F 08 00 E0 03 70 00 BD 27 }
	condition:
		$1
}

rule file_348_5_0 {
	meta:
		name = "authunix_validate"
		size = 292
		refs = "0000 _gp_disp 0044 __GI_xdrmem_create 006c free 0080 __GI_xdr_opaque_auth 00f8 marshal_new_auth"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 B8 FF BD 27 34 00 B1 AF 10 00 BC AF 44 00 BF AF 40 00 B4 AF 3C 00 B3 AF 38 00 B2 AF 30 00 B0 AF 21 88 80 00 00 00 A4 8C 02 00 03 24 31 00 83 14 21 10 A0 00 24 00 30 8E ?? ?? 99 8F 04 00 A5 8C 08 00 46 8C 18 00 B2 27 21 20 40 02 ?? ?? ?? ?? 01 00 07 24 10 00 04 8E 06 00 80 10 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F 10 00 00 AE ?? ?? 93 8F 0C 00 14 26 21 20 40 02 21 C8 60 02 ?? ?? ?? ?? 21 28 80 02 07 00 40 10 10 00 BC 8F 0C 00 02 8E 00 00 22 AE 10 00 02 8E 04 00 22 AE 0E 00 00 10 14 00 02 8E 02 00 02 24 18 00 A2 AF 21 20 40 02 21 C8 60 02 ?? ?? ?? ?? 21 28 80 02 00 00 02 8E 10 00 BC 8F 10 00 00 AE 00 00 22 AE 04 00 02 8E 04 00 22 AE 08 00 02 8E ?? ?? 99 8F 08 00 22 AE ?? ?? 39 27 ?? ?? ?? ?? 21 20 20 02 44 00 BF 8F 40 00 B4 8F 3C 00 B3 8F 38 00 B2 8F 34 00 B1 8F 30 00 B0 8F 01 00 02 24 08 00 E0 03 48 00 BD 27 }
	condition:
		$1
}

rule file_348_6_0 {
	meta:
		name = "__GI_authunix_create"
		size = 524
		refs = "0000 _gp_disp 000c malloc 006c stderr 0074 __GI_fputs 0070 $LC1 0088 free 00b0 __GI_gettimeofday 00c4 _null_auth 0110 __GI_xdrmem_create 0148 __GI_xdr_authunix_parms 015c __GI_abort 01a4 __GI_memcpy 01dc marshal_new_auth"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F 00 FE BD 27 10 00 BC AF FC 01 BF AF F8 01 B5 AF F4 01 B4 AF F0 01 B3 AF EC 01 B2 AF E8 01 B1 AF E4 01 B0 AF 21 A8 80 00 28 00 04 24 21 A0 A0 00 21 98 C0 00 ?? ?? ?? ?? 21 90 E0 00 10 00 BC 8F B0 01 04 24 ?? ?? 99 8F ?? ?? ?? ?? 21 88 40 00 21 80 40 00 11 00 20 16 10 00 BC 8F ?? ?? 82 8F ?? ?? 84 8F ?? ?? 99 8F 00 00 45 8C ?? ?? ?? ?? ?? ?? 84 24 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 20 02 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 00 02 50 00 00 10 21 10 00 00 EF FF 40 10 ?? ?? 99 8F ?? ?? 82 8F 21 28 00 00 ?? ?? 42 24 20 00 22 AE ?? ?? 82 8F 24 00 30 AE 18 00 00 AE 04 00 43 8C 00 00 44 8C 08 00 42 8C 10 00 03 AE 10 00 23 AE 0C 00 04 AE 0C 00 24 AE 14 00 02 AE D8 01 A4 27 ?? ?? ?? ?? 14 00 22 AE D8 01 A2 8F 10 00 BC 8F CC 01 B3 AF C0 01 A2 AF 10 02 A2 8F ?? ?? 99 8F D0 01 B2 AF 18 00 B3 27 A8 01 B2 27 D4 01 A2 AF 21 20 40 02 21 28 60 02 90 01 06 24 21 38 00 00 C4 01 B5 AF ?? ?? ?? ?? C8 01 B4 AF 10 00 BC 8F 21 20 40 02 ?? ?? 99 8F ?? ?? ?? ?? C0 01 A5 27 04 00 40 14 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 AC 01 A2 8F 10 00 59 8C 09 F8 20 03 21 20 40 02 10 00 BC 8F 21 90 40 00 08 00 02 AE ?? ?? 99 8F 01 00 02 24 00 00 02 AE ?? ?? ?? ?? 21 20 40 02 04 00 02 AE B3 FF 40 10 10 00 BC 8F ?? ?? 99 8F 21 20 40 00 21 28 60 02 ?? ?? ?? ?? 21 30 40 02 00 00 02 8E 10 00 BC 8F 21 20 20 02 00 00 22 AE 04 00 02 8E ?? ?? 99 8F 04 00 22 AE 08 00 02 8E ?? ?? 39 27 ?? ?? ?? ?? 08 00 22 AE 21 10 20 02 FC 01 BF 8F F8 01 B5 8F F4 01 B4 8F F0 01 B3 8F EC 01 B2 8F E8 01 B1 8F E4 01 B0 8F 08 00 E0 03 00 02 BD 27 }
	condition:
		$1
}

rule file_348_7_0 {
	meta:
		name = "__GI_authunix_create_default"
		size = 300
		refs = "0000 _gp_disp 000c __GI_sysconf 0044 malloc 005c __GI_abort 006c __GI_gethostname 008c __GI_geteuid 009c __GI_getegid 00b4 __GI_getgroups 00d0 __GI_authunix_create 00fc free"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F C0 FE BD 27 18 00 BC AF 2C 01 B1 AF 3C 01 BF AF 38 01 B4 AF 34 01 B3 AF 30 01 B2 AF 28 01 B0 AF ?? ?? ?? ?? 03 00 04 24 21 88 40 00 0A 00 40 10 18 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 80 20 02 00 21 80 40 00 05 00 40 14 18 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 21 80 00 00 ?? ?? 99 8F 20 00 B2 27 21 20 40 02 ?? ?? ?? ?? FF 00 05 24 FF FF 03 24 F5 FF 43 10 18 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 1F 01 A0 A3 18 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 A0 40 00 18 00 BC 8F 21 20 20 02 21 28 00 02 ?? ?? 99 8F ?? ?? ?? ?? 21 98 40 00 21 18 40 00 E5 FF 40 04 18 00 BC 8F 11 00 47 28 ?? ?? 99 8F 10 00 02 24 0B 10 67 00 21 28 80 02 21 30 60 02 10 00 B0 AF 21 20 40 02 ?? ?? ?? ?? 21 38 40 00 18 00 BC 8F 21 20 00 02 ?? ?? 99 8F ?? ?? ?? ?? 20 01 A2 AF 3C 01 BF 8F 20 01 A2 8F 38 01 B4 8F 34 01 B3 8F 30 01 B2 8F 2C 01 B1 8F 28 01 B0 8F 08 00 E0 03 40 01 BD 27 }
	condition:
		$1
}

rule file_349_0_0 {
	meta:
		name = "_setjmp"
		size = 24
		refs = "0000 _gp_disp 000c __sigsetjmp"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F 08 00 20 03 21 28 00 00 }
	condition:
		$1
}

rule file_350_0_0 {
	meta:
		name = "__open_etc_hosts"
		size = 124
		refs = "0000 _gp_disp 0020 __GI_fopen 0010 $LC0 0038 $LC1 0044 $LC2"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D8 FF BD 27 ?? ?? 84 8F 20 00 B1 AF 1C 00 B0 AF ?? ?? 91 8F ?? ?? 90 8F 10 00 BC AF 24 00 BF AF ?? ?? 84 24 21 C8 00 02 ?? ?? ?? ?? ?? ?? 25 26 0A 00 40 14 10 00 BC 8F ?? ?? 84 8F 24 00 BF 8F ?? ?? 25 26 21 C8 00 02 20 00 B1 8F 1C 00 B0 8F ?? ?? 84 24 ?? ?? ?? ?? 28 00 BD 27 24 00 BF 8F 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_350_1_0 {
	meta:
		name = "__read_etc_hosts_r"
		size = 784
		refs = "0000 _gp_disp 009c __open_etc_hosts 00bc __GI___errno_location 0100 __GI_fgets 011c __GI_strchrnul 0150 __GI___ctype_b 01ac __GI_strcmp 01e8 __GI_strcasecmp 0214 __GI_inet_pton 0278 __GI_fclose"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 B0 FF BD 27 70 00 A3 8F 38 00 B4 AF 21 A0 80 00 64 00 A4 8F 10 00 BC AF FF FF 02 24 34 00 B3 AF 30 00 B2 AF 28 00 B0 AF 4C 00 BF AF 48 00 BE AF 44 00 B7 AF 40 00 B6 AF 3C 00 B5 AF 2C 00 B1 AF 00 00 62 AC 68 00 A2 8F 23 18 04 00 03 00 63 30 23 10 43 00 E0 FF 53 24 54 00 A5 AF 60 00 B0 8F 9B 00 60 06 22 00 12 24 21 B8 83 00 01 00 04 24 21 F0 C0 00 21 A8 E0 00 18 00 E4 10 20 00 F1 26 D4 FF 53 24 50 00 62 2A 92 00 40 14 4C 00 BF 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 21 A0 40 00 08 00 40 14 10 00 BC 8F 6C 00 B9 8F 00 00 20 AF ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 84 00 00 10 00 00 52 8C 28 00 F6 26 18 00 B1 AF 20 00 F6 AE 24 00 E0 AE 03 00 00 10 2C 00 F1 26 21 B0 00 00 18 00 A0 AF 70 00 A3 8F 01 00 02 24 01 00 12 24 00 00 62 AC ?? ?? 99 8F 21 20 20 02 21 28 60 02 ?? ?? ?? ?? 21 30 80 02 55 00 40 10 10 00 BC 8F ?? ?? 99 8F 21 20 20 02 ?? ?? ?? ?? 23 00 05 24 10 00 BC 8F 21 30 00 00 00 00 40 A0 21 10 20 02 00 00 44 80 05 00 80 50 80 10 06 00 00 00 44 80 09 00 80 14 ?? ?? 83 8F 80 10 06 00 21 10 E2 02 00 00 40 AC 02 00 C2 28 0D 00 40 10 01 00 02 24 E5 FF 00 10 ?? ?? 99 8F 40 20 04 00 00 00 65 8C 21 20 A4 00 00 00 84 94 20 00 84 30 40 00 80 10 21 28 60 00 00 00 40 A0 EC FF 00 10 01 00 42 24 4F 00 A2 12 02 00 02 24 0D 00 A2 16 01 00 07 24 ?? ?? 99 8F 54 00 A4 8F ?? ?? ?? ?? 00 00 E5 8E D0 FF 40 14 10 00 BC 8F 12 00 00 10 02 00 02 24 01 00 E7 24 2A 10 E6 00 CB FF 40 10 ?? ?? 99 8F 80 10 07 00 21 10 E2 02 00 00 45 8C ?? ?? 99 8F 54 00 A4 8F 1C 00 A6 AF ?? ?? ?? ?? 20 00 A7 AF 10 00 BC 8F 1C 00 A6 8F F1 FF 40 14 20 00 A7 8F 02 00 02 24 03 00 C2 13 ?? ?? 99 8F B9 FF 00 10 02 00 12 24 00 00 E5 8E 02 00 04 24 ?? ?? ?? ?? 21 30 C0 02 F9 FF 40 18 10 00 BC 8F 04 00 02 24 08 00 1E AE 0C 00 02 AE 18 00 A3 8F 04 00 E2 8E 6C 00 B9 8F 10 00 03 AE 08 00 E3 26 00 00 02 AE 04 00 03 AE 21 90 00 00 04 00 00 10 00 00 30 AF 01 00 02 24 1B 00 A2 52 4C 00 BF 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 80 02 16 00 00 10 4C 00 BF 8F 07 00 C4 28 0E 00 80 50 00 00 44 80 80 20 06 00 21 20 E4 02 00 00 82 AC 08 00 00 10 01 00 C6 24 40 20 04 00 21 20 E4 00 00 00 84 94 20 00 84 30 A0 FF 80 54 00 00 44 80 01 00 42 24 00 00 44 80 F7 FF 80 54 00 00 A7 8C 9A FF 00 10 00 00 00 00 4C 00 BF 8F 21 10 40 02 48 00 BE 8F 44 00 B7 8F 40 00 B6 8F 3C 00 B5 8F 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 E0 03 50 00 BD 27 }
	condition:
		$1
}

rule file_351_0_0 {
	meta:
		name = "__GI_lockf"
		size = 332
		refs = "0000 _gp_disp 0010 __GI_memset 007c __GI___errno_location 0090 __GI_fcntl 00b4 __GI_getpid"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 A8 FF BD 27 ?? ?? 99 8F 48 00 B1 AF 18 00 B1 27 10 00 BC AF 50 00 B3 AF 4C 00 B2 AF 44 00 B0 AF 21 98 C0 00 54 00 BF AF 21 90 80 00 21 80 A0 00 21 20 20 02 21 28 00 00 ?? ?? ?? ?? 24 00 06 24 01 00 02 24 1A 00 A2 A7 01 00 02 24 10 00 BC 8F 21 00 02 12 20 00 B3 AF 02 00 03 2A 05 00 60 10 02 00 13 24 1F 00 00 12 02 00 02 24 21 00 00 10 ?? ?? 99 8F 1C 00 13 52 18 00 A2 A7 03 00 02 24 1B 00 02 16 ?? ?? 99 8F 21 20 40 02 0E 00 05 24 ?? ?? ?? ?? 21 30 20 02 21 00 40 04 10 00 BC 8F 18 00 A2 87 03 00 53 14 ?? ?? 99 8F 1D 00 00 10 21 10 00 00 ?? ?? ?? ?? 28 00 B0 8F FB FF 02 12 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 0B 00 00 10 0D 00 03 24 18 00 B0 A7 0A 00 00 10 07 00 05 24 18 00 A2 A7 07 00 00 10 06 00 05 24 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 16 00 03 24 07 00 00 10 00 00 43 AC ?? ?? 99 8F 21 20 40 02 ?? ?? ?? ?? 21 30 20 02 03 00 00 10 54 00 BF 8F FF FF 02 24 54 00 BF 8F 50 00 B3 8F 4C 00 B2 8F 48 00 B1 8F 44 00 B0 8F 08 00 E0 03 58 00 BD 27 }
	condition:
		$1
}

rule file_352_0_0 {
	meta:
		name = "memcmp_bytes"
		size = 44
	strings:
		$1 = { 00 00 A4 AF 04 00 A5 AF 21 20 A0 03 04 00 A3 27 00 00 85 90 00 00 62 90 01 00 84 24 FC FF A2 10 01 00 63 24 08 00 E0 03 23 10 A2 00 }
	condition:
		$1
}

rule file_352_1_0 {
	meta:
		name = "__GI_memcmp"
		size = 680
		refs = "0000 _gp_disp 0250 memcmp_bytes"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 C2 2C 10 00 BC AF 1C 00 BF AF 21 40 C0 00 21 38 80 00 9A 00 40 14 21 18 A0 00 03 00 62 30 09 00 40 10 21 C0 60 00 00 00 E4 90 00 00 62 90 01 00 E7 24 23 10 82 00 94 00 40 14 01 00 63 24 F6 FF 00 10 FF FF 08 25 03 00 E2 30 21 78 E0 00 32 00 40 14 82 30 08 00 03 00 C2 30 01 00 04 24 13 00 44 50 00 00 E4 8C 0E 00 40 10 03 00 04 24 07 00 44 50 00 00 E4 8C 00 00 E9 8C 00 00 65 8C F8 FF E7 24 F8 FF 63 24 16 00 00 10 02 00 C6 24 00 00 62 8C FC FF E7 24 FC FF 63 24 0E 00 00 10 01 00 C6 24 00 00 E9 8C 08 00 00 10 00 00 65 8C 00 00 62 8C 04 00 E7 24 04 00 63 24 FF FF C6 24 00 00 E9 8C 13 00 82 14 00 00 65 8C 04 00 E4 8C 07 00 25 15 04 00 62 8C 08 00 E9 8C 0D 00 82 14 08 00 65 8C 0C 00 E4 8C 03 00 25 11 0C 00 62 8C 51 00 00 10 21 20 20 01 FC FF C6 24 03 00 C0 10 10 00 E7 24 EE FF 00 10 10 00 63 24 4E 00 82 50 21 10 00 00 48 00 00 10 21 28 40 00 C0 38 02 00 20 00 0A 24 FC FF 02 24 03 00 C4 30 01 00 05 24 23 50 47 01 16 00 85 10 24 10 E2 01 10 00 80 50 00 00 4B 8C 03 00 05 24 08 00 85 50 00 00 65 8C 00 00 4C 8C 04 00 49 8C 00 00 6E 8C FC FF 42 24 F8 FF 63 24 22 00 00 10 02 00 C6 24 00 00 4D 8C 04 00 4C 8C FC FF 63 24 17 00 00 10 01 00 C6 24 04 00 4D 8C 00 00 6E 8C 0D 00 00 10 04 00 42 24 00 00 49 8C 04 00 4B 8C 00 00 65 8C 08 00 42 24 04 00 63 24 FF FF C6 24 04 20 4B 01 06 48 E9 00 25 20 89 00 00 00 4D 8C 1F 00 85 14 00 00 6E 8C 04 20 4D 01 06 58 EB 00 25 20 8B 00 04 00 4C 8C 0D 00 8E 14 04 00 65 8C 04 20 4C 01 06 68 ED 00 25 20 8D 00 08 00 49 8C 13 00 85 14 08 00 6E 8C 04 20 49 01 06 60 EC 00 25 20 8C 00 0C 00 4B 8C 03 00 8E 10 0C 00 65 8C 0B 00 00 10 21 28 C0 01 FC FF C6 24 04 00 C0 50 04 50 4B 01 10 00 42 24 E1 FF 00 10 10 00 63 24 06 38 E9 00 25 20 47 01 05 00 85 50 21 10 00 00 ?? ?? 99 8F ?? ?? 39 27 ?? ?? ?? ?? 00 00 00 00 11 00 40 14 1C 00 BF 8F FC FF 03 24 24 18 03 01 21 38 6F 00 03 00 08 31 07 00 00 10 21 18 78 00 00 00 62 90 01 00 E7 24 23 10 82 00 05 00 40 14 01 00 63 24 FF FF 08 25 F9 FF 00 55 00 00 E4 90 21 10 00 00 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_353_0_0 {
	meta:
		name = "__GI_erand48_r"
		size = 180
		refs = "0000 _gp_disp 000c __drand48_iterate 0050 __subdf3 0078 $LC0"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F D8 FF BD 27 10 00 BC AF 20 00 B1 AF 1C 00 B0 AF 24 00 BF AF 21 80 80 00 ?? ?? ?? ?? 21 88 C0 00 1A 00 40 04 10 00 BC 8F 21 10 00 00 FF 03 03 24 C4 FF 02 7C 04 F5 62 7C 04 00 04 96 02 00 03 96 ?? ?? 99 8F 00 21 04 00 02 2B 03 00 25 20 A4 00 00 00 05 96 04 98 82 7C 00 25 03 00 00 29 05 00 25 38 A4 00 21 28 40 00 ?? ?? 82 8F 21 20 E0 00 ?? ?? 46 8C ?? ?? ?? ?? ?? ?? 47 8C 00 00 22 AE 04 00 23 AE 02 00 00 10 21 10 00 00 FF FF 02 24 24 00 BF 8F 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_354_0_0 {
	meta:
		name = "__GI_strrchr"
		size = 152
		refs = "0000 _gp_disp 002c __GI_strchr"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D8 FF BD 27 20 00 B2 AF 10 00 BC AF FF 00 B2 30 1C 00 B1 AF 24 00 BF AF 18 00 B0 AF 04 00 40 12 ?? ?? 91 8F 21 18 80 00 09 00 00 10 21 80 00 00 24 00 BF 8F 20 00 B2 8F 18 00 B0 8F 21 C8 20 02 1C 00 B1 8F 21 28 00 00 ?? ?? ?? ?? 28 00 BD 27 21 20 60 00 21 C8 20 02 ?? ?? ?? ?? 21 28 40 02 03 00 40 10 01 00 43 24 F9 FF 00 10 21 80 40 00 24 00 BF 8F 21 10 00 02 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_355_0_0 {
	meta:
		name = "_ppfs_parsespec"
		size = 1320
		refs = "0000 _gp_disp 00b0 __GI___ctype_b 04b8 __GI_memcpy"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 98 FF BD 27 54 00 B1 AF 10 00 BC AF 64 00 BF AF 60 00 B4 AF 5C 00 B3 AF 58 00 B2 AF 50 00 B0 AF 21 88 80 00 18 00 92 8C 10 00 84 8C 08 00 02 24 38 00 A0 AF 80 00 84 30 3C 00 A0 AF 44 00 A2 AF 48 00 A2 AF 17 00 80 10 00 00 23 8E FF 3F 08 3C 21 10 00 00 FF FF 08 35 18 00 A9 27 20 00 07 24 21 30 48 00 80 30 06 00 21 30 66 00 00 00 C5 80 21 50 22 01 00 00 45 A1 00 00 C6 8C 03 00 A6 10 00 00 00 00 1D 01 00 10 FF FF 02 24 03 00 A0 10 01 00 42 24 F3 FF 47 14 21 30 48 00 37 00 A0 A3 19 00 A3 27 ?? ?? 8D 8F ?? ?? 98 8F 21 28 00 00 21 38 00 00 2A 00 08 24 18 00 A9 27 0A 00 0E 24 25 00 0A 24 2E 00 0F 24 24 00 0B 24 30 00 19 24 00 00 6C 80 06 00 88 15 21 80 60 00 23 10 05 00 80 10 02 00 21 10 22 01 2C 00 40 AC 01 00 70 24 21 10 00 00 00 00 06 82 00 00 B4 8D 40 98 06 00 21 98 93 02 00 00 73 96 08 00 73 32 07 00 60 12 FF 0F 53 28 F7 FF 60 12 01 00 10 26 02 98 4E 70 D0 FF C6 24 F3 FF 00 10 21 10 66 02 FF FF 73 80 29 00 6A 56 00 00 66 80 09 00 CB 14 00 00 00 00 07 00 40 18 00 00 00 00 CE FF 40 12 01 00 03 26 2A 30 42 02 40 00 A2 AF 07 00 00 10 0B 90 46 00 C8 FF 40 1E 2B 30 70 00 03 00 C0 10 21 90 00 00 19 00 99 55 00 00 66 80 21 80 60 00 01 00 06 24 ?? ?? 02 27 00 00 13 82 00 00 4C 80 04 00 6C 16 01 00 43 24 01 00 10 26 F8 FF 00 10 25 20 86 00 01 00 4C 80 40 30 06 00 F6 FF 80 15 21 10 60 00 0A 00 82 30 43 10 02 00 27 10 02 00 24 20 82 00 FF FF 02 82 03 00 4A 10 21 10 00 00 C0 FF 00 10 21 18 00 02 00 00 66 80 10 00 C8 14 00 00 00 00 0B 00 40 52 01 00 63 24 00 00 06 82 A5 FF CB 14 01 00 03 26 A3 FF 40 18 23 30 05 00 80 30 06 00 21 30 26 01 20 00 C2 AC 03 00 00 10 21 80 60 00 BA 00 03 16 FF FF 02 24 00 80 02 3C 09 00 A0 14 ?? ?? 83 8F 00 00 03 82 04 00 6F 14 21 38 40 00 01 00 10 26 E5 FF 00 10 FF FF 05 24 FF FF 02 24 ?? ?? 83 8F ?? ?? 63 24 21 28 60 00 00 00 08 82 00 00 66 80 03 00 06 55 01 00 63 24 04 00 00 10 01 00 10 26 00 00 66 80 FA FF C0 54 00 00 08 82 23 28 65 00 02 00 A5 28 08 00 A0 50 09 00 66 80 00 00 06 82 00 00 65 80 04 00 C5 54 09 00 66 80 09 00 63 24 01 00 10 26 09 00 66 80 00 00 05 82 78 FF A0 10 00 32 06 00 ?? ?? 83 8F ?? ?? 63 24 21 40 60 00 00 00 69 80 21 00 25 55 01 00 63 24 23 18 68 00 12 00 65 28 05 00 A0 14 ?? ?? 85 8F 00 04 C9 30 FE FF 65 24 0B 18 A9 00 ?? ?? 85 8F 20 00 23 AE ?? ?? A5 24 01 00 A5 24 00 00 A9 80 2A 48 23 01 FD FF 20 55 01 00 A5 24 ?? ?? 83 8F ?? ?? 89 8F ?? ?? 63 24 23 28 A3 00 ?? ?? 83 8F 40 28 05 00 ?? ?? 29 25 ?? ?? 63 24 21 18 A3 00 00 00 63 84 21 28 A9 00 00 00 A5 84 25 18 C3 00 24 18 65 00 4C 00 A3 AF 04 00 00 10 21 18 00 01 00 00 69 80 DB FF 20 15 00 00 00 00 00 00 05 82 04 00 22 AE 08 00 27 AE 0C 00 25 AE 04 00 87 30 30 00 02 24 20 00 05 24 0A 10 A7 00 14 00 22 AE FB FF 02 24 24 20 82 00 00 0F C6 30 25 20 C4 00 01 00 02 24 10 00 24 AE 1C 00 22 AE 00 00 63 80 5A 00 60 50 FF FF 02 24 44 00 40 1A ?? ?? 89 8F ?? ?? 85 8F ?? ?? 8B 8F ?? ?? 29 25 ?? ?? A5 24 ?? ?? 6B 25 21 10 00 00 18 00 A7 27 08 00 08 24 21 70 20 01 21 50 A0 00 21 78 A0 00 21 C0 60 01 03 00 0D 24 80 20 02 00 21 18 E4 00 20 00 63 8C 21 30 22 02 24 00 C3 A0 FF 00 63 30 2A 30 43 02 05 00 C0 50 21 20 E4 00 0A 00 66 28 21 FF C0 10 21 90 60 00 21 20 E4 00 FF FF 63 24 2C 00 84 8C 80 60 03 00 21 18 2C 02 1F 00 88 10 28 00 66 8C 1C 00 C8 50 21 60 2C 02 19 00 C4 10 21 18 20 01 FE FF 63 24 00 00 79 84 03 00 26 13 2B C8 A3 00 FC FF 20 57 FE FF 63 24 23 18 6A 00 43 18 03 00 21 18 6B 00 00 00 66 90 21 18 C0 01 FE FF 63 24 00 00 79 84 03 00 24 13 2B C8 43 01 FC FF 20 57 FE FF 63 24 23 18 6F 00 43 18 03 00 21 18 03 03 00 00 63 90 2A 18 66 00 04 00 60 54 01 00 42 24 21 60 2C 02 28 00 84 AD 01 00 42 24 CE FF 4D 14 80 20 02 00 08 00 00 10 10 00 22 8E ?? ?? 99 8F 26 00 22 A2 28 00 24 26 4C 00 A5 27 ?? ?? ?? ?? 04 00 06 24 10 00 22 8E 80 00 42 30 03 00 40 14 18 00 32 AE 06 00 00 10 01 00 10 26 18 00 A2 27 23 80 02 02 00 00 22 8E 80 80 10 00 21 80 50 00 1C 00 22 8E 00 00 30 AE 02 00 42 24 64 00 BF 8F 60 00 B4 8F 5C 00 B3 8F 58 00 B2 8F 54 00 B1 8F 50 00 B0 8F 08 00 E0 03 68 00 BD 27 }
	condition:
		$1
}

rule file_356_0_0 {
	meta:
		name = "fdatasync"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 38 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_357_0_0 {
	meta:
		name = "__GI_isalnum"
		size = 40
		refs = "0000 _gp_disp 000c __GI___ctype_b"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F 40 20 04 00 00 00 42 8C 21 10 44 00 00 00 42 94 08 00 E0 03 00 08 42 30 }
	condition:
		$1
}

rule file_358_0_0 {
	meta:
		name = "msgctl"
		size = 76
		refs = "0000 _gp_disp 000c __syscall_ipc"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F D8 FF BD 27 21 18 80 00 00 01 A2 34 0E 00 04 24 24 00 BF AF 18 00 BC AF 10 00 A6 AF 14 00 A0 AF 21 28 60 00 21 30 40 00 ?? ?? ?? ?? 21 38 00 00 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_359_0_0 {
	meta:
		name = "__GI_isxdigit"
		size = 40
		refs = "0000 _gp_disp 000c __GI___ctype_b"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F 40 20 04 00 00 00 42 8C 21 10 44 00 00 00 42 94 08 00 E0 03 10 00 42 30 }
	condition:
		$1
}

rule file_360_0_0 {
	meta:
		name = "__init_scan_cookie"
		size = 92
		refs = "0000 _gp_disp"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 08 00 85 AC 0C 00 80 AC 19 00 80 A0 00 00 A3 94 02 00 63 30 02 00 60 10 21 10 00 00 28 00 A2 8C 14 00 82 AC ?? ?? 82 8F 1A 00 80 A0 1B 00 80 A0 ?? ?? 42 24 30 00 82 AC 3C 00 82 AC 01 00 02 24 34 00 82 AC 2E 00 02 24 08 00 E0 03 38 00 82 AC }
	condition:
		$1
}

rule file_360_1_0 {
	meta:
		name = "__scan_getc"
		size = 136
	strings:
		$1 = { 10 00 82 8C D8 FF BD 27 20 00 B1 AF FF FF 42 24 FF FF 11 24 1C 00 B0 AF 24 00 BF AF 21 80 80 00 00 00 91 AC 09 00 40 04 10 00 82 AC 19 00 82 80 0B 00 40 54 19 00 80 A0 2C 00 99 8C 09 F8 20 03 00 00 00 00 06 00 51 54 04 00 02 AE 19 00 02 92 02 00 42 34 19 00 02 A2 06 00 00 10 FF FF 02 24 0C 00 02 8E 01 00 42 24 0C 00 02 AE 04 00 02 8E 00 00 02 AE 24 00 BF 8F 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_360_2_0 {
	meta:
		name = "__scan_ungetc"
		size = 76
	strings:
		$1 = { 10 00 82 8C 02 00 03 24 01 00 42 24 10 00 82 AC 19 00 82 80 05 00 43 14 00 00 00 00 04 00 82 8C 19 00 80 A0 08 00 E0 03 00 00 82 AC 05 00 40 14 01 00 02 24 19 00 82 A0 0C 00 82 8C FF FF 42 24 0C 00 82 AC 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_361_0_0 {
	meta:
		name = "posix_fadvise"
		size = 88
	strings:
		$1 = { F8 FF BD 27 21 10 A0 00 00 00 B0 AF 21 80 C0 00 04 00 B1 AF 21 30 40 00 21 88 E0 00 21 28 00 00 C3 3F 02 00 C3 17 10 00 E0 FF BD 27 10 00 B0 AF 14 00 A2 AF 18 00 B1 AF 9E 10 02 24 0C 00 00 00 20 00 BD 27 04 00 B1 8F 00 00 B0 8F 0A 10 07 00 08 00 E0 03 08 00 BD 27 }
	condition:
		$1
}

rule file_362_0_0 {
	meta:
		name = "__GI_xdr_reference"
		size = 264
		refs = "0000 _gp_disp 005c malloc 0080 stderr 0088 __GI_fputs 0084 $LC0 00a0 __GI_memset 00d4 free"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 C8 FF BD 27 30 00 B3 AF 2C 00 B2 AF 28 00 B1 AF 10 00 BC AF 34 00 BF AF 24 00 B0 AF 00 00 B0 8C 21 90 80 00 21 88 A0 00 1E 00 00 16 21 98 E0 00 00 00 83 8C 01 00 02 24 05 00 62 10 02 00 04 24 28 00 64 10 34 00 BF 8F 17 00 00 10 21 20 40 02 ?? ?? 99 8F 21 20 C0 00 ?? ?? ?? ?? 18 00 A6 AF 21 80 40 00 10 00 BC 8F 00 00 22 AE 09 00 40 14 18 00 A6 8F ?? ?? 82 8F ?? ?? 84 8F ?? ?? 99 8F 00 00 45 8C ?? ?? ?? ?? ?? ?? 84 24 14 00 00 10 21 10 00 00 ?? ?? 99 8F 21 20 40 00 ?? ?? ?? ?? 21 28 00 00 21 20 40 02 21 28 00 02 21 C8 60 02 09 F8 20 03 FF FF 06 24 00 00 43 8E 02 00 04 24 07 00 64 14 10 00 BC 8F ?? ?? 99 8F 18 00 A2 AF ?? ?? ?? ?? 21 20 00 02 18 00 A2 8F 00 00 20 AE 34 00 BF 8F 30 00 B3 8F 2C 00 B2 8F 28 00 B1 8F 24 00 B0 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_362_1_0 {
	meta:
		name = "xdr_pointer"
		size = 156
		refs = "0000 _gp_disp 0024 __GI_xdr_bool 0070 __GI_xdr_reference"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 C8 FF BD 27 10 00 BC AF 30 00 B1 AF 2C 00 B0 AF 34 00 BF AF 00 00 A2 8C ?? ?? 99 8F 20 00 A6 AF 2B 10 02 00 24 00 A7 AF 21 80 A0 00 18 00 A2 AF 18 00 A5 27 ?? ?? ?? ?? 21 88 80 00 10 00 BC 8F 21 18 00 00 20 00 A6 8F 0B 00 40 10 24 00 A7 8F 18 00 A2 8F 03 00 40 14 01 00 03 24 06 00 00 10 00 00 00 AE ?? ?? 99 8F 21 20 20 02 ?? ?? ?? ?? 21 28 00 02 21 18 40 00 34 00 BF 8F 30 00 B1 8F 2C 00 B0 8F 21 10 60 00 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_363_0_0 {
	meta:
		name = "updwtmp"
		size = 200
		refs = "0000 _gp_disp 000c __GI_open 0044 __GI_lockf 0064 __GI_write 00a0 __GI_close"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F D8 FF BD 27 21 30 00 00 10 00 BC AF 20 00 B2 AF 18 00 B0 AF 24 00 BF AF 1C 00 B1 AF 21 90 A0 00 ?? ?? ?? ?? 09 00 05 24 21 80 40 00 1C 00 40 04 10 00 BC 8F ?? ?? 91 8F 21 20 40 00 01 00 05 24 21 C8 20 02 ?? ?? ?? ?? 21 30 00 00 14 00 40 14 10 00 BC 8F ?? ?? 99 8F 21 20 00 02 21 28 40 02 ?? ?? ?? ?? 80 01 06 24 21 20 00 02 21 C8 20 02 21 28 00 00 ?? ?? ?? ?? 21 30 00 00 10 00 BC 8F 24 00 BF 8F 20 00 B2 8F 1C 00 B1 8F 21 20 00 02 ?? ?? 99 8F 18 00 B0 8F ?? ?? ?? ?? 28 00 BD 27 24 00 BF 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_364_0_0 {
	meta:
		name = "__GI_mbsnrtowcs"
		size = 200
		refs = "0000 _gp_disp 0080 __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D8 FF BD 27 38 00 A3 8F 10 00 BC AF 24 00 BF AF 03 00 60 14 00 00 00 00 ?? ?? 83 8F ?? ?? 63 24 05 00 80 50 21 40 00 00 05 00 83 14 01 00 08 24 02 00 00 10 21 40 00 00 FF FF 07 24 18 00 A4 27 2B 10 C7 00 00 00 A3 8C 0B 38 C2 00 21 10 E0 00 80 30 08 00 13 00 40 50 18 00 A6 27 00 00 68 90 0E 00 00 11 00 00 88 AC 80 00 08 29 08 00 00 55 01 00 63 24 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 58 00 03 24 00 00 43 AC 09 00 00 10 FF FF 02 24 21 20 86 00 EF FF 00 10 FF FF 42 24 21 18 00 00 18 00 A6 27 01 00 86 54 00 00 A3 AC 23 10 E2 00 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_365_0_0 {
	meta:
		name = "mrand48_r"
		size = 28
		refs = "0000 _gp_disp 000c __GI_jrand48_r"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F 21 30 A0 00 ?? ?? ?? ?? 21 28 80 00 }
	condition:
		$1
}

rule file_370_0_0 {
	meta:
		name = "__GI_lrand48_r"
		size = 28
		refs = "0000 _gp_disp 000c __GI_nrand48_r"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F 21 30 A0 00 ?? ?? ?? ?? 21 28 80 00 }
	condition:
		$1
}

rule file_389_0_0 {
	meta:
		name = "drand48_r"
		size = 28
		refs = "0000 _gp_disp 000c __GI_erand48_r"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F 21 30 A0 00 ?? ?? ?? ?? 21 28 80 00 }
	condition:
		$1
}

rule file_366_0_0 {
	meta:
		name = "__GI_getenv"
		size = 192
		refs = "0000 _gp_disp 000c __environ 003c __GI_strlen 0054 __GI_memcmp"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F C8 FF BD 27 10 00 BC AF 34 00 BF AF 30 00 B5 AF 2C 00 B4 AF 28 00 B3 AF 24 00 B2 AF 20 00 B1 AF 1C 00 B0 AF 00 00 51 8C 17 00 20 12 ?? ?? 99 8F 21 98 80 00 ?? ?? ?? ?? 3D 00 15 24 10 00 BC 8F 21 90 40 00 ?? ?? 94 8F 00 00 30 8E 0E 00 00 12 21 20 60 02 21 28 00 02 21 C8 80 02 ?? ?? ?? ?? 21 30 40 02 F8 FF 40 14 04 00 31 26 21 10 12 02 00 00 42 80 F5 FF 55 54 00 00 30 8E 01 00 52 26 02 00 00 10 21 10 12 02 21 10 00 00 34 00 BF 8F 30 00 B5 8F 2C 00 B4 8F 28 00 B3 8F 24 00 B2 8F 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_367_0_0 {
	meta:
		name = "cfsetspeed"
		size = 224
		refs = "0000 _gp_disp 0050 __GI_cfsetispeed 0094 __GI_cfsetospeed 00b0 __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D8 FF BD 27 1C 00 B1 AF 21 88 A0 00 ?? ?? 85 8F 18 00 B0 AF 10 00 BC AF 21 80 80 00 24 00 BF AF 20 00 B2 AF 21 10 00 00 ?? ?? A5 24 20 00 04 24 C0 18 02 00 21 18 A3 00 04 00 72 8C 09 00 32 56 00 00 63 8C ?? ?? 99 8F 21 20 00 02 ?? ?? ?? ?? 21 28 20 02 10 00 BC 8F 21 20 00 02 0A 00 00 10 21 28 20 02 0D 00 23 56 01 00 42 24 ?? ?? 99 8F 21 20 00 02 ?? ?? ?? ?? 21 28 40 02 10 00 BC 8F 21 20 00 02 21 28 40 02 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 09 00 00 10 21 10 00 00 E5 FF 44 14 C0 18 02 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 16 00 03 24 00 00 43 AC FF FF 02 24 24 00 BF 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_369_0_0 {
	meta:
		name = "__GI_memccpy"
		size = 68
	strings:
		$1 = { FF 00 C6 30 0D 00 E0 10 FF FF E8 24 00 00 A3 80 01 00 82 24 01 00 A9 24 00 00 83 A0 FF 00 63 30 04 00 66 10 21 38 00 01 21 28 20 01 F5 FF 00 10 21 20 40 00 08 00 E0 03 00 00 00 00 08 00 E0 03 21 10 00 00 }
	condition:
		$1
}

rule file_372_0_0 {
	meta:
		name = "__socketcall"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 06 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_373_0_0 {
	meta:
		name = "putpwent"
		size = 148
		refs = "0000 _gp_disp 0028 __GI___errno_location 005c __GI_fprintf 0058 $LC0"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 C8 FF BD 27 28 00 BC AF 34 00 BF AF 03 00 80 10 21 10 80 00 08 00 A0 14 21 20 A0 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 16 00 03 24 00 00 43 AC 12 00 00 10 FF FF 02 24 08 00 43 8C 00 00 46 8C 04 00 47 8C 10 00 A3 AF 0C 00 43 8C ?? ?? 85 8F ?? ?? 99 8F 14 00 A3 AF 10 00 43 8C ?? ?? A5 24 18 00 A3 AF 14 00 43 8C 1C 00 A3 AF 18 00 42 8C ?? ?? ?? ?? 20 00 A2 AF C3 17 02 00 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_374_0_0 {
	meta:
		name = "__GI_rewind"
		size = 172
		refs = "0000 _gp_disp 0030 _pthread_cleanup_push_defer 0034 __pthread_mutex_unlock 004c __pthread_mutex_lock 0060 __GI_fseek 0084 _pthread_cleanup_pop_restore"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 C8 FF BD 27 28 00 B0 AF 10 00 BC AF 34 00 BF AF 30 00 B2 AF 2C 00 B1 AF 34 00 91 8C 0C 00 20 16 21 80 80 00 ?? ?? 99 8F ?? ?? 85 8F 38 00 92 24 21 30 40 02 ?? ?? ?? ?? 18 00 A4 27 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 40 02 10 00 BC 8F 00 00 02 96 ?? ?? 99 8F 21 20 00 02 F7 FF 42 30 00 00 02 A6 21 28 00 00 ?? ?? ?? ?? 21 30 00 00 05 00 20 16 10 00 BC 8F ?? ?? 99 8F 18 00 A4 27 ?? ?? ?? ?? 01 00 05 24 34 00 BF 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_375_0_0 {
	meta:
		name = "realpath"
		size = 808
		refs = "0000 _gp_disp 0044 __GI___errno_location 0060 __GI_strlen 0098 __GI_strcpy 00c8 __GI_getcwd 01c0 __GI_readlink 02a8 __GI_memmove"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 B8 EF BD 27 10 00 BC AF 2C 10 B3 AF 44 10 BF AF 40 10 BE AF 3C 10 B7 AF 38 10 B6 AF 34 10 B5 AF 30 10 B4 AF 28 10 B2 AF 24 10 B1 AF 20 10 B0 AF 06 00 80 14 21 98 80 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 4F 00 00 10 16 00 03 24 00 00 82 80 06 00 40 14 ?? ?? 92 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 47 00 00 10 02 00 03 24 21 C8 40 02 ?? ?? ?? ?? 21 80 A0 00 FE 0F 43 2C 26 00 60 10 10 00 BC 8F FF 0F 07 24 23 38 E2 00 ?? ?? 99 8F 18 00 B1 27 21 90 27 02 21 20 40 02 ?? ?? ?? ?? 21 28 60 02 00 00 42 82 FE 0F 03 26 2F 00 14 24 10 00 BC 8F 14 00 54 10 18 10 A3 AF ?? ?? 99 8F 21 20 00 02 ?? ?? ?? ?? FF 0F 05 24 46 00 40 10 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 00 02 21 A8 02 02 FF FF A2 82 03 00 54 10 10 00 BC 8F 00 00 B4 A2 01 00 B5 26 21 20 00 00 2F 00 14 24 0D 00 00 10 01 00 16 26 01 00 15 26 00 00 02 A2 F9 FF 00 10 01 00 52 26 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 17 00 00 10 4E 00 03 24 30 00 A0 14 00 00 00 00 01 00 52 26 00 00 42 82 63 00 40 50 01 00 02 26 FC FF 54 50 01 00 52 26 2E 00 05 24 F6 FF 45 50 01 00 45 82 00 00 42 82 35 00 40 14 00 00 00 00 01 00 97 24 21 00 84 28 07 00 80 14 ?? ?? 99 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 5A 00 03 24 18 00 00 10 00 00 43 AC ?? ?? ?? ?? 21 20 40 02 10 00 BC 8F 00 00 A0 A2 ?? ?? 99 8F ?? ?? ?? ?? 1C 10 A2 AF 10 00 BC 8F FF 0F 06 24 21 20 00 02 ?? ?? 99 8F 21 28 20 02 21 98 40 00 ?? ?? ?? ?? 00 00 5E 8C 21 30 40 00 10 00 BC 8F 20 00 41 04 1C 10 AA 8F 00 00 64 8E 16 00 02 24 35 00 82 50 2F 00 02 24 40 00 00 10 21 10 00 00 D1 FF B4 50 01 00 52 26 D8 FF A2 54 00 00 42 82 02 00 42 82 03 00 40 10 00 00 00 00 D3 FF 54 54 00 00 42 82 C8 FF B6 12 02 00 52 26 FF FF B5 26 FF FF A2 82 FE FF 54 54 FF FF B5 26 C3 FF 00 10 00 00 42 82 CB FF 54 10 18 10 A3 8F 2B 28 75 00 B5 FF A0 14 01 00 52 26 00 00 A2 A2 C2 FF 00 10 01 00 B5 26 21 10 4A 00 FE 0F 42 2C 04 00 40 54 18 00 A2 83 4E 00 02 24 DF FF 00 10 00 00 62 AE 07 00 54 50 21 A8 00 02 FF FF B5 26 00 00 A2 82 FE FF 54 54 FF FF B5 26 02 00 00 10 FF 0F 07 24 FF 0F 07 24 23 38 EA 00 23 38 E6 00 ?? ?? 99 8F 21 90 27 02 21 20 40 02 ?? ?? ?? ?? 21 28 20 02 10 00 BC 8F 2F 00 02 24 00 00 7E AE 21 20 E0 02 00 00 A2 A2 9C FF 00 10 01 00 B5 26 06 00 A2 52 00 00 A0 A2 FF FF A2 82 2F 00 42 38 01 00 42 2C 23 A8 A2 02 00 00 A0 A2 21 10 00 02 44 10 BF 8F 40 10 BE 8F 3C 10 B7 8F 38 10 B6 8F 34 10 B5 8F 30 10 B4 8F 2C 10 B3 8F 28 10 B2 8F 24 10 B1 8F 20 10 B0 8F 08 00 E0 03 48 10 BD 27 }
	condition:
		$1
}

rule file_376_0_0 {
	meta:
		name = "__GI_lockf64"
		size = 376
		refs = "0000 _gp_disp 003c __GI___errno_location 0050 __GI_memset 00b8 __GI_fcntl64 00dc __GI_getpid"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 B0 FF BD 27 C3 17 06 00 10 00 BC AF 48 00 B4 AF 44 00 B3 AF 4C 00 BF AF 40 00 B2 AF 3C 00 B1 AF 38 00 B0 AF 21 98 C0 00 06 00 E2 10 21 A0 E0 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 3A 00 00 10 4F 00 03 24 ?? ?? 99 8F 18 00 B1 27 21 90 80 00 21 80 A0 00 21 20 20 02 21 28 00 00 ?? ?? ?? ?? 20 00 06 24 01 00 02 24 1A 00 A2 A7 01 00 02 24 10 00 BC 8F 28 00 B3 AF 21 00 02 12 2C 00 B4 AF 02 00 03 2A 05 00 60 10 02 00 13 24 1F 00 00 12 02 00 02 24 21 00 00 10 ?? ?? 99 8F 1C 00 13 52 18 00 A2 A7 03 00 02 24 1B 00 02 16 ?? ?? 99 8F 21 20 40 02 21 00 05 24 ?? ?? ?? ?? 21 30 20 02 21 00 40 04 10 00 BC 8F 18 00 A2 87 03 00 53 14 ?? ?? 99 8F 1D 00 00 10 21 10 00 00 ?? ?? ?? ?? 30 00 B0 8F FB FF 02 12 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 0B 00 00 10 0D 00 03 24 18 00 B0 A7 0A 00 00 10 07 00 05 24 18 00 A2 A7 07 00 00 10 22 00 05 24 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 16 00 03 24 07 00 00 10 00 00 43 AC ?? ?? 99 8F 21 20 40 02 ?? ?? ?? ?? 21 30 20 02 03 00 00 10 4C 00 BF 8F FF FF 02 24 4C 00 BF 8F 48 00 B4 8F 44 00 B3 8F 40 00 B2 8F 3C 00 B1 8F 38 00 B0 8F 08 00 E0 03 50 00 BD 27 }
	condition:
		$1
}

rule file_377_0_0 {
	meta:
		name = "sysinfo"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 14 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_378_0_0 {
	meta:
		name = "daemon"
		size = 284
		refs = "0000 _gp_disp 000c fork 0044 __GI_setsid 0048 __GI__exit 0070 __GI_chdir 0074 $LC0 0090 __GI_open 008c $LC1 00b4 __GI_dup2 00f4 __GI_close"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F D8 FF BD 27 10 00 BC AF 20 00 B2 AF 1C 00 B1 AF 18 00 B0 AF 24 00 BF AF 21 88 80 00 21 90 A0 00 ?? ?? ?? ?? FF FF 10 24 0A 00 50 10 10 00 BC 8F 04 00 40 10 ?? ?? 99 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 00 00 ?? ?? ?? ?? 00 00 00 00 03 00 50 14 10 00 BC 8F 27 00 00 10 FF FF 02 24 05 00 20 16 ?? ?? 99 8F ?? ?? 84 8F ?? ?? ?? ?? ?? ?? 84 24 10 00 BC 8F 1F 00 40 16 21 10 00 00 ?? ?? 84 8F ?? ?? 99 8F 02 00 05 24 ?? ?? 84 24 ?? ?? ?? ?? 21 30 00 00 21 80 40 00 FF FF 02 24 14 00 02 12 10 00 BC 8F ?? ?? 91 8F 21 20 00 02 21 C8 20 02 ?? ?? ?? ?? 21 28 00 00 21 20 00 02 21 C8 20 02 ?? ?? ?? ?? 01 00 05 24 21 20 00 02 21 C8 20 02 ?? ?? ?? ?? 02 00 05 24 03 00 02 2A 04 00 40 14 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 00 02 21 10 00 00 24 00 BF 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_379_0_0 {
	meta:
		name = "clone"
		size = 108
		refs = "0000 _gp_disp 0044 __thread_start 0060 __syscall_error"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 10 00 80 10 16 00 02 24 0E 00 A0 10 00 00 00 00 E0 FF A5 24 00 00 A4 AC 04 00 A7 AC 21 20 C0 00 18 10 02 24 0C 00 00 00 06 00 E0 14 00 00 00 00 ?? ?? 40 10 00 00 00 00 08 00 E0 03 20 00 BD 27 00 00 00 00 20 00 BD 27 21 20 40 00 ?? ?? 99 8F 08 00 20 03 00 00 00 00 }
	condition:
		$1
}

rule file_379_1_0 {
	meta:
		name = "__thread_start"
		size = 40
		refs = "0018 __GI__exit"
	strings:
		$1 = { 10 00 BC AF 00 00 B9 8F 09 F8 20 03 04 00 A4 8F 10 00 BC 8F 21 20 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F }
	condition:
		$1
}

rule file_380_0_0 {
	meta:
		name = "_test_and_set"
		size = 40
	strings:
		$1 = { 0F 00 00 00 00 00 82 C0 05 00 45 10 21 18 A0 00 00 00 83 E0 FB FF 60 10 00 00 00 00 0F 00 00 00 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_381_0_0 {
	meta:
		name = "bcopy"
		size = 32
		refs = "0000 _gp_disp 000c __GI_memmove"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F 21 10 80 00 21 20 A0 00 ?? ?? ?? ?? 21 28 40 00 }
	condition:
		$1
}

rule file_382_0_0 {
	meta:
		name = "getsockopt"
		size = 100
		refs = "0000 _gp_disp 003c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 30 00 A2 8F E0 FF BD 27 10 00 A2 AF 4D 10 02 24 0C 00 00 00 20 00 BD 27 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_383_0_0 {
	meta:
		name = "__GI_setrlimit"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF EB 0F 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_384_0_0 {
	meta:
		name = "getwchar_unlocked"
		size = 28
		refs = "0000 _gp_disp 000c stdin 0010 __GI_fgetwc_unlocked"
		altNames = "getwchar"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 44 8C }
	condition:
		$1
}

rule file_75_3_3 {
	meta:
		name = "_ZSt10unexpectedv"
		size = 44
		refs = "0000 _gp_disp 000c _ZN10__cxxabiv120__unexpected_handlerE 0010 _ZN10__cxxabiv112__unexpectedEPFvvE"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F ?? ?? 99 8F E0 FF BD 27 00 00 44 8C 10 00 BC AF 1C 00 BF AF ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_75_1_3 {
	meta:
		name = "_ZSt9terminatev"
		size = 44
		refs = "0000 _gp_disp 000c _ZN10__cxxabiv119__terminate_handlerE 0010 _ZN10__cxxabiv111__terminateEPFvvE"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F ?? ?? 99 8F E0 FF BD 27 00 00 44 8C 10 00 BC AF 1C 00 BF AF ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_79_0_3 {
	meta:
		name = "_ZZN12_GLOBAL__N_18key_initEvEN5key_sD2Ev"
		size = 28
		refs = "0000 _gp_disp 0010 pthread_key_delete"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F ?? ?? 99 8F ?? ?? ?? ?? ?? ?? 44 8C }
	condition:
		$1
}

rule file_386_0_0 {
	meta:
		name = "__GI_ungetc"
		size = 384
		refs = "0000 _gp_disp 0038 _pthread_cleanup_push_defer 0040 __pthread_mutex_unlock 0054 __pthread_mutex_lock 00c4 __stdio_trans2r_o 0150 _pthread_cleanup_pop_restore"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 C0 FF BD 27 30 00 B1 AF 2C 00 B0 AF 10 00 BC AF 3C 00 BF AF 38 00 B3 AF 34 00 B2 AF 34 00 B2 8C 21 88 80 00 0C 00 40 16 21 80 A0 00 ?? ?? 99 8F 38 00 B3 24 ?? ?? 85 8F 18 00 A4 27 ?? ?? ?? ?? 21 30 60 02 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 60 02 10 00 BC 8F 10 00 02 8E 18 00 04 8E 2B 20 44 00 11 00 80 10 00 00 03 96 FF FF 04 24 0F 00 24 52 83 00 63 30 08 00 04 8E 2B 20 82 00 0B 00 80 50 83 00 63 30 FF FF 45 90 FF 00 24 32 07 00 A4 54 83 00 63 30 FF FF 42 24 FB FF 63 30 10 00 02 AE 25 00 00 10 00 00 03 A6 83 00 63 30 81 00 63 2C 07 00 60 14 ?? ?? 99 8F 00 00 02 96 02 00 43 30 0A 00 60 54 01 00 43 30 0D 00 00 10 FF FF 03 24 21 20 00 02 ?? ?? ?? ?? 80 00 05 24 F6 FF 40 10 10 00 BC 8F 14 00 00 10 FF FF 11 24 12 00 60 54 FF FF 11 24 28 00 03 8E FA FF 60 14 FF FF 03 24 0D 00 23 12 01 00 42 24 08 00 03 8E FF FF 42 30 18 00 03 AE 01 00 03 24 28 00 03 AE 01 00 43 30 08 00 63 24 80 18 03 00 21 18 03 02 FB FF 42 30 04 00 71 AC 00 00 02 A6 06 00 40 16 3C 00 BF 8F ?? ?? 99 8F 18 00 A4 27 ?? ?? ?? ?? 01 00 05 24 3C 00 BF 8F 21 10 20 02 38 00 B3 8F 34 00 B2 8F 30 00 B1 8F 2C 00 B0 8F 08 00 E0 03 40 00 BD 27 }
	condition:
		$1
}

rule file_387_0_0 {
	meta:
		name = "setxattr"
		size = 100
		refs = "0000 _gp_disp 003c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 30 00 A2 8F E0 FF BD 27 10 00 A2 AF 80 10 02 24 0C 00 00 00 20 00 BD 27 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_387_1_0 {
	meta:
		name = "lsetxattr"
		size = 100
		refs = "0000 _gp_disp 003c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 30 00 A2 8F E0 FF BD 27 10 00 A2 AF 81 10 02 24 0C 00 00 00 20 00 BD 27 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_387_2_0 {
	meta:
		name = "fsetxattr"
		size = 100
		refs = "0000 _gp_disp 003c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 30 00 A2 8F E0 FF BD 27 10 00 A2 AF 82 10 02 24 0C 00 00 00 20 00 BD 27 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_387_3_0 {
	meta:
		name = "getxattr"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 83 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_387_4_0 {
	meta:
		name = "lgetxattr"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 84 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_387_5_0 {
	meta:
		name = "fgetxattr"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 85 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_387_6_0 {
	meta:
		name = "listxattr"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 86 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_387_7_0 {
	meta:
		name = "llistxattr"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 87 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_387_8_0 {
	meta:
		name = "flistxattr"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 88 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_387_9_0 {
	meta:
		name = "removexattr"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 89 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_387_10_0 {
	meta:
		name = "lremovexattr"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 8A 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_387_11_0 {
	meta:
		name = "fremovexattr"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 8B 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_388_0_0 {
	meta:
		name = "_charpad"
		size = 148
		refs = "0000 _gp_disp 0014 _wstdio_fwrite"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 C8 FF BD 27 2C 00 B3 AF ?? ?? 93 8F 30 00 B4 AF 28 00 B2 AF 24 00 B1 AF 20 00 B0 AF 10 00 BC AF 34 00 BF AF 21 A0 80 00 21 88 C0 00 18 00 A5 AF 21 80 C0 00 18 00 B2 27 0A 00 00 12 21 20 40 02 01 00 05 24 21 C8 60 02 ?? ?? ?? ?? 21 30 80 02 01 00 03 24 04 00 43 14 34 00 BF 8F F6 FF 00 10 FF FF 10 26 34 00 BF 8F 23 10 30 02 30 00 B4 8F 2C 00 B3 8F 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_388_1_0 {
	meta:
		name = "_fp_out_wide"
		size = 252
		refs = "0000 _gp_disp 0044 __GI_strlen 0070 _charpad 00c4 _wstdio_fwrite"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 78 FF BD 27 80 00 A2 30 10 00 BC AF 80 00 B4 AF 7C 00 B3 AF 78 00 B2 AF 70 00 B0 AF 84 00 BF AF 74 00 B1 AF 21 98 80 00 21 80 A0 00 21 90 C0 00 13 00 40 10 21 A0 E0 00 ?? ?? 99 8F ?? ?? ?? ?? 21 20 E0 00 23 90 42 02 10 00 BC 8F 0D 00 40 1A 21 88 40 00 ?? ?? 99 8F 7F 00 05 32 21 20 60 02 ?? ?? 39 27 ?? ?? ?? ?? 21 30 40 02 21 80 40 00 16 00 52 14 10 00 BC 8F 03 00 00 10 00 00 00 00 21 88 C0 00 21 80 00 00 10 00 20 1A 21 10 00 00 18 00 A4 27 21 28 82 02 00 00 A5 80 80 18 02 00 21 18 83 00 01 00 42 24 00 00 65 AC 2A 18 51 00 F9 FF 60 14 21 28 82 02 ?? ?? 99 8F 21 28 20 02 ?? ?? ?? ?? 21 30 60 02 21 80 02 02 84 00 BF 8F 21 10 00 02 80 00 B4 8F 7C 00 B3 8F 78 00 B2 8F 74 00 B1 8F 70 00 B0 8F 08 00 E0 03 88 00 BD 27 }
	condition:
		$1
}

rule file_388_2_0 {
	meta:
		name = "_vfwprintf_internal"
		size = 2016
		refs = "0000 _gp_disp 0024 __GI_memset 0070 __GI_wcsrtombs 00d8 _ppfs_parsespec 0144 _ppfs_prepargs 0158 __GI_wcslen 0170 _wstdio_fwrite 0218 _ppfs_setargs 027c _store_inttype 0340 _load_inttype 0358 _uintmaxtostr 03bc __GI_mbsrtowcs 0468 $LC0 04b4 _fpmaxtostr 04f8 __GI_wcsnlen 0564 __GI_btowc 05d0 $LC1 0678 _charpad 0694 __GI_fputws"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 70 FD BD 27 20 01 B9 27 6C 02 B1 AF 58 02 B9 AF 21 88 80 00 21 20 20 03 ?? ?? 99 8F 18 00 BC AF 8C 02 BF AF 7C 02 B5 AF 74 02 B3 AF 70 02 B2 AF 68 02 B0 AF 21 90 A0 00 88 02 BE AF 21 28 00 00 84 02 B7 AF 80 02 B6 AF 78 02 B4 AF 21 80 C0 00 ?? ?? ?? ?? 98 00 06 24 18 00 BC 8F 80 00 02 24 FF FF 15 24 ?? ?? 99 8F 20 00 B3 27 38 01 B5 AF 20 01 B2 AF 30 01 A2 AF 20 00 A0 AF B8 01 B2 AF 21 20 00 00 B8 01 A5 27 FF FF 06 24 ?? ?? ?? ?? 21 38 60 02 05 00 55 14 18 00 BC 8F ?? ?? 82 8F ?? ?? 42 24 28 00 00 10 20 01 A2 AF 48 01 A2 27 09 00 04 24 21 B8 40 00 08 00 03 24 FF FF 84 24 00 00 43 AC FD FF 80 14 04 00 42 24 ?? ?? 96 8F 21 10 40 02 25 00 15 24 00 00 44 8C 11 00 80 50 38 01 A2 8F FC FF 95 54 04 00 42 24 04 00 44 24 04 00 42 8C 08 00 55 10 21 C8 C0 02 20 01 A4 AF ?? ?? ?? ?? 20 01 A4 27 0F 00 40 04 18 00 BC 8F F1 FF 00 10 20 01 A2 8F 21 10 80 00 EE FF 00 10 04 00 42 24 20 01 B2 AF 21 18 E0 02 08 00 04 24 FF FF 42 24 10 00 40 04 ?? ?? 99 8F 00 00 65 8C FB FF A4 14 04 00 63 24 20 01 B0 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 00 02 18 00 BC 8F 21 20 00 02 21 28 40 00 ?? ?? 99 8F ?? ?? ?? ?? 21 30 20 02 8B 01 00 10 FF FF 10 24 20 01 A4 27 ?? ?? ?? ?? 21 28 00 02 18 00 BC 8F 21 20 40 02 21 80 00 00 00 00 42 8E 06 00 40 10 23 A8 44 02 25 00 03 24 04 00 43 10 03 00 A2 26 F9 FF 00 10 04 00 52 26 03 00 A2 26 07 00 42 2C 0A 00 40 54 00 00 42 8E ?? ?? 99 8F 83 A8 15 00 21 28 A0 02 ?? ?? ?? ?? 21 30 20 02 E6 FF 55 14 18 00 BC 8F 21 80 02 02 00 00 42 8E 6E 01 40 10 25 00 02 24 04 00 43 8E 69 01 62 10 04 00 44 26 ?? ?? 99 8F 20 01 A4 AF ?? ?? ?? ?? 20 01 A4 27 18 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 20 01 A4 27 38 01 A3 8F 18 00 BC 8F 46 01 A4 93 04 00 60 18 70 01 A2 27 C0 18 04 00 F8 FF 63 24 21 10 43 00 21 28 00 00 21 18 00 00 3C 01 A6 8F 2A 30 66 00 04 00 C0 10 01 00 63 24 21 28 40 00 FA FF 00 10 08 00 42 24 40 01 A2 8F 0A 00 40 14 08 00 43 2C 00 00 A4 8C 30 01 A5 8F ?? ?? 99 8F 21 30 00 02 00 0F A5 30 ?? ?? ?? ?? C3 3F 10 00 90 00 00 10 18 00 BC 8F 7F 00 60 10 10 00 43 2C ?? ?? 83 8F ?? ?? 63 24 21 18 43 00 FF FF 74 80 0A 00 03 24 08 00 83 16 57 00 12 24 30 01 A3 8F 2C 00 06 24 20 00 68 30 0B 90 C8 00 40 00 63 30 80 00 46 36 0B 90 C3 00 06 00 43 2C 09 00 60 50 23 A0 14 00 03 00 03 24 05 00 43 10 01 00 03 24 04 00 43 14 06 00 16 24 04 00 00 10 24 01 A6 8F 37 00 12 24 0B 00 16 24 24 01 A6 8F 34 01 A3 83 20 00 15 24 00 00 C6 28 0B A8 66 00 01 00 03 24 06 00 43 10 09 00 84 24 80 20 04 00 21 20 64 02 00 01 84 8C 02 00 00 10 00 0F 84 30 00 04 04 24 ?? ?? 99 8F ?? ?? ?? ?? 21 30 80 02 18 00 BC 8F 10 00 B4 AF 14 00 B2 AF ?? ?? 99 8F 37 02 A4 27 21 30 40 00 ?? ?? ?? ?? 21 38 60 00 21 B8 40 00 40 01 A2 8F 06 00 42 2C 10 00 40 14 18 00 BC 8F 00 00 E4 82 2D 00 03 24 06 00 83 14 30 01 A2 8F 02 00 42 34 30 01 A2 AF 01 00 F7 26 07 00 00 10 02 00 16 24 02 00 43 30 04 00 60 54 21 B0 00 00 01 00 42 30 04 00 03 24 0B B0 62 00 ?? ?? 99 8F 21 20 00 00 21 28 60 02 48 02 A7 27 20 00 B7 AF 48 02 A0 AF ?? ?? ?? ?? 21 30 00 00 24 01 A7 8F 21 F0 40 00 01 00 05 24 00 00 E2 28 0B 38 A2 00 30 01 A2 8F 18 00 BC 8F 10 00 42 30 11 00 40 10 00 00 E4 82 40 01 A2 8F 03 00 46 2C 0D 00 C0 54 06 00 16 24 03 00 06 24 0A 00 46 50 09 00 16 24 04 00 06 24 07 00 46 14 2B 10 C7 03 06 00 40 14 30 00 02 24 30 00 87 38 01 00 C2 27 0B 28 47 00 21 38 A0 00 30 00 02 24 0F 00 82 14 2B 10 C7 03 06 00 C4 2A 0B 00 02 24 0A B0 44 00 40 01 A4 8F 01 00 02 24 05 00 82 10 ?? ?? 89 8F 06 00 E0 54 2B 10 C7 03 54 00 00 10 21 F0 00 00 05 00 1E 24 51 00 00 10 ?? ?? 37 25 5E 00 40 14 23 38 FE 00 5C 00 00 10 21 38 00 00 10 00 60 10 12 00 43 2C 24 01 A2 27 00 00 A6 8C 04 00 A7 8C 10 00 A2 AF ?? ?? 82 8F ?? ?? 99 8F 21 20 20 02 ?? ?? 42 24 ?? ?? ?? ?? 14 00 A2 AF B1 00 40 04 18 00 BC 8F 21 80 02 02 AF 00 00 10 21 90 00 00 1E 00 60 10 14 00 43 2C 11 00 03 24 12 00 43 54 00 00 A2 8C 00 00 B4 8C 36 00 80 12 ?? ?? 99 8F 24 01 A2 8F FF FF 03 24 00 00 45 28 0A 18 45 00 21 20 80 02 ?? ?? ?? ?? 21 28 60 00 21 F0 40 00 18 00 BC 8F 21 B8 00 00 20 00 15 24 0B 00 16 24 36 00 00 10 21 38 00 00 40 02 A2 AF 44 02 A0 AF 21 B8 00 00 20 00 15 24 0B 00 16 24 21 38 00 00 01 00 1E 24 2D 00 00 10 40 02 B4 27 8D 00 60 10 13 00 03 24 15 00 43 14 ?? ?? 99 8F 00 00 B7 8C 1F 00 E0 12 ?? ?? 99 8F 24 01 A2 8F FF FF 12 24 00 00 46 28 48 02 A4 27 0B 10 46 02 20 00 B7 AF 48 02 A0 AF 21 28 60 02 21 30 40 00 ?? ?? ?? ?? 21 38 80 00 21 F0 40 00 7A 00 52 10 18 00 BC 8F 20 00 15 24 05 00 00 10 0B 00 16 24 ?? ?? ?? ?? 00 00 A4 90 DC FF 00 10 18 00 BC 8F 0E 00 00 10 21 38 00 00 ?? ?? 89 8F 20 00 15 24 0B 00 16 24 ?? ?? 37 25 21 38 00 00 08 00 00 10 06 00 1E 24 ?? ?? 89 8F 20 00 15 24 0B 00 16 24 ?? ?? 37 25 21 38 00 00 06 00 1E 24 21 A0 00 00 0B 00 04 24 06 00 C4 12 21 10 FE 00 06 00 C6 2A 01 00 04 24 02 00 05 24 0A 20 A6 00 21 10 44 00 28 01 A4 8F 21 80 50 00 2B 90 44 00 23 20 82 00 0A 20 12 00 30 00 02 24 21 90 80 00 03 00 A2 16 21 80 04 02 21 38 E4 00 21 90 00 00 30 01 A2 8F ?? ?? 83 8F 08 00 42 30 0B 00 40 14 ?? ?? 75 24 64 02 A7 AF 21 20 20 02 20 00 05 24 21 C8 A0 02 ?? ?? ?? ?? 21 30 40 02 18 00 BC 8F 42 00 52 14 64 02 A7 8F 21 90 00 00 ?? ?? 82 8F ?? ?? 99 8F 80 20 16 00 ?? ?? 42 24 21 20 44 00 21 28 20 02 ?? ?? ?? ?? 64 02 A7 AF 64 02 A7 8F 21 20 20 02 30 00 05 24 21 C8 A0 02 ?? ?? ?? ?? 21 30 E0 00 64 02 A7 8F 30 00 47 14 18 00 BC 8F 28 00 80 16 ?? ?? 99 8F 50 02 B7 AF ?? ?? 97 8F 50 02 A3 27 38 02 B9 27 38 02 A0 AF 5C 02 A3 AF 40 00 16 24 60 02 B9 AF 14 00 C0 13 ?? ?? 99 8F 41 00 C6 2F 21 10 C0 02 0B 10 C6 03 21 20 60 02 50 02 A5 27 21 30 40 00 ?? ?? ?? ?? 38 02 A7 27 21 28 40 00 21 20 60 02 21 30 20 02 21 C8 E0 02 ?? ?? ?? ?? 21 A0 40 00 23 F0 C2 03 EE FF 54 10 18 00 BC 8F 12 00 C0 57 FF FF 12 24 21 30 40 02 21 20 20 02 21 C8 A0 02 ?? ?? ?? ?? 20 00 05 24 26 10 52 00 2B 90 02 00 18 00 BC 8F 08 00 00 10 23 90 12 00 21 20 80 02 21 28 C0 03 ?? ?? ?? ?? 21 30 20 02 F1 FF 5E 10 18 00 BC 8F FF FF 12 24 79 FE 40 16 20 01 A4 8F 7F FE 00 10 21 90 80 00 7D FE 00 10 08 00 52 26 8C 02 BF 8F 21 10 00 02 88 02 BE 8F 84 02 B7 8F 80 02 B6 8F 7C 02 B5 8F 78 02 B4 8F 74 02 B3 8F 70 02 B2 8F 6C 02 B1 8F 68 02 B0 8F 08 00 E0 03 90 02 BD 27 }
	condition:
		$1
}

rule file_390_0_0 {
	meta:
		name = "wcwidth"
		size = 56
		refs = "0000 _gp_disp 000c __GI_wcswidth"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F E0 FF BD 27 01 00 05 24 1C 00 BF AF 10 00 BC AF 20 00 A4 AF ?? ?? ?? ?? 20 00 A4 27 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_391_0_0 {
	meta:
		name = "fcloseall"
		size = 424
		refs = "0000 _gp_disp 0010 _stdio_openlist_del_lock 0014 __pthread_mutex_unlock 0018 _pthread_cleanup_push_defer 0060 __pthread_mutex_lock 007c _stdio_openlist_use_count 0080 _pthread_cleanup_pop_restore 00a0 _stdio_openlist_add_lock 00d0 _stdio_openlist 00e4 __GI_fclose 00ec _stdio_openlist_dec_use"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 B0 FF BD 27 ?? ?? 86 8F ?? ?? 85 8F ?? ?? 99 8F 2C 00 B1 AF 18 00 B1 27 4C 00 BF AF 10 00 BC AF 44 00 B7 AF 40 00 B6 AF 3C 00 B5 AF 30 00 B2 AF 28 00 B0 AF 48 00 BE AF 38 00 B4 AF 34 00 B3 AF ?? ?? ?? ?? 21 20 20 02 10 00 BC 8F 21 90 00 00 30 00 15 24 ?? ?? 99 8F ?? ?? 84 8F ?? ?? ?? ?? FF FF 17 24 10 00 BC 8F 21 20 20 02 01 00 05 24 ?? ?? 82 8F ?? ?? 99 8F 00 00 43 8C 01 00 63 24 00 00 43 AC ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F ?? ?? 85 8F ?? ?? 86 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 20 02 10 00 BC 8F ?? ?? 84 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F 21 20 20 02 01 00 05 24 ?? ?? 82 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 50 8C 10 00 BC 8F ?? ?? 96 8F 20 00 00 12 ?? ?? 99 8F 34 00 13 8E 0C 00 60 16 20 00 1E 8E ?? ?? 99 8F ?? ?? 85 8F 38 00 14 26 21 20 20 02 ?? ?? ?? ?? 21 30 80 02 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 80 02 10 00 BC 8F 00 00 02 96 30 00 42 30 05 00 55 10 21 C8 C0 02 ?? ?? ?? ?? 21 20 00 02 10 00 BC 8F 0B 90 E2 02 E7 FF 60 56 21 80 C0 03 ?? ?? 99 8F 21 20 20 02 ?? ?? ?? ?? 01 00 05 24 10 00 BC 8F E0 FF 00 10 21 80 C0 03 ?? ?? ?? ?? 00 00 00 00 4C 00 BF 8F 21 10 40 02 48 00 BE 8F 44 00 B7 8F 40 00 B6 8F 3C 00 B5 8F 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 E0 03 50 00 BD 27 }
	condition:
		$1
}

rule file_393_0_0 {
	meta:
		name = "tcgetsid"
		size = 272
		refs = "0000 _gp_disp 0038 __GI___errno_location 0050 __GI_ioctl 0098 __GI_tcgetpgrp 00b0 __GI_getsid"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 C8 FF BD 27 2C 00 B2 AF ?? ?? 92 8F 10 00 BC AF 28 00 B1 AF ?? ?? 42 8E 34 00 BF AF 30 00 B3 AF 24 00 B0 AF 19 00 40 14 21 88 80 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F 21 20 20 02 16 74 05 24 ?? ?? 99 8F 18 00 A6 27 21 80 40 00 ?? ?? ?? ?? 00 00 53 8C 0A 00 41 04 10 00 BC 8F 00 00 03 8E 16 00 02 24 03 00 62 10 01 00 02 24 1C 00 00 10 FF FF 10 24 ?? ?? 42 AE 03 00 00 10 00 00 13 AE 17 00 00 10 18 00 B0 8F ?? ?? 99 8F 21 20 20 02 ?? ?? ?? ?? FF FF 11 24 F4 FF 51 10 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 40 00 18 00 A2 AF 10 00 BC 8F 0A 00 51 14 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 44 8C 03 00 03 24 03 00 83 54 FF FF 10 24 19 00 03 24 00 00 43 AC 34 00 BF 8F 21 10 00 02 30 00 B3 8F 2C 00 B2 8F 28 00 B1 8F 24 00 B0 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_395_0_0 {
	meta:
		name = "sysmips"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 35 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_396_0_0 {
	meta:
		name = "__GI_sprintf"
		size = 68
		refs = "0000 _gp_disp 0010 __GI_vsnprintf"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D8 FF BD 27 ?? ?? 99 8F 34 00 A7 AF 30 00 A7 27 24 00 BF AF 10 00 BC AF 30 00 A6 AF 18 00 A7 AF 21 30 A0 00 ?? ?? ?? ?? FF FF 05 24 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_397_0_0 {
	meta:
		name = "__GI___cxa_atexit"
		size = 120
		refs = "0000 _gp_disp 002c __new_exitfn"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D8 FF BD 27 10 00 BC AF 18 00 B0 AF 24 00 BF AF 20 00 B2 AF 1C 00 B1 AF 0B 00 80 10 21 80 80 00 ?? ?? 99 8F 21 88 A0 00 ?? ?? ?? ?? 21 90 C0 00 07 00 40 10 03 00 03 24 04 00 50 AC 08 00 51 AC 0C 00 52 AC 00 00 43 AC 02 00 00 10 21 10 00 00 FF FF 02 24 24 00 BF 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_398_0_0 {
	meta:
		name = "__GI_getgrnam_r"
		size = 300
		refs = "0000 _gp_disp 0030 __GI_fopen 0028 $LC0 002c $LC1 0078 __GI___errno_location 008c __pgsreader 0090 __GI_strcmp 009c __parsegrent 00ec __GI_fclose"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 B8 FF BD 27 34 00 B5 AF 2C 00 B3 AF 28 00 B2 AF 58 00 B3 8F 21 A8 80 00 21 90 A0 00 ?? ?? 84 8F ?? ?? 85 8F ?? ?? 99 8F 18 00 BC AF 3C 00 B7 AF 38 00 B6 AF 24 00 B1 AF 44 00 BF AF 40 00 BE AF 30 00 B4 AF 20 00 B0 AF ?? ?? 84 24 00 00 60 AE ?? ?? A5 24 21 B0 C0 00 ?? ?? ?? ?? 21 B8 E0 00 21 88 40 00 06 00 40 14 18 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 1C 00 00 10 00 00 50 8C ?? ?? 9E 8F ?? ?? 94 8F 01 00 02 24 34 00 22 AE ?? ?? 84 8F 10 00 B1 AF 21 28 40 02 21 30 C0 02 21 C8 C0 03 ?? ?? ?? ?? 21 38 E0 02 21 80 40 00 09 00 40 14 18 00 BC 8F 00 00 44 8E 21 C8 80 02 ?? ?? ?? ?? 21 28 A0 02 F1 FF 40 14 18 00 BC 8F 03 00 00 10 00 00 72 AE 02 00 42 38 0A 80 02 00 ?? ?? 99 8F ?? ?? ?? ?? 21 20 20 02 44 00 BF 8F 21 10 00 02 40 00 BE 8F 3C 00 B7 8F 38 00 B6 8F 34 00 B5 8F 30 00 B4 8F 2C 00 B3 8F 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 08 00 E0 03 48 00 BD 27 }
	condition:
		$1
}

rule file_752_0_0 {
	meta:
		name = "__GI_getpwnam_r"
		size = 300
		refs = "0000 _gp_disp 0030 __GI_fopen 0028 $LC0 002c $LC1 0078 __GI___errno_location 008c __pgsreader 0090 __GI_strcmp 009c __parsepwent 00ec __GI_fclose"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 B8 FF BD 27 34 00 B5 AF 2C 00 B3 AF 28 00 B2 AF 58 00 B3 8F 21 A8 80 00 21 90 A0 00 ?? ?? 84 8F ?? ?? 85 8F ?? ?? 99 8F 18 00 BC AF 3C 00 B7 AF 38 00 B6 AF 24 00 B1 AF 44 00 BF AF 40 00 BE AF 30 00 B4 AF 20 00 B0 AF ?? ?? 84 24 00 00 60 AE ?? ?? A5 24 21 B0 C0 00 ?? ?? ?? ?? 21 B8 E0 00 21 88 40 00 06 00 40 14 18 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 1C 00 00 10 00 00 50 8C ?? ?? 9E 8F ?? ?? 94 8F 01 00 02 24 34 00 22 AE ?? ?? 84 8F 10 00 B1 AF 21 28 40 02 21 30 C0 02 21 C8 C0 03 ?? ?? ?? ?? 21 38 E0 02 21 80 40 00 09 00 40 14 18 00 BC 8F 00 00 44 8E 21 C8 80 02 ?? ?? ?? ?? 21 28 A0 02 F1 FF 40 14 18 00 BC 8F 03 00 00 10 00 00 72 AE 02 00 42 38 0A 80 02 00 ?? ?? 99 8F ?? ?? ?? ?? 21 20 20 02 44 00 BF 8F 21 10 00 02 40 00 BE 8F 3C 00 B7 8F 38 00 B6 8F 34 00 B5 8F 30 00 B4 8F 2C 00 B3 8F 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 08 00 E0 03 48 00 BD 27 }
	condition:
		$1
}

rule file_539_0_0 {
	meta:
		name = "__GI_getspnam_r"
		size = 300
		refs = "0000 _gp_disp 0030 __GI_fopen 0028 $LC0 002c $LC1 0078 __GI___errno_location 008c __pgsreader 0090 __GI_strcmp 009c __parsespent 00ec __GI_fclose"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 B8 FF BD 27 34 00 B5 AF 2C 00 B3 AF 28 00 B2 AF 58 00 B3 8F 21 A8 80 00 21 90 A0 00 ?? ?? 84 8F ?? ?? 85 8F ?? ?? 99 8F 18 00 BC AF 3C 00 B7 AF 38 00 B6 AF 24 00 B1 AF 44 00 BF AF 40 00 BE AF 30 00 B4 AF 20 00 B0 AF ?? ?? 84 24 00 00 60 AE ?? ?? A5 24 21 B0 C0 00 ?? ?? ?? ?? 21 B8 E0 00 21 88 40 00 06 00 40 14 18 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 1C 00 00 10 00 00 50 8C ?? ?? 9E 8F ?? ?? 94 8F 01 00 02 24 34 00 22 AE ?? ?? 84 8F 10 00 B1 AF 21 28 40 02 21 30 C0 02 21 C8 C0 03 ?? ?? ?? ?? 21 38 E0 02 21 80 40 00 09 00 40 14 18 00 BC 8F 00 00 44 8E 21 C8 80 02 ?? ?? ?? ?? 21 28 A0 02 F1 FF 40 14 18 00 BC 8F 03 00 00 10 00 00 72 AE 02 00 42 38 0A 80 02 00 ?? ?? 99 8F ?? ?? ?? ?? 21 20 20 02 44 00 BF 8F 21 10 00 02 40 00 BE 8F 3C 00 B7 8F 38 00 B6 8F 34 00 B5 8F 30 00 B4 8F 2C 00 B3 8F 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 08 00 E0 03 48 00 BD 27 }
	condition:
		$1
}

rule file_399_0_0 {
	meta:
		name = "getppid"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF E0 0F 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_400_0_0 {
	meta:
		name = "readv"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 31 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_401_0_0 {
	meta:
		name = "__GI__rpc_dtablesize"
		size = 80
		refs = "0000 _gp_disp 002c __GI_getdtablesize"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 18 00 B0 AF ?? ?? 90 8F 10 00 BC AF 1C 00 BF AF ?? ?? 02 8E 07 00 40 14 1C 00 BF 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 ?? ?? 02 AE 1C 00 BF 8F ?? ?? 02 8E 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_402_0_0 {
	meta:
		name = "__libc_sa_len"
		size = 56
		refs = "0000 _gp_disp"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 FF FF 84 24 FF FF 84 30 0A 00 83 2C 05 00 60 10 21 10 00 00 ?? ?? 82 8F ?? ?? 42 24 21 20 82 00 00 00 82 80 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_403_0_0 {
	meta:
		name = "__GI_setsockopt"
		size = 100
		refs = "0000 _gp_disp 003c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 30 00 A2 8F E0 FF BD 27 10 00 A2 AF 55 10 02 24 0C 00 00 00 20 00 BD 27 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_406_0_0 {
	meta:
		name = "putspent"
		size = 432
		refs = "0000 _gp_disp 004c _pthread_cleanup_push_defer 0054 __pthread_mutex_unlock 0068 __pthread_mutex_lock 0084 $LC0 008c __GI_fprintf 0090 $LC1 0124 __GI___fputc_unlocked 0120 $LC2 016c _pthread_cleanup_pop_restore"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 B0 FF BD 27 2C 00 B1 AF 28 00 B0 AF 10 00 BC AF 4C 00 BF AF 48 00 BE AF 44 00 B7 AF 40 00 B6 AF 3C 00 B5 AF 38 00 B4 AF 34 00 B3 AF 30 00 B2 AF 34 00 B3 8C 21 88 80 00 0C 00 60 16 21 80 A0 00 ?? ?? 99 8F 38 00 B2 24 ?? ?? 85 8F 18 00 A4 27 ?? ?? ?? ?? 21 30 40 02 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 40 02 10 00 BC 8F 04 00 27 8E 03 00 E0 14 00 00 26 8E ?? ?? 87 8F ?? ?? E7 24 ?? ?? 92 8F ?? ?? 85 8F 21 20 00 02 21 C8 40 02 ?? ?? ?? ?? ?? ?? A5 24 21 A0 40 02 10 00 BC 8F 03 00 41 04 21 90 00 00 2B 00 00 10 FF FF 10 24 ?? ?? 95 8F ?? ?? 97 8F ?? ?? 9E 8F ?? ?? B5 26 FF FF 16 24 21 10 55 02 00 00 42 90 ?? ?? E5 26 21 20 00 02 21 10 22 02 00 00 46 8C ?? ?? C2 27 21 C8 80 02 26 18 D6 00 ?? ?? ?? ?? 0A 28 43 00 ED FF 40 04 10 00 BC 8F 01 00 52 26 06 00 02 24 F1 FF 42 16 21 10 55 02 20 00 26 8E FF FF 02 24 09 00 C2 14 ?? ?? 85 8F ?? ?? 99 8F 21 28 00 02 ?? ?? ?? ?? 0A 00 04 24 01 00 42 28 10 00 BC 8F 09 00 00 10 23 80 02 00 ?? ?? 99 8F 21 20 00 02 ?? ?? ?? ?? ?? ?? A5 24 F3 FF 41 04 10 00 BC 8F 01 00 00 10 FF FF 10 24 06 00 60 16 4C 00 BF 8F ?? ?? 99 8F 18 00 A4 27 ?? ?? ?? ?? 01 00 05 24 4C 00 BF 8F 21 10 00 02 48 00 BE 8F 44 00 B7 8F 40 00 B6 8F 3C 00 B5 8F 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 E0 03 50 00 BD 27 }
	condition:
		$1
}

rule file_407_0_0 {
	meta:
		name = "__GI_sigprocmask"
		size = 132
		refs = "0000 _gp_disp 0030 __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 0A 00 A0 10 FF FF 82 24 03 00 42 2C 08 00 40 14 10 00 07 24 ?? ?? 99 8F ?? ?? ?? ?? FF FF 10 24 16 00 03 24 0B 00 00 10 00 00 43 AC 10 00 07 24 63 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_408_0_0 {
	meta:
		name = "__GI_strlcpy"
		size = 72
	strings:
		$1 = { F0 FF BD 27 03 00 C0 50 21 30 00 00 02 00 00 10 FF FF C6 24 08 00 A4 27 21 10 A0 00 00 00 43 80 06 00 60 10 00 00 83 A0 FC FF C0 10 01 00 42 24 FF FF C6 24 F9 FF 00 10 01 00 84 24 23 10 45 00 08 00 E0 03 10 00 BD 27 }
	condition:
		$1
}

rule file_409_0_0 {
	meta:
		name = "__GI_inet_netof"
		size = 52
	strings:
		$1 = { A0 20 04 7C 02 24 24 00 03 00 80 04 00 C0 03 3C 08 00 E0 03 02 16 04 00 24 18 83 00 00 80 05 3C 02 14 04 00 26 18 65 00 02 22 04 00 08 00 E0 03 0B 10 83 00 }
	condition:
		$1
}

rule file_410_0_0 {
	meta:
		name = "__GI_listen"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 4E 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_412_0_0 {
	meta:
		name = "__GI_fstat64"
		size = 120
		refs = "0000 _gp_disp 0034 __GI___errno_location 0054 __xstat64_conv"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 78 FF BD 27 10 00 BC AF 21 30 A0 00 84 00 BF AF 80 00 B0 AF 18 00 A5 27 77 10 02 24 0C 00 00 00 07 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC 07 00 00 10 FF FF 10 24 06 00 40 14 84 00 BF 8F ?? ?? 99 8F 18 00 A4 27 ?? ?? ?? ?? 21 28 C0 00 84 00 BF 8F 21 10 00 02 80 00 B0 8F 08 00 E0 03 88 00 BD 27 }
	condition:
		$1
}

rule file_413_0_0 {
	meta:
		name = "sched_getaffinity"
		size = 160
		refs = "0000 _gp_disp 004c __GI___errno_location 0068 __GI_memset"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D8 FF BD 27 1C 00 B1 AF 10 00 BC AF 21 88 A0 00 20 00 B2 AF 24 00 BF AF 18 00 B0 AF 03 00 21 06 21 90 C0 00 FF 7F 05 3C FF FF A5 34 21 30 40 02 90 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 0A 00 00 10 00 00 50 AC FF FF 02 24 08 00 02 12 ?? ?? 99 8F 21 20 50 02 21 28 00 00 ?? ?? ?? ?? 23 30 30 02 02 00 00 10 21 10 00 00 FF FF 02 24 24 00 BF 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_414_0_0 {
	meta:
		name = "xdrrec_inline"
		size = 124
	strings:
		$1 = { 00 00 82 8C 06 00 40 10 0C 00 83 8C 01 00 04 24 0B 00 44 50 34 00 66 8C 08 00 E0 03 21 10 00 00 10 00 62 8C 14 00 64 8C 21 28 45 00 2B 20 85 00 10 00 80 54 21 10 00 00 08 00 E0 03 10 00 65 AC 2B 10 C5 00 0B 00 40 14 21 10 00 00 2C 00 62 8C 30 00 67 8C 21 20 45 00 2B 38 E4 00 04 00 E0 14 23 28 C5 00 34 00 65 AC 08 00 E0 03 2C 00 64 AC 21 10 00 00 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_414_1_0 {
	meta:
		name = "fill_input_buf"
		size = 108
	strings:
		$1 = { D8 FF BD 27 1C 00 B0 AF 24 00 BF AF 20 00 B1 AF 30 00 82 8C 28 00 91 8C 24 00 86 8C 03 00 42 30 20 00 99 8C 21 80 80 00 00 00 84 8C 21 88 22 02 21 28 20 02 09 F8 20 03 23 30 C2 00 FF FF 03 24 05 00 43 50 21 10 00 00 2C 00 11 AE 21 88 22 02 30 00 11 AE 01 00 02 24 24 00 BF 8F 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_414_2_0 {
	meta:
		name = "skip_input_bytes"
		size = 148
		refs = "0000 _gp_disp 0050 fill_input_buf"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D8 FF BD 27 20 00 B2 AF ?? ?? 92 8F 1C 00 B1 AF 18 00 B0 AF 10 00 BC AF 24 00 BF AF 21 88 80 00 21 80 A0 00 12 00 00 1A 01 00 02 24 2C 00 23 8E 30 00 22 8E 23 10 43 00 08 00 40 14 2A 20 50 00 ?? ?? 59 26 ?? ?? ?? ?? 21 20 20 02 F5 FF 40 14 21 10 00 00 07 00 00 10 24 00 BF 8F 0A 10 04 02 21 18 62 00 2C 00 23 AE EE FF 00 10 23 80 02 02 24 00 BF 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_414_3_0 {
	meta:
		name = "xdrrec_destroy"
		size = 72
		refs = "0000 _gp_disp 0020 free"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 0C 00 90 8C ?? ?? 99 8F ?? ?? ?? ?? 04 00 04 8E 10 00 BC 8F 1C 00 BF 8F 21 20 00 02 ?? ?? 99 8F 18 00 B0 8F ?? ?? ?? ?? 20 00 BD 27 }
	condition:
		$1
}

rule file_414_4_0 {
	meta:
		name = "xdrrec_getpos"
		size = 140
		refs = "0000 _gp_disp 0028 __GI_lseek"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D8 FF BD 27 20 00 B1 AF 10 00 BC AF 24 00 BF AF 1C 00 B0 AF 0C 00 90 8C 21 88 80 00 ?? ?? 99 8F 00 00 04 8E 21 28 00 00 ?? ?? ?? ?? 01 00 06 24 FF FF 03 24 0D 00 43 50 FF FF 02 24 00 00 23 8E 06 00 60 10 01 00 04 24 08 00 64 54 FF FF 02 24 2C 00 04 8E 03 00 00 10 30 00 03 8E 10 00 04 8E 0C 00 03 8E 23 18 83 00 21 10 43 00 24 00 BF 8F 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_414_5_0 {
	meta:
		name = "xdrrec_setpos"
		size = 244
		refs = "0000 _gp_disp 0034 xdrrec_getpos"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F D8 FF BD 27 20 00 B2 AF 1C 00 B1 AF 10 00 BC AF 24 00 BF AF 18 00 B0 AF ?? ?? 39 27 21 90 A0 00 21 88 80 00 ?? ?? ?? ?? 0C 00 90 8C FF FF 03 24 25 00 43 10 23 28 52 00 00 00 22 8E 05 00 40 10 01 00 03 24 0F 00 43 50 34 00 04 8E 1F 00 00 10 21 10 00 00 10 00 02 8E 18 00 03 8E 23 28 45 00 2B 18 65 00 19 00 60 10 21 10 00 00 14 00 03 8E 2B 18 A3 00 16 00 60 10 24 00 BF 8F 10 00 00 10 10 00 05 AE 2C 00 03 8E 2A 30 A4 00 0F 00 C0 10 21 10 00 00 30 00 06 8E 23 18 65 00 2B 30 C3 00 0B 00 C0 14 24 00 BF 8F 28 00 06 8E 2B 30 66 00 07 00 C0 14 23 28 85 00 2C 00 03 AE 34 00 05 AE 02 00 00 10 01 00 02 24 21 10 00 00 24 00 BF 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_414_6_0 {
	meta:
		name = "get_input_bytes"
		size = 196
		refs = "0000 _gp_disp 005c fill_input_buf 0074 __GI_memcpy"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D0 FF BD 27 28 00 B4 AF ?? ?? 94 8F 24 00 B3 AF 1C 00 B1 AF 18 00 B0 AF 10 00 BC AF 2C 00 BF AF 20 00 B2 AF 21 88 80 00 21 98 A0 00 21 80 C0 00 19 00 00 1A 01 00 02 24 2C 00 25 8E 30 00 32 8E 23 90 45 02 08 00 40 16 2A 10 50 02 ?? ?? 99 26 ?? ?? ?? ?? 21 20 20 02 F5 FF 40 14 10 00 BC 8F 0D 00 00 10 21 10 00 00 ?? ?? 99 8F 0A 90 02 02 21 20 60 02 ?? ?? ?? ?? 21 30 40 02 2C 00 22 8E 10 00 BC 8F 21 98 72 02 21 10 52 00 2C 00 22 AE E7 FF 00 10 23 80 12 02 2C 00 BF 8F 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_414_7_0 {
	meta:
		name = "set_input_fragment"
		size = 116
		refs = "0000 _gp_disp 002c get_input_bytes"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F D8 FF BD 27 18 00 A5 27 04 00 06 24 20 00 B0 AF 10 00 BC AF 24 00 BF AF ?? ?? 39 27 ?? ?? ?? ?? 21 80 80 00 03 00 40 54 18 00 A2 8F 09 00 00 10 21 10 00 00 A0 10 02 7C 02 14 22 00 C2 1F 02 00 FA FF 40 10 38 00 03 AE 00 F0 42 7C 34 00 02 AE 01 00 02 24 24 00 BF 8F 20 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_414_8_0 {
	meta:
		name = "xdrrec_getbytes"
		size = 224
		refs = "0000 _gp_disp 006c set_input_fragment 0098 get_input_bytes"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 C8 FF BD 27 30 00 B5 AF 2C 00 B4 AF 28 00 B3 AF 20 00 B1 AF 10 00 BC AF 34 00 BF AF 24 00 B2 AF 1C 00 B0 AF 0C 00 90 8C ?? ?? 94 8F ?? ?? 95 8F 21 98 A0 00 21 88 C0 00 1D 00 20 12 01 00 02 24 34 00 02 8E 0C 00 40 14 2B 90 51 00 38 00 02 8E 03 00 40 10 ?? ?? B9 26 15 00 00 10 21 10 00 00 ?? ?? ?? ?? 21 20 00 02 F3 FF 40 14 21 10 00 00 10 00 00 10 34 00 BF 8F 0A 10 32 02 21 20 00 02 21 28 60 02 21 30 40 00 ?? ?? 99 26 ?? ?? ?? ?? 21 90 40 00 F0 FF 40 10 21 98 72 02 34 00 02 8E 23 88 32 02 23 10 52 00 E3 FF 00 10 34 00 02 AE 34 00 BF 8F 30 00 B5 8F 2C 00 B4 8F 28 00 B3 8F 24 00 B2 8F 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_414_9_0 {
	meta:
		name = "xdrrec_getint32"
		size = 184
		refs = "0000 _gp_disp 0080 xdrrec_getbytes"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 0C 00 82 8C D8 FF BD 27 20 00 B0 AF 10 00 BC AF 24 00 BF AF 21 80 A0 00 34 00 45 8C 04 00 A5 28 11 00 A0 14 2C 00 43 8C 30 00 45 8C 23 28 A3 00 04 00 A5 28 0D 00 A0 14 ?? ?? 99 8F 00 00 63 8C A0 18 03 7C 02 1C 23 00 00 00 03 AE 34 00 43 8C FC FF 63 24 34 00 43 AC 2C 00 43 8C 04 00 63 24 0C 00 00 10 2C 00 43 AC ?? ?? 99 8F 18 00 A5 27 ?? ?? 39 27 ?? ?? ?? ?? 04 00 06 24 06 00 40 10 21 18 00 00 18 00 A2 8F A0 10 02 7C 02 14 22 00 00 00 02 AE 01 00 03 24 24 00 BF 8F 20 00 B0 8F 21 10 60 00 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_414_10_0 {
	meta:
		name = "flush_out"
		size = 144
	strings:
		$1 = { D8 FF BD 27 20 00 B1 AF 1C 00 B0 AF 24 00 BF AF 21 80 80 00 18 00 83 8C 10 00 84 8C 01 00 A5 38 00 80 02 3C 23 20 83 00 0B 10 05 00 FC FF 84 24 25 10 44 00 A0 10 02 7C 02 14 22 00 00 00 62 AC 0C 00 05 8E 10 00 11 8E 08 00 19 8E 00 00 04 8E 23 88 25 02 09 F8 20 03 21 30 20 02 06 00 51 14 21 18 00 00 0C 00 02 8E 01 00 03 24 18 00 02 AE 04 00 42 24 10 00 02 AE 24 00 BF 8F 20 00 B1 8F 1C 00 B0 8F 21 10 60 00 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_414_11_0 {
	meta:
		name = "xdrrec_putint32"
		size = 160
		refs = "0000 _gp_disp 0058 flush_out"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D8 FF BD 27 20 00 B1 AF 10 00 BC AF 24 00 BF AF 1C 00 B0 AF 0C 00 90 8C 10 00 02 8E 14 00 04 8E 04 00 43 24 10 00 03 AE 2B 18 83 00 0E 00 60 10 21 88 A0 00 ?? ?? 99 8F 10 00 02 AE 01 00 02 24 1C 00 02 AE 21 20 00 02 ?? ?? 39 27 ?? ?? ?? ?? 21 28 00 00 09 00 40 10 21 18 00 00 10 00 02 8E 04 00 43 24 10 00 03 AE 00 00 23 8E A0 18 03 7C 02 1C 23 00 00 00 43 AC 01 00 03 24 24 00 BF 8F 20 00 B1 8F 1C 00 B0 8F 21 10 60 00 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_414_12_0 {
	meta:
		name = "xdrrec_putbytes"
		size = 224
		refs = "0000 _gp_disp 0048 __GI_memcpy 00a0 flush_out"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 C8 FF BD 27 30 00 B5 AF 2C 00 B4 AF 28 00 B3 AF 20 00 B1 AF 10 00 BC AF 34 00 BF AF 24 00 B2 AF 1C 00 B0 AF 0C 00 90 8C ?? ?? 95 8F 21 98 A0 00 21 88 C0 00 01 00 14 24 1C 00 20 12 ?? ?? 99 8F 10 00 04 8E 14 00 12 8E 21 28 60 02 23 90 44 02 2B 10 51 02 0A 90 22 02 ?? ?? ?? ?? 21 30 40 02 10 00 02 8E 14 00 03 8E 10 00 BC 8F 21 10 52 00 10 00 02 AE 21 98 72 02 EF FF 43 14 23 88 32 02 0B 00 20 12 01 00 02 24 1C 00 14 AE 21 20 00 02 ?? ?? B9 26 ?? ?? ?? ?? 21 28 00 00 E6 FF 40 14 10 00 BC 8F 02 00 00 10 21 10 00 00 01 00 02 24 34 00 BF 8F 30 00 B5 8F 2C 00 B4 8F 28 00 B3 8F 24 00 B2 8F 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_414_13_0 {
	meta:
		name = "__GI_xdrrec_create"
		size = 412
		refs = "0054 malloc 00c0 __GI_fputs 00d0 free 0000 _gp_disp 00b0 stderr 00b4 $LC0"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F C0 FF BD 27 10 00 BC AF 3C 00 BF AF 38 00 B7 AF 34 00 B6 AF 30 00 B5 AF 2C 00 B4 AF 28 00 B3 AF 24 00 B2 AF 20 00 B1 AF 1C 00 B0 AF 21 A0 80 00 44 00 04 24 21 88 A0 00 21 90 C0 00 21 B8 E0 00 50 00 B6 8F ?? ?? ?? ?? 54 00 B5 8F 21 80 40 00 10 00 BC 8F A0 0F 03 24 64 00 22 2E 0B 88 62 00 64 00 44 2E FC FF 02 24 0B 90 64 00 03 00 31 26 24 98 22 02 ?? ?? 99 8F 03 00 52 26 24 90 42 02 04 00 64 26 ?? ?? ?? ?? 21 20 92 00 21 88 40 00 03 00 00 12 10 00 BC 8F 19 00 40 54 3C 00 13 AE ?? ?? 82 8F ?? ?? 84 8F ?? ?? 99 8F 00 00 45 8C ?? ?? ?? ?? ?? ?? 84 24 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 00 02 10 00 BC 8F 3C 00 BF 8F 38 00 B7 8F 34 00 B6 8F 30 00 B5 8F 2C 00 B4 8F 28 00 B3 8F 24 00 B2 8F 1C 00 B0 8F 21 20 20 02 ?? ?? 99 8F 20 00 B1 8F ?? ?? ?? ?? 40 00 BD 27 04 00 02 AE 21 98 53 00 0C 00 02 AE ?? ?? 82 8F 3C 00 BF 8F 28 00 13 AE ?? ?? 42 24 04 00 82 AE 18 00 11 AE 14 00 13 AE 04 00 31 26 21 98 72 02 01 00 02 24 40 00 12 AE 0C 00 90 AE 00 00 17 AE 20 00 16 AE 08 00 15 AE 10 00 11 AE 24 00 12 AE 30 00 13 AE 2C 00 13 AE 38 00 B7 8F 34 00 B6 8F 30 00 B5 8F 2C 00 B4 8F 28 00 B3 8F 24 00 B2 8F 20 00 B1 8F 1C 00 00 AE 34 00 00 AE 38 00 02 AE 1C 00 B0 8F 08 00 E0 03 40 00 BD 27 }
	condition:
		$1
}

rule file_414_14_0 {
	meta:
		name = "__GI_xdrrec_skiprecord"
		size = 164
		refs = "0040 skip_input_bytes 0064 set_input_fragment 0000 _gp_disp"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D8 FF BD 27 20 00 B2 AF 1C 00 B1 AF 10 00 BC AF 24 00 BF AF 18 00 B0 AF 0C 00 90 8C ?? ?? 91 8F ?? ?? 92 8F 34 00 05 8E 11 00 A0 58 38 00 02 8E ?? ?? 39 26 ?? ?? ?? ?? 21 20 00 02 03 00 40 54 38 00 02 8E 0E 00 00 10 21 10 00 00 F5 FF 40 14 34 00 00 AE ?? ?? 59 26 ?? ?? ?? ?? 21 20 00 02 F1 FF 40 54 34 00 05 8E 05 00 00 10 21 10 00 00 F0 FF 40 10 ?? ?? 39 26 38 00 00 AE 01 00 02 24 24 00 BF 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_414_15_0 {
	meta:
		name = "__GI_xdrrec_eof"
		size = 172
		refs = "0040 skip_input_bytes 0064 set_input_fragment 0000 _gp_disp"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D8 FF BD 27 20 00 B2 AF 1C 00 B1 AF 10 00 BC AF 24 00 BF AF 18 00 B0 AF 0C 00 90 8C ?? ?? 91 8F ?? ?? 92 8F 34 00 05 8E 11 00 A0 58 38 00 02 8E ?? ?? 39 26 ?? ?? ?? ?? 21 20 00 02 03 00 40 54 38 00 02 8E 10 00 00 10 01 00 02 24 F5 FF 40 14 34 00 00 AE ?? ?? 59 26 ?? ?? ?? ?? 21 20 00 02 F1 FF 40 54 34 00 05 8E 07 00 00 10 01 00 02 24 F0 FF 40 10 ?? ?? 39 26 2C 00 03 8E 30 00 02 8E 26 10 62 00 01 00 42 2C 24 00 BF 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_414_16_0 {
	meta:
		name = "__GI_xdrrec_endofrecord"
		size = 156
		refs = "0000 _gp_disp 0044 flush_out"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 0A 00 A0 14 0C 00 84 8C 1C 00 82 8C 08 00 40 14 ?? ?? 99 8F 10 00 82 8C 14 00 85 8C 04 00 43 24 2B 18 65 00 06 00 60 54 18 00 83 8C ?? ?? 99 8F 1C 00 80 AC ?? ?? 39 27 ?? ?? ?? ?? 01 00 05 24 00 80 05 3C 23 10 43 00 FC FF 42 24 25 28 45 00 02 32 02 00 02 3E 05 00 00 FF C6 30 00 FF 42 30 25 30 C7 00 00 12 02 00 25 10 C2 00 00 2E 05 00 25 28 45 00 00 00 65 AC 10 00 82 8C 18 00 82 AC 04 00 42 24 10 00 82 AC 08 00 E0 03 01 00 02 24 }
	condition:
		$1
}

rule file_415_0_0 {
	meta:
		name = "__GI_isupper"
		size = 40
		refs = "0000 _gp_disp 000c __GI___ctype_b"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F 40 20 04 00 00 00 42 8C 21 10 44 00 00 00 42 94 08 00 E0 03 01 00 42 30 }
	condition:
		$1
}

rule file_417_0_0 {
	meta:
		name = "sigisemptyset"
		size = 52
	strings:
		$1 = { 0C 00 82 8C 03 00 03 24 FF FF 05 24 07 00 40 14 FF FF 63 24 05 00 65 10 00 00 00 00 80 10 03 00 21 10 82 00 F9 FF 00 10 00 00 42 8C 08 00 E0 03 01 00 42 2C }
	condition:
		$1
}

rule file_418_0_0 {
	meta:
		name = "__parsegrent"
		size = 416
		refs = "0000 _gp_disp 0014 __GI_strchr 0070 __GI_strtoul 00b8 __GI___ctype_b"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D0 FF BD 27 28 00 B2 AF ?? ?? 92 8F 20 00 B0 AF 21 80 80 00 24 00 B1 AF 10 00 BC AF 21 20 A0 00 00 00 11 8E 2C 00 BF AF 00 00 05 AE 21 C8 40 02 ?? ?? ?? ?? 3A 00 05 24 03 00 40 14 01 00 44 24 4E 00 00 10 FF FF 02 24 00 00 40 A0 3A 00 05 24 21 C8 40 02 ?? ?? ?? ?? 04 00 04 AE F8 FF 40 10 10 00 BC 8F ?? ?? 99 8F 01 00 52 24 00 00 40 A0 21 20 40 02 18 00 A5 27 ?? ?? ?? ?? 0A 00 06 24 08 00 02 AE 18 00 A2 8F ED FF 52 10 10 00 BC 8F 00 00 44 80 3A 00 03 24 38 00 83 54 FF FF 02 24 01 00 43 80 1C 00 60 10 01 00 03 24 ?? ?? 86 8F 2C 00 03 24 00 00 43 A0 21 20 40 00 01 00 03 24 2C 00 05 24 00 00 47 80 10 00 E5 54 01 00 82 24 00 00 40 A0 01 00 44 24 01 00 42 80 D8 FF 40 10 01 00 63 24 25 00 45 50 FF FF 02 24 00 00 C7 8C 40 10 02 00 21 10 E2 00 00 00 42 94 20 00 42 30 1E 00 40 14 FF FF 02 24 01 00 82 24 01 00 84 80 EC FF 80 14 21 20 40 00 FC FF 04 24 04 00 42 24 24 10 44 00 80 20 03 00 21 20 44 00 2B 88 24 02 C3 FF 20 16 FF FF 64 24 0E 00 80 10 0C 00 02 AE 18 00 A3 8F 21 28 40 00 01 00 63 24 FF FF 84 24 04 00 42 24 07 00 80 10 00 00 A3 AC 01 00 63 24 00 00 65 80 FE FF A0 54 01 00 63 24 F6 FF 00 10 21 28 40 00 00 00 40 AC 21 10 00 00 2C 00 BF 8F 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_419_0_0 {
	meta:
		name = "__GI_fclose"
		size = 448
		refs = "0000 _gp_disp 0034 _pthread_cleanup_push_defer 0038 __pthread_mutex_unlock 0050 __pthread_mutex_lock 0070 __GI_fflush_unlocked 0084 __GI_close 00a4 _stdio_openlist_del_lock 00dc _stdio_openlist_use_count 00e0 _pthread_cleanup_pop_restore 0134 free 0178 _stdio_openlist_del_count 0194 _stdio_openlist_dec_use"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 B0 FF BD 27 3C 00 B0 AF 10 00 BC AF 4C 00 BF AF 48 00 B3 AF 44 00 B2 AF 40 00 B1 AF 34 00 93 8C 0C 00 60 16 21 80 80 00 ?? ?? 99 8F ?? ?? 85 8F 38 00 91 24 21 30 20 02 ?? ?? ?? ?? 28 00 A4 27 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 20 02 10 00 BC 8F 00 00 02 96 40 00 42 30 06 00 40 10 21 88 00 00 ?? ?? 99 8F ?? ?? ?? ?? 21 20 00 02 10 00 BC 8F 21 88 40 00 ?? ?? 99 8F 04 00 04 8E ?? ?? ?? ?? 18 00 B2 27 10 00 BC 8F FF FF 03 24 00 00 42 28 ?? ?? 85 8F ?? ?? 86 8F ?? ?? 99 8F 04 00 03 AE 21 20 40 02 ?? ?? ?? ?? 0B 88 62 00 10 00 BC 8F ?? ?? 84 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F 21 20 40 02 01 00 05 24 ?? ?? 82 8F ?? ?? 99 8F 00 00 43 8C 01 00 63 24 00 00 43 AC ?? ?? ?? ?? 00 00 00 00 00 00 02 96 10 00 BC 8F 00 60 42 30 30 00 42 34 06 00 60 16 00 00 02 A6 ?? ?? 99 8F 28 00 A4 27 ?? ?? ?? ?? 01 00 05 24 10 00 BC 8F 00 00 02 96 00 40 42 30 06 00 40 10 ?? ?? 86 8F ?? ?? 99 8F ?? ?? ?? ?? 08 00 04 8E 10 00 BC 8F ?? ?? 86 8F ?? ?? 85 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 40 02 10 00 BC 8F ?? ?? 84 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F 21 20 40 02 01 00 05 24 ?? ?? 82 8F ?? ?? 99 8F 00 00 43 8C 01 00 63 24 ?? ?? ?? ?? 00 00 43 AC 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 4C 00 BF 8F 21 10 20 02 48 00 B3 8F 44 00 B2 8F 40 00 B1 8F 3C 00 B0 8F 08 00 E0 03 50 00 BD 27 }
	condition:
		$1
}

rule file_420_0_0 {
	meta:
		name = "shmget"
		size = 76
		refs = "0000 _gp_disp 000c __syscall_ipc"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F D8 FF BD 27 21 18 80 00 21 10 A0 00 21 38 C0 00 24 00 BF AF 18 00 BC AF 10 00 A0 AF 14 00 A0 AF 17 00 04 24 21 28 60 00 ?? ?? ?? ?? 21 30 40 00 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_421_0_0 {
	meta:
		name = "__GI_stat64"
		size = 120
		refs = "0000 _gp_disp 0034 __GI___errno_location 0054 __xstat64_conv"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 78 FF BD 27 10 00 BC AF 21 30 A0 00 84 00 BF AF 80 00 B0 AF 18 00 A5 27 75 10 02 24 0C 00 00 00 07 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC 07 00 00 10 FF FF 10 24 06 00 40 14 84 00 BF 8F ?? ?? 99 8F 18 00 A4 27 ?? ?? ?? ?? 21 28 C0 00 84 00 BF 8F 21 10 00 02 80 00 B0 8F 08 00 E0 03 88 00 BD 27 }
	condition:
		$1
}

rule file_423_0_0 {
	meta:
		name = "__syscall_mmap2"
		size = 108
		refs = "0000 _gp_disp 0044 __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 18 00 B0 AF 1C 00 BF AF 34 00 B0 8F 30 00 A2 8F E0 FF BD 27 10 00 A2 AF 14 00 B0 AF 72 10 02 24 0C 00 00 00 20 00 BD 27 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_423_1_0 {
	meta:
		name = "mmap64"
		size = 100
		refs = "0000 _gp_disp 0024 __GI___errno_location 003c __syscall_mmap2"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 38 00 A2 8F 10 00 BC AF 1C 00 BF AF FF 0F 48 30 08 00 00 15 ?? ?? 99 8F ?? ?? 99 8F 1C 00 BF 8F 02 13 02 00 34 00 A2 AF ?? ?? 39 27 ?? ?? ?? ?? 20 00 BD 27 ?? ?? ?? ?? 00 00 00 00 16 00 03 24 00 00 43 AC 1C 00 BF 8F FF FF 02 24 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_425_0_0 {
	meta:
		name = "__GI_getcwd"
		size = 304
		refs = "0000 _gp_disp 0038 __GI_getpagesize 003c __GI___errno_location 0078 malloc 00d8 realloc 0100 free"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D0 FF BD 27 10 00 BC AF 28 00 B3 AF 1C 00 B0 AF 2C 00 BF AF 24 00 B2 AF 20 00 B1 AF 21 80 80 00 0F 00 A0 14 21 98 A0 00 07 00 80 10 ?? ?? 99 8F ?? ?? 99 8F ?? ?? ?? ?? 21 88 00 00 16 00 03 24 30 00 00 10 00 00 43 AC ?? ?? ?? ?? 00 10 12 24 00 10 43 28 10 00 BC 8F 04 00 00 10 0A 90 43 00 21 90 A0 00 07 00 80 14 21 88 80 00 ?? ?? 99 8F ?? ?? ?? ?? 21 20 40 02 21 88 40 00 20 00 40 10 10 00 BC 8F 21 20 20 02 21 28 40 02 6B 10 02 24 0C 00 00 00 07 00 E0 10 21 90 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F 0F 00 00 10 00 00 52 AC 0D 00 40 04 00 00 00 00 11 00 00 56 21 88 00 02 10 00 60 16 2C 00 BF 8F ?? ?? 99 8F 21 20 20 02 ?? ?? ?? ?? 21 28 40 00 09 00 40 10 21 80 40 00 07 00 00 10 21 88 00 02 05 00 00 56 21 88 00 00 ?? ?? 99 8F ?? ?? ?? ?? 21 20 20 02 21 88 00 00 2C 00 BF 8F 21 10 20 02 28 00 B3 8F 24 00 B2 8F 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_426_0_0 {
	meta:
		name = "_stdio_openlist_dec_use"
		size = 388
		refs = "0000 _gp_disp 0010 _pthread_cleanup_push_defer 0014 __pthread_mutex_unlock 0018 _stdio_openlist_del_lock 005c __pthread_mutex_lock 0070 _stdio_openlist_use_count 007c _stdio_openlist_del_count 0094 _stdio_openlist_add_lock 00c4 _stdio_openlist 00d4 _pthread_cleanup_pop_restore 0104 free"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 A0 FF BD 27 ?? ?? 99 8F ?? ?? 85 8F ?? ?? 86 8F 40 00 B2 AF 28 00 B2 27 10 00 BC AF 5C 00 BF AF 44 00 B3 AF 58 00 BE AF 54 00 B7 AF 50 00 B6 AF 4C 00 B5 AF 48 00 B4 AF 3C 00 B1 AF 38 00 B0 AF ?? ?? ?? ?? 21 20 40 02 10 00 BC 8F ?? ?? 84 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F 01 00 02 24 ?? ?? 93 8F 00 00 63 8E 2F 00 62 14 ?? ?? 82 8F 00 00 43 8C 2C 00 60 18 21 A8 40 00 ?? ?? 99 8F ?? ?? 85 8F ?? ?? 86 8F 18 00 B4 27 ?? ?? ?? ?? 21 20 80 02 10 00 BC 8F 21 80 00 00 30 80 17 24 ?? ?? 84 8F ?? ?? 99 8F ?? ?? ?? ?? 30 00 1E 24 10 00 BC 8F ?? ?? 83 8F 00 00 64 8C 21 B0 60 00 14 00 80 10 ?? ?? 99 8F 00 00 83 94 24 18 77 00 0D 00 7E 14 20 00 91 8C 02 00 00 56 20 00 11 AE 00 00 D1 AE 00 00 83 94 00 20 63 30 F4 FF 60 50 21 20 20 02 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 02 00 00 10 10 00 BC 8F 21 80 80 00 EC FF 00 10 21 20 20 02 21 20 80 02 ?? ?? ?? ?? 01 00 05 24 10 00 BC 8F 00 00 A0 AE 00 00 62 8E ?? ?? 99 8F 21 20 40 02 FF FF 42 24 00 00 62 AE ?? ?? ?? ?? 01 00 05 24 5C 00 BF 8F 58 00 BE 8F 54 00 B7 8F 50 00 B6 8F 4C 00 B5 8F 48 00 B4 8F 44 00 B3 8F 40 00 B2 8F 3C 00 B1 8F 38 00 B0 8F 08 00 E0 03 60 00 BD 27 }
	condition:
		$1
}

rule file_426_1_0 {
	meta:
		name = "__GI_fflush_unlocked"
		size = 576
		refs = "0000 _gp_disp 0014 _stdio_openlist 0054 _stdio_openlist_del_lock 0060 __pthread_mutex_unlock 0064 _pthread_cleanup_push_defer 007c __pthread_mutex_lock 0098 _stdio_openlist_use_count 009c _pthread_cleanup_pop_restore 00bc _stdio_openlist_add_lock 0100 _stdio_user_locking 0104 __stdio_wcommit 010c _stdio_openlist_dec_use"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 B0 FF BD 27 30 00 B2 AF ?? ?? 92 8F 10 00 BC AF 28 00 B0 AF 4C 00 BF AF 48 00 BE AF 44 00 B7 AF 40 00 B6 AF 3C 00 B5 AF 38 00 B4 AF 34 00 B3 AF 2C 00 B1 AF 05 00 92 10 21 80 80 00 62 00 80 14 00 01 13 24 03 00 00 10 ?? ?? 86 8F 21 98 00 00 ?? ?? 86 8F ?? ?? 85 8F ?? ?? 99 8F 18 00 B1 27 ?? ?? ?? ?? 21 20 20 02 10 00 BC 8F 02 00 14 24 ?? ?? 99 8F ?? ?? 84 8F ?? ?? ?? ?? BF FF 1E 24 10 00 BC 8F 21 20 20 02 01 00 05 24 ?? ?? 82 8F ?? ?? 99 8F 00 00 43 8C 01 00 63 24 00 00 43 AC ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F ?? ?? 85 8F ?? ?? 86 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 20 02 10 00 BC 8F ?? ?? 84 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F 21 20 20 02 01 00 05 24 ?? ?? 99 8F 00 00 50 8E ?? ?? ?? ?? 21 90 00 00 10 00 BC 8F ?? ?? 96 8F ?? ?? 97 8F 2E 00 00 12 ?? ?? 99 8F 00 00 02 96 40 00 42 30 FB FF 40 50 20 00 10 8E 00 00 C2 8E 0B 00 54 10 ?? ?? 99 8F ?? ?? 85 8F 38 00 15 26 21 20 20 02 ?? ?? ?? ?? 21 30 A0 02 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 A0 02 10 00 BC 8F 00 00 02 96 25 10 62 02 40 01 42 38 40 03 42 30 0E 00 40 14 ?? ?? 82 8F 21 C8 E0 02 ?? ?? ?? ?? 21 20 00 02 07 00 40 14 10 00 BC 8F 08 00 02 8E 1C 00 02 AE 00 00 02 96 24 10 5E 00 02 00 00 10 00 00 02 A6 FF FF 12 24 ?? ?? 82 8F 00 00 42 8C 05 00 54 10 ?? ?? 99 8F 21 20 20 02 ?? ?? ?? ?? 01 00 05 24 10 00 BC 8F D2 FF 00 10 20 00 10 8E ?? ?? ?? ?? 00 00 00 00 10 00 00 10 4C 00 BF 8F 00 00 82 94 40 00 42 30 0B 00 40 10 21 90 00 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 06 00 40 54 FF FF 12 24 08 00 02 8E 1C 00 02 AE 00 00 02 96 BF FF 42 30 00 00 02 A6 4C 00 BF 8F 21 10 40 02 48 00 BE 8F 44 00 B7 8F 40 00 B6 8F 3C 00 B5 8F 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 E0 03 50 00 BD 27 }
	condition:
		$1
}

rule file_427_0_0 {
	meta:
		name = "__GI_open"
		size = 120
		refs = "0000 _gp_disp 0050 __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D8 FF BD 27 00 01 A3 30 10 00 BC AF 24 00 BF AF 20 00 B0 AF 30 00 A6 AF 34 00 A7 AF 04 00 60 10 21 10 00 00 30 00 A2 27 18 00 A2 AF 21 10 C0 00 21 30 40 00 A5 0F 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 24 00 BF 8F 21 10 00 02 20 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_428_0_0 {
	meta:
		name = "__GI_isatty"
		size = 52
		refs = "0000 _gp_disp 000c __GI_tcgetattr"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F A8 FF BD 27 54 00 BF AF 10 00 BC AF ?? ?? ?? ?? 18 00 A5 27 54 00 BF 8F 01 00 42 2C 08 00 E0 03 58 00 BD 27 }
	condition:
		$1
}

rule file_429_0_0 {
	meta:
		name = "__GI_wcschrnul"
		size = 36
	strings:
		$1 = { FC FF 82 24 04 00 42 24 00 00 43 8C 03 00 60 10 00 00 00 00 FC FF 65 54 04 00 42 24 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_430_0_0 {
	meta:
		name = "byte_insert_op1"
		size = 48
	strings:
		$1 = { 03 00 E2 24 05 00 E5 10 FF FF 42 24 FF FF E7 24 00 00 E3 90 FB FF 00 10 00 00 43 A0 01 00 E6 A0 03 32 06 00 00 00 E4 A0 08 00 E0 03 02 00 E6 A0 }
	condition:
		$1
}

rule file_430_1_0 {
	meta:
		name = "byte_compile_range"
		size = 216
	strings:
		$1 = { 00 00 A3 8C 0F 00 66 10 14 00 A8 8F 01 00 62 24 00 00 A2 AC 10 00 A2 8F 0B 00 05 24 00 04 42 7C 0A 28 02 00 09 00 E0 10 21 10 A0 00 00 00 63 90 FF 00 84 30 21 20 E4 00 00 00 84 80 03 00 00 10 21 18 E3 00 08 00 E0 03 0B 00 02 24 00 00 63 90 01 00 05 24 2B 30 64 00 1D 00 C0 14 00 00 00 00 04 00 E0 10 21 10 E4 00 00 00 42 90 02 00 00 10 C3 10 02 00 C3 10 04 00 05 00 E0 10 21 30 02 01 21 10 E4 00 00 00 42 90 02 00 00 10 C3 10 02 00 C3 10 04 00 21 10 02 01 05 00 E0 10 00 00 49 80 21 10 E4 00 00 00 42 90 02 00 00 10 07 00 42 30 07 00 82 30 04 10 45 00 20 14 02 7C 25 10 49 00 00 00 C2 A0 01 00 84 24 E2 FF 00 10 21 10 00 00 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_430_2_0 {
	meta:
		name = "byte_common_op_match_null_string_p"
		size = 392
		refs = "0000 _gp_disp 00b8 byte_group_match_null_string_p"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D0 FF BD 27 20 00 B0 AF 10 00 BC AF 2C 00 BF AF 28 00 B2 AF 24 00 B1 AF 00 00 82 8C 21 80 80 00 01 00 44 24 18 00 A4 AF 00 00 43 90 0D 00 67 2C 0B 00 E0 50 15 00 05 24 09 00 64 2C 46 00 80 10 06 00 04 24 16 00 64 10 21 88 C0 00 08 00 04 24 3C 00 64 50 01 00 46 90 0D 00 00 10 00 00 00 00 29 00 65 50 03 00 43 24 16 00 64 2C 05 00 80 10 0D 00 04 24 1D 00 64 50 02 00 43 80 39 00 00 10 21 10 00 00 E6 FF 63 24 03 00 02 24 2B 18 43 00 34 00 60 54 21 10 00 00 30 00 00 10 18 00 A2 8F ?? ?? 99 8F 01 00 52 90 ?? ?? 39 27 ?? ?? ?? ?? 18 00 A4 27 80 30 12 00 21 30 26 02 00 00 C4 8C 03 00 03 24 03 00 84 30 04 00 83 14 00 00 00 00 00 00 C3 90 04 08 43 7C 00 00 C3 A0 1F 00 40 54 18 00 A2 8F 1F 00 00 10 21 10 00 00 01 00 44 90 00 1A 03 00 21 18 83 00 0F 00 61 04 03 00 42 24 18 00 00 10 21 10 00 00 18 00 A3 AF 04 00 45 80 03 00 46 90 00 2A 05 00 21 28 C5 00 11 00 A0 54 21 10 00 00 18 00 A4 AF 01 00 44 90 02 00 42 80 00 12 02 00 21 10 82 00 21 18 62 00 06 00 00 10 18 00 A3 AF 80 30 06 00 21 88 26 02 00 00 22 8E E2 FF 00 10 03 00 42 30 18 00 A2 8F 00 00 02 AE 01 00 02 24 2C 00 BF 8F 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_430_3_0 {
	meta:
		name = "byte_group_match_null_string_p"
		size = 456
		refs = "0000 _gp_disp 00d4 byte_alt_match_null_string_p 0180 byte_common_op_match_null_string_p"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 B0 FF BD 27 44 00 B7 AF 40 00 B6 AF 38 00 B4 AF 34 00 B3 AF 30 00 B2 AF 2C 00 B1 AF 28 00 B0 AF 10 00 BC AF 4C 00 BF AF 48 00 BE AF 3C 00 B5 AF 00 00 82 8C ?? ?? 96 8F ?? ?? 97 8F 02 00 42 24 18 00 A2 AF 18 00 A2 27 21 90 80 00 21 88 A0 00 21 80 C0 00 07 00 14 24 0F 00 13 24 20 00 A2 AF 18 00 A2 8F 2B 18 51 00 48 00 60 50 21 10 00 00 00 00 43 90 3A 00 74 50 02 00 42 24 3B 00 73 14 18 00 A4 27 01 00 43 24 18 00 A3 AF 02 00 5E 80 01 00 43 90 03 00 42 24 00 F2 1E 00 21 F0 7E 00 18 00 A2 AF EE FF C0 07 0E 00 15 24 18 00 A4 8F FD FF C5 27 21 28 85 00 00 00 A2 90 1A 00 55 14 ?? ?? F9 26 24 00 B9 AF ?? ?? ?? ?? 21 30 00 02 03 00 40 14 24 00 B9 8F 2C 00 00 10 21 10 00 00 18 00 A2 8F 21 10 5E 00 18 00 A2 AF 00 00 44 90 0D 00 93 14 01 00 44 24 18 00 A4 AF 02 00 5E 80 01 00 44 90 00 F2 1E 00 21 F0 9E 00 03 00 44 24 18 00 A4 AF 21 20 9E 00 FD FF 84 90 E4 FF 95 10 18 00 A4 8F 18 00 A2 AF 18 00 A4 8F 21 30 00 02 FF FF 9E 80 FE FF 82 90 00 F2 1E 00 21 F0 5E 00 09 F8 20 03 21 28 9E 00 10 00 40 10 21 10 00 00 18 00 A2 8F 21 F0 5E 00 C1 FF 00 10 18 00 BE AF 00 00 42 AE 09 00 00 10 01 00 02 24 21 28 20 02 ?? ?? D9 26 ?? ?? ?? ?? 21 30 00 02 B9 FF 40 54 18 00 A2 8F 01 00 00 10 21 10 00 00 4C 00 BF 8F 48 00 BE 8F 44 00 B7 8F 40 00 B6 8F 3C 00 B5 8F 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 E0 03 50 00 BD 27 }
	condition:
		$1
}

rule file_430_4_0 {
	meta:
		name = "byte_alt_match_null_string_p"
		size = 196
		refs = "0000 _gp_disp 0090 byte_common_op_match_null_string_p"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 C8 FF BD 27 30 00 B4 AF ?? ?? 94 8F 2C 00 B3 AF 28 00 B2 AF 24 00 B1 AF 20 00 B0 AF 10 00 BC AF 34 00 BF AF 21 80 A0 00 21 90 C0 00 18 00 A4 AF 0F 00 13 24 18 00 B1 27 18 00 A2 8F 2B 18 50 00 15 00 60 50 01 00 02 24 00 00 43 90 0A 00 73 14 01 00 43 24 18 00 A3 AF 01 00 44 90 03 00 43 24 02 00 42 80 00 12 02 00 21 10 82 00 21 10 62 00 F1 FF 00 10 18 00 A2 AF 21 20 20 02 21 28 00 02 ?? ?? 99 26 ?? ?? ?? ?? 21 30 40 02 EB FF 40 54 18 00 A2 8F 21 10 00 00 34 00 BF 8F 30 00 B4 8F 2C 00 B3 8F 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_430_5_0 {
	meta:
		name = "byte_re_compile_fastmap"
		size = 1136
		refs = "0000 _gp_disp 0040 __GI_memset 0080 re_max_failures 0374 __GI_memcpy 0424 __GI_abort"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 A8 FF BD 27 50 00 BE AF 4C 00 B7 AF 40 00 B4 AF 3C 00 B3 AF 38 00 B2 AF 10 00 BC AF 54 00 BF AF 48 00 B6 AF 44 00 B5 AF 34 00 B1 AF 30 00 B0 AF 10 00 95 8C ?? ?? 99 8F 21 F0 A0 03 21 98 80 00 00 00 91 8C 08 00 96 8C E0 FF BD 27 21 28 00 00 21 20 A0 02 ?? ?? ?? ?? 00 01 06 24 10 00 DC 8F 1C 00 62 92 01 00 03 24 ?? ?? 88 8F C4 18 62 7C ?? ?? 83 8F ?? ?? 89 8F 04 00 02 7C 21 B0 36 02 10 00 B7 27 1C 00 62 A2 21 90 00 00 05 00 05 24 01 00 14 24 ?? ?? 08 25 ?? ?? 63 24 04 00 36 12 01 00 04 24 00 00 22 92 0F 00 44 14 1E 00 44 2C 1C 00 64 8E 1C 00 62 92 00 00 84 7C 25 A0 84 02 04 00 82 7E D7 00 40 12 1C 00 62 A2 FF FF 52 26 80 10 12 00 21 10 E2 02 00 00 50 8C 01 00 14 24 EE FF 00 10 21 88 00 02 CB 00 80 10 01 00 30 26 80 10 02 00 21 10 02 01 00 00 42 8C 21 10 5C 00 08 00 40 00 00 00 00 00 1C 00 62 92 01 00 03 24 04 00 62 7C C3 00 00 10 1C 00 62 A2 02 00 22 92 01 00 04 24 21 10 A2 02 5A 00 00 10 00 00 44 A0 01 00 22 92 02 00 26 26 FF FF 04 24 C0 10 02 00 FF FF 42 24 01 00 07 24 53 00 44 10 21 80 C0 02 C3 50 02 00 21 50 CA 00 00 00 4B 91 07 00 4A 30 07 50 4B 01 01 00 4A 31 F7 FF 40 51 FF FF 42 24 21 50 A2 02 00 00 47 A1 F3 FF 00 10 FF FF 42 24 01 00 22 92 01 00 06 24 C0 10 02 00 00 01 44 28 04 00 80 10 21 20 A2 02 00 00 86 A0 FB FF 00 10 01 00 42 24 01 00 22 92 02 00 26 26 FF FF 04 24 C0 10 02 00 FF FF 42 24 01 00 07 24 36 00 44 10 21 80 C0 02 C3 50 02 00 21 50 CA 00 00 00 4B 91 07 00 4A 30 07 50 4B 01 01 00 4A 31 F7 FF 40 55 FF FF 42 24 21 50 A2 02 00 00 47 A1 F3 FF 00 10 FF FF 42 24 21 10 00 00 01 00 04 24 00 01 06 24 21 38 43 00 00 00 E7 80 04 00 E4 54 01 00 42 24 21 38 A2 02 00 00 E4 A0 01 00 42 24 F9 FF 46 54 21 38 43 00 1C 00 00 10 21 80 C0 02 21 10 00 00 01 00 04 24 00 01 06 24 21 38 43 00 00 00 E7 80 02 00 E4 10 21 38 A2 02 00 00 E4 A0 01 00 42 24 FA FF 46 54 21 38 43 00 0F 00 00 10 21 80 C0 02 0A 00 A4 82 21 10 00 00 01 00 0A 24 00 01 06 24 21 38 A2 02 01 00 42 24 FD FF 46 14 00 00 EA A0 0C 00 62 8E 40 00 42 30 05 00 40 54 1C 00 62 8E 0A 00 A4 A2 21 80 C0 02 91 FF 00 10 21 A0 00 00 01 00 42 30 FC FF 40 10 21 80 C0 02 60 00 00 10 21 10 00 00 02 00 22 82 01 00 24 92 03 00 30 26 00 12 02 00 21 10 82 00 85 FF 40 1C 21 80 02 02 00 00 02 92 0F 00 04 24 03 00 44 10 15 00 04 24 6E FF 44 14 21 88 00 02 01 00 04 92 03 00 02 26 02 00 10 82 00 82 10 00 21 80 90 00 78 FF 40 12 21 80 50 00 80 10 12 00 21 10 E2 02 FC FF 42 8C 26 10 50 00 01 00 42 2C 71 FF 00 10 23 90 42 02 21 88 00 00 01 00 0A 82 00 00 02 92 02 00 07 26 00 52 0A 00 21 50 4A 00 21 50 EA 00 2B 10 56 01 23 00 40 50 1C 00 62 92 1D 00 45 16 80 10 12 00 00 00 22 8D 13 00 04 24 02 10 82 70 2B 10 52 00 32 00 40 14 C0 10 12 00 ?? ?? 99 8F 08 00 42 24 23 E8 A2 03 21 28 E0 02 28 00 C3 AF 18 00 C7 AF 20 00 C8 AF 24 00 C9 AF 1C 00 CA AF 10 00 A4 27 ?? ?? ?? ?? 80 30 12 00 21 B8 40 00 10 00 DC 8F 28 00 C3 8F 18 00 C7 8F 20 00 C8 8F 24 00 C9 8F 1E 00 40 10 1C 00 CA 8F 40 28 12 00 80 10 12 00 21 10 E2 02 00 00 4A AC 04 00 00 10 01 00 52 26 01 00 04 24 04 00 82 7C 1C 00 62 A2 04 00 10 26 3F FF 00 10 0A 80 F1 00 04 00 22 82 03 00 24 92 00 12 02 00 21 10 82 00 39 FF 40 54 05 00 30 26 C8 FF 00 10 01 00 11 24 35 FF 00 10 05 00 30 26 33 FF 00 10 03 00 30 26 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 02 00 00 10 21 10 00 00 FE FF 02 24 21 E8 C0 03 54 00 BF 8F 50 00 BE 8F 4C 00 B7 8F 48 00 B6 8F 44 00 B5 8F 40 00 B4 8F 3C 00 B3 8F 38 00 B2 8F 34 00 B1 8F 30 00 B0 8F 08 00 E0 03 58 00 BD 27 }
	condition:
		$1
}

rule file_430_6_0 {
	meta:
		name = "byte_re_match_2_internal"
		size = 7724
		refs = "0000 _gp_disp 0438 malloc 04d0 realloc 092c byte_group_match_null_string_p 0bec re_max_failures 0c70 __GI_memcpy 0eb8 __GI_memcmp 1c9c __GI_abort"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 40 FF BD 27 B8 00 BE AF A8 00 B4 AF 9C 00 B1 AF BC 00 BF AF B4 00 B7 AF B0 00 B6 AF AC 00 B5 AF A4 00 B3 AF A0 00 B2 AF 98 00 B0 AF 10 00 BC AF 18 00 88 8C 00 00 8C 8C 08 00 82 8C 14 00 83 8C 21 F0 A0 03 21 10 82 01 01 00 0A 25 E0 FF BD 27 C4 00 C5 AF 21 88 E0 00 C0 00 C4 AF 21 48 C0 00 D8 00 C7 8F DC 00 C5 8F 34 00 C2 AF 28 00 C3 AF 4C 00 C8 AF 38 00 CA AF 20 00 00 11 10 00 B4 27 80 10 0A 00 0E 00 42 24 C2 10 02 00 C0 10 02 00 23 E8 A2 03 10 00 AB 27 23 E8 A2 03 10 00 AD 27 23 E8 A2 03 10 00 AE 27 23 E8 A2 03 10 00 B9 27 23 E8 A2 03 10 00 A3 27 23 E8 A2 03 10 00 A8 27 23 E8 A2 03 54 00 C8 AF 10 00 A8 27 23 E8 A2 03 10 00 AA 27 23 E8 A2 03 20 00 CB AF 10 00 AB 27 24 00 CD AF 40 00 CE AF 44 00 D9 AF 50 00 C3 AF 5C 00 CA AF 0A 00 00 10 60 00 CB AF 60 00 C0 AF 5C 00 C0 AF 54 00 C0 AF 50 00 C0 AF 21 40 00 00 44 00 C0 AF 40 00 C0 AF 24 00 C0 AF 20 00 C0 AF D4 00 CD 8F 03 00 A1 05 D0 00 CE 8F 2F 07 00 10 FF FF 02 24 D4 00 D9 8F 21 10 2E 01 2A 10 59 00 FA FF 40 14 ?? ?? 84 8F 01 00 03 24 03 00 0A 24 ?? ?? 84 24 38 00 CB 8F 2B 10 6B 00 16 00 40 10 44 00 CB 8F 40 00 CD 8F 80 10 03 00 24 00 CE 8F 21 30 62 01 20 00 D9 8F 00 00 C4 AC 21 30 A2 01 00 00 C4 AC 21 30 C2 01 00 00 C4 AC 21 30 22 03 00 00 C4 AC 21 10 02 01 00 00 46 90 01 00 63 24 04 08 46 7D 84 10 06 7C C4 18 06 7C 04 21 06 7C E8 FF 00 10 00 00 46 A0 D0 00 CD 8F 0A 00 A0 15 D0 00 CA 8F C4 00 CE 8F 03 00 C0 55 D0 00 C9 AF 04 00 00 10 D0 00 CE AF C4 00 D1 8F 21 48 00 00 C4 00 C0 AF D0 00 CA 8F C4 00 D9 8F 2A 10 25 01 21 50 2A 02 21 18 29 03 05 00 40 14 3C 00 CA AF 21 28 25 03 2C 00 C5 AF 04 00 00 10 21 78 20 02 23 28 A9 00 21 78 25 02 2C 00 C3 AF 08 00 20 19 D4 00 CB 8F 2A 10 2B 01 06 00 40 14 D4 00 CE 8F C4 00 CD 8F 2C 00 D8 8F 05 00 00 10 21 80 AB 01 D4 00 CE 8F 21 C0 E0 01 23 80 C9 01 21 80 30 02 21 90 00 00 05 00 17 24 21 50 00 00 30 00 C0 AF 48 00 C0 AF 00 01 16 24 01 01 15 24 58 00 C0 AF 34 00 D9 8F FF 00 99 55 00 00 86 91 50 00 0F 12 00 00 00 00 08 00 20 11 21 20 00 00 C4 00 CA 8F 30 00 CB 8F 2B 10 6A 01 04 00 40 14 2C 00 CC 8F 2B 20 6B 00 01 00 84 38 2C 00 CC 8F 30 00 CD 8F 26 28 0C 03 2B 30 05 00 2B 10 B0 01 26 20 C4 00 1D 00 40 12 0A 10 C4 00 48 00 CE 8F 04 00 C0 51 01 00 02 24 A3 02 40 10 21 20 00 02 01 00 02 24 38 00 CD 8F 2B 20 4D 00 0F 00 80 10 20 00 D9 8F 80 20 02 00 50 00 CA 8F 21 28 24 03 00 00 A6 8C 24 00 CB 8F 21 28 44 01 00 00 A6 AC 54 00 CC 8F 21 28 64 01 00 00 A5 8C 21 20 84 01 01 00 42 24 EF FF 00 10 00 00 85 AC 01 00 0E 24 30 00 D0 AF 8B 02 00 10 48 00 CE AF 48 00 D9 8F 20 00 20 13 00 00 00 00 1E 00 40 14 00 00 00 00 30 00 D0 8F 30 00 C8 8F C4 00 CA 8F 2B 10 0A 01 05 00 40 14 01 00 02 24 2C 00 CB 8F 2B 10 68 00 0A 78 62 01 01 00 02 24 38 00 C8 8F 2B 20 48 00 0F 00 80 10 50 00 CC 8F 80 20 02 00 20 00 CD 8F 21 28 84 01 00 00 A6 8C 54 00 CE 8F 21 28 A4 01 00 00 A6 AC 24 00 D9 8F 21 28 C4 01 00 00 A5 8C 21 20 24 03 01 00 42 24 EF FF 00 10 00 00 85 AC 21 C0 E0 01 0A 00 E0 14 C0 00 CD 8F 2C 00 CB 8F D4 00 CA 8F C4 00 CC 8F 26 10 0B 03 23 88 29 02 23 80 0A 02 0A 88 82 01 81 06 00 10 23 10 11 02 1C 00 A2 8D 10 00 44 30 F5 FF 80 14 2C 00 CB 8F 06 00 42 30 22 00 40 14 02 00 04 24 4C 00 CE 8F ?? ?? 99 8F 02 00 D3 25 00 00 F3 AC 80 98 13 00 88 00 C3 AF 8C 00 C9 AF 84 00 D8 AF 21 20 60 02 ?? ?? ?? ?? 90 00 C7 AF 10 00 DC 8F 90 00 C7 8F 21 20 60 02 ?? ?? 99 8F 04 00 E2 AC 90 00 C7 AF ?? ?? ?? ?? 21 90 40 00 90 00 C7 8F 10 00 DC 8F 08 00 E2 AC 88 00 C3 8F 8C 00 C9 8F 5F 06 40 12 84 00 D8 8F 5D 06 40 10 C0 00 D9 8F 01 00 04 24 1C 00 22 93 44 10 82 7C 24 00 00 10 1C 00 22 A3 23 00 44 14 00 00 E2 8C 4C 00 C8 8F 02 00 05 25 2B 10 45 00 1E 00 40 50 00 00 E2 8C 04 00 E4 8C ?? ?? 99 8F 00 00 E5 AC 88 00 C3 AF 8C 00 C9 AF 84 00 D8 AF 80 28 05 00 ?? ?? ?? ?? 90 00 C7 AF 90 00 C7 8F 10 00 DC 8F 00 00 E5 8C 08 00 E4 8C ?? ?? 99 8F 04 00 E2 AC 80 28 05 00 ?? ?? ?? ?? 90 00 C7 AF 90 00 C7 8F 10 00 DC 8F 04 00 E4 8C 08 00 E2 AC 88 00 C3 8F 8C 00 C9 8F 37 06 80 10 84 00 D8 8F 36 06 40 10 FE FF 02 24 00 00 E2 8C 0E 00 40 10 ?? ?? 86 8F 04 00 E2 8C D4 00 CA 8F 2C 00 CB 8F 00 00 4A AC 04 00 0B 17 08 00 E4 8C C4 00 CC 8F 03 00 00 10 23 10 0C 02 23 10 11 02 21 10 49 00 00 00 82 AC ?? ?? 86 8F 01 00 05 24 FF FF 0A 24 ?? ?? C6 24 00 00 E2 8C 38 00 CB 8F 2B 20 4B 00 0A 10 64 01 2B 10 A2 00 30 00 40 10 20 00 CD 8F 80 10 05 00 04 00 EC 8C 21 20 A2 01 00 00 84 8C 06 00 86 10 21 60 82 01 24 00 CE 8F 21 58 C2 01 00 00 6D 8D 06 00 A6 15 00 00 00 00 08 00 E4 8C 21 10 82 00 00 00 4A AC 1E 00 00 10 00 00 8A AD 0A 00 20 51 23 20 91 00 C4 00 D9 8F 2B 68 99 00 06 00 A0 55 23 20 91 00 2B 68 64 00 03 00 A0 55 23 20 91 00 02 00 00 10 23 20 99 00 21 20 89 00 00 00 84 AD 08 00 E4 8C 21 10 82 00 0A 00 20 11 00 00 64 8D C4 00 C8 8F 2B 58 88 00 07 00 60 55 23 20 91 00 2B 58 64 00 04 00 60 55 23 20 91 00 03 00 00 10 23 20 88 00 23 20 91 00 21 20 89 00 00 00 44 AC CB FF 00 10 01 00 A5 24 21 10 60 01 FF FF 03 24 00 00 E4 8C 2B 20 44 00 5E FF 80 10 80 20 02 00 04 00 E5 8C 08 00 E6 8C 21 28 A4 00 21 20 C4 00 00 00 83 AC 01 00 42 24 F5 FF 00 10 00 00 A3 AC 1E 00 C2 2C 85 05 40 10 01 00 93 25 ?? ?? 8D 8F 80 10 06 00 ?? ?? AD 25 21 10 A2 01 00 00 42 8C 21 10 5C 00 08 00 40 00 00 00 00 00 01 00 0A 24 F2 FE 00 10 21 60 60 02 28 00 CE 8F 02 00 84 25 17 00 C0 11 01 00 82 91 05 00 18 56 00 00 06 92 A6 01 0F 13 21 28 20 02 0B 00 00 10 21 C0 E0 01 28 00 D9 8F 01 00 93 24 00 00 84 90 21 30 26 03 00 00 C6 90 9C 01 C4 14 01 00 05 26 FF FF 42 24 10 00 40 10 21 20 60 02 EF FF 00 10 21 80 A0 00 96 01 0F 13 21 28 20 02 21 C0 E0 01 21 80 A0 00 FB FF 18 12 01 00 93 24 00 00 06 82 00 00 84 80 8D 01 C4 14 01 00 05 26 FF FF 42 24 F7 FF 40 14 21 20 60 02 DA FF 40 15 21 80 A0 00 21 10 A0 02 01 00 04 24 2B 28 C2 02 D4 FF A0 14 80 28 02 00 21 28 05 01 00 00 A6 90 01 00 42 24 04 21 86 7C C4 18 86 7C F7 FF 00 10 00 00 A6 A0 7C 01 0F 12 21 20 00 02 21 C0 E0 01 21 80 20 02 FB FF 18 12 C0 00 CB 8F 0C 00 62 8D 40 00 44 30 0A 00 80 54 80 00 42 30 28 00 CC 8F 04 00 80 51 00 00 05 82 00 00 04 92 21 20 84 01 00 00 85 80 0A 00 04 24 6A 01 A4 10 80 00 42 30 08 00 40 10 28 00 CD 8F 04 00 A0 51 00 00 02 82 00 00 02 92 21 10 A2 01 00 00 42 80 62 01 40 10 21 20 00 02 B0 FF 40 55 01 00 10 26 21 10 A0 02 01 00 04 24 2B 28 C2 02 23 05 A0 14 80 28 02 00 21 28 05 01 00 00 A6 90 01 00 42 24 04 21 86 7C C4 18 86 7C F7 FF 00 10 00 00 A6 A0 05 00 C6 38 01 00 C6 2C 20 24 06 7C 06 00 18 16 28 00 CE 8F 4D 01 0F 52 21 20 00 02 21 C0 E0 01 FA FF 00 10 21 80 20 02 03 00 C0 11 00 00 02 92 21 10 C2 01 00 00 42 90 01 00 85 91 C0 58 05 00 2B 58 4B 00 08 00 60 11 C2 58 02 00 21 58 6B 02 01 00 6B 91 07 00 42 30 01 00 C6 38 07 10 4B 00 01 00 42 30 0B 20 C2 00 38 01 80 10 21 20 00 02 0F 00 40 55 01 00 A5 24 21 10 A0 02 01 00 04 24 2B 30 C2 02 08 00 C0 14 80 30 02 00 21 30 06 01 00 00 CA 90 01 00 42 24 04 21 8A 7C C4 18 8A 7C F7 FF 00 10 00 00 CA A0 01 00 0A 24 01 00 A5 24 EF 04 00 10 21 98 65 02 18 00 D3 AF 01 00 93 91 03 00 02 24 80 98 13 00 21 98 13 01 00 00 64 8E 03 00 84 30 1A 00 82 54 01 00 82 91 ?? ?? 99 8F 34 00 C5 8F 18 00 C4 27 21 30 00 01 88 00 C3 AF 90 00 C7 AF 80 00 C8 AF 8C 00 C9 AF 7C 00 CC AF 78 00 CF AF ?? ?? 39 27 ?? ?? ?? ?? 84 00 D8 AF 00 00 64 92 10 00 DC 8F 04 08 44 7C 00 00 64 A2 84 00 D8 8F 78 00 CF 8F 7C 00 CC 8F 8C 00 C9 8F 80 00 C8 8F 90 00 C7 8F 88 00 C3 8F 01 00 82 91 40 00 D9 8F 20 00 CA 8F 80 10 02 00 21 28 02 01 00 00 A5 8C 21 20 22 03 03 00 A5 30 08 00 A0 10 21 10 42 01 00 00 45 8C ?? ?? 82 8F ?? ?? 42 24 26 10 A2 00 0A 28 02 02 02 00 00 10 21 10 A0 00 00 00 42 8C 00 00 82 AC 01 00 82 91 20 00 CB 8F 01 00 05 24 80 10 02 00 21 10 62 01 00 00 50 AC 01 00 82 91 03 00 93 25 58 00 D3 AF 80 10 02 00 21 10 02 01 00 00 44 90 84 10 A4 7C 00 00 44 A0 01 00 82 91 80 10 02 00 21 10 02 01 00 00 44 90 C4 18 04 7C 00 00 44 A0 01 00 96 91 01 01 A2 3A E0 00 00 10 0A A8 C2 02 01 00 82 91 44 00 CD 8F 24 00 CE 8F 80 10 02 00 21 28 02 01 00 00 A5 8C 21 20 A2 01 03 00 A5 30 08 00 A0 10 21 10 C2 01 00 00 45 8C ?? ?? 82 8F ?? ?? 42 24 26 10 A2 00 0A 28 02 02 02 00 00 10 21 10 A0 00 00 00 42 8C 00 00 82 AC 01 00 82 91 24 00 D9 8F 80 10 02 00 21 10 22 03 00 00 50 AC 01 00 82 91 80 10 02 00 21 10 02 01 00 00 44 90 84 10 04 7C 0D 00 B6 12 00 00 44 A0 01 00 82 91 FF FF 42 24 FF 00 42 30 08 00 40 10 80 20 02 00 21 20 04 01 00 00 84 8C 04 00 84 30 F8 FF 80 10 21 B0 40 00 04 00 00 10 01 00 82 91 00 01 16 24 01 01 15 24 01 00 82 91 80 10 02 00 21 10 02 01 00 00 42 8C 08 00 42 30 05 00 40 10 34 00 CB 8F 58 00 CA 8F A9 00 4C 15 03 00 93 25 34 00 CB 8F 03 00 82 25 2B 10 4B 00 A4 00 40 10 03 00 93 25 04 00 82 25 18 00 C2 AF 03 00 82 91 14 00 44 2C 08 00 80 10 16 00 04 24 11 00 44 2C 09 00 80 10 0D 00 04 24 08 00 44 10 21 28 00 00 0E 00 00 10 21 20 00 00 04 00 44 10 01 00 05 24 0A 00 00 10 21 20 00 00 21 28 00 00 05 00 84 81 04 00 82 91 00 22 04 00 21 20 44 00 02 00 A0 10 06 00 82 25 08 00 82 25 18 00 C2 AF 18 00 C2 8F 21 10 44 00 85 00 81 04 18 00 C2 AF 00 00 45 90 0F 00 04 24 82 00 A4 14 03 00 93 25 03 00 45 90 06 00 04 24 C8 FE A4 14 21 50 00 00 01 00 84 91 04 00 42 90 C4 FE 44 14 80 10 02 00 21 10 02 01 00 00 44 8C 10 00 84 30 12 00 80 54 00 00 44 90 18 00 C2 8F 01 00 CA 26 23 50 55 01 01 00 44 24 18 00 C4 AF 01 00 44 90 02 00 53 80 03 00 42 24 18 00 C2 AF 03 00 02 24 02 50 42 71 00 9A 13 00 21 98 93 00 ?? ?? 8B 8F 13 00 0C 24 3B 00 00 10 04 00 4A 25 04 21 04 7C 00 00 44 A0 01 00 82 91 02 00 85 91 01 00 84 91 21 20 A4 00 2B 20 44 00 E7 FF 80 10 80 20 02 00 40 00 CA 8F 20 00 CB 8F 21 28 44 01 00 00 A6 8C 44 00 CD 8F 21 28 64 01 00 00 A6 AC 21 28 A4 01 00 00 A5 8C 2B 30 A6 00 EF FF C0 14 01 00 42 24 24 00 CE 8F 21 20 C4 01 EB FF 00 10 00 00 85 AC 02 10 82 71 2B 10 57 00 62 04 40 14 C0 10 17 00 ?? ?? 99 8F 08 00 42 24 23 E8 A2 03 21 28 80 02 88 00 C3 AF 90 00 C7 AF 80 00 C8 AF 8C 00 C9 AF 70 00 CA AF 74 00 CB AF 7C 00 CC AF 78 00 CF AF 84 00 D8 AF 10 00 A4 27 ?? ?? ?? ?? 80 30 17 00 21 A0 40 00 10 00 DC 8F 88 00 C3 8F 90 00 C7 8F 80 00 C8 8F 8C 00 C9 8F 70 00 CA 8F 74 00 CB 8F 7C 00 CC 8F 78 00 CF 8F 46 04 40 10 84 00 D8 8F 40 B8 17 00 23 10 F2 02 2B 10 4A 00 DC FF 40 54 00 00 62 8D 21 20 A0 02 2B 28 C4 02 11 00 A0 14 80 10 12 00 20 00 CA 8F 80 28 04 00 24 00 CB 8F 21 30 45 01 00 00 C6 8C 21 10 82 02 03 00 52 26 00 00 46 AC 21 30 65 01 00 00 C6 8C 21 28 05 01 01 00 84 24 04 00 46 AC 00 00 A5 8C EE FF 00 10 08 00 45 AC 21 10 82 02 00 00 55 AC 04 00 56 AC 18 00 C4 8F 04 00 52 26 0C 00 50 AC 21 98 93 00 02 00 00 10 08 00 53 AC 21 80 A0 00 21 20 00 02 0F 00 06 24 15 00 0A 24 16 00 0B 24 CD 03 00 10 0D 00 0C 24 03 00 93 25 49 FE 00 10 21 50 00 00 01 00 8E 91 02 00 93 25 20 00 CC 8F 80 70 0E 00 21 10 8E 01 00 00 4B 8C ?? ?? 82 8F ?? ?? 42 24 EE FF 62 11 24 00 CD 8F 21 70 AE 01 00 00 CC 8D EA FF 82 11 64 00 CE AF 07 00 20 11 21 10 00 00 C4 00 CE 8F 2B 20 6E 01 04 00 80 14 01 00 44 38 2B 10 6B 00 01 00 42 38 01 00 44 38 07 00 20 11 21 10 00 00 C4 00 D9 8F 2B 28 99 01 04 00 A0 14 2C 00 CD 8F 2B 10 6C 00 01 00 42 38 2C 00 CD 8F 26 10 82 00 0A 60 A2 01 0C 00 6C 15 00 00 00 00 23 FE 6F 11 64 00 CE 8F 00 00 CC 8D 20 FE 6C 11 21 58 20 02 F8 FF 00 10 00 00 00 00 CC FF 0F 12 21 20 00 02 21 C0 E0 01 21 80 20 02 FB FF 18 12 28 00 D9 8F 23 68 10 03 23 10 8B 01 2A 20 4D 00 15 00 20 13 0B 68 44 00 21 28 60 01 21 20 00 02 21 10 A0 01 2B 00 40 10 28 00 C6 8F 01 00 99 24 01 00 AE 24 00 00 84 90 00 00 A5 90 21 20 C4 00 21 28 C5 00 00 00 84 80 00 00 A5 80 04 00 85 14 21 28 C0 01 FF FF 42 24 F2 FF 00 10 21 20 20 03 1C 00 00 10 01 00 02 24 ?? ?? 99 8F 21 28 60 01 21 30 A0 01 88 00 C3 AF 90 00 C7 AF 80 00 C8 AF 8C 00 C9 AF 70 00 CA AF 74 00 CB AF 7C 00 CC AF 6C 00 CD AF 78 00 CF AF 84 00 D8 AF ?? ?? ?? ?? 21 20 00 02 10 00 DC 8F 84 00 D8 8F 78 00 CF 8F 6C 00 CD 8F 7C 00 CC 8F 74 00 CB 8F 70 00 CA 8F 8C 00 C9 8F 80 00 C8 8F 90 00 C7 8F 88 00 C3 8F 2B 10 02 00 92 FF 40 54 21 20 00 02 21 80 0D 02 B9 FF 40 15 21 58 6D 01 21 10 A0 02 2B 20 C2 02 09 00 80 14 80 20 02 00 21 20 04 01 00 00 85 90 01 00 06 24 01 00 42 24 04 21 C5 7C C4 18 C5 7C F6 FF 00 10 00 00 85 A0 AB FF 00 10 01 00 0A 24 C4 00 C2 8F 0A 10 29 02 03 00 02 12 D0 00 CB 8F 05 00 60 55 FF FF 04 82 C0 00 CC 8F 1C 00 82 8D 0C 00 00 10 20 00 42 30 0A 00 02 24 74 FF 82 14 21 20 00 02 C0 00 CD 8F 13 00 00 10 1C 00 A2 8D 3C 00 CE 8F 07 00 0E 16 C0 00 D9 8F 1C 00 22 8F 40 00 42 30 AD FC 40 50 21 60 60 02 68 FF 00 10 21 20 00 02 02 00 03 56 00 00 02 82 00 00 22 82 0A 00 42 38 01 00 42 2C 61 FF 40 10 21 20 00 02 C0 00 CB 8F 1C 00 62 8D 80 00 42 30 9F FC 40 54 }
	condition:
		$1
}

rule file_430_7_0 {
	meta:
		name = "byte_regex_compile"
		size = 9560
		refs = "0000 _gp_disp 0040 malloc 00a4 __GI_memset 00c8 __GI___ctype_b 0124 realloc 0158 free 0768 byte_insert_op1 0b60 byte_compile_range 0d88 __GI_strcmp 0d8c $LC0 0db4 $LC1 0dd4 __GI_wctype 0e2c __GI_btowc 0e58 __GI_iswctype"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 70 FE BD 27 18 00 BC AF 84 01 B7 AF 70 01 B2 AF 6C 01 B1 AF 8C 01 BF AF 88 01 BE AF 80 01 B6 AF 7C 01 B5 AF 78 01 B4 AF 74 01 B3 AF 68 01 B0 AF 14 00 E3 8C ?? ?? 99 8F 90 01 A4 AF 24 01 A4 AF 28 01 A3 AF 80 02 04 24 21 90 A0 00 21 88 C0 00 ?? ?? ?? ?? 21 B8 E0 00 2C 01 A2 AF 3E 00 40 10 18 00 BC 8F 1C 00 E2 92 0C 00 F1 AE 08 00 E0 AE C4 18 02 7C 84 31 02 7C 44 29 02 7C 1C 00 E2 A2 ?? ?? 82 8F 18 00 E0 AE ?? ?? 43 8C 1D 00 60 14 21 A8 40 00 ?? ?? 90 8F ?? ?? 99 8F 21 28 00 00 ?? ?? 10 26 21 20 00 02 ?? ?? ?? ?? 00 01 06 24 18 00 BC 8F 21 10 00 00 01 00 05 24 ?? ?? 84 8F 00 01 03 24 00 00 87 8C 40 30 02 00 21 30 E6 00 00 00 C6 94 00 08 C6 30 04 00 C0 50 01 00 42 24 21 30 02 02 00 00 C5 A0 01 00 42 24 F6 FF 43 54 00 00 87 8C 01 00 02 24 5F 00 02 A2 01 00 02 24 ?? ?? A2 AE 04 00 E2 8E 17 00 40 14 90 01 A8 8F 00 00 E4 8E 05 00 80 10 ?? ?? 99 8F ?? ?? ?? ?? 20 00 05 24 05 00 00 10 18 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 20 00 04 24 18 00 BC 8F 00 00 E2 AE 00 00 E2 8E 06 00 40 54 20 00 02 24 ?? ?? 99 8F ?? ?? ?? ?? 2C 01 A4 8F F0 08 00 10 0C 00 02 24 04 00 E2 AE 90 01 A8 8F 00 00 F6 8E 20 00 19 24 21 90 12 01 21 80 C0 02 30 01 A0 AF 38 01 B9 AF 34 01 A0 AF 21 A8 00 00 21 98 00 00 21 A0 00 00 24 01 A2 8F AD 08 52 10 28 01 A3 8F 01 00 44 24 24 01 A4 AF 03 00 60 10 00 00 5E 90 21 F0 7E 00 00 00 DE 93 2E 00 05 24 94 01 C5 13 2F 00 C5 2F 15 00 A0 10 28 00 05 24 01 04 C5 13 29 00 C5 2F 08 00 A0 50 2A 00 02 24 0A 00 05 24 0E 04 C5 13 24 00 05 24 5F 00 C5 13 00 00 00 00 10 08 00 10 00 00 00 00 A9 00 C2 13 2A 00 C2 2F 02 04 40 14 00 20 22 32 2B 00 02 24 A2 00 C2 13 02 04 22 32 07 08 00 10 00 00 00 00 5C 00 05 24 12 04 C5 13 5D 00 C5 2F 08 00 A0 50 7B 00 05 24 3F 00 02 24 97 00 C2 13 5B 00 02 24 98 01 C2 13 00 00 00 00 FB 07 00 10 00 00 00 00 FD 03 C5 13 7C 00 05 24 F6 03 C5 13 5E 00 05 24 F5 07 C5 17 90 01 A8 8F 01 00 05 25 1A 00 85 10 08 00 24 32 19 00 80 14 01 00 06 3C FF FF 45 24 2B 28 05 01 05 00 A0 50 FF FF 42 80 FE FF 44 80 5C 00 84 38 01 00 84 2C FF FF 42 80 28 00 05 24 03 00 45 14 20 24 04 7C 05 00 00 10 00 20 22 32 7C 00 05 24 E0 07 45 14 5E 00 1E 24 00 80 22 32 05 00 40 14 2B 10 04 00 04 00 40 14 01 00 06 3C D9 07 00 10 5E 00 1E 24 01 00 06 3C 01 00 C7 24 00 00 FE 8E 04 00 E5 8E 23 10 DE 02 01 00 42 24 2B 10 A2 00 65 00 40 50 09 00 02 24 03 00 A6 54 40 28 05 00 87 08 00 10 0F 00 02 24 2B 10 A7 00 ?? ?? 99 8F 0A 28 C2 00 58 01 A6 AF 5C 01 A7 AF 04 00 E5 AE ?? ?? ?? ?? 21 20 C0 03 00 00 E2 AE 18 00 BC 8F 58 01 A6 8F 89 FF 40 10 5C 01 A7 8F E7 FF C2 13 23 10 5E 00 21 20 A2 02 21 B0 C2 02 21 80 02 02 0B A8 95 00 21 20 62 02 21 10 82 02 0B 98 93 00 DE FF 00 10 0B A0 54 00 24 00 92 10 08 00 24 32 23 00 80 54 01 00 06 3C 01 00 44 80 02 00 42 24 2B 28 52 00 5C 00 86 38 0A 10 05 00 00 20 25 32 06 00 A0 10 01 00 C6 2C 29 00 05 24 0C 00 85 14 00 80 25 32 16 00 00 10 01 00 06 3C 06 00 C0 10 21 28 00 00 04 00 40 10 00 00 00 00 00 00 45 80 29 00 A5 38 01 00 A5 2C 0C 00 A0 14 00 80 25 32 07 00 A0 54 7C 00 84 38 06 00 C0 10 21 20 00 00 04 00 40 10 00 00 00 00 00 00 44 80 7C 00 84 38 01 00 84 2C 8F 07 80 10 24 00 1E 24 01 00 06 3C 01 00 C7 24 00 00 FE 8E 04 00 E5 8E 23 10 DE 02 01 00 42 24 2B 10 A2 00 1B 00 40 50 0A 00 02 24 B7 FF A6 10 ?? ?? 99 8F 40 28 05 00 2B 10 A7 00 0A 28 C2 00 58 01 A6 AF 5C 01 A7 AF 04 00 E5 AE ?? ?? ?? ?? 21 20 C0 03 00 00 E2 AE 18 00 BC 8F 58 01 A6 8F 41 FF 40 10 5C 01 A7 8F E9 FF C2 13 23 10 5E 00 21 20 A2 02 21 B0 C2 02 21 80 02 02 0B A8 95 00 21 20 62 02 21 10 82 02 0B 98 93 00 E0 FF 00 10 0B A0 54 00 00 00 C2 A2 41 FF 00 10 01 00 D6 26 02 04 22 32 66 07 40 14 00 00 00 00 07 00 60 16 21 28 00 00 20 00 22 32 2A 05 40 14 ?? ?? 99 8F 10 00 22 32 5E 07 40 10 00 00 00 00 21 60 00 00 2A 00 0D 24 02 00 2E 32 5C 00 0F 24 2B 00 07 24 3F 00 06 24 2B 00 C2 3B 2B 10 02 00 25 60 82 01 24 01 A2 8F 3F 00 DE 3B 2B F0 1E 00 1E 00 52 10 25 28 BE 00 28 01 B9 8F 01 00 58 24 24 01 B8 AF 03 00 20 13 00 00 44 90 21 20 24 03 00 00 84 90 F0 FF 8D 10 2A 00 1E 24 07 00 C0 15 00 00 00 00 EC FF 87 10 2B 00 1E 24 0E 00 86 14 3F 00 1E 24 E9 FF 00 10 2B 00 C2 3B 0B 00 8F 54 24 01 A2 AF 4B 03 12 13 28 01 A3 8F 02 00 44 24 24 01 A4 AF F3 FF 60 10 01 00 44 90 21 20 64 00 F0 FF 00 10 00 00 84 90 24 01 A2 AF 0A FF 60 12 24 01 A2 8F 50 00 A0 10 21 A0 00 00 01 00 14 3C 01 00 87 26 00 00 FE 8E 04 00 E5 8E 23 10 DE 02 03 00 42 24 2B 10 A2 00 19 00 40 10 28 01 A8 8F 57 FF B4 10 ?? ?? 99 8F 40 28 05 00 2B 10 A7 00 0A 28 82 02 5C 01 A7 AF 54 01 AC AF 04 00 E5 AE ?? ?? ?? ?? 21 20 C0 03 00 00 E2 AE 18 00 BC 8F 5C 01 A7 8F E1 FE 40 10 54 01 AC 8F E9 FF C2 13 23 F0 5E 00 21 10 BE 02 21 B0 DE 02 21 80 1E 02 21 F0 7E 02 0B A8 55 00 E2 FF 00 10 0B 98 D3 03 06 00 00 11 24 01 A2 8F FE FF 44 90 21 20 04 01 00 00 85 80 03 00 00 10 2E 00 04 81 FE FF 45 80 2E 00 04 24 1C 00 A4 54 23 10 76 02 1A 00 80 51 23 10 76 02 2B 20 52 00 17 00 80 50 23 10 76 02 28 01 B9 8F 06 00 20 53 00 00 44 80 00 00 42 90 21 10 22 03 00 00 44 80 02 00 00 10 0A 00 22 83 0A 00 02 24 0C 00 82 14 23 10 76 02 40 00 22 32 09 00 40 14 23 10 76 02 FD FF 42 24 0D 00 04 24 01 00 C2 A2 03 12 02 00 00 00 C4 A2 02 00 C2 A2 08 00 00 10 01 00 14 24 FA FF 42 24 12 00 04 24 01 00 C2 A2 03 12 02 00 00 00 C4 A2 02 00 C2 A2 21 A0 00 00 03 00 D6 26 01 00 07 3C 21 F0 C0 02 01 00 EB 24 00 00 F6 8E 04 00 E5 8E 23 10 D6 03 03 00 42 24 2B 10 A2 00 1B 00 40 50 10 00 02 24 07 FF A7 10 ?? ?? 99 8F 40 28 05 00 2B 10 AB 00 0A 28 E2 00 5C 01 A7 AF 48 01 AB AF 54 01 AC AF 04 00 E5 AE ?? ?? ?? ?? 21 20 C0 02 00 00 E2 AE 18 00 BC 8F 5C 01 A7 8F 48 01 AB 8F 8F FE 40 10 54 01 AC 8F E7 FF C2 12 23 18 56 00 21 10 A3 02 21 F0 C3 03 21 80 03 02 21 18 63 02 0B A8 55 00 E0 FF 00 10 0B 98 73 00 0F 00 04 24 0B 20 54 00 ?? ?? 82 8F 21 28 60 02 23 30 D3 03 ?? ?? 59 24 ?? ?? ?? ?? 21 38 C0 03 03 00 D6 27 88 FE 80 15 18 00 BC 8F 01 00 1E 3C 01 00 CB 27 00 00 F4 8E 04 00 E5 8E 23 10 D4 02 03 00 42 24 2B 10 A2 00 17 00 40 10 ?? ?? 99 8F D9 FE BE 10 ?? ?? 99 8F 40 28 05 00 2B 10 AB 00 0A 28 C2 03 48 01 AB AF 04 00 E5 AE ?? ?? ?? ?? 21 20 80 02 00 00 E2 AE 18 00 BC 8F 65 FE 40 10 48 01 AB 8F EB FF 82 12 23 30 54 00 21 10 A6 02 21 B0 C6 02 21 80 06 02 21 30 66 02 0B A8 55 00 E4 FF 00 10 0B 98 D3 00 13 00 04 24 21 28 60 02 03 00 06 24 ?? ?? 39 27 ?? ?? ?? ?? 21 38 C0 02 A7 03 00 10 18 00 BC 8F 01 00 06 3C 21 98 C0 02 01 00 C7 24 00 00 FE 8E 04 00 E5 8E 23 10 DE 02 01 00 42 24 2B 10 A2 00 15 FF 40 50 03 00 02 24 B1 FE A6 10 ?? ?? 99 8F 40 28 05 00 2B 10 A7 00 0A 28 C2 00 58 01 A6 AF 5C 01 A7 AF 04 00 E5 AE ?? ?? ?? ?? 21 20 C0 03 00 00 E2 AE 18 00 BC 8F 58 01 A6 8F 3B FE 40 10 5C 01 A7 8F E9 FF C2 13 23 10 5E 00 21 20 A2 02 21 B0 C2 02 21 80 02 02 0B A8 95 00 21 20 62 02 21 10 82 02 0B 98 93 00 E0 FF 00 10 0B A0 54 00 B6 00 92 10 01 00 13 3C 01 00 67 26 00 00 FE 8E 04 00 E5 8E 23 10 DE 02 22 00 42 24 2B 10 A2 00 17 00 40 10 01 00 06 3C 8D FE B3 10 ?? ?? 99 8F 40 28 05 00 2B 10 A7 00 0A 28 62 02 5C 01 A7 AF 04 00 E5 AE ?? ?? ?? ?? 21 20 C0 03 00 00 E2 AE 18 00 BC 8F 19 FE 40 10 5C 01 A7 8F EB FF C2 13 23 F0 5E 00 21 10 BE 02 21 B0 DE 02 21 80 1E 02 21 F0 9E 02 0B A8 55 00 E4 FF 00 10 0B A0 D4 03 21 98 C0 02 01 00 C7 24 00 00 FE 8E 04 00 E5 8E 23 10 DE 02 01 00 42 24 2B 10 A2 00 1B 00 40 50 24 01 A2 8F 6E FE A6 10 ?? ?? 99 8F 40 28 05 00 2B 10 A7 00 0A 28 C2 00 58 01 A6 AF 5C 01 A7 AF 04 00 E5 AE ?? ?? ?? ?? 21 20 C0 03 00 00 E2 AE 18 00 BC 8F 58 01 A6 8F F8 FD 40 10 5C 01 A7 8F E9 FF C2 13 23 10 5E 00 21 20 A2 02 21 B0 C2 02 21 80 02 02 0B A8 95 00 21 20 62 02 21 10 82 02 0B 98 93 00 E0 FF 00 10 0B A0 54 00 04 00 04 24 5E 00 03 24 00 00 45 80 05 00 02 24 5E 00 A5 38 0B 10 85 00 00 00 C2 A2 24 01 A2 8F 00 00 44 80 03 00 83 14 01 00 CC 26 01 00 42 24 24 01 A2 AF 24 01 A3 8F 01 00 16 3C 01 00 C6 26 3C 01 A3 AF 00 00 FE 8E 04 00 E5 8E 23 10 9E 01 01 00 42 24 2B 10 A2 00 1B 00 40 10 ?? ?? 99 8F 3C FE B6 10 ?? ?? 99 8F 40 28 05 00 2B 10 A6 00 0A 28 C2 02 58 01 A6 AF 54 01 AC AF 04 00 E5 AE ?? ?? ?? ?? 21 20 C0 03 00 00 E2 AE 18 00 BC 8F 58 01 A6 8F C6 FD 40 10 54 01 AC 8F E9 FF C2 13 23 10 5E 00 21 20 A2 02 21 60 82 01 21 80 02 02 0B A8 95 00 21 20 62 02 21 10 82 02 0B 98 93 00 E0 FF 00 10 0B A0 54 00 01 00 96 25 20 00 02 24 00 00 82 A1 21 20 C0 02 54 01 AC AF 21 28 00 00 ?? ?? ?? ?? 20 00 06 24 54 01 AC 8F 05 00 02 24 FF FF 83 91 07 00 62 14 18 00 BC 8F 00 01 22 32 3F 00 40 50 FF FF 06 24 02 00 82 91 04 00 42 34 02 00 82 A1 3A 00 00 10 FF FF 06 24 01 00 44 24 24 01 A4 AF 03 00 00 11 00 00 43 90 21 18 03 01 00 00 63 90 01 00 25 32 33 00 A0 14 5C 00 05 24 5D 00 05 24 43 00 65 10 3C 01 A8 8F 01 00 45 80 45 00 C0 15 2D 00 07 24 5A 00 67 14 90 01 B9 8F FF FF 47 24 2B 38 F9 00 49 00 E0 50 FF FF 4F 80 90 01 A8 8F FE FF 47 24 2B 38 E8 00 49 00 E0 50 FE FF 4F 80 5D 00 07 24 4D 00 A7 10 28 01 A7 8F ?? ?? 82 8F 21 20 C0 00 10 00 B1 AF 14 00 B6 AF 24 01 A5 27 21 30 40 02 ?? ?? 59 24 ?? ?? ?? ?? 00 00 00 00 21 F0 40 00 54 00 40 14 18 00 BC 8F FF FF 06 24 24 01 A2 8F D4 FF 52 14 28 01 A8 8F ?? ?? 99 8F ?? ?? ?? ?? 2C 01 A4 8F 65 06 00 10 07 00 02 24 0C 00 82 91 3A 00 06 24 08 00 42 34 0C 00 82 A1 08 00 82 91 04 00 42 34 08 00 82 A1 F0 FF 00 10 21 70 00 00 CE FF 65 54 5D 00 05 24 AD 01 92 10 28 01 B9 8F 02 00 43 24 24 01 A3 AF 03 00 20 13 01 00 46 90 21 30 26 03 00 00 C6 90 C2 10 06 00 21 10 C2 02 01 00 04 24 07 00 C3 30 04 18 64 00 00 00 44 90 25 18 64 00 DD FF 00 10 00 00 43 A0 01 00 05 25 BD FF 85 50 01 00 45 80 6D 01 00 10 00 00 82 91 16 00 67 14 2D 00 07 24 5D 00 07 24 BA FF A7 10 90 01 B9 8F ?? ?? 99 8F ?? ?? ?? ?? 2C 01 A4 8F 3A 06 00 10 0B 00 02 24 5B 00 07 24 B7 FF E7 15 90 01 A8 8F 09 00 00 10 2D 00 07 24 5B 00 07 24 B7 FF E7 15 5D 00 07 24 FF FF 4F 80 5E 00 07 24 B3 FF E7 15 5D 00 07 24 2D 00 07 24 16 00 A7 14 04 00 27 32 02 00 4F 80 5D 00 07 24 12 00 E7 11 04 00 27 32 24 06 92 10 21 20 60 00 ?? ?? 83 8F 02 00 42 24 24 01 A2 AF 10 00 B1 AF 14 00 B6 AF 24 01 A5 27 21 30 40 02 28 01 A7 8F A9 FF 00 10 ?? ?? 79 24 ?? ?? 99 8F ?? ?? ?? ?? 2C 01 A4 8F 16 06 00 10 21 10 C0 03 2F 01 E0 50 C2 10 03 00 5B 00 07 24 2C 01 67 54 C2 10 03 00 3A 00 07 24 90 00 A7 54 3D 00 07 24 0B 06 92 10 02 00 42 24 A1 FF 52 10 24 01 A2 AF 21 10 00 00 3A 00 07 24 20 00 BE 27 5D 00 0E 24 24 01 A3 8F 02 06 72 10 28 01 A8 8F 01 00 65 24 24 01 A5 AF 03 00 00 11 00 00 64 90 21 20 04 01 00 00 84 90 04 00 87 14 00 00 00 00 01 00 6F 80 08 00 EE 51 21 28 C2 03 06 00 B2 50 21 28 C2 03 01 00 43 24 21 10 C2 03 00 00 44 A0 EC FF 00 10 FF 00 62 30 00 00 A0 A0 3A 00 05 24 66 00 85 14 01 00 42 24 01 00 64 80 5D 00 03 24 63 00 83 14 FF 00 42 30 ?? ?? 99 8F ?? ?? 85 8F 58 01 A6 AF 54 01 AC AF 21 20 C0 03 ?? ?? A5 24 ?? ?? ?? ?? 48 01 B9 AF 18 00 BC 8F 48 01 B9 8F 01 00 42 2C ?? ?? 85 8F 21 20 C0 03 40 01 A2 AF 09 F8 20 03 ?? ?? A5 24 18 00 BC 8F 01 00 42 2C 21 20 C0 03 ?? ?? 99 8F ?? ?? ?? ?? 44 01 A2 AF 21 F0 40 00 18 00 BC 8F 58 01 A6 8F 06 00 40 14 54 01 AC 8F ?? ?? 99 8F ?? ?? ?? ?? 2C 01 A4 8F C9 05 00 10 04 00 02 24 24 01 A2 8F C5 05 52 10 01 00 42 24 5B FF 52 10 24 01 A2 AF ?? ?? 8F 8F 21 18 00 00 01 00 07 24 00 01 0E 24 ?? ?? 99 8F 21 20 60 00 48 01 A3 AF 58 01 A6 AF 5C 01 A7 AF 54 01 AC AF 50 01 AE AF ?? ?? ?? ?? 4C 01 AF AF 18 00 BC 8F 21 20 40 00 ?? ?? 99 8F ?? ?? ?? ?? 21 28 C0 03 18 00 BC 8F 48 01 A3 8F 58 01 A6 8F 5C 01 A7 8F 54 01 AC 8F 50 01 AE 8F 08 00 40 10 4C 01 AF 8F C0 20 62 7C 21 10 C2 02 00 00 45 90 07 00 64 30 04 20 87 00 25 20 85 00 00 00 44 A0 28 01 A8 8F 14 00 00 11 44 01 B9 8F 05 00 20 57 00 00 E4 8D 40 01 A8 8F 10 00 00 51 01 00 63 24 00 00 E4 8D 40 10 03 00 21 10 82 00 00 00 42 94 03 00 42 30 09 00 40 50 01 00 63 24 C0 20 62 7C 21 10 C2 02 00 00 45 90 07 00 64 30 04 20 87 00 25 20 85 00 00 00 44 A0 01 00 63 24 CC FF 6E 14 ?? ?? 99 8F 1C FF 00 10 01 00 0E 24 FF 00 42 30 FF FF 43 24 20 FF 40 10 FF 00 63 30 24 01 A2 8F FF FF 42 24 24 01 A2 AF F9 FF 00 10 21 10 60 00 47 00 A7 54 2E 00 06 24 7A 05 92 10 02 00 42 24 10 FF 52 10 24 01 A2 AF 21 10 00 00 3D 00 07 24 5D 00 0E 24 24 01 A3 8F 72 05 72 10 28 01 B9 8F 01 00 65 24 24 01 A5 AF 03 00 20 13 00 00 64 90 21 20 24 03 00 00 84 90 04 00 87 14 00 00 00 00 01 00 6F 80 08 00 EE 51 21 38 A2 03 06 00 B2 50 21 38 A2 03 02 00 40 54 20 00 A0 A3 20 00 A4 A3 EC FF 00 10 01 00 02 24 20 00 E0 A0 3D 00 07 24 16 00 87 54 01 00 42 24 01 00 67 80 5D 00 04 24 12 00 E4 54 01 00 42 24 20 00 A4 93 0F 00 80 50 01 00 42 24 4F 00 40 10 ?? ?? 99 8F 51 05 B2 10 02 00 63 24 24 01 A3 AF C2 18 04 00 21 18 C3 02 00 00 65 90 07 00 84 30 04 10 82 00 25 10 45 00 }
	condition:
		$1
}

rule file_430_8_0 {
	meta:
		name = "re_set_syntax"
		size = 28
		refs = "0000 _gp_disp 000c re_syntax_options"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 83 8F 00 00 62 8C 08 00 E0 03 00 00 64 AC }
	condition:
		$1
}

rule file_75_4_3 {
	meta:
		name = "_ZSt13set_terminatePFvvE"
		size = 28
		refs = "0000 _gp_disp 000c _ZN10__cxxabiv119__terminate_handlerE"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 83 8F 00 00 62 8C 08 00 E0 03 00 00 64 AC }
	condition:
		$1
}

rule file_75_5_3 {
	meta:
		name = "_ZSt14set_unexpectedPFvvE"
		size = 28
		refs = "0000 _gp_disp 000c _ZN10__cxxabiv120__unexpected_handlerE"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 83 8F 00 00 62 8C 08 00 E0 03 00 00 64 AC }
	condition:
		$1
}

rule file_127_0_3 {
	meta:
		name = "_ZSt15set_new_handlerPFvvE"
		size = 28
		refs = "0000 _gp_disp 000c __new_handler"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 83 8F 00 00 62 8C 08 00 E0 03 00 00 64 AC }
	condition:
		$1
}

rule file_430_9_0 {
	meta:
		name = "__GI_re_compile_fastmap"
		size = 28
		refs = "0000 _gp_disp 0014 byte_re_compile_fastmap"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? 39 27 ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_73_6_3 {
	meta:
		name = "_ZSt18_Rb_tree_decrementPKSt18_Rb_tree_node_base"
		size = 28
		refs = "0000 _gp_disp 0014 _ZStL23local_Rb_tree_decrementPSt18_Rb_tree_node_base"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? 39 27 ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_73_5_3 {
	meta:
		name = "_ZSt18_Rb_tree_decrementPSt18_Rb_tree_node_base"
		size = 28
		refs = "0000 _gp_disp 0014 _ZStL23local_Rb_tree_decrementPSt18_Rb_tree_node_base"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? 39 27 ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_73_7_3 {
	meta:
		name = "_ZSt20_Rb_tree_rotate_leftPSt18_Rb_tree_node_baseRS0_"
		size = 28
		refs = "0000 _gp_disp 0014 _ZStL25local_Rb_tree_rotate_leftPSt18_Rb_tree_node_baseRS0_"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? 39 27 ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_73_8_3 {
	meta:
		name = "_ZSt21_Rb_tree_rotate_rightPSt18_Rb_tree_node_baseRS0_"
		size = 28
		refs = "0000 _gp_disp 0014 _ZStL26local_Rb_tree_rotate_rightPSt18_Rb_tree_node_baseRS0_"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? 39 27 ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_754_1_0 {
	meta:
		name = "__GI_setenv"
		size = 28
		refs = "0000 _gp_disp 0014 __add_to_environ"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? 39 27 ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_813_7_0 {
	meta:
		name = "__ivaliduser"
		size = 28
		refs = "0000 _gp_disp 0014 __ivaliduser2.isra.1"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? 39 27 ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_18_15_2 {
	meta:
		name = "__pthread_initialize"
		size = 28
		refs = "0000 _gp_disp 0014 pthread_initialize"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? 39 27 ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_813_6_0 {
	meta:
		name = "iruserok"
		size = 28
		refs = "0000 _gp_disp 0014 iruserok2.isra.2"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? 39 27 ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_430_14_0 {
	meta:
		name = "re_match_2"
		size = 28
		refs = "0000 _gp_disp 0014 byte_re_match_2_internal"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? 39 27 ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_497_1_0 {
	meta:
		name = "waitid"
		size = 28
		refs = "0000 _gp_disp 0014 waitid5.constprop.0"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F ?? ?? 39 27 ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_430_10_0 {
	meta:
		name = "re_set_registers"
		size = 64
	strings:
		$1 = { 09 00 C0 10 1C 00 82 90 01 00 03 24 44 10 62 7C 1C 00 82 A0 10 00 A2 8F 00 00 A6 AC 04 00 A7 AC 08 00 E0 03 08 00 A2 AC 44 10 02 7C 1C 00 82 A0 00 00 A0 AC 08 00 A0 AC 08 00 E0 03 04 00 A0 AC }
	condition:
		$1
}

rule file_430_11_0 {
	meta:
		name = "re_search_2"
		size = 756
		refs = "0000 _gp_disp 00ec byte_re_compile_fastmap 028c byte_re_match_2_internal"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 B0 FF BD 27 2C 00 B1 AF 28 00 B0 AF 60 00 A2 8F 64 00 B0 8F 68 00 B1 8F 40 00 B6 AF 34 00 B3 AF 30 00 B2 AF 20 00 BC AF 4C 00 BF AF 48 00 BE AF 44 00 B7 AF 3C 00 B5 AF 38 00 B4 AF 21 B0 C2 00 21 90 80 00 21 98 C0 00 10 00 94 8C 14 00 97 8C 96 00 00 06 21 10 11 02 2A 18 D0 02 93 00 60 14 21 F0 A0 00 03 00 41 04 21 A8 E0 00 04 00 00 10 23 88 10 00 2A 10 C2 02 23 18 D0 02 0B 88 62 00 08 00 42 8E 0F 00 40 10 00 00 00 00 0D 00 20 1A 0B 00 03 24 00 00 42 8E 00 00 42 90 07 00 43 10 09 00 03 24 07 00 43 14 00 00 00 00 1C 00 42 8E 80 00 42 30 03 00 40 14 00 00 00 00 7B 00 00 1E 01 00 11 24 58 00 80 12 00 00 00 00 1C 00 42 8E 08 00 42 30 24 00 40 14 ?? ?? 99 8F ?? ?? 39 27 ?? ?? ?? ?? 21 20 40 02 FE FF 03 24 1E 00 43 14 20 00 BC 8F 70 00 00 10 FE FF 02 24 4A 00 40 10 00 00 00 00 1C 00 42 8E 01 00 42 30 46 00 40 14 00 00 00 00 18 00 20 5E 2A 10 13 02 3E 00 60 56 2A 10 13 02 23 10 13 02 21 10 A2 02 00 00 42 80 03 00 E0 12 FF 00 42 30 21 10 E2 02 00 00 42 90 21 10 82 02 00 00 42 80 37 00 40 14 00 00 00 00 59 00 20 12 FF FF 02 24 52 00 20 5A 01 00 31 26 FF FF 31 26 01 00 10 26 E4 FF 80 16 2A 10 16 02 2D 00 00 10 00 00 00 00 07 00 40 10 21 20 00 00 21 18 11 02 2A 18 73 00 04 00 60 14 23 18 B3 02 23 20 13 02 21 20 24 02 23 18 B3 02 0B 18 C2 03 21 18 70 00 15 00 E0 12 21 10 20 02 2A 28 82 00 15 00 A0 10 01 00 65 24 00 00 63 90 21 18 E3 02 00 00 63 90 21 18 83 02 00 00 63 80 0F 00 60 54 23 88 22 02 FF FF 42 24 F4 FF 00 10 21 18 A0 00 00 00 63 90 21 18 83 02 00 00 63 80 07 00 60 54 23 88 22 02 FF FF 42 24 21 18 A0 00 2A 28 82 00 F7 FF A0 14 01 00 65 24 23 88 22 02 21 80 11 02 05 00 00 10 21 88 40 00 C3 FF 40 50 23 10 13 02 C2 FF 00 10 21 10 D0 03 0A 00 20 06 60 00 A2 8F 09 00 16 16 ?? ?? 99 8F 08 00 80 52 14 00 B0 AF 1C 00 42 8E 01 00 42 30 1B 00 40 10 FF FF 02 24 60 00 A2 8F ?? ?? 99 8F 14 00 B0 AF 10 00 A2 AF 6C 00 A2 8F 21 20 40 02 21 28 C0 03 18 00 A2 AF 70 00 A2 8F 21 30 60 02 21 38 A0 02 ?? ?? 39 27 ?? ?? ?? ?? 1C 00 A2 AF 0A 00 41 04 20 00 BC 8F FE FF 03 24 AE FF 43 14 FE FF 02 24 07 00 00 10 4C 00 BF 8F B0 FF 00 10 FF FF 10 26 02 00 00 10 FF FF 02 24 21 10 00 02 4C 00 BF 8F 48 00 BE 8F 44 00 B7 8F 40 00 B6 8F 3C 00 B5 8F 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 E0 03 50 00 BD 27 }
	condition:
		$1
}

rule file_430_12_0 {
	meta:
		name = "re_search"
		size = 88
		refs = "0000 _gp_disp 0014 re_search_2"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 C8 FF BD 27 48 00 A3 8F ?? ?? 99 8F 21 10 A0 00 18 00 A3 AF 4C 00 A3 8F 34 00 BF AF 28 00 BC AF 10 00 A6 AF 14 00 A7 AF 1C 00 A3 AF 20 00 A6 AF 21 28 00 00 21 30 00 00 ?? ?? ?? ?? 21 38 40 00 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_430_13_0 {
	meta:
		name = "re_match"
		size = 84
		refs = "0000 _gp_disp 0040 byte_re_match_2_internal"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D0 FF BD 27 ?? ?? 99 8F 40 00 A3 8F 21 10 A0 00 2C 00 BF AF 20 00 BC AF 10 00 A6 AF 14 00 A7 AF 18 00 A3 AF 1C 00 A6 AF 21 28 00 00 21 30 00 00 ?? ?? 39 27 ?? ?? ?? ?? 21 38 40 00 2C 00 BF 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_430_15_0 {
	meta:
		name = "re_compile_pattern"
		size = 132
		refs = "0000 _gp_disp 0034 re_syntax_options 0040 byte_regex_compile"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 1C 00 C2 90 01 00 03 24 ?? ?? 99 8F 44 10 02 7C 04 21 02 7C C4 39 62 7C 1C 00 C2 A0 ?? ?? 82 8F 21 38 C0 00 ?? ?? 39 27 ?? ?? ?? ?? 00 00 46 8C 0A 00 40 10 10 00 BC 8F ?? ?? 83 8F 40 10 02 00 ?? ?? 63 24 21 10 43 00 00 00 43 94 ?? ?? 82 8F ?? ?? 42 24 02 00 00 10 21 10 43 00 21 10 00 00 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_430_16_0 {
	meta:
		name = "re_comp"
		size = 300
		refs = "0000 _gp_disp 003c $LC2 0050 malloc 0060 __GI_strlen 0080 re_syntax_options 0090 byte_regex_compile"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D8 FF BD 27 10 00 BC AF 1C 00 B1 AF 18 00 B0 AF 24 00 BF AF 20 00 B2 AF 21 88 80 00 07 00 80 14 ?? ?? 90 8F ?? ?? 03 8E 37 00 60 14 21 10 00 00 ?? ?? 82 8F 34 00 00 10 ?? ?? 42 24 ?? ?? 02 8E 1D 00 40 10 ?? ?? 99 8F ?? ?? 10 26 1C 00 02 92 01 00 03 24 ?? ?? 99 8F C4 39 62 7C 21 20 20 02 ?? ?? ?? ?? 1C 00 02 A2 10 00 BC 8F 21 28 40 00 21 20 20 02 ?? ?? 82 8F ?? ?? 99 8F 21 38 00 02 ?? ?? 39 27 ?? ?? ?? ?? 00 00 46 8C 1D 00 40 10 10 00 BC 8F ?? ?? 83 8F 40 10 02 00 ?? ?? 63 24 21 10 43 00 00 00 43 94 ?? ?? 82 8F ?? ?? 42 24 15 00 00 10 21 10 43 00 ?? ?? ?? ?? C8 00 04 24 ?? ?? 02 AE 04 00 40 14 10 00 BC 8F ?? ?? 82 8F 0D 00 00 10 ?? ?? 42 24 ?? ?? 99 8F ?? ?? 12 26 C8 00 02 24 04 00 42 AE ?? ?? ?? ?? 00 01 04 24 10 00 42 AE D4 FF 40 14 10 00 BC 8F F4 FF 00 10 ?? ?? 82 8F 21 10 00 00 24 00 BF 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_430_17_0 {
	meta:
		name = "re_exec"
		size = 104
		refs = "0000 _gp_disp 000c __GI_strlen 0038 re_search"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F D8 FF BD 27 24 00 BF AF 20 00 B0 AF 18 00 BC AF ?? ?? ?? ?? 21 80 80 00 18 00 BC 8F 21 28 00 02 10 00 A2 AF ?? ?? 84 8F ?? ?? 99 8F 14 00 A0 AF ?? ?? 84 24 21 30 40 00 ?? ?? ?? ?? 21 38 00 00 24 00 BF 8F 27 10 02 00 20 00 B0 8F C2 17 02 00 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_430_18_0 {
	meta:
		name = "regcomp"
		size = 456
		refs = "0000 _gp_disp 0050 malloc 0090 __GI___ctype_b 0094 __GI___ctype_tolower 0118 __GI_strlen 0148 byte_regex_compile 0174 byte_re_compile_fastmap 0188 free"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D0 FF BD 27 01 00 C2 30 10 00 BC AF 28 00 B3 AF 24 00 B2 AF 1C 00 B0 AF 2C 00 BF AF 20 00 B1 AF 21 80 80 00 21 98 A0 00 04 00 40 10 21 90 C0 00 03 00 11 3C 03 00 00 10 FC B2 31 36 01 01 11 3C C6 02 31 26 ?? ?? 99 8F 00 00 00 AE 04 00 00 AE 08 00 00 AE ?? ?? ?? ?? 00 01 04 24 10 00 02 AE 02 00 42 32 1C 00 40 10 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 00 01 04 24 14 00 02 AE 45 00 40 10 10 00 BC 8F ?? ?? 87 8F ?? ?? 88 8F 21 10 00 00 00 01 05 24 00 00 E3 8C 40 20 02 00 14 00 06 8E 21 18 64 00 00 00 69 94 21 30 C2 00 01 00 29 31 04 00 20 11 20 1C 02 7C 00 00 03 8D 21 20 64 00 00 00 83 80 01 00 42 24 F2 FF 45 14 00 00 C3 A0 03 00 00 10 04 00 43 32 14 00 00 AE 04 00 43 32 07 00 60 10 1C 00 02 92 BF FF 03 24 24 88 23 02 01 00 03 24 00 01 31 36 02 00 00 10 C4 39 62 7C C4 39 02 7C 1C 00 02 A2 1C 00 02 92 ?? ?? 99 8F C0 00 52 7E 04 21 42 7E 21 20 60 02 ?? ?? ?? ?? 1C 00 02 A2 10 00 BC 8F 21 20 60 02 21 28 40 00 ?? ?? 99 8F 21 30 20 02 ?? ?? 39 27 ?? ?? ?? ?? 21 38 00 02 10 00 03 24 14 00 43 10 10 00 BC 8F 14 00 40 14 2C 00 BF 8F 10 00 02 8E 0B 00 40 10 ?? ?? 99 8F ?? ?? 39 27 ?? ?? ?? ?? 21 20 00 02 FE FF 03 24 05 00 43 14 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 10 00 04 8E 10 00 00 AE 04 00 00 10 21 10 00 00 02 00 00 10 0C 00 02 24 08 00 02 24 2C 00 BF 8F 28 00 B3 8F 24 00 B2 8F 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_430_19_0 {
	meta:
		name = "__GI_regexec"
		size = 412
		refs = "0000 _gp_disp 000c __GI_strlen 0064 __GI_memcpy 00b4 malloc 00e0 re_search 0118 free"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F 88 FF BD 27 18 00 BC AF 74 00 BF AF 70 00 B7 AF 6C 00 B6 AF 21 B8 80 00 68 00 B5 AF 21 20 A0 00 64 00 B4 AF 60 00 B3 AF 5C 00 B2 AF 58 00 B1 AF 54 00 B0 AF 88 00 B5 8F 21 80 C0 00 21 98 A0 00 ?? ?? ?? ?? 21 B0 E0 00 18 00 BC 8F 1C 00 F1 8E 21 90 40 00 ?? ?? 99 8F 10 00 31 32 2B 10 10 00 20 00 B4 27 0B 10 11 00 21 20 80 02 21 28 E0 02 20 00 06 24 ?? ?? ?? ?? 21 88 40 00 3C 00 A2 93 02 00 03 24 18 00 BC 8F 44 29 A2 7E 40 00 B5 7E 84 31 A2 7E 44 10 62 7C 3C 00 A2 A3 0C 00 20 12 21 10 00 00 ?? ?? 99 8F 40 00 B0 AF ?? ?? ?? ?? C0 20 10 00 44 00 A2 AF 28 00 40 10 18 00 BC 8F 80 18 10 00 21 10 43 00 48 00 A2 AF 40 00 A2 27 ?? ?? 99 8F 10 00 B2 AF 21 30 40 02 14 00 A2 AF 21 20 80 02 21 28 60 02 ?? ?? ?? ?? 21 38 00 00 21 90 40 00 17 00 20 12 18 00 BC 8F 44 00 A4 8F 06 00 41 04 21 18 00 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 12 00 00 10 C2 17 12 00 2B 10 70 00 F9 FF 40 10 80 28 03 00 21 30 85 00 00 00 C6 8C C0 10 03 00 21 10 C2 02 00 00 46 AC 48 00 A6 8F 01 00 63 24 21 28 C5 00 00 00 A5 8C F3 FF 00 10 04 00 45 AC 02 00 00 10 C2 17 12 00 01 00 02 24 74 00 BF 8F 70 00 B7 8F 6C 00 B6 8F 68 00 B5 8F 64 00 B4 8F 60 00 B3 8F 5C 00 B2 8F 58 00 B1 8F 54 00 B0 8F 08 00 E0 03 78 00 BD 27 }
	condition:
		$1
}

rule file_430_20_0 {
	meta:
		name = "regerror"
		size = 208
		refs = "0000 _gp_disp 0030 __GI_abort 0050 __GI_strlen 0088 __GI_memcpy"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D0 FF BD 27 11 00 82 2C 10 00 BC AF 2C 00 BF AF 28 00 B2 AF 24 00 B1 AF 20 00 B0 AF 04 00 40 14 ?? ?? 82 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 40 20 04 00 ?? ?? 85 8F ?? ?? 42 24 21 20 82 00 00 00 82 94 ?? ?? 99 8F ?? ?? A5 24 21 28 A2 00 21 20 A0 00 18 00 A5 AF 21 80 C0 00 ?? ?? ?? ?? 21 90 E0 00 01 00 51 24 10 00 BC 8F 0E 00 40 12 18 00 A5 8F 2B 10 51 02 08 00 40 10 ?? ?? 99 8F FF FF 52 26 21 30 40 02 21 20 00 02 ?? ?? ?? ?? 21 90 12 02 04 00 00 10 00 00 40 A2 21 20 00 02 ?? ?? ?? ?? 21 30 20 02 2C 00 BF 8F 21 10 20 02 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_430_21_0 {
	meta:
		name = "__GI_regfree"
		size = 124
		refs = "0000 _gp_disp 0020 free"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 1C 00 BF AF 18 00 B0 AF 10 00 BC AF 21 80 80 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 84 8C 10 00 BC 8F 10 00 04 8E 00 00 00 AE ?? ?? 99 8F 04 00 00 AE ?? ?? ?? ?? 08 00 00 AE 10 00 BC 8F 1C 00 02 92 14 00 04 8E ?? ?? 99 8F C4 18 02 7C 1C 00 02 A2 ?? ?? ?? ?? 10 00 00 AE 1C 00 BF 8F 14 00 00 AE 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_431_0_0 {
	meta:
		name = "feof"
		size = 152
		refs = "0000 _gp_disp 0030 _pthread_cleanup_push_defer 0034 __pthread_mutex_unlock 004c __pthread_mutex_lock 006c _pthread_cleanup_pop_restore"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 C8 FF BD 27 28 00 B0 AF 10 00 BC AF 34 00 BF AF 30 00 B2 AF 2C 00 B1 AF 34 00 91 8C 0C 00 20 16 21 80 80 00 ?? ?? 99 8F ?? ?? 85 8F 38 00 92 24 21 30 40 02 ?? ?? ?? ?? 18 00 A4 27 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 40 02 10 00 BC 8F 00 00 10 96 04 00 10 32 05 00 20 16 FF FF 10 32 ?? ?? 99 8F 18 00 A4 27 ?? ?? ?? ?? 01 00 05 24 34 00 BF 8F 21 10 00 02 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_432_0_0 {
	meta:
		name = "getw"
		size = 72
		refs = "0000 _gp_disp 000c __GI_fread_unlocked"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F D8 FF BD 27 21 38 80 00 18 00 A4 27 10 00 BC AF 24 00 BF AF 04 00 05 24 ?? ?? ?? ?? 01 00 06 24 02 00 40 14 18 00 A2 8F FF FF 02 24 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_433_0_0 {
	meta:
		name = "__GI_chdir"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF AC 0F 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_434_0_0 {
	meta:
		name = "ftok"
		size = 96
		refs = "0000 _gp_disp 000c __GI_stat"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F 48 FF BD 27 B0 00 B0 AF 10 00 BC AF B4 00 BF AF 21 80 A0 00 ?? ?? ?? ?? 18 00 A5 27 07 00 40 04 18 00 A2 93 28 00 A3 97 00 86 10 00 00 14 02 00 25 10 43 00 02 00 00 10 25 10 50 00 FF FF 02 24 B4 00 BF 8F B0 00 B0 8F 08 00 E0 03 B8 00 BD 27 }
	condition:
		$1
}

rule file_436_0_0 {
	meta:
		name = "__GI_fgetwc"
		size = 160
		refs = "0000 _gp_disp 0030 _pthread_cleanup_push_defer 0034 __pthread_mutex_unlock 004c __pthread_mutex_lock 005c __GI_fgetwc_unlocked 0070 _pthread_cleanup_pop_restore"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 C0 FF BD 27 30 00 B0 AF 10 00 BC AF 3C 00 BF AF 38 00 B2 AF 34 00 B1 AF 34 00 91 8C 0C 00 20 16 21 80 80 00 ?? ?? 99 8F ?? ?? 85 8F 38 00 92 24 21 30 40 02 ?? ?? ?? ?? 18 00 A4 27 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 40 02 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 00 02 07 00 20 16 10 00 BC 8F ?? ?? 99 8F 28 00 A2 AF 18 00 A4 27 ?? ?? ?? ?? 01 00 05 24 28 00 A2 8F 3C 00 BF 8F 38 00 B2 8F 34 00 B1 8F 30 00 B0 8F 08 00 E0 03 40 00 BD 27 }
	condition:
		$1
}

rule file_486_0_0 {
	meta:
		name = "__GI_fileno"
		size = 160
		refs = "0000 _gp_disp 0030 _pthread_cleanup_push_defer 0034 __pthread_mutex_unlock 004c __pthread_mutex_lock 005c __GI_fileno_unlocked 0070 _pthread_cleanup_pop_restore"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 C0 FF BD 27 30 00 B0 AF 10 00 BC AF 3C 00 BF AF 38 00 B2 AF 34 00 B1 AF 34 00 91 8C 0C 00 20 16 21 80 80 00 ?? ?? 99 8F ?? ?? 85 8F 38 00 92 24 21 30 40 02 ?? ?? ?? ?? 18 00 A4 27 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 40 02 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 00 02 07 00 20 16 10 00 BC 8F ?? ?? 99 8F 28 00 A2 AF 18 00 A4 27 ?? ?? ?? ?? 01 00 05 24 28 00 A2 8F 3C 00 BF 8F 38 00 B2 8F 34 00 B1 8F 30 00 B0 8F 08 00 E0 03 40 00 BD 27 }
	condition:
		$1
}

rule file_437_0_0 {
	meta:
		name = "confstr"
		size = 172
		refs = "0000 _gp_disp 0020 __GI___errno_location 0058 __GI_memcpy 0060 $LC0"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 05 00 80 14 ?? ?? 99 8F 1D 00 C0 10 0E 00 02 24 07 00 00 10 00 00 00 00 ?? ?? ?? ?? 00 00 00 00 16 00 03 24 00 00 43 AC 15 00 00 10 21 10 00 00 12 00 A0 10 0E 00 C2 2C 08 00 40 14 ?? ?? 99 8F 21 20 A0 00 ?? ?? 85 8F 0E 00 06 24 ?? ?? ?? ?? ?? ?? A5 24 0A 00 00 10 0E 00 02 24 21 20 A0 00 ?? ?? 85 8F FF FF D0 24 21 30 00 02 ?? ?? ?? ?? ?? ?? A5 24 21 18 50 00 00 00 60 A0 0E 00 02 24 1C 00 BF 8F 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_438_0_0 {
	meta:
		name = "wcscpy"
		size = 36
	strings:
		$1 = { 21 10 80 00 21 18 80 00 00 00 A4 8C 04 00 63 24 04 00 A5 24 FC FF 80 14 FC FF 64 AC 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_439_0_0 {
	meta:
		name = "__GI_gethostname"
		size = 176
		refs = "0000 _gp_disp 000c __GI_uname 0044 __GI_strlen 0064 __GI___errno_location 007c __GI_strcpy"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F 50 FE BD 27 10 00 BC AF A8 01 B2 AF A4 01 B1 AF AC 01 BF AF A0 01 B0 AF 21 88 80 00 18 00 A4 27 ?? ?? ?? ?? 21 90 A0 00 FF FF 03 24 15 00 43 10 10 00 BC 8F ?? ?? 99 8F 59 00 B0 27 ?? ?? ?? ?? 21 20 00 02 01 00 42 24 2B 90 42 02 07 00 40 12 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 16 00 03 24 07 00 00 10 00 00 43 AC ?? ?? 99 8F 21 20 20 02 ?? ?? ?? ?? 21 28 00 02 02 00 00 10 21 10 00 00 FF FF 02 24 AC 01 BF 8F A8 01 B2 8F A4 01 B1 8F A0 01 B0 8F 08 00 E0 03 B0 01 BD 27 }
	condition:
		$1
}

rule file_441_0_0 {
	meta:
		name = "_ppfs_prepargs"
		size = 96
		refs = "0000 _gp_disp 0030 _ppfs_setargs"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D8 FF BD 27 20 00 B1 AF 18 00 91 8C 10 00 BC AF 1C 00 B0 AF 24 00 BF AF 21 80 80 00 08 00 20 1A 4C 00 85 AC ?? ?? 99 8F 1C 00 91 AC 18 00 80 AC 04 00 80 AC ?? ?? ?? ?? 08 00 80 AC 18 00 11 AE 24 00 BF 8F 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_442_0_0 {
	meta:
		name = "__time_localtime_tzi"
		size = 940
		refs = "0000 _gp_disp 0094 _time_t2tm 00b8 ll_tzname_UTC 00bc __GI_strcmp 0100 __GI_strnlen 011c ll_tzname_UNKNOWN 0128 malloc 0140 __GI_strcpy"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 B0 FF BD 27 34 00 B3 AF ?? ?? 93 8F 3C 00 B5 AF F6 7F 15 3C ?? ?? 73 26 40 00 B6 AF 38 00 B4 AF 30 00 B2 AF 2C 00 B1 AF 28 00 B0 AF 10 00 BC AF 4C 00 BF AF 48 00 BE AF 44 00 B7 AF 21 A0 80 00 21 80 A0 00 21 90 C0 00 21 88 00 00 80 C5 B5 36 21 B0 60 02 18 00 17 24 02 10 37 72 09 00 03 3C 80 3A 63 34 21 B8 52 00 00 00 E2 8E 23 10 62 00 00 00 83 8E 2A 20 75 00 03 00 80 14 F9 FF 05 24 23 10 02 00 07 00 05 24 ?? ?? 99 8F 21 10 62 00 18 00 A2 AF 18 00 A4 27 ?? ?? ?? ?? 21 30 00 02 10 00 BC 8F 20 00 11 AE 00 00 E2 8E ?? ?? 83 8F ?? ?? 99 8F 23 10 02 00 24 00 02 AE 10 00 F7 26 04 00 7E 24 20 00 A3 AF 24 00 B9 AF 21 20 C0 03 09 F8 20 03 21 28 E0 02 10 00 BC 8F 20 00 A3 8F 1C 00 40 10 24 00 B9 8F 00 00 63 8C F5 FF 60 54 04 00 7E 24 ?? ?? 99 8F 21 20 E0 02 ?? ?? ?? ?? 07 00 05 24 10 00 BC 8F 07 00 43 28 03 00 60 14 ?? ?? 9E 8F 10 00 00 10 04 00 C2 27 ?? ?? 99 8F ?? ?? ?? ?? 08 00 44 24 FA FF 40 10 10 00 BC 8F 00 00 C3 8F ?? ?? 99 8F 00 00 C2 AF 00 00 43 AC 04 00 44 24 ?? ?? ?? ?? 21 28 E0 02 02 00 00 10 10 00 BC 8F 21 10 C0 03 28 00 02 AE 01 00 31 26 01 00 02 24 82 00 22 16 4C 00 BF 8F 28 00 42 82 7B 00 40 10 21 20 00 00 1C 00 03 8E 18 00 09 24 08 00 02 8E 02 20 23 71 04 00 03 8E 21 48 82 00 3C 00 02 24 02 20 22 71 21 48 83 00 02 20 22 71 00 00 03 8E 21 48 83 00 14 00 03 8E 90 01 04 24 1A 00 64 00 F4 01 80 00 10 18 00 00 6C 07 62 24 03 00 46 30 0B 00 C0 14 21 28 00 00 64 00 05 24 1A 00 45 00 F4 01 A0 00 10 30 00 00 05 00 C0 14 01 00 05 24 1A 00 44 00 F4 01 80 00 10 28 00 00 01 00 A5 2C 6B 07 63 24 9C FF 06 24 1A 00 66 00 F4 01 C0 00 83 38 03 00 90 01 06 24 21 38 47 00 07 00 04 24 01 00 0E 3C 21 60 00 00 4A 00 18 24 4D 00 19 24 1F 00 17 24 07 00 0A 24 80 51 CE 25 01 00 0D 24 12 10 00 00 21 10 E2 00 21 38 00 00 1A 00 66 00 F4 01 C0 00 12 78 00 00 21 78 4F 00 21 10 40 02 1A 00 E4 01 F4 01 80 00 21 20 00 00 10 78 00 00 0E 00 46 84 08 00 D8 14 08 00 43 84 28 00 A0 50 FF FF 63 24 3C 00 66 28 25 00 C0 10 00 00 00 00 23 00 00 10 FF FF 63 24 21 00 D9 14 00 00 00 00 0C 00 48 84 21 30 13 01 FF FF CB 90 02 30 17 71 04 00 A0 10 23 30 CB 00 3B 00 DE 28 01 00 DE 2F 21 30 DE 00 21 F0 C8 02 00 00 DE 93 1F 00 6B 25 04 00 A0 10 23 58 7E 01 02 00 08 29 01 00 08 2D 21 58 68 01 21 40 E6 01 1A 00 0A 01 F4 01 40 01 10 F0 00 00 23 18 7E 00 F9 FF 68 24 00 00 7E 28 0A 18 1E 01 0A 00 48 84 02 F0 0A 71 21 18 C3 03 2A 58 6B 00 F9 FF 68 24 0A 18 0B 01 21 18 C3 00 08 00 E0 10 02 40 6E 70 E8 FF 48 8C 00 00 46 8C 2A 60 6C 00 21 20 8C 00 23 30 06 01 21 48 26 01 02 40 6E 70 04 00 46 8C 01 00 E7 24 18 00 42 24 21 30 06 01 2A 30 26 01 01 00 C6 2C 03 00 ED 14 21 20 86 00 C2 FF 00 10 21 60 60 00 01 00 84 30 3B FF 80 14 20 00 04 AE 4C 00 BF 8F 21 10 00 02 48 00 BE 8F 44 00 B7 8F 40 00 B6 8F 3C 00 B5 8F 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 E0 03 50 00 BD 27 }
	condition:
		$1
}

rule file_444_0_0 {
	meta:
		name = "erand48"
		size = 60
		refs = "0000 _gp_disp 000c __libc_drand48_data 0010 __GI_erand48_r"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 85 8F ?? ?? 99 8F D8 FF BD 27 24 00 BF AF 10 00 BC AF ?? ?? ?? ?? 18 00 A6 27 24 00 BF 8F 18 00 A2 8F 1C 00 A3 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_445_0_0 {
	meta:
		name = "mktemp"
		size = 72
		refs = "0000 _gp_disp 000c __gen_tempname"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F E0 FF BD 27 03 00 05 24 18 00 B0 AF 10 00 BC AF 1C 00 BF AF ?? ?? ?? ?? 21 80 80 00 01 00 42 04 00 00 00 A2 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_446_0_0 {
	meta:
		name = "__syscall_pwrite.constprop.0"
		size = 112
		refs = "0000 _gp_disp 0048 __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 18 00 B0 AF 21 10 E0 00 1C 00 BF AF 21 38 00 00 30 00 B0 8F E0 FF BD 27 10 00 A2 AF 14 00 B0 AF 69 10 02 24 0C 00 00 00 20 00 BD 27 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_446_1_0 {
	meta:
		name = "__syscall_pread.constprop.1"
		size = 112
		refs = "0000 _gp_disp 0048 __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 18 00 B0 AF 21 10 E0 00 1C 00 BF AF 21 38 00 00 30 00 B0 8F E0 FF BD 27 10 00 A2 AF 14 00 B0 AF 68 10 02 24 0C 00 00 00 20 00 BD 27 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_446_2_0 {
	meta:
		name = "__libc_pread"
		size = 60
		refs = "0000 _gp_disp 0028 __syscall_pread.constprop.1"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F D8 FF BD 27 C3 17 07 00 ?? ?? 39 27 24 00 BF AF 18 00 BC AF 10 00 A2 AF ?? ?? ?? ?? 00 00 00 00 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_446_4_0 {
	meta:
		name = "__libc_pwrite"
		size = 60
		refs = "0000 _gp_disp 0028 __syscall_pwrite.constprop.0"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F D8 FF BD 27 C3 17 07 00 ?? ?? 39 27 24 00 BF AF 18 00 BC AF 10 00 A2 AF ?? ?? ?? ?? 00 00 00 00 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_446_3_0 {
	meta:
		name = "__libc_pread64"
		size = 36
		refs = "0000 _gp_disp 001c __syscall_pread.constprop.1"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 14 00 A2 8F ?? ?? 99 8F 10 00 A7 8F ?? ?? 39 27 ?? ?? ?? ?? 10 00 A2 AF }
	condition:
		$1
}

rule file_446_5_0 {
	meta:
		name = "__libc_pwrite64"
		size = 36
		refs = "0000 _gp_disp 001c __syscall_pwrite.constprop.0"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 14 00 A2 8F ?? ?? 99 8F 10 00 A7 8F ?? ?? 39 27 ?? ?? ?? ?? 10 00 A2 AF }
	condition:
		$1
}

rule file_447_0_0 {
	meta:
		name = "__GI_fstat"
		size = 120
		refs = "0000 _gp_disp 0034 __GI___errno_location 0054 __xstat_conv"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 50 FF BD 27 10 00 BC AF 21 30 A0 00 AC 00 BF AF A8 00 B0 AF 18 00 A5 27 0C 10 02 24 0C 00 00 00 07 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC 07 00 00 10 FF FF 10 24 06 00 40 14 AC 00 BF 8F ?? ?? 99 8F 18 00 A4 27 ?? ?? ?? ?? 21 28 C0 00 AC 00 BF 8F 21 10 00 02 A8 00 B0 8F 08 00 E0 03 B0 00 BD 27 }
	condition:
		$1
}

rule file_448_0_0 {
	meta:
		name = "truncate64"
		size = 88
		refs = "0000 _gp_disp 0030 __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 21 28 00 00 73 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_449_0_0 {
	meta:
		name = "__GI_connect"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 4A 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_450_0_0 {
	meta:
		name = "putchar_unlocked"
		size = 72
		refs = "0000 _gp_disp 000c stdout 003c __GI___fputc_unlocked"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 83 8F 00 00 65 8C 10 00 A3 8C 1C 00 A6 8C 2B 30 66 00 06 00 C0 10 21 10 80 00 01 00 64 24 10 00 A4 AC 00 00 62 A0 08 00 E0 03 FF 00 42 30 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_451_0_0 {
	meta:
		name = "_create_xid"
		size = 232
		refs = "0000 _gp_disp 0018 _pthread_cleanup_push_defer 001c __pthread_mutex_unlock 004c __pthread_mutex_lock 006c __GI_gettimeofday 0088 __GI_srand48_r 00a4 __GI_lrand48_r 00bc _pthread_cleanup_pop_restore"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 B8 FF BD 27 38 00 B1 AF ?? ?? 91 8F ?? ?? 99 8F ?? ?? 85 8F 34 00 B0 AF 18 00 B0 27 10 00 BC AF ?? ?? 26 26 44 00 BF AF 40 00 B3 AF 3C 00 B2 AF ?? ?? ?? ?? 21 20 00 02 10 00 BC 8F ?? ?? 24 26 ?? ?? 99 8F ?? ?? ?? ?? 28 00 B2 27 10 00 BC 8F ?? ?? 93 8F ?? ?? 62 8E 0F 00 40 14 ?? ?? 91 8F ?? ?? 99 8F 21 20 40 02 ?? ?? ?? ?? 21 28 00 00 10 00 BC 8F 28 00 A2 8F 2C 00 A4 8F ?? ?? 99 8F ?? ?? 25 26 ?? ?? ?? ?? 26 20 82 00 10 00 BC 8F 01 00 02 24 ?? ?? 62 AE ?? ?? 99 8F ?? ?? 24 26 ?? ?? ?? ?? 21 28 40 02 10 00 BC 8F 21 20 00 02 ?? ?? 99 8F ?? ?? ?? ?? 01 00 05 24 44 00 BF 8F 28 00 A2 8F 40 00 B3 8F 3C 00 B2 8F 38 00 B1 8F 34 00 B0 8F 08 00 E0 03 48 00 BD 27 }
	condition:
		$1
}

rule file_452_0_0 {
	meta:
		name = "pmap_getmaps"
		size = 252
		refs = "0000 _gp_disp 0034 __GI_clnttcp_create 0078 __GI_xdr_pmaplist 0080 __GI_xdr_void 00c0 __GI_clnt_perror 00bc $LC0"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 B8 FF BD 27 FF FF 02 24 30 00 A2 AF 3C 00 02 24 20 00 BC AF 28 00 A2 AF 00 6F 02 24 40 00 B1 AF 3C 00 B0 AF 44 00 BF AF ?? ?? 99 8F 02 00 82 A4 32 00 02 24 10 00 A2 AF 01 00 05 3C F4 01 02 24 34 00 A0 AF 2C 00 A0 AF 14 00 A2 AF A0 86 A5 34 02 00 06 24 30 00 A7 27 ?? ?? ?? ?? 21 88 80 00 21 80 40 00 1B 00 40 10 20 00 BC 8F ?? ?? 83 8F 04 00 42 8C ?? ?? 86 8F 10 00 A3 AF 34 00 A3 27 14 00 A3 AF 28 00 A3 8F 21 20 00 02 04 00 05 24 18 00 A3 AF 2C 00 A3 8F 1C 00 A3 AF 00 00 59 8C 09 F8 20 03 21 38 00 00 06 00 40 10 20 00 BC 8F ?? ?? 85 8F ?? ?? 99 8F 21 20 00 02 ?? ?? ?? ?? ?? ?? A5 24 04 00 02 8E 10 00 59 8C 09 F8 20 03 21 20 00 02 44 00 BF 8F 34 00 A2 8F 3C 00 B0 8F 02 00 20 A6 40 00 B1 8F 08 00 E0 03 48 00 BD 27 }
	condition:
		$1
}

rule file_454_0_0 {
	meta:
		name = "__GI_mremap"
		size = 100
		refs = "0000 _gp_disp 003c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 30 00 A2 8F E0 FF BD 27 10 00 A2 AF 47 10 02 24 0C 00 00 00 20 00 BD 27 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_456_0_0 {
	meta:
		name = "quotactl"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 23 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_457_0_0 {
	meta:
		name = "__GI_lfind"
		size = 112
	strings:
		$1 = { 00 00 C2 8C D0 FF BD 27 24 00 B2 AF 20 00 B1 AF 1C 00 B0 AF 2C 00 BF AF 28 00 B3 AF 21 88 80 00 21 80 A0 00 21 90 E0 00 0A 00 40 10 FF FF 53 24 40 00 B9 8F 21 20 20 02 09 F8 20 03 21 28 00 02 03 00 40 10 21 10 60 02 F7 FF 00 10 21 80 12 02 21 10 00 02 2C 00 BF 8F 28 00 B3 8F 24 00 B2 8F 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_458_0_0 {
	meta:
		name = "__GI_execv"
		size = 28
		refs = "0000 _gp_disp 000c __environ 0010 __GI_execve"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 46 8C }
	condition:
		$1
}

rule file_461_0_0 {
	meta:
		name = "ptrace"
		size = 160
		refs = "0000 _gp_disp 0054 __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D0 FF BD 27 34 00 A2 27 28 00 B1 AF FF FF 91 24 10 00 BC AF 18 00 A2 AF 03 00 31 2E 1C 00 A2 27 3C 00 A7 AF 2C 00 BF AF 24 00 B0 AF 34 00 A5 AF 38 00 A6 AF 0B 38 51 00 BA 0F 02 24 0C 00 00 00 07 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC 09 00 00 10 FF FF 02 24 08 00 00 06 2C 00 BF 8F 06 00 20 12 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 40 AC 1C 00 A2 8F 2C 00 BF 8F 28 00 B1 8F 24 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_463_0_0 {
	meta:
		name = "tcflow"
		size = 28
		refs = "0000 _gp_disp 000c __GI_ioctl"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F 21 30 A0 00 ?? ?? ?? ?? 06 54 05 24 }
	condition:
		$1
}

rule file_464_0_0 {
	meta:
		name = "__GI_wcschr"
		size = 36
	strings:
		$1 = { 00 00 82 8C 05 00 45 10 00 00 00 00 FC FF 40 14 04 00 84 24 08 00 E0 03 00 00 00 00 08 00 E0 03 21 10 80 00 }
	condition:
		$1
}

rule file_465_0_0 {
	meta:
		name = "__ether_line"
		size = 156
		refs = "0000 _gp_disp 000c __GI_ether_aton_r"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F E0 FF BD 27 18 00 B0 AF 10 00 BC AF 1C 00 BF AF ?? ?? ?? ?? 21 80 80 00 DF FF 04 24 16 00 40 10 09 00 03 24 00 00 02 82 24 28 44 00 20 2C 05 7C 05 00 A0 50 20 00 04 24 03 00 43 50 20 00 04 24 F8 FF 00 10 01 00 10 26 09 00 03 24 00 00 02 82 0A 00 40 50 21 10 00 00 03 00 44 14 00 00 00 00 FA FF 00 10 01 00 10 26 F8 FF 43 50 01 00 10 26 02 00 00 10 21 10 00 02 21 10 00 00 1C 00 BF 8F 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_465_1_0 {
	meta:
		name = "__ether_line_w"
		size = 136
		refs = "0000 _gp_disp 0014 __GI_strchr 0080 __ether_line"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D8 FF BD 27 1C 00 B1 AF ?? ?? 91 8F 10 00 BC AF 20 00 B2 AF 18 00 B0 AF 24 00 BF AF 21 90 A0 00 21 C8 20 02 23 00 05 24 ?? ?? ?? ?? 21 80 80 00 07 00 40 14 10 00 BC 8F 21 20 00 02 21 C8 20 02 ?? ?? ?? ?? 0A 00 05 24 02 00 40 10 10 00 BC 8F 00 00 40 A0 ?? ?? 99 8F 24 00 BF 8F 1C 00 B1 8F 21 20 00 02 21 28 40 02 18 00 B0 8F 20 00 B2 8F ?? ?? 39 27 ?? ?? ?? ?? 28 00 BD 27 }
	condition:
		$1
}

rule file_465_2_0 {
	meta:
		name = "ether_line"
		size = 152
		refs = "0000 _gp_disp 0024 __ether_line 0034 __GI___ctype_b"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F E0 FF BD 27 10 00 BC AF 18 00 B0 AF 1C 00 BF AF ?? ?? 39 27 ?? ?? ?? ?? 21 80 C0 00 15 00 40 10 10 00 BC 8F ?? ?? 85 8F 23 00 04 24 00 00 43 80 0E 00 60 50 00 00 00 A2 0B 00 64 10 40 30 03 00 00 00 A7 8C 21 30 E6 00 00 00 C6 94 20 00 C6 30 06 00 C0 54 00 00 00 A2 00 00 03 A2 01 00 42 24 F2 FF 00 10 01 00 10 26 00 00 00 A2 02 00 00 10 21 10 00 00 FF FF 02 24 1C 00 BF 8F 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_465_3_0 {
	meta:
		name = "ether_ntohost"
		size = 308
		refs = "0000 _gp_disp 0028 __GI_fopen 0024 $LC0 0020 $LC1 0068 __GI_fgets 0070 __GI_memcmp 00a0 __ether_line_w 00cc __GI_strcpy 00ec __GI_fclose"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 B8 FE BD 27 38 01 B6 AF 34 01 B5 AF 21 B0 A0 00 21 A8 80 00 ?? ?? 85 8F ?? ?? 84 8F ?? ?? 99 8F 10 00 BC AF 20 01 B0 AF 44 01 BF AF 40 01 BE AF 3C 01 B7 AF 30 01 B4 AF 2C 01 B3 AF 28 01 B2 AF 24 01 B1 AF ?? ?? 84 24 ?? ?? ?? ?? ?? ?? A5 24 21 80 40 00 27 00 40 10 10 00 BC 8F ?? ?? 94 8F ?? ?? 97 8F ?? ?? 9E 8F 18 00 B1 27 18 01 B2 27 21 20 20 02 00 01 05 24 21 C8 80 02 ?? ?? ?? ?? 21 30 00 02 15 00 40 10 10 00 BC 8F 21 20 20 02 ?? ?? F9 26 ?? ?? ?? ?? 21 28 40 02 F4 FF 40 10 21 98 40 00 21 20 C0 02 21 28 40 02 21 C8 C0 03 ?? ?? ?? ?? 06 00 06 24 ED FF 40 14 10 00 BC 8F ?? ?? 99 8F 21 20 A0 02 ?? ?? ?? ?? 21 28 60 02 21 88 00 00 02 00 00 10 10 00 BC 8F FF FF 11 24 ?? ?? 99 8F ?? ?? ?? ?? 21 20 00 02 02 00 00 10 21 10 20 02 FF FF 02 24 44 01 BF 8F 40 01 BE 8F 3C 01 B7 8F 38 01 B6 8F 34 01 B5 8F 30 01 B4 8F 2C 01 B3 8F 28 01 B2 8F 24 01 B1 8F 20 01 B0 8F 08 00 E0 03 48 01 BD 27 }
	condition:
		$1
}

rule file_465_4_0 {
	meta:
		name = "ether_hostton"
		size = 260
		refs = "0000 _gp_disp 0028 __GI_fopen 0024 $LC0 0020 $LC1 0060 __GI_fgets 0068 __GI_strcasecmp 0094 __ether_line_w 00c4 __GI_fclose"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 C8 FE BD 27 28 01 B4 AF 24 01 B3 AF 21 A0 A0 00 21 98 80 00 ?? ?? 85 8F ?? ?? 84 8F ?? ?? 99 8F 10 00 BC AF 18 01 B0 AF 34 01 BF AF 30 01 B6 AF 2C 01 B5 AF 20 01 B2 AF 1C 01 B1 AF ?? ?? 84 24 ?? ?? ?? ?? ?? ?? A5 24 21 80 40 00 1F 00 40 10 10 00 BC 8F ?? ?? 92 8F ?? ?? 95 8F ?? ?? 96 8F 18 00 B1 27 21 20 20 02 00 01 05 24 21 C8 40 02 ?? ?? ?? ?? 21 30 00 02 0E 00 40 10 10 00 BC 8F 21 20 20 02 ?? ?? B9 26 ?? ?? ?? ?? 21 28 80 02 F4 FF 40 10 21 20 60 02 21 C8 C0 02 ?? ?? ?? ?? 21 28 40 00 EF FF 40 14 10 00 BC 8F 02 00 00 10 21 88 00 00 FF FF 11 24 ?? ?? 99 8F ?? ?? ?? ?? 21 20 00 02 02 00 00 10 21 10 20 02 FF FF 02 24 34 01 BF 8F 30 01 B6 8F 2C 01 B5 8F 28 01 B4 8F 24 01 B3 8F 20 01 B2 8F 1C 01 B1 8F 18 01 B0 8F 08 00 E0 03 38 01 BD 27 }
	condition:
		$1
}

rule file_466_0_0 {
	meta:
		name = "_buf"
		size = 92
		refs = "0000 _gp_disp 000c __rpc_thread_variables 0038 malloc"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F E0 FF BD 27 10 00 BC AF 18 00 B0 AF 1C 00 BF AF ?? ?? ?? ?? 00 00 00 00 21 80 40 00 9C 00 42 8C 05 00 40 14 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 00 01 04 24 9C 00 02 AE 1C 00 BF 8F 9C 00 02 8E 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_466_1_0 {
	meta:
		name = "free_mem"
		size = 60
		refs = "0000 _gp_disp 000c __rpc_thread_variables 0030 free"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F E0 FF BD 27 10 00 BC AF 1C 00 BF AF ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F 1C 00 BF 8F 9C 00 44 8C ?? ?? 99 8F ?? ?? ?? ?? 20 00 BD 27 }
	condition:
		$1
}

rule file_466_2_0 {
	meta:
		name = "__GI_clnt_sperrno"
		size = 88
		refs = "0000 _gp_disp 004c $LC0"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 86 8F 21 10 00 00 12 00 05 24 ?? ?? C6 24 C0 18 02 00 21 18 66 00 00 00 67 8C 06 00 E4 54 01 00 42 24 ?? ?? 82 8F 04 00 63 8C ?? ?? 42 24 08 00 E0 03 21 10 43 00 F6 FF 45 14 C0 18 02 00 ?? ?? 82 8F 08 00 E0 03 ?? ?? 42 24 }
	condition:
		$1
}

rule file_466_3_0 {
	meta:
		name = "clnt_perrno"
		size = 68
		refs = "0000 _gp_disp 000c __GI_clnt_sperrno 0030 stderr 0034 __GI_fputs"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F E0 FF BD 27 10 00 BC AF 1C 00 BF AF ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F 21 20 40 00 1C 00 BF 8F ?? ?? 82 8F ?? ?? 99 8F 00 00 45 8C ?? ?? ?? ?? 20 00 BD 27 }
	condition:
		$1
}

rule file_466_5_0 {
	meta:
		name = "__GI_clnt_perror"
		size = 68
		refs = "0000 _gp_disp 000c __GI_clnt_sperror 0030 stderr 0034 __GI_fputs"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F E0 FF BD 27 10 00 BC AF 1C 00 BF AF ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F 21 20 40 00 1C 00 BF 8F ?? ?? 82 8F ?? ?? 99 8F 00 00 45 8C ?? ?? ?? ?? 20 00 BD 27 }
	condition:
		$1
}

rule file_466_7_0 {
	meta:
		name = "clnt_pcreateerror"
		size = 68
		refs = "0000 _gp_disp 000c __GI_clnt_spcreateerror 0030 stderr 0034 __GI_fputs"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F E0 FF BD 27 10 00 BC AF 1C 00 BF AF ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F 21 20 40 00 1C 00 BF 8F ?? ?? 82 8F ?? ?? 99 8F 00 00 45 8C ?? ?? ?? ?? 20 00 BD 27 }
	condition:
		$1
}

rule file_466_4_0 {
	meta:
		name = "__GI_clnt_sperror"
		size = 608
		refs = "0000 _gp_disp 003c _buf 006c __GI_sprintf 0070 $LC1 008c __GI_clnt_sperrno 00a0 __GI_strcpy 00b4 __GI_strlen 0100 __GI___glibc_strerror_r 0120 $LC2 0174 $LC4 01c4 $LC5 01e4 $LC3 0200 $LC6"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F B0 FB BD 27 38 04 B1 AF 34 04 B0 AF 10 00 BC AF 28 04 A4 AF 4C 04 BF AF 48 04 B5 AF 44 04 B4 AF 40 04 B3 AF 3C 04 B2 AF ?? ?? 39 27 ?? ?? ?? ?? 21 80 A0 00 21 88 40 00 7B 00 40 10 28 04 A4 8F 04 00 82 8C 08 00 59 8C 09 F8 20 03 18 04 A5 27 10 00 BC 8F 21 30 00 02 21 20 20 02 ?? ?? 93 8F ?? ?? 85 8F 21 C8 60 02 ?? ?? ?? ?? ?? ?? A5 24 10 00 BC 8F 18 04 A4 8F 21 80 22 02 ?? ?? 99 8F ?? ?? ?? ?? 21 90 60 02 10 00 BC 8F 21 20 00 02 ?? ?? 94 8F 21 C8 80 02 ?? ?? ?? ?? 21 28 40 00 10 00 BC 8F ?? ?? 95 8F 21 C8 A0 02 ?? ?? ?? ?? 21 20 00 02 21 80 02 02 18 04 A2 8F 10 00 BC 8F 12 00 43 2C 4A 00 60 10 21 C8 80 02 ?? ?? 83 8F 80 10 02 00 ?? ?? 63 24 21 10 62 00 00 00 42 8C 21 10 5C 00 08 00 40 00 00 00 00 00 1C 04 A4 8F ?? ?? 99 8F 18 00 B3 27 21 28 60 02 ?? ?? ?? ?? 00 04 06 24 10 00 BC 8F 21 20 00 02 21 30 60 02 ?? ?? 85 8F 2A 00 00 10 ?? ?? A5 24 ?? ?? 86 8F 1C 04 A5 8F 21 10 00 00 ?? ?? C6 24 08 00 04 24 C0 18 02 00 21 18 66 00 00 00 67 8C 06 00 E5 14 01 00 42 24 ?? ?? 93 8F 04 00 62 8C ?? ?? 73 26 04 00 00 10 21 98 62 02 F6 FF 44 14 C0 18 02 00 21 98 00 00 ?? ?? 85 8F 21 20 00 02 ?? ?? ?? ?? ?? ?? A5 24 21 C8 A0 02 ?? ?? ?? ?? 21 20 00 02 21 80 02 02 10 00 BC 8F 0A 00 60 12 21 20 00 02 ?? ?? 99 8F ?? ?? ?? ?? 21 28 60 02 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 00 02 19 00 00 10 21 80 02 02 ?? ?? 85 8F 1C 04 A6 8F ?? ?? A5 24 21 C8 40 02 ?? ?? ?? ?? 00 00 00 00 11 00 00 10 21 80 02 02 ?? ?? 85 8F 21 20 00 02 1C 04 A6 8F ?? ?? A5 24 20 04 A7 8F 07 00 00 10 21 C8 60 02 ?? ?? 85 8F 1C 04 A6 8F 20 04 A7 8F 21 20 00 02 ?? ?? A5 24 21 C8 60 02 ?? ?? ?? ?? 00 00 00 00 21 80 02 02 0A 00 02 24 00 00 02 A2 01 00 00 A2 02 00 00 10 21 10 20 02 21 10 00 00 4C 04 BF 8F 48 04 B5 8F 44 04 B4 8F 40 04 B3 8F 3C 04 B2 8F 38 04 B1 8F 34 04 B0 8F 08 00 E0 03 50 04 BD 27 }
	condition:
		$1
}

rule file_466_6_0 {
	meta:
		name = "__GI_clnt_spcreateerror"
		size = 440
		refs = "0000 _gp_disp 0038 _buf 004c __GI___rpc_thread_createerr 0068 __GI_sprintf 0064 $LC1 0080 __GI_clnt_sperrno 0098 __GI_strcpy 00ac __GI_strlen 00dc $LC7 0144 __GI___glibc_strerror_r"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F C8 FB BD 27 10 00 BC AF 28 04 B3 AF 1C 04 B0 AF 34 04 BF AF 30 04 B5 AF 2C 04 B4 AF 24 04 B2 AF 20 04 B1 AF ?? ?? 39 27 ?? ?? ?? ?? 21 80 80 00 21 98 40 00 52 00 40 10 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F 21 30 00 02 21 20 60 02 ?? ?? 85 8F ?? ?? 99 8F 21 A0 40 00 ?? ?? ?? ?? ?? ?? A5 24 10 00 BC 8F 00 00 84 8E ?? ?? 95 8F 21 C8 A0 02 ?? ?? ?? ?? 21 80 62 02 10 00 BC 8F 21 20 00 02 ?? ?? 92 8F 21 C8 40 02 ?? ?? ?? ?? 21 28 40 00 10 00 BC 8F ?? ?? 91 8F 21 C8 20 02 ?? ?? ?? ?? 21 20 00 02 21 80 02 02 00 00 82 8E 0C 00 03 24 13 00 43 10 10 00 BC 8F 0E 00 03 24 2A 00 43 54 0A 00 02 24 ?? ?? 85 8F 21 20 00 02 21 C8 40 02 ?? ?? ?? ?? ?? ?? A5 24 21 C8 20 02 ?? ?? ?? ?? 21 20 00 02 04 00 84 8E 21 C8 A0 02 ?? ?? ?? ?? 21 80 02 02 21 28 40 00 13 00 00 10 21 20 00 02 ?? ?? 85 8F 21 20 00 02 21 C8 40 02 ?? ?? ?? ?? ?? ?? A5 24 21 C8 20 02 ?? ?? ?? ?? 21 20 00 02 10 00 BC 8F 08 00 84 8E 18 00 B4 27 ?? ?? 99 8F 21 80 02 02 21 28 80 02 ?? ?? ?? ?? 00 04 06 24 21 20 00 02 21 28 80 02 21 C8 40 02 ?? ?? ?? ?? 00 00 00 00 21 C8 20 02 ?? ?? ?? ?? 21 20 00 02 21 80 02 02 0A 00 02 24 00 00 02 A2 01 00 00 A2 02 00 00 10 21 10 60 02 21 10 00 00 34 04 BF 8F 30 04 B5 8F 2C 04 B4 8F 28 04 B3 8F 24 04 B2 8F 20 04 B1 8F 1C 04 B0 8F 08 00 E0 03 38 04 BD 27 }
	condition:
		$1
}

rule file_468_0_0 {
	meta:
		name = "__cxa_finalize"
		size = 196
		refs = "0000 _gp_disp 000c __exit_count 0034 __exit_function_table"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F D0 FF BD 27 28 00 B4 AF 24 00 B3 AF 20 00 B2 AF 1C 00 B1 AF 10 00 BC AF 2C 00 BF AF 18 00 B0 AF 00 00 50 8C ?? ?? 94 8F 21 88 80 00 03 00 12 24 21 98 00 00 17 00 00 12 FF FF 10 26 00 00 83 8E 00 11 10 00 04 00 20 12 21 10 62 00 0C 00 43 8C F8 FF 23 16 00 00 00 00 00 00 44 C0 06 00 92 14 21 18 00 00 21 18 60 02 00 00 43 E0 FA FF 60 10 00 00 00 00 0F 00 00 00 EE FF 60 10 00 00 00 00 04 00 59 8C 09 F8 20 03 08 00 44 8C E9 FF 00 10 00 00 00 00 2C 00 BF 8F 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_469_0_0 {
	meta:
		name = "__GI_wcsrtombs"
		size = 60
		refs = "0000 _gp_disp 000c __GI_wcsnrtombs"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F D8 FF BD 27 21 10 C0 00 FF FF 06 24 24 00 BF AF 18 00 BC AF 10 00 A7 AF ?? ?? ?? ?? 21 38 40 00 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_470_0_0 {
	meta:
		name = "sigpending"
		size = 88
		refs = "0000 _gp_disp 0030 __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 10 00 05 24 64 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_471_0_0 {
	meta:
		name = "lldiv"
		size = 260
		refs = "0000 _gp_disp 0020 __divdi3 0074 __moddi3"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 C0 FF BD 27 20 00 B2 AF 1C 00 B1 AF 50 00 B2 8F 54 00 B1 8F ?? ?? 99 8F 10 00 BC AF 21 28 E0 00 3C 00 BF AF 38 00 BE AF 34 00 B7 AF 30 00 B6 AF 2C 00 B5 AF 28 00 B4 AF 24 00 B3 AF 18 00 B0 AF 21 F0 C0 00 21 A0 E0 00 21 80 80 00 21 38 20 02 21 20 C0 00 ?? ?? ?? ?? 21 30 40 02 10 00 BC 8F 21 20 C0 03 21 28 80 02 ?? ?? 99 8F 21 30 40 02 21 38 20 02 21 98 40 00 21 B8 60 00 21 B0 40 00 ?? ?? ?? ?? 21 A8 60 00 21 28 40 00 09 00 80 06 21 20 60 00 07 00 61 04 23 88 71 00 01 00 76 26 23 28 52 00 2B 98 D3 02 2B 10 45 00 21 A8 77 02 23 20 22 02 3C 00 BF 8F 00 00 16 AE 04 00 15 AE 21 10 00 02 38 00 BE 8F 34 00 B7 8F 30 00 B6 8F 2C 00 B5 8F 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 08 00 05 AE 0C 00 04 AE 18 00 B0 8F 08 00 E0 03 40 00 BD 27 }
	condition:
		$1
}

rule file_472_0_0 {
	meta:
		name = "__GI_sigemptyset"
		size = 24
	strings:
		$1 = { 0C 00 80 AC 08 00 80 AC 04 00 80 AC 00 00 80 AC 08 00 E0 03 21 10 00 00 }
	condition:
		$1
}

rule file_473_0_0 {
	meta:
		name = "__GI_nrand48_r"
		size = 104
		refs = "0000 _gp_disp 000c __drand48_iterate"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F D8 FF BD 27 20 00 B1 AF 1C 00 B0 AF 10 00 BC AF 24 00 BF AF 21 80 80 00 ?? ?? ?? ?? 21 88 C0 00 08 00 42 04 FF FF 02 24 02 00 03 96 04 00 02 96 42 18 03 00 C0 13 02 00 25 10 62 00 00 00 22 AE 21 10 00 00 24 00 BF 8F 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_474_0_0 {
	meta:
		name = "setdomainname"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 19 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_475_0_0 {
	meta:
		name = "_stdlib_wcsto_ll"
		size = 724
		refs = "0000 _gp_disp 0014 __GI_iswspace 0100 __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 B8 FF BD 27 34 00 B5 AF ?? ?? 95 8F 38 00 B6 AF 2C 00 B3 AF 28 00 B2 AF 24 00 B1 AF 20 00 B0 AF 10 00 BC AF 44 00 BF AF 40 00 BE AF 3C 00 B7 AF 30 00 B4 AF 21 B0 80 00 21 98 A0 00 21 88 C0 00 21 90 E0 00 21 80 80 00 00 00 14 8E 21 C8 A0 02 ?? ?? ?? ?? 21 20 80 02 03 00 40 10 10 00 BC 8F F9 FF 00 10 04 00 10 26 2B 00 02 24 05 00 82 12 2D 00 02 24 05 00 82 56 21 A8 00 00 02 00 00 10 01 00 15 24 21 A8 00 00 04 00 10 26 EF FF 02 24 24 10 22 02 14 00 40 14 FE FF 22 26 00 00 03 8E 30 00 02 24 03 00 62 50 04 00 04 8E 0A 00 00 10 0A 00 22 26 78 00 03 24 04 00 16 26 20 00 84 34 04 00 83 14 08 00 22 26 08 00 10 26 02 00 00 10 40 10 02 00 21 80 C0 02 10 00 11 24 11 00 43 28 0B 88 43 00 FE FF 22 26 23 00 42 2C 4E 00 40 10 21 18 00 00 ?? ?? 99 8F 21 10 00 00 21 18 00 00 00 04 14 3C C3 BF 11 00 00 01 08 3C 22 00 1E 24 00 00 04 8E D0 FF 85 24 0A 00 A6 2C 07 00 C0 54 FF 00 A5 30 20 00 84 34 61 00 86 2C 03 00 C0 14 28 00 05 24 A9 FF 85 24 FF 00 A5 30 2A 20 B1 00 39 00 80 10 2B 20 74 00 0D 00 80 10 04 00 10 26 18 00 E2 02 00 00 71 70 12 20 00 00 19 00 51 00 12 10 00 00 21 10 A2 00 2B 28 45 00 10 18 00 00 21 18 83 00 21 18 A3 00 E5 FF 00 10 21 B0 00 02 FF 00 44 30 02 30 91 70 02 12 02 00 00 26 03 00 25 10 82 00 02 1A 03 00 18 00 E2 02 21 28 C5 00 02 32 05 00 00 00 71 70 12 20 00 00 19 00 51 00 12 10 00 00 21 48 C2 00 2B 30 26 01 10 18 00 00 21 20 83 00 21 18 80 00 21 20 C4 00 2B 20 88 00 0B 00 80 50 18 00 A8 AF 02 36 02 00 00 22 03 00 00 12 02 00 C3 1F 05 00 25 20 C4 00 21 10 A2 00 2B 28 45 00 21 20 64 00 DF FF 00 10 21 18 A4 00 09 F8 20 03 1C 00 B9 AF 10 00 BC 8F 00 00 5E AC 24 A8 B2 02 FF FF 02 24 FF FF 03 24 18 00 A8 8F D5 FF 00 10 1C 00 B9 8F 01 00 60 56 00 00 76 AE 04 00 A0 52 FF 7F 10 3C 21 88 00 00 03 00 00 10 00 80 10 3C FF FF 11 24 FF FF 10 36 0D 00 40 12 2B 20 03 02 05 00 80 14 ?? ?? 99 8F 09 00 70 14 2B 20 22 02 07 00 80 10 00 00 00 00 ?? ?? ?? ?? 00 00 00 00 22 00 03 24 00 00 43 AC 21 10 20 02 21 18 00 02 05 00 A0 12 44 00 BF 8F 23 10 02 00 2B 20 02 00 23 18 03 00 23 18 64 00 40 00 BE 8F 3C 00 B7 8F 38 00 B6 8F 34 00 B5 8F 30 00 B4 8F 2C 00 B3 8F 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 08 00 E0 03 48 00 BD 27 }
	condition:
		$1
}

rule file_476_0_0 {
	meta:
		name = "skip_nospace"
		size = 80
		refs = "0000 _gp_disp 000c __GI___ctype_b"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 86 8F 21 10 80 00 0A 00 07 24 00 00 43 80 0A 00 60 10 40 20 03 00 00 00 C5 8C 21 20 A4 00 00 00 84 94 20 00 84 30 04 00 80 14 00 00 00 00 F6 FF 67 54 01 00 42 24 00 00 40 A0 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_476_1_0 {
	meta:
		name = "skip_and_NUL_space"
		size = 96
		refs = "0000 _gp_disp 0010 __GI___ctype_b"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 21 10 80 00 ?? ?? 84 8F 0A 00 05 24 23 00 06 24 00 00 43 80 0D 00 60 10 40 38 03 00 00 00 88 8C 21 38 07 01 00 00 E7 94 20 00 E7 30 07 00 E0 10 00 00 00 00 05 00 65 10 00 00 40 A0 03 00 66 10 00 00 00 00 F2 FF 00 10 01 00 42 24 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_476_2_0 {
	meta:
		name = "__open_nameservers"
		size = 1140
		refs = "0000 _gp_disp 000c __res_sync 0048 __nameservers 004c __GI_time 006c __close_nameservers 0094 __GI_fopen 008c $LC0 00a4 $LC1 00b4 $LC2 00e4 __GI_fgets 0108 skip_and_NUL_space 0118 skip_nospace 013c __GI_strcmp 0138 $LC3 016c __GI_inet_pton 0198 __nameserver 01a0 realloc 01d4 __GI_memcpy 0200 $LC4 021c $LC5 0238 __searchdomains 023c __searchdomain 0264 free 02d0 __GI_strdup 031c __GI_fclose 0338 malloc 0358 __local_nameserver 0390 __GI_gethostname 03b0 __GI_strchr"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F 28 FE BD 27 10 00 BC AF D4 01 BF AF D0 01 BE AF CC 01 B7 AF C8 01 B6 AF C4 01 B5 AF C0 01 B4 AF BC 01 B3 AF B8 01 B2 AF B4 01 B1 AF B0 01 B0 AF 00 00 43 8C 0E 00 60 14 ?? ?? 92 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 00 00 10 00 BC 8F 00 3A 42 7C ?? ?? 83 8F ?? ?? 64 90 04 00 82 10 ?? ?? 99 8F ?? ?? ?? ?? ?? ?? 62 A0 10 00 BC 8F ?? ?? 92 8F 00 00 42 8E EA 00 40 14 ?? ?? 82 8F ?? ?? 84 8F ?? ?? 93 8F ?? ?? 90 8F ?? ?? 84 24 21 C8 00 02 ?? ?? ?? ?? ?? ?? 65 26 21 88 40 00 09 00 40 14 10 00 BC 8F ?? ?? 84 8F ?? ?? 65 26 21 C8 00 02 ?? ?? ?? ?? ?? ?? 84 24 21 88 40 00 97 00 40 10 10 00 BC 8F ?? ?? 93 8F ?? ?? 94 8F ?? ?? 73 26 ?? ?? 94 26 ?? ?? 99 8F 18 01 B0 27 21 20 00 02 80 00 05 24 ?? ?? ?? ?? 21 30 20 02 87 00 40 10 10 00 BC 8F 21 C8 60 02 ?? ?? ?? ?? 21 20 00 02 21 20 40 00 21 C8 80 02 ?? ?? ?? ?? 21 A8 40 00 21 C8 60 02 ?? ?? ?? ?? 21 20 40 00 10 00 BC 8F 21 80 40 00 21 20 A0 02 ?? ?? 82 8F ?? ?? 96 8F 21 C8 C0 02 ?? ?? ?? ?? ?? ?? 45 24 2C 00 40 14 10 00 BC 8F 21 C8 80 02 ?? ?? ?? ?? 21 20 00 02 10 00 BC 8F 02 00 04 24 00 00 40 A0 ?? ?? 99 8F 98 01 A0 AF 9C 01 A0 AF A0 01 A0 AF A4 01 A0 AF 21 28 00 02 ?? ?? ?? ?? 9C 01 A6 27 98 01 B5 27 D4 FF 40 18 10 00 BC 8F ?? ?? 96 8F 00 00 45 8E ?? ?? 99 8F 02 00 02 24 00 00 C4 8E 98 01 A2 A7 01 00 A5 24 00 35 02 24 9A 01 A2 A7 ?? ?? 90 8F ?? ?? ?? ?? 00 29 05 00 C6 FF 40 10 10 00 BC 8F 00 00 04 8E ?? ?? 99 8F 00 00 C2 AE 01 00 83 24 00 21 04 00 00 00 03 AE 21 20 44 00 21 28 A0 02 ?? ?? ?? ?? 10 00 06 24 BA FF 00 10 10 00 BC 8F ?? ?? 85 8F 21 20 A0 02 21 C8 C0 02 ?? ?? ?? ?? ?? ?? A5 24 08 00 40 10 10 00 BC 8F ?? ?? 85 8F 21 20 A0 02 21 C8 C0 02 ?? ?? ?? ?? ?? ?? A5 24 AC FF 40 14 10 00 BC 8F ?? ?? 95 8F ?? ?? 9E 8F 00 00 A2 8E ?? ?? 96 8F 0B 00 40 10 ?? ?? 97 8F 00 00 C3 8F FF FF 42 24 00 00 A2 AE 80 10 02 00 21 10 62 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 44 8C F3 FF 00 10 10 00 BC 8F 21 A8 E0 02 ?? ?? 99 8F ?? ?? 39 27 ?? ?? ?? ?? 21 20 00 02 10 00 BC 8F ?? ?? 99 8F ?? ?? 39 27 ?? ?? ?? ?? 21 20 40 00 10 00 BC 8F 00 00 E5 8E 00 00 C4 8E ?? ?? 99 8F 01 00 A5 24 80 28 05 00 ?? ?? ?? ?? 21 F0 40 00 21 18 40 00 87 FF 40 10 10 00 BC 8F ?? ?? 82 8F ?? ?? 99 8F 21 20 00 02 00 00 43 AC ?? ?? ?? ?? A8 01 A3 AF 10 00 BC 8F 7E FF 40 10 A8 01 A3 8F 00 00 A4 8E 01 00 85 24 80 20 04 00 21 18 64 00 00 00 A5 AE 00 00 62 AC 00 00 C2 83 DB FF 40 14 21 80 C0 03 74 FF 00 10 ?? ?? 99 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 20 02 10 00 BC 8F 00 00 42 8E 14 00 40 14 ?? ?? 90 8F ?? ?? 99 8F ?? ?? ?? ?? 10 00 04 24 10 00 BC 8F ?? ?? 83 8F 08 00 40 10 00 00 62 AC ?? ?? 99 8F ?? ?? 85 8F 21 20 40 00 ?? ?? ?? ?? 10 00 06 24 03 00 00 10 10 00 BC 8F ?? ?? 82 8F 00 00 62 AC 01 00 02 24 00 00 42 AE ?? ?? 90 8F 00 00 02 8E 29 00 40 14 ?? ?? 82 8F ?? ?? 99 8F 18 00 B1 27 21 20 20 02 ?? ?? ?? ?? FF 00 05 24 10 00 BC 8F 20 00 40 14 17 01 A0 A3 ?? ?? 99 8F 21 20 20 02 ?? ?? ?? ?? 2E 00 05 24 1A 00 40 10 10 00 BC 8F 01 00 43 80 18 00 60 50 ?? ?? 82 8F ?? ?? 99 8F ?? ?? ?? ?? 01 00 44 24 21 88 40 00 11 00 40 10 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 04 00 04 24 10 00 BC 8F ?? ?? 83 8F 06 00 40 14 00 00 62 AC ?? ?? 99 8F ?? ?? ?? ?? 21 20 20 02 05 00 00 10 10 00 BC 8F 00 00 51 AC 00 00 02 8E 01 00 42 24 00 00 02 AE ?? ?? 82 8F 00 00 59 8C 04 00 20 13 D4 01 BF 8F 09 F8 20 03 00 00 00 00 D4 01 BF 8F D0 01 BE 8F CC 01 B7 8F C8 01 B6 8F C4 01 B5 8F C0 01 B4 8F BC 01 B3 8F B8 01 B2 8F B4 01 B1 8F B0 01 B0 8F 08 00 E0 03 D8 01 BD 27 }
	condition:
		$1
}

rule file_477_0_0 {
	meta:
		name = "__GI_strptime"
		size = 1344
		refs = "0000 _gp_disp 0070 __GI___ctype_b 01c0 __GI_nl_langinfo 0224 __GI_strlen 023c __GI_strncasecmp 02e4 __GI___errno_location 0320 __GI_strtol 0358 __GI_localtime_r"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 60 FF BD 27 21 10 00 00 0D 00 03 24 80 00 B2 AF 7C 00 B1 AF 78 00 B0 AF 10 00 BC AF 21 88 A0 00 9C 00 BF AF 98 00 BE AF 94 00 B7 AF 90 00 B6 AF 8C 00 B5 AF 88 00 B4 AF 84 00 B3 AF 21 80 80 00 A8 00 A6 AF 18 00 B2 27 00 80 05 3C 80 20 02 00 21 20 44 02 01 00 42 24 FC FF 43 14 00 00 85 AC ?? ?? 93 8F ?? ?? 95 8F 21 A0 00 00 ?? ?? 73 26 00 00 24 82 1A 00 80 14 25 00 02 24 14 00 80 56 FF FF 94 26 30 00 A3 8F 07 00 02 24 01 00 62 50 30 00 A0 AF 21 10 00 00 00 80 06 3C 08 00 05 24 80 20 02 00 21 18 44 02 00 00 63 8C 03 00 66 10 A8 00 A7 8F 21 20 E4 00 00 00 83 AC 01 00 42 24 F8 FF 45 14 80 20 02 00 0E 01 00 10 21 10 00 02 80 10 14 00 21 10 42 02 E5 FF 00 10 34 00 51 8C F3 00 82 54 00 00 22 82 01 00 23 82 EE 00 64 10 01 00 22 26 4F 00 04 24 05 00 64 10 45 00 05 24 07 00 65 14 3F 00 04 24 02 00 00 10 80 FF 04 24 40 00 04 24 3F 00 84 34 FF 00 84 30 02 00 22 26 00 00 43 80 8A 00 60 10 20 00 65 34 9F FF A5 24 FF 00 A5 30 1A 00 A5 2C F2 00 A0 50 21 10 00 00 21 18 73 00 BF FF 63 90 24 20 64 00 3F 00 84 2C 7F 00 80 10 30 00 64 30 30 00 05 24 1C 00 85 14 01 00 51 24 04 00 04 24 79 00 84 12 80 38 14 00 01 00 42 24 21 38 47 02 0F 00 71 30 34 00 E2 AC 08 00 22 2E 06 00 40 10 01 00 97 26 5A 00 31 26 21 88 71 02 00 00 22 92 0B 00 00 10 21 88 22 02 ?? ?? 99 8F 07 00 63 30 ?? ?? 39 27 21 18 23 03 00 00 64 90 ?? ?? 99 8F ?? ?? ?? ?? 00 03 84 34 10 00 BC 8F 21 88 40 00 A9 FF 00 10 21 A0 E0 02 10 00 02 24 3B 00 82 14 0F 00 63 30 FF 00 7E 30 21 10 D3 03 1D 00 4A 90 1A 00 4B 90 21 B8 40 01 00 03 6B 35 ?? ?? 99 8F FF FF F7 26 21 20 77 01 68 00 AA AF ?? ?? ?? ?? 6C 00 AB AF 10 00 BC 8F 21 20 40 00 60 00 A2 AF ?? ?? 99 8F ?? ?? ?? ?? 21 B0 40 00 10 00 BC 8F 21 20 00 02 21 28 C0 02 ?? ?? 99 8F ?? ?? ?? ?? 21 30 40 00 10 00 BC 8F 68 00 AA 8F 1B 00 40 14 6C 00 AB 8F 00 00 C2 82 18 00 40 10 00 00 00 00 60 00 A2 8F 01 00 44 24 60 00 A4 AF 01 00 42 80 FB FF 40 14 01 00 10 26 09 00 C0 57 42 50 0A 00 0C 00 02 24 02 18 E2 72 3C 00 A2 8F 7A FF 40 04 38 00 A3 AF 21 18 43 00 77 FF 00 10 20 00 A3 AF 1A 00 EA 02 F4 01 40 01 C0 48 1E 00 21 48 49 02 10 10 00 00 70 FF 00 10 08 00 22 AD D0 FF E0 16 ?? ?? 99 8F 91 00 00 10 21 10 00 00 20 00 02 24 34 00 82 14 40 48 03 00 68 FF 60 54 00 00 24 82 ?? ?? 99 8F ?? ?? ?? ?? 60 00 B0 AF 00 00 43 8C 10 00 BC 8F 00 00 40 AC 21 B8 40 00 00 00 02 82 00 00 A4 8E 40 10 02 00 21 10 82 00 00 00 42 94 20 00 42 30 0B 00 40 14 60 00 BE 8F ?? ?? 99 8F 68 00 A3 AF 21 20 00 02 60 00 A5 27 ?? ?? ?? ?? 0A 00 06 24 10 00 BC 8F 68 00 A3 8F 5C 00 A2 AF 60 00 BE 8F 71 00 D0 13 21 10 00 00 00 00 E2 8E 03 00 40 10 ?? ?? 99 8F 6C 00 00 10 21 10 00 00 A8 00 A5 8F 5C 00 A4 27 ?? ?? ?? ?? 00 00 E3 AE 10 00 BC 8F 21 10 00 00 08 00 04 24 A8 00 A7 8F 80 18 02 00 21 28 43 02 21 18 E3 00 00 00 63 8C 01 00 42 24 F9 FF 44 14 00 00 A3 AC 36 FF 00 10 21 80 C0 03 3A 00 29 25 21 48 69 02 01 00 22 91 03 00 43 28 07 00 60 10 FF FF 03 24 01 00 42 38 6E 01 03 24 0F 27 04 24 0B 18 82 00 21 10 60 00 FF FF 03 24 0A 00 06 24 00 00 04 82 D0 FF 84 24 FF 00 85 30 0A 00 A5 2C 09 00 A0 10 27 28 03 00 0A 18 05 00 02 28 66 70 21 18 A4 00 2A 20 43 00 D5 FF 80 14 01 00 10 26 F4 FF 00 10 00 00 04 82 00 00 22 91 01 00 44 30 2A 20 64 00 CE FF 80 14 40 00 44 7C 23 18 64 00 94 F8 64 24 04 00 45 30 0B 18 85 00 49 00 04 24 08 00 44 14 C2 20 02 00 0C 00 64 38 0A 18 04 00 38 00 A4 8F 02 00 80 04 21 20 64 00 20 00 A4 AF C2 20 02 00 80 20 04 00 B0 FF 42 24 21 20 44 02 09 00 42 2C 02 FF 40 10 00 00 83 AC 40 00 A2 8F 05 00 43 04 44 00 A3 8F 45 00 64 28 64 00 62 24 07 00 00 10 0B 18 44 00 ED FF 42 24 00 00 64 28 0B 18 04 00 64 00 04 24 02 28 44 70 21 18 A3 00 F3 FE 00 10 2C 00 A3 AF 21 88 40 00 00 00 22 82 00 00 A3 8E 40 20 02 00 21 20 64 00 00 00 84 94 20 00 84 30 0A 00 80 10 01 00 31 26 00 00 02 82 40 10 02 00 21 10 62 00 00 00 42 94 20 00 42 30 E4 FE 40 50 00 00 24 82 F8 FF 00 10 01 00 10 26 00 00 03 82 96 FF 62 14 01 00 04 26 DC FE 00 10 21 80 80 00 9C 00 BF 8F 98 00 BE 8F 94 00 B7 8F 90 00 B6 8F 8C 00 B5 8F 88 00 B4 8F 84 00 B3 8F 80 00 B2 8F 7C 00 B1 8F 78 00 B0 8F 08 00 E0 03 A0 00 BD 27 }
	condition:
		$1
}

rule file_478_0_0 {
	meta:
		name = "epoll_create"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 98 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_478_1_0 {
	meta:
		name = "epoll_ctl"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 99 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_478_2_0 {
	meta:
		name = "epoll_wait"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 9A 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_480_1_0 {
	meta:
		name = "scan_getwc"
		size = 324
		refs = "0000 _gp_disp 0064 __scan_getc 0068 __GI_mbrtowc 00e4 __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 B8 FF BD 27 24 00 B0 AF 10 00 BC AF 44 00 BF AF 40 00 B7 AF 3C 00 B6 AF 38 00 B5 AF 34 00 B4 AF 30 00 B3 AF 2C 00 B2 AF 28 00 B1 AF 10 00 92 8C 21 80 80 00 FF FF 52 26 06 00 41 06 10 00 92 AC 19 00 82 90 02 00 42 34 19 00 82 A0 2F 00 00 10 FF FF 02 24 FF 7F 02 3C ?? ?? 93 8F ?? ?? 97 8F FF FF 42 34 10 00 82 AC FD FF 11 24 1C 00 B4 27 1C 00 95 24 18 00 B6 27 21 C8 60 02 ?? ?? ?? ?? 21 20 00 02 12 00 40 04 10 00 BC 8F 00 00 02 8E 21 20 C0 02 21 28 80 02 1C 00 A2 A3 01 00 06 24 21 C8 E0 02 ?? ?? ?? ?? 21 38 A0 02 21 88 40 00 04 00 40 04 10 00 BC 8F 18 00 A2 8F 11 00 00 10 24 00 02 AE FE FF 02 24 EC FF 22 12 21 C8 60 02 FD FF 02 24 05 00 22 16 ?? ?? 99 8F FF FF 02 24 24 00 02 AE 07 00 00 10 FF FF 11 24 ?? ?? ?? ?? 00 00 00 00 58 00 03 24 00 00 43 AC 01 00 02 24 1B 00 02 A2 10 00 12 AE 21 10 20 02 44 00 BF 8F 40 00 B7 8F 3C 00 B6 8F 38 00 B5 8F 34 00 B4 8F 30 00 B3 8F 2C 00 B2 8F 28 00 B1 8F 24 00 B0 8F 08 00 E0 03 48 00 BD 27 }
	condition:
		$1
}

rule file_480_2_0 {
	meta:
		name = "__GI_vfscanf"
		size = 1964
		refs = "0000 _gp_disp 0010 __GI_memset 007c _pthread_cleanup_push_defer 0080 __pthread_mutex_unlock 0098 __pthread_mutex_lock 00a8 __init_scan_cookie 0104 __GI___ctype_b 016c __scan_getc 018c __psfs_parse_spec 0268 __scan_ungetc 02b8 _store_inttype 02dc __psfs_do_numeric 0544 scan_getwc 072c __GI_ungetc 0768 _pthread_cleanup_pop_restore"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 C8 FD BD 27 ?? ?? 99 8F 18 01 A3 27 FF FF 02 24 10 00 BC AF 20 02 B4 AF 1C 02 B3 AF 10 02 B0 AF 21 A0 80 00 34 02 BF AF 30 02 BE AF 2C 02 B7 AF 28 02 B6 AF 24 02 B5 AF 18 02 B2 AF 14 02 B1 AF 21 80 A0 00 21 98 C0 00 3C 01 A2 AF FC 01 A3 AF 21 20 60 00 21 28 00 00 ?? ?? ?? ?? 24 00 06 24 34 00 99 8E 10 00 BC 8F 0C 00 20 17 00 02 B9 AF ?? ?? 99 8F ?? ?? 85 8F 38 00 91 26 E4 01 A4 27 ?? ?? ?? ?? 21 30 20 02 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 20 02 10 00 BC 8F ?? ?? 99 8F A4 01 B1 27 21 20 20 02 ?? ?? ?? ?? 21 28 80 02 10 00 BC 8F FF 7F 16 3C 01 00 12 24 ?? ?? 82 8F FF FF D6 36 ?? ?? 42 24 D0 01 A2 AF AC 01 A2 8F 03 00 42 90 4C 01 A0 AF BC 01 A2 A3 D4 01 A2 8F E0 01 A2 AF 00 00 02 92 7B 01 40 10 01 00 03 24 5C 01 A3 A3 BD 01 A3 93 ?? ?? 9E 8F 40 20 02 00 01 00 63 30 BD 01 A3 A3 00 00 C3 8F 5D 01 A0 A3 58 01 B6 AF B4 01 B6 AF 21 20 64 00 00 00 84 94 20 00 84 30 0D 00 80 50 25 00 03 24 01 00 02 92 40 10 02 00 21 10 62 00 00 00 42 94 20 00 42 30 03 00 40 10 01 00 04 26 F8 FF 00 10 21 80 80 00 17 00 02 24 33 00 00 10 54 01 A2 AF 4D 01 43 14 ?? ?? 99 8F 01 00 03 92 05 00 62 14 01 00 17 26 16 00 02 24 54 01 A2 AF 23 00 00 10 21 80 E0 02 ?? ?? 99 8F 48 01 B7 AF ?? ?? ?? ?? 18 01 A4 27 50 01 40 04 10 00 BC 8F 21 80 E2 02 5C 01 A2 93 1A 00 40 10 54 01 A2 8F 3C 01 A4 8F FE FF 03 24 05 00 83 14 18 00 A2 27 00 00 62 8E 04 00 73 26 11 00 00 10 44 01 A2 AF 40 01 A3 8F 3C 01 A4 8F 2A 28 83 00 08 00 A0 10 01 00 84 24 00 00 63 8E 3C 01 A4 AF 80 20 04 00 21 20 44 00 00 01 83 AC F5 FF 00 10 04 00 73 26 80 18 03 00 21 10 43 00 00 01 42 8C 44 01 A2 AF 54 01 A2 8F 2D 00 03 3C 01 00 63 34 07 10 43 00 01 00 42 30 17 00 40 14 58 01 A7 8F ?? ?? 97 8F 21 C8 E0 02 ?? ?? ?? ?? 21 20 20 02 09 00 40 04 10 00 BC 8F A4 01 A2 8F 00 00 C3 8F 40 10 02 00 21 10 62 00 00 00 42 94 20 00 42 30 F5 FF 40 14 21 C8 E0 02 ?? ?? 99 8F ?? ?? ?? ?? 21 20 20 02 54 01 A3 8F 17 00 02 24 12 01 62 10 10 00 BC 8F 58 01 A7 8F 16 01 E0 10 B4 01 A7 AF 54 01 B7 8F 16 00 02 24 01 01 E2 12 ?? ?? 99 8F 0C 00 E0 16 10 00 E2 2A 5C 01 A2 93 07 01 40 50 00 00 82 96 B0 01 A6 8F ?? ?? 99 8F 44 01 A4 8F 50 01 A5 8F ?? ?? ?? ?? C3 3F 06 00 FE 00 00 10 10 00 BC 8F 0C 00 40 10 12 00 E2 2A ?? ?? 99 8F 18 01 A4 27 ?? ?? ?? ?? 21 28 20 02 FF FF 03 24 FC 00 43 10 10 00 BC 8F F3 00 41 04 21 90 00 00 F9 00 00 10 00 00 82 96 82 00 40 14 44 01 A2 8F 5C 01 A4 93 60 01 B5 27 0B A8 44 00 13 00 02 24 10 00 E2 16 14 00 02 24 03 00 F6 14 ?? ?? 97 8F 01 00 02 24 B4 01 A2 AF 21 C8 E0 02 ?? ?? ?? ?? 21 20 20 02 8A 00 40 04 10 00 BC 8F A4 01 A2 8F 21 90 00 00 00 00 A2 A2 5C 01 A2 93 F6 FF 00 10 21 A8 A2 02 17 00 E2 56 01 00 04 92 ?? ?? 99 8F 01 00 17 24 04 02 B9 AF 09 F8 20 03 21 20 20 02 10 00 BC 8F 5C 00 40 04 04 02 B9 8F A4 01 A2 8F 00 00 C5 8F 40 20 02 00 21 20 A4 00 00 00 84 94 20 00 84 30 55 00 80 54 ?? ?? 99 8F 00 00 A2 A2 5C 01 A2 93 21 B8 00 00 21 90 00 00 ED FF 00 10 21 A8 A2 02 5E 00 02 24 03 00 82 10 21 18 00 00 03 00 00 10 01 00 10 26 02 00 10 26 01 00 03 24 ?? ?? 99 8F 18 00 A8 27 21 20 00 01 21 28 60 00 04 02 A3 AF 08 02 A7 AF ?? ?? ?? ?? 00 01 06 24 04 02 A3 8F 00 00 04 92 21 40 40 00 01 00 63 38 5D 00 02 24 10 00 BC 8F F8 01 A3 AF 03 00 82 14 08 02 A7 8F 75 00 A3 A3 01 00 10 26 5D 00 05 24 2D 00 06 24 00 00 02 92 1A 00 45 50 12 00 02 24 A9 00 40 50 00 00 82 96 12 00 46 14 F8 01 B9 8F 01 00 04 92 10 00 85 50 01 00 10 26 FF FF 02 92 2B 48 44 00 0B 00 20 51 00 00 02 92 01 00 10 26 F8 01 A3 8F 01 00 42 24 21 48 02 01 00 00 23 A1 2A 48 44 00 FB FF 20 15 F8 01 A3 8F 00 00 02 92 F8 01 B9 8F 01 00 10 26 21 10 02 01 E5 FF 00 10 00 00 59 A0 1B 00 E2 12 44 01 A2 8F ?? ?? 9E 8F 01 00 17 24 04 02 A8 AF 21 C8 C0 03 ?? ?? ?? ?? 21 20 20 02 10 00 BC 8F 0B 00 40 04 04 02 A8 8F A4 01 A2 8F 21 20 02 01 00 00 84 90 06 00 80 10 21 90 00 00 00 00 A2 A2 5C 01 A2 93 21 B8 00 00 F0 FF 00 10 21 A8 A2 02 ?? ?? 99 8F ?? ?? ?? ?? 21 20 20 02 77 00 E0 16 10 00 BC 8F 5F 00 00 10 00 00 A0 A2 5C 01 A4 93 F4 01 B5 27 0B A8 44 00 10 00 02 24 1A 00 E2 16 C0 01 A0 AF 04 00 F6 14 ?? ?? 99 8F 01 00 02 24 B4 01 A2 AF ?? ?? 99 8F ?? ?? 39 27 ?? ?? ?? ?? 21 20 20 02 08 00 40 04 10 00 BC 8F C8 01 A2 8F 21 90 00 00 00 00 A2 AE 5C 01 A2 93 80 10 02 00 F4 FF 00 10 21 A8 A2 02 ?? ?? 99 8F ?? ?? ?? ?? 21 20 20 02 B4 01 A2 8F 42 00 40 18 10 00 BC 8F 57 00 00 10 00 00 82 96 11 00 02 24 03 00 E2 12 01 00 17 24 27 00 00 10 18 00 BE 27 ?? ?? 99 8F ?? ?? 39 27 ?? ?? ?? ?? 21 20 20 02 2C 00 40 04 10 00 BC 8F C8 01 A2 8F 00 01 44 2C 09 00 80 50 00 00 A2 AE 00 00 C5 8F 40 20 02 00 21 20 A4 00 00 00 84 94 20 00 84 30 21 00 80 54 21 90 00 00 00 00 A2 AE 5C 01 A2 93 21 B8 00 00 21 90 00 00 80 10 02 00 E9 FF 00 10 21 A8 A2 02 C8 01 A2 8F 00 01 44 2C 13 00 80 10 F8 01 A3 8F 21 20 C2 03 00 00 84 90 12 00 80 10 21 90 00 00 00 00 A2 AE 5C 01 A2 93 21 B8 00 00 21 90 00 00 80 10 02 00 21 A8 A2 02 ?? ?? 99 8F ?? ?? 39 27 ?? ?? ?? ?? 21 20 20 02 ED FF 41 04 10 00 BC 8F 05 00 00 10 ?? ?? 99 8F F2 FF 60 50 00 00 A2 AE 21 90 00 00 ?? ?? 99 8F ?? ?? ?? ?? 21 20 20 02 1B 00 E0 16 10 00 BC 8F BF 01 A2 83 19 00 40 54 00 00 82 96 00 00 A0 AE 4C 01 A3 8F 5C 01 A2 93 21 10 62 00 0B 00 00 10 4C 01 A2 AF ?? ?? ?? ?? 21 20 20 02 00 00 03 92 06 00 43 10 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 20 02 08 00 00 10 10 00 BC 8F 00 00 82 96 08 00 42 30 87 FE 40 10 01 00 10 26 03 00 00 10 00 00 82 96 21 80 E0 02 00 00 82 96 08 00 43 30 0A 00 60 54 FF FF 02 24 00 00 03 92 09 00 60 50 BD 01 A2 93 07 00 40 52 BD 01 A2 93 04 00 42 30 04 00 40 10 BD 01 A2 93 FF FF 02 24 4C 01 A2 AF BD 01 A2 93 01 00 42 30 0E 00 40 10 00 02 A3 8F ?? ?? 99 8F A8 01 A4 8F ?? ?? ?? ?? AC 01 A5 8F B0 01 A3 8F 10 00 BC 8F 04 00 60 14 AC 01 A2 8F B8 01 A3 8F 02 00 00 10 28 00 43 AC 28 00 40 AC 00 02 A3 8F 06 00 60 14 34 02 BF 8F ?? ?? 99 8F E4 01 A4 27 ?? ?? ?? ?? 01 00 05 24 34 02 BF 8F 4C 01 A2 8F 30 02 BE 8F 2C 02 B7 8F 28 02 B6 8F 24 02 B5 8F 20 02 B4 8F 1C 02 B3 8F 18 02 B2 8F 14 02 B1 8F 10 02 B0 8F 08 00 E0 03 38 02 BD 27 }
	condition:
		$1
}

rule file_482_0_0 {
	meta:
		name = "exchange.constprop.2"
		size = 248
		refs = "0000 _gp_disp"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 86 8F ?? ?? C7 24 20 00 E2 8C 24 00 E3 8C ?? ?? C5 8C 21 58 C0 00 2A 30 65 00 2B 00 C0 10 2A 30 43 00 29 00 C0 10 23 40 A3 00 23 48 62 00 2A 30 28 01 03 00 C0 14 23 60 43 00 13 00 00 10 21 30 00 00 21 30 00 00 21 60 AC 00 2A 40 C9 00 0C 00 00 11 21 50 46 00 21 40 86 01 80 50 0A 00 80 40 08 00 21 50 8A 00 21 40 88 00 00 00 4D 8D 00 00 0E 8D 01 00 C6 24 00 00 4E AD F3 FF 00 10 00 00 0D AD E4 FF 00 10 23 28 A9 00 2A 48 C8 00 0C 00 20 11 21 50 46 00 21 48 66 00 80 50 0A 00 80 48 09 00 21 50 8A 00 21 48 89 00 00 00 4C 8D 00 00 2D 8D 01 00 C6 24 00 00 4D AD F3 FF 00 10 00 00 2C AD D4 FF 00 10 21 10 48 00 ?? ?? 62 8D 24 00 E3 8C 20 00 E4 8C 24 00 E2 AC 23 18 43 00 21 18 83 00 08 00 E0 03 20 00 E3 AC }
	condition:
		$1
}

rule file_482_1_0 {
	meta:
		name = "_getopt_internal"
		size = 2176
		refs = "0000 _gp_disp 000c opterr 0048 optind 00b8 __GI_getenv 00b4 $LC0 018c exchange.constprop.2 01f8 __GI_strcmp 01f0 $LC1 0318 __GI_strchr 0380 __GI_strncmp 03cc __GI_strlen 0498 stderr 04ac __GI_fprintf 04bc $LC3 04d8 $LC4 054c $LC5 05f4 $LC2 06e8 $LC9 06f8 $LC10 076c $LC11 07d0 optopt 07dc optarg 083c $LC6 0858 $LC7 0874 $LC8"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 83 8F 90 FF BD 27 5C 00 B5 AF 58 00 B4 AF 54 00 B3 AF 50 00 B2 AF 48 00 B0 AF 18 00 BC AF 6C 00 BF AF 68 00 BE AF 64 00 B7 AF 60 00 B6 AF 4C 00 B1 AF 00 00 63 8C 21 A8 80 00 ?? ?? 84 8F 20 00 A3 AF ?? ?? 90 8F 20 00 B9 8F 00 00 82 8C ?? ?? 03 26 04 00 79 AC ?? ?? 02 AE 21 90 A0 00 00 00 C5 80 21 98 C0 00 21 A0 60 00 3A 00 A4 38 0A C8 04 00 7A 00 A0 1A 20 00 B9 AF 21 88 E0 00 06 00 40 10 08 00 60 AC 10 00 62 8C 06 00 40 50 ?? ?? 02 8E 22 00 00 10 1C 00 82 8E 01 00 02 24 ?? ?? 02 AE ?? ?? 02 8E ?? ?? 84 8F ?? ?? 99 8F 24 00 82 AE ?? ?? 84 24 20 00 82 AE ?? ?? ?? ?? 1C 00 80 AE 2B 10 02 00 18 00 BC 8F 18 00 82 AE 00 00 64 82 2D 00 05 24 04 00 85 14 2B 00 05 24 02 00 02 24 04 00 00 10 14 00 82 AE 04 00 85 14 00 00 00 00 14 00 80 AE 06 00 00 10 01 00 73 26 03 00 40 10 01 00 02 24 03 00 00 10 14 00 80 AE 14 00 82 AE 01 00 02 24 10 00 82 AE 1C 00 82 8E 04 00 40 50 ?? ?? 02 8E 00 00 42 80 68 00 40 14 ?? ?? 02 8E 24 00 84 8E 2A 20 44 00 01 00 80 54 24 00 82 AE 20 00 84 8E 2A 20 44 00 01 00 80 54 20 00 82 AE 14 00 85 8E 01 00 04 24 1F 00 A4 14 ?? ?? 16 8E 24 00 85 8E 20 00 84 8E 08 00 85 10 00 00 00 00 08 00 A2 10 ?? ?? 99 8F ?? ?? 39 27 ?? ?? ?? ?? 21 20 40 02 03 00 00 10 18 00 BC 8F 01 00 82 54 20 00 82 AE 2D 00 05 24 ?? ?? 02 8E 2A 20 55 00 0B 00 80 10 80 20 02 00 21 20 44 02 00 00 84 8C 00 00 86 80 04 00 C5 50 01 00 84 80 01 00 42 24 F5 FF 00 10 ?? ?? 02 AE FD FF 80 50 01 00 42 24 24 00 82 AE ?? ?? 16 8E 18 00 D5 12 80 10 16 00 ?? ?? 85 8F 21 10 42 02 ?? ?? 99 8F 00 00 44 8C ?? ?? ?? ?? ?? ?? A5 24 10 00 40 14 18 00 BC 8F ?? ?? 82 8F 01 00 D6 26 20 00 84 8E ?? ?? 56 AC 24 00 82 8E 07 00 82 50 20 00 96 AE 05 00 56 10 ?? ?? 99 8F ?? ?? 39 27 ?? ?? ?? ?? 21 20 40 02 18 00 BC 8F 24 00 95 AE ?? ?? 15 AE ?? ?? 04 8E 08 00 95 14 80 30 04 00 20 00 82 8E 24 00 84 8E 02 00 44 10 ?? ?? 84 8F ?? ?? 82 AC 56 01 00 10 FF FF 02 24 21 30 46 02 00 00 C2 8C 2D 00 05 24 00 00 47 80 05 00 E5 54 14 00 82 8E 01 00 45 80 0A 00 A0 14 00 00 00 00 14 00 82 8E F3 FF 40 10 01 00 84 24 ?? ?? 82 8F ?? ?? 44 AC 00 00 C2 8C 08 00 82 AE 44 01 00 10 01 00 02 24 03 00 20 12 2D 00 A4 38 02 00 00 10 01 00 84 2C 21 20 00 00 01 00 84 24 21 10 44 00 1C 00 82 AE E6 00 20 12 ?? ?? 1E 8E 2D 00 02 24 80 60 1E 00 21 60 4C 02 00 00 96 8D 01 00 C3 82 0F 00 62 10 24 00 A3 AF 84 00 B9 8F DD 00 20 53 1C 00 96 8E 02 00 C2 82 0A 00 40 54 1C 00 97 8E ?? ?? 99 8F 40 00 AC AF 21 20 60 02 ?? ?? ?? ?? 21 28 60 00 18 00 BC 8F D1 00 40 14 40 00 AC 8F 1C 00 97 8E 3D 00 04 24 21 48 E0 02 00 00 22 81 05 00 40 10 FF FF 03 24 04 00 44 10 23 C8 37 01 FA FF 00 10 01 00 29 25 23 C8 37 01 21 58 00 00 28 00 A3 AF 21 50 00 00 21 40 00 00 2C 00 B9 AF 00 00 2D 8E 35 00 A0 11 ?? ?? 99 8F 2C 00 A6 8F 21 20 A0 01 38 00 A8 AF 34 00 A9 AF 3C 00 AA AF 44 00 AB AF 40 00 AC AF 30 00 AD AF ?? ?? ?? ?? 21 28 E0 02 18 00 BC 8F 38 00 A8 8F 34 00 A9 8F 3C 00 AA 8F 44 00 AB 8F 40 00 AC 8F 20 00 40 14 30 00 AD 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 A0 01 2C 00 A3 8F 18 00 BC 8F 38 00 A8 8F 34 00 A9 8F 3C 00 AA 8F 44 00 AB 8F 1D 00 62 10 40 00 AC 8F 12 00 00 51 28 00 AB AF 84 00 B9 8F 10 00 20 57 01 00 0A 24 04 00 04 8D 04 00 22 8E 0C 00 82 54 01 00 0A 24 08 00 04 8D 08 00 22 8E 08 00 82 54 01 00 0A 24 0C 00 22 8E 0C 00 04 8D 26 20 82 00 01 00 02 24 02 00 00 10 0B 50 44 00 21 40 20 02 10 00 31 26 CA FF 00 10 01 00 6B 25 64 00 40 15 20 00 A3 8F 28 00 AB 8F 79 00 00 11 21 88 00 01 01 00 C2 27 ?? ?? 02 AE 00 00 25 81 ?? ?? 96 8F 25 00 A0 10 04 00 24 8E 04 00 80 10 20 00 B9 8F 01 00 29 25 45 00 00 10 08 00 89 AE 14 00 20 13 ?? ?? 84 8F 00 00 85 8D 2D 00 07 24 01 00 A8 80 00 00 46 8E ?? ?? 99 8F 00 00 22 8E 07 00 07 15 00 00 84 8C ?? ?? 85 8F 21 38 40 00 ?? ?? ?? ?? ?? ?? A5 24 06 00 00 10 00 00 00 00 00 00 A7 80 ?? ?? 85 8F 10 00 A2 AF ?? ?? ?? ?? ?? ?? A5 24 1C 00 92 8E 21 C8 C0 02 ?? ?? ?? ?? 21 20 40 02 21 10 42 02 18 00 BC 8F 1C 00 82 AE 0C 00 22 8E 4D 00 00 10 0C 00 82 AE 01 00 05 24 24 00 85 54 44 00 AB AF 2A A8 55 00 07 00 A0 12 20 00 A3 8F ?? ?? 82 8F 02 00 DE 27 ?? ?? 5E AC 04 00 82 8D 1A 00 00 10 08 00 82 AE 0A 00 60 50 1C 00 92 8E ?? ?? 82 8F ?? ?? 85 8F 00 00 46 8E 00 00 44 8C 00 00 87 8D ?? ?? 99 8F ?? ?? ?? ?? ?? ?? A5 24 1C 00 92 8E 21 C8 C0 02 ?? ?? ?? ?? 21 20 40 02 21 10 42 02 18 00 BC 8F 1C 00 82 AE 0C 00 22 8E 3F 00 04 24 0C 00 82 AE 00 00 65 82 3A 00 02 24 3A 00 A5 38 8A 00 00 10 0B 10 85 00 44 00 AB AF 21 C8 C0 02 ?? ?? ?? ?? 21 20 E0 02 80 00 A3 8F 21 10 E2 02 18 00 BC 8F 1C 00 82 AE 02 00 60 10 44 00 AB 8F 00 00 6B AC 08 00 24 8E 7C 00 80 10 0C 00 22 8E 00 00 82 AC 79 00 00 10 21 10 00 00 0B 00 60 50 1C 00 91 8E ?? ?? 82 8F ?? ?? 85 8F ?? ?? 99 8F 00 00 44 8C 00 00 46 8E ?? ?? A5 24 ?? ?? ?? ?? 21 38 C0 02 18 00 BC 8F 1C 00 91 8E ?? ?? 99 8F ?? ?? ?? ?? 21 20 20 02 18 00 BC 8F 21 10 22 02 1C 00 82 AE ?? ?? 02 8E 0C 00 80 AE 01 00 42 24 ?? ?? 02 AE 61 00 00 10 3F 00 02 24 84 00 B9 8F 74 00 20 13 20 00 B9 8F 24 00 A3 8F 2D 00 02 24 6F 00 62 10 ?? ?? 99 8F 00 00 E5 82 ?? ?? ?? ?? 21 20 60 02 6A 00 40 10 18 00 BC 8F 1C 00 96 8E ?? ?? 99 8F 21 20 60 02 01 00 D7 26 1C 00 97 AE 00 00 D1 82 ?? ?? 9E 8F ?? ?? ?? ?? 21 28 20 02 01 00 C4 82 04 00 80 14 18 00 BC 8F ?? ?? C4 8F 01 00 84 24 ?? ?? C4 AF 05 00 40 10 20 00 B9 8F 3A 00 05 24 15 00 25 56 01 00 44 80 20 00 B9 8F DC FF 20 53 0C 00 91 AE 18 00 84 8E ?? ?? 82 8F 00 00 46 8E 05 00 80 10 ?? ?? 99 8F ?? ?? 85 8F 00 00 44 8C 04 00 00 10 ?? ?? A5 24 ?? ?? 85 8F 00 00 44 8C ?? ?? A5 24 ?? ?? ?? ?? 21 38 20 02 18 00 BC 8F CB FF 00 10 0C 00 91 AE 2B 00 85 54 21 10 20 02 02 00 45 80 05 00 A4 14 01 00 C2 82 05 00 40 14 ?? ?? 02 8E 22 00 00 10 08 00 80 AE 05 00 40 10 ?? ?? 02 8E 08 00 97 AE 01 00 42 24 1C 00 00 10 ?? ?? 02 AE 14 00 55 14 ?? ?? 84 8F 20 00 A3 8F 0B 00 60 50 0C 00 91 AE ?? ?? 82 8F ?? ?? 85 8F ?? ?? 99 8F 00 00 44 8C 00 00 46 8E ?? ?? A5 24 ?? ?? ?? ?? 21 38 20 02 18 00 BC 8F 0C 00 91 AE 00 00 64 82 3A 00 11 24 3F 00 02 24 3A 00 84 38 07 00 00 10 0B 88 44 00 01 00 45 24 80 10 02 00 ?? ?? 85 AC 21 90 42 02 00 00 42 8E 08 00 82 AE 1C 00 80 AE 21 10 20 02 ?? ?? 04 8E ?? ?? 85 8F ?? ?? 83 8F 00 00 A4 AC 08 00 85 8E ?? ?? 84 8F 00 00 85 AC 0C 00 84 8E 00 00 64 AC 6C 00 BF 8F 68 00 BE 8F 64 00 B7 8F 60 00 B6 8F 5C 00 B5 8F 58 00 B4 8F 54 00 B3 8F 50 00 B2 8F 4C 00 B1 8F 48 00 B0 8F 08 00 E0 03 70 00 BD 27 20 00 B9 8F 14 00 20 13 24 00 A3 8F 2D 00 04 24 ?? ?? 82 8F 00 00 46 8E 08 00 64 14 ?? ?? 99 8F ?? ?? 85 8F 00 00 44 8C 21 38 E0 02 ?? ?? ?? ?? ?? ?? A5 24 08 00 00 10 18 00 BC 8F ?? ?? 85 8F 00 00 44 8C 00 00 C7 82 ?? ?? A5 24 ?? ?? ?? ?? 10 00 B7 AF 18 00 BC 8F ?? ?? 82 8F 6C FF 00 10 ?? ?? 42 24 }
	condition:
		$1
}

rule file_482_2_0 {
	meta:
		name = "__GI_getopt"
		size = 56
		refs = "0000 _gp_disp 000c _getopt_internal"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F D8 FF BD 27 24 00 BF AF 18 00 BC AF 10 00 A0 AF 14 00 A0 AF ?? ?? ?? ?? 21 38 00 00 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_482_3_0 {
	meta:
		name = "getopt_long"
		size = 60
		refs = "0000 _gp_disp 0014 _getopt_internal"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D8 FF BD 27 38 00 A2 8F ?? ?? 99 8F 24 00 BF AF 18 00 BC AF 10 00 A2 AF 14 00 A0 AF ?? ?? ?? ?? 00 00 00 00 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_482_4_0 {
	meta:
		name = "getopt_long_only"
		size = 64
		refs = "0000 _gp_disp 0014 _getopt_internal"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D8 FF BD 27 38 00 A2 8F ?? ?? 99 8F 24 00 BF AF 10 00 A2 AF 01 00 02 24 18 00 BC AF 14 00 A2 AF ?? ?? ?? ?? 00 00 00 00 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_483_0_0 {
	meta:
		name = "__GI_nl_langinfo"
		size = 96
		refs = "0000 _gp_disp"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F 03 1A 04 00 06 00 65 2C 0F 00 A0 10 ?? ?? 42 24 21 18 43 00 00 00 65 90 01 00 63 90 FF 00 84 30 21 20 A4 00 2B 18 83 00 07 00 60 10 40 00 83 30 21 20 82 00 07 00 84 90 40 18 03 00 61 00 63 24 21 18 64 00 21 10 43 00 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_484_0_0 {
	meta:
		name = "__GI_wcscmp"
		size = 56
	strings:
		$1 = { 00 00 82 8C 00 00 A3 8C 05 00 43 54 2B 18 43 00 07 00 40 10 04 00 84 24 F9 FF 00 10 04 00 A5 24 01 00 04 24 FF FF 02 24 08 00 E0 03 0A 10 83 00 08 00 E0 03 21 10 00 00 }
	condition:
		$1
}

rule file_485_0_0 {
	meta:
		name = "__libc_longjmp"
		size = 92
		refs = "0000 _gp_disp 0030 __GI_sigprocmask 0048 __GI___longjmp"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D8 FF BD 27 20 00 B1 AF 1C 00 B0 AF 10 00 BC AF 24 00 BF AF 68 00 82 8C 21 80 80 00 07 00 40 10 21 88 A0 00 ?? ?? 99 8F 03 00 04 24 6C 00 05 26 ?? ?? ?? ?? 21 30 00 00 10 00 BC 8F ?? ?? 99 8F 01 00 05 24 21 20 00 02 ?? ?? ?? ?? 0B 28 31 02 }
	condition:
		$1
}

rule file_488_0_0 {
	meta:
		name = "tcsendbreak"
		size = 64
		refs = "0000 _gp_disp 0010 __GI_ioctl"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 04 00 A0 1C ?? ?? 99 8F 05 54 05 24 07 00 00 10 21 30 00 00 63 00 A6 24 64 00 02 24 1A 00 C2 00 F4 01 40 00 86 54 05 24 12 30 00 00 ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_489_0_0 {
	meta:
		name = "munlock"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 3B 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_490_0_0 {
	meta:
		name = "__exit_handler"
		size = 220
		refs = "0000 _gp_disp 0018 __exit_function_table 001c __exit_count 00d0 free"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D0 FF BD 27 20 00 B2 AF 18 00 B0 AF ?? ?? 92 8F ?? ?? 90 8F 28 00 B4 AF 24 00 B3 AF 1C 00 B1 AF 10 00 BC AF 2C 00 BF AF 21 88 80 00 02 00 13 24 03 00 14 24 00 00 02 8E 1A 00 40 10 FF FF 42 24 00 00 43 8E 00 00 02 AE 00 11 02 00 21 10 62 00 00 00 43 8C 05 00 73 50 04 00 59 8C 0A 00 74 50 04 00 59 8C F4 FF 00 10 00 00 02 8E F2 FF 20 53 00 00 02 8E 08 00 45 8C 09 F8 20 03 21 20 20 02 06 00 00 10 10 00 BC 8F EB FF 20 53 00 00 02 8E 09 F8 20 03 08 00 44 8C 10 00 BC 8F E6 FF 00 10 00 00 02 8E ?? ?? 82 8F 2C 00 BF 8F 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 00 00 44 8C ?? ?? 99 8F ?? ?? ?? ?? 30 00 BD 27 }
	condition:
		$1
}

rule file_490_1_0 {
	meta:
		name = "__new_exitfn"
		size = 280
		refs = "0000 _gp_disp 0010 __pthread_mutex_unlock 0014 _pthread_cleanup_push_defer 0018 __atexit_lock 0048 __pthread_mutex_lock 0058 __exit_slots 005c __exit_count 0070 __exit_function_table 0074 realloc 0090 __GI___errno_location 00bc __exit_handler 00c0 __exit_cleanup 00e8 _pthread_cleanup_pop_restore"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 C0 FF BD 27 ?? ?? 85 8F ?? ?? 99 8F ?? ?? 86 8F 34 00 B2 AF 18 00 B2 27 10 00 BC AF 3C 00 BF AF 38 00 B3 AF 30 00 B1 AF 2C 00 B0 AF ?? ?? ?? ?? 21 20 40 02 10 00 BC 8F ?? ?? 84 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F ?? ?? 91 8F ?? ?? 93 8F 00 00 25 8E 00 00 62 8E 2A 10 45 00 13 00 40 14 ?? ?? 90 8F ?? ?? 99 8F 00 00 04 8E 14 00 A5 24 ?? ?? ?? ?? 00 29 05 00 08 00 40 14 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 80 00 00 0C 00 03 24 10 00 BC 8F 10 00 00 10 00 00 43 AC 00 00 02 AE 00 00 22 8E 14 00 42 24 00 00 22 AE ?? ?? 83 8F ?? ?? 82 8F 00 00 10 8E 00 00 43 AC 00 00 62 8E 01 00 43 24 00 11 02 00 21 80 02 02 01 00 02 24 00 00 63 AE 00 00 02 AE ?? ?? 99 8F 21 20 40 02 ?? ?? ?? ?? 01 00 05 24 3C 00 BF 8F 21 10 00 02 38 00 B3 8F 34 00 B2 8F 30 00 B1 8F 2C 00 B0 8F 08 00 E0 03 40 00 BD 27 }
	condition:
		$1
}

rule file_491_0_0 {
	meta:
		name = "__GI_fputwc_unlocked"
		size = 76
		refs = "0000 _gp_disp 000c _wstdio_fwrite"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F E0 FF BD 27 21 30 A0 00 01 00 05 24 1C 00 BF AF 10 00 BC AF 20 00 A4 AF ?? ?? ?? ?? 20 00 A4 27 20 00 A4 8F 1C 00 BF 8F FF FF 03 24 0B 18 82 00 21 10 60 00 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_492_0_0 {
	meta:
		name = "token"
		size = 692
		refs = "0000 _gp_disp 0050 __GI___fgetc_unlocked 0238 __GI_strcmp"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 C0 FF BD 27 20 00 B1 AF ?? ?? 91 8F 10 00 BC AF 3C 00 BF AF ?? ?? 22 8E 38 00 B7 AF 34 00 B6 AF 30 00 B5 AF 2C 00 B4 AF 28 00 B3 AF 24 00 B2 AF 1C 00 B0 AF 00 00 43 94 0C 00 63 30 8F 00 60 14 21 10 00 00 ?? ?? 90 8F FF FF 12 24 20 00 13 24 2C 00 14 24 ?? ?? 24 8E 10 00 82 8C 18 00 83 8C 2B 18 43 00 04 00 60 10 01 00 43 24 10 00 83 AC 08 00 00 10 00 00 42 90 21 C8 00 02 ?? ?? ?? ?? 00 00 00 00 03 00 52 14 10 00 BC 8F 7B 00 00 10 21 10 00 00 F7 FF 43 24 02 00 63 2C EE FF 60 14 ?? ?? 24 8E ED FF 53 50 10 00 82 8C EA FF 54 10 22 00 03 24 28 00 43 14 ?? ?? 92 8F ?? ?? 93 8F ?? ?? 50 26 FF FF 15 24 22 00 14 24 5C 00 16 24 ?? ?? 24 8E 10 00 82 8C 18 00 83 8C 2B 18 43 00 04 00 60 10 01 00 43 24 10 00 83 AC 06 00 00 10 00 00 42 90 21 C8 60 02 ?? ?? ?? ?? 00 00 00 00 45 00 55 10 10 00 BC 8F 44 00 54 50 00 00 00 A2 0F 00 56 54 00 00 02 A2 ?? ?? 24 8E 10 00 82 8C 18 00 83 8C 2B 18 43 00 04 00 60 10 01 00 43 24 10 00 83 AC 05 00 00 10 00 00 42 90 21 C8 60 02 ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F 00 00 02 A2 DF FF 00 10 01 00 10 26 ?? ?? 90 8F ?? ?? 93 8F ?? ?? 42 A2 ?? ?? 10 26 FF FF 15 24 20 00 16 24 2C 00 14 24 5C 00 17 24 ?? ?? 24 8E 10 00 82 8C 18 00 83 8C 2B 18 43 00 04 00 60 10 01 00 43 24 10 00 83 AC 06 00 00 10 00 00 42 90 21 C8 60 02 ?? ?? ?? ?? 00 00 00 00 1B 00 55 10 10 00 BC 8F F7 FF 43 24 02 00 63 2C 18 00 60 54 00 00 00 A2 16 00 56 50 00 00 00 A2 14 00 54 50 00 00 00 A2 0F 00 57 54 00 00 02 A2 ?? ?? 24 8E 10 00 82 8C 18 00 83 8C 2B 18 43 00 04 00 60 10 01 00 43 24 10 00 83 AC 05 00 00 10 00 00 42 90 21 C8 60 02 ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F 00 00 02 A2 D9 FF 00 10 01 00 10 26 00 00 00 A2 ?? ?? 42 82 9A FF 40 10 ?? ?? 95 8F ?? ?? 96 8F ?? ?? 93 8F 21 80 00 00 ?? ?? B5 26 ?? ?? D6 26 ?? ?? 52 26 07 00 14 24 C0 88 10 00 21 88 35 02 00 00 24 8E 21 28 40 02 21 C8 60 02 ?? ?? ?? ?? 21 20 C4 02 03 00 40 14 01 00 10 26 04 00 00 10 04 00 22 8E F5 FF 14 16 C0 88 10 00 0A 00 02 24 3C 00 BF 8F 38 00 B7 8F 34 00 B6 8F 30 00 B5 8F 2C 00 B4 8F 28 00 B3 8F 24 00 B2 8F 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 40 00 BD 27 }
	condition:
		$1
}

rule file_492_1_0 {
	meta:
		name = "__GI_ruserpass"
		size = 1280
		refs = "0000 _gp_disp 000c __GI_getuid 0058 __GI_geteuid 006c __GI_getgid 007c __GI_getegid 0094 __GI_getenv 0090 $LC0 00ac __GI_strlen 00d0 __GI_strcpy 00f4 __GI_strcat 00f0 $LC1 010c __GI_fopen 0108 $LC2 0128 __GI___errno_location 0148 __GI_printf 0144 $LC3 0160 __GI___fsetlocking 017c __GI_gethostname 0194 __GI_strchr 01d8 token 0224 __GI_strcasecmp 028c __GI_strncasecmp 02d8 __GI_fclose 035c malloc 0398 __GI_strcmp 03d0 __GI_fileno 03e4 __GI_fstat 036c $LC4 03b0 $LC5 0408 $LC6 0420 $LC7 0324 $LC8"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F 20 FB BD 27 DC 04 BF AF D8 04 BE AF D4 04 B7 AF 21 F0 A0 03 D0 04 B6 AF C0 04 B2 AF B8 04 B0 AF 10 00 BC AF CC 04 B5 AF C8 04 B4 AF C4 04 B3 AF BC 04 B1 AF 21 90 80 00 21 B0 A0 00 ?? ?? ?? ?? 21 B8 C0 00 10 00 DC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 80 40 00 17 01 02 16 10 00 DC 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 10 00 DC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 80 40 00 0E 01 02 16 10 00 DC 8F ?? ?? 84 8F ?? ?? 99 8F ?? ?? ?? ?? ?? ?? 84 24 21 88 40 00 07 01 40 10 10 00 DC 8F ?? ?? 93 8F 21 C8 60 02 ?? ?? ?? ?? 21 20 40 00 10 00 DC 8F 16 00 42 24 C2 10 02 00 21 28 20 02 C0 10 02 00 ?? ?? 91 8F 23 E8 A2 03 10 00 B0 27 21 C8 20 02 ?? ?? ?? ?? 21 20 00 02 10 00 DC 8F 21 20 00 02 ?? ?? 85 8F ?? ?? 99 8F ?? ?? ?? ?? ?? ?? A5 24 10 00 DC 8F 21 20 00 02 ?? ?? 85 8F ?? ?? 99 8F ?? ?? ?? ?? ?? ?? A5 24 10 00 DC 8F ?? ?? 94 8F 0F 00 40 14 ?? ?? 82 AE ?? ?? 99 8F ?? ?? ?? ?? 21 88 00 00 00 00 43 8C 02 00 02 24 E2 00 62 10 10 00 DC 8F ?? ?? 84 8F ?? ?? 99 8F 21 28 00 02 ?? ?? ?? ?? ?? ?? 84 24 DC 00 00 10 21 E8 C0 03 ?? ?? 99 8F 21 20 40 00 ?? ?? ?? ?? 02 00 05 24 10 00 DC 8F 18 00 D0 27 21 20 00 02 ?? ?? 99 8F ?? ?? ?? ?? 00 04 05 24 02 00 41 04 10 00 DC 8F 18 00 C0 A3 ?? ?? 91 8F 21 20 00 02 21 C8 20 02 ?? ?? ?? ?? 2E 00 05 24 21 A8 40 00 06 00 40 14 10 00 DC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 00 02 10 00 DC 8F 21 A8 02 02 ?? ?? 93 8F 21 88 00 00 ?? ?? 99 8F ?? ?? 39 27 ?? ?? ?? ?? 00 00 00 00 3B 00 40 10 10 00 DC 8F 01 00 03 24 13 00 43 10 0B 00 03 24 F7 FF 43 14 ?? ?? 99 8F 2C 00 20 16 ?? ?? 39 27 ?? ?? ?? ?? 00 00 00 00 0A 00 03 24 EF FF 43 14 10 00 DC 8F ?? ?? 90 8F 21 20 40 02 21 C8 00 02 ?? ?? ?? ?? ?? ?? 65 26 05 00 40 14 10 00 DC 8F 1F 00 00 10 ?? ?? 70 26 1C 00 00 10 01 00 11 24 ?? ?? 99 8F 21 20 40 02 ?? ?? ?? ?? 2E 00 05 24 DE FF 40 10 10 00 DC 8F 21 20 40 00 21 28 A0 02 21 C8 00 02 ?? ?? ?? ?? B0 04 C2 AF 10 00 DC 8F D6 FF 40 14 B0 04 C6 8F ?? ?? 99 8F 23 80 D2 00 21 20 40 02 ?? ?? 65 26 ?? ?? ?? ?? 21 30 00 02 CE FF 40 14 10 00 DC 8F ?? ?? 66 26 21 80 06 02 00 00 02 82 C9 FF 40 14 21 88 00 00 ?? ?? 70 26 ?? ?? 99 8F ?? ?? 39 27 ?? ?? ?? ?? 00 00 00 00 02 00 43 2C 07 00 60 10 10 00 DC 8F ?? ?? 84 8E ?? ?? 99 8F ?? ?? ?? ?? 21 88 00 00 7A 00 00 10 21 E8 C0 03 0B 00 03 24 F8 FF 43 10 03 00 03 24 2E 00 43 10 04 00 43 28 06 00 60 50 06 00 42 28 02 00 03 24 07 00 43 10 ?? ?? 99 8F 66 00 00 10 ?? ?? 82 8F E7 FF 40 14 ?? ?? 99 8F 62 00 00 10 ?? ?? 82 8F ?? ?? 39 27 ?? ?? ?? ?? 00 00 00 00 DF FF 40 10 10 00 DC 8F 00 00 C4 8E 15 00 80 14 ?? ?? 99 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 00 02 10 00 DC 8F ?? ?? 99 8F ?? ?? ?? ?? 01 00 44 24 05 00 40 14 10 00 DC 8F ?? ?? 84 8F ?? ?? 99 8F 2C 00 00 10 ?? ?? 84 24 ?? ?? 99 8F 21 20 40 00 ?? ?? ?? ?? 21 28 00 02 00 00 C2 AE C8 FF 00 10 10 00 DC 8F ?? ?? ?? ?? 21 28 00 02 C4 FF 40 10 10 00 DC 8F 8A FF 00 10 ?? ?? 99 8F ?? ?? 85 8F ?? ?? 99 8F 00 00 C4 8E ?? ?? ?? ?? ?? ?? A5 24 20 00 40 10 10 00 DC 8F ?? ?? 99 8F ?? ?? ?? ?? ?? ?? 84 8E 10 00 DC 8F 21 20 40 00 ?? ?? 99 8F ?? ?? ?? ?? 18 04 C5 27 16 00 40 04 10 00 DC 8F 2C 04 C2 8F 3F 00 42 30 13 00 40 10 ?? ?? 99 8F ?? ?? 90 8F ?? ?? 84 8F 21 C8 00 02 ?? ?? ?? ?? ?? ?? 84 24 10 00 DC 8F 21 C8 00 02 ?? ?? 84 8F ?? ?? 84 24 ?? ?? ?? ?? FF FF 11 24 10 00 DC 8F ?? ?? 99 8F ?? ?? ?? ?? ?? ?? 84 8E 22 00 00 10 21 E8 C0 03 ?? ?? 99 8F ?? ?? 39 27 ?? ?? ?? ?? 00 00 00 00 96 FF 40 10 10 00 DC 8F 00 00 E2 8E 94 FF 40 14 ?? ?? 99 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 00 02 10 00 DC 8F ?? ?? 99 8F ?? ?? ?? ?? 01 00 44 24 B8 FF 40 10 10 00 DC 8F ?? ?? 99 8F 21 20 40 00 ?? ?? ?? ?? 21 28 00 02 00 00 E2 AE 83 FF 00 10 10 00 DC 8F ?? ?? 99 8F 21 28 00 02 ?? ?? ?? ?? ?? ?? 44 24 7D FF 00 10 10 00 DC 8F FF FF 11 24 21 E8 C0 03 DC 04 BF 8F 21 10 20 02 D8 04 BE 8F D4 04 B7 8F D0 04 B6 8F CC 04 B5 8F C8 04 B4 8F C4 04 B3 8F C0 04 B2 8F BC 04 B1 8F B8 04 B0 8F 08 00 E0 03 E0 04 BD 27 }
	condition:
		$1
}

rule file_493_0_0 {
	meta:
		name = "__GI_abort"
		size = 344
		refs = "0000 _gp_disp 0018 __pthread_mutex_lock 003c __GI___sigaddset 0064 __GI_sigprocmask 008c __pthread_mutex_unlock 009c __GI_raise 00d0 __GI_sigaction 0138 __GI__exit"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 A8 FF BD 27 50 00 B1 AF ?? ?? 91 8F ?? ?? 99 8F 54 00 BF AF 10 00 BC AF 4C 00 B0 AF ?? ?? ?? ?? ?? ?? 24 26 10 00 BC 8F 34 00 B0 27 21 20 00 02 ?? ?? 99 8F 06 00 05 24 40 00 A0 AF 3C 00 A0 AF 38 00 A0 AF ?? ?? ?? ?? 34 00 A0 AF 10 00 BC 8F 21 28 00 02 02 00 04 24 ?? ?? 99 8F ?? ?? ?? ?? 21 30 00 00 10 00 BC 8F ?? ?? 90 8F ?? ?? 02 8E 10 00 40 14 ?? ?? 03 8E 01 00 02 24 ?? ?? 02 AE ?? ?? 99 8F ?? ?? ?? ?? ?? ?? 24 26 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 06 00 04 24 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? ?? ?? 24 26 10 00 BC 8F ?? ?? 03 8E 01 00 04 24 12 00 64 14 ?? ?? 82 8F 02 00 03 24 ?? ?? 99 8F ?? ?? 43 AC FF FF 02 24 18 00 A0 AF 1C 00 A0 AF 30 00 A0 AF 2C 00 A2 AF 28 00 A2 AF 24 00 A2 AF 20 00 A2 AF 06 00 04 24 18 00 A5 27 ?? ?? ?? ?? 21 30 00 00 E0 FF 00 10 10 00 BC 8F 02 00 04 24 05 00 64 14 ?? ?? 03 8E 03 00 03 24 ?? ?? 43 AC 0D 00 FF 00 ?? ?? 03 8E 03 00 02 24 06 00 62 14 ?? ?? 82 8F ?? ?? 99 8F 04 00 03 24 ?? ?? 43 AC ?? ?? ?? ?? 7F 00 04 24 0D 00 FF 00 FE FF 00 10 00 00 00 00 }
	condition:
		$1
}

rule file_494_0_0 {
	meta:
		name = "__decode_dotted"
		size = 380
		refs = "0000 _gp_disp 00ec __GI_memcpy"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 B0 FF BD 27 10 00 BC AF 30 00 B2 AF 4C 00 BF AF 48 00 BE AF 44 00 B7 AF 40 00 B6 AF 3C 00 B5 AF 38 00 B4 AF 34 00 B3 AF 2C 00 B1 AF 28 00 B0 AF 03 00 80 14 21 90 80 00 41 00 00 10 FF FF 02 24 21 B0 E0 00 21 A0 C0 00 21 20 00 00 21 80 00 00 01 00 13 24 C0 FF 07 24 C0 00 08 24 2E 00 09 24 2A 10 B4 00 36 00 40 10 FF FF 02 24 01 00 A2 24 21 28 45 02 00 00 B1 90 30 00 20 12 2B 18 13 00 24 28 27 02 0D 00 A8 14 21 80 03 02 2A 28 54 00 E9 FF A0 10 21 80 03 02 21 10 42 02 00 00 42 90 3F 00 25 32 00 2A 05 00 25 28 A2 00 21 A8 80 00 21 98 00 00 EA FF 00 10 21 20 A0 02 60 00 A5 8F 21 B8 24 02 01 00 F5 26 2B 18 A5 02 DA FF 60 10 21 F0 22 02 01 00 C3 27 2B 18 74 00 D6 FF 60 10 ?? ?? 99 8F 21 28 42 02 18 00 A7 AF 1C 00 A8 AF 20 00 A9 AF 21 20 C4 02 ?? ?? ?? ?? 21 30 20 02 02 10 71 72 10 00 BC 8F 21 28 C0 03 21 B8 D7 02 18 00 A7 8F 1C 00 A8 8F 21 80 50 00 21 10 5E 02 00 00 42 90 03 00 40 10 20 00 A9 8F E1 FF 00 10 00 00 E9 A2 DF FF 00 10 00 00 E0 A2 21 10 13 02 4C 00 BF 8F 48 00 BE 8F 44 00 B7 8F 40 00 B6 8F 3C 00 B5 8F 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 E0 03 50 00 BD 27 }
	condition:
		$1
}

rule file_495_0_0 {
	meta:
		name = "__GI_setresuid"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 59 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_496_0_0 {
	meta:
		name = "lsearch"
		size = 148
		refs = "0000 _gp_disp 0014 __GI_lfind 0054 __GI_memcpy"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 C8 FF BD 27 48 00 A2 8F ?? ?? 99 8F 18 00 BC AF 30 00 B3 AF 2C 00 B2 AF 28 00 B1 AF 24 00 B0 AF 34 00 BF AF 10 00 A2 AF 21 90 80 00 21 98 A0 00 21 80 C0 00 ?? ?? ?? ?? 21 88 E0 00 0B 00 40 14 18 00 BC 8F 00 00 04 8E ?? ?? 99 8F 21 28 40 02 02 10 24 72 21 30 20 02 ?? ?? ?? ?? 21 20 53 00 00 00 03 8E 01 00 63 24 00 00 03 AE 34 00 BF 8F 30 00 B3 8F 2C 00 B2 8F 28 00 B1 8F 24 00 B0 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_497_0_0 {
	meta:
		name = "waitid5.constprop.0"
		size = 100
		refs = "0000 _gp_disp 003c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 21 10 00 00 E0 FF BD 27 10 00 A2 AF B6 10 02 24 0C 00 00 00 20 00 BD 27 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_498_0_0 {
	meta:
		name = "shmat"
		size = 88
		refs = "0000 _gp_disp 000c __syscall_ipc"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F D0 FF BD 27 21 10 80 00 15 00 04 24 18 00 BC AF 10 00 A5 AF 2C 00 BF AF 14 00 A0 AF 21 28 40 00 ?? ?? ?? ?? 20 00 A7 27 FC FF 03 3C 01 00 63 24 2B 18 43 00 01 00 60 54 20 00 A2 8F 2C 00 BF 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_499_0_0 {
	meta:
		name = "__GI_wmempcpy"
		size = 40
	strings:
		$1 = { 21 10 80 00 06 00 C0 10 FF FF C6 24 00 00 A3 8C 04 00 A5 24 00 00 43 AC FA FF 00 10 04 00 42 24 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_500_0_0 {
	meta:
		name = "__psfs_do_numeric"
		size = 1672
		refs = "0000 _gp_disp 0060 __scan_getc 0094 __scan_ungetc 01dc __GI___ctype_b 02d0 _stdlib_strto_ll 0320 _store_inttype 0340 __GI_strcpy 04c4 __strtofpmax 05fc __truncdfsf2"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 00 FF BD 27 ?? ?? 82 8F F8 00 BE AF E0 00 B2 AF DC 00 B1 AF D8 00 B0 AF 10 00 BC AF FC 00 BF AF F4 00 B7 AF F0 00 B6 AF EC 00 B5 AF E8 00 B4 AF E4 00 B3 AF 3C 00 95 8C ?? ?? 42 24 21 80 80 00 21 10 A2 02 FF FF 52 90 01 00 02 24 21 F0 A0 00 23 00 A2 16 ?? ?? 91 8F ?? ?? 93 8F ?? ?? 73 26 21 A0 60 02 21 C8 20 02 ?? ?? ?? ?? 21 20 C0 03 05 00 40 04 10 00 BC 8F 00 00 63 92 00 00 C2 8F 09 00 62 50 01 00 73 26 ?? ?? 99 8F 21 20 C0 03 ?? ?? ?? ?? 2B 98 93 02 12 00 60 12 21 C8 20 02 6A 01 00 10 FE FF 02 24 00 00 62 92 EE FF 40 14 21 C8 20 02 44 00 02 92 64 01 40 50 21 10 00 00 34 00 02 8E 2C 00 04 8E 38 00 05 8E 01 00 42 24 34 00 02 AE 21 30 00 00 8E 00 00 10 21 38 00 00 21 C8 20 02 ?? ?? ?? ?? 21 20 C0 03 00 00 C2 8F 55 01 40 04 10 00 BC 8F 2B 00 03 24 03 00 43 10 2D 00 04 24 07 00 44 14 18 00 B7 27 18 00 A2 A3 21 C8 20 02 ?? ?? ?? ?? 21 20 C0 03 10 00 BC 8F 19 00 B7 27 EF 00 42 32 23 00 40 54 00 00 C2 8F 00 00 D3 8F 30 00 02 24 1D 00 62 16 0A 00 02 24 21 C8 20 02 ?? ?? ?? ?? 21 20 C0 03 00 00 C4 8F 78 00 02 24 20 00 84 34 08 00 82 14 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 C0 03 31 01 40 04 10 00 BC 8F 0F 00 00 10 10 00 12 24 ?? ?? 99 8F ?? ?? ?? ?? 21 20 C0 03 10 00 BC 8F 00 00 D3 AF 3C 00 02 8E 08 00 42 28 06 00 40 50 0A 00 12 24 40 38 52 7E 08 00 52 26 02 00 00 10 FF 00 52 32 0A 90 52 00 00 00 C2 8F 30 00 04 24 08 00 44 10 21 A0 00 00 18 00 A3 27 21 B0 00 00 21 98 00 00 ?? ?? 85 8F 10 00 06 24 20 00 00 10 C8 00 A3 AF 01 00 F3 26 00 00 E2 A2 30 00 14 24 21 C8 20 02 ?? ?? ?? ?? 21 20 C0 03 00 00 C2 8F FB FF 54 10 10 00 BC 8F 21 B8 60 02 EE FF 00 10 01 00 14 24 1C 00 46 16 D1 FF 44 24 C8 00 A3 8F 23 20 E3 02 41 00 84 28 05 00 80 50 01 00 73 26 00 00 E2 A2 01 00 14 24 01 00 F7 26 01 00 16 24 CC 00 A5 AF D0 00 A6 AF 21 C8 20 02 ?? ?? ?? ?? 21 20 C0 03 10 00 BC 8F D0 00 A6 8F CC 00 A5 8F 00 00 C2 8F 00 00 A8 8C 40 20 02 00 21 20 04 01 00 00 84 94 10 00 84 30 E6 FF 80 14 00 00 00 00 05 00 00 10 3C 00 02 8E 2A 20 44 02 E4 FF 80 10 C8 00 A3 8F 3C 00 02 8E 08 00 42 28 23 00 40 50 3C 00 D5 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 C0 03 10 00 BC 8F E3 00 80 12 00 00 E0 A2 44 00 02 92 DB 00 40 10 18 00 A3 93 ?? ?? 99 8F 06 00 B5 2A 2D 00 62 38 34 00 03 8E 0A A8 02 00 01 00 07 24 01 00 63 24 2C 00 11 8E 34 00 03 AE 18 00 A4 27 38 00 10 8E 21 28 00 00 21 30 40 02 ?? ?? ?? ?? 23 38 F5 00 10 00 BC 8F 21 20 20 02 21 28 00 02 21 30 40 00 21 38 60 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 C2 00 00 10 00 00 00 00 00 00 A2 92 0B 00 40 54 00 00 C4 8F ?? ?? 99 8F 30 00 C5 8F ?? ?? ?? ?? 21 20 E0 02 34 00 C2 8F 10 00 BC 8F 10 00 C0 12 21 B8 E2 02 20 00 00 10 10 00 16 24 07 00 44 10 21 C8 20 02 3C 00 C2 8F 2B A8 55 00 34 00 A0 12 ?? ?? 99 8F B0 00 00 10 00 00 00 00 ?? ?? ?? ?? 21 20 C0 03 01 00 B5 26 E7 FF 00 10 10 00 BC 8F 00 00 C2 8F 30 00 04 24 0F 00 44 14 10 00 16 24 01 00 F4 26 00 00 E2 A2 01 00 73 26 30 00 15 24 21 C8 20 02 ?? ?? ?? ?? 21 20 C0 03 00 00 C2 8F FF FF 73 26 FA FF 55 10 10 00 BC 8F 21 B8 80 02 01 00 14 24 10 00 16 24 18 00 B5 27 ?? ?? 83 8F 00 00 C2 8F 00 00 65 8C 40 20 02 00 21 20 A4 00 00 00 84 94 10 00 84 30 11 00 80 10 00 00 00 00 0C 00 56 16 D1 FF 44 24 23 20 F5 02 41 00 84 28 04 00 80 10 21 C8 20 02 00 00 E2 A2 01 00 14 24 01 00 F7 26 ?? ?? ?? ?? 21 20 C0 03 EB FF 00 10 10 00 BC 8F 2A 20 44 02 F4 FF 80 10 23 20 F5 02 24 00 80 56 00 00 C2 8F 10 00 02 24 79 00 42 12 69 00 05 24 00 00 C2 8F 20 00 44 34 06 00 85 10 6E 00 05 24 74 00 85 14 ?? ?? 99 8F ?? ?? 92 8F 03 00 00 10 ?? ?? 52 26 ?? ?? 92 8F ?? ?? 52 26 00 00 E2 A2 21 C8 20 02 ?? ?? ?? ?? 21 20 C0 03 00 00 C4 8F 00 00 42 92 01 00 F7 26 20 00 85 34 04 00 A2 14 10 00 BC 8F 00 00 E4 A2 F5 FF 00 10 01 00 52 26 40 00 40 10 ?? ?? 99 8F ?? ?? 82 8F ?? ?? 42 24 3D 00 42 12 18 00 A4 27 5A 00 00 10 ?? ?? 99 8F 65 00 04 24 20 00 45 34 36 00 A4 14 ?? ?? 99 8F 00 00 E2 A2 21 C8 20 02 ?? ?? ?? ?? 21 20 C0 03 00 00 C2 8F 4E 00 40 04 10 00 BC 8F 2B 00 04 24 05 00 44 10 2D 00 04 24 04 00 44 50 01 00 E2 A2 09 00 00 10 01 00 F7 26 01 00 E2 A2 21 C8 20 02 ?? ?? ?? ?? 21 20 C0 03 10 00 BC 8F 02 00 F2 26 21 B8 40 02 00 00 C2 8F 30 00 04 24 16 00 44 14 21 90 00 00 01 00 F2 26 00 00 E2 A2 30 00 14 24 21 C8 20 02 ?? ?? ?? ?? 21 20 C0 03 00 00 C2 8F FB FF 54 10 10 00 BC 8F 21 B8 40 02 0A 00 00 10 01 00 12 24 05 00 80 10 21 C8 20 02 01 00 52 26 00 00 E2 A2 FF 00 52 32 01 00 F7 26 ?? ?? ?? ?? 21 20 C0 03 10 00 BC 8F 00 00 C2 93 D0 FF 44 24 0A 00 84 2C F3 FF 80 14 14 00 44 2E 20 00 40 12 ?? ?? 99 8F 18 00 A4 27 00 00 E0 A2 C0 00 A5 27 ?? ?? ?? ?? 21 30 60 02 44 00 04 92 13 00 80 10 10 00 BC 8F 38 00 04 8E 00 08 85 30 04 00 A0 14 2C 00 11 8E 00 04 84 30 04 00 80 10 ?? ?? 99 8F 00 00 22 AE 06 00 00 10 04 00 23 AE 21 20 40 00 ?? ?? ?? ?? 21 28 60 00 10 00 BC 8F 00 00 22 AE 34 00 02 8E 01 00 42 24 34 00 02 AE ?? ?? 99 8F ?? ?? ?? ?? 21 20 C0 03 07 00 00 10 21 10 00 00 ?? ?? 99 8F ?? ?? ?? ?? 21 20 C0 03 02 00 00 10 FE FF 02 24 FF FF 02 24 FC 00 BF 8F F8 00 BE 8F F4 00 B7 8F F0 00 B6 8F EC 00 B5 8F E8 00 B4 8F E4 00 B3 8F E0 00 B2 8F DC 00 B1 8F D8 00 B0 8F 08 00 E0 03 00 01 BD 27 }
	condition:
		$1
}

rule file_502_0_0 {
	meta:
		name = "__pgsreader"
		size = 472
		refs = "0000 _gp_disp 004c __GI___errno_location 0078 _pthread_cleanup_push_defer 007c __pthread_mutex_unlock 0094 __pthread_mutex_lock 00a4 __GI___ctype_b 00b0 __GI_fgets_unlocked 00e4 __GI_strlen 0164 __parsegrent 0194 _pthread_cleanup_pop_restore"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 B0 FF BD 27 00 01 E2 2C 10 00 BC AF 30 00 B2 AF 2C 00 B1 AF 4C 00 BF AF 48 00 BE AF 44 00 B7 AF 40 00 B6 AF 3C 00 B5 AF 38 00 B4 AF 34 00 B3 AF 28 00 B0 AF 21 88 E0 00 07 00 40 10 60 00 B2 8F ?? ?? 99 8F ?? ?? ?? ?? 22 00 10 24 22 00 03 24 51 00 00 10 00 00 43 AC 34 00 53 8E 21 A0 80 00 21 A8 A0 00 0C 00 60 16 21 80 C0 00 ?? ?? 99 8F ?? ?? 85 8F 38 00 56 26 18 00 A4 27 ?? ?? ?? ?? 21 30 C0 02 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 C0 02 10 00 BC 8F ?? ?? 96 8F 21 B8 00 00 21 F0 11 02 ?? ?? 99 8F 21 20 00 02 21 28 20 02 ?? ?? ?? ?? 21 30 40 02 07 00 40 14 10 00 BC 8F 00 00 43 96 22 00 10 24 02 00 02 24 04 00 63 30 2B 00 00 10 0B 80 43 00 ?? ?? 99 8F ?? ?? ?? ?? 21 20 00 02 FF FF 44 24 21 20 04 02 00 00 86 80 0A 00 05 24 03 00 C5 14 10 00 BC 8F 06 00 00 10 00 00 80 A0 01 00 42 24 03 00 51 14 00 00 00 00 E4 FF 00 10 01 00 F7 26 03 00 E0 52 00 00 02 82 E0 FF 00 10 FF FF F7 26 03 00 40 14 23 00 03 24 DC FF 00 10 21 B8 00 00 FD FF 43 10 40 10 02 00 00 00 C3 8E 21 10 62 00 00 00 42 94 20 00 42 30 D4 FF 40 14 21 B8 00 00 ?? ?? 82 8F 01 00 82 52 00 00 BE AE 21 20 A0 02 21 C8 80 02 09 F8 20 03 21 28 00 02 EE FF 40 14 10 00 BC 8F 21 80 00 00 06 00 60 16 4C 00 BF 8F ?? ?? 99 8F 18 00 A4 27 ?? ?? ?? ?? 01 00 05 24 4C 00 BF 8F 21 10 00 02 48 00 BE 8F 44 00 B7 8F 40 00 B6 8F 3C 00 B5 8F 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 E0 03 50 00 BD 27 }
	condition:
		$1
}

rule file_504_0_0 {
	meta:
		name = "__GI_rawmemchr"
		size = 180
	strings:
		$1 = { FF 00 A2 30 03 00 83 30 06 00 60 50 FF 00 A5 30 00 00 83 90 25 00 62 10 00 00 00 00 F9 FF 00 10 01 00 84 24 00 1A 05 00 25 28 65 00 00 1C 05 00 FE 7E 07 3C 01 81 08 3C 25 28 65 00 FF FE E7 34 00 01 08 25 00 00 83 8C 26 18 A3 00 27 48 03 00 21 18 67 00 26 18 23 01 24 18 68 00 03 00 60 14 04 00 86 24 F7 FF 00 10 21 20 C0 00 00 00 83 90 0E 00 62 10 00 00 00 00 01 00 83 90 03 00 62 54 02 00 83 90 08 00 E0 03 01 00 82 24 03 00 62 54 03 00 83 90 08 00 E0 03 02 00 82 24 E9 FF 62 54 21 20 C0 00 08 00 E0 03 03 00 82 24 08 00 E0 03 21 10 80 00 }
	condition:
		$1
}

rule file_505_0_0 {
	meta:
		name = "putchar"
		size = 272
		refs = "0000 _gp_disp 000c stdout 0060 __GI___fputc_unlocked 0074 _pthread_cleanup_push_defer 0078 __pthread_mutex_unlock 0094 __pthread_mutex_lock 00e0 _pthread_cleanup_pop_restore"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F C0 FF BD 27 30 00 B1 AF 10 00 BC AF 3C 00 BF AF 38 00 B3 AF 34 00 B2 AF 2C 00 B0 AF 00 00 50 8C 34 00 02 8E 0F 00 40 10 21 88 80 00 10 00 02 8E 1C 00 03 8E 2B 18 43 00 05 00 60 10 01 00 43 24 10 00 03 AE 00 00 44 A0 26 00 00 10 FF 00 82 30 ?? ?? 99 8F ?? ?? ?? ?? 21 28 00 02 22 00 00 10 3C 00 BF 8F ?? ?? 99 8F ?? ?? 85 8F 38 00 13 26 18 00 B2 27 21 20 40 02 ?? ?? ?? ?? 21 30 60 02 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 60 02 10 00 02 8E 1C 00 03 8E 2B 18 43 00 06 00 60 10 10 00 BC 8F 01 00 43 24 10 00 03 AE 00 00 51 A0 07 00 00 10 FF 00 31 32 ?? ?? 99 8F 21 20 20 02 ?? ?? ?? ?? 21 28 00 02 10 00 BC 8F 21 88 40 00 ?? ?? 99 8F 21 20 40 02 ?? ?? ?? ?? 01 00 05 24 21 10 20 02 3C 00 BF 8F 38 00 B3 8F 34 00 B2 8F 30 00 B1 8F 2C 00 B0 8F 08 00 E0 03 40 00 BD 27 }
	condition:
		$1
}

rule file_507_0_0 {
	meta:
		name = "freopen"
		size = 452
		refs = "0000 _gp_disp 0044 _pthread_cleanup_push_defer 0048 __pthread_mutex_unlock 0060 __pthread_mutex_lock 0074 _stdio_openlist_del_lock 00a8 _stdio_openlist_use_count 00ac _pthread_cleanup_pop_restore 00e4 __GI_fclose 0128 _stdio_openlist_del_count 0144 _stdio_fopen 0174 _stdio_openlist_dec_use"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 A8 FF BD 27 4C 00 B4 AF 48 00 B3 AF 3C 00 B0 AF 10 00 BC AF 54 00 BF AF 50 00 B5 AF 44 00 B2 AF 40 00 B1 AF 34 00 D2 8C 21 A0 80 00 21 98 A0 00 0C 00 40 16 21 80 C0 00 ?? ?? 99 8F ?? ?? 85 8F 38 00 D1 24 28 00 A4 27 ?? ?? ?? ?? 21 30 20 02 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 20 02 10 00 BC 8F ?? ?? 85 8F ?? ?? 86 8F ?? ?? 99 8F 18 00 B1 27 ?? ?? ?? ?? 21 20 20 02 10 00 BC 8F ?? ?? 84 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F 21 20 20 02 01 00 05 24 ?? ?? 82 8F ?? ?? 99 8F 00 00 43 8C 01 00 63 24 00 00 43 AC ?? ?? ?? ?? 00 00 00 00 00 00 02 96 10 00 BC 8F FF 9F 43 30 00 60 55 30 00 00 03 A6 30 00 42 30 30 00 03 24 18 00 43 10 ?? ?? 99 8F ?? ?? ?? ?? 21 20 00 02 10 00 BC 8F ?? ?? 85 8F ?? ?? 86 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 20 02 10 00 BC 8F ?? ?? 84 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F 21 20 20 02 01 00 05 24 ?? ?? 82 8F ?? ?? 99 8F 00 00 43 8C FF FF 63 24 ?? ?? ?? ?? 00 00 43 AC 10 00 BC 8F ?? ?? 99 8F 21 20 80 02 21 28 60 02 21 30 00 02 ?? ?? ?? ?? FF FF 07 24 21 88 40 00 03 00 40 14 10 00 BC 8F 30 80 02 24 00 00 02 A6 00 00 02 96 ?? ?? 99 8F 25 A8 A2 02 ?? ?? ?? ?? 00 00 15 A6 05 00 40 16 10 00 BC 8F ?? ?? 99 8F 28 00 A4 27 ?? ?? ?? ?? 01 00 05 24 54 00 BF 8F 21 10 20 02 50 00 B5 8F 4C 00 B4 8F 48 00 B3 8F 44 00 B2 8F 40 00 B1 8F 3C 00 B0 8F 08 00 E0 03 58 00 BD 27 }
	condition:
		$1
}

rule file_508_0_0 {
	meta:
		name = "setfsuid"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 2A 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_509_0_0 {
	meta:
		name = "__GI___fputc_unlocked"
		size = 332
		refs = "0000 _gp_disp 0058 __stdio_trans2w_o 0098 __stdio_WRITE 00a4 __stdio_wcommit"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D0 FF BD 27 28 00 B1 AF 24 00 B0 AF 10 00 BC AF 2C 00 BF AF 10 00 A2 8C 1C 00 A3 8C 21 88 80 00 2B 18 43 00 05 00 60 10 21 80 A0 00 01 00 43 24 10 00 A3 AC 22 00 00 10 00 00 44 A0 00 00 A3 94 C0 00 02 24 C0 00 63 30 07 00 62 14 ?? ?? 99 8F 04 00 03 8E FE FF 02 24 0A 00 62 54 0C 00 02 8E 32 00 00 10 FF 00 22 32 21 20 A0 00 ?? ?? ?? ?? 80 00 05 24 F6 FF 40 10 10 00 BC 8F 2B 00 00 10 FF FF 02 24 08 00 03 8E 20 00 62 10 ?? ?? 99 8F 10 00 03 8E 0C 00 62 10 ?? ?? 99 8F 10 00 03 8E 01 00 62 24 10 00 02 AE FF 00 22 32 00 00 62 A0 00 00 03 96 00 01 63 30 09 00 60 14 0A 00 03 24 1A 00 00 10 FF 00 22 32 ?? ?? ?? ?? 21 20 00 02 F2 FF 40 10 10 00 BC 8F 14 00 00 10 FF FF 02 24 12 00 43 14 FF 00 22 32 ?? ?? 99 8F ?? ?? ?? ?? 21 20 00 02 0D 00 40 10 FF 00 22 32 10 00 02 8E FF FF 42 24 08 00 00 10 10 00 02 AE 18 00 B1 A3 21 20 00 02 18 00 A5 27 ?? ?? ?? ?? 01 00 06 24 02 00 40 14 FF 00 22 32 FF FF 02 24 2C 00 BF 8F 28 00 B1 8F 24 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_510_0_0 {
	meta:
		name = "dup"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF C9 0F 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_512_0_0 {
	meta:
		name = "__GI_wcsncasecmp"
		size = 204
		refs = "0000 _gp_disp 0014 __GI_towlower"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 C8 FF BD 27 28 00 B4 AF ?? ?? 94 8F 24 00 B3 AF 1C 00 B1 AF 18 00 B0 AF 10 00 BC AF 34 00 BF AF 30 00 B6 AF 2C 00 B5 AF 20 00 B2 AF 21 80 80 00 21 88 A0 00 21 98 C0 00 17 00 60 12 21 10 00 00 00 00 12 8E 00 00 36 8E 06 00 56 16 21 C8 80 02 10 00 40 12 04 00 10 26 04 00 31 26 F6 FF 00 10 FF FF 73 26 ?? ?? ?? ?? 21 20 40 02 21 20 C0 02 21 C8 80 02 ?? ?? ?? ?? 21 A8 40 00 F4 FF A2 12 2B A8 A2 02 01 00 03 24 FF FF 02 24 02 00 00 10 0A 10 75 00 21 10 00 00 34 00 BF 8F 30 00 B6 8F 2C 00 B5 8F 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_513_0_0 {
	meta:
		name = "__GI_wcslen"
		size = 32
	strings:
		$1 = { 21 10 80 00 00 00 43 8C 03 00 60 50 23 10 44 00 FC FF 00 10 04 00 42 24 08 00 E0 03 83 10 02 00 }
	condition:
		$1
}

rule file_514_0_0 {
	meta:
		name = "__GI_fgets_unlocked"
		size = 260
		refs = "0000 _gp_disp 0044 __GI___fgetc_unlocked"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 C8 FF BD 27 10 00 BC AF 20 00 B2 AF 34 00 BF AF 30 00 B6 AF 2C 00 B5 AF 28 00 B4 AF 24 00 B3 AF 1C 00 B1 AF 18 00 B0 AF 03 00 A0 1C 21 90 A0 00 27 00 00 10 21 10 00 00 ?? ?? 95 8F 21 98 80 00 21 88 C0 00 21 80 80 00 FF FF 16 24 0A 00 14 24 FF FF 52 26 1A 00 40 12 2B 10 70 02 10 00 22 8E 18 00 23 8E 2B 18 43 00 05 00 60 10 01 00 44 24 10 00 24 AE 01 00 03 26 0D 00 00 10 00 00 42 80 21 C8 A0 02 ?? ?? ?? ?? 21 20 20 02 07 00 56 14 01 00 03 26 00 00 22 96 08 00 42 30 08 00 40 50 2B 10 70 02 0A 00 00 10 21 10 00 00 20 14 02 7C 00 00 02 A2 E6 FF 54 14 21 80 60 00 2B 10 70 02 03 00 40 10 21 10 00 00 00 00 00 A2 21 10 60 02 34 00 BF 8F 30 00 B6 8F 2C 00 B5 8F 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_515_0_0 {
	meta:
		name = "div"
		size = 36
	strings:
		$1 = { 1A 00 A6 00 F4 01 C0 00 21 10 80 00 12 18 00 00 00 00 43 AC 02 20 66 70 23 28 A4 00 08 00 E0 03 04 00 45 AC }
	condition:
		$1
}

rule file_516_0_0 {
	meta:
		name = "__free_initshell_memory"
		size = 92
		refs = "0000 _gp_disp 0018 free"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 18 00 B0 AF ?? ?? 90 8F ?? ?? 99 8F 1C 00 BF AF ?? ?? 04 8E 10 00 BC AF ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F ?? ?? 00 AE ?? ?? 90 8F ?? ?? 99 8F ?? ?? ?? ?? ?? ?? 04 8E 1C 00 BF 8F ?? ?? 00 AE 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_516_1_0 {
	meta:
		name = "initshells"
		size = 560
		refs = "0000 _gp_disp 0048 __free_initshell_memory 005c __GI_fopen 0054 $LC0 0058 $LC1 0078 __GI_fileno 0090 __GI_fstat 00ac malloc 00d4 calloc 00f4 __GI___fsetlocking 0114 __GI_fgets_unlocked 0118 __GI___ctype_b 0170 __GI_fclose"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 20 FF BD 27 B8 00 B0 AF ?? ?? 90 8F 10 00 BC AF DC 00 BF AF ?? ?? 10 26 BC 00 B1 AF 21 C8 00 02 D8 00 BE AF D4 00 B7 AF D0 00 B6 AF CC 00 B5 AF C8 00 B4 AF C4 00 B3 AF C0 00 B2 AF ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F ?? ?? 84 8F ?? ?? 85 8F ?? ?? 99 8F ?? ?? 84 24 ?? ?? ?? ?? ?? ?? A5 24 21 88 40 00 4D 00 40 10 10 00 BC 8F ?? ?? 99 8F 21 20 40 00 ?? ?? ?? ?? 21 90 00 02 10 00 BC 8F 21 20 40 00 ?? ?? 99 8F ?? ?? ?? ?? 18 00 A5 27 FF FF 03 24 39 00 43 10 10 00 BC 8F 4C 00 B0 8F ?? ?? 99 8F ?? ?? ?? ?? 01 00 04 26 10 00 BC 8F ?? ?? 93 8F 31 00 40 10 ?? ?? 62 AE 03 00 04 24 1B 00 04 02 F4 01 80 00 ?? ?? 99 8F 04 00 05 24 ?? ?? ?? ?? 12 20 00 00 10 00 BC 8F ?? ?? 94 8F 26 00 40 10 ?? ?? 82 AE ?? ?? 99 8F 21 20 20 02 ?? ?? ?? ?? 02 00 05 24 10 00 BC 8F ?? ?? 92 8E ?? ?? 70 8E 4C 00 B7 8F ?? ?? 99 8F ?? ?? 96 8F 23 00 15 24 2F 00 1E 24 ?? ?? 65 8E B0 00 B9 AF 21 20 00 02 23 28 B0 00 21 28 E5 02 09 F8 20 03 21 30 20 02 10 00 BC 8F 0A 00 40 10 B0 00 B9 8F 00 00 02 82 F5 FF 55 10 ?? ?? 65 8E 16 00 5E 10 04 00 44 26 F2 FF 40 50 B0 00 B9 AF F8 FF 00 10 01 00 10 26 ?? ?? 99 8F 00 00 40 AE ?? ?? ?? ?? 21 20 20 02 1F 00 00 10 ?? ?? 82 8E 21 C8 40 02 09 F8 20 03 00 00 00 00 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 20 02 10 00 BC 8F ?? ?? 82 8F 14 00 00 10 ?? ?? 42 24 00 00 50 AE 00 00 02 82 00 00 C5 8E 40 18 02 00 21 18 A3 00 00 00 65 94 20 00 A5 30 07 00 A0 14 01 00 03 26 06 00 55 50 00 00 00 A2 04 00 40 50 00 00 00 A2 F3 FF 00 10 21 80 60 00 00 00 00 A2 21 90 80 00 CA FF 00 10 21 80 60 00 DC 00 BF 8F D8 00 BE 8F D4 00 B7 8F D0 00 B6 8F CC 00 B5 8F C8 00 B4 8F C4 00 B3 8F C0 00 B2 8F BC 00 B1 8F B8 00 B0 8F 08 00 E0 03 E0 00 BD 27 }
	condition:
		$1
}

rule file_516_2_0 {
	meta:
		name = "getusershell"
		size = 108
		refs = "0000 _gp_disp 0034 initshells"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 18 00 B0 AF ?? ?? 90 8F 10 00 BC AF 1C 00 BF AF ?? ?? 02 8E 08 00 40 14 ?? ?? 03 8E ?? ?? 99 8F ?? ?? 39 27 ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F ?? ?? 02 AE ?? ?? 03 8E 00 00 62 8C 03 00 40 10 ?? ?? 84 8F 04 00 63 24 ?? ?? 83 AC 1C 00 BF 8F 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_516_3_0 {
	meta:
		name = "endusershell"
		size = 64
		refs = "0000 _gp_disp 0020 __free_initshell_memory"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F E0 FF BD 27 1C 00 BF AF 10 00 BC AF ?? ?? 39 27 ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F 1C 00 BF 8F 20 00 BD 27 ?? ?? 82 8F 08 00 E0 03 ?? ?? 40 AC }
	condition:
		$1
}

rule file_516_4_0 {
	meta:
		name = "setusershell"
		size = 64
		refs = "0000 _gp_disp 0020 initshells"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F E0 FF BD 27 1C 00 BF AF 10 00 BC AF ?? ?? 39 27 ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F 1C 00 BF 8F 20 00 BD 27 ?? ?? 83 8F 08 00 E0 03 ?? ?? 62 AC }
	condition:
		$1
}

rule file_517_0_0 {
	meta:
		name = "__GI_readdir64_r"
		size = 352
		refs = "0000 _gp_disp 0010 _pthread_cleanup_push_defer 001c __pthread_mutex_unlock 0060 __pthread_mutex_lock 0070 __getdents64 00b0 __GI___errno_location 0104 __GI_memcpy 0124 _pthread_cleanup_pop_restore"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 B8 FF BD 27 ?? ?? 99 8F 3C 00 B4 AF 21 A0 A0 00 ?? ?? 85 8F 34 00 B2 AF 30 00 B1 AF 18 00 B2 27 18 00 91 24 10 00 BC AF 44 00 BF AF 40 00 B5 AF 38 00 B3 AF 2C 00 B0 AF 21 98 C0 00 21 80 80 00 21 30 20 02 ?? ?? ?? ?? 21 20 40 02 10 00 BC 8F 21 20 20 02 ?? ?? 99 8F ?? ?? ?? ?? 21 88 00 00 10 00 BC 8F ?? ?? 95 8F 08 00 03 8E 04 00 02 8E 2B 10 43 00 14 00 40 54 04 00 02 8E 00 00 04 8E 0C 00 05 8E 21 C8 A0 02 ?? ?? ?? ?? 14 00 06 8E 0A 00 40 1C 10 00 BC 8F 00 00 60 AE 1E 00 40 10 21 80 00 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 8C 18 00 00 10 10 00 BC 8F 08 00 02 AE 04 00 00 AE 04 00 02 8E 0C 00 11 8E 21 88 22 02 10 00 23 96 21 10 62 00 04 00 02 AE 08 00 22 8E 10 00 02 AE 00 00 22 8E 04 00 23 8E 25 10 43 00 DE FF 40 50 08 00 03 8E ?? ?? 99 8F 10 00 26 96 21 20 80 02 ?? ?? ?? ?? 21 28 20 02 10 00 BC 8F 00 00 74 AE 21 80 00 00 ?? ?? 99 8F 21 20 40 02 ?? ?? ?? ?? 01 00 05 24 44 00 BF 8F 21 10 00 00 0A 10 11 02 40 00 B5 8F 3C 00 B4 8F 38 00 B3 8F 34 00 B2 8F 30 00 B1 8F 2C 00 B0 8F 08 00 E0 03 48 00 BD 27 }
	condition:
		$1
}

rule file_518_0_0 {
	meta:
		name = "scandir"
		size = 516
		refs = "0000 _gp_disp 000c __GI_opendir 005c __GI___errno_location 0084 __GI_readdir 00c0 __GI_closedir 00dc free 0124 __GI_qsort 0158 realloc 0184 malloc 01a0 __GI_memcpy"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F B8 FF BD 27 10 00 BC AF 40 00 BE AF 3C 00 B7 AF 38 00 B6 AF 2C 00 B3 AF 44 00 BF AF 34 00 B5 AF 30 00 B4 AF 28 00 B2 AF 24 00 B1 AF 20 00 B0 AF 21 F0 A0 00 21 B0 C0 00 ?? ?? ?? ?? 21 B8 E0 00 21 98 40 00 3C 00 40 10 10 00 BC 8F ?? ?? 99 8F 21 80 00 00 ?? ?? ?? ?? 21 A8 00 00 00 00 59 8C 10 00 BC 8F 21 90 40 00 18 00 B9 AF 00 00 40 AC 21 88 00 00 ?? ?? 99 8F ?? ?? ?? ?? 21 20 60 02 21 A0 40 00 09 00 40 10 10 00 BC 8F 2C 00 C0 12 21 C8 C0 02 09 F8 20 03 21 20 80 02 28 00 40 14 10 00 BC 8F F3 FF 00 10 00 00 40 AE 00 00 54 8E ?? ?? 99 8F 11 00 80 12 21 20 60 02 ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F 08 00 00 12 ?? ?? 99 8F FF FF 10 26 80 10 10 00 21 10 22 02 ?? ?? ?? ?? 00 00 44 8C F8 FF 00 10 10 00 BC 8F ?? ?? ?? ?? 21 20 20 02 10 00 00 10 00 00 54 AE ?? ?? ?? ?? 00 00 00 00 18 00 B9 8F 10 00 BC 8F 07 00 E0 12 00 00 59 AE ?? ?? 99 8F 21 20 20 02 21 28 00 02 04 00 06 24 ?? ?? ?? ?? 21 38 E0 02 00 00 D1 AF 24 00 00 10 21 10 00 02 22 00 00 10 FF FF 02 24 0B 00 15 16 00 00 40 AE ?? ?? 99 8F 0A 00 02 24 40 A8 10 00 0A A8 50 00 21 20 20 02 ?? ?? ?? ?? 80 28 15 00 D1 FF 40 10 10 00 BC 8F 21 88 40 00 08 00 86 96 ?? ?? 99 8F 21 20 C0 00 ?? ?? ?? ?? 1C 00 A6 AF 10 00 BC 8F C8 FF 40 10 1C 00 A6 8F ?? ?? 99 8F 01 00 03 26 1C 00 A3 AF 21 20 40 00 21 28 80 02 ?? ?? ?? ?? 80 80 10 00 21 80 30 02 10 00 BC 8F 00 00 02 AE 1C 00 A3 8F AD FF 00 10 21 80 60 00 44 00 BF 8F 40 00 BE 8F 3C 00 B7 8F 38 00 B6 8F 34 00 B5 8F 30 00 B4 8F 2C 00 B3 8F 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 08 00 E0 03 48 00 BD 27 }
	condition:
		$1
}

rule file_519_0_0 {
	meta:
		name = "do_close"
		size = 96
		refs = "0000 _gp_disp 000c __GI___errno_location 003c __GI_close"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F D0 FF BD 27 2C 00 BF AF 28 00 B1 AF 24 00 B0 AF 10 00 BC AF 18 00 A4 AF ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F 00 00 51 8C 18 00 A4 8F ?? ?? 99 8F ?? ?? ?? ?? 21 80 40 00 00 00 11 AE 2C 00 BF 8F 28 00 B1 8F 24 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_519_1_0 {
	meta:
		name = "__GI_rtime"
		size = 628
		refs = "0000 _gp_disp 0020 __GI_socket 0084 __GI_sendto 00cc __GI_poll 00d0 __GI___errno_location 0130 __GI_recvfrom 0198 __GI_connect 01c4 do_close 01d4 __GI_read"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 98 FF BD 27 5C 00 B6 AF 02 00 16 24 58 00 B5 AF 4C 00 B2 AF ?? ?? 99 8F 01 00 15 24 21 90 C0 02 0B 90 A6 02 18 00 BC AF 54 00 B4 AF 50 00 B3 AF 48 00 B1 AF 44 00 B0 AF 64 00 BF AF 60 00 B7 AF 21 88 80 00 21 A0 A0 00 21 98 C0 00 02 00 04 24 21 28 40 02 ?? ?? ?? ?? 21 30 00 00 21 80 40 00 6C 00 40 04 18 00 BC 8F 00 25 02 24 00 00 36 A6 46 00 55 16 02 00 22 A6 ?? ?? 99 8F 10 00 02 24 3C 00 B5 27 10 00 B1 AF 14 00 A2 AF 21 20 00 02 21 28 A0 02 04 00 06 24 ?? ?? ?? ?? 21 38 00 00 36 00 40 04 18 00 BC 8F 04 00 66 8E E8 03 02 24 00 00 63 8E 1B 00 C2 00 F4 01 40 00 34 00 B2 A7 ?? ?? 97 8F ?? ?? 92 8F 30 00 B0 AF 30 00 B6 27 04 00 11 24 00 00 43 70 12 98 00 00 21 20 C0 02 01 00 05 24 21 C8 E0 02 ?? ?? ?? ?? 21 30 60 02 09 00 41 04 18 00 BC 8F 21 C8 40 02 ?? ?? ?? ?? 00 00 00 00 00 00 42 8C F4 FF 51 10 18 00 BC 8F 1B 00 00 10 ?? ?? 99 8F 12 00 40 10 21 28 A0 02 10 00 02 24 ?? ?? 99 8F 38 00 A2 AF 20 00 A2 27 10 00 A2 AF 38 00 A2 27 21 20 00 02 14 00 A2 AF 04 00 06 24 ?? ?? ?? ?? 21 38 00 00 18 00 BC 8F 21 88 40 00 21 20 00 02 ?? ?? 99 8F 21 00 00 10 ?? ?? 39 27 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 91 00 03 24 18 00 BC 8F 00 00 43 AC ?? ?? 99 8F 21 20 00 02 0C 00 00 10 ?? ?? 39 27 ?? ?? 99 8F 21 20 00 02 21 28 20 02 ?? ?? ?? ?? 10 00 06 24 18 00 BC 8F 21 20 00 02 ?? ?? 92 8F 06 00 41 04 ?? ?? 52 26 21 C8 40 02 ?? ?? ?? ?? 00 00 00 00 1E 00 00 10 FF FF 02 24 ?? ?? 99 8F 3C 00 A5 27 ?? ?? ?? ?? 04 00 06 24 21 88 40 00 21 20 00 02 21 C8 40 02 ?? ?? ?? ?? 00 00 00 00 09 00 20 06 18 00 BC 8F 04 00 02 24 08 00 22 52 3C 00 A2 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 05 00 03 24 00 00 43 AC 09 00 00 10 FF FF 02 24 55 7C 03 3C 80 81 63 34 A0 10 02 7C 02 14 22 00 21 10 43 00 00 00 82 AE 04 00 80 AE 21 10 00 00 64 00 BF 8F 60 00 B7 8F 5C 00 B6 8F 58 00 B5 8F 54 00 B4 8F 50 00 B3 8F 4C 00 B2 8F 48 00 B1 8F 44 00 B0 8F 08 00 E0 03 68 00 BD 27 }
	condition:
		$1
}

rule file_520_0_0 {
	meta:
		name = "wmemset"
		size = 36
	strings:
		$1 = { 21 10 80 00 21 18 80 00 04 00 C0 10 FF FF C6 24 00 00 65 AC FC FF 00 10 04 00 63 24 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_521_0_0 {
	meta:
		name = "__GI_clock_getres"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF A8 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_522_0_0 {
	meta:
		name = "__GI_herror"
		size = 184
		refs = "0000 _gp_disp 0044 __GI___h_errno_location 0080 stderr 0088 __GI_fprintf 0084 $LC0"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D0 FF BD 27 18 00 BC AF 28 00 B1 AF 2C 00 BF AF 24 00 B0 AF 04 00 80 10 21 88 80 00 00 00 82 80 04 00 40 54 ?? ?? 90 8F ?? ?? 90 8F 02 00 00 10 ?? ?? 10 26 ?? ?? 10 26 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 42 8C 05 00 43 2C 07 00 60 10 18 00 BC 8F ?? ?? 83 8F 80 10 02 00 ?? ?? 63 24 21 10 43 00 03 00 00 10 00 00 42 8C ?? ?? 82 8F ?? ?? 42 24 ?? ?? 83 8F ?? ?? 85 8F ?? ?? 99 8F 00 00 64 8C 21 30 20 02 21 38 00 02 10 00 A2 AF ?? ?? ?? ?? ?? ?? A5 24 2C 00 BF 8F 28 00 B1 8F 24 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_522_1_0 {
	meta:
		name = "hstrerror"
		size = 56
		refs = "0000 _gp_disp"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 05 00 82 2C 06 00 40 10 80 20 04 00 ?? ?? 82 8F ?? ?? 42 24 21 20 82 00 08 00 E0 03 00 00 82 8C ?? ?? 82 8F 08 00 E0 03 ?? ?? 42 24 }
	condition:
		$1
}

rule file_524_0_0 {
	meta:
		name = "__GI_fseek"
		size = 56
		refs = "0000 _gp_disp 000c __GI_fseeko64"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F D8 FF BD 27 C3 3F 05 00 24 00 BF AF 18 00 BC AF 10 00 A6 AF ?? ?? ?? ?? 21 30 A0 00 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_525_0_0 {
	meta:
		name = "print_and_abort"
		size = 72
		refs = "0000 _gp_disp 000c stderr 0024 __GI_fprintf 0014 $LC0 0018 $LC1 003c __GI_exit"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F E0 FF BD 27 ?? ?? 85 8F ?? ?? 86 8F 10 00 BC AF 1C 00 BF AF ?? ?? 99 8F 00 00 44 8C ?? ?? A5 24 ?? ?? ?? ?? ?? ?? C6 24 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 01 00 04 24 }
	condition:
		$1
}

rule file_525_1_0 {
	meta:
		name = "_obstack_begin"
		size = 256
		refs = "0000 _gp_disp 00a0 print_and_abort"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D8 FF BD 27 38 00 A3 8F 20 00 B2 AF 1C 00 B1 AF 18 00 B0 AF 10 00 BC AF 24 00 BF AF 20 00 83 AC 28 00 83 90 08 00 11 24 0B 88 C6 00 04 00 03 7C 28 00 83 A0 28 00 83 8C E8 0F 02 24 0B 10 A5 00 FF FF 32 26 01 00 63 30 21 80 80 00 1C 00 87 AC 00 00 82 AC 07 00 60 10 18 00 92 AC 24 00 84 8C 21 C8 E0 00 09 F8 20 03 21 28 40 00 05 00 00 10 10 00 BC 8F 21 C8 E0 00 09 F8 20 03 21 20 40 00 10 00 BC 8F 05 00 40 14 04 00 02 AE ?? ?? 99 8F ?? ?? 39 27 ?? ?? ?? ?? 00 00 00 00 08 00 43 24 21 90 72 00 00 00 03 8E 23 88 11 00 24 88 51 02 21 18 43 00 08 00 11 AE 0C 00 11 AE 00 00 43 AC 10 00 03 AE 04 00 40 AC 28 00 02 92 24 00 BF 8F 20 00 B2 8F 44 08 02 7C 84 10 02 7C 28 00 02 A2 1C 00 B1 8F 18 00 B0 8F 01 00 02 24 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_525_2_0 {
	meta:
		name = "_obstack_begin_1"
		size = 264
		refs = "0000 _gp_disp 00a8 print_and_abort"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D8 FF BD 27 38 00 A3 8F 18 00 B0 AF 21 80 80 00 20 00 03 AE 28 00 03 92 E8 0F 02 24 0B 10 A5 00 01 00 05 24 04 00 A3 7C 28 00 03 A2 28 00 03 8E 1C 00 B1 AF 3C 00 A4 8F 08 00 11 24 0B 88 C6 00 20 00 B2 AF 10 00 BC AF FF FF 32 26 01 00 63 30 24 00 BF AF 1C 00 07 AE 00 00 02 AE 18 00 12 AE 06 00 60 10 24 00 04 AE 21 C8 E0 00 09 F8 20 03 21 28 40 00 05 00 00 10 10 00 BC 8F 21 C8 E0 00 09 F8 20 03 21 20 40 00 10 00 BC 8F 05 00 40 14 04 00 02 AE ?? ?? 99 8F ?? ?? 39 27 ?? ?? ?? ?? 00 00 00 00 08 00 43 24 21 90 72 00 00 00 03 8E 23 88 11 00 24 88 51 02 21 18 43 00 08 00 11 AE 0C 00 11 AE 00 00 43 AC 10 00 03 AE 04 00 40 AC 28 00 02 92 24 00 BF 8F 20 00 B2 8F 44 08 02 7C 84 10 02 7C 28 00 02 A2 1C 00 B1 8F 18 00 B0 8F 01 00 02 24 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_525_3_0 {
	meta:
		name = "_obstack_newchunk"
		size = 456
		refs = "0000 _gp_disp 00a0 print_and_abort"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D0 FF BD 27 28 00 B3 AF 1C 00 B0 AF 10 00 BC AF 2C 00 BF AF 24 00 B2 AF 20 00 B1 AF 08 00 82 8C 0C 00 91 8C 21 80 80 00 04 00 92 8C 23 88 22 02 C3 10 11 00 21 28 25 02 21 98 A2 00 18 00 82 8C 21 98 62 02 00 00 82 8C 64 00 73 26 2A 18 62 02 0B 98 43 00 28 00 82 8C 01 00 42 30 06 00 40 10 1C 00 99 8C 24 00 84 8C 09 F8 20 03 21 28 60 02 04 00 00 10 10 00 BC 8F 09 F8 20 03 21 20 60 02 10 00 BC 8F 05 00 40 54 21 98 53 00 ?? ?? 99 8F ?? ?? 39 27 ?? ?? ?? ?? 00 00 00 00 04 00 02 AE 04 00 52 AC 10 00 13 AE 00 00 53 AC 18 00 03 8E 08 00 53 24 27 20 03 00 21 98 63 02 24 98 64 02 07 00 64 28 0E 00 80 14 21 18 00 00 82 18 11 00 FF FF 64 24 FF FF 06 24 08 00 86 10 80 28 04 00 08 00 07 8E FF FF 84 24 21 38 E5 00 00 00 E7 8C 21 28 65 02 F8 FF 00 10 00 00 A7 AC 80 18 03 00 2A 20 71 00 08 00 80 50 28 00 03 8E 08 00 04 8E 21 20 83 00 00 00 85 80 21 20 63 02 01 00 63 24 F7 FF 00 10 00 00 85 A0 02 00 63 30 17 00 60 54 28 00 02 92 18 00 03 8E 08 00 44 26 21 20 83 00 27 18 03 00 24 18 83 00 08 00 04 8E 0F 00 83 54 28 00 02 92 04 00 43 8E 04 00 43 AC 28 00 02 8E 01 00 42 30 06 00 40 10 20 00 19 8E 24 00 04 8E 09 F8 20 03 21 28 40 02 03 00 00 10 00 00 00 00 09 F8 20 03 21 20 40 02 28 00 02 92 2C 00 BF 8F 21 88 71 02 44 08 02 7C 08 00 13 AE 0C 00 11 AE 28 00 B3 8F 24 00 B2 8F 20 00 B1 8F 28 00 02 A2 1C 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_525_4_0 {
	meta:
		name = "_obstack_allocated_p"
		size = 48
	strings:
		$1 = { 04 00 82 8C 08 00 40 10 2B 18 45 00 03 00 60 54 00 00 43 8C FB FF 00 10 04 00 42 8C 2B 18 65 00 F8 FF 60 54 04 00 42 8C 08 00 E0 03 2B 10 02 00 }
	condition:
		$1
}

rule file_525_5_0 {
	meta:
		name = "obstack_free"
		size = 224
		refs = "0000 _gp_disp 00b8 __GI_abort"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D0 FF BD 27 24 00 B2 AF 20 00 B1 AF 1C 00 B0 AF 10 00 BC AF 2C 00 BF AF 28 00 B3 AF 21 88 A0 00 04 00 85 8C 21 80 80 00 01 00 12 24 1D 00 A0 10 2B 18 B1 00 12 00 60 54 00 00 A3 8C 28 00 03 8E 04 00 B3 8C 01 00 63 30 05 00 60 10 20 00 19 8E 09 F8 20 03 24 00 04 8E 04 00 00 10 10 00 BC 8F 09 F8 20 03 21 20 A0 00 10 00 BC 8F 28 00 02 92 21 28 60 02 44 08 42 7E EC FF 00 10 28 00 02 A2 2B 18 71 00 EE FF 60 54 28 00 03 8E 0C 00 11 AE 08 00 11 AE 00 00 A3 8C 04 00 05 AE 06 00 00 10 10 00 03 AE 05 00 20 12 2C 00 BF 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 2C 00 BF 8F 28 00 B3 8F 24 00 B2 8F 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_525_6_0 {
	meta:
		name = "_obstack_memory_used"
		size = 44
	strings:
		$1 = { 04 00 83 8C 21 10 00 00 06 00 60 10 00 00 00 00 00 00 64 8C 23 20 83 00 21 10 44 00 FA FF 00 10 04 00 63 8C 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_526_0_0 {
	meta:
		name = "_store_inttype"
		size = 64
	strings:
		$1 = { 00 01 02 24 03 00 A2 14 00 08 02 24 08 00 E0 03 00 00 86 A0 04 00 A2 54 00 02 02 24 00 00 86 AC 08 00 E0 03 04 00 87 AC 03 00 A2 14 00 00 00 00 08 00 E0 03 00 00 86 A4 08 00 E0 03 00 00 86 AC }
	condition:
		$1
}

rule file_527_0_0 {
	meta:
		name = "__GI_perror"
		size = 176
		refs = "0000 _gp_disp 0038 $LC0 004c stderr 0050 __GI___errno_location 0068 __GI___glibc_strerror_r 0084 __GI_fprintf 0080 $LC1"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 90 FF BD 27 18 00 BC AF 64 00 B1 AF 6C 00 BF AF 68 00 B2 AF 60 00 B0 AF 04 00 80 10 21 88 80 00 00 00 82 80 05 00 40 54 ?? ?? 90 8F ?? ?? 90 8F ?? ?? 10 26 02 00 00 10 21 88 00 02 ?? ?? 10 26 ?? ?? 82 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 52 8C 18 00 BC 8F 00 00 44 8C 20 00 A5 27 ?? ?? 99 8F ?? ?? ?? ?? 40 00 06 24 18 00 BC 8F 21 20 40 02 21 30 20 02 ?? ?? 85 8F ?? ?? 99 8F 21 38 00 02 10 00 A2 AF ?? ?? ?? ?? ?? ?? A5 24 6C 00 BF 8F 68 00 B2 8F 64 00 B1 8F 60 00 B0 8F 08 00 E0 03 70 00 BD 27 }
	condition:
		$1
}

rule file_528_0_0 {
	meta:
		name = "get_kernel_syms"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 22 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_529_0_0 {
	meta:
		name = "msync"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 30 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_530_0_0 {
	meta:
		name = "skip"
		size = 252
		refs = "0000 _gp_disp"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 21 10 80 00 21 28 00 00 22 00 08 24 01 00 07 24 23 00 09 24 20 00 0A 24 5C 00 0B 24 00 00 43 80 31 00 60 10 00 00 00 00 03 00 68 14 21 30 80 00 2A 00 00 10 01 00 A5 38 08 00 A7 54 00 00 4C 80 06 00 6B 54 00 00 4C 80 01 00 46 80 22 00 C6 38 01 00 C6 2C 21 10 46 00 00 00 4C 80 01 00 86 24 1E 00 A7 10 00 00 8C A0 05 00 69 54 F7 FF 64 24 ?? ?? 84 8F 00 00 40 A0 16 00 00 10 ?? ?? 83 A0 FF 00 84 30 02 00 84 2C 04 00 80 54 ?? ?? 84 8F 13 00 6A 54 01 00 42 24 ?? ?? 84 8F 00 00 40 A0 01 00 42 24 ?? ?? 83 A0 20 00 04 24 00 00 43 80 F7 FF 65 24 FF 00 A5 30 02 00 A5 2C 03 00 A0 10 00 00 00 00 F9 FF 00 10 01 00 42 24 F7 FF 64 50 01 00 42 24 04 00 00 10 21 20 C0 00 01 00 42 24 CE FF 00 10 21 20 C0 00 08 00 E0 03 FF FF 80 A0 }
	condition:
		$1
}

rule file_530_1_0 {
	meta:
		name = "__GI_setttyent"
		size = 140
		refs = "0000 _gp_disp 0028 __GI_rewind 0044 __GI_fopen 003c $LC0 0040 $LC1 0060 __GI___fsetlocking"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 18 00 B0 AF ?? ?? 90 8F 10 00 BC AF 1C 00 BF AF ?? ?? 04 8E 05 00 80 10 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 0E 00 00 10 00 00 00 00 ?? ?? 84 8F ?? ?? 85 8F ?? ?? 99 8F ?? ?? 84 24 ?? ?? ?? ?? ?? ?? A5 24 ?? ?? 02 AE 07 00 40 10 10 00 BC 8F ?? ?? 99 8F 21 20 40 00 ?? ?? ?? ?? 02 00 05 24 02 00 00 10 01 00 02 24 21 10 00 00 1C 00 BF 8F 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_530_2_0 {
	meta:
		name = "__GI_getttyent"
		size = 1092
		refs = "0000 _gp_disp 0048 __GI_setttyent 0060 malloc 0090 __GI_abort 00a8 __pthread_mutex_unlock 00b0 _pthread_cleanup_push_defer 00c8 __pthread_mutex_lock 00d8 __GI_strchr 00dc __GI___ctype_b 00e0 __GI___fgetc_unlocked 00e8 __GI_fgets_unlocked 01c0 skip 022c $LC2 0230 $LC3 0250 __GI_strncmp 0234 $LC4 032c $LC5 0400 _pthread_cleanup_pop_restore"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 A8 FF BD 27 30 00 B0 AF ?? ?? 90 8F 10 00 BC AF 54 00 BF AF ?? ?? 02 8E 50 00 BE AF 4C 00 B7 AF 48 00 B6 AF 44 00 B5 AF 40 00 B4 AF 3C 00 B3 AF 38 00 B2 AF 34 00 B1 AF 07 00 40 10 ?? ?? 99 8F ?? ?? 91 8F ?? ?? 22 8E 11 00 40 14 21 A8 20 02 07 00 00 10 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 F7 FF 40 14 10 00 BC 8F E7 00 00 10 21 10 00 00 ?? ?? ?? ?? 00 10 04 24 ?? ?? 22 AE 04 00 40 14 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 18 00 B9 27 ?? ?? 06 8E 21 20 20 03 ?? ?? 85 8F 28 00 B9 AF ?? ?? 99 8F 38 00 C6 24 ?? ?? ?? ?? 23 00 14 24 10 00 BC 8F ?? ?? 04 8E ?? ?? 99 8F ?? ?? ?? ?? 38 00 84 24 10 00 BC 8F ?? ?? 96 8F ?? ?? 97 8F ?? ?? 9E 8F ?? ?? B2 8E ?? ?? 99 8F ?? ?? 06 8E 21 20 40 02 ?? ?? ?? ?? 00 10 05 24 BD 00 40 10 10 00 BC 8F 21 20 40 02 21 C8 C0 02 ?? ?? ?? ?? 0A 00 05 24 16 00 40 14 10 00 BC 8F 0A 00 13 24 FF FF 11 24 ?? ?? 04 8E 10 00 82 8C 18 00 83 8C 2B 18 43 00 04 00 60 10 01 00 43 24 10 00 83 AC 05 00 00 10 00 00 42 90 21 C8 C0 03 ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F E3 FF 53 10 ?? ?? B2 8E F1 FF 51 14 ?? ?? 04 8E E0 FF 00 10 ?? ?? 99 8F 00 00 42 82 00 00 E5 8E 40 20 02 00 21 20 A4 00 00 00 84 94 20 00 84 30 03 00 80 10 ?? ?? 91 8F F7 FF 00 10 01 00 52 26 D3 FF 40 50 ?? ?? B2 8E D1 FF 54 50 ?? ?? B2 8E ?? ?? 8D 8F ?? ?? 90 8F ?? ?? 95 8F ?? ?? B2 AD 21 20 40 02 ?? ?? 19 26 ?? ?? ?? ?? ?? ?? A0 A2 ?? ?? A7 25 10 00 BC 8F 04 00 E2 AC 21 98 40 00 00 00 42 80 21 80 20 03 04 00 40 14 21 90 E0 00 08 00 E0 AC 0F 00 00 10 04 00 E0 AC ?? ?? ?? ?? 21 20 60 02 10 00 BC 8F 08 00 42 AE 21 98 40 00 00 00 42 80 03 00 40 14 21 C8 00 02 05 00 00 10 08 00 40 AE ?? ?? ?? ?? 21 20 60 02 10 00 BC 8F 21 98 40 00 ?? ?? 96 8F ?? ?? 97 8F ?? ?? 9E 8F 0C 00 40 AE 10 00 40 AE ?? ?? D6 26 ?? ?? F7 26 00 00 74 82 4F 00 80 12 ?? ?? 95 8F 21 20 60 02 21 28 C0 02 21 C8 A0 02 ?? ?? ?? ?? 03 00 06 24 0D 00 40 14 21 20 60 02 03 00 62 82 00 00 24 8E 40 10 02 00 21 10 82 00 00 00 42 94 20 00 42 30 05 00 40 50 21 20 60 02 0C 00 44 8E FE FF 02 24 11 00 00 10 24 10 82 00 21 28 E0 02 21 C8 A0 02 ?? ?? ?? ?? 02 00 06 24 0D 00 40 14 21 20 60 02 02 00 62 82 00 00 24 8E 40 10 02 00 21 10 82 00 00 00 42 94 20 00 42 30 05 00 40 10 21 20 60 02 0C 00 42 8E 01 00 42 34 24 00 00 10 0C 00 42 AE ?? ?? C5 27 21 C8 A0 02 ?? ?? ?? ?? 06 00 06 24 0C 00 40 14 10 00 BC 8F 06 00 62 82 00 00 24 8E 40 10 02 00 21 10 82 00 00 00 42 94 20 00 42 30 05 00 40 10 ?? ?? 85 8F 0C 00 42 8E EE FF 00 10 02 00 42 34 ?? ?? 85 8F 21 20 60 02 06 00 06 24 21 C8 A0 02 ?? ?? ?? ?? ?? ?? A5 24 11 00 40 14 10 00 BC 8F 06 00 64 82 3D 00 02 24 0D 00 82 14 ?? ?? 99 8F 21 20 60 02 ?? ?? ?? ?? 3D 00 05 24 01 00 44 24 0A 20 02 00 10 00 44 AE 21 C8 00 02 ?? ?? ?? ?? 21 20 60 02 21 98 40 00 B0 FF 00 10 10 00 BC 8F ?? ?? 82 8F ?? ?? 44 80 23 00 02 24 04 00 82 10 20 00 05 24 09 00 82 56 14 00 53 AE 20 00 05 24 09 00 04 24 01 00 62 82 FE FF 45 10 01 00 73 26 FD FF 44 50 01 00 62 82 14 00 53 AE 00 00 62 82 01 00 40 50 14 00 40 AE ?? ?? 99 8F 21 20 60 02 ?? ?? ?? ?? 0A 00 05 24 05 00 40 10 10 00 BC 8F 03 00 00 10 00 00 40 A0 02 00 00 10 21 80 00 00 21 80 40 02 ?? ?? 99 8F 18 00 A4 27 ?? ?? ?? ?? 01 00 05 24 21 10 00 02 54 00 BF 8F 50 00 BE 8F 4C 00 B7 8F 48 00 B6 8F 44 00 B5 8F 40 00 B4 8F 3C 00 B3 8F 38 00 B2 8F 34 00 B1 8F 30 00 B0 8F 08 00 E0 03 58 00 BD 27 }
	condition:
		$1
}

rule file_530_3_0 {
	meta:
		name = "__GI_endttyent"
		size = 88
		refs = "0000 _gp_disp 0028 __GI_fclose"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 18 00 B0 AF ?? ?? 90 8F 10 00 BC AF 1C 00 BF AF ?? ?? 04 8E 07 00 80 10 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 01 00 42 24 ?? ?? 00 AE 02 00 00 10 2B 10 02 00 01 00 02 24 1C 00 BF 8F 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_530_4_0 {
	meta:
		name = "getttynam"
		size = 156
		refs = "0000 _gp_disp 000c __GI_setttyent 0038 __GI_getttyent 003c __GI_strcmp 0070 __GI_endttyent"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F D0 FF BD 27 10 00 BC AF 28 00 B3 AF 24 00 B2 AF 20 00 B1 AF 2C 00 BF AF 1C 00 B0 AF ?? ?? ?? ?? 21 90 80 00 10 00 BC 8F ?? ?? 91 8F ?? ?? 93 8F 21 C8 20 02 ?? ?? ?? ?? 00 00 00 00 21 80 40 00 07 00 40 10 10 00 BC 8F 00 00 05 8E 21 C8 60 02 ?? ?? ?? ?? 21 20 40 02 F5 FF 40 14 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 2C 00 BF 8F 21 10 00 02 28 00 B3 8F 24 00 B2 8F 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_531_0_0 {
	meta:
		name = "__GI_strcasecmp"
		size = 104
		refs = "0000 _gp_disp 000c __GI___ctype_tolower"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 86 8F 0E 00 85 50 00 00 82 80 00 00 82 90 00 00 C3 8C 40 10 02 00 21 10 62 00 00 00 47 84 00 00 A2 90 40 10 02 00 21 18 62 00 00 00 62 84 23 10 E2 00 07 00 40 14 00 00 00 00 00 00 82 80 01 00 A5 24 03 00 40 10 01 00 83 24 ED FF 00 10 21 20 60 00 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_533_0_0 {
	meta:
		name = "__GI_sysconf"
		size = 1004
		refs = "0000 _gp_disp 0048 __GI___errno_location 0078 __GI_getdtablesize 0118 __GI_getpagesize 03b4 __GI_clock_getres"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 96 00 82 2C 10 00 BC AF 1C 00 BF AF 0A 00 40 10 80 20 04 00 ?? ?? 82 8F ?? ?? 42 24 21 20 44 00 00 00 82 8C 21 10 5C 00 08 00 40 00 00 00 00 00 E7 00 00 10 02 00 02 3C ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 16 00 03 24 00 00 43 AC E0 00 00 10 FF FF 02 24 DE 00 00 10 64 00 02 24 DC 00 00 10 01 00 02 3C 29 00 00 10 ?? ?? 99 8F D8 00 00 10 10 00 02 24 D6 00 00 10 06 00 02 24 D4 00 00 10 01 00 02 24 D2 00 00 10 01 00 02 24 D0 00 00 10 01 00 02 24 CE 00 00 10 01 00 02 24 CC 00 00 10 01 00 02 24 CA 00 00 10 01 00 02 24 C8 00 00 10 01 00 02 24 C6 00 00 10 01 00 02 24 C4 00 00 10 01 00 02 24 C2 00 00 10 01 00 02 24 C0 00 00 10 01 00 02 24 BE 00 00 10 01 00 02 24 BC 00 00 10 01 00 02 24 BA 00 00 10 01 00 02 24 B8 00 00 10 01 00 02 24 B6 00 00 10 01 00 02 24 03 00 02 3C B3 00 00 10 B0 0D 42 24 ?? ?? 99 8F 1C 00 BF 8F 08 00 20 03 20 00 BD 27 AD 00 00 10 14 00 02 24 FF 7F 02 3C AA 00 00 10 FF FF 42 34 A8 00 00 10 00 80 02 34 A6 00 00 10 20 00 02 24 A4 00 00 10 00 01 02 24 A2 00 00 10 63 00 02 24 A0 00 00 10 00 08 02 24 9E 00 00 10 63 00 02 24 9C 00 00 10 E8 03 02 24 9A 00 00 10 FF 00 02 24 98 00 00 10 20 00 02 24 96 00 00 10 00 08 02 24 94 00 00 10 FF 7F 02 24 92 00 00 10 00 08 02 24 03 00 02 3C 8F 00 00 10 B0 0D 42 24 03 00 02 3C 8C 00 00 10 B0 0D 42 24 03 00 02 3C 89 00 00 10 B0 0D 42 24 03 00 02 3C 86 00 00 10 B0 0D 42 24 03 00 02 3C 83 00 00 10 B0 0D 42 24 03 00 02 3C 80 00 00 10 B0 0D 42 24 7E 00 00 10 01 00 02 24 7C 00 00 10 01 00 02 24 7A 00 00 10 00 01 02 24 78 00 00 10 00 01 02 24 76 00 00 10 00 01 02 24 74 00 00 10 20 00 02 24 72 00 00 10 04 00 02 24 70 00 00 10 00 04 02 24 6E 00 00 10 00 40 02 24 6C 00 00 10 00 04 02 24 6A 00 00 10 01 00 02 24 68 00 00 10 01 00 02 24 66 00 00 10 01 00 02 24 64 00 00 10 01 00 02 24 62 00 00 10 01 00 02 24 60 00 00 10 01 00 02 24 5E 00 00 10 01 00 02 24 5C 00 00 10 01 00 02 24 FF 7F 02 3C 59 00 00 10 FF FF 42 34 57 00 00 10 00 10 02 24 55 00 00 10 F4 01 02 24 53 00 00 10 04 00 02 24 51 00 00 10 01 00 02 24 4F 00 00 10 01 00 02 24 4D 00 00 10 01 00 02 24 4B 00 00 10 01 00 02 24 49 00 00 10 01 00 02 24 47 00 00 10 01 00 02 24 45 00 00 10 01 00 02 24 43 00 00 10 08 00 02 24 41 00 00 10 7F 00 02 24 3F 00 00 10 80 FF 02 24 FF 7F 02 3C 3C 00 00 10 FF FF 42 34 3A 00 00 10 00 80 02 3C 38 00 00 10 20 00 02 24 36 00 00 10 20 00 02 24 34 00 00 10 10 00 02 24 32 00 00 10 14 00 02 24 30 00 00 10 FF 7F 02 24 2E 00 00 10 7F 00 02 24 2C 00 00 10 80 FF 02 24 2A 00 00 10 FF 7F 02 24 28 00 00 10 00 80 02 24 26 00 00 10 FF 00 02 24 24 00 00 10 FF FF 02 34 22 00 00 10 09 00 02 24 20 00 00 10 00 08 02 24 FF 7F 02 3C 1D 00 00 10 FF FF 42 34 FF 7F 02 3C 1A 00 00 10 FF FF 42 34 FF 7F 02 3C 17 00 00 10 FF FF 42 34 FF 7F 02 3C 14 00 00 10 FF FF 42 34 12 00 00 10 01 00 02 24 10 00 00 10 01 00 02 24 0E 00 00 10 01 00 02 24 0C 00 00 10 01 00 02 24 ?? ?? 99 8F 01 00 04 24 ?? ?? ?? ?? 21 28 00 00 05 00 40 04 03 00 02 3C 04 00 00 10 B0 0D 42 24 02 00 00 10 FF FF 02 24 FF FF 02 24 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_534_0_0 {
	meta:
		name = "capset"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 6D 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_535_0_0 {
	meta:
		name = "__xstat_conv"
		size = 216
		refs = "0000 _gp_disp 000c __GI_memset"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F D8 FF BD 27 98 00 06 24 24 00 BF AF 20 00 B1 AF 1C 00 B0 AF 21 88 80 00 21 80 A0 00 10 00 BC AF 21 20 A0 00 ?? ?? ?? ?? 21 28 00 00 00 00 22 8E 04 00 00 AE 00 00 02 AE 10 00 22 8E 10 00 02 AE 14 00 22 8E 14 00 02 AE 18 00 22 8E 18 00 02 AE 1C 00 22 8E 1C 00 02 AE 20 00 22 8E 20 00 02 AE 24 00 22 8E 2C 00 00 AE 28 00 02 AE 30 00 22 8E 34 00 02 AE 50 00 22 8E 54 00 02 AE 54 00 22 8E 58 00 02 AE 38 00 22 8E 3C 00 02 AE 40 00 22 8E 44 00 02 AE 48 00 22 8E 4C 00 02 AE 3C 00 22 8E 40 00 02 AE 44 00 22 8E 48 00 02 AE 4C 00 22 8E 50 00 02 AE 24 00 BF 8F 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_535_1_0 {
	meta:
		name = "__xstat64_conv"
		size = 240
		refs = "0000 _gp_disp 000c __GI_memset"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F D8 FF BD 27 A0 00 06 24 24 00 BF AF 20 00 B1 AF 1C 00 B0 AF 21 88 80 00 21 80 A0 00 10 00 BC AF 21 20 A0 00 ?? ?? ?? ?? 21 28 00 00 00 00 22 8E 04 00 00 AE 00 00 02 AE 10 00 22 8E 14 00 23 8E 10 00 02 AE 14 00 03 AE 18 00 22 8E 18 00 02 AE 1C 00 22 8E 1C 00 02 AE 20 00 22 8E 20 00 02 AE 24 00 22 8E 24 00 02 AE 28 00 22 8E 2C 00 00 AE 28 00 02 AE 38 00 22 8E 3C 00 23 8E 38 00 02 AE 3C 00 03 AE 58 00 22 8E 58 00 02 AE 60 00 22 8E 64 00 23 8E 60 00 02 AE 64 00 03 AE 40 00 22 8E 40 00 02 AE 48 00 22 8E 48 00 02 AE 50 00 22 8E 50 00 02 AE 44 00 22 8E 24 00 BF 8F 44 00 02 AE 4C 00 22 8E 4C 00 02 AE 54 00 22 8E 20 00 B1 8F 54 00 02 AE 1C 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_537_0_0 {
	meta:
		name = "wcsncat"
		size = 68
	strings:
		$1 = { 21 10 80 00 21 18 80 00 00 00 64 8C 09 00 80 10 04 00 67 24 FC FF 00 10 21 18 E0 00 04 00 A7 24 06 00 80 10 00 00 64 AC FF FF C6 24 04 00 63 24 21 28 E0 00 F9 FF C0 54 00 00 A4 8C 08 00 E0 03 00 00 60 AC }
	condition:
		$1
}

rule file_538_0_0 {
	meta:
		name = "seed48"
		size = 64
		refs = "0000 _gp_disp 000c __libc_drand48_data 0010 __GI_seed48_r"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 85 8F ?? ?? 99 8F E0 FF BD 27 1C 00 BF AF 10 00 BC AF ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F 1C 00 BF 8F 20 00 BD 27 ?? ?? 82 8F 08 00 E0 03 06 00 42 24 }
	condition:
		$1
}

rule file_541_0_0 {
	meta:
		name = "wcsncmp"
		size = 60
	strings:
		$1 = { 0A 00 C0 10 00 00 00 00 00 00 82 8C 00 00 A3 8C 08 00 43 14 00 00 00 00 04 00 40 10 04 00 84 24 04 00 A5 24 F6 FF 00 10 FF FF C6 24 08 00 E0 03 21 10 00 00 08 00 E0 03 23 10 43 00 }
	condition:
		$1
}

rule file_543_3_0 {
	meta:
		name = "__GI_getservent_r"
		size = 780
		refs = "0000 _gp_disp 0050 __GI___errno_location 0070 _pthread_cleanup_push_defer 0078 __pthread_mutex_unlock 009c __pthread_mutex_lock 00e4 $LC2 00f0 $LC3 00f4 __GI_fgets 0124 __GI_fopen 011c $LC0 0120 $LC1 016c __GI_strpbrk 01d4 $LC4 01f8 __GI_atoi 02c8 _pthread_cleanup_pop_restore"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 A8 FF BD 27 8C 00 C2 2C 10 00 BC AF 40 00 B4 AF 34 00 B1 AF 54 00 BF AF 50 00 BE AF 4C 00 B7 AF 48 00 B6 AF 44 00 B5 AF 3C 00 B3 AF 38 00 B2 AF 30 00 B0 AF 21 88 C0 00 21 A0 E0 00 08 00 40 10 00 00 E0 AC ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 22 00 03 24 00 00 43 AC 9D 00 00 10 22 00 02 24 ?? ?? 95 8F ?? ?? 99 8F 21 90 A0 00 ?? ?? 85 8F 18 00 B3 27 ?? ?? A6 26 21 80 80 00 ?? ?? ?? ?? 21 20 60 02 10 00 BC 8F 74 FF 31 26 ?? ?? A4 26 ?? ?? 99 8F ?? ?? ?? ?? 01 10 31 2E 08 00 20 12 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 22 00 10 24 22 00 03 24 10 00 BC 8F 80 00 00 10 00 00 43 AC ?? ?? 91 8F 8C 00 59 26 28 00 B9 AF ?? ?? 22 8E 0F 00 40 10 21 B0 20 02 ?? ?? 97 8F ?? ?? 9E 8F ?? ?? F7 26 ?? ?? DE 27 ?? ?? 99 8F 28 00 A4 8F ?? ?? C6 8E ?? ?? ?? ?? 00 10 05 24 21 A8 40 00 13 00 40 14 10 00 BC 8F 0B 00 00 10 ?? ?? 99 8F ?? ?? 84 8F ?? ?? 85 8F ?? ?? 99 8F ?? ?? 84 24 ?? ?? ?? ?? ?? ?? A5 24 ?? ?? 22 AE EA FF 40 14 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 05 00 10 24 05 00 03 24 10 00 BC 8F 5C 00 00 10 00 00 43 AC 00 00 43 80 23 00 02 24 E3 FF 62 10 21 20 A0 02 ?? ?? 91 8F 21 C8 20 02 ?? ?? ?? ?? 21 28 E0 02 DD FF 40 10 10 00 BC 8F 00 00 40 A0 21 20 A0 02 00 00 15 AE 21 C8 20 02 ?? ?? ?? ?? 21 28 C0 03 10 00 BC 8F D4 FF 40 10 ?? ?? 95 8F 01 00 43 24 00 00 40 A0 20 00 05 24 09 00 04 24 00 00 62 80 03 00 45 14 00 00 00 00 FC FF 00 10 01 00 63 24 FA FF 44 50 01 00 63 24 ?? ?? 82 8F 21 20 60 00 2C 00 A3 AF 21 C8 20 02 ?? ?? ?? ?? ?? ?? 45 24 10 00 BC 8F C0 FF 40 10 2C 00 A3 8F ?? ?? 99 8F 21 20 60 00 00 00 40 A0 ?? ?? ?? ?? 01 00 56 24 10 00 BC 8F 00 1A 02 00 00 FF 63 30 ?? ?? 99 8F 00 3A 42 7C 25 10 62 00 08 00 02 AE 0C 00 16 AE 04 00 12 AE 21 20 C0 02 ?? ?? ?? ?? ?? ?? A5 26 04 00 40 10 10 00 BC 8F 01 00 44 24 02 00 00 10 00 00 40 A0 21 20 00 00 20 00 16 24 09 00 17 24 88 00 5E 26 ?? ?? B5 26 16 00 80 50 00 00 40 AE 00 00 82 80 13 00 40 50 00 00 40 AE FA FF 56 50 01 00 84 24 03 00 57 14 2B 10 5E 02 F6 FF 00 10 01 00 84 24 03 00 40 10 21 C8 20 02 00 00 44 AE 04 00 52 26 ?? ?? ?? ?? 21 28 A0 02 04 00 40 10 10 00 BC 8F 01 00 44 24 EB FF 00 10 00 00 40 A0 00 00 40 AE 00 00 90 AE 21 80 00 00 ?? ?? 99 8F 21 20 60 02 ?? ?? ?? ?? 01 00 05 24 21 10 00 02 54 00 BF 8F 50 00 BE 8F 4C 00 B7 8F 48 00 B6 8F 44 00 B5 8F 40 00 B4 8F 3C 00 B3 8F 38 00 B2 8F 34 00 B1 8F 30 00 B0 8F 08 00 E0 03 58 00 BD 27 }
	condition:
		$1
}

rule file_543_5_0 {
	meta:
		name = "__GI_getservbyname_r"
		size = 392
		refs = "0000 _gp_disp 0018 _pthread_cleanup_push_defer 0024 __pthread_mutex_unlock 006c __pthread_mutex_lock 0080 __GI_setservent 0090 __GI_strcmp 0094 __GI_getservent_r 0124 _pthread_cleanup_pop_restore 0128 __GI_endservent"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 B0 FF BD 27 3C 00 B5 AF ?? ?? 95 8F ?? ?? 99 8F 38 00 B4 AF 21 A0 A0 00 ?? ?? 85 8F 30 00 B2 AF 18 00 B2 27 4C 00 BF AF 10 00 BC AF 48 00 BE AF 44 00 B7 AF 34 00 B3 AF 28 00 B0 AF 40 00 B6 AF 2C 00 B1 AF 21 98 80 00 21 80 C0 00 21 20 40 02 ?? ?? A6 26 ?? ?? ?? ?? 21 B8 E0 00 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? ?? ?? A4 26 10 00 BC 8F ?? ?? 95 8F ?? ?? 99 8F ?? ?? ?? ?? ?? ?? A4 8E 10 00 BC 8F ?? ?? 9E 8F ?? ?? 99 8F 60 00 A6 8F 64 00 A7 8F 21 20 00 02 ?? ?? ?? ?? 21 28 E0 02 21 88 40 00 1A 00 40 14 10 00 BC 8F 00 00 05 8E 21 C8 C0 03 ?? ?? ?? ?? 21 20 60 02 10 00 BC 8F 0B 00 40 10 ?? ?? 91 8F 04 00 16 8E 00 00 C5 8E ED FF A0 10 21 C8 20 02 ?? ?? ?? ?? 21 20 60 02 03 00 40 10 10 00 BC 8F F8 FF 00 10 04 00 D6 26 06 00 80 12 21 C8 20 02 0C 00 04 8E ?? ?? ?? ?? 21 28 80 02 E0 FF 40 14 10 00 BC 8F 21 88 00 00 ?? ?? A3 8E 06 00 60 14 ?? ?? 99 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F ?? ?? 99 8F 21 20 40 02 ?? ?? ?? ?? 01 00 05 24 64 00 A3 8F 4C 00 BF 8F 48 00 BE 8F 00 00 62 8C 44 00 B7 8F 40 00 B6 8F 0B 88 02 00 21 10 20 02 3C 00 B5 8F 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 E0 03 50 00 BD 27 }
	condition:
		$1
}

rule file_543_6_0 {
	meta:
		name = "getservbyname"
		size = 116
		refs = "0000 _gp_disp 0028 __initbuf 0044 __GI_getservbyname_r"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F C8 FF BD 27 34 00 BF AF 18 00 BC AF 28 00 A4 AF 2C 00 A5 AF ?? ?? 39 27 ?? ?? ?? ?? 00 00 00 00 18 00 BC 8F 28 00 A4 8F 2C 00 A5 8F ?? ?? 82 8F ?? ?? 86 8F ?? ?? 99 8F ?? ?? 47 8C 8D 10 02 24 10 00 A2 AF 20 00 A2 27 14 00 A2 AF ?? ?? ?? ?? ?? ?? C6 24 34 00 BF 8F 20 00 A2 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_543_8_0 {
	meta:
		name = "__GI_getservbyport"
		size = 116
		refs = "0000 _gp_disp 0028 __initbuf 0044 __GI_getservbyport_r"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F C8 FF BD 27 34 00 BF AF 18 00 BC AF 28 00 A4 AF 2C 00 A5 AF ?? ?? 39 27 ?? ?? ?? ?? 00 00 00 00 18 00 BC 8F 28 00 A4 8F 2C 00 A5 8F ?? ?? 82 8F ?? ?? 86 8F ?? ?? 99 8F ?? ?? 47 8C 8D 10 02 24 10 00 A2 AF 20 00 A2 27 14 00 A2 AF ?? ?? ?? ?? ?? ?? C6 24 34 00 BF 8F 20 00 A2 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_543_7_0 {
	meta:
		name = "__GI_getservbyport_r"
		size = 336
		refs = "0000 _gp_disp 0018 _pthread_cleanup_push_defer 0024 __pthread_mutex_unlock 006c __pthread_mutex_lock 0080 __GI_setservent 0090 __GI_getservent_r 0094 __GI_strcmp 00ec _pthread_cleanup_pop_restore 00f0 __GI_endservent"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 B0 FF BD 27 2C 00 B1 AF ?? ?? 91 8F ?? ?? 99 8F 34 00 B3 AF 21 98 A0 00 ?? ?? 85 8F 30 00 B2 AF 18 00 B2 27 4C 00 BF AF 10 00 BC AF 48 00 BE AF 44 00 B7 AF 40 00 B6 AF 3C 00 B5 AF 38 00 B4 AF 28 00 B0 AF 21 B8 80 00 21 80 C0 00 21 20 40 02 ?? ?? 26 26 ?? ?? ?? ?? 21 B0 E0 00 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? ?? ?? 24 26 10 00 BC 8F ?? ?? 94 8F ?? ?? 99 8F ?? ?? ?? ?? ?? ?? 84 8E 10 00 BC 8F ?? ?? 95 8F ?? ?? 9E 8F 60 00 A6 8F 64 00 A7 8F 21 20 00 02 21 C8 A0 02 ?? ?? ?? ?? 21 28 C0 02 21 88 40 00 0B 00 40 14 10 00 BC 8F 08 00 02 8E F6 FF 57 14 60 00 A6 8F 06 00 60 12 21 C8 C0 03 0C 00 04 8E ?? ?? ?? ?? 21 28 60 02 EE FF 40 14 10 00 BC 8F ?? ?? 82 8E 06 00 40 14 ?? ?? 99 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F ?? ?? 99 8F 21 20 40 02 ?? ?? ?? ?? 01 00 05 24 64 00 A3 8F 4C 00 BF 8F 48 00 BE 8F 00 00 62 8C 44 00 B7 8F 40 00 B6 8F 0B 88 02 00 21 10 20 02 3C 00 B5 8F 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 E0 03 50 00 BD 27 }
	condition:
		$1
}

rule file_544_0_0 {
	meta:
		name = "__GI_readlink"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF F5 0F 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_546_0_0 {
	meta:
		name = "__decode_header"
		size = 188
	strings:
		$1 = { 00 00 82 90 01 00 83 90 00 12 02 00 25 10 43 00 00 00 A2 AC 02 00 82 80 C2 17 02 00 04 00 A2 AC 02 00 82 90 C0 18 42 7C 08 00 A2 AC 02 00 82 90 80 00 42 7C 0C 00 A2 AC 02 00 82 90 40 00 42 7C 10 00 A2 AC 02 00 82 90 01 00 42 30 14 00 A2 AC 03 00 82 80 C2 17 02 00 18 00 A2 AC 03 00 82 90 0F 00 42 30 1C 00 A2 AC 04 00 82 90 05 00 83 90 00 12 02 00 25 10 43 00 20 00 A2 AC 06 00 82 90 07 00 83 90 00 12 02 00 25 10 43 00 24 00 A2 AC 08 00 82 90 09 00 83 90 00 12 02 00 25 10 43 00 28 00 A2 AC 0A 00 82 90 0B 00 83 90 00 12 02 00 25 10 43 00 08 00 E0 03 2C 00 A2 AC }
	condition:
		$1
}

rule file_547_0_0 {
	meta:
		name = "__GI_truncate"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF FC 0F 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_548_0_0 {
	meta:
		name = "wcstok"
		size = 180
		refs = "0000 _gp_disp 0040 __GI_wcsspn 0064 __GI_wcspbrk"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D8 FF BD 27 10 00 BC AF 20 00 B2 AF 1C 00 B1 AF 18 00 B0 AF 24 00 BF AF 21 80 80 00 21 90 A0 00 04 00 80 14 21 88 C0 00 00 00 D0 8C 17 00 00 52 21 80 00 00 ?? ?? 99 8F 21 20 00 02 ?? ?? ?? ?? 21 28 40 02 80 10 02 00 21 80 02 02 00 00 02 8E 09 00 40 10 10 00 BC 8F ?? ?? 99 8F 21 20 00 02 ?? ?? ?? ?? 21 28 40 02 06 00 40 10 04 00 43 24 05 00 00 10 00 00 40 AC 21 18 00 00 02 00 00 10 21 80 00 00 21 18 00 00 00 00 23 AE 24 00 BF 8F 21 10 00 02 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_549_0_0 {
	meta:
		name = "__GI_mmap"
		size = 108
		refs = "0000 _gp_disp 0044 __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 18 00 B0 AF 1C 00 BF AF 34 00 B0 8F 30 00 A2 8F E0 FF BD 27 10 00 A2 AF 14 00 B0 AF FA 0F 02 24 0C 00 00 00 20 00 BD 27 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_550_0_0 {
	meta:
		name = "_time_t2tm"
		size = 484
		refs = "0000 _gp_disp"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 21 10 C0 00 1C 00 C0 AC 21 38 C0 00 ?? ?? 86 8F 00 00 83 8C 02 00 04 3C 76 0E 84 24 ?? ?? C6 24 07 00 08 24 21 28 A4 00 00 00 CA 94 0C 00 48 15 21 20 40 01 1A 00 68 00 F4 01 00 01 21 18 65 00 10 20 00 00 0B 00 84 24 1A 00 88 00 F4 01 00 01 02 00 C4 94 80 20 04 00 01 00 84 24 10 58 00 00 1A 00 64 00 F4 01 80 00 12 48 00 00 02 60 24 71 23 18 6C 00 03 00 61 04 00 00 00 00 21 18 64 00 FF FF 29 25 09 00 48 15 3D 00 8A 28 FF FF 8A 24 06 00 6A 14 3D 00 8A 28 10 00 EA 8C FE FF 83 24 01 00 4A 25 10 00 EA AC 3D 00 8A 28 04 00 40 11 04 00 E4 24 00 00 E3 AC 02 00 00 10 21 18 20 01 00 00 E9 AC 02 00 C6 24 00 00 C9 94 D6 FF 20 15 21 38 80 00 FC FF 86 8C 04 00 05 24 05 00 C5 54 00 00 85 8C 03 00 03 24 FC FF 83 AC 6D 01 03 24 00 00 85 8C F4 FF 86 8C 19 00 07 24 21 18 65 00 F0 FF 85 8C 00 00 83 AC 80 28 05 00 21 28 A6 00 02 40 A7 70 F8 FF 86 8C 21 28 06 01 FC FF 86 8C 80 28 05 00 FC FF 8B AC 21 28 A6 00 D5 FE A6 24 41 06 A5 24 F8 FF 86 AC 03 00 A6 30 0E 00 C0 54 ?? ?? 85 8F 64 00 06 24 1A 00 A6 00 F4 01 C0 00 10 38 00 00 0A 00 E0 54 ?? ?? 85 8F 90 01 06 24 1A 00 A6 00 F4 01 C0 00 10 38 00 00 04 00 E0 50 ?? ?? 85 8F ?? ?? 85 8F 02 00 00 10 ?? ?? A5 24 ?? ?? A5 24 01 00 63 24 F4 FF 80 AC 00 00 A6 90 2A 38 C3 00 09 00 E0 10 F5 FF A7 24 23 18 66 00 1D 00 C6 38 0A 28 E6 00 F4 FF 86 8C 01 00 A5 24 01 00 C6 24 F5 FF 00 10 F4 FF 86 AC F0 FF 83 AC ?? ?? 83 8F 04 00 80 AC 24 00 40 AC ?? ?? 63 24 08 00 E0 03 28 00 43 AC }
	condition:
		$1
}

rule file_551_0_0 {
	meta:
		name = "creat"
		size = 28
		refs = "0000 _gp_disp 000c __GI_open"
		altNames = "creat64"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F 21 30 A0 00 ?? ?? ?? ?? 01 03 05 24 }
	condition:
		$1
}

rule file_552_0_0 {
	meta:
		name = "atexit"
		size = 40
		refs = "0000 _gp_disp 000c __dso_handle 001c __cxa_atexit"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F 02 00 40 50 21 30 00 00 00 00 46 8C ?? ?? 99 8F ?? ?? ?? ?? 21 28 00 00 }
	condition:
		$1
}

rule file_553_0_0 {
	meta:
		name = "__GI_signal"
		size = 196
		refs = "0000 _gp_disp 0034 __GI___errno_location 004c __GI___sigaddset 0074 _sigintr 0078 __GI___sigismember 0090 __GI_sigaction"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 A8 FF BD 27 FF FF 02 24 10 00 BC AF 54 00 BF AF 50 00 B0 AF 04 00 A2 10 FF FF 82 24 80 00 42 2C 07 00 40 14 21 80 80 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 16 00 03 24 1A 00 00 10 00 00 43 AC ?? ?? 99 8F 38 00 A5 AF 3C 00 A4 27 21 28 00 02 48 00 A0 AF 44 00 A0 AF 40 00 A0 AF ?? ?? ?? ?? 3C 00 A0 AF 10 00 BC 8F ?? ?? 84 8F ?? ?? 99 8F ?? ?? ?? ?? 21 28 00 02 10 00 BC 8F 00 10 03 3C 0B 18 02 00 ?? ?? 99 8F 34 00 A3 AF 21 20 00 02 34 00 A5 27 ?? ?? ?? ?? 18 00 A6 27 02 00 41 04 1C 00 A2 8F FF FF 02 24 54 00 BF 8F 50 00 B0 8F 08 00 E0 03 58 00 BD 27 }
	condition:
		$1
}

rule file_554_0_0 {
	meta:
		name = "pathconf"
		size = 320
		refs = "0000 _gp_disp 002c __GI___errno_location 009c __libc_statfs 00dc __GI_stat"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 38 FF BD 27 10 00 BC AF C4 00 BF AF C0 00 B1 AF BC 00 B0 AF 00 00 82 80 06 00 40 54 14 00 A2 2C ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 10 00 00 10 02 00 03 24 0A 00 40 10 80 28 05 00 ?? ?? 82 8F ?? ?? 42 24 21 28 45 00 00 00 A2 8C 21 10 5C 00 08 00 40 00 00 00 00 00 31 00 00 10 7F 00 02 24 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 16 00 03 24 28 00 00 10 00 00 43 AC ?? ?? 99 8F ?? ?? ?? ?? B0 00 A4 AF 10 00 BC 8F B0 00 A4 8F 18 00 A5 27 ?? ?? 99 8F 21 80 40 00 ?? ?? ?? ?? 00 00 51 8C 1F 00 41 04 40 00 A2 8F 00 00 04 8E 59 00 03 24 1B 00 83 14 FF FF 02 24 18 00 00 10 00 00 11 AE 17 00 00 10 00 10 02 24 15 00 00 10 21 10 00 00 ?? ?? 99 8F ?? ?? ?? ?? 18 00 A5 27 0D 00 40 04 2C 00 A3 8F 00 80 02 34 00 F0 63 30 05 00 62 10 00 60 63 38 01 00 02 24 FF FF 04 24 08 00 00 10 0B 10 83 00 06 00 00 10 01 00 02 24 04 00 00 10 20 00 02 24 02 00 00 10 FF FF 02 24 FF 00 02 24 C4 00 BF 8F C0 00 B1 8F BC 00 B0 8F 08 00 E0 03 C8 00 BD 27 }
	condition:
		$1
}

rule file_555_0_0 {
	meta:
		name = "__GI_jrand48_r"
		size = 100
		refs = "0000 _gp_disp 000c __drand48_iterate"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F D8 FF BD 27 20 00 B1 AF 1C 00 B0 AF 10 00 BC AF 24 00 BF AF 21 80 80 00 ?? ?? ?? ?? 21 88 C0 00 07 00 42 04 FF FF 02 24 04 00 02 96 02 00 03 96 00 14 02 00 25 10 43 00 00 00 22 AE 21 10 00 00 24 00 BF 8F 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_556_0_0 {
	meta:
		name = "popen"
		size = 552
		refs = "0000 _gp_disp 0058 __GI___errno_location 0074 malloc 008c __GI_pipe 00c4 __GI_fdopen 00e0 __GI_close 00fc fork 0124 __GI_dup2 0178 __GI_execl 016c $LC0 0170 $LC1 0174 $LC2 0198 __GI__exit 01d8 __GI_fclose 01ec free"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 B0 FF BD 27 48 00 B7 AF 3C 00 B4 AF 18 00 BC AF 4C 00 BF AF 44 00 B6 AF 40 00 B5 AF 38 00 B3 AF 34 00 B2 AF 30 00 B1 AF 2C 00 B0 AF 00 00 A2 80 77 00 03 24 21 B8 80 00 0A 00 43 10 21 A0 A0 00 72 00 03 24 08 00 43 10 01 00 13 24 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 16 00 03 24 63 00 00 10 00 00 43 AC 21 98 00 00 ?? ?? 99 8F ?? ?? ?? ?? 0C 00 04 24 21 80 40 00 5C 00 40 10 18 00 BC 8F ?? ?? 99 8F 20 00 B1 27 ?? ?? ?? ?? 21 20 20 02 53 00 40 14 18 00 BC 8F 80 10 13 00 21 10 22 02 00 00 52 8C 01 00 02 24 23 10 53 00 80 10 02 00 21 88 22 02 00 00 35 8E ?? ?? 99 8F 21 28 80 02 ?? ?? ?? ?? 21 20 A0 02 18 00 BC 8F 21 A0 40 00 07 00 40 14 ?? ?? 91 8F 21 C8 20 02 ?? ?? ?? ?? 21 20 A0 02 21 20 40 02 3A 00 00 10 21 C8 20 02 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 26 00 40 14 21 B0 40 00 21 C8 20 02 ?? ?? ?? ?? 21 20 A0 02 09 00 53 12 18 00 BC 8F ?? ?? 99 8F 21 20 40 02 ?? ?? ?? ?? 21 28 60 02 21 C8 20 02 ?? ?? ?? ?? 21 20 40 02 18 00 BC 8F ?? ?? 82 8F ?? ?? 50 8C 07 00 00 12 21 C8 20 02 04 00 02 8E ?? ?? ?? ?? 04 00 44 8C 18 00 BC 8F F9 FF 00 10 00 00 10 8E ?? ?? 84 8F ?? ?? 85 8F ?? ?? 86 8F ?? ?? 99 8F ?? ?? 84 24 10 00 A0 AF ?? ?? A5 24 ?? ?? C6 24 ?? ?? ?? ?? 21 38 E0 02 18 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 7F 00 04 24 21 C8 20 02 ?? ?? ?? ?? 21 20 40 02 09 00 C0 1A 18 00 BC 8F ?? ?? 82 8F 08 00 16 AE 04 00 14 AE ?? ?? 43 8C ?? ?? 50 AC 21 10 80 02 0A 00 00 10 00 00 03 AE ?? ?? 99 8F 21 20 80 02 09 F8 20 03 00 00 00 00 18 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 00 02 21 10 00 00 4C 00 BF 8F 48 00 B7 8F 44 00 B6 8F 40 00 B5 8F 3C 00 B4 8F 38 00 B3 8F 34 00 B2 8F 30 00 B1 8F 2C 00 B0 8F 08 00 E0 03 50 00 BD 27 }
	condition:
		$1
}

rule file_556_1_0 {
	meta:
		name = "pclose"
		size = 280
		refs = "0000 _gp_disp 006c __GI___errno_location 00a8 free 00c0 __GI_fclose 00d0 __GI_waitpid"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 83 8F C8 FF BD 27 10 00 BC AF ?? ?? 62 8C 34 00 BF AF 30 00 B4 AF 2C 00 B3 AF 28 00 B2 AF 24 00 B1 AF 20 00 B0 AF 1A 00 40 10 21 80 80 00 04 00 44 8C 08 00 90 14 00 00 44 8C ?? ?? 64 AC 16 00 00 10 21 20 40 00 0B 00 70 50 00 00 83 8C 21 10 80 00 00 00 44 8C FB FF 80 54 04 00 83 8C ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 16 00 03 24 08 00 00 10 00 00 43 AC 08 00 00 10 00 00 43 AC ?? ?? ?? ?? 00 00 00 00 00 00 42 8C 10 00 50 10 21 20 80 02 15 00 00 10 FF FF 02 24 ?? ?? 99 8F 08 00 94 8C ?? ?? ?? ?? 18 00 B3 27 10 00 BC 8F 21 20 00 02 ?? ?? 99 8F ?? ?? ?? ?? 04 00 10 24 10 00 BC 8F ?? ?? 92 8F ?? ?? 91 8F 21 20 80 02 21 28 60 02 21 C8 40 02 ?? ?? ?? ?? 21 30 00 00 E7 FF 40 04 21 C8 20 02 18 00 A2 8F 34 00 BF 8F 30 00 B4 8F 2C 00 B3 8F 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_557_0_0 {
	meta:
		name = "rand_r"
		size = 72
	strings:
		$1 = { 00 00 85 8C C6 41 03 3C 6D 4E 63 24 02 28 A3 70 39 30 A5 24 00 54 A2 7C 02 28 A3 70 80 12 02 00 39 30 A5 24 02 18 A3 70 00 4C A6 7C 26 10 46 00 80 2A 02 00 39 30 63 24 00 4C 62 7C 00 00 83 AC 08 00 E0 03 25 10 A2 00 }
	condition:
		$1
}

rule file_558_0_0 {
	meta:
		name = "callrpc"
		size = 792
		refs = "0000 _gp_disp 000c __rpc_thread_variables 0068 calloc 0094 malloc 00d8 __GI_strcmp 0100 __GI_close 0140 __GI_gethostbyname_r 0148 __GI___errno_location 01e0 __GI_memcpy 0218 __GI_clntudp_create 0244 __GI___rpc_thread_createerr 025c __GI_strncpy"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F 68 FF BD 27 90 00 BE AF 84 00 B5 AF 21 F0 A0 03 80 00 B4 AF 7C 00 B3 AF 78 00 B2 AF 74 00 B1 AF 70 00 B0 AF 20 00 BC AF 94 00 BF AF 8C 00 B7 AF 88 00 B6 AF 21 80 80 00 21 90 A0 00 21 88 C0 00 ?? ?? ?? ?? 21 98 E0 00 A4 00 55 8C 20 00 DC 8F 09 00 A0 16 21 A0 40 00 ?? ?? 99 8F 01 00 04 24 ?? ?? ?? ?? 18 00 05 24 21 A8 40 00 98 00 40 10 20 00 DC 8F A4 00 82 AE 14 00 A2 8E 0A 00 40 54 10 00 A2 8E ?? ?? 99 8F ?? ?? ?? ?? 00 01 04 24 20 00 DC 8F 14 00 A2 AE 00 00 40 A0 FF FF 02 24 04 00 A2 AE 10 00 A2 8E 0E 00 40 50 04 00 A4 8E 08 00 A2 8E 0B 00 52 54 04 00 A4 8E 0C 00 A2 8E 08 00 51 54 04 00 A4 8E ?? ?? 99 8F 14 00 A4 8E ?? ?? ?? ?? 21 28 00 02 69 00 40 10 20 00 DC 8F 04 00 A4 8E FF FF 14 24 06 00 94 10 10 00 A0 AE ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 20 00 DC 8F 04 00 B4 AE 00 00 A4 8E 08 00 80 10 5C 00 D9 27 04 00 82 8C 10 00 59 8C 09 F8 20 03 00 00 00 00 20 00 DC 8F 00 00 A0 AE 5C 00 D9 27 60 00 D9 AF ?? ?? 96 8F 4C 00 D9 27 ?? ?? 97 8F F8 FB BD 27 64 00 D9 AF 28 00 D9 27 20 00 A6 27 00 04 14 24 68 00 D9 AF 5C 00 C2 27 4C 00 D9 27 14 00 B9 AF 10 00 A2 AF 21 20 00 02 28 00 C5 27 21 C8 C0 02 ?? ?? ?? ?? 21 38 80 02 11 00 40 10 20 00 DC 8F 4C 00 C4 8F FF FF 02 24 3B 00 82 14 21 C8 E0 02 ?? ?? ?? ?? 00 00 00 00 00 00 44 8C 22 00 02 24 35 00 82 14 40 A0 14 00 0E 00 82 26 C2 10 02 00 C0 10 02 00 23 E8 A2 03 E6 FF 00 10 20 00 A6 27 5C 00 C2 8F EF FF 40 50 4C 00 C4 8F 10 00 45 8C ?? ?? 99 8F 0C 00 46 8C 00 00 A5 8C 05 00 04 24 54 00 C4 AF 58 00 C0 AF ?? ?? ?? ?? 40 00 C4 27 20 00 DC 8F 02 00 02 24 3C 00 C2 A7 04 00 A2 26 14 00 A2 AF 58 00 C2 8F ?? ?? 99 8F 54 00 C7 8F 3E 00 C0 A7 10 00 A2 AF 3C 00 C4 27 21 28 40 02 ?? ?? ?? ?? 21 30 20 02 20 00 DC 8F 06 00 40 14 00 00 A2 AE ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 24 00 00 10 00 00 42 8C 14 00 A4 8E ?? ?? 99 8F 01 00 02 24 10 00 A2 AE 08 00 B2 AE 0C 00 B1 AE 21 28 00 02 ?? ?? ?? ?? FF 00 06 24 14 00 A2 8E 03 00 00 10 FF 00 40 A0 16 00 00 10 0D 00 02 24 19 00 02 24 4C 00 C2 AF 50 00 C0 AF 00 00 A4 8E B0 00 C6 8F AC 00 C7 8F 04 00 85 8C 10 00 A6 AF B4 00 C6 8F 18 00 A2 AF 1C 00 A0 AF 14 00 A6 AF 00 00 B9 8C A8 00 C6 8F 09 F8 20 03 21 28 60 02 04 00 40 54 10 00 A0 AE 03 00 00 10 21 E8 C0 03 21 10 00 00 21 E8 C0 03 94 00 BF 8F 90 00 BE 8F 8C 00 B7 8F 88 00 B6 8F 84 00 B5 8F 80 00 B4 8F 7C 00 B3 8F 78 00 B2 8F 74 00 B1 8F 70 00 B0 8F 08 00 E0 03 98 00 BD 27 }
	condition:
		$1
}

rule file_558_1_0 {
	meta:
		name = "__rpc_thread_clnt_cleanup"
		size = 124
		refs = "0000 _gp_disp 000c __rpc_thread_variables 005c free"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F E0 FF BD 27 10 00 BC AF 18 00 B0 AF 1C 00 BF AF ?? ?? ?? ?? 00 00 00 00 A4 00 50 8C 0F 00 00 12 10 00 BC 8F 00 00 04 8E 07 00 80 10 1C 00 BF 8F 04 00 82 8C 10 00 59 8C 09 F8 20 03 00 00 00 00 10 00 BC 8F 1C 00 BF 8F 21 20 00 02 ?? ?? 99 8F 18 00 B0 8F ?? ?? ?? ?? 20 00 BD 27 1C 00 BF 8F 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_559_0_0 {
	meta:
		name = "__GI_brk"
		size = 96
		refs = "0000 _gp_disp 0028 __curbrk 003c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 21 28 80 00 21 20 A0 00 CD 0F 02 24 0C 00 00 00 ?? ?? 83 8F 2B 28 45 00 00 00 62 AC 07 00 A0 10 21 10 00 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 0C 00 03 24 00 00 43 AC FF FF 02 24 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_560_0_0 {
	meta:
		name = "__GI_strverscmp"
		size = 296
		refs = "0000 _gp_disp"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 40 00 85 10 ?? ?? 88 8F 00 00 82 90 01 00 86 24 01 00 A3 24 00 00 A4 90 30 00 47 38 D0 FF 45 24 01 00 E7 2C 0A 00 A5 2C 21 38 E5 00 ?? ?? 08 25 23 28 44 00 10 00 A0 54 30 00 82 38 0E 00 40 50 30 00 82 38 00 00 C2 90 21 38 E8 00 00 00 E5 90 30 00 49 38 D0 FF 47 24 01 00 29 2D 0A 00 E7 2C 21 38 27 01 00 00 64 90 25 38 E5 00 01 00 63 24 EF FF 00 10 01 00 C6 24 D0 FF 84 24 01 00 42 2C 0A 00 84 2C 21 20 44 00 ?? ?? 82 8F 80 38 07 00 25 38 87 00 ?? ?? 42 24 21 38 E2 00 00 00 E2 80 02 00 04 24 19 00 44 10 03 00 04 24 0B 00 44 50 00 00 C2 90 08 00 E0 03 00 00 00 00 01 00 62 24 00 00 63 90 D0 FF 63 24 0A 00 63 2C 11 00 60 10 21 30 80 00 21 18 40 00 00 00 C2 90 D0 FF 42 24 0A 00 42 2C F5 FF 40 14 01 00 C4 24 00 00 63 90 FF FF 02 24 D0 FF 63 24 0A 00 63 2C 08 00 E0 03 0A 10 A3 00 08 00 E0 03 21 10 00 00 08 00 E0 03 21 10 A0 00 08 00 E0 03 01 00 02 24 }
	condition:
		$1
}

rule file_561_0_0 {
	meta:
		name = "drand48"
		size = 64
		refs = "0000 _gp_disp 000c __libc_drand48_data 0010 __GI_erand48_r"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 84 8F ?? ?? 99 8F D8 FF BD 27 18 00 A6 27 24 00 BF AF 10 00 BC AF ?? ?? ?? ?? 21 28 80 00 24 00 BF 8F 18 00 A2 8F 1C 00 A3 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_562_0_0 {
	meta:
		name = "__GI_mkdir"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF C7 0F 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_563_0_0 {
	meta:
		name = "clnttcp_geterr"
		size = 32
	strings:
		$1 = { 08 00 82 8C 24 00 43 8C 00 00 A3 AC 28 00 43 8C 04 00 A3 AC 2C 00 42 8C 08 00 E0 03 08 00 A2 AC }
	condition:
		$1
}

rule file_563_1_0 {
	meta:
		name = "clnttcp_freeres"
		size = 28
	strings:
		$1 = { 08 00 84 8C 02 00 02 24 21 C8 A0 00 4C 00 82 AC 21 28 C0 00 08 00 20 03 4C 00 84 24 }
	condition:
		$1
}

rule file_563_3_0 {
	meta:
		name = "clnttcp_control"
		size = 300
		refs = "0000 _gp_disp 008c __GI_memcpy"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 FF FF A5 24 0F 00 A3 2C 43 00 60 10 08 00 82 8C ?? ?? 83 8F 80 28 05 00 E0 FF BD 27 ?? ?? 63 24 21 28 65 00 00 00 A3 8C 10 00 BC AF 1C 00 BF AF 21 18 7C 00 08 00 60 00 00 00 00 00 01 00 03 24 2A 00 00 10 04 00 43 AC 28 00 00 10 04 00 40 AC 00 00 C3 8C 08 00 43 AC 04 00 C3 8C 0C 00 43 AC 01 00 03 24 21 00 00 10 10 00 43 AC 08 00 43 8C 00 00 C3 AC 0C 00 42 8C 1C 00 00 10 04 00 C2 AC ?? ?? 99 8F 21 20 C0 00 14 00 45 24 ?? ?? ?? ?? 10 00 06 24 1D 00 00 10 01 00 02 24 12 00 00 10 00 00 42 8C 0E 00 00 10 30 00 42 8C 00 00 C3 8C FF FF 63 24 A0 18 03 7C 02 1C 23 00 30 00 43 AC 07 00 00 10 40 00 42 8C 00 00 C3 8C A0 18 03 7C 02 1C 23 00 05 00 00 10 40 00 43 AC 3C 00 42 8C A0 10 02 7C 02 14 22 00 00 00 C2 AC 07 00 00 10 01 00 02 24 00 00 C3 8C A0 18 03 7C 02 1C 23 00 FA FF 00 10 3C 00 43 AC 21 10 00 00 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 08 00 E0 03 21 10 00 00 }
	condition:
		$1
}

rule file_563_4_0 {
	meta:
		name = "clnttcp_destroy"
		size = 136
		refs = "0000 _gp_disp 0030 __GI_close 004c free"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D8 FF BD 27 20 00 B1 AF 10 00 BC AF 24 00 BF AF 1C 00 B0 AF 08 00 90 8C 04 00 02 8E 05 00 40 10 21 88 80 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 04 8E 10 00 BC 8F 50 00 02 8E 1C 00 59 8C 05 00 20 53 ?? ?? 99 8F 09 F8 20 03 4C 00 04 26 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 00 02 10 00 BC 8F 24 00 BF 8F 1C 00 B0 8F 21 20 20 02 ?? ?? 99 8F 20 00 B1 8F ?? ?? ?? ?? 28 00 BD 27 }
	condition:
		$1
}

rule file_563_5_0 {
	meta:
		name = "clnttcp_call"
		size = 804
		refs = "0000 _gp_disp 015c __GI_xdrrec_endofrecord 0190 _null_auth 019c __GI_xdr_void 01bc __GI_xdrrec_skiprecord 01ec __GI_xdr_replymsg 0224 __GI__seterr_reply 02a8 __GI_xdr_opaque_auth"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 88 FF BD 27 54 00 B1 AF 50 00 B0 AF 10 00 BC AF 74 00 BF AF 70 00 BE AF 6C 00 B7 AF 68 00 B6 AF 64 00 B5 AF 60 00 B4 AF 5C 00 B3 AF 58 00 B2 AF 08 00 96 8C 21 88 80 00 7C 00 A5 AF 10 00 C2 8E 80 00 A6 AF 84 00 A7 AF 05 00 40 14 4C 00 D0 26 90 00 A2 8F 08 00 C2 AE 94 00 A2 8F 0C 00 C2 AE 88 00 B9 8F 06 00 20 17 01 00 12 24 08 00 C2 8E 04 00 40 14 7C 00 B9 27 0C 00 D2 8E 2B 90 12 00 7C 00 B9 27 4C 00 B9 AF 18 00 B9 27 02 00 13 24 30 00 D7 26 48 00 B9 AF 30 00 D4 8E 50 00 C2 8E 4C 00 C0 AE FF FF 94 26 30 00 D4 AE 24 00 C0 AE 0C 00 59 8C 48 00 C6 8E 21 20 00 02 09 F8 20 03 21 28 E0 02 A0 A0 14 7C 02 A4 34 00 07 00 40 14 10 00 BC 8F 24 00 C2 8E 1B 00 40 54 21 20 00 02 01 00 02 24 17 00 00 10 24 00 C2 AE 50 00 C2 8E 21 20 00 02 04 00 59 8C 09 F8 20 03 7C 00 A5 27 F4 FF 40 10 10 00 BC 8F 00 00 24 8E 20 00 82 8C 04 00 59 8C 09 F8 20 03 21 28 00 02 ED FF 40 10 10 00 BC 8F 84 00 A5 8F 80 00 B9 8F 09 F8 20 03 21 20 00 02 07 00 40 14 10 00 BC 8F E6 FF 00 10 24 00 C2 8E 21 20 00 02 01 00 05 24 58 00 00 10 ?? ?? 99 8F ?? ?? 99 8F 21 20 00 02 ?? ?? ?? ?? 21 28 40 02 03 00 40 14 10 00 BC 8F 0A 00 00 10 03 00 02 24 5C 00 40 12 21 10 00 00 08 00 C2 8E 07 00 40 14 ?? ?? 95 8F 0C 00 C2 8E 05 00 40 14 ?? ?? 9E 8F 05 00 02 24 53 00 00 10 24 00 C2 AE ?? ?? 9E 8F 01 00 02 24 4C 00 C2 AE 00 00 A2 8E ?? ?? 99 8F 34 00 A0 AF 24 00 A2 AF 04 00 A2 8E 38 00 BE AF 21 20 00 02 28 00 A2 AF 08 00 A2 8E ?? ?? ?? ?? 2C 00 A2 AF 42 00 40 10 10 00 BC 8F ?? ?? 99 8F 21 20 00 02 ?? ?? ?? ?? 18 00 A5 27 06 00 40 14 10 00 BC 8F 24 00 C2 8E EC FF 40 50 00 00 A2 8E 39 00 00 10 74 00 BF 8F 18 00 A2 8F E7 FF 54 54 00 00 A2 8E ?? ?? 99 8F 18 00 A4 27 ?? ?? ?? ?? 24 00 C5 26 24 00 C2 8E 24 00 40 14 00 00 00 00 00 00 24 8E 24 00 B1 27 20 00 82 8C 08 00 59 8C 09 F8 20 03 21 28 20 02 06 00 40 14 10 00 BC 8F 07 00 02 24 24 00 C2 AE 06 00 02 24 0C 00 00 10 28 00 C2 AE 8C 00 A5 8F 88 00 B9 8F 09 F8 20 03 21 20 00 02 06 00 40 14 10 00 BC 8F 24 00 C2 8E 04 00 40 14 28 00 A2 8F 02 00 02 24 24 00 C2 AE 28 00 A2 8F 12 00 40 10 ?? ?? 99 8F 02 00 02 24 4C 00 C2 AE 21 20 00 02 21 28 20 02 09 F8 20 03 00 00 00 00 0B 00 00 10 24 00 C2 8E 08 00 60 12 FF FF 74 26 00 00 24 8E 20 00 82 8C 0C 00 59 8C 09 F8 20 03 00 00 00 00 6E FF 40 14 21 98 80 02 24 00 C2 8E 74 00 BF 8F 70 00 BE 8F 6C 00 B7 8F 68 00 B6 8F 64 00 B5 8F 60 00 B4 8F 5C 00 B3 8F 58 00 B2 8F 54 00 B1 8F 50 00 B0 8F 08 00 E0 03 78 00 BD 27 }
	condition:
		$1
}

rule file_563_6_0 {
	meta:
		name = "writetcp"
		size = 192
		refs = "0000 _gp_disp 0014 __GI_write 0068 __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 C8 FF BD 27 2C 00 B4 AF ?? ?? 94 8F 30 00 B5 AF 28 00 B3 AF 24 00 B2 AF 20 00 B1 AF 1C 00 B0 AF 10 00 BC AF 34 00 BF AF 21 88 80 00 21 90 A0 00 21 98 C0 00 21 80 C0 00 FF FF 15 24 13 00 00 1A 21 28 40 02 00 00 24 8E 21 C8 80 02 ?? ?? ?? ?? 21 30 00 02 0A 00 55 14 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 42 8C 28 00 22 AE 03 00 02 24 24 00 22 AE 05 00 00 10 FF FF 02 24 23 80 02 02 ED FF 00 10 21 90 42 02 21 10 60 02 34 00 BF 8F 30 00 B5 8F 2C 00 B4 8F 28 00 B3 8F 24 00 B2 8F 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_563_7_0 {
	meta:
		name = "readtcp"
		size = 368
		refs = "0000 _gp_disp 0054 __GI_poll 0058 __GI___errno_location 00a8 __GI_read"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 B8 FF BD 27 28 00 B1 AF 24 00 B0 AF 10 00 BC AF 21 80 80 00 44 00 BF AF 40 00 B7 AF 3C 00 B6 AF 38 00 B5 AF 34 00 B4 AF 30 00 B3 AF 2C 00 B2 AF 21 88 C0 00 08 00 84 8C 0C 00 03 8E 3E 00 C0 10 21 10 00 00 00 00 02 8E ?? ?? 97 8F ?? ?? 94 8F 18 00 A2 AF 01 00 02 24 1C 00 A2 A7 E8 03 02 24 1A 00 62 00 F4 01 40 00 21 98 A0 00 18 00 B6 27 00 00 82 70 12 A8 00 00 21 20 C0 02 01 00 05 24 21 C8 E0 02 ?? ?? ?? ?? 21 30 A0 02 FF FF 12 24 06 00 52 10 10 00 BC 8F 10 00 40 14 ?? ?? 99 8F 05 00 02 24 0B 00 00 10 24 00 02 AE 21 C8 80 02 ?? ?? ?? ?? 00 00 00 00 00 00 44 8C 04 00 03 24 EE FF 83 10 21 20 C0 02 24 00 03 AE 00 00 42 8C 28 00 02 AE 18 00 00 10 FF FF 02 24 00 00 04 8E 21 30 20 02 ?? ?? ?? ?? 21 28 60 02 21 88 40 00 09 00 52 10 10 00 BC 8F 0F 00 40 14 21 10 20 02 83 00 02 24 28 00 02 AE 04 00 02 24 24 00 02 AE 08 00 00 10 FF FF 11 24 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 42 8C 28 00 02 AE 04 00 02 24 24 00 02 AE 21 10 20 02 44 00 BF 8F 40 00 B7 8F 3C 00 B6 8F 38 00 B5 8F 34 00 B4 8F 30 00 B3 8F 2C 00 B2 8F 28 00 B1 8F 24 00 B0 8F 08 00 E0 03 48 00 BD 27 }
	condition:
		$1
}

rule file_563_8_0 {
	meta:
		name = "__GI_clnttcp_create"
		size = 776
		refs = "0000 _gp_disp 000c malloc 0074 __GI___rpc_thread_createerr 0088 stderr 0090 __GI_fputs 008c $LC0 00bc __GI_pmap_getport 00f8 __GI_socket 0118 __GI_bindresvport 0148 __GI___errno_location 0168 __GI_close 0170 free 0174 __GI_connect 0198 __GI_memcpy 01bc _create_xid 01d4 __GI_xdrmem_create 0204 __GI_xdr_callhdr 0270 __GI_xdrrec_create 02a8 __GI_authnone_create"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F 90 FF BD 27 18 00 BC AF 6C 00 BF AF 68 00 B5 AF 64 00 B4 AF 60 00 B3 AF 5C 00 B2 AF 58 00 B1 AF 54 00 B0 AF 21 98 80 00 0C 00 04 24 21 A8 A0 00 21 A0 C0 00 ?? ?? ?? ?? 21 90 E0 00 18 00 BC 8F 64 00 04 24 ?? ?? 99 8F ?? ?? ?? ?? 21 88 40 00 21 80 40 00 03 00 20 12 18 00 BC 8F 11 00 40 54 02 00 62 96 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 18 00 BC 8F 21 90 40 00 ?? ?? 82 8F ?? ?? 84 8F ?? ?? 99 8F 00 00 45 8C ?? ?? ?? ?? ?? ?? 84 24 0C 00 02 24 18 00 BC 8F 00 00 42 AE 85 00 00 10 08 00 42 AE 0E 00 40 54 00 00 42 8E ?? ?? 99 8F 21 20 60 02 21 28 A0 02 21 30 80 02 ?? ?? ?? ?? 06 00 07 24 7B 00 40 10 18 00 BC 8F 00 1A 02 00 00 7A 42 7C 25 10 62 00 02 00 62 A6 00 00 42 8E 28 00 43 04 04 00 00 AE ?? ?? 99 8F 02 00 04 24 02 00 05 24 ?? ?? ?? ?? 06 00 06 24 18 00 BC 8F 21 20 40 00 00 00 42 AE ?? ?? 99 8F ?? ?? ?? ?? 21 28 00 00 00 00 44 8E 12 00 81 04 18 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 18 00 BC 8F 21 98 40 00 0C 00 02 24 ?? ?? 99 8F ?? ?? ?? ?? 00 00 62 AE 00 00 42 8C 18 00 BC 8F 08 00 62 AE 00 00 44 8E 31 00 83 04 ?? ?? 99 8F 56 00 00 10 ?? ?? 99 8F ?? ?? 99 8F 21 28 60 02 ?? ?? ?? ?? 10 00 06 24 EA FF 40 04 18 00 BC 8F 01 00 02 24 04 00 02 AE 00 00 42 8E ?? ?? 99 8F 21 28 60 02 14 00 04 26 10 00 06 24 00 00 02 AE 0C 00 00 AE ?? ?? ?? ?? 10 00 00 AE 18 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 4C 00 13 26 18 00 BC 8F 20 00 A2 AF 02 00 02 24 ?? ?? 99 8F 28 00 A2 AF 21 20 60 02 30 00 05 26 18 00 06 24 21 38 00 00 24 00 A0 AF 2C 00 B5 AF ?? ?? ?? ?? 30 00 B4 AF 18 00 BC 8F 21 20 60 02 ?? ?? 99 8F ?? ?? ?? ?? 20 00 A5 27 0A 00 40 14 18 00 BC 8F 04 00 02 8E 2A 00 40 10 ?? ?? 99 8F 00 00 44 8E ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 23 00 00 10 18 00 BC 8F 50 00 02 8E 10 00 59 8C 09 F8 20 03 21 20 60 02 48 00 02 AE 50 00 02 8E 1C 00 59 8C 04 00 20 13 18 00 BC 8F 09 F8 20 03 21 20 60 02 18 00 BC 8F ?? ?? 82 8F ?? ?? 99 8F 80 00 A5 8F ?? ?? 42 24 10 00 A2 AF ?? ?? 82 8F 84 00 A6 8F 21 20 60 02 ?? ?? 42 24 14 00 A2 AF ?? ?? ?? ?? 21 38 00 02 18 00 BC 8F 08 00 30 AE ?? ?? 82 8F ?? ?? 99 8F ?? ?? 42 24 ?? ?? ?? ?? 04 00 22 AE 00 00 22 AE 09 00 00 10 21 10 20 02 ?? ?? 99 8F ?? ?? ?? ?? 21 20 00 02 18 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 20 02 21 10 00 00 6C 00 BF 8F 68 00 B5 8F 64 00 B4 8F 60 00 B3 8F 5C 00 B2 8F 58 00 B1 8F 54 00 B0 8F 08 00 E0 03 70 00 BD 27 }
	condition:
		$1
}

rule file_565_0_0 {
	meta:
		name = "__GI_iscntrl"
		size = 40
		refs = "0000 _gp_disp 000c __GI___ctype_b"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F 40 20 04 00 00 00 42 8C 21 10 44 00 00 00 42 94 08 00 E0 03 00 02 42 30 }
	condition:
		$1
}

rule file_566_0_0 {
	meta:
		name = "__GI___fgetc_unlocked"
		size = 340
		refs = "0000 _gp_disp 0040 __stdio_trans2r_o 00d0 _stdio_openlist 00d4 __GI_fflush_unlocked 00f0 __stdio_rfill 0124 __stdio_READ"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D8 FF BD 27 20 00 B0 AF 10 00 BC AF 24 00 BF AF 10 00 82 8C 18 00 83 8C 2B 18 43 00 3A 00 60 14 21 80 80 00 00 00 82 94 83 00 42 30 81 00 42 2C 0F 00 40 14 ?? ?? 99 8F 00 00 02 96 02 00 43 30 11 00 60 50 10 00 03 8E FF FF 43 24 01 00 42 30 08 00 42 24 80 10 02 00 00 00 03 A6 21 10 02 02 04 00 42 8C 28 00 00 AE 33 00 00 10 FF 00 42 30 ?? ?? ?? ?? 80 00 05 24 EF FF 40 10 10 00 BC 8F 2D 00 00 10 FF FF 02 24 14 00 04 8E 05 00 83 50 04 00 04 8E 01 00 62 24 10 00 02 AE 26 00 00 10 00 00 62 90 FE FF 03 24 04 00 83 54 00 03 42 30 04 00 42 34 1F 00 00 10 00 00 02 A6 07 00 40 50 08 00 02 8E ?? ?? 84 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F 08 00 02 8E 0C 00 03 8E 0D 00 62 10 ?? ?? 99 8F 18 00 02 AE ?? ?? ?? ?? 21 20 00 02 10 00 40 50 FF FF 02 24 14 00 02 8E 18 00 02 AE 10 00 02 8E 01 00 43 24 10 00 03 AE 09 00 00 10 00 00 42 90 ?? ?? 99 8F 21 20 00 02 18 00 A5 27 ?? ?? ?? ?? 01 00 06 24 02 00 40 14 18 00 A2 93 FF FF 02 24 24 00 BF 8F 20 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_567_0_0 {
	meta:
		name = "__GI_getpwuid_r"
		size = 276
		refs = "0000 _gp_disp 0030 __GI_fopen 0028 $LC0 002c $LC1 0074 __GI___errno_location 0088 __pgsreader 0094 __parsepwent 00d8 __GI_fclose"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 B8 FF BD 27 34 00 B4 AF 30 00 B3 AF 2C 00 B2 AF 58 00 B3 8F 21 A0 80 00 21 90 A0 00 ?? ?? 84 8F ?? ?? 85 8F ?? ?? 99 8F 18 00 BC AF 3C 00 B6 AF 38 00 B5 AF 28 00 B1 AF 44 00 BF AF 40 00 B7 AF 24 00 B0 AF ?? ?? 84 24 00 00 60 AE ?? ?? A5 24 21 A8 C0 00 ?? ?? ?? ?? 21 B0 E0 00 21 88 40 00 06 00 40 14 18 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 18 00 00 10 00 00 50 8C ?? ?? 97 8F 01 00 02 24 34 00 22 AE ?? ?? 84 8F 10 00 B1 AF 21 28 40 02 21 30 A0 02 21 C8 E0 02 ?? ?? ?? ?? 21 38 C0 02 21 80 40 00 06 00 40 14 18 00 BC 8F 08 00 42 8E F5 FF 54 14 ?? ?? 84 8F 03 00 00 10 00 00 72 AE 02 00 42 38 0A 80 02 00 ?? ?? 99 8F ?? ?? ?? ?? 21 20 20 02 44 00 BF 8F 21 10 00 02 40 00 B7 8F 3C 00 B6 8F 38 00 B5 8F 34 00 B4 8F 30 00 B3 8F 2C 00 B2 8F 28 00 B1 8F 24 00 B0 8F 08 00 E0 03 48 00 BD 27 }
	condition:
		$1
}

rule file_676_0_0 {
	meta:
		name = "__GI_getgrgid_r"
		size = 276
		refs = "0000 _gp_disp 0030 __GI_fopen 0028 $LC0 002c $LC1 0074 __GI___errno_location 0088 __pgsreader 0094 __parsegrent 00d8 __GI_fclose"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 B8 FF BD 27 34 00 B4 AF 30 00 B3 AF 2C 00 B2 AF 58 00 B3 8F 21 A0 80 00 21 90 A0 00 ?? ?? 84 8F ?? ?? 85 8F ?? ?? 99 8F 18 00 BC AF 3C 00 B6 AF 38 00 B5 AF 28 00 B1 AF 44 00 BF AF 40 00 B7 AF 24 00 B0 AF ?? ?? 84 24 00 00 60 AE ?? ?? A5 24 21 A8 C0 00 ?? ?? ?? ?? 21 B0 E0 00 21 88 40 00 06 00 40 14 18 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 18 00 00 10 00 00 50 8C ?? ?? 97 8F 01 00 02 24 34 00 22 AE ?? ?? 84 8F 10 00 B1 AF 21 28 40 02 21 30 A0 02 21 C8 E0 02 ?? ?? ?? ?? 21 38 C0 02 21 80 40 00 06 00 40 14 18 00 BC 8F 08 00 42 8E F5 FF 54 14 ?? ?? 84 8F 03 00 00 10 00 00 72 AE 02 00 42 38 0A 80 02 00 ?? ?? 99 8F ?? ?? ?? ?? 21 20 20 02 44 00 BF 8F 21 10 00 02 40 00 B7 8F 3C 00 B6 8F 38 00 B5 8F 34 00 B4 8F 30 00 B3 8F 2C 00 B2 8F 28 00 B1 8F 24 00 B0 8F 08 00 E0 03 48 00 BD 27 }
	condition:
		$1
}

rule file_568_0_0 {
	meta:
		name = "nice"
		size = 116
		refs = "0000 _gp_disp 002c __GI___errno_location 004c __GI_getpriority"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF C2 0F 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 09 00 00 10 00 00 50 AC 07 00 40 14 1C 00 BF 8F 18 00 B0 8F ?? ?? 99 8F 21 20 00 00 21 28 00 00 ?? ?? ?? ?? 20 00 BD 27 1C 00 BF 8F 18 00 B0 8F FF FF 02 24 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_569_0_0 {
	meta:
		name = "__GI_vswprintf"
		size = 192
		refs = "0000 _gp_disp 0038 _vfwprintf_internal"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 90 FF BD 27 FD FF 02 24 68 00 B0 AF 27 80 04 00 1C 00 A2 AF 82 80 10 00 50 08 02 24 18 00 A2 A7 2B 10 B0 00 0B 80 A2 00 80 10 10 00 ?? ?? 99 8F 21 10 82 00 10 00 BC AF 20 00 A4 AF 28 00 A4 AF 2C 00 A4 AF 30 00 A4 AF 34 00 A4 AF 21 28 C0 00 18 00 A4 27 6C 00 BF AF 1A 00 A0 A3 44 00 A0 AF 38 00 A0 AF 24 00 A2 AF ?? ?? ?? ?? 21 30 E0 00 28 00 A3 8F 24 00 A4 8F 06 00 64 14 00 00 00 00 08 00 00 12 FF FF 02 24 FC FF 63 24 03 00 00 10 28 00 A3 AF 04 00 00 12 6C 00 BF 8F 28 00 A3 8F 00 00 60 AC 6C 00 BF 8F 68 00 B0 8F 08 00 E0 03 70 00 BD 27 }
	condition:
		$1
}

rule file_570_0_0 {
	meta:
		name = "__GI_ttyname_r"
		size = 540
		refs = "0000 _gp_disp 000c __GI_fstat 005c __GI___errno_location 0070 __GI_isatty 00a0 __GI_strcpy 00c0 __GI_opendir 00dc __GI_lstat 00e8 __GI_readdir 00fc __GI_strlen 0170 __GI_closedir"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F 68 FE BD 27 10 00 BC AF 84 01 B5 AF 80 01 B4 AF 70 01 B0 AF 94 01 BF AF 90 01 BE AF 8C 01 B7 AF 88 01 B6 AF 7C 01 B3 AF 78 01 B2 AF 74 01 B1 AF 21 A0 A0 00 B0 00 A5 27 21 80 80 00 ?? ?? ?? ?? 21 A8 C0 00 06 00 41 04 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 60 00 00 10 00 00 42 8C ?? ?? 99 8F ?? ?? ?? ?? 21 20 00 02 03 00 40 14 10 00 BC 8F 54 00 00 10 19 00 11 24 ?? ?? 91 8F 48 01 B0 27 ?? ?? 31 26 00 00 32 82 F9 FF 40 12 ?? ?? 99 8F 01 00 33 26 21 20 00 02 ?? ?? ?? ?? 21 28 60 02 10 00 BC 8F 21 20 60 02 1E 00 17 24 ?? ?? 99 8F 21 B0 12 02 ?? ?? ?? ?? 23 B8 F2 02 21 90 40 00 3C 00 40 10 10 00 BC 8F ?? ?? 9E 8F 18 00 B9 27 68 01 B9 AF ?? ?? 99 8F ?? ?? ?? ?? 21 20 40 02 30 00 40 10 10 00 BC 8F ?? ?? 99 8F 0B 00 45 24 21 20 A0 00 ?? ?? ?? ?? 6C 01 A5 AF 2B 10 E2 02 10 00 BC 8F F3 FF 40 14 6C 01 A5 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 C0 02 21 20 00 02 21 C8 C0 03 ?? ?? ?? ?? 18 00 A5 27 EA FF 40 14 10 00 BC 8F 2C 00 A3 8F 00 20 02 24 00 F0 63 30 E6 FF 62 14 ?? ?? 99 8F 40 00 A2 8F D8 00 A3 8F E2 FF 62 14 44 00 A2 8F DC 00 A3 8F DE FF 62 14 ?? ?? 99 8F 21 20 40 02 ?? ?? ?? ?? 22 00 11 24 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 00 02 2B 10 A2 02 10 00 40 14 10 00 BC 8F ?? ?? 99 8F 21 20 80 02 ?? ?? ?? ?? 21 28 00 02 21 88 00 00 09 00 00 10 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 40 02 10 00 BC 8F 00 00 31 82 01 00 31 26 B1 FF 00 10 21 88 71 02 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 51 AC 21 10 20 02 94 01 BF 8F 90 01 BE 8F 8C 01 B7 8F 88 01 B6 8F 84 01 B5 8F 80 01 B4 8F 7C 01 B3 8F 78 01 B2 8F 74 01 B1 8F 70 01 B0 8F 08 00 E0 03 98 01 BD 27 }
	condition:
		$1
}

rule file_570_1_0 {
	meta:
		name = "ttyname"
		size = 76
		refs = "0000 _gp_disp 0018 __GI_ttyname_r"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 18 00 B0 AF ?? ?? 90 8F ?? ?? 99 8F 1C 00 BF AF 10 00 BC AF ?? ?? 05 26 ?? ?? ?? ?? 20 00 06 24 1C 00 BF 8F ?? ?? 10 26 0B 80 02 00 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_571_0_0 {
	meta:
		name = "__GI_strspn"
		size = 56
	strings:
		$1 = { 21 10 00 00 00 00 86 80 09 00 C0 10 21 18 A0 00 00 00 67 80 06 00 E0 10 00 00 00 00 FC FF C7 14 01 00 63 24 01 00 42 24 F6 FF 00 10 01 00 84 24 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_572_0_0 {
	meta:
		name = "__GI_strncasecmp"
		size = 116
		refs = "0000 _gp_disp 000c __GI___ctype_tolower"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 87 8F 16 00 C0 10 21 10 00 00 0E 00 85 50 00 00 82 80 00 00 82 90 00 00 E3 8C 40 10 02 00 21 10 62 00 00 00 48 84 00 00 A2 90 40 10 02 00 21 18 62 00 00 00 62 84 23 10 02 01 08 00 40 14 00 00 00 00 00 00 82 80 FF FF C6 24 01 00 A5 24 03 00 40 10 01 00 83 24 EA FF 00 10 21 20 60 00 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_575_0_0 {
	meta:
		name = "remap_file_pages"
		size = 100
		refs = "0000 _gp_disp 003c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 30 00 A2 8F E0 FF BD 27 10 00 A2 AF 9B 10 02 24 0C 00 00 00 20 00 BD 27 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_576_0_0 {
	meta:
		name = "memcpy"
		size = 308
	strings:
		$1 = { 08 00 C8 28 2E 00 00 15 21 10 80 00 26 40 A4 00 03 00 08 31 33 00 00 15 23 48 05 00 03 00 29 31 05 00 20 11 23 30 C9 00 00 00 A8 98 21 28 A9 00 00 00 88 B8 21 20 89 00 1F 00 C8 30 16 00 06 11 23 38 C8 00 21 38 E5 00 21 30 00 01 00 00 A8 8C 04 00 A9 8C 08 00 AA 8C 0C 00 AB 8C 10 00 AC 8C 14 00 AD 8C 18 00 AE 8C 1C 00 AF 8C 20 00 84 24 20 00 A5 24 E0 FF 88 AC E4 FF 89 AC E8 FF 8A AC EC FF 8B AC F0 FF 8C AC F4 FF 8D AC F8 FF 8E AC EE FF A7 14 FC FF 8F AC 03 00 C8 30 08 00 06 11 23 38 C8 00 21 38 E5 00 21 30 00 01 00 00 A8 8C 04 00 84 24 04 00 A5 24 FC FF A7 14 FC FF 88 AC 06 00 C0 18 21 38 C5 00 00 00 A8 80 01 00 84 24 01 00 A5 24 FC FF A7 14 FF FF 88 A0 08 00 E0 03 00 00 00 00 23 38 04 00 03 00 E7 30 06 00 E0 10 23 30 C7 00 00 00 A8 98 03 00 A8 88 21 28 A7 00 00 00 88 B8 21 20 87 00 03 00 C8 30 23 38 C8 00 21 38 E5 00 00 00 A9 98 03 00 A9 88 04 00 84 24 04 00 A5 24 FB FF A7 14 FC FF 89 AC E4 FF 00 10 21 30 00 01 }
	condition:
		$1
}

rule file_577_0_0 {
	meta:
		name = "modify_ldt"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 1B 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_578_0_0 {
	meta:
		name = "cfmakeraw"
		size = 84
	strings:
		$1 = { 00 00 83 8C 14 FA 02 24 16 00 80 A0 24 10 62 00 04 00 83 8C 00 00 82 AC FE FF 02 24 24 10 62 00 0C 00 83 8C 04 00 82 AC B4 FE 02 24 24 10 62 00 0C 00 82 AC 08 00 82 8C CF FE 03 24 24 10 62 00 30 00 42 34 08 00 82 AC 01 00 02 24 08 00 E0 03 15 00 82 A0 }
	condition:
		$1
}

rule file_580_0_0 {
	meta:
		name = "__GI_mbsinit"
		size = 28
	strings:
		$1 = { 04 00 80 10 00 00 00 00 00 00 82 8C 08 00 E0 03 01 00 42 2C 08 00 E0 03 01 00 02 24 }
	condition:
		$1
}

rule file_581_0_0 {
	meta:
		name = "__GI_inet_makeaddr"
		size = 92
	strings:
		$1 = { 80 00 A3 2C 04 00 60 10 21 10 80 00 00 2E 05 00 0D 00 00 10 00 B8 C6 7C 01 00 03 3C 2B 18 A3 00 04 00 60 10 00 01 04 3C 00 2C 05 00 06 00 00 10 FF FF C6 30 2B 20 A4 00 04 00 80 10 25 18 A6 00 00 2A 05 00 FF 00 C6 30 25 18 A6 00 A0 18 03 7C 02 1C 23 00 08 00 E0 03 00 00 43 AC }
	condition:
		$1
}

rule file_582_0_0 {
	meta:
		name = "clock_gettime"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF A7 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_583_0_0 {
	meta:
		name = "signalfd"
		size = 92
		refs = "0000 _gp_disp 0034 __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 21 38 C0 00 1C 00 BF AF 18 00 B0 AF 10 00 06 24 E4 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_584_0_0 {
	meta:
		name = "__GI_waitpid"
		size = 48
		refs = "0000 _gp_disp 000c __GI_wait4"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F E0 FF BD 27 1C 00 BF AF 10 00 BC AF ?? ?? ?? ?? 21 38 00 00 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_585_0_0 {
	meta:
		name = "__GI_execl"
		size = 192
		refs = "0000 _gp_disp 0098 __environ 009c __GI_execve"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D8 FF BD 27 20 00 BE AF 21 F0 A0 03 30 00 C6 AF 30 00 C6 27 24 00 BF AF 10 00 BC AF 34 00 C7 AF 18 00 C6 AF 21 18 00 00 18 00 C7 8F 01 00 62 24 04 00 E8 24 00 00 E7 8C 03 00 E0 10 18 00 C8 AF F9 FF 00 10 21 18 40 00 80 18 03 00 16 00 63 24 C2 18 03 00 C0 18 03 00 23 E8 A3 03 10 00 A3 27 00 00 65 AC 18 00 C6 AF 21 28 60 00 18 00 C6 8F 04 00 A5 24 FF FF 42 24 04 00 C7 24 00 00 C6 8C 18 00 C7 AF F9 FF 40 14 00 00 A6 AC ?? ?? 82 8F ?? ?? 99 8F 21 28 60 00 ?? ?? ?? ?? 00 00 46 8C 21 E8 C0 03 24 00 BF 8F 20 00 BE 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_586_0_0 {
	meta:
		name = "syscall"
		size = 104
		refs = "0000 _gp_disp 005c __syscall_error"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 21 10 80 00 21 20 A0 00 21 28 C0 00 21 30 E0 00 10 00 A7 8F 14 00 A8 8F 18 00 A9 8F 1C 00 AA 8F E0 FF BD 27 10 00 A8 AF 14 00 A9 AF 18 00 AA AF 1C 00 A2 AF 1C 00 A2 8F 0C 00 00 00 03 00 E0 14 20 00 BD 27 08 00 E0 03 00 00 00 00 21 20 40 00 ?? ?? 99 8F 08 00 20 03 00 00 00 00 }
	condition:
		$1
}

rule file_587_0_0 {
	meta:
		name = "__GI_lseek64"
		size = 132
		refs = "0000 _gp_disp 0044 __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D8 FF BD 27 10 00 BC AF 21 28 E0 00 24 00 BF AF 20 00 B0 AF 18 00 A7 27 38 00 A2 8F E0 FF BD 27 10 00 A2 AF 2C 10 02 24 0C 00 00 00 20 00 BD 27 07 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC 03 00 00 10 FF FF 10 24 04 00 40 50 18 00 A2 8F 21 10 00 02 02 00 00 10 C3 1F 10 00 1C 00 A3 8F 24 00 BF 8F 20 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_588_0_0 {
	meta:
		name = "__stdio_rfill"
		size = 84
		refs = "0000 _gp_disp 0014 __stdio_READ"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 08 00 85 8C 0C 00 86 8C ?? ?? 99 8F E0 FF BD 27 23 30 C5 00 1C 00 BF AF 18 00 B0 AF 10 00 BC AF ?? ?? ?? ?? 21 80 80 00 08 00 03 8E 1C 00 BF 8F 10 00 03 AE 21 18 62 00 14 00 03 AE 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_589_0_0 {
	meta:
		name = "__GI_wcspbrk"
		size = 60
	strings:
		$1 = { 00 00 83 8C 0B 00 60 10 00 00 00 00 21 10 A0 00 00 00 46 8C FA FF C0 50 04 00 84 24 03 00 C3 10 00 00 00 00 FA FF 00 10 04 00 42 24 08 00 E0 03 21 10 80 00 08 00 E0 03 21 10 00 00 }
	condition:
		$1
}

rule file_590_0_0 {
	meta:
		name = "__GI_getsid"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 37 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_591_0_0 {
	meta:
		name = "clock_settime"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF A6 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_592_0_0 {
	meta:
		name = "_stdlib_strto_l"
		size = 548
		refs = "0000 _gp_disp 0018 __GI___ctype_b 010c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 C0 FF BD 27 1C 00 B1 AF 21 88 C0 00 ?? ?? 86 8F 28 00 B4 AF 24 00 B3 AF 18 00 B0 AF 10 00 BC AF 3C 00 BF AF 38 00 BE AF 34 00 B7 AF 30 00 B6 AF 2C 00 B5 AF 20 00 B2 AF 21 98 A0 00 21 A0 E0 00 21 80 80 00 00 00 02 82 00 00 C5 8C 40 18 02 00 21 18 A3 00 00 00 63 94 20 00 63 30 03 00 60 10 2B 00 03 24 F7 FF 00 10 01 00 10 26 05 00 43 10 2D 00 03 24 05 00 43 54 21 90 00 00 02 00 00 10 01 00 12 24 21 90 00 00 01 00 10 26 EF FF 02 24 24 10 22 02 14 00 40 14 FE FF 22 26 00 00 03 82 30 00 02 24 03 00 62 50 01 00 05 82 0A 00 00 10 0A 00 22 26 78 00 03 24 01 00 04 26 20 00 A5 34 04 00 A3 14 08 00 22 26 02 00 10 26 02 00 00 10 40 10 02 00 21 80 80 00 10 00 11 24 11 00 43 28 0B 88 43 00 FE FF 22 26 23 00 42 2C 2B 00 40 10 21 18 00 00 FF FF 15 24 1B 00 B1 02 F4 01 20 02 ?? ?? 96 8F 22 00 1E 24 10 B8 00 00 FF 00 F7 32 12 A8 00 00 00 00 05 82 D0 FF A2 24 FF 00 42 30 0A 00 46 2C 09 00 C0 54 2A 28 51 00 20 00 A5 34 FF 00 A5 30 61 00 A6 2C 03 00 C0 14 28 00 02 24 A9 FF A2 24 FF 00 42 30 2A 28 51 00 13 00 A0 10 00 00 00 00 2B 20 A3 02 06 00 80 14 01 00 10 26 0C 00 75 14 02 20 71 70 2B 20 E2 02 09 00 80 50 02 20 71 70 21 C8 C0 02 ?? ?? ?? ?? 24 90 54 02 10 00 BC 8F FF FF 03 24 00 00 5E AC E1 FF 00 10 21 20 00 02 FD FF 00 10 21 18 82 00 01 00 60 56 00 00 64 AE 03 00 40 16 00 80 10 3C FF 7F 10 3C FF FF 10 36 0B 00 80 12 3C 00 BF 8F 2B 10 03 02 09 00 40 10 23 10 03 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 22 00 03 24 00 00 43 AC 21 18 00 02 3C 00 BF 8F 23 10 03 00 0A 10 72 00 38 00 BE 8F 34 00 B7 8F 30 00 B6 8F 2C 00 B5 8F 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 40 00 BD 27 }
	condition:
		$1
}

rule file_594_0_0 {
	meta:
		name = "__GI_tfind"
		size = 120
	strings:
		$1 = { D8 FF BD 27 20 00 B2 AF 1C 00 B1 AF 18 00 B0 AF 24 00 BF AF 21 90 80 00 21 80 A0 00 07 00 A0 14 21 88 C0 00 0E 00 00 10 21 10 00 00 00 00 42 28 04 00 70 24 08 00 63 24 0A 80 62 00 00 00 02 8E F8 FF 40 10 21 C8 20 02 00 00 45 8C 09 F8 20 03 21 20 40 02 F5 FF 40 54 00 00 03 8E 00 00 02 8E 24 00 BF 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_595_0_0 {
	meta:
		name = "sched_setparam"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 3E 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_596_0_0 {
	meta:
		name = "realloc"
		size = 1124
		refs = "0000 _gp_disp 0070 malloc 0084 _pthread_cleanup_push_defer 0088 free 009c __pthread_mutex_unlock 00a0 __malloc_lock 00b8 __pthread_mutex_lock 00d0 __GI___errno_location 0128 __malloc_state 01c4 __GI_abort 0220 __GI_memcpy 0350 __GI_mremap 03d0 _pthread_cleanup_pop_restore"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 B0 FF BD 27 10 00 BC AF 2C 00 B1 AF 28 00 B0 AF 4C 00 BF AF 48 00 BE AF 44 00 B7 AF 40 00 B6 AF 3C 00 B5 AF 38 00 B4 AF 34 00 B3 AF 30 00 B2 AF 21 80 80 00 0F 00 80 14 21 88 A0 00 4C 00 BF 8F 48 00 BE 8F 44 00 B7 8F 40 00 B6 8F 3C 00 B5 8F 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F ?? ?? 99 8F 21 20 A0 00 ?? ?? ?? ?? 50 00 BD 27 06 00 A0 14 ?? ?? 99 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 E7 00 00 10 21 10 00 00 ?? ?? 85 8F ?? ?? 86 8F 18 00 B6 27 ?? ?? ?? ?? 21 20 C0 02 10 00 BC 8F ?? ?? 84 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 E0 FF 22 2E 08 00 40 14 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 0C 00 03 24 00 00 43 AC D3 00 00 10 21 10 00 00 0B 00 31 26 10 00 22 2E 03 00 40 14 10 00 12 24 F8 FF 12 24 24 90 32 02 FC FF 04 8E FC FF 02 24 F8 FF 15 26 02 00 83 30 83 00 60 14 24 88 82 00 2B 18 32 02 66 00 60 50 23 10 32 02 ?? ?? 85 8F 21 A0 B1 02 2C 00 A6 8C 10 00 86 16 04 00 83 8E 24 10 43 00 21 10 51 00 10 00 43 26 2B 18 43 00 23 00 60 14 ?? ?? 99 8F 01 00 84 30 23 10 52 00 21 A8 B2 02 25 20 44 02 01 00 42 34 FC FF 04 AE 2C 00 B5 AC AB 00 00 10 04 00 A2 AE FE FF 04 24 24 20 64 00 21 20 84 02 04 00 84 8C 01 00 84 30 13 00 80 14 ?? ?? 99 8F 24 10 62 00 21 20 51 00 2B 10 92 00 0E 00 40 14 00 00 00 00 08 00 83 8E 0C 00 65 8C 04 00 B4 14 0C 00 82 8E 08 00 46 8C 04 00 C5 50 0C 00 62 AC ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 21 88 80 00 38 00 00 10 08 00 43 AC ?? ?? ?? ?? F9 FF 44 26 21 98 40 00 8C 00 40 10 10 00 BC 8F FC FF 43 8C F8 FF 42 24 05 00 82 16 FC FF 26 26 FC FF 02 24 24 10 62 00 2B 00 00 10 21 88 22 02 82 10 06 00 0A 00 43 2C 07 00 60 54 00 00 03 8E ?? ?? 99 8F 21 20 60 02 ?? ?? ?? ?? 21 28 00 02 1B 00 00 10 10 00 BC 8F 00 00 63 AE 04 00 03 8E 04 00 63 AE 08 00 03 8E 08 00 63 AE 05 00 43 2C 14 00 60 14 ?? ?? 99 8F 0C 00 03 8E 0C 00 63 AE 10 00 03 8E 10 00 63 AE 07 00 43 2C 0E 00 60 14 21 20 00 02 14 00 03 8E 14 00 63 AE 18 00 03 8E 18 00 63 AE 09 00 03 24 07 00 43 14 00 00 00 00 1C 00 02 8E 1C 00 62 AE 20 00 02 8E 20 00 62 AE ?? ?? 99 8F 21 20 00 02 ?? ?? ?? ?? 21 80 60 02 5B 00 00 10 10 00 BC 8F 23 10 32 02 10 00 44 2C 09 00 80 10 FC FF 03 8E 01 00 63 30 25 18 23 02 FC FF 03 AE 21 88 B1 02 04 00 22 8E 01 00 42 34 4F 00 00 10 04 00 22 AE 01 00 63 30 21 20 B2 02 25 90 43 02 01 00 43 34 FC FF 12 AE 21 10 82 00 04 00 83 AC 04 00 43 8C ?? ?? 99 8F 08 00 84 24 01 00 63 34 ?? ?? ?? ?? 04 00 43 AC 40 00 00 10 10 00 BC 8F ?? ?? 93 8F F8 FF 14 8E 5C 03 62 8E 04 00 97 26 FF FF 42 24 21 B8 E2 02 21 B8 F2 02 27 10 02 00 24 B8 E2 02 23 F0 F4 02 34 00 3E 12 ?? ?? 99 8F 23 20 B4 02 21 28 34 02 21 30 E0 02 ?? ?? ?? ?? 01 00 07 24 FF FF 03 24 15 00 43 10 10 00 BC 8F 21 80 54 00 02 00 DE 37 04 00 1E AE 64 03 62 8E 23 88 51 00 70 03 62 8E 21 88 37 02 2B 10 51 00 02 00 40 10 64 03 71 AE 70 03 71 AE 68 03 62 8E 21 88 22 02 74 03 62 8E 2B 10 51 00 1B 00 40 10 08 00 10 26 ?? ?? 82 8F 18 00 00 10 74 03 51 AC 04 00 42 26 2B 10 22 02 15 00 40 10 ?? ?? 99 8F ?? ?? 99 8F ?? ?? ?? ?? F9 FF 44 26 21 90 40 00 0D 00 40 10 10 00 BC 8F ?? ?? 99 8F 21 28 00 02 21 20 40 00 ?? ?? ?? ?? F8 FF 26 26 10 00 BC 8F 21 20 00 02 ?? ?? 99 8F ?? ?? ?? ?? 21 80 40 02 02 00 00 10 10 00 BC 8F 21 80 00 00 ?? ?? 99 8F 21 20 C0 02 ?? ?? ?? ?? 01 00 05 24 21 10 00 02 4C 00 BF 8F 48 00 BE 8F 44 00 B7 8F 40 00 B6 8F 3C 00 B5 8F 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 E0 03 50 00 BD 27 }
	condition:
		$1
}

rule file_597_0_0 {
	meta:
		name = "_svcauth_unix"
		size = 596
		refs = "0000 _gp_disp 0038 __GI_xdrmem_create 00b4 __GI_memcpy 017c __GI_printf 0178 $LC0 0198 __GI_xdr_authunix_parms"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 B0 FF BD 27 10 00 BC AF 4C 00 BF AF 40 00 B4 AF 3C 00 B3 AF 34 00 B1 AF 48 00 B6 AF 44 00 B5 AF 38 00 B2 AF 30 00 B0 AF 18 00 90 8C ?? ?? 99 8F 21 88 A0 00 18 00 02 26 04 00 02 AE 18 01 02 26 14 00 02 AE 20 00 B5 8C 1C 00 A5 8C 18 00 B3 27 21 30 A0 02 01 00 07 24 21 A0 80 00 ?? ?? ?? ?? 21 20 60 02 1C 00 A2 8F 21 20 60 02 18 00 59 8C 09 F8 20 03 21 28 A0 02 44 00 40 10 10 00 BC 8F 00 00 43 8C A0 18 03 7C 02 1C 23 00 00 00 03 AE 04 00 52 8C A0 90 12 7C 02 94 32 00 00 01 43 2E 58 00 60 50 01 00 10 24 ?? ?? 99 8F 04 00 04 8E 08 00 56 24 21 30 40 02 ?? ?? ?? ?? 21 28 C0 02 04 00 02 8E 10 00 BC 8F 21 10 52 00 00 00 40 A0 03 00 52 26 FC FF 02 24 24 30 42 02 21 28 C6 02 00 00 A2 8C A0 10 02 7C 02 14 22 00 08 00 02 AE 04 00 A2 8C A0 10 02 7C 02 14 22 00 0C 00 02 AE 08 00 A3 8C A0 18 03 7C 02 1C 23 00 11 00 62 2C 3C 00 40 50 01 00 10 24 0C 00 A5 24 10 00 03 AE 21 20 00 00 2B 10 83 00 0A 00 40 10 80 38 04 00 00 00 A2 8C 14 00 08 8E A0 10 02 7C 02 14 22 00 21 38 07 01 00 00 E2 AC 01 00 84 24 F5 FF 00 10 04 00 A5 24 05 00 62 24 80 10 02 00 21 10 46 00 2B 10 A2 02 18 00 40 50 2C 00 23 8E ?? ?? 84 8F ?? ?? 99 8F 21 28 60 00 ?? ?? 84 24 ?? ?? ?? ?? 21 38 A0 02 0E 00 00 10 00 00 00 00 ?? ?? 92 8F 21 20 60 02 21 C8 40 02 ?? ?? ?? ?? 21 28 00 02 09 00 40 54 2C 00 23 8E 02 00 02 24 18 00 A2 AF 21 20 60 02 21 C8 40 02 ?? ?? ?? ?? 21 28 00 02 10 00 00 10 01 00 10 24 0A 00 60 10 1C 00 82 8E 24 00 23 8E 20 00 43 AC 1C 00 82 8E 28 00 23 8E 24 00 43 AC 1C 00 82 8E 2C 00 23 8E 04 00 00 10 28 00 43 AC 20 00 40 AC 1C 00 82 8E 28 00 40 AC 21 80 00 00 1C 00 A2 8F 1C 00 59 8C 04 00 20 13 4C 00 BF 8F 09 F8 20 03 21 20 60 02 4C 00 BF 8F 21 10 00 02 48 00 B6 8F 44 00 B5 8F 40 00 B4 8F 3C 00 B3 8F 38 00 B2 8F 34 00 B1 8F 30 00 B0 8F 08 00 E0 03 50 00 BD 27 }
	condition:
		$1
}

rule file_598_0_0 {
	meta:
		name = "__GI_ether_aton_r"
		size = 236
	strings:
		$1 = { 21 18 00 00 05 00 08 24 3A 00 09 24 06 00 0C 24 00 00 87 90 20 00 E7 34 FF 00 E7 30 D0 FF E6 24 FF 00 C6 30 0A 00 C2 2C 07 00 40 14 02 00 82 24 9F FF E2 24 06 00 42 2C 2A 00 40 10 A9 FF E6 24 FF 00 C6 30 02 00 82 24 05 00 68 10 01 00 87 80 06 00 E9 14 20 00 EB 34 1B 00 00 10 21 20 A3 00 19 00 E0 50 21 20 A3 00 20 00 EB 34 FF 00 67 31 D0 FF EA 24 FF 00 4A 31 0A 00 4D 2D 05 00 A0 15 00 31 06 00 9F FF ED 24 06 00 AD 2D 15 00 A0 11 00 00 00 00 3A 00 6B 29 03 00 60 15 FF 00 C6 30 A9 FF E7 24 FF 00 EA 30 21 30 46 01 05 00 68 10 FF 00 C6 30 03 00 82 24 02 00 84 80 09 00 89 14 00 00 00 00 21 20 A3 00 01 00 63 24 03 00 6C 10 00 00 86 A0 CE FF 00 10 21 20 40 00 08 00 E0 03 21 10 A0 00 08 00 E0 03 21 10 00 00 }
	condition:
		$1
}

rule file_598_2_0 {
	meta:
		name = "__GI_ether_ntoa_r"
		size = 112
		refs = "0000 _gp_disp 0034 __GI_sprintf 004c $LC0"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D0 FF BD 27 2C 00 BF AF 28 00 B0 AF 20 00 BC AF 02 00 82 90 00 00 86 90 01 00 87 90 10 00 A2 AF 03 00 82 90 21 80 A0 00 ?? ?? 99 8F 14 00 A2 AF 04 00 82 90 18 00 A2 AF 05 00 82 90 21 20 A0 00 ?? ?? 85 8F 1C 00 A2 AF ?? ?? ?? ?? ?? ?? A5 24 2C 00 BF 8F 21 10 00 02 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_599_0_0 {
	meta:
		name = "__GI_inet_ntop"
		size = 428
		refs = "0000 _gp_disp 0034 __GI_memset 0130 __GI_strlen 014c __GI___errno_location 0160 __GI_strcpy"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 B8 FF BD 27 02 00 02 24 10 00 BC AF 44 00 BF AF 40 00 B3 AF 3C 00 B2 AF 38 00 B1 AF 34 00 B0 AF 52 00 82 14 ?? ?? 82 8F ?? ?? 99 8F 21 98 A0 00 ?? ?? 42 94 21 28 00 00 21 88 C0 00 18 00 A2 A7 1A 00 A4 27 0F 00 06 24 ?? ?? ?? ?? 21 90 E0 00 10 00 BC 8F 21 50 00 00 21 18 00 00 64 00 0B 24 18 00 B0 27 30 00 02 24 0A 00 08 24 2E 00 0C 24 04 00 05 24 21 30 6A 02 00 00 C9 90 21 38 03 02 01 00 64 24 1B 00 2B 01 F4 01 60 01 12 30 00 00 30 00 C6 24 20 34 06 7C 0C 00 C2 14 00 00 E6 A0 1B 00 28 01 F4 01 00 01 12 68 00 00 1B 00 A8 01 F4 01 00 01 10 30 00 00 30 00 C6 24 00 00 E6 A0 26 30 C2 00 0B 00 00 10 0B 18 86 00 1B 00 28 01 F4 01 00 01 21 20 04 02 02 00 63 24 12 38 00 00 1B 00 E8 00 F4 01 00 01 10 30 00 00 30 00 C6 24 00 00 86 A0 1B 00 28 01 F4 01 00 01 01 00 64 24 21 30 03 02 01 00 4A 25 02 00 63 24 10 38 00 00 30 00 E9 24 00 00 C9 A0 21 48 04 02 D5 FF 45 15 00 00 2C A1 ?? ?? 99 8F 00 00 20 A1 ?? ?? ?? ?? 21 20 00 02 2B 10 42 02 06 00 40 10 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 0B 00 00 10 1C 00 03 24 ?? ?? 99 8F 21 20 20 02 ?? ?? ?? ?? 21 28 00 02 08 00 00 10 44 00 BF 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 7C 00 03 24 00 00 43 AC 21 10 00 00 44 00 BF 8F 40 00 B3 8F 3C 00 B2 8F 38 00 B1 8F 34 00 B0 8F 08 00 E0 03 48 00 BD 27 }
	condition:
		$1
}

rule file_599_1_0 {
	meta:
		name = "__GI_inet_pton"
		size = 280
		refs = "0000 _gp_disp 00d8 __GI_memcpy 00f4 __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D8 FF BD 27 02 00 02 24 10 00 BC AF 24 00 BF AF 35 00 82 14 18 00 A2 27 18 00 A0 A3 21 18 00 00 21 38 00 00 21 50 40 00 2E 00 0B 24 04 00 0C 24 0A 00 0D 24 00 00 A8 80 22 00 00 11 01 00 A4 24 D0 FF 09 25 0A 00 25 2D 11 00 A0 10 00 00 00 00 00 00 48 90 02 28 0D 71 21 40 A9 00 00 01 05 2D 03 00 A0 14 00 00 00 00 25 00 00 10 21 10 00 00 11 00 E0 14 00 00 48 A0 01 00 63 24 05 00 65 28 0E 00 A0 14 01 00 07 24 1D 00 00 10 21 10 00 00 1B 00 0B 55 21 10 00 00 19 00 E0 50 21 10 00 00 17 00 6C 50 21 10 00 00 01 00 40 A0 21 38 00 00 02 00 00 10 01 00 42 24 01 00 07 24 DD FF 00 10 21 28 80 00 04 00 63 28 E7 FF 60 14 ?? ?? 99 8F 21 20 C0 00 21 28 40 01 ?? ?? ?? ?? 04 00 06 24 07 00 00 10 01 00 02 24 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 7C 00 03 24 00 00 43 AC FF FF 02 24 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_600_0_0 {
	meta:
		name = "memset"
		size = 144
	strings:
		$1 = { 08 00 C9 28 1B 00 20 15 21 10 80 00 05 00 A0 10 FF 00 A5 30 00 42 05 00 25 28 A8 00 00 44 05 00 25 28 A8 00 23 40 04 00 03 00 08 31 03 00 00 11 23 30 C8 00 00 00 85 B8 21 20 88 00 07 00 C8 30 07 00 06 11 23 38 C8 00 21 38 E4 00 21 30 00 01 08 00 84 24 F8 FF 85 AC FD FF 87 14 FC FF 85 AC 04 00 C8 30 03 00 00 11 23 30 C8 00 00 00 85 AC 04 00 84 24 04 00 C0 18 21 38 C4 00 01 00 84 24 FE FF 87 14 FF FF 85 A0 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_601_0_0 {
	meta:
		name = "__GI_fopen64"
		size = 28
		refs = "0000 _gp_disp 000c _stdio_fopen"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F 21 30 00 00 ?? ?? ?? ?? FE FF 07 24 }
	condition:
		$1
}

rule file_602_0_0 {
	meta:
		name = "__GI_strcat"
		size = 60
	strings:
		$1 = { 21 10 80 00 21 18 80 00 00 00 64 80 03 00 80 10 01 00 66 24 FC FF 00 10 21 18 C0 00 FF FF 63 24 00 00 A4 80 01 00 63 24 01 00 A5 24 FC FF 80 14 00 00 64 A0 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_603_0_0 {
	meta:
		name = "sched_setaffinity"
		size = 400
		refs = "0000 _gp_disp 0068 __GI_getpid 00cc __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 C0 FF BD 27 28 00 B4 AF ?? ?? 94 8F 38 00 BE AF 21 F0 A0 03 ?? ?? 82 8E 2C 00 B5 AF 24 00 B3 AF 20 00 B2 AF 3C 00 BF AF 34 00 B7 AF 30 00 B6 AF 1C 00 B1 AF 18 00 B0 AF 10 00 BC AF 21 A8 80 00 21 90 A0 00 22 00 40 14 21 98 C0 00 78 FF BD 27 10 00 B1 27 80 00 10 24 16 00 17 24 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 21 20 40 00 10 00 DC 8F 21 28 00 02 21 30 20 02 90 10 02 24 0C 00 00 00 0E 00 E0 10 21 B0 40 00 0C 00 57 14 40 10 10 00 0E 00 43 24 C2 18 03 00 C0 18 03 00 23 E8 A3 03 10 00 A3 27 21 20 62 00 26 20 24 02 21 80 50 00 21 88 60 00 E9 FF 00 10 0B 80 44 00 1F 00 C0 12 ?? ?? 99 8F 1D 00 E0 14 00 00 00 00 ?? ?? 96 AE ?? ?? 82 8E 2B 18 52 00 0A 00 60 10 21 18 62 02 00 00 63 80 FB FF 60 10 01 00 42 24 ?? ?? 99 8F ?? ?? ?? ?? FF FF 10 24 16 00 03 24 0D 00 00 10 00 00 43 AC 21 20 A0 02 21 28 40 02 21 30 60 02 8F 10 02 24 0C 00 00 00 0C 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 06 00 00 10 21 E8 C0 03 ?? ?? ?? ?? FF FF 10 24 FB FF 00 10 00 00 56 AC 21 E8 C0 03 3C 00 BF 8F 21 10 00 02 38 00 BE 8F 34 00 B7 8F 30 00 B6 8F 2C 00 B5 8F 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 40 00 BD 27 }
	condition:
		$1
}

rule file_604_0_0 {
	meta:
		name = "__GI___sigpause"
		size = 156
		refs = "0000 _gp_disp 002c __GI_sigprocmask 0048 __GI_sigdelset 0074 __GI_sigsuspend"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 C8 FF BD 27 10 00 BC AF 30 00 B1 AF 2C 00 B0 AF 34 00 BF AF 21 88 80 00 0F 00 A0 10 18 00 B0 27 ?? ?? 99 8F 01 00 04 24 21 28 00 00 ?? ?? ?? ?? 21 30 00 02 10 00 BC 8F 21 20 00 02 ?? ?? 99 8F ?? ?? ?? ?? 21 28 20 02 07 00 41 04 10 00 BC 8F 0A 00 00 10 FF FF 02 24 1C 00 A0 AF 20 00 A0 AF 24 00 A0 AF 18 00 A4 AF ?? ?? 99 8F ?? ?? ?? ?? 21 20 00 02 02 00 00 10 34 00 BF 8F 34 00 BF 8F 30 00 B1 8F 2C 00 B0 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_605_0_0 {
	meta:
		name = "__libc_statfs"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 03 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_606_0_0 {
	meta:
		name = "__GI_execve"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF AB 0F 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_608_0_0 {
	meta:
		name = "ctermid"
		size = 40
		refs = "0000 _gp_disp 001c __GI_strcpy 0010 $LC0"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 03 00 80 14 ?? ?? 85 8F ?? ?? 84 8F ?? ?? 84 24 ?? ?? 99 8F ?? ?? ?? ?? ?? ?? A5 24 }
	condition:
		$1
}

rule file_609_0_0 {
	meta:
		name = "__GI_wait4"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 12 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_610_0_0 {
	meta:
		name = "__GI_setgroups"
		size = 256
		refs = "0000 _gp_disp 000c __GI_sysconf 0044 __GI___errno_location 0068 malloc 00d8 free"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F D8 FF BD 27 10 00 BC AF 20 00 B2 AF 1C 00 B1 AF 24 00 BF AF 21 88 80 00 18 00 B0 AF 03 00 04 24 ?? ?? ?? ?? 21 90 A0 00 2B 10 51 00 08 00 40 10 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 16 00 03 24 00 00 43 AC 23 00 00 10 FF FF 02 24 07 00 20 12 21 80 00 00 ?? ?? 99 8F ?? ?? ?? ?? 80 20 11 00 21 80 40 00 F2 FF 40 10 10 00 BC 8F 21 10 00 00 2B 18 51 00 07 00 60 10 80 18 02 00 21 20 03 02 21 18 43 02 00 00 63 8C 01 00 42 24 F8 FF 00 10 00 00 83 AC 21 20 20 02 21 28 00 02 F1 0F 02 24 0C 00 00 00 07 00 E0 10 21 88 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F 00 00 51 AC FF FF 11 24 ?? ?? 99 8F ?? ?? ?? ?? 21 20 00 02 21 10 20 02 24 00 BF 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_611_0_0 {
	meta:
		name = "__dn_expand"
		size = 84
		refs = "0000 _gp_disp 0014 __GI___ns_name_uncompress"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D8 FF BD 27 38 00 A2 8F ?? ?? 99 8F 20 00 B0 AF 18 00 BC AF 24 00 BF AF 10 00 A2 AF ?? ?? ?? ?? 21 80 E0 00 04 00 40 18 2E 00 03 24 00 00 04 82 01 00 83 50 00 00 00 A2 24 00 BF 8F 20 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_612_0_0 {
	meta:
		name = "inotify_init"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF BC 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_612_1_0 {
	meta:
		name = "inotify_add_watch"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF BD 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_612_2_0 {
	meta:
		name = "inotify_rm_watch"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF BE 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_613_0_0 {
	meta:
		name = "load_field"
		size = 116
		refs = "0000 _gp_disp"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 83 8F 80 10 04 00 21 28 A2 00 ?? ?? 63 24 00 00 A2 8C 21 18 83 00 07 00 05 24 07 00 85 10 3A 00 63 90 05 00 05 24 06 00 85 54 2B 18 62 00 6C 07 42 24 02 00 00 10 0F 27 03 24 6D 01 03 24 2B 18 62 00 05 00 60 14 03 00 03 24 04 00 83 14 FF FF 03 24 08 00 E0 03 0A 10 62 00 FF FF 02 24 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_613_1_0 {
	meta:
		name = "__GI_strftime"
		size = 1564
		refs = "0000 _gp_disp 0014 _time_mktime 006c _time_tzset 01bc __GI_nl_langinfo 0204 _uintmaxtostr 025c $LC0 02d0 load_field"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 88 FF BD 27 6C 00 B7 AF ?? ?? 97 8F 18 00 BC AF 48 00 A6 AF 74 00 BF AF 70 00 BE AF 68 00 B6 AF 64 00 B5 AF 60 00 B4 AF 5C 00 B3 AF 58 00 B2 AF 50 00 B0 AF 7C 00 A5 AF 21 C8 E0 02 21 28 00 00 54 00 B1 AF 21 80 80 00 21 20 E0 00 ?? ?? ?? ?? 21 98 E0 00 18 00 BC 8F 98 45 04 3C 00 4F 84 24 ?? ?? 99 8F 2A 20 44 00 ?? ?? ?? ?? 21 A8 00 00 18 00 BC 8F 7C 00 B2 8F 48 00 A6 8F ?? ?? 94 8F ?? ?? 9E 8F ?? ?? 94 26 21 B0 80 02 ?? ?? DE 27 53 01 40 12 21 10 00 00 00 00 C3 80 0C 00 60 14 25 00 02 24 05 00 A0 16 FF FF B5 26 7C 00 A3 8F 00 00 00 A2 4A 01 00 10 23 10 72 00 80 10 15 00 21 10 A2 03 20 00 42 8C F1 FF 00 10 21 30 40 00 2D 01 62 14 21 88 C0 00 01 00 C2 80 2A 01 43 10 01 00 D1 24 4F 00 03 24 05 00 43 10 40 00 03 24 45 00 03 24 07 00 43 54 3F 00 03 24 80 FF 03 24 3F 00 63 34 FF 00 63 30 02 00 D1 24 02 00 00 10 03 00 07 24 02 00 07 24 00 00 28 82 20 00 02 35 9F FF 44 24 FF 00 84 30 1A 00 84 2C 06 00 80 10 21 20 14 01 BF FF 8A 90 24 18 43 01 3F 00 63 2C 06 00 60 14 30 00 4B 31 17 01 00 15 01 00 22 26 FF FF 31 26 13 01 00 10 FF FF E7 24 30 00 03 24 19 00 63 55 20 00 03 24 04 00 02 24 0D 01 A2 12 80 48 15 00 0F 00 42 31 21 48 A9 03 01 00 31 26 08 00 44 2C 01 00 B7 26 06 00 80 10 20 00 31 AD 74 00 42 24 21 10 82 02 00 00 51 90 08 00 00 10 21 10 51 00 07 00 4A 31 21 50 5E 01 00 00 44 91 ?? ?? 99 8F ?? ?? ?? ?? 00 03 84 34 18 00 BC 8F C1 FF 00 10 21 A8 E0 02 A7 00 63 55 1F 00 48 31 73 00 03 24 14 00 03 15 7A 00 03 24 ?? ?? 99 8F 21 20 60 02 ?? ?? ?? ?? 21 28 00 00 FF FF 03 24 E7 00 43 10 18 00 BC 8F ?? ?? 99 8F F6 FF 03 24 21 30 40 00 C3 3F 02 00 10 00 A3 AF 14 00 A0 AF ?? ?? ?? ?? 3B 00 A4 27 21 30 40 00 18 00 BC 8F E0 00 00 10 0C 00 07 24 20 00 43 14 21 50 00 00 20 00 62 8E D8 00 40 04 5A 00 02 24 07 00 02 55 24 00 63 8E 28 00 66 8E D6 00 C0 14 FF FF 07 24 ?? ?? 86 8F D3 00 00 10 ?? ?? C6 24 2B 00 02 24 04 00 61 04 00 00 02 A2 2D 00 02 24 23 18 03 00 00 00 02 A2 3C 00 04 24 1A 00 64 00 F4 01 80 00 64 00 06 24 01 00 10 26 FF FF 52 26 12 18 00 00 1A 00 64 00 F4 01 80 00 12 18 00 00 10 28 00 00 02 20 66 70 CC 00 00 10 21 10 85 00 ?? ?? 8D 8F 20 00 AB 27 03 00 0C 24 21 10 CA 02 49 00 44 90 ?? ?? B9 25 ?? ?? ?? ?? 21 28 60 02 80 18 0A 00 21 18 63 01 18 00 BC 8F B0 00 40 04 1C 00 62 AC 01 00 4A 25 F5 FF 4C 15 21 10 CA 02 FD FF 03 24 24 18 03 01 55 00 02 24 11 00 62 14 3C 00 AB 8F 40 00 A3 8F 57 00 04 39 23 18 6B 00 07 00 62 24 08 00 63 24 0A 10 64 00 07 00 03 24 1A 00 43 00 F4 01 60 00 57 00 04 24 12 00 03 24 80 00 04 15 12 10 00 00 01 00 6B 2D 7D 00 00 10 23 10 4B 00 07 00 05 24 64 00 06 24 90 01 07 24 40 00 A4 8F 23 68 8B 00 0B 00 AD 25 1A 00 A5 01 F4 01 A0 00 10 68 00 00 FD FF A2 25 2A 50 82 00 13 00 40 11 44 00 A3 8F FF FF 63 24 03 00 6A 30 44 00 A3 AF 0A 00 40 15 21 10 00 00 1A 00 66 00 F4 01 C0 00 10 50 00 00 05 00 40 15 01 00 02 24 1A 00 67 00 F4 01 E0 00 10 10 00 00 01 00 42 2C 6D 01 42 24 21 20 82 00 E5 FF 00 10 40 00 A4 AF 03 00 6C 30 0A 00 80 15 21 50 00 00 1A 00 66 00 F4 01 C0 00 10 60 00 00 05 00 80 15 01 00 0A 24 1A 00 67 00 F4 01 E0 00 10 50 00 00 01 00 4A 2D 6D 01 4A 25 73 01 AD 25 23 68 AA 01 1A 00 A5 01 F4 01 A0 00 10 70 00 00 21 68 CA 01 FD FF AD 25 2A 68 8D 00 06 00 A0 15 07 00 0C 24 23 20 8A 00 01 00 63 24 40 00 A4 AF C9 FF 00 10 44 00 A3 AF 23 20 82 00 1A 00 8C 00 F4 01 80 01 56 00 04 24 12 10 00 00 3A 00 04 11 01 00 42 24 67 00 02 24 62 00 02 55 21 10 60 00 64 00 02 24 1A 00 62 00 F4 01 40 00 32 00 00 10 10 10 00 00 ?? ?? 99 8F 21 40 14 01 42 00 04 91 ?? ?? 39 27 ?? ?? ?? ?? 21 28 60 02 46 00 40 04 18 00 BC 8F 58 00 05 91 0C 00 06 24 64 00 04 24 80 00 A7 30 FF 00 E7 30 0A 20 C7 00 40 00 A6 30 04 00 C0 10 21 18 A0 00 1A 00 44 00 F4 01 80 00 12 10 00 00 20 00 A6 30 08 00 C0 50 01 00 A4 30 1A 00 44 00 F4 01 80 00 21 10 80 00 10 30 00 00 21 38 E6 00 0B 10 C7 00 01 00 A4 30 08 00 A5 30 03 00 A0 10 21 10 44 00 07 00 04 24 0A 10 82 00 10 00 04 24 0E 00 64 55 40 08 67 7C 0F 00 4A 31 21 50 CA 02 6E 00 43 91 ?? ?? 99 8F 21 20 43 00 ?? ?? ?? ?? 00 03 84 34 21 30 40 00 18 00 BC 8F 1F 00 00 10 FF FF 07 24 12 00 03 24 40 08 67 7C 01 00 E7 24 30 00 A4 27 21 30 87 00 0A 00 05 24 1A 00 45 00 F4 01 A0 00 FF FF C6 24 10 40 00 00 30 00 08 25 00 00 C8 A0 2B 40 86 00 F8 FF 00 15 12 10 00 00 30 00 A4 83 30 00 02 24 0D 00 82 14 01 00 22 26 10 00 63 30 20 00 63 24 09 00 00 10 30 00 A3 A3 06 00 00 10 01 00 07 24 02 00 00 10 01 00 07 24 21 38 00 00 ?? ?? 86 8F ?? ?? C6 24 01 00 22 26 B9 FE E0 50 21 30 40 00 B7 FE 40 52 21 30 40 00 00 00 C3 80 C2 FE 60 10 FF FF E7 24 00 00 03 A2 01 00 C6 24 FF FF 52 26 F5 FF 00 10 01 00 10 26 D5 FF 00 10 16 00 03 24 74 00 BF 8F 70 00 BE 8F 6C 00 B7 8F 68 00 B6 8F 64 00 B5 8F 60 00 B4 8F 5C 00 B3 8F 58 00 B2 8F 54 00 B1 8F 50 00 B0 8F 08 00 E0 03 78 00 BD 27 }
	condition:
		$1
}

rule file_614_0_0 {
	meta:
		name = "__GI_pmap_getport"
		size = 380
		refs = "0000 _gp_disp 0060 __GI_clntudp_bufcreate 009c __GI___rpc_thread_createerr 00b4 __GI_xdr_u_short 00d8 __GI_xdr_pmap"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 A0 FF BD 27 FF FF 02 24 20 00 BC AF 38 00 A2 AF 00 6F 02 24 58 00 B5 AF 54 00 B4 AF 50 00 B3 AF 4C 00 B2 AF 44 00 B0 AF 5C 00 BF AF 48 00 B1 AF 02 00 82 A4 ?? ?? 82 8F 38 00 A3 27 14 00 A3 AF 90 01 03 24 18 00 A3 AF 1C 00 A3 AF ?? ?? 43 24 04 00 63 8C ?? ?? 99 8F 21 98 E0 00 ?? ?? 47 8C 21 A8 A0 00 01 00 05 3C 21 A0 C0 00 3C 00 A0 A7 10 00 A3 AF A0 86 A5 34 02 00 06 24 ?? ?? ?? ?? 21 90 80 00 21 80 40 00 2E 00 40 10 20 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 20 00 BC 8F 21 88 40 00 2C 00 B4 AF ?? ?? 82 8F 30 00 B3 AF 34 00 A0 AF 04 00 03 8E 10 00 A2 AF 3C 00 A2 27 14 00 A2 AF ?? ?? 82 8F 28 00 B5 AF ?? ?? 86 8F ?? ?? 44 8C ?? ?? 42 24 04 00 42 8C 18 00 A4 AF 03 00 05 24 1C 00 A2 AF 00 00 79 8C 21 20 00 02 09 F8 20 03 28 00 A7 27 0A 00 40 50 3C 00 A2 97 0E 00 02 24 00 00 22 AE 04 00 02 8E 21 20 00 02 08 00 59 8C 09 F8 20 03 04 00 25 26 06 00 00 10 04 00 02 8E 04 00 40 54 04 00 02 8E 0F 00 02 24 00 00 22 AE 04 00 02 8E 10 00 59 8C 09 F8 20 03 21 20 00 02 5C 00 BF 8F 3C 00 A2 97 58 00 B5 8F 54 00 B4 8F 50 00 B3 8F 48 00 B1 8F 44 00 B0 8F 02 00 40 A6 4C 00 B2 8F 08 00 E0 03 60 00 BD 27 }
	condition:
		$1
}

rule file_615_0_0 {
	meta:
		name = "rewinddir"
		size = 164
		refs = "0000 _gp_disp 0010 __pthread_mutex_unlock 0014 _pthread_cleanup_push_defer 0048 __pthread_mutex_lock 0060 __GI_lseek 0078 _pthread_cleanup_pop_restore"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 C8 FF BD 27 ?? ?? 85 8F ?? ?? 99 8F 30 00 B2 AF 2C 00 B1 AF 18 00 92 24 18 00 B1 27 34 00 BF AF 28 00 B0 AF 10 00 BC AF 21 80 80 00 21 30 40 02 ?? ?? ?? ?? 21 20 20 02 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 40 02 10 00 BC 8F 00 00 04 8E 21 30 00 00 ?? ?? 99 8F ?? ?? ?? ?? 21 28 00 00 10 00 BC 8F 21 20 20 02 08 00 00 AE ?? ?? 99 8F 04 00 00 AE 10 00 00 AE ?? ?? ?? ?? 01 00 05 24 34 00 BF 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_616_0_0 {
	meta:
		name = "__GI_exit"
		size = 184
		refs = "0000 _gp_disp 0010 _pthread_cleanup_push_defer 0014 __pthread_mutex_unlock 0018 __atexit_lock 0044 __pthread_mutex_lock 0054 __exit_cleanup 0060 _pthread_cleanup_pop_restore 0084 __GI___uClibc_fini 0094 _stdio_term 009c __GI__exit"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 C8 FF BD 27 ?? ?? 99 8F ?? ?? 85 8F ?? ?? 86 8F 30 00 B1 AF 18 00 B1 27 10 00 BC AF 34 00 BF AF 2C 00 B0 AF 21 80 80 00 ?? ?? ?? ?? 21 20 20 02 10 00 BC 8F ?? ?? 84 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F ?? ?? 82 8F 00 00 59 8C 05 00 20 53 ?? ?? 99 8F 09 F8 20 03 21 20 00 02 10 00 BC 8F ?? ?? 99 8F 21 20 20 02 ?? ?? ?? ?? 01 00 05 24 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F ?? ?? 99 8F 05 00 20 53 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 00 02 }
	condition:
		$1
}

rule file_617_0_0 {
	meta:
		name = "_stdlib_wcsto_l"
		size = 540
		refs = "0000 _gp_disp 0014 __GI_iswspace 010c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 B8 FF BD 27 38 00 B6 AF ?? ?? 96 8F 34 00 B5 AF 30 00 B4 AF 2C 00 B3 AF 24 00 B1 AF 20 00 B0 AF 10 00 BC AF 44 00 BF AF 40 00 BE AF 3C 00 B7 AF 28 00 B2 AF 21 98 80 00 21 A8 A0 00 21 88 C0 00 21 A0 E0 00 21 80 80 00 00 00 12 8E 21 C8 C0 02 ?? ?? ?? ?? 21 20 40 02 03 00 40 10 10 00 BC 8F F9 FF 00 10 04 00 10 26 2B 00 02 24 05 00 42 12 2D 00 02 24 05 00 42 56 21 90 00 00 02 00 00 10 01 00 12 24 21 90 00 00 04 00 10 26 EF FF 02 24 24 10 22 02 14 00 40 14 FE FF 22 26 00 00 03 8E 30 00 02 24 03 00 62 50 04 00 04 8E 0A 00 00 10 0A 00 22 26 78 00 03 24 04 00 13 26 20 00 84 34 04 00 83 14 08 00 22 26 08 00 10 26 02 00 00 10 40 10 02 00 21 80 60 02 10 00 11 24 11 00 43 28 0B 88 43 00 FE FF 22 26 23 00 42 2C 29 00 40 10 21 18 00 00 FF FF 16 24 1B 00 D1 02 F4 01 20 02 ?? ?? 99 8F 22 00 17 24 10 F0 00 00 FF 00 DE 33 12 B0 00 00 00 00 04 8E D0 FF 82 24 0A 00 46 2C 07 00 C0 54 FF 00 42 30 20 00 84 34 61 00 86 2C 03 00 C0 14 28 00 02 24 A9 FF 82 24 FF 00 42 30 2A 20 51 00 13 00 80 10 2B 20 C3 02 06 00 80 14 04 00 10 26 0D 00 76 14 02 20 71 70 2B 20 C2 03 0A 00 80 10 02 20 71 70 09 F8 20 03 18 00 B9 AF 10 00 BC 8F 00 00 57 AC 18 00 B9 8F 24 90 54 02 FF FF 03 24 E3 FF 00 10 21 98 00 02 FD FF 00 10 21 18 82 00 01 00 A0 56 00 00 B3 AE 03 00 40 16 00 80 10 3C FF 7F 10 3C FF FF 10 36 0B 00 80 12 44 00 BF 8F 2B 10 03 02 09 00 40 10 23 10 03 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 22 00 03 24 00 00 43 AC 21 18 00 02 44 00 BF 8F 23 10 03 00 0A 10 72 00 40 00 BE 8F 3C 00 B7 8F 38 00 B6 8F 34 00 B5 8F 30 00 B4 8F 2C 00 B3 8F 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 08 00 E0 03 48 00 BD 27 }
	condition:
		$1
}

rule file_618_0_0 {
	meta:
		name = "vmsplice"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF D3 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_620_0_0 {
	meta:
		name = "__syscall_error"
		size = 64
		refs = "0000 _gp_disp 000c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F E0 FF BD 27 1C 00 BF AF 18 00 B0 AF 10 00 BC AF ?? ?? ?? ?? 21 80 80 00 00 00 50 AC 1C 00 BF 8F 18 00 B0 8F FF FF 02 24 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_621_0_0 {
	meta:
		name = "sched_get_priority_min"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 44 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_622_0_0 {
	meta:
		name = "__stdio_trans2w_o"
		size = 288
		refs = "0000 _gp_disp 0038 __GI___errno_location 0098 __GI_fseek"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 18 00 B0 AF 10 00 BC AF 1C 00 BF AF 00 00 82 94 24 18 A2 00 0B 00 60 14 21 80 80 00 80 08 43 30 07 00 60 50 25 10 A2 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 09 00 03 24 1B 00 00 10 00 00 43 AC 00 00 82 A4 00 00 06 96 20 00 C2 30 F7 FF 40 14 ?? ?? 99 8F 03 00 C2 30 22 00 40 50 00 00 02 96 04 00 C2 30 18 00 40 54 00 00 02 96 14 00 03 8E 10 00 02 8E 11 00 62 10 02 00 C2 30 00 04 C6 30 01 00 03 24 02 00 02 24 ?? ?? 99 8F 0A 10 66 00 21 20 00 02 21 28 00 00 ?? ?? ?? ?? 21 30 40 00 09 00 40 50 00 00 02 96 00 00 02 96 08 00 42 34 00 00 02 A6 12 00 00 10 FF FF 02 24 F0 FF 40 54 00 04 C6 30 00 00 02 96 FC FF 42 30 00 00 02 A6 08 00 02 8E 18 00 02 AE 10 00 02 AE 14 00 02 AE 00 00 02 96 40 00 43 34 00 00 03 A6 00 0B 43 30 03 00 60 14 21 10 00 00 0C 00 03 8E 1C 00 03 AE 1C 00 BF 8F 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_623_0_0 {
	meta:
		name = "__GI_getegid"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF D2 0F 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_624_0_0 {
	meta:
		name = "__sigsetjmp"
		size = 32
		refs = "0000 _gp_disp 0014 __sigsetjmp_aux"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 21 30 A0 03 21 38 C0 03 ?? ?? 99 8F 08 00 20 03 00 00 00 00 }
	condition:
		$1
}

rule file_626_0_0 {
	meta:
		name = "getpw"
		size = 192
		refs = "0000 _gp_disp 0024 __GI___errno_location 003c __GI_getpwuid_r 0078 __GI_sprintf 0064 $LC0"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 A8 FE BD 27 28 00 BC AF 50 01 B0 AF 54 01 BF AF 07 00 A0 14 21 80 A0 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 16 00 03 24 1D 00 00 10 00 00 43 AC ?? ?? 99 8F 4C 01 A2 27 10 00 A2 AF 30 01 A5 27 30 00 A6 27 ?? ?? ?? ?? 00 01 07 24 14 00 40 14 28 00 BC 8F 38 01 A2 8F ?? ?? 85 8F 30 01 A6 8F 10 00 A2 AF 3C 01 A2 8F 34 01 A7 8F ?? ?? 99 8F 14 00 A2 AF 40 01 A2 8F 21 20 00 02 ?? ?? A5 24 18 00 A2 AF 44 01 A2 8F 1C 00 A2 AF 48 01 A2 8F ?? ?? ?? ?? 20 00 A2 AF 02 00 00 10 C3 17 02 00 FF FF 02 24 54 01 BF 8F 50 01 B0 8F 08 00 E0 03 58 01 BD 27 }
	condition:
		$1
}

rule file_627_0_0 {
	meta:
		name = "__GI_strnlen"
		size = 204
	strings:
		$1 = { 30 00 A0 10 21 10 00 00 21 28 85 00 FF FF 02 24 2B 18 A4 00 0B 28 43 00 21 10 80 00 03 00 43 30 06 00 60 10 FE FE 07 3C 00 00 43 80 23 00 60 10 2B 18 A2 00 F9 FF 00 10 01 00 42 24 80 80 08 3C 21 18 40 00 FF FE E7 34 80 80 08 35 2B 30 65 00 1A 00 C0 50 2B 18 A2 00 00 00 62 8C 21 10 47 00 24 10 48 00 11 00 40 10 04 00 66 24 00 00 62 80 11 00 40 10 21 10 60 00 01 00 62 80 03 00 40 54 02 00 62 80 0C 00 00 10 01 00 62 24 03 00 40 54 03 00 62 80 08 00 00 10 02 00 62 24 04 00 40 54 21 10 A0 00 04 00 00 10 03 00 62 24 21 10 A0 00 E6 FF 00 10 21 18 C0 00 2B 18 A2 00 0B 10 A3 00 23 10 44 00 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_628_0_0 {
	meta:
		name = "killpg"
		size = 84
		refs = "0000 _gp_disp 0020 __GI_kill 0030 __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 05 00 80 04 1C 00 BF 8F ?? ?? 99 8F 23 20 04 00 ?? ?? ?? ?? 20 00 BD 27 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 16 00 03 24 00 00 43 AC 1C 00 BF 8F FF FF 02 24 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_629_0_0 {
	meta:
		name = "__error"
		size = 364
		refs = "0000 _gp_disp 000c stdout 0030 __GI_fflush 004c error_print_progname 0058 stderr 006c __uclibc_progname 0074 __GI_fprintf 0070 $LC0 008c __GI_vfprintf 00a8 error_message_count 00c0 __GI_strerror 00dc $LC1 00fc __GI_fputc 012c __GI___fputc_unlocked 0148 __GI_exit"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F C8 FF BD 27 10 00 BC AF 30 00 B3 AF 2C 00 B2 AF 28 00 B1 AF 24 00 B0 AF 34 00 BF AF 44 00 A7 AF ?? ?? 99 8F 21 88 80 00 00 00 44 8C 21 90 A0 00 ?? ?? ?? ?? 21 98 C0 00 10 00 BC 8F ?? ?? 82 8F 00 00 59 8C 05 00 20 13 ?? ?? 90 8F 09 F8 20 03 00 00 00 00 09 00 00 10 10 00 BC 8F ?? ?? 82 8F ?? ?? 85 8F ?? ?? 99 8F 00 00 04 8E 00 00 46 8C ?? ?? ?? ?? ?? ?? A5 24 10 00 BC 8F ?? ?? 99 8F 00 00 04 8E 44 00 A6 27 18 00 A6 AF ?? ?? ?? ?? 21 28 60 02 10 00 BC 8F ?? ?? 82 8F 00 00 43 8C 01 00 63 24 0E 00 40 12 00 00 43 AC ?? ?? 82 8F ?? ?? 99 8F 21 20 40 02 ?? ?? ?? ?? 00 00 53 8C 10 00 BC 8F 21 20 60 02 21 30 40 00 ?? ?? 85 8F ?? ?? 99 8F ?? ?? ?? ?? ?? ?? A5 24 10 00 BC 8F 00 00 05 8E 34 00 A2 8C 0D 00 40 10 ?? ?? 99 8F 10 00 A2 8C 1C 00 A3 8C 2B 18 43 00 05 00 60 10 01 00 43 24 10 00 A3 AC 0A 00 03 24 08 00 00 10 00 00 43 A0 0A 00 04 24 02 00 00 10 ?? ?? 99 8F 0A 00 04 24 09 F8 20 03 00 00 00 00 10 00 BC 8F 04 00 20 12 34 00 BF 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 20 02 30 00 B3 8F 2C 00 B2 8F 28 00 B1 8F 24 00 B0 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_629_1_0 {
	meta:
		name = "__error_at_line"
		size = 488
		refs = "0000 _gp_disp 000c error_one_per_line 0068 __GI_strcmp 0084 stdout 0088 __GI_fflush 0098 error_print_progname 00a4 stderr 00b8 __uclibc_progname 00c0 __GI_fprintf 00bc $LC2 00dc $LC3 00fc __GI_vfprintf 0118 error_message_count 0130 __GI_strerror 014c $LC1 016c __GI_fputc 019c __GI___fputc_unlocked 01b8 __GI_exit"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F C0 FF BD 27 34 00 B4 AF 30 00 B3 AF 2C 00 B2 AF 24 00 B0 AF 10 00 BC AF 3C 00 BF AF 38 00 B5 AF 28 00 B1 AF 00 00 42 8C 21 98 80 00 21 A0 A0 00 21 80 C0 00 0F 00 40 10 21 90 E0 00 ?? ?? 82 8F ?? ?? 91 8F ?? ?? 43 8C 08 00 67 14 21 A8 40 00 ?? ?? 24 8E 57 00 C4 10 ?? ?? 99 8F ?? ?? ?? ?? 21 28 C0 00 53 00 40 10 10 00 BC 8F ?? ?? 30 AE ?? ?? B2 AE ?? ?? 82 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 44 8C 10 00 BC 8F ?? ?? 82 8F 00 00 59 8C 05 00 20 13 ?? ?? 91 8F 09 F8 20 03 00 00 00 00 09 00 00 10 10 00 BC 8F ?? ?? 82 8F ?? ?? 85 8F ?? ?? 99 8F 00 00 24 8E 00 00 46 8C ?? ?? ?? ?? ?? ?? A5 24 10 00 BC 8F 08 00 00 12 ?? ?? 85 8F ?? ?? 99 8F 00 00 24 8E ?? ?? A5 24 21 30 00 02 ?? ?? ?? ?? 21 38 40 02 10 00 BC 8F ?? ?? 99 8F 00 00 24 8E 50 00 A5 8F 54 00 A6 27 ?? ?? ?? ?? 18 00 A6 AF 10 00 BC 8F ?? ?? 82 8F 00 00 43 8C 01 00 63 24 0E 00 80 12 00 00 43 AC ?? ?? 82 8F ?? ?? 99 8F 21 20 80 02 ?? ?? ?? ?? 00 00 50 8C 10 00 BC 8F 21 20 00 02 21 30 40 00 ?? ?? 85 8F ?? ?? 99 8F ?? ?? ?? ?? ?? ?? A5 24 10 00 BC 8F 00 00 25 8E 34 00 A2 8C 0D 00 40 10 ?? ?? 99 8F 10 00 A2 8C 1C 00 A3 8C 2B 18 43 00 05 00 60 10 01 00 43 24 10 00 A3 AC 0A 00 03 24 08 00 00 10 00 00 43 A0 0A 00 04 24 02 00 00 10 ?? ?? 99 8F 0A 00 04 24 09 F8 20 03 00 00 00 00 10 00 BC 8F 05 00 60 12 3C 00 BF 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 60 02 3C 00 BF 8F 38 00 B5 8F 34 00 B4 8F 30 00 B3 8F 2C 00 B2 8F 28 00 B1 8F 24 00 B0 8F 08 00 E0 03 40 00 BD 27 }
	condition:
		$1
}

rule file_630_0_0 {
	meta:
		name = "__libc_fstatfs"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 04 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_631_0_0 {
	meta:
		name = "scandir64"
		size = 516
		refs = "0000 _gp_disp 000c __GI_opendir 005c __GI___errno_location 0084 __GI_readdir64 00c0 __GI_closedir 00dc free 0124 __GI_qsort 0158 realloc 0184 malloc 01a0 __GI_memcpy"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F B8 FF BD 27 10 00 BC AF 40 00 BE AF 3C 00 B7 AF 38 00 B6 AF 2C 00 B3 AF 44 00 BF AF 34 00 B5 AF 30 00 B4 AF 28 00 B2 AF 24 00 B1 AF 20 00 B0 AF 21 F0 A0 00 21 B0 C0 00 ?? ?? ?? ?? 21 B8 E0 00 21 98 40 00 3C 00 40 10 10 00 BC 8F ?? ?? 99 8F 21 80 00 00 ?? ?? ?? ?? 21 A8 00 00 00 00 59 8C 10 00 BC 8F 21 90 40 00 18 00 B9 AF 00 00 40 AC 21 88 00 00 ?? ?? 99 8F ?? ?? ?? ?? 21 20 60 02 21 A0 40 00 09 00 40 10 10 00 BC 8F 2C 00 C0 12 21 C8 C0 02 09 F8 20 03 21 20 80 02 28 00 40 14 10 00 BC 8F F3 FF 00 10 00 00 40 AE 00 00 54 8E ?? ?? 99 8F 11 00 80 12 21 20 60 02 ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F 08 00 00 12 ?? ?? 99 8F FF FF 10 26 80 10 10 00 21 10 22 02 ?? ?? ?? ?? 00 00 44 8C F8 FF 00 10 10 00 BC 8F ?? ?? ?? ?? 21 20 20 02 10 00 00 10 00 00 54 AE ?? ?? ?? ?? 00 00 00 00 18 00 B9 8F 10 00 BC 8F 07 00 E0 12 00 00 59 AE ?? ?? 99 8F 21 20 20 02 21 28 00 02 04 00 06 24 ?? ?? ?? ?? 21 38 E0 02 00 00 D1 AF 24 00 00 10 21 10 00 02 22 00 00 10 FF FF 02 24 0B 00 15 16 00 00 40 AE ?? ?? 99 8F 0A 00 02 24 40 A8 10 00 0A A8 50 00 21 20 20 02 ?? ?? ?? ?? 80 28 15 00 D1 FF 40 10 10 00 BC 8F 21 88 40 00 10 00 86 96 ?? ?? 99 8F 21 20 C0 00 ?? ?? ?? ?? 1C 00 A6 AF 10 00 BC 8F C8 FF 40 10 1C 00 A6 8F ?? ?? 99 8F 01 00 03 26 1C 00 A3 AF 21 20 40 00 21 28 80 02 ?? ?? ?? ?? 80 80 10 00 21 80 30 02 10 00 BC 8F 00 00 02 AE 1C 00 A3 8F AD FF 00 10 21 80 60 00 44 00 BF 8F 40 00 BE 8F 3C 00 B7 8F 38 00 B6 8F 34 00 B5 8F 30 00 B4 8F 2C 00 B3 8F 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 08 00 E0 03 48 00 BD 27 }
	condition:
		$1
}

rule file_633_0_0 {
	meta:
		name = "setpgrp"
		size = 28
		refs = "0000 _gp_disp 000c __GI_setpgid"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F 21 20 00 00 ?? ?? ?? ?? 21 28 00 00 }
	condition:
		$1
}

rule file_634_0_0 {
	meta:
		name = "__GI_munmap"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF FB 0F 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_635_0_0 {
	meta:
		name = "__GI_getgid"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF CF 0F 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_636_0_0 {
	meta:
		name = "rename"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF C6 0F 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_637_0_0 {
	meta:
		name = "mincore"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 79 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_638_0_0 {
	meta:
		name = "semctl"
		size = 96
		refs = "0000 _gp_disp 0014 __syscall_ipc"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D0 FF BD 27 21 18 80 00 ?? ?? 99 8F 3C 00 A4 27 21 10 A0 00 20 00 A4 AF 24 00 A4 27 2C 00 BF AF 18 00 BC AF 3C 00 A7 AF 24 00 A7 AF 10 00 A4 AF 00 01 C7 34 14 00 A0 AF 03 00 04 24 21 28 60 00 ?? ?? ?? ?? 21 30 40 00 2C 00 BF 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_640_0_0 {
	meta:
		name = "__GI_wcsnlen"
		size = 44
	strings:
		$1 = { 21 10 80 00 07 00 A0 50 23 10 44 00 00 00 43 8C 03 00 60 10 FF FF A5 24 FA FF 00 10 04 00 42 24 23 10 44 00 08 00 E0 03 83 10 02 00 }
	condition:
		$1
}

rule file_642_0_0 {
	meta:
		name = "_wstdio_fwrite"
		size = 408
		refs = "0000 _gp_disp 0074 __GI_wmemcpy 00a8 __stdio_trans2w_o 00c4 __GI_wcsnrtombs 00cc __stdio_fwrite"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 68 FF BD 27 7C 00 B3 AF 78 00 B2 AF 70 00 B0 AF 18 00 BC AF 94 00 BF AF 90 00 BE AF 8C 00 B7 AF 88 00 B6 AF 84 00 B5 AF 80 00 B4 AF 74 00 B1 AF 04 00 C3 8C FD FF 02 24 21 98 80 00 21 90 A0 00 12 00 62 14 21 80 C0 00 10 00 C4 8C 0C 00 D4 8C 23 A0 84 02 83 A0 14 00 2B 10 B4 00 0B A0 A2 00 3D 00 80 12 21 88 A0 00 ?? ?? 99 8F 21 30 80 02 ?? ?? ?? ?? 21 28 60 02 10 00 02 8E 80 A0 14 00 21 A0 54 00 34 00 00 10 10 00 14 AE 00 00 C3 94 40 08 02 24 40 08 63 30 0A 00 62 14 ?? ?? 99 8F 60 00 B9 27 60 00 B3 AF 21 88 00 00 68 00 B9 AF 2C 00 16 26 20 00 B4 27 ?? ?? 97 8F 23 00 00 10 ?? ?? 9E 8F 21 20 C0 00 ?? ?? ?? ?? 00 08 05 24 21 88 00 00 20 00 40 14 18 00 BC 8F F1 FF 00 10 60 00 B9 27 21 20 80 02 60 00 A5 27 23 30 51 02 21 C8 E0 02 ?? ?? ?? ?? 40 00 07 24 21 A8 40 00 FF FF 02 24 15 00 A2 12 94 00 BF 8F 06 00 A0 16 21 20 80 02 01 00 22 26 80 10 02 00 21 10 62 02 60 00 A2 AF 01 00 15 24 21 28 A0 02 21 C8 C0 03 ?? ?? ?? ?? 21 30 00 02 08 00 55 14 94 00 BF 8F 60 00 B1 8F 23 88 33 02 83 88 11 00 2B 10 32 02 E4 FF 40 54 10 00 B6 AF 94 00 BF 8F 21 10 20 02 90 00 BE 8F 8C 00 B7 8F 88 00 B6 8F 84 00 B5 8F 80 00 B4 8F 7C 00 B3 8F 78 00 B2 8F 74 00 B1 8F 70 00 B0 8F 08 00 E0 03 98 00 BD 27 }
	condition:
		$1
}

rule file_643_0_0 {
	meta:
		name = "__GI_memchr"
		size = 236
	strings:
		$1 = { FF 00 A2 30 08 00 C0 10 03 00 83 30 07 00 60 50 FF 00 A5 30 00 00 83 90 32 00 62 10 FF FF C6 24 F8 FF 00 10 01 00 84 24 FF 00 A5 30 00 1A 05 00 25 28 65 00 00 1C 05 00 FE 7E 07 3C 01 81 08 3C 25 28 65 00 FF FE E7 34 00 01 08 25 04 00 C3 2C 20 00 60 14 00 00 00 00 00 00 83 8C 26 18 A3 00 27 50 03 00 21 18 67 00 26 18 43 01 24 18 68 00 11 00 60 10 04 00 89 24 00 00 83 90 19 00 62 10 00 00 00 00 01 00 83 90 03 00 62 54 02 00 83 90 08 00 E0 03 01 00 82 24 03 00 62 54 03 00 83 90 08 00 E0 03 02 00 82 24 04 00 62 14 FC FF C6 24 08 00 E0 03 03 00 82 24 FC FF C6 24 E3 FF 00 10 21 20 20 01 00 00 85 90 06 00 A2 10 21 30 60 00 01 00 84 24 FB FF C0 14 FF FF C3 24 08 00 E0 03 21 10 00 00 08 00 E0 03 21 10 80 00 }
	condition:
		$1
}

rule file_644_0_0 {
	meta:
		name = "__GI_strpbrk"
		size = 60
		altNames = "any"
	strings:
		$1 = { 00 00 83 80 0B 00 60 10 00 00 00 00 21 10 A0 00 00 00 46 80 FA FF C0 50 01 00 84 24 03 00 C3 10 00 00 00 00 FA FF 00 10 01 00 42 24 08 00 E0 03 21 10 80 00 08 00 E0 03 21 10 00 00 }
	condition:
		$1
}

rule file_645_0_0 {
	meta:
		name = "wcsncpy"
		size = 48
	strings:
		$1 = { 21 10 80 00 21 18 80 00 07 00 C0 10 04 00 A7 24 00 00 A4 8C 04 00 63 24 FC FF 64 AC 0B 28 E4 00 F9 FF 00 10 FF FF C6 24 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_647_0_0 {
	meta:
		name = "__GI__exit"
		size = 84
		refs = "0000 _gp_disp 0014 __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D8 FF BD 27 18 00 B0 AF ?? ?? 90 8F 1C 00 B1 AF 10 00 BC AF 24 00 BF AF 20 00 B2 AF 21 88 80 00 21 20 20 02 A1 0F 02 24 0C 00 00 00 FC FF E0 10 21 90 40 00 21 C8 00 02 ?? ?? ?? ?? 00 00 00 00 F7 FF 00 10 00 00 52 AC }
	condition:
		$1
}

rule file_648_0_0 {
	meta:
		name = "__GI_strcasestr"
		size = 136
		refs = "0000 _gp_disp 000c __GI___ctype_tolower"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 89 8F 21 18 A0 00 21 10 80 00 00 00 67 80 16 00 E0 10 00 00 00 00 00 00 46 80 0B 00 E6 10 FF 00 E7 30 00 00 28 8D FF 00 CA 30 40 50 0A 00 40 38 07 00 21 38 07 01 21 40 0A 01 00 00 EA 84 00 00 07 85 04 00 47 15 00 00 00 00 01 00 63 24 EE FF 00 10 01 00 42 24 06 00 C0 10 01 00 84 24 21 18 A0 00 E9 FF 00 10 21 10 80 00 08 00 E0 03 21 10 80 00 08 00 E0 03 21 10 00 00 }
	condition:
		$1
}

rule file_649_0_0 {
	meta:
		name = "__get_myaddress"
		size = 468
		refs = "0000 _gp_disp 000c __GI_socket 0060 $LC0 006c __GI_ioctl 00a4 $LC1 00ac __GI_perror 00bc __GI_exit 00e0 __GI_memcpy 0110 $LC2 016c __GI_close"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F 98 EF BD 27 01 00 05 24 21 30 00 00 10 00 BC AF 50 10 B4 AF 40 10 B0 AF 64 10 BF AF 60 10 BE AF 5C 10 B7 AF 58 10 B6 AF 54 10 B5 AF 4C 10 B3 AF 48 10 B2 AF 44 10 B1 AF 21 A0 80 00 ?? ?? ?? ?? 02 00 04 24 21 80 40 00 04 00 41 04 10 00 BC 8F ?? ?? 84 8F 11 00 00 10 ?? ?? 84 24 ?? ?? 91 8F 00 10 02 24 38 10 A2 AF 18 00 A2 27 3C 10 A2 AF 21 20 00 02 12 89 05 34 21 C8 20 02 ?? ?? ?? ?? 38 10 A6 27 21 B0 20 02 10 00 BC 8F 0A 00 41 04 01 00 12 24 ?? ?? 84 8F ?? ?? 84 24 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 01 00 04 24 18 10 B5 27 02 00 1E 24 01 00 17 24 3C 10 B1 8F 38 10 B3 8F 2A 00 60 12 ?? ?? 99 8F 21 20 A0 02 21 28 20 02 ?? ?? ?? ?? 20 00 06 24 21 20 00 02 13 89 05 34 21 C8 C0 02 ?? ?? ?? ?? 21 30 A0 02 04 00 41 04 10 00 BC 8F ?? ?? 84 8F E5 FF 00 10 ?? ?? 84 24 28 10 A2 97 01 00 43 30 16 00 60 50 20 00 31 26 10 00 23 96 13 00 7E 54 20 00 31 26 08 00 42 30 04 00 40 14 ?? ?? 99 8F 0E 00 40 56 20 00 31 26 ?? ?? 99 8F 21 20 80 02 10 00 25 26 ?? ?? ?? ?? 10 00 06 24 10 00 BC 8F 00 6F 02 24 02 00 82 A6 ?? ?? 99 8F ?? ?? ?? ?? 21 20 00 02 0A 00 00 10 01 00 02 24 D6 FF 00 10 E0 FF 73 26 03 00 57 16 ?? ?? 99 8F D0 FF 00 10 21 90 00 00 ?? ?? ?? ?? 21 20 00 02 21 10 00 00 64 10 BF 8F 60 10 BE 8F 5C 10 B7 8F 58 10 B6 8F 54 10 B5 8F 50 10 B4 8F 4C 10 B3 8F 48 10 B2 8F 44 10 B1 8F 40 10 B0 8F 08 00 E0 03 68 10 BD 27 }
	condition:
		$1
}

rule file_649_1_0 {
	meta:
		name = "__GI_pmap_set"
		size = 348
		refs = "0000 _gp_disp 0050 __get_myaddress 0088 __GI_clntudp_bufcreate 00c4 __GI_xdr_bool 00cc __GI_xdr_pmap 0114 __GI_clnt_perror 0110 $LC3"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F 98 FF BD 27 FF FF 02 24 50 00 B0 AF 38 00 B0 27 20 00 BC AF 60 00 B4 AF 5C 00 B3 AF 58 00 B2 AF 54 00 B1 AF 64 00 BF AF 21 A0 80 00 4C 00 A2 AF 21 20 00 02 ?? ?? 39 27 21 98 A0 00 21 90 C0 00 ?? ?? ?? ?? FF FF F1 30 03 00 40 14 20 00 BC 8F 36 00 00 10 21 10 00 00 ?? ?? 82 8F 4C 00 A3 27 14 00 A3 AF 90 01 03 24 18 00 A3 AF 1C 00 A3 AF ?? ?? 43 24 04 00 63 8C ?? ?? 99 8F ?? ?? 47 8C 01 00 05 3C 21 20 00 02 10 00 A3 AF A0 86 A5 34 ?? ?? ?? ?? 02 00 06 24 21 80 40 00 EC FF 40 10 20 00 BC 8F 2C 00 B3 AF 30 00 B2 AF 34 00 B1 AF 04 00 43 8C ?? ?? 82 8F 28 00 B4 AF ?? ?? 86 8F 10 00 A2 AF 48 00 A2 27 14 00 A2 AF ?? ?? 82 8F 01 00 05 24 28 00 A7 27 ?? ?? 44 8C ?? ?? 42 24 04 00 42 8C 18 00 A4 AF 1C 00 A2 AF 00 00 79 8C 09 F8 20 03 21 20 00 02 07 00 40 10 20 00 BC 8F ?? ?? 85 8F ?? ?? 99 8F 21 20 00 02 ?? ?? ?? ?? ?? ?? A5 24 48 00 A0 AF 04 00 02 8E 10 00 59 8C 09 F8 20 03 21 20 00 02 48 00 A2 8F 64 00 BF 8F 60 00 B4 8F 5C 00 B3 8F 58 00 B2 8F 54 00 B1 8F 50 00 B0 8F 08 00 E0 03 68 00 BD 27 }
	condition:
		$1
}

rule file_649_2_0 {
	meta:
		name = "__GI_pmap_unset"
		size = 292
		refs = "0000 _gp_disp 0040 __get_myaddress 0078 __GI_clntudp_bufcreate 00b4 __GI_xdr_bool 00bc __GI_xdr_pmap"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F A0 FF BD 27 FF FF 02 24 50 00 B0 AF 38 00 B0 27 20 00 BC AF 58 00 B2 AF 54 00 B1 AF 5C 00 BF AF 21 90 80 00 4C 00 A2 AF 21 20 00 02 ?? ?? 39 27 ?? ?? ?? ?? 21 88 A0 00 03 00 40 14 20 00 BC 8F 2E 00 00 10 21 10 00 00 ?? ?? 82 8F 4C 00 A3 27 14 00 A3 AF 90 01 03 24 18 00 A3 AF 1C 00 A3 AF ?? ?? 43 24 04 00 63 8C ?? ?? 99 8F ?? ?? 47 8C 01 00 05 3C 21 20 00 02 10 00 A3 AF A0 86 A5 34 ?? ?? ?? ?? 02 00 06 24 21 80 40 00 EC FF 40 10 20 00 BC 8F 2C 00 B1 AF 30 00 A0 AF 34 00 A0 AF 04 00 43 8C ?? ?? 82 8F 28 00 B2 AF ?? ?? 86 8F 10 00 A2 AF 48 00 A2 27 14 00 A2 AF ?? ?? 82 8F 02 00 05 24 28 00 A7 27 ?? ?? 44 8C ?? ?? 42 24 04 00 42 8C 18 00 A4 AF 1C 00 A2 AF 00 00 79 8C 09 F8 20 03 21 20 00 02 04 00 02 8E 10 00 59 8C 09 F8 20 03 21 20 00 02 48 00 A2 8F 5C 00 BF 8F 58 00 B2 8F 54 00 B1 8F 50 00 B0 8F 08 00 E0 03 60 00 BD 27 }
	condition:
		$1
}

rule file_650_0_0 {
	meta:
		name = "__GI_wcsnrtombs"
		size = 180
		refs = "0000 _gp_disp 0060 __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D0 FF BD 27 10 00 BC AF 2C 00 BF AF 05 00 80 50 21 40 00 00 05 00 85 14 01 00 08 24 02 00 00 10 21 40 00 00 FF FF 07 24 18 00 A4 27 2B 10 C7 00 00 00 A3 8C 0B 38 C2 00 21 10 E0 00 14 00 40 10 18 00 A6 27 00 00 66 8C 80 00 C9 2C 08 00 20 15 20 34 06 7C ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 58 00 03 24 00 00 43 AC 0C 00 00 10 FF FF 02 24 05 00 C0 10 00 00 86 A0 04 00 63 24 21 20 88 00 EE FF 00 10 FF FF 42 24 21 18 00 00 18 00 A6 27 01 00 86 54 00 00 A3 AC 23 10 E2 00 2C 00 BF 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_651_0_0 {
	meta:
		name = "__GI_mempcpy"
		size = 60
		refs = "0000 _gp_disp 000c __GI_memcpy"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F E0 FF BD 27 1C 00 BF AF 18 00 B0 AF 10 00 BC AF ?? ?? ?? ?? 21 80 C0 00 1C 00 BF 8F 21 10 50 00 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_653_0_0 {
	meta:
		name = "__GI_fdopen"
		size = 128
		refs = "0000 _gp_disp 000c __GI_fcntl 0054 _stdio_fopen"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F D8 FF BD 27 10 00 BC AF 20 00 B1 AF 1C 00 B0 AF 24 00 BF AF 21 88 A0 00 03 00 05 24 ?? ?? ?? ?? 21 80 80 00 FF FF 03 24 0B 00 43 10 10 00 BC 8F 24 00 BF 8F 21 28 20 02 21 38 00 02 20 00 B1 8F 1C 00 B0 8F ?? ?? 99 8F 21 20 40 00 21 30 00 00 ?? ?? ?? ?? 28 00 BD 27 24 00 BF 8F 20 00 B1 8F 1C 00 B0 8F 21 10 00 00 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_654_0_0 {
	meta:
		name = "__GI_fgetc"
		size = 244
		refs = "0000 _gp_disp 0050 __GI___fgetc_unlocked 0064 _pthread_cleanup_push_defer 0068 __pthread_mutex_unlock 0084 __pthread_mutex_lock 00c8 _pthread_cleanup_pop_restore"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 C8 FF BD 27 28 00 B0 AF 10 00 BC AF 34 00 BF AF 30 00 B2 AF 2C 00 B1 AF 34 00 82 8C 0E 00 40 10 21 80 80 00 10 00 82 8C 18 00 83 8C 2B 18 43 00 04 00 60 10 01 00 43 24 10 00 83 AC 24 00 00 10 00 00 42 90 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 20 00 00 10 34 00 BF 8F ?? ?? 99 8F ?? ?? 85 8F 38 00 92 24 18 00 B1 27 21 20 20 02 ?? ?? ?? ?? 21 30 40 02 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 40 02 10 00 02 8E 18 00 03 8E 2B 18 43 00 05 00 60 10 10 00 BC 8F 01 00 43 24 10 00 03 AE 06 00 00 10 00 00 50 90 ?? ?? 99 8F ?? ?? ?? ?? 21 20 00 02 10 00 BC 8F 21 80 40 00 ?? ?? 99 8F 21 20 20 02 ?? ?? ?? ?? 01 00 05 24 21 10 00 02 34 00 BF 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_655_0_0 {
	meta:
		name = "__stdio_seek"
		size = 100
		refs = "0000 _gp_disp 0028 __GI_lseek64"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D8 FF BD 27 00 00 A2 8C 04 00 A3 8C 20 00 B0 AF 18 00 BC AF 24 00 BF AF 04 00 84 8C ?? ?? 99 8F 10 00 A6 AF 21 38 60 00 21 30 40 00 ?? ?? ?? ?? 21 80 A0 00 05 00 60 04 24 00 BF 8F 00 00 02 AE 04 00 03 AE 21 10 00 00 24 00 BF 8F 20 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_656_0_0 {
	meta:
		name = "fgetpos64"
		size = 220
		refs = "0000 _gp_disp 0038 _pthread_cleanup_push_defer 003c __pthread_mutex_unlock 0054 __pthread_mutex_lock 0064 __GI_ftello64 00ac _pthread_cleanup_pop_restore"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 C0 FF BD 27 30 00 B1 AF 2C 00 B0 AF 10 00 BC AF 3C 00 BF AF 38 00 B3 AF 34 00 B2 AF 34 00 92 8C 21 80 80 00 0C 00 40 16 21 88 A0 00 ?? ?? 99 8F ?? ?? 85 8F 38 00 93 24 21 30 60 02 ?? ?? ?? ?? 18 00 A4 27 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 60 02 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 00 02 00 00 22 AE 10 00 BC 8F 09 00 60 04 04 00 23 AE 2C 00 02 8E 08 00 22 AE 30 00 02 8E 0C 00 22 AE 02 00 02 92 21 80 00 00 02 00 00 10 10 00 22 AE FF FF 10 24 06 00 40 16 3C 00 BF 8F ?? ?? 99 8F 18 00 A4 27 ?? ?? ?? ?? 01 00 05 24 3C 00 BF 8F 21 10 00 02 38 00 B3 8F 34 00 B2 8F 30 00 B1 8F 2C 00 B0 8F 08 00 E0 03 40 00 BD 27 }
	condition:
		$1
}

rule file_658_0_0 {
	meta:
		name = "__wcslcpy"
		size = 76
	strings:
		$1 = { F0 FF BD 27 03 00 C0 50 21 30 00 00 02 00 00 10 FF FF C6 24 08 00 A4 27 21 10 A0 00 00 00 43 8C 06 00 60 10 00 00 83 AC FC FF C0 10 04 00 42 24 FF FF C6 24 F9 FF 00 10 04 00 84 24 23 10 45 00 83 10 02 00 08 00 E0 03 10 00 BD 27 }
	condition:
		$1
}

rule file_659_0_0 {
	meta:
		name = "__GI___assert"
		size = 140
		refs = "0000 _gp_disp 0024 __GI_abort 0030 stderr 003c __uclibc_progname 004c $LC0 0060 __GI_fprintf 005c $LC1"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 83 8F D0 FF BD 27 20 00 BC AF ?? ?? 62 8C 2C 00 BF AF 18 00 40 14 ?? ?? 99 8F 01 00 02 24 ?? ?? 62 AC ?? ?? 82 8F 21 40 A0 00 00 00 45 8C ?? ?? 82 8F 00 00 43 8C 03 00 E0 14 21 10 E0 00 ?? ?? 82 8F ?? ?? 42 24 18 00 A4 AF 21 20 A0 00 ?? ?? 85 8F ?? ?? 99 8F 10 00 A6 AF 14 00 A2 AF ?? ?? A5 24 21 30 60 00 ?? ?? ?? ?? 21 38 00 01 20 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_660_0_0 {
	meta:
		name = "__libc_current_sigrtmin"
		size = 24
		refs = "0000 _gp_disp"
		altNames = "_ZNSt5ctypeIcE13classic_tableEv __libc_current_sigrtmax __pthread_getconcurrency"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F 08 00 E0 03 ?? ?? 42 8C }
	condition:
		$1
}

rule file_660_2_0 {
	meta:
		name = "__libc_allocate_rtsig"
		size = 88
		refs = "0000 _gp_disp"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 86 8F FF FF 03 24 ?? ?? C2 8C 0D 00 43 10 ?? ?? 85 8F ?? ?? A3 8C 2A 38 62 00 09 00 E0 14 00 00 00 00 04 00 80 50 FF FF 62 24 01 00 43 24 08 00 E0 03 ?? ?? C3 AC ?? ?? A2 AC 08 00 E0 03 21 10 60 00 08 00 E0 03 FF FF 02 24 }
	condition:
		$1
}

rule file_661_0_0 {
	meta:
		name = "tmpnam"
		size = 164
		refs = "0000 _gp_disp 0010 ___path_search 0054 __gen_tempname 0078 __GI_memcpy"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 C0 FF BD 27 ?? ?? 99 8F 34 00 B0 AF 18 00 B0 27 0B 80 84 00 10 00 BC AF 38 00 B1 AF 3C 00 BF AF 21 88 80 00 14 00 05 24 21 20 00 02 21 30 00 00 ?? ?? ?? ?? 21 38 00 00 03 00 40 10 10 00 BC 8F 10 00 00 10 21 10 00 00 ?? ?? 99 8F 21 20 00 02 ?? ?? ?? ?? 03 00 05 24 F9 FF 40 14 10 00 BC 8F 08 00 20 16 21 10 20 02 ?? ?? 83 8F ?? ?? 99 8F 21 28 00 02 ?? ?? 63 24 21 20 60 00 ?? ?? ?? ?? 14 00 06 24 3C 00 BF 8F 38 00 B1 8F 34 00 B0 8F 08 00 E0 03 40 00 BD 27 }
	condition:
		$1
}

rule file_662_0_0 {
	meta:
		name = "tdelete"
		size = 292
		refs = "0000 _gp_disp 009c free"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D0 FF BD 27 10 00 BC AF 1C 00 B0 AF 2C 00 BF AF 28 00 B3 AF 24 00 B2 AF 20 00 B1 AF 03 00 A0 14 21 80 A0 00 35 00 00 10 21 10 00 00 00 00 B2 8C 21 98 80 00 FB FF 40 12 21 88 C0 00 00 00 02 8E 21 20 60 02 21 C8 20 02 09 F8 20 03 00 00 45 8C 0B 00 40 10 10 00 BC 8F 00 00 12 8E 00 00 42 28 04 00 50 26 08 00 43 26 0A 80 62 00 00 00 02 8E F4 FF 40 54 21 20 60 02 20 00 00 10 21 10 00 00 00 00 02 8E 08 00 51 8C 04 00 42 8C 17 00 40 10 ?? ?? 99 8F 14 00 20 52 21 88 40 00 04 00 23 8E 04 00 60 54 04 00 62 8C 10 00 00 10 04 00 22 AE 04 00 62 8C 04 00 40 50 08 00 62 8C 21 88 60 00 FB FF 00 10 21 18 40 00 04 00 22 AE 00 00 02 8E 21 88 60 00 04 00 42 8C 04 00 62 AC 00 00 02 8E 08 00 42 8C 08 00 62 AC ?? ?? 99 8F ?? ?? ?? ?? 00 00 04 8E 00 00 11 AE 21 10 40 02 2C 00 BF 8F 28 00 B3 8F 24 00 B2 8F 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_663_0_0 {
	meta:
		name = "__GI_fflush"
		size = 200
		refs = "0000 _gp_disp 0030 __GI_fflush_unlocked 0034 _stdio_openlist 0048 __pthread_mutex_unlock 004c _pthread_cleanup_push_defer 0064 __pthread_mutex_lock 0084 _pthread_cleanup_pop_restore"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 B8 FF BD 27 10 00 BC AF 3C 00 B2 AF 34 00 B0 AF 44 00 BF AF 40 00 B3 AF 38 00 B1 AF 21 80 80 00 1C 00 80 10 ?? ?? 92 8F ?? ?? 82 8F 1A 00 82 10 21 C8 40 02 34 00 91 8C 0B 00 20 16 ?? ?? 85 8F ?? ?? 99 8F 38 00 93 24 21 30 60 02 ?? ?? ?? ?? 18 00 A4 27 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 60 02 21 C8 40 02 ?? ?? ?? ?? 21 20 00 02 0B 00 20 16 10 00 BC 8F ?? ?? 99 8F 28 00 A2 AF 18 00 A4 27 ?? ?? ?? ?? 01 00 05 24 04 00 00 10 28 00 A2 8F 21 C8 40 02 ?? ?? ?? ?? 21 20 00 02 44 00 BF 8F 40 00 B3 8F 3C 00 B2 8F 38 00 B1 8F 34 00 B0 8F 08 00 E0 03 48 00 BD 27 }
	condition:
		$1
}

rule file_664_0_0 {
	meta:
		name = "__GI_accept"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 48 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_665_0_0 {
	meta:
		name = "mount"
		size = 100
		refs = "0000 _gp_disp 003c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 30 00 A2 8F E0 FF BD 27 10 00 A2 AF B5 0F 02 24 0C 00 00 00 20 00 BD 27 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_666_0_0 {
	meta:
		name = "getsubopt"
		size = 348
		refs = "0000 _gp_disp 004c __GI_strchrnul 0070 __GI_memchr 008c __GI_strncmp"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 B8 FF BD 27 2C 00 B3 AF 10 00 BC AF 44 00 BF AF 40 00 BE AF 3C 00 B7 AF 38 00 B6 AF 34 00 B5 AF 30 00 B4 AF 28 00 B2 AF 24 00 B1 AF 20 00 B0 AF 00 00 91 8C 00 00 22 82 38 00 40 10 21 98 80 00 ?? ?? 99 8F 21 20 20 02 21 F0 A0 00 2C 00 05 24 ?? ?? ?? ?? 21 B0 C0 00 10 00 BC 8F 21 20 20 02 3D 00 05 24 ?? ?? 99 8F 23 30 51 00 ?? ?? ?? ?? 21 80 40 00 10 00 BC 8F 21 A8 00 02 0B A8 42 00 ?? ?? 99 8F 21 90 00 00 23 B8 B1 02 80 10 12 00 21 10 C2 03 00 00 54 8C 19 00 80 12 21 20 20 02 18 00 B9 AF 21 28 80 02 09 F8 20 03 21 30 E0 02 11 00 40 14 18 00 B9 8F 21 A0 97 02 00 00 82 82 F2 FF 40 54 01 00 52 26 01 00 A2 26 26 A8 B0 02 0A 10 15 00 00 00 C2 AE 00 00 02 82 04 00 40 50 00 00 70 AE 00 00 00 A2 01 00 10 26 00 00 70 AE 0B 00 00 10 21 10 40 02 E4 FF 00 10 01 00 52 26 00 00 D1 AE 00 00 02 82 04 00 40 50 00 00 70 AE 00 00 00 A2 01 00 10 26 00 00 70 AE FF FF 02 24 44 00 BF 8F 40 00 BE 8F 3C 00 B7 8F 38 00 B6 8F 34 00 B5 8F 30 00 B4 8F 2C 00 B3 8F 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 08 00 E0 03 48 00 BD 27 }
	condition:
		$1
}

rule file_667_1_0 {
	meta:
		name = "__GI__authenticate"
		size = 108
		refs = "0000 _gp_disp 0020 _null_auth"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 18 00 A6 8C 0C 00 86 AC 1C 00 A6 8C 10 00 86 AC 20 00 A3 8C ?? ?? 86 8F 14 00 83 AC 00 00 C6 8C 1C 00 83 8C 20 00 66 AC 1C 00 83 8C 28 00 60 AC 0C 00 82 8C 04 00 43 2C 07 00 60 10 ?? ?? 83 8F 80 10 02 00 ?? ?? 63 24 21 10 43 00 00 00 59 8C 08 00 20 03 00 00 00 00 08 00 E0 03 02 00 02 24 }
	condition:
		$1
}

rule file_669_0_0 {
	meta:
		name = "munlockall"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 3D 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_670_0_0 {
	meta:
		name = "__GI_write"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF A4 0F 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_671_0_0 {
	meta:
		name = "__GI_getuid"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF B8 0F 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_673_0_0 {
	meta:
		name = "__GI_xdr_rejected_reply"
		size = 188
		refs = "0000 _gp_disp 0014 __GI_xdr_enum 0060 __GI_xdr_u_long"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D8 FF BD 27 20 00 B2 AF ?? ?? 92 8F 10 00 BC AF 1C 00 B1 AF 18 00 B0 AF 24 00 BF AF 21 C8 40 02 21 88 80 00 ?? ?? ?? ?? 21 80 A0 00 19 00 40 10 10 00 BC 8F 00 00 02 8E 06 00 40 10 01 00 03 24 15 00 43 14 24 00 BF 8F 21 20 20 02 0B 00 00 10 04 00 05 26 ?? ?? 92 8F 21 20 20 02 21 C8 40 02 ?? ?? ?? ?? 04 00 05 26 0A 00 40 10 10 00 BC 8F 21 20 20 02 08 00 05 26 24 00 BF 8F 1C 00 B1 8F 18 00 B0 8F 21 C8 40 02 20 00 B2 8F 08 00 20 03 28 00 BD 27 24 00 BF 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 21 10 00 00 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_673_1_0 {
	meta:
		name = "__GI_xdr_opaque_auth"
		size = 116
		refs = "0000 _gp_disp 000c __GI_xdr_enum 004c __GI_xdr_bytes"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F D8 FF BD 27 10 00 BC AF 20 00 B1 AF 1C 00 B0 AF 24 00 BF AF 21 88 80 00 ?? ?? ?? ?? 21 80 A0 00 0B 00 40 10 10 00 BC 8F 24 00 BF 8F 21 20 20 02 04 00 05 26 20 00 B1 8F 08 00 06 26 ?? ?? 99 8F 1C 00 B0 8F 90 01 07 24 ?? ?? ?? ?? 28 00 BD 27 24 00 BF 8F 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_673_2_0 {
	meta:
		name = "__GI_xdr_accepted_reply"
		size = 248
		refs = "0000 _gp_disp 000c __GI_xdr_opaque_auth 0044 __GI_xdr_enum 006c __GI_xdr_u_long"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F D8 FF BD 27 10 00 BC AF 1C 00 B1 AF 18 00 B0 AF 24 00 BF AF 20 00 B2 AF 21 88 80 00 ?? ?? ?? ?? 21 80 A0 00 03 00 40 14 10 00 BC 8F 27 00 00 10 21 18 00 00 ?? ?? 99 8F 21 20 20 02 ?? ?? ?? ?? 0C 00 05 26 F9 FF 40 10 10 00 BC 8F 0C 00 02 8E 05 00 40 10 02 00 03 24 0C 00 43 10 ?? ?? 92 8F 1A 00 00 10 01 00 03 24 24 00 BF 8F 20 00 B2 8F 14 00 19 8E 21 20 20 02 10 00 05 8E 1C 00 B1 8F 18 00 B0 8F 08 00 20 03 28 00 BD 27 21 20 20 02 21 C8 40 02 ?? ?? ?? ?? 10 00 05 26 10 00 BC 8F 0A 00 40 10 21 18 00 00 24 00 BF 8F 21 20 20 02 14 00 05 26 1C 00 B1 8F 18 00 B0 8F 21 C8 40 02 20 00 B2 8F ?? ?? ?? ?? 28 00 BD 27 24 00 BF 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 21 10 60 00 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_673_4_0 {
	meta:
		name = "__GI_xdr_replymsg"
		size = 156
		refs = "0000 _gp_disp 000c __GI_xdr_u_long 0040 __GI_xdr_enum 006c __GI_xdr_union"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F D0 FF BD 27 18 00 BC AF 28 00 B1 AF 24 00 B0 AF 2C 00 BF AF 21 88 80 00 ?? ?? ?? ?? 21 80 A0 00 03 00 40 14 18 00 BC 8F 13 00 00 10 21 10 00 00 ?? ?? 99 8F 21 20 20 02 ?? ?? ?? ?? 04 00 05 26 F9 FF 40 10 18 00 BC 8F 04 00 03 8E 01 00 02 24 09 00 62 14 21 10 00 00 ?? ?? 87 8F ?? ?? 99 8F 10 00 A0 AF 21 20 20 02 08 00 05 26 0C 00 06 26 ?? ?? ?? ?? ?? ?? E7 24 2C 00 BF 8F 28 00 B1 8F 24 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_673_5_0 {
	meta:
		name = "__GI_xdr_callhdr"
		size = 224
		refs = "0000 _gp_disp 0040 __GI_xdr_u_long 0058 __GI_xdr_enum"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D8 FF BD 27 02 00 02 24 10 00 BC AF 1C 00 B1 AF 18 00 B0 AF 24 00 BF AF 20 00 B2 AF 04 00 A0 AC 08 00 A2 AC 00 00 82 8C 21 88 80 00 22 00 40 14 21 80 A0 00 ?? ?? 92 8F 21 C8 40 02 ?? ?? ?? ?? 00 00 00 00 1C 00 40 10 10 00 BC 8F ?? ?? 99 8F 21 20 20 02 ?? ?? ?? ?? 04 00 05 26 17 00 40 10 24 00 BF 8F 21 20 20 02 21 C8 40 02 ?? ?? ?? ?? 08 00 05 26 11 00 40 10 24 00 BF 8F 21 20 20 02 21 C8 40 02 ?? ?? ?? ?? 0C 00 05 26 0A 00 40 10 10 00 BC 8F 24 00 BF 8F 21 20 20 02 10 00 05 26 1C 00 B1 8F 18 00 B0 8F 21 C8 40 02 20 00 B2 8F ?? ?? ?? ?? 28 00 BD 27 24 00 BF 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 21 10 00 00 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_673_6_0 {
	meta:
		name = "__GI__seterr_reply"
		size = 304
		refs = "0000 _gp_disp"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 08 00 83 8C 05 00 60 10 01 00 02 24 21 00 62 50 0C 00 82 8C 2B 00 00 10 10 00 02 24 18 00 82 8C 03 00 40 14 FF FF 43 24 08 00 E0 03 00 00 A0 AC 05 00 66 2C 13 00 C0 10 80 18 03 00 ?? ?? 82 8F ?? ?? 42 24 21 18 43 00 00 00 62 8C 21 10 5C 00 08 00 40 00 00 00 00 00 08 00 00 10 08 00 02 24 06 00 00 10 09 00 02 24 04 00 00 10 0A 00 02 24 02 00 00 10 0B 00 02 24 0C 00 02 24 14 00 00 10 00 00 A2 AC 10 00 03 24 00 00 A3 AC 0B 00 00 10 04 00 A0 AC 07 00 43 10 06 00 06 24 0C 00 46 50 00 00 A2 AC 10 00 06 24 00 00 A6 AC 03 00 00 10 04 00 A3 AC F1 FF 00 10 07 00 02 24 04 00 00 10 08 00 A2 AC 00 00 A2 AC 08 00 82 8C 04 00 A2 AC 00 00 A2 8C 07 00 03 24 09 00 43 10 09 00 03 24 0A 00 43 10 06 00 03 24 0C 00 43 14 00 00 00 00 10 00 82 8C 04 00 A2 AC 07 00 00 10 14 00 82 8C 10 00 82 8C 08 00 E0 03 04 00 A2 AC 1C 00 82 8C 04 00 A2 AC 20 00 82 8C 08 00 A2 AC 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_674_0_0 {
	meta:
		name = "getitimer"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 09 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_675_0_0 {
	meta:
		name = "endhostent"
		size = 156
		refs = "0000 _gp_disp 0018 _pthread_cleanup_push_defer 001c __pthread_mutex_unlock 0040 __pthread_mutex_lock 0064 __GI_fclose 0078 _pthread_cleanup_pop_restore"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 C8 FF BD 27 30 00 B1 AF ?? ?? 91 8F ?? ?? 99 8F ?? ?? 85 8F 2C 00 B0 AF 18 00 B0 27 10 00 BC AF ?? ?? 26 26 34 00 BF AF ?? ?? ?? ?? 21 20 00 02 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? ?? ?? 24 26 10 00 BC 8F ?? ?? 91 8F ?? ?? 82 8F ?? ?? 24 8E 06 00 80 10 ?? ?? 40 AC ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F ?? ?? 20 AE ?? ?? 99 8F 21 20 00 02 ?? ?? ?? ?? 01 00 05 24 34 00 BF 8F 30 00 B1 8F 2C 00 B0 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_675_1_0 {
	meta:
		name = "sethostent"
		size = 140
		refs = "0000 _gp_disp 0018 __pthread_mutex_unlock 001c _pthread_cleanup_push_defer 004c __pthread_mutex_lock 0068 _pthread_cleanup_pop_restore"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 C8 FF BD 27 2C 00 B1 AF ?? ?? 91 8F ?? ?? 85 8F ?? ?? 99 8F 28 00 B0 AF 18 00 B0 27 34 00 BF AF ?? ?? 26 26 30 00 B2 AF 10 00 BC AF 21 90 80 00 ?? ?? ?? ?? 21 20 00 02 10 00 BC 8F ?? ?? 24 26 ?? ?? 99 8F ?? ?? ?? ?? 2B 90 12 00 10 00 BC 8F 21 20 00 02 01 00 05 24 ?? ?? 82 8F ?? ?? 99 8F ?? ?? ?? ?? ?? ?? 52 AC 34 00 BF 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_675_2_0 {
	meta:
		name = "__GI_gethostent_r"
		size = 332
		refs = "0000 _gp_disp 0018 _pthread_cleanup_push_defer 0024 __pthread_mutex_unlock 0068 __pthread_mutex_lock 0088 __open_etc_hosts 00b0 __read_etc_hosts_r 00f4 _pthread_cleanup_pop_restore 00f8 __GI_fclose"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 98 FF BD 27 44 00 B0 AF ?? ?? 90 8F ?? ?? 99 8F 58 00 B5 AF 21 A8 A0 00 ?? ?? 85 8F 48 00 B1 AF 30 00 B1 27 28 00 BC AF 64 00 BF AF 60 00 B7 AF 5C 00 B6 AF 54 00 B4 AF 50 00 B3 AF 4C 00 B2 AF 21 B0 80 00 21 A0 C0 00 21 20 20 02 ?? ?? 06 26 ?? ?? ?? ?? 21 98 E0 00 28 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? ?? ?? 04 26 28 00 BC 8F ?? ?? 90 8F ?? ?? 02 8E 0A 00 40 14 21 B8 00 02 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 ?? ?? 02 AE 04 00 40 14 28 00 BC 8F 00 00 60 AE 19 00 00 10 02 00 10 24 78 00 A2 8F ?? ?? 99 8F ?? ?? E4 8E 10 00 B6 AF 14 00 B5 AF 18 00 B4 AF 1C 00 B3 AF 20 00 A2 AF 21 28 00 00 02 00 06 24 ?? ?? 92 8F ?? ?? ?? ?? 01 00 07 24 28 00 BC 8F 21 80 40 00 ?? ?? 82 8F ?? ?? 42 8C 07 00 40 14 ?? ?? 99 8F ?? ?? 99 8F ?? ?? ?? ?? ?? ?? 44 8E 28 00 BC 8F ?? ?? 40 AE ?? ?? 99 8F 21 20 20 02 ?? ?? ?? ?? 01 00 05 24 64 00 BF 8F 21 10 00 02 60 00 B7 8F 5C 00 B6 8F 58 00 B5 8F 54 00 B4 8F 50 00 B3 8F 4C 00 B2 8F 48 00 B1 8F 44 00 B0 8F 08 00 E0 03 68 00 BD 27 }
	condition:
		$1
}

rule file_677_0_0 {
	meta:
		name = "__GI_tcgetpgrp"
		size = 68
		refs = "0000 _gp_disp 000c __GI_ioctl"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F D8 FF BD 27 04 40 05 3C 77 74 A5 24 10 00 BC AF 24 00 BF AF ?? ?? ?? ?? 18 00 A6 27 02 00 41 04 18 00 A2 8F FF FF 02 24 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_678_0_0 {
	meta:
		name = "__GI_if_nametoindex"
		size = 228
		refs = "0000 _gp_disp 000c __opensock 0040 __GI_strncpy 0064 __GI_ioctl 0078 __GI_close 007c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F B0 FF BD 27 10 00 BC AF 44 00 B2 AF 3C 00 B0 AF 4C 00 BF AF 48 00 B3 AF 40 00 B1 AF ?? ?? ?? ?? 21 90 80 00 21 80 40 00 1D 00 40 04 10 00 BC 8F ?? ?? 99 8F 18 00 B1 27 21 20 20 02 21 28 40 02 ?? ?? ?? ?? 10 00 06 24 10 00 BC 8F 21 30 20 02 21 20 00 02 ?? ?? 99 8F ?? ?? ?? ?? 33 89 05 34 10 00 BC 8F 10 00 41 04 ?? ?? 91 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 53 8C 21 20 00 02 21 C8 20 02 ?? ?? ?? ?? 21 90 40 00 16 00 02 24 09 00 62 56 21 10 00 00 59 00 02 24 00 00 42 AE 05 00 00 10 21 10 00 00 21 C8 20 02 ?? ?? ?? ?? 21 20 00 02 28 00 A2 8F 4C 00 BF 8F 48 00 B3 8F 44 00 B2 8F 40 00 B1 8F 3C 00 B0 8F 08 00 E0 03 50 00 BD 27 }
	condition:
		$1
}

rule file_678_1_0 {
	meta:
		name = "__GI_if_freenameindex"
		size = 100
		refs = "0000 _gp_disp 0030 free"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D8 FF BD 27 20 00 B1 AF 1C 00 B0 AF 10 00 BC AF 24 00 BF AF 21 88 80 00 21 80 80 00 04 00 04 8E 05 00 80 10 ?? ?? 99 8F ?? ?? ?? ?? 08 00 10 26 FA FF 00 10 10 00 BC 8F 00 00 02 8E FA FF 40 14 24 00 BF 8F 1C 00 B0 8F 21 20 20 02 20 00 B1 8F ?? ?? ?? ?? 28 00 BD 27 }
	condition:
		$1
}

rule file_678_2_0 {
	meta:
		name = "__GI_if_nameindex"
		size = 608
		refs = "0000 _gp_disp 000c __opensock 0058 __GI_ioctl 00bc __GI_close 00dc malloc 0100 __GI_strdup 0114 __GI___errno_location 01b0 free"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F B8 FF BD 27 40 00 BE AF 20 00 B0 AF 21 F0 A0 03 10 00 BC AF 44 00 BF AF 3C 00 B7 AF 38 00 B6 AF 34 00 B5 AF 30 00 B4 AF 2C 00 B3 AF 28 00 B2 AF 24 00 B1 AF ?? ?? ?? ?? 00 00 00 00 21 80 40 00 75 00 40 04 10 00 DC 8F ?? ?? 93 8F 1C 00 C0 AF 80 00 11 24 18 00 D2 27 40 10 11 00 0E 00 43 24 C2 18 03 00 C0 18 03 00 1C 00 C5 8F 23 E8 A3 03 10 00 A3 27 21 20 62 00 26 20 A4 00 21 88 51 00 0B 88 44 00 1C 00 C3 AF 18 00 D1 AF 21 20 00 02 12 89 05 34 21 C8 60 02 ?? ?? ?? ?? 21 30 40 02 10 00 DC 8F 06 00 41 04 ?? ?? 96 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 00 02 58 00 00 10 21 10 00 00 18 00 D4 8F E5 FF 91 12 40 10 11 00 ?? ?? 99 8F 42 A1 14 00 01 00 84 26 ?? ?? ?? ?? C0 20 04 00 10 00 DC 8F 21 88 40 00 21 90 00 00 1F 00 40 14 ?? ?? 97 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 00 02 10 00 DC 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 84 00 03 24 40 00 00 10 00 00 43 AC 1C 00 C2 8F 40 99 12 00 21 C8 E0 02 21 98 53 00 ?? ?? ?? ?? 21 20 60 02 21 A8 35 02 10 00 DC 8F 10 00 40 10 04 00 A2 AE 21 20 00 02 33 89 05 34 21 C8 C0 02 ?? ?? ?? ?? 21 30 60 02 09 00 40 04 10 00 DC 8F 10 00 62 8E 01 00 52 26 00 00 A2 AE 2B 10 54 02 EA FF 40 14 C0 A8 12 00 20 00 00 10 ?? ?? 99 8F ?? ?? 99 8F ?? ?? ?? ?? 21 A0 00 00 00 00 53 8C 10 00 DC 8F 21 A8 40 00 2B 10 92 02 08 00 40 10 ?? ?? 99 8F C0 10 14 00 21 10 22 02 04 00 44 8C ?? ?? ?? ?? 01 00 94 26 F7 FF 00 10 10 00 DC 8F ?? ?? ?? ?? 21 20 20 02 10 00 DC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 00 02 16 00 02 24 04 00 62 12 0C 00 63 3A 84 00 02 24 02 00 00 10 0A 98 43 00 59 00 13 24 08 00 00 10 00 00 B3 AE 21 A8 35 02 00 00 A0 AE 04 00 A0 AE ?? ?? ?? ?? 21 20 00 02 02 00 00 10 21 10 20 02 21 10 00 00 21 E8 C0 03 44 00 BF 8F 40 00 BE 8F 3C 00 B7 8F 38 00 B6 8F 34 00 B5 8F 30 00 B4 8F 2C 00 B3 8F 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 08 00 E0 03 48 00 BD 27 }
	condition:
		$1
}

rule file_678_3_0 {
	meta:
		name = "if_indextoname"
		size = 236
		refs = "0000 _gp_disp 000c __opensock 0044 __GI_ioctl 0068 __GI_close 006c __GI___errno_location 00b8 __GI_strncpy"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F B0 FF BD 27 10 00 BC AF 48 00 B3 AF 40 00 B1 AF 3C 00 B0 AF 4C 00 BF AF 44 00 B2 AF 21 88 80 00 ?? ?? ?? ?? 21 98 A0 00 21 80 40 00 23 00 40 04 10 00 BC 8F ?? ?? 99 8F 28 00 B1 AF 18 00 B1 27 21 20 40 00 10 89 05 34 ?? ?? ?? ?? 21 30 20 02 10 00 BC 8F 0E 00 41 04 ?? ?? 92 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 51 8C 21 20 00 02 21 C8 40 02 ?? ?? ?? ?? 21 98 40 00 13 00 23 3A 06 00 02 24 0A 88 43 00 0C 00 00 10 00 00 71 AE 21 C8 40 02 ?? ?? ?? ?? 21 20 00 02 10 00 BC 8F 21 20 60 02 21 28 20 02 ?? ?? 99 8F ?? ?? ?? ?? 10 00 06 24 03 00 00 10 4C 00 BF 8F 21 10 00 00 4C 00 BF 8F 48 00 B3 8F 44 00 B2 8F 40 00 B1 8F 3C 00 B0 8F 08 00 E0 03 50 00 BD 27 }
	condition:
		$1
}

rule file_679_0_0 {
	meta:
		name = "nrand48"
		size = 56
		refs = "0000 _gp_disp 000c __libc_drand48_data 0010 __GI_nrand48_r"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 85 8F ?? ?? 99 8F D8 FF BD 27 24 00 BF AF 10 00 BC AF ?? ?? ?? ?? 18 00 A6 27 24 00 BF 8F 18 00 A2 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_771_0_0 {
	meta:
		name = "jrand48"
		size = 56
		refs = "0000 _gp_disp 000c __libc_drand48_data 0010 __GI_jrand48_r"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 85 8F ?? ?? 99 8F D8 FF BD 27 24 00 BF AF 10 00 BC AF ?? ?? ?? ?? 18 00 A6 27 24 00 BF 8F 18 00 A2 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_680_0_0 {
	meta:
		name = "__GI_vsnprintf"
		size = 240
		refs = "0000 _gp_disp 0014 __stdio_init_mutex 0078 _vfprintf_internal"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 80 FF BD 27 FE FF 02 24 ?? ?? 99 8F 1C 00 A2 AF D0 00 02 24 18 00 A2 A7 01 00 02 24 10 00 BC AF 7C 00 BF AF 78 00 B4 AF 74 00 B3 AF 70 00 B2 AF 6C 00 B1 AF 68 00 B0 AF 4C 00 A2 AF 21 80 80 00 1A 00 A0 A3 50 00 A4 27 44 00 A0 AF 21 90 A0 00 21 A0 C0 00 ?? ?? ?? ?? 21 98 E0 00 10 00 BC 8F 27 10 10 00 2B 88 42 02 0A 90 51 00 ?? ?? 99 8F 21 10 12 02 38 00 A0 AF 20 00 B0 AF 24 00 A2 AF 28 00 B0 AF 2C 00 B0 AF 30 00 B0 AF 34 00 A2 AF 18 00 A4 27 21 28 80 02 ?? ?? ?? ?? 21 30 60 02 08 00 40 12 28 00 A3 8F 24 00 A4 8F 05 00 64 54 00 00 60 A0 FF FF 63 24 28 00 A3 AF 28 00 A3 8F 00 00 60 A0 7C 00 BF 8F 78 00 B4 8F 74 00 B3 8F 70 00 B2 8F 6C 00 B1 8F 68 00 B0 8F 08 00 E0 03 80 00 BD 27 }
	condition:
		$1
}

rule file_681_0_0 {
	meta:
		name = "__GI_strtok_r"
		size = 184
		refs = "0000 _gp_disp 0038 __GI_strspn 0060 __GI_strpbrk 0078 __GI_rawmemchr"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D8 FF BD 27 10 00 BC AF 20 00 B2 AF 1C 00 B1 AF 18 00 B0 AF 24 00 BF AF 21 80 80 00 21 90 A0 00 02 00 80 14 21 88 C0 00 00 00 D0 8C ?? ?? 99 8F 21 20 00 02 ?? ?? ?? ?? 21 28 40 02 21 80 02 02 00 00 02 82 03 00 40 14 10 00 BC 8F 11 00 00 10 00 00 30 AE ?? ?? 99 8F 21 20 00 02 ?? ?? ?? ?? 21 28 40 02 07 00 40 14 10 00 BC 8F ?? ?? 99 8F 21 20 00 02 ?? ?? ?? ?? 21 28 00 00 04 00 00 10 00 00 22 AE 00 00 40 A0 01 00 42 24 00 00 22 AE 21 10 00 02 24 00 BF 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_684_0_0 {
	meta:
		name = "__GI_sigfillset"
		size = 28
	strings:
		$1 = { FF FF 02 24 0C 00 82 AC 08 00 82 AC 04 00 82 AC 00 00 82 AC 08 00 E0 03 21 10 00 00 }
	condition:
		$1
}

rule file_685_0_0 {
	meta:
		name = "inet_lnaof"
		size = 52
	strings:
		$1 = { A0 20 04 7C 02 24 24 00 03 00 80 04 00 C0 03 3C 08 00 E0 03 00 B8 82 7C 24 18 83 00 00 80 05 3C FF FF 82 30 26 18 65 00 FF 00 84 30 08 00 E0 03 0B 10 83 00 }
	condition:
		$1
}

rule file_686_0_0 {
	meta:
		name = "firstwhite"
		size = 128
		refs = "0000 _gp_disp 0014 __GI_strchr"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D8 FF BD 27 1C 00 B1 AF ?? ?? 91 8F 10 00 BC AF 24 00 BF AF 20 00 B2 AF 18 00 B0 AF 20 00 05 24 21 C8 20 02 ?? ?? ?? ?? 21 90 80 00 21 80 40 00 21 20 40 02 21 C8 20 02 ?? ?? ?? ?? 09 00 05 24 07 00 00 12 24 00 BF 8F 03 00 40 10 2B 18 02 02 03 00 00 10 0B 10 03 02 21 10 00 02 24 00 BF 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_686_1_0 {
	meta:
		name = "__get_next_rpcent"
		size = 468
		refs = "0000 _gp_disp 0020 __GI_strlen 0024 __GI_fgets 0088 __GI_strchr 00c4 firstwhite 0108 __GI_atoi"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 C8 FF BD 27 24 00 B2 AF ?? ?? 92 8F 30 00 B5 AF 2C 00 B4 AF ?? ?? 95 8F ?? ?? 94 8F 20 00 B1 AF 1C 00 B0 AF 10 00 BC AF 34 00 BF AF 28 00 B3 AF 21 80 80 00 A8 00 91 24 ?? ?? 52 26 00 00 06 8E 21 20 20 02 21 C8 80 02 ?? ?? ?? ?? 00 10 05 24 53 00 40 10 21 C8 A0 02 ?? ?? ?? ?? 21 20 20 02 21 10 02 02 0A 00 03 24 10 00 BC 8F A7 00 43 A0 A8 00 03 82 23 00 02 24 F0 FF 62 10 ?? ?? 93 8F 21 20 20 02 21 C8 60 02 ?? ?? ?? ?? 23 00 05 24 08 00 40 54 00 00 40 A0 21 20 20 02 21 C8 60 02 ?? ?? ?? ?? 0A 00 05 24 E5 FF 40 50 00 00 06 8E 00 00 40 A0 21 C8 40 02 ?? ?? ?? ?? 21 20 20 02 21 98 40 02 DD FF 40 10 10 00 BC 8F 00 00 40 A0 01 00 52 24 9C 00 11 AE 20 00 04 24 09 00 03 24 00 00 42 82 03 00 44 14 00 00 00 00 FC FF 00 10 01 00 52 26 FA FF 43 50 01 00 52 26 ?? ?? 99 8F 21 20 40 02 ?? ?? ?? ?? 10 00 11 26 A4 00 02 AE A0 00 11 AE 21 C8 60 02 ?? ?? ?? ?? 21 20 40 02 03 00 40 10 01 00 44 24 02 00 00 10 00 00 40 A0 21 20 00 00 20 00 12 24 09 00 14 24 98 00 15 26 15 00 80 50 00 00 20 AE 00 00 82 80 12 00 40 50 00 00 20 AE FA FF 52 50 01 00 84 24 03 00 54 14 2B 10 35 02 F6 FF 00 10 01 00 84 24 03 00 40 10 21 C8 60 02 00 00 24 AE 04 00 31 26 ?? ?? ?? ?? 00 00 00 00 03 00 40 10 01 00 44 24 EC FF 00 10 00 00 40 A0 00 00 20 AE 02 00 00 10 9C 00 02 26 21 10 00 00 34 00 BF 8F 30 00 B5 8F 2C 00 B4 8F 28 00 B3 8F 24 00 B2 8F 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_686_2_0 {
	meta:
		name = "_rpcdata"
		size = 80
		refs = "0000 _gp_disp 002c calloc"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 18 00 B0 AF ?? ?? 90 8F 10 00 BC AF 1C 00 BF AF ?? ?? 02 8E 07 00 40 14 1C 00 BF 8F ?? ?? 99 8F 01 00 04 24 ?? ?? ?? ?? B0 10 05 24 ?? ?? 02 AE 1C 00 BF 8F 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_686_3_0 {
	meta:
		name = "__copy_rpcent.part.1"
		size = 408
		refs = "0000 _gp_disp 000c __GI_memset 00ac __GI_strlen 00f8 __GI_memcpy"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F C8 FF BD 27 10 00 BC AF 34 00 BF AF 28 00 B4 AF 20 00 B2 AF 1C 00 B1 AF 18 00 B0 AF 21 88 80 00 21 80 A0 00 21 20 A0 00 21 90 C0 00 21 28 00 00 0C 00 06 24 30 00 B6 AF 2C 00 B5 AF 24 00 B3 AF ?? ?? ?? ?? 21 A0 E0 00 10 00 BC 8F 21 20 40 02 21 28 00 00 ?? ?? 99 8F ?? ?? ?? ?? 21 30 80 02 08 00 22 8E 10 00 BC 8F 08 00 02 AE 21 10 00 00 04 00 24 8E 80 18 02 00 21 18 83 00 00 00 63 8C 03 00 60 10 01 00 53 24 FA FF 00 10 21 10 60 02 80 98 13 00 2B 18 93 02 03 00 60 10 ?? ?? 96 8F 2F 00 00 10 22 00 02 24 04 00 12 AE 21 90 53 02 23 98 93 02 1B 00 40 10 FF FF 55 24 04 00 22 8E 80 A0 15 00 21 C8 C0 02 21 10 54 00 ?? ?? ?? ?? 00 00 44 8C 01 00 46 24 2B 10 66 02 F0 FF 40 14 10 00 BC 8F 04 00 02 8E ?? ?? 99 8F 23 98 66 02 21 10 54 00 00 00 52 AC 04 00 02 8E 04 00 23 8E 21 90 46 02 21 10 54 00 21 A0 74 00 00 00 44 8C ?? ?? ?? ?? 00 00 85 8E 10 00 BC 8F E5 FF 00 10 21 10 A0 02 ?? ?? 99 8F ?? ?? ?? ?? 00 00 24 8E 2B 98 53 00 DA FF 60 12 10 00 BC 8F 00 00 12 AE ?? ?? 99 8F 00 00 25 8E 21 20 40 02 ?? ?? ?? ?? 21 30 40 00 48 00 A2 8F 00 00 50 AC 21 10 00 00 34 00 BF 8F 30 00 B6 8F 2C 00 B5 8F 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_686_4_0 {
	meta:
		name = "__GI_endrpcent"
		size = 128
		refs = "0000 _gp_disp 0024 _rpcdata 0044 free 0060 __GI_fclose"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F E0 FF BD 27 10 00 BC AF 18 00 B0 AF 1C 00 BF AF ?? ?? 39 27 ?? ?? ?? ?? 00 00 00 00 21 80 40 00 0F 00 40 10 10 00 BC 8F 0C 00 42 8C 0D 00 40 14 1C 00 BF 8F ?? ?? 99 8F ?? ?? ?? ?? 04 00 04 8E 00 00 04 8E 10 00 BC 8F 05 00 80 10 04 00 00 AE ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 00 AE 1C 00 BF 8F 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_686_5_0 {
	meta:
		name = "__GI_setrpcent"
		size = 168
		refs = "0000 _gp_disp 0028 _rpcdata 0044 __GI_rewind 0050 __GI_fopen 004c $LC0 0078 free"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F D8 FF BD 27 10 00 BC AF 20 00 B1 AF 1C 00 B0 AF 24 00 BF AF ?? ?? 39 27 ?? ?? ?? ?? 21 88 80 00 21 80 40 00 17 00 40 10 10 00 BC 8F 00 00 44 8C 0A 00 80 14 ?? ?? 99 8F ?? ?? 84 8F ?? ?? 85 8F ?? ?? 99 8F ?? ?? 84 24 ?? ?? ?? ?? ?? ?? A5 24 10 00 BC 8F 04 00 00 10 00 00 02 AE ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 04 00 04 8E 0C 00 02 8E 04 00 00 AE 25 88 51 00 0C 00 11 AE 24 00 BF 8F 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_686_6_0 {
	meta:
		name = "__GI_getrpcent"
		size = 148
		refs = "0000 _gp_disp 0024 _rpcdata 0058 __get_next_rpcent 0064 __GI_fopen 0060 $LC0"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F E0 FF BD 27 10 00 BC AF 18 00 B0 AF 1C 00 BF AF ?? ?? 39 27 ?? ?? ?? ?? 00 00 00 00 21 80 40 00 13 00 40 10 10 00 BC 8F 00 00 42 8C 08 00 40 10 ?? ?? 84 8F ?? ?? 99 8F 1C 00 BF 8F 21 20 00 02 18 00 B0 8F ?? ?? 39 27 ?? ?? ?? ?? 20 00 BD 27 ?? ?? 85 8F ?? ?? 99 8F ?? ?? 84 24 ?? ?? ?? ?? ?? ?? A5 24 10 00 BC 8F F2 FF 40 14 00 00 02 AE 1C 00 BF 8F 18 00 B0 8F 21 10 00 00 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_686_7_0 {
	meta:
		name = "__GI_getrpcbynumber"
		size = 164
		refs = "0000 _gp_disp 002c _rpcdata 003c __GI_setrpcent 004c __GI_getrpcent 0074 __GI_endrpcent"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F D8 FF BD 27 10 00 BC AF 1C 00 B1 AF 24 00 BF AF 20 00 B2 AF 18 00 B0 AF ?? ?? 39 27 ?? ?? ?? ?? 21 88 80 00 14 00 40 10 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 00 00 10 00 BC 8F ?? ?? 92 8F 21 C8 40 02 ?? ?? ?? ?? 00 00 00 00 21 80 40 00 04 00 40 10 10 00 BC 8F 08 00 02 8E F9 FF 51 14 21 C8 40 02 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 02 00 00 10 21 10 00 02 21 10 00 00 24 00 BF 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_686_8_0 {
	meta:
		name = "__GI_getrpcbyname"
		size = 228
		refs = "0000 _gp_disp 000c __GI_setrpcent 0044 __GI_getrpcent 0048 __GI_strcmp 00a8 __GI_endrpcent"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F C8 FF BD 27 10 00 BC AF 2C 00 B4 AF 28 00 B3 AF 24 00 B2 AF 34 00 BF AF 30 00 B5 AF 20 00 B1 AF 1C 00 B0 AF 21 90 80 00 ?? ?? ?? ?? 21 20 00 00 10 00 BC 8F ?? ?? 93 8F ?? ?? 94 8F 21 C8 60 02 ?? ?? ?? ?? 00 00 00 00 21 80 40 00 12 00 40 10 10 00 BC 8F 00 00 04 8E 21 C8 80 02 ?? ?? ?? ?? 21 28 40 02 10 00 BC 8F 10 00 40 10 ?? ?? 95 8F 04 00 11 8E 00 00 24 8E F0 FF 80 10 21 C8 A0 02 ?? ?? ?? ?? 21 28 40 02 08 00 40 10 04 00 31 26 F9 FF 00 10 00 00 24 8E ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 02 00 00 10 21 10 00 00 21 10 00 02 34 00 BF 8F 30 00 B5 8F 2C 00 B4 8F 28 00 B3 8F 24 00 B2 8F 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_686_9_0 {
	meta:
		name = "getrpcbynumber_r"
		size = 240
		refs = "0000 _gp_disp 0018 _pthread_cleanup_push_defer 0024 __pthread_mutex_unlock 0068 __pthread_mutex_lock 0078 __GI_getrpcbynumber 00a8 __copy_rpcent.part.1 00b8 _pthread_cleanup_pop_restore"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 A8 FF BD 27 44 00 B2 AF ?? ?? 92 8F ?? ?? 99 8F 4C 00 B4 AF 21 A0 A0 00 ?? ?? 85 8F 3C 00 B0 AF 20 00 B0 27 30 00 A7 AF 54 00 BF AF 18 00 BC AF 50 00 B5 AF 48 00 B3 AF 40 00 B1 AF 21 A8 80 00 21 98 C0 00 21 20 00 02 ?? ?? 46 26 ?? ?? ?? ?? 68 00 B1 8F 18 00 BC 8F ?? ?? 44 26 ?? ?? 99 8F ?? ?? ?? ?? 02 00 12 24 18 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 A0 02 18 00 BC 8F 00 00 20 AE 0A 00 40 10 30 00 A7 8F ?? ?? 99 8F 10 00 B1 AF 21 20 40 00 21 28 80 02 ?? ?? 39 27 ?? ?? ?? ?? 21 30 60 02 18 00 BC 8F 21 90 40 00 ?? ?? 99 8F 21 20 00 02 ?? ?? ?? ?? 01 00 05 24 54 00 BF 8F 21 10 40 02 50 00 B5 8F 4C 00 B4 8F 48 00 B3 8F 44 00 B2 8F 40 00 B1 8F 3C 00 B0 8F 08 00 E0 03 58 00 BD 27 }
	condition:
		$1
}

rule file_686_10_0 {
	meta:
		name = "getrpcbyname_r"
		size = 240
		refs = "0000 _gp_disp 0018 _pthread_cleanup_push_defer 0024 __pthread_mutex_unlock 0068 __pthread_mutex_lock 0078 __GI_getrpcbyname 00a8 __copy_rpcent.part.1 00b8 _pthread_cleanup_pop_restore"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 A8 FF BD 27 44 00 B2 AF ?? ?? 92 8F ?? ?? 99 8F 4C 00 B4 AF 21 A0 A0 00 ?? ?? 85 8F 3C 00 B0 AF 20 00 B0 27 30 00 A7 AF 54 00 BF AF 18 00 BC AF 50 00 B5 AF 48 00 B3 AF 40 00 B1 AF 21 A8 80 00 21 98 C0 00 21 20 00 02 ?? ?? 46 26 ?? ?? ?? ?? 68 00 B1 8F 18 00 BC 8F ?? ?? 44 26 ?? ?? 99 8F ?? ?? ?? ?? 02 00 12 24 18 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 A0 02 18 00 BC 8F 00 00 20 AE 0A 00 40 10 30 00 A7 8F ?? ?? 99 8F 10 00 B1 AF 21 20 40 00 21 28 80 02 ?? ?? 39 27 ?? ?? ?? ?? 21 30 60 02 18 00 BC 8F 21 90 40 00 ?? ?? 99 8F 21 20 00 02 ?? ?? ?? ?? 01 00 05 24 54 00 BF 8F 21 10 40 02 50 00 B5 8F 4C 00 B4 8F 48 00 B3 8F 44 00 B2 8F 40 00 B1 8F 3C 00 B0 8F 08 00 E0 03 58 00 BD 27 }
	condition:
		$1
}

rule file_686_11_0 {
	meta:
		name = "getrpcent_r"
		size = 236
		refs = "0000 _gp_disp 0018 _pthread_cleanup_push_defer 0024 __pthread_mutex_unlock 0064 __pthread_mutex_lock 0074 __GI_getrpcent 00a4 __copy_rpcent.part.1 00b4 _pthread_cleanup_pop_restore"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 B0 FF BD 27 3C 00 B2 AF ?? ?? 92 8F ?? ?? 99 8F 44 00 B4 AF 21 A0 A0 00 ?? ?? 85 8F 34 00 B0 AF 20 00 B0 27 4C 00 BF AF 18 00 BC AF 48 00 B5 AF 40 00 B3 AF 38 00 B1 AF 21 A8 80 00 21 98 C0 00 21 20 00 02 ?? ?? 46 26 ?? ?? ?? ?? 21 88 E0 00 18 00 BC 8F ?? ?? 44 26 ?? ?? 99 8F ?? ?? ?? ?? 02 00 12 24 18 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 18 00 BC 8F 0B 00 40 10 00 00 20 AE ?? ?? 99 8F 10 00 B1 AF 21 20 40 00 21 28 A0 02 21 30 80 02 ?? ?? 39 27 ?? ?? ?? ?? 21 38 60 02 18 00 BC 8F 21 90 40 00 ?? ?? 99 8F 21 20 00 02 ?? ?? ?? ?? 01 00 05 24 4C 00 BF 8F 21 10 40 02 48 00 B5 8F 44 00 B4 8F 40 00 B3 8F 3C 00 B2 8F 38 00 B1 8F 34 00 B0 8F 08 00 E0 03 50 00 BD 27 }
	condition:
		$1
}

rule file_687_0_0 {
	meta:
		name = "__libc_select"
		size = 100
		refs = "0000 _gp_disp 003c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 30 00 A2 8F E0 FF BD 27 10 00 A2 AF 2E 10 02 24 0C 00 00 00 20 00 BD 27 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_688_0_0 {
	meta:
		name = "__GI_seed48_r"
		size = 140
		refs = "0000 _gp_disp 000c __GI_memcpy"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F D8 FF BD 27 06 00 06 24 24 00 BF AF 20 00 B1 AF 1C 00 B0 AF 21 88 80 00 10 00 BC AF 06 00 A4 24 ?? ?? ?? ?? 21 80 A0 00 04 00 22 96 24 00 BF 8F 05 00 03 24 04 00 02 A6 02 00 22 96 02 00 02 A6 00 00 22 96 20 00 B1 8F 14 00 03 AE 00 00 02 A6 EC DE 02 3C 6D E6 42 34 10 00 02 AE 0B 00 02 24 0C 00 02 A6 01 00 02 24 0E 00 02 A6 1C 00 B0 8F 21 10 00 00 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_689_0_0 {
	meta:
		name = "__GI_setreuid"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF E6 0F 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_691_0_0 {
	meta:
		name = "__dns_lookup"
		size = 2052
		refs = "0000 _gp_disp 000c malloc 0060 __GI_strlen 00c8 __GI_memcpy 0100 __pthread_mutex_unlock 0104 __resolv_lock 0108 _pthread_cleanup_push_defer 011c __pthread_mutex_lock 012c __open_nameservers 0144 __searchdomains 0168 __searchdomain 016c __GI_strcpy 0190 __nameservers 01e4 __nameserver 0224 _pthread_cleanup_pop_restore 0240 __GI_memset 0270 __encode_header 02a8 __encode_question 02d0 __GI_socket 02f0 __GI_connect 030c __GI_send 0334 __GI_poll 035c __GI_recv 0398 __decode_header 03d8 __GI___h_errno_location 04d0 __decode_dotted 0510 __GI_strdup 05f0 __GI_close 067c free"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F 08 FE BD 27 18 00 BC AF F4 01 BF AF EC 01 B7 AF E8 01 B6 AF D0 01 B0 AF FC 01 A5 AF 21 80 80 00 00 02 A6 AF 00 02 04 24 F0 01 BE AF E4 01 B5 AF E0 01 B4 AF DC 01 B3 AF D8 01 B2 AF D4 01 B1 AF ?? ?? ?? ?? 21 B0 E0 00 18 00 BC 8F 21 20 00 02 ?? ?? 99 8F ?? ?? ?? ?? 21 B8 40 00 A4 01 A2 AF 7F 03 42 2C 03 00 40 14 18 00 BC 8F C1 01 00 10 A0 01 A0 AF A4 01 A3 8F ?? ?? 99 8F ?? ?? ?? ?? 82 00 64 24 A0 01 A2 AF BA 01 E0 12 18 00 BC 8F B8 01 40 50 A0 01 A0 AF 00 00 02 82 B5 01 40 10 A4 01 B9 8F A0 01 A4 8F 21 28 00 02 21 10 19 02 FF FF 42 80 21 30 20 03 ?? ?? 99 8F B8 01 A2 AF ?? ?? ?? ?? FF FF 13 24 20 00 A3 27 A4 01 B9 8F B4 01 A3 AF A0 01 A3 8F 01 00 22 27 18 00 BC 8F 21 10 62 00 FF FF 10 24 B0 01 A0 AF BC 01 A2 AF ?? ?? 85 8F ?? ?? 86 8F ?? ?? 99 8F ?? ?? ?? ?? 20 00 A4 27 18 00 BC 8F ?? ?? 84 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 18 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 18 00 BC 8F A4 01 A3 8F A0 01 B9 8F ?? ?? 82 8F 00 00 5E 8C 21 10 23 03 2B 18 1E 02 03 00 60 14 2E 00 03 24 0B 00 00 10 00 00 40 A0 00 00 43 A0 ?? ?? 82 8F ?? ?? 99 8F BC 01 A4 8F 00 00 43 8C 80 10 10 00 21 10 62 00 ?? ?? ?? ?? 00 00 45 8C 18 00 BC 8F 0A 00 61 06 ?? ?? 82 8F ?? ?? 84 8F ?? ?? 85 8F 00 00 43 8C ?? ?? 84 94 ?? ?? B3 8C AC 01 A4 AF 03 00 04 24 02 28 83 70 B0 01 A5 AF 00 00 42 8C AC 01 A3 8F ?? ?? 84 8F 2B 10 62 02 0A 98 02 00 01 00 62 24 B0 01 B9 8F FF FF 42 30 ?? ?? 85 8F ?? ?? 82 A4 AC 01 A2 AF ?? ?? 82 8F FF FF 39 27 B0 01 B9 AF ?? ?? B3 AC 78 01 B9 27 00 00 45 8C 21 20 20 03 A8 01 B9 AF ?? ?? 99 8F 00 11 13 00 10 00 06 24 ?? ?? ?? ?? 21 28 A2 00 18 00 BC 8F 20 00 A4 27 01 00 05 24 ?? ?? 99 8F 20 01 B2 27 ?? ?? ?? ?? 01 00 14 24 18 00 BC 8F 21 20 E0 02 21 28 00 00 ?? ?? 99 8F ?? ?? ?? ?? 00 02 06 24 18 00 BC 8F 21 20 40 02 21 28 00 00 ?? ?? 99 8F ?? ?? ?? ?? 30 00 06 24 18 00 BC 8F AC 01 A3 8F 40 01 B4 AF ?? ?? 99 8F 20 01 A3 AF 34 01 B4 AF 21 20 40 02 21 28 E0 02 ?? ?? ?? ?? 00 02 06 24 21 88 40 00 3C 01 40 04 18 00 BC 8F A0 01 B9 8F FC 01 A3 8F 00 02 06 24 88 01 B9 AF ?? ?? 99 8F 90 01 B4 AF 8C 01 A3 AF 88 01 A4 27 21 28 E2 02 ?? ?? ?? ?? 23 30 C2 00 21 A0 40 00 2E 01 40 04 18 00 BC 8F ?? ?? 99 8F 78 01 A4 97 01 00 05 24 ?? ?? ?? ?? 11 00 06 24 21 A8 40 00 1B 01 40 04 18 00 BC 8F ?? ?? 99 8F 21 20 40 00 78 01 A5 27 ?? ?? ?? ?? 10 00 06 24 14 01 40 04 18 00 BC 8F ?? ?? 99 8F 21 30 34 02 21 20 A0 02 21 28 E0 02 ?? ?? ?? ?? 21 38 00 00 18 00 BC 8F 94 01 B9 27 88 13 11 24 A8 01 B9 AF ?? ?? 99 8F 01 00 02 24 94 01 B5 AF 98 01 A2 A7 94 01 A4 27 01 00 05 24 ?? ?? ?? ?? 21 30 20 02 00 01 40 18 18 00 BC 8F ?? ?? 99 8F 21 20 A0 02 21 28 E0 02 00 02 06 24 ?? ?? ?? ?? 40 00 07 24 21 A0 40 00 0C 00 42 28 18 FC 31 26 05 00 40 10 18 00 BC 8F EB FF 20 16 ?? ?? 99 8F F2 00 00 10 01 00 73 26 ?? ?? 99 8F 21 20 E0 02 ?? ?? ?? ?? 21 28 40 02 20 01 A2 8F AC 01 A3 8F F5 FF 43 14 18 00 BC 8F 24 01 A2 8F F2 FF 40 10 3C 01 A2 8F 03 00 03 24 0E 00 43 14 B8 01 B9 8F 2E 00 02 24 06 00 22 53 ?? ?? 99 8F FF FF C2 27 2A 10 02 02 DE 00 40 14 01 00 10 26 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 18 00 BC 8F 0B 00 00 10 01 00 03 24 D5 00 40 54 01 00 73 26 44 01 A2 8F 08 00 40 1C 0C 00 10 24 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 18 00 BC 8F 04 00 03 24 DD 00 00 10 00 00 43 AC 21 28 00 00 C0 FF 08 24 C0 00 09 24 40 01 A2 8F 2A 10 A2 00 1A 00 40 10 21 30 F0 02 C1 00 C0 10 23 10 90 02 21 20 C0 00 BF 00 40 58 01 00 73 26 00 00 83 90 0A 00 60 10 01 00 87 24 24 50 68 00 04 00 49 55 FF FF 42 24 02 00 87 24 04 00 00 10 FE FF 42 24 21 20 E3 00 F3 FF 00 10 23 10 43 00 04 00 42 28 AF 00 40 14 23 30 E6 00 04 00 C6 24 AC 00 C0 04 21 80 06 02 E4 FF 00 10 01 00 A5 24 50 01 A3 27 01 00 12 24 21 88 00 00 A8 01 A3 AF 44 01 A2 8F 2A 10 22 02 48 00 40 10 ?? ?? 99 8F 00 01 04 24 10 00 A4 AF 21 28 00 02 21 20 E0 02 21 30 80 02 ?? ?? ?? ?? 20 00 A7 27 21 18 40 00 37 00 40 04 18 00 BC 8F F6 FF 02 24 23 28 43 00 23 28 B0 00 21 28 85 02 30 00 A0 04 ?? ?? 99 8F 21 30 03 02 20 00 A4 27 C0 01 A3 AF C8 01 A5 AF C4 01 A6 AF ?? ?? ?? ?? 21 F0 E6 02 50 01 A2 AF 00 00 C2 93 01 00 C4 93 C4 01 A6 8F 00 12 02 00 25 10 44 00 54 01 A2 AF 02 00 C2 93 03 00 C4 93 C8 01 A5 8F 00 12 02 00 25 10 44 00 58 01 A2 AF 04 00 C4 93 05 00 C2 93 0A 00 C6 24 00 26 04 00 00 14 02 00 25 10 82 00 07 00 C4 93 0A 00 DE 27 18 00 BC 8F 25 10 44 00 FC FF C4 93 C0 01 A3 8F 00 22 04 00 25 10 44 00 5C 01 A2 AF FE FF C2 93 FF FF C4 93 64 01 BE AF 00 12 02 00 25 10 44 00 2A 28 A2 00 60 01 A2 AF 07 00 A0 14 68 01 A6 AF 0A 00 63 24 02 00 00 10 21 18 62 00 21 18 A0 00 0F 00 61 04 00 00 00 00 5F 00 20 12 01 00 73 26 30 01 A2 8F 5D 00 40 10 FF FF 10 24 ?? ?? 99 8F ?? ?? ?? ?? 21 20 A0 02 00 02 A3 8F 4C 00 60 10 18 00 BC 8F 00 02 B9 8F 4D 00 00 10 00 00 37 AF 2B 00 40 12 21 80 03 02 1C 00 DE 8E 20 00 D2 8E 24 00 C2 8E ?? ?? 99 8F 6C 01 BE AF 70 01 B2 AF 74 01 A2 AF 21 20 C0 02 50 01 A5 27 ?? ?? ?? ?? 28 00 06 24 04 00 C2 8E 18 00 03 24 08 00 43 10 18 00 BC 8F E5 FF C0 13 FC 01 B9 8F 01 00 03 24 03 00 23 13 1C 00 03 24 E1 FF 23 17 ?? ?? 99 8F FC 01 A3 8F 06 00 43 10 ?? ?? 99 8F 00 00 C4 8E ?? ?? ?? ?? 01 00 12 24 27 00 00 10 18 00 BC 8F 44 01 A2 8F 10 00 C3 8E 23 10 51 00 FF FF 42 24 04 00 63 24 24 00 C2 AE 02 10 43 70 2B 90 42 02 CF FF 40 16 ?? ?? 99 8F 1B 00 00 10 24 00 C0 AE ?? ?? 99 8F ?? ?? ?? ?? 50 01 A4 8F 54 01 A2 8F FC 01 A3 8F 14 00 43 14 18 00 BC 8F 10 00 C6 8E 60 01 A2 8F 06 00 C2 50 24 00 C4 8E ?? ?? 99 8F ?? ?? ?? ?? 00 00 C4 8E 16 00 00 10 18 00 BC 8F 1C 00 C2 8E ?? ?? 99 8F 02 18 C4 70 64 01 A5 8F ?? ?? ?? ?? 21 20 62 00 24 00 C2 8E 18 00 BC 8F 01 00 42 24 24 00 C2 AE 65 FF 00 10 01 00 31 26 ?? ?? 99 8F ?? ?? ?? ?? 21 20 E0 02 18 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? A0 01 A4 8F 20 00 00 10 21 10 80 02 01 00 73 26 FF FF 10 24 B0 01 A3 8F 08 00 60 18 FF FF 02 24 64 FE A2 12 ?? ?? 99 8F ?? ?? ?? ?? 21 20 A0 02 60 FE 00 10 18 00 BC 8F FF FF 15 24 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 FF FF 03 24 18 00 BC 8F 05 00 A3 12 00 00 43 AC ?? ?? 99 8F ?? ?? ?? ?? 21 20 A0 02 18 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? A0 01 A4 8F 18 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 E0 02 FF FF 02 24 F4 01 BF 8F F0 01 BE 8F EC 01 B7 8F E8 01 B6 8F E4 01 B5 8F E0 01 B4 8F DC 01 B3 8F D8 01 B2 8F D4 01 B1 8F D0 01 B0 8F 08 00 E0 03 F8 01 BD 27 }
	condition:
		$1
}

rule file_692_0_0 {
	meta:
		name = "__fbufsize"
		size = 16
	strings:
		$1 = { 0C 00 83 8C 08 00 82 8C 08 00 E0 03 23 10 62 00 }
	condition:
		$1
}

rule file_694_0_0 {
	meta:
		name = "labs"
		size = 16
	strings:
		$1 = { C3 1F 04 00 26 10 64 00 08 00 E0 03 23 10 43 00 }
	condition:
		$1
}

rule file_695_0_0 {
	meta:
		name = "__GI_kill"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF C5 0F 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_696_0_0 {
	meta:
		name = "__GI_strncmp"
		size = 184
	strings:
		$1 = { 04 00 C2 2C 1D 00 40 14 82 38 06 00 00 00 82 90 27 00 40 10 00 00 A3 90 25 00 43 14 00 00 00 00 01 00 82 90 22 00 40 10 01 00 A3 90 20 00 43 14 00 00 00 00 02 00 82 90 1D 00 40 10 02 00 A3 90 1B 00 43 14 04 00 88 24 03 00 82 90 03 00 A3 90 17 00 40 10 04 00 A4 24 15 00 43 14 FF FF E7 24 03 00 E0 10 21 28 80 00 E8 FF 00 10 21 20 00 01 03 00 C6 30 0C 00 00 10 21 20 00 01 21 18 00 00 09 00 00 10 21 10 00 00 01 00 87 24 00 00 A3 90 07 00 40 10 01 00 A4 24 05 00 43 14 21 28 80 00 FF FF C6 24 21 20 E0 00 F7 FF C0 54 00 00 82 90 08 00 E0 03 23 10 43 00 }
	condition:
		$1
}

rule file_697_0_0 {
	meta:
		name = "__GI_gettimeofday"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF EE 0F 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_698_0_0 {
	meta:
		name = "__syscall_rt_sigaction"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 62 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_699_1_0 {
	meta:
		name = "lckpwdf"
		size = 576
		refs = "0000 _gp_disp 0050 __pthread_mutex_unlock 0054 _pthread_cleanup_push_defer 006c __pthread_mutex_lock 0084 __GI_open 0080 $LC0 009c __GI_fcntl 00d4 __GI_sigaction 0114 __GI___sigaddset 013c __GI_sigprocmask 0154 __GI_alarm 0170 __GI_memset 01e4 __GI_close 01f8 _pthread_cleanup_pop_restore"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 28 FF BD 27 B4 00 B1 AF ?? ?? 91 8F B0 00 B0 AF 10 00 BC AF ?? ?? 30 8E FF FF 02 24 D4 00 BF AF D0 00 BE AF CC 00 B7 AF C8 00 B6 AF C4 00 B5 AF C0 00 B4 AF BC 00 B3 AF B8 00 B2 AF 71 00 02 16 ?? ?? 92 8F ?? ?? 85 8F ?? ?? 99 8F 74 00 B3 27 ?? ?? 46 26 ?? ?? ?? ?? 21 20 60 02 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? ?? ?? 44 26 10 00 BC 8F 01 00 05 24 ?? ?? 84 8F ?? ?? 99 8F ?? ?? ?? ?? ?? ?? 84 24 ?? ?? 22 AE 58 00 50 10 10 00 BC 8F ?? ?? 92 8F 21 20 40 00 21 C8 40 02 ?? ?? ?? ?? 01 00 05 24 ?? ?? 24 8E 02 00 05 24 21 C8 40 02 ?? ?? ?? ?? 01 00 46 34 10 00 BC 8F 3C 00 A5 27 58 00 B5 27 ?? ?? 82 8F ?? ?? 94 8F 21 30 A0 02 ?? ?? 42 24 3C 00 A0 AF 0E 00 04 24 18 00 A0 AC 21 C8 80 02 40 00 A2 AF 50 00 B0 AF 4C 00 B0 AF 48 00 B0 AF ?? ?? ?? ?? 44 00 B0 AF 10 00 BC 8F 84 00 B6 27 21 20 C0 02 ?? ?? 99 8F 0E 00 05 24 90 00 A0 AF 8C 00 A0 AF 88 00 A0 AF ?? ?? ?? ?? 84 00 A0 AF 10 00 BC 8F 21 28 C0 02 94 00 B7 27 ?? ?? 96 8F 21 30 E0 02 21 C8 C0 02 ?? ?? ?? ?? 02 00 04 24 10 00 BC 8F ?? ?? 9E 8F 21 C8 C0 03 ?? ?? ?? ?? 0F 00 04 24 10 00 BC 8F 18 00 A3 27 21 20 60 00 ?? ?? 99 8F 21 28 00 00 24 00 06 24 ?? ?? ?? ?? A8 00 A3 AF A8 00 A3 8F ?? ?? 24 8E 01 00 02 24 21 30 60 00 07 00 05 24 21 C8 40 02 ?? ?? ?? ?? 18 00 A2 A7 21 20 00 00 21 C8 C0 03 ?? ?? ?? ?? 21 90 40 00 03 00 04 24 21 28 E0 02 21 C8 C0 02 ?? ?? ?? ?? 21 30 00 00 0E 00 04 24 21 28 A0 02 21 C8 80 02 ?? ?? ?? ?? 21 30 00 00 06 00 41 06 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? ?? ?? 24 8E 10 00 BC 8F ?? ?? 30 AE ?? ?? 99 8F 21 20 60 02 ?? ?? ?? ?? 01 00 05 24 01 00 00 10 21 10 00 00 D4 00 BF 8F D0 00 BE 8F CC 00 B7 8F C8 00 B6 8F C4 00 B5 8F C0 00 B4 8F BC 00 B3 8F B8 00 B2 8F B4 00 B1 8F B0 00 B0 8F 08 00 E0 03 D8 00 BD 27 }
	condition:
		$1
}

rule file_699_2_0 {
	meta:
		name = "ulckpwdf"
		size = 184
		refs = "0000 _gp_disp 003c __pthread_mutex_unlock 0040 _pthread_cleanup_push_defer 0058 __pthread_mutex_lock 0068 __GI_close 0080 _pthread_cleanup_pop_restore"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 B8 FF BD 27 34 00 B0 AF ?? ?? 90 8F 3C 00 B2 AF 10 00 BC AF ?? ?? 02 8E FF FF 12 24 44 00 BF AF 40 00 B3 AF 38 00 B1 AF 18 00 52 10 ?? ?? 93 8F ?? ?? 85 8F ?? ?? 99 8F 18 00 B1 27 ?? ?? 66 26 ?? ?? ?? ?? 21 20 20 02 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? ?? ?? 64 26 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? ?? ?? 04 8E 10 00 BC 8F 28 00 A2 AF ?? ?? 12 AE ?? ?? 99 8F 21 20 20 02 ?? ?? ?? ?? 01 00 05 24 02 00 00 10 28 00 A2 8F FF FF 02 24 44 00 BF 8F 40 00 B3 8F 3C 00 B2 8F 38 00 B1 8F 34 00 B0 8F 08 00 E0 03 48 00 BD 27 }
	condition:
		$1
}

rule file_700_0_0 {
	meta:
		name = "wcsstr"
		size = 72
	strings:
		$1 = { 21 18 A0 00 21 10 80 00 00 00 67 8C 0A 00 E0 10 00 00 00 00 00 00 46 8C 03 00 E6 14 04 00 63 24 F9 FF 00 10 04 00 42 24 05 00 C0 10 04 00 84 24 F4 FF 00 10 21 18 A0 00 08 00 E0 03 21 10 80 00 08 00 E0 03 21 10 00 00 }
	condition:
		$1
}

rule file_701_0_0 {
	meta:
		name = "__GI_hdestroy_r"
		size = 92
		refs = "0000 _gp_disp 0024 __GI___errno_location 003c free"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 18 00 B0 AF 1C 00 BF AF 07 00 80 14 21 80 80 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 16 00 03 24 05 00 00 10 00 00 43 AC ?? ?? 99 8F ?? ?? ?? ?? 00 00 84 8C 00 00 00 AE 1C 00 BF 8F 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_702_0_0 {
	meta:
		name = "__GI_getmntent_r"
		size = 444
		refs = "0000 _gp_disp 0054 __GI_fgets 0098 __GI_strtok_r 0114 $LC0 013c __GI_atoi"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 C0 FF BD 27 10 00 BC AF 28 00 B2 AF 3C 00 BF AF 38 00 B6 AF 34 00 B5 AF 30 00 B4 AF 2C 00 B3 AF 24 00 B1 AF 20 00 B0 AF 03 00 80 14 21 90 80 00 55 00 00 10 21 10 00 00 FD FF A0 10 21 80 A0 00 FB FF C0 10 21 88 C0 00 ?? ?? 93 8F 21 A0 E0 00 23 00 15 24 0A 00 16 24 21 20 20 02 21 28 80 02 21 C8 60 02 ?? ?? ?? ?? 21 30 40 02 F0 FF 40 10 10 00 BC 8F 00 00 22 82 F8 FF 55 10 21 20 20 02 F7 FF 56 10 21 28 80 02 ?? ?? 93 8F ?? ?? 92 8F 18 00 B1 27 18 00 A0 AF ?? ?? 65 26 21 C8 40 02 ?? ?? ?? ?? 21 30 20 02 E1 FF 40 10 00 00 02 AE 21 20 00 00 ?? ?? 65 26 21 C8 40 02 ?? ?? ?? ?? 21 30 20 02 DA FF 40 10 04 00 02 AE 21 20 00 00 ?? ?? 65 26 21 C8 40 02 ?? ?? ?? ?? 21 30 20 02 D3 FF 40 10 08 00 02 AE 21 20 00 00 ?? ?? 65 26 21 C8 40 02 ?? ?? ?? ?? 21 30 20 02 10 00 BC 8F 04 00 40 14 0C 00 02 AE ?? ?? 82 8F ?? ?? 42 24 0C 00 02 AE 21 20 00 00 ?? ?? 65 26 21 C8 40 02 ?? ?? ?? ?? 21 30 20 02 06 00 40 10 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 40 00 03 00 00 10 10 00 02 AE 21 10 00 00 10 00 02 AE 21 20 00 00 ?? ?? 65 26 21 C8 40 02 ?? ?? ?? ?? 21 30 20 02 06 00 40 10 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 40 00 03 00 00 10 14 00 02 AE 21 10 00 00 14 00 02 AE 21 10 00 02 3C 00 BF 8F 38 00 B6 8F 34 00 B5 8F 30 00 B4 8F 2C 00 B3 8F 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 08 00 E0 03 40 00 BD 27 }
	condition:
		$1
}

rule file_702_1_0 {
	meta:
		name = "getmntent"
		size = 228
		refs = "0000 _gp_disp 0018 _pthread_cleanup_push_defer 001c __pthread_mutex_unlock 004c __pthread_mutex_lock 006c malloc 0084 __GI_abort 0098 __GI_getmntent_r 00b8 _pthread_cleanup_pop_restore"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 B8 FF BD 27 34 00 B0 AF ?? ?? 90 8F ?? ?? 99 8F ?? ?? 85 8F 38 00 B1 AF 18 00 B1 27 10 00 BC AF ?? ?? 06 26 44 00 BF AF 40 00 B3 AF 3C 00 B2 AF 21 90 80 00 ?? ?? ?? ?? 21 20 20 02 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? ?? ?? 04 26 10 00 BC 8F ?? ?? 90 8F ?? ?? 02 8E 0A 00 40 14 21 98 00 02 ?? ?? 99 8F ?? ?? ?? ?? 00 10 04 24 ?? ?? 02 AE 04 00 40 14 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 ?? ?? 85 8F ?? ?? 66 8E ?? ?? 99 8F 21 20 40 02 00 10 07 24 ?? ?? ?? ?? ?? ?? A5 24 10 00 BC 8F 21 20 20 02 28 00 A2 AF ?? ?? 99 8F ?? ?? ?? ?? 01 00 05 24 44 00 BF 8F 28 00 A2 8F 40 00 B3 8F 3C 00 B2 8F 38 00 B1 8F 34 00 B0 8F 08 00 E0 03 48 00 BD 27 }
	condition:
		$1
}

rule file_702_2_0 {
	meta:
		name = "addmntent"
		size = 156
		refs = "0000 _gp_disp 000c __GI_fseek 0058 __GI_fprintf 0044 $LC1"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F C8 FF BD 27 02 00 06 24 20 00 BC AF 30 00 B1 AF 2C 00 B0 AF 34 00 BF AF 21 80 A0 00 21 28 00 00 ?? ?? ?? ?? 21 88 80 00 12 00 40 04 20 00 BC 8F 08 00 02 8E ?? ?? 85 8F 00 00 06 8E 10 00 A2 AF 0C 00 02 8E 04 00 07 8E ?? ?? 99 8F 14 00 A2 AF 10 00 02 8E 21 20 20 02 ?? ?? A5 24 18 00 A2 AF 14 00 02 8E ?? ?? ?? ?? 1C 00 A2 AF 02 00 00 10 C2 17 02 00 01 00 02 24 34 00 BF 8F 30 00 B1 8F 2C 00 B0 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_702_5_0 {
	meta:
		name = "__GI_endmntent"
		size = 64
		refs = "0000 _gp_disp 0010 __GI_fclose"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 0A 00 80 10 ?? ?? 99 8F E0 FF BD 27 1C 00 BF AF 10 00 BC AF ?? ?? ?? ?? 00 00 00 00 1C 00 BF 8F 01 00 02 24 08 00 E0 03 20 00 BD 27 08 00 E0 03 01 00 02 24 }
	condition:
		$1
}

rule file_704_0_0 {
	meta:
		name = "fgetpos"
		size = 216
		refs = "0000 _gp_disp 0038 _pthread_cleanup_push_defer 003c __pthread_mutex_unlock 0054 __pthread_mutex_lock 0064 __GI_ftell 00a8 _pthread_cleanup_pop_restore"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 C0 FF BD 27 30 00 B1 AF 2C 00 B0 AF 10 00 BC AF 3C 00 BF AF 38 00 B3 AF 34 00 B2 AF 34 00 92 8C 21 80 80 00 0C 00 40 16 21 88 A0 00 ?? ?? 99 8F ?? ?? 85 8F 38 00 93 24 21 30 60 02 ?? ?? ?? ?? 18 00 A4 27 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 60 02 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 00 02 00 00 22 AE 09 00 40 04 10 00 BC 8F 2C 00 02 8E 04 00 22 AE 30 00 02 8E 08 00 22 AE 02 00 02 92 21 80 00 00 02 00 00 10 0C 00 22 AE FF FF 10 24 06 00 40 16 3C 00 BF 8F ?? ?? 99 8F 18 00 A4 27 ?? ?? ?? ?? 01 00 05 24 3C 00 BF 8F 21 10 00 02 38 00 B3 8F 34 00 B2 8F 30 00 B1 8F 2C 00 B0 8F 08 00 E0 03 40 00 BD 27 }
	condition:
		$1
}

rule file_705_0_0 {
	meta:
		name = "__GI_mbrtowc"
		size = 152
		refs = "0000 _gp_disp 0054 __GI_mbsnrtowcs"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 C8 FF BD 27 18 00 BC AF 30 00 B0 AF 34 00 BF AF 03 00 E0 14 21 80 80 00 ?? ?? 87 8F ?? ?? E7 24 05 00 A0 54 00 00 A3 80 28 00 A0 A3 28 00 A5 27 05 00 00 10 21 80 00 00 10 00 60 10 21 10 00 00 0F 00 C0 10 34 00 BF 8F ?? ?? 99 8F 20 00 A5 AF 10 00 A7 AF 24 00 A4 27 20 00 A5 27 FF FF 06 24 ?? ?? ?? ?? 01 00 07 24 05 00 40 04 34 00 BF 8F 03 00 00 12 24 00 A3 8F 00 00 03 AE 34 00 BF 8F 30 00 B0 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_707_0_0 {
	meta:
		name = "query_module"
		size = 100
		refs = "0000 _gp_disp 003c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 30 00 A2 8F E0 FF BD 27 10 00 A2 AF 5B 10 02 24 0C 00 00 00 20 00 BD 27 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_708_0_0 {
	meta:
		name = "closelog_intern"
		size = 160
		refs = "0000 _gp_disp 0038 __GI_close 0060 $LC0"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 83 8F D8 FF BD 27 1C 00 B0 AF 21 80 80 00 ?? ?? 64 8C 20 00 B1 AF 10 00 BC AF 21 88 60 00 FF FF 03 24 24 00 BF AF 04 00 83 10 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F FF FF 02 24 ?? ?? 22 AE ?? ?? 82 8F 0D 00 00 16 ?? ?? 40 AC ?? ?? 82 8F ?? ?? 83 8F ?? ?? 40 AC ?? ?? 82 8F ?? ?? 63 24 ?? ?? 43 AC ?? ?? 82 8F 08 00 03 24 ?? ?? 43 AC ?? ?? 82 8F FF 00 03 24 ?? ?? 43 AC 24 00 BF 8F 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_708_1_0 {
	meta:
		name = "__GI_openlog"
		size = 496
		refs = "0000 _gp_disp 0018 _pthread_cleanup_push_defer 0024 __pthread_mutex_unlock 0064 __pthread_mutex_lock 00c8 __GI_socket 00ec __GI_fcntl 0154 _pthread_cleanup_pop_restore 015c __GI_connect 018c __GI_close"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 B0 FF BD 27 38 00 B3 AF ?? ?? 93 8F ?? ?? 99 8F 3C 00 B4 AF 21 A0 A0 00 ?? ?? 85 8F 34 00 B2 AF 18 00 B2 27 10 00 BC AF 4C 00 BF AF 30 00 B1 AF 2C 00 B0 AF 48 00 B7 AF 44 00 B6 AF 40 00 B5 AF 21 88 80 00 21 80 C0 00 21 20 40 02 ?? ?? ?? ?? ?? ?? 66 26 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? ?? ?? 64 26 03 00 20 12 10 00 BC 8F ?? ?? 82 8F ?? ?? 51 AC ?? ?? 95 8F 07 00 00 12 ?? ?? B4 AE 07 FC 02 24 24 10 02 02 04 00 40 14 ?? ?? 93 8F ?? ?? 82 8F ?? ?? 50 AC ?? ?? 93 8F FF FF 02 24 ?? ?? 63 8E 21 00 62 14 01 00 10 24 ?? ?? A2 8E 08 00 42 30 1E 00 40 10 ?? ?? 64 8E ?? ?? 99 8F 01 00 04 24 21 28 00 02 ?? ?? ?? ?? 21 30 00 00 FF FF 03 24 10 00 BC 8F 33 00 43 10 ?? ?? 62 AE ?? ?? 91 8F 01 00 06 24 21 20 40 00 21 C8 20 02 ?? ?? ?? ?? 02 00 05 24 10 00 BC 8F 03 00 05 24 21 C8 20 02 ?? ?? 82 8F ?? ?? 54 8C ?? ?? ?? ?? 21 20 80 02 80 00 46 34 21 20 80 02 21 C8 20 02 ?? ?? ?? ?? 04 00 05 24 10 00 BC 8F ?? ?? 64 8E FF FF 17 24 1C 00 97 10 ?? ?? 94 8F ?? ?? 96 8F ?? ?? C2 8E 19 00 40 14 ?? ?? 99 8F ?? ?? 85 8F ?? ?? 99 8F 10 00 06 24 ?? ?? ?? ?? ?? ?? A5 24 21 88 40 00 04 00 57 10 10 00 BC 8F 01 00 02 24 0D 00 00 10 ?? ?? C2 AE ?? ?? 84 8E 05 00 82 10 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F ?? ?? 91 AE 01 00 02 24 04 00 02 16 ?? ?? 99 8F C2 FF 00 10 02 00 10 24 ?? ?? 99 8F 21 20 40 02 ?? ?? ?? ?? 01 00 05 24 4C 00 BF 8F 48 00 B7 8F 44 00 B6 8F 40 00 B5 8F 3C 00 B4 8F 38 00 B3 8F 34 00 B2 8F 30 00 B1 8F 2C 00 B0 8F 08 00 E0 03 50 00 BD 27 }
	condition:
		$1
}

rule file_708_2_0 {
	meta:
		name = "__GI_vsyslog"
		size = 1168
		refs = "0000 _gp_disp 001c __GI_sigaction 0090 __GI___errno_location 00b8 __pthread_mutex_unlock 00c0 _pthread_cleanup_push_defer 00d0 __pthread_mutex_lock 0130 __GI_openlog 0150 __GI_time 0174 __GI_ctime 0190 __GI_sprintf 018c $LC1 01b4 __GI_strlen 01d0 $LC2 01f4 __GI_strcpy 01f0 $LC3 0220 __GI_getpid 0238 $LC4 027c __GI_vsnprintf 02b8 __GI_memmove 02dc __GI_memcpy 0320 __GI_write 0390 closelog_intern 03b4 _pthread_cleanup_pop_restore 03cc __GI_open 03c8 $LC6 03e8 __GI_strchr 0428 __GI_close"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 60 FB BD 27 80 04 B2 AF ?? ?? 92 8F 7C 04 B1 AF ?? ?? 91 8F 10 00 BC AF 98 04 BE AF 18 04 B9 27 21 F0 A0 00 ?? ?? 52 26 34 04 A5 27 9C 04 BF AF 94 04 B7 AF 88 04 B4 AF 84 04 B3 AF 78 04 B0 AF 90 04 B6 AF 8C 04 B5 AF 34 04 A0 AF 21 80 80 00 08 00 A0 AC 0C 00 A0 AC 10 00 A0 AC 14 00 A0 AC 18 00 A0 AC 0D 00 04 24 68 04 B9 AF 21 B8 C0 00 21 30 20 03 21 C8 20 02 ?? ?? ?? ?? 38 04 B2 AF 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 59 8C 10 00 BC 8F 21 98 40 00 70 04 B9 AF ?? ?? 94 8F 50 04 B9 27 21 20 20 03 ?? ?? 85 8F 6C 04 B9 AF ?? ?? 99 8F ?? ?? ?? ?? ?? ?? 86 26 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? ?? ?? 84 26 10 00 BC 8F 01 00 03 24 07 00 02 32 04 10 43 00 ?? ?? 83 8F ?? ?? 63 8C 24 10 43 00 CF 00 40 10 00 FC 02 24 24 10 02 02 CC 00 40 14 ?? ?? 96 8F ?? ?? 94 8F ?? ?? C2 8E 05 00 40 04 ?? ?? 92 8F ?? ?? 82 8F ?? ?? 42 8C 09 00 40 14 F8 03 02 32 ?? ?? 45 8E ?? ?? 99 8F ?? ?? 84 8E 08 00 A5 34 ?? ?? ?? ?? 21 30 00 00 10 00 BC 8F F8 03 02 32 04 00 40 14 ?? ?? 99 8F ?? ?? 82 8F ?? ?? 42 8C 25 80 02 02 60 04 B1 27 ?? ?? ?? ?? 21 20 20 02 10 00 BC 8F 21 20 20 02 ?? ?? 99 8F ?? ?? ?? ?? 18 00 B1 27 10 00 BC 8F 21 30 00 02 21 20 20 02 ?? ?? 85 8F ?? ?? 99 8F 04 00 47 24 ?? ?? A5 24 ?? ?? ?? ?? 74 04 B9 AF ?? ?? 95 8E 10 00 BC 8F 17 00 A0 12 21 80 22 02 ?? ?? 99 8F ?? ?? ?? ?? 21 20 A0 02 C0 03 42 2C 10 00 BC 8F 09 00 40 10 21 20 00 02 ?? ?? 85 8F ?? ?? 99 8F 21 30 A0 02 ?? ?? ?? ?? ?? ?? A5 24 21 A8 02 02 09 00 00 10 10 00 BC 8F ?? ?? 85 8F ?? ?? 99 8F 18 00 15 26 ?? ?? ?? ?? ?? ?? A5 24 02 00 00 10 10 00 BC 8F 21 A8 00 02 ?? ?? 42 8E 01 00 42 30 0E 00 40 10 ?? ?? 82 8E ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F 21 20 A0 02 21 30 40 00 ?? ?? 85 8F ?? ?? 99 8F ?? ?? ?? ?? ?? ?? A5 24 10 00 BC 8F 21 A8 A2 02 ?? ?? 82 8E 05 00 40 10 3A 00 02 24 00 00 A2 A2 20 00 02 24 01 00 A2 A2 02 00 B5 26 70 04 B9 8F 17 04 B4 27 23 40 95 02 00 00 79 AE ?? ?? 99 8F 21 28 00 01 21 30 C0 03 21 38 E0 02 74 04 A8 AF ?? ?? ?? ?? 21 20 A0 02 21 B8 A2 02 2B 10 F4 02 10 00 BC 8F 2B F0 F5 02 03 00 40 10 74 04 A8 8F 18 00 C0 13 ?? ?? 42 8E ?? ?? 99 8F F4 FF 06 25 0C 00 A4 26 ?? ?? ?? ?? 21 28 A0 02 10 00 BC 8F 21 20 A0 02 0C 00 06 24 ?? ?? 85 8F ?? ?? 99 8F ?? ?? ?? ?? ?? ?? A5 24 06 00 C0 17 10 00 BC 8F 07 00 00 10 16 04 B7 27 06 00 40 10 ?? ?? 42 8E 01 00 F7 26 2B 10 F4 02 FB FF 40 54 00 00 E2 82 ?? ?? 42 8E 20 00 42 30 0B 00 40 10 ?? ?? C2 8E ?? ?? 99 8F 0A 00 02 24 23 30 F0 02 00 00 E2 A2 02 00 04 24 21 28 00 02 ?? ?? ?? ?? 01 00 C6 24 10 00 BC 8F ?? ?? C2 8E 1B 00 40 04 00 00 E0 A2 ?? ?? 95 8F 21 A0 20 02 01 00 FE 26 04 00 10 24 ?? ?? C4 8E 21 28 80 02 21 C8 A0 02 ?? ?? ?? ?? 23 30 D4 03 0A 00 41 04 10 00 BC 8F 00 00 62 8E 07 00 50 10 21 10 00 00 ?? ?? 99 8F ?? ?? 39 27 ?? ?? ?? ?? 01 00 04 24 07 00 00 10 10 00 BC 8F 21 A0 82 02 2B 10 F4 02 EE FF 40 10 ?? ?? C4 8E 22 00 00 10 ?? ?? 99 8F ?? ?? 42 8E 02 00 42 30 1E 00 40 10 ?? ?? 99 8F ?? ?? 84 8F ?? ?? 99 8F 01 08 05 24 ?? ?? ?? ?? ?? ?? 84 24 21 80 40 00 15 00 40 04 10 00 BC 8F ?? ?? 99 8F 21 20 20 02 ?? ?? ?? ?? 3E 00 05 24 10 00 BC 8F 01 00 45 24 0D 00 02 24 ?? ?? 99 8F 23 30 E5 02 00 00 E2 A2 0A 00 02 24 21 20 00 02 02 00 C6 24 ?? ?? ?? ?? 01 00 E2 A2 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 00 02 10 00 BC 8F ?? ?? 99 8F 50 04 A4 27 ?? ?? ?? ?? 01 00 05 24 10 00 BC 8F 18 04 A5 27 0D 00 04 24 ?? ?? 99 8F ?? ?? ?? ?? 21 30 00 00 9C 04 BF 8F 98 04 BE 8F 94 04 B7 8F 90 04 B6 8F 8C 04 B5 8F 88 04 B4 8F 84 04 B3 8F 80 04 B2 8F 7C 04 B1 8F 78 04 B0 8F 08 00 E0 03 A0 04 BD 27 }
	condition:
		$1
}

rule file_708_4_0 {
	meta:
		name = "__GI_closelog"
		size = 136
		refs = "0000 _gp_disp 0018 __pthread_mutex_unlock 001c _pthread_cleanup_push_defer 0040 __pthread_mutex_lock 0058 closelog_intern 0068 _pthread_cleanup_pop_restore"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 C8 FF BD 27 30 00 B1 AF ?? ?? 91 8F ?? ?? 85 8F ?? ?? 99 8F 2C 00 B0 AF 18 00 B0 27 34 00 BF AF ?? ?? 26 26 10 00 BC AF ?? ?? ?? ?? 21 20 00 02 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? ?? ?? 24 26 10 00 BC 8F ?? ?? 99 8F ?? ?? 39 27 ?? ?? ?? ?? 21 20 00 00 10 00 BC 8F 21 20 00 02 ?? ?? 99 8F ?? ?? ?? ?? 01 00 05 24 34 00 BF 8F 30 00 B1 8F 2C 00 B0 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_708_5_0 {
	meta:
		name = "setlogmask"
		size = 164
		refs = "0000 _gp_disp 0040 __pthread_mutex_unlock 0044 _pthread_cleanup_push_defer 005c __pthread_mutex_lock 0074 _pthread_cleanup_pop_restore"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 C0 FF BD 27 2C 00 B1 AF ?? ?? 91 8F 10 00 BC AF 38 00 B4 AF 30 00 B2 AF 3C 00 BF AF 34 00 B3 AF 28 00 B0 AF 21 90 80 00 12 00 80 10 ?? ?? 34 8E ?? ?? 93 8F ?? ?? 85 8F ?? ?? 99 8F 18 00 B0 27 ?? ?? 66 26 ?? ?? ?? ?? 21 20 00 02 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? ?? ?? 64 26 10 00 BC 8F ?? ?? 32 AE 21 20 00 02 ?? ?? 99 8F ?? ?? ?? ?? 01 00 05 24 3C 00 BF 8F 21 10 80 02 34 00 B3 8F 38 00 B4 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 E0 03 40 00 BD 27 }
	condition:
		$1
}

rule file_709_0_0 {
	meta:
		name = "__libc_sigsuspend"
		size = 88
		refs = "0000 _gp_disp 0030 __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 10 00 05 24 67 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_710_0_0 {
	meta:
		name = "__GI_strlcat"
		size = 88
	strings:
		$1 = { F0 FF BD 27 21 10 00 00 2B 18 46 00 03 00 60 54 00 00 83 80 06 00 00 10 08 00 A4 27 05 00 60 50 00 00 A3 80 01 00 84 24 F7 FF 00 10 01 00 42 24 00 00 A3 80 06 00 60 10 00 00 83 A0 01 00 42 24 2B 18 46 00 21 20 83 00 F9 FF 00 10 01 00 A5 24 08 00 E0 03 10 00 BD 27 }
	condition:
		$1
}

rule file_712_0_0 {
	meta:
		name = "__GI_xdr_authunix_parms"
		size = 212
		refs = "0000 _gp_disp 000c __GI_xdr_u_long 0044 __GI_xdr_string 0060 __GI_xdr_u_int 0094 __GI_xdr_array"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F D0 FF BD 27 18 00 BC AF 24 00 B1 AF 20 00 B0 AF 2C 00 BF AF 28 00 B2 AF 21 88 80 00 ?? ?? ?? ?? 21 80 A0 00 03 00 40 14 18 00 BC 8F 1F 00 00 10 21 10 00 00 ?? ?? 99 8F 21 20 20 02 04 00 05 26 ?? ?? ?? ?? FF 00 06 24 F8 FF 40 10 18 00 BC 8F ?? ?? 92 8F 21 20 20 02 21 C8 40 02 ?? ?? ?? ?? 08 00 05 26 11 00 40 10 21 10 00 00 21 20 20 02 21 C8 40 02 ?? ?? ?? ?? 0C 00 05 26 EB FF 40 10 18 00 BC 8F ?? ?? 99 8F 04 00 02 24 10 00 A2 AF 14 00 B2 AF 21 20 20 02 14 00 05 26 10 00 06 26 ?? ?? ?? ?? 10 00 07 24 2B 10 02 00 2C 00 BF 8F 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_713_1_0 {
	meta:
		name = "ntohs"
		size = 24
		altNames = "htons"
	strings:
		$1 = { FF FF 84 30 00 12 04 00 FF FF 42 30 02 22 04 00 08 00 E0 03 25 10 44 00 }
	condition:
		$1
}

rule file_714_0_0 {
	meta:
		name = "mbstowcs"
		size = 60
		refs = "0000 _gp_disp 000c __GI_mbsrtowcs"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F D0 FF BD 27 18 00 A7 27 2C 00 BF AF 10 00 BC AF 20 00 A5 AF 18 00 A0 AF ?? ?? ?? ?? 20 00 A5 27 2C 00 BF 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_715_0_0 {
	meta:
		name = "wmemcmp"
		size = 64
	strings:
		$1 = { 08 00 C0 10 00 00 00 00 00 00 83 8C 00 00 A2 8C 06 00 62 14 04 00 84 24 04 00 A5 24 F8 FF 00 10 FF FF C6 24 08 00 E0 03 21 10 00 00 2B 18 62 00 01 00 04 24 FF FF 02 24 08 00 E0 03 0A 10 83 00 }
	condition:
		$1
}

rule file_716_0_0 {
	meta:
		name = "on_exit"
		size = 100
		refs = "0000 _gp_disp 000c __new_exitfn"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F D8 FF BD 27 20 00 B1 AF 1C 00 B0 AF 10 00 BC AF 24 00 BF AF 21 80 80 00 ?? ?? ?? ?? 21 88 A0 00 06 00 40 10 02 00 03 24 04 00 50 AC 08 00 51 AC 00 00 43 AC 02 00 00 10 21 10 00 00 FF FF 02 24 24 00 BF 8F 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_717_0_0 {
	meta:
		name = "__GI_vfwprintf"
		size = 244
		refs = "0000 _gp_disp 0040 _pthread_cleanup_push_defer 0044 __pthread_mutex_unlock 005c __pthread_mutex_lock 007c __stdio_trans2w_o 0080 _vfwprintf_internal 00bc _pthread_cleanup_pop_restore"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 B8 FF BD 27 40 00 B4 AF 3C 00 B3 AF 30 00 B0 AF 10 00 BC AF 44 00 BF AF 38 00 B2 AF 34 00 B1 AF 34 00 91 8C 21 80 80 00 21 98 A0 00 0C 00 20 16 21 A0 C0 00 ?? ?? 99 8F ?? ?? 85 8F 38 00 92 24 21 30 40 02 ?? ?? ?? ?? 18 00 A4 27 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 40 02 10 00 BC 8F 00 00 03 96 40 08 02 24 40 08 63 30 08 00 62 14 ?? ?? 99 8F ?? ?? 99 8F 21 20 00 02 21 28 60 02 ?? ?? ?? ?? 21 30 80 02 07 00 00 10 10 00 BC 8F 21 20 00 02 ?? ?? ?? ?? 00 08 05 24 F5 FF 40 10 10 00 BC 8F FF FF 02 24 08 00 20 16 44 00 BF 8F ?? ?? 99 8F 28 00 A2 AF 18 00 A4 27 ?? ?? ?? ?? 01 00 05 24 28 00 A2 8F 44 00 BF 8F 40 00 B4 8F 3C 00 B3 8F 38 00 B2 8F 34 00 B1 8F 30 00 B0 8F 08 00 E0 03 48 00 BD 27 }
	condition:
		$1
}

rule file_719_0_0 {
	meta:
		name = "__GI_setsid"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF E2 0F 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_720_0_0 {
	meta:
		name = "__encode_dotted"
		size = 296
		refs = "0000 _gp_disp 0014 __GI_strlen 0064 __GI_strchr 00b4 __GI_memcpy"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 C0 FF BD 27 34 00 B7 AF ?? ?? 97 8F 38 00 BE AF 2C 00 B5 AF 28 00 B4 AF 20 00 B2 AF 18 00 B0 AF 10 00 BC AF 3C 00 BF AF 30 00 B6 AF 24 00 B3 AF 1C 00 B1 AF 21 80 80 00 21 A0 A0 00 21 A8 C0 00 21 90 00 00 FF FF DE 24 24 00 00 12 00 00 00 00 00 00 02 82 21 00 40 10 ?? ?? 99 8F 21 20 00 02 ?? ?? ?? ?? 2E 00 05 24 21 98 40 00 03 00 40 10 10 00 BC 8F 06 00 00 10 23 88 50 00 21 C8 E0 02 ?? ?? ?? ?? 21 20 00 02 10 00 BC 8F 21 88 40 00 03 00 20 56 23 10 D2 03 14 00 00 10 FF FF 02 24 2B 10 22 02 FC FF 40 10 ?? ?? 99 8F 01 00 56 26 21 90 92 02 00 00 51 A2 21 20 96 02 21 28 00 02 ?? ?? ?? ?? 21 30 20 02 21 90 36 02 03 00 60 12 10 00 BC 8F DC FF 00 10 01 00 70 26 EE FF A0 1A 21 A0 92 02 00 00 80 A2 01 00 42 26 3C 00 BF 8F 38 00 BE 8F 34 00 B7 8F 30 00 B6 8F 2C 00 B5 8F 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 40 00 BD 27 }
	condition:
		$1
}

rule file_721_0_0 {
	meta:
		name = "__GI_gethostbyname"
		size = 104
		refs = "0000 _gp_disp 000c __GI___h_errno_location 003c __GI_gethostbyname_r"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F C8 FF BD 27 34 00 BF AF 18 00 BC AF 28 00 A4 AF ?? ?? ?? ?? 00 00 00 00 18 00 BC 8F 28 00 A4 8F 20 00 A3 27 ?? ?? 85 8F ?? ?? 86 8F ?? ?? 99 8F 10 00 A3 AF 14 00 A2 AF ?? ?? A5 24 ?? ?? C6 24 ?? ?? ?? ?? CC 01 07 24 34 00 BF 8F 20 00 A2 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_722_0_0 {
	meta:
		name = "__fpending"
		size = 36
	strings:
		$1 = { 00 00 83 94 40 00 63 30 04 00 60 10 21 10 00 00 10 00 83 8C 08 00 82 8C 23 10 62 00 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_723_0_0 {
	meta:
		name = "clearerr"
		size = 148
		refs = "0000 _gp_disp 0030 _pthread_cleanup_push_defer 0034 __pthread_mutex_unlock 004c __pthread_mutex_lock 006c _pthread_cleanup_pop_restore"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 C8 FF BD 27 28 00 B0 AF 10 00 BC AF 34 00 BF AF 30 00 B2 AF 2C 00 B1 AF 34 00 91 8C 0C 00 20 16 21 80 80 00 ?? ?? 99 8F ?? ?? 85 8F 38 00 92 24 21 30 40 02 ?? ?? ?? ?? 18 00 A4 27 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 40 02 10 00 BC 8F 00 00 02 96 F3 FF 42 30 05 00 20 16 00 00 02 A6 ?? ?? 99 8F 18 00 A4 27 ?? ?? ?? ?? 01 00 05 24 34 00 BF 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_724_1_0 {
	meta:
		name = "cfgetispeed"
		size = 32
	strings:
		$1 = { 00 00 82 8C 04 00 40 04 00 00 00 00 08 00 82 8C 08 00 E0 03 0F 10 42 30 08 00 E0 03 21 10 00 00 }
	condition:
		$1
}

rule file_724_2_0 {
	meta:
		name = "__GI_cfsetospeed"
		size = 116
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 F0 EF 02 24 24 10 A2 00 11 00 40 50 08 00 82 8C FF EF A2 24 0F 00 42 2C 0D 00 40 54 08 00 82 8C ?? ?? 99 8F E0 FF BD 27 1C 00 BF AF 10 00 BC AF ?? ?? ?? ?? 00 00 00 00 16 00 03 24 00 00 43 AC 1C 00 BF 8F FF FF 02 24 08 00 E0 03 20 00 BD 27 F0 EF 03 24 24 10 62 00 25 28 A2 00 08 00 85 AC 08 00 E0 03 21 10 00 00 }
	condition:
		$1
}

rule file_724_3_0 {
	meta:
		name = "__GI_cfsetispeed"
		size = 152
		refs = "0000 _gp_disp 0028 __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 F0 EF 02 24 24 10 A2 00 10 00 40 10 FF EF A2 24 0F 00 42 2C 14 00 40 54 00 00 82 8C ?? ?? 99 8F E0 FF BD 27 1C 00 BF AF 10 00 BC AF ?? ?? ?? ?? 00 00 00 00 16 00 03 24 00 00 43 AC 1C 00 BF 8F FF FF 02 24 08 00 E0 03 20 00 BD 27 06 00 A0 54 00 00 82 8C 00 00 83 8C 00 80 02 3C 25 10 62 00 08 00 00 10 00 00 82 AC F0 EF 03 24 00 F0 42 7C 00 00 82 AC 08 00 82 8C 24 10 62 00 25 28 A2 00 08 00 85 AC 08 00 E0 03 21 10 00 00 }
	condition:
		$1
}

rule file_725_0_0 {
	meta:
		name = "getrusage"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF ED 0F 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_726_0_0 {
	meta:
		name = "__GI_sbrk"
		size = 136
		refs = "0000 _gp_disp 0014 __curbrk 0040 __GI_brk"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D8 FF BD 27 1C 00 B0 AF ?? ?? 90 8F 20 00 B1 AF 10 00 BC AF 24 00 BF AF 00 00 02 8E 05 00 40 10 21 88 80 00 0A 00 20 56 00 00 10 8E 0E 00 00 10 00 00 02 8E ?? ?? 99 8F ?? ?? ?? ?? 21 20 00 00 F8 FF 41 04 10 00 BC 8F 07 00 00 10 FF FF 02 24 ?? ?? 99 8F ?? ?? ?? ?? 21 20 11 02 02 00 40 04 FF FF 02 24 21 10 00 02 24 00 BF 8F 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_727_0_0 {
	meta:
		name = "llabs"
		size = 32
	strings:
		$1 = { C3 37 05 00 26 20 C4 00 23 10 86 00 26 28 C5 00 2B 20 82 00 23 30 A6 00 08 00 E0 03 23 18 C4 00 }
	condition:
		$1
}

rule file_729_0_0 {
	meta:
		name = "__GI_localeconv"
		size = 116
		refs = "0000 _gp_disp"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F ?? ?? 83 8F ?? ?? 86 8F ?? ?? 85 8F ?? ?? 42 24 ?? ?? 62 AC ?? ?? 63 24 21 10 60 00 ?? ?? C6 24 ?? ?? A5 24 04 00 63 24 2B 20 65 00 FD FF 80 14 00 00 66 AC ?? ?? 83 8F ?? ?? 85 8F 7F 00 06 24 ?? ?? 63 24 ?? ?? A5 24 00 00 66 A0 01 00 63 24 2B 20 A3 00 FD FF 80 50 00 00 66 A0 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_730_0_0 {
	meta:
		name = "__GI_vsscanf"
		size = 172
		refs = "0000 _gp_disp 0014 __stdio_init_mutex 0060 __GI_strlen 007c __GI_vfscanf"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 88 FF BD 27 FE FF 02 24 ?? ?? 99 8F 1C 00 A2 AF A1 00 02 24 18 00 A2 A7 01 00 02 24 74 00 BF AF 70 00 B0 AF 10 00 BC AF 21 80 80 00 68 00 A5 AF 6C 00 A6 AF 4C 00 A2 AF 1A 00 A0 A3 44 00 A0 AF ?? ?? ?? ?? 50 00 A4 27 10 00 BC 8F 28 00 B0 AF 20 00 B0 AF ?? ?? 99 8F 21 20 00 02 ?? ?? ?? ?? 38 00 A0 AF 10 00 BC 8F 68 00 A5 8F 6C 00 A6 8F ?? ?? 99 8F 21 10 02 02 34 00 B0 AF 18 00 A4 27 24 00 A2 AF 2C 00 A2 AF ?? ?? ?? ?? 30 00 A2 AF 74 00 BF 8F 70 00 B0 8F 08 00 E0 03 78 00 BD 27 }
	condition:
		$1
}

rule file_731_0_0 {
	meta:
		name = "gmtime"
		size = 60
		refs = "0000 _gp_disp 000c __time_tm 0010 _time_t2tm"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 86 8F ?? ?? 99 8F E0 FF BD 27 1C 00 BF AF 10 00 BC AF ?? ?? ?? ?? 21 28 00 00 10 00 BC 8F 1C 00 BF 8F 20 00 BD 27 08 00 E0 03 ?? ?? 82 8F }
	condition:
		$1
}

rule file_732_0_0 {
	meta:
		name = "fpathconf"
		size = 316
		refs = "0000 _gp_disp 0024 __GI___errno_location 009c __libc_fstatfs 00d8 __GI_fstat"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 38 FF BD 27 10 00 BC AF C4 00 BF AF C0 00 B1 AF BC 00 B0 AF 05 00 81 04 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 12 00 00 10 09 00 03 24 3B 00 A0 10 7F 00 02 24 FF FF A5 24 13 00 A2 2C 08 00 40 10 80 28 05 00 ?? ?? 82 8F ?? ?? 42 24 21 28 45 00 00 00 A2 8C 21 10 5C 00 08 00 40 00 00 00 00 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 16 00 03 24 27 00 00 10 00 00 43 AC ?? ?? 99 8F ?? ?? ?? ?? B0 00 A4 AF 10 00 BC 8F B0 00 A4 8F 18 00 A5 27 ?? ?? 99 8F 21 80 40 00 ?? ?? ?? ?? 00 00 51 8C 1E 00 43 04 40 00 A2 8F 00 00 04 8E 59 00 03 24 1A 00 83 14 FF FF 02 24 00 00 11 AE 17 00 00 10 FF 00 02 24 15 00 00 10 21 10 00 00 ?? ?? 99 8F ?? ?? ?? ?? 18 00 A5 27 0D 00 40 04 2C 00 A3 8F 00 80 02 34 00 F0 63 30 05 00 62 10 00 60 63 38 01 00 02 24 FF FF 04 24 08 00 00 10 0B 10 83 00 06 00 00 10 01 00 02 24 04 00 00 10 20 00 02 24 02 00 00 10 FF FF 02 24 00 10 02 24 C4 00 BF 8F C0 00 B1 8F BC 00 B0 8F 08 00 E0 03 C8 00 BD 27 }
	condition:
		$1
}

rule file_733_0_0 {
	meta:
		name = "gaih_inet_serv.isra.0"
		size = 312
		refs = "0000 _gp_disp 0020 __GI_getservbyname_r"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 98 FF BD 27 60 00 BE AF 21 F0 A0 03 30 00 D9 27 54 00 B5 AF ?? ?? 95 8F 38 00 D9 AF 20 00 D9 27 5C 00 B7 AF 58 00 B6 AF 50 00 B4 AF 4C 00 B3 AF 48 00 B2 AF 44 00 B1 AF 40 00 B0 AF 64 00 BF AF 18 00 BC AF 21 B8 80 00 21 88 A0 00 21 B0 C0 00 21 80 E0 00 00 04 12 24 03 00 B3 24 3C 00 D9 AF 22 00 14 24 0E 00 42 26 C2 10 02 00 C0 10 02 00 23 E8 A2 03 30 00 C2 27 10 00 B2 AF 14 00 A2 AF 21 20 E0 02 21 28 60 02 20 00 C6 27 21 C8 A0 02 ?? ?? ?? ?? 18 00 A7 27 06 00 40 14 00 00 00 00 30 00 C2 8F 14 00 40 50 08 01 02 24 05 00 00 10 00 00 00 AE 0F 00 54 14 40 90 12 00 EA FF 00 10 0E 00 42 26 00 00 23 82 04 00 03 AE 02 00 23 92 02 00 63 30 02 00 60 50 01 00 23 82 00 00 C3 8E 08 00 03 AE 08 00 42 8C 0C 00 02 AE 02 00 00 10 21 10 00 00 08 01 02 24 21 E8 C0 03 64 00 BF 8F 60 00 BE 8F 5C 00 B7 8F 58 00 B6 8F 54 00 B5 8F 50 00 B4 8F 4C 00 B3 8F 48 00 B2 8F 44 00 B1 8F 40 00 B0 8F 08 00 E0 03 68 00 BD 27 }
	condition:
		$1
}

rule file_733_1_0 {
	meta:
		name = "gaih_inet"
		size = 2068
		refs = "0000 _gp_disp 014c gaih_inet_serv.isra.0 02fc __GI_inet_pton 037c __GI_gethostbyname2_r 0430 __GI___h_errno_location 0478 __GI_memcpy 059c __GI_inet_ntop 05c0 __GI_strlen 05f0 malloc 0648 __GI_gethostbyaddr_r 0674 __GI___errno_location 0764 __GI_memset 0794 __GI_strcpy"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 28 FF BD 27 D0 00 BE AF CC 00 B7 AF C8 00 B6 AF C0 00 B4 AF BC 00 B3 AF B4 00 B1 AF D4 00 BF AF C4 00 B5 AF B8 00 B2 AF B0 00 B0 AF 20 00 BC AF 04 00 C2 8C 21 F0 A0 03 6C 00 D3 27 21 88 80 00 21 A0 A0 00 21 B8 C0 00 21 B0 E0 00 88 00 D3 AF 04 00 40 10 84 00 C0 AF 0A 00 04 24 03 00 44 14 21 90 00 00 00 00 F2 8E C0 00 52 7E 0C 00 E4 8E 6C 00 C0 AF 08 00 E6 8E 04 00 60 AE 08 00 60 AE 06 00 80 14 0C 00 60 AE 05 00 C0 54 ?? ?? 82 8F ?? ?? 82 8F 16 00 00 10 ?? ?? 42 24 ?? ?? 82 8F ?? ?? 42 24 03 00 45 80 C8 01 A0 50 07 01 02 24 06 00 C0 10 00 00 00 00 00 00 45 80 03 00 C5 10 00 00 00 00 F7 FF 00 10 07 00 42 24 08 00 80 10 00 00 00 00 02 00 45 90 02 00 A5 30 04 00 A0 14 00 00 00 00 01 00 45 80 EE FF 85 54 07 00 42 24 5D 00 80 12 00 00 00 00 02 00 47 90 01 00 E5 30 03 00 A0 50 04 00 86 8E B2 01 00 10 08 01 02 24 46 00 C3 04 00 00 49 80 03 00 44 80 0E 00 80 10 ?? ?? 89 8F ?? ?? 99 8F E8 FF BD 27 00 00 84 8E 20 00 A7 27 88 00 C7 AF 21 28 40 00 ?? ?? 39 27 ?? ?? ?? ?? 0C 00 E6 26 68 00 40 10 20 00 DC 8F A1 01 00 10 21 E8 C0 03 07 00 50 24 88 00 C3 27 0C 00 E8 26 03 00 02 82 2C 00 40 10 88 00 C2 8F 02 00 04 92 01 00 82 30 FA FF 40 54 07 00 10 26 08 00 E2 8E 05 00 40 50 0C 00 E2 8E 00 00 05 82 F4 FF 45 54 07 00 10 26 0C 00 E2 8E 06 00 40 10 02 00 84 30 05 00 80 54 00 00 84 8E 01 00 04 82 EC FF 44 54 07 00 10 26 00 00 84 8E E8 FF BD 27 20 00 B5 27 21 30 00 01 ?? ?? 39 25 A0 00 C3 AF A4 00 C8 AF A8 00 C9 AF 21 28 00 02 ?? ?? ?? ?? 21 38 A0 02 20 00 DC 8F A0 00 C3 8F A4 00 C8 8F 06 00 40 10 A8 00 C9 8F 00 01 44 30 D9 FF 80 14 07 00 10 26 74 01 00 10 21 E8 C0 03 00 00 75 AC 21 18 A0 02 D3 FF 00 10 07 00 10 26 33 00 53 14 08 01 02 24 6C 01 00 10 21 E8 C0 03 E8 FF BD 27 20 00 A5 27 02 00 E7 30 88 00 C5 AF 00 00 A0 AC 02 00 E0 14 04 00 A9 AC 01 00 44 80 00 12 06 00 00 FF 42 30 00 3A C6 7C 25 30 46 00 08 00 A4 AC 22 00 00 10 0C 00 A6 AC 04 00 C0 54 00 00 46 80 0E 00 80 50 07 00 42 24 00 00 46 80 E8 FF BD 27 20 00 A5 27 04 00 A6 AC 02 00 46 90 88 00 C5 AF 02 00 C6 30 02 00 C0 14 00 00 A0 AC 01 00 44 80 08 00 A4 AC 11 00 00 10 0C 00 A0 AC 88 00 C5 27 03 00 44 80 0D 00 80 10 00 00 00 00 00 00 46 80 E8 FF BD 27 20 00 A4 27 24 00 A6 AF 01 00 46 80 20 00 A0 AF 2C 00 A0 AF 28 00 A6 AF 07 00 42 24 00 00 A4 AC F2 FF 00 10 21 28 80 00 7A 00 20 12 ?? ?? 99 8F D8 FF BD 27 20 00 B0 27 84 00 D0 AF 04 00 00 AE 18 00 00 AE 00 00 00 AE 02 00 04 24 21 28 20 02 ?? ?? ?? ?? 08 00 06 26 0A 00 40 18 20 00 DC 8F 04 00 E2 8E FD FF 04 24 24 10 82 00 04 00 40 50 02 00 02 24 26 01 40 12 06 00 02 24 02 00 02 24 04 00 02 AE 04 00 02 8E 5D 00 40 14 84 00 C2 8F 00 00 E2 8E 04 00 44 30 59 00 80 54 84 00 C2 8F 04 00 E4 8E 02 00 05 24 0A 00 85 10 ?? ?? 95 8F 05 00 40 56 10 00 42 30 07 00 80 10 7C 00 D9 27 4F 00 00 10 84 00 C2 8F 4D 00 40 10 84 00 C2 8F ?? ?? 95 8F 7C 00 D9 27 00 02 10 24 90 00 D9 AF 58 00 D3 27 28 00 D4 27 22 00 12 24 40 80 10 00 0E 00 02 26 C2 10 02 00 C0 10 02 00 23 E8 A2 03 7C 00 C2 27 10 00 B0 AF 14 00 A2 AF 18 00 B3 AF 21 20 20 02 02 00 05 24 21 30 80 02 21 C8 A0 02 ?? ?? ?? ?? 20 00 A7 27 07 00 52 14 20 00 DC 8F 58 00 C4 8F FF FF 02 24 ED FF 82 50 40 80 10 00 05 00 00 10 58 00 D0 8F 0A 00 40 10 7C 00 C2 8F 58 00 D0 8F FF FF 02 24 29 00 02 56 84 00 C2 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 9D 00 00 10 00 00 50 AC 21 00 40 10 21 88 00 00 84 00 D0 27 02 00 12 24 7C 00 C4 8F 80 10 11 00 10 00 84 8C 21 20 82 00 00 00 84 8C 19 00 80 50 84 00 C2 8F 00 00 04 8E 06 00 80 14 ?? ?? 99 8F D8 FF BD 27 20 00 A4 27 00 00 04 AE 38 00 A0 AF 00 00 04 8E 04 00 06 24 00 00 80 AC 00 00 04 8E 01 00 31 26 04 00 92 AC 7C 00 C5 8F 00 00 04 8E 10 00 A5 8C 08 00 84 24 21 10 A2 00 ?? ?? ?? ?? 00 00 45 8C 20 00 DC 8F E3 FF 00 10 00 00 10 8E 84 00 C2 8F 04 00 44 8C C2 00 80 10 02 01 02 24 23 00 00 10 00 00 00 00 D8 FF BD 27 20 00 A2 27 00 00 40 AC 04 00 40 AC 08 00 40 AC 0C 00 40 AC 10 00 40 AC 14 00 40 AC 18 00 40 AC 04 00 E4 8E 0B 00 80 14 84 00 C2 AF D8 FF BD 27 20 00 A4 27 00 00 44 AC 20 00 A0 AF 24 00 A0 AF 28 00 A0 AF 2C 00 A0 AF 30 00 A0 AF 34 00 A0 AF 38 00 A0 AF 04 00 E4 8E FD FF 05 24 24 20 A4 00 08 00 80 14 02 00 04 24 04 00 44 AC 00 00 E4 8E 01 00 84 30 03 00 80 14 00 01 04 3C 7F 00 84 24 08 00 44 AC 98 00 C0 12 58 00 D9 27 94 00 D9 AF 80 00 D9 27 98 00 D9 AF 7C 00 D9 27 84 00 D0 8F 21 88 00 00 1A 00 00 10 9C 00 D9 AF 09 00 40 54 00 00 51 8C ?? ?? 99 8F 04 00 04 8E 21 28 40 02 28 00 C6 27 ?? ?? ?? ?? 2E 00 07 24 20 00 DC 8F 21 88 40 00 45 00 20 12 ?? ?? 99 8F ?? ?? ?? ?? 21 20 20 02 20 00 DC 8F 01 00 42 24 88 00 D3 8F 08 00 19 26 30 00 54 24 02 00 12 24 10 00 15 24 90 00 D9 AF 3B 00 60 16 ?? ?? 99 8F 00 00 10 8E 79 00 00 12 21 10 00 00 00 00 E2 8E 02 00 42 30 F2 FF 40 10 21 10 00 00 80 00 C0 AF 00 02 11 24 08 00 12 26 40 88 11 00 0E 00 22 26 C2 10 02 00 C0 10 02 00 23 E8 A2 03 04 00 06 8E 20 00 A2 27 7C 00 D9 27 10 00 A2 AF 1C 00 B9 AF 80 00 C2 27 ?? ?? 99 8F 0A 00 C7 38 18 00 A2 AF 04 00 05 24 10 00 02 24 0A 28 47 00 21 20 40 02 58 00 C7 27 ?? ?? ?? ?? 14 00 B1 AF 20 00 DC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 A0 40 00 00 00 42 8C 0D 00 82 12 20 00 DC 8F C1 FF 80 12 80 00 C2 8F 7C 00 D1 8F FF FF 02 24 BD FF 22 56 80 00 C2 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 51 AC 4A 00 00 10 0B 00 02 24 7C 00 C4 8F FF FF 02 24 D6 FF 82 50 40 88 11 00 EF FF 00 10 00 00 00 00 42 00 00 10 02 01 02 24 ?? ?? ?? ?? 21 20 80 02 20 00 DC 8F 37 00 40 10 00 00 C2 AE 00 00 E4 8E ?? ?? 99 8F 90 00 C5 8F 00 00 44 AC 00 00 C2 8E 04 00 06 24 04 00 52 AC 00 00 C2 8E 04 00 64 8E 08 00 44 AC 00 00 C2 8E 08 00 64 8E 0C 00 44 AC 00 00 C2 8E 10 00 55 AC 00 00 C2 8E 20 00 44 24 14 00 44 AC 00 00 C2 8E 14 00 42 8C 00 00 52 A4 00 00 C2 8E 14 00 49 8C 04 00 24 25 ?? ?? ?? ?? A8 00 C9 AF 20 00 DC 8F A8 00 C9 8F 0C 00 62 8E ?? ?? 99 8F 08 00 24 25 02 00 22 A5 21 28 00 00 ?? ?? ?? ?? 08 00 06 24 20 00 DC 8F 0A 00 20 12 00 00 C2 8E 30 00 44 24 18 00 44 AC 00 00 C2 8E ?? ?? 99 8F 21 28 20 02 ?? ?? ?? ?? 18 00 44 8C 02 00 00 10 20 00 DC 8F 18 00 40 AC 00 00 C2 8E 1C 00 40 AC 00 00 C8 8E 00 00 73 8E 8A FF 00 10 1C 00 16 25 05 00 00 10 0A 00 02 24 03 00 00 10 21 10 00 00 08 01 03 24 0A 10 66 00 21 E8 C0 03 D4 00 BF 8F D0 00 BE 8F CC 00 B7 8F C8 00 B6 8F C4 00 B5 8F C0 00 B4 8F BC 00 B3 8F B8 00 B2 8F B4 00 B1 8F B0 00 B0 8F 08 00 E0 03 D8 00 BD 27 }
	condition:
		$1
}

rule file_733_2_0 {
	meta:
		name = "__GI_freeaddrinfo"
		size = 72
		refs = "0000 _gp_disp 0020 free"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 06 00 80 10 ?? ?? 99 8F ?? ?? ?? ?? 1C 00 90 8C 10 00 BC 8F FA FF 00 10 21 20 00 02 1C 00 BF 8F 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_733_3_0 {
	meta:
		name = "__GI_getaddrinfo"
		size = 852
		refs = "0000 _gp_disp 00a0 __GI_memset 00fc __GI_strtoul 01b4 __GI___errno_location 01e4 __GI_socket 0214 __GI_close 028c __GI_freeaddrinfo"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 80 FF BD 27 10 00 BC AF 6C 00 B5 AF 64 00 B3 AF 5C 00 B1 AF 58 00 B0 AF 7C 00 BF AF 78 00 BE AF 74 00 B7 AF 70 00 B6 AF 68 00 B4 AF 60 00 B2 AF 21 80 80 00 21 88 A0 00 21 A8 C0 00 21 98 E0 00 07 00 80 10 44 00 A0 AF 00 00 83 80 2A 00 02 24 03 00 62 14 00 00 00 00 01 00 82 80 0A 80 02 00 06 00 20 12 2A 00 02 24 00 00 23 82 03 00 62 14 00 00 00 00 01 00 22 82 0A 88 02 00 03 00 00 16 00 00 00 00 A4 00 20 12 FE FF 02 24 0A 00 A0 56 00 00 A2 8E ?? ?? 99 8F 18 00 B2 27 21 20 40 02 21 28 00 00 ?? ?? ?? ?? 20 00 06 24 10 00 BC 8F 21 A8 40 02 00 00 A2 8E C0 FB 03 24 24 18 43 00 95 00 60 54 FF FF 02 24 02 00 42 30 03 00 40 10 00 00 00 00 90 00 00 12 FF FF 02 24 1E 00 20 52 48 00 A0 AF 00 00 22 82 1B 00 40 10 48 00 A0 AF ?? ?? 99 8F 38 00 B1 AF 21 20 20 02 40 00 A5 27 ?? ?? ?? ?? 0A 00 06 24 3C 00 A2 AF 40 00 A2 8F 00 00 42 80 08 00 40 10 10 00 BC 8F 00 00 A3 8E 00 04 63 30 7C 00 60 14 FE FF 02 24 FF FF 02 24 07 00 00 10 3C 00 A2 AF 08 00 A2 8E 05 00 40 14 38 00 B9 27 0C 00 A3 8E 73 00 60 10 F8 FF 02 24 38 00 B9 27 48 00 B9 AF ?? ?? 83 8F 44 00 B2 27 0A 90 13 00 21 F0 00 00 ?? ?? 77 24 21 88 00 00 21 A0 00 00 04 00 E2 8E 53 00 40 10 00 00 00 00 04 00 A2 8E 00 00 E4 8E 04 00 44 50 00 00 A2 8E F8 FF 40 54 08 00 F7 26 00 00 A2 8E 20 00 42 30 23 00 40 50 01 00 94 26 ?? ?? 99 8F FF FF 84 30 ?? ?? ?? ?? 50 00 A4 AF 00 00 59 8C 50 00 A4 8F 21 48 40 00 02 00 02 24 10 00 BC 8F 4C 00 B9 AF 13 00 82 10 01 00 16 24 ?? ?? 99 8F 50 00 A9 AF 01 00 05 24 ?? ?? ?? ?? 21 30 00 00 10 00 BC 8F 05 00 41 04 50 00 A9 8F 00 00 36 8D 18 00 D6 3A 07 00 00 10 01 00 D6 2E ?? ?? 99 8F 50 00 A9 AF ?? ?? ?? ?? 21 20 40 00 10 00 BC 8F 50 00 A9 8F 4C 00 B9 8F 24 00 C0 12 00 00 39 AD 01 00 94 26 04 00 C0 13 04 00 F9 8E 04 00 C2 8F CD FF 59 50 08 00 F7 26 48 00 A5 8F 21 20 00 02 21 30 A0 02 09 F8 20 03 21 38 40 02 21 B0 40 00 0F 00 40 10 10 00 BC 8F 04 00 A2 8E 03 00 40 14 00 01 C2 32 13 00 40 14 21 F0 E0 02 44 00 A4 8F 03 00 80 10 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 FF FE 02 24 24 10 C2 02 20 00 00 10 23 10 02 00 06 00 40 12 21 F0 E0 02 00 00 42 8E 03 00 40 10 21 F0 E0 02 FC FF 00 10 1C 00 52 24 AE FF 00 10 08 00 F7 26 AC FF 00 10 21 88 C0 02 12 00 80 12 44 00 A2 8F 04 00 40 10 00 00 00 00 00 00 62 AE 0E 00 00 10 21 10 00 00 05 00 60 16 00 00 00 00 05 00 20 16 21 10 00 00 09 00 00 10 7C 00 BF 8F 06 00 20 52 FE FF 02 24 FF FE 02 24 24 88 22 02 02 00 00 10 23 10 11 00 FA FF 02 24 7C 00 BF 8F 78 00 BE 8F 74 00 B7 8F 70 00 B6 8F 6C 00 B5 8F 68 00 B4 8F 64 00 B3 8F 60 00 B2 8F 5C 00 B1 8F 58 00 B0 8F 08 00 E0 03 80 00 BD 27 }
	condition:
		$1
}

rule file_735_0_0 {
	meta:
		name = "__GI_ftell"
		size = 84
		refs = "0000 _gp_disp 000c __GI_ftello64 0030 __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F E0 FF BD 27 10 00 BC AF 1C 00 BF AF ?? ?? ?? ?? 00 00 00 00 C3 27 02 00 07 00 83 10 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 4F 00 03 24 00 00 43 AC FF FF 02 24 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_736_0_0 {
	meta:
		name = "__raise"
		size = 72
		refs = "0000 _gp_disp 000c __GI_getpid 0034 __GI_kill"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF ?? ?? ?? ?? 21 80 80 00 10 00 BC 8F 1C 00 BF 8F 21 28 00 02 ?? ?? 99 8F 18 00 B0 8F 21 20 40 00 ?? ?? ?? ?? 20 00 BD 27 }
	condition:
		$1
}

rule file_6_3_2 {
	meta:
		name = "__GI_pthread_exit"
		size = 36
		refs = "0000 _gp_disp 000c __pthread_do_exit"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F E0 FF BD 27 10 00 BC AF 1C 00 BF AF ?? ?? ?? ?? 21 28 A0 03 }
	condition:
		$1
}

rule file_737_0_0 {
	meta:
		name = "__GI_tsearch"
		size = 184
		refs = "0000 _gp_disp 0074 malloc"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D8 FF BD 27 10 00 BC AF 20 00 B2 AF 1C 00 B1 AF 18 00 B0 AF 24 00 BF AF 21 88 80 00 21 80 A0 00 1B 00 A0 10 21 90 C0 00 00 00 02 8E 0E 00 40 10 21 C8 40 02 00 00 45 8C 09 F8 20 03 21 20 20 02 03 00 40 14 10 00 BC 8F 12 00 00 10 00 00 02 8E 00 00 03 8E 00 00 42 28 04 00 70 24 08 00 63 24 F1 FF 00 10 0A 80 62 00 ?? ?? 99 8F ?? ?? ?? ?? 0C 00 04 24 07 00 40 50 21 10 00 00 00 00 02 AE 00 00 51 AC 08 00 40 AC 02 00 00 10 04 00 40 AC 21 10 00 00 24 00 BF 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_738_0_0 {
	meta:
		name = "__GI_wcsspn"
		size = 48
	strings:
		$1 = { 21 10 80 00 21 18 A0 00 00 00 66 8C 06 00 C0 50 23 10 44 00 00 00 47 8C FB FF C7 14 04 00 63 24 F8 FF 00 10 04 00 42 24 08 00 E0 03 83 10 02 00 }
	condition:
		$1
}

rule file_739_0_0 {
	meta:
		name = "__GI___dl_iterate_phdr"
		size = 164
		refs = "0000 _gp_disp 000c _dl_loaded_modules"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F C0 FF BD 27 38 00 B3 AF 34 00 B2 AF 30 00 B1 AF 10 00 BC AF 3C 00 BF AF 2C 00 B0 AF 00 00 50 8C 21 90 80 00 21 98 A0 00 21 10 00 00 18 00 B1 27 11 00 00 12 21 20 20 02 00 00 02 8E 10 00 05 24 18 00 A2 AF 04 00 02 8E 21 30 60 02 21 C8 40 02 1C 00 A2 AF E0 00 02 8E 20 00 A2 AF DC 00 02 8E 09 F8 20 03 24 00 A2 A7 04 00 40 14 3C 00 BF 8F EF FF 00 10 0C 00 10 8E 3C 00 BF 8F 38 00 B3 8F 34 00 B2 8F 30 00 B1 8F 2C 00 B0 8F 08 00 E0 03 40 00 BD 27 }
	condition:
		$1
}

rule file_739_1_0 {
	meta:
		name = "dl_iterate_phdr"
		size = 148
		refs = "0000 _gp_disp 000c _dl_phnum 0034 $LC0 0048 _dl_phdr 0070 __GI___dl_iterate_phdr"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F C8 FF BD 27 30 00 B1 AF 2C 00 B0 AF 10 00 BC AF 34 00 BF AF 00 00 42 8C 21 88 80 00 10 00 40 10 21 80 A0 00 ?? ?? 83 8F 18 00 A0 AF 24 00 A2 A7 ?? ?? 63 24 1C 00 A3 AF ?? ?? 83 8F 18 00 A4 27 10 00 05 24 00 00 63 8C 21 30 00 02 21 C8 20 02 09 F8 20 03 20 00 A3 AF 05 00 40 14 10 00 BC 8F ?? ?? 99 8F 21 20 20 02 ?? ?? ?? ?? 21 28 00 02 34 00 BF 8F 30 00 B1 8F 2C 00 B0 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_741_0_0 {
	meta:
		name = "__GI_strncpy"
		size = 220
	strings:
		$1 = { 21 10 80 00 FF FF 83 24 04 00 C4 2C 23 00 80 54 03 00 C6 30 82 20 06 00 00 00 A9 80 21 40 A0 00 21 38 60 00 15 00 20 11 01 00 69 A0 01 00 A9 80 03 00 20 15 02 00 69 A0 11 00 00 10 02 00 63 24 02 00 A9 80 03 00 20 15 03 00 69 A0 0C 00 00 10 03 00 63 24 03 00 08 81 04 00 A5 24 04 00 63 24 07 00 00 11 04 00 E8 A0 FF FF 84 24 EB FF 80 54 00 00 A9 80 09 00 00 10 03 00 C6 30 01 00 63 24 FF FF C6 24 23 20 43 00 21 30 C4 00 0E 00 C0 14 01 00 63 24 08 00 E0 03 00 00 00 00 0D 00 C0 10 00 00 00 00 00 00 A4 80 01 00 63 24 FF FF C6 24 01 00 A7 24 F7 FF C0 10 00 00 64 A0 F9 FF 80 14 21 28 E0 00 01 00 63 24 FF FF C6 24 FD FF C0 14 00 00 60 A0 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_744_0_0 {
	meta:
		name = "__GI_hsearch_r"
		size = 556
		refs = "0000 _gp_disp 000c __GI_strlen 00c0 __GI_strcmp 017c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F B0 FF BD 27 10 00 BC AF 44 00 B7 AF 3C 00 B5 AF 34 00 B3 AF 30 00 B2 AF 4C 00 BF AF 48 00 BE AF 40 00 B6 AF 38 00 B4 AF 2C 00 B1 AF 28 00 B0 AF 50 00 A4 AF 54 00 A5 AF 21 B8 C0 00 21 98 E0 00 60 00 B2 8F ?? ?? ?? ?? 21 A8 80 00 10 00 BC 8F 21 18 40 00 07 00 60 10 FF FF 64 24 21 18 A4 02 00 00 63 80 00 11 02 00 21 10 62 00 F9 FF 00 10 21 18 80 00 04 00 54 8E 01 00 10 24 0C 00 11 24 1B 00 54 00 F4 01 80 02 00 00 56 8E 10 18 00 00 0B 80 63 00 02 10 11 72 21 88 56 00 00 00 22 8E 30 00 40 50 21 88 00 02 08 00 50 14 FE FF 9E 26 ?? ?? 99 8F 04 00 25 8E ?? ?? ?? ?? 21 20 A0 02 41 00 40 10 10 00 BC 8F FE FF 9E 26 1B 00 1E 02 F4 01 C0 03 ?? ?? 99 8F 21 88 00 02 0C 00 07 24 10 10 00 00 01 00 5E 24 23 30 9E 02 2B 18 D1 03 21 10 26 02 23 88 3E 02 0A 88 43 00 19 00 30 12 02 10 27 72 21 18 56 00 00 00 62 8C 11 00 50 14 21 20 A0 02 04 00 65 8C 18 00 A3 AF 1C 00 A6 AF 20 00 A7 AF 09 F8 20 03 24 00 B9 AF 10 00 BC 8F 18 00 A3 8F 1C 00 A6 8F 20 00 A7 8F EB FF 40 14 24 00 B9 8F 04 00 63 24 00 00 63 AE 27 00 00 10 01 00 02 24 E6 FF 40 14 2B 18 D1 03 02 00 00 10 01 00 02 24 01 00 02 24 1A 00 E2 16 ?? ?? 99 8F 08 00 42 8E 06 00 54 54 0C 00 02 24 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 15 00 00 10 0C 00 03 24 02 88 22 72 50 00 A3 8F 21 B0 D1 02 00 00 D0 AE 00 00 42 8E 21 10 51 00 04 00 43 AC 54 00 A3 8F 08 00 43 AC 08 00 42 8E 01 00 42 24 08 00 42 AE 00 00 42 8E 21 88 51 00 04 00 31 26 DF FF 00 10 00 00 71 AE ?? ?? ?? ?? 00 00 00 00 03 00 03 24 00 00 43 AC 00 00 60 AE 21 10 00 00 4C 00 BF 8F 48 00 BE 8F 44 00 B7 8F 40 00 B6 8F 3C 00 B5 8F 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 E0 03 50 00 BD 27 }
	condition:
		$1
}

rule file_745_0_0 {
	meta:
		name = "__GI_localtime_r"
		size = 188
		refs = "0000 _gp_disp 0010 _time_tzlock 0014 _pthread_cleanup_push_defer 0020 __pthread_mutex_unlock 004c __pthread_mutex_lock 0064 _time_tzset 007c _time_tzinfo 0080 __time_localtime_tzi 0094 _pthread_cleanup_pop_restore"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 C8 FF BD 27 ?? ?? 86 8F ?? ?? 99 8F 28 00 B0 AF 21 80 A0 00 ?? ?? 85 8F 2C 00 B1 AF 18 00 B1 27 34 00 BF AF 30 00 B2 AF 10 00 BC AF 21 90 80 00 ?? ?? ?? ?? 21 20 20 02 10 00 BC 8F ?? ?? 84 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F 00 00 44 8E 98 45 02 3C ?? ?? 99 8F 00 4F 42 24 ?? ?? ?? ?? 2A 20 82 00 10 00 BC 8F 21 20 40 02 ?? ?? 86 8F ?? ?? 99 8F ?? ?? ?? ?? 21 28 00 02 10 00 BC 8F 21 20 20 02 ?? ?? 99 8F ?? ?? ?? ?? 01 00 05 24 34 00 BF 8F 21 10 00 02 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_746_0_0 {
	meta:
		name = "fchown"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF FF 0F 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_747_0_0 {
	meta:
		name = "__GI_wcswidth"
		size = 124
	strings:
		$1 = { 21 10 00 00 2B 18 45 00 09 00 60 10 80 18 02 00 21 18 83 00 00 00 63 8C 05 00 60 10 7F 00 66 30 14 00 66 54 FF FF 02 24 F6 FF 00 10 01 00 42 24 21 10 00 00 0F 00 A0 10 00 00 00 00 00 00 83 8C 0C 00 60 10 04 00 86 24 E0 FF 64 24 E0 00 84 2C 07 00 80 10 81 FF 63 24 21 00 63 2C 04 00 60 14 FF FF A5 24 01 00 42 24 F2 FF 00 10 21 20 C0 00 FF FF 02 24 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_748_0_0 {
	meta:
		name = "__GI_fopen"
		size = 28
		refs = "0000 _gp_disp 000c _stdio_fopen"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F 21 30 00 00 ?? ?? ?? ?? FF FF 07 24 }
	condition:
		$1
}

rule file_749_0_0 {
	meta:
		name = "__GI_memmove"
		size = 748
		refs = "0000 _gp_disp 0030 __GI_memcpy"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 23 18 85 00 2B 18 66 00 10 00 BC AF 18 00 B0 AF 1C 00 BF AF 21 80 80 00 06 00 60 14 21 38 C0 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 A7 00 00 10 1C 00 BF 8F 10 00 C2 2C 21 28 A6 00 9B 00 40 14 21 18 86 00 03 00 66 30 23 10 E6 00 06 00 C0 10 FF FF C6 24 FF FF A5 24 00 00 A4 90 FF FF 63 24 FA FF 00 10 00 00 64 A0 03 00 AA 30 4B 00 40 15 82 48 02 00 07 00 24 31 FF FF 84 24 07 00 86 2C 27 00 C0 10 21 50 20 01 ?? ?? 86 8F 80 20 04 00 ?? ?? C6 24 21 20 C4 00 00 00 84 8C 21 20 9C 00 08 00 80 00 00 00 00 00 F8 FF A8 24 FC FF 67 24 FC FF A6 8C 30 00 00 10 06 00 2A 25 F4 FF A8 24 F8 FF 67 24 FC FF A4 8C 29 00 00 10 05 00 2A 25 F0 FF A8 24 F4 FF 67 24 FC FF A6 8C 22 00 00 10 04 00 2A 25 EC FF A8 24 F0 FF 67 24 FC FF A4 8C 1B 00 00 10 03 00 2A 25 E8 FF A8 24 EC FF 67 24 FC FF A6 8C 14 00 00 10 02 00 2A 25 E4 FF A8 24 E8 FF 67 24 FC FF A4 8C 0D 00 00 10 01 00 2A 25 E0 FF A8 24 E4 FF 67 24 07 00 00 10 FC FF A6 8C FC FF A4 8C DC FF A8 24 E0 FF 67 24 FF FF 2A 25 1C 00 06 8D 1C 00 E4 AC 18 00 04 8D 18 00 E6 AC 14 00 06 8D 14 00 E4 AC 10 00 04 8D 10 00 E6 AC 0C 00 06 8D 0C 00 E4 AC 08 00 04 8D 08 00 E6 AC 04 00 06 8D 04 00 E4 AC F8 FF 4A 25 00 00 04 8D 04 00 40 11 00 00 E6 AC E0 FF 08 25 EC FF 00 10 E0 FF E7 24 40 00 00 10 FC FF E4 AC C0 50 0A 00 20 00 0B 24 FC FF 07 24 03 00 24 31 02 00 06 24 23 58 6A 01 0B 00 86 10 24 38 A7 00 03 00 06 24 0E 00 86 10 F4 FF E6 24 01 00 06 24 10 00 86 10 F0 FF E6 24 F4 FF 68 24 00 00 ED 8C 16 00 00 10 FC FF EF 8C F8 FF E6 24 FC FF 68 24 00 00 EE 8C FC FF EC 8C 1A 00 00 10 02 00 29 25 F8 FF 68 24 00 00 EF 8C FC FF EE 8C 10 00 00 10 01 00 29 25 00 00 EC 8C FC FF ED 8C EC FF E6 24 F0 FF 68 24 FF FF 29 25 04 60 6C 01 06 20 4D 01 25 60 84 01 0C 00 CF 8C 0C 00 0C AD 04 68 6D 01 06 20 4F 01 25 68 A4 01 08 00 CE 8C 08 00 0D AD 04 78 6F 01 06 20 4E 01 25 78 E4 01 04 00 CC 8C 04 00 0F AD 04 70 6E 01 06 20 4C 01 25 70 C4 01 FC FF 29 25 00 00 CD 8C 04 00 20 11 00 00 0E AD F0 FF C6 24 E8 FF 00 10 F0 FF 08 25 06 50 4D 01 04 58 6C 01 25 50 4B 01 FC FF 0A AD FC FF 04 24 24 20 44 00 23 28 A4 00 23 18 64 00 03 00 47 30 06 00 E0 10 FF FF A5 24 00 00 A2 90 FF FF 63 24 FF FF E7 24 FA FF 00 10 00 00 62 A0 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_750_0_0 {
	meta:
		name = "srandom"
		size = 152
		refs = "0000 _gp_disp 0018 __pthread_mutex_unlock 001c _pthread_cleanup_push_defer 0048 __pthread_mutex_lock 0060 __GI_srandom_r 0074 _pthread_cleanup_pop_restore"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 C8 FF BD 27 2C 00 B1 AF ?? ?? 91 8F ?? ?? 85 8F ?? ?? 99 8F 28 00 B0 AF 18 00 B0 27 34 00 BF AF ?? ?? 26 26 30 00 B2 AF 10 00 BC AF 21 90 80 00 ?? ?? ?? ?? 21 20 00 02 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? ?? ?? 24 26 10 00 BC 8F 21 20 40 02 ?? ?? 85 8F ?? ?? 99 8F ?? ?? ?? ?? ?? ?? A5 24 10 00 BC 8F 21 20 00 02 ?? ?? 99 8F ?? ?? ?? ?? 01 00 05 24 34 00 BF 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_750_1_0 {
	meta:
		name = "initstate"
		size = 192
		refs = "0000 _gp_disp 001c _pthread_cleanup_push_defer 0024 __pthread_mutex_unlock 0058 __pthread_mutex_lock 0074 __GI_initstate_r 0090 _pthread_cleanup_pop_restore"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 C0 FF BD 27 2C 00 B1 AF ?? ?? 91 8F 34 00 B3 AF ?? ?? 99 8F 21 98 A0 00 ?? ?? 85 8F 28 00 B0 AF 18 00 B0 27 3C 00 BF AF 38 00 B4 AF 30 00 B2 AF 10 00 BC AF 21 A0 80 00 21 90 C0 00 21 20 00 02 ?? ?? ?? ?? ?? ?? 26 26 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? ?? ?? 24 26 10 00 BC 8F 21 30 40 02 21 20 80 02 ?? ?? 87 8F ?? ?? 99 8F 21 28 60 02 ?? ?? E7 24 ?? ?? ?? ?? 08 00 F1 8C 10 00 BC 8F 21 20 00 02 ?? ?? 99 8F ?? ?? ?? ?? 01 00 05 24 3C 00 BF 8F FC FF 22 26 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 E0 03 40 00 BD 27 }
	condition:
		$1
}

rule file_750_2_0 {
	meta:
		name = "setstate"
		size = 172
		refs = "0000 _gp_disp 0018 __pthread_mutex_unlock 001c _pthread_cleanup_push_defer 0048 __pthread_mutex_lock 0060 __GI_setstate_r 007c _pthread_cleanup_pop_restore"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 C8 FF BD 27 28 00 B0 AF ?? ?? 90 8F ?? ?? 85 8F ?? ?? 99 8F 2C 00 B1 AF 18 00 B1 27 34 00 BF AF ?? ?? 06 26 30 00 B2 AF 10 00 BC AF 21 90 80 00 ?? ?? ?? ?? 21 20 20 02 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? ?? ?? 04 26 10 00 BC 8F 21 20 40 02 ?? ?? 85 8F ?? ?? 99 8F ?? ?? A5 24 ?? ?? ?? ?? 08 00 B0 8C 10 00 BC 8F 00 00 42 28 21 20 20 02 ?? ?? 99 8F 01 00 05 24 FC FF 10 26 ?? ?? ?? ?? 0B 80 02 00 34 00 BF 8F 21 10 00 02 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_750_3_0 {
	meta:
		name = "__GI_random"
		size = 144
		refs = "0000 _gp_disp 0018 __pthread_mutex_unlock 001c _pthread_cleanup_push_defer 0040 __pthread_mutex_lock 0058 __GI_random_r 006c _pthread_cleanup_pop_restore"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 C0 FF BD 27 38 00 B1 AF ?? ?? 91 8F ?? ?? 85 8F ?? ?? 99 8F 34 00 B0 AF 18 00 B0 27 3C 00 BF AF ?? ?? 26 26 10 00 BC AF ?? ?? ?? ?? 21 20 00 02 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? ?? ?? 24 26 10 00 BC 8F 28 00 A5 27 ?? ?? 84 8F ?? ?? 99 8F ?? ?? ?? ?? ?? ?? 84 24 10 00 BC 8F 21 20 00 02 ?? ?? 99 8F ?? ?? ?? ?? 01 00 05 24 3C 00 BF 8F 28 00 A2 8F 38 00 B1 8F 34 00 B0 8F 08 00 E0 03 40 00 BD 27 }
	condition:
		$1
}

rule file_751_0_0 {
	meta:
		name = "__GI_getpriority"
		size = 100
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 00 10 02 24 0C 00 00 00 07 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC 04 00 00 10 FF FF 10 24 02 00 40 04 14 00 02 24 23 80 50 00 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_753_0_0 {
	meta:
		name = "__GI_mknod"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF AE 0F 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_754_0_0 {
	meta:
		name = "__add_to_environ"
		size = 576
		refs = "0000 _gp_disp 000c __GI_strchrnul 0064 _pthread_cleanup_push_defer 0068 __pthread_mutex_unlock 0080 __pthread_mutex_lock 0094 __environ 00a0 __GI_strncmp 00f0 _pthread_cleanup_pop_restore 0104 realloc 0138 __GI_memcpy 0168 __GI_strlen 0180 malloc 0198 __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F A8 FF BD 27 54 00 BF AF 10 00 BC AF 4C 00 B7 AF 48 00 B6 AF 44 00 B5 AF 40 00 B4 AF 3C 00 B3 AF 38 00 B2 AF 34 00 B1 AF 30 00 B0 AF 50 00 BE AF 21 A0 A0 00 3D 00 05 24 21 88 80 00 ?? ?? ?? ?? 21 B8 C0 00 10 00 BC 8F 18 00 B5 27 21 20 A0 02 ?? ?? 90 8F ?? ?? 99 8F ?? ?? 85 8F ?? ?? 06 26 ?? ?? ?? ?? 23 90 51 00 10 00 BC 8F ?? ?? 04 26 ?? ?? 99 8F ?? ?? ?? ?? 21 98 00 00 10 00 BC 8F 3D 00 03 24 ?? ?? 96 8F 00 00 D0 8E 18 00 00 12 ?? ?? 99 8F 00 00 1E 8E 15 00 C0 13 21 20 C0 03 2C 00 A3 AF 28 00 B9 AF 21 28 20 02 09 F8 20 03 21 30 40 02 10 00 BC 8F 2C 00 A3 8F 09 00 40 14 28 00 B9 8F 21 F0 D2 03 00 00 C2 83 06 00 43 54 01 00 73 26 1F 00 E0 16 21 98 00 00 44 00 00 10 ?? ?? 99 8F 01 00 73 26 EA FF 00 10 04 00 10 26 ?? ?? 9E 8F ?? ?? 99 8F 02 00 70 26 ?? ?? D7 8F 80 80 10 00 21 28 00 02 ?? ?? ?? ?? 21 20 E0 02 21 18 40 00 1C 00 40 10 10 00 BC 8F 00 00 C5 8E 07 00 B7 10 F8 FF 10 26 ?? ?? 99 8F 21 20 40 00 ?? ?? ?? ?? 21 30 00 02 10 00 BC 8F 21 18 40 00 21 80 70 00 00 00 C3 AE ?? ?? C3 AF 00 00 00 AE 04 00 00 AE 23 00 80 12 ?? ?? 99 8F 21 20 80 02 ?? ?? ?? ?? 01 00 57 26 10 00 BC 8F 01 00 56 24 ?? ?? 99 8F ?? ?? ?? ?? 21 20 D7 02 21 98 40 00 08 00 40 14 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? FF FF 13 24 0C 00 03 24 10 00 BC 8F 13 00 00 10 00 00 43 AC ?? ?? 99 8F 21 28 20 02 21 30 40 02 ?? ?? ?? ?? 21 20 40 00 10 00 BC 8F 3D 00 02 24 21 90 72 02 ?? ?? 99 8F 00 00 42 A2 21 20 77 02 21 28 80 02 ?? ?? ?? ?? 21 30 C0 02 10 00 BC 8F 21 88 60 02 00 00 11 AE 21 98 00 00 ?? ?? 99 8F 21 20 A0 02 ?? ?? ?? ?? 01 00 05 24 54 00 BF 8F 21 10 60 02 50 00 BE 8F 4C 00 B7 8F 48 00 B6 8F 44 00 B5 8F 40 00 B4 8F 3C 00 B3 8F 38 00 B2 8F 34 00 B1 8F 30 00 B0 8F 08 00 E0 03 58 00 BD 27 }
	condition:
		$1
}

rule file_754_2_0 {
	meta:
		name = "__GI_unsetenv"
		size = 348
		refs = "0000 _gp_disp 0044 __GI_strchrnul 0060 __GI___errno_location 0080 _pthread_cleanup_push_defer 0084 __pthread_mutex_unlock 00a0 __pthread_mutex_lock 00b0 __environ 00bc __GI_strncmp 00c0 _pthread_cleanup_pop_restore"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 B8 FF BD 27 10 00 BC AF 2C 00 B1 AF 44 00 BF AF 40 00 B6 AF 3C 00 B5 AF 38 00 B4 AF 34 00 B3 AF 30 00 B2 AF 28 00 B0 AF 0A 00 80 10 21 88 80 00 00 00 82 80 07 00 40 10 ?? ?? 99 8F ?? ?? ?? ?? 3D 00 05 24 00 00 44 80 3D 00 03 24 08 00 83 14 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 16 00 03 24 00 00 43 AC 2F 00 00 10 FF FF 02 24 ?? ?? 90 8F ?? ?? 99 8F ?? ?? 85 8F 18 00 B3 27 ?? ?? 06 26 21 20 60 02 ?? ?? ?? ?? 23 A0 51 00 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? ?? ?? 04 26 10 00 BC 8F ?? ?? 82 8F 00 00 50 8C 07 00 00 16 ?? ?? 95 8F ?? ?? 99 8F 21 20 60 02 ?? ?? ?? ?? 01 00 05 24 18 00 00 10 21 10 00 00 3D 00 16 24 00 00 12 8E F7 FF 40 12 21 20 40 02 21 28 20 02 21 C8 A0 02 ?? ?? ?? ?? 21 30 80 02 0C 00 40 14 10 00 BC 8F 21 90 54 02 00 00 42 82 F4 FF 56 54 04 00 10 26 21 18 00 02 04 00 62 8C 04 00 63 24 FD FF 40 14 FC FF 62 AC EE FF 00 10 00 00 12 8E EB FF 00 10 04 00 10 26 44 00 BF 8F 40 00 B6 8F 3C 00 B5 8F 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 E0 03 48 00 BD 27 }
	condition:
		$1
}

rule file_754_3_0 {
	meta:
		name = "clearenv"
		size = 152
		refs = "0000 _gp_disp 0018 __pthread_mutex_unlock 001c _pthread_cleanup_push_defer 0040 __pthread_mutex_lock 0054 free 006c __environ 0070 _pthread_cleanup_pop_restore"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 C8 FF BD 27 30 00 B1 AF ?? ?? 91 8F ?? ?? 85 8F ?? ?? 99 8F 2C 00 B0 AF 18 00 B0 27 34 00 BF AF ?? ?? 26 26 10 00 BC AF ?? ?? ?? ?? 21 20 00 02 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? ?? ?? 24 26 10 00 BC 8F ?? ?? 91 8F ?? ?? 99 8F ?? ?? ?? ?? ?? ?? 24 8E 10 00 BC 8F 21 20 00 02 ?? ?? 20 AE ?? ?? 82 8F ?? ?? 99 8F 01 00 05 24 ?? ?? ?? ?? 00 00 40 AC 34 00 BF 8F 30 00 B1 8F 2C 00 B0 8F 21 10 00 00 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_754_4_0 {
	meta:
		name = "putenv"
		size = 108
		refs = "0000 _gp_disp 000c __GI_strchr 0050 __add_to_environ 0060 __GI_unsetenv"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F E0 FF BD 27 3D 00 05 24 10 00 BC AF 18 00 B0 AF 1C 00 BF AF ?? ?? ?? ?? 21 80 80 00 10 00 BC 8F 09 00 40 10 21 20 00 02 ?? ?? 99 8F 1C 00 BF 8F 18 00 B0 8F 21 28 00 00 01 00 06 24 ?? ?? 39 27 ?? ?? ?? ?? 20 00 BD 27 1C 00 BF 8F 18 00 B0 8F ?? ?? 99 8F ?? ?? ?? ?? 20 00 BD 27 }
	condition:
		$1
}

rule file_755_0_0 {
	meta:
		name = "__GI_ppoll"
		size = 128
		refs = "0000 _gp_disp 0058 __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D8 FF BD 27 10 00 BC AF 24 00 BF AF 20 00 B0 AF 06 00 C0 50 21 30 00 00 00 00 C2 8C 18 00 A2 AF 04 00 C2 8C 18 00 A6 27 1C 00 A2 AF 10 00 02 24 E0 FF BD 27 10 00 A2 AF CE 10 02 24 0C 00 00 00 20 00 BD 27 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 24 00 BF 8F 21 10 00 02 20 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_757_0_0 {
	meta:
		name = "getrlimit64"
		size = 172
		refs = "0000 _gp_disp 000c __GI_getrlimit"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F D8 FF BD 27 20 00 B0 AF 10 00 BC AF 24 00 BF AF 21 80 A0 00 ?? ?? ?? ?? 18 00 A5 27 1A 00 40 04 18 00 A2 8F FF 7F 03 3C FF FF 63 34 07 00 43 54 00 00 02 AE FF 7F 03 3C FF FF 02 24 FF FF 63 34 00 00 02 AE 02 00 00 10 04 00 03 AE 04 00 00 AE 1C 00 A2 8F FF 7F 03 3C FF FF 63 34 07 00 43 54 08 00 02 AE FF 7F 03 3C FF FF 02 24 FF FF 63 34 08 00 02 AE 02 00 00 10 0C 00 03 AE 0C 00 00 AE 02 00 00 10 21 10 00 00 FF FF 02 24 24 00 BF 8F 20 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_758_0_0 {
	meta:
		name = "__GI_execvp"
		size = 704
		refs = "0000 _gp_disp 004c __GI___errno_location 0060 __GI_strchr 0078 __environ 007c __GI_execve 00dc __GI_memcpy 0104 $LC0 0124 __GI_getenv 0120 $LC1 0144 __GI_strlen 01c0 __GI_strchrnul"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 B8 FF BD 27 40 00 BE AF 20 00 B0 AF 44 00 BF AF 3C 00 B7 AF 38 00 B6 AF 34 00 B5 AF 30 00 B4 AF 2C 00 B3 AF 28 00 B2 AF 24 00 B1 AF 10 00 BC AF 00 00 82 80 21 F0 A0 03 06 00 40 14 21 80 80 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 49 00 00 10 02 00 03 24 ?? ?? 99 8F 21 88 A0 00 ?? ?? ?? ?? 2F 00 05 24 2B 00 40 10 10 00 DC 8F ?? ?? 82 8F ?? ?? 99 8F 21 20 00 02 00 00 46 8C ?? ?? ?? ?? 21 28 20 02 10 00 DC 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 43 8C 08 00 02 24 77 00 62 14 10 00 DC 8F 21 10 00 00 80 30 02 00 21 18 26 02 00 00 63 8C FC FF 60 14 01 00 42 24 16 00 C2 24 C2 10 02 00 C0 10 02 00 23 E8 A2 03 00 00 22 8E ?? ?? 99 8F 18 00 A4 27 04 00 25 26 10 00 A2 AF ?? ?? ?? ?? 14 00 B0 AF 10 00 DC 8F 10 00 B2 27 21 28 40 02 ?? ?? 82 8F ?? ?? 84 8F ?? ?? 99 8F 00 00 46 8C ?? ?? ?? ?? ?? ?? 84 24 5C 00 00 10 21 E8 C0 03 ?? ?? 84 8F ?? ?? 99 8F ?? ?? ?? ?? ?? ?? 84 24 21 A8 40 00 06 00 40 10 10 00 DC 8F 00 00 42 80 06 00 40 54 ?? ?? 99 8F C1 FF 00 10 ?? ?? 99 8F ?? ?? 83 8F ?? ?? 75 24 ?? ?? 99 8F ?? ?? ?? ?? 21 20 00 02 FF 0F 44 2C 07 00 80 14 10 00 DC 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 4E 00 03 24 41 00 00 10 00 00 43 AC F8 EF BD 27 FE 0F 13 24 ?? ?? 99 8F 23 98 62 02 10 00 B2 27 21 90 53 02 21 28 00 02 21 20 40 02 ?? ?? ?? ?? 01 00 46 24 10 00 DC 8F 21 80 00 00 08 00 17 24 ?? ?? 94 8F ?? ?? 99 8F 21 20 A0 02 ?? ?? ?? ?? 3A 00 05 24 21 B0 40 00 2B 10 A2 02 16 00 40 10 10 00 DC 8F FF FF C2 82 23 38 D5 02 2F 00 42 38 2B 10 02 00 21 38 E2 00 2B 10 67 02 1D 00 40 54 00 00 C2 82 ?? ?? 99 8F 23 80 47 02 21 30 E0 00 18 00 C7 AF 21 20 00 02 ?? ?? ?? ?? 21 28 A0 02 18 00 C7 8F 2F 00 02 24 10 00 DC 8F 21 38 07 02 02 00 00 10 FF FF E2 A0 21 80 40 02 ?? ?? 99 8F 00 00 86 8E 21 20 00 02 ?? ?? ?? ?? 21 28 20 02 10 00 DC 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 42 8C 93 FF 57 10 10 00 DC 8F 01 00 10 24 00 00 C2 82 D3 FF 40 14 01 00 D5 26 BE FF 00 12 ?? ?? 99 8F 02 00 00 10 21 E8 C0 03 21 E8 C0 03 44 00 BF 8F 40 00 BE 8F 3C 00 B7 8F 38 00 B6 8F 34 00 B5 8F 30 00 B4 8F 2C 00 B3 8F 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F FF FF 02 24 08 00 E0 03 48 00 BD 27 }
	condition:
		$1
}

rule file_759_0_0 {
	meta:
		name = "__GI_stpcpy"
		size = 32
	strings:
		$1 = { 00 00 A3 80 21 10 80 00 01 00 A5 24 01 00 84 24 FB FF 60 14 00 00 43 A0 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_760_0_0 {
	meta:
		name = "__GI___res_query"
		size = 304
		refs = "0000 _gp_disp 0044 __GI_memset 0048 __GI___h_errno_location 0088 __dns_lookup 00c8 free 00e0 __GI_memcpy"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 A0 FF BD 27 10 00 BC AF 4C 00 B1 AF 48 00 B0 AF 5C 00 BF AF 58 00 B4 AF 54 00 B3 AF 50 00 B2 AF 21 80 80 00 70 00 B1 8F 04 00 80 10 40 00 A0 AF 01 00 02 24 07 00 A2 10 ?? ?? 99 8F ?? ?? 99 8F ?? ?? ?? ?? FF FF 10 24 03 00 03 24 2C 00 00 10 00 00 43 AC 18 00 B3 27 21 90 C0 00 21 20 60 02 21 28 00 00 28 00 06 24 ?? ?? ?? ?? 21 A0 E0 00 10 00 BC 8F 21 20 00 02 21 28 40 02 ?? ?? 99 8F 40 00 A6 27 ?? ?? ?? ?? 21 38 60 02 21 80 40 00 0A 00 41 04 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? FF FF 10 24 00 00 43 8C 16 00 60 14 5C 00 BF 8F 02 00 03 24 12 00 00 10 00 00 43 AC ?? ?? 99 8F ?? ?? ?? ?? 18 00 A4 8F 1C 00 A2 8F 09 00 52 14 10 00 BC 8F ?? ?? 99 8F 2A 10 30 02 40 00 A5 8F 0B 80 22 02 21 20 80 02 ?? ?? ?? ?? 21 30 00 02 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 40 00 A4 8F 5C 00 BF 8F 21 10 00 02 58 00 B4 8F 54 00 B3 8F 50 00 B2 8F 4C 00 B1 8F 48 00 B0 8F 08 00 E0 03 60 00 BD 27 }
	condition:
		$1
}

rule file_760_1_0 {
	meta:
		name = "__GI___res_querydomain"
		size = 396
		refs = "0000 _gp_disp 0044 __GI_strlen 0048 __GI___h_errno_location 00c4 __GI_strncpy 011c __GI_snprintf 0118 $LC0 0148 __GI___res_query"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 B8 FB BD 27 18 00 BC AF 34 04 B3 AF 28 04 B0 AF 44 04 BF AF 40 04 B6 AF 3C 04 B5 AF 38 04 B4 AF 30 04 B2 AF 2C 04 B1 AF 21 80 80 00 03 00 80 10 58 04 B3 8F 06 00 60 16 ?? ?? 92 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 10 00 00 10 FF FF 03 24 21 88 A0 00 21 A8 C0 00 21 A0 E0 00 20 00 A0 14 21 C8 40 02 ?? ?? ?? ?? 00 00 00 00 01 00 43 24 02 04 63 2C 08 00 60 14 18 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 03 00 03 24 00 00 43 AC 31 00 00 10 FF FF 02 24 28 00 40 50 5C 04 A2 8F FF FF 52 24 21 10 12 02 00 00 43 80 2E 00 02 24 22 00 62 14 5C 04 A2 8F ?? ?? 99 8F 20 00 B1 27 21 30 40 02 21 20 20 02 21 28 00 02 ?? ?? ?? ?? 21 90 32 02 18 00 BC 8F 16 00 00 10 00 00 40 A2 ?? ?? ?? ?? 00 00 00 00 21 20 20 02 21 C8 40 02 ?? ?? ?? ?? 21 B0 40 00 21 10 C2 02 02 00 56 24 02 04 D6 2E DD FF C0 12 18 00 BC 8F ?? ?? 86 8F ?? ?? 99 8F 10 00 B1 AF 20 00 B1 27 21 20 20 02 01 04 05 24 ?? ?? C6 24 ?? ?? ?? ?? 21 38 00 02 18 00 BC 8F 21 80 20 02 5C 04 A2 8F ?? ?? 99 8F 21 20 00 02 10 00 A2 AF 21 28 A0 02 21 30 80 02 ?? ?? ?? ?? 21 38 60 02 44 04 BF 8F 40 04 B6 8F 3C 04 B5 8F 38 04 B4 8F 34 04 B3 8F 30 04 B2 8F 2C 04 B1 8F 28 04 B0 8F 08 00 E0 03 48 04 BD 27 }
	condition:
		$1
}

rule file_760_2_0 {
	meta:
		name = "__res_search"
		size = 812
		refs = "0000 _gp_disp 0050 __GI___h_errno_location 0068 _res 006c __GI___res_init 0078 __pthread_mutex_unlock 007c __resolv_lock 0080 _pthread_cleanup_push_defer 0094 __pthread_mutex_lock 00ac _pthread_cleanup_pop_restore 00e0 __GI___errno_location 0168 __GI___res_querydomain"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 90 FF BD 27 18 00 BC AF 48 00 B0 AF 6C 00 BF AF 68 00 BE AF 64 00 B7 AF 60 00 B6 AF 5C 00 B5 AF 58 00 B4 AF 54 00 B3 AF 50 00 B2 AF 4C 00 B1 AF 21 80 80 00 03 00 80 10 78 00 A6 AF 07 00 E0 14 21 88 E0 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 FF FF 03 24 A0 00 00 10 00 00 43 AC ?? ?? 97 8F ?? ?? 93 8F 21 A0 A0 00 20 00 B6 27 ?? ?? 85 8F ?? ?? 86 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 C0 02 18 00 BC 8F ?? ?? 84 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 18 00 BC 8F 08 00 F2 8E 21 20 C0 02 ?? ?? 99 8F 01 00 05 24 ?? ?? ?? ?? 59 01 FE 92 18 00 BC 8F 01 00 42 32 06 00 40 14 ?? ?? 95 8F 21 C8 60 02 ?? ?? ?? ?? 00 00 00 00 E7 FF 00 10 18 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 18 00 BC 8F 00 00 40 AC ?? ?? 99 8F ?? ?? ?? ?? 21 B0 40 00 21 98 40 00 01 00 02 24 18 00 BC 8F 21 40 00 00 00 00 62 AE 21 10 00 02 00 00 44 80 05 00 80 10 2E 00 84 38 01 00 84 2C 21 40 04 01 FA FF 00 10 01 00 42 24 2B 20 02 02 04 00 80 10 21 B8 00 00 FF FF 57 80 2E 00 F7 3A 01 00 F7 2E 2B 10 1E 01 10 00 40 14 FF FF 1E 24 80 00 B9 8F 78 00 A7 8F 40 00 A8 AF 14 00 B9 AF ?? ?? 99 8F 10 00 B1 AF 21 20 00 02 21 28 00 00 ?? ?? ?? ?? 21 30 80 02 18 00 BC 8F 5D 00 40 1C 40 00 A8 8F 00 00 7E 8E 08 00 F7 36 05 00 00 11 80 00 42 32 01 00 E2 32 39 00 40 14 08 00 E2 32 00 02 42 32 36 00 40 10 08 00 E2 32 ?? ?? 99 8F 21 40 00 00 3C 00 B5 26 92 00 0A 24 02 00 0B 24 00 0F 0C 3C 00 02 52 32 00 00 A5 8E 2C 00 A0 10 08 00 E2 32 29 00 00 15 80 00 A2 8F 78 00 A7 8F 40 00 A8 AF 34 00 AA AF 38 00 AB AF 3C 00 AC AF 30 00 B9 AF 10 00 B1 AF 14 00 A2 AF 21 20 00 02 09 F8 20 03 21 30 80 02 18 00 BC 8F 40 00 A8 8F 34 00 AA 8F 38 00 AB 8F 3C 00 AC 8F 35 00 40 1C 30 00 B9 8F 00 00 C2 8E 03 00 4A 54 00 00 62 8E 29 00 00 10 02 00 02 24 06 00 4B 10 04 00 04 24 0A 00 44 50 02 00 F7 36 01 00 48 38 07 00 00 10 2B 40 08 00 00 00 24 8E 00 02 02 3C 24 20 84 01 02 00 82 54 01 00 08 24 04 00 F7 36 01 00 02 24 0A 40 52 00 D4 FF 00 10 04 00 B5 26 08 00 E2 32 05 00 40 10 FF FF 02 24 10 00 C2 53 02 00 E2 32 12 00 00 10 00 00 7E AE 80 00 B9 8F 78 00 A7 8F 10 00 B1 AF 14 00 B9 AF ?? ?? 99 8F 21 20 00 02 21 28 00 00 ?? ?? ?? ?? 21 30 80 02 0E 00 40 1C 6C 00 BF 8F F0 FF 00 10 FF FF 02 24 05 00 40 10 04 00 F7 32 04 00 02 24 00 00 62 AE 05 00 00 10 FF FF 02 24 03 00 E0 12 FF FF 02 24 02 00 04 24 00 00 64 AE 6C 00 BF 8F 68 00 BE 8F 64 00 B7 8F 60 00 B6 8F 5C 00 B5 8F 58 00 B4 8F 54 00 B3 8F 50 00 B2 8F 4C 00 B1 8F 48 00 B0 8F 08 00 E0 03 70 00 BD 27 }
	condition:
		$1
}

rule file_761_0_0 {
	meta:
		name = "flock"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 2F 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_763_0_0 {
	meta:
		name = "res_sync_func"
		size = 164
		refs = "0000 _gp_disp 000c __nameserver 0030 __local_nameserver 0038 _res 003c __nameservers 006c __GI_memcpy"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F D8 FF BD 27 1C 00 B1 AF 10 00 BC AF 24 00 BF AF 20 00 B2 AF 18 00 B0 AF 00 00 43 8C 21 88 40 00 ?? ?? 82 8F 15 00 62 10 ?? ?? 84 8F ?? ?? 82 8F 58 01 83 90 00 00 45 8C 2B 28 65 00 02 00 A0 10 21 90 80 00 00 00 43 AC 00 00 50 8C FF FF 10 26 0A 00 00 06 00 19 10 00 00 00 24 8E ?? ?? 99 8F 21 28 43 02 21 20 83 00 0C 00 A5 24 ?? ?? ?? ?? 10 00 06 24 F5 FF 00 10 10 00 BC 8F 24 00 BF 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_763_1_0 {
	meta:
		name = "__GI___res_init"
		size = 460
		refs = "0000 _gp_disp 0010 __pthread_mutex_unlock 0014 __resolv_lock 0018 _pthread_cleanup_push_defer 0054 __pthread_mutex_lock 0064 __close_nameservers 0074 __open_nameservers 0090 _res 0094 __res_sync 0098 __GI_memset 00b8 __GI_random 00d8 __searchdomains 00dc __searchdomain 0124 __nameservers 0128 __nameserver 0140 _pthread_cleanup_pop_restore 0168 __GI_memcpy"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 B8 FF BD 27 ?? ?? 85 8F ?? ?? 86 8F ?? ?? 99 8F 34 00 B3 AF 18 00 B3 27 44 00 BF AF 10 00 BC AF 2C 00 B1 AF 28 00 B0 AF 40 00 B6 AF 3C 00 B5 AF 38 00 B4 AF 30 00 B2 AF ?? ?? ?? ?? 21 20 60 02 10 00 BC 8F ?? ?? 84 8F ?? ?? 99 8F ?? ?? ?? ?? 01 00 11 24 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F 21 28 00 00 B4 01 06 24 ?? ?? 83 8F ?? ?? 90 8F ?? ?? 82 8F ?? ?? 99 8F ?? ?? 63 24 00 00 43 AC ?? ?? ?? ?? 21 20 00 02 10 00 BC 8F 05 00 02 24 00 00 02 AE ?? ?? 99 8F 04 00 02 24 08 00 11 AE ?? ?? ?? ?? 04 00 02 AE 10 00 BC 8F 5E 01 02 A6 07 00 03 24 ?? ?? 82 8F ?? ?? 85 8F 59 01 11 A2 00 00 42 8C 08 00 44 2C 0B 18 44 00 21 10 00 00 2A 20 43 00 0A 00 80 10 80 20 02 00 00 00 A6 8C 21 20 C4 00 00 00 86 8C 0E 00 44 24 80 20 04 00 21 20 04 02 04 00 86 AC F5 FF 00 10 01 00 42 24 ?? ?? 94 8F ?? ?? 95 8F 21 88 00 00 21 90 00 00 02 00 16 24 03 00 22 2E 14 00 40 10 ?? ?? 99 8F 00 00 82 8E 2B 10 42 02 10 00 40 10 00 29 12 00 00 00 A2 8E 21 28 45 00 00 00 A2 94 F5 FF 56 54 01 00 52 26 ?? ?? 99 8F 00 21 11 00 21 20 04 02 0C 00 84 24 ?? ?? ?? ?? 10 00 06 24 10 00 BC 8F 01 00 31 26 EB FF 00 10 01 00 52 26 58 01 11 A2 21 20 60 02 ?? ?? ?? ?? 01 00 05 24 44 00 BF 8F 40 00 B6 8F 3C 00 B5 8F 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 21 10 00 00 08 00 E0 03 48 00 BD 27 }
	condition:
		$1
}

rule file_764_0_0 {
	meta:
		name = "___path_search"
		size = 368
		refs = "0000 _gp_disp 004c __GI_strlen 006c $LC0 0084 __GI_stat 0090 $LC1 00b0 __GI___errno_location 012c __GI_sprintf 010c $LC2"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 30 FF BD 27 18 00 BC AF C8 00 B4 AF C4 00 B3 AF C0 00 B2 AF B8 00 B0 AF CC 00 BF AF BC 00 B1 AF 21 98 80 00 21 A0 A0 00 21 90 C0 00 0C 00 E0 10 21 80 E0 00 00 00 E2 80 0A 00 40 50 ?? ?? 90 8F ?? ?? 99 8F 21 20 E0 00 ?? ?? ?? ?? 05 00 11 24 06 00 43 2C 18 00 BC 8F 04 00 00 10 0B 88 43 00 ?? ?? 90 8F 04 00 11 24 ?? ?? 10 26 13 00 40 16 ?? ?? 99 8F ?? ?? 92 8F ?? ?? 99 8F 20 00 A5 27 ?? ?? ?? ?? ?? ?? 44 26 06 00 40 14 18 00 BC 8F 34 00 A2 8F 00 F0 42 30 00 40 42 38 06 00 40 10 ?? ?? 52 26 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 18 00 00 10 02 00 03 24 ?? ?? 99 8F ?? ?? ?? ?? 21 20 40 02 18 00 BC 8F 2F 00 04 24 02 00 43 2C 07 00 60 14 FF FF 43 24 21 28 43 02 00 00 A5 80 04 00 A4 54 08 00 23 26 F8 FF 00 10 21 10 60 00 08 00 23 26 21 18 62 00 2B A0 83 02 08 00 80 12 ?? ?? 85 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 16 00 03 24 00 00 43 AC 0A 00 00 10 FF FF 02 24 ?? ?? 99 8F 10 00 B1 AF 14 00 B0 AF 21 20 60 02 ?? ?? A5 24 21 30 40 00 ?? ?? ?? ?? 21 38 40 02 21 10 00 00 CC 00 BF 8F C8 00 B4 8F C4 00 B3 8F C0 00 B2 8F BC 00 B1 8F B8 00 B0 8F 08 00 E0 03 D0 00 BD 27 }
	condition:
		$1
}

rule file_764_1_0 {
	meta:
		name = "__gen_tempname"
		size = 944
		refs = "0000 _gp_disp 000c __GI___errno_location 0058 __GI_strlen 0080 __GI_strcmp 007c $LC3 00a8 $LC4 00ac $LC5 00c0 __GI_open 00fc __GI_gettimeofday 0140 __GI_getpid 01c0 __GI_read 01e4 __GI_close 02a8 __GI_open64 02d4 __GI_stat 0334 __GI_mkdir"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F 00 FF BD 27 10 00 BC AF FC 00 BF AF E8 00 B4 AF E0 00 B2 AF DC 00 B1 AF D8 00 B0 AF F8 00 BE AF F4 00 B7 AF F0 00 B6 AF EC 00 B5 AF E4 00 B3 AF 21 88 80 00 ?? ?? ?? ?? 21 90 A0 00 10 00 BC 8F 00 00 43 8C 21 20 20 02 ?? ?? 99 8F B8 00 A3 AF ?? ?? ?? ?? 21 80 40 00 FA FF 54 24 06 00 42 2C 10 00 BC 8F 09 00 40 14 21 A0 34 02 ?? ?? 85 8F ?? ?? 99 8F 21 20 80 02 ?? ?? ?? ?? ?? ?? A5 24 21 98 00 00 04 00 40 10 10 00 BC 8F 16 00 02 24 B6 00 00 10 00 00 02 AE ?? ?? 97 8F ?? ?? 9E 8F ?? ?? 95 8F ?? ?? F7 26 ?? ?? DE 27 ?? ?? B5 26 ?? ?? 96 8F 21 20 E0 02 21 C8 C0 02 ?? ?? ?? ?? 21 28 00 00 21 18 40 00 39 00 41 04 10 00 BC 8F 21 20 C0 03 21 C8 C0 02 ?? ?? ?? ?? 80 00 05 24 21 18 40 00 32 00 41 04 10 00 BC 8F ?? ?? 99 8F 18 00 A8 27 21 20 00 01 C8 00 A8 AF ?? ?? ?? ?? 21 28 00 00 1C 00 A7 8F 10 00 BC 8F C3 17 07 00 ?? ?? 83 8F 02 24 07 00 00 14 02 00 25 10 82 00 18 00 A4 8F ?? ?? 65 8C ?? ?? 69 8C C3 57 04 00 ?? ?? 99 8F 00 3C 07 00 26 38 E4 00 26 50 4A 00 D0 00 A3 AF CC 00 A5 AF C0 00 A7 AF BC 00 A9 AF ?? ?? ?? ?? C4 00 AA AF C0 00 A7 8F C4 00 AA 8F CC 00 A5 8F BC 00 A9 8F C3 37 02 00 26 38 E2 00 D0 00 A3 8F 26 50 46 01 21 28 E5 00 21 48 49 01 2B 38 A7 00 21 30 E9 00 21 04 0B 3C ?? ?? 65 AC ?? ?? 66 AC 10 00 BC 8F 21 18 00 00 3E 00 02 24 42 08 6B 25 06 00 09 24 13 00 00 10 C8 00 A8 8F ?? ?? 99 8F 21 20 60 00 B0 00 A5 27 06 00 06 24 ?? ?? ?? ?? D0 00 A3 AF 10 00 BC 8F D0 00 A3 8F CC 00 A2 AF ?? ?? 99 8F ?? ?? ?? ?? 21 20 60 00 CC 00 A5 8F 06 00 02 24 19 00 A2 10 10 00 BC 8F BF FF 00 10 ?? ?? 99 8F 1B 00 C2 00 F4 01 40 00 10 38 00 00 80 50 07 00 12 30 00 00 1B 00 A2 00 F4 01 40 00 10 20 00 00 21 20 44 01 00 00 EB 70 12 38 00 00 1B 00 82 00 F4 01 40 00 10 50 00 00 21 20 55 01 00 00 84 90 12 28 00 00 21 28 E5 00 21 38 03 01 01 00 63 24 EB FF 69 14 98 00 E4 A0 21 10 00 00 06 00 05 24 18 00 A6 27 3E 00 03 24 0B 00 45 10 21 20 C2 00 98 00 84 90 21 38 82 02 01 00 42 24 1B 00 83 00 F4 01 60 00 10 40 00 00 21 20 A8 02 00 00 84 90 F5 FF 00 10 00 00 E4 A0 01 00 02 24 1C 00 42 12 ?? ?? 99 8F 02 00 42 2A 05 00 40 10 02 00 03 24 13 00 40 12 21 20 20 02 27 00 00 10 00 00 02 8E 1A 00 43 12 03 00 02 24 22 00 42 16 ?? ?? 99 8F D0 00 A3 AF 21 20 20 02 ?? ?? ?? ?? 18 00 A5 27 06 00 41 04 D0 00 A3 8F 00 00 02 8E 21 00 43 14 21 10 00 00 15 00 00 10 B8 00 A3 8F 21 20 20 02 02 05 05 24 80 01 06 24 04 00 00 10 21 C8 C0 02 21 20 20 02 02 05 05 24 80 01 06 24 09 F8 20 03 00 00 00 00 06 00 00 10 10 00 BC 8F ?? ?? 99 8F 21 20 20 02 ?? ?? ?? ?? C0 01 05 24 10 00 BC 8F 05 00 42 04 00 00 02 8E B8 00 A3 8F 0A 00 00 10 00 00 03 AE 00 00 02 8E 11 00 03 24 05 00 43 14 03 00 03 3C 01 00 73 26 F8 A2 63 34 53 FF 63 16 ?? ?? 96 8F FF FF 02 24 FC 00 BF 8F F8 00 BE 8F F4 00 B7 8F F0 00 B6 8F EC 00 B5 8F E8 00 B4 8F E4 00 B3 8F E0 00 B2 8F DC 00 B1 8F D8 00 B0 8F 08 00 E0 03 00 01 BD 27 }
	condition:
		$1
}

rule file_765_0_0 {
	meta:
		name = "__GI_utime"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF BE 0F 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_766_0_0 {
	meta:
		name = "__GI___longjmp"
		size = 80
	strings:
		$1 = { 2C 00 9C 8C 08 00 90 8C 0C 00 91 8C 10 00 92 8C 14 00 93 8C 18 00 94 8C 1C 00 95 8C 20 00 96 8C 24 00 97 8C 00 00 99 8C 04 00 9D 8C 03 00 A0 14 28 00 9E 8C 02 00 00 10 01 00 02 24 21 10 A0 00 08 00 20 03 00 00 00 00 FF FF 00 10 00 00 00 00 }
	condition:
		$1
}

rule file_767_0_0 {
	meta:
		name = "memalign"
		size = 604
		refs = "0000 _gp_disp 0054 malloc 007c _pthread_cleanup_push_defer 009c __pthread_mutex_unlock 00a0 __malloc_lock 00b8 __pthread_mutex_lock 00d0 __GI___errno_location 019c free 0228 _pthread_cleanup_pop_restore"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 C0 FF BD 27 09 00 82 2C 10 00 BC AF 2C 00 B1 AF 28 00 B0 AF 3C 00 BF AF 38 00 B4 AF 34 00 B3 AF 30 00 B2 AF 21 80 80 00 0B 00 40 10 21 88 A0 00 3C 00 BF 8F 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F ?? ?? 99 8F 21 20 A0 00 ?? ?? ?? ?? 40 00 BD 27 10 00 02 24 10 00 83 2C 0B 80 43 00 FF FF 02 26 24 10 50 00 08 00 40 10 ?? ?? 99 8F 10 00 02 24 2B 18 50 00 03 00 60 50 21 80 40 00 FC FF 00 10 40 10 02 00 ?? ?? 99 8F ?? ?? 85 8F ?? ?? 86 8F 18 00 B4 27 ?? ?? ?? ?? 21 20 80 02 10 00 BC 8F ?? ?? 84 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 E0 FF 22 2E 08 00 40 14 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 0C 00 03 24 00 00 43 AC 55 00 00 10 21 10 00 00 0B 00 31 26 10 00 22 2E 03 00 40 14 10 00 13 24 F8 FF 13 24 24 98 33 02 ?? ?? 99 8F 10 00 04 26 ?? ?? ?? ?? 21 20 93 00 43 00 40 10 10 00 BC 8F 1B 00 50 00 F4 01 00 02 10 18 00 00 27 00 60 10 F8 FF 52 24 FF FF 11 26 23 18 10 00 21 88 51 00 24 88 23 02 F8 FF 31 26 23 18 32 02 10 00 63 2C 02 20 70 70 FC FF 03 24 21 88 91 00 FC FF 44 8C 23 90 32 02 24 18 83 00 02 00 84 30 08 00 80 10 23 18 72 00 F8 FF 42 8C 02 00 63 34 04 00 23 AE 21 90 42 02 00 00 32 AE 28 00 00 10 08 00 31 26 01 00 64 34 04 00 24 AE 21 18 23 02 04 00 64 8C ?? ?? 99 8F 01 00 84 34 04 00 64 AC FC FF 43 8C 21 20 40 00 01 00 63 30 25 90 43 02 ?? ?? ?? ?? FC FF 52 AC 10 00 BC 8F 21 90 20 02 04 00 42 8E 02 00 43 30 15 00 60 14 08 00 51 26 FC FF 03 24 24 10 43 00 10 00 63 26 2B 18 62 00 0F 00 60 10 23 10 53 00 21 20 53 02 01 00 42 34 04 00 82 AC 04 00 42 8E ?? ?? 99 8F 08 00 84 24 01 00 42 30 25 98 62 02 ?? ?? ?? ?? 04 00 53 AE 10 00 BC 8F 02 00 00 10 08 00 51 26 21 88 00 00 ?? ?? 99 8F 21 20 80 02 ?? ?? ?? ?? 01 00 05 24 21 10 20 02 3C 00 BF 8F 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 E0 03 40 00 BD 27 }
	condition:
		$1
}

rule file_768_0_0 {
	meta:
		name = "swab"
		size = 60
	strings:
		$1 = { 43 30 06 00 40 18 06 00 21 18 83 00 2B 10 83 00 08 00 40 10 02 00 A5 24 00 00 82 94 02 00 84 24 00 32 02 00 02 12 02 00 25 10 C2 00 F7 FF 00 10 FE FF A2 A4 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_770_0_0 {
	meta:
		name = "__GI___glibc_strerror_r"
		size = 60
		refs = "0000 _gp_disp 000c __GI___xpg_strerror_r"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F E0 FF BD 27 1C 00 BF AF 18 00 B0 AF 10 00 BC AF ?? ?? ?? ?? 21 80 A0 00 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_772_0_0 {
	meta:
		name = "__GI_recvmsg"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 51 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_773_0_0 {
	meta:
		name = "tdestroy_recurse"
		size = 136
		refs = "0000 _gp_disp 0038 tdestroy_recurse 0078 free"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D8 FF BD 27 20 00 B1 AF 1C 00 B0 AF 10 00 BC AF 24 00 BF AF 21 80 80 00 04 00 84 8C 06 00 80 10 21 88 A0 00 ?? ?? 99 8F ?? ?? 39 27 ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F 08 00 04 8E 04 00 80 10 ?? ?? 99 8F ?? ?? 39 27 ?? ?? ?? ?? 21 28 20 02 21 C8 20 02 09 F8 20 03 00 00 04 8E 10 00 BC 8F 24 00 BF 8F 20 00 B1 8F 21 20 00 02 ?? ?? 99 8F 1C 00 B0 8F ?? ?? ?? ?? 28 00 BD 27 }
	condition:
		$1
}

rule file_773_1_0 {
	meta:
		name = "__GI_tdestroy"
		size = 40
		refs = "0000 _gp_disp 0018 tdestroy_recurse"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 04 00 80 10 ?? ?? 99 8F ?? ?? 39 27 ?? ?? ?? ?? 00 00 00 00 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_774_0_0 {
	meta:
		name = "_stdlib_strto_ll"
		size = 728
		refs = "0000 _gp_disp 0018 __GI___ctype_b 0100 __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 B8 FF BD 27 24 00 B1 AF 21 88 C0 00 ?? ?? 86 8F 34 00 B5 AF 30 00 B4 AF 20 00 B0 AF 10 00 BC AF 44 00 BF AF 40 00 BE AF 3C 00 B7 AF 38 00 B6 AF 2C 00 B3 AF 28 00 B2 AF 21 A0 A0 00 21 A8 E0 00 21 80 80 00 00 00 02 82 00 00 C5 8C 40 18 02 00 21 18 A3 00 00 00 63 94 20 00 63 30 03 00 60 10 2B 00 03 24 F7 FF 00 10 01 00 10 26 05 00 43 10 2D 00 03 24 05 00 43 54 21 98 00 00 02 00 00 10 01 00 13 24 21 98 00 00 01 00 10 26 EF FF 02 24 24 10 22 02 14 00 40 14 FE FF 22 26 00 00 03 82 30 00 02 24 03 00 62 50 01 00 05 82 0A 00 00 10 0A 00 22 26 78 00 03 24 01 00 04 26 20 00 A5 34 04 00 A3 14 08 00 22 26 02 00 10 26 02 00 00 10 40 10 02 00 21 80 80 00 10 00 11 24 11 00 43 28 0B 88 43 00 FE FF 22 26 23 00 42 2C 4F 00 40 10 21 18 00 00 ?? ?? 99 8F 21 10 00 00 21 18 00 00 00 04 1E 3C C3 B7 11 00 00 01 12 3C 22 00 17 24 00 00 05 82 D0 FF A6 24 FF 00 C6 30 0A 00 C8 2C 09 00 00 55 2A 28 D1 00 20 00 A5 34 FF 00 A5 30 61 00 A8 2C 03 00 00 15 28 00 06 24 A9 FF A6 24 FF 00 C6 30 2A 28 D1 00 38 00 A0 10 00 00 00 00 2B 20 7E 00 0D 00 80 10 01 00 10 26 18 00 C2 02 00 00 71 70 12 20 00 00 19 00 51 00 12 10 00 00 21 10 C2 00 2B 30 46 00 10 18 00 00 21 18 83 00 21 18 C3 00 E2 FF 00 10 21 20 00 02 FF 00 44 30 02 28 91 70 02 12 02 00 00 26 03 00 25 10 82 00 02 1A 03 00 18 00 C2 02 21 30 A6 00 02 2A 06 00 00 00 71 70 12 20 00 00 19 00 51 00 12 10 00 00 21 40 A2 00 2B 28 05 01 10 18 00 00 21 20 83 00 21 18 80 00 21 20 A4 00 2B 20 92 00 0A 00 80 10 02 2E 02 00 00 22 03 00 00 12 02 00 C3 1F 06 00 25 20 A4 00 21 10 C2 00 2B 30 46 00 21 20 64 00 E0 FF 00 10 21 18 C4 00 09 F8 20 03 18 00 B9 AF 10 00 BC 8F 00 00 57 AC 24 98 75 02 FF FF 02 24 FF FF 03 24 D7 FF 00 10 18 00 B9 8F 01 00 80 56 00 00 84 AE 04 00 60 52 FF 7F 10 3C 21 88 00 00 03 00 00 10 00 80 10 3C FF FF 11 24 FF FF 10 36 0D 00 A0 12 2B 20 03 02 05 00 80 14 ?? ?? 99 8F 09 00 70 14 2B 20 22 02 07 00 80 10 00 00 00 00 ?? ?? ?? ?? 00 00 00 00 22 00 03 24 00 00 43 AC 21 10 20 02 21 18 00 02 05 00 60 12 44 00 BF 8F 23 10 02 00 2B 20 02 00 23 18 03 00 23 18 64 00 40 00 BE 8F 3C 00 B7 8F 38 00 B6 8F 34 00 B5 8F 30 00 B4 8F 2C 00 B3 8F 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 08 00 E0 03 48 00 BD 27 }
	condition:
		$1
}

rule file_775_0_0 {
	meta:
		name = "__stdio_WRITE"
		size = 280
		refs = "0000 _gp_disp 0014 __GI_write"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 C8 FF BD 27 2C 00 B4 AF ?? ?? 94 8F 30 00 B5 AF FF 7F 15 3C 28 00 B3 AF 24 00 B2 AF 20 00 B1 AF 1C 00 B0 AF 10 00 BC AF 34 00 BF AF 21 88 80 00 21 90 A0 00 21 98 C0 00 21 80 C0 00 FF FF B5 36 28 00 00 12 00 00 06 2A 21 10 A0 02 04 00 24 8E 0A 10 06 02 21 30 40 00 21 C8 80 02 ?? ?? ?? ?? 21 28 40 02 04 00 42 04 00 00 22 96 23 80 02 02 F3 FF 00 10 21 90 42 02 08 00 23 8E 08 00 42 34 00 00 22 A6 0C 00 22 8E 23 10 43 00 16 00 40 50 23 10 70 02 2B 20 02 02 0B 10 04 02 0A 00 05 24 00 00 44 92 05 00 85 14 00 00 64 A0 00 00 24 96 00 01 84 30 06 00 80 54 08 00 22 8E FF FF 42 24 01 00 63 24 F6 FF 40 14 01 00 52 26 08 00 22 8E 10 00 23 AE 23 18 43 00 21 80 03 02 02 00 00 10 23 10 70 02 21 10 60 02 34 00 BF 8F 30 00 B5 8F 2C 00 B4 8F 28 00 B3 8F 24 00 B2 8F 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_776_0_0 {
	meta:
		name = "__GI___uc_malloc"
		size = 128
		refs = "0000 _gp_disp 0014 __GI___uc_malloc_failed 0028 malloc 0050 __GI__exit"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D8 FF BD 27 20 00 B1 AF ?? ?? 91 8F 1C 00 B0 AF 10 00 BC AF 24 00 BF AF 21 80 80 00 ?? ?? 99 8F ?? ?? ?? ?? 21 20 00 02 0D 00 00 12 10 00 BC 8F 0C 00 40 14 24 00 BF 8F 00 00 39 8E 04 00 20 17 00 00 00 00 ?? ?? 99 8F ?? ?? ?? ?? 01 00 04 24 09 F8 20 03 21 20 00 02 F0 FF 00 10 10 00 BC 8F 24 00 BF 8F 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_777_0_0 {
	meta:
		name = "__GI_wcscat"
		size = 56
	strings:
		$1 = { 21 10 80 00 21 18 80 00 00 00 64 8C 03 00 80 10 04 00 66 24 FC FF 00 10 21 18 C0 00 00 00 A4 8C 04 00 63 24 04 00 A5 24 FC FF 80 14 FC FF 64 AC 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_778_0_0 {
	meta:
		name = "mlockall"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 3C 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_779_0_0 {
	meta:
		name = "mprotect"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 1D 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_781_0_0 {
	meta:
		name = "__fwritable"
		size = 16
	strings:
		$1 = { 00 00 82 94 20 00 42 38 08 00 E0 03 40 01 42 7C }
	condition:
		$1
}

rule file_782_0_0 {
	meta:
		name = "vsprintf"
		size = 36
		refs = "0000 _gp_disp 000c __GI_vsnprintf"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F 21 10 A0 00 21 38 C0 00 FF FF 05 24 ?? ?? ?? ?? 21 30 40 00 }
	condition:
		$1
}

rule file_783_0_0 {
	meta:
		name = "__libc_system"
		size = 476
		refs = "0000 _gp_disp 003c __GI_signal 0080 fork 0114 __GI_execl 0108 $LC0 010c $LC1 0110 $LC2 012c __GI__exit 015c __GI_wait4"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 B8 FF BD 27 18 00 BC AF 40 00 B6 AF 44 00 BF AF 3C 00 B5 AF 38 00 B4 AF 34 00 B3 AF 30 00 B2 AF 2C 00 B1 AF 28 00 B0 AF 5E 00 80 10 21 B0 80 00 ?? ?? 90 8F 03 00 04 24 21 C8 00 02 ?? ?? ?? ?? 01 00 05 24 02 00 04 24 01 00 05 24 21 C8 00 02 ?? ?? ?? ?? 21 A8 40 00 12 00 04 24 21 28 00 00 21 C8 00 02 ?? ?? ?? ?? 21 A0 40 00 18 00 BC 8F 21 98 40 00 ?? ?? 99 8F ?? ?? ?? ?? 21 88 00 02 21 90 40 00 0E 00 41 04 03 00 04 24 21 C8 00 02 ?? ?? ?? ?? 21 28 A0 02 02 00 04 24 21 C8 00 02 ?? ?? ?? ?? 21 28 80 02 12 00 04 24 21 C8 00 02 ?? ?? ?? ?? 21 28 60 02 3B 00 00 10 FF FF 02 24 1A 00 40 14 21 C8 00 02 ?? ?? ?? ?? 21 28 00 00 02 00 04 24 21 C8 00 02 ?? ?? ?? ?? 21 28 00 00 12 00 04 24 21 C8 00 02 ?? ?? ?? ?? 21 28 00 00 18 00 BC 8F 10 00 A0 AF 21 38 C0 02 ?? ?? 84 8F ?? ?? 85 8F ?? ?? 86 8F ?? ?? 99 8F ?? ?? 84 24 ?? ?? A5 24 ?? ?? ?? ?? ?? ?? C6 24 18 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 7F 00 04 24 ?? ?? ?? ?? 01 00 05 24 02 00 04 24 21 C8 00 02 ?? ?? ?? ?? 01 00 05 24 18 00 BC 8F 21 20 40 02 20 00 A5 27 ?? ?? 99 8F 21 30 00 00 ?? ?? ?? ?? 21 38 00 00 FF FF 03 24 01 00 43 50 20 00 A2 AF 03 00 04 24 21 C8 20 02 ?? ?? ?? ?? 21 28 A0 02 02 00 04 24 21 C8 20 02 ?? ?? ?? ?? 21 28 80 02 12 00 04 24 21 C8 20 02 ?? ?? ?? ?? 21 28 60 02 02 00 00 10 20 00 A2 8F 01 00 02 24 44 00 BF 8F 40 00 B6 8F 3C 00 B5 8F 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 E0 03 48 00 BD 27 }
	condition:
		$1
}

rule file_784_0_0 {
	meta:
		name = "sethostname"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF EA 0F 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_785_0_0 {
	meta:
		name = "clock"
		size = 80
		refs = "0000 _gp_disp 000c __GI_times"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F D0 FF BD 27 2C 00 BF AF 10 00 BC AF ?? ?? ?? ?? 18 00 A4 27 18 00 A2 8F 1C 00 A3 8F 2C 00 BF 8F 30 00 BD 27 21 18 62 00 10 27 02 24 02 18 62 70 FF 7F 02 3C F0 FF 42 34 08 00 E0 03 24 10 62 00 }
	condition:
		$1
}

rule file_786_0_0 {
	meta:
		name = "ldiv"
		size = 52
	strings:
		$1 = { 1A 00 A6 00 F4 01 C0 00 21 10 80 00 10 18 00 00 05 00 A0 04 12 20 00 00 04 00 63 04 00 00 44 AC 01 00 84 24 23 18 66 00 00 00 44 AC 08 00 E0 03 04 00 43 AC }
	condition:
		$1
}

rule file_787_0_0 {
	meta:
		name = "swapoff"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 13 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_788_0_0 {
	meta:
		name = "tcsetpgrp"
		size = 60
		refs = "0000 _gp_disp 0010 __GI_ioctl"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 ?? ?? 99 8F 24 00 A5 AF 04 80 05 3C 1C 00 BF AF 10 00 BC AF 24 00 A6 27 ?? ?? ?? ?? 76 74 A5 24 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_790_0_0 {
	meta:
		name = "getchar"
		size = 248
		refs = "0000 _gp_disp 000c stdin 0034 _pthread_cleanup_push_defer 0058 __GI___fgetc_unlocked 006c __pthread_mutex_unlock 0088 __pthread_mutex_lock 00cc _pthread_cleanup_pop_restore"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F C8 FF BD 27 10 00 BC AF 34 00 BF AF 30 00 B2 AF 2C 00 B1 AF 28 00 B0 AF 00 00 50 8C 34 00 02 8E 0E 00 40 10 ?? ?? 99 8F 10 00 02 8E 18 00 03 8E 2B 18 43 00 04 00 60 10 01 00 43 24 10 00 03 AE 23 00 00 10 00 00 42 90 ?? ?? 99 8F ?? ?? ?? ?? 21 20 00 02 1F 00 00 10 34 00 BF 8F ?? ?? 85 8F 38 00 12 26 18 00 B1 27 21 20 20 02 ?? ?? ?? ?? 21 30 40 02 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 40 02 10 00 02 8E 18 00 03 8E 2B 18 43 00 05 00 60 10 10 00 BC 8F 01 00 43 24 10 00 03 AE 06 00 00 10 00 00 50 90 ?? ?? 99 8F ?? ?? ?? ?? 21 20 00 02 10 00 BC 8F 21 80 40 00 ?? ?? 99 8F 21 20 20 02 ?? ?? ?? ?? 01 00 05 24 21 10 00 02 34 00 BF 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_791_0_0 {
	meta:
		name = "__GI_getdomainname"
		size = 176
		refs = "0000 _gp_disp 000c __GI_uname 0044 __GI_strlen 0064 __GI___errno_location 007c __GI_strcpy"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F 50 FE BD 27 10 00 BC AF A8 01 B2 AF A4 01 B1 AF AC 01 BF AF A0 01 B0 AF 21 88 80 00 18 00 A4 27 ?? ?? ?? ?? 21 90 A0 00 FF FF 03 24 15 00 43 10 10 00 BC 8F ?? ?? 99 8F 5D 01 B0 27 ?? ?? ?? ?? 21 20 00 02 01 00 42 24 2B 90 42 02 07 00 40 12 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 16 00 03 24 07 00 00 10 00 00 43 AC ?? ?? 99 8F 21 20 20 02 ?? ?? ?? ?? 21 28 00 02 02 00 00 10 21 10 00 00 FF FF 02 24 AC 01 BF 8F A8 01 B2 8F A4 01 B1 8F A0 01 B0 8F 08 00 E0 03 B0 01 BD 27 }
	condition:
		$1
}

rule file_792_0_0 {
	meta:
		name = "__psfs_parse_spec"
		size = 732
		refs = "0000 _gp_disp 0098 __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 30 00 82 8C E0 FF BD 27 10 00 BC AF 1C 00 BF AF 00 00 43 90 D0 FF 63 24 FF 00 63 30 0A 00 63 2C 27 00 60 10 01 00 07 24 CC 0C 08 3C 21 18 00 00 CC CC 08 35 0A 00 09 24 2A 28 68 00 08 00 A0 10 30 00 85 8C 01 00 A6 24 30 00 86 AC 02 30 69 70 00 00 A5 90 D0 FF A5 24 21 18 C5 00 30 00 85 8C 00 00 A6 90 D0 FF C7 24 0A 00 E7 2C F3 FF E0 54 2A 28 68 00 24 00 07 24 0E 00 C7 10 01 00 A5 24 24 00 85 8C 08 00 A2 04 40 00 83 AC ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 16 00 03 24 00 00 43 AC 88 00 00 10 FF FF 02 24 FE FF 03 24 3E 00 00 10 24 00 83 AC 30 00 85 AC 02 00 00 10 21 38 00 00 21 18 00 00 ?? ?? 89 8F 10 00 06 24 ?? ?? 25 25 30 00 88 8C 00 00 AB 90 00 00 0A 91 07 00 6A 15 01 00 A5 24 45 00 85 90 01 00 08 25 30 00 88 AC 25 30 C5 00 F4 FF 00 10 45 00 86 A0 00 00 A8 90 F3 FF 00 15 40 30 06 00 45 00 85 90 10 00 A5 30 03 00 A0 10 00 00 00 00 06 00 00 10 44 00 80 A0 09 00 E0 10 24 00 85 8C D8 FF A1 04 FE FF 03 24 24 00 83 AC CC 0C 07 3C 21 18 00 00 CC CC E7 34 12 00 00 10 0A 00 08 24 FE FF 06 24 CF FF A6 10 FF FF 63 24 09 00 65 2C CD FF A0 10 ?? ?? 99 8F F4 FF 00 10 28 00 83 AC 09 00 C0 50 30 00 85 8C 01 00 A6 24 30 00 86 AC 02 30 68 70 00 00 A5 90 D0 FF A5 24 21 18 C5 00 40 00 83 AC 30 00 85 8C 00 00 A6 90 D0 FF C6 24 FF 00 C6 30 0A 00 C6 2C F1 FF C0 14 2A 30 67 00 ?? ?? 83 8F ?? ?? 63 24 21 30 60 00 30 00 85 8C 00 00 67 90 00 00 A8 90 04 00 07 55 01 00 63 24 01 00 A5 24 04 00 00 10 30 00 85 AC 00 00 65 90 F7 FF A0 54 30 00 85 8C 23 28 66 00 02 00 A5 28 0A 00 A0 50 08 00 66 90 30 00 85 8C 00 00 66 90 00 00 A7 90 05 00 E6 54 08 00 66 90 01 00 A5 24 08 00 63 24 30 00 85 AC 08 00 66 90 ?? ?? 83 8F 00 32 06 00 ?? ?? 63 24 38 00 86 AC 21 40 60 00 30 00 87 8C 00 00 65 90 00 00 E9 90 1E 00 25 55 01 00 63 24 ?? ?? 85 8F 23 18 68 00 ?? ?? A5 24 21 40 A0 00 00 00 A9 90 2A 48 23 01 03 00 20 51 23 28 A8 00 FB FF 00 10 01 00 A5 24 ?? ?? 88 8F 40 28 05 00 45 00 89 90 ?? ?? 08 25 21 28 A8 00 00 00 A8 94 03 2A 06 00 25 28 A9 00 27 40 08 00 24 28 05 01 7F FF A0 14 13 00 65 28 03 00 A0 14 00 04 C6 30 FD FF 65 24 0B 18 A6 00 3C 00 83 AC 06 00 00 10 23 10 E2 00 00 00 65 90 DE FF A0 54 30 00 87 8C 74 FF 00 10 ?? ?? 99 8F 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_793_0_0 {
	meta:
		name = "__stdio_READ"
		size = 128
		refs = "0000 _gp_disp 0034 __GI_read"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 18 00 B0 AF 10 00 BC AF 1C 00 BF AF 00 00 83 94 21 80 80 00 04 00 63 30 11 00 60 14 21 10 00 00 03 00 C1 04 ?? ?? 99 8F FF 7F 06 3C FF FF C6 34 ?? ?? ?? ?? 04 00 04 8E 0A 00 40 1C 1C 00 BF 8F 04 00 40 14 00 00 03 96 04 00 63 34 04 00 00 10 00 00 03 A6 08 00 63 34 00 00 03 A6 21 10 00 00 1C 00 BF 8F 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_794_0_0 {
	meta:
		name = "__GI_dup2"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF DF 0F 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_795_0_0 {
	meta:
		name = "__GI_wmemchr"
		size = 44
	strings:
		$1 = { 06 00 C0 10 00 00 00 00 00 00 82 8C 05 00 45 10 FF FF C6 24 FA FF 00 10 04 00 84 24 08 00 E0 03 21 10 00 00 08 00 E0 03 21 10 80 00 }
	condition:
		$1
}

rule file_796_0_0 {
	meta:
		name = "sendfile"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 6F 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_797_0_0 {
	meta:
		name = "unlockpt"
		size = 140
		refs = "0000 _gp_disp 000c __GI___errno_location 003c __GI_ioctl"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F C8 FF BD 27 10 00 BC AF 34 00 BF AF 30 00 B1 AF 2C 00 B0 AF 20 00 A4 AF ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F 20 00 A4 8F 04 80 05 3C ?? ?? 99 8F 18 00 A0 AF 31 54 A5 24 18 00 A6 27 21 80 40 00 ?? ?? ?? ?? 00 00 51 8C 06 00 40 10 21 18 00 00 00 00 04 8E 16 00 02 24 02 00 82 54 FF FF 03 24 00 00 11 AE 34 00 BF 8F 30 00 B1 8F 2C 00 B0 8F 21 10 60 00 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_798_0_0 {
	meta:
		name = "getnetbyaddr"
		size = 172
		refs = "0000 _gp_disp 0014 _net_stayopen 002c __GI_setnetent 0044 __GI_getnetent 0080 __GI_endnetent"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 C8 FF BD 27 24 00 B0 AF ?? ?? 90 8F 10 00 BC AF 30 00 B3 AF 2C 00 B2 AF 28 00 B1 AF 34 00 BF AF ?? ?? 99 8F 21 88 80 00 00 00 04 8E ?? ?? ?? ?? 21 90 A0 00 10 00 BC 8F ?? ?? 93 8F 21 C8 60 02 ?? ?? ?? ?? 00 00 00 00 07 00 40 10 10 00 BC 8F 08 00 43 8C FA FF 72 14 21 C8 60 02 0C 00 43 8C F7 FF 71 14 00 00 00 00 00 00 03 8E 06 00 60 14 34 00 BF 8F ?? ?? 99 8F ?? ?? ?? ?? 18 00 A2 AF 18 00 A2 8F 34 00 BF 8F 30 00 B3 8F 2C 00 B2 8F 28 00 B1 8F 24 00 B0 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_799_0_0 {
	meta:
		name = "create_module"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 1F 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_800_0_0 {
	meta:
		name = "sigorset"
		size = 60
	strings:
		$1 = { 04 00 02 24 FF FF 07 24 FF FF 42 24 09 00 47 10 80 18 02 00 21 40 83 00 21 48 C3 00 21 18 A3 00 00 00 29 8D 00 00 63 8C 25 18 23 01 F6 FF 00 10 00 00 03 AD 08 00 E0 03 21 10 00 00 }
	condition:
		$1
}

rule file_801_0_0 {
	meta:
		name = "dirname"
		size = 168
		refs = "0000 _gp_disp"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 21 28 80 00 21 10 80 00 21 00 80 10 2F 00 07 24 00 00 46 80 08 00 C0 10 21 18 40 00 07 00 C7 50 00 00 66 80 01 00 43 24 21 10 A0 00 21 28 40 00 F7 FF 00 10 21 10 60 00 00 00 66 80 03 00 C7 14 00 00 00 00 FC FF 00 10 01 00 63 24 F8 FF C0 54 21 28 40 00 0B 00 A4 14 21 10 A0 00 00 00 83 80 2F 00 02 24 0B 00 62 54 ?? ?? 82 8F 01 00 85 80 04 00 A3 14 01 00 82 24 02 00 85 80 02 00 83 24 0A 10 65 00 00 00 40 A0 08 00 E0 03 21 10 80 00 ?? ?? 82 8F 08 00 E0 03 ?? ?? 42 24 }
	condition:
		$1
}

rule file_802_1_0 {
	meta:
		name = "xdrmem_getlong"
		size = 68
		altNames = "xdrmem_getint32"
	strings:
		$1 = { 14 00 83 8C 04 00 66 2C 0C 00 C0 14 21 10 00 00 0C 00 82 8C FC FF 63 24 14 00 83 AC 00 00 42 8C A0 10 02 7C 02 14 22 00 00 00 A2 AC 0C 00 82 8C 04 00 42 24 0C 00 82 AC 01 00 02 24 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_802_2_0 {
	meta:
		name = "xdrmem_putlong"
		size = 68
		altNames = "xdrmem_putint32"
	strings:
		$1 = { 14 00 83 8C 04 00 66 2C 0C 00 C0 14 21 10 00 00 FC FF 63 24 14 00 83 AC 00 00 A2 8C 0C 00 83 8C A0 10 02 7C 02 14 22 00 00 00 62 AC 0C 00 82 8C 04 00 42 24 0C 00 82 AC 01 00 02 24 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_802_3_0 {
	meta:
		name = "xdrmem_getpos"
		size = 16
	strings:
		$1 = { 0C 00 83 8C 10 00 82 8C 08 00 E0 03 23 10 62 00 }
	condition:
		$1
}

rule file_802_4_0 {
	meta:
		name = "xdrmem_setpos"
		size = 56
	strings:
		$1 = { 10 00 82 8C 0C 00 83 8C 21 28 45 00 14 00 82 8C 21 18 62 00 2A 30 65 00 05 00 C0 14 21 10 00 00 0C 00 85 AC 23 28 65 00 14 00 85 AC 01 00 02 24 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_802_5_0 {
	meta:
		name = "xdrmem_inline"
		size = 48
	strings:
		$1 = { 14 00 82 8C 2B 18 45 00 07 00 60 14 00 00 00 00 23 10 45 00 14 00 82 AC 0C 00 82 8C 21 28 45 00 08 00 E0 03 0C 00 85 AC 08 00 E0 03 21 10 00 00 }
	condition:
		$1
}

rule file_802_8_0 {
	meta:
		name = "xdrmem_putbytes"
		size = 112
		refs = "0000 _gp_disp 0038 __GI_memcpy"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D8 FF BD 27 20 00 B1 AF 1C 00 B0 AF 10 00 BC AF 24 00 BF AF 14 00 83 8C 21 80 80 00 21 88 C0 00 2B 20 66 00 0A 00 80 14 21 10 00 00 ?? ?? 99 8F 0C 00 04 8E 23 18 66 00 ?? ?? ?? ?? 14 00 03 AE 0C 00 02 8E 21 88 51 00 0C 00 11 AE 01 00 02 24 24 00 BF 8F 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_802_9_0 {
	meta:
		name = "xdrmem_getbytes"
		size = 116
		refs = "0000 _gp_disp 003c __GI_memcpy"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D8 FF BD 27 1C 00 B0 AF 21 80 80 00 14 00 03 8E 10 00 BC AF 21 20 A0 00 2B 28 66 00 20 00 B1 AF 24 00 BF AF 21 88 C0 00 0A 00 A0 14 21 10 00 00 ?? ?? 99 8F 0C 00 05 8E 23 18 66 00 ?? ?? ?? ?? 14 00 03 AE 0C 00 02 8E 21 88 51 00 0C 00 11 AE 01 00 02 24 24 00 BF 8F 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_802_10_0 {
	meta:
		name = "__GI_xdrmem_create"
		size = 44
		refs = "0000 _gp_disp"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F 00 00 87 AC 10 00 85 AC ?? ?? 42 24 04 00 82 AC 0C 00 85 AC 08 00 E0 03 14 00 86 AC }
	condition:
		$1
}

rule file_803_0_0 {
	meta:
		name = "calloc"
		size = 324
		refs = "0000 _gp_disp 0038 __pthread_mutex_unlock 003c __GI___errno_location 005c __malloc_lock 0060 _pthread_cleanup_push_defer 0078 __pthread_mutex_lock 0088 malloc 00ac _pthread_cleanup_pop_restore 00cc __GI_memset"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 C8 FF BD 27 10 00 BC AF 2C 00 B0 AF 34 00 BF AF 30 00 B1 AF 0D 00 80 10 02 80 85 70 1B 00 04 02 F4 01 80 00 12 20 00 00 09 00 A4 50 ?? ?? 85 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 0C 00 03 24 00 00 43 AC 37 00 00 10 21 10 00 00 ?? ?? 85 8F ?? ?? 86 8F ?? ?? 99 8F 18 00 B1 27 ?? ?? ?? ?? 21 20 20 02 10 00 BC 8F ?? ?? 84 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 00 02 21 80 40 00 20 00 40 10 10 00 BC 8F FC FF 42 8C 02 00 43 30 1D 00 60 14 ?? ?? 99 8F FC FF 06 24 24 30 46 00 FC FF C6 24 82 10 06 00 0A 00 43 2C 07 00 60 14 05 00 43 2C ?? ?? 99 8F 21 20 00 02 ?? ?? ?? ?? 21 28 00 00 0F 00 00 10 10 00 BC 8F 00 00 00 AE 04 00 00 AE 0B 00 60 14 08 00 00 AE 07 00 43 2C 0C 00 00 AE 07 00 60 14 10 00 00 AE 09 00 03 24 14 00 00 AE 03 00 43 14 18 00 00 AE 1C 00 00 AE 20 00 00 AE ?? ?? 99 8F 21 20 20 02 ?? ?? ?? ?? 01 00 05 24 21 10 00 02 34 00 BF 8F 30 00 B1 8F 2C 00 B0 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_805_0_0 {
	meta:
		name = "fsync"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 16 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_806_0_0 {
	meta:
		name = "__GI_ftruncate64"
		size = 88
		refs = "0000 _gp_disp 0030 __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 21 28 00 00 74 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_807_0_0 {
	meta:
		name = "umount"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF B6 0F 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_809_0_0 {
	meta:
		name = "__GI_strtok"
		size = 28
		refs = "0000 _gp_disp 0010 __GI_strtok_r"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 86 8F ?? ?? 99 8F ?? ?? ?? ?? ?? ?? C6 24 }
	condition:
		$1
}

rule file_811_0_0 {
	meta:
		name = "get_current_dir_name"
		size = 228
		refs = "0000 _gp_disp 0010 __GI_getenv 000c $LC0 0040 __GI_stat64 003c $LC1 0080 __GI_getcwd 00ac __GI_strdup"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 84 8F ?? ?? 99 8F 98 FE BD 27 10 00 BC AF 5C 01 B0 AF 64 01 BF AF 60 01 B1 AF ?? ?? ?? ?? ?? ?? 84 24 21 80 40 00 22 00 40 10 10 00 BC 8F ?? ?? 84 8F ?? ?? 91 8F B8 00 A5 27 21 C8 20 02 ?? ?? ?? ?? ?? ?? 84 24 1A 00 40 14 10 00 BC 8F 21 20 00 02 21 C8 20 02 ?? ?? ?? ?? 18 00 A5 27 14 00 40 14 10 00 BC 8F B8 00 A2 8F 18 00 A3 8F 11 00 62 14 ?? ?? 99 8F BC 00 A2 8F 1C 00 A3 8F 0E 00 62 14 21 20 00 00 C8 00 A2 8F 28 00 A3 8F 09 00 62 14 CC 00 A2 8F 2C 00 A3 8F 05 00 62 14 ?? ?? 99 8F ?? ?? ?? ?? 21 20 00 02 06 00 00 10 64 01 BF 8F ?? ?? 99 8F 21 20 00 00 ?? ?? ?? ?? 21 28 00 00 64 01 BF 8F 60 01 B1 8F 5C 01 B0 8F 08 00 E0 03 68 01 BD 27 }
	condition:
		$1
}

rule file_812_0_0 {
	meta:
		name = "getpgrp"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF E1 0F 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_813_0_0 {
	meta:
		name = "iruserfopen"
		size = 260
		refs = "0000 _gp_disp 0010 __GI_lstat 005c __GI_fopen 0058 $LC0 0078 __GI_fileno 008c __GI_fstat 00b0 __GI_fclose"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 40 FF BD 27 ?? ?? 99 8F B4 00 B1 AF 18 00 B1 27 10 00 BC AF B8 00 B2 AF B0 00 B0 AF BC 00 BF AF 21 90 A0 00 21 28 20 02 ?? ?? ?? ?? 21 80 80 00 2A 00 40 14 10 00 BC 8F 2C 00 A3 8F 00 80 02 34 00 F0 63 30 26 00 62 14 21 10 00 00 ?? ?? 85 8F ?? ?? 99 8F 21 20 00 02 ?? ?? ?? ?? ?? ?? A5 24 21 80 40 00 1D 00 40 10 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 40 00 10 00 BC 8F 21 20 40 00 ?? ?? 99 8F ?? ?? ?? ?? 21 28 20 02 10 00 40 04 10 00 BC 8F 34 00 A2 8F 04 00 40 50 2C 00 A2 8F 0C 00 52 14 ?? ?? 99 8F 2C 00 A2 8F 12 00 42 30 08 00 40 14 ?? ?? 99 8F 30 00 A2 8F 02 00 42 2C 04 00 40 10 21 10 00 02 06 00 00 10 BC 00 BF 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 00 02 21 10 00 00 BC 00 BF 8F B8 00 B2 8F B4 00 B1 8F B0 00 B0 8F 08 00 E0 03 C0 00 BD 27 }
	condition:
		$1
}

rule file_813_1_0 {
	meta:
		name = "__ivaliduser2.isra.1"
		size = 1116
		refs = "0000 _gp_disp 0014 $LC1 006c __GI_getline 0090 __GI___ctype_b 00d4 __GI_strcmp 0104 __GI_strchr 013c __GI___fgetc_unlocked 019c __GI___ctype_tolower 0294 malloc 0298 __GI_inet_addr 02cc __GI___errno_location 02e4 __GI_gethostbyname_r 031c free 0350 __GI_memcmp"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 80 FF BD 27 6C 00 B5 AF ?? ?? 95 8F 44 00 A3 27 40 00 B9 27 68 00 B4 AF 64 00 B3 AF 5C 00 B1 AF 18 00 BC AF 7C 00 BF AF 78 00 BE AF 74 00 B7 AF 70 00 B6 AF 60 00 B2 AF 58 00 B0 AF 21 88 80 00 21 98 A0 00 88 00 A6 AF 21 A0 E0 00 44 00 A0 AF 40 00 A0 AF 4C 00 A3 AF 50 00 B9 AF ?? ?? B5 26 ?? ?? 99 8F 44 00 A4 27 40 00 A5 27 ?? ?? ?? ?? 21 30 20 02 1C 00 40 18 18 00 BC 8F 44 00 A3 8F 40 00 A2 8F ?? ?? 86 8F 21 10 62 00 FF FF 40 A0 44 00 B2 8F 21 18 40 02 00 00 62 80 F0 FF 40 10 40 20 02 00 00 00 C5 8C 21 20 A4 00 00 00 84 94 20 00 84 30 0E 00 80 10 ?? ?? 96 8F F6 FF 00 10 01 00 63 24 21 20 A0 02 ?? ?? ?? ?? 21 28 C0 03 01 00 12 24 65 00 40 14 18 00 BC 8F FF FF 02 24 A7 00 42 16 00 00 00 00 C9 00 00 10 FF FF 10 24 23 00 03 24 DA FF 43 10 ?? ?? 99 8F 21 20 40 02 ?? ?? ?? ?? 0A 00 05 24 21 00 40 14 18 00 BC 8F 10 00 22 8E 18 00 23 8E 2B 18 43 00 04 00 60 10 01 00 43 24 10 00 23 AE 05 00 00 10 00 00 42 90 ?? ?? 99 8F ?? ?? ?? ?? 21 20 20 02 18 00 BC 8F ?? ?? 90 8F 0A 00 16 24 FF FF 12 24 C5 FF 56 10 ?? ?? 99 8F C4 FF 52 50 44 00 A4 27 10 00 22 8E 18 00 23 8E 2B 18 43 00 04 00 60 10 01 00 43 24 10 00 23 AE F5 FF 00 10 00 00 42 90 21 C8 00 02 ?? ?? ?? ?? 21 20 20 02 F0 FF 00 10 18 00 BC 8F ?? ?? 85 8F 00 00 42 82 0F 00 40 10 40 18 02 00 00 00 C4 8E 21 20 83 00 00 00 84 94 20 00 84 30 07 00 80 54 20 00 03 24 00 00 A2 8C 01 00 52 26 21 18 43 00 00 00 62 94 F2 FF 00 10 FF FF 42 A2 05 00 43 50 01 00 50 26 09 00 03 24 1A 00 43 14 21 80 40 02 01 00 50 26 00 00 40 A2 00 00 02 82 09 00 40 10 40 10 02 00 00 00 C3 8E 21 10 62 00 00 00 42 94 20 00 42 30 04 00 40 10 21 90 00 02 F6 FF 00 10 01 00 10 26 21 90 00 02 00 00 42 82 09 00 40 10 40 10 02 00 00 00 C3 8E 21 10 62 00 00 00 42 94 20 00 42 30 04 00 40 54 00 00 40 A2 F6 FF 00 10 01 00 52 26 00 00 40 A2 44 00 BE 8F 2D 00 02 24 3C 00 B3 AF 00 00 C4 93 99 FF 82 14 ?? ?? 99 8F 01 00 DE 27 FF FF 12 24 00 00 C2 83 00 00 C4 8E 40 10 02 00 21 10 82 00 00 00 42 94 08 00 42 30 0B 00 40 10 ?? ?? 99 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 C0 03 FF FF 04 24 04 00 44 10 18 00 BC 8F 26 10 62 02 8C FF 00 10 0B 90 02 00 ?? ?? 99 8F ?? ?? ?? ?? 00 04 04 24 18 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 B8 40 00 18 00 BC 8F 00 00 43 8C 21 B0 40 00 ?? ?? 99 8F 38 00 A2 27 10 00 A2 AF 34 00 A2 27 21 20 C0 03 48 00 A3 AF 14 00 A2 AF 20 00 A5 27 21 30 E0 02 ?? ?? ?? ?? 00 04 07 24 18 00 BC 8F 21 20 E0 02 05 00 40 10 ?? ?? 99 8F ?? ?? ?? ?? 21 90 00 00 16 00 00 10 18 00 BC 8F ?? ?? ?? ?? 00 00 00 00 48 00 B9 8F 38 00 A2 8F 18 00 BC 8F 0E 00 40 10 00 00 D9 AE 10 00 56 8C ?? ?? 9E 8F 3C 00 B7 27 00 00 C5 8E 08 00 A0 10 21 20 E0 02 21 C8 C0 03 ?? ?? ?? ?? 04 00 06 24 5D FF 40 10 18 00 BC 8F F7 FF 00 10 04 00 D6 26 21 90 00 00 59 FF 00 10 FF FF 02 24 38 FF 40 12 ?? ?? 99 8F 00 00 02 82 88 00 A3 8F 0A 80 62 00 00 00 03 92 2D 00 02 24 09 00 62 14 ?? ?? 92 8F 01 00 04 26 21 C8 40 02 ?? ?? ?? ?? 21 28 80 02 01 00 42 2C 18 00 BC 8F 0E 00 00 10 23 10 02 00 21 20 A0 02 21 C8 40 02 ?? ?? ?? ?? 21 28 00 02 0D 00 40 10 18 00 BC 8F 21 20 80 02 21 C8 40 02 ?? ?? ?? ?? 21 28 00 02 01 00 42 2C 06 00 40 14 18 00 BC 8F FF FF 03 24 19 FF 43 14 ?? ?? 99 8F 02 00 00 10 FF FF 10 24 21 80 00 00 ?? ?? 99 8F ?? ?? ?? ?? 44 00 A4 8F 7C 00 BF 8F 21 10 00 02 78 00 BE 8F 74 00 B7 8F 70 00 B6 8F 6C 00 B5 8F 68 00 B4 8F 64 00 B3 8F 60 00 B2 8F 5C 00 B1 8F 58 00 B0 8F 08 00 E0 03 80 00 BD 27 }
	condition:
		$1
}

rule file_813_2_0 {
	meta:
		name = "iruserok2.isra.2"
		size = 592
		refs = "0000 _gp_disp 005c $LC2 0068 iruserfopen 0090 __ivaliduser2.isra.1 00a0 __GI_fclose 00b8 __check_rhosts_file 00c8 __GI_sysconf 00e4 __GI_getpwnam_r 011c __GI_strlen 0130 malloc 0148 __GI_strcpy 0160 __GI_strcat 015c $LC3 0170 __GI_geteuid 0188 __GI_seteuid 01bc free"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 98 FF BD 27 60 00 BE AF 21 F0 A0 03 54 00 B5 AF 50 00 B4 AF 4C 00 B3 AF 48 00 B2 AF 64 00 BF AF 5C 00 B7 AF 58 00 B6 AF 44 00 B1 AF 40 00 B0 AF 18 00 BC AF 21 A8 80 00 21 98 A0 00 21 A0 C0 00 03 00 A0 10 21 90 E0 00 18 00 00 10 FF FF 10 24 ?? ?? 84 8F ?? ?? 99 8F ?? ?? 39 27 ?? ?? ?? ?? ?? ?? 84 24 21 88 40 00 F7 FF 40 10 18 00 DC 8F ?? ?? 99 8F 21 20 40 00 21 28 A0 02 21 30 40 02 ?? ?? 39 27 ?? ?? ?? ?? 21 38 80 02 18 00 DC 8F 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 21 20 20 02 18 00 DC 8F 59 00 00 12 21 18 00 00 ?? ?? 82 8F 00 00 42 8C 25 98 62 02 53 00 60 12 ?? ?? 99 8F ?? ?? ?? ?? 46 00 04 24 18 00 DC 8F 0E 00 43 24 C2 18 03 00 C0 18 03 00 ?? ?? 99 8F 23 E8 A3 03 3C 00 C3 27 10 00 A3 AF 21 20 40 02 20 00 C5 27 18 00 A6 27 ?? ?? ?? ?? 21 38 40 00 18 00 DC 8F 42 00 40 14 FF FF 03 24 3C 00 C2 8F 3F 00 40 10 ?? ?? 99 8F 14 00 53 8C ?? ?? ?? ?? 21 20 60 02 18 00 DC 8F ?? ?? 99 8F ?? ?? ?? ?? 09 00 44 24 18 00 DC 8F 21 28 60 02 21 20 40 00 ?? ?? 99 8F ?? ?? ?? ?? 21 88 40 00 18 00 DC 8F 21 20 20 02 ?? ?? 85 8F ?? ?? 99 8F ?? ?? ?? ?? ?? ?? A5 24 18 00 DC 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 18 00 DC 8F 21 B8 40 00 3C 00 C2 8F ?? ?? 96 8F 21 C8 C0 02 ?? ?? ?? ?? 08 00 44 8C 18 00 DC 8F 3C 00 C2 8F 21 20 20 02 ?? ?? 99 8F ?? ?? 39 27 ?? ?? ?? ?? 08 00 45 8C 18 00 DC 8F 21 98 40 00 ?? ?? 99 8F ?? ?? ?? ?? 21 20 20 02 0D 00 60 12 18 00 DC 8F ?? ?? 99 8F 21 20 60 02 21 28 A0 02 21 30 40 02 ?? ?? 39 27 ?? ?? ?? ?? 21 38 80 02 18 00 DC 8F 21 20 60 02 ?? ?? 99 8F ?? ?? ?? ?? 21 80 40 00 21 C8 C0 02 ?? ?? ?? ?? 21 20 E0 02 02 00 00 10 21 18 00 02 FF FF 03 24 21 E8 C0 03 64 00 BF 8F 60 00 BE 8F 5C 00 B7 8F 58 00 B6 8F 54 00 B5 8F 50 00 B4 8F 4C 00 B3 8F 48 00 B2 8F 44 00 B1 8F 40 00 B0 8F 21 10 60 00 08 00 E0 03 68 00 BD 27 }
	condition:
		$1
}

rule file_813_3_0 {
	meta:
		name = "__GI_rresvport"
		size = 308
		refs = "0000 _gp_disp 000c __GI_socket 0068 __GI_bind 006c __GI___errno_location 00c4 __GI_close"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F B0 FF BD 27 02 00 02 24 02 00 05 24 10 00 BC AF 30 00 B1 AF 2C 00 B0 AF 4C 00 BF AF 48 00 B7 AF 44 00 B6 AF 40 00 B5 AF 3C 00 B4 AF 38 00 B3 AF 34 00 B2 AF 21 88 80 00 18 00 A2 A7 1C 00 A0 AF 02 00 04 24 ?? ?? ?? ?? 21 30 00 00 21 80 40 00 26 00 40 04 10 00 BC 8F ?? ?? 95 8F ?? ?? 96 8F 18 00 B4 27 7D 00 17 24 00 02 13 24 00 00 22 8E 21 20 00 02 21 28 80 02 00 1A 02 00 00 3A 42 7C 25 10 62 00 1A 00 A2 A7 21 C8 A0 02 ?? ?? ?? ?? 10 00 06 24 17 00 41 04 21 C8 C0 02 ?? ?? ?? ?? 00 00 00 00 21 90 40 00 00 00 42 8C 06 00 57 10 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 00 02 0D 00 00 10 FF FF 02 24 00 00 22 8E FF FF 42 24 E6 FF 53 14 00 00 22 AE ?? ?? 99 8F ?? ?? ?? ?? 21 20 00 02 0B 00 02 24 00 00 42 AE 02 00 00 10 FF FF 02 24 21 10 00 02 4C 00 BF 8F 48 00 B7 8F 44 00 B6 8F 40 00 B5 8F 3C 00 B4 8F 38 00 B3 8F 34 00 B2 8F 30 00 B1 8F 2C 00 B0 8F 08 00 E0 03 50 00 BD 27 }
	condition:
		$1
}

rule file_813_4_0 {
	meta:
		name = "rcmd"
		size = 1952
		refs = "0000 _gp_disp 0010 __GI_getpid 0068 __GI_gethostbyname_r 006c __GI___errno_location 00dc __GI___h_errno_location 00f0 __GI_herror 013c __GI_sigblock 0164 __GI_rresvport 0198 stderr 01a0 __GI_fputs 019c $LC4 01bc __GI_fprintf 01b8 $LC5 01d4 __GI_fcntl 021c __GI_memmove 0238 __GI_connect 0258 __GI_close 02b0 __GI_sleep 02e0 __GI_inet_ntoa 0318 $LC6 0330 __GI_perror 039c $LC7 03b4 $LC8 03ec __GI_write 03e8 $LC9 042c __GI_listen 044c __GI_snprintf 0448 $LC10 0464 __GI_strlen 04b4 $LC11 04e0 __GI_poll 0508 __GI_accept 0518 $LC12 0538 $LC13 0584 $LC14 05e4 $LC15 067c __GI_read 069c $LC16 06c8 __GI_sigsetmask"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 30 FF BD 27 ?? ?? 99 8F FF FF A5 30 C8 00 BE AF 21 F0 A0 03 C4 00 B7 AF C0 00 B6 AF BC 00 B5 AF B8 00 B4 AF B4 00 B3 AF B0 00 B2 AF AC 00 B1 AF 18 00 BC AF CC 00 BF AF A8 00 B0 AF 84 00 C5 AF 21 A8 C0 00 21 90 80 00 ?? ?? ?? ?? 21 A0 E0 00 18 00 DC 8F 74 00 D9 27 F8 FB BD 27 ?? ?? 93 8F ?? ?? 91 8F 88 00 D9 AF 20 00 D9 27 80 00 C2 AF 18 00 A6 27 00 04 16 24 78 00 D7 27 8C 00 D9 AF 00 00 44 8E 74 00 C2 27 10 00 A2 AF 14 00 B7 AF 20 00 C5 27 21 C8 60 02 ?? ?? ?? ?? 21 38 C0 02 1C 00 40 10 18 00 DC 8F 78 00 D0 8F FF FF 02 24 07 00 02 16 21 C8 20 02 ?? ?? ?? ?? 00 00 00 00 00 00 44 8C 22 00 02 24 0B 00 82 10 18 00 DC 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 18 00 DC 8F 00 00 50 AC ?? ?? 99 8F ?? ?? ?? ?? 00 00 44 8E 9B 01 00 10 FF FF 02 24 40 B0 16 00 0E 00 C2 26 C2 10 02 00 C0 10 02 00 23 E8 A2 03 DC FF 00 10 18 00 A6 27 74 00 C2 8F E4 FF 40 10 78 00 D0 8F 01 00 03 24 38 00 C3 A7 40 00 C3 A7 00 00 42 8C ?? ?? 99 8F 10 00 04 3C ?? ?? ?? ?? 00 00 42 AE 18 00 DC 8F 21 88 40 00 FF 03 02 24 70 00 C2 AF 01 00 13 24 70 00 D6 27 ?? ?? 99 8F ?? ?? ?? ?? 21 20 C0 02 21 80 40 00 17 00 41 04 18 00 DC 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 44 8C 18 00 DC 8F 0B 00 03 24 08 00 83 14 ?? ?? 82 8F ?? ?? 84 8F ?? ?? 99 8F 00 00 45 8C ?? ?? ?? ?? ?? ?? 84 24 6A 01 00 10 18 00 DC 8F ?? ?? 85 8F ?? ?? 99 8F 00 00 44 8C ?? ?? ?? ?? ?? ?? A5 24 63 01 00 10 18 00 DC 8F ?? ?? 99 8F 80 00 C6 8F 21 20 40 00 ?? ?? ?? ?? 18 00 05 24 74 00 C2 8F 18 00 DC 8F 58 00 D7 27 08 00 43 8C 21 20 E0 02 54 00 C3 A7 10 00 43 8C 0C 00 42 8C 00 00 65 8C 05 00 46 2C 04 00 03 24 0B 18 46 00 21 30 60 00 ?? ?? 83 8F 21 C8 60 00 ?? ?? ?? ?? A0 00 C3 AF 18 00 DC 8F 84 00 D9 8F 21 20 00 02 ?? ?? 82 8F 56 00 D9 A7 54 00 C5 27 21 C8 40 00 ?? ?? ?? ?? 10 00 06 24 60 00 41 04 18 00 DC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 00 02 18 00 DC 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 47 8C 21 40 40 00 7D 00 02 24 05 00 E2 14 18 00 DC 8F 70 00 C2 8F FF FF 42 24 B4 FF 00 10 70 00 C2 AF 92 00 02 24 0A 00 E2 14 74 00 C2 8F 11 00 62 2A 07 00 40 10 74 00 C2 8F ?? ?? 99 8F 21 20 60 02 ?? ?? ?? ?? 40 98 13 00 A8 FF 00 10 18 00 DC 8F ?? ?? 90 8F 10 00 43 8C 04 00 64 8C 37 00 80 10 ?? ?? 83 8F 00 00 65 8C ?? ?? 89 8F 58 00 C4 8F A0 00 C3 AF 21 C8 20 01 9C 00 C9 AF 98 00 C7 AF 94 00 C8 AF ?? ?? ?? ?? 90 00 C5 AF 18 00 DC 8F 90 00 C5 8F 21 30 40 00 21 C8 00 02 21 20 A0 00 ?? ?? 85 8F ?? ?? ?? ?? ?? ?? A5 24 18 00 DC 8F 94 00 C8 8F 98 00 C7 8F ?? ?? 82 8F 21 20 00 00 21 C8 40 00 ?? ?? ?? ?? 00 00 07 AD 74 00 C2 8F 18 00 DC 8F 04 00 06 24 10 00 45 8C ?? ?? 99 8F 04 00 A4 24 10 00 44 AC 0C 00 42 8C 04 00 A5 8C 21 20 E0 02 05 00 47 2C ?? ?? ?? ?? 0B 30 47 00 9C 00 C9 8F A0 00 C3 8F 58 00 C4 8F 21 C8 20 01 09 F8 20 03 00 00 77 8C 18 00 DC 8F 21 20 E0 02 21 30 40 00 ?? ?? 85 8F 21 C8 00 02 ?? ?? ?? ?? ?? ?? A5 24 6D FF 00 10 18 00 DC 8F ?? ?? 85 8F 00 00 64 8C 00 00 46 8C 21 C8 00 02 ?? ?? ?? ?? ?? ?? A5 24 E3 00 00 10 18 00 DC 8F 70 00 C2 8F E4 00 D9 8F FF FF 42 24 0A 00 20 17 70 00 C2 AF ?? ?? 85 8F ?? ?? 99 8F 21 20 00 02 ?? ?? A5 24 ?? ?? ?? ?? 01 00 06 24 18 00 DC 8F 7E 00 00 10 70 00 C0 AF ?? ?? 99 8F ?? ?? ?? ?? 21 20 C0 02 21 98 40 00 10 00 02 24 18 00 DC 8F C9 00 60 06 6C 00 C2 AF ?? ?? 99 8F 21 20 60 02 ?? ?? ?? ?? 01 00 05 24 18 00 DC 8F 70 00 C7 8F 64 00 D6 27 ?? ?? 86 8F ?? ?? 99 8F 21 20 C0 02 08 00 05 24 ?? ?? ?? ?? ?? ?? C6 24 18 00 DC 8F ?? ?? 97 8F 21 C8 E0 02 ?? ?? ?? ?? 21 20 C0 02 18 00 DC 8F 21 28 C0 02 21 20 00 02 ?? ?? 99 8F ?? ?? ?? ?? 01 00 46 24 A0 00 C2 AF 21 C8 E0 02 ?? ?? ?? ?? 21 20 C0 02 18 00 DC 8F A0 00 C3 8F 01 00 42 24 06 00 62 10 ?? ?? 96 8F ?? ?? 82 8F ?? ?? 85 8F 00 00 44 8C 19 00 00 10 ?? ?? A5 24 ?? ?? 99 8F 34 00 D0 AF ?? ?? ?? ?? 3C 00 D3 AF 18 00 DC 8F 34 00 C4 27 00 00 40 AC ?? ?? 99 8F 02 00 05 24 FF FF 06 24 ?? ?? ?? ?? 21 B8 40 00 05 00 40 18 18 00 DC 8F 42 00 C2 97 01 00 42 30 14 00 40 14 ?? ?? 99 8F 00 00 E3 8E 09 00 60 10 ?? ?? 82 8F ?? ?? 85 8F 00 00 44 8C ?? ?? A5 24 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 06 00 00 10 00 00 00 00 ?? ?? 84 8F 00 00 45 8C ?? ?? 99 8F ?? ?? ?? ?? ?? ?? 84 24 21 20 60 02 7B 00 00 10 21 C8 C0 02 21 20 60 02 44 00 C5 27 ?? ?? ?? ?? 6C 00 C6 27 21 B8 40 00 21 C8 C0 02 ?? ?? ?? ?? 21 20 60 02 0A 00 E1 06 18 00 DC 8F ?? ?? 82 8F ?? ?? 85 8F ?? ?? 99 8F 00 00 44 8C ?? ?? ?? ?? ?? ?? A5 24 18 00 DC 8F 6B 00 00 10 70 00 C0 AF 46 00 C3 97 E4 00 D9 8F 44 00 C4 97 00 12 03 00 FF FF 42 30 02 1A 03 00 25 10 43 00 02 00 03 24 00 00 37 AF 05 00 83 14 46 00 C2 A7 00 FE 42 24 00 02 42 2C 0A 00 40 14 ?? ?? 96 8F ?? ?? 82 8F ?? ?? 84 8F ?? ?? 99 8F 00 00 45 8C ?? ?? ?? ?? ?? ?? 84 24 2F 00 00 10 18 00 DC 8F ?? ?? 96 8F 21 C8 C0 02 ?? ?? ?? ?? 21 20 A0 02 18 00 DC 8F 21 28 A0 02 01 00 46 24 ?? ?? 93 8F 21 C8 60 02 ?? ?? ?? ?? 21 20 00 02 21 C8 C0 02 ?? ?? ?? ?? 21 20 80 02 01 00 46 24 21 28 80 02 21 C8 60 02 ?? ?? ?? ?? 21 20 00 02 E0 00 C4 8F 21 C8 C0 02 ?? ?? ?? ?? 64 00 D4 27 E0 00 C5 8F 21 20 00 02 21 C8 60 02 ?? ?? ?? ?? 01 00 46 24 18 00 DC 8F 21 20 00 02 21 28 80 02 ?? ?? 95 8F 21 C8 A0 02 ?? ?? ?? ?? 01 00 06 24 01 00 03 24 0B 00 43 10 18 00 DC 8F ?? ?? 82 8F ?? ?? 85 8F ?? ?? 99 8F 00 00 44 8C 00 00 46 8E ?? ?? ?? ?? ?? ?? A5 24 18 00 DC 8F 1C 00 00 10 70 00 C2 8F 64 00 C2 83 14 00 40 10 ?? ?? 99 8F 0A 00 12 24 21 20 00 02 21 28 80 02 21 C8 A0 02 ?? ?? ?? ?? 01 00 06 24 01 00 03 24 0F 00 43 14 18 00 DC 8F 02 00 04 24 21 28 80 02 21 C8 60 02 ?? ?? ?? ?? 01 00 06 24 64 00 C2 83 F1 FF 52 14 18 00 DC 8F 06 00 00 10 70 00 C2 8F ?? ?? ?? ?? 21 20 20 02 12 00 00 10 21 10 00 02 70 00 C2 8F 08 00 40 10 ?? ?? 99 8F E4 00 D9 8F 00 00 24 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 18 00 DC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 00 02 18 00 DC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 20 02 FF FF 02 24 21 E8 C0 03 CC 00 BF 8F C8 00 BE 8F C4 00 B7 8F C0 00 B6 8F BC 00 B5 8F B8 00 B4 8F B4 00 B3 8F B0 00 B2 8F AC 00 B1 8F A8 00 B0 8F 08 00 E0 03 D0 00 BD 27 }
	condition:
		$1
}

rule file_813_5_0 {
	meta:
		name = "ruserok"
		size = 380
		refs = "0000 _gp_disp 0024 __GI_gethostbyname_r 0028 __GI___errno_location 010c __GI_memcpy 012c iruserok2.isra.2"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 90 FF BD 27 68 00 BE AF 21 F0 A0 03 64 00 B7 AF 60 00 B6 AF 3C 00 D9 27 ?? ?? 96 8F ?? ?? 97 8F 5C 00 B5 AF 58 00 B4 AF 54 00 B3 AF 50 00 B2 AF 4C 00 B1 AF 48 00 B0 AF 6C 00 BF AF 18 00 BC AF 40 00 D9 AF F8 FB BD 27 34 00 D9 27 21 88 C0 00 21 98 80 00 21 80 A0 00 21 90 E0 00 18 00 A6 27 00 04 14 24 44 00 D9 AF 20 00 D5 27 3C 00 C2 27 34 00 D9 27 14 00 B9 AF 10 00 A2 AF 21 20 60 02 21 28 A0 02 21 C8 C0 02 ?? ?? ?? ?? 21 38 80 02 13 00 40 10 18 00 DC 8F 34 00 C4 8F FF FF 02 24 03 00 82 10 21 C8 E0 02 24 00 00 10 FF FF 02 24 ?? ?? ?? ?? 00 00 00 00 00 00 44 8C 22 00 02 24 F9 FF 82 14 40 A0 14 00 0E 00 82 26 C2 10 02 00 C0 10 02 00 23 E8 A2 03 E4 FF 00 10 18 00 A6 27 3C 00 C2 8F ED FF 40 10 34 00 C4 8F 10 00 53 8C ?? ?? 95 8F 38 00 D4 27 00 00 65 8E EA FF A0 10 ?? ?? 99 8F 21 20 80 02 ?? ?? ?? ?? 04 00 06 24 38 00 C4 8F 21 28 00 02 21 30 20 02 ?? ?? B9 26 ?? ?? ?? ?? 21 38 40 02 03 00 40 10 18 00 DC 8F F1 FF 00 10 04 00 73 26 21 10 00 00 21 E8 C0 03 6C 00 BF 8F 68 00 BE 8F 64 00 B7 8F 60 00 B6 8F 5C 00 B5 8F 58 00 B4 8F 54 00 B3 8F 50 00 B2 8F 4C 00 B1 8F 48 00 B0 8F 08 00 E0 03 70 00 BD 27 }
	condition:
		$1
}

rule file_814_0_0 {
	meta:
		name = "wait"
		size = 60
		refs = "0000 _gp_disp 000c __GI_wait4"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F E0 FF BD 27 21 28 80 00 FF FF 04 24 1C 00 BF AF 10 00 BC AF 21 30 00 00 ?? ?? ?? ?? 21 38 00 00 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_815_0_0 {
	meta:
		name = "__GI_asctime_r"
		size = 404
		refs = "0000 _gp_disp 0020 __GI_memcpy"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 18 00 B0 AF 21 80 80 00 21 20 A0 00 ?? ?? 85 8F ?? ?? 99 8F 10 00 BC AF 1C 00 BF AF ?? ?? A5 24 ?? ?? ?? ?? 1A 00 06 24 18 00 04 8E 21 18 40 00 07 00 82 2C 0C 00 40 10 10 00 BC 8F 03 00 05 24 02 30 85 70 ?? ?? 82 8F ?? ?? 42 24 21 10 C2 00 00 00 44 90 00 00 64 A0 01 00 44 90 02 00 42 90 01 00 64 A0 02 00 62 A0 10 00 02 8E 0C 00 44 2C 0E 00 80 50 14 00 04 8E 03 00 05 24 02 10 45 70 ?? ?? 85 8F ?? ?? A5 24 15 00 42 24 21 10 A2 00 00 00 45 90 04 00 65 A0 01 00 45 90 02 00 42 90 05 00 65 A0 06 00 62 A0 14 00 04 8E 6C 07 84 24 10 27 82 2C 03 00 40 54 17 00 62 24 0C 00 00 10 13 00 62 24 3F 00 05 24 0A 00 03 24 1A 00 83 00 F4 01 60 00 FF FF 42 24 10 30 00 00 30 00 C6 24 01 00 46 A0 00 00 46 80 F8 FF C5 10 12 20 00 00 3F 00 04 24 0A 00 05 24 30 00 06 24 FF FF 43 80 21 18 03 02 00 00 63 8C 64 00 67 2C 04 00 E0 14 00 00 00 00 FF FF 44 A0 0A 00 00 10 FE FF 44 A0 1A 00 65 00 F4 01 A0 00 10 38 00 00 30 00 E7 24 FF FF 47 A0 FE FF 47 90 12 18 00 00 21 18 67 00 FE FF 43 A0 FB FF 43 80 03 00 66 14 FD FF 47 24 EA FF 00 10 21 10 E0 00 FE FF 44 80 30 00 03 24 04 00 83 14 1C 00 BF 8F 20 00 03 24 FE FF 43 A0 1C 00 BF 8F 18 00 B0 8F F6 FF 42 24 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_816_0_0 {
	meta:
		name = "__parsespent"
		size = 292
		refs = "0000 _gp_disp 0020 __GI_strchr 0024 __GI_strtoul"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 B8 FF BD 27 2C 00 B3 AF ?? ?? 93 8F 3C 00 B7 AF 34 00 B5 AF ?? ?? 97 8F ?? ?? 95 8F 38 00 B6 AF 30 00 B4 AF 28 00 B2 AF 24 00 B1 AF 20 00 B0 AF 10 00 BC AF 44 00 BF AF 40 00 BE AF 21 90 80 00 21 88 A0 00 21 80 00 00 ?? ?? 73 26 18 00 B4 27 FF FF 16 24 21 10 13 02 00 00 5E 90 02 00 02 2A 0A 00 40 10 21 F0 5E 02 00 00 D1 AF 21 20 20 02 21 C8 E0 02 ?? ?? ?? ?? 3A 00 05 24 16 00 40 14 21 18 40 00 18 00 00 10 16 00 02 24 21 20 20 02 21 28 80 02 21 C8 A0 02 ?? ?? ?? ?? 0A 00 06 24 18 00 A3 8F 26 88 71 00 0A 10 D1 02 00 00 C2 AF 08 00 02 24 05 00 02 56 00 00 64 80 00 00 63 80 16 00 02 24 08 00 00 10 0A 10 03 00 3A 00 02 24 05 00 82 14 16 00 02 24 01 00 71 24 00 00 60 A0 DC FF 00 10 01 00 10 26 44 00 BF 8F 40 00 BE 8F 3C 00 B7 8F 38 00 B6 8F 34 00 B5 8F 30 00 B4 8F 2C 00 B3 8F 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 08 00 E0 03 48 00 BD 27 }
	condition:
		$1
}

rule file_817_0_0 {
	meta:
		name = "__GI_lstat"
		size = 120
		refs = "0000 _gp_disp 0034 __GI___errno_location 0054 __xstat_conv"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 50 FF BD 27 10 00 BC AF 21 30 A0 00 AC 00 BF AF A8 00 B0 AF 18 00 A5 27 0B 10 02 24 0C 00 00 00 07 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC 07 00 00 10 FF FF 10 24 06 00 40 14 AC 00 BF 8F ?? ?? 99 8F 18 00 A4 27 ?? ?? ?? ?? 21 28 C0 00 AC 00 BF 8F 21 10 00 02 A8 00 B0 8F 08 00 E0 03 B0 00 BD 27 }
	condition:
		$1
}

rule file_818_0_0 {
	meta:
		name = "__GI_setitimer"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 08 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_819_0_0 {
	meta:
		name = "stime"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF B9 0F 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_821_0_0 {
	meta:
		name = "__GI_getrlimit"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF EC 0F 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_822_1_0 {
	meta:
		name = "__glob_sort"
		size = 28
		refs = "0000 _gp_disp 0010 __GI_strcmp"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 00 00 84 8C ?? ?? 99 8F ?? ?? ?? ?? 00 00 A5 8C }
	condition:
		$1
}

rule file_822_2_0 {
	meta:
		name = "__glob_is_literal"
		size = 152
	strings:
		$1 = { 21 18 00 00 5B 00 06 24 5C 00 07 24 5D 00 08 24 2A 00 09 24 3F 00 0A 24 00 00 82 80 1C 00 40 50 01 00 02 24 17 00 46 10 5C 00 4B 28 07 00 60 11 00 00 00 00 16 00 49 50 21 10 00 00 14 00 4A 10 21 10 00 00 F4 FF 00 10 01 00 84 24 05 00 47 10 00 00 00 00 07 00 48 10 00 00 00 00 EE FF 00 10 01 00 84 24 EC FF A0 50 01 00 84 24 08 00 E0 03 21 10 00 00 E8 FF 60 50 01 00 84 24 08 00 E0 03 21 10 00 00 01 00 03 24 E3 FF 00 10 01 00 84 24 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_822_3_0 {
	meta:
		name = "__glob_append"
		size = 172
		refs = "0000 _gp_disp 000c malloc 0050 __GI_strcpy 0074 __GI_strcat 0070 $LC0"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F D0 FF BD 27 10 00 BC AF 28 00 B2 AF 24 00 B1 AF 20 00 B0 AF 18 00 A5 AF 2C 00 BF AF 21 88 80 00 09 00 C4 24 ?? ?? ?? ?? 21 90 E0 00 21 80 40 00 10 00 BC 8F 12 00 40 10 18 00 A5 8F 00 00 22 8E ?? ?? 99 8F 04 00 03 26 00 00 50 AC 21 20 60 00 ?? ?? ?? ?? 00 00 00 AE 06 00 40 12 10 00 BC 8F ?? ?? 85 8F ?? ?? 99 8F 21 20 40 00 ?? ?? ?? ?? ?? ?? A5 24 00 00 30 AE 02 00 00 10 21 10 00 00 FF FF 02 24 2C 00 BF 8F 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_822_4_0 {
	meta:
		name = "__glob_match_in_dir"
		size = 1144
		refs = "0000 _gp_disp 0014 __GI_strlen 008c __GI_strchr 00b8 __GI_strcpy 00f0 __glob_is_literal 0124 $LC1 0134 __GI_opendir 0144 __GI___errno_location 0184 __GI_stat64 01b0 __glob_append 0208 __GI_fnmatch 0224 __GI_readdir64_r 0244 __GI_closedir 031c __GI_memcpy 037c __glob_match_in_dir 0430 __GI_strcmp"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FC BD 27 00 03 B2 AF ?? ?? 92 8F 18 03 BE AF 21 F0 A0 03 1C 03 BF AF 18 00 BC AF 10 03 B6 AF 0C 03 B5 AF 08 03 B4 AF 04 03 B3 AF FC 02 B1 AF F8 02 B0 AF 14 03 B7 AF 21 C8 40 02 2C 03 C7 AF 21 80 80 00 21 20 A0 00 21 88 A0 00 ?? ?? ?? ?? 21 B0 C0 00 08 00 42 24 C2 10 02 00 C0 10 02 00 23 E8 A2 03 21 C8 40 02 ?? ?? ?? ?? 21 20 00 02 18 00 DC 8F 21 90 40 00 40 00 D4 32 04 00 02 24 ?? ?? 99 8F 06 00 03 24 0A 18 54 00 E0 02 C3 AF 21 20 20 02 ?? ?? ?? ?? 2F 00 05 24 18 00 B5 27 18 00 DC 8F 0F 00 40 10 21 98 40 00 ?? ?? 99 8F 21 28 20 02 23 88 71 02 21 20 A0 02 ?? ?? ?? ?? 21 88 B1 02 18 00 DC 8F 2F 00 02 24 00 00 20 A2 00 00 63 82 03 00 62 14 21 88 A0 02 FC FF 00 10 01 00 73 26 ?? ?? 99 8F 21 20 20 02 ?? ?? ?? ?? 01 00 85 2E E8 02 C2 AF 00 00 02 82 2F 00 03 24 04 00 43 14 18 00 DC 8F 01 00 02 82 03 00 00 10 0A 90 02 00 03 00 40 50 ?? ?? 84 8F 02 00 00 10 21 20 00 02 ?? ?? 84 24 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 18 00 DC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 A0 40 00 00 00 55 8C 4C 00 80 16 18 00 DC 8F 14 00 02 24 03 00 A2 56 0D 00 02 24 B6 00 00 10 21 10 00 00 3A 00 A2 16 2C 03 D9 8F 00 00 22 82 38 00 40 14 21 20 00 02 ?? ?? 99 8F ?? ?? ?? ?? 20 00 C5 27 31 00 40 14 18 00 DC 8F 38 00 C3 8F 00 40 02 24 00 F0 63 30 2D 00 62 14 2C 03 D9 8F 30 03 C4 8F ?? ?? 99 8F 21 28 00 02 21 30 40 02 ?? ?? ?? ?? 21 38 40 02 9F 00 00 10 2B 10 02 00 D8 02 C5 8F 1C 00 A0 10 E8 02 C3 8F 10 00 A2 94 E4 02 DD AF 21 10 42 02 09 00 42 24 C2 10 02 00 C0 10 02 00 23 E8 A2 03 18 00 B7 27 21 A8 E0 02 13 00 A5 24 8B 00 60 14 21 20 20 02 ?? ?? 99 8F ?? ?? ?? ?? E0 02 C6 8F 18 00 DC 8F 31 00 40 10 00 00 00 00 E4 02 DD 8F ?? ?? 99 8F 21 20 80 02 20 00 C5 27 ?? ?? ?? ?? D8 02 C6 27 21 A8 40 00 E3 FF 40 10 18 00 DC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 80 02 7C 00 A0 12 21 10 00 00 2C 03 D9 8F 21 20 00 02 09 F8 20 03 21 28 A0 02 03 00 40 10 01 00 D6 32 74 00 00 10 02 00 02 24 72 00 C0 16 02 00 02 24 70 00 00 10 21 10 00 00 00 00 22 82 0E 00 40 14 D8 02 D9 27 ?? ?? 99 8F 30 03 C4 8F 21 28 00 02 21 30 40 02 ?? ?? ?? ?? 21 38 40 02 18 00 DC 8F 2B 80 02 00 ?? ?? 99 8F ?? ?? ?? ?? 21 20 80 02 60 00 00 10 21 10 00 02 EC 02 D9 AF 20 00 C3 27 02 00 D9 32 F0 02 C3 AF D2 FF 00 10 F4 02 D9 AF 0B 00 60 12 D8 02 C2 8F 12 00 42 90 09 00 40 50 00 00 02 82 00 13 02 00 FF FF 42 30 00 40 03 24 03 00 43 10 00 A0 03 34 C6 FF 43 54 E4 02 DD 8F 00 00 02 82 12 00 40 50 D8 02 D5 8F ?? ?? 99 8F 21 20 E0 02 21 28 00 02 ?? ?? ?? ?? 21 30 40 02 18 00 DC 8F D8 02 C5 8F 21 10 F2 02 ?? ?? 99 8F 2F 00 03 24 01 00 44 26 00 00 43 A0 21 20 E4 02 ?? ?? ?? ?? 13 00 A5 24 02 00 00 10 18 00 DC 8F 13 00 B5 26 10 00 60 12 30 03 D9 8F 21 20 A0 02 21 28 60 02 10 00 B9 AF 2C 03 C7 8F ?? ?? 99 8F ?? ?? ?? ?? 21 30 C0 02 21 A8 40 00 A4 FF 40 10 18 00 DC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 80 02 21 00 00 10 21 10 A0 02 F4 02 C3 8F 10 00 60 10 21 38 00 00 D8 02 C2 8F 12 00 47 90 03 00 E0 10 00 3B 07 00 08 00 00 10 FF FF E7 30 ?? ?? 99 8F 21 20 A0 02 ?? ?? ?? ?? 38 02 C5 27 50 02 C7 8F 18 00 DC 8F 00 F0 E7 30 00 40 E7 38 01 00 E7 2C D8 02 C2 8F ?? ?? 99 8F 30 03 C4 8F 10 00 46 94 21 28 A0 02 01 00 C6 24 ?? ?? ?? ?? 21 30 D2 00 83 FF 40 10 18 00 DC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 80 02 01 00 02 24 06 00 00 10 E4 02 DD 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 76 FF 00 10 18 00 DC 8F 21 E8 C0 03 1C 03 BF 8F 18 03 BE 8F 14 03 B7 8F 10 03 B6 8F 0C 03 B5 8F 08 03 B4 8F 04 03 B3 8F 00 03 B2 8F FC 02 B1 8F F8 02 B0 8F 08 00 E0 03 20 03 BD 27 }
	condition:
		$1
}

rule file_822_5_0 {
	meta:
		name = "__glob_freelist"
		size = 76
		refs = "0000 _gp_disp 0024 free"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 00 00 84 8C 06 00 80 10 ?? ?? 99 8F ?? ?? ?? ?? 00 00 90 8C 10 00 BC 8F FA FF 00 10 21 20 00 02 1C 00 BF 8F 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_823_0_0 {
	meta:
		name = "__GI_getsockname"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 4C 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_824_0_0 {
	meta:
		name = "setlocale"
		size = 136
		refs = "0000 _gp_disp 0050 __GI_strcmp 004c $LC0"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 07 00 84 2C 16 00 80 10 00 00 00 00 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 14 00 A0 10 ?? ?? 82 8F 00 00 A2 80 10 00 40 10 43 00 03 24 04 00 43 14 21 20 A0 00 01 00 A2 80 0C 00 40 10 ?? ?? 82 8F ?? ?? 85 8F ?? ?? 99 8F ?? ?? ?? ?? ?? ?? A5 24 05 00 40 10 10 00 BC 8F 05 00 00 10 21 10 00 00 08 00 E0 03 21 10 00 00 ?? ?? 82 8F ?? ?? 42 24 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_826_0_0 {
	meta:
		name = "gcvt"
		size = 92
		refs = "0000 _gp_disp 0018 __GI_sprintf 0014 $LC0"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D8 FF BD 27 14 00 A5 AF ?? ?? 85 8F ?? ?? 99 8F 12 00 C3 28 11 00 02 24 24 00 BF AF 20 00 B0 AF 18 00 BC AF 10 00 A4 AF ?? ?? A5 24 21 20 E0 00 0A 30 43 00 ?? ?? ?? ?? 21 80 E0 00 24 00 BF 8F 21 10 00 02 20 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_827_0_0 {
	meta:
		name = "trecurse"
		size = 216
		refs = "0000 _gp_disp 0070 trecurse"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 D8 FF BD 27 20 00 B2 AF 1C 00 B1 AF 18 00 B0 AF 10 00 BC AF 24 00 BF AF 04 00 82 8C 21 80 80 00 21 88 A0 00 04 00 40 14 21 90 C0 00 08 00 82 8C 1F 00 40 10 03 00 05 24 21 20 00 02 21 28 00 00 21 C8 20 02 09 F8 20 03 21 30 40 02 04 00 04 8E 06 00 80 10 10 00 BC 8F ?? ?? 99 8F 21 28 20 02 ?? ?? 39 27 ?? ?? ?? ?? 01 00 46 26 21 20 00 02 01 00 05 24 21 C8 20 02 09 F8 20 03 21 30 40 02 08 00 04 8E 07 00 80 10 10 00 BC 8F ?? ?? 99 8F 21 28 20 02 ?? ?? 39 27 ?? ?? ?? ?? 01 00 46 26 10 00 BC 8F 21 20 00 02 02 00 05 24 21 30 40 02 24 00 BF 8F 20 00 B2 8F 18 00 B0 8F 21 C8 20 02 1C 00 B1 8F 08 00 20 03 28 00 BD 27 }
	condition:
		$1
}

rule file_827_1_0 {
	meta:
		name = "twalk"
		size = 48
		refs = "0000 _gp_disp 0020 trecurse"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 06 00 80 10 00 00 00 00 04 00 A0 10 ?? ?? 99 8F ?? ?? 39 27 ?? ?? ?? ?? 21 30 00 00 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_828_0_0 {
	meta:
		name = "sync"
		size = 76
		refs = "0000 _gp_disp 0018 __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 C4 0F 02 24 0C 00 00 00 0B 00 E0 10 ?? ?? 99 8F E0 FF BD 27 1C 00 BF AF 18 00 B0 AF 10 00 BC AF ?? ?? ?? ?? 21 80 40 00 00 00 50 AC 1C 00 BF 8F 18 00 B0 8F 20 00 BD 27 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_829_0_0 {
	meta:
		name = "mlock"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 3A 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_830_3_0 {
	meta:
		name = "__GI_getnetent"
		size = 664
		refs = "0000 _gp_disp 0018 _pthread_cleanup_push_defer 001c __pthread_mutex_unlock 0058 __pthread_mutex_lock 0078 $LC1 009c malloc 00a4 __GI_fopen 00a0 $LC0 00dc __GI_abort 00ec __GI_fgets 0120 any 0150 $LC2 01b0 __GI_inet_network 0258 _pthread_cleanup_pop_restore"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 B0 FF BD 27 2C 00 B0 AF ?? ?? 90 8F ?? ?? 99 8F ?? ?? 85 8F 38 00 B3 AF 18 00 B3 27 10 00 BC AF ?? ?? 06 26 4C 00 BF AF 48 00 B7 AF 44 00 B6 AF 40 00 B5 AF 3C 00 B4 AF 34 00 B2 AF 30 00 B1 AF ?? ?? ?? ?? 21 20 60 02 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? ?? ?? 04 26 10 00 BC 8F ?? ?? 90 8F ?? ?? 02 8E 0B 00 40 10 ?? ?? 84 8F ?? ?? 97 8F ?? ?? 96 8F ?? ?? 91 8F ?? ?? F7 26 ?? ?? D6 26 ?? ?? 22 8E 16 00 40 14 ?? ?? 82 8F 0B 00 00 10 ?? ?? 99 8F ?? ?? 85 8F ?? ?? 99 8F ?? ?? 84 24 ?? ?? ?? ?? ?? ?? A5 24 ?? ?? 02 AE EF FF 40 14 10 00 BC 8F 65 00 00 10 21 80 00 00 ?? ?? ?? ?? 01 10 04 24 ?? ?? 22 AE 04 00 40 14 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 ?? ?? 82 8F ?? ?? 99 8F ?? ?? 06 8E ?? ?? 44 8C ?? ?? ?? ?? 00 10 05 24 21 38 40 00 EE FF 40 10 10 00 BC 8F 00 00 43 80 23 00 02 24 DD FF 62 10 21 20 E0 00 21 C8 C0 02 ?? ?? ?? ?? 21 28 E0 02 21 90 C0 02 D7 FF 40 10 10 00 BC 8F ?? ?? 95 8F ?? ?? 94 8F 00 00 40 A0 21 20 E0 00 ?? ?? A7 AE 21 C8 C0 02 ?? ?? ?? ?? ?? ?? 85 26 CD FF 40 10 10 00 BC 8F 01 00 51 24 00 00 40 A0 20 00 04 24 09 00 03 24 00 00 22 82 03 00 44 14 00 00 00 00 FC FF 00 10 01 00 31 26 FA FF 43 50 01 00 31 26 21 20 20 02 21 C8 40 02 ?? ?? ?? ?? ?? ?? 85 26 04 00 40 10 10 00 BC 8F 01 00 50 24 02 00 00 10 00 00 40 A0 21 80 00 00 ?? ?? 99 8F 21 20 20 02 ?? ?? ?? ?? 0A 80 30 02 10 00 BC 8F ?? ?? A3 26 0C 00 62 AC ?? ?? 87 8F ?? ?? 8B 8F 02 00 02 24 ?? ?? E7 24 08 00 62 AC 04 00 67 AC 21 40 60 00 20 00 09 24 09 00 0A 24 ?? ?? 6B 25 ?? ?? 94 26 00 00 06 82 15 00 C0 50 00 00 E0 AC 10 00 C9 50 01 00 10 26 03 00 CA 14 2B 10 EB 00 0C 00 00 10 01 00 10 26 03 00 40 10 21 20 00 02 00 00 F0 AC 04 00 E7 24 21 C8 40 02 ?? ?? ?? ?? 21 28 80 02 05 00 40 10 10 00 BC 8F 01 00 50 24 00 00 40 A0 EC FF 00 56 00 00 06 82 00 00 E0 AC 21 80 00 01 ?? ?? 99 8F 21 20 60 02 ?? ?? ?? ?? 01 00 05 24 4C 00 BF 8F 21 10 00 02 48 00 B7 8F 44 00 B6 8F 40 00 B5 8F 3C 00 B4 8F 38 00 B3 8F 34 00 B2 8F 30 00 B1 8F 2C 00 B0 8F 08 00 E0 03 50 00 BD 27 }
	condition:
		$1
}

rule file_832_0_0 {
	meta:
		name = "__GI_stpncpy"
		size = 52
	strings:
		$1 = { 21 38 80 00 21 18 A0 00 07 00 C0 10 01 00 E7 24 00 00 62 80 FF FF C6 24 FF FF E2 A0 2B 10 02 00 F9 FF 00 10 21 18 62 00 23 10 65 00 08 00 E0 03 21 10 82 00 }
	condition:
		$1
}

rule file_833_0_0 {
	meta:
		name = "fstatvfs64"
		size = 932
		refs = "0000 _gp_disp 000c __GI_fstatfs64 0060 __GI_memset 00e8 __GI_fstat64 010c __GI___errno_location 012c __GI_setmntent 0124 $LC0 013c $LC1 014c $LC2 016c __GI_getmntent_r 0170 __GI_stat64 01dc $LC11 01e0 $LC3 01e4 $LC4 01f8 __GI_strsep 0214 __GI_strcmp 0260 $LC5 0288 $LC6 02b0 $LC7 02d8 $LC8 0300 $LC9 0328 $LC10 0354 __GI_endmntent"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F 00 FA BD 27 10 00 BC AF DC 05 B1 AF D8 05 B0 AF FC 05 BF AF F8 05 BE AF F4 05 B7 AF F0 05 B6 AF EC 05 B5 AF E8 05 B4 AF E4 05 B3 AF E0 05 B2 AF 21 88 A0 00 58 05 A5 27 ?? ?? ?? ?? 21 80 80 00 C5 00 40 04 10 00 BC 8F 5C 05 A2 8F 6C 05 A3 8F ?? ?? 99 8F 00 00 22 AE 04 00 22 AE 68 05 A2 8F 0C 00 23 AE 74 05 A3 8F 08 00 22 AE 70 05 A2 8F 14 00 23 AE 8C 05 A3 8F 10 00 22 AE 88 05 A2 8F 1C 00 23 AE 7C 05 A3 8F 18 00 22 AE 78 05 A2 8F 24 00 23 AE 84 05 A3 8F 20 00 22 AE 80 05 A2 8F 2C 00 23 AE 48 00 24 26 28 00 22 AE 90 05 A2 8F 21 28 00 00 18 00 06 24 38 00 22 AE 98 05 A2 8F 3C 00 20 AE ?? ?? ?? ?? 44 00 22 AE 10 00 BC 8F 28 00 22 8E 2C 00 23 8E ?? ?? 99 8F 30 00 22 AE 34 00 23 AE 40 00 20 AE 21 20 00 02 ?? ?? ?? ?? B8 04 A5 27 9A 00 40 04 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F 21 A0 40 00 00 00 55 8C ?? ?? 84 8F ?? ?? 92 8F ?? ?? 90 8F ?? ?? 84 24 21 C8 00 02 ?? ?? ?? ?? ?? ?? 45 26 21 98 40 00 09 00 40 14 10 00 BC 8F ?? ?? 84 8F ?? ?? 45 26 21 C8 00 02 ?? ?? ?? ?? ?? ?? 84 24 21 98 40 00 7E 00 40 10 10 00 BC 8F ?? ?? 90 8F ?? ?? 9E 8F B8 05 B6 27 18 00 B2 27 18 04 B7 27 21 20 60 02 21 28 C0 02 21 30 40 02 21 C8 00 02 ?? ?? ?? ?? 00 04 07 24 6E 00 40 10 10 00 BC 8F BC 05 A4 8F 21 C8 C0 03 ?? ?? ?? ?? 21 28 E0 02 F3 FF 40 04 10 00 BC 8F 18 04 A2 8F B8 04 A3 8F F0 FF 62 14 21 20 60 02 1C 04 A2 8F BC 04 A3 8F ED FF 62 14 21 28 C0 02 C4 05 A2 8F ?? ?? 96 8F ?? ?? 97 8F ?? ?? 9E 8F D0 05 A2 AF ?? ?? D6 26 ?? ?? F7 26 ?? ?? DE 27 ?? ?? 99 8F D0 05 A4 27 ?? ?? ?? ?? 21 28 C0 02 21 80 40 00 51 00 40 10 10 00 BC 8F ?? ?? 92 8F 21 20 00 02 21 C8 40 02 ?? ?? ?? ?? 21 28 E0 02 04 00 40 14 10 00 BC 8F 40 00 22 8E 45 00 00 10 01 00 42 34 21 20 00 02 21 C8 40 02 ?? ?? ?? ?? 21 28 C0 03 04 00 40 14 10 00 BC 8F 40 00 22 8E 3C 00 00 10 02 00 42 34 ?? ?? 85 8F 21 20 00 02 21 C8 40 02 ?? ?? ?? ?? ?? ?? A5 24 04 00 40 14 10 00 BC 8F 40 00 22 8E 32 00 00 10 08 00 42 34 ?? ?? 85 8F 21 20 00 02 21 C8 40 02 ?? ?? ?? ?? ?? ?? A5 24 04 00 40 14 10 00 BC 8F 40 00 22 8E 28 00 00 10 04 00 42 34 ?? ?? 85 8F 21 20 00 02 21 C8 40 02 ?? ?? ?? ?? ?? ?? A5 24 04 00 40 14 10 00 BC 8F 40 00 22 8E 1E 00 00 10 10 00 42 34 ?? ?? 85 8F 21 20 00 02 21 C8 40 02 ?? ?? ?? ?? ?? ?? A5 24 04 00 40 14 10 00 BC 8F 40 00 22 8E 14 00 00 10 40 00 42 34 ?? ?? 85 8F 21 20 00 02 21 C8 40 02 ?? ?? ?? ?? ?? ?? A5 24 04 00 40 14 10 00 BC 8F 40 00 22 8E 0A 00 00 10 00 04 42 34 ?? ?? 85 8F 21 20 00 02 21 C8 40 02 ?? ?? ?? ?? ?? ?? A5 24 AE FF 40 14 10 00 BC 8F 40 00 22 8E 00 08 42 34 AA FF 00 10 40 00 22 AE ?? ?? 99 8F ?? ?? ?? ?? 21 20 60 02 03 00 00 10 00 00 95 AE 02 00 00 10 FF FF 02 24 21 10 00 00 FC 05 BF 8F F8 05 BE 8F F4 05 B7 8F F0 05 B6 8F EC 05 B5 8F E8 05 B4 8F E4 05 B3 8F E0 05 B2 8F DC 05 B1 8F D8 05 B0 8F 08 00 E0 03 00 06 BD 27 }
	condition:
		$1
}

rule file_834_0_0 {
	meta:
		name = "__GI___ns_name_ntop"
		size = 528
		refs = "0000 _gp_disp 0070 __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 89 8F D8 FF BD 27 21 30 A6 00 21 18 A0 00 1C 00 B1 AF 18 00 B0 AF 10 00 BC AF 24 00 BF AF 20 00 B2 AF 2E 00 0D 24 2E 00 0E 24 5C 00 0A 24 64 00 0B 24 ?? ?? 29 25 0A 00 02 24 40 00 0F 24 5C 00 18 24 3B 00 19 24 22 00 10 24 24 00 11 24 00 00 88 90 22 00 00 11 01 00 87 24 C0 00 04 31 2B 00 80 54 ?? ?? 99 8F 05 00 65 10 2B 20 66 00 27 00 80 50 ?? ?? 99 8F 00 00 6D A0 01 00 63 24 21 20 68 00 2B 20 86 00 21 00 80 50 ?? ?? 99 8F 01 00 E4 24 00 00 E7 90 26 00 EE 10 2F 00 EC 2C 07 00 80 11 00 00 00 00 23 00 F0 10 01 00 6C 24 28 00 F1 54 DF FF EC 24 20 00 00 10 2B 60 86 01 1D 00 EF 10 01 00 6C 24 1C 00 F8 10 2B 60 86 01 20 00 F9 54 DF FF EC 24 17 00 00 10 01 00 6C 24 08 00 65 54 2B 30 66 00 2B 10 66 00 08 00 40 10 ?? ?? 99 8F 2E 00 02 24 00 00 62 A0 01 00 63 24 2B 30 66 00 08 00 C0 54 00 00 60 A0 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 61 00 03 24 00 00 43 AC 32 00 00 10 FF FF 02 24 01 00 63 24 2F 00 00 10 23 10 65 00 01 00 6C 24 2B 60 86 01 F4 FF 80 51 ?? ?? 99 8F 00 00 6A A0 01 00 67 A0 1D 00 00 10 02 00 63 24 5E 00 8C 2D 1F 00 80 15 2B 60 66 00 03 00 6C 24 2B 60 86 01 E9 FF 80 51 ?? ?? 99 8F 1B 00 EB 00 F4 01 60 01 00 00 6A A0 04 00 63 24 10 60 00 00 12 90 00 00 21 90 32 01 00 00 52 92 1B 00 82 01 F4 01 40 00 FD FF 72 A0 12 60 00 00 21 60 2C 01 00 00 8C 91 1B 00 E2 00 F4 01 40 00 FE FF 6C A0 10 60 00 00 21 38 2C 01 00 00 E7 90 FF FF 67 A0 FF FF 08 25 B1 FF 00 15 21 38 80 00 A0 FF 00 10 00 00 88 90 CD FF 80 51 ?? ?? 99 8F 00 00 67 A0 F7 FF 00 10 01 00 63 24 24 00 BF 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_834_1_0 {
	meta:
		name = "__GI___ns_name_unpack"
		size = 420
		refs = "0000 _gp_disp 0064 __GI___errno_location 0080 __GI_memcpy"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 B8 FF BD 27 3C 00 B7 AF 58 00 B7 8F 10 00 BC AF 2B 10 C4 00 34 00 B5 AF 28 00 B2 AF 44 00 BF AF 40 00 BE AF 38 00 B6 AF 30 00 B4 AF 2C 00 B3 AF 24 00 B1 AF 20 00 B0 AF 21 A8 80 00 21 90 C0 00 21 00 40 14 21 B8 F7 00 2B 10 C5 00 25 00 40 14 21 98 A0 00 1D 00 00 10 ?? ?? 99 8F 21 18 E2 00 2B 18 77 00 18 00 60 10 21 88 B0 00 2B 18 33 02 15 00 60 10 ?? ?? 99 8F 01 00 E3 24 00 00 F0 A0 21 20 60 00 18 00 A8 AF 1C 00 A9 AF 21 30 00 02 ?? ?? ?? ?? 21 A0 82 02 10 00 BC 8F 18 00 A8 8F 1C 00 A9 8F 21 38 50 00 00 00 30 92 29 00 00 12 01 00 25 26 24 10 1E 02 E8 FF 40 50 01 00 02 26 0F 00 48 50 2B 10 B3 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 61 00 03 24 00 00 43 AC 22 00 00 10 FF FF 02 24 21 88 C0 00 21 A0 00 00 FF FF 16 24 C0 FF 1E 24 C0 00 08 24 EB FF 00 10 23 48 A4 00 F2 FF 40 10 ?? ?? 99 8F 03 00 C1 06 01 00 22 92 23 28 B2 00 01 00 B6 24 3F 00 10 32 00 82 10 00 25 88 02 02 21 88 B1 02 2B 10 35 02 E7 FF 40 14 ?? ?? 99 8F 2B 10 33 02 E4 FF 40 10 02 00 94 26 2A 10 89 02 D9 FF 40 54 00 00 30 92 DF FF 00 10 00 00 00 00 00 00 C2 2A 23 90 B2 00 0B B0 42 02 00 00 E0 A0 21 10 C0 02 44 00 BF 8F 40 00 BE 8F 3C 00 B7 8F 38 00 B6 8F 34 00 B5 8F 30 00 B4 8F 2C 00 B3 8F 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 08 00 E0 03 48 00 BD 27 }
	condition:
		$1
}

rule file_834_2_0 {
	meta:
		name = "__GI___ns_name_uncompress"
		size = 152
		refs = "0000 _gp_disp 0010 __GI___ns_name_unpack 0060 __GI___ns_name_ntop"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 C8 FE BD 27 ?? ?? 99 8F FF 00 02 24 24 01 B0 AF 20 00 B0 27 18 00 BC AF 30 01 B3 AF 2C 01 B2 AF 28 01 B1 AF 34 01 BF AF 21 98 E0 00 10 00 A2 AF 21 38 00 02 ?? ?? ?? ?? FF FF 12 24 21 88 40 00 03 00 52 14 18 00 BC 8F 09 00 00 10 FF FF 02 24 48 01 A6 8F ?? ?? 99 8F 21 20 00 02 ?? ?? ?? ?? 21 28 60 02 02 00 52 10 FF FF 02 24 21 10 20 02 34 01 BF 8F 30 01 B3 8F 2C 01 B2 8F 28 01 B1 8F 24 01 B0 8F 08 00 E0 03 38 01 BD 27 }
	condition:
		$1
}

rule file_835_0_0 {
	meta:
		name = "__check_one_fd"
		size = 124
		refs = "0000 _gp_disp 000c __GI_fcntl 0044 __GI_open 0040 $LC0 005c __GI_abort"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F D8 FF BD 27 10 00 BC AF 20 00 B1 AF 1C 00 B0 AF 24 00 BF AF 21 88 A0 00 01 00 05 24 ?? ?? ?? ?? 21 80 80 00 FF FF 03 24 0B 00 43 14 10 00 BC 8F ?? ?? 84 8F ?? ?? 99 8F 21 28 20 02 ?? ?? ?? ?? ?? ?? 84 24 04 00 50 10 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 24 00 BF 8F 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_835_3_0 {
	meta:
		name = "__GI___uClibc_init"
		size = 112
		refs = "0000 _gp_disp 002c __pagesize 0038 __pthread_initialize_minimal 0050 _stdio_init"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F E0 FF BD 27 10 00 BC AF ?? ?? 43 8C 1C 00 BF AF 10 00 60 14 01 00 03 24 ?? ?? 43 AC ?? ?? 82 8F 00 10 03 24 00 00 43 AC ?? ?? 82 8F 04 00 40 10 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F ?? ?? 99 8F 03 00 20 13 1C 00 BF 8F ?? ?? ?? ?? 20 00 BD 27 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_835_4_0 {
	meta:
		name = "__GI___uClibc_fini"
		size = 168
		refs = "0000 _gp_disp 000c __fini_array_start 0010 __fini_array_end 005c __app_fini 0068 __rtld_fini"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 83 8F ?? ?? 82 8F D8 FF BD 27 20 00 B1 AF 23 10 43 00 10 00 BC AF 24 00 BF AF 1C 00 B0 AF 83 10 02 00 21 88 60 00 09 00 40 10 FF FF 50 24 80 10 10 00 21 10 22 02 00 00 59 8C 09 F8 20 03 00 00 00 00 10 00 BC 8F F7 FF 00 10 21 10 00 02 ?? ?? 82 8F 00 00 59 8C 05 00 20 13 ?? ?? 82 8F 09 F8 20 03 00 00 00 00 10 00 BC 8F ?? ?? 82 8F 00 00 59 8C 05 00 20 13 24 00 BF 8F 20 00 B1 8F 1C 00 B0 8F 08 00 20 03 28 00 BD 27 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_835_5_0 {
	meta:
		name = "__uClibc_main"
		size = 736
		refs = "0000 _gp_disp 0010 __libc_stack_end 0044 __rtld_fini 004c __environ 0088 __GI_memset 00c8 __GI_memcpy 00ec _dl_aux_init 00fc __GI___uClibc_init 0118 __pagesize 0144 __GI_getuid 0154 __GI_geteuid 0168 __GI_getgid 0178 __GI_getegid 01c0 __check_one_fd 01f0 __uclibc_progname 01f4 __preinit_array_start 01f8 __preinit_array_end 0200 __app_fini 0250 __init_array_start 0254 __init_array_end 0288 __GI___errno_location 0290 __GI___h_errno_location 02d4 __GI_exit"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 48 FF BD 27 ?? ?? 82 8F D0 00 A3 8F 10 00 BC AF AC 00 B6 AF A8 00 B5 AF A4 00 B4 AF 9C 00 B2 AF 94 00 B0 AF B4 00 BF AF B0 00 B7 AF A0 00 B3 AF 98 00 B1 AF 00 00 43 AC ?? ?? 82 8F CC 00 A3 8F ?? ?? 92 8F 21 A8 80 00 00 00 43 AC 01 00 A2 24 80 10 02 00 21 18 C2 00 00 00 43 AE 00 00 C4 8C 21 A0 A0 00 21 80 C0 00 04 00 64 14 21 B0 E0 00 FC FF 42 24 21 10 C2 00 00 00 42 AE ?? ?? 99 8F 18 00 B3 27 21 20 60 02 21 28 00 00 ?? ?? ?? ?? 78 00 06 24 10 00 BC 8F 00 00 51 8E 00 00 22 8E FE FF 40 14 04 00 31 26 00 00 24 8E 0C 00 80 10 0F 00 82 2C FC FF 40 50 08 00 31 26 ?? ?? 99 8F C0 20 04 00 21 20 64 02 21 28 20 02 ?? ?? ?? ?? 08 00 06 24 10 00 BC 8F F3 FF 00 10 08 00 31 26 ?? ?? 99 8F ?? ?? ?? ?? 21 20 60 02 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F 4C 00 A3 8F 00 10 02 24 0B 10 63 00 ?? ?? 83 8F 00 00 62 AC 74 00 A3 8F FF FF 02 24 06 00 62 10 74 00 A2 8F FF FF 03 24 17 00 43 54 7C 00 A3 8F 2C 00 00 10 00 00 03 8E ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 88 40 00 12 00 22 16 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 88 40 00 09 00 22 16 10 00 BC 8F E8 FF 00 10 74 00 A2 8F 06 00 43 14 ?? ?? 91 8F 8C 00 A2 8F 84 00 A3 8F 12 00 62 50 00 00 03 8E ?? ?? 91 8F 21 20 00 00 02 00 05 3C ?? ?? 31 26 21 C8 20 02 ?? ?? ?? ?? 02 00 13 3C 01 00 04 24 21 C8 20 02 ?? ?? ?? ?? 02 00 65 26 02 00 04 24 21 C8 20 02 ?? ?? ?? ?? 02 00 65 36 10 00 BC 8F 00 00 03 8E ?? ?? 82 8F ?? ?? 93 8F ?? ?? 97 8F 00 00 43 AC ?? ?? 82 8F C8 00 A3 8F 23 B8 F3 02 21 88 00 00 00 00 43 AC 83 B8 17 00 2B 10 37 02 07 00 40 10 80 10 11 00 21 10 62 02 00 00 59 8C 09 F8 20 03 01 00 31 26 F8 FF 00 10 10 00 BC 8F 04 00 C0 12 21 C8 C0 02 09 F8 20 03 00 00 00 00 10 00 BC 8F ?? ?? 93 8F ?? ?? 96 8F 21 88 00 00 23 B0 D3 02 83 B0 16 00 2B 10 36 02 07 00 40 10 80 10 11 00 21 10 62 02 00 00 59 8C 09 F8 20 03 01 00 31 26 F8 FF 00 10 10 00 BC 8F ?? ?? 99 8F 06 00 20 53 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F 00 00 40 AC ?? ?? 99 8F 05 00 20 53 00 00 46 8E ?? ?? ?? ?? 00 00 00 00 00 00 40 AC 00 00 46 8E 21 20 80 02 21 C8 A0 02 09 F8 20 03 21 28 00 02 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 40 00 }
	condition:
		$1
}

rule file_836_0_0 {
	meta:
		name = "__GI_fputws_unlocked"
		size = 116
		refs = "0000 _gp_disp 000c __GI_wcslen 0040 _wstdio_fwrite"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F D8 FF BD 27 24 00 BF AF 20 00 B2 AF 1C 00 B1 AF 18 00 B0 AF 10 00 BC AF 21 88 A0 00 ?? ?? ?? ?? 21 90 80 00 10 00 BC 8F 21 20 40 02 21 30 20 02 ?? ?? 99 8F 21 28 40 00 ?? ?? ?? ?? 21 80 40 00 24 00 BF 8F 26 10 50 00 2B 10 02 00 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 23 10 02 00 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_837_0_0 {
	meta:
		name = "__GI_strcpy"
		size = 40
	strings:
		$1 = { 21 10 80 00 21 18 80 00 00 00 A4 80 04 00 80 10 00 00 64 A0 01 00 A5 24 FB FF 00 10 01 00 63 24 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_838_0_0 {
	meta:
		name = "reboot"
		size = 104
		refs = "0000 _gp_disp 0040 __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 21 30 80 00 E1 FE 04 3C 10 00 BC AF 12 28 05 3C 1C 00 BF AF 18 00 B0 AF AD DE 84 34 69 19 A5 24 F8 0F 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_840_0_0 {
	meta:
		name = "__GI_strndup"
		size = 132
		refs = "0000 _gp_disp 000c __GI_strnlen 0034 malloc 004c __GI_memcpy"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F D8 FF BD 27 10 00 BC AF 24 00 BF AF 20 00 B1 AF 1C 00 B0 AF ?? ?? ?? ?? 21 88 80 00 10 00 BC 8F 01 00 44 24 ?? ?? 99 8F ?? ?? ?? ?? 21 80 40 00 21 18 40 00 09 00 40 10 10 00 BC 8F ?? ?? 99 8F 21 30 00 02 21 20 40 00 ?? ?? ?? ?? 21 28 20 02 21 80 50 00 21 18 40 00 00 00 00 A2 24 00 BF 8F 20 00 B1 8F 1C 00 B0 8F 21 10 60 00 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_841_0_0 {
	meta:
		name = "setuid"
		size = 120
		refs = "0000 _gp_disp 0024 __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 FF FF 02 24 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 07 00 82 14 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 16 00 03 24 00 00 43 AC 0B 00 00 10 FF FF 02 24 B7 0F 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 21 10 00 02 1C 00 BF 8F 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_843_0_0 {
	meta:
		name = "__GI_fgetws_unlocked"
		size = 192
		refs = "0000 _gp_disp 0014 __GI_fgetwc_unlocked"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 C8 FF BD 27 24 00 B3 AF ?? ?? 93 8F 30 00 B6 AF 2C 00 B5 AF 28 00 B4 AF 20 00 B2 AF 1C 00 B1 AF 18 00 B0 AF 10 00 BC AF 34 00 BF AF 21 88 80 00 21 90 A0 00 21 A8 C0 00 21 80 80 00 FF FF 16 24 0A 00 14 24 02 00 42 2A 0B 00 40 14 21 C8 60 02 ?? ?? ?? ?? 21 20 A0 02 07 00 56 10 04 00 03 26 04 00 54 10 00 00 02 AE FF FF 52 26 F5 FF 00 10 21 80 60 00 21 80 60 00 03 00 11 12 21 10 20 02 02 00 00 10 00 00 00 AE 21 10 00 00 34 00 BF 8F 30 00 B6 8F 2C 00 B5 8F 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_844_0_0 {
	meta:
		name = "ferror"
		size = 152
		refs = "0000 _gp_disp 0030 _pthread_cleanup_push_defer 0034 __pthread_mutex_unlock 004c __pthread_mutex_lock 006c _pthread_cleanup_pop_restore"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 C8 FF BD 27 28 00 B0 AF 10 00 BC AF 34 00 BF AF 30 00 B2 AF 2C 00 B1 AF 34 00 91 8C 0C 00 20 16 21 80 80 00 ?? ?? 99 8F ?? ?? 85 8F 38 00 92 24 21 30 40 02 ?? ?? ?? ?? 18 00 A4 27 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 40 02 10 00 BC 8F 00 00 10 96 08 00 10 32 05 00 20 16 FF FF 10 32 ?? ?? 99 8F 18 00 A4 27 ?? ?? ?? ?? 01 00 05 24 34 00 BF 8F 21 10 00 02 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_845_0_0 {
	meta:
		name = "adjtime"
		size = 272
		refs = "0000 _gp_disp 0054 __GI___errno_location 0088 __GI_adjtimex"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 60 FF BD 27 10 00 BC AF 98 00 B0 AF 9C 00 BF AF 19 00 80 10 21 80 A0 00 04 00 83 8C 0F 00 02 3C 40 42 42 24 1A 00 62 00 F4 01 40 00 00 00 84 8C 12 18 00 00 21 18 64 00 61 08 64 24 C3 10 84 2C 07 00 80 14 10 28 00 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 16 00 03 24 23 00 00 10 00 00 43 AC 02 20 62 70 01 80 02 34 18 00 A2 AF 21 18 85 00 02 00 00 10 1C 00 A3 AF 18 00 A0 AF ?? ?? 99 8F ?? ?? ?? ?? 18 00 A4 27 1A 00 42 04 FF FF 02 24 17 00 00 12 1C 00 A3 8F 0F 00 02 3C 0B 00 61 04 40 42 42 24 23 20 03 00 1A 00 82 00 F4 01 40 00 10 28 00 00 23 20 05 00 04 00 04 AE 1A 00 62 00 F4 01 40 00 06 00 00 10 12 10 00 00 1A 00 62 00 F4 01 40 00 10 20 00 00 04 00 04 AE 12 10 00 00 03 00 00 10 00 00 02 AE 02 00 00 10 FF FF 02 24 21 10 00 00 9C 00 BF 8F 98 00 B0 8F 08 00 E0 03 A0 00 BD 27 }
	condition:
		$1
}

rule file_846_0_0 {
	meta:
		name = "__GI_fnmatch"
		size = 1624
		refs = "0000 _gp_disp 000c __GI___ctype_b 0010 __GI___ctype_tolower 029c __GI_fnmatch"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 87 8F ?? ?? 88 8F C0 FF BD 27 01 00 CB 30 2F 00 0C 24 34 00 B7 AF 30 00 B6 AF 2C 00 B5 AF 24 00 B3 AF 20 00 B2 AF 1C 00 B1 AF 18 00 B0 AF 10 00 BC AF 3C 00 BF AF 38 00 BE AF 28 00 B4 AF 21 80 A0 00 10 00 D1 30 04 00 D2 30 2E 00 13 24 02 00 CD 30 5C 00 0E 24 2D 00 15 24 5D 00 19 24 5E 00 16 24 2A 00 17 24 00 00 82 80 61 01 40 10 01 00 83 24 0D 00 20 12 3F 00 09 24 0A 00 40 04 40 48 02 00 00 00 EA 8C 21 50 49 01 00 00 4A 95 01 00 4A 31 05 00 40 51 3F 00 09 24 00 00 02 8D 21 48 49 00 00 00 22 81 3F 00 09 24 0D 00 49 10 40 00 49 28 05 00 20 51 5B 00 09 24 44 00 57 50 04 00 C2 30 3A 01 00 10 00 00 04 82 A2 00 49 50 00 00 0A 82 19 00 4E 10 00 00 00 00 34 01 00 10 00 00 04 82 00 00 02 82 03 00 40 14 00 00 00 00 4A 01 00 10 01 00 02 24 03 00 60 11 00 00 00 00 46 01 4C 50 01 00 02 24 38 01 40 52 01 00 10 26 36 01 53 54 01 00 10 26 40 01 05 12 01 00 02 24 32 01 60 51 01 00 10 26 FF FF 02 82 2F 01 4C 14 01 00 10 26 39 01 00 10 01 00 02 24 12 00 A0 15 00 00 00 00 01 00 82 80 E9 FF 40 10 02 00 83 24 24 01 20 52 00 00 04 82 0D 00 40 04 40 20 02 00 00 00 E9 8C 21 48 24 01 00 00 29 95 01 00 29 31 08 00 20 51 00 00 04 82 00 00 02 8D 21 20 44 00 03 00 00 10 00 00 82 80 0F 00 20 12 5C 00 02 24 00 00 04 82 13 01 82 04 00 00 04 82 00 00 E9 8C 40 20 04 00 21 48 24 01 00 00 29 95 01 00 29 31 0C 01 20 51 00 00 04 82 00 00 09 8D 21 20 24 01 08 01 00 10 00 00 84 84 06 01 00 10 00 00 04 82 0F 00 40 10 02 00 82 24 00 00 03 82 2E 00 02 24 0B 00 62 54 02 00 82 24 0C 01 05 12 01 00 02 24 01 00 C2 30 06 00 40 10 02 00 82 24 FF FF 03 82 2F 00 02 24 05 01 62 10 01 00 02 24 02 00 82 24 01 00 92 80 3F 00 03 24 2A 00 04 24 01 00 C5 30 2F 00 07 24 0E 00 43 16 00 00 00 00 04 00 A0 10 00 00 00 00 00 00 08 82 F8 00 07 51 01 00 02 24 05 00 43 56 00 00 52 80 00 00 08 82 A8 FF 00 11 01 00 10 26 00 00 52 80 F2 FF 00 10 01 00 42 24 F2 FF 44 12 00 00 00 00 03 00 40 56 02 00 C3 30 EA 00 00 10 21 10 00 00 04 00 60 14 21 98 40 02 5C 00 03 24 01 00 43 52 00 00 53 80 0F 00 20 12 ?? ?? 94 8F 0D 00 60 06 ?? ?? 84 8F 40 18 13 00 00 00 84 8C 21 20 83 00 00 00 84 94 01 00 84 30 07 00 80 10 ?? ?? 97 8F ?? ?? 84 8F 00 00 84 8C 21 18 83 00 00 00 73 80 ?? ?? 94 8F ?? ?? 97 8F ?? ?? 9E 8F FB FF 16 24 FF FF 55 24 24 B0 D6 00 00 00 03 82 CD 00 60 10 01 00 02 24 5B 00 02 24 11 00 42 12 21 20 A0 02 0C 00 20 12 00 00 00 00 0A 00 60 04 40 28 03 00 00 00 E2 8E 21 10 45 00 00 00 42 94 01 00 42 30 04 00 40 10 00 00 00 00 00 00 C2 8F 21 28 45 00 00 00 A3 84 EC FF 73 54 01 00 10 26 21 20 A0 02 21 28 00 02 21 C8 80 02 ?? ?? ?? ?? 21 30 C0 02 C9 FF 40 10 01 00 10 26 E4 FF 00 10 00 00 03 82 B0 00 40 11 01 00 02 24 0B 00 40 52 01 00 82 80 09 00 53 55 01 00 82 80 AB 00 05 12 3C 00 BF 8F 05 00 60 51 01 00 82 80 FF FF 02 82 A6 00 4C 10 01 00 02 24 01 00 82 80 21 00 09 24 9F 00 49 50 02 00 83 24 9D 00 56 50 02 00 83 24 21 C0 00 00 00 00 62 80 01 00 64 24 40 78 0A 00 06 00 A0 15 21 48 40 00 04 00 4E 14 00 00 00 00 00 00 89 80 49 FF 20 11 01 00 84 24 0C 00 20 12 00 00 00 00 0A 00 20 05 40 18 09 00 00 00 F4 8C 21 A0 83 02 00 00 94 96 01 00 94 32 04 00 80 12 00 00 00 00 00 00 09 8D 21 18 23 01 00 00 69 80 85 00 40 50 01 00 02 24 01 00 83 24 0C 00 20 12 00 00 82 80 0A 00 40 04 40 A0 02 00 00 00 FE 8C 21 F0 D4 03 00 00 DE 97 01 00 DE 33 04 00 C0 13 00 00 00 00 00 00 02 8D 21 A0 54 00 00 00 82 82 03 00 60 11 00 00 00 00 73 00 4C 50 01 00 02 24 1C 00 55 14 21 A0 20 01 01 00 94 80 19 00 99 52 21 A0 20 01 05 00 A0 15 02 00 82 24 03 00 8E 16 00 00 00 00 02 00 94 80 03 00 82 24 66 00 80 52 01 00 02 24 0E 00 20 12 01 00 43 24 0D 00 82 06 00 00 42 80 00 00 E4 8C 40 18 14 00 21 20 83 00 00 00 84 94 01 00 84 30 05 00 80 50 01 00 43 24 00 00 04 8D 21 18 83 00 00 00 74 80 01 00 43 24 00 00 42 80 0C 00 20 12 21 20 40 01 0B 00 42 05 2A 48 89 00 00 00 E4 8C 21 20 8F 00 00 00 84 94 01 00 84 30 04 00 80 50 21 20 40 01 00 00 04 8D 21 20 8F 00 00 00 84 84 2A 48 89 00 11 00 20 15 00 00 00 00 0C 00 20 12 21 20 40 01 0B 00 42 05 2A A0 84 02 00 00 E4 8C 21 20 8F 00 00 00 84 94 01 00 84 30 04 00 80 50 21 20 40 01 00 00 04 8D 21 20 8F 00 00 00 84 84 2A A0 84 02 0C 00 80 12 00 00 00 00 9A FF 59 14 21 20 60 00 C5 FE 00 17 01 00 10 26 30 00 00 10 01 00 02 24 E3 FE 40 10 01 00 64 24 06 00 A0 11 00 00 62 80 21 18 80 00 FA FF 59 14 00 00 00 00 08 00 00 10 00 00 00 00 FB FF 4E 54 21 18 80 00 01 00 64 80 D7 FE 80 10 02 00 64 24 F6 FF 00 10 21 18 80 00 12 00 00 13 01 00 10 26 1C 00 00 10 01 00 02 24 0C 00 20 12 00 00 00 00 0A 00 80 04 40 48 04 00 00 00 EA 8C 21 50 49 01 00 00 4A 95 01 00 4A 31 04 00 40 11 00 00 00 00 00 00 04 8D 21 48 89 00 00 00 24 85 C2 FE 44 14 01 00 10 26 9E FE 00 10 21 20 60 00 00 00 03 82 08 00 60 10 08 00 C6 30 06 00 C0 10 01 00 02 24 2F 00 62 38 03 00 00 10 2B 10 02 00 64 FF 00 10 01 00 18 24 3C 00 BF 8F 38 00 BE 8F 34 00 B7 8F 30 00 B6 8F 2C 00 B5 8F 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 40 00 BD 27 }
	condition:
		$1
}

rule file_847_0_0 {
	meta:
		name = "sysctl"
		size = 196
		refs = "0000 _gp_disp 0010 memset 008c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 A8 FF BD 27 ?? ?? 99 8F 40 00 B0 AF 18 00 B0 27 10 00 BC AF 50 00 B4 AF 4C 00 B3 AF 48 00 B2 AF 44 00 B1 AF 21 98 80 00 21 90 A0 00 21 88 C0 00 21 20 00 02 54 00 BF AF 21 28 00 00 28 00 06 24 ?? ?? ?? ?? 21 A0 E0 00 68 00 A2 8F 10 00 BC 8F 18 00 B3 AF 28 00 A2 AF 6C 00 A2 8F 1C 00 B2 AF 20 00 B1 AF 24 00 B4 AF 2C 00 A2 AF 21 20 00 02 39 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 54 00 BF 8F 21 10 00 02 50 00 B4 8F 4C 00 B3 8F 48 00 B2 8F 44 00 B1 8F 40 00 B0 8F 08 00 E0 03 58 00 BD 27 }
	condition:
		$1
}

rule file_848_0_0 {
	meta:
		name = "remque"
		size = 32
	strings:
		$1 = { 00 00 83 8C 02 00 60 10 04 00 82 8C 04 00 62 AC 01 00 40 54 00 00 43 AC 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_849_0_0 {
	meta:
		name = "_time_mktime_tzi"
		size = 960
		refs = "0000 _gp_disp 0010 __GI_memcpy 0180 _time_tzset 0308 __time_localtime_tzi"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 88 FF BD 27 ?? ?? 99 8F 58 00 B2 AF 54 00 B1 AF 21 90 80 00 18 00 B1 27 10 00 BC AF 5C 00 B3 AF 50 00 B0 AF 74 00 BF AF 21 80 C0 00 70 00 BE AF 6C 00 B7 AF 68 00 B6 AF 64 00 B5 AF 60 00 B4 AF 21 98 A0 00 21 20 20 02 21 28 40 02 ?? ?? ?? ?? 2C 00 06 24 28 00 02 82 02 00 40 14 10 00 BC 8F 38 00 A0 AF 38 00 A3 8F 07 00 60 10 21 A8 00 00 01 00 02 24 01 00 63 28 FF FF 04 24 0B 10 83 00 38 00 A2 AF 01 00 15 24 2C 00 A5 8F 90 01 04 24 28 00 A3 8F 1A 00 A4 00 F4 01 80 00 0C 00 02 24 12 30 00 00 30 00 A6 AF 1A 00 62 00 F4 01 40 00 12 10 00 00 02 38 C4 70 23 20 A7 00 F4 FF 05 24 02 30 45 70 21 20 82 00 21 10 C3 00 03 00 40 04 2C 00 A4 AF 05 00 00 10 28 00 A2 AF 0C 00 42 24 FF FF 84 24 28 00 A2 AF 2C 00 A4 AF 2C 00 A4 8F 6C 07 84 24 03 00 82 30 0D 00 40 14 2C 00 A4 AF 64 00 02 24 1A 00 82 00 F4 01 40 00 10 18 00 00 0A 00 60 14 ?? ?? 82 8F 90 01 02 24 1A 00 82 00 F4 01 40 00 10 18 00 00 04 00 60 50 ?? ?? 82 8F ?? ?? 82 8F 02 00 00 10 ?? ?? 42 24 ?? ?? 42 24 28 00 A3 8F 34 00 A0 AF 0A 00 60 10 34 00 A6 8F 00 00 45 90 FF FF 63 24 21 30 C5 00 34 00 A6 AF 1D 00 A5 38 F5 FF 46 24 0A 10 C5 00 F6 FF 00 10 01 00 42 24 ?? ?? 99 8F ?? ?? ?? ?? D7 07 84 28 2C 00 A4 8F 6D 01 07 24 F5 FF 05 3C FF FF 82 24 02 18 47 70 C5 06 A5 24 02 00 84 24 18 00 B6 8F 30 00 A8 8F 1C 00 A6 8F 10 00 BC 8F C3 5F 06 00 21 28 65 00 00 00 43 28 0A 20 43 00 9C FF 03 24 1A 00 43 00 F4 01 60 00 83 20 04 00 90 01 03 24 21 28 A4 00 12 20 00 00 21 20 A4 00 20 00 A5 8F 1A 00 43 00 F4 01 60 00 C3 4F 05 00 12 38 00 00 21 38 87 00 18 00 04 24 02 10 A4 72 C3 1F 07 00 21 B8 50 00 00 00 E2 8E 21 B0 C2 02 21 10 E0 00 13 00 40 00 02 00 07 3C 99 3A E7 24 11 00 60 00 C3 57 16 00 00 00 07 71 24 00 A7 8F C3 47 07 00 12 10 00 00 21 38 47 00 2B 10 E2 00 10 18 00 00 21 18 68 00 21 18 43 00 34 00 A2 8F C3 47 02 00 21 10 E2 00 19 00 82 00 21 18 68 00 2B 38 47 00 21 38 E3 00 12 10 00 00 10 18 00 00 02 40 87 70 0B 20 15 00 21 F0 04 02 21 18 03 01 21 40 A2 00 2B 28 05 01 21 10 23 01 21 10 A2 00 3C 00 05 24 19 00 A8 00 12 40 00 00 10 48 00 00 02 18 A2 70 21 10 C8 00 2B 30 46 00 19 00 A2 00 21 48 69 00 21 58 69 01 21 30 CB 00 12 10 00 00 21 A0 C2 02 2B B0 96 02 10 18 00 00 02 38 A6 70 21 18 E3 00 21 50 43 01 21 B0 CA 02 00 80 02 3C 21 10 82 02 2B 10 54 00 21 10 56 00 04 00 40 10 38 00 A3 8F FF FF 02 24 22 00 00 10 44 00 A2 AF ?? ?? 99 8F 44 00 A4 27 48 00 A3 AF 44 00 B4 AF 21 28 20 02 ?? ?? ?? ?? 21 30 00 02 44 00 A4 8F FF FF 02 24 10 00 BC 8F 16 00 82 10 48 00 A3 8F 0D 00 61 04 38 00 A2 8F 0B 00 55 10 00 00 00 00 00 00 C3 8F 00 00 E2 8E 23 10 62 00 C3 27 02 00 21 10 82 02 2B 18 54 00 21 B0 C4 02 21 A0 40 00 DE FF 00 10 21 B0 76 00 07 00 60 12 74 00 BF 8F ?? ?? 99 8F 21 20 40 02 21 28 20 02 ?? ?? ?? ?? 2C 00 06 24 74 00 BF 8F 44 00 A2 8F 70 00 BE 8F 6C 00 B7 8F 68 00 B6 8F 64 00 B5 8F 60 00 B4 8F 5C 00 B3 8F 58 00 B2 8F 54 00 B1 8F 50 00 B0 8F 08 00 E0 03 78 00 BD 27 }
	condition:
		$1
}

rule file_850_0_0 {
	meta:
		name = "__GI_sendto"
		size = 108
		refs = "0000 _gp_disp 0044 __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 18 00 B0 AF 1C 00 BF AF 34 00 B0 8F 30 00 A2 8F E0 FF BD 27 10 00 A2 AF 14 00 B0 AF 54 10 02 24 0C 00 00 00 20 00 BD 27 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_852_0_0 {
	meta:
		name = "__GI_strdup"
		size = 124
		refs = "0000 _gp_disp 000c __GI_strlen 0034 malloc 004c __GI_memcpy"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F D8 FF BD 27 10 00 BC AF 24 00 BF AF 20 00 B1 AF 1C 00 B0 AF ?? ?? ?? ?? 21 88 80 00 10 00 BC 8F 01 00 50 24 ?? ?? 99 8F ?? ?? ?? ?? 21 20 00 02 21 18 40 00 07 00 40 10 10 00 BC 8F ?? ?? 99 8F 21 20 40 00 21 28 20 02 ?? ?? ?? ?? 21 30 00 02 21 18 40 00 24 00 BF 8F 20 00 B1 8F 1C 00 B0 8F 21 10 60 00 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_854_0_0 {
	meta:
		name = "__GI_getdelim"
		size = 424
		refs = "0000 _gp_disp 0054 __GI___errno_location 0078 _pthread_cleanup_push_defer 007c __pthread_mutex_unlock 0094 __pthread_mutex_lock 00b0 __GI___fgetc_unlocked 00cc realloc 0164 _pthread_cleanup_pop_restore"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 B0 FF BD 27 10 00 BC AF 38 00 B4 AF 4C 00 BF AF 48 00 BE AF 44 00 B7 AF 40 00 B6 AF 3C 00 B5 AF 34 00 B3 AF 30 00 B2 AF 2C 00 B1 AF 28 00 B0 AF 05 00 80 10 21 A0 80 00 03 00 A0 10 21 98 A0 00 07 00 E0 14 21 80 E0 00 ?? ?? 99 8F ?? ?? ?? ?? FF FF 12 24 16 00 03 24 43 00 00 10 00 00 43 AC 34 00 F5 8C 0C 00 A0 16 21 B0 C0 00 ?? ?? 99 8F ?? ?? 85 8F 38 00 F1 24 18 00 A4 27 ?? ?? ?? ?? 21 30 20 02 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 20 02 10 00 BC 8F 00 00 91 8E 01 00 20 52 00 00 60 AE ?? ?? 97 8F 01 00 12 24 FF FF 1E 24 00 00 65 8E 2B 10 45 02 0F 00 40 54 10 00 02 8E ?? ?? 99 8F 21 20 20 02 ?? ?? ?? ?? 40 00 A5 24 21 88 40 00 03 00 40 14 10 00 BC 8F 1C 00 00 10 FF FF 12 24 00 00 62 8E 00 00 91 AE 40 00 42 24 00 00 62 AE 10 00 02 8E 18 00 03 8E 2B 18 43 00 04 00 60 10 01 00 43 24 10 00 03 AE 06 00 00 10 00 00 42 90 21 C8 E0 02 ?? ?? ?? ?? 21 20 00 02 05 00 5E 10 10 00 BC 8F 01 00 52 26 21 18 32 02 DF FF 56 14 FE FF 62 A0 01 00 02 24 04 00 42 52 FF FF 12 24 FF FF 52 26 21 88 32 02 00 00 20 A2 06 00 A0 16 4C 00 BF 8F ?? ?? 99 8F 18 00 A4 27 ?? ?? ?? ?? 01 00 05 24 4C 00 BF 8F 21 10 40 02 48 00 BE 8F 44 00 B7 8F 40 00 B6 8F 3C 00 B5 8F 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 E0 03 50 00 BD 27 }
	condition:
		$1
}

rule file_858_0_0 {
	meta:
		name = "__GI_mbrlen"
		size = 56
		refs = "0000 _gp_disp 0024 __GI_mbrtowc"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 21 18 80 00 21 10 A0 00 03 00 C0 14 21 38 C0 00 ?? ?? 87 8F ?? ?? E7 24 ?? ?? 99 8F 21 20 00 00 21 28 60 00 ?? ?? ?? ?? 21 30 40 00 }
	condition:
		$1
}

rule file_860_0_0 {
	meta:
		name = "acct"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF D3 0F 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_861_0_0 {
	meta:
		name = "writev"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 32 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_862_0_0 {
	meta:
		name = "pause"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF BD 0F 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_863_0_0 {
	meta:
		name = "splice"
		size = 108
		refs = "0000 _gp_disp 0044 __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 18 00 B0 AF 1C 00 BF AF 34 00 B0 8F 30 00 A2 8F E0 FF BD 27 10 00 A2 AF 14 00 B0 AF D0 10 02 24 0C 00 00 00 20 00 BD 27 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_864_0_0 {
	meta:
		name = "sched_getscheduler"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 41 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_865_0_0 {
	meta:
		name = "difftime"
		size = 124
		refs = "0000 _gp_disp 000c __floatsidf 0054 __subdf3"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F D8 FF BD 27 24 00 BF AF 20 00 B2 AF 1C 00 B1 AF 18 00 B0 AF 10 00 BC AF ?? ?? ?? ?? 21 90 A0 00 10 00 BC 8F 21 20 40 02 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 21 88 60 00 10 00 BC 8F 21 20 00 02 21 28 20 02 ?? ?? 99 8F 21 30 40 00 ?? ?? ?? ?? 21 38 60 00 24 00 BF 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_866_0_0 {
	meta:
		name = "__GI_sendmsg"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 53 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_867_0_0 {
	meta:
		name = "mkdtemp"
		size = 68
		refs = "0000 _gp_disp 000c __gen_tempname"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F E0 FF BD 27 02 00 05 24 1C 00 BF AF 18 00 B0 AF 10 00 BC AF ?? ?? ?? ?? 21 80 80 00 1C 00 BF 8F 0B 80 02 00 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_868_0_0 {
	meta:
		name = "__GI_ffs"
		size = 116
	strings:
		$1 = { FF FF 82 30 03 00 40 14 01 00 03 24 03 24 04 00 11 00 03 24 FF 00 82 30 05 00 40 14 0F 00 82 30 08 00 63 24 20 1C 03 7C 03 22 04 00 0F 00 82 30 05 00 40 14 03 00 82 30 04 00 63 24 20 1C 03 7C 03 21 04 00 03 00 82 30 06 00 40 54 01 00 82 24 83 20 04 00 05 00 80 10 02 00 63 24 20 1C 03 7C 01 00 82 24 01 00 42 30 21 10 62 00 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_871_0_0 {
	meta:
		name = "__GI_readdir64"
		size = 264
		refs = "0000 _gp_disp 0010 _pthread_cleanup_push_defer 0014 __pthread_mutex_unlock 004c __pthread_mutex_lock 005c __getdents64 00d0 _pthread_cleanup_pop_restore"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 C0 FF BD 27 ?? ?? 99 8F ?? ?? 85 8F 34 00 B2 AF 30 00 B1 AF 18 00 B2 27 18 00 91 24 10 00 BC AF 3C 00 BF AF 38 00 B3 AF 2C 00 B0 AF 21 30 20 02 21 80 80 00 ?? ?? ?? ?? 21 20 40 02 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 20 02 10 00 BC 8F ?? ?? 93 8F 08 00 03 8E 04 00 02 8E 2B 10 43 00 0B 00 40 54 04 00 02 8E 00 00 04 8E 0C 00 05 8E 21 C8 60 02 ?? ?? ?? ?? 14 00 06 8E 12 00 40 18 10 00 BC 8F 08 00 02 AE 04 00 00 AE 04 00 02 8E 0C 00 11 8E 21 88 22 02 10 00 23 96 21 10 62 00 04 00 02 AE 08 00 22 8E 10 00 02 AE 00 00 22 8E 04 00 23 8E 25 10 43 00 E7 FF 40 50 08 00 03 8E 03 00 00 10 ?? ?? 99 8F 21 88 00 00 ?? ?? 99 8F 21 20 40 02 ?? ?? ?? ?? 01 00 05 24 3C 00 BF 8F 21 10 20 02 38 00 B3 8F 34 00 B2 8F 30 00 B1 8F 2C 00 B0 8F 08 00 E0 03 40 00 BD 27 }
	condition:
		$1
}

rule file_872_0_0 {
	meta:
		name = "vhangup"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF 0F 10 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_873_0_0 {
	meta:
		name = "wcsdup"
		size = 128
		refs = "0000 _gp_disp 000c __GI_wcslen 0038 malloc 0050 __GI_memcpy"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F D8 FF BD 27 10 00 BC AF 24 00 BF AF 20 00 B1 AF 1C 00 B0 AF ?? ?? ?? ?? 21 88 80 00 10 00 BC 8F 01 00 42 24 80 80 02 00 ?? ?? 99 8F ?? ?? ?? ?? 21 20 00 02 21 18 40 00 07 00 40 10 10 00 BC 8F ?? ?? 99 8F 21 20 40 00 21 28 20 02 ?? ?? ?? ?? 21 30 00 02 21 18 40 00 24 00 BF 8F 20 00 B1 8F 1C 00 B0 8F 21 10 60 00 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_874_0_0 {
	meta:
		name = "__GI_gethostbyname2_r"
		size = 72
		refs = "0000 _gp_disp 0028 __GI_gethostbyname_r"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 02 00 09 24 21 18 C0 00 10 00 A2 8F 21 30 E0 00 14 00 A8 8F 07 00 A9 14 18 00 A7 8F ?? ?? 99 8F 14 00 A7 AF 10 00 A8 AF 21 28 60 00 ?? ?? ?? ?? 21 38 40 00 08 00 E0 03 01 00 02 24 }
	condition:
		$1
}

rule file_875_0_0 {
	meta:
		name = "__opensock"
		size = 32
		refs = "0000 _gp_disp 000c __GI_socket"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F 02 00 04 24 01 00 05 24 ?? ?? ?? ?? 21 30 00 00 }
	condition:
		$1
}

rule file_876_0_0 {
	meta:
		name = "__GI_ungetwc"
		size = 300
		refs = "0000 _gp_disp 0038 _pthread_cleanup_push_defer 0040 __pthread_mutex_unlock 0054 __pthread_mutex_lock 0074 __stdio_trans2r_o 00fc _pthread_cleanup_pop_restore"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 C0 FF BD 27 30 00 B1 AF 2C 00 B0 AF 10 00 BC AF 3C 00 BF AF 38 00 B3 AF 34 00 B2 AF 34 00 B2 8C 21 88 80 00 0C 00 40 16 21 80 A0 00 ?? ?? 99 8F 38 00 B3 24 ?? ?? 85 8F 18 00 A4 27 ?? ?? ?? ?? 21 30 60 02 10 00 BC 8F ?? ?? 99 8F ?? ?? ?? ?? 21 20 60 02 10 00 BC 8F 00 00 02 96 03 08 42 30 01 08 42 2C 07 00 40 14 ?? ?? 99 8F 00 00 02 96 02 00 43 30 0A 00 60 54 01 00 43 30 0E 00 00 10 FF FF 03 24 21 20 00 02 ?? ?? ?? ?? 00 08 05 24 F6 FF 40 10 10 00 BC 8F 13 00 00 10 FF FF 11 24 11 00 60 54 FF FF 11 24 28 00 03 8E 0E 00 60 54 FF FF 11 24 FF FF 03 24 0B 00 23 12 01 00 42 24 01 00 03 24 FF FF 42 30 28 00 03 AE 01 00 43 30 08 00 63 24 80 18 03 00 21 18 03 02 FB FF 42 30 04 00 71 AC 00 00 02 A6 06 00 40 16 3C 00 BF 8F ?? ?? 99 8F 18 00 A4 27 ?? ?? ?? ?? 01 00 05 24 3C 00 BF 8F 21 10 20 02 38 00 B3 8F 34 00 B2 8F 30 00 B1 8F 2C 00 B0 8F 08 00 E0 03 40 00 BD 27 }
	condition:
		$1
}

rule file_877_0_0 {
	meta:
		name = "__xpg_basename"
		size = 116
		refs = "0000 _gp_disp"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 17 00 80 10 ?? ?? 82 8F 00 00 82 80 13 00 40 10 FF FF 83 24 21 10 80 00 2F 00 06 24 00 00 85 80 06 00 A6 50 01 00 84 24 01 00 63 24 2B 28 64 00 0B 18 85 00 0B 10 85 00 01 00 84 24 00 00 85 80 F6 FF A0 14 00 00 00 00 00 00 44 80 2F 00 84 38 0A 18 44 00 08 00 E0 03 01 00 60 A0 ?? ?? 82 8F 08 00 E0 03 ?? ?? 42 24 }
	condition:
		$1
}

rule file_878_0_0 {
	meta:
		name = "__GI_isprint"
		size = 40
		refs = "0000 _gp_disp 000c __GI___ctype_b"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 82 8F 40 20 04 00 00 00 42 8C 21 10 44 00 00 00 42 94 08 00 E0 03 40 00 42 30 }
	condition:
		$1
}

rule file_879_0_0 {
	meta:
		name = "__GI_alarm"
		size = 84
		refs = "0000 _gp_disp 002c __GI___errno_location"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 E0 FF BD 27 10 00 BC AF 1C 00 BF AF 18 00 B0 AF BB 0F 02 24 0C 00 00 00 06 00 E0 10 21 80 40 00 ?? ?? 99 8F ?? ?? ?? ?? 00 00 00 00 00 00 50 AC FF FF 10 24 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_880_0_0 {
	meta:
		name = "_ppfs_init"
		size = 232
		refs = "0000 _gp_disp 000c __GI_memset 0070 _ppfs_parsespec"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F D0 FF BD 27 98 00 06 24 10 00 BC AF 20 00 B1 AF 1C 00 B0 AF 21 88 A0 00 21 80 80 00 2C 00 BF AF 28 00 B3 AF 24 00 B2 AF ?? ?? ?? ?? 21 28 00 00 18 00 02 8E 10 00 BC 8F 00 00 11 AE FF FF 42 24 18 00 02 AE 28 00 03 26 09 00 02 24 08 00 04 24 FF FF 42 24 00 00 64 AC FD FF 40 14 04 00 63 24 ?? ?? 93 8F 21 10 20 02 25 00 12 24 00 00 43 80 11 00 60 50 00 00 11 AE FC FF 72 54 01 00 42 24 01 00 43 24 01 00 42 80 08 00 52 10 21 C8 60 02 00 00 03 AE ?? ?? ?? ?? 21 20 00 02 07 00 42 04 FF FF 02 24 F1 FF 00 10 00 00 02 8E 21 10 60 00 EE FF 00 10 01 00 42 24 21 10 00 00 2C 00 BF 8F 28 00 B3 8F 24 00 B2 8F 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_1_0_1 {
	meta:
		name = "floorf"
		size = 88
		refs = "0000 _gp_disp 000c __extendsfdf2 002c __GI_floor 0040 __truncdfsf2"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F E0 FF BD 27 1C 00 BF AF 10 00 BC AF ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F 21 20 40 00 ?? ?? 99 8F ?? ?? ?? ?? 21 28 60 00 10 00 BC 8F 21 20 40 00 ?? ?? 99 8F ?? ?? ?? ?? 21 28 60 00 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_23_0_1 {
	meta:
		name = "acosf"
		size = 88
		refs = "0000 _gp_disp 000c __extendsfdf2 002c __GI_acos 0040 __truncdfsf2"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F E0 FF BD 27 1C 00 BF AF 10 00 BC AF ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F 21 20 40 00 ?? ?? 99 8F ?? ?? ?? ?? 21 28 60 00 10 00 BC 8F 21 20 40 00 ?? ?? 99 8F ?? ?? ?? ?? 21 28 60 00 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_9_0_1 {
	meta:
		name = "acoshf"
		size = 88
		refs = "0000 _gp_disp 000c __extendsfdf2 002c __GI_acosh 0040 __truncdfsf2"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F E0 FF BD 27 1C 00 BF AF 10 00 BC AF ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F 21 20 40 00 ?? ?? 99 8F ?? ?? ?? ?? 21 28 60 00 10 00 BC 8F 21 20 40 00 ?? ?? 99 8F ?? ?? ?? ?? 21 28 60 00 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_84_0_1 {
	meta:
		name = "asinf"
		size = 88
		refs = "0000 _gp_disp 000c __extendsfdf2 002c __GI_asin 0040 __truncdfsf2"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F E0 FF BD 27 1C 00 BF AF 10 00 BC AF ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F 21 20 40 00 ?? ?? 99 8F ?? ?? ?? ?? 21 28 60 00 10 00 BC 8F 21 20 40 00 ?? ?? 99 8F ?? ?? ?? ?? 21 28 60 00 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_59_0_1 {
	meta:
		name = "asinhf"
		size = 88
		refs = "0000 _gp_disp 000c __extendsfdf2 002c __GI_asinh 0040 __truncdfsf2"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F E0 FF BD 27 1C 00 BF AF 10 00 BC AF ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F 21 20 40 00 ?? ?? 99 8F ?? ?? ?? ?? 21 28 60 00 10 00 BC 8F 21 20 40 00 ?? ?? 99 8F ?? ?? ?? ?? 21 28 60 00 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_81_0_1 {
	meta:
		name = "atanf"
		size = 88
		refs = "0000 _gp_disp 000c __extendsfdf2 002c __GI_atan 0040 __truncdfsf2"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F E0 FF BD 27 1C 00 BF AF 10 00 BC AF ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F 21 20 40 00 ?? ?? 99 8F ?? ?? ?? ?? 21 28 60 00 10 00 BC 8F 21 20 40 00 ?? ?? 99 8F ?? ?? ?? ?? 21 28 60 00 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_42_0_1 {
	meta:
		name = "atanhf"
		size = 88
		refs = "0000 _gp_disp 000c __extendsfdf2 002c __GI_atanh 0040 __truncdfsf2"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F E0 FF BD 27 1C 00 BF AF 10 00 BC AF ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F 21 20 40 00 ?? ?? 99 8F ?? ?? ?? ?? 21 28 60 00 10 00 BC 8F 21 20 40 00 ?? ?? 99 8F ?? ?? ?? ?? 21 28 60 00 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_78_0_1 {
	meta:
		name = "cbrtf"
		size = 88
		refs = "0000 _gp_disp 000c __extendsfdf2 002c __GI_cbrt 0040 __truncdfsf2"
	strings:
		$1 = { ?? ?? 1C 3C ?? ?? 9C 27 21 E0 99 03 ?? ?? 99 8F E0 FF BD 27 1C 00 BF AF 10 00 BC AF ?? ?? ?? ?? 00 00 00 00 10 00 BC 8F 21 20 40 00 ?? ?? 99 8F ?? ?? ?? ?? 21 28 60 00 10 00 BC 8F 21 20 40 00 ?? ?? 99 8F ?? ?? ?? ??