private rule architecture {
	meta:
		bits = 32
		endianness = "little"
		architecture = "x86"
	condition:
		true
}

rule file_2_0_0 {
	meta:
		name = "___avx_asinf8"
		size = 352
		refs = "0010 ___common_sasin_data 014a ___common_sasin_cout_rare"
	strings:
		$1 = { 55 8B EC 83 E4 C0 81 EC C0 00 00 00 C5 FC 10 15 ?? ?? ?? ?? C5 FC 10 25 ?? ?? ?? ?? C5 FC 11 04 24 C5 EC 54 C8 C5 F4 59 DC C5 F4 59 E9 C5 F4 C2 35 ?? ?? ?? ?? 1D C5 DC 5C FB C5 F4 C2 E4 15 C5 D4 5D DF C5 EC 55 D0 C4 E3 7D 19 F5 01 C5 C9 6B C5 C5 D1 EF ED C5 F9 63 F5 C5 FC 52 C7 C5 C4 58 FF C5 F9 D7 D6 C5 FC 59 E8 C5 C4 59 C0 C5 C4 59 FD C5 C4 5C 3D ?? ?? ?? ?? C5 C4 59 35 ?? ?? ?? ?? C5 CC 58 2D ?? ?? ?? ?? C5 FC 59 F7 C5 D4 59 FE C5 E4 59 2D ?? ?? ?? ?? C5 C4 5C F8 C5 D4 58 2D ?? ?? ?? ?? C5 E4 59 05 ?? ?? ?? ?? C5 FC 58 35 ?? ?? ?? ?? C5 E4 59 C3 C5 CC 59 F0 C5 CC 58 C5 C5 FC 59 EB C4 E3 75 4A C7 40 C5 D4 58 35 ?? ?? ?? ?? C5 CC 59 DB C5 E4 59 C8 C5 F4 58 C8 C5 DC 54 1D ?? ?? ?? ?? C5 F4 58 E3 C5 DC 57 C2 84 D2 75 04 8B E5 5D C3 C5 FC 10 0C 24 C5 FC 11 84 24 80 00 00 00 C5 FC 11 4C 24 40 85 D2 74 E4 33 C0 89 74 24 04 8B F0 89 3C 24 8B FA 0F A3 F7 72 18 46 83 FE 20 7C F5 8B 74 24 04 8B 3C 24 C5 FC 10 84 24 80 00 00 00 EB BA C5 F8 77 8D 8C B4 80 00 00 00 8D 44 B4 40 51 50 E8 ?? ?? ?? ?? 83 C4 08 EB CE 8D A4 24 00 00 00 00 8D 9B 00 00 00 00 }
	condition:
		$1
}

rule file_3_0_0 {
	meta:
		name = "__EH_prolog2"
		size = 56
	strings:
		$1 = { 51 8B 4C 24 08 89 5C 24 08 8D 5C 24 08 F7 D9 23 E1 8B 4B F8 89 2C 24 8B EC 6A FF 50 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 51 8B 43 FC 8B 4B 04 89 4D 04 59 50 F2 C3 }
	condition:
		$1
}

rule file_4_0_0 {
	meta:
		name = "___avx_floorf8"
		size = 16
	strings:
		$1 = { C4 E3 7D 08 C0 01 C3 8D A4 24 00 00 00 00 8B FF }
	condition:
		$1
}

rule file_5_0_0 {
	meta:
		name = "___sse2_ceilf4"
		size = 112
		refs = "0021 _static_const_table"
	strings:
		$1 = { 8B C4 83 EC 50 83 E4 F0 89 44 24 14 66 0F 6F C8 F3 0F 5B D0 66 0F 72 E1 1F 66 0F 6F D8 66 0F DB 05 ?? ?? ?? ?? 0F 5B D2 66 0F 6F E9 66 0F 72 F1 1F 66 0F 66 05 ?? ?? ?? ?? 66 0F EB D1 66 0F 6F E3 66 0F DB D8 66 0F DF C2 66 0F EB C3 66 0F 76 E0 66 0F DF 25 ?? ?? ?? ?? 66 0F DF EC 0F 5C C5 8B 64 24 14 C3 8D A4 24 00 00 00 00 8D 64 24 00 }
	condition:
		$1
}

rule file_7_0_0 {
	meta:
		name = "__exp_spec_sd"
		size = 272
		refs = "0004 _static_const_table"
	strings:
		$1 = { 66 0F 28 1D ?? ?? ?? ?? 8B 70 04 8B 08 8B FE 81 E6 FF FF FF 7F 81 FE 00 00 F0 7F 66 0F FE CB 77 63 72 09 85 C9 BE 00 00 00 00 75 58 33 F6 81 FF 10 49 87 C0 0F 87 A4 00 00 00 72 0C 81 F9 52 30 2D D5 0F 83 96 00 00 00 81 FF 2B 23 86 C0 77 62 72 08 81 F9 D1 BC 7A DD 73 58 81 FF 42 2E 86 40 7F 41 7C 08 81 F9 F0 39 FA FE 73 37 81 FF 37 2E 86 40 7F 1D 7C 08 81 F9 72 BA D8 E7 73 13 66 0F 28 D6 EB 63 66 0F 57 D2 33 F6 66 0F C2 D2 00 EB 56 66 0F 59 15 ?? ?? ?? ?? 66 0F 59 15 ?? ?? ?? ?? EB 44 BE 01 00 00 00 66 0F 28 15 ?? ?? ?? ?? EB 35 66 0F FE CB 66 0F 28 2D ?? ?? ?? ?? 66 0F 73 F1 2E BE FF FF FF FF 66 0F DB 0D ?? ?? ?? ?? 66 0F FA CD 66 0F 59 D1 66 0F 59 D5 EB 09 BE FF FF FF FF 66 0F 57 D2 85 F6 7C 03 7F 12 C3 66 0F EF ED 66 0F 76 FF 66 0F FA EF 66 0F 59 ED C3 66 0F 28 2D ?? ?? ?? ?? 66 0F 58 ED C3 8D 64 24 00 }
	condition:
		$1
}

rule file_7_1_0 {
	meta:
		name = "___sse2_exp2"
		size = 416
		refs = "001f _static_const_table"
	strings:
		$1 = { 8B C4 81 EC 90 00 00 00 83 E4 F0 89 44 24 54 66 0F 28 C8 89 4C 24 34 89 5C 24 30 66 0F 28 15 ?? ?? ?? ?? 89 74 24 3C 89 7C 24 38 66 0F 59 D1 66 0F 28 1D ?? ?? ?? ?? 66 0F 28 25 ?? ?? ?? ?? 66 0F 58 D3 66 0F 28 2D ?? ?? ?? ?? 66 0F 28 F2 66 0F 29 0C 24 66 0F 5C D3 8D 44 24 04 66 0F 28 C6 66 0F 59 E2 66 0F 29 74 24 10 66 0F 73 F6 04 66 0F 59 EA 66 0F 5C CC 66 0F FE 05 ?? ?? ?? ?? 66 0F 7E F6 66 0F 5C CD 81 E6 F0 03 00 00 66 0F 73 F0 2E 66 0F 15 F6 66 0F 28 BE ?? ?? ?? ?? 66 0F 28 E1 8B 08 66 0F 7E F7 66 0F 28 15 ?? ?? ?? ?? 81 E7 F0 03 00 00 66 0F DB 05 ?? ?? ?? ?? 66 0F 59 D1 66 0F 28 B7 ?? ?? ?? ?? 66 0F 59 C9 8B 58 08 66 0F 28 EF 66 0F 58 15 ?? ?? ?? ?? 66 0F C6 EE 00 66 0F 59 D4 81 E1 FF FF FF 7F 66 0F 58 15 ?? ?? ?? ?? 66 0F C6 FE 03 81 E3 FF FF FF 7F 66 0F 59 D4 66 0F 28 DD 66 0F 58 15 ?? ?? ?? ?? 81 E9 2B 23 86 40 66 0F 58 EF 66 0F 59 D1 81 EB 2B 23 86 40 66 0F 58 E2 8B F9 66 0F 59 E5 23 CB 66 0F 58 E7 8D 04 24 66 0F 58 E3 F7 C1 00 00 00 80 66 0F 59 C4 74 12 8B 5C 24 30 8B 4C 24 34 8B 7C 24 38 8B 74 24 3C EB 3E 66 0F 28 F0 66 0F 28 4C 24 10 66 0F 28 D4 E8 85 FD FF FF 66 0F 28 C2 83 C0 08 66 0F 28 4C 24 10 66 0F 28 D4 E8 6F FD FF FF 66 0F C6 C2 02 8B 5C 24 30 8B 4C 24 34 8B 7C 24 38 8B 74 24 3C 8B 64 24 54 C3 EB 03 CC CC CC }
	condition:
		$1
}

rule file_9_0_0 {
	meta:
		name = "__alldiv"
		size = 170
	strings:
		$1 = { 57 56 53 33 FF 8B 44 24 14 0B C0 7D 14 47 8B 54 24 10 F7 D8 F7 DA 83 D8 00 89 44 24 14 89 54 24 10 8B 44 24 1C 0B C0 7D 14 47 8B 54 24 18 F7 D8 F7 DA 83 D8 00 89 44 24 1C 89 54 24 18 0B C0 75 18 8B 4C 24 18 8B 44 24 14 33 D2 F7 F1 8B D8 8B 44 24 10 F7 F1 8B D3 EB 41 8B D8 8B 4C 24 18 8B 54 24 14 8B 44 24 10 D1 EB D1 D9 D1 EA D1 D8 0B DB 75 F4 F7 F1 8B F0 F7 64 24 1C 8B C8 8B 44 24 18 F7 E6 03 D1 72 0E 3B 54 24 14 77 08 72 07 3B 44 24 10 76 01 4E 33 D2 8B C6 4F 75 07 F7 DA F7 D8 83 DA 00 5B 5E 5F C2 10 00 }
	condition:
		$1
}

rule file_16_0_0 {
	meta:
		name = "___sse2_sin2"
		size = 448
		refs = "001c _static_const_table 016a ___common_sin_reduction_LA"
	strings:
		$1 = { 8B C4 81 EC A0 00 00 00 83 E4 F0 89 44 24 64 66 0F 29 04 24 66 0F 28 C8 66 0F DB 05 ?? ?? ?? ?? 66 0F 28 25 ?? ?? ?? ?? 66 0F DB 0D ?? ?? ?? ?? 66 0F 28 D0 66 0F 28 F8 66 0F 59 05 ?? ?? ?? ?? 66 0F 28 2D ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 58 05 ?? ?? ?? ?? 66 0F 28 D8 66 0F 5C 05 ?? ?? ?? ?? 66 0F 66 3D ?? ?? ?? ?? 66 0F 50 C7 0B C0 0F 85 BA 00 00 00 66 0F 28 3D ?? ?? ?? ?? 66 0F 59 E0 66 0F 59 E8 66 0F 59 F0 66 0F 59 F8 66 0F 73 F3 3F 66 0F EF D9 66 0F 5C D4 66 0F 5C D5 66 0F 5C D6 66 0F 5C D7 66 0F 28 05 ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 28 CA 66 0F 59 D2 66 0F 28 E2 66 0F 59 E4 66 0F 59 D1 66 0F 59 C4 66 0F 59 F4 66 0F 58 05 ?? ?? ?? ?? 66 0F 58 35 ?? ?? ?? ?? 66 0F 59 C4 66 0F 59 F4 66 0F 58 05 ?? ?? ?? ?? 66 0F 58 35 ?? ?? ?? ?? 66 0F 59 C4 66 0F 59 F4 66 0F 58 05 ?? ?? ?? ?? 66 0F 58 35 ?? ?? ?? ?? 66 0F 59 C4 66 0F 59 F2 66 0F 59 C1 66 0F 58 F1 66 0F 58 C6 66 0F EF C3 E9 84 00 00 00 66 0F 28 04 24 66 0F 28 C8 66 0F DB 05 ?? ?? ?? ?? 66 0F DB 0D ?? ?? ?? ?? 66 0F 29 44 24 30 66 0F 29 4C 24 40 DD 44 24 30 8D 44 24 20 83 EC 20 DD 1C 24 89 44 24 08 E8 ?? ?? ?? ?? 83 C4 20 89 44 24 14 33 C0 89 44 24 10 DD 44 24 38 8D 44 24 28 83 EC 20 DD 1C 24 89 44 24 08 E8 ?? ?? ?? ?? 83 C4 20 89 44 24 1C 33 C0 89 44 24 18 66 0F 28 54 24 20 66 0F 28 5C 24 10 66 0F 57 5C 24 40 E9 F3 FE FF FF 8B 64 24 64 C3 EB 03 CC CC CC }
	condition:
		$1
}

rule file_17_0_0 {
	meta:
		name = "__alldvrm"
		size = 223
	strings:
		$1 = { 57 56 55 33 FF 33 ED 8B 44 24 14 0B C0 7D 15 47 45 8B 54 24 10 F7 D8 F7 DA 83 D8 00 89 44 24 14 89 54 24 10 8B 44 24 1C 0B C0 7D 14 47 8B 54 24 18 F7 D8 F7 DA 83 D8 00 89 44 24 1C 89 54 24 18 0B C0 75 28 8B 4C 24 18 8B 44 24 14 33 D2 F7 F1 8B D8 8B 44 24 10 F7 F1 8B F0 8B C3 F7 64 24 18 8B C8 8B C6 F7 64 24 18 03 D1 EB 47 8B D8 8B 4C 24 18 8B 54 24 14 8B 44 24 10 D1 EB D1 D9 D1 EA D1 D8 0B DB 75 F4 F7 F1 8B F0 F7 64 24 1C 8B C8 8B 44 24 18 F7 E6 03 D1 72 0E 3B 54 24 14 77 08 72 0F 3B 44 24 10 76 09 4E 2B 44 24 18 1B 54 24 1C 33 DB 2B 44 24 10 1B 54 24 14 4D 79 07 F7 DA F7 D8 83 DA 00 8B CA 8B D3 8B D9 8B C8 8B C6 4F 75 07 F7 DA F7 D8 83 DA 00 5D 5E 5F C2 10 00 }
	condition:
		$1
}

rule file_18_0_0 {
	meta:
		name = "___vdecl_fmod4"
		size = 89
		refs = "0016 __CIfmod"
	strings:
		$1 = { 83 EC 40 C5 FE 7F 04 24 C5 FE 7F 4C 24 20 DD 04 24 DD 44 24 20 E8 ?? ?? ?? ?? DD 1C 24 DD 44 24 08 DD 44 24 28 E8 ?? ?? ?? ?? DD 5C 24 08 DD 44 24 10 DD 44 24 30 E8 ?? ?? ?? ?? DD 5C 24 10 DD 44 24 18 DD 44 24 38 E8 ?? ?? ?? ?? DD 5C 24 18 C5 FE 6F 04 24 83 C4 40 C3 }
	condition:
		$1
}

rule file_28_0_0 {
	meta:
		name = "__sinh_spec_sd"
		size = 320
		refs = "004f _static_const_table"
	strings:
		$1 = { 8B 58 04 8B 08 81 E3 FF FF FF 7F 81 FB 36 23 86 40 0F 82 15 01 00 00 F2 0F 10 30 0F 87 BE 00 00 00 81 FB 50 3C 9C F4 0F 82 FF 00 00 00 81 FB C3 33 86 40 72 2D 77 08 81 F9 00 79 98 78 72 23 8B 48 50 C1 E1 04 81 E1 F0 03 00 00 66 0F 28 B9 ?? ?? ?? ?? 66 0F 28 EF BB 01 00 00 00 66 0F 15 FF EB 0C F2 0F 10 68 10 F2 0F 10 78 20 33 DB 66 0F 28 DD F2 0F 10 70 40 66 0F 28 D6 66 0F 28 0D ?? ?? ?? ?? F2 0F 59 CE 66 0F 58 EF F2 0F 59 F6 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CA F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CA F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CE F2 0F 58 D1 F2 0F 59 D5 F2 0F 10 30 F2 0F 58 D7 85 DB F2 0F 58 D3 74 51 F2 0F 59 15 ?? ?? ?? ?? 33 DB F2 0F 59 15 ?? ?? ?? ?? EB 3D 81 FB CE 33 86 40 0F 82 42 FF FF FF 77 18 81 FB 7D F8 B9 8F 0F 82 34 FF FF FF 33 DB F2 0F 10 15 ?? ?? ?? ?? EB 17 81 FB 00 00 F0 7F 72 EC 77 04 85 C9 74 E8 66 0F 57 D2 66 0F C2 D2 00 66 0F 54 35 ?? ?? ?? ?? 85 DB 66 0F 56 D6 74 01 C3 66 0F 28 2D ?? ?? ?? ?? 66 0F 58 ED C3 8D 9B 00 00 00 00 }
	condition:
		$1
}

rule file_28_1_0 {
	meta:
		name = "___sse2_sinh2"
		size = 560
		refs = "0016 _static_const_table"
	strings:
		$1 = { 8B C4 81 EC E0 00 00 00 83 E4 F0 89 84 24 A4 00 00 00 66 0F 28 3D ?? ?? ?? ?? 66 0F 28 C8 66 0F 28 15 ?? ?? ?? ?? 66 0F 54 C7 89 74 24 08 66 0F 28 1D ?? ?? ?? ?? 66 0F 59 D0 66 0F 54 F9 66 0F 28 25 ?? ?? ?? ?? 66 0F 58 D3 66 0F 28 2D ?? ?? ?? ?? 66 0F 28 F2 66 0F 29 4C 24 10 66 0F 5C D3 8D 44 24 10 66 0F 28 CE 66 0F 59 E2 66 0F 57 DB 66 0F C2 3D ?? ?? ?? ?? 05 66 0F 73 F6 04 66 0F 29 4C 24 60 66 0F 59 EA 66 0F FB D9 66 0F 5C C4 66 0F 7E F6 89 7C 24 04 66 0F 5C C5 66 0F 50 CF 66 0F FE 0D ?? ?? ?? ?? 81 E6 F0 03 00 00 66 0F 15 F6 66 0F FE 1D ?? ?? ?? ?? 66 0F 73 F1 2E 66 0F 7E F7 66 0F 28 BE ?? ?? ?? ?? 81 E7 F0 03 00 00 66 0F 73 F3 2E 66 0F 29 44 24 50 F7 DE 66 0F 28 B7 ?? ?? ?? ?? 81 C6 00 04 00 00 66 0F DB 0D ?? ?? ?? ?? 66 0F 28 EF F7 DF 66 0F DB 1D ?? ?? ?? ?? 66 0F C6 EE 00 81 C7 00 04 00 00 66 0F 28 A6 ?? ?? ?? ?? 66 0F C6 FE 03 66 0F 28 97 ?? ?? ?? ?? 66 0F 59 E9 66 0F 28 F4 66 0F 59 F9 66 0F C6 E2 00 66 0F 29 6C 24 20 66 0F 28 C8 66 0F C6 F2 03 66 0F 59 E3 66 0F 28 15 ?? ?? ?? ?? 66 0F 59 C0 66 0F 29 64 24 40 66 0F 59 F3 66 0F 58 EF 66 0F 28 1D ?? ?? ?? ?? F7 C1 03 00 00 00 66 0F 59 D0 66 0F 58 E6 66 0F 29 7C 24 30 66 0F 59 D8 66 0F 58 15 ?? ?? ?? ?? 66 0F 28 FD 66 0F 58 1D ?? ?? ?? ?? 66 0F 59 D0 66 0F 5C EC 66 0F 59 D8 66 0F 58 FC 66 0F 28 44 24 30 66 0F 59 D1 66 0F 28 20 66 0F 59 DD 66 0F 58 D1 8B 74 24 08 66 0F 5C C6 66 0F 54 25 ?? ?? ?? ?? 66 0F 59 D7 66 0F 28 6C 24 20 66 0F 58 C3 66 0F 5C 6C 24 40 66 0F 58 C2 8B 7C 24 04 66 0F 58 C5 66 0F 56 C4 75 02 EB 2F 89 1C 24 8D 44 24 10 66 0F 28 E0 66 0F 28 D0 66 0F 15 E4 E8 B6 FC FF FF 83 C0 08 66 0F 28 C2 66 0F 28 D4 E8 A6 FC FF FF 66 0F 14 C2 8B 1C 24 8B A4 24 A4 00 00 00 C3 8D A4 24 00 00 00 00 }
	condition:
		$1
}

rule file_33_0_0 {
	meta:
		name = "___common_sin_reduction_LA"
		size = 752
		refs = "006c __d02PI 0095 __DP4 013c __e02PI 0175 _2il0floatpacket_2 02aa __dPI02"
	strings:
		$1 = { 55 8B EC 83 E4 F0 56 57 53 83 EC 54 B8 00 00 F0 7F 8B 55 0C 8B 5D 10 2B D0 0F 8D B7 02 00 00 33 C0 66 89 44 24 3C D9 7C 24 3E 0F B7 54 24 3E 8B C2 25 00 0F 00 00 3D 00 03 00 00 74 15 81 E2 FF F0 FF FF 81 CA 00 03 FF FF 66 89 54 24 3C D9 6C 24 3C DD 45 08 F2 0F 10 45 08 8B 45 0C DB 7C 24 48 81 7D 0C 00 40 FF 40 73 6E DB 2D ?? ?? ?? ?? DB 6C 24 48 DC C9 D9 C9 D9 3C 24 0F B7 04 24 0D 00 0C 00 00 89 44 24 08 D9 6C 24 08 DB 5C 24 10 D9 2C 24 DD 05 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? 8B 7C 24 10 47 83 E7 FE 89 7C 24 18 DB 44 24 18 DC CC D9 CC DE ED D9 CA D8 CB DE EC D8 CA DE EB DE C9 DE E9 DB 7C 24 48 E9 DC 01 00 00 8B C8 05 00 00 80 F3 C1 E9 14 81 E1 FF 07 00 00 F2 0F 11 44 24 10 89 44 24 14 B8 1F 85 EB 51 DD 44 24 10 DB 3C 24 DB 2C 24 8D B9 E4 FB FF FF F7 EF 8B F2 C1 FE 03 C1 FF 1F 2B F7 83 64 24 04 C0 C7 04 24 00 00 00 00 DB 2C 24 6B C6 E7 DC E9 D9 C9 DB 7C 24 20 8D 94 08 E4 FB FF FF 83 FA 11 7C 3A DD 04 F5 ?? ?? ?? ?? DD 04 F5 ?? ?? ?? ?? 46 D8 CA DB 6C 24 20 DE CA DE C1 DB 7C 24 10 DB 6C 24 10 83 64 24 14 C0 C7 44 24 10 00 00 00 00 DB 6C 24 10 DE E9 DB 7C 24 48 EB 0A DB 2D ?? ?? ?? ?? DB 7C 24 48 DD 04 F5 ?? ?? ?? ?? D9 C1 DD 04 F5 ?? ?? ?? ?? DC C9 DD 04 F5 ?? ?? ?? ?? DE CC DB 6C 24 20 DC CB D9 CA DE C3 DE C9 DE C2 D9 C9 DB 7C 24 10 DB 6C 24 10 DB 6C 24 48 DE C2 D9 C9 DB 7C 24 48 DB 6C 24 48 DE C1 DD 5C 24 30 F2 0F 10 44 24 30 F2 0F 11 44 24 40 8B 44 24 44 C1 E8 14 25 FF 07 00 00 F7 D8 05 33 04 00 00 89 44 24 2C 50 FF 74 24 48 FF 74 24 48 E8 F9 00 00 00 83 C4 0C 8B F8 83 C7 01 83 D2 00 83 E7 FE 89 54 24 44 89 7C 24 40 FF 74 24 2C 52 57 E8 08 01 00 00 83 C4 0C DB 6C 24 48 DB 6C 24 10 DB 6C 24 20 DD 04 F5 ?? ?? ?? ?? DD 04 F5 ?? ?? ?? ?? DD 04 F5 ?? ?? ?? ?? DD 04 F5 ?? ?? ?? ?? 89 44 24 40 89 54 24 44 DB 7C 24 30 DD 44 24 40 DE EE D9 CC DE C5 D9 C1 D9 CA D8 CB DB 2C 24 DC CB DD 04 F5 ?? ?? ?? ?? D8 CD DE C4 D9 CB DE C6 D9 C1 D8 CB DE C1 DE C5 D9 C3 D8 CA D9 C9 D8 CB DE C1 DE C4 D9 C9 DC CA DB 6C 24 30 D9 C0 D8 CB DE C4 D9 CB DE C4 DE CA DD 04 F5 ?? ?? ?? ?? DE C9 DE C1 DE C1 DB 2D ?? ?? ?? ?? DE C9 DB 7C 24 48 DB 6C 24 48 0F B7 44 24 3C 85 C0 DD 1B 74 04 D9 6C 24 3E C1 E7 1E 8B C7 83 C4 54 5B 5F 5E 8B E5 5D C3 33 C0 C7 03 FF FF FF FF C7 43 04 FF FF FF 7F 83 C4 54 5B 5F 5E 8B E5 5D C3 90 }
	condition:
		$1
}

rule file_33_1_0 {
	meta:
		name = "___common_srl"
		size = 48
	strings:
		$1 = { 8B 44 24 04 8B 54 24 08 8B 4C 24 0C 80 F9 40 73 16 80 F9 20 73 06 0F AD D0 D3 FA C3 8B C2 C1 FA 1F 80 E1 1F D3 F8 C3 C1 FA 1F 8B C2 C3 8D 49 00 }
	condition:
		$1
}

rule file_33_2_0 {
	meta:
		name = "___common_sll"
		size = 48
	strings:
		$1 = { 8B 44 24 04 8B 54 24 08 8B 4C 24 0C 80 F9 40 73 15 80 F9 20 73 06 0F A5 C2 D3 E0 C3 8B D0 33 C0 80 E1 1F D3 E2 C3 33 C0 33 D2 C3 EB 03 CC CC CC }
	condition:
		$1
}

rule file_33_3_0 {
	meta:
		name = "___common_cos_reduction_LA"
		size = 752
		refs = "006c __d02PI 0095 __DP4 013b __e02PI 0174 _2il0floatpacket_9 02a3 __dPI02"
	strings:
		$1 = { 55 8B EC 83 E4 F0 56 57 53 83 EC 54 B8 00 00 F0 7F 8B 55 0C 8B 5D 10 2B D0 0F 8D B8 02 00 00 33 C0 66 89 44 24 3C D9 7C 24 3E 0F B7 54 24 3E 8B C2 25 00 0F 00 00 3D 00 03 00 00 74 15 81 E2 FF F0 FF FF 81 CA 00 03 FF FF 66 89 54 24 3C D9 6C 24 3C DD 45 08 F2 0F 10 45 08 8B 45 0C DB 7C 24 48 81 7D 0C 00 40 FF 40 73 6D DB 2D ?? ?? ?? ?? DB 6C 24 48 DC C9 D9 C9 D9 3C 24 0F B7 04 24 0D 00 0C 00 00 89 44 24 08 D9 6C 24 08 DB 5C 24 10 D9 2C 24 DD 05 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? 8B 7C 24 10 83 CF 01 89 7C 24 18 DB 44 24 18 DC CC D9 CC DE ED D9 CA D8 CB DE EC D8 CA DE EB DE C9 DE E9 DB 7C 24 48 E9 D6 01 00 00 8B C8 05 00 00 80 F3 C1 E9 14 81 E1 FF 07 00 00 F2 0F 11 44 24 10 89 44 24 14 B8 1F 85 EB 51 DD 44 24 10 DB 3C 24 DB 2C 24 8D B9 E4 FB FF FF F7 EF 8B F2 C1 FE 03 C1 FF 1F 2B F7 83 64 24 04 C0 C7 04 24 00 00 00 00 DB 2C 24 6B C6 E7 DC E9 D9 C9 DB 7C 24 20 8D 94 08 E4 FB FF FF 83 FA 11 7C 3A DD 04 F5 ?? ?? ?? ?? DD 04 F5 ?? ?? ?? ?? 46 D8 CA DB 6C 24 20 DE CA DE C1 DB 7C 24 10 DB 6C 24 10 83 64 24 14 C0 C7 44 24 10 00 00 00 00 DB 6C 24 10 DE E9 DB 7C 24 48 EB 0A DB 2D ?? ?? ?? ?? DB 7C 24 48 DD 04 F5 ?? ?? ?? ?? D9 C1 DD 04 F5 ?? ?? ?? ?? DC C9 DD 04 F5 ?? ?? ?? ?? DE CC DB 6C 24 20 DC CB D9 CA DE C3 DE C9 DE C2 D9 C9 DB 7C 24 10 DB 6C 24 10 DB 6C 24 48 DE C2 D9 C9 DB 7C 24 48 DB 6C 24 48 DE C1 DD 5C 24 30 F2 0F 10 44 24 30 F2 0F 11 44 24 40 8B 44 24 44 C1 E8 14 25 FF 07 00 00 F7 D8 05 33 04 00 00 89 44 24 2C 50 FF 74 24 48 FF 74 24 48 E8 AA FD FF FF 83 C4 0C 8B F8 83 CF 01 89 54 24 44 89 7C 24 40 FF 74 24 2C 52 57 E8 BF FD FF FF 83 C4 0C DB 6C 24 48 DB 6C 24 10 DB 6C 24 20 DD 04 F5 ?? ?? ?? ?? DD 04 F5 ?? ?? ?? ?? DD 04 F5 ?? ?? ?? ?? DD 04 F5 ?? ?? ?? ?? 89 44 24 40 89 54 24 44 DB 7C 24 30 DD 44 24 40 DE EE D9 CC DE C5 D9 C1 D9 CA D8 CB DB 2C 24 DC CB DD 04 F5 ?? ?? ?? ?? D8 CD DE C4 D9 CB DE C6 D9 C1 D8 CB DE C1 DE C5 D9 C3 D8 CA D9 C9 D8 CB DE C1 DE C4 D9 C9 DC CA DB 6C 24 30 D9 C0 D8 CB DE C4 D9 CB DE C4 DE CA DD 04 F5 ?? ?? ?? ?? DE C9 DE C1 DE C1 DB 2D ?? ?? ?? ?? DE C9 DB 7C 24 48 DB 6C 24 48 0F B7 44 24 3C 85 C0 DD 1B 74 04 D9 6C 24 3E C1 E7 1E F7 D7 81 E7 00 00 00 80 8B C7 83 C4 54 5B 5F 5E 8B E5 5D C3 33 C0 C7 03 FF FF FF FF C7 43 04 FF FF FF 7F 83 C4 54 5B 5F 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_33_4_0 {
	meta:
		name = "___common_pi04_reduction_LA"
		size = 784
		refs = "006c __d04PI 0095 __QP4 00a7 __dPI04 0144 __e04PI 017d _2il0floatpacket_12 02c1 __dPI02"
	strings:
		$1 = { 55 8B EC 83 E4 F0 56 57 53 83 EC 54 B8 00 00 F0 7F 8B 55 0C 8B 5D 10 2B D0 0F 8D D2 02 00 00 33 C0 66 89 44 24 44 D9 7C 24 46 0F B7 54 24 46 8B C2 25 00 0F 00 00 3D 00 03 00 00 74 15 81 E2 FF F0 FF FF 81 CA 00 03 FF FF 66 89 54 24 44 D9 6C 24 44 DD 45 08 F2 0F 10 45 08 8B 45 0C DB 7C 24 38 81 7D 0C 00 40 FF 40 73 76 DB 2D ?? ?? ?? ?? DB 6C 24 38 DC C9 D9 C9 D9 3C 24 0F B7 04 24 0D 00 0C 00 00 89 44 24 08 D9 6C 24 08 DB 5C 24 10 D9 2C 24 DD 05 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? DB 2D ?? ?? ?? ?? 8B 7C 24 10 47 83 E7 FE 89 7C 24 18 DB 44 24 18 DC CC D9 CC DE ED D9 CA D8 CB DE EC D8 CA DE EB D9 C9 DC 0D ?? ?? ?? ?? DE EA D9 C9 DB 7C 24 38 E9 D0 01 00 00 8B C8 05 00 00 80 F3 C1 E9 14 81 E1 FF 07 00 00 F2 0F 11 44 24 10 89 44 24 14 B8 1F 85 EB 51 DD 44 24 10 DB 3C 24 DB 2C 24 8D B9 E4 FB FF FF F7 EF 8B F2 C1 FE 03 C1 FF 1F 2B F7 83 64 24 04 C0 C7 04 24 00 00 00 00 DB 2C 24 6B C6 E7 DC E9 D9 C9 DB 7C 24 20 8D 94 08 E4 FB FF FF 83 FA 11 7C 3A DD 04 F5 ?? ?? ?? ?? DD 04 F5 ?? ?? ?? ?? 46 D8 CA DB 6C 24 20 DE CA DE C1 DB 7C 24 10 DB 6C 24 10 83 64 24 14 C0 C7 44 24 10 00 00 00 00 DB 6C 24 10 DE E9 DB 7C 24 38 EB 0A DB 2D ?? ?? ?? ?? DB 7C 24 38 DD 04 F5 ?? ?? ?? ?? D9 C1 D8 C9 D9 CA DC 0C F5 ?? ?? ?? ?? DD 04 F5 ?? ?? ?? ?? DB 6C 24 20 DC C9 D9 CC DE C1 D9 CB DE CA DE C1 DB 7C 24 10 DB 6C 24 10 DB 6C 24 38 DE C2 D9 C9 DB 7C 24 38 DB 6C 24 38 DE C1 DD 5C 24 30 8B 44 24 34 C1 E8 14 25 FF 07 00 00 F7 D8 05 33 04 00 00 89 44 24 2C 50 FF 74 24 38 FF 74 24 38 E8 BD FA FF FF 83 C4 0C 8B F8 83 C7 01 83 D2 00 83 E7 FE 89 54 24 34 89 7C 24 30 FF 74 24 2C 52 57 E8 CC FA FF FF 83 C4 0C DB 6C 24 38 DB 6C 24 10 DB 2C 24 DB 6C 24 20 DD 04 F5 ?? ?? ?? ?? 89 44 24 30 D9 C0 89 54 24 34 D8 CB D9 C9 D8 CA D9 CD DC 64 24 30 DE C4 DD 04 F5 ?? ?? ?? ?? DD 04 F5 ?? ?? ?? ?? DD 04 F5 ?? ?? ?? ?? D8 CC DE C3 D9 CA DE C5 D9 C3 D8 C9 DE C6 D9 CD DE C4 D9 C2 D8 C9 D9 CA DC CD D9 CA DE C5 D9 CC DE C3 D9 C1 D9 C9 DC CC D9 CA DC 0C F5 ?? ?? ?? ?? DD 04 F5 ?? ?? ?? ?? DC CA D9 CA DE C5 D9 CC DE C3 DE C9 DE C2 DE C1 DB 2D ?? ?? ?? ?? DC C9 D9 C9 DB 7C 24 38 DB 6C 24 38 D1 FF DE D9 DF E0 9E 7A 02 76 13 DB 2D ?? ?? ?? ?? 83 C7 FD DB 6C 24 38 DE E1 DB 7C 24 38 DB 6C 24 38 0F B7 44 24 44 85 C0 DD 1B 74 04 D9 6C 24 46 8B C7 83 C4 54 5B 5F 5E 8B E5 5D C3 33 C0 C7 03 FF FF FF FF C7 43 04 FF FF FF 7F 83 C4 54 5B 5F 5E 8B E5 5D C3 8D 9B 00 00 00 00 }
	condition:
		$1
}

rule file_34_1_0 {
	meta:
		name = "__EH_epilog3_align"
		size = 23
	strings:
		$1 = { 8B 4D F4 64 89 0D 00 00 00 00 59 5F 5F 5E 8B E5 5D 8B E3 5B 51 F2 C3 }
	condition:
		$1
}

rule file_34_2_0 {
	meta:
		name = "__EH_prolog3_GS_align"
		size = 110
		refs = "0041 ___security_cookie"
	strings:
		$1 = { 51 8B 4C 24 0C 89 5C 24 0C 8D 5C 24 0C 50 8D 44 24 08 F7 D9 23 C1 8D 60 F8 8B 43 F0 89 04 24 8B 43 F8 50 8B 43 F4 50 8B 43 FC 89 6C 24 10 8D 6C 24 10 C7 44 24 0C FF FF FF FF 23 CC 2B E0 56 57 A1 ?? ?? ?? ?? 33 C5 50 89 41 FC 8B 4D F0 89 5D F0 8B 43 04 89 45 04 FF 75 F4 64 A1 00 00 00 00 89 45 F4 8D 45 F4 64 A3 00 00 00 00 F2 C3 }
	condition:
		$1
}

rule file_34_3_0 {
	meta:
		name = "__EH_prolog3_align"
		size = 99
		refs = "003f ___security_cookie"
	strings:
		$1 = { 51 8B 4C 24 0C 89 5C 24 0C 8D 5C 24 0C 50 8D 44 24 08 F7 D9 23 C1 8D 60 F8 8B 43 F0 89 04 24 8B 43 F8 50 8B 43 FC 8B 4B F4 89 6C 24 0C 8D 6C 24 0C C7 44 24 08 FF FF FF FF 53 2B E0 56 57 A1 ?? ?? ?? ?? 33 C5 50 8B 43 04 89 45 04 FF 75 F4 64 A1 00 00 00 00 89 45 F4 8D 45 F4 64 A3 00 00 00 00 F2 C3 }
	condition:
		$1
}

rule file_34_4_0 {
	meta:
		name = "__EH_prolog3_catch_GS_align"
		size = 111
		refs = "0042 ___security_cookie"
	strings:
		$1 = { 51 8B 4C 24 0C 89 5C 24 0C 8D 5C 24 0C 50 8D 44 24 08 F7 D9 23 C1 8D 60 F8 8B 43 F0 89 04 24 8B 43 F8 50 8B 43 F4 50 8B 43 FC 89 6C 24 10 8D 6C 24 10 C7 44 24 0C FF FF FF FF 53 23 CC 2B E0 56 57 A1 ?? ?? ?? ?? 33 C5 50 89 41 FC 8B 4D F0 89 65 F0 8B 43 04 89 45 04 FF 75 F4 64 A1 00 00 00 00 89 45 F4 8D 45 F4 64 A3 00 00 00 00 F2 C3 }
	condition:
		$1
}

rule file_34_5_0 {
	meta:
		name = "__EH_prolog3_catch_align"
		size = 103
		refs = "0040 ___security_cookie"
	strings:
		$1 = { 51 8B 4C 24 0C 89 5C 24 0C 8D 5C 24 0C 50 8D 44 24 08 F7 D9 23 C1 8D 60 F8 8B 43 F0 89 04 24 8B 43 F8 50 8B 43 FC 8B 4B F4 89 6C 24 0C 8D 6C 24 0C C7 44 24 08 FF FF FF FF 51 53 2B E0 56 57 A1 ?? ?? ?? ?? 33 C5 50 89 65 F0 8B 43 04 89 45 04 FF 75 F4 64 A1 00 00 00 00 89 45 F4 8D 45 F4 64 A3 00 00 00 00 F2 C3 }
	condition:
		$1
}

rule file_35_0_0 {
	meta:
		name = "__SEH_prolog"
		size = 60
		refs = "0001 __except_handler3"
	strings:
		$1 = { 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 8B 44 24 10 89 6C 24 10 8D 6C 24 10 2B E0 53 56 57 8B 45 F8 89 65 E8 50 8B 45 FC C7 45 FC FF FF FF FF 89 45 F8 8D 45 F0 64 A3 00 00 00 00 F2 C3 }
	condition:
		$1
}

rule file_35_1_0 {
	meta:
		name = "__SEH_epilog"
		size = 18
	strings:
		$1 = { 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B C9 51 F2 C3 }
	condition:
		$1
}

rule file_39_0_0 {
	meta:
		name = "__vmlsAtan24Spec"
		size = 2800
		refs = "0073 INFP_1898_0_2 0086 INFN_1898_0_2 00da _2il0floatpacket_46 010e _2il0floatpacket_50 0116 _2il0floatpacket_54 0120 _2il0floatpacket_49 012a _2il0floatpacket_53 0134 _2il0floatpacket_48 013e _2il0floatpacket_52 0148 _2il0floatpacket_47 0159 _2il0floatpacket_51 016c m_or_p_1898_0_2 0173 pi_or_zero_1898_0_2 0632 _2il0floatpacket_39 063f _2il0floatpacket_38 065d _2il0floatpacket_41 066b _2il0floatpacket_40 0678 _2il0floatpacket_45 0685 _2il0floatpacket_44 06a7 NEGZERO_1898_0_2 06c0 _2il0floatpacket_43 06cd _2il0floatpacket_42"
	strings:
		$1 = { 55 8B EC 83 E4 F8 56 57 53 83 EC 1C 8B 45 0C 8B 55 08 8B 18 8B FB 8B 32 8B CE F3 0F 10 22 8B D3 81 E7 FF FF FF 7F 81 E1 00 00 00 80 81 E2 00 00 00 80 81 FF 00 00 80 7F F3 0F 10 18 0F 8F 43 01 00 00 8B FE 81 E7 FF FF FF 7F 81 FF 00 00 80 7F 0F 8F 2F 01 00 00 0F 57 C0 0F 2E E0 7A 06 0F 84 90 06 00 00 0F 2E D8 7A 06 0F 84 67 06 00 00 F3 0F 10 15 ?? ?? ?? ?? 0F 2E DA 7A 06 0F 84 0C 06 00 00 F3 0F 10 0D ?? ?? ?? ?? 0F 2E D9 7A 06 0F 84 B3 05 00 00 0F 2E E2 7A 06 0F 84 9B 05 00 00 0F 2E E1 7A 06 0F 84 83 05 00 00 81 E6 FF FF FF 7F 81 E3 FF FF FF 7F 89 34 24 81 C9 00 00 80 3F 89 5C 24 04 F3 0F 10 14 24 F3 0F 10 4C 24 04 89 4C 24 10 0F 2F D1 76 18 DD 05 ?? ?? ?? ?? F3 0F 5C C1 F3 0F 5E C2 F3 0F 11 04 24 D9 04 24 EB 0E F3 0F 5E D1 F3 0F 11 14 24 D9 EE D9 04 24 D9 44 24 10 D9 C1 D8 CA D9 C0 D8 C9 D9 E8 DD 05 ?? ?? ?? ?? D8 CA DD 05 ?? ?? ?? ?? D8 CB D9 C9 DC 05 ?? ?? ?? ?? D8 CB D9 C9 DC 05 ?? ?? ?? ?? D8 CB D9 C9 DC 05 ?? ?? ?? ?? D8 CB D9 C9 DC 05 ?? ?? ?? ?? D8 CB D9 C9 DC 05 ?? ?? ?? ?? DE CB C1 FA 1F D9 CA DE C1 D9 C9 DC 05 ?? ?? ?? ?? DE CA DE C1 DE CA D9 C9 DE C2 D9 C9 DC 0C D5 ?? ?? ?? ?? DC 04 D5 ?? ?? ?? ?? DE C9 D9 5C 24 08 F3 0F 10 64 24 08 EB 04 F3 0F 58 E3 8B 55 10 8B 4D 08 F3 0F 11 22 8B 58 04 8B FB 8B 71 04 8B D3 F3 0F 10 61 04 8B CE 81 E7 FF FF FF 7F 81 E1 00 00 00 80 81 E2 00 00 00 80 81 FF 00 00 80 7F F3 0F 10 58 04 0F 8F 45 01 00 00 8B FE 81 E7 FF FF FF 7F 81 FF 00 00 80 7F 0F 8F 31 01 00 00 0F 57 C0 0F 2E E0 7A 06 0F 84 3B 06 00 00 0F 2E D8 7A 06 0F 84 12 06 00 00 F3 0F 10 15 ?? ?? ?? ?? 0F 2E DA 7A 06 0F 84 B7 05 00 00 F3 0F 10 0D ?? ?? ?? ?? 0F 2E D9 7A 06 0F 84 5E 05 00 00 0F 2E E2 7A 06 0F 84 46 05 00 00 0F 2E E1 7A 06 0F 84 2E 05 00 00 81 E6 FF FF FF 7F 81 E3 FF FF FF 7F 89 74 24 14 81 C9 00 00 80 3F 89 5C 24 18 F3 0F 10 54 24 14 F3 0F 10 4C 24 18 89 4C 24 10 0F 2F D1 76 18 DD 05 ?? ?? ?? ?? F3 0F 5C C1 F3 0F 5E C2 F3 0F 11 04 24 D9 04 24 EB 0E F3 0F 5E D1 F3 0F 11 14 24 D9 EE D9 04 24 D9 44 24 10 D9 C1 D8 CA D9 C0 D8 C9 D9 E8 DD 05 ?? ?? ?? ?? D8 CA DD 05 ?? ?? ?? ?? D8 CB D9 C9 DC 05 ?? ?? ?? ?? D8 CB D9 C9 DC 05 ?? ?? ?? ?? D8 CB D9 C9 DC 05 ?? ?? ?? ?? D8 CB D9 C9 DC 05 ?? ?? ?? ?? D8 CB D9 C9 DC 05 ?? ?? ?? ?? DE CB C1 FA 1F D9 CA DE C1 D9 C9 DC 05 ?? ?? ?? ?? DE CA DE C1 DE CA D9 C9 DE C2 D9 C9 DC 0C D5 ?? ?? ?? ?? DC 04 D5 ?? ?? ?? ?? DE C9 D9 5C 24 08 F3 0F 10 64 24 08 EB 04 F3 0F 58 E3 8B 55 10 8B 4D 08 F3 0F 11 62 04 8B 58 08 8B FB 8B 71 08 8B D3 F3 0F 10 61 08 8B CE 81 E7 FF FF FF 7F 81 E1 00 00 00 80 81 E2 00 00 00 80 81 FF 00 00 80 7F F3 0F 10 58 08 0F 8F 45 01 00 00 8B FE 81 E7 FF FF FF 7F 81 FF 00 00 80 7F 0F 8F 31 01 00 00 0F 57 C0 0F 2E E0 7A 06 0F 84 E3 05 00 00 0F 2E D8 7A 06 0F 84 BA 05 00 00 F3 0F 10 15 ?? ?? ?? ?? 0F 2E DA 7A 06 0F 84 5F 05 00 00 F3 0F 10 0D ?? ?? ?? ?? 0F 2E D9 7A 06 0F 84 06 05 00 00 0F 2E E2 7A 06 0F 84 EE 04 00 00 0F 2E E1 7A 06 0F 84 D6 04 00 00 81 E6 FF FF FF 7F 81 E3 FF FF FF 7F 89 74 24 14 81 C9 00 00 80 3F 89 5C 24 18 F3 0F 10 54 24 14 F3 0F 10 4C 24 18 89 4C 24 10 0F 2F D1 76 18 DD 05 ?? ?? ?? ?? F3 0F 5C C1 F3 0F 5E C2 F3 0F 11 04 24 D9 04 24 EB 0E F3 0F 5E D1 F3 0F 11 14 24 D9 EE D9 04 24 D9 44 24 10 D9 C1 D8 CA D9 C0 D8 C9 D9 E8 DD 05 ?? ?? ?? ?? D8 CA DD 05 ?? ?? ?? ?? D8 CB D9 C9 DC 05 ?? ?? ?? ?? D8 CB D9 C9 DC 05 ?? ?? ?? ?? D8 CB D9 C9 DC 05 ?? ?? ?? ?? D8 CB D9 C9 DC 05 ?? ?? ?? ?? D8 CB D9 C9 DC 05 ?? ?? ?? ?? DE CB C1 FA 1F D9 CA DE C1 D9 C9 DC 05 ?? ?? ?? ?? DE CA DE C1 DE CA D9 C9 DE C2 D9 C9 DC 0C D5 ?? ?? ?? ?? DC 04 D5 ?? ?? ?? ?? DE C9 D9 5C 24 08 F3 0F 10 64 24 08 EB 04 F3 0F 58 E3 8B 55 10 8B 4D 08 F3 0F 11 62 08 F3 0F 10 61 0C 8B 51 0C 8B DA 8B 48 0C 8B F1 F3 0F 10 58 0C 8B C1 25 FF FF FF 7F 81 E3 00 00 00 80 81 E6 00 00 00 80 3D 00 00 80 7F 0F 8F 43 01 00 00 8B C2 25 FF FF FF 7F 3D 00 00 80 7F 0F 8F 31 01 00 00 0F 57 C0 0F 2E E0 7A 06 0F 84 8F 05 00 00 0F 2E D8 7A 06 0F 84 66 05 00 00 F3 0F 10 15 ?? ?? ?? ?? 0F 2E DA 7A 06 0F 84 0B 05 00 00 F3 0F 10 0D ?? ?? ?? ?? 0F 2E D9 7A 06 0F 84 B2 04 00 00 0F 2E E2 7A 06 0F 84 9A 04 00 00 0F 2E E1 7A 06 0F 84 82 04 00 00 81 E2 FF FF FF 7F 81 E1 FF FF FF 7F 89 54 24 14 81 CB 00 00 80 3F 89 4C 24 18 F3 0F 10 54 24 14 F3 0F 10 4C 24 18 89 5C 24 10 0F 2F D1 76 18 DD 05 ?? ?? ?? ?? F3 0F 5C C1 F3 0F 5E C2 F3 0F 11 04 24 D9 04 24 EB 0E F3 0F 5E D1 F3 0F 11 14 24 D9 EE D9 04 24 D9 44 24 10 D9 C1 D8 CA D9 C0 D8 C9 D9 E8 DD 05 ?? ?? ?? ?? D8 CA DD 05 ?? ?? ?? ?? D8 CB D9 C9 DC 05 ?? ?? ?? ?? D8 CB D9 C9 DC 05 ?? ?? ?? ?? D8 CB D9 C9 DC 05 ?? ?? ?? ?? D8 CB D9 C9 DC 05 ?? ?? ?? ?? D8 CB D9 C9 DC 05 ?? ?? ?? ?? DE CB C1 FE 1F D9 CA DE C1 D9 C9 DC 05 ?? ?? ?? ?? DE CA DE C1 DE CA D9 C9 DE C2 D9 C9 DC 0C F5 ?? ?? ?? ?? DC 04 F5 ?? ?? ?? ?? DE C9 D9 5C 24 08 F3 0F 10 64 24 08 EB 04 F3 0F 58 E3 8B 45 10 F3 0F 11 60 0C 83 C4 1C 5B 5F 5E 8B E5 5D C3 F3 0F 10 25 ?? ?? ?? ?? E9 4E FB FF FF F3 0F 10 25 ?? ?? ?? ?? E9 41 FB FF FF 0F 2E E2 7A 02 74 32 0F 2E E1 7A 02 74 1E 0F 2F E0 F3 0F 10 25 ?? ?? ?? ?? 0F 87 22 FB FF FF F3 0F 10 25 ?? ?? ?? ?? E9 15 FB FF FF F3 0F 10 25 ?? ?? ?? ?? E9 08 FB FF FF F3 0F 10 25 ?? ?? ?? ?? E9 FB FA FF FF 0F 2E E2 7A 02 74 34 0F 2E 25 ?? ?? ?? ?? 7A 02 74 1C 0F 2F C4 F3 0F 10 0D ?? ?? ?? ?? 0F 28 E0 0F 86 D5 FA FF FF 0F 28 E1 E9 CD FA FF FF F3 0F 10 25 ?? ?? ?? ?? E9 C0 FA FF FF F3 0F 10 25 ?? ?? ?? ?? E9 B3 FA FF FF 0F 2F E0 F3 0F 10 25 ?? ?? ?? ?? 0F 87 A2 FA FF FF F3 0F 10 25 ?? ?? ?? ?? E9 95 FA FF FF 85 C9 74 33 0F 2F D8 0F 87 88 FA FF FF 0F 2F C3 77 18 85 D2 F3 0F 10 05 ?? ?? ?? ?? 0F 84 73 FA FF FF 0F 28 E0 E9 6B FA FF FF F3 0F 10 25 ?? ?? ?? ?? E9 5E FA FF FF 0F 2F D8 0F 87 55 FA FF FF 0F 2F C3 77 18 85 D2 F3 0F 10 05 ?? ?? ?? ?? 0F 84 40 FA FF FF 0F 28 E0 E9 38 FA FF FF F3 0F 10 25 ?? ?? ?? ?? E9 2B FA FF FF F3 0F 10 25 ?? ?? ?? ?? E9 A5 FB FF FF F3 0F 10 25 ?? ?? ?? ?? E9 98 FB FF FF 0F 2E E2 7A 02 74 32 0F 2E E1 7A 02 74 1E 0F 2F E0 F3 0F 10 25 ?? ?? ?? ?? 0F 87 79 FB FF FF F3 0F 10 25 ?? ?? ?? ?? E9 6C FB FF FF F3 0F 10 25 ?? ?? ?? ?? E9 5F FB FF FF F3 0F 10 25 ?? ?? ?? ?? E9 52 FB FF FF 0F 2E E2 7A 02 74 34 0F 2E 25 ?? ?? ?? ?? 7A 02 74 1C 0F 2F C4 F3 0F 10 0D ?? ?? ?? ?? 0F 28 E0 0F 86 2C FB FF FF 0F 28 E1 E9 24 FB FF FF F3 0F 10 25 ?? ?? ?? ?? E9 17 FB FF FF F3 0F 10 25 ?? ?? ?? ?? E9 0A FB FF FF 0F 2F E0 F3 0F 10 25 ?? ?? ?? ?? 0F 87 F9 FA FF FF F3 0F 10 25 ?? ?? ?? ?? E9 EC FA FF FF 85 C9 74 33 0F 2F D8 0F 87 DF FA FF FF 0F 2F C3 77 18 85 D2 F3 0F 10 05 ?? ?? ?? ?? 0F 84 CA FA FF FF 0F 28 E0 E9 C2 FA FF FF F3 0F 10 25 ?? ?? ?? ?? E9 B5 FA FF FF 0F 2F D8 0F 87 AC FA FF FF 0F 2F C3 77 18 85 D2 F3 0F 10 05 ?? ?? ?? ?? 0F 84 97 FA FF FF 0F 28 E0 E9 8F FA FF FF F3 0F 10 25 ?? ?? ?? ?? E9 82 FA FF FF F3 0F 10 25 ?? ?? ?? ?? E9 FD FB FF FF F3 0F 10 25 ?? ?? ?? ?? E9 F0 FB FF FF 0F 2E E2 7A 02 74 32 0F 2E E1 7A 02 74 1E 0F 2F E0 F3 0F 10 25 ?? ?? ?? ?? 0F 87 D1 FB FF FF F3 0F 10 25 ?? ?? ?? ?? E9 C4 FB FF FF F3 0F 10 25 ?? ?? ?? ?? E9 B7 FB FF FF F3 0F 10 25 ?? ?? ?? ?? E9 AA FB FF FF 0F 2E E2 7A 02 74 34 0F 2E 25 ?? ?? ?? ?? 7A 02 74 1C 0F 2F C4 F3 0F 10 0D ?? ?? ?? ?? 0F 28 E0 0F 86 84 FB FF FF 0F 28 E1 E9 7C FB FF FF F3 0F 10 25 ?? ?? ?? ?? E9 6F FB FF FF F3 0F 10 25 ?? ?? ?? ?? E9 62 FB FF FF 0F 2F E0 F3 0F 10 25 ?? ?? ?? ?? 0F 87 51 FB FF FF F3 0F 10 25 ?? ?? ?? ?? E9 44 FB FF FF 85 C9 74 33 0F 2F D8 0F 87 37 FB FF FF 0F 2F C3 77 18 85 D2 F3 0F 10 05 ?? ?? ?? ?? 0F 84 22 FB FF FF 0F 28 E0 E9 1A FB FF FF F3 0F 10 25 ?? ?? ?? ?? E9 0D FB FF FF 0F 2F D8 0F 87 04 FB FF FF 0F 2F C3 77 18 85 D2 F3 0F 10 05 ?? ?? ?? ?? 0F 84 EF FA FF FF 0F 28 E0 E9 E7 FA FF FF F3 0F 10 25 ?? ?? ?? ?? E9 DA FA FF FF F3 0F 10 25 ?? ?? ?? ?? E9 51 FC FF FF F3 0F 10 25 ?? ?? ?? ?? E9 44 FC FF FF 0F 2E E2 7A 02 74 32 0F 2E E1 7A 02 74 1E 0F 2F E0 F3 0F 10 25 ?? ?? ?? ?? 0F 87 25 FC FF FF F3 0F 10 25 ?? ?? ?? ?? E9 18 FC FF FF F3 0F 10 25 ?? ?? ?? ?? E9 0B FC FF FF F3 0F 10 25 ?? ?? ?? ?? E9 FE FB FF FF 0F 2E E2 7A 02 74 34 0F 2E 25 ?? ?? ?? ?? 7A 02 74 1C 0F 2F C4 F3 0F 10 0D ?? ?? ?? ?? 0F 28 E0 0F 86 D8 FB FF FF 0F 28 E1 E9 D0 FB FF FF F3 0F 10 25 ?? ?? ?? ?? E9 C3 FB FF FF F3 0F 10 25 ?? ?? ?? ?? E9 B6 FB FF FF 0F 2F E0 F3 0F 10 25 ?? ?? ?? ?? 0F 87 A5 FB FF FF F3 0F 10 25 ?? ?? ?? ?? E9 98 FB FF FF 85 DB 74 33 0F 2F D8 0F 87 8B FB FF FF 0F 2F C3 77 18 85 F6 F3 0F 10 05 ?? ?? ?? ?? 0F 84 76 FB FF FF 0F 28 E0 E9 6E FB FF FF F3 0F 10 25 ?? ?? ?? ?? E9 61 FB FF FF 0F 2F D8 0F 87 58 FB FF FF 0F 2F C3 77 18 85 F6 F3 0F 10 05 ?? ?? ?? ?? 0F 84 43 FB FF FF 0F 28 E0 E9 3B FB FF FF F3 0F 10 25 ?? ?? ?? ?? E9 2E FB FF FF 8B FF }
	condition:
		$1
}

rule file_39_1_0 {
	meta:
		name = "___sse2_atan2f4"
		size = 368
		refs = "0012 _static_const_table"
	strings:
		$1 = { 8B C4 81 EC A0 00 00 00 83 E4 F0 89 44 24 64 0F 28 15 ?? ?? ?? ?? 0F 28 EA 0F 29 44 24 20 0F 54 E9 0F 54 D0 0F 28 35 ?? ?? ?? ?? 0F 29 4C 24 30 0F 54 C6 0F 28 FE 0F 56 05 ?? ?? ?? ?? 0F 28 DD 0F 54 F9 0F 29 44 24 10 0F 56 3D ?? ?? ?? ?? 0F C2 DA 01 0F 28 E3 0F 54 E5 0F 28 C3 0F 55 C2 0F 56 E0 0F 54 D3 0F 28 C3 0F 55 C5 0F 56 D0 0F 5E E2 D9 44 24 20 D8 4C 24 24 D8 4C 24 28 D8 4C 24 2C D9 44 24 30 D8 4C 24 34 D8 4C 24 38 D8 4C 24 3C DE C9 DD 1C 24 0F 54 F3 0F 57 ED 0F 54 1D ?? ?? ?? ?? 0F C2 CD 01 0F 56 E6 0F 54 0D ?? ?? ?? ?? 0F 28 C4 8B 44 24 04 0F 59 C4 0F 28 D0 0F 59 D0 0F 28 35 ?? ?? ?? ?? 25 00 00 F0 7F 0F 59 F2 0F 28 2D ?? ?? ?? ?? 0F 59 EA 0F 58 35 ?? ?? ?? ?? 0F 58 2D ?? ?? ?? ?? 0F 59 F2 0F 59 EA 0F 58 35 ?? ?? ?? ?? 0F 58 2D ?? ?? ?? ?? 0F 59 F2 0F 59 EA 0F 58 35 ?? ?? ?? ?? 0F 58 2D ?? ?? ?? ?? 0F 59 F2 0F 59 C5 0F 58 35 ?? ?? ?? ?? 0F 58 C6 0F 59 C4 0F 28 6C 24 10 0F 58 C3 0F 59 C7 0F 58 C1 0F 59 C5 74 09 3D 00 00 F0 7F 74 02 EB 27 83 EC 20 8D 44 24 40 89 04 24 8D 44 24 50 89 44 24 04 8D 44 24 60 89 44 24 08 E8 B2 F3 FF FF 83 C4 20 0F 28 44 24 40 8B 64 24 64 C3 EB 03 CC CC CC }
	condition:
		$1
}

rule file_40_0_0 {
	meta:
		name = "__except_handler4_noexcept"
		size = 71
		refs = "0015 __except_handler4 003c _terminate"
	strings:
		$1 = { 55 8B EC 51 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 89 45 FC 8B 4D 08 8B 51 04 83 E2 66 75 16 8B 45 08 81 38 63 73 6D E0 75 0B 83 7D FC 01 75 05 E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_44_0_4 {
	meta:
		name = "__except_handler3_noexcept"
		size = 71
		refs = "0015 __except_handler3 003c _terminate"
	strings:
		$1 = { 55 8B EC 51 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 89 45 FC 8B 4D 08 8B 51 04 83 E2 66 75 16 8B 45 08 81 38 63 73 6D E0 75 0B 83 7D FC 01 75 05 E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_43_1_0 {
	meta:
		name = "__ftol2_pentium4"
		size = 19
	strings:
		$1 = { 55 8B EC 83 EC 08 83 E4 F8 DD 1C 24 F2 0F 2C 04 24 C9 C3 }
	condition:
		$1
}

rule file_43_2_0 {
	meta:
		name = "__ftol2_sse_excpt"
		size = 36
		refs = "0002 ___isa_available"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 1B 83 EC 04 D9 3C 24 58 66 83 E0 7F 66 83 F8 7F 74 D3 8D A4 24 00 00 00 00 8D 49 00 }
	condition:
		$1
}

rule file_43_3_0 {
	meta:
		name = "__ftol2"
		size = 117
	strings:
		$1 = { 55 8B EC 83 EC 20 83 E4 F0 D9 C0 D9 54 24 18 DF 7C 24 10 DF 6C 24 10 8B 54 24 18 8B 44 24 10 85 C0 74 3C DE E9 85 D2 79 1E D9 1C 24 8B 0C 24 81 F1 00 00 00 80 81 C1 FF FF FF 7F 83 D0 00 8B 54 24 14 83 D2 00 EB 2C D9 1C 24 8B 0C 24 81 C1 FF FF FF 7F 83 D8 00 8B 54 24 14 83 DA 00 EB 14 8B 54 24 14 F7 C2 FF FF FF 7F 75 B8 D9 5C 24 18 D9 5C 24 18 C9 C3 }
	condition:
		$1
}

rule file_45_0_0 {
	meta:
		name = "___common_scosh_cout_rare"
		size = 1008
		refs = "0011 __vmldCoshHATab"
	strings:
		$1 = { 55 8B EC 83 E4 F8 56 83 EC 3C 8B 4D 08 F2 0F 10 0D ?? ?? ?? ?? 0F B7 05 ?? ?? ?? ?? 0F B7 51 02 81 E2 80 7F 00 00 81 FA 80 7F 00 00 0F 84 9A 03 00 00 F3 0F 5A 01 F2 0F 11 44 24 20 80 64 24 27 7F 0F B7 54 24 26 81 E2 F0 7F 00 00 81 FA 90 3C 00 00 0F 8E 51 03 00 00 F2 0F 10 74 24 20 F2 0F 10 05 ?? ?? ?? ?? 66 0F 2F C6 0F 86 15 03 00 00 F2 0F 11 4C 24 30 66 0F 2F 35 ?? ?? ?? ?? 0F 82 3B 01 00 00 F2 0F 10 05 ?? ?? ?? ?? F2 0F 59 C6 F2 0F 58 05 ?? ?? ?? ?? F2 0F 11 04 24 F2 0F 10 0C 24 8B 0C 24 8B D1 83 E2 3F F2 0F 5C 0D ?? ?? ?? ?? F2 0F 11 4C 24 08 F2 0F 10 54 24 08 F2 0F 59 15 ?? ?? ?? ?? F2 0F 10 5C 24 08 F2 0F 5C F2 F2 0F 59 1D ?? ?? ?? ?? F2 0F 10 0D ?? ?? ?? ?? F2 0F 5C F3 F2 0F 59 CE C1 E2 04 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CE F2 0F 10 A2 ?? ?? ?? ?? C1 E9 06 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CE 81 C1 FF 03 00 00 49 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CE 81 E1 FF 07 00 00 81 F9 FE 07 00 00 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CE F2 0F 59 CE F2 0F 58 CE F2 0F 59 CC F2 0F 58 8A ?? ?? ?? ?? F2 0F 58 CC 77 2E C1 E1 04 25 0F 80 FF FF 0B C1 66 89 44 24 36 F2 0F 10 44 24 30 F2 0F 59 C1 F2 0F 5A C0 8B 45 0C F3 0F 11 00 33 C0 83 C4 3C 5E 8B E5 5D C3 49 81 E1 FF 07 00 00 0F B7 44 24 36 C1 E1 04 25 0F 80 FF FF 0B C1 66 89 44 24 36 33 C0 F2 0F 59 4C 24 30 F2 0F 59 0D ?? ?? ?? ?? F2 0F 5A C9 8B 55 0C F3 0F 11 0A 83 C4 3C 5E 8B E5 5D C3 F2 0F 10 3D ?? ?? ?? ?? F2 0F 59 FE 0F B7 4C 24 36 81 E1 0F 80 FF FF F2 0F 58 3D ?? ?? ?? ?? F2 0F 11 3C 24 F2 0F 10 2C 24 8B 34 24 8B D6 C1 EA 06 83 E6 3F 81 C2 FF 03 00 00 F2 0F 5C 2D ?? ?? ?? ?? F2 0F 11 6C 24 08 81 E2 FF 07 00 00 F2 0F 10 5C 24 08 F2 0F 59 1D ?? ?? ?? ?? F2 0F 10 64 24 08 8D 42 FF F2 0F 59 25 ?? ?? ?? ?? F2 0F 5C F3 F2 0F 10 2D ?? ?? ?? ?? 25 FF 07 00 00 C1 E6 04 F7 DA C1 E0 04 83 C2 FC 0B C8 81 E2 FF 07 00 00 66 89 4C 24 36 81 E1 0F 80 FF FF F2 0F 10 44 24 30 F2 0F 5C F4 0F 28 D6 F2 0F 59 D6 F2 0F 59 EA F2 0F 10 8E ?? ?? ?? ?? F2 0F 59 C8 F2 0F 58 2D ?? ?? ?? ?? F2 0F 10 9E ?? ?? ?? ?? F7 DE C1 E2 04 0B CA 66 89 4C 24 36 F2 0F 10 25 ?? ?? ?? ?? F2 0F 11 4C 24 20 F2 0F 59 D8 F2 0F 59 E2 F2 0F 59 EA F2 0F 58 25 ?? ?? ?? ?? F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 E2 F2 0F 59 EA F2 0F 59 E6 F2 0F 10 7C 24 30 0F 28 C3 F2 0F 10 8E ?? ?? ?? ?? F2 0F 59 CF F2 0F 10 96 ?? ?? ?? ?? F2 0F 58 C1 F2 0F 59 D7 F2 0F 11 44 24 10 0F 28 C3 F2 0F 10 7C 24 10 F2 0F 5C D9 F2 0F 5C C7 F2 0F 59 E3 F2 0F 58 C1 F2 0F 10 4C 24 20 F2 0F 11 44 24 18 F2 0F 5C CA F2 0F 59 CE F2 0F 59 F3 F2 0F 58 CA F2 0F 10 7C 24 10 F2 0F 10 44 24 18 F2 0F 11 7C 24 28 F2 0F 10 54 24 28 F2 0F 59 EA F2 0F 58 4C 24 20 8B 45 0C F2 0F 58 C8 F2 0F 58 CC F2 0F 58 CD F2 0F 58 CE F2 0F 11 4C 24 10 F2 0F 10 74 24 10 F2 0F 58 D6 F2 0F 5A D2 F3 0F 11 10 33 C0 83 C4 3C 5E 8B E5 5D C3 F2 0F 10 05 ?? ?? ?? ?? F2 0F 59 C0 F2 0F 5A C0 8B 45 0C F3 0F 11 00 B8 03 00 00 00 83 C4 3C 5E 8B E5 5D C3 F2 0F 10 05 ?? ?? ?? ?? 8B 45 0C F2 0F 58 44 24 20 F2 0F 5A C0 F3 0F 11 00 33 C0 83 C4 3C 5E 8B E5 5D C3 F3 0F 10 01 F3 0F 59 C0 8B 45 0C F3 0F 11 00 33 C0 83 C4 3C 5E 8B E5 5D C3 8D A4 24 00 00 00 00 8D 64 24 00 }
	condition:
		$1
}

rule file_52_0_0 {
	meta:
		name = "___sse2_atan2"
		size = 416
		refs = "0010 _static_const_table"
	strings:
		$1 = { 8B C4 83 EC 70 83 E4 F0 89 44 24 34 66 0F 28 0D ?? ?? ?? ?? 66 0F 28 15 ?? ?? ?? ?? 66 0F 28 1D ?? ?? ?? ?? 66 0F 28 25 ?? ?? ?? ?? 66 0F 54 E0 66 0F 29 24 24 66 0F 57 C4 66 0F C2 C8 01 66 0F 54 D9 66 0F 29 5C 24 10 66 0F 28 E1 66 0F DF C8 66 0F DB D4 66 0F EB CA 66 0F DB C4 66 0F DF 25 ?? ?? ?? ?? 66 0F EB C4 66 0F 5E C8 66 0F 28 E1 66 0F 59 C9 66 0F 28 E9 66 0F 59 C9 66 0F 28 C1 66 0F 59 C9 66 0F 28 15 ?? ?? ?? ?? 66 0F 28 1D ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 28 3D ?? ?? ?? ?? 66 0F 59 D1 66 0F 59 D9 66 0F 59 F1 66 0F 59 F9 66 0F 58 15 ?? ?? ?? ?? 66 0F 58 1D ?? ?? ?? ?? 66 0F 58 35 ?? ?? ?? ?? 66 0F 58 3D ?? ?? ?? ?? 66 0F 59 D1 66 0F 59 D9 66 0F 59 F1 66 0F 59 F9 66 0F 58 15 ?? ?? ?? ?? 66 0F 58 1D ?? ?? ?? ?? 66 0F 58 35 ?? ?? ?? ?? 66 0F 58 3D ?? ?? ?? ?? 66 0F 59 D1 66 0F 59 D9 66 0F 59 F1 66 0F 59 F9 66 0F 58 15 ?? ?? ?? ?? 66 0F 58 1D ?? ?? ?? ?? 66 0F 58 35 ?? ?? ?? ?? 66 0F 58 3D ?? ?? ?? ?? 66 0F 59 D1 66 0F 59 D9 66 0F 59 F1 66 0F 59 F9 66 0F 58 15 ?? ?? ?? ?? 66 0F 58 1D ?? ?? ?? ?? 66 0F 58 35 ?? ?? ?? ?? 66 0F 58 3D ?? ?? ?? ?? 66 0F 59 D0 66 0F 59 D5 66 0F 59 D8 66 0F 59 F5 66 0F 58 D3 66 0F 58 F7 66 0F 58 F2 66 0F 59 F4 66 0F 58 74 24 10 66 0F 56 34 24 66 0F 28 C6 8B 64 24 34 C3 8D A4 24 00 00 00 00 90 }
	condition:
		$1
}

rule file_54_0_0 {
	meta:
		name = "??3@YAXPAXI@Z"
		size = 17
		refs = "0008 ??3@YAXPAX@Z"
		altNames = "??3@YAXPAXABUnothrow_t@std@@@Z ??_V@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_1_187_2 {
	meta:
		name = "??3_Crt_new_delete@std@@SAXPAX@Z"
		size = 17
		refs = "0008 _free"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_510_0_7 {
	meta:
		name = "??_U@YAPAXI@Z"
		size = 17
		refs = "0008 ??2@YAPAXI@Z"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_309_0_7 {
	meta:
		name = "??_V@YAXPAXABUnothrow_t@std@@@Z"
		size = 17
		refs = "0008 ??_V@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_170_0_0 {
	meta:
		name = "??_V@YAXPAXI@Z"
		size = 17
		refs = "0008 ??_V@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_47_442_3 {
	meta:
		name = "?pointer_to@?$pointer_traits@PAD@std@@SAPADAAD@Z"
		size = 17
		refs = "0008 ??$addressof@D@std@@YAPADAAD@Z"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_29_1407_1 {
	meta:
		name = "?pointer_to@?$pointer_traits@PAG@std@@SAPAGAAG@Z"
		size = 17
		refs = "0008 ??$addressof@G@std@@YAPAGAAG@Z"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_53_446_3 {
	meta:
		name = "?pointer_to@?$pointer_traits@PAU_Container_proxy@std@@@std@@SAPAU_Container_proxy@2@AAU32@@Z"
		size = 17
		refs = "0008 ??$addressof@U_Container_proxy@std@@@std@@YAPAU_Container_proxy@0@AAU10@@Z"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_69_101_1 {
	meta:
		name = "?pointer_to@?$pointer_traits@PA_W@std@@SAPA_WAA_W@Z"
		size = 17
		refs = "0008 ??$addressof@_W@std@@YAPA_WAA_W@Z"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_2_0_3 {
	meta:
		name = "__LDtest"
		size = 17
		refs = "0008 __Dtest"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_40_5_2 {
	meta:
		name = "__Thrd_exit"
		size = 17
		refs = "0008 __endthreadex"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_60_0_0 {
	meta:
		name = "___sse2_log10f4"
		size = 320
		refs = "0010 _static_const_table"
	strings:
		$1 = { 8B C4 83 EC 60 83 E4 F0 89 44 24 24 66 0F 6F 15 ?? ?? ?? ?? 66 0F 6F 1D ?? ?? ?? ?? 66 0F DB D0 66 0F 6F 0D ?? ?? ?? ?? 0F 11 04 24 66 0F FE DA 66 0F 6F 25 ?? ?? ?? ?? 66 0F DB 1D ?? ?? ?? ?? 66 0F 66 E0 66 0F EF CB 66 0F 72 E3 17 66 0F EB D1 66 0F 6F C8 66 0F 72 E0 17 66 0F 66 0D ?? ?? ?? ?? 66 0F FA 05 ?? ?? ?? ?? 66 0F 6F FA 66 0F 6F D0 66 0F FE D3 66 0F DB E1 66 0F D7 C4 0F 28 DF 0F 28 0D ?? ?? ?? ?? 0F 5C 1D ?? ?? ?? ?? 0F 28 05 ?? ?? ?? ?? 0F 58 CB 0F 28 25 ?? ?? ?? ?? 0F 28 EB 0F 5E D9 0F 5B D2 0F 28 CB 0F 59 DB 0F 28 35 ?? ?? ?? ?? 0F 28 FB 0F 59 DB 0F 59 F2 0F 59 C3 3D FF FF 00 00 0F 59 E3 0F 58 05 ?? ?? ?? ?? 0F 59 C7 0F 58 C4 0F 59 15 ?? ?? ?? ?? 0F 28 DD 0F 5C E8 0F 59 E9 0F 58 F3 0F 5C EE 0F 5C D5 0F 59 15 ?? ?? ?? ?? 75 07 0F 28 C2 EB 34 8B FF D9 EC D9 04 24 D9 F1 D9 1C 24 D9 EC D9 44 24 04 D9 F1 D9 5C 24 04 D9 EC D9 44 24 08 D9 F1 D9 5C 24 08 D9 EC D9 44 24 0C D9 F1 D9 5C 24 0C 0F 10 04 24 8B 64 24 24 C3 8D A4 24 00 00 00 00 8B FF }
	condition:
		$1
}

rule file_64_0_0 {
	meta:
		name = "___scrt_is_ucrt_dll_in_use"
		size = 36
		refs = "0006 ___scrt_ucrt_dll_is_in_use"
	strings:
		$1 = { 55 8B EC 51 83 3D ?? ?? ?? ?? 00 74 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_67_2_0 {
	meta:
		name = "__RTC_InitBase"
		size = 41
		refs = "0002 ?init@?1??_RTC_InitBase@@9@4_NA 001b __CRT_RTC_INITW 0021 __RTC_SetErrorFuncW"
	strings:
		$1 = { 80 3D ?? ?? ?? ?? 00 75 1F 6A 00 6A 01 6A 00 6A 00 6A 00 C6 05 ?? ?? ?? ?? 01 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 18 C3 }
	condition:
		$1
}

rule file_67_3_0 {
	meta:
		name = "__RTC_Shutdown"
		size = 19
		refs = "000b __CRT_RTC_INITW"
	strings:
		$1 = { 6A 01 6A 01 6A 00 6A 00 6A 00 E8 ?? ?? ?? ?? 83 C4 14 C3 }
	condition:
		$1
}

rule file_69_0_0 {
	meta:
		name = "___avx_atan24"
		size = 624
		refs = "0010 ___common_datan2_data 025b ___common_datan2_cout_rare"
	strings:
		$1 = { 55 8B EC 83 E4 C0 81 EC 00 01 00 00 C5 FD 10 35 ?? ?? ?? ?? C5 FD 10 3D ?? ?? ?? ?? C5 FD 11 04 24 C5 FD 11 4C 24 20 C5 F5 54 DE C5 FD 54 EE C5 FD 54 E7 C5 FD 11 64 24 60 C5 D5 C2 E3 15 C5 F5 54 F7 C5 FD 11 74 24 40 C5 F5 C2 0D ?? ?? ?? ?? 12 C5 E5 56 F7 C5 DD 54 15 ?? ?? ?? ?? C5 FD 11 94 24 80 00 00 00 C4 E3 55 4B FE 40 C4 E3 65 4B D5 40 C5 C5 5E F2 C5 F8 10 3D ?? ?? ?? ?? C4 E3 7D 19 D8 01 C4 E3 7D 19 EC 01 C5 E0 C6 D8 DD C5 D0 C6 EC DD C5 E1 FA D7 C5 F8 10 25 ?? ?? ?? ?? C5 D1 FA EF C5 E9 66 C4 C5 E9 76 DC C5 D1 66 FC C5 D1 76 EC C5 F9 EB D3 C5 C1 EB E5 C5 E9 EB C4 C5 CD 59 E6 C5 F8 50 D0 C5 F5 54 2D ?? ?? ?? ?? C5 FD 11 AC 24 A0 00 00 00 C5 DD 59 EC C5 D5 59 DD C5 E5 59 3D ?? ?? ?? ?? C5 E5 59 0D ?? ?? ?? ?? C5 E5 59 15 ?? ?? ?? ?? C5 C5 58 05 ?? ?? ?? ?? C5 F5 58 3D ?? ?? ?? ?? C5 ED 58 15 ?? ?? ?? ?? C5 FD 59 C3 C5 E5 59 0D ?? ?? ?? ?? C5 ED 59 D3 C5 C5 59 FB C5 FD 58 05 ?? ?? ?? ?? C5 F5 58 0D ?? ?? ?? ?? C5 ED 58 15 ?? ?? ?? ?? C5 C5 58 3D ?? ?? ?? ?? C5 FD 59 C3 C5 F5 59 CB C5 ED 59 D3 C5 C5 59 FB C5 FD 58 05 ?? ?? ?? ?? C5 F5 58 0D ?? ?? ?? ?? C5 ED 58 15 ?? ?? ?? ?? C5 C5 58 3D ?? ?? ?? ?? C5 FD 59 C3 C5 F5 59 CB C5 ED 59 D3 C5 C5 59 FB C5 FD 58 05 ?? ?? ?? ?? C5 F5 58 0D ?? ?? ?? ?? C5 ED 58 15 ?? ?? ?? ?? C5 C5 58 3D ?? ?? ?? ?? C5 FD 59 C4 C5 F5 59 DB C5 C5 59 E4 C5 FD 58 CA C5 E5 58 1D ?? ?? ?? ?? C5 F5 59 ED C5 DD 58 C3 C5 D5 58 D0 C5 ED 59 F6 C5 CD 58 84 24 80 00 00 00 C5 FD 56 4C 24 40 C5 F5 58 94 24 A0 00 00 00 C5 ED 56 44 24 60 C5 FD 10 54 24 20 85 D2 75 04 8B E5 5D C3 C5 FD 10 0C 24 C5 FD 11 94 24 80 00 00 00 C5 FD 11 84 24 C0 00 00 00 C5 FD 11 4C 24 40 74 DD 33 C0 89 74 24 04 8B F0 89 3C 24 8B FA 0F A3 F7 72 18 46 83 FE 20 7C F5 8B 74 24 04 8B 3C 24 C5 FD 10 84 24 C0 00 00 00 EB B3 C5 F8 77 8D 8C F4 C0 00 00 00 8D 54 F4 40 8D 84 F4 80 00 00 00 51 50 52 E8 ?? ?? ?? ?? 83 C4 0C EB C6 8D A4 24 00 00 00 00 EB 03 CC CC CC }
	condition:
		$1
}

rule file_70_0_0 {
	meta:
		name = "___raise_securityfailure"
		size = 41
		refs = "0007 __imp__SetUnhandledExceptionFilter@4 0011 __imp__UnhandledExceptionFilter@4 001c __imp__GetCurrentProcess@0 0023 __imp__TerminateProcess@8"
	strings:
		$1 = { 55 8B EC 6A 00 FF 15 ?? ?? ?? ?? 8B 45 08 50 FF 15 ?? ?? ?? ?? 68 09 04 00 C0 FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_70_1_0 {
	meta:
		name = "___report_gsfailure"
		size = 259
		refs = "000c _IsProcessorFeaturePresent@4 001c _GS_ContextRecord 009d _GS_ExceptionRecord 00db ___security_cookie 00ed ___security_cookie_complement 00f6 _GS_ExceptionPointers 00fb ___raise_securityfailure"
	strings:
		$1 = { 55 8B EC 81 EC 24 03 00 00 6A 17 E8 ?? ?? ?? ?? 85 C0 74 07 B9 02 00 00 00 CD 29 A3 ?? ?? ?? ?? 89 0D ?? ?? ?? ?? 89 15 ?? ?? ?? ?? 89 1D ?? ?? ?? ?? 89 35 ?? ?? ?? ?? 89 3D ?? ?? ?? ?? 66 8C 15 ?? ?? ?? ?? 66 8C 0D ?? ?? ?? ?? 66 8C 1D ?? ?? ?? ?? 66 8C 05 ?? ?? ?? ?? 66 8C 25 ?? ?? ?? ?? 66 8C 2D ?? ?? ?? ?? 9C 8F 05 ?? ?? ?? ?? 8B 45 00 A3 ?? ?? ?? ?? 8B 45 04 A3 ?? ?? ?? ?? 8D 45 08 A3 ?? ?? ?? ?? 8B 85 DC FC FF FF C7 05 ?? ?? ?? ?? 01 00 01 00 A1 ?? ?? ?? ?? A3 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 09 04 00 C0 C7 05 ?? ?? ?? ?? 01 00 00 00 C7 05 ?? ?? ?? ?? 01 00 00 00 B9 04 00 00 00 6B D1 00 C7 82 ?? ?? ?? ?? 02 00 00 00 B8 04 00 00 00 6B C8 00 8B 15 ?? ?? ?? ?? 89 54 0D F8 B8 04 00 00 00 C1 E0 00 8B 0D ?? ?? ?? ?? 89 4C 05 F8 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_70_3_0 {
	meta:
		name = "___report_securityfailure"
		size = 210
		refs = "000c _IsProcessorFeaturePresent@4 001a _GS_ContextRecord 0091 _GS_ExceptionRecord 00c5 _GS_ExceptionPointers 00ca ___raise_securityfailure"
	strings:
		$1 = { 55 8B EC 81 EC 1C 03 00 00 6A 17 E8 ?? ?? ?? ?? 85 C0 74 05 8B 4D 08 CD 29 A3 ?? ?? ?? ?? 89 0D ?? ?? ?? ?? 89 15 ?? ?? ?? ?? 89 1D ?? ?? ?? ?? 89 35 ?? ?? ?? ?? 89 3D ?? ?? ?? ?? 66 8C 15 ?? ?? ?? ?? 66 8C 0D ?? ?? ?? ?? 66 8C 1D ?? ?? ?? ?? 66 8C 05 ?? ?? ?? ?? 66 8C 25 ?? ?? ?? ?? 66 8C 2D ?? ?? ?? ?? 9C 8F 05 ?? ?? ?? ?? 8B 45 00 A3 ?? ?? ?? ?? 8B 45 04 A3 ?? ?? ?? ?? 8D 45 08 A3 ?? ?? ?? ?? 8B 85 E4 FC FF FF A1 ?? ?? ?? ?? A3 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 09 04 00 C0 C7 05 ?? ?? ?? ?? 01 00 00 00 C7 05 ?? ?? ?? ?? 01 00 00 00 B9 04 00 00 00 6B D1 00 8B 45 08 89 82 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_70_4_0 {
	meta:
		name = "___report_securityfailureEx"
		size = 293
		refs = "000c _IsProcessorFeaturePresent@4 001a _GS_ContextRecord 0091 _GS_ExceptionRecord 0118 _GS_ExceptionPointers 011d ___raise_securityfailure"
	strings:
		$1 = { 55 8B EC 81 EC 20 03 00 00 6A 17 E8 ?? ?? ?? ?? 85 C0 74 05 8B 4D 08 CD 29 A3 ?? ?? ?? ?? 89 0D ?? ?? ?? ?? 89 15 ?? ?? ?? ?? 89 1D ?? ?? ?? ?? 89 35 ?? ?? ?? ?? 89 3D ?? ?? ?? ?? 66 8C 15 ?? ?? ?? ?? 66 8C 0D ?? ?? ?? ?? 66 8C 1D ?? ?? ?? ?? 66 8C 05 ?? ?? ?? ?? 66 8C 25 ?? ?? ?? ?? 66 8C 2D ?? ?? ?? ?? 9C 8F 05 ?? ?? ?? ?? 8B 45 00 A3 ?? ?? ?? ?? 8B 45 04 A3 ?? ?? ?? ?? 8D 45 08 A3 ?? ?? ?? ?? 8B 85 E0 FC FF FF A1 ?? ?? ?? ?? A3 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 09 04 00 C0 C7 05 ?? ?? ?? ?? 01 00 00 00 83 7D 0C 00 76 0D 83 7D 10 00 75 07 C7 45 0C 00 00 00 00 83 7D 0C 0E 76 09 8B 4D 0C 83 E9 01 89 4D 0C 8B 55 0C 83 C2 01 89 15 ?? ?? ?? ?? B8 04 00 00 00 6B C8 00 8B 55 08 89 91 ?? ?? ?? ?? C7 45 FC 00 00 00 00 EB 09 8B 45 FC 83 C0 01 89 45 FC 8B 4D FC 3B 4D 0C 73 15 8B 55 FC 8B 45 FC 8B 4D 10 8B 04 81 89 04 95 ?? ?? ?? ?? EB DA 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_71_0_0 {
	meta:
		name = "___libm_sse2_cosf"
		size = 320
		refs = "0004 _static_const_table"
	strings:
		$1 = { F2 0F 10 15 ?? ?? ?? ?? 81 E6 FF FF FF 7F 25 00 00 80 7F 3D 00 00 80 7F 0F 84 0E 01 00 00 C1 EE 17 81 EE 8E 00 00 00 81 E6 F8 FF 00 00 F2 0F 10 1C 75 ?? ?? ?? ?? F2 0F 10 2C 75 ?? ?? ?? ?? F2 0F 10 15 ?? ?? ?? ?? 66 0F 57 E4 B8 38 43 00 00 66 0F C4 E0 03 66 0F 54 D3 66 0F 73 F3 28 F2 0F 59 D1 F2 0F 59 D9 F2 0F 59 CD F2 0F 10 C2 F2 0F 58 D3 F2 0F 10 EA F2 0F 5C C2 F2 0F 58 D4 F2 0F 58 D8 66 0F 7E D6 F2 0F 5C D4 F2 0F 58 CB B8 80 01 00 00 F2 0F 10 25 ?? ?? ?? ?? F2 0F 5C EA 03 F6 8B D6 C1 E6 18 C1 FE 1F 23 C2 03 D6 33 D6 F2 0F 58 CD 81 E2 FE 00 00 00 F2 0F 10 1C D5 ?? ?? ?? ?? F2 0F 10 05 ?? ?? ?? ?? 66 0F 70 D1 44 F2 0F 59 C9 F2 0F 10 2C D5 ?? ?? ?? ?? 8B F0 81 E6 00 01 00 00 C1 E6 17 F2 0F 59 DA 66 0F 6E D6 F2 0F 5C C1 05 80 00 00 00 25 00 01 00 00 C1 E0 17 F2 0F 5C E1 66 0F 73 F2 20 66 0F 6E C8 66 0F 57 E2 F2 0F 59 C5 F2 0F 59 DC 66 0F 73 F1 20 66 0F 57 C1 F2 0F 58 C3 66 0F 5A C0 EB 04 F3 0F 5C C0 C3 8D A4 24 00 00 00 00 8D A4 24 00 00 00 00 90 }
	condition:
		$1
}

rule file_71_1_0 {
	meta:
		name = "___sse2_cosf4"
		size = 1328
		refs = "0015 _static_const_table"
	strings:
		$1 = { 8B C4 81 EC 20 01 00 00 83 E4 F0 89 84 24 E4 00 00 00 0F 28 3D ?? ?? ?? ?? 0F 54 F8 0F 28 05 ?? ?? ?? ?? 0F 28 25 ?? ?? ?? ?? 0F 28 F7 0F 28 D7 0F 28 2D ?? ?? ?? ?? 0F 58 C7 0F 59 C4 66 0F 5B C0 0F 28 25 ?? ?? ?? ?? 0F C2 FD 06 0F 28 2D ?? ?? ?? ?? 0F 50 C7 23 C0 75 5B 0F 28 D8 0F 28 3D ?? ?? ?? ?? 0F 5B C0 0F 28 0D ?? ?? ?? ?? 0F 28 35 ?? ?? ?? ?? 0F 5C C1 66 0F 72 F3 1F 0F 59 E0 0F 59 E8 0F 59 F0 0F 59 F8 0F 28 05 ?? ?? ?? ?? 0F 5C D4 0F 5C D5 0F 5C D6 0F 28 2D ?? ?? ?? ?? 0F 28 35 ?? ?? ?? ?? 0F 28 CA 0F 5C CF 0F 59 D2 E9 4A 04 00 00 0F 28 CE 0F 29 74 24 50 66 0F 66 35 ?? ?? ?? ?? 0F 29 BC 24 90 00 00 00 0F 57 3D ?? ?? ?? ?? 0F 50 D6 89 04 24 85 D2 0F 85 A7 02 00 00 0F 28 F2 0F 28 DD 0F 28 2D ?? ?? ?? ?? 0F 29 BC 24 80 00 00 00 0F 28 F8 0F 5B C0 0F 28 0D ?? ?? ?? ?? 0F 28 D4 0F 28 25 ?? ?? ?? ?? 0F 5C C1 66 0F 72 F7 1F 0F 59 D0 0F 59 D8 0F 59 E0 0F 59 E8 66 0F 70 44 24 50 EE 0F 5A 4C 24 50 0F 5A C0 0F 5C F2 0F 5C F3 66 0F 28 1D ?? ?? ?? ?? 66 0F 59 D9 0F 5C F4 66 0F E6 DB 66 0F 70 DB DC 0F 5C F5 66 0F EB 1D ?? ?? ?? ?? 66 0F 28 15 ?? ?? ?? ?? 66 0F 56 D3 66 0F 5C 15 ?? ?? ?? ?? 66 0F 29 44 24 20 66 0F 28 05 ?? ?? ?? ?? 66 0F 59 C2 66 0F 28 25 ?? ?? ?? ?? 66 0F 59 E2 66 0F 5C C8 66 0F 28 2D ?? ?? ?? ?? 66 0F 59 EA 66 0F 28 C1 66 0F 5C CC 66 0F 5C C1 0F 54 B4 24 80 00 00 00 0F 29 B4 24 A0 00 00 00 66 0F 28 F1 66 0F 5C C4 66 0F 5C CD 66 0F 73 F3 3E 66 0F 5C F1 0F 54 BC 24 80 00 00 00 0F 29 BC 24 B0 00 00 00 66 0F 28 F9 66 0F 28 25 ?? ?? ?? ?? 66 0F 5C F5 66 0F 58 C6 66 0F 28 74 24 20 66 0F 59 35 ?? ?? ?? ?? 66 0F 58 C8 66 0F 59 E2 66 0F 5C F9 66 0F 28 E9 66 0F 5C CC 66 0F 58 C7 66 0F 5C E9 66 0F 59 15 ?? ?? ?? ?? 66 0F 5C EC 66 0F 58 C5 66 0F E6 F6 66 0F 28 2D ?? ?? ?? ?? 66 0F 5C C2 66 0F DB EB 66 0F 58 C1 66 0F 28 4C 24 20 66 0F EF 2D ?? ?? ?? ?? 66 0F 70 ED DD 66 0F 70 F6 DC 66 0F EB 35 ?? ?? ?? ?? 66 0F 28 15 ?? ?? ?? ?? 66 0F 56 D6 66 0F 29 44 24 30 66 0F 5C 15 ?? ?? ?? ?? 66 0F 28 05 ?? ?? ?? ?? 66 0F 59 C2 66 0F 28 25 ?? ?? ?? ?? 66 0F 59 E2 66 0F D6 6C 24 10 66 0F 5C C8 66 0F 28 2D ?? ?? ?? ?? 66 0F 59 EA 66 0F 28 C1 66 0F 5C CC 66 0F 5C C1 66 0F 28 D9 66 0F 5C C4 66 0F 5C CD 66 0F 73 F6 3E 66 0F 5C D9 66 0F 28 F9 66 0F 28 25 ?? ?? ?? ?? 66 0F 5C DD 66 0F 58 C3 66 0F 58 C8 66 0F 59 E2 66 0F 5C F9 66 0F 28 E9 66 0F 5C CC 66 0F 58 C7 66 0F 5C E9 66 0F 59 15 ?? ?? ?? ?? 66 0F 5C EC 0F 28 A4 24 90 00 00 00 66 0F 58 C5 66 0F 28 2D ?? ?? ?? ?? 66 0F 5C C2 66 0F 5A 54 24 30 66 0F DB EE 0F 28 B4 24 A0 00 00 00 66 0F 28 5C 24 10 66 0F 58 C8 66 0F EF 2D ?? ?? ?? ?? 66 0F 5A C9 66 0F 70 ED DD 66 0F 14 D1 0F 28 8C 24 B0 00 00 00 66 0F 14 DD 0F 54 D4 0F 54 DC 0F 56 D6 0F 28 05 ?? ?? ?? ?? 0F 28 2D ?? ?? ?? ?? 0F 28 35 ?? ?? ?? ?? 0F 56 D9 0F 28 CA 0F 59 D2 E9 76 01 00 00 0F 5A C9 66 0F 29 8C 24 C0 00 00 00 83 F8 0F 0F 84 98 00 00 00 0F 28 D8 0F 28 3D ?? ?? ?? ?? 0F 5B C0 0F 28 0D ?? ?? ?? ?? 0F 28 35 ?? ?? ?? ?? 0F 5C C1 66 0F 72 F3 1F 0F 59 E0 0F 59 E8 0F 59 F0 0F 59 F8 0F 5C D4 0F 5C D5 0F 5C D6 0F 5C D7 0F 28 CA 0F 59 D2 0F 28 05 ?? ?? ?? ?? 0F 28 2D ?? ?? ?? ?? 0F 28 35 ?? ?? ?? ?? 0F 28 E2 0F 59 D2 0F 57 CB 0F 28 05 ?? ?? ?? ?? 0F 28 2D ?? ?? ?? ?? 0F 59 C2 0F 59 EA 0F 59 D1 0F 59 E1 0F 58 05 ?? ?? ?? ?? 0F 58 2D ?? ?? ?? ?? 0F 59 C2 0F 59 EC 0F 58 C5 0F 58 C1 0F 29 44 24 70 89 74 24 04 0F 5A 74 24 58 66 0F 29 74 24 20 89 04 24 A9 01 00 00 00 74 22 F3 0F 10 44 24 50 8B 74 24 50 8B 44 24 50 F2 0F 10 8C 24 C0 00 00 00 E8 55 FA FF FF F3 0F 11 44 24 70 8B 04 24 A9 02 00 00 00 74 22 F3 0F 10 44 24 54 8B 74 24 54 8B 44 24 54 F2 0F 10 8C 24 C8 00 00 00 E8 29 FA FF FF F3 0F 11 44 24 74 8B 04 24 A9 04 00 00 00 74 1F F3 0F 10 44 24 58 8B 74 24 58 8B 44 24 58 F2 0F 10 4C 24 20 E8 00 FA FF FF F3 0F 11 44 24 78 8B 04 24 0F 28 44 24 70 A9 08 00 00 00 74 1F F3 0F 10 44 24 5C 8B 74 24 5C 8B 44 24 5C F2 0F 10 4C 24 28 E8 D2 F9 FF FF F3 0F 11 44 24 7C 8B 74 24 04 0F 28 44 24 70 EB 23 0F 59 C2 0F 58 05 ?? ?? ?? ?? 0F 59 C2 0F 58 C5 0F 59 C2 0F 58 C6 0F 59 C2 0F 59 C1 0F 58 C1 66 0F EF C3 8B A4 24 E4 00 00 00 C3 8D 9B 00 00 00 00 }
	condition:
		$1
}

rule file_72_0_0 {
	meta:
		name = "___sse2_powf4"
		size = 960
		refs = "0032 ___common_spow_data 009f _2il0floatpacket_128 03a8 ___common_spow_cout_rare"
	strings:
		$1 = { 55 8B EC 83 E4 C0 81 EC 00 01 00 00 0F 28 F1 0F 12 F1 0F 28 D0 0F 5A D9 0F 5A EE 0F 5A F8 0F 12 D0 0F 5A E2 0F 29 5C 24 20 0F 29 6C 24 30 66 0F 6F 1D ?? ?? ?? ?? 0F 28 2D ?? ?? ?? ?? 66 0F DB D9 0F 29 4C 24 10 0F 28 CD 0F 28 15 ?? ?? ?? ?? 0F 54 CF 0F 54 EC 0F 56 CA 0F 29 04 24 0F 56 EA 66 0F FA 05 ?? ?? ?? ?? 66 0F 73 D7 14 66 0F 7F 44 24 40 66 0F 73 D4 14 66 0F 7F 5C 24 50 66 0F 5A D9 66 0F 5A C5 0F 16 DB 0F 16 C0 0F 53 F3 0F 53 D0 0F 5A DE 0F 5A D2 0F C6 FC DD 0F 28 25 ?? ?? ?? ?? 66 0F 58 DC 66 0F 58 D4 F3 0F E6 F7 66 0F 5C DC 66 0F 5C D4 66 0F 59 CB 66 0F 59 EA 66 0F 70 E7 EE 0F 28 C2 0F 28 3D ?? ?? ?? ?? 66 0F 73 D0 28 66 0F 5C CF 66 0F 5C EF F3 0F E6 E4 66 0F 7E C1 0F 28 FB 66 0F 73 D7 28 66 0F 7E F8 66 0F 70 C0 02 0F 29 6C 24 60 66 0F 70 FF 02 F2 0F 10 A8 ?? ?? ?? ?? 66 0F 7E C0 66 0F 7E FA F2 0F 10 B9 ?? ?? ?? ?? 66 0F 16 B8 ?? ?? ?? ?? 0F 29 7C 24 70 0F 28 3D ?? ?? ?? ?? 0F 28 C7 66 0F C2 C3 01 66 0F C2 FA 01 0F 28 1D ?? ?? ?? ?? 0F 28 15 ?? ?? ?? ?? 0F 54 C3 0F 54 FB 0F 56 C2 0F 56 FA 66 0F 5C F0 66 0F 5C E7 0F 28 1D ?? ?? ?? ?? 0F 28 05 ?? ?? ?? ?? 66 0F 59 F3 66 0F 59 E3 0F 28 7C 24 60 0F 28 D8 66 0F 59 D9 66 0F 59 C7 0F 29 A4 24 80 00 00 00 0F 28 E1 0F 28 15 ?? ?? ?? ?? 66 0F 59 E1 66 0F 58 DA 66 0F 58 C2 66 0F 59 DC 0F 28 D7 66 0F 59 D7 66 0F 58 CB 66 0F 59 C2 66 0F 58 F8 66 0F 16 AA ?? ?? ?? ?? 66 0F 58 CD 66 0F 58 7C 24 70 66 0F 58 CE 66 0F 58 BC 24 80 00 00 00 66 0F 59 4C 24 20 66 0F 59 7C 24 30 0F 28 25 ?? ?? ?? ?? 0F 28 DC 66 0F 59 D9 66 0F 59 E7 0F 28 35 ?? ?? ?? ?? 0F 28 D3 66 0F 5C D6 0F 29 A4 24 90 00 00 00 66 0F 5C E6 0F 28 35 ?? ?? ?? ?? 66 0F 58 D6 66 0F 58 E6 0F 28 EA 0F 28 C4 66 0F 5C EE 66 0F 5C C6 66 0F 6F 74 24 40 0F 29 AC 24 A0 00 00 00 66 0F 6F EE 0F C6 CF DD 66 0F 6F 3D ?? ?? ?? ?? 0F 29 84 24 B0 00 00 00 66 0F 66 EF 66 0F 6F 44 24 50 66 0F 76 F7 66 0F 6F 3D ?? ?? ?? ?? 66 0F EB EE 66 0F 6F F0 66 0F 76 C7 66 0F 66 F7 66 0F EB F0 0F 28 C2 66 0F EB EE 66 0F 73 D2 0B 0F 28 B4 24 90 00 00 00 66 0F 73 F2 34 66 0F 5C 9C 24 A0 00 00 00 66 0F 5C B4 24 B0 00 00 00 0F 28 3D ?? ?? ?? ?? 66 0F DB 0D ?? ?? ?? ?? 0F 54 C7 66 0F 66 0D ?? ?? ?? ?? 0F 54 FC 66 0F 7E C2 66 0F EB E9 0F 28 0D ?? ?? ?? ?? 66 0F 73 D4 0B 66 0F 73 F4 34 66 0F C5 C8 04 66 0F 59 D9 66 0F 59 F1 0F 50 C5 F3 0F 7E 2C D5 ?? ?? ?? ?? 66 0F 16 2C CD ?? ?? ?? ?? 66 0F 7E FA 85 C0 66 0F C5 CF 04 66 0F 59 DD F3 0F 7E 04 D5 ?? ?? ?? ?? 66 0F 16 04 CD ?? ?? ?? ?? 66 0F 59 F0 66 0F 58 DD 66 0F 58 F0 66 0F D4 DA 66 0F D4 F4 66 0F 5A C3 66 0F 5A CE 0F 16 C1 75 04 8B E5 5D C3 0F 28 0C 24 0F 28 54 24 10 0F 29 4C 24 40 0F 29 94 24 80 00 00 00 0F 29 84 24 C0 00 00 00 74 DC 33 D2 89 74 24 04 8B F2 89 3C 24 8B F8 8B CE B8 01 00 00 00 D3 E0 85 F8 75 17 46 83 FE 20 7C ED 8B 74 24 04 8B 3C 24 0F 28 84 24 C0 00 00 00 EB AB 8D 8C B4 C0 00 00 00 8D 54 B4 40 8D 84 B4 80 00 00 00 51 50 52 E8 ?? ?? ?? ?? 83 C4 0C EB CA 8D A4 24 00 00 00 00 8D A4 24 00 00 00 00 90 }
	condition:
		$1
}

rule file_74_0_0 {
	meta:
		name = "___sse2_asinf4"
		size = 336
		refs = "000f ___common_sasin_data 013c ___common_sasin_cout_rare"
	strings:
		$1 = { 55 8B EC 83 E4 C0 81 EC C0 00 00 00 0F 28 2D ?? ?? ?? ?? 0F 28 F5 0F 55 E8 0F 54 F0 0F 28 1D ?? ?? ?? ?? 0F 28 FE 0F 59 FB 0F 28 E6 0F 59 E6 0F 28 15 ?? ?? ?? ?? 0F C2 D6 02 0F 29 04 24 0F 28 C3 0F 50 D2 0F 28 D6 0F C2 D3 05 0F 5C C7 0F 52 D8 0F 5D E0 0F 58 C0 0F 28 CB 0F 28 FC 0F 59 CB 85 D2 0F 59 D8 0F 59 FC 0F 59 C1 0F 28 0D ?? ?? ?? ?? 0F 5C 05 ?? ?? ?? ?? 0F 59 C8 0F 59 C3 0F 58 0D ?? ?? ?? ?? 0F 59 C8 0F 28 05 ?? ?? ?? ?? 0F 5C CB 0F 59 C4 0F 28 1D ?? ?? ?? ?? 0F 54 CA 0F 59 DC 0F 58 05 ?? ?? ?? ?? 0F 59 C7 0F 58 1D ?? ?? ?? ?? 0F 58 C3 0F 59 C4 0F 58 05 ?? ?? ?? ?? 0F 59 C4 0F 28 E2 0F 55 E6 0F 56 E1 0F 59 C4 0F 28 35 ?? ?? ?? ?? 0F 58 C4 0F 54 F2 0F 58 C6 66 0F EF C5 75 04 8B E5 5D C3 0F 28 0C 24 0F 29 4C 24 40 0F 29 84 24 80 00 00 00 74 E9 33 C0 89 74 24 04 8B F0 89 3C 24 8B FA 8B CE B8 01 00 00 00 D3 E0 85 F8 75 17 46 83 FE 20 7C ED 8B 74 24 04 8B 3C 24 0F 28 84 24 80 00 00 00 EB B8 8D 8C B4 80 00 00 00 8D 44 B4 40 51 50 E8 ?? ?? ?? ?? 83 C4 08 EB D2 8D A4 24 00 00 00 00 8D 64 24 00 }
	condition:
		$1
}

rule file_75_0_0 {
	meta:
		name = "__EH_prolog"
		size = 32
	strings:
		$1 = { 6A FF 50 64 A1 00 00 00 00 50 8B 44 24 0C 64 89 25 00 00 00 00 89 6C 24 0C 8D 6C 24 0C 50 F2 C3 }
	condition:
		$1
}

rule file_76_0_0 {
	meta:
		name = "___avx_cosf8"
		size = 3200
		refs = "0013 ___common_scos_data 0130 ___common_scos_cout_rare 01df ___common_scos_reduction_data"
	strings:
		$1 = { 55 8B EC 83 E4 C0 56 57 53 81 EC F4 02 00 00 C5 FC 54 15 ?? ?? ?? ?? C5 E1 EF DB C5 EC C2 25 ?? ?? ?? ?? 1E C4 E3 7D 19 E5 01 C5 D9 6B F5 C5 C9 63 FB C5 F9 D7 C7 84 C0 0F 85 FB 00 00 00 C5 FC 58 3D ?? ?? ?? ?? 33 DB C5 FC 10 35 ?? ?? ?? ?? C5 C4 59 15 ?? ?? ?? ?? C5 EC 58 D6 C5 E1 72 F2 1F C4 E3 7D 19 D5 01 C5 EC 5C D6 C5 D1 72 F5 1F C5 EC 5C 25 ?? ?? ?? ?? C5 DC 59 15 ?? ?? ?? ?? C5 FC 5C D2 C4 E3 65 18 ED 01 C5 DC 59 1D ?? ?? ?? ?? C5 EC 5C D3 C5 DC 59 1D ?? ?? ?? ?? C5 EC 5C D3 C5 DC 59 1D ?? ?? ?? ?? C5 EC 5C D3 C5 EC 59 DA C5 E4 59 25 ?? ?? ?? ?? C5 DC 58 25 ?? ?? ?? ?? C5 DC 59 E3 C5 DC 58 25 ?? ?? ?? ?? C5 DC 59 E3 C5 DC 58 25 ?? ?? ?? ?? C5 DC 59 DB C5 EC 57 D5 C5 E4 59 DA C5 E4 58 D2 84 DB 75 11 C5 FC 28 C2 81 C4 F4 02 00 00 5B 5F 5E 8B E5 5D C3 C5 FC 11 04 24 C5 FC 11 54 24 40 85 DB 74 E0 33 F6 0F A3 F3 72 0E 46 83 FE 20 7C F5 C5 FC 10 54 24 40 EB CB C5 F8 77 8D 44 B4 40 8D 14 B4 50 52 E8 ?? ?? ?? ?? 83 C4 08 EB DC C5 FC 10 25 ?? ?? ?? ?? BA 00 00 80 7F C5 FC 11 44 24 40 C5 F9 6E FA C5 DC 54 EA C5 D4 C2 D4 00 C4 E3 7D 19 C4 01 C5 F8 11 A4 24 90 00 00 00 C4 E3 7D 19 D5 01 C5 E9 6B F5 C5 C9 63 DB C5 F9 70 D7 00 C5 F9 D7 C3 89 84 24 A0 02 00 00 C5 F8 28 C8 C5 E9 DB D9 C5 D1 72 D3 17 C5 E9 DB DC C5 E9 72 D3 17 C5 E1 72 F5 01 C5 E1 FE DD C5 D1 72 F3 02 C5 E1 72 F2 01 C5 F9 7E EA C5 E1 FE DA C5 E1 72 F3 02 C5 F8 11 8C 24 80 00 00 00 C4 E3 79 16 E9 01 C4 E3 79 16 E8 02 C4 E3 79 16 EF 03 C5 F9 7E DE C5 F9 6E 91 ?? ?? ?? ?? C4 E3 79 16 9C 24 AC 02 00 00 01 C4 E3 79 16 9C 24 B0 02 00 00 02 C4 E3 79 16 DB 03 C5 F9 6E 9A ?? ?? ?? ?? C5 E1 6C EA C5 F9 6E 98 ?? ?? ?? ?? C5 F9 6E 97 ?? ?? ?? ?? C5 E1 6C DA 89 B4 24 A8 02 00 00 C5 D0 C6 F3 88 C5 F9 6E 9E ?? ?? ?? ?? 8B B4 24 AC 02 00 00 89 BC 24 A4 02 00 00 C5 F9 6E 83 ?? ?? ?? ?? C5 F9 6E 96 ?? ?? ?? ?? 8B B4 24 B0 02 00 00 C5 E1 6C EA C5 F9 6E 93 ?? ?? ?? ?? C5 F9 6E 9E ?? ?? ?? ?? C5 E1 6C DA C5 D0 C6 EB 88 C5 F9 6E 9A ?? ?? ?? ?? C5 F9 6E 91 ?? ?? ?? ?? C5 E1 6C FA C5 F9 6E 97 ?? ?? ?? ?? 8B BC 24 A8 02 00 00 C5 F9 6E 98 ?? ?? ?? ?? C5 E1 6C DA C5 C0 C6 FB 88 C5 F9 6E 9F ?? ?? ?? ?? 8B BC 24 AC 02 00 00 C5 F8 11 B4 24 A0 00 00 00 C5 F8 11 AC 24 B0 00 00 00 C5 F9 6E 97 ?? ?? ?? ?? C5 E1 6C D2 C5 F9 6E 9E ?? ?? ?? ?? C5 E1 6C D8 C5 E8 C6 D3 88 C5 F8 11 94 24 C0 00 00 00 C5 F9 6E 9A ?? ?? ?? ?? C5 F9 6E 91 ?? ?? ?? ?? B9 FF FF 7F 00 C5 E1 6C DA C5 F9 6E 90 ?? ?? ?? ?? 8B 84 24 A4 02 00 00 8B 94 24 A8 02 00 00 C5 F9 6E 80 ?? ?? ?? ?? B8 FF FF 00 00 C5 E9 6C D0 C5 E0 C6 DA 88 C5 F8 11 9C 24 D0 00 00 00 C5 F9 6E 9A ?? ?? ?? ?? BA 00 00 00 80 C5 F9 6E 97 ?? ?? ?? ?? BF 00 00 80 28 C5 F9 6E 83 ?? ?? ?? ?? BB 00 00 80 00 C5 E1 6C DA C5 F9 6E 96 ?? ?? ?? ?? BE FF 00 00 00 C5 E9 6C D0 C5 E0 C6 C2 88 C5 F9 6E D9 C5 F9 70 D3 00 C5 F9 6E DB C5 F9 70 DB 00 C5 E9 DB E4 C5 E9 DB C9 C5 D9 FE D3 C5 F9 6E E0 C5 F1 FE CB C5 F9 70 DC 00 B9 00 00 80 3F C5 C9 DB E3 C5 D1 DB F3 C5 D1 72 D7 10 C5 C1 DB FB C5 FA 7F AC 24 10 01 00 00 BB 00 00 40 47 C5 F8 10 AC 24 C0 00 00 00 B8 FF FF 03 00 C5 FA 7F B4 24 00 01 00 00 C5 C9 72 D5 10 C5 D1 DB EB C5 FA 7F AC 24 40 01 00 00 C5 F8 10 AC 24 D0 00 00 00 C5 F8 11 84 24 E0 00 00 00 C5 F9 72 D0 10 C5 FA 7F 84 24 60 01 00 00 C5 F9 72 D1 10 C5 F1 DB CB C5 D1 72 D5 10 C5 FA 7F AC 24 50 01 00 00 C5 D1 72 D2 10 C5 E9 DB D3 C5 FA 7F A4 24 F0 00 00 00 C4 E2 71 40 E4 C5 FA 7F A4 24 A0 01 00 00 C4 E2 69 40 A4 24 00 01 00 00 C5 FA 7F B4 24 20 01 00 00 C5 FA 7F BC 24 30 01 00 00 C5 FA 7F A4 24 B0 01 00 00 C4 E2 69 40 F6 C4 E2 71 40 A4 24 10 01 00 00 C5 FA 7F B4 24 D0 01 00 00 C4 E2 71 40 F7 C5 E1 DB BC 24 D0 00 00 00 C5 FA 7F A4 24 C0 01 00 00 C4 E2 79 40 E7 C5 FA 6F BC 24 50 01 00 00 C5 D9 72 D4 10 C5 FA 7F 8C 24 80 01 00 00 C4 E2 71 40 CF C5 FA 7F 84 24 70 01 00 00 C4 E2 79 40 C7 C5 C1 72 D1 10 C5 FA 7F B4 24 E0 01 00 00 C5 C9 DB F3 C5 F9 FE C7 C5 C9 FE F0 C5 D9 FE FE C5 E1 DB A4 24 E0 00 00 00 C5 FA 7F 94 24 90 01 00 00 C4 E2 69 40 94 24 40 01 00 00 C4 E2 51 40 CC C5 E9 DB C3 C5 FA 7F 94 24 F0 01 00 00 C5 C9 72 D1 10 C5 FA 6F 8C 24 60 01 00 00 C5 FA 6F 94 24 90 01 00 00 C4 E2 69 40 D1 C4 E2 51 40 E1 C5 E9 72 D2 10 C5 D9 FE E2 C5 F9 FE C4 C5 FA 7F BC 24 00 02 00 00 C5 C9 FE C8 C5 FA 6F A4 24 70 01 00 00 C5 C9 72 D7 10 C5 FA 6F BC 24 E0 01 00 00 C4 E2 59 40 84 24 30 01 00 00 C5 C1 72 D7 10 C5 E1 DB 94 24 C0 01 00 00 C5 F9 FE C7 C5 FA 7F 8C 24 10 02 00 00 C5 E9 FE D0 C5 C1 72 D1 10 C5 C9 FE C2 C5 FA 6F 8C 24 F0 01 00 00 C4 E2 51 40 B4 24 40 01 00 00 C5 F1 72 D1 10 C5 E1 DB 94 24 D0 01 00 00 C5 C9 FE F1 C5 E9 FE D6 C5 C1 FE F2 C5 FA 6F 94 24 C0 01 00 00 C4 E2 59 40 BC 24 10 01 00 00 C5 E9 72 D2 10 C5 E1 DB 8C 24 A0 01 00 00 C5 C1 FE FA C5 FA 7F 84 24 20 02 00 00 C5 F9 72 D0 10 C5 F1 FE D7 C5 FA 7F B4 24 30 02 00 00 C5 F9 FE FA C5 E9 72 D6 10 C5 FA 6F B4 24 D0 01 00 00 C4 E2 51 40 8C 24 20 01 00 00 C5 C9 72 D6 10 C5 E1 DB 84 24 B0 01 00 00 C5 F1 FE CE C5 F9 FE C1 C5 C9 72 D7 10 C5 E9 FE C8 C5 C1 DB FB C5 F8 10 84 24 A0 00 00 00 C5 FA 6F 94 24 80 01 00 00 C5 F9 72 D0 10 C4 E2 69 40 D0 C4 E2 59 40 84 24 F0 00 00 00 C5 E9 DB D3 C5 FA 6F A4 24 A0 01 00 00 C5 D9 72 D4 10 C5 F9 FE C4 C5 E9 FE D0 C5 C9 FE F2 C5 E9 72 D1 10 C5 F8 10 A4 24 B0 00 00 00 C5 F9 72 F6 10 C5 FA 6F B4 24 90 01 00 00 C5 F9 FE C7 C5 C1 72 D4 10 C5 F1 DB CB C4 E2 49 40 E7 C4 E2 51 40 B4 24 00 01 00 00 C5 D9 DB E3 C5 FA 6F AC 24 B0 01 00 00 C5 D1 72 D5 10 C5 C9 FE FD C5 D9 FE E7 C5 E9 FE D4 C5 D9 72 F2 10 C5 FA 6F BC 24 30 02 00 00 C5 D9 FE E9 C5 FA 6F A4 24 20 02 00 00 C5 E1 DB B4 24 00 02 00 00 C5 E9 72 F4 10 C5 E1 DB 9C 24 10 02 00 00 C5 D9 72 F7 10 C5 D9 FE E3 C5 F9 6E DA C5 E9 FE CE C5 F9 6E F1 C5 F9 70 D3 00 BA 00 00 00 34 C5 E9 DB 9C 24 80 00 00 00 B9 FF 01 00 00 C5 F9 70 F6 00 C5 E9 DB 94 24 90 00 00 00 C5 E1 EF FE C5 FA 7F 84 24 40 02 00 00 C5 F9 72 D0 09 C5 FA 7F AC 24 50 02 00 00 C5 D1 72 D5 09 C5 E9 EF F6 C5 F9 EB C7 C5 D1 EB EE C4 E3 7D 18 ED 01 C5 F9 6E C3 C5 F9 70 F0 00 BB DB 0F C9 40 C4 E3 4D 18 FE 01 C5 C4 58 C5 C5 FC 5C F7 C5 F9 6E FE C5 D4 5C EE BE 00 10 C9 40 C5 FC 11 6C 24 60 C5 F9 6E EF C5 F9 70 F5 00 C5 E9 EF EE BF 7A 77 95 B7 C5 F8 11 84 24 60 02 00 00 C4 E3 7D 19 84 24 70 02 00 00 01 C5 F9 70 C7 00 C5 F9 6E F8 C5 F9 70 FF 00 B8 00 F0 FF FF C5 FA 7F 84 24 80 02 00 00 C5 E1 EF C6 C5 C1 DB F1 C5 C1 DB FC C5 C9 72 F6 05 C5 C1 72 F7 05 C5 C9 EB F0 C5 C1 EB FD C5 F1 72 D1 12 C5 D9 72 D4 12 C4 E3 4D 18 FF 01 C4 E3 7D 18 ED 01 C5 F9 6E C2 C5 C4 5C FD BA FF FF FF 7F C5 F9 70 E8 00 C5 E1 EF C5 C5 F9 6E D9 C5 F9 70 DB 00 C5 E9 EF D5 C5 E1 DB B4 24 40 02 00 00 B9 00 00 80 35 C5 E1 DB 9C 24 50 02 00 00 C5 D1 72 F6 0E C5 E1 72 F3 0E C5 D1 EB E9 C5 E1 EB E4 C5 D1 EB C8 C5 D9 EB DA C4 E3 75 18 EB 01 C5 FC 10 4C 24 60 C4 E3 7D 18 D2 01 C5 D4 5C C2 C5 F9 6E EF C5 F4 58 F0 C5 F4 5C E6 C5 FC 58 DC C5 F9 6E E6 C5 E4 58 D7 C5 F9 6E FB C5 F9 70 DC 00 C5 F9 6E E0 C5 F9 70 C7 00 C5 F9 70 FD 00 C5 F9 70 EC 00 C4 E3 55 18 E5 01 C5 CC 54 E4 C5 CC 5C F4 C4 E3 7D 18 C8 01 C4 E3 65 18 C3 01 C4 E3 45 18 DF 01 C5 FC 59 FC C5 FC 59 EE C5 E4 59 C4 C5 F4 59 D2 C5 F9 6E C9 C5 E4 59 F6 C5 D4 58 C0 C5 F9 6E EA C5 EC 58 E6 C5 F9 70 F5 00 C5 FC 58 D4 C5 FC 10 44 24 40 C5 C4 58 E2 C5 C4 5C DC C5 F9 70 F9 00 C5 E4 58 D2 C4 E3 4D 18 DE 01 C5 FC 54 EB C4 E3 45 18 F7 01 C5 D4 C2 DE 1E C5 D4 C2 EE 12 C5 D4 54 E8 C5 E4 54 E4 C5 E4 54 D2 C5 D4 56 E4 C5 FA 6F AC 24 80 02 00 00 C5 FC 11 14 24 C5 D1 DB 94 24 60 02 00 00 C5 C9 72 F2 04 C5 D1 DB 94 24 70 02 00 00 C5 E9 72 F2 04 C5 F9 7E F6 C5 F9 7E D2 C5 DC 59 DC C4 E3 79 16 F3 01 C4 E3 79 16 F7 02 C4 E3 79 16 F1 03 C4 E3 79 16 94 24 BC 02 00 00 01 C4 E3 79 16 94 24 C0 02 00 00 02 C4 E3 79 16 D0 03 C5 F9 6E 96 ?? ?? ?? ?? C5 F9 6E AB ?? ?? ?? ?? C5 E9 6C F5 C5 F9 6E 97 ?? ?? ?? ?? C5 F9 6E A9 ?? ?? ?? ?? 89 94 24 B8 02 00 00 C5 E9 6C D5 C5 F9 6E AA ?? ?? ?? ?? 8B 94 24 BC 02 00 00 C5 C8 C6 D2 88 89 8C 24 B4 02 00 00 C5 F9 6E B2 ?? ?? ?? ?? 8B 94 24 C0 02 00 00 C5 D1 6C FE C5 F9 6E B0 ?? ?? ?? ?? C5 F9 6E AA ?? ?? ?? ?? C5 D1 6C EE C5 C0 C6 ED 88 C5 F9 6E B3 ?? ?? ?? ?? C5 F9 6E 88 ?? ?? ?? ?? 89 9C 24 94 02 00 00 89 B4 24 98 02 00 00 89 BC 24 9C 02 00 00 C4 E3 6D 18 D5 01 C5 F9 6E AE ?? ?? ?? ?? C5 D1 6C FE C5 F9 6E B1 ?? ?? ?? ?? 8B 8C 24 B8 02 00 00 C5 F9 6E AF ?? ?? ?? ?? C5 D1 6C EE C5 F9 6E B1 ?? ?? ?? ?? 8B 8C 24 BC 02 00 00 C5 C0 C6 ED 88 C5 F9 6E B9 ?? ?? ?? ?? C5 C9 6C F7 C5 F9 6E BA ?? ?? ?? ?? C5 C1 6C F9 C5 C8 C6 F7 88 C4 E3 55 18 EE 01 C5 F9 6E B3 ?? ?? ?? ?? C5 FC 11 6C 24 20 C5 F9 6E AE ?? ?? ?? ?? C5 D1 6C F6 8B 9F ?? ?? ?? ?? 89 9C 24 90 02 00 00 8B 9C 24 A0 02 00 00 8B B4 24 B4 02 00 00 8B BC 24 B8 02 00 00 C5 FC 11 44 24 40 C5 F9 6E AC 24 90 02 00 00 C5 F9 6E 86 ?? ?? ?? ?? C5 D1 6C C8 C5 C8 C6 F9 88 89 9C 24 A0 02 00 00 8B 9C 24 98 02 00 00 C5 F9 6E B7 ?? ?? ?? ?? C5 F9 6E A9 ?? ?? ?? ?? C5 F9 6E 82 ?? ?? ?? ?? C5 F9 6E 88 ?? ?? ?? ?? C5 C9 6C F5 C5 F9 6C E9 C5 C8 C6 C5 88 C5 F9 6E AB ?? ?? ?? ?? 8B 9C 24 94 02 00 00 C5 F9 6E B6 ?? ?? ?? ?? C4 E3 45 18 F8 01 C5 F9 6E 83 ?? ?? ?? ?? 8B 9C 24 9C 02 00 00 C5 FC 11 7C 24 60 C5 D1 6C F8 C5 F9 6E 8B ?? ?? ?? ?? C5 F1 6C EE C5 C0 C6 ED 88 C5 F9 6E 87 ?? ?? ?? ?? C5 F9 6E 89 ?? ?? ?? ?? C5 F9 6E B2 ?? ?? ?? ?? C5 F9 6E B8 ?? ?? ?? ?? C5 F9 6C C1 C5 C9 6C CF C5 F8 C6 F1 88 C5 FC 10 7C 24 20 8B 9C 24 A0 02 00 00 C4 E3 55 18 EE 01 C5 DC 59 C5 C5 EC 59 F4 C5 FC 11 AC 24 80 00 00 00 C5 C4 58 C8 C5 CC 58 E9 C5 C4 5C F9 C5 C4 58 F8 C5 F4 5C C5 C5 FC 58 CE C5 E4 59 35 ?? ?? ?? ?? C5 F4 58 C7 C5 CC 58 0D ?? ?? ?? ?? C5 F4 59 F3 C5 CC 59 CC C5 EC 58 B4 24 80 00 00 00 C5 E4 59 15 ?? ?? ?? ?? C5 EC 58 15 ?? ?? ?? ?? C5 EC 59 DB C5 FC 10 54 24 20 C5 DC 59 E2 C5 E4 59 DA C5 CC 5C E4 C5 DC 59 3C 24 C5 F4 59 CC C5 C4 58 74 24 60 C5 F4 58 C0 C5 E4 58 D6 C5 EC 58 D8 C5 FC 10 44 24 40 C5 D4 58 D3 E9 74 F4 FF FF 8D A4 24 00 00 00 00 8D 49 00 }
	condition:
		$1
}

rule file_77_0_0 {
	meta:
		name = "___sse4_exp2"
		size = 672
		refs = "0004 _static_const_table"
	strings:
		$1 = { 66 0F 28 1D ?? ?? ?? ?? 66 0F 28 15 ?? ?? ?? ?? 66 0F 59 D8 66 0F 28 25 ?? ?? ?? ?? 66 0F 28 0D ?? ?? ?? ?? 66 0F 58 D3 66 0F C5 C8 03 66 0F 28 E8 66 0F 3A 09 DB 00 66 0F 7E D0 81 E1 FF 7F 00 00 66 0F 59 E3 66 0F C5 D2 04 81 F9 86 40 00 00 66 0F 59 1D ?? ?? ?? ?? 66 0F FE CA 66 0F C5 C8 07 66 0F 5C C4 0F 8D 95 00 00 00 81 E1 FF 7F 00 00 83 E0 3F 83 E2 3F 66 0F 5C C3 66 0F 28 35 ?? ?? ?? ?? 66 0F 28 1D ?? ?? ?? ?? 66 0F 73 D1 06 F3 0F 7E 24 C5 ?? ?? ?? ?? 66 0F 28 F8 66 0F 59 C0 66 0F 73 F1 34 81 F9 86 40 00 00 0F 8D 8E 00 00 00 66 0F 16 24 D5 ?? ?? ?? ?? 66 0F 59 F0 66 0F 59 D8 66 0F 58 35 ?? ?? ?? ?? 66 0F 58 1D ?? ?? ?? ?? 66 0F 59 F0 66 0F 59 C3 66 0F 59 F7 66 0F 58 C7 66 0F 58 35 ?? ?? ?? ?? 66 0F EB CC 66 0F 58 C6 66 0F 59 C1 C3 8D A4 24 00 00 00 00 90 83 E0 3F 83 E2 3F 66 0F 5C C3 66 0F 28 35 ?? ?? ?? ?? 66 0F 28 1D ?? ?? ?? ?? 66 0F 73 D1 06 F3 0F 7E 24 C5 ?? ?? ?? ?? 66 0F 28 F8 66 0F 59 C0 66 0F 73 F1 34 8D A4 24 00 00 00 00 8D 64 24 00 66 0F 16 24 D5 ?? ?? ?? ?? 66 0F 59 F0 66 0F 59 D8 66 0F 58 35 ?? ?? ?? ?? 66 0F 58 1D ?? ?? ?? ?? 66 0F 59 F0 66 0F 59 C3 66 0F 59 F7 66 0F 58 C7 66 0F 58 35 ?? ?? ?? ?? 66 0F EB CC 66 0F 58 C6 66 0F 59 C8 66 0F 28 1D ?? ?? ?? ?? 66 0F DB DD 66 0F C2 1D ?? ?? ?? ?? 01 66 0F DB CB 66 0F 28 35 ?? ?? ?? ?? 66 0F DB F5 66 0F C2 35 ?? ?? ?? ?? 01 66 0F DF DE 66 0F DB C3 66 0F DB D3 66 0F DB E3 66 0F C5 C5 03 66 0F C5 D5 07 C1 E8 0F C1 EA 0F 66 0F FE 15 ?? ?? ?? ?? 66 0F 73 D2 06 F3 0F 7E 3C C5 ?? ?? ?? ?? 66 0F 16 3C D5 ?? ?? ?? ?? 66 0F FE D7 66 0F 73 F2 34 66 0F EB D4 66 0F 59 C2 F3 0F 7E 3C C5 ?? ?? ?? ?? 66 0F 16 3C D5 ?? ?? ?? ?? 66 0F 59 C7 66 0F EB C1 66 0F 28 3D ?? ?? ?? ?? 66 0F DB FD 66 0F C2 3D ?? ?? ?? ?? 01 66 0F DF F7 F3 0F 7E 0C C5 ?? ?? ?? ?? 66 0F 16 0C D5 ?? ?? ?? ?? 66 0F DB CE 66 0F 28 35 ?? ?? ?? ?? 66 0F DB F5 66 0F C2 35 ?? ?? ?? ?? 00 F3 0F 7E 3C C5 ?? ?? ?? ?? 66 0F 16 3C D5 ?? ?? ?? ?? 66 0F DB F7 66 0F EB CE 66 0F 28 35 ?? ?? ?? ?? 66 0F C2 F5 03 66 0F DB EE 66 0F EB CD 66 0F 59 C9 66 0F EB C1 E9 5A FE FF FF 8D 49 00 }
	condition:
		$1
}

rule file_78_0_0 {
	meta:
		name = "___sse4_expf4"
		size = 704
		refs = "0003 _static_const_table"
	strings:
		$1 = { 0F 28 1D ?? ?? ?? ?? 0F 59 D8 0F 28 25 ?? ?? ?? ?? 0F 28 0D ?? ?? ?? ?? 66 0F 5B D3 0F 28 3D ?? ?? ?? ?? 0F 28 E8 66 0F DB F8 66 0F 3A 08 DB 00 66 0F 7E D0 0F 59 E3 66 0F C5 D2 02 0F 59 1D ?? ?? ?? ?? 83 E0 3F 83 E2 3F 66 0F FE CA 0F 5C C4 66 0F 66 3D ?? ?? ?? ?? F3 0F 7E 24 C5 ?? ?? ?? ?? 66 0F C5 C2 04 0F 16 24 D5 ?? ?? ?? ?? 66 0F C5 D2 06 0F 50 CF 0F 5C C3 83 E0 3F 83 E2 3F 23 C9 66 0F 72 D1 06 75 38 F3 0F 7E 14 C5 ?? ?? ?? ?? 0F 16 14 D5 ?? ?? ?? ?? 0F 28 D8 0F 58 C0 0F 59 DB 0F 58 05 ?? ?? ?? ?? 0F C6 E2 88 66 0F 72 F1 17 0F 58 C3 66 0F EB CC 0F 59 C1 C3 8D 49 00 F3 0F 7E 34 C5 ?? ?? ?? ?? 0F 16 34 D5 ?? ?? ?? ?? 0F 28 F8 0F 58 C0 0F 59 FF 0F 58 05 ?? ?? ?? ?? 0F C6 E6 88 66 0F 72 F1 17 0F 58 C7 66 0F EB CC 0F 59 C8 0F 28 1D ?? ?? ?? ?? 66 0F DB DD 0F C2 1D ?? ?? ?? ?? 01 66 0F DB CB 0F 28 35 ?? ?? ?? ?? 66 0F DB F5 0F C2 35 ?? ?? ?? ?? 01 66 0F DF DE 66 0F DB C3 66 0F DB D3 66 0F DB E3 66 0F FE 15 ?? ?? ?? ?? 66 0F 72 D2 06 66 0F C5 C5 01 66 0F C5 D5 03 C1 E8 0F C1 EA 0F F3 0F 7E 3C C5 ?? ?? ?? ?? 0F 16 3C D5 ?? ?? ?? ?? 66 0F C5 C5 05 66 0F C5 D5 07 C1 E8 0F C1 EA 0F F3 0F 7E 1C C5 ?? ?? ?? ?? 0F 16 1C D5 ?? ?? ?? ?? 0F C6 FB 88 66 0F FE D7 66 0F 72 F2 17 66 0F EB D4 0F 59 C2 66 0F C5 C5 01 66 0F C5 D5 03 C1 E8 0F C1 EA 0F F3 0F 7E 3C C5 ?? ?? ?? ?? 0F 16 3C D5 ?? ?? ?? ?? 66 0F C5 C5 05 66 0F C5 D5 07 C1 E8 0F C1 EA 0F F3 0F 7E 1C C5 ?? ?? ?? ?? 0F 16 1C D5 ?? ?? ?? ?? 0F C6 FB 88 0F 59 C7 66 0F EB C1 0F 28 3D ?? ?? ?? ?? 66 0F DB FD 0F C2 3D ?? ?? ?? ?? 01 66 0F DF F7 66 0F C5 C5 01 66 0F C5 D5 03 C1 E8 0F C1 EA 0F F3 0F 7E 0C C5 ?? ?? ?? ?? 0F 16 0C D5 ?? ?? ?? ?? 66 0F C5 C5 05 66 0F C5 D5 07 C1 E8 0F C1 EA 0F F3 0F 7E 1C C5 ?? ?? ?? ?? 0F 16 1C D5 ?? ?? ?? ?? 0F C6 CB 88 66 0F DB CE 0F 28 35 ?? ?? ?? ?? 66 0F DB F5 0F C2 35 ?? ?? ?? ?? 00 66 0F C5 C5 01 66 0F C5 D5 03 C1 E8 0F C1 EA 0F F3 0F 7E 3C C5 ?? ?? ?? ?? 0F 16 3C D5 ?? ?? ?? ?? 66 0F C5 C5 05 66 0F C5 D5 07 C1 E8 0F C1 EA 0F F3 0F 7E 1C C5 ?? ?? ?? ?? 0F 16 1C D5 ?? ?? ?? ?? 0F C6 FB 88 66 0F DB F7 66 0F EB CE 0F 28 35 ?? ?? ?? ?? 0F C2 F5 03 66 0F DB EE 66 0F EB CD 0F 59 C9 66 0F EB C1 E9 FD FD FF FF 90 }
	condition:
		$1
}

rule file_79_2_0 {
	meta:
		name = "__RTC_GetErrDesc"
		size = 24
		refs = "000e ?_RTC_errlist@@3QBQBDB"
	strings:
		$1 = { 55 8B EC 8B 45 08 83 F8 04 77 09 8B 04 85 ?? ?? ?? ?? 5D C3 33 C0 5D C3 }
	condition:
		$1
}

rule file_79_4_0 {
	meta:
		name = "__RTC_SetErrorFunc"
		size = 29
		refs = "0004 ?_RTC_ErrorReportFunc@@3P6AHHPBDH00ZZA 0013 ?_RTC_ErrorReportFuncW@@3P6AHHPB_WH00ZZA"
	strings:
		$1 = { 55 8B EC A1 ?? ?? ?? ?? 8B 4D 08 89 0D ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 00 00 00 00 5D C3 }
	condition:
		$1
}

rule file_79_5_0 {
	meta:
		name = "__RTC_SetErrorFuncW"
		size = 29
		refs = "0004 ?_RTC_ErrorReportFuncW@@3P6AHHPB_WH00ZZA 0013 ?_RTC_ErrorReportFunc@@3P6AHHPBDH00ZZA"
	strings:
		$1 = { 55 8B EC A1 ?? ?? ?? ?? 8B 4D 08 89 0D ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 00 00 00 00 5D C3 }
	condition:
		$1
}

rule file_79_6_0 {
	meta:
		name = "__RTC_SetErrorType"
		size = 35
		refs = "000e ?_RTC_ErrorLevels@@3PAHA"
	strings:
		$1 = { 55 8B EC 8B 55 08 83 FA 04 77 13 8B 04 95 ?? ?? ?? ?? 8B 4D 0C 89 0C 95 ?? ?? ?? ?? 5D C3 83 C8 FF 5D C3 }
	condition:
		$1
}

rule file_80_0_0 {
	meta:
		name = "___vdecl_fmodf8"
		size = 157
		refs = "0016 __CIfmod"
	strings:
		$1 = { 83 EC 40 C5 FE 7F 04 24 C5 FE 7F 4C 24 20 D9 04 24 D9 44 24 20 E8 ?? ?? ?? ?? D9 1C 24 D9 44 24 04 D9 44 24 24 E8 ?? ?? ?? ?? D9 5C 24 04 D9 44 24 08 D9 44 24 28 E8 ?? ?? ?? ?? D9 5C 24 08 D9 44 24 0C D9 44 24 2C E8 ?? ?? ?? ?? D9 5C 24 0C D9 44 24 10 D9 44 24 30 E8 ?? ?? ?? ?? D9 5C 24 10 D9 44 24 14 D9 44 24 34 E8 ?? ?? ?? ?? D9 5C 24 14 D9 44 24 18 D9 44 24 38 E8 ?? ?? ?? ?? D9 5C 24 18 D9 44 24 1C D9 44 24 3C E8 ?? ?? ?? ?? D9 5C 24 1C C5 FE 6F 04 24 83 C4 40 C3 }
	condition:
		$1
}

rule file_81_0_0 {
	meta:
		name = "___sse2_tanhf4"
		size = 240
		refs = "000f _static_const_table"
	strings:
		$1 = { 8B C4 83 EC 70 83 E4 F0 89 44 24 34 0F 28 35 ?? ?? ?? ?? 0F 28 3D ?? ?? ?? ?? 0F 54 F8 0F 58 F7 0F 28 15 ?? ?? ?? ?? 0F 54 D6 0F 29 54 24 10 0F 28 1D ?? ?? ?? ?? 0F C2 DF 02 0F 57 C7 0F 28 15 ?? ?? ?? ?? 0F 28 CF 0F C2 CA 02 0F 54 CB 0F 28 2D ?? ?? ?? ?? 8B 4C 24 10 8B 14 8D ?? ?? ?? ?? 89 14 24 0F 54 E9 8B 4C 24 14 8B 14 8D ?? ?? ?? ?? 89 54 24 04 8B 4C 24 18 8B 14 8D ?? ?? ?? ?? 89 54 24 08 8B 4C 24 1C 8B 14 8D ?? ?? ?? ?? 89 54 24 0C 0F 28 15 ?? ?? ?? ?? 0F 5C F2 0F 5C FE 0F 28 E7 0F 59 E7 0F 28 1D ?? ?? ?? ?? 0F 59 DC 0F 58 1D ?? ?? ?? ?? 0F 56 C5 0F 28 15 ?? ?? ?? ?? 0F 59 E2 0F 58 25 ?? ?? ?? ?? 0F 59 E7 0F 28 14 24 0F 28 F3 0F 59 F2 0F 58 F4 0F 59 E2 0F 58 E3 0F 5E F4 0F 55 CE 0F 56 C1 8B 64 24 34 C3 90 }
	condition:
		$1
}

rule file_82_0_0 {
	meta:
		name = "___sse2_asin2"
		size = 464
		refs = "001a _static_const_table"
	strings:
		$1 = { 8B C4 81 EC C0 00 00 00 83 E4 F0 89 84 24 84 00 00 00 66 0F 28 C8 66 0F 28 05 ?? ?? ?? ?? 66 0F 54 C1 66 0F 29 44 24 10 66 0F 55 C1 66 0F 28 E0 66 0F C2 25 ?? ?? ?? ?? 05 66 0F 28 3D ?? ?? ?? ?? 66 0F 29 04 24 66 0F 5C F8 66 0F 59 C0 66 0F 59 3D ?? ?? ?? ?? 66 0F 28 D4 66 0F 54 FC 66 0F 55 D0 66 0F 56 D7 66 0F 51 F7 66 0F 28 2D ?? ?? ?? ?? 66 0F 28 D8 66 0F C2 DD 00 66 0F 29 5C 24 20 66 0F 28 1D ?? ?? ?? ?? 66 0F 54 DC 66 0F 29 5C 24 40 66 0F 28 0D ?? ?? ?? ?? 66 0F 54 CC 66 0F 56 CD 66 0F 29 4C 24 50 66 0F 28 05 ?? ?? ?? ?? 66 0F 54 C4 66 0F FE C5 66 0F 29 44 24 60 66 0F 28 CA 66 0F 59 D2 66 0F 28 C2 66 0F 59 05 ?? ?? ?? ?? 66 0F 28 DA 66 0F 59 1D ?? ?? ?? ?? 66 0F 58 05 ?? ?? ?? ?? 66 0F 58 1D ?? ?? ?? ?? 66 0F 59 C2 66 0F 59 DA 66 0F 58 05 ?? ?? ?? ?? 66 0F 58 1D ?? ?? ?? ?? 66 0F 59 C2 66 0F 59 DA 66 0F 58 05 ?? ?? ?? ?? 66 0F 28 EC 66 0F 55 2C 24 66 0F 54 F4 66 0F 56 F5 66 0F 29 74 24 30 66 0F 58 1D ?? ?? ?? ?? 66 0F 59 C2 66 0F 59 DA 66 0F 58 05 ?? ?? ?? ?? 66 0F 58 1D ?? ?? ?? ?? 66 0F 59 C2 66 0F 59 DA 66 0F 58 05 ?? ?? ?? ?? 66 0F 58 1D ?? ?? ?? ?? 66 0F 59 C2 66 0F 59 DA 66 0F 58 05 ?? ?? ?? ?? 66 0F 59 C8 66 0F 58 CB 66 0F 59 4C 24 30 66 0F 58 4C 24 30 66 0F 59 4C 24 60 66 0F 59 4C 24 50 66 0F 58 4C 24 40 66 0F 28 54 24 20 66 0F 28 C2 66 0F 54 15 ?? ?? ?? ?? 66 0F 55 C1 66 0F 56 C2 66 0F 56 44 24 10 8B A4 24 84 00 00 00 C3 8D A4 24 00 00 00 00 EB 03 CC CC CC }
	condition:
		$1
}

rule file_85_0_0 {
	meta:
		name = "___sse2_floorf4"
		size = 80
		refs = "0006 _2il0floatpacket_4 0010 _2il0floatpacket_5 0037 _2il0floatpacket_6"
	strings:
		$1 = { 0F 28 D8 0F 28 0D ?? ?? ?? ?? 0F 28 E0 0F 28 15 ?? ?? ?? ?? 0F 54 D9 0F 55 C8 0F 28 EA 0F C2 E9 01 0F 58 CA 0F 28 F5 0F 54 C5 0F 5C CA 0F 56 CB 0F C2 E1 01 0F 54 25 ?? ?? ?? ?? 0F 5C CC 0F 55 F1 0F 56 C6 C3 8D A4 24 00 00 00 00 8D 64 24 00 }
	condition:
		$1
}

rule file_86_0_0 {
	meta:
		name = "___sse2_atan22"
		size = 656
		refs = "0021 _static_const_table"
	strings:
		$1 = { 8B C4 81 EC C0 00 00 00 83 E4 F0 89 84 24 84 00 00 00 66 0F 29 04 24 66 0F 29 4C 24 10 66 0F 28 15 ?? ?? ?? ?? 66 0F 28 1D ?? ?? ?? ?? 66 0F 54 D0 66 0F 54 D9 66 0F 29 54 24 30 66 0F 29 5C 24 40 66 0F 57 C2 66 0F 57 CB 66 0F 28 D0 66 0F C2 D1 05 66 0F 28 1D ?? ?? ?? ?? 66 0F 28 E2 66 0F 54 DA 66 0F 54 25 ?? ?? ?? ?? 66 0F 56 CC 66 0F 28 E2 66 0F 28 E8 66 0F 28 F1 66 0F 54 C2 66 0F 54 CA 66 0F 55 D6 66 0F 55 E5 66 0F 56 CC 66 0F 56 D0 66 0F 5E CA 66 0F 28 24 24 66 0F 28 2C 24 66 0F 28 74 24 10 66 0F 28 7C 24 10 66 0F 54 25 ?? ?? ?? ?? 66 0F 54 2D ?? ?? ?? ?? 66 0F 54 35 ?? ?? ?? ?? 66 0F 54 3D ?? ?? ?? ?? 66 0F C2 25 ?? ?? ?? ?? 06 66 0F C2 2D ?? ?? ?? ?? 01 66 0F C2 35 ?? ?? ?? ?? 06 66 0F C2 3D ?? ?? ?? ?? 01 66 0F 54 E5 66 0F 54 F7 66 0F 54 E6 66 0F 50 C4 83 F8 03 0F 8C 5A 01 00 00 66 0F 28 64 24 40 66 0F 72 E4 1F 66 0F 70 E4 F5 66 0F 54 25 ?? ?? ?? ?? 66 0F 29 64 24 50 66 0F 29 5C 24 60 66 0F 28 E1 66 0F 59 C9 66 0F 28 E9 66 0F 59 C9 66 0F 28 C1 66 0F 59 C9 66 0F 28 15 ?? ?? ?? ?? 66 0F 28 1D ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 28 3D ?? ?? ?? ?? 66 0F 59 D1 66 0F 59 D9 66 0F 59 F1 66 0F 59 F9 66 0F 58 15 ?? ?? ?? ?? 66 0F 58 1D ?? ?? ?? ?? 66 0F 58 35 ?? ?? ?? ?? 66 0F 58 3D ?? ?? ?? ?? 66 0F 59 D1 66 0F 59 D9 66 0F 59 F1 66 0F 59 F9 66 0F 58 15 ?? ?? ?? ?? 66 0F 58 1D ?? ?? ?? ?? 66 0F 58 35 ?? ?? ?? ?? 66 0F 58 3D ?? ?? ?? ?? 66 0F 59 D1 66 0F 59 D9 66 0F 59 F1 66 0F 59 F9 66 0F 58 15 ?? ?? ?? ?? 66 0F 58 1D ?? ?? ?? ?? 66 0F 58 35 ?? ?? ?? ?? 66 0F 58 3D ?? ?? ?? ?? 66 0F 59 D1 66 0F 59 D9 66 0F 59 F1 66 0F 59 F9 66 0F 58 15 ?? ?? ?? ?? 66 0F 58 1D ?? ?? ?? ?? 66 0F 58 35 ?? ?? ?? ?? 66 0F 58 3D ?? ?? ?? ?? 66 0F 59 D0 66 0F 59 D5 66 0F 59 D8 66 0F 59 F5 66 0F 58 D3 66 0F 58 F7 66 0F 58 F2 66 0F 59 F4 66 0F 58 74 24 60 66 0F 56 74 24 40 66 0F 58 74 24 50 66 0F 56 74 24 30 66 0F 28 C6 EB 21 DD 04 24 DD 44 24 10 D9 F3 DD 5C 24 20 DD 44 24 08 DD 44 24 18 D9 F3 DD 5C 24 28 66 0F 28 44 24 20 8B A4 24 84 00 00 00 C3 8D 64 24 00 }
	condition:
		$1
}

rule file_87_0_0 {
	meta:
		name = "___common_stan_cout_rare"
		size = 96
	strings:
		$1 = { 56 8B 54 24 08 8B 02 0F B7 4A 02 89 04 24 81 E1 80 7F 00 00 C1 E8 18 83 E0 7F F3 0F 10 0A 81 F9 80 7F 00 00 88 44 24 03 74 04 33 C0 59 C3 8B 44 24 0C 81 3C 24 00 00 80 7F 75 13 66 0F EF C0 F3 0F 59 C8 F3 0F 11 08 B8 01 00 00 00 59 C3 F3 0F 59 C9 F3 0F 11 08 33 C0 59 C3 8D 9B 00 00 00 00 }
	condition:
		$1
}

rule file_90_0_0 {
	meta:
		name = "??2@YAPAXI@Z"
		size = 70
		refs = "0009 _malloc 0023 __callnewh 0035 ?__scrt_throw_std_bad_array_new_length@@YAXXZ 003c ?__scrt_throw_std_bad_alloc@@YAXXZ"
	strings:
		$1 = { 55 8B EC 51 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 FC 83 7D FC 00 74 05 8B 45 FC EB 24 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 12 83 7D 08 FF 75 07 E8 ?? ?? ?? ?? EB 05 E8 ?? ?? ?? ?? EB C2 8B E5 5D C3 }
	condition:
		$1
}

rule file_92_0_0 {
	meta:
		name = "___common_stanh_cout_rare"
		size = 80
		refs = "0023 __imlsTanhHATab"
	strings:
		$1 = { 8B 54 24 04 0F B6 42 03 25 80 00 00 00 C1 E8 07 0F B7 4A 02 81 E1 80 7F 00 00 81 F9 80 7F 00 00 8B 04 85 ?? ?? ?? ?? 74 09 8B 54 24 08 89 02 33 C0 C3 F7 02 FF FF 7F 00 74 EF F3 0F 10 02 8B 44 24 08 F3 0F 58 C0 F3 0F 11 00 EB E3 8D 64 24 00 }
	condition:
		$1
}

rule file_93_0_0 {
	meta:
		name = "___common_sacos_cout_rare"
		size = 2672
		refs = "0040 __vmldACosHATab 09d5 _2il0floatpacket_192"
	strings:
		$1 = { 55 8B EC 83 E4 F8 56 57 53 83 EC 5C 8B 4D 08 0F B7 41 02 25 80 7F 00 00 F3 0F 10 11 3D 80 7F 00 00 0F 84 1A 0A 00 00 F3 0F 5A CA F2 0F 11 4C 24 40 80 64 24 47 7F F2 0F 10 64 24 40 F2 0F 10 05 ?? ?? ?? ?? 0F B7 05 ?? ?? ?? ?? 66 0F 2F C4 0F 86 75 09 00 00 F2 0F 10 0D ?? ?? ?? ?? 66 0F 2F CC 0F 86 42 04 00 00 66 0F 2F 25 ?? ?? ?? ?? 0F 86 D8 03 00 00 F2 0F 10 1D ?? ?? ?? ?? 0F 28 D4 F2 0F 59 D3 F2 0F 11 54 24 38 F2 0F 10 44 24 38 F2 0F 11 64 24 08 F2 0F 5C 44 24 40 F2 0F 11 44 24 30 0F 28 C4 F2 0F 10 54 24 38 F2 0F 10 6C 24 30 F2 0F 5C D5 F2 0F 11 54 24 38 0F 28 D4 F2 0F 10 7C 24 38 F2 0F 5C C7 F2 0F 10 3D ?? ?? ?? ?? F2 0F 11 44 24 30 F2 0F 10 44 24 38 0F 28 C8 F2 0F 58 D0 F2 0F 59 C8 F2 0F 10 74 24 30 0F 28 E9 F2 0F 59 D6 F2 0F 58 EA F2 0F 59 FD F2 0F 11 6C 24 10 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FD F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FD F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FD F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FD F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FD F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FD F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FD F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FD F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FD F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FD 0F 28 EB F2 0F 59 E9 F2 0F 58 3D ?? ?? ?? ?? F2 0F 11 6C 24 38 F2 0F 11 7C 24 18 F2 0F 10 7C 24 38 F2 0F 5C F9 F2 0F 11 7C 24 30 F2 0F 10 7C 24 38 F2 0F 10 6C 24 30 F2 0F 5C FD F2 0F 11 7C 24 38 F2 0F 10 6C 24 38 F2 0F 5C CD F2 0F 11 4C 24 30 F2 0F 10 4C 24 38 F2 0F 10 7C 24 30 F2 0F 59 F1 F2 0F 58 D7 F2 0F 59 C1 F2 0F 59 E2 F2 0F 58 E6 0F 28 F3 F2 0F 59 F0 F2 0F 11 74 24 38 F2 0F 10 6C 24 38 F2 0F 5C E8 F2 0F 11 6C 24 30 0F 28 E8 F2 0F 10 7C 24 38 F2 0F 58 C4 F2 0F 10 74 24 30 F2 0F 59 D0 F2 0F 5C FE F2 0F 11 7C 24 38 F2 0F 10 74 24 38 F2 0F 5C EE F2 0F 11 6C 24 30 0F 28 E9 F2 0F 10 74 24 38 F2 0F 59 EE F2 0F 59 DD F2 0F 10 7C 24 30 F2 0F 11 7C 24 20 F2 0F 58 FC F2 0F 11 5C 24 38 F2 0F 10 5C 24 38 F2 0F 59 CF F2 0F 5C DD F2 0F 11 5C 24 30 0F 28 DD F2 0F 10 7C 24 38 F2 0F 58 CA F2 0F 10 54 24 30 F2 0F 58 E9 F2 0F 5C FA F2 0F 11 7C 24 38 F2 0F 10 54 24 38 F2 0F 10 7C 24 18 F2 0F 5C DA F2 0F 11 5C 24 30 F2 0F 10 5C 24 38 F2 0F 10 54 24 30 F2 0F 11 54 24 28 F2 0F 10 54 24 10 F2 0F 59 D5 F2 0F 59 FA F2 0F 10 15 ?? ?? ?? ?? F2 0F 59 D0 F2 0F 10 05 ?? ?? ?? ?? F2 0F 59 C5 F2 0F 10 6C 24 08 F2 0F 58 D0 F2 0F 10 05 ?? ?? ?? ?? F2 0F 58 D7 F2 0F 59 E0 F2 0F 59 F0 F2 0F 58 D4 F2 0F 10 64 24 20 F2 0F 59 E0 0F 28 C5 F2 0F 58 C6 F2 0F 58 D4 F2 0F 11 44 24 38 F2 0F 10 64 24 38 F2 0F 11 34 24 F2 0F 5C EC F2 0F 10 3D ?? ?? ?? ?? F2 0F 58 EE F2 0F 59 CF F2 0F 59 DF F2 0F 59 7C 24 28 F2 0F 11 6C 24 30 F2 0F 10 64 24 38 F2 0F 10 74 24 30 F2 0F 58 D6 F2 0F 58 D1 0F 28 CC F2 0F 58 CB F2 0F 58 D7 F2 0F 11 4C 24 38 F2 0F 10 44 24 38 F2 0F 5C E0 F2 0F 58 E3 F2 0F 11 64 24 30 F3 0F 5A 09 F2 0F 10 44 24 38 F2 0F 10 5C 24 30 66 0F 2F 0D ?? ?? ?? ?? F2 0F 58 D3 76 47 F2 0F 10 25 ?? ?? ?? ?? 0F 28 CC F2 0F 5C C8 F2 0F 11 4C 24 38 F2 0F 10 5C 24 38 F2 0F 10 0D ?? ?? ?? ?? F2 0F 5C E3 F2 0F 5C CA F2 0F 5C E0 F2 0F 11 64 24 30 F2 0F 10 5C 24 38 F2 0F 10 44 24 30 F2 0F 58 C8 EB 45 F2 0F 10 25 ?? ?? ?? ?? 0F 28 C8 F2 0F 58 CC F2 0F 11 4C 24 38 F2 0F 10 5C 24 38 F2 0F 5C E3 F2 0F 58 E0 F2 0F 10 05 ?? ?? ?? ?? F2 0F 58 D0 F2 0F 11 64 24 30 F2 0F 10 5C 24 38 F2 0F 10 4C 24 30 F2 0F 58 CA 8B 45 0C F2 0F 58 D9 F2 0F 5A DB F3 0F 11 18 33 C0 83 C4 5C 5B 5F 5E 8B E5 5D C3 F2 0F 10 0D ?? ?? ?? ?? F2 0F 58 C4 F2 0F 11 44 24 38 F2 0F 10 44 24 38 F2 0F 59 44 24 40 F2 0F 11 04 24 0F B6 44 24 07 0F B6 49 03 83 E0 7F 83 E1 80 0B C1 88 44 24 07 33 C0 8B 55 0C F2 0F 5C 0C 24 F2 0F 58 0D ?? ?? ?? ?? F2 0F 5A C9 F3 0F 11 0A 83 C4 5C 5B 5F 5E 8B E5 5D C3 0F 28 D8 8B F0 81 E6 0F 80 FF FF 25 0F 80 FF FF F2 0F 11 44 24 08 F2 0F 5C DC F2 0F 59 CB F2 0F 11 0C 24 0F B7 54 24 06 81 E2 F0 7F 00 00 C1 EA 04 81 C2 01 FC FF FF 8B DA F7 DB 81 C3 FF 03 00 00 81 E3 FF 07 00 00 C1 E3 04 0B F3 66 89 74 24 0E 8B F2 F2 0F 59 4C 24 08 83 E6 01 0F 28 E9 8B FE F2 0F 10 35 ?? ?? ?? ?? F2 0F 58 E9 75 03 0F 28 E9 F2 0F 59 F5 F2 0F 58 0D ?? ?? ?? ?? F2 0F 11 4C 24 10 0F 28 FE 8B 5C 24 10 2B D6 C1 E7 08 81 E3 FF 01 00 00 03 DF F2 0F 5C FD F2 0F 11 7C 24 30 F2 0F 10 64 24 30 F2 0F 10 14 DD ?? ?? ?? ?? F2 0F 5C F4 0F 28 FA 0F 28 E5 F2 0F 59 FA 0F 28 CE F2 0F 5C E6 F2 0F 59 F2 F2 0F 59 CF F2 0F 59 FC F2 0F 5C C8 D1 EA F2 0F 58 CF F2 0F 10 3D ?? ?? ?? ?? 81 C2 FF 03 00 00 F2 0F 59 F9 81 E2 FF 07 00 00 C1 E2 04 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 F9 0B C2 F2 0F 11 44 24 18 66 89 44 24 1E F2 0F 10 44 24 18 F2 0F 59 F0 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 F9 F2 0F 11 5C 24 20 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 F9 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 F9 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 F9 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 F9 F2 0F 59 FA F2 0F 59 D4 F2 0F 59 FD F2 0F 58 FA F2 0F 10 15 ?? ?? ?? ?? 0F 28 EA F2 0F 59 EE F2 0F 59 F8 F2 0F 11 6C 24 38 F2 0F 10 44 24 38 F2 0F 10 2D ?? ?? ?? ?? F2 0F 5C C6 F2 0F 58 2D ?? ?? ?? ?? F2 0F 11 44 24 30 F2 0F 10 64 24 38 F2 0F 10 4C 24 30 F2 0F 5C E1 F2 0F 10 0D ?? ?? ?? ?? F2 0F 11 64 24 38 F2 0F 10 44 24 38 F2 0F 10 25 ?? ?? ?? ?? F2 0F 5C F0 F2 0F 58 25 ?? ?? ?? ?? F2 0F 11 74 24 30 F2 0F 10 74 24 38 F2 0F 10 44 24 30 F2 0F 11 74 24 28 0F 28 F1 F2 0F 59 E3 F2 0F 58 F8 F2 0F 58 35 ?? ?? ?? ?? F2 0F 10 05 ?? ?? ?? ?? F2 0F 58 F4 F2 0F 59 C3 F2 0F 59 F3 F2 0F 58 05 ?? ?? ?? ?? F2 0F 58 EE F2 0F 59 C3 0F 28 E3 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C3 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C3 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C3 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C3 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C3 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C3 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C3 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C3 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C3 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C3 F2 0F 59 C3 F2 0F 59 C3 F2 0F 11 44 24 40 F2 0F 58 E8 F2 0F 59 FD F2 0F 11 7C 24 48 0F 28 FA F2 0F 59 FB F2 0F 11 7C 24 38 F2 0F 10 44 24 38 F2 0F 5C C3 F2 0F 11 44 24 30 F2 0F 10 74 24 38 F2 0F 10 6C 24 30 F2 0F 5C F5 F2 0F 11 74 24 38 F2 0F 10 7C 24 38 F2 0F 5C E7 F2 0F 11 64 24 30 F2 0F 10 64 24 38 0F 28 EC 0F 28 C4 F2 0F 59 EC F2 0F 58 C3 F2 0F 59 E1 0F 28 DA F2 0F 59 DD F2 0F 10 7C 24 30 F2 0F 11 5C 24 38 F2 0F 10 74 24 38 F2 0F 59 CF F2 0F 5C F5 F2 0F 59 C7 F2 0F 11 74 24 30 F2 0F 10 74 24 38 F2 0F 10 5C 24 30 F2 0F 5C F3 F2 0F 11 74 24 38 F2 0F 10 5C 24 38 F2 0F 5C EB 0F 28 DC F2 0F 11 6C 24 30 F2 0F 10 74 24 38 F2 0F 59 35 ?? ?? ?? ?? F2 0F 10 6C 24 30 F2 0F 58 DE F2 0F 11 5C 24 38 F2 0F 11 6C 24 50 F2 0F 10 6C 24 38 F2 0F 11 74 24 10 F2 0F 5C E5 F2 0F 10 2D ?? ?? ?? ?? F2 0F 58 E6 F2 0F 11 64 24 30 0F 28 E5 F2 0F 10 5C 24 38 F2 0F 10 74 24 30 F2 0F 58 E3 F2 0F 11 64 24 38 F2 0F 10 64 24 38 F2 0F 5C EC F2 0F 58 EB F2 0F 11 6C 24 30 F2 0F 10 64 24 38 F2 0F 59 D4 F2 0F 10 5C 24 30 F2 0F 11 54 24 38 F2 0F 10 54 24 38 F2 0F 5C D4 F2 0F 11 54 24 30 F2 0F 10 54 24 38 F2 0F 10 6C 24 30 F2 0F 5C D5 F2 0F 11 54 24 38 F2 0F 10 6C 24 38 F2 0F 5C E5 F2 0F 11 64 24 30 F2 0F 10 6C 24 38 F2 0F 10 54 24 30 F2 0F 10 25 ?? ?? ?? ?? F2 0F 58 D6 F3 0F 5A 31 F2 0F 58 D3 66 0F 2F 35 ?? ?? ?? ?? F2 0F 58 D1 F2 0F 10 5C 24 20 F2 0F 59 E3 F2 0F 10 4C 24 50 F2 0F 58 C8 F2 0F 10 44 24 28 F2 0F 58 25 ?? ?? ?? ?? F2 0F 59 0D ?? ?? ?? ?? F2 0F 59 E3 F2 0F 58 D1 F2 0F 58 25 ?? ?? ?? ?? F2 0F 59 D0 F2 0F 58 64 24 40 F2 0F 10 4C 24 48 F2 0F 59 E0 F2 0F 58 CA F2 0F 59 C5 F2 0F 58 CC 77 4D F2 0F 10 25 ?? ?? ?? ?? 0F 28 D4 F2 0F 10 35 ?? ?? ?? ?? F2 0F 5C D0 F2 0F 5C F1 F2 0F 11 54 24 38 F2 0F 10 5C 24 38 F2 0F 11 04 24 F2 0F 5C E3 F2 0F 5C E0 F2 0F 11 64 24 30 F2 0F 10 44 24 38 F2 0F 10 6C 24 30 0F 28 CD F2 0F 58 CE 8B 45 0C F2 0F 58 C1 F2 0F 5A C0 F3 0F 11 00 33 C0 83 C4 5C 5B 5F 5E 8B E5 5D C3 66 0F 2E C8 7A 02 74 54 0F 57 05 ?? ?? ?? ?? 66 0F 2E C8 7A 02 74 1E 8B 45 0C F3 0F 5C D2 F3 0F 5E D2 F3 0F 11 10 B8 01 00 00 00 83 C4 5C 5B 5F 5E 8B E5 5D C3 F2 0F 10 05 ?? ?? ?? ?? 8B 45 0C F2 0F 58 05 ?? ?? ?? ?? F2 0F 5A C0 F3 0F 11 00 33 C0 83 C4 5C 5B 5F 5E 8B E5 5D C3 F2 0F 5A 05 ?? ?? ?? ?? 8B 45 0C F3 0F 11 00 33 C0 83 C4 5C 5B 5F 5E 8B E5 5D C3 F3 0F 5E D2 8B 45 0C BA 01 00 00 00 F3 0F 11 10 33 C0 F7 01 FF FF 7F 00 0F 44 C2 83 C4 5C 5B 5F 5E 8B E5 5D C3 8D A4 24 00 00 00 00 8D 49 00 }
	condition:
		$1
}

rule file_95_0_0 {
	meta:
		name = "@__mpx_init_static_rep@8"
		size = 183
	strings:
		$1 = { 55 8B EC 83 EC 28 89 55 EC 89 4D FC F3 0F 1B 05 FF FF FF FF 66 0F 1B 45 D8 83 7D FC 00 F2 75 06 F2 E9 8D 00 00 00 8B 45 EC 89 45 F8 EB 09 8B 4D F8 83 E9 01 89 4D F8 83 7D F8 00 F2 76 75 8B 55 FC 8B 45 FC 8B 4A 08 2B 48 04 89 4D E8 8B 55 FC 83 C2 04 89 55 F4 8B 45 F4 8B 08 8B 55 F4 8B 02 8B 55 E8 83 EA 01 F3 0F 1B 04 10 66 0F 1B 45 D8 89 4D F0 8B 45 FC 8B 08 89 4D E4 8B 55 E4 8B 02 66 0F 1A 45 D8 66 0F 1B 45 D8 89 45 F0 8B 4D FC 89 4D E0 8B 55 E0 8B 02 8B 4D F0 66 0F 1A 45 D8 0F 1B 04 08 8B 55 FC 83 C2 0C 89 55 FC F2 E9 7B FF FF FF 8B E5 5D C3 }
	condition:
		$1
}

rule file_96_0_0 {
	meta:
		name = "___avx_tan4"
		size = 2736
		refs = "0012 ___common_dtan_data 0176 ___common_dtan_cout_rare 01f6 ___common_dtan_reduction_data 0287 _2il0floatpacket_355 028f _2il0floatpacket_356 029f _2il0floatpacket_357 0624 _2il0floatpacket_358 065f _2il0floatpacket_359 0673 _2il0floatpacket_361 0685 _2il0floatpacket_362 06cf _2il0floatpacket_363 06e5 _2il0floatpacket_364 0744 _2il0floatpacket_368 0755 _2il0floatpacket_365 075e _2il0floatpacket_366 0767 _2il0floatpacket_367 07a1 _2il0floatpacket_369 07ae _2il0floatpacket_370 07d0 _2il0floatpacket_360 07dc _2il0floatpacket_371"
	strings:
		$1 = { 55 8B EC 83 E4 C0 57 53 81 EC 38 03 00 00 C5 FD 10 0D ?? ?? ?? ?? C5 FD 54 E1 C5 DD C2 1D ?? ?? ?? ?? 1E C5 F5 55 C8 C4 E3 7D 19 DD 01 C5 E0 C6 F5 DD C5 F8 50 C6 85 C0 0F 85 41 01 00 00 C5 FD 10 1D ?? ?? ?? ?? 33 DB C5 DD 59 2D ?? ?? ?? ?? C5 D5 58 F3 C5 CD 5C DB C5 E5 59 2D ?? ?? ?? ?? C5 DD 5C E5 C5 E5 59 2D ?? ?? ?? ?? C5 DD 5C E5 C5 E5 59 2D ?? ?? ?? ?? C5 DD 5C E5 C5 E5 59 2D ?? ?? ?? ?? C5 DD 5C DD C5 E5 59 D3 C5 D9 73 F6 3F C4 E3 7D 19 F5 01 C5 C1 73 F5 3F C5 D1 73 F5 3E C4 E3 5D 18 E7 01 C5 DD 57 E1 C5 F1 73 F6 3E C5 C5 57 FF C4 E3 75 18 F5 01 C5 ED 59 2D ?? ?? ?? ?? C5 CD C2 CF 0C C5 ED 59 35 ?? ?? ?? ?? C5 D5 58 2D ?? ?? ?? ?? C5 CD 58 3D ?? ?? ?? ?? C5 D5 59 F2 C5 C5 59 FA C5 CD 58 35 ?? ?? ?? ?? C5 C5 58 2D ?? ?? ?? ?? C5 CD 59 F2 C5 D5 59 EA C5 CD 58 3D ?? ?? ?? ?? C5 D5 58 35 ?? ?? ?? ?? C5 C5 59 FB C5 F5 55 EF C5 F5 54 DE C5 D5 56 EB C5 F5 54 DF C5 F5 55 CE C5 E5 56 C9 C5 D5 5E C9 C5 F5 57 CC 85 DB 75 10 C5 FD 28 C1 81 C4 38 03 00 00 5B 5F 8B E5 5D C3 C5 FD 11 04 24 C5 FD 11 4C 24 40 74 E3 33 FF 0F A3 FB 72 0E 47 83 FF 20 7C F5 C5 FD 10 4C 24 40 EB CE C5 F8 77 8D 44 FC 40 8D 14 FC 50 52 E8 ?? ?? ?? ?? 83 C4 08 EB DC C5 FD 10 0D ?? ?? ?? ?? B8 00 00 F0 7F C5 FD 11 04 24 C5 F9 6E F8 C5 F9 70 F7 11 C5 F5 54 E4 C5 DD C2 D9 00 C4 E3 7D 19 DC 01 C5 E0 C6 EC DD C5 F8 50 DD C4 E3 7D 19 C5 01 C5 C9 DB DD C5 F8 11 AC 24 30 01 00 00 C5 F8 28 D0 C5 C9 DB CA C5 D9 73 D1 34 C5 F1 73 D3 34 C5 F9 7E E7 C5 F9 7E C8 C5 F8 11 94 24 20 01 00 00 C4 E3 79 16 E1 02 8D 14 7F C5 FA 7E 1C D5 ?? ?? ?? ?? 8D 3C 40 C4 E3 79 16 C8 02 C5 FA 7E 24 FD ?? ?? ?? ?? 8D 0C 49 C5 E1 16 3C CD ?? ?? ?? ?? C5 FA 7E 1C FD ?? ?? ?? ?? 8D 04 40 C5 E1 16 34 C5 ?? ?? ?? ?? C5 FA 7E 1C D5 ?? ?? ?? ?? C5 E1 16 04 CD ?? ?? ?? ?? C5 FA 7E 1C D5 ?? ?? ?? ?? BA 00 00 00 80 C5 D9 16 0C C5 ?? ?? ?? ?? C5 E1 16 24 CD ?? ?? ?? ?? C5 FA 7E 1C FD ?? ?? ?? ?? C5 F9 11 A4 24 60 01 00 00 C5 E1 16 24 C5 ?? ?? ?? ?? C5 F9 11 A4 24 70 01 00 00 C5 FA 6F 25 ?? ?? ?? ?? C5 FA 6F 1D ?? ?? ?? ?? C5 D9 DB D2 C5 D9 DB ED C5 FA 6F 25 ?? ?? ?? ?? C5 F9 11 BC 24 40 01 00 00 C5 E9 D4 D3 C5 D1 D4 DB C5 C1 DB EC C5 C1 73 D0 20 C5 FA 7F BC 24 A0 01 00 00 C5 C1 73 D1 20 C5 F1 DB CC C5 F9 DB C4 C5 FA 7F 8C 24 D0 01 00 00 C5 F9 10 8C 24 60 01 00 00 C5 F1 73 D1 20 C5 FA 7F 8C 24 E0 01 00 00 C5 F9 10 8C 24 70 01 00 00 C5 F1 73 D1 20 C5 FA 7F 8C 24 F0 01 00 00 C5 F1 73 D2 20 C5 E9 DB D4 C5 FA 7F AC 24 80 01 00 00 C5 E9 F4 ED C5 F9 11 B4 24 50 01 00 00 C5 C9 DB F4 C5 FA 7F 8C 24 00 02 00 00 C5 F1 73 D3 20 C5 E1 DB DC C5 FA 7F B4 24 90 01 00 00 C5 FA 7F AC 24 30 02 00 00 C5 E1 F4 F6 C5 E9 F4 AC 24 A0 01 00 00 C5 FA 7F BC 24 B0 01 00 00 C5 E1 F4 FF C5 FA 7F 84 24 C0 01 00 00 C5 FA 7F B4 24 40 02 00 00 C5 FA 7F AC 24 50 02 00 00 C5 E9 F4 E8 C5 D9 DB B4 24 60 01 00 00 C5 FA 6F 84 24 00 02 00 00 C5 FA 7F BC 24 60 02 00 00 C5 F9 F4 FE C5 C9 73 D7 20 C5 FA 6F BC 24 E0 01 00 00 C5 FA 7F 94 24 10 02 00 00 C5 E9 F4 D7 C5 F9 F4 C7 C5 C1 73 D2 20 C5 F9 D4 C7 C5 FA 7F AC 24 70 02 00 00 C5 D1 DB EC C5 D1 D4 E8 C5 D9 DB 84 24 70 01 00 00 C5 C9 D4 FD C5 F1 F4 F0 C5 FA 6F 94 24 F0 01 00 00 C5 D1 73 D6 20 C5 FA 7F 9C 24 20 02 00 00 C5 E9 F4 B4 24 20 02 00 00 C5 F1 F4 C2 C5 E1 F4 9C 24 D0 01 00 00 C5 E9 73 D6 20 C5 F9 D4 C2 C5 FA 7F 9C 24 80 02 00 00 C5 E1 DB DC C5 E1 D4 D8 C5 FA 6F 84 24 00 02 00 00 C5 D1 D4 D3 C5 F9 F4 9C 24 C0 01 00 00 C5 FA 6F B4 24 70 02 00 00 C5 C9 73 D6 20 C5 E1 D4 DE C5 D9 DB AC 24 50 02 00 00 C5 D1 D4 EB C5 FA 7F BC 24 90 02 00 00 C5 C1 73 D7 20 C5 C1 D4 FD C5 F1 F4 AC 24 D0 01 00 00 C5 FA 6F 9C 24 80 02 00 00 C5 E1 73 D3 20 C5 D1 D4 EB C5 D9 DB B4 24 60 02 00 00 C5 C9 D4 F5 C5 FA 7F 94 24 A0 02 00 00 C5 E9 73 D2 20 C5 E9 D4 EE C5 F9 F4 B4 24 A0 01 00 00 C5 FA 6F 94 24 50 02 00 00 C5 E9 73 D2 20 C5 C9 D4 F2 C5 F1 F4 94 24 B0 01 00 00 C5 D9 DB 9C 24 30 02 00 00 C5 E1 D4 DE C5 FA 7F BC 24 B0 02 00 00 C5 C1 73 D7 20 C5 C1 D4 F3 C5 FA 6F BC 24 60 02 00 00 C5 C1 73 D7 20 C5 E9 D4 D7 C5 D9 DB 9C 24 40 02 00 00 C5 C1 73 D6 20 C5 E1 D4 DA C5 FA 7F AC 24 C0 02 00 00 C5 D1 73 D5 20 C5 D1 D4 D3 C5 F9 10 AC 24 40 01 00 00 C5 C9 DB F4 C5 E1 73 D5 20 C5 E1 F4 AC 24 10 02 00 00 C5 F9 F4 9C 24 80 01 00 00 C5 FA 6F 84 24 30 02 00 00 C5 D1 DB EC C5 F9 73 D0 20 C5 E1 D4 D8 C5 D1 D4 EB C5 C1 D4 FD C5 F9 10 AC 24 50 01 00 00 C5 E1 73 F7 20 C5 F9 73 D5 20 C5 C1 73 D2 20 C5 E1 D4 DE C5 F9 F4 B4 24 20 02 00 00 C5 F1 F4 84 24 90 01 00 00 C5 FA 6F 8C 24 40 02 00 00 C5 C9 DB EC C5 F1 73 D1 20 C5 E9 DB D4 C5 F9 D4 F1 C5 D1 D4 EE C5 C1 D4 FD C5 D1 73 F7 20 C5 FA 6F B4 24 C0 02 00 00 C5 D1 D4 CA C5 FA 6F AC 24 B0 02 00 00 C5 E9 73 F6 20 C5 D9 DB BC 24 90 02 00 00 C5 F9 73 F5 20 C5 D9 DB A4 24 A0 02 00 00 C5 F9 D4 EF C5 E9 D4 FC C5 F9 6E E2 C5 F9 70 C4 11 C5 F9 DB A4 24 20 01 00 00 C5 F9 DB B4 24 30 01 00 00 C5 FA 6F 05 ?? ?? ?? ?? C5 FA 7F 9C 24 D0 02 00 00 C5 E1 73 D3 0C C5 D9 EF D0 C5 C9 EF C0 C5 FA 7F 8C 24 E0 02 00 00 C5 F1 73 D1 0C C5 E1 EB DA C5 F1 EB C8 C4 E3 65 18 C1 01 C4 E2 7D 1A 15 ?? ?? ?? ?? C5 ED 58 D8 C5 E5 5C CA C5 FD 5C D1 C5 FA 6F 05 ?? ?? ?? ?? C5 C9 EF C8 C5 FD 11 54 24 20 C5 FA 6F 15 ?? ?? ?? ?? C5 F8 11 9C 24 F0 02 00 00 C4 E3 7D 19 9C 24 00 03 00 00 01 C5 D9 EF D8 C5 E9 DB C5 C5 E9 DB D7 C5 F9 73 F0 1C C5 E9 73 F2 1C C5 F9 EB C3 C5 E9 EB D1 C5 D1 73 D5 18 C5 C1 73 D7 18 C4 E3 65 18 C9 01 C5 FA 6F 1D ?? ?? ?? ?? C4 E3 7D 18 D2 01 C5 D9 EF C3 C5 C9 EF DB C5 FA 6F 35 ?? ?? ?? ?? C5 C9 DB A4 24 D0 02 00 00 C5 C9 DB B4 24 E0 02 00 00 C5 D9 73 F4 28 C5 D9 EB E5 C5 D1 73 F6 28 C5 D1 EB EF C5 D9 EB E0 C5 D1 EB FB C5 ED 5C D1 C5 FD 10 4C 24 20 C4 E3 5D 18 E7 01 C4 E3 7D 18 DB 01 C5 DD 5C F3 C5 F5 58 C6 C5 F5 5C D8 C5 CD 58 E3 C5 DD 58 F2 C4 E2 7D 1A 15 ?? ?? ?? ?? C5 FD 54 FA C5 FD 5C C7 C4 E2 7D 1A 2D ?? ?? ?? ?? C4 E2 7D 1A 1D ?? ?? ?? ?? C4 E2 7D 1A 25 ?? ?? ?? ?? C5 E5 59 D7 C5 E5 59 C8 C5 DD 59 FF C5 D5 59 EE C5 DD 59 C0 C5 F5 58 FF C5 D5 58 C8 C5 C5 58 F1 C5 FD 10 0C 24 C5 ED 58 EE C5 ED 5C DD C5 E5 58 DE C4 E2 7D 1A 25 ?? ?? ?? ?? C5 F5 54 D4 C4 E2 7D 1A 05 ?? ?? ?? ?? C5 ED C2 E0 1E C5 ED C2 F8 12 C5 C5 54 F1 C5 DD 54 ED C5 CD 56 D5 C5 DD 54 DB C5 FA 6F 2D ?? ?? ?? ?? C5 ED 58 E3 C5 FA 6F 3D ?? ?? ?? ?? C5 D1 DB 9C 24 F0 02 00 00 C5 D1 DB 84 24 00 03 00 00 C5 E1 DB CF C5 F9 DB DF C5 F9 7E CF C5 F9 7E D8 6B CF 68 6B C0 68 C5 FA 7E B1 ?? ?? ?? ?? C4 E3 79 16 CA 02 C4 E3 79 16 DF 02 6B D2 68 6B FF 68 C5 FA 7E A8 ?? ?? ?? ?? C5 FA 7E B9 ?? ?? ?? ?? C5 C9 16 92 ?? ?? ?? ?? C5 FA 7E B0 ?? ?? ?? ?? C5 D1 16 87 ?? ?? ?? ?? C5 C1 16 8A ?? ?? ?? ?? C5 FA 7E A9 ?? ?? ?? ?? C5 C9 16 9F ?? ?? ?? ?? C5 FA 7E B8 ?? ?? ?? ?? C4 E3 6D 18 D0 01 C5 D1 16 82 ?? ?? ?? ?? C5 FA 7E A9 ?? ?? ?? ?? C4 E3 75 18 F3 01 C5 C1 16 9F ?? ?? ?? ?? C5 D1 16 BA ?? ?? ?? ?? C4 E3 7D 18 CB 01 C5 FA 7E 98 ?? ?? ?? ?? C5 E1 16 AF ?? ?? ?? ?? C5 FA 7E 81 ?? ?? ?? ?? C5 F9 16 9A ?? ?? ?? ?? C4 E3 45 18 FD 01 C5 FA 7E A8 ?? ?? ?? ?? C5 D1 16 87 ?? ?? ?? ?? C5 FA 7E A9 ?? ?? ?? ?? C4 E3 65 18 D8 01 C5 FC 11 5C 24 40 C5 FA 7E 98 ?? ?? ?? ?? C5 D1 16 82 ?? ?? ?? ?? C5 E1 16 AF ?? ?? ?? ?? C4 E3 7D 18 DD 01 C5 FC 11 5C 24 60 C5 FA 7E A9 ?? ?? ?? ?? C5 FA 7E 98 ?? ?? ?? ?? C5 D1 16 82 ?? ?? ?? ?? C5 E1 16 AF ?? ?? ?? ?? C4 E3 7D 18 DD 01 C5 FC 11 9C 24 80 00 00 00 C5 FA 7E A9 ?? ?? ?? ?? C5 FA 7E 98 ?? ?? ?? ?? C5 D1 16 82 ?? ?? ?? ?? C5 E1 16 AF ?? ?? ?? ?? C4 E3 7D 18 DD 01 C5 FC 11 9C 24 A0 00 00 00 C5 FA 7E A9 ?? ?? ?? ?? C5 FA 7E 98 ?? ?? ?? ?? C5 D1 16 82 ?? ?? ?? ?? C5 E1 16 AF ?? ?? ?? ?? C4 E3 7D 18 DD 01 C5 FC 11 9C 24 C0 00 00 00 C5 FA 7E A9 ?? ?? ?? ?? C5 FA 7E 98 ?? ?? ?? ?? C5 D1 16 82 ?? ?? ?? ?? C5 E1 16 AF ?? ?? ?? ?? C4 E3 7D 18 DD 01 C5 FC 11 9C 24 E0 00 00 00 C5 FA 7E A9 ?? ?? ?? ?? C5 FA 7E 98 ?? ?? ?? ?? C5 D1 16 82 ?? ?? ?? ?? C5 E1 16 AF ?? ?? ?? ?? C4 E3 7D 18 DD 01 C5 ED 5C C4 C5 FC 11 9C 24 00 01 00 00 C5 FD 5A D0 C5 F8 53 DA C5 FC 5A EB C5 FD 59 C5 C4 E2 7D 1A 15 ?? ?? ?? ?? C5 ED 5C D8 C5 E5 59 C3 C5 D5 59 D0 C5 FD 58 DB C5 ED 58 C5 C5 DD 59 94 24 E0 00 00 00 C5 FD 59 DB C5 DD 59 84 24 A0 00 00 00 C5 ED 58 94 24 C0 00 00 00 C5 E5 58 DD C5 C5 59 EC C5 E5 59 F6 C5 D5 58 F9 C5 DD 59 CC C5 DD 59 6C 24 60 C5 CD 58 DF C5 FD 58 B4 24 80 00 00 00 C5 D5 58 7C 24 40 C5 F5 59 84 24 00 01 00 00 C5 F5 59 E9 C5 CD 59 C9 C5 FD 58 C2 C5 F5 58 CF C5 FD 59 F5 C5 CD 58 C1 C5 FD 59 E4 C5 FD 10 04 24 C5 DD 58 CB E9 8E F6 FF FF 8D A4 24 00 00 00 00 8D 64 24 00 }
	condition:
		$1
}

rule file_101_0_0 {
	meta:
		name = "___sse2_tanh2"
		size = 656
		refs = "0016 _static_const_table"
	strings:
		$1 = { 8B C4 81 EC C0 00 00 00 83 E4 F0 89 84 24 84 00 00 00 66 0F 28 3D ?? ?? ?? ?? 66 0F 28 C8 89 4C 24 60 66 0F 28 15 ?? ?? ?? ?? 66 0F 54 C7 89 74 24 64 66 0F 28 1D ?? ?? ?? ?? 66 0F 59 D0 66 0F 54 F9 66 0F 28 25 ?? ?? ?? ?? 66 0F 58 D3 66 0F 28 2D ?? ?? ?? ?? 66 0F 28 F2 66 0F 29 4C 24 50 66 0F 5C D3 8D 44 24 50 66 0F 28 CE 66 0F 59 E2 66 0F 57 DB 66 0F C2 3D ?? ?? ?? ?? 05 66 0F 73 F6 04 66 0F 29 4C 24 40 66 0F 59 EA 66 0F FB D9 66 0F 5C C4 66 0F 7E F6 89 7C 24 68 66 0F 5C C5 66 0F 50 CF 66 0F FE 0D ?? ?? ?? ?? 81 E6 F0 03 00 00 66 0F 15 F6 66 0F FE 1D ?? ?? ?? ?? 66 0F 73 F1 2E 66 0F 7E F7 66 0F 28 BE ?? ?? ?? ?? 81 E7 F0 03 00 00 66 0F 73 F3 2E 66 0F 29 44 24 30 F7 DE 66 0F 28 B7 ?? ?? ?? ?? 81 C6 00 04 00 00 66 0F DB 0D ?? ?? ?? ?? 66 0F 28 EF F7 DF 66 0F DB 1D ?? ?? ?? ?? 66 0F C6 EE 00 81 C7 00 04 00 00 66 0F 28 A6 ?? ?? ?? ?? 66 0F C6 FE 03 66 0F 28 97 ?? ?? ?? ?? 66 0F 59 E9 66 0F 28 F4 66 0F 59 F9 66 0F C6 E2 00 66 0F 29 2C 24 66 0F 28 C8 66 0F C6 F2 03 66 0F 59 E3 66 0F 28 15 ?? ?? ?? ?? 66 0F 59 C0 66 0F 29 64 24 20 66 0F 59 F3 66 0F 58 EF 66 0F 28 1D ?? ?? ?? ?? 83 F9 03 66 0F 59 D0 66 0F 58 E6 0F 84 C8 00 00 00 66 0F 29 7C 24 10 66 0F 59 D8 66 0F 58 15 ?? ?? ?? ?? 66 0F 28 FD 66 0F 58 1D ?? ?? ?? ?? 66 0F 59 D0 66 0F 58 EC 66 0F 59 C3 66 0F 5C FC 66 0F 59 D1 66 0F 28 D8 66 0F 58 D1 66 0F 59 DD 66 0F 28 CA 66 0F 59 D7 66 0F 28 20 66 0F 59 C7 66 0F 58 DA 66 0F 59 CD 66 0F 28 7C 24 10 66 0F 58 DE 66 0F 28 6C 24 20 66 0F 58 DF 66 0F 5C F7 66 0F 28 14 24 66 0F 58 DD 66 0F 5C C6 66 0F 54 25 ?? ?? ?? ?? 66 0F 58 DA 66 0F 5C EA 66 0F 58 C1 8B 74 24 64 66 0F 5C C5 8B 7C 24 68 66 0F 5E C3 83 F9 01 66 0F 56 C4 7D 08 8B 4C 24 60 EB 5B 8B FF 7F 0A 66 0F 28 3D ?? ?? ?? ?? EB 10 66 0F 28 3D ?? ?? ?? ?? EB 06 8B FF 66 0F 57 FF 66 0F 28 08 66 0F 54 C7 66 0F 28 15 ?? ?? ?? ?? 66 0F 57 DB 66 0F 54 D1 66 0F 55 3D ?? ?? ?? ?? 66 0F C2 D9 03 8B 4C 24 60 66 0F 56 C7 8B 74 24 64 66 0F 56 C2 8B 7C 24 68 66 0F 56 C3 8B A4 24 84 00 00 00 C3 8D 49 00 }
	condition:
		$1
}

rule file_102_0_0 {
	meta:
		name = "___common_dlog10_cout_rare"
		size = 736
		refs = "003a __vmldLgHATab 006a _2il0floatpacket_78 026f _2il0floatpacket_79"
	strings:
		$1 = { 55 8B EC 83 E4 F8 83 EC 18 8B 45 08 0F B7 48 06 8B D1 81 E2 F0 7F 00 00 81 FA F0 7F 00 00 0F 84 63 02 00 00 F2 0F 10 18 F7 C1 F0 7F 00 00 F2 0F 11 5C 24 10 75 19 F2 0F 10 05 ?? ?? ?? ?? BA C4 FF FF FF F2 0F 59 D8 F2 0F 11 5C 24 10 EB 02 33 D2 F2 0F 10 05 ?? ?? ?? ?? 66 0F 2F D8 0F 86 E5 01 00 00 0F 28 CB F2 0F 5C 0D ?? ?? ?? ?? F2 0F 11 4C 24 08 80 64 24 0F 7F F2 0F 10 44 24 08 66 0F 2F 05 ?? ?? ?? ?? 0F 86 42 01 00 00 F2 0F 11 5C 24 08 0F B7 4C 24 0E 81 E1 0F 80 FF FF 81 C9 F0 3F FF FF 66 89 4C 24 0E F2 0F 10 6C 24 08 0F 28 DD 0F 28 E5 0F B7 44 24 16 25 F0 7F 00 00 F2 0F 58 1D ?? ?? ?? ?? F2 0F 58 25 ?? ?? ?? ?? C1 E8 04 F2 0F 11 1C 24 F2 0F 10 0D ?? ?? ?? ?? 8B 4D 0C 8D 94 02 01 FC FF FF 8B 04 24 F2 0F 11 24 24 83 E0 7F F2 0F 10 1C 24 F2 0F 2A D2 F2 0F 5C 1D ?? ?? ?? ?? F2 0F 59 CA F2 0F 5C EB F2 0F 59 15 ?? ?? ?? ?? 8D 14 40 33 C0 F2 0F 10 04 D5 ?? ?? ?? ?? F2 0F 59 D8 F2 0F 58 14 D5 ?? ?? ?? ?? F2 0F 58 0C D5 ?? ?? ?? ?? F2 0F 59 C5 F2 0F 5C 1D ?? ?? ?? ?? 0F 28 F3 0F 28 F8 F2 0F 10 2D ?? ?? ?? ?? F2 0F 58 F0 F2 0F 58 CB F2 0F 59 EE F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 EE F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 EE F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 EE F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 EE F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 EE F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 EE F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 FD F2 0F 59 DD F2 0F 58 D7 F2 0F 58 C2 F2 0F 58 C3 F2 0F 58 C8 F2 0F 11 09 8B E5 5D C3 F2 0F 59 0D ?? ?? ?? ?? F2 0F 10 05 ?? ?? ?? ?? F2 0F 59 C1 8B 45 0C F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C1 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C1 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C1 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C1 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C1 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C1 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C1 F2 0F 58 C8 F2 0F 11 08 33 C0 8B E5 5D C3 66 0F 2E D8 7A 02 74 14 F2 0F 5E C0 8B 45 0C F2 0F 11 00 B8 01 00 00 00 8B E5 5D C3 F2 0F 10 0D ?? ?? ?? ?? 0F 57 0D ?? ?? ?? ?? F2 0F 5E C8 8B 45 0C F2 0F 11 08 B8 02 00 00 00 8B E5 5D C3 0F B6 50 07 F7 C2 80 00 00 00 75 15 F2 0F 10 00 F2 0F 59 C0 8B 45 0C F2 0F 11 00 33 C0 8B E5 5D C3 F7 40 04 FF FF 0F 00 75 E2 83 38 00 75 DD F2 0F 10 05 ?? ?? ?? ?? F2 0F 5E C0 8B 45 0C F2 0F 11 00 B8 01 00 00 00 8B E5 5D C3 8D A4 24 00 00 00 00 8D A4 24 00 00 00 00 }
	condition:
		$1
}

rule file_104_0_0 {
	meta:
		name = "___avx_pow4"
		size = 1024
		refs = "0026 ___common_dpow_data 03f3 ___common_dpow_cout_rare"
	strings:
		$1 = { 55 8B EC 83 E4 C0 81 EC 00 01 00 00 C5 FD 11 04 24 C5 FD 11 4C 24 20 C4 E3 7D 19 C2 01 C5 F8 C6 EA DD C5 FD 54 25 ?? ?? ?? ?? C5 DD 56 15 ?? ?? ?? ?? C5 F8 11 AC 24 C0 00 00 00 C4 E3 7D 19 CB 01 C5 F0 C6 F3 DD C5 D0 54 1D ?? ?? ?? ?? C5 C9 DB 3D ?? ?? ?? ?? C5 E1 FE 35 ?? ?? ?? ?? C5 FA 7F BC 24 D0 00 00 00 C5 C1 72 D6 0A C5 F1 72 F7 03 C5 F9 72 F7 04 C5 F9 7E C8 C5 D1 FA 2D ?? ?? ?? ?? C5 D1 72 E5 14 C4 E3 79 16 CA 01 C4 E3 79 16 C9 02 C5 FB 10 A0 ?? ?? ?? ?? C4 E3 79 16 C8 03 C5 D9 16 9A ?? ?? ?? ?? C5 F9 7E C2 C5 FB 10 B1 ?? ?? ?? ?? C5 C9 16 88 ?? ?? ?? ?? C4 E3 79 16 C1 01 C4 E3 79 16 C0 02 C5 F9 10 B2 ?? ?? ?? ?? C4 E3 79 16 C2 03 C5 F9 10 B9 ?? ?? ?? ?? C5 D1 FE 25 ?? ?? ?? ?? C4 E3 4D 18 80 ?? ?? ?? ?? 01 C4 E3 45 18 B2 ?? ?? ?? ?? 01 C5 FD 14 FE C4 E3 65 18 D9 01 C5 FD 15 CE C5 F9 70 F4 50 C5 F9 70 C4 FA C4 E3 4D 18 E8 01 C5 D5 54 35 ?? ?? ?? ?? C5 ED 54 2D ?? ?? ?? ?? C5 ED 5C E5 C5 CD 5C 35 ?? ?? ?? ?? C5 ED 59 D3 C5 D5 59 EB C5 ED 58 05 ?? ?? ?? ?? C5 D5 5C EA C5 DD 59 D3 C5 ED 58 E5 C5 CD 58 D7 C5 ED 58 F0 C5 CD 58 FC C5 ED 5C DE C5 CD 5C D7 C5 E5 58 D8 C5 ED 58 EC C5 D5 58 F3 C5 FD 58 DC C5 CD 58 F1 C5 E5 59 0D ?? ?? ?? ?? C5 F5 58 25 ?? ?? ?? ?? C5 DD 59 C3 C5 FD 58 15 ?? ?? ?? ?? C5 ED 59 EB C5 D5 58 0D ?? ?? ?? ?? C5 F5 59 E3 C5 DD 58 05 ?? ?? ?? ?? C5 FD 59 D3 C5 ED 58 2D ?? ?? ?? ?? C5 D5 59 DB C5 E5 58 F6 C5 FD 10 1D ?? ?? ?? ?? C5 C5 58 EE C5 D5 5C FF C5 CD 5C D7 C5 FD 10 74 24 20 C5 FD 11 54 24 40 C5 D5 54 FB C5 CD 54 D3 C5 ED 59 CF C5 FD 11 7C 24 60 C5 CD 5C C2 C5 D5 5C EF C5 F8 10 B4 24 C0 00 00 00 C5 F8 10 3D ?? ?? ?? ?? C5 FD 11 8C 24 80 00 00 00 C5 ED 59 D5 C4 E3 7D 19 CC 01 C5 F0 C6 DC DD C5 E1 DB 25 ?? ?? ?? ?? C5 C9 FE 1D ?? ?? ?? ?? C5 F8 10 35 ?? ?? ?? ?? C5 C1 66 CB C5 FA 6F 9C 24 D0 00 00 00 C5 E1 66 FE C5 E1 76 DE C5 C1 EB FB C5 F1 EB F7 C5 FD 59 FD C5 F8 10 0D ?? ?? ?? ?? C5 D9 66 D9 C5 D9 76 E1 C5 E1 EB DC C5 C9 EB F3 C5 ED 58 EF C5 F8 50 C6 C5 FD 10 0D ?? ?? ?? ?? C5 FD 10 BC 24 80 00 00 00 C5 FD 10 54 24 20 C5 FD 59 44 24 60 C5 C5 58 E1 C5 ED 59 74 24 40 C5 FD 58 DD C5 E5 58 DE C4 E3 7D 19 E0 01 C5 DD 5C C9 C5 D8 C6 E8 88 C5 D0 54 15 ?? ?? ?? ?? C5 F9 72 F2 04 C5 E9 72 F5 0D C5 C5 5C F9 C5 E9 FE 2D ?? ?? ?? ?? C5 F9 70 D5 50 C5 F9 7E C1 C5 F9 70 ED FA C5 E5 58 DF C4 E3 79 16 C2 01 C5 E5 59 35 ?? ?? ?? ?? C4 E3 6D 18 D5 01 C5 ED 54 2D ?? ?? ?? ?? C5 FB 10 91 ?? ?? ?? ?? C4 E3 79 16 C1 02 C5 FD 11 AC 24 A0 00 00 00 C5 E9 16 AA ?? ?? ?? ?? C5 FB 10 91 ?? ?? ?? ?? C4 E3 79 16 C2 03 C5 E9 16 82 ?? ?? ?? ?? C4 E3 55 18 D0 01 C5 CD 58 05 ?? ?? ?? ?? C5 ED 59 94 24 A0 00 00 00 C5 FD 59 CB C5 ED 59 EB C5 F5 58 25 ?? ?? ?? ?? C5 DD 59 F3 C5 CD 58 3D ?? ?? ?? ?? C5 C5 59 DB C5 E5 58 05 ?? ?? ?? ?? C5 FD 59 ED C5 D5 58 C2 85 C0 75 04 8B E5 5D C3 C5 FD 10 0C 24 C5 FD 10 54 24 20 C5 FD 11 84 24 C0 00 00 00 C5 FD 11 4C 24 40 C5 FD 11 94 24 80 00 00 00 74 D7 33 D2 89 74 24 04 8B F2 89 3C 24 8B F8 0F A3 F7 72 18 46 83 FE 20 7C F5 8B 74 24 04 8B 3C 24 C5 FD 10 84 24 C0 00 00 00 EB AD C5 F8 77 8D 8C F4 C0 00 00 00 8D 54 F4 40 8D 84 F4 80 00 00 00 51 50 52 E8 ?? ?? ?? ?? 83 C4 0C EB C6 8D 64 24 00 }
	condition:
		$1
}

rule file_106_0_0 {
	meta:
		name = "___avx_sinh4"
		size = 512
		refs = "0012 ___common_dsinh_data 01ea ___common_dsinh_cout_rare"
	strings:
		$1 = { 55 8B EC 83 E4 C0 56 57 81 EC B8 00 00 00 C5 FD 54 35 ?? ?? ?? ?? C5 CD 57 C8 C5 FD 10 25 ?? ?? ?? ?? C5 F5 59 3D ?? ?? ?? ?? C5 FD 11 44 24 20 C5 F9 10 15 ?? ?? ?? ?? C5 FD 11 34 24 C5 C5 58 EC C4 E3 7D 19 CB 01 C5 F0 C6 C3 DD C5 F9 66 35 ?? ?? ?? ?? C5 F8 50 FE C5 D1 DB FA C4 E3 7D 19 EE 01 C5 F9 7E F8 C5 C8 54 C2 C5 D5 5C D4 C5 D1 EF EF C5 F9 7E C1 C5 ED 59 25 ?? ?? ?? ?? C5 ED 59 15 ?? ?? ?? ?? C5 F5 5C CC C1 E0 04 C4 E3 79 16 FA 02 C5 C1 73 F5 2D C1 E2 04 C5 C8 57 E8 C1 E1 04 C5 C9 73 F5 2D C4 E3 79 16 C6 02 C1 E6 04 C5 FA 7E 98 ?? ?? ?? ?? C5 E1 16 A2 ?? ?? ?? ?? C5 FA 7E 99 ?? ?? ?? ?? C5 F9 11 64 24 60 C5 E1 16 A6 ?? ?? ?? ?? C5 F9 11 64 24 70 C5 FA 7E 98 ?? ?? ?? ?? C5 FA 7E A1 ?? ?? ?? ?? C5 E1 16 9A ?? ?? ?? ?? C5 F5 5C D2 C5 D9 16 A6 ?? ?? ?? ?? C5 E1 D4 DF C5 D9 D4 E6 C5 ED 59 CA C5 F9 10 6C 24 60 C4 E3 65 18 C4 01 C5 F9 10 5C 24 70 C5 D1 D4 E7 C5 D1 FB FF C5 FC 11 44 24 40 C5 E1 D4 C6 C5 E1 FB DE C4 E3 5D 18 E0 01 C4 E3 45 18 C3 01 C5 DD 58 E8 C5 DD 5C C0 C5 F5 59 25 ?? ?? ?? ?? C5 DD 58 35 ?? ?? ?? ?? C5 CD 59 E1 C5 DD 59 DA C5 E5 58 DA C5 F5 59 15 ?? ?? ?? ?? C5 ED 58 25 ?? ?? ?? ?? C5 FC 10 54 24 40 C5 DD 59 C9 C5 ED 58 E0 C5 ED 58 ED C5 F5 59 C4 C5 E5 59 D5 C5 ED 58 C8 C5 F5 58 DC C5 E5 56 04 24 85 FF 75 0C 81 C4 B8 00 00 00 5F 5E 8B E5 5D C3 C5 FD 10 4C 24 20 C5 FD 11 44 24 40 C5 FD 11 0C 24 74 E1 33 F6 0F A3 F7 72 18 46 83 FE 20 7C F5 C5 FD 10 44 24 40 81 C4 B8 00 00 00 5F 5E 8B E5 5D C3 C5 F8 77 8D 44 F4 40 8D 14 F4 50 52 E8 ?? ?? ?? ?? 83 C4 08 EB D2 8D A4 24 00 00 00 00 8D 9B 00 00 00 00 }
	condition:
		$1
}

rule file_108_1_0 {
	meta:
		name = "__guard_icall_checks_enforced"
		size = 39
		refs = "0006 ___guard_check_icall_fptr 000a @_guard_check_icall_nop@4"
	strings:
		$1 = { 55 8B EC 51 81 3D ?? ?? ?? ?? ?? ?? ?? ?? 74 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_110_0_0 {
	meta:
		name = "__FindPESection"
		size = 115
	strings:
		$1 = { 55 8B EC 83 EC 0C 8B 45 08 8B 4D 08 03 48 3C 89 4D F8 C7 45 F4 00 00 00 00 8B 55 F8 0F B7 42 14 8B 4D F8 8D 54 01 18 89 55 FC EB 12 8B 45 F4 83 C0 01 89 45 F4 8B 4D FC 83 C1 28 89 4D FC 8B 55 F8 0F B7 42 06 39 45 F4 73 23 8B 4D FC 8B 55 0C 3B 51 0C 72 16 8B 45 FC 8B 48 0C 8B 55 FC 03 4A 08 39 4D 0C 73 05 8B 45 FC EB 04 EB BF 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_110_1_0 {
	meta:
		name = "__IsNonwritableInCurrentImage"
		size = 299
		refs = "0006 __sehtable$__IsNonwritableInCurrentImage 000b __except_handler4 001d ___security_cookie 0036 ___ImageBase 0046 __ValidateImageBase 0079 __FindPESection"
	strings:
		$1 = { 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 D0 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 89 65 E8 C7 45 E4 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 45 E4 50 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 16 C7 45 D4 00 00 00 00 C7 45 FC FE FF FF FF 8B 45 D4 E9 B2 00 00 00 8B 4D 08 2B 4D E4 89 4D D0 8B 55 D0 52 8B 45 E4 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 E0 83 7D E0 00 75 13 C7 45 CC 00 00 00 00 C7 45 FC FE FF FF FF 8B 45 CC EB 7D 8B 4D E0 8B 51 24 81 E2 00 00 00 80 75 09 C7 45 DC 01 00 00 00 EB 07 C7 45 DC 00 00 00 00 8B 45 DC 89 45 C8 C7 45 FC FE FF FF FF 8B 45 C8 EB 4D C7 45 FC FE FF FF FF EB 44 8B 4D EC 8B 11 8B 02 89 45 C4 81 7D C4 05 00 00 C0 75 09 C7 45 D8 01 00 00 00 EB 07 C7 45 D8 00 00 00 00 8B 45 D8 C3 8B 65 E8 C7 45 C0 00 00 00 00 C7 45 FC FE FF FF FF 8B 45 C0 EB 07 C7 45 FC FE FF FF FF 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_110_2_0 {
	meta:
		name = "__ValidateImageBase"
		size = 93
	strings:
		$1 = { 55 8B EC 83 EC 0C 8B 45 08 89 45 FC 8B 4D FC 0F B7 11 81 FA 4D 5A 00 00 74 04 33 C0 EB 3B 8B 45 FC 8B 4D FC 03 48 3C 89 4D F8 8B 55 F8 81 3A 50 45 00 00 74 04 33 C0 EB 20 8B 45 F8 83 C0 18 89 45 F4 8B 4D F4 0F B7 11 81 FA 0B 01 00 00 74 04 33 C0 EB 05 B8 01 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_112_2_0 {
	meta:
		name = "___scrt_initialize_default_local_stdio_options"
		size = 64
		refs = "0007 ___local_stdio_printf_options 0022 ___local_stdio_scanf_options"
	strings:
		$1 = { 55 8B EC 83 EC 08 E8 ?? ?? ?? ?? 89 45 FC 8B 45 FC 8B 08 83 C9 04 8B 50 04 8B 45 FC 89 08 89 50 04 E8 ?? ?? ?? ?? 89 45 F8 8B 4D F8 8B 11 83 CA 02 8B 41 04 8B 4D F8 89 11 89 41 04 8B E5 5D C3 }
	condition:
		$1
}

rule file_113_0_0 {
	meta:
		name = "___sse2_coshf4"
		size = 320
		refs = "0012 ___common_scosh_data 0135 ___common_scosh_cout_rare"
	strings:
		$1 = { 55 8B EC 83 E4 C0 81 EC C0 00 00 00 0F 28 C8 0F 28 3D ?? ?? ?? ?? 0F 28 1D ?? ?? ?? ?? 0F 55 F9 0F 59 DF 0F 28 25 ?? ?? ?? ?? 0F 29 0C 24 0F 28 CF 66 0F 6F 15 ?? ?? ?? ?? 0F 58 DC 66 0F 66 CA 66 0F 76 D7 66 0F EB CA 0F 50 D1 0F 28 CB 0F 28 15 ?? ?? ?? ?? 66 0F 72 F3 17 0F 28 2D ?? ?? ?? ?? 0F 5C CC 0F 59 D1 85 D2 0F 28 25 ?? ?? ?? ?? 0F 5C FA 0F 59 E1 0F 28 35 ?? ?? ?? ?? 0F 5C FC 0F 28 CF 0F 59 CF 0F 59 E9 0F 59 F1 0F 58 2D ?? ?? ?? ?? 0F 58 35 ?? ?? ?? ?? 0F 59 E9 0F 59 F1 0F 59 EF 0F 58 35 ?? ?? ?? ?? 0F 58 EF 0F 59 F1 66 0F 6F 05 ?? ?? ?? ?? 66 0F 6F D0 66 0F FA C3 66 0F FE D3 66 0F 6F DA 0F 58 D0 0F 5C D8 0F 59 F2 0F 59 DD 0F 58 DE 0F 58 DA 75 07 0F 28 C3 8B E5 5D C3 0F 28 0C 24 0F 29 4C 24 40 0F 29 9C 24 80 00 00 00 74 E6 33 C0 89 74 24 04 8B F0 89 3C 24 8B FA 8B CE B8 01 00 00 00 D3 E0 85 F8 75 17 46 83 FE 20 7C ED 8B 74 24 04 8B 3C 24 0F 28 9C 24 80 00 00 00 EB B5 8D 8C B4 80 00 00 00 8D 44 B4 40 51 50 E8 ?? ?? ?? ?? 83 C4 08 EB D2 8B FF }
	condition:
		$1
}

rule file_114_0_0 {
	meta:
		name = "??2@YAPAXIABUnothrow_t@std@@@Z"
		size = 71
		refs = "0006 __ehhandler$??2@YAPAXIABUnothrow_t@std@@@Z 0019 ___security_cookie 0038 ??2@YAPAXI@Z"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 51 83 EC 08 53 56 57 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 65 F0 C7 45 FC 00 00 00 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 EC 8B 45 EC EB 26 }
	condition:
		$1
}

rule file_114_1_0 {
	meta:
		name = "__catch$??2@YAPAXIABUnothrow_t@std@@@Z$0"
		size = 56
		refs = "0008 $LN7 000e __tryend$??2@YAPAXIABUnothrow_t@std@@@Z$1"
	strings:
		$1 = { C7 45 E8 00 00 00 00 B8 ?? ?? ?? ?? C3 B8 ?? ?? ?? ?? C3 C7 45 FC FF FF FF FF EB 0A C7 45 FC FF FF FF FF 8B 45 E8 8B 4D F4 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_114_2_0 {
	meta:
		name = "__ehhandler$??2@YAPAXIABUnothrow_t@std@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??2@YAPAXIABUnothrow_t@std@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_79_7_2 {
	meta:
		name = "__ehhandler$??$?0AAPAUEHExceptionRecord@@_N@?$_Ref_count_obj_alloc@V__ExceptionPtr@@U?$_StaticAllocator@H@@@std@@QAE@ABU?$_StaticAllocator@H@@AAPAUEHExceptionRecord@@$$QA_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$?0AAPAUEHExceptionRecord@@_N@?$_Ref_count_obj_alloc@V__ExceptionPtr@@U?$_StaticAllocator@H@@@std@@QAE@ABU?$_StaticAllocator@H@@AAPAUEHExceptionRecord@@$$QA_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_79_62_2 {
	meta:
		name = "__ehhandler$??1__ExceptionPtr@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1__ExceptionPtr@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_79_96_2 {
	meta:
		name = "__ehhandler$?_CurrentException@__ExceptionPtr@@SA?AV?$shared_ptr@V__ExceptionPtr@@@std@@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_CurrentException@__ExceptionPtr@@SA?AV?$shared_ptr@V__ExceptionPtr@@@std@@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_90_426_2 {
	meta:
		name = "__ehhandler$?_Init@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@IAEXABV_Locinfo@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Init@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@IAEXABV_Locinfo@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_1064_3 {
	meta:
		name = "__ehhandler$?_Init@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@IAEXABV_Locinfo@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Init@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@IAEXABV_Locinfo@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_1015_2 {
	meta:
		name = "__ehhandler$?_Init@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@IAEXABV_Locinfo@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Init@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@IAEXABV_Locinfo@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_100_559_3 {
	meta:
		name = "__ehhandler$?do_get_time@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?do_get_time@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_29_1210_1 {
	meta:
		name = "__ehhandler$?do_get_time@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?do_get_time@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_29_1213_1 {
	meta:
		name = "__ehhandler$?do_get_time@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?do_get_time@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_102_452_2 {
	meta:
		name = "__ehhandler$?widen@?$basic_ios@DU?$char_traits@D@std@@@std@@QBEDD@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?widen@?$basic_ios@DU?$char_traits@D@std@@@std@@QBEDD@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_19_483_3 {
	meta:
		name = "__ehhandler$?widen@?$basic_ios@GU?$char_traits@G@std@@@std@@QBEGD@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?widen@?$basic_ios@GU?$char_traits@G@std@@@std@@QBEGD@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_47_484_3 {
	meta:
		name = "__ehhandler$?widen@?$basic_ios@_WU?$char_traits@_W@std@@@std@@QBE_WD@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?widen@?$basic_ios@_WU?$char_traits@_W@std@@@std@@QBE_WD@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_115_0_0 {
	meta:
		name = "??0bad_alloc@std@@AAE@QBD@Z"
		size = 39
		refs = "0011 ??0exception@std@@QAE@QBDH@Z 001a ??_7bad_alloc@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 6A 01 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_115_1_0 {
	meta:
		name = "??0bad_alloc@std@@QAE@ABV01@@Z"
		size = 37
		refs = "000f ??0exception@std@@QAE@ABV01@@Z 0018 ??_7bad_alloc@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_28_1_4 {
	meta:
		name = "??0__non_rtti_object@std@@QAE@ABV01@@Z"
		size = 37
		refs = "000f ??0bad_typeid@std@@QAE@ABV01@@Z 0018 ??_7__non_rtti_object@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_115_3_0 {
	meta:
		name = "??0bad_array_new_length@std@@QAE@ABV01@@Z"
		size = 37
		refs = "000f ??0bad_alloc@std@@QAE@ABV01@@Z 0018 ??_7bad_array_new_length@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_65_113_2 {
	meta:
		name = "??0bad_cast@std@@QAE@ABV01@@Z"
		size = 37
		refs = "000f ??0exception@std@@QAE@ABV01@@Z 0018 ??_7bad_cast@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_79_52_2 {
	meta:
		name = "??0bad_exception@std@@QAE@ABV01@@Z"
		size = 37
		refs = "000f ??0exception@std@@QAE@ABV01@@Z 0018 ??_7bad_exception@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_79_2_3 {
	meta:
		name = "??0bad_function_call@std@@QAE@ABV01@@Z"
		size = 37
		refs = "000f ??0exception@std@@QAE@ABV01@@Z 0018 ??_7bad_function_call@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_28_5_4 {
	meta:
		name = "??0bad_typeid@std@@QAE@ABV01@@Z"
		size = 37
		refs = "000f ??0exception@std@@QAE@ABV01@@Z 0018 ??_7bad_typeid@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_67_122_3 {
	meta:
		name = "??0codecvt_base@std@@QAE@I@Z"
		size = 37
		refs = "000f ??0facet@locale@std@@IAE@I@Z 0018 ??_7codecvt_base@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_92_136_3 {
	meta:
		name = "??0ctype_base@std@@QAE@I@Z"
		size = 37
		refs = "000f ??0facet@locale@std@@IAE@I@Z 0018 ??_7ctype_base@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_19_126_2 {
	meta:
		name = "??0failure@ios_base@std@@QAE@ABV012@@Z"
		size = 37
		refs = "000f ??0system_error@std@@QAE@ABV01@@Z 0018 ??_7failure@ios_base@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_79_8_3 {
	meta:
		name = "??0invalid_argument@std@@QAE@ABV01@@Z"
		size = 37
		refs = "000f ??0logic_error@std@@QAE@ABV01@@Z 0018 ??_7invalid_argument@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_32_9_2 {
	meta:
		name = "??0invalid_argument@std@@QAE@PBD@Z"
		size = 37
		refs = "000f ??0logic_error@std@@QAE@PBD@Z 0018 ??_7invalid_argument@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_51_10_1 {
	meta:
		name = "??0length_error@std@@QAE@ABV01@@Z"
		size = 37
		refs = "000f ??0logic_error@std@@QAE@ABV01@@Z 0018 ??_7length_error@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_51_11_1 {
	meta:
		name = "??0length_error@std@@QAE@PBD@Z"
		size = 37
		refs = "000f ??0logic_error@std@@QAE@PBD@Z 0018 ??_7length_error@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_23_5_1 {
	meta:
		name = "??0logic_error@std@@QAE@ABV01@@Z"
		size = 37
		refs = "000f ??0exception@std@@QAE@ABV01@@Z 0018 ??_7logic_error@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_79_13_3 {
	meta:
		name = "??0logic_error@std@@QAE@PBD@Z"
		size = 37
		refs = "000f ??0exception@std@@QAE@QBD@Z 0018 ??_7logic_error@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_100_207_3 {
	meta:
		name = "??0messages_base@std@@QAE@I@Z"
		size = 37
		refs = "000f ??0facet@locale@std@@IAE@I@Z 0018 ??_7messages_base@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_80_156_1 {
	meta:
		name = "??0money_base@std@@QAE@I@Z"
		size = 37
		refs = "000f ??0facet@locale@std@@IAE@I@Z 0018 ??_7money_base@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_51_14_1 {
	meta:
		name = "??0out_of_range@std@@QAE@ABV01@@Z"
		size = 37
		refs = "000f ??0logic_error@std@@QAE@ABV01@@Z 0018 ??_7out_of_range@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_51_15_1 {
	meta:
		name = "??0out_of_range@std@@QAE@PBD@Z"
		size = 37
		refs = "000f ??0logic_error@std@@QAE@PBD@Z 0018 ??_7out_of_range@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_51_16_1 {
	meta:
		name = "??0overflow_error@std@@QAE@ABV01@@Z"
		size = 37
		refs = "000f ??0runtime_error@std@@QAE@ABV01@@Z 0018 ??_7overflow_error@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_51_17_1 {
	meta:
		name = "??0overflow_error@std@@QAE@PBD@Z"
		size = 37
		refs = "000f ??0runtime_error@std@@QAE@PBD@Z 0018 ??_7overflow_error@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_75_108_1 {
	meta:
		name = "??0runtime_error@std@@QAE@ABV01@@Z"
		size = 37
		refs = "000f ??0exception@std@@QAE@ABV01@@Z 0018 ??_7runtime_error@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_67_143_3 {
	meta:
		name = "??0runtime_error@std@@QAE@PBD@Z"
		size = 37
		refs = "000f ??0exception@std@@QAE@QBD@Z 0018 ??_7runtime_error@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_107_144_3 {
	meta:
		name = "??0system_error@std@@QAE@ABV01@@Z"
		size = 37
		refs = "000f ??0_System_error@std@@QAE@ABV01@@Z 0018 ??_7system_error@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_100_211_3 {
	meta:
		name = "??0time_base@std@@QAE@I@Z"
		size = 37
		refs = "000f ??0facet@locale@std@@IAE@I@Z 0018 ??_7time_base@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_115_2_0 {
	meta:
		name = "??0bad_alloc@std@@QAE@XZ"
		size = 38
		refs = "000a ??_C@_0P@GHFPNOJB@bad?5allocation?$AA@ 0012 ??0exception@std@@QAE@QBDH@Z 001b ??_7bad_alloc@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 6A 01 68 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC C7 00 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_46_121_3 {
	meta:
		name = "??0bad_cast@std@@QAE@XZ"
		size = 38
		refs = "000a ??_C@_08EPJLHIJG@bad?5cast?$AA@ 0012 ??0exception@std@@QAE@QBDH@Z 001b ??_7bad_cast@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 6A 01 68 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC C7 00 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_93_53_1 {
	meta:
		name = "??0bad_exception@std@@QAE@XZ"
		size = 38
		refs = "000a ??_C@_0O@DPKOEFFH@bad?5exception?$AA@ 0012 ??0exception@std@@QAE@QBDH@Z 001b ??_7bad_exception@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 6A 01 68 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC C7 00 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_115_4_0 {
	meta:
		name = "??0bad_array_new_length@std@@QAE@XZ"
		size = 36
		refs = "0008 ??_C@_0BF@KINCDENJ@bad?5array?5new?5length?$AA@ 0010 ??0bad_alloc@std@@AAE@QBD@Z 0019 ??_7bad_array_new_length@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 68 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC C7 00 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_115_5_0 {
	meta:
		name = "??0exception@std@@QAE@ABV01@@Z"
		size = 60
		refs = "000c ??_7exception@std@@6B@ 002c ___std_exception_copy"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 33 C9 8B 55 FC 83 C2 04 89 0A 89 4A 04 8B 45 FC 83 C0 04 50 8B 4D 08 83 C1 04 51 E8 ?? ?? ?? ?? 83 C4 08 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_115_6_0 {
	meta:
		name = "??0exception@std@@QAE@QBDH@Z"
		size = 47
		refs = "000c ??_7exception@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 33 C9 8B 55 FC 83 C2 04 89 0A 89 4A 04 8B 45 FC 8B 4D 08 89 48 04 8B 45 FC 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_115_7_0 {
	meta:
		name = "??1bad_alloc@std@@UAE@XZ"
		size = 19
		refs = "000b ??1exception@std@@UAE@XZ"
		altNames = "??1bad_cast@std@@UAE@XZ ??1bad_exception@std@@UAE@XZ ??1bad_function_call@std@@UAE@XZ ??1bad_typeid@std@@UAE@XZ ??1logic_error@std@@UAE@XZ ??1runtime_error@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_67_148_3 {
	meta:
		name = "??1?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@D@std@@@std@@V?$_String_val@U?$_Simple_types@D@std@@@2@$00@std@@QAE@XZ"
		size = 19
		refs = "000b ??1?$_String_val@U?$_Simple_types@D@std@@@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_44_456_2 {
	meta:
		name = "??1?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@G@std@@@std@@V?$_String_val@U?$_Simple_types@G@std@@@2@$00@std@@QAE@XZ"
		size = 19
		refs = "000b ??1?$_String_val@U?$_Simple_types@G@std@@@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_29_385_1 {
	meta:
		name = "??1?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@_W@std@@@std@@V?$_String_val@U?$_Simple_types@_W@std@@@2@$00@std@@QAE@XZ"
		size = 19
		refs = "000b ??1?$_String_val@U?$_Simple_types@_W@std@@@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_2_2_2 {
	meta:
		name = "??1?$_Func_class@X$$V@std@@QAE@XZ"
		size = 19
		refs = "000b ?_Tidy@?$_Func_class@X$$V@std@@IAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_104_142_2 {
	meta:
		name = "??1?$_Iterator012@Urandom_access_iterator_tag@std@@DHPBDABDU_Iterator_base12@2@@std@@QAE@XZ"
		size = 19
		refs = "000b ??1_Iterator_base12@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_10_504_3 {
	meta:
		name = "??1?$_Iterator012@Urandom_access_iterator_tag@std@@GHPBGABGU_Iterator_base12@2@@std@@QAE@XZ"
		size = 19
		refs = "000b ??1_Iterator_base12@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_44_459_2 {
	meta:
		name = "??1?$_Iterator012@Urandom_access_iterator_tag@std@@_WHPB_WAB_WU_Iterator_base12@2@@std@@QAE@XZ"
		size = 19
		refs = "000b ??1_Iterator_base12@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_93_56_1 {
	meta:
		name = "??1?$_Ref_count_obj@V__ExceptionPtr@@@std@@UAE@XZ"
		size = 19
		refs = "000b ??1_Ref_count_base@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_93_57_1 {
	meta:
		name = "??1?$_Ref_count_obj_alloc@V__ExceptionPtr@@U?$_StaticAllocator@H@@@std@@UAE@XZ"
		size = 19
		refs = "000b ??1_Ref_count_base@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_110_118_1 {
	meta:
		name = "??1?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAE@XZ"
		size = 19
		refs = "000b ??1?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@D@std@@@std@@V?$_String_val@U?$_Simple_types@D@std@@@2@$00@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_29_391_1 {
	meta:
		name = "??1?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAE@XZ"
		size = 19
		refs = "000b ??1?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@G@std@@@std@@V?$_String_val@U?$_Simple_types@G@std@@@2@$00@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_73_21_1 {
	meta:
		name = "??1?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAE@XZ"
		size = 19
		refs = "000b ??1?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@_W@std@@@std@@V?$_String_val@U?$_Simple_types@_W@std@@@2@$00@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_9_145_2 {
	meta:
		name = "??1?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QAE@XZ"
		size = 19
		refs = "000b ??1?$_Iterator012@Urandom_access_iterator_tag@std@@DHPBDABDU_Iterator_base12@2@@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_44_470_2 {
	meta:
		name = "??1?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QAE@XZ"
		size = 19
		refs = "000b ??1?$_Iterator012@Urandom_access_iterator_tag@std@@GHPBGABGU_Iterator_base12@2@@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_10_517_3 {
	meta:
		name = "??1?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QAE@XZ"
		size = 19
		refs = "000b ??1?$_Iterator012@Urandom_access_iterator_tag@std@@_WHPB_WAB_WU_Iterator_base12@2@@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_114_166_3 {
	meta:
		name = "??1?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QAE@XZ"
		size = 19
		refs = "000b ??1?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_10_518_3 {
	meta:
		name = "??1?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QAE@XZ"
		size = 19
		refs = "000b ??1?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_49_55_3 {
	meta:
		name = "??1?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QAE@XZ"
		size = 19
		refs = "000b ??1?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_16_63_1 {
	meta:
		name = "??1?$_String_val@U?$_Simple_types@D@std@@@std@@QAE@XZ"
		size = 19
		refs = "000b ??1_Bxty@?$_String_val@U?$_Simple_types@D@std@@@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_29_394_1 {
	meta:
		name = "??1?$_String_val@U?$_Simple_types@G@std@@@std@@QAE@XZ"
		size = 19
		refs = "000b ??1_Bxty@?$_String_val@U?$_Simple_types@G@std@@@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_73_22_1 {
	meta:
		name = "??1?$_String_val@U?$_Simple_types@_W@std@@@std@@QAE@XZ"
		size = 19
		refs = "000b ??1_Bxty@?$_String_val@U?$_Simple_types@_W@std@@@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_2_9_4 {
	meta:
		name = "??1?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QAE@XZ"
		size = 19
		refs = "000b ?release@?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_25_2_4 {
	meta:
		name = "??1?$__crt_unique_heap_ptr@DU__crt_public_free_policy@@@@QAE@XZ"
		size = 19
		refs = "000b ?release@?$__crt_unique_heap_ptr@DU__crt_public_free_policy@@@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_318_3_0 {
	meta:
		name = "??1?$__crt_unique_heap_ptr@UTlsDtorNode@@U__crt_internal_free_policy@@@@QAE@XZ"
		size = 19
		refs = "000b ?release@?$__crt_unique_heap_ptr@UTlsDtorNode@@U__crt_internal_free_policy@@@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_4_3_4 {
	meta:
		name = "??1?$__crt_unique_heap_ptr@U__vcrt_ptd@@U__crt_internal_free_policy@@@@QAE@XZ"
		size = 19
		refs = "000b ?release@?$__crt_unique_heap_ptr@U__vcrt_ptd@@U__crt_internal_free_policy@@@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_2_10_4 {
	meta:
		name = "??1?$__crt_unique_heap_ptr@XU__crt_internal_free_policy@@@@QAE@XZ"
		size = 19
		refs = "000b ?release@?$__crt_unique_heap_ptr@XU__crt_internal_free_policy@@@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_2_3_2 {
	meta:
		name = "??1?$function@$$A6AXXZ@std@@QAE@XZ"
		size = 19
		refs = "000b ??1?$_Func_class@X$$V@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_95_59_1 {
	meta:
		name = "??1_Generic_error_category@std@@UAE@XZ"
		size = 19
		refs = "000b ??1error_category@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_10_166_2 {
	meta:
		name = "??1_Iostream_error_category@std@@UAE@XZ"
		size = 19
		refs = "000b ??1_Generic_error_category@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_75_138_1 {
	meta:
		name = "??1_System_error@std@@UAE@XZ"
		size = 19
		refs = "000b ??1runtime_error@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_59_111_3 {
	meta:
		name = "??1_System_error_category@std@@UAE@XZ"
		size = 19
		refs = "000b ??1error_category@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_28_8_4 {
	meta:
		name = "??1__non_rtti_object@std@@UAE@XZ"
		size = 19
		refs = "000b ??1bad_typeid@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_164_8_7 {
	meta:
		name = "??1bad_array_new_length@std@@UAE@XZ"
		size = 19
		refs = "000b ??1bad_alloc@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_36_177_2 {
	meta:
		name = "??1failure@ios_base@std@@UAE@XZ"
		size = 19
		refs = "000b ??1system_error@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_23_9_1 {
	meta:
		name = "??1future_error@std@@UAE@XZ"
		size = 19
		refs = "000b ??1logic_error@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_79_25_3 {
	meta:
		name = "??1invalid_argument@std@@UAE@XZ"
		size = 19
		refs = "000b ??1logic_error@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_79_26_3 {
	meta:
		name = "??1length_error@std@@UAE@XZ"
		size = 19
		refs = "000b ??1logic_error@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_100_253_3 {
	meta:
		name = "??1messages_base@std@@UAE@XZ"
		size = 19
		refs = "000b ??1facet@locale@std@@MAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_10_582_3 {
	meta:
		name = "??1money_base@std@@UAE@XZ"
		size = 19
		refs = "000b ??1facet@locale@std@@MAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_51_28_1 {
	meta:
		name = "??1out_of_range@std@@UAE@XZ"
		size = 19
		refs = "000b ??1logic_error@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_51_29_1 {
	meta:
		name = "??1overflow_error@std@@UAE@XZ"
		size = 19
		refs = "000b ??1runtime_error@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_51_30_1 {
	meta:
		name = "??1regex_error@std@@UAE@XZ"
		size = 19
		refs = "000b ??1runtime_error@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_3_204_3 {
	meta:
		name = "??1system_error@std@@UAE@XZ"
		size = 19
		refs = "000b ??1_System_error@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_2_13_4 {
	meta:
		name = "??B?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QBE_NXZ"
		size = 19
		refs = "000b ?is_valid@?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QBE_NXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_25_3_4 {
	meta:
		name = "??B?$__crt_unique_heap_ptr@DU__crt_public_free_policy@@@@QBE_NXZ"
		size = 19
		refs = "000b ?is_valid@?$__crt_unique_heap_ptr@DU__crt_public_free_policy@@@@QBE_NXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_4_5_4 {
	meta:
		name = "??B?$__crt_unique_heap_ptr@U__vcrt_ptd@@U__crt_internal_free_policy@@@@QBE_NXZ"
		size = 19
		refs = "000b ?is_valid@?$__crt_unique_heap_ptr@U__vcrt_ptd@@U__crt_internal_free_policy@@@@QBE_NXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_2_14_4 {
	meta:
		name = "??B?$__crt_unique_heap_ptr@XU__crt_internal_free_policy@@@@QBE_NXZ"
		size = 19
		refs = "000b ?is_valid@?$__crt_unique_heap_ptr@XU__crt_internal_free_policy@@@@QBE_NXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_94_71_3 {
	meta:
		name = "??C?$shared_ptr@V__ExceptionPtr@@@std@@QBEPAV__ExceptionPtr@@XZ"
		size = 19
		refs = "000b ?_Get@?$_Ptr_base@V__ExceptionPtr@@@std@@QBEPAV__ExceptionPtr@@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_102_195_2 {
	meta:
		name = "??D?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QBEAADXZ"
		size = 19
		refs = "000b ??D?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QBEABDXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_29_484_1 {
	meta:
		name = "??D?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QBEAAGXZ"
		size = 19
		refs = "000b ??D?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QBEABGXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_44_574_2 {
	meta:
		name = "??D?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QBEAA_WXZ"
		size = 19
		refs = "000b ??D?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QBEAB_WXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_53_96_1 {
	meta:
		name = "?_Bx@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAEAAT_Bxty@?$_String_val@U?$_Simple_types@D@std@@@2@XZ"
		size = 19
		refs = "000b ?_Get_data@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAEAAV?$_String_val@U?$_Simple_types@D@std@@@2@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_29_584_1 {
	meta:
		name = "?_Bx@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAEAAT_Bxty@?$_String_val@U?$_Simple_types@G@std@@@2@XZ"
		size = 19
		refs = "000b ?_Get_data@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAEAAV?$_String_val@U?$_Simple_types@G@std@@@2@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_73_29_1 {
	meta:
		name = "?_Bx@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAEAAT_Bxty@?$_String_val@U?$_Simple_types@_W@std@@@2@XZ"
		size = 19
		refs = "000b ?_Get_data@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAEAAV?$_String_val@U?$_Simple_types@_W@std@@@2@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_76_102_1 {
	meta:
		name = "?_Get_data@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAEAAV?$_String_val@U?$_Simple_types@D@std@@@2@XZ"
		size = 19
		refs = "000b ?_Get_second@?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@D@std@@@std@@V?$_String_val@U?$_Simple_types@D@std@@@2@$00@std@@QAEAAV?$_String_val@U?$_Simple_types@D@std@@@2@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_27_133_3 {
	meta:
		name = "?_Get_data@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QBEABV?$_String_val@U?$_Simple_types@D@std@@@2@XZ"
		size = 19
		refs = "000b ?_Get_second@?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@D@std@@@std@@V?$_String_val@U?$_Simple_types@D@std@@@2@$00@std@@QBEABV?$_String_val@U?$_Simple_types@D@std@@@2@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_29_642_1 {
	meta:
		name = "?_Get_data@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAEAAV?$_String_val@U?$_Simple_types@G@std@@@2@XZ"
		size = 19
		refs = "000b ?_Get_second@?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@G@std@@@std@@V?$_String_val@U?$_Simple_types@G@std@@@2@$00@std@@QAEAAV?$_String_val@U?$_Simple_types@G@std@@@2@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_44_746_2 {
	meta:
		name = "?_Get_data@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QBEABV?$_String_val@U?$_Simple_types@G@std@@@2@XZ"
		size = 19
		refs = "000b ?_Get_second@?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@G@std@@@std@@V?$_String_val@U?$_Simple_types@G@std@@@2@$00@std@@QBEABV?$_String_val@U?$_Simple_types@G@std@@@2@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_73_37_1 {
	meta:
		name = "?_Get_data@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAEAAV?$_String_val@U?$_Simple_types@_W@std@@@2@XZ"
		size = 19
		refs = "000b ?_Get_second@?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@_W@std@@@std@@V?$_String_val@U?$_Simple_types@_W@std@@@2@$00@std@@QAEAAV?$_String_val@U?$_Simple_types@_W@std@@@2@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_97_90_2 {
	meta:
		name = "?_Get_data@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QBEABV?$_String_val@U?$_Simple_types@_W@std@@@2@XZ"
		size = 19
		refs = "000b ?_Get_second@?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@_W@std@@@std@@V?$_String_val@U?$_Simple_types@_W@std@@@2@$00@std@@QBEABV?$_String_val@U?$_Simple_types@_W@std@@@2@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_92_280_3 {
	meta:
		name = "?_Getal@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAEAAU?$_Wrap_alloc@V?$allocator@D@std@@@2@XZ"
		size = 19
		refs = "000b ?_Get_first@?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@D@std@@@std@@V?$_String_val@U?$_Simple_types@D@std@@@2@$00@std@@QAEAAU?$_Wrap_alloc@V?$allocator@D@std@@@2@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_29_659_1 {
	meta:
		name = "?_Getal@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QBEABU?$_Wrap_alloc@V?$allocator@D@std@@@2@XZ"
		size = 19
		refs = "000b ?_Get_first@?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@D@std@@@std@@V?$_String_val@U?$_Simple_types@D@std@@@2@$00@std@@QBEABU?$_Wrap_alloc@V?$allocator@D@std@@@2@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_29_660_1 {
	meta:
		name = "?_Getal@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAEAAU?$_Wrap_alloc@V?$allocator@G@std@@@2@XZ"
		size = 19
		refs = "000b ?_Get_first@?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@G@std@@@std@@V?$_String_val@U?$_Simple_types@G@std@@@2@$00@std@@QAEAAU?$_Wrap_alloc@V?$allocator@G@std@@@2@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_29_661_1 {
	meta:
		name = "?_Getal@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QBEABU?$_Wrap_alloc@V?$allocator@G@std@@@2@XZ"
		size = 19
		refs = "000b ?_Get_first@?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@G@std@@@std@@V?$_String_val@U?$_Simple_types@G@std@@@2@$00@std@@QBEABU?$_Wrap_alloc@V?$allocator@G@std@@@2@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_49_103_3 {
	meta:
		name = "?_Getal@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAEAAU?$_Wrap_alloc@V?$allocator@_W@std@@@2@XZ"
		size = 19
		refs = "000b ?_Get_first@?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@_W@std@@@std@@V?$_String_val@U?$_Simple_types@_W@std@@@2@$00@std@@QAEAAU?$_Wrap_alloc@V?$allocator@_W@std@@@2@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_69_57_1 {
	meta:
		name = "?_Getal@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QBEABU?$_Wrap_alloc@V?$allocator@_W@std@@@2@XZ"
		size = 19
		refs = "000b ?_Get_first@?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@_W@std@@@std@@V?$_String_val@U?$_Simple_types@_W@std@@@2@$00@std@@QBEABU?$_Wrap_alloc@V?$allocator@_W@std@@@2@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_1_290_2 {
	meta:
		name = "?_Myproxy@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAEAAPAU_Container_proxy@2@XZ"
		size = 19
		refs = "000b ?_Get_data@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAEAAV?$_String_val@U?$_Simple_types@D@std@@@2@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_10_1126_3 {
	meta:
		name = "?_Myproxy@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAEAAPAU_Container_proxy@2@XZ"
		size = 19
		refs = "000b ?_Get_data@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAEAAV?$_String_val@U?$_Simple_types@G@std@@@2@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_97_101_2 {
	meta:
		name = "?_Myproxy@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAEAAPAU_Container_proxy@2@XZ"
		size = 19
		refs = "000b ?_Get_data@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAEAAV?$_String_val@U?$_Simple_types@_W@std@@@2@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_93_141_1 {
	meta:
		name = "?get@?$shared_ptr@V__ExceptionPtr@@@std@@QBEPAV__ExceptionPtr@@XZ"
		size = 19
		refs = "000b ?_Get@?$_Ptr_base@V__ExceptionPtr@@@std@@QBEPAV__ExceptionPtr@@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_115_9_0 {
	meta:
		name = "??1exception@std@@UAE@XZ"
		size = 35
		refs = "000c ??_7exception@std@@6B@ 0018 ___std_exception_destroy"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC 83 C1 04 51 E8 ?? ?? ?? ?? 83 C4 04 8B E5 5D C3 }
	condition:
		$1
}

rule file_115_10_0 {
	meta:
		name = "??_Gbad_alloc@std@@UAEPAXI@Z"
		size = 46
		refs = "000b ??1bad_alloc@std@@UAE@XZ 001e ??3@YAXPAXI@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0E 6A 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 08 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_93_75_1 {
	meta:
		name = "??_G_Ref_count_base@std@@UAEPAXI@Z"
		size = 46
		refs = "000b ??1_Ref_count_base@std@@UAE@XZ 001e ??3@YAXPAXI@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0E 6A 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 08 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_28_12_4 {
	meta:
		name = "??_G__non_rtti_object@std@@UAEPAXI@Z"
		size = 46
		refs = "000b ??1__non_rtti_object@std@@UAE@XZ 001e ??3@YAXPAXI@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0E 6A 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 08 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_115_11_0 {
	meta:
		name = "??_Gbad_array_new_length@std@@UAEPAXI@Z"
		size = 46
		refs = "000b ??1bad_array_new_length@std@@UAE@XZ 001e ??3@YAXPAXI@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0E 6A 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 08 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_75_174_1 {
	meta:
		name = "??_Gbad_cast@std@@UAEPAXI@Z"
		size = 46
		refs = "000b ??1bad_cast@std@@UAE@XZ 001e ??3@YAXPAXI@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0E 6A 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 08 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_94_78_3 {
	meta:
		name = "??_Gbad_exception@std@@UAEPAXI@Z"
		size = 46
		refs = "000b ??1bad_exception@std@@UAE@XZ 001e ??3@YAXPAXI@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0E 6A 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 08 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_51_33_1 {
	meta:
		name = "??_Gbad_function_call@std@@UAEPAXI@Z"
		size = 46
		refs = "000b ??1bad_function_call@std@@UAE@XZ 001e ??3@YAXPAXI@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0E 6A 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 08 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_28_14_4 {
	meta:
		name = "??_Gbad_typeid@std@@UAEPAXI@Z"
		size = 46
		refs = "000b ??1bad_typeid@std@@UAE@XZ 001e ??3@YAXPAXI@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0E 6A 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 08 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_118_231_3 {
	meta:
		name = "??_Gexception@std@@UAEPAXI@Z"
		size = 46
		refs = "000b ??1exception@std@@UAE@XZ 001e ??3@YAXPAXI@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0E 6A 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 08 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_32_35_2 {
	meta:
		name = "??_Ginvalid_argument@std@@UAEPAXI@Z"
		size = 46
		refs = "000b ??1invalid_argument@std@@UAE@XZ 001e ??3@YAXPAXI@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0E 6A 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 08 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_79_36_3 {
	meta:
		name = "??_Glength_error@std@@UAEPAXI@Z"
		size = 46
		refs = "000b ??1length_error@std@@UAE@XZ 001e ??3@YAXPAXI@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0E 6A 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 08 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_100_13_2 {
	meta:
		name = "??_Glogic_error@std@@UAEPAXI@Z"
		size = 46
		refs = "000b ??1logic_error@std@@UAE@XZ 001e ??3@YAXPAXI@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0E 6A 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 08 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_51_38_1 {
	meta:
		name = "??_Gout_of_range@std@@UAEPAXI@Z"
		size = 46
		refs = "000b ??1out_of_range@std@@UAE@XZ 001e ??3@YAXPAXI@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0E 6A 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 08 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_32_39_2 {
	meta:
		name = "??_Goverflow_error@std@@UAEPAXI@Z"
		size = 46
		refs = "000b ??1overflow_error@std@@UAE@XZ 001e ??3@YAXPAXI@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0E 6A 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 08 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_32_41_2 {
	meta:
		name = "??_Gruntime_error@std@@UAEPAXI@Z"
		size = 46
		refs = "000b ??1runtime_error@std@@UAE@XZ 001e ??3@YAXPAXI@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0E 6A 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 08 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_194_1_0 {
	meta:
		name = "??_Gtype_info@@UAEPAXI@Z"
		size = 46
		refs = "000b ??1type_info@@UAE@XZ 001e ??3@YAXPAXI@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0E 6A 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 08 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_115_13_0 {
	meta:
		name = "?__scrt_throw_std_bad_alloc@@YAXXZ"
		size = 32
		refs = "000a ??0bad_alloc@std@@QAE@XZ 000f __TI2?AVbad_alloc@std@@ 0018 __CxxThrowException@8"
		altNames = "?_Xbad_alloc@std@@YAXXZ"
	strings:
		$1 = { 55 8B EC 83 EC 0C 8D 4D F4 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F4 50 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_51_44_1 {
	meta:
		name = "?_Xbad_function_call@std@@YAXXZ"
		size = 32
		refs = "000a ??0bad_function_call@std@@QAE@XZ 000f __TI2?AVbad_function_call@std@@ 0018 __CxxThrowException@8"
	strings:
		$1 = { 55 8B EC 83 EC 0C 8D 4D F4 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F4 50 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_115_14_0 {
	meta:
		name = "?__scrt_throw_std_bad_array_new_length@@YAXXZ"
		size = 32
		refs = "000a ??0bad_array_new_length@std@@QAE@XZ 000f __TI3?AVbad_array_new_length@std@@ 0018 __CxxThrowException@8"
	strings:
		$1 = { 55 8B EC 83 EC 0C 8D 4D F4 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F4 50 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_115_15_0 {
	meta:
		name = "?what@exception@std@@UBEPBDXZ"
		size = 43
		refs = "0020 ??_C@_0BC@EOODALEL@Unknown?5exception?$AA@"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D FC 8B 45 FC 83 78 04 00 74 0B 8B 4D FC 8B 51 04 89 55 F8 EB 07 C7 45 F8 ?? ?? ?? ?? 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_116_0_0 {
	meta:
		name = "?pre_c_initialization@@YAHXZ"
		size = 189
		refs = "0005 ?get_app_type@__scrt_main_policy@@SA?AW4_crt_app_type@@XZ 000b __set_app_type 0013 __get_startup_file_mode 0019 __set_fmode 0021 __get_startup_commit_mode 0028 ___p__commode 0031 ___scrt_initialize_onexit_tables 0042 ___scrt_fastfail 0049 __RTC_Initialize 004e __RTC_Terminate 0053 _atexit 005b ?configure_argv@__scrt_narrow_argv_policy@@SAHXZ 006b ?__scrt_initialize_type_info@@YAXXZ 0070 ___scrt_is_user_matherr_present 0079 __matherr 007e ___setusermatherr 0086 __initialize_invalid_parameter_handler 008b __initialize_denormal_control 0090 __initialize_default_precision 0095 __get_startup_thread_locale_mode 009b __configthreadlocale 00a3 __should_initialize_environment 00af ?initialize_environment@@YAXXZ 00b4 ___scrt_initialize_winrt"
	strings:
		$1 = { 55 8B EC 56 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 E8 ?? ?? ?? ?? 8B F0 E8 ?? ?? ?? ?? 89 30 6A 01 E8 ?? ?? ?? ?? 83 C4 04 0F B6 C0 85 C0 75 07 6A 07 E8 ?? ?? ?? ?? DB E2 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 E8 ?? ?? ?? ?? 85 C0 74 07 6A 07 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 0D 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 E8 ?? ?? ?? ?? 0F B6 C8 85 C9 74 05 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5E 5D C3 }
	condition:
		$1
}

rule file_210_0_0 {
	meta:
		name = "?pre_c_initialization@@YAHXZ"
		size = 189
		refs = "0005 ?get_app_type@__scrt_winmain_policy@@SA?AW4_crt_app_type@@XZ 000b __set_app_type 0013 __get_startup_file_mode 0019 __set_fmode 0021 __get_startup_commit_mode 0028 ___p__commode 0031 ___scrt_initialize_onexit_tables 0042 ___scrt_fastfail 0049 __RTC_Initialize 004e __RTC_Terminate 0053 _atexit 005b ?configure_argv@__scrt_narrow_argv_policy@@SAHXZ 006b ?__scrt_initialize_type_info@@YAXXZ 0070 ___scrt_is_user_matherr_present 0079 __matherr 007e ___setusermatherr 0086 __initialize_invalid_parameter_handler 008b __initialize_denormal_control 0090 __initialize_default_precision 0095 __get_startup_thread_locale_mode 009b __configthreadlocale 00a3 __should_initialize_environment 00af ?initialize_environment@@YAXXZ 00b4 ___scrt_initialize_winrt"
	strings:
		$1 = { 55 8B EC 56 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 E8 ?? ?? ?? ?? 8B F0 E8 ?? ?? ?? ?? 89 30 6A 01 E8 ?? ?? ?? ?? 83 C4 04 0F B6 C0 85 C0 75 07 6A 07 E8 ?? ?? ?? ?? DB E2 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 E8 ?? ?? ?? ?? 85 C0 74 07 6A 07 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 0D 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 E8 ?? ?? ?? ?? 0F B6 C8 85 C9 74 05 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5E 5D C3 }
	condition:
		$1
}

rule file_215_0_0 {
	meta:
		name = "?pre_c_initialization@@YAHXZ"
		size = 189
		refs = "0005 ?get_app_type@__scrt_winmain_policy@@SA?AW4_crt_app_type@@XZ 000b __set_app_type 0013 __get_startup_file_mode 0019 __set_fmode 0021 __get_startup_commit_mode 0028 ___p__commode 0031 ___scrt_initialize_onexit_tables 0042 ___scrt_fastfail 0049 __RTC_Initialize 004e __RTC_Terminate 0053 _atexit 005b ?configure_argv@__scrt_wide_argv_policy@@SAHXZ 006b ?__scrt_initialize_type_info@@YAXXZ 0070 ___scrt_is_user_matherr_present 0079 __matherr 007e ___setusermatherr 0086 __initialize_invalid_parameter_handler 008b __initialize_denormal_control 0090 __initialize_default_precision 0095 __get_startup_thread_locale_mode 009b __configthreadlocale 00a3 __should_initialize_environment 00af ?initialize_environment@@YAXXZ 00b4 ___scrt_initialize_winrt"
	strings:
		$1 = { 55 8B EC 56 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 E8 ?? ?? ?? ?? 8B F0 E8 ?? ?? ?? ?? 89 30 6A 01 E8 ?? ?? ?? ?? 83 C4 04 0F B6 C0 85 C0 75 07 6A 07 E8 ?? ?? ?? ?? DB E2 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 E8 ?? ?? ?? ?? 85 C0 74 07 6A 07 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 0D 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 E8 ?? ?? ?? ?? 0F B6 C8 85 C9 74 05 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5E 5D C3 }
	condition:
		$1
}

rule file_282_0_0 {
	meta:
		name = "?pre_c_initialization@@YAHXZ"
		size = 189
		refs = "0005 ?get_app_type@__scrt_main_policy@@SA?AW4_crt_app_type@@XZ 000b __set_app_type 0013 __get_startup_file_mode 0019 __set_fmode 0021 __get_startup_commit_mode 0028 ___p__commode 0031 ___scrt_initialize_onexit_tables 0042 ___scrt_fastfail 0049 __RTC_Initialize 004e __RTC_Terminate 0053 _atexit 005b ?configure_argv@__scrt_wide_argv_policy@@SAHXZ 006b ?__scrt_initialize_type_info@@YAXXZ 0070 ___scrt_is_user_matherr_present 0079 __matherr 007e ___setusermatherr 0086 __initialize_invalid_parameter_handler 008b __initialize_denormal_control 0090 __initialize_default_precision 0095 __get_startup_thread_locale_mode 009b __configthreadlocale 00a3 __should_initialize_environment 00af ?initialize_environment@@YAXXZ 00b4 ___scrt_initialize_winrt"
	strings:
		$1 = { 55 8B EC 56 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 E8 ?? ?? ?? ?? 8B F0 E8 ?? ?? ?? ?? 89 30 6A 01 E8 ?? ?? ?? ?? 83 C4 04 0F B6 C0 85 C0 75 07 6A 07 E8 ?? ?? ?? ?? DB E2 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 E8 ?? ?? ?? ?? 85 C0 74 07 6A 07 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 0D 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 E8 ?? ?? ?? ?? 0F B6 C8 85 C9 74 05 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5E 5D C3 }
	condition:
		$1
}

rule file_12_0_7 {
	meta:
		name = "?pre_c_initialization@@YAHXZ"
		size = 189
		refs = "0005 ?get_app_type@__scrt_winmain_policy@@SA?AW4_crt_app_type@@XZ 000b __set_app_type 0013 __get_startup_file_mode 0019 __set_fmode 0021 __get_startup_commit_mode 0028 ___p__commode 0031 ___scrt_initialize_onexit_tables 0042 ___scrt_fastfail 0049 __RTC_Initialize 004e __RTC_Terminate 0053 _atexit 005b ?configure_argv@__scrt_wide_argv_policy@@SAHXZ 006b ?__scrt_initialize_type_info@@YAXXZ 0070 ___scrt_is_user_matherr_present 0079 __matherr 007e ___setusermatherr 0086 __initialize_invalid_parameter_handler 008b __initialize_denormal_control 0090 __initialize_default_precision 0095 __get_startup_thread_locale_mode 009b __configthreadlocale 00a3 __should_initialize_environment 00af ?initialize_environment@@YAXXZ 00b4 ___scrt_initialize_winrt"
	strings:
		$1 = { 55 8B EC 56 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 E8 ?? ?? ?? ?? 8B F0 E8 ?? ?? ?? ?? 89 30 6A 01 E8 ?? ?? ?? ?? 83 C4 04 0F B6 C0 85 C0 75 07 6A 07 E8 ?? ?? ?? ?? DB E2 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 E8 ?? ?? ?? ?? 85 C0 74 07 6A 07 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 0D 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 E8 ?? ?? ?? ?? 0F B6 C8 85 C9 74 05 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5E 5D C3 }
	condition:
		$1
}

rule file_350_0_7 {
	meta:
		name = "?pre_c_initialization@@YAHXZ"
		size = 189
		refs = "0005 ?get_app_type@__scrt_winmain_policy@@SA?AW4_crt_app_type@@XZ 000b __set_app_type 0013 __get_startup_file_mode 0019 __set_fmode 0021 __get_startup_commit_mode 0028 ___p__commode 0031 ___scrt_initialize_onexit_tables 0042 ___scrt_fastfail 0049 __RTC_Initialize 004e __RTC_Terminate 0053 _atexit 005b ?configure_argv@__scrt_narrow_argv_policy@@SAHXZ 006b ?__scrt_initialize_type_info@@YAXXZ 0070 ___scrt_is_user_matherr_present 0079 __matherr 007e ___setusermatherr 0086 __initialize_invalid_parameter_handler 008b __initialize_denormal_control 0090 __initialize_default_precision 0095 __get_startup_thread_locale_mode 009b __configthreadlocale 00a3 __should_initialize_environment 00af ?initialize_environment@@YAXXZ 00b4 ___scrt_initialize_winrt"
	strings:
		$1 = { 55 8B EC 56 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 E8 ?? ?? ?? ?? 8B F0 E8 ?? ?? ?? ?? 89 30 6A 01 E8 ?? ?? ?? ?? 83 C4 04 0F B6 C0 85 C0 75 07 6A 07 E8 ?? ?? ?? ?? DB E2 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 E8 ?? ?? ?? ?? 85 C0 74 07 6A 07 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 0D 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 E8 ?? ?? ?? ?? 0F B6 C8 85 C9 74 05 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5E 5D C3 }
	condition:
		$1
}

rule file_116_2_0 {
	meta:
		name = "?pre_cpp_initialization@@YAXXZ"
		size = 24
		refs = "0004 ___scrt_set_unhandled_exception_filter 0009 __get_startup_new_mode 000f __set_new_mode"
	strings:
		$1 = { 55 8B EC E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_116_4_0 {
	meta:
		name = "?__scrt_common_main_seh@@YAHXZ"
		size = 525
		refs = "0006 __sehtable$?__scrt_common_main_seh@@YAHXZ 000b __except_handler4 001d ___security_cookie 0036 ___scrt_initialize_crt 0047 ___scrt_fastfail 0057 ___scrt_acquire_startup_lock 0060 ___scrt_current_native_startup_state 0084 ___xi_z 0089 ___xi_a 008e __initterm_e 00b0 ___xc_z 00b5 ___xc_a 00ba __initterm 00d7 ___scrt_release_startup_lock 00df ___scrt_get_dyn_tls_init_callback 00f3 ___scrt_is_nonwritable_in_current_image 0113 @_guard_check_icall@4 011b ___scrt_get_dyn_tls_dtor_callback 0144 __register_thread_local_exe_atexit_callback 014c ?invoke_main@@YAHXZ 0154 ___scrt_is_managed_app 0164 _exit 0171 __cexit 017a ___scrt_uninitialize_crt 01af __seh_filter_exe 01d1 __exit 01de __c_exit"
	strings:
		$1 = { 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 D0 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 89 65 E8 6A 01 E8 ?? ?? ?? ?? 83 C4 04 0F B6 C0 85 C0 75 07 6A 07 E8 ?? ?? ?? ?? C6 45 E7 00 C7 45 FC 00 00 00 00 E8 ?? ?? ?? ?? 88 45 E6 83 3D ?? ?? ?? ?? 01 75 09 6A 07 E8 ?? ?? ?? ?? EB 61 83 3D ?? ?? ?? ?? 00 75 54 C7 05 ?? ?? ?? ?? 01 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 16 C7 45 C8 FF 00 00 00 C7 45 FC FE FF FF FF 8B 45 C8 E9 4C 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 08 C7 05 ?? ?? ?? ?? 02 00 00 00 EB 04 C6 45 E7 01 0F B6 4D E6 51 E8 ?? ?? ?? ?? 83 C4 04 E8 ?? ?? ?? ?? 89 45 E0 8B 55 E0 83 3A 00 74 2C 8B 45 E0 50 E8 ?? ?? ?? ?? 83 C4 04 0F B6 C8 85 C9 74 19 6A 00 6A 02 6A 00 8B 55 E0 8B 02 89 45 D8 8B 4D D8 E8 ?? ?? ?? ?? FF 55 D8 E8 ?? ?? ?? ?? 89 45 DC 8B 4D DC 83 39 00 74 21 8B 55 DC 52 E8 ?? ?? ?? ?? 83 C4 04 0F B6 C0 85 C0 74 0E 8B 4D DC 8B 11 52 E8 ?? ?? ?? ?? 83 C4 04 E8 ?? ?? ?? ?? 89 45 D4 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 09 8B 4D D4 51 E8 ?? ?? ?? ?? 0F B6 55 E7 85 D2 75 05 E8 ?? ?? ?? ?? 6A 00 6A 01 E8 ?? ?? ?? ?? 83 C4 08 8B 45 D4 89 45 C4 C7 45 FC FE FF FF FF 8B 45 C4 EB 68 C7 45 FC FE FF FF FF EB 5F 8B 4D EC 8B 11 8B 02 89 45 D0 8B 4D EC 51 8B 55 D0 52 E8 ?? ?? ?? ?? 83 C4 08 C3 8B 65 E8 8B 45 D0 89 45 CC E8 ?? ?? ?? ?? 0F B6 C8 85 C9 75 09 8B 55 CC 52 E8 ?? ?? ?? ?? 0F B6 45 E7 85 C0 75 05 E8 ?? ?? ?? ?? 8B 4D CC 89 4D C0 C7 45 FC FE FF FF FF 8B 45 C0 EB 07 C7 45 FC FE FF FF FF 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_116_5_0 {
	meta:
		name = "?configure_argv@__scrt_narrow_argv_policy@@SAHXZ"
		size = 19
		refs = "0004 __get_startup_argv_mode 000a __configure_narrow_argv"
	strings:
		$1 = { 55 8B EC E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_215_5_0 {
	meta:
		name = "?configure_argv@__scrt_wide_argv_policy@@SAHXZ"
		size = 19
		refs = "0004 __get_startup_argv_mode 000a __configure_wide_argv"
	strings:
		$1 = { 55 8B EC E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_6_1_4 {
	meta:
		name = "__get_unexpected"
		size = 19
		refs = "0004 ___vcrt_getptd 000a ?get_unexpected_or_default@@YAP6AXXZQBU__vcrt_ptd@@@Z"
	strings:
		$1 = { 55 8B EC E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_116_8_0 {
	meta:
		name = "?invoke_main@@YAHXZ"
		size = 35
		refs = "0004 __get_initial_narrow_environment 000a ___p___argv 0012 ___p___argc 001a _main"
	strings:
		$1 = { 55 8B EC E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B 00 50 E8 ?? ?? ?? ?? 8B 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_282_8_0 {
	meta:
		name = "?invoke_main@@YAHXZ"
		size = 35
		refs = "0004 __get_initial_wide_environment 000a ___p___wargv 0012 ___p___argc 001a _wmain"
	strings:
		$1 = { 55 8B EC E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B 00 50 E8 ?? ?? ?? ?? 8B 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_117_0_0 {
	meta:
		name = "___sse2_logf4"
		size = 272
		refs = "0014 _static_const_table"
	strings:
		$1 = { 8B C4 83 EC 60 83 E4 F0 89 44 24 24 66 0F 6F E0 66 0F 6F 15 ?? ?? ?? ?? 0F 28 F0 66 0F 6F 0D ?? ?? ?? ?? 66 0F 6F 1D ?? ?? ?? ?? 66 0F DB 25 ?? ?? ?? ?? 66 0F 66 D8 66 0F FE D4 66 0F DB 15 ?? ?? ?? ?? 66 0F EF CA 66 0F 72 E2 17 66 0F EB E1 66 0F 6F C8 66 0F 72 E1 17 66 0F 66 05 ?? ?? ?? ?? 66 0F FA 0D ?? ?? ?? ?? 66 0F DB D8 66 0F 6F C1 66 0F FE C2 0F 28 D4 0F 28 0D ?? ?? ?? ?? 0F 5C 15 ?? ?? ?? ?? 66 0F D7 D3 0F 28 1D ?? ?? ?? ?? 0F 58 CA 0F 28 25 ?? ?? ?? ?? 0F 28 EA 0F 5E D1 0F 5B C0 0F 28 CA 0F 59 D2 0F 28 FA 0F 59 D2 0F 59 DA 0F 59 E2 0F 58 1D ?? ?? ?? ?? 0F 59 DF 0F 58 DC 0F 59 05 ?? ?? ?? ?? 0F 28 D5 0F 5C EB 0F 59 E9 0F 5C EA 0F 5C C5 81 FA FF FF 00 00 75 02 EB 1E BA 0C 00 00 00 0F 29 34 24 D9 ED D9 04 14 D9 F1 D9 1C 14 83 EA 04 79 F1 0F 28 04 24 EB E0 8B 64 24 24 C3 8D A4 24 00 00 00 00 8D 49 00 }
	condition:
		$1
}

rule file_118_0_0 {
	meta:
		name = "___sse2_tanf4"
		size = 512
		refs = "0019 _static_const_table 0131 ___common_pi04_reduction_LA"
	strings:
		$1 = { 8B C4 81 EC 90 00 00 00 83 E4 F0 89 44 24 54 0F 28 C8 0F 28 F0 66 0F DB 05 ?? ?? ?? ?? 66 0F DB 0D ?? ?? ?? ?? 0F 28 D0 0F 28 F8 0F 59 05 ?? ?? ?? ?? 66 0F 66 3D ?? ?? ?? ?? 0F 50 C7 0B C0 0F 85 BB 00 00 00 0F 28 25 ?? ?? ?? ?? 0F 28 2D ?? ?? ?? ?? 0F 58 05 ?? ?? ?? ?? 0F 28 D8 0F 5C 05 ?? ?? ?? ?? 0F 28 35 ?? ?? ?? ?? 0F 28 3D ?? ?? ?? ?? 0F 59 E0 0F 59 E8 0F 59 F0 0F 59 F8 66 0F 6F C3 66 0F 72 F0 1F 0F 57 C1 0F 5C D4 0F 28 25 ?? ?? ?? ?? 0F 5C D5 0F 28 2D ?? ?? ?? ?? 0F 5C D6 0F 5C D7 66 0F 72 F3 1E 0F 57 C9 0F C2 D9 04 0F 28 CA 0F 59 D2 0F 59 E2 0F 59 EA 0F 58 25 ?? ?? ?? ?? 0F 58 2D ?? ?? ?? ?? 0F 59 E1 0F 59 EA 0F 58 2D ?? ?? ?? ?? 0F 28 CB 0F 28 D3 0F 54 CC 0F 55 D5 0F 56 CA 0F 28 F3 0F 28 FB 0F 55 F4 0F 54 FD 0F 56 F7 0F 5E F1 0F 57 C6 E9 EC 00 00 00 66 0F 6F CE 66 0F DB 35 ?? ?? ?? ?? 66 0F DB 0D ?? ?? ?? ?? F3 0F 7F 34 24 F3 0F 7F 4C 24 30 D9 04 24 83 EC 20 DD 1C 24 8D 44 24 10 89 44 24 08 E8 ?? ?? ?? ?? DD 44 24 10 83 C4 20 D9 5C 24 10 89 44 24 20 D9 44 24 04 83 EC 20 DD 1C 24 8D 44 24 10 89 44 24 08 E8 ?? ?? ?? ?? DD 44 24 10 83 C4 20 D9 5C 24 14 89 44 24 24 D9 44 24 08 83 EC 20 DD 1C 24 8D 44 24 10 89 44 24 08 E8 ?? ?? ?? ?? DD 44 24 10 83 C4 20 D9 5C 24 18 89 44 24 28 D9 44 24 0C 83 EC 20 DD 1C 24 8D 44 24 10 89 44 24 08 E8 ?? ?? ?? ?? DD 44 24 10 83 C4 20 D9 5C 24 1C 89 44 24 2C 0F 10 54 24 10 0F 10 5C 24 20 0F 28 C3 66 0F 72 F0 1F 0F 57 44 24 30 66 0F 72 F3 1E 0F 57 C9 0F C2 D9 04 0F 28 25 ?? ?? ?? ?? 0F 28 2D ?? ?? ?? ?? E9 C4 FE FF FF 8B 64 24 54 C3 8D A4 24 00 00 00 00 8D A4 24 00 00 00 00 90 }
	condition:
		$1
}

rule file_121_0_0 {
	meta:
		name = "___sse2_log2"
		size = 464
		refs = "005a _static_const_table"
	strings:
		$1 = { 8B C4 83 EC 70 83 E4 F0 89 44 24 34 89 1C 24 89 4C 24 04 66 0F 28 F8 66 0F 28 F0 66 0F 73 D7 20 66 0F 7E F8 8B C8 0F C6 FF 02 66 0F 7E FA 8B DA C1 E8 09 25 F0 07 00 00 83 C0 10 25 E0 0F 00 00 C1 EA 09 81 E2 F0 07 00 00 83 C2 10 81 E2 E0 0F 00 00 66 0F 28 C8 66 0F DB 05 ?? ?? ?? ?? 66 0F EB 05 ?? ?? ?? ?? 66 0F 28 15 ?? ?? ?? ?? 66 0F 28 1D ?? ?? ?? ?? 66 0F 70 C9 0D 66 0F 72 D1 14 66 0F FA 0D ?? ?? ?? ?? F3 0F E6 C9 66 0F 54 D8 66 0F 5C C3 66 0F 59 D1 66 0F 59 0D ?? ?? ?? ?? F3 0F 7E A0 ?? ?? ?? ?? 66 0F 16 A2 ?? ?? ?? ?? 81 E9 00 00 10 00 81 F9 00 00 E0 7F 0F 83 D0 00 00 00 81 EB 00 00 10 00 81 FB 00 00 E0 7F 0F 83 BE 00 00 00 66 0F 59 DC 66 0F 59 C4 66 0F 28 B8 ?? ?? ?? ?? 66 0F 28 EF 66 0F 28 B2 ?? ?? ?? ?? 66 0F 14 FE 66 0F 15 EE 66 0F 58 FA 66 0F 28 E7 66 0F C2 25 ?? ?? ?? ?? 00 66 0F 58 E9 66 0F 5C 1D ?? ?? ?? ?? 66 0F 54 E0 66 0F 58 FB 66 0F 58 FC 66 0F 55 E0 66 0F 58 C3 66 0F 28 15 ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 28 C8 66 0F 59 C0 66 0F 59 F0 66 0F 59 D0 66 0F 58 35 ?? ?? ?? ?? 66 0F 58 15 ?? ?? ?? ?? 66 0F 59 F0 66 0F 59 D0 66 0F 58 35 ?? ?? ?? ?? 66 0F 58 15 ?? ?? ?? ?? 66 0F 59 F1 66 0F 58 F2 66 0F 59 C6 66 0F 58 C5 66 0F 58 C4 66 0F 58 C7 8B 4C 24 04 8B 1C 24 EB 2B 66 0F 29 74 24 10 D9 ED DD 44 24 10 D9 F1 8B 4C 24 04 DD 5C 24 10 D9 ED DD 44 24 18 D9 F1 8B 1C 24 DD 5C 24 18 66 0F 28 44 24 10 8B 64 24 34 C3 8D A4 24 00 00 00 00 8D A4 24 00 00 00 00 }
	condition:
		$1
}

rule file_130_0_0 {
	meta:
		name = "___common_ssin_cout_rare"
		size = 96
		altNames = "___common_scos_cout_rare"
	strings:
		$1 = { 56 8B 54 24 08 8B 02 0F B7 4A 02 89 04 24 81 E1 80 7F 00 00 C1 E8 18 83 E0 7F F3 0F 10 0A 81 F9 80 7F 00 00 75 30 88 44 24 03 8B 54 24 0C 81 3C 24 00 00 80 7F 75 13 B8 01 00 00 00 66 0F EF C0 F3 0F 59 C8 F3 0F 11 0A 59 C3 F3 0F 59 C9 33 C0 F3 0F 11 0A 59 C3 33 C0 59 C3 8D 9B 00 00 00 00 }
	condition:
		$1
}

rule file_142_0_0 {
	meta:
		name = "@__security_check_cookie@4"
		size = 17
		refs = "0002 ___security_cookie 000d ___report_gsfailure"
	strings:
		$1 = { 3B 0D ?? ?? ?? ?? F2 75 02 F2 C3 F2 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_147_0_0 {
	meta:
		name = "___avx_log104"
		size = 416
		refs = "0010 ___common_dlog10_data 0197 ___common_dlog10_cout_rare"
	strings:
		$1 = { 55 8B EC 83 E4 C0 81 EC C0 00 00 00 C5 FD 54 0D ?? ?? ?? ?? C5 F5 56 25 ?? ?? ?? ?? C5 FD 5A F4 C5 F8 53 FE C5 FC 5A D7 C5 D1 73 D0 14 C4 E3 7D 19 C3 01 C5 F1 73 D3 14 C5 FD C2 3D ?? ?? ?? ?? 11 C5 D0 C6 F1 DD C5 FD C2 0D ?? ?? ?? ?? 16 C4 E3 7D 09 EA 00 C5 FE E6 DE C5 C5 56 D1 C5 DD 54 35 ?? ?? ?? ?? C5 DD 5C E6 C5 DD 59 E5 C4 E3 7D 19 D7 01 C5 E8 C6 CF DD C5 CD 59 FD C5 F8 50 C1 C5 C5 5C 15 ?? ?? ?? ?? C5 ED 58 CC C5 E9 73 D5 28 C5 F9 7E D2 C4 E3 79 16 D1 02 C4 E3 7D 19 EE 01 C5 C1 73 D6 28 C5 FB 10 A2 ?? ?? ?? ?? C5 F9 7E FA C5 D9 16 B1 ?? ?? ?? ?? C5 D5 C2 2D ?? ?? ?? ?? 1E C5 FB 10 92 ?? ?? ?? ?? C4 E3 79 16 F9 02 C5 E9 16 B9 ?? ?? ?? ?? C4 E3 4D 18 D7 01 C5 D5 54 3D ?? ?? ?? ?? C5 C5 56 2D ?? ?? ?? ?? C5 E5 5C DD C5 F5 59 2D ?? ?? ?? ?? C5 E5 59 3D ?? ?? ?? ?? C5 F5 59 1D ?? ?? ?? ?? C5 D5 58 25 ?? ?? ?? ?? C5 F5 59 E9 C5 E5 58 35 ?? ?? ?? ?? C5 F5 59 1D ?? ?? ?? ?? C5 CD 59 CD C5 F5 58 CC C5 F5 59 E5 C5 DD 58 DB C5 E5 58 D2 C5 ED 58 CF 85 C0 75 08 C5 FD 28 C1 8B E5 5D C3 C5 FD 11 44 24 40 C5 FD 11 8C 24 80 00 00 00 74 E7 33 D2 89 74 24 04 8B F2 89 3C 24 8B F8 0F A3 F7 72 18 46 83 FE 20 7C F5 8B 74 24 04 8B 3C 24 C5 FD 10 8C 24 80 00 00 00 EB BD C5 F8 77 8D 8C F4 80 00 00 00 8D 44 F4 40 51 50 E8 ?? ?? ?? ?? 83 C4 08 EB CE }
	condition:
		$1
}

rule file_153_0_0 {
	meta:
		name = "__allshr"
		size = 33
	strings:
		$1 = { 80 F9 40 73 16 80 F9 20 73 06 0F AD D0 D3 FA C3 8B C2 C1 FA 1F 80 E1 1F D3 F8 C3 C1 FA 1F 8B C2 C3 }
	condition:
		$1
}

rule file_160_0_0 {
	meta:
		name = "___sse2_sinhf4"
		size = 320
		refs = "0012 ___common_ssinh_data 0130 ___common_ssinh_cout_rare"
	strings:
		$1 = { 55 8B EC 83 E4 C0 81 EC C0 00 00 00 0F 28 F0 0F 28 05 ?? ?? ?? ?? 0F 54 C6 0F 28 D8 0F 28 25 ?? ?? ?? ?? 66 0F EF DE 0F 59 E3 0F 28 FB 0F 28 2D ?? ?? ?? ?? 66 0F 66 3D ?? ?? ?? ?? 0F 58 E5 0F 50 D7 0F 28 FC 66 0F 72 F4 17 0F 29 34 24 85 D2 0F 28 35 ?? ?? ?? ?? 0F 5C FD 0F 28 2D ?? ?? ?? ?? 0F 59 EF 0F 59 F7 0F 5C DD 66 0F 6F 15 ?? ?? ?? ?? 0F 5C DE 0F 28 EB 66 0F 6F F2 0F 59 EB 66 0F FE F4 66 0F FA D4 66 0F 6F E6 0F 28 0D ?? ?? ?? ?? 0F 58 E2 0F 59 CD 0F 5C F2 0F 28 15 ?? ?? ?? ?? 0F 59 D5 0F 58 0D ?? ?? ?? ?? 0F 59 CD 0F 58 15 ?? ?? ?? ?? 0F 59 D5 0F 59 CB 0F 58 15 ?? ?? ?? ?? 0F 58 CB 0F 59 D5 0F 59 E1 0F 59 D6 0F 58 E2 0F 58 E6 0F 56 C4 75 04 8B E5 5D C3 0F 28 0C 24 0F 29 4C 24 40 0F 29 84 24 80 00 00 00 74 E9 33 C0 89 74 24 04 8B F0 89 3C 24 8B FA 8B CE B8 01 00 00 00 D3 E0 85 F8 75 17 46 83 FE 20 7C ED 8B 74 24 04 8B 3C 24 0F 28 84 24 80 00 00 00 EB B8 8D 8C B4 80 00 00 00 8D 44 B4 40 51 50 E8 ?? ?? ?? ?? 83 C4 08 EB D2 8D A4 24 00 00 00 00 }
	condition:
		$1
}

rule file_163_0_0 {
	meta:
		name = "___avx_acosf8"
		size = 368
		refs = "0010 ___common_sacos_data 015f ___common_sacos_cout_rare"
	strings:
		$1 = { 55 8B EC 83 E4 C0 81 EC C0 00 00 00 C5 FC 10 1D ?? ?? ?? ?? C5 FC 10 2D ?? ?? ?? ?? C5 E4 56 E0 C5 DC 59 FD C5 DC 59 F4 C5 C4 58 D5 C5 E4 54 C8 C5 DC C2 1D ?? ?? ?? ?? 12 C5 FC 11 0C 24 C5 CC 5D CA C5 C9 EF F6 C4 E3 7D 19 DF 01 C5 E1 6B EF C5 FC 52 FA C5 D1 63 DE C5 F9 D7 D3 C5 F4 C2 DA 15 C5 EC 58 D2 C5 C4 59 EF C5 EC 59 F7 C5 EC 59 D5 C5 EC 5C 2D ?? ?? ?? ?? C5 D4 59 3D ?? ?? ?? ?? C5 C4 58 15 ?? ?? ?? ?? C5 CC 59 FD C5 EC 59 EF C5 CC 5C D5 C5 F4 59 35 ?? ?? ?? ?? C4 E3 5D 4A E2 30 C5 CC 58 2D ?? ?? ?? ?? C5 F4 59 35 ?? ?? ?? ?? C5 CC 58 3D ?? ?? ?? ?? C5 F4 59 F1 C5 D4 59 EE C5 D4 58 FF C5 C4 59 E9 C5 D4 58 35 ?? ?? ?? ?? C5 FC C2 E9 11 C5 CC 59 F1 C5 E4 54 0D ?? ?? ?? ?? C5 F4 54 FD C5 E4 55 0D ?? ?? ?? ?? C5 F4 58 EF C5 DC 57 0C 24 C5 CC 59 F1 C5 CC 58 D1 C5 D4 58 CA 84 D2 75 08 C5 FC 28 C1 8B E5 5D C3 C5 FC 11 44 24 40 C5 FC 11 8C 24 80 00 00 00 85 D2 74 E5 33 C0 89 74 24 04 8B F0 89 3C 24 8B FA 0F A3 F7 72 18 46 83 FE 20 7C F5 8B 74 24 04 8B 3C 24 C5 FC 10 8C 24 80 00 00 00 EB BB C5 F8 77 8D 8C B4 80 00 00 00 8D 44 B4 40 51 50 E8 ?? ?? ?? ?? 83 C4 08 EB CE 8D A4 24 00 00 00 00 90 }
	condition:
		$1
}

rule file_164_0_0 {
	meta:
		name = "___common_dtanh_cout_rare"
		size = 128
		refs = "001a __imldTanhHATab"
	strings:
		$1 = { 8B 54 24 04 8B 44 24 08 0F B6 4A 07 81 E1 80 00 00 00 C1 E9 07 F2 0F 10 04 CD ?? ?? ?? ?? 0F B7 4A 06 81 E1 F0 7F 00 00 C1 E9 04 81 F9 FF 07 00 00 74 29 81 F9 FE 07 00 00 75 06 F2 0F 11 00 EB 18 F2 0F 10 0A F2 0F 10 05 ?? ?? ?? ?? F2 0F 58 C1 F2 0F 59 C8 F2 0F 11 08 33 C0 C3 F7 42 04 FF FF 0F 00 75 0B 83 3A 00 75 06 F2 0F 11 00 EB E9 F2 0F 10 02 F2 0F 58 C0 F2 0F 11 00 EB DB 8B FF }
	condition:
		$1
}

rule file_166_0_0 {
	meta:
		name = "___common_ssinh_cout_rare"
		size = 1920
		refs = "0011 __vmldSinhHATab 00ff _2il0floatpacket_89"
	strings:
		$1 = { 55 8B EC 83 E4 F8 56 83 EC 7C 8B 4D 08 F2 0F 10 15 ?? ?? ?? ?? 0F B7 05 ?? ?? ?? ?? 0F B7 51 02 81 E2 80 7F 00 00 F3 0F 10 19 81 FA 80 7F 00 00 0F 84 28 07 00 00 F3 0F 5A DB F2 0F 11 5C 24 70 0F B7 54 24 76 81 E2 F0 7F 00 00 F2 0F 11 5C 24 10 C1 EA 04 80 64 24 17 7F 85 D2 0F 8E C2 06 00 00 81 FA C9 03 00 00 0F 8E 8D 06 00 00 F2 0F 10 44 24 10 F2 0F 10 0D ?? ?? ?? ?? 66 0F 2F C8 0F 86 51 06 00 00 F2 0F 10 0D ?? ?? ?? ?? 66 0F 2F C8 0F 86 F1 04 00 00 66 0F 2F 05 ?? ?? ?? ?? 0F 82 71 04 00 00 F2 0F 10 3D ?? ?? ?? ?? 25 0F 80 FF FF F2 0F 59 F8 F2 0F 10 0D ?? ?? ?? ?? F2 0F 11 54 24 68 F2 0F 58 3D ?? ?? ?? ?? F2 0F 11 7C 24 50 F2 0F 10 64 24 50 8B 4C 24 50 8B D1 C1 EA 06 83 E1 3F 81 C2 FF 03 00 00 F2 0F 5C 25 ?? ?? ?? ?? F2 0F 59 CC 81 E2 FF 07 00 00 0F 57 25 ?? ?? ?? ?? 8D 72 FF F2 0F 59 25 ?? ?? ?? ?? F2 0F 5C C1 0F 28 D0 0F 28 D8 C1 E1 04 81 E6 FF 07 00 00 F7 DA F2 0F 58 D4 F2 0F 11 54 24 60 83 C2 FC F2 0F 10 6C 24 60 81 E2 FF 07 00 00 C1 E6 04 F2 0F 5C DD F2 0F 11 1C 24 0B C6 F2 0F 10 6C 24 60 F2 0F 10 34 24 66 89 44 24 6E 25 0F 80 FF FF C1 E2 04 F2 0F 58 EE F2 0F 11 6C 24 08 0B C2 F2 0F 10 3C 24 F2 0F 58 E7 F2 0F 11 24 24 F2 0F 10 64 24 08 F2 0F 5C C4 F2 0F 10 25 ?? ?? ?? ?? F2 0F 11 44 24 08 F2 0F 10 34 24 F2 0F 10 44 24 08 F2 0F 58 F0 F2 0F 11 74 24 08 F2 0F 10 74 24 60 0F 28 FE F2 0F 59 FC F2 0F 10 6C 24 08 F2 0F 11 7C 24 60 F2 0F 10 4C 24 60 F2 0F 11 74 24 10 F2 0F 5C CE F2 0F 11 0C 24 F2 0F 10 54 24 60 F2 0F 10 04 24 F2 0F 10 0D ?? ?? ?? ?? F2 0F 5C D0 F2 0F 11 54 24 60 0F 28 D6 F2 0F 59 D6 F2 0F 59 CA F2 0F 11 6C 24 18 0F 28 EE F2 0F 10 5C 24 60 F2 0F 58 0D ?? ?? ?? ?? F2 0F 5C EB F2 0F 59 CA F2 0F 59 CE F2 0F 10 35 ?? ?? ?? ?? F2 0F 59 F2 F2 0F 11 2C 24 F2 0F 10 7C 24 60 F2 0F 10 04 24 F2 0F 11 44 24 28 F2 0F 10 81 ?? ?? ?? ?? F2 0F 10 5C 24 68 66 89 44 24 6E F2 0F 11 4C 24 30 F2 0F 59 C3 F2 0F 58 35 ?? ?? ?? ?? F2 0F 59 F2 0F 28 E8 F2 0F 11 7C 24 20 0F B6 44 24 77 83 E0 80 F2 0F 58 35 ?? ?? ?? ?? F2 0F 59 F2 F2 0F 10 91 ?? ?? ?? ?? F7 D9 F2 0F 11 74 24 38 F2 0F 10 74 24 68 F2 0F 59 D3 F2 0F 10 89 ?? ?? ?? ?? F2 0F 59 CE F2 0F 10 99 ?? ?? ?? ?? F2 0F 5C E9 F2 0F 59 DE F2 0F 11 6C 24 60 0F 28 F0 F2 0F 10 7C 24 60 F2 0F 5C F7 F2 0F 5C F1 F2 0F 11 34 24 F2 0F 10 74 24 60 F2 0F 10 2C 24 0F 28 FE F2 0F 5C EB F2 0F 58 EA F2 0F 58 D3 F2 0F 58 FD F2 0F 11 7C 24 60 F2 0F 10 7C 24 60 F2 0F 5C F7 0F 28 F8 F2 0F 58 F9 F2 0F 58 F5 F2 0F 11 34 24 F2 0F 10 6C 24 60 F2 0F 10 34 24 F2 0F 11 7C 24 60 F2 0F 10 7C 24 60 F2 0F 5C C7 F2 0F 58 C1 F2 0F 11 04 24 F2 0F 10 7C 24 60 F2 0F 10 04 24 0F 28 CF F2 0F 58 D0 F2 0F 58 CA F2 0F 11 4C 24 60 F2 0F 10 5C 24 60 F2 0F 5C FB F2 0F 58 FA F2 0F 11 3C 24 F2 0F 10 7C 24 60 F2 0F 59 E7 0F 28 DF F2 0F 10 0C 24 F2 0F 11 64 24 60 F2 0F 10 64 24 60 F2 0F 5C E7 F2 0F 11 24 24 F2 0F 10 44 24 60 F2 0F 10 24 24 F2 0F 5C C4 F2 0F 11 44 24 60 F2 0F 10 54 24 60 F2 0F 5C DA F2 0F 11 1C 24 F2 0F 10 64 24 60 F2 0F 10 04 24 F2 0F 11 44 24 48 F2 0F 10 5C 24 18 F2 0F 10 44 24 30 0F 28 D3 F2 0F 11 64 24 40 0F 28 E0 F2 0F 59 D1 F2 0F 59 E1 F2 0F 59 C7 F2 0F 59 DF F2 0F 58 D4 F2 0F 10 64 24 38 0F 28 F8 F2 0F 59 E6 F2 0F 58 D4 F2 0F 10 64 24 10 F2 0F 59 E1 F2 0F 58 D4 F2 0F 10 64 24 38 F2 0F 59 E5 F2 0F 58 D3 F2 0F 58 FC F2 0F 58 F2 F2 0F 11 7C 24 60 F2 0F 10 4C 24 60 F2 0F 10 5C 24 48 F2 0F 5C C1 F2 0F 10 4C 24 28 F2 0F 58 C4 F2 0F 11 04 24 0F 28 C1 F2 0F 10 64 24 60 F2 0F 10 14 24 F2 0F 59 C3 F2 0F 58 F2 F2 0F 10 7C 24 20 F2 0F 58 F0 F2 0F 59 DF F2 0F 10 54 24 40 0F 28 C4 F2 0F 59 FA F2 0F 58 F3 F2 0F 59 CA F2 0F 58 C7 F2 0F 58 F1 F2 0F 11 44 24 60 0F 28 C5 F2 0F 10 4C 24 60 F2 0F 5C F9 F2 0F 58 FC F2 0F 11 3C 24 F2 0F 10 4C 24 60 F2 0F 10 3C 24 F2 0F 58 C1 F2 0F 58 F7 F2 0F 11 44 24 60 F2 0F 10 7C 24 60 F2 0F 5C EF F2 0F 58 E9 F2 0F 11 2C 24 F2 0F 10 44 24 60 F2 0F 10 2C 24 F2 0F 58 F5 F2 0F 58 F0 F2 0F 11 74 24 58 0F B6 54 24 5F 83 E2 7F 0B D0 88 54 24 5F F2 0F 5A 74 24 58 8B 45 0C F3 0F 11 30 33 C0 83 C4 7C 5E 8B E5 5D C3 0F 28 D0 F2 0F 59 D0 F2 0F 10 0D ?? ?? ?? ?? F2 0F 59 CA 0F B6 74 24 77 83 E6 80 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CA 8B 55 0C F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CA F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 D1 F2 0F 59 D0 F2 0F 58 C2 F2 0F 11 44 24 58 0F B6 44 24 5F 83 E0 7F 0B C6 88 44 24 5F 33 C0 F2 0F 5A 44 24 58 F3 0F 11 02 83 C4 7C 5E 8B E5 5D C3 F2 0F 10 0D ?? ?? ?? ?? F2 0F 59 C8 F2 0F 11 54 24 68 F2 0F 10 15 ?? ?? ?? ?? F2 0F 10 1D ?? ?? ?? ?? F2 0F 58 0D ?? ?? ?? ?? F2 0F 11 4C 24 50 F2 0F 10 64 24 50 F2 0F 10 0D ?? ?? ?? ?? 8B 4C 24 50 8B D1 83 E2 3F F2 0F 5C 25 ?? ?? ?? ?? F2 0F 59 D4 F2 0F 59 E3 F2 0F 5C C2 C1 E2 04 F2 0F 5C C4 F2 0F 59 C8 C1 E9 06 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 C8 81 C1 FE 03 00 00 81 E1 FF 07 00 00 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 C8 81 F9 FE 07 00 00 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 C8 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 C8 F2 0F 59 C8 F2 0F 58 C8 F2 0F 10 82 ?? ?? ?? ?? F2 0F 59 C8 F2 0F 58 8A ?? ?? ?? ?? F2 0F 58 C8 77 21 C1 E1 04 25 0F 80 FF FF 0B C1 66 89 44 24 6E F2 0F 10 44 24 68 F2 0F 59 C8 F2 0F 11 4C 24 58 EB 33 49 81 E1 FF 07 00 00 0F B7 44 24 6E C1 E1 04 25 0F 80 FF FF 0B C1 66 89 44 24 6E F2 0F 10 44 24 68 F2 0F 59 C8 F2 0F 59 0D ?? ?? ?? ?? F2 0F 11 4C 24 58 0F B6 44 24 5F 0F B6 74 24 77 83 E0 7F 83 E6 80 0B C6 88 44 24 5F 33 C0 F2 0F 5A 44 24 58 8B 55 0C F3 0F 11 02 83 C4 7C 5E 8B E5 5D C3 F2 0F 10 05 ?? ?? ?? ?? F2 0F 59 C3 F2 0F 5A C0 8B 45 0C F3 0F 11 00 B8 03 00 00 00 83 C4 7C 5E 8B E5 5D C3 F2 0F 10 05 ?? ?? ?? ?? 8B 45 0C F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C3 F2 0F 5A C0 F3 0F 11 00 33 C0 83 C4 7C 5E 8B E5 5D C3 F2 0F 10 05 ?? ?? ?? ?? F2 0F 59 D8 F2 0F 11 5C 24 60 F2 0F 11 54 24 68 F3 0F 5A 11 F2 0F 10 4C 24 60 8B 45 0C F2 0F 58 D1 F2 0F 5A D2 F3 0F 11 10 33 C0 83 C4 7C 5E 8B E5 5D C3 8B 45 0C F3 0F 58 DB F3 0F 11 18 33 C0 83 C4 7C 5E 8B E5 5D C3 8D A4 24 00 00 00 00 8D 9B 00 00 00 00 }
	condition:
		$1
}

rule file_167_0_0 {
	meta:
		name = "?dllmain_crt_dispatch@@YGHQAUHINSTANCE__@@KQAX@Z"
		size = 124
		refs = "0018 $LN11 0025 ?dllmain_crt_process_attach@@YAHQAUHINSTANCE__@@QAX@Z 0044 ?dllmain_crt_process_detach@@YAH_N@Z 004e ___scrt_dllmain_crt_thread_attach 0058 ___scrt_dllmain_crt_thread_detach 006c $LN5 0070 $LN4 0074 $LN6 0078 $LN7"
	strings:
		$1 = { 55 8B EC 83 EC 08 8B 45 0C 89 45 F8 83 7D F8 03 77 4F 8B 4D F8 FF 24 8D ?? ?? ?? ?? 8B 55 10 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 EB 38 83 7D 10 00 74 06 C6 45 FF 01 EB 04 C6 45 FF 00 0F B6 4D FF 51 E8 ?? ?? ?? ?? 83 C4 04 EB 19 E8 ?? ?? ?? ?? 0F B6 C0 EB 0F E8 ?? ?? ?? ?? 0F B6 C0 EB 05 B8 01 00 00 00 8B E5 5D C2 0C 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_167_1_0 {
	meta:
		name = "?dllmain_crt_process_attach@@YAHQAUHINSTANCE__@@QAX@Z"
		size = 382
		refs = "0006 __sehtable$?dllmain_crt_process_attach@@YAHQAUHINSTANCE__@@QAX@Z 000b __except_handler4 001d ___security_cookie 0033 ___scrt_initialize_crt 0049 ___scrt_acquire_startup_lock 005d ___scrt_current_native_startup_state 0067 ___scrt_fastfail 0076 ___scrt_dllmain_before_initialize_c 0084 __RTC_Initialize 0089 __RTC_Terminate 008e _atexit 0096 ?__scrt_initialize_type_info@@YAXXZ 009b ?__scrt_uninitialize_type_info@@YAXXZ 00a8 ___scrt_initialize_default_local_stdio_options 00ad ___xi_z 00b2 ___xi_a 00b7 __initterm_e 00c5 ___scrt_dllmain_after_initialize_c 00d3 ___xc_z 00d8 ___xc_a 00dd __initterm 0106 ___scrt_release_startup_lock 011b ___scrt_get_dyn_tls_init_callback 012f ___scrt_is_nonwritable_in_current_image 0153 @_guard_check_icall@4 015b ?__proc_attached@@3HA"
	strings:
		$1 = { 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 EC 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 6A 00 E8 ?? ?? ?? ?? 83 C4 04 0F B6 C0 85 C0 75 07 33 C0 E9 24 01 00 00 E8 ?? ?? ?? ?? 88 45 E6 C6 45 E7 01 C7 45 FC 00 00 00 00 83 3D ?? ?? ?? ?? 00 74 07 6A 07 E8 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 01 00 00 00 E8 ?? ?? ?? ?? 0F B6 C8 85 C9 75 02 EB 6F E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 02 EB 2E E8 ?? ?? ?? ?? 0F B6 D0 85 D2 75 02 EB 20 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 08 C7 05 ?? ?? ?? ?? 02 00 00 00 C6 45 E7 00 C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0E 0F B6 45 E6 50 E8 ?? ?? ?? ?? 83 C4 04 C3 0F B6 4D E7 85 C9 74 04 33 C0 EB 52 E8 ?? ?? ?? ?? 89 45 E0 8B 55 E0 83 3A 00 74 30 8B 45 E0 50 E8 ?? ?? ?? ?? 83 C4 04 0F B6 C8 85 C9 74 1D 8B 55 0C 52 6A 02 8B 45 08 50 8B 4D E0 8B 11 89 55 DC 8B 4D DC E8 ?? ?? ?? ?? FF 55 DC A1 ?? ?? ?? ?? 83 C0 01 A3 ?? ?? ?? ?? B8 01 00 00 00 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_167_2_0 {
	meta:
		name = "?dllmain_crt_process_detach@@YAH_N@Z"
		size = 202
		refs = "0006 __sehtable$?dllmain_crt_process_detach@@YAH_N@Z 000b __except_handler4 001d ___security_cookie 0032 ?__proc_attached@@3HA 004b ___scrt_acquire_startup_lock 005b ___scrt_current_native_startup_state 0065 ___scrt_fastfail 006a ___scrt_dllmain_uninitialize_c 0087 ___scrt_dllmain_uninitialize_critical 0091 ___scrt_release_startup_lock 00a1 ___scrt_uninitialize_crt"
	strings:
		$1 = { 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 F4 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 83 3D ?? ?? ?? ?? 00 7F 04 33 C0 EB 7B A1 ?? ?? ?? ?? 83 E8 01 A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? 88 45 E7 C7 45 FC 00 00 00 00 83 3D ?? ?? ?? ?? 02 74 07 6A 07 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 00 00 00 00 C7 45 FC FE FF FF FF E8 02 00 00 00 EB 13 E8 ?? ?? ?? ?? 0F B6 4D E7 51 E8 ?? ?? ?? ?? 83 C4 04 C3 6A 00 0F B6 55 08 52 E8 ?? ?? ?? ?? 83 C4 08 0F B6 C0 85 C0 75 04 33 C0 EB 05 B8 01 00 00 00 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_167_3_0 {
	meta:
		name = "?dllmain_dispatch@@YAHQAUHINSTANCE__@@KQAX@Z"
		size = 389
		refs = "0006 __sehtable$?dllmain_dispatch@@YAHQAUHINSTANCE__@@KQAX@Z 000b __except_handler4 001d ___security_cookie 003b ?__proc_attached@@3HA 0070 ?dllmain_raw@@YGHQAUHINSTANCE__@@KQAX@Z 008f ?dllmain_crt_dispatch@@YGHQAUHINSTANCE__@@KQAX@Z 00ae _DllMain@12 0157 ___scrt_dllmain_exception_filter"
	strings:
		$1 = { 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 F0 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 89 65 E8 83 7D 0C 00 75 10 83 3D ?? ?? ?? ?? 00 7F 07 33 C0 E9 2A 01 00 00 C7 45 E4 01 00 00 00 C7 45 FC 00 00 00 00 83 7D 0C 01 74 06 83 7D 0C 02 75 3E 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 89 45 E4 83 7D E4 00 75 05 E9 A8 00 00 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 89 45 E4 83 7D E4 00 75 05 E9 89 00 00 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 89 45 E4 83 7D 0C 01 75 33 83 7D E4 00 75 2D 8B 45 10 50 6A 00 8B 4D 08 51 E8 ?? ?? ?? ?? 8B 55 10 52 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 8B 4D 10 51 6A 00 8B 55 08 52 E8 ?? ?? ?? ?? 83 7D 0C 00 74 06 83 7D 0C 03 75 30 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 89 45 E4 83 7D E4 00 75 02 EB 14 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 89 45 E4 C7 45 FC FE FF FF FF EB 3D 8B 45 EC 8B 08 8B 11 89 55 E0 8B 45 EC 50 8B 4D E0 51 68 ?? ?? ?? ?? 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 18 C3 8B 65 E8 C7 45 E4 00 00 00 00 C7 45 FC FE FF FF FF 8B 45 E4 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_167_4_0 {
	meta:
		name = "?dllmain_raw@@YGHQAUHINSTANCE__@@KQAX@Z"
		size = 57
		refs = "0006 __pRawDllMain 002c @_guard_check_icall@4"
	strings:
		$1 = { 55 8B EC 51 83 3D ?? ?? ?? ?? 00 75 07 B8 01 00 00 00 EB 1F 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 A1 ?? ?? ?? ?? 89 45 FC 8B 4D FC E8 ?? ?? ?? ?? FF 55 FC 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule file_167_5_0 {
	meta:
		name = "__CRT_INIT@12"
		size = 24
		refs = "0010 ?dllmain_crt_dispatch@@YGHQAUHINSTANCE__@@KQAX@Z"
	strings:
		$1 = { 55 8B EC 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 5D C2 0C 00 }
	condition:
		$1
}

rule file_167_6_0 {
	meta:
		name = "__DllMainCRTStartup@12"
		size = 38
		refs = "000a ___security_init_cookie 001b ?dllmain_dispatch@@YAHQAUHINSTANCE__@@KQAX@Z"
	strings:
		$1 = { 55 8B EC 83 7D 0C 01 75 05 E8 ?? ?? ?? ?? 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 5D C2 0C 00 }
	condition:
		$1
}

rule file_168_0_0 {
	meta:
		name = "___sse2_cos2"
		size = 416
		refs = "0018 _static_const_table 0155 ___common_cos_reduction_LA"
	strings:
		$1 = { 8B C4 81 EC 90 00 00 00 83 E4 F0 89 44 24 54 66 0F 29 04 24 66 0F DB 05 ?? ?? ?? ?? 66 0F 28 25 ?? ?? ?? ?? 66 0F 28 D0 66 0F 28 F8 66 0F 58 05 ?? ?? ?? ?? 66 0F 59 05 ?? ?? ?? ?? 66 0F 28 2D ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 58 05 ?? ?? ?? ?? 66 0F 28 D8 66 0F 5C 05 ?? ?? ?? ?? 66 0F 5C 05 ?? ?? ?? ?? 66 0F 66 3D ?? ?? ?? ?? 66 0F 50 C7 0B C0 0F 85 B3 00 00 00 66 0F 28 3D ?? ?? ?? ?? 66 0F 59 E0 66 0F 59 E8 66 0F 59 F0 66 0F 59 F8 66 0F 5C D4 66 0F 5C D5 66 0F 5C D6 66 0F 5C D7 66 0F 73 F3 3F 66 0F 28 05 ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 28 CA 66 0F 59 D2 66 0F 28 E2 66 0F 59 E4 66 0F 59 D1 66 0F 59 C4 66 0F 59 F4 66 0F 58 05 ?? ?? ?? ?? 66 0F 58 35 ?? ?? ?? ?? 66 0F 59 C4 66 0F 59 F4 66 0F 58 05 ?? ?? ?? ?? 66 0F 58 35 ?? ?? ?? ?? 66 0F 59 C4 66 0F 59 F4 66 0F 58 05 ?? ?? ?? ?? 66 0F 58 35 ?? ?? ?? ?? 66 0F 59 C4 66 0F 59 F2 66 0F 59 C1 66 0F 58 F1 66 0F 58 C6 66 0F EF C3 EB 6C 66 0F 28 04 24 66 0F DB 05 ?? ?? ?? ?? 66 0F 29 44 24 30 DD 44 24 30 8D 44 24 20 83 EC 20 DD 1C 24 89 44 24 08 E8 ?? ?? ?? ?? 83 C4 20 89 44 24 14 33 C0 89 44 24 10 DD 44 24 38 8D 44 24 28 83 EC 20 DD 1C 24 89 44 24 08 E8 ?? ?? ?? ?? 83 C4 20 89 44 24 1C 33 C0 89 44 24 18 66 0F 28 54 24 20 66 0F 28 5C 24 10 E9 0E FF FF FF 8B 64 24 54 C3 }
	condition:
		$1
}

rule file_169_0_0 {
	meta:
		name = "__aullshr"
		size = 31
	strings:
		$1 = { 80 F9 40 73 15 80 F9 20 73 06 0F AD D0 D3 EA C3 8B C2 33 D2 80 E1 1F D3 E8 C3 33 C0 33 D2 C3 }
	condition:
		$1
}

rule file_172_0_0 {
	meta:
		name = "___common_satan2_cout_rare"
		size = 4192
		refs = "0104 __vmldAtanHATab"
	strings:
		$1 = { 55 8B EC 83 E4 F8 56 57 53 83 EC 6C 8B 45 08 8B 4D 0C F3 0F 10 18 F3 0F 10 11 F3 0F 5A C3 F3 0F 5A CA F2 0F 11 44 24 18 F2 0F 11 4C 24 20 0F B6 78 03 0F B7 40 02 25 80 7F 00 00 0F B6 71 03 0F B7 4C 24 1E 81 E6 80 00 00 00 0F B7 5C 24 26 81 E1 F0 7F 00 00 81 E3 F0 7F 00 00 C1 E8 07 C1 EF 07 C1 EE 07 C1 E9 04 C1 EB 04 3D FF 00 00 00 0F 84 9E 0E 00 00 8B 55 0C 0F B7 52 02 81 E2 80 7F 00 00 81 FA 80 7F 00 00 0F 84 85 0E 00 00 85 C9 75 0F 8B 45 08 F7 00 FF FF 7F 00 0F 84 E2 0D 00 00 85 DB 75 0F 8B 45 0C F7 00 FF FF 7F 00 0F 84 8A 0D 00 00 F7 DB F2 0F 11 44 24 20 03 D9 F2 0F 11 4C 24 28 0F B6 44 24 27 0F B6 54 24 2F 83 E0 7F 83 E2 7F 89 44 24 1C 83 FB CA 89 54 24 18 0F 8E 7C 0C 00 00 83 FB 36 0F 8D 23 0C 00 00 8B C2 85 F6 8B 54 24 1C 88 44 24 2F 88 54 24 27 75 10 F2 0F 10 15 ?? ?? ?? ?? F2 0F 11 54 24 18 EB 16 F2 0F 10 05 ?? ?? ?? ?? F2 0F 10 15 ?? ?? ?? ?? F2 0F 11 44 24 18 F2 0F 10 5C 24 20 85 C9 F2 0F 10 44 24 28 0F 28 E3 F2 0F 5E E0 0F B7 44 24 26 F2 0F 11 64 24 50 0F 8E AB 0D 00 00 81 F9 FE 07 00 00 7D 1D 25 0F 80 FF FF 81 C1 01 FC FF FF F2 0F 11 5C 24 20 0D F0 3F FF FF 66 89 44 24 26 EB 17 F2 0F 10 0D ?? ?? ?? ?? B9 FE 03 00 00 F2 0F 59 D9 F2 0F 11 5C 24 20 F7 D9 81 C1 FF 03 00 00 81 E1 FF 07 00 00 0F B7 05 ?? ?? ?? ?? F2 0F 10 0D ?? ?? ?? ?? 25 0F 80 FF FF C1 E1 04 F2 0F 11 4C 24 28 0B C1 66 89 44 24 2E F2 0F 10 5C 24 28 F2 0F 59 C3 66 0F 2F 25 ?? ?? ?? ?? 0F 82 20 07 00 00 F2 0F 10 2D ?? ?? ?? ?? 0F 28 F8 F2 0F 59 FD 0F 28 F0 F2 0F 11 3C 24 F2 0F 11 54 24 48 F2 0F 10 14 24 F2 0F 11 64 24 28 F2 0F 5C D0 F2 0F 11 54 24 08 F2 0F 10 1C 24 F2 0F 10 64 24 08 F2 0F 11 4C 24 40 F2 0F 5C DC F2 0F 11 1C 24 F2 0F 10 0C 24 8B 4C 24 2C 8B D9 81 E1 00 00 08 00 81 E3 00 00 F0 FF 81 C9 00 00 04 00 F2 0F 5C F1 0B D9 C7 44 24 28 00 00 00 00 89 5C 24 2C F2 0F 11 74 24 08 F2 0F 10 0C 24 F2 0F 10 54 24 28 F2 0F 10 74 24 08 F2 0F 59 CA F2 0F 59 F2 F2 0F 10 3D ?? ?? ?? ?? F2 0F 59 CF F2 0F 59 F7 0F 28 E1 0F B7 54 24 56 F2 0F 58 E6 F2 0F 11 24 24 81 E2 F0 7F 00 00 F2 0F 10 1C 24 C1 EA 04 F2 0F 5C CB 8B 44 24 54 F2 0F 58 CE F2 0F 11 4C 24 08 25 FF FF 0F 00 F2 0F 10 4C 24 20 F2 0F 10 24 24 0F 28 F9 F2 0F 10 74 24 08 F2 0F 58 FC F2 0F 11 3C 24 0F 28 F9 F2 0F 10 1C 24 C1 E2 14 F2 0F 5C FB F2 0F 11 7C 24 08 0B D0 F2 0F 10 3C 24 81 C2 00 00 40 C0 F2 0F 10 5C 24 08 B8 71 00 00 00 C1 FA 13 F2 0F 58 FB F2 0F 11 7C 24 10 0F 28 F9 F2 0F 10 5C 24 08 83 FA 71 F2 0F 58 E3 F2 0F 11 64 24 08 0F 4C C2 F2 0F 10 64 24 10 C1 E0 04 F2 0F 5C FC F2 0F 11 7C 24 10 F2 0F 10 5C 24 08 F2 0F 10 64 24 10 F2 0F 58 DC F2 0F 11 5C 24 10 F2 0F 10 1C 24 F2 0F 10 64 24 10 F2 0F 58 E6 0F 28 F3 F2 0F 59 F5 F2 0F 11 34 24 F2 0F 10 3C 24 F2 0F 5C FB F2 0F 11 7C 24 08 F2 0F 10 3C 24 F2 0F 10 74 24 08 F2 0F 5C FE F2 0F 11 3C 24 0F 28 F9 F2 0F 10 34 24 F2 0F 59 3D ?? ?? ?? ?? F2 0F 5C DE F2 0F 11 5C 24 08 F2 0F 10 1C 24 F2 0F 10 74 24 08 F2 0F 11 3C 24 F2 0F 58 E6 F2 0F 10 34 24 F2 0F 5C 74 24 20 F2 0F 11 74 24 08 F2 0F 10 34 24 F2 0F 10 7C 24 08 F2 0F 5C F7 F2 0F 11 34 24 F2 0F 10 3C 24 F2 0F 5C CF F2 0F 11 4C 24 08 F2 0F 10 34 24 F2 0F 10 7C 24 08 F2 0F 59 F2 F2 0F 59 FA 0F 28 D6 F2 0F 58 D7 F2 0F 11 14 24 F2 0F 10 14 24 F2 0F 5C F2 0F 28 D0 F2 0F 58 F7 F2 0F 11 74 24 08 0F 28 F0 F2 0F 10 0C 24 F2 0F 10 7C 24 08 F2 0F 58 F1 F2 0F 11 34 24 F2 0F 10 34 24 F2 0F 5C D6 F2 0F 11 54 24 08 F2 0F 10 14 24 F2 0F 10 74 24 08 F2 0F 58 D6 F2 0F 11 54 24 10 F2 0F 10 74 24 08 F2 0F 58 CE F2 0F 11 4C 24 08 F2 0F 10 4C 24 10 F2 0F 5C C1 F2 0F 11 44 24 10 F2 0F 10 74 24 08 F2 0F 10 44 24 10 F2 0F 58 F0 F2 0F 11 74 24 10 F2 0F 10 34 24 F2 0F 10 44 24 10 F2 0F 58 C7 0F 28 FE F2 0F 59 FD F2 0F 11 3C 24 F2 0F 10 14 24 F2 0F 5C D6 F2 0F 11 54 24 08 F2 0F 10 0C 24 F2 0F 10 7C 24 08 F2 0F 10 54 24 40 F2 0F 5C CF F2 0F 11 0C 24 F2 0F 10 3C 24 F2 0F 5C F7 F2 0F 11 74 24 08 F2 0F 10 3C 24 F2 0F 10 74 24 08 F2 0F 58 C6 0F 28 F2 F2 0F 5E F7 0F 28 CE F2 0F 59 CD F2 0F 11 4C 24 08 F2 0F 10 4C 24 08 F2 0F 5C CE F2 0F 11 4C 24 10 F2 0F 10 4C 24 08 F2 0F 10 74 24 10 F2 0F 5C CE F2 0F 11 4C 24 10 F2 0F 10 74 24 10 F2 0F 59 FE F2 0F 5C D7 F2 0F 10 7C 24 10 F2 0F 59 C7 F2 0F 11 44 24 08 F2 0F 10 44 24 08 F2 0F 5C D0 F2 0F 11 54 24 08 F2 0F 10 4C 24 08 F2 0F 10 7C 24 10 F2 0F 10 44 24 08 F2 0F 10 74 24 10 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 C8 0F 28 C7 F2 0F 59 C3 F2 0F 59 CE 0F 28 D1 F2 0F 59 D4 F2 0F 59 D9 F2 0F 59 E7 F2 0F 58 D3 F2 0F 10 3D ?? ?? ?? ?? F2 0F 58 D4 F2 0F 11 14 24 0F 28 E0 F2 0F 10 34 24 F2 0F 58 E6 F2 0F 11 24 24 F2 0F 10 1C 24 F2 0F 5C C3 F2 0F 58 C6 F2 0F 11 44 24 08 F2 0F 10 1C 24 0F 28 D3 0F 28 CB F2 0F 59 D3 F2 0F 59 CD F2 0F 59 FA F2 0F 10 44 24 08 F2 0F 11 0C 24 F2 0F 10 34 24 F2 0F 58 3D ?? ?? ?? ?? F2 0F 5C F3 F2 0F 59 FA F2 0F 11 74 24 08 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FA F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FA F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FA F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FA F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 D7 F2 0F 10 3C 24 F2 0F 10 64 24 08 F2 0F 59 EA F2 0F 5C FC F2 0F 11 3C 24 F2 0F 10 34 24 F2 0F 5C DE F2 0F 11 5C 24 08 F2 0F 10 24 24 F2 0F 10 5C 24 08 F2 0F 11 2C 24 F2 0F 58 C3 F2 0F 10 2C 24 F2 0F 5C EA F2 0F 11 6C 24 08 F2 0F 10 3C 24 F2 0F 10 74 24 08 F2 0F 5C FE F2 0F 11 3C 24 F2 0F 10 0C 24 F2 0F 5C D1 F2 0F 11 54 24 08 F2 0F 10 14 24 F2 0F 10 5C 24 08 0F 28 F2 0F 28 FB F2 0F 59 F8 F2 0F 59 D0 F2 0F 59 DC F2 0F 59 F4 F2 0F 58 FA 0F 28 CE 0F 28 D6 F2 0F 58 FB F2 0F 58 CC F2 0F 11 3C 24 F2 0F 10 3C 24 F2 0F 11 0C 24 F2 0F 10 2C 24 F2 0F 5C D5 F2 0F 11 54 24 08 F2 0F 10 1C 24 F2 0F 10 4C 24 08 F2 0F 58 D9 F2 0F 11 5C 24 10 F2 0F 10 6C 24 08 F2 0F 10 98 ?? ?? ?? ?? F2 0F 58 E5 F2 0F 11 64 24 08 F2 0F 10 64 24 10 F2 0F 5C F4 F2 0F 11 74 24 10 F2 0F 10 4C 24 08 F2 0F 10 74 24 10 F2 0F 58 CE F2 0F 11 4C 24 10 F2 0F 10 34 24 F2 0F 10 54 24 10 0F 28 EE F2 0F 58 DE F2 0F 58 C2 F2 0F 11 1C 24 F2 0F 58 C7 F2 0F 10 24 24 F2 0F 11 44 24 38 F2 0F 5C EC F2 0F 11 6C 24 08 F2 0F 10 0C 24 F2 0F 10 7C 24 08 F2 0F 58 CF F2 0F 11 4C 24 10 F2 0F 10 54 24 08 F2 0F 58 90 ?? ?? ?? ?? F2 0F 11 54 24 08 F2 0F 10 5C 24 10 F2 0F 10 54 24 48 F2 0F 5C F3 F2 0F 11 74 24 10 F2 0F 10 6C 24 08 F2 0F 10 64 24 10 F2 0F 58 EC F2 0F 11 6C 24 10 F2 0F 10 34 24 F2 0F 10 7C 24 10 F2 0F 11 74 24 30 F2 0F 58 C7 0F B6 54 24 37 0F 28 CA 83 E2 7F F2 0F 58 80 ?? ?? ?? ?? 8B C6 C1 E0 07 0B D0 88 54 24 37 F2 0F 11 44 24 38 F2 0F 10 44 24 30 0F 28 E0 F2 0F 58 C8 F2 0F 11 0C 24 F2 0F 10 1C 24 0F B6 4C 24 3F 8B D9 C1 E9 07 83 E3 7F 33 F1 F2 0F 5C E3 F2 0F 11 64 24 08 F2 0F 10 34 24 F2 0F 10 6C 24 08 C1 E6 07 F2 0F 58 F5 F2 0F 11 74 24 10 0B DE F2 0F 10 7C 24 08 88 5C 24 3F F2 0F 58 D7 F2 0F 11 54 24 08 F2 0F 10 54 24 10 C1 E7 07 F2 0F 5C C2 F2 0F 11 44 24 10 F2 0F 10 4C 24 08 F2 0F 10 44 24 10 8B 75 10 F2 0F 58 C8 F2 0F 11 4C 24 10 F2 0F 10 24 24 F2 0F 10 5C 24 10 F2 0F 11 64 24 30 F2 0F 58 5C 24 38 F2 0F 58 5C 24 18 F2 0F 11 5C 24 38 F2 0F 58 E3 F2 0F 11 64 24 60 0F B6 44 24 67 83 E0 7F 0B C7 88 44 24 67 F2 0F 5A 54 24 60 F3 0F 11 16 E9 F9 05 00 00 F2 0F 10 7C 24 20 8B C6 0F 28 E7 F2 0F 59 25 ?? ?? ?? ?? F2 0F 11 24 24 F2 0F 10 1C 24 F2 0F 11 54 24 48 F2 0F 10 25 ?? ?? ?? ?? C1 E0 07 F2 0F 5C 5C 24 20 F2 0F 11 5C 24 08 F2 0F 10 2C 24 F2 0F 10 54 24 08 C1 E7 07 F2 0F 5C EA F2 0F 11 2C 24 0F 28 E8 F2 0F 10 34 24 F2 0F 59 EC F2 0F 5C FE F2 0F 11 7C 24 08 F2 0F 10 14 24 F2 0F 10 5C 24 08 F2 0F 11 2C 24 F2 0F 10 34 24 F2 0F 5C F0 F2 0F 11 74 24 08 F2 0F 10 2C 24 F2 0F 10 7C 24 08 F2 0F 5C EF F2 0F 11 2C 24 F2 0F 10 34 24 F2 0F 5C C6 F2 0F 11 44 24 08 0F 28 C1 F2 0F 10 2C 24 F2 0F 5E C5 0F 28 F0 F2 0F 59 F4 F2 0F 10 7C 24 08 F2 0F 11 74 24 08 F2 0F 10 74 24 08 F2 0F 5C F0 F2 0F 11 74 24 10 F2 0F 10 74 24 08 F2 0F 10 44 24 10 F2 0F 5C F0 F2 0F 11 74 24 10 F2 0F 10 44 24 10 F2 0F 59 E8 F2 0F 5C CD F2 0F 10 6C 24 10 F2 0F 59 FD F2 0F 11 7C 24 08 F2 0F 10 7C 24 08 F2 0F 5C CF F2 0F 11 4C 24 08 F2 0F 10 6C 24 08 F2 0F 10 74 24 10 F2 0F 10 4C 24 08 0F 28 C6 F2 0F 59 C2 F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 F3 F2 0F 59 E9 F2 0F 10 4C 24 10 F2 0F 59 E9 0F 28 FD F2 0F 59 FB F2 0F 59 D5 F2 0F 58 FA 0F 28 D0 F2 0F 58 FE F2 0F 11 3C 24 F2 0F 10 0C 24 F2 0F 58 D1 F2 0F 11 14 24 F2 0F 10 1C 24 F2 0F 5C C3 F2 0F 58 C1 F2 0F 10 0D ?? ?? ?? ?? F2 0F 11 44 24 08 F2 0F 10 44 24 50 F2 0F 59 C0 F2 0F 59 C8 F2 0F 10 3C 24 0F 28 EF F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 EC F2 0F 59 C8 F2 0F 10 54 24 08 F2 0F 11 2C 24 F2 0F 10 34 24 F2 0F 58 0D ?? ?? ?? ?? F2 0F 5C F7 F2 0F 59 C8 F2 0F 11 74 24 08 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 C8 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 C8 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 C8 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 C8 F2 0F 10 04 24 F2 0F 10 5C 24 08 F2 0F 59 E1 F2 0F 5C C3 F2 0F 11 04 24 F2 0F 10 2C 24 F2 0F 5C FD F2 0F 11 7C 24 08 F2 0F 10 34 24 F2 0F 10 7C 24 08 F2 0F 11 24 24 F2 0F 58 D7 F2 0F 10 24 24 F2 0F 5C E1 F2 0F 11 64 24 08 F2 0F 10 2C 24 F2 0F 10 44 24 08 F2 0F 5C E8 F2 0F 11 2C 24 F2 0F 10 1C 24 F2 0F 5C CB F2 0F 11 4C 24 08 F2 0F 10 0C 24 F2 0F 10 7C 24 08 0F 28 E9 0F 28 C7 F2 0F 59 C2 F2 0F 59 CA F2 0F 59 FE F2 0F 59 EE F2 0F 58 C1 0F 28 CD 0F 28 DD F2 0F 58 C7 F2 0F 58 CE F2 0F 11 04 24 F2 0F 10 04 24 F2 0F 11 0C 24 F2 0F 10 24 24 F2 0F 5C DC F2 0F 11 5C 24 08 F2 0F 10 24 24 F2 0F 10 4C 24 08 F2 0F 58 E1 F2 0F 11 64 24 10 F2 0F 10 7C 24 08 F2 0F 58 F7 F2 0F 11 74 24 08 F2 0F 10 74 24 10 F2 0F 5C EE F2 0F 10 74 24 48 F2 0F 11 6C 24 10 F2 0F 10 5C 24 08 F2 0F 10 4C 24 10 F2 0F 58 D9 F2 0F 11 5C 24 10 F2 0F 10 24 24 F2 0F 10 6C 24 10 F2 0F 11 64 24 30 F2 0F 58 D5 0F B6 54 24 37 F2 0F 58 D0 83 E2 7F 0B D0 88 54 24 37 F2 0F 11 54 24 38 0F 28 D6 F2 0F 10 4C 24 30 0F 28 C1 F2 0F 58 D1 F2 0F 11 14 24 F2 0F 10 14 24 0F B6 4C 24 3F 8B D9 C1 E9 07 83 E3 7F 33 F1 F2 0F 5C C2 F2 0F 11 44 24 08 F2 0F 10 24 24 F2 0F 10 5C 24 08 C1 E6 07 F2 0F 58 E3 F2 0F 11 64 24 10 0B DE F2 0F 10 6C 24 08 88 5C 24 3F F2 0F 58 F5 F2 0F 11 74 24 08 F2 0F 10 7C 24 10 8B 75 10 F2 0F 5C CF F2 0F 11 4C 24 10 F2 0F 10 44 24 08 F2 0F 10 4C 24 10 F2 0F 58 C1 F2 0F 11 44 24 10 F2 0F 10 1C 24 F2 0F 10 54 24 10 F2 0F 11 5C 24 30 F2 0F 58 54 24 38 F2 0F 58 54 24 18 F2 0F 11 54 24 38 F2 0F 58 DA F2 0F 11 5C 24 60 0F B6 44 24 67 83 E0 7F 0B C7 88 44 24 67 F2 0F 5A 4C 24 60 F3 0F 11 0E E9 DA 01 00 00 83 FB 4A 0F 8D 33 01 00 00 88 44 24 27 F2 0F 5E 4C 24 20 F2 0F 10 05 ?? ?? ?? ?? C1 E7 07 F2 0F 5C C1 8B 4D 10 F2 0F 58 05 ?? ?? ?? ?? F2 0F 11 44 24 60 0F B6 54 24 67 83 E2 7F 0B D7 88 54 24 67 F2 0F 5A 4C 24 60 F3 0F 11 09 E9 8A 01 00 00 85 F6 0F 85 4E 01 00 00 8B D0 8B 44 24 18 88 54 24 27 88 44 24 2F F2 0F 10 54 24 20 F2 0F 5E 54 24 28 F2 0F 5A C2 F3 0F 11 44 24 58 0F B7 4C 24 5A F7 C1 80 7F 00 00 F2 0F 11 54 24 60 74 43 F2 0F 10 05 ?? ?? ?? ?? C1 E7 07 F2 0F 58 C2 F2 0F 11 04 24 F2 0F 10 0C 24 F2 0F 59 D1 F2 0F 11 54 24 60 0F B6 44 24 67 83 E0 7F 0B C7 88 44 24 67 F2 0F 5A 54 24 60 8B 55 10 F3 0F 11 12 E9 08 01 00 00 F2 0F 5A 44 24 60 F3 0F 11 44 24 58 F3 0F 10 54 24 58 F3 0F 10 4C 24 58 F3 0F 59 D1 F3 0F 11 54 24 58 F3 0F 10 5C 24 58 F3 0F 5A DB C1 E7 07 F2 0F 58 5C 24 60 F2 0F 11 5C 24 60 0F B6 44 24 67 83 E0 7F 0B C7 88 44 24 67 F2 0F 5A 64 24 60 8B 55 10 F3 0F 11 22 E9 AD 00 00 00 85 C9 75 0B 8B 45 08 F7 00 FF FF 7F 00 74 36 F2 0F 10 05 ?? ?? ?? ?? C1 E7 07 F2 0F 58 05 ?? ?? ?? ?? F2 0F 11 44 24 60 0F B6 44 24 67 83 E0 7F 0B C7 88 44 24 67 F2 0F 5A 4C 24 60 8B 55 10 F3 0F 11 0A EB 68 85 F6 75 30 0F B6 05 ?? ?? ?? ?? F2 0F 10 05 ?? ?? ?? ?? 83 E0 7F C1 E7 07 F2 0F 11 44 24 60 0B C7 88 44 24 67 F2 0F 5A 4C 24 60 8B 55 10 F3 0F 11 0A EB 34 F2 0F 10 05 ?? ?? ?? ?? C1 E7 07 F2 0F 58 05 ?? ?? ?? ?? F2 0F 11 44 24 60 0F B6 44 24 67 83 E0 7F 0B C7 88 44 24 67 F2 0F 5A 4C 24 60 8B 55 10 F3 0F 11 0A 33 C0 83 C4 6C 5B 5F 5E 8B E5 5D C3 F2 0F 10 0D ?? ?? ?? ?? B9 02 FC FF FF F2 0F 59 D9 F2 0F 11 5C 24 20 E9 75 F2 FF FF 81 F9 FF 07 00 00 0F 84 31 01 00 00 81 FB FF 07 00 00 0F 84 06 01 00 00 8B 55 0C 0F B7 4A 02 81 E1 80 7F 00 00 81 F9 80 7F 00 00 74 39 F2 0F 10 05 ?? ?? ?? ?? C1 E7 07 F2 0F 58 05 ?? ?? ?? ?? F2 0F 11 44 24 60 0F B6 44 24 67 83 E0 7F 0B C7 88 44 24 67 F2 0F 5A 4C 24 60 8B 55 10 F3 0F 11 0A E9 72 FF FF FF 3D FF 00 00 00 74 3B 85 F6 0F 85 2F FF FF FF 0F B6 05 ?? ?? ?? ?? F2 0F 10 05 ?? ?? ?? ?? 83 E0 7F C1 E7 07 F2 0F 11 44 24 60 0B C7 88 44 24 67 F2 0F 5A 4C 24 60 8B 55 10 F3 0F 11 0A E9 30 FF FF FF 85 F6 75 39 F2 0F 10 05 ?? ?? ?? ?? C1 E7 07 F2 0F 58 05 ?? ?? ?? ?? F2 0F 11 44 24 60 0F B6 44 24 67 83 E0 7F 0B C7 88 44 24 67 F2 0F 5A 4C 24 60 8B 55 10 F3 0F 11 0A E9 F3 FE FF FF F2 0F 10 05 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_173_0_0 {
	meta:
		name = "___common_sexp_cout_rare"
		size = 608
		refs = "0027 _2il0floatpacket_46 003b _2il0floatpacket_47 0049 _2il0floatpacket_49 0062 _2il0floatpacket_50 006a _2il0floatpacket_53 0082 _2il0floatpacket_54 0098 _2il0floatpacket_51 00a9 _2il0floatpacket_52 00c0 _2il0floatpacket_55 00cf _2il0floatpacket_56 00d6 _2il0floatpacket_58 00e2 _2il0floatpacket_57 0171 _2il0floatpacket_61 01c2 _2il0floatpacket_60 01e3 _2il0floatpacket_59 0208 _2il0floatpacket_48"
	strings:
		$1 = { 83 EC 10 8B 44 24 14 0F B7 50 02 81 E2 80 7F 00 00 81 FA 80 7F 00 00 0F 84 0C 02 00 00 F3 0F 10 00 33 D2 F3 0F 10 0D ?? ?? ?? ?? 89 54 24 0C 0F 2F C8 0F 82 CC 01 00 00 0F 2F 05 ?? ?? ?? ?? 0F 82 9A 01 00 00 F3 0F 10 0D ?? ?? ?? ?? 0F 28 F8 F3 0F 59 C8 F3 0F 11 0C 24 F3 0F 10 14 24 F3 0F 10 1D ?? ?? ?? ?? F3 0F 10 0D ?? ?? ?? ?? F3 0F 58 D3 F3 0F 11 54 24 04 F3 0F 10 64 24 04 F3 0F 10 15 ?? ?? ?? ?? F3 0F 5C E3 F3 0F 11 24 24 F3 0F 10 2C 24 F3 0F 59 2D ?? ?? ?? ?? F3 0F 10 34 24 F3 0F 5C FD F3 0F 59 35 ?? ?? ?? ?? 8B 44 24 04 F3 0F 5C FE F3 0F 59 D7 C1 E0 10 F3 0F 58 15 ?? ?? ?? ?? F3 0F 59 D7 C1 F8 10 F3 0F 58 15 ?? ?? ?? ?? 0F 2F 05 ?? ?? ?? ?? F3 0F 59 D7 F3 0F 58 15 ?? ?? ?? ?? F3 0F 59 D7 F3 0F 58 D1 F3 0F 59 D7 F3 0F 58 D1 F3 0F 11 54 24 08 0F 82 89 00 00 00 8D 50 7F 81 FA FE 00 00 00 77 2D 0F B6 D2 C1 E2 07 66 89 54 24 0E F3 0F 10 44 24 08 F3 0F 59 44 24 0C 8B 4C 24 18 F3 0F 11 44 24 08 8B 44 24 08 89 01 33 C0 83 C4 10 C3 83 C0 7E 0F B6 C0 0F B7 54 24 0E C1 E0 07 81 E2 7F 80 FF FF 0B D0 F3 0F 10 44 24 08 66 89 54 24 0E F3 0F 59 44 24 0C F3 0F 11 44 24 08 F3 0F 10 4C 24 08 F3 0F 59 0D ?? ?? ?? ?? 8B 44 24 18 F3 0F 11 4C 24 08 8B 4C 24 08 89 08 33 C0 83 C4 10 C3 83 C0 BB 0F B6 C0 0F B7 54 24 0E C1 E0 07 81 E2 7F 80 FF FF 0B D0 F3 0F 10 44 24 08 66 89 54 24 0E F3 0F 59 44 24 0C F3 0F 11 44 24 08 F3 0F 10 4C 24 08 F3 0F 59 0D ?? ?? ?? ?? 8B 44 24 18 F3 0F 11 4C 24 08 8B 4C 24 08 89 08 B8 04 00 00 00 83 C4 10 C3 F3 0F 10 05 ?? ?? ?? ?? F3 0F 59 C0 8B 54 24 18 F3 0F 11 44 24 08 8B 44 24 08 89 02 B8 04 00 00 00 83 C4 10 C3 F3 0F 10 05 ?? ?? ?? ?? F3 0F 59 C0 8B 54 24 18 F3 0F 11 44 24 08 8B 44 24 08 89 02 B8 03 00 00 00 83 C4 10 C3 0F B6 50 03 F7 C2 80 00 00 00 75 16 F3 0F 10 00 F3 0F 59 C0 8B 44 24 18 F3 0F 11 00 33 C0 83 C4 10 C3 F7 00 FF FF 7F 00 75 E2 8B 54 24 18 33 C0 89 02 83 C4 10 C3 90 }
	condition:
		$1
}

rule file_174_0_0 {
	meta:
		name = "___scrt_is_user_matherr_present"
		size = 36
		refs = "0006 ___scrt_default_matherr"
	strings:
		$1 = { 55 8B EC 51 83 3D ?? ?? ?? ?? 00 75 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_175_0_0 {
	meta:
		name = "___sse2_tan2"
		size = 512
		refs = "001c _static_const_table 018c ___common_pi04_reduction_LA"
	strings:
		$1 = { 8B C4 81 EC A0 00 00 00 83 E4 F0 89 44 24 64 66 0F 29 04 24 66 0F 28 C8 66 0F DB 05 ?? ?? ?? ?? 66 0F 28 25 ?? ?? ?? ?? 66 0F 28 2D ?? ?? ?? ?? 66 0F DB 0D ?? ?? ?? ?? 66 0F 28 D0 66 0F 28 F8 66 0F 59 05 ?? ?? ?? ?? 66 0F 66 3D ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 50 C7 0B C0 0F 85 F0 00 00 00 66 0F 28 3D ?? ?? ?? ?? 66 0F 58 05 ?? ?? ?? ?? 66 0F 28 D8 66 0F 5C 05 ?? ?? ?? ?? 66 0F 59 E0 66 0F 59 E8 66 0F 59 F0 66 0F 59 F8 66 0F 28 C3 66 0F 73 F0 3F 66 0F EF C1 66 0F 5C D4 66 0F 5C D5 66 0F 5C D6 66 0F 5C D7 66 0F 73 F3 3E 66 0F EF C9 66 0F C2 D9 04 66 0F 28 25 ?? ?? ?? ?? 66 0F 28 2D ?? ?? ?? ?? 66 0F 28 CA 66 0F 59 D2 66 0F 59 E2 66 0F 59 EA 66 0F 58 25 ?? ?? ?? ?? 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 E2 66 0F 59 EA 66 0F 58 25 ?? ?? ?? ?? 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 E2 66 0F 59 EA 66 0F 58 25 ?? ?? ?? ?? 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 E1 66 0F 28 CB 66 0F 28 D3 66 0F 54 CC 66 0F 55 D5 66 0F 56 CA 66 0F 28 F3 66 0F 28 FB 66 0F 55 F4 66 0F 54 FD 66 0F 56 F7 66 0F 5E F1 66 0F EF C6 E9 9B 00 00 00 66 0F 28 04 24 66 0F 28 C8 66 0F DB 05 ?? ?? ?? ?? 66 0F DB 0D ?? ?? ?? ?? 66 0F 29 44 24 30 66 0F 29 4C 24 40 DD 44 24 30 8D 44 24 20 83 EC 20 DD 1C 24 89 44 24 08 E8 ?? ?? ?? ?? 83 C4 20 89 44 24 10 33 C0 89 44 24 14 DD 44 24 38 8D 44 24 28 83 EC 20 DD 1C 24 89 44 24 08 E8 ?? ?? ?? ?? 83 C4 20 89 44 24 18 33 C0 89 44 24 1C 66 0F 28 54 24 20 66 0F 28 5C 24 10 66 0F 28 C3 66 0F 73 F0 3F 66 0F EF 44 24 40 66 0F 73 F3 3E 66 0F EF C9 66 0F C2 D9 04 E9 CC FE FF FF 8B 64 24 64 C3 8D A4 24 00 00 00 00 EB 03 CC CC CC }
	condition:
		$1
}

rule file_177_0_0 {
	meta:
		name = "___common_slog10_cout_rare"
		size = 688
		refs = "0039 _2il0floatpacket_77 0060 _2il0floatpacket_93 0078 _2il0floatpacket_78 0099 _2il0floatpacket_79 00a1 _2il0floatpacket_80 00a9 _2il0floatpacket_82 00e1 _2il0floatpacket_81 010e __vmldLgHATab 0134 _2il0floatpacket_83 0142 _2il0floatpacket_84 0158 _2il0floatpacket_85 0164 _2il0floatpacket_86 0170 _2il0floatpacket_87 017c _2il0floatpacket_88 0188 _2il0floatpacket_89 0194 _2il0floatpacket_90 01a0 _2il0floatpacket_91 025a _2il0floatpacket_92"
	strings:
		$1 = { 83 EC 0C 8B 44 24 10 8B 54 24 14 0F B7 48 02 81 E1 80 7F 00 00 81 F9 80 7F 00 00 0F 84 4E 02 00 00 F3 0F 10 08 8B 00 89 44 24 08 C1 E8 10 A9 80 7F 00 00 75 15 F3 0F 59 0D ?? ?? ?? ?? B9 D8 FF FF FF F3 0F 11 4C 24 08 EB 02 33 C9 66 0F EF C0 0F 2F C8 0F 86 E5 01 00 00 0F 28 D1 F3 0F 5C 15 ?? ?? ?? ?? F3 0F 11 54 24 04 80 64 24 07 7F F3 0F 10 44 24 04 0F 2F 05 ?? ?? ?? ?? 0F 86 42 01 00 00 0F B7 44 24 0A 25 80 7F 00 00 C1 E8 07 F3 0F 11 4C 24 04 F3 0F 10 15 ?? ?? ?? ?? F3 0F 10 25 ?? ?? ?? ?? F3 0F 10 3D ?? ?? ?? ?? 8D 4C 01 81 F3 0F 2A D9 0F B7 44 24 06 25 7F 80 FF FF 0D 80 3F FF FF 66 89 44 24 06 F3 0F 59 D3 F3 0F 59 DC F3 0F 10 64 24 04 0F 28 EC 0F 28 F4 F3 0F 58 2D ?? ?? ?? ?? F3 0F 58 F7 F3 0F 11 2C 24 8B 04 24 F3 0F 11 34 24 83 E0 7F F3 0F 10 04 24 F3 0F 5C C7 8D 0C C5 00 00 00 00 F3 0F 10 8C 81 ?? ?? ?? ?? F3 0F 5C E0 F3 0F 58 9C 81 ?? ?? ?? ?? F3 0F 58 94 81 ?? ?? ?? ?? F3 0F 59 C1 F3 0F 59 CC F3 0F 5C 05 ?? ?? ?? ?? 0F 28 E8 0F 28 F1 F3 0F 10 25 ?? ?? ?? ?? 33 C0 F3 0F 58 E9 F3 0F 58 D0 F3 0F 59 E5 F3 0F 58 25 ?? ?? ?? ?? F3 0F 59 E5 F3 0F 58 25 ?? ?? ?? ?? F3 0F 59 E5 F3 0F 58 25 ?? ?? ?? ?? F3 0F 59 E5 F3 0F 58 25 ?? ?? ?? ?? F3 0F 59 E5 F3 0F 58 25 ?? ?? ?? ?? F3 0F 59 E5 F3 0F 58 25 ?? ?? ?? ?? F3 0F 59 E5 F3 0F 58 25 ?? ?? ?? ?? F3 0F 59 F4 F3 0F 59 C4 F3 0F 58 DE F3 0F 58 CB F3 0F 58 C8 F3 0F 58 D1 F3 0F 11 12 83 C4 0C C3 F3 0F 10 05 ?? ?? ?? ?? 33 C0 F3 0F 59 D0 F3 0F 10 0D ?? ?? ?? ?? F3 0F 59 CA F3 0F 58 0D ?? ?? ?? ?? F3 0F 59 CA F3 0F 58 0D ?? ?? ?? ?? F3 0F 59 CA F3 0F 58 0D ?? ?? ?? ?? F3 0F 59 CA F3 0F 58 0D ?? ?? ?? ?? F3 0F 59 CA F3 0F 58 0D ?? ?? ?? ?? F3 0F 59 CA F3 0F 58 0D ?? ?? ?? ?? F3 0F 59 CA F3 0F 58 0D ?? ?? ?? ?? F3 0F 59 CA F3 0F 58 D1 F3 0F 11 12 83 C4 0C C3 0F 2E C8 7A 02 74 11 F3 0F 5E C0 F3 0F 11 02 B8 01 00 00 00 83 C4 0C C3 F3 0F 10 0D ?? ?? ?? ?? B8 02 00 00 00 F3 0F 5E C8 F3 0F 11 0A 83 C4 0C C3 0F B6 48 03 F7 C1 80 00 00 00 75 12 F3 0F 10 00 33 C0 F3 0F 59 C0 F3 0F 11 02 83 C4 0C C3 F7 00 FF FF 7F 00 75 E6 B8 01 00 00 00 66 0F EF C9 66 0F EF C0 F3 0F 5E C8 F3 0F 11 0A 83 C4 0C C3 8B FF }
	condition:
		$1
}

rule file_179_0_0 {
	meta:
		name = "___sse2_sinf4"
		size = 448
		refs = "001b _static_const_table 00f7 ___common_sin_reduction_LA"
	strings:
		$1 = { 8B C4 81 EC 90 00 00 00 83 E4 F0 89 44 24 54 0F 28 F0 0F 28 D0 0F 28 F8 0F 28 0D ?? ?? ?? ?? 66 0F DB F9 0F 28 25 ?? ?? ?? ?? 0F 28 2D ?? ?? ?? ?? 0F 59 C4 0F 28 25 ?? ?? ?? ?? 66 0F 66 FD 0F 28 2D ?? ?? ?? ?? 0F 50 C7 0B C0 75 7B 66 0F 5B C0 0F 28 D8 0F 28 3D ?? ?? ?? ?? 0F 5B C0 0F 28 35 ?? ?? ?? ?? 66 0F 72 F3 1F 0F 59 E0 0F 59 E8 0F 59 F0 0F 59 F8 0F 28 05 ?? ?? ?? ?? 0F 5C D4 0F 5C D5 0F 5C D6 0F 28 25 ?? ?? ?? ?? 0F 28 2D ?? ?? ?? ?? 0F 28 35 ?? ?? ?? ?? 0F 28 CA 0F 5C CF 0F 59 D2 0F 59 C2 0F 58 C4 0F 59 C2 0F 58 C5 0F 59 C2 0F 58 C6 0F 59 C2 0F 59 C1 0F 58 C1 66 0F EF C3 E9 EA 00 00 00 66 0F 28 CE 66 0F DB 35 ?? ?? ?? ?? 66 0F DB 0D ?? ?? ?? ?? 0F 11 34 24 0F 11 4C 24 30 D9 04 24 83 EC 20 DD 1C 24 8D 44 24 10 89 44 24 08 E8 ?? ?? ?? ?? DD 44 24 10 83 C4 20 D9 5C 24 10 89 44 24 20 D9 44 24 04 83 EC 20 DD 1C 24 8D 44 24 10 89 44 24 08 E8 ?? ?? ?? ?? DD 44 24 10 83 C4 20 D9 5C 24 14 89 44 24 24 D9 44 24 08 83 EC 20 DD 1C 24 8D 44 24 10 89 44 24 08 E8 ?? ?? ?? ?? DD 44 24 10 83 C4 20 D9 5C 24 18 89 44 24 28 D9 44 24 0C 83 EC 20 DD 1C 24 8D 44 24 10 89 44 24 08 E8 ?? ?? ?? ?? DD 44 24 10 83 C4 20 D9 5C 24 1C 89 44 24 2C 0F 10 54 24 10 0F 10 5C 24 20 0F 57 5C 24 30 0F 28 05 ?? ?? ?? ?? 0F 28 25 ?? ?? ?? ?? 0F 28 2D ?? ?? ?? ?? 0F 28 35 ?? ?? ?? ?? 0F 28 CA 0F 59 D2 E9 F2 FE FF FF 8B 64 24 54 C3 8D A4 24 00 00 00 00 8B FF }
	condition:
		$1
}

rule file_180_0_0 {
	meta:
		name = "___isa_available_init"
		size = 723
		refs = "0007 ___security_cookie 0014 ___isa_available 001d ___isa_enabled 002c _IsProcessorFeaturePresent@4 016e ___favor 02cb @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 40 A1 ?? ?? ?? ?? 33 C5 89 45 FC 53 56 C7 05 ?? ?? ?? ?? 00 00 00 00 A1 ?? ?? ?? ?? 83 C8 01 A3 ?? ?? ?? ?? 6A 0A E8 ?? ?? ?? ?? 85 C0 75 07 33 C0 E9 88 02 00 00 C7 45 F0 00 00 00 00 C7 45 F4 00 00 00 00 C7 45 F8 00 00 00 00 C7 05 ?? ?? ?? ?? 01 00 00 00 8B 0D ?? ?? ?? ?? 83 C9 02 89 0D ?? ?? ?? ?? 8D 75 E0 33 C0 33 C9 0F A2 89 06 89 5E 04 89 4E 08 89 56 0C BA 04 00 00 00 6B C2 00 8B 4C 05 E0 89 4D D0 BA 04 00 00 00 C1 E2 00 8B 44 15 E0 35 47 65 6E 75 B9 04 00 00 00 6B D1 03 8B 4C 15 E0 81 F1 69 6E 65 49 0B C1 BA 04 00 00 00 D1 E2 8B 4C 15 E0 81 F1 6E 74 65 6C 0B C1 75 09 C7 45 D4 01 00 00 00 EB 07 C7 45 D4 00 00 00 00 8A 55 D4 88 55 DF 8D 75 E0 B8 01 00 00 00 33 C9 0F A2 89 06 89 5E 04 89 4E 08 89 56 0C B8 04 00 00 00 6B C8 00 8B 54 0D E0 89 55 D8 0F B6 45 DF 85 C0 74 71 8B 4D D8 81 E1 F0 3F FF 0F 81 F9 C0 06 01 00 74 51 8B 55 D8 81 E2 F0 3F FF 0F 81 FA 60 06 02 00 74 40 8B 45 D8 25 F0 3F FF 0F 3D 70 06 02 00 74 31 8B 4D D8 81 E1 F0 3F FF 0F 81 F9 50 06 03 00 74 20 8B 55 D8 81 E2 F0 3F FF 0F 81 FA 60 06 03 00 74 0F 8B 45 D8 25 F0 3F FF 0F 3D 70 06 03 00 75 0F 8B 0D ?? ?? ?? ?? 83 C9 01 89 0D ?? ?? ?? ?? BA 04 00 00 00 6B C2 03 B9 04 00 00 00 6B D1 00 8B 44 05 E0 89 44 15 F0 B9 04 00 00 00 D1 E1 BA 04 00 00 00 C1 E2 00 8B 44 0D E0 89 44 15 F0 83 7D D0 07 7C 4F 8D 75 E0 B8 07 00 00 00 33 C9 0F A2 89 06 89 5E 04 89 4E 08 89 56 0C B9 04 00 00 00 C1 E1 00 BA 04 00 00 00 D1 E2 8B 44 0D E0 89 44 15 F0 B9 04 00 00 00 C1 E1 00 8B 54 0D E0 81 E2 00 02 00 00 74 0D A1 ?? ?? ?? ?? 83 C8 02 A3 ?? ?? ?? ?? B9 04 00 00 00 C1 E1 00 8B 54 0D F0 81 E2 00 00 10 00 0F 84 AA 00 00 00 C7 05 ?? ?? ?? ?? 02 00 00 00 A1 ?? ?? ?? ?? 83 C8 04 A3 ?? ?? ?? ?? B9 04 00 00 00 C1 E1 00 8B 54 0D F0 81 E2 00 00 00 08 74 7F B8 04 00 00 00 C1 E0 00 8B 4C 05 F0 81 E1 00 00 00 10 74 6B 33 C9 0F 01 D0 89 45 C8 89 55 CC 8B 55 C8 8B 45 CC 83 E2 06 83 E0 00 89 55 C0 89 45 C4 83 7D C0 06 75 48 83 7D C4 00 75 42 C7 05 ?? ?? ?? ?? 03 00 00 00 8B 0D ?? ?? ?? ?? 83 C9 08 89 0D ?? ?? ?? ?? BA 04 00 00 00 D1 E2 8B 44 15 F0 83 E0 20 74 19 C7 05 ?? ?? ?? ?? 05 00 00 00 8B 0D ?? ?? ?? ?? 83 C9 20 89 0D ?? ?? ?? ?? 33 C0 5E 5B 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_181_0_0 {
	meta:
		name = "??3@YAXPAX@Z"
		size = 19
		refs = "000a __free_dbg"
	strings:
		$1 = { 55 8B EC 6A FF 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_182_0_0 {
	meta:
		name = "__allrem"
		size = 178
	strings:
		$1 = { 53 57 33 FF 8B 44 24 10 0B C0 7D 14 47 8B 54 24 0C F7 D8 F7 DA 83 D8 00 89 44 24 10 89 54 24 0C 8B 44 24 18 0B C0 7D 13 8B 54 24 14 F7 D8 F7 DA 83 D8 00 89 44 24 18 89 54 24 14 0B C0 75 1B 8B 4C 24 14 8B 44 24 10 33 D2 F7 F1 8B 44 24 0C F7 F1 8B C2 33 D2 4F 79 4E EB 53 8B D8 8B 4C 24 14 8B 54 24 10 8B 44 24 0C D1 EB D1 D9 D1 EA D1 D8 0B DB 75 F4 F7 F1 8B C8 F7 64 24 18 91 F7 64 24 14 03 D1 72 0E 3B 54 24 10 77 08 72 0E 3B 44 24 0C 76 08 2B 44 24 14 1B 54 24 18 2B 44 24 0C 1B 54 24 10 4F 79 07 F7 DA F7 D8 83 DA 00 5F 5B C2 10 00 }
	condition:
		$1
}

rule file_185_0_0 {
	meta:
		name = "___avx_acos4"
		size = 512
		refs = "0010 ___common_dacos_data 01ea ___common_dacos_cout_rare"
	strings:
		$1 = { 55 8B EC 83 E4 C0 81 EC C0 00 00 00 C5 FD 10 35 ?? ?? ?? ?? C5 FD 10 25 ?? ?? ?? ?? C5 FD 11 04 24 C5 CD 56 C8 C5 F5 59 FC C5 FD 11 4C 24 20 C5 F5 C2 1D ?? ?? ?? ?? 12 C5 C5 58 E4 C5 CD 54 E8 C5 F5 59 F1 C5 FD 11 6C 24 40 C5 FD 5A CC C5 CD 5D EC C5 D5 C2 F4 15 C5 DD 58 E4 C4 E3 7D 19 DA 01 C5 E0 C6 FA DD C5 F8 52 D9 C5 F8 50 D7 C5 FC 5A D3 C5 ED 59 FA C5 DD 59 CA C5 DD 59 E7 C5 DD 5C 3D ?? ?? ?? ?? C5 C5 59 1D ?? ?? ?? ?? C5 F5 59 E7 C5 E5 58 15 ?? ?? ?? ?? C5 ED 59 DF C5 E5 58 15 ?? ?? ?? ?? C5 ED 59 FF C5 D5 59 15 ?? ?? ?? ?? C5 C5 58 3D ?? ?? ?? ?? C5 ED 58 15 ?? ?? ?? ?? C5 C5 59 E4 C5 D5 59 3D ?? ?? ?? ?? C5 F5 5C CC C5 C5 58 3D ?? ?? ?? ?? C5 D5 59 25 ?? ?? ?? ?? C5 FD 11 4C 24 60 C5 D5 59 0D ?? ?? ?? ?? C5 DD 58 1D ?? ?? ?? ?? C5 D5 59 E5 C5 F5 58 0D ?? ?? ?? ?? C5 C5 59 FC C5 F5 59 CC C5 C5 58 DB C5 F5 58 CA C5 DD 59 D4 C5 D5 59 3D ?? ?? ?? ?? C5 E5 59 DA C5 C5 58 3D ?? ?? ?? ?? C5 E5 58 C9 C5 F5 59 D4 C5 ED 58 DF C5 D5 59 3D ?? ?? ?? ?? C5 FD 10 54 24 20 C5 E5 59 E4 C5 C5 58 3D ?? ?? ?? ?? C5 DD 58 CF C5 F5 59 FD C5 FD C2 ED 11 C5 CD 54 05 ?? ?? ?? ?? C5 FD 54 CD C5 CD 55 05 ?? ?? ?? ?? C4 E3 6D 4B 74 24 60 60 C5 FD 58 E1 C5 CD 57 5C 24 40 C5 C5 59 FB C5 C5 58 EB C5 DD 58 C5 85 D2 75 04 8B E5 5D C3 C5 FD 10 0C 24 C5 FD 11 84 24 80 00 00 00 C5 FD 11 4C 24 40 74 E6 33 C0 89 74 24 04 8B F0 89 3C 24 8B FA 0F A3 F7 72 18 46 83 FE 20 7C F5 8B 74 24 04 8B 3C 24 C5 FD 10 84 24 80 00 00 00 EB BC C5 F8 77 8D 8C F4 80 00 00 00 8D 44 F4 40 51 50 E8 ?? ?? ?? ?? 83 C4 08 EB CE 8D A4 24 00 00 00 00 8D 9B 00 00 00 00 }
	condition:
		$1
}

rule file_186_0_0 {
	meta:
		name = "__aulldiv"
		size = 104
	strings:
		$1 = { 53 56 8B 44 24 18 0B C0 75 18 8B 4C 24 14 8B 44 24 10 33 D2 F7 F1 8B D8 8B 44 24 0C F7 F1 8B D3 EB 41 8B C8 8B 5C 24 14 8B 54 24 10 8B 44 24 0C D1 E9 D1 DB D1 EA D1 D8 0B C9 75 F4 F7 F3 8B F0 F7 64 24 18 8B C8 8B 44 24 14 F7 E6 03 D1 72 0E 3B 54 24 10 77 08 72 07 3B 44 24 0C 76 01 4E 33 D2 8B C6 5E 5B C2 10 00 }
	condition:
		$1
}

rule file_187_0_0 {
	meta:
		name = "__RTC_Initialize"
		size = 45
		refs = "0002 ___rtc_iaa 0009 ___rtc_izz 0019 @_guard_check_icall@4"
	strings:
		$1 = { 56 BE ?? ?? ?? ?? 8B C6 3D ?? ?? ?? ?? 73 1C 57 8B 3E 85 FF 74 09 8B CF E8 ?? ?? ?? ?? FF D7 83 C6 04 81 FE ?? ?? ?? ?? 72 E6 5F 5E C3 }
	condition:
		$1
}

rule file_187_1_0 {
	meta:
		name = "__RTC_Terminate"
		size = 45
		refs = "0002 ___rtc_taa 0009 ___rtc_tzz 0019 @_guard_check_icall@4"
	strings:
		$1 = { 56 BE ?? ?? ?? ?? 8B C6 3D ?? ?? ?? ?? 73 1C 57 8B 3E 85 FF 74 09 8B CF E8 ?? ?? ?? ?? FF D7 83 C6 04 81 FE ?? ?? ?? ?? 72 E6 5F 5E C3 }
	condition:
		$1
}

rule file_188_0_0 {
	meta:
		name = "___common_dtan_cout_rare"
		size = 128
		refs = "004f __vmldTanHATab"
	strings:
		$1 = { 55 8B EC 83 E4 F8 83 EC 08 8B 55 08 0F B7 4A 06 F2 0F 10 0A 81 E1 F0 7F 00 00 0F B6 42 07 83 E0 7F F2 0F 11 0C 24 81 F9 F0 7F 00 00 88 44 24 07 74 06 33 C0 8B E5 5D C3 8B 45 0C 83 3C 24 00 75 23 81 7C 24 04 00 00 F0 7F 75 19 F2 0F 10 05 ?? ?? ?? ?? F2 0F 59 C8 F2 0F 11 08 B8 01 00 00 00 8B E5 5D C3 F2 0F 59 C9 F2 0F 11 08 33 C0 8B E5 5D C3 8D A4 24 00 00 00 00 8D A4 24 00 00 00 00 }
	condition:
		$1
}

rule file_189_0_0 {
	meta:
		name = "__aullrem"
		size = 117
	strings:
		$1 = { 53 8B 44 24 14 0B C0 75 18 8B 4C 24 10 8B 44 24 0C 33 D2 F7 F1 8B 44 24 08 F7 F1 8B C2 33 D2 EB 50 8B C8 8B 5C 24 10 8B 54 24 0C 8B 44 24 08 D1 E9 D1 DB D1 EA D1 D8 0B C9 75 F4 F7 F3 8B C8 F7 64 24 14 91 F7 64 24 10 03 D1 72 0E 3B 54 24 0C 77 08 72 0E 3B 44 24 08 76 08 2B 44 24 10 1B 54 24 14 2B 44 24 08 1B 54 24 0C F7 DA F7 D8 83 DA 00 5B C2 10 00 }
	condition:
		$1
}

rule file_194_0_0 {
	meta:
		name = "??1type_info@@UAE@XZ"
		size = 20
		refs = "000c ??_7type_info@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_36_164_2 {
	meta:
		name = "??1_Facet_base@std@@UAE@XZ"
		size = 20
		refs = "000c ??_7_Facet_base@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_79_60_2 {
	meta:
		name = "??1_Ref_count_base@std@@UAE@XZ"
		size = 20
		refs = "000c ??_7_Ref_count_base@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_32_144_1 {
	meta:
		name = "??1error_category@std@@UAE@XZ"
		size = 20
		refs = "000c ??_7error_category@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_196_0_0 {
	meta:
		name = "___common_satan_cout_rare"
		size = 1520
		refs = "0048 __vmlsAtanHATab"
	strings:
		$1 = { 55 8B EC 83 E4 F8 53 83 EC 3C 8B 4D 08 0F B7 41 02 25 80 7F 00 00 C1 E8 07 3D FF 00 00 00 0F 84 73 05 00 00 F3 0F 10 09 F3 0F 5A C1 F2 0F 11 44 24 30 80 64 24 37 7F F2 0F 10 44 24 30 0F B6 51 03 C1 EA 07 66 0F 2F 05 ?? ?? ?? ?? 0F 82 1D 04 00 00 F2 0F 10 0D ?? ?? ?? ?? 66 0F 2F C8 0F 86 D2 03 00 00 0F B7 44 24 36 0F 28 F8 25 F0 7F 00 00 C1 E8 04 8B 4C 24 34 F2 0F 11 44 24 10 81 E1 FF FF 0F 00 C1 E0 14 8B 5C 24 14 0B C1 8B CB 81 E3 00 00 08 00 81 E1 00 00 F0 FF 81 CB 00 00 04 00 0B CB 05 00 00 40 C0 C7 44 24 10 00 00 00 00 89 4C 24 14 F2 0F 10 0D ?? ?? ?? ?? 0F 28 E1 F2 0F 5C 7C 24 10 F2 0F 59 E7 F2 0F 11 64 24 18 F2 0F 10 54 24 18 C1 F8 0F F2 0F 5C D7 F2 0F 11 54 24 20 83 E0 F0 F2 0F 10 5C 24 18 F2 0F 10 6C 24 20 C1 E2 07 F2 0F 5C DD F2 0F 11 5C 24 18 0F 28 E8 F2 0F 10 74 24 18 F2 0F 59 2D ?? ?? ?? ?? F2 0F 5C FE F2 0F 11 7C 24 20 F2 0F 10 5C 24 18 F2 0F 10 64 24 20 F2 0F 11 6C 24 18 F2 0F 10 74 24 18 F2 0F 5C 74 24 30 F2 0F 11 74 24 20 F2 0F 10 6C 24 18 F2 0F 10 54 24 20 F2 0F 5C EA F2 0F 11 6C 24 18 F2 0F 10 74 24 18 F2 0F 5C C6 F2 0F 11 44 24 20 F2 0F 10 7C 24 18 F2 0F 10 44 24 10 F2 0F 10 54 24 20 F2 0F 59 F8 F2 0F 59 D0 0F 28 EF F2 0F 58 EA F2 0F 11 6C 24 18 F2 0F 10 74 24 18 F2 0F 5C FE F2 0F 58 D7 F2 0F 11 54 24 20 F2 0F 10 15 ?? ?? ?? ?? F2 0F 10 44 24 18 0F 28 F2 F2 0F 10 6C 24 20 F2 0F 58 F0 F2 0F 11 74 24 18 0F 28 F2 F2 0F 10 7C 24 18 F2 0F 5C F7 F2 0F 11 74 24 20 F2 0F 10 74 24 18 F2 0F 10 7C 24 20 F2 0F 58 F7 F2 0F 11 74 24 28 0F 28 F2 F2 0F 10 7C 24 20 F2 0F 58 C7 F2 0F 11 44 24 20 F2 0F 10 44 24 28 F2 0F 5C F0 F2 0F 11 74 24 28 F2 0F 10 74 24 20 F2 0F 10 7C 24 28 F2 0F 58 F7 F2 0F 11 74 24 28 F2 0F 10 7C 24 18 F2 0F 10 44 24 28 F2 0F 58 C5 0F 28 EF F2 0F 59 E9 F2 0F 11 6C 24 18 F2 0F 10 74 24 18 F2 0F 5C F7 F2 0F 11 74 24 20 F2 0F 10 74 24 18 F2 0F 10 6C 24 20 F2 0F 5C F5 F2 0F 11 74 24 18 F2 0F 10 6C 24 18 F2 0F 5C FD F2 0F 11 7C 24 20 F2 0F 10 74 24 18 F2 0F 10 6C 24 20 F2 0F 58 E8 0F 28 C2 F2 0F 5E C6 F2 0F 59 C8 F2 0F 11 4C 24 20 F2 0F 10 4C 24 20 F2 0F 5C C8 F2 0F 11 4C 24 28 F2 0F 10 44 24 20 F2 0F 10 7C 24 28 F2 0F 5C C7 F2 0F 11 44 24 28 F2 0F 10 4C 24 28 F2 0F 59 F1 F2 0F 5C D6 F2 0F 10 74 24 28 F2 0F 59 EE F2 0F 11 6C 24 20 F2 0F 10 6C 24 20 F2 0F 5C D5 F2 0F 11 54 24 20 F2 0F 10 7C 24 20 F2 0F 10 74 24 28 F2 0F 10 54 24 20 F2 0F 10 6C 24 28 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FA F2 0F 59 FD 0F 28 EE F2 0F 59 F4 F2 0F 59 EB F2 0F 59 DF 0F 28 C7 F2 0F 59 C4 F2 0F 10 3D ?? ?? ?? ?? F2 0F 58 C6 F2 0F 10 90 ?? ?? ?? ?? F2 0F 58 C3 F2 0F 11 44 24 18 0F 28 DD F2 0F 10 74 24 18 0F 28 C2 F2 0F 58 DE F2 0F 11 5C 24 18 F2 0F 10 64 24 18 F2 0F 5C EC F2 0F 58 EE F2 0F 11 6C 24 20 F2 0F 10 5C 24 18 0F 28 EB F2 0F 58 C3 F2 0F 59 EB F2 0F 59 FD F2 0F 10 74 24 20 F2 0F 11 44 24 18 F2 0F 10 4C 24 18 F2 0F 58 3D ?? ?? ?? ?? F2 0F 5C D1 F2 0F 59 FD F2 0F 58 D3 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FD F2 0F 11 54 24 20 F2 0F 10 44 24 18 F2 0F 10 64 24 20 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FD F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FD F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FD F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FD F2 0F 59 DF F2 0F 58 DE F2 0F 58 98 ?? ?? ?? ?? F2 0F 58 DC F2 0F 58 C3 F2 0F 11 44 24 08 0F B6 44 24 0F 83 E0 7F 0B C2 88 44 24 0F F2 0F 5A 5C 24 08 8B 55 0C F3 0F 11 1A E9 57 01 00 00 F2 0F 10 05 ?? ?? ?? ?? C1 E2 07 F2 0F 58 05 ?? ?? ?? ?? F2 0F 11 44 24 08 0F B6 44 24 0F 83 E0 7F 0B C2 88 44 24 0F F2 0F 5A 4C 24 08 8B 55 0C F3 0F 11 0A E9 1E 01 00 00 66 0F 2F 05 ?? ?? ?? ?? 0F 82 8C 00 00 00 0F 28 C8 F2 0F 59 C8 F2 0F 10 15 ?? ?? ?? ?? F2 0F 59 D1 C1 E2 07 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D1 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D1 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D1 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D1 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D1 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D1 F2 0F 59 D0 F2 0F 58 D0 F2 0F 11 54 24 08 0F B6 44 24 0F 83 E0 7F 0B C2 88 44 24 0F F2 0F 5A 44 24 08 8B 55 0C F3 0F 11 02 E9 84 00 00 00 85 C0 74 44 F2 0F 10 0D ?? ?? ?? ?? C1 E2 07 F2 0F 58 C8 F2 0F 11 4C 24 18 F2 0F 10 44 24 18 F2 0F 59 44 24 30 F2 0F 11 44 24 08 0F B6 44 24 0F 83 E0 7F 0B C2 88 44 24 0F F2 0F 5A 54 24 08 8B 55 0C F3 0F 11 12 EB 3C F3 0F 59 C9 F3 0F 11 0C 24 F3 0F 10 04 24 F3 0F 5A C0 C1 E2 07 F2 0F 58 44 24 30 F2 0F 11 44 24 08 0F B6 44 24 0F 83 E0 7F 0B C2 88 44 24 0F F2 0F 5A 4C 24 08 8B 55 0C F3 0F 11 0A 33 C0 83 C4 3C 5B 8B E5 5D C3 F7 01 FF FF 7F 00 75 3A F2 0F 10 05 ?? ?? ?? ?? 0F B6 41 03 83 E0 80 F2 0F 58 05 ?? ?? ?? ?? F2 0F 11 44 24 08 0F B6 54 24 0F 83 E2 7F 0B D0 88 54 24 0F F2 0F 5A 4C 24 08 8B 4D 0C F3 0F 11 09 EB B4 F3 0F 10 01 8B 45 0C F3 0F 58 C0 F3 0F 11 00 EB A3 8D 9B 00 00 00 00 }
	condition:
		$1
}

rule file_199_0_0 {
	meta:
		name = "___avx_expf8"
		size = 320
		refs = "0010 ___common_sexp_data 0136 ___common_sexp_cout_rare"
	strings:
		$1 = { 55 8B EC 83 E4 C0 81 EC C0 00 00 00 C5 FC 10 25 ?? ?? ?? ?? C5 FC 59 0D ?? ?? ?? ?? C5 F8 10 15 ?? ?? ?? ?? C5 F8 10 3D ?? ?? ?? ?? C5 F8 10 1D ?? ?? ?? ?? C5 F4 58 F4 C5 CC 5C CC C5 F8 54 E2 C4 E3 7D 19 C5 01 C5 D9 66 E7 C5 D0 54 EA C5 D1 66 FF C5 D9 6B D7 C5 F4 59 3D ?? ?? ?? ?? C5 D9 EF E4 C5 F4 59 0D ?? ?? ?? ?? C5 E9 63 EC C5 F9 D7 D5 C5 C9 FE D3 C4 E3 7D 19 F4 01 C5 C9 72 F2 17 C5 FC 5C D7 C5 D9 FE DB C5 D1 72 F3 17 C5 EC 5C D1 C5 EC 59 0D ?? ?? ?? ?? C5 F4 58 25 ?? ?? ?? ?? C4 E3 4D 18 DD 01 C5 DC 59 EA C5 D4 58 35 ?? ?? ?? ?? C5 CC 59 FA C5 C4 58 0D ?? ?? ?? ?? C5 F4 59 E2 C5 DC 58 2D ?? ?? ?? ?? C5 D4 59 D2 C5 EC 58 0D ?? ?? ?? ?? C5 E4 59 C9 84 D2 75 08 C5 FC 28 C1 8B E5 5D C3 C5 FC 11 44 24 40 C5 FC 11 8C 24 80 00 00 00 85 D2 74 E5 33 C0 89 74 24 04 8B F0 89 3C 24 8B FA 0F A3 F7 72 18 46 83 FE 20 7C F5 8B 74 24 04 8B 3C 24 C5 FC 10 8C 24 80 00 00 00 EB BB C5 F8 77 8D 8C B4 80 00 00 00 8D 44 B4 40 51 50 E8 ?? ?? ?? ?? 83 C4 08 EB CE 90 }
	condition:
		$1
}

rule file_201_0_0 {
	meta:
		name = "___common_dasin_cout_rare"
		size = 2544
		refs = "0042 __vmldASinHATab"
	strings:
		$1 = { 55 8B EC 83 E4 F8 56 57 53 83 EC 64 8B 55 08 0F B7 42 06 25 F0 7F 00 00 F2 0F 10 12 3D F0 7F 00 00 0F B6 4A 07 0F 84 84 09 00 00 F2 0F 11 54 24 40 83 E1 7F 88 4C 24 47 F2 0F 10 4C 24 40 F2 0F 10 05 ?? ?? ?? ?? 0F B7 05 ?? ?? ?? ?? 66 0F 2F C1 0F 82 3A 09 00 00 F2 0F 10 15 ?? ?? ?? ?? 66 0F 2F D1 0F 86 00 04 00 00 66 0F 2F 0D ?? ?? ?? ?? 0F 86 54 03 00 00 F2 0F 10 15 ?? ?? ?? ?? 0F 28 D9 F2 0F 59 DA 0F 28 F1 F2 0F 11 5C 24 30 F2 0F 10 6C 24 30 F2 0F 11 0C 24 8B 4D 0C F2 0F 5C 6C 24 40 F2 0F 11 6C 24 28 F2 0F 10 44 24 30 F2 0F 10 7C 24 28 F2 0F 5C C7 F2 0F 11 44 24 30 0F 28 C1 F2 0F 10 7C 24 30 F2 0F 5C F7 F2 0F 10 3D ?? ?? ?? ?? F2 0F 11 74 24 28 F2 0F 10 6C 24 30 0F 28 F5 F2 0F 58 C5 F2 0F 59 F5 F2 0F 10 64 24 28 0F 28 DE F2 0F 59 C4 F2 0F 58 D8 F2 0F 59 FB F2 0F 11 5C 24 08 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FB F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FB F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FB F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FB F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FB F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FB F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FB F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FB F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FB F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FB 0F 28 DA F2 0F 59 DE F2 0F 58 3D ?? ?? ?? ?? F2 0F 11 5C 24 30 F2 0F 11 7C 24 10 F2 0F 10 7C 24 30 F2 0F 5C FE F2 0F 11 7C 24 28 F2 0F 10 7C 24 30 F2 0F 10 5C 24 28 F2 0F 5C FB F2 0F 11 7C 24 30 F2 0F 10 5C 24 30 F2 0F 5C F3 F2 0F 11 74 24 28 F2 0F 10 74 24 30 F2 0F 10 7C 24 28 F2 0F 59 E6 F2 0F 58 C7 F2 0F 59 EE F2 0F 59 C8 F2 0F 58 CC 0F 28 E2 F2 0F 59 E5 F2 0F 11 64 24 30 F2 0F 10 7C 24 30 F2 0F 5C FD F2 0F 11 7C 24 28 F2 0F 10 5C 24 30 F2 0F 10 64 24 28 F2 0F 5C DC 0F 28 E5 F2 0F 58 E9 F2 0F 11 5C 24 30 0F 28 DE F2 0F 10 7C 24 30 F2 0F 59 C5 F2 0F 5C E7 F2 0F 11 64 24 28 F2 0F 10 64 24 30 F2 0F 59 DC F2 0F 59 D3 F2 0F 10 7C 24 28 F2 0F 11 7C 24 18 F2 0F 58 F9 F2 0F 11 54 24 30 F2 0F 10 54 24 30 F2 0F 59 F7 F2 0F 5C D3 F2 0F 11 54 24 28 F2 0F 58 F0 F2 0F 10 44 24 30 F2 0F 10 7C 24 28 F2 0F 5C C7 0F 28 FB F2 0F 58 DE F2 0F 11 44 24 30 F2 0F 10 54 24 30 F2 0F 5C FA F2 0F 11 7C 24 28 F2 0F 10 7C 24 08 F2 0F 59 FB F2 0F 10 44 24 30 F2 0F 10 54 24 28 F2 0F 11 54 24 20 F2 0F 10 54 24 10 F2 0F 59 D7 F2 0F 10 3D ?? ?? ?? ?? F2 0F 59 FD F2 0F 10 2D ?? ?? ?? ?? F2 0F 59 EB F2 0F 10 1C 24 F2 0F 58 FD F2 0F 10 2D ?? ?? ?? ?? F2 0F 58 FA F2 0F 59 F5 F2 0F 59 C5 F2 0F 59 6C 24 20 F2 0F 10 15 ?? ?? ?? ?? F2 0F 59 CA F2 0F 59 E2 F2 0F 58 F9 F2 0F 10 4C 24 18 F2 0F 59 CA 0F 28 D3 F2 0F 58 D4 F2 0F 58 F9 F2 0F 11 54 24 30 F2 0F 10 4C 24 30 F2 0F 5C D9 F2 0F 58 DC F2 0F 11 5C 24 28 F2 0F 10 4C 24 30 F2 0F 10 64 24 28 F2 0F 58 FC F2 0F 58 FE 0F 28 F1 F2 0F 58 F0 F2 0F 58 FD F2 0F 11 74 24 30 F2 0F 10 64 24 30 F2 0F 5C CC F2 0F 58 C8 F2 0F 11 4C 24 28 F2 0F 10 4C 24 30 F2 0F 10 44 24 28 0F B6 52 07 F2 0F 58 F8 83 E2 80 F2 0F 58 F9 F2 0F 11 7C 24 38 0F B6 44 24 3F 83 E0 7F 0B C2 88 44 24 3F 33 C0 F2 0F 10 7C 24 38 F2 0F 11 39 83 C4 64 5B 5F 5E 8B E5 5D C3 66 0F 2F 0D ?? ?? ?? ?? 72 4A 8B 4D 0C F2 0F 58 C8 F2 0F 11 4C 24 30 F2 0F 10 44 24 30 F2 0F 59 44 24 40 F2 0F 11 44 24 38 0F B6 44 24 3F 0F B6 52 07 83 E0 7F 83 E2 80 0B C2 88 44 24 3F 33 C0 F2 0F 10 4C 24 38 F2 0F 11 09 83 C4 64 5B 5F 5E 8B E5 5D C3 F2 0F 59 C9 F2 0F 11 4C 24 30 F2 0F 10 44 24 30 0F B6 52 07 83 E2 80 F2 0F 58 44 24 40 F2 0F 11 44 24 38 0F B6 44 24 3F 83 E0 7F 8B 4D 0C 0B C2 88 44 24 3F 33 C0 F2 0F 10 4C 24 38 F2 0F 11 09 83 C4 64 5B 5F 5E 8B E5 5D C3 0F 28 D8 8B C8 81 E1 0F 80 FF FF 25 0F 80 FF FF F2 0F 11 44 24 08 F2 0F 5C D9 F2 0F 59 D3 F2 0F 11 14 24 0F B7 74 24 06 81 E6 F0 7F 00 00 C1 EE 04 81 C6 01 FC FF FF 8B FE F7 DF 81 C7 FF 03 00 00 81 E7 FF 07 00 00 C1 E7 04 0B CF 66 89 4C 24 0E 8B CE F2 0F 59 54 24 08 83 E1 01 0F 28 EA 8B D9 F2 0F 10 35 ?? ?? ?? ?? F2 0F 58 EA 75 03 0F 28 EA F2 0F 59 F5 F2 0F 58 15 ?? ?? ?? ?? 0F 28 FE 0F 28 E5 F2 0F 11 54 24 10 2B F1 8B 7C 24 10 F2 0F 5C FD C1 E3 08 81 E7 FF 01 00 00 03 FB F2 0F 11 7C 24 28 F2 0F 10 4C 24 28 D1 EE F2 0F 5C F1 F2 0F 10 0C FD ?? ?? ?? ?? 0F 28 D6 0F 28 F9 81 C6 FF 03 00 00 F2 0F 59 F9 F2 0F 5C E6 F2 0F 59 F1 F2 0F 59 D7 F2 0F 59 FC F2 0F 5C D0 81 E6 FF 07 00 00 F2 0F 58 D7 F2 0F 10 3D ?? ?? ?? ?? F2 0F 59 FA C1 E6 04 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FA 0B C6 F2 0F 11 44 24 18 66 89 44 24 1E F2 0F 10 44 24 18 F2 0F 59 F0 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FA F2 0F 11 5C 24 20 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FA F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FA F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FA F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FA F2 0F 59 F9 F2 0F 59 CC F2 0F 59 FD F2 0F 10 15 ?? ?? ?? ?? F2 0F 58 F9 0F 28 EA F2 0F 59 EE F2 0F 59 F8 F2 0F 11 6C 24 30 F2 0F 10 64 24 30 F2 0F 5C E6 F2 0F 11 64 24 28 F2 0F 10 44 24 30 F2 0F 10 4C 24 28 F2 0F 10 25 ?? ?? ?? ?? F2 0F 5C C1 F2 0F 58 25 ?? ?? ?? ?? F2 0F 11 44 24 30 F2 0F 10 05 ?? ?? ?? ?? F2 0F 59 C3 F2 0F 59 E3 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C3 F2 0F 10 6C 24 30 F2 0F 58 05 ?? ?? ?? ?? F2 0F 5C F5 F2 0F 59 C3 F2 0F 11 74 24 28 F2 0F 10 74 24 30 F2 0F 10 4C 24 28 F2 0F 11 74 24 40 F2 0F 58 F9 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C3 F2 0F 10 0D ?? ?? ?? ?? 0F 28 F1 F2 0F 58 05 ?? ?? ?? ?? F2 0F 58 35 ?? ?? ?? ?? F2 0F 59 C3 F2 0F 58 F4 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 F3 F2 0F 59 C3 F2 0F 10 2D ?? ?? ?? ?? F2 0F 58 05 ?? ?? ?? ?? F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 C3 F2 0F 58 EE F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C3 0F 28 F3 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C3 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C3 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C3 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C3 F2 0F 59 C3 F2 0F 59 C3 F2 0F 11 44 24 48 F2 0F 58 E8 0F 28 C2 F2 0F 59 C3 F2 0F 59 FD F2 0F 11 44 24 30 F2 0F 11 7C 24 50 F2 0F 10 7C 24 30 F2 0F 5C FB F2 0F 11 7C 24 28 F2 0F 10 6C 24 30 F2 0F 10 44 24 28 F2 0F 5C E8 F2 0F 11 6C 24 30 F2 0F 10 7C 24 30 F2 0F 5C F7 F2 0F 11 74 24 28 F2 0F 10 64 24 30 0F 28 EC 0F 28 C4 F2 0F 59 EC F2 0F 58 C3 F2 0F 59 E1 0F 28 DA F2 0F 59 DD F2 0F 10 7C 24 28 F2 0F 11 5C 24 30 F2 0F 10 74 24 30 F2 0F 59 CF F2 0F 5C F5 F2 0F 59 C7 F2 0F 11 74 24 28 F2 0F 10 74 24 30 F2 0F 10 5C 24 28 F2 0F 5C F3 F2 0F 11 74 24 30 F2 0F 10 5C 24 30 F2 0F 5C EB 0F 28 DC F2 0F 11 6C 24 28 F2 0F 10 74 24 30 F2 0F 59 35 ?? ?? ?? ?? F2 0F 10 6C 24 28 F2 0F 58 DE F2 0F 11 5C 24 30 F2 0F 11 6C 24 58 F2 0F 10 6C 24 30 F2 0F 11 74 24 10 F2 0F 5C E5 F2 0F 10 2D ?? ?? ?? ?? F2 0F 58 E6 F2 0F 11 64 24 28 0F 28 E5 F2 0F 10 5C 24 30 F2 0F 10 74 24 28 F2 0F 58 E3 F2 0F 11 64 24 30 F2 0F 10 64 24 30 F2 0F 5C EC F2 0F 58 EB F2 0F 11 6C 24 28 F2 0F 10 64 24 30 F2 0F 59 D4 F2 0F 10 5C 24 28 F2 0F 11 54 24 30 F2 0F 10 54 24 30 F2 0F 5C D4 F2 0F 11 54 24 28 F2 0F 10 54 24 30 F2 0F 10 6C 24 28 F2 0F 5C D5 F2 0F 11 54 24 30 F2 0F 10 6C 24 30 F2 0F 5C E5 F2 0F 11 64 24 28 F2 0F 10 6C 24 30 F2 0F 10 54 24 28 F2 0F 10 25 ?? ?? ?? ?? F2 0F 58 D6 F2 0F 58 D3 F2 0F 10 5C 24 20 F2 0F 59 E3 F2 0F 58 D1 F2 0F 58 25 ?? ?? ?? ?? F2 0F 10 4C 24 58 F2 0F 59 E3 F2 0F 58 C8 F2 0F 59 0D ?? ?? ?? ?? F2 0F 58 25 ?? ?? ?? ?? F2 0F 58 D1 F2 0F 58 64 24 48 F2 0F 10 44 24 40 F2 0F 59 D0 F2 0F 59 E0 F2 0F 59 C5 F2 0F 10 4C 24 50 F2 0F 58 CA F2 0F 10 15 ?? ?? ?? ?? 0F 28 F2 F2 0F 58 CC F2 0F 5C F0 F2 0F 11 74 24 30 F2 0F 10 7C 24 30 F2 0F 5C D7 F2 0F 5C D0 F2 0F 11 54 24 28 F2 0F 10 15 ?? ?? ?? ?? F2 0F 10 5C 24 30 F2 0F 5C D1 F2 0F 10 44 24 28 0F B6 52 07 F2 0F 58 D0 83 E2 80 F2 0F 58 DA F2 0F 11 5C 24 38 0F B6 44 24 3F 83 E0 7F 0B C2 88 44 24 3F 8B 45 0C F2 0F 10 44 24 38 F2 0F 11 00 33 C0 83 C4 64 5B 5F 5E 8B E5 5D C3 8B 45 0C F2 0F 5C D2 F2 0F 5E D2 F2 0F 11 10 B8 01 00 00 00 83 C4 64 5B 5F 5E 8B E5 5D C3 F2 0F 5E D2 8B 45 0C F2 0F 11 10 F7 42 04 FF FF 0F 00 75 17 B9 01 00 00 00 33 C0 83 3A 00 0F 44 C1 83 C4 64 5B 5F 5E 8B E5 5D C3 33 C0 83 C4 64 5B 5F 5E 8B E5 5D C3 8D A4 24 00 00 00 00 8D 49 00 }
	condition:
		$1
}

rule file_202_0_0 {
	meta:
		name = "?__scrt_initialize_thread_safe_statics@@YAHXZ"
		size = 247
		refs = "000e ?_Tss_mutex@@3U_RTL_CRITICAL_SECTION@@A 0013 ___vcrt_InitializeCriticalSectionEx 001b ??_C@_1BK@MGMFAEKH@?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA3?$AA2?$AA?4?$AAd?$AAl?$AAl?$AA?$AA@ 0021 __imp__GetModuleHandleW@4 0031 ___scrt_fastfail 0036 ??_C@_0BM@HLJJNPAH@InitializeConditionVariable?$AA@ 0040 __imp__GetProcAddress@8 0048 ??_C@_0BJ@JEBJOJFJ@SleepConditionVariableCS?$AA@ 005a ??_C@_0BJ@PGPPEPCC@WakeAllConditionVariable?$AA@ 007f ?_Tss_event@@3PAXA 0088 ?_Tss_cv@@3U_RTL_CONDITION_VARIABLE@@A 0096 @_guard_check_icall@4 00a2 ??$__crt_fast_encode_pointer@P6GHPAU_RTL_CONDITION_VARIABLE@@PAU_RTL_CRITICAL_SECTION@@K@Z@@YAP6GHPAU_RTL_CONDITION_VARIABLE@@PAU_RTL_CRITICAL_SECTION@@K@ZQ6GH01K@Z@Z 00aa ?encoded_sleep_condition_variable_cs@@3P6GHPAU_RTL_CONDITION_VARIABLE@@PAU_RTL_CRITICAL_SECTION@@K@ZA 00b3 ??$__crt_fast_encode_pointer@P6GXPAU_RTL_CONDITION_VARIABLE@@@Z@@YAP6GXPAU_RTL_CONDITION_VARIABLE@@@ZQ6GX0@Z@Z 00bb ?encoded_wake_all_condition_variable@@3P6GXPAU_RTL_CONDITION_VARIABLE@@@ZA 00cb __imp__CreateEventW@16 00e5 ?__scrt_uninitialize_thread_safe_statics@@YAXXZ 00ea _atexit"
	strings:
		$1 = { 55 8B EC 83 EC 14 6A 00 68 A0 0F 00 00 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 89 45 FC 83 7D FC 00 75 07 6A 07 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 45 FC 50 FF 15 ?? ?? ?? ?? 89 45 F8 68 ?? ?? ?? ?? 8B 4D FC 51 FF 15 ?? ?? ?? ?? 89 45 F0 68 ?? ?? ?? ?? 8B 55 FC 52 FF 15 ?? ?? ?? ?? 89 45 EC 83 7D F8 00 74 50 83 7D F0 00 74 4A 83 7D EC 00 74 44 C7 05 ?? ?? ?? ?? 00 00 00 00 68 ?? ?? ?? ?? 8B 45 F8 89 45 F4 8B 4D F4 E8 ?? ?? ?? ?? FF 55 F4 8B 4D F0 51 E8 ?? ?? ?? ?? 83 C4 04 A3 ?? ?? ?? ?? 8B 55 EC 52 E8 ?? ?? ?? ?? 83 C4 04 A3 ?? ?? ?? ?? EB 23 6A 00 6A 00 6A 01 6A 00 FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 75 07 6A 07 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_202_1_0 {
	meta:
		name = "??$__crt_fast_decode_pointer@P6GHPAU_RTL_CONDITION_VARIABLE@@PAU_RTL_CRITICAL_SECTION@@K@Z@@YAP6GHPAU_RTL_CONDITION_VARIABLE@@PAU_RTL_CRITICAL_SECTION@@K@ZQ6GH01K@Z@Z"
		size = 38
		refs = "0004 ___security_cookie 001d ?__crt_rotate_pointer_value@@YAIIH@Z"
		altNames = "??$__crt_fast_decode_pointer@P6AXXZ@@YAP6AXXZQ6AXXZ@Z ??$__crt_fast_decode_pointer@P6GXPAU_RTL_CONDITION_VARIABLE@@@Z@@YAP6GXPAU_RTL_CONDITION_VARIABLE@@@ZQ6GX0@Z@Z ??$__crt_fast_decode_pointer@PAP6AXXZ@@YAPAP6AXXZQAP6AXXZ@Z ??$__crt_fast_decode_pointer@PAX@@YAPAXQAX@Z"
	strings:
		$1 = { 55 8B EC A1 ?? ?? ?? ?? 33 D2 B9 20 00 00 00 F7 F1 52 8B 55 08 33 15 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_202_3_0 {
	meta:
		name = "??$__crt_fast_encode_pointer@P6GHPAU_RTL_CONDITION_VARIABLE@@PAU_RTL_CRITICAL_SECTION@@K@Z@@YAP6GHPAU_RTL_CONDITION_VARIABLE@@PAU_RTL_CRITICAL_SECTION@@K@ZQ6GH01K@Z@Z"
		size = 45
		refs = "0004 ___security_cookie 001e ?__crt_rotate_pointer_value@@YAIIH@Z"
		altNames = "??$__crt_fast_encode_pointer@P6AXXZ@@YAP6AXXZQ6AXXZ@Z ??$__crt_fast_encode_pointer@P6GXPAU_RTL_CONDITION_VARIABLE@@@Z@@YAP6GXPAU_RTL_CONDITION_VARIABLE@@@ZQ6GX0@Z@Z ??$__crt_fast_encode_pointer@PAP6AXXZ@@YAPAP6AXXZQAP6AXXZ@Z ??$__crt_fast_encode_pointer@PAX@@YAPAXQAX@Z"
	strings:
		$1 = { 55 8B EC A1 ?? ?? ?? ?? 33 D2 B9 20 00 00 00 F7 F1 B8 20 00 00 00 2B C2 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 33 05 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_202_6_0 {
	meta:
		name = "?__scrt_uninitialize_thread_safe_statics@@YAXXZ"
		size = 37
		refs = "0004 ?_Tss_mutex@@3U_RTL_CRITICAL_SECTION@@A 000a __imp__DeleteCriticalSection@4 0010 ?_Tss_event@@3PAXA 001f __imp__CloseHandle@4"
	strings:
		$1 = { 55 8B EC 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 74 0C A1 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_202_7_0 {
	meta:
		name = "__Init_thread_abort"
		size = 29
		refs = "0004 __Init_thread_lock 0012 __Init_thread_unlock 0017 __Init_thread_notify"
	strings:
		$1 = { 55 8B EC E8 ?? ?? ?? ?? 8B 45 08 C7 00 00 00 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_202_8_0 {
	meta:
		name = "__Init_thread_footer"
		size = 70
		refs = "0004 __Init_thread_lock 0009 __Init_global_epoch 0021 __tls_index 0028 __tls_array 0036 __Init_thread_epoch 003b __Init_thread_unlock 0040 __Init_thread_notify"
	strings:
		$1 = { 55 8B EC E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 83 C0 01 A3 ?? ?? ?? ?? 8B 4D 08 8B 15 ?? ?? ?? ?? 89 11 A1 ?? ?? ?? ?? 64 8B 0D ?? ?? ?? ?? 8B 14 81 A1 ?? ?? ?? ?? 89 82 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_202_9_0 {
	meta:
		name = "__Init_thread_header"
		size = 105
		refs = "0004 __Init_thread_lock 0026 __Init_thread_wait 003f __Init_thread_unlock 0049 __tls_index 004f __tls_array 0058 __Init_global_epoch 005e __Init_thread_epoch"
	strings:
		$1 = { 55 8B EC E8 ?? ?? ?? ?? 8B 45 08 83 38 00 75 0B 8B 4D 08 C7 01 FF FF FF FF EB 47 8B 55 08 83 3A FF 75 24 6A 64 E8 ?? ?? ?? ?? 83 C4 04 8B 45 08 83 38 00 75 10 8B 4D 08 C7 01 FF FF FF FF E8 ?? ?? ?? ?? EB 22 EB D4 8B 15 ?? ?? ?? ?? 64 A1 ?? ?? ?? ?? 8B 0C 90 8B 15 ?? ?? ?? ?? 89 91 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_202_10_0 {
	meta:
		name = "__Init_thread_lock"
		size = 16
		refs = "0004 ?_Tss_mutex@@3U_RTL_CRITICAL_SECTION@@A 000a __imp__EnterCriticalSection@4"
	strings:
		$1 = { 55 8B EC 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_286_0_0 {
	meta:
		name = "?__scrt_initialize_type_info@@YAXXZ"
		size = 16
		refs = "0004 ?__type_info_root_node@@3U__type_info_node@@A 000a __imp__InitializeSListHead@4"
	strings:
		$1 = { 55 8B EC 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_202_12_0 {
	meta:
		name = "__Init_thread_unlock"
		size = 16
		refs = "0004 ?_Tss_mutex@@3U_RTL_CRITICAL_SECTION@@A 000a __imp__LeaveCriticalSection@4"
	strings:
		$1 = { 55 8B EC 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_335_4_0 {
	meta:
		name = "___scrt_set_unhandled_exception_filter"
		size = 16
		refs = "0004 ___scrt_unhandled_exception_filter@4 000a __imp__SetUnhandledExceptionFilter@4"
	strings:
		$1 = { 55 8B EC 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_202_11_0 {
	meta:
		name = "__Init_thread_notify"
		size = 78
		refs = "0006 ?_Tss_event@@3PAXA 000e ?_Tss_cv@@3U_RTL_CONDITION_VARIABLE@@A 0013 ?encoded_wake_all_condition_variable@@3P6GXPAU_RTL_CONDITION_VARIABLE@@@ZA 0019 ??$__crt_fast_decode_pointer@P6GXPAU_RTL_CONDITION_VARIABLE@@@Z@@YAP6GXPAU_RTL_CONDITION_VARIABLE@@@ZQ6GX0@Z@Z 0027 @_guard_check_icall@4 0039 __imp__SetEvent@4 0046 __imp__ResetEvent@4"
	strings:
		$1 = { 55 8B EC 51 83 3D ?? ?? ?? ?? 00 75 23 68 ?? ?? ?? ?? A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 FC 8B 4D FC E8 ?? ?? ?? ?? FF 55 FC EB 1A 8B 0D ?? ?? ?? ?? 51 FF 15 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 52 FF 15 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_202_13_0 {
	meta:
		name = "__Init_thread_wait"
		size = 187
		refs = "0008 ?_Tss_event@@3PAXA 0014 ?_Tss_mutex@@3U_RTL_CRITICAL_SECTION@@A 0019 ?_Tss_cv@@3U_RTL_CONDITION_VARIABLE@@A 001f ?encoded_sleep_condition_variable_cs@@3P6GHPAU_RTL_CONDITION_VARIABLE@@PAU_RTL_CRITICAL_SECTION@@K@ZA 0025 ??$__crt_fast_decode_pointer@P6GHPAU_RTL_CONDITION_VARIABLE@@PAU_RTL_CRITICAL_SECTION@@K@Z@@YAP6GHPAU_RTL_CONDITION_VARIABLE@@PAU_RTL_CRITICAL_SECTION@@K@ZQ6GH01K@Z@Z 0033 @_guard_check_icall@4 005e ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 006a ??_C@_1HK@LKKBAJNK@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAv?$AAc?$AAs?$AAt?$AAa?$AAr?$AAt?$AAu?$AAp?$AA?2?$AAs?$AAr?$AAc?$AA?2@ 0071 __CrtDbgReportW 007f __Init_thread_unlock 0092 __imp__WaitForSingleObjectEx@12 009a __Init_thread_lock"
	strings:
		$1 = { 55 8B EC 83 EC 10 83 3D ?? ?? ?? ?? 00 75 46 8B 45 08 50 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 83 C4 04 89 45 FC 8B 4D FC E8 ?? ?? ?? ?? FF 55 FC 85 C0 74 09 C7 45 F8 01 00 00 00 EB 07 C7 45 F8 00 00 00 00 8A 45 F8 EB 64 EB 62 83 7D 08 FF 75 23 6A 00 68 ?? ?? ?? ?? 6A 00 68 8F 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 6A 00 8B 45 08 50 8B 0D ?? ?? ?? ?? 51 FF 15 ?? ?? ?? ?? 89 45 F0 E8 ?? ?? ?? ?? 83 7D F0 00 75 09 C7 45 F4 01 00 00 00 EB 07 C7 45 F4 00 00 00 00 8A 45 F4 8B E5 5D C3 }
	condition:
		$1
}

rule file_203_0_0 {
	meta:
		name = "___sse2_ceil2"
		size = 80
		refs = "0006 _2il0floatpacket_4 000d _2il0floatpacket_5 0038 _2il0floatpacket_6"
	strings:
		$1 = { 0F 28 D8 0F 28 15 ?? ?? ?? ?? 0F 28 0D ?? ?? ?? ?? 0F 28 EA 0F 54 D9 0F 55 C8 66 0F C2 E9 01 66 0F 58 CA 66 0F 5C CA 0F 56 CB 0F 28 F5 0F 28 E1 66 0F C2 E0 01 0F 54 25 ?? ?? ?? ?? 0F 54 C5 66 0F 5C CC 0F 55 F1 0F 56 C6 C3 8D 9B 00 00 00 00 }
	condition:
		$1
}

rule file_204_0_0 {
	meta:
		name = "___avx_atan2f8"
		size = 512
		refs = "0010 ___common_satan2_data 01ed ___common_satan2_cout_rare"
	strings:
		$1 = { 55 8B EC 83 E4 C0 81 EC 00 01 00 00 C5 FC 10 35 ?? ?? ?? ?? C5 FC 11 4C 24 20 C5 FC 28 E8 C5 F4 54 E6 C5 D4 54 C6 C5 FC C2 FC 11 C5 FC 11 2C 24 C5 D4 57 D8 C5 DC 56 15 ?? ?? ?? ?? C5 FC 11 5C 24 60 C4 E3 6D 4A E8 70 C4 E3 7D 4A DC 70 C5 F4 C2 15 ?? ?? ?? ?? 12 C5 D4 5E EB C5 F4 57 F4 C5 EC 54 0D ?? ?? ?? ?? C5 FC 11 74 24 40 C5 FC 11 8C 24 80 00 00 00 C5 F8 10 0D ?? ?? ?? ?? C5 C4 55 35 ?? ?? ?? ?? C5 D9 FA D1 C4 E3 7D 19 E3 01 C5 E1 FA E1 C5 F9 FA D9 C4 E3 7D 19 C7 01 C5 C1 FA F9 C5 F8 10 0D ?? ?? ?? ?? C5 E9 66 C1 C5 E9 76 D1 C5 F9 EB D2 C5 E1 66 C1 C5 E1 76 D9 C5 F9 EB C3 C5 D9 66 D9 C5 D9 76 E1 C5 E9 EB C0 C5 E1 EB D4 C5 C1 66 D9 C5 C1 76 F9 C5 E1 EB DF C5 F1 EF C9 C5 E9 EB E3 C5 D4 59 DD C5 F9 6B C4 C5 F9 63 D1 C5 F9 D7 D2 C5 E4 59 E3 C5 DC 59 3D ?? ?? ?? ?? C5 DC 59 05 ?? ?? ?? ?? C5 C4 58 0D ?? ?? ?? ?? C5 FC 58 3D ?? ?? ?? ?? C5 F4 59 D4 C5 C4 59 FC C5 EC 58 05 ?? ?? ?? ?? C5 C4 58 15 ?? ?? ?? ?? C5 FC 59 CC C5 EC 59 D4 C5 F4 58 05 ?? ?? ?? ?? C5 EC 58 0D ?? ?? ?? ?? C5 FC 10 54 24 20 C5 FC 59 E4 C5 F4 59 DB C5 DC 58 05 ?? ?? ?? ?? C5 E4 58 C8 C5 F4 59 ED C5 D4 58 F6 C5 CC 56 44 24 40 C5 FC 58 8C 24 80 00 00 00 C5 F4 56 44 24 60 84 D2 75 04 8B E5 5D C3 C5 FC 10 0C 24 C5 FC 11 94 24 80 00 00 00 C5 FC 11 84 24 C0 00 00 00 C5 FC 11 4C 24 40 85 D2 74 DB 33 C0 89 74 24 04 8B F0 89 3C 24 8B FA 0F A3 F7 72 18 46 83 FE 20 7C F5 8B 74 24 04 8B 3C 24 C5 FC 10 84 24 C0 00 00 00 EB B1 C5 F8 77 8D 8C B4 C0 00 00 00 8D 54 B4 40 8D 84 B4 80 00 00 00 51 50 52 E8 ?? ?? ?? ?? 83 C4 0C EB C6 8D A4 24 00 00 00 00 8D 49 00 }
	condition:
		$1
}

rule file_207_0_0 {
	meta:
		name = "__cosh_spec_sd"
		size = 304
		refs = "004b _static_const_table"
	strings:
		$1 = { 8B 58 04 8B 08 81 E3 FF FF FF 7F 81 FB 36 23 86 40 0F 82 01 01 00 00 0F 87 BA 00 00 00 81 FB 50 3C 9C F4 0F 82 EF 00 00 00 81 FB C3 33 86 40 72 2D 77 08 81 F9 00 79 98 78 72 23 8B 48 50 C1 E1 04 81 E1 F0 03 00 00 66 0F 28 B9 ?? ?? ?? ?? 66 0F 28 EF BB 01 00 00 00 66 0F 15 FF EB 0C F2 0F 10 68 10 F2 0F 10 78 20 33 DB 66 0F 28 DD F2 0F 10 70 40 66 0F 28 D6 66 0F 28 0D ?? ?? ?? ?? F2 0F 59 CE 66 0F 58 EF F2 0F 59 F6 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CA F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CA F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CE F2 0F 58 D1 F2 0F 59 D5 F2 0F 58 D7 85 DB F2 0F 58 D3 74 51 F2 0F 59 15 ?? ?? ?? ?? 33 DB F2 0F 59 15 ?? ?? ?? ?? EB 3D 81 FB CE 33 86 40 0F 82 46 FF FF FF 77 18 81 FB 7D F8 B9 8F 0F 82 38 FF FF FF 33 DB F2 0F 10 15 ?? ?? ?? ?? EB 17 81 FB 00 00 F0 7F 72 EC 77 04 85 C9 74 E8 66 0F 57 D2 66 0F C2 D2 00 85 DB 74 01 C3 66 0F 28 2D ?? ?? ?? ?? 66 0F 58 ED C3 8D A4 24 00 00 00 00 8D 49 00 }
	condition:
		$1
}

rule file_207_1_0 {
	meta:
		name = "___sse2_cosh2"
		size = 560
		refs = "0019 _static_const_table"
	strings:
		$1 = { 8B C4 81 EC E0 00 00 00 83 E4 F0 89 84 24 A4 00 00 00 89 1C 24 66 0F 28 3D ?? ?? ?? ?? 89 7C 24 04 89 74 24 08 66 0F 28 15 ?? ?? ?? ?? 66 0F 54 C7 66 0F 28 1D ?? ?? ?? ?? 66 0F 59 D0 8D 44 24 10 66 0F 28 25 ?? ?? ?? ?? B9 FF FF FF 7F 66 0F 58 D3 66 0F 28 2D ?? ?? ?? ?? BB FF FF FF 7F 66 0F 28 F2 66 0F 29 44 24 10 66 0F 5C D3 66 0F 28 CE 66 0F 59 E2 66 0F 57 DB 23 48 04 66 0F 73 F6 04 66 0F 29 4C 24 60 66 0F 59 EA 23 58 0C 66 0F FB D9 66 0F 5C C4 66 0F 7E F6 66 0F 5C C5 66 0F FE 0D ?? ?? ?? ?? 81 E6 F0 03 00 00 66 0F 15 F6 66 0F FE 1D ?? ?? ?? ?? 66 0F 73 F1 2E 66 0F 7E F7 66 0F 28 BE ?? ?? ?? ?? 81 E7 F0 03 00 00 66 0F 73 F3 2E 66 0F 29 44 24 50 F7 DE 66 0F 28 B7 ?? ?? ?? ?? 81 C6 00 04 00 00 66 0F DB 0D ?? ?? ?? ?? 66 0F 28 EF F7 DF 66 0F DB 1D ?? ?? ?? ?? 66 0F C6 EE 00 81 C7 00 04 00 00 66 0F 28 A6 ?? ?? ?? ?? 66 0F C6 FE 03 66 0F 28 97 ?? ?? ?? ?? 66 0F 59 E9 81 E9 36 23 86 40 66 0F 28 F4 66 0F 59 F9 81 EB 36 23 86 40 66 0F C6 E2 00 66 0F 29 6C 24 20 66 0F 28 C8 66 0F C6 F2 03 66 0F 59 E3 66 0F 28 15 ?? ?? ?? ?? 66 0F 59 C0 66 0F 29 64 24 40 66 0F 59 F3 66 0F 58 EF 66 0F 28 1D ?? ?? ?? ?? 66 0F 59 D0 23 D9 66 0F 58 E6 66 0F 29 7C 24 30 66 0F 59 D8 66 0F 58 15 ?? ?? ?? ?? 66 0F 28 FD 66 0F 58 1D ?? ?? ?? ?? 66 0F 59 D0 66 0F 58 EC 66 0F 59 C3 66 0F 5C FC 66 0F 59 D1 66 0F 59 C5 66 0F 58 D1 66 0F 28 5C 24 30 66 0F 59 D7 66 0F 58 C2 66 0F 28 64 24 40 66 0F 58 C6 66 0F 28 6C 24 20 66 0F 58 C3 F7 C3 00 00 00 80 66 0F 58 C4 66 0F 58 C5 8B 74 24 08 8B 7C 24 04 74 02 EB 29 8D 44 24 10 66 0F 28 E0 66 0F 28 D0 66 0F 15 E4 E8 C9 FC FF FF 83 C0 08 66 0F 28 C2 66 0F 28 D4 E8 B9 FC FF FF 66 0F 14 C2 8B 1C 24 8B A4 24 A4 00 00 00 C3 8D A4 24 00 00 00 00 8D 49 00 }
	condition:
		$1
}

rule file_210_8_0 {
	meta:
		name = "?invoke_main@@YAHXZ"
		size = 32
		refs = "0004 ___scrt_get_show_window_mode 000d __get_narrow_winmain_command_line 0015 ___ImageBase 001a _WinMain@16"
	strings:
		$1 = { 55 8B EC E8 ?? ?? ?? ?? 0F B7 C0 50 E8 ?? ?? ?? ?? 50 6A 00 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_215_8_0 {
	meta:
		name = "?invoke_main@@YAHXZ"
		size = 32
		refs = "0004 ___scrt_get_show_window_mode 000d __get_wide_winmain_command_line 0015 ___ImageBase 001a _wWinMain@16"
	strings:
		$1 = { 55 8B EC E8 ?? ?? ?? ?? 0F B7 C0 50 E8 ?? ?? ?? ?? 50 6A 00 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_212_0_0 {
	meta:
		name = "___avx_atan4"
		size = 432
		refs = "001b ___common_datan_data"
	strings:
		$1 = { 53 8B DC 83 E4 C0 55 55 8B 6B 04 89 6C 24 04 8B EC 81 EC B8 00 00 00 C5 FD 10 3D ?? ?? ?? ?? C5 FD 10 15 ?? ?? ?? ?? C5 FD 54 0D ?? ?? ?? ?? C5 F5 C2 E7 12 C5 FD 54 F2 C5 DD 55 1D ?? ?? ?? ?? C5 E5 57 EE C5 F5 5F DF C5 C5 5D C9 C5 FD 11 AD 48 FF FF FF C5 FD 10 2D ?? ?? ?? ?? C5 FD 10 05 ?? ?? ?? ?? C5 FD 10 3D ?? ?? ?? ?? C5 F5 5E CB C5 FD 10 1D ?? ?? ?? ?? C5 DD 55 E2 C5 DD 57 F6 C5 CD 57 D1 C5 FD 11 95 68 FF FF FF C5 ED 59 D2 C5 FD 10 25 ?? ?? ?? ?? C5 FD 11 55 88 C5 ED 59 D2 C5 FD 10 35 ?? ?? ?? ?? C5 FD 11 55 A8 C5 ED 59 D2 C5 D5 59 EA C5 C5 59 FA C5 FD 59 C2 C5 D5 58 F6 C5 C5 58 FB C5 FD 58 DC C5 ED 59 25 ?? ?? ?? ?? C5 CD 59 F2 C5 C5 59 EA C5 E5 59 DA C5 DD 58 05 ?? ?? ?? ?? C5 CD 58 25 ?? ?? ?? ?? C5 D5 58 3D ?? ?? ?? ?? C5 E5 58 2D ?? ?? ?? ?? C5 FD 59 F2 C5 DD 59 E2 C5 C5 59 FA C5 D5 59 C2 C5 CD 58 1D ?? ?? ?? ?? C5 DD 58 25 ?? ?? ?? ?? C5 FD 58 2D ?? ?? ?? ?? C5 C5 58 35 ?? ?? ?? ?? C5 E5 59 DA C5 DD 59 E2 C5 CD 59 F2 C5 D5 59 EA C5 E5 58 1D ?? ?? ?? ?? C5 DD 58 25 ?? ?? ?? ?? C5 D5 58 05 ?? ?? ?? ?? C5 CD 58 35 ?? ?? ?? ?? C5 E5 59 D2 C5 FD 10 0D ?? ?? ?? ?? C5 ED 58 D9 C5 FD 10 55 88 C5 DD 59 CA C5 CD 59 F2 C5 F5 58 C8 C5 CD 58 EB C5 F5 59 65 A8 C5 DD 58 FD C5 C5 59 85 68 FF FF FF C5 FD 58 85 48 FF FF FF 8B E5 5D 8B E3 5B C3 8D A4 24 00 00 00 00 8D 9B 00 00 00 00 }
	condition:
		$1
}

rule file_216_0_0 {
	meta:
		name = "___avx_ceilf8"
		size = 16
	strings:
		$1 = { C4 E3 7D 08 C0 02 C3 8D A4 24 00 00 00 00 8B FF }
	condition:
		$1
}

rule file_217_0_0 {
	meta:
		name = "___vdecl_ceil2"
		size = 18
		refs = "0002 ___isa_available 0009 ___sse4_ceil2 000e ___sse2_ceil2"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 02 0F 8D ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_231_0_0 {
	meta:
		name = "___vdecl_ceilf4"
		size = 18
		refs = "0002 ___isa_available 0009 ___sse4_ceilf4 000e ___sse2_ceilf4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 02 0F 8D ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_251_0_0 {
	meta:
		name = "___vdecl_exp2"
		size = 18
		refs = "0002 ___isa_available 0009 ___sse4_exp2 000e ___sse2_exp2"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 02 0F 8D ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_355_0_0 {
	meta:
		name = "___vdecl_expf4"
		size = 18
		refs = "0002 ___isa_available 0009 ___sse4_expf4 000e ___sse2_expf4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 02 0F 8D ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_375_0_0 {
	meta:
		name = "___vdecl_floor2"
		size = 18
		refs = "0002 ___isa_available 0009 ___sse4_floor2 000e ___sse2_floor2"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 02 0F 8D ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_244_0_0 {
	meta:
		name = "___vdecl_floorf4"
		size = 18
		refs = "0002 ___isa_available 0009 ___sse4_floorf4 000e ___sse2_floorf4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 02 0F 8D ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_221_0_0 {
	meta:
		name = "??__C@YGXPAX0IHP6EX00@ZP6EX0@Z@Z"
		size = 36
		refs = "001c ??__C@YGXPAX0IIP6EX00@ZP6EX0@Z@Z"
	strings:
		$1 = { 55 8B EC 8B 45 1C 50 8B 4D 18 51 8B 55 14 52 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 5D C2 18 00 }
	condition:
		$1
}

rule file_264_0_0 {
	meta:
		name = "??__D@YGXPAX0IHP6EX00@ZP6EX0@Z@Z"
		size = 36
		refs = "001c ??__D@YGXPAX0IIP6EX00@ZP6EX0@Z@Z"
	strings:
		$1 = { 55 8B EC 8B 45 1C 50 8B 4D 18 51 8B 55 14 52 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 5D C2 18 00 }
	condition:
		$1
}

rule file_221_1_0 {
	meta:
		name = "??__C@YGXPAX0IIP6EX00@ZP6EX0@Z@Z"
		size = 197
		refs = "0006 __sehtable$??__C@YGXPAX0IIP6EX00@ZP6EX0@Z@Z 000b __except_handler4 001d ___security_cookie 0063 @_guard_check_icall@4 00ac ?__ArrayUnwind@@YGXPAXIIP6EX0@Z@Z"
	strings:
		$1 = { 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 EC 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 C7 45 E0 00 00 00 00 C6 45 E7 00 C7 45 FC 00 00 00 00 EB 09 8B 45 E0 83 C0 01 89 45 E0 8B 4D E0 3B 4D 14 74 2C 8B 55 0C 52 8B 45 18 89 45 DC 8B 4D DC E8 ?? ?? ?? ?? 8B 4D 08 FF 55 DC 8B 4D 08 03 4D 10 89 4D 08 8B 55 0C 03 55 10 89 55 0C EB C3 C6 45 E7 01 C7 45 FC FE FF FF FF E8 02 00 00 00 EB 1E 0F B6 45 E7 85 C0 75 15 8B 4D 1C 51 8B 55 E0 52 8B 45 10 50 8B 4D 08 51 E8 ?? ?? ?? ?? C3 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C2 18 00 }
	condition:
		$1
}

rule file_223_0_0 {
	meta:
		name = "??_N@YGXPAXIHP6EX0@Z1@Z"
		size = 32
		refs = "0018 ??_N@YGXPAXIIP6EX0@Z1@Z"
	strings:
		$1 = { 55 8B EC 8B 45 18 50 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 5D C2 14 00 }
	condition:
		$1
}

rule file_308_0_0 {
	meta:
		name = "??_L@YGXPAXIHP6EX0@Z1@Z"
		size = 32
		refs = "0018 ??_L@YGXPAXIIP6EX0@Z1@Z"
	strings:
		$1 = { 55 8B EC 8B 45 18 50 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 5D C2 14 00 }
	condition:
		$1
}

rule file_223_1_0 {
	meta:
		name = "??_N@YGXPAXIIP6EX0@Z1@Z"
		size = 186
		refs = "0006 __sehtable$??_N@YGXPAXIIP6EX0@Z1@Z 000b __except_handler4 001d ___security_cookie 0061 @_guard_check_icall@4 00a1 ?__ArrayUnwind@@YGXPAXIIP6EX0@Z@Z"
	strings:
		$1 = { 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 EC 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 C7 45 E0 00 00 00 00 C6 45 E7 00 C7 45 FC 00 00 00 00 EB 09 8B 45 E0 83 C0 01 89 45 E0 8B 4D E0 3B 4D 10 74 21 6A 01 8B 55 14 89 55 DC 8B 4D DC E8 ?? ?? ?? ?? 8B 4D 08 FF 55 DC 8B 45 08 03 45 0C 89 45 08 EB CE C6 45 E7 01 C7 45 FC FE FF FF FF E8 02 00 00 00 EB 1E 0F B6 4D E7 85 C9 75 15 8B 55 18 52 8B 45 E0 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? C3 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C2 14 00 }
	condition:
		$1
}

rule file_224_0_0 {
	meta:
		name = "??_U@YAPAXIABUnothrow_t@std@@@Z"
		size = 21
		refs = "000c ??2@YAPAXIABUnothrow_t@std@@@Z"
	strings:
		$1 = { 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_80_7_1 {
	meta:
		name = "??$?8V?$allocator@D@std@@V01@@std@@YA_NABU?$_Wrap_alloc@V?$allocator@D@std@@@0@0@Z"
		size = 21
		refs = "000c ??$?8DD@std@@YA_NABV?$allocator@D@0@0@Z"
	strings:
		$1 = { 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_44_26_2 {
	meta:
		name = "??$?8V?$allocator@G@std@@V01@@std@@YA_NABU?$_Wrap_alloc@V?$allocator@G@std@@@0@0@Z"
		size = 21
		refs = "000c ??$?8GG@std@@YA_NABV?$allocator@G@0@0@Z"
	strings:
		$1 = { 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_44_27_2 {
	meta:
		name = "??$?8V?$allocator@_W@std@@V01@@std@@YA_NABU?$_Wrap_alloc@V?$allocator@_W@std@@@0@0@Z"
		size = 21
		refs = "000c ??$?8_W_W@std@@YA_NABV?$allocator@_W@0@0@Z"
	strings:
		$1 = { 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_59_22_3 {
	meta:
		name = "??$_Swap_adl@PAD@std@@YAXAAPAD0@Z"
		size = 21
		refs = "000c ??$swap@PADX@std@@YAXAAPAD0@Z"
	strings:
		$1 = { 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_59_45_3 {
	meta:
		name = "??$iter_swap@PADPAD@std@@YAXPAD0@Z"
		size = 21
		refs = "000c ??$swap@DX@std@@YAXAAD0@Z"
	strings:
		$1 = { 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_263_0_0 {
	meta:
		name = "??3@YAXPAXHPBDH@Z"
		size = 21
		refs = "000c __free_dbg"
	strings:
		$1 = { 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_9_0_3 {
	meta:
		name = "__LDscale"
		size = 21
		refs = "000c __Dscale"
	strings:
		$1 = { 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_37_0_3 {
	meta:
		name = "__LDunscale"
		size = 21
		refs = "000c __Dunscale"
	strings:
		$1 = { 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_97_164_2 {
	meta:
		name = "__Lstat"
		size = 21
		refs = "000c __Stat"
	strings:
		$1 = { 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_229_0_0 {
	meta:
		name = "___avx_tanh4"
		size = 720
		refs = "0018 ___common_dtanh_data 02c3 ___common_dtanh_cout_rare"
	strings:
		$1 = { 55 8B EC 83 E4 C0 56 57 81 EC 38 01 00 00 C5 FD 11 44 24 20 C5 F8 10 25 ?? ?? ?? ?? C5 F8 10 1D ?? ?? ?? ?? C5 FD 54 0D ?? ?? ?? ?? C5 FD 54 15 ?? ?? ?? ?? C5 FD 11 14 24 C4 E3 7D 19 C5 01 C5 F8 C6 FD DD C5 C1 DB 2D ?? ?? ?? ?? C5 D1 66 35 ?? ?? ?? ?? C5 D9 66 E5 C5 C9 EB D4 C5 C1 EF FF C5 D1 FA 35 ?? ?? ?? ?? C5 C9 66 C7 C5 F8 50 FA C5 C9 DB E0 C5 C9 66 D3 C4 E3 59 4A DB 20 C5 C9 72 D3 0A C5 F9 7E F0 C4 E3 79 16 F2 01 C4 E3 79 16 F1 02 C4 E3 79 16 F6 03 C5 F9 10 A0 ?? ?? ?? ?? C5 F9 10 9A ?? ?? ?? ?? C5 F9 10 B0 ?? ?? ?? ?? C4 E3 5D 18 A9 ?? ?? ?? ?? 01 C4 E3 65 18 BE ?? ?? ?? ?? 01 C5 F9 10 A2 ?? ?? ?? ?? C5 D5 15 C7 C5 FD 11 44 24 40 C5 F9 10 80 ?? ?? ?? ?? C4 E3 4D 18 91 ?? ?? ?? ?? 01 C4 E3 5D 18 AE ?? ?? ?? ?? 01 C5 F9 10 B2 ?? ?? ?? ?? C5 ED 15 FD C5 ED 14 DD C5 FD 11 BC 24 80 00 00 00 C5 F9 10 B8 ?? ?? ?? ?? C5 FD 11 5C 24 60 C4 E3 4D 18 96 ?? ?? ?? ?? 01 C5 F9 10 B2 ?? ?? ?? ?? C4 E3 7D 18 99 ?? ?? ?? ?? 01 C5 E5 14 E2 C5 E5 15 EA C5 FD 11 AC 24 C0 00 00 00 C5 F9 10 80 ?? ?? ?? ?? C5 FD 11 A4 24 A0 00 00 00 C4 E3 45 18 99 ?? ?? ?? ?? 01 C4 E3 4D 18 96 ?? ?? ?? ?? 01 C5 E5 15 EA C5 FD 11 AC 24 00 01 00 00 C5 F9 10 B2 ?? ?? ?? ?? C5 F9 10 BA ?? ?? ?? ?? C5 F9 10 A8 ?? ?? ?? ?? C5 E5 14 E2 C5 FD 11 A4 24 E0 00 00 00 C4 E3 4D 18 96 ?? ?? ?? ?? 01 C4 E3 55 18 B1 ?? ?? ?? ?? 01 C4 E3 7D 18 99 ?? ?? ?? ?? 01 C5 E5 14 E2 C5 E5 15 DA C5 F9 10 80 ?? ?? ?? ?? C4 E3 45 18 AE ?? ?? ?? ?? 01 C5 CD 14 D5 C5 CD 15 ED C5 F9 10 B2 ?? ?? ?? ?? C4 E3 7D 18 81 ?? ?? ?? ?? 01 C4 E3 4D 18 B6 ?? ?? ?? ?? 01 C5 FD 14 FE C5 F5 58 F7 C5 D5 59 CE C5 F5 58 C2 C5 FD 59 CE C5 F5 58 D3 C5 ED 59 DE C5 E5 58 E4 C5 DD 59 EE C5 D5 58 BC 24 00 01 00 00 C5 C5 59 C6 C5 FD 58 8C 24 E0 00 00 00 C5 F5 59 D6 C5 ED 58 9C 24 C0 00 00 00 C5 E5 59 E6 C5 DD 58 AC 24 A0 00 00 00 C5 D5 59 FE C5 C5 58 84 24 80 00 00 00 C5 FD 59 CE C5 F5 58 54 24 60 C5 ED 59 F6 C5 CD 58 44 24 40 C5 FD 56 04 24 85 FF 75 0C 81 C4 38 01 00 00 5F 5E 8B E5 5D C3 C5 FD 10 4C 24 20 C5 FD 11 44 24 40 C5 FD 11 0C 24 74 E1 33 F6 0F A3 F7 72 18 46 83 FE 20 7C F5 C5 FD 10 44 24 40 81 C4 38 01 00 00 5F 5E 8B E5 5D C3 C5 F8 77 8D 44 F4 40 8D 14 F4 50 52 E8 ?? ?? ?? ?? 83 C4 08 EB D2 8D 64 24 00 }
	condition:
		$1
}

rule file_237_0_0 {
	meta:
		name = "__alloca_probe_16"
		size = 44
		refs = "0012 __chkstk"
	strings:
		$1 = { 51 8D 4C 24 08 2B C8 83 E1 0F 03 C1 1B C9 0B C1 59 E9 ?? ?? ?? ?? 51 8D 4C 24 08 2B C8 83 E1 07 03 C1 1B C9 0B C1 59 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_240_0_0 {
	meta:
		name = "___sse4_ceilf4"
		size = 16
	strings:
		$1 = { 66 0F 3A 08 C0 02 C3 8D A4 24 00 00 00 00 8B FF }
	condition:
		$1
}

rule file_245_0_0 {
	meta:
		name = "___sse2_floor2"
		size = 80
		refs = "0006 _2il0floatpacket_4 0010 _2il0floatpacket_5 0038 _2il0floatpacket_6"
	strings:
		$1 = { 0F 28 D8 0F 28 15 ?? ?? ?? ?? 0F 28 E0 0F 28 0D ?? ?? ?? ?? 0F 28 EA 0F 54 D9 0F 55 C8 66 0F C2 E9 01 66 0F 58 CA 66 0F 5C CA 0F 56 CB 0F 28 F5 66 0F C2 E1 01 0F 54 25 ?? ?? ?? ?? 0F 54 C5 66 0F 5C CC 0F 55 F1 0F 56 C6 C3 8D 9B 00 00 00 00 }
	condition:
		$1
}

rule file_247_0_0 {
	meta:
		name = "___vdecl_fmod2"
		size = 55
		refs = "0016 __CIfmod"
	strings:
		$1 = { 83 EC 20 F3 0F 7F 04 24 F3 0F 7F 4C 24 10 DD 04 24 DD 44 24 10 E8 ?? ?? ?? ?? DD 1C 24 DD 44 24 08 DD 44 24 18 E8 ?? ?? ?? ?? DD 5C 24 08 F3 0F 6F 04 24 83 C4 20 C3 }
	condition:
		$1
}

rule file_248_0_0 {
	meta:
		name = "@_guard_check_icall@4"
		size = 20
		refs = "000c ___guard_check_icall_fptr"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC FF 15 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_254_0_0 {
	meta:
		name = "_TestInt"
		size = 144
	strings:
		$1 = { 57 8B 7C 24 0C 81 E7 FF FF FF 7F 8B D7 8B 44 24 08 0B D0 74 69 8D 97 00 00 10 C0 81 FA 00 00 00 40 73 3E 81 FF 00 00 40 43 7D 53 8B CF 81 E1 00 00 F0 7F 81 C1 00 00 10 C0 C1 F9 14 83 F9 14 7F 24 8B D7 D3 E2 C1 E2 0C 0B D0 75 15 83 C1 0B D3 E7 F7 D7 81 E7 00 00 00 80 C1 EF 1F 47 8B C7 5F C3 33 C0 5F C3 83 C1 0B D3 E0 A9 FF FF FF 7F 75 F0 F7 D0 25 00 00 00 80 C1 E8 1F 40 5F C3 B8 02 00 00 00 5F C3 8D A4 24 00 00 00 00 8D 64 24 00 }
	condition:
		$1
}

rule file_254_1_0 {
	meta:
		name = "__vmldPow_HA_scalar"
		size = 1248
		refs = "01af _2il0floatpacket_6 020c INF_c_1917_0_4 034a _2il0floatpacket_5 0446 QNaN_c_1917_0_4"
	strings:
		$1 = { 55 8B EC 83 E4 F8 56 57 53 83 EC 2C F2 0F 10 4D 08 8B 4D 0C 8B F1 F2 0F 11 4C 24 08 81 E1 00 00 00 80 8B 45 14 8B D8 8B F8 81 E6 FF FF FF 7F F2 0F 10 45 10 81 E3 FF FF FF 7F 89 4C 24 1C 81 E7 00 00 00 80 8B 4C 24 08 81 FE 00 00 F0 7F F2 0F 11 04 24 89 74 24 0C 8B 55 10 89 5C 24 04 89 7C 24 10 89 4C 24 24 0F 84 57 04 00 00 C7 44 24 08 00 00 00 00 8B 0C 24 81 FB 00 00 F0 7F 89 4C 24 0C 0F 84 24 04 00 00 C7 44 24 20 00 00 00 00 8B CE 81 E1 00 00 F0 7F 81 F9 00 00 F0 7F 0F 84 F1 03 00 00 C7 04 24 00 00 00 00 8B CB 81 E1 00 00 F0 7F 81 F9 00 00 F0 7F 0F 84 BE 03 00 00 C7 44 24 28 00 00 00 00 8B FE B9 01 00 00 00 0B 7C 24 24 BF 00 00 00 00 0F 44 F9 89 7C 24 18 8B 7C 24 20 0B 7C 24 28 BF 00 00 00 00 0F 44 F9 81 FE 00 00 F0 3F 89 7C 24 14 0F 84 67 03 00 00 C7 44 24 04 00 00 00 00 25 FF FF FF 7F 8B CA 0B C8 74 69 8D 88 00 00 10 C0 81 F9 00 00 00 40 73 3A 3D 00 00 40 43 7D 54 8B C8 81 E1 00 00 F0 7F 81 C1 00 00 10 C0 C1 F9 14 83 F9 14 7F 21 8B F8 D3 E7 C1 E7 0C 0B FA 75 12 83 C1 0B D3 E0 F7 D0 25 00 00 00 80 C1 E8 1F 40 EB 26 33 C0 EB 22 83 C1 0B D3 E2 F7 C2 FF FF FF 7F 75 EF F7 D2 81 E2 00 00 00 80 C1 EA 1F 8D 42 01 EB 05 B8 02 00 00 00 81 FE 00 00 F0 3F 7E 07 BA 01 00 00 00 EB 08 0F 84 C1 02 00 00 33 D2 0B 5C 24 0C 0F 84 90 02 00 00 83 7C 24 1C 00 75 17 83 7C 24 04 00 74 2E D9 05 ?? ?? ?? ?? 83 C4 2C 5B 5F 5E 8B E5 5D C3 83 7C 24 04 00 74 17 83 7C 24 20 00 74 10 D9 05 ?? ?? ?? ?? 83 C4 2C 5B 5F 5E 8B E5 5D C3 83 3C 24 00 0F 85 38 02 00 00 83 7C 24 28 00 0F 85 1B 02 00 00 83 7C 24 18 00 74 23 83 7C 24 10 00 74 1C 83 7C 24 20 00 74 15 E8 D6 02 00 00 DD 05 ?? ?? ?? ?? 83 C4 2C 5B 5F 5E 8B E5 5D C3 85 D2 74 3B 83 7C 24 10 00 75 17 83 7C 24 20 00 74 2D DD 05 ?? ?? ?? ?? 83 C4 2C 5B 5F 5E 8B E5 5D C3 83 7C 24 20 00 74 16 66 0F EF C0 F3 0F 11 04 24 D9 04 24 83 C4 2C 5B 5F 5E 8B E5 5D C3 81 FE 00 00 F0 3F 7D 3B 83 7C 24 10 00 75 1D 83 7C 24 20 00 74 2D 66 0F EF C0 F3 0F 11 04 24 D9 04 24 83 C4 2C 5B 5F 5E 8B E5 5D C3 83 7C 24 20 00 74 10 DD 05 ?? ?? ?? ?? 83 C4 2C 5B 5F 5E 8B E5 5D C3 83 7C 24 1C 00 75 62 83 7C 24 08 00 74 27 83 7C 24 10 00 74 06 66 0F EF C0 EB 08 F2 0F 10 05 ?? ?? ?? ?? F2 0F 11 04 24 DD 04 24 83 C4 2C 5B 5F 5E 8B E5 5D C3 83 7C 24 18 00 0F 84 19 01 00 00 83 7C 24 10 00 0F 84 E1 00 00 00 83 F8 01 0F 85 9B 00 00 00 E8 EB 01 00 00 DD 05 ?? ?? ?? ?? 83 C4 2C 5B 5F 5E 8B E5 5D C3 83 7C 24 08 00 74 54 83 7C 24 10 00 75 2A F2 0F 10 05 ?? ?? ?? ?? 83 F8 01 66 0F EF C9 F2 0F 5C C8 74 03 0F 28 C8 F2 0F 11 0C 24 DD 04 24 83 C4 2C 5B 5F 5E 8B E5 5D C3 83 F8 01 66 0F EF C0 75 08 F2 0F 10 05 ?? ?? ?? ?? F2 0F 11 04 24 DD 04 24 83 C4 2C 5B 5F 5E 8B E5 5D C3 83 7C 24 14 00 74 11 85 C0 75 0D 83 7C 24 18 00 0F 84 C9 00 00 00 EB 07 83 7C 24 18 00 74 76 83 7C 24 10 00 74 3D 83 F8 01 74 15 E8 50 01 00 00 DD 05 ?? ?? ?? ?? 83 C4 2C 5B 5F 5E 8B E5 5D C3 E8 3B 01 00 00 66 0F EF C0 F2 0F 5C 05 ?? ?? ?? ?? F2 0F 11 04 24 DD 04 24 83 C4 2C 5B 5F 5E 8B E5 5D C3 83 F8 01 74 1D 83 7C 24 14 00 74 26 66 0F EF C0 F3 0F 11 04 24 D9 04 24 83 C4 2C 5B 5F 5E 8B E5 5D C3 DD 05 ?? ?? ?? ?? 83 C4 2C 5B 5F 5E 8B E5 5D C3 66 0F EF C0 F3 0F 11 04 24 D9 04 24 83 C4 2C 5B 5F 5E 8B E5 5D C3 F2 0F 11 04 24 DD 04 24 83 C4 2C 5B 5F 5E 8B E5 5D C3 F2 0F 11 0C 24 DD 04 24 83 C4 2C 5B 5F 5E 8B E5 5D C3 D9 05 ?? ?? ?? ?? 83 C4 2C 5B 5F 5E 8B E5 5D C3 E8 0C 0C 00 00 DD 05 ?? ?? ?? ?? 83 C4 2C 5B 5F 5E 8B E5 5D C3 83 7C 24 24 00 0F 85 27 FD FF FF E9 2F FD FF FF 33 FF B9 01 00 00 00 83 7C 24 24 00 0F 44 F9 89 7C 24 04 E9 89 FC FF FF 33 FF B9 01 00 00 00 83 7C 24 20 00 0F 44 F9 89 7C 24 28 E9 32 FC FF FF 33 FF B9 01 00 00 00 83 7C 24 08 00 0F 44 F9 89 3C 24 E9 FF FB FF FF 33 FF B9 01 00 00 00 83 7C 24 0C 00 0F 44 F9 89 7C 24 20 E9 CC FB FF FF B9 01 00 00 00 33 FF 83 7C 24 24 00 0F 44 F9 89 7C 24 08 E9 99 FB FF FF EB 03 CC CC CC }
	condition:
		$1
}

rule file_254_2_0 {
	meta:
		name = "__raise_zerodivide"
		size = 32
	strings:
		$1 = { 66 0F 76 DB 66 0F 72 F3 1F 0F 57 D2 F3 0F 5E DA C3 8D A4 24 00 00 00 00 8D A4 24 00 00 00 00 90 }
	condition:
		$1
}

rule file_254_3_0 {
	meta:
		name = "_pow_scalar"
		size = 1808
		refs = "0096 _static_const_table"
	strings:
		$1 = { 60 8B C4 83 E4 F0 81 EC C0 00 00 00 89 04 24 8D 74 24 30 8D 54 24 38 66 0F D6 44 24 30 66 0F D6 4C 24 38 8B FA 33 C0 BB 00 00 F0 3F 89 44 24 10 89 44 24 14 89 44 24 20 89 5C 24 24 F3 0F 7E 1E 8B 47 04 25 FF FF FF 7F 8B 1F 0B D8 0F 84 F6 05 00 00 3D 00 00 F0 7F 0F 83 EB 05 00 00 8B 56 04 81 EA 00 00 10 80 81 FA FF FF DF FF 0F 8F 32 05 00 00 8B FF F3 0F 7E D3 66 0F 73 D2 20 66 0F 7E D0 F3 0F 7E D3 25 00 FE 0F 00 05 00 02 00 00 C1 E8 0A 66 0F DB 15 ?? ?? ?? ?? 66 0F FB 1D ?? ?? ?? ?? 66 0F EB 15 ?? ?? ?? ?? 66 0F 72 E3 14 66 0F DB 1D ?? ?? ?? ?? F3 0F 7E 04 C5 ?? ?? ?? ?? 03 C0 66 0F D6 54 24 40 66 0F D6 44 24 50 66 0F FA 5C 24 10 66 0F FE 1D ?? ?? ?? ?? F2 0F 59 C2 F3 0F 7E 0C C5 ?? ?? ?? ?? F3 0F 7E 14 C5 ?? ?? ?? ?? F2 0F 5C 1D ?? ?? ?? ?? 66 0F D6 54 24 60 F2 0F 58 D9 F3 0F 7E 0D ?? ?? ?? ?? F3 0F 7E 54 24 40 66 0F DB 4C 24 40 F2 0F 5C D1 F2 0F 59 4C 24 50 F2 0F 59 54 24 50 F2 0F 5C C8 F2 0F 58 05 ?? ?? ?? ?? F2 0F 58 CA F3 0F 7E D3 F2 0F 58 D8 F2 0F 5C D3 F2 0F 58 D0 66 0F D6 44 24 70 F3 0F 7E C3 66 0F D6 9C 24 80 00 00 00 F2 0F 58 D9 F2 0F 5C C3 F2 0F 58 C1 F2 0F 58 4C 24 70 F2 0F 58 C2 F3 0F 7E 15 ?? ?? ?? ?? F2 0F 59 D1 F2 0F 58 44 24 60 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D1 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D1 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D1 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D1 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D1 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D1 F2 0F 58 C2 F3 0F 7E D3 F2 0F 58 D8 F3 0F 7E 0F F2 0F 5C D3 F2 0F 58 C2 F3 0F 7E D3 66 0F DB 15 ?? ?? ?? ?? F2 0F 5C DA 66 0F D6 94 24 90 00 00 00 8B 84 24 84 00 00 00 8B 5F 04 25 00 00 F0 7F 81 E3 00 00 F0 7F 03 C3 3D 00 00 90 80 0F 87 5A 04 00 00 F3 0F 7E D1 F2 0F 59 C1 66 0F DB 0D ?? ?? ?? ?? 66 0F D6 84 24 A0 00 00 00 F3 0F 7E C3 F2 0F 5C D1 F2 0F 59 D9 F2 0F 59 C2 F2 0F 59 94 24 90 00 00 00 F2 0F 59 8C 24 90 00 00 00 F2 0F 58 C3 F2 0F 58 C2 F3 0F 7E D1 F2 0F 58 0D ?? ?? ?? ?? 66 0F 7E C8 F3 0F 7E 1D ?? ?? ?? ?? F2 0F 5C D9 66 0F 73 F1 2D 3D 80 00 02 00 0F 8D FB 00 00 00 3D 80 FF 01 00 7D 18 3D 00 E6 FD FF 0F 8E 05 01 00 00 3D 00 1E FE FF 0F 8E 0E 01 00 00 EB 1C 66 0F FB 0D ?? ?? ?? ?? F3 0F 7E 64 24 20 66 0F 59 25 ?? ?? ?? ?? 66 0F D6 64 24 20 83 E0 7F 03 C0 66 0F FE 0D ?? ?? ?? ?? 66 0F DB 0D ?? ?? ?? ?? F2 0F 58 DA F2 0F 58 84 24 A0 00 00 00 F2 0F 58 C3 66 0F D6 8C 24 B0 00 00 00 F3 0F 7E 14 C5 ?? ?? ?? ?? F3 0F 7E 1C C5 ?? ?? ?? ?? F3 0F 7E 0D ?? ?? ?? ?? F2 0F 59 C8 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 C8 F2 0F 59 C8 F2 0F 59 C8 F2 0F 59 C8 F2 0F 59 CA F2 0F 58 CB F3 0F 7E 1D ?? ?? ?? ?? F2 0F 59 D8 F2 0F 58 1D ?? ?? ?? ?? F2 0F 59 D8 F2 0F 59 D8 F2 0F 59 DA F2 0F 58 CB F2 0F 59 05 ?? ?? ?? ?? F2 0F 59 C2 F2 0F 58 C8 F2 0F 58 CA F2 0F 59 4C 24 20 F2 0F 59 8C 24 B0 00 00 00 F3 0F 7E C1 E9 77 03 00 00 8D 49 00 F3 0F 7E 44 24 20 66 0F DB 05 ?? ?? ?? ?? 66 0F EB 05 ?? ?? ?? ?? E9 59 03 00 00 90 F3 0F 7E 44 24 20 66 0F DB 05 ?? ?? ?? ?? E9 45 03 00 00 90 66 0F D4 0D ?? ?? ?? ?? F3 0F 7E 64 24 20 66 0F 59 25 ?? ?? ?? ?? 66 0F D6 64 24 20 83 E0 7F 03 C0 66 0F FE 0D ?? ?? ?? ?? 66 0F DB 0D ?? ?? ?? ?? F2 0F 58 DA F2 0F 58 84 24 A0 00 00 00 F3 0F 7E D3 F2 0F 58 D8 F2 0F 5C D3 F2 0F 58 C2 F3 0F 7E 14 C5 ?? ?? ?? ?? F3 0F 7E 24 C5 ?? ?? ?? ?? F3 0F 7E 6C 24 20 F2 0F 59 EA F2 0F 59 E9 66 0F DB 2D ?? ?? ?? ?? 66 0F 66 2D ?? ?? ?? ?? 66 0F 50 C5 A9 01 00 00 00 0F 84 BD 00 00 00 F3 0F 7E 2D ?? ?? ?? ?? F2 0F 59 EB F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 EB 66 0F D6 8C 24 B0 00 00 00 F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 EB F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 EB F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 C5 F2 0F 59 DD F3 0F 7E EB 66 0F DB 2D ?? ?? ?? ?? F3 0F 7E F3 F2 0F 5C DD F2 0F 58 C3 F3 0F 7E DA 66 0F DB 15 ?? ?? ?? ?? F3 0F 7E FB F2 0F 5C DA F2 0F 59 F4 F3 0F 7E C8 F2 0F 59 C3 F2 0F 58 C6 F2 0F 59 CA F2 0F 58 C1 F2 0F 58 C4 F2 0F 59 DD F2 0F 58 C3 F2 0F 59 D5 F2 0F 58 C2 F2 0F 58 C7 F3 0F 7E 8C 24 B0 00 00 00 F2 0F 59 4C 24 20 F2 0F 59 C1 E9 FA 01 00 00 F3 0F 7E 2D ?? ?? ?? ?? F2 0F 59 EB F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 EB F2 0F 59 EB F2 0F 59 EB F2 0F 59 EB F2 0F 59 EA F2 0F 58 EC F3 0F 7E 35 ?? ?? ?? ?? F2 0F 59 F3 F2 0F 58 35 ?? ?? ?? ?? F2 0F 59 F3 F2 0F 59 F3 F2 0F 59 F2 F2 0F 58 EE F2 0F 59 1D ?? ?? ?? ?? F2 0F 59 DA F2 0F 58 EB F3 0F 7E C2 66 0F DB 15 ?? ?? ?? ?? F2 0F 5C C2 F3 0F 7E F5 66 0F DB 2D ?? ?? ?? ?? F2 0F 5C F5 F2 0F 58 C6 F2 0F 58 C5 66 0F 59 C1 66 0F 59 D1 F2 0F 58 C2 F2 0F 59 44 24 20 E9 5B 01 00 00 8D 49 00 8B 46 04 8B 56 04 8B 1E 25 FF FF FF 7F 3D 00 00 F0 7F 0F 83 8C 00 00 00 0B D8 0F 84 84 00 00 00 81 FA 00 00 10 00 73 16 66 0F 59 1D ?? ?? ?? ?? B8 34 00 00 00 89 44 24 14 E9 92 FA FF FF 60 83 EC 10 F3 0F 7E 07 66 0F D6 04 24 E8 7C F4 FF FF 83 C4 10 89 44 24 24 61 8B 44 24 04 83 F8 00 74 43 66 0F EF 1D ?? ?? ?? ?? A9 01 00 00 00 74 09 B8 00 00 F0 BF 89 44 24 24 81 E2 FF FF FF 7F 81 FA 00 00 10 00 0F 87 45 FA FF FF 66 0F 59 1D ?? ?? ?? ?? B8 34 00 00 00 89 44 24 14 E9 2F FA FF FF 8D 49 00 F3 0F 7E 06 F3 0F 7E 0F 60 83 EC 10 66 0F D6 04 24 66 0F D6 4C 24 08 E8 9C F4 FF FF 83 C4 10 61 DD 5C 24 40 F3 0F 7E 44 24 40 E9 85 00 00 00 90 60 83 EC 10 F3 0F 7E 07 66 0F D6 04 24 E8 E6 F3 FF FF 83 C4 10 89 44 24 24 61 8B 44 24 04 8B 5F 04 8B 94 24 84 00 00 00 33 DA 81 FB 00 00 00 80 73 2E 8B 5E 04 81 FB 00 00 00 80 73 0A F3 0F 7E 05 ?? ?? ?? ?? EB 3D 83 F8 00 74 84 66 0F C4 C0 00 66 0F 73 F0 3F 66 0F EB 05 ?? ?? ?? ?? EB 24 8B 5E 04 81 FB 00 00 00 80 73 06 66 0F EF C0 EB 13 83 F8 00 0F 84 56 FF FF FF 66 0F C4 C0 00 66 0F 73 F0 3F 8B 24 24 61 C3 8D A4 24 00 00 00 00 8D A4 24 00 00 00 00 90 }
	condition:
		$1
}

rule file_254_4_0 {
	meta:
		name = "___sse2_pow2"
		size = 1088
		refs = "001e _static_const_table"
	strings:
		$1 = { 8B C4 81 EC D0 00 00 00 83 E4 F0 89 84 24 94 00 00 00 66 0F 28 D8 66 0F 28 D0 66 0F DB 05 ?? ?? ?? ?? 66 0F 57 F6 66 0F FE 05 ?? ?? ?? ?? BA 00 00 00 00 89 54 24 70 66 0F 73 D0 2A 66 0F 7E C0 66 0F C5 C8 04 66 0F 29 4C 24 10 66 0F C5 D3 03 F3 0F 7E 04 C5 ?? ?? ?? ?? 66 0F 16 04 CD ?? ?? ?? ?? 66 0F DB 15 ?? ?? ?? ?? 03 C0 66 0F 28 3C C5 ?? ?? ?? ?? 66 0F C5 C3 07 66 0F 29 1C 24 66 0F FB 1D ?? ?? ?? ?? 03 C9 66 0F EB 15 ?? ?? ?? ?? 66 0F 72 E3 14 66 0F DB 1D ?? ?? ?? ?? 66 0F 28 2C CD ?? ?? ?? ?? 66 0F 28 E2 66 0F 29 74 24 30 66 0F FE 1D ?? ?? ?? ?? 66 0F 59 D0 81 EA 10 00 00 80 66 0F 5C 1D ?? ?? ?? ?? 2D 10 00 00 80 81 FA DF 7F 00 80 0F 8F C0 02 00 00 3D DF 7F 00 80 0F 8F B5 02 00 00 66 0F 70 F7 0E 66 0F 14 FD 66 0F 58 DF 66 0F C6 F5 02 66 0F 28 3D ?? ?? ?? ?? 66 0F DB FC 66 0F 5C E7 66 0F 59 F8 66 0F 59 E0 66 0F 5C FA 66 0F 58 15 ?? ?? ?? ?? 66 0F 58 FC 66 0F 28 E3 66 0F 58 DA 66 0F 5C E3 66 0F 58 E2 66 0F 28 C3 66 0F 58 DF 66 0F 5C C3 66 0F 58 C7 66 0F 58 FA 66 0F 58 C4 66 0F 28 D7 66 0F 59 FF 66 0F 28 25 ?? ?? ?? ?? 66 0F 28 2D ?? ?? ?? ?? 66 0F 59 E7 66 0F 59 EF 66 0F 58 C6 66 0F 58 25 ?? ?? ?? ?? 66 0F 58 2D ?? ?? ?? ?? 66 0F 28 F3 66 0F 59 E7 66 0F 59 EF 66 0F 58 25 ?? ?? ?? ?? 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 E7 66 0F 59 EF 66 0F 28 F9 66 0F 58 25 ?? ?? ?? ?? 66 0F 59 E2 66 0F 70 D3 F1 66 0F 58 E5 66 0F 58 C4 66 0F 28 25 ?? ?? ?? ?? 66 0F 58 D8 66 0F 5C F3 66 0F 7E D0 66 0F 70 D2 FF 8B 4C 24 14 66 0F DB 3D ?? ?? ?? ?? 66 0F 58 C6 66 0F DB E3 25 00 00 F0 7F 81 E1 00 00 F0 7F 66 0F 5C DC 03 C1 3D 00 00 90 80 0F 87 D7 01 00 00 66 0F 7E D0 66 0F 59 C1 8B 4C 24 1C 25 00 00 F0 7F 81 E1 00 00 F0 7F 03 C1 3D 00 00 90 80 0F 87 B3 01 00 00 66 0F 28 EB 8B 44 24 14 25 FF FF FF 7F 8B 4C 24 10 0B C8 66 0F 5C CF 0F 84 96 01 00 00 3D 00 00 F0 7F 66 0F 59 DF 0F 83 87 01 00 00 8B 44 24 1C 25 FF FF FF 7F 8B 4C 24 18 0B C8 0F 84 72 01 00 00 3D 00 00 F0 7F 66 0F 59 E9 0F 83 63 01 00 00 66 0F 59 CC 66 0F 59 FC 66 0F 58 EB 66 0F 28 1D ?? ?? ?? ?? 66 0F 58 E9 66 0F 28 D7 66 0F 58 3D ?? ?? ?? ?? 66 0F 7E F8 66 0F C5 CF 04 66 0F C5 D7 05 C1 E2 10 66 0F 5C DF 0B CA 3D 80 FF 01 00 0F 8D 1D 01 00 00 81 F9 80 FF 01 00 0F 8D 11 01 00 00 3D 00 1E FE FF 0F 8E 06 01 00 00 81 F9 00 1E FE FF 0F 8E FA 00 00 00 83 E0 7F 83 E1 7F 03 C0 03 C9 66 0F 73 F7 2D 66 0F 28 25 ?? ?? ?? ?? 66 0F FE 3D ?? ?? ?? ?? 66 0F DB 3D ?? ?? ?? ?? 66 0F 58 DA 66 0F 58 E8 66 0F 28 05 ?? ?? ?? ?? F3 0F 7E 14 C5 ?? ?? ?? ?? 66 0F 58 EB F3 0F 7E 1C C5 ?? ?? ?? ?? 66 0F 16 14 CD ?? ?? ?? ?? 66 0F 16 1C CD ?? ?? ?? ?? 66 0F 59 C5 66 0F 28 CD 66 0F 59 E5 66 0F 59 ED 66 0F 58 05 ?? ?? ?? ?? 66 0F 58 25 ?? ?? ?? ?? 66 0F 59 C5 66 0F 59 E5 66 0F 59 C5 66 0F 59 0D ?? ?? ?? ?? 66 0F 59 C2 66 0F 59 E2 66 0F 58 C3 66 0F 59 CA 66 0F 58 C4 66 0F 58 C1 66 0F 58 C2 66 0F 59 C7 E9 97 00 00 00 66 0F 57 F6 66 0F 28 3D ?? ?? ?? ?? 66 0F C2 74 24 10 01 66 0F C2 7C 24 10 05 66 0F EF ED 66 0F DB F7 66 0F 76 2C 24 66 0F 70 FD B1 66 0F DB EE 66 0F DB EF 66 0F D7 D5 89 54 24 70 66 0F 29 6C 24 30 8B 44 24 70 A9 0F 00 00 00 75 16 F2 0F 10 04 24 F2 0F 10 4C 24 10 E8 F7 F4 FF FF F2 0F 11 44 24 20 8B 44 24 70 A9 00 0F 00 00 75 11 F2 0F 10 44 24 08 F2 0F 10 4C 24 18 E8 D5 F4 FF FF 66 0F 76 C9 66 0F EF 4C 24 30 66 0F 14 C0 66 0F 12 44 24 20 66 0F 54 C1 8B A4 24 94 00 00 00 C3 EB 03 CC CC CC }
	condition:
		$1
}

rule file_254_5_0 {
	meta:
		name = "__raise_invalid"
		size = 16
	strings:
		$1 = { 66 0F 76 D2 66 0F 72 F2 17 F3 0F 5C D2 C3 8B FF }
	condition:
		$1
}

rule file_258_0_0 {
	meta:
		name = "___avx_sin4"
		size = 2368
		refs = "0012 ___common_dsin_data 0145 ___common_dsin_cout_rare 015d ___common_dsin_data_ha 01d6 ___common_dsin_reduction_data 023e _2il0floatpacket_264 0260 _2il0floatpacket_265 026d _2il0floatpacket_266 05fb _2il0floatpacket_267 0636 _2il0floatpacket_268 0650 _2il0floatpacket_269 066f _2il0floatpacket_270 0677 _2il0floatpacket_271 06c4 _2il0floatpacket_272 06d4 _2il0floatpacket_273 072f _2il0floatpacket_277 0740 _2il0floatpacket_274 0749 _2il0floatpacket_275 0752 _2il0floatpacket_276 078c _2il0floatpacket_278 0799 _2il0floatpacket_279"
	strings:
		$1 = { 55 8B EC 83 E4 C0 57 53 81 EC B8 02 00 00 C5 FD 10 1D ?? ?? ?? ?? C5 E5 55 F0 C5 FD 54 DB C5 E5 C2 0D ?? ?? ?? ?? 1E C4 E3 7D 19 CA 01 C5 F0 C6 E2 DD C5 F8 50 C4 85 C0 0F 85 10 01 00 00 C5 FD 10 0D ?? ?? ?? ?? 33 DB C5 E5 59 3D ?? ?? ?? ?? C5 C5 58 D1 C5 ED 5C E9 C5 D9 73 F2 3F C4 E3 7D 19 D7 01 C5 D5 59 15 ?? ?? ?? ?? C5 F1 73 F7 3F C5 E5 5C DA C4 E3 5D 18 E1 01 C5 D5 59 0D ?? ?? ?? ?? C5 E5 5C D1 C5 D5 59 1D ?? ?? ?? ?? C5 D5 59 2D ?? ?? ?? ?? C5 ED 5C FB C5 C5 5C CD C5 F5 59 D1 C5 F5 57 CC C5 ED 59 25 ?? ?? ?? ?? C5 DD 58 1D ?? ?? ?? ?? C5 E5 59 E2 C5 DD 58 2D ?? ?? ?? ?? C5 D5 59 FA C5 C5 58 1D ?? ?? ?? ?? C5 E5 59 E2 C5 DD 58 2D ?? ?? ?? ?? C5 D5 59 FA C5 C5 58 1D ?? ?? ?? ?? C5 E5 59 E2 C5 DD 58 2D ?? ?? ?? ?? C5 D5 59 D2 C5 ED 59 D1 C5 ED 58 C9 C5 F5 57 CE 85 DB 75 10 C5 FD 28 C1 81 C4 B8 02 00 00 5B 5F 8B E5 5D C3 C5 FD 11 04 24 C5 FD 11 4C 24 40 74 E3 33 FF 0F A3 FB 72 0E 47 83 FF 20 7C F5 C5 FD 10 4C 24 40 EB CE C5 F8 77 8D 44 FC 40 8D 14 FC 50 52 E8 ?? ?? ?? ?? 83 C4 08 EB DC C5 FD 11 74 24 20 BF 00 00 F0 7F C5 FD 10 35 ?? ?? ?? ?? C5 FD 11 1C 24 C5 FD 11 44 24 40 C5 F9 6E D7 C5 CD 54 E3 C5 DD C2 CE 00 C5 F9 70 E2 11 C4 E3 7D 19 CF 01 C5 F0 C6 EF DD C5 F8 50 DD C5 D9 DB C3 C4 E3 7D 19 DD 01 C5 F1 73 D0 34 C5 D9 DB F5 C5 E9 73 D6 34 C5 F9 7E D0 C5 F9 7E C9 C5 F8 11 9C 24 C0 00 00 00 C5 F8 11 AC 24 D0 00 00 00 C4 E3 79 16 D7 02 8D 04 40 C4 E3 79 16 CA 02 8D 0C 49 C5 FA 7E 04 C5 ?? ?? ?? ?? C5 FA 7E 24 CD ?? ?? ?? ?? C5 FA 7E 14 CD ?? ?? ?? ?? 8D 3C 7F C5 F9 16 34 FD ?? ?? ?? ?? 8D 14 52 C5 D9 16 04 D5 ?? ?? ?? ?? C5 E9 16 24 D5 ?? ?? ?? ?? C5 FA 7E 14 C5 ?? ?? ?? ?? C5 F9 11 A4 24 00 01 00 00 C5 E9 16 24 FD ?? ?? ?? ?? C5 F9 11 A4 24 10 01 00 00 C5 FA 7E 3C CD ?? ?? ?? ?? C5 FA 6F 25 ?? ?? ?? ?? C5 FA 7E 0C C5 ?? ?? ?? ?? C5 D9 DB D3 C5 C1 16 3C D5 ?? ?? ?? ?? C5 D9 DB ED C5 FA 6F 1D ?? ?? ?? ?? B8 00 00 00 80 C5 FA 6F 25 ?? ?? ?? ?? C5 F1 16 0C FD ?? ?? ?? ?? C5 F9 11 BC 24 E0 00 00 00 C5 E9 D4 D3 C5 D1 D4 DB C5 C1 DB EC C5 C1 73 D0 20 C5 FA 7F BC 24 40 01 00 00 C5 C1 73 D1 20 C5 F1 DB CC C5 F9 DB C4 C5 FA 7F 8C 24 70 01 00 00 C5 F9 10 8C 24 00 01 00 00 C5 F1 73 D1 20 C5 FA 7F 8C 24 80 01 00 00 C5 F9 10 8C 24 10 01 00 00 C5 F1 73 D1 20 C5 FA 7F 8C 24 90 01 00 00 C5 F1 73 D2 20 C5 FA 7F 8C 24 A0 01 00 00 C5 F1 73 D3 20 C5 E1 DB DC C5 E9 DB D4 C5 F9 11 B4 24 F0 00 00 00 C5 C9 DB F4 C5 FA 7F BC 24 50 01 00 00 C5 E1 F4 FF C5 FA 7F B4 24 30 01 00 00 C5 E1 F4 F6 C5 FA 7F AC 24 20 01 00 00 C5 E9 F4 ED C5 FA 7F BC 24 00 02 00 00 C5 E9 F4 F8 C5 FA 7F B4 24 E0 01 00 00 C5 E9 F4 B4 24 40 01 00 00 C5 FA 7F 84 24 60 01 00 00 C5 FA 7F AC 24 D0 01 00 00 C5 D9 DB AC 24 00 01 00 00 C5 FA 6F 84 24 A0 01 00 00 C5 FA 7F BC 24 10 02 00 00 C5 FA 7F B4 24 F0 01 00 00 C5 F9 F4 F5 C5 C1 DB EC C5 FA 6F BC 24 80 01 00 00 C5 C9 73 D6 20 C5 FA 7F 94 24 B0 01 00 00 C5 E9 F4 D7 C5 F9 F4 C7 C5 C1 73 D2 20 C5 F9 D4 C7 C5 FA 7F 9C 24 C0 01 00 00 C5 E1 F4 9C 24 70 01 00 00 C5 D1 D4 F8 C5 C9 D4 EF C5 D9 DB B4 24 10 01 00 00 C5 FA 7F 9C 24 20 02 00 00 C5 F1 F4 D6 C5 E1 DB F4 C5 FA 6F 9C 24 90 01 00 00 C5 C1 73 D2 20 C5 F1 F4 C3 C5 E1 F4 9C 24 C0 01 00 00 C5 E9 73 D3 20 C5 F9 D4 C2 C5 C9 D4 F0 C5 FA 6F 84 24 A0 01 00 00 C5 C1 D4 D6 C5 F9 F4 B4 24 60 01 00 00 C5 FA 6F 9C 24 10 02 00 00 C5 E1 73 D3 20 C5 C9 D4 F3 C5 D9 DB BC 24 F0 01 00 00 C5 C1 D4 FE C5 F1 F4 B4 24 70 01 00 00 C5 FA 6F 9C 24 20 02 00 00 C5 E1 73 D3 20 C5 FA 7F AC 24 30 02 00 00 C5 D1 73 D5 20 C5 C9 D4 F3 C5 D1 D4 FF C5 D9 DB AC 24 00 02 00 00 C5 E1 73 D7 20 C5 D1 D4 EE C5 F9 F4 B4 24 40 01 00 00 C5 FA 7F 94 24 40 02 00 00 C5 E9 73 D2 20 C5 E9 D4 ED C5 FA 6F 94 24 F0 01 00 00 C5 E9 73 D2 20 C5 C9 D4 F2 C5 F1 F4 94 24 50 01 00 00 C5 FA 7F BC 24 50 02 00 00 C5 D9 DB BC 24 D0 01 00 00 C5 C1 D4 FE C5 E1 D4 F7 C5 FA 6F 9C 24 00 02 00 00 C5 E1 73 D3 20 C5 E9 D4 D3 C5 D9 DB BC 24 E0 01 00 00 C5 E1 73 D6 20 C5 C1 D4 FA C5 FA 7F AC 24 60 02 00 00 C5 D1 73 D5 20 C5 D1 D4 D7 C5 F9 10 AC 24 E0 00 00 00 C5 C9 DB F4 C5 C1 73 D5 20 C5 C1 F4 AC 24 B0 01 00 00 C5 F9 F4 BC 24 20 01 00 00 C5 FA 6F 84 24 D0 01 00 00 C5 D1 DB EC C5 F9 73 D0 20 C5 C1 D4 F8 C5 D1 D4 EF C5 E1 D4 DD C5 C1 73 F3 20 C5 D1 73 D2 20 C5 C1 D4 DE C5 F9 10 B4 24 F0 00 00 00 C5 E9 DB D4 C5 C1 73 D6 20 C5 C1 F4 84 24 C0 01 00 00 C5 F1 F4 B4 24 30 01 00 00 C5 FA 6F 8C 24 E0 01 00 00 C5 F9 DB FC C5 F1 73 D1 20 C5 C9 D4 C1 C5 C1 D4 F8 C5 D1 D4 EF C5 C9 73 F5 20 C5 C9 D4 CA C5 FA 6F B4 24 50 02 00 00 C5 FA 6F 94 24 60 02 00 00 C5 C1 73 F6 20 C5 F9 6E F0 C5 F9 73 F2 20 C5 D9 DB AC 24 30 02 00 00 C5 D9 DB A4 24 40 02 00 00 C5 F9 70 D6 11 C5 E9 DB B4 24 D0 00 00 00 C5 C1 D4 ED C5 F9 D4 FC C5 E9 DB A4 24 C0 00 00 00 C5 FA 6F 15 ?? ?? ?? ?? C5 FA 7F 9C 24 70 02 00 00 C5 E1 73 D3 0C C5 D9 EF C2 C5 C9 EF D2 C5 FA 7F 8C 24 80 02 00 00 C5 F1 73 D1 0C C5 E1 EB D8 C5 F1 EB CA C4 E3 65 18 D1 01 C4 E2 7D 1A 1D ?? ?? ?? ?? C5 E5 58 CA C5 F5 5C C3 C5 ED 5C D8 C5 FD 11 5C 24 60 C5 F8 10 1D ?? ?? ?? ?? C5 F1 DB D3 C4 E3 7D 19 C8 01 C5 FA 7F 94 24 90 02 00 00 C5 F8 54 CB C5 FA 6F 15 ?? ?? ?? ?? C5 FA 6F 05 ?? ?? ?? ?? C5 D9 EF DA C5 F8 11 8C 24 A0 02 00 00 C5 C9 EF CA C5 F9 DB D5 C5 F9 DB C7 C5 E9 73 F2 1C C5 F9 73 F0 1C C5 E9 EB D3 C5 F9 EB C1 C5 D1 73 D5 18 C5 C1 73 D7 18 C4 E3 6D 18 D0 01 C4 E3 65 18 C9 01 C5 ED 5C D1 C5 FA 6F 0D ?? ?? ?? ?? C5 D9 EF D9 C5 C9 EF C9 C5 FA 6F 35 ?? ?? ?? ?? C5 C9 DB A4 24 70 02 00 00 C5 C9 DB B4 24 80 02 00 00 C5 F9 73 F4 28 C5 F9 EB ED C5 F9 73 F6 28 C5 F9 EB F7 C5 D1 EB E3 C5 C9 EB F9 C4 E3 5D 18 EF 01 C5 FD 10 64 24 60 C4 E3 65 18 C9 01 C5 D5 5C F1 C5 DD 58 C6 C5 DD 5C C8 C5 CD 58 F9 C5 C5 58 F2 C4 E2 7D 1A 15 ?? ?? ?? ?? C5 FD 54 FA C5 FD 5C C7 C4 E2 7D 1A 2D ?? ?? ?? ?? C4 E2 7D 1A 1D ?? ?? ?? ?? C4 E2 7D 1A 25 ?? ?? ?? ?? C5 E5 59 D7 C5 E5 59 C8 C5 DD 59 DF C5 D5 59 EE C5 DD 59 C0 C5 F5 58 F3 C5 D5 58 C8 C5 CD 58 D9 C5 ED 58 EB C5 ED 5C FD C5 C5 58 C3 C5 FD 10 1C 24 C4 E2 7D 1A 15 ?? ?? ?? ?? C5 E5 54 E2 C4 E2 7D 1A 0D ?? ?? ?? ?? C5 DD C2 F1 1E C5 DD C2 F9 12 C5 CD 54 ED C5 CD 54 C0 C5 FA 6F B4 24 90 02 00 00 C5 C5 54 D3 C5 F8 10 9C 24 A0 02 00 00 C5 F9 7E F2 C5 F9 7E D8 C5 FD 11 84 24 80 00 00 00 C1 E2 05 C4 E3 79 16 F1 02 C4 E3 79 16 DF 02 C5 ED 56 ED C1 E0 05 C1 E1 05 C1 E7 05 C5 FA 7E 8A ?? ?? ?? ?? C5 FA 7E 90 ?? ?? ?? ?? C5 F1 16 B9 ?? ?? ?? ?? C5 FA 7E A2 ?? ?? ?? ?? C5 E9 16 87 ?? ?? ?? ?? C5 FA 7E 88 ?? ?? ?? ?? C5 D9 16 B1 ?? ?? ?? ?? C5 FA 7E 9A ?? ?? ?? ?? C5 E1 16 91 ?? ?? ?? ?? C4 E3 45 18 C0 01 C5 F1 16 BF ?? ?? ?? ?? C4 E3 4D 18 E7 01 C5 FA 7E B0 ?? ?? ?? ?? C5 C9 16 8F ?? ?? ?? ?? C5 FD 59 FD C4 E3 6D 18 D9 01 C5 D5 59 CC C5 FC 11 9C 24 A0 00 00 00 C5 E5 58 D1 C5 C5 58 F2 C5 E5 5C DA C5 E5 58 D9 C5 ED 5C CE C5 D5 59 D5 C5 F5 58 FF C5 C5 58 CB C5 ED 59 3D ?? ?? ?? ?? C5 C5 58 1D ?? ?? ?? ?? C5 E5 59 FA C5 C5 59 DD C5 FD 58 FC C5 ED 59 25 ?? ?? ?? ?? C5 E5 59 C7 C5 FD 58 D9 C5 DD 58 0D ?? ?? ?? ?? C5 F5 59 C2 C5 FD 58 25 ?? ?? ?? ?? C5 FC 10 84 24 A0 00 00 00 C5 DD 59 D2 C5 D5 59 E8 C5 ED 59 C8 C5 FA 7E 82 ?? ?? ?? ?? C5 F9 16 91 ?? ?? ?? ?? C5 C5 5C FD C5 F5 58 CB C5 FA 7E 98 ?? ?? ?? ?? C5 E1 16 A7 ?? ?? ?? ?? C5 C5 59 BC 24 80 00 00 00 C4 E3 6D 18 EC 01 C5 C5 58 C5 C5 F5 58 C8 C5 FD 10 44 24 40 C5 CD 58 F1 C5 CD 57 4C 24 20 E9 C4 F7 FF FF 8B FF }
	condition:
		$1
}

rule file_259_0_0 {
	meta:
		name = "___avx_cos4"
		size = 2352
		refs = "0012 ___common_dcos_data 0149 ___common_dcos_cout_rare 0156 ___common_dcos_data_ha 01d2 ___common_dcos_reduction_data 025a _2il0floatpacket_267 0262 _2il0floatpacket_268 0272 _2il0floatpacket_269 05ee _2il0floatpacket_270 0632 _2il0floatpacket_271 0646 _2il0floatpacket_272 0662 _2il0floatpacket_274 0680 _2il0floatpacket_273 06c0 _2il0floatpacket_275 06d0 _2il0floatpacket_276 072b _2il0floatpacket_280 073c _2il0floatpacket_277 0745 _2il0floatpacket_278 074e _2il0floatpacket_279 0788 _2il0floatpacket_281 0795 _2il0floatpacket_282"
	strings:
		$1 = { 55 8B EC 83 E4 C0 57 53 81 EC 78 02 00 00 C5 FD 58 2D ?? ?? ?? ?? C5 D5 54 35 ?? ?? ?? ?? C5 CD C2 0D ?? ?? ?? ?? 1E C4 E3 7D 19 CB 01 C5 F0 C6 E3 DD C5 F8 50 C4 85 C0 0F 85 14 01 00 00 C5 FD 10 3D ?? ?? ?? ?? 33 DB C5 D5 59 35 ?? ?? ?? ?? C5 CD 58 DF C5 E5 5C E7 C5 DD 5C 2D ?? ?? ?? ?? C5 D5 59 0D ?? ?? ?? ?? C5 D9 73 F3 3F C4 E3 7D 19 DB 01 C5 E1 73 F3 3F C4 E3 5D 18 E3 01 C5 D5 59 1D ?? ?? ?? ?? C5 FD 5C DB C5 E5 5C D9 C5 D5 59 0D ?? ?? ?? ?? C5 E5 5C D9 C5 D5 59 0D ?? ?? ?? ?? C5 E5 5C D9 C5 E5 59 CB C5 F5 59 2D ?? ?? ?? ?? C5 D5 58 2D ?? ?? ?? ?? C5 D5 59 E9 C5 D5 58 2D ?? ?? ?? ?? C5 D5 59 E9 C5 D5 58 2D ?? ?? ?? ?? C5 D5 59 E9 C5 D5 58 2D ?? ?? ?? ?? C5 D5 59 E9 C5 D5 58 2D ?? ?? ?? ?? C5 D5 59 E9 C5 D5 58 2D ?? ?? ?? ?? C5 D5 59 C9 C5 F5 59 CB C5 F5 58 CB C5 F5 57 CC 85 DB 75 10 C5 FD 28 C1 81 C4 78 02 00 00 5B 5F 8B E5 5D C3 C5 FD 11 04 24 C5 FD 11 4C 24 40 74 E3 33 FF 0F A3 FB 72 0E 47 83 FF 20 7C F5 C5 FD 10 4C 24 40 EB CE C5 F8 77 8D 44 FC 40 8D 14 FC 50 52 E8 ?? ?? ?? ?? 83 C4 08 EB DC C5 FD 10 25 ?? ?? ?? ?? BF 00 00 F0 7F C5 FD 11 04 24 C5 F9 6E FF C5 DD 54 CE C5 F5 C2 CC 00 C4 E3 7D 19 C5 01 C5 F8 11 AC 24 90 00 00 00 C4 E3 7D 19 CE 01 C5 F0 C6 DE DD C5 F9 70 CF 11 C5 F8 50 DB C5 F8 28 D0 C5 F1 DB E2 C5 C9 73 D4 34 C5 F1 DB CD C5 F9 7E F1 C5 E1 73 D1 34 C5 F9 7E D8 C5 F8 11 94 24 80 00 00 00 C4 E3 79 16 F2 02 8D 0C 49 C4 E3 79 16 DF 02 8D 04 40 C5 FA 7E 0C CD ?? ?? ?? ?? C5 FA 7E 24 C5 ?? ?? ?? ?? C5 FA 7E 1C CD ?? ?? ?? ?? 8D 14 52 C5 F1 16 3C D5 ?? ?? ?? ?? 8D 3C 7F C5 FA 7E 0C C5 ?? ?? ?? ?? C5 F1 16 34 FD ?? ?? ?? ?? C5 FA 7E 0C CD ?? ?? ?? ?? C5 F1 16 04 D5 ?? ?? ?? ?? C5 D9 16 0C FD ?? ?? ?? ?? C5 E1 16 24 D5 ?? ?? ?? ?? C5 FA 7E 1C C5 ?? ?? ?? ?? B8 00 00 00 80 C5 F9 11 A4 24 C0 00 00 00 C5 E1 16 24 FD ?? ?? ?? ?? C5 F9 11 A4 24 D0 00 00 00 C5 FA 6F 25 ?? ?? ?? ?? C5 FA 6F 1D ?? ?? ?? ?? C5 D9 DB D2 C5 D9 DB ED C5 FA 6F 25 ?? ?? ?? ?? C5 F9 11 BC 24 A0 00 00 00 C5 E9 D4 D3 C5 D1 D4 DB C5 C1 DB EC C5 C1 73 D0 20 C5 FA 7F BC 24 00 01 00 00 C5 C1 73 D1 20 C5 F1 DB CC C5 F9 DB C4 C5 FA 7F 8C 24 30 01 00 00 C5 F9 10 8C 24 C0 00 00 00 C5 F1 73 D1 20 C5 FA 7F 8C 24 40 01 00 00 C5 F9 10 8C 24 D0 00 00 00 C5 F1 73 D1 20 C5 FA 7F 8C 24 50 01 00 00 C5 F1 73 D2 20 C5 F9 11 B4 24 B0 00 00 00 C5 C9 DB F4 C5 FA 7F 8C 24 60 01 00 00 C5 F1 73 D3 20 C5 E1 DB DC C5 E9 DB D4 C5 FA 7F B4 24 F0 00 00 00 C5 E1 F4 F6 C5 FA 7F B4 24 A0 01 00 00 C5 E9 F4 B4 24 00 01 00 00 C5 FA 7F AC 24 E0 00 00 00 C5 E9 F4 ED C5 FA 7F BC 24 10 01 00 00 C5 E1 F4 FF C5 FA 7F 84 24 20 01 00 00 C5 FA 7F B4 24 B0 01 00 00 C5 FA 7F AC 24 90 01 00 00 C5 E9 F4 E8 C5 D9 DB B4 24 C0 00 00 00 C5 FA 6F 84 24 60 01 00 00 C5 FA 7F BC 24 C0 01 00 00 C5 F9 F4 FE C5 C9 73 D7 20 C5 FA 6F BC 24 40 01 00 00 C5 FA 7F 94 24 70 01 00 00 C5 E9 F4 D7 C5 F9 F4 C7 C5 C1 73 D2 20 C5 F9 D4 C7 C5 FA 7F AC 24 D0 01 00 00 C5 D1 DB EC C5 D1 D4 E8 C5 FA 7F 9C 24 80 01 00 00 C5 E1 F4 9C 24 30 01 00 00 C5 C9 D4 FD C5 D9 DB B4 24 D0 00 00 00 C5 F1 F4 C6 C5 E1 DB F4 C5 FA 7F 9C 24 E0 01 00 00 C5 D1 73 D0 20 C5 FA 6F 9C 24 50 01 00 00 C5 F1 F4 C3 C5 E1 F4 9C 24 80 01 00 00 C5 E9 73 D3 20 C5 F9 D4 DA C5 C9 D4 F3 C5 FA 6F 84 24 60 01 00 00 C5 D1 D4 D6 C5 F9 F4 B4 24 20 01 00 00 C5 FA 7F BC 24 F0 01 00 00 C5 D1 73 D7 20 C5 FA 6F BC 24 D0 01 00 00 C5 C1 73 D7 20 C5 C9 D4 F7 C5 D9 DB 9C 24 B0 01 00 00 C5 E1 D4 DE C5 F1 F4 B4 24 30 01 00 00 C5 D1 D4 FB C5 FA 6F 9C 24 E0 01 00 00 C5 E1 73 D3 20 C5 C9 D4 F3 C5 D9 DB AC 24 C0 01 00 00 C5 D1 D4 EE C5 F9 F4 B4 24 00 01 00 00 C5 FA 7F 94 24 00 02 00 00 C5 E9 73 D2 20 C5 E9 D4 ED C5 FA 6F 94 24 B0 01 00 00 C5 E9 73 D2 20 C5 C9 D4 F2 C5 F1 F4 94 24 10 01 00 00 C5 D9 DB 9C 24 90 01 00 00 C5 E1 D4 DE C5 FA 7F BC 24 10 02 00 00 C5 C1 73 D7 20 C5 C1 D4 F3 C5 FA 6F BC 24 C0 01 00 00 C5 C1 73 D7 20 C5 E9 D4 D7 C5 D9 DB 9C 24 A0 01 00 00 C5 C1 73 D6 20 C5 E1 D4 DA C5 FA 7F AC 24 20 02 00 00 C5 D1 73 D5 20 C5 D1 D4 D3 C5 F9 10 AC 24 A0 00 00 00 C5 C9 DB F4 C5 E1 73 D5 20 C5 E1 F4 AC 24 70 01 00 00 C5 F9 F4 9C 24 E0 00 00 00 C5 FA 6F 84 24 90 01 00 00 C5 D1 DB EC C5 F9 73 D0 20 C5 E1 D4 D8 C5 D1 D4 EB C5 C1 D4 FD C5 E1 73 F7 20 C5 C1 73 D2 20 C5 E1 D4 DE C5 F9 10 B4 24 B0 00 00 00 C5 E9 DB D4 C5 D1 73 D6 20 C5 D1 F4 84 24 80 01 00 00 C5 F1 F4 AC 24 F0 00 00 00 C5 FA 6F 8C 24 A0 01 00 00 C5 F9 DB F4 C5 F1 73 D1 20 C5 D1 D4 C1 C5 C9 D4 F0 C5 C1 D4 FE C5 FA 6F B4 24 10 02 00 00 C5 F1 73 F7 20 C5 FA 6F 84 24 20 02 00 00 C5 D1 73 F6 20 C5 F9 6E F0 C5 D9 DB BC 24 F0 01 00 00 C5 D9 DB A4 24 00 02 00 00 C5 F1 D4 CA C5 D1 D4 EF C5 E9 73 F0 20 C5 F9 70 C6 11 C5 E9 D4 FC C5 F9 DB A4 24 80 00 00 00 C5 FA 6F 15 ?? ?? ?? ?? C5 FA 7F 9C 24 30 02 00 00 C5 E1 73 D3 0C C5 F9 DB B4 24 90 00 00 00 C5 D9 EF C2 C5 FA 7F 8C 24 40 02 00 00 C5 E1 EB D8 C5 F1 73 D1 0C C5 C9 EF C2 C5 F1 EB C8 C4 E3 65 18 D9 01 C4 E2 7D 1A 15 ?? ?? ?? ?? C5 ED 58 CB C5 F5 5C C2 C5 E5 5C D0 C5 F8 10 05 ?? ?? ?? ?? C5 FD 11 54 24 20 C4 E3 7D 19 CB 01 C5 F1 DB C8 C5 E0 54 D0 C5 FA 6F 05 ?? ?? ?? ?? C5 FA 7F 8C 24 50 02 00 00 C5 F8 11 94 24 60 02 00 00 C5 F9 DB D5 C5 FA 6F 0D ?? ?? ?? ?? C5 F9 DB C7 C5 D9 EF D9 C5 E9 73 F2 1C C5 C9 EF C9 C5 F9 73 F0 1C C5 E9 EB D3 C5 F9 EB C1 C5 D1 73 D5 18 C5 C1 73 D7 18 C4 E3 6D 18 C0 01 C4 E3 65 18 C9 01 C5 FD 5C D1 C5 FA 6F 0D ?? ?? ?? ?? C5 D9 EF D9 C5 C9 EF C9 C5 FA 6F 25 ?? ?? ?? ?? C5 D9 DB B4 24 30 02 00 00 C5 C9 73 F6 28 C5 D9 DB A4 24 40 02 00 00 C5 C9 EB F5 C5 C9 EB EB C5 C9 73 F4 28 C5 C9 EB F7 C5 C9 EB F9 C5 FD 10 64 24 20 C4 E3 55 18 EF 01 C4 E3 65 18 C9 01 C5 D5 5C C9 C5 DD 58 C1 C5 DD 5C F0 C5 F5 58 DE C5 E5 58 F2 C4 E2 7D 1A 15 ?? ?? ?? ?? C5 FD 54 FA C5 FD 5C C7 C4 E2 7D 1A 2D ?? ?? ?? ?? C4 E2 7D 1A 0D ?? ?? ?? ?? C4 E2 7D 1A 25 ?? ?? ?? ?? C5 F5 59 D7 C5 F5 59 D8 C5 DD 59 CF C5 D5 59 EE C5 DD 59 C0 C5 E5 58 C9 C5 D5 58 F0 C5 F5 58 EE C5 ED 58 FD C5 ED 5C DF C5 E5 58 F5 C5 FD 10 2C 24 C4 E2 7D 1A 05 ?? ?? ?? ?? C5 D5 54 E0 C4 E2 7D 1A 15 ?? ?? ?? ?? C5 DD C2 CA 1E C5 DD C2 DA 12 C5 F5 54 FF C5 F5 54 CE C5 FD 11 4C 24 40 C5 FA 6F B4 24 50 02 00 00 C5 F8 10 8C 24 60 02 00 00 C5 F9 7E F2 C5 F9 7E C8 C1 E2 05 C4 E3 79 16 F1 02 C4 E3 79 16 CF 02 C5 E5 54 C5 C1 E0 05 C1 E1 05 C1 E7 05 C5 FA 7E A2 ?? ?? ?? ?? C5 FA 7E B0 ?? ?? ?? ?? C5 D9 16 91 ?? ?? ?? ?? C5 C9 16 9F ?? ?? ?? ?? C5 FA 7E AA ?? ?? ?? ?? C5 FA 7E A0 ?? ?? ?? ?? C5 FD 56 FF C5 D1 16 81 ?? ?? ?? ?? C5 D9 16 8F ?? ?? ?? ?? C5 FA 7E A0 ?? ?? ?? ?? C4 E3 6D 18 F3 01 C5 FA 7E 9A ?? ?? ?? ?? C5 E1 16 A9 ?? ?? ?? ?? C4 E3 7D 18 D1 01 C5 D9 16 8F ?? ?? ?? ?? C5 CD 59 E7 C5 FC 11 54 24 60 C4 E3 55 18 E9 01 C5 C5 59 DD C5 CD 58 ED C5 ED 58 C3 C5 DD 58 C8 C5 ED 5C D0 C5 ED 58 D3 C5 FD 5C D9 C5 E5 58 C4 C5 FD 58 E2 C5 C5 59 C7 C5 FD 59 15 ?? ?? ?? ?? C5 ED 58 1D ?? ?? ?? ?? C5 E5 59 D0 C5 ED 59 DF C5 E5 59 F5 C5 CD 58 DC C5 FD 59 35 ?? ?? ?? ?? C5 CD 58 15 ?? ?? ?? ?? C5 ED 59 E0 C5 FC 10 54 24 60 C5 DD 58 35 ?? ?? ?? ?? C5 FA 7E A0 ?? ?? ?? ?? C5 C5 59 FA C5 CD 59 C0 C5 FD 59 F2 C5 FA 7E 82 ?? ?? ?? ?? C5 F9 16 91 ?? ?? ?? ?? C5 CD 58 F3 C5 D5 5C DF C5 D9 16 AF ?? ?? ?? ?? C5 E5 59 5C 24 40 C4 E3 6D 18 FD 01 C5 E5 58 C7 C5 CD 58 F0 C5 FD 10 04 24 C5 F5 58 CE E9 DF F7 FF FF 8D A4 24 00 00 00 00 8B FF }
	condition:
		$1
}

rule file_260_1_0 {
	meta:
		name = "?DebuggerProbe@@YAHK@Z"
		size = 153
		refs = "0006 __sehtable$?DebuggerProbe@@YAHK@Z 000b __except_handler4 001d ___security_cookie 0060 __imp__RaiseException@16"
	strings:
		$1 = { 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 24 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 89 65 E8 C6 45 E7 00 C7 45 CC 01 10 00 00 8B 45 08 89 45 D0 8D 45 E7 89 45 D4 C7 45 FC 00 00 00 00 8D 45 CC 50 6A 06 6A 00 68 88 13 6D 40 FF 15 ?? ?? ?? ?? EB 16 8B 45 EC 8B 00 33 C9 81 38 88 13 6D 40 0F 94 C1 8B C1 C3 8B 65 E8 C7 45 FC FE FF FF FF 0F B6 45 E7 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_260_2_0 {
	meta:
		name = "?DebuggerRuntime@@YAHKHPAXPB_W@Z"
		size = 171
		refs = "0006 __sehtable$?DebuggerRuntime@@YAHKHPAXPB_W@Z 000b __except_handler4 001d ___security_cookie 0072 __imp__RaiseException@16"
	strings:
		$1 = { 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 24 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 89 65 E8 C6 45 E7 00 C7 45 CC 02 10 00 00 8B 45 08 89 45 D0 8B 45 0C 89 45 D4 8B 45 10 89 45 D8 8D 45 E7 89 45 DC 8B 45 14 89 45 E0 C7 45 FC 00 00 00 00 8D 45 CC 50 6A 06 6A 00 68 88 13 6D 40 FF 15 ?? ?? ?? ?? EB 16 8B 45 EC 8B 00 33 C9 81 38 88 13 6D 40 0F 94 C1 8B C1 C3 8B 65 E8 C7 45 FC FE FF FF FF 0F B6 45 E7 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_260_3_0 {
	meta:
		name = "?_RTC_AllocaFailure@@YAXPAXPAU_RTC_ALLOCA_NODE@@H@Z"
		size = 287
		refs = "000a ___security_cookie 001d ?_RTC_ErrorLevels@@3PAHA 0035 ??_C@_0EJ@LJKNEOLN@Stack?5area?5around?5_alloca?5memory@ 003e ?failwithmessage@@YAXPAXHHPBD@Z 004d @__security_check_cookie@4 005a ??_C@_08OMAHNMHJ@?6Data?3?5?$DM?$AA@ 0068 ??_C@_0CK@DKGBICFE@?6Allocation?5number?5within?5this?5f@ 006e ??_C@_07DFDJCKFN@?6Size?3?5?$AA@ 0074 ??_C@_0N@MHFFIMFG@?6Address?3?50x?$AA@ 0079 ??_C@_0EI@CLEPFNGI@Stack?5area?5around?5_alloca?5memory@ 007e ??_C@_0BC@HHMKLAND@?$CFs?$CFs?$CFp?$CFs?$CFzd?$CFs?$CFd?$CFs?$AA@ 008f _sprintf_s 00a4 ?_getMemBlockDataString@@YAXPAD00I@Z 00af ??_C@_01EEMJAFIK@?6?$AA@ 00b5 ??_C@_02LLMPMKNF@?$DO?5?$AA@ 00c4 ??_C@_08KJEDNCKC@?$CFs?$CFs?$CFs?$CFs?$AA@ 00ca ?_strlen_priv@@YAIPBD@Z"
	strings:
		$1 = { 55 8B EC 81 EC 44 01 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 53 8B 5D 0C 57 8B 3D ?? ?? ?? ?? 89 85 BC FE FF FF 83 FF FF 0F 84 DF 00 00 00 85 DB 75 21 68 ?? ?? ?? ?? 6A 04 57 50 E8 ?? ?? ?? ?? 83 C4 10 5F 5B 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 8B 43 0C 56 68 ?? ?? ?? ?? FF 75 10 83 E8 24 8D 73 20 68 ?? ?? ?? ?? 50 68 ?? ?? ?? ?? 56 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 85 C0 FE FF FF 68 F4 00 00 00 50 E8 ?? ?? ?? ?? 8B 43 0C 83 E8 24 50 56 8D 45 B4 50 8D 45 E8 50 E8 ?? ?? ?? ?? 83 C4 3C 8D 45 B4 68 ?? ?? ?? ?? 50 68 ?? ?? ?? ?? 8D 45 E8 50 8D 85 C0 FE FF FF 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 B9 F4 00 00 00 2B C8 8D 85 C0 FE FF FF 51 50 E8 ?? ?? ?? ?? 83 C4 04 8D 8D C0 FE FF FF 03 C1 50 E8 ?? ?? ?? ?? 8D 85 C0 FE FF FF 50 6A 04 57 FF B5 BC FE FF FF E8 ?? ?? ?? ?? 83 C4 2C 5E 8B 4D FC 5F 33 CD 5B E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_260_4_0 {
	meta:
		name = "?_RTC_Failure@@YAXPAXH@Z"
		size = 78
		refs = "000e ?_RTC_ErrorLevels@@3PAHA 0015 ?_RTC_ErrorMessages@@3QBQBDB 0025 ?failwithmessage@@YAXPAXHHPBD@Z"
	strings:
		$1 = { 55 8B EC 8B 45 0C 83 F8 04 77 23 8B 0C 85 ?? ?? ?? ?? 8B 14 85 ?? ?? ?? ?? 83 F9 FF 74 2E 52 50 51 FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 8B 15 ?? ?? ?? ?? B8 05 00 00 00 52 50 B9 01 00 00 00 51 FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_260_5_0 {
	meta:
		name = "?_RTC_StackFailure@@YAXPAXPBD@Z"
		size = 256
		refs = "000a ___security_cookie 001d ?_RTC_ErrorLevels@@3PAHA 003f ?_strlen_priv@@YAIPBD@Z 0062 ?stack_premsg@@3QBDB 0093 ?stack_postmsg@@3QBDB 00d6 ??_C@_0CG@IAFNJNEE@Stack?5corrupted?5near?5unknown?5var@ 00ea ?failwithmessage@@YAXPAXHHPBD@Z 00f8 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 81 EC 0C 04 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 89 85 F4 FB FF FF A1 ?? ?? ?? ?? 89 85 F8 FB FF FF 53 8B 5D 0C 83 F8 FF 0F 84 BD 00 00 00 80 3B 00 0F 84 98 00 00 00 53 E8 ?? ?? ?? ?? 83 C0 2D 83 C4 04 3D 00 04 00 00 0F 87 81 00 00 00 33 C0 EB 08 8D A4 24 00 00 00 00 90 8A 88 ?? ?? ?? ?? 8D 40 01 88 8C 05 FB FB FF FF 84 C9 75 EC 56 57 8B F3 8A 03 43 84 C0 75 F9 8D BD FC FB FF FF 2B DE 4F 8A 47 01 47 84 C0 75 F8 8B CB BA ?? ?? ?? ?? C1 E9 02 F3 A5 8B CB 83 E1 03 F3 A4 8B F2 8A 02 42 84 C0 75 F9 8D BD FC FB FF FF 2B D6 4F 8A 47 01 47 84 C0 75 F8 8B CA 8D 85 FC FB FF FF C1 E9 02 F3 A5 8B CA 83 E1 03 F3 A4 5F 5E EB 05 B8 ?? ?? ?? ?? 50 6A 02 FF B5 F8 FB FF FF FF B5 F4 FB FF FF E8 ?? ?? ?? ?? 83 C4 10 8B 4D FC 33 CD 5B E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_260_6_0 {
	meta:
		name = "?_getMemBlockDataString@@YAXPAD00I@Z"
		size = 118
		refs = "003b ??_C@_05MKKEDADM@?$CF?42X?5?$AA@ 0042 _sprintf_s"
	strings:
		$1 = { 55 8B EC 8B 4D 0C 83 EC 08 53 8B 5D 10 56 33 F6 57 8B 7D 08 2B DF 89 5D 10 8D 56 31 8B 45 14 89 55 FC 89 4D F8 83 F8 10 72 05 B8 10 00 00 00 3B F0 73 2B 8A 1C 3B 0F B6 C3 50 68 ?? ?? ?? ?? 52 51 E8 ?? ?? ?? ?? 8B 55 FC 83 C4 10 8B 4D F8 46 88 1F 83 EA 03 8B 5D 10 83 C1 03 47 EB BE 8B 45 08 5F C6 04 06 00 8B 45 0C 8D 04 70 C6 04 06 00 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_260_7_0 {
	meta:
		name = "?_strlen_priv@@YAIPBD@Z"
		size = 20
	strings:
		$1 = { 55 8B EC 8B 55 08 8B C2 8A 08 40 84 C9 75 F9 2B C2 48 5D C3 }
	condition:
		$1
}

rule file_260_8_0 {
	meta:
		name = "?failwithmessage@@YAXPAXHHPBD@Z"
		size = 510
		refs = "000a ___security_cookie 0037 ?_RTC_GetErrorFuncW@@YAP6AHHPB_WH00ZZPBX@Z 0046 ?_RTC_GetErrorFunc@@YAP6AHHPBDH00ZZPBX@Z 0063 __imp__MultiByteToWideChar@24 0091 ??_C@_1GM@OLMCBDMB@?$AAR?$AAu?$AAn?$AAt?$AAi?$AAm?$AAe?$AA?5?$AAC?$AAh?$AAe?$AAc?$AAk?$AA?5?$AAE?$AAr?$AAr?$AAo?$AAr?$AA?4?$AA?6?$AA?$AN?$AA?5?$AAU?$AAn?$AAa?$AAb?$AAl?$AAe?$AA?5?$AAt?$AAo@ 009b ?DebuggerProbe@@YAHK@Z 00b1 ?_RTC_NoFalsePositives@@3QBHB 00b7 ?DebuggerRuntime@@YAHKHPAXPB_W@Z 00e3 __imp__IsDebuggerPresent@0 0113 ?_RTC_GetSrcLine@@YAHPAEPA_WKPAH1K@Z 012e ??_C@_1EA@NFKNIFJP@?$AAR?$AAu?$AAn?$AA?9?$AAT?$AAi?$AAm?$AAe?$AA?5?$AAC?$AAh?$AAe?$AAc?$AAk?$AA?5?$AAF?$AAa?$AAi?$AAl?$AAu?$AAr?$AAe?$AA?5?$AA?$CD?$AA?$CF?$AAd?$AA?5?$AA?9?$AA?5?$AA?$CF?$AAs?$AA?$AA@ 0144 @_guard_check_icall@4 015f ??_C@_0BB@PFFGGCJP@Unknown?5Filename?$AA@ 0176 __imp__WideCharToMultiByte@32 0194 ??_C@_0BE@GNBOBNCK@Unknown?5Module?5Name?$AA@ 01ce ??_C@_0CA@IODNCDPG@Run?9Time?5Check?5Failure?5?$CD?$CFd?5?9?5?$CFs?$AA@ 01f6 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 81 EC 3C 0E 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 10 53 8B 5D 14 56 8B 75 08 57 56 89 85 D0 F1 FF FF 89 9D C4 F1 FF FF C7 85 CC F1 FF FF 00 00 00 00 E8 ?? ?? ?? ?? 8B F8 83 C4 04 85 FF 75 0F 56 E8 ?? ?? ?? ?? 83 C4 04 89 85 CC F1 FF FF 6A 00 6A 00 6A FF 53 6A 00 68 E9 FD 00 00 FF 15 ?? ?? ?? ?? 3D 00 02 00 00 73 22 50 8D 85 D4 F1 FF FF 50 6A FF 53 6A 00 68 E9 FD 00 00 FF 15 ?? ?? ?? ?? 8D 9D D4 F1 FF FF 85 C0 75 05 BB ?? ?? ?? ?? 68 02 10 00 00 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 24 8B 85 D0 F1 FF FF 53 56 FF 34 85 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 10 85 C0 0F 85 27 01 00 00 32 C0 EB 02 B0 01 83 BD CC F1 FF FF 00 75 08 85 FF 0F 84 0F 01 00 00 84 C0 74 0E FF 15 ?? ?? ?? ?? 85 C0 0F 85 FD 00 00 00 68 04 01 00 00 8D 85 EC FB FF FF 50 8D 85 C8 F1 FF FF 50 68 04 01 00 00 8D 85 F4 FD FF FF 50 8D 46 FB 50 E8 ?? ?? ?? ?? 83 C4 18 85 FF 74 31 53 FF B5 D0 F1 FF FF 8D 85 EC FB FF FF 8B CF 68 ?? ?? ?? ?? 50 FF B5 C8 F1 FF FF 8D 85 F4 FD FF FF 50 FF 75 0C E8 ?? ?? ?? ?? FF D7 E9 95 00 00 00 6A 00 6A 00 68 0A 03 00 00 8D 85 E0 F8 FF FF BE ?? ?? ?? ?? 50 6A FF 8D 85 F4 FD FF FF 50 6A 00 68 E9 FD 00 00 FF 15 ?? ?? ?? ?? 85 C0 74 06 8D B5 E0 F8 FF FF 6A 00 6A 00 68 0A 03 00 00 8D 85 D4 F5 FF FF BF ?? ?? ?? ?? 50 6A FF 8D 85 EC FB FF FF 50 6A 00 68 E9 FD 00 00 FF 15 ?? ?? ?? ?? 85 C0 74 06 8D BD D4 F5 FF FF FF B5 C4 F1 FF FF 8B 9D CC F1 FF FF 8B CB FF B5 D0 F1 FF FF 68 ?? ?? ?? ?? 57 FF B5 C8 F1 FF FF 56 FF 75 0C E8 ?? ?? ?? ?? FF D3 83 C4 1C 83 F8 01 75 01 CC 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_260_9_0 {
	meta:
		name = "__RTC_UninitUse"
		size = 238
		refs = "000a ___security_cookie 0014 ?_RTC_ErrorLevels@@3PAHA 0035 ?_strlen_priv@@YAIPBD@Z 0052 ?uninit_premsg@@3QBDB 0083 ?uninit_postmsg@@3QBDB 00c6 ??_C@_0DE@OHJBPMBP@A?5variable?5is?5being?5used?5without@ 00d8 ?failwithmessage@@YAXPAXHHPBD@Z 00e6 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 81 EC 08 04 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC A1 ?? ?? ?? ?? 89 85 F8 FB FF FF 53 8B 5D 08 83 F8 FF 0F 84 B4 00 00 00 85 DB 0F 84 92 00 00 00 53 E8 ?? ?? ?? ?? 83 C0 3A 83 C4 04 3D 00 04 00 00 77 7F 33 C0 EB 06 8D 9B 00 00 00 00 8A 88 ?? ?? ?? ?? 8D 40 01 88 8C 05 FB FB FF FF 84 C9 75 EC 56 57 8B F3 8A 03 43 84 C0 75 F9 8D BD FC FB FF FF 2B DE 4F 8A 47 01 47 84 C0 75 F8 8B CB BA ?? ?? ?? ?? C1 E9 02 F3 A5 8B CB 83 E1 03 F3 A4 8B F2 8A 02 42 84 C0 75 F9 8D BD FC FB FF FF 2B D6 4F 8A 47 01 47 84 C0 75 F8 8B CA 8D 85 FC FB FF FF C1 E9 02 F3 A5 8B CA 83 E1 03 F3 A4 5F 5E EB 05 B8 ?? ?? ?? ?? 50 8B 45 04 6A 03 FF B5 F8 FB FF FF 50 E8 ?? ?? ?? ?? 83 C4 10 8B 4D FC 33 CD 5B E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_260_11_0 {
	meta:
		name = "__vsprintf_s_l"
		size = 45
		refs = "0004 ___local_stdio_printf_options 001d ___stdio_common_vsprintf_s"
	strings:
		$1 = { 55 8B EC E8 ?? ?? ?? ?? FF 75 18 FF 75 14 FF 75 10 FF 75 0C FF 75 08 FF 70 04 FF 30 E8 ?? ?? ?? ?? 83 C4 1C 85 C0 79 03 83 C8 FF 5D C3 }
	condition:
		$1
}

rule file_260_12_0 {
	meta:
		name = "_sprintf_s"
		size = 33
		refs = "0004 ??$__vcrt_va_start_verify_argument_type@QBD@@YAXXZ 0018 __vsprintf_s_l"
	strings:
		$1 = { 55 8B EC E8 ?? ?? ?? ?? 8D 45 14 50 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_263_1_0 {
	meta:
		name = "??_V@YAXPAXHPBDH@Z"
		size = 29
		refs = "0014 ??3@YAXPAXHPBDH@Z"
	strings:
		$1 = { 55 8B EC 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_405_1_0 {
	meta:
		name = "??_U@YAPAXIHPBDH@Z"
		size = 29
		refs = "0014 ??2@YAPAXIHPBDH@Z"
	strings:
		$1 = { 55 8B EC 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_264_1_0 {
	meta:
		name = "??__D@YGXPAX0IIP6EX00@ZP6EX0@Z@Z"
		size = 199
		refs = "0006 __sehtable$??__D@YGXPAX0IIP6EX00@ZP6EX0@Z@Z 000b __except_handler4 001d ___security_cookie 0065 @_guard_check_icall@4 00ae ?__ArrayUnwind@@YGXPAXIIP6EX0@Z@Z"
	strings:
		$1 = { 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 EC 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 C7 45 E0 00 00 00 00 C6 45 E7 00 C7 45 FC 00 00 00 00 EB 09 8B 45 E0 83 C0 01 89 45 E0 8B 4D E0 3B 4D 14 74 2E 6A 01 8B 55 0C 52 8B 45 18 89 45 DC 8B 4D DC E8 ?? ?? ?? ?? 8B 4D 08 FF 55 DC 8B 4D 08 03 4D 10 89 4D 08 8B 55 0C 03 55 10 89 55 0C EB C1 C6 45 E7 01 C7 45 FC FE FF FF FF E8 02 00 00 00 EB 1E 0F B6 45 E7 85 C0 75 15 8B 4D 1C 51 8B 55 E0 52 8B 45 10 50 8B 4D 08 51 E8 ?? ?? ?? ?? C3 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C2 18 00 }
	condition:
		$1
}

rule file_268_0_0 {
	meta:
		name = "__allmul"
		size = 52
	strings:
		$1 = { 8B 44 24 08 8B 4C 24 10 0B C8 8B 4C 24 0C 75 09 8B 44 24 04 F7 E1 C2 10 00 53 F7 E1 8B D8 8B 44 24 08 F7 64 24 14 03 D8 8B 44 24 08 F7 E1 03 D3 5B C2 10 00 }
	condition:
		$1
}

rule file_270_0_0 {
	meta:
		name = "___sse2_acos2"
		size = 528
		refs = "001a _static_const_table"
	strings:
		$1 = { 8B C4 81 EC 30 01 00 00 83 E4 F0 89 84 24 F4 00 00 00 66 0F 28 C8 66 0F 28 05 ?? ?? ?? ?? 66 0F 57 D2 66 0F C2 D1 05 66 0F 29 94 24 C0 00 00 00 66 0F 54 C1 66 0F 28 D9 66 0F 55 1D ?? ?? ?? ?? 66 0F 29 9C 24 B0 00 00 00 66 0F 29 44 24 10 66 0F 55 C1 66 0F 28 E0 66 0F C2 25 ?? ?? ?? ?? 05 66 0F 28 3D ?? ?? ?? ?? 66 0F 29 04 24 66 0F 5C F8 66 0F 59 C0 66 0F 59 3D ?? ?? ?? ?? 66 0F 28 D4 66 0F 54 FC 66 0F 55 D0 66 0F 56 D7 66 0F 51 F7 66 0F 28 2D ?? ?? ?? ?? 66 0F 28 D8 66 0F C2 DD 00 66 0F 29 5C 24 20 66 0F 28 05 ?? ?? ?? ?? 66 0F 56 84 24 B0 00 00 00 66 0F 28 0D ?? ?? ?? ?? 66 0F 56 4C 24 10 66 0F 28 DC 66 0F 54 CC 66 0F 55 D8 66 0F 56 CB 66 0F 29 4C 24 70 66 0F 28 05 ?? ?? ?? ?? 66 0F 28 0D ?? ?? ?? ?? 66 0F 54 8C 24 C0 00 00 00 66 0F 28 DC 66 0F 54 CC 66 0F 55 D8 66 0F 56 CB 66 0F 29 8C 24 80 00 00 00 66 0F 28 CA 66 0F 59 D2 66 0F 28 C2 66 0F 59 05 ?? ?? ?? ?? 66 0F 28 DA 66 0F 59 1D ?? ?? ?? ?? 66 0F 58 05 ?? ?? ?? ?? 66 0F 58 1D ?? ?? ?? ?? 66 0F 59 C2 66 0F 59 DA 66 0F 58 05 ?? ?? ?? ?? 66 0F 28 EC 66 0F 55 2C 24 66 0F 54 F4 66 0F 56 F5 66 0F 29 74 24 40 66 0F 28 6C 24 20 66 0F 28 74 24 20 66 0F 58 1D ?? ?? ?? ?? 66 0F 59 C2 66 0F 59 DA 66 0F 58 05 ?? ?? ?? ?? 66 0F 58 1D ?? ?? ?? ?? 66 0F 59 C2 66 0F 59 DA 66 0F 58 05 ?? ?? ?? ?? 66 0F 58 1D ?? ?? ?? ?? 66 0F 59 C2 66 0F 59 DA 66 0F 58 05 ?? ?? ?? ?? 66 0F 59 C8 66 0F 58 CB 66 0F 28 1D ?? ?? ?? ?? 66 0F 54 9C 24 C0 00 00 00 66 0F 59 4C 24 40 66 0F 58 4C 24 40 66 0F 59 4C 24 70 66 0F 58 8C 24 80 00 00 00 66 0F 54 EB 66 0F 55 F1 66 0F 56 F5 66 0F 28 C6 66 0F 28 C6 8B A4 24 F4 00 00 00 C3 8D 9B 00 00 00 00 }
	condition:
		$1
}

rule file_273_0_0 {
	meta:
		name = "___sse4_floor2"
		size = 16
	strings:
		$1 = { 66 0F 3A 09 C0 01 C3 8D A4 24 00 00 00 00 8B FF }
	condition:
		$1
}

rule file_274_0_0 {
	meta:
		name = "___avx_asin4"
		size = 480
		refs = "0010 ___common_dasin_data 01c9 ___common_dasin_cout_rare"
	strings:
		$1 = { 55 8B EC 83 E4 C0 81 EC C0 00 00 00 C5 FD 10 2D ?? ?? ?? ?? C5 FD 10 3D ?? ?? ?? ?? C5 FD 11 04 24 C5 D5 54 F0 C5 CD 59 E7 C5 CD 59 CE C5 CD C2 15 ?? ?? ?? ?? 1D C5 C5 5C E4 C5 CD C2 FF 15 C5 D5 55 E8 C5 FD 11 6C 24 20 C5 F5 5D EC C5 FD 5A CC C5 DD 58 E4 C4 E3 7D 19 D3 01 C5 E8 C6 C3 DD C5 F8 52 D1 C5 F8 50 D0 C5 FC 5A DA C5 E5 59 C3 C5 DD 59 CB C5 DD 59 E0 C5 DD 5C 05 ?? ?? ?? ?? C5 FD 59 15 ?? ?? ?? ?? C5 F5 59 E0 C5 ED 58 1D ?? ?? ?? ?? C5 E5 59 D0 C5 ED 58 1D ?? ?? ?? ?? C5 D5 59 15 ?? ?? ?? ?? C5 E5 59 C0 C5 ED 58 15 ?? ?? ?? ?? C5 FD 58 05 ?? ?? ?? ?? C5 FD 59 E4 C5 D5 59 05 ?? ?? ?? ?? C5 DD 5C C9 C5 FD 58 05 ?? ?? ?? ?? C5 D5 59 25 ?? ?? ?? ?? C5 FD 11 4C 24 40 C5 D5 59 0D ?? ?? ?? ?? C5 DD 58 1D ?? ?? ?? ?? C5 D5 59 E5 C5 F5 58 0D ?? ?? ?? ?? C5 E5 59 DC C5 E5 58 D8 C5 F5 59 C4 C5 FD 58 CA C5 DD 59 D4 C5 D5 59 05 ?? ?? ?? ?? C5 E5 59 D2 C5 FD 58 05 ?? ?? ?? ?? C5 ED 58 C9 C5 F5 59 DC C5 E5 58 C8 C5 D5 59 05 ?? ?? ?? ?? C5 F5 59 E4 C5 FD 58 15 ?? ?? ?? ?? C5 DD 58 C2 C5 FD 59 ED C4 E3 4D 4B 44 24 40 70 C5 D5 59 F0 C5 CD 58 C8 C5 C5 54 15 ?? ?? ?? ?? C5 F5 58 DA C5 E5 57 44 24 20 85 D2 75 04 8B E5 5D C3 C5 FD 10 0C 24 C5 FD 11 84 24 80 00 00 00 C5 FD 11 4C 24 40 74 E6 33 C0 89 74 24 04 8B F0 89 3C 24 8B FA 0F A3 F7 72 18 46 83 FE 20 7C F5 8B 74 24 04 8B 3C 24 C5 FD 10 84 24 80 00 00 00 EB BC C5 F8 77 8D 8C F4 80 00 00 00 8D 44 F4 40 51 50 E8 ?? ?? ?? ?? 83 C4 08 EB CE 8D A4 24 00 00 00 00 8D A4 24 00 00 00 00 }
	condition:
		$1
}

rule file_277_0_0 {
	meta:
		name = "___avx_logf8"
		size = 352
		refs = "0015 ___common_slog_data 0150 ___common_slog_cout_rare"
	strings:
		$1 = { 55 8B EC 83 E4 C0 81 EC C0 00 00 00 C5 FC 11 04 24 C5 F8 10 1D ?? ?? ?? ?? C5 F8 10 3D ?? ?? ?? ?? C5 F9 FA F3 C4 E3 7D 19 C1 01 C5 E9 72 E6 17 C5 F1 FA E3 C5 C9 DB F7 C5 D1 72 E4 17 C5 D9 DB FF C4 E3 6D 18 D5 01 C5 C9 FE EB C5 C1 FE DB C5 F8 10 35 ?? ?? ?? ?? C5 FC 5B D2 C5 EC 59 15 ?? ?? ?? ?? C4 E3 55 18 E3 01 C5 F8 10 2D ?? ?? ?? ?? C5 F9 FE C5 C5 F1 FE CD C5 C9 66 F8 C5 C9 66 D9 C5 C1 6B C3 C5 DC 5C 1D ?? ?? ?? ?? C5 F1 EF C9 C5 F9 63 E9 C5 F9 D7 D5 C5 E4 59 25 ?? ?? ?? ?? C5 DC 58 35 ?? ?? ?? ?? C5 CC 59 C3 C5 FC 58 0D ?? ?? ?? ?? C5 F4 59 E3 C5 DC 58 2D ?? ?? ?? ?? C5 D4 59 F3 C5 CC 58 3D ?? ?? ?? ?? C5 C4 59 C3 C5 FC 58 0D ?? ?? ?? ?? C5 F4 59 E3 C5 DC 58 2D ?? ?? ?? ?? C5 D4 59 F3 C5 CC 59 FB C5 C4 58 DB C5 EC 58 C3 84 D2 75 04 8B E5 5D C3 C5 FC 10 0C 24 C5 FC 11 84 24 80 00 00 00 C5 FC 11 4C 24 40 85 D2 74 E4 33 C0 89 74 24 04 8B F0 89 3C 24 8B FA 0F A3 F7 72 18 46 83 FE 20 7C F5 8B 74 24 04 8B 3C 24 C5 FC 10 84 24 80 00 00 00 EB BA C5 F8 77 8D 8C B4 80 00 00 00 8D 44 B4 40 51 50 E8 ?? ?? ?? ?? 83 C4 08 EB CE 8D A4 24 00 00 00 00 }
	condition:
		$1
}

rule file_279_0_0 {
	meta:
		name = "___common_dpow_cout_rare"
		size = 2736
		refs = "0191 __vmldPowHATab"
	strings:
		$1 = { 55 8B EC 83 E4 F8 56 57 53 83 EC 6C 8B 55 08 8B 75 0C 0F B6 42 07 F2 0F 10 16 0F B6 7E 07 0F B7 76 06 81 E7 80 00 00 00 0F B7 5A 06 81 E6 F0 7F 00 00 89 44 24 18 81 E3 F0 7F 00 00 25 80 00 00 00 F2 0F 10 0A C1 EB 04 C1 EE 04 C1 E8 07 C1 EF 07 8B 0A F2 0F 11 54 24 60 89 44 24 20 F7 42 04 FF FF 0F 00 75 0E 85 C9 75 0A C7 44 24 10 01 00 00 00 EB 08 C7 44 24 10 00 00 00 00 8B 54 24 60 8B 44 24 64 89 54 24 24 25 FF FF 0F 00 75 12 83 7C 24 24 00 75 0B BA 01 00 00 00 89 54 24 14 EB 08 C7 44 24 14 00 00 00 00 8B D6 33 C9 C1 E2 14 0B D0 B8 01 00 00 00 81 FE FF 07 00 00 0F 45 C8 8B 44 24 24 89 4C 24 1C 0B C2 74 70 81 FE FF 03 00 00 8D 8E 01 FC FF FF 7C 19 83 7C 24 1C 00 74 12 83 F9 14 7F 27 8B C2 D3 E0 C1 E0 0C 0B 44 24 24 74 04 33 D2 EB 4A 8D 8E 0C FC FF FF D3 E2 F7 D2 81 E2 00 00 00 80 C1 EA 1F 42 EB 34 83 F9 35 7D 2A 8B 44 24 24 8D 8E 0C FC FF FF D3 E0 89 44 24 24 A9 FF FF FF 7F 74 04 33 D2 EB 14 F7 D0 25 00 00 00 80 C1 E8 1F 8D 50 01 EB 05 BA 02 00 00 00 83 7C 24 20 00 75 0C 81 FB FF 03 00 00 0F 84 3E 09 00 00 85 F6 75 0B 83 7C 24 14 00 0F 85 A9 03 00 00 33 C0 B9 01 00 00 00 81 FB FF 07 00 00 0F 45 C1 8B 4C 24 10 0B C8 0F 84 82 03 00 00 8B 4C 24 14 0B 4C 24 1C 0F 84 74 03 00 00 F2 0F 10 05 ?? ?? ?? ?? 66 0F 2E C8 7A 06 0F 84 B6 08 00 00 66 0F 2E 0D ?? ?? ?? ?? 7A 06 0F 84 84 08 00 00 85 C0 0F 84 FE 02 00 00 83 7C 24 1C 00 0F 84 F3 02 00 00 66 0F 2F C8 77 08 85 D2 0F 84 B9 02 00 00 23 54 24 20 8B 44 24 18 83 E0 7F F2 0F 11 4C 24 10 85 DB F2 0F 10 04 D5 ?? ?? ?? ?? 88 44 24 17 75 1B F2 0F 10 4C 24 10 BB 38 FF FF FF F2 0F 59 0D ?? ?? ?? ?? F2 0F 11 4C 24 10 EB 08 F2 0F 10 4C 24 10 33 DB F2 0F 11 4C 24 30 0F B7 44 24 16 25 F0 7F 00 00 0F B7 54 24 36 81 E2 0F 80 FF FF C1 E8 04 81 CA F0 3F FF FF 8B 4C 24 14 66 89 54 24 36 81 E1 FF FF 0F 00 C1 E0 14 0B C1 8B 4C 24 34 05 00 40 18 C0 81 E1 00 C0 0F 00 81 C1 00 40 00 00 C1 E9 0F F2 0F 10 74 24 30 F2 0F 11 44 24 48 0F 28 EE C1 F8 14 F2 0F 10 3C CD ?? ?? ?? ?? 03 C3 0F 28 C7 F2 0F 59 C6 F2 0F 2A C8 F2 0F 11 44 24 38 8B 5C 24 3C 81 E3 00 FC 00 00 81 C3 00 04 00 00 C1 EB 0B C1 E1 04 F2 0F 10 1C DD ?? ?? ?? ?? F2 0F 59 C3 F2 0F 58 89 ?? ?? ?? ?? F2 0F 59 FB F2 0F 11 44 24 40 8B 54 24 44 81 E2 F0 0F 00 00 F2 0F 10 1D ?? ?? ?? ?? 83 C2 10 C1 EA 05 F2 0F 59 EB F2 0F 10 24 D5 ?? ?? ?? ?? F2 0F 11 6C 24 50 F2 0F 59 C4 F2 0F 59 FC F2 0F 10 64 24 50 F2 0F 11 5C 24 20 C1 E3 04 F2 0F 5C 64 24 30 F2 0F 58 8B ?? ?? ?? ?? F2 0F 11 64 24 58 F2 0F 10 64 24 50 F2 0F 10 6C 24 58 C1 E2 04 F2 0F 5C E5 F2 0F 58 8A ?? ?? ?? ?? F2 0F 11 64 24 50 F2 0F 10 6C 24 50 F2 0F 10 93 ?? ?? ?? ?? F2 0F 5C F5 F2 0F 58 92 ?? ?? ?? ?? F2 0F 11 74 24 58 0F 28 F7 F2 0F 59 F3 F2 0F 58 91 ?? ?? ?? ?? F2 0F 10 64 24 50 F2 0F 10 6C 24 58 F2 0F 11 74 24 50 F2 0F 10 5C 24 50 F2 0F 11 54 24 28 0F 28 D0 F2 0F 5C DF F2 0F 5C 15 ?? ?? ?? ?? F2 0F 11 5C 24 58 F2 0F 10 5C 24 50 F2 0F 10 74 24 58 F2 0F 5C DE F2 0F 11 5C 24 50 0F 28 DC F2 0F 10 74 24 50 F2 0F 5C FE F2 0F 11 7C 24 58 F2 0F 10 7C 24 50 F2 0F 59 DF F2 0F 59 FD F2 0F 5C D8 0F 28 C1 F2 0F 58 DF F2 0F 58 C2 F2 0F 10 74 24 58 F2 0F 11 44 24 50 F2 0F 10 44 24 50 F2 0F 59 E6 F2 0F 5C C8 F2 0F 59 EE F2 0F 58 CA F2 0F 58 DC F2 0F 11 4C 24 58 F2 0F 58 DD F2 0F 10 6C 24 50 F2 0F 11 6C 24 18 0F B7 44 24 1E 25 F0 7F 00 00 C1 E8 04 03 F0 F2 0F 10 4C 24 58 81 FE 09 08 00 00 F2 0F 10 44 24 48 0F 8D BF 05 00 00 81 FE C0 07 00 00 0F 8F 05 01 00 00 F2 0F 10 0D ?? ?? ?? ?? 33 C0 F2 0F 11 4C 24 50 F2 0F 10 54 24 50 F2 0F 58 15 ?? ?? ?? ?? F2 0F 11 54 24 50 F2 0F 10 5C 24 50 F2 0F 59 C3 E9 C1 00 00 00 F2 0F 11 44 24 50 B8 01 00 00 00 F2 0F 10 4C 24 50 F2 0F 10 44 24 50 F2 0F 5E C8 F2 0F 11 4C 24 50 F2 0F 10 44 24 50 E9 95 00 00 00 81 FB FF 03 00 00 7D 13 33 C0 85 FF 0F 84 83 00 00 00 0F 28 C2 F2 0F 59 C2 EB 7A 33 C0 85 FF 74 0F 23 54 24 20 F2 0F 59 04 D5 ?? ?? ?? ?? EB 65 F2 0F 59 C9 F2 0F 59 D1 23 54 24 20 0F 28 C2 F2 0F 59 04 D5 ?? ?? ?? ?? EB 4B 0F 28 C1 33 C0 F2 0F 58 C2 EB 40 F2 0F 10 05 ?? ?? ?? ?? F2 0F 58 CA F2 0F 11 4C 24 50 F2 0F 11 44 24 58 0F B6 74 24 57 0F B6 44 24 5F 83 E6 80 83 E0 7F 0B C6 88 44 24 5F 33 C0 F2 0F 10 44 24 58 F2 0F 10 4C 24 58 F2 0F 59 C1 8B 55 10 F2 0F 11 02 83 C4 6C 5B 5F 5E 8B E5 5D C3 F2 0F 10 25 ?? ?? ?? ?? F2 0F 58 D3 F2 0F 58 D9 F2 0F 59 E2 F2 0F 58 25 ?? ?? ?? ?? F2 0F 59 E2 F2 0F 58 25 ?? ?? ?? ?? F2 0F 59 E2 F2 0F 58 25 ?? ?? ?? ?? F2 0F 59 E2 F2 0F 10 54 24 28 F2 0F 58 EC F2 0F 58 D3 F2 0F 11 6C 24 50 0F 28 EA F2 0F 10 7C 24 50 F2 0F 10 5C 24 18 F2 0F 5C DF F2 0F 58 DC F2 0F 11 5C 24 58 F2 0F 10 74 24 50 F2 0F 10 5C 24 58 F2 0F 58 EE F2 0F 11 6C 24 50 F2 0F 10 4C 24 50 F2 0F 5C F1 F2 0F 58 F2 F2 0F 10 54 24 20 F2 0F 11 74 24 58 F2 0F 10 74 24 50 F2 0F 59 D6 F2 0F 10 7C 24 58 F2 0F 11 54 24 50 F2 0F 58 FB F2 0F 10 64 24 50 F2 0F 59 7C 24 60 F2 0F 5C E6 F2 0F 11 64 24 58 F2 0F 10 54 24 50 F2 0F 10 6C 24 58 F2 0F 5C D5 F2 0F 11 54 24 50 F2 0F 10 4C 24 50 F2 0F 5C F1 F2 0F 10 4C 24 60 0F 28 D9 F2 0F 59 1D ?? ?? ?? ?? F2 0F 11 74 24 58 F2 0F 10 64 24 50 F2 0F 10 6C 24 58 F2 0F 11 5C 24 50 F2 0F 10 74 24 50 F2 0F 5C 74 24 60 F2 0F 11 74 24 58 F2 0F 10 5C 24 50 F2 0F 10 54 24 58 F2 0F 5C DA F2 0F 11 5C 24 50 F2 0F 10 74 24 50 F2 0F 5C CE F2 0F 11 4C 24 58 F2 0F 10 4C 24 50 F2 0F 10 74 24 58 0F 28 D9 0F 28 D6 F2 0F 59 D5 F2 0F 59 CD F2 0F 59 DC F2 0F 59 E6 F2 0F 58 D1 F2 0F 58 D4 F2 0F 10 25 ?? ?? ?? ?? F2 0F 58 E3 F2 0F 58 FA F2 0F 11 64 24 50 F2 0F 10 6C 24 50 8B 54 24 50 8B C2 83 E2 7F F2 0F 5C 2D ?? ?? ?? ?? F2 0F 11 2C 24 F2 0F 10 0C 24 C1 E2 04 F2 0F 5C D9 F2 0F 11 5C 24 08 F2 0F 10 54 24 08 F2 0F 10 0D ?? ?? ?? ?? F2 0F 58 FA F2 0F 59 CF F2 0F 10 92 ?? ?? ?? ?? C1 F8 07 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CF F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CF F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CF F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CF F2 0F 59 CA F2 0F 58 8A ?? ?? ?? ?? 0F 28 E1 F2 0F 58 E2 F2 0F 11 64 24 10 0F B7 54 24 16 8B CA 81 E1 F0 7F 00 00 C1 E9 04 8D 8C 08 01 FC FF FF 81 F9 00 04 00 00 0F 8D 2E 02 00 00 81 F9 02 FC FF FF 7C 33 81 C1 FF 03 00 00 81 E2 0F 80 FF FF 81 E1 FF 07 00 00 33 C0 C1 E1 04 0B D1 66 89 54 24 16 F2 0F 10 4C 24 10 F2 0F 59 C1 F2 0F 11 44 24 10 E9 6F FD FF FF 81 F9 F8 FB FF FF 0F 8C 1C 01 00 00 F2 0F 11 64 24 50 05 C8 00 00 00 F2 0F 10 5C 24 50 05 FF 03 00 00 F2 0F 10 64 24 20 25 FF 07 00 00 0F B7 15 ?? ?? ?? ?? F2 0F 5C D3 F2 0F 59 05 ?? ?? ?? ?? F2 0F 58 D1 F2 0F 11 54 24 58 81 E2 0F 80 FF FF F2 0F 10 5C 24 50 F2 0F 59 E3 F2 0F 10 54 24 58 F2 0F 11 64 24 50 F2 0F 10 6C 24 50 C1 E0 04 F2 0F 5C EB F2 0F 11 6C 24 58 0B D0 F2 0F 10 7C 24 50 33 C0 F2 0F 10 74 24 58 F2 0F 10 2D ?? ?? ?? ?? F2 0F 5C FE F2 0F 11 7C 24 50 F2 0F 10 4C 24 50 F2 0F 11 6C 24 18 F2 0F 5C D9 F2 0F 11 5C 24 58 F2 0F 10 4C 24 50 F2 0F 10 64 24 58 66 89 54 24 1E F2 0F 58 D4 F2 0F 10 74 24 18 F2 0F 59 CE F2 0F 59 D6 F2 0F 59 C8 F2 0F 59 C2 F2 0F 11 44 24 50 F2 0F 10 44 24 50 F2 0F 58 C8 F2 0F 10 05 ?? ?? ?? ?? F2 0F 11 44 24 50 F2 0F 10 5C 24 50 F2 0F 10 54 24 50 F2 0F 59 DA F2 0F 11 5C 24 50 F2 0F 10 64 24 50 F2 0F 58 CC 0F 28 C1 F2 0F 11 44 24 10 E9 47 FC FF FF 81 F9 C4 FB FF FF 0F 8C 84 00 00 00 05 C7 04 00 00 25 FF 07 00 00 0F B7 15 ?? ?? ?? ?? F2 0F 10 15 ?? ?? ?? ?? 81 E2 0F 80 FF FF C1 E0 04 F2 0F 11 54 24 18 0B D0 66 89 54 24 1E 33 C0 F2 0F 10 0D ?? ?? ?? ?? F2 0F 10 5C 24 18 F2 0F 59 C1 F2 0F 59 E3 F2 0F 59 C4 F2 0F 10 25 ?? ?? ?? ?? F2 0F 11 64 24 50 F2 0F 10 6C 24 50 F2 0F 10 74 24 50 F2 0F 59 F5 F2 0F 11 74 24 50 F2 0F 10 7C 24 50 F2 0F 58 C7 F2 0F 11 44 24 10 E9 B7 FB FF FF F2 0F 10 0D ?? ?? ?? ?? 33 C0 F2 0F 11 4C 24 50 F2 0F 10 54 24 50 F2 0F 10 5C 24 50 F2 0F 59 DA F2 0F 11 5C 24 50 F2 0F 10 64 24 50 F2 0F 59 C4 F2 0F 11 44 24 10 E9 7C FB FF FF F2 0F 10 0D ?? ?? ?? ?? 33 C0 F2 0F 11 4C 24 50 F2 0F 10 5C 24 50 F2 0F 10 54 24 50 F2 0F 59 DA F2 0F 11 5C 24 50 F2 0F 10 64 24 50 F2 0F 59 C4 F2 0F 11 44 24 10 E9 41 FB FF FF 0F B6 44 24 1F 25 80 00 00 00 C1 E8 07 33 F8 33 C0 F2 0F 10 0C FD ?? ?? ?? ?? F2 0F 59 C9 F2 0F 59 C8 0F 28 C1 E9 17 FB FF FF 85 D2 75 0B 83 7C 24 1C 00 0F 85 6D F7 FF FF 83 E2 01 33 C0 F2 0F 10 04 D5 ?? ?? ?? ?? E9 F5 FA FF FF F2 0F 59 C9 85 FF 74 1B 23 54 24 20 B8 01 00 00 00 F2 0F 10 04 D5 ?? ?? ?? ?? F2 0F 5E C1 E9 D2 FA FF FF 23 54 24 20 33 C0 F2 0F 10 04 D5 ?? ?? ?? ?? F2 0F 59 C1 E9 BA FA FF FF 83 7C 24 10 00 0F 84 B7 F6 FF FF E9 6A FA FF FF 8D A4 24 00 00 00 00 8D A4 24 00 00 00 00 }
	condition:
		$1
}

rule file_280_0_0 {
	meta:
		name = "___avx_ceil4"
		size = 16
	strings:
		$1 = { C4 E3 7D 09 C0 02 C3 8D A4 24 00 00 00 00 8B FF }
	condition:
		$1
}

rule file_281_0_0 {
	meta:
		name = "___common_dacos_cout_rare"
		size = 2672
		refs = "0042 __vmldACosHATab 09cb _2il0floatpacket_190"
	strings:
		$1 = { 55 8B EC 83 E4 F8 56 57 53 83 EC 5C 8B 4D 08 0F B7 41 06 25 F0 7F 00 00 F2 0F 10 09 3D F0 7F 00 00 0F B6 51 07 0F 84 08 0A 00 00 F2 0F 11 4C 24 40 83 E2 7F 88 54 24 47 F2 0F 10 64 24 40 F2 0F 10 05 ?? ?? ?? ?? 0F B7 05 ?? ?? ?? ?? 66 0F 2F C4 0F 86 69 09 00 00 F2 0F 10 0D ?? ?? ?? ?? 66 0F 2F CC 0F 86 3A 04 00 00 66 0F 2F 25 ?? ?? ?? ?? 0F 86 D4 03 00 00 F2 0F 10 1D ?? ?? ?? ?? 0F 28 D4 F2 0F 59 D3 F2 0F 11 54 24 38 F2 0F 10 44 24 38 F2 0F 11 64 24 08 F2 0F 5C 44 24 40 F2 0F 11 44 24 30 0F 28 C4 F2 0F 10 54 24 38 F2 0F 10 6C 24 30 F2 0F 5C D5 F2 0F 11 54 24 38 0F 28 D4 F2 0F 10 7C 24 38 F2 0F 5C C7 F2 0F 10 3D ?? ?? ?? ?? F2 0F 11 44 24 30 F2 0F 10 44 24 38 0F 28 C8 F2 0F 58 D0 F2 0F 59 C8 F2 0F 10 74 24 30 0F 28 E9 F2 0F 59 D6 F2 0F 58 EA F2 0F 59 FD F2 0F 11 6C 24 10 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FD F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FD F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FD F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FD F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FD F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FD F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FD F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FD F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FD F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FD 0F 28 EB F2 0F 59 E9 F2 0F 58 3D ?? ?? ?? ?? F2 0F 11 6C 24 38 F2 0F 11 7C 24 18 F2 0F 10 7C 24 38 F2 0F 5C F9 F2 0F 11 7C 24 30 F2 0F 10 7C 24 38 F2 0F 10 6C 24 30 F2 0F 5C FD F2 0F 11 7C 24 38 F2 0F 10 6C 24 38 F2 0F 5C CD F2 0F 11 4C 24 30 F2 0F 10 4C 24 38 F2 0F 10 7C 24 30 F2 0F 59 F1 F2 0F 58 D7 F2 0F 59 C1 F2 0F 59 E2 F2 0F 58 E6 0F 28 F3 F2 0F 59 F0 F2 0F 11 74 24 38 F2 0F 10 6C 24 38 F2 0F 5C E8 F2 0F 11 6C 24 30 0F 28 E8 F2 0F 10 7C 24 38 F2 0F 58 C4 F2 0F 10 74 24 30 F2 0F 59 D0 F2 0F 5C FE F2 0F 11 7C 24 38 F2 0F 10 74 24 38 F2 0F 5C EE F2 0F 11 6C 24 30 0F 28 E9 F2 0F 10 74 24 38 F2 0F 59 EE F2 0F 59 DD F2 0F 10 7C 24 30 F2 0F 11 7C 24 20 F2 0F 58 FC F2 0F 11 5C 24 38 F2 0F 10 5C 24 38 F2 0F 59 CF F2 0F 5C DD F2 0F 11 5C 24 30 0F 28 DD F2 0F 10 7C 24 38 F2 0F 58 CA F2 0F 10 54 24 30 F2 0F 58 E9 F2 0F 5C FA F2 0F 11 7C 24 38 F2 0F 10 54 24 38 F2 0F 10 7C 24 18 F2 0F 5C DA F2 0F 11 5C 24 30 F2 0F 10 5C 24 38 F2 0F 10 54 24 30 F2 0F 11 54 24 28 F2 0F 10 54 24 10 F2 0F 59 D5 F2 0F 59 FA F2 0F 10 15 ?? ?? ?? ?? F2 0F 59 D0 F2 0F 10 05 ?? ?? ?? ?? F2 0F 59 C5 F2 0F 10 6C 24 08 F2 0F 58 D0 F2 0F 10 05 ?? ?? ?? ?? F2 0F 58 D7 F2 0F 59 E0 F2 0F 59 F0 F2 0F 58 D4 F2 0F 10 64 24 20 F2 0F 59 E0 0F 28 C5 F2 0F 58 C6 F2 0F 58 D4 F2 0F 11 44 24 38 F2 0F 10 64 24 38 F2 0F 11 34 24 F2 0F 5C EC F2 0F 10 3D ?? ?? ?? ?? F2 0F 58 EE F2 0F 59 CF F2 0F 59 DF F2 0F 59 7C 24 28 F2 0F 11 6C 24 30 F2 0F 10 64 24 38 F2 0F 10 74 24 30 F2 0F 58 D6 F2 0F 58 D1 0F 28 CC F2 0F 58 CB F2 0F 58 D7 F2 0F 11 4C 24 38 F2 0F 10 44 24 38 F2 0F 5C E0 F2 0F 58 E3 F2 0F 11 64 24 30 F2 0F 10 44 24 38 F2 0F 10 09 F2 0F 10 5C 24 30 66 0F 2F 0D ?? ?? ?? ?? F2 0F 58 D3 76 47 F2 0F 10 25 ?? ?? ?? ?? 0F 28 CC F2 0F 5C C8 F2 0F 11 4C 24 38 F2 0F 10 5C 24 38 F2 0F 10 0D ?? ?? ?? ?? F2 0F 5C E3 F2 0F 5C CA F2 0F 5C E0 F2 0F 11 64 24 30 F2 0F 10 5C 24 38 F2 0F 10 44 24 30 F2 0F 58 C8 EB 45 F2 0F 10 25 ?? ?? ?? ?? 0F 28 C8 F2 0F 58 CC F2 0F 11 4C 24 38 F2 0F 10 5C 24 38 F2 0F 5C E3 F2 0F 58 E0 F2 0F 10 05 ?? ?? ?? ?? F2 0F 58 D0 F2 0F 11 64 24 30 F2 0F 10 5C 24 38 F2 0F 10 4C 24 30 F2 0F 58 CA 8B 45 0C F2 0F 58 D9 F2 0F 11 18 33 C0 83 C4 5C 5B 5F 5E 8B E5 5D C3 F2 0F 10 0D ?? ?? ?? ?? F2 0F 58 C4 F2 0F 11 44 24 38 F2 0F 10 44 24 38 F2 0F 59 44 24 40 F2 0F 11 04 24 0F B6 44 24 07 0F B6 49 07 83 E0 7F 83 E1 80 0B C1 88 44 24 07 33 C0 8B 55 0C F2 0F 5C 0C 24 F2 0F 58 0D ?? ?? ?? ?? F2 0F 11 0A 83 C4 5C 5B 5F 5E 8B E5 5D C3 0F 28 D8 8B F0 81 E6 0F 80 FF FF 25 0F 80 FF FF F2 0F 11 44 24 08 F2 0F 5C DC F2 0F 59 CB F2 0F 11 0C 24 0F B7 54 24 06 81 E2 F0 7F 00 00 C1 EA 04 81 C2 01 FC FF FF 8B DA F7 DB 81 C3 FF 03 00 00 81 E3 FF 07 00 00 C1 E3 04 0B F3 66 89 74 24 0E 8B F2 F2 0F 59 4C 24 08 83 E6 01 0F 28 E9 8B FE F2 0F 10 35 ?? ?? ?? ?? F2 0F 58 E9 75 03 0F 28 E9 F2 0F 59 F5 F2 0F 58 0D ?? ?? ?? ?? F2 0F 11 4C 24 10 0F 28 FE 8B 5C 24 10 2B D6 C1 E7 08 81 E3 FF 01 00 00 03 DF F2 0F 5C FD F2 0F 11 7C 24 30 F2 0F 10 64 24 30 F2 0F 10 14 DD ?? ?? ?? ?? F2 0F 5C F4 0F 28 FA 0F 28 E5 F2 0F 59 FA 0F 28 CE F2 0F 5C E6 F2 0F 59 F2 F2 0F 59 CF F2 0F 59 FC F2 0F 5C C8 D1 EA F2 0F 58 CF F2 0F 10 3D ?? ?? ?? ?? 81 C2 FF 03 00 00 F2 0F 59 F9 81 E2 FF 07 00 00 C1 E2 04 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 F9 0B C2 F2 0F 11 44 24 18 66 89 44 24 1E F2 0F 10 44 24 18 F2 0F 59 F0 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 F9 F2 0F 11 5C 24 20 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 F9 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 F9 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 F9 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 F9 F2 0F 59 FA F2 0F 59 D4 F2 0F 59 FD F2 0F 58 FA F2 0F 10 15 ?? ?? ?? ?? 0F 28 EA F2 0F 59 EE F2 0F 59 F8 F2 0F 11 6C 24 38 F2 0F 10 44 24 38 F2 0F 10 2D ?? ?? ?? ?? F2 0F 5C C6 F2 0F 58 2D ?? ?? ?? ?? F2 0F 11 44 24 30 F2 0F 10 64 24 38 F2 0F 10 4C 24 30 F2 0F 5C E1 F2 0F 10 0D ?? ?? ?? ?? F2 0F 11 64 24 38 F2 0F 10 44 24 38 F2 0F 10 25 ?? ?? ?? ?? F2 0F 5C F0 F2 0F 58 25 ?? ?? ?? ?? F2 0F 11 74 24 30 F2 0F 10 74 24 38 F2 0F 10 44 24 30 F2 0F 11 74 24 28 0F 28 F1 F2 0F 59 E3 F2 0F 58 F8 F2 0F 58 35 ?? ?? ?? ?? F2 0F 10 05 ?? ?? ?? ?? F2 0F 58 F4 F2 0F 59 C3 F2 0F 59 F3 F2 0F 58 05 ?? ?? ?? ?? F2 0F 58 EE F2 0F 59 C3 0F 28 E3 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C3 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C3 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C3 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C3 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C3 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C3 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C3 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C3 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C3 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C3 F2 0F 59 C3 F2 0F 59 C3 F2 0F 11 44 24 40 F2 0F 58 E8 F2 0F 59 FD F2 0F 11 7C 24 48 0F 28 FA F2 0F 59 FB F2 0F 11 7C 24 38 F2 0F 10 44 24 38 F2 0F 5C C3 F2 0F 11 44 24 30 F2 0F 10 74 24 38 F2 0F 10 6C 24 30 F2 0F 5C F5 F2 0F 11 74 24 38 F2 0F 10 7C 24 38 F2 0F 5C E7 F2 0F 11 64 24 30 F2 0F 10 64 24 38 0F 28 EC 0F 28 C4 F2 0F 59 EC F2 0F 58 C3 F2 0F 59 E1 0F 28 DA F2 0F 59 DD F2 0F 10 7C 24 30 F2 0F 11 5C 24 38 F2 0F 10 74 24 38 F2 0F 59 CF F2 0F 5C F5 F2 0F 59 C7 F2 0F 11 74 24 30 F2 0F 10 74 24 38 F2 0F 10 5C 24 30 F2 0F 5C F3 F2 0F 11 74 24 38 F2 0F 10 5C 24 38 F2 0F 5C EB 0F 28 DC F2 0F 11 6C 24 30 F2 0F 10 74 24 38 F2 0F 59 35 ?? ?? ?? ?? F2 0F 10 6C 24 30 F2 0F 58 DE F2 0F 11 5C 24 38 F2 0F 11 6C 24 50 F2 0F 10 6C 24 38 F2 0F 11 74 24 10 F2 0F 5C E5 F2 0F 10 2D ?? ?? ?? ?? F2 0F 58 E6 F2 0F 11 64 24 30 0F 28 E5 F2 0F 10 5C 24 38 F2 0F 10 74 24 30 F2 0F 58 E3 F2 0F 11 64 24 38 F2 0F 10 64 24 38 F2 0F 5C EC F2 0F 58 EB F2 0F 11 6C 24 30 F2 0F 10 64 24 38 F2 0F 59 D4 F2 0F 10 5C 24 30 F2 0F 11 54 24 38 F2 0F 10 54 24 38 F2 0F 5C D4 F2 0F 11 54 24 30 F2 0F 10 54 24 38 F2 0F 10 6C 24 30 F2 0F 5C D5 F2 0F 11 54 24 38 F2 0F 10 6C 24 38 F2 0F 5C E5 F2 0F 11 64 24 30 F2 0F 10 6C 24 38 F2 0F 10 54 24 30 F2 0F 10 25 ?? ?? ?? ?? F2 0F 58 D6 F2 0F 10 31 F2 0F 58 D3 66 0F 2F 35 ?? ?? ?? ?? F2 0F 58 D1 F2 0F 10 5C 24 20 F2 0F 59 E3 F2 0F 10 4C 24 50 F2 0F 58 C8 F2 0F 10 44 24 28 F2 0F 58 25 ?? ?? ?? ?? F2 0F 59 0D ?? ?? ?? ?? F2 0F 59 E3 F2 0F 58 D1 F2 0F 58 25 ?? ?? ?? ?? F2 0F 59 D0 F2 0F 58 64 24 40 F2 0F 10 4C 24 48 F2 0F 59 E0 F2 0F 58 CA F2 0F 59 C5 F2 0F 58 CC 77 4D F2 0F 10 25 ?? ?? ?? ?? 0F 28 D4 F2 0F 10 35 ?? ?? ?? ?? F2 0F 5C D0 F2 0F 5C F1 F2 0F 11 54 24 38 F2 0F 10 5C 24 38 F2 0F 11 04 24 F2 0F 5C E3 F2 0F 5C E0 F2 0F 11 64 24 30 F2 0F 10 44 24 38 F2 0F 10 6C 24 30 0F 28 CD F2 0F 58 CE 8B 45 0C F2 0F 58 C1 F2 0F 11 00 33 C0 83 C4 5C 5B 5F 5E 8B E5 5D C3 66 0F 2E C8 7A 02 74 50 0F 57 05 ?? ?? ?? ?? 66 0F 2E C8 7A 02 74 1E 8B 45 0C F2 0F 5C C9 F2 0F 5E C9 F2 0F 11 08 B8 01 00 00 00 83 C4 5C 5B 5F 5E 8B E5 5D C3 F2 0F 10 05 ?? ?? ?? ?? 8B 45 0C F2 0F 58 05 ?? ?? ?? ?? F2 0F 11 00 33 C0 83 C4 5C 5B 5F 5E 8B E5 5D C3 8B 45 0C F2 0F 10 05 ?? ?? ?? ?? F2 0F 11 00 33 C0 83 C4 5C 5B 5F 5E 8B E5 5D C3 F2 0F 5E C9 8B 45 0C F2 0F 11 08 F7 41 04 FF FF 0F 00 75 17 BA 01 00 00 00 33 C0 83 39 00 0F 44 C2 83 C4 5C 5B 5F 5E 8B E5 5D C3 33 C0 83 C4 5C 5B 5F 5E 8B E5 5D C3 8D 9B 00 00 00 00 }
	condition:
		$1
}

rule file_283_3_0 {
	meta:
		name = "__ftol3_NaN"
		size = 24
	strings:
		$1 = { 66 0F 7E C0 25 FF FF FF 7F 3D 00 00 80 7F 0F 83 4C 01 00 00 F3 0F 5A C0 }
	condition:
		$1
}

rule file_283_4_0 {
	meta:
		name = "__ftol3_work"
		size = 134
		refs = "0009 _MinSubInexact 002b _MinInt64 0050 _MinFP32"
	strings:
		$1 = { 83 F9 02 75 18 F2 0F 10 15 ?? ?? ?? ?? 66 0F 2F C2 76 0A BA 10 00 00 00 E8 3D 01 00 00 66 0F 2F C5 0F 83 21 01 00 00 F2 0F 10 35 ?? ?? ?? ?? 66 0F 2F C6 0F 82 0F 01 00 00 66 0F 6F C8 66 0F 73 F1 01 66 0F 73 D1 01 83 F9 01 74 3A F2 0F 10 15 ?? ?? ?? ?? 66 0F 2F CA 77 2C 66 0F 57 D2 66 0F 2F CA 74 22 50 9B D9 3C 24 66 8B 04 24 66 A9 10 00 58 75 12 BA 02 00 00 00 E8 DC 00 00 00 33 C0 BA 00 00 00 80 C3 }
	condition:
		$1
}

rule file_283_5_0 {
	meta:
		name = "__ftol3_common"
		size = 194
		refs = "0012 _MantissaMask 001a _IntegerBit 0022 _i1075"
	strings:
		$1 = { 66 0F 57 F6 66 0F 2F CE 0F 84 A6 00 00 00 F2 0F 10 1D ?? ?? ?? ?? F2 0F 10 25 ?? ?? ?? ?? 66 0F 6E 2D ?? ?? ?? ?? 66 0F 6F F0 F2 0F C2 F1 00 66 0F 6F D1 66 0F DB D3 66 0F EB D4 66 0F 73 D1 34 66 0F 6F E1 66 0F FB E5 66 0F 6F DA 66 0F F3 DC 66 0F 6F E5 66 0F FB E1 66 0F 6F FA 66 0F D3 FC 66 0F 66 CD 66 0F 62 C9 66 0F DB D9 66 0F DF CF 66 0F EB CB 66 0F EF ED 66 0F FB E9 66 0F DB CE 66 0F DF F5 66 0F EB F1 66 0F 7E E0 83 F8 00 7E 23 66 0F F3 FC 66 0F EF D7 66 0F 7E D0 66 0F 73 DA 04 66 0F 7E D2 0B C2 74 0A BA 10 00 00 00 E8 20 00 00 00 66 0F 7E F0 66 0F 73 DE 04 66 0F 7E F2 C3 }
	condition:
		$1
}

rule file_283_6_0 {
	meta:
		name = "__ftol3_arg_error"
		size = 18
	strings:
		$1 = { BA 08 00 00 00 E8 08 00 00 00 33 C0 BA 00 00 00 80 C3 }
	condition:
		$1
}

rule file_283_7_0 {
	meta:
		name = "__ftol3_except"
		size = 68
		refs = "0012 _FpExcptTable 001a _CWMask 003a __except1"
	strings:
		$1 = { 83 EC 20 9B D9 3C 24 0F B7 04 24 83 FA 08 74 08 84 82 ?? ?? ?? ?? 75 28 D9 2D ?? ?? ?? ?? 89 14 24 C7 44 24 04 00 00 00 00 F2 0F 11 44 24 08 F2 0F 11 44 24 10 89 44 24 18 E8 ?? ?? ?? ?? DD D8 83 C4 20 C3 }
	condition:
		$1
}

rule file_283_11_0 {
	meta:
		name = "__dtol3_NaN"
		size = 29
	strings:
		$1 = { 66 0F 6F C8 66 0F 73 D9 04 66 0F 7E C8 25 FF FF FF 7F 3D 00 00 F0 7F 0F 83 62 FF FF FF }
	condition:
		$1
}

rule file_283_12_0 {
	meta:
		name = "__dtol3_work"
		size = 231
		refs = "001b _MaxFP32 0058 _MinFP32 0096 _MaxInt64 00d2 _MinInt64"
	strings:
		$1 = { 83 F9 01 0F 84 11 FE FF FF 66 0F 6F C8 66 0F 73 F1 01 66 0F 73 D1 01 F2 0F 10 15 ?? ?? ?? ?? 66 0F 2F CA 76 2F 83 F9 04 74 16 BA 01 00 00 00 E8 40 FF FF FF BA 10 00 00 00 E8 36 FF FF FF EB 14 BA 10 00 00 00 E8 2A FF FF FF BA 01 00 00 00 E8 20 FF FF FF F2 0F 10 15 ?? ?? ?? ?? 66 0F 2F CA 73 27 66 0F 57 D2 66 0F 2F CA 0F 84 30 FE FF FF BA 02 00 00 00 E8 FA FE FF FF BA 10 00 00 00 E8 F0 FE FF FF E9 17 FE FF FF 66 0F 6F D8 83 F9 04 75 12 F2 0F 10 15 ?? ?? ?? ?? 66 0F 2F DA 72 04 66 0F 5C DA 66 0F 6F E3 66 0F 73 F4 23 66 0F 73 D4 23 66 0F 7E E0 0B C0 74 0A BA 10 00 00 00 E8 B0 FE FF FF 66 0F 2F C5 0F 83 94 FE FF FF F2 0F 10 15 ?? ?? ?? ?? 66 0F 2F C2 0F 82 82 FE FF FF E9 BB FD FF FF 8B FF }
	condition:
		$1
}

rule file_283_13_0 {
	meta:
		name = "__ultod3"
		size = 64
		refs = "000f _Int32ToUInt32 002e _DP2to32"
	strings:
		$1 = { 0F 57 C0 F2 0F 2A C1 C1 E9 1F F2 0F 58 04 CD ?? ?? ?? ?? 85 D2 74 1F 0F 57 C9 F2 0F 2A CA C1 EA 1F F2 0F 58 0C D5 ?? ?? ?? ?? F2 0F 59 0D ?? ?? ?? ?? F2 0F 58 C1 C3 8D A4 24 00 00 00 00 8B FF }
	condition:
		$1
}

rule file_283_14_0 {
	meta:
		name = "__ltod3"
		size = 39
		refs = "0015 _DP2to32 001e _Int32ToUInt32"
	strings:
		$1 = { 0F 57 C9 F2 0F 2A CA 0F 57 C0 F2 0F 2A C1 C1 E9 1F F2 0F 59 0D ?? ?? ?? ?? F2 0F 58 04 CD ?? ?? ?? ?? F2 0F 58 C1 C3 }
	condition:
		$1
}

rule file_286_1_0 {
	meta:
		name = "?__scrt_uninitialize_type_info@@YAXXZ"
		size = 18
		refs = "0004 ?__type_info_root_node@@3U__type_info_node@@A 0009 ___std_type_info_destroy_list"
	strings:
		$1 = { 55 8B EC 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_102_44_1 {
	meta:
		name = "??__E_Fac_tidy_reg@std@@YAXXZ"
		size = 18
		refs = "0004 ??__F_Fac_tidy_reg@std@@YAXXZ 0009 _atexit"
	strings:
		$1 = { 55 8B EC 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_46_2_1 {
	meta:
		name = "??__Einit_atexit@@YAXXZ"
		size = 18
		refs = "0004 ??__Finit_atexit@@YAXXZ 0009 _atexit"
	strings:
		$1 = { 55 8B EC 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_287_0_0 {
	meta:
		name = "___sse2_expf4"
		size = 544
		refs = "0012 _static_const_table"
	strings:
		$1 = { 8B C4 81 EC 90 00 00 00 83 E4 F0 89 44 24 54 0F 28 3D ?? ?? ?? ?? 89 4C 24 34 0F 28 0D ?? ?? ?? ?? 89 5C 24 30 0F 54 F8 0F 28 15 ?? ?? ?? ?? 0F 59 C8 0F 28 1D ?? ?? ?? ?? 0F 58 CA 0F 5C D1 66 0F 66 3D ?? ?? ?? ?? 0F 59 DA 66 0F 7E C8 0F 59 15 ?? ?? ?? ?? 0F 29 44 24 20 66 0F 6F E9 66 0F 6F F1 66 0F 73 D1 1D 0F 58 C3 66 0F FE 2D ?? ?? ?? ?? 66 0F 7E CB 0F 58 C2 66 0F 70 CE EE 83 E0 3F 0F 28 35 ?? ?? ?? ?? 0F 59 F0 66 0F 7E C9 81 E3 F8 01 00 00 83 E1 3F F3 0F 7E 1C C5 ?? ?? ?? ?? 66 0F 73 D1 1D F3 0F 7E A3 ?? ?? ?? ?? 90 0F 58 35 ?? ?? ?? ?? 66 0F 7E C8 F3 0F 7E 14 CD ?? ?? ?? ?? 25 F8 01 00 00 0F 14 DC F3 0F 7E 88 ?? ?? ?? ?? 66 0F 72 F5 11 0F 59 F0 0F 28 E3 66 0F DB 2D ?? ?? ?? ?? 0F 14 D1 0F 59 F0 8B 5C 24 30 0F 58 F0 0F C6 DA 44 8B 4C 24 34 0F C6 E2 EE 0F 28 C3 0F 58 DC 0F 59 F3 0F 50 C7 0F 58 F4 A9 0F 00 00 00 0F 58 C6 75 08 0F 59 C5 E9 F7 00 00 00 0F 29 44 24 10 0F 28 4C 24 20 0F 57 D2 0F 59 C5 0F C2 D1 03 B9 00 00 00 00 0F 50 DA 33 C3 0F 84 CB 00 00 00 0F 28 15 ?? ?? ?? ?? 0F 28 D8 0F C2 D1 02 0F 28 05 ?? ?? ?? ?? 0F 54 C2 0F 50 DA 0F 55 D3 33 C3 0F 56 C2 0F 84 A2 00 00 00 0F 28 D8 0F 28 C1 0F C2 05 ?? ?? ?? ?? 02 0F 50 D8 0F 55 C3 33 C3 0F 84 86 00 00 00 0F 50 D9 0F 29 04 24 A9 01 00 00 00 74 6B F7 C3 01 00 00 00 F3 0F 10 44 8C 20 0F 59 05 ?? ?? ?? ?? 0F 58 05 ?? ?? ?? ?? 75 15 66 0F FE 05 ?? ?? ?? ?? 0F 28 2D ?? ?? ?? ?? 66 0F EF F6 EB 1A 66 0F FE 05 ?? ?? ?? ?? 0F 28 2D ?? ?? ?? ?? 66 0F FE 05 ?? ?? ?? ?? 0F 28 F5 66 0F 72 F0 11 66 0F DB 05 ?? ?? ?? ?? 66 0F FA C6 F3 0F 59 44 8C 10 F3 0F 59 C5 F3 0F 11 04 8C D1 EB 83 C1 01 D1 E8 75 85 0F 28 04 24 8B 5C 24 30 8B 4C 24 34 8B 64 24 54 C3 8D 64 24 00 }
	condition:
		$1
}

rule file_289_0_0 {
	meta:
		name = "___common_dcos_cout_rare"
		size = 128
		refs = "0049 __vmldCosHATab"
	strings:
		$1 = { 55 8B EC 83 E4 F8 83 EC 08 8B 55 08 0F B7 4A 06 81 E1 F0 7F 00 00 F2 0F 10 0A 0F B6 42 07 83 E0 7F F2 0F 11 0C 24 81 F9 F0 7F 00 00 75 3E 8B 55 0C 83 3C 24 00 75 27 88 44 24 07 81 7C 24 04 00 00 F0 7F 75 19 F2 0F 10 05 ?? ?? ?? ?? B8 01 00 00 00 F2 0F 59 C8 F2 0F 11 0A 8B E5 5D C3 F2 0F 59 C9 33 C0 F2 0F 11 0A 8B E5 5D C3 33 C0 8B E5 5D C3 8D A4 24 00 00 00 00 8D A4 24 00 00 00 00 }
	condition:
		$1
}

rule file_304_0_0 {
	meta:
		name = "___common_dsin_cout_rare"
		size = 128
		refs = "0049 __vmldSinHATab"
	strings:
		$1 = { 55 8B EC 83 E4 F8 83 EC 08 8B 55 08 0F B7 4A 06 81 E1 F0 7F 00 00 F2 0F 10 0A 0F B6 42 07 83 E0 7F F2 0F 11 0C 24 81 F9 F0 7F 00 00 75 3E 8B 55 0C 83 3C 24 00 75 27 88 44 24 07 81 7C 24 04 00 00 F0 7F 75 19 F2 0F 10 05 ?? ?? ?? ?? B8 01 00 00 00 F2 0F 59 C8 F2 0F 11 0A 8B E5 5D C3 F2 0F 59 C9 33 C0 F2 0F 11 0A 8B E5 5D C3 33 C0 8B E5 5D C3 8D A4 24 00 00 00 00 8D A4 24 00 00 00 00 }
	condition:
		$1
}

rule file_291_0_0 {
	meta:
		name = "___common_dexp_cout_rare"
		size = 912
		refs = "0011 __imldExpHATab"
	strings:
		$1 = { 55 8B EC 83 E4 F8 56 83 EC 4C 8B 45 08 F2 0F 10 15 ?? ?? ?? ?? 0F B7 0D ?? ?? ?? ?? F2 0F 10 00 0F B7 40 06 25 F0 7F 00 00 C1 E8 04 F2 0F 11 44 24 40 3D FF 07 00 00 0F 84 01 03 00 00 3D CA 03 00 00 0F 8E D9 02 00 00 F2 0F 10 0D ?? ?? ?? ?? 66 0F 2F C8 0F 82 A7 02 00 00 66 0F 2F 05 ?? ?? ?? ?? 0F 82 79 02 00 00 F2 0F 10 0D ?? ?? ?? ?? 0F 28 F0 F2 0F 59 C8 F2 0F 11 4C 24 30 F2 0F 11 54 24 40 F2 0F 10 54 24 30 F2 0F 58 15 ?? ?? ?? ?? F2 0F 11 54 24 38 F2 0F 10 5C 24 38 8B 74 24 38 8B C6 83 E6 3F F2 0F 5C 1D ?? ?? ?? ?? F2 0F 11 5C 24 30 F2 0F 10 64 24 30 F2 0F 59 25 ?? ?? ?? ?? F2 0F 10 6C 24 30 F2 0F 5C F4 F2 0F 59 2D ?? ?? ?? ?? F2 0F 10 1D ?? ?? ?? ?? F2 0F 5C F5 F2 0F 59 DE C1 E6 04 F2 0F 58 1D ?? ?? ?? ?? F2 0F 59 DE C1 E8 06 F2 0F 58 1D ?? ?? ?? ?? 66 0F 2F 05 ?? ?? ?? ?? F2 0F 59 DE F2 0F 10 8E ?? ?? ?? ?? 8D 90 FF 03 00 00 F2 0F 58 1D ?? ?? ?? ?? F2 0F 59 DE F2 0F 58 1D ?? ?? ?? ?? F2 0F 59 DE F2 0F 59 DE F2 0F 58 DE F2 0F 58 9E ?? ?? ?? ?? F2 0F 59 D9 72 73 81 E2 FF 07 00 00 F2 0F 58 D9 81 FA FE 07 00 00 77 27 C1 E2 04 81 E1 0F 80 FF FF 0B CA 66 89 4C 24 46 F2 0F 59 5C 24 40 8B 45 0C F2 0F 11 18 33 C0 83 C4 4C 5E 8B E5 5D C3 4A 81 E2 FF 07 00 00 0F B7 44 24 46 C1 E2 04 25 0F 80 FF FF 0B C2 66 89 44 24 46 33 C0 F2 0F 59 5C 24 40 F2 0F 59 1D ?? ?? ?? ?? 8B 55 0C F2 0F 11 1A 83 C4 4C 5E 8B E5 5D C3 05 3B 04 00 00 25 FF 07 00 00 8B D0 0F B7 4C 24 46 C1 E2 04 81 E1 0F 80 FF FF 0B CA 66 89 4C 24 46 83 F8 32 F2 0F 10 54 24 40 F2 0F 59 DA F2 0F 59 D1 0F 28 C2 F2 0F 58 C3 77 14 F2 0F 59 05 ?? ?? ?? ?? 8B 45 0C F2 0F 11 00 E9 CC 00 00 00 F2 0F 11 04 24 F2 0F 10 04 24 8B 45 0C F2 0F 5C D0 F2 0F 11 54 24 08 F2 0F 10 4C 24 08 F2 0F 58 D9 F2 0F 11 5C 24 08 F2 0F 10 14 24 F2 0F 59 15 ?? ?? ?? ?? F2 0F 11 54 24 10 F2 0F 10 24 24 F2 0F 10 5C 24 10 F2 0F 58 E3 F2 0F 11 64 24 18 F2 0F 10 74 24 18 F2 0F 10 6C 24 10 F2 0F 5C F5 F2 0F 11 74 24 20 F2 0F 10 04 24 F2 0F 10 7C 24 20 F2 0F 5C C7 F2 0F 11 44 24 28 F2 0F 10 4C 24 08 F2 0F 10 54 24 28 F2 0F 58 D1 F2 0F 11 54 24 28 F2 0F 10 5C 24 20 F2 0F 59 1D ?? ?? ?? ?? F2 0F 11 5C 24 20 F2 0F 10 64 24 28 F2 0F 59 25 ?? ?? ?? ?? F2 0F 11 64 24 28 F2 0F 10 74 24 20 F2 0F 10 6C 24 28 F2 0F 58 F5 F2 0F 11 30 B8 04 00 00 00 83 C4 4C 5E 8B E5 5D C3 F2 0F 10 05 ?? ?? ?? ?? F2 0F 59 C0 8B 45 0C F2 0F 11 00 B8 04 00 00 00 83 C4 4C 5E 8B E5 5D C3 F2 0F 10 05 ?? ?? ?? ?? F2 0F 59 C0 8B 45 0C F2 0F 11 00 B8 03 00 00 00 83 C4 4C 5E 8B E5 5D C3 F2 0F 10 0D ?? ?? ?? ?? 8B 45 0C F2 0F 58 C8 F2 0F 11 08 33 C0 83 C4 4C 5E 8B E5 5D C3 0F B6 44 24 47 A9 80 00 00 00 75 15 F2 0F 59 C0 8B 45 0C F2 0F 11 00 33 C0 83 C4 4C 5E 8B E5 5D C3 F7 44 24 44 FF FF 0F 00 75 E1 83 7C 24 40 00 75 DA 8B 45 0C F2 0F 11 10 33 C0 83 C4 4C 5E 8B E5 5D C3 8D A4 24 00 00 00 00 8D A4 24 00 00 00 00 90 }
	condition:
		$1
}

rule file_292_0_0 {
	meta:
		name = "___avx_log4"
		size = 416
		refs = "0010 ___common_dlog_data 018f ___common_dlog_cout_rare"
	strings:
		$1 = { 55 8B EC 83 E4 C0 81 EC C0 00 00 00 C5 FD 54 2D ?? ?? ?? ?? C5 D5 56 1D ?? ?? ?? ?? C5 FD 5A CB C5 F8 53 F1 C5 FC 5A FE C5 E9 73 D0 14 C4 E3 7D 19 C4 01 C5 D1 73 D4 14 C5 FD C2 25 ?? ?? ?? ?? 11 C5 E8 C6 CD DD C5 FD C2 2D ?? ?? ?? ?? 16 C4 E3 7D 09 D7 00 C5 FE E6 F1 C5 DD 56 FD C5 E5 54 25 ?? ?? ?? ?? C5 E5 5C DC C4 E3 7D 19 FD 01 C5 C0 C6 CD DD C5 DD 59 EA C5 F8 50 C1 C5 E5 59 CA C5 D5 5C 1D ?? ?? ?? ?? C5 E5 58 E9 C5 C1 73 D2 28 C5 F9 7E FA C4 E3 79 16 F9 02 C4 E3 7D 19 D4 01 C5 D9 73 D4 28 C5 FB 10 9A ?? ?? ?? ?? C5 F9 7E E2 C5 E1 16 89 ?? ?? ?? ?? C5 ED C2 15 ?? ?? ?? ?? 1E C5 FB 10 BA ?? ?? ?? ?? C4 E3 79 16 E1 02 C5 ED 54 15 ?? ?? ?? ?? C5 C1 16 A1 ?? ?? ?? ?? C4 E3 75 18 DC 01 C5 ED 56 0D ?? ?? ?? ?? C5 CD 5C F1 C5 D5 59 0D ?? ?? ?? ?? C5 D5 59 25 ?? ?? ?? ?? C5 CD 59 15 ?? ?? ?? ?? C5 F5 58 35 ?? ?? ?? ?? C5 DD 58 25 ?? ?? ?? ?? C5 D5 59 CD C5 CD 59 F9 C5 C5 58 F4 C5 CD 59 C9 C5 D5 58 E9 C5 D5 58 DB C5 E5 58 CA 85 C0 75 08 C5 FD 28 C1 8B E5 5D C3 C5 FD 11 44 24 40 C5 FD 11 8C 24 80 00 00 00 74 E7 33 D2 89 74 24 04 8B F2 89 3C 24 8B F8 0F A3 F7 72 18 46 83 FE 20 7C F5 8B 74 24 04 8B 3C 24 C5 FD 10 8C 24 80 00 00 00 EB BD C5 F8 77 8D 8C F4 80 00 00 00 8D 44 F4 40 51 50 E8 ?? ?? ?? ?? 83 C4 08 EB CE 8D A4 24 00 00 00 00 90 }
	condition:
		$1
}

rule file_295_0_0 {
	meta:
		name = "__EH_epilog3"
		size = 21
	strings:
		$1 = { 8B 4D F4 64 89 0D 00 00 00 00 59 5F 5F 5E 5B 8B E5 5D 51 F2 C3 }
	condition:
		$1
}

rule file_295_1_0 {
	meta:
		name = "__EH_epilog3_GS"
		size = 17
		refs = "0007 @__security_check_cookie@4 000d __EH_epilog3"
	strings:
		$1 = { 8B 4D F0 33 CD F2 E8 ?? ?? ?? ?? F2 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_295_2_0 {
	meta:
		name = "__EH_epilog3_catch_GS"
		size = 17
		refs = "0007 @__security_check_cookie@4 000d __EH_epilog3"
	strings:
		$1 = { 8B 4D EC 33 CD F2 E8 ?? ?? ?? ?? F2 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_295_3_0 {
	meta:
		name = "__EH_prolog3"
		size = 52
		refs = "0018 ___security_cookie"
	strings:
		$1 = { 50 64 FF 35 00 00 00 00 8D 44 24 0C 2B 64 24 0C 53 56 57 89 28 8B E8 A1 ?? ?? ?? ?? 33 C5 50 FF 75 FC C7 45 FC FF FF FF FF 8D 45 F4 64 A3 00 00 00 00 F2 C3 }
	condition:
		$1
}

rule file_295_4_0 {
	meta:
		name = "__EH_prolog3_GS"
		size = 55
		refs = "0018 ___security_cookie"
	strings:
		$1 = { 50 64 FF 35 00 00 00 00 8D 44 24 0C 2B 64 24 0C 53 56 57 89 28 8B E8 A1 ?? ?? ?? ?? 33 C5 50 89 45 F0 FF 75 FC C7 45 FC FF FF FF FF 8D 45 F4 64 A3 00 00 00 00 F2 C3 }
	condition:
		$1
}

rule file_295_5_0 {
	meta:
		name = "__EH_prolog3_catch"
		size = 55
		refs = "0018 ___security_cookie"
	strings:
		$1 = { 50 64 FF 35 00 00 00 00 8D 44 24 0C 2B 64 24 0C 53 56 57 89 28 8B E8 A1 ?? ?? ?? ?? 33 C5 50 89 65 F0 FF 75 FC C7 45 FC FF FF FF FF 8D 45 F4 64 A3 00 00 00 00 F2 C3 }
	condition:
		$1
}

rule file_295_6_0 {
	meta:
		name = "__EH_prolog3_catch_GS"
		size = 58
		refs = "0018 ___security_cookie"
	strings:
		$1 = { 50 64 FF 35 00 00 00 00 8D 44 24 0C 2B 64 24 0C 53 56 57 89 28 8B E8 A1 ?? ?? ?? ?? 33 C5 50 89 45 EC 89 65 F0 FF 75 FC C7 45 FC FF FF FF FF 8D 45 F4 64 A3 00 00 00 00 F2 C3 }
	condition:
		$1
}

rule file_298_0_0 {
	meta:
		name = "___avx_powf8"
		size = 1488
		refs = "0041 ___common_spow_data 05bd ___common_spow_cout_rare"
	strings:
		$1 = { 55 8B EC 83 E4 C0 81 EC 80 02 00 00 C5 FC 11 4C 24 20 C5 FC 11 04 24 C4 E3 7D 19 C4 01 C5 FC 5A F4 C5 F8 28 D0 C4 E3 7D 19 C8 01 C5 FC 5A F8 C5 FC 5A D9 C5 FC 5A EA C5 FD 11 7C 24 60 C5 F8 10 3D ?? ?? ?? ?? C5 F9 DB C7 C5 F1 DB CF C5 FA 7F 84 24 10 02 00 00 C5 FA 7F 8C 24 00 02 00 00 C5 FD 11 5C 24 40 C5 F8 10 1D ?? ?? ?? ?? C5 E9 FA D3 C5 D9 FA E3 C5 FA 7F 94 24 E0 01 00 00 C5 FA 7F A4 24 F0 01 00 00 C5 FD 10 05 ?? ?? ?? ?? C5 FD 10 15 ?? ?? ?? ?? C5 D5 54 C8 C5 F5 56 DA C5 CD 54 E0 C5 FD 5A FB C5 DD 56 D2 C5 FD 5A E2 C5 F8 53 C7 C5 F8 53 FC C5 FC 5A C8 C5 FC 5A E7 C4 E3 7D 19 E8 01 C5 D1 73 D5 14 C5 F9 73 D0 14 C5 D0 C6 E8 DD C4 E3 7D 19 F7 01 C5 C9 73 D6 14 C5 F9 73 D7 14 C5 C8 C6 F8 DD C4 E3 7D 09 C1 00 C4 E3 7D 09 CC 00 C5 FE E6 F7 C5 FE E6 E5 C5 FD 10 3D ?? ?? ?? ?? C5 E5 59 D8 C5 ED 59 D1 C5 FD 11 B4 24 80 00 00 00 C5 E5 5C EF C5 ED 5C FF C5 FD 11 AC 24 A0 00 00 00 C5 FD 11 BC 24 C0 00 00 00 C5 D1 73 D0 28 C5 F9 7E E8 C4 E3 7D 19 C3 01 C4 E3 79 16 EA 02 C5 E1 73 D3 28 C5 F9 7E D9 C5 C1 73 D1 28 C4 E3 7D 19 CE 01 C5 E9 73 D6 28 C5 FB 10 B0 ?? ?? ?? ?? C4 E3 79 16 D8 02 C5 C9 16 B2 ?? ?? ?? ?? C5 F9 7E FA C5 FB 10 A9 ?? ?? ?? ?? C5 D1 16 98 ?? ?? ?? ?? C5 F9 7E D0 C5 FB 10 AA ?? ?? ?? ?? C4 E3 79 16 D2 02 C4 E3 79 16 F9 02 C4 E3 4D 18 F3 01 C5 FB 10 98 ?? ?? ?? ?? C5 E1 16 92 ?? ?? ?? ?? C5 FD 10 1D ?? ?? ?? ?? C5 D1 16 B9 ?? ?? ?? ?? C5 FD 10 2D ?? ?? ?? ?? C5 E5 C2 C0 11 C5 E5 C2 D9 11 C5 FD 54 CD C5 E5 54 C5 C5 FD 10 1D ?? ?? ?? ?? C5 FD 10 AC 24 A0 00 00 00 C5 F5 56 CB C5 DD 5C C9 C5 FD 10 A4 24 80 00 00 00 C5 FD 56 C3 C5 DD 5C D8 C4 E3 45 18 FA 01 C5 FD 10 15 ?? ?? ?? ?? C5 F5 59 E2 C5 E5 59 D2 C5 FD 10 0D ?? ?? ?? ?? C5 FD 10 1D ?? ?? ?? ?? C5 FD 11 A4 24 E0 00 00 00 C5 FD 11 94 24 00 01 00 00 C5 FD 10 94 24 C0 00 00 00 C5 F5 59 C5 C5 F5 59 E2 C5 FD 58 C3 C5 DD 58 CB C5 D5 59 DD C5 ED 59 E2 C5 FD 59 C3 C5 F5 59 CC C5 D5 58 E8 C5 ED 58 C1 C5 FD 10 0D ?? ?? ?? ?? C5 D5 58 F6 C5 FD 58 FF C5 CD 58 84 24 E0 00 00 00 C5 C5 58 B4 24 00 01 00 00 C5 FD 10 3D ?? ?? ?? ?? C5 FD 59 6C 24 40 C5 CD 59 54 24 60 C5 D5 59 E1 C5 ED 59 D9 C5 FD 11 A4 24 20 01 00 00 C5 FD 11 9C 24 40 01 00 00 C5 E5 5C CF C5 DD 5C E7 C5 FD 10 1D ?? ?? ?? ?? C5 DD 58 E3 C5 F5 58 FB C5 DD 5C CB C5 C5 5C DB C5 FD 11 A4 24 60 01 00 00 C5 FD 11 8C 24 A0 01 00 00 C5 FD 11 9C 24 C0 01 00 00 C5 F8 10 1D ?? ?? ?? ?? C5 FD 11 BC 24 80 01 00 00 C4 E3 7D 19 E8 01 C4 E3 7D 19 D6 01 C5 D0 C6 C0 DD C5 E8 C6 D6 DD C5 F8 10 35 ?? ?? ?? ?? C5 FA 6F AC 24 E0 01 00 00 C5 D1 66 CE C5 D1 76 E6 C5 FA 6F AC 24 00 02 00 00 C5 F1 EB E4 C5 D1 66 FB C5 D1 76 CB C5 C1 EB E9 C5 D9 EB CD C5 F8 10 2D ?? ?? ?? ?? C5 F8 10 25 ?? ?? ?? ?? C5 F8 54 C5 C5 F9 66 C4 C5 E8 54 D5 C5 F1 EB C8 C5 FA 6F 84 24 F0 01 00 00 C5 F9 66 FE C5 F9 76 F6 C5 C1 EB F6 C5 FA 6F BC 24 10 02 00 00 C5 C1 66 C3 C5 C1 76 DB C5 F9 EB C3 C5 C9 EB F0 C5 E9 66 C4 C5 C9 EB E0 C5 FD 10 AC 24 80 01 00 00 C5 E9 EF D2 C5 F1 6B CC C5 F1 63 DA C5 F9 10 0D ?? ?? ?? ?? C5 FD 10 A4 24 60 01 00 00 C5 F9 D7 C3 C5 D8 54 C1 C4 E3 7D 19 EE 01 C4 E3 7D 19 E7 01 C5 C8 54 D9 C5 F8 11 B4 24 40 02 00 00 C5 C0 54 D1 C5 F8 11 BC 24 20 02 00 00 C5 D9 73 D4 0B C5 FD 10 B4 24 20 01 00 00 C5 FD 10 BC 24 40 01 00 00 C5 F8 11 AC 24 30 02 00 00 C5 D0 54 E9 C5 F9 7E C1 C5 CD 5C 8C 24 A0 01 00 00 C5 C5 5C B4 24 C0 01 00 00 C5 FD 10 3D ?? ?? ?? ?? C4 E3 79 16 C2 02 C5 F5 59 CF C5 CD 59 F7 C5 FA 7E 3C CD ?? ?? ?? ?? C5 C1 16 3C D5 ?? ?? ?? ?? C5 F9 7E D1 C4 E3 79 16 D2 02 C5 FA 7E 04 CD ?? ?? ?? ?? C5 F9 7E E9 C5 F9 16 14 D5 ?? ?? ?? ?? C4 E3 79 16 EA 02 C5 FA 7E 04 CD ?? ?? ?? ?? C5 F9 7E D9 C5 F9 16 2C D5 ?? ?? ?? ?? C4 E3 79 16 DA 02 C4 E3 45 18 D2 01 C5 FA 7E 3C CD ?? ?? ?? ?? C5 C1 16 1C D5 ?? ?? ?? ?? C5 ED 59 C1 C5 FD 58 D2 C4 E3 55 18 DB 01 C5 E5 59 F6 C5 F8 10 AC 24 20 02 00 00 C5 C1 73 D5 0B C5 D1 73 F7 34 C5 CD 58 CB C5 E1 73 F4 34 C4 E3 7D 19 D0 01 C5 E9 D4 E3 C5 F9 D4 C5 C5 F8 10 94 24 30 02 00 00 C5 E1 73 D2 0B C5 F8 10 94 24 40 02 00 00 C5 C1 73 F3 34 C5 E1 73 D2 0B C4 E3 7D 19 CE 01 C4 E3 5D 18 C0 01 C5 D9 73 F3 34 C5 F1 D4 CF C5 C9 D4 F4 C5 FD 5A C0 C4 E3 75 18 CE 01 C5 FD 5A D1 C4 E3 7D 18 C2 01 84 C0 75 04 8B E5 5D C3 C5 FC 10 0C 24 C5 FC 10 54 24 20 C5 FC 11 84 24 C0 00 00 00 C5 FC 11 4C 24 40 C5 FC 11 94 24 80 00 00 00 85 C0 74 D5 33 D2 89 74 24 04 8B F2 89 3C 24 8B F8 0F A3 F7 72 18 46 83 FE 20 7C F5 8B 74 24 04 8B 3C 24 C5 FC 10 84 24 C0 00 00 00 EB AB C5 F8 77 8D 8C B4 C0 00 00 00 8D 54 B4 40 8D 84 B4 80 00 00 00 51 50 52 E8 ?? ?? ?? ?? 83 C4 0C EB C6 8D A4 24 00 00 00 00 8D 49 00 }
	condition:
		$1
}

rule file_299_0_0 {
	meta:
		name = "___common_sasin_cout_rare"
		size = 2528
		refs = "0040 __vmldASinHATab"
	strings:
		$1 = { 55 8B EC 83 E4 F8 56 57 53 83 EC 64 8B 55 08 0F B7 42 02 25 80 7F 00 00 F3 0F 10 12 3D 80 7F 00 00 0F 84 86 09 00 00 F3 0F 5A C2 F2 0F 11 44 24 40 80 64 24 47 7F F2 0F 10 4C 24 40 F2 0F 10 05 ?? ?? ?? ?? 0F B7 05 ?? ?? ?? ?? 66 0F 2F C1 0F 82 3A 09 00 00 F2 0F 10 15 ?? ?? ?? ?? 66 0F 2F D1 0F 86 00 04 00 00 66 0F 2F 0D ?? ?? ?? ?? 0F 86 54 03 00 00 F2 0F 10 15 ?? ?? ?? ?? 0F 28 D9 F2 0F 59 DA 0F 28 F1 F2 0F 11 5C 24 30 F2 0F 10 6C 24 30 F2 0F 11 0C 24 8B 4D 0C F2 0F 5C 6C 24 40 F2 0F 11 6C 24 28 F2 0F 10 44 24 30 F2 0F 10 7C 24 28 F2 0F 5C C7 F2 0F 11 44 24 30 0F 28 C1 F2 0F 10 7C 24 30 F2 0F 5C F7 F2 0F 10 3D ?? ?? ?? ?? F2 0F 11 74 24 28 F2 0F 10 6C 24 30 0F 28 F5 F2 0F 58 C5 F2 0F 59 F5 F2 0F 10 64 24 28 0F 28 DE F2 0F 59 C4 F2 0F 58 D8 F2 0F 59 FB F2 0F 11 5C 24 08 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FB F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FB F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FB F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FB F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FB F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FB F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FB F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FB F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FB F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FB 0F 28 DA F2 0F 59 DE F2 0F 58 3D ?? ?? ?? ?? F2 0F 11 5C 24 30 F2 0F 11 7C 24 10 F2 0F 10 7C 24 30 F2 0F 5C FE F2 0F 11 7C 24 28 F2 0F 10 7C 24 30 F2 0F 10 5C 24 28 F2 0F 5C FB F2 0F 11 7C 24 30 F2 0F 10 5C 24 30 F2 0F 5C F3 F2 0F 11 74 24 28 F2 0F 10 74 24 30 F2 0F 10 7C 24 28 F2 0F 59 E6 F2 0F 58 C7 F2 0F 59 EE F2 0F 59 C8 F2 0F 58 CC 0F 28 E2 F2 0F 59 E5 F2 0F 11 64 24 30 F2 0F 10 7C 24 30 F2 0F 5C FD F2 0F 11 7C 24 28 F2 0F 10 5C 24 30 F2 0F 10 64 24 28 F2 0F 5C DC 0F 28 E5 F2 0F 58 E9 F2 0F 11 5C 24 30 0F 28 DE F2 0F 10 7C 24 30 F2 0F 59 C5 F2 0F 5C E7 F2 0F 11 64 24 28 F2 0F 10 64 24 30 F2 0F 59 DC F2 0F 59 D3 F2 0F 10 7C 24 28 F2 0F 11 7C 24 18 F2 0F 58 F9 F2 0F 11 54 24 30 F2 0F 10 54 24 30 F2 0F 59 F7 F2 0F 5C D3 F2 0F 11 54 24 28 F2 0F 58 F0 F2 0F 10 44 24 30 F2 0F 10 7C 24 28 F2 0F 5C C7 0F 28 FB F2 0F 58 DE F2 0F 11 44 24 30 F2 0F 10 54 24 30 F2 0F 5C FA F2 0F 11 7C 24 28 F2 0F 10 7C 24 08 F2 0F 59 FB F2 0F 10 44 24 30 F2 0F 10 54 24 28 F2 0F 11 54 24 20 F2 0F 10 54 24 10 F2 0F 59 D7 F2 0F 10 3D ?? ?? ?? ?? F2 0F 59 FD F2 0F 10 2D ?? ?? ?? ?? F2 0F 59 EB F2 0F 10 1C 24 F2 0F 58 FD F2 0F 10 2D ?? ?? ?? ?? F2 0F 58 FA F2 0F 59 F5 F2 0F 59 C5 F2 0F 59 6C 24 20 F2 0F 10 15 ?? ?? ?? ?? F2 0F 59 CA F2 0F 59 E2 F2 0F 58 F9 F2 0F 10 4C 24 18 F2 0F 59 CA 0F 28 D3 F2 0F 58 D4 F2 0F 58 F9 F2 0F 11 54 24 30 F2 0F 10 4C 24 30 F2 0F 5C D9 F2 0F 58 DC F2 0F 11 5C 24 28 F2 0F 10 4C 24 30 F2 0F 10 64 24 28 F2 0F 58 FC F2 0F 58 FE 0F 28 F1 F2 0F 58 F0 F2 0F 58 FD F2 0F 11 74 24 30 F2 0F 10 64 24 30 F2 0F 5C CC F2 0F 58 C8 F2 0F 11 4C 24 28 F2 0F 10 4C 24 30 F2 0F 10 44 24 28 0F B6 52 03 F2 0F 58 F8 83 E2 80 F2 0F 58 F9 F2 0F 11 7C 24 38 0F B6 44 24 3F 83 E0 7F 0B C2 88 44 24 3F 33 C0 F2 0F 5A 7C 24 38 F3 0F 11 39 83 C4 64 5B 5F 5E 8B E5 5D C3 66 0F 2F 0D ?? ?? ?? ?? 72 4A 8B 4D 0C F2 0F 58 C8 F2 0F 11 4C 24 30 F2 0F 10 44 24 30 F2 0F 59 44 24 40 F2 0F 11 44 24 38 0F B6 44 24 3F 0F B6 52 03 83 E0 7F 83 E2 80 0B C2 88 44 24 3F 33 C0 F2 0F 5A 4C 24 38 F3 0F 11 09 83 C4 64 5B 5F 5E 8B E5 5D C3 F2 0F 59 C9 F2 0F 11 4C 24 30 F2 0F 10 44 24 30 0F B6 52 03 83 E2 80 F2 0F 58 44 24 40 F2 0F 11 44 24 38 0F B6 44 24 3F 83 E0 7F 0B C2 88 44 24 3F 33 C0 F2 0F 5A 4C 24 38 8B 4D 0C F3 0F 11 09 83 C4 64 5B 5F 5E 8B E5 5D C3 0F 28 D8 8B C8 81 E1 0F 80 FF FF 25 0F 80 FF FF F2 0F 11 44 24 08 F2 0F 5C D9 F2 0F 59 D3 F2 0F 11 14 24 0F B7 74 24 06 81 E6 F0 7F 00 00 C1 EE 04 81 C6 01 FC FF FF 8B FE F7 DF 81 C7 FF 03 00 00 81 E7 FF 07 00 00 C1 E7 04 0B CF 66 89 4C 24 0E 8B CE F2 0F 59 54 24 08 83 E1 01 0F 28 EA 8B D9 F2 0F 10 35 ?? ?? ?? ?? F2 0F 58 EA 75 03 0F 28 EA F2 0F 59 F5 F2 0F 58 15 ?? ?? ?? ?? 0F 28 FE 0F 28 E5 F2 0F 11 54 24 10 2B F1 8B 7C 24 10 F2 0F 5C FD C1 E3 08 81 E7 FF 01 00 00 03 FB F2 0F 11 7C 24 28 F2 0F 10 4C 24 28 D1 EE F2 0F 5C F1 F2 0F 10 0C FD ?? ?? ?? ?? 0F 28 D6 0F 28 F9 81 C6 FF 03 00 00 F2 0F 59 F9 F2 0F 5C E6 F2 0F 59 F1 F2 0F 59 D7 F2 0F 59 FC F2 0F 5C D0 81 E6 FF 07 00 00 F2 0F 58 D7 F2 0F 10 3D ?? ?? ?? ?? F2 0F 59 FA C1 E6 04 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FA 0B C6 F2 0F 11 44 24 18 66 89 44 24 1E F2 0F 10 44 24 18 F2 0F 59 F0 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FA F2 0F 11 5C 24 20 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FA F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FA F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FA F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FA F2 0F 59 F9 F2 0F 59 CC F2 0F 59 FD F2 0F 10 15 ?? ?? ?? ?? F2 0F 58 F9 0F 28 EA F2 0F 59 EE F2 0F 59 F8 F2 0F 11 6C 24 30 F2 0F 10 64 24 30 F2 0F 5C E6 F2 0F 11 64 24 28 F2 0F 10 44 24 30 F2 0F 10 4C 24 28 F2 0F 10 25 ?? ?? ?? ?? F2 0F 5C C1 F2 0F 58 25 ?? ?? ?? ?? F2 0F 11 44 24 30 F2 0F 10 05 ?? ?? ?? ?? F2 0F 59 C3 F2 0F 59 E3 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C3 F2 0F 10 6C 24 30 F2 0F 58 05 ?? ?? ?? ?? F2 0F 5C F5 F2 0F 59 C3 F2 0F 11 74 24 28 F2 0F 10 74 24 30 F2 0F 10 4C 24 28 F2 0F 11 74 24 40 F2 0F 58 F9 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C3 F2 0F 10 0D ?? ?? ?? ?? 0F 28 F1 F2 0F 58 05 ?? ?? ?? ?? F2 0F 58 35 ?? ?? ?? ?? F2 0F 59 C3 F2 0F 58 F4 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 F3 F2 0F 59 C3 F2 0F 10 2D ?? ?? ?? ?? F2 0F 58 05 ?? ?? ?? ?? F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 C3 F2 0F 58 EE F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C3 0F 28 F3 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C3 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C3 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C3 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C3 F2 0F 59 C3 F2 0F 59 C3 F2 0F 11 44 24 48 F2 0F 58 E8 0F 28 C2 F2 0F 59 C3 F2 0F 59 FD F2 0F 11 44 24 30 F2 0F 11 7C 24 50 F2 0F 10 7C 24 30 F2 0F 5C FB F2 0F 11 7C 24 28 F2 0F 10 6C 24 30 F2 0F 10 44 24 28 F2 0F 5C E8 F2 0F 11 6C 24 30 F2 0F 10 7C 24 30 F2 0F 5C F7 F2 0F 11 74 24 28 F2 0F 10 64 24 30 0F 28 EC 0F 28 C4 F2 0F 59 EC F2 0F 58 C3 F2 0F 59 E1 0F 28 DA F2 0F 59 DD F2 0F 10 7C 24 28 F2 0F 11 5C 24 30 F2 0F 10 74 24 30 F2 0F 59 CF F2 0F 5C F5 F2 0F 59 C7 F2 0F 11 74 24 28 F2 0F 10 74 24 30 F2 0F 10 5C 24 28 F2 0F 5C F3 F2 0F 11 74 24 30 F2 0F 10 5C 24 30 F2 0F 5C EB 0F 28 DC F2 0F 11 6C 24 28 F2 0F 10 74 24 30 F2 0F 59 35 ?? ?? ?? ?? F2 0F 10 6C 24 28 F2 0F 58 DE F2 0F 11 5C 24 30 F2 0F 11 6C 24 58 F2 0F 10 6C 24 30 F2 0F 11 74 24 10 F2 0F 5C E5 F2 0F 10 2D ?? ?? ?? ?? F2 0F 58 E6 F2 0F 11 64 24 28 0F 28 E5 F2 0F 10 5C 24 30 F2 0F 10 74 24 28 F2 0F 58 E3 F2 0F 11 64 24 30 F2 0F 10 64 24 30 F2 0F 5C EC F2 0F 58 EB F2 0F 11 6C 24 28 F2 0F 10 64 24 30 F2 0F 59 D4 F2 0F 10 5C 24 28 F2 0F 11 54 24 30 F2 0F 10 54 24 30 F2 0F 5C D4 F2 0F 11 54 24 28 F2 0F 10 54 24 30 F2 0F 10 6C 24 28 F2 0F 5C D5 F2 0F 11 54 24 30 F2 0F 10 6C 24 30 F2 0F 5C E5 F2 0F 11 64 24 28 F2 0F 10 6C 24 30 F2 0F 10 54 24 28 F2 0F 10 25 ?? ?? ?? ?? F2 0F 58 D6 F2 0F 58 D3 F2 0F 10 5C 24 20 F2 0F 59 E3 F2 0F 58 D1 F2 0F 58 25 ?? ?? ?? ?? F2 0F 10 4C 24 58 F2 0F 59 E3 F2 0F 58 C8 F2 0F 59 0D ?? ?? ?? ?? F2 0F 58 25 ?? ?? ?? ?? F2 0F 58 D1 F2 0F 58 64 24 48 F2 0F 10 44 24 40 F2 0F 59 D0 F2 0F 59 E0 F2 0F 59 C5 F2 0F 10 4C 24 50 F2 0F 58 CA F2 0F 10 15 ?? ?? ?? ?? 0F 28 F2 F2 0F 58 CC F2 0F 5C F0 F2 0F 11 74 24 30 F2 0F 10 7C 24 30 F2 0F 5C D7 F2 0F 5C D0 F2 0F 11 54 24 28 F2 0F 10 15 ?? ?? ?? ?? F2 0F 10 5C 24 30 F2 0F 5C D1 F2 0F 10 44 24 28 0F B6 52 03 F2 0F 58 D0 83 E2 80 F2 0F 58 DA F2 0F 11 5C 24 38 0F B6 44 24 3F 83 E0 7F 0B C2 88 44 24 3F F2 0F 5A 44 24 38 8B 45 0C F3 0F 11 00 33 C0 83 C4 64 5B 5F 5E 8B E5 5D C3 8B 45 0C F3 0F 5C D2 F3 0F 5E D2 F3 0F 11 10 B8 01 00 00 00 83 C4 64 5B 5F 5E 8B E5 5D C3 F3 0F 5E D2 8B 45 0C B9 01 00 00 00 F3 0F 11 10 33 C0 F7 02 FF FF 7F 00 0F 44 C1 83 C4 64 5B 5F 5E 8B E5 5D C3 8D A4 24 00 00 00 00 8D A4 24 00 00 00 00 }
	condition:
		$1
}

rule file_305_0_0 {
	meta:
		name = "___common_spow_cout_rare"
		size = 2960
		refs = "0174 _2il0floatpacket_112 01be __vmlsPowHATab 01d9 _2il0floatpacket_113 0376 _2il0floatpacket_114 0384 _2il0floatpacket_115 04ca _2il0floatpacket_124 061f _2il0floatpacket_116 0637 _2il0floatpacket_117 0646 _2il0floatpacket_118 0652 _2il0floatpacket_119 0787 _2il0floatpacket_120 07aa _2il0floatpacket_121 07f0 _2il0floatpacket_122 07fc _2il0floatpacket_123 0944 _2il0floatpacket_126"
	strings:
		$1 = { 56 57 53 55 83 EC 30 8B 44 24 44 66 0F EF C0 8B 54 24 48 F3 0F 10 20 F3 0F 10 1A 0F 28 CC 8B 12 0F 28 D3 8B 00 0F 2E E0 7A 02 74 06 89 44 24 08 EB 0D 0F 28 CC F3 0F 58 CC F3 0F 11 4C 24 08 0F 2E D8 7A 02 74 06 89 54 24 28 EB 0D 0F 28 D3 F3 0F 58 D3 F3 0F 11 54 24 28 0F B6 54 24 2B B8 01 00 00 00 81 E2 80 00 00 00 33 DB C1 EA 07 33 C9 F7 44 24 08 FF FF 7F 00 89 54 24 2C BA 00 00 00 00 0F B7 6C 24 2A 0F 44 D0 81 E5 80 7F 00 00 F7 44 24 28 FF FF 7F 00 0F B7 7C 24 0A 0F 44 D8 81 E7 80 7F 00 00 C1 ED 07 81 FD FF 00 00 00 0F B6 74 24 0B 0F 45 C8 81 E6 80 00 00 00 66 0F 7E D0 25 FF FF FF 7F 89 4C 24 0C C1 EF 07 C1 EE 07 8D 88 00 00 80 C0 81 F9 00 00 00 40 73 42 3D 00 00 80 4B 0F 8D 20 05 00 00 8B C8 81 E1 00 00 80 FF 81 C1 00 00 80 00 C1 E9 17 D3 E0 A9 FF FF 7F 00 75 1D 25 FF FF FF 00 B9 02 00 00 00 3D 00 00 80 00 B8 01 00 00 00 0F 44 C8 89 4C 24 10 EB 08 C7 44 24 10 00 00 00 00 85 F6 75 09 83 FF 7F 0F 84 47 0A 00 00 85 ED 75 08 85 DB 0F 85 7E 04 00 00 33 C9 B8 01 00 00 00 81 FF FF 00 00 00 0F 45 C8 89 4C 24 08 0B D1 0F 84 4C 04 00 00 0B 5C 24 0C 0F 84 42 04 00 00 0F 2E C8 7A 06 0F 84 B2 09 00 00 0F 2E 0D ?? ?? ?? ?? 7A 06 0F 84 73 09 00 00 83 7C 24 08 00 0F 84 96 03 00 00 83 7C 24 0C 00 0F 84 8B 03 00 00 0F 2F C8 77 0B 83 7C 24 10 00 0F 84 46 03 00 00 8B 44 24 10 23 C6 F3 0F 11 4C 24 08 80 64 24 0B 7F 85 FF F3 0F 10 04 85 ?? ?? ?? ?? F3 0F 11 44 24 0C 75 1B F3 0F 10 44 24 08 B9 C0 FF FF FF F3 0F 59 05 ?? ?? ?? ?? F3 0F 11 44 24 08 EB 08 F3 0F 10 44 24 08 33 C9 0F B7 5C 24 0A 81 E3 80 7F 00 00 C1 EB 07 8B 54 24 08 C1 E3 17 81 E2 FF FF 7F 00 F3 0F 11 44 24 18 0B DA 0F B7 44 24 1A 81 C3 00 00 C8 C0 25 7F 80 FF FF 0D 80 3F FF FF 66 89 44 24 1A C1 FB 17 03 D9 8B 4C 24 18 81 E1 00 00 78 00 81 C1 00 00 08 00 C1 E9 14 F3 0F 2A C3 F3 0F 10 2C CD ?? ?? ?? ?? 0F 28 D5 F3 0F 10 24 8D ?? ?? ?? ?? F3 0F 58 D0 F3 0F 10 5C 24 18 F3 0F 11 54 24 20 F3 0F 59 DC F3 0F 10 74 24 20 66 0F 7E DE F3 0F 5C C6 81 E6 00 00 1E 00 F3 0F 58 E8 81 C6 00 00 02 00 C1 EE 12 F3 0F 11 6C 24 24 F3 0F 10 54 24 20 0F 28 EA F3 0F 10 3C F5 ?? ?? ?? ?? F3 0F 10 0C B5 ?? ?? ?? ?? F3 0F 58 EF F3 0F 59 E1 F3 0F 10 44 24 24 F3 0F 11 6C 24 20 F3 0F 59 D9 F3 0F 10 6C 24 20 66 0F 7E DF F3 0F 5C D5 81 E7 00 C0 07 00 F3 0F 58 D7 81 C7 00 40 00 00 C1 EF 0F F3 0F 11 54 24 24 F3 0F 10 6C 24 20 0F 28 FD F3 0F 10 14 FD ?? ?? ?? ?? F3 0F 10 74 24 24 F3 0F 58 FA F3 0F 58 C6 F3 0F 11 7C 24 20 F3 0F 10 7C 24 20 F3 0F 10 34 BD ?? ?? ?? ?? F3 0F 5C EF F3 0F 59 E6 F3 0F 58 EA F3 0F 11 6C 24 24 F3 0F 10 6C 24 20 F3 0F 10 54 24 24 F3 0F 10 7C 24 18 F3 0F 58 C2 0F 28 CF F3 0F 58 04 CD ?? ?? ?? ?? F3 0F 59 DE F3 0F 58 04 F5 ?? ?? ?? ?? 0F 28 D3 F3 0F 58 04 FD ?? ?? ?? ?? F3 0F 5C 15 ?? ?? ?? ?? F3 0F 11 44 24 1C F3 0F 10 05 ?? ?? ?? ?? F3 0F 59 C8 F3 0F 11 4C 24 20 F3 0F 10 74 24 20 F3 0F 11 54 24 14 F3 0F 5C 74 24 18 F3 0F 11 74 24 24 F3 0F 10 74 24 20 F3 0F 10 4C 24 24 F3 0F 5C F1 F3 0F 11 74 24 20 F3 0F 10 4C 24 20 F3 0F 5C F9 F3 0F 11 7C 24 24 0F 28 FC F3 0F 59 F8 F3 0F 10 74 24 20 F3 0F 10 4C 24 24 F3 0F 11 7C 24 20 F3 0F 10 44 24 20 F3 0F 5C C4 F3 0F 11 44 24 24 F3 0F 10 7C 24 20 F3 0F 10 44 24 24 F3 0F 5C F8 F3 0F 11 7C 24 20 0F 28 FE F3 0F 10 44 24 20 F3 0F 5C E0 F3 0F 11 64 24 24 F3 0F 10 64 24 20 F3 0F 59 FC F3 0F 59 E1 F3 0F 5C FB 0F 28 DA F3 0F 58 FC F3 0F 58 DD F3 0F 10 44 24 24 F3 0F 11 5C 24 20 F3 0F 10 64 24 20 F3 0F 59 F0 F3 0F 5C EC F3 0F 59 C8 F3 0F 58 FE F3 0F 58 EA F3 0F 58 CF F3 0F 11 6C 24 24 F3 0F 10 64 24 20 F3 0F 11 64 24 10 0F B7 44 24 12 25 80 7F 00 00 C1 E8 07 03 E8 F3 0F 10 54 24 24 81 FD 09 01 00 00 F3 0F 10 44 24 1C 0F 8D 19 06 00 00 81 FD C0 00 00 00 0F 8F 67 01 00 00 C7 44 24 20 00 00 80 3F F3 0F 10 44 24 20 F3 0F 10 54 24 0C 8B 44 24 4C F3 0F 58 05 ?? ?? ?? ?? F3 0F 11 44 24 20 F3 0F 10 4C 24 20 F3 0F 59 D1 F3 0F 11 10 33 C0 83 C4 30 5D 5B 5F 5E C3 C7 44 24 20 00 00 00 00 F3 0F 10 4C 24 20 F3 0F 10 44 24 20 F3 0F 5E C8 8B 54 24 4C F3 0F 11 4C 24 20 8B 44 24 20 89 02 B8 01 00 00 00 83 C4 30 5D 5B 5F 5E C3 83 FF 7F 7D 31 83 7C 24 2C 00 74 16 F3 0F 59 D2 8B 44 24 4C F3 0F 11 10 33 C0 83 C4 30 5D 5B 5F 5E C3 8B 44 24 4C C7 00 00 00 00 00 33 C0 83 C4 30 5D 5B 5F 5E C3 83 7C 24 2C 00 74 21 8B 44 24 10 23 C6 8B 4C 24 4C 8B 14 85 ?? ?? ?? ?? 33 C0 89 54 24 18 89 11 83 C4 30 5D 5B 5F 5E C3 F3 0F 59 C9 8B 44 24 10 F3 0F 59 D1 23 C6 F3 0F 59 14 85 ?? ?? ?? ?? 33 C0 8B 54 24 4C F3 0F 11 12 83 C4 30 5D 5B 5F 5E C3 8B 44 24 4C F3 0F 58 E3 F3 0F 11 20 33 C0 83 C4 30 5D 5B 5F 5E C3 8B 54 24 4C F3 0F 58 CA F3 0F 11 4C 24 20 C7 44 24 24 00 00 80 3F 0F B6 6C 24 23 0F B6 44 24 27 83 E5 80 83 E0 7F 0B C5 88 44 24 27 33 C0 F3 0F 10 4C 24 24 F3 0F 10 44 24 24 F3 0F 59 C8 F3 0F 11 0A 83 C4 30 5D 5B 5F 5E C3 C7 44 24 10 02 00 00 00 E9 12 FB FF FF F3 0F 10 5C 24 14 F3 0F 10 3D ?? ?? ?? ?? F3 0F 58 D9 F3 0F 58 CA F3 0F 59 FB F3 0F 58 C1 F3 0F 58 3D ?? ?? ?? ?? F3 0F 59 FB 0F 28 D0 F3 0F 58 3D ?? ?? ?? ?? F3 0F 59 FB F3 0F 58 3D ?? ?? ?? ?? F3 0F 59 FB F3 0F 58 E7 F3 0F 11 64 24 20 F3 0F 10 4C 24 20 F3 0F 10 64 24 10 F3 0F 5C E1 F3 0F 58 E7 F3 0F 11 64 24 24 F3 0F 10 74 24 20 F3 0F 10 4C 24 24 F3 0F 58 D6 F3 0F 11 54 24 20 F3 0F 10 6C 24 20 F3 0F 10 54 24 28 F3 0F 5C F5 F3 0F 58 F0 F3 0F 11 74 24 24 F3 0F 10 35 ?? ?? ?? ?? F3 0F 10 6C 24 20 0F 28 C6 F3 0F 59 C5 F3 0F 59 F2 F3 0F 10 7C 24 24 F3 0F 11 44 24 20 F3 0F 58 F9 F3 0F 10 4C 24 20 F3 0F 59 7C 24 28 F3 0F 5C CD F3 0F 11 4C 24 24 F3 0F 10 5C 24 20 F3 0F 10 44 24 24 F3 0F 5C D8 F3 0F 11 5C 24 20 F3 0F 10 64 24 20 F3 0F 5C EC F3 0F 11 6C 24 24 F3 0F 10 5C 24 20 F3 0F 10 64 24 24 F3 0F 11 74 24 20 F3 0F 10 6C 24 20 F3 0F 5C 6C 24 28 F3 0F 11 6C 24 24 F3 0F 10 4C 24 20 F3 0F 10 44 24 24 F3 0F 5C C8 F3 0F 11 4C 24 20 F3 0F 10 6C 24 20 F3 0F 5C D5 F3 0F 11 54 24 24 F3 0F 10 54 24 20 F3 0F 10 6C 24 24 0F 28 C2 0F 28 CD F3 0F 59 CC F3 0F 59 D4 F3 0F 59 C3 F3 0F 59 DD F3 0F 58 CA F3 0F 10 15 ?? ?? ?? ?? F3 0F 58 CB 0F 28 D8 F3 0F 58 F9 F3 0F 58 DA F3 0F 11 5C 24 20 F3 0F 10 64 24 20 F3 0F 10 0D ?? ?? ?? ?? F3 0F 5C E2 F3 0F 11 24 24 F3 0F 10 34 24 8B 54 24 20 8B C2 83 E2 7F F3 0F 5C C6 F3 0F 11 44 24 04 F3 0F 10 44 24 04 C1 E0 0A F3 0F 58 F8 F3 0F 59 CF F3 0F 10 04 D5 ?? ?? ?? ?? C1 F8 11 F3 0F 58 0D ?? ?? ?? ?? F3 0F 59 CF F3 0F 58 0D ?? ?? ?? ?? F3 0F 59 CF F3 0F 59 C8 F3 0F 58 0C D5 ?? ?? ?? ?? 0F 28 D1 F3 0F 58 D0 F3 0F 11 54 24 18 0F B7 4C 24 1A 8B D1 81 E2 80 7F 00 00 C1 EA 07 83 C2 81 03 D0 81 FA 80 00 00 00 0F 8D 36 02 00 00 83 FA 82 7C 3A 83 C2 7F 81 E1 7F 80 FF FF 0F B6 D2 C1 E2 07 0B CA 66 89 4C 24 1A F3 0F 10 44 24 18 F3 0F 59 44 24 0C 8B 44 24 4C F3 0F 11 44 24 18 F3 0F 11 00 33 C0 83 C4 30 5D 5B 5F 5E C3 81 FA 78 FF FF FF 0F 8C 1E 01 00 00 F3 0F 11 54 24 20 83 C0 40 F3 0F 10 54 24 20 BA 00 00 80 3F F3 0F 10 1D ?? ?? ?? ?? 83 C0 7F 89 54 24 08 F3 0F 5C C2 C1 EA 10 F3 0F 58 C1 F3 0F 11 44 24 24 F3 0F 10 44 24 20 F3 0F 59 D8 F3 0F 10 4C 24 24 F3 0F 11 5C 24 20 F3 0F 10 64 24 20 0F B7 CA F3 0F 5C E0 F3 0F 11 64 24 24 81 E1 7F 80 FF FF F3 0F 10 74 24 20 F3 0F 10 6C 24 24 0F B6 C0 F3 0F 5C F5 F3 0F 11 74 24 20 F3 0F 10 7C 24 20 C1 E0 07 F3 0F 5C C7 F3 0F 11 44 24 24 0B C8 F3 0F 10 44 24 20 33 C0 F3 0F 10 54 24 24 66 89 4C 24 0A F3 0F 58 CA F3 0F 10 5C 24 08 F3 0F 59 CB F3 0F 59 C3 F3 0F 10 25 ?? ?? ?? ?? F3 0F 59 CC F3 0F 59 C4 F3 0F 11 4C 24 20 F3 0F 10 4C 24 20 C7 44 24 20 00 00 80 00 F3 0F 58 C1 F3 0F 10 74 24 20 F3 0F 10 6C 24 20 F3 0F 59 F5 F3 0F 11 74 24 20 F3 0F 10 7C 24 20 F3 0F 10 4C 24 0C F3 0F 58 C7 F3 0F 59 C8 8B 5C 24 4C F3 0F 11 44 24 18 F3 0F 11 0B 83 C4 30 5D 5B 5F 5E C3 81 FA 61 FF FF FF 7C 7F BA 00 00 80 3F 05 BF 00 00 00 89 54 24 08 C1 EA 10 0F B7 CA 0F B6 C0 81 E1 7F 80 FF FF C1 E0 07 0B C8 33 C0 F3 0F 10 5C 24 0C 66 89 4C 24 0A F3 0F 59 1D ?? ?? ?? ?? F3 0F 59 54 24 08 C7 44 24 20 00 00 80 00 F3 0F 59 DA F3 0F 10 54 24 20 F3 0F 10 44 24 20 F3 0F 59 C2 F3 0F 11 44 24 20 F3 0F 10 4C 24 20 8B 5C 24 4C F3 0F 58 D9 F3 0F 11 5C 24 18 F3 0F 11 1B 83 C4 30 5D 5B 5F 5E C3 C7 44 24 20 00 00 80 00 F3 0F 10 44 24 20 F3 0F 10 4C 24 20 F3 0F 59 C8 F3 0F 11 4C 24 20 F3 0F 10 54 24 20 F3 0F 10 5C 24 0C F3 0F 59 DA 8B 44 24 4C F3 0F 11 5C 24 18 F3 0F 11 18 33 C0 83 C4 30 5D 5B 5F 5E C3 C7 44 24 20 00 00 00 7F F3 0F 10 4C 24 20 F3 0F 10 44 24 20 F3 0F 59 C8 F3 0F 11 4C 24 20 F3 0F 10 54 24 20 F3 0F 10 5C 24 0C F3 0F 59 DA 8B 44 24 4C F3 0F 11 5C 24 18 F3 0F 11 18 33 C0 83 C4 30 5D 5B 5F 5E C3 0F B6 44 24 13 25 80 00 00 00 C1 E8 07 8B 54 24 2C 33 D0 33 C0 8B 4C 24 4C F3 0F 10 04 95 ?? ?? ?? ?? F3 0F 59 C0 F3 0F 59 44 24 0C F3 0F 11 01 83 C4 30 5D 5B 5F 5E C3 83 7C 24 10 00 75 0B 83 7C 24 0C 00 0F 85 7B F6 FF FF 8B 44 24 10 83 E0 01 8B 4C 24 4C 8B 14 85 ?? ?? ?? ?? 33 C0 89 11 83 C4 30 5D 5B 5F 5E C3 F3 0F 59 C9 83 7C 24 2C 00 74 28 8B 44 24 10 23 C6 8B 54 24 4C F3 0F 10 04 85 ?? ?? ?? ?? B8 01 00 00 00 F3 0F 5E C1 F3 0F 11 02 83 C4 30 5D 5B 5F 5E C3 8B 44 24 10 23 C6 8B 54 24 4C F3 0F 10 04 85 ?? ?? ?? ?? 33 C0 F3 0F 59 C1 F3 0F 11 02 83 C4 30 5D 5B 5F 5E C3 85 D2 0F 84 B1 F5 FF FF E9 36 FA FF FF 8D A4 24 00 00 00 00 90 }
	condition:
		$1
}

rule file_308_1_0 {
	meta:
		name = "??_L@YGXPAXIIP6EX0@Z1@Z"
		size = 184
		refs = "0006 __sehtable$??_L@YGXPAXIIP6EX0@Z1@Z 000b __except_handler4 001d ___security_cookie 005f @_guard_check_icall@4 009f ?__ArrayUnwind@@YGXPAXIIP6EX0@Z@Z"
	strings:
		$1 = { 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 EC 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 C7 45 E0 00 00 00 00 C6 45 E7 00 C7 45 FC 00 00 00 00 EB 09 8B 45 E0 83 C0 01 89 45 E0 8B 4D E0 3B 4D 10 74 1F 8B 55 14 89 55 DC 8B 4D DC E8 ?? ?? ?? ?? 8B 4D 08 FF 55 DC 8B 45 08 03 45 0C 89 45 08 EB D0 C6 45 E7 01 C7 45 FC FE FF FF FF E8 02 00 00 00 EB 1E 0F B6 4D E7 85 C9 75 15 8B 55 18 52 8B 45 E0 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? C3 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C2 14 00 }
	condition:
		$1
}

rule file_310_0_0 {
	meta:
		name = "@_RTC_Check_2_to_1@4"
		size = 41
		refs = "001d ?_RTC_Failure@@YAXPAXH@Z"
	strings:
		$1 = { 55 8B EC 53 8B D9 8B C3 25 00 FF 00 00 74 15 3D 00 FF 00 00 74 0E 8B 45 04 6A 01 50 E8 ?? ?? ?? ?? 83 C4 08 8A C3 5B 5D C3 }
	condition:
		$1
}

rule file_310_1_0 {
	meta:
		name = "@_RTC_Check_4_to_1@4"
		size = 41
		refs = "001d ?_RTC_Failure@@YAXPAXH@Z"
	strings:
		$1 = { 55 8B EC 53 8B D9 8B C3 25 00 FF FF FF 74 15 3D 00 FF FF FF 74 0E 8B 45 04 6A 01 50 E8 ?? ?? ?? ?? 83 C4 08 8A C3 5B 5D C3 }
	condition:
		$1
}

rule file_310_2_0 {
	meta:
		name = "@_RTC_Check_4_to_2@4"
		size = 42
		refs = "001d ?_RTC_Failure@@YAXPAXH@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 8B C6 25 00 00 FF FF 74 15 3D 00 00 FF FF 74 0E 8B 45 04 6A 01 50 E8 ?? ?? ?? ?? 83 C4 08 66 8B C6 5E 5D C3 }
	condition:
		$1
}

rule file_310_3_0 {
	meta:
		name = "@_RTC_Check_8_to_1@8"
		size = 56
		refs = "002a ?_RTC_Failure@@YAXPAXH@Z"
	strings:
		$1 = { 55 8B EC 8B 55 0C 53 8B 5D 08 8B C3 25 00 FF FF FF 8B C8 0B CA 74 1A 3D 00 FF FF FF 75 05 83 FA FF 74 0E 8B 45 04 6A 01 50 E8 ?? ?? ?? ?? 83 C4 08 8A C3 5B 5D C2 08 00 }
	condition:
		$1
}

rule file_310_4_0 {
	meta:
		name = "@_RTC_Check_8_to_2@8"
		size = 57
		refs = "002a ?_RTC_Failure@@YAXPAXH@Z"
	strings:
		$1 = { 55 8B EC 8B 55 0C 56 8B 75 08 8B C6 25 00 00 FF FF 8B C8 0B CA 74 1A 3D 00 00 FF FF 75 05 83 FA FF 74 0E 8B 45 04 6A 01 50 E8 ?? ?? ?? ?? 83 C4 08 66 8B C6 5E 5D C2 08 00 }
	condition:
		$1
}

rule file_310_5_0 {
	meta:
		name = "@_RTC_Check_8_to_4@8"
		size = 44
		refs = "001e ?_RTC_Failure@@YAXPAXH@Z"
	strings:
		$1 = { 55 8B EC 8B 4D 0C 33 D2 8B C2 0B C1 74 17 85 D2 75 05 83 F9 FF 74 0E 8B 45 04 6A 01 50 E8 ?? ?? ?? ?? 83 C4 08 8B 45 08 5D C2 08 00 }
	condition:
		$1
}

rule file_311_0_0 {
	meta:
		name = "___avx_cosh4"
		size = 528
		refs = "0010 ___common_dcosh_data 0206 ___common_dcosh_cout_rare"
	strings:
		$1 = { 55 8B EC 83 E4 C0 81 EC C0 00 00 00 C5 FD 10 1D ?? ?? ?? ?? C5 FD 10 15 ?? ?? ?? ?? C5 FD 11 04 24 C5 FD 11 54 24 20 C5 E5 55 E8 C5 D5 59 35 ?? ?? ?? ?? C5 CD 58 74 24 20 C5 C1 73 D3 0B C4 E3 7D 19 D9 01 C5 D9 73 D1 0B C5 FA 7F 64 24 50 C5 FA 7F 7C 24 40 C5 F8 10 0D ?? ?? ?? ?? C4 E3 7D 19 EA 01 C4 E3 7D 19 F4 01 C5 D0 C6 DA DD C5 C8 C6 C4 88 C5 D9 73 F4 2C C5 E1 66 3D ?? ?? ?? ?? C5 F9 DB 15 ?? ?? ?? ?? C5 F8 50 C7 C5 C1 72 F2 03 C5 F9 7E FA C5 F1 FA DA C5 E1 72 F3 03 C4 E3 79 16 F9 01 C5 FB 10 82 ?? ?? ?? ?? C4 E3 79 16 FA 02 C5 F9 16 91 ?? ?? ?? ?? C4 E3 79 16 F9 03 C5 FB 10 8A ?? ?? ?? ?? C5 F9 7E DA C5 F1 16 89 ?? ?? ?? ?? C4 E3 79 16 D9 01 C5 FB 10 BA ?? ?? ?? ?? C4 E3 79 16 DA 02 C5 C1 16 B9 ?? ?? ?? ?? C4 E3 79 16 D9 03 C5 FB 10 82 ?? ?? ?? ?? C5 F9 11 7C 24 60 C5 F9 16 99 ?? ?? ?? ?? C5 CD 5C 44 24 20 C5 FD 59 3D ?? ?? ?? ?? C5 D5 5C EF C5 FD 59 3D ?? ?? ?? ?? C5 D5 5C C7 C5 C1 73 F6 2C C5 F9 10 35 ?? ?? ?? ?? C5 C1 DB FE C5 D9 DB E6 C5 E9 D4 F7 C5 E1 FB DC C5 F1 D4 CC C5 E1 FB 64 24 50 C5 FD 59 E8 C5 F9 10 54 24 60 C5 E9 FB FF C5 C1 FB 7C 24 40 C4 E3 4D 18 C9 01 C4 E3 45 18 DC 01 C5 F5 5C FB C5 F5 58 DB C5 D5 59 0D ?? ?? ?? ?? C5 F5 59 D0 C5 ED 58 C0 C5 FD 59 D7 C5 D5 59 05 ?? ?? ?? ?? C5 FD 58 0D ?? ?? ?? ?? C5 F5 59 ED C5 D5 59 C3 C5 FD 58 CA C5 F5 58 C3 85 C0 75 04 8B E5 5D C3 C5 FD 10 0C 24 C5 FD 11 84 24 80 00 00 00 C5 FD 11 4C 24 40 74 E6 33 D2 89 74 24 04 8B F2 89 3C 24 8B F8 0F A3 F7 72 18 46 83 FE 20 7C F5 8B 74 24 04 8B 3C 24 C5 FD 10 84 24 80 00 00 00 EB BC C5 F8 77 8D 8C F4 80 00 00 00 8D 44 F4 40 51 50 E8 ?? ?? ?? ?? 83 C4 08 EB CE 90 }
	condition:
		$1
}

rule file_312_0_0 {
	meta:
		name = "___security_init_cookie"
		size = 221
		refs = "0016 ___security_cookie 0036 ___security_cookie_complement 0045 __imp__GetSystemTimeAsFileTime@4 005a __imp__GetCurrentThreadId@0 0066 __imp__GetCurrentProcessId@0 0076 __imp__QueryPerformanceCounter@4"
	strings:
		$1 = { 55 8B EC 83 EC 14 C7 45 F4 00 00 00 00 C7 45 F8 00 00 00 00 81 3D ?? ?? ?? ?? 4E E6 40 BB 74 1F A1 ?? ?? ?? ?? 25 00 00 FF FF 74 13 8B 0D ?? ?? ?? ?? F7 D1 89 0D ?? ?? ?? ?? E9 9A 00 00 00 8D 55 F4 52 FF 15 ?? ?? ?? ?? 8B 45 F4 89 45 FC 8B 4D FC 33 4D F8 89 4D FC FF 15 ?? ?? ?? ?? 33 45 FC 89 45 FC FF 15 ?? ?? ?? ?? 33 45 FC 89 45 FC 8D 55 EC 52 FF 15 ?? ?? ?? ?? 8B 45 FC 33 45 EC 89 45 FC 8B 4D FC 33 4D F0 89 4D FC 8B 55 FC 8D 45 FC 33 D0 89 55 FC 81 7D FC 4E E6 40 BB 75 09 C7 45 FC 4F E6 40 BB EB 1D 8B 4D FC 81 E1 00 00 FF FF 75 12 8B 55 FC 81 CA 11 47 00 00 C1 E2 10 0B 55 FC 89 55 FC 8B 45 FC A3 ?? ?? ?? ?? 8B 4D FC F7 D1 89 0D ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_313_0_0 {
	meta:
		name = "___sse2_atanf4"
		size = 208
		refs = "0012 _static_const_table"
	strings:
		$1 = { 8B C4 81 EC 90 00 00 00 83 E4 F0 89 44 24 54 0F 28 25 ?? ?? ?? ?? 0F 28 DC 0F 55 D8 0F 54 E0 0F 28 3D ?? ?? ?? ?? 0F 28 35 ?? ?? ?? ?? 0F C2 FC 01 0F 28 EF 0F 54 F7 0F 55 FC 0F 56 F7 0F 28 FD 0F 54 E5 0F 55 2D ?? ?? ?? ?? 0F 56 E5 0F 5E F4 0F 28 0D ?? ?? ?? ?? 0F 54 F9 0F 28 CE 0F 59 CE 0F 28 D1 0F 59 D1 0F 28 25 ?? ?? ?? ?? 0F 59 E2 0F 28 05 ?? ?? ?? ?? 0F 59 C2 0F 58 25 ?? ?? ?? ?? 0F 58 05 ?? ?? ?? ?? 0F 59 E2 0F 59 C2 0F 58 25 ?? ?? ?? ?? 0F 58 05 ?? ?? ?? ?? 0F 59 E2 0F 59 C2 0F 58 25 ?? ?? ?? ?? 0F 58 05 ?? ?? ?? ?? 0F 59 E2 0F 59 C1 0F 58 25 ?? ?? ?? ?? 0F 58 C4 0F 59 C6 0F 58 C7 0F 56 C3 8B 64 24 54 C3 8B FF }
	condition:
		$1
}

rule file_315_0_0 {
	meta:
		name = "?GetPdbDll@@YAPAUHINSTANCE__@@XZ"
		size = 320
		refs = "000a ___security_cookie 0015 ?alreadyTried@?1??GetPdbDll@@YAPAUHINSTANCE__@@XZ@4_NA 0028 ?GetPdbDllFromInstallPath@@YAPAUHINSTANCE__@@XZ 0035 ?debugCrtFileName@@3QB_WB 003a ___vcrt_GetModuleHandleW 0053 ___vcrt_GetModuleFileNameW 0072 ?GetPdbDllPathFromFilePath@@YAHPB_WPA_WI@Z 008c ___vcrt_LoadLibraryExW 009d __imp__GetLastError@0 00c5 ??_C@_1BC@JINFINNJ@?$AAM?$AAS?$AAP?$AAD?$AAB?$AA1?$AA4?$AA0?$AA?$AA@ 0138 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 81 EC 14 04 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 80 3D ?? ?? ?? ?? 00 0F 85 10 01 00 00 C6 05 ?? ?? ?? ?? 01 E8 ?? ?? ?? ?? 85 C0 0F 85 FE 00 00 00 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 78 68 04 01 00 00 8D 8D EC FB FF FF 51 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 5F 68 04 01 00 00 8D 85 F4 FD FF FF 50 8D 85 EC FB FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 40 68 00 09 00 00 8D 85 F4 FD FF FF 6A 00 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 85 97 00 00 00 FF 15 ?? ?? ?? ?? 83 F8 57 75 17 6A 08 8D 85 F4 FD FF FF 6A 00 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 75 68 00 0A 00 00 6A 00 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 5D FF 15 ?? ?? ?? ?? 83 F8 57 75 50 68 04 01 00 00 8D 85 EC FB FF FF 50 6A 00 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 36 68 04 01 00 00 8D 85 F4 FD FF FF 50 8D 85 EC FB FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 17 6A 08 8D 85 F4 FD FF FF 6A 00 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 02 33 C0 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_315_1_0 {
	meta:
		name = "?GetPdbDllFromInstallPath@@YAPAUHINSTANCE__@@XZ"
		size = 628
		refs = "000a ___security_cookie 001c ??_C@_1EI@MLPKHBGE@?$AAa?$AAp?$AAi?$AA?9?$AAm?$AAs?$AA?9?$AAw?$AAi?$AAn?$AA?9?$AAc?$AAo?$AAr?$AAe?$AA?9?$AAr?$AAe?$AAg?$AAi?$AAs?$AAt?$AAr?$AAy?$AA?9?$AAl?$AA1?$AA?9?$AA1?$AA?9?$AA0?$AA?4@ 0021 ___vcrt_LoadLibraryExW 0035 ??_C@_1BK@JHLNAEJL@?$AAa?$AAd?$AAv?$AAa?$AAp?$AAi?$AA3?$AA2?$AA?4?$AAd?$AAl?$AAl?$AA?$AA@ 0049 __imp__GetLastError@0 0070 @__security_check_cookie@4 007a ??_C@_0O@COHOBMLB@RegOpenKeyExW?$AA@ 0081 __imp__GetProcAddress@8 009d ??_C@_0BB@GLNAEDBD@RegQueryValueExW?$AA@ 00af ??_C@_0M@HLOHPNFA@RegCloseKey?$AA@ 00d2 ??_C@_1HE@EBEAGLFB@?$AAS?$AAO?$AAF?$AAT?$AAW?$AAA?$AAR?$AAE?$AA?2?$AAW?$AAo?$AAw?$AA6?$AA4?$AA3?$AA2?$AAN?$AAo?$AAd?$AAe?$AA?2?$AAM?$AAi?$AAc?$AAr?$AAo?$AAs?$AAo?$AAf?$AAt?$AA?2?$AAV@ 00dc @_guard_check_icall@4 00e9 __imp__FreeLibrary@4 0124 ??_C@_1BG@EABPBLLF@?$AAP?$AAr?$AAo?$AAd?$AAu?$AAc?$AAt?$AAD?$AAi?$AAr?$AA?$AA@ 01b9 ?mspdbName@@3QB_WB"
	strings:
		$1 = { 55 8B EC 81 EC 1C 02 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 57 68 00 08 00 00 6A 00 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F8 83 C4 0C 85 FF 75 4A 68 00 08 00 00 50 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F8 83 C4 0C 85 FF 75 31 FF 15 ?? ?? ?? ?? 83 F8 57 75 15 57 57 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F8 83 C4 0C 85 FF 75 11 33 C0 5F 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 56 68 ?? ?? ?? ?? 57 FF 15 ?? ?? ?? ?? 8B F0 85 F6 75 10 5E 5F 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 53 68 ?? ?? ?? ?? 57 FF 15 ?? ?? ?? ?? 8B D8 85 DB 74 3F 68 ?? ?? ?? ?? 57 FF 15 ?? ?? ?? ?? 89 85 E8 FD FF FF 85 C0 74 29 8D 85 F0 FD FF FF 8B CE 50 6A 01 6A 00 68 ?? ?? ?? ?? 68 02 00 00 80 E8 ?? ?? ?? ?? FF D6 85 C0 74 1A 57 FF 15 ?? ?? ?? ?? 5B 5E 33 C0 5F 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 8D 85 EC FD FF FF C7 85 EC FD FF FF 08 02 00 00 50 8D 85 F4 FD FF FF 8B CB 50 8D 85 E4 FD FF FF 50 6A 00 68 ?? ?? ?? ?? FF B5 F0 FD FF FF E8 ?? ?? ?? ?? FF D3 FF B5 F0 FD FF FF 8B 9D E8 FD FF FF 8B F0 8B CB E8 ?? ?? ?? ?? FF D3 57 FF 15 ?? ?? ?? ?? 85 F6 75 96 83 BD E4 FD FF FF 01 75 8D 8B 8D EC FD FF FF F6 C1 01 75 82 D1 E9 8B D1 83 F9 02 0F 82 75 FF FF FF 49 8D 85 F4 FD FF FF 66 39 34 48 8D 04 48 0F 85 61 FF FF FF 66 83 78 FE 5C 74 0A B9 5C 00 00 00 66 89 08 8B CA 8B C1 F7 D0 83 F8 12 0F 82 43 FF FF FF 8D 41 11 3D 04 01 00 00 0F 87 35 FF FF FF A1 ?? ?? ?? ?? 89 84 4D F4 FD FF FF A1 ?? ?? ?? ?? 89 84 4D F8 FD FF FF A1 ?? ?? ?? ?? 89 84 4D FC FD FF FF A1 ?? ?? ?? ?? 89 84 4D 00 FE FF FF A1 ?? ?? ?? ?? 89 84 4D 04 FE FF FF A1 ?? ?? ?? ?? 89 84 4D 08 FE FF FF A1 ?? ?? ?? ?? 89 84 4D 0C FE FF FF A1 ?? ?? ?? ?? 89 84 4D 10 FE FF FF 66 A1 ?? ?? ?? ?? 68 00 09 00 00 66 89 84 4D 14 FE FF FF 8D 85 F4 FD FF FF 6A 00 50 E8 ?? ?? ?? ?? 8B F0 83 C4 0C 85 F6 75 1F FF 15 ?? ?? ?? ?? 83 F8 57 75 14 6A 08 8D 85 F4 FD FF FF 56 50 E8 ?? ?? ?? ?? 83 C4 0C 8B F0 8B 4D FC 8B C6 5B 5E 33 CD 5F E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_315_2_0 {
	meta:
		name = "?GetPdbDllPathFromFilePath@@YAHPB_WPA_WI@Z"
		size = 207
		refs = "000a ___security_cookie 0046 __wsplitpath_s 005a @__security_check_cookie@4 0063 ?mspdbFilename@?1??GetPdbDllPathFromFilePath@@YAHPB_WPA_WI@Z@4QB_WB 0071 _wcscpy_s 007d ?dllExt@?1??GetPdbDllPathFromFilePath@@YAHPB_WPA_WI@Z@4QB_WB 00b4 __wmakepath_s"
	strings:
		$1 = { 55 8B EC 81 EC 0C 06 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 8D 8D F4 FD FF FF 56 8B 75 0C 68 00 01 00 00 51 68 00 01 00 00 8D 8D F4 FB FF FF 51 68 00 01 00 00 8D 8D F4 F9 FF FF 51 6A 03 8D 4D F4 51 50 E8 ?? ?? ?? ?? 83 C4 24 85 C0 74 11 33 C0 5E 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 68 ?? ?? ?? ?? 8D 85 F4 FB FF FF 6A 09 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 D5 68 ?? ?? ?? ?? 8D 85 F4 FD FF FF 6A 04 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 BB 8D 85 F4 FD FF FF 50 8D 85 F4 FB FF FF 50 8D 85 F4 F9 FF FF 50 8D 45 F4 50 FF 75 10 56 E8 ?? ?? ?? ?? 8B 4D FC 83 C4 18 F7 D8 1B C0 33 CD 40 5E E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_315_3_0 {
	meta:
		name = "?_RTC_GetSrcLine@@YAHPAEPA_WKPAH1K@Z"
		size = 850
		refs = "0025 __imp__VirtualQuery@12 003e ___vcrt_GetModuleFileNameW 00a0 ?PDBOK@?1??_RTC_GetSrcLine@@YAHPAEPA_WKPAH1K@Z@4_NA 00ac ?mspdb@@3PAUHINSTANCE__@@A 00b4 ?GetPdbDll@@YAPAUHINSTANCE__@@XZ 00d0 ??_C@_0BB@KCIACLNC@PDBOpenValidate5?$AA@ 00d7 __imp__GetProcAddress@8 00f9 @_guard_check_icall@4 013b ??_C@_01KDCPPGHE@r?$AA@ 0232 __imp__GetProcessHeap@0 0239 __imp__HeapFree@12 02af __imp__HeapAlloc@12"
	strings:
		$1 = { 55 8B EC 8B 45 14 83 EC 4C 33 C9 C7 00 00 00 00 00 8B 45 0C 56 8B 75 08 6A 1C 66 89 08 4E 8D 45 B4 50 56 FF 15 ?? ?? ?? ?? 85 C0 75 07 33 C0 5E 8B E5 5D C3 FF 75 1C FF 75 18 FF 75 B8 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 E4 8B 4D B8 B8 4D 5A 00 00 66 39 01 75 D7 8B 41 3C 85 C0 7E D0 81 3C 08 50 45 00 00 8D 14 08 75 C4 0F B7 42 14 2B F1 53 57 0F B7 7A 06 33 DB 03 D0 33 C0 85 FF 74 1A 8D 4A 24 8B 11 3B F2 72 09 8B DE 2B DA 3B 71 FC 72 08 40 83 C1 28 3B C7 72 E9 3B C7 74 69 40 80 3D ?? ?? ?? ?? 00 89 45 F4 75 20 83 3D ?? ?? ?? ?? 00 75 53 E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? 85 C0 74 45 C6 05 ?? ?? ?? ?? 01 EB 05 A1 ?? ?? ?? ?? 68 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 8B F0 85 F6 74 25 8D 45 E8 8B CE 50 6A 00 6A 00 8D 45 D0 50 6A 00 6A 00 6A 00 FF 75 18 E8 ?? ?? ?? ?? FF D6 83 C4 20 85 C0 75 09 5F 5B 33 C0 5E 8B E5 5D C3 8B 7D E8 C7 45 DC 00 00 00 00 8B 07 8B 30 8B CE E8 ?? ?? ?? ?? 8B CF FF D6 3D 41 91 32 01 0F 85 42 01 00 00 8B 7D E8 8D 4D E0 51 68 ?? ?? ?? ?? 6A 00 8B 07 8B 70 1C 8B CE E8 ?? ?? ?? ?? 8B CF FF D6 85 C0 0F 84 1C 01 00 00 8B 7D E0 8D 45 EC 6A 00 6A 00 6A 00 8B 37 50 53 FF 75 F4 8B 76 20 8B CE E8 ?? ?? ?? ?? 8B CF FF D6 85 C0 0F 84 E0 00 00 00 8B 7D EC 8D 4D F8 C7 45 F8 00 00 00 00 51 8B 07 8B 70 68 8B CE E8 ?? ?? ?? ?? 8B CF FF D6 84 C0 0F 84 A7 00 00 00 8B 45 F8 85 C0 0F 84 9C 00 00 00 8B 00 33 FF 8B 70 08 8B CE E8 ?? ?? ?? ?? 8B 4D F8 FF D6 85 C0 74 63 8D 9B 00 00 00 00 8B 7D F8 8D 45 F0 6A 00 50 8D 45 D8 8B 37 50 8D 45 FC 50 8B 76 0C 8D 45 E4 50 6A 00 8B CE E8 ?? ?? ?? ?? 8B CF FF D6 84 C0 74 42 0F B7 45 FC 3B 45 F4 75 10 8B 4D E4 3B CB 77 09 8B 45 D8 03 C1 3B D8 72 7E 8B 7D F8 8B 07 8B 70 08 8B CE E8 ?? ?? ?? ?? 8B CF FF D6 85 C0 75 A5 33 FF 57 6A 00 FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 8B 7D F8 8B 07 8B 30 8B CE E8 ?? ?? ?? ?? 8B CF FF D6 8B 7D EC 8B 07 8B 70 40 8B CE E8 ?? ?? ?? ?? 8B CF FF D6 8B 7D E0 8B 07 8B 70 38 8B CE E8 ?? ?? ?? ?? 8B CF FF D6 8B 7D E8 8B 17 8B 72 2C 8B CE E8 ?? ?? ?? ?? 8B CF FF D6 8B 45 DC 5F 5B 5E 8B E5 5D C3 8B 45 F0 85 C0 74 A4 3D FF FF FF 1F 73 9D C1 E0 03 50 6A 00 FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 89 45 F4 85 C0 74 83 8B 7D F8 50 8D 45 F0 50 8B 37 8D 45 D4 6A 00 6A 00 6A 00 8B 76 0C 8B CE 50 E8 ?? ?? ?? ?? 8B CF FF D6 8B 7D F4 84 C0 0F 84 46 FF FF FF 2B 5D E4 3B 1F 0F 82 3B FF FF FF 8B 4D F0 B8 01 00 00 00 3B C8 76 0C 8B FF 3B 1C C7 72 05 40 3B C1 72 F6 8B 44 C7 FC 8B 4D 14 25 FF FF FF 00 8B 7D EC 6A 00 6A 00 89 01 8D 45 10 8B 37 6A 00 50 FF 75 0C 8B 76 70 8B CE FF 75 D4 E8 ?? ?? ?? ?? 8B CF FF D6 8B 7D F4 84 C0 0F 84 E7 FE FF FF C7 45 DC 01 00 00 00 E9 DB FE FF FF }
	condition:
		$1
}

rule file_318_0_0 {
	meta:
		name = "___dyn_tls_dtor@12"
		size = 200
		refs = "001f __tls_index 0026 __tls_array 002f _dtor_list 007e @_guard_check_icall@4 009d __free_dbg"
	strings:
		$1 = { 55 8B EC 83 EC 10 83 7D 0C 03 74 0B 83 7D 0C 00 74 05 E9 AB 00 00 00 C7 45 F4 00 00 00 00 A1 ?? ?? ?? ?? 64 8B 0D ?? ?? ?? ?? 8B 14 81 8B 82 ?? ?? ?? ?? 89 45 FC EB 06 8B 4D F4 89 4D FC 83 7D FC 00 74 7E 8B 55 FC 8B 02 83 E8 01 89 45 F8 EB 09 8B 4D F8 83 E9 01 89 4D F8 83 7D F8 00 7C 27 8B 55 F8 8B 45 FC 83 7C 90 08 00 74 18 8B 4D F8 8B 55 FC 8B 44 8A 08 89 45 F0 8B 4D F0 E8 ?? ?? ?? ?? FF 55 F0 EB CA 8B 4D FC 8B 51 04 89 55 F4 83 7D F4 00 74 0E 6A 02 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 08 8B 0D ?? ?? ?? ?? 64 8B 15 ?? ?? ?? ?? 8B 04 8A 8B 4D F4 89 88 ?? ?? ?? ?? E9 76 FF FF FF 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule file_318_1_0 {
	meta:
		name = "??$?RUTlsDtorNode@@@__crt_internal_free_policy@@QBEXQBUTlsDtorNode@@@Z"
		size = 27
		refs = "000e __free_dbg"
		altNames = "??$?RD@__crt_internal_free_policy@@QBEXQBD@Z ??$?RU__vcrt_ptd@@@__crt_internal_free_policy@@QBEXQBU__vcrt_ptd@@@Z ??$?RX@__crt_internal_free_policy@@QBEXQBX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 6A 02 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_318_2_0 {
	meta:
		name = "??0?$__crt_unique_heap_ptr@UTlsDtorNode@@U__crt_internal_free_policy@@@@QAE@QAUTlsDtorNode@@@Z"
		size = 24
		altNames = "??0?$__crt_scoped_stack_ptr@_W@@QAE@U?$__crt_scoped_stack_ptr_tag@_W@@@Z ??0?$__crt_scoped_stack_ptr_tag@_W@@QAE@QA_W@Z ??0?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QAE@QAD@Z ??0?$__crt_unique_heap_ptr@DU__crt_public_free_policy@@@@QAE@QAD@Z ??0?$__crt_unique_heap_ptr@U__vcrt_ptd@@U__crt_internal_free_policy@@@@QAE@QAU__vcrt_ptd@@@Z ??0?$__crt_unique_heap_ptr@XU__crt_internal_free_policy@@@@QAE@QAX@Z ??0_Timevec@std@@QAE@PAX@Z ??0id@locale@std@@QAE@I@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 4D 08 89 08 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_318_4_0 {
	meta:
		name = "?detach@?$__crt_unique_heap_ptr@UTlsDtorNode@@U__crt_internal_free_policy@@@@QAEPAUTlsDtorNode@@XZ"
		size = 33
		altNames = "?detach@?$__crt_unique_heap_ptr@DU__crt_public_free_policy@@@@QAEPADXZ ?detach@?$__crt_unique_heap_ptr@U__vcrt_ptd@@U__crt_internal_free_policy@@@@QAEPAU__vcrt_ptd@@XZ ?detach@?$__crt_unique_heap_ptr@XU__crt_internal_free_policy@@@@QAEPAXXZ"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D FC 8B 45 FC 8B 08 89 4D F8 8B 55 FC C7 02 00 00 00 00 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_318_5_0 {
	meta:
		name = "?release@?$__crt_unique_heap_ptr@UTlsDtorNode@@U__crt_internal_free_policy@@@@QAEXXZ"
		size = 36
		refs = "0013 ??$?RUTlsDtorNode@@@__crt_internal_free_policy@@QBEXQBUTlsDtorNode@@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D F8 8B 45 F8 8B 08 51 8D 4D FF E8 ?? ?? ?? ?? 8B 55 F8 C7 02 00 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_2_22_4 {
	meta:
		name = "?release@?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QAEXXZ"
		size = 36
		refs = "0013 ??$?RD@__crt_internal_free_policy@@QBEXQBD@Z"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D F8 8B 45 F8 8B 08 51 8D 4D FF E8 ?? ?? ?? ?? 8B 55 F8 C7 02 00 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_25_7_4 {
	meta:
		name = "?release@?$__crt_unique_heap_ptr@DU__crt_public_free_policy@@@@QAEXXZ"
		size = 36
		refs = "0013 ??$?RD@__crt_public_free_policy@@QBEXQBD@Z"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D F8 8B 45 F8 8B 08 51 8D 4D FF E8 ?? ?? ?? ?? 8B 55 F8 C7 02 00 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_4_9_4 {
	meta:
		name = "?release@?$__crt_unique_heap_ptr@U__vcrt_ptd@@U__crt_internal_free_policy@@@@QAEXXZ"
		size = 36
		refs = "0013 ??$?RU__vcrt_ptd@@@__crt_internal_free_policy@@QBEXQBU__vcrt_ptd@@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D F8 8B 45 F8 8B 08 51 8D 4D FF E8 ?? ?? ?? ?? 8B 55 F8 C7 02 00 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_2_23_4 {
	meta:
		name = "?release@?$__crt_unique_heap_ptr@XU__crt_internal_free_policy@@@@QAEXXZ"
		size = 36
		refs = "0013 ??$?RX@__crt_internal_free_policy@@QBEXQBX@Z"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D F8 8B 45 F8 8B 08 51 8D 4D FF E8 ?? ?? ?? ?? 8B 55 F8 C7 02 00 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_318_6_0 {
	meta:
		name = "___tlregdtor"
		size = 392
		refs = "0007 __tls_index 000e __tls_array 0017 _dtor_list 002f _dtor_list_head 0089 ??_C@_0DA@HHHHCDMN@f?3?2dd?2vctools?2crt?2vcstartup?2src?2@ 0095 __malloc_dbg 00a1 ??0?$__crt_unique_heap_ptr@UTlsDtorNode@@U__crt_internal_free_policy@@@@QAE@QAUTlsDtorNode@@@Z 00a8 ?detach@?$__crt_unique_heap_ptr@UTlsDtorNode@@U__crt_internal_free_policy@@@@QAEPAUTlsDtorNode@@XZ 00b3 ??1?$__crt_unique_heap_ptr@UTlsDtorNode@@U__crt_internal_free_policy@@@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 83 EC 08 A1 ?? ?? ?? ?? 64 8B 0D ?? ?? ?? ?? 8B 14 81 83 BA ?? ?? ?? ?? 00 75 49 A1 ?? ?? ?? ?? 64 8B 0D ?? ?? ?? ?? 8B 14 81 81 C2 ?? ?? ?? ?? A1 ?? ?? ?? ?? 64 8B 0D ?? ?? ?? ?? 8B 04 81 89 90 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 64 8B 15 ?? ?? ?? ?? 8B 04 8A C7 80 ?? ?? ?? ?? 00 00 00 00 E9 B5 00 00 00 8B 0D ?? ?? ?? ?? 64 8B 15 ?? ?? ?? ?? 8B 04 8A 8B 88 ?? ?? ?? ?? 83 39 1E 0F 85 96 00 00 00 6A 43 68 ?? ?? ?? ?? 6A 02 68 80 00 00 00 E8 ?? ?? ?? ?? 83 C4 10 50 8D 4D F8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 89 45 FC 8D 4D F8 E8 ?? ?? ?? ?? 83 7D FC 00 75 08 83 C8 FF E9 BF 00 00 00 8B 55 FC C7 02 00 00 00 00 A1 ?? ?? ?? ?? 64 8B 0D ?? ?? ?? ?? 8B 14 81 8B 45 FC 8B 8A ?? ?? ?? ?? 89 48 04 8B 15 ?? ?? ?? ?? 64 A1 ?? ?? ?? ?? 8B 0C 90 8B 55 FC 89 91 ?? ?? ?? ?? A1 ?? ?? ?? ?? 64 8B 0D ?? ?? ?? ?? 8B 14 81 8B 82 ?? ?? ?? ?? C7 00 00 00 00 00 8B 0D ?? ?? ?? ?? 64 8B 15 ?? ?? ?? ?? 8B 04 8A 8B 88 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 64 A1 ?? ?? ?? ?? 8B 14 90 8B 82 ?? ?? ?? ?? 8B 10 8B 45 08 89 44 91 08 8B 0D ?? ?? ?? ?? 64 8B 15 ?? ?? ?? ?? 8B 04 8A 8B 88 ?? ?? ?? ?? 8B 11 83 C2 01 A1 ?? ?? ?? ?? 64 8B 0D ?? ?? ?? ?? 8B 04 81 8B 88 ?? ?? ?? ?? 89 11 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_321_0_0 {
	meta:
		name = "??_M@YGXPAXIHP6EX0@Z@Z"
		size = 28
		refs = "0014 ??_M@YGXPAXIIP6EX0@Z@Z"
	strings:
		$1 = { 55 8B EC 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 5D C2 10 00 }
	condition:
		$1
}

rule file_321_1_0 {
	meta:
		name = "??_M@YGXPAXIIP6EX0@Z@Z"
		size = 192
		refs = "0006 __sehtable$??_M@YGXPAXIIP6EX0@Z@Z 000b __except_handler4 001d ___security_cookie 0070 @_guard_check_icall@4 00a7 ?__ArrayUnwind@@YGXPAXIIP6EX0@Z@Z"
	strings:
		$1 = { 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 EC 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 C6 45 E7 00 8B 45 0C 0F AF 45 10 03 45 08 89 45 08 C7 45 FC 00 00 00 00 8B 4D 10 89 4D DC 8B 55 10 83 EA 01 89 55 10 83 7D DC 00 76 1F 8B 45 08 2B 45 0C 89 45 08 8B 4D 14 89 4D E0 8B 4D E0 E8 ?? ?? ?? ?? 8B 4D 08 FF 55 E0 EB CC C6 45 E7 01 C7 45 FC FE FF FF FF E8 02 00 00 00 EB 1E 0F B6 55 E7 85 D2 75 15 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? C3 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C2 10 00 }
	condition:
		$1
}

rule file_321_2_0 {
	meta:
		name = "?ArrayUnwindFilter@@YAHPAU_EXCEPTION_POINTERS@@@Z"
		size = 44
		refs = "0022 _terminate"
	strings:
		$1 = { 55 8B EC 83 EC 08 8B 45 08 8B 08 89 4D FC 8B 55 FC 8B 02 89 45 F8 81 7D F8 63 73 6D E0 74 02 EB 05 E8 ?? ?? ?? ?? 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_321_3_0 {
	meta:
		name = "?__ArrayUnwind@@YGXPAXIIP6EX0@Z@Z"
		size = 167
		refs = "0006 __sehtable$?__ArrayUnwind@@YGXPAXIIP6EX0@Z@Z 000b __except_handler4 001d ___security_cookie 0067 @_guard_check_icall@4 0081 ?ArrayUnwindFilter@@YAHPAU_EXCEPTION_POINTERS@@@Z"
	strings:
		$1 = { 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 F0 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 89 65 E8 C7 45 FC 00 00 00 00 C7 45 E4 00 00 00 00 EB 09 8B 45 E4 83 C0 01 89 45 E4 8B 4D E4 3B 4D 10 74 1F 8B 55 08 2B 55 0C 89 55 08 8B 45 14 89 45 E0 8B 4D E0 E8 ?? ?? ?? ?? 8B 4D 08 FF 55 E0 EB D0 C7 45 FC FE FF FF FF EB 17 8B 4D EC 51 E8 ?? ?? ?? ?? 83 C4 04 C3 8B 65 E8 C7 45 FC FE FF FF FF 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C2 10 00 }
	condition:
		$1
}

rule file_322_0_0 {
	meta:
		name = "___avx_log10f8"
		size = 368
		refs = "0010 ___common_slog10_data 0166 ___common_slog10_cout_rare"
	strings:
		$1 = { 55 8B EC 83 E4 C0 81 EC C0 00 00 00 C5 F8 10 1D ?? ?? ?? ?? C5 F8 10 25 ?? ?? ?? ?? C5 F9 FA EB C4 E3 7D 19 C1 01 C5 C9 72 E5 17 C5 F1 FA D3 C5 D1 DB EC C5 F1 72 E2 17 C5 E9 DB D4 C5 E9 FE E3 C5 FC C2 15 ?? ?? ?? ?? 16 C4 E3 4D 18 F9 01 C5 FC 5B CF C5 D1 FE FB C5 FC C2 1D ?? ?? ?? ?? 11 C5 C9 EF F6 C5 E4 56 EA C4 E3 45 18 FC 01 C5 C4 5C 3D ?? ?? ?? ?? C4 E3 7D 19 EC 01 C5 D1 6B DC C5 C4 59 2D ?? ?? ?? ?? C5 E1 63 D6 C5 C4 59 25 ?? ?? ?? ?? C5 D4 58 35 ?? ?? ?? ?? C5 F9 D7 D2 C5 DC 58 1D ?? ?? ?? ?? C5 C4 59 EF C5 C4 59 15 ?? ?? ?? ?? C5 CC 59 F5 C5 EC 58 25 ?? ?? ?? ?? C5 CC 58 F3 C5 C4 59 1D ?? ?? ?? ?? C5 E4 58 15 ?? ?? ?? ?? C5 CC 59 DD C5 E4 58 E4 C5 DC 59 ED C5 F4 59 25 ?? ?? ?? ?? C5 F4 59 0D ?? ?? ?? ?? C5 D4 58 D2 C5 EC 59 D7 C5 EC 58 1D ?? ?? ?? ?? C5 E4 59 FF C5 C4 58 D4 C5 F4 58 CA 84 D2 75 08 C5 FC 28 C1 8B E5 5D C3 C5 FC 11 44 24 40 C5 FC 11 8C 24 80 00 00 00 85 D2 74 E5 33 C0 89 74 24 04 8B F0 89 3C 24 8B FA 0F A3 F7 72 18 46 83 FE 20 7C F5 8B 74 24 04 8B 3C 24 C5 FC 10 8C 24 80 00 00 00 EB BB C5 F8 77 8D 8C B4 80 00 00 00 8D 44 B4 40 51 50 E8 ?? ?? ?? ?? 83 C4 08 EB CE 90 }
	condition:
		$1
}

rule file_330_0_0 {
	meta:
		name = "__SEH_prolog4"
		size = 70
		refs = "0001 __except_handler4 001e ___security_cookie"
	strings:
		$1 = { 68 ?? ?? ?? ?? 64 FF 35 00 00 00 00 8B 44 24 10 89 6C 24 10 8D 6C 24 10 2B E0 53 56 57 A1 ?? ?? ?? ?? 31 45 FC 33 C5 50 89 65 E8 FF 75 F8 8B 45 FC C7 45 FC FE FF FF FF 89 45 F8 8D 45 F0 64 A3 00 00 00 00 F2 C3 }
	condition:
		$1
}

rule file_330_1_0 {
	meta:
		name = "__SEH_epilog4"
		size = 21
	strings:
		$1 = { 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5F 5E 5B 8B E5 5D 51 F2 C3 }
	condition:
		$1
}

rule file_331_0_0 {
	meta:
		name = "___vdecl_fmodf4"
		size = 89
		refs = "0016 __CIfmod"
	strings:
		$1 = { 83 EC 20 F3 0F 7F 04 24 F3 0F 7F 4C 24 10 D9 04 24 D9 44 24 10 E8 ?? ?? ?? ?? D9 1C 24 D9 44 24 04 D9 44 24 14 E8 ?? ?? ?? ?? D9 5C 24 04 D9 44 24 08 D9 44 24 18 E8 ?? ?? ?? ?? D9 5C 24 08 D9 44 24 0C D9 44 24 1C E8 ?? ?? ?? ?? D9 5C 24 0C F3 0F 6F 04 24 83 C4 20 C3 }
	condition:
		$1
}

rule file_333_0_0 {
	meta:
		name = "___sse4_floorf4"
		size = 16
	strings:
		$1 = { 66 0F 3A 08 C0 01 C3 8D A4 24 00 00 00 00 8B FF }
	condition:
		$1
}

rule file_334_0_0 {
	meta:
		name = "___avx_tanhf8"
		size = 624
		refs = "001d ___common_stanh_data 0266 ___common_stanh_cout_rare"
	strings:
		$1 = { 55 8B EC 83 E4 C0 56 57 53 81 EC B4 00 00 00 C5 FC 28 E0 C5 FC 11 64 24 20 C5 F8 10 35 ?? ?? ?? ?? C5 F8 10 3D ?? ?? ?? ?? C5 F8 10 0D ?? ?? ?? ?? C5 DC 54 05 ?? ?? ?? ?? C5 DC 54 2D ?? ?? ?? ?? C5 FC 11 2C 24 C5 D9 DB DE C4 E3 7D 19 E2 01 C5 E1 66 EF C5 E9 DB D6 C5 E9 66 FF C5 C9 EF F6 C5 D1 6B EF C5 D1 63 E6 C5 E9 FA E9 C5 F9 D7 C4 C5 E1 FA E1 C5 F8 10 0D ?? ?? ?? ?? C5 D9 66 DE C5 D9 DB D3 C5 D9 66 E1 C5 D1 66 F6 C4 E3 69 4A E1 40 C5 D1 DB F6 C5 D1 66 E9 C4 E3 49 4A C9 50 C5 C9 72 D4 0E C5 F9 7E F3 C5 D1 72 D1 0E C5 F9 7E EE C5 F9 10 A3 ?? ?? ?? ?? C4 E3 79 16 F1 01 C4 E3 79 16 F2 03 C4 E3 79 16 EF 01 89 84 24 80 00 00 00 C5 F9 10 91 ?? ?? ?? ?? C4 E3 79 16 F0 02 89 B4 24 84 00 00 00 C5 F9 10 B6 ?? ?? ?? ?? 89 BC 24 88 00 00 00 C4 E3 79 16 EE 03 C4 E3 6D 18 8A ?? ?? ?? ?? 01 C5 F9 10 97 ?? ?? ?? ?? C4 E3 79 16 EF 02 C4 E3 5D 18 B8 ?? ?? ?? ?? 01 C5 C5 14 D9 C5 C5 15 E1 C5 F9 10 B9 ?? ?? ?? ?? C5 FD 11 5C 24 40 C5 F9 10 9B ?? ?? ?? ?? 8B 8C 24 88 00 00 00 C4 E3 4D 18 B7 ?? ?? ?? ?? 01 C4 E3 6D 18 96 ?? ?? ?? ?? 01 C5 CD 14 EA C5 FD 11 6C 24 60 C5 CD 15 EA C4 E3 45 18 B2 ?? ?? ?? ?? 01 8B 94 24 84 00 00 00 C4 E3 65 18 88 ?? ?? ?? ?? 01 C5 F5 14 D6 C5 F5 15 CE C5 F9 10 B2 ?? ?? ?? ?? C5 F9 10 99 ?? ?? ?? ?? C4 E3 4D 18 BF ?? ?? ?? ?? 01 C4 E3 65 18 B6 ?? ?? ?? ?? 01 C5 C5 14 DE C5 C5 15 FE 8B B4 24 80 00 00 00 8B C6 C5 FC 5A F0 C4 E3 7D 19 C0 01 C5 F5 59 CE C5 FC 5A C0 C5 F5 58 D2 C5 C5 59 F8 C5 ED 59 D6 C5 C5 58 CB C5 ED 58 D4 C5 F5 59 E0 C5 DD 58 CD C5 ED 59 EE C5 F5 59 D8 C5 D5 58 54 24 40 C5 E5 58 44 24 60 C5 FD 5A F2 C5 FD 5A C8 C4 E3 4D 18 D1 01 C5 EC 56 04 24 84 C0 75 0D 81 C4 B4 00 00 00 5B 5F 5E 8B E5 5D C3 C5 FC 10 4C 24 20 C5 FC 11 44 24 40 C5 FC 11 0C 24 85 F6 74 DE 33 DB 0F A3 DE 72 19 43 83 FB 20 7C F5 C5 FC 10 44 24 40 81 C4 B4 00 00 00 5B 5F 5E 8B E5 5D C3 C5 F8 77 8D 44 9C 40 8D 14 9C 50 52 E8 ?? ?? ?? ?? 83 C4 08 EB D1 90 }
	condition:
		$1
}

rule file_335_0_0 {
	meta:
		name = "___scrt_fastfail"
		size = 309
		refs = "000c _IsProcessorFeaturePresent@4 001c __crt_debugger_hook 0032 _memset 00dc __imp__IsDebuggerPresent@0 0108 __imp__SetUnhandledExceptionFilter@4 0112 __imp__UnhandledExceptionFilter@4"
	strings:
		$1 = { 55 8B EC 81 EC 2C 03 00 00 6A 17 E8 ?? ?? ?? ?? 85 C0 74 05 8B 4D 08 CD 29 6A 03 E8 ?? ?? ?? ?? 83 C4 04 68 CC 02 00 00 6A 00 8D 85 D4 FC FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C 89 85 84 FD FF FF 89 8D 80 FD FF FF 89 95 7C FD FF FF 89 9D 78 FD FF FF 89 B5 74 FD FF FF 89 BD 70 FD FF FF 66 8C 95 9C FD FF FF 66 8C 8D 90 FD FF FF 66 8C 9D 6C FD FF FF 66 8C 85 68 FD FF FF 66 8C A5 64 FD FF FF 66 8C AD 60 FD FF FF 9C 8F 85 94 FD FF FF C7 85 D4 FC FF FF 01 00 01 00 8B 4D 04 89 8D 8C FD FF FF 8D 55 04 89 95 98 FD FF FF 8D 45 04 8B 48 FC 89 8D 88 FD FF FF 6A 50 6A 00 8D 55 A0 52 E8 ?? ?? ?? ?? 83 C4 0C C7 45 A0 15 00 00 40 C7 45 A4 01 00 00 00 8B 45 04 89 45 AC FF 15 ?? ?? ?? ?? 83 F8 01 75 06 C6 45 FF 01 EB 04 C6 45 FF 00 8A 4D FF 88 4D FE 8D 55 A0 89 55 F0 8D 85 D4 FC FF FF 89 45 F4 6A 00 FF 15 ?? ?? ?? ?? 8D 4D F0 51 FF 15 ?? ?? ?? ?? 89 45 F8 83 7D F8 00 75 12 0F B6 55 FE 85 D2 75 0A 6A 03 E8 ?? ?? ?? ?? 83 C4 04 8B E5 5D C3 }
	condition:
		$1
}

rule file_335_1_0 {
	meta:
		name = "___scrt_get_show_window_mode"
		size = 64
		refs = "000f _memset 001c __imp__GetStartupInfoW@4"
	strings:
		$1 = { 55 8B EC 83 EC 48 6A 44 6A 00 8D 45 B8 50 E8 ?? ?? ?? ?? 83 C4 0C 8D 4D B8 51 FF 15 ?? ?? ?? ?? 8B 55 E4 83 E2 01 74 09 0F B7 45 E8 89 45 FC EB 07 C7 45 FC 0A 00 00 00 66 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_335_3_0 {
	meta:
		name = "___scrt_is_managed_app"
		size = 131
		refs = "000a __imp__GetModuleHandleW@4"
	strings:
		$1 = { 55 8B EC 83 EC 08 6A 00 FF 15 ?? ?? ?? ?? 89 45 FC 83 7D FC 00 75 04 32 C0 EB 64 8B 45 FC 0F B7 08 81 F9 4D 5A 00 00 74 04 32 C0 EB 52 8B 55 FC 8B 45 FC 03 42 3C 89 45 F8 8B 4D F8 81 39 50 45 00 00 74 04 32 C0 EB 37 8B 55 F8 0F B7 42 18 3D 0B 01 00 00 74 04 32 C0 EB 25 8B 4D F8 83 79 74 0E 77 04 32 C0 EB 18 BA 08 00 00 00 6B C2 0E 8B 4D F8 83 7C 01 78 00 75 04 32 C0 EB 02 B0 01 8B E5 5D C3 }
	condition:
		$1
}

rule file_335_5_0 {
	meta:
		name = "___scrt_unhandled_exception_filter@4"
		size = 93
		refs = "0051 _terminate"
	strings:
		$1 = { 55 8B EC 51 8B 45 08 8B 08 89 4D FC 8B 55 FC 81 3A 63 73 6D E0 75 3E 8B 45 FC 83 78 10 03 75 35 8B 4D FC 81 79 14 20 05 93 19 74 24 8B 55 FC 81 7A 14 21 05 93 19 74 18 8B 45 FC 81 78 14 22 05 93 19 74 0C 8B 4D FC 81 79 14 00 40 99 01 75 05 E8 ?? ?? ?? ?? 33 C0 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_336_4_0 {
	meta:
		name = "?find_pe_section@@YAPAU_IMAGE_SECTION_HEADER@@QAEI@Z"
		size = 129
	strings:
		$1 = { 55 8B EC 83 EC 18 8B 45 08 89 45 F4 8B 4D F4 8B 55 F4 03 51 3C 89 55 EC 8B 45 EC 89 45 F8 8B 4D F8 0F B7 51 14 8B 45 F8 8D 4C 10 18 89 4D F0 8B 55 F8 0F B7 42 06 6B C8 28 03 4D F0 89 4D E8 8B 55 F0 89 55 FC EB 09 8B 45 FC 83 C0 28 89 45 FC 8B 4D FC 3B 4D E8 74 23 8B 55 FC 8B 45 0C 3B 42 0C 72 16 8B 4D FC 8B 51 0C 8B 45 FC 03 50 08 39 55 0C 73 05 8B 45 FC EB 04 EB CC 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_336_5_0 {
	meta:
		name = "?is_potentially_valid_image_base@@YA_NQAX@Z"
		size = 105
	strings:
		$1 = { 55 8B EC 83 EC 10 83 7D 08 00 75 04 32 C0 EB 55 8B 45 08 89 45 FC 8B 4D FC 0F B7 11 81 FA 4D 5A 00 00 74 04 32 C0 EB 3D 8B 45 FC 8B 4D FC 03 48 3C 89 4D F4 8B 55 F4 89 55 F8 8B 45 F8 81 38 50 45 00 00 74 04 32 C0 EB 1C 8B 4D F8 83 C1 18 89 4D F0 8B 55 F0 0F B7 02 3D 0B 01 00 00 74 04 32 C0 EB 02 B0 01 8B E5 5D C3 }
	condition:
		$1
}

rule file_336_7_0 {
	meta:
		name = "___scrt_acquire_startup_lock"
		size = 73
		refs = "0007 ___scrt_is_ucrt_dll_in_use 0014 _NtCurrentTeb 0022 ___scrt_native_startup_lock"
	strings:
		$1 = { 55 8B EC 83 EC 08 E8 ?? ?? ?? ?? 85 C0 75 04 32 C0 EB 32 E8 ?? ?? ?? ?? 8B 40 04 89 45 FC 8B 4D FC BA ?? ?? ?? ?? 33 C0 F0 0F B1 0A 89 45 F8 83 7D F8 00 74 0E 8B 45 FC 3B 45 F8 75 04 B0 01 EB 04 EB DB 32 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_336_8_0 {
	meta:
		name = "___scrt_dllmain_after_initialize_c"
		size = 41
		refs = "0004 ___scrt_is_ucrt_dll_in_use 000d ___isa_available_init 0014 ?configure_argv@__scrt_narrow_argv_policy@@SAHXZ 0021 __initialize_narrow_environment"
	strings:
		$1 = { 55 8B EC E8 ?? ?? ?? ?? 85 C0 74 07 E8 ?? ?? ?? ?? EB 12 E8 ?? ?? ?? ?? 85 C0 74 04 32 C0 EB 07 E8 ?? ?? ?? ?? B0 01 5D C3 }
	condition:
		$1
}

rule file_336_9_0 {
	meta:
		name = "___scrt_dllmain_before_initialize_c"
		size = 28
		refs = "0006 ___scrt_initialize_onexit_tables"
	strings:
		$1 = { 55 8B EC 6A 00 E8 ?? ?? ?? ?? 83 C4 04 0F B6 C0 85 C0 75 04 32 C0 EB 02 B0 01 5D C3 }
	condition:
		$1
}

rule file_336_10_0 {
	meta:
		name = "___scrt_dllmain_crt_thread_attach"
		size = 44
		refs = "0004 ___vcrt_thread_attach 0014 ___acrt_thread_attach 0020 ___vcrt_thread_detach"
	strings:
		$1 = { 55 8B EC E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 04 32 C0 EB 17 E8 ?? ?? ?? ?? 0F B6 C8 85 C9 75 09 E8 ?? ?? ?? ?? 32 C0 EB 02 B0 01 5D C3 }
	condition:
		$1
}

rule file_336_11_0 {
	meta:
		name = "___scrt_dllmain_crt_thread_detach"
		size = 17
		refs = "0004 ___acrt_thread_detach 0009 ___vcrt_thread_detach"
	strings:
		$1 = { 55 8B EC E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? B0 01 5D C3 }
	condition:
		$1
}

rule file_336_12_0 {
	meta:
		name = "___scrt_dllmain_exception_filter"
		size = 66
		refs = "0005 ___scrt_is_ucrt_dll_in_use 0027 @_guard_check_icall@4 0037 __seh_filter_dll"
	strings:
		$1 = { 55 8B EC 51 E8 ?? ?? ?? ?? 85 C0 75 21 83 7D 0C 01 75 1B 8B 45 10 50 6A 00 8B 4D 08 51 8B 55 14 89 55 FC 8B 4D FC E8 ?? ?? ?? ?? FF 55 FC 8B 45 1C 50 8B 4D 18 51 E8 ?? ?? ?? ?? 83 C4 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_336_13_0 {
	meta:
		name = "___scrt_dllmain_uninitialize_c"
		size = 43
		refs = "0004 ___scrt_is_ucrt_dll_in_use 000d ?module_local_atexit_table@@3U_onexit_table_t@@A 0012 __execute_onexit_table 001c __is_c_termination_complete 0025 __cexit"
	strings:
		$1 = { 55 8B EC E8 ?? ?? ?? ?? 85 C0 74 0F 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 EB 0E E8 ?? ?? ?? ?? 85 C0 75 05 E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_336_14_0 {
	meta:
		name = "___scrt_dllmain_uninitialize_critical"
		size = 20
		refs = "0006 ___acrt_uninitialize_critical 000e ___vcrt_uninitialize_critical"
	strings:
		$1 = { 55 8B EC 6A 00 E8 ?? ?? ?? ?? 83 C4 04 E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_336_15_0 {
	meta:
		name = "___scrt_initialize_crt"
		size = 67
		refs = "000b ?is_initialized_as_dll@@3_NA 0011 ___isa_available_init 0016 ___vcrt_initialize 0026 ___acrt_initialize 0034 ___vcrt_uninitialize"
	strings:
		$1 = { 55 8B EC 83 7D 08 00 75 07 C6 05 ?? ?? ?? ?? 01 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 04 32 C0 EB 1C E8 ?? ?? ?? ?? 0F B6 C8 85 C9 75 0E 6A 00 E8 ?? ?? ?? ?? 83 C4 04 32 C0 EB 02 B0 01 5D C3 }
	condition:
		$1
}

rule file_336_16_0 {
	meta:
		name = "___scrt_initialize_onexit_tables"
		size = 198
		refs = "0015 ___scrt_fastfail 001a ___scrt_is_ucrt_dll_in_use 0029 ?module_local_atexit_table@@3U_onexit_table_t@@A 002e __initialize_onexit_table 0041 ?module_local_at_quick_exit_table@@3U_onexit_table_t@@A 005e ??$__crt_fast_encode_pointer@PAP6AXXZ@@YAPAP6AXXZQAP6AXXZ@Z"
	strings:
		$1 = { 55 8B EC 83 EC 1C 83 7D 08 00 74 0D 83 7D 08 01 74 07 6A 05 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 39 83 7D 08 00 75 33 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 07 32 C0 E9 82 00 00 00 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 04 32 C0 EB 6D B0 01 EB 69 EB 67 6A FF E8 ?? ?? ?? ?? 83 C4 04 89 45 FC 8B 45 FC 89 45 F0 8B 4D FC 89 4D F4 8B 55 FC 89 55 F8 8B 45 F0 A3 ?? ?? ?? ?? 8B 4D F4 89 0D ?? ?? ?? ?? 8B 55 F8 89 15 ?? ?? ?? ?? 8B 45 FC 89 45 E4 8B 4D FC 89 4D E8 8B 55 FC 89 55 EC 8B 45 E4 A3 ?? ?? ?? ?? 8B 4D E8 89 0D ?? ?? ?? ?? 8B 55 EC 89 15 ?? ?? ?? ?? B0 01 8B E5 5D C3 }
	condition:
		$1
}

rule file_336_17_0 {
	meta:
		name = "___scrt_is_nonwritable_in_current_image"
		size = 297
		refs = "0006 __sehtable$___scrt_is_nonwritable_in_current_image 000b __except_handler4 001d ___security_cookie 003c ___ImageBase 004c ?is_potentially_valid_image_base@@YA_NQAX@Z 007f ?find_pe_section@@YAPAU_IMAGE_SECTION_HEADER@@QAEI@Z"
	strings:
		$1 = { 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 D8 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 89 65 E8 8B 45 08 89 45 D0 C7 45 DC ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D DC 51 E8 ?? ?? ?? ?? 83 C4 04 0F B6 D0 85 D2 75 13 C6 45 E7 00 C7 45 FC FE FF FF FF 8A 45 E7 E9 AA 00 00 00 8B 45 D0 2B 45 DC 89 45 CC 8B 4D CC 51 8B 55 DC 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 D8 83 7D D8 00 75 10 C6 45 E6 00 C7 45 FC FE FF FF FF 8A 45 E6 EB 78 8B 45 D8 8B 48 24 81 E1 00 00 00 80 74 10 C6 45 E5 00 C7 45 FC FE FF FF FF 8A 45 E5 EB 5A C6 45 E4 01 C7 45 FC FE FF FF FF 8A 45 E4 EB 4A C7 45 FC FE FF FF FF EB 41 8B 55 EC 8B 02 8B 08 89 4D C8 81 7D C8 05 00 00 C0 75 09 C7 45 D4 01 00 00 00 EB 07 C7 45 D4 00 00 00 00 8B 45 D4 C3 8B 65 E8 C6 45 E3 00 C7 45 FC FE FF FF FF 8A 45 E3 EB 07 C7 45 FC FE FF FF FF 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_336_18_0 {
	meta:
		name = "___scrt_release_startup_lock"
		size = 35
		refs = "0004 ___scrt_is_ucrt_dll_in_use 001b ___scrt_native_startup_lock"
	strings:
		$1 = { 55 8B EC E8 ?? ?? ?? ?? 85 C0 75 02 EB 13 0F B6 45 08 85 C0 74 02 EB 09 33 C9 BA ?? ?? ?? ?? 87 0A 5D C3 }
	condition:
		$1
}

rule file_336_19_0 {
	meta:
		name = "___scrt_uninitialize_crt"
		size = 56
		refs = "0006 ?is_initialized_as_dll@@3_NA 0020 ___acrt_uninitialize 002d ___vcrt_uninitialize"
	strings:
		$1 = { 55 8B EC 0F B6 05 ?? ?? ?? ?? 85 C0 74 0C 0F B6 4D 0C 85 C9 74 04 B0 01 EB 1C 0F B6 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 0F B6 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 B0 01 5D C3 }
	condition:
		$1
}

rule file_336_20_0 {
	meta:
		name = "__onexit"
		size = 110
		refs = "0007 ?module_local_atexit_table@@3U_onexit_table_t@@A 000d ??$__crt_fast_decode_pointer@PAP6AXXZ@@YAPAP6AXXZQAP6AXXZ@Z 0022 __crt_atexit 004d __register_onexit_function"
	strings:
		$1 = { 55 8B EC 83 EC 0C A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 F4 83 7D F4 FF 75 26 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 08 8B 55 08 89 55 FC EB 07 C7 45 FC 00 00 00 00 8B 45 FC EB 29 EB 27 8B 45 08 50 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 08 8B 4D 08 89 4D F8 EB 07 C7 45 F8 00 00 00 00 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_336_21_0 {
	meta:
		name = "_at_quick_exit"
		size = 72
		refs = "0007 ?module_local_at_quick_exit_table@@3U_onexit_table_t@@A 000d ??$__crt_fast_decode_pointer@PAP6AXXZ@@YAPAP6AXXZQAP6AXXZ@Z 0022 __crt_at_quick_exit 003d __register_onexit_function"
	strings:
		$1 = { 55 8B EC 83 EC 08 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 FC 83 7D FC FF 75 10 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 04 EB 19 EB 17 8B 55 08 89 55 F8 8B 45 F8 50 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_336_22_0 {
	meta:
		name = "_atexit"
		size = 43
		refs = "0009 __onexit"
	strings:
		$1 = { 55 8B EC 51 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 09 C7 45 FC 00 00 00 00 EB 07 C7 45 FC FF FF FF FF 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_359_0_0 {
	meta:
		name = "___sse2_acosf4"
		size = 352
		refs = "000f ___common_sacos_data 014f ___common_sacos_cout_rare"
	strings:
		$1 = { 55 8B EC 83 E4 C0 81 EC C0 00 00 00 0F 28 3D ?? ?? ?? ?? 0F 28 F7 0F 54 F8 0F 56 F0 0F 28 15 ?? ?? ?? ?? 0F 28 E6 0F 59 E2 0F 28 EE 0F 59 EE 0F 58 E2 0F 52 D4 0F 5D EC 0F 28 DE 0F 28 CA 0F C2 1D ?? ?? ?? ?? 02 0F 59 CA 0F 50 D3 0F 28 DD 0F 29 3C 24 0F C2 DC 05 0F 58 E4 0F 59 D4 85 D2 0F 59 E1 0F 28 3D ?? ?? ?? ?? 0F 28 0D ?? ?? ?? ?? 0F 59 CD 0F 5C 25 ?? ?? ?? ?? 0F 59 FC 0F 58 0D ?? ?? ?? ?? 0F 59 E2 0F 58 3D ?? ?? ?? ?? 0F 59 FC 0F 28 E5 0F 59 E5 0F 5C D7 0F 59 CC 0F 28 3D ?? ?? ?? ?? 0F 28 E0 0F 59 FD 0F 54 D3 0F C2 E5 01 0F 58 3D ?? ?? ?? ?? 0F 58 CF 0F 28 FB 0F 59 CD 0F 55 3D ?? ?? ?? ?? 0F 58 0D ?? ?? ?? ?? 0F 59 CD 0F 28 2D ?? ?? ?? ?? 0F 54 EB 0F 54 EC 0F 28 E3 0F 55 E6 0F 58 FD 0F 56 E2 0F 57 24 24 0F 59 CC 0F 58 CC 0F 58 F9 75 07 0F 28 C7 8B E5 5D C3 0F 29 44 24 40 0F 29 BC 24 80 00 00 00 74 EA 33 C0 89 74 24 04 8B F0 89 3C 24 8B FA 8B CE B8 01 00 00 00 D3 E0 85 F8 75 17 46 83 FE 20 7C ED 8B 74 24 04 8B 3C 24 0F 28 BC 24 80 00 00 00 EB B9 8D 8C B4 80 00 00 00 8D 44 B4 40 51 50 E8 ?? ?? ?? ?? 83 C4 08 EB D2 8D A4 24 00 00 00 00 90 }
	condition:
		$1
}

rule file_361_0_0 {
	meta:
		name = "___avx_sinhf8"
		size = 368
		refs = "0014 ___common_ssinh_data 0162 ___common_ssinh_cout_rare"
	strings:
		$1 = { 55 8B EC 83 E4 C0 81 EC C0 00 00 00 C5 FC 28 C8 C5 F4 54 2D ?? ?? ?? ?? C5 D4 57 F9 C5 FC 10 35 ?? ?? ?? ?? C5 C4 59 25 ?? ?? ?? ?? C5 F8 10 05 ?? ?? ?? ?? C5 F8 10 15 ?? ?? ?? ?? C5 FC 11 0C 24 C5 DC 58 CE C5 C1 66 E0 C4 E3 7D 19 FB 01 C5 E1 66 D8 C5 D9 6B C3 C5 D9 EF E4 C5 F9 63 DC C5 F4 5C C6 C5 F9 D7 D3 C5 FC 59 35 ?? ?? ?? ?? C5 FC 59 05 ?? ?? ?? ?? C5 C4 5C FE C5 C4 5C D8 C5 E4 59 E3 C5 C9 72 F1 17 C4 E3 7D 19 CF 01 C5 E9 FE CE C5 F9 72 F7 17 C5 E9 FA F6 C5 E9 FE F8 C5 E9 FA D0 C4 E3 75 18 FF 01 C5 DC 59 0D ?? ?? ?? ?? C4 E3 4D 18 F2 01 C5 F4 58 15 ?? ?? ?? ?? C5 C4 58 C6 C5 C4 5C FE C5 EC 59 F4 C5 CC 59 CB C5 F4 58 F3 C5 DC 59 1D ?? ?? ?? ?? C5 FC 59 C6 C5 E4 58 0D ?? ?? ?? ?? C5 F4 59 D4 C5 EC 58 1D ?? ?? ?? ?? C5 E4 59 E4 C5 DC 59 CF C5 FC 58 C1 C5 FC 58 FF C5 D4 56 C7 84 D2 75 04 8B E5 5D C3 C5 FC 10 0C 24 C5 FC 11 84 24 80 00 00 00 C5 FC 11 4C 24 40 85 D2 74 E4 33 C0 89 74 24 04 8B F0 89 3C 24 8B FA 0F A3 F7 72 18 46 83 FE 20 7C F5 8B 74 24 04 8B 3C 24 C5 FC 10 84 24 80 00 00 00 EB BA C5 F8 77 8D 8C B4 80 00 00 00 8D 44 B4 40 51 50 E8 ?? ?? ?? ?? 83 C4 08 EB CE EB 03 CC CC CC }
	condition:
		$1
}

rule file_365_0_0 {
	meta:
		name = "___common_datan_cout_rare"
		size = 1520
		refs = "004a __vmldAtanHATab"
	strings:
		$1 = { 55 8B EC 83 E4 F8 53 83 EC 34 8B 45 08 0F B7 50 06 81 E2 F0 7F 00 00 C1 EA 04 81 FA FF 07 00 00 0F 84 66 05 00 00 F2 0F 10 00 0F B6 58 07 8B CB F2 0F 11 44 24 28 83 E3 7F 88 5C 24 2F F2 0F 10 44 24 28 C1 E9 07 66 0F 2F 05 ?? ?? ?? ?? 0F 82 0A 04 00 00 F2 0F 10 0D ?? ?? ?? ?? 66 0F 2F C8 0F 86 BF 03 00 00 8B 40 04 0F 28 F8 F2 0F 11 04 24 25 FF FF 0F 00 C1 E2 14 8B 5C 24 04 0B D0 8B C3 81 E3 00 00 08 00 25 00 00 F0 FF 81 CB 00 00 04 00 0B C3 81 C2 00 00 40 C0 C7 04 24 00 00 00 00 89 44 24 04 F2 0F 10 0D ?? ?? ?? ?? 0F 28 E1 F2 0F 5C 3C 24 F2 0F 59 E7 F2 0F 11 64 24 08 F2 0F 10 54 24 08 C1 FA 0F F2 0F 5C D7 F2 0F 11 54 24 10 83 E2 F0 F2 0F 10 5C 24 08 F2 0F 10 6C 24 10 C1 E1 07 F2 0F 5C DD F2 0F 11 5C 24 08 0F 28 E8 F2 0F 10 74 24 08 F2 0F 59 2D ?? ?? ?? ?? F2 0F 5C FE F2 0F 11 7C 24 10 F2 0F 10 5C 24 08 F2 0F 10 64 24 10 F2 0F 11 6C 24 08 F2 0F 10 74 24 08 F2 0F 5C 74 24 28 F2 0F 11 74 24 10 F2 0F 10 6C 24 08 F2 0F 10 54 24 10 F2 0F 5C EA F2 0F 11 6C 24 08 F2 0F 10 74 24 08 F2 0F 5C C6 F2 0F 11 44 24 10 F2 0F 10 7C 24 08 F2 0F 10 04 24 F2 0F 10 54 24 10 F2 0F 59 F8 F2 0F 59 D0 0F 28 EF F2 0F 58 EA F2 0F 11 6C 24 08 F2 0F 10 74 24 08 F2 0F 5C FE F2 0F 58 D7 F2 0F 11 54 24 10 F2 0F 10 15 ?? ?? ?? ?? F2 0F 10 44 24 08 0F 28 F2 F2 0F 10 6C 24 10 F2 0F 58 F0 F2 0F 11 74 24 08 0F 28 F2 F2 0F 10 7C 24 08 F2 0F 5C F7 F2 0F 11 74 24 10 F2 0F 10 74 24 08 F2 0F 10 7C 24 10 F2 0F 58 F7 F2 0F 11 74 24 18 0F 28 F2 F2 0F 10 7C 24 10 F2 0F 58 C7 F2 0F 11 44 24 10 F2 0F 10 44 24 18 F2 0F 5C F0 F2 0F 11 74 24 18 F2 0F 10 74 24 10 F2 0F 10 7C 24 18 F2 0F 58 F7 F2 0F 11 74 24 18 F2 0F 10 7C 24 08 F2 0F 10 44 24 18 F2 0F 58 C5 0F 28 EF F2 0F 59 E9 F2 0F 11 6C 24 08 F2 0F 10 74 24 08 F2 0F 5C F7 F2 0F 11 74 24 10 F2 0F 10 74 24 08 F2 0F 10 6C 24 10 F2 0F 5C F5 F2 0F 11 74 24 08 F2 0F 10 6C 24 08 F2 0F 5C FD F2 0F 11 7C 24 10 F2 0F 10 74 24 08 F2 0F 10 6C 24 10 F2 0F 58 E8 0F 28 C2 F2 0F 5E C6 F2 0F 59 C8 F2 0F 11 4C 24 10 F2 0F 10 4C 24 10 F2 0F 5C C8 F2 0F 11 4C 24 18 F2 0F 10 44 24 10 F2 0F 10 7C 24 18 F2 0F 5C C7 F2 0F 11 44 24 18 F2 0F 10 4C 24 18 F2 0F 59 F1 F2 0F 5C D6 F2 0F 10 74 24 18 F2 0F 59 EE F2 0F 11 6C 24 10 F2 0F 10 6C 24 10 F2 0F 5C D5 F2 0F 11 54 24 10 F2 0F 10 7C 24 10 F2 0F 10 74 24 18 F2 0F 10 54 24 10 F2 0F 10 6C 24 18 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FA F2 0F 59 FD 0F 28 EE F2 0F 59 F4 F2 0F 59 EB F2 0F 59 DF 0F 28 C7 F2 0F 59 C4 F2 0F 10 3D ?? ?? ?? ?? F2 0F 58 C6 F2 0F 10 92 ?? ?? ?? ?? F2 0F 58 C3 F2 0F 11 44 24 08 0F 28 DD F2 0F 10 74 24 08 0F 28 C2 F2 0F 58 DE F2 0F 11 5C 24 08 F2 0F 10 64 24 08 F2 0F 5C EC F2 0F 58 EE F2 0F 11 6C 24 10 F2 0F 10 5C 24 08 0F 28 EB F2 0F 58 C3 F2 0F 59 EB F2 0F 59 FD F2 0F 10 74 24 10 F2 0F 11 44 24 08 F2 0F 10 4C 24 08 F2 0F 58 3D ?? ?? ?? ?? F2 0F 5C D1 F2 0F 59 FD F2 0F 58 D3 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FD F2 0F 11 54 24 10 F2 0F 10 44 24 08 F2 0F 10 64 24 10 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FD F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FD F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FD F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FD F2 0F 59 DF F2 0F 58 DE F2 0F 58 9A ?? ?? ?? ?? F2 0F 58 DC F2 0F 58 C3 F2 0F 11 44 24 20 0F B6 54 24 27 83 E2 7F 0B D1 8B 4D 0C 88 54 24 27 F2 0F 10 5C 24 20 F2 0F 11 19 E9 5D 01 00 00 F2 0F 10 05 ?? ?? ?? ?? C1 E1 07 F2 0F 58 05 ?? ?? ?? ?? F2 0F 11 44 24 20 0F B6 44 24 27 83 E0 7F 8B 55 0C 0B C1 88 44 24 27 F2 0F 10 4C 24 20 F2 0F 11 0A E9 24 01 00 00 66 0F 2F 05 ?? ?? ?? ?? 0F 82 8C 00 00 00 0F 28 C8 F2 0F 59 C8 F2 0F 10 15 ?? ?? ?? ?? F2 0F 59 D1 C1 E1 07 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D1 8B 55 0C F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D1 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D1 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D1 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D1 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D1 F2 0F 59 D0 F2 0F 58 D0 F2 0F 11 54 24 20 0F B6 44 24 27 83 E0 7F 0B C1 88 44 24 27 F2 0F 10 44 24 20 F2 0F 11 02 E9 8A 00 00 00 0F B7 44 24 2E A9 F0 7F 00 00 74 44 F2 0F 10 0D ?? ?? ?? ?? C1 E1 07 F2 0F 58 C8 F2 0F 11 4C 24 08 F2 0F 10 44 24 08 F2 0F 59 44 24 28 F2 0F 11 44 24 20 0F B6 44 24 27 83 E0 7F 8B 55 0C 0B C1 88 44 24 27 F2 0F 10 54 24 20 F2 0F 11 12 EB 3A F2 0F 59 C0 F2 0F 11 44 24 08 F2 0F 10 44 24 08 C1 E1 07 F2 0F 58 44 24 28 F2 0F 11 44 24 20 0F B6 44 24 27 83 E0 7F 8B 55 0C 0B C1 88 44 24 27 F2 0F 10 4C 24 20 F2 0F 11 0A 33 C0 83 C4 34 5B 8B E5 5D C3 F7 40 04 FF FF 0F 00 75 3F 83 38 00 75 3A F2 0F 10 05 ?? ?? ?? ?? 0F B6 40 07 83 E0 80 F2 0F 58 05 ?? ?? ?? ?? F2 0F 11 44 24 20 0F B6 54 24 27 83 E2 7F 8B 4D 0C 0B D0 88 54 24 27 F2 0F 10 4C 24 20 F2 0F 11 09 EB AE F2 0F 10 00 8B 45 0C F2 0F 58 C0 F2 0F 11 00 EB 9D 8D A4 24 00 00 00 00 8D 64 24 00 }
	condition:
		$1
}

rule file_367_0_0 {
	meta:
		name = "___common_slog_cout_rare"
		size = 704
		refs = "003f __imlsLnHATab 0068 _2il0floatpacket_72 025a _2il0floatpacket_73"
	strings:
		$1 = { 55 8B EC 83 E4 F8 83 EC 18 8B 45 08 8B 55 0C 0F B7 48 02 81 E1 80 7F 00 00 81 F9 80 7F 00 00 0F 84 49 02 00 00 F3 0F 5A 28 F2 0F 11 6C 24 10 0F B7 44 24 16 A9 F0 7F 00 00 75 15 F2 0F 59 2D ?? ?? ?? ?? B9 C4 FF FF FF F2 0F 11 6C 24 10 EB 02 33 C9 F2 0F 10 05 ?? ?? ?? ?? 66 0F 2F E8 0F 86 C9 01 00 00 F2 0F 10 1D ?? ?? ?? ?? 0F 28 D5 F2 0F 5C D3 F2 0F 11 54 24 08 80 64 24 0F 7F F2 0F 10 44 24 08 66 0F 2F 05 ?? ?? ?? ?? 0F 86 2E 01 00 00 0F B7 44 24 16 25 F0 7F 00 00 C1 E8 04 F2 0F 11 6C 24 08 F2 0F 10 0D ?? ?? ?? ?? F2 0F 10 25 ?? ?? ?? ?? 8D 8C 01 01 FC FF FF 0F B7 44 24 0E 25 0F 80 FF FF 0D F0 3F FF FF 66 89 44 24 0E F2 0F 10 7C 24 08 0F 28 EF 0F 28 F7 F2 0F 2A D1 F2 0F 58 2D ?? ?? ?? ?? F2 0F 58 35 ?? ?? ?? ?? F2 0F 59 CA F2 0F 59 D4 F2 0F 11 2C 24 8B 0C 24 F2 0F 11 34 24 83 E1 7F F2 0F 10 24 24 F2 0F 5C 25 ?? ?? ?? ?? 8D 04 49 F2 0F 10 04 C5 ?? ?? ?? ?? F2 0F 5C FC F2 0F 59 E0 F2 0F 58 14 C5 ?? ?? ?? ?? F2 0F 58 0C C5 ?? ?? ?? ?? F2 0F 59 C7 F2 0F 5C E3 0F 28 DC 33 C0 F2 0F 10 3D ?? ?? ?? ?? F2 0F 58 D8 F2 0F 58 C2 F2 0F 58 E1 F2 0F 59 FB F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FB F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FB F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FB F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FB F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FB F2 0F 59 DB F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FB F2 0F 58 C7 F2 0F 58 E0 F2 0F 5A E4 F3 0F 11 22 8B E5 5D C3 F2 0F 10 0D ?? ?? ?? ?? 0F 28 C2 F2 0F 59 CA 33 C0 F2 0F 59 C2 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CA F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CA F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CA F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CA F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CA F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 C8 F2 0F 58 D1 F2 0F 5A D2 F3 0F 11 12 8B E5 5D C3 66 0F 2E E8 7A 02 74 15 F2 0F 5E C0 F2 0F 5A C0 F3 0F 11 02 B8 01 00 00 00 8B E5 5D C3 F2 0F 10 0D ?? ?? ?? ?? B8 02 00 00 00 0F 57 0D ?? ?? ?? ?? F2 0F 5E C8 F2 0F 5A C9 F3 0F 11 0A 8B E5 5D C3 0F B6 48 03 F7 C1 80 00 00 00 75 12 F3 0F 10 00 33 C0 F3 0F 59 C0 F3 0F 11 02 8B E5 5D C3 F7 00 FF FF 7F 00 75 E6 F2 0F 10 05 ?? ?? ?? ?? B8 01 00 00 00 F2 0F 5E C0 F2 0F 5A C0 F3 0F 11 02 8B E5 5D C3 8D A4 24 00 00 00 00 8D A4 24 00 00 00 00 90 }
	condition:
		$1
}

rule file_368_0_0 {
	meta:
		name = "___common_dlog_cout_rare"
		size = 688
		refs = "003a __imldLnHATab 0063 _2il0floatpacket_70 0248 _2il0floatpacket_71"
	strings:
		$1 = { 55 8B EC 83 E4 F8 83 EC 18 8B 45 08 0F B7 48 06 8B D1 81 E2 F0 7F 00 00 81 FA F0 7F 00 00 0F 84 3C 02 00 00 F2 0F 10 20 F7 C1 F0 7F 00 00 F2 0F 11 64 24 10 75 15 F2 0F 59 25 ?? ?? ?? ?? BA C4 FF FF FF F2 0F 11 64 24 10 EB 02 33 D2 F2 0F 10 05 ?? ?? ?? ?? 66 0F 2F E0 0F 86 C2 01 00 00 F2 0F 10 05 ?? ?? ?? ?? 0F 28 D4 F2 0F 5C D0 F2 0F 11 54 24 08 80 64 24 0F 7F F2 0F 10 4C 24 08 66 0F 2F 0D ?? ?? ?? ?? 0F 86 2B 01 00 00 F2 0F 11 64 24 08 0F B7 4C 24 0E 81 E1 0F 80 FF FF 81 C9 F0 3F FF FF 66 89 4C 24 0E F2 0F 10 74 24 08 0F 28 E6 0F 28 EE 0F B7 44 24 16 25 F0 7F 00 00 F2 0F 58 25 ?? ?? ?? ?? F2 0F 58 2D ?? ?? ?? ?? C1 E8 04 F2 0F 11 24 24 F2 0F 10 3D ?? ?? ?? ?? F2 0F 10 15 ?? ?? ?? ?? 8B 4D 0C 8D 94 02 01 FC FF FF 8B 04 24 F2 0F 11 2C 24 83 E0 7F F2 0F 10 24 24 F2 0F 2A DA F2 0F 5C 25 ?? ?? ?? ?? F2 0F 59 D3 F2 0F 5C F4 F2 0F 59 1D ?? ?? ?? ?? 8D 14 40 33 C0 F2 0F 10 0C D5 ?? ?? ?? ?? F2 0F 59 E1 F2 0F 58 1C D5 ?? ?? ?? ?? F2 0F 58 14 D5 ?? ?? ?? ?? F2 0F 59 CE F2 0F 5C E0 0F 28 C4 F2 0F 58 E2 F2 0F 58 C1 F2 0F 58 CB F2 0F 59 F8 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 F8 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 F8 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 F8 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 F8 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 F8 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 F8 F2 0F 59 F8 F2 0F 58 CF F2 0F 58 E1 F2 0F 11 21 8B E5 5D C3 F2 0F 10 05 ?? ?? ?? ?? F2 0F 59 C2 8B 45 0C F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C2 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C2 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C2 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C2 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C2 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C2 F2 0F 59 C2 F2 0F 58 D0 F2 0F 11 10 33 C0 8B E5 5D C3 66 0F 2E E0 7A 02 74 14 F2 0F 5E C0 8B 45 0C F2 0F 11 00 B8 01 00 00 00 8B E5 5D C3 F2 0F 10 0D ?? ?? ?? ?? 0F 57 0D ?? ?? ?? ?? F2 0F 5E C8 8B 45 0C F2 0F 11 08 B8 02 00 00 00 8B E5 5D C3 0F B6 50 07 F7 C2 80 00 00 00 75 15 F2 0F 10 00 F2 0F 59 C0 8B 45 0C F2 0F 11 00 33 C0 8B E5 5D C3 F7 40 04 FF FF 0F 00 75 E2 83 38 00 75 DD F2 0F 10 05 ?? ?? ?? ?? F2 0F 5E C0 8B 45 0C F2 0F 11 00 B8 01 00 00 00 8B E5 5D C3 EB 03 CC CC CC }
	condition:
		$1
}

rule file_371_0_0 {
	meta:
		name = "___avx_tanf8"
		size = 4096
		refs = "0013 ___common_stan_data 015d ___common_stan_cout_rare 0204 ___common_stan_reduction_data"
	strings:
		$1 = { 55 8B EC 83 E4 C0 56 57 53 81 EC B4 02 00 00 C5 FC 10 15 ?? ?? ?? ?? C5 FC 54 DA C5 E4 C2 25 ?? ?? ?? ?? 1E C5 EC 55 C8 C5 E9 EF D2 C4 E3 7D 19 E5 01 C5 D9 6B F5 C5 C9 63 FA C5 F9 D7 C7 84 C0 0F 85 20 01 00 00 C5 FC 10 25 ?? ?? ?? ?? 33 DB C5 E4 59 15 ?? ?? ?? ?? C5 EC 58 EC C5 D4 5C F4 C5 CC 59 3D ?? ?? ?? ?? C5 CC 59 25 ?? ?? ?? ?? C5 CC 59 15 ?? ?? ?? ?? C5 CC 59 35 ?? ?? ?? ?? C5 E4 5C DF C5 E4 5C FC C5 C4 5C DA C5 E4 5C D6 C5 EC 59 DA C5 D9 72 F5 1F C4 E3 7D 19 EF 01 C5 D1 72 F5 1E C5 C9 72 F7 1F C5 C1 72 F7 1E C4 E3 5D 18 E6 01 C5 DC 57 C9 C5 E4 59 35 ?? ?? ?? ?? C4 E3 55 18 E7 01 C5 C4 57 FF C5 DC C2 FF 0C C5 CC 58 2D ?? ?? ?? ?? C5 E4 59 25 ?? ?? ?? ?? C5 D4 59 F2 C5 DC 58 25 ?? ?? ?? ?? C5 DC 59 D3 C5 EC 58 2D ?? ?? ?? ?? C5 C4 55 DE C5 C4 54 E5 C5 E4 56 E4 C5 C4 54 D6 C5 C4 55 DD C5 EC 56 EB C5 DC 5E F5 C5 CC 57 D1 84 DB 75 11 C5 FC 28 C2 81 C4 B4 02 00 00 5B 5F 5E 8B E5 5D C3 C5 FC 11 04 24 C5 FC 11 54 24 40 85 DB 74 E0 33 F6 0F A3 F3 72 0E 46 83 FE 20 7C F5 C5 FC 10 54 24 40 EB CB C5 F8 77 8D 44 B4 40 8D 14 B4 50 52 E8 ?? ?? ?? ?? 83 C4 08 EB DC B8 00 00 80 7F C5 FC 11 44 24 20 C5 F9 6E D8 C5 F9 70 EB 00 C4 E3 55 18 E5 01 C5 FC 54 DC C5 E4 C2 F4 00 C4 E3 7D 19 F7 01 C5 C9 6B DF C5 E1 63 D2 C5 F9 D7 F2 C4 E3 7D 19 C3 01 89 B4 24 90 02 00 00 C5 F8 11 5C 24 70 C5 F8 28 C8 C5 D1 DB D1 C5 D9 72 D2 17 C5 D1 DB D3 C5 D1 72 D2 17 C5 E9 72 F4 01 C5 E9 FE D4 C5 D9 72 F2 02 C5 E9 72 F5 01 C5 F9 7E E6 C5 E9 FE D5 C5 E9 72 F2 02 C5 F8 11 4C 24 60 C4 E3 79 16 E1 01 C4 E3 79 16 E0 02 C4 E3 79 16 E3 03 C5 F9 7E D7 C5 F9 6E A1 ?? ?? ?? ?? C4 E3 79 16 94 24 A8 02 00 00 01 C4 E3 79 16 94 24 AC 02 00 00 02 C4 E3 79 16 D2 03 C5 F9 6E 96 ?? ?? ?? ?? C5 E9 6C EC C5 F9 6E 90 ?? ?? ?? ?? C5 F9 6E A3 ?? ?? ?? ?? C5 E9 6C D4 89 BC 24 A4 02 00 00 C5 D0 C6 F2 88 C5 F9 6E 97 ?? ?? ?? ?? 8B BC 24 A8 02 00 00 89 9C 24 A0 02 00 00 C5 F9 6E 82 ?? ?? ?? ?? C5 F9 6E A7 ?? ?? ?? ?? 8B BC 24 AC 02 00 00 C5 E9 6C EC C5 F9 6E A2 ?? ?? ?? ?? C5 F9 6E 97 ?? ?? ?? ?? C5 E9 6C D4 C5 D0 C6 EA 88 C5 F9 6E 96 ?? ?? ?? ?? C5 F9 6E A1 ?? ?? ?? ?? C5 E9 6C FC C5 F9 6E A3 ?? ?? ?? ?? 8B 9C 24 A4 02 00 00 C5 F9 6E 90 ?? ?? ?? ?? C5 E9 6C D4 C5 C0 C6 FA 88 C5 F9 6E 93 ?? ?? ?? ?? 8B 9C 24 A8 02 00 00 C5 F8 11 B4 24 80 00 00 00 C5 F8 11 AC 24 90 00 00 00 C5 F9 6E A3 ?? ?? ?? ?? C5 E9 6C D4 C5 F9 6E A7 ?? ?? ?? ?? C5 D9 6C E0 C5 E8 C6 D4 88 C5 F9 6E A1 ?? ?? ?? ?? 8B 8C 24 A0 02 00 00 C5 F8 11 94 24 A0 00 00 00 C5 F9 6E 96 ?? ?? ?? ?? BE 00 00 80 00 C5 E9 6C E4 C5 F9 6E 90 ?? ?? ?? ?? 8B 84 24 A4 02 00 00 C5 F9 6E 81 ?? ?? ?? ?? B9 00 00 00 80 C5 E9 6C D0 C5 D8 C6 E2 88 C5 F9 6E 82 ?? ?? ?? ?? BA FF FF 7F 00 C5 F8 11 A4 24 B0 00 00 00 C5 F9 6E 90 ?? ?? ?? ?? B8 00 00 40 47 C5 F9 6E A3 ?? ?? ?? ?? BB 00 00 80 3F C5 E9 6C D4 C5 F9 6E A7 ?? ?? ?? ?? BF FF FF 00 00 C5 D9 6C E0 C5 E8 C6 C4 88 C5 F9 6E D2 C5 F9 70 D2 00 C5 F9 6E E6 C5 F9 70 E4 00 C5 E9 DB DB C5 E9 DB C9 C5 E1 FE D4 C5 F9 6E DF C5 F1 FE CC C5 F9 70 DB 00 BA FF 00 00 00 C5 C9 DB E3 C5 D1 DB F3 C5 D1 72 D7 10 C5 C1 DB FB C5 FA 7F AC 24 F0 00 00 00 BE 00 00 80 28 C5 F8 10 AC 24 A0 00 00 00 BF FF FF 03 00 C5 FA 7F B4 24 E0 00 00 00 C5 C9 72 D5 10 C5 D1 DB EB C5 FA 7F AC 24 30 01 00 00 C5 F8 10 AC 24 B0 00 00 00 C5 F8 11 84 24 C0 00 00 00 C5 F9 72 D0 10 C5 FA 7F 84 24 50 01 00 00 C5 F9 72 D1 10 C5 F1 DB CB C5 D1 72 D5 10 C5 FA 7F AC 24 40 01 00 00 C5 D1 72 D2 10 C5 E9 DB D3 C5 FA 7F A4 24 D0 00 00 00 C4 E2 71 40 E4 C5 FA 7F A4 24 90 01 00 00 C4 E2 69 40 A4 24 E0 00 00 00 C5 FA 7F BC 24 10 01 00 00 C4 E2 71 40 FF C5 FA 7F A4 24 A0 01 00 00 C4 E2 71 40 A4 24 F0 00 00 00 C5 FA 7F B4 24 00 01 00 00 C4 E2 69 40 F6 C5 FA 7F BC 24 D0 01 00 00 C5 FA 7F B4 24 C0 01 00 00 C5 C1 DB F3 C5 FA 6F BC 24 40 01 00 00 C5 FA 7F A4 24 B0 01 00 00 C5 FA 7F 94 24 80 01 00 00 C4 E2 69 40 A4 24 30 01 00 00 C5 E1 DB 94 24 B0 00 00 00 C5 FA 7F 8C 24 70 01 00 00 C4 E2 71 40 CF C5 FA 7F 84 24 60 01 00 00 C4 E2 79 40 D2 C4 E2 79 40 C7 C5 C1 72 D1 10 C5 F9 FE C7 C5 E9 72 D2 10 C5 C9 FE C8 C5 D9 DB C3 C5 E9 FE F1 C5 E1 DB 94 24 C0 00 00 00 C4 E2 51 40 FA C5 FA 7F A4 24 E0 01 00 00 C5 F1 72 D7 10 C5 FA 6F BC 24 50 01 00 00 C5 FA 6F A4 24 80 01 00 00 C4 E2 59 40 E7 C4 E2 51 40 D7 C5 D9 72 D4 10 C5 E9 FE D4 C5 D9 72 D6 10 C5 FA 7F B4 24 F0 01 00 00 C5 F9 FE C2 C5 FA 6F 94 24 60 01 00 00 C5 F1 FE C8 C5 FA 6F B4 24 D0 01 00 00 C4 E2 69 40 BC 24 10 01 00 00 C5 C9 72 D6 10 C5 E1 DB 84 24 B0 01 00 00 C5 C1 FE FE C5 F9 FE C7 C5 FA 6F BC 24 E0 01 00 00 C5 D9 FE C0 C4 E2 51 40 B4 24 30 01 00 00 C5 C1 72 D7 10 C5 FA 7F 8C 24 00 02 00 00 C5 D9 72 D1 10 C5 E1 DB 8C 24 C0 01 00 00 C5 C9 FE F7 C5 F1 FE CE C5 D9 FE F1 C5 FA 6F A4 24 B0 01 00 00 C4 E2 69 40 8C 24 F0 00 00 00 C5 D9 72 D4 10 C5 FA 7F B4 24 20 02 00 00 C5 F1 FE CC C5 E1 DB BC 24 90 01 00 00 C5 D9 72 D6 10 C5 FA 6F B4 24 C0 01 00 00 C5 C1 FE F9 C4 E2 51 40 8C 24 00 01 00 00 C5 C9 72 D6 10 C5 FA 7F 84 24 10 02 00 00 C5 F9 72 D0 10 C5 F9 FE FF C5 F1 FE CE C5 E1 DB 84 24 A0 01 00 00 C5 C9 72 D7 10 C5 F9 FE C1 C5 C1 DB FB C5 D9 FE C8 C5 F8 10 84 24 80 00 00 00 C5 FA 6F A4 24 70 01 00 00 C5 F9 72 D0 10 C4 E2 59 40 E0 C4 E2 69 40 84 24 D0 00 00 00 C5 D9 DB E3 C5 FA 6F 94 24 90 01 00 00 C5 E9 72 D2 10 C5 F9 FE C2 C5 D9 FE E0 C5 C9 FE F4 C5 D9 72 D1 10 C5 F8 10 94 24 90 00 00 00 C5 F9 72 F6 10 C5 FA 6F B4 24 80 01 00 00 C5 F9 FE C7 C5 C1 72 D2 10 C5 F1 DB CB C4 E2 49 40 D7 C4 E2 51 40 B4 24 E0 00 00 00 C5 E9 DB D3 C5 FA 6F AC 24 A0 01 00 00 C5 D1 72 D5 10 C5 C9 FE FD C5 E9 FE D7 C5 D9 FE E2 C5 E9 72 F4 10 C5 E9 FE E9 C5 FA 6F 8C 24 10 02 00 00 C5 E1 DB A4 24 F0 01 00 00 C5 E9 72 F1 10 C5 FA 6F B4 24 20 02 00 00 C5 F9 6E C9 C5 E9 FE D4 C5 C1 72 F6 10 C5 F9 70 E1 00 C5 F9 6E F3 C5 E1 DB 9C 24 00 02 00 00 B9 00 00 00 34 C5 D9 DB 4C 24 60 C5 C1 FE DB C5 F9 70 F6 00 BB FF 01 00 00 C5 D9 DB 64 24 70 C5 F1 EF FE C5 FA 7F 84 24 30 02 00 00 C5 F9 72 D0 09 C5 FA 7F AC 24 40 02 00 00 C5 D1 72 D5 09 C5 FA 7F B4 24 20 01 00 00 C5 D9 EF F6 C5 F9 EB C7 C5 D1 EB EE C4 E3 7D 18 ED 01 C5 F9 6E C0 C5 F9 70 F0 00 B8 DB 0F C9 40 C4 E3 4D 18 FE 01 C5 C4 58 C5 C5 FC 5C F7 C5 F9 6E FA C5 D4 5C EE BA 00 10 C9 40 C5 FC 11 6C 24 40 C5 F9 6E EE C5 F9 70 F5 00 C5 D9 EF EE BE 7A 77 95 B7 C5 F8 11 84 24 50 02 00 00 C4 E3 7D 19 84 24 60 02 00 00 01 C5 F9 70 C7 00 C5 F9 6E FF C5 F9 70 FF 00 BF 00 F0 FF FF C5 FA 7F 84 24 70 02 00 00 C5 F1 EF C6 C5 C1 DB F2 C5 C1 DB FB C5 C9 72 F6 05 C5 C1 72 F7 05 C5 C9 EB F0 C5 C1 EB FD C5 E9 72 D2 12 C5 E1 72 D3 12 C4 E3 7D 18 ED 01 C5 F9 6E C1 B9 FF FF FF 7F C4 E3 4D 18 FF 01 C5 F9 70 F0 00 C5 C4 5C FD C5 F1 EF EE C5 F9 6E CB C5 D9 EF E6 C5 F9 70 C1 00 C5 F9 DB 8C 24 30 02 00 00 BB 00 00 80 35 C5 F9 DB 84 24 40 02 00 00 C5 C9 72 F1 0E C5 C9 EB CA C5 E9 72 F0 0E C5 E9 EB C3 C5 F1 EB CD C5 F9 EB D4 C4 E3 55 18 DC 01 C5 FC 10 64 24 40 C4 E3 75 18 CA 01 C5 F4 5C C3 C5 DC 58 F0 C5 DC 5C CE C5 F9 6E E2 C5 F9 70 EC 00 C5 FC 58 D1 C5 F9 6E CE C5 F9 70 E1 00 C5 EC 58 D7 C5 F9 6E F8 C5 F9 70 C7 00 C5 F9 6E FF C5 F9 70 CF 00 B8 7F 00 00 00 C4 E3 7D 18 D8 01 C4 E3 55 18 C5 01 C4 E3 75 18 E9 01 C5 CC 54 CD C5 CC 5C F1 C5 FC 11 2C 24 C5 FC 59 F9 C5 FC 59 EE C5 E4 59 DA C4 E3 5D 18 E4 01 C5 DC 59 C1 C5 DC 59 F6 C5 D4 58 C0 C5 F9 6E E9 C5 E4 58 CE C5 F9 70 F5 00 C5 FC 58 D9 C5 C4 58 E3 C5 C4 5C D4 C5 F9 6E FB C5 F9 70 C7 00 C5 EC 58 DB C4 E3 4D 18 D6 01 C4 E3 7D 18 F0 01 C5 FC 10 44 24 20 C5 FC 54 EA C5 D4 C2 D6 1E C5 D4 C2 FE 12 C5 EC 54 E4 C5 EC 54 F3 C5 F9 6E D0 C5 FA 6F 9C 24 70 02 00 00 C5 C4 54 E8 C5 F9 70 FA 00 C5 E1 DB 94 24 50 02 00 00 C5 D4 56 EC C5 E9 DB E7 C5 E1 DB 94 24 60 02 00 00 C5 D4 58 CE C5 E9 DB DF C5 C9 72 F4 02 C5 D1 72 F3 02 C5 C9 FE E4 C5 D1 FE D3 C5 D9 72 F4 03 C5 E1 72 F2 03 C5 F9 7E E7 C5 F9 7E D9 C4 E3 79 16 E3 01 C5 F9 6E AF ?? ?? ?? ?? C4 E3 79 16 9C 24 98 02 00 00 01 89 8C 24 94 02 00 00 C5 F9 6E B3 ?? ?? ?? ?? C4 E3 79 16 9C 24 9C 02 00 00 02 C4 E3 79 16 D8 03 C5 D1 6C DE C5 F9 6E A9 ?? ?? ?? ?? C4 E3 79 16 E2 02 C4 E3 79 16 E6 03 8B 8C 24 98 02 00 00 89 BC 24 84 02 00 00 C5 F9 6E BA ?? ?? ?? ?? C5 F9 6E B1 ?? ?? ?? ?? 8B 8C 24 9C 02 00 00 C5 F9 6E 96 ?? ?? ?? ?? C5 C1 6C E2 C5 E0 C6 D4 88 C5 F9 6E B9 ?? ?? ?? ?? C5 F9 6E 98 ?? ?? ?? ?? C5 D1 6C E6 C5 C1 6C EB 89 94 24 8C 02 00 00 C5 D8 C6 F5 88 C5 F9 6E BF ?? ?? ?? ?? C5 F9 6E A2 ?? ?? ?? ?? 8B BC 24 94 02 00 00 8B 94 24 98 02 00 00 C5 F9 6E 9B ?? ?? ?? ?? C5 F9 6E AE ?? ?? ?? ?? 89 9C 24 88 02 00 00 8B 98 ?? ?? ?? ?? 89 9C 24 80 02 00 00 8B 9C 24 90 02 00 00 C4 E3 6D 18 D6 01 C5 C1 6C F3 C5 D9 6C FD C5 C8 C6 DF 88 C5 F9 6E A7 ?? ?? ?? ?? C5 F9 6E AA ?? ?? ?? ?? C5 D9 6C ED C5 F9 6E A1 ?? ?? ?? ?? 89 9C 24 90 02 00 00 8B 9C 24 84 02 00 00 C5 FC 11 44 24 20 C5 F9 6E 84 24 80 02 00 00 C5 D9 6C F8 C5 D0 C6 F7 88 C5 F9 6E AB ?? ?? ?? ?? 8B 9C 24 88 02 00 00 C4 E3 65 18 C6 01 C5 F9 6E BE ?? ?? ?? ?? C5 F9 6E A3 ?? ?? ?? ?? 8B 9C 24 8C 02 00 00 C5 D1 6C F4 89 84 24 34 01 00 00 C5 F9 6E 9B ?? ?? ?? ?? C5 E1 6C EF C5 C8 C6 F5 88 C5 F9 6E A8 ?? ?? ?? ?? 8B 84 24 84 02 00 00 C5 F9 6E A7 ?? ?? ?? ?? C5 F9 6E 9A ?? ?? ?? ?? C5 F9 6E B9 ?? ?? ?? ?? C5 D9 6C E3 C5 C1 6C DD C5 F9 6E A8 ?? ?? ?? ?? 8B 84 24 88 02 00 00 C5 D8 C6 FB 88 C5 F9 6E 9B ?? ?? ?? ?? C5 F9 6E A0 ?? ?? ?? ?? C5 D1 6C EC 89 8C 24 9C 02 00 00 89 94 24 98 02 00 00 89 BC 24 94 02 00 00 89 B4 24 30 01 00 00 C4 E3 4D 18 F7 01 C5 F9 6E BE ?? ?? ?? ?? C5 E1 6C E7 C5 D0 C6 DC 88 C5 F9 6E BF ?? ?? ?? ?? C5 F9 6E AA ?? ?? ?? ?? C5 C1 6C E5 C5 F9 6E B9 ?? ?? ?? ?? 8B 8C 24 34 01 00 00 C5 F9 6E A9 ?? ?? ?? ?? C5 C1 6C FD 8B 8C 24 84 02 00 00 C5 D8 C6 E7 88 C4 E3 65 18 DC 01 C5 FC 11 5C 24 40 C5 F9 6E B9 ?? ?? ?? ?? C5 F9 6E A8 ?? ?? ?? ?? C5 F9 6E A3 ?? ?? ?? ?? C5 C1 6C FD C5 F9 6E 9E ?? ?? ?? ?? C5 D9 6C EB C5 F9 6E 9A ?? ?? ?? ?? 8B 94 24 9C 02 00 00 C5 F9 6E A7 ?? ?? ?? ?? C5 C0 C6 ED 88 C5 D9 6C FB C5 F9 6E A2 ?? ?? ?? ?? 8B 94 24 34 01 00 00 C5 F9 6E 9A ?? ?? ?? ?? C5 D9 6C E3 C5 C0 C6 FC 88 C4 E3 55 18 EF 01 C5 FC 11 6C 24 60 C5 F9 6E B9 ?? ?? ?? ?? C5 F9 6E A8 ?? ?? ?? ?? C5 F9 6E A3 ?? ?? ?? ?? C5 C1 6C FD C5 F9 6E 9E ?? ?? ?? ?? C5 D9 6C EB C5 F9 6E A7 ?? ?? ?? ?? 8B BC 24 98 02 00 00 C5 C0 C6 DD 88 C5 F9 6E AA ?? ?? ?? ?? C5 F9 6E BF ?? ?? ?? ?? 8B BC 24 9C 02 00 00 C5 D9 6C E7 C5 F9 6E BF ?? ?? ?? ?? C5 C1 6C FD C5 D8 C6 E7 88 C5 F9 6E B9 ?? ?? ?? ?? C5 F9 6E A8 ?? ?? ?? ?? C5 C1 6C FD C4 E3 65 18 DC 01 C5 FC 11 9C 24 80 00 00 00 C5 F9 6E 9E ?? ?? ?? ?? C5 F9 6E A3 ?? ?? ?? ?? C5 D9 6C EB C5 C0 C6 ED 88 8B B4 24 94 02 00 00 C5 F9 6E A6 ?? ?? ?? ?? 8B B4 24 98 02 00 00 C5 F9 6E 9E ?? ?? ?? ?? C5 D9 6C FB C5 F9 6E A7 ?? ?? ?? ?? C5 F9 6E 9A ?? ?? ?? ?? C5 D9 6C E3 C5 C0 C6 FC 88 C5 F9 6E A3 ?? ?? ?? ?? 8B 9C 24 30 01 00 00 C4 E3 55 18 EF 01 C5 FC 11 AC 24 A0 00 00 00 C5 F9 6E 9B ?? ?? ?? ?? C5 F9 6E B9 ?? ?? ?? ?? C5 F9 6E A8 ?? ?? ?? ?? C5 C1 6C FD 8B 9C 24 94 02 00 00 C5 D9 6C EB C5 C0 C6 DD 88 C5 F9 6E A3 ?? ?? ?? ?? C5 F9 6E BE ?? ?? ?? ?? C5 D9 6C E7 C5 F9 6E BF ?? ?? ?? ?? C5 F9 6E AA ?? ?? ?? ?? C5 C1 6C FD C5 F9 6E A8 ?? ?? ?? ?? 8B 84 24 8C 02 00 00 C5 D8 C6 E7 88 C5 F9 6E B9 ?? ?? ?? ?? C5 C1 6C FD C4 E3 65 18 DC 01 C5 F9 6E A0 ?? ?? ?? ?? 8B 84 24 30 01 00 00 C5 FC 11 9C 24 C0 00 00 00 C5 F9 6E 98 ?? ?? ?? ?? C5 D9 6C EB C5 C0 C6 ED 88 C5 F9 6E A3 ?? ?? ?? ?? C5 F9 6E 9E ?? ?? ?? ?? C5 D9 6C FB C5 F9 6E A7 ?? ?? ?? ?? C5 F9 6E 9A ?? ?? ?? ?? C5 D9 6C E3 C5 C0 C6 FC 88 C5 F9 6E 98 ?? ?? ?? ?? C4 E3 55 18 EF 01 C5 F9 6E B9 ?? ?? ?? ?? 8B 8C 24 88 02 00 00 C5 FC 11 AC 24 E0 00 00 00 C5 F9 6E A9 ?? ?? ?? ?? C5 C1 6C FD 8B 8C 24 8C 02 00 00 C5 F9 6E A1 ?? ?? ?? ?? C5 D9 6C EB C5 C0 C6 DD 88 C5 F9 6E A3 ?? ?? ?? ?? C5 F9 6E BE ?? ?? ?? ?? C5 D9 6C E7 C5 F9 6E BF ?? ?? ?? ?? C5 F9 6E AA ?? ?? ?? ?? C5 C1 6C FD C5 D8 C6 E7 88 C5 EC 5C E9 C5 EC 5C D5 C5 EC 5C D1 8B 9C 24 90 02 00 00 C4 E3 65 18 DC 01 C5 FC 11 9C 24 00 01 00 00 C5 FC 10 1C 24 C5 D4 54 E3 C5 D4 5C EC C5 D4 58 C0 C5 EC 58 E8 C5 FC 53 D4 C5 EC 54 D3 C5 DC 59 E2 C4 E2 7D 1A BC 24 20 01 00 00 C5 C4 5C C4 C5 EC 59 D8 C5 FC 59 E0 C5 E4 58 DA C5 DC 58 FF C5 E4 59 E7 C5 D4 59 FC C5 C4 59 EF C5 C4 5C C0 C5 D4 5C F8 C5 EC 59 EE C5 FC 10 54 24 40 C5 C4 59 C4 C5 F4 59 A4 24 80 00 00 00 C5 FC 59 FE C5 EC 58 F4 C5 EC 5C DE C5 CC 58 D5 C5 E4 58 C4 C5 D4 5C EA C5 F4 59 9C 24 00 01 00 00 C5 F4 59 E1 C5 FC 58 FF C5 D4 58 F6 C5 E4 58 AC 24 E0 00 00 00 C5 F4 59 84 24 C0 00 00 00 C5 C4 58 FE C5 DC 59 F5 C5 FC 58 84 24 A0 00 00 00 C5 C4 58 7C 24 60 C5 CC 58 D8 C5 E4 59 C9 C5 F4 58 C7 C5 EC 58 D0 C5 FC 10 44 24 20 E9 23 F1 FF FF 8D A4 24 00 00 00 00 EB 03 CC CC CC }
	condition:
		$1
}

rule file_374_0_0 {
	meta:
		name = "@_RTC_AllocaHelper@12"
		size = 50
	strings:
		$1 = { 55 8B EC 53 56 8B F1 8B DA 85 F6 74 1F 85 DB 74 1B 8B 55 08 85 D2 74 14 57 B0 CC 8B FE 8B CB F3 AA 8B 02 89 46 04 89 5E 0C 89 32 5F 5E 5B 5D C2 04 00 }
	condition:
		$1
}

rule file_374_1_0 {
	meta:
		name = "@_RTC_CheckStackVars2@12"
		size = 209
		refs = "004e ?_RTC_StackFailure@@YAXPAXPBD@Z 009e ?_RTC_AllocaFailure@@YAXPAXPAU_RTC_ALLOCA_NODE@@H@Z"
	strings:
		$1 = { 55 8B EC 51 53 8B DA 89 4D FC 56 57 85 DB 74 4D 33 F6 39 33 7E 47 33 FF EB 06 8D 9B 00 00 00 00 8B 4B 04 8B 45 FC 8B 14 39 81 7C 02 FC CC CC CC CC 75 12 8B 44 39 04 03 C2 8B 55 FC 81 3C 10 CC CC CC CC 74 10 FF 74 39 08 8B 45 04 50 E8 ?? ?? ?? ?? 83 C4 08 46 83 C7 0C 3B 33 7C C3 8B 75 08 33 FF 8B C6 85 F6 74 60 8B 40 04 47 85 C0 75 F8 85 F6 74 54 81 3E CC CC CC CC 75 1B 81 7E 14 CC CC CC CC 75 12 81 7E 18 CC CC CC CC 75 09 81 7E 1C CC CC CC CC 74 0E 8B 45 04 57 56 50 E8 ?? ?? ?? ?? 83 C4 0C 8B 46 0C 81 7C 30 FC CC CC CC CC 74 0E 8B 45 04 57 56 50 E8 ?? ?? ?? ?? 83 C4 0C 8B 76 04 4F 85 F6 75 AC 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_374_2_0 {
	meta:
		name = "@_RTC_CheckStackVars@8"
		size = 88
		refs = "0042 ?_RTC_StackFailure@@YAXPAXPBD@Z"
	strings:
		$1 = { 55 8B EC 51 53 8B DA 89 4D FC 56 33 F6 39 33 7E 41 57 33 FF 8B 4B 04 8B 45 FC 8B 14 39 81 7C 02 FC CC CC CC CC 75 12 8B 44 39 04 03 C2 8B 55 FC 81 3C 10 CC CC CC CC 74 10 FF 74 39 08 8B 45 04 50 E8 ?? ?? ?? ?? 83 C4 08 46 83 C7 0C 3B 33 7C C3 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_374_3_0 {
	meta:
		name = "__RTC_CheckEsp"
		size = 49
		refs = "001b ?_RTC_Failure@@YAXPAXH@Z"
	strings:
		$1 = { F2 75 02 F2 C3 55 8B EC 83 EC 00 50 0F 1B 04 04 52 53 56 57 8B 45 04 6A 00 50 E8 ?? ?? ?? ?? 83 C4 08 5F 5E 5B 5A 58 0F 1A 44 04 FC 8B E5 5D F2 C3 }
	condition:
		$1
}

rule file_382_0_0 {
	meta:
		name = "__SEH_prolog4_GS"
		size = 73
		refs = "0001 __except_handler4 001e ___security_cookie"
	strings:
		$1 = { 68 ?? ?? ?? ?? 64 FF 35 00 00 00 00 8B 44 24 10 89 6C 24 10 8D 6C 24 10 2B E0 53 56 57 A1 ?? ?? ?? ?? 31 45 FC 33 C5 89 45 E4 50 89 65 E8 FF 75 F8 8B 45 FC C7 45 FC FE FF FF FF 89 45 F8 8D 45 F0 64 A3 00 00 00 00 F2 C3 }
	condition:
		$1
}

rule file_382_1_0 {
	meta:
		name = "__SEH_epilog4_GS"
		size = 17
		refs = "0007 @__security_check_cookie@4 000d __SEH_epilog4"
	strings:
		$1 = { 8B 4D E4 33 CD F2 E8 ?? ?? ?? ?? F2 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_385_0_0 {
	meta:
		name = "___avx_floor4"
		size = 16
	strings:
		$1 = { C4 E3 7D 09 C0 01 C3 8D A4 24 00 00 00 00 8B FF }
	condition:
		$1
}

rule file_386_0_0 {
	meta:
		name = "___sse4_ceil2"
		size = 16
	strings:
		$1 = { 66 0F 3A 09 C0 02 C3 8D A4 24 00 00 00 00 8B FF }
	condition:
		$1
}

rule file_388_0_0 {
	meta:
		name = "___common_dsinh_cout_rare"
		size = 1888
		refs = "0012 __vmldSinhHATab 00f9 _2il0floatpacket_88"
	strings:
		$1 = { 55 8B EC 83 E4 F8 56 53 83 EC 78 8B 4D 08 F2 0F 10 15 ?? ?? ?? ?? 0F B7 05 ?? ?? ?? ?? 0F B7 59 06 81 E3 F0 7F 00 00 C1 EB 04 F2 0F 10 19 81 FB FF 07 00 00 0F B6 51 07 F2 0F 11 5C 24 70 0F 84 03 07 00 00 85 DB 0F 8E C5 06 00 00 8B CA 83 E1 7F F2 0F 11 5C 24 10 81 FB C9 03 00 00 88 4C 24 17 0F 8E 84 06 00 00 F2 0F 10 44 24 10 F2 0F 10 0D ?? ?? ?? ?? 66 0F 2F C8 0F 86 4B 06 00 00 F2 0F 10 0D ?? ?? ?? ?? 66 0F 2F C8 0F 86 EA 04 00 00 66 0F 2F 05 ?? ?? ?? ?? 0F 82 69 04 00 00 F2 0F 10 3D ?? ?? ?? ?? 25 0F 80 FF FF F2 0F 59 F8 83 E2 80 F2 0F 10 0D ?? ?? ?? ?? F2 0F 11 54 24 68 F2 0F 58 3D ?? ?? ?? ?? F2 0F 11 7C 24 50 F2 0F 10 64 24 50 8B 5C 24 50 8B F3 C1 EE 06 83 E3 3F C1 E3 04 F2 0F 5C 25 ?? ?? ?? ?? F2 0F 59 CC 8D 8E FF 03 00 00 0F 57 25 ?? ?? ?? ?? 81 C6 FE 03 00 00 F2 0F 59 25 ?? ?? ?? ?? F2 0F 5C C1 0F 28 D0 0F 28 D8 81 E6 FF 07 00 00 F7 D9 C1 E6 04 83 C1 FC 0B C6 81 E1 FF 07 00 00 66 89 44 24 6E 25 0F 80 FF FF C1 E1 04 F2 0F 58 D4 F2 0F 11 54 24 60 0B C1 F2 0F 10 6C 24 60 F2 0F 5C DD F2 0F 11 1C 24 F2 0F 10 6C 24 60 F2 0F 10 34 24 F2 0F 58 EE F2 0F 11 6C 24 08 F2 0F 10 3C 24 F2 0F 58 E7 F2 0F 11 24 24 F2 0F 10 64 24 08 F2 0F 5C C4 F2 0F 10 25 ?? ?? ?? ?? F2 0F 11 44 24 08 F2 0F 10 34 24 F2 0F 10 44 24 08 F2 0F 58 F0 F2 0F 11 74 24 08 F2 0F 10 74 24 60 0F 28 FE F2 0F 59 FC F2 0F 10 6C 24 08 F2 0F 11 7C 24 60 F2 0F 10 4C 24 60 F2 0F 11 74 24 10 F2 0F 5C CE F2 0F 11 0C 24 F2 0F 10 54 24 60 F2 0F 10 04 24 F2 0F 10 0D ?? ?? ?? ?? F2 0F 5C D0 F2 0F 11 54 24 60 0F 28 D6 F2 0F 59 D6 F2 0F 59 CA F2 0F 11 6C 24 18 0F 28 EE F2 0F 10 5C 24 60 F2 0F 58 0D ?? ?? ?? ?? F2 0F 5C EB F2 0F 59 CA F2 0F 59 CE F2 0F 10 35 ?? ?? ?? ?? F2 0F 59 F2 F2 0F 11 2C 24 F2 0F 10 7C 24 60 F2 0F 10 04 24 F2 0F 11 44 24 28 F2 0F 10 83 ?? ?? ?? ?? F2 0F 10 5C 24 68 66 89 44 24 6E F2 0F 11 4C 24 30 F2 0F 59 C3 F2 0F 58 35 ?? ?? ?? ?? F2 0F 59 F2 0F 28 E8 F2 0F 11 7C 24 20 F2 0F 58 35 ?? ?? ?? ?? F2 0F 59 F2 F2 0F 10 93 ?? ?? ?? ?? F7 DB F2 0F 11 74 24 38 F2 0F 10 74 24 68 F2 0F 59 D3 F2 0F 10 8B ?? ?? ?? ?? F2 0F 59 CE F2 0F 10 9B ?? ?? ?? ?? F2 0F 5C E9 F2 0F 59 DE F2 0F 11 6C 24 60 0F 28 F0 F2 0F 10 7C 24 60 F2 0F 5C F7 F2 0F 5C F1 F2 0F 11 34 24 F2 0F 10 74 24 60 F2 0F 10 2C 24 0F 28 FE F2 0F 5C EB F2 0F 58 EA F2 0F 58 D3 F2 0F 58 FD F2 0F 11 7C 24 60 F2 0F 10 7C 24 60 F2 0F 5C F7 0F 28 F8 F2 0F 58 F9 F2 0F 58 F5 F2 0F 11 34 24 F2 0F 10 6C 24 60 F2 0F 10 34 24 F2 0F 11 7C 24 60 F2 0F 10 7C 24 60 F2 0F 5C C7 F2 0F 58 C1 F2 0F 11 04 24 F2 0F 10 7C 24 60 F2 0F 10 04 24 0F 28 CF F2 0F 58 D0 F2 0F 58 CA F2 0F 11 4C 24 60 F2 0F 10 5C 24 60 F2 0F 5C FB F2 0F 58 FA F2 0F 11 3C 24 F2 0F 10 7C 24 60 F2 0F 59 E7 0F 28 DF F2 0F 10 0C 24 F2 0F 11 64 24 60 F2 0F 10 64 24 60 F2 0F 5C E7 F2 0F 11 24 24 F2 0F 10 44 24 60 F2 0F 10 24 24 F2 0F 5C C4 F2 0F 11 44 24 60 F2 0F 10 54 24 60 F2 0F 5C DA F2 0F 11 1C 24 F2 0F 10 64 24 60 F2 0F 10 04 24 F2 0F 10 5C 24 18 F2 0F 11 44 24 48 0F 28 D3 F2 0F 11 64 24 40 0F 28 E1 F2 0F 10 44 24 30 F2 0F 59 D1 F2 0F 59 E0 F2 0F 59 C7 F2 0F 59 DF F2 0F 58 D4 0F 28 E6 0F 28 F8 F2 0F 59 64 24 38 F2 0F 58 D4 F2 0F 10 64 24 10 F2 0F 59 E1 F2 0F 58 D4 F2 0F 10 64 24 38 F2 0F 59 E5 F2 0F 58 D3 F2 0F 58 FC F2 0F 58 F2 F2 0F 11 7C 24 60 F2 0F 10 4C 24 60 F2 0F 10 5C 24 48 F2 0F 5C C1 F2 0F 10 4C 24 28 F2 0F 58 C4 F2 0F 11 04 24 0F 28 C1 F2 0F 10 64 24 60 F2 0F 10 14 24 F2 0F 59 C3 F2 0F 58 F2 F2 0F 10 7C 24 20 F2 0F 58 F0 F2 0F 59 DF F2 0F 10 54 24 40 F2 0F 58 F3 F2 0F 59 FA F2 0F 59 CA 0F 28 C7 F2 0F 58 F1 F2 0F 58 C4 F2 0F 11 44 24 60 0F 28 C5 F2 0F 10 4C 24 60 F2 0F 5C F9 F2 0F 58 FC F2 0F 11 3C 24 F2 0F 10 4C 24 60 F2 0F 10 3C 24 F2 0F 58 C1 F2 0F 58 F7 F2 0F 11 44 24 60 F2 0F 10 7C 24 60 F2 0F 5C EF F2 0F 58 E9 F2 0F 11 2C 24 F2 0F 10 44 24 60 F2 0F 10 2C 24 F2 0F 58 F5 F2 0F 58 F0 F2 0F 11 74 24 58 0F B6 44 24 5F 83 E0 7F 0B C2 8B 55 0C 88 44 24 5F 33 C0 F2 0F 10 74 24 58 F2 0F 11 32 83 C4 78 5B 5E 8B E5 5D C3 0F 28 D0 F2 0F 59 D0 F2 0F 10 0D ?? ?? ?? ?? F2 0F 59 CA 0F B6 74 24 77 83 E6 80 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CA 8B 55 0C F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CA F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 D1 F2 0F 59 D0 F2 0F 58 C2 F2 0F 11 44 24 58 0F B6 44 24 5F 83 E0 7F 0B C6 88 44 24 5F 33 C0 F2 0F 10 44 24 58 F2 0F 11 02 83 C4 78 5B 5E 8B E5 5D C3 F2 0F 10 0D ?? ?? ?? ?? F2 0F 59 C8 F2 0F 11 54 24 68 F2 0F 10 15 ?? ?? ?? ?? F2 0F 10 1D ?? ?? ?? ?? F2 0F 58 0D ?? ?? ?? ?? F2 0F 11 4C 24 50 F2 0F 10 64 24 50 F2 0F 10 0D ?? ?? ?? ?? 8B 4C 24 50 8B D1 83 E2 3F F2 0F 5C 25 ?? ?? ?? ?? F2 0F 59 D4 F2 0F 59 E3 F2 0F 5C C2 C1 E2 04 F2 0F 5C C4 F2 0F 59 C8 C1 E9 06 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 C8 81 C1 FE 03 00 00 81 E1 FF 07 00 00 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 C8 81 F9 FE 07 00 00 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 C8 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 C8 F2 0F 59 C8 F2 0F 58 C8 F2 0F 10 82 ?? ?? ?? ?? F2 0F 59 C8 F2 0F 58 8A ?? ?? ?? ?? F2 0F 58 C8 77 21 C1 E1 04 25 0F 80 FF FF 0B C1 66 89 44 24 6E F2 0F 10 44 24 68 F2 0F 59 C8 F2 0F 11 4C 24 58 EB 33 49 81 E1 FF 07 00 00 0F B7 44 24 6E C1 E1 04 25 0F 80 FF FF 0B C1 66 89 44 24 6E F2 0F 10 44 24 68 F2 0F 59 C8 F2 0F 59 0D ?? ?? ?? ?? F2 0F 11 4C 24 58 0F B6 44 24 5F 0F B6 74 24 77 83 E0 7F 83 E6 80 8B 55 0C 0B C6 88 44 24 5F 33 C0 F2 0F 10 44 24 58 F2 0F 11 02 83 C4 78 5B 5E 8B E5 5D C3 F2 0F 10 05 ?? ?? ?? ?? F2 0F 59 C3 8B 45 0C F2 0F 11 00 B8 03 00 00 00 83 C4 78 5B 5E 8B E5 5D C3 F2 0F 10 05 ?? ?? ?? ?? 8B 45 0C F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C3 F2 0F 11 00 33 C0 83 C4 78 5B 5E 8B E5 5D C3 F2 0F 10 05 ?? ?? ?? ?? F2 0F 59 D8 F2 0F 11 5C 24 60 F2 0F 10 4C 24 60 8B 45 0C F2 0F 11 54 24 68 F2 0F 58 4C 24 70 F2 0F 11 08 33 C0 83 C4 78 5B 5E 8B E5 5D C3 8B 45 0C F2 0F 58 DB F2 0F 11 18 33 C0 83 C4 78 5B 5E 8B E5 5D C3 8D 49 00 }
	condition:
		$1
}

rule file_390_0_0 {
	meta:
		name = "___dyn_tls_init@12"
		size = 189
		refs = "0006 __sehtable$___dyn_tls_init@12 000b __except_handler4 001d ___security_cookie 0045 ___xd_a 0057 ___xd_z 0071 @_guard_check_icall@4 0092 _dyntls_init_exception_filter 009e _terminate"
	strings:
		$1 = { 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 EC 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 89 65 E8 83 7D 0C 02 74 02 EB 6E C7 45 FC 00 00 00 00 C7 45 E4 ?? ?? ?? ?? EB 09 8B 45 E4 83 C0 04 89 45 E4 81 7D E4 ?? ?? ?? ?? 74 1D 8B 4D E4 83 39 00 74 13 8B 55 E4 8B 02 89 45 E0 8B 4D E0 E8 ?? ?? ?? ?? FF 55 E0 EB D1 C7 45 FC FE FF FF FF EB 26 8B 4D EC 8B 11 8B 02 89 45 DC 8B 4D DC 51 E8 ?? ?? ?? ?? 83 C4 04 C3 8B 65 E8 E8 ?? ?? ?? ?? C7 45 FC FE FF FF FF 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule file_390_1_0 {
	meta:
		name = "_dyntls_init_exception_filter"
		size = 23
	strings:
		$1 = { 55 8B EC 81 7D 08 63 73 6D E0 75 07 B8 01 00 00 00 EB 02 33 C0 5D C3 }
	condition:
		$1
}

rule file_396_0_0 {
	meta:
		name = "__aulldvrm"
		size = 149
	strings:
		$1 = { 56 8B 44 24 14 0B C0 75 28 8B 4C 24 10 8B 44 24 0C 33 D2 F7 F1 8B D8 8B 44 24 08 F7 F1 8B F0 8B C3 F7 64 24 10 8B C8 8B C6 F7 64 24 10 03 D1 EB 47 8B C8 8B 5C 24 10 8B 54 24 0C 8B 44 24 08 D1 E9 D1 DB D1 EA D1 D8 0B C9 75 F4 F7 F3 8B F0 F7 64 24 14 8B C8 8B 44 24 10 F7 E6 03 D1 72 0E 3B 54 24 0C 77 08 72 0F 3B 44 24 08 76 09 4E 2B 44 24 10 1B 54 24 14 33 DB 2B 44 24 08 1B 54 24 0C F7 DA F7 D8 83 DA 00 8B CA 8B D3 8B D9 8B C8 8B C6 5E C2 10 00 }
	condition:
		$1
}

rule file_397_0_0 {
	meta:
		name = "___common_datan2_cout_rare"
		size = 4128
		refs = "0013 __vmldAtanHATab"
	strings:
		$1 = { 55 8B EC 83 E4 F8 56 57 53 83 EC 64 8B 45 08 F2 0F 10 0D ?? ?? ?? ?? 8B 55 0C 0F 28 D1 F2 0F 10 00 F2 0F 59 C2 F2 0F 59 12 F2 0F 11 44 24 18 F2 0F 11 54 24 20 0F B7 54 24 1E 81 E2 F0 7F 00 00 0F B6 4C 24 27 0F B7 7C 24 26 81 E1 80 00 00 00 81 E7 F0 7F 00 00 C1 EA 04 0F B6 5C 24 1F C1 EB 07 C1 E9 07 C1 EF 04 0F B7 35 ?? ?? ?? ?? 81 FA FF 07 00 00 0F 84 38 0F 00 00 81 FF FF 07 00 00 0F 84 55 0E 00 00 85 D2 75 15 F7 44 24 1C FF FF 0F 00 75 0B 83 7C 24 18 00 0F 84 74 0D 00 00 85 FF 75 15 F7 44 24 24 FF FF 0F 00 75 0B 83 7C 24 20 00 0F 84 48 0D 00 00 F2 0F 11 44 24 20 F7 DF F2 0F 11 54 24 28 03 FA 0F B6 44 24 27 83 E0 7F 89 44 24 18 0F B6 44 24 2F 83 E0 7F 83 FF CA 0F 8E 70 0C 00 00 83 FF 36 0F 8D 13 0C 00 00 85 C9 88 44 24 2F 8B 44 24 18 88 44 24 27 75 10 F2 0F 10 15 ?? ?? ?? ?? F2 0F 11 54 24 18 EB 16 F2 0F 10 05 ?? ?? ?? ?? F2 0F 10 15 ?? ?? ?? ?? F2 0F 11 44 24 18 F2 0F 10 64 24 20 85 D2 F2 0F 10 44 24 28 0F 28 EC F2 0F 5E E8 0F B7 44 24 26 F2 0F 11 6C 24 50 0F 8E 75 0D 00 00 81 FA FE 07 00 00 7D 1D 25 0F 80 FF FF 81 C2 01 FC FF FF F2 0F 11 64 24 20 0D F0 3F FF FF 66 89 44 24 26 EB 17 F2 0F 10 1D ?? ?? ?? ?? BA FE 03 00 00 F2 0F 59 E3 F2 0F 11 64 24 20 F7 DA 81 E6 0F 80 FF FF 81 C2 FF 03 00 00 81 E2 FF 07 00 00 C1 E2 04 F2 0F 11 4C 24 28 0B F2 66 89 74 24 2E F2 0F 10 5C 24 28 F2 0F 59 C3 66 0F 2F 2D ?? ?? ?? ?? 0F 82 20 07 00 00 F2 0F 11 6C 24 28 0F 28 F8 F2 0F 10 2D ?? ?? ?? ?? 0F 28 F0 F2 0F 59 FD F2 0F 11 3C 24 F2 0F 11 54 24 48 F2 0F 10 14 24 F2 0F 11 4C 24 40 F2 0F 5C D0 F2 0F 11 54 24 08 F2 0F 10 1C 24 F2 0F 10 64 24 08 8B 74 24 2C 8B FE 81 E6 00 00 08 00 81 E7 00 00 F0 FF 81 CE 00 00 04 00 F2 0F 5C DC F2 0F 11 1C 24 0B FE F2 0F 10 0C 24 C7 44 24 28 00 00 00 00 F2 0F 5C F1 89 7C 24 2C F2 0F 11 74 24 08 F2 0F 10 0C 24 F2 0F 10 54 24 28 F2 0F 10 74 24 08 F2 0F 59 CA F2 0F 59 F2 F2 0F 10 3D ?? ?? ?? ?? F2 0F 59 CF F2 0F 59 F7 0F 28 E1 0F B7 54 24 56 F2 0F 58 E6 F2 0F 11 24 24 81 E2 F0 7F 00 00 F2 0F 10 1C 24 C1 EA 04 F2 0F 5C CB 8B 44 24 54 F2 0F 58 CE F2 0F 11 4C 24 08 25 FF FF 0F 00 F2 0F 10 4C 24 20 F2 0F 10 24 24 0F 28 F9 F2 0F 10 74 24 08 F2 0F 58 FC F2 0F 11 3C 24 0F 28 F9 F2 0F 10 1C 24 C1 E2 14 F2 0F 5C FB F2 0F 11 7C 24 08 0B D0 F2 0F 10 3C 24 81 C2 00 00 40 C0 F2 0F 10 5C 24 08 B8 71 00 00 00 C1 FA 13 F2 0F 58 FB F2 0F 11 7C 24 10 0F 28 F9 F2 0F 10 5C 24 08 83 FA 71 F2 0F 58 E3 F2 0F 11 64 24 08 0F 4C C2 F2 0F 10 64 24 10 C1 E0 04 F2 0F 5C FC F2 0F 11 7C 24 10 F2 0F 10 5C 24 08 F2 0F 10 64 24 10 F2 0F 58 DC F2 0F 11 5C 24 10 F2 0F 10 1C 24 F2 0F 10 64 24 10 F2 0F 58 E6 0F 28 F3 F2 0F 59 F5 F2 0F 11 34 24 F2 0F 10 3C 24 F2 0F 5C FB F2 0F 11 7C 24 08 F2 0F 10 3C 24 F2 0F 10 74 24 08 F2 0F 5C FE F2 0F 11 3C 24 0F 28 F9 F2 0F 10 34 24 F2 0F 59 3D ?? ?? ?? ?? F2 0F 5C DE F2 0F 11 5C 24 08 F2 0F 10 1C 24 F2 0F 10 74 24 08 F2 0F 11 3C 24 F2 0F 58 E6 F2 0F 10 34 24 F2 0F 5C 74 24 20 F2 0F 11 74 24 08 F2 0F 10 34 24 F2 0F 10 7C 24 08 F2 0F 5C F7 F2 0F 11 34 24 F2 0F 10 3C 24 F2 0F 5C CF F2 0F 11 4C 24 08 F2 0F 10 34 24 F2 0F 10 7C 24 08 F2 0F 59 F2 F2 0F 59 FA 0F 28 D6 F2 0F 58 D7 F2 0F 11 14 24 F2 0F 10 14 24 F2 0F 5C F2 0F 28 D0 F2 0F 58 F7 F2 0F 11 74 24 08 0F 28 F0 F2 0F 10 0C 24 F2 0F 10 7C 24 08 F2 0F 58 F1 F2 0F 11 34 24 F2 0F 10 34 24 F2 0F 5C D6 F2 0F 11 54 24 08 F2 0F 10 14 24 F2 0F 10 74 24 08 F2 0F 58 D6 F2 0F 11 54 24 10 F2 0F 10 74 24 08 F2 0F 58 CE F2 0F 11 4C 24 08 F2 0F 10 4C 24 10 F2 0F 5C C1 F2 0F 11 44 24 10 F2 0F 10 74 24 08 F2 0F 10 44 24 10 F2 0F 58 F0 F2 0F 11 74 24 10 F2 0F 10 34 24 F2 0F 10 44 24 10 F2 0F 58 C7 0F 28 FE F2 0F 59 FD F2 0F 11 3C 24 F2 0F 10 14 24 F2 0F 5C D6 F2 0F 11 54 24 08 F2 0F 10 0C 24 F2 0F 10 7C 24 08 F2 0F 10 54 24 40 F2 0F 5C CF F2 0F 11 0C 24 F2 0F 10 3C 24 F2 0F 5C F7 F2 0F 11 74 24 08 F2 0F 10 3C 24 F2 0F 10 74 24 08 F2 0F 58 C6 0F 28 F2 F2 0F 5E F7 0F 28 CE F2 0F 59 CD F2 0F 11 4C 24 08 F2 0F 10 4C 24 08 F2 0F 5C CE F2 0F 11 4C 24 10 F2 0F 10 4C 24 08 F2 0F 10 74 24 10 F2 0F 5C CE F2 0F 11 4C 24 10 F2 0F 10 74 24 10 F2 0F 59 FE F2 0F 5C D7 F2 0F 10 7C 24 10 F2 0F 59 C7 F2 0F 11 44 24 08 F2 0F 10 44 24 08 F2 0F 5C D0 F2 0F 11 54 24 08 F2 0F 10 4C 24 08 F2 0F 10 7C 24 10 F2 0F 10 44 24 08 F2 0F 10 74 24 10 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 C8 0F 28 C7 F2 0F 59 C3 F2 0F 59 CE 0F 28 D1 F2 0F 59 D4 F2 0F 59 D9 F2 0F 59 E7 F2 0F 58 D3 F2 0F 10 3D ?? ?? ?? ?? F2 0F 58 D4 F2 0F 11 14 24 0F 28 E0 F2 0F 10 34 24 F2 0F 58 E6 F2 0F 11 24 24 F2 0F 10 1C 24 F2 0F 5C C3 F2 0F 58 C6 F2 0F 11 44 24 08 F2 0F 10 1C 24 0F 28 D3 0F 28 CB F2 0F 59 D3 F2 0F 59 CD F2 0F 59 FA F2 0F 10 44 24 08 F2 0F 11 0C 24 F2 0F 10 34 24 F2 0F 58 3D ?? ?? ?? ?? F2 0F 5C F3 F2 0F 59 FA F2 0F 11 74 24 08 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FA F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FA F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FA F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FA F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 D7 F2 0F 10 3C 24 F2 0F 10 64 24 08 F2 0F 59 EA F2 0F 5C FC F2 0F 11 3C 24 F2 0F 10 34 24 F2 0F 5C DE F2 0F 11 5C 24 08 F2 0F 10 24 24 F2 0F 10 5C 24 08 F2 0F 11 2C 24 F2 0F 58 C3 F2 0F 10 2C 24 F2 0F 5C EA F2 0F 11 6C 24 08 F2 0F 10 3C 24 F2 0F 10 74 24 08 F2 0F 5C FE F2 0F 11 3C 24 F2 0F 10 0C 24 F2 0F 5C D1 F2 0F 11 54 24 08 F2 0F 10 14 24 F2 0F 10 5C 24 08 0F 28 F2 0F 28 FB F2 0F 59 F8 F2 0F 59 D0 F2 0F 59 DC F2 0F 59 F4 F2 0F 58 FA 0F 28 CE 0F 28 D6 F2 0F 58 FB F2 0F 58 CC F2 0F 11 3C 24 F2 0F 10 3C 24 F2 0F 11 0C 24 F2 0F 10 2C 24 F2 0F 5C D5 F2 0F 11 54 24 08 F2 0F 10 1C 24 F2 0F 10 4C 24 08 F2 0F 58 D9 F2 0F 11 5C 24 10 F2 0F 10 6C 24 08 F2 0F 10 98 ?? ?? ?? ?? F2 0F 58 E5 F2 0F 11 64 24 08 F2 0F 10 64 24 10 F2 0F 5C F4 F2 0F 11 74 24 10 F2 0F 10 4C 24 08 F2 0F 10 74 24 10 F2 0F 58 CE F2 0F 11 4C 24 10 F2 0F 10 34 24 F2 0F 10 54 24 10 0F 28 EE F2 0F 58 DE F2 0F 58 C2 F2 0F 11 1C 24 F2 0F 58 C7 F2 0F 10 24 24 F2 0F 11 44 24 38 F2 0F 5C EC F2 0F 11 6C 24 08 F2 0F 10 0C 24 F2 0F 10 7C 24 08 F2 0F 58 CF F2 0F 11 4C 24 10 F2 0F 10 54 24 08 F2 0F 58 90 ?? ?? ?? ?? F2 0F 11 54 24 08 F2 0F 10 5C 24 10 F2 0F 10 54 24 48 F2 0F 5C F3 F2 0F 11 74 24 10 F2 0F 10 6C 24 08 F2 0F 10 64 24 10 F2 0F 58 EC F2 0F 11 6C 24 10 F2 0F 10 34 24 F2 0F 10 7C 24 10 F2 0F 11 74 24 30 F2 0F 58 C7 8B F1 0F 28 CA C1 E6 07 F2 0F 58 80 ?? ?? ?? ?? 0F B6 44 24 37 83 E0 7F 0B C6 88 44 24 37 F2 0F 11 44 24 38 F2 0F 10 44 24 30 0F 28 E0 F2 0F 58 C8 F2 0F 11 0C 24 F2 0F 10 1C 24 0F B6 7C 24 3F 8B D7 C1 EF 07 83 E2 7F 33 CF F2 0F 5C E3 F2 0F 11 64 24 08 F2 0F 10 34 24 F2 0F 10 6C 24 08 C1 E1 07 F2 0F 58 F5 F2 0F 11 74 24 10 0B D1 F2 0F 10 7C 24 08 88 54 24 3F F2 0F 58 D7 F2 0F 11 54 24 08 F2 0F 10 54 24 10 C1 E3 07 F2 0F 5C C2 F2 0F 11 44 24 10 F2 0F 10 4C 24 08 F2 0F 10 44 24 10 F2 0F 58 C8 F2 0F 11 4C 24 10 F2 0F 10 24 24 F2 0F 10 5C 24 10 F2 0F 11 64 24 30 F2 0F 58 5C 24 38 F2 0F 58 5C 24 18 F2 0F 11 5C 24 38 F2 0F 58 E3 F2 0F 11 64 24 58 0F B6 4C 24 5F 83 E1 7F 0B CB 8B 5D 10 88 4C 24 5F F2 0F 10 54 24 58 F2 0F 11 13 E9 D1 05 00 00 F2 0F 10 7C 24 20 8B F1 0F 28 E7 F2 0F 59 25 ?? ?? ?? ?? F2 0F 11 24 24 F2 0F 10 1C 24 F2 0F 11 54 24 48 F2 0F 10 25 ?? ?? ?? ?? C1 E6 07 F2 0F 5C 5C 24 20 F2 0F 11 5C 24 08 F2 0F 10 2C 24 F2 0F 10 54 24 08 C1 E3 07 F2 0F 5C EA F2 0F 11 2C 24 0F 28 E8 F2 0F 10 34 24 F2 0F 59 EC F2 0F 5C FE F2 0F 11 7C 24 08 F2 0F 10 14 24 F2 0F 10 5C 24 08 F2 0F 11 2C 24 F2 0F 10 34 24 F2 0F 5C F0 F2 0F 11 74 24 08 F2 0F 10 2C 24 F2 0F 10 7C 24 08 F2 0F 5C EF F2 0F 11 2C 24 F2 0F 10 34 24 F2 0F 5C C6 F2 0F 11 44 24 08 0F 28 C1 F2 0F 10 2C 24 F2 0F 5E C5 0F 28 F0 F2 0F 59 F4 F2 0F 10 7C 24 08 F2 0F 11 74 24 08 F2 0F 10 74 24 08 F2 0F 5C F0 F2 0F 11 74 24 10 F2 0F 10 74 24 08 F2 0F 10 44 24 10 F2 0F 5C F0 F2 0F 11 74 24 10 F2 0F 10 44 24 10 F2 0F 59 E8 F2 0F 5C CD F2 0F 10 6C 24 10 F2 0F 59 FD F2 0F 11 7C 24 08 F2 0F 10 7C 24 08 F2 0F 5C CF F2 0F 11 4C 24 08 F2 0F 10 6C 24 08 F2 0F 10 74 24 10 F2 0F 10 4C 24 08 0F 28 C6 F2 0F 59 C2 F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 F3 F2 0F 59 E9 F2 0F 10 4C 24 10 F2 0F 59 E9 0F 28 FD F2 0F 59 FB F2 0F 59 D5 F2 0F 58 FA 0F 28 D0 F2 0F 58 FE F2 0F 11 3C 24 F2 0F 10 0C 24 F2 0F 58 D1 F2 0F 11 14 24 F2 0F 10 1C 24 F2 0F 5C C3 F2 0F 58 C1 F2 0F 10 0D ?? ?? ?? ?? F2 0F 11 44 24 08 F2 0F 10 44 24 50 F2 0F 59 C0 F2 0F 59 C8 F2 0F 10 3C 24 0F 28 EF F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 EC F2 0F 59 C8 F2 0F 10 54 24 08 F2 0F 11 2C 24 F2 0F 10 34 24 F2 0F 58 0D ?? ?? ?? ?? F2 0F 5C F7 F2 0F 59 C8 F2 0F 11 74 24 08 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 C8 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 C8 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 C8 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 C8 F2 0F 10 04 24 F2 0F 10 5C 24 08 F2 0F 59 E1 F2 0F 5C C3 F2 0F 11 04 24 F2 0F 10 2C 24 F2 0F 5C FD F2 0F 11 7C 24 08 F2 0F 10 34 24 F2 0F 10 7C 24 08 F2 0F 11 24 24 F2 0F 58 D7 F2 0F 10 24 24 F2 0F 5C E1 F2 0F 11 64 24 08 F2 0F 10 2C 24 F2 0F 10 44 24 08 F2 0F 5C E8 F2 0F 11 2C 24 F2 0F 10 1C 24 F2 0F 5C CB F2 0F 11 4C 24 08 F2 0F 10 0C 24 F2 0F 10 7C 24 08 0F 28 E9 0F 28 C7 F2 0F 59 C2 F2 0F 59 CA F2 0F 59 FE F2 0F 59 EE F2 0F 58 C1 0F 28 CD 0F 28 DD F2 0F 58 C7 F2 0F 58 CE F2 0F 11 04 24 F2 0F 10 04 24 F2 0F 11 0C 24 F2 0F 10 24 24 F2 0F 5C DC F2 0F 11 5C 24 08 F2 0F 10 24 24 F2 0F 10 4C 24 08 F2 0F 58 E1 F2 0F 11 64 24 10 F2 0F 10 7C 24 08 F2 0F 58 F7 F2 0F 11 74 24 08 F2 0F 10 74 24 10 F2 0F 5C EE F2 0F 10 74 24 48 F2 0F 11 6C 24 10 F2 0F 10 5C 24 08 F2 0F 10 4C 24 10 F2 0F 58 D9 F2 0F 11 5C 24 10 F2 0F 10 24 24 F2 0F 10 6C 24 10 F2 0F 11 64 24 30 F2 0F 58 D5 0F B6 44 24 37 F2 0F 58 D0 83 E0 7F 0B C6 88 44 24 37 F2 0F 11 54 24 38 0F 28 D6 F2 0F 10 4C 24 30 0F 28 C1 F2 0F 58 D1 F2 0F 11 14 24 F2 0F 10 14 24 0F B6 7C 24 3F 8B D7 C1 EF 07 83 E2 7F 33 CF F2 0F 5C C2 F2 0F 11 44 24 08 F2 0F 10 24 24 F2 0F 10 5C 24 08 C1 E1 07 F2 0F 58 E3 F2 0F 11 64 24 10 0B D1 F2 0F 10 6C 24 08 88 54 24 3F F2 0F 58 F5 F2 0F 11 74 24 08 F2 0F 10 7C 24 10 F2 0F 5C CF F2 0F 11 4C 24 10 F2 0F 10 44 24 08 F2 0F 10 4C 24 10 F2 0F 58 C1 F2 0F 11 44 24 10 F2 0F 10 1C 24 F2 0F 10 54 24 10 F2 0F 11 5C 24 30 F2 0F 58 54 24 38 F2 0F 58 54 24 18 F2 0F 11 54 24 38 F2 0F 58 DA F2 0F 11 5C 24 58 0F B6 4C 24 5F 83 E1 7F 0B CB 8B 5D 10 88 4C 24 5F F2 0F 10 4C 24 58 F2 0F 11 0B E9 B2 01 00 00 83 FF 4A 0F 8D 0B 01 00 00 8B 44 24 18 88 44 24 27 F2 0F 5E 54 24 20 F2 0F 10 05 ?? ?? ?? ?? C1 E3 07 F2 0F 5C C2 8B 4D 10 F2 0F 58 05 ?? ?? ?? ?? F2 0F 11 44 24 58 0F B6 54 24 5F 83 E2 7F 0B D3 88 54 24 5F F2 0F 10 4C 24 58 F2 0F 11 09 E9 5E 01 00 00 85 C9 0F 85 22 01 00 00 8B 54 24 18 88 54 24 27 88 44 24 2F F2 0F 10 54 24 20 F2 0F 5E 54 24 28 F2 0F 11 54 24 58 0F B7 4C 24 5E F7 C1 F0 7F 00 00 74 3B C1 E3 07 F2 0F 58 CA F2 0F 11 0C 24 F2 0F 10 04 24 F2 0F 59 D0 F2 0F 11 54 24 58 0F B6 44 24 5F 83 E0 7F 8B 55 10 0B C3 88 44 24 5F F2 0F 10 4C 24 58 F2 0F 11 0A E9 F0 00 00 00 F2 0F 59 D2 F2 0F 11 14 24 F2 0F 10 04 24 C1 E3 07 F2 0F 58 44 24 58 F2 0F 11 44 24 58 0F B6 44 24 5F 83 E0 7F 8B 55 10 0B C3 88 44 24 5F F2 0F 10 4C 24 58 F2 0F 11 0A E9 B3 00 00 00 85 D2 75 11 F7 44 24 1C FF FF 0F 00 75 07 E9 FD 01 00 00 74 36 F2 0F 10 05 ?? ?? ?? ?? C1 E3 07 F2 0F 58 05 ?? ?? ?? ?? F2 0F 11 44 24 58 0F B6 44 24 5F 83 E0 7F 8B 55 10 0B C3 88 44 24 5F F2 0F 10 4C 24 58 F2 0F 11 0A EB 68 85 C9 75 30 0F B6 05 ?? ?? ?? ?? F2 0F 10 05 ?? ?? ?? ?? 83 E0 7F C1 E3 07 8B 55 10 0B C3 F2 0F 11 44 24 58 88 44 24 5F F2 0F 10 4C 24 58 F2 0F 11 0A EB 34 F2 0F 10 05 ?? ?? ?? ?? C1 E3 07 F2 0F 58 05 ?? ?? ?? ?? F2 0F 11 44 24 58 0F B6 44 24 5F 83 E0 7F 8B 55 10 0B C3 88 44 24 5F F2 0F 10 4C 24 58 F2 0F 11 0A 33 C0 83 C4 64 5B 5F 5E 8B E5 5D C3 F2 0F 10 1D ?? ?? ?? ?? BA 02 FC FF FF F2 0F 59 E3 F2 0F 11 64 24 20 E9 AB F2 FF FF F7 44 24 24 FF FF 0F 00 75 07 83 7C 24 20 00 74 0D 8B 45 10 F2 0F 58 C2 F2 0F 11 00 EB BA 81 FA FF 07 00 00 74 3B 85 C9 0F 85 76 FF FF FF 0F B6 05 ?? ?? ?? ?? F2 0F 10 05 ?? ?? ?? ?? 83 E0 7F C1 E3 07 8B 55 10 0B C3 F2 0F 11 44 24 58 88 44 24 5F F2 0F 10 4C 24 58 F2 0F 11 0A E9 77 FF FF FF 85 C9 75 39 F2 0F 10 05 ?? ?? ?? ?? C1 E3 07 F2 0F 58 05 ?? ?? ?? ?? F2 0F 11 44 24 58 0F B6 44 24 5F 83 E0 7F 8B 55 10 0B C3 88 44 24 5F F2 0F 10 4C 24 58 F2 0F 11 0A E9 3A FF FF FF F2 0F 10 05 ?? ?? ?? ?? C1 E3 07 F2 0F 58 05 ?? ?? ?? ?? F2 0F 11 44 24 58 0F B6 44 24 5F 83 E0 7F 8B 55 10 0B C3 88 44 24 5F F2 0F 10 4C 24 58 F2 0F 11 0A E9 01 FF FF FF F7 44 24 1C FF FF 0F 00 0F 85 2C FF FF FF 83 7C 24 18 00 0F 85 21 FF FF FF 81 FF FF 07 00 00 0F 84 04 FF FF FF F2 0F 10 05 ?? ?? ?? ?? C1 E3 07 F2 0F 58 05 ?? ?? ?? ?? F2 0F 11 44 24 58 0F B6 44 24 5F 83 E0 7F 8B 55 10 0B C3 88 44 24 }
	condition:
		$1
}

rule file_398_0_0 {
	meta:
		name = "__allshl"
		size = 31
	strings:
		$1 = { 80 F9 40 73 15 80 F9 20 73 06 0F A5 C2 D3 E0 C3 8B D0 33 C0 80 E1 1F D3 E2 C3 33 C0 33 D2 C3 }
	condition:
		$1
}

rule file_399_0_0 {
	meta:
		name = "___avx_exp4"
		size = 352
		refs = "0010 ___common_dexp_data 0151 ___common_dexp_cout_rare"
	strings:
		$1 = { 55 8B EC 83 E4 C0 81 EC C0 00 00 00 C5 FD 10 35 ?? ?? ?? ?? C5 FD 59 15 ?? ?? ?? ?? C5 F9 10 25 ?? ?? ?? ?? C5 ED 58 DE C5 E5 5C CE C4 E3 7D 19 C5 01 C5 F8 C6 D5 DD C5 E8 54 3D ?? ?? ?? ?? C5 C1 66 35 ?? ?? ?? ?? C5 F8 50 C6 C5 E0 54 EC C5 F9 7E EA C4 E3 79 16 E9 02 C4 E3 7D 19 DA 01 C5 D9 DF DB C5 E8 54 FC C5 D9 DF E2 C5 FA 7E 34 D5 ?? ?? ?? ?? C5 E9 73 F4 2A C5 F9 7E FA C5 C9 16 2C CD ?? ?? ?? ?? C4 E3 79 16 F9 02 C5 FA 7E 34 D5 ?? ?? ?? ?? C5 C9 16 3C CD ?? ?? ?? ?? C4 E3 55 18 FF 01 C5 F5 59 2D ?? ?? ?? ?? C5 F5 59 0D ?? ?? ?? ?? C5 FD 5C F5 C5 CD 5C F1 C5 CD 58 2D ?? ?? ?? ?? C5 D5 59 CE C5 F5 58 2D ?? ?? ?? ?? C5 F1 73 F3 2A C5 D5 59 F6 C5 CD 58 2D ?? ?? ?? ?? C5 C5 59 FD C4 E3 7D 19 FD 01 C5 C1 D4 D9 C5 D1 D4 CA C4 E3 65 18 C9 01 85 C0 75 08 C5 FD 28 C1 8B E5 5D C3 C5 FD 11 44 24 40 C5 FD 11 8C 24 80 00 00 00 74 E7 33 D2 89 74 24 04 8B F2 89 3C 24 8B F8 0F A3 F7 72 18 46 83 FE 20 7C F5 8B 74 24 04 8B 3C 24 C5 FD 10 8C 24 80 00 00 00 EB BD C5 F8 77 8D 8C F4 80 00 00 00 8D 44 F4 40 51 50 E8 ?? ?? ?? ?? 83 C4 08 EB CE 8D 9B 00 00 00 00 }
	condition:
		$1
}

rule file_402_0_0 {
	meta:
		name = "___sse2_log102"
		size = 464
		refs = "005b _static_const_table"
	strings:
		$1 = { 8B C4 83 EC 70 83 E4 F0 89 44 24 2C 66 0F 28 F8 66 0F 28 F0 66 0F 73 D7 20 89 5C 24 10 89 4C 24 14 66 0F 7E F8 8B C8 0F C6 FF 02 66 0F 7E FA 8B DA C1 E8 09 25 F0 07 00 00 83 C0 10 25 E0 0F 00 00 C1 EA 09 81 E2 F0 07 00 00 83 C2 10 81 E2 E0 0F 00 00 66 0F 28 C8 66 0F DB 05 ?? ?? ?? ?? 66 0F EB 05 ?? ?? ?? ?? 66 0F 28 15 ?? ?? ?? ?? 66 0F 28 1D ?? ?? ?? ?? 66 0F 70 C9 0D 66 0F 72 D1 14 66 0F FA 0D ?? ?? ?? ?? F3 0F E6 C9 66 0F 54 D8 66 0F 5C C3 66 0F 59 D1 66 0F 59 0D ?? ?? ?? ?? F3 0F 7E A0 ?? ?? ?? ?? 66 0F 16 A2 ?? ?? ?? ?? 66 0F 59 DC 66 0F 59 C4 66 0F 28 B8 ?? ?? ?? ?? 66 0F 28 EF 81 E9 00 00 10 00 81 F9 00 00 E0 7F 0F 83 C9 00 00 00 81 EB 00 00 10 00 81 FB 00 00 E0 7F 0F 83 B7 00 00 00 66 0F 28 B2 ?? ?? ?? ?? 66 0F 14 FE 66 0F 15 EE 66 0F 58 FA 66 0F 28 E7 66 0F C2 25 ?? ?? ?? ?? 00 66 0F 58 E9 66 0F 5C 1D ?? ?? ?? ?? 66 0F 54 E0 66 0F 58 FB 66 0F 58 FC 66 0F 55 E0 66 0F 58 C3 66 0F 28 15 ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 28 C8 66 0F 59 C0 66 0F 59 F0 66 0F 59 D0 66 0F 58 35 ?? ?? ?? ?? 66 0F 58 15 ?? ?? ?? ?? 66 0F 59 F0 66 0F 59 D0 66 0F 58 35 ?? ?? ?? ?? 66 0F 58 15 ?? ?? ?? ?? 66 0F 59 F1 66 0F 58 F2 66 0F 59 0D ?? ?? ?? ?? 66 0F 59 C6 66 0F 58 C1 66 0F 58 C5 66 0F 58 C4 66 0F 58 C7 8B 4C 24 14 8B 5C 24 10 EB 28 66 0F 29 34 24 D9 EC DD 04 24 D9 F1 8B 4C 24 14 DD 1C 24 D9 EC DD 44 24 08 D9 F1 8B 5C 24 10 DD 5C 24 08 66 0F 28 04 24 8B 64 24 2C C3 8D 49 00 }
	condition:
		$1
}

rule file_404_0_0 {
	meta:
		name = "___avx_atanf8"
		size = 192
		refs = "0004 ___common_satan_data"
	strings:
		$1 = { C5 FC 10 15 ?? ?? ?? ?? C5 FC 10 3D ?? ?? ?? ?? C5 FC 54 25 ?? ?? ?? ?? C5 DC C2 F2 12 C5 EC 5D CC C5 FC 54 EF C5 CC 55 1D ?? ?? ?? ?? C5 E4 57 C5 C5 EC 5F DC C5 F4 5E E3 C5 CC 55 F7 C5 CC 57 ED C5 D4 57 DC C5 E4 59 D3 C5 EC 59 CA C5 F4 59 3D ?? ?? ?? ?? C5 F4 59 25 ?? ?? ?? ?? C5 C4 58 2D ?? ?? ?? ?? C5 DC 58 3D ?? ?? ?? ?? C5 D4 59 F1 C5 C4 59 F9 C5 CC 58 25 ?? ?? ?? ?? C5 C4 58 35 ?? ?? ?? ?? C5 DC 59 E9 C5 CC 59 C9 C5 D4 58 25 ?? ?? ?? ?? C5 F4 58 2D ?? ?? ?? ?? C5 DC 59 CA C5 F4 58 F5 C5 CC 59 D2 C5 EC 58 0D ?? ?? ?? ?? C5 F4 59 DB C5 E4 58 C0 C3 8D 9B 00 00 00 00 }
	condition:
		$1
}

rule file_405_0_0 {
	meta:
		name = "??2@YAPAXIHPBDH@Z"
		size = 82
		refs = "0015 __malloc_dbg 002f __callnewh 0041 ?__scrt_throw_std_bad_array_new_length@@YAXXZ 0048 ?__scrt_throw_std_bad_alloc@@YAXXZ"
	strings:
		$1 = { 55 8B EC 51 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 89 45 FC 83 7D FC 00 74 05 8B 45 FC EB 24 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 12 83 7D 08 FF 75 07 E8 ?? ?? ?? ?? EB 05 E8 ?? ?? ?? ?? EB B6 8B E5 5D C3 }
	condition:
		$1
}

rule file_406_0_0 {
	meta:
		name = "___common_dcosh_cout_rare"
		size = 976
		refs = "0011 __vmldCoshHATab"
	strings:
		$1 = { 55 8B EC 83 E4 F8 56 83 EC 3C 8B 4D 08 F2 0F 10 0D ?? ?? ?? ?? 0F B7 05 ?? ?? ?? ?? 0F B7 51 06 81 E2 F0 7F 00 00 81 FA F0 7F 00 00 0F 84 7F 03 00 00 F2 0F 10 01 0F B6 51 07 F2 0F 11 44 24 20 83 E2 7F 88 54 24 27 0F B7 4C 24 26 81 E1 F0 7F 00 00 81 F9 90 3C 00 00 0F 8E 34 03 00 00 F2 0F 10 7C 24 20 F2 0F 10 05 ?? ?? ?? ?? 66 0F 2F C7 0F 86 FC 02 00 00 F2 0F 11 4C 24 30 F2 0F 10 0D ?? ?? ?? ?? F2 0F 59 CF 66 0F 2F 3D ?? ?? ?? ?? 0F 82 2B 01 00 00 F2 0F 10 05 ?? ?? ?? ?? F2 0F 58 C8 F2 0F 11 0C 24 F2 0F 10 0C 24 8B 0C 24 8B D1 83 E2 3F F2 0F 5C 0D ?? ?? ?? ?? F2 0F 11 4C 24 08 F2 0F 10 54 24 08 F2 0F 59 15 ?? ?? ?? ?? F2 0F 10 5C 24 08 F2 0F 5C FA F2 0F 59 1D ?? ?? ?? ?? F2 0F 10 0D ?? ?? ?? ?? F2 0F 5C FB F2 0F 59 CF C1 E2 04 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CF F2 0F 10 A2 ?? ?? ?? ?? C1 E9 06 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CF 81 C1 FF 03 00 00 49 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CF 81 E1 FF 07 00 00 81 F9 FE 07 00 00 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CF F2 0F 59 CF F2 0F 58 CF F2 0F 59 CC F2 0F 58 8A ?? ?? ?? ?? F2 0F 58 CC 77 2A C1 E1 04 25 0F 80 FF FF 0B C1 66 89 44 24 36 F2 0F 10 44 24 30 F2 0F 59 C1 8B 45 0C F2 0F 11 00 33 C0 83 C4 3C 5E 8B E5 5D C3 49 81 E1 FF 07 00 00 0F B7 44 24 36 C1 E1 04 25 0F 80 FF FF 0B C1 66 89 44 24 36 33 C0 F2 0F 59 4C 24 30 F2 0F 59 0D ?? ?? ?? ?? 8B 55 0C F2 0F 11 0A 83 C4 3C 5E 8B E5 5D C3 F2 0F 10 2D ?? ?? ?? ?? 0F B7 4C 24 36 81 E1 0F 80 FF FF F2 0F 58 0D ?? ?? ?? ?? F2 0F 11 0C 24 F2 0F 10 34 24 8B 34 24 8B D6 C1 EA 06 83 E6 3F 81 C2 FF 03 00 00 F2 0F 5C 35 ?? ?? ?? ?? F2 0F 11 74 24 08 8D 42 FF F2 0F 10 5C 24 08 25 FF 07 00 00 F2 0F 59 1D ?? ?? ?? ?? F7 DA F2 0F 10 44 24 08 83 C2 FC F2 0F 59 05 ?? ?? ?? ?? F2 0F 5C FB F2 0F 10 35 ?? ?? ?? ?? 81 E2 FF 07 00 00 C1 E6 04 F2 0F 5C F8 0F 28 E7 F2 0F 59 E7 F2 0F 59 F4 F2 0F 59 EC F2 0F 58 35 ?? ?? ?? ?? F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 F4 F2 0F 59 EC F2 0F 58 35 ?? ?? ?? ?? F2 0F 59 EF F2 0F 59 F4 C1 E0 04 F2 0F 10 9E ?? ?? ?? ?? 0B C8 F2 0F 10 A6 ?? ?? ?? ?? F7 DE 66 89 4C 24 36 81 E1 0F 80 FF FF C1 E2 04 F2 0F 10 4C 24 30 0B CA 66 89 4C 24 36 F2 0F 59 D9 F2 0F 59 E1 F2 0F 10 44 24 30 F2 0F 10 96 ?? ?? ?? ?? F2 0F 59 D0 F2 0F 10 8E ?? ?? ?? ?? F2 0F 59 C8 0F 28 C3 F2 0F 58 C2 F2 0F 11 44 24 10 0F 28 C3 F2 0F 11 4C 24 20 F2 0F 5C DA F2 0F 10 4C 24 10 F2 0F 59 EB F2 0F 5C C1 8B 45 0C F2 0F 58 C2 F2 0F 11 44 24 18 0F 28 C4 F2 0F 10 54 24 20 F2 0F 10 4C 24 10 F2 0F 5C C2 F2 0F 59 C7 F2 0F 59 FB F2 0F 58 C2 F2 0F 11 4C 24 28 F2 0F 58 C4 F2 0F 10 4C 24 18 F2 0F 58 C1 F2 0F 58 C5 F2 0F 10 6C 24 28 F2 0F 59 F5 F2 0F 58 C6 F2 0F 58 C7 F2 0F 11 44 24 10 F2 0F 10 7C 24 10 F2 0F 58 EF F2 0F 11 28 33 C0 83 C4 3C 5E 8B E5 5D C3 F2 0F 10 05 ?? ?? ?? ?? F2 0F 59 C0 8B 45 0C F2 0F 11 00 B8 03 00 00 00 83 C4 3C 5E 8B E5 5D C3 F2 0F 10 05 ?? ?? ?? ?? 8B 45 0C F2 0F 58 44 24 20 F2 0F 11 00 33 C0 83 C4 3C 5E 8B E5 5D C3 F2 0F 10 01 F2 0F 59 C0 8B 45 0C F2 0F 11 00 33 C0 83 C4 3C 5E 8B E5 5D C3 8D 9B 00 00 00 00 }
	condition:
		$1
}

rule file_411_0_0 {
	meta:
		name = "___avx_coshf8"
		size = 384
		refs = "0010 ___common_scosh_data 016e ___common_scosh_cout_rare"
	strings:
		$1 = { 55 8B EC 83 E4 C0 81 EC C0 00 00 00 C5 FC 10 0D ?? ?? ?? ?? C5 FC 10 1D ?? ?? ?? ?? C5 F8 10 15 ?? ?? ?? ?? C5 FC 28 F0 C5 F4 55 E6 C5 DC 59 2D ?? ?? ?? ?? C5 FC 11 34 24 C5 F8 10 05 ?? ?? ?? ?? C5 D4 58 EB C5 D9 66 FA C4 E3 7D 19 E1 01 C5 D9 76 F2 C5 C1 EB F6 C5 F1 66 FA C5 F1 76 D2 C5 C1 EB FA C5 C9 6B CF C5 C9 EF F6 C5 F1 63 FE C5 D4 5C F3 C5 F9 D7 D7 C5 CC 59 1D ?? ?? ?? ?? C5 DC 5C FB C5 CC 59 25 ?? ?? ?? ?? C5 C4 5C F4 C5 CC 59 FE C5 E9 72 F5 17 C4 E3 7D 19 EB 01 C5 F9 FE CA C5 E1 72 F3 17 C5 F9 FA D2 C5 F9 FE EB C5 F9 FA C3 C4 E3 75 18 E5 01 C5 C4 59 0D ?? ?? ?? ?? C5 F4 58 1D ?? ?? ?? ?? C4 E3 6D 18 C0 01 C5 C4 59 15 ?? ?? ?? ?? C5 DC 5C E8 C5 DC 58 C0 C5 E4 59 E7 C5 EC 58 1D ?? ?? ?? ?? C5 DC 59 CE C5 E4 59 E7 C5 F4 58 F6 C5 DC 58 0D ?? ?? ?? ?? C5 D4 59 EE C5 F4 59 FF C5 C4 59 C8 C5 D4 58 F1 C5 CC 58 C0 84 D2 75 04 8B E5 5D C3 C5 FC 10 0C 24 C5 FC 11 84 24 80 00 00 00 C5 FC 11 4C 24 40 85 D2 74 E4 33 C0 89 74 24 04 8B F0 89 3C 24 8B FA 0F A3 F7 72 18 46 83 FE 20 7C F5 8B 74 24 04 8B 3C 24 C5 FC 10 84 24 80 00 00 00 EB BA C5 F8 77 8D 8C B4 80 00 00 00 8D 44 B4 40 51 50 E8 ?? ?? ?? ?? 83 C4 08 EB CE 8D A4 24 00 00 00 00 8B FF }
	condition:
		$1
}

rule file_416_0_0 {
	meta:
		name = "__chkstk"
		size = 45
	strings:
		$1 = { 51 8D 4C 24 04 2B C8 1B C0 F7 D0 23 C8 8B C4 25 00 F0 FF FF 3B C8 F2 72 0B 8B C1 59 94 8B 00 89 04 24 F2 C3 2D 00 10 00 00 85 00 EB E7 }
	condition:
		$1
}

rule file_419_0_0 {
	meta:
		name = "__initialize_default_precision"
		size = 36
		refs = "0010 __controlfp_s 001e ___scrt_fastfail"
	strings:
		$1 = { 55 8B EC 68 00 00 03 00 68 00 00 01 00 6A 00 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 07 6A 07 E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_421_0_0 {
	meta:
		name = "___avx_sinf8"
		size = 3200
		refs = "0013 ___common_ssin_data 012c ___common_ssin_cout_rare 01db ___common_ssin_reduction_data"
	strings:
		$1 = { 55 8B EC 83 E4 C0 56 57 53 81 EC F4 02 00 00 C5 FC 10 1D ?? ?? ?? ?? C5 E9 EF D2 C5 FC 54 CB C5 F4 C2 25 ?? ?? ?? ?? 1E C4 E3 7D 19 E5 01 C5 D9 6B F5 C5 C9 63 FA C5 F9 D7 C7 84 C0 0F 85 F3 00 00 00 C5 E4 55 D0 33 DB C5 FC 10 1D ?? ?? ?? ?? C5 F4 59 25 ?? ?? ?? ?? C5 DC 58 FB C5 C9 72 F7 1F C4 E3 7D 19 FD 01 C5 D9 72 F5 1F C5 C4 5C EB C5 D4 59 1D ?? ?? ?? ?? C5 F4 5C DB C4 E3 4D 18 F4 01 C5 D4 59 25 ?? ?? ?? ?? C5 E4 5C DC C5 D4 59 25 ?? ?? ?? ?? C5 E4 5C DC C5 D4 59 25 ?? ?? ?? ?? C5 E4 5C DC C5 E4 59 E3 C5 DC 59 2D ?? ?? ?? ?? C5 D4 58 2D ?? ?? ?? ?? C5 D4 59 EC C5 D4 58 2D ?? ?? ?? ?? C5 D4 59 EC C5 D4 58 2D ?? ?? ?? ?? C5 D4 59 E4 C5 E4 57 DE C5 DC 59 E3 C5 DC 58 DB C5 E4 57 D2 84 DB 75 11 C5 FC 28 C2 81 C4 F4 02 00 00 5B 5F 5E 8B E5 5D C3 C5 FC 11 04 24 C5 FC 11 54 24 40 85 DB 74 E0 33 F6 0F A3 F3 72 0E 46 83 FE 20 7C F5 C5 FC 10 54 24 40 EB CB C5 F8 77 8D 44 B4 40 8D 14 B4 50 52 E8 ?? ?? ?? ?? 83 C4 08 EB DC C5 FC 10 25 ?? ?? ?? ?? BA 00 00 80 7F C5 FC 11 44 24 40 C5 F9 6E FA C5 DC 54 E9 C5 D4 C2 DC 00 C4 E3 7D 19 C4 01 C5 F8 11 A4 24 90 00 00 00 C4 E3 7D 19 DD 01 C5 E1 6B F5 C5 C9 63 D2 C5 F9 D7 C2 C5 F9 70 D7 00 89 84 24 A0 02 00 00 C5 F8 28 C8 C5 E9 DB D9 C5 D1 72 D3 17 C5 E9 DB DC C5 E9 72 D3 17 C5 E1 72 F5 01 C5 E1 FE DD C5 D1 72 F3 02 C5 E1 72 F2 01 C5 F9 7E EA C5 E1 FE DA C5 E1 72 F3 02 C5 F8 11 8C 24 80 00 00 00 C4 E3 79 16 E9 01 C4 E3 79 16 E8 02 C4 E3 79 16 EF 03 C5 F9 7E DE C5 F9 6E 91 ?? ?? ?? ?? C4 E3 79 16 9C 24 AC 02 00 00 01 C4 E3 79 16 9C 24 B0 02 00 00 02 C4 E3 79 16 DB 03 C5 F9 6E 9A ?? ?? ?? ?? C5 E1 6C EA C5 F9 6E 98 ?? ?? ?? ?? C5 F9 6E 97 ?? ?? ?? ?? C5 E1 6C DA 89 B4 24 A8 02 00 00 C5 D0 C6 F3 88 C5 F9 6E 9E ?? ?? ?? ?? 8B B4 24 AC 02 00 00 89 BC 24 A4 02 00 00 C5 F9 6E 83 ?? ?? ?? ?? C5 F9 6E 96 ?? ?? ?? ?? 8B B4 24 B0 02 00 00 C5 E1 6C EA C5 F9 6E 93 ?? ?? ?? ?? C5 F9 6E 9E ?? ?? ?? ?? C5 E1 6C DA C5 D0 C6 EB 88 C5 F9 6E 9A ?? ?? ?? ?? C5 F9 6E 91 ?? ?? ?? ?? C5 E1 6C FA C5 F9 6E 97 ?? ?? ?? ?? 8B BC 24 A8 02 00 00 C5 F9 6E 98 ?? ?? ?? ?? C5 E1 6C DA C5 C0 C6 FB 88 C5 F9 6E 9F ?? ?? ?? ?? 8B BC 24 AC 02 00 00 C5 F8 11 B4 24 A0 00 00 00 C5 F8 11 AC 24 B0 00 00 00 C5 F9 6E 97 ?? ?? ?? ?? C5 E1 6C D2 C5 F9 6E 9E ?? ?? ?? ?? C5 E1 6C D8 C5 E8 C6 D3 88 C5 F8 11 94 24 C0 00 00 00 C5 F9 6E 9A ?? ?? ?? ?? C5 F9 6E 91 ?? ?? ?? ?? B9 FF FF 7F 00 C5 E1 6C DA C5 F9 6E 90 ?? ?? ?? ?? 8B 84 24 A4 02 00 00 8B 94 24 A8 02 00 00 C5 F9 6E 80 ?? ?? ?? ?? B8 FF FF 00 00 C5 E9 6C D0 C5 E0 C6 DA 88 C5 F8 11 9C 24 D0 00 00 00 C5 F9 6E 9A ?? ?? ?? ?? BA 00 00 00 80 C5 F9 6E 97 ?? ?? ?? ?? BF 00 00 80 28 C5 F9 6E 83 ?? ?? ?? ?? BB 00 00 80 00 C5 E1 6C DA C5 F9 6E 96 ?? ?? ?? ?? BE FF 00 00 00 C5 E9 6C D0 C5 E0 C6 C2 88 C5 F9 6E D9 C5 F9 70 D3 00 C5 F9 6E DB C5 F9 70 DB 00 C5 E9 DB E4 C5 E9 DB C9 C5 D9 FE D3 C5 F9 6E E0 C5 F1 FE CB C5 F9 70 DC 00 B9 00 00 80 3F C5 C9 DB E3 C5 D1 DB F3 C5 D1 72 D7 10 C5 C1 DB FB C5 FA 7F AC 24 10 01 00 00 BB 00 00 40 47 C5 F8 10 AC 24 C0 00 00 00 B8 FF FF 03 00 C5 FA 7F B4 24 00 01 00 00 C5 C9 72 D5 10 C5 D1 DB EB C5 FA 7F AC 24 40 01 00 00 C5 F8 10 AC 24 D0 00 00 00 C5 F8 11 84 24 E0 00 00 00 C5 F9 72 D0 10 C5 FA 7F 84 24 60 01 00 00 C5 F9 72 D1 10 C5 F1 DB CB C5 D1 72 D5 10 C5 FA 7F AC 24 50 01 00 00 C5 D1 72 D2 10 C5 E9 DB D3 C5 FA 7F A4 24 F0 00 00 00 C4 E2 71 40 E4 C5 FA 7F A4 24 A0 01 00 00 C4 E2 69 40 A4 24 00 01 00 00 C5 FA 7F B4 24 20 01 00 00 C5 FA 7F BC 24 30 01 00 00 C5 FA 7F A4 24 B0 01 00 00 C4 E2 69 40 F6 C4 E2 71 40 A4 24 10 01 00 00 C5 FA 7F B4 24 D0 01 00 00 C4 E2 71 40 F7 C5 E1 DB BC 24 D0 00 00 00 C5 FA 7F A4 24 C0 01 00 00 C4 E2 79 40 E7 C5 FA 6F BC 24 50 01 00 00 C5 D9 72 D4 10 C5 FA 7F 8C 24 80 01 00 00 C4 E2 71 40 CF C5 FA 7F 84 24 70 01 00 00 C4 E2 79 40 C7 C5 C1 72 D1 10 C5 FA 7F B4 24 E0 01 00 00 C5 C9 DB F3 C5 F9 FE C7 C5 C9 FE F0 C5 D9 FE FE C5 E1 DB A4 24 E0 00 00 00 C5 FA 7F 94 24 90 01 00 00 C4 E2 69 40 94 24 40 01 00 00 C4 E2 51 40 CC C5 E9 DB C3 C5 FA 7F 94 24 F0 01 00 00 C5 C9 72 D1 10 C5 FA 6F 8C 24 60 01 00 00 C5 FA 6F 94 24 90 01 00 00 C4 E2 69 40 D1 C4 E2 51 40 E1 C5 E9 72 D2 10 C5 D9 FE E2 C5 F9 FE C4 C5 FA 7F BC 24 00 02 00 00 C5 C9 FE C8 C5 FA 6F A4 24 70 01 00 00 C5 C9 72 D7 10 C5 FA 6F BC 24 E0 01 00 00 C4 E2 59 40 84 24 30 01 00 00 C5 C1 72 D7 10 C5 E1 DB 94 24 C0 01 00 00 C5 F9 FE C7 C5 FA 7F 8C 24 10 02 00 00 C5 E9 FE D0 C5 C1 72 D1 10 C5 C9 FE C2 C5 FA 6F 8C 24 F0 01 00 00 C4 E2 51 40 B4 24 40 01 00 00 C5 F1 72 D1 10 C5 E1 DB 94 24 D0 01 00 00 C5 C9 FE F1 C5 E9 FE D6 C5 C1 FE F2 C5 FA 6F 94 24 C0 01 00 00 C4 E2 59 40 BC 24 10 01 00 00 C5 E9 72 D2 10 C5 E1 DB 8C 24 A0 01 00 00 C5 C1 FE FA C5 FA 7F 84 24 20 02 00 00 C5 F9 72 D0 10 C5 F1 FE D7 C5 FA 7F B4 24 30 02 00 00 C5 F9 FE FA C5 E9 72 D6 10 C5 FA 6F B4 24 D0 01 00 00 C4 E2 51 40 8C 24 20 01 00 00 C5 C9 72 D6 10 C5 E1 DB 84 24 B0 01 00 00 C5 F1 FE CE C5 F9 FE C1 C5 C9 72 D7 10 C5 E9 FE C8 C5 C1 DB FB C5 F8 10 84 24 A0 00 00 00 C5 FA 6F 94 24 80 01 00 00 C5 F9 72 D0 10 C4 E2 69 40 D0 C4 E2 59 40 84 24 F0 00 00 00 C5 E9 DB D3 C5 FA 6F A4 24 A0 01 00 00 C5 D9 72 D4 10 C5 F9 FE C4 C5 E9 FE D0 C5 C9 FE F2 C5 E9 72 D1 10 C5 F8 10 A4 24 B0 00 00 00 C5 F9 72 F6 10 C5 FA 6F B4 24 90 01 00 00 C5 F9 FE C7 C5 C1 72 D4 10 C5 F1 DB CB C4 E2 49 40 E7 C4 E2 51 40 B4 24 00 01 00 00 C5 D9 DB E3 C5 FA 6F AC 24 B0 01 00 00 C5 D1 72 D5 10 C5 C9 FE FD C5 D9 FE E7 C5 E9 FE D4 C5 D9 72 F2 10 C5 FA 6F BC 24 30 02 00 00 C5 D9 FE E9 C5 FA 6F A4 24 20 02 00 00 C5 E1 DB B4 24 00 02 00 00 C5 E9 72 F4 10 C5 E1 DB 9C 24 10 02 00 00 C5 D9 72 F7 10 C5 D9 FE E3 C5 F9 6E DA C5 E9 FE CE C5 F9 6E F1 C5 F9 70 D3 00 BA 00 00 00 34 C5 E9 DB 9C 24 80 00 00 00 B9 FF 01 00 00 C5 F9 70 F6 00 C5 E9 DB 94 24 90 00 00 00 C5 E1 EF FE C5 FA 7F 84 24 40 02 00 00 C5 F9 72 D0 09 C5 FA 7F AC 24 50 02 00 00 C5 D1 72 D5 09 C5 E9 EF F6 C5 F9 EB C7 C5 D1 EB EE C4 E3 7D 18 ED 01 C5 F9 6E C3 C5 F9 70 F0 00 BB DB 0F C9 40 C4 E3 4D 18 FE 01 C5 C4 58 C5 C5 FC 5C F7 C5 F9 6E FE C5 D4 5C EE BE 00 10 C9 40 C5 FC 11 6C 24 60 C5 F9 6E EF C5 F9 70 F5 00 C5 E9 EF EE BF 7A 77 95 B7 C5 F8 11 84 24 60 02 00 00 C4 E3 7D 19 84 24 70 02 00 00 01 C5 F9 70 C7 00 C5 F9 6E F8 C5 F9 70 FF 00 B8 00 F0 FF FF C5 FA 7F 84 24 80 02 00 00 C5 E1 EF C6 C5 C1 DB F1 C5 C1 DB FC C5 C9 72 F6 05 C5 C1 72 F7 05 C5 C9 EB F0 C5 C1 EB FD C5 F1 72 D1 12 C5 D9 72 D4 12 C4 E3 4D 18 FF 01 C4 E3 7D 18 ED 01 C5 F9 6E C2 C5 C4 5C FD BA FF FF FF 7F C5 F9 70 E8 00 C5 E1 EF C5 C5 F9 6E D9 C5 F9 70 DB 00 C5 E9 EF D5 C5 E1 DB B4 24 40 02 00 00 B9 00 00 80 35 C5 E1 DB 9C 24 50 02 00 00 C5 D1 72 F6 0E C5 E1 72 F3 0E C5 D1 EB E9 C5 E1 EB E4 C5 D1 EB C8 C5 D9 EB DA C4 E3 75 18 EB 01 C5 FC 10 4C 24 60 C4 E3 7D 18 D2 01 C5 D4 5C C2 C5 F9 6E EF C5 F4 58 F0 C5 F4 5C E6 C5 FC 58 DC C5 F9 6E E6 C5 E4 58 D7 C5 F9 6E FB C5 F9 70 DC 00 C5 F9 6E E0 C5 F9 70 C7 00 C5 F9 70 FD 00 C5 F9 70 EC 00 C4 E3 55 18 E5 01 C5 CC 54 E4 C5 CC 5C F4 C4 E3 7D 18 C8 01 C4 E3 65 18 C3 01 C4 E3 45 18 DF 01 C5 FC 59 FC C5 FC 59 EE C5 E4 59 C4 C5 F4 59 D2 C5 F9 6E C9 C5 E4 59 F6 C5 D4 58 C0 C5 F9 6E EA C5 EC 58 E6 C5 F9 70 F5 00 C5 FC 58 D4 C5 FC 10 44 24 40 C5 C4 58 E2 C5 C4 5C DC C5 F9 70 F9 00 C5 E4 58 D2 C4 E3 4D 18 DE 01 C5 FC 54 EB C4 E3 45 18 F7 01 C5 D4 C2 DE 1E C5 D4 C2 EE 12 C5 D4 54 E8 C5 E4 54 E4 C5 E4 54 D2 C5 D4 56 E4 C5 FA 6F AC 24 80 02 00 00 C5 FC 11 14 24 C5 D1 DB 94 24 60 02 00 00 C5 C9 72 F2 04 C5 D1 DB 94 24 70 02 00 00 C5 E9 72 F2 04 C5 F9 7E F6 C5 F9 7E D2 C5 DC 59 DC C4 E3 79 16 F3 01 C4 E3 79 16 F7 02 C4 E3 79 16 F1 03 C4 E3 79 16 94 24 BC 02 00 00 01 C4 E3 79 16 94 24 C0 02 00 00 02 C4 E3 79 16 D0 03 C5 F9 6E 96 ?? ?? ?? ?? C5 F9 6E AB ?? ?? ?? ?? C5 E9 6C F5 C5 F9 6E 97 ?? ?? ?? ?? C5 F9 6E A9 ?? ?? ?? ?? 89 94 24 B8 02 00 00 C5 E9 6C D5 C5 F9 6E AA ?? ?? ?? ?? 8B 94 24 BC 02 00 00 C5 C8 C6 D2 88 89 8C 24 B4 02 00 00 C5 F9 6E B2 ?? ?? ?? ?? 8B 94 24 C0 02 00 00 C5 D1 6C FE C5 F9 6E B0 ?? ?? ?? ?? C5 F9 6E AA ?? ?? ?? ?? C5 D1 6C EE C5 C0 C6 ED 88 C5 F9 6E B3 ?? ?? ?? ?? C5 F9 6E 88 ?? ?? ?? ?? 89 9C 24 98 02 00 00 89 B4 24 94 02 00 00 89 BC 24 9C 02 00 00 C4 E3 6D 18 D5 01 C5 F9 6E AE ?? ?? ?? ?? C5 D1 6C FE C5 F9 6E B1 ?? ?? ?? ?? 8B 8C 24 B8 02 00 00 C5 F9 6E AF ?? ?? ?? ?? C5 D1 6C EE C5 F9 6E B1 ?? ?? ?? ?? 8B 8C 24 BC 02 00 00 C5 C0 C6 ED 88 C5 F9 6E B9 ?? ?? ?? ?? C5 C9 6C F7 C5 F9 6E BA ?? ?? ?? ?? C5 C1 6C F9 C5 C8 C6 F7 88 C4 E3 55 18 EE 01 C5 F9 6E B3 ?? ?? ?? ?? C5 FC 11 6C 24 20 C5 F9 6E AE ?? ?? ?? ?? C5 D1 6C F6 8B 9F ?? ?? ?? ?? 89 9C 24 90 02 00 00 8B 9C 24 A0 02 00 00 8B B4 24 B4 02 00 00 8B BC 24 B8 02 00 00 C5 F9 6E AC 24 90 02 00 00 C5 F9 6E 8E ?? ?? ?? ?? C5 D1 6C F9 C5 FC 11 44 24 40 C5 C8 C6 C7 88 C5 F9 6E B7 ?? ?? ?? ?? C5 F9 6E A9 ?? ?? ?? ?? C5 C9 6C F5 C5 F9 6E 8A ?? ?? ?? ?? C5 F9 6E B8 ?? ?? ?? ?? C5 F1 6C EF C5 C8 C6 CD 88 C5 EC 59 F4 89 9C 24 A0 02 00 00 8B 9C 24 94 02 00 00 C4 E3 7D 18 C1 01 C5 FC 11 44 24 60 C5 DC 59 E8 C5 FC 10 44 24 20 C5 EC 58 54 24 60 C5 FC 58 CD C5 CC 58 F9 C5 FC 5C C1 C5 FC 11 BC 24 80 00 00 00 C5 F4 5C FF C5 FC 58 C5 C5 E4 59 0D ?? ?? ?? ?? C5 C4 58 F6 C5 E4 59 3D ?? ?? ?? ?? C5 CC 58 E8 C5 F4 58 05 ?? ?? ?? ?? C5 C4 58 35 ?? ?? ?? ?? C5 FC 11 AC 24 A0 00 00 00 C5 FC 59 EB C5 CC 59 DB C5 F9 6E B6 ?? ?? ?? ?? C5 D4 59 C4 C5 F9 6E AB ?? ?? ?? ?? 8B 9C 24 98 02 00 00 C5 F9 6E 8B ?? ?? ?? ?? 8B 9C 24 9C 02 00 00 C5 D1 6C E9 C5 F9 6E BB ?? ?? ?? ?? C5 C1 6C CE C5 D0 C6 F9 88 C5 F9 6E B7 ?? ?? ?? ?? C5 F9 6E A9 ?? ?? ?? ?? C5 C9 6C F5 C5 F9 6E 8A ?? ?? ?? ?? C5 F9 6E A8 ?? ?? ?? ?? C5 F1 6C CD C5 FC 10 6C 24 20 C5 C8 C6 F1 88 C5 DC 59 E5 C5 E4 59 DD C5 EC 5C E4 C5 DC 59 14 24 C5 FC 59 C4 8B 9C 24 A0 02 00 00 C4 E3 45 18 CE 01 C5 EC 58 C9 C5 E4 58 D1 C5 FC 58 9C 24 A0 00 00 00 C5 FC 10 44 24 40 C5 EC 58 E3 C5 DC 58 94 24 80 00 00 00 E9 66 F4 FF FF }
	condition:
		$1
}

rule file_0_0_1 {
	meta:
		name = "__Stoul"
		size = 27
		refs = "0012 __Stoulx"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_57_139_2 {
	meta:
		name = "?_Execute_once@std@@YAHAAUonce_flag@1@P6GHPAX1PAPAX@Z1@Z"
		size = 27
		refs = "0012 ___crtInitOnceExecuteOnce"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_21_0_2 {
	meta:
		name = "__Stod"
		size = 27
		refs = "0012 __Stodx"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_28_0_3 {
	meta:
		name = "__Stof"
		size = 27
		refs = "0012 __Stofx"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_86_0_2 {
	meta:
		name = "__Stold"
		size = 27
		refs = "0012 __Stoldx"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_43_0_3 {
	meta:
		name = "__Stoll"
		size = 27
		refs = "0012 __Stollx"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_105_0_3 {
	meta:
		name = "__Stoull"
		size = 27
		refs = "0012 __Stoullx"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_17_0_3 {
	meta:
		name = "__WStod"
		size = 27
		refs = "0012 __WStodx"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_83_0_2 {
	meta:
		name = "__WStof"
		size = 27
		refs = "0012 __WStofx"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_82_0_2 {
	meta:
		name = "__WStold"
		size = 27
		refs = "0012 __WStoldx"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_0_1_1 {
	meta:
		name = "__Stoulx"
		size = 633
		refs = "002e _isspace 0186 _tolower 0198 _digits 019e _memchr 01fa _ndigs 022f __errno"
	strings:
		$1 = { 55 8B EC 83 EC 24 83 7D 14 00 74 09 8B 45 14 C7 00 00 00 00 00 8B 4D 08 89 4D F8 EB 09 8B 55 F8 83 C2 01 89 55 F8 8B 45 F8 0F B6 08 51 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 02 EB E2 8B 55 F8 0F BE 02 83 F8 2D 74 14 8B 4D F8 0F BE 11 83 FA 2B 74 09 C7 45 F0 2B 00 00 00 EB 12 8B 45 F8 0F BE 08 89 4D F0 8B 55 F8 83 C2 01 89 55 F8 8A 45 F0 88 45 FE 83 7D 10 00 7C 0C 83 7D 10 01 74 06 83 7D 10 24 7E 1A 83 7D 0C 00 74 08 8B 4D 0C 8B 55 08 89 11 33 C0 E9 DC 01 00 00 E9 9F 00 00 00 83 7D 10 00 7E 44 83 7D 10 10 75 3C 8B 45 F8 0F BE 08 83 F9 30 75 31 BA 01 00 00 00 C1 E2 00 8B 45 F8 0F BE 0C 10 83 F9 78 74 14 BA 01 00 00 00 C1 E2 00 8B 45 F8 0F BE 0C 10 83 F9 58 75 09 8B 55 F8 83 C2 02 89 55 F8 EB 55 8B 45 F8 0F BE 08 83 F9 30 74 09 C7 45 10 0A 00 00 00 EB 41 BA 01 00 00 00 C1 E2 00 8B 45 F8 0F BE 0C 10 83 F9 78 74 14 BA 01 00 00 00 C1 E2 00 8B 45 F8 0F BE 0C 10 83 F9 58 75 12 C7 45 10 10 00 00 00 8B 55 F8 83 C2 02 89 55 F8 EB 07 C7 45 10 08 00 00 00 8B 45 F8 89 45 E0 EB 09 8B 4D F8 83 C1 01 89 4D F8 8B 55 F8 0F BE 02 83 F8 30 75 02 EB EA C7 45 F4 00 00 00 00 8B 4D F8 89 4D DC C7 45 E4 00 00 00 00 EB 09 8B 55 F8 83 C2 01 89 55 F8 8B 45 10 50 8B 4D F8 0F BE 11 52 E8 ?? ?? ?? ?? 83 C4 04 50 B8 01 00 00 00 6B C8 00 81 C1 ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 83 C4 0C 89 45 EC 83 7D EC 00 74 23 8B 55 F4 89 55 E4 8B 45 EC 2D ?? ?? ?? ?? 88 45 FF 8B 4D F4 0F AF 4D 10 0F BE 55 FF 03 CA 89 4D F4 EB A0 8B 45 E0 3B 45 F8 75 15 83 7D 0C 00 74 08 8B 4D 0C 8B 55 08 89 11 33 C0 E9 87 00 00 00 8B 45 F8 2B 45 DC 8B 4D 10 0F BE 91 ?? ?? ?? ?? 2B C2 89 45 E8 79 02 EB 4C 83 7D E8 00 7F 21 0F BE 45 FF 8B 4D F4 2B C8 39 4D F4 72 13 0F BE 55 FF 8B 45 F4 2B C2 33 D2 F7 75 10 3B 45 E4 74 25 E8 ?? ?? ?? ?? C7 00 22 00 00 00 83 7D 14 00 74 09 8B 45 14 C7 00 01 00 00 00 C7 45 F4 FF FF FF FF C6 45 FE 2B 0F BE 4D FE 83 F9 2D 75 08 33 D2 2B 55 F4 89 55 F4 83 7D 0C 00 74 08 8B 45 0C 8B 4D F8 89 08 8B 45 F4 8B E5 5D C3 }
	condition:
		$1
}

rule file_1_1_1 {
	meta:
		name = "__WStoldx"
		size = 846
		refs = "000a ___security_cookie 0025 __WStopfx 0082 __WStoflt 0094 __real@41cdcd6500000000 00a2 __LXp_setw 00eb __LXp_setn 0114 __LXp_mulx 0156 __LXp_addx 017e __LDtento 01b3 __WStoxflt 01c5 __real@41b0000000000000 02c5 __LDscale 02d9 __LInf 02f0 __LNan 0315 __LPmsw 0346 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 81 EC 7C 01 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 89 85 90 FE FF FF 8B 4D 0C 51 8D 55 08 52 E8 ?? ?? ?? ?? 83 C4 08 89 85 A8 FE FF FF 8B 85 A8 FE FF FF 83 E0 08 89 85 84 FE FF FF 83 7D 14 00 74 09 8B 4D 14 C7 01 00 00 00 00 8B 95 A8 FE FF FF 83 E2 F7 89 95 A8 FE FF FF 83 BD A8 FE FF FF 01 0F 85 24 01 00 00 6A 03 8D 45 EC 50 8B 4D 0C 51 8B 55 08 52 8B 85 90 FE FF FF 50 E8 ?? ?? ?? ?? 83 C4 14 89 85 94 FE FF FF 83 EC 08 DD 05 ?? ?? ?? ?? DD 1C 24 6A 04 8D 4D 8C 51 E8 ?? ?? ?? ?? 83 C4 10 83 BD 94 FE FF FF 00 75 1B 83 EC 08 D9 EE DD 1C 24 6A 04 8D 55 CC 52 E8 ?? ?? ?? ?? 83 C4 10 E9 92 00 00 00 C7 85 A4 FE FF FF 01 00 00 00 B8 04 00 00 00 C1 E0 00 8B 4C 05 EC 51 6A 04 8D 55 CC 52 E8 ?? ?? ?? ?? 83 C4 0C 8B 85 A4 FE FF FF 3B 85 94 FE FF FF 7D 5F 8D 8D EC FE FF FF 51 6A 04 8D 55 8C 52 6A 04 8D 45 CC 50 E8 ?? ?? ?? ?? 83 C4 14 8B 8D A4 FE FF FF 83 C1 01 89 8D A4 FE FF FF 8B 95 A4 FE FF FF 8B 44 95 EC 50 6A 04 8D 8D 6C FF FF FF 51 E8 ?? ?? ?? ?? 83 C4 0C 6A 04 8D 95 6C FF FF FF 52 6A 04 8D 45 CC 50 E8 ?? ?? ?? ?? 83 C4 10 EB 93 B9 04 00 00 00 6B D1 00 8B 45 10 03 44 15 EC 89 45 10 8B 4D 14 51 8B 55 10 52 8D 45 CC 50 E8 ?? ?? ?? ?? 83 C4 0C DD 9D 98 FE FF FF E9 74 01 00 00 83 BD A8 FE FF FF 02 0F 85 31 01 00 00 6A 03 8D 4D EC 51 8B 55 0C 52 8B 45 08 50 8B 8D 90 FE FF FF 51 E8 ?? ?? ?? ?? 83 C4 14 89 85 8C FE FF FF 83 EC 08 DD 05 ?? ?? ?? ?? DD 1C 24 6A 04 8D 95 4C FF FF FF 52 E8 ?? ?? ?? ?? 83 C4 10 83 BD 8C FE FF FF 00 75 1B 83 EC 08 D9 EE DD 1C 24 6A 04 8D 45 AC 50 E8 ?? ?? ?? ?? 83 C4 10 E9 95 00 00 00 C7 85 A0 FE FF FF 01 00 00 00 B9 04 00 00 00 C1 E1 00 8B 54 0D EC 52 6A 04 8D 45 AC 50 E8 ?? ?? ?? ?? 83 C4 0C 8B 8D A0 FE FF FF 3B 8D 8C FE FF FF 7D 62 8D 95 AC FE FF FF 52 6A 04 8D 85 4C FF FF FF 50 6A 04 8D 4D AC 51 E8 ?? ?? ?? ?? 83 C4 14 8B 95 A0 FE FF FF 83 C2 01 89 95 A0 FE FF FF 8B 85 A0 FE FF FF 8B 4C 85 EC 51 6A 04 8D 95 2C FF FF FF 52 E8 ?? ?? ?? ?? 83 C4 0C 6A 04 8D 85 2C FF FF FF 50 6A 04 8D 4D AC 51 E8 ?? ?? ?? ?? 83 C4 10 EB 90 8B 55 14 52 8B 45 10 50 8D 4D AC 51 E8 ?? ?? ?? ?? 83 C4 0C DD 9D 98 FE FF FF BA 04 00 00 00 6B C2 00 8B 4C 05 EC 51 8D 95 98 FE FF FF 52 E8 ?? ?? ?? ?? 83 C4 08 EB 36 83 BD A8 FE FF FF 03 75 0E DD 05 ?? ?? ?? ?? DD 9D 98 FE FF FF EB 1F 83 BD A8 FE FF FF 04 75 0E DD 05 ?? ?? ?? ?? DD 9D 98 FE FF FF EB 08 D9 EE DD 9D 98 FE FF FF 83 BD 84 FE FF FF 00 74 2D 8D 85 98 FE FF FF 50 E8 ?? ?? ?? ?? 83 C4 04 89 85 88 FE FF FF 8B 8D 88 FE FF FF 0F B7 11 81 F2 00 80 00 00 8B 85 88 FE FF FF 66 89 10 DD 85 98 FE FF FF 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_59_1_1 {
	meta:
		name = "__Stodx"
		size = 846
		refs = "000a ___security_cookie 0025 __Stopfx 0082 __Stoflt 0094 __real@41cdcd6500000000 00a2 __Xp_setw 00eb __Xp_setn 0114 __Xp_mulx 0156 __Xp_addx 017e __Dtento 01b3 __Stoxflt 01c5 __real@41b0000000000000 02c5 __Dscale 02d9 __Inf 02f0 __Nan 0315 __Pmsw 0346 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 81 EC 7C 01 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 89 85 90 FE FF FF 8B 4D 0C 51 8D 55 08 52 E8 ?? ?? ?? ?? 83 C4 08 89 85 A8 FE FF FF 8B 85 A8 FE FF FF 83 E0 08 89 85 84 FE FF FF 83 7D 14 00 74 09 8B 4D 14 C7 01 00 00 00 00 8B 95 A8 FE FF FF 83 E2 F7 89 95 A8 FE FF FF 83 BD A8 FE FF FF 01 0F 85 24 01 00 00 6A 03 8D 45 EC 50 8B 4D 0C 51 8B 55 08 52 8B 85 90 FE FF FF 50 E8 ?? ?? ?? ?? 83 C4 14 89 85 94 FE FF FF 83 EC 08 DD 05 ?? ?? ?? ?? DD 1C 24 6A 04 8D 4D 8C 51 E8 ?? ?? ?? ?? 83 C4 10 83 BD 94 FE FF FF 00 75 1B 83 EC 08 D9 EE DD 1C 24 6A 04 8D 55 CC 52 E8 ?? ?? ?? ?? 83 C4 10 E9 92 00 00 00 C7 85 A4 FE FF FF 01 00 00 00 B8 04 00 00 00 C1 E0 00 8B 4C 05 EC 51 6A 04 8D 55 CC 52 E8 ?? ?? ?? ?? 83 C4 0C 8B 85 A4 FE FF FF 3B 85 94 FE FF FF 7D 5F 8D 8D EC FE FF FF 51 6A 04 8D 55 8C 52 6A 04 8D 45 CC 50 E8 ?? ?? ?? ?? 83 C4 14 8B 8D A4 FE FF FF 83 C1 01 89 8D A4 FE FF FF 8B 95 A4 FE FF FF 8B 44 95 EC 50 6A 04 8D 8D 6C FF FF FF 51 E8 ?? ?? ?? ?? 83 C4 0C 6A 04 8D 95 6C FF FF FF 52 6A 04 8D 45 CC 50 E8 ?? ?? ?? ?? 83 C4 10 EB 93 B9 04 00 00 00 6B D1 00 8B 45 10 03 44 15 EC 89 45 10 8B 4D 14 51 8B 55 10 52 8D 45 CC 50 E8 ?? ?? ?? ?? 83 C4 0C DD 9D 98 FE FF FF E9 74 01 00 00 83 BD A8 FE FF FF 02 0F 85 31 01 00 00 6A 03 8D 4D EC 51 8B 55 0C 52 8B 45 08 50 8B 8D 90 FE FF FF 51 E8 ?? ?? ?? ?? 83 C4 14 89 85 8C FE FF FF 83 EC 08 DD 05 ?? ?? ?? ?? DD 1C 24 6A 04 8D 95 4C FF FF FF 52 E8 ?? ?? ?? ?? 83 C4 10 83 BD 8C FE FF FF 00 75 1B 83 EC 08 D9 EE DD 1C 24 6A 04 8D 45 AC 50 E8 ?? ?? ?? ?? 83 C4 10 E9 95 00 00 00 C7 85 A0 FE FF FF 01 00 00 00 B9 04 00 00 00 C1 E1 00 8B 54 0D EC 52 6A 04 8D 45 AC 50 E8 ?? ?? ?? ?? 83 C4 0C 8B 8D A0 FE FF FF 3B 8D 8C FE FF FF 7D 62 8D 95 AC FE FF FF 52 6A 04 8D 85 4C FF FF FF 50 6A 04 8D 4D AC 51 E8 ?? ?? ?? ?? 83 C4 14 8B 95 A0 FE FF FF 83 C2 01 89 95 A0 FE FF FF 8B 85 A0 FE FF FF 8B 4C 85 EC 51 6A 04 8D 95 2C FF FF FF 52 E8 ?? ?? ?? ?? 83 C4 0C 6A 04 8D 85 2C FF FF FF 50 6A 04 8D 4D AC 51 E8 ?? ?? ?? ?? 83 C4 10 EB 90 8B 55 14 52 8B 45 10 50 8D 4D AC 51 E8 ?? ?? ?? ?? 83 C4 0C DD 9D 98 FE FF FF BA 04 00 00 00 6B C2 00 8B 4C 05 EC 51 8D 95 98 FE FF FF 52 E8 ?? ?? ?? ?? 83 C4 08 EB 36 83 BD A8 FE FF FF 03 75 0E DD 05 ?? ?? ?? ?? DD 9D 98 FE FF FF EB 1F 83 BD A8 FE FF FF 04 75 0E DD 05 ?? ?? ?? ?? DD 9D 98 FE FF FF EB 08 D9 EE DD 9D 98 FE FF FF 83 BD 84 FE FF FF 00 74 2D 8D 85 98 FE FF FF 50 E8 ?? ?? ?? ?? 83 C4 04 89 85 88 FE FF FF 8B 8D 88 FE FF FF 0F B7 11 81 F2 00 80 00 00 8B 85 88 FE FF FF 66 89 10 DD 85 98 FE FF FF 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_50_1_1 {
	meta:
		name = "__Stoldx"
		size = 846
		refs = "000a ___security_cookie 0025 __Stopfx 0082 __Stoflt 0094 __real@41cdcd6500000000 00a2 __LXp_setw 00eb __LXp_setn 0114 __LXp_mulx 0156 __LXp_addx 017e __LDtento 01b3 __Stoxflt 01c5 __real@41b0000000000000 02c5 __LDscale 02d9 __LInf 02f0 __LNan 0315 __LPmsw 0346 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 81 EC 7C 01 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 89 85 90 FE FF FF 8B 4D 0C 51 8D 55 08 52 E8 ?? ?? ?? ?? 83 C4 08 89 85 A8 FE FF FF 8B 85 A8 FE FF FF 83 E0 08 89 85 84 FE FF FF 83 7D 14 00 74 09 8B 4D 14 C7 01 00 00 00 00 8B 95 A8 FE FF FF 83 E2 F7 89 95 A8 FE FF FF 83 BD A8 FE FF FF 01 0F 85 24 01 00 00 6A 03 8D 45 EC 50 8B 4D 0C 51 8B 55 08 52 8B 85 90 FE FF FF 50 E8 ?? ?? ?? ?? 83 C4 14 89 85 94 FE FF FF 83 EC 08 DD 05 ?? ?? ?? ?? DD 1C 24 6A 04 8D 4D 8C 51 E8 ?? ?? ?? ?? 83 C4 10 83 BD 94 FE FF FF 00 75 1B 83 EC 08 D9 EE DD 1C 24 6A 04 8D 55 CC 52 E8 ?? ?? ?? ?? 83 C4 10 E9 92 00 00 00 C7 85 A4 FE FF FF 01 00 00 00 B8 04 00 00 00 C1 E0 00 8B 4C 05 EC 51 6A 04 8D 55 CC 52 E8 ?? ?? ?? ?? 83 C4 0C 8B 85 A4 FE FF FF 3B 85 94 FE FF FF 7D 5F 8D 8D EC FE FF FF 51 6A 04 8D 55 8C 52 6A 04 8D 45 CC 50 E8 ?? ?? ?? ?? 83 C4 14 8B 8D A4 FE FF FF 83 C1 01 89 8D A4 FE FF FF 8B 95 A4 FE FF FF 8B 44 95 EC 50 6A 04 8D 8D 6C FF FF FF 51 E8 ?? ?? ?? ?? 83 C4 0C 6A 04 8D 95 6C FF FF FF 52 6A 04 8D 45 CC 50 E8 ?? ?? ?? ?? 83 C4 10 EB 93 B9 04 00 00 00 6B D1 00 8B 45 10 03 44 15 EC 89 45 10 8B 4D 14 51 8B 55 10 52 8D 45 CC 50 E8 ?? ?? ?? ?? 83 C4 0C DD 9D 98 FE FF FF E9 74 01 00 00 83 BD A8 FE FF FF 02 0F 85 31 01 00 00 6A 03 8D 4D EC 51 8B 55 0C 52 8B 45 08 50 8B 8D 90 FE FF FF 51 E8 ?? ?? ?? ?? 83 C4 14 89 85 8C FE FF FF 83 EC 08 DD 05 ?? ?? ?? ?? DD 1C 24 6A 04 8D 95 4C FF FF FF 52 E8 ?? ?? ?? ?? 83 C4 10 83 BD 8C FE FF FF 00 75 1B 83 EC 08 D9 EE DD 1C 24 6A 04 8D 45 AC 50 E8 ?? ?? ?? ?? 83 C4 10 E9 95 00 00 00 C7 85 A0 FE FF FF 01 00 00 00 B9 04 00 00 00 C1 E1 00 8B 54 0D EC 52 6A 04 8D 45 AC 50 E8 ?? ?? ?? ?? 83 C4 0C 8B 8D A0 FE FF FF 3B 8D 8C FE FF FF 7D 62 8D 95 AC FE FF FF 52 6A 04 8D 85 4C FF FF FF 50 6A 04 8D 4D AC 51 E8 ?? ?? ?? ?? 83 C4 14 8B 95 A0 FE FF FF 83 C2 01 89 95 A0 FE FF FF 8B 85 A0 FE FF FF 8B 4C 85 EC 51 6A 04 8D 95 2C FF FF FF 52 E8 ?? ?? ?? ?? 83 C4 0C 6A 04 8D 85 2C FF FF FF 50 6A 04 8D 4D AC 51 E8 ?? ?? ?? ?? 83 C4 10 EB 90 8B 55 14 52 8B 45 10 50 8D 4D AC 51 E8 ?? ?? ?? ?? 83 C4 0C DD 9D 98 FE FF FF BA 04 00 00 00 6B C2 00 8B 4C 05 EC 51 8D 95 98 FE FF FF 52 E8 ?? ?? ?? ?? 83 C4 08 EB 36 83 BD A8 FE FF FF 03 75 0E DD 05 ?? ?? ?? ?? DD 9D 98 FE FF FF EB 1F 83 BD A8 FE FF FF 04 75 0E DD 05 ?? ?? ?? ?? DD 9D 98 FE FF FF EB 08 D9 EE DD 9D 98 FE FF FF 83 BD 84 FE FF FF 00 74 2D 8D 85 98 FE FF FF 50 E8 ?? ?? ?? ?? 83 C4 04 89 85 88 FE FF FF 8B 8D 88 FE FF FF 0F B7 11 81 F2 00 80 00 00 8B 85 88 FE FF FF 66 89 10 DD 85 98 FE FF FF 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_60_1_1 {
	meta:
		name = "__WStodx"
		size = 846
		refs = "000a ___security_cookie 0025 __WStopfx 0082 __WStoflt 0094 __real@41cdcd6500000000 00a2 __Xp_setw 00eb __Xp_setn 0114 __Xp_mulx 0156 __Xp_addx 017e __Dtento 01b3 __WStoxflt 01c5 __real@41b0000000000000 02c5 __Dscale 02d9 __Inf 02f0 __Nan 0315 __Pmsw 0346 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 81 EC 7C 01 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 89 85 90 FE FF FF 8B 4D 0C 51 8D 55 08 52 E8 ?? ?? ?? ?? 83 C4 08 89 85 A8 FE FF FF 8B 85 A8 FE FF FF 83 E0 08 89 85 84 FE FF FF 83 7D 14 00 74 09 8B 4D 14 C7 01 00 00 00 00 8B 95 A8 FE FF FF 83 E2 F7 89 95 A8 FE FF FF 83 BD A8 FE FF FF 01 0F 85 24 01 00 00 6A 03 8D 45 EC 50 8B 4D 0C 51 8B 55 08 52 8B 85 90 FE FF FF 50 E8 ?? ?? ?? ?? 83 C4 14 89 85 94 FE FF FF 83 EC 08 DD 05 ?? ?? ?? ?? DD 1C 24 6A 04 8D 4D 8C 51 E8 ?? ?? ?? ?? 83 C4 10 83 BD 94 FE FF FF 00 75 1B 83 EC 08 D9 EE DD 1C 24 6A 04 8D 55 CC 52 E8 ?? ?? ?? ?? 83 C4 10 E9 92 00 00 00 C7 85 A4 FE FF FF 01 00 00 00 B8 04 00 00 00 C1 E0 00 8B 4C 05 EC 51 6A 04 8D 55 CC 52 E8 ?? ?? ?? ?? 83 C4 0C 8B 85 A4 FE FF FF 3B 85 94 FE FF FF 7D 5F 8D 8D EC FE FF FF 51 6A 04 8D 55 8C 52 6A 04 8D 45 CC 50 E8 ?? ?? ?? ?? 83 C4 14 8B 8D A4 FE FF FF 83 C1 01 89 8D A4 FE FF FF 8B 95 A4 FE FF FF 8B 44 95 EC 50 6A 04 8D 8D 6C FF FF FF 51 E8 ?? ?? ?? ?? 83 C4 0C 6A 04 8D 95 6C FF FF FF 52 6A 04 8D 45 CC 50 E8 ?? ?? ?? ?? 83 C4 10 EB 93 B9 04 00 00 00 6B D1 00 8B 45 10 03 44 15 EC 89 45 10 8B 4D 14 51 8B 55 10 52 8D 45 CC 50 E8 ?? ?? ?? ?? 83 C4 0C DD 9D 98 FE FF FF E9 74 01 00 00 83 BD A8 FE FF FF 02 0F 85 31 01 00 00 6A 03 8D 4D EC 51 8B 55 0C 52 8B 45 08 50 8B 8D 90 FE FF FF 51 E8 ?? ?? ?? ?? 83 C4 14 89 85 8C FE FF FF 83 EC 08 DD 05 ?? ?? ?? ?? DD 1C 24 6A 04 8D 95 4C FF FF FF 52 E8 ?? ?? ?? ?? 83 C4 10 83 BD 8C FE FF FF 00 75 1B 83 EC 08 D9 EE DD 1C 24 6A 04 8D 45 AC 50 E8 ?? ?? ?? ?? 83 C4 10 E9 95 00 00 00 C7 85 A0 FE FF FF 01 00 00 00 B9 04 00 00 00 C1 E1 00 8B 54 0D EC 52 6A 04 8D 45 AC 50 E8 ?? ?? ?? ?? 83 C4 0C 8B 8D A0 FE FF FF 3B 8D 8C FE FF FF 7D 62 8D 95 AC FE FF FF 52 6A 04 8D 85 4C FF FF FF 50 6A 04 8D 4D AC 51 E8 ?? ?? ?? ?? 83 C4 14 8B 95 A0 FE FF FF 83 C2 01 89 95 A0 FE FF FF 8B 85 A0 FE FF FF 8B 4C 85 EC 51 6A 04 8D 95 2C FF FF FF 52 E8 ?? ?? ?? ?? 83 C4 0C 6A 04 8D 85 2C FF FF FF 50 6A 04 8D 4D AC 51 E8 ?? ?? ?? ?? 83 C4 10 EB 90 8B 55 14 52 8B 45 10 50 8D 4D AC 51 E8 ?? ?? ?? ?? 83 C4 0C DD 9D 98 FE FF FF BA 04 00 00 00 6B C2 00 8B 4C 05 EC 51 8D 95 98 FE FF FF 52 E8 ?? ?? ?? ?? 83 C4 08 EB 36 83 BD A8 FE FF FF 03 75 0E DD 05 ?? ?? ?? ?? DD 9D 98 FE FF FF EB 1F 83 BD A8 FE FF FF 04 75 0E DD 05 ?? ?? ?? ?? DD 9D 98 FE FF FF EB 08 D9 EE DD 9D 98 FE FF FF 83 BD 84 FE FF FF 00 74 2D 8D 85 98 FE FF FF 50 E8 ?? ?? ?? ?? 83 C4 04 89 85 88 FE FF FF 8B 8D 88 FE FF FF 0F B7 11 81 F2 00 80 00 00 8B 85 88 FE FF FF 66 89 10 DD 85 98 FE FF FF 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_2_0_1 {
	meta:
		name = "__Getcoll"
		size = 73
		refs = "0007 ____lc_collate_cp_func 000f ____lc_locale_name_func 002a ??_C@_0CL@JDOPBDBF@f?3?2dd?2vctools?2crt?2crtw32?2stdcpp?2@ 0035 __wcsdup_dbg"
	strings:
		$1 = { 55 8B EC 83 EC 08 E8 ?? ?? ?? ?? 89 45 F8 E8 ?? ?? ?? ?? B9 04 00 00 00 C1 E1 00 8B 14 08 89 55 FC 83 7D FC 00 74 18 6A 79 68 ?? ?? ?? ?? 6A 02 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 10 89 45 FC 8B 45 F8 8B 55 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_2_1_1 {
	meta:
		name = "__Strcoll"
		size = 276
		refs = "0026 ____lc_locale_name_func 0039 ____lc_collate_cp_func 007c _memcmp 00e0 ___crtCompareStringA 00f1 __errno"
	strings:
		$1 = { 55 8B EC 83 EC 24 C7 45 FC 00 00 00 00 8B 45 0C 2B 45 08 89 45 F4 8B 4D 14 2B 4D 10 89 4D F8 83 7D 18 00 75 1D E8 ?? ?? ?? ?? BA 04 00 00 00 C1 E2 00 8B 04 10 89 45 F0 E8 ?? ?? ?? ?? 89 45 DC EB 11 8B 4D 18 8B 51 04 89 55 F0 8B 45 18 8B 08 89 4D DC 83 7D F0 00 75 69 8B 55 F4 3B 55 F8 7D 08 8B 45 F4 89 45 EC EB 06 8B 4D F8 89 4D EC 8B 55 EC 52 8B 45 10 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 89 45 E4 83 7D E4 00 75 28 8B 55 F4 3B 55 F8 74 20 8B 45 F4 3B 45 F8 7D 09 C7 45 E8 FF FF FF FF EB 07 C7 45 E8 01 00 00 00 8B 4D E8 89 4D E0 EB 06 8B 55 E4 89 55 E0 8B 45 E0 89 45 FC EB 4B 8B 4D DC 51 8B 55 F8 52 8B 45 10 50 8B 4D F4 51 8B 55 08 52 68 00 10 00 00 8B 45 F0 50 E8 ?? ?? ?? ?? 83 C4 1C 89 45 FC 83 7D FC 00 75 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 C7 45 FC FF FF FF 7F EB 09 8B 4D FC 83 E9 02 89 4D FC 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_3_0_1 {
	meta:
		name = "??$?0$$V@?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@D@std@@@std@@V?$_String_val@U?$_Simple_types@D@std@@@2@$00@std@@QAE@U_Zero_then_variadic_args_t@1@@Z"
		size = 32
		refs = "000b ??0?$_Wrap_alloc@V?$allocator@D@std@@@std@@QAE@XZ 0013 ??0?$_String_val@U?$_Simple_types@D@std@@@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_29_1_1 {
	meta:
		name = "??$?0$$V@?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@G@std@@@std@@V?$_String_val@U?$_Simple_types@G@std@@@2@$00@std@@QAE@U_Zero_then_variadic_args_t@1@@Z"
		size = 32
		refs = "000b ??0?$_Wrap_alloc@V?$allocator@G@std@@@std@@QAE@XZ 0013 ??0?$_String_val@U?$_Simple_types@G@std@@@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_29_2_1 {
	meta:
		name = "??$?0$$V@?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@_W@std@@@std@@V?$_String_val@U?$_Simple_types@_W@std@@@2@$00@std@@QAE@U_Zero_then_variadic_args_t@1@@Z"
		size = 32
		refs = "000b ??0?$_Wrap_alloc@V?$allocator@_W@std@@@std@@QAE@XZ 0013 ??0?$_String_val@U?$_Simple_types@_W@std@@@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_3_2_1 {
	meta:
		name = "??$?8DU?$char_traits@D@std@@@std@@YA_NABV?$istreambuf_iterator@DU?$char_traits@D@std@@@0@0@Z"
		size = 17
		refs = "000b ?equal@?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@QBE_NABV12@@Z"
	strings:
		$1 = { 55 8B EC 8B 45 0C 50 8B 4D 08 E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_44_25_2 {
	meta:
		name = "??$?8GU?$char_traits@G@std@@@std@@YA_NABV?$istreambuf_iterator@GU?$char_traits@G@std@@@0@0@Z"
		size = 17
		refs = "000b ?equal@?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@QBE_NABV12@@Z"
	strings:
		$1 = { 55 8B EC 8B 45 0C 50 8B 4D 08 E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_29_16_1 {
	meta:
		name = "??$?8_WU?$char_traits@_W@std@@@std@@YA_NABV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@0@0@Z"
		size = 17
		refs = "000b ?equal@?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@QBE_NABV12@@Z"
	strings:
		$1 = { 55 8B EC 8B 45 0C 50 8B 4D 08 E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_44_139_2 {
	meta:
		name = "??$destroy@PAD@?$allocator_traits@V?$allocator@D@std@@@std@@SAXAAV?$allocator@D@1@PAPAD@Z"
		size = 17
		refs = "000b ??$destroy@PAD@?$allocator@D@std@@QAEXPAPAD@Z"
	strings:
		$1 = { 55 8B EC 8B 45 0C 50 8B 4D 08 E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_44_142_2 {
	meta:
		name = "??$destroy@PAG@?$allocator_traits@V?$allocator@G@std@@@std@@SAXAAV?$allocator@G@1@PAPAG@Z"
		size = 17
		refs = "000b ??$destroy@PAG@?$allocator@G@std@@QAEXPAPAG@Z"
	strings:
		$1 = { 55 8B EC 8B 45 0C 50 8B 4D 08 E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_6_15_3 {
	meta:
		name = "??$destroy@PA_W@?$allocator_traits@V?$allocator@_W@std@@@std@@SAXAAV?$allocator@_W@1@PAPA_W@Z"
		size = 17
		refs = "000b ??$destroy@PA_W@?$allocator@_W@std@@QAEXPAPA_W@Z"
	strings:
		$1 = { 55 8B EC 8B 45 0C 50 8B 4D 08 E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_46_38_3 {
	meta:
		name = "??$destroy@U_Container_proxy@std@@@?$allocator_traits@V?$allocator@U_Container_proxy@std@@@std@@@std@@SAXAAV?$allocator@U_Container_proxy@std@@@1@PAU_Container_proxy@1@@Z"
		size = 17
		refs = "000b ??$destroy@U_Container_proxy@std@@@?$allocator@U_Container_proxy@std@@@std@@QAEXPAU_Container_proxy@1@@Z"
	strings:
		$1 = { 55 8B EC 8B 45 0C 50 8B 4D 08 E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_3_5_1 {
	meta:
		name = "??$?9DU?$char_traits@D@std@@@std@@YA_NABV?$istreambuf_iterator@DU?$char_traits@D@std@@@0@0@Z"
		size = 50
		refs = "000d ??$?8DU?$char_traits@D@std@@@std@@YA_NABV?$istreambuf_iterator@DU?$char_traits@D@std@@@0@0@Z"
	strings:
		$1 = { 55 8B EC 51 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 0F B6 D0 85 D2 75 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8A 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_29_19_1 {
	meta:
		name = "??$?9GU?$char_traits@G@std@@@std@@YA_NABV?$istreambuf_iterator@GU?$char_traits@G@std@@@0@0@Z"
		size = 50
		refs = "000d ??$?8GU?$char_traits@G@std@@@std@@YA_NABV?$istreambuf_iterator@GU?$char_traits@G@std@@@0@0@Z"
	strings:
		$1 = { 55 8B EC 51 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 0F B6 D0 85 D2 75 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8A 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_100_13_3 {
	meta:
		name = "??$?9V?$allocator@D@std@@V01@@std@@YA_NABU?$_Wrap_alloc@V?$allocator@D@std@@@0@0@Z"
		size = 50
		refs = "000d ??$?8V?$allocator@D@std@@V01@@std@@YA_NABU?$_Wrap_alloc@V?$allocator@D@std@@@0@0@Z"
	strings:
		$1 = { 55 8B EC 51 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 0F B6 D0 85 D2 75 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8A 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_44_32_2 {
	meta:
		name = "??$?9V?$allocator@G@std@@V01@@std@@YA_NABU?$_Wrap_alloc@V?$allocator@G@std@@@0@0@Z"
		size = 50
		refs = "000d ??$?8V?$allocator@G@std@@V01@@std@@YA_NABU?$_Wrap_alloc@V?$allocator@G@std@@@0@0@Z"
	strings:
		$1 = { 55 8B EC 51 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 0F B6 D0 85 D2 75 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8A 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_44_33_2 {
	meta:
		name = "??$?9V?$allocator@_W@std@@V01@@std@@YA_NABU?$_Wrap_alloc@V?$allocator@_W@std@@@0@0@Z"
		size = 50
		refs = "000d ??$?8V?$allocator@_W@std@@V01@@std@@YA_NABU?$_Wrap_alloc@V?$allocator@_W@std@@@0@0@Z"
	strings:
		$1 = { 55 8B EC 51 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 0F B6 D0 85 D2 75 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8A 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_44_34_2 {
	meta:
		name = "??$?9_WU?$char_traits@_W@std@@@std@@YA_NABV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@0@0@Z"
		size = 50
		refs = "000d ??$?8_WU?$char_traits@_W@std@@@std@@YA_NABV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@0@0@Z"
	strings:
		$1 = { 55 8B EC 51 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 0F B6 D0 85 D2 75 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8A 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_3_7_1 {
	meta:
		name = "??$_Find_elem@D@std@@YAIPADD@Z"
		size = 57
	strings:
		$1 = { 55 8B EC 51 8B 45 08 89 45 FC EB 09 8B 4D FC 83 C1 01 89 4D FC 8B 55 FC 0F BE 02 85 C0 74 10 8B 4D FC 0F BE 11 0F BE 45 0C 3B D0 74 02 EB DD 8B 45 FC 2B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_3_8_1 {
	meta:
		name = "??$_Getloctxt@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@YAHAAV?$istreambuf_iterator@DU?$char_traits@D@std@@@0@0IPBD@Z"
		size = 592
		refs = "0006 __ehhandler$??$_Getloctxt@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@YAHAAV?$istreambuf_iterator@DU?$char_traits@D@std@@@0@0IPBD@Z 0015 ___security_cookie 0079 ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@ID@Z 00a1 ??E?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@QAEAAV01@XZ 0113 ??A?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAADI@Z 01a1 ??$?8DU?$char_traits@D@std@@@std@@YA_NABV?$istreambuf_iterator@DU?$char_traits@D@std@@@0@0@Z 01bc ??D?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@QBEDXZ 022f ??1?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@XZ 0248 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 40 A1 ?? ?? ?? ?? 33 C5 89 45 F0 56 50 8D 45 F4 64 A3 00 00 00 00 C7 45 C4 00 00 00 00 EB 09 8B 45 C4 83 C0 01 89 45 C4 8B 4D 14 03 4D C4 0F BE 11 85 D2 74 27 8B 45 14 03 45 C4 0F BE 08 BA 01 00 00 00 6B C2 00 8B 55 14 0F BE 04 02 3B C8 75 09 8B 4D 10 83 C1 01 89 4D 10 EB C3 6A 00 8B 55 10 52 8D 4D D8 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 C7 45 C0 FE FF FF FF C7 45 C8 01 00 00 00 EB 18 8B 45 C8 83 C0 01 89 45 C8 8B 4D 08 E8 ?? ?? ?? ?? C7 45 C0 FF FF FF FF C6 45 D7 00 C7 45 D0 00 00 00 00 C7 45 CC 00 00 00 00 EB 09 8B 4D CC 83 C1 01 89 4D CC 8B 55 CC 3B 55 10 0F 83 23 01 00 00 EB 09 8B 45 D0 83 C0 01 89 45 D0 8B 4D 14 03 4D D0 0F BE 11 85 D2 74 1E 8B 45 14 03 45 D0 0F BE 08 BA 01 00 00 00 6B C2 00 8B 55 14 0F BE 04 02 3B C8 74 02 EB CC 8B 4D CC 51 8D 4D D8 E8 ?? ?? ?? ?? 0F BE 10 85 D2 74 1A 8B 45 CC 50 8D 4D D8 E8 ?? ?? ?? ?? 0F BE 08 03 4D D0 89 4D D0 E9 BB 00 00 00 8B 55 D0 03 55 C8 89 55 D0 8B 45 14 03 45 D0 0F BE 08 BA 01 00 00 00 6B C2 00 8B 55 14 0F BE 04 02 3B C8 74 0D 8B 4D 14 03 4D D0 0F BE 11 85 D2 75 2E 83 7D C8 7F 73 08 8B 45 C8 89 45 BC EB 07 C7 45 BC 7F 00 00 00 8B 4D CC 51 8D 4D D8 E8 ?? ?? ?? ?? 8A 55 BC 88 10 8B 45 CC 89 45 C0 EB 5B 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 08 0F B6 C0 85 C0 75 18 8B 4D 14 03 4D D0 0F BE 31 8B 4D 08 E8 ?? ?? ?? ?? 0F BE D0 3B F2 74 28 83 7D C8 7F 73 08 8B 45 C8 89 45 B8 EB 07 C7 45 B8 7F 00 00 00 8B 4D CC 51 8D 4D D8 E8 ?? ?? ?? ?? 8A 55 B8 88 10 EB 04 C6 45 D7 01 E9 C8 FE FF FF 0F B6 45 D7 85 C0 74 17 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 08 0F B6 C0 85 C0 74 02 EB 05 E9 76 FE FF FF 8B 4D C0 89 4D B4 C7 45 FC FF FF FF FF 8D 4D D8 E8 ?? ?? ?? ?? 8B 45 B4 8B 4D F4 64 89 0D 00 00 00 00 59 5E 8B 4D F0 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_3_10_1 {
	meta:
		name = "__ehhandler$??$_Getloctxt@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@YAHAAV?$istreambuf_iterator@DU?$char_traits@D@std@@@0@0IPBD@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$??$_Getloctxt@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@YAHAAV?$istreambuf_iterator@DU?$char_traits@D@std@@@0@0IPBD@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B8 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_29_36_1 {
	meta:
		name = "__ehhandler$??$_Getloctxt@DV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@YAHAAV?$istreambuf_iterator@GU?$char_traits@G@std@@@0@0IPBD@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$??$_Getloctxt@DV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@YAHAAV?$istreambuf_iterator@GU?$char_traits@G@std@@@0@0IPBD@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B8 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_29_39_1 {
	meta:
		name = "__ehhandler$??$_Getloctxt@DV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@YAHAAV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@0@0IPBD@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$??$_Getloctxt@DV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@YAHAAV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@0@0IPBD@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B8 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_29_42_1 {
	meta:
		name = "__ehhandler$??$_Getloctxt@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@YAHAAV?$istreambuf_iterator@GU?$char_traits@G@std@@@0@0IPBG@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$??$_Getloctxt@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@YAHAAV?$istreambuf_iterator@GU?$char_traits@G@std@@@0@0IPBG@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B8 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_29_45_1 {
	meta:
		name = "__ehhandler$??$_Getloctxt@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@YAHAAV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@0@0IPB_W@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$??$_Getloctxt@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@YAHAAV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@0@0IPB_W@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B8 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_100_546_3 {
	meta:
		name = "__ehhandler$?do_get@?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0_NAAVios_base@2@AAHAAO@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?do_get@?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0_NAAVios_base@2@AAHAAO@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B8 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_3_329_1 {
	meta:
		name = "__ehhandler$?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHAAJ@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHAAJ@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B8 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_3_332_1 {
	meta:
		name = "__ehhandler$?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHAAK@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHAAK@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B8 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_1294_2 {
	meta:
		name = "__ehhandler$?do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHAAJ@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHAAJ@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B8 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_1297_2 {
	meta:
		name = "__ehhandler$?do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHAAK@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHAAK@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B8 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_1325_2 {
	meta:
		name = "__ehhandler$?do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHAAJ@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHAAJ@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B8 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_1328_2 {
	meta:
		name = "__ehhandler$?do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHAAK@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHAAK@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B8 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_3_11_1 {
	meta:
		name = "??$_Getvals@D@?$numpunct@D@std@@IAEXDPBUlconv@@U_Cvtvec@@@Z"
		size = 90
		refs = "0020 ??$_Maklocchr@D@std@@YADDPADABU_Cvtvec@@@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8D 45 10 50 6A 00 B9 01 00 00 00 6B D1 00 8B 45 0C 8B 08 0F B6 14 11 52 E8 ?? ?? ?? ?? 83 C4 0C 8B 4D FC 88 41 0C 8D 55 10 52 6A 00 B8 01 00 00 00 6B C8 00 8B 55 0C 8B 42 04 0F B6 0C 08 51 E8 ?? ?? ?? ?? 83 C4 0C 8B 55 FC 88 42 0D 8B E5 5D C2 34 00 }
	condition:
		$1
}

rule file_3_13_1 {
	meta:
		name = "??$_Maklocstr@D@std@@YAPADPBDPADABU_Cvtvec@@@Z"
		size = 124
		refs = "000b _strlen 001e ??_C@_0CI@FIAODHFJ@f?3?2dd?2vctools?2crt?2crtw32?2stdhpp?2@ 002b __calloc_dbg 003c ?_Xbad_alloc@std@@YAXXZ"
	strings:
		$1 = { 55 8B EC 83 EC 0C 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 83 C0 01 89 45 FC 68 D3 02 00 00 68 ?? ?? ?? ?? 6A 02 6A 01 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 14 89 45 F4 83 7D F4 00 75 05 E8 ?? ?? ?? ?? 8B 55 F4 89 55 F8 EB 1B 8B 45 FC 83 E8 01 89 45 FC 8B 4D F8 83 C1 01 89 4D F8 8B 55 08 83 C2 01 89 55 08 83 7D FC 00 76 0C 8B 45 F8 8B 4D 08 8A 11 88 10 EB D3 8B 45 F4 8B E5 5D C3 }
	condition:
		$1
}

rule file_3_14_1 {
	meta:
		name = "??$_Pocca@U?$_Wrap_alloc@V?$allocator@D@std@@@std@@@std@@YAXAAU?$_Wrap_alloc@V?$allocator@D@std@@@0@ABU10@@Z"
		size = 29
		refs = "0012 ??$_Pocca@U?$_Wrap_alloc@V?$allocator@D@std@@@std@@@std@@YAXAAU?$_Wrap_alloc@V?$allocator@D@std@@@0@ABU10@U?$integral_constant@_N$0A@@0@@Z"
	strings:
		$1 = { 55 8B EC 51 0F B6 45 FF 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_29_63_1 {
	meta:
		name = "??$_Pocca@U?$_Wrap_alloc@V?$allocator@G@std@@@std@@@std@@YAXAAU?$_Wrap_alloc@V?$allocator@G@std@@@0@ABU10@@Z"
		size = 29
		refs = "0012 ??$_Pocca@U?$_Wrap_alloc@V?$allocator@G@std@@@std@@@std@@YAXAAU?$_Wrap_alloc@V?$allocator@G@std@@@0@ABU10@U?$integral_constant@_N$0A@@0@@Z"
	strings:
		$1 = { 55 8B EC 51 0F B6 45 FF 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_29_65_1 {
	meta:
		name = "??$_Pocca@U?$_Wrap_alloc@V?$allocator@_W@std@@@std@@@std@@YAXAAU?$_Wrap_alloc@V?$allocator@_W@std@@@0@ABU10@@Z"
		size = 29
		refs = "0012 ??$_Pocca@U?$_Wrap_alloc@V?$allocator@_W@std@@@std@@@std@@YAXAAU?$_Wrap_alloc@V?$allocator@_W@std@@@0@ABU10@U?$integral_constant@_N$0A@@0@@Z"
	strings:
		$1 = { 55 8B EC 51 0F B6 45 FF 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_100_43_3 {
	meta:
		name = "??$_Pocma@U?$_Wrap_alloc@V?$allocator@D@std@@@std@@@std@@YAXAAU?$_Wrap_alloc@V?$allocator@D@std@@@0@0@Z"
		size = 29
		refs = "0012 ??$_Pocma@U?$_Wrap_alloc@V?$allocator@D@std@@@std@@@std@@YAXAAU?$_Wrap_alloc@V?$allocator@D@std@@@0@0U?$integral_constant@_N$00@0@@Z"
	strings:
		$1 = { 55 8B EC 51 0F B6 45 FF 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_44_79_2 {
	meta:
		name = "??$_Pocma@U?$_Wrap_alloc@V?$allocator@G@std@@@std@@@std@@YAXAAU?$_Wrap_alloc@V?$allocator@G@std@@@0@0@Z"
		size = 29
		refs = "0012 ??$_Pocma@U?$_Wrap_alloc@V?$allocator@G@std@@@std@@@std@@YAXAAU?$_Wrap_alloc@V?$allocator@G@std@@@0@0U?$integral_constant@_N$00@0@@Z"
	strings:
		$1 = { 55 8B EC 51 0F B6 45 FF 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_44_82_2 {
	meta:
		name = "??$_Pocma@U?$_Wrap_alloc@V?$allocator@_W@std@@@std@@@std@@YAXAAU?$_Wrap_alloc@V?$allocator@_W@std@@@0@0@Z"
		size = 29
		refs = "0012 ??$_Pocma@U?$_Wrap_alloc@V?$allocator@_W@std@@@std@@@std@@YAXAAU?$_Wrap_alloc@V?$allocator@_W@std@@@0@0U?$integral_constant@_N$00@0@@Z"
	strings:
		$1 = { 55 8B EC 51 0F B6 45 FF 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_57_17_2 {
	meta:
		name = "??$_Pocs@U?$_Wrap_alloc@V?$allocator@D@std@@@std@@@std@@YAXAAU?$_Wrap_alloc@V?$allocator@D@std@@@0@0@Z"
		size = 29
		refs = "0012 ??$_Pocs@U?$_Wrap_alloc@V?$allocator@D@std@@@std@@@std@@YAXAAU?$_Wrap_alloc@V?$allocator@D@std@@@0@0U?$integral_constant@_N$0A@@0@@Z"
	strings:
		$1 = { 55 8B EC 51 0F B6 45 FF 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_93_27_1 {
	meta:
		name = "??$destroy@V?$_Ref_count_obj_alloc@V__ExceptionPtr@@U?$_StaticAllocator@H@@@std@@@?$allocator_traits@U?$_StaticAllocator@V?$_Ref_count_obj_alloc@V__ExceptionPtr@@U?$_StaticAllocator@H@@@std@@@@@std@@SAXAAU?$_StaticAllocator@V?$_Ref_count_obj_alloc@V__ExceptionPtr@@U?$_StaticAllocator@H@@@std@@@@PAV?$_Ref_count_obj_alloc@V__ExceptionPtr@@U?$_StaticAllocator@H@@@1@@Z"
		size = 29
		refs = "0012 ??$_Destroy1@V?$_Ref_count_obj_alloc@V__ExceptionPtr@@U?$_StaticAllocator@H@@@std@@@?$allocator_traits@U?$_StaticAllocator@V?$_Ref_count_obj_alloc@V__ExceptionPtr@@U?$_StaticAllocator@H@@@std@@@@@std@@SAXAAU?$_StaticAllocator@V?$_Ref_count_obj_alloc@V__ExceptionPtr@@U?$_StaticAllocator@H@@@std@@@@PAV?$_Ref_count_obj_alloc@V__ExceptionPtr@@U?$_StaticAllocator@H@@@1@U?$integral_constant@_N$00@1@@Z"
	strings:
		$1 = { 55 8B EC 51 0F B6 45 FF 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_3_19_1 {
	meta:
		name = "??$construct@PADAAPAD@?$_Wrap_alloc@V?$allocator@D@std@@@std@@QAEXPAPADAAPAD@Z"
		size = 42
		refs = "000c ??$forward@AAPAD@std@@YAAAPADAAPAD@Z 001d ??$construct@PADAAPAD@?$allocator_traits@V?$allocator@D@std@@@std@@SAXAAV?$allocator@D@1@PAPADAAPAD@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 0C 50 E8 ?? ?? ?? ?? 83 C4 04 50 8B 4D 08 51 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_29_96_1 {
	meta:
		name = "??$construct@PAGAAPAG@?$_Wrap_alloc@V?$allocator@G@std@@@std@@QAEXPAPAGAAPAG@Z"
		size = 42
		refs = "000c ??$forward@AAPAG@std@@YAAAPAGAAPAG@Z 001d ??$construct@PAGAAPAG@?$allocator_traits@V?$allocator@G@std@@@std@@SAXAAV?$allocator@G@1@PAPAGAAPAG@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 0C 50 E8 ?? ?? ?? ?? 83 C4 04 50 8B 4D 08 51 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_29_99_1 {
	meta:
		name = "??$construct@PA_WAAPA_W@?$_Wrap_alloc@V?$allocator@_W@std@@@std@@QAEXPAPA_WAAPA_W@Z"
		size = 42
		refs = "000c ??$forward@AAPA_W@std@@YAAAPA_WAAPA_W@Z 001d ??$construct@PA_WAAPA_W@?$allocator_traits@V?$allocator@_W@std@@@std@@SAXAAV?$allocator@_W@1@PAPA_WAAPA_W@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 0C 50 E8 ?? ?? ?? ?? 83 C4 04 50 8B 4D 08 51 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_6_10_3 {
	meta:
		name = "??$construct@U_Container_proxy@std@@U12@@?$_Wrap_alloc@V?$allocator@U_Container_proxy@std@@@std@@@std@@QAEXPAU_Container_proxy@1@$$QAU21@@Z"
		size = 42
		refs = "000c ??$forward@U_Container_proxy@std@@@std@@YA$$QAU_Container_proxy@0@AAU10@@Z 001d ??$construct@U_Container_proxy@std@@U12@@?$allocator_traits@V?$allocator@U_Container_proxy@std@@@std@@@std@@SAXAAV?$allocator@U_Container_proxy@std@@@1@PAU_Container_proxy@1@$$QAU31@@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 0C 50 E8 ?? ?? ?? ?? 83 C4 04 50 8B 4D 08 51 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_3_20_1 {
	meta:
		name = "??$construct@PADAAPAD@?$allocator@D@std@@QAEXPAPADAAPAD@Z"
		size = 72
		refs = "0010 ??2@YAPAXIPAX@Z 0025 ??$forward@AAPAD@std@@YAAAPADAAPAD@Z"
	strings:
		$1 = { 55 8B EC 83 EC 0C 89 4D F4 8B 45 08 50 6A 04 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 1B 8B 4D 0C 51 E8 ?? ?? ?? ?? 83 C4 04 8B 55 FC 8B 00 89 02 8B 4D FC 89 4D F8 EB 07 C7 45 F8 00 00 00 00 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_29_97_1 {
	meta:
		name = "??$construct@PAGAAPAG@?$allocator@G@std@@QAEXPAPAGAAPAG@Z"
		size = 72
		refs = "0010 ??2@YAPAXIPAX@Z 0025 ??$forward@AAPAG@std@@YAAAPAGAAPAG@Z"
	strings:
		$1 = { 55 8B EC 83 EC 0C 89 4D F4 8B 45 08 50 6A 04 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 1B 8B 4D 0C 51 E8 ?? ?? ?? ?? 83 C4 04 8B 55 FC 8B 00 89 02 8B 4D FC 89 4D F8 EB 07 C7 45 F8 00 00 00 00 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_29_100_1 {
	meta:
		name = "??$construct@PA_WAAPA_W@?$allocator@_W@std@@QAEXPAPA_WAAPA_W@Z"
		size = 72
		refs = "0010 ??2@YAPAXIPAX@Z 0025 ??$forward@AAPA_W@std@@YAAAPA_WAAPA_W@Z"
	strings:
		$1 = { 55 8B EC 83 EC 0C 89 4D F4 8B 45 08 50 6A 04 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 1B 8B 4D 0C 51 E8 ?? ?? ?? ?? 83 C4 04 8B 55 FC 8B 00 89 02 8B 4D FC 89 4D F8 EB 07 C7 45 F8 00 00 00 00 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_3_21_1 {
	meta:
		name = "??$construct@PADAAPAD@?$allocator_traits@V?$allocator@D@std@@@std@@SAXAAV?$allocator@D@1@PAPADAAPAD@Z"
		size = 30
		refs = "0008 ??$forward@AAPAD@std@@YAAAPADAAPAD@Z 0018 ??$construct@PADAAPAD@?$allocator@D@std@@QAEXPAPADAAPAD@Z"
	strings:
		$1 = { 55 8B EC 8B 45 10 50 E8 ?? ?? ?? ?? 83 C4 04 50 8B 4D 0C 51 8B 4D 08 E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_29_98_1 {
	meta:
		name = "??$construct@PAGAAPAG@?$allocator_traits@V?$allocator@G@std@@@std@@SAXAAV?$allocator@G@1@PAPAGAAPAG@Z"
		size = 30
		refs = "0008 ??$forward@AAPAG@std@@YAAAPAGAAPAG@Z 0018 ??$construct@PAGAAPAG@?$allocator@G@std@@QAEXPAPAGAAPAG@Z"
	strings:
		$1 = { 55 8B EC 8B 45 10 50 E8 ?? ?? ?? ?? 83 C4 04 50 8B 4D 0C 51 8B 4D 08 E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_29_101_1 {
	meta:
		name = "??$construct@PA_WAAPA_W@?$allocator_traits@V?$allocator@_W@std@@@std@@SAXAAV?$allocator@_W@1@PAPA_WAAPA_W@Z"
		size = 30
		refs = "0008 ??$forward@AAPA_W@std@@YAAAPA_WAAPA_W@Z 0018 ??$construct@PA_WAAPA_W@?$allocator@_W@std@@QAEXPAPA_WAAPA_W@Z"
	strings:
		$1 = { 55 8B EC 8B 45 10 50 E8 ?? ?? ?? ?? 83 C4 04 50 8B 4D 0C 51 8B 4D 08 E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_6_12_3 {
	meta:
		name = "??$construct@U_Container_proxy@std@@U12@@?$allocator_traits@V?$allocator@U_Container_proxy@std@@@std@@@std@@SAXAAV?$allocator@U_Container_proxy@std@@@1@PAU_Container_proxy@1@$$QAU31@@Z"
		size = 30
		refs = "0008 ??$forward@U_Container_proxy@std@@@std@@YA$$QAU_Container_proxy@0@AAU10@@Z 0018 ??$construct@U_Container_proxy@std@@U12@@?$allocator@U_Container_proxy@std@@@std@@QAEXPAU_Container_proxy@1@$$QAU21@@Z"
	strings:
		$1 = { 55 8B EC 8B 45 10 50 E8 ?? ?? ?? ?? 83 C4 04 50 8B 4D 0C 51 8B 4D 08 E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_3_22_1 {
	meta:
		name = "??$destroy@PAD@?$_Wrap_alloc@V?$allocator@D@std@@@std@@QAEXPAPAD@Z"
		size = 29
		refs = "0010 ??$destroy@PAD@?$allocator_traits@V?$allocator@D@std@@@std@@SAXAAV?$allocator@D@1@PAPAD@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 08 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_29_107_1 {
	meta:
		name = "??$destroy@PAG@?$_Wrap_alloc@V?$allocator@G@std@@@std@@QAEXPAPAG@Z"
		size = 29
		refs = "0010 ??$destroy@PAG@?$allocator_traits@V?$allocator@G@std@@@std@@SAXAAV?$allocator@G@1@PAPAG@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 08 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_29_110_1 {
	meta:
		name = "??$destroy@PA_W@?$_Wrap_alloc@V?$allocator@_W@std@@@std@@QAEXPAPA_W@Z"
		size = 29
		refs = "0010 ??$destroy@PA_W@?$allocator_traits@V?$allocator@_W@std@@@std@@SAXAAV?$allocator@_W@1@PAPA_W@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 08 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_49_20_3 {
	meta:
		name = "??$destroy@U_Container_proxy@std@@@?$_Wrap_alloc@V?$allocator@U_Container_proxy@std@@@std@@@std@@QAEXPAU_Container_proxy@1@@Z"
		size = 29
		refs = "0010 ??$destroy@U_Container_proxy@std@@@?$allocator_traits@V?$allocator@U_Container_proxy@std@@@std@@@std@@SAXAAV?$allocator@U_Container_proxy@std@@@1@PAU_Container_proxy@1@@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 08 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_79_26_2 {
	meta:
		name = "??$destroy@V?$_Ref_count_obj_alloc@V__ExceptionPtr@@U?$_StaticAllocator@H@@@std@@@?$_Wrap_alloc@U?$_StaticAllocator@V?$_Ref_count_obj_alloc@V__ExceptionPtr@@U?$_StaticAllocator@H@@@std@@@@@std@@QAEXPAV?$_Ref_count_obj_alloc@V__ExceptionPtr@@U?$_StaticAllocator@H@@@1@@Z"
		size = 29
		refs = "0010 ??$destroy@V?$_Ref_count_obj_alloc@V__ExceptionPtr@@U?$_StaticAllocator@H@@@std@@@?$allocator_traits@U?$_StaticAllocator@V?$_Ref_count_obj_alloc@V__ExceptionPtr@@U?$_StaticAllocator@H@@@std@@@@@std@@SAXAAU?$_StaticAllocator@V?$_Ref_count_obj_alloc@V__ExceptionPtr@@U?$_StaticAllocator@H@@@std@@@@PAV?$_Ref_count_obj_alloc@V__ExceptionPtr@@U?$_StaticAllocator@H@@@1@@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 08 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_3_27_1 {
	meta:
		name = "??$use_facet@V?$codecvt@DDU_Mbstatet@@@std@@@std@@YAABV?$codecvt@DDU_Mbstatet@@@0@ABVlocale@0@@Z"
		size = 254
		refs = "0006 __ehhandler$??$use_facet@V?$codecvt@DDU_Mbstatet@@@std@@@std@@YAABV?$codecvt@DDU_Mbstatet@@@0@ABVlocale@0@@Z 0015 ___security_cookie 002b ??0_Lockit@std@@QAE@H@Z 0037 ?_Psave@?$_Facetptr@V?$codecvt@DDU_Mbstatet@@@std@@@std@@2PBVfacet@locale@2@B 003f ?id@?$codecvt@DDU_Mbstatet@@@std@@2V0locale@2@A 0044 ??Bid@locale@std@@QAEIXZ 0053 ?_Getfacet@locale@std@@QBEPBVfacet@12@I@Z 0079 ?_Getcat@?$codecvt@DDU_Mbstatet@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0089 ??0bad_cast@std@@QAE@XZ 008e __TI2?AVbad_cast@std@@ 0097 __CxxThrowException@8 00c1 @_guard_check_icall@4 00d0 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00e8 ??1_Lockit@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 28 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 6A 00 8D 4D DC E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 A1 ?? ?? ?? ?? 89 45 F0 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 E0 8B 4D E0 51 8B 4D 08 E8 ?? ?? ?? ?? 89 45 EC 83 7D EC 00 74 02 EB 75 83 7D F0 00 74 08 8B 55 F0 89 55 EC EB 67 8B 45 08 50 8D 4D F0 51 E8 ?? ?? ?? ?? 83 C4 08 83 F8 FF 75 18 8D 4D CC E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 55 CC 52 E8 ?? ?? ?? ?? EB 3A 8B 45 F0 89 45 EC 8B 4D F0 89 0D ?? ?? ?? ?? 8B 55 F0 89 55 E8 8B 45 E8 8B 08 8B 51 04 89 55 E4 8B 4D E4 E8 ?? ?? ?? ?? 8B 4D E8 FF 55 E4 8B 45 E8 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D EC 89 4D D8 C7 45 FC FF FF FF FF 8D 4D DC E8 ?? ?? ?? ?? 8B 45 D8 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_29_127_1 {
	meta:
		name = "??$use_facet@V?$codecvt@GDU_Mbstatet@@@std@@@std@@YAABV?$codecvt@GDU_Mbstatet@@@0@ABVlocale@0@@Z"
		size = 254
		refs = "0006 __ehhandler$??$use_facet@V?$codecvt@GDU_Mbstatet@@@std@@@std@@YAABV?$codecvt@GDU_Mbstatet@@@0@ABVlocale@0@@Z 0015 ___security_cookie 002b ??0_Lockit@std@@QAE@H@Z 0037 ?_Psave@?$_Facetptr@V?$codecvt@GDU_Mbstatet@@@std@@@std@@2PBVfacet@locale@2@B 003f ?id@?$codecvt@GDU_Mbstatet@@@std@@2V0locale@2@A 0044 ??Bid@locale@std@@QAEIXZ 0053 ?_Getfacet@locale@std@@QBEPBVfacet@12@I@Z 0079 ?_Getcat@?$codecvt@GDU_Mbstatet@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0089 ??0bad_cast@std@@QAE@XZ 008e __TI2?AVbad_cast@std@@ 0097 __CxxThrowException@8 00c1 @_guard_check_icall@4 00d0 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00e8 ??1_Lockit@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 28 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 6A 00 8D 4D DC E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 A1 ?? ?? ?? ?? 89 45 F0 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 E0 8B 4D E0 51 8B 4D 08 E8 ?? ?? ?? ?? 89 45 EC 83 7D EC 00 74 02 EB 75 83 7D F0 00 74 08 8B 55 F0 89 55 EC EB 67 8B 45 08 50 8D 4D F0 51 E8 ?? ?? ?? ?? 83 C4 08 83 F8 FF 75 18 8D 4D CC E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 55 CC 52 E8 ?? ?? ?? ?? EB 3A 8B 45 F0 89 45 EC 8B 4D F0 89 0D ?? ?? ?? ?? 8B 55 F0 89 55 E8 8B 45 E8 8B 08 8B 51 04 89 55 E4 8B 4D E4 E8 ?? ?? ?? ?? 8B 4D E8 FF 55 E4 8B 45 E8 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D EC 89 4D D8 C7 45 FC FF FF FF FF 8D 4D DC E8 ?? ?? ?? ?? 8B 45 D8 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_75_24_1 {
	meta:
		name = "??$use_facet@V?$codecvt@_WDU_Mbstatet@@@std@@@std@@YAABV?$codecvt@_WDU_Mbstatet@@@0@ABVlocale@0@@Z"
		size = 254
		refs = "0006 __ehhandler$??$use_facet@V?$codecvt@_WDU_Mbstatet@@@std@@@std@@YAABV?$codecvt@_WDU_Mbstatet@@@0@ABVlocale@0@@Z 0015 ___security_cookie 002b ??0_Lockit@std@@QAE@H@Z 0037 ?_Psave@?$_Facetptr@V?$codecvt@_WDU_Mbstatet@@@std@@@std@@2PBVfacet@locale@2@B 003f ?id@?$codecvt@_WDU_Mbstatet@@@std@@2V0locale@2@A 0044 ??Bid@locale@std@@QAEIXZ 0053 ?_Getfacet@locale@std@@QBEPBVfacet@12@I@Z 0079 ?_Getcat@?$codecvt@_WDU_Mbstatet@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0089 ??0bad_cast@std@@QAE@XZ 008e __TI2?AVbad_cast@std@@ 0097 __CxxThrowException@8 00c1 @_guard_check_icall@4 00d0 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00e8 ??1_Lockit@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 28 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 6A 00 8D 4D DC E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 A1 ?? ?? ?? ?? 89 45 F0 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 E0 8B 4D E0 51 8B 4D 08 E8 ?? ?? ?? ?? 89 45 EC 83 7D EC 00 74 02 EB 75 83 7D F0 00 74 08 8B 55 F0 89 55 EC EB 67 8B 45 08 50 8D 4D F0 51 E8 ?? ?? ?? ?? 83 C4 08 83 F8 FF 75 18 8D 4D CC E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 55 CC 52 E8 ?? ?? ?? ?? EB 3A 8B 45 F0 89 45 EC 8B 4D F0 89 0D ?? ?? ?? ?? 8B 55 F0 89 55 E8 8B 45 E8 8B 08 8B 51 04 89 55 E4 8B 4D E4 E8 ?? ?? ?? ?? 8B 4D E8 FF 55 E4 8B 45 E8 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D EC 89 4D D8 C7 45 FC FF FF FF FF 8D 4D DC E8 ?? ?? ?? ?? 8B 45 D8 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_80_50_1 {
	meta:
		name = "??$use_facet@V?$collate@D@std@@@std@@YAABV?$collate@D@0@ABVlocale@0@@Z"
		size = 254
		refs = "0006 __ehhandler$??$use_facet@V?$collate@D@std@@@std@@YAABV?$collate@D@0@ABVlocale@0@@Z 0015 ___security_cookie 002b ??0_Lockit@std@@QAE@H@Z 0037 ?_Psave@?$_Facetptr@V?$collate@D@std@@@std@@2PBVfacet@locale@2@B 003f ?id@?$collate@D@std@@2V0locale@2@A 0044 ??Bid@locale@std@@QAEIXZ 0053 ?_Getfacet@locale@std@@QBEPBVfacet@12@I@Z 0079 ?_Getcat@?$collate@D@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0089 ??0bad_cast@std@@QAE@XZ 008e __TI2?AVbad_cast@std@@ 0097 __CxxThrowException@8 00c1 @_guard_check_icall@4 00d0 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00e8 ??1_Lockit@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 28 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 6A 00 8D 4D DC E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 A1 ?? ?? ?? ?? 89 45 F0 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 E0 8B 4D E0 51 8B 4D 08 E8 ?? ?? ?? ?? 89 45 EC 83 7D EC 00 74 02 EB 75 83 7D F0 00 74 08 8B 55 F0 89 55 EC EB 67 8B 45 08 50 8D 4D F0 51 E8 ?? ?? ?? ?? 83 C4 08 83 F8 FF 75 18 8D 4D CC E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 55 CC 52 E8 ?? ?? ?? ?? EB 3A 8B 45 F0 89 45 EC 8B 4D F0 89 0D ?? ?? ?? ?? 8B 55 F0 89 55 E8 8B 45 E8 8B 08 8B 51 04 89 55 E4 8B 4D E4 E8 ?? ?? ?? ?? 8B 4D E8 FF 55 E4 8B 45 E8 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D EC 89 4D D8 C7 45 FC FF FF FF FF 8D 4D DC E8 ?? ?? ?? ?? 8B 45 D8 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_29_133_1 {
	meta:
		name = "??$use_facet@V?$collate@G@std@@@std@@YAABV?$collate@G@0@ABVlocale@0@@Z"
		size = 254
		refs = "0006 __ehhandler$??$use_facet@V?$collate@G@std@@@std@@YAABV?$collate@G@0@ABVlocale@0@@Z 0015 ___security_cookie 002b ??0_Lockit@std@@QAE@H@Z 0037 ?_Psave@?$_Facetptr@V?$collate@G@std@@@std@@2PBVfacet@locale@2@B 003f ?id@?$collate@G@std@@2V0locale@2@A 0044 ??Bid@locale@std@@QAEIXZ 0053 ?_Getfacet@locale@std@@QBEPBVfacet@12@I@Z 0079 ?_Getcat@?$collate@G@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0089 ??0bad_cast@std@@QAE@XZ 008e __TI2?AVbad_cast@std@@ 0097 __CxxThrowException@8 00c1 @_guard_check_icall@4 00d0 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00e8 ??1_Lockit@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 28 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 6A 00 8D 4D DC E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 A1 ?? ?? ?? ?? 89 45 F0 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 E0 8B 4D E0 51 8B 4D 08 E8 ?? ?? ?? ?? 89 45 EC 83 7D EC 00 74 02 EB 75 83 7D F0 00 74 08 8B 55 F0 89 55 EC EB 67 8B 45 08 50 8D 4D F0 51 E8 ?? ?? ?? ?? 83 C4 08 83 F8 FF 75 18 8D 4D CC E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 55 CC 52 E8 ?? ?? ?? ?? EB 3A 8B 45 F0 89 45 EC 8B 4D F0 89 0D ?? ?? ?? ?? 8B 55 F0 89 55 E8 8B 45 E8 8B 08 8B 51 04 89 55 E4 8B 4D E4 E8 ?? ?? ?? ?? 8B 4D E8 FF 55 E4 8B 45 E8 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D EC 89 4D D8 C7 45 FC FF FF FF FF 8D 4D DC E8 ?? ?? ?? ?? 8B 45 D8 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_44_176_2 {
	meta:
		name = "??$use_facet@V?$collate@_W@std@@@std@@YAABV?$collate@_W@0@ABVlocale@0@@Z"
		size = 254
		refs = "0006 __ehhandler$??$use_facet@V?$collate@_W@std@@@std@@YAABV?$collate@_W@0@ABVlocale@0@@Z 0015 ___security_cookie 002b ??0_Lockit@std@@QAE@H@Z 0037 ?_Psave@?$_Facetptr@V?$collate@_W@std@@@std@@2PBVfacet@locale@2@B 003f ?id@?$collate@_W@std@@2V0locale@2@A 0044 ??Bid@locale@std@@QAEIXZ 0053 ?_Getfacet@locale@std@@QBEPBVfacet@12@I@Z 0079 ?_Getcat@?$collate@_W@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0089 ??0bad_cast@std@@QAE@XZ 008e __TI2?AVbad_cast@std@@ 0097 __CxxThrowException@8 00c1 @_guard_check_icall@4 00d0 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00e8 ??1_Lockit@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 28 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 6A 00 8D 4D DC E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 A1 ?? ?? ?? ?? 89 45 F0 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 E0 8B 4D E0 51 8B 4D 08 E8 ?? ?? ?? ?? 89 45 EC 83 7D EC 00 74 02 EB 75 83 7D F0 00 74 08 8B 55 F0 89 55 EC EB 67 8B 45 08 50 8D 4D F0 51 E8 ?? ?? ?? ?? 83 C4 08 83 F8 FF 75 18 8D 4D CC E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 55 CC 52 E8 ?? ?? ?? ?? EB 3A 8B 45 F0 89 45 EC 8B 4D F0 89 0D ?? ?? ?? ?? 8B 55 F0 89 55 E8 8B 45 E8 8B 08 8B 51 04 89 55 E4 8B 4D E4 E8 ?? ?? ?? ?? 8B 4D E8 FF 55 E4 8B 45 E8 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D EC 89 4D D8 C7 45 FC FF FF FF FF 8D 4D DC E8 ?? ?? ?? ?? 8B 45 D8 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_67_49_3 {
	meta:
		name = "??$use_facet@V?$ctype@D@std@@@std@@YAABV?$ctype@D@0@ABVlocale@0@@Z"
		size = 254
		refs = "0006 __ehhandler$??$use_facet@V?$ctype@D@std@@@std@@YAABV?$ctype@D@0@ABVlocale@0@@Z 0015 ___security_cookie 002b ??0_Lockit@std@@QAE@H@Z 0037 ?_Psave@?$_Facetptr@V?$ctype@D@std@@@std@@2PBVfacet@locale@2@B 003f ?id@?$ctype@D@std@@2V0locale@2@A 0044 ??Bid@locale@std@@QAEIXZ 0053 ?_Getfacet@locale@std@@QBEPBVfacet@12@I@Z 0079 ?_Getcat@?$ctype@D@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0089 ??0bad_cast@std@@QAE@XZ 008e __TI2?AVbad_cast@std@@ 0097 __CxxThrowException@8 00c1 @_guard_check_icall@4 00d0 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00e8 ??1_Lockit@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 28 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 6A 00 8D 4D DC E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 A1 ?? ?? ?? ?? 89 45 F0 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 E0 8B 4D E0 51 8B 4D 08 E8 ?? ?? ?? ?? 89 45 EC 83 7D EC 00 74 02 EB 75 83 7D F0 00 74 08 8B 55 F0 89 55 EC EB 67 8B 45 08 50 8D 4D F0 51 E8 ?? ?? ?? ?? 83 C4 08 83 F8 FF 75 18 8D 4D CC E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 55 CC 52 E8 ?? ?? ?? ?? EB 3A 8B 45 F0 89 45 EC 8B 4D F0 89 0D ?? ?? ?? ?? 8B 55 F0 89 55 E8 8B 45 E8 8B 08 8B 51 04 89 55 E4 8B 4D E4 E8 ?? ?? ?? ?? 8B 4D E8 FF 55 E4 8B 45 E8 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D EC 89 4D D8 C7 45 FC FF FF FF FF 8D 4D DC E8 ?? ?? ?? ?? 8B 45 D8 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_118_62_3 {
	meta:
		name = "??$use_facet@V?$ctype@G@std@@@std@@YAABV?$ctype@G@0@ABVlocale@0@@Z"
		size = 254
		refs = "0006 __ehhandler$??$use_facet@V?$ctype@G@std@@@std@@YAABV?$ctype@G@0@ABVlocale@0@@Z 0015 ___security_cookie 002b ??0_Lockit@std@@QAE@H@Z 0037 ?_Psave@?$_Facetptr@V?$ctype@G@std@@@std@@2PBVfacet@locale@2@B 003f ?id@?$ctype@G@std@@2V0locale@2@A 0044 ??Bid@locale@std@@QAEIXZ 0053 ?_Getfacet@locale@std@@QBEPBVfacet@12@I@Z 0079 ?_Getcat@?$ctype@G@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0089 ??0bad_cast@std@@QAE@XZ 008e __TI2?AVbad_cast@std@@ 0097 __CxxThrowException@8 00c1 @_guard_check_icall@4 00d0 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00e8 ??1_Lockit@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 28 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 6A 00 8D 4D DC E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 A1 ?? ?? ?? ?? 89 45 F0 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 E0 8B 4D E0 51 8B 4D 08 E8 ?? ?? ?? ?? 89 45 EC 83 7D EC 00 74 02 EB 75 83 7D F0 00 74 08 8B 55 F0 89 55 EC EB 67 8B 45 08 50 8D 4D F0 51 E8 ?? ?? ?? ?? 83 C4 08 83 F8 FF 75 18 8D 4D CC E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 55 CC 52 E8 ?? ?? ?? ?? EB 3A 8B 45 F0 89 45 EC 8B 4D F0 89 0D ?? ?? ?? ?? 8B 55 F0 89 55 E8 8B 45 E8 8B 08 8B 51 04 89 55 E4 8B 4D E4 E8 ?? ?? ?? ?? 8B 4D E8 FF 55 E4 8B 45 E8 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D EC 89 4D D8 C7 45 FC FF FF FF FF 8D 4D DC E8 ?? ?? ?? ?? 8B 45 D8 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_3_62_3 {
	meta:
		name = "??$use_facet@V?$ctype@_W@std@@@std@@YAABV?$ctype@_W@0@ABVlocale@0@@Z"
		size = 254
		refs = "0006 __ehhandler$??$use_facet@V?$ctype@_W@std@@@std@@YAABV?$ctype@_W@0@ABVlocale@0@@Z 0015 ___security_cookie 002b ??0_Lockit@std@@QAE@H@Z 0037 ?_Psave@?$_Facetptr@V?$ctype@_W@std@@@std@@2PBVfacet@locale@2@B 003f ?id@?$ctype@_W@std@@2V0locale@2@A 0044 ??Bid@locale@std@@QAEIXZ 0053 ?_Getfacet@locale@std@@QBEPBVfacet@12@I@Z 0079 ?_Getcat@?$ctype@_W@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0089 ??0bad_cast@std@@QAE@XZ 008e __TI2?AVbad_cast@std@@ 0097 __CxxThrowException@8 00c1 @_guard_check_icall@4 00d0 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00e8 ??1_Lockit@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 28 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 6A 00 8D 4D DC E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 A1 ?? ?? ?? ?? 89 45 F0 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 E0 8B 4D E0 51 8B 4D 08 E8 ?? ?? ?? ?? 89 45 EC 83 7D EC 00 74 02 EB 75 83 7D F0 00 74 08 8B 55 F0 89 55 EC EB 67 8B 45 08 50 8D 4D F0 51 E8 ?? ?? ?? ?? 83 C4 08 83 F8 FF 75 18 8D 4D CC E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 55 CC 52 E8 ?? ?? ?? ?? EB 3A 8B 45 F0 89 45 EC 8B 4D F0 89 0D ?? ?? ?? ?? 8B 55 F0 89 55 E8 8B 45 E8 8B 08 8B 51 04 89 55 E4 8B 4D E4 E8 ?? ?? ?? ?? 8B 4D E8 FF 55 E4 8B 45 E8 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D EC 89 4D D8 C7 45 FC FF FF FF FF 8D 4D DC E8 ?? ?? ?? ?? 8B 45 D8 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_80_56_1 {
	meta:
		name = "??$use_facet@V?$messages@D@std@@@std@@YAABV?$messages@D@0@ABVlocale@0@@Z"
		size = 254
		refs = "0006 __ehhandler$??$use_facet@V?$messages@D@std@@@std@@YAABV?$messages@D@0@ABVlocale@0@@Z 0015 ___security_cookie 002b ??0_Lockit@std@@QAE@H@Z 0037 ?_Psave@?$_Facetptr@V?$messages@D@std@@@std@@2PBVfacet@locale@2@B 003f ?id@?$messages@D@std@@2V0locale@2@A 0044 ??Bid@locale@std@@QAEIXZ 0053 ?_Getfacet@locale@std@@QBEPBVfacet@12@I@Z 0079 ?_Getcat@?$messages@D@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0089 ??0bad_cast@std@@QAE@XZ 008e __TI2?AVbad_cast@std@@ 0097 __CxxThrowException@8 00c1 @_guard_check_icall@4 00d0 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00e8 ??1_Lockit@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 28 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 6A 00 8D 4D DC E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 A1 ?? ?? ?? ?? 89 45 F0 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 E0 8B 4D E0 51 8B 4D 08 E8 ?? ?? ?? ?? 89 45 EC 83 7D EC 00 74 02 EB 75 83 7D F0 00 74 08 8B 55 F0 89 55 EC EB 67 8B 45 08 50 8D 4D F0 51 E8 ?? ?? ?? ?? 83 C4 08 83 F8 FF 75 18 8D 4D CC E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 55 CC 52 E8 ?? ?? ?? ?? EB 3A 8B 45 F0 89 45 EC 8B 4D F0 89 0D ?? ?? ?? ?? 8B 55 F0 89 55 E8 8B 45 E8 8B 08 8B 51 04 89 55 E4 8B 4D E4 E8 ?? ?? ?? ?? 8B 4D E8 FF 55 E4 8B 45 E8 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D EC 89 4D D8 C7 45 FC FF FF FF FF 8D 4D DC E8 ?? ?? ?? ?? 8B 45 D8 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_10_231_3 {
	meta:
		name = "??$use_facet@V?$messages@G@std@@@std@@YAABV?$messages@G@0@ABVlocale@0@@Z"
		size = 254
		refs = "0006 __ehhandler$??$use_facet@V?$messages@G@std@@@std@@YAABV?$messages@G@0@ABVlocale@0@@Z 0015 ___security_cookie 002b ??0_Lockit@std@@QAE@H@Z 0037 ?_Psave@?$_Facetptr@V?$messages@G@std@@@std@@2PBVfacet@locale@2@B 003f ?id@?$messages@G@std@@2V0locale@2@A 0044 ??Bid@locale@std@@QAEIXZ 0053 ?_Getfacet@locale@std@@QBEPBVfacet@12@I@Z 0079 ?_Getcat@?$messages@G@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0089 ??0bad_cast@std@@QAE@XZ 008e __TI2?AVbad_cast@std@@ 0097 __CxxThrowException@8 00c1 @_guard_check_icall@4 00d0 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00e8 ??1_Lockit@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 28 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 6A 00 8D 4D DC E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 A1 ?? ?? ?? ?? 89 45 F0 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 E0 8B 4D E0 51 8B 4D 08 E8 ?? ?? ?? ?? 89 45 EC 83 7D EC 00 74 02 EB 75 83 7D F0 00 74 08 8B 55 F0 89 55 EC EB 67 8B 45 08 50 8D 4D F0 51 E8 ?? ?? ?? ?? 83 C4 08 83 F8 FF 75 18 8D 4D CC E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 55 CC 52 E8 ?? ?? ?? ?? EB 3A 8B 45 F0 89 45 EC 8B 4D F0 89 0D ?? ?? ?? ?? 8B 55 F0 89 55 E8 8B 45 E8 8B 08 8B 51 04 89 55 E4 8B 4D E4 E8 ?? ?? ?? ?? 8B 4D E8 FF 55 E4 8B 45 E8 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D EC 89 4D D8 C7 45 FC FF FF FF FF 8D 4D DC E8 ?? ?? ?? ?? 8B 45 D8 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_44_188_2 {
	meta:
		name = "??$use_facet@V?$messages@_W@std@@@std@@YAABV?$messages@_W@0@ABVlocale@0@@Z"
		size = 254
		refs = "0006 __ehhandler$??$use_facet@V?$messages@_W@std@@@std@@YAABV?$messages@_W@0@ABVlocale@0@@Z 0015 ___security_cookie 002b ??0_Lockit@std@@QAE@H@Z 0037 ?_Psave@?$_Facetptr@V?$messages@_W@std@@@std@@2PBVfacet@locale@2@B 003f ?id@?$messages@_W@std@@2V0locale@2@A 0044 ??Bid@locale@std@@QAEIXZ 0053 ?_Getfacet@locale@std@@QBEPBVfacet@12@I@Z 0079 ?_Getcat@?$messages@_W@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0089 ??0bad_cast@std@@QAE@XZ 008e __TI2?AVbad_cast@std@@ 0097 __CxxThrowException@8 00c1 @_guard_check_icall@4 00d0 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00e8 ??1_Lockit@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 28 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 6A 00 8D 4D DC E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 A1 ?? ?? ?? ?? 89 45 F0 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 E0 8B 4D E0 51 8B 4D 08 E8 ?? ?? ?? ?? 89 45 EC 83 7D EC 00 74 02 EB 75 83 7D F0 00 74 08 8B 55 F0 89 55 EC EB 67 8B 45 08 50 8D 4D F0 51 E8 ?? ?? ?? ?? 83 C4 08 83 F8 FF 75 18 8D 4D CC E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 55 CC 52 E8 ?? ?? ?? ?? EB 3A 8B 45 F0 89 45 EC 8B 4D F0 89 0D ?? ?? ?? ?? 8B 55 F0 89 55 E8 8B 45 E8 8B 08 8B 51 04 89 55 E4 8B 4D E4 E8 ?? ?? ?? ?? 8B 4D E8 FF 55 E4 8B 45 E8 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D EC 89 4D D8 C7 45 FC FF FF FF FF 8D 4D DC E8 ?? ?? ?? ?? 8B 45 D8 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_80_59_1 {
	meta:
		name = "??$use_facet@V?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z"
		size = 254
		refs = "0006 __ehhandler$??$use_facet@V?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z 0015 ___security_cookie 002b ??0_Lockit@std@@QAE@H@Z 0037 ?_Psave@?$_Facetptr@V?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@2PBVfacet@locale@2@B 003f ?id@?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@2V0locale@2@A 0044 ??Bid@locale@std@@QAEIXZ 0053 ?_Getfacet@locale@std@@QBEPBVfacet@12@I@Z 0079 ?_Getcat@?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0089 ??0bad_cast@std@@QAE@XZ 008e __TI2?AVbad_cast@std@@ 0097 __CxxThrowException@8 00c1 @_guard_check_icall@4 00d0 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00e8 ??1_Lockit@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 28 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 6A 00 8D 4D DC E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 A1 ?? ?? ?? ?? 89 45 F0 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 E0 8B 4D E0 51 8B 4D 08 E8 ?? ?? ?? ?? 89 45 EC 83 7D EC 00 74 02 EB 75 83 7D F0 00 74 08 8B 55 F0 89 55 EC EB 67 8B 45 08 50 8D 4D F0 51 E8 ?? ?? ?? ?? 83 C4 08 83 F8 FF 75 18 8D 4D CC E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 55 CC 52 E8 ?? ?? ?? ?? EB 3A 8B 45 F0 89 45 EC 8B 4D F0 89 0D ?? ?? ?? ?? 8B 55 F0 89 55 E8 8B 45 E8 8B 08 8B 51 04 89 55 E4 8B 4D E4 E8 ?? ?? ?? ?? 8B 4D E8 FF 55 E4 8B 45 E8 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D EC 89 4D D8 C7 45 FC FF FF FF FF 8D 4D DC E8 ?? ?? ?? ?? 8B 45 D8 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_29_151_1 {
	meta:
		name = "??$use_facet@V?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z"
		size = 254
		refs = "0006 __ehhandler$??$use_facet@V?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z 0015 ___security_cookie 002b ??0_Lockit@std@@QAE@H@Z 0037 ?_Psave@?$_Facetptr@V?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@2PBVfacet@locale@2@B 003f ?id@?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@2V0locale@2@A 0044 ??Bid@locale@std@@QAEIXZ 0053 ?_Getfacet@locale@std@@QBEPBVfacet@12@I@Z 0079 ?_Getcat@?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0089 ??0bad_cast@std@@QAE@XZ 008e __TI2?AVbad_cast@std@@ 0097 __CxxThrowException@8 00c1 @_guard_check_icall@4 00d0 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00e8 ??1_Lockit@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 28 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 6A 00 8D 4D DC E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 A1 ?? ?? ?? ?? 89 45 F0 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 E0 8B 4D E0 51 8B 4D 08 E8 ?? ?? ?? ?? 89 45 EC 83 7D EC 00 74 02 EB 75 83 7D F0 00 74 08 8B 55 F0 89 55 EC EB 67 8B 45 08 50 8D 4D F0 51 E8 ?? ?? ?? ?? 83 C4 08 83 F8 FF 75 18 8D 4D CC E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 55 CC 52 E8 ?? ?? ?? ?? EB 3A 8B 45 F0 89 45 EC 8B 4D F0 89 0D ?? ?? ?? ?? 8B 55 F0 89 55 E8 8B 45 E8 8B 08 8B 51 04 89 55 E4 8B 4D E4 E8 ?? ?? ?? ?? 8B 4D E8 FF 55 E4 8B 45 E8 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D EC 89 4D D8 C7 45 FC FF FF FF FF 8D 4D DC E8 ?? ?? ?? ?? 8B 45 D8 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_29_154_1 {
	meta:
		name = "??$use_facet@V?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z"
		size = 254
		refs = "0006 __ehhandler$??$use_facet@V?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z 0015 ___security_cookie 002b ??0_Lockit@std@@QAE@H@Z 0037 ?_Psave@?$_Facetptr@V?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@2PBVfacet@locale@2@B 003f ?id@?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@2V0locale@2@A 0044 ??Bid@locale@std@@QAEIXZ 0053 ?_Getfacet@locale@std@@QBEPBVfacet@12@I@Z 0079 ?_Getcat@?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0089 ??0bad_cast@std@@QAE@XZ 008e __TI2?AVbad_cast@std@@ 0097 __CxxThrowException@8 00c1 @_guard_check_icall@4 00d0 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00e8 ??1_Lockit@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 28 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 6A 00 8D 4D DC E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 A1 ?? ?? ?? ?? 89 45 F0 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 E0 8B 4D E0 51 8B 4D 08 E8 ?? ?? ?? ?? 89 45 EC 83 7D EC 00 74 02 EB 75 83 7D F0 00 74 08 8B 55 F0 89 55 EC EB 67 8B 45 08 50 8D 4D F0 51 E8 ?? ?? ?? ?? 83 C4 08 83 F8 FF 75 18 8D 4D CC E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 55 CC 52 E8 ?? ?? ?? ?? EB 3A 8B 45 F0 89 45 EC 8B 4D F0 89 0D ?? ?? ?? ?? 8B 55 F0 89 55 E8 8B 45 E8 8B 08 8B 51 04 89 55 E4 8B 4D E4 E8 ?? ?? ?? ?? 8B 4D E8 FF 55 E4 8B 45 E8 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D EC 89 4D D8 C7 45 FC FF FF FF FF 8D 4D DC E8 ?? ?? ?? ?? 8B 45 D8 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_90_84_2 {
	meta:
		name = "??$use_facet@V?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z"
		size = 254
		refs = "0006 __ehhandler$??$use_facet@V?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z 0015 ___security_cookie 002b ??0_Lockit@std@@QAE@H@Z 0037 ?_Psave@?$_Facetptr@V?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@2PBVfacet@locale@2@B 003f ?id@?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@2V0locale@2@A 0044 ??Bid@locale@std@@QAEIXZ 0053 ?_Getfacet@locale@std@@QBEPBVfacet@12@I@Z 0079 ?_Getcat@?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0089 ??0bad_cast@std@@QAE@XZ 008e __TI2?AVbad_cast@std@@ 0097 __CxxThrowException@8 00c1 @_guard_check_icall@4 00d0 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00e8 ??1_Lockit@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 28 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 6A 00 8D 4D DC E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 A1 ?? ?? ?? ?? 89 45 F0 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 E0 8B 4D E0 51 8B 4D 08 E8 ?? ?? ?? ?? 89 45 EC 83 7D EC 00 74 02 EB 75 83 7D F0 00 74 08 8B 55 F0 89 55 EC EB 67 8B 45 08 50 8D 4D F0 51 E8 ?? ?? ?? ?? 83 C4 08 83 F8 FF 75 18 8D 4D CC E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 55 CC 52 E8 ?? ?? ?? ?? EB 3A 8B 45 F0 89 45 EC 8B 4D F0 89 0D ?? ?? ?? ?? 8B 55 F0 89 55 E8 8B 45 E8 8B 08 8B 51 04 89 55 E4 8B 4D E4 E8 ?? ?? ?? ?? 8B 4D E8 FF 55 E4 8B 45 E8 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D EC 89 4D D8 C7 45 FC FF FF FF FF 8D 4D DC E8 ?? ?? ?? ?? 8B 45 D8 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_10_243_3 {
	meta:
		name = "??$use_facet@V?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z"
		size = 254
		refs = "0006 __ehhandler$??$use_facet@V?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z 0015 ___security_cookie 002b ??0_Lockit@std@@QAE@H@Z 0037 ?_Psave@?$_Facetptr@V?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@2PBVfacet@locale@2@B 003f ?id@?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@2V0locale@2@A 0044 ??Bid@locale@std@@QAEIXZ 0053 ?_Getfacet@locale@std@@QBEPBVfacet@12@I@Z 0079 ?_Getcat@?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0089 ??0bad_cast@std@@QAE@XZ 008e __TI2?AVbad_cast@std@@ 0097 __CxxThrowException@8 00c1 @_guard_check_icall@4 00d0 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00e8 ??1_Lockit@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 28 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 6A 00 8D 4D DC E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 A1 ?? ?? ?? ?? 89 45 F0 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 E0 8B 4D E0 51 8B 4D 08 E8 ?? ?? ?? ?? 89 45 EC 83 7D EC 00 74 02 EB 75 83 7D F0 00 74 08 8B 55 F0 89 55 EC EB 67 8B 45 08 50 8D 4D F0 51 E8 ?? ?? ?? ?? 83 C4 08 83 F8 FF 75 18 8D 4D CC E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 55 CC 52 E8 ?? ?? ?? ?? EB 3A 8B 45 F0 89 45 EC 8B 4D F0 89 0D ?? ?? ?? ?? 8B 55 F0 89 55 E8 8B 45 E8 8B 08 8B 51 04 89 55 E4 8B 4D E4 E8 ?? ?? ?? ?? 8B 4D E8 FF 55 E4 8B 45 E8 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D EC 89 4D D8 C7 45 FC FF FF FF FF 8D 4D DC E8 ?? ?? ?? ?? 8B 45 D8 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_10_246_3 {
	meta:
		name = "??$use_facet@V?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z"
		size = 254
		refs = "0006 __ehhandler$??$use_facet@V?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z 0015 ___security_cookie 002b ??0_Lockit@std@@QAE@H@Z 0037 ?_Psave@?$_Facetptr@V?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@2PBVfacet@locale@2@B 003f ?id@?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@2V0locale@2@A 0044 ??Bid@locale@std@@QAEIXZ 0053 ?_Getfacet@locale@std@@QBEPBVfacet@12@I@Z 0079 ?_Getcat@?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0089 ??0bad_cast@std@@QAE@XZ 008e __TI2?AVbad_cast@std@@ 0097 __CxxThrowException@8 00c1 @_guard_check_icall@4 00d0 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00e8 ??1_Lockit@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 28 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 6A 00 8D 4D DC E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 A1 ?? ?? ?? ?? 89 45 F0 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 E0 8B 4D E0 51 8B 4D 08 E8 ?? ?? ?? ?? 89 45 EC 83 7D EC 00 74 02 EB 75 83 7D F0 00 74 08 8B 55 F0 89 55 EC EB 67 8B 45 08 50 8D 4D F0 51 E8 ?? ?? ?? ?? 83 C4 08 83 F8 FF 75 18 8D 4D CC E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 55 CC 52 E8 ?? ?? ?? ?? EB 3A 8B 45 F0 89 45 EC 8B 4D F0 89 0D ?? ?? ?? ?? 8B 55 F0 89 55 E8 8B 45 E8 8B 08 8B 51 04 89 55 E4 8B 4D E4 E8 ?? ?? ?? ?? 8B 4D E8 FF 55 E4 8B 45 E8 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D EC 89 4D D8 C7 45 FC FF FF FF FF 8D 4D DC E8 ?? ?? ?? ?? 8B 45 D8 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_90_87_2 {
	meta:
		name = "??$use_facet@V?$moneypunct@D$00@std@@@std@@YAABV?$moneypunct@D$00@0@ABVlocale@0@@Z"
		size = 254
		refs = "0006 __ehhandler$??$use_facet@V?$moneypunct@D$00@std@@@std@@YAABV?$moneypunct@D$00@0@ABVlocale@0@@Z 0015 ___security_cookie 002b ??0_Lockit@std@@QAE@H@Z 0037 ?_Psave@?$_Facetptr@V?$moneypunct@D$00@std@@@std@@2PBVfacet@locale@2@B 003f ?id@?$moneypunct@D$00@std@@2V0locale@2@A 0044 ??Bid@locale@std@@QAEIXZ 0053 ?_Getfacet@locale@std@@QBEPBVfacet@12@I@Z 0079 ?_Getcat@?$moneypunct@D$00@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0089 ??0bad_cast@std@@QAE@XZ 008e __TI2?AVbad_cast@std@@ 0097 __CxxThrowException@8 00c1 @_guard_check_icall@4 00d0 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00e8 ??1_Lockit@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 28 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 6A 00 8D 4D DC E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 A1 ?? ?? ?? ?? 89 45 F0 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 E0 8B 4D E0 51 8B 4D 08 E8 ?? ?? ?? ?? 89 45 EC 83 7D EC 00 74 02 EB 75 83 7D F0 00 74 08 8B 55 F0 89 55 EC EB 67 8B 45 08 50 8D 4D F0 51 E8 ?? ?? ?? ?? 83 C4 08 83 F8 FF 75 18 8D 4D CC E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 55 CC 52 E8 ?? ?? ?? ?? EB 3A 8B 45 F0 89 45 EC 8B 4D F0 89 0D ?? ?? ?? ?? 8B 55 F0 89 55 E8 8B 45 E8 8B 08 8B 51 04 89 55 E4 8B 4D E4 E8 ?? ?? ?? ?? 8B 4D E8 FF 55 E4 8B 45 E8 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D EC 89 4D D8 C7 45 FC FF FF FF FF 8D 4D DC E8 ?? ?? ?? ?? 8B 45 D8 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_80_68_1 {
	meta:
		name = "??$use_facet@V?$moneypunct@D$0A@@std@@@std@@YAABV?$moneypunct@D$0A@@0@ABVlocale@0@@Z"
		size = 254
		refs = "0006 __ehhandler$??$use_facet@V?$moneypunct@D$0A@@std@@@std@@YAABV?$moneypunct@D$0A@@0@ABVlocale@0@@Z 0015 ___security_cookie 002b ??0_Lockit@std@@QAE@H@Z 0037 ?_Psave@?$_Facetptr@V?$moneypunct@D$0A@@std@@@std@@2PBVfacet@locale@2@B 003f ?id@?$moneypunct@D$0A@@std@@2V0locale@2@A 0044 ??Bid@locale@std@@QAEIXZ 0053 ?_Getfacet@locale@std@@QBEPBVfacet@12@I@Z 0079 ?_Getcat@?$moneypunct@D$0A@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0089 ??0bad_cast@std@@QAE@XZ 008e __TI2?AVbad_cast@std@@ 0097 __CxxThrowException@8 00c1 @_guard_check_icall@4 00d0 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00e8 ??1_Lockit@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 28 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 6A 00 8D 4D DC E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 A1 ?? ?? ?? ?? 89 45 F0 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 E0 8B 4D E0 51 8B 4D 08 E8 ?? ?? ?? ?? 89 45 EC 83 7D EC 00 74 02 EB 75 83 7D F0 00 74 08 8B 55 F0 89 55 EC EB 67 8B 45 08 50 8D 4D F0 51 E8 ?? ?? ?? ?? 83 C4 08 83 F8 FF 75 18 8D 4D CC E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 55 CC 52 E8 ?? ?? ?? ?? EB 3A 8B 45 F0 89 45 EC 8B 4D F0 89 0D ?? ?? ?? ?? 8B 55 F0 89 55 E8 8B 45 E8 8B 08 8B 51 04 89 55 E4 8B 4D E4 E8 ?? ?? ?? ?? 8B 4D E8 FF 55 E4 8B 45 E8 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D EC 89 4D D8 C7 45 FC FF FF FF FF 8D 4D DC E8 ?? ?? ?? ?? 8B 45 D8 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_29_163_1 {
	meta:
		name = "??$use_facet@V?$moneypunct@G$00@std@@@std@@YAABV?$moneypunct@G$00@0@ABVlocale@0@@Z"
		size = 254
		refs = "0006 __ehhandler$??$use_facet@V?$moneypunct@G$00@std@@@std@@YAABV?$moneypunct@G$00@0@ABVlocale@0@@Z 0015 ___security_cookie 002b ??0_Lockit@std@@QAE@H@Z 0037 ?_Psave@?$_Facetptr@V?$moneypunct@G$00@std@@@std@@2PBVfacet@locale@2@B 003f ?id@?$moneypunct@G$00@std@@2V0locale@2@A 0044 ??Bid@locale@std@@QAEIXZ 0053 ?_Getfacet@locale@std@@QBEPBVfacet@12@I@Z 0079 ?_Getcat@?$moneypunct@G$00@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0089 ??0bad_cast@std@@QAE@XZ 008e __TI2?AVbad_cast@std@@ 0097 __CxxThrowException@8 00c1 @_guard_check_icall@4 00d0 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00e8 ??1_Lockit@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 28 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 6A 00 8D 4D DC E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 A1 ?? ?? ?? ?? 89 45 F0 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 E0 8B 4D E0 51 8B 4D 08 E8 ?? ?? ?? ?? 89 45 EC 83 7D EC 00 74 02 EB 75 83 7D F0 00 74 08 8B 55 F0 89 55 EC EB 67 8B 45 08 50 8D 4D F0 51 E8 ?? ?? ?? ?? 83 C4 08 83 F8 FF 75 18 8D 4D CC E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 55 CC 52 E8 ?? ?? ?? ?? EB 3A 8B 45 F0 89 45 EC 8B 4D F0 89 0D ?? ?? ?? ?? 8B 55 F0 89 55 E8 8B 45 E8 8B 08 8B 51 04 89 55 E4 8B 4D E4 E8 ?? ?? ?? ?? 8B 4D E8 FF 55 E4 8B 45 E8 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D EC 89 4D D8 C7 45 FC FF FF FF FF 8D 4D DC E8 ?? ?? ?? ?? 8B 45 D8 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_10_252_3 {
	meta:
		name = "??$use_facet@V?$moneypunct@G$0A@@std@@@std@@YAABV?$moneypunct@G$0A@@0@ABVlocale@0@@Z"
		size = 254
		refs = "0006 __ehhandler$??$use_facet@V?$moneypunct@G$0A@@std@@@std@@YAABV?$moneypunct@G$0A@@0@ABVlocale@0@@Z 0015 ___security_cookie 002b ??0_Lockit@std@@QAE@H@Z 0037 ?_Psave@?$_Facetptr@V?$moneypunct@G$0A@@std@@@std@@2PBVfacet@locale@2@B 003f ?id@?$moneypunct@G$0A@@std@@2V0locale@2@A 0044 ??Bid@locale@std@@QAEIXZ 0053 ?_Getfacet@locale@std@@QBEPBVfacet@12@I@Z 0079 ?_Getcat@?$moneypunct@G$0A@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0089 ??0bad_cast@std@@QAE@XZ 008e __TI2?AVbad_cast@std@@ 0097 __CxxThrowException@8 00c1 @_guard_check_icall@4 00d0 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00e8 ??1_Lockit@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 28 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 6A 00 8D 4D DC E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 A1 ?? ?? ?? ?? 89 45 F0 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 E0 8B 4D E0 51 8B 4D 08 E8 ?? ?? ?? ?? 89 45 EC 83 7D EC 00 74 02 EB 75 83 7D F0 00 74 08 8B 55 F0 89 55 EC EB 67 8B 45 08 50 8D 4D F0 51 E8 ?? ?? ?? ?? 83 C4 08 83 F8 FF 75 18 8D 4D CC E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 55 CC 52 E8 ?? ?? ?? ?? EB 3A 8B 45 F0 89 45 EC 8B 4D F0 89 0D ?? ?? ?? ?? 8B 55 F0 89 55 E8 8B 45 E8 8B 08 8B 51 04 89 55 E4 8B 4D E4 E8 ?? ?? ?? ?? 8B 4D E8 FF 55 E4 8B 45 E8 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D EC 89 4D D8 C7 45 FC FF FF FF FF 8D 4D DC E8 ?? ?? ?? ?? 8B 45 D8 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_44_209_2 {
	meta:
		name = "??$use_facet@V?$moneypunct@_W$00@std@@@std@@YAABV?$moneypunct@_W$00@0@ABVlocale@0@@Z"
		size = 254
		refs = "0006 __ehhandler$??$use_facet@V?$moneypunct@_W$00@std@@@std@@YAABV?$moneypunct@_W$00@0@ABVlocale@0@@Z 0015 ___security_cookie 002b ??0_Lockit@std@@QAE@H@Z 0037 ?_Psave@?$_Facetptr@V?$moneypunct@_W$00@std@@@std@@2PBVfacet@locale@2@B 003f ?id@?$moneypunct@_W$00@std@@2V0locale@2@A 0044 ??Bid@locale@std@@QAEIXZ 0053 ?_Getfacet@locale@std@@QBEPBVfacet@12@I@Z 0079 ?_Getcat@?$moneypunct@_W$00@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0089 ??0bad_cast@std@@QAE@XZ 008e __TI2?AVbad_cast@std@@ 0097 __CxxThrowException@8 00c1 @_guard_check_icall@4 00d0 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00e8 ??1_Lockit@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 28 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 6A 00 8D 4D DC E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 A1 ?? ?? ?? ?? 89 45 F0 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 E0 8B 4D E0 51 8B 4D 08 E8 ?? ?? ?? ?? 89 45 EC 83 7D EC 00 74 02 EB 75 83 7D F0 00 74 08 8B 55 F0 89 55 EC EB 67 8B 45 08 50 8D 4D F0 51 E8 ?? ?? ?? ?? 83 C4 08 83 F8 FF 75 18 8D 4D CC E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 55 CC 52 E8 ?? ?? ?? ?? EB 3A 8B 45 F0 89 45 EC 8B 4D F0 89 0D ?? ?? ?? ?? 8B 55 F0 89 55 E8 8B 45 E8 8B 08 8B 51 04 89 55 E4 8B 4D E4 E8 ?? ?? ?? ?? 8B 4D E8 FF 55 E4 8B 45 E8 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D EC 89 4D D8 C7 45 FC FF FF FF FF 8D 4D DC E8 ?? ?? ?? ?? 8B 45 D8 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_10_258_3 {
	meta:
		name = "??$use_facet@V?$moneypunct@_W$0A@@std@@@std@@YAABV?$moneypunct@_W$0A@@0@ABVlocale@0@@Z"
		size = 254
		refs = "0006 __ehhandler$??$use_facet@V?$moneypunct@_W$0A@@std@@@std@@YAABV?$moneypunct@_W$0A@@0@ABVlocale@0@@Z 0015 ___security_cookie 002b ??0_Lockit@std@@QAE@H@Z 0037 ?_Psave@?$_Facetptr@V?$moneypunct@_W$0A@@std@@@std@@2PBVfacet@locale@2@B 003f ?id@?$moneypunct@_W$0A@@std@@2V0locale@2@A 0044 ??Bid@locale@std@@QAEIXZ 0053 ?_Getfacet@locale@std@@QBEPBVfacet@12@I@Z 0079 ?_Getcat@?$moneypunct@_W$0A@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0089 ??0bad_cast@std@@QAE@XZ 008e __TI2?AVbad_cast@std@@ 0097 __CxxThrowException@8 00c1 @_guard_check_icall@4 00d0 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00e8 ??1_Lockit@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 28 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 6A 00 8D 4D DC E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 A1 ?? ?? ?? ?? 89 45 F0 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 E0 8B 4D E0 51 8B 4D 08 E8 ?? ?? ?? ?? 89 45 EC 83 7D EC 00 74 02 EB 75 83 7D F0 00 74 08 8B 55 F0 89 55 EC EB 67 8B 45 08 50 8D 4D F0 51 E8 ?? ?? ?? ?? 83 C4 08 83 F8 FF 75 18 8D 4D CC E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 55 CC 52 E8 ?? ?? ?? ?? EB 3A 8B 45 F0 89 45 EC 8B 4D F0 89 0D ?? ?? ?? ?? 8B 55 F0 89 55 E8 8B 45 E8 8B 08 8B 51 04 89 55 E4 8B 4D E4 E8 ?? ?? ?? ?? 8B 4D E8 FF 55 E4 8B 45 E8 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D EC 89 4D D8 C7 45 FC FF FF FF FF 8D 4D DC E8 ?? ?? ?? ?? 8B 45 D8 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_3_33_1 {
	meta:
		name = "??$use_facet@V?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z"
		size = 254
		refs = "0006 __ehhandler$??$use_facet@V?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z 0015 ___security_cookie 002b ??0_Lockit@std@@QAE@H@Z 0037 ?_Psave@?$_Facetptr@V?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@2PBVfacet@locale@2@B 003f ?id@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@2V0locale@2@A 0044 ??Bid@locale@std@@QAEIXZ 0053 ?_Getfacet@locale@std@@QBEPBVfacet@12@I@Z 0079 ?_Getcat@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0089 ??0bad_cast@std@@QAE@XZ 008e __TI2?AVbad_cast@std@@ 0097 __CxxThrowException@8 00c1 @_guard_check_icall@4 00d0 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00e8 ??1_Lockit@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 28 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 6A 00 8D 4D DC E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 A1 ?? ?? ?? ?? 89 45 F0 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 E0 8B 4D E0 51 8B 4D 08 E8 ?? ?? ?? ?? 89 45 EC 83 7D EC 00 74 02 EB 75 83 7D F0 00 74 08 8B 55 F0 89 55 EC EB 67 8B 45 08 50 8D 4D F0 51 E8 ?? ?? ?? ?? 83 C4 08 83 F8 FF 75 18 8D 4D CC E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 55 CC 52 E8 ?? ?? ?? ?? EB 3A 8B 45 F0 89 45 EC 8B 4D F0 89 0D ?? ?? ?? ?? 8B 55 F0 89 55 E8 8B 45 E8 8B 08 8B 51 04 89 55 E4 8B 4D E4 E8 ?? ?? ?? ?? 8B 4D E8 FF 55 E4 8B 45 E8 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D EC 89 4D D8 C7 45 FC FF FF FF FF 8D 4D DC E8 ?? ?? ?? ?? 8B 45 D8 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_10_261_3 {
	meta:
		name = "??$use_facet@V?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z"
		size = 254
		refs = "0006 __ehhandler$??$use_facet@V?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z 0015 ___security_cookie 002b ??0_Lockit@std@@QAE@H@Z 0037 ?_Psave@?$_Facetptr@V?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@2PBVfacet@locale@2@B 003f ?id@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@2V0locale@2@A 0044 ??Bid@locale@std@@QAEIXZ 0053 ?_Getfacet@locale@std@@QBEPBVfacet@12@I@Z 0079 ?_Getcat@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0089 ??0bad_cast@std@@QAE@XZ 008e __TI2?AVbad_cast@std@@ 0097 __CxxThrowException@8 00c1 @_guard_check_icall@4 00d0 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00e8 ??1_Lockit@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 28 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 6A 00 8D 4D DC E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 A1 ?? ?? ?? ?? 89 45 F0 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 E0 8B 4D E0 51 8B 4D 08 E8 ?? ?? ?? ?? 89 45 EC 83 7D EC 00 74 02 EB 75 83 7D F0 00 74 08 8B 55 F0 89 55 EC EB 67 8B 45 08 50 8D 4D F0 51 E8 ?? ?? ?? ?? 83 C4 08 83 F8 FF 75 18 8D 4D CC E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 55 CC 52 E8 ?? ?? ?? ?? EB 3A 8B 45 F0 89 45 EC 8B 4D F0 89 0D ?? ?? ?? ?? 8B 55 F0 89 55 E8 8B 45 E8 8B 08 8B 51 04 89 55 E4 8B 4D E4 E8 ?? ?? ?? ?? 8B 4D E8 FF 55 E4 8B 45 E8 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D EC 89 4D D8 C7 45 FC FF FF FF FF 8D 4D DC E8 ?? ?? ?? ?? 8B 45 D8 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_10_264_3 {
	meta:
		name = "??$use_facet@V?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z"
		size = 254
		refs = "0006 __ehhandler$??$use_facet@V?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z 0015 ___security_cookie 002b ??0_Lockit@std@@QAE@H@Z 0037 ?_Psave@?$_Facetptr@V?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@2PBVfacet@locale@2@B 003f ?id@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@2V0locale@2@A 0044 ??Bid@locale@std@@QAEIXZ 0053 ?_Getfacet@locale@std@@QBEPBVfacet@12@I@Z 0079 ?_Getcat@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0089 ??0bad_cast@std@@QAE@XZ 008e __TI2?AVbad_cast@std@@ 0097 __CxxThrowException@8 00c1 @_guard_check_icall@4 00d0 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00e8 ??1_Lockit@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 28 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 6A 00 8D 4D DC E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 A1 ?? ?? ?? ?? 89 45 F0 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 E0 8B 4D E0 51 8B 4D 08 E8 ?? ?? ?? ?? 89 45 EC 83 7D EC 00 74 02 EB 75 83 7D F0 00 74 08 8B 55 F0 89 55 EC EB 67 8B 45 08 50 8D 4D F0 51 E8 ?? ?? ?? ?? 83 C4 08 83 F8 FF 75 18 8D 4D CC E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 55 CC 52 E8 ?? ?? ?? ?? EB 3A 8B 45 F0 89 45 EC 8B 4D F0 89 0D ?? ?? ?? ?? 8B 55 F0 89 55 E8 8B 45 E8 8B 08 8B 51 04 89 55 E4 8B 4D E4 E8 ?? ?? ?? ?? 8B 4D E8 FF 55 E4 8B 45 E8 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D EC 89 4D D8 C7 45 FC FF FF FF FF 8D 4D DC E8 ?? ?? ?? ?? 8B 45 D8 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_110_48_2 {
	meta:
		name = "??$use_facet@V?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z"
		size = 254
		refs = "0006 __ehhandler$??$use_facet@V?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z 0015 ___security_cookie 002b ??0_Lockit@std@@QAE@H@Z 0037 ?_Psave@?$_Facetptr@V?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@2PBVfacet@locale@2@B 003f ?id@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@2V0locale@2@A 0044 ??Bid@locale@std@@QAEIXZ 0053 ?_Getfacet@locale@std@@QBEPBVfacet@12@I@Z 0079 ?_Getcat@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0089 ??0bad_cast@std@@QAE@XZ 008e __TI2?AVbad_cast@std@@ 0097 __CxxThrowException@8 00c1 @_guard_check_icall@4 00d0 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00e8 ??1_Lockit@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 28 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 6A 00 8D 4D DC E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 A1 ?? ?? ?? ?? 89 45 F0 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 E0 8B 4D E0 51 8B 4D 08 E8 ?? ?? ?? ?? 89 45 EC 83 7D EC 00 74 02 EB 75 83 7D F0 00 74 08 8B 55 F0 89 55 EC EB 67 8B 45 08 50 8D 4D F0 51 E8 ?? ?? ?? ?? 83 C4 08 83 F8 FF 75 18 8D 4D CC E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 55 CC 52 E8 ?? ?? ?? ?? EB 3A 8B 45 F0 89 45 EC 8B 4D F0 89 0D ?? ?? ?? ?? 8B 55 F0 89 55 E8 8B 45 E8 8B 08 8B 51 04 89 55 E4 8B 4D E4 E8 ?? ?? ?? ?? 8B 4D E8 FF 55 E4 8B 45 E8 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D EC 89 4D D8 C7 45 FC FF FF FF FF 8D 4D DC E8 ?? ?? ?? ?? 8B 45 D8 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_10_267_3 {
	meta:
		name = "??$use_facet@V?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z"
		size = 254
		refs = "0006 __ehhandler$??$use_facet@V?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z 0015 ___security_cookie 002b ??0_Lockit@std@@QAE@H@Z 0037 ?_Psave@?$_Facetptr@V?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@2PBVfacet@locale@2@B 003f ?id@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@2V0locale@2@A 0044 ??Bid@locale@std@@QAEIXZ 0053 ?_Getfacet@locale@std@@QBEPBVfacet@12@I@Z 0079 ?_Getcat@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0089 ??0bad_cast@std@@QAE@XZ 008e __TI2?AVbad_cast@std@@ 0097 __CxxThrowException@8 00c1 @_guard_check_icall@4 00d0 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00e8 ??1_Lockit@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 28 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 6A 00 8D 4D DC E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 A1 ?? ?? ?? ?? 89 45 F0 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 E0 8B 4D E0 51 8B 4D 08 E8 ?? ?? ?? ?? 89 45 EC 83 7D EC 00 74 02 EB 75 83 7D F0 00 74 08 8B 55 F0 89 55 EC EB 67 8B 45 08 50 8D 4D F0 51 E8 ?? ?? ?? ?? 83 C4 08 83 F8 FF 75 18 8D 4D CC E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 55 CC 52 E8 ?? ?? ?? ?? EB 3A 8B 45 F0 89 45 EC 8B 4D F0 89 0D ?? ?? ?? ?? 8B 55 F0 89 55 E8 8B 45 E8 8B 08 8B 51 04 89 55 E4 8B 4D E4 E8 ?? ?? ?? ?? 8B 4D E8 FF 55 E4 8B 45 E8 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D EC 89 4D D8 C7 45 FC FF FF FF FF 8D 4D DC E8 ?? ?? ?? ?? 8B 45 D8 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_10_270_3 {
	meta:
		name = "??$use_facet@V?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z"
		size = 254
		refs = "0006 __ehhandler$??$use_facet@V?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z 0015 ___security_cookie 002b ??0_Lockit@std@@QAE@H@Z 0037 ?_Psave@?$_Facetptr@V?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@2PBVfacet@locale@2@B 003f ?id@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@2V0locale@2@A 0044 ??Bid@locale@std@@QAEIXZ 0053 ?_Getfacet@locale@std@@QBEPBVfacet@12@I@Z 0079 ?_Getcat@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0089 ??0bad_cast@std@@QAE@XZ 008e __TI2?AVbad_cast@std@@ 0097 __CxxThrowException@8 00c1 @_guard_check_icall@4 00d0 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00e8 ??1_Lockit@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 28 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 6A 00 8D 4D DC E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 A1 ?? ?? ?? ?? 89 45 F0 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 E0 8B 4D E0 51 8B 4D 08 E8 ?? ?? ?? ?? 89 45 EC 83 7D EC 00 74 02 EB 75 83 7D F0 00 74 08 8B 55 F0 89 55 EC EB 67 8B 45 08 50 8D 4D F0 51 E8 ?? ?? ?? ?? 83 C4 08 83 F8 FF 75 18 8D 4D CC E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 55 CC 52 E8 ?? ?? ?? ?? EB 3A 8B 45 F0 89 45 EC 8B 4D F0 89 0D ?? ?? ?? ?? 8B 55 F0 89 55 E8 8B 45 E8 8B 08 8B 51 04 89 55 E4 8B 4D E4 E8 ?? ?? ?? ?? 8B 4D E8 FF 55 E4 8B 45 E8 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D EC 89 4D D8 C7 45 FC FF FF FF FF 8D 4D DC E8 ?? ?? ?? ?? 8B 45 D8 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_110_51_2 {
	meta:
		name = "??$use_facet@V?$numpunct@D@std@@@std@@YAABV?$numpunct@D@0@ABVlocale@0@@Z"
		size = 254
		refs = "0006 __ehhandler$??$use_facet@V?$numpunct@D@std@@@std@@YAABV?$numpunct@D@0@ABVlocale@0@@Z 0015 ___security_cookie 002b ??0_Lockit@std@@QAE@H@Z 0037 ?_Psave@?$_Facetptr@V?$numpunct@D@std@@@std@@2PBVfacet@locale@2@B 003f ?id@?$numpunct@D@std@@2V0locale@2@A 0044 ??Bid@locale@std@@QAEIXZ 0053 ?_Getfacet@locale@std@@QBEPBVfacet@12@I@Z 0079 ?_Getcat@?$numpunct@D@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0089 ??0bad_cast@std@@QAE@XZ 008e __TI2?AVbad_cast@std@@ 0097 __CxxThrowException@8 00c1 @_guard_check_icall@4 00d0 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00e8 ??1_Lockit@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 28 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 6A 00 8D 4D DC E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 A1 ?? ?? ?? ?? 89 45 F0 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 E0 8B 4D E0 51 8B 4D 08 E8 ?? ?? ?? ?? 89 45 EC 83 7D EC 00 74 02 EB 75 83 7D F0 00 74 08 8B 55 F0 89 55 EC EB 67 8B 45 08 50 8D 4D F0 51 E8 ?? ?? ?? ?? 83 C4 08 83 F8 FF 75 18 8D 4D CC E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 55 CC 52 E8 ?? ?? ?? ?? EB 3A 8B 45 F0 89 45 EC 8B 4D F0 89 0D ?? ?? ?? ?? 8B 55 F0 89 55 E8 8B 45 E8 8B 08 8B 51 04 89 55 E4 8B 4D E4 E8 ?? ?? ?? ?? 8B 4D E8 FF 55 E4 8B 45 E8 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D EC 89 4D D8 C7 45 FC FF FF FF FF 8D 4D DC E8 ?? ?? ?? ?? 8B 45 D8 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_10_273_3 {
	meta:
		name = "??$use_facet@V?$numpunct@G@std@@@std@@YAABV?$numpunct@G@0@ABVlocale@0@@Z"
		size = 254
		refs = "0006 __ehhandler$??$use_facet@V?$numpunct@G@std@@@std@@YAABV?$numpunct@G@0@ABVlocale@0@@Z 0015 ___security_cookie 002b ??0_Lockit@std@@QAE@H@Z 0037 ?_Psave@?$_Facetptr@V?$numpunct@G@std@@@std@@2PBVfacet@locale@2@B 003f ?id@?$numpunct@G@std@@2V0locale@2@A 0044 ??Bid@locale@std@@QAEIXZ 0053 ?_Getfacet@locale@std@@QBEPBVfacet@12@I@Z 0079 ?_Getcat@?$numpunct@G@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0089 ??0bad_cast@std@@QAE@XZ 008e __TI2?AVbad_cast@std@@ 0097 __CxxThrowException@8 00c1 @_guard_check_icall@4 00d0 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00e8 ??1_Lockit@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 28 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 6A 00 8D 4D DC E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 A1 ?? ?? ?? ?? 89 45 F0 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 E0 8B 4D E0 51 8B 4D 08 E8 ?? ?? ?? ?? 89 45 EC 83 7D EC 00 74 02 EB 75 83 7D F0 00 74 08 8B 55 F0 89 55 EC EB 67 8B 45 08 50 8D 4D F0 51 E8 ?? ?? ?? ?? 83 C4 08 83 F8 FF 75 18 8D 4D CC E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 55 CC 52 E8 ?? ?? ?? ?? EB 3A 8B 45 F0 89 45 EC 8B 4D F0 89 0D ?? ?? ?? ?? 8B 55 F0 89 55 E8 8B 45 E8 8B 08 8B 51 04 89 55 E4 8B 4D E4 E8 ?? ?? ?? ?? 8B 4D E8 FF 55 E4 8B 45 E8 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D EC 89 4D D8 C7 45 FC FF FF FF FF 8D 4D DC E8 ?? ?? ?? ?? 8B 45 D8 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_44_230_2 {
	meta:
		name = "??$use_facet@V?$numpunct@_W@std@@@std@@YAABV?$numpunct@_W@0@ABVlocale@0@@Z"
		size = 254
		refs = "0006 __ehhandler$??$use_facet@V?$numpunct@_W@std@@@std@@YAABV?$numpunct@_W@0@ABVlocale@0@@Z 0015 ___security_cookie 002b ??0_Lockit@std@@QAE@H@Z 0037 ?_Psave@?$_Facetptr@V?$numpunct@_W@std@@@std@@2PBVfacet@locale@2@B 003f ?id@?$numpunct@_W@std@@2V0locale@2@A 0044 ??Bid@locale@std@@QAEIXZ 0053 ?_Getfacet@locale@std@@QBEPBVfacet@12@I@Z 0079 ?_Getcat@?$numpunct@_W@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0089 ??0bad_cast@std@@QAE@XZ 008e __TI2?AVbad_cast@std@@ 0097 __CxxThrowException@8 00c1 @_guard_check_icall@4 00d0 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00e8 ??1_Lockit@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 28 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 6A 00 8D 4D DC E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 A1 ?? ?? ?? ?? 89 45 F0 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 E0 8B 4D E0 51 8B 4D 08 E8 ?? ?? ?? ?? 89 45 EC 83 7D EC 00 74 02 EB 75 83 7D F0 00 74 08 8B 55 F0 89 55 EC EB 67 8B 45 08 50 8D 4D F0 51 E8 ?? ?? ?? ?? 83 C4 08 83 F8 FF 75 18 8D 4D CC E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 55 CC 52 E8 ?? ?? ?? ?? EB 3A 8B 45 F0 89 45 EC 8B 4D F0 89 0D ?? ?? ?? ?? 8B 55 F0 89 55 E8 8B 45 E8 8B 08 8B 51 04 89 55 E4 8B 4D E4 E8 ?? ?? ?? ?? 8B 4D E8 FF 55 E4 8B 45 E8 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D EC 89 4D D8 C7 45 FC FF FF FF FF 8D 4D DC E8 ?? ?? ?? ?? 8B 45 D8 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_90_93_2 {
	meta:
		name = "??$use_facet@V?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z"
		size = 254
		refs = "0006 __ehhandler$??$use_facet@V?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z 0015 ___security_cookie 002b ??0_Lockit@std@@QAE@H@Z 0037 ?_Psave@?$_Facetptr@V?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@2PBVfacet@locale@2@B 003f ?id@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@2V0locale@2@A 0044 ??Bid@locale@std@@QAEIXZ 0053 ?_Getfacet@locale@std@@QBEPBVfacet@12@I@Z 0079 ?_Getcat@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0089 ??0bad_cast@std@@QAE@XZ 008e __TI2?AVbad_cast@std@@ 0097 __CxxThrowException@8 00c1 @_guard_check_icall@4 00d0 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00e8 ??1_Lockit@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 28 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 6A 00 8D 4D DC E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 A1 ?? ?? ?? ?? 89 45 F0 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 E0 8B 4D E0 51 8B 4D 08 E8 ?? ?? ?? ?? 89 45 EC 83 7D EC 00 74 02 EB 75 83 7D F0 00 74 08 8B 55 F0 89 55 EC EB 67 8B 45 08 50 8D 4D F0 51 E8 ?? ?? ?? ?? 83 C4 08 83 F8 FF 75 18 8D 4D CC E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 55 CC 52 E8 ?? ?? ?? ?? EB 3A 8B 45 F0 89 45 EC 8B 4D F0 89 0D ?? ?? ?? ?? 8B 55 F0 89 55 E8 8B 45 E8 8B 08 8B 51 04 89 55 E4 8B 4D E4 E8 ?? ?? ?? ?? 8B 4D E8 FF 55 E4 8B 45 E8 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D EC 89 4D D8 C7 45 FC FF FF FF FF 8D 4D DC E8 ?? ?? ?? ?? 8B 45 D8 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_29_193_1 {
	meta:
		name = "??$use_facet@V?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z"
		size = 254
		refs = "0006 __ehhandler$??$use_facet@V?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z 0015 ___security_cookie 002b ??0_Lockit@std@@QAE@H@Z 0037 ?_Psave@?$_Facetptr@V?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@2PBVfacet@locale@2@B 003f ?id@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@2V0locale@2@A 0044 ??Bid@locale@std@@QAEIXZ 0053 ?_Getfacet@locale@std@@QBEPBVfacet@12@I@Z 0079 ?_Getcat@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0089 ??0bad_cast@std@@QAE@XZ 008e __TI2?AVbad_cast@std@@ 0097 __CxxThrowException@8 00c1 @_guard_check_icall@4 00d0 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00e8 ??1_Lockit@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 28 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 6A 00 8D 4D DC E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 A1 ?? ?? ?? ?? 89 45 F0 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 E0 8B 4D E0 51 8B 4D 08 E8 ?? ?? ?? ?? 89 45 EC 83 7D EC 00 74 02 EB 75 83 7D F0 00 74 08 8B 55 F0 89 55 EC EB 67 8B 45 08 50 8D 4D F0 51 E8 ?? ?? ?? ?? 83 C4 08 83 F8 FF 75 18 8D 4D CC E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 55 CC 52 E8 ?? ?? ?? ?? EB 3A 8B 45 F0 89 45 EC 8B 4D F0 89 0D ?? ?? ?? ?? 8B 55 F0 89 55 E8 8B 45 E8 8B 08 8B 51 04 89 55 E4 8B 4D E4 E8 ?? ?? ?? ?? 8B 4D E8 FF 55 E4 8B 45 E8 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D EC 89 4D D8 C7 45 FC FF FF FF FF 8D 4D DC E8 ?? ?? ?? ?? 8B 45 D8 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_29_196_1 {
	meta:
		name = "??$use_facet@V?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z"
		size = 254
		refs = "0006 __ehhandler$??$use_facet@V?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z 0015 ___security_cookie 002b ??0_Lockit@std@@QAE@H@Z 0037 ?_Psave@?$_Facetptr@V?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@2PBVfacet@locale@2@B 003f ?id@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@2V0locale@2@A 0044 ??Bid@locale@std@@QAEIXZ 0053 ?_Getfacet@locale@std@@QBEPBVfacet@12@I@Z 0079 ?_Getcat@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0089 ??0bad_cast@std@@QAE@XZ 008e __TI2?AVbad_cast@std@@ 0097 __CxxThrowException@8 00c1 @_guard_check_icall@4 00d0 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00e8 ??1_Lockit@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 28 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 6A 00 8D 4D DC E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 A1 ?? ?? ?? ?? 89 45 F0 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 E0 8B 4D E0 51 8B 4D 08 E8 ?? ?? ?? ?? 89 45 EC 83 7D EC 00 74 02 EB 75 83 7D F0 00 74 08 8B 55 F0 89 55 EC EB 67 8B 45 08 50 8D 4D F0 51 E8 ?? ?? ?? ?? 83 C4 08 83 F8 FF 75 18 8D 4D CC E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 55 CC 52 E8 ?? ?? ?? ?? EB 3A 8B 45 F0 89 45 EC 8B 4D F0 89 0D ?? ?? ?? ?? 8B 55 F0 89 55 E8 8B 45 E8 8B 08 8B 51 04 89 55 E4 8B 4D E4 E8 ?? ?? ?? ?? 8B 4D E8 FF 55 E4 8B 45 E8 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D EC 89 4D D8 C7 45 FC FF FF FF FF 8D 4D DC E8 ?? ?? ?? ?? 8B 45 D8 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_80_74_1 {
	meta:
		name = "??$use_facet@V?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z"
		size = 254
		refs = "0006 __ehhandler$??$use_facet@V?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z 0015 ___security_cookie 002b ??0_Lockit@std@@QAE@H@Z 0037 ?_Psave@?$_Facetptr@V?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@2PBVfacet@locale@2@B 003f ?id@?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@2V0locale@2@A 0044 ??Bid@locale@std@@QAEIXZ 0053 ?_Getfacet@locale@std@@QBEPBVfacet@12@I@Z 0079 ?_Getcat@?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0089 ??0bad_cast@std@@QAE@XZ 008e __TI2?AVbad_cast@std@@ 0097 __CxxThrowException@8 00c1 @_guard_check_icall@4 00d0 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00e8 ??1_Lockit@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 28 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 6A 00 8D 4D DC E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 A1 ?? ?? ?? ?? 89 45 F0 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 E0 8B 4D E0 51 8B 4D 08 E8 ?? ?? ?? ?? 89 45 EC 83 7D EC 00 74 02 EB 75 83 7D F0 00 74 08 8B 55 F0 89 55 EC EB 67 8B 45 08 50 8D 4D F0 51 E8 ?? ?? ?? ?? 83 C4 08 83 F8 FF 75 18 8D 4D CC E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 55 CC 52 E8 ?? ?? ?? ?? EB 3A 8B 45 F0 89 45 EC 8B 4D F0 89 0D ?? ?? ?? ?? 8B 55 F0 89 55 E8 8B 45 E8 8B 08 8B 51 04 89 55 E4 8B 4D E4 E8 ?? ?? ?? ?? 8B 4D E8 FF 55 E4 8B 45 E8 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D EC 89 4D D8 C7 45 FC FF FF FF FF 8D 4D DC E8 ?? ?? ?? ?? 8B 45 D8 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_29_199_1 {
	meta:
		name = "??$use_facet@V?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z"
		size = 254
		refs = "0006 __ehhandler$??$use_facet@V?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z 0015 ___security_cookie 002b ??0_Lockit@std@@QAE@H@Z 0037 ?_Psave@?$_Facetptr@V?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@2PBVfacet@locale@2@B 003f ?id@?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@2V0locale@2@A 0044 ??Bid@locale@std@@QAEIXZ 0053 ?_Getfacet@locale@std@@QBEPBVfacet@12@I@Z 0079 ?_Getcat@?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0089 ??0bad_cast@std@@QAE@XZ 008e __TI2?AVbad_cast@std@@ 0097 __CxxThrowException@8 00c1 @_guard_check_icall@4 00d0 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00e8 ??1_Lockit@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 28 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 6A 00 8D 4D DC E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 A1 ?? ?? ?? ?? 89 45 F0 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 E0 8B 4D E0 51 8B 4D 08 E8 ?? ?? ?? ?? 89 45 EC 83 7D EC 00 74 02 EB 75 83 7D F0 00 74 08 8B 55 F0 89 55 EC EB 67 8B 45 08 50 8D 4D F0 51 E8 ?? ?? ?? ?? 83 C4 08 83 F8 FF 75 18 8D 4D CC E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 55 CC 52 E8 ?? ?? ?? ?? EB 3A 8B 45 F0 89 45 EC 8B 4D F0 89 0D ?? ?? ?? ?? 8B 55 F0 89 55 E8 8B 45 E8 8B 08 8B 51 04 89 55 E4 8B 4D E4 E8 ?? ?? ?? ?? 8B 4D E8 FF 55 E4 8B 45 E8 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D EC 89 4D D8 C7 45 FC FF FF FF FF 8D 4D DC E8 ?? ?? ?? ?? 8B 45 D8 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_29_202_1 {
	meta:
		name = "??$use_facet@V?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z"
		size = 254
		refs = "0006 __ehhandler$??$use_facet@V?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z 0015 ___security_cookie 002b ??0_Lockit@std@@QAE@H@Z 0037 ?_Psave@?$_Facetptr@V?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@2PBVfacet@locale@2@B 003f ?id@?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@2V0locale@2@A 0044 ??Bid@locale@std@@QAEIXZ 0053 ?_Getfacet@locale@std@@QBEPBVfacet@12@I@Z 0079 ?_Getcat@?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0089 ??0bad_cast@std@@QAE@XZ 008e __TI2?AVbad_cast@std@@ 0097 __CxxThrowException@8 00c1 @_guard_check_icall@4 00d0 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00e8 ??1_Lockit@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 28 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 6A 00 8D 4D DC E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 A1 ?? ?? ?? ?? 89 45 F0 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 E0 8B 4D E0 51 8B 4D 08 E8 ?? ?? ?? ?? 89 45 EC 83 7D EC 00 74 02 EB 75 83 7D F0 00 74 08 8B 55 F0 89 55 EC EB 67 8B 45 08 50 8D 4D F0 51 E8 ?? ?? ?? ?? 83 C4 08 83 F8 FF 75 18 8D 4D CC E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 55 CC 52 E8 ?? ?? ?? ?? EB 3A 8B 45 F0 89 45 EC 8B 4D F0 89 0D ?? ?? ?? ?? 8B 55 F0 89 55 E8 8B 45 E8 8B 08 8B 51 04 89 55 E4 8B 4D E4 E8 ?? ?? ?? ?? 8B 4D E8 FF 55 E4 8B 45 E8 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D EC 89 4D D8 C7 45 FC FF FF FF FF 8D 4D DC E8 ?? ?? ?? ?? 8B 45 D8 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_3_29_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$codecvt@DDU_Mbstatet@@@std@@@std@@YAABV?$codecvt@DDU_Mbstatet@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$codecvt@DDU_Mbstatet@@@std@@@std@@YAABV?$codecvt@DDU_Mbstatet@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1_41_2 {
	meta:
		name = "__ehhandler$??$use_facet@V?$codecvt@GDU_Mbstatet@@@std@@@std@@YAABV?$codecvt@GDU_Mbstatet@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$codecvt@GDU_Mbstatet@@@std@@@std@@YAABV?$codecvt@GDU_Mbstatet@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_41_2 {
	meta:
		name = "__ehhandler$??$use_facet@V?$codecvt@_WDU_Mbstatet@@@std@@@std@@YAABV?$codecvt@_WDU_Mbstatet@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$codecvt@_WDU_Mbstatet@@@std@@@std@@YAABV?$codecvt@_WDU_Mbstatet@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_80_52_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$collate@D@std@@@std@@YAABV?$collate@D@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$collate@D@std@@@std@@YAABV?$collate@D@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_175_2 {
	meta:
		name = "__ehhandler$??$use_facet@V?$collate@G@std@@@std@@YAABV?$collate@G@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$collate@G@std@@@std@@YAABV?$collate@G@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_178_2 {
	meta:
		name = "__ehhandler$??$use_facet@V?$collate@_W@std@@@std@@YAABV?$collate@_W@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$collate@_W@std@@@std@@YAABV?$collate@_W@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_110_44_2 {
	meta:
		name = "__ehhandler$??$use_facet@V?$ctype@D@std@@@std@@YAABV?$ctype@D@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$ctype@D@std@@@std@@YAABV?$ctype@D@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_9_44_2 {
	meta:
		name = "__ehhandler$??$use_facet@V?$ctype@G@std@@@std@@YAABV?$ctype@G@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$ctype@G@std@@@std@@YAABV?$ctype@G@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_59_44_2 {
	meta:
		name = "__ehhandler$??$use_facet@V?$ctype@_W@std@@@std@@YAABV?$ctype@_W@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$ctype@_W@std@@@std@@YAABV?$ctype@_W@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_100_94_3 {
	meta:
		name = "__ehhandler$??$use_facet@V?$messages@D@std@@@std@@YAABV?$messages@D@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$messages@D@std@@@std@@YAABV?$messages@D@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_233_3 {
	meta:
		name = "__ehhandler$??$use_facet@V?$messages@G@std@@@std@@YAABV?$messages@G@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$messages@G@std@@@std@@YAABV?$messages@G@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_236_3 {
	meta:
		name = "__ehhandler$??$use_facet@V?$messages@_W@std@@@std@@YAABV?$messages@_W@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$messages@_W@std@@@std@@YAABV?$messages@_W@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_80_61_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_239_3 {
	meta:
		name = "__ehhandler$??$use_facet@V?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_29_156_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_90_86_2 {
	meta:
		name = "__ehhandler$??$use_facet@V?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_29_159_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_29_162_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_100_103_3 {
	meta:
		name = "__ehhandler$??$use_facet@V?$moneypunct@D$00@std@@@std@@YAABV?$moneypunct@D$00@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$moneypunct@D$00@std@@@std@@YAABV?$moneypunct@D$00@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_100_106_3 {
	meta:
		name = "__ehhandler$??$use_facet@V?$moneypunct@D$0A@@std@@@std@@YAABV?$moneypunct@D$0A@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$moneypunct@D$0A@@std@@@std@@YAABV?$moneypunct@D$0A@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_251_3 {
	meta:
		name = "__ehhandler$??$use_facet@V?$moneypunct@G$00@std@@@std@@YAABV?$moneypunct@G$00@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$moneypunct@G$00@std@@@std@@YAABV?$moneypunct@G$00@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_254_3 {
	meta:
		name = "__ehhandler$??$use_facet@V?$moneypunct@G$0A@@std@@@std@@YAABV?$moneypunct@G$0A@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$moneypunct@G$0A@@std@@@std@@YAABV?$moneypunct@G$0A@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_257_3 {
	meta:
		name = "__ehhandler$??$use_facet@V?$moneypunct@_W$00@std@@@std@@YAABV?$moneypunct@_W$00@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$moneypunct@_W$00@std@@@std@@YAABV?$moneypunct@_W$00@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_260_3 {
	meta:
		name = "__ehhandler$??$use_facet@V?$moneypunct@_W$0A@@std@@@std@@YAABV?$moneypunct@_W$0A@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$moneypunct@_W$0A@@std@@@std@@YAABV?$moneypunct@_W$0A@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_53_57_3 {
	meta:
		name = "__ehhandler$??$use_facet@V?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_29_177_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_29_180_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_53_60_3 {
	meta:
		name = "__ehhandler$??$use_facet@V?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_269_3 {
	meta:
		name = "__ehhandler$??$use_facet@V?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_29_186_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_3_41_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$numpunct@D@std@@@std@@YAABV?$numpunct@D@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$numpunct@D@std@@@std@@YAABV?$numpunct@D@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_229_2 {
	meta:
		name = "__ehhandler$??$use_facet@V?$numpunct@G@std@@@std@@YAABV?$numpunct@G@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$numpunct@G@std@@@std@@YAABV?$numpunct@G@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_232_2 {
	meta:
		name = "__ehhandler$??$use_facet@V?$numpunct@_W@std@@@std@@YAABV?$numpunct@_W@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$numpunct@_W@std@@@std@@YAABV?$numpunct@_W@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_90_95_2 {
	meta:
		name = "__ehhandler$??$use_facet@V?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_235_2 {
	meta:
		name = "__ehhandler$??$use_facet@V?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_29_198_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_80_76_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_287_3 {
	meta:
		name = "__ehhandler$??$use_facet@V?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_29_204_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_117_20_1 {
	meta:
		name = "__ehhandler$?create_stl_condition_variable@details@Concurrency@@YAXPAVstl_condition_variable_interface@12@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?create_stl_condition_variable@details@Concurrency@@YAXPAVstl_condition_variable_interface@12@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_54_20_1 {
	meta:
		name = "__ehhandler$?create_stl_critical_section@details@Concurrency@@YAXPAVstl_critical_section_interface@12@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?create_stl_critical_section@details@Concurrency@@YAXPAVstl_critical_section_interface@12@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_3_42_1 {
	meta:
		name = "??0?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAE@XZ"
		size = 29
		refs = "0012 ??$?0$$V@?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@D@std@@@std@@V?$_String_val@U?$_Simple_types@D@std@@@2@$00@std@@QAE@U_Zero_then_variadic_args_t@1@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D F8 0F B6 45 FF 50 8B 4D F8 E8 ?? ?? ?? ?? 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_29_212_1 {
	meta:
		name = "??0?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAE@XZ"
		size = 29
		refs = "0012 ??$?0$$V@?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@G@std@@@std@@V?$_String_val@U?$_Simple_types@G@std@@@2@$00@std@@QAE@U_Zero_then_variadic_args_t@1@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D F8 0F B6 45 FF 50 8B 4D F8 E8 ?? ?? ?? ?? 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_29_213_1 {
	meta:
		name = "??0?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAE@XZ"
		size = 29
		refs = "0012 ??$?0$$V@?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@_W@std@@@std@@V?$_String_val@U?$_Simple_types@_W@std@@@2@$00@std@@QAE@U_Zero_then_variadic_args_t@1@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D F8 0F B6 45 FF 50 8B 4D F8 E8 ?? ?? ?? ?? 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_3_43_1 {
	meta:
		name = "??0?$_String_val@U?$_Simple_types@D@std@@@std@@QAE@XZ"
		size = 42
		refs = "000b ??0_Bxty@?$_String_val@U?$_Simple_types@D@std@@@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC C7 40 10 00 00 00 00 8B 4D FC C7 41 14 00 00 00 00 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_29_221_1 {
	meta:
		name = "??0?$_String_val@U?$_Simple_types@G@std@@@std@@QAE@XZ"
		size = 42
		refs = "000b ??0_Bxty@?$_String_val@U?$_Simple_types@G@std@@@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC C7 40 10 00 00 00 00 8B 4D FC C7 41 14 00 00 00 00 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_29_222_1 {
	meta:
		name = "??0?$_String_val@U?$_Simple_types@_W@std@@@std@@QAE@XZ"
		size = 42
		refs = "000b ??0_Bxty@?$_String_val@U?$_Simple_types@_W@std@@@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC C7 40 10 00 00 00 00 8B 4D FC C7 41 14 00 00 00 00 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_3_44_1 {
	meta:
		name = "??0?$_Wrap_alloc@V?$allocator@D@std@@@std@@QAE@XZ"
		size = 22
		refs = "000b ??0?$allocator@D@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_118_66_3 {
	meta:
		name = "??0?$_Iterator012@Urandom_access_iterator_tag@std@@DHPBDABDU_Iterator_base12@2@@std@@QAE@XZ"
		size = 22
		refs = "000b ??0_Iterator_base12@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_44_247_2 {
	meta:
		name = "??0?$_Iterator012@Urandom_access_iterator_tag@std@@GHPBGABGU_Iterator_base12@2@@std@@QAE@XZ"
		size = 22
		refs = "000b ??0_Iterator_base12@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_49_27_3 {
	meta:
		name = "??0?$_Iterator012@Urandom_access_iterator_tag@std@@_WHPB_WAB_WU_Iterator_base12@2@@std@@QAE@XZ"
		size = 22
		refs = "000b ??0_Iterator_base12@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_10_340_3 {
	meta:
		name = "??0?$_Wrap_alloc@V?$allocator@G@std@@@std@@QAE@XZ"
		size = 22
		refs = "000b ??0?$allocator@G@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_6_30_3 {
	meta:
		name = "??0?$_Wrap_alloc@V?$allocator@_W@std@@@std@@QAE@XZ"
		size = 22
		refs = "000b ??0?$allocator@_W@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_79_47_2 {
	meta:
		name = "??0?$shared_ptr@V__ExceptionPtr@@@std@@QAE@XZ"
		size = 22
		refs = "000b ??0?$_Ptr_base@V__ExceptionPtr@@@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_90_265_2 {
	meta:
		name = "??E?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@QAEAAV01@XZ"
		size = 22
		refs = "000b ?_Inc@?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@AAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_44_581_2 {
	meta:
		name = "??E?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@QAEAAV01@XZ"
		size = 22
		refs = "000b ?_Inc@?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@AAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_44_582_2 {
	meta:
		name = "??E?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@QAEAAV01@XZ"
		size = 22
		refs = "000b ?_Inc@?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@AAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_3_45_1 {
	meta:
		name = "??0?$_Yarn@D@std@@QAE@XZ"
		size = 30
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 00 00 00 00 8B 4D FC C6 41 04 00 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_3_46_1 {
	meta:
		name = "??0?$_Yarn@_W@std@@QAE@XZ"
		size = 32
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 00 00 00 00 33 C9 8B 55 FC 66 89 4A 04 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_3_47_1 {
	meta:
		name = "??0?$allocator@D@std@@QAE@ABV01@@Z"
		size = 16
		altNames = "??$?0D@?$allocator@U_Container_proxy@std@@@std@@QAE@ABV?$allocator@D@1@@Z ??$?0G@?$allocator@U_Container_proxy@std@@@std@@QAE@ABV?$allocator@G@1@@Z ??$?0H@?$_StaticAllocator@V?$_Ref_count_obj_alloc@V__ExceptionPtr@@U?$_StaticAllocator@H@@@std@@@@QAE@ABU?$_StaticAllocator@H@@@Z ??$?0Uoutput_iterator_tag@std@@@_Any_tag@std@@QAE@$$QAUoutput_iterator_tag@1@@Z ??$?0_W@?$allocator@U_Container_proxy@std@@@std@@QAE@ABV?$allocator@_W@1@@Z ??0?$allocator@G@std@@QAE@ABV01@@Z ??0?$allocator@_W@std@@QAE@ABV01@@Z ??0locale@std@@QAE@W4_Uninitialized@1@@Z ??E?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@QAEAAV01@H@Z ??E?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@QAEAAV01@H@Z ??E?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@QAEAAV01@H@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_3_49_1 {
	meta:
		name = "??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@ID@Z"
		size = 109
		refs = "0006 __ehhandler$??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@ID@Z 0013 ___security_cookie 002a ??0?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAE@XZ 003d ?_Tidy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEX_NI@Z 004e ?assign@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAAV12@ID@Z"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 51 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D F0 8B 4D F0 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 6A 00 6A 00 8B 4D F0 E8 ?? ?? ?? ?? 0F B6 45 0C 50 8B 4D 08 51 8B 4D F0 E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8B 45 F0 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_3_51_1 {
	meta:
		name = "__ehhandler$??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@ID@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@ID@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_79_11_2 {
	meta:
		name = "__ehhandler$??$?0ABU?$_StaticAllocator@H@@@?$_Wrap_alloc@U?$_StaticAllocator@V?$_Ref_count_obj_alloc@V__ExceptionPtr@@U?$_StaticAllocator@H@@@std@@@@@std@@QAE@ABU?$_StaticAllocator@H@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$?0ABU?$_StaticAllocator@H@@@?$_Wrap_alloc@U?$_StaticAllocator@V?$_Ref_count_obj_alloc@V__ExceptionPtr@@U?$_StaticAllocator@H@@@std@@@@@std@@QAE@ABU?$_StaticAllocator@H@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_80_79_1 {
	meta:
		name = "__ehhandler$??0?$_Mpunct@D@std@@QAE@ABV_Locinfo@1@I_N1@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_Mpunct@D@std@@QAE@ABV_Locinfo@1@I_N1@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_253_2 {
	meta:
		name = "__ehhandler$??0?$_Mpunct@G@std@@QAE@ABV_Locinfo@1@I_N1@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_Mpunct@G@std@@QAE@ABV_Locinfo@1@I_N1@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_29_210_1 {
	meta:
		name = "__ehhandler$??0?$_Mpunct@_W@std@@QAE@ABV_Locinfo@1@I_N1@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_Mpunct@_W@std@@QAE@ABV_Locinfo@1@I_N1@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_19_72_3 {
	meta:
		name = "__ehhandler$??0?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QAE@PBDPBU_Container_base12@1@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QAE@PBDPBU_Container_base12@1@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_316_3 {
	meta:
		name = "__ehhandler$??0?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QAE@PBGPBU_Container_base12@1@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QAE@PBGPBU_Container_base12@1@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_34_3 {
	meta:
		name = "__ehhandler$??0?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QAE@PB_WPBU_Container_base12@1@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QAE@PB_WPBU_Container_base12@1@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_59_62_3 {
	meta:
		name = "__ehhandler$??0?$_String_val@U?$_Simple_types@D@std@@@std@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_String_val@U?$_Simple_types@D@std@@@std@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_287_2 {
	meta:
		name = "__ehhandler$??0?$_String_val@U?$_Simple_types@G@std@@@std@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_String_val@U?$_Simple_types@G@std@@@std@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_336_3 {
	meta:
		name = "__ehhandler$??0?$_String_val@U?$_Simple_types@_W@std@@@std@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_String_val@U?$_Simple_types@_W@std@@@std@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_32_43_1 {
	meta:
		name = "__ehhandler$??0?$basic_filebuf@DU?$char_traits@D@std@@@std@@QAE@PAU_iobuf@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_filebuf@DU?$char_traits@D@std@@@std@@QAE@PAU_iobuf@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_85_85_3 {
	meta:
		name = "__ehhandler$??0?$basic_filebuf@GU?$char_traits@G@std@@@std@@QAE@PAU_iobuf@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_filebuf@GU?$char_traits@G@std@@@std@@QAE@PAU_iobuf@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_3_85_3 {
	meta:
		name = "__ehhandler$??0?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@QAE@PAU_iobuf@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@QAE@PAU_iobuf@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_19_92_3 {
	meta:
		name = "__ehhandler$??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@$$QAV01@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@$$QAV01@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_100_59_1 {
	meta:
		name = "__ehhandler$??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@PBD@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@PBD@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_90_138_2 {
	meta:
		name = "__ehhandler$??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@PBDI@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@PBDI@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_19_103_3 {
	meta:
		name = "__ehhandler$??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_362_3 {
	meta:
		name = "__ehhandler$??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE@$$QAV01@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE@$$QAV01@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_29_254_1 {
	meta:
		name = "__ehhandler$??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE@IG@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE@IG@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_29_257_1 {
	meta:
		name = "__ehhandler$??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE@PBG@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE@PBG@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_328_2 {
	meta:
		name = "__ehhandler$??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE@PBGI@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE@PBGI@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_376_3 {
	meta:
		name = "__ehhandler$??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_332_2 {
	meta:
		name = "__ehhandler$??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE@$$QAV01@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE@$$QAV01@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_29_270_1 {
	meta:
		name = "__ehhandler$??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE@I_W@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE@I_W@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_341_2 {
	meta:
		name = "__ehhandler$??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE@PB_W@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE@PB_W@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_29_276_1 {
	meta:
		name = "__ehhandler$??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE@PB_WI@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE@PB_WI@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_29_278_1 {
	meta:
		name = "__ehhandler$??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_64_1 {
	meta:
		name = "__ehhandler$??0?$codecvt@DDU_Mbstatet@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$codecvt@DDU_Mbstatet@@@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_349_2 {
	meta:
		name = "__ehhandler$??0?$codecvt@GDU_Mbstatet@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$codecvt@GDU_Mbstatet@@@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_3_106_3 {
	meta:
		name = "__ehhandler$??0?$codecvt@_WDU_Mbstatet@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$codecvt@_WDU_Mbstatet@@@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_80_109_1 {
	meta:
		name = "__ehhandler$??0?$collate@D@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$collate@D@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_401_3 {
	meta:
		name = "__ehhandler$??0?$collate@G@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$collate@G@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_404_3 {
	meta:
		name = "__ehhandler$??0?$collate@_W@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$collate@_W@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_107_96_3 {
	meta:
		name = "__ehhandler$??0?$ctype@D@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$ctype@D@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_19_109_3 {
	meta:
		name = "__ehhandler$??0?$ctype@G@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$ctype@G@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_4_67_1 {
	meta:
		name = "__ehhandler$??0?$ctype@_W@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$ctype@_W@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_80_115_1 {
	meta:
		name = "__ehhandler$??0?$messages@D@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$messages@D@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_29_299_1 {
	meta:
		name = "__ehhandler$??0?$messages@G@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$messages@G@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_370_2 {
	meta:
		name = "__ehhandler$??0?$messages@_W@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$messages@_W@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_100_166_3 {
	meta:
		name = "__ehhandler$??0?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_419_3 {
	meta:
		name = "__ehhandler$??0?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_422_3 {
	meta:
		name = "__ehhandler$??0?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_100_169_3 {
	meta:
		name = "__ehhandler$??0?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_379_2 {
	meta:
		name = "__ehhandler$??0?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_428_3 {
	meta:
		name = "__ehhandler$??0?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_3_65_1 {
	meta:
		name = "__ehhandler$??0?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_435_3 {
	meta:
		name = "__ehhandler$??0?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_29_324_1 {
	meta:
		name = "__ehhandler$??0?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_53_94_3 {
	meta:
		name = "__ehhandler$??0?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_395_2 {
	meta:
		name = "__ehhandler$??0?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_29_330_1 {
	meta:
		name = "__ehhandler$??0?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_3_71_1 {
	meta:
		name = "__ehhandler$??0?$numpunct@D@std@@QAE@ABV_Locinfo@1@I_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$numpunct@D@std@@QAE@ABV_Locinfo@1@I_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_447_3 {
	meta:
		name = "__ehhandler$??0?$numpunct@G@std@@QAE@ABV_Locinfo@1@I_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$numpunct@G@std@@QAE@ABV_Locinfo@1@I_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_29_336_1 {
	meta:
		name = "__ehhandler$??0?$numpunct@_W@std@@QAE@ABV_Locinfo@1@I_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$numpunct@_W@std@@QAE@ABV_Locinfo@1@I_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_94_44_3 {
	meta:
		name = "__ehhandler$??0?$shared_ptr@V__ExceptionPtr@@@std@@QAE@$$QAV01@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$shared_ptr@V__ExceptionPtr@@@std@@QAE@$$QAV01@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_94_46_3 {
	meta:
		name = "__ehhandler$??0?$shared_ptr@V__ExceptionPtr@@@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$shared_ptr@V__ExceptionPtr@@@std@@QAE@ABV01@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_90_160_2 {
	meta:
		name = "__ehhandler$??0?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_407_2 {
	meta:
		name = "__ehhandler$??0?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_456_3 {
	meta:
		name = "__ehhandler$??0?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_100_178_3 {
	meta:
		name = "__ehhandler$??0?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_29_346_1 {
	meta:
		name = "__ehhandler$??0?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_29_350_1 {
	meta:
		name = "__ehhandler$??0?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_102_6_1 {
	meta:
		name = "__ehhandler$??0_Locimp@locale@std@@AAE@ABV012@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0_Locimp@locale@std@@AAE@ABV012@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_102_9_1 {
	meta:
		name = "__ehhandler$??0_Locimp@locale@std@@AAE@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0_Locimp@locale@std@@AAE@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_104_125_2 {
	meta:
		name = "__ehhandler$??0facet@locale@std@@IAE@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0facet@locale@std@@IAE@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_67_140_3 {
	meta:
		name = "__ehhandler$??0locale@std@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0locale@std@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_60_76_3 {
	meta:
		name = "__ehhandler$??0sentry@?$basic_ostream@DU?$char_traits@D@std@@@std@@QAE@AAV12@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0sentry@?$basic_ostream@DU?$char_traits@D@std@@@std@@QAE@AAV12@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_16_55_1 {
	meta:
		name = "__ehhandler$??0sentry@?$basic_ostream@GU?$char_traits@G@std@@@std@@QAE@AAV12@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0sentry@?$basic_ostream@GU?$char_traits@G@std@@@std@@QAE@AAV12@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_50_75_2 {
	meta:
		name = "__ehhandler$??0sentry@?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAE@AAV12@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0sentry@?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAE@AAV12@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_80_162_1 {
	meta:
		name = "__ehhandler$??1?$_Mpunct@D@std@@MAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$_Mpunct@D@std@@MAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_507_3 {
	meta:
		name = "__ehhandler$??1?$_Mpunct@G@std@@MAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$_Mpunct@G@std@@MAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_29_389_1 {
	meta:
		name = "__ehhandler$??1?$_Mpunct@_W@std@@MAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$_Mpunct@_W@std@@MAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_59_102_3 {
	meta:
		name = "__ehhandler$??1?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_467_2 {
	meta:
		name = "__ehhandler$??1?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_107_40_2 {
	meta:
		name = "__ehhandler$??1?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_100_222_3 {
	meta:
		name = "__ehhandler$??1?$_Yarn@D@std@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$_Yarn@D@std@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_9_151_2 {
	meta:
		name = "__ehhandler$??1?$_Yarn@_W@std@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$_Yarn@_W@std@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_48_154_2 {
	meta:
		name = "__ehhandler$??1?$basic_filebuf@DU?$char_traits@D@std@@@std@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$basic_filebuf@DU?$char_traits@D@std@@@std@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_104_153_2 {
	meta:
		name = "__ehhandler$??1?$basic_filebuf@GU?$char_traits@G@std@@@std@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$basic_filebuf@GU?$char_traits@G@std@@@std@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_3_173_3 {
	meta:
		name = "__ehhandler$??1?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_84_129_1 {
	meta:
		name = "__ehhandler$??1?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_29_403_1 {
	meta:
		name = "__ehhandler$??1?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_486_2 {
	meta:
		name = "__ehhandler$??1?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_3_111_1 {
	meta:
		name = "__ehhandler$??1?$ctype@D@std@@MAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$ctype@D@std@@MAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_3_115_1 {
	meta:
		name = "__ehhandler$??1?$numpunct@D@std@@MAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$numpunct@D@std@@MAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_554_3 {
	meta:
		name = "__ehhandler$??1?$numpunct@G@std@@MAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$numpunct@G@std@@MAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_510_2 {
	meta:
		name = "__ehhandler$??1?$numpunct@_W@std@@MAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$numpunct@_W@std@@MAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_79_59_2 {
	meta:
		name = "__ehhandler$??1?$shared_ptr@V__ExceptionPtr@@@std@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$shared_ptr@V__ExceptionPtr@@@std@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_80_180_1 {
	meta:
		name = "__ehhandler$??1?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_29_431_1 {
	meta:
		name = "__ehhandler$??1?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_514_2 {
	meta:
		name = "__ehhandler$??1?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_0_165_2 {
	meta:
		name = "__ehhandler$??1_Container_base12@std@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1_Container_base12@std@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_38_23_3 {
	meta:
		name = "__ehhandler$??1_Locimp@locale@std@@MAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1_Locimp@locale@std@@MAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_114_190_3 {
	meta:
		name = "__ehhandler$??1_Locinfo@std@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1_Locinfo@std@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_16_73_1 {
	meta:
		name = "__ehhandler$??1_UShinit@std@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1_UShinit@std@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_53_73_1 {
	meta:
		name = "__ehhandler$??1_Winit@std@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1_Winit@std@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_32_149_1 {
	meta:
		name = "__ehhandler$??1ios_base@std@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1ios_base@std@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_60_101_3 {
	meta:
		name = "__ehhandler$??1sentry@?$basic_ostream@DU?$char_traits@D@std@@@std@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1sentry@?$basic_ostream@DU?$char_traits@D@std@@@std@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_5_104_3 {
	meta:
		name = "__ehhandler$??1sentry@?$basic_ostream@GU?$char_traits@G@std@@@std@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1sentry@?$basic_ostream@GU?$char_traits@G@std@@@std@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_53_79_1 {
	meta:
		name = "__ehhandler$??1sentry@?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1sentry@?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_81_8_2 {
	meta:
		name = "__ehhandler$??_EGlobalCore@details@Concurrency@@QAEPAXI@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??_EGlobalCore@details@Concurrency@@QAEPAXI@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_15_12_1 {
	meta:
		name = "__ehhandler$?_CallInContext@_ContextCallback@details@Concurrency@@QBEXV?$function@$$A6AXXZ@std@@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_CallInContext@_ContextCallback@details@Concurrency@@QBEXV?$function@$$A6AXXZ@std@@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_93_104_1 {
	meta:
		name = "__ehhandler$?_Destroy@?$_Ref_count_obj@V__ExceptionPtr@@@std@@EAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Destroy@?$_Ref_count_obj@V__ExceptionPtr@@@std@@EAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_94_106_3 {
	meta:
		name = "__ehhandler$?_Destroy@?$_Ref_count_obj_alloc@V__ExceptionPtr@@U?$_StaticAllocator@H@@@std@@EAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Destroy@?$_Ref_count_obj_alloc@V__ExceptionPtr@@U?$_StaticAllocator@H@@@std@@EAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_114_360_3 {
	meta:
		name = "__ehhandler$?c_str@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBEPBDXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?c_str@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBEPBDXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_29_1075_1 {
	meta:
		name = "__ehhandler$?c_str@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QBEPBGXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?c_str@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QBEPBGXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_1282_3 {
	meta:
		name = "__ehhandler$?c_str@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QBEPB_WXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?c_str@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QBEPB_WXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_59_233_3 {
	meta:
		name = "__ehhandler$?swap@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEXAAV12@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?swap@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEXAAV12@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_3_52_1 {
	meta:
		name = "??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@PBD@Z"
		size = 104
		refs = "0006 __ehhandler$??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@PBD@Z 0013 ___security_cookie 002a ??0?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAE@XZ 003d ?_Tidy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEX_NI@Z 0049 ?assign@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAAV12@PBD@Z"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 51 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D F0 8B 4D F0 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 6A 00 6A 00 8B 4D F0 E8 ?? ?? ?? ?? 8B 45 08 50 8B 4D F0 E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8B 45 F0 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_29_255_1 {
	meta:
		name = "??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE@PBG@Z"
		size = 104
		refs = "0006 __ehhandler$??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE@PBG@Z 0013 ___security_cookie 002a ??0?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAE@XZ 003d ?_Tidy@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAEX_NI@Z 0049 ?assign@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAEAAV12@PBG@Z"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 51 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D F0 8B 4D F0 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 6A 00 6A 00 8B 4D F0 E8 ?? ?? ?? ?? 8B 45 08 50 8B 4D F0 E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8B 45 F0 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_29_271_1 {
	meta:
		name = "??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE@PB_W@Z"
		size = 104
		refs = "0006 __ehhandler$??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE@PB_W@Z 0013 ___security_cookie 002a ??0?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAE@XZ 003d ?_Tidy@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAEX_NI@Z 0049 ?assign@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAEAAV12@PB_W@Z"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 51 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D F0 8B 4D F0 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 6A 00 6A 00 8B 4D F0 E8 ?? ?? ?? ?? 8B 45 08 50 8B 4D F0 E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8B 45 F0 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_3_55_1 {
	meta:
		name = "??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@XZ"
		size = 76
		refs = "0006 __ehhandler$??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@XZ 0013 ___security_cookie 002a ??0?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAE@XZ 0036 ?_Tidy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEX_NI@Z"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 51 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D F0 8B 4D F0 E8 ?? ?? ?? ?? 6A 00 6A 00 8B 4D F0 E8 ?? ?? ?? ?? 8B 45 F0 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_29_261_1 {
	meta:
		name = "??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE@XZ"
		size = 76
		refs = "0006 __ehhandler$??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE@XZ 0013 ___security_cookie 002a ??0?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAE@XZ 0036 ?_Tidy@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAEX_NI@Z"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 51 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D F0 8B 4D F0 E8 ?? ?? ?? ?? 6A 00 6A 00 8B 4D F0 E8 ?? ?? ?? ?? 8B 45 F0 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_29_277_1 {
	meta:
		name = "??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE@XZ"
		size = 76
		refs = "0006 __ehhandler$??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE@XZ 0013 ___security_cookie 002a ??0?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAE@XZ 0036 ?_Tidy@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAEX_NI@Z"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 51 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D F0 8B 4D F0 E8 ?? ?? ?? ?? 6A 00 6A 00 8B 4D F0 E8 ?? ?? ?? ?? 8B 45 F0 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_3_57_1 {
	meta:
		name = "??0?$codecvt@DDU_Mbstatet@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 105
		refs = "0006 __ehhandler$??0?$codecvt@DDU_Mbstatet@@@std@@QAE@ABV_Locinfo@1@I@Z 0013 ___security_cookie 002e ??0codecvt_base@std@@QAE@I@Z 003e ??_7?$codecvt@DDU_Mbstatet@@@std@@6B@ 004a ?_Init@?$codecvt@DDU_Mbstatet@@@std@@IAEXABV_Locinfo@2@@Z"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 51 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D F0 8B 45 0C 50 8B 4D F0 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D F0 C7 01 ?? ?? ?? ?? 8B 55 08 52 8B 4D F0 E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8B 45 F0 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_29_279_1 {
	meta:
		name = "??0?$codecvt@GDU_Mbstatet@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 105
		refs = "0006 __ehhandler$??0?$codecvt@GDU_Mbstatet@@@std@@QAE@ABV_Locinfo@1@I@Z 0013 ___security_cookie 002e ??0codecvt_base@std@@QAE@I@Z 003e ??_7?$codecvt@GDU_Mbstatet@@@std@@6B@ 004a ?_Init@?$codecvt@GDU_Mbstatet@@@std@@IAEXABV_Locinfo@2@@Z"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 51 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D F0 8B 45 0C 50 8B 4D F0 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D F0 C7 01 ?? ?? ?? ?? 8B 55 08 52 8B 4D F0 E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8B 45 F0 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_75_62_1 {
	meta:
		name = "??0?$codecvt@_WDU_Mbstatet@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 105
		refs = "0006 __ehhandler$??0?$codecvt@_WDU_Mbstatet@@@std@@QAE@ABV_Locinfo@1@I@Z 0013 ___security_cookie 002e ??0codecvt_base@std@@QAE@I@Z 003e ??_7?$codecvt@_WDU_Mbstatet@@@std@@6B@ 004a ?_Init@?$codecvt@_WDU_Mbstatet@@@std@@IAEXABV_Locinfo@2@@Z"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 51 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D F0 8B 45 0C 50 8B 4D F0 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D F0 C7 01 ?? ?? ?? ?? 8B 55 08 52 8B 4D F0 E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8B 45 F0 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_90_141_2 {
	meta:
		name = "??0?$collate@D@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 105
		refs = "0006 __ehhandler$??0?$collate@D@std@@QAE@ABV_Locinfo@1@I@Z 0013 ___security_cookie 002e ??0facet@locale@std@@IAE@I@Z 003e ??_7?$collate@D@std@@6B@ 004a ?_Init@?$collate@D@std@@IAEXABV_Locinfo@2@@Z"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 51 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D F0 8B 45 0C 50 8B 4D F0 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D F0 C7 01 ?? ?? ?? ?? 8B 55 08 52 8B 4D F0 E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8B 45 F0 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_44_353_2 {
	meta:
		name = "??0?$collate@G@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 105
		refs = "0006 __ehhandler$??0?$collate@G@std@@QAE@ABV_Locinfo@1@I@Z 0013 ___security_cookie 002e ??0facet@locale@std@@IAE@I@Z 003e ??_7?$collate@G@std@@6B@ 004a ?_Init@?$collate@G@std@@IAEXABV_Locinfo@2@@Z"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 51 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D F0 8B 45 0C 50 8B 4D F0 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D F0 C7 01 ?? ?? ?? ?? 8B 55 08 52 8B 4D F0 E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8B 45 F0 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_44_356_2 {
	meta:
		name = "??0?$collate@_W@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 105
		refs = "0006 __ehhandler$??0?$collate@_W@std@@QAE@ABV_Locinfo@1@I@Z 0013 ___security_cookie 002e ??0facet@locale@std@@IAE@I@Z 003e ??_7?$collate@_W@std@@6B@ 004a ?_Init@?$collate@_W@std@@IAEXABV_Locinfo@2@@Z"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 51 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D F0 8B 45 0C 50 8B 4D F0 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D F0 C7 01 ?? ?? ?? ?? 8B 55 08 52 8B 4D F0 E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8B 45 F0 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_48_87_2 {
	meta:
		name = "??0?$ctype@D@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 105
		refs = "0006 __ehhandler$??0?$ctype@D@std@@QAE@ABV_Locinfo@1@I@Z 0013 ___security_cookie 002e ??0ctype_base@std@@QAE@I@Z 003e ??_7?$ctype@D@std@@6B@ 004a ?_Init@?$ctype@D@std@@IAEXABV_Locinfo@2@@Z"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 51 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D F0 8B 45 0C 50 8B 4D F0 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D F0 C7 01 ?? ?? ?? ?? 8B 55 08 52 8B 4D F0 E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8B 45 F0 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_104_87_2 {
	meta:
		name = "??0?$ctype@G@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 105
		refs = "0006 __ehhandler$??0?$ctype@G@std@@QAE@ABV_Locinfo@1@I@Z 0013 ___security_cookie 002e ??0ctype_base@std@@QAE@I@Z 003e ??_7?$ctype@G@std@@6B@ 004a ?_Init@?$ctype@G@std@@IAEXABV_Locinfo@2@@Z"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 51 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D F0 8B 45 0C 50 8B 4D F0 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D F0 C7 01 ?? ?? ?? ?? 8B 55 08 52 8B 4D F0 E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8B 45 F0 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_3_107_3 {
	meta:
		name = "??0?$ctype@_W@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 105
		refs = "0006 __ehhandler$??0?$ctype@_W@std@@QAE@ABV_Locinfo@1@I@Z 0013 ___security_cookie 002e ??0ctype_base@std@@QAE@I@Z 003e ??_7?$ctype@_W@std@@6B@ 004a ?_Init@?$ctype@_W@std@@IAEXABV_Locinfo@2@@Z"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 51 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D F0 8B 45 0C 50 8B 4D F0 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D F0 C7 01 ?? ?? ?? ?? 8B 55 08 52 8B 4D F0 E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8B 45 F0 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_80_113_1 {
	meta:
		name = "??0?$messages@D@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 105
		refs = "0006 __ehhandler$??0?$messages@D@std@@QAE@ABV_Locinfo@1@I@Z 0013 ___security_cookie 002e ??0messages_base@std@@QAE@I@Z 003e ??_7?$messages@D@std@@6B@ 004a ?_Init@?$messages@D@std@@IAEXABV_Locinfo@2@@Z"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 51 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D F0 8B 45 0C 50 8B 4D F0 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D F0 C7 01 ?? ?? ?? ?? 8B 55 08 52 8B 4D F0 E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8B 45 F0 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_44_365_2 {
	meta:
		name = "??0?$messages@G@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 105
		refs = "0006 __ehhandler$??0?$messages@G@std@@QAE@ABV_Locinfo@1@I@Z 0013 ___security_cookie 002e ??0messages_base@std@@QAE@I@Z 003e ??_7?$messages@G@std@@6B@ 004a ?_Init@?$messages@G@std@@IAEXABV_Locinfo@2@@Z"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 51 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D F0 8B 45 0C 50 8B 4D F0 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D F0 C7 01 ?? ?? ?? ?? 8B 55 08 52 8B 4D F0 E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8B 45 F0 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_29_300_1 {
	meta:
		name = "??0?$messages@_W@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 105
		refs = "0006 __ehhandler$??0?$messages@_W@std@@QAE@ABV_Locinfo@1@I@Z 0013 ___security_cookie 002e ??0messages_base@std@@QAE@I@Z 003e ??_7?$messages@_W@std@@6B@ 004a ?_Init@?$messages@_W@std@@IAEXABV_Locinfo@2@@Z"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 51 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D F0 8B 45 0C 50 8B 4D F0 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D F0 C7 01 ?? ?? ?? ?? 8B 55 08 52 8B 4D F0 E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8B 45 F0 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_100_164_3 {
	meta:
		name = "??0?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 105
		refs = "0006 __ehhandler$??0?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0013 ___security_cookie 002e ??0facet@locale@std@@IAE@I@Z 003e ??_7?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@6B@ 004a ?_Init@?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@IAEXABV_Locinfo@2@@Z"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 51 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D F0 8B 45 0C 50 8B 4D F0 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D F0 C7 01 ?? ?? ?? ?? 8B 55 08 52 8B 4D F0 E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8B 45 F0 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_29_303_1 {
	meta:
		name = "??0?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 105
		refs = "0006 __ehhandler$??0?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0013 ___security_cookie 002e ??0facet@locale@std@@IAE@I@Z 003e ??_7?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@6B@ 004a ?_Init@?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@IAEXABV_Locinfo@2@@Z"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 51 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D F0 8B 45 0C 50 8B 4D F0 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D F0 C7 01 ?? ?? ?? ?? 8B 55 08 52 8B 4D F0 E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8B 45 F0 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_44_374_2 {
	meta:
		name = "??0?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 105
		refs = "0006 __ehhandler$??0?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0013 ___security_cookie 002e ??0facet@locale@std@@IAE@I@Z 003e ??_7?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@6B@ 004a ?_Init@?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@IAEXABV_Locinfo@2@@Z"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 51 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D F0 8B 45 0C 50 8B 4D F0 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D F0 C7 01 ?? ?? ?? ?? 8B 55 08 52 8B 4D F0 E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8B 45 F0 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_100_167_3 {
	meta:
		name = "??0?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 105
		refs = "0006 __ehhandler$??0?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0013 ___security_cookie 002e ??0facet@locale@std@@IAE@I@Z 003e ??_7?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@6B@ 004a ?_Init@?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@IAEXABV_Locinfo@2@@Z"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 51 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D F0 8B 45 0C 50 8B 4D F0 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D F0 C7 01 ?? ?? ?? ?? 8B 55 08 52 8B 4D F0 E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8B 45 F0 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_44_377_2 {
	meta:
		name = "??0?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 105
		refs = "0006 __ehhandler$??0?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0013 ___security_cookie 002e ??0facet@locale@std@@IAE@I@Z 003e ??_7?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@6B@ 004a ?_Init@?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@IAEXABV_Locinfo@2@@Z"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 51 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D F0 8B 45 0C 50 8B 4D F0 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D F0 C7 01 ?? ?? ?? ?? 8B 55 08 52 8B 4D F0 E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8B 45 F0 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_44_380_2 {
	meta:
		name = "??0?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 105
		refs = "0006 __ehhandler$??0?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0013 ___security_cookie 002e ??0facet@locale@std@@IAE@I@Z 003e ??_7?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@6B@ 004a ?_Init@?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@IAEXABV_Locinfo@2@@Z"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 51 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D F0 8B 45 0C 50 8B 4D F0 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D F0 C7 01 ?? ?? ?? ?? 8B 55 08 52 8B 4D F0 E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8B 45 F0 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_3_63_1 {
	meta:
		name = "??0?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 105
		refs = "0006 __ehhandler$??0?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0013 ___security_cookie 002e ??0facet@locale@std@@IAE@I@Z 003e ??_7?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@6B@ 004a ?_Init@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@IAEXABV_Locinfo@2@@Z"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 51 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D F0 8B 45 0C 50 8B 4D F0 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D F0 C7 01 ?? ?? ?? ?? 8B 55 08 52 8B 4D F0 E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8B 45 F0 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_10_433_3 {
	meta:
		name = "??0?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 105
		refs = "0006 __ehhandler$??0?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0013 ___security_cookie 002e ??0facet@locale@std@@IAE@I@Z 003e ??_7?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@6B@ 004a ?_Init@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@IAEXABV_Locinfo@2@@Z"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 51 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D F0 8B 45 0C 50 8B 4D F0 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D F0 C7 01 ?? ?? ?? ?? 8B 55 08 52 8B 4D F0 E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8B 45 F0 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_29_322_1 {
	meta:
		name = "??0?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 105
		refs = "0006 __ehhandler$??0?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0013 ___security_cookie 002e ??0facet@locale@std@@IAE@I@Z 003e ??_7?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@6B@ 004a ?_Init@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@IAEXABV_Locinfo@2@@Z"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 51 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D F0 8B 45 0C 50 8B 4D F0 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D F0 C7 01 ?? ?? ?? ?? 8B 55 08 52 8B 4D F0 E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8B 45 F0 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_110_82_2 {
	meta:
		name = "??0?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 105
		refs = "0006 __ehhandler$??0?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0013 ___security_cookie 002e ??0facet@locale@std@@IAE@I@Z 003e ??_7?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@6B@ 004a ?_Init@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@IAEXABV_Locinfo@2@@Z"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 51 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D F0 8B 45 0C 50 8B 4D F0 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D F0 C7 01 ?? ?? ?? ?? 8B 55 08 52 8B 4D F0 E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8B 45 F0 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_29_325_1 {
	meta:
		name = "??0?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 105
		refs = "0006 __ehhandler$??0?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0013 ___security_cookie 002e ??0facet@locale@std@@IAE@I@Z 003e ??_7?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@6B@ 004a ?_Init@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@IAEXABV_Locinfo@2@@Z"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 51 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D F0 8B 45 0C 50 8B 4D F0 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D F0 C7 01 ?? ?? ?? ?? 8B 55 08 52 8B 4D F0 E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8B 45 F0 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_44_396_2 {
	meta:
		name = "??0?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 105
		refs = "0006 __ehhandler$??0?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0013 ___security_cookie 002e ??0facet@locale@std@@IAE@I@Z 003e ??_7?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@6B@ 004a ?_Init@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@IAEXABV_Locinfo@2@@Z"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 51 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D F0 8B 45 0C 50 8B 4D F0 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D F0 C7 01 ?? ?? ?? ?? 8B 55 08 52 8B 4D F0 E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8B 45 F0 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_80_124_1 {
	meta:
		name = "??0?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 105
		refs = "0006 __ehhandler$??0?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0013 ___security_cookie 002e ??0time_base@std@@QAE@I@Z 003e ??_7?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@6B@ 004a ?_Init@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@IAEXABV_Locinfo@2@@Z"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 51 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D F0 8B 45 0C 50 8B 4D F0 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D F0 C7 01 ?? ?? ?? ?? 8B 55 08 52 8B 4D F0 E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8B 45 F0 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_29_337_1 {
	meta:
		name = "??0?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 105
		refs = "0006 __ehhandler$??0?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0013 ___security_cookie 002e ??0time_base@std@@QAE@I@Z 003e ??_7?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@6B@ 004a ?_Init@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@IAEXABV_Locinfo@2@@Z"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 51 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D F0 8B 45 0C 50 8B 4D F0 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D F0 C7 01 ?? ?? ?? ?? 8B 55 08 52 8B 4D F0 E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8B 45 F0 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_29_340_1 {
	meta:
		name = "??0?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 105
		refs = "0006 __ehhandler$??0?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0013 ___security_cookie 002e ??0time_base@std@@QAE@I@Z 003e ??_7?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@6B@ 004a ?_Init@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@IAEXABV_Locinfo@2@@Z"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 51 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D F0 8B 45 0C 50 8B 4D F0 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D F0 C7 01 ?? ?? ?? ?? 8B 55 08 52 8B 4D F0 E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8B 45 F0 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_3_69_1 {
	meta:
		name = "??0?$numpunct@D@std@@QAE@ABV_Locinfo@1@I_N@Z"
		size = 110
		refs = "0006 __ehhandler$??0?$numpunct@D@std@@QAE@ABV_Locinfo@1@I_N@Z 0013 ___security_cookie 002e ??0facet@locale@std@@IAE@I@Z 003e ??_7?$numpunct@D@std@@6B@ 004f ?_Init@?$numpunct@D@std@@IAEXABV_Locinfo@2@_N@Z"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 51 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D F0 8B 45 0C 50 8B 4D F0 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D F0 C7 01 ?? ?? ?? ?? 0F B6 55 10 52 8B 45 08 50 8B 4D F0 E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8B 45 F0 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule file_29_331_1 {
	meta:
		name = "??0?$numpunct@G@std@@QAE@ABV_Locinfo@1@I_N@Z"
		size = 110
		refs = "0006 __ehhandler$??0?$numpunct@G@std@@QAE@ABV_Locinfo@1@I_N@Z 0013 ___security_cookie 002e ??0facet@locale@std@@IAE@I@Z 003e ??_7?$numpunct@G@std@@6B@ 004f ?_Init@?$numpunct@G@std@@IAEXABV_Locinfo@2@_N@Z"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 51 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D F0 8B 45 0C 50 8B 4D F0 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D F0 C7 01 ?? ?? ?? ?? 0F B6 55 10 52 8B 45 08 50 8B 4D F0 E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8B 45 F0 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule file_29_334_1 {
	meta:
		name = "??0?$numpunct@_W@std@@QAE@ABV_Locinfo@1@I_N@Z"
		size = 110
		refs = "0006 __ehhandler$??0?$numpunct@_W@std@@QAE@ABV_Locinfo@1@I_N@Z 0013 ___security_cookie 002e ??0facet@locale@std@@IAE@I@Z 003e ??_7?$numpunct@_W@std@@6B@ 004f ?_Init@?$numpunct@_W@std@@IAEXABV_Locinfo@2@_N@Z"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 51 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D F0 8B 45 0C 50 8B 4D F0 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D F0 C7 01 ?? ?? ?? ?? 0F B6 55 10 52 8B 45 08 50 8B 4D F0 E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8B 45 F0 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule file_3_73_1 {
	meta:
		name = "??0_Facet_base@std@@QAE@XZ"
		size = 23
		refs = "000c ??_7_Facet_base@std@@6B@"
		altNames = "??0?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QAE@XZ ??0?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QAE@XZ ??0?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QAE@XZ ??0Block@_HeapManager@@QAE@XZ ??0Replicator@@QAE@XZ ??0_Container_base12@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_33_11_4 {
	meta:
		name = "??0DNameNode@@IAE@XZ"
		size = 23
		refs = "000c ??_7DNameNode@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_48_129_2 {
	meta:
		name = "??0ios_base@std@@IAE@XZ"
		size = 23
		refs = "000c ??_7ios_base@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_3_74_1 {
	meta:
		name = "??0_Locinfo@std@@QAE@PBD@Z"
		size = 223
		refs = "0006 __ehhandler$??0_Locinfo@std@@QAE@PBD@Z 0015 ___security_cookie 002e ??0_Lockit@std@@QAE@H@Z 0040 ??0?$_Yarn@D@std@@QAE@XZ 005e ??0?$_Yarn@_W@std@@QAE@XZ 009a ??_C@_0BA@ELKIONDK@bad?5locale?5name?$AA@ 00a2 ??0runtime_error@std@@QAE@PBD@Z 00a7 __TI2?AVruntime_error@std@@ 00b0 __CxxThrowException@8 00bd ?_Locinfo_ctor@_Locinfo@std@@SAXPAV12@PBD@Z"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 10 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D F0 6A 00 8B 4D F0 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D F0 83 C1 04 E8 ?? ?? ?? ?? C6 45 FC 01 8B 4D F0 83 C1 0C E8 ?? ?? ?? ?? C6 45 FC 02 8B 4D F0 83 C1 14 E8 ?? ?? ?? ?? C6 45 FC 03 8B 4D F0 83 C1 1C E8 ?? ?? ?? ?? C6 45 FC 04 8B 4D F0 83 C1 24 E8 ?? ?? ?? ?? C6 45 FC 05 8B 4D F0 83 C1 2C E8 ?? ?? ?? ?? C6 45 FC 06 83 7D 08 00 75 1B 68 ?? ?? ?? ?? 8D 4D E4 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 E4 50 E8 ?? ?? ?? ?? 8B 4D 08 51 8B 55 F0 52 E8 ?? ?? ?? ?? 83 C4 08 C7 45 FC FF FF FF FF 8B 45 F0 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_3_82_1 {
	meta:
		name = "__ehhandler$??0_Locinfo@std@@QAE@PBD@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0_Locinfo@std@@QAE@PBD@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_79_3_2 {
	meta:
		name = "__ehhandler$??$?0AAPAUEHExceptionRecord@@_N@?$_Ref_count_obj@V__ExceptionPtr@@@std@@QAE@AAPAUEHExceptionRecord@@$$QA_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$?0AAPAUEHExceptionRecord@@_N@?$_Ref_count_obj@V__ExceptionPtr@@@std@@QAE@AAPAUEHExceptionRecord@@$$QA_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_40_1_3 {
	meta:
		name = "__ehhandler$??1_Init_atexit@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1_Init_atexit@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_13_4 {
	meta:
		name = "__ehhandler$?CallUnexpected@@YAXPBU_s_ESTypeList@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?CallUnexpected@@YAXPBU_s_ESTypeList@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_114_249_3 {
	meta:
		name = "__ehhandler$?_Adopt@_Iterator_base12@std@@QAEXPBU_Container_base12@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Adopt@_Iterator_base12@std@@QAEXPBU_Container_base12@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_90_429_2 {
	meta:
		name = "__ehhandler$?_Init@?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@IAEXABV_Locinfo@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Init@?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@IAEXABV_Locinfo@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_1070_3 {
	meta:
		name = "__ehhandler$?_Init@?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@IAEXABV_Locinfo@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Init@?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@IAEXABV_Locinfo@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_1021_2 {
	meta:
		name = "__ehhandler$?_Init@?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@IAEXABV_Locinfo@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Init@?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@IAEXABV_Locinfo@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_94_117_3 {
	meta:
		name = "__ehhandler$?_InitBadAllocException@__ExceptionPtr@@CA?AV?$shared_ptr@V__ExceptionPtr@@@std@@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_InitBadAllocException@__ExceptionPtr@@CA?AV?$shared_ptr@V__ExceptionPtr@@@std@@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_70_4_2 {
	meta:
		name = "__ehhandler$?set_new_handler@std@@YAP6AXXZP6AXXZ@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?set_new_handler@std@@YAP6AXXZP6AXXZ@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_3_88_1 {
	meta:
		name = "??0exception@std@@QAE@QBD@Z"
		size = 69
		refs = "000e ??_7exception@std@@6B@ 0035 ___std_exception_copy"
	strings:
		$1 = { 55 8B EC 83 EC 0C 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 33 C9 8B 55 FC 83 C2 04 89 0A 89 4A 04 8B 45 08 89 45 F4 C6 45 F8 01 8B 4D FC 83 C1 04 51 8D 55 F4 52 E8 ?? ?? ?? ?? 83 C4 08 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_3_90_1 {
	meta:
		name = "??0facet@locale@std@@IAE@I@Z"
		size = 108
		refs = "0006 __ehhandler$??0facet@locale@std@@IAE@I@Z 0013 ___security_cookie 002a ??0_Facet_base@std@@QAE@XZ 003a ??_7facet@locale@std@@6B@ 004a ?_Init_atomic_counter@std@@YAXAAKK@Z"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 51 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D F0 8B 4D F0 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 45 F0 C7 00 ?? ?? ?? ?? 8B 4D 08 51 8B 55 F0 83 C2 04 52 E8 ?? ?? ?? ?? 83 C4 08 C7 45 FC FF FF FF FF 8B 45 F0 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_3_94_1 {
	meta:
		name = "??0locale@std@@QAE@ABV01@@Z"
		size = 107
		refs = "0006 __ehhandler$??0locale@std@@QAE@ABV01@@Z 0016 ___security_cookie 004d @_guard_check_icall@4"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 08 56 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D F0 8B 45 F0 8B 4D 08 8B 51 04 89 50 04 8B 45 F0 8B 48 04 8B 55 F0 8B 72 04 8B 01 8B 48 04 89 4D EC 8B 4D EC E8 ?? ?? ?? ?? 8B CE FF 55 EC 8B 45 F0 8B 4D F4 64 89 0D 00 00 00 00 59 5E 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_3_95_1 {
	meta:
		name = "__ehhandler$??0locale@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0locale@std@@QAE@ABV01@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_94_16_3 {
	meta:
		name = "__ehhandler$??$_Construct1@V?$_Ref_count_obj_alloc@V__ExceptionPtr@@U?$_StaticAllocator@H@@@std@@ABU?$_StaticAllocator@H@@AAPAUEHExceptionRecord@@_N@?$allocator_traits@U?$_StaticAllocator@V?$_Ref_count_obj_alloc@V__ExceptionPtr@@U?$_StaticAllocator@H@@@std@@@@@std@@SAXU?$integral_constant@_N$00@1@AAU?$_StaticAllocator@V?$_Ref_count_obj_alloc@V__ExceptionPtr@@U?$_StaticAllocator@H@@@std@@@@PAV?$_Ref_count_obj_alloc@V__ExceptionPtr@@U?$_StaticAllocator@H@@@1@ABU?$_StaticAllocator@H@@AAPAUEHExceptionRecord@@$$QA_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$_Construct1@V?$_Ref_count_obj_alloc@V__ExceptionPtr@@U?$_StaticAllocator@H@@@std@@ABU?$_StaticAllocator@H@@AAPAUEHExceptionRecord@@_N@?$allocator_traits@U?$_StaticAllocator@V?$_Ref_count_obj_alloc@V__ExceptionPtr@@U?$_StaticAllocator@H@@@std@@@@@std@@SAXU?$integral_constant@_N$00@1@AAU?$_StaticAllocator@V?$_Ref_count_obj_alloc@V__ExceptionPtr@@U?$_StaticAllocator@H@@@std@@@@PAV?$_Ref_count_obj_alloc@V__ExceptionPtr@@U?$_StaticAllocator@H@@@1@ABU?$_StaticAllocator@H@@AAPAUEHExceptionRecord@@$$QA_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_59_51_3 {
	meta:
		name = "__ehhandler$??$swap@D$0BA@X@std@@YAXAAY0BA@D0@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$swap@D$0BA@X@std@@YAXAAY0BA@D0@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_100_266_3 {
	meta:
		name = "__ehhandler$??4?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAAV01@$$QAV01@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??4?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAAV01@$$QAV01@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_29_463_1 {
	meta:
		name = "__ehhandler$??4?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAEAAV01@$$QAV01@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??4?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAEAAV01@$$QAV01@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_554_2 {
	meta:
		name = "__ehhandler$??4?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAEAAV01@$$QAV01@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??4?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAEAAV01@$$QAV01@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_53_2 {
	meta:
		name = "__ehhandler$?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_68_2 {
	meta:
		name = "__ehhandler$?_New_Locimp@_Locimp@locale@std@@CAPAV123@ABV123@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_New_Locimp@_Locimp@locale@std@@CAPAV123@ABV123@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_71_2 {
	meta:
		name = "__ehhandler$?_New_Locimp@_Locimp@locale@std@@CAPAV123@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_New_Locimp@_Locimp@locale@std@@CAPAV123@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_76_162_1 {
	meta:
		name = "__ehhandler$?flush@?$basic_ostream@DU?$char_traits@D@std@@@std@@QAEAAV12@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?flush@?$basic_ostream@DU?$char_traits@D@std@@@std@@QAEAAV12@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_5_197_3 {
	meta:
		name = "__ehhandler$?flush@?$basic_ostream@GU?$char_traits@G@std@@@std@@QAEAAV12@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?flush@?$basic_ostream@GU?$char_traits@G@std@@@std@@QAEAAV12@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_27_197_3 {
	meta:
		name = "__ehhandler$?flush@?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAEAAV12@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?flush@?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAEAAV12@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_3_96_1 {
	meta:
		name = "??0locale@std@@QAE@XZ"
		size = 72
		refs = "0006 __ehhandler$??0locale@std@@QAE@XZ 0013 ___security_cookie 0029 ?_Init@locale@std@@CAPAV_Locimp@12@_N@Z"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 51 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D F0 6A 01 E8 ?? ?? ?? ?? 83 C4 04 8B 4D F0 89 41 04 8B 45 F0 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_3_103_1 {
	meta:
		name = "??1?$_Yarn@D@std@@QAE@XZ"
		size = 61
		refs = "0006 __ehhandler$??1?$_Yarn@D@std@@QAE@XZ 0013 ___security_cookie 002a ?_Tidy@?$_Yarn@D@std@@AAEXXZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 51 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D F0 8B 4D F0 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_53_134_3 {
	meta:
		name = "??1?$_Yarn@_W@std@@QAE@XZ"
		size = 61
		refs = "0006 __ehhandler$??1?$_Yarn@_W@std@@QAE@XZ 0013 ___security_cookie 002a ?_Tidy@?$_Yarn@_W@std@@AAEXXZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 51 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D F0 8B 4D F0 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_94_58_3 {
	meta:
		name = "??1?$shared_ptr@V__ExceptionPtr@@@std@@QAE@XZ"
		size = 61
		refs = "0006 __ehhandler$??1?$shared_ptr@V__ExceptionPtr@@@std@@QAE@XZ 0013 ___security_cookie 002a ?_Decref@?$_Ptr_base@V__ExceptionPtr@@@std@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 51 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D F0 8B 4D F0 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_102_164_2 {
	meta:
		name = "??1_Container_base12@std@@QAE@XZ"
		size = 61
		refs = "0006 __ehhandler$??1_Container_base12@std@@QAE@XZ 0013 ___security_cookie 002a ?_Orphan_all@_Container_base12@std@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 51 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D F0 8B 4D F0 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_10_1277_3 {
	meta:
		name = "?c_str@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBEPBDXZ"
		size = 61
		refs = "0006 __ehhandler$?c_str@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBEPBDXZ 0013 ___security_cookie 002a ?_Myptr@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QBEPBDXZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 51 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D F0 8B 4D F0 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_44_1226_2 {
	meta:
		name = "?c_str@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QBEPBGXZ"
		size = 61
		refs = "0006 __ehhandler$?c_str@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QBEPBGXZ 0013 ___security_cookie 002a ?_Myptr@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QBEPBGXZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 51 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D F0 8B 4D F0 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_69_85_1 {
	meta:
		name = "?c_str@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QBEPB_WXZ"
		size = 61
		refs = "0006 __ehhandler$?c_str@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QBEPB_WXZ 0013 ___security_cookie 002a ?_Myptr@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QBEPB_WXZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 51 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D F0 8B 4D F0 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_3_107_1 {
	meta:
		name = "??1?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@XZ"
		size = 73
		refs = "0006 __ehhandler$??1?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@XZ 0013 ___security_cookie 002e ?_Tidy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEX_NI@Z 0036 ??1?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 51 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D F0 6A 00 6A 01 8B 4D F0 E8 ?? ?? ?? ?? 8B 4D F0 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_29_402_1 {
	meta:
		name = "??1?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE@XZ"
		size = 73
		refs = "0006 __ehhandler$??1?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE@XZ 0013 ___security_cookie 002e ?_Tidy@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAEX_NI@Z 0036 ??1?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 51 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D F0 6A 00 6A 01 8B 4D F0 E8 ?? ?? ?? ?? 8B 4D F0 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_29_404_1 {
	meta:
		name = "??1?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE@XZ"
		size = 73
		refs = "0006 __ehhandler$??1?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE@XZ 0013 ___security_cookie 002e ?_Tidy@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAEX_NI@Z 0036 ??1?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 51 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D F0 6A 00 6A 01 8B 4D F0 E8 ?? ?? ?? ?? 8B 4D F0 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_3_109_1 {
	meta:
		name = "??1?$codecvt@DDU_Mbstatet@@@std@@MAE@XZ"
		size = 28
		refs = "000c ??_7?$codecvt@DDU_Mbstatet@@@std@@6B@ 0014 ??1codecvt_base@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_46_162_3 {
	meta:
		name = "??1?$basic_ios@DU?$char_traits@D@std@@@std@@UAE@XZ"
		size = 28
		refs = "000c ??_7?$basic_ios@DU?$char_traits@D@std@@@std@@6B@ 0014 ??1ios_base@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_19_174_3 {
	meta:
		name = "??1?$basic_ios@GU?$char_traits@G@std@@@std@@UAE@XZ"
		size = 28
		refs = "000c ??_7?$basic_ios@GU?$char_traits@G@std@@@std@@6B@ 0014 ??1ios_base@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_92_174_3 {
	meta:
		name = "??1?$basic_ios@_WU?$char_traits@_W@std@@@std@@UAE@XZ"
		size = 28
		refs = "000c ??_7?$basic_ios@_WU?$char_traits@_W@std@@@std@@6B@ 0014 ??1ios_base@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_9_159_2 {
	meta:
		name = "??1?$codecvt@GDU_Mbstatet@@@std@@MAE@XZ"
		size = 28
		refs = "000c ??_7?$codecvt@GDU_Mbstatet@@@std@@6B@ 0014 ??1codecvt_base@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_59_159_2 {
	meta:
		name = "??1?$codecvt@_WDU_Mbstatet@@@std@@MAE@XZ"
		size = 28
		refs = "000c ??_7?$codecvt@_WDU_Mbstatet@@@std@@6B@ 0014 ??1codecvt_base@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_100_230_3 {
	meta:
		name = "??1?$messages@D@std@@MAE@XZ"
		size = 28
		refs = "000c ??_7?$messages@D@std@@6B@ 0014 ??1messages_base@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_10_539_3 {
	meta:
		name = "??1?$messages@G@std@@MAE@XZ"
		size = 28
		refs = "000c ??_7?$messages@G@std@@6B@ 0014 ??1messages_base@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_44_494_2 {
	meta:
		name = "??1?$messages@_W@std@@MAE@XZ"
		size = 28
		refs = "000c ??_7?$messages@_W@std@@6B@ 0014 ??1messages_base@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_100_231_3 {
	meta:
		name = "??1?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAE@XZ"
		size = 28
		refs = "000c ??_7?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@6B@ 0014 ??1facet@locale@std@@MAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_29_414_1 {
	meta:
		name = "??1?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAE@XZ"
		size = 28
		refs = "000c ??_7?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@6B@ 0014 ??1facet@locale@std@@MAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_29_415_1 {
	meta:
		name = "??1?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAE@XZ"
		size = 28
		refs = "000c ??_7?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@6B@ 0014 ??1facet@locale@std@@MAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_100_232_3 {
	meta:
		name = "??1?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAE@XZ"
		size = 28
		refs = "000c ??_7?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@6B@ 0014 ??1facet@locale@std@@MAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_29_416_1 {
	meta:
		name = "??1?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAE@XZ"
		size = 28
		refs = "000c ??_7?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@6B@ 0014 ??1facet@locale@std@@MAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_29_417_1 {
	meta:
		name = "??1?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAE@XZ"
		size = 28
		refs = "000c ??_7?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@6B@ 0014 ??1facet@locale@std@@MAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_100_233_3 {
	meta:
		name = "??1?$moneypunct@D$00@std@@MAE@XZ"
		size = 28
		refs = "000c ??_7?$moneypunct@D$00@std@@6B@ 0014 ??1?$_Mpunct@D@std@@MAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_80_178_1 {
	meta:
		name = "??1?$moneypunct@D$0A@@std@@MAE@XZ"
		size = 28
		refs = "000c ??_7?$moneypunct@D$0A@@std@@6B@ 0014 ??1?$_Mpunct@D@std@@MAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_10_545_3 {
	meta:
		name = "??1?$moneypunct@G$00@std@@MAE@XZ"
		size = 28
		refs = "000c ??_7?$moneypunct@G$00@std@@6B@ 0014 ??1?$_Mpunct@G@std@@MAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_29_419_1 {
	meta:
		name = "??1?$moneypunct@G$0A@@std@@MAE@XZ"
		size = 28
		refs = "000c ??_7?$moneypunct@G$0A@@std@@6B@ 0014 ??1?$_Mpunct@G@std@@MAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_29_420_1 {
	meta:
		name = "??1?$moneypunct@_W$00@std@@MAE@XZ"
		size = 28
		refs = "000c ??_7?$moneypunct@_W$00@std@@6B@ 0014 ??1?$_Mpunct@_W@std@@MAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_44_502_2 {
	meta:
		name = "??1?$moneypunct@_W$0A@@std@@MAE@XZ"
		size = 28
		refs = "000c ??_7?$moneypunct@_W$0A@@std@@6B@ 0014 ??1?$_Mpunct@_W@std@@MAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_3_112_1 {
	meta:
		name = "??1?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAE@XZ"
		size = 28
		refs = "000c ??_7?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@6B@ 0014 ??1facet@locale@std@@MAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_29_422_1 {
	meta:
		name = "??1?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAE@XZ"
		size = 28
		refs = "000c ??_7?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@6B@ 0014 ??1facet@locale@std@@MAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_10_550_3 {
	meta:
		name = "??1?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAE@XZ"
		size = 28
		refs = "000c ??_7?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@6B@ 0014 ??1facet@locale@std@@MAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_53_142_3 {
	meta:
		name = "??1?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAE@XZ"
		size = 28
		refs = "000c ??_7?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@6B@ 0014 ??1facet@locale@std@@MAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_29_424_1 {
	meta:
		name = "??1?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAE@XZ"
		size = 28
		refs = "000c ??_7?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@6B@ 0014 ??1facet@locale@std@@MAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_29_425_1 {
	meta:
		name = "??1?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAE@XZ"
		size = 28
		refs = "000c ??_7?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@6B@ 0014 ??1facet@locale@std@@MAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_10_140_1 {
	meta:
		name = "??1codecvt_base@std@@UAE@XZ"
		size = 28
		refs = "000c ??_7codecvt_base@std@@6B@ 0014 ??1facet@locale@std@@MAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_32_143_1 {
	meta:
		name = "??1ctype_base@std@@UAE@XZ"
		size = 28
		refs = "000c ??_7ctype_base@std@@6B@ 0014 ??1facet@locale@std@@MAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_29_447_1 {
	meta:
		name = "??1facet@locale@std@@MAE@XZ"
		size = 28
		refs = "000c ??_7facet@locale@std@@6B@ 0014 ??1_Facet_base@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_10_584_3 {
	meta:
		name = "??1time_base@std@@UAE@XZ"
		size = 28
		refs = "000c ??_7time_base@std@@6B@ 0014 ??1facet@locale@std@@MAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_3_110_1 {
	meta:
		name = "??1?$ctype@D@std@@MAE@XZ"
		size = 78
		refs = "0006 __ehhandler$??1?$ctype@D@std@@MAE@XZ 0013 ___security_cookie 002b ??_7?$ctype@D@std@@6B@ 0033 ?_Tidy@?$ctype@D@std@@IAEXXZ 003b ??1ctype_base@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 51 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D F0 8B 45 F0 C7 00 ?? ?? ?? ?? 8B 4D F0 E8 ?? ?? ?? ?? 8B 4D F0 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_90_200_2 {
	meta:
		name = "??1?$_Mpunct@D@std@@MAE@XZ"
		size = 78
		refs = "0006 __ehhandler$??1?$_Mpunct@D@std@@MAE@XZ 0013 ___security_cookie 002b ??_7?$_Mpunct@D@std@@6B@ 0033 ?_Tidy@?$_Mpunct@D@std@@AAEXXZ 003b ??1money_base@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 51 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D F0 8B 45 F0 C7 00 ?? ?? ?? ?? 8B 4D F0 E8 ?? ?? ?? ?? 8B 4D F0 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_44_460_2 {
	meta:
		name = "??1?$_Mpunct@G@std@@MAE@XZ"
		size = 78
		refs = "0006 __ehhandler$??1?$_Mpunct@G@std@@MAE@XZ 0013 ___security_cookie 002b ??_7?$_Mpunct@G@std@@6B@ 0033 ?_Tidy@?$_Mpunct@G@std@@AAEXXZ 003b ??1money_base@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 51 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D F0 8B 45 F0 C7 00 ?? ?? ?? ?? 8B 4D F0 E8 ?? ?? ?? ?? 8B 4D F0 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_44_462_2 {
	meta:
		name = "??1?$_Mpunct@_W@std@@MAE@XZ"
		size = 78
		refs = "0006 __ehhandler$??1?$_Mpunct@_W@std@@MAE@XZ 0013 ___security_cookie 002b ??_7?$_Mpunct@_W@std@@6B@ 0033 ?_Tidy@?$_Mpunct@_W@std@@AAEXXZ 003b ??1money_base@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 51 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D F0 8B 45 F0 C7 00 ?? ?? ?? ?? 8B 4D F0 E8 ?? ?? ?? ?? 8B 4D F0 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_3_114_1 {
	meta:
		name = "??1?$numpunct@D@std@@MAE@XZ"
		size = 78
		refs = "0006 __ehhandler$??1?$numpunct@D@std@@MAE@XZ 0013 ___security_cookie 002b ??_7?$numpunct@D@std@@6B@ 0033 ?_Tidy@?$numpunct@D@std@@AAEXXZ 003b ??1facet@locale@std@@MAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 51 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D F0 8B 45 F0 C7 00 ?? ?? ?? ?? 8B 4D F0 E8 ?? ?? ?? ?? 8B 4D F0 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_29_426_1 {
	meta:
		name = "??1?$numpunct@G@std@@MAE@XZ"
		size = 78
		refs = "0006 __ehhandler$??1?$numpunct@G@std@@MAE@XZ 0013 ___security_cookie 002b ??_7?$numpunct@G@std@@6B@ 0033 ?_Tidy@?$numpunct@G@std@@AAEXXZ 003b ??1facet@locale@std@@MAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 51 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D F0 8B 45 F0 C7 00 ?? ?? ?? ?? 8B 4D F0 E8 ?? ?? ?? ?? 8B 4D F0 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_29_428_1 {
	meta:
		name = "??1?$numpunct@_W@std@@MAE@XZ"
		size = 78
		refs = "0006 __ehhandler$??1?$numpunct@_W@std@@MAE@XZ 0013 ___security_cookie 002b ??_7?$numpunct@_W@std@@6B@ 0033 ?_Tidy@?$numpunct@_W@std@@AAEXXZ 003b ??1facet@locale@std@@MAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 51 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D F0 8B 45 F0 C7 00 ?? ?? ?? ?? 8B 4D F0 E8 ?? ?? ?? ?? 8B 4D F0 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_100_235_3 {
	meta:
		name = "??1?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAE@XZ"
		size = 78
		refs = "0006 __ehhandler$??1?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAE@XZ 0013 ___security_cookie 002b ??_7?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@6B@ 0033 ?_Tidy@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@AAEXXZ 003b ??1time_base@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 51 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D F0 8B 45 F0 C7 00 ?? ?? ?? ?? 8B 4D F0 E8 ?? ?? ?? ?? 8B 4D F0 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_44_511_2 {
	meta:
		name = "??1?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAE@XZ"
		size = 78
		refs = "0006 __ehhandler$??1?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAE@XZ 0013 ___security_cookie 002b ??_7?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@6B@ 0033 ?_Tidy@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@AAEXXZ 003b ??1time_base@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 51 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D F0 8B 45 F0 C7 00 ?? ?? ?? ?? 8B 4D F0 E8 ?? ?? ?? ?? 8B 4D F0 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_44_513_2 {
	meta:
		name = "??1?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAE@XZ"
		size = 78
		refs = "0006 __ehhandler$??1?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAE@XZ 0013 ___security_cookie 002b ??_7?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@6B@ 0033 ?_Tidy@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@AAEXXZ 003b ??1time_base@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 51 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D F0 8B 45 F0 C7 00 ?? ?? ?? ?? 8B 4D F0 E8 ?? ?? ?? ?? 8B 4D F0 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_3_118_1 {
	meta:
		name = "??1_Locinfo@std@@QAE@XZ"
		size = 139
		refs = "0006 __ehhandler$??1_Locinfo@std@@QAE@XZ 0013 ___security_cookie 002b ?_Locinfo_dtor@_Locinfo@std@@SAXPAV12@@Z 0039 ??1?$_Yarn@D@std@@QAE@XZ 004f ??1?$_Yarn@_W@std@@QAE@XZ 0078 ??1_Lockit@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 51 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D F0 8B 45 F0 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D F0 83 C1 2C E8 ?? ?? ?? ?? 8B 4D F0 83 C1 24 E8 ?? ?? ?? ?? 8B 4D F0 83 C1 1C E8 ?? ?? ?? ?? 8B 4D F0 83 C1 14 E8 ?? ?? ?? ?? 8B 4D F0 83 C1 0C E8 ?? ?? ?? ?? 8B 4D F0 83 C1 04 E8 ?? ?? ?? ?? 8B 4D F0 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_3_125_1 {
	meta:
		name = "??1locale@std@@QAE@XZ"
		size = 152
		refs = "0006 __ehhandler$??1locale@std@@QAE@XZ 0016 ___security_cookie 004a @_guard_check_icall@4"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 18 56 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D F0 8B 45 F0 83 78 04 00 74 56 8B 4D F0 8B 51 04 8B 45 F0 8B 70 04 8B 0A 8B 51 08 89 55 E8 8B 4D E8 E8 ?? ?? ?? ?? 8B CE FF 55 E8 89 45 E0 8B 45 E0 89 45 EC 83 7D EC 00 74 1F 6A 01 8B 4D EC 8B 11 8B 02 89 45 E4 8B 4D E4 E8 ?? ?? ?? ?? 8B 4D EC FF 55 E4 89 45 DC EB 07 C7 45 DC 00 00 00 00 8B 4D F4 64 89 0D 00 00 00 00 59 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_3_126_1 {
	meta:
		name = "__ehhandler$??1locale@std@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1locale@std@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_93_35_1 {
	meta:
		name = "__ehhandler$??$make_shared@V__ExceptionPtr@@AAPAUEHExceptionRecord@@_N@std@@YA?AV?$shared_ptr@V__ExceptionPtr@@@0@AAPAUEHExceptionRecord@@$$QA_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$make_shared@V__ExceptionPtr@@AAPAUEHExceptionRecord@@_N@std@@YA?AV?$shared_ptr@V__ExceptionPtr@@@0@AAPAUEHExceptionRecord@@$$QA_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_102_19_1 {
	meta:
		name = "__ehhandler$??1_Fac_node@std@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1_Fac_node@std@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_93_85_1 {
	meta:
		name = "__ehhandler$?_CallCopyCtor@__ExceptionPtr@@ABEXPAX0IQBU_s_CatchableType@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_CallCopyCtor@__ExceptionPtr@@ABEXPAX0IQBU_s_CatchableType@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_102_59_1 {
	meta:
		name = "__ehhandler$?_Init@locale@std@@CAPAV_Locimp@12@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Init@locale@std@@CAPAV_Locimp@12@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_3_129_1 {
	meta:
		name = "??2_Crt_new_delete@std@@SAPAXI@Z"
		size = 42
		refs = "0005 ?nothrow@std@@3Unothrow_t@1@B 000e ??2_Crt_new_delete@std@@SAPAXIABUnothrow_t@1@@Z 001f ?_Xbad_alloc@std@@YAXXZ"
	strings:
		$1 = { 55 8B EC 51 68 ?? ?? ?? ?? 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 75 05 E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_3_130_1 {
	meta:
		name = "??2_Crt_new_delete@std@@SAPAXIABUnothrow_t@1@@Z"
		size = 50
		refs = "001c ??_C@_0CI@FIAODHFJ@f?3?2dd?2vctools?2crt?2crtw32?2stdhpp?2@ 0027 __malloc_dbg"
	strings:
		$1 = { 55 8B EC 51 83 7D 08 00 76 08 8B 45 08 89 45 FC EB 07 C7 45 FC 01 00 00 00 6A 4A 68 ?? ?? ?? ?? 6A 02 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 10 8B E5 5D C3 }
	condition:
		$1
}

rule file_3_132_1 {
	meta:
		name = "??4?$_Yarn@D@std@@QAEAAV01@PBD@Z"
		size = 146
		refs = "0017 ?_Tidy@?$_Yarn@D@std@@AAEXXZ 0054 ??_C@_0CJ@JJAOBJEO@f?3?2dd?2vctools?2crt?2crtw32?2stdhpp?2@ 005f __malloc_dbg 0082 _memcpy"
	strings:
		$1 = { 55 8B EC 83 EC 0C 89 4D F8 8B 45 F8 8B 08 3B 4D 08 74 76 8B 4D F8 E8 ?? ?? ?? ?? 83 7D 08 00 74 68 8B 55 08 89 55 FC 8B 45 FC 0F BE 08 85 C9 74 0B 8B 55 FC 83 C2 01 89 55 FC EB EB 8B 45 FC 83 C0 01 89 45 FC 8B 4D FC 2B 4D 08 89 4D F4 68 AB 0E 00 00 68 ?? ?? ?? ?? 6A 02 8B 55 F4 52 E8 ?? ?? ?? ?? 83 C4 10 8B 4D F8 89 01 8B 55 F8 83 3A 00 74 16 8B 45 F4 50 8B 4D 08 51 8B 55 F8 8B 02 50 E8 ?? ?? ?? ?? 83 C4 0C 8B 45 F8 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_3_133_1 {
	meta:
		name = "??4?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAAV01@ABV01@@Z"
		size = 102
		refs = "0013 ?_Getal@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QBEABU?$_Wrap_alloc@V?$allocator@D@std@@@2@XZ 001c ?_Getal@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAEAAU?$_Wrap_alloc@V?$allocator@D@std@@@2@XZ 0022 ??$?9V?$allocator@D@std@@V01@@std@@YA_NABU?$_Wrap_alloc@V?$allocator@D@std@@@0@0@Z 003c ?_Tidy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEX_NI@Z 004d ?_Copy_alloc@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAEXABU?$_Wrap_alloc@V?$allocator@D@std@@@2@@Z 0059 ?assign@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAAV12@ABV12@@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 3B 45 08 74 4E 8B 4D 08 E8 ?? ?? ?? ?? 50 8B 4D FC E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 08 0F B6 C8 85 C9 74 21 33 D2 74 1D 6A 00 6A 01 8B 4D FC E8 ?? ?? ?? ?? 8B 4D 08 E8 ?? ?? ?? ?? 50 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_29_464_1 {
	meta:
		name = "??4?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAEAAV01@ABV01@@Z"
		size = 102
		refs = "0013 ?_Getal@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QBEABU?$_Wrap_alloc@V?$allocator@G@std@@@2@XZ 001c ?_Getal@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAEAAU?$_Wrap_alloc@V?$allocator@G@std@@@2@XZ 0022 ??$?9V?$allocator@G@std@@V01@@std@@YA_NABU?$_Wrap_alloc@V?$allocator@G@std@@@0@0@Z 003c ?_Tidy@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAEX_NI@Z 004d ?_Copy_alloc@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAEXABU?$_Wrap_alloc@V?$allocator@G@std@@@2@@Z 0059 ?assign@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAEAAV12@ABV12@@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 3B 45 08 74 4E 8B 4D 08 E8 ?? ?? ?? ?? 50 8B 4D FC E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 08 0F B6 C8 85 C9 74 21 33 D2 74 1D 6A 00 6A 01 8B 4D FC E8 ?? ?? ?? ?? 8B 4D 08 E8 ?? ?? ?? ?? 50 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_29_467_1 {
	meta:
		name = "??4?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAEAAV01@ABV01@@Z"
		size = 102
		refs = "0013 ?_Getal@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QBEABU?$_Wrap_alloc@V?$allocator@_W@std@@@2@XZ 001c ?_Getal@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAEAAU?$_Wrap_alloc@V?$allocator@_W@std@@@2@XZ 0022 ??$?9V?$allocator@_W@std@@V01@@std@@YA_NABU?$_Wrap_alloc@V?$allocator@_W@std@@@0@0@Z 003c ?_Tidy@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAEX_NI@Z 004d ?_Copy_alloc@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAEXABU?$_Wrap_alloc@V?$allocator@_W@std@@@2@@Z 0059 ?assign@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAEAAV12@ABV12@@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 3B 45 08 74 4E 8B 4D 08 E8 ?? ?? ?? ?? 50 8B 4D FC E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 08 0F B6 C8 85 C9 74 21 33 D2 74 1D 6A 00 6A 01 8B 4D FC E8 ?? ?? ?? ?? 8B 4D 08 E8 ?? ?? ?? ?? 50 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_3_134_1 {
	meta:
		name = "??4?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@QAEAAV01@D@Z"
		size = 83
		refs = "001e ?sputc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@QAEHD@Z 0026 ?eof@?$char_traits@D@std@@SAHXZ 0036 ?eq_int_type@?$char_traits@D@std@@SA_NABH0@Z"
	strings:
		$1 = { 55 8B EC 83 EC 0C 89 4D FC 8B 45 FC 83 78 04 00 74 32 0F B6 4D 08 51 8B 55 FC 8B 4A 04 E8 ?? ?? ?? ?? 89 45 F8 E8 ?? ?? ?? ?? 89 45 F4 8D 45 F8 50 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 08 0F B6 D0 85 D2 74 06 8B 45 FC C6 00 01 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_3_135_1 {
	meta:
		name = "??A?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAADI@Z"
		size = 24
		refs = "000b ?_Myptr@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAEPADXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 03 45 08 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_3_136_1 {
	meta:
		name = "??A?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBEABDI@Z"
		size = 24
		refs = "000b ?_Myptr@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QBEPBDXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 03 45 08 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_3_137_1 {
	meta:
		name = "??Bid@locale@std@@QAEIXZ"
		size = 78
		refs = "0017 ??0_Lockit@std@@QAE@H@Z 0025 ?_Id_cnt@id@locale@std@@0HA 0041 ??1_Lockit@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D FC 8B 45 FC 83 38 00 75 34 6A 00 8D 4D F8 E8 ?? ?? ?? ?? 8B 4D FC 83 39 00 75 1A 8B 15 ?? ?? ?? ?? 83 C2 01 89 15 ?? ?? ?? ?? 8B 45 FC 8B 0D ?? ?? ?? ?? 89 08 8D 4D F8 E8 ?? ?? ?? ?? 8B 55 FC 8B 02 8B E5 5D C3 }
	condition:
		$1
}

rule file_3_138_1 {
	meta:
		name = "??D?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@QBEDXZ"
		size = 36
		refs = "0016 ?_Peek@?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@ABEDXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 0F B6 48 04 85 C9 75 08 8B 4D FC E8 ?? ?? ?? ?? 8B 55 FC 8A 42 05 8B E5 5D C3 }
	condition:
		$1
}

rule file_3_142_1 {
	meta:
		name = "??Y?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAAV01@ABV01@@Z"
		size = 25
		refs = "000f ?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAAV12@ABV12@@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_90_272_2 {
	meta:
		name = "??G?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QBEHABV?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@1@@Z"
		size = 25
		refs = "000f ??G?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QBEHABV01@@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_44_592_2 {
	meta:
		name = "??G?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QBEHABV?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@1@@Z"
		size = 25
		refs = "000f ??G?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QBEHABV01@@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_29_503_1 {
	meta:
		name = "??G?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QBEHABV?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@1@@Z"
		size = 25
		refs = "000f ??G?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QBEHABV01@@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_29_511_1 {
	meta:
		name = "??Y?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAEAAV01@ABV01@@Z"
		size = 25
		refs = "000f ?append@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAEAAV12@ABV12@@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_29_513_1 {
	meta:
		name = "??Y?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAEAAV01@ABV01@@Z"
		size = 25
		refs = "000f ?append@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAEAAV12@ABV12@@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_79_138_2 {
	meta:
		name = "?allocate@?$_Wrap_alloc@U?$_StaticAllocator@V?$_Ref_count_obj_alloc@V__ExceptionPtr@@U?$_StaticAllocator@H@@@std@@@@@std@@QAEPAV?$_Ref_count_obj_alloc@V__ExceptionPtr@@U?$_StaticAllocator@H@@@2@I@Z"
		size = 25
		refs = "000f ?allocate@?$_StaticAllocator@V?$_Ref_count_obj_alloc@V__ExceptionPtr@@U?$_StaticAllocator@H@@@std@@@@QBEPAV?$_Ref_count_obj_alloc@V__ExceptionPtr@@U?$_StaticAllocator@H@@@std@@I@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_48_316_2 {
	meta:
		name = "?allocate@?$_Wrap_alloc@V?$allocator@D@std@@@std@@QAEPADI@Z"
		size = 25
		refs = "000f ?allocate@?$allocator@D@std@@QAEPADI@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_10_1234_3 {
	meta:
		name = "?allocate@?$_Wrap_alloc@V?$allocator@G@std@@@std@@QAEPAGI@Z"
		size = 25
		refs = "000f ?allocate@?$allocator@G@std@@QAEPAGI@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_49_128_3 {
	meta:
		name = "?allocate@?$_Wrap_alloc@V?$allocator@U_Container_proxy@std@@@std@@@std@@QAEPAU_Container_proxy@2@I@Z"
		size = 25
		refs = "000f ?allocate@?$allocator@U_Container_proxy@std@@@std@@QAEPAU_Container_proxy@2@I@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_29_1032_1 {
	meta:
		name = "?allocate@?$_Wrap_alloc@V?$allocator@_W@std@@@std@@QAEPA_WI@Z"
		size = 25
		refs = "000f ?allocate@?$allocator@_W@std@@QAEPA_WI@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_94_142_3 {
	meta:
		name = "?swap@?$shared_ptr@V__ExceptionPtr@@@std@@QAEXAAV12@@Z"
		size = 25
		refs = "000f ?_Swap@?$_Ptr_base@V__ExceptionPtr@@@std@@QAEXAAV12@@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_3_143_1 {
	meta:
		name = "??Y?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAAV01@D@Z"
		size = 28
		refs = "0012 ?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAAV12@ID@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 0F B6 45 08 50 6A 01 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_3_144_1 {
	meta:
		name = "??_G?$codecvt@DDU_Mbstatet@@@std@@MAEPAXI@Z"
		size = 68
		refs = "000b ??1?$codecvt@DDU_Mbstatet@@@std@@MAE@XZ 0024 ??3_Crt_new_delete@std@@SAXPAX@Z 0034 ?__global_delete@@YAXPAXI@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 24 8B 4D 08 83 E1 04 75 0E 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 04 EB 0E 6A 08 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 08 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_80_231_1 {
	meta:
		name = "??_G?$messages@D@std@@MAEPAXI@Z"
		size = 68
		refs = "000b ??1?$messages@D@std@@MAE@XZ 0024 ??3_Crt_new_delete@std@@SAXPAX@Z 0034 ?__global_delete@@YAXPAXI@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 24 8B 4D 08 83 E1 04 75 0E 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 04 EB 0E 6A 08 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 08 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_10_671_3 {
	meta:
		name = "??_G?$messages@G@std@@MAEPAXI@Z"
		size = 68
		refs = "000b ??1?$messages@G@std@@MAE@XZ 0024 ??3_Crt_new_delete@std@@SAXPAX@Z 0034 ?__global_delete@@YAXPAXI@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 24 8B 4D 08 83 E1 04 75 0E 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 04 EB 0E 6A 08 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 08 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_44_623_2 {
	meta:
		name = "??_G?$messages@_W@std@@MAEPAXI@Z"
		size = 68
		refs = "000b ??1?$messages@_W@std@@MAE@XZ 0024 ??3_Crt_new_delete@std@@SAXPAX@Z 0034 ?__global_delete@@YAXPAXI@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 24 8B 4D 08 83 E1 04 75 0E 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 04 EB 0E 6A 08 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 08 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_80_232_1 {
	meta:
		name = "??_G?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAEPAXI@Z"
		size = 68
		refs = "000b ??1?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAE@XZ 0024 ??3_Crt_new_delete@std@@SAXPAX@Z 0034 ?__global_delete@@YAXPAXI@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 24 8B 4D 08 83 E1 04 75 0E 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 04 EB 0E 6A 08 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 08 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_44_624_2 {
	meta:
		name = "??_G?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAEPAXI@Z"
		size = 68
		refs = "000b ??1?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAE@XZ 0024 ??3_Crt_new_delete@std@@SAXPAX@Z 0034 ?__global_delete@@YAXPAXI@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 24 8B 4D 08 83 E1 04 75 0E 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 04 EB 0E 6A 08 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 08 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_29_528_1 {
	meta:
		name = "??_G?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAEPAXI@Z"
		size = 68
		refs = "000b ??1?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAE@XZ 0024 ??3_Crt_new_delete@std@@SAXPAX@Z 0034 ?__global_delete@@YAXPAXI@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 24 8B 4D 08 83 E1 04 75 0E 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 04 EB 0E 6A 08 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 08 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_80_233_1 {
	meta:
		name = "??_G?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAEPAXI@Z"
		size = 68
		refs = "000b ??1?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAE@XZ 0024 ??3_Crt_new_delete@std@@SAXPAX@Z 0034 ?__global_delete@@YAXPAXI@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 24 8B 4D 08 83 E1 04 75 0E 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 04 EB 0E 6A 08 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 08 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_10_675_3 {
	meta:
		name = "??_G?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAEPAXI@Z"
		size = 68
		refs = "000b ??1?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAE@XZ 0024 ??3_Crt_new_delete@std@@SAXPAX@Z 0034 ?__global_delete@@YAXPAXI@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 24 8B 4D 08 83 E1 04 75 0E 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 04 EB 0E 6A 08 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 08 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_29_530_1 {
	meta:
		name = "??_G?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAEPAXI@Z"
		size = 68
		refs = "000b ??1?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAE@XZ 0024 ??3_Crt_new_delete@std@@SAXPAX@Z 0034 ?__global_delete@@YAXPAXI@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 24 8B 4D 08 83 E1 04 75 0E 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 04 EB 0E 6A 08 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 08 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_110_167_2 {
	meta:
		name = "??_G?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAEPAXI@Z"
		size = 68
		refs = "000b ??1?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAE@XZ 0024 ??3_Crt_new_delete@std@@SAXPAX@Z 0034 ?__global_delete@@YAXPAXI@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 24 8B 4D 08 83 E1 04 75 0E 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 04 EB 0E 6A 08 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 08 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_29_535_1 {
	meta:
		name = "??_G?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAEPAXI@Z"
		size = 68
		refs = "000b ??1?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAE@XZ 0024 ??3_Crt_new_delete@std@@SAXPAX@Z 0034 ?__global_delete@@YAXPAXI@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 24 8B 4D 08 83 E1 04 75 0E 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 04 EB 0E 6A 08 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 08 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_29_536_1 {
	meta:
		name = "??_G?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAEPAXI@Z"
		size = 68
		refs = "000b ??1?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAE@XZ 0024 ??3_Crt_new_delete@std@@SAXPAX@Z 0034 ?__global_delete@@YAXPAXI@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 24 8B 4D 08 83 E1 04 75 0E 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 04 EB 0E 6A 08 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 08 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_3_147_1 {
	meta:
		name = "??_G?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAEPAXI@Z"
		size = 68
		refs = "000b ??1?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAE@XZ 0024 ??3_Crt_new_delete@std@@SAXPAX@Z 0034 ?__global_delete@@YAXPAXI@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 24 8B 4D 08 83 E1 04 75 0E 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 04 EB 0E 6A 08 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 08 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_10_683_3 {
	meta:
		name = "??_G?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAEPAXI@Z"
		size = 68
		refs = "000b ??1?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAE@XZ 0024 ??3_Crt_new_delete@std@@SAXPAX@Z 0034 ?__global_delete@@YAXPAXI@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 24 8B 4D 08 83 E1 04 75 0E 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 04 EB 0E 6A 08 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 08 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_10_684_3 {
	meta:
		name = "??_G?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAEPAXI@Z"
		size = 68
		refs = "000b ??1?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAE@XZ 0024 ??3_Crt_new_delete@std@@SAXPAX@Z 0034 ?__global_delete@@YAXPAXI@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 24 8B 4D 08 83 E1 04 75 0E 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 04 EB 0E 6A 08 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 08 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_170_6_6 {
	meta:
		name = "??_G_Fac_node@std@@QAEPAXI@Z"
		size = 68
		refs = "000b ??1_Fac_node@std@@QAE@XZ 0024 ??3_Fac_node@std@@SAXPAX@Z 0034 ?__global_delete@@YAXPAXI@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 24 8B 4D 08 83 E1 04 75 0E 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 04 EB 0E 6A 08 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 08 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_10_207_2 {
	meta:
		name = "??_Gcodecvt_base@std@@UAEPAXI@Z"
		size = 68
		refs = "000b ??1codecvt_base@std@@UAE@XZ 0024 ??3_Crt_new_delete@std@@SAXPAX@Z 0034 ?__global_delete@@YAXPAXI@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 24 8B 4D 08 83 E1 04 75 0E 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 04 EB 0E 6A 08 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 08 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_67_218_3 {
	meta:
		name = "??_Gctype_base@std@@UAEPAXI@Z"
		size = 68
		refs = "000b ??1ctype_base@std@@UAE@XZ 0024 ??3_Crt_new_delete@std@@SAXPAX@Z 0034 ?__global_delete@@YAXPAXI@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 24 8B 4D 08 83 E1 04 75 0E 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 04 EB 0E 6A 08 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 08 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_10_696_3 {
	meta:
		name = "??_Gfacet@locale@std@@MAEPAXI@Z"
		size = 68
		refs = "000b ??1facet@locale@std@@MAE@XZ 0024 ??3_Crt_new_delete@std@@SAXPAX@Z 0034 ?__global_delete@@YAXPAXI@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 24 8B 4D 08 83 E1 04 75 0E 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 04 EB 0E 6A 08 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 08 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_69_235_3 {
	meta:
		name = "??_Glocale@std@@QAEPAXI@Z"
		size = 68
		refs = "000b ??1locale@std@@QAE@XZ 0024 ??3_Crt_new_delete@std@@SAXPAX@Z 0034 ?__global_delete@@YAXPAXI@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 24 8B 4D 08 83 E1 04 75 0E 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 04 EB 0E 6A 08 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 08 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_90_295_2 {
	meta:
		name = "??_Gmessages_base@std@@UAEPAXI@Z"
		size = 68
		refs = "000b ??1messages_base@std@@UAE@XZ 0024 ??3_Crt_new_delete@std@@SAXPAX@Z 0034 ?__global_delete@@YAXPAXI@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 24 8B 4D 08 83 E1 04 75 0E 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 04 EB 0E 6A 08 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 08 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_100_313_3 {
	meta:
		name = "??_Gmoney_base@std@@UAEPAXI@Z"
		size = 68
		refs = "000b ??1money_base@std@@UAE@XZ 0024 ??3_Crt_new_delete@std@@SAXPAX@Z 0034 ?__global_delete@@YAXPAXI@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 24 8B 4D 08 83 E1 04 75 0E 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 04 EB 0E 6A 08 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 08 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_100_315_3 {
	meta:
		name = "??_Gtime_base@std@@UAEPAXI@Z"
		size = 68
		refs = "000b ??1time_base@std@@UAE@XZ 0024 ??3_Crt_new_delete@std@@SAXPAX@Z 0034 ?__global_delete@@YAXPAXI@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 24 8B 4D 08 83 E1 04 75 0E 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 04 EB 0E 6A 08 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 08 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_3_145_1 {
	meta:
		name = "??_G?$ctype@D@std@@MAEPAXI@Z"
		size = 68
		refs = "000b ??1?$ctype@D@std@@MAE@XZ 0024 ??3_Crt_new_delete@std@@SAXPAX@Z 0034 ?__global_delete@@YAXPAXI@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 24 8B 4D 08 83 E1 04 75 0E 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 04 EB 0E 6A 18 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 08 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_3_148_1 {
	meta:
		name = "??_G?$numpunct@D@std@@MAEPAXI@Z"
		size = 68
		refs = "000b ??1?$numpunct@D@std@@MAE@XZ 0024 ??3_Crt_new_delete@std@@SAXPAX@Z 0034 ?__global_delete@@YAXPAXI@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 24 8B 4D 08 83 E1 04 75 0E 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 04 EB 0E 6A 18 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 08 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_29_539_1 {
	meta:
		name = "??_G?$numpunct@G@std@@MAEPAXI@Z"
		size = 68
		refs = "000b ??1?$numpunct@G@std@@MAE@XZ 0024 ??3_Crt_new_delete@std@@SAXPAX@Z 0034 ?__global_delete@@YAXPAXI@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 24 8B 4D 08 83 E1 04 75 0E 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 04 EB 0E 6A 18 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 08 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_29_540_1 {
	meta:
		name = "??_G?$numpunct@_W@std@@MAEPAXI@Z"
		size = 68
		refs = "000b ??1?$numpunct@_W@std@@MAE@XZ 0024 ??3_Crt_new_delete@std@@SAXPAX@Z 0034 ?__global_delete@@YAXPAXI@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 24 8B 4D 08 83 E1 04 75 0E 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 04 EB 0E 6A 18 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 08 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_3_149_1 {
	meta:
		name = "??_G_Facet_base@std@@UAEPAXI@Z"
		size = 46
		refs = "000b ??1_Facet_base@std@@UAE@XZ 001e ??3@YAXPAXI@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0E 6A 04 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 08 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_3_156_1 {
	meta:
		name = "??__E?id@?$codecvt@DDU_Mbstatet@@@std@@2V0locale@2@A@@YAXXZ"
		size = 17
		refs = "0006 ?id@?$codecvt@DDU_Mbstatet@@@std@@2V0locale@2@A 000b ??0id@locale@std@@QAE@I@Z"
	strings:
		$1 = { 55 8B EC 6A 00 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_17_39_2 {
	meta:
		name = "??__E?id@?$codecvt@GDU_Mbstatet@@@std@@2V0locale@2@A@@YAXXZ"
		size = 17
		refs = "0006 ?id@?$codecvt@GDU_Mbstatet@@@std@@2V0locale@2@A 000b ??0id@locale@std@@QAE@I@Z"
	strings:
		$1 = { 55 8B EC 6A 00 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_17_40_2 {
	meta:
		name = "??__E?id@?$codecvt@_WDU_Mbstatet@@@std@@2V0locale@2@A@@YAXXZ"
		size = 17
		refs = "0006 ?id@?$codecvt@_WDU_Mbstatet@@@std@@2V0locale@2@A 000b ??0id@locale@std@@QAE@I@Z"
	strings:
		$1 = { 55 8B EC 6A 00 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_80_247_1 {
	meta:
		name = "??__E?id@?$collate@D@std@@2V0locale@2@A@@YAXXZ"
		size = 17
		refs = "0006 ?id@?$collate@D@std@@2V0locale@2@A 000b ??0id@locale@std@@QAE@I@Z"
	strings:
		$1 = { 55 8B EC 6A 00 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_10_701_3 {
	meta:
		name = "??__E?id@?$collate@G@std@@2V0locale@2@A@@YAXXZ"
		size = 17
		refs = "0006 ?id@?$collate@G@std@@2V0locale@2@A 000b ??0id@locale@std@@QAE@I@Z"
	strings:
		$1 = { 55 8B EC 6A 00 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_10_702_3 {
	meta:
		name = "??__E?id@?$collate@_W@std@@2V0locale@2@A@@YAXXZ"
		size = 17
		refs = "0006 ?id@?$collate@_W@std@@2V0locale@2@A 000b ??0id@locale@std@@QAE@I@Z"
	strings:
		$1 = { 55 8B EC 6A 00 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_38_41_3 {
	meta:
		name = "??__E?id@?$ctype@D@std@@2V0locale@2@A@@YAXXZ"
		size = 17
		refs = "0006 ?id@?$ctype@D@std@@2V0locale@2@A 000b ??0id@locale@std@@QAE@I@Z"
	strings:
		$1 = { 55 8B EC 6A 00 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_38_42_3 {
	meta:
		name = "??__E?id@?$ctype@G@std@@2V0locale@2@A@@YAXXZ"
		size = 17
		refs = "0006 ?id@?$ctype@G@std@@2V0locale@2@A 000b ??0id@locale@std@@QAE@I@Z"
	strings:
		$1 = { 55 8B EC 6A 00 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_102_43_1 {
	meta:
		name = "??__E?id@?$ctype@_W@std@@2V0locale@2@A@@YAXXZ"
		size = 17
		refs = "0006 ?id@?$ctype@_W@std@@2V0locale@2@A 000b ??0id@locale@std@@QAE@I@Z"
	strings:
		$1 = { 55 8B EC 6A 00 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_80_248_1 {
	meta:
		name = "??__E?id@?$messages@D@std@@2V0locale@2@A@@YAXXZ"
		size = 17
		refs = "0006 ?id@?$messages@D@std@@2V0locale@2@A 000b ??0id@locale@std@@QAE@I@Z"
	strings:
		$1 = { 55 8B EC 6A 00 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_10_703_3 {
	meta:
		name = "??__E?id@?$messages@G@std@@2V0locale@2@A@@YAXXZ"
		size = 17
		refs = "0006 ?id@?$messages@G@std@@2V0locale@2@A 000b ??0id@locale@std@@QAE@I@Z"
	strings:
		$1 = { 55 8B EC 6A 00 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_10_704_3 {
	meta:
		name = "??__E?id@?$messages@_W@std@@2V0locale@2@A@@YAXXZ"
		size = 17
		refs = "0006 ?id@?$messages@_W@std@@2V0locale@2@A 000b ??0id@locale@std@@QAE@I@Z"
	strings:
		$1 = { 55 8B EC 6A 00 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_80_249_1 {
	meta:
		name = "??__E?id@?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@2V0locale@2@A@@YAXXZ"
		size = 17
		refs = "0006 ?id@?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@2V0locale@2@A 000b ??0id@locale@std@@QAE@I@Z"
	strings:
		$1 = { 55 8B EC 6A 00 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_44_656_2 {
	meta:
		name = "??__E?id@?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@2V0locale@2@A@@YAXXZ"
		size = 17
		refs = "0006 ?id@?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@2V0locale@2@A 000b ??0id@locale@std@@QAE@I@Z"
	strings:
		$1 = { 55 8B EC 6A 00 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_10_706_3 {
	meta:
		name = "??__E?id@?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@2V0locale@2@A@@YAXXZ"
		size = 17
		refs = "0006 ?id@?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@2V0locale@2@A 000b ??0id@locale@std@@QAE@I@Z"
	strings:
		$1 = { 55 8B EC 6A 00 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_80_250_1 {
	meta:
		name = "??__E?id@?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@2V0locale@2@A@@YAXXZ"
		size = 17
		refs = "0006 ?id@?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@2V0locale@2@A 000b ??0id@locale@std@@QAE@I@Z"
	strings:
		$1 = { 55 8B EC 6A 00 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_44_658_2 {
	meta:
		name = "??__E?id@?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@2V0locale@2@A@@YAXXZ"
		size = 17
		refs = "0006 ?id@?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@2V0locale@2@A 000b ??0id@locale@std@@QAE@I@Z"
	strings:
		$1 = { 55 8B EC 6A 00 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_10_708_3 {
	meta:
		name = "??__E?id@?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@2V0locale@2@A@@YAXXZ"
		size = 17
		refs = "0006 ?id@?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@2V0locale@2@A 000b ??0id@locale@std@@QAE@I@Z"
	strings:
		$1 = { 55 8B EC 6A 00 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_80_251_1 {
	meta:
		name = "??__E?id@?$moneypunct@D$00@std@@2V0locale@2@A@@YAXXZ"
		size = 17
		refs = "0006 ?id@?$moneypunct@D$00@std@@2V0locale@2@A 000b ??0id@locale@std@@QAE@I@Z"
	strings:
		$1 = { 55 8B EC 6A 00 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_100_321_3 {
	meta:
		name = "??__E?id@?$moneypunct@D$0A@@std@@2V0locale@2@A@@YAXXZ"
		size = 17
		refs = "0006 ?id@?$moneypunct@D$0A@@std@@2V0locale@2@A 000b ??0id@locale@std@@QAE@I@Z"
	strings:
		$1 = { 55 8B EC 6A 00 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_10_709_3 {
	meta:
		name = "??__E?id@?$moneypunct@G$00@std@@2V0locale@2@A@@YAXXZ"
		size = 17
		refs = "0006 ?id@?$moneypunct@G$00@std@@2V0locale@2@A 000b ??0id@locale@std@@QAE@I@Z"
	strings:
		$1 = { 55 8B EC 6A 00 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_10_710_3 {
	meta:
		name = "??__E?id@?$moneypunct@G$0A@@std@@2V0locale@2@A@@YAXXZ"
		size = 17
		refs = "0006 ?id@?$moneypunct@G$0A@@std@@2V0locale@2@A 000b ??0id@locale@std@@QAE@I@Z"
	strings:
		$1 = { 55 8B EC 6A 00 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_44_662_2 {
	meta:
		name = "??__E?id@?$moneypunct@_W$00@std@@2V0locale@2@A@@YAXXZ"
		size = 17
		refs = "0006 ?id@?$moneypunct@_W$00@std@@2V0locale@2@A 000b ??0id@locale@std@@QAE@I@Z"
	strings:
		$1 = { 55 8B EC 6A 00 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_10_712_3 {
	meta:
		name = "??__E?id@?$moneypunct@_W$0A@@std@@2V0locale@2@A@@YAXXZ"
		size = 17
		refs = "0006 ?id@?$moneypunct@_W$0A@@std@@2V0locale@2@A 000b ??0id@locale@std@@QAE@I@Z"
	strings:
		$1 = { 55 8B EC 6A 00 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_110_178_2 {
	meta:
		name = "??__E?id@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@2V0locale@2@A@@YAXXZ"
		size = 17
		refs = "0006 ?id@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@2V0locale@2@A 000b ??0id@locale@std@@QAE@I@Z"
	strings:
		$1 = { 55 8B EC 6A 00 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_44_664_2 {
	meta:
		name = "??__E?id@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@2V0locale@2@A@@YAXXZ"
		size = 17
		refs = "0006 ?id@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@2V0locale@2@A 000b ??0id@locale@std@@QAE@I@Z"
	strings:
		$1 = { 55 8B EC 6A 00 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_29_568_1 {
	meta:
		name = "??__E?id@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@2V0locale@2@A@@YAXXZ"
		size = 17
		refs = "0006 ?id@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@2V0locale@2@A 000b ??0id@locale@std@@QAE@I@Z"
	strings:
		$1 = { 55 8B EC 6A 00 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_110_179_2 {
	meta:
		name = "??__E?id@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@2V0locale@2@A@@YAXXZ"
		size = 17
		refs = "0006 ?id@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@2V0locale@2@A 000b ??0id@locale@std@@QAE@I@Z"
	strings:
		$1 = { 55 8B EC 6A 00 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_10_715_3 {
	meta:
		name = "??__E?id@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@2V0locale@2@A@@YAXXZ"
		size = 17
		refs = "0006 ?id@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@2V0locale@2@A 000b ??0id@locale@std@@QAE@I@Z"
	strings:
		$1 = { 55 8B EC 6A 00 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_44_667_2 {
	meta:
		name = "??__E?id@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@2V0locale@2@A@@YAXXZ"
		size = 17
		refs = "0006 ?id@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@2V0locale@2@A 000b ??0id@locale@std@@QAE@I@Z"
	strings:
		$1 = { 55 8B EC 6A 00 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_110_180_2 {
	meta:
		name = "??__E?id@?$numpunct@D@std@@2V0locale@2@A@@YAXXZ"
		size = 17
		refs = "0006 ?id@?$numpunct@D@std@@2V0locale@2@A 000b ??0id@locale@std@@QAE@I@Z"
	strings:
		$1 = { 55 8B EC 6A 00 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_10_717_3 {
	meta:
		name = "??__E?id@?$numpunct@G@std@@2V0locale@2@A@@YAXXZ"
		size = 17
		refs = "0006 ?id@?$numpunct@G@std@@2V0locale@2@A 000b ??0id@locale@std@@QAE@I@Z"
	strings:
		$1 = { 55 8B EC 6A 00 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_44_669_2 {
	meta:
		name = "??__E?id@?$numpunct@_W@std@@2V0locale@2@A@@YAXXZ"
		size = 17
		refs = "0006 ?id@?$numpunct@_W@std@@2V0locale@2@A 000b ??0id@locale@std@@QAE@I@Z"
	strings:
		$1 = { 55 8B EC 6A 00 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_100_322_3 {
	meta:
		name = "??__E?id@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@2V0locale@2@A@@YAXXZ"
		size = 17
		refs = "0006 ?id@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@2V0locale@2@A 000b ??0id@locale@std@@QAE@I@Z"
	strings:
		$1 = { 55 8B EC 6A 00 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_44_670_2 {
	meta:
		name = "??__E?id@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@2V0locale@2@A@@YAXXZ"
		size = 17
		refs = "0006 ?id@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@2V0locale@2@A 000b ??0id@locale@std@@QAE@I@Z"
	strings:
		$1 = { 55 8B EC 6A 00 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_10_720_3 {
	meta:
		name = "??__E?id@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@2V0locale@2@A@@YAXXZ"
		size = 17
		refs = "0006 ?id@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@2V0locale@2@A 000b ??0id@locale@std@@QAE@I@Z"
	strings:
		$1 = { 55 8B EC 6A 00 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_100_323_3 {
	meta:
		name = "??__E?id@?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@2V0locale@2@A@@YAXXZ"
		size = 17
		refs = "0006 ?id@?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@2V0locale@2@A 000b ??0id@locale@std@@QAE@I@Z"
	strings:
		$1 = { 55 8B EC 6A 00 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_29_575_1 {
	meta:
		name = "??__E?id@?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@2V0locale@2@A@@YAXXZ"
		size = 17
		refs = "0006 ?id@?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@2V0locale@2@A 000b ??0id@locale@std@@QAE@I@Z"
	strings:
		$1 = { 55 8B EC 6A 00 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_29_576_1 {
	meta:
		name = "??__E?id@?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@2V0locale@2@A@@YAXXZ"
		size = 17
		refs = "0006 ?id@?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@2V0locale@2@A 000b ??0id@locale@std@@QAE@I@Z"
	strings:
		$1 = { 55 8B EC 6A 00 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_3_160_1 {
	meta:
		name = "?_Addfac@_Locimp@locale@std@@AAEXPAVfacet@23@I@Z"
		size = 33
		refs = "0014 ?_Locimp_Addfac@_Locimp@locale@std@@CAXPAV123@PAVfacet@23@I@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 0C 50 8B 4D 08 51 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_3_161_1 {
	meta:
		name = "?_Allocate@std@@YAPAXII_N@Z"
		size = 350
		refs = "0029 ?_Xbad_alloc@std@@YAXXZ 006b ??2@YAPAXI@Z 007c ??_C@_0BE@LMNLACIC@_Ptr_container?5?$CB?$DN?50?$AA@ 0089 ??_C@_1DG@HGDKEBPG@?$AA?$CC?$AA_?$AAP?$AAt?$AAr?$AA_?$AAc?$AAo?$AAn?$AAt?$AAa?$AAi?$AAn?$AAe?$AAr?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA0?$AA?$CC?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA0?$AA?$AA@ 008e ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0097 ??_C@_1FC@CNLMDHOG@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAs?$AAt?$AAd?$AAh?$AAp?$AAp?$AA?2@ 009e __CrtDbgReportW 00b5 ??_C@_1BO@NKFMJPA@?$AAs?$AAt?$AAd?$AA?3?$AA?3?$AA_?$AAA?$AAl?$AAl?$AAo?$AAc?$AAa?$AAt?$AAe?$AA?$AA@ 00ba ??_C@_1CG@JNLFBNGN@?$AA?$CC?$AAi?$AAn?$AAv?$AAa?$AAl?$AAi?$AAd?$AA?5?$AAa?$AAr?$AAg?$AAu?$AAm?$AAe?$AAn?$AAt?$AA?$CC?$AA?$AA@ 00bf __invalid_parameter 010d ??_C@_09GLJCAGLP@_Ptr?5?$CB?$DN?50?$AA@ 011a ??_C@_1CC@GKJLLHIM@?$AA?$CC?$AA_?$AAP?$AAt?$AAr?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA0?$AA?$CC?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA0?$AA?$AA@"
	strings:
		$1 = { 55 8B EC 83 EC 10 C7 45 FC 00 00 00 00 83 7D 08 00 75 08 8B 45 FC E9 3F 01 00 00 83 C8 FF 33 D2 F7 75 0C 3B 45 08 73 05 E8 ?? ?? ?? ?? 8B 45 08 0F AF 45 0C 89 45 F8 0F B6 4D 10 85 C9 0F 84 B4 00 00 00 81 7D F8 00 10 00 00 0F 82 A7 00 00 00 8B 55 F8 83 C2 27 89 55 F0 8B 45 F0 3B 45 F8 77 05 E8 ?? ?? ?? ?? 8B 4D F0 51 E8 ?? ?? ?? ?? 83 C4 04 89 45 F4 83 7D F4 00 75 4B BA ?? ?? ?? ?? 85 D2 74 04 33 C0 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 46 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 6A 00 6A 46 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 8B 55 F4 83 C2 27 83 E2 E0 89 55 FC B8 04 00 00 00 6B C8 FF 8B 55 FC 8B 45 F4 89 04 0A B9 04 00 00 00 6B D1 FE 8B 45 FC C7 04 10 FA FA FA FA EB 60 8B 4D F8 51 E8 ?? ?? ?? ?? 83 C4 04 89 45 FC 83 7D FC 00 75 4B BA ?? ?? ?? ?? 85 D2 74 04 33 C0 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 54 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 6A 00 6A 54 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_3_162_1 {
	meta:
		name = "?_Assign_rv@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEX$$QAV12@@Z"
		size = 182
		refs = "000c ?_Myres@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAEAAIXZ 0019 ?_Mysize@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAEAAIXZ 0027 ?_Bx@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAEAAT_Bxty@?$_String_val@U?$_Simple_types@D@std@@@2@XZ 0036 ?move@?$char_traits@D@std@@SAPADPADPBDI@Z 0052 ??$addressof@PAD@std@@YAPAPADAAPAD@Z 005e ?_Getal@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAEAAU?$_Wrap_alloc@V?$allocator@D@std@@@2@XZ 0065 ??$construct@PADAAPAD@?$_Wrap_alloc@V?$allocator@D@std@@@std@@QAEXPAPADAAPAD@Z 00ab ?_Tidy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEX_NI@Z"
	strings:
		$1 = { 55 8B EC 51 56 89 4D FC 8B 4D 08 E8 ?? ?? ?? ?? 83 38 10 73 2A 8B 4D 08 E8 ?? ?? ?? ?? 8B 00 83 C0 01 50 8B 4D 08 E8 ?? ?? ?? ?? 50 8B 4D FC E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 0C EB 38 8B 4D 08 E8 ?? ?? ?? ?? 50 8B 4D FC E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 50 8B 4D FC E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 4D 08 E8 ?? ?? ?? ?? C7 00 00 00 00 00 8B 4D 08 E8 ?? ?? ?? ?? 8B F0 8B 4D FC E8 ?? ?? ?? ?? 8B 0E 89 08 8B 4D 08 E8 ?? ?? ?? ?? 8B F0 8B 4D FC E8 ?? ?? ?? ?? 8B 16 89 10 6A 00 6A 00 8B 4D 08 E8 ?? ?? ?? ?? 5E 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_3_164_1 {
	meta:
		name = "?_C_str@?$_Yarn@D@std@@QBEPBDXZ"
		size = 43
		altNames = "?_C_str@?$_Yarn@_W@std@@QBEPB_WXZ ?c_str@?$_Yarn@D@std@@QBEPBDXZ"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D FC 8B 45 FC 83 38 00 74 0A 8B 4D FC 8B 11 89 55 F8 EB 09 8B 45 FC 83 C0 04 89 45 F8 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_3_165_1 {
	meta:
		name = "?_Chassign@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEXIID@Z"
		size = 74
		refs = "0015 ?_Myptr@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAEPADXZ 001e ?assign@?$char_traits@D@std@@SAXAADABD@Z 003d ?assign@?$char_traits@D@std@@SAPADPADID@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 83 7D 0C 01 75 1A 8D 45 10 50 8B 4D FC E8 ?? ?? ?? ?? 03 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 EB 1D 0F B6 4D 10 51 8B 55 0C 52 8B 4D FC E8 ?? ?? ?? ?? 03 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule file_3_166_1 {
	meta:
		name = "?_Check_offset@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBEXI@Z"
		size = 36
		refs = "000b ?_Mysize@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QBEABIXZ 001a ?_Xran@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 00 3B 45 08 73 08 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_29_592_1 {
	meta:
		name = "?_Check_offset@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QBEXI@Z"
		size = 36
		refs = "000b ?_Mysize@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QBEABIXZ 001a ?_Xran@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QBEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 00 3B 45 08 73 08 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_29_593_1 {
	meta:
		name = "?_Check_offset@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QBEXI@Z"
		size = 36
		refs = "000b ?_Mysize@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QBEABIXZ 001a ?_Xran@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QBEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 00 3B 45 08 73 08 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_3_167_1 {
	meta:
		name = "?_Clamp_suffix_size@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBEIII@Z"
		size = 49
		refs = "000d ?_Mysize@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QBEABIXZ"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D F8 8B 4D F8 E8 ?? ?? ?? ?? 8B 00 2B 45 08 89 45 FC 8B 4D 0C 3B 4D FC 77 07 8B 45 0C EB 05 EB 03 8B 45 FC 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_29_595_1 {
	meta:
		name = "?_Clamp_suffix_size@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QBEIII@Z"
		size = 49
		refs = "000d ?_Mysize@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QBEABIXZ"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D F8 8B 4D F8 E8 ?? ?? ?? ?? 8B 00 2B 45 08 89 45 FC 8B 4D 0C 3B 4D FC 77 07 8B 45 0C EB 05 EB 03 8B 45 FC 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_29_596_1 {
	meta:
		name = "?_Clamp_suffix_size@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QBEIII@Z"
		size = 49
		refs = "000d ?_Mysize@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QBEABIXZ"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D F8 8B 4D F8 E8 ?? ?? ?? ?? 8B 00 2B 45 08 89 45 FC 8B 4D 0C 3B 4D FC 77 07 8B 45 0C EB 05 EB 03 8B 45 FC 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_3_168_1 {
	meta:
		name = "?_Copy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEXII@Z"
		size = 223
		refs = "0006 __ehhandler$?_Copy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEXII@Z 0019 ___security_cookie 003c ?max_size@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBEIXZ 005f ?_Myres@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAEAAIXZ 00c9 ?_Getal@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAEAAU?$_Wrap_alloc@V?$allocator@D@std@@@2@XZ 00d0 ?allocate@?$_Wrap_alloc@V?$allocator@D@std@@@std@@QAEPADI@Z"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 51 83 EC 14 53 56 57 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 65 F0 89 4D EC 8B 45 08 83 C8 0F 89 45 E8 8B 4D EC E8 ?? ?? ?? ?? 3B 45 E8 73 08 8B 4D 08 89 4D E8 EB 6A 8B 45 E8 33 D2 B9 03 00 00 00 F7 F1 8B F0 8B 4D EC E8 ?? ?? ?? ?? 8B 10 D1 EA 3B D6 77 02 EB 4A 8B 4D EC E8 ?? ?? ?? ?? 8B 30 D1 EE 8B 4D EC E8 ?? ?? ?? ?? 8B F8 2B FE 8B 4D EC E8 ?? ?? ?? ?? 39 38 77 1B 8B 4D EC E8 ?? ?? ?? ?? 8B 30 D1 EE 8B 4D EC E8 ?? ?? ?? ?? 03 30 89 75 E8 EB 0B 8B 4D EC E8 ?? ?? ?? ?? 89 45 E8 C7 45 FC 00 00 00 00 8B 45 E8 83 C0 01 50 8B 4D EC E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 89 45 E0 8B 4D E0 89 4D E4 EB 5F }
	condition:
		$1
}

rule file_3_169_1 {
	meta:
		name = "__catch$?_Copy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEXII@Z$0"
		size = 46
		refs = "0018 ?_Getal@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAEAAU?$_Wrap_alloc@V?$allocator@D@std@@@2@XZ 001f ?allocate@?$_Wrap_alloc@V?$allocator@D@std@@@std@@QAEPADI@Z"
	strings:
		$1 = { 89 65 F0 8B 55 08 89 55 E8 C6 45 FC 02 8B 45 E8 83 C0 01 50 8B 4D EC E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 89 45 DC 8B 4D DC 89 4D E4 EB 1B }
	condition:
		$1
}

rule file_29_604_1 {
	meta:
		name = "__catch$?_Copy@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAEXII@Z$0"
		size = 46
		refs = "0018 ?_Getal@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAEAAU?$_Wrap_alloc@V?$allocator@G@std@@@2@XZ 001f ?allocate@?$_Wrap_alloc@V?$allocator@G@std@@@std@@QAEPAGI@Z"
	strings:
		$1 = { 89 65 F0 8B 55 08 89 55 E8 C6 45 FC 02 8B 45 E8 83 C0 01 50 8B 4D EC E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 89 45 DC 8B 4D DC 89 4D E4 EB 1B }
	condition:
		$1
}

rule file_29_608_1 {
	meta:
		name = "__catch$?_Copy@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAEXII@Z$0"
		size = 46
		refs = "0018 ?_Getal@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAEAAU?$_Wrap_alloc@V?$allocator@_W@std@@@2@XZ 001f ?allocate@?$_Wrap_alloc@V?$allocator@_W@std@@@std@@QAEPA_WI@Z"
	strings:
		$1 = { 89 65 F0 8B 55 08 89 55 E8 C6 45 FC 02 8B 45 E8 83 C0 01 50 8B 4D EC E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 89 45 DC 8B 4D DC 89 4D E4 EB 1B }
	condition:
		$1
}

rule file_3_170_1 {
	meta:
		name = "__catch$?_Copy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEXII@Z$1"
		size = 199
		refs = "0008 ?_Tidy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEX_NI@Z 0011 __CxxThrowException@8 0016 $LN17 002c $LN19 004f ?_Myptr@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAEPADXZ 0059 ??$_Unfancy@D@std@@YAPADPAD@Z 0062 ?copy@?$char_traits@D@std@@SAPADPADPBDI@Z 007d ?_Bx@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAEAAT_Bxty@?$_String_val@U?$_Simple_types@D@std@@@2@XZ 0083 ??$addressof@PAD@std@@YAPAPADAAPAD@Z 008f ?_Getal@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAEAAU?$_Wrap_alloc@V?$allocator@D@std@@@2@XZ 0096 ??$construct@PADAAPAD@?$_Wrap_alloc@V?$allocator@D@std@@@std@@QAEXPAPADAAPAD@Z 009e ?_Myres@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAEAAIXZ 00af ?_Eos@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEXI@Z"
	strings:
		$1 = { 6A 00 6A 01 8B 4D EC E8 ?? ?? ?? ?? 6A 00 6A 00 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? C3 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 01 00 00 00 B8 ?? ?? ?? ?? C3 C7 45 FC FF FF FF FF EB 07 C7 45 FC FF FF FF FF 83 7D 0C 00 76 22 8B 55 0C 52 8B 4D EC E8 ?? ?? ?? ?? 50 8B 45 E4 50 E8 ?? ?? ?? ?? 83 C4 04 50 E8 ?? ?? ?? ?? 83 C4 0C 6A 00 6A 01 8B 4D EC E8 ?? ?? ?? ?? 8D 4D E4 51 8B 4D EC E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 50 8B 4D EC E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 4D EC E8 ?? ?? ?? ?? 8B 55 E8 89 10 8B 45 0C 50 8B 4D EC E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_29_605_1 {
	meta:
		name = "__catch$?_Copy@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAEXII@Z$1"
		size = 199
		refs = "0008 ?_Tidy@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAEX_NI@Z 0011 __CxxThrowException@8 0016 $LN17 002c $LN19 004f ?_Myptr@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAEPAGXZ 0059 ??$_Unfancy@G@std@@YAPAGPAG@Z 0062 ?copy@?$char_traits@G@std@@SAPAGPAGPBGI@Z 007d ?_Bx@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAEAAT_Bxty@?$_String_val@U?$_Simple_types@G@std@@@2@XZ 0083 ??$addressof@PAG@std@@YAPAPAGAAPAG@Z 008f ?_Getal@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAEAAU?$_Wrap_alloc@V?$allocator@G@std@@@2@XZ 0096 ??$construct@PAGAAPAG@?$_Wrap_alloc@V?$allocator@G@std@@@std@@QAEXPAPAGAAPAG@Z 009e ?_Myres@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAEAAIXZ 00af ?_Eos@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAEXI@Z"
	strings:
		$1 = { 6A 00 6A 01 8B 4D EC E8 ?? ?? ?? ?? 6A 00 6A 00 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? C3 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 01 00 00 00 B8 ?? ?? ?? ?? C3 C7 45 FC FF FF FF FF EB 07 C7 45 FC FF FF FF FF 83 7D 0C 00 76 22 8B 55 0C 52 8B 4D EC E8 ?? ?? ?? ?? 50 8B 45 E4 50 E8 ?? ?? ?? ?? 83 C4 04 50 E8 ?? ?? ?? ?? 83 C4 0C 6A 00 6A 01 8B 4D EC E8 ?? ?? ?? ?? 8D 4D E4 51 8B 4D EC E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 50 8B 4D EC E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 4D EC E8 ?? ?? ?? ?? 8B 55 E8 89 10 8B 45 0C 50 8B 4D EC E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_29_609_1 {
	meta:
		name = "__catch$?_Copy@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAEXII@Z$1"
		size = 199
		refs = "0008 ?_Tidy@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAEX_NI@Z 0011 __CxxThrowException@8 0016 $LN17 002c $LN19 004f ?_Myptr@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAEPA_WXZ 0059 ??$_Unfancy@_W@std@@YAPA_WPA_W@Z 0062 ?copy@?$char_traits@_W@std@@SAPA_WPA_WPB_WI@Z 007d ?_Bx@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAEAAT_Bxty@?$_String_val@U?$_Simple_types@_W@std@@@2@XZ 0083 ??$addressof@PA_W@std@@YAPAPA_WAAPA_W@Z 008f ?_Getal@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAEAAU?$_Wrap_alloc@V?$allocator@_W@std@@@2@XZ 0096 ??$construct@PA_WAAPA_W@?$_Wrap_alloc@V?$allocator@_W@std@@@std@@QAEXPAPA_WAAPA_W@Z 009e ?_Myres@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAEAAIXZ 00af ?_Eos@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAEXI@Z"
	strings:
		$1 = { 6A 00 6A 01 8B 4D EC E8 ?? ?? ?? ?? 6A 00 6A 00 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? C3 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 01 00 00 00 B8 ?? ?? ?? ?? C3 C7 45 FC FF FF FF FF EB 07 C7 45 FC FF FF FF FF 83 7D 0C 00 76 22 8B 55 0C 52 8B 4D EC E8 ?? ?? ?? ?? 50 8B 45 E4 50 E8 ?? ?? ?? ?? 83 C4 04 50 E8 ?? ?? ?? ?? 83 C4 0C 6A 00 6A 01 8B 4D EC E8 ?? ?? ?? ?? 8D 4D E4 51 8B 4D EC E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 50 8B 4D EC E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 4D EC E8 ?? ?? ?? ?? 8B 55 E8 89 10 8B 45 0C 50 8B 4D EC E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_3_171_1 {
	meta:
		name = "__ehhandler$?_Copy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEXII@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Copy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEXII@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_79_23_2 {
	meta:
		name = "__ehhandler$??$allocate_shared@V__ExceptionPtr@@U?$_StaticAllocator@H@@AAPAUEHExceptionRecord@@_N@std@@YA?AV?$shared_ptr@V__ExceptionPtr@@@0@ABU?$_StaticAllocator@H@@AAPAUEHExceptionRecord@@$$QA_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$allocate_shared@V__ExceptionPtr@@U?$_StaticAllocator@H@@AAPAUEHExceptionRecord@@_N@std@@YA?AV?$shared_ptr@V__ExceptionPtr@@@0@ABU?$_StaticAllocator@H@@AAPAUEHExceptionRecord@@$$QA_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_758_3 {
	meta:
		name = "__ehhandler$?_Copy@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAEXII@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Copy@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAEXII@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_762_3 {
	meta:
		name = "__ehhandler$?_Copy@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAEXII@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Copy@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAEXII@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_100_402_3 {
	meta:
		name = "__ehhandler$?_Getfmt@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@IBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@PBD@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Getfmt@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@IBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@PBD@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_907_2 {
	meta:
		name = "__ehhandler$?_Getfmt@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@IBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@PBD@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Getfmt@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@IBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@PBD@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_910_2 {
	meta:
		name = "__ehhandler$?_Getfmt@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@IBE?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@PBD@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Getfmt@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@IBE?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@PBD@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_75_156_2 {
	meta:
		name = "__ehhandler$?_Osfx@?$basic_ostream@DU?$char_traits@D@std@@@std@@QAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Osfx@?$basic_ostream@DU?$char_traits@D@std@@@std@@QAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_85_156_2 {
	meta:
		name = "__ehhandler$?_Osfx@?$basic_ostream@GU?$char_traits@G@std@@@std@@QAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Osfx@?$basic_ostream@GU?$char_traits@G@std@@@std@@QAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_50_156_2 {
	meta:
		name = "__ehhandler$?_Osfx@?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Osfx@?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_3_172_1 {
	meta:
		name = "?_Copy_alloc@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAEXABU?$_Wrap_alloc@V?$allocator@D@std@@@2@@Z"
		size = 34
		refs = "000f ?_Getal@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAEAAU?$_Wrap_alloc@V?$allocator@D@std@@@2@XZ 0015 ??$_Pocca@U?$_Wrap_alloc@V?$allocator@D@std@@@std@@@std@@YAXAAU?$_Wrap_alloc@V?$allocator@D@std@@@0@ABU10@@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 08 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_29_611_1 {
	meta:
		name = "?_Copy_alloc@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAEXABU?$_Wrap_alloc@V?$allocator@G@std@@@2@@Z"
		size = 34
		refs = "000f ?_Getal@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAEAAU?$_Wrap_alloc@V?$allocator@G@std@@@2@XZ 0015 ??$_Pocca@U?$_Wrap_alloc@V?$allocator@G@std@@@std@@@std@@YAXAAU?$_Wrap_alloc@V?$allocator@G@std@@@0@ABU10@@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 08 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_29_612_1 {
	meta:
		name = "?_Copy_alloc@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAEXABU?$_Wrap_alloc@V?$allocator@_W@std@@@2@@Z"
		size = 34
		refs = "000f ?_Getal@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAEAAU?$_Wrap_alloc@V?$allocator@_W@std@@@2@XZ 0015 ??$_Pocca@U?$_Wrap_alloc@V?$allocator@_W@std@@@std@@@std@@YAXAAU?$_Wrap_alloc@V?$allocator@_W@std@@@0@ABU10@@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 08 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_80_380_1 {
	meta:
		name = "?_Move_alloc@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAEXAAU?$_Wrap_alloc@V?$allocator@D@std@@@2@@Z"
		size = 34
		refs = "000f ?_Getal@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAEAAU?$_Wrap_alloc@V?$allocator@D@std@@@2@XZ 0015 ??$_Pocma@U?$_Wrap_alloc@V?$allocator@D@std@@@std@@@std@@YAXAAU?$_Wrap_alloc@V?$allocator@D@std@@@0@0@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 08 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_29_951_1 {
	meta:
		name = "?_Move_alloc@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAEXAAU?$_Wrap_alloc@V?$allocator@G@std@@@2@@Z"
		size = 34
		refs = "000f ?_Getal@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAEAAU?$_Wrap_alloc@V?$allocator@G@std@@@2@XZ 0015 ??$_Pocma@U?$_Wrap_alloc@V?$allocator@G@std@@@std@@@std@@YAXAAU?$_Wrap_alloc@V?$allocator@G@std@@@0@0@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 08 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_29_952_1 {
	meta:
		name = "?_Move_alloc@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAEXAAU?$_Wrap_alloc@V?$allocator@_W@std@@@2@@Z"
		size = 34
		refs = "000f ?_Getal@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAEAAU?$_Wrap_alloc@V?$allocator@_W@std@@@2@XZ 0015 ??$_Pocma@U?$_Wrap_alloc@V?$allocator@_W@std@@@std@@@std@@YAXAAU?$_Wrap_alloc@V?$allocator@_W@std@@@0@0@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 08 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_3_173_1 {
	meta:
		name = "?_Deallocate@std@@YAXPAXII@Z"
		size = 595
		refs = "0014 ??_C@_0BN@HMCJOMKN@_Count?5?$DM?$DN?5?$CIsize_t?$CJ?$CI?91?$CJ?5?1?5_Sz?$AA@ 0021 ??_C@_1EI@MLOBABC@?$AA?$CC?$AA_?$AAC?$AAo?$AAu?$AAn?$AAt?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AA?$CI?$AAs?$AAi?$AAz?$AAe?$AA_?$AAt?$AA?$CJ?$AA?$CI?$AA?9?$AA1?$AA?$CJ?$AA?5?$AA?1?$AA?5?$AA_?$AAS?$AAz?$AA?$CC?$AA?5?$AA?$CG@ 0026 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 002f ??_C@_1FC@CNLMDHOG@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAs?$AAt?$AAd?$AAh?$AAp?$AAp?$AA?2@ 0036 __CrtDbgReportW 004d ??_C@_1CC@LOFJFFDB@?$AAs?$AAt?$AAd?$AA?3?$AA?3?$AA_?$AAD?$AAe?$AAa?$AAl?$AAl?$AAo?$AAc?$AAa?$AAt?$AAe?$AA?$AA@ 0052 ??_C@_1CG@JNLFBNGN@?$AA?$CC?$AAi?$AAn?$AAv?$AAa?$AAl?$AAi?$AAd?$AA?5?$AAa?$AAr?$AAg?$AAu?$AAm?$AAe?$AAn?$AAt?$AA?$CC?$AA?$AA@ 0057 __invalid_parameter 0084 ??_C@_0DD@GBGGGKGG@?$CI_Ptr_user?5?$CG?5?$CI_BIG_ALLOCATION_AL@ 0091 ??_C@_1HE@CDMBFOKC@?$AA?$CC?$AA?$CI?$AA_?$AAP?$AAt?$AAr?$AA_?$AAu?$AAs?$AAe?$AAr?$AA?5?$AA?$CG?$AA?5?$AA?$CI?$AA_?$AAB?$AAI?$AAG?$AA_?$AAA?$AAL?$AAL?$AAO?$AAC?$AAA?$AAT?$AAI?$AAO?$AAN?$AA_?$AAA@ 00f4 ??_C@_0EI@NOJHEJCJ@reinterpret_cast?$DMuintptr_t?5?$CK?$DO?$CI_P@ 0101 ??_C@_1JO@EKLKIEHP@?$AA?$CC?$AAr?$AAe?$AAi?$AAn?$AAt?$AAe?$AAr?$AAp?$AAr?$AAe?$AAt?$AA_?$AAc?$AAa?$AAs?$AAt?$AA?$DM?$AAu?$AAi?$AAn?$AAt?$AAp?$AAt?$AAr?$AA_?$AAt?$AA?5?$AA?$CK?$AA?$DO?$AA?$CI?$AA_@ 0147 ??_C@_0BL@OCKMEJON@_Ptr_container?5?$DM?5_Ptr_user?$AA@ 0154 ??_C@_1EE@PDHAHDDC@?$AA?$CC?$AA_?$AAP?$AAt?$AAr?$AA_?$AAc?$AAo?$AAn?$AAt?$AAa?$AAi?$AAn?$AAe?$AAr?$AA?5?$AA?$DM?$AA?5?$AA_?$AAP?$AAt?$AAr?$AA_?$AAu?$AAs?$AAe?$AAr?$AA?$CC?$AA?5?$AA?$CG?$AA?$CG?$AA?5@ 019d ??_C@_0DB@GLFJLNCE@2?5?$CK?5sizeof?$CIvoid?5?$CK?$CJ?5?$DM?$DN?5_Ptr_user?5@ 01aa ??_C@_1HA@NAPGMHAO@?$AA?$CC?$AA2?$AA?5?$AA?$CK?$AA?5?$AAs?$AAi?$AAz?$AAe?$AAo?$AAf?$AA?$CI?$AAv?$AAo?$AAi?$AAd?$AA?5?$AA?$CK?$AA?$CJ?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AA_?$AAP?$AAt?$AAr?$AA_?$AAu?$AAs?$AAe?$AAr@ 01f3 ??_C@_0CN@BLHJCAL@_Ptr_user?5?9?5_Ptr_container?5?$DM?$DN?5_N@ 0200 ??_C@_1GI@DHJGPFNI@?$AA?$CC?$AA_?$AAP?$AAt?$AAr?$AA_?$AAu?$AAs?$AAe?$AAr?$AA?5?$AA?9?$AA?5?$AA_?$AAP?$AAt?$AAr?$AA_?$AAc?$AAo?$AAn?$AAt?$AAa?$AAi?$AAn?$AAe?$AAr?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AA_@ 0248 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 83 EC 10 83 C8 FF 33 D2 F7 75 10 39 45 0C 76 4B B8 ?? ?? ?? ?? 85 C0 74 04 33 C9 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 5E 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 6A 00 6A 5E 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 8B 45 0C 0F AF 45 10 89 45 F0 81 7D F0 00 10 00 00 0F 82 CE 01 00 00 8B 4D 08 89 4D FC 8B 55 FC 83 E2 1F 74 4B B8 ?? ?? ?? ?? 85 C0 74 04 33 C9 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 64 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 6A 00 6A 64 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 8B 45 FC 83 E8 04 89 45 F4 8B 4D F4 8B 11 89 55 F8 B8 04 00 00 00 6B C8 FF 8B 55 F4 81 3C 0A FA FA FA FA 74 4B B8 ?? ?? ?? ?? 85 C0 74 04 33 C9 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 6E 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 6A 00 6A 6E 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 8B 45 F8 3B 45 FC 72 4B B9 ?? ?? ?? ?? 85 C9 74 04 33 D2 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 72 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 6A 00 6A 72 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 8B 4D FC 2B 4D F8 83 F9 08 73 4B BA ?? ?? ?? ?? 85 D2 74 04 33 C0 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 76 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 6A 00 6A 76 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 8B 55 FC 2B 55 F8 83 FA 27 76 4B B8 ?? ?? ?? ?? 85 C0 74 04 33 C9 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 7E 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 6A 00 6A 7E 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 8B 45 F8 89 45 08 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 04 8B E5 5D C3 }
	condition:
		$1
}

rule file_3_174_1 {
	meta:
		name = "?_Decref@facet@locale@std@@UAEPAV_Facet_base@3@XZ"
		size = 36
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 83 C0 04 83 C9 FF F0 0F C1 08 49 75 07 8B 45 FC EB 04 EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_3_175_1 {
	meta:
		name = "?_Eos@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEXI@Z"
		size = 63
		refs = "000d ?_Get_data@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAEAAV?$_String_val@U?$_Simple_types@D@std@@@2@XZ 0029 ?_Myptr@?$_String_val@U?$_Simple_types@D@std@@@std@@QAEPADXZ 0032 ?assign@?$char_traits@D@std@@SAXAADABD@Z"
	strings:
		$1 = { 55 8B EC 83 EC 0C 89 4D F4 8B 4D F4 E8 ?? ?? ?? ?? 89 45 F8 C6 45 FF 00 8B 45 F8 8B 4D 08 89 48 10 8D 55 FF 52 8B 4D F8 E8 ?? ?? ?? ?? 03 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_3_176_1 {
	meta:
		name = "?_Ffmt@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABAPADPADDH@Z"
		size = 319
		altNames = "?_Ffmt@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABAPADPADDH@Z ?_Ffmt@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABAPADPADDH@Z"
	strings:
		$1 = { 55 8B EC 83 EC 10 8B 45 0C 89 45 F4 8B 4D F4 C6 01 25 8B 55 F4 83 C2 01 89 55 F4 8B 45 14 83 E0 20 74 0F 8B 4D F4 C6 01 2B 8B 55 F4 83 C2 01 89 55 F4 8B 45 14 83 E0 10 74 0F 8B 4D F4 C6 01 23 8B 55 F4 83 C2 01 89 55 F4 8B 45 F4 C6 00 2E 8B 4D F4 83 C1 01 89 4D F4 8B 55 F4 C6 02 2A 8B 45 F4 83 C0 01 89 45 F4 0F BE 4D 10 85 C9 74 11 8B 55 F4 8A 45 10 88 02 8B 4D F4 83 C1 01 89 4D F4 8B 55 14 81 E2 00 30 00 00 89 55 F0 8B 45 14 83 E0 04 74 50 81 7D F0 00 20 00 00 75 06 C6 45 FD 66 EB 2E 81 7D F0 00 30 00 00 75 06 C6 45 FE 41 EB 19 81 7D F0 00 10 00 00 75 06 C6 45 FF 45 EB 04 C6 45 FF 47 8A 4D FF 88 4D FE 8A 55 FE 88 55 FD 8B 45 F4 8A 4D FD 88 08 8B 55 F4 83 C2 01 89 55 F4 EB 4E 81 7D F0 00 20 00 00 75 06 C6 45 FA 66 EB 2E 81 7D F0 00 30 00 00 75 06 C6 45 FB 61 EB 19 81 7D F0 00 10 00 00 75 06 C6 45 FC 65 EB 04 C6 45 FC 67 8A 45 FC 88 45 FB 8A 4D FB 88 4D FA 8B 55 F4 8A 45 FA 88 02 8B 4D F4 83 C1 01 89 4D F4 8B 55 F4 C6 02 00 8B 45 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_3_177_1 {
	meta:
		name = "?_Fput@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AAVios_base@2@DPBDI@Z"
		size = 1263
		refs = "0006 __ehhandler$?_Fput@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AAVios_base@2@DPBDI@Z 0018 ___security_cookie 0062 ?flags@ios_base@std@@QBEHXZ 0075 ??_C@_02MDKMJEGG@eE?$AA@ 007e ??_C@_02OOPEBDOJ@pP?$AA@ 00d3 _strcspn 00e3 ??_C@_01LFCBOECM@?4?$AA@ 00ec _localeconv 0138 ?getloc@ios_base@std@@QBE?AVlocale@2@XZ 0151 ??$use_facet@V?$ctype@D@std@@@std@@YAABV?$ctype@D@0@ABVlocale@0@@Z 0169 ??1locale@std@@QAE@XZ 0177 ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@ID@Z 0188 ??A?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAADI@Z 01a4 ?widen@?$ctype@D@std@@QBEPBDPBD0PAD@Z 01d5 ??$use_facet@V?$numpunct@D@std@@@std@@YAABV?$numpunct@D@0@ABVlocale@0@@Z 01f6 ?grouping@?$numpunct@D@std@@QBE?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ 0202 ?thousands_sep@?$numpunct@D@std@@QBEDXZ 0215 ?decimal_point@?$numpunct@D@std@@QBEDXZ 024e ??A?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBEABDI@Z 0297 ?insert@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAAV12@IID@Z 02bd ?size@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBEIXZ 02c8 ?width@ios_base@std@@QBE_JXZ 0352 ?_Rep@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@DI@Z 038e ?_Put@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@PBDI@Z 0492 ?width@ios_base@std@@QAE_J_J@Z 04bf ??1?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@XZ 04e7 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 81 EC C8 00 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 F0 53 50 8D 45 F4 64 A3 00 00 00 00 83 7D 24 00 76 1F 8B 45 20 0F BE 08 83 F9 2B 74 0B 8B 55 20 0F BE 02 83 F8 2D 75 09 C7 45 98 01 00 00 00 EB 07 C7 45 98 00 00 00 00 8B 4D 98 89 4D BC 8B 4D 18 E8 ?? ?? ?? ?? 25 00 30 00 00 3D 00 30 00 00 74 09 C7 45 94 ?? ?? ?? ?? EB 47 C7 45 94 ?? ?? ?? ?? 8B 55 BC 83 C2 02 3B 55 24 77 35 8B 45 20 03 45 BC 0F BE 08 83 F9 30 75 27 8B 55 20 03 55 BC 0F BE 42 01 83 F8 78 74 0F 8B 4D 20 03 4D BC 0F BE 51 01 83 FA 58 75 09 8B 45 BC 83 C0 02 89 45 BC 8B 4D 94 51 BA 01 00 00 00 6B C2 00 03 45 20 50 E8 ?? ?? ?? ?? 83 C4 08 89 85 74 FF FF FF 66 8B 0D ?? ?? ?? ?? 66 89 4D B0 E8 ?? ?? ?? ?? BA 01 00 00 00 6B CA 00 8B 10 B8 01 00 00 00 6B C0 00 8A 0C 11 88 4C 05 B0 BA 01 00 00 00 6B C2 00 8D 4C 05 B0 51 BA 01 00 00 00 6B C2 00 03 45 20 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 A8 8D 8D 64 FF FF FF 51 8B 4D 18 E8 ?? ?? ?? ?? 89 45 88 8B 55 88 89 55 84 C7 45 FC 00 00 00 00 8B 45 84 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 80 C7 45 FC FF FF FF FF 8D 8D 64 FF FF FF E8 ?? ?? ?? ?? 6A 00 8B 4D 24 51 8D 4D D8 E8 ?? ?? ?? ?? C7 45 FC 01 00 00 00 6A 00 8D 4D D8 E8 ?? ?? ?? ?? 50 8B 55 20 03 55 24 52 B8 01 00 00 00 6B C8 00 03 4D 20 51 8B 4D 80 E8 ?? ?? ?? ?? 8D 95 5C FF FF FF 52 8B 4D 18 E8 ?? ?? ?? ?? 89 85 7C FF FF FF 8B 85 7C FF FF FF 89 85 78 FF FF FF C6 45 FC 02 8B 8D 78 FF FF FF 51 E8 ?? ?? ?? ?? 83 C4 04 89 45 A0 C6 45 FC 01 8D 8D 5C FF FF FF E8 ?? ?? ?? ?? 8D 55 C0 52 8B 4D A0 E8 ?? ?? ?? ?? C6 45 FC 03 8B 4D A0 E8 ?? ?? ?? ?? 88 45 BB 8B 45 A8 3B 45 24 74 18 8B 4D A0 E8 ?? ?? ?? ?? 8A D8 8B 4D A8 51 8D 4D D8 E8 ?? ?? ?? ?? 88 18 8B 55 A8 3B 55 24 75 0B 8B 85 74 FF FF FF 89 45 90 EB 06 8B 4D A8 89 4D 90 8B 55 90 89 55 A4 6A 00 8D 4D C0 E8 ?? ?? ?? ?? 89 45 B4 8B 45 B4 0F BE 08 83 F9 7F 74 59 8B 55 B4 0F BE 02 85 C0 7E 4F 8B 4D B4 0F BE 11 8B 45 A4 2B 45 BC 3B D0 73 3F 8B 4D B4 0F BE 11 8B 45 A4 2B C2 89 45 A4 0F B6 4D BB 51 6A 01 8B 55 A4 52 8D 4D D8 E8 ?? ?? ?? ?? B8 01 00 00 00 C1 E0 00 8B 4D B4 0F BE 14 01 85 D2 7E 09 8B 45 B4 83 C0 01 89 45 B4 EB 9C 8D 4D D8 E8 ?? ?? ?? ?? 89 45 24 8B 4D 18 E8 ?? ?? ?? ?? 89 85 6C FF FF FF 89 95 70 FF FF FF 83 BD 70 FF FF FF 00 7C 28 7F 09 83 BD 6C FF FF FF 00 76 1D 8B 4D 18 E8 ?? ?? ?? ?? 3B 45 24 76 10 8B 4D 18 E8 ?? ?? ?? ?? 2B 45 24 89 45 8C EB 07 C7 45 8C 00 00 00 00 8B 4D 8C 89 4D AC 8B 4D 18 E8 ?? ?? ?? ?? 25 C0 01 00 00 89 45 9C 83 7D 9C 40 74 79 81 7D 9C 00 01 00 00 74 70 8B 55 AC 52 0F B6 45 1C 50 8B 4D 14 51 8B 55 10 52 8D 85 54 FF FF FF 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 18 8B 10 8B 40 04 89 55 10 89 45 14 C7 45 AC 00 00 00 00 8B 4D BC 51 6A 00 8D 4D D8 E8 ?? ?? ?? ?? 50 8B 55 14 52 8B 45 10 50 8D 8D 4C FF FF FF 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 18 8B 08 8B 50 04 89 4D 10 89 55 14 E9 AB 00 00 00 81 7D 9C 00 01 00 00 75 6D 8B 45 BC 50 6A 00 8D 4D D8 E8 ?? ?? ?? ?? 50 8B 4D 14 51 8B 55 10 52 8D 85 44 FF FF FF 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 18 8B 10 8B 40 04 89 55 10 89 45 14 8B 4D AC 51 0F B6 55 1C 52 8B 45 14 50 8B 4D 10 51 8D 95 3C FF FF FF 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 18 8B 08 8B 50 04 89 4D 10 89 55 14 C7 45 AC 00 00 00 00 EB 35 8B 45 BC 50 6A 00 8D 4D D8 E8 ?? ?? ?? ?? 50 8B 4D 14 51 8B 55 10 52 8D 85 34 FF FF FF 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 18 8B 10 8B 40 04 89 55 10 89 45 14 8B 4D 24 2B 4D BC 51 8B 55 BC 52 8D 4D D8 E8 ?? ?? ?? ?? 50 8B 45 14 50 8B 4D 10 51 8D 95 2C FF FF FF 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 18 8B 08 8B 50 04 89 4D 10 89 55 14 6A 00 6A 00 8B 4D 18 E8 ?? ?? ?? ?? 8B 45 AC 50 0F B6 4D 1C 51 8B 55 14 52 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 18 C6 45 FC 01 8D 4D C0 E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8D 4D D8 E8 ?? ?? ?? ?? 8B 45 0C 8B 4D F4 64 89 0D 00 00 00 00 59 5B 8B 4D F0 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_3_182_1 {
	meta:
		name = "__ehhandler$?_Fput@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AAVios_base@2@DPBDI@Z"
		size = 40
		refs = "0010 @__security_check_cookie@4 001f __ehfuncinfo$?_Fput@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AAVios_base@2@DPBDI@Z 0024 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 8A 30 FF FF FF 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_29_633_1 {
	meta:
		name = "__ehhandler$?_Fput@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AAVios_base@2@GPBDI@Z"
		size = 40
		refs = "0010 @__security_check_cookie@4 001f __ehfuncinfo$?_Fput@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AAVios_base@2@GPBDI@Z 0024 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 8A 30 FF FF FF 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_29_639_1 {
	meta:
		name = "__ehhandler$?_Fput@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AAVios_base@2@_WPBDI@Z"
		size = 40
		refs = "0010 @__security_check_cookie@4 001f __ehfuncinfo$?_Fput@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AAVios_base@2@_WPBDI@Z 0024 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 8A 30 FF FF FF 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_3_191_1 {
	meta:
		name = "?_Getcat@?$codecvt@DDU_Mbstatet@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 225
		refs = "0006 __ehhandler$?_Getcat@?$codecvt@DDU_Mbstatet@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0015 ___security_cookie 0045 ??2_Crt_new_delete@std@@SAPAXI@Z 0062 ?c_str@locale@std@@QBEPBDXZ 006b ??0_Locinfo@std@@QAE@PBD@Z 008d ??0?$codecvt@DDU_Mbstatet@@@std@@QAE@ABV_Locinfo@1@I@Z 00c9 ??1_Locinfo@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 4C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 C7 45 F0 00 00 00 00 83 7D 08 00 0F 84 97 00 00 00 8B 45 08 83 38 00 0F 85 8B 00 00 00 6A 08 E8 ?? ?? ?? ?? 83 C4 04 89 45 EC C7 45 FC 00 00 00 00 83 7D EC 00 74 3A 6A 00 8B 4D 0C E8 ?? ?? ?? ?? 50 8D 4D A8 E8 ?? ?? ?? ?? 89 45 E4 8B 4D E4 89 4D E0 C6 45 FC 01 8B 55 F0 83 CA 01 89 55 F0 8B 45 E0 50 8B 4D EC E8 ?? ?? ?? ?? 89 45 E8 EB 07 C7 45 E8 00 00 00 00 8B 4D E8 89 4D DC C7 45 FC 02 00 00 00 8B 55 08 8B 45 DC 89 02 C7 45 FC FF FF FF FF 8B 4D F0 83 E1 01 74 0C 83 65 F0 FE 8D 4D A8 E8 ?? ?? ?? ?? B8 02 00 00 00 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_3_193_1 {
	meta:
		name = "__unwindfunclet$?_Getcat@?$codecvt@DDU_Mbstatet@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z$1"
		size = 25
		refs = "0014 ??1_Locinfo@std@@QAE@XZ"
		altNames = "__unwindfunclet$?_Getcat@?$codecvt@GDU_Mbstatet@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z$1 __unwindfunclet$?_Getcat@?$codecvt@_WDU_Mbstatet@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z$1 __unwindfunclet$?_Getcat@?$ctype@D@std@@SAIPAPBVfacet@locale@2@PBV42@@Z$1 __unwindfunclet$?_Getcat@?$ctype@G@std@@SAIPAPBVfacet@locale@2@PBV42@@Z$1 __unwindfunclet$?_Getcat@?$ctype@_W@std@@SAIPAPBVfacet@locale@2@PBV42@@Z$1 __unwindfunclet$?_Getcat@?$messages@D@std@@SAIPAPBVfacet@locale@2@PBV42@@Z$1 __unwindfunclet$?_Getcat@?$messages@G@std@@SAIPAPBVfacet@locale@2@PBV42@@Z$1 __unwindfunclet$?_Getcat@?$messages@_W@std@@SAIPAPBVfacet@locale@2@PBV42@@Z$1 __unwindfunclet$?_Getcat@?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z$1 __unwindfunclet$?_Getcat@?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z$1 __unwindfunclet$?_Getcat@?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z$1 __unwindfunclet$?_Getcat@?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z$1 __unwindfunclet$?_Getcat@?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z$1 __unwindfunclet$?_Getcat@?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z$1 __unwindfunclet$?_Getcat@?$moneypunct@D$00@std@@SAIPAPBVfacet@locale@2@PBV42@@Z$1 __unwindfunclet$?_Getcat@?$moneypunct@D$0A@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z$1 __unwindfunclet$?_Getcat@?$moneypunct@G$00@std@@SAIPAPBVfacet@locale@2@PBV42@@Z$1 __unwindfunclet$?_Getcat@?$moneypunct@G$0A@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z$1 __unwindfunclet$?_Getcat@?$moneypunct@_W$00@std@@SAIPAPBVfacet@locale@2@PBV42@@Z$1 __unwindfunclet$?_Getcat@?$moneypunct@_W$0A@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z$1 __unwindfunclet$?_Getcat@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z$1 __unwindfunclet$?_Getcat@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z$1 __unwindfunclet$?_Getcat@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z$1 __unwindfunclet$?_Getcat@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z$1 __unwindfunclet$?_Getcat@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z$1 __unwindfunclet$?_Getcat@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z$1 __unwindfunclet$?_Getcat@?$numpunct@D@std@@SAIPAPBVfacet@locale@2@PBV42@@Z$1 __unwindfunclet$?_Getcat@?$numpunct@G@std@@SAIPAPBVfacet@locale@2@PBV42@@Z$1 __unwindfunclet$?_Getcat@?$numpunct@_W@std@@SAIPAPBVfacet@locale@2@PBV42@@Z$1 __unwindfunclet$?_Getcat@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z$1 __unwindfunclet$?_Getcat@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z$1 __unwindfunclet$?_Getcat@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z$1 __unwindfunclet$?_Getcat@?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z$1 __unwindfunclet$?_Getcat@?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z$1 __unwindfunclet$?_Getcat@?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z$1"
	strings:
		$1 = { 8B 45 F0 83 E0 01 0F 84 0C 00 00 00 83 65 F0 FE 8D 4D A8 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_3_194_1 {
	meta:
		name = "__ehhandler$?_Getcat@?$codecvt@DDU_Mbstatet@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Getcat@?$codecvt@DDU_Mbstatet@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_19_285_3 {
	meta:
		name = "__ehhandler$?_Getcat@?$codecvt@GDU_Mbstatet@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Getcat@?$codecvt@GDU_Mbstatet@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_29_671_1 {
	meta:
		name = "__ehhandler$?_Getcat@?$codecvt@_WDU_Mbstatet@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Getcat@?$codecvt@_WDU_Mbstatet@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_58_228_1 {
	meta:
		name = "__ehhandler$?_Getcat@?$ctype@D@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Getcat@?$ctype@D@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_3_265_2 {
	meta:
		name = "__ehhandler$?_Getcat@?$ctype@G@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Getcat@?$ctype@G@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_28_227_1 {
	meta:
		name = "__ehhandler$?_Getcat@?$ctype@_W@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Getcat@?$ctype@_W@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_100_368_3 {
	meta:
		name = "__ehhandler$?_Getcat@?$messages@D@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Getcat@?$messages@D@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_796_2 {
	meta:
		name = "__ehhandler$?_Getcat@?$messages@G@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Getcat@?$messages@G@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_852_3 {
	meta:
		name = "__ehhandler$?_Getcat@?$messages@_W@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Getcat@?$messages@_W@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_100_372_3 {
	meta:
		name = "__ehhandler$?_Getcat@?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Getcat@?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_856_3 {
	meta:
		name = "__ehhandler$?_Getcat@?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Getcat@?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_808_2 {
	meta:
		name = "__ehhandler$?_Getcat@?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Getcat@?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_100_376_3 {
	meta:
		name = "__ehhandler$?_Getcat@?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Getcat@?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_812_2 {
	meta:
		name = "__ehhandler$?_Getcat@?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Getcat@?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_29_713_1 {
	meta:
		name = "__ehhandler$?_Getcat@?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Getcat@?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_100_380_3 {
	meta:
		name = "__ehhandler$?_Getcat@?$moneypunct@D$00@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Getcat@?$moneypunct@D$00@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_90_364_2 {
	meta:
		name = "__ehhandler$?_Getcat@?$moneypunct@D$0A@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Getcat@?$moneypunct@D$0A@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_872_3 {
	meta:
		name = "__ehhandler$?_Getcat@?$moneypunct@G$00@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Getcat@?$moneypunct@G$00@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_876_3 {
	meta:
		name = "__ehhandler$?_Getcat@?$moneypunct@G$0A@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Getcat@?$moneypunct@G$0A@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_880_3 {
	meta:
		name = "__ehhandler$?_Getcat@?$moneypunct@_W$00@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Getcat@?$moneypunct@_W$00@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_884_3 {
	meta:
		name = "__ehhandler$?_Getcat@?$moneypunct@_W$0A@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Getcat@?$moneypunct@_W$0A@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_53_235_3 {
	meta:
		name = "__ehhandler$?_Getcat@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Getcat@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_888_3 {
	meta:
		name = "__ehhandler$?_Getcat@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Getcat@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_892_3 {
	meta:
		name = "__ehhandler$?_Getcat@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Getcat@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_53_239_3 {
	meta:
		name = "__ehhandler$?_Getcat@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Getcat@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_896_3 {
	meta:
		name = "__ehhandler$?_Getcat@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Getcat@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_900_3 {
	meta:
		name = "__ehhandler$?_Getcat@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Getcat@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_3_210_1 {
	meta:
		name = "__ehhandler$?_Getcat@?$numpunct@D@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Getcat@?$numpunct@D@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_904_3 {
	meta:
		name = "__ehhandler$?_Getcat@?$numpunct@G@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Getcat@?$numpunct@G@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_856_2 {
	meta:
		name = "__ehhandler$?_Getcat@?$numpunct@_W@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Getcat@?$numpunct@_W@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_90_368_2 {
	meta:
		name = "__ehhandler$?_Getcat@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Getcat@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_29_757_1 {
	meta:
		name = "__ehhandler$?_Getcat@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Getcat@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_29_761_1 {
	meta:
		name = "__ehhandler$?_Getcat@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Getcat@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_80_318_1 {
	meta:
		name = "__ehhandler$?_Getcat@?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Getcat@?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_29_765_1 {
	meta:
		name = "__ehhandler$?_Getcat@?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Getcat@?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_29_769_1 {
	meta:
		name = "__ehhandler$?_Getcat@?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Getcat@?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_3_195_1 {
	meta:
		name = "?_Getcat@?$ctype@D@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 225
		refs = "0006 __ehhandler$?_Getcat@?$ctype@D@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0015 ___security_cookie 0045 ??2_Crt_new_delete@std@@SAPAXI@Z 0062 ?c_str@locale@std@@QBEPBDXZ 006b ??0_Locinfo@std@@QAE@PBD@Z 008d ??0?$ctype@D@std@@QAE@ABV_Locinfo@1@I@Z 00c9 ??1_Locinfo@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 4C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 C7 45 F0 00 00 00 00 83 7D 08 00 0F 84 97 00 00 00 8B 45 08 83 38 00 0F 85 8B 00 00 00 6A 18 E8 ?? ?? ?? ?? 83 C4 04 89 45 EC C7 45 FC 00 00 00 00 83 7D EC 00 74 3A 6A 00 8B 4D 0C E8 ?? ?? ?? ?? 50 8D 4D A8 E8 ?? ?? ?? ?? 89 45 E4 8B 4D E4 89 4D E0 C6 45 FC 01 8B 55 F0 83 CA 01 89 55 F0 8B 45 E0 50 8B 4D EC E8 ?? ?? ?? ?? 89 45 E8 EB 07 C7 45 E8 00 00 00 00 8B 4D E8 89 4D DC C7 45 FC 02 00 00 00 8B 55 08 8B 45 DC 89 02 C7 45 FC FF FF FF FF 8B 4D F0 83 E1 01 74 0C 83 65 F0 FE 8D 4D A8 E8 ?? ?? ?? ?? B8 02 00 00 00 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_3_199_1 {
	meta:
		name = "?_Getcat@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 225
		refs = "0006 __ehhandler$?_Getcat@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0015 ___security_cookie 0045 ??2_Crt_new_delete@std@@SAPAXI@Z 0062 ?c_str@locale@std@@QBEPBDXZ 006b ??0_Locinfo@std@@QAE@PBD@Z 008d ??0?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 00c9 ??1_Locinfo@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 4C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 C7 45 F0 00 00 00 00 83 7D 08 00 0F 84 97 00 00 00 8B 45 08 83 38 00 0F 85 8B 00 00 00 6A 08 E8 ?? ?? ?? ?? 83 C4 04 89 45 EC C7 45 FC 00 00 00 00 83 7D EC 00 74 3A 6A 00 8B 4D 0C E8 ?? ?? ?? ?? 50 8D 4D A8 E8 ?? ?? ?? ?? 89 45 E4 8B 4D E4 89 4D E0 C6 45 FC 01 8B 55 F0 83 CA 01 89 55 F0 8B 45 E0 50 8B 4D EC E8 ?? ?? ?? ?? 89 45 E8 EB 07 C7 45 E8 00 00 00 00 8B 4D E8 89 4D DC C7 45 FC 02 00 00 00 8B 55 08 8B 45 DC 89 02 C7 45 FC FF FF FF FF 8B 4D F0 83 E1 01 74 0C 83 65 F0 FE 8D 4D A8 E8 ?? ?? ?? ?? B8 04 00 00 00 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_29_730_1 {
	meta:
		name = "?_Getcat@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 225
		refs = "0006 __ehhandler$?_Getcat@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0015 ___security_cookie 0045 ??2_Crt_new_delete@std@@SAPAXI@Z 0062 ?c_str@locale@std@@QBEPBDXZ 006b ??0_Locinfo@std@@QAE@PBD@Z 008d ??0?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 00c9 ??1_Locinfo@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 4C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 C7 45 F0 00 00 00 00 83 7D 08 00 0F 84 97 00 00 00 8B 45 08 83 38 00 0F 85 8B 00 00 00 6A 08 E8 ?? ?? ?? ?? 83 C4 04 89 45 EC C7 45 FC 00 00 00 00 83 7D EC 00 74 3A 6A 00 8B 4D 0C E8 ?? ?? ?? ?? 50 8D 4D A8 E8 ?? ?? ?? ?? 89 45 E4 8B 4D E4 89 4D E0 C6 45 FC 01 8B 55 F0 83 CA 01 89 55 F0 8B 45 E0 50 8B 4D EC E8 ?? ?? ?? ?? 89 45 E8 EB 07 C7 45 E8 00 00 00 00 8B 4D E8 89 4D DC C7 45 FC 02 00 00 00 8B 55 08 8B 45 DC 89 02 C7 45 FC FF FF FF FF 8B 4D F0 83 E1 01 74 0C 83 65 F0 FE 8D 4D A8 E8 ?? ?? ?? ?? B8 04 00 00 00 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_29_734_1 {
	meta:
		name = "?_Getcat@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 225
		refs = "0006 __ehhandler$?_Getcat@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0015 ___security_cookie 0045 ??2_Crt_new_delete@std@@SAPAXI@Z 0062 ?c_str@locale@std@@QBEPBDXZ 006b ??0_Locinfo@std@@QAE@PBD@Z 008d ??0?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 00c9 ??1_Locinfo@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 4C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 C7 45 F0 00 00 00 00 83 7D 08 00 0F 84 97 00 00 00 8B 45 08 83 38 00 0F 85 8B 00 00 00 6A 08 E8 ?? ?? ?? ?? 83 C4 04 89 45 EC C7 45 FC 00 00 00 00 83 7D EC 00 74 3A 6A 00 8B 4D 0C E8 ?? ?? ?? ?? 50 8D 4D A8 E8 ?? ?? ?? ?? 89 45 E4 8B 4D E4 89 4D E0 C6 45 FC 01 8B 55 F0 83 CA 01 89 55 F0 8B 45 E0 50 8B 4D EC E8 ?? ?? ?? ?? 89 45 E8 EB 07 C7 45 E8 00 00 00 00 8B 4D E8 89 4D DC C7 45 FC 02 00 00 00 8B 55 08 8B 45 DC 89 02 C7 45 FC FF FF FF FF 8B 4D F0 83 E1 01 74 0C 83 65 F0 FE 8D 4D A8 E8 ?? ?? ?? ?? B8 04 00 00 00 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_3_203_1 {
	meta:
		name = "?_Getcat@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 225
		refs = "0006 __ehhandler$?_Getcat@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0015 ___security_cookie 0045 ??2_Crt_new_delete@std@@SAPAXI@Z 0062 ?c_str@locale@std@@QBEPBDXZ 006b ??0_Locinfo@std@@QAE@PBD@Z 008d ??0?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 00c9 ??1_Locinfo@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 4C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 C7 45 F0 00 00 00 00 83 7D 08 00 0F 84 97 00 00 00 8B 45 08 83 38 00 0F 85 8B 00 00 00 6A 08 E8 ?? ?? ?? ?? 83 C4 04 89 45 EC C7 45 FC 00 00 00 00 83 7D EC 00 74 3A 6A 00 8B 4D 0C E8 ?? ?? ?? ?? 50 8D 4D A8 E8 ?? ?? ?? ?? 89 45 E4 8B 4D E4 89 4D E0 C6 45 FC 01 8B 55 F0 83 CA 01 89 55 F0 8B 45 E0 50 8B 4D EC E8 ?? ?? ?? ?? 89 45 E8 EB 07 C7 45 E8 00 00 00 00 8B 4D E8 89 4D DC C7 45 FC 02 00 00 00 8B 55 08 8B 45 DC 89 02 C7 45 FC FF FF FF FF 8B 4D F0 83 E1 01 74 0C 83 65 F0 FE 8D 4D A8 E8 ?? ?? ?? ?? B8 04 00 00 00 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_29_738_1 {
	meta:
		name = "?_Getcat@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 225
		refs = "0006 __ehhandler$?_Getcat@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0015 ___security_cookie 0045 ??2_Crt_new_delete@std@@SAPAXI@Z 0062 ?c_str@locale@std@@QBEPBDXZ 006b ??0_Locinfo@std@@QAE@PBD@Z 008d ??0?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 00c9 ??1_Locinfo@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 4C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 C7 45 F0 00 00 00 00 83 7D 08 00 0F 84 97 00 00 00 8B 45 08 83 38 00 0F 85 8B 00 00 00 6A 08 E8 ?? ?? ?? ?? 83 C4 04 89 45 EC C7 45 FC 00 00 00 00 83 7D EC 00 74 3A 6A 00 8B 4D 0C E8 ?? ?? ?? ?? 50 8D 4D A8 E8 ?? ?? ?? ?? 89 45 E4 8B 4D E4 89 4D E0 C6 45 FC 01 8B 55 F0 83 CA 01 89 55 F0 8B 45 E0 50 8B 4D EC E8 ?? ?? ?? ?? 89 45 E8 EB 07 C7 45 E8 00 00 00 00 8B 4D E8 89 4D DC C7 45 FC 02 00 00 00 8B 55 08 8B 45 DC 89 02 C7 45 FC FF FF FF FF 8B 4D F0 83 E1 01 74 0C 83 65 F0 FE 8D 4D A8 E8 ?? ?? ?? ?? B8 04 00 00 00 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_29_742_1 {
	meta:
		name = "?_Getcat@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 225
		refs = "0006 __ehhandler$?_Getcat@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0015 ___security_cookie 0045 ??2_Crt_new_delete@std@@SAPAXI@Z 0062 ?c_str@locale@std@@QBEPBDXZ 006b ??0_Locinfo@std@@QAE@PBD@Z 008d ??0?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 00c9 ??1_Locinfo@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 4C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 C7 45 F0 00 00 00 00 83 7D 08 00 0F 84 97 00 00 00 8B 45 08 83 38 00 0F 85 8B 00 00 00 6A 08 E8 ?? ?? ?? ?? 83 C4 04 89 45 EC C7 45 FC 00 00 00 00 83 7D EC 00 74 3A 6A 00 8B 4D 0C E8 ?? ?? ?? ?? 50 8D 4D A8 E8 ?? ?? ?? ?? 89 45 E4 8B 4D E4 89 4D E0 C6 45 FC 01 8B 55 F0 83 CA 01 89 55 F0 8B 45 E0 50 8B 4D EC E8 ?? ?? ?? ?? 89 45 E8 EB 07 C7 45 E8 00 00 00 00 8B 4D E8 89 4D DC C7 45 FC 02 00 00 00 8B 55 08 8B 45 DC 89 02 C7 45 FC FF FF FF FF 8B 4D F0 83 E1 01 74 0C 83 65 F0 FE 8D 4D A8 E8 ?? ?? ?? ?? B8 04 00 00 00 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_3_207_1 {
	meta:
		name = "?_Getcat@?$numpunct@D@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 227
		refs = "0006 __ehhandler$?_Getcat@?$numpunct@D@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0015 ___security_cookie 0045 ??2_Crt_new_delete@std@@SAPAXI@Z 0064 ?c_str@locale@std@@QBEPBDXZ 006d ??0_Locinfo@std@@QAE@PBD@Z 008f ??0?$numpunct@D@std@@QAE@ABV_Locinfo@1@I_N@Z 00cb ??1_Locinfo@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 4C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 C7 45 F0 00 00 00 00 83 7D 08 00 0F 84 99 00 00 00 8B 45 08 83 38 00 0F 85 8D 00 00 00 6A 18 E8 ?? ?? ?? ?? 83 C4 04 89 45 EC C7 45 FC 00 00 00 00 83 7D EC 00 74 3C 6A 01 6A 00 8B 4D 0C E8 ?? ?? ?? ?? 50 8D 4D A8 E8 ?? ?? ?? ?? 89 45 E4 8B 4D E4 89 4D E0 C6 45 FC 01 8B 55 F0 83 CA 01 89 55 F0 8B 45 E0 50 8B 4D EC E8 ?? ?? ?? ?? 89 45 E8 EB 07 C7 45 E8 00 00 00 00 8B 4D E8 89 4D DC C7 45 FC 02 00 00 00 8B 55 08 8B 45 DC 89 02 C7 45 FC FF FF FF FF 8B 4D F0 83 E1 01 74 0C 83 65 F0 FE 8D 4D A8 E8 ?? ?? ?? ?? B8 04 00 00 00 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_29_746_1 {
	meta:
		name = "?_Getcat@?$numpunct@G@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 227
		refs = "0006 __ehhandler$?_Getcat@?$numpunct@G@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0015 ___security_cookie 0045 ??2_Crt_new_delete@std@@SAPAXI@Z 0064 ?c_str@locale@std@@QBEPBDXZ 006d ??0_Locinfo@std@@QAE@PBD@Z 008f ??0?$numpunct@G@std@@QAE@ABV_Locinfo@1@I_N@Z 00cb ??1_Locinfo@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 4C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 C7 45 F0 00 00 00 00 83 7D 08 00 0F 84 99 00 00 00 8B 45 08 83 38 00 0F 85 8D 00 00 00 6A 18 E8 ?? ?? ?? ?? 83 C4 04 89 45 EC C7 45 FC 00 00 00 00 83 7D EC 00 74 3C 6A 01 6A 00 8B 4D 0C E8 ?? ?? ?? ?? 50 8D 4D A8 E8 ?? ?? ?? ?? 89 45 E4 8B 4D E4 89 4D E0 C6 45 FC 01 8B 55 F0 83 CA 01 89 55 F0 8B 45 E0 50 8B 4D EC E8 ?? ?? ?? ?? 89 45 E8 EB 07 C7 45 E8 00 00 00 00 8B 4D E8 89 4D DC C7 45 FC 02 00 00 00 8B 55 08 8B 45 DC 89 02 C7 45 FC FF FF FF FF 8B 4D F0 83 E1 01 74 0C 83 65 F0 FE 8D 4D A8 E8 ?? ?? ?? ?? B8 04 00 00 00 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_29_750_1 {
	meta:
		name = "?_Getcat@?$numpunct@_W@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 227
		refs = "0006 __ehhandler$?_Getcat@?$numpunct@_W@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0015 ___security_cookie 0045 ??2_Crt_new_delete@std@@SAPAXI@Z 0064 ?c_str@locale@std@@QBEPBDXZ 006d ??0_Locinfo@std@@QAE@PBD@Z 008f ??0?$numpunct@_W@std@@QAE@ABV_Locinfo@1@I_N@Z 00cb ??1_Locinfo@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 4C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 C7 45 F0 00 00 00 00 83 7D 08 00 0F 84 99 00 00 00 8B 45 08 83 38 00 0F 85 8D 00 00 00 6A 18 E8 ?? ?? ?? ?? 83 C4 04 89 45 EC C7 45 FC 00 00 00 00 83 7D EC 00 74 3C 6A 01 6A 00 8B 4D 0C E8 ?? ?? ?? ?? 50 8D 4D A8 E8 ?? ?? ?? ?? 89 45 E4 8B 4D E4 89 4D E0 C6 45 FC 01 8B 55 F0 83 CA 01 89 55 F0 8B 45 E0 50 8B 4D EC E8 ?? ?? ?? ?? 89 45 E8 EB 07 C7 45 E8 00 00 00 00 8B 4D E8 89 4D DC C7 45 FC 02 00 00 00 8B 55 08 8B 45 DC 89 02 C7 45 FC FF FF FF FF 8B 4D F0 83 E1 01 74 0C 83 65 F0 FE 8D 4D A8 E8 ?? ?? ?? ?? B8 04 00 00 00 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_3_211_1 {
	meta:
		name = "?_Getctype@_Locinfo@std@@QBE?AU_Ctypevec@@XZ"
		size = 79
		refs = "000e __Getctype"
	strings:
		$1 = { 55 8B EC 83 EC 24 89 4D FC 8D 45 DC 50 E8 ?? ?? ?? ?? 83 C4 04 8B 08 89 4D EC 8B 50 04 89 55 F0 8B 48 08 89 4D F4 8B 50 0C 89 55 F8 8B 45 08 8B 4D EC 89 08 8B 55 F0 89 50 04 8B 4D F4 89 48 08 8B 55 F8 89 50 0C 8B 45 08 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_3_212_1 {
	meta:
		name = "?_Getcvt@_Locinfo@std@@QBE?AU_Cvtvec@@XZ"
		size = 79
		refs = "0007 ___security_cookie 001a __Getcvt 0045 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 60 A1 ?? ?? ?? ?? 33 C5 89 45 FC 56 57 89 4D CC 8D 45 A0 50 E8 ?? ?? ?? ?? 83 C4 04 B9 0B 00 00 00 8B F0 8D 7D D0 F3 A5 B9 0B 00 00 00 8D 75 D0 8B 7D 08 F3 A5 8B 45 08 5F 5E 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_3_213_1 {
	meta:
		name = "?_Getfacet@locale@std@@QBEPBVfacet@12@I@Z"
		size = 135
		refs = "0054 ?_Getgloballocale@locale@std@@CAPAV_Locimp@12@XZ"
	strings:
		$1 = { 55 8B EC 83 EC 14 89 4D FC 8B 45 FC 8B 48 04 8B 55 08 3B 51 0C 73 14 8B 45 FC 8B 48 04 8B 51 08 8B 45 08 8B 0C 82 89 4D F8 EB 07 C7 45 F8 00 00 00 00 8B 55 F8 89 55 F4 83 7D F4 00 75 0E 8B 45 FC 8B 48 04 0F B6 51 14 85 D2 75 07 8B 45 F4 EB 30 EB 2E E8 ?? ?? ?? ?? 89 45 F0 8B 45 F0 8B 4D 08 3B 48 0C 73 11 8B 55 F0 8B 42 08 8B 4D 08 8B 14 88 89 55 EC EB 07 C7 45 EC 00 00 00 00 8B 45 EC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_3_214_1 {
	meta:
		name = "?_Getfalse@_Locinfo@std@@QBEPBDXZ"
		size = 16
		refs = "0008 ??_C@_05LAPONLG@false?$AA@"
		altNames = "?do_encoding@codecvt_base@std@@MBEHXZ ?do_max_length@?$codecvt@GDU_Mbstatet@@@std@@MBEHXZ ?do_max_length@?$codecvt@_WDU_Mbstatet@@@std@@MBEHXZ ?do_max_length@codecvt_base@std@@MBEHXZ ?length@charNode@@UBEHXZ ?max_size@?$allocator@G@std@@QBEIXZ ?max_size@?$allocator@_W@std@@QBEIXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC B8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_29_848_1 {
	meta:
		name = "?_Gettrue@_Locinfo@std@@QBEPBDXZ"
		size = 16
		refs = "0008 ??_C@_04LOAJBDKD@true?$AA@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC B8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_59_223_3 {
	meta:
		name = "?name@_Generic_error_category@std@@UBEPBDXZ"
		size = 16
		refs = "0008 ??_C@_07DCLBNMLN@generic?$AA@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC B8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_85_428_3 {
	meta:
		name = "?name@_Iostream_error_category@std@@UBEPBDXZ"
		size = 16
		refs = "0008 ??_C@_08LLGCOLLL@iostream?$AA@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC B8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_74_188_1 {
	meta:
		name = "?name@_System_error_category@std@@UBEPBDXZ"
		size = 16
		refs = "0008 ??_C@_06FHFOAHML@system?$AA@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC B8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_79_53_3 {
	meta:
		name = "?what@bad_function_call@std@@UBEPBDXZ"
		size = 16
		refs = "0008 ??_C@_0BC@DPJNKNAF@bad?5function?5call?$AA@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC B8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_3_215_1 {
	meta:
		name = "?_Getffld@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@1AAVios_base@2@PAH@Z"
		size = 2275
		refs = "0006 __ehhandler$?_Getffld@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@1AAVios_base@2@PAH@Z 0018 ___security_cookie 0030 ?flags@ios_base@std@@QBEHXZ 0059 ?_Getffldx@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@1AAVios_base@2@PAH@Z 0070 ?getloc@ios_base@std@@QBE?AVlocale@2@XZ 0095 ??$use_facet@V?$numpunct@D@std@@@std@@YAABV?$numpunct@D@0@ABVlocale@0@@Z 00ad ??1locale@std@@QAE@XZ 00b9 ?grouping@?$numpunct@D@std@@QBE?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ 00ff ??$use_facet@V?$ctype@D@std@@@std@@YAABV?$ctype@D@0@ABVlocale@0@@Z 0129 ?_Src@?1??_Getffld@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@DU?$char_traits@D@std@@@3@1AAVios_base@3@PAH@Z@4QBDB 0143 ?widen@?$ctype@D@std@@QBEPBDPBD0PAD@Z 0150 ??$?8DU?$char_traits@D@std@@@std@@YA_NABV?$istreambuf_iterator@DU?$char_traits@D@std@@@0@0@Z 0164 ??D?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@QBEDXZ 018f ??E?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@QAEAAV01@XZ 0222 ??A?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBEABDI@Z 0259 ??$?9DU?$char_traits@D@std@@@std@@YA_NABV?$istreambuf_iterator@DU?$char_traits@D@std@@@0@0@Z 0278 ??$_Find_elem@D@std@@YAIPADD@Z 02e1 ?size@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBEIXZ 02f3 ?thousands_sep@?$numpunct@D@std@@QBEDXZ 0308 ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@ID@Z 03b8 ??A?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAADI@Z 0425 ?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAAV12@ID@Z 04f0 ??1?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@XZ 051a ?decimal_point@?$numpunct@D@std@@QBEDXZ 0526 _localeconv 08db @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 81 EC A8 00 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 F0 56 50 8D 45 F4 64 A3 00 00 00 00 8B 4D 18 E8 ?? ?? ?? ?? 25 00 30 00 00 3D 00 30 00 00 75 25 8B 45 1C 50 8B 4D 18 51 8B 55 14 52 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 18 E9 64 08 00 00 8D 85 54 FF FF FF 50 8B 4D 18 E8 ?? ?? ?? ?? 89 85 70 FF FF FF 8B 8D 70 FF FF FF 89 8D 6C FF FF FF C7 45 FC 00 00 00 00 8B 95 6C FF FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 89 45 84 C7 45 FC FF FF FF FF 8D 8D 54 FF FF FF E8 ?? ?? ?? ?? 8D 45 B0 50 8B 4D 84 E8 ?? ?? ?? ?? C7 45 FC 01 00 00 00 8B 4D 0C 89 4D A8 C6 45 A6 00 C6 45 A7 00 8D 95 4C FF FF FF 52 8B 4D 18 E8 ?? ?? ?? ?? 89 85 68 FF FF FF 8B 85 68 FF FF FF 89 85 64 FF FF FF C6 45 FC 02 8B 8D 64 FF FF FF 51 E8 ?? ?? ?? ?? 83 C4 04 89 85 60 FF FF FF C6 45 FC 01 8D 8D 4C FF FF FF E8 ?? ?? ?? ?? 8D 55 E0 52 B8 01 00 00 00 6B C8 0F 81 C1 ?? ?? ?? ?? 51 BA 01 00 00 00 6B C2 00 05 ?? ?? ?? ?? 50 8B 8D 60 FF FF FF E8 ?? ?? ?? ?? 8B 4D 14 51 8B 55 10 52 E8 ?? ?? ?? ?? 83 C4 08 0F B6 C0 85 C0 74 02 EB 68 8B 4D 10 E8 ?? ?? ?? ?? 0F BE C8 BA 01 00 00 00 6B C2 0B 0F BE 54 05 E0 3B CA 75 19 8B 45 A8 C6 00 2B 8B 4D A8 83 C1 01 89 4D A8 8B 4D 10 E8 ?? ?? ?? ?? EB 33 8B 4D 10 E8 ?? ?? ?? ?? 0F BE D0 B8 01 00 00 00 6B C8 0A 0F BE 44 0D E0 3B D0 75 17 8B 4D A8 C6 01 2D 8B 55 A8 83 C2 01 89 55 A8 8B 4D 10 E8 ?? ?? ?? ?? 8B 45 A8 89 85 74 FF FF FF 8B 4D A8 C6 01 30 8B 55 A8 83 C2 01 89 55 A8 C6 45 AF 00 C7 45 98 00 00 00 00 C7 45 94 00 00 00 00 8B 45 1C 81 38 00 CA 9A 3B 75 0C C7 85 7C FF FF FF 00 03 00 00 EB 0A C7 85 7C FF FF FF 24 00 00 00 8B 8D 7C FF FF FF 89 4D 80 6A 00 8D 4D B0 E8 ?? ?? ?? ?? 89 45 88 8B 55 88 0F BE 02 83 F8 7F 74 0E 8B 4D 88 0F BE 11 85 D2 0F 8F 9B 00 00 00 EB 0C C6 45 AF 01 8B 4D 10 E8 ?? ?? ?? ?? 8B 45 14 50 8B 4D 10 51 E8 ?? ?? ?? ?? 83 C4 08 0F B6 D0 85 D2 74 71 8B 4D 10 E8 ?? ?? ?? ?? 0F B6 C0 50 8D 4D E0 51 E8 ?? ?? ?? ?? 83 C4 08 89 45 9C 83 7D 9C 0A 73 50 8B 55 80 3B 55 98 7F 15 8B 45 94 83 C0 01 89 45 94 83 7D 9C 00 76 04 C6 45 A7 01 EB 2E 83 7D 9C 00 75 08 83 7D 98 00 75 02 EB 20 8B 4D A8 8B 55 9C 8A 82 ?? ?? ?? ?? 88 01 8B 4D A8 83 C1 01 89 4D A8 8B 55 98 83 C2 01 89 55 98 E9 6C FF FF FF E9 17 02 00 00 8D 4D B0 E8 ?? ?? ?? ?? 85 C0 75 06 C6 45 93 00 EB 0B 8B 4D 84 E8 ?? ?? ?? ?? 88 45 93 8A 45 93 88 45 92 6A 00 6A 01 8D 4D C8 E8 ?? ?? ?? ?? C6 45 FC 03 C7 45 A0 00 00 00 00 EB 08 8B 4D 10 E8 ?? ?? ?? ?? 8B 4D 14 51 8B 55 10 52 E8 ?? ?? ?? ?? 83 C4 08 0F B6 C0 85 C0 0F 84 FB 00 00 00 8B 4D 10 E8 ?? ?? ?? ?? 0F B6 C8 51 8D 55 E0 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 9C 83 7D 9C 0A 0F 83 8A 00 00 00 C6 45 AF 01 8B 45 80 3B 45 98 7F 15 8B 4D 94 83 C1 01 89 4D 94 83 7D 9C 00 76 04 C6 45 A7 01 EB 2E 83 7D 9C 00 75 08 83 7D 98 00 75 02 EB 20 8B 55 A8 8B 45 9C 8A 88 ?? ?? ?? ?? 88 0A 8B 55 A8 83 C2 01 89 55 A8 8B 45 98 83 C0 01 89 45 98 8B 4D A0 51 8D 4D C8 E8 ?? ?? ?? ?? 0F BE 10 83 FA 7F 74 25 8B 45 A0 50 8D 4D C8 E8 ?? ?? ?? ?? 89 85 78 FF FF FF 8B 8D 78 FF FF FF 8A 11 80 C2 01 8B 85 78 FF FF FF 88 10 EB 47 8B 4D A0 51 8D 4D C8 E8 ?? ?? ?? ?? 0F BE 10 85 D2 74 1B 0F BE 45 92 85 C0 74 13 8B 4D 10 E8 ?? ?? ?? ?? 0F BE C8 0F BE 55 92 3B CA 74 04 EB 1C EB 15 6A 00 6A 01 8D 4D C8 E8 ?? ?? ?? ?? 8B 45 A0 83 C0 01 89 45 A0 E9 E2 FE FF FF 83 7D A0 00 75 02 EB 22 8B 4D A0 51 8D 4D C8 E8 ?? ?? ?? ?? 0F BE 10 85 D2 7E 0B 8B 45 A0 83 C0 01 89 45 A0 EB 04 C6 45 A6 01 0F B6 4D A6 85 C9 75 7F 83 7D A0 00 76 79 8B 55 88 0F BE 02 83 F8 7F 75 04 EB 6C EB 65 8B 4D A0 83 E9 01 89 4D A0 74 19 8B 55 88 0F BE 32 8B 45 A0 50 8D 4D C8 E8 ?? ?? ?? ?? 0F BE 08 3B F1 75 1F 83 7D A0 00 75 1F 8B 55 88 0F BE 32 8B 45 A0 50 8D 4D C8 E8 ?? ?? ?? ?? 0F BE 08 3B F1 7D 06 C6 45 A6 01 EB 1C BA 01 00 00 00 C1 E2 00 8B 45 88 0F BE 0C 10 85 C9 7E 09 8B 55 88 83 C2 01 89 55 88 E9 79 FF FF FF C6 45 FC 01 8D 4D C8 E8 ?? ?? ?? ?? 8B 45 14 50 8B 4D 10 51 E8 ?? ?? ?? ?? 83 C4 08 0F B6 D0 85 D2 74 42 8B 4D 10 E8 ?? ?? ?? ?? 0F BE F0 8B 4D 84 E8 ?? ?? ?? ?? 0F BE C0 3B F0 75 28 E8 ?? ?? ?? ?? B9 01 00 00 00 6B D1 00 8B 00 8B 4D A8 8A 14 02 88 11 8B 45 A8 83 C0 01 89 45 A8 8B 4D 10 E8 ?? ?? ?? ?? 8B 4D 1C 81 39 00 CA 9A 3B 74 70 83 7D 98 00 75 6A EB 0C C6 45 AF 01 8B 4D 10 E8 ?? ?? ?? ?? 8B 55 14 52 8B 45 10 50 E8 ?? ?? ?? ?? 83 C4 08 0F B6 C8 85 C9 74 27 8B 4D 10 E8 ?? ?? ?? ?? 0F BE D0 B8 01 00 00 00 6B C8 00 0F BE 44 0D E0 3B D0 75 0B 8B 4D 94 83 E9 01 89 4D 94 EB B6 83 7D 94 00 7D 18 8B 55 A8 C6 02 30 8B 45 A8 83 C0 01 89 45 A8 8B 4D 94 83 C1 01 89 4D 94 EB 0C C6 45 AF 01 8B 4D 10 E8 ?? ?? ?? ?? 8B 55 14 52 8B 45 10 50 E8 ?? ?? ?? ?? 83 C4 08 0F B6 C8 85 C9 74 57 8B 4D 10 E8 ?? ?? ?? ?? 0F B6 D0 52 8D 45 E0 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 9C 83 7D 9C 0A 73 36 8B 4D 98 3B 4D 80 7D 22 8B 55 A8 8B 45 9C 8A 88 ?? ?? ?? ?? 88 0A 8B 55 A8 83 C2 01 89 55 A8 8B 45 98 83 C0 01 89 45 98 EB 0A 83 7D 9C 00 76 04 C6 45 A7 01 EB 86 0F B6 4D A7 85 C9 74 77 8B 55 A8 89 55 8C 8B 45 8C 83 E8 01 89 45 8C 8B 4D 8C 3B 8D 74 FF FF FF 74 43 8B 55 8C 0F BE 32 E8 ?? ?? ?? ?? B9 01 00 00 00 6B D1 00 8B 00 0F BE 0C 10 3B F1 75 02 EB 22 8B 55 8C 0F BE 02 83 F8 39 74 11 8B 4D 8C 8A 11 80 C2 01 8B 45 8C 88 10 EB 0A EB 06 8B 4D 8C C6 01 30 EB A9 8B 55 8C 3B 95 74 FF FF FF 75 0F 8B 45 8C C6 00 31 8B 4D 94 83 C1 01 89 4D 94 0F B6 55 AF 85 D2 0F 84 C0 01 00 00 8B 45 14 50 8B 4D 10 51 E8 ?? ?? ?? ?? 83 C4 08 0F B6 D0 85 D2 0F 84 A5 01 00 00 8B 4D 10 E8 ?? ?? ?? ?? 0F BE C0 B9 01 00 00 00 6B D1 0D 0F BE 4C 15 E0 3B C1 74 20 8B 4D 10 E8 ?? ?? ?? ?? 0F BE D0 B8 01 00 00 00 6B C8 0C 0F BE 44 0D E0 3B D0 0F 85 69 01 00 00 8B 4D A8 C6 01 65 8B 55 A8 83 C2 01 89 55 A8 8B 4D 10 E8 ?? ?? ?? ?? C6 45 AF 00 C7 45 98 00 00 00 00 8B 45 14 50 8B 4D 10 51 E8 ?? ?? ?? ?? 83 C4 08 0F B6 D0 85 D2 74 02 EB 68 8B 4D 10 E8 ?? ?? ?? ?? 0F BE C0 B9 01 00 00 00 6B D1 0B 0F BE 4C 15 E0 3B C1 75 19 8B 55 A8 C6 02 2B 8B 45 A8 83 C0 01 89 45 A8 8B 4D 10 E8 ?? ?? ?? ?? EB 33 8B 4D 10 E8 ?? ?? ?? ?? 0F BE C8 BA 01 00 00 00 6B C2 0A 0F BE 54 05 E0 3B CA 75 17 8B 45 A8 C6 00 2D 8B 4D A8 83 C1 01 89 4D A8 8B 4D 10 E8 ?? ?? ?? ?? 8B 55 14 52 8B 45 10 50 E8 ?? ?? ?? ?? 83 C4 08 0F B6 C8 85 C9 74 2A 8B 4D 10 E8 ?? ?? ?? ?? 0F BE D0 B8 01 00 00 00 6B C8 00 0F BE 44 0D E0 3B D0 75 0E C6 45 AF 01 8B 4D 10 E8 ?? ?? ?? ?? EB BF 0F B6 4D AF 85 C9 74 0F 8B 55 A8 C6 02 30 8B 45 A8 83 C0 01 89 45 A8 EB 0C C6 45 AF 01 8B 4D 10 E8 ?? ?? ?? ?? 8B 4D 14 51 8B 55 10 52 E8 ?? ?? ?? ?? 83 C4 08 0F B6 C0 85 C0 74 49 8B 4D 10 E8 ?? ?? ?? ?? 0F B6 C8 51 8D 55 E0 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 9C 83 7D 9C 0A 73 28 83 7D 98 08 7D 20 8B 45 A8 8B 4D 9C 8A 91 ?? ?? ?? ?? 88 10 8B 45 A8 83 C0 01 89 45 A8 8B 4D 98 83 C1 01 89 4D 98 EB 94 0F B6 55 A6 85 D2 75 08 0F B6 45 AF 85 C0 75 06 8B 4D 0C 89 4D A8 8B 55 A8 C6 02 00 8B 45 94 89 85 5C FF FF FF C7 45 FC FF FF FF FF 8D 4D B0 E8 ?? ?? ?? ?? 8B 85 5C FF FF FF 8B 4D F4 64 89 0D 00 00 00 00 59 5E 8B 4D F0 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_3_220_1 {
	meta:
		name = "__ehhandler$?_Getffld@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@1AAVios_base@2@PAH@Z"
		size = 40
		refs = "0010 @__security_check_cookie@4 001f __ehfuncinfo$?_Getffld@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@1AAVios_base@2@PAH@Z 0024 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 8A 50 FF FF FF 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_3_221_1 {
	meta:
		name = "?_Getffldx@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@1AAVios_base@2@PAH@Z"
		size = 2298
		refs = "0006 __ehhandler$?_Getffldx@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@1AAVios_base@2@PAH@Z 0018 ___security_cookie 0037 ?getloc@ios_base@std@@QBE?AVlocale@2@XZ 005c ??$use_facet@V?$numpunct@D@std@@@std@@YAABV?$numpunct@D@0@ABVlocale@0@@Z 0077 ??1locale@std@@QAE@XZ 0086 ?grouping@?$numpunct@D@std@@QBE?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ 00be ??$use_facet@V?$ctype@D@std@@@std@@YAABV?$ctype@D@0@ABVlocale@0@@Z 00e7 ?_Src@?1??_Getffldx@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@DU?$char_traits@D@std@@@3@1AAVios_base@3@PAH@Z@4QBDB 0102 ?widen@?$ctype@D@std@@QBEPBDPBD0PAD@Z 0119 ??$?8DU?$char_traits@D@std@@@std@@YA_NABV?$istreambuf_iterator@DU?$char_traits@D@std@@@0@0@Z 012d ??D?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@QBEDXZ 0158 ??E?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@QAEAAV01@XZ 0204 ??$?9DU?$char_traits@D@std@@@std@@YA_NABV?$istreambuf_iterator@DU?$char_traits@D@std@@@0@0@Z 028b ??A?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBEABDI@Z 02ea ??$_Find_elem@D@std@@YAIPADD@Z 034c ?size@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBEIXZ 0361 ?thousands_sep@?$numpunct@D@std@@QBEDXZ 0376 ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@ID@Z 041f ??A?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAADI@Z 048c ?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAAV12@ID@Z 0571 ??1?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@XZ 05bb ?decimal_point@?$numpunct@D@std@@QBEDXZ 05c7 _localeconv 08f2 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 81 EC B0 00 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 F0 56 50 8D 45 F4 64 A3 00 00 00 00 8D 85 4C FF FF FF 50 8B 4D 18 E8 ?? ?? ?? ?? 89 85 68 FF FF FF 8B 8D 68 FF FF FF 89 8D 64 FF FF FF C7 45 FC 00 00 00 00 8B 95 64 FF FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 89 85 78 FF FF FF C7 45 FC FF FF FF FF 8D 8D 4C FF FF FF E8 ?? ?? ?? ?? 8D 45 A0 50 8B 8D 78 FF FF FF E8 ?? ?? ?? ?? C7 45 FC 01 00 00 00 8D 8D 44 FF FF FF 51 8B 4D 18 E8 ?? ?? ?? ?? 89 85 60 FF FF FF 8B 95 60 FF FF FF 89 95 5C FF FF FF C6 45 FC 02 8B 85 5C FF FF FF 50 E8 ?? ?? ?? ?? 83 C4 04 89 85 58 FF FF FF C6 45 FC 01 8D 8D 44 FF FF FF E8 ?? ?? ?? ?? 8D 4D D0 51 BA 01 00 00 00 6B C2 1D 05 ?? ?? ?? ?? 50 B9 01 00 00 00 6B D1 00 81 C2 ?? ?? ?? ?? 52 8B 8D 58 FF FF FF E8 ?? ?? ?? ?? 8B 45 0C 89 45 98 C6 45 97 00 8B 4D 14 51 8B 55 10 52 E8 ?? ?? ?? ?? 83 C4 08 0F B6 C0 85 C0 74 02 EB 68 8B 4D 10 E8 ?? ?? ?? ?? 0F BE C8 BA 01 00 00 00 6B C2 17 0F BE 54 05 D0 3B CA 75 19 8B 45 98 C6 00 2B 8B 4D 98 83 C1 01 89 4D 98 8B 4D 10 E8 ?? ?? ?? ?? EB 33 8B 4D 10 E8 ?? ?? ?? ?? 0F BE D0 B8 01 00 00 00 6B C8 16 0F BE 44 0D D0 3B D0 75 17 8B 4D 98 C6 01 2D 8B 55 98 83 C2 01 89 55 98 8B 4D 10 E8 ?? ?? ?? ?? 8B 45 98 C6 00 30 8B 4D 98 83 C1 01 89 4D 98 8B 55 98 C6 02 78 8B 45 98 83 C0 01 89 45 98 C6 45 9F 00 C7 45 90 00 00 00 00 C7 45 80 00 00 00 00 8B 4D 14 51 8B 55 10 52 E8 ?? ?? ?? ?? 83 C4 08 0F B6 C0 85 C0 75 1C 8B 4D 10 E8 ?? ?? ?? ?? 0F BE C8 BA 01 00 00 00 6B C2 00 0F BE 54 05 D0 3B CA 74 02 EB 62 8B 45 14 50 8B 4D 10 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 08 0F B6 C8 85 C9 74 42 8B 4D 10 E8 ?? ?? ?? ?? 0F BE D0 B8 01 00 00 00 6B C8 19 0F BE 44 0D D0 3B D0 74 1C 8B 4D 10 E8 ?? ?? ?? ?? 0F BE C8 BA 01 00 00 00 6B C2 18 0F BE 54 05 D0 3B CA 75 0A 8B 4D 10 E8 ?? ?? ?? ?? EB 04 C6 45 9F 01 8B 45 1C 81 38 00 CA 9A 3B 75 0C C7 85 70 FF FF FF 00 03 00 00 EB 0A C7 85 70 FF FF FF 24 00 00 00 8B 8D 70 FF FF FF 89 8D 74 FF FF FF 6A 00 8D 4D A0 E8 ?? ?? ?? ?? 89 85 7C FF FF FF 8B 95 7C FF FF FF 0F BE 02 83 F8 7F 74 11 8B 8D 7C FF FF FF 0F BE 11 85 D2 0F 8F 94 00 00 00 EB 0C C6 45 9F 01 8B 4D 10 E8 ?? ?? ?? ?? 8B 45 14 50 8B 4D 10 51 E8 ?? ?? ?? ?? 83 C4 08 0F B6 D0 85 D2 74 6A 8B 4D 10 E8 ?? ?? ?? ?? 0F B6 C0 50 8D 4D D0 51 E8 ?? ?? ?? ?? 83 C4 08 89 45 88 83 7D 88 16 73 49 8B 95 74 FF FF FF 3B 55 90 7F 0B 8B 45 80 83 C0 01 89 45 80 EB 2E 83 7D 88 00 75 08 83 7D 90 00 75 02 EB 20 8B 4D 98 8B 55 88 8A 82 ?? ?? ?? ?? 88 01 8B 4D 98 83 C1 01 89 4D 98 8B 55 90 83 C2 01 89 55 90 E9 73 FF FF FF E9 2D 02 00 00 8D 4D A0 E8 ?? ?? ?? ?? 85 C0 75 06 C6 45 87 00 EB 0E 8B 8D 78 FF FF FF E8 ?? ?? ?? ?? 88 45 87 8A 45 87 88 45 86 6A 00 6A 01 8D 4D B8 E8 ?? ?? ?? ?? C6 45 FC 03 C7 45 8C 00 00 00 00 EB 08 8B 4D 10 E8 ?? ?? ?? ?? 8B 4D 14 51 8B 55 10 52 E8 ?? ?? ?? ?? 83 C4 08 0F B6 C0 85 C0 0F 84 F4 00 00 00 8B 4D 10 E8 ?? ?? ?? ?? 0F B6 C8 51 8D 55 D0 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 88 83 7D 88 16 0F 83 83 00 00 00 C6 45 9F 01 8B 85 74 FF FF FF 3B 45 90 7F 0B 8B 4D 80 83 C1 01 89 4D 80 EB 2E 83 7D 88 00 75 08 83 7D 90 00 75 02 EB 20 8B 55 98 8B 45 88 8A 88 ?? ?? ?? ?? 88 0A 8B 55 98 83 C2 01 89 55 98 8B 45 90 83 C0 01 89 45 90 8B 4D 8C 51 8D 4D B8 E8 ?? ?? ?? ?? 0F BE 10 83 FA 7F 74 25 8B 45 8C 50 8D 4D B8 E8 ?? ?? ?? ?? 89 85 6C FF FF FF 8B 8D 6C FF FF FF 8A 11 80 C2 01 8B 85 6C FF FF FF 88 10 EB 47 8B 4D 8C 51 8D 4D B8 E8 ?? ?? ?? ?? 0F BE 10 85 D2 74 1B 0F BE 45 86 85 C0 74 13 8B 4D 10 E8 ?? ?? ?? ?? 0F BE C8 0F BE 55 86 3B CA 74 04 EB 1C EB 15 6A 00 6A 01 8D 4D B8 E8 ?? ?? ?? ?? 8B 45 8C 83 C0 01 89 45 8C E9 E9 FE FF FF 83 7D 8C 00 75 02 EB 22 8B 4D 8C 51 8D 4D B8 E8 ?? ?? ?? ?? 0F BE 10 85 D2 7E 0B 8B 45 8C 83 C0 01 89 45 8C EB 04 C6 45 97 01 0F B6 4D 97 85 C9 0F 85 95 00 00 00 83 7D 8C 00 0F 86 8B 00 00 00 8B 95 7C FF FF FF 0F BE 02 83 F8 7F 75 04 EB 7B EB 74 8B 4D 8C 83 E9 01 89 4D 8C 74 1C 8B 95 7C FF FF FF 0F BE 32 8B 45 8C 50 8D 4D B8 E8 ?? ?? ?? ?? 0F BE 08 3B F1 75 22 83 7D 8C 00 75 22 8B 95 7C FF FF FF 0F BE 32 8B 45 8C 50 8D 4D B8 E8 ?? ?? ?? ?? 0F BE 08 3B F1 7D 06 C6 45 97 01 EB 25 BA 01 00 00 00 C1 E2 00 8B 85 7C FF FF FF 0F BE 0C 10 85 C9 7E 0F 8B 95 7C FF FF FF 83 C2 01 89 95 7C FF FF FF E9 5F FF FF FF C6 45 FC 01 8D 4D B8 E8 ?? ?? ?? ?? 0F B6 45 9F 85 C0 74 15 83 7D 90 00 75 0F 8B 4D 98 C6 01 30 8B 55 98 83 C2 01 89 55 98 8B 45 14 50 8B 4D 10 51 E8 ?? ?? ?? ?? 83 C4 08 0F B6 D0 85 D2 74 45 8B 4D 10 E8 ?? ?? ?? ?? 0F BE F0 8B 8D 78 FF FF FF E8 ?? ?? ?? ?? 0F BE C0 3B F0 75 28 E8 ?? ?? ?? ?? B9 01 00 00 00 6B D1 00 8B 00 8B 4D 98 8A 14 02 88 11 8B 45 98 83 C0 01 89 45 98 8B 4D 10 E8 ?? ?? ?? ?? 83 7D 90 00 75 6A EB 0C C6 45 9F 01 8B 4D 10 E8 ?? ?? ?? ?? 8B 4D 14 51 8B 55 10 52 E8 ?? ?? ?? ?? 83 C4 08 0F B6 C0 85 C0 74 27 8B 4D 10 E8 ?? ?? ?? ?? 0F BE C8 BA 01 00 00 00 6B C2 00 0F BE 54 05 D0 3B CA 75 0B 8B 45 80 83 E8 01 89 45 80 EB B6 83 7D 80 00 7D 18 8B 4D 98 C6 01 30 8B 55 98 83 C2 01 89 55 98 8B 45 80 83 C0 01 89 45 80 EB 0C C6 45 9F 01 8B 4D 10 E8 ?? ?? ?? ?? 8B 4D 14 51 8B 55 10 52 E8 ?? ?? ?? ?? 83 C4 08 0F B6 C0 85 C0 74 4E 8B 4D 10 E8 ?? ?? ?? ?? 0F B6 C8 51 8D 55 D0 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 88 83 7D 88 16 73 2D 8B 45 90 3B 85 74 FF FF FF 7D 20 8B 4D 98 8B 55 88 8A 82 ?? ?? ?? ?? 88 01 8B 4D 98 83 C1 01 89 4D 98 8B 55 90 83 C2 01 89 55 90 EB 8F 0F B6 45 9F 85 C0 0F 84 C0 01 00 00 8B 4D 14 51 8B 55 10 52 E8 ?? ?? ?? ?? 83 C4 08 0F B6 C0 85 C0 0F 84 A5 01 00 00 8B 4D 10 E8 ?? ?? ?? ?? 0F BE C8 BA 01 00 00 00 6B C2 1B 0F BE 54 05 D0 3B CA 74 20 8B 4D 10 E8 ?? ?? ?? ?? 0F BE C0 B9 01 00 00 00 6B D1 1A 0F BE 4C 15 D0 3B C1 0F 85 69 01 00 00 8B 55 98 C6 02 70 8B 45 98 83 C0 01 89 45 98 8B 4D 10 E8 ?? ?? ?? ?? C6 45 9F 00 C7 45 90 00 00 00 00 8B 4D 14 51 8B 55 10 52 E8 ?? ?? ?? ?? 83 C4 08 0F B6 C0 85 C0 74 02 EB 68 8B 4D 10 E8 ?? ?? ?? ?? 0F BE C8 BA 01 00 00 00 6B C2 17 0F BE 54 05 D0 3B CA 75 19 8B 45 98 C6 00 2B 8B 4D 98 83 C1 01 89 4D 98 8B 4D 10 E8 ?? ?? ?? ?? EB 33 8B 4D 10 E8 ?? ?? ?? ?? 0F BE D0 B8 01 00 00 00 6B C8 16 0F BE 44 0D D0 3B D0 75 17 8B 4D 98 C6 01 2D 8B 55 98 83 C2 01 89 55 98 8B 4D 10 E8 ?? ?? ?? ?? 8B 45 14 50 8B 4D 10 51 E8 ?? ?? ?? ?? 83 C4 08 0F B6 D0 85 D2 74 2A 8B 4D 10 E8 ?? ?? ?? ?? 0F BE C0 B9 01 00 00 00 6B D1 00 0F BE 4C 15 D0 3B C1 75 0E C6 45 9F 01 8B 4D 10 E8 ?? ?? ?? ?? EB BF 0F B6 55 9F 85 D2 74 0F 8B 45 98 C6 00 30 8B 4D 98 83 C1 01 89 4D 98 EB 0C C6 45 9F 01 8B 4D 10 E8 ?? ?? ?? ?? 8B 55 14 52 8B 45 10 50 E8 ?? ?? ?? ?? 83 C4 08 0F B6 C8 85 C9 74 49 8B 4D 10 E8 ?? ?? ?? ?? 0F B6 D0 52 8D 45 D0 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 88 83 7D 88 16 73 28 83 7D 90 08 7D 20 8B 4D 98 8B 55 88 8A 82 ?? ?? ?? ?? 88 01 8B 4D 98 83 C1 01 89 4D 98 8B 55 90 83 C2 01 89 55 90 EB 94 0F B6 45 97 85 C0 75 08 0F B6 4D 9F 85 C9 75 06 8B 55 0C 89 55 98 8B 45 98 C6 00 00 8B 4D 1C 8B 55 80 89 11 C7 85 54 FF FF FF 00 00 00 00 C7 45 FC FF FF FF FF 8D 4D A0 E8 ?? ?? ?? ?? 8B 85 54 FF FF FF 8B 4D F4 64 89 0D 00 00 00 00 59 5E 8B 4D F0 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_3_226_1 {
	meta:
		name = "__ehhandler$?_Getffldx@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@1AAVios_base@2@PAH@Z"
		size = 40
		refs = "0010 @__security_check_cookie@4 001f __ehfuncinfo$?_Getffldx@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@1AAVios_base@2@PAH@Z 0024 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 8A 48 FF FF FF 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_110_243_2 {
	meta:
		name = "__ehhandler$?_Getffld@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@1AAVios_base@2@PAH@Z"
		size = 40
		refs = "0010 @__security_check_cookie@4 001f __ehfuncinfo$?_Getffld@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@1AAVios_base@2@PAH@Z 0024 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 8A 48 FF FF FF 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_3_227_1 {
	meta:
		name = "?_Getifld@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@1HABVlocale@2@@Z"
		size = 1319
		refs = "0006 __ehhandler$?_Getifld@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@1HABVlocale@2@@Z 0018 ___security_cookie 0031 ??$use_facet@V?$numpunct@D@std@@@std@@YAABV?$numpunct@D@0@ABVlocale@0@@Z 0043 ?grouping@?$numpunct@D@std@@QBE?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ 0052 ?size@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBEIXZ 0064 ?thousands_sep@?$numpunct@D@std@@QBEDXZ 0076 ??$use_facet@V?$ctype@D@std@@@std@@YAABV?$ctype@D@0@ABVlocale@0@@Z 0090 ?_Src@?1??_Getifld@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@DU?$char_traits@D@std@@@3@1HABVlocale@3@@Z@4QBDB 00ab ?widen@?$ctype@D@std@@QBEPBDPBD0PAD@Z 00be ??$?8DU?$char_traits@D@std@@@std@@YA_NABV?$istreambuf_iterator@DU?$char_traits@D@std@@@0@0@Z 00d2 ??D?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@QBEDXZ 00fd ??E?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@QAEAAV01@XZ 01a7 ??$?9DU?$char_traits@D@std@@@std@@YA_NABV?$istreambuf_iterator@DU?$char_traits@D@std@@@0@0@Z 02b9 ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@ID@Z 030f ??$_Find_elem@D@std@@YAIPADD@Z 0372 ??A?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAADI@Z 03de ?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAAV12@ID@Z 0420 ??A?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBEABDI@Z 04f4 ??1?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@XZ 051f @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 81 EC 98 00 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 F0 56 50 8D 45 F4 64 A3 00 00 00 00 8B 45 1C 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 88 8D 4D A4 51 8B 4D 88 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8D 4D A4 E8 ?? ?? ?? ?? 85 C0 75 06 C6 45 96 00 EB 0B 8B 4D 88 E8 ?? ?? ?? ?? 88 45 96 8A 55 96 88 55 95 8B 45 1C 50 E8 ?? ?? ?? ?? 83 C4 04 89 85 68 FF FF FF 8D 4D D4 51 BA 01 00 00 00 6B C2 1B 05 ?? ?? ?? ?? 50 B9 01 00 00 00 6B D1 00 81 C2 ?? ?? ?? ?? 52 8B 8D 68 FF FF FF E8 ?? ?? ?? ?? 8B 45 0C 89 45 98 8B 4D 14 51 8B 55 10 52 E8 ?? ?? ?? ?? 83 C4 08 0F B6 C0 85 C0 74 02 EB 68 8B 4D 10 E8 ?? ?? ?? ?? 0F BE C8 BA 01 00 00 00 6B C2 17 0F BE 54 05 D4 3B CA 75 19 8B 45 98 C6 00 2B 8B 4D 98 83 C1 01 89 4D 98 8B 4D 10 E8 ?? ?? ?? ?? EB 33 8B 4D 10 E8 ?? ?? ?? ?? 0F BE D0 B8 01 00 00 00 6B C8 16 0F BE 44 0D D4 3B D0 75 17 8B 4D 98 C6 01 2D 8B 55 98 83 C2 01 89 55 98 8B 4D 10 E8 ?? ?? ?? ?? 8B 45 18 25 00 0E 00 00 89 45 18 81 7D 18 00 04 00 00 75 0C C7 85 7C FF FF FF 08 00 00 00 EB 37 81 7D 18 00 08 00 00 75 09 C7 45 80 10 00 00 00 EB 1C 83 7D 18 00 75 09 C7 45 84 00 00 00 00 EB 07 C7 45 84 0A 00 00 00 8B 4D 84 89 4D 80 8B 55 80 89 95 7C FF FF FF 8B 85 7C FF FF FF 89 45 90 C6 45 A3 00 C6 45 97 00 8B 4D 14 51 8B 55 10 52 E8 ?? ?? ?? ?? 83 C4 08 0F B6 C0 85 C0 0F 84 A9 00 00 00 8B 4D 10 E8 ?? ?? ?? ?? 0F BE C8 BA 01 00 00 00 6B C2 00 0F BE 54 05 D4 3B CA 0F 85 89 00 00 00 C6 45 A3 01 8B 4D 10 E8 ?? ?? ?? ?? 8B 45 14 50 8B 4D 10 51 E8 ?? ?? ?? ?? 83 C4 08 0F B6 D0 85 D2 74 59 8B 4D 10 E8 ?? ?? ?? ?? 0F BE C0 B9 01 00 00 00 6B D1 19 0F BE 4C 15 D4 3B C1 74 1C 8B 4D 10 E8 ?? ?? ?? ?? 0F BE D0 B8 01 00 00 00 6B C8 18 0F BE 44 0D D4 3B D0 75 21 83 7D 90 00 74 06 83 7D 90 10 75 15 C7 45 90 10 00 00 00 C6 45 A3 00 8B 4D 10 E8 ?? ?? ?? ?? EB 0D 83 7D 90 00 75 07 C7 45 90 08 00 00 00 83 7D 90 00 74 30 83 7D 90 0A 74 2A 83 7D 90 08 75 0C C7 85 78 FF FF FF 08 00 00 00 EB 0A C7 85 78 FF FF FF 16 00 00 00 8B 8D 78 FF FF FF 89 8D 74 FF FF FF EB 0A C7 85 74 FF FF FF 0A 00 00 00 8B 95 74 FF FF FF 89 95 64 FF FF FF 0F B6 45 A3 50 6A 01 8D 4D BC E8 ?? ?? ?? ?? C6 45 FC 01 C7 45 9C 00 00 00 00 B9 01 00 00 00 6B D1 1F 03 55 0C 89 95 60 FF FF FF EB 08 8B 4D 10 E8 ?? ?? ?? ?? 8B 45 14 50 8B 4D 10 51 E8 ?? ?? ?? ?? 83 C4 08 0F B6 D0 85 D2 0F 84 F2 00 00 00 8B 4D 10 E8 ?? ?? ?? ?? 0F B6 C0 50 8D 4D D4 51 E8 ?? ?? ?? ?? 83 C4 08 89 85 70 FF FF FF 8B 95 70 FF FF FF 3B 95 64 FF FF FF 73 7A 8B 45 98 8B 8D 70 FF FF FF 8A 91 ?? ?? ?? ?? 88 10 0F B6 45 97 85 C0 75 0B 8B 4D 98 0F BE 11 83 FA 30 74 18 8B 45 98 3B 85 60 FF FF FF 73 0D 8B 4D 98 83 C1 01 89 4D 98 C6 45 97 01 C6 45 A3 01 8B 55 9C 52 8D 4D BC E8 ?? ?? ?? ?? 0F BE 00 83 F8 7F 74 24 8B 4D 9C 51 8D 4D BC E8 ?? ?? ?? ?? 89 85 6C FF FF FF 8B 95 6C FF FF FF 8A 02 04 01 8B 8D 6C FF FF FF 88 01 EB 47 8B 55 9C 52 8D 4D BC E8 ?? ?? ?? ?? 0F BE 00 85 C0 74 1B 0F BE 4D 95 85 C9 74 13 8B 4D 10 E8 ?? ?? ?? ?? 0F BE D0 0F BE 45 95 3B D0 74 04 EB 1C EB 15 6A 00 6A 01 8D 4D BC E8 ?? ?? ?? ?? 8B 4D 9C 83 C1 01 89 4D 9C E9 EB FE FF FF 83 7D 9C 00 75 02 EB 22 8B 55 9C 52 8D 4D BC E8 ?? ?? ?? ?? 0F BE 00 85 C0 7E 0B 8B 4D 9C 83 C1 01 89 4D 9C EB 04 C6 45 A3 00 6A 00 8D 4D A4 E8 ?? ?? ?? ?? 89 45 8C 0F B6 55 A3 85 D2 74 7F 83 7D 9C 00 76 79 8B 45 8C 0F BE 08 83 F9 7F 75 04 EB 6C EB 65 8B 55 9C 83 EA 01 89 55 9C 74 19 8B 45 8C 0F BE 30 8B 4D 9C 51 8D 4D BC E8 ?? ?? ?? ?? 0F BE 10 3B F2 75 1F 83 7D 9C 00 75 1F 8B 45 8C 0F BE 30 8B 4D 9C 51 8D 4D BC E8 ?? ?? ?? ?? 0F BE 10 3B F2 7D 06 C6 45 A3 00 EB 1C B8 01 00 00 00 C1 E0 00 8B 4D 8C 0F BE 14 01 85 D2 7E 09 8B 45 8C 83 C0 01 89 45 8C E9 79 FF FF FF 0F B6 4D A3 85 C9 74 19 0F B6 55 97 85 D2 75 11 8B 45 98 C6 00 30 8B 4D 98 83 C1 01 89 4D 98 EB 0E 0F B6 55 A3 85 D2 75 06 8B 45 0C 89 45 98 8B 4D 98 C6 01 00 8B 55 90 89 95 5C FF FF FF C6 45 FC 00 8D 4D BC E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8D 4D A4 E8 ?? ?? ?? ?? 8B 85 5C FF FF FF 8B 4D F4 64 89 0D 00 00 00 00 59 5E 8B 4D F0 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_3_230_1 {
	meta:
		name = "__ehhandler$?_Getifld@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@1HABVlocale@2@@Z"
		size = 40
		refs = "0010 @__security_check_cookie@4 001f __ehfuncinfo$?_Getifld@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@1HABVlocale@2@@Z 0024 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 8A 60 FF FF FF 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_3_231_1 {
	meta:
		name = "?_Getlconv@_Locinfo@std@@QBEPBUlconv@@XZ"
		size = 16
		refs = "0008 _localeconv"
	strings:
		$1 = { 55 8B EC 51 89 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_44_877_2 {
	meta:
		name = "?_Getdateorder@_Locinfo@std@@QBEHXZ"
		size = 16
		refs = "0008 __Getdateorder"
	strings:
		$1 = { 55 8B EC 51 89 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_46_456_3 {
	meta:
		name = "?underflow@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MAEHXZ"
		size = 16
		refs = "0008 ?eof@?$char_traits@D@std@@SAHXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_118_477_3 {
	meta:
		name = "?underflow@?$basic_streambuf@GU?$char_traits@G@std@@@std@@MAEGXZ"
		size = 16
		refs = "0008 ?eof@?$char_traits@G@std@@SAGXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_4_394_1 {
	meta:
		name = "?underflow@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@MAEGXZ"
		size = 16
		refs = "0008 ?eof@?$char_traits@_W@std@@SAGXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_3_232_1 {
	meta:
		name = "?_Getname@_Locinfo@std@@QBEPBDXZ"
		size = 22
		refs = "000e ?_C_str@?$_Yarn@D@std@@QBEPBDXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC 83 C1 2C E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_3_234_1 {
	meta:
		name = "?_Gnavail@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IBE_JXZ"
		size = 48
		altNames = "?_Gnavail@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IBE_JXZ ?_Gnavail@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IBE_JXZ"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D FC 8B 45 FC 8B 48 1C 83 39 00 74 0D 8B 55 FC 8B 42 2C 8B 08 89 4D F8 EB 07 C7 45 F8 00 00 00 00 8B 45 F8 99 8B E5 5D C3 }
	condition:
		$1
}

rule file_3_235_1 {
	meta:
		name = "?_Gninc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IAEPADXZ"
		size = 65
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D FC 8B 45 FC 8B 48 2C 8B 11 83 EA 01 8B 45 FC 8B 48 2C 89 11 8B 55 FC 8B 42 1C 8B 08 89 4D F8 8B 55 FC 8B 42 1C 8B 08 83 C1 01 8B 55 FC 8B 42 1C 89 08 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_3_236_1 {
	meta:
		name = "?_Grow@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE_NI_N@Z"
		size = 183
		refs = "000d ?max_size@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBEIXZ 001a ?_Xlen@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBEXXZ 0022 ?_Myres@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAEAAIXZ 0031 ?_Mysize@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAEAAIXZ 0040 ?_Copy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEXII@Z 0082 ?_Tidy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEX_NI@Z 0094 ?_Eos@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEXI@Z"
	strings:
		$1 = { 55 8B EC 83 EC 0C 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 3B 45 08 73 08 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B 00 3B 45 08 73 19 8B 4D FC E8 ?? ?? ?? ?? 8B 08 51 8B 55 08 52 8B 4D FC E8 ?? ?? ?? ?? EB 52 0F B6 45 0C 85 C0 74 3A 83 7D 08 10 73 34 8B 4D FC E8 ?? ?? ?? ?? 8B 4D 08 3B 08 73 08 8B 55 08 89 55 F8 EB 0D 8B 4D FC E8 ?? ?? ?? ?? 8B 00 89 45 F8 8B 4D F8 51 6A 01 8B 4D FC E8 ?? ?? ?? ?? EB 10 83 7D 08 00 75 0A 6A 00 8B 4D FC E8 ?? ?? ?? ?? 83 7D 08 00 76 09 C7 45 F4 01 00 00 00 EB 07 C7 45 F4 00 00 00 00 8A 45 F4 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_3_237_1 {
	meta:
		name = "?_Ifmt@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABAPADPADPBDH@Z"
		size = 283
		altNames = "?_Ifmt@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABAPADPADPBDH@Z ?_Ifmt@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABAPADPADPBDH@Z"
	strings:
		$1 = { 55 8B EC 83 EC 0C 8B 45 0C 89 45 F8 8B 4D F8 C6 01 25 8B 55 F8 83 C2 01 89 55 F8 8B 45 14 83 E0 20 74 0F 8B 4D F8 C6 01 2B 8B 55 F8 83 C2 01 89 55 F8 8B 45 14 83 E0 08 74 0F 8B 4D F8 C6 01 23 8B 55 F8 83 C2 01 89 55 F8 B8 01 00 00 00 6B C8 00 8B 55 10 0F BE 04 0A 83 F8 4C 74 1E B9 01 00 00 00 6B D1 00 8B 45 F8 8B 4D 10 8A 14 11 88 10 8B 45 F8 83 C0 01 89 45 F8 EB 2D 8B 4D F8 C6 01 49 8B 55 F8 83 C2 01 89 55 F8 8B 45 F8 C6 00 36 8B 4D F8 83 C1 01 89 4D F8 8B 55 F8 C6 02 34 8B 45 F8 83 C0 01 89 45 F8 8B 4D 14 81 E1 00 0E 00 00 89 4D F4 81 7D F4 00 04 00 00 75 06 C6 45 FD 6F EB 3A 81 7D F4 00 08 00 00 74 13 BA 01 00 00 00 C1 E2 00 8B 45 10 8A 0C 10 88 4D FE EB 18 8B 55 14 83 E2 04 74 06 C6 45 FF 58 EB 04 C6 45 FF 78 8A 45 FF 88 45 FE 8A 4D FE 88 4D FD 8B 55 F8 8A 45 FD 88 02 8B 4D F8 83 C1 01 89 4D F8 8B 55 F8 C6 02 00 8B 45 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_3_238_1 {
	meta:
		name = "?_Inc@?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@AAEXXZ"
		size = 90
		refs = "0017 ?sbumpc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@QAEHXZ 001f ?eof@?$char_traits@D@std@@SAHXZ 002f ?eq_int_type@?$char_traits@D@std@@SA_NABH0@Z"
	strings:
		$1 = { 55 8B EC 83 EC 0C 89 4D FC 8B 45 FC 83 38 00 74 2C 8B 4D FC 8B 09 E8 ?? ?? ?? ?? 89 45 F8 E8 ?? ?? ?? ?? 89 45 F4 8D 55 F8 52 8D 45 F4 50 E8 ?? ?? ?? ?? 83 C4 08 0F B6 C8 85 C9 74 12 8B 55 FC C7 02 00 00 00 00 8B 45 FC C6 40 04 01 EB 07 8B 4D FC C6 41 04 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_3_239_1 {
	meta:
		name = "?_Incref@facet@locale@std@@UAEXXZ"
		size = 20
		altNames = "?_Incref@_Ref_count_base@std@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 83 C0 04 F0 FF 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_3_241_1 {
	meta:
		name = "?_Init@?$ctype@D@std@@IAEXABV_Locinfo@2@@Z"
		size = 55
		refs = "0011 ?_Getctype@_Locinfo@std@@QBE?AU_Ctypevec@@XZ"
	strings:
		$1 = { 55 8B EC 83 EC 14 89 4D FC 8D 45 EC 50 8B 4D 08 E8 ?? ?? ?? ?? 8B 4D FC 83 C1 08 8B 10 89 11 8B 50 04 89 51 04 8B 50 08 89 51 08 8B 40 0C 89 41 0C 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_3_244_1 {
	meta:
		name = "?_Init@?$numpunct@D@std@@IAEXABV_Locinfo@2@_N@Z"
		size = 292
		refs = "0006 __ehhandler$?_Init@?$numpunct@D@std@@IAEXABV_Locinfo@2@_N@Z 0019 ___security_cookie 0039 ?_Getlconv@_Locinfo@std@@QBEPBUlconv@@XZ 0048 ?_Getcvt@_Locinfo@std@@QBE?AU_Cvtvec@@XZ 007c ??_C@_00CNPNBAHC@?$AA@ 00a5 ??$_Maklocstr@D@std@@YAPADPBDPADABU_Cvtvec@@@Z 00bc ?_Getfalse@_Locinfo@std@@QBEPBDXZ 00f1 ?_Gettrue@_Locinfo@std@@QBEPBDXZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 51 81 EC 80 00 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 EC 53 56 57 50 8D 45 F4 64 A3 00 00 00 00 89 65 F0 89 4D 90 8B 4D 08 E8 ?? ?? ?? ?? 89 45 88 8D 45 C0 50 8B 4D 08 E8 ?? ?? ?? ?? 8B 4D 90 C7 41 08 00 00 00 00 8B 55 90 C7 42 10 00 00 00 00 8B 45 90 C7 40 14 00 00 00 00 C7 45 FC 00 00 00 00 0F B6 4D 0C 85 C9 74 09 C7 45 8C ?? ?? ?? ?? EB 09 8B 55 88 8B 42 08 89 45 8C 8D 4D 94 51 8B 4D 08 E8 ?? ?? ?? ?? 89 45 84 8B 55 84 52 6A 00 8B 45 8C 50 E8 ?? ?? ?? ?? 83 C4 0C 89 45 80 8B 4D 90 8B 55 80 89 51 08 8B 4D 08 E8 ?? ?? ?? ?? 89 85 7C FF FF FF 8D 45 C0 50 6A 00 8B 8D 7C FF FF FF 51 E8 ?? ?? ?? ?? 83 C4 0C 89 85 78 FF FF FF 8B 55 90 8B 85 78 FF FF FF 89 42 10 8B 4D 08 E8 ?? ?? ?? ?? 89 85 74 FF FF FF 8D 4D C0 51 6A 00 8B 95 74 FF FF FF 52 E8 ?? ?? ?? ?? 83 C4 0C 89 85 70 FF FF FF 8B 45 90 8B 8D 70 FF FF FF 89 48 14 EB 17 }
	condition:
		$1
}

rule file_29_884_1 {
	meta:
		name = "?_Init@?$numpunct@G@std@@IAEXABV_Locinfo@2@_N@Z"
		size = 292
		refs = "0006 __ehhandler$?_Init@?$numpunct@G@std@@IAEXABV_Locinfo@2@_N@Z 0019 ___security_cookie 0039 ?_Getlconv@_Locinfo@std@@QBEPBUlconv@@XZ 0048 ?_Getcvt@_Locinfo@std@@QBE?AU_Cvtvec@@XZ 007c ??_C@_00CNPNBAHC@?$AA@ 00a5 ??$_Maklocstr@D@std@@YAPADPBDPADABU_Cvtvec@@@Z 00bc ?_Getfalse@_Locinfo@std@@QBEPBDXZ 00d4 ??$_Maklocstr@G@std@@YAPAGPBDPAGABU_Cvtvec@@@Z 00f1 ?_Gettrue@_Locinfo@std@@QBEPBDXZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 51 81 EC 80 00 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 EC 53 56 57 50 8D 45 F4 64 A3 00 00 00 00 89 65 F0 89 4D 90 8B 4D 08 E8 ?? ?? ?? ?? 89 45 88 8D 45 C0 50 8B 4D 08 E8 ?? ?? ?? ?? 8B 4D 90 C7 41 08 00 00 00 00 8B 55 90 C7 42 10 00 00 00 00 8B 45 90 C7 40 14 00 00 00 00 C7 45 FC 00 00 00 00 0F B6 4D 0C 85 C9 74 09 C7 45 8C ?? ?? ?? ?? EB 09 8B 55 88 8B 42 08 89 45 8C 8D 4D 94 51 8B 4D 08 E8 ?? ?? ?? ?? 89 45 84 8B 55 84 52 6A 00 8B 45 8C 50 E8 ?? ?? ?? ?? 83 C4 0C 89 45 80 8B 4D 90 8B 55 80 89 51 08 8B 4D 08 E8 ?? ?? ?? ?? 89 85 7C FF FF FF 8D 45 C0 50 6A 00 8B 8D 7C FF FF FF 51 E8 ?? ?? ?? ?? 83 C4 0C 89 85 78 FF FF FF 8B 55 90 8B 85 78 FF FF FF 89 42 10 8B 4D 08 E8 ?? ?? ?? ?? 89 85 74 FF FF FF 8D 4D C0 51 6A 00 8B 95 74 FF FF FF 52 E8 ?? ?? ?? ?? 83 C4 0C 89 85 70 FF FF FF 8B 45 90 8B 8D 70 FF FF FF 89 48 14 EB 17 }
	condition:
		$1
}

rule file_29_887_1 {
	meta:
		name = "?_Init@?$numpunct@_W@std@@IAEXABV_Locinfo@2@_N@Z"
		size = 292
		refs = "0006 __ehhandler$?_Init@?$numpunct@_W@std@@IAEXABV_Locinfo@2@_N@Z 0019 ___security_cookie 0039 ?_Getlconv@_Locinfo@std@@QBEPBUlconv@@XZ 0048 ?_Getcvt@_Locinfo@std@@QBE?AU_Cvtvec@@XZ 007c ??_C@_00CNPNBAHC@?$AA@ 00a5 ??$_Maklocstr@D@std@@YAPADPBDPADABU_Cvtvec@@@Z 00bc ?_Getfalse@_Locinfo@std@@QBEPBDXZ 00d4 ??$_Maklocstr@_W@std@@YAPA_WPBDPA_WABU_Cvtvec@@@Z 00f1 ?_Gettrue@_Locinfo@std@@QBEPBDXZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 51 81 EC 80 00 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 EC 53 56 57 50 8D 45 F4 64 A3 00 00 00 00 89 65 F0 89 4D 90 8B 4D 08 E8 ?? ?? ?? ?? 89 45 88 8D 45 C0 50 8B 4D 08 E8 ?? ?? ?? ?? 8B 4D 90 C7 41 08 00 00 00 00 8B 55 90 C7 42 10 00 00 00 00 8B 45 90 C7 40 14 00 00 00 00 C7 45 FC 00 00 00 00 0F B6 4D 0C 85 C9 74 09 C7 45 8C ?? ?? ?? ?? EB 09 8B 55 88 8B 42 08 89 45 8C 8D 4D 94 51 8B 4D 08 E8 ?? ?? ?? ?? 89 45 84 8B 55 84 52 6A 00 8B 45 8C 50 E8 ?? ?? ?? ?? 83 C4 0C 89 45 80 8B 4D 90 8B 55 80 89 51 08 8B 4D 08 E8 ?? ?? ?? ?? 89 85 7C FF FF FF 8D 45 C0 50 6A 00 8B 8D 7C FF FF FF 51 E8 ?? ?? ?? ?? 83 C4 0C 89 85 78 FF FF FF 8B 55 90 8B 85 78 FF FF FF 89 42 10 8B 4D 08 E8 ?? ?? ?? ?? 89 85 74 FF FF FF 8D 4D C0 51 6A 00 8B 95 74 FF FF FF 52 E8 ?? ?? ?? ?? 83 C4 0C 89 85 70 FF FF FF 8B 45 90 8B 8D 70 FF FF FF 89 48 14 EB 17 }
	condition:
		$1
}

rule file_3_245_1 {
	meta:
		name = "__catch$?_Init@?$numpunct@D@std@@IAEXABV_Locinfo@2@_N@Z$0"
		size = 152
		refs = "0004 ?_Tidy@?$numpunct@D@std@@AAEXXZ 000d __CxxThrowException@8 0012 $LN11 0038 ??$_Maklocchr@D@std@@YADDPADABU_Cvtvec@@@Z 0076 ??$_Getvals@D@?$numpunct@D@std@@IAEXDPBUlconv@@U_Cvtvec@@@Z 008e @__security_check_cookie@4"
	strings:
		$1 = { 8B 4D 90 E8 ?? ?? ?? ?? 6A 00 6A 00 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? C3 C7 45 FC FF FF FF FF EB 07 C7 45 FC FF FF FF FF 0F B6 55 0C 85 D2 74 2E 8D 45 C0 50 6A 00 6A 2E E8 ?? ?? ?? ?? 83 C4 0C 8B 4D 90 88 41 0C 8D 55 C0 52 6A 00 6A 2C E8 ?? ?? ?? ?? 83 C4 0C 8B 4D 90 88 41 0D EB 1D 83 EC 2C B9 0B 00 00 00 8D 75 C0 8B FC F3 A5 8B 55 88 52 6A 00 8B 4D 90 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 5F 5E 5B 8B 4D EC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_3_246_1 {
	meta:
		name = "__ehhandler$?_Init@?$numpunct@D@std@@IAEXABV_Locinfo@2@_N@Z"
		size = 40
		refs = "0010 @__security_check_cookie@4 001f __ehfuncinfo$?_Init@?$numpunct@D@std@@IAEXABV_Locinfo@2@_N@Z 0024 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 8A 6C FF FF FF 33 C8 E8 ?? ?? ?? ?? 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_29_886_1 {
	meta:
		name = "__ehhandler$?_Init@?$numpunct@G@std@@IAEXABV_Locinfo@2@_N@Z"
		size = 40
		refs = "0010 @__security_check_cookie@4 001f __ehfuncinfo$?_Init@?$numpunct@G@std@@IAEXABV_Locinfo@2@_N@Z 0024 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 8A 6C FF FF FF 33 C8 E8 ?? ?? ?? ?? 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_29_889_1 {
	meta:
		name = "__ehhandler$?_Init@?$numpunct@_W@std@@IAEXABV_Locinfo@2@_N@Z"
		size = 40
		refs = "0010 @__security_check_cookie@4 001f __ehfuncinfo$?_Init@?$numpunct@_W@std@@IAEXABV_Locinfo@2@_N@Z 0024 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 8A 6C FF FF FF 33 C8 E8 ?? ?? ?? ?? 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_3_248_1 {
	meta:
		name = "?_Inside@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE_NPBD@Z"
		size = 67
		refs = "0012 ?_Myptr@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAEPADXZ 0029 ?_Mysize@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAEAAIXZ"
	strings:
		$1 = { 55 8B EC 51 56 89 4D FC 83 7D 08 00 74 26 8B 4D FC E8 ?? ?? ?? ?? 39 45 08 72 19 8B 4D FC E8 ?? ?? ?? ?? 8B F0 8B 4D FC E8 ?? ?? ?? ?? 03 30 3B 75 08 77 06 32 C0 EB 04 EB 02 B0 01 5E 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_3_249_1 {
	meta:
		name = "?_Iput@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AAVios_base@2@DPADI@Z"
		size = 1072
		refs = "0006 __ehhandler$?_Iput@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AAVios_base@2@DPADI@Z 0018 ___security_cookie 0061 ?flags@ios_base@std@@QBEHXZ 00bc ?getloc@ios_base@std@@QBE?AVlocale@2@XZ 00d5 ??$use_facet@V?$ctype@D@std@@@std@@YAABV?$ctype@D@0@ABVlocale@0@@Z 00ed ??1locale@std@@QAE@XZ 00fb ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@ID@Z 010c ??A?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAADI@Z 0128 ?widen@?$ctype@D@std@@QBEPBDPBD0PAD@Z 014d ??$use_facet@V?$numpunct@D@std@@@std@@YAABV?$numpunct@D@0@ABVlocale@0@@Z 016e ?grouping@?$numpunct@D@std@@QBE?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ 017c ??A?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBEABDI@Z 019c ?thousands_sep@?$numpunct@D@std@@QBEDXZ 01e5 ?insert@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAAV12@IID@Z 020b ?size@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBEIXZ 0216 ?width@ios_base@std@@QBE_JXZ 0294 ?_Rep@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@DI@Z 02d0 ?_Put@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@PBDI@Z 03d4 ?width@ios_base@std@@QAE_J_J@Z 0401 ??1?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@XZ 0428 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 81 EC B0 00 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 F0 50 8D 45 F4 64 A3 00 00 00 00 83 7D 24 00 76 1F 8B 45 20 0F BE 08 83 F9 2B 74 0B 8B 55 20 0F BE 02 83 F8 2D 75 09 C7 45 A8 01 00 00 00 EB 07 C7 45 A8 00 00 00 00 8B 4D A8 89 4D BC 8B 4D 18 E8 ?? ?? ?? ?? 25 00 0E 00 00 3D 00 08 00 00 75 40 8B 55 BC 83 C2 02 3B 55 24 77 35 8B 45 20 03 45 BC 0F BE 08 83 F9 30 75 27 8B 55 20 03 55 BC 0F BE 42 01 83 F8 78 74 0F 8B 4D 20 03 4D BC 0F BE 51 01 83 FA 58 75 09 8B 45 BC 83 C0 02 89 45 BC 8D 8D 7C FF FF FF 51 8B 4D 18 E8 ?? ?? ?? ?? 89 45 9C 8B 55 9C 89 55 98 C7 45 FC 00 00 00 00 8B 45 98 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 94 C7 45 FC FF FF FF FF 8D 8D 7C FF FF FF E8 ?? ?? ?? ?? 6A 00 8B 4D 24 51 8D 4D D8 E8 ?? ?? ?? ?? C7 45 FC 01 00 00 00 6A 00 8D 4D D8 E8 ?? ?? ?? ?? 50 8B 55 20 03 55 24 52 B8 01 00 00 00 6B C8 00 03 4D 20 51 8B 4D 94 E8 ?? ?? ?? ?? 8D 95 74 FF FF FF 52 8B 4D 18 E8 ?? ?? ?? ?? 89 45 90 8B 45 90 89 45 8C C6 45 FC 02 8B 4D 8C 51 E8 ?? ?? ?? ?? 83 C4 04 89 45 A4 C6 45 FC 01 8D 8D 74 FF FF FF E8 ?? ?? ?? ?? 8D 55 C0 52 8B 4D A4 E8 ?? ?? ?? ?? C6 45 FC 03 6A 00 8D 4D C0 E8 ?? ?? ?? ?? 89 45 B8 8B 45 B8 0F BE 08 83 F9 7F 74 79 8B 55 B8 0F BE 02 85 C0 7E 6F 8B 4D A4 E8 ?? ?? ?? ?? 88 45 B7 8B 4D B8 0F BE 11 83 FA 7F 74 59 8B 45 B8 0F BE 08 85 C9 7E 4F 8B 55 B8 0F BE 02 8B 4D 24 2B 4D BC 3B C1 73 3F 8B 55 B8 0F BE 02 8B 4D 24 2B C8 89 4D 24 0F B6 55 B7 52 6A 01 8B 45 24 50 8D 4D D8 E8 ?? ?? ?? ?? B9 01 00 00 00 C1 E1 00 8B 55 B8 0F BE 04 0A 85 C0 7E 09 8B 4D B8 83 C1 01 89 4D B8 EB 9C 8D 4D D8 E8 ?? ?? ?? ?? 89 45 24 8B 4D 18 E8 ?? ?? ?? ?? 89 45 84 89 55 88 83 7D 88 00 7C 25 7F 06 83 7D 84 00 76 1D 8B 4D 18 E8 ?? ?? ?? ?? 3B 45 24 76 10 8B 4D 18 E8 ?? ?? ?? ?? 2B 45 24 89 45 A0 EB 07 C7 45 A0 00 00 00 00 8B 55 A0 89 55 B0 8B 4D 18 E8 ?? ?? ?? ?? 25 C0 01 00 00 89 45 AC 83 7D AC 40 74 79 81 7D AC 00 01 00 00 74 70 8B 45 B0 50 0F B6 4D 1C 51 8B 55 14 52 8B 45 10 50 8D 8D 6C FF FF FF 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 18 8B 08 8B 50 04 89 4D 10 89 55 14 C7 45 B0 00 00 00 00 8B 45 BC 50 6A 00 8D 4D D8 E8 ?? ?? ?? ?? 50 8B 4D 14 51 8B 55 10 52 8D 85 64 FF FF FF 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 18 8B 10 8B 40 04 89 55 10 89 45 14 E9 AB 00 00 00 81 7D AC 00 01 00 00 75 6D 8B 4D BC 51 6A 00 8D 4D D8 E8 ?? ?? ?? ?? 50 8B 55 14 52 8B 45 10 50 8D 8D 5C FF FF FF 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 18 8B 08 8B 50 04 89 4D 10 89 55 14 8B 45 B0 50 0F B6 4D 1C 51 8B 55 14 52 8B 45 10 50 8D 8D 54 FF FF FF 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 18 8B 08 8B 50 04 89 4D 10 89 55 14 C7 45 B0 00 00 00 00 EB 35 8B 45 BC 50 6A 00 8D 4D D8 E8 ?? ?? ?? ?? 50 8B 4D 14 51 8B 55 10 52 8D 85 4C FF FF FF 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 18 8B 10 8B 40 04 89 55 10 89 45 14 8B 4D 24 2B 4D BC 51 8B 55 BC 52 8D 4D D8 E8 ?? ?? ?? ?? 50 8B 45 14 50 8B 4D 10 51 8D 95 44 FF FF FF 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 18 8B 08 8B 50 04 89 4D 10 89 55 14 6A 00 6A 00 8B 4D 18 E8 ?? ?? ?? ?? 8B 45 B0 50 0F B6 4D 1C 51 8B 55 14 52 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 18 C6 45 FC 01 8D 4D C0 E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8D 4D D8 E8 ?? ?? ?? ?? 8B 45 0C 8B 4D F4 64 89 0D 00 00 00 00 59 8B 4D F0 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_3_254_1 {
	meta:
		name = "__ehhandler$?_Iput@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AAVios_base@2@DPADI@Z"
		size = 40
		refs = "0010 @__security_check_cookie@4 001f __ehfuncinfo$?_Iput@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AAVios_base@2@DPADI@Z 0024 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 8A 4C FF FF FF 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_29_911_1 {
	meta:
		name = "__ehhandler$?_Iput@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AAVios_base@2@GPADI@Z"
		size = 40
		refs = "0010 @__security_check_cookie@4 001f __ehfuncinfo$?_Iput@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AAVios_base@2@GPADI@Z 0024 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 8A 4C FF FF FF 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_29_917_1 {
	meta:
		name = "__ehhandler$?_Iput@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AAVios_base@2@_WPADI@Z"
		size = 40
		refs = "0010 @__security_check_cookie@4 001f __ehfuncinfo$?_Iput@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AAVios_base@2@_WPADI@Z 0024 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 8A 4C FF FF FF 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_118_437_3 {
	meta:
		name = "__ehhandler$?overflow@?$basic_filebuf@GU?$char_traits@G@std@@@std@@MAEGG@Z"
		size = 40
		refs = "0010 @__security_check_cookie@4 001f __ehfuncinfo$?overflow@?$basic_filebuf@GU?$char_traits@G@std@@@std@@MAEGG@Z 0024 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 8A 4C FF FF FF 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_36_412_2 {
	meta:
		name = "__ehhandler$?overflow@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@MAEGG@Z"
		size = 40
		refs = "0010 @__security_check_cookie@4 001f __ehfuncinfo$?overflow@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@MAEGG@Z 0024 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 8A 4C FF FF FF 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_3_255_1 {
	meta:
		name = "?_Locimp_Addfac@_Locimp@locale@std@@CAXPAV123@PAVfacet@23@I@Z"
		size = 389
		refs = "0006 __ehhandler$?_Locimp_Addfac@_Locimp@locale@std@@CAXPAV123@PAVfacet@23@I@Z 0016 ___security_cookie 002c ??0_Lockit@std@@QAE@H@Z 0069 ??_C@_0CL@KAIJNGJC@f?3?2dd?2vctools?2crt?2crtw32?2stdcpp?2@ 007e __realloc_dbg 008f ?_Xbad_alloc@std@@YAXXZ 00dc @_guard_check_icall@4 0171 ??1_Lockit@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 28 56 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 6A 00 8D 4D D0 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 C7 45 CC 28 00 00 00 8B 45 08 8B 48 0C 3B 4D 10 0F 87 80 00 00 00 8B 55 10 83 C2 01 89 55 F0 83 7D F0 28 73 07 C7 45 F0 28 00 00 00 68 81 00 00 00 68 ?? ?? ?? ?? 6A 02 8B 45 F0 C1 E0 02 50 8B 4D 08 8B 51 08 52 E8 ?? ?? ?? ?? 83 C4 14 89 45 E8 83 7D E8 00 75 05 E8 ?? ?? ?? ?? 8B 45 08 8B 4D E8 89 48 08 EB 0F 8B 55 08 8B 42 0C 83 C0 01 8B 4D 08 89 41 0C 8B 55 08 8B 42 0C 3B 45 F0 73 15 8B 4D 08 8B 51 0C 8B 45 08 8B 48 08 C7 04 91 00 00 00 00 EB D1 8B 55 0C 8B 02 8B 48 04 89 4D E4 8B 4D E4 E8 ?? ?? ?? ?? 8B 4D 0C FF 55 E4 8B 55 08 8B 42 08 8B 4D 10 83 3C 88 00 74 62 8B 55 08 8B 42 08 8B 4D 10 8B 14 88 8B 45 08 8B 48 08 8B 45 10 8B 34 81 8B 0A 8B 51 08 89 55 E0 8B 4D E0 E8 ?? ?? ?? ?? 8B CE FF 55 E0 89 45 D8 8B 45 D8 89 45 EC 83 7D EC 00 74 1F 6A 01 8B 4D EC 8B 11 8B 02 89 45 DC 8B 4D DC E8 ?? ?? ?? ?? 8B 4D EC FF 55 DC 89 45 D4 EB 07 C7 45 D4 00 00 00 00 8B 4D 08 8B 51 08 8B 45 10 8B 4D 0C 89 0C 82 C7 45 FC FF FF FF FF 8D 4D D0 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_3_257_1 {
	meta:
		name = "__ehhandler$?_Locimp_Addfac@_Locimp@locale@std@@CAXPAV123@PAVfacet@23@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Locimp_Addfac@_Locimp@locale@std@@CAXPAV123@PAVfacet@23@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_3_258_1 {
	meta:
		name = "?_Locimp_ctor@_Locimp@locale@std@@CAXPAV123@ABV123@@Z"
		size = 305
		refs = "0006 __ehhandler$?_Locimp_ctor@_Locimp@locale@std@@CAXPAV123@ABV123@@Z 0015 ___security_cookie 002a ?_Clocptr@_Locimp@locale@std@@0PAV123@A 0031 ??_C@_01GFHCPBMG@C?$AA@ 0039 ??0_Locinfo@std@@QAE@PBD@Z 0051 ?_Makeloc@_Locimp@locale@std@@CAPAV123@ABV_Locinfo@3@HPAV123@PBV23@@Z 0063 ??1_Locinfo@std@@QAE@XZ 0072 ??0_Lockit@std@@QAE@H@Z 008d ??_C@_0CL@KAIJNGJC@f?3?2dd?2vctools?2crt?2crtw32?2stdcpp?2@ 009e __malloc_dbg 00b8 ?_Xbad_alloc@std@@YAXXZ 0107 @_guard_check_icall@4 011e ??1_Lockit@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 48 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 8B 45 0C 3B 05 ?? ?? ?? ?? 75 3C 68 ?? ?? ?? ?? 8D 4D AC E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 6A 00 8B 4D 08 51 6A 3F 8D 55 AC 52 E8 ?? ?? ?? ?? 83 C4 10 C7 45 FC FF FF FF FF 8D 4D AC E8 ?? ?? ?? ?? E9 B6 00 00 00 6A 00 8D 4D E0 E8 ?? ?? ?? ?? C7 45 FC 01 00 00 00 8B 45 08 83 78 0C 00 0F 86 89 00 00 00 6A 65 68 ?? ?? ?? ?? 6A 02 8B 4D 08 8B 51 0C C1 E2 02 52 E8 ?? ?? ?? ?? 83 C4 10 89 45 E8 8B 45 08 8B 4D E8 89 48 08 83 7D E8 00 75 05 E8 ?? ?? ?? ?? 8B 55 08 8B 42 0C 89 45 F0 83 7D F0 00 76 48 8B 4D F0 83 E9 01 89 4D F0 8B 55 0C 8B 42 08 8B 4D F0 8B 14 88 89 55 EC 8B 45 08 8B 48 08 8B 55 F0 8B 45 EC 89 04 91 83 7D EC 00 74 19 8B 4D EC 8B 11 8B 42 04 89 45 E4 8B 4D E4 E8 ?? ?? ?? ?? 8B 4D EC FF 55 E4 EB B2 C7 45 FC FF FF FF FF 8D 4D E0 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_3_261_1 {
	meta:
		name = "__ehhandler$?_Locimp_ctor@_Locimp@locale@std@@CAXPAV123@ABV123@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Locimp_ctor@_Locimp@locale@std@@CAXPAV123@ABV123@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_93_92_1 {
	meta:
		name = "__ehhandler$?_CopyException@__ExceptionPtr@@SA?AV?$shared_ptr@V__ExceptionPtr@@@std@@PBXPBU_s_ThrowInfo@@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_CopyException@__ExceptionPtr@@SA?AV?$shared_ptr@V__ExceptionPtr@@@std@@PBXPBU_s_ThrowInfo@@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_80_452_1 {
	meta:
		name = "__ehhandler$?do_get_date@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?do_get_date@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_29_1202_1 {
	meta:
		name = "__ehhandler$?do_get_date@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?do_get_date@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_29_1205_1 {
	meta:
		name = "__ehhandler$?do_get_date@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?do_get_date@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_3_262_1 {
	meta:
		name = "?_Locinfo_Addcats@_Locinfo@std@@SAAAV12@PAV12@HPBD@Z"
		size = 269
		refs = "0014 ??_C@_0BA@ELKIONDK@bad?5locale?5name?$AA@ 0019 ?_Xruntime_error@std@@YAXPBD@Z 0051 _setlocale 00c9 ??_C@_01NBENCBCI@?$CK?$AA@ 00d4 ??4?$_Yarn@D@std@@QAEAAV01@PBD@Z 00e6 ?_C_str@?$_Yarn@D@std@@QBEPBDXZ 00ec _strcmp"
	strings:
		$1 = { 55 8B EC 83 EC 08 C7 45 F8 00 00 00 00 83 7D 10 00 75 0A 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 01 00 00 00 6B C8 00 8B 55 10 0F BE 04 0A 83 F8 2A 75 15 B9 01 00 00 00 C1 E1 00 8B 55 10 0F BE 04 0A 85 C0 75 02 EB 7C 83 7D 0C 00 75 11 6A 00 6A 00 E8 ?? ?? ?? ?? 83 C4 08 89 45 F8 EB 65 83 7D 0C 3F 75 13 8B 4D 10 51 6A 00 E8 ?? ?? ?? ?? 83 C4 08 89 45 F8 EB 4C C7 45 FC 00 00 00 00 EB 09 8B 55 FC 83 C2 01 89 55 FC 83 7D FC 05 7F 23 B8 01 00 00 00 8B 4D FC D3 E0 D1 F8 23 45 0C 74 10 8B 4D 10 51 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 08 EB CE 8B 45 10 50 6A 00 E8 ?? ?? ?? ?? 83 C4 08 89 45 F8 83 7D F8 00 75 12 68 ?? ?? ?? ?? 8B 4D 08 83 C1 2C E8 ?? ?? ?? ?? EB 2C 68 ?? ?? ?? ?? 8B 4D 08 83 C1 2C E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 0F 8B 4D F8 51 8B 4D 08 83 C1 2C E8 ?? ?? ?? ?? 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_3_263_1 {
	meta:
		name = "?_Locinfo_ctor@_Locinfo@std@@SAXPAV12@HPBD@Z"
		size = 81
		refs = "000b _setlocale 001e ??_C@_00CNPNBAHC@?$AA@ 0035 ??4?$_Yarn@D@std@@QAEAAV01@PBD@Z 0046 ?_Locinfo_Addcats@_Locinfo@std@@SAAAV12@PAV12@HPBD@Z"
	strings:
		$1 = { 55 8B EC 83 EC 08 6A 00 6A 00 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 75 09 C7 45 F8 ?? ?? ?? ?? EB 06 8B 45 FC 89 45 F8 8B 4D F8 51 8B 4D 08 83 C1 24 E8 ?? ?? ?? ?? 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_3_264_1 {
	meta:
		name = "?_Makeloc@_Locimp@locale@std@@CAPAV123@ABV_Locinfo@3@HPAV123@PBV23@@Z"
		size = 969
		refs = "0006 __ehhandler$?_Makeloc@_Locimp@locale@std@@CAPAV123@ABV_Locinfo@3@HPAV123@PBV23@@Z 0015 ___security_cookie 002a ?_Getcat@?$ctype@D@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 004f ??2_Crt_new_delete@std@@SAPAXI@Z 0070 ??0?$ctype@D@std@@QAE@ABV_Locinfo@1@I@Z 008e ?id@?$ctype@D@std@@2V0locale@2@A 0093 ??Bid@locale@std@@QAEIXZ 00a0 ?_Addfac@_Locimp@locale@std@@AAEXPAVfacet@23@I@Z 00b6 ??$use_facet@V?$ctype@D@std@@@std@@YAABV?$ctype@D@0@ABVlocale@0@@Z 00cb ?_Getcat@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0111 ??0?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 012f ?id@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@2V0locale@2@A 0157 ??$use_facet@V?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z 016c ?_Getcat@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 01b2 ??0?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 01d0 ?id@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@2V0locale@2@A 01f8 ??$use_facet@V?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z 020d ?_Getcat@?$numpunct@D@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0255 ??0?$numpunct@D@std@@QAE@ABV_Locinfo@1@I_N@Z 0273 ?id@?$numpunct@D@std@@2V0locale@2@A 029b ??$use_facet@V?$numpunct@D@std@@@std@@YAABV?$numpunct@D@0@ABVlocale@0@@Z 02b0 ?_Getcat@?$codecvt@DDU_Mbstatet@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 02f6 ??0?$codecvt@DDU_Mbstatet@@@std@@QAE@ABV_Locinfo@1@I@Z 0314 ?id@?$codecvt@DDU_Mbstatet@@@std@@2V0locale@2@A 033c ??$use_facet@V?$codecvt@DDU_Mbstatet@@@std@@@std@@YAABV?$codecvt@DDU_Mbstatet@@@0@ABVlocale@0@@Z 035d ?_Makexloc@_Locimp@locale@std@@CAXABV_Locinfo@3@HPAV123@PBV23@@Z 0375 ?_Makewloc@_Locimp@locale@std@@CAXABV_Locinfo@3@HPAV123@PBV23@@Z 038d ?_Makeushloc@_Locimp@locale@std@@CAXABV_Locinfo@3@HPAV123@PBV23@@Z 03a7 ?_Getname@_Locinfo@std@@QBEPBDXZ 03b3 ??4?$_Yarn@D@std@@QAEAAV01@PBD@Z"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 3C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 6A 00 6A 00 E8 ?? ?? ?? ?? 83 C4 08 BA 01 00 00 00 8B C8 D3 E2 D1 FA 23 55 0C 75 05 E9 80 00 00 00 83 7D 14 00 75 5A 6A 18 E8 ?? ?? ?? ?? 83 C4 04 89 45 F0 C7 45 FC 00 00 00 00 83 7D F0 00 74 13 6A 00 8B 45 08 50 8B 4D F0 E8 ?? ?? ?? ?? 89 45 EC EB 07 C7 45 EC 00 00 00 00 8B 4D EC 89 4D C8 C7 45 FC FF FF FF FF B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 8B 55 C8 52 8B 4D 10 E8 ?? ?? ?? ?? EB 20 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 8B 45 14 50 E8 ?? ?? ?? ?? 83 C4 04 50 8B 4D 10 E8 ?? ?? ?? ?? 6A 00 6A 00 E8 ?? ?? ?? ?? 83 C4 08 BA 01 00 00 00 8B C8 D3 E2 D1 FA 23 55 0C 75 05 E9 80 00 00 00 83 7D 14 00 75 5A 6A 08 E8 ?? ?? ?? ?? 83 C4 04 89 45 E8 C7 45 FC 01 00 00 00 83 7D E8 00 74 13 6A 00 8B 45 08 50 8B 4D E8 E8 ?? ?? ?? ?? 89 45 E4 EB 07 C7 45 E4 00 00 00 00 8B 4D E4 89 4D C4 C7 45 FC FF FF FF FF B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 8B 55 C4 52 8B 4D 10 E8 ?? ?? ?? ?? EB 20 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 8B 45 14 50 E8 ?? ?? ?? ?? 83 C4 04 50 8B 4D 10 E8 ?? ?? ?? ?? 6A 00 6A 00 E8 ?? ?? ?? ?? 83 C4 08 BA 01 00 00 00 8B C8 D3 E2 D1 FA 23 55 0C 75 05 E9 80 00 00 00 83 7D 14 00 75 5A 6A 08 E8 ?? ?? ?? ?? 83 C4 04 89 45 E0 C7 45 FC 02 00 00 00 83 7D E0 00 74 13 6A 00 8B 45 08 50 8B 4D E0 E8 ?? ?? ?? ?? 89 45 DC EB 07 C7 45 DC 00 00 00 00 8B 4D DC 89 4D C0 C7 45 FC FF FF FF FF B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 8B 55 C0 52 8B 4D 10 E8 ?? ?? ?? ?? EB 20 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 8B 45 14 50 E8 ?? ?? ?? ?? 83 C4 04 50 8B 4D 10 E8 ?? ?? ?? ?? 6A 00 6A 00 E8 ?? ?? ?? ?? 83 C4 08 BA 01 00 00 00 8B C8 D3 E2 D1 FA 23 55 0C 75 05 E9 82 00 00 00 83 7D 14 00 75 5C 6A 18 E8 ?? ?? ?? ?? 83 C4 04 89 45 D8 C7 45 FC 03 00 00 00 83 7D D8 00 74 15 6A 00 6A 00 8B 45 08 50 8B 4D D8 E8 ?? ?? ?? ?? 89 45 D4 EB 07 C7 45 D4 00 00 00 00 8B 4D D4 89 4D BC C7 45 FC FF FF FF FF B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 8B 55 BC 52 8B 4D 10 E8 ?? ?? ?? ?? EB 20 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 8B 45 14 50 E8 ?? ?? ?? ?? 83 C4 04 50 8B 4D 10 E8 ?? ?? ?? ?? 6A 00 6A 00 E8 ?? ?? ?? ?? 83 C4 08 BA 01 00 00 00 8B C8 D3 E2 D1 FA 23 55 0C 75 05 E9 80 00 00 00 83 7D 14 00 75 5A 6A 08 E8 ?? ?? ?? ?? 83 C4 04 89 45 D0 C7 45 FC 04 00 00 00 83 7D D0 00 74 13 6A 00 8B 45 08 50 8B 4D D0 E8 ?? ?? ?? ?? 89 45 CC EB 07 C7 45 CC 00 00 00 00 8B 4D CC 89 4D B8 C7 45 FC FF FF FF FF B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 8B 55 B8 52 8B 4D 10 E8 ?? ?? ?? ?? EB 20 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 8B 45 14 50 E8 ?? ?? ?? ?? 83 C4 04 50 8B 4D 10 E8 ?? ?? ?? ?? 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 10 8B 55 14 52 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 8B 4D 10 8B 51 10 0B 55 0C 8B 45 10 89 50 10 8B 4D 08 E8 ?? ?? ?? ?? 50 8B 4D 10 83 C1 18 E8 ?? ?? ?? ?? 8B 45 10 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_3_270_1 {
	meta:
		name = "__ehhandler$?_Makeloc@_Locimp@locale@std@@CAPAV123@ABV_Locinfo@3@HPAV123@PBV23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Makeloc@_Locimp@locale@std@@CAPAV123@ABV_Locinfo@3@HPAV123@PBV23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A C0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_3_271_1 {
	meta:
		name = "?_Myptr@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAEPADXZ"
		size = 26
		refs = "000b ?_Get_data@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAEAAV?$_String_val@U?$_Simple_types@D@std@@@2@XZ 0012 ?_Myptr@?$_String_val@U?$_Simple_types@D@std@@@std@@QAEPADXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_48_292_2 {
	meta:
		name = "?_Myptr@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QBEPBDXZ"
		size = 26
		refs = "000b ?_Get_data@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QBEABV?$_String_val@U?$_Simple_types@D@std@@@2@XZ 0012 ?_Myptr@?$_String_val@U?$_Simple_types@D@std@@@std@@QBEPBDXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_44_1078_2 {
	meta:
		name = "?_Myptr@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAEPAGXZ"
		size = 26
		refs = "000b ?_Get_data@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAEAAV?$_String_val@U?$_Simple_types@G@std@@@2@XZ 0012 ?_Myptr@?$_String_val@U?$_Simple_types@G@std@@@std@@QAEPAGXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_44_1079_2 {
	meta:
		name = "?_Myptr@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QBEPBGXZ"
		size = 26
		refs = "000b ?_Get_data@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QBEABV?$_String_val@U?$_Simple_types@G@std@@@2@XZ 0012 ?_Myptr@?$_String_val@U?$_Simple_types@G@std@@@std@@QBEPBGXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_49_110_3 {
	meta:
		name = "?_Myptr@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAEPA_WXZ"
		size = 26
		refs = "000b ?_Get_data@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAEAAV?$_String_val@U?$_Simple_types@_W@std@@@2@XZ 0012 ?_Myptr@?$_String_val@U?$_Simple_types@_W@std@@@std@@QAEPA_WXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_97_103_2 {
	meta:
		name = "?_Myptr@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QBEPB_WXZ"
		size = 26
		refs = "000b ?_Get_data@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QBEABV?$_String_val@U?$_Simple_types@_W@std@@@2@XZ 0012 ?_Myptr@?$_String_val@U?$_Simple_types@_W@std@@@std@@QBEPB_WXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_27_154_3 {
	meta:
		name = "?_Orphan_all@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAEXXZ"
		size = 26
		refs = "000b ?_Get_data@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAEAAV?$_String_val@U?$_Simple_types@D@std@@@2@XZ 0012 ?_Orphan_all@_Container_base12@std@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_10_1150_3 {
	meta:
		name = "?_Orphan_all@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAEXXZ"
		size = 26
		refs = "000b ?_Get_data@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAEAAV?$_String_val@U?$_Simple_types@G@std@@@2@XZ 0012 ?_Orphan_all@_Container_base12@std@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_10_1151_3 {
	meta:
		name = "?_Orphan_all@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAEXXZ"
		size = 26
		refs = "000b ?_Get_data@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAEAAV?$_String_val@U?$_Simple_types@_W@std@@@2@XZ 0012 ?_Orphan_all@_Container_base12@std@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_3_273_1 {
	meta:
		name = "?_Myptr@?$_String_val@U?$_Simple_types@D@std@@@std@@QAEPADXZ"
		size = 50
		refs = "0019 ??$_Unfancy@D@std@@YAPADPAD@Z"
		altNames = "?_Myptr@?$_String_val@U?$_Simple_types@D@std@@@std@@QBEPBDXZ"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D FC 8B 45 FC 83 78 14 10 72 13 8B 4D FC 8B 11 52 E8 ?? ?? ?? ?? 83 C4 04 89 45 F8 EB 06 8B 45 FC 89 45 F8 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_3_275_1 {
	meta:
		name = "?_Myres@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAEAAIXZ"
		size = 22
		refs = "000b ?_Get_data@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAEAAV?$_String_val@U?$_Simple_types@D@std@@@2@XZ"
		altNames = "?_Mysize@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAEAAIXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 83 C0 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_74_135_1 {
	meta:
		name = "?_Myres@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QBEABIXZ"
		size = 22
		refs = "000b ?_Get_data@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QBEABV?$_String_val@U?$_Simple_types@D@std@@@2@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 83 C0 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_29_966_1 {
	meta:
		name = "?_Myres@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAEAAIXZ"
		size = 22
		refs = "000b ?_Get_data@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAEAAV?$_String_val@U?$_Simple_types@G@std@@@2@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 83 C0 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_29_967_1 {
	meta:
		name = "?_Myres@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAEAAIXZ"
		size = 22
		refs = "000b ?_Get_data@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAEAAV?$_String_val@U?$_Simple_types@_W@std@@@2@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 83 C0 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_46_308_3 {
	meta:
		name = "?_Mysize@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QBEABIXZ"
		size = 22
		refs = "000b ?_Get_data@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QBEABV?$_String_val@U?$_Simple_types@D@std@@@2@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 83 C0 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_44_1093_2 {
	meta:
		name = "?_Mysize@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAEAAIXZ"
		size = 22
		refs = "000b ?_Get_data@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAEAAV?$_String_val@U?$_Simple_types@G@std@@@2@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 83 C0 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_10_1146_3 {
	meta:
		name = "?_Mysize@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QBEABIXZ"
		size = 22
		refs = "000b ?_Get_data@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QBEABV?$_String_val@U?$_Simple_types@G@std@@@2@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 83 C0 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_97_107_2 {
	meta:
		name = "?_Mysize@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAEAAIXZ"
		size = 22
		refs = "000b ?_Get_data@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAEAAV?$_String_val@U?$_Simple_types@_W@std@@@2@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 83 C0 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_49_116_3 {
	meta:
		name = "?_Mysize@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QBEABIXZ"
		size = 22
		refs = "000b ?_Get_data@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QBEABV?$_String_val@U?$_Simple_types@_W@std@@@2@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 83 C0 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_3_276_1 {
	meta:
		name = "?_Mysize@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAEAAIXZ"
		size = 22
		refs = "000b ?_Get_data@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAEAAV?$_String_val@U?$_Simple_types@D@std@@@2@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 83 C0 10 8B E5 5D C3 }
	condition:
		$1
}

rule file_58_257_1 {
	meta:
		name = "?_Mysize@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QBEABIXZ"
		size = 22
		refs = "000b ?_Get_data@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QBEABV?$_String_val@U?$_Simple_types@D@std@@@2@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 83 C0 10 8B E5 5D C3 }
	condition:
		$1
}

rule file_29_970_1 {
	meta:
		name = "?_Mysize@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAEAAIXZ"
		size = 22
		refs = "000b ?_Get_data@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAEAAV?$_String_val@U?$_Simple_types@G@std@@@2@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 83 C0 10 8B E5 5D C3 }
	condition:
		$1
}

rule file_29_971_1 {
	meta:
		name = "?_Mysize@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QBEABIXZ"
		size = 22
		refs = "000b ?_Get_data@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QBEABV?$_String_val@U?$_Simple_types@G@std@@@2@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 83 C0 10 8B E5 5D C3 }
	condition:
		$1
}

rule file_69_66_1 {
	meta:
		name = "?_Mysize@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAEAAIXZ"
		size = 22
		refs = "000b ?_Get_data@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAEAAV?$_String_val@U?$_Simple_types@_W@std@@@2@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 83 C0 10 8B E5 5D C3 }
	condition:
		$1
}

rule file_69_67_1 {
	meta:
		name = "?_Mysize@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QBEABIXZ"
		size = 22
		refs = "000b ?_Get_data@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QBEABV?$_String_val@U?$_Simple_types@_W@std@@@2@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 83 C0 10 8B E5 5D C3 }
	condition:
		$1
}

rule file_3_278_1 {
	meta:
		name = "?_Peek@?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@ABEDXZ"
		size = 107
		refs = "0017 ?sgetc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@QAEHXZ 001f ?eof@?$char_traits@D@std@@SAHXZ 002f ?eq_int_type@?$char_traits@D@std@@SA_NABH0@Z 004d ?to_char_type@?$char_traits@D@std@@SADABH@Z"
	strings:
		$1 = { 55 8B EC 83 EC 0C 89 4D FC 8B 45 FC 83 38 00 74 2C 8B 4D FC 8B 09 E8 ?? ?? ?? ?? 89 45 F8 E8 ?? ?? ?? ?? 89 45 F4 8D 55 F8 52 8D 45 F4 50 E8 ?? ?? ?? ?? 83 C4 08 0F B6 C8 85 C9 74 0B 8B 55 FC C7 02 00 00 00 00 EB 12 8D 45 F8 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D FC 88 41 05 8B 55 FC C6 42 04 01 8B 45 FC 8A 40 05 8B E5 5D C3 }
	condition:
		$1
}

rule file_3_279_1 {
	meta:
		name = "?_Pnavail@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IBE_JXZ"
		size = 48
		altNames = "?_Pnavail@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IBE_JXZ ?_Pnavail@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IBE_JXZ"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D FC 8B 45 FC 8B 48 20 83 39 00 74 0D 8B 55 FC 8B 42 30 8B 08 89 4D F8 EB 07 C7 45 F8 00 00 00 00 8B 45 F8 99 8B E5 5D C3 }
	condition:
		$1
}

rule file_3_280_1 {
	meta:
		name = "?_Pninc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IAEPADXZ"
		size = 65
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D FC 8B 45 FC 8B 48 30 8B 11 83 EA 01 8B 45 FC 8B 48 30 89 11 8B 55 FC 8B 42 20 8B 08 89 4D F8 8B 55 FC 8B 42 20 8B 08 83 C1 01 8B 55 FC 8B 42 20 89 08 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_3_281_1 {
	meta:
		name = "?_Put@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@PBDI@Z"
		size = 80
		refs = "0012 ??E?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@QAEAAV01@XZ 0030 ??D?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@QAEAAV01@XZ 0037 ??4?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@QAEAAV01@D@Z"
	strings:
		$1 = { 55 8B EC EB 1A 8B 45 1C 83 E8 01 89 45 1C 8D 4D 10 E8 ?? ?? ?? ?? 8B 4D 18 83 C1 01 89 4D 18 83 7D 1C 00 76 18 8B 55 18 0F B6 02 50 8D 4D 10 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? EB C8 8B 4D 0C 8B 55 10 89 11 8B 45 14 89 41 04 8B 45 0C 5D C3 }
	condition:
		$1
}

rule file_3_282_1 {
	meta:
		name = "?_Rep@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@DI@Z"
		size = 69
		refs = "0012 ??E?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@QAEAAV01@XZ 0025 ??D?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@QAEAAV01@XZ 002c ??4?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@QAEAAV01@D@Z"
	strings:
		$1 = { 55 8B EC EB 11 8B 45 1C 83 E8 01 89 45 1C 8D 4D 10 E8 ?? ?? ?? ?? 83 7D 1C 00 76 16 0F B6 4D 18 51 8D 4D 10 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? EB D3 8B 55 0C 8B 45 10 89 02 8B 4D 14 89 4A 04 8B 45 0C 5D C3 }
	condition:
		$1
}

rule file_3_283_1 {
	meta:
		name = "?_Stodx_v2@std@@YANPBDPAPADHPAH@Z"
		size = 122
		refs = "0007 __errno 0028 _strtod 005e __real@4024000000000000 0066 _pow"
	strings:
		$1 = { 55 8B EC 83 EC 18 E8 ?? ?? ?? ?? 89 45 FC 8B 45 FC 8B 08 89 4D F8 8B 55 FC C7 02 00 00 00 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 DD 5D F0 8B 55 14 8B 45 FC 8B 08 89 0A 8B 55 FC 8B 45 F8 89 02 83 7D 10 00 74 29 DB 45 10 DD 5D E8 DD 45 E8 83 EC 08 DD 1C 24 83 EC 08 DD 05 ?? ?? ?? ?? DD 1C 24 E8 ?? ?? ?? ?? 83 C4 10 DC 4D F0 DD 5D F0 DD 45 F0 8B E5 5D C3 }
	condition:
		$1
}

rule file_3_284_1 {
	meta:
		name = "?_Stofx_v2@std@@YAMPBDPAPADHPAH@Z"
		size = 118
		refs = "0007 __errno 0028 _strtof 005a __real@41200000 0062 _powf"
	strings:
		$1 = { 55 8B EC 83 EC 10 E8 ?? ?? ?? ?? 89 45 FC 8B 45 FC 8B 08 89 4D F4 8B 55 FC C7 02 00 00 00 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 D9 5D F8 8B 55 14 8B 45 FC 8B 08 89 0A 8B 55 FC 8B 45 F4 89 02 83 7D 10 00 74 25 DB 45 10 D9 5D F0 D9 45 F0 51 D9 1C 24 51 D9 05 ?? ?? ?? ?? D9 1C 24 E8 ?? ?? ?? ?? 83 C4 08 D8 4D F8 D9 5D F8 D9 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_3_285_1 {
	meta:
		name = "?_Tidy@?$_Yarn@D@std@@AAEXXZ"
		size = 44
		refs = "0018 __free_dbg"
		altNames = "?_Tidy@?$_Yarn@_W@std@@AAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 83 38 00 74 10 6A 02 8B 4D FC 8B 11 52 E8 ?? ?? ?? ?? 83 C4 08 8B 45 FC C7 00 00 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_3_287_1 {
	meta:
		name = "?_Tidy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEX_NI@Z"
		size = 186
		refs = "001a ?_Myres@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAEAAIXZ 0027 ?_Bx@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAEAAT_Bxty@?$_String_val@U?$_Simple_types@D@std@@@2@XZ 003a ??$addressof@PAD@std@@YAPAPADAAPAD@Z 0046 ?_Getal@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAEAAU?$_Wrap_alloc@V?$allocator@D@std@@@2@XZ 004d ??$destroy@PAD@?$_Wrap_alloc@V?$allocator@D@std@@@std@@QAEXPAPAD@Z 0060 ??$_Unfancy@D@std@@YAPADPAD@Z 0072 ?copy@?$char_traits@D@std@@SAPADPADPBDI@Z 0096 ?deallocate@?$_Wrap_alloc@V?$allocator@D@std@@@std@@QAEXPADI@Z 00b0 ?_Eos@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEXI@Z"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D FC 0F B6 45 08 85 C0 75 05 E9 84 00 00 00 8B 4D FC E8 ?? ?? ?? ?? 83 38 10 72 77 8B 4D FC E8 ?? ?? ?? ?? 8B 08 89 4D F8 8B 4D FC E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 50 8B 4D FC E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 83 7D 0C 00 76 22 8B 55 0C 52 8B 45 F8 50 E8 ?? ?? ?? ?? 83 C4 04 50 8B 4D FC E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 0C 8B 4D FC E8 ?? ?? ?? ?? 8B 08 83 C1 01 51 8B 55 F8 52 8B 4D FC E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? C7 00 0F 00 00 00 8B 45 0C 50 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_3_288_1 {
	meta:
		name = "?_Tidy@?$ctype@D@std@@IAEXXZ"
		size = 84
		refs = "001a _free 003a ??_V@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D FC 8B 45 FC 83 78 10 00 7E 11 8B 4D FC 8B 51 0C 52 E8 ?? ?? ?? ?? 83 C4 04 EB 1E 8B 45 FC 83 78 10 00 7D 15 8B 4D FC 8B 51 0C 89 55 F8 8B 45 F8 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D FC 8B 51 14 52 E8 ?? ?? ?? ?? 83 C4 04 8B E5 5D C3 }
	condition:
		$1
}

rule file_3_289_1 {
	meta:
		name = "?_Tidy@?$numpunct@D@std@@AAEXXZ"
		size = 56
		refs = "000f _free"
		altNames = "?_Tidy@?$numpunct@G@std@@AAEXXZ ?_Tidy@?$numpunct@_W@std@@AAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 48 08 51 E8 ?? ?? ?? ?? 83 C4 04 8B 55 FC 8B 42 10 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D FC 8B 51 14 52 E8 ?? ?? ?? ?? 83 C4 04 8B E5 5D C3 }
	condition:
		$1
}

rule file_3_290_1 {
	meta:
		name = "?_Xlen@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBEXXZ"
		size = 21
		refs = "0008 ??_C@_0BA@JFNIOLAK@string?5too?5long?$AA@ 000d ?_Xlength_error@std@@YAXPBD@Z"
		altNames = "?_Xlen@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QBEXXZ ?_Xlen@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QBEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_19_335_3 {
	meta:
		name = "?_Xran@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBEXXZ"
		size = 21
		refs = "0008 ??_C@_0BI@CFPLBAOH@invalid?5string?5position?$AA@ 000d ?_Xout_of_range@std@@YAXPBD@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_10_1226_3 {
	meta:
		name = "?_Xran@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QBEXXZ"
		size = 21
		refs = "0008 ??_C@_0BI@CFPLBAOH@invalid?5string?5position?$AA@ 000d ?_Xout_of_range@std@@YAXPBD@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_29_1025_1 {
	meta:
		name = "?_Xran@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QBEXXZ"
		size = 21
		refs = "0008 ??_C@_0BI@CFPLBAOH@invalid?5string?5position?$AA@ 000d ?_Xout_of_range@std@@YAXPBD@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_3_295_1 {
	meta:
		name = "?allocate@?$allocator@D@std@@QAEPADI@Z"
		size = 29
		refs = "0010 ?_Allocate@std@@YAPAXII_N@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 6A 01 6A 01 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_3_296_1 {
	meta:
		name = "?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAAV12@ABV12@@Z"
		size = 33
		refs = "0008 ?npos@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@2IB 0017 ?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAAV12@ABV12@II@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC A1 ?? ?? ?? ?? 50 6A 00 8B 4D 08 51 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_29_1037_1 {
	meta:
		name = "?append@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAEAAV12@ABV12@@Z"
		size = 33
		refs = "0008 ?npos@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@2IB 0017 ?append@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAEAAV12@ABV12@II@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC A1 ?? ?? ?? ?? 50 6A 00 8B 4D 08 51 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_29_1040_1 {
	meta:
		name = "?append@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAEAAV12@ABV12@@Z"
		size = 33
		refs = "0008 ?npos@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@2IB 0017 ?append@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAEAAV12@ABV12@II@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC A1 ?? ?? ?? ?? 50 6A 00 8B 4D 08 51 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_3_301_1 {
	meta:
		name = "?assign@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAAV12@ABV12@@Z"
		size = 33
		refs = "0008 ?npos@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@2IB 0017 ?assign@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAAV12@ABV12@II@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC A1 ?? ?? ?? ?? 50 6A 00 8B 4D 08 51 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_29_1049_1 {
	meta:
		name = "?assign@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAEAAV12@ABV12@@Z"
		size = 33
		refs = "0008 ?npos@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@2IB 0017 ?assign@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAEAAV12@ABV12@II@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC A1 ?? ?? ?? ?? 50 6A 00 8B 4D 08 51 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_29_1056_1 {
	meta:
		name = "?assign@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAEAAV12@ABV12@@Z"
		size = 33
		refs = "0008 ?npos@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@2IB 0017 ?assign@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAEAAV12@ABV12@II@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC A1 ?? ?? ?? ?? 50 6A 00 8B 4D 08 51 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_3_297_1 {
	meta:
		name = "?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAAV12@ABV12@II@Z"
		size = 180
		refs = "0012 ?_Check_offset@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBEXI@Z 0022 ?_Clamp_suffix_size@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBEIII@Z 002d ?_Mysize@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAEAAIXZ 0033 ?npos@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@2IB 0042 ?_Xlen@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBEXXZ 0066 ?_Grow@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE_NI_N@Z 0079 ?_Myptr@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QBEPBDXZ 0085 ?_Myptr@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAEPADXZ 0097 ?copy@?$char_traits@D@std@@SAPADPADPBDI@Z 00a6 ?_Eos@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEXI@Z"
	strings:
		$1 = { 55 8B EC 83 EC 08 56 89 4D FC 8B 45 0C 50 8B 4D 08 E8 ?? ?? ?? ?? 8B 4D 10 51 8B 55 0C 52 8B 4D 08 E8 ?? ?? ?? ?? 89 45 10 8B 4D FC E8 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 2B 08 3B 4D 10 77 08 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B 10 03 55 10 89 55 F8 83 7D 10 00 76 4E 6A 00 8B 45 F8 50 8B 4D FC E8 ?? ?? ?? ?? 0F B6 C8 85 C9 74 39 8B 55 10 52 8B 4D 08 E8 ?? ?? ?? ?? 03 45 0C 50 8B 4D FC E8 ?? ?? ?? ?? 8B F0 8B 4D FC E8 ?? ?? ?? ?? 03 30 56 E8 ?? ?? ?? ?? 83 C4 0C 8B 45 F8 50 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 5E 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule file_3_298_1 {
	meta:
		name = "?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAAV12@ID@Z"
		size = 130
		refs = "000d ?_Mysize@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAEAAIXZ 0013 ?npos@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@2IB 0022 ?_Xlen@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBEXXZ 0046 ?_Grow@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE_NI_N@Z 0069 ?_Chassign@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEXIID@Z 0075 ?_Eos@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEXI@Z"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 2B 08 3B 4D 08 77 08 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B 10 03 55 08 89 55 F8 83 7D 08 00 76 3D 6A 00 8B 45 F8 50 8B 4D FC E8 ?? ?? ?? ?? 0F B6 C8 85 C9 74 28 0F B6 55 0C 52 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 08 51 8B 4D FC E8 ?? ?? ?? ?? 8B 55 F8 52 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_3_299_1 {
	meta:
		name = "?assign@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAAV12@$$QAV12@@Z"
		size = 171
		refs = "0006 __ehhandler$?assign@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAAV12@$$QAV12@@Z 0015 ___security_cookie 003a ?get_allocator@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBE?AV?$allocator@D@2@XZ 004d ??$?9DD@std@@YA_NABV?$allocator@D@0@0@Z 005f ?_Myres@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAEAAIXZ 0070 ??4?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAAV01@ABV01@@Z 007e ?_Tidy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEX_NI@Z 0087 ??$forward@V?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@@std@@YA$$QAV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@0@AAV10@@Z 0093 ?_Assign_rv@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEX$$QAV12@@Z"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 08 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D EC 8B 45 EC 3B 45 08 75 02 EB 65 8D 4D F3 51 8B 4D 08 E8 ?? ?? ?? ?? 50 8D 55 F2 52 8B 4D EC E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 08 0F B6 C0 85 C0 74 1B 8B 4D 08 E8 ?? ?? ?? ?? 83 38 10 72 0E 8B 4D 08 51 8B 4D EC E8 ?? ?? ?? ?? EB 21 6A 00 6A 01 8B 4D EC E8 ?? ?? ?? ?? 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 50 8B 4D EC E8 ?? ?? ?? ?? 8B 45 EC 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_3_300_1 {
	meta:
		name = "__ehhandler$?assign@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAAV12@$$QAV12@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?assign@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAAV12@$$QAV12@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_0_6_2 {
	meta:
		name = "__ehhandler$??$?0U?$_Wrap_alloc@V?$allocator@D@std@@@std@@X@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAE@$$QAU?$_Wrap_alloc@V?$allocator@D@std@@@1@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$?0U?$_Wrap_alloc@V?$allocator@D@std@@@std@@X@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAE@$$QAU?$_Wrap_alloc@V?$allocator@D@std@@@1@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_15_2 {
	meta:
		name = "__ehhandler$??$?0U?$_Wrap_alloc@V?$allocator@G@std@@@std@@X@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAE@$$QAU?$_Wrap_alloc@V?$allocator@G@std@@@1@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$?0U?$_Wrap_alloc@V?$allocator@G@std@@@std@@X@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAE@$$QAU?$_Wrap_alloc@V?$allocator@G@std@@@1@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_19_3 {
	meta:
		name = "__ehhandler$??$?0U?$_Wrap_alloc@V?$allocator@_W@std@@@std@@X@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAE@$$QAU?$_Wrap_alloc@V?$allocator@_W@std@@@1@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$?0U?$_Wrap_alloc@V?$allocator@_W@std@@@std@@X@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAE@$$QAU?$_Wrap_alloc@V?$allocator@_W@std@@@1@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_259_2 {
	meta:
		name = "__ehhandler$??0?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_308_3 {
	meta:
		name = "__ehhandler$??0?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_97_28_2 {
	meta:
		name = "__ehhandler$??0?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_42_76_3 {
	meta:
		name = "__ehhandler$??0?$basic_istream@DU?$char_traits@D@std@@@std@@QAE@PAV?$basic_streambuf@DU?$char_traits@D@std@@@1@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_istream@DU?$char_traits@D@std@@@std@@QAE@PAV?$basic_streambuf@DU?$char_traits@D@std@@@1@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_47_1 {
	meta:
		name = "__ehhandler$??0?$basic_istream@GU?$char_traits@G@std@@@std@@QAE@PAV?$basic_streambuf@GU?$char_traits@G@std@@@1@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_istream@GU?$char_traits@G@std@@@std@@QAE@PAV?$basic_streambuf@GU?$char_traits@G@std@@@1@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_69_89_3 {
	meta:
		name = "__ehhandler$??0?$basic_istream@_WU?$char_traits@_W@std@@@std@@QAE@PAV?$basic_streambuf@_WU?$char_traits@_W@std@@@1@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_istream@_WU?$char_traits@_W@std@@@std@@QAE@PAV?$basic_streambuf@_WU?$char_traits@_W@std@@@1@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_65_69_2 {
	meta:
		name = "__ehhandler$??0?$basic_ostream@DU?$char_traits@D@std@@@std@@QAE@PAV?$basic_streambuf@DU?$char_traits@D@std@@@1@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_ostream@DU?$char_traits@D@std@@@std@@QAE@PAV?$basic_streambuf@DU?$char_traits@D@std@@@1@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_85_89_3 {
	meta:
		name = "__ehhandler$??0?$basic_ostream@GU?$char_traits@G@std@@@std@@QAE@PAV?$basic_streambuf@GU?$char_traits@G@std@@@1@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_ostream@GU?$char_traits@G@std@@@std@@QAE@PAV?$basic_streambuf@GU?$char_traits@G@std@@@1@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_92_89_3 {
	meta:
		name = "__ehhandler$??0?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAE@PAV?$basic_streambuf@_WU?$char_traits@_W@std@@@1@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAE@PAV?$basic_streambuf@_WU?$char_traits@_W@std@@@1@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_47_95_3 {
	meta:
		name = "__ehhandler$??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@ABV01@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_319_2 {
	meta:
		name = "__ehhandler$??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE@ABV01@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_29_267_1 {
	meta:
		name = "__ehhandler$??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE@ABV01@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_47_188_3 {
	meta:
		name = "__ehhandler$??1_Iterator_base12@std@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1_Iterator_base12@std@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_100_270_3 {
	meta:
		name = "__ehhandler$??4_Iterator_base12@std@@QAEAAU01@ABU01@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??4_Iterator_base12@std@@QAEAAU01@ABU01@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_79_102_2 {
	meta:
		name = "__ehhandler$?_Delete_this@?$_Ref_count_obj_alloc@V__ExceptionPtr@@U?$_StaticAllocator@H@@@std@@EAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Delete_this@?$_Ref_count_obj_alloc@V__ExceptionPtr@@U?$_StaticAllocator@H@@@std@@EAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_100_18_2 {
	meta:
		name = "__ehhandler$?_Rethrow_future_exception@std@@YAXVexception_ptr@1@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Rethrow_future_exception@std@@YAXVexception_ptr@1@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_93_131_1 {
	meta:
		name = "__ehhandler$?__ExceptionPtrCurrentException@@YAXPAX@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?__ExceptionPtrCurrentException@@YAXPAX@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_1253_3 {
	meta:
		name = "__ehhandler$?assign@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAEAAV12@$$QAV12@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?assign@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAEAAV12@$$QAV12@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_29_1055_1 {
	meta:
		name = "__ehhandler$?assign@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAEAAV12@$$QAV12@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?assign@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAEAAV12@$$QAV12@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_48_333_2 {
	meta:
		name = "__ehhandler$?begin@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE?AV?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@2@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?begin@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE?AV?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@2@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_1273_3 {
	meta:
		name = "__ehhandler$?begin@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE?AV?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@2@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?begin@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE?AV?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@2@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_29_1070_1 {
	meta:
		name = "__ehhandler$?begin@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE?AV?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@2@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?begin@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE?AV?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@2@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_59_203_3 {
	meta:
		name = "__ehhandler$?default_error_condition@_System_error_category@std@@UBE?AVerror_condition@2@H@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?default_error_condition@_System_error_category@std@@UBE?AVerror_condition@2@H@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_100_599_3 {
	meta:
		name = "__ehhandler$?end@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE?AV?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@2@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?end@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE?AV?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@2@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_1500_2 {
	meta:
		name = "__ehhandler$?end@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE?AV?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@2@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?end@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE?AV?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@2@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_152_3 {
	meta:
		name = "__ehhandler$?end@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE?AV?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@2@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?end@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE?AV?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@2@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_70_2_2 {
	meta:
		name = "__ehhandler$?get_new_handler@std@@YAP6AXXZXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?get_new_handler@std@@YAP6AXXZXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_3_302_1 {
	meta:
		name = "?assign@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAAV12@ABV12@II@Z"
		size = 152
		refs = "000f ?_Check_offset@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBEXI@Z 001f ?_Clamp_suffix_size@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBEIII@Z 0039 ?erase@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAAV12@I@Z 0047 ?erase@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAAV12@II@Z 0057 ?_Grow@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE_NI_N@Z 006a ?_Myptr@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QBEPBDXZ 0076 ?_Myptr@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAEPADXZ 007c ?copy@?$char_traits@D@std@@SAPADPADPBDI@Z 008b ?_Eos@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEXI@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 0C 50 8B 4D 08 E8 ?? ?? ?? ?? 8B 4D 10 51 8B 55 0C 52 8B 4D 08 E8 ?? ?? ?? ?? 89 45 10 8B 45 FC 3B 45 08 75 1F 8B 4D 0C 03 4D 10 51 8B 4D FC E8 ?? ?? ?? ?? 8B 55 0C 52 6A 00 8B 4D FC E8 ?? ?? ?? ?? EB 42 6A 00 8B 45 10 50 8B 4D FC E8 ?? ?? ?? ?? 0F B6 C8 85 C9 74 2D 8B 55 10 52 8B 4D 08 E8 ?? ?? ?? ?? 03 45 0C 50 8B 4D FC E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 0C 8B 45 10 50 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule file_3_303_1 {
	meta:
		name = "?assign@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAAV12@ID@Z"
		size = 87
		refs = "000c ?npos@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@2IB 0016 ?_Xlen@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBEXXZ 0024 ?_Grow@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE_NI_N@Z 003e ?_Chassign@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEXIID@Z 004a ?_Eos@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEXI@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 3B 05 ?? ?? ?? ?? 75 08 8B 4D FC E8 ?? ?? ?? ?? 6A 00 8B 4D 08 51 8B 4D FC E8 ?? ?? ?? ?? 0F B6 D0 85 D2 74 1F 0F B6 45 0C 50 8B 4D 08 51 6A 00 8B 4D FC E8 ?? ?? ?? ?? 8B 55 08 52 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_3_304_1 {
	meta:
		name = "?assign@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAAV12@PBD@Z"
		size = 38
		refs = "000c ?length@?$char_traits@D@std@@SAIPBD@Z 001c ?assign@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAAV12@PBDI@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 50 8B 4D 08 51 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_48_324_2 {
	meta:
		name = "?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAAV12@PBD@Z"
		size = 38
		refs = "000c ?length@?$char_traits@D@std@@SAIPBD@Z 001c ?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAAV12@PBDI@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 50 8B 4D 08 51 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_69_78_1 {
	meta:
		name = "?append@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAEAAV12@PB_W@Z"
		size = 38
		refs = "000c ?length@?$char_traits@_W@std@@SAIPB_W@Z 001c ?append@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAEAAV12@PB_WI@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 50 8B 4D 08 51 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_44_1204_2 {
	meta:
		name = "?assign@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAEAAV12@PBG@Z"
		size = 38
		refs = "000c ?length@?$char_traits@G@std@@SAIPBG@Z 001c ?assign@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAEAAV12@PBGI@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 50 8B 4D 08 51 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_69_81_1 {
	meta:
		name = "?assign@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAEAAV12@PB_W@Z"
		size = 38
		refs = "000c ?length@?$char_traits@_W@std@@SAIPB_W@Z 001c ?assign@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAEAAV12@PB_WI@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 50 8B 4D 08 51 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_3_305_1 {
	meta:
		name = "?assign@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAAV12@PBDI@Z"
		size = 125
		refs = "000f ?_Inside@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE_NPBD@Z 0022 ?_Myptr@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAEPADXZ 0034 ?assign@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAAV12@ABV12@II@Z 0044 ?_Grow@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE_NI_N@Z 0061 ?copy@?$char_traits@D@std@@SAPADPADPBDI@Z 0070 ?_Eos@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEXI@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 0F B6 C8 85 C9 74 20 8B 55 0C 52 8B 4D FC E8 ?? ?? ?? ?? 8B 4D 08 2B C8 51 8B 55 FC 52 8B 4D FC E8 ?? ?? ?? ?? EB 3D 6A 00 8B 45 0C 50 8B 4D FC E8 ?? ?? ?? ?? 0F B6 C8 85 C9 74 25 8B 55 0C 52 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 0C 8B 4D 0C 51 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_3_306_1 {
	meta:
		name = "?assign@?$char_traits@D@std@@SAPADPADID@Z"
		size = 26
		refs = "0011 _memset"
	strings:
		$1 = { 55 8B EC 8B 45 0C 50 0F BE 4D 10 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_3_311_1 {
	meta:
		name = "?c_str@locale@std@@QBEPBDXZ"
		size = 51
		refs = "0015 ??_C@_00CNPNBAHC@?$AA@ 0025 ?c_str@?$_Yarn@D@std@@QBEPBDXZ"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D FC 8B 45 FC 83 78 04 00 75 09 C7 45 F8 ?? ?? ?? ?? EB 11 8B 4D FC 8B 49 04 83 C1 18 E8 ?? ?? ?? ?? 89 45 F8 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_3_312_1 {
	meta:
		name = "?copy@?$char_traits@D@std@@SAPADPADPBDI@Z"
		size = 48
		refs = "001f _memcpy"
	strings:
		$1 = { 55 8B EC 51 83 7D 10 00 75 08 8B 45 08 89 45 FC EB 17 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 89 45 FC 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_84_299_1 {
	meta:
		name = "?copy@?$char_traits@G@std@@SAPAGPAGPBGI@Z"
		size = 48
		refs = "001f _wmemcpy"
	strings:
		$1 = { 55 8B EC 51 83 7D 10 00 75 08 8B 45 08 89 45 FC EB 17 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 89 45 FC 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_47_369_3 {
	meta:
		name = "?copy@?$char_traits@_W@std@@SAPA_WPA_WPB_WI@Z"
		size = 48
		refs = "001f _wmemcpy"
	strings:
		$1 = { 55 8B EC 51 83 7D 10 00 75 08 8B 45 08 89 45 FC EB 17 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 89 45 FC 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_4_181_3 {
	meta:
		name = "?move@?$char_traits@D@std@@SAPADPADPBDI@Z"
		size = 48
		refs = "001f _memmove"
	strings:
		$1 = { 55 8B EC 51 83 7D 10 00 75 08 8B 45 08 89 45 FC EB 17 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 89 45 FC 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_44_1556_2 {
	meta:
		name = "?move@?$char_traits@G@std@@SAPAGPAGPBGI@Z"
		size = 48
		refs = "001f _wmemmove"
	strings:
		$1 = { 55 8B EC 51 83 7D 10 00 75 08 8B 45 08 89 45 FC EB 17 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 89 45 FC 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_49_160_3 {
	meta:
		name = "?move@?$char_traits@_W@std@@SAPA_WPA_WPB_WI@Z"
		size = 48
		refs = "001f _wmemmove"
	strings:
		$1 = { 55 8B EC 51 83 7D 10 00 75 08 8B 45 08 89 45 FC EB 17 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 89 45 FC 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_3_313_1 {
	meta:
		name = "?deallocate@?$_Wrap_alloc@V?$allocator@D@std@@@std@@QAEXPADI@Z"
		size = 29
		refs = "0013 ?deallocate@?$allocator@D@std@@QAEXPADI@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 0C 50 8B 4D 08 51 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_93_140_1 {
	meta:
		name = "?deallocate@?$_Wrap_alloc@U?$_StaticAllocator@V?$_Ref_count_obj_alloc@V__ExceptionPtr@@U?$_StaticAllocator@H@@@std@@@@@std@@QAEXPAV?$_Ref_count_obj_alloc@V__ExceptionPtr@@U?$_StaticAllocator@H@@@2@I@Z"
		size = 29
		refs = "0013 ?deallocate@?$_StaticAllocator@V?$_Ref_count_obj_alloc@V__ExceptionPtr@@U?$_StaticAllocator@H@@@std@@@@QBEXPAV?$_Ref_count_obj_alloc@V__ExceptionPtr@@U?$_StaticAllocator@H@@@std@@I@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 0C 50 8B 4D 08 51 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_29_1087_1 {
	meta:
		name = "?deallocate@?$_Wrap_alloc@V?$allocator@G@std@@@std@@QAEXPAGI@Z"
		size = 29
		refs = "0013 ?deallocate@?$allocator@G@std@@QAEXPAGI@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 0C 50 8B 4D 08 51 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_46_358_3 {
	meta:
		name = "?deallocate@?$_Wrap_alloc@V?$allocator@U_Container_proxy@std@@@std@@@std@@QAEXPAU_Container_proxy@2@I@Z"
		size = 29
		refs = "0013 ?deallocate@?$allocator@U_Container_proxy@std@@@std@@QAEXPAU_Container_proxy@2@I@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 0C 50 8B 4D 08 51 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_29_1088_1 {
	meta:
		name = "?deallocate@?$_Wrap_alloc@V?$allocator@_W@std@@@std@@QAEXPA_WI@Z"
		size = 29
		refs = "0013 ?deallocate@?$allocator@_W@std@@QAEXPA_WI@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 0C 50 8B 4D 08 51 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_3_314_1 {
	meta:
		name = "?deallocate@?$allocator@D@std@@QAEXPADI@Z"
		size = 31
		refs = "0012 ?_Deallocate@std@@YAXPAXII@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 6A 01 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_3_315_1 {
	meta:
		name = "?decimal_point@?$numpunct@D@std@@QBEDXZ"
		size = 38
		refs = "0018 @_guard_check_icall@4"
		altNames = "?always_noconv@codecvt_base@std@@QBE_NXZ ?date_order@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QBE?AW4dateorder@time_base@2@XZ ?date_order@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QBE?AW4dateorder@time_base@2@XZ ?date_order@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QBE?AW4dateorder@time_base@2@XZ ?decimal_point@?$_Mpunct@D@std@@QBEDXZ ?decimal_point@?$_Mpunct@G@std@@QBEGXZ ?decimal_point@?$_Mpunct@_W@std@@QBE_WXZ ?decimal_point@?$numpunct@G@std@@QBEGXZ ?decimal_point@?$numpunct@_W@std@@QBE_WXZ"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D FC 8B 45 FC 8B 08 8B 51 0C 89 55 F8 8B 4D F8 E8 ?? ?? ?? ?? 8B 4D FC FF 55 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_3_318_1 {
	meta:
		name = "?do_decimal_point@?$numpunct@D@std@@MBEDXZ"
		size = 17
		altNames = "?do_decimal_point@?$_Mpunct@D@std@@MBEDXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8A 40 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_3_320_1 {
	meta:
		name = "?do_falsename@?$numpunct@D@std@@MBE?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ"
		size = 49
		refs = "001b ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@PBD@Z"
		altNames = "?do_curr_symbol@?$_Mpunct@D@std@@MBE?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D F8 C7 45 FC 00 00 00 00 8B 45 F8 8B 48 10 51 8B 4D 08 E8 ?? ?? ?? ?? 8B 55 FC 83 CA 01 89 55 FC 8B 45 08 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_29_1103_1 {
	meta:
		name = "?do_curr_symbol@?$_Mpunct@G@std@@MBE?AV?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@2@XZ"
		size = 49
		refs = "001b ??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE@PBG@Z"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D F8 C7 45 FC 00 00 00 00 8B 45 F8 8B 48 10 51 8B 4D 08 E8 ?? ?? ?? ?? 8B 55 FC 83 CA 01 89 55 FC 8B 45 08 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_29_1104_1 {
	meta:
		name = "?do_curr_symbol@?$_Mpunct@_W@std@@MBE?AV?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@2@XZ"
		size = 49
		refs = "001b ??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE@PB_W@Z"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D F8 C7 45 FC 00 00 00 00 8B 45 F8 8B 48 10 51 8B 4D 08 E8 ?? ?? ?? ?? 8B 55 FC 83 CA 01 89 55 FC 8B 45 08 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_29_1114_1 {
	meta:
		name = "?do_falsename@?$numpunct@G@std@@MBE?AV?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@2@XZ"
		size = 49
		refs = "001b ??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE@PBG@Z"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D F8 C7 45 FC 00 00 00 00 8B 45 F8 8B 48 10 51 8B 4D 08 E8 ?? ?? ?? ?? 8B 55 FC 83 CA 01 89 55 FC 8B 45 08 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_29_1115_1 {
	meta:
		name = "?do_falsename@?$numpunct@_W@std@@MBE?AV?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@2@XZ"
		size = 49
		refs = "001b ??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE@PB_W@Z"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D F8 C7 45 FC 00 00 00 00 8B 45 F8 8B 48 10 51 8B 4D 08 E8 ?? ?? ?? ?? 8B 55 FC 83 CA 01 89 55 FC 8B 45 08 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_3_321_1 {
	meta:
		name = "?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHAAG@Z"
		size = 360
		refs = "0006 __ehhandler$?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHAAG@Z 0015 ___security_cookie 003a ?getloc@ios_base@std@@QBE?AVlocale@2@XZ 0056 ?flags@ios_base@std@@QBEHXZ 006c ?_Getifld@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@1HABVlocale@2@@Z 0081 ??1locale@std@@QAE@XZ 00bc __Stoulx 00cf ??$?8DU?$char_traits@D@std@@@std@@YA_NABV?$istreambuf_iterator@DU?$char_traits@D@std@@@0@0@Z 015e @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 54 A1 ?? ?? ?? ?? 33 C5 89 45 F0 50 8D 45 F4 64 A3 00 00 00 00 89 4D B0 C7 45 C0 00 00 00 00 8D 45 A0 50 8B 4D 1C E8 ?? ?? ?? ?? 89 45 B8 8B 4D B8 89 4D B4 C7 45 FC 00 00 00 00 8B 55 B4 52 8B 4D 1C E8 ?? ?? ?? ?? 50 8D 45 14 50 8D 4D 0C 51 8D 55 D0 52 8B 45 B0 50 E8 ?? ?? ?? ?? 83 C4 18 89 45 AC C7 45 FC FF FF FF FF 8D 4D A0 E8 ?? ?? ?? ?? B9 01 00 00 00 6B D1 00 0F BE 44 15 D0 83 F8 2D 75 08 8D 4D D1 89 4D C8 EB 06 8D 55 D0 89 55 C8 8B 45 C8 89 45 C4 8D 4D C0 51 8B 55 AC 52 8D 45 A8 50 8B 4D C4 51 E8 ?? ?? ?? ?? 83 C4 10 89 45 CC 8D 55 14 52 8D 45 0C 50 E8 ?? ?? ?? ?? 83 C4 08 0F B6 C8 85 C9 74 0D 8B 55 20 8B 02 83 C8 01 8B 4D 20 89 01 8B 55 A8 3B 55 C4 74 0F 83 7D C0 00 75 09 81 7D CC FF FF 00 00 76 0F 8B 45 20 8B 08 83 C9 02 8B 55 20 89 0A EB 2C B8 01 00 00 00 6B C8 00 0F BE 54 0D D0 83 FA 2D 75 0A 33 C0 2B 45 CC 89 45 BC EB 06 8B 4D CC 89 4D BC 8B 55 24 66 8B 45 BC 66 89 02 8B 4D 08 8B 55 0C 89 11 8B 45 10 89 41 04 8B 45 08 8B 4D F4 64 89 0D 00 00 00 00 59 8B 4D F0 33 CD E8 ?? ?? ?? ?? 8B E5 5D C2 20 00 }
	condition:
		$1
}

rule file_29_1132_1 {
	meta:
		name = "?do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHAAG@Z"
		size = 360
		refs = "0006 __ehhandler$?do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHAAG@Z 0015 ___security_cookie 003a ?getloc@ios_base@std@@QBE?AVlocale@2@XZ 0056 ?flags@ios_base@std@@QBEHXZ 006c ?_Getifld@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@1HABVlocale@2@@Z 0081 ??1locale@std@@QAE@XZ 00bc __Stoulx 00cf ??$?8GU?$char_traits@G@std@@@std@@YA_NABV?$istreambuf_iterator@GU?$char_traits@G@std@@@0@0@Z 015e @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 54 A1 ?? ?? ?? ?? 33 C5 89 45 F0 50 8D 45 F4 64 A3 00 00 00 00 89 4D B0 C7 45 C0 00 00 00 00 8D 45 A0 50 8B 4D 1C E8 ?? ?? ?? ?? 89 45 B8 8B 4D B8 89 4D B4 C7 45 FC 00 00 00 00 8B 55 B4 52 8B 4D 1C E8 ?? ?? ?? ?? 50 8D 45 14 50 8D 4D 0C 51 8D 55 D0 52 8B 45 B0 50 E8 ?? ?? ?? ?? 83 C4 18 89 45 AC C7 45 FC FF FF FF FF 8D 4D A0 E8 ?? ?? ?? ?? B9 01 00 00 00 6B D1 00 0F BE 44 15 D0 83 F8 2D 75 08 8D 4D D1 89 4D C8 EB 06 8D 55 D0 89 55 C8 8B 45 C8 89 45 C4 8D 4D C0 51 8B 55 AC 52 8D 45 A8 50 8B 4D C4 51 E8 ?? ?? ?? ?? 83 C4 10 89 45 CC 8D 55 14 52 8D 45 0C 50 E8 ?? ?? ?? ?? 83 C4 08 0F B6 C8 85 C9 74 0D 8B 55 20 8B 02 83 C8 01 8B 4D 20 89 01 8B 55 A8 3B 55 C4 74 0F 83 7D C0 00 75 09 81 7D CC FF FF 00 00 76 0F 8B 45 20 8B 08 83 C9 02 8B 55 20 89 0A EB 2C B8 01 00 00 00 6B C8 00 0F BE 54 0D D0 83 FA 2D 75 0A 33 C0 2B 45 CC 89 45 BC EB 06 8B 4D CC 89 4D BC 8B 55 24 66 8B 45 BC 66 89 02 8B 4D 08 8B 55 0C 89 11 8B 45 10 89 41 04 8B 45 08 8B 4D F4 64 89 0D 00 00 00 00 59 8B 4D F0 33 CD E8 ?? ?? ?? ?? 8B E5 5D C2 20 00 }
	condition:
		$1
}

rule file_29_1163_1 {
	meta:
		name = "?do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHAAG@Z"
		size = 360
		refs = "0006 __ehhandler$?do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHAAG@Z 0015 ___security_cookie 003a ?getloc@ios_base@std@@QBE?AVlocale@2@XZ 0056 ?flags@ios_base@std@@QBEHXZ 006c ?_Getifld@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@1HABVlocale@2@@Z 0081 ??1locale@std@@QAE@XZ 00bc __Stoulx 00cf ??$?8_WU?$char_traits@_W@std@@@std@@YA_NABV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@0@0@Z 015e @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 54 A1 ?? ?? ?? ?? 33 C5 89 45 F0 50 8D 45 F4 64 A3 00 00 00 00 89 4D B0 C7 45 C0 00 00 00 00 8D 45 A0 50 8B 4D 1C E8 ?? ?? ?? ?? 89 45 B8 8B 4D B8 89 4D B4 C7 45 FC 00 00 00 00 8B 55 B4 52 8B 4D 1C E8 ?? ?? ?? ?? 50 8D 45 14 50 8D 4D 0C 51 8D 55 D0 52 8B 45 B0 50 E8 ?? ?? ?? ?? 83 C4 18 89 45 AC C7 45 FC FF FF FF FF 8D 4D A0 E8 ?? ?? ?? ?? B9 01 00 00 00 6B D1 00 0F BE 44 15 D0 83 F8 2D 75 08 8D 4D D1 89 4D C8 EB 06 8D 55 D0 89 55 C8 8B 45 C8 89 45 C4 8D 4D C0 51 8B 55 AC 52 8D 45 A8 50 8B 4D C4 51 E8 ?? ?? ?? ?? 83 C4 10 89 45 CC 8D 55 14 52 8D 45 0C 50 E8 ?? ?? ?? ?? 83 C4 08 0F B6 C8 85 C9 74 0D 8B 55 20 8B 02 83 C8 01 8B 4D 20 89 01 8B 55 A8 3B 55 C4 74 0F 83 7D C0 00 75 09 81 7D CC FF FF 00 00 76 0F 8B 45 20 8B 08 83 C9 02 8B 55 20 89 0A EB 2C B8 01 00 00 00 6B C8 00 0F BE 54 0D D0 83 FA 2D 75 0A 33 C0 2B 45 CC 89 45 BC EB 06 8B 4D CC 89 4D BC 8B 55 24 66 8B 45 BC 66 89 02 8B 4D 08 8B 55 0C 89 11 8B 45 10 89 41 04 8B 45 08 8B 4D F4 64 89 0D 00 00 00 00 59 8B 4D F0 33 CD E8 ?? ?? ?? ?? 8B E5 5D C2 20 00 }
	condition:
		$1
}

rule file_3_323_1 {
	meta:
		name = "__ehhandler$?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHAAG@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHAAG@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A A8 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_110_211_1 {
	meta:
		name = "__ehhandler$?_Endwrite@?$basic_filebuf@DU?$char_traits@D@std@@@std@@IAE_NXZ"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?_Endwrite@?$basic_filebuf@DU?$char_traits@D@std@@@std@@IAE_NXZ 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A A8 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_3_326_1 {
	meta:
		name = "__ehhandler$?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHAAI@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHAAI@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A A8 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_3_338_1 {
	meta:
		name = "__ehhandler$?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHAAPAX@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHAAPAX@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A A8 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_1341_3 {
	meta:
		name = "__ehhandler$?do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHAAG@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHAAG@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A A8 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_1344_3 {
	meta:
		name = "__ehhandler$?do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHAAI@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHAAI@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A A8 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_1356_3 {
	meta:
		name = "__ehhandler$?do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHAAPAX@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHAAPAX@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A A8 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_1319_2 {
	meta:
		name = "__ehhandler$?do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHAAG@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHAAG@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A A8 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_1322_2 {
	meta:
		name = "__ehhandler$?do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHAAI@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHAAI@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A A8 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_1334_2 {
	meta:
		name = "__ehhandler$?do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHAAPAX@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHAAPAX@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A A8 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_3_363_1 {
	meta:
		name = "__ehhandler$?do_put@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AAVios_base@2@DN@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?do_put@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AAVios_base@2@DN@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A A8 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_3_366_1 {
	meta:
		name = "__ehhandler$?do_put@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AAVios_base@2@DO@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?do_put@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AAVios_base@2@DO@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A A8 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_29_1275_1 {
	meta:
		name = "__ehhandler$?do_put@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AAVios_base@2@GN@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?do_put@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AAVios_base@2@GN@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A A8 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_29_1278_1 {
	meta:
		name = "__ehhandler$?do_put@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AAVios_base@2@GO@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?do_put@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AAVios_base@2@GO@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A A8 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_29_1290_1 {
	meta:
		name = "__ehhandler$?do_put@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AAVios_base@2@_WN@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?do_put@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AAVios_base@2@_WN@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A A8 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_29_1293_1 {
	meta:
		name = "__ehhandler$?do_put@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AAVios_base@2@_WO@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?do_put@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AAVios_base@2@_WO@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A A8 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_1458_2 {
	meta:
		name = "__ehhandler$?do_put@?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AAVios_base@2@GPBUtm@@DD@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?do_put@?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AAVios_base@2@GPBUtm@@DD@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A A8 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_1462_2 {
	meta:
		name = "__ehhandler$?do_put@?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AAVios_base@2@_WPBUtm@@DD@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?do_put@?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AAVios_base@2@_WPBUtm@@DD@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A A8 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_3_324_1 {
	meta:
		name = "?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHAAI@Z"
		size = 355
		refs = "0006 __ehhandler$?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHAAI@Z 0015 ___security_cookie 003a ?getloc@ios_base@std@@QBE?AVlocale@2@XZ 0056 ?flags@ios_base@std@@QBEHXZ 006c ?_Getifld@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@1HABVlocale@2@@Z 0081 ??1locale@std@@QAE@XZ 00bc __Stoulx 00cf ??$?8DU?$char_traits@D@std@@@std@@YA_NABV?$istreambuf_iterator@DU?$char_traits@D@std@@@0@0@Z 0159 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 54 A1 ?? ?? ?? ?? 33 C5 89 45 F0 50 8D 45 F4 64 A3 00 00 00 00 89 4D B0 C7 45 C0 00 00 00 00 8D 45 A0 50 8B 4D 1C E8 ?? ?? ?? ?? 89 45 B8 8B 4D B8 89 4D B4 C7 45 FC 00 00 00 00 8B 55 B4 52 8B 4D 1C E8 ?? ?? ?? ?? 50 8D 45 14 50 8D 4D 0C 51 8D 55 D0 52 8B 45 B0 50 E8 ?? ?? ?? ?? 83 C4 18 89 45 AC C7 45 FC FF FF FF FF 8D 4D A0 E8 ?? ?? ?? ?? B9 01 00 00 00 6B D1 00 0F BE 44 15 D0 83 F8 2D 75 08 8D 4D D1 89 4D C8 EB 06 8D 55 D0 89 55 C8 8B 45 C8 89 45 C4 8D 4D C0 51 8B 55 AC 52 8D 45 A8 50 8B 4D C4 51 E8 ?? ?? ?? ?? 83 C4 10 89 45 CC 8D 55 14 52 8D 45 0C 50 E8 ?? ?? ?? ?? 83 C4 08 0F B6 C8 85 C9 74 0D 8B 55 20 8B 02 83 C8 01 8B 4D 20 89 01 8B 55 A8 3B 55 C4 74 0C 83 7D C0 00 75 06 83 7D CC FF 76 0F 8B 45 20 8B 08 83 C9 02 8B 55 20 89 0A EB 2A B8 01 00 00 00 6B C8 00 0F BE 54 0D D0 83 FA 2D 75 0A 33 C0 2B 45 CC 89 45 BC EB 06 8B 4D CC 89 4D BC 8B 55 24 8B 45 BC 89 02 8B 4D 08 8B 55 0C 89 11 8B 45 10 89 41 04 8B 45 08 8B 4D F4 64 89 0D 00 00 00 00 59 8B 4D F0 33 CD E8 ?? ?? ?? ?? 8B E5 5D C2 20 00 }
	condition:
		$1
}

rule file_29_1135_1 {
	meta:
		name = "?do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHAAI@Z"
		size = 355
		refs = "0006 __ehhandler$?do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHAAI@Z 0015 ___security_cookie 003a ?getloc@ios_base@std@@QBE?AVlocale@2@XZ 0056 ?flags@ios_base@std@@QBEHXZ 006c ?_Getifld@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@1HABVlocale@2@@Z 0081 ??1locale@std@@QAE@XZ 00bc __Stoulx 00cf ??$?8GU?$char_traits@G@std@@@std@@YA_NABV?$istreambuf_iterator@GU?$char_traits@G@std@@@0@0@Z 0159 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 54 A1 ?? ?? ?? ?? 33 C5 89 45 F0 50 8D 45 F4 64 A3 00 00 00 00 89 4D B0 C7 45 C0 00 00 00 00 8D 45 A0 50 8B 4D 1C E8 ?? ?? ?? ?? 89 45 B8 8B 4D B8 89 4D B4 C7 45 FC 00 00 00 00 8B 55 B4 52 8B 4D 1C E8 ?? ?? ?? ?? 50 8D 45 14 50 8D 4D 0C 51 8D 55 D0 52 8B 45 B0 50 E8 ?? ?? ?? ?? 83 C4 18 89 45 AC C7 45 FC FF FF FF FF 8D 4D A0 E8 ?? ?? ?? ?? B9 01 00 00 00 6B D1 00 0F BE 44 15 D0 83 F8 2D 75 08 8D 4D D1 89 4D C8 EB 06 8D 55 D0 89 55 C8 8B 45 C8 89 45 C4 8D 4D C0 51 8B 55 AC 52 8D 45 A8 50 8B 4D C4 51 E8 ?? ?? ?? ?? 83 C4 10 89 45 CC 8D 55 14 52 8D 45 0C 50 E8 ?? ?? ?? ?? 83 C4 08 0F B6 C8 85 C9 74 0D 8B 55 20 8B 02 83 C8 01 8B 4D 20 89 01 8B 55 A8 3B 55 C4 74 0C 83 7D C0 00 75 06 83 7D CC FF 76 0F 8B 45 20 8B 08 83 C9 02 8B 55 20 89 0A EB 2A B8 01 00 00 00 6B C8 00 0F BE 54 0D D0 83 FA 2D 75 0A 33 C0 2B 45 CC 89 45 BC EB 06 8B 4D CC 89 4D BC 8B 55 24 8B 45 BC 89 02 8B 4D 08 8B 55 0C 89 11 8B 45 10 89 41 04 8B 45 08 8B 4D F4 64 89 0D 00 00 00 00 59 8B 4D F0 33 CD E8 ?? ?? ?? ?? 8B E5 5D C2 20 00 }
	condition:
		$1
}

rule file_29_1166_1 {
	meta:
		name = "?do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHAAI@Z"
		size = 355
		refs = "0006 __ehhandler$?do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHAAI@Z 0015 ___security_cookie 003a ?getloc@ios_base@std@@QBE?AVlocale@2@XZ 0056 ?flags@ios_base@std@@QBEHXZ 006c ?_Getifld@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@1HABVlocale@2@@Z 0081 ??1locale@std@@QAE@XZ 00bc __Stoulx 00cf ??$?8_WU?$char_traits@_W@std@@@std@@YA_NABV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@0@0@Z 0159 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 54 A1 ?? ?? ?? ?? 33 C5 89 45 F0 50 8D 45 F4 64 A3 00 00 00 00 89 4D B0 C7 45 C0 00 00 00 00 8D 45 A0 50 8B 4D 1C E8 ?? ?? ?? ?? 89 45 B8 8B 4D B8 89 4D B4 C7 45 FC 00 00 00 00 8B 55 B4 52 8B 4D 1C E8 ?? ?? ?? ?? 50 8D 45 14 50 8D 4D 0C 51 8D 55 D0 52 8B 45 B0 50 E8 ?? ?? ?? ?? 83 C4 18 89 45 AC C7 45 FC FF FF FF FF 8D 4D A0 E8 ?? ?? ?? ?? B9 01 00 00 00 6B D1 00 0F BE 44 15 D0 83 F8 2D 75 08 8D 4D D1 89 4D C8 EB 06 8D 55 D0 89 55 C8 8B 45 C8 89 45 C4 8D 4D C0 51 8B 55 AC 52 8D 45 A8 50 8B 4D C4 51 E8 ?? ?? ?? ?? 83 C4 10 89 45 CC 8D 55 14 52 8D 45 0C 50 E8 ?? ?? ?? ?? 83 C4 08 0F B6 C8 85 C9 74 0D 8B 55 20 8B 02 83 C8 01 8B 4D 20 89 01 8B 55 A8 3B 55 C4 74 0C 83 7D C0 00 75 06 83 7D CC FF 76 0F 8B 45 20 8B 08 83 C9 02 8B 55 20 89 0A EB 2A B8 01 00 00 00 6B C8 00 0F BE 54 0D D0 83 FA 2D 75 0A 33 C0 2B 45 CC 89 45 BC EB 06 8B 4D CC 89 4D BC 8B 55 24 8B 45 BC 89 02 8B 4D 08 8B 55 0C 89 11 8B 45 10 89 41 04 8B 45 08 8B 4D F4 64 89 0D 00 00 00 00 59 8B 4D F0 33 CD E8 ?? ?? ?? ?? 8B E5 5D C2 20 00 }
	condition:
		$1
}

rule file_3_327_1 {
	meta:
		name = "?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHAAJ@Z"
		size = 271
		refs = "0006 __ehhandler$?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHAAJ@Z 0015 ___security_cookie 003e ?getloc@ios_base@std@@QBE?AVlocale@2@XZ 005a ?flags@ios_base@std@@QBEHXZ 0070 ?_Getifld@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@1HABVlocale@2@@Z 0081 __Stolx 0096 ??1locale@std@@QAE@XZ 00a3 ??$?8DU?$char_traits@D@std@@@std@@YA_NABV?$istreambuf_iterator@DU?$char_traits@D@std@@@0@0@Z 0105 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 44 A1 ?? ?? ?? ?? 33 C5 89 45 F0 50 8D 45 F4 64 A3 00 00 00 00 89 4D C0 C7 45 CC 00 00 00 00 8D 45 CC 50 8D 4D B0 51 8B 4D 1C E8 ?? ?? ?? ?? 89 45 C8 8B 55 C8 89 55 C4 C7 45 FC 00 00 00 00 8B 45 C4 50 8B 4D 1C E8 ?? ?? ?? ?? 50 8D 4D 14 51 8D 55 0C 52 8D 45 D0 50 8B 4D C0 51 E8 ?? ?? ?? ?? 83 C4 18 50 8D 55 BC 52 8D 45 D0 50 E8 ?? ?? ?? ?? 83 C4 10 89 45 B8 C7 45 FC FF FF FF FF 8D 4D B0 E8 ?? ?? ?? ?? 8D 4D 14 51 8D 55 0C 52 E8 ?? ?? ?? ?? 83 C4 08 0F B6 C0 85 C0 74 0D 8B 4D 20 8B 11 83 CA 01 8B 45 20 89 10 8D 4D D0 39 4D BC 74 06 83 7D CC 00 74 0F 8B 55 20 8B 02 83 C8 02 8B 4D 20 89 01 EB 08 8B 55 24 8B 45 B8 89 02 8B 4D 08 8B 55 0C 89 11 8B 45 10 89 41 04 8B 45 08 8B 4D F4 64 89 0D 00 00 00 00 59 8B 4D F0 33 CD E8 ?? ?? ?? ?? 8B E5 5D C2 20 00 }
	condition:
		$1
}

rule file_3_330_1 {
	meta:
		name = "?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHAAK@Z"
		size = 271
		refs = "0006 __ehhandler$?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHAAK@Z 0015 ___security_cookie 003e ?getloc@ios_base@std@@QBE?AVlocale@2@XZ 005a ?flags@ios_base@std@@QBEHXZ 0070 ?_Getifld@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@1HABVlocale@2@@Z 0081 __Stoulx 0096 ??1locale@std@@QAE@XZ 00a3 ??$?8DU?$char_traits@D@std@@@std@@YA_NABV?$istreambuf_iterator@DU?$char_traits@D@std@@@0@0@Z 0105 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 44 A1 ?? ?? ?? ?? 33 C5 89 45 F0 50 8D 45 F4 64 A3 00 00 00 00 89 4D C0 C7 45 CC 00 00 00 00 8D 45 CC 50 8D 4D B0 51 8B 4D 1C E8 ?? ?? ?? ?? 89 45 C8 8B 55 C8 89 55 C4 C7 45 FC 00 00 00 00 8B 45 C4 50 8B 4D 1C E8 ?? ?? ?? ?? 50 8D 4D 14 51 8D 55 0C 52 8D 45 D0 50 8B 4D C0 51 E8 ?? ?? ?? ?? 83 C4 18 50 8D 55 BC 52 8D 45 D0 50 E8 ?? ?? ?? ?? 83 C4 10 89 45 B8 C7 45 FC FF FF FF FF 8D 4D B0 E8 ?? ?? ?? ?? 8D 4D 14 51 8D 55 0C 52 E8 ?? ?? ?? ?? 83 C4 08 0F B6 C0 85 C0 74 0D 8B 4D 20 8B 11 83 CA 01 8B 45 20 89 10 8D 4D D0 39 4D BC 74 06 83 7D CC 00 74 0F 8B 55 20 8B 02 83 C8 02 8B 4D 20 89 01 EB 08 8B 55 24 8B 45 B8 89 02 8B 4D 08 8B 55 0C 89 11 8B 45 10 89 41 04 8B 45 08 8B 4D F4 64 89 0D 00 00 00 00 59 8B 4D F0 33 CD E8 ?? ?? ?? ?? 8B E5 5D C2 20 00 }
	condition:
		$1
}

rule file_29_1138_1 {
	meta:
		name = "?do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHAAJ@Z"
		size = 271
		refs = "0006 __ehhandler$?do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHAAJ@Z 0015 ___security_cookie 003e ?getloc@ios_base@std@@QBE?AVlocale@2@XZ 005a ?flags@ios_base@std@@QBEHXZ 0070 ?_Getifld@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@1HABVlocale@2@@Z 0081 __Stolx 0096 ??1locale@std@@QAE@XZ 00a3 ??$?8GU?$char_traits@G@std@@@std@@YA_NABV?$istreambuf_iterator@GU?$char_traits@G@std@@@0@0@Z 0105 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 44 A1 ?? ?? ?? ?? 33 C5 89 45 F0 50 8D 45 F4 64 A3 00 00 00 00 89 4D C0 C7 45 CC 00 00 00 00 8D 45 CC 50 8D 4D B0 51 8B 4D 1C E8 ?? ?? ?? ?? 89 45 C8 8B 55 C8 89 55 C4 C7 45 FC 00 00 00 00 8B 45 C4 50 8B 4D 1C E8 ?? ?? ?? ?? 50 8D 4D 14 51 8D 55 0C 52 8D 45 D0 50 8B 4D C0 51 E8 ?? ?? ?? ?? 83 C4 18 50 8D 55 BC 52 8D 45 D0 50 E8 ?? ?? ?? ?? 83 C4 10 89 45 B8 C7 45 FC FF FF FF FF 8D 4D B0 E8 ?? ?? ?? ?? 8D 4D 14 51 8D 55 0C 52 E8 ?? ?? ?? ?? 83 C4 08 0F B6 C0 85 C0 74 0D 8B 4D 20 8B 11 83 CA 01 8B 45 20 89 10 8D 4D D0 39 4D BC 74 06 83 7D CC 00 74 0F 8B 55 20 8B 02 83 C8 02 8B 4D 20 89 01 EB 08 8B 55 24 8B 45 B8 89 02 8B 4D 08 8B 55 0C 89 11 8B 45 10 89 41 04 8B 45 08 8B 4D F4 64 89 0D 00 00 00 00 59 8B 4D F0 33 CD E8 ?? ?? ?? ?? 8B E5 5D C2 20 00 }
	condition:
		$1
}

rule file_29_1141_1 {
	meta:
		name = "?do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHAAK@Z"
		size = 271
		refs = "0006 __ehhandler$?do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHAAK@Z 0015 ___security_cookie 003e ?getloc@ios_base@std@@QBE?AVlocale@2@XZ 005a ?flags@ios_base@std@@QBEHXZ 0070 ?_Getifld@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@1HABVlocale@2@@Z 0081 __Stoulx 0096 ??1locale@std@@QAE@XZ 00a3 ??$?8GU?$char_traits@G@std@@@std@@YA_NABV?$istreambuf_iterator@GU?$char_traits@G@std@@@0@0@Z 0105 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 44 A1 ?? ?? ?? ?? 33 C5 89 45 F0 50 8D 45 F4 64 A3 00 00 00 00 89 4D C0 C7 45 CC 00 00 00 00 8D 45 CC 50 8D 4D B0 51 8B 4D 1C E8 ?? ?? ?? ?? 89 45 C8 8B 55 C8 89 55 C4 C7 45 FC 00 00 00 00 8B 45 C4 50 8B 4D 1C E8 ?? ?? ?? ?? 50 8D 4D 14 51 8D 55 0C 52 8D 45 D0 50 8B 4D C0 51 E8 ?? ?? ?? ?? 83 C4 18 50 8D 55 BC 52 8D 45 D0 50 E8 ?? ?? ?? ?? 83 C4 10 89 45 B8 C7 45 FC FF FF FF FF 8D 4D B0 E8 ?? ?? ?? ?? 8D 4D 14 51 8D 55 0C 52 E8 ?? ?? ?? ?? 83 C4 08 0F B6 C0 85 C0 74 0D 8B 4D 20 8B 11 83 CA 01 8B 45 20 89 10 8D 4D D0 39 4D BC 74 06 83 7D CC 00 74 0F 8B 55 20 8B 02 83 C8 02 8B 4D 20 89 01 EB 08 8B 55 24 8B 45 B8 89 02 8B 4D 08 8B 55 0C 89 11 8B 45 10 89 41 04 8B 45 08 8B 4D F4 64 89 0D 00 00 00 00 59 8B 4D F0 33 CD E8 ?? ?? ?? ?? 8B E5 5D C2 20 00 }
	condition:
		$1
}

rule file_29_1169_1 {
	meta:
		name = "?do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHAAJ@Z"
		size = 271
		refs = "0006 __ehhandler$?do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHAAJ@Z 0015 ___security_cookie 003e ?getloc@ios_base@std@@QBE?AVlocale@2@XZ 005a ?flags@ios_base@std@@QBEHXZ 0070 ?_Getifld@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@1HABVlocale@2@@Z 0081 __Stolx 0096 ??1locale@std@@QAE@XZ 00a3 ??$?8_WU?$char_traits@_W@std@@@std@@YA_NABV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@0@0@Z 0105 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 44 A1 ?? ?? ?? ?? 33 C5 89 45 F0 50 8D 45 F4 64 A3 00 00 00 00 89 4D C0 C7 45 CC 00 00 00 00 8D 45 CC 50 8D 4D B0 51 8B 4D 1C E8 ?? ?? ?? ?? 89 45 C8 8B 55 C8 89 55 C4 C7 45 FC 00 00 00 00 8B 45 C4 50 8B 4D 1C E8 ?? ?? ?? ?? 50 8D 4D 14 51 8D 55 0C 52 8D 45 D0 50 8B 4D C0 51 E8 ?? ?? ?? ?? 83 C4 18 50 8D 55 BC 52 8D 45 D0 50 E8 ?? ?? ?? ?? 83 C4 10 89 45 B8 C7 45 FC FF FF FF FF 8D 4D B0 E8 ?? ?? ?? ?? 8D 4D 14 51 8D 55 0C 52 E8 ?? ?? ?? ?? 83 C4 08 0F B6 C0 85 C0 74 0D 8B 4D 20 8B 11 83 CA 01 8B 45 20 89 10 8D 4D D0 39 4D BC 74 06 83 7D CC 00 74 0F 8B 55 20 8B 02 83 C8 02 8B 4D 20 89 01 EB 08 8B 55 24 8B 45 B8 89 02 8B 4D 08 8B 55 0C 89 11 8B 45 10 89 41 04 8B 45 08 8B 4D F4 64 89 0D 00 00 00 00 59 8B 4D F0 33 CD E8 ?? ?? ?? ?? 8B E5 5D C2 20 00 }
	condition:
		$1
}

rule file_29_1172_1 {
	meta:
		name = "?do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHAAK@Z"
		size = 271
		refs = "0006 __ehhandler$?do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHAAK@Z 0015 ___security_cookie 003e ?getloc@ios_base@std@@QBE?AVlocale@2@XZ 005a ?flags@ios_base@std@@QBEHXZ 0070 ?_Getifld@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@1HABVlocale@2@@Z 0081 __Stoulx 0096 ??1locale@std@@QAE@XZ 00a3 ??$?8_WU?$char_traits@_W@std@@@std@@YA_NABV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@0@0@Z 0105 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 44 A1 ?? ?? ?? ?? 33 C5 89 45 F0 50 8D 45 F4 64 A3 00 00 00 00 89 4D C0 C7 45 CC 00 00 00 00 8D 45 CC 50 8D 4D B0 51 8B 4D 1C E8 ?? ?? ?? ?? 89 45 C8 8B 55 C8 89 55 C4 C7 45 FC 00 00 00 00 8B 45 C4 50 8B 4D 1C E8 ?? ?? ?? ?? 50 8D 4D 14 51 8D 55 0C 52 8D 45 D0 50 8B 4D C0 51 E8 ?? ?? ?? ?? 83 C4 18 50 8D 55 BC 52 8D 45 D0 50 E8 ?? ?? ?? ?? 83 C4 10 89 45 B8 C7 45 FC FF FF FF FF 8D 4D B0 E8 ?? ?? ?? ?? 8D 4D 14 51 8D 55 0C 52 E8 ?? ?? ?? ?? 83 C4 08 0F B6 C0 85 C0 74 0D 8B 4D 20 8B 11 83 CA 01 8B 45 20 89 10 8D 4D D0 39 4D BC 74 06 83 7D CC 00 74 0F 8B 55 20 8B 02 83 C8 02 8B 4D 20 89 01 EB 08 8B 55 24 8B 45 B8 89 02 8B 4D 08 8B 55 0C 89 11 8B 45 10 89 41 04 8B 45 08 8B 4D F4 64 89 0D 00 00 00 00 59 8B 4D F0 33 CD E8 ?? ?? ?? ?? 8B E5 5D C2 20 00 }
	condition:
		$1
}

rule file_3_333_1 {
	meta:
		name = "?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHAAM@Z"
		size = 295
		refs = "000a ___security_cookie 0056 ?_Getffld@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@1AAVios_base@2@PAH@Z 006d ?_Stofx_v2@std@@YAMPBDPAPADHPAH@Z 00a4 _ldexpf 00ba ??$?8DU?$char_traits@D@std@@@std@@YA_NABV?$istreambuf_iterator@DU?$char_traits@D@std@@@0@0@Z 011d @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 81 EC 30 03 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 89 8D D4 FC FF FF C7 85 D8 FC FF FF 00 00 00 00 C7 85 E0 FC FF FF 00 CA 9A 3B 8D 85 D8 FC FF FF 50 8D 8D E0 FC FF FF 51 8B 55 1C 52 8D 45 14 50 8D 4D 0C 51 8D 95 E4 FC FF FF 52 8B 85 D4 FC FF FF 50 E8 ?? ?? ?? ?? 83 C4 18 50 8D 8D D0 FC FF FF 51 8D 95 E4 FC FF FF 52 E8 ?? ?? ?? ?? 83 C4 10 D9 9D DC FC FF FF 81 BD E0 FC FF FF 00 CA 9A 3B 74 2B 83 BD E0 FC FF FF 00 74 22 8B 85 E0 FC FF FF C1 E0 02 50 51 D9 85 DC FC FF FF D9 1C 24 E8 ?? ?? ?? ?? 83 C4 08 D9 9D DC FC FF FF 8D 4D 14 51 8D 55 0C 52 E8 ?? ?? ?? ?? 83 C4 08 0F B6 C0 85 C0 74 0D 8B 4D 20 8B 11 83 CA 01 8B 45 20 89 10 8D 8D E4 FC FF FF 39 8D D0 FC FF FF 74 09 83 BD D8 FC FF FF 00 74 0F 8B 55 20 8B 02 83 C8 02 8B 4D 20 89 01 EB 0B 8B 55 24 D9 85 DC FC FF FF D9 1A 8B 45 08 8B 4D 0C 89 08 8B 55 10 89 50 04 8B 45 08 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C2 20 00 }
	condition:
		$1
}

rule file_29_1144_1 {
	meta:
		name = "?do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHAAM@Z"
		size = 295
		refs = "000a ___security_cookie 0056 ?_Getffld@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@1AAVios_base@2@PAH@Z 006d ?_Stofx_v2@std@@YAMPBDPAPADHPAH@Z 00a4 _ldexpf 00ba ??$?8GU?$char_traits@G@std@@@std@@YA_NABV?$istreambuf_iterator@GU?$char_traits@G@std@@@0@0@Z 011d @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 81 EC 30 03 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 89 8D D4 FC FF FF C7 85 D8 FC FF FF 00 00 00 00 C7 85 E0 FC FF FF 00 CA 9A 3B 8D 85 D8 FC FF FF 50 8D 8D E0 FC FF FF 51 8B 55 1C 52 8D 45 14 50 8D 4D 0C 51 8D 95 E4 FC FF FF 52 8B 85 D4 FC FF FF 50 E8 ?? ?? ?? ?? 83 C4 18 50 8D 8D D0 FC FF FF 51 8D 95 E4 FC FF FF 52 E8 ?? ?? ?? ?? 83 C4 10 D9 9D DC FC FF FF 81 BD E0 FC FF FF 00 CA 9A 3B 74 2B 83 BD E0 FC FF FF 00 74 22 8B 85 E0 FC FF FF C1 E0 02 50 51 D9 85 DC FC FF FF D9 1C 24 E8 ?? ?? ?? ?? 83 C4 08 D9 9D DC FC FF FF 8D 4D 14 51 8D 55 0C 52 E8 ?? ?? ?? ?? 83 C4 08 0F B6 C0 85 C0 74 0D 8B 4D 20 8B 11 83 CA 01 8B 45 20 89 10 8D 8D E4 FC FF FF 39 8D D0 FC FF FF 74 09 83 BD D8 FC FF FF 00 74 0F 8B 55 20 8B 02 83 C8 02 8B 4D 20 89 01 EB 0B 8B 55 24 D9 85 DC FC FF FF D9 1A 8B 45 08 8B 4D 0C 89 08 8B 55 10 89 50 04 8B 45 08 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C2 20 00 }
	condition:
		$1
}

rule file_29_1175_1 {
	meta:
		name = "?do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHAAM@Z"
		size = 295
		refs = "000a ___security_cookie 0056 ?_Getffld@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@1AAVios_base@2@PAH@Z 006d ?_Stofx_v2@std@@YAMPBDPAPADHPAH@Z 00a4 _ldexpf 00ba ??$?8_WU?$char_traits@_W@std@@@std@@YA_NABV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@0@0@Z 011d @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 81 EC 30 03 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 89 8D D4 FC FF FF C7 85 D8 FC FF FF 00 00 00 00 C7 85 E0 FC FF FF 00 CA 9A 3B 8D 85 D8 FC FF FF 50 8D 8D E0 FC FF FF 51 8B 55 1C 52 8D 45 14 50 8D 4D 0C 51 8D 95 E4 FC FF FF 52 8B 85 D4 FC FF FF 50 E8 ?? ?? ?? ?? 83 C4 18 50 8D 8D D0 FC FF FF 51 8D 95 E4 FC FF FF 52 E8 ?? ?? ?? ?? 83 C4 10 D9 9D DC FC FF FF 81 BD E0 FC FF FF 00 CA 9A 3B 74 2B 83 BD E0 FC FF FF 00 74 22 8B 85 E0 FC FF FF C1 E0 02 50 51 D9 85 DC FC FF FF D9 1C 24 E8 ?? ?? ?? ?? 83 C4 08 D9 9D DC FC FF FF 8D 4D 14 51 8D 55 0C 52 E8 ?? ?? ?? ?? 83 C4 08 0F B6 C0 85 C0 74 0D 8B 4D 20 8B 11 83 CA 01 8B 45 20 89 10 8D 8D E4 FC FF FF 39 8D D0 FC FF FF 74 09 83 BD D8 FC FF FF 00 74 0F 8B 55 20 8B 02 83 C8 02 8B 4D 20 89 01 EB 0B 8B 55 24 D9 85 DC FC FF FF D9 1A 8B 45 08 8B 4D 0C 89 08 8B 55 10 89 50 04 8B 45 08 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C2 20 00 }
	condition:
		$1
}

rule file_3_334_1 {
	meta:
		name = "?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHAAN@Z"
		size = 297
		refs = "000a ___security_cookie 0056 ?_Getffld@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@1AAVios_base@2@PAH@Z 006d ?_Stodx_v2@std@@YANPBDPAPADHPAH@Z 00a6 _ldexp 00bc ??$?8DU?$char_traits@D@std@@@std@@YA_NABV?$istreambuf_iterator@DU?$char_traits@D@std@@@0@0@Z 011f @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 81 EC 34 03 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 89 8D D8 FC FF FF C7 85 DC FC FF FF 00 00 00 00 C7 85 E0 FC FF FF 00 CA 9A 3B 8D 85 DC FC FF FF 50 8D 8D E0 FC FF FF 51 8B 55 1C 52 8D 45 14 50 8D 4D 0C 51 8D 95 E4 FC FF FF 52 8B 85 D8 FC FF FF 50 E8 ?? ?? ?? ?? 83 C4 18 50 8D 8D D4 FC FF FF 51 8D 95 E4 FC FF FF 52 E8 ?? ?? ?? ?? 83 C4 10 DD 9D CC FC FF FF 81 BD E0 FC FF FF 00 CA 9A 3B 74 2D 83 BD E0 FC FF FF 00 74 24 8B 85 E0 FC FF FF C1 E0 02 50 83 EC 08 DD 85 CC FC FF FF DD 1C 24 E8 ?? ?? ?? ?? 83 C4 0C DD 9D CC FC FF FF 8D 4D 14 51 8D 55 0C 52 E8 ?? ?? ?? ?? 83 C4 08 0F B6 C0 85 C0 74 0D 8B 4D 20 8B 11 83 CA 01 8B 45 20 89 10 8D 8D E4 FC FF FF 39 8D D4 FC FF FF 74 09 83 BD DC FC FF FF 00 74 0F 8B 55 20 8B 02 83 C8 02 8B 4D 20 89 01 EB 0B 8B 55 24 DD 85 CC FC FF FF DD 1A 8B 45 08 8B 4D 0C 89 08 8B 55 10 89 50 04 8B 45 08 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C2 20 00 }
	condition:
		$1
}

rule file_3_335_1 {
	meta:
		name = "?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHAAO@Z"
		size = 297
		refs = "000a ___security_cookie 0056 ?_Getffld@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@1AAVios_base@2@PAH@Z 006d ?_Stodx_v2@std@@YANPBDPAPADHPAH@Z 00a6 _ldexpl 00bc ??$?8DU?$char_traits@D@std@@@std@@YA_NABV?$istreambuf_iterator@DU?$char_traits@D@std@@@0@0@Z 011f @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 81 EC 34 03 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 89 8D D8 FC FF FF C7 85 DC FC FF FF 00 00 00 00 C7 85 E0 FC FF FF 00 CA 9A 3B 8D 85 DC FC FF FF 50 8D 8D E0 FC FF FF 51 8B 55 1C 52 8D 45 14 50 8D 4D 0C 51 8D 95 E4 FC FF FF 52 8B 85 D8 FC FF FF 50 E8 ?? ?? ?? ?? 83 C4 18 50 8D 8D D4 FC FF FF 51 8D 95 E4 FC FF FF 52 E8 ?? ?? ?? ?? 83 C4 10 DD 9D CC FC FF FF 81 BD E0 FC FF FF 00 CA 9A 3B 74 2D 83 BD E0 FC FF FF 00 74 24 8B 85 E0 FC FF FF C1 E0 02 50 83 EC 08 DD 85 CC FC FF FF DD 1C 24 E8 ?? ?? ?? ?? 83 C4 0C DD 9D CC FC FF FF 8D 4D 14 51 8D 55 0C 52 E8 ?? ?? ?? ?? 83 C4 08 0F B6 C0 85 C0 74 0D 8B 4D 20 8B 11 83 CA 01 8B 45 20 89 10 8D 8D E4 FC FF FF 39 8D D4 FC FF FF 74 09 83 BD DC FC FF FF 00 74 0F 8B 55 20 8B 02 83 C8 02 8B 4D 20 89 01 EB 0B 8B 55 24 DD 85 CC FC FF FF DD 1A 8B 45 08 8B 4D 0C 89 08 8B 55 10 89 50 04 8B 45 08 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C2 20 00 }
	condition:
		$1
}

rule file_29_1145_1 {
	meta:
		name = "?do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHAAN@Z"
		size = 297
		refs = "000a ___security_cookie 0056 ?_Getffld@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@1AAVios_base@2@PAH@Z 006d ?_Stodx_v2@std@@YANPBDPAPADHPAH@Z 00a6 _ldexp 00bc ??$?8GU?$char_traits@G@std@@@std@@YA_NABV?$istreambuf_iterator@GU?$char_traits@G@std@@@0@0@Z 011f @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 81 EC 34 03 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 89 8D D8 FC FF FF C7 85 DC FC FF FF 00 00 00 00 C7 85 E0 FC FF FF 00 CA 9A 3B 8D 85 DC FC FF FF 50 8D 8D E0 FC FF FF 51 8B 55 1C 52 8D 45 14 50 8D 4D 0C 51 8D 95 E4 FC FF FF 52 8B 85 D8 FC FF FF 50 E8 ?? ?? ?? ?? 83 C4 18 50 8D 8D D4 FC FF FF 51 8D 95 E4 FC FF FF 52 E8 ?? ?? ?? ?? 83 C4 10 DD 9D CC FC FF FF 81 BD E0 FC FF FF 00 CA 9A 3B 74 2D 83 BD E0 FC FF FF 00 74 24 8B 85 E0 FC FF FF C1 E0 02 50 83 EC 08 DD 85 CC FC FF FF DD 1C 24 E8 ?? ?? ?? ?? 83 C4 0C DD 9D CC FC FF FF 8D 4D 14 51 8D 55 0C 52 E8 ?? ?? ?? ?? 83 C4 08 0F B6 C0 85 C0 74 0D 8B 4D 20 8B 11 83 CA 01 8B 45 20 89 10 8D 8D E4 FC FF FF 39 8D D4 FC FF FF 74 09 83 BD DC FC FF FF 00 74 0F 8B 55 20 8B 02 83 C8 02 8B 4D 20 89 01 EB 0B 8B 55 24 DD 85 CC FC FF FF DD 1A 8B 45 08 8B 4D 0C 89 08 8B 55 10 89 50 04 8B 45 08 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C2 20 00 }
	condition:
		$1
}

rule file_29_1146_1 {
	meta:
		name = "?do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHAAO@Z"
		size = 297
		refs = "000a ___security_cookie 0056 ?_Getffld@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@1AAVios_base@2@PAH@Z 006d ?_Stodx_v2@std@@YANPBDPAPADHPAH@Z 00a6 _ldexpl 00bc ??$?8GU?$char_traits@G@std@@@std@@YA_NABV?$istreambuf_iterator@GU?$char_traits@G@std@@@0@0@Z 011f @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 81 EC 34 03 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 89 8D D8 FC FF FF C7 85 DC FC FF FF 00 00 00 00 C7 85 E0 FC FF FF 00 CA 9A 3B 8D 85 DC FC FF FF 50 8D 8D E0 FC FF FF 51 8B 55 1C 52 8D 45 14 50 8D 4D 0C 51 8D 95 E4 FC FF FF 52 8B 85 D8 FC FF FF 50 E8 ?? ?? ?? ?? 83 C4 18 50 8D 8D D4 FC FF FF 51 8D 95 E4 FC FF FF 52 E8 ?? ?? ?? ?? 83 C4 10 DD 9D CC FC FF FF 81 BD E0 FC FF FF 00 CA 9A 3B 74 2D 83 BD E0 FC FF FF 00 74 24 8B 85 E0 FC FF FF C1 E0 02 50 83 EC 08 DD 85 CC FC FF FF DD 1C 24 E8 ?? ?? ?? ?? 83 C4 0C DD 9D CC FC FF FF 8D 4D 14 51 8D 55 0C 52 E8 ?? ?? ?? ?? 83 C4 08 0F B6 C0 85 C0 74 0D 8B 4D 20 8B 11 83 CA 01 8B 45 20 89 10 8D 8D E4 FC FF FF 39 8D D4 FC FF FF 74 09 83 BD DC FC FF FF 00 74 0F 8B 55 20 8B 02 83 C8 02 8B 4D 20 89 01 EB 0B 8B 55 24 DD 85 CC FC FF FF DD 1A 8B 45 08 8B 4D 0C 89 08 8B 55 10 89 50 04 8B 45 08 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C2 20 00 }
	condition:
		$1
}

rule file_29_1176_1 {
	meta:
		name = "?do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHAAN@Z"
		size = 297
		refs = "000a ___security_cookie 0056 ?_Getffld@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@1AAVios_base@2@PAH@Z 006d ?_Stodx_v2@std@@YANPBDPAPADHPAH@Z 00a6 _ldexp 00bc ??$?8_WU?$char_traits@_W@std@@@std@@YA_NABV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@0@0@Z 011f @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 81 EC 34 03 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 89 8D D8 FC FF FF C7 85 DC FC FF FF 00 00 00 00 C7 85 E0 FC FF FF 00 CA 9A 3B 8D 85 DC FC FF FF 50 8D 8D E0 FC FF FF 51 8B 55 1C 52 8D 45 14 50 8D 4D 0C 51 8D 95 E4 FC FF FF 52 8B 85 D8 FC FF FF 50 E8 ?? ?? ?? ?? 83 C4 18 50 8D 8D D4 FC FF FF 51 8D 95 E4 FC FF FF 52 E8 ?? ?? ?? ?? 83 C4 10 DD 9D CC FC FF FF 81 BD E0 FC FF FF 00 CA 9A 3B 74 2D 83 BD E0 FC FF FF 00 74 24 8B 85 E0 FC FF FF C1 E0 02 50 83 EC 08 DD 85 CC FC FF FF DD 1C 24 E8 ?? ?? ?? ?? 83 C4 0C DD 9D CC FC FF FF 8D 4D 14 51 8D 55 0C 52 E8 ?? ?? ?? ?? 83 C4 08 0F B6 C0 85 C0 74 0D 8B 4D 20 8B 11 83 CA 01 8B 45 20 89 10 8D 8D E4 FC FF FF 39 8D D4 FC FF FF 74 09 83 BD DC FC FF FF 00 74 0F 8B 55 20 8B 02 83 C8 02 8B 4D 20 89 01 EB 0B 8B 55 24 DD 85 CC FC FF FF DD 1A 8B 45 08 8B 4D 0C 89 08 8B 55 10 89 50 04 8B 45 08 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C2 20 00 }
	condition:
		$1
}

rule file_29_1177_1 {
	meta:
		name = "?do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHAAO@Z"
		size = 297
		refs = "000a ___security_cookie 0056 ?_Getffld@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@1AAVios_base@2@PAH@Z 006d ?_Stodx_v2@std@@YANPBDPAPADHPAH@Z 00a6 _ldexpl 00bc ??$?8_WU?$char_traits@_W@std@@@std@@YA_NABV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@0@0@Z 011f @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 81 EC 34 03 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 89 8D D8 FC FF FF C7 85 DC FC FF FF 00 00 00 00 C7 85 E0 FC FF FF 00 CA 9A 3B 8D 85 DC FC FF FF 50 8D 8D E0 FC FF FF 51 8B 55 1C 52 8D 45 14 50 8D 4D 0C 51 8D 95 E4 FC FF FF 52 8B 85 D8 FC FF FF 50 E8 ?? ?? ?? ?? 83 C4 18 50 8D 8D D4 FC FF FF 51 8D 95 E4 FC FF FF 52 E8 ?? ?? ?? ?? 83 C4 10 DD 9D CC FC FF FF 81 BD E0 FC FF FF 00 CA 9A 3B 74 2D 83 BD E0 FC FF FF 00 74 24 8B 85 E0 FC FF FF C1 E0 02 50 83 EC 08 DD 85 CC FC FF FF DD 1C 24 E8 ?? ?? ?? ?? 83 C4 0C DD 9D CC FC FF FF 8D 4D 14 51 8D 55 0C 52 E8 ?? ?? ?? ?? 83 C4 08 0F B6 C0 85 C0 74 0D 8B 4D 20 8B 11 83 CA 01 8B 45 20 89 10 8D 8D E4 FC FF FF 39 8D D4 FC FF FF 74 09 83 BD DC FC FF FF 00 74 0F 8B 55 20 8B 02 83 C8 02 8B 4D 20 89 01 EB 0B 8B 55 24 DD 85 CC FC FF FF DD 1A 8B 45 08 8B 4D 0C 89 08 8B 55 10 89 50 04 8B 45 08 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C2 20 00 }
	condition:
		$1
}

rule file_3_336_1 {
	meta:
		name = "?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHAAPAX@Z"
		size = 331
		refs = "0006 __ehhandler$?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHAAPAX@Z 0015 ___security_cookie 003a ?getloc@ios_base@std@@QBE?AVlocale@2@XZ 0068 ?_Getifld@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@1HABVlocale@2@@Z 007d ??1locale@std@@QAE@XZ 009b __Stoulx 00bd __Stoullx 00df ??$?8DU?$char_traits@D@std@@@std@@YA_NABV?$istreambuf_iterator@DU?$char_traits@D@std@@@0@0@Z 0141 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 54 A1 ?? ?? ?? ?? 33 C5 89 45 F0 50 8D 45 F4 64 A3 00 00 00 00 89 4D B0 C7 45 CC 00 00 00 00 8D 45 A0 50 8B 4D 1C E8 ?? ?? ?? ?? 89 45 B8 8B 4D B8 89 4D B4 C7 45 FC 00 00 00 00 8B 55 B4 52 68 00 08 00 00 8D 45 14 50 8D 4D 0C 51 8D 55 D0 52 8B 45 B0 50 E8 ?? ?? ?? ?? 83 C4 18 89 45 C8 C7 45 FC FF FF FF FF 8D 4D A0 E8 ?? ?? ?? ?? B9 01 00 00 00 85 C9 74 22 8D 55 CC 52 8B 45 C8 50 8D 4D C4 51 8D 55 D0 52 E8 ?? ?? ?? ?? 83 C4 10 33 C9 89 45 BC 89 4D C0 EB 1E 8D 55 CC 52 8B 45 C8 50 8D 4D C4 51 8D 55 D0 52 E8 ?? ?? ?? ?? 83 C4 10 89 45 BC 89 55 C0 8B 45 BC 89 45 A8 8B 4D C0 89 4D AC 8D 55 14 52 8D 45 0C 50 E8 ?? ?? ?? ?? 83 C4 08 0F B6 C8 85 C9 74 0D 8B 55 20 8B 02 83 C8 01 8B 4D 20 89 01 8D 55 D0 39 55 C4 74 06 83 7D CC 00 74 0F 8B 45 20 8B 08 83 C9 02 8B 55 20 89 0A EB 08 8B 45 A8 8B 4D 24 89 01 8B 55 08 8B 45 0C 89 02 8B 4D 10 89 4A 04 8B 45 08 8B 4D F4 64 89 0D 00 00 00 00 59 8B 4D F0 33 CD E8 ?? ?? ?? ?? 8B E5 5D C2 20 00 }
	condition:
		$1
}

rule file_29_1147_1 {
	meta:
		name = "?do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHAAPAX@Z"
		size = 331
		refs = "0006 __ehhandler$?do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHAAPAX@Z 0015 ___security_cookie 003a ?getloc@ios_base@std@@QBE?AVlocale@2@XZ 0068 ?_Getifld@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@1HABVlocale@2@@Z 007d ??1locale@std@@QAE@XZ 009b __Stoulx 00bd __Stoullx 00df ??$?8GU?$char_traits@G@std@@@std@@YA_NABV?$istreambuf_iterator@GU?$char_traits@G@std@@@0@0@Z 0141 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 54 A1 ?? ?? ?? ?? 33 C5 89 45 F0 50 8D 45 F4 64 A3 00 00 00 00 89 4D B0 C7 45 CC 00 00 00 00 8D 45 A0 50 8B 4D 1C E8 ?? ?? ?? ?? 89 45 B8 8B 4D B8 89 4D B4 C7 45 FC 00 00 00 00 8B 55 B4 52 68 00 08 00 00 8D 45 14 50 8D 4D 0C 51 8D 55 D0 52 8B 45 B0 50 E8 ?? ?? ?? ?? 83 C4 18 89 45 C8 C7 45 FC FF FF FF FF 8D 4D A0 E8 ?? ?? ?? ?? B9 01 00 00 00 85 C9 74 22 8D 55 CC 52 8B 45 C8 50 8D 4D C4 51 8D 55 D0 52 E8 ?? ?? ?? ?? 83 C4 10 33 C9 89 45 BC 89 4D C0 EB 1E 8D 55 CC 52 8B 45 C8 50 8D 4D C4 51 8D 55 D0 52 E8 ?? ?? ?? ?? 83 C4 10 89 45 BC 89 55 C0 8B 45 BC 89 45 A8 8B 4D C0 89 4D AC 8D 55 14 52 8D 45 0C 50 E8 ?? ?? ?? ?? 83 C4 08 0F B6 C8 85 C9 74 0D 8B 55 20 8B 02 83 C8 01 8B 4D 20 89 01 8D 55 D0 39 55 C4 74 06 83 7D CC 00 74 0F 8B 45 20 8B 08 83 C9 02 8B 55 20 89 0A EB 08 8B 45 A8 8B 4D 24 89 01 8B 55 08 8B 45 0C 89 02 8B 4D 10 89 4A 04 8B 45 08 8B 4D F4 64 89 0D 00 00 00 00 59 8B 4D F0 33 CD E8 ?? ?? ?? ?? 8B E5 5D C2 20 00 }
	condition:
		$1
}

rule file_29_1178_1 {
	meta:
		name = "?do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHAAPAX@Z"
		size = 331
		refs = "0006 __ehhandler$?do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHAAPAX@Z 0015 ___security_cookie 003a ?getloc@ios_base@std@@QBE?AVlocale@2@XZ 0068 ?_Getifld@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@1HABVlocale@2@@Z 007d ??1locale@std@@QAE@XZ 009b __Stoulx 00bd __Stoullx 00df ??$?8_WU?$char_traits@_W@std@@@std@@YA_NABV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@0@0@Z 0141 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 54 A1 ?? ?? ?? ?? 33 C5 89 45 F0 50 8D 45 F4 64 A3 00 00 00 00 89 4D B0 C7 45 CC 00 00 00 00 8D 45 A0 50 8B 4D 1C E8 ?? ?? ?? ?? 89 45 B8 8B 4D B8 89 4D B4 C7 45 FC 00 00 00 00 8B 55 B4 52 68 00 08 00 00 8D 45 14 50 8D 4D 0C 51 8D 55 D0 52 8B 45 B0 50 E8 ?? ?? ?? ?? 83 C4 18 89 45 C8 C7 45 FC FF FF FF FF 8D 4D A0 E8 ?? ?? ?? ?? B9 01 00 00 00 85 C9 74 22 8D 55 CC 52 8B 45 C8 50 8D 4D C4 51 8D 55 D0 52 E8 ?? ?? ?? ?? 83 C4 10 33 C9 89 45 BC 89 4D C0 EB 1E 8D 55 CC 52 8B 45 C8 50 8D 4D C4 51 8D 55 D0 52 E8 ?? ?? ?? ?? 83 C4 10 89 45 BC 89 55 C0 8B 45 BC 89 45 A8 8B 4D C0 89 4D AC 8D 55 14 52 8D 45 0C 50 E8 ?? ?? ?? ?? 83 C4 08 0F B6 C8 85 C9 74 0D 8B 55 20 8B 02 83 C8 01 8B 4D 20 89 01 8D 55 D0 39 55 C4 74 06 83 7D CC 00 74 0F 8B 45 20 8B 08 83 C9 02 8B 55 20 89 0A EB 08 8B 45 A8 8B 4D 24 89 01 8B 55 08 8B 45 0C 89 02 8B 4D 10 89 4A 04 8B 45 08 8B 4D F4 64 89 0D 00 00 00 00 59 8B 4D F0 33 CD E8 ?? ?? ?? ?? 8B E5 5D C2 20 00 }
	condition:
		$1
}

rule file_3_339_1 {
	meta:
		name = "?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHAA_J@Z"
		size = 280
		refs = "0006 __ehhandler$?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHAA_J@Z 0015 ___security_cookie 003e ?getloc@ios_base@std@@QBE?AVlocale@2@XZ 005a ?flags@ios_base@std@@QBEHXZ 0070 ?_Getifld@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@1HABVlocale@2@@Z 0081 __Stollx 0099 ??1locale@std@@QAE@XZ 00a6 ??$?8DU?$char_traits@D@std@@@std@@YA_NABV?$istreambuf_iterator@DU?$char_traits@D@std@@@0@0@Z 010e @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 48 A1 ?? ?? ?? ?? 33 C5 89 45 F0 50 8D 45 F4 64 A3 00 00 00 00 89 4D C0 C7 45 CC 00 00 00 00 8D 45 CC 50 8D 4D AC 51 8B 4D 1C E8 ?? ?? ?? ?? 89 45 C8 8B 55 C8 89 55 C4 C7 45 FC 00 00 00 00 8B 45 C4 50 8B 4D 1C E8 ?? ?? ?? ?? 50 8D 4D 14 51 8D 55 0C 52 8D 45 D0 50 8B 4D C0 51 E8 ?? ?? ?? ?? 83 C4 18 50 8D 55 BC 52 8D 45 D0 50 E8 ?? ?? ?? ?? 83 C4 10 89 45 B4 89 55 B8 C7 45 FC FF FF FF FF 8D 4D AC E8 ?? ?? ?? ?? 8D 4D 14 51 8D 55 0C 52 E8 ?? ?? ?? ?? 83 C4 08 0F B6 C0 85 C0 74 0D 8B 4D 20 8B 11 83 CA 01 8B 45 20 89 10 8D 4D D0 39 4D BC 74 06 83 7D CC 00 74 0F 8B 55 20 8B 02 83 C8 02 8B 4D 20 89 01 EB 0E 8B 55 24 8B 45 B4 89 02 8B 4D B8 89 4A 04 8B 55 08 8B 45 0C 89 02 8B 4D 10 89 4A 04 8B 45 08 8B 4D F4 64 89 0D 00 00 00 00 59 8B 4D F0 33 CD E8 ?? ?? ?? ?? 8B E5 5D C2 20 00 }
	condition:
		$1
}

rule file_3_342_1 {
	meta:
		name = "?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHAA_K@Z"
		size = 280
		refs = "0006 __ehhandler$?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHAA_K@Z 0015 ___security_cookie 003e ?getloc@ios_base@std@@QBE?AVlocale@2@XZ 005a ?flags@ios_base@std@@QBEHXZ 0070 ?_Getifld@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@1HABVlocale@2@@Z 0081 __Stoullx 0099 ??1locale@std@@QAE@XZ 00a6 ??$?8DU?$char_traits@D@std@@@std@@YA_NABV?$istreambuf_iterator@DU?$char_traits@D@std@@@0@0@Z 010e @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 48 A1 ?? ?? ?? ?? 33 C5 89 45 F0 50 8D 45 F4 64 A3 00 00 00 00 89 4D C0 C7 45 CC 00 00 00 00 8D 45 CC 50 8D 4D AC 51 8B 4D 1C E8 ?? ?? ?? ?? 89 45 C8 8B 55 C8 89 55 C4 C7 45 FC 00 00 00 00 8B 45 C4 50 8B 4D 1C E8 ?? ?? ?? ?? 50 8D 4D 14 51 8D 55 0C 52 8D 45 D0 50 8B 4D C0 51 E8 ?? ?? ?? ?? 83 C4 18 50 8D 55 BC 52 8D 45 D0 50 E8 ?? ?? ?? ?? 83 C4 10 89 45 B4 89 55 B8 C7 45 FC FF FF FF FF 8D 4D AC E8 ?? ?? ?? ?? 8D 4D 14 51 8D 55 0C 52 E8 ?? ?? ?? ?? 83 C4 08 0F B6 C0 85 C0 74 0D 8B 4D 20 8B 11 83 CA 01 8B 45 20 89 10 8D 4D D0 39 4D BC 74 06 83 7D CC 00 74 0F 8B 55 20 8B 02 83 C8 02 8B 4D 20 89 01 EB 0E 8B 55 24 8B 45 B4 89 02 8B 4D B8 89 4A 04 8B 55 08 8B 45 0C 89 02 8B 4D 10 89 4A 04 8B 45 08 8B 4D F4 64 89 0D 00 00 00 00 59 8B 4D F0 33 CD E8 ?? ?? ?? ?? 8B E5 5D C2 20 00 }
	condition:
		$1
}

rule file_29_1150_1 {
	meta:
		name = "?do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHAA_J@Z"
		size = 280
		refs = "0006 __ehhandler$?do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHAA_J@Z 0015 ___security_cookie 003e ?getloc@ios_base@std@@QBE?AVlocale@2@XZ 005a ?flags@ios_base@std@@QBEHXZ 0070 ?_Getifld@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABAHPADAAV?$istreambuf_itera