private rule architecture {
	meta:
		bits = 32
		endianness = "little"
		architecture = "x86"
	condition:
		true
}

rule file_0_0_0 {
	meta:
		name = "__fsetlocking"
		size = 55
	strings:
		$1 = { 53 8B 54 24 08 8B 4C 24 0C 8B 1A 89 D8 25 00 80 00 00 83 F8 01 19 C0 83 C0 02 85 C9 74 0A 80 E7 7F 83 F9 02 89 1A 74 08 5B C3 8D B6 00 00 00 00 80 CF 80 89 1A 5B C3 }
	condition:
		$1
}

rule file_1_0_0 {
	meta:
		name = "prefixcmp"
		size = 33
	strings:
		$1 = { 53 8B 54 24 0C B8 01 00 00 00 8B 4C 24 08 8B 5A 10 39 59 10 72 09 0F 94 C0 0F B6 C0 83 E8 01 5B C3 }
	condition:
		$1
}

rule file_1_1_0 {
	meta:
		name = "scopecmp"
		size = 48
	strings:
		$1 = { 83 EC 08 8B 54 24 10 8B 4C 24 0C 89 1C 24 31 DB 89 74 24 04 8B 74 24 04 8B 42 04 39 41 04 B8 FF FF FF FF 0F 95 C3 0F 46 C3 8B 1C 24 83 C4 08 C3 }
	condition:
		$1
}

rule file_1_2_0 {
	meta:
		name = "free_prefixlist"
		size = 31
		refs = "000f free"
	strings:
		$1 = { 85 C0 74 19 53 83 EC 18 8B 58 18 89 04 24 E8 ?? ?? ?? ?? 85 DB 89 D8 75 EF 83 C4 18 5B F3 C3 }
	condition:
		$1
}

rule file_1_3_0 {
	meta:
		name = "in6aicmp"
		size = 41
		refs = "0021 memcmp"
	strings:
		$1 = { 83 EC 1C 8B 44 24 24 C7 44 24 08 10 00 00 00 83 C0 08 89 44 24 04 8B 44 24 20 83 C0 08 89 04 24 E8 ?? ?? ?? ?? 83 C4 1C C3 }
	condition:
		$1
}

rule file_1_4_0 {
	meta:
		name = "match_prefix"
		size = 213
	strings:
		$1 = { 55 57 56 89 C6 53 89 C8 83 EC 24 0F B7 0E 66 83 F9 02 74 0E 66 83 F9 0A 74 52 83 C4 24 5B 5E 5F 5D C3 0F B7 46 02 C7 44 24 18 00 00 00 00 66 C7 44 24 08 0A 00 C7 44 24 0C 00 00 00 00 66 89 44 24 0A 8B 46 04 8D 74 24 08 C7 44 24 10 00 00 00 00 C7 44 24 14 00 00 00 00 66 C7 44 24 1A FF FF 89 44 24 1C C7 44 24 20 00 00 00 00 8D 46 08 89 D3 89 04 24 BF 00 FF 00 00 8D B4 26 00 00 00 00 8B 4B 10 89 DA 8B 2C 24 83 F9 07 76 21 0F B6 46 08 38 03 74 0B EB 2E 90 0F B6 45 00 38 02 75 25 83 E9 08 83 C2 01 83 C5 01 83 F9 07 77 EA 0F B6 02 89 FA 0F B6 6D 00 D3 FA 31 C5 81 E5 FF 00 00 00 85 D5 74 05 83 C3 18 EB B6 8B 43 14 83 C4 24 5B 5E 5F 5D C3 }
	condition:
		$1
}

rule file_1_6_0 {
	meta:
		name = "gaih_inet_serv.isra.1"
		size = 189
		refs = "0053 __getservbyname_r"
	strings:
		$1 = { 55 89 E5 57 89 C7 56 BE 00 04 00 00 53 89 F3 83 EC 5C 89 4D C0 8D 4A 0A 89 55 C4 89 CE B9 10 00 00 00 31 D2 8D 43 1E F7 F1 8D 55 D4 8D 4D D8 C1 E0 04 29 C4 8D 44 24 27 83 E0 F0 89 54 24 14 89 5C 24 10 89 44 24 0C 89 4C 24 08 89 74 24 04 89 3C 24 E8 ?? ?? ?? ?? 85 C0 75 3D 8B 45 D4 8B 5D C4 85 C0 74 43 8B 4D 08 8B 13 C7 01 00 00 00 00 89 51 04 F6 43 08 02 74 3F 8B 4D C0 8B 11 8B 4D 08 8B 40 08 89 51 08 89 41 0C 8D 65 F4 31 C0 5B 5E 5F 5D C3 8D 74 26 00 83 F8 22 75 0B 01 DB E9 79 FF FF FF 8D 74 26 00 8D 65 F4 B8 08 01 00 00 5B 5E 5F 5D C3 8D 76 00 8B 53 04 EB C1 }
	condition:
		$1
}

rule file_1_7_0 {
	meta:
		name = "gaih_inet"
		size = 8216
		refs = "01b5 __idna_to_ascii_lz 0210 __inet_aton 0291 free 02c0 strchr 02eb inet_pton 0350 strtoul 03a5 __nss_not_use_nscd_hosts 03c4 __nss_hosts_database 03d7 _res_hconf 03e5 __libc_resp 03f8 __res_maybe_init 0499 __nss_lookup_function 04b6 _dl_mcount_wrapper_check 0630 malloc 06e4 realloc 08cf in6addr_loopback 09a7 __idna_to_unicode_lzlz 0f0f __nss_database_custom 0f36 __nscd_getai 107a memcpy 12d7 __gethostbyname2_r 139c __strdup 143f strlen 150e if_nametoindex 1538 __libc_alloca_cutoff 1589 __libc_h_errno 1943 __gethostbyaddr_r 1af7 __nss_database_lookup 1cba __libc_errno 1d08 _res_hconf_init 1df9 mempcpy 1e32 __strndup 1ed2 __assert_fail"
	strings:
		$1 = { 55 89 E5 57 89 CF 56 53 89 D3 81 EC CC 00 00 00 89 45 94 8B 41 0C C7 45 BC ?? ?? ?? ?? 8B 49 08 C7 45 C0 00 00 00 00 85 C0 75 09 85 C9 BA ?? ?? ?? ?? 74 2C BA ?? ?? ?? ?? 8D B4 26 00 00 00 00 85 C9 74 3C 39 0A 74 38 83 C2 14 80 7A 0A 00 75 EF B8 07 01 00 00 66 90 8D 65 F4 5B 5E 5F 5D C3 85 DB 0F 84 7D 01 00 00 F6 42 08 01 74 3A B8 08 01 00 00 8D 65 F4 5B 5E 5F 5D C3 90 8D 74 26 00 85 C0 74 DC F6 42 08 02 75 D6 3B 42 04 74 D1 83 C2 14 80 7A 0A 00 75 A8 85 C9 B8 08 01 00 00 74 D2 B8 07 01 00 00 EB B0 8B 4B 04 85 C9 0F 88 D1 06 00 00 89 CB 66 C1 CB 08 0F B7 DB 8B 4F 08 85 C9 75 5D 85 C0 75 59 80 7A 1E 00 8D 42 14 0F 84 38 10 00 00 8D 75 BC C7 45 B4 00 00 00 00 EB 09 83 C0 14 80 78 0A 00 74 65 80 78 09 00 74 F1 89 E1 83 EC 20 8D 54 24 33 83 E2 F0 29 E1 01 4D B4 8B 08 C7 02 00 00 00 00 89 5A 0C 89 4A 04 8B 48 04 89 4A 08 89 16 89 D6 EB C6 8D B6 00 00 00 00 89 E6 83 EC 20 8D 4C 24 33 83 E1 F0 29 E6 89 75 B4 8B 32 F6 42 08 02 89 4D BC C7 01 00 00 00 00 89 71 04 75 03 8B 42 04 89 41 08 89 59 0C 8B 75 94 85 F6 0F 84 27 07 00 00 89 E3 83 EC 30 8D 44 24 33 83 E0 F0 29 E3 8B 17 89 45 C0 C7 40 08 00 00 00 00 C7 40 1C 00 00 00 00 F6 C2 40 C7 00 00 00 00 00 0F 84 E5 03 00 00 89 D0 C1 E8 08 83 E0 01 89 C1 83 C9 02 80 E6 02 0F 45 C1 89 44 24 08 8B 45 94 8D 75 D0 89 74 24 04 C7 45 D0 00 00 00 00 89 04 24 E8 ?? ?? ?? ?? 85 C0 89 C2 89 45 C4 74 2A 3D C9 00 00 00 0F 84 43 09 00 00 81 FA CA 00 00 00 B8 0B 00 00 00 BA 69 00 00 00 0F 45 C2 E9 8E FE FF FF 31 DB E9 D0 FE FF FF 8B 4D D0 39 4D 94 8B 45 C0 89 4D 9C 0F 95 45 86 8B 4D 9C 83 C0 0C 03 5D B4 89 44 24 04 89 0C 24 89 5D 98 E8 ?? ?? ?? ?? 85 C0 0F 84 84 00 00 00 8B 47 04 A9 FD FF FF FF 0F 84 8C 04 00 00 83 F8 0A 0F 84 78 0C 00 00 B8 09 00 00 00 C7 45 80 00 00 00 00 C6 45 A8 00 C7 85 7C FF FF FF 00 00 00 00 C6 45 87 00 C7 45 88 00 00 00 00 C6 45 8C 00 80 7D 86 00 0F 85 02 05 00 00 80 7D 8C 00 0F 85 DC 04 00 00 80 7D 87 00 0F 85 B3 04 00 00 80 7D A8 00 0F 84 EF FD FF FF 8B 7D 80 89 85 6C FF FF FF 89 3C 24 E8 ?? ?? ?? ?? 8B 85 6C FF FF FF E9 D3 FD FF FF 8B 55 C0 8B 5A 08 89 55 B0 85 DB 0F 85 CC 02 00 00 8B 4D 9C C7 44 24 04 25 00 00 00 89 0C 24 E8 ?? ?? ?? ?? 85 C0 89 C3 0F 95 45 B4 0F 85 8F 1A 00 00 8B 75 9C 8B 45 B0 89 74 24 04 C7 04 24 0A 00 00 00 83 C0 0C 89 44 24 08 E8 ?? ?? ?? ?? 85 C0 0F 8E EB 0B 00 00 8B 47 04 83 F8 0A 74 08 85 C0 0F 85 B1 08 00 00 8B 75 C0 89 75 B0 C7 46 08 0A 00 00 00 80 7D B4 00 74 52 8B 4D B0 8B 41 0C 25 FF C0 00 00 3D FE 80 00 00 0F 84 D1 11 00 00 80 79 0C FF 8D 53 01 0F 84 B5 11 00 00 8D 75 D0 89 14 24 C7 44 24 08 0A 00 00 00 89 74 24 04 E8 ?? ?? ?? ?? 8B 55 B0 89 42 1C 8B 45 D0 80 38 00 0F 85 E7 05 00 00 8B 55 C0 89 55 B0 F6 07 02 0F 85 F3 0E 00 00 8B 4D B0 C7 45 90 00 00 00 00 8B 41 08 85 C0 0F 85 FA 01 00 00 F6 07 04 0F 85 BA 05 00 00 83 7F 04 02 C7 45 C8 00 00 00 00 0F 84 D5 0E 00 00 A1 ?? ?? ?? ?? 83 F8 00 0F 8E 7E 0E 00 00 83 C0 01 83 F8 64 0F 8F 45 0B 00 00 A3 ?? ?? ?? ?? A1 ?? ?? ?? ?? 85 C0 0F 84 08 17 00 00 89 45 C8 31 F6 8B 1D ?? ?? ?? ?? 85 DB 0F 84 24 19 00 00 8B 0D ?? ?? ?? ?? C7 44 24 04 00 00 00 00 65 8B 01 89 04 24 E8 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 65 8B 19 83 F8 FF B8 01 00 00 00 0F 44 F0 8B 45 98 8B 4B 08 05 00 04 00 00 89 4D 88 80 E5 DF 3D 00 10 00 00 89 4B 08 0F 87 49 1B 00 00 89 E0 81 EC 10 04 00 00 8D 54 24 33 83 E2 F0 29 E0 01 45 98 89 55 80 C6 45 A8 00 85 F6 0F 85 FF 1A 00 00 BE FF FF FF FF 8B 45 C8 BB 00 04 00 00 89 7D AC 89 F7 8B 75 80 8D 4D C0 C7 45 A0 FF FF FF FF C7 45 8C 00 00 00 00 89 4D B0 C7 85 7C FF FF FF 00 00 00 00 C6 45 87 00 C6 45 85 00 C7 44 24 04 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 85 C0 89 45 B4 0F 84 A3 06 00 00 8B 45 B4 C7 45 C4 00 00 00 00 89 04 24 E8 ?? ?? ?? ?? 8B 7D B0 8D 4D C4 89 4C 24 10 8B 4D 9C 8D 55 CC C7 44 24 18 00 00 00 00 89 54 24 14 89 7C 24 04 8B 7D B4 89 5C 24 0C 89 74 24 08 89 0C 24 FF D7 83 F8 01 0F 84 5B 05 00 00 83 F8 FE 0F 85 48 05 00 00 83 7D C4 22 0F 85 37 05 00 00 8B 55 CC 83 FA FF 0F 85 D6 04 00 00 80 7D A8 00 0F 85 BC 01 00 00 8B 45 98 8D 0C 1B 01 C8 3D 00 10 00 00 0F 87 C4 16 00 00 89 E7 83 C1 0F 31 D2 83 E1 F0 89 7D 80 8D 41 1E BF 10 00 00 00 89 45 A4 01 CB F7 F7 C1 E0 04 29 C4 8D 44 24 33 83 E0 F0 8D 14 08 39 D6 0F 45 D9 8B 4D 80 29 E1 01 4D 98 89 C6 E9 3A FF FF FF 8B 75 94 C6 45 86 00 89 75 9C E9 7F FC FF FF C7 45 90 00 00 00 00 C7 45 80 00 00 00 00 C6 45 A8 00 C7 85 7C FF FF FF 00 00 00 00 C6 45 87 00 C7 45 88 00 00 00 00 C6 45 8C 00 C6 45 85 00 8B 75 B0 89 7D A4 89 F7 39 F7 0F 84 9B 03 00 00 8B 46 08 C7 45 B0 10 00 00 00 66 83 F8 0A 66 89 45 B4 0F 84 5C 02 00 00 8B 7D BC 85 FF 0F 84 24 01 00 00 8B 5D B0 25 FF FF 00 00 89 F2 89 45 A0 8B 75 90 83 C3 20 89 5D AC 8B 5D 08 EB 29 8D B6 00 00 00 00 8B 5A 0C C7 40 28 00 00 00 00 C7 40 2C 00 00 00 00 89 58 24 8B 3F 31 F6 8D 58 1C 85 FF 0F 84 D8 00 00 00 8B 4D AC 89 95 68 FF FF FF 89 0C 24 E8 ?? ?? ?? ?? 8B 95 68 FF FF FF 85 C0 89 03 0F 84 D7 00 00 00 8B 4D A4 8B 19 8B 4D B0 89 18 8B 5D A0 89 58 04 8B 5F 04 89 58 08 8B 5F 08 89 48 10 89 70 18 C7 40 1C 00 00 00 00 89 58 0C 8D 58 20 89 58 14 0F B7 5D B4 66 89 58 20 66 83 FB 0A 8B 5F 0C 66 89 58 22 0F 85 74 FF FF FF C7 40 24 00 00 00 00 8B 4A 0C 89 48 28 8B 4A 10 89 48 2C 8B 4A 14 89 48 30 8B 72 18 89 70 34 8B 5A 1C 89 58 38 E9 5E FF FF FF 8B 5D C0 8B 07 89 5D B0 C7 43 08 02 00 00 00 A8 02 B8 00 00 00 00 0F 45 45 9C 89 45 90 E9 AC FE FF FF 01 DB 89 F0 89 5C 24 04 89 04 24 E8 ?? ?? ?? ?? 85 C0 0F 84 9B 04 00 00 89 C6 C6 45 A8 01 E9 AD FD FF FF 89 75 90 89 D6 89 5D 08 8B 7D 0C 83 07 01 8B 36 85 F6 0F 84 67 12 00 00 8B 7D C0 E9 99 FE FF FF 89 34 24 E8 ?? ?? ?? ?? B8 0A 00 00 00 E9 2F FB FF FF 8B B5 7C FF FF FF 89 85 6C FF FF FF 89 34 24 E8 ?? ?? ?? ?? 8B 85 6C FF FF FF E9 2E FB FF FF 8B 5D 88 89 85 6C FF FF FF 89 1C 24 E8 ?? ?? ?? ?? 8B 85 6C FF FF FF E9 08 FB FF FF 8B 4D 9C 89 85 6C FF FF FF 89 0C 24 E8 ?? ?? ?? ?? 8B 85 6C FF FF FF E9 E2 FA FF FF 80 7A 0A 00 0F 85 8C 03 00 00 80 7A 1E 00 8D 72 14 0F 84 D3 F8 FF FF 8D 45 BC 8D 57 0C 89 45 AC C7 45 B4 00 00 00 00 89 55 A8 89 5D B0 89 7D A4 EB 17 3B 16 74 25 8D B6 00 00 00 00 83 C6 14 80 7E 0A 00 0F 84 5B 02 00 00 0F B6 46 08 A8 01 75 EB 8B 4D A4 8B 51 08 85 D2 75 D7 8B 4D A4 8B 51 0C 85 D2 74 09 A8 02 75 05 3B 56 04 75 CE 89 E0 83 EC 20 8D 5C 24 33 83 E3 F0 29 E0 8B 7D B0 89 F2 01 45 B4 8B 4D A8 89 1C 24 8B 07 E8 2B F7 FF FF 85 C0 89 45 C4 74 0A F6 C4 01 75 9F E9 4D F8 FF FF 8B 7D AC 89 5D AC 89 1F EB 90 80 7D 85 00 0F 84 A2 01 00 00 8B 4D A4 C7 45 B0 1C 00 00 00 8B 11 83 E2 18 83 FA 08 0F 85 82 FD FF FF 8B 5E 0C 85 DB 0F 85 77 FD FF FF 8B 4E 10 85 C9 0F 85 6C FD FF FF 81 7E 14 00 00 FF FF 0F 85 5F FD FF FF E9 8F FE FF FF 8D B6 00 00 00 00 89 E2 83 EC 30 8D 44 24 33 83 E0 F0 89 45 B0 29 E2 03 55 B4 89 45 C0 89 55 98 31 D2 C7 04 10 00 00 00 00 83 C2 04 83 FA 20 72 F1 8B 57 04 85 D2 0F 84 D2 05 00 00 83 FA 0A 74 06 85 D2 89 C1 75 35 F6 07 01 C7 40 08 0A 00 00 00 75 27 8B 15 ?? ?? ?? ?? 89 50 0C 8B 15 ?? ?? ?? ?? 89 50 10 8B 15 ?? ?? ?? ?? 89 50 14 8B 15 ?? ?? ?? ?? 89 50 18 8B 57 04 8B 08 83 E2 FD 75 13 F6 07 01 C7 41 08 02 00 00 00 75 07 C7 41 0C 7F 00 00 01 C7 45 9C 00 00 00 00 C7 45 80 00 00 00 00 C6 45 A8 00 C7 85 7C FF FF FF 00 00 00 00 C6 45 87 00 C7 45 88 00 00 00 00 C6 45 8C 00 C6 45 86 00 C7 45 90 00 00 00 00 C6 45 85 00 E9 5F FC FF FF B8 02 01 00 00 E9 E1 F8 FF FF 8B 4D A4 8B 01 A8 02 0F 84 58 FC FF FF 8B 55 90 C6 45 B0 00 C7 45 B4 00 00 00 00 85 D2 0F 84 3E 0F 00 00 A8 80 0F 84 96 07 00 00 89 C2 C1 EA 08 83 E2 01 89 D1 83 C9 02 F6 C4 02 8B 45 90 0F 45 D1 8D 5D D0 89 54 24 08 89 5C 24 04 89 04 24 E8 ?? ?? ?? ?? 85 C0 0F 85 5E 13 00 00 8B 45 D0 3B 45 90 0F 84 59 07 00 00 89 45 90 80 7D B0 00 0F 84 F0 FB FF FF 8B 4D B4 89 0C 24 E8 ?? ?? ?? ?? E9 E0 FB FF FF C7 45 B0 1C 00 00 00 E9 EC FB FF FF 89 C7 89 D0 31 D2 83 F8 02 0F 84 00 05 00 00 31 C9 83 F8 04 0F 94 C1 89 4D B4 8B 4D B4 89 4D 8C 8B 45 C8 83 7C 90 04 01 0F 84 17 11 00 00 8B 00 85 C0 0F 84 E8 01 00 00 89 45 C8 E9 65 FA FF FF 81 7D BC ?? ?? ?? ?? 8B 7D A4 0F 85 16 F7 FF FF E9 31 F6 FF FF 89 C7 8B 45 CC EB A8 89 C7 8B 45 CC 8D 57 02 EB A9 8B 4D AC 89 C7 F6 01 02 8B 4D B0 8B 01 74 0B 8B 4D 90 85 C9 0F 84 BA 10 00 00 C7 45 B4 01 00 00 00 89 5D A4 8D B6 00 00 00 00 85 C0 74 21 8B 48 08 8B 5D AC 83 F9 02 8B 53 04 74 2E 85 D2 74 1C 39 D1 74 60 8B 00 8B 4D B0 85 C0 89 01 75 DF 8B 5D A4 BA 03 00 00 00 E9 58 FF FF FF 89 45 B0 8B 00 C7 45 B4 00 00 00 00 EB C0 83 FA 0A 75 CD F6 03 08 74 D0 8B 50 0C C7 40 08 0A 00 00 00 C7 40 14 00 00 FF FF C7 40 10 00 00 00 00 89 50 18 C7 40 0C 00 00 00 00 89 45 B0 8B 00 C7 45 B4 00 00 00 00 EB 86 83 F9 0A 89 45 B0 8B 00 C7 45 B4 00 00 00 00 0F 85 71 FF FF FF C6 45 85 01 E9 68 FF FF FF B8 0A 00 00 00 E9 59 F5 FF FF 89 E6 83 EC 20 8D 44 24 33 83 E0 F0 29 E6 89 45 BC 8D 4F 0C 89 04 24 8B 03 E8 08 F4 FF FF 85 C0 89 45 C4 0F 85 30 F5 FF FF 89 75 B4 E9 03 F6 FF FF 8B 4D AC F6 01 02 0F 85 0F 01 00 00 8B 45 C8 C7 44 24 04 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 85 C0 89 45 80 0F 85 0F 01 00 00 BA 01 00 00 00 BF FF FF FF FF C7 45 B4 00 00 00 00 E9 7D FE FF FF 8B 0D ?? ?? ?? ?? 89 75 80 65 8B 01 8B 55 88 81 E2 00 20 00 00 09 50 08 B8 0A 00 00 00 C7 45 88 00 00 00 00 C6 45 8C 00 E9 A4 F6 FF FF 83 F8 02 0F 85 72 F6 FF FF 8B 55 C0 8B 4A 0C 89 55 B0 85 C9 0F 85 61 F6 FF FF 8B 72 10 85 F6 0F 85 56 F6 FF FF 81 7A 14 00 00 FF FF B0 09 0F 85 4C F6 FF FF 8B 75 B0 8B 46 18 C7 46 08 02 00 00 00 89 46 0C E9 13 F7 FF FF 8D B4 26 00 00 00 00 8B 0D ?? ?? ?? ?? 8B 7D AC 89 75 80 65 8B 19 8B 75 8C 8B 45 B4 8B 4B 08 85 F6 0F 95 C2 85 C0 0F 95 C0 21 C2 8B 45 88 25 00 20 00 00 09 C8 84 D2 89 43 08 0F 84 C1 0E 00 00 83 7D 8C FD 75 0A 83 7D B4 FD 0F 84 72 0E 00 00 B8 05 01 00 00 C7 45 88 00 00 00 00 C6 45 8C 00 E9 F6 F5 FF FF 8B 45 C8 C7 44 24 04 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 85 C0 89 45 80 0F 84 D3 FE FF FF 8B 4D AC 8B 41 04 85 C0 74 09 83 F8 0A 0F 85 A4 05 00 00 8D 7D D0 89 7D A4 8D 7D D4 C7 45 D0 00 00 00 00 89 7D B4 EB 39 8D 74 26 00 83 7D CC FF 0F 85 1E 07 00 00 8D 4C 1B 0F 31 D2 83 E1 F0 BF 10 00 00 00 8D 41 1E 01 CB F7 F7 C1 E0 04 29 C4 8D 44 24 33 83 E0 F0 8D 14 08 39 D6 89 C6 0F 45 D9 8B 45 80 8D 7D CC C7 45 C4 00 00 00 00 89 04 24 E8 ?? ?? ?? ?? 8B 4D A4 8D 45 C4 89 7C 24 18 8B 7D 9C 8B 55 80 C7 44 24 1C 00 00 00 00 89 4C 24 20 8B 4D B4 89 44 24 14 89 5C 24 10 89 74 24 0C 89 4C 24 08 C7 44 24 04 0A 00 00 00 89 3C 24 FF D2 8B 55 C4 83 FA 22 0F 84 6E FF FF FF 89 45 A0 8B 7D A0 83 FF 01 0F 84 27 08 00 00 85 D2 0F 85 23 08 00 00 C7 45 B4 00 00 00 00 8B 4D AC 8B 55 B4 8B 41 04 89 55 8C A9 FD FF FF FF 0F 84 CF 03 00 00 83 F8 0A 0F 84 AB 03 00 00 83 FF 01 74 0A 83 7D A0 01 0F 85 B8 04 00 00 8B 4D AC BA 03 00 00 00 BF 01 00 00 00 F6 01 02 0F 84 63 FC FF FF 8B 45 90 85 C0 0F 85 58 FC FF FF 8B 45 C8 C7 44 24 04 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 85 C0 89 C7 0F 84 A6 00 00 00 8B 4D AC F6 01 80 0F 84 C6 0F 00 00 8B 45 98 05 00 01 00 00 3D 00 10 00 00 0F 87 A3 0F 00 00 89 E2 81 EC 10 01 00 00 8D 44 24 33 83 E0 F0 29 E2 01 55 98 89 85 7C FF FF FF 89 3C 24 E8 ?? ?? ?? ?? 8B 45 C0 8D 55 CC 8D 4D C4 8B 40 04 89 54 24 14 8B 95 7C FF FF FF 89 4C 24 10 8D 4D D0 89 4C 24 0C 85 C0 0F 44 45 9C C7 44 24 08 00 01 00 00 89 54 24 04 89 04 24 FF D7 83 F8 01 0F 84 99 0D 00 00 8B 4D 9C 80 7D 87 00 89 4D 90 74 18 8B 85 7C FF FF FF 89 04 24 E8 ?? ?? ?? ?? 8B 4D 9C C6 45 87 00 89 4D 90 BA 03 00 00 00 BF 01 00 00 00 E9 86 FB FF FF 8D B6 00 00 00 00 83 EC 30 8D 4C 24 33 83 E1 F0 89 08 C7 04 11 00 00 00 00 83 C2 04 83 FA 20 72 F1 8B 57 04 E9 0B FA FF FF 8B 07 A8 08 0F 84 7E F3 FF FF 8B 75 C0 8B 56 0C 89 75 B0 C7 46 14 00 00 FF FF C7 46 10 00 00 00 00 89 56 18 C7 46 0C 00 00 00 00 C7 46 08 0A 00 00 00 E9 E3 F7 FF FF 8B 5D C0 C7 45 90 00 00 00 00 89 5D B0 8B 43 08 E9 8B F4 FF FF C7 45 B4 FD FF FF FF E9 FF FA FF FF C7 05 ?? ?? ?? ?? 00 00 00 00 80 3D ?? ?? ?? ?? 00 0F 85 A9 F4 FF FF 8B 5D 9C 8D 4D CC 8D 75 D0 89 74 24 04 89 4C 24 08 89 1C 24 C7 45 D0 00 00 00 00 E8 ?? ?? ?? ?? 8B 75 D0 85 F6 0F 84 05 0D 00 00 8B 07 8B 1E 8B 4E 0C D1 E8 83 F0 01 89 DA 83 E0 01 88 45 A8 8B 45 98 C1 E2 05 89 4D B4 01 D0 3D 00 10 00 00 0F 87 A7 0C 00 00 89 E0 83 C2 10 29 D4 8D 54 24 33 83 E2 F0 29 E0 01 45 98 89 55 88 C6 45 8C 00 85 DB 0F 8E B9 0D 00 00 8B 45 88 31 DB 8D 4D C0 C7 85 7C FF FF FF 00 00 00 00 C6 45 87 00 89 45 A0 C6 45 85 00 89 7D AC EB 53 8B 7E 04 85 FF 89 7D A4 0F 84 85 00 00 00 8B BD 7C FF FF FF 85 FF 0F 84 63 04 00 00 8B 46 08 0F B6 3C 18 89 FA 80 FA 02 8B 55 AC 8B 42 04 0F 84 C1 00 00 00 81 E7 FF 00 00 00 85 C0 74 63 39 C7 74 5F 8B 7D B0 83 C3 01 01 7D B4 39 1E }
	condition:
		$1
}

rule file_1_8_0 {
	meta:
		name = "get_scope"
		size = 177
	strings:
		$1 = { 53 0F B7 08 89 C2 66 83 F9 0A 74 44 66 83 F9 02 B8 0F 00 00 00 74 09 5B C3 8D B4 26 00 00 00 00 8B 5A 04 8B 15 ?? ?? ?? ?? 8B 4A 04 8D 42 0C 21 D9 3B 0A 74 12 8D 76 00 89 C2 83 C0 0C 8B 4A 04 21 D9 3B 48 F4 75 F1 8B 42 08 5B C3 8D 74 26 00 80 78 08 FF 74 52 8B 48 08 B8 02 00 00 00 89 CB 81 E3 FF C0 00 00 81 FB FE 80 00 00 74 A9 85 C9 75 1E 8B 4A 0C 85 C9 75 17 8B 4A 10 85 C9 75 10 81 7A 14 00 00 00 01 74 8E 8D B4 26 00 00 00 00 31 C0 81 FB FE C0 00 00 0F 95 C0 8D 44 C0 05 5B C3 8D B4 26 00 00 00 00 0F B6 40 09 5B 83 E0 0F C3 }
	condition:
		$1
}

rule file_1_9_0 {
	meta:
		name = "rfc3484_sort"
		size = 1479
		refs = "01d4 __check_native 050f __assert_fail"
	strings:
		$1 = { 55 57 56 53 83 EC 5C 8B 44 24 70 8B 54 24 78 8B 00 89 44 24 20 8B 44 24 74 6B 74 24 20 2C 8B 00 89 44 24 24 8B 02 6B 5C 24 24 2C 01 C6 01 C3 80 7E 21 00 0F 84 C7 00 00 00 80 7B 21 00 0F 84 35 03 00 00 8B 06 8D 7E 04 8D 6B 04 8B 48 14 89 C8 89 4C 24 18 E8 E7 FE FF FF 89 44 24 30 8B 03 8B 40 14 E8 D9 FE FF FF 89 44 24 28 89 F8 E8 CE FE FF FF 89 44 24 2C 89 E8 E8 C3 FE FF FF 8B 4C 24 18 39 44 24 28 0F 85 90 03 00 00 39 44 24 28 0F 84 33 02 00 00 0F B6 56 22 0F B6 43 22 F6 C2 01 0F 85 12 02 00 00 A8 01 0F 85 CA 02 00 00 83 E2 02 0F 84 D1 02 00 00 A8 02 0F 84 B9 02 00 00 89 C8 E8 8A DD FF FF 89 44 24 2C 89 F8 E8 7F DD FF FF 89 44 24 34 8B 03 8B 40 14 E8 71 DD FF FF 89 C7 89 E8 E8 68 DD FF FF 39 C7 0F 85 40 03 00 00 39 C7 0F 84 A0 02 00 00 8B 06 8B 78 14 EB 29 90 80 7B 21 00 0F 85 56 01 00 00 8B 06 8B 78 14 89 F8 E8 2A FE FF FF 89 44 24 30 8B 03 8B 40 14 E8 1C FE FF FF 89 44 24 28 8B 2D ?? ?? ?? ?? 31 C9 89 F8 89 EA E8 37 DC FF FF 31 C9 89 EA 89 C7 8B 03 8B 40 14 E8 27 DC FF FF 39 C7 0F 8F 27 02 00 00 0F 8C 09 01 00 00 80 7E 21 00 90 8D 74 26 00 0F 84 12 01 00 00 8B 53 24 8B 6E 24 89 54 24 34 39 D5 0F 84 00 01 00 00 8B 7E 28 8B 43 28 83 FF FF 0F 94 C2 83 F8 FF 89 7C 24 48 0F 94 C1 89 44 24 4C 0F 84 18 02 00 00 84 D2 0F 84 B8 00 00 00 C7 44 24 48 00 00 00 00 84 C9 0F 85 5E 02 00 00 C7 44 24 34 FF FF FF FF 8B 4C 24 34 8D 44 24 4C 89 44 24 0C 8D 44 24 48 89 44 24 04 89 2C 24 89 4C 24 08 E8 ?? ?? ?? ?? 8B 44 24 78 8B 78 04 85 FF 0F 8E A8 02 00 00 8B 54 24 48 8B 4C 24 4C 89 74 24 1C 89 5C 24 3C 8B 5C 24 34 89 54 24 38 8B 54 24 78 89 4C 24 2C 8B 74 24 38 8B 02 31 D2 EB 19 8D B4 26 00 00 00 00 39 CB 0F 84 D0 01 00 00 83 C2 01 83 C0 2C 39 FA 74 1E 8B 48 24 39 E9 75 E7 8B 48 28 83 F9 FF 74 08 39 F1 0F 85 D2 02 00 00 89 70 28 EB DA 66 90 8B 74 24 1C 8B 5C 24 3C 8B 7C 24 38 8B 44 24 2C 85 FF 75 14 85 C0 74 18 B8 01 00 00 00 83 C4 5C 5B 5E 5F 5D C3 8D 76 00 85 C0 0F 84 00 01 00 00 8B 44 24 30 39 44 24 28 0F 8F F2 00 00 00 7C D8 80 7E 21 00 74 10 8B 2E 8B 3B 8B 45 04 3B 47 04 0F 84 27 01 00 00 8B 4C 24 24 39 4C 24 20 19 C0 83 C4 5C 5B 83 C8 01 5E 5F 5D C3 90 8D 74 26 00 A8 01 0F 85 EE FD FF FF EB 9E 8D B6 00 00 00 00 8B 44 24 2C 39 44 24 30 0F 84 BF FD FF FF EB 88 66 83 7E 04 02 0F 85 C0 02 00 00 66 83 7B 04 02 0F 85 91 02 00 00 8B 45 14 B9 20 00 00 00 8B 50 04 8B 46 08 0F CA 0F C8 31 D0 0F B6 56 23 BE FF FF FF FF 29 D1 31 D2 D3 E6 85 F0 75 19 B9 00 00 00 80 EB 0E 8D 74 26 00 83 C2 01 D1 E9 83 FA 20 74 04 85 C1 74 F2 8B 47 14 8B 48 04 8B 43 08 0F B6 5B 23 0F C9 0F C8 31 C8 B9 20 00 00 00 29 D9 BB FF FF FF FF D3 E3 31 C9 85 D8 75 19 BB 00 00 00 80 EB 0E 8D 74 26 00 83 C1 01 D1 EB 83 F9 20 74 6D 85 C3 74 F2 39 CA 7E 65 8D B6 00 00 00 00 B8 FF FF FF FF E9 E3 FE FF FF 8D B6 00 00 00 00 A8 02 0F 84 2F FD FF FF E9 CB FE FF FF 8D 76 00 8B 44 24 34 39 44 24 2C 0F 84 52 FD FF FF E9 B5 FE FF FF 90 8D 74 26 00 84 D2 0F 85 E8 FD FF FF BD FF FF FF FF 8D 76 00 E9 E3 FD FF FF 83 F8 02 0F 84 0A FF FF FF 31 C9 31 D2 83 F8 0A 74 6E 39 D1 B8 01 00 00 00 0F 8E BA FE FF FF E9 7C FE FF FF 8D B4 26 00 00 00 00 8B 48 28 83 F9 FF 74 0A 3B 4C 24 2C 0F 85 ED 00 00 00 8B 4C 24 2C 89 48 28 E9 12 FE FF FF C7 44 24 4C 00 00 00 00 E9 9D FD FF FF 8B 54 24 2C 39 54 24 30 0F 85 62 FC FF FF E9 4A FF FF FF 66 90 8B 54 24 34 39 54 24 2C 0F 85 B2 FC FF FF 66 90 E9 33 FF FF FF 66 83 7E 04 0A 0F 85 E7 00 00 00 66 83 7B 04 0A 0F 85 00 01 00 00 8B 55 14 31 C0 8B 6F 14 8D 7E 04 89 D6 8B 4C 86 08 8B 54 87 08 39 D1 75 2A 8B 54 83 0C 39 54 85 08 75 1E 83 C0 01 83 F8 04 75 E2 31 C9 31 D2 E9 48 FF FF FF 8B 7C 24 48 8B 44 24 4C E9 BC FD FF FF 89 CA 31 D1 BE 00 00 00 80 0F C9 31 D2 EB 0F 90 8D 74 26 00 83 C2 01 D1 EE 83 FA 20 74 04 85 CE 74 F2 8B 5C 83 0C 31 C9 33 5C 85 08 B8 00 00 00 80 0F CB EB 15 8D B4 26 00 00 00 00 83 C1 01 D1 E8 83 F9 20 0F 84 F1 FE FF FF 85 D8 74 EE E9 7F FE FF FF C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 BF 06 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 B9 06 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 FB 06 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 FC 06 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 DD 06 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 DC 06 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1_10_0 {
	meta:
		name = "gaiconf_init"
		size = 2909
		refs = "0044 _IO_new_fopen 0058 fileno 0070 __fxstat64 00d0 __getline 00ec strchr 00fd __libc_tsd_CTYPE_B 022b free 0237 _IO_new_fclose 027c malloc 030d qsort 03ee __libc_errno 042a inet_pton 0455 strtoul"
	strings:
		$1 = { 55 57 56 53 81 EC DC 00 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? C7 44 24 34 00 00 00 00 C7 44 24 38 00 00 00 00 C6 44 24 32 00 C7 44 24 3C 00 00 00 00 C7 44 24 40 00 00 00 00 C6 44 24 33 00 E8 ?? ?? ?? ?? 85 C0 89 44 24 14 0F 84 C3 09 00 00 89 04 24 E8 ?? ?? ?? ?? 8D 54 24 70 89 54 24 08 C7 04 24 03 00 00 00 89 44 24 04 E8 ?? ?? ?? ?? 85 C0 0F 85 C4 08 00 00 8B 54 24 14 C7 44 24 44 00 00 00 00 C7 44 24 48 00 00 00 00 C6 44 24 2F 00 8B 02 C7 44 24 24 00 00 00 00 C7 44 24 28 00 00 00 00 80 CC 80 89 02 A8 10 0F 85 6A 01 00 00 8D 74 26 00 8B 44 24 14 8D 54 24 48 8D 4C 24 44 89 54 24 04 89 0C 24 89 44 24 08 E8 ?? ?? ?? ?? 85 C0 0F 8E 42 01 00 00 8B 74 24 44 C7 44 24 04 23 00 00 00 89 34 24 E8 ?? ?? ?? ?? 85 C0 74 07 C6 00 00 8B 74 24 44 8B 15 ?? ?? ?? ?? 65 8B 02 0F B6 16 0F BE CA F6 44 48 01 20 74 17 8D B4 26 00 00 00 00 83 C6 01 0F B6 16 0F BE CA F6 44 48 01 20 75 F0 84 D2 89 F3 75 15 E9 E7 05 00 00 90 8D 74 26 00 F6 44 50 01 20 0F 85 45 02 00 00 83 C3 01 0F BE 13 84 D2 75 EB 0F B7 08 89 DF 29 F7 66 81 E1 00 20 31 D2 66 85 C9 74 10 83 C3 01 0F B6 13 0F BE CA F6 44 48 01 20 75 F0 84 D2 0F 84 9B 05 00 00 0F BE CA 89 DD F6 44 48 01 20 74 0E EB 17 66 90 0F BE CA F6 44 48 01 20 75 0B 83 C5 01 0F B6 55 00 84 D2 75 EB 39 EE 0F 84 63 05 00 00 84 D2 74 1A 8B 15 ?? ?? ?? ?? 83 C5 01 C6 45 FF 00 65 8B 02 EB 08 90 8D 74 26 00 83 C5 01 0F B6 55 00 0F BE CA F6 44 48 01 20 75 EF 84 D2 89 EA 75 13 EB 18 8D B4 26 00 00 00 00 83 C2 01 0F BE 0A 84 C9 74 07 F6 44 48 01 20 74 EF 83 FF 06 C6 02 00 0F 84 73 04 00 00 0F 87 AD 01 00 00 83 FF 05 0F 84 C7 04 00 00 8D 74 26 00 8B 4C 24 14 8B 01 A8 10 0F 84 9A FE FF FF 8B 44 24 44 BB ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 8B 44 24 14 89 04 24 E8 ?? ?? ?? ?? 8B 74 24 38 85 F6 0F 85 DC 04 00 00 8B 7C 24 40 85 FF 0F 85 83 05 00 00 8B 44 24 24 BD ?? ?? ?? ?? 85 C0 0F 84 2E 06 00 00 80 7C 24 2F 01 83 54 24 24 00 8B 54 24 24 8D 04 52 C1 E0 02 89 04 24 E8 ?? ?? ?? ?? 85 C0 89 C6 0F 84 A4 07 00 00 80 7C 24 2F 00 8B 44 24 24 0F 84 ED 06 00 00 85 C0 7E 35 6B F8 F4 31 D2 8D 04 40 8D 0C 86 8B 44 24 28 89 5C 24 14 8B 18 89 5C 11 F4 8B 58 04 89 5C 11 F8 8B 58 08 89 5C 11 FC 83 EA 0C 8B 40 0C 39 FA 75 E2 8B 5C 24 14 8B 7C 24 28 8B 44 24 28 85 FF 74 13 66 90 8B 78 0C 89 04 24 E8 ?? ?? ?? ?? 85 FF 89 F8 75 EF 8B 54 24 24 C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 0C 00 00 00 89 34 24 89 54 24 04 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 89 1D ?? ?? ?? ?? 3D ?? ?? ?? ?? 74 08 89 04 24 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 89 2D ?? ?? ?? ?? 3D ?? ?? ?? ?? 74 08 89 04 24 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 89 35 ?? ?? ?? ?? 3D ?? ?? ?? ?? 74 08 89 04 24 E8 ?? ?? ?? ?? 8B 84 24 B8 00 00 00 8B 94 24 BC 00 00 00 A3 ?? ?? ?? ?? 89 15 ?? ?? ?? ?? 81 C4 DC 00 00 00 5B 5E 5F 5D C3 90 8D 74 26 00 8B 0D ?? ?? ?? ?? 89 DF 83 C3 01 0F B6 13 29 F7 C6 43 FF 00 65 8B 01 0F BE CA 0F B7 0C 48 66 81 E1 00 20 E9 AB FD FF FF 83 FF 07 0F 84 5F 01 00 00 83 FF 0A 0F 85 4E FE FF FF BF ?? ?? ?? ?? B9 0B 00 00 00 F3 A6 0F 85 3C FE FF FF 8D 54 24 33 89 54 24 20 8D 4C 24 40 8D 54 24 3C 89 4C 24 1C 89 54 24 18 8B 35 ?? ?? ?? ?? 65 C7 06 00 00 00 00 C7 44 24 04 2F 00 00 00 89 1C 24 E8 ?? ?? ?? ?? 85 C0 89 C7 0F 84 F2 06 00 00 C6 00 00 8D 44 24 50 89 44 24 08 89 5C 24 04 C7 04 24 0A 00 00 00 E8 ?? ?? ?? ?? 85 C0 0F 84 DA FD FF FF 89 FA 83 C2 01 0F 84 E4 06 00 00 8D 5C 24 4C 89 14 24 C7 44 24 08 0A 00 00 00 89 5C 24 04 E8 ?? ?? ?? ?? 83 F8 FF 89 C2 0F 84 AC FD FF FF 8B 44 24 4C 80 38 00 0F 85 9F FD FF FF 81 FA 80 00 00 00 0F 87 93 FD FF FF 89 5C 24 04 C7 44 24 08 0A 00 00 00 89 2C 24 89 54 24 10 E8 ?? ?? ?? ?? 8B 54 24 10 83 F8 FF 89 C3 0F 84 F1 05 00 00 8B 44 24 4C 80 38 00 0F 85 5F FD FF FF 85 DB 0F 88 57 FD FF FF C7 04 24 1C 00 00 00 89 54 24 10 E8 ?? ?? ?? ?? 8B 54 24 10 85 C0 0F 84 6B 06 00 00 8B 4C 24 50 89 58 14 8B 5C 24 18 89 50 10 89 08 8B 4C 24 54 89 48 04 8B 4C 24 58 89 48 08 8B 4C 24 5C 89 48 0C 8B 0B 89 03 8B 5C 24 20 89 48 18 8B 4C 24 1C 83 01 01 85 D2 0F 94 C0 08 03 E9 F8 FC FF FF BF ?? ?? ?? ?? B9 08 00 00 00 F3 A6 0F 85 E6 FC FF FF 8B 35 ?? ?? ?? ?? 65 C7 06 00 00 00 00 C7 44 24 04 2F 00 00 00 89 1C 24 E8 ?? ?? ?? ?? 85 C0 89 C7 74 06 C6 00 00 83 C7 01 8D 44 24 60 89 44 24 08 89 5C 24 04 C7 04 24 0A 00 00 00 E8 ?? ?? ?? ?? 85 C0 0F 84 29 03 00 00 8B 44 24 60 85 C0 0F 85 91 FC FF FF 8B 44 24 64 85 C0 0F 85 85 FC FF FF 81 7C 24 68 00 00 FF FF 0F 85 77 FC FF FF 85 FF 0F 84 30 05 00 00 8D 5C 24 4C 89 3C 24 C7 44 24 08 0A 00 00 00 89 5C 24 04 E8 ?? ?? ?? ?? 83 F8 FF 89 C7 0F 84 C2 04 00 00 8B 44 24 4C 80 38 00 0F 85 3F FC FF FF 8D 47 A0 83 F8 20 0F 87 33 FC FF FF 8D 5C 24 4C 89 5C 24 04 C7 44 24 08 0A 00 00 00 89 2C 24 E8 ?? ?? ?? ?? 83 F8 FF 89 C3 0F 84 B7 04 00 00 8B 44 24 4C 80 38 00 0F 85 03 FC FF FF 85 DB 0F 88 FB FB FF FF C7 04 24 10 00 00 00 E8 ?? ?? ?? ?? 85 C0 0F 84 17 05 00 00 83 FF 60 0F 84 96 04 00 00 B9 80 00 00 00 BA FF FF FF FF 29 F9 D3 E2 8B 4C 24 6C 0F CA 21 D1 89 50 04 8B 54 24 28 83 44 24 24 01 83 FF 60 89 08 89 50 0C 0F 94 C2 89 58 08 08 54 24 2F 89 44 24 28 E9 A1 FB FF FF 90 BF ?? ?? ?? ?? B9 07 00 00 00 F3 A6 0F 85 8E FB FF FF 0F B6 03 83 E8 79 75 37 0F B6 43 01 83 E8 65 75 2E 0F B6 43 02 83 E8 73 75 25 31 C0 80 7B 03 00 0F 94 C0 85 C0 A3 ?? ?? ?? ?? 0F 84 5E FB FF FF C7 05 ?? ?? ?? ?? 01 00 00 00 E9 4F FB FF FF 85 C0 0F 94 C0 0F B6 C0 A3 ?? ?? ?? ?? E9 3D FB FF FF BF ?? ?? ?? ?? B9 06 00 00 00 F3 A6 0F 85 2B FB FF FF 8D 4C 24 32 89 4C 24 20 8D 54 24 38 8D 4C 24 34 89 54 24 1C 89 4C 24 18 E9 EA FC FF FF 8D B6 00 00 00 00 8B 5C 24 14 8B 03 E9 99 F9 FF FF 89 DD E9 83 FA FF FF 31 C9 31 FF E9 36 FA FF FF 0F B6 7C 24 32 89 FB 84 DB 0F 84 3C 02 00 00 8D 04 76 C1 E0 03 89 04 24 E8 ?? ?? ?? ?? 85 C0 89 C3 0F 84 04 03 00 00 89 FA 89 F0 84 D2 0F 84 8A 02 00 00 85 C0 8B 7C 24 34 7E 45 6B F0 E8 89 FA 8D 04 40 8D 0C C3 31 C0 90 8D 74 26 00 8B 2A 89 6C 01 E8 8B 6A 04 89 6C 01 EC 8B 6A 08 89 6C 01 F0 8B 6A 0C 89 6C 01 F4 8B 6A 10 89 6C 01 F8 8B 6A 14 89 6C 01 FC 83 E8 18 8B 52 18 39 F0 75 CD 89 F8 E8 A6 CF FF FF 8B 44 24 38 C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 18 00 00 00 89 1C 24 89 44 24 04 E8 ?? ?? ?? ?? 8B 7C 24 40 85 FF 0F 84 7D FA FF FF 0F B6 74 24 33 89 F1 84 C9 0F 84 95 01 00 00 8D 04 7F C1 E0 03 89 04 24 E8 ?? ?? ?? ?? 85 C0 89 C5 0F 84 A8 02 00 00 89 F2 89 F8 84 D2 0F 84 9F 01 00 00 85 C0 8B 7C 24 3C 7E 4E 6B F0 E8 89 FA 8D 04 40 8D 4C C5 00 31 C0 89 5C 24 14 90 8D 74 26 00 8B 1A 89 5C 01 E8 8B 5A 04 89 5C 01 EC 8B 5A 08 89 5C 01 F0 8B 5A 0C 89 5C 01 F4 8B 5A 10 89 5C 01 F8 8B 5A 14 89 5C 01 FC 83 E8 18 8B 52 18 39 F0 75 CD 8B 5C 24 14 89 F8 E8 EA CE FF FF 8B 44 24 40 C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 18 00 00 00 89 2C 24 89 44 24 04 E8 ?? ?? ?? ?? 8B 44 24 24 85 C0 0F 85 D2 F9 FF FF BE ?? ?? ?? ?? E9 75 FA FF FF 8D 44 24 6C 89 44 24 08 89 5C 24 04 C7 04 24 02 00 00 00 E8 ?? ?? ?? ?? 85 C0 0F 84 54 F9 FF FF 85 FF 0F 84 26 02 00 00 8D 5C 24 4C 89 3C 24 C7 44 24 08 0A 00 00 00 89 5C 24 04 E8 ?? ?? ?? ?? 83 F8 FF 89 C7 0F 84 29 F9 FF FF 8B 44 24 4C 80 38 00 0F 85 1C F9 FF FF 83 FF 20 0F 87 13 F9 FF FF 89 5C 24 04 C7 44 24 08 0A 00 00 00 89 2C 24 E8 ?? ?? ?? ?? 83 F8 FF 89 C3 0F 84 BF 01 00 00 8B 44 24 4C 80 38 00 0F 85 E7 F8 FF FF 83 C7 60 85 DB 0F 89 E1 FC FF FF E9 D7 F8 FF FF 8D B4 26 00 00 00 00 8B 44 24 14 89 04 24 E8 ?? ?? ?? ?? 8B 44 24 34 E8 FB CD FF FF 8B 44 24 3C E8 F2 CD FF FF E8 ?? ?? ?? ?? 81 C4 DC 00 00 00 5B 5E 5F 5D C3 83 C6 01 89 74 24 38 E9 B8 FD FF FF 83 C7 01 89 7C 24 40 E9 5F FE FF FF 83 E8 01 8D 14 40 8D 14 96 C7 02 00 00 00 00 C7 42 04 00 00 00 00 C7 42 08 0E 00 00 00 E9 F1 F8 FF FF 83 E8 01 8D 14 40 8D 54 D5 00 C7 02 00 00 00 00 C7 42 04 00 00 00 00 C7 42 08 00 00 00 00 C7 42 0C 00 00 00 00 C7 42 10 00 00 00 00 C7 42 14 28 00 00 00 E9 29 FE FF FF 83 E8 01 8D 14 40 8D 14 D3 C7 02 00 00 00 00 C7 42 04 00 00 00 00 C7 42 08 00 00 00 00 C7 42 0C 00 00 00 00 C7 42 10 00 00 00 00 C7 42 14 01 00 00 00 E9 3F FD FF FF 8B 44 24 34 E8 30 CD FF FF 8B 44 24 3C E8 27 CD FF FF E9 30 FF FF FF 81 FB ?? ?? ?? ?? 74 08 89 1C 24 E8 ?? ?? ?? ?? 81 FD ?? ?? ?? ?? 74 08 89 2C 24 E8 ?? ?? ?? ?? 8B 44 24 34 E8 F9 CC FF FF 8B 44 24 3C E8 F0 CC FF FF 8B 5C 24 28 85 DB 0F 84 F2 FE FF FF 8B 44 24 28 8B 58 0C 89 04 24 E8 ?? ?? ?? ?? 85 DB 89 D8 75 EF E9 D8 FE FF FF 65 83 3E 22 0F 85 34 FB FF FF E9 7B F7 FF FF 65 83 3E 22 0F 85 05 FA FF FF 90 E9 6B F7 FF FF 81 FB ?? ?? ?? ?? 74 A1 89 1C 24 E8 ?? ?? ?? ?? EB 97 65 83 3E 22 0F 85 3F FB FF FF E9 4A F7 FF FF 66 90 31 D2 31 C9 E9 77 FB FF FF BF 80 00 00 00 E9 E9 FA FF FF 65 83 3E 22 0F 85 37 FE FF FF E9 26 F7 FF FF 8B 44 24 4C 80 38 00 0F 85 19 F7 FF FF BF 20 00 00 00 8D 5C 24 4C E9 F8 FD FF FF 8D 44 24 50 89 44 24 08 89 5C 24 04 C7 04 24 0A 00 00 00 E8 ?? ?? ?? ?? 85 C0 0F 84 EB F6 FF FF 8B 44 24 4C 80 38 00 0F 85 DE F6 FF FF BA 80 00 00 00 8D 5C 24 4C E9 3D F9 FF FF 8B 44 24 44 89 04 24 E8 ?? ?? ?? ?? 8B 44 24 14 89 04 24 E8 ?? ?? ?? ?? E9 F1 FE FF FF }
	condition:
		$1
}

rule file_1_13_0 {
	meta:
		name = "freeaddrinfo"
		size = 50
		refs = "001a free"
	strings:
		$1 = { 56 53 83 EC 14 8B 5C 24 20 85 DB 74 1F 8D 76 00 8B 43 18 8B 73 1C 89 04 24 E8 ?? ?? ?? ?? 89 1C 24 89 F3 E8 ?? ?? ?? ?? 85 F6 75 E4 83 C4 14 5B 5E C3 }
	condition:
		$1
}

rule file_1_14_0 {
	meta:
		name = "getaddrinfo"
		size = 2717
		refs = "0124 __pthread_once 01be qsort 025f __connect 0292 __libc_errno 0344 __socket 0395 _dl_sysinfo 03ca memcmp 040d memcpy 0468 __getsockname 04ed bsearch 05c9 qsort_r 0651 __free_in6ai 06c6 __check_pf 077c strtoul 084c __assert_fail 0860 freeaddrinfo 0a68 __xstat64"
	strings:
		$1 = { 55 89 E5 57 56 53 81 EC 3C 01 00 00 8B 7D 08 8B 45 0C 8B 75 10 C7 85 18 FF FF FF 00 00 00 00 85 FF 0F 84 A1 08 00 00 31 C9 80 3F 2A 0F 84 16 07 00 00 85 C0 0F 84 48 06 00 00 80 38 2A 0F 84 35 06 00 00 85 F6 BA ?? ?? ?? ?? 0F 44 F2 8B 16 F7 C2 00 F8 FF FF 0F 85 4D 03 00 00 F6 C2 02 0F 85 3C 03 00 00 31 DB 83 E2 20 C7 85 1C FF FF FF 00 00 00 00 C7 85 20 FF FF FF 00 00 00 00 C6 85 16 FF FF FF 00 C6 85 17 FF FF FF 00 0F 85 07 06 00 00 31 D2 85 C0 74 09 80 38 00 0F 85 C0 06 00 00 8B 46 04 C7 85 28 FF FF FF 00 00 00 00 A9 FD FF FF FF 74 09 83 F8 0A 0F 85 BC 08 00 00 8D 85 28 FF FF FF 89 F1 89 44 24 04 8D 85 18 FF FF FF 89 04 24 89 F8 E8 D7 CC FF FF 85 C0 0F 85 6F 07 00 00 8B 85 18 FF FF FF C7 85 F0 FE FF FF 00 00 00 00 8B 95 F0 FE FF FF 85 C0 74 15 90 8D 74 26 00 8B 40 1C 83 C2 01 85 C0 75 F6 89 95 F0 FE FF FF 83 BD 28 FF FF FF 01 0F 86 2A 05 00 00 8B 15 ?? ?? ?? ?? B8 ?? ?? ?? ?? 85 C0 89 A5 E4 FE FF FF 89 95 E0 FE FF FF 0F 84 79 08 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? FF D0 6B 85 F0 FE FF FF 2C 83 C0 12 83 E0 F0 29 C4 8D 54 24 14 89 95 F4 FE FF FF 8B 95 F0 FE FF FF 8D 04 95 12 00 00 00 83 E0 F0 29 C4 8D 54 24 17 C1 EA 02 89 95 E8 FE FF FF C1 E2 02 84 DB 89 95 F8 FE FF FF 0F 84 1A 06 00 00 8B 85 1C FF FF FF 85 C0 74 22 C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 18 00 00 00 8B 95 20 FF FF FF 89 04 24 89 54 24 04 E8 ?? ?? ?? ?? 8B BD 18 FF FF FF 85 FF 0F 84 71 07 00 00 BB FF FF FF FF 8B B5 F4 FE FF FF 31 C0 C7 85 FC FE FF FF 00 00 00 00 C7 85 00 FF FF FF 00 00 00 00 C7 85 04 FF FF FF 00 00 00 00 89 9D D8 FE FF FF E9 D9 00 00 00 66 90 83 BD FC FE FF FF 02 75 0A 83 7F 04 0A 0F 84 6D 01 00 00 8D 85 40 FF FF FF C7 85 40 FF FF FF 00 00 00 00 C7 85 44 FF FF FF 00 00 00 00 C7 85 48 FF FF FF 00 00 00 00 C7 85 4C FF FF FF 00 00 00 00 C7 44 24 08 10 00 00 00 89 44 24 04 8B 9D D8 FE FF FF 89 1C 24 E8 ?? ?? ?? ?? C7 85 2C FF FF FF 1C 00 00 00 8B 4F 10 8B 47 14 89 4C 24 08 89 44 24 04 8B 9D D8 FE FF FF 89 1C 24 E8 ?? ?? ?? ?? 85 C0 0F 84 A7 01 00 00 A1 ?? ?? ?? ?? 65 83 38 61 0F 84 D0 00 00 00 C6 46 20 00 8B 47 18 85 C0 74 1B 8B 95 00 FF FF FF 85 D2 0F 85 D8 06 00 00 C7 47 18 00 00 00 00 89 85 00 FF FF FF 8B 4F 1C 83 C6 2C 89 F8 83 85 04 FF FF FF 01 85 C9 0F 84 83 02 00 00 89 CF 8B 8D 04 FF FF FF 85 C0 8B 95 F8 FE FF FF 89 3E C7 46 28 FF FF FF FF 89 0C 8A 74 0C 8B 48 10 3B 4F 10 0F 84 B1 00 00 00 83 BD D8 FE FF FF FF C6 46 21 00 C6 46 22 00 C6 46 23 00 C7 46 24 FF FF FF FF 0F 85 E1 FE FF FF 8B 57 04 89 95 FC FE FF FF C7 44 24 08 00 00 00 00 C7 44 24 04 02 00 00 00 89 14 24 E8 ?? ?? ?? ?? C7 85 2C FF FF FF 1C 00 00 00 83 F8 FF 89 85 D8 FE FF FF 0F 85 0C FF FF FF A1 ?? ?? ?? ?? 65 83 38 61 0F 85 30 FF FF FF 83 BD FC FE FF FF 0A 0F 85 23 FF FF FF 83 7F 04 02 0F 85 19 FF FF FF 90 8B 9D D8 FE FF FF B8 06 00 00 00 FF 15 ?? ?? ?? ?? EB 8C 90 8D 74 26 00 84 C9 0F 84 BC FC FF FF B8 FF FF FF FF E9 B8 02 00 00 8D B6 00 00 00 00 89 4C 24 08 8B 4F 14 89 4C 24 04 8B 40 14 89 04 24 E8 ?? ?? ?? ?? 85 C0 0F 85 31 FF FF FF 8B 8D 04 FF FF FF 8B 95 F4 FE FF FF 6B 85 04 FF FF FF 2C 8B 9D F4 FE FF FF 83 E9 01 6B C9 2C 8D 44 02 04 0F B6 56 F4 89 04 24 8D 4C 0B 04 89 54 24 08 89 4C 24 04 E8 ?? ?? ?? ?? 0F B6 46 F4 88 46 20 0F B6 46 F5 88 46 21 0F B6 46 F6 88 46 22 0F B6 46 F7 88 46 23 8B 46 F8 89 46 24 E9 6C FE FF FF 6B 85 04 FF FF FF 2C 8B 9D F4 FE FF FF 01 C3 8D 53 04 8D 85 2C FF FF FF 89 54 24 04 89 44 24 08 8B 8D D8 FE FF FF 89 0C 24 89 95 DC FE FF FF E8 ?? ?? ?? ?? 8B 95 DC FE FF FF 85 C0 0F 85 17 FE FF FF 8B 85 2C FF FF FF C6 46 21 01 88 46 20 8B 85 1C FF FF FF 85 C0 74 7D 83 7F 04 02 0F 84 ED 03 00 00 8B 4A 08 89 8D 58 FF FF FF 8B 4A 0C 89 8D 5C FF FF FF 8B 4A 10 89 8D 60 FF FF FF 8B 4A 14 89 8D 64 FF FF FF C7 44 24 10 ?? ?? ?? ?? C7 44 24 0C 18 00 00 00 8B 8D 20 FF FF FF 89 44 24 04 8D 85 50 FF FF FF 89 04 24 89 4C 24 08 89 95 DC FE FF FF E8 ?? ?? ?? ?? 8B 95 DC FE FF FF 85 C0 74 13 0F B6 08 88 4E 22 0F B6 48 01 88 4E 23 8B 40 04 89 46 24 83 7F 04 02 0F 85 8C FD FF FF 83 BD FC FE FF FF 0A 0F 85 7F FD FF FF 8B 42 08 85 C0 0F 85 FC 02 00 00 8B 4A 0C 85 C9 0F 85 F1 02 00 00 81 7A 10 00 00 FF FF 0F 85 E4 02 00 00 66 C7 43 04 02 00 8B 42 14 89 42 04 C6 46 20 10 E9 47 FD FF FF 8D 76 00 8B 9D D8 FE FF FF 83 FB FF 74 0B B8 06 00 00 00 FF 15 ?? ?? ?? ?? 8B 95 F4 FE FF FF A1 ?? ?? ?? ?? 89 95 38 FF FF FF 8B 95 F0 FE FF FF 85 C0 89 95 3C FF FF FF 0F 85 39 04 00 00 8D 85 38 FF FF FF 89 44 24 10 C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 04 00 00 00 8B 95 F0 FE FF FF 89 54 24 04 8B 95 F8 FE FF FF 89 14 24 E8 ?? ?? ?? ?? 8B 95 E8 FE FF FF 6B 04 95 00 00 00 00 2C 8B 95 F4 FE FF FF 83 BD F0 FE FF FF 01 8B 1C 02 89 9D 18 FF FF FF 0F 8E 7B 03 00 00 89 D9 8B BD F8 FE FF FF B8 01 00 00 00 89 9D 04 FF FF FF 8B 9D F0 FE FF FF 89 D6 8D B6 00 00 00 00 6B 14 87 2C 83 C0 01 39 D8 8B 14 16 89 51 1C 89 D1 75 ED 8B 9D 04 FF FF FF C7 42 1C 00 00 00 00 8B 95 00 FF FF FF 89 53 18 8B A5 E4 FE FF FF 8B 85 1C FF FF FF 89 04 24 E8 ?? ?? ?? ?? 8B 95 18 FF FF FF 85 D2 0F 84 05 03 00 00 8B 45 14 89 10 31 C0 8D 65 F4 5B 5E 5F 5D C3 8D B6 00 00 00 00 80 78 01 00 0F 85 C1 F9 FF FF 84 C9 0F 85 DE 02 00 00 31 C0 E9 B2 F9 FF FF 8D B4 26 00 00 00 00 8D 95 20 FF FF FF 89 54 24 0C 8D 95 1C FF FF FF 89 54 24 08 8D 95 17 FF FF FF 89 54 24 04 8D 95 16 FF FF FF 89 14 24 89 85 DC FE FF FF E8 ?? ?? ?? ?? 8B 56 04 8B 85 DC FE FF FF 85 D2 0F 85 15 01 00 00 80 BD 16 FF FF FF 00 0F 84 EA 01 00 00 80 BD 17 FF FF FF 00 BB 01 00 00 00 0F 85 97 F9 FF FF 8B 16 C7 85 6C FF FF FF 00 00 00 00 89 95 68 FF FF FF 8B 56 08 89 95 70 FF FF FF 8B 56 0C 89 95 74 FF FF FF 8B 56 10 89 95 78 FF FF FF 8B 56 14 89 95 7C FF FF FF 8B 56 18 89 55 80 8B 56 1C 89 55 84 BA 02 00 00 00 E9 E5 01 00 00 66 90 80 7F 01 00 0F 85 E0 F8 FF FF B9 01 00 00 00 31 FF E9 D4 F8 FF FF 66 90 8D 95 24 FF FF FF 89 85 30 FF FF FF C7 44 24 08 0A 00 00 00 89 54 24 04 89 04 24 E8 ?? ?? ?? ?? 89 85 34 FF FF FF 8B 85 24 FF FF FF 80 38 00 74 12 F7 06 00 04 00 00 75 7B C7 85 34 FF FF FF FF FF FF FF 8D 95 30 FF FF FF E9 F2 F8 FF FF 66 90 8D 85 20 FF FF FF 89 44 24 0C 8D 85 1C FF FF FF 89 44 24 08 8D 85 17 FF FF FF 89 44 24 04 8D 85 16 FF FF FF 89 04 24 E8 ?? ?? ?? ?? 8B 85 1C FF FF FF 85 C0 0F 85 B6 F9 FF FF E9 D3 F9 FF FF 90 83 FA 02 BB 01 00 00 00 0F 84 52 01 00 00 83 FA 0A 0F 85 8A F8 FF FF 80 BD 17 FF FF FF 00 0F 85 7D F8 FF FF 8B 85 1C FF FF FF 89 04 24 E8 ?? ?? ?? ?? B8 FE FF FF FF E9 3E FE FF FF C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 02 0A 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 95 18 FF FF FF 89 14 24 89 85 DC FE FF FF E8 ?? ?? ?? ?? 8B 95 1C FF FF FF 89 14 24 E8 ?? ?? ?? ?? 8B 85 DC FE FF FF 8D 65 F4 5B 5E 5F 80 E4 FE F7 D8 5D C3 8D 76 00 83 BD FC FE FF FF 02 0F 85 06 FC FF FF 8B 4A 04 C7 85 58 FF FF FF 00 00 00 00 C7 85 5C FF FF FF 00 00 00 00 C7 85 60 FF FF FF 00 00 FF FF 89 8D 64 FF FF FF E9 FE FB FF FF 8D B4 26 00 00 00 00 B9 01 00 00 00 E9 60 F7 FF FF 80 BD 17 FF FF FF 00 BB 01 00 00 00 0F 84 AD F7 FF FF 8B 16 C7 85 6C FF FF FF 00 00 00 00 89 95 68 FF FF FF 8B 56 08 89 95 70 FF FF FF 8B 56 0C 89 95 74 FF FF FF 8B 56 10 89 95 78 FF FF FF 8B 56 14 89 95 7C FF FF FF 8B 56 18 89 55 80 8B 56 1C 89 55 84 BA 0A 00 00 00 89 95 6C FF FF FF BB 01 00 00 00 8D B5 68 FF FF FF E9 50 F7 FF FF C7 85 00 FF FF FF 00 00 00 00 E9 26 FC FF FF 80 BD 16 FF FF FF 00 0F 85 34 F7 FF FF E9 B2 FE FF FF 8D B6 00 00 00 00 B8 FE FF FF FF E9 F8 FC FF FF 89 DA E9 B8 FC FF FF 8B 85 1C FF FF FF 89 04 24 E8 ?? ?? ?? ?? B8 FA FF FF FF E9 D9 FC FF FF C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 1D 0A 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 85 E0 FE FF FF 85 C0 0F 85 8A F7 FF FF E8 98 EA FF FF 83 0D ?? ?? ?? ?? 02 E9 79 F7 FF FF 31 C0 B9 01 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 0D ?? ?? ?? ?? 0F 85 AA 00 00 00 8B 85 E0 FE FF FF 85 C0 74 09 A1 ?? ?? ?? ?? 85 C0 75 4B 8D 85 38 FF FF FF 89 44 24 10 C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 04 00 00 00 8B 95 F0 FE FF FF 89 54 24 04 8B 95 F8 FE FF FF 89 14 24 E8 ?? ?? ?? ?? 65 83 3D 0C 00 00 00 00 74 01 F0 83 2D ?? ?? ?? ?? 01 75 61 E9 7C FB FF FF 8D 45 88 89 44 24 08 C7 44 24 04 ?? ?? ?? ?? C7 04 24 03 00 00 00 E8 ?? ?? ?? ?? 85 C0 75 23 8D 45 D0 C7 44 24 08 08 00 00 00 C7 44 24 04 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 85 C0 0F 84 73 FF FF FF E8 C8 E9 FF FF E9 69 FF FF FF }
	condition:
		$1
}

rule file_1_15_0 {
	meta:
		name = "fini"
		size = 97
		refs = "001d free"
	strings:
		$1 = { 83 EC 1C A1 ?? ?? ?? ?? 3D ?? ?? ?? ?? 74 12 89 04 24 C7 05 ?? ?? ?? ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 3D ?? ?? ?? ?? 74 12 89 04 24 C7 05 ?? ?? ?? ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 3D ?? ?? ?? ?? 74 12 89 04 24 C7 05 ?? ?? ?? ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 1C C3 }
	condition:
		$1
}

rule file_3_0_0 {
	meta:
		name = "bcopy"
		size = 80
	strings:
		$1 = { 57 8B 4C 24 10 8B 7C 24 0C 89 F2 8B 74 24 08 89 F8 29 F0 39 C7 73 12 FC D1 E9 73 01 A4 D1 E9 73 02 66 A5 F3 A5 89 D6 5F C3 FD 8D 7C 0F FF 8D 74 0E FF D1 E9 73 01 A4 83 EF 01 83 EE 01 D1 E9 73 02 66 A5 83 EF 02 83 EE 02 F3 A5 89 D6 FC 5F C3 }
	condition:
		$1
}

rule file_4_0_0 {
	meta:
		name = "__libc_cleanup_routine"
		size = 27
		altNames = "__pthread_cleanup_routine"
	strings:
		$1 = { 8B 44 24 04 8B 50 08 85 D2 75 05 F3 C3 8D 76 00 8B 50 04 89 54 24 04 8B 00 FF E0 }
	condition:
		$1
}

rule file_5_0_0 {
	meta:
		name = "__atomic_pwritev64_replacement"
		size = 358
		refs = "00b0 mempcpy 00db __pwrite64 00e9 free 0101 __libc_errno 0129 __libc_alloca_cutoff 013f malloc"
	strings:
		$1 = { 55 89 E5 57 56 53 83 EC 4C 8B 5D 0C 89 4D E4 8B 4D 08 89 45 DC 89 5D D4 89 4D D0 8B 4D E4 85 C9 0F 8E F5 00 00 00 8B 4A 04 81 F9 FF FF FF 7F 0F 87 CB 00 00 00 31 C0 31 DB BF FF FF FF 7F EB 10 8B 4C C2 04 89 FE 29 DE 39 CE 0F 82 B0 00 00 00 01 CB 83 C0 01 3B 45 E4 75 E6 81 FB 00 10 00 00 0F 87 BC 00 00 00 8D 43 1E 83 E0 F0 29 C4 8D 44 24 23 83 E0 F0 89 45 E0 8B 45 E4 C7 45 D8 00 00 00 00 85 C0 7E 35 31 F6 8B 45 E0 89 D7 89 5D CC 89 F3 8B 75 E4 8D 76 00 8B 4F 04 83 C3 01 83 C7 08 89 4C 24 08 8B 4F F8 89 04 24 89 4C 24 04 E8 ?? ?? ?? ?? 39 F3 75 E0 8B 5D CC 8B 45 E0 8B 55 D0 8B 4D D4 89 5C 24 08 89 44 24 04 8B 45 DC 89 54 24 0C 89 4C 24 10 89 04 24 E8 ?? ?? ?? ?? 8B 55 D8 89 45 C8 89 14 24 E8 ?? ?? ?? ?? 8B 45 C8 8D 65 F4 5B 5E 5F 5D C2 08 00 8D B6 00 00 00 00 A1 ?? ?? ?? ?? 65 C7 00 16 00 00 00 8D 65 F4 B8 FF FF FF FF 5B 5E 5F 5D C2 08 00 31 DB E9 44 FF FF FF 89 1C 24 89 55 C8 E8 ?? ?? ?? ?? 8B 55 C8 85 C0 0F 85 2E FF FF FF 89 1C 24 89 55 C8 E8 ?? ?? ?? ?? 8B 55 C8 85 C0 89 45 E0 74 08 89 45 D8 E9 31 FF FF FF C7 45 D8 00 00 00 00 B8 FF FF FF FF E9 79 FF FF FF }
	condition:
		$1
}

rule file_5_1_0 {
	meta:
		name = "pwritev64"
		size = 240
		refs = "0038 _dl_sysinfo 0069 __libc_errno 0093 __libc_enable_asynccancel 00c0 __libc_disable_asynccancel"
	strings:
		$1 = { 83 EC 3C 89 5C 24 2C 8B 54 24 48 89 74 24 30 8B 5C 24 40 89 7C 24 34 8B 74 24 4C 89 6C 24 38 8B 7C 24 50 65 A1 0C 00 00 00 85 C0 75 61 8B 4C 24 44 B8 4E 01 00 00 FF 15 ?? ?? ?? ?? 3D 00 F0 FF FF 0F 87 86 00 00 00 89 C1 89 CD 85 ED 78 19 89 E8 8B 5C 24 2C 8B 74 24 30 8B 7C 24 34 8B 6C 24 38 83 C4 3C C3 8D 76 00 A1 ?? ?? ?? ?? 65 83 38 26 75 DC 89 D1 8B 54 24 44 89 D8 89 34 24 89 7C 24 04 E8 09 FE FF FF 83 EC 08 89 C5 EB C1 89 54 24 18 E8 ?? ?? ?? ?? 8B 54 24 18 8B 4C 24 44 89 44 24 1C B8 4E 01 00 00 FF 15 ?? ?? ?? ?? 3D 00 F0 FF FF 77 2B 89 C5 8B 44 24 1C 89 54 24 18 E8 ?? ?? ?? ?? 8B 54 24 18 E9 7E FF FF FF 8B 0D ?? ?? ?? ?? F7 D8 65 89 01 83 C9 FF E9 69 FF FF FF 8B 0D ?? ?? ?? ?? F7 D8 65 89 01 83 C8 FF EB C5 }
	condition:
		$1
}

rule file_6_0_0 {
	meta:
		name = "__call_pselect6"
		size = 40
	strings:
		$1 = { 53 56 57 55 B8 34 01 00 00 8B 5C 24 14 8B 4C 24 18 8B 54 24 1C 8B 74 24 20 8B 7C 24 24 8B 6C 24 28 CD 80 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule file_7_0_0 {
	meta:
		name = "decode_name"
		size = 194
	strings:
		$1 = { 57 89 C2 56 89 C7 53 8D 48 01 EB 14 8D 74 26 00 88 59 FF 0F B6 1A 83 C1 01 83 C2 01 84 DB 74 38 0F B6 1A 80 FB 5C 75 E8 0F B6 72 01 89 F0 3C 30 74 2E 89 F0 3C 5C 74 58 89 F0 3C 31 75 D2 80 7A 02 33 75 CC 80 7A 03 34 75 C6 C6 41 FF 5C 83 C2 03 EB C0 90 8D 74 26 00 89 F8 5B 5E 5F C3 66 90 0F B6 72 02 89 F0 3C 34 74 36 89 F0 3C 31 75 A0 0F B6 72 03 89 F0 3C 31 74 3C 89 F0 3C 32 75 90 C6 41 FF 0A 83 C2 03 EB 8A 8D B4 26 00 00 00 00 C6 41 FF 5C 83 C2 01 E9 77 FF FF FF 8D 74 26 00 80 7A 03 30 0F 85 66 FF FF FF C6 41 FF 20 83 C2 03 E9 5D FF FF FF C6 41 FF 09 83 C2 03 E9 51 FF FF FF }
	condition:
		$1
}

rule file_7_4_0 {
	meta:
		name = "__setmntent"
		size = 88
		refs = "000f strlen 002b mempcpy 0043 _IO_new_fopen"
	strings:
		$1 = { 55 89 E5 56 53 83 EC 10 8B 5D 0C 89 1C 24 E8 ?? ?? ?? ?? 8D 50 12 83 E2 F0 29 D4 8D 74 24 0C 89 44 24 08 89 5C 24 04 89 34 24 E8 ?? ?? ?? ?? 66 C7 00 63 65 C6 40 02 00 8B 45 08 89 74 24 04 89 04 24 E8 ?? ?? ?? ?? 85 C0 74 06 81 08 00 80 00 00 8D 65 F8 5B 5E 5D C3 }
	condition:
		$1
}

rule file_7_5_0 {
	meta:
		name = "__endmntent"
		size = 28
		refs = "000f _IO_new_fclose"
	strings:
		$1 = { 83 EC 1C 8B 44 24 20 85 C0 74 08 89 04 24 E8 ?? ?? ?? ?? B8 01 00 00 00 83 C4 1C C3 }
	condition:
		$1
}

rule file_7_6_0 {
	meta:
		name = "__getmntent_r"
		size = 993
		refs = "006b fgets_unlocked 0083 strchr 038a sscanf"
	strings:
		$1 = { 55 57 56 53 81 EC 1C 04 00 00 8B B4 24 30 04 00 00 8B 9C 24 38 04 00 00 8B 06 25 00 80 00 00 75 32 8B 56 48 65 8B 3D 08 00 00 00 3B 7A 08 74 1F B9 01 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 0A 0F 85 5A 09 00 00 8B 56 48 89 7A 08 83 42 04 01 8D 7C 24 10 90 8B 94 24 3C 04 00 00 89 74 24 08 89 1C 24 89 54 24 04 E8 ?? ?? ?? ?? 85 C0 0F 84 2E 03 00 00 C7 44 24 04 0A 00 00 00 89 1C 24 E8 ?? ?? ?? ?? 85 C0 74 7D C6 00 00 89 D8 EB 09 8D B6 00 00 00 00 83 C0 01 0F B6 08 89 C5 0F BE D1 83 FA 20 74 F0 83 FA 09 74 EB 80 F9 23 74 A6 84 C9 74 A2 80 F9 20 0F 84 7E 00 00 00 80 F9 09 75 13 EB 77 66 90 80 FA 20 90 8D 74 26 00 74 6B 80 FA 09 74 66 83 C5 01 0F B6 55 00 84 D2 75 E6 E8 C9 FD FF FF 8B 94 24 34 04 00 00 89 02 8B 84 24 34 04 00 00 C7 40 04 ?? ?? ?? ?? E9 BC 00 00 00 90 8D 74 26 00 89 74 24 08 C7 44 24 04 00 04 00 00 89 3C 24 E8 ?? ?? ?? ?? 85 C0 0F 84 6A FF FF FF C7 44 24 04 0A 00 00 00 89 3C 24 E8 ?? ?? ?? ?? 85 C0 74 D0 E9 51 FF FF FF C6 45 00 00 83 C5 01 E8 67 FD FF FF 8B 94 24 34 04 00 00 85 ED 89 02 74 9A 89 E8 EB 09 8D B6 00 00 00 00 83 C0 01 0F B6 18 89 C2 0F BE CB 83 F9 20 74 F0 83 F9 09 74 EB 84 DB 74 37 80 FB 20 0F 84 B8 00 00 00 80 FB 09 75 1F E9 AE 00 00 00 8D 74 26 00 80 F9 20 0F 84 A1 00 00 00 80 F9 09 8D 74 26 00 0F 84 94 00 00 00 83 C2 01 0F B6 0A 84 C9 75 E0 E8 FB FC FF FF 8B 94 24 34 04 00 00 89 42 04 8B 84 24 34 04 00 00 C7 40 08 ?? ?? ?? ?? 8B 84 24 34 04 00 00 C7 40 0C ?? ?? ?? ?? 8B 84 24 34 04 00 00 C7 40 10 00 00 00 00 8B 84 24 34 04 00 00 C7 40 14 00 00 00 00 F7 06 00 80 00 00 75 29 8B 56 48 83 6A 04 01 75 20 C7 42 08 00 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 83 2A 01 0F 85 8C 07 00 00 90 8D 74 26 00 8B 84 24 34 04 00 00 81 C4 1C 04 00 00 5B 5E 5F 5D C3 C6 02 00 8D 5A 01 E8 6B FC FF FF 8B 94 24 34 04 00 00 85 DB 89 42 04 0F 84 68 FF FF FF 89 D8 EB 08 90 8D 74 26 00 83 C0 01 0F B6 18 89 C2 0F BE CB 83 F9 20 74 F0 83 F9 09 74 EB 84 DB 74 28 80 FB 20 74 4A 80 FB 09 75 14 EB 43 8D 76 00 80 F9 20 90 8D 74 26 00 74 36 80 F9 09 74 31 83 C2 01 0F B6 0A 84 C9 75 E7 E8 0A FC FF FF 8B 94 24 34 04 00 00 89 42 08 8B 84 24 34 04 00 00 C7 40 0C ?? ?? ?? ?? E9 18 FF FF FF 90 8D 74 26 00 C6 02 00 8D 5A 01 E8 DD FB FF FF 8B 94 24 34 04 00 00 85 DB 89 42 08 74 CF 89 D8 EB 06 8D 76 00 83 C0 01 0F B6 18 89 C2 0F BE CB 83 F9 20 74 F0 83 F9 09 74 EB 84 DB 74 30 80 FB 20 74 3F 80 FB 09 75 1C 90 8D 74 26 00 EB 33 8D B6 00 00 00 00 80 F9 20 90 8D 74 26 00 74 23 80 F9 09 74 1E 83 C2 01 0F B6 0A 84 C9 75 E7 E8 7A FB FF FF 8B 94 24 34 04 00 00 89 42 0C E9 96 FE FF FF C6 02 00 8D 5A 01 E8 60 FB FF FF 8B 94 24 34 04 00 00 85 DB 89 42 0C 0F 84 79 FE FF FF 8B 84 24 34 04 00 00 C7 44 24 04 ?? ?? ?? ?? 89 1C 24 83 C0 14 89 44 24 0C 8B 84 24 34 04 00 00 83 C0 10 89 44 24 08 E8 ?? ?? ?? ?? 85 C0 0F 84 45 FE FF FF 83 F8 01 0F 85 58 FE FF FF 90 E9 44 FE FF FF F7 06 00 80 00 00 75 24 8B 56 48 83 6A 04 01 75 1B C7 42 08 00 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 83 2A 01 0F 85 EA 05 00 00 C7 84 24 34 04 00 00 00 00 00 00 E9 47 FE FF FF }
	condition:
		$1
}

rule file_7_7_0 {
	meta:
		name = "__addmntent"
		size = 1319
		refs = "0040 fseek 0203 fprintf 0212 fflush 023f strlen"
	strings:
		$1 = { 55 89 E5 57 56 53 83 EC 3C 8B 45 0C 8B 50 08 8B 38 8B 70 04 89 55 E0 8B 50 0C 89 55 E4 8B 50 10 8B 40 14 C7 44 24 08 02 00 00 00 C7 44 24 04 00 00 00 00 89 55 DC 8B 55 08 89 45 D8 89 14 24 E8 ?? ?? ?? ?? 85 C0 0F 85 DC 01 00 00 0F B6 1F 84 DB 74 57 80 FB 09 0F 84 54 03 00 00 80 FB 20 0F 84 4B 03 00 00 80 FB 0A 0F 84 42 03 00 00 80 FB 5C 0F 84 39 03 00 00 89 FA EB 25 90 8D 74 26 00 3C 09 0F 84 28 03 00 00 3C 20 0F 84 20 03 00 00 3C 0A 0F 84 18 03 00 00 3C 5C 0F 84 10 03 00 00 83 C2 01 0F B6 02 84 C0 75 D6 0F B6 1E 84 DB 74 59 80 FB 09 0F 84 FE 01 00 00 80 FB 20 0F 84 F5 01 00 00 80 FB 0A 0F 84 EC 01 00 00 80 FB 5C 90 0F 84 E2 01 00 00 89 F2 EB 26 8D B6 00 00 00 00 3C 09 0F 84 D0 01 00 00 3C 20 0F 84 C8 01 00 00 3C 0A 0F 84 C0 01 00 00 3C 5C 0F 84 B8 01 00 00 83 C2 01 0F B6 02 84 C0 75 D6 8B 55 E0 0F B6 1A 84 DB 74 5C 80 FB 20 0F 84 13 02 00 00 80 FB 09 0F 84 0A 02 00 00 80 FB 0A 0F 84 01 02 00 00 80 FB 5C 75 32 E9 F7 01 00 00 8D B4 26 00 00 00 00 3C 09 0F 84 E8 01 00 00 3C 20 8D B6 00 00 00 00 0F 84 DA 01 00 00 3C 0A 0F 84 D2 01 00 00 3C 5C 0F 84 CA 01 00 00 83 C2 01 0F B6 02 84 C0 75 D0 8B 55 E4 0F B6 1A 84 DB 74 56 80 FB 09 0F 84 B5 00 00 00 80 FB 20 0F 84 AC 00 00 00 80 FB 0A 90 0F 84 A2 00 00 00 80 FB 5C 75 2B 90 8D 74 26 00 E9 93 00 00 00 8D 76 00 3C 09 8D B6 00 00 00 00 0F 84 82 00 00 00 3C 20 74 7E 3C 0A 8D 74 26 00 74 76 3C 5C 74 72 83 C2 01 0F B6 02 84 C0 75 D8 8B 55 D8 89 74 24 0C 89 7C 24 08 C7 44 24 04 ?? ?? ?? ?? 89 54 24 1C 8B 55 DC 89 54 24 18 8B 55 E4 89 54 24 14 8B 55 E0 89 54 24 10 8B 55 08 89 14 24 E8 ?? ?? ?? ?? 85 C0 78 1D 8B 55 08 89 14 24 E8 ?? ?? ?? ?? 85 C0 0F 95 C0 8D 65 F4 0F B6 C0 5B 5E 5F 5D C3 66 90 8D 65 F4 B8 01 00 00 00 5B 5E 5F 5D C3 8D 76 00 8B 55 E4 89 14 24 E8 ?? ?? ?? ?? 8B 55 E4 8D 04 85 1F 00 00 00 83 E0 F0 29 C4 8D 4C 24 2F 83 E1 F0 89 C8 EB 30 8D 76 00 80 FB 09 0F 84 BF 01 00 00 80 FB 0A 0F 84 16 02 00 00 80 FB 5C 0F 84 9D 02 00 00 88 18 83 C0 01 0F B6 1A 83 C2 01 84 DB 74 25 0F B6 1A 80 FB 20 75 CE C6 00 5C 83 C2 01 83 C0 04 C6 40 FD 30 C6 40 FE 34 C6 40 FF 30 0F B6 5A FF 84 DB 75 DB 89 4D E4 E9 19 FF FF FF 90 89 34 24 E8 ?? ?? ?? ?? 8D 04 85 1F 00 00 00 83 E0 F0 29 C4 8D 54 24 2F 83 E2 F0 89 D0 EB 2E 90 80 FB 09 0F 84 77 01 00 00 80 FB 0A 0F 84 E6 01 00 00 80 FB 5C 0F 84 15 02 00 00 88 18 83 C0 01 0F B6 0E 83 C6 01 84 C9 74 25 0F B6 1E 80 FB 20 75 CE C6 00 5C 83 C6 01 83 C0 04 C6 40 FD 30 C6 40 FE 34 C6 40 FF 30 0F B6 4E FF 84 C9 75 DB 89 D6 E9 DC FD FF FF 66 90 8B 55 E0 89 14 24 E8 ?? ?? ?? ?? 8B 4D E0 8D 04 85 1F 00 00 00 83 E0 F0 29 C4 8D 54 24 2F 83 E2 F0 89 D0 EB 30 8D 76 00 80 FB 09 0F 84 DF 00 00 00 80 FB 0A 0F 84 4E 01 00 00 80 FB 5C 0F 84 85 01 00 00 88 18 83 C0 01 0F B6 19 83 C1 01 84 DB 74 25 0F B6 19 80 FB 20 75 CE C6 00 5C 83 C1 01 83 C0 04 C6 40 FD 30 C6 40 FE 34 C6 40 FF 30 0F B6 59 FF 84 DB 75 DB 89 55 E0 E9 C1 FD FF FF 90 89 3C 24 E8 ?? ?? ?? ?? 8D 04 85 1F 00 00 00 83 E0 F0 29 C4 8D 54 24 2F 83 E2 F0 89 D0 EB 2E 90 80 FB 09 0F 84 97 00 00 00 80 FB 0A 0F 84 BE 00 00 00 80 FB 5C 0F 84 FD 00 00 00 88 18 83 C0 01 0F B6 0F 83 C7 01 84 C9 74 25 0F B6 1F 80 FB 20 75 CE C6 00 5C 83 C7 01 83 C0 04 C6 40 FD 30 C6 40 FE 34 C6 40 FF 30 0F B6 4F FF 84 C9 75 DB 89 D7 E9 84 FC FF FF 66 90 C6 00 5C 83 C0 04 C6 40 FD 30 C6 40 FE 31 C6 40 FF 31 E9 41 FE FF FF 90 C6 00 5C 83 C0 04 C6 40 FD 30 C6 40 FE 31 C6 40 FF 31 E9 21 FF FF FF 90 C6 00 5C 83 C0 04 C6 40 FD 30 C6 40 FE 31 C6 40 FF 31 E9 89 FE FF FF 90 C6 00 5C 83 C0 04 C6 40 FD 30 C6 40 FE 31 C6 40 FF 31 E9 69 FF FF FF 90 C6 00 5C 83 C0 04 C6 40 FD 30 C6 40 FE 31 C6 40 FF 32 E9 E1 FD FF FF 90 C6 00 5C 83 C0 04 C6 40 FD 30 C6 40 FE 31 C6 40 FF 32 E9 39 FF FF FF 90 C6 00 5C 83 C0 04 C6 40 FD 30 C6 40 FE 31 C6 40 FF 32 E9 A9 FE FF FF 90 C6 00 5C 83 C0 04 C6 40 FD 30 C6 40 FE 31 C6 40 FF 32 E9 11 FE FF FF 90 C6 00 5C 83 C0 02 C6 40 FF 5C E9 F9 FE FF FF 90 C6 00 5C 83 C0 02 C6 40 FF 5C E9 71 FE FF FF 90 C6 00 5C 83 C0 02 C6 40 FF 5C E9 E1 FD FF FF 90 C6 00 5C 83 C0 02 C6 40 FF 5C E9 59 FD FF FF }
	condition:
		$1
}

rule file_7_8_0 {
	meta:
		name = "__hasmntopt"
		size = 131
		refs = "000e strlen 002c strchr 003f strstr"
	strings:
		$1 = { 57 56 53 83 EC 10 8B 74 24 24 89 34 24 E8 ?? ?? ?? ?? 89 C7 8B 44 24 20 8B 58 0C EB 1A 8D 76 00 C7 44 24 04 2C 00 00 00 89 14 24 E8 ?? ?? ?? ?? 85 C0 74 44 8D 58 01 89 74 24 04 89 1C 24 E8 ?? ?? ?? ?? 85 C0 89 C2 74 1F 39 DA 74 06 80 7A FF 2C 75 CD 0F B6 04 3A 3C 3D 74 0D 84 C0 74 09 3C 2C 75 BD 90 8D 74 26 00 83 C4 10 89 D0 5B 5E 5F C3 8D B4 26 00 00 00 00 83 C4 10 31 D2 5B 89 D0 5E 5F C3 }
	condition:
		$1
}

rule file_8_0_0 {
	meta:
		name = "__setitimer"
		size = 37
		refs = "0014 _dl_sysinfo 0020 __syscall_error"
	strings:
		$1 = { 53 8B 54 24 10 8B 4C 24 0C 8B 5C 24 08 B8 68 00 00 00 FF 15 ?? ?? ?? ?? 5B 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_9_3_0 {
	meta:
		name = "__isoc99_vwscanf"
		size = 234
		refs = "0007 stdin 0072 _IO_vfwscanf 00e6 _Unwind_Resume"
	strings:
		$1 = { 56 53 83 EC 14 8B 1D ?? ?? ?? ?? 8B 03 89 DA 25 00 80 00 00 75 3C 8B 73 48 65 8B 15 08 00 00 00 3B 56 08 0F 84 87 00 00 00 B9 01 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 0E 0F 85 A8 00 00 00 8B 73 48 89 56 08 8B 15 ?? ?? ?? ?? 83 46 04 01 8B 44 24 24 83 4A 3C 10 C7 44 24 0C 00 00 00 00 89 44 24 08 8B 44 24 20 89 14 24 89 44 24 04 E8 ?? ?? ?? ?? 83 63 3C EB 89 C2 F7 03 00 80 00 00 75 20 8B 4B 48 83 69 04 01 75 17 C7 41 08 00 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 83 29 01 75 52 83 C4 14 89 D0 5B 5E C3 8D 74 26 00 89 DA EB 9A 83 63 3C EB 89 C6 F7 03 00 80 00 00 75 20 8B 53 48 83 6A 04 01 75 17 C7 42 08 00 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 83 2A 01 75 1D 89 34 24 E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1161_3_0 {
	meta:
		name = "__isoc99_vscanf"
		size = 234
		refs = "0007 stdin 0072 _IO_vfscanf 00e6 _Unwind_Resume"
	strings:
		$1 = { 56 53 83 EC 14 8B 1D ?? ?? ?? ?? 8B 03 89 DA 25 00 80 00 00 75 3C 8B 73 48 65 8B 15 08 00 00 00 3B 56 08 0F 84 87 00 00 00 B9 01 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 0E 0F 85 A8 00 00 00 8B 73 48 89 56 08 8B 15 ?? ?? ?? ?? 83 46 04 01 8B 44 24 24 83 4A 3C 10 C7 44 24 0C 00 00 00 00 89 44 24 08 8B 44 24 20 89 14 24 89 44 24 04 E8 ?? ?? ?? ?? 83 63 3C EB 89 C2 F7 03 00 80 00 00 75 20 8B 4B 48 83 69 04 01 75 17 C7 41 08 00 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 83 29 01 75 52 83 C4 14 89 D0 5B 5E C3 8D 74 26 00 89 DA EB 9A 83 63 3C EB 89 C6 F7 03 00 80 00 00 75 20 8B 53 48 83 6A 04 01 75 17 C7 42 08 00 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 83 2A 01 75 1D 89 34 24 E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_0_0 {
	meta:
		name = "allocate"
		size = 24
		refs = "000b malloc"
	strings:
		$1 = { 83 EC 1C C7 04 24 00 04 00 00 E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? 83 C4 1C C3 }
	condition:
		$1
}

rule file_10_1_0 {
	meta:
		name = "getnetgrent"
		size = 130
		refs = "0001 __pthread_once 004a __getnetgrent_r 0059 __libc_errno"
	strings:
		$1 = { B8 ?? ?? ?? ?? 83 EC 2C 85 C0 74 5F C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? FF D0 A1 ?? ?? ?? ?? 85 C0 74 32 89 44 24 0C 8B 44 24 38 C7 44 24 10 00 04 00 00 89 44 24 08 8B 44 24 34 89 44 24 04 8B 44 24 30 89 04 24 E8 ?? ?? ?? ?? 83 C4 2C C3 8D B6 00 00 00 00 A1 ?? ?? ?? ?? 65 C7 00 0C 00 00 00 B8 FF FF FF FF EB E3 83 3D ?? ?? ?? ?? 00 75 A9 E8 67 FF FF FF 83 0D ?? ?? ?? ?? 02 EB 9B }
	condition:
		$1
}

rule file_11_3_0 {
	meta:
		name = "putwc"
		size = 229
		refs = "00ab __woverflow 00e1 _Unwind_Resume"
	strings:
		$1 = { 83 EC 1C 89 5C 24 10 8B 5C 24 24 89 74 24 14 8B 74 24 20 89 7C 24 18 8B 03 25 00 80 00 00 75 32 8B 53 48 65 8B 3D 08 00 00 00 3B 7A 08 74 1F B9 01 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 0A 0F 85 9D 00 00 00 8B 53 48 89 7A 08 83 42 04 01 8B 53 58 85 D2 74 4A 8B 4A 10 3B 4A 14 73 42 89 31 83 C1 04 89 4A 10 F7 03 00 80 00 00 75 20 8B 53 48 83 6A 04 01 75 17 C7 42 08 00 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 83 2A 01 75 60 89 F0 8B 5C 24 10 8B 74 24 14 8B 7C 24 18 83 C4 1C C3 89 74 24 04 89 1C 24 E8 ?? ?? ?? ?? 89 C6 EB B6 F7 03 00 80 00 00 89 C6 75 20 8B 53 48 83 6A 04 01 75 17 C7 42 08 00 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 83 2A 01 75 1D 89 34 24 E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_12_0_0 {
	meta:
		name = "parse_printf_format"
		size = 249
		refs = "0023 __strchrnul 0050 __parse_one_specmb 00b2 __printf_arginfo_table"
	strings:
		$1 = { 55 57 56 53 83 EC 5C 8B 44 24 70 C7 44 24 04 25 00 00 00 8B 5C 24 74 C7 44 24 18 00 00 00 00 89 04 24 E8 ?? ?? ?? ?? 80 38 00 0F 84 C5 00 00 00 31 FF 8D 6C 24 18 8D 74 24 1C 8D B6 00 00 00 00 89 7C 24 04 89 6C 24 0C 89 74 24 08 89 04 24 E8 ?? ?? ?? ?? 01 C7 8B 44 24 3C 83 F8 FF 74 0F 39 D8 73 0B 8B 54 24 78 C7 04 82 00 00 00 00 8B 44 24 38 83 F8 FF 74 0F 39 C3 76 0B 8B 54 24 78 C7 04 82 00 00 00 00 8B 44 24 40 39 C3 76 3A 8B 4C 24 48 85 C9 74 32 83 F9 01 74 4D 8D 54 24 4C 89 54 24 0C 8B 54 24 78 89 34 24 8D 0C 82 89 DA 29 C2 A1 ?? ?? ?? ?? 89 4C 24 08 8B 4C 24 24 89 54 24 04 FF 14 88 8D 76 00 8B 44 24 34 80 38 00 0F 85 6B FF FF FF 8B 44 24 18 39 C7 0F 43 C7 83 C4 5C 5B 5E 5F 5D C3 66 90 8B 4C 24 44 8B 54 24 78 89 0C 82 EB D3 31 C0 EB E5 }
	condition:
		$1
}

rule file_13_0_0 {
	meta:
		name = "getwchar_unlocked"
		size = 43
		refs = "0004 _IO_stdin 0025 __wuflow"
	strings:
		$1 = { 83 EC 1C A1 ?? ?? ?? ?? 8B 50 58 85 D2 74 12 8B 0A 3B 4A 04 73 0B 8B 01 83 C1 04 89 0A 83 C4 1C C3 89 04 24 E8 ?? ?? ?? ?? EB F2 }
	condition:
		$1
}

rule file_14_0_0 {
	meta:
		name = "rename"
		size = 35
		refs = "0011 _dl_sysinfo 001e __syscall_error"
	strings:
		$1 = { 89 DA 8B 4C 24 08 8B 5C 24 04 B8 26 00 00 00 FF 15 ?? ?? ?? ?? 89 D3 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_15_0_0 {
	meta:
		name = "posix_spawn_file_actions_destroy"
		size = 24
		refs = "000e free"
	strings:
		$1 = { 83 EC 1C 8B 44 24 20 8B 40 08 89 04 24 E8 ?? ?? ?? ?? 31 C0 83 C4 1C C3 }
	condition:
		$1
}

rule file_16_0_0 {
	meta:
		name = "__mmap"
		size = 71
		refs = "0033 _dl_sysinfo 0042 __syscall_error"
	strings:
		$1 = { 55 53 56 57 8B 5C 24 14 8B 4C 24 18 8B 54 24 1C 8B 74 24 20 8B 7C 24 24 8B 6C 24 28 F7 C5 FF 0F 00 00 B8 EA FF FF FF 75 0E C1 ED 0C B8 C0 00 00 00 FF 15 ?? ?? ?? ?? 5F 5E 5B 5D 3D 00 F0 FF FF 0F 87 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_17_0_0 {
	meta:
		name = "__nl_langinfo_l"
		size = 90
	strings:
		$1 = { 53 8B 4C 24 08 89 CA C1 FA 10 83 FA 06 74 39 89 D0 C1 E8 1F 84 C0 75 30 83 FA 0C B8 ?? ?? ?? ?? 7F 1E 81 E1 FF FF 00 00 81 F9 FF FF 00 00 74 20 8B 5C 24 0C 8B 14 93 3B 4A 20 73 04 8B 44 8A 24 5B C3 8D B6 00 00 00 00 B8 ?? ?? ?? ?? 5B C3 90 8B 4C 24 0C 5B 8B 44 91 40 C3 }
	condition:
		$1
}

rule file_18_0_0 {
	meta:
		name = "strerror_l"
		size = 250
		refs = "0019 _sys_nerr_internal 0022 _sys_errlist_internal 0032 __uselocale 0045 _libc_intl_domainname 004c __dcgettext 006e last_value 0076 free 00cd __asprintf"
	strings:
		$1 = { 83 EC 1C 89 5C 24 10 8B 5C 24 20 89 74 24 14 89 7C 24 18 85 DB 78 55 3B 1D ?? ?? ?? ?? 7D 4D 8B 34 9D ?? ?? ?? ?? 85 F6 74 42 8B 44 24 24 89 04 24 E8 ?? ?? ?? ?? C7 44 24 08 05 00 00 00 89 74 24 04 C7 04 24 ?? ?? ?? ?? 89 C7 E8 ?? ?? ?? ?? 89 3C 24 89 C3 E8 ?? ?? ?? ?? 89 D8 8B 74 24 14 8B 5C 24 10 8B 7C 24 18 83 C4 1C C3 65 A1 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 8B 44 24 24 89 04 24 E8 ?? ?? ?? ?? C7 44 24 08 05 00 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? 89 C7 E8 ?? ?? ?? ?? 89 3C 24 89 C6 E8 ?? ?? ?? ?? 65 A1 00 00 00 00 89 5C 24 0C 89 74 24 08 C7 44 24 04 ?? ?? ?? ?? 05 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 83 F8 FF 74 12 65 8B 1D ?? ?? ?? ?? E9 78 FF FF FF 8D B6 00 00 00 00 65 C7 05 ?? ?? ?? ?? 00 00 00 00 31 DB E9 60 FF FF FF }
	condition:
		$1
}

rule file_18_1_0 {
	meta:
		name = "strerror_thread_freeres"
		size = 21
		refs = "0005 last_value 000d free"
	strings:
		$1 = { 83 EC 1C 65 A1 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 83 C4 1C C3 }
	condition:
		$1
}

rule file_19_0_0 {
	meta:
		name = "__scanf"
		size = 44
		refs = "001c stdin 0024 _IO_vfscanf"
	strings:
		$1 = { 83 EC 1C 8D 44 24 24 89 44 24 08 8B 44 24 20 C7 44 24 0C 00 00 00 00 89 44 24 04 A1 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 83 C4 1C C3 }
	condition:
		$1
}

rule file_932_0_0 {
	meta:
		name = "__wscanf"
		size = 44
		refs = "001c stdin 0024 _IO_vfwscanf"
	strings:
		$1 = { 83 EC 1C 8D 44 24 24 89 44 24 08 8B 44 24 20 C7 44 24 0C 00 00 00 00 89 44 24 04 A1 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 83 C4 1C C3 }
	condition:
		$1
}

rule file_20_0_0 {
	meta:
		name = "fstatvfs"
		size = 159
		refs = "002e __fstatfs 004a __fxstat64 0071 __internal_statvfs"
	strings:
		$1 = { 81 EC BC 00 00 00 89 B4 24 B4 00 00 00 8B B4 24 C0 00 00 00 89 9C 24 B0 00 00 00 8D 5C 24 10 89 5C 24 04 89 BC 24 B8 00 00 00 89 34 24 E8 ?? ?? ?? ?? 85 C0 78 62 8D 7C 24 50 89 7C 24 08 89 74 24 04 C7 04 24 03 00 00 00 E8 ?? ?? ?? ?? 31 D2 89 5C 24 08 C7 04 24 00 00 00 00 83 F8 FF 8B 84 24 C4 00 00 00 0F 45 D7 89 54 24 0C 89 44 24 04 E8 ?? ?? ?? ?? 31 C0 8B 9C 24 B0 00 00 00 8B B4 24 B4 00 00 00 8B BC 24 B8 00 00 00 81 C4 BC 00 00 00 C3 90 8D 74 26 00 B8 FF FF FF FF EB D8 }
	condition:
		$1
}

rule file_21_0_0 {
	meta:
		name = "syscall"
		size = 54
		refs = "0022 _dl_sysinfo 0031 __syscall_error"
	strings:
		$1 = { 55 57 56 53 8B 6C 24 2C 8B 7C 24 28 8B 74 24 24 8B 54 24 20 8B 4C 24 1C 8B 5C 24 18 8B 44 24 14 FF 15 ?? ?? ?? ?? 5B 5E 5F 5D 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_22_0_0 {
	meta:
		name = "__strverscmp"
		size = 325
	strings:
		$1 = { 55 57 56 53 83 EC 08 8B 4C 24 1C 8B 5C 24 20 39 D9 0F 84 11 01 00 00 0F B6 11 83 C1 01 83 C3 01 0F B6 43 FF 89 0C 24 31 C9 80 FA 30 88 44 24 07 0F B6 C2 0F 94 C1 8D 70 D0 89 CF 31 C9 83 FE 09 0F 96 C1 89 CE 01 FE 0F B6 7C 24 07 29 F8 74 4D EB 5E 8D B6 00 00 00 00 8B 04 24 83 C3 01 0F B6 4B FF 0F B6 B6 ?? ?? ?? ?? 0F B6 10 83 C0 01 89 04 24 31 C0 88 4C 24 07 80 FA 30 0F 94 C0 31 C9 89 C5 0F B6 C2 8D 78 D0 83 FF 09 0F 96 C1 89 CF 01 EF 0F B6 6C 24 07 01 FE 29 E8 75 13 84 D2 75 B7 83 C4 08 5B 5E 5F 5D C3 8D B4 26 00 00 00 00 31 D2 80 7C 24 07 30 8D B4 76 ?? ?? ?? ?? 0F 94 C2 89 D7 0F B6 54 24 07 83 EA 30 83 FA 09 0F 96 C2 01 FE 0F B6 D2 0F B6 14 16 80 FA 02 74 C2 80 FA 03 8B 0C 24 74 11 83 C4 08 0F BE C2 5B 5E 5F 5D C3 8D B6 00 00 00 00 0F B6 11 83 C1 01 83 EA 30 83 FA 09 0F B6 13 77 29 83 EA 30 83 C3 01 83 FA 09 76 E4 83 C4 08 B8 01 00 00 00 5B 5E 5F 5D C3 8D B4 26 00 00 00 00 83 C4 08 31 C0 5B 5E 5F 5D C3 83 EA 30 83 FA 09 BA FF FF FF FF 0F 46 C2 E9 5C FF FF FF }
	condition:
		$1
}

rule file_23_2_0 {
	meta:
		name = "getnetent"
		size = 132
		refs = "0020 __libc_h_errno 0052 __getnetent_r 0057 __nss_getent 005d __libc_errno"
	strings:
		$1 = { 53 31 C0 83 EC 28 B9 01 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 0D ?? ?? ?? ?? 75 65 A1 ?? ?? ?? ?? 65 03 05 00 00 00 00 C7 44 24 10 ?? ?? ?? ?? C7 44 24 0C 00 04 00 00 89 44 24 14 C7 44 24 08 ?? ?? ?? ?? C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 65 8B 1A 89 C1 65 83 3D 0C 00 00 00 00 74 01 F0 83 2D ?? ?? ?? ?? 01 75 17 65 89 1A 83 C4 28 89 C8 5B C3 }
	condition:
		$1
}

rule file_310_2_0 {
	meta:
		name = "gethostent"
		size = 132
		refs = "0020 __libc_h_errno 0052 __gethostent_r 0057 __nss_getent 005d __libc_errno"
	strings:
		$1 = { 53 31 C0 83 EC 28 B9 01 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 0D ?? ?? ?? ?? 75 65 A1 ?? ?? ?? ?? 65 03 05 00 00 00 00 C7 44 24 10 ?? ?? ?? ?? C7 44 24 0C 00 04 00 00 89 44 24 14 C7 44 24 08 ?? ?? ?? ?? C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 65 8B 1A 89 C1 65 83 3D 0C 00 00 00 00 74 01 F0 83 2D ?? ?? ?? ?? 01 75 17 65 89 1A 83 C4 28 89 C8 5B C3 }
	condition:
		$1
}

rule file_24_0_0 {
	meta:
		name = "__dup2"
		size = 35
		refs = "0011 _dl_sysinfo 001e __syscall_error"
	strings:
		$1 = { 89 DA 8B 4C 24 08 8B 5C 24 04 B8 3F 00 00 00 FF 15 ?? ?? ?? ?? 89 D3 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_25_0_0 {
	meta:
		name = "__wctrans"
		size = 114
		refs = "0008 _nl_current_LC_CTYPE 0037 __rawmemchr 004c strcmp"
	strings:
		$1 = { 55 57 56 53 83 EC 1C A1 ?? ?? ?? ?? 8B 7C 24 30 65 8B 00 8B 28 8B 5D 50 80 3B 00 74 4B 31 F6 EB 23 8D B4 26 00 00 00 00 89 1C 24 83 C6 01 C7 44 24 04 00 00 00 00 E8 ?? ?? ?? ?? 80 78 01 00 8D 58 01 74 24 89 5C 24 04 89 3C 24 E8 ?? ?? ?? ?? 85 C0 75 D4 03 75 6C 8B 44 B5 24 83 C4 1C 5B 5E 5F 5D C3 90 8D 74 26 00 83 C4 1C 31 C0 5B 5E 5F 5D C3 }
	condition:
		$1
}

rule file_26_0_0 {
	meta:
		name = "critical_factorization"
		size = 416
		refs = "000f __libc_tsd_CTYPE_TOLOWER"
	strings:
		$1 = { 55 57 56 53 31 DB 83 EC 1C 89 54 24 04 8B 15 ?? ?? ?? ?? 89 4C 24 18 B9 01 00 00 00 C7 44 24 10 01 00 00 00 C7 44 24 08 FF FF FF FF 65 8B 32 89 44 24 0C 90 8D 74 26 00 8D 14 19 8B 44 24 0C 3B 54 24 04 73 39 8B 7C 24 08 0F B6 2C 10 01 C7 0F B6 3C 0F 0F B6 04 BE 38 04 AE 0F 83 C0 00 00 00 89 D1 89 D3 8B 44 24 0C 2B 4C 24 08 89 4C 24 10 B9 01 00 00 00 8D 14 19 3B 54 24 04 72 C7 8B 4C 24 18 31 DB 8B 54 24 10 C7 44 24 14 01 00 00 00 C7 44 24 0C FF FF FF FF 89 04 24 89 11 8B 0D ?? ?? ?? ?? 65 8B 31 B9 01 00 00 00 90 8D 74 26 00 8D 14 19 39 54 24 04 76 34 8B 04 24 8B 7C 24 0C 0F B6 2C 10 01 C7 0F B6 3C 0F 0F B6 04 BE 38 04 AE 76 6D 89 D1 89 D3 2B 4C 24 0C 89 4C 24 14 B9 01 00 00 00 8D 14 19 39 54 24 04 77 CC 8B 44 24 0C 8B 54 24 08 83 C0 01 83 C2 01 39 D0 73 0A 8B 44 24 10 89 44 24 14 89 D0 8B 54 24 14 8B 4C 24 18 89 11 83 C4 1C 5B 5E 5F 5D C3 90 8D 74 26 00 74 3E 89 5C 24 08 B9 01 00 00 00 83 C3 01 C7 44 24 10 01 00 00 00 E9 FD FE FF FF 90 8D 74 26 00 74 2E 89 5C 24 0C B9 01 00 00 00 83 C3 01 C7 44 24 14 01 00 00 00 E9 55 FF FF FF 90 8D 74 26 00 3B 4C 24 10 74 1A 83 C1 01 E9 CA FE FF FF 66 90 3B 4C 24 14 74 1A 83 C1 01 E9 32 FF FF FF 66 90 89 4C 24 10 89 D3 B9 01 00 00 00 E9 A8 FE FF FF 89 4C 24 14 89 D3 B9 01 00 00 00 E9 10 FF FF FF }
	condition:
		$1
}

rule file_26_1_0 {
	meta:
		name = "two_way_long_needle"
		size = 1130
		refs = "0053 __libc_tsd_CTYPE_TOLOWER 00a6 __strncasecmp 014b memchr"
	strings:
		$1 = { 55 57 56 53 89 D3 81 EC 6C 04 00 00 8B B4 24 80 04 00 00 89 4C 24 44 8D 4C 24 5C 89 44 24 2C 8B 44 24 44 89 F2 E8 36 FE FF FF 8D 94 24 60 04 00 00 89 44 24 34 8D 44 24 60 8D B4 26 00 00 00 00 89 30 83 C0 04 39 D0 75 F7 85 F6 0F 84 01 04 00 00 8B 0D ?? ?? ?? ?? 8D 56 FF 8B 44 24 44 65 8B 39 89 C5 89 4C 24 20 01 F5 8D B4 26 00 00 00 00 0F B6 08 83 C0 01 8B 0C 8F 89 54 8C 60 83 EA 01 39 E8 75 EC 8B 44 24 34 8B 7C 24 5C 8B 4C 24 44 89 44 24 08 8B 44 24 44 89 7C 24 48 89 0C 24 01 F8 89 44 24 04 E8 ?? ?? ?? ?? 85 C0 0F 85 F1 01 00 00 8B 7C 24 20 8D 56 FF 8B 4C 24 34 8B 44 24 34 C7 44 24 4C 01 00 00 00 65 8B 2F 8B 7C 24 44 83 E9 01 C7 44 24 30 00 00 00 00 C7 44 24 28 00 00 00 00 89 54 24 20 01 CF 89 4C 24 38 89 7C 24 3C 29 44 24 4C 89 74 24 40 EB 2C 90 8D 74 26 00 8B 54 24 30 85 D2 74 0F 8B 54 24 40 2B 54 24 48 39 44 24 48 0F 47 C2 01 44 24 28 C7 44 24 30 00 00 00 00 8B 5C 24 24 8B 74 24 28 03 74 24 40 C7 44 24 04 00 00 00 00 89 F0 29 D8 03 5C 24 2C 89 44 24 08 89 74 24 24 89 1C 24 E8 ?? ?? ?? ?? 85 C0 0F 85 1E 01 00 00 85 F6 0F 84 18 01 00 00 8B 4C 24 2C 8B 54 24 24 0F B6 44 11 FF 8B 44 85 00 8B 44 84 60 85 C0 75 88 8B 44 24 34 8B 7C 24 44 8B 54 24 28 39 44 24 30 89 C6 0F 43 74 24 30 01 F2 01 F7 03 54 24 2C 3B 74 24 20 73 48 0F B6 02 0F B6 0F 8B 5C 85 00 39 5C 8D 00 0F 85 D1 00 00 00 8D 46 01 F7 DE 01 F7 01 D6 89 74 24 1C EB 1F 8B 74 24 1C 8D 58 01 0F B6 0C 07 0F B6 14 06 8B 74 95 00 39 74 8D 00 0F 85 AB 00 00 00 89 D8 39 44 24 20 75 DB 8B 44 24 34 8B 5C 24 28 03 5C 24 38 03 5C 24 2C 39 44 24 30 89 C6 73 52 8B 7C 24 3C 0F B6 03 0F B6 17 8B 4C 85 00 39 4C 95 00 0F 85 4C 02 00 00 8B 7C 24 4C 31 C0 03 7C 24 30 89 7C 24 1C EB 1E 8D 76 00 8B 7C 24 3C 0F B6 54 03 FF 0F B6 4C 07 FF 83 E8 01 8B 7C 95 00 39 7C 8D 00 75 0C 8B 74 24 38 01 C6 3B 44 24 1C 75 D9 8B 44 24 30 83 C0 01 39 F0 0F 87 BD 01 00 00 8B 54 24 48 8B 4C 24 40 01 54 24 28 29 D1 89 4C 24 30 E9 AE FE FF FF 31 C0 81 C4 6C 04 00 00 5B 5E 5F 5D C3 89 F0 8D 74 26 00 8B 54 24 4C 03 54 24 28 C7 44 24 30 00 00 00 00 01 C2 89 54 24 28 E9 80 FE FF FF 89 F0 8B 4C 24 44 2B 44 24 34 3B 44 24 34 0F 42 44 24 34 03 4C 24 34 8B 54 24 20 83 C0 01 89 44 24 48 89 44 24 5C 8B 44 24 34 89 4C 24 3C 8B 4C 24 44 65 8B 3A 8B 54 24 3C 83 E8 01 01 C1 89 44 24 38 8B 44 24 34 C7 44 24 28 00 00 00 00 89 4C 24 44 89 74 24 30 F7 D8 01 C2 89 44 24 40 89 54 24 24 EB 09 90 01 44 24 28 8B 5C 24 20 8B 74 24 28 03 74 24 30 C7 44 24 04 00 00 00 00 89 F0 29 D8 03 5C 24 2C 89 44 24 08 89 74 24 20 89 1C 24 E8 ?? ?? ?? ?? 85 C0 0F 85 35 FF FF FF 85 F6 0F 84 2F FF FF FF 8B 5C 24 2C 8B 4C 24 20 0F B6 44 0B FF 8B 04 87 8B 44 84 60 85 C0 75 A8 8B 74 24 30 8B 6C 24 28 03 6C 24 34 03 6C 24 2C 83 EE 01 39 74 24 34 73 4F 8B 4C 24 3C 0F B6 45 00 0F B6 11 8B 1C 87 8B 44 24 34 39 1C 97 0F 85 9C 00 00 00 83 C0 01 03 6C 24 40 89 74 24 4C EB 21 8D B4 26 00 00 00 00 8B 74 24 24 8D 58 01 0F B6 54 05 00 0F B6 0C 06 8B 34 97 39 34 8F 75 70 89 D8 3B 44 24 4C 75 E0 8B 74 24 28 03 74 24 38 03 74 24 2C 83 7C 24 38 FF 74 40 8B 4C 24 44 0F B6 06 0F B6 11 8B 1C 87 39 1C 97 75 58 BB 01 00 00 00 31 C0 2B 5C 24 34 89 CD 89 5C 24 4C EB 15 0F B6 54 06 FF 0F B6 4C 05 FF 83 E8 01 8B 1C 97 39 1C 8F 75 30 3B 44 24 4C 75 E5 8B 44 24 2C 03 44 24 28 81 C4 6C 04 00 00 5B 5E 5F 5D C3 66 90 8B 54 24 28 2B 54 24 34 8D 54 10 01 89 54 24 28 E9 C7 FE FF FF 8B 54 24 48 01 54 24 28 E9 BA FE FF FF 8B 15 ?? ?? ?? ?? 89 54 24 20 E9 23 FC FF FF 8B 74 24 34 E9 E5 FD FF FF }
	condition:
		$1
}

rule file_26_2_0 {
	meta:
		name = "__strcasestr"
		size = 1305
		refs = "002d __libc_tsd_CTYPE_TOLOWER 0104 __strncasecmp 0224 memchr"
	strings:
		$1 = { 55 57 56 53 83 EC 6C 8B 84 24 80 00 00 00 8B 8C 24 84 00 00 00 0F B6 10 84 D2 0F 84 D3 04 00 00 0F B6 19 84 DB 0F 84 86 00 00 00 8B 0D ?? ?? ?? ?? 89 C6 BF 01 00 00 00 89 44 24 18 65 8B 29 8B 8C 24 84 00 00 00 EB 07 0F B6 19 84 DB 74 71 8B 44 9D 00 39 44 95 00 0F 94 C2 83 C6 01 21 D7 0F B6 16 83 C1 01 84 D2 75 DF 8B 44 24 18 80 39 00 0F 85 32 01 00 00 89 FA 84 D2 75 35 2B 8C 24 84 00 00 00 83 C0 01 89 44 24 34 89 CD 83 ED 01 83 F9 1F 89 4C 24 18 76 30 8B 5C 24 18 89 EA 8B 8C 24 84 00 00 00 8B 44 24 34 89 1C 24 E8 DF FA FF FF 83 C4 6C 5B 5E 5F 5D C3 8D B4 26 00 00 00 00 8B 44 24 18 EB B0 66 90 8B 54 24 18 8D 4C 24 5C 8B 84 24 84 00 00 00 E8 14 F9 FF FF 8B 4C 24 5C 89 4C 24 3C 89 44 24 30 89 44 24 08 8B 84 24 84 00 00 00 01 C8 8B 8C 24 84 00 00 00 89 44 24 04 89 0C 24 E8 ?? ?? ?? ?? 85 C0 0F 84 A2 00 00 00 8B 54 24 30 A1 ?? ?? ?? ?? 8B 8C 24 84 00 00 00 8B 7C 24 34 03 7C 24 30 8B 9C 24 84 00 00 00 89 6C 24 28 89 7C 24 40 65 8B 38 0F B6 04 11 8B 4C 24 40 0F B6 04 87 88 44 24 24 8B 44 24 18 29 D0 39 D0 0F 42 C2 83 C2 01 83 C0 01 01 D3 89 44 24 5C 89 44 24 4C 8B 44 24 30 89 54 24 2C 8B 54 24 30 89 5C 24 44 83 E8 01 89 44 24 3C 0F B6 01 F7 DA 01 D3 89 54 24 48 8D 51 01 89 5C 24 1C 0F B6 04 87 38 44 24 24 0F 84 25 02 00 00 8D 74 26 00 84 C0 0F 85 03 02 00 00 31 C0 83 C4 6C 5B 5E 5F 5D C3 8B 5C 24 30 A1 ?? ?? ?? ?? 8B 8C 24 84 00 00 00 C7 44 24 38 01 00 00 00 83 EB 01 65 8B 30 01 D9 8B 44 24 30 89 5C 24 1C 8B 5C 24 18 2B 5C 24 3C 29 44 24 38 C7 44 24 28 00 00 00 00 C7 44 24 24 00 00 00 00 89 4C 24 20 89 5C 24 40 66 90 8B 5C 24 24 03 5C 24 18 C7 44 24 04 00 00 00 00 89 D8 29 E8 03 6C 24 34 89 44 24 08 89 5C 24 2C 89 2C 24 E8 ?? ?? ?? ?? 85 C0 0F 85 78 FF FF FF 85 DB 0F 84 79 FE FF FF 8B 44 24 30 8B AC 24 84 00 00 00 8B 54 24 24 39 44 24 28 89 C7 0F 43 7C 24 28 01 FA 01 FD 03 54 24 34 39 7C 24 18 76 4C 0F B6 02 0F B6 4D 00 8B 1C 86 39 1C 8E 0F 85 3D 02 00 00 8D 47 01 F7 DF 01 FD 01 D7 89 7C 24 44 EB 24 8D B6 00 00 00 00 8B 7C 24 44 8D 58 01 0F B6 4C 05 00 0F B6 14 07 8B 3C 96 39 3C 8E 0F 85 14 02 00 00 89 D8 39 44 24 18 75 DC 8B 5C 24 24 8B 6C 24 28 03 5C 24 1C 03 5C 24 34 39 6C 24 30 0F 86 24 02 00 00 8B 4C 24 20 0F B6 03 0F B6 11 8B 3C 86 39 3C 96 0F 85 0E 02 00 00 8B 6C 24 38 31 C0 03 6C 24 28 89 6C 24 44 EB 1D 8D 74 26 00 8B 6C 24 20 0F B6 54 03 FF 0F B6 4C 05 FF 83 E8 01 8B 2C 96 39 2C 8E 75 0C 8B 7C 24 1C 01 C7 3B 44 24 44 75 DB 8B 44 24 28 83 C0 01 39 F8 0F 87 D9 01 00 00 8B 54 24 3C 8B 4C 24 40 01 54 24 24 89 4C 24 28 8B 6C 24 2C E9 C3 FE FF FF 8D 76 00 0F B6 6C 24 20 89 EA 84 D2 0F 84 59 FE FF FF 39 44 24 18 0F 86 DE 00 00 00 8B 54 24 38 2B 54 24 30 8D 74 10 01 8B 5C 24 18 C7 44 24 04 00 00 00 00 01 F3 89 D8 2B 44 24 28 89 44 24 08 8B 44 24 34 03 44 24 28 89 04 24 E8 ?? ?? ?? ?? 85 C0 0F 85 13 FE FF FF 85 DB 0F 84 0B FE FF FF 8B 54 24 30 89 5C 24 28 01 F2 03 54 24 34 89 D1 0F B6 01 8D 51 01 0F B6 04 87 38 44 24 24 0F 85 DF FD FF FF 2B 54 24 40 8B 44 24 2C 83 EA 01 39 44 24 18 89 54 24 38 76 61 0F B6 51 01 8D 71 02 8B 6C 24 44 8B 14 97 0F B6 4D 00 89 D3 81 E2 FF 00 00 00 39 14 8F 0F 85 11 01 00 00 8B 44 24 30 03 74 24 48 83 C0 02 EB 2B 66 90 0F B6 54 06 FE 8D 58 01 8B 6C 24 1C 8B 14 97 0F B6 4C 05 FF 88 54 24 20 81 E2 FF 00 00 00 39 14 8F 0F 85 11 FF FF FF 89 D8 39 44 24 18 75 D1 8B 44 24 38 8B 5C 24 34 03 44 24 3C 8B B4 24 84 00 00 00 03 74 24 3C 01 C3 83 7C 24 3C FF 74 4C 0F B6 03 0F B6 16 8B 04 87 89 C5 25 FF 00 00 00 39 04 97 75 67 8B 44 24 30 C7 44 24 20 01 00 00 00 29 44 24 20 31 C0 EB 1D 0F B6 54 03 FF 0F B6 4C 06 FF 83 E8 01 8B 14 97 89 D5 81 E2 FF 00 00 00 39 14 8F 75 36 3B 44 24 20 75 DD 8B 44 24 34 03 44 24 38 E9 01 FC FF FF 89 F8 8D B6 00 00 00 00 8B 54 24 38 03 54 24 24 C7 44 24 28 00 00 00 00 01 C2 89 54 24 24 E9 61 FE FF FF 89 E9 84 C9 0F 84 CB FC FF FF 8B 74 24 38 03 74 24 4C E9 7B FE FF FF 8B 7C 24 30 E9 22 FE FF FF BF 01 00 00 00 E9 70 FB FF FF 8B 44 24 34 03 44 24 24 E9 A7 FB FF FF 84 DB 0F 85 47 FE FF FF 31 C0 E9 91 FC FF FF }
	condition:
		$1
}

rule file_27_1_0 {
	meta:
		name = "__libc_csu_init"
		size = 155
		refs = "000d __preinit_array_end 0019 __preinit_array_start 0054 _init 005e __init_array_end 0066 __init_array_start"
	strings:
		$1 = { 55 31 ED 57 56 53 83 EC 2C C7 44 24 1C ?? ?? ?? ?? 8B 5C 24 40 81 6C 24 1C ?? ?? ?? ?? C1 7C 24 1C 02 8B 54 24 1C 8B 74 24 44 8B 7C 24 48 85 D2 74 21 8D B6 00 00 00 00 89 7C 24 08 89 74 24 04 89 1C 24 FF 14 AD ?? ?? ?? ?? 83 C5 01 3B 6C 24 1C 75 E5 E8 ?? ?? ?? ?? 31 ED C7 44 24 1C ?? ?? ?? ?? 81 6C 24 1C ?? ?? ?? ?? C1 7C 24 1C 02 8B 44 24 1C 85 C0 74 1C 90 89 7C 24 08 89 74 24 04 89 1C 24 FF 14 AD ?? ?? ?? ?? 83 C5 01 3B 6C 24 1C 75 E5 83 C4 2C 5B 5E 5F 5D C3 }
	condition:
		$1
}

rule file_27_2_0 {
	meta:
		name = "__libc_csu_fini"
		size = 45
		refs = "0002 __fini_array_end 0008 __fini_array_start 0029 _fini"
	strings:
		$1 = { 53 BB ?? ?? ?? ?? 81 EB ?? ?? ?? ?? 83 EC 08 C1 FB 02 85 DB 74 0E 66 90 FF 14 9D ?? ?? ?? ?? 83 EB 01 75 F4 83 C4 08 5B E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_28_0_0 {
	meta:
		name = "xdr_rmtcallres"
		size = 108
		refs = "0013 xdr_u_long 002f xdr_reference"
	strings:
		$1 = { 56 53 83 EC 24 8B 5C 24 34 8B 74 24 30 8B 03 C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 04 00 00 00 89 34 24 89 44 24 1C 8D 44 24 1C 89 44 24 04 E8 ?? ?? ?? ?? 85 C0 75 09 83 C4 24 31 C0 5B 5E C3 90 8D 43 04 89 44 24 04 89 34 24 E8 ?? ?? ?? ?? 85 C0 74 E4 8B 44 24 1C 89 03 8B 43 08 89 34 24 89 44 24 04 FF 53 0C 83 C4 24 5B 5E C3 }
	condition:
		$1
}

rule file_28_1_0 {
	meta:
		name = "xdr_rmtcall_args"
		size = 261
		refs = "0023 xdr_u_long"
	strings:
		$1 = { 83 EC 4C 89 5C 24 3C 8B 5C 24 50 89 74 24 40 8B 74 24 54 89 7C 24 44 89 6C 24 48 89 1C 24 89 74 24 04 E8 ?? ?? ?? ?? 85 C0 75 1D 31 C0 8B 5C 24 3C 8B 74 24 40 8B 7C 24 44 8B 6C 24 48 83 C4 4C C3 8D B4 26 00 00 00 00 8D 46 04 89 44 24 04 89 1C 24 E8 ?? ?? ?? ?? 85 C0 74 D0 8D 46 08 89 44 24 04 89 1C 24 E8 ?? ?? ?? ?? 85 C0 74 BD 8B 43 04 C7 44 24 2C 00 00 00 00 89 1C 24 FF 50 10 89 1C 24 89 C7 8D 44 24 2C 89 44 24 04 E8 ?? ?? ?? ?? 85 C0 74 96 8B 43 04 89 1C 24 FF 50 10 89 C5 8B 46 10 89 1C 24 89 44 24 04 FF 56 14 85 C0 0F 84 76 FF FF FF 8B 43 04 83 C6 0C 89 1C 24 FF 50 10 89 44 24 1C 29 E8 89 06 8B 43 04 89 7C 24 04 89 1C 24 FF 50 14 89 74 24 04 89 1C 24 E8 ?? ?? ?? ?? 85 C0 0F 84 41 FF FF FF 8B 43 04 8B 54 24 1C 89 1C 24 89 54 24 04 FF 50 14 B8 01 00 00 00 E9 28 FF FF FF }
	condition:
		$1
}

rule file_28_2_0 {
	meta:
		name = "pmap_rmtcall"
		size = 267
		refs = "0046 clntudp_create 00d5 xdr_rmtcallres 00dd xdr_rmtcall_args"
	strings:
		$1 = { 56 53 83 EC 64 8B 15 ?? ?? ?? ?? 8B 5C 24 70 8D 44 24 34 C7 44 24 34 FF FF FF FF 66 C7 43 02 00 6F 89 44 24 14 A1 ?? ?? ?? ?? 89 54 24 10 C7 44 24 08 02 00 00 00 C7 44 24 04 A0 86 01 00 89 44 24 0C 89 1C 24 E8 ?? ?? ?? ?? 89 C6 B8 10 00 00 00 85 F6 0F 84 A6 00 00 00 8B 44 24 74 8B 94 24 90 00 00 00 8B 8C 24 94 00 00 00 89 44 24 48 8B 44 24 78 89 44 24 4C 8B 44 24 7C 89 44 24 50 8B 84 24 84 00 00 00 89 44 24 58 8B 84 24 80 00 00 00 89 44 24 5C 8B 84 24 98 00 00 00 89 44 24 38 8B 84 24 8C 00 00 00 89 44 24 40 8B 84 24 88 00 00 00 89 44 24 44 8B 46 04 89 54 24 18 8D 54 24 38 89 54 24 14 8D 54 24 48 89 4C 24 1C 89 54 24 0C C7 44 24 10 ?? ?? ?? ?? C7 44 24 08 ?? ?? ?? ?? C7 44 24 04 05 00 00 00 89 34 24 FF 10 8B 56 04 89 34 24 89 44 24 2C FF 52 10 8B 44 24 2C 66 C7 43 02 00 00 83 C4 64 5B 5E C3 }
	condition:
		$1
}

rule file_28_3_0 {
	meta:
		name = "clnt_broadcast"
		size = 1475
		refs = "000b authunix_create_default 0031 __socket 0063 __setsockopt 0082 getifaddrs 00e4 freeifaddrs 010f _create_xid 0218 xdrmem_create 022f xdr_callmsg 0253 _libc_intl_domainname 025d __dcgettext 0265 perror 026d __close 02b3 xdr_rmtcall_args 033d __sendto 038c _null_auth 03a3 xdr_rmtcallres 03dd __poll 042c __recvfrom 0439 __libc_errno 0502 xdr_replymsg 0538 xdr_void"
	strings:
		$1 = { 55 57 56 53 81 EC 0C 29 00 00 E8 ?? ?? ?? ?? C7 44 24 08 11 00 00 00 C7 44 24 04 02 00 00 00 C7 04 24 02 00 00 00 C7 44 24 34 01 00 00 00 89 C5 E8 ?? ?? ?? ?? 85 C0 89 C6 0F 88 49 02 00 00 8D 44 24 34 C7 44 24 10 04 00 00 00 89 44 24 0C C7 44 24 08 06 00 00 00 C7 44 24 04 01 00 00 00 89 34 24 E8 ?? ?? ?? ?? 85 C0 0F 88 D1 01 00 00 8D 44 24 3C 89 04 24 89 74 24 40 66 C7 44 24 44 01 00 E8 ?? ?? ?? ?? 85 C0 0F 85 D2 02 00 00 8B 5C 24 3C 85 DB 0F 84 DB 03 00 00 89 D8 31 FF EB 0B 83 FF 13 8B 00 7F 39 85 C0 74 35 8B 50 08 83 E2 03 83 FA 03 75 EA 8B 50 0C 85 D2 74 E3 66 83 3A 02 75 DD 8B 50 14 8B 00 8B 52 04 89 94 BC D8 00 00 00 83 C7 01 83 FF 13 7E CD 8D B6 00 00 00 00 89 1C 24 E8 ?? ?? ?? ?? C7 44 24 4C 00 00 00 00 C7 44 24 50 00 00 00 00 C7 44 24 54 00 00 00 00 66 C7 44 24 48 02 00 66 C7 44 24 4A 00 6F E8 ?? ?? ?? ?? 8B 94 24 38 29 00 00 C7 84 24 BC 00 00 00 05 00 00 00 C7 84 24 B8 00 00 00 02 00 00 00 C7 84 24 B4 00 00 00 A0 86 01 00 C7 84 24 B0 00 00 00 02 00 00 00 C7 84 24 AC 00 00 00 00 00 00 00 89 44 24 20 89 84 24 A8 00 00 00 8B 45 00 89 84 24 C0 00 00 00 8B 45 04 89 84 24 C4 00 00 00 8B 45 08 89 84 24 C8 00 00 00 8B 45 0C 89 84 24 CC 00 00 00 8B 45 10 89 84 24 D0 00 00 00 8B 45 14 89 84 24 D4 00 00 00 8B 84 24 20 29 00 00 89 84 24 90 00 00 00 8B 84 24 24 29 00 00 89 84 24 94 00 00 00 8B 84 24 28 29 00 00 89 84 24 98 00 00 00 8B 84 24 2C 29 00 00 89 84 24 A4 00 00 00 8B 84 24 30 29 00 00 89 84 24 A0 00 00 00 8D 44 24 38 89 44 24 68 8B 84 24 34 29 00 00 89 44 24 74 8D 84 24 28 01 00 00 89 54 24 70 8D 54 24 78 89 44 24 04 89 14 24 C7 44 24 0C 00 00 00 00 C7 44 24 08 78 05 00 00 E8 ?? ?? ?? ?? 8D 84 24 A8 00 00 00 8D 54 24 78 89 44 24 04 89 14 24 E8 ?? ?? ?? ?? 85 C0 75 69 BB 01 00 00 00 EB 2B 66 90 C7 44 24 08 05 00 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? BB 03 00 00 00 E8 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 89 34 24 E8 ?? ?? ?? ?? 8B 55 20 89 2C 24 FF 52 10 81 C4 0C 29 00 00 89 D8 5B 5E 5F 5D C3 90 C7 44 24 08 05 00 00 00 C7 44 24 04 ?? ?? ?? ?? EB B6 8D B6 00 00 00 00 8D 84 24 90 00 00 00 89 44 24 04 8D 44 24 78 89 04 24 E8 ?? ?? ?? ?? 85 C0 0F 84 78 FF FF FF 8B 44 24 7C 8D 54 24 78 89 14 24 FF 50 10 89 44 24 28 8B 44 24 7C 8B 40 1C 85 C0 74 09 8D 54 24 78 89 14 24 FF D0 C7 44 24 24 A0 0F 00 00 89 6C 24 2C 31 ED 85 FF 8B 5C 24 28 75 0C EB 7B 8D 76 00 83 C5 01 39 FD 74 71 8B 84 AC D8 00 00 00 8D 94 24 28 01 00 00 C7 44 24 14 10 00 00 00 C7 44 24 0C 00 00 00 00 89 5C 24 08 89 44 24 4C 8D 44 24 48 89 44 24 10 89 54 24 04 89 34 24 E8 ?? ?? ?? ?? 39 C3 74 BB 8B 6C 24 2C C7 44 24 08 05 00 00 00 C7 44 24 04 ?? ?? ?? ?? E9 F2 FE FF FF 66 90 C7 04 24 ?? ?? ?? ?? 31 FF E8 ?? ?? ?? ?? E9 75 FD FF FF 90 8D 74 26 00 8B 84 24 3C 29 00 00 85 C0 0F 84 F1 01 00 00 8D 6C 24 58 A1 ?? ?? ?? ?? 8B 54 24 24 C7 44 24 04 01 00 00 00 C7 84 24 C8 00 00 00 ?? ?? ?? ?? 89 84 24 B4 00 00 00 A1 ?? ?? ?? ?? 89 54 24 08 89 84 24 B8 00 00 00 A1 ?? ?? ?? ?? 89 84 24 BC 00 00 00 8D 44 24 68 89 84 24 C4 00 00 00 8D 44 24 40 89 04 24 E8 ?? ?? ?? ?? 83 F8 FF 0F 84 B6 00 00 00 85 C0 0F 84 8A 00 00 00 8D 9C 24 A0 06 00 00 8D B4 26 00 00 00 00 8D 54 24 30 89 54 24 14 89 6C 24 10 C7 44 24 0C 00 00 00 00 C7 44 24 08 60 22 00 00 89 5C 24 04 89 34 24 C7 44 24 30 10 00 00 00 E8 ?? ?? ?? ?? 85 C0 0F 89 90 00 00 00 A1 ?? ?? ?? ?? 65 83 38 04 74 BD 8B 6C 24 2C C7 44 24 08 05 00 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? BB 04 00 00 00 E8 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? E9 F4 FD FF FF 31 FF E9 64 FC FF FF 81 44 24 24 D0 07 00 00 81 7C 24 24 80 3E 00 00 0F 85 5F FE FF FF 8B 6C 24 2C BB 05 00 00 00 E9 C9 FD FF FF A1 ?? ?? ?? ?? 65 83 38 04 0F 84 DC FE FF FF 8B 6C 24 2C C7 44 24 08 05 00 00 00 C7 44 24 04 ?? ?? ?? ?? EB 92 8D 76 00 83 F8 03 0F 86 BA FE FF FF 89 44 24 08 8D 44 24 78 89 5C 24 04 31 DB 89 04 24 C7 44 24 0C 01 00 00 00 E8 ?? ?? ?? ?? 8D 94 24 A8 00 00 00 8D 44 24 78 89 54 24 04 89 04 24 E8 ?? ?? ?? ?? 85 C0 74 0D 8B 44 24 20 3B 84 24 A8 00 00 00 74 6C 8D 54 24 78 8D 84 24 A8 00 00 00 89 14 24 89 44 24 04 C7 44 24 78 02 00 00 00 C7 84 24 C8 00 00 00 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 84 24 38 29 00 00 8D 54 24 78 89 14 24 8B 94 24 34 29 00 00 89 44 24 04 FF D2 8B 44 24 7C 8B 40 1C 85 C0 74 09 8D 54 24 78 89 14 24 FF D0 85 DB 0F 84 13 FE FF FF 8B 6C 24 2C 31 DB E9 E6 FC FF FF 83 BC 24 B0 00 00 00 00 75 8A 83 BC 24 C0 00 00 00 00 75 80 8B 94 24 38 29 00 00 0F B7 44 24 38 89 6C 24 04 66 C1 C8 08 89 14 24 8B 94 24 3C 29 00 00 66 89 44 24 5A FF D2 89 C3 E9 54 FF FF FF }
	condition:
		$1
}

rule file_29_0_0 {
	meta:
		name = "compute_tzname_max"
		size = 59
		refs = "0026 __tzname_cur_max"
	strings:
		$1 = { 8B 15 ?? ?? ?? ?? 53 8D 0C 02 8D B6 00 00 00 00 80 3A 00 89 D0 74 1B 90 83 C0 01 80 38 00 75 F8 89 C3 29 D3 39 1D ?? ?? ?? ?? 73 06 89 1D ?? ?? ?? ?? 8D 50 01 39 CA 72 D7 5B C3 }
	condition:
		$1
}

rule file_29_1_0 {
	meta:
		name = "__tzfile_read"
		size = 3013
		refs = "0011 __use_tzfile 0034 __libc_enable_secure 0051 getenv 0080 strlen 00b5 mempcpy 00d3 memcpy 00ee __xstat64 0106 _IO_new_fopen 0118 fileno 012f __fxstat64 014a free 01a0 fread_unlocked 01c1 memcmp 02a0 malloc 05ed _IO_new_fclose 0617 __tzstring 062b __tzname 06e8 __daylight 06ed __timezone 0700 __uflow 075b strstr 099c fseek 09ac ftello 0b87 __assert_fail"
	strings:
		$1 = { 55 89 E5 57 56 53 81 EC DC 00 00 00 8B 5D 08 8B 35 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 00 00 00 00 85 DB 0F 84 29 08 00 00 0F B6 13 84 D2 0F 84 EE 06 00 00 8B 0D ?? ?? ?? ?? 85 C9 0F 85 00 07 00 00 80 FA 2F 0F 84 8E 00 00 00 C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 09 80 38 00 0F 85 66 07 00 00 BF 14 00 00 00 BA ?? ?? ?? ?? C7 85 3C FF FF FF 13 00 00 00 89 1C 24 89 95 28 FF FF FF E8 ?? ?? ?? ?? 8B 95 28 FF FF FF 8D 48 01 8D 44 39 1E 83 E0 F0 29 C4 8B 85 3C FF FF FF 8D 7C 24 1F 83 E7 F0 89 54 24 04 89 44 24 08 89 3C 24 89 8D 28 FF FF FF E8 ?? ?? ?? ?? C6 00 2F 8B 8D 28 FF FF FF 83 C0 01 89 5C 24 04 89 FB 89 04 24 89 4C 24 08 E8 ?? ?? ?? ?? 85 F6 74 1F 8D 45 88 89 44 24 08 89 5C 24 04 C7 04 24 03 00 00 00 E8 ?? ?? ?? ?? 85 C0 0F 84 76 06 00 00 89 1C 24 C7 44 24 04 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 89 C3 0F 84 0C 06 00 00 89 04 24 E8 ?? ?? ?? ?? 8D 55 88 89 54 24 08 C7 04 24 03 00 00 00 89 44 24 04 E8 ?? ?? ?? ?? 85 C0 0F 85 DD 05 00 00 A1 ?? ?? ?? ?? 8D B5 5C FF FF FF 89 04 24 E8 ?? ?? ?? ?? 8B 45 88 8B 55 8C C7 05 ?? ?? ?? ?? 00 00 00 00 A3 ?? ?? ?? ?? 8B 45 E0 89 15 ?? ?? ?? ?? 8B 55 E4 A3 ?? ?? ?? ?? 8B 45 D0 81 0B 00 80 00 00 89 5C 24 0C C7 44 24 08 01 00 00 00 C7 44 24 04 2C 00 00 00 89 34 24 89 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 F8 01 0F 85 6B 05 00 00 C7 44 24 08 04 00 00 00 C7 44 24 04 ?? ?? ?? ?? 89 34 24 E8 ?? ?? ?? ?? 85 C0 0F 85 4B 05 00 00 8B 4D 84 8B B5 7C FF FF FF 8B 55 80 8B 85 78 FF FF FF 0F C9 89 8D 3C FF FF FF 8B 8D 74 FF FF FF 0F CE 81 FE 32 33 33 33 0F CA 89 35 ?? ?? ?? ?? 0F C8 89 15 ?? ?? ?? ?? 0F C9 89 8D 38 FF FF FF 8B 8D 70 FF FF FF A3 ?? ?? ?? ?? 0F C9 89 8D 34 FF FF FF 0F 87 F2 04 00 00 8D 7C B6 03 83 E7 FC 89 F9 F7 D1 C1 E9 03 39 D1 0F 82 DC 04 00 00 C1 E2 03 89 95 30 FF FF FF 01 FA 89 D1 F7 D1 3B 8D 3C FF FF FF 0F 82 C1 04 00 00 03 95 3C FF FF FF 83 FA FC 0F 87 B2 04 00 00 8D 4A 03 83 E1 FC 89 CA F7 D2 C1 EA 03 39 C2 0F 82 9D 04 00 00 C1 E0 03 89 85 2C FF FF FF 01 C8 89 C2 F7 D2 3B 55 0C 0F 82 85 04 00 00 03 45 0C 89 8D 28 FF FF FF 89 04 24 E8 ?? ?? ?? ?? 8B 8D 28 FF FF FF 85 C0 A3 ?? ?? ?? ?? 0F 84 61 04 00 00 8D 14 B0 01 C1 89 15 ?? ?? ?? ?? 8D 14 38 89 15 ?? ?? ?? ?? 03 95 30 FF FF FF 89 0D ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 00 00 00 00 89 15 ?? ?? ?? ?? 8B 55 0C 85 D2 74 0B 8B 55 10 03 8D 2C FF FF FF 89 0A 89 5C 24 0C 89 74 24 08 C7 44 24 04 05 00 00 00 89 04 24 E8 ?? ?? ?? ?? 3B 05 ?? ?? ?? ?? 89 C7 0F 85 F9 03 00 00 85 C0 0F 84 E1 07 00 00 8B 0D ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? 0F B6 01 39 C6 0F 86 DA 03 00 00 8D 41 01 01 F9 EB 11 8D 76 00 0F B6 10 83 C0 01 39 D6 0F 86 C2 03 00 00 39 C8 75 EE 8B 15 ?? ?? ?? ?? 83 EF 01 90 8D 74 26 00 8B 04 BA 0F C8 89 04 BA 83 EF 01 83 FF FF 75 F0 8D 8D 54 FF FF FF 31 FF 8D B5 58 FF FF FF 89 8D 40 FF FF FF 89 B5 44 FF FF FF 8D B6 00 00 00 00 8B 53 04 8B 4B 08 8B B5 40 FF FF FF 39 D1 0F 86 39 07 00 00 0F B6 02 83 C2 01 89 53 04 88 06 83 C6 01 3B B5 44 FF FF FF 75 E2 39 CA 0F 83 83 07 00 00 0F B6 02 83 C2 01 89 53 04 83 F8 01 0F 87 3C 03 00 00 8B 15 ?? ?? ?? ?? 8D 34 FD 00 00 00 00 88 44 32 04 8B 53 04 3B 53 08 0F 83 47 07 00 00 0F B6 02 83 C2 01 89 53 04 3B 85 3C FF FF FF 0F 87 0A 03 00 00 03 35 ?? ?? ?? ?? 83 C7 01 39 3D ?? ?? ?? ?? 88 46 05 8B 85 54 FF FF FF 0F C8 89 06 0F 87 68 FF FF FF 8B B5 3C FF FF FF A1 ?? ?? ?? ?? 89 5C 24 0C C7 44 24 04 01 00 00 00 89 74 24 08 89 04 24 E8 ?? ?? ?? ?? 39 F0 89 85 30 FF FF FF 0F 85 B7 02 00 00 A1 ?? ?? ?? ?? 31 C9 8D B5 54 FF FF FF 89 B5 40 FF FF FF 8D BD 58 FF FF FF 85 C0 0F 84 93 00 00 00 8D B6 00 00 00 00 8B B5 40 FF FF FF 8B 53 04 3B 53 08 0F 83 5C 02 00 00 0F B6 02 83 C2 01 89 53 04 88 06 83 C6 01 39 FE 75 E2 8D 34 CD 00 00 00 00 8B 85 54 FF FF FF 8B 15 ?? ?? ?? ?? 89 B5 3C FF FF FF 8B B5 40 FF FF FF 0F C8 89 04 CA 8B 53 04 3B 53 08 0F 83 3E 06 00 00 0F B6 02 83 C2 01 89 53 04 88 06 83 C6 01 39 FE 75 E2 8B 85 54 FF FF FF 83 C1 01 8B 15 ?? ?? ?? ?? 8B B5 3C FF FF FF 39 0D ?? ?? ?? ?? 0F C8 89 44 32 04 0F 87 73 FF FF FF 8B 85 38 FF FF FF 31 F6 85 C0 74 2F 8B BD 38 FF FF FF 90 8B 53 04 3B 53 08 0F 83 7A 06 00 00 0F B6 02 83 C2 01 89 53 04 85 C0 A1 ?? ?? ?? ?? 0F 95 44 F0 06 83 C6 01 39 FE 75 D8 A1 ?? ?? ?? ?? 39 F0 76 13 8B 15 ?? ?? ?? ?? 90 C6 44 F2 06 00 83 C6 01 39 C6 75 F4 8B BD 34 FF FF FF 31 F6 85 FF 74 35 8B BD 34 FF FF FF 66 90 8B 53 04 3B 53 08 0F 83 0C 06 00 00 0F B6 02 83 C2 01 89 53 04 85 C0 A1 ?? ?? ?? ?? 0F 95 44 F0 07 83 C6 01 39 FE 75 D8 A1 ?? ?? ?? ?? 39 F0 76 13 8B 15 ?? ?? ?? ?? 90 C6 44 F2 07 00 83 C6 01 39 C6 75 F4 80 BD 60 FF FF FF 00 0F 85 15 03 00 00 A1 ?? ?? ?? ?? 85 C0 74 0F 80 38 00 75 0A C7 05 ?? ?? ?? ?? 00 00 00 00 89 1C 24 E8 ?? ?? ?? ?? 8B 1D ?? ?? ?? ?? 85 DB 74 28 31 DB 8D 76 00 A1 ?? ?? ?? ?? 0F B6 44 D8 05 83 C3 01 03 05 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 39 1D ?? ?? ?? ?? 77 DD 8B 1D ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 00 00 00 00 C7 05 ?? ?? ?? ?? 00 00 00 00 85 DB 0F 84 47 04 00 00 BE 01 00 00 00 EB 08 8D 74 26 00 85 DB 74 4B A1 ?? ?? ?? ?? 83 EB 01 0F B6 14 18 A1 ?? ?? ?? ?? 8D 04 D0 0F B6 78 04 8B 0C BD ?? ?? ?? ?? 85 C9 75 D9 0F B6 40 05 03 05 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 89 04 BD ?? ?? ?? ?? 89 F0 29 F8 8B 14 85 ?? ?? ?? ?? 85 D2 74 B1 A1 ?? ?? ?? ?? 85 C0 0F 84 E0 03 00 00 A1 ?? ?? ?? ?? 85 C0 0F 84 C4 03 00 00 8B 85 30 FF FF FF E8 FC F8 FF FF A1 ?? ?? ?? ?? 85 C0 0F 85 89 01 00 00 A1 ?? ?? ?? ?? 31 D2 8B 00 A3 ?? ?? ?? ?? A3 ?? ?? ?? ?? F7 D8 89 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? E9 BD 00 00 00 89 1C 24 89 8D 28 FF FF FF E8 ?? ?? ?? ?? 8B 8D 28 FF FF FF 83 F8 FF 0F 85 90 FD FF FF 90 8D 74 26 00 89 1C 24 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 00 00 00 00 8D 65 F4 5B 5E 5F 5D C3 90 80 FA 2F 0F 84 A7 00 00 00 C7 44 24 04 ?? ?? ?? ?? 89 1C 24 88 95 28 FF FF FF E8 ?? ?? ?? ?? 0F B6 95 28 FF FF FF 85 C0 75 B6 E9 D1 F8 FF FF 90 8B 45 E0 8B 55 E4 33 15 ?? ?? ?? ?? 33 05 ?? ?? ?? ?? 09 C2 0F 85 70 F9 FF FF 8B 45 88 8B 55 8C 33 15 ?? ?? ?? ?? 33 05 ?? ?? ?? ?? 09 C2 0F 85 56 F9 FF FF 8B 0D ?? ?? ?? ?? 39 4D D0 0F 85 47 F9 FF FF C7 05 ?? ?? ?? ?? 01 00 00 00 E9 75 FF FF FF 8D B6 00 00 00 00 89 04 24 89 85 28 FF FF FF E8 ?? ?? ?? ?? 8B 95 28 FF FF FF 89 C7 89 85 3C FF FF FF 83 C7 01 E9 8A F8 FF FF 8D 74 26 00 C7 44 24 08 0F 00 00 00 C7 44 24 04 ?? ?? ?? ?? 89 1C 24 88 95 28 FF FF FF E8 ?? ?? ?? ?? 0F B6 95 28 FF FF FF 85 C0 0F 84 2C FF FF FF C7 44 24 08 13 00 00 00 C7 44 24 04 ?? ?? ?? ?? 89 1C 24 E8 ?? ?? ?? ?? 0F B6 95 28 FF FF FF 85 C0 0F 84 05 FF FF FF E9 D7 FE FF FF 8D B4 26 00 00 00 00 BB ?? ?? ?? ?? E9 7D F8 FF FF C7 05 ?? ?? ?? ?? 00 00 00 00 8B 3D ?? ?? ?? ?? 31 D2 C7 05 ?? ?? ?? ?? 00 00 00 00 8B 35 ?? ?? ?? ?? 31 C9 C7 85 3C FF FF FF 00 00 00 00 C7 85 40 FF FF FF 00 00 00 00 EB 29 0F B6 5C 06 FF 8D 1C DF 80 7B 04 00 75 1F 8B 1B B1 01 89 9D 40 FF FF FF 85 CA 0F 85 FC 01 00 00 83 E8 01 0F 84 93 01 00 00 85 C9 74 D3 85 D2 75 1A 0F B6 5C 06 FF 8D 1C DF 80 7B 04 00 74 E1 8B 1B B2 01 89 9D 3C FF FF FF EB CD BA 01 00 00 00 EB C6 8D 85 5C FF FF FF 89 5C 24 0C C7 44 24 08 01 00 00 00 C7 44 24 04 2C 00 00 00 89 04 24 E8 ?? ?? ?? ?? 83 F8 01 0F 85 07 FE FF FF 8D 8D 5C FF FF FF C7 44 24 08 04 00 00 00 C7 44 24 04 ?? ?? ?? ?? 89 0C 24 E8 ?? ?? ?? ?? 85 C0 0F 85 E1 FD FF FF 8B 75 84 8B BD 74 FF FF FF 8B 8D 7C FF FF FF 8B 55 80 0F CE 89 B5 3C FF FF FF 8B B5 70 FF FF FF 8B 85 78 FF FF FF 0F CF 0F C9 8D 0C C9 0F CA 8D 14 52 0F CE 89 B5 40 FF FF FF 8B B5 3C FF FF FF 0F C8 8D 04 40 C7 44 24 08 01 00 00 00 89 1C 24 01 FE 03 B5 40 FF FF FF 01 F1 8D 14 51 8D 04 82 89 44 24 04 E8 ?? ?? ?? ?? 85 C0 0F 85 70 FD FF FF 89 1C 24 E8 ?? ?? ?? ?? 85 C0 0F 88 60 FD FF FF 8D 48 02 8B 55 B4 89 CF C1 FF 1F 39 7D B8 0F 8C 4C FD FF FF 0F 8E 88 01 00 00 89 D6 8B 53 04 29 C6 8D 46 1D 83 E0 F0 29 C4 8D 7C 24 1F 83 E7 F0 3B 53 08 0F 83 9A 01 00 00 0F B6 02 83 C2 01 89 53 04 83 F8 0A 0F 85 15 FD FF FF 8D 56 FE 89 54 24 08 89 5C 24 0C C7 44 24 04 01 00 00 00 89 3C 24 89 95 28 FF FF FF E8 ?? ?? ?? ?? 8B 95 28 FF FF FF 39 C2 0F 85 E6 FC FF FF C6 44 37 FE 00 89 3C 24 E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? E9 88 FB FF FF 8D B4 26 00 00 00 00 8B B5 40 FF FF FF 85 D2 8B 85 3C FF FF FF 89 35 ?? ?? ?? ?? A3 ?? ?? ?? ?? 75 68 8B 85 40 FF FF FF 31 D2 A3 ?? ?? ?? ?? E9 67 FC FF FF A1 ?? ?? ?? ?? A3 ?? ?? ?? ?? E9 2D FC FF FF 83 3D ?? ?? ?? ?? 01 0F 85 CE 00 00 00 A1 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? E9 FC FB FF FF 8B 85 40 FF FF FF 31 D2 8B 8D 3C FF FF FF A3 ?? ?? ?? ?? 39 C8 89 0D ?? ?? ?? ?? 0F 95 C2 E9 11 FC FF FF 31 D2 89 F0 3B B5 3C FF FF FF 0F 95 C2 E9 FF FB FF FF 89 1C 24 E8 ?? ?? ?? ?? 83 F8 FF 0F 84 22 FC FF FF 8B 53 04 8B 4B 08 E9 B4 F8 FF FF 8D B4 26 00 00 00 00 A1 ?? ?? ?? ?? 85 C0 0F 85 63 F8 FF FF E9 16 F9 FF FF 89 1C 24 89 8D 28 FF FF FF E8 ?? ?? ?? ?? 8B 8D 28 FF FF FF 83 F8 FF 0F 84 E1 FB FF FF E9 A9 F9 FF FF 8D 74 26 00 89 1C 24 E8 ?? ?? ?? ?? E9 B5 F8 FF FF 89 1C 24 E8 ?? ?? ?? ?? E9 79 F8 FF FF 39 CA 0F 82 B6 FB FF FF E9 6B FE FF FF C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 EA 01 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 1C 24 E8 ?? ?? ?? ?? E9 62 FE FF FF 89 1C 24 E8 ?? ?? ?? ?? 83 F8 FF 0F 84 6F FB FF FF E9 E7 F9 FF FF 89 1C 24 E8 ?? ?? ?? ?? 83 F8 FF 0F 85 7E F9 FF FF 90 E9 53 FB FF FF }
	condition:
		$1
}

rule file_29_2_0 {
	meta:
		name = "__tzfile_default"
		size = 442
		refs = "000f strlen 004b __tzfile_read 0051 __use_tzfile 0082 mempcpy 0096 memcpy 0180 __tzname 0187 __timezone"
	strings:
		$1 = { 55 57 56 53 83 EC 4C 8B 54 24 60 89 14 24 E8 ?? ?? ?? ?? 8B 5C 24 64 89 1C 24 83 C0 01 89 44 24 20 E8 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? 8D 58 01 8B 44 24 20 01 D8 89 44 24 24 8D 44 24 3C 89 44 24 08 8B 44 24 24 89 44 24 04 E8 ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? 85 F6 0F 84 3D 01 00 00 83 3D ?? ?? ?? ?? 01 0F 86 3E 01 00 00 8B 54 24 20 8B 44 24 3C 89 54 24 08 8B 54 24 60 89 04 24 89 54 24 04 E8 ?? ?? ?? ?? 89 5C 24 08 8B 5C 24 64 89 5C 24 04 89 04 24 E8 ?? ?? ?? ?? 8B 3D ?? ?? ?? ?? 8B 44 24 3C C7 05 ?? ?? ?? ?? 02 00 00 00 8B 1D ?? ?? ?? ?? 85 FF A3 ?? ?? ?? ?? 0F 84 85 00 00 00 8B 44 24 6C 31 F6 8B 54 24 68 2B 05 ?? ?? ?? ?? 2B 15 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 89 44 24 2C 8B 2D ?? ?? ?? ?? 31 C0 89 54 24 28 89 5C 24 1C EB 20 90 8D 74 26 00 80 7A 06 00 75 31 8B 5C 24 2C 01 5C 85 00 66 90 83 C0 01 0F B6 72 04 39 F8 74 2F 0F B6 14 01 8B 5C 24 1C 8D 14 D3 0F B6 5A 04 88 1C 01 80 7A 07 00 75 DD 85 F6 75 C9 8B 5C 24 28 01 5C 85 00 83 C0 01 39 F8 0F B6 72 04 75 D1 8B 5C 24 1C 8B 44 24 68 8B 54 24 6C C6 43 05 00 C6 43 04 00 89 03 A3 ?? ?? ?? ?? 0F B6 44 24 20 89 53 08 89 15 ?? ?? ?? ?? 8B 54 24 60 C6 43 0C 01 88 43 0D 8B 44 24 68 8B 5C 24 64 89 15 ?? ?? ?? ?? F7 D8 A3 ?? ?? ?? ?? 8B 44 24 24 89 1D ?? ?? ?? ?? E8 56 F2 FF FF 83 C4 4C 5B 5E 5F 5D C3 8D B6 00 00 00 00 C7 05 ?? ?? ?? ?? 00 00 00 00 83 C4 4C 5B 5E 5F 5D C3 }
	condition:
		$1
}

rule file_29_3_0 {
	meta:
		name = "__tzfile_compute"
		size = 1514
		refs = "001b __tzname 00ca __tzstring 017b __daylight 0181 __timezone 01bd strcmp 03ae __assert_fail 03c7 __tzset_parse_tz 03df __offtime 03f9 __tz_compute 043c strlen"
	strings:
		$1 = { 55 57 56 53 83 EC 2C 8B 5C 24 44 85 DB 0F 84 C2 01 00 00 8B 1D ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 00 00 00 00 C7 05 ?? ?? ?? ?? 00 00 00 00 85 DB 0F 84 2D 04 00 00 8B 3D ?? ?? ?? ?? 8B 74 24 40 39 37 0F 8F 1B 04 00 00 8D 6B FF 8B 04 AF 39 C6 0F 8D 5D 03 00 00 89 E9 89 C5 29 F5 BA EF 22 1A 88 89 E8 F7 EA 01 EA C1 FA 17 C1 FD 1F 29 EA 39 D3 0F 87 4A 02 00 00 31 C0 EB 08 8D B6 00 00 00 00 89 D0 8D 58 01 39 D9 76 10 8D 14 01 D1 EA 3B 34 97 7D ED 89 D1 39 D9 77 F0 8D 69 FF 89 CA A1 ?? ?? ?? ?? BF 01 00 00 00 0F B6 0C 28 A1 ?? ?? ?? ?? 8D 04 C8 0F B6 58 04 0F B6 40 05 03 05 ?? ?? ?? ?? 89 54 24 1C 89 04 24 E8 ?? ?? ?? ?? 8B 54 24 1C 8B 0D ?? ?? ?? ?? 89 04 9D ?? ?? ?? ?? 89 D3 8B 15 ?? ?? ?? ?? 3B 1D ?? ?? ?? ?? 72 14 EB 5F 8D B4 26 00 00 00 00 83 C3 01 39 1D ?? ?? ?? ?? 76 4D 0F B6 04 19 8D 04 C2 0F B6 70 04 0F B6 40 05 83 3C B5 ?? ?? ?? ?? 00 75 DC 03 05 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 89 04 B5 ?? ?? ?? ?? 89 F8 29 F0 8B 04 85 ?? ?? ?? ?? 85 C0 74 AC 8D 74 26 00 A1 ?? ?? ?? ?? 85 C0 0F 84 7E 04 00 00 0F B6 0C 29 8D 3C CA 8B 15 ?? ?? ?? ?? 31 C9 3B 15 ?? ?? ?? ?? 0F 95 C1 F7 DA 85 C0 89 0D ?? ?? ?? ?? 89 15 ?? ?? ?? ?? 0F 84 BD 01 00 00 8B 2D ?? ?? ?? ?? 85 ED 0F 84 CF 01 00 00 0F B6 47 04 8B 54 24 50 8B 1C 85 ?? ?? ?? ?? 89 42 20 89 5C 24 04 0F B6 47 05 03 05 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 85 C0 0F 85 EE 03 00 00 8B 54 24 50 8B 07 89 5A 28 89 42 24 8B 15 ?? ?? ?? ?? 8B 3D ?? ?? ?? ?? 8B 74 24 4C 8D 42 FF 8B 5C 24 48 8D 54 D7 F8 C7 03 00 00 00 00 C7 06 00 00 00 00 8B 74 24 40 EB 08 8D B6 00 00 00 00 89 C8 83 F8 FF 74 1A 89 D3 83 EA 08 39 33 8D 48 FF 7F ED 8B 53 04 8B 6C 24 48 89 55 00 3B 33 74 0F 83 C4 2C 5B 5E 5F 5D C3 8D B4 26 00 00 00 00 85 C0 8B 53 04 0F 84 C5 00 00 00 8D 2C CF 8B 5D 04 39 D3 89 5C 24 18 7D D8 8B 5C 24 4C 85 C0 C7 03 01 00 00 00 74 CA 8B 6D 00 83 C5 01 39 EE 75 C0 8B 5C 24 18 83 C3 01 39 D3 75 B5 8D 04 C7 BA 02 00 00 00 EB 2B 66 90 8B 70 F0 89 C3 83 C6 01 39 70 F8 0F 85 E6 00 00 00 8B 73 F4 83 C2 01 83 E8 08 83 C6 01 39 73 FC 0F 85 DC 00 00 00 83 E9 01 85 C9 89 D7 75 D1 8B 5C 24 4C 89 13 E9 6F FF FF FF 8D B6 00 00 00 00 89 D8 29 D0 8D 50 FF 3B 34 97 7D 5C 83 FA 09 76 0C 8D 48 F5 3B 34 8F 0F 8C 99 FD FF FF 8D 68 FE 3B 34 AF 8D 42 FF 0F 8D B2 FD FF FF 8D 74 26 00 89 C2 83 E8 01 3B 74 97 FC 89 C5 7C F3 E9 9C FD FF FF 8D B6 00 00 00 00 85 D2 0F 8E 33 FF FF FF 8B 74 24 4C C7 06 01 00 00 00 83 C4 2C 5B 5E 5F 5D C3 8D B6 00 00 00 00 83 C0 09 39 C3 76 09 3B 34 87 0F 8D 4A FD FF FF 83 C2 01 3B 34 97 7D F8 8D 6A FF E9 56 FD FF FF 83 3D ?? ?? ?? ?? 01 75 3D A1 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? E9 23 FE FF FF A1 ?? ?? ?? ?? A3 ?? ?? ?? ?? E9 22 FE FF FF 8B 74 24 4C 89 16 E9 A7 FE FF FF 8B 6C 24 4C 89 7D 00 E9 9B FE FF FF C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 15 03 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 85 C0 0F 84 F1 01 00 00 89 04 24 8D 5C 24 40 E8 ?? ?? ?? ?? 8B 54 24 50 C7 44 24 04 00 00 00 00 89 1C 24 89 54 24 08 E8 ?? ?? ?? ?? 85 C0 0F 84 BC 01 00 00 8B 54 24 50 B9 01 00 00 00 8B 44 24 40 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 8B 3D ?? ?? ?? ?? 8D 04 D7 3B 05 ?? ?? ?? ?? 0F 85 C9 FD FF FF 83 3D ?? ?? ?? ?? 02 0F 85 B3 00 00 00 89 04 24 E8 ?? ?? ?? ?? 8B 1D ?? ?? ?? ?? 89 1C 24 A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 44 03 01 89 04 24 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 8B 3D ?? ?? ?? ?? A3 ?? ?? ?? ?? E9 7F FD FF FF 8B 0D ?? ?? ?? ?? 31 F6 31 DB A1 ?? ?? ?? ?? 85 C9 0F 84 90 00 00 00 8B 15 ?? ?? ?? ?? 80 7A 04 00 89 D1 0F 84 0F 01 00 00 31 C0 31 DB EB 24 8D B4 26 00 00 00 00 8B 35 ?? ?? ?? ?? 83 C3 01 89 D0 39 DE 76 55 8D 0C DA 80 79 04 00 74 4C A1 ?? ?? ?? ?? 85 C0 75 DF 0F B6 41 05 03 05 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? EB C0 C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 B7 02 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 39 DE 74 38 8D 34 DD 00 00 00 00 89 D0 0F B6 44 30 05 03 05 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 85 D2 A3 ?? ?? ?? ?? 74 13 8B 3D ?? ?? ?? ?? 01 F7 E9 2C FC FF FF 31 F6 31 DB EB CB 8B 2D ?? ?? ?? ?? 39 EB 73 E3 8B 15 ?? ?? ?? ?? 8D 3C 32 80 7F 04 00 8D 54 DA 08 75 48 83 C3 01 39 DD 0F 86 FE FB FF FF 89 D1 83 C2 08 80 7A FC 00 74 EA 0F B6 41 05 03 05 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 8B 3D ?? ?? ?? ?? 01 F7 A3 ?? ?? ?? ?? A1 ?? ?? ?? ?? E9 CA FB FF FF 31 F6 31 DB E9 64 FF FF FF 89 F9 EB CA 8B 1D ?? ?? ?? ?? 8D 6B FF 89 DA E9 E7 FA FF FF C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 1C 03 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? A3 ?? ?? ?? ?? E9 73 FB FF FF }
	condition:
		$1
}

rule file_30_2_0 {
	meta:
		name = "fgetpwent"
		size = 368
		refs = "0017 _IO_new_fgetpos 004f __libc_errno 0065 _IO_new_fsetpos 00a0 __fgetpwent_r 00ca realloc 00e1 free 015c malloc"
	strings:
		$1 = { 55 57 56 53 83 EC 4C 8B 5C 24 60 8D 74 24 34 89 74 24 04 89 1C 24 E8 ?? ?? ?? ?? 85 C0 0F 85 1D 01 00 00 B9 01 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 0D ?? ?? ?? ?? 0F 85 30 01 00 00 A1 ?? ?? ?? ?? 85 C0 0F 84 FD 00 00 00 8B 3D ?? ?? ?? ?? EB 29 8D 76 00 89 74 24 04 89 1C 24 A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 0F 85 87 00 00 00 A1 ?? ?? ?? ?? 85 C0 0F 84 84 00 00 00 8D 54 24 30 89 54 24 10 8B 15 ?? ?? ?? ?? 89 44 24 08 C7 44 24 04 ?? ?? ?? ?? 89 1C 24 89 54 24 0C E8 ?? ?? ?? ?? 83 F8 22 0F 85 83 00 00 00 A1 ?? ?? ?? ?? 8B 2D ?? ?? ?? ?? 05 00 04 00 00 89 44 24 04 89 2C 24 A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 75 86 65 8B 17 89 2C 24 89 44 24 2C 89 54 24 28 E8 ?? ?? ?? ?? 8B 54 24 28 8B 44 24 2C 65 89 17 E9 63 FF FF FF 8D 76 00 C7 05 ?? ?? ?? ?? 00 00 00 00 C7 44 24 30 00 00 00 00 65 8B 17 65 83 3D 0C 00 00 00 00 74 01 F0 83 2D ?? ?? ?? ?? 01 75 5F 65 89 17 8B 44 24 30 83 C4 4C 5B 5E 5F 5D C3 A1 ?? ?? ?? ?? 85 C0 75 D1 EB C7 90 8D 74 26 00 83 C4 4C 31 C0 5B 5E 5F 5D C3 C7 04 24 00 04 00 00 C7 05 ?? ?? ?? ?? 00 04 00 00 E8 ?? ?? ?? ?? 8B 3D ?? ?? ?? ?? A3 ?? ?? ?? ?? E9 06 FF FF FF }
	condition:
		$1
}

rule file_31_0_0 {
	meta:
		name = "__getclktck"
		size = 16
		refs = "0001 _dl_clktck"
	strings:
		$1 = { A1 ?? ?? ?? ?? BA 64 00 00 00 85 C0 0F 44 C2 C3 }
	condition:
		$1
}

rule file_32_0_0 {
	meta:
		name = "__libc_pause"
		size = 72
		refs = "0011 _dl_sysinfo 0022 __libc_enable_asynccancel 0037 __libc_disable_asynccancel 001c __syscall_error"
		altNames = "pause"
	strings:
		$1 = { 65 83 3D 0C 00 00 00 00 75 17 B8 1D 00 00 00 FF 15 ?? ?? ?? ?? 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 E8 ?? ?? ?? ?? 89 C1 B8 1D 00 00 00 FF 15 ?? ?? ?? ?? 50 89 C8 E8 ?? ?? ?? ?? 58 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_4_0_3 {
	meta:
		name = "__libc_pause"
		size = 72
		refs = "0011 _dl_sysinfo 0022 __pthread_enable_asynccancel 0037 __pthread_disable_asynccancel 001c __syscall_error"
	strings:
		$1 = { 65 83 3D 0C 00 00 00 00 75 17 B8 1D 00 00 00 FF 15 ?? ?? ?? ?? 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 E8 ?? ?? ?? ?? 89 C1 B8 1D 00 00 00 FF 15 ?? ?? ?? ?? 50 89 C8 E8 ?? ?? ?? ?? 58 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_4_2_3 {
	meta:
		name = "pause"
		size = 72
		refs = "0011 _dl_sysinfo 0022 __pthread_enable_asynccancel 0037 __pthread_disable_asynccancel 001c __syscall_error"
	strings:
		$1 = { 65 83 3D 0C 00 00 00 00 75 17 B8 1D 00 00 00 FF 15 ?? ?? ?? ?? 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 E8 ?? ?? ?? ?? 89 C1 B8 1D 00 00 00 FF 15 ?? ?? ?? ?? 50 89 C8 E8 ?? ?? ?? ?? 58 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_32_1_0 {
	meta:
		name = "__pause_nocancel"
		size = 23
		refs = "0007 _dl_sysinfo 0012 __syscall_error"
	strings:
		$1 = { B8 1D 00 00 00 FF 15 ?? ?? ?? ?? 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_33_0_0 {
	meta:
		name = "getsubopt"
		size = 258
		refs = "0022 __strchrnul 003c memchr 006c strncmp"
	strings:
		$1 = { 55 57 56 53 83 EC 2C 8B 54 24 40 8B 32 80 3E 00 0F 84 E5 00 00 00 C7 44 24 04 2C 00 00 00 89 34 24 E8 ?? ?? ?? ?? C7 44 24 04 3D 00 00 00 89 34 24 89 44 24 18 29 F0 89 44 24 08 E8 ?? ?? ?? ?? 8B 54 24 44 8B 4C 24 18 8B 3A 85 C0 0F 45 C8 85 FF 89 4C 24 1C 74 31 89 CB 31 ED 29 F3 8D 76 00 89 5C 24 08 89 7C 24 04 89 34 24 E8 ?? ?? ?? ?? 85 C0 75 06 80 3C 1F 00 74 46 8B 54 24 44 83 C5 01 8B 3C AA 85 FF 75 D8 8B 4C 24 48 8B 44 24 18 89 31 80 38 00 75 19 8B 44 24 18 BD FF FF FF FF 8B 54 24 40 89 02 83 C4 2C 89 E8 5B 5E 5F 5D C3 C6 00 00 83 C0 01 89 44 24 18 EB DB 8D 74 26 00 8B 54 24 1C 8B 4C 24 18 83 C2 01 39 4C 24 1C 0F 45 C2 8B 54 24 48 89 02 80 39 00 74 0A C6 01 00 83 C1 01 89 4C 24 18 8B 44 24 18 8B 4C 24 40 89 01 83 C4 2C 89 E8 5B 5E 5F 5D C3 BD FF FF FF FF EB A4 }
	condition:
		$1
}

rule file_34_0_0 {
	meta:
		name = "day_of_the_week"
		size = 241
		refs = "0098 __mon_yday"
	strings:
		$1 = { 83 EC 18 31 D2 89 5C 24 08 89 C3 8B 40 14 83 7B 10 01 89 74 24 0C 89 7C 24 10 BF 1F 85 EB 51 0F 9E C2 8D 88 6C 07 00 00 29 D1 85 C9 8D 51 03 0F 49 D1 69 C0 6D 01 00 00 89 D6 C1 FE 02 89 6C 24 14 89 14 24 8D AC 06 59 9A FF FF 89 C8 F7 EF C1 F9 1F 89 D0 89 54 24 04 C1 F8 05 89 CA 29 C2 89 F0 01 D5 F7 EF 8B 04 24 8B 7C 24 10 C1 F8 1F C1 FA 03 29 C2 8D 04 92 8D 04 80 29 C6 8B 44 24 04 C1 EE 1F 01 F5 BE 93 24 49 92 C1 F8 07 29 C8 01 C5 8B 43 10 0F B7 94 00 ?? ?? ?? ?? 01 D5 03 6B 0C 83 ED 01 89 E8 F7 EE 89 E8 C1 F8 1F 8D 0C 2A C1 F9 02 29 C1 8D 04 CD 00 00 00 00 29 C8 29 C5 8D 4D 07 8B 6C 24 14 89 C8 F7 EE 89 C8 8B 74 24 0C C1 F8 1F 01 CA C1 FA 02 29 C2 8D 04 D5 00 00 00 00 29 D0 29 C1 89 4B 18 8B 5C 24 08 83 C4 18 C3 }
	condition:
		$1
}

rule file_34_1_0 {
	meta:
		name = "__strptime_internal"
		size = 11935
		refs = "02c3 _nl_C_LC_TIME 02e4 __strptime_internal 0430 _nl_select_era_entry 07a5 strlen 07c1 __strncasecmp_l 07ec strcmp 132e __localtime_r 1bb3 __mon_yday 20c9 _nl_parse_alt_digit 2c6c __assert_fail"
	strings:
		$1 = { 55 89 CD 57 89 D7 56 53 81 EC 9C 00 00 00 8B B4 24 B4 00 00 00 89 44 24 4C 8B 84 24 B0 00 00 00 8B 56 08 85 C0 89 54 24 30 0F 84 6B 03 00 00 8B 9C 24 B0 00 00 00 8B 03 8B 53 04 8D 5C 24 64 89 5C 24 28 89 44 24 5C 8B 01 89 54 24 60 89 44 24 64 8B 41 04 89 44 24 68 8B 41 08 89 44 24 6C 8B 41 0C 89 44 24 70 8B 41 10 89 44 24 74 8B 41 14 89 44 24 78 8B 41 18 89 44 24 7C 8B 41 1C 89 84 24 80 00 00 00 8B 41 20 89 84 24 84 00 00 00 8B 41 24 89 84 24 88 00 00 00 8B 41 28 89 84 24 8C 00 00 00 89 E8 89 FD 89 C7 0F B6 45 00 84 C0 74 45 8B 56 34 0F BE C8 F6 44 4A 01 20 0F 84 C6 00 00 00 8B 44 24 4C 0F BE 08 F6 44 4A 01 20 74 1B 83 C0 01 90 8D 74 26 00 89 C1 89 44 24 4C 0F BE 09 83 C0 01 F6 44 4A 01 20 75 ED 83 C5 01 0F B6 45 00 84 C0 75 BB 8B 84 24 B0 00 00 00 89 FD 85 C0 0F 84 AF 17 00 00 8B BC 24 B0 00 00 00 8B 44 24 5C 8B 54 24 60 89 07 8B 44 24 64 89 57 04 89 45 00 8B 44 24 68 89 45 04 8B 44 24 6C 89 45 08 8B 44 24 70 89 45 0C 8B 44 24 74 89 45 10 8B 44 24 78 89 45 14 8B 44 24 7C 89 45 18 8B 84 24 80 00 00 00 89 45 1C 8B 84 24 84 00 00 00 89 45 20 8B 84 24 88 00 00 00 89 45 24 8B 84 24 8C 00 00 00 89 45 28 8B 44 24 4C 81 C4 9C 00 00 00 5B 5E 5F 5D C2 08 00 8D 76 00 3C 25 74 2C 8B 54 24 4C 83 C5 01 0F B6 0A 83 C2 01 89 54 24 4C 38 C8 0F 84 04 FF FF FF 31 C0 81 C4 9C 00 00 00 5B 5E 5F 5D C2 08 00 8D 74 26 00 8B 84 24 B0 00 00 00 8D 4D 01 85 C0 0F 84 B5 01 00 00 8D B6 00 00 00 00 0F B6 01 3C 5F 74 49 3C 2D 74 45 3C 30 74 41 3C 5E 74 3D 3C 23 75 0F EB 37 8D B4 26 00 00 00 00 83 C1 01 0F B6 01 8D 58 D0 80 FB 09 76 F2 83 E8 25 8B 5C 24 4C 3C 55 8D 69 01 76 04 31 C0 EB 97 0F B6 C0 FF 24 85 ?? ?? ?? ?? 8D B6 00 00 00 00 83 C1 01 EB AB 83 C3 01 89 5C 24 4C 0F BE 03 3C 20 74 F2 8D 50 D0 80 FA 09 0F 87 4D 2B 00 00 83 E8 30 8D 0C 80 01 C9 8D 53 01 83 F9 35 89 54 24 4C 77 22 0F BE 53 01 80 FA 2F 7E 19 80 FA 39 7F 14 8D 44 11 D0 83 C3 02 83 F8 35 89 5C 24 4C 0F 87 20 2B 00 00 88 44 24 5E 80 4C 24 5C 20 E9 26 FE FF FF 0F B6 4C 24 5D 89 C8 83 E0 18 3C 10 88 44 24 24 74 2C 8B 44 24 30 8B 90 CC 00 00 00 80 3A 00 0F 85 F9 1A 00 00 80 7C 24 24 08 0F 84 22 2B 00 00 83 E1 E7 83 C9 10 89 5C 24 4C 88 4C 24 5D 8B 15 ?? ?? ?? ?? 80 3A 00 0F 84 9C 28 00 00 8D 4C 24 5C 8B 44 24 4C 89 0C 24 8B 4C 24 28 89 74 24 04 E8 ?? ?? ?? ?? 83 EC 08 85 C0 89 44 24 4C 0F 85 B2 FD FF FF 31 C0 E9 A9 FE FF FF 66 90 0F B6 4C 24 5D 89 CA 83 E2 18 80 FA 10 88 54 24 24 74 2C 8B 44 24 30 8B 90 C8 00 00 00 80 3A 00 0F 85 C8 1A 00 00 80 7C 24 24 08 0F 84 5B 28 00 00 83 E1 E7 83 C9 10 89 5C 24 4C 88 4C 24 5D 8B 15 ?? ?? ?? ?? 80 3A 00 0F 84 17 28 00 00 8D 4C 24 5C 8B 44 24 4C 89 0C 24 8B 4C 24 28 89 74 24 04 E8 ?? ?? ?? ?? 83 EC 08 85 C0 89 44 24 4C 0F 84 75 2A 00 00 80 4C 24 5D 04 E9 2A FD FF FF 0F B6 45 01 8D 69 01 8B 5C 24 4C 83 E8 25 3C 55 0F 87 77 FE FF FF E9 76 FE FF FF C7 44 24 5C 00 00 00 00 C7 44 24 60 FF FF FF FF C6 44 24 5F FF 89 4C 24 28 E9 EB FC FF FF 8B 4C 24 28 8D 44 24 5C BA ?? ?? ?? ?? 89 04 24 89 D8 89 74 24 04 E8 ?? ?? ?? ?? 83 EC 08 85 C0 89 44 24 4C 75 97 31 C0 E9 C2 FD FF FF 8D 76 00 0F B6 41 01 8D 69 02 83 E8 43 3C 36 0F 86 D8 0F 00 00 31 C0 E9 A6 FD FF FF 8B 54 24 30 31 C0 C7 44 24 60 00 00 00 00 8B 92 EC 00 00 00 85 D2 89 54 24 24 0F 8E A0 00 00 00 89 6C 24 34 89 F5 89 7C 24 38 8B 54 24 30 E8 ?? ?? ?? ?? 85 C0 0F 84 3E 28 00 00 8B 5C 24 28 8B 78 30 8B 73 14 2B 70 04 0F AF F7 85 F6 0F 88 26 28 00 00 8B 48 14 89 F2 8B 40 08 C1 FA 1F 89 54 24 44 89 74 24 40 89 CB 89 C2 C1 FA 1F C1 FB 1F 29 C1 19 D3 89 FA C1 FA 1F 89 D8 89 D3 0F AF C7 0F AF D9 01 C3 89 C8 F7 E7 01 DA 39 54 24 44 89 44 24 10 89 54 24 14 0F 8F DC 27 00 00 0F 8D CC 27 00 00 0F B6 44 24 5D 89 EE 8B 7C 24 38 8B 6C 24 34 83 E0 E7 83 C8 08 88 44 24 5D 8B 44 24 60 3B 44 24 24 0F 85 DE FB FF FF 0F B6 44 24 5D C7 44 24 60 FF FF FF FF 89 C2 83 E2 18 80 FA 08 0F 84 BF 27 00 00 8B 5C 24 4C 83 E0 E7 83 C8 10 88 44 24 5D 0F BE 13 80 FA 20 75 15 8D 43 01 89 C3 89 44 24 4C 83 C0 01 0F BE 50 FF 80 FA 20 74 EE 8D 42 D0 3C 09 0F 87 50 29 00 00 8D 43 01 89 44 24 4C 0F BE 43 01 8D 8C 92 10 FF FF FF 01 C9 3C 2F 0F 8E 48 15 00 00 3C 39 0F 8F 40 15 00 00 8D 14 01 83 C3 02 8D 42 D0 83 F8 44 89 5C 24 4C 0F 86 2A 15 00 00 8B 5C 24 28 89 43 14 80 4C 24 5D 05 E9 42 FB FF FF 0F B6 13 8D 43 01 80 FA 20 75 12 89 C3 89 44 24 4C 83 C0 01 0F B6 50 FF 80 FA 20 74 EE 83 EA 30 80 FA 09 0F 87 D5 28 00 00 8D 43 01 89 44 24 4C 0F B6 43 01 3C 2F 0F 8E 06 FB FF FF 3C 39 0F 8F FE FA FF FF 83 C3 02 89 5C 24 4C E9 F2 FA FF FF 0F BE 13 8D 43 01 80 FA 20 75 12 89 C3 89 44 24 4C 83 C0 01 0F BE 50 FF 80 FA 20 74 EE 8D 42 D0 3C 09 0F 87 7D 28 00 00 8D 4B 01 8D 42 D0 89 4C 24 4C 8D 0C 80 01 C9 83 F9 1F 89 4C 24 24 77 1F 0F B6 4B 01 80 F9 2F 7E 16 80 F9 39 7F 11 0F BE D1 83 C3 02 03 54 24 24 89 5C 24 4C 8D 42 D0 83 EA 31 83 FA 1E 0F 87 03 26 00 00 8B 5C 24 28 89 43 0C 80 4C 24 5C 10 80 4C 24 5D 04 E9 71 FA FF FF 0F B6 13 8D 43 01 80 FA 20 75 12 89 C3 89 44 24 4C 83 C0 01 0F B6 50 FF 80 FA 20 74 EE 8D 42 D0 3C 09 0F 87 0A 27 00 00 0F BE C2 83 C3 01 83 E8 30 83 F8 06 89 5C 24 4C 0F 87 ED 26 00 00 8B 5C 24 28 89 43 18 80 4C 24 5C 02 E9 22 FA FF FF 0F B6 13 8D 43 01 80 FA 20 75 12 89 C3 89 44 24 4C 83 C0 01 0F B6 50 FF 80 FA 20 74 EE 8D 42 D0 3C 09 0F 87 4D 27 00 00 0F BE C2 83 E8 30 8D 0C 80 01 C9 8D 53 01 83 F9 3B 89 54 24 4C 77 22 0F BE 53 01 80 FA 2F 7E 19 80 FA 39 7F 14 8D 44 11 D0 83 C3 02 83 F8 3B 89 5C 24 4C 0F 87 1D 27 00 00 8B 5C 24 28 89 43 04 E9 B5 F9 FF FF 0F BE 03 8D 53 01 3C 20 75 11 89 D3 89 54 24 4C 83 C2 01 0F BE 42 FF 3C 20 74 EF 8D 50 D0 80 FA 09 0F 87 DA 26 00 00 8D 53 01 8D 48 D0 89 54 24 4C 8D 14 89 01 D2 83 FA 0C 89 54 24 24 77 1F 0F B6 53 01 80 FA 2F 7E 16 80 FA 39 7F 11 0F BE C2 83 C3 02 03 44 24 24 89 5C 24 4C 8D 48 D0 83 E8 31 83 F8 0B 0F 87 F7 22 00 00 89 C8 BA AB AA AA AA 8B 5C 24 28 F7 E2 C1 EA 03 8D 04 52 C1 E0 02 29 C1 89 4B 08 80 4C 24 5C 01 E9 26 F9 FF FF 0F B6 44 24 5D 83 E0 18 3C 10 0F 84 5B 13 00 00 8B 54 24 30 8B 8A BC 00 00 00 89 0C 24 89 4C 24 1C E8 ?? ?? ?? ?? 8B 4C 24 1C 89 74 24 0C 89 5C 24 04 89 0C 24 89 44 24 08 89 44 24 20 E8 ?? ?? ?? ?? 8B 54 24 20 85 C0 0F 85 CE 12 00 00 01 54 24 4C A1 ?? ?? ?? ?? 8B 54 24 30 89 44 24 04 8B 82 BC 00 00 00 89 04 24 E8 ?? ?? ?? ?? 85 C0 74 0F 0F B6 44 24 5D 83 E0 E7 83 C8 08 88 44 24 5D 80 64 24 5C 7F E9 9C F8 FF FF 0F B6 0B 8D 43 01 80 F9 20 75 12 89 C3 89 44 24 4C 83 C0 01 0F B6 48 FF 80 F9 20 74 EE 80 F9 2D 0F 85 42 25 00 00 8D 53 01 31 DB 89 54 24 4C C7 44 24 24 00 00 00 00 0F BE 02 3C 2F 0F 8E 08 16 00 00 3C 39 0F 8F 00 16 00 00 83 44 24 24 01 83 C2 01 83 7C 24 24 04 8D 1C 9B 8D 5C 58 D0 89 54 24 4C 75 D3 89 D8 BA 1F 85 EB 51 F7 E2 89 D0 C1 E8 05 6B C0 64 29 C3 83 FB 3B 89 D8 0F 87 AA 22 00 00 6B C0 32 C1 EA 05 6B DA 64 BA 89 88 88 88 F7 E2 C1 EA 04 01 DA 81 FA B0 04 00 00 0F 87 82 22 00 00 69 D2 10 0E 00 00 BB 1F 85 EB 51 89 D0 F7 E3 8B 5C 24 28 C1 EA 05 80 F9 2D 89 53 24 0F 85 D7 F7 FF FF F7 DA 89 53 24 E9 CD F7 FF FF 0F BE 13 8D 43 01 80 FA 20 75 12 89 C3 89 44 24 4C 83 C0 01 0F BE 50 FF 80 FA 20 74 EE 8D 42 D0 3C 09 0F 87 D8 24 00 00 8D 94 92 10 FF FF FF 01 D2 8D 43 01 83 FA 35 89 44 24 4C 0F 87 8C F7 FF FF 0F BE 43 01 3C 2F 0F 8E 80 F7 FF FF 3C 39 0F 8F 78 F7 FF FF 8D 44 02 D0 83 C3 02 83 F8 35 89 5C 24 4C 0F 86 64 F7 FF FF 31 C0 E9 5B F8 FF FF 8D 74 26 00 0F B6 13 8D 43 01 80 FA 20 75 12 89 C3 89 44 24 4C 83 C0 01 0F B6 50 FF 80 FA 20 74 EE 8D 42 D0 3C 09 0F 87 DD 21 00 00 0F BE C2 83 E8 30 8D 0C 80 01 C9 8D 53 01 83 F9 3D 89 54 24 4C 77 22 0F BE 53 01 80 FA 2F 7E 19 80 FA 39 7F 14 8D 44 11 D0 83 C3 02 83 F8 3D 89 5C 24 4C 0F 87 32 24 00 00 8B 5C 24 28 89 03 E9 ED F6 FF FF 0F B6 13 8D 43 01 80 FA 20 75 12 89 C3 89 44 24 4C 83 C0 01 0F B6 50 FF 80 FA 20 74 EE 8D 42 D0 3C 09 0F 87 78 23 00 00 0F BE C2 83 E8 30 8D 0C 80 01 C9 8D 53 01 83 F9 35 89 54 24 4C 77 22 0F BE 53 01 80 FA 2F 7E 19 80 FA 39 7F 14 8D 44 11 D0 83 C3 02 83 F8 35 89 5C 24 4C 0F 87 3F 21 00 00 88 44 24 5E 80 4C 24 5C 40 E9 7E F6 FF FF 0F B6 13 8D 43 01 80 FA 20 75 12 89 C3 89 44 24 4C 83 C0 01 0F B6 50 FF 80 FA 20 74 EE 8D 42 D0 3C 09 0F 87 F2 20 00 00 0F BE C2 83 E8 30 8D 0C 80 01 C9 8D 53 01 83 F9 17 89 54 24 4C 77 22 0F BE 53 01 80 FA 2F 7E 19 80 FA 39 7F 14 8D 44 11 D0 83 C3 02 83 F8 17 89 5C 24 4C 0F 87 C0 20 00 00 8B 5C 24 28 89 43 08 80 64 24 5C FE E9 0C F6 FF FF 0F B6 03 83 E8 30 3C 09 0F 87 80 20 00 00 83 C3 01 89 D8 89 5C 24 4C 0F B6 00 83 C3 01 83 E8 30 3C 09 76 ED E9 E3 F5 FF FF 8B 92 EC 00 00 00 31 C0 C7 44 24 60 00 00 00 00 85 D2 89 54 24 24 7E 65 8B 54 24 30 E8 ?? ?? ?? ?? 85 C0 0F 84 F9 1F 00 00 8B 50 20 89 14 24 89 54 24 20 E8 ?? ?? ?? ?? 8B 54 24 20 89 74 24 0C 89 14 24 89 C1 89 44 24 08 8B 44 24 4C 89 4C 24 1C 89 44 24 04 E8 ?? ?? ?? ?? 8B 4C 24 1C 85 C0 0F 85 BC 1F 00 00 0F B6 44 24 5D 01 4C 24 4C 83 E0 E7 83 C8 08 88 44 24 5D 8B 44 24 60 3B 44 24 24 0F 85 5C F5 FF FF 0F B6 44 24 5D C7 44 24 60 FF FF FF FF 89 C2 83 E2 18 80 FA 08 0F 84 9E 1F 00 00 8B 5C 24 4C 83 E0 E7 83 C8 10 88 44 24 5D 0F B6 13 80 FA 20 75 15 8D 43 01 89 C3 89 44 24 4C 83 C0 01 0F B6 50 FF 80 FA 20 74 EE 8D 42 D0 3C 09 0F 87 B7 21 00 00 0F BE C2 8D 53 01 83 E8 30 89 54 24 4C 0F BE 53 01 8D 0C 80 01 C9 80 FA 2F 7E 10 80 FA 39 7F 0B 83 C3 02 8D 44 11 D0 89 5C 24 4C 88 44 24 5F 80 4C 24 5D 04 E9 D2 F4 FF FF 0F B6 4C 24 5D 89 6C 24 40 31 ED 89 7C 24 48 C7 44 24 24 FF FF FF FF 89 C8 C0 E8 03 89 C2 83 E2 03 89 54 24 34 31 D2 C7 44 24 38 00 00 00 00 89 D7 E9 BA 00 00 00 8D 14 0B 0F B6 4C 24 5D 39 D5 0F 83 86 01 00 00 83 E1 18 0F 85 09 0F 00 00 8B 04 BD ?? ?? ?? ?? 8B 5C 24 30 89 44 24 04 8B 44 BB 24 89 54 24 20 89 04 24 E8 ?? ?? ?? ?? 8B 54 24 20 8B 5C 24 4C 89 7C 24 24 89 D5 85 C0 74 08 C7 44 24 34 01 00 00 00 8B 14 BD ?? ?? ?? ?? 89 14 24 89 54 24 20 E8 ?? ?? ?? ?? 8B 54 24 20 89 74 24 0C 89 5C 24 04 89 14 24 89 44 24 08 89 44 24 1C E8 ?? ?? ?? ?? 8B 4C 24 1C 85 C0 0F 85 BE 0B 00 00 01 D9 39 E9 0F 86 B4 0B 00 00 89 7C 24 24 89 CD C7 44 24 34 02 00 00 00 83 C7 01 83 FF 07 0F 84 1B 0D 00 00 8B 5C 24 4C 0F B6 4C 24 5D 83 E1 18 80 F9 10 74 90 8B 44 24 30 8D 8F 07 00 02 00 81 E1 FF FF 00 00 83 C1 08 8B 54 88 04 89 4C 24 1C 89 14 24 89 54 24 20 E8 ?? ?? ?? ?? 8B 54 24 20 89 74 24 0C 89 5C 24 04 89 14 24 89 44 24 08 89 44 24 38 E8 ?? ?? ?? ?? 8B 4C 24 1C 85 C0 75 44 03 5C 24 38 39 EB 76 3C F6 44 24 5D 18 0F 85 0D 0E 00 00 8B 04 BD ?? ?? ?? ?? 89 DD 8B 54 24 30 89 44 24 04 8B 44 8A 04 89 04 24 E8 ?? ?? ?? ?? 89 7C 24 24 85 C0 B8 01 00 00 00 0F 44 44 24 34 89 44 24 34 8B 4C 24 30 8B 5C 24 4C 8B 54 B9 24 89 14 24 89 54 24 20 E8 ?? ?? ?? ?? 8B 54 24 20 89 74 24 0C 89 5C 24 04 89 14 24 89 44 24 08 89 44 24 1C E8 ?? ?? ?? ?? 8B 4C 24 1C 85 C0 0F 84 6F FE FF FF 0F B6 4C 24 5D 83 E1 18 80 F9 08 0F 84 03 FF FF FF 8B 5C 24 4C E9 A7 FE FF FF 8B 4C 24 28 8D 44 24 5C BA ?? ?? ?? ?? 89 04 24 89 D8 89 74 24 04 E8 ?? ?? ?? ?? 83 EC 08 85 C0 89 44 24 4C 0F 85 C7 F2 FF FF 31 C0 E9 BE F3 FF FF 8D B4 26 00 00 00 00 0F B6 41 01 8D 69 02 83 E8 48 3C 31 0F 86 C6 05 00 00 31 C0 E9 9E F3 FF FF 0F B6 03 83 C3 01 89 5C 24 4C 3C 25 0F 84 8E F2 FF FF 31 C0 E9 85 F3 FF FF 8D B6 00 00 00 00 0F BE 13 8D 43 01 80 FA 20 75 12 89 C3 89 44 24 4C 83 C0 01 0F BE 50 FF 80 FA 20 74 EE 8D 42 D0 3C 09 0F 87 2C 1D 00 00 8D 8C 92 10 FF FF FF 01 C9 8D 43 01 83 F9 0C 89 44 24 4C 77 16 0F BE 43 01 3C 2F 7E 0E 3C 39 7F 0A 83 C3 02 8D 14 01 89 5C 24 4C 83 EA 31 83 FA 0B 0F 87 FE 1C 00 00 8B 5C 24 28 89 53 10 80 4C 24 5C 08 80 4C 24 5D 04 E9 0C F2 FF FF 0F B6 03 83 C3 01 3C 20 75 0F 89 5C 24 4C 83 C3 01 0F B6 43 FF 3C 20 74 F1 83 E8 30 3C 09 0F 87 63 1C 00 00 8B 44 24 4C 0F BE 10 8D 48 01 89 4C 24 4C 8D 8C 92 10 FF FF FF 01 C9 81 F9 6E 01 00 00 77 46 0F B6 58 01 80 FB 2F 7E 3D 80 FB 39 7F 38 0F BE D3 01 CA 8D 48 02 89 4C 24 4C 8D 8C 92 10 FF FF FF 01 C9 81 F9 6E 01 00 00 77 1B 0F B6 58 02 80 FB 2F 7E 12 80 FB 39 7F 0D 0F BE 50 02 83 C0 03 89 44 24 4C 01 CA 83 EA 31 81 FA 6D 01 00 00 0F 87 27 1B 00 00 8B 5C 24 28 89 53 1C 80 4C 24 5C 04 E9 63 F1 FF FF 0F BE 03 83 C3 01 F6 44 42 01 20 0F 84 52 F1 FF FF 89 D8 89 5C 24 4C 0F BE 00 83 C3 01 F6 44 42 01 20 75 ED E9 3A F1 FF FF 0F B6 4C 24 5D 89 7C 24 48 C7 44 24 34 FF FF FF FF C7 44 24 24 00 00 00 00 89 C8 C0 E8 03 89 C2 89 C8 83 E2 03 89 54 24 38 31 D2 89 6C 24 40 89 D7 E9 B1 00 00 00 01 D5 0F B6 44 24 5D 39 6C 24 24 0F 83 88 01 00 00 83 E0 18 0F 85 68 0A 00 00 8B 04 BD ?? ?? ?? ?? 8B 54 24 30 89 44 24 04 8B 44 8A 04 89 04 24 E8 ?? ?? ?? ?? 8B 5C 24 4C 89 7C 24 34 89 6C 24 24 85 C0 74 08 C7 44 24 38 01 00 00 00 8B 2C BD ?? ?? ?? ?? 89 2C 24 E8 ?? ?? ?? }
	condition:
		$1
}

rule file_34_2_0 {
	meta:
		name = "__strptime_l"
		size = 42
		refs = "001f __strptime_internal"
	strings:
		$1 = { 83 EC 1C 8B 44 24 2C 8B 4C 24 28 8B 54 24 24 C7 04 24 00 00 00 00 89 44 24 04 8B 44 24 20 E8 ?? ?? ?? ?? 83 EC 08 83 C4 1C C3 }
	condition:
		$1
}

rule file_35_0_0 {
	meta:
		name = "jrand48"
		size = 39
		refs = "0013 __libc_drand48_data 001b __jrand48_r"
	strings:
		$1 = { 83 EC 2C 8D 44 24 1C 89 44 24 08 8B 44 24 30 C7 44 24 04 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 8B 44 24 1C 83 C4 2C C3 }
	condition:
		$1
}

rule file_443_0_0 {
	meta:
		name = "nrand48"
		size = 39
		refs = "0013 __libc_drand48_data 001b __nrand48_r"
	strings:
		$1 = { 83 EC 2C 8D 44 24 1C 89 44 24 08 8B 44 24 30 C7 44 24 04 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 8B 44 24 1C 83 C4 2C C3 }
	condition:
		$1
}

rule file_36_0_0 {
	meta:
		name = "_longjmp_unwind"
		size = 22
		refs = "0001 __pthread_cleanup_upto"
	strings:
		$1 = { B8 ?? ?? ?? ?? 85 C0 74 0C 55 89 E5 89 6D 0C 5D E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_37_0_0 {
	meta:
		name = "mabort"
		size = 195
		refs = "002f _libc_intl_domainname 0034 __dcgettext 003c __libc_fatal"
	strings:
		$1 = { 83 EC 1C 8B 44 24 20 83 F8 01 74 70 0F 8E 88 00 00 00 83 F8 02 74 29 83 F8 03 74 42 C7 44 24 08 05 00 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? C7 44 24 08 05 00 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB DA C7 44 24 08 05 00 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB BC C7 44 24 08 05 00 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 9E 85 C0 0F 85 7A FF FF FF C7 44 24 08 05 00 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? E9 75 FF FF FF }
	condition:
		$1
}

rule file_37_1_0 {
	meta:
		name = "checkhdr"
		size = 130
	strings:
		$1 = { 53 31 DB 83 EC 18 8B 15 ?? ?? ?? ?? 85 D2 74 3B 8B 50 0C 03 50 08 33 50 04 81 FA 09 53 67 D8 74 37 81 FA EB BE DA FE BB 02 00 00 00 74 32 C7 05 ?? ?? ?? ?? 00 00 00 00 89 1C 24 FF 15 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 01 00 00 00 83 C4 18 89 D8 5B C3 8D B6 00 00 00 00 BB 01 00 00 00 EB CF 90 8B 10 BB 03 00 00 00 80 7C 10 18 D7 75 C0 8B 50 10 B3 02 33 50 14 81 FA EB BE DA FE 75 B0 30 DB EB C9 }
	condition:
		$1
}

rule file_37_2_0 {
	meta:
		name = "unlink_blk.isra.1"
		size = 55
	strings:
		$1 = { 85 D2 74 11 8B 08 89 4A 08 03 4A 0C 81 F1 EB BE DA FE 89 4A 04 8B 00 85 C0 74 15 89 50 0C 03 50 08 81 F2 EB BE DA FE 89 50 04 C3 90 8D 74 26 00 89 15 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_37_3_0 {
	meta:
		name = "memalignhook"
		size = 284
		refs = "003a __memalign_hook 00ca memset 00d9 mcheck_check_all 00f4 memalign 0101 __libc_errno"
	strings:
		$1 = { 57 56 53 83 EC 10 8B 0D ?? ?? ?? ?? 8B 7C 24 20 8B 74 24 24 85 C9 0F 85 BC 00 00 00 89 FB F7 DB 8D 47 17 21 C3 8D 43 01 F7 D0 39 F0 0F 82 CE 00 00 00 A1 ?? ?? ?? ?? 85 C0 A3 ?? ?? ?? ?? 0F 84 A4 00 00 00 8B 54 24 28 89 3C 24 89 54 24 08 8D 54 33 01 89 54 24 04 FF D0 85 C0 C7 05 ?? ?? ?? ?? ?? ?? ?? ?? 0F 84 AD 00 00 00 8B 0D ?? ?? ?? ?? 8D 54 18 E8 89 32 C7 42 08 00 00 00 00 89 15 ?? ?? ?? ?? 89 CB 81 F3 EB BE DA FE 85 C9 89 4A 0C 89 5A 04 74 11 8B 59 0C 89 51 08 01 D3 81 F3 EB BE DA FE 89 59 04 89 42 10 8D 5A 18 35 EB BE DA FE 89 42 14 C6 44 32 18 D7 89 74 24 08 C7 44 24 04 93 FF FF FF 89 1C 24 E8 ?? ?? ?? ?? 83 C4 10 89 D8 5B 5E 5F C3 90 E8 ?? ?? ?? ?? E9 3A FF FF FF 8D B6 00 00 00 00 8D 44 33 01 89 44 24 04 89 3C 24 E8 ?? ?? ?? ?? E9 5C FF FF FF 8D 76 00 A1 ?? ?? ?? ?? 31 DB 65 C7 00 0C 00 00 00 83 C4 10 89 D8 5B 5E 5F C3 90 31 DB EB B2 }
	condition:
		$1
}

rule file_37_4_0 {
	meta:
		name = "mallochook"
		size = 252
		refs = "0028 __malloc_hook 00b1 memset 00c1 mcheck_check_all 00cf __libc_errno 00ef malloc"
	strings:
		$1 = { 56 53 83 EC 14 8B 35 ?? ?? ?? ?? 8B 5C 24 20 85 F6 0F 85 A9 00 00 00 83 FB E6 0F 87 AE 00 00 00 A1 ?? ?? ?? ?? 85 C0 A3 ?? ?? ?? ?? 0F 84 B6 00 00 00 8B 54 24 24 89 54 24 04 8D 53 19 89 14 24 FF D0 85 C0 C7 05 ?? ?? ?? ?? ?? ?? ?? ?? 0F 84 A4 00 00 00 8B 15 ?? ?? ?? ?? 89 18 C7 40 08 00 00 00 00 A3 ?? ?? ?? ?? 89 D1 81 F1 EB BE DA FE 85 D2 89 50 0C 89 48 04 74 11 8B 4A 0C 89 42 08 01 C1 81 F1 EB BE DA FE 89 4A 04 89 C2 81 F2 EB BE DA FE 8D 70 18 89 40 10 89 50 14 C6 44 18 18 D7 89 5C 24 08 C7 44 24 04 93 FF FF FF 89 34 24 E8 ?? ?? ?? ?? 83 C4 14 89 F0 5B 5E C3 8D 76 00 E8 ?? ?? ?? ?? 83 FB E6 0F 86 52 FF FF FF A1 ?? ?? ?? ?? 31 F6 65 C7 00 0C 00 00 00 83 C4 14 89 F0 5B 5E C3 8D 74 26 00 8D 43 19 89 04 24 E8 ?? ?? ?? ?? E9 4A FF FF FF 31 F6 EB B9 }
	condition:
		$1
}

rule file_37_5_0 {
	meta:
		name = "freehook"
		size = 167
		refs = "0057 memset 0066 __free_hook 0089 mcheck_check_all 0094 free"
	strings:
		$1 = { 53 83 EC 18 A1 ?? ?? ?? ?? 8B 5C 24 20 85 C0 75 77 85 DB 74 49 8D 43 E8 E8 B3 FC FF FF 8B 53 F4 8D 43 F0 C7 43 EC 09 53 67 D8 C7 43 FC 09 53 67 D8 E8 2A FD FF FF 8B 43 E8 C7 43 F4 00 00 00 00 C7 43 F0 00 00 00 00 89 1C 24 89 44 24 08 C7 44 24 04 95 FF FF FF E8 ?? ?? ?? ?? 8B 5B F8 A1 ?? ?? ?? ?? 85 C0 A3 ?? ?? ?? ?? 74 24 8B 54 24 24 89 1C 24 89 54 24 04 FF D0 C7 05 ?? ?? ?? ?? ?? ?? ?? ?? 83 C4 18 5B C3 E8 ?? ?? ?? ?? EB 82 90 89 1C 24 E8 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? 83 C4 18 5B C3 }
	condition:
		$1
}

rule file_37_6_0 {
	meta:
		name = "reallochook"
		size = 471
		refs = "0061 __free_hook 006e __realloc_hook 0073 __malloc_hook 007d __memalign_hook 0129 mcheck_check_all 015e memset 0193 realloc 01a1 __libc_errno"
	strings:
		$1 = { 55 57 56 53 83 EC 1C 8B 74 24 34 8B 5C 24 30 85 F6 0F 84 A1 01 00 00 A1 ?? ?? ?? ?? 85 C0 0F 85 04 01 00 00 83 FE E6 0F 87 73 01 00 00 85 DB 0F 84 03 01 00 00 8D 6B E8 8B 7B E8 89 E8 E8 DE FB FF FF 8B 53 F4 8D 43 F0 E8 63 FC FF FF 39 FE 0F 82 13 01 00 00 A1 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? A1 ?? ?? ?? ?? 85 D2 89 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? A1 ?? ?? ?? ?? A3 ?? ?? ?? ?? 0F 84 01 01 00 00 8B 44 24 38 89 2C 24 89 44 24 08 8D 46 19 89 44 24 04 FF D2 89 C3 85 DB C7 05 ?? ?? ?? ?? ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? 0F 84 03 01 00 00 A1 ?? ?? ?? ?? 89 33 C7 43 08 00 00 00 00 89 1D ?? ?? ?? ?? 89 C2 81 F2 EB BE DA FE 85 C0 89 43 0C 89 53 04 74 11 8B 50 0C 89 58 08 01 DA 81 F2 EB BE DA FE 89 50 04 89 D8 35 EB BE DA FE 39 F7 89 5B 10 89 43 14 C6 44 33 18 D7 72 2E 8D 43 18 83 C4 1C 5B 5E 5F 5D C3 8D 76 00 E8 ?? ?? ?? ?? E9 F2 FE FF FF 8D B6 00 00 00 00 31 FF 31 ED 8D 74 26 00 E9 10 FF FF FF 8D 76 00 29 FE 8D 44 3B 18 89 74 24 08 C7 44 24 04 93 FF FF FF 89 04 24 E8 ?? ?? ?? ?? EB B6 8D 74 26 00 89 F8 01 F3 29 F0 89 44 24 08 C7 44 24 04 95 FF FF FF 89 1C 24 E8 ?? ?? ?? ?? E9 CE FE FF FF 90 8D 46 19 89 44 24 04 89 2C 24 E8 ?? ?? ?? ?? 89 C3 E9 FF FE FF FF 66 90 A1 ?? ?? ?? ?? 65 C7 00 0C 00 00 00 31 C0 E9 6A FF FF FF 90 8D 74 26 00 8B 44 24 38 89 1C 24 89 44 24 04 E8 88 FD FF FF 31 C0 E9 4E FF FF FF 90 31 C0 E9 46 FF FF FF }
	condition:
		$1
}

rule file_37_7_0 {
	meta:
		name = "mcheck_check_all"
		size = 53
	strings:
		$1 = { 53 83 EC 08 8B 1D ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 00 00 00 00 85 DB 74 0E 89 D8 E8 11 FF FF FF 8B 5B 0C 85 DB 75 F2 C7 05 ?? ?? ?? ?? 01 00 00 00 83 C4 08 5B C3 }
	condition:
		$1
}

rule file_37_8_0 {
	meta:
		name = "mcheck"
		size = 186
		refs = "0017 __libc_malloc_initialized 0048 malloc 0058 free 005d __free_hook 007b __malloc_hook 008f __memalign_hook 00a3 __realloc_hook"
	strings:
		$1 = { 83 EC 2C BA ?? ?? ?? ?? 8B 44 24 30 85 C0 0F 44 C2 A3 ?? ?? ?? ?? A1 ?? ?? ?? ?? 85 C0 7E 11 83 3D ?? ?? ?? ?? 01 19 C0 83 C4 2C C3 8D 74 26 00 A1 ?? ?? ?? ?? 85 C0 74 07 31 C0 83 C4 2C C3 90 C7 04 24 00 00 00 00 E8 ?? ?? ?? ?? 89 44 24 1C 8B 44 24 1C 89 04 24 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 01 00 00 00 C7 05 ?? ?? ?? ?? ?? ?? ?? ?? A3 ?? ?? ?? ?? A1 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? A3 ?? ?? ?? ?? A1 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? A3 ?? ?? ?? ?? A1 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? A3 ?? ?? ?? ?? 31 C0 EB 81 }
	condition:
		$1
}

rule file_37_9_0 {
	meta:
		name = "mcheck_pedantic"
		size = 33
		refs = "000b mcheck"
	strings:
		$1 = { 83 EC 1C 8B 44 24 20 89 04 24 E8 ?? ?? ?? ?? 85 C0 75 0A C7 05 ?? ?? ?? ?? 01 00 00 00 83 C4 1C C3 }
	condition:
		$1
}

rule file_37_10_0 {
	meta:
		name = "mprobe"
		size = 30
	strings:
		$1 = { 8B 15 ?? ?? ?? ?? 8B 44 24 04 85 D2 74 0A 83 E8 18 E9 3A F9 FF FF 66 90 B8 FF FF FF FF C3 }
	condition:
		$1
}

rule file_40_2_0 {
	meta:
		name = "_create_xid"
		size = 147
		refs = "0020 getpid 003e __gettimeofday 0058 __srand48_r 0072 lrand48_r"
	strings:
		$1 = { 53 31 C0 83 EC 28 B9 01 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 0D ?? ?? ?? ?? 75 74 E8 ?? ?? ?? ?? 39 05 ?? ?? ?? ?? 74 36 89 C3 8D 44 24 18 C7 44 24 04 00 00 00 00 89 04 24 E8 ?? ?? ?? ?? 8B 54 24 1C 33 54 24 18 C7 44 24 04 ?? ?? ?? ?? 31 DA 89 14 24 E8 ?? ?? ?? ?? 89 1D ?? ?? ?? ?? 8D 44 24 14 89 44 24 04 C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 65 83 3D 0C 00 00 00 00 74 01 F0 83 2D ?? ?? ?? ?? 01 75 19 8B 44 24 14 83 C4 28 5B C3 }
	condition:
		$1
}

rule file_41_0_0 {
	meta:
		name = "__alphasort64"
		size = 31
		refs = "001b strcoll"
	strings:
		$1 = { 8B 44 24 08 8B 00 83 C0 13 89 44 24 08 8B 44 24 04 8B 00 83 C0 13 89 44 24 04 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_66_0_0 {
	meta:
		name = "__versionsort64"
		size = 31
		refs = "001b __strverscmp"
	strings:
		$1 = { 8B 44 24 08 8B 00 83 C0 13 89 44 24 08 8B 44 24 04 8B 00 83 C0 13 89 44 24 04 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_42_0_0 {
	meta:
		name = "lrand48"
		size = 39
		refs = "000f __libc_drand48_data 001b __nrand48_r"
	strings:
		$1 = { 83 EC 2C 8D 44 24 1C 89 44 24 08 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 44 24 1C 83 C4 2C C3 }
	condition:
		$1
}

rule file_1309_0_0 {
	meta:
		name = "mrand48"
		size = 39
		refs = "000f __libc_drand48_data 001b __jrand48_r"
	strings:
		$1 = { 83 EC 2C 8D 44 24 1C 89 44 24 08 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 44 24 1C 83 C4 2C C3 }
	condition:
		$1
}

rule file_43_0_0 {
	meta:
		name = "__realpath_chk"
		size = 42
		refs = "0026 __chk_fail 0021 __realpath"
	strings:
		$1 = { 83 EC 0C 81 7C 24 18 FF 0F 00 00 8B 44 24 10 8B 54 24 14 76 10 89 54 24 14 89 44 24 10 83 C4 0C E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_0_0 {
	meta:
		name = "psignal"
		size = 285
		refs = "003b _sys_siglist 004a _libc_intl_domainname 004f __dcgettext 006f __fxprintf 00b4 __asprintf 00e0 free"
	strings:
		$1 = { 83 EC 3C 89 5C 24 30 8B 5C 24 44 89 74 24 34 8B 74 24 40 89 7C 24 38 85 DB 74 09 80 3B 00 0F 85 D4 00 00 00 BF ?? ?? ?? ?? 89 FB 83 FE 40 C7 44 24 08 05 00 00 00 77 50 8B 04 B5 ?? ?? ?? ?? 85 C0 74 45 89 44 24 04 C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 7C 24 0C 89 5C 24 08 C7 44 24 04 ?? ?? ?? ?? C7 04 24 00 00 00 00 89 44 24 10 E8 ?? ?? ?? ?? 8B 5C 24 30 8B 74 24 34 8B 7C 24 38 83 C4 3C C3 90 8D 74 26 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 74 24 10 89 7C 24 0C 89 5C 24 08 89 44 24 04 8D 44 24 2C 89 04 24 E8 ?? ?? ?? ?? 85 C0 78 4C 8B 44 24 2C C7 44 24 04 ?? ?? ?? ?? C7 04 24 00 00 00 00 89 44 24 08 E8 ?? ?? ?? ?? 8B 44 24 2C 89 04 24 E8 ?? ?? ?? ?? 8B 5C 24 30 8B 74 24 34 8B 7C 24 38 83 C4 3C C3 8D 74 26 00 BF ?? ?? ?? ?? E9 29 FF FF FF 8D B6 00 00 00 00 C7 44 24 08 05 00 00 00 C7 44 24 04 ?? ?? ?? ?? E9 2A FF FF FF }
	condition:
		$1
}

rule file_45_0_0 {
	meta:
		name = "__lcong48_r"
		size = 80
	strings:
		$1 = { 83 EC 08 8B 54 24 0C 89 1C 24 8B 44 24 10 89 74 24 04 8B 0A 89 08 0F B7 4A 04 66 89 48 04 0F B7 5A 08 0F B7 4A 06 0F B7 72 0A 0F B7 52 0C C1 E3 10 09 D9 8B 1C 24 89 70 14 8B 74 24 04 89 48 10 66 89 50 0C 66 C7 40 0E 01 00 31 C0 83 C4 08 C3 }
	condition:
		$1
}

rule file_46_0_0 {
	meta:
		name = "grantpt"
		size = 1230
		refs = "0031 realloc 0058 __ptsname_internal 0074 memchr 0086 malloc 0092 __libc_errno 00a5 free 00bb __libc_fcntl 00e1 __getuid 0101 __chown 0151 __chmod 0181 __fork 01bc __setrlimit 01d5 __dup2 01ef __opendir 0204 __readdir64 022f strtol 0250 _dl_sysinfo 026c __waitpid 02ab __assert_fail 02ec __closedir 0300 __open_nocancel 0345 basename 0365 execle 0371 _exit 0438 __sysconf 047a __getgrnam_r 049a __getgid"
	strings:
		$1 = { 55 89 E5 57 BF 00 10 00 00 56 53 8D B5 E8 EF FF FF 81 EC BC 10 00 00 89 F3 EB 20 90 8D 74 26 00 39 F3 BF 80 00 00 00 74 59 89 7C 24 04 89 1C 24 E8 ?? ?? ?? ?? 85 C0 74 57 89 C3 85 FF 74 E1 8D 85 88 EF FF FF 89 44 24 0C 8B 45 08 89 7C 24 08 89 5C 24 04 89 04 24 E8 ?? ?? ?? ?? 85 C0 0F 85 61 02 00 00 89 7C 24 08 C7 44 24 04 00 00 00 00 89 1C 24 E8 ?? ?? ?? ?? 85 C0 75 64 01 FF 39 F3 75 A7 89 3C 24 E8 ?? ?? ?? ?? 85 C0 75 AB 66 90 8B 3D ?? ?? ?? ?? 65 C7 07 0C 00 00 00 39 F3 74 08 89 1C 24 E8 ?? ?? ?? ?? 8B 45 08 65 8B 1F C7 44 24 04 01 00 00 00 89 04 24 E8 ?? ?? ?? ?? 83 F8 FF 0F 84 AD 02 00 00 83 FB 19 0F 84 2A 03 00 00 65 89 1F B8 FF FF FF FF E9 95 00 00 00 66 90 E8 ?? ?? ?? ?? 39 85 A0 EF FF FF 89 C7 74 1A 8B 85 A4 EF FF FF 89 7C 24 04 89 1C 24 89 44 24 08 E8 ?? ?? ?? ?? 85 C0 78 77 A1 ?? ?? ?? ?? 83 F8 FF 0F 84 19 03 00 00 3B 85 A4 EF FF FF 74 14 89 44 24 08 89 7C 24 04 89 1C 24 E8 ?? ?? ?? ?? 85 C0 78 4D 8B 85 98 EF FF FF 25 FF 01 00 00 3D 90 01 00 00 74 14 C7 44 24 04 90 01 00 00 89 1C 24 E8 ?? ?? ?? ?? 85 C0 78 27 31 C0 39 F3 74 14 89 1C 24 89 85 64 EF FF FF E8 ?? ?? ?? ?? 8B 85 64 EF FF FF 8D 65 F4 5B 5E 5F 5D C3 90 8D 74 26 00 E8 ?? ?? ?? ?? 83 F8 FF 0F 84 50 01 00 00 85 C0 0F 85 C0 00 00 00 8D 85 70 EF FF FF 89 44 24 04 C7 04 24 04 00 00 00 C7 85 70 EF FF FF 00 00 00 00 C7 85 74 EF FF FF 00 00 00 00 E8 ?? ?? ?? ?? 83 7D 08 03 74 1B 8B 5D 08 C7 44 24 04 03 00 00 00 89 1C 24 E8 ?? ?? ?? ?? 85 C0 0F 88 0E 02 00 00 C7 04 24 ?? ?? ?? ?? 8D BD 6C EF FF FF E8 ?? ?? ?? ?? 85 C0 89 C6 0F 84 40 01 00 00 8D 76 00 89 34 24 E8 ?? ?? ?? ?? 85 C0 0F 84 D8 00 00 00 0F BE 50 13 83 EA 30 83 FA 09 77 E4 83 C0 13 C7 44 24 08 0A 00 00 00 89 7C 24 04 89 04 24 E8 ?? ?? ?? ?? 8B 95 6C EF FF FF 80 3A 00 75 C2 83 F8 03 74 BD 3B 06 74 B9 89 C3 B8 06 00 00 00 FF 15 ?? ?? ?? ?? EB AA 8D 95 68 EF FF FF C7 44 24 08 00 00 00 00 89 54 24 04 89 04 24 E8 ?? ?? ?? ?? 83 F8 FF 74 69 8B 85 68 EF FF FF A8 7F 75 30 0F B6 C4 83 F8 05 0F 86 05 01 00 00 C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 E9 00 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 65 C7 00 08 00 00 00 B8 FF FF FF FF E9 96 FE FF FF 8B 3D ?? ?? ?? ?? 83 F8 19 BA 16 00 00 00 0F 44 C2 65 89 07 E9 BF FD FF FF B8 FF FF FF FF E9 73 FE FF FF 89 34 24 E8 ?? ?? ?? ?? C7 44 24 04 00 00 00 00 C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 0F 85 00 01 00 00 C7 44 24 04 01 00 00 00 C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 F8 01 0F 85 7A 01 00 00 C7 44 24 04 02 00 00 00 C7 04 24 01 00 00 00 E8 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 44 24 0C 00 00 00 00 C7 44 24 08 00 00 00 00 C7 04 24 ?? ?? ?? ?? 89 44 24 04 E8 ?? ?? ?? ?? C7 04 24 04 00 00 00 E8 ?? ?? ?? ?? 65 83 3F 09 0F 85 49 FD FF FF B8 FF FF FF FF E9 EA FD FF FF 8D B4 26 00 00 00 00 FF 24 85 ?? ?? ?? ?? A1 ?? ?? ?? ?? 65 C7 00 0D 00 00 00 B8 FF FF FF FF E9 AE FD FF FF A1 ?? ?? ?? ?? 65 C7 00 16 00 00 00 B8 FF FF FF FF E9 98 FD FF FF A1 ?? ?? ?? ?? 65 C7 00 09 00 00 00 B8 FF FF FF FF E9 82 FD FF FF A1 ?? ?? ?? ?? 65 C7 00 0C 00 00 00 B8 FF FF FF FF E9 6C FD FF FF C7 04 24 01 00 00 00 E8 ?? ?? ?? ?? 65 C7 07 16 00 00 00 B8 FF FF FF FF E9 67 FD FF FF C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 23 00 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 04 24 45 00 00 00 E8 ?? ?? ?? ?? BA 00 04 00 00 8D 8D 6C EF FF FF 83 F8 FF 0F 44 C2 8D 50 1E 83 E2 F0 29 D4 8D 54 24 23 83 E2 F0 89 44 24 0C 8D 85 78 EF FF FF 89 4C 24 10 89 54 24 08 89 44 24 04 C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 85 6C EF FF FF 85 C0 74 3F 8B 40 08 A3 ?? ?? ?? ?? 83 F8 FF 0F 85 7E FC FF FF E8 ?? ?? ?? ?? E9 74 FC FF FF C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 25 00 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? EB C2 }
	condition:
		$1
}

rule file_47_0_0 {
	meta:
		name = "atol"
		size = 35
		refs = "001b strtol"
		altNames = "atoi atoll"
	strings:
		$1 = { 83 EC 1C 8B 44 24 20 C7 44 24 08 0A 00 00 00 C7 44 24 04 00 00 00 00 89 04 24 E8 ?? ?? ?? ?? 83 C4 1C C3 }
	condition:
		$1
}

rule file_105_1_0 {
	meta:
		name = "gmtime"
		size = 35
		refs = "000b _tmbuf 001b __tz_convert"
	strings:
		$1 = { 83 EC 1C 8B 44 24 20 C7 44 24 08 ?? ?? ?? ?? C7 44 24 04 00 00 00 00 89 04 24 E8 ?? ?? ?? ?? 83 C4 1C C3 }
	condition:
		$1
}

rule file_48_0_0 {
	meta:
		name = "__getpwuid_r"
		size = 587
		refs = "0008 __nss_not_use_nscd_passwd 0070 __libc_errno 0090 _dl_mcount_wrapper_check 00f4 __nss_next2 013c __nss_database_custom 016b __nscd_getpwuid_r 01d3 __nss_passwd_lookup2"
	strings:
		$1 = { 55 57 56 53 83 EC 4C A1 ?? ?? ?? ?? 8B 5C 24 64 83 F8 00 0F 8E 97 01 00 00 83 C0 01 83 F8 64 0F 8F 0B 01 00 00 A3 ?? ?? ?? ?? 80 3D ?? ?? ?? ?? 00 0F 84 89 01 00 00 A1 ?? ?? ?? ?? C1 C8 09 65 33 05 18 00 00 00 89 44 24 3C A1 ?? ?? ?? ?? C1 C8 09 65 33 05 18 00 00 00 83 F8 FF 89 44 24 38 0F 94 C0 0F B6 C0 85 C0 0F 85 0A 01 00 00 8B 15 ?? ?? ?? ?? 8D 6C 24 3C 89 D7 65 03 3D 00 00 00 00 89 54 24 2C 8D 76 00 8B 44 24 3C 89 04 24 E8 ?? ?? ?? ?? 8B 44 24 6C 8B 54 24 68 89 7C 24 10 89 5C 24 04 89 44 24 0C 8B 44 24 60 89 54 24 08 89 04 24 FF 54 24 3C 83 F8 FE 89 C6 75 0E 8B 54 24 2C 65 83 3A 22 0F 84 BC 00 00 00 8D 44 24 38 C7 44 24 14 00 00 00 00 89 74 24 10 89 6C 24 0C C7 44 24 08 00 00 00 00 C7 44 24 04 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 85 C0 74 8C 83 FE 01 8B 44 24 70 0F 84 0F 01 00 00 C7 00 00 00 00 00 0F 86 32 01 00 00 8B 54 24 2C 65 8B 02 83 F8 22 74 7D 83 C4 4C 5B 5E 5F 5D C3 8D B4 26 00 00 00 00 C7 05 ?? ?? ?? ?? 00 00 00 00 80 3D ?? ?? ?? ?? 00 0F 85 E3 FE FF FF 8B 44 24 70 8B 54 24 6C 89 5C 24 04 89 44 24 10 8B 44 24 68 89 54 24 0C 8B 54 24 60 89 44 24 08 89 14 24 E8 ?? ?? ?? ?? 85 C0 79 AE E9 B2 FE FF FF 8B 15 ?? ?? ?? ?? BE FF FF FF FF 89 54 24 2C 90 8B 44 24 70 8B 54 24 2C C7 00 00 00 00 00 65 8B 02 83 F8 22 75 83 83 FE FE 0F 84 7A FF FF FF B0 16 EB 71 90 8D 74 26 00 74 88 80 3D ?? ?? ?? ?? 00 0F 85 78 FE FF FF 90 8D 44 24 3C 31 C9 89 04 24 BA ?? ?? ?? ?? 8D 44 24 38 E8 ?? ?? ?? ?? 83 EC 04 85 C0 75 52 8B 54 24 3C 65 33 15 18 00 00 00 C1 C2 09 89 15 ?? ?? ?? ?? 8B 54 24 38 65 33 15 18 00 00 00 C1 C2 09 89 15 ?? ?? ?? ?? C6 05 ?? ?? ?? ?? 01 E9 54 FE FF FF 8D B6 00 00 00 00 89 18 31 C0 8B 54 24 2C 65 89 02 83 C4 4C 5B 5E 5F 5D C3 90 8D 74 26 00 BA FF FF FF FF 65 33 15 18 00 00 00 C1 C2 09 89 15 ?? ?? ?? ?? EB BF 31 C0 EB D1 }
	condition:
		$1
}

rule file_216_0_0 {
	meta:
		name = "__getgrgid_r"
		size = 587
		refs = "0008 __nss_not_use_nscd_group 0070 __libc_errno 0090 _dl_mcount_wrapper_check 00f4 __nss_next2 013c __nss_database_custom 016b __nscd_getgrgid_r 01d3 __nss_group_lookup2"
	strings:
		$1 = { 55 57 56 53 83 EC 4C A1 ?? ?? ?? ?? 8B 5C 24 64 83 F8 00 0F 8E 97 01 00 00 83 C0 01 83 F8 64 0F 8F 0B 01 00 00 A3 ?? ?? ?? ?? 80 3D ?? ?? ?? ?? 00 0F 84 89 01 00 00 A1 ?? ?? ?? ?? C1 C8 09 65 33 05 18 00 00 00 89 44 24 3C A1 ?? ?? ?? ?? C1 C8 09 65 33 05 18 00 00 00 83 F8 FF 89 44 24 38 0F 94 C0 0F B6 C0 85 C0 0F 85 0A 01 00 00 8B 15 ?? ?? ?? ?? 8D 6C 24 3C 89 D7 65 03 3D 00 00 00 00 89 54 24 2C 8D 76 00 8B 44 24 3C 89 04 24 E8 ?? ?? ?? ?? 8B 44 24 6C 8B 54 24 68 89 7C 24 10 89 5C 24 04 89 44 24 0C 8B 44 24 60 89 54 24 08 89 04 24 FF 54 24 3C 83 F8 FE 89 C6 75 0E 8B 54 24 2C 65 83 3A 22 0F 84 BC 00 00 00 8D 44 24 38 C7 44 24 14 00 00 00 00 89 74 24 10 89 6C 24 0C C7 44 24 08 00 00 00 00 C7 44 24 04 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 85 C0 74 8C 83 FE 01 8B 44 24 70 0F 84 0F 01 00 00 C7 00 00 00 00 00 0F 86 32 01 00 00 8B 54 24 2C 65 8B 02 83 F8 22 74 7D 83 C4 4C 5B 5E 5F 5D C3 8D B4 26 00 00 00 00 C7 05 ?? ?? ?? ?? 00 00 00 00 80 3D ?? ?? ?? ?? 00 0F 85 E3 FE FF FF 8B 44 24 70 8B 54 24 6C 89 5C 24 04 89 44 24 10 8B 44 24 68 89 54 24 0C 8B 54 24 60 89 44 24 08 89 14 24 E8 ?? ?? ?? ?? 85 C0 79 AE E9 B2 FE FF FF 8B 15 ?? ?? ?? ?? BE FF FF FF FF 89 54 24 2C 90 8B 44 24 70 8B 54 24 2C C7 00 00 00 00 00 65 8B 02 83 F8 22 75 83 83 FE FE 0F 84 7A FF FF FF B0 16 EB 71 90 8D 74 26 00 74 88 80 3D ?? ?? ?? ?? 00 0F 85 78 FE FF FF 90 8D 44 24 3C 31 C9 89 04 24 BA ?? ?? ?? ?? 8D 44 24 38 E8 ?? ?? ?? ?? 83 EC 04 85 C0 75 52 8B 54 24 3C 65 33 15 18 00 00 00 C1 C2 09 89 15 ?? ?? ?? ?? 8B 54 24 38 65 33 15 18 00 00 00 C1 C2 09 89 15 ?? ?? ?? ?? C6 05 ?? ?? ?? ?? 01 E9 54 FE FF FF 8D B6 00 00 00 00 89 18 31 C0 8B 54 24 2C 65 89 02 83 C4 4C 5B 5E 5F 5D C3 90 8D 74 26 00 BA FF FF FF FF 65 33 15 18 00 00 00 C1 C2 09 89 15 ?? ?? ?? ?? EB BF 31 C0 EB D1 }
	condition:
		$1
}

rule file_72_0_0 {
	meta:
		name = "__getgrnam_r"
		size = 587
		refs = "0008 __nss_not_use_nscd_group 0070 __libc_errno 0090 _dl_mcount_wrapper_check 00f4 __nss_next2 013c __nss_database_custom 016b __nscd_getgrnam_r 01d3 __nss_group_lookup2"
	strings:
		$1 = { 55 57 56 53 83 EC 4C A1 ?? ?? ?? ?? 8B 5C 24 64 83 F8 00 0F 8E 97 01 00 00 83 C0 01 83 F8 64 0F 8F 0B 01 00 00 A3 ?? ?? ?? ?? 80 3D ?? ?? ?? ?? 00 0F 84 89 01 00 00 A1 ?? ?? ?? ?? C1 C8 09 65 33 05 18 00 00 00 89 44 24 3C A1 ?? ?? ?? ?? C1 C8 09 65 33 05 18 00 00 00 83 F8 FF 89 44 24 38 0F 94 C0 0F B6 C0 85 C0 0F 85 0A 01 00 00 8B 15 ?? ?? ?? ?? 8D 6C 24 3C 89 D7 65 03 3D 00 00 00 00 89 54 24 2C 8D 76 00 8B 44 24 3C 89 04 24 E8 ?? ?? ?? ?? 8B 44 24 6C 8B 54 24 68 89 7C 24 10 89 5C 24 04 89 44 24 0C 8B 44 24 60 89 54 24 08 89 04 24 FF 54 24 3C 83 F8 FE 89 C6 75 0E 8B 54 24 2C 65 83 3A 22 0F 84 BC 00 00 00 8D 44 24 38 C7 44 24 14 00 00 00 00 89 74 24 10 89 6C 24 0C C7 44 24 08 00 00 00 00 C7 44 24 04 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 85 C0 74 8C 83 FE 01 8B 44 24 70 0F 84 0F 01 00 00 C7 00 00 00 00 00 0F 86 32 01 00 00 8B 54 24 2C 65 8B 02 83 F8 22 74 7D 83 C4 4C 5B 5E 5F 5D C3 8D B4 26 00 00 00 00 C7 05 ?? ?? ?? ?? 00 00 00 00 80 3D ?? ?? ?? ?? 00 0F 85 E3 FE FF FF 8B 44 24 70 8B 54 24 6C 89 5C 24 04 89 44 24 10 8B 44 24 68 89 54 24 0C 8B 54 24 60 89 44 24 08 89 14 24 E8 ?? ?? ?? ?? 85 C0 79 AE E9 B2 FE FF FF 8B 15 ?? ?? ?? ?? BE FF FF FF FF 89 54 24 2C 90 8B 44 24 70 8B 54 24 2C C7 00 00 00 00 00 65 8B 02 83 F8 22 75 83 83 FE FE 0F 84 7A FF FF FF B0 16 EB 71 90 8D 74 26 00 74 88 80 3D ?? ?? ?? ?? 00 0F 85 78 FE FF FF 90 8D 44 24 3C 31 C9 89 04 24 BA ?? ?? ?? ?? 8D 44 24 38 E8 ?? ?? ?? ?? 83 EC 04 85 C0 75 52 8B 54 24 3C 65 33 15 18 00 00 00 C1 C2 09 89 15 ?? ?? ?? ?? 8B 54 24 38 65 33 15 18 00 00 00 C1 C2 09 89 15 ?? ?? ?? ?? C6 05 ?? ?? ?? ?? 01 E9 54 FE FF FF 8D B6 00 00 00 00 89 18 31 C0 8B 54 24 2C 65 89 02 83 C4 4C 5B 5E 5F 5D C3 90 8D 74 26 00 BA FF FF FF FF 65 33 15 18 00 00 00 C1 C2 09 89 15 ?? ?? ?? ?? EB BF 31 C0 EB D1 }
	condition:
		$1
}

rule file_325_0_0 {
	meta:
		name = "__getpwnam_r"
		size = 587
		refs = "0008 __nss_not_use_nscd_passwd 0070 __libc_errno 0090 _dl_mcount_wrapper_check 00f4 __nss_next2 013c __nss_database_custom 016b __nscd_getpwnam_r 01d3 __nss_passwd_lookup2"
	strings:
		$1 = { 55 57 56 53 83 EC 4C A1 ?? ?? ?? ?? 8B 5C 24 64 83 F8 00 0F 8E 97 01 00 00 83 C0 01 83 F8 64 0F 8F 0B 01 00 00 A3 ?? ?? ?? ?? 80 3D ?? ?? ?? ?? 00 0F 84 89 01 00 00 A1 ?? ?? ?? ?? C1 C8 09 65 33 05 18 00 00 00 89 44 24 3C A1 ?? ?? ?? ?? C1 C8 09 65 33 05 18 00 00 00 83 F8 FF 89 44 24 38 0F 94 C0 0F B6 C0 85 C0 0F 85 0A 01 00 00 8B 15 ?? ?? ?? ?? 8D 6C 24 3C 89 D7 65 03 3D 00 00 00 00 89 54 24 2C 8D 76 00 8B 44 24 3C 89 04 24 E8 ?? ?? ?? ?? 8B 44 24 6C 8B 54 24 68 89 7C 24 10 89 5C 24 04 89 44 24 0C 8B 44 24 60 89 54 24 08 89 04 24 FF 54 24 3C 83 F8 FE 89 C6 75 0E 8B 54 24 2C 65 83 3A 22 0F 84 BC 00 00 00 8D 44 24 38 C7 44 24 14 00 00 00 00 89 74 24 10 89 6C 24 0C C7 44 24 08 00 00 00 00 C7 44 24 04 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 85 C0 74 8C 83 FE 01 8B 44 24 70 0F 84 0F 01 00 00 C7 00 00 00 00 00 0F 86 32 01 00 00 8B 54 24 2C 65 8B 02 83 F8 22 74 7D 83 C4 4C 5B 5E 5F 5D C3 8D B4 26 00 00 00 00 C7 05 ?? ?? ?? ?? 00 00 00 00 80 3D ?? ?? ?? ?? 00 0F 85 E3 FE FF FF 8B 44 24 70 8B 54 24 6C 89 5C 24 04 89 44 24 10 8B 44 24 68 89 54 24 0C 8B 54 24 60 89 44 24 08 89 14 24 E8 ?? ?? ?? ?? 85 C0 79 AE E9 B2 FE FF FF 8B 15 ?? ?? ?? ?? BE FF FF FF FF 89 54 24 2C 90 8B 44 24 70 8B 54 24 2C C7 00 00 00 00 00 65 8B 02 83 F8 22 75 83 83 FE FE 0F 84 7A FF FF FF B0 16 EB 71 90 8D 74 26 00 74 88 80 3D ?? ?? ?? ?? 00 0F 85 78 FE FF FF 90 8D 44 24 3C 31 C9 89 04 24 BA ?? ?? ?? ?? 8D 44 24 38 E8 ?? ?? ?? ?? 83 EC 04 85 C0 75 52 8B 54 24 3C 65 33 15 18 00 00 00 C1 C2 09 89 15 ?? ?? ?? ?? 8B 54 24 38 65 33 15 18 00 00 00 C1 C2 09 89 15 ?? ?? ?? ?? C6 05 ?? ?? ?? ?? 01 E9 54 FE FF FF 8D B6 00 00 00 00 89 18 31 C0 8B 54 24 2C 65 89 02 83 C4 4C 5B 5E 5F 5D C3 90 8D 74 26 00 BA FF FF FF FF 65 33 15 18 00 00 00 C1 C2 09 89 15 ?? ?? ?? ?? EB BF 31 C0 EB D1 }
	condition:
		$1
}

rule file_49_0_0 {
	meta:
		name = "__futimes"
		size = 408
		refs = "0076 _dl_sysinfo 0099 __libc_errno 00ef _itoa_word"
	strings:
		$1 = { 83 EC 6C 89 6C 24 68 8B 6C 24 74 89 5C 24 5C 89 74 24 60 89 7C 24 64 85 ED 0F 84 2D 01 00 00 8B 55 04 81 FA 3F 42 0F 00 77 6E 8B 45 0C 85 C0 78 67 3D 3F 42 0F 00 7F 60 69 C0 E8 03 00 00 8B 4D 00 69 D2 E8 03 00 00 89 44 24 30 A1 ?? ?? ?? ?? 89 54 24 28 8B 55 08 89 4C 24 24 85 C0 89 54 24 2C 75 62 8D 54 24 24 31 C9 8B 5C 24 70 89 CE B8 40 01 00 00 FF 15 ?? ?? ?? ?? 3D 00 F0 FF FF 77 2A 8B 5C 24 5C 8B 74 24 60 8B 7C 24 64 8B 6C 24 68 83 C4 6C C3 8D 76 00 A1 ?? ?? ?? ?? 65 C7 00 16 00 00 00 B8 FF FF FF FF EB D6 8B 15 ?? ?? ?? ?? F7 D8 83 F8 26 65 89 02 75 7C C7 05 ?? ?? ?? ?? 01 00 00 00 8D 44 24 4F BE ?? ?? ?? ?? 89 44 24 04 8B 44 24 70 C7 44 24 0C 00 00 00 00 C7 44 24 08 0A 00 00 00 C6 44 24 4F 00 89 04 24 E8 ?? ?? ?? ?? B9 0E 00 00 00 8D 58 F2 89 DF F3 A4 89 4C 24 1C 89 E9 B8 0F 01 00 00 FF 15 ?? ?? ?? ?? 3D 00 F0 FF FF 0F 86 66 FF FF FF 8B 35 ?? ?? ?? ?? F7 D8 83 F8 14 65 89 06 74 18 7F 33 83 F8 02 74 3A 83 F8 0D 74 08 83 C8 FF E9 42 FF FF FF 85 ED 74 F4 65 C7 06 26 00 00 00 EB EB 31 D2 83 3D ?? ?? ?? ?? 00 0F 84 0C FF FF FF E9 65 FF FF FF 83 F8 24 74 DE 83 F8 28 75 CD EB D7 B9 01 00 00 00 8B 5C 24 70 8B 54 24 1C B8 37 00 00 00 FF 15 ?? ?? ?? ?? 3D 00 F0 FF FF 76 B8 F7 D8 65 89 06 83 C8 FF E9 E9 FE FF FF }
	condition:
		$1
}

rule file_50_0_0 {
	meta:
		name = "wmemset"
		size = 89
	strings:
		$1 = { 56 53 8B 74 24 14 8B 44 24 0C 8B 4C 24 10 83 FE 03 89 C2 76 2B 89 F3 90 83 EB 04 83 C2 10 89 4A F0 89 4A F4 89 4A F8 89 4A FC 83 FB 03 77 E9 8D 56 FC 83 E6 03 C1 EA 02 83 C2 01 C1 E2 04 01 C2 85 F6 74 12 83 FE 01 89 0A 74 0B 83 FE 03 89 4A 04 75 03 89 4A 08 5B 5E C3 }
	condition:
		$1
}

rule file_51_0_0 {
	meta:
		name = "fdatasync"
		size = 88
		refs = "0017 _dl_sysinfo 002a __libc_enable_asynccancel 0047 __libc_disable_asynccancel 0024 __syscall_error"
	strings:
		$1 = { 65 83 3D 0C 00 00 00 00 75 1F 89 DA 8B 5C 24 04 B8 94 00 00 00 FF 15 ?? ?? ?? ?? 89 D3 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 E8 ?? ?? ?? ?? 89 C1 89 DA 8B 5C 24 04 B8 94 00 00 00 FF 15 ?? ?? ?? ?? 89 D3 50 89 C8 E8 ?? ?? ?? ?? 58 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_51_1_0 {
	meta:
		name = "__fdatasync_nocancel"
		size = 31
		refs = "000d _dl_sysinfo 001a __syscall_error"
	strings:
		$1 = { 89 DA 8B 5C 24 04 B8 94 00 00 00 FF 15 ?? ?? ?? ?? 89 D3 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_52_0_0 {
	meta:
		name = "_dl_add_to_namespace_list"
		size = 148
		refs = "0008 __pthread_mutex_lock 0016 _dl_load_write_lock 0021 _dl_ns 0041 _dl_load_adds 0049 __pthread_mutex_unlock"
	strings:
		$1 = { 57 89 D7 56 89 C6 53 B8 ?? ?? ?? ?? 83 EC 10 85 C0 74 09 C7 04 24 ?? ?? ?? ?? FF D0 6B C7 4C 8B 98 ?? ?? ?? ?? 85 DB 75 09 EB 61 90 8D 74 26 00 89 CB 8B 4B 0C 85 C9 75 F7 89 5E 10 89 73 0C 8B 0D ?? ?? ?? ?? 6B FF 4C B8 ?? ?? ?? ?? 8B 1D ?? ?? ?? ?? 83 87 ?? ?? ?? ?? 01 89 8E 50 02 00 00 83 C1 01 89 9E 54 02 00 00 83 D3 00 85 C0 89 0D ?? ?? ?? ?? 89 1D ?? ?? ?? ?? 74 09 C7 04 24 ?? ?? ?? ?? FF D0 83 C4 10 5B 5E 5F C3 89 B0 ?? ?? ?? ?? EB AB }
	condition:
		$1
}

rule file_52_1_0 {
	meta:
		name = "_dl_new_object"
		size = 718
		refs = "0019 strlen 0031 calloc 0068 memcpy 00a1 _dl_debug_mask 00d4 _dl_ns 017e realloc 019b __getcwd 01a8 __libc_errno 01c5 free 0241 malloc 0264 mempcpy 02a8 strchr"
	strings:
		$1 = { 55 89 D5 57 56 53 83 EC 3C 89 14 24 8B 7C 24 50 89 4C 24 28 89 44 24 24 E8 ?? ?? ?? ?? C7 44 24 04 01 00 00 00 8D 70 01 05 69 02 00 00 89 04 24 E8 ?? ?? ?? ?? 85 C0 89 C3 0F 84 90 01 00 00 89 40 14 05 58 02 00 00 89 83 64 01 00 00 8D 83 5C 02 00 00 89 43 1C 8D 83 68 02 00 00 89 74 24 08 89 6C 24 04 89 04 24 E8 ?? ?? ?? ?? 0F B6 54 24 28 C7 83 64 02 00 00 01 00 00 00 83 E2 03 89 D6 89 83 5C 02 00 00 8B 44 24 24 89 43 04 0F B6 83 94 01 00 00 83 E0 FC 09 F0 88 83 94 01 00 00 F6 05 ?? ?? ?? ?? 01 0F 84 64 01 00 00 8B 54 24 58 8D 83 B8 01 00 00 89 83 CC 01 00 00 89 BB 6C 01 00 00 C7 83 C8 01 00 00 04 00 00 00 6B C2 4C 89 53 18 8B 80 ?? ?? ?? ?? 85 C0 0F 84 50 01 00 00 05 5C 01 00 00 B9 01 00 00 00 89 83 B8 01 00 00 85 FF 75 0E E9 26 01 00 00 8D B4 26 00 00 00 00 89 C7 8B 87 6C 01 00 00 85 C0 75 F4 85 C9 0F 85 CC 00 00 00 31 C0 8D 97 5C 01 00 00 89 94 03 B8 01 00 00 8D 83 5C 01 00 00 89 83 D0 01 00 00 8B 44 24 24 0F B6 08 84 C9 0F 84 91 00 00 00 89 04 24 31 ED 88 4C 24 1C E8 ?? ?? ?? ?? 0F B6 4C 24 1C 89 44 24 20 83 C0 01 80 F9 2F 89 44 24 28 0F 84 D3 00 00 00 89 5C 24 2C 89 EB 89 C5 8D 76 00 8D BD 80 00 00 00 89 7C 24 04 89 1C 24 E8 ?? ?? ?? ?? 85 C0 89 C6 0F 84 FC 00 00 00 8D 55 7F 2B 54 24 20 89 04 24 89 54 24 04 E8 ?? ?? ?? ?? 85 C0 0F 85 F1 00 00 00 A1 ?? ?? ?? ?? 89 F3 89 FD 65 83 38 22 74 BA 8B 5C 24 2C 89 F5 89 2C 24 BE FF FF FF FF E8 ?? ?? ?? ?? 89 B3 A8 01 00 00 83 C4 3C 89 D8 5B 5E 5F 5D C2 0C 00 90 8D 74 26 00 8B 83 B8 01 00 00 8D 97 5C 01 00 00 39 D0 0F 84 2F FF FF FF F6 44 24 54 08 0F 84 C5 00 00 00 89 83 BC 01 00 00 31 C0 E9 10 FF FF FF 8D 74 26 00 C7 83 FC 01 00 00 01 00 00 00 E9 8D FE FF FF 85 C9 89 DF 0F 84 EB FE FF FF EB B5 90 8D 74 26 00 31 C9 E9 B9 FE FF FF 90 89 04 24 90 8D 74 26 00 E8 ?? ?? ?? ?? 85 C0 89 C6 74 6F 90 8D 74 26 00 8B 54 24 28 89 04 24 89 54 24 08 8B 54 24 24 89 54 24 04 E8 ?? ?? ?? ?? EB 08 8D B6 00 00 00 00 89 C8 80 78 FF 2F 8D 48 FF 75 F5 39 CE 0F 44 C8 C6 01 00 E9 41 FF FF FF 89 DD 8B 5C 24 2C E9 29 FF FF FF 90 8D 74 26 00 C7 44 24 04 00 00 00 00 8B 5C 24 2C 89 34 24 E8 ?? ?? ?? ?? 80 78 FF 2F 74 9E C6 00 2F 83 C0 01 EB 96 BE FF FF FF FF E9 05 FF FF FF B8 04 00 00 00 E9 4E FE FF FF }
	condition:
		$1
}

rule file_54_0_0 {
	meta:
		name = "__atfct_seterrno_2"
		size = 648
		refs = "0042 __libc_errno 008d strchr 00a8 __lxstat64 0103 __fxstat64 017f __xstat64"
	strings:
		$1 = { 81 EC 8C 00 00 00 89 B4 24 84 00 00 00 8B B4 24 98 00 00 00 89 BC 24 88 00 00 00 8B BC 24 A0 00 00 00 89 9C 24 80 00 00 00 8B 9C 24 90 00 00 00 85 F6 0F 95 C0 85 FF 0F 95 C2 75 2C 84 C0 75 28 8B 35 ?? ?? ?? ?? 65 89 1E 8B 9C 24 80 00 00 00 8B B4 24 84 00 00 00 8B BC 24 88 00 00 00 81 C4 8C 00 00 00 C3 8D 76 00 83 FB 14 74 73 83 FB 02 75 CE 84 C0 0F 84 36 01 00 00 8D 46 0E C7 44 24 04 2F 00 00 00 89 04 24 88 54 24 1C E8 ?? ?? ?? ?? C6 00 00 8D 44 24 20 89 44 24 08 89 74 24 04 C7 04 24 03 00 00 00 E8 ?? ?? ?? ?? 0F B6 54 24 1C 83 F8 FF 0F 84 76 01 00 00 85 C0 0F 85 EE 00 00 00 8B 44 24 30 25 00 F0 00 00 3D 00 A0 00 00 0F 84 DA 00 00 00 BB 09 00 00 00 E9 60 FF FF FF 84 C0 74 44 8B 84 24 94 00 00 00 8D 74 24 20 89 74 24 08 C7 04 24 03 00 00 00 88 54 24 1C 89 44 24 04 E8 ?? ?? ?? ?? 0F B6 54 24 1C 85 C0 0F 85 35 FF FF FF 8B 44 24 30 25 00 F0 00 00 3D 00 40 00 00 0F 84 22 01 00 00 84 D2 0F 84 10 FF FF FF 8B 84 24 9C 00 00 00 8D 74 24 20 89 74 24 08 C7 04 24 03 00 00 00 89 44 24 04 E8 ?? ?? ?? ?? 85 C0 0F 85 F2 FE FF FF 8B 44 24 30 25 00 F0 00 00 3D 00 40 00 00 0F 85 D5 FE FF FF 89 74 24 08 C7 44 24 04 ?? ?? ?? ?? C7 04 24 03 00 00 00 E8 ?? ?? ?? ?? 85 C0 75 19 8B 44 24 30 25 00 F0 00 00 3D 00 40 00 00 0F 84 A5 FE FF FF 90 8D 74 26 00 BB 26 00 00 00 8B 35 ?? ?? ?? ?? E9 96 FE FF FF 8B 35 ?? ?? ?? ?? 84 D2 0F 84 88 FE FF FF 8D 47 0E C7 44 24 04 2F 00 00 00 89 04 24 E8 ?? ?? ?? ?? C6 00 00 8D 44 24 20 89 44 24 08 89 7C 24 04 C7 04 24 03 00 00 00 E8 ?? ?? ?? ?? 83 F8 FF 74 27 85 C0 0F 85 4D FE FF FF 8B 44 24 30 25 00 F0 00 00 3D 00 A0 00 00 B8 09 00 00 00 0F 45 D8 E9 32 FE FF FF 8D 74 26 00 65 83 3E 02 B8 09 00 00 00 0F 44 D8 E9 1D FE FF FF 8D B4 26 00 00 00 00 8B 35 ?? ?? ?? ?? 65 83 3E 02 0F 85 76 FF FF FF BB 09 00 00 00 E9 FC FD FF FF 89 74 24 08 C7 44 24 04 ?? ?? ?? ?? C7 04 24 03 00 00 00 E8 ?? ?? ?? ?? 0F B6 54 24 1C 85 C0 0F 85 31 FF FF FF 8B 44 24 30 25 00 F0 00 00 3D 00 40 00 00 0F 85 1D FF FF FF E9 A0 FE FF FF }
	condition:
		$1
}

rule file_54_1_0 {
	meta:
		name = "renameat"
		size = 388
		refs = "0007 __have_atfcts 002b _dl_sysinfo 0045 __libc_errno 007b strlen 00b7 __snprintf 0151 __atfct_seterrno_2"
	strings:
		$1 = { 55 89 E5 83 EC 48 A1 ?? ?? ?? ?? 89 75 F8 8B 75 14 89 5D F4 89 7D FC 85 C0 78 46 8B 5D 08 8B 4D 0C 8B 55 10 B8 2E 01 00 00 FF 15 ?? ?? ?? ?? 3D 00 F0 FF FF 77 0D 8B 5D F4 8B 75 F8 8B 7D FC 89 EC 5D C3 8B 15 ?? ?? ?? ?? F7 D8 83 F8 26 65 89 02 0F 85 FE 00 00 00 C7 05 ?? ?? ?? ?? FF FF FF FF 83 7D 08 9C 0F 84 F5 00 00 00 8B 4D 0C 80 39 2F 0F 84 E9 00 00 00 89 0C 24 E8 ?? ?? ?? ?? 85 C0 0F 84 E9 00 00 00 8D 50 20 83 C0 3E 8B 4D 0C 83 E0 F0 8B 5D 08 29 C4 8D 7C 24 23 83 E7 F0 89 4C 24 10 89 5C 24 0C C7 44 24 08 ?? ?? ?? ?? 89 54 24 04 89 3C 24 E8 ?? ?? ?? ?? 83 7D 10 9C 89 7D 0C 0F 84 A4 00 00 00 80 3E 2F 0F 84 9B 00 00 00 89 34 24 E8 ?? ?? ?? ?? 85 C0 0F 84 8F 00 00 00 8D 48 20 83 C0 3E 83 E0 F0 29 C4 8B 45 10 8D 54 24 23 83 E2 F0 89 74 24 10 89 14 24 89 44 24 0C C7 44 24 08 ?? ?? ?? ?? 89 4C 24 04 89 55 E4 E8 ?? ?? ?? ?? 8B 55 E4 89 D6 8B 5D 0C 89 F1 B8 26 00 00 00 FF 15 ?? ?? ?? ?? 3D 00 F0 FF FF 0F 86 01 FF FF FF 8B 5D 08 F7 D8 89 54 24 08 8B 55 10 89 7C 24 10 89 04 24 89 5C 24 0C 89 54 24 04 E8 ?? ?? ?? ?? 83 C8 FF E9 D9 FE FF FF 8D 76 00 31 FF 83 7D 10 9C 0F 85 5C FF FF FF 31 D2 EB AA A1 ?? ?? ?? ?? 65 C7 00 02 00 00 00 83 C8 FF E9 B2 FE FF FF }
	condition:
		$1
}

rule file_55_0_0 {
	meta:
		name = "__getdate_r"
		size = 1300
		refs = "002f getenv 0085 __xstat64 00b0 __access 00ce _IO_new_fopen 015f strptime 017f __getline 01ac free 01b9 _IO_new_fclose 01eb time 01fb __localtime_r 033e mktime"
	strings:
		$1 = { 81 EC FC 00 00 00 C7 04 24 ?? ?? ?? ?? 89 BC 24 F4 00 00 00 BF 01 00 00 00 89 9C 24 EC 00 00 00 89 B4 24 F0 00 00 00 89 AC 24 F8 00 00 00 E8 ?? ?? ?? ?? 85 C0 74 05 80 38 00 75 2C 89 F8 8B 9C 24 EC 00 00 00 8B B4 24 F0 00 00 00 8B BC 24 F4 00 00 00 8B AC 24 F8 00 00 00 81 C4 FC 00 00 00 C3 8D B4 26 00 00 00 00 89 C3 66 BF 03 00 8D 84 24 80 00 00 00 89 44 24 08 89 5C 24 04 C7 04 24 03 00 00 00 E8 ?? ?? ?? ?? 85 C0 78 AF 8B 84 24 90 00 00 00 66 BF 04 00 25 00 F0 00 00 3D 00 80 00 00 75 98 C7 44 24 04 04 00 00 00 89 1C 24 E8 ?? ?? ?? ?? 85 C0 79 0A BF 02 00 00 00 E9 7A FF FF FF 89 1C 24 C7 44 24 04 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 89 C3 74 E0 81 08 00 80 00 00 31 ED 8D 7C 24 20 C7 44 24 1C 00 00 00 00 8D 74 24 1C C7 44 24 20 00 00 00 00 EB 79 8D B6 00 00 00 00 8B 84 24 04 01 00 00 C7 40 18 00 00 00 80 C7 40 0C 00 00 00 80 C7 40 10 00 00 00 80 C7 40 14 00 00 00 80 C7 40 04 00 00 00 80 C7 00 00 00 00 80 C7 40 08 00 00 00 80 C7 40 20 FF FF FF FF C7 40 24 00 00 00 00 C7 40 28 00 00 00 00 89 54 24 04 8B 94 24 00 01 00 00 89 44 24 08 89 14 24 E8 ?? ?? ?? ?? 85 C0 89 C5 74 05 80 38 00 74 36 F6 03 10 75 31 89 5C 24 08 89 7C 24 04 89 34 24 E8 ?? ?? ?? ?? 85 C0 78 1D 8B 54 24 1C 8D 44 02 FF 80 38 0A 0F 85 68 FF FF FF C6 00 00 8B 54 24 1C E9 5C FF FF FF 8B 44 24 1C 89 04 24 E8 ?? ?? ?? ?? F6 03 20 89 1C 24 74 0F E8 ?? ?? ?? ?? BF 05 00 00 00 E9 75 FE FF FF E8 ?? ?? ?? ?? 85 ED BF 07 00 00 00 0F 84 63 FE FF FF 80 7D 00 00 0F 85 59 FE FF FF 8D 5C 24 24 89 1C 24 E8 ?? ?? ?? ?? 8D 44 24 28 89 1C 24 89 44 24 04 E8 ?? ?? ?? ?? 8B 8C 24 04 01 00 00 31 C0 8B 59 18 83 FB 06 77 0D 81 79 14 00 00 00 80 0F 84 2B 02 00 00 8B 8C 24 04 01 00 00 8B 51 10 83 FA 0B 77 0D 81 79 0C 00 00 00 80 0F 84 58 02 00 00 8B 8C 24 04 01 00 00 81 79 08 00 00 00 80 0F 84 6D 01 00 00 8B 94 24 04 01 00 00 81 7A 04 00 00 00 80 0F 84 4D 01 00 00 8B 8C 24 04 01 00 00 81 39 00 00 00 80 0F 84 2F 01 00 00 8B 9C 24 04 01 00 00 8B 53 08 83 FA 17 77 0D 81 7B 10 00 00 00 80 0F 84 46 01 00 00 8B 94 24 04 01 00 00 81 7A 14 00 00 00 80 0F 84 D8 00 00 00 8B 9C 24 04 01 00 00 81 7B 10 00 00 00 80 0F 84 B8 00 00 00 85 C0 75 77 8B 84 24 04 01 00 00 83 78 10 0B 8B 58 0C 8B 50 14 0F 87 89 00 00 00 8B 48 10 B8 00 00 50 AB D3 E0 85 C0 0F 88 81 00 00 00 B8 00 00 A0 14 D3 E0 85 C0 78 64 B8 00 00 00 40 D3 E0 85 C0 79 61 85 DB 7E 5D 8D 8A 6C 07 00 00 BE 1C 00 00 00 F6 C1 03 75 17 89 CA BF 64 00 00 00 C1 FA 1F 89 C8 F7 FF 85 D2 74 6E BE 1D 00 00 00 39 F3 BF 08 00 00 00 0F 8F 09 FD FF FF 8B 94 24 04 01 00 00 89 14 24 E8 ?? ?? ?? ?? 31 C9 83 C0 01 0F 94 C1 89 CF C1 E7 03 E9 E8 FC FF FF 83 EB 01 83 FB 1D 76 D7 BF 08 00 00 00 E9 D6 FC FF FF 83 EB 01 83 FB 1E 77 EE EB C3 8B 54 24 38 89 53 10 E9 3C FF FF FF 8B 54 24 3C 8B 8C 24 04 01 00 00 89 51 14 E9 15 FF FF FF 89 CA BF 90 01 00 00 C1 FA 1F 89 C8 F7 FF 85 D2 74 80 EB 83 C7 01 00 00 00 00 E9 C6 FE FF FF C7 42 04 00 00 00 00 E9 A7 FE FF FF 81 79 04 00 00 00 80 74 4E 8B 94 24 04 01 00 00 C7 42 08 00 00 00 00 E9 77 FE FF FF 81 7B 0C 00 00 00 80 0F 85 AD FE FF FF 81 7B 18 00 00 00 80 0F 85 A0 FE FF FF 8B 44 24 38 89 43 10 89 D0 2B 44 24 30 C1 E8 1F 03 44 24 34 89 43 0C B8 01 00 00 00 E9 7F FE FF FF 8B 8C 24 04 01 00 00 81 39 00 00 00 80 75 A3 8B 54 24 30 8B 9C 24 04 01 00 00 89 51 08 8B 4C 24 2C 81 FA 00 00 00 80 89 4B 04 8B 4C 24 28 89 0B 74 80 E9 05 FE FF FF 81 79 10 00 00 00 80 0F 85 C8 FD FF FF 81 79 0C 00 00 00 80 0F 85 D7 FD FF FF 8B 44 24 3C 89 41 14 8B 44 24 38 89 41 10 89 D8 2B 44 24 40 83 C0 07 89 C2 C1 FA 1F F7 FF B8 01 00 00 00 03 54 24 34 89 51 0C E9 8C FD FF FF 81 79 14 00 00 00 80 75 10 89 D0 2B 44 24 38 C1 E8 1F 03 44 24 3C 89 41 14 8B 84 24 04 01 00 00 81 FB 00 00 00 80 8B 68 14 B8 01 00 00 00 74 3F 8D 74 24 54 30 C0 B9 0B 00 00 00 89 F7 F3 AB 89 34 24 89 54 24 64 89 6C 24 68 C7 44 24 60 01 00 00 00 E8 ?? ?? ?? ?? 89 D8 B9 07 00 00 00 2B 44 24 6C 83 C0 07 89 C2 C1 FA 1F F7 F9 8D 42 01 8B 94 24 04 01 00 00 89 42 0C B8 01 00 00 00 E9 25 FD FF FF }
	condition:
		$1
}

rule file_55_1_0 {
	meta:
		name = "getdate"
		size = 53
		refs = "0013 __getdate_r 002b getdate_err"
	strings:
		$1 = { 83 EC 1C 8B 44 24 20 C7 44 24 04 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? BA ?? ?? ?? ?? 85 C0 75 08 89 D0 83 C4 1C C3 66 90 31 D2 A3 ?? ?? ?? ?? 89 D0 83 C4 1C C3 }
	condition:
		$1
}

rule file_56_0_0 {
	meta:
		name = "__nss_ethers_lookup2"
		size = 135
		refs = "0009 __nss_ethers_database 002d __nss_lookup 0068 __nss_database_lookup"
	strings:
		$1 = { 83 EC 2C 89 5C 24 24 8B 1D ?? ?? ?? ?? 89 74 24 28 89 C6 85 DB 74 29 8B 44 24 30 89 1E 89 4C 24 08 89 54 24 04 89 44 24 0C 89 34 24 E8 ?? ?? ?? ?? 8B 5C 24 24 8B 74 24 28 83 C4 2C C2 04 00 90 C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 00 00 00 00 C7 44 24 04 00 00 00 00 C7 04 24 ?? ?? ?? ?? 89 54 24 1C 89 4C 24 18 E8 ?? ?? ?? ?? 8B 54 24 1C 8B 4C 24 18 85 C0 78 08 8B 1D ?? ?? ?? ?? EB 97 B8 FF FF FF FF EB AA }
	condition:
		$1
}

rule file_878_0_0 {
	meta:
		name = "__nss_aliases_lookup2"
		size = 135
		refs = "0009 __nss_aliases_database 002d __nss_lookup 0068 __nss_database_lookup"
	strings:
		$1 = { 83 EC 2C 89 5C 24 24 8B 1D ?? ?? ?? ?? 89 74 24 28 89 C6 85 DB 74 29 8B 44 24 30 89 1E 89 4C 24 08 89 54 24 04 89 44 24 0C 89 34 24 E8 ?? ?? ?? ?? 8B 5C 24 24 8B 74 24 28 83 C4 2C C2 04 00 90 C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 00 00 00 00 C7 44 24 04 00 00 00 00 C7 04 24 ?? ?? ?? ?? 89 54 24 1C 89 4C 24 18 E8 ?? ?? ?? ?? 8B 54 24 1C 8B 4C 24 18 85 C0 78 08 8B 1D ?? ?? ?? ?? EB 97 B8 FF FF FF FF EB AA }
	condition:
		$1
}

rule file_1150_0_0 {
	meta:
		name = "__nss_group_lookup2"
		size = 135
		refs = "0009 __nss_group_database 002d __nss_lookup 0068 __nss_database_lookup"
	strings:
		$1 = { 83 EC 2C 89 5C 24 24 8B 1D ?? ?? ?? ?? 89 74 24 28 89 C6 85 DB 74 29 8B 44 24 30 89 1E 89 4C 24 08 89 54 24 04 89 44 24 0C 89 34 24 E8 ?? ?? ?? ?? 8B 5C 24 24 8B 74 24 28 83 C4 2C C2 04 00 90 C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 ?? ?? ?? ?? C7 44 24 04 00 00 00 00 C7 04 24 ?? ?? ?? ?? 89 54 24 1C 89 4C 24 18 E8 ?? ?? ?? ?? 8B 54 24 1C 8B 4C 24 18 85 C0 78 08 8B 1D ?? ?? ?? ?? EB 97 B8 FF FF FF FF EB AA }
	condition:
		$1
}

rule file_432_0_0 {
	meta:
		name = "__nss_gshadow_lookup2"
		size = 135
		refs = "0009 __nss_gshadow_database 002d __nss_lookup 0068 __nss_database_lookup"
	strings:
		$1 = { 83 EC 2C 89 5C 24 24 8B 1D ?? ?? ?? ?? 89 74 24 28 89 C6 85 DB 74 29 8B 44 24 30 89 1E 89 4C 24 08 89 54 24 04 89 44 24 0C 89 34 24 E8 ?? ?? ?? ?? 8B 5C 24 24 8B 74 24 28 83 C4 2C C2 04 00 90 C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 ?? ?? ?? ?? C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? 89 54 24 1C 89 4C 24 18 E8 ?? ?? ?? ?? 8B 54 24 1C 8B 4C 24 18 85 C0 78 08 8B 1D ?? ?? ?? ?? EB 97 B8 FF FF FF FF EB AA }
	condition:
		$1
}

rule file_926_0_0 {
	meta:
		name = "__nss_hosts_lookup2"
		size = 135
		refs = "0009 __nss_hosts_database 002d __nss_lookup 0068 __nss_database_lookup"
	strings:
		$1 = { 83 EC 2C 89 5C 24 24 8B 1D ?? ?? ?? ?? 89 74 24 28 89 C6 85 DB 74 29 8B 44 24 30 89 1E 89 4C 24 08 89 54 24 04 89 44 24 0C 89 34 24 E8 ?? ?? ?? ?? 8B 5C 24 24 8B 74 24 28 83 C4 2C C2 04 00 90 C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 ?? ?? ?? ?? C7 44 24 04 00 00 00 00 C7 04 24 ?? ?? ?? ?? 89 54 24 1C 89 4C 24 18 E8 ?? ?? ?? ?? 8B 54 24 1C 8B 4C 24 18 85 C0 78 08 8B 1D ?? ?? ?? ?? EB 97 B8 FF FF FF FF EB AA }
	condition:
		$1
}

rule file_826_0_0 {
	meta:
		name = "__nss_netgroup_lookup2"
		size = 135
		refs = "0009 __nss_netgroup_database 002d __nss_lookup 0068 __nss_database_lookup"
	strings:
		$1 = { 83 EC 2C 89 5C 24 24 8B 1D ?? ?? ?? ?? 89 74 24 28 89 C6 85 DB 74 29 8B 44 24 30 89 1E 89 4C 24 08 89 54 24 04 89 44 24 0C 89 34 24 E8 ?? ?? ?? ?? 8B 5C 24 24 8B 74 24 28 83 C4 2C C2 04 00 90 C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 00 00 00 00 C7 44 24 04 00 00 00 00 C7 04 24 ?? ?? ?? ?? 89 54 24 1C 89 4C 24 18 E8 ?? ?? ?? ?? 8B 54 24 1C 8B 4C 24 18 85 C0 78 08 8B 1D ?? ?? ?? ?? EB 97 B8 FF FF FF FF EB AA }
	condition:
		$1
}

rule file_735_0_0 {
	meta:
		name = "__nss_networks_lookup2"
		size = 135
		refs = "0009 __nss_networks_database 002d __nss_lookup 0068 __nss_database_lookup"
	strings:
		$1 = { 83 EC 2C 89 5C 24 24 8B 1D ?? ?? ?? ?? 89 74 24 28 89 C6 85 DB 74 29 8B 44 24 30 89 1E 89 4C 24 08 89 54 24 04 89 44 24 0C 89 34 24 E8 ?? ?? ?? ?? 8B 5C 24 24 8B 74 24 28 83 C4 2C C2 04 00 90 C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 ?? ?? ?? ?? C7 44 24 04 00 00 00 00 C7 04 24 ?? ?? ?? ?? 89 54 24 1C 89 4C 24 18 E8 ?? ?? ?? ?? 8B 54 24 1C 8B 4C 24 18 85 C0 78 08 8B 1D ?? ?? ?? ?? EB 97 B8 FF FF FF FF EB AA }
	condition:
		$1
}

rule file_1313_0_0 {
	meta:
		name = "__nss_passwd_lookup2"
		size = 135
		refs = "0009 __nss_passwd_database 002d __nss_lookup 0068 __nss_database_lookup"
	strings:
		$1 = { 83 EC 2C 89 5C 24 24 8B 1D ?? ?? ?? ?? 89 74 24 28 89 C6 85 DB 74 29 8B 44 24 30 89 1E 89 4C 24 08 89 54 24 04 89 44 24 0C 89 34 24 E8 ?? ?? ?? ?? 8B 5C 24 24 8B 74 24 28 83 C4 2C C2 04 00 90 C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 ?? ?? ?? ?? C7 44 24 04 00 00 00 00 C7 04 24 ?? ?? ?? ?? 89 54 24 1C 89 4C 24 18 E8 ?? ?? ?? ?? 8B 54 24 1C 8B 4C 24 18 85 C0 78 08 8B 1D ?? ?? ?? ?? EB 97 B8 FF FF FF FF EB AA }
	condition:
		$1
}

rule file_660_0_0 {
	meta:
		name = "__nss_protocols_lookup2"
		size = 135
		refs = "0009 __nss_protocols_database 002d __nss_lookup 0068 __nss_database_lookup"
	strings:
		$1 = { 83 EC 2C 89 5C 24 24 8B 1D ?? ?? ?? ?? 89 74 24 28 89 C6 85 DB 74 29 8B 44 24 30 89 1E 89 4C 24 08 89 54 24 04 89 44 24 0C 89 34 24 E8 ?? ?? ?? ?? 8B 5C 24 24 8B 74 24 28 83 C4 2C C2 04 00 90 C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 00 00 00 00 C7 44 24 04 00 00 00 00 C7 04 24 ?? ?? ?? ?? 89 54 24 1C 89 4C 24 18 E8 ?? ?? ?? ?? 8B 54 24 1C 8B 4C 24 18 85 C0 78 08 8B 1D ?? ?? ?? ?? EB 97 B8 FF FF FF FF EB AA }
	condition:
		$1
}

rule file_614_0_0 {
	meta:
		name = "__nss_publickey_lookup2"
		size = 135
		refs = "0009 __nss_publickey_database 002d __nss_lookup 0068 __nss_database_lookup"
	strings:
		$1 = { 83 EC 2C 89 5C 24 24 8B 1D ?? ?? ?? ?? 89 74 24 28 89 C6 85 DB 74 29 8B 44 24 30 89 1E 89 4C 24 08 89 54 24 04 89 44 24 0C 89 34 24 E8 ?? ?? ?? ?? 8B 5C 24 24 8B 74 24 28 83 C4 2C C2 04 00 90 C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 ?? ?? ?? ?? C7 44 24 04 00 00 00 00 C7 04 24 ?? ?? ?? ?? 89 54 24 1C 89 4C 24 18 E8 ?? ?? ?? ?? 8B 54 24 1C 8B 4C 24 18 85 C0 78 08 8B 1D ?? ?? ?? ?? EB 97 B8 FF FF FF FF EB AA }
	condition:
		$1
}

rule file_280_0_0 {
	meta:
		name = "__nss_rpc_lookup2"
		size = 135
		refs = "0009 __nss_rpc_database 002d __nss_lookup 0068 __nss_database_lookup"
	strings:
		$1 = { 83 EC 2C 89 5C 24 24 8B 1D ?? ?? ?? ?? 89 74 24 28 89 C6 85 DB 74 29 8B 44 24 30 89 1E 89 4C 24 08 89 54 24 04 89 44 24 0C 89 34 24 E8 ?? ?? ?? ?? 8B 5C 24 24 8B 74 24 28 83 C4 2C C2 04 00 90 C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 00 00 00 00 C7 44 24 04 00 00 00 00 C7 04 24 ?? ?? ?? ?? 89 54 24 1C 89 4C 24 18 E8 ?? ?? ?? ?? 8B 54 24 1C 8B 4C 24 18 85 C0 78 08 8B 1D ?? ?? ?? ?? EB 97 B8 FF FF FF FF EB AA }
	condition:
		$1
}

rule file_656_0_0 {
	meta:
		name = "__nss_services_lookup2"
		size = 135
		refs = "0009 __nss_services_database 002d __nss_lookup 0068 __nss_database_lookup"
	strings:
		$1 = { 83 EC 2C 89 5C 24 24 8B 1D ?? ?? ?? ?? 89 74 24 28 89 C6 85 DB 74 29 8B 44 24 30 89 1E 89 4C 24 08 89 54 24 04 89 44 24 0C 89 34 24 E8 ?? ?? ?? ?? 8B 5C 24 24 8B 74 24 28 83 C4 2C C2 04 00 90 C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 00 00 00 00 C7 44 24 04 00 00 00 00 C7 04 24 ?? ?? ?? ?? 89 54 24 1C 89 4C 24 18 E8 ?? ?? ?? ?? 8B 54 24 1C 8B 4C 24 18 85 C0 78 08 8B 1D ?? ?? ?? ?? EB 97 B8 FF FF FF FF EB AA }
	condition:
		$1
}

rule file_477_0_0 {
	meta:
		name = "__nss_shadow_lookup2"
		size = 135
		refs = "0009 __nss_shadow_database 002d __nss_lookup 0068 __nss_database_lookup"
	strings:
		$1 = { 83 EC 2C 89 5C 24 24 8B 1D ?? ?? ?? ?? 89 74 24 28 89 C6 85 DB 74 29 8B 44 24 30 89 1E 89 4C 24 08 89 54 24 04 89 44 24 0C 89 34 24 E8 ?? ?? ?? ?? 8B 5C 24 24 8B 74 24 28 83 C4 2C C2 04 00 90 C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 ?? ?? ?? ?? C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? 89 54 24 1C 89 4C 24 18 E8 ?? ?? ?? ?? 8B 54 24 1C 8B 4C 24 18 85 C0 78 08 8B 1D ?? ?? ?? ?? EB 97 B8 FF FF FF FF EB AA }
	condition:
		$1
}

rule file_56_1_0 {
	meta:
		name = "__nss_ethers_lookup"
		size = 20
		refs = "0009 __nss_ethers_lookup2"
	strings:
		$1 = { 83 EC 1C 89 0C 24 31 C9 E8 ?? ?? ?? ?? 83 EC 04 83 C4 1C C3 }
	condition:
		$1
}

rule file_878_1_0 {
	meta:
		name = "__nss_aliases_lookup"
		size = 20
		refs = "0009 __nss_aliases_lookup2"
	strings:
		$1 = { 83 EC 1C 89 0C 24 31 C9 E8 ?? ?? ?? ?? 83 EC 04 83 C4 1C C3 }
	condition:
		$1
}

rule file_1150_1_0 {
	meta:
		name = "__nss_group_lookup"
		size = 20
		refs = "0009 __nss_group_lookup2"
	strings:
		$1 = { 83 EC 1C 89 0C 24 31 C9 E8 ?? ?? ?? ?? 83 EC 04 83 C4 1C C3 }
	condition:
		$1
}

rule file_432_1_0 {
	meta:
		name = "__nss_gshadow_lookup"
		size = 20
		refs = "0009 __nss_gshadow_lookup2"
	strings:
		$1 = { 83 EC 1C 89 0C 24 31 C9 E8 ?? ?? ?? ?? 83 EC 04 83 C4 1C C3 }
	condition:
		$1
}

rule file_926_1_0 {
	meta:
		name = "__nss_hosts_lookup"
		size = 20
		refs = "0009 __nss_hosts_lookup2"
	strings:
		$1 = { 83 EC 1C 89 0C 24 31 C9 E8 ?? ?? ?? ?? 83 EC 04 83 C4 1C C3 }
	condition:
		$1
}

rule file_826_1_0 {
	meta:
		name = "__nss_netgroup_lookup"
		size = 20
		refs = "0009 __nss_netgroup_lookup2"
	strings:
		$1 = { 83 EC 1C 89 0C 24 31 C9 E8 ?? ?? ?? ?? 83 EC 04 83 C4 1C C3 }
	condition:
		$1
}

rule file_735_1_0 {
	meta:
		name = "__nss_networks_lookup"
		size = 20
		refs = "0009 __nss_networks_lookup2"
	strings:
		$1 = { 83 EC 1C 89 0C 24 31 C9 E8 ?? ?? ?? ?? 83 EC 04 83 C4 1C C3 }
	condition:
		$1
}

rule file_1313_1_0 {
	meta:
		name = "__nss_passwd_lookup"
		size = 20
		refs = "0009 __nss_passwd_lookup2"
	strings:
		$1 = { 83 EC 1C 89 0C 24 31 C9 E8 ?? ?? ?? ?? 83 EC 04 83 C4 1C C3 }
	condition:
		$1
}

rule file_660_1_0 {
	meta:
		name = "__nss_protocols_lookup"
		size = 20
		refs = "0009 __nss_protocols_lookup2"
	strings:
		$1 = { 83 EC 1C 89 0C 24 31 C9 E8 ?? ?? ?? ?? 83 EC 04 83 C4 1C C3 }
	condition:
		$1
}

rule file_614_1_0 {
	meta:
		name = "__nss_publickey_lookup"
		size = 20
		refs = "0009 __nss_publickey_lookup2"
	strings:
		$1 = { 83 EC 1C 89 0C 24 31 C9 E8 ?? ?? ?? ?? 83 EC 04 83 C4 1C C3 }
	condition:
		$1
}

rule file_280_1_0 {
	meta:
		name = "__nss_rpc_lookup"
		size = 20
		refs = "0009 __nss_rpc_lookup2"
	strings:
		$1 = { 83 EC 1C 89 0C 24 31 C9 E8 ?? ?? ?? ?? 83 EC 04 83 C4 1C C3 }
	condition:
		$1
}

rule file_477_1_0 {
	meta:
		name = "__nss_shadow_lookup"
		size = 20
		refs = "0009 __nss_shadow_lookup2"
	strings:
		$1 = { 83 EC 1C 89 0C 24 31 C9 E8 ?? ?? ?? ?? 83 EC 04 83 C4 1C C3 }
	condition:
		$1
}

rule file_58_0_0 {
	meta:
		name = "__setstate_r"
		size = 235
		refs = "00d9 __libc_errno"
	strings:
		$1 = { 83 EC 10 8B 4C 24 18 89 1C 24 8B 5C 24 14 89 74 24 04 89 7C 24 08 85 C9 89 6C 24 0C 8D 73 04 0F 84 B3 00 00 00 85 DB 0F 84 AB 00 00 00 8B 79 0C 8B 51 08 85 FF 0F 84 8D 00 00 00 8B 41 04 29 D0 C1 F8 02 8D 04 80 01 C7 89 7A FC 8B 3B B8 67 66 66 66 F7 EF 89 F8 C1 F8 1F D1 FA 29 C2 8D 04 92 89 FA 29 C2 83 FA 04 77 6F 8B 3C 95 ?? ?? ?? ?? 85 D2 8B 2C 95 ?? ?? ?? ?? 89 51 0C 89 79 10 89 69 14 74 25 8B 1B B8 67 66 66 66 F7 EB C1 FB 1F D1 FA 29 DA 8D 04 96 89 41 04 8D 04 2A 89 C2 C1 FA 1F F7 FF 8D 04 96 89 01 8D 04 BE 89 41 18 31 C0 89 71 08 8B 1C 24 8B 74 24 04 8B 7C 24 08 8B 6C 24 0C 83 C4 10 C3 90 C7 42 FC 00 00 00 00 E9 77 FF FF FF 8D 74 26 00 A1 ?? ?? ?? ?? 65 C7 00 16 00 00 00 B8 FF FF FF FF EB C9 }
	condition:
		$1
}

rule file_58_1_0 {
	meta:
		name = "__random_r"
		size = 155
		refs = "0089 __libc_errno"
	strings:
		$1 = { 83 EC 10 8B 54 24 18 89 1C 24 8B 44 24 14 89 74 24 04 89 7C 24 08 85 D2 89 6C 24 0C 74 6A 85 C0 74 66 8B 48 0C 8B 70 08 85 C9 74 44 8B 18 8B 78 04 8B 68 18 8B 0B 83 C3 04 03 0F 83 C7 04 89 4B FC D1 E9 39 DD 89 0A 76 1F 39 FD 0F 46 FE 89 18 89 78 04 31 C0 8B 1C 24 8B 74 24 04 8B 7C 24 08 8B 6C 24 0C 83 C4 10 C3 89 F3 EB E2 8D 74 26 00 69 06 6D 4E C6 41 05 39 30 00 00 25 FF FF FF 7F 89 06 89 02 31 C0 EB CD A1 ?? ?? ?? ?? 65 C7 00 16 00 00 00 B8 FF FF FF FF EB BA }
	condition:
		$1
}

rule file_58_2_0 {
	meta:
		name = "__srandom_r"
		size = 205
		refs = "00b3 __random_r"
	strings:
		$1 = { 55 57 56 53 83 EC 18 8B 74 24 30 8B 54 24 2C 85 F6 0F 84 AF 00 00 00 8B 46 0C 83 F8 04 0F 87 A3 00 00 00 8B 7E 08 85 D2 B9 01 00 00 00 0F 45 CA 85 C0 89 0F 0F 84 82 00 00 00 8B 6E 10 BB 01 00 00 00 83 FD 01 7E 3F 90 B8 5F 0B 4E 83 F7 E9 89 C8 C1 F8 1F 01 CA C1 FA 10 29 C2 69 C2 1D F3 01 00 69 D2 EC F4 FF FF 29 C1 69 C9 A7 41 00 00 01 D1 85 C9 8D 81 FF FF FF 7F 0F 48 C8 89 0C 9F 83 C3 01 39 EB 75 C2 8B 46 14 89 7E 04 8D 04 87 89 06 8D 44 AD 00 8D 5C 00 FF 85 DB 8D 7C 24 14 78 1B 8D B4 26 00 00 00 00 89 7C 24 04 83 EB 01 89 34 24 E8 ?? ?? ?? ?? 83 FB FF 75 EC 31 C0 83 C4 18 5B 5E 5F 5D C3 B8 FF FF FF FF EB F1 }
	condition:
		$1
}

rule file_58_3_0 {
	meta:
		name = "__initstate_r"
		size = 320
		refs = "0081 __srandom_r 012b __libc_errno"
	strings:
		$1 = { 83 EC 18 89 5C 24 08 8B 5C 24 28 89 7C 24 10 8B 44 24 24 89 74 24 0C 8B 7C 24 20 89 6C 24 14 85 DB 0F 84 03 01 00 00 8B 53 08 85 D2 74 12 8B 73 0C 85 F6 0F 85 C7 00 00 00 C7 42 FC 00 00 00 00 83 F8 7F 77 63 83 F8 1F 0F 87 D2 00 00 00 83 F8 07 0F 86 D3 00 00 00 8D 47 04 89 43 18 89 43 08 8B 44 24 1C C7 43 0C 00 00 00 00 C7 43 14 00 00 00 00 C7 43 10 00 00 00 00 89 5C 24 04 89 04 24 E8 ?? ?? ?? ?? 31 C0 C7 07 00 00 00 00 8B 5C 24 08 8B 74 24 0C 8B 7C 24 10 8B 6C 24 14 83 C4 18 C3 8D B4 26 00 00 00 00 3D 00 01 00 00 19 F6 83 C6 04 8B 04 B5 ?? ?? ?? ?? 8D 6F 04 8B 14 B5 ?? ?? ?? ?? 89 73 0C 89 6B 08 89 43 10 8D 44 85 00 89 43 18 8B 44 24 1C 89 53 14 89 5C 24 04 89 04 24 E8 ?? ?? ?? ?? 8B 43 04 29 E8 C1 F8 02 8D 04 80 01 C6 31 C0 89 37 EB 94 8D B4 26 00 00 00 00 8B 4B 04 29 D1 C1 F9 02 8D 0C 89 01 CE 83 F8 7F 89 72 FC 0F 86 2C FF FF FF EB 8D 90 8D 74 26 00 83 F8 40 19 F6 83 C6 02 EB 88 A1 ?? ?? ?? ?? 65 C7 00 16 00 00 00 B8 FF FF FF FF E9 4D FF FF FF }
	condition:
		$1
}

rule file_59_3_0 {
	meta:
		name = "fputwc"
		size = 245
		refs = "0050 _IO_fwide 00bb __woverflow 00f1 _Unwind_Resume"
	strings:
		$1 = { 56 53 83 EC 14 8B 5C 24 24 8B 03 25 00 80 00 00 75 32 8B 53 48 65 8B 35 08 00 00 00 3B 72 08 74 1F B9 01 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 0A 0F 85 BB 00 00 00 8B 53 48 89 72 08 83 42 04 01 C7 44 24 04 01 00 00 00 89 1C 24 E8 ?? ?? ?? ?? 85 C0 78 50 8B 43 58 85 C0 74 50 8B 48 10 3B 48 14 73 48 8B 54 24 20 83 C1 04 89 51 FC 89 48 10 F7 03 00 80 00 00 75 20 8B 4B 48 83 69 04 01 75 17 C7 41 08 00 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 83 29 01 75 65 83 C4 14 89 D0 5B 5E C3 8D 74 26 00 BA FF FF FF FF EB C5 8B 44 24 20 89 1C 24 89 44 24 04 E8 ?? ?? ?? ?? 89 C2 EB B1 F7 03 00 80 00 00 89 C6 75 20 8B 53 48 83 6A 04 01 75 17 C7 42 08 00 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 83 2A 01 75 1D 89 34 24 E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_60_0_0 {
	meta:
		name = "__towctrans_l"
		size = 91
		altNames = "__towctrans"
	strings:
		$1 = { 83 EC 08 8B 54 24 10 89 1C 24 8B 44 24 0C 89 74 24 04 85 D2 74 3A 8B 0A 89 C3 D3 EB 3B 5A 04 73 2F 8B 5C 9A 14 85 DB 74 27 8B 4A 08 89 C6 D3 EE 8B 4A 0C 21 F1 8D 0C 8B 8B 0C 0A 85 C9 74 11 8B 5A 10 21 C3 8D 0C 99 03 04 0A 8D B6 00 00 00 00 8B 1C 24 8B 74 24 04 83 C4 08 C3 }
	condition:
		$1
}

rule file_61_0_0 {
	meta:
		name = "wcscmp"
		size = 49
	strings:
		$1 = { 53 8B 4C 24 08 8B 54 24 0C 8D B4 26 00 00 00 00 8B 1A 83 C1 04 83 C2 04 8B 41 FC 85 DB 74 10 39 D8 74 ED 39 C3 0F 9E C0 0F B6 C0 8D 44 00 FF 5B C3 }
	condition:
		$1
}

rule file_62_0_0 {
	meta:
		name = "__iswalnum_l"
		size = 156
	strings:
		$1 = { 83 EC 0C 8B 54 24 10 89 1C 24 8B 44 24 14 89 74 24 04 89 7C 24 08 F7 C2 80 FF FF FF 74 62 8B 00 8B 48 68 8B 5C 88 50 89 D0 8B 0B D3 E8 89 C1 31 C0 3B 4B 04 73 3A 8B 74 8B 14 85 F6 74 32 8B 4B 08 89 D7 D3 EF 8B 4B 0C 21 F9 8D 0C 8E 8B 0C 0B 85 C9 74 1C 89 D0 C1 E8 05 23 43 10 8D 04 81 89 D1 8B 04 03 D3 E8 83 E0 01 8D B4 26 00 00 00 00 8B 1C 24 8B 74 24 04 8B 7C 24 08 83 C4 0C C3 90 8B 40 34 8B 1C 24 8B 74 24 04 8B 7C 24 08 0F B7 04 50 83 C4 0C 83 E0 08 0F B7 C0 C3 }
	condition:
		$1
}

rule file_62_1_0 {
	meta:
		name = "__iswalpha_l"
		size = 157
	strings:
		$1 = { 83 EC 0C 8B 54 24 10 89 1C 24 8B 44 24 14 89 74 24 04 89 7C 24 08 F7 C2 80 FF FF FF 74 62 8B 00 8B 48 68 8B 5C 88 2C 89 D0 8B 0B D3 E8 89 C1 31 C0 3B 4B 04 73 3A 8B 74 8B 14 85 F6 74 32 8B 4B 08 89 D7 D3 EF 8B 4B 0C 21 F9 8D 0C 8E 8B 0C 0B 85 C9 74 1C 89 D0 C1 E8 05 23 43 10 8D 04 81 89 D1 8B 04 03 D3 E8 83 E0 01 8D B4 26 00 00 00 00 8B 1C 24 8B 74 24 04 8B 7C 24 08 83 C4 0C C3 90 8B 40 34 8B 1C 24 8B 74 24 04 8B 7C 24 08 0F B7 04 50 83 C4 0C 66 25 00 04 0F B7 C0 C3 }
	condition:
		$1
}

rule file_62_2_0 {
	meta:
		name = "__iswblank_l"
		size = 153
	strings:
		$1 = { 83 EC 0C 8B 54 24 10 89 1C 24 8B 44 24 14 89 74 24 04 89 7C 24 08 F7 C2 80 FF FF FF 74 62 8B 00 8B 48 68 8B 5C 88 44 89 D0 8B 0B D3 E8 89 C1 31 C0 3B 4B 04 73 3A 8B 74 8B 14 85 F6 74 32 8B 4B 08 89 D7 D3 EF 8B 4B 0C 21 F9 8D 0C 8E 8B 0C 0B 85 C9 74 1C 89 D0 C1 E8 05 23 43 10 8D 04 81 89 D1 8B 04 03 D3 E8 83 E0 01 8D B4 26 00 00 00 00 8B 1C 24 8B 74 24 04 8B 7C 24 08 83 C4 0C C3 90 8B 40 34 8B 1C 24 8B 74 24 04 8B 7C 24 08 0F B7 04 50 83 C4 0C 83 E0 01 C3 }
	condition:
		$1
}

rule file_62_3_0 {
	meta:
		name = "__iswcntrl_l"
		size = 156
	strings:
		$1 = { 83 EC 0C 8B 54 24 10 89 1C 24 8B 44 24 14 89 74 24 04 89 7C 24 08 F7 C2 80 FF FF FF 74 62 8B 00 8B 48 68 8B 5C 88 48 89 D0 8B 0B D3 E8 89 C1 31 C0 3B 4B 04 73 3A 8B 74 8B 14 85 F6 74 32 8B 4B 08 89 D7 D3 EF 8B 4B 0C 21 F9 8D 0C 8E 8B 0C 0B 85 C9 74 1C 89 D0 C1 E8 05 23 43 10 8D 04 81 89 D1 8B 04 03 D3 E8 83 E0 01 8D B4 26 00 00 00 00 8B 1C 24 8B 74 24 04 8B 7C 24 08 83 C4 0C C3 90 8B 40 34 8B 1C 24 8B 74 24 04 8B 7C 24 08 0F B7 04 50 83 C4 0C 83 E0 02 0F B7 C0 C3 }
	condition:
		$1
}

rule file_62_4_0 {
	meta:
		name = "__iswdigit_l"
		size = 154
	strings:
		$1 = { 83 EC 0C 8B 54 24 10 89 1C 24 89 74 24 04 89 7C 24 08 F7 C2 80 FF FF FF 74 66 8B 44 24 14 8B 00 8B 48 68 8B 5C 88 30 89 D0 8B 0B D3 E8 89 C1 31 C0 3B 4B 04 73 3A 8B 74 8B 14 85 F6 74 32 8B 4B 08 89 D7 D3 EF 8B 4B 0C 21 F9 8D 0C 8E 8B 0C 0B 85 C9 74 1C 89 D0 C1 E8 05 23 43 10 8D 04 81 89 D1 8B 04 03 D3 E8 83 E0 01 8D B4 26 00 00 00 00 8B 1C 24 8B 74 24 04 8B 7C 24 08 83 C4 0C C3 90 83 EA 30 31 C0 8B 1C 24 83 FA 09 8B 74 24 04 0F 96 C0 8B 7C 24 08 83 C4 0C C3 }
	condition:
		$1
}

rule file_62_5_0 {
	meta:
		name = "__iswlower_l"
		size = 157
	strings:
		$1 = { 83 EC 0C 8B 54 24 10 89 1C 24 8B 44 24 14 89 74 24 04 89 7C 24 08 F7 C2 80 FF FF FF 74 62 8B 00 8B 48 68 8B 5C 88 28 89 D0 8B 0B D3 E8 89 C1 31 C0 3B 4B 04 73 3A 8B 74 8B 14 85 F6 74 32 8B 4B 08 89 D7 D3 EF 8B 4B 0C 21 F9 8D 0C 8E 8B 0C 0B 85 C9 74 1C 89 D0 C1 E8 05 23 43 10 8D 04 81 89 D1 8B 04 03 D3 E8 83 E0 01 8D B4 26 00 00 00 00 8B 1C 24 8B 74 24 04 8B 7C 24 08 83 C4 0C C3 90 8B 40 34 8B 1C 24 8B 74 24 04 8B 7C 24 08 0F B7 04 50 83 C4 0C 66 25 00 02 0F B7 C0 C3 }
	condition:
		$1
}

rule file_62_6_0 {
	meta:
		name = "__iswgraph_l"
		size = 157
	strings:
		$1 = { 83 EC 0C 8B 54 24 10 89 1C 24 8B 44 24 14 89 74 24 04 89 7C 24 08 F7 C2 80 FF FF FF 74 62 8B 00 8B 48 68 8B 5C 88 40 89 D0 8B 0B D3 E8 89 C1 31 C0 3B 4B 04 73 3A 8B 74 8B 14 85 F6 74 32 8B 4B 08 89 D7 D3 EF 8B 4B 0C 21 F9 8D 0C 8E 8B 0C 0B 85 C9 74 1C 89 D0 C1 E8 05 23 43 10 8D 04 81 89 D1 8B 04 03 D3 E8 83 E0 01 8D B4 26 00 00 00 00 8B 1C 24 8B 74 24 04 8B 7C 24 08 83 C4 0C C3 90 8B 40 34 8B 1C 24 8B 74 24 04 8B 7C 24 08 0F B7 04 50 83 C4 0C 66 25 00 80 0F B7 C0 C3 }
	condition:
		$1
}

rule file_62_7_0 {
	meta:
		name = "__iswprint_l"
		size = 157
	strings:
		$1 = { 83 EC 0C 8B 54 24 10 89 1C 24 8B 44 24 14 89 74 24 04 89 7C 24 08 F7 C2 80 FF FF FF 74 62 8B 00 8B 48 68 8B 5C 88 3C 89 D0 8B 0B D3 E8 89 C1 31 C0 3B 4B 04 73 3A 8B 74 8B 14 85 F6 74 32 8B 4B 08 89 D7 D3 EF 8B 4B 0C 21 F9 8D 0C 8E 8B 0C 0B 85 C9 74 1C 89 D0 C1 E8 05 23 43 10 8D 04 81 89 D1 8B 04 03 D3 E8 83 E0 01 8D B4 26 00 00 00 00 8B 1C 24 8B 74 24 04 8B 7C 24 08 83 C4 0C C3 90 8B 40 34 8B 1C 24 8B 74 24 04 8B 7C 24 08 0F B7 04 50 83 C4 0C 66 25 00 40 0F B7 C0 C3 }
	condition:
		$1
}

rule file_62_8_0 {
	meta:
		name = "__iswpunct_l"
		size = 156
	strings:
		$1 = { 83 EC 0C 8B 54 24 10 89 1C 24 8B 44 24 14 89 74 24 04 89 7C 24 08 F7 C2 80 FF FF FF 74 62 8B 00 8B 48 68 8B 5C 88 4C 89 D0 8B 0B D3 E8 89 C1 31 C0 3B 4B 04 73 3A 8B 74 8B 14 85 F6 74 32 8B 4B 08 89 D7 D3 EF 8B 4B 0C 21 F9 8D 0C 8E 8B 0C 0B 85 C9 74 1C 89 D0 C1 E8 05 23 43 10 8D 04 81 89 D1 8B 04 03 D3 E8 83 E0 01 8D B4 26 00 00 00 00 8B 1C 24 8B 74 24 04 8B 7C 24 08 83 C4 0C C3 90 8B 40 34 8B 1C 24 8B 74 24 04 8B 7C 24 08 0F B7 04 50 83 C4 0C 83 E0 04 0F B7 C0 C3 }
	condition:
		$1
}

rule file_62_9_0 {
	meta:
		name = "__iswspace_l"
		size = 157
	strings:
		$1 = { 83 EC 0C 8B 54 24 10 89 1C 24 8B 44 24 14 89 74 24 04 89 7C 24 08 F7 C2 80 FF FF FF 74 62 8B 00 8B 48 68 8B 5C 88 38 89 D0 8B 0B D3 E8 89 C1 31 C0 3B 4B 04 73 3A 8B 74 8B 14 85 F6 74 32 8B 4B 08 89 D7 D3 EF 8B 4B 0C 21 F9 8D 0C 8E 8B 0C 0B 85 C9 74 1C 89 D0 C1 E8 05 23 43 10 8D 04 81 89 D1 8B 04 03 D3 E8 83 E0 01 8D B4 26 00 00 00 00 8B 1C 24 8B 74 24 04 8B 7C 24 08 83 C4 0C C3 90 8B 40 34 8B 1C 24 8B 74 24 04 8B 7C 24 08 0F B7 04 50 83 C4 0C 66 25 00 20 0F B7 C0 C3 }
	condition:
		$1
}

rule file_62_10_0 {
	meta:
		name = "__iswupper_l"
		size = 157
	strings:
		$1 = { 83 EC 0C 8B 54 24 10 89 1C 24 8B 44 24 14 89 74 24 04 89 7C 24 08 F7 C2 80 FF FF FF 74 62 8B 00 8B 48 68 8B 5C 88 24 89 D0 8B 0B D3 E8 89 C1 31 C0 3B 4B 04 73 3A 8B 74 8B 14 85 F6 74 32 8B 4B 08 89 D7 D3 EF 8B 4B 0C 21 F9 8D 0C 8E 8B 0C 0B 85 C9 74 1C 89 D0 C1 E8 05 23 43 10 8D 04 81 89 D1 8B 04 03 D3 E8 83 E0 01 8D B4 26 00 00 00 00 8B 1C 24 8B 74 24 04 8B 7C 24 08 83 C4 0C C3 90 8B 40 34 8B 1C 24 8B 74 24 04 8B 7C 24 08 0F B7 04 50 83 C4 0C 66 25 00 01 0F B7 C0 C3 }
	condition:
		$1
}

rule file_62_11_0 {
	meta:
		name = "__iswxdigit_l"
		size = 157
	strings:
		$1 = { 83 EC 0C 8B 54 24 10 89 1C 24 8B 44 24 14 89 74 24 04 89 7C 24 08 F7 C2 80 FF FF FF 74 62 8B 00 8B 48 68 8B 5C 88 34 89 D0 8B 0B D3 E8 89 C1 31 C0 3B 4B 04 73 3A 8B 74 8B 14 85 F6 74 32 8B 4B 08 89 D7 D3 EF 8B 4B 0C 21 F9 8D 0C 8E 8B 0C 0B 85 C9 74 1C 89 D0 C1 E8 05 23 43 10 8D 04 81 89 D1 8B 04 03 D3 E8 83 E0 01 8D B4 26 00 00 00 00 8B 1C 24 8B 74 24 04 8B 7C 24 08 83 C4 0C C3 90 8B 40 34 8B 1C 24 8B 74 24 04 8B 7C 24 08 0F B7 04 50 83 C4 0C 66 25 00 10 0F B7 C0 C3 }
	condition:
		$1
}

rule file_62_12_0 {
	meta:
		name = "__towlower_l"
		size = 90
	strings:
		$1 = { 83 EC 08 8B 54 24 10 89 1C 24 8B 44 24 0C 89 74 24 04 8B 12 89 C3 8B 4A 6C 8B 54 8A 28 8B 0A D3 EB 3B 5A 04 73 29 8B 5C 9A 14 85 DB 74 21 8B 4A 08 89 C6 D3 EE 8B 4A 0C 21 F1 8D 0C 8B 8B 0C 0A 85 C9 74 0B 8B 5A 10 21 C3 8D 0C 99 03 04 0A 8B 1C 24 8B 74 24 04 83 C4 08 C3 }
	condition:
		$1
}

rule file_62_13_0 {
	meta:
		name = "__towupper_l"
		size = 90
	strings:
		$1 = { 83 EC 08 8B 54 24 10 89 1C 24 8B 44 24 0C 89 74 24 04 8B 12 89 C3 8B 4A 6C 8B 54 8A 24 8B 0A D3 EB 3B 5A 04 73 29 8B 5C 9A 14 85 DB 74 21 8B 4A 08 89 C6 D3 EE 8B 4A 0C 21 F1 8D 0C 8B 8B 0C 0A 85 C9 74 0B 8B 5A 10 21 C3 8D 0C 99 03 04 0A 8B 1C 24 8B 74 24 04 83 C4 08 C3 }
	condition:
		$1
}

rule file_63_0_0 {
	meta:
		name = "__strnlen"
		size = 146
	strings:
		$1 = { 56 31 C0 53 8B 5C 24 10 8B 74 24 0C 85 DB 74 6F 01 F3 B8 FF FF FF FF 0F 42 D8 F7 C6 03 00 00 00 89 F0 74 18 80 3E 00 75 0C EB 4D 90 8D 74 26 00 80 38 00 74 43 83 C0 01 A8 03 75 F4 39 C3 76 38 8B 08 8D 50 04 81 E9 01 01 01 01 81 E1 80 80 80 80 74 18 80 7A FC 00 74 1F 80 7A FD 00 74 23 80 7A FE 00 74 22 80 7A FF 00 74 21 39 D3 89 D0 77 CF 89 D8 90 8D 74 26 00 39 D8 0F 47 C3 29 F0 5B 5E C3 83 C0 01 EB F1 83 C0 02 EB EC 83 C0 03 90 EB E6 }
	condition:
		$1
}

rule file_64_0_0 {
	meta:
		name = "__posix_spawnp"
		size = 67
		refs = "003b __spawni"
	strings:
		$1 = { 83 EC 2C 8B 44 24 44 C7 44 24 18 01 00 00 00 89 44 24 14 8B 44 24 40 89 44 24 10 8B 44 24 3C 89 44 24 0C 8B 44 24 38 89 44 24 08 8B 44 24 34 89 44 24 04 8B 44 24 30 89 04 24 E8 ?? ?? ?? ?? 83 C4 2C C3 }
	condition:
		$1
}

rule file_65_0_0 {
	meta:
		name = "wait_on_socket"
		size = 255
		refs = "0034 __poll 005a __libc_errno 0074 __gettimeofday"
	strings:
		$1 = { 83 EC 3C 89 74 24 30 8D 74 24 10 89 54 24 08 C7 44 24 04 01 00 00 00 89 34 24 89 5C 24 2C 89 D3 89 7C 24 34 89 6C 24 38 89 44 24 10 66 C7 44 24 14 19 00 E8 ?? ?? ?? ?? 83 F8 FF 74 1B 8B 5C 24 2C 8B 74 24 30 8B 7C 24 34 8B 6C 24 38 83 C4 3C C3 8D B4 26 00 00 00 00 8B 15 ?? ?? ?? ?? 65 83 3A 04 75 D9 8D 7C 24 18 C7 44 24 04 00 00 00 00 89 3C 24 E8 ?? ?? ?? ?? B9 E8 03 00 00 69 44 24 18 E8 03 00 00 8D 2C 18 8B 44 24 1C 05 F4 01 00 00 89 C2 C1 FA 1F F7 F9 01 C5 89 D8 BB D3 4D 62 10 EB 3E 8B 15 ?? ?? ?? ?? 65 83 3A 04 75 8E C7 44 24 04 00 00 00 00 89 3C 24 E8 ?? ?? ?? ?? 8B 4C 24 1C 81 C1 F4 01 00 00 89 C8 F7 EB 69 44 24 18 18 FC FF FF C1 F9 1F C1 FA 06 29 D1 01 C8 01 E8 89 44 24 08 C7 44 24 04 01 00 00 00 89 34 24 E8 ?? ?? ?? ?? 83 F8 FF 74 A9 E9 3E FF FF FF }
	condition:
		$1
}

rule file_65_1_0 {
	meta:
		name = "open_socket"
		size = 779
		refs = "0016 __have_sock_cloexec 0040 __socket 00e4 __connect 012f memcpy 014d __send 01b9 __libc_errno 01ce _dl_sysinfo 0215 __gettimeofday 0268 __poll 02ba __fcntl"
	strings:
		$1 = { 55 89 E5 57 89 CF 56 53 81 EC BC 00 00 00 89 95 4C FF FF FF 8B 15 ?? ?? ?? ?? 89 85 50 FF FF FF 85 D2 0F 88 68 01 00 00 C7 44 24 08 00 00 00 00 C7 44 24 04 01 08 08 00 C7 04 24 01 00 00 00 E8 ?? ?? ?? ?? 89 C3 A1 ?? ?? ?? ?? 85 C0 0F 84 25 01 00 00 85 C0 0F 88 35 01 00 00 85 DB 0F 88 6D 02 00 00 8D 47 0F 83 E0 FC 83 C0 12 83 E0 F0 29 C4 8D 47 0C 89 85 54 FF FF FF A1 ?? ?? ?? ?? 8D 54 24 13 C1 EA 02 8D 34 95 00 00 00 00 85 C0 0F 88 0B 02 00 00 8D 85 7A FF FF FF C7 44 24 08 6E 00 00 00 89 44 24 04 89 1C 24 89 95 48 FF FF FF 66 C7 85 7A FF FF FF 01 00 C7 85 7C FF FF FF 2F 76 61 72 C7 45 80 2F 72 75 6E C7 45 84 2F 6E 73 63 C7 45 88 64 2F 73 6F C7 45 8C 63 6B 65 74 C6 45 90 00 E8 ?? ?? ?? ?? 8B 95 48 FF FF FF 85 C0 0F 88 C2 00 00 00 8B 85 50 FF FF FF 89 3C 95 08 00 00 00 C7 04 95 00 00 00 00 02 00 00 00 89 04 95 04 00 00 00 8B 95 4C FF FF FF 8D 46 0C 89 7C 24 08 BF 01 00 00 00 89 04 24 89 54 24 04 E8 ?? ?? ?? ?? 8B 85 54 FF FF FF C7 44 24 0C 00 40 00 00 89 74 24 04 89 1C 24 89 44 24 08 E8 ?? ?? ?? ?? 83 F8 FF 0F 84 86 00 00 00 3B 85 54 FF FF FF 75 65 8D B6 00 00 00 00 8D 65 F4 89 D8 5B 5E 5F 5D C3 8D B6 00 00 00 00 83 FB FF 0F 84 FF 00 00 00 B8 01 00 00 00 A3 ?? ?? ?? ?? E9 C3 FE FF FF C7 44 24 08 00 00 00 00 C7 44 24 04 01 00 00 00 C7 04 24 01 00 00 00 E8 ?? ?? ?? ?? 89 C3 E9 A8 FE FF FF 90 8D 74 26 00 A1 ?? ?? ?? ?? 65 83 38 73 0F 84 2F FF FF FF B8 06 00 00 00 FF 15 ?? ?? ?? ?? BB FF FF FF FF EB 8F 8D B4 26 00 00 00 00 A1 ?? ?? ?? ?? 65 8B 00 83 F8 04 0F 84 42 FF FF FF 83 BD 54 FF FF FF FF 0F 84 6A FF FF FF 83 F8 0B 75 C4 8D 95 68 FF FF FF C7 44 24 04 00 00 00 00 89 14 24 E8 ?? ?? ?? ?? 89 F8 84 C0 0F 84 B7 00 00 00 8B 85 6C FF FF FF B9 88 13 00 00 89 85 64 FF FF FF 8B 85 68 FF FF FF 83 C0 05 89 85 60 FF FF FF 8D 95 70 FF FF FF 89 4C 24 08 C7 44 24 04 01 00 00 00 89 14 24 89 9D 70 FF FF FF 66 C7 85 74 FF FF FF 1C 00 E8 ?? ?? ?? ?? 85 C0 0F 8E 53 FF FF FF 31 FF E9 B8 FE FF FF 90 8D 74 26 00 A1 ?? ?? ?? ?? 65 83 38 16 0F 85 F2 FE FF FF B8 FF FF FF FF E9 ED FE FF FF 8D B4 26 00 00 00 00 C7 44 24 08 02 08 00 00 C7 44 24 04 04 00 00 00 89 1C 24 89 95 48 FF FF FF E8 ?? ?? ?? ?? 8B 95 48 FF FF FF E9 CC FD FF FF 8D B4 26 00 00 00 00 BB FF FF FF FF E9 8E FE FF FF 8B 85 60 FF FF FF BF E8 03 00 00 2B 85 68 FF FF FF 69 C8 E8 03 00 00 8B 85 64 FF FF FF 2B 85 6C FF FF FF 89 C2 C1 FA 1F F7 FF 01 C1 E9 38 FF FF FF }
	condition:
		$1
}

rule file_65_2_0 {
	meta:
		name = "__readall"
		size = 152
		refs = "002b __read 0061 __libc_errno"
	strings:
		$1 = { 83 EC 2C 89 74 24 20 8B 74 24 34 89 7C 24 24 8B 7C 24 30 89 6C 24 28 8B 6C 24 38 89 5C 24 1C 89 6C 24 08 89 74 24 04 89 3C 24 E8 ?? ?? ?? ?? 83 F8 FF 89 C3 74 2A 83 F8 00 7E 3D 01 C6 29 C5 75 DE 8B 44 24 38 29 E8 8B 5C 24 1C 8B 74 24 20 8B 7C 24 24 8B 6C 24 28 83 C4 2C C3 90 8D 74 26 00 A1 ?? ?? ?? ?? 65 8B 00 83 F8 04 74 B2 83 F8 0B 74 12 89 D8 EB D1 66 90 74 C7 A1 ?? ?? ?? ?? 65 8B 00 EB E9 BA C8 00 00 00 89 F8 E8 60 FB FF FF 85 C0 7F 8B 89 D8 EB AF }
	condition:
		$1
}

rule file_65_3_0 {
	meta:
		name = "__readvall"
		size = 364
		refs = "0024 __readv 002f __libc_errno 00ab memcpy"
	strings:
		$1 = { 55 89 E5 57 56 53 83 EC 2C 8B 75 0C 8B 5D 10 8B 7D 08 8D B6 00 00 00 00 89 5C 24 08 89 74 24 04 89 3C 24 E8 ?? ?? ?? ?? 83 F8 FF 75 23 8B 15 ?? ?? ?? ?? 65 8B 12 83 FA 04 74 DD 83 FA 0B 89 45 E4 75 3C C7 45 E4 00 00 00 00 EB 10 8D 74 26 00 83 F8 00 0F 8E D1 00 00 00 89 45 E4 85 DB 7E 1F 8D 0C DD 00 00 00 00 89 F0 8D 14 31 31 FF 66 90 03 78 04 83 C0 08 39 D0 75 F6 39 7D E4 72 11 8B 45 E4 8D 65 F4 5B 5E 5F 5D C3 8D B6 00 00 00 00 8D 41 12 83 E0 F0 89 65 E0 29 C4 8D 44 24 0C 89 4C 24 08 89 74 24 04 89 04 24 E8 ?? ?? ?? ?? 8B 4D E4 89 C6 8B 46 04 39 C8 76 3D 01 0E 29 C8 89 46 04 89 5C 24 08 89 74 24 04 8B 45 08 89 04 24 E8 ?? ?? ?? ?? 83 F8 FF 89 C1 74 26 83 F8 00 7F 3F 75 62 8B 45 E4 8B 65 E0 8D 65 F4 5B 5E 5F 5D C3 8D B4 26 00 00 00 00 29 C1 83 EB 01 83 C6 08 EB B2 A1 ?? ?? ?? ?? 65 8B 00 83 F8 04 74 B3 83 F8 0B 74 3B 89 4D E4 EB CA 8D B4 26 00 00 00 00 01 45 E4 39 7D E4 72 8C EB B9 C7 45 E4 00 00 00 00 0F 84 48 FF FF FF 8B 15 ?? ?? ?? ?? 65 8B 12 E9 F6 FE FF FF A1 ?? ?? ?? ?? 65 8B 00 EB C0 8B 45 08 BA C8 00 00 00 89 4D DC E8 F1 F9 FF FF 8B 4D DC 85 C0 0F 8F 58 FF FF FF EB A8 }
	condition:
		$1
}

rule file_65_4_0 {
	meta:
		name = "__nscd_unmap"
		size = 81
		refs = "001c __munmap 004d __assert_fail 0029 free"
	strings:
		$1 = { 53 83 EC 18 8B 5C 24 20 8B 4B 0C 85 C9 75 1E 8B 43 08 89 44 24 04 8B 03 89 04 24 E8 ?? ?? ?? ?? 89 5C 24 20 83 C4 18 5B E9 ?? ?? ?? ?? C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 0F 01 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_65_5_0 {
	meta:
		name = "__nscd_get_mapping"
		size = 955
		refs = "0018 strlen 001e __libc_errno 0120 __recvmsg 017b strcmp 01a0 __fxstat64 01d9 __close 020c __nscd_unmap 0276 __mmap 02e5 __munmap 031c malloc 0362 time"
	strings:
		$1 = { 55 89 E5 57 56 BE FF FF FF FF 53 81 EC FC 00 00 00 8B 45 0C 89 04 24 E8 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 65 8B 09 8D 50 01 89 C7 83 C0 10 83 E0 F0 29 C4 8D 44 24 18 89 95 2C FF FF FF 89 8D 28 FF FF FF 89 D1 8B 55 0C 89 85 24 FF FF FF 8B 45 08 E8 2B FA FF FF 85 C0 0F 88 80 01 00 00 8B 95 24 FF FF FF 89 C3 8B 8D 2C FF FF FF 8D 85 40 FF FF FF 89 85 54 FF FF FF 8D B5 6C FF FF FF 31 C0 C7 85 58 FF FF FF 08 00 00 00 89 95 4C FF FF FF 89 8D 50 FF FF FF C7 04 06 00 00 00 00 83 C0 04 83 F8 1C 72 F1 8D 85 4C FF FF FF BA 88 13 00 00 89 85 74 FF FF FF 8D 85 5C FF FF FF 89 85 7C FF FF FF 89 D8 C7 85 78 FF FF FF 02 00 00 00 C7 45 80 10 00 00 00 C7 85 60 FF FF FF 01 00 00 00 C7 85 64 FF FF FF 01 00 00 00 C7 85 5C FF FF FF 10 00 00 00 C7 85 68 FF FF FF FF FF FF FF E8 7F F8 FF FF 85 C0 0F 8E C7 00 00 00 8D B4 26 00 00 00 00 C7 44 24 08 00 00 00 40 89 74 24 04 89 1C 24 E8 ?? ?? ?? ?? 83 F8 FF 75 0C 8B 15 ?? ?? ?? ?? 65 83 3A 04 74 DB 83 7D 80 0B 0F 86 91 00 00 00 8B 95 7C FF FF FF 85 D2 0F 84 83 00 00 00 83 3A 10 75 7E 8B 8D 68 FF FF FF 39 85 2C FF FF FF 89 8D 20 FF FF FF 0F 85 B0 00 00 00 8B 45 0C 8B 95 24 FF FF FF 89 44 24 04 89 14 24 E8 ?? ?? ?? ?? 85 C0 0F 85 62 01 00 00 8B 8D 20 FF FF FF 8D 45 88 89 44 24 08 C7 04 24 03 00 00 00 89 4C 24 04 E8 ?? ?? ?? ?? 85 C0 0F 85 3D 01 00 00 8B 45 B8 8B 55 B4 83 F8 00 0F 8C 2E 01 00 00 0F 8E EC 01 00 00 89 95 40 FF FF FF 89 85 44 FF FF FF EB 73 90 BE FF FF FF FF 89 1C 24 E8 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 8B 85 28 FF FF FF 65 89 01 8B 4D 10 8B 11 89 31 85 D2 74 07 F0 83 6A 0C 01 74 0A 8D 65 F4 89 F0 5B 5E 5F 5D C3 89 14 24 E8 ?? ?? ?? ?? 8D 65 F4 89 F0 5B 5E 5F 5D C3 83 C7 09 39 F8 0F 85 C4 00 00 00 8B 45 0C 8B 95 24 FF FF FF 89 44 24 04 89 14 24 E8 ?? ?? ?? ?? 85 C0 0F 85 A7 00 00 00 8B 95 20 FF FF FF 8B 85 40 FF FF FF C7 44 24 14 00 00 00 00 C7 44 24 0C 01 00 00 00 89 54 24 10 C7 44 24 08 01 00 00 00 89 44 24 04 C7 04 24 00 00 00 00 E8 ?? ?? ?? ?? 83 F8 FF 89 C2 74 68 83 38 02 0F 85 12 01 00 00 83 78 04 78 0F 85 08 01 00 00 8B 40 28 85 C0 0F 84 FD 00 00 00 8B 4A 0C 85 C9 0F 84 A4 00 00 00 8B 72 2C 8D 3C 85 0F 00 00 00 89 F8 83 E0 F0 8B 8D 44 FF FF FF 85 C9 8D 4C 06 78 8B 85 40 FF FF FF 89 85 30 FF FF FF 75 35 39 C1 76 31 8B 8D 30 FF FF FF 89 14 24 89 4C 24 04 E8 ?? ?? ?? ?? BE FF FF FF FF 66 90 8B 95 20 FF FF FF 89 14 24 E8 ?? ?? ?? ?? E9 D2 FE FF FF 90 8D 74 26 00 C7 04 24 14 00 00 00 89 95 18 FF FF FF 89 8D 1C FF FF FF E8 ?? ?? ?? ?? 8B 95 18 FF FF FF 8B 8D 1C FF FF FF 85 C0 74 A7 83 E7 F0 03 7A 04 89 10 89 70 10 89 C6 01 D7 89 78 04 89 48 08 C7 40 0C 01 00 00 00 EB A2 8B 72 10 8B 7A 14 C7 04 24 00 00 00 00 89 95 18 FF FF FF E8 ?? ?? ?? ?? 81 C6 2C 01 00 00 8B 95 18 FF FF FF 83 D7 00 89 C1 C1 F9 1F 89 8D 34 FF FF FF 3B BD 34 FF FF FF 89 85 30 FF FF FF 72 0E 77 04 39 C6 72 08 8B 42 28 E9 0E FF FF FF 8B 8D 40 FF FF FF 89 8D 30 FF FF FF E9 2A FF FF FF 83 FA 77 0F 86 33 FF FF FF E9 06 FE FF FF }
	condition:
		$1
}

rule file_65_6_0 {
	meta:
		name = "__nscd_get_map_ref"
		size = 293
		refs = "00a6 time 00df __nscd_get_mapping"
	strings:
		$1 = { 83 EC 2C B9 01 00 00 00 89 6C 24 28 8B 6C 24 38 89 5C 24 1C 31 DB 89 74 24 20 BE 06 00 00 00 89 7C 24 24 8B 55 04 83 FA FF 0F 84 C9 00 00 00 89 D8 F0 0F B1 4D 00 85 C0 0F 85 D9 00 00 00 8B 5D 04 83 FB FF 0F 84 C5 00 00 00 85 DB 74 7A 8B 03 8B 50 0C 85 D2 74 41 8B 53 10 39 50 2C 77 69 8B 40 08 8B 54 24 3C A8 01 89 02 0F 85 9F 00 00 00 F0 FF 43 0C C7 45 00 00 00 00 00 89 D8 8B 74 24 20 8B 5C 24 1C 8B 7C 24 24 8B 6C 24 28 83 C4 2C C3 8D B4 26 00 00 00 00 8B 70 10 8B 78 14 C7 04 24 00 00 00 00 E8 ?? ?? ?? ?? 89 FA 89 C1 89 F0 05 2C 01 00 00 89 CF 83 D2 00 C1 FF 1F 39 FA 72 07 77 45 39 C8 73 41 90 8D 45 04 89 44 24 08 8B 44 24 34 89 44 24 04 8B 44 24 30 89 04 24 E8 ?? ?? ?? ?? 83 F8 FF 89 C3 74 25 8B 00 E9 6E FF FF FF 8D B4 26 00 00 00 00 BB FF FF FF FF E9 79 FF FF FF 8D B6 00 00 00 00 8B 03 E9 48 FF FF FF 83 CB FF E9 5D FF FF FF 83 EE 01 74 DC F3 90 66 90 E9 0A FF FF FF }
	condition:
		$1
}

rule file_65_7_0 {
	meta:
		name = "__nscd_cache_search"
		size = 354
		refs = "001b __nis_hash 00f7 memcmp"
	strings:
		$1 = { 55 57 56 53 83 EC 3C 8B 54 24 54 8B 44 24 58 8B 5C 24 5C 89 14 24 89 44 24 04 E8 ?? ?? ?? ?? 8B 53 10 8B 0B 89 54 24 20 31 D2 F7 71 28 8B 44 24 20 8B 74 91 78 BA CD CC CC CC F7 E2 C1 EA 05 83 FE FF 0F 84 10 01 00 00 8D 46 1C 39 44 24 20 0F 82 03 01 00 00 8D 6A FF 8B 54 24 60 31 FF 8B 4B 04 89 F3 83 C2 18 89 54 24 28 EB 51 8D 74 26 00 8B 76 10 39 F3 0F 84 DD 00 00 00 83 FD FF 0F 84 D4 00 00 00 85 FF 74 13 8D 04 19 83 C3 1C 39 5C 24 20 0F 82 C0 00 00 00 8B 58 10 B8 01 00 00 00 29 F8 83 FE FF 89 C7 0F 84 AB 00 00 00 83 ED 01 8D 46 1C 39 44 24 20 0F 82 9B 00 00 00 01 CE 0F B6 06 3B 44 24 50 75 A8 8B 44 24 58 39 46 04 75 9F 8B 56 08 01 D0 39 44 24 20 72 94 8B 44 24 58 89 4C 24 1C 89 44 24 08 8D 04 11 8B 54 24 54 89 44 24 04 89 14 24 E8 ?? ?? ?? ?? 8B 4C 24 1C 85 C0 0F 85 69 FF FF FF 8B 46 14 89 C2 83 C2 18 39 54 24 20 89 44 24 14 0F 82 53 FF FF FF 01 C8 80 78 12 00 89 44 24 24 0F 84 43 FF FF FF 8B 54 24 14 03 10 39 54 24 20 0F 82 33 FF FF FF 8B 44 24 14 03 44 24 28 39 44 24 20 0F 82 21 FF FF FF 8B 44 24 24 EB 05 8D 76 00 31 C0 83 C4 3C 5B 5E 5F 5D C3 }
	condition:
		$1
}

rule file_65_8_0 {
	meta:
		name = "__nscd_open_socket"
		size = 175
		refs = "0021 __libc_errno 005c __read 0087 _dl_sysinfo"
	strings:
		$1 = { 55 57 56 53 83 EC 2C 8B 4C 24 44 8B 6C 24 4C 8B 74 24 50 81 F9 00 04 00 00 0F 87 89 00 00 00 8B 3D ?? ?? ?? ?? 8B 54 24 40 65 8B 07 89 44 24 1C 8B 44 24 48 E8 E7 F3 FF FF 85 C0 89 C3 78 4C BA 88 13 00 00 E8 D7 F2 FF FF 85 C0 7E 33 8D 76 00 89 74 24 08 89 6C 24 04 89 1C 24 E8 ?? ?? ?? ?? 83 F8 FF 75 06 65 83 3F 04 74 E5 39 F0 75 11 83 C4 2C 89 D8 5B 5E 5F 5D C3 8D B4 26 00 00 00 00 B8 06 00 00 00 FF 15 ?? ?? ?? ?? 8B 44 24 1C BB FF FF FF FF 65 89 07 83 C4 2C 89 D8 5B 5E 5F 5D C3 8D B4 26 00 00 00 00 BB FF FF FF FF EB C0 }
	condition:
		$1
}

rule file_67_0_0 {
	meta:
		name = "convert_and_print"
		size = 253
		refs = "001d strlen 005d realloc 008d __mbsrtowcs 00c7 stderr 00cf __vfwprintf 00f1 fputws_unlocked"
	strings:
		$1 = { 55 89 E5 57 56 53 83 EC 3C 85 C0 89 45 D4 89 55 C8 0F 84 BC 00 00 00 89 04 24 31 FF E8 ?? ?? ?? ?? 8D 75 E0 8D 58 01 8D 04 9D 00 00 00 00 89 45 D0 83 C0 1E 89 45 CC EB 5C 8D B4 26 00 00 00 00 85 FF 74 0E 81 FB 9F 0F 00 00 B8 00 00 00 00 0F 46 F8 8B 45 D0 89 3C 24 89 44 24 04 E8 ?? ?? ?? ?? 85 C0 89 C7 74 79 8B 45 D4 C7 06 00 00 00 00 C7 46 04 00 00 00 00 89 74 24 0C 89 45 DC 8D 45 DC 89 5C 24 08 89 44 24 04 89 3C 24 E8 ?? ?? ?? ?? 39 C3 75 1B 81 FB CF 07 00 00 77 A3 8B 45 CC 83 E0 F0 29 C4 8D 7C 24 1F 83 E7 F0 EB B9 66 90 83 F8 FF B8 ?? ?? ?? ?? 0F 44 F8 8B 45 C8 89 7C 24 04 89 44 24 08 A1 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 8D 65 F4 5B 5E 5F 5D C3 90 8D 74 26 00 A1 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? 89 44 24 04 E8 ?? ?? ?? ?? 8D 65 F4 5B 5E 5F 5D C3 }
	condition:
		$1
}

rule file_67_1_0 {
	meta:
		name = "vwarnx"
		size = 207
		refs = "0005 stderr 000a __progname 0035 __fwprintf 0074 fprintf 008d vfprintf 005f putwc_unlocked 00cb __overflow"
	strings:
		$1 = { 83 EC 1C 8B 0D ?? ?? ?? ?? A1 ?? ?? ?? ?? 89 5C 24 14 8B 5C 24 20 89 74 24 18 8B 74 24 24 8B 51 68 89 44 24 08 85 D2 7E 3F 89 0C 24 C7 44 24 04 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 D8 89 F2 E8 BE FE FF FF A1 ?? ?? ?? ?? 8B 5C 24 14 8B 74 24 18 C7 44 24 20 0A 00 00 00 89 44 24 24 83 C4 1C E9 ?? ?? ?? ?? 90 8D 74 26 00 C7 44 24 04 ?? ?? ?? ?? 89 0C 24 E8 ?? ?? ?? ?? 85 DB 74 15 A1 ?? ?? ?? ?? 89 74 24 08 89 5C 24 04 89 04 24 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 8B 50 14 3B 50 18 73 15 C6 02 0A 83 C2 01 8B 5C 24 14 89 50 14 8B 74 24 18 83 C4 1C C3 8B 5C 24 14 8B 74 24 18 C7 44 24 24 0A 00 00 00 89 44 24 20 83 C4 1C E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_67_2_0 {
	meta:
		name = "vwarn"
		size = 274
		refs = "0005 stderr 000e __progname 0014 __libc_errno 0046 __fwprintf 0068 fputws_unlocked 00a4 fprintf 00bd vfprintf 00e2 fwrite_unlocked"
	strings:
		$1 = { 83 EC 2C 8B 0D ?? ?? ?? ?? 89 5C 24 1C A1 ?? ?? ?? ?? 8B 1D ?? ?? ?? ?? 89 74 24 20 8B 74 24 30 8B 51 68 89 7C 24 24 89 6C 24 28 65 8B 3B 8B 6C 24 34 85 D2 89 44 24 08 7E 5E C7 44 24 04 ?? ?? ?? ?? 89 0C 24 E8 ?? ?? ?? ?? 85 F6 74 1E 89 F0 89 EA E8 D9 FD FF FF A1 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? 89 44 24 04 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 65 89 3B 8B 74 24 20 8B 5C 24 1C 8B 7C 24 24 8B 6C 24 28 C7 44 24 34 ?? ?? ?? ?? 89 44 24 30 83 C4 2C E9 ?? ?? ?? ?? C7 44 24 04 ?? ?? ?? ?? 89 0C 24 E8 ?? ?? ?? ?? 85 F6 74 3A A1 ?? ?? ?? ?? 89 6C 24 08 89 74 24 04 89 04 24 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? C7 44 24 08 02 00 00 00 C7 44 24 04 01 00 00 00 C7 04 24 ?? ?? ?? ?? 89 44 24 0C E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 65 89 3B 8B 74 24 20 8B 5C 24 1C 8B 7C 24 24 8B 6C 24 28 C7 44 24 34 ?? ?? ?? ?? 89 44 24 30 83 C4 2C E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_67_3_0 {
	meta:
		name = "warn"
		size = 27
		refs = "0013 vwarn"
		altNames = "warnx"
	strings:
		$1 = { 83 EC 1C 8D 44 24 24 89 44 24 04 8B 44 24 20 89 04 24 E8 ?? ?? ?? ?? 83 C4 1C C3 }
	condition:
		$1
}

rule file_67_5_0 {
	meta:
		name = "verr"
		size = 35
		refs = "0013 vwarn 001f exit"
	strings:
		$1 = { 83 EC 1C 8B 44 24 28 89 44 24 04 8B 44 24 24 89 04 24 E8 ?? ?? ?? ?? 8B 44 24 20 89 04 24 E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_67_6_0 {
	meta:
		name = "verrx"
		size = 35
		refs = "0013 vwarnx 001f exit"
	strings:
		$1 = { 83 EC 1C 8B 44 24 28 89 44 24 04 8B 44 24 24 89 04 24 E8 ?? ?? ?? ?? 8B 44 24 20 89 04 24 E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_67_7_0 {
	meta:
		name = "err"
		size = 31
		refs = "001b verr"
		altNames = "errx"
	strings:
		$1 = { 83 EC 1C 8D 44 24 28 89 44 24 08 8B 44 24 24 89 44 24 04 8B 44 24 20 89 04 24 E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_202_3_0 {
	meta:
		name = "_IO_obstack_printf"
		size = 35
		refs = "001b _IO_obstack_vprintf"
	strings:
		$1 = { 83 EC 1C 8D 44 24 28 89 44 24 08 8B 44 24 24 89 44 24 04 8B 44 24 20 89 04 24 E8 ?? ?? ?? ?? 83 C4 1C C3 }
	condition:
		$1
}

rule file_1400_0_0 {
	meta:
		name = "___asprintf"
		size = 35
		refs = "001b _IO_vasprintf"
	strings:
		$1 = { 83 EC 1C 8D 44 24 28 89 44 24 08 8B 44 24 24 89 44 24 04 8B 44 24 20 89 04 24 E8 ?? ?? ?? ?? 83 C4 1C C3 }
	condition:
		$1
}

rule file_1261_0_0 {
	meta:
		name = "__dprintf"
		size = 35
		refs = "001b _IO_vdprintf"
	strings:
		$1 = { 83 EC 1C 8D 44 24 28 89 44 24 08 8B 44 24 24 89 44 24 04 8B 44 24 20 89 04 24 E8 ?? ?? ?? ?? 83 C4 1C C3 }
	condition:
		$1
}

rule file_880_0_0 {
	meta:
		name = "__fprintf"
		size = 35
		refs = "001b vfprintf"
	strings:
		$1 = { 83 EC 1C 8D 44 24 28 89 44 24 08 8B 44 24 24 89 44 24 04 8B 44 24 20 89 04 24 E8 ?? ?? ?? ?? 83 C4 1C C3 }
	condition:
		$1
}

rule file_1275_0_0 {
	meta:
		name = "__fscanf"
		size = 35
		refs = "001b __vfscanf"
	strings:
		$1 = { 83 EC 1C 8D 44 24 28 89 44 24 08 8B 44 24 24 89 44 24 04 8B 44 24 20 89 04 24 E8 ?? ?? ?? ?? 83 C4 1C C3 }
	condition:
		$1
}

rule file_864_0_0 {
	meta:
		name = "__fwprintf"
		size = 35
		refs = "001b __vfwprintf"
	strings:
		$1 = { 83 EC 1C 8D 44 24 28 89 44 24 08 8B 44 24 24 89 44 24 04 8B 44 24 20 89 04 24 E8 ?? ?? ?? ?? 83 C4 1C C3 }
	condition:
		$1
}

rule file_893_0_0 {
	meta:
		name = "__fwscanf"
		size = 35
		refs = "001b __vfwscanf"
	strings:
		$1 = { 83 EC 1C 8D 44 24 28 89 44 24 08 8B 44 24 24 89 44 24 04 8B 44 24 20 89 04 24 E8 ?? ?? ?? ?? 83 C4 1C C3 }
	condition:
		$1
}

rule file_546_0_0 {
	meta:
		name = "__isoc99_sscanf"
		size = 35
		refs = "001b __isoc99_vsscanf"
	strings:
		$1 = { 83 EC 1C 8D 44 24 28 89 44 24 08 8B 44 24 24 89 44 24 04 8B 44 24 20 89 04 24 E8 ?? ?? ?? ?? 83 C4 1C C3 }
	condition:
		$1
}

rule file_1059_0_0 {
	meta:
		name = "__isoc99_swscanf"
		size = 35
		refs = "001b __isoc99_vswscanf"
	strings:
		$1 = { 83 EC 1C 8D 44 24 28 89 44 24 08 8B 44 24 24 89 44 24 04 8B 44 24 20 89 04 24 E8 ?? ?? ?? ?? 83 C4 1C C3 }
	condition:
		$1
}

rule file_620_0_0 {
	meta:
		name = "__sprintf"
		size = 35
		refs = "001b _IO_vsprintf"
	strings:
		$1 = { 83 EC 1C 8D 44 24 28 89 44 24 08 8B 44 24 24 89 44 24 04 8B 44 24 20 89 04 24 E8 ?? ?? ?? ?? 83 C4 1C C3 }
	condition:
		$1
}

rule file_343_0_0 {
	meta:
		name = "__sscanf"
		size = 35
		refs = "001b _IO_vsscanf"
	strings:
		$1 = { 83 EC 1C 8D 44 24 28 89 44 24 08 8B 44 24 24 89 44 24 04 8B 44 24 20 89 04 24 E8 ?? ?? ?? ?? 83 C4 1C C3 }
	condition:
		$1
}

rule file_863_0_0 {
	meta:
		name = "__swscanf"
		size = 35
		refs = "001b vswscanf"
	strings:
		$1 = { 83 EC 1C 8D 44 24 28 89 44 24 08 8B 44 24 24 89 44 24 04 8B 44 24 20 89 04 24 E8 ?? ?? ?? ?? 83 C4 1C C3 }
	condition:
		$1
}

rule file_68_0_0 {
	meta:
		name = "__scandir64"
		size = 51
		refs = "002b scandirat64"
		altNames = "scandir"
	strings:
		$1 = { 83 EC 2C 8B 44 24 3C C7 04 24 9C FF FF FF 89 44 24 10 8B 44 24 38 89 44 24 0C 8B 44 24 34 89 44 24 08 8B 44 24 30 89 44 24 04 E8 ?? ?? ?? ?? 83 C4 2C C3 }
	condition:
		$1
}

rule file_69_0_0 {
	meta:
		name = "ether_ntohost"
		size = 302
		refs = "0043 __libc_errno 00aa __nss_next2 00db strcpy 00fe __nss_ethers_lookup"
	strings:
		$1 = { 55 57 56 53 81 EC 5C 04 00 00 8B 15 ?? ?? ?? ?? 85 D2 0F 84 D4 00 00 00 A1 ?? ?? ?? ?? 83 FA FF 89 54 24 3C 89 44 24 40 0F 84 E2 00 00 00 8D 74 24 40 8D 5C 24 3C 65 8B 3D 00 00 00 00 8D 4C 24 50 8B 15 ?? ?? ?? ?? 8D 6C 24 44 89 4C 24 28 01 D7 89 7C 24 2C EB 05 90 8B 44 24 40 8B 54 24 2C 8B 4C 24 28 C7 44 24 0C 00 04 00 00 89 6C 24 04 89 54 24 10 8B 94 24 74 04 00 00 89 4C 24 08 89 14 24 FF D0 C7 44 24 14 00 00 00 00 89 74 24 0C C7 44 24 08 00 00 00 00 C7 44 24 04 ?? ?? ?? ?? 89 1C 24 89 44 24 10 89 C7 E8 ?? ?? ?? ?? 85 C0 74 A6 83 FF 01 B8 FF FF FF FF 74 0C 81 C4 5C 04 00 00 5B 5E 5F 5D C3 90 8B 44 24 44 89 44 24 04 8B 84 24 70 04 00 00 89 04 24 E8 ?? ?? ?? ?? 81 C4 5C 04 00 00 31 C0 5B 5E 5F 5D C3 8D 74 24 40 BA ?? ?? ?? ?? 8D 5C 24 3C 89 F1 89 D8 E8 ?? ?? ?? ?? 85 C0 74 11 C7 05 ?? ?? ?? ?? FF FF FF FF B8 FF FF FF FF EB A5 8B 44 24 3C A3 ?? ?? ?? ?? 8B 44 24 40 A3 ?? ?? ?? ?? E9 08 FF FF FF }
	condition:
		$1
}

rule file_70_0_0 {
	meta:
		name = "clnttcp_geterr"
		size = 29
	strings:
		$1 = { 8B 54 24 04 8B 44 24 08 8B 52 08 8B 4A 24 89 08 8B 4A 28 89 48 04 8B 52 2C 89 50 08 C3 }
	condition:
		$1
}

rule file_70_1_0 {
	meta:
		name = "clnttcp_freeres"
		size = 35
	strings:
		$1 = { 8B 44 24 04 8B 4C 24 0C 8B 54 24 08 8B 40 08 C7 40 4C 02 00 00 00 83 C0 4C 89 4C 24 08 89 44 24 04 FF E2 }
	condition:
		$1
}

rule file_70_3_0 {
	meta:
		name = "clnttcp_destroy"
		size = 84
		refs = "002f free 004e __close"
	strings:
		$1 = { 83 EC 1C 89 74 24 18 8B 74 24 20 89 5C 24 14 8B 5E 08 8B 43 04 85 C0 75 2F 8B 43 50 8B 40 1C 85 C0 74 08 8D 53 4C 89 14 24 FF D0 89 1C 24 E8 ?? ?? ?? ?? 8B 5C 24 14 89 74 24 20 8B 74 24 18 83 C4 1C E9 ?? ?? ?? ?? 90 8B 03 89 04 24 E8 ?? ?? ?? ?? EB C5 }
	condition:
		$1
}

rule file_70_4_0 {
	meta:
		name = "clnttcp_control"
		size = 278
	strings:
		$1 = { 53 8B 44 24 0C 8B 54 24 08 8B 5C 24 10 83 F8 0F 8B 4A 08 76 0B 31 C0 5B C3 8D B4 26 00 00 00 00 FF 24 85 ?? ?? ?? ?? 90 8B 03 8B 53 04 C7 41 10 01 00 00 00 89 41 08 B8 01 00 00 00 89 51 0C 5B C3 8D B4 26 00 00 00 00 8B 41 08 8B 51 0C 89 03 B8 01 00 00 00 89 53 04 5B C3 8D B6 00 00 00 00 8B 41 14 89 03 8B 41 18 89 43 04 8B 41 1C 89 43 08 8B 41 20 89 43 0C B8 01 00 00 00 5B C3 66 90 8B 01 89 03 B8 01 00 00 00 5B C3 90 8D 74 26 00 C7 41 04 01 00 00 00 B8 01 00 00 00 5B C3 66 90 C7 41 04 00 00 00 00 B8 01 00 00 00 5B C3 66 90 8B 41 30 0F C8 89 03 B8 01 00 00 00 5B C3 66 90 8B 03 83 E8 01 0F C8 89 41 30 B8 01 00 00 00 5B C3 8D B4 26 00 00 00 00 8B 41 40 0F C8 89 03 B8 01 00 00 00 5B C3 66 90 8B 03 0F C8 89 41 40 B8 01 00 00 00 5B C3 66 90 8B 41 3C 0F C8 89 03 B8 01 00 00 00 5B C3 66 90 8B 03 0F C8 89 41 3C B8 01 00 00 00 5B C3 }
	condition:
		$1
}

rule file_70_5_0 {
	meta:
		name = "clnttcp_call"
		size = 685
		refs = "00e8 xdrrec_endofrecord 0113 _null_auth 0126 xdr_void 0141 xdrrec_skiprecord 0151 xdr_replymsg 0179 _seterr_reply 0277 xdr_opaque_auth"
	strings:
		$1 = { 55 57 56 53 83 EC 5C 8B 54 24 70 8B 5A 08 8B 53 10 8D 73 4C 85 D2 75 14 8B 84 24 88 00 00 00 8B 94 24 8C 00 00 00 89 43 08 89 53 0C 8B 84 24 80 00 00 00 C7 44 24 14 01 00 00 00 85 C0 0F 84 95 01 00 00 8D 53 30 C7 44 24 1C 03 00 00 00 8D 7C 24 20 89 54 24 18 8B 6B 30 8B 53 48 C7 43 4C 00 00 00 00 8B 43 50 C7 43 24 00 00 00 00 83 ED 01 89 6B 30 0F CD 89 54 24 08 8B 54 24 18 89 34 24 89 54 24 04 FF 50 0C 85 C0 0F 84 69 01 00 00 8B 43 50 8D 54 24 74 89 54 24 04 89 34 24 FF 50 04 85 C0 0F 84 50 01 00 00 8B 54 24 70 8B 02 8B 50 20 89 74 24 04 89 04 24 FF 52 04 85 C0 0F 84 35 01 00 00 8B 44 24 7C 8B 54 24 78 89 34 24 89 44 24 04 FF D2 85 C0 0F 84 1C 01 00 00 8B 54 24 14 89 34 24 89 54 24 04 E8 ?? ?? ?? ?? 85 C0 0F 84 2A 01 00 00 8B 44 24 14 85 C0 0F 84 2C 01 00 00 8B 43 08 85 C0 0F 84 AD 00 00 00 C7 43 4C 01 00 00 00 A1 ?? ?? ?? ?? 89 34 24 C7 44 24 3C 00 00 00 00 C7 44 24 40 ?? ?? ?? ?? 89 44 24 2C A1 ?? ?? ?? ?? 89 44 24 30 A1 ?? ?? ?? ?? 89 44 24 34 E8 ?? ?? ?? ?? 85 C0 74 5F 89 7C 24 04 89 34 24 E8 ?? ?? ?? ?? 85 C0 75 0F 8B 43 24 85 C0 74 B2 83 C4 5C 5B 5E 5F 5D C3 39 6C 24 20 75 A4 8D 43 24 89 44 24 04 89 3C 24 E8 ?? ?? ?? ?? 8B 43 24 85 C0 0F 84 AB 00 00 00 83 6C 24 1C 01 74 D1 8B 54 24 70 8B 02 8B 50 20 89 04 24 FF 52 0C 85 C0 0F 85 B0 FE FF FF 66 90 8B 43 24 83 C4 5C 5B 5E 5F 5D C3 90 8D 74 26 00 8B 4B 0C 85 C9 0F 85 48 FF FF FF C7 43 24 05 00 00 00 B8 05 00 00 00 EB 8F 8D B4 26 00 00 00 00 8B 43 08 85 C0 0F 85 60 FE FF FF 8B 43 0C 31 D2 85 C0 0F 95 C2 89 54 24 14 E9 4D FE FF FF 66 90 8B 43 24 85 C0 75 07 C7 43 24 01 00 00 00 C7 44 24 04 01 00 00 00 89 34 24 E8 ?? ?? ?? ?? 8B 43 24 E9 42 FF FF FF C7 43 24 03 00 00 00 B0 03 E9 34 FF FF FF 31 C0 E9 2D FF FF FF 8B 54 24 70 8D 7C 24 2C 8B 02 8B 50 20 89 7C 24 04 89 04 24 FF 52 08 85 C0 75 35 C7 43 24 07 00 00 00 C7 43 28 06 00 00 00 8B 54 24 30 85 D2 0F 84 40 FF FF FF C7 43 4C 02 00 00 00 89 7C 24 04 89 34 24 E8 ?? ?? ?? ?? 8B 43 24 E9 DD FE FF FF 8B 84 24 84 00 00 00 8B 94 24 80 00 00 00 89 34 24 89 44 24 04 FF D2 85 C0 75 BE 83 7B 24 00 75 B8 C7 43 24 02 00 00 00 EB AF }
	condition:
		$1
}

rule file_70_6_0 {
	meta:
		name = "writetcp"
		size = 96
		refs = "0036 __write 0040 __libc_errno"
	strings:
		$1 = { 55 57 56 53 83 EC 1C 8B 7C 24 38 8B 74 24 30 8B 6C 24 34 85 FF 89 FB 7F 0F EB 3B 90 8D 74 26 00 29 C3 01 C5 85 DB 7E 2E 89 5C 24 08 89 6C 24 04 8B 06 89 04 24 E8 ?? ?? ?? ?? 83 F8 FF 75 E1 A1 ?? ?? ?? ?? BF FF FF FF FF C7 46 24 03 00 00 00 65 8B 00 89 46 28 83 C4 1C 89 F8 5B 5E 5F 5D C3 }
	condition:
		$1
}

rule file_70_7_0 {
	meta:
		name = "readtcp"
		size = 260
		refs = "005f __poll 007e __read 00c9 __libc_errno"
	strings:
		$1 = { 83 EC 3C 89 74 24 30 8B 74 24 48 89 5C 24 2C 8B 5C 24 40 89 6C 24 38 89 7C 24 34 85 F6 8B 6B 08 8B 4B 0C 74 7B 8B 03 BA D3 4D 62 10 69 ED E8 03 00 00 66 C7 44 24 1C 01 00 8D 7C 24 18 89 44 24 18 89 C8 F7 EA C1 F9 1F C1 FA 06 29 CA 01 D5 89 6C 24 08 C7 44 24 04 01 00 00 00 89 3C 24 E8 ?? ?? ?? ?? 83 F8 FF 74 60 85 C0 74 4C 8B 44 24 44 89 74 24 08 89 44 24 04 8B 03 89 04 24 E8 ?? ?? ?? ?? 83 F8 FF 89 C6 74 67 85 C0 75 13 C7 43 28 68 00 00 00 BE FF FF FF FF C7 43 24 04 00 00 00 89 F0 8B 5C 24 2C 8B 74 24 30 8B 7C 24 34 8B 6C 24 38 83 C4 3C C3 66 90 C7 43 24 05 00 00 00 BE FF FF FF FF EB DA 66 90 A1 ?? ?? ?? ?? 65 8B 00 83 F8 04 0F 84 76 FF FF FF C7 43 24 04 00 00 00 BE FF FF FF FF 89 43 28 EB B6 8D B6 00 00 00 00 A1 ?? ?? ?? ?? C7 43 24 04 00 00 00 65 8B 00 89 43 28 EB 9C }
	condition:
		$1
}

rule file_70_8_0 {
	meta:
		name = "clnttcp_create"
		size = 670
		refs = "0017 malloc 0085 _create_xid 00c8 xdrmem_create 00d8 xdr_callhdr 012d xdrrec_create 013c authnone_create 016c pmap_getport 01a3 __socket 01b5 bindresvport 01d3 __connect 01fd __close 0205 free 0221 __rpc_thread_createerr 0238 _libc_intl_domainname 023f __dcgettext 025f __fxprintf 027f __libc_errno"
	strings:
		$1 = { 55 57 56 53 83 EC 5C C7 04 24 0C 00 00 00 8B 7C 24 70 8B 74 24 7C E8 ?? ?? ?? ?? C7 04 24 64 00 00 00 89 C3 E8 ?? ?? ?? ?? 85 C0 89 C5 0F 84 ED 01 00 00 85 DB 0F 84 E5 01 00 00 66 83 7F 02 00 0F 84 0A 01 00 00 8B 06 85 C0 0F 88 3B 01 00 00 C7 45 04 00 00 00 00 8B 06 C7 45 0C 00 00 00 00 C7 45 10 00 00 00 00 89 45 00 8B 07 89 45 14 8B 47 04 89 45 18 8B 47 08 89 45 1C 8B 47 0C 8D 7D 4C 89 45 20 E8 ?? ?? ?? ?? C7 44 24 0C 00 00 00 00 C7 44 24 08 18 00 00 00 89 3C 24 C7 44 24 24 00 00 00 00 C7 44 24 28 02 00 00 00 89 44 24 20 8B 44 24 74 89 44 24 2C 8B 44 24 78 89 44 24 30 8D 45 30 89 44 24 04 E8 ?? ?? ?? ?? 8D 44 24 20 89 44 24 04 89 3C 24 E8 ?? ?? ?? ?? 85 C0 0F 84 0C 01 00 00 8B 45 50 89 3C 24 FF 50 10 89 45 48 8B 45 50 8B 40 1C 85 C0 74 05 89 3C 24 FF D0 8B 84 24 84 00 00 00 89 6C 24 0C 89 3C 24 C7 44 24 14 ?? ?? ?? ?? 89 44 24 08 8B 84 24 80 00 00 00 C7 44 24 10 ?? ?? ?? ?? 89 44 24 04 E8 ?? ?? ?? ?? 89 6B 08 C7 43 04 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 03 83 C4 5C 89 D8 5B 5E 5F 5D C3 8D 74 26 00 8B 44 24 78 C7 44 24 0C 06 00 00 00 89 3C 24 89 44 24 08 8B 44 24 74 89 44 24 04 E8 ?? ?? ?? ?? 66 85 C0 0F 84 88 00 00 00 66 C1 C8 08 66 89 47 02 8B 06 85 C0 0F 89 C5 FE FF FF C7 44 24 08 06 00 00 00 C7 44 24 04 01 00 00 00 C7 04 24 02 00 00 00 E8 ?? ?? ?? ?? 89 06 C7 44 24 04 00 00 00 00 89 04 24 E8 ?? ?? ?? ?? 8B 06 85 C0 0F 88 B5 00 00 00 C7 44 24 08 10 00 00 00 89 7C 24 04 89 04 24 E8 ?? ?? ?? ?? 85 C0 0F 88 99 00 00 00 C7 45 04 01 00 00 00 E9 6C FE FF FF 90 8D 74 26 00 8B 4D 04 85 C9 74 0A 8B 06 89 04 24 E8 ?? ?? ?? ?? 89 2C 24 E8 ?? ?? ?? ?? 89 1C 24 31 DB E8 ?? ?? ?? ?? 83 C4 5C 89 D8 5B 5E 5F 5D C3 8D 76 00 E8 ?? ?? ?? ?? C7 44 24 08 05 00 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? 89 C6 E8 ?? ?? ?? ?? C7 44 24 08 ?? ?? ?? ?? C7 44 24 04 ?? ?? ?? ?? C7 04 24 00 00 00 00 89 44 24 0C E8 ?? ?? ?? ?? C7 06 0C 00 00 00 C7 46 08 0C 00 00 00 EB 8F 8D B6 00 00 00 00 E8 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 65 8B 09 C7 00 0C 00 00 00 89 48 08 8B 06 85 C0 0F 89 60 FF FF FF E9 63 FF FF FF }
	condition:
		$1
}

rule file_71_0_0 {
	meta:
		name = "__libc_siglongjmp"
		size = 83
		refs = "0015 _longjmp_unwind 0032 __longjmp 004d __sigprocmask"
	strings:
		$1 = { 56 53 83 EC 14 8B 74 24 20 8B 5C 24 24 89 34 24 89 5C 24 04 E8 ?? ?? ?? ?? 8B 46 18 85 C0 75 16 85 DB B8 01 00 00 00 0F 44 D8 89 5C 24 04 89 34 24 E8 ?? ?? ?? ?? 8D 46 1C C7 44 24 08 00 00 00 00 89 44 24 04 C7 04 24 02 00 00 00 E8 ?? ?? ?? ?? EB CD }
	condition:
		$1
}

rule file_1411_0_0 {
	meta:
		name = "__longjmp_chk"
		size = 83
		refs = "0015 _longjmp_unwind 0032 ____longjmp_chk 004d __sigprocmask"
	strings:
		$1 = { 56 53 83 EC 14 8B 74 24 20 8B 5C 24 24 89 34 24 89 5C 24 04 E8 ?? ?? ?? ?? 8B 46 18 85 C0 75 16 85 DB B8 01 00 00 00 0F 44 D8 89 5C 24 04 89 34 24 E8 ?? ?? ?? ?? 8D 46 1C C7 44 24 08 00 00 00 00 89 44 24 04 C7 04 24 02 00 00 00 E8 ?? ?? ?? ?? EB CD }
	condition:
		$1
}

rule file_73_0_0 {
	meta:
		name = "__vwprintf"
		size = 36
		refs = "0014 stdout 001c __vfwprintf"
	strings:
		$1 = { 83 EC 1C 8B 44 24 24 89 44 24 08 8B 44 24 20 89 44 24 04 A1 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 83 C4 1C C3 }
	condition:
		$1
}

rule file_820_0_0 {
	meta:
		name = "__vprintf"
		size = 36
		refs = "0014 stdout 001c vfprintf"
	strings:
		$1 = { 83 EC 1C 8B 44 24 24 89 44 24 08 8B 44 24 20 89 44 24 04 A1 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 83 C4 1C C3 }
	condition:
		$1
}

rule file_74_0_0 {
	meta:
		name = "__link"
		size = 35
		refs = "0011 _dl_sysinfo 001e __syscall_error"
	strings:
		$1 = { 89 DA 8B 4C 24 08 8B 5C 24 04 B8 09 00 00 00 FF 15 ?? ?? ?? ?? 89 D3 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_75_0_0 {
	meta:
		name = "getpass"
		size = 548
		refs = "001a _IO_new_fopen 003a fileno 0046 __tcgetattr 0071 __fxprintf 0079 fflush_unlocked 0091 __getline 00c2 stdin 00cc _IO_new_fclose 018d tcsetattr 0200 stderr 0220 _Unwind_Resume"
	strings:
		$1 = { 55 57 56 53 81 EC AC 00 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 89 C3 0F 84 D0 01 00 00 81 08 00 80 00 00 89 C7 89 C6 89 34 24 8D 6C 24 64 E8 ?? ?? ?? ?? 89 6C 24 04 89 04 24 E8 ?? ?? ?? ?? 85 C0 C7 44 24 1C 00 00 00 00 0F 84 86 00 00 00 8B 84 24 C0 00 00 00 C7 44 24 04 ?? ?? ?? ?? 89 3C 24 89 44 24 08 E8 ?? ?? ?? ?? 89 3C 24 E8 ?? ?? ?? ?? 89 74 24 08 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 85 D2 74 15 85 C0 0F 88 49 01 00 00 8D 44 02 FF 80 38 0A 0F 84 F4 00 00 00 8B 44 24 1C 85 C0 0F 85 08 01 00 00 3B 35 ?? ?? ?? ?? 74 08 89 34 24 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 81 C4 AC 00 00 00 5B 5E 5F 5D C3 8B 44 24 64 89 34 24 89 44 24 28 8B 44 24 68 89 44 24 2C 8B 44 24 6C 89 44 24 30 8B 44 24 70 83 64 24 70 F6 89 44 24 34 8B 44 24 74 89 44 24 38 8B 44 24 78 89 44 24 3C 8B 44 24 7C 89 44 24 40 8B 84 24 80 00 00 00 89 44 24 44 8B 84 24 84 00 00 00 89 44 24 48 8B 84 24 88 00 00 00 89 44 24 4C 8B 84 24 8C 00 00 00 89 44 24 50 8B 84 24 90 00 00 00 89 44 24 54 8B 84 24 94 00 00 00 89 44 24 58 8B 84 24 98 00 00 00 89 44 24 5C 8B 84 24 9C 00 00 00 89 44 24 60 E8 ?? ?? ?? ?? 89 6C 24 08 C7 44 24 04 02 00 00 00 89 04 24 E8 ?? ?? ?? ?? 85 C0 0F 94 C0 0F B6 C0 89 44 24 1C E9 B8 FE FF FF 8D B6 00 00 00 00 8B 54 24 1C C6 00 00 85 D2 0F 84 09 FF FF FF C7 44 24 04 ?? ?? ?? ?? 89 3C 24 E8 ?? ?? ?? ?? 90 89 34 24 E8 ?? ?? ?? ?? 8D 54 24 28 89 54 24 08 C7 44 24 04 02 00 00 00 89 04 24 E8 ?? ?? ?? ?? E9 D3 FE FF FF 8D 76 00 C6 02 00 E9 BC FE FF FF 8B 35 ?? ?? ?? ?? 8B 3D ?? ?? ?? ?? 39 FE 0F 44 DE E9 24 FE FF FF 85 DB 89 C6 74 08 89 1C 24 E8 ?? ?? ?? ?? 89 34 24 E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_76_3_0 {
	meta:
		name = "__isoc99_fscanf"
		size = 212
		refs = "0064 _IO_vfscanf 00d0 _Unwind_Resume"
	strings:
		$1 = { 56 53 83 EC 14 8B 5C 24 20 8B 03 25 00 80 00 00 75 32 8B 53 48 65 8B 35 08 00 00 00 3B 72 08 74 1F B9 01 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 0A 0F 85 9A 00 00 00 8B 53 48 89 72 08 83 42 04 01 8D 44 24 28 83 4B 3C 10 89 44 24 08 8B 44 24 24 C7 44 24 0C 00 00 00 00 89 1C 24 89 44 24 04 E8 ?? ?? ?? ?? 83 63 3C EB 89 C2 F7 03 00 80 00 00 75 20 8B 4B 48 83 69 04 01 75 17 C7 41 08 00 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 83 29 01 75 4A 83 C4 14 89 D0 5B 5E C3 83 63 3C EB 89 C6 F7 03 00 80 00 00 75 20 8B 53 48 83 6A 04 01 75 17 C7 42 08 00 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 83 2A 01 75 1D 89 34 24 E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_824_3_0 {
	meta:
		name = "__isoc99_fwscanf"
		size = 212
		refs = "0064 _IO_vfwscanf 00d0 _Unwind_Resume"
	strings:
		$1 = { 56 53 83 EC 14 8B 5C 24 20 8B 03 25 00 80 00 00 75 32 8B 53 48 65 8B 35 08 00 00 00 3B 72 08 74 1F B9 01 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 0A 0F 85 9A 00 00 00 8B 53 48 89 72 08 83 42 04 01 8D 44 24 28 83 4B 3C 10 89 44 24 08 8B 44 24 24 C7 44 24 0C 00 00 00 00 89 1C 24 89 44 24 04 E8 ?? ?? ?? ?? 83 63 3C EB 89 C2 F7 03 00 80 00 00 75 20 8B 4B 48 83 69 04 01 75 17 C7 41 08 00 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 83 29 01 75 4A 83 C4 14 89 D0 5B 5E C3 83 63 3C EB 89 C6 F7 03 00 80 00 00 75 20 8B 53 48 83 6A 04 01 75 17 C7 42 08 00 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 83 2A 01 75 1D 89 34 24 E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_78_0_0 {
	meta:
		name = "mktemp"
		size = 54
		refs = "0024 __gen_tempname"
	strings:
		$1 = { 53 83 EC 18 8B 5C 24 20 C7 44 24 0C 02 00 00 00 C7 44 24 08 00 00 00 00 C7 44 24 04 00 00 00 00 89 1C 24 E8 ?? ?? ?? ?? 85 C0 79 03 C6 03 00 83 C4 18 89 D8 5B C3 }
	condition:
		$1
}

rule file_79_0_0 {
	meta:
		name = "__strcasecmp"
		size = 89
		refs = "0002 __libc_tsd_LOCALE"
	strings:
		$1 = { 55 A1 ?? ?? ?? ?? 57 56 53 8B 5C 24 14 8B 54 24 18 65 8B 00 39 D3 74 38 8B 48 38 90 8D 74 26 00 0F B6 3B 83 C2 01 0F B6 72 FF 89 F8 0F B6 E8 8B 04 A9 2B 04 B1 89 C6 75 09 89 F8 83 C3 01 84 C0 75 DE 5B 89 F0 5E 5F 5D C3 8D B4 26 00 00 00 00 31 F6 5B 89 F0 5E 5F 5D C3 }
	condition:
		$1
}

rule file_80_0_0 {
	meta:
		name = "strftime"
		size = 55
		refs = "0004 __libc_tsd_LOCALE 002f __strftime_l"
	strings:
		$1 = { 83 EC 2C A1 ?? ?? ?? ?? 65 8B 00 89 44 24 10 8B 44 24 3C 89 44 24 0C 8B 44 24 38 89 44 24 08 8B 44 24 34 89 44 24 04 8B 44 24 30 89 04 24 E8 ?? ?? ?? ?? 83 C4 2C C3 }
	condition:
		$1
}

rule file_934_0_0 {
	meta:
		name = "__strtol_internal"
		size = 55
		refs = "0004 __libc_tsd_LOCALE 002f ____strtol_l_internal"
	strings:
		$1 = { 83 EC 2C A1 ?? ?? ?? ?? 65 8B 00 89 44 24 10 8B 44 24 3C 89 44 24 0C 8B 44 24 38 89 44 24 08 8B 44 24 34 89 44 24 04 8B 44 24 30 89 04 24 E8 ?? ?? ?? ?? 83 C4 2C C3 }
	condition:
		$1
}

rule file_1298_0_0 {
	meta:
		name = "__strtoll_internal"
		size = 55
		refs = "0004 __libc_tsd_LOCALE 002f ____strtoll_l_internal"
	strings:
		$1 = { 83 EC 2C A1 ?? ?? ?? ?? 65 8B 00 89 44 24 10 8B 44 24 3C 89 44 24 0C 8B 44 24 38 89 44 24 08 8B 44 24 34 89 44 24 04 8B 44 24 30 89 04 24 E8 ?? ?? ?? ?? 83 C4 2C C3 }
	condition:
		$1
}

rule file_799_0_0 {
	meta:
		name = "__strtoul_internal"
		size = 55
		refs = "0004 __libc_tsd_LOCALE 002f ____strtoul_l_internal"
	strings:
		$1 = { 83 EC 2C A1 ?? ?? ?? ?? 65 8B 00 89 44 24 10 8B 44 24 3C 89 44 24 0C 8B 44 24 38 89 44 24 08 8B 44 24 34 89 44 24 04 8B 44 24 30 89 04 24 E8 ?? ?? ?? ?? 83 C4 2C C3 }
	condition:
		$1
}

rule file_814_0_0 {
	meta:
		name = "__strtoull_internal"
		size = 55
		refs = "0004 __libc_tsd_LOCALE 002f ____strtoull_l_internal"
	strings:
		$1 = { 83 EC 2C A1 ?? ?? ?? ?? 65 8B 00 89 44 24 10 8B 44 24 3C 89 44 24 0C 8B 44 24 38 89 44 24 08 8B 44 24 34 89 44 24 04 8B 44 24 30 89 04 24 E8 ?? ?? ?? ?? 83 C4 2C C3 }
	condition:
		$1
}

rule file_82_0_0 {
	meta:
		name = "__wcstol_internal"
		size = 55
		refs = "0004 __libc_tsd_LOCALE 002f ____wcstol_l_internal"
	strings:
		$1 = { 83 EC 2C A1 ?? ?? ?? ?? 65 8B 00 89 44 24 10 8B 44 24 3C 89 44 24 0C 8B 44 24 38 89 44 24 08 8B 44 24 34 89 44 24 04 8B 44 24 30 89 04 24 E8 ?? ?? ?? ?? 83 C4 2C C3 }
	condition:
		$1
}

rule file_717_0_0 {
	meta:
		name = "__wcstoll_internal"
		size = 55
		refs = "0004 __libc_tsd_LOCALE 002f ____wcstoll_l_internal"
	strings:
		$1 = { 83 EC 2C A1 ?? ?? ?? ?? 65 8B 00 89 44 24 10 8B 44 24 3C 89 44 24 0C 8B 44 24 38 89 44 24 08 8B 44 24 34 89 44 24 04 8B 44 24 30 89 04 24 E8 ?? ?? ?? ?? 83 C4 2C C3 }
	condition:
		$1
}

rule file_209_0_0 {
	meta:
		name = "__wcstoul_internal"
		size = 55
		refs = "0004 __libc_tsd_LOCALE 002f ____wcstoul_l_internal"
	strings:
		$1 = { 83 EC 2C A1 ?? ?? ?? ?? 65 8B 00 89 44 24 10 8B 44 24 3C 89 44 24 0C 8B 44 24 38 89 44 24 08 8B 44 24 34 89 44 24 04 8B 44 24 30 89 04 24 E8 ?? ?? ?? ?? 83 C4 2C C3 }
	condition:
		$1
}

rule file_854_0_0 {
	meta:
		name = "__wcstoull_internal"
		size = 55
		refs = "0004 __libc_tsd_LOCALE 002f ____wcstoull_l_internal"
	strings:
		$1 = { 83 EC 2C A1 ?? ?? ?? ?? 65 8B 00 89 44 24 10 8B 44 24 3C 89 44 24 0C 8B 44 24 38 89 44 24 08 8B 44 24 34 89 44 24 04 8B 44 24 30 89 04 24 E8 ?? ?? ?? ?? 83 C4 2C C3 }
	condition:
		$1
}

rule file_341_0_0 {
	meta:
		name = "wcsftime"
		size = 55
		refs = "0004 __libc_tsd_LOCALE 002f __wcsftime_l"
	strings:
		$1 = { 83 EC 2C A1 ?? ?? ?? ?? 65 8B 00 89 44 24 10 8B 44 24 3C 89 44 24 0C 8B 44 24 38 89 44 24 08 8B 44 24 34 89 44 24 04 8B 44 24 30 89 04 24 E8 ?? ?? ?? ?? 83 C4 2C C3 }
	condition:
		$1
}

rule file_81_0_0 {
	meta:
		name = "__socketpair"
		size = 34
		refs = "0012 _dl_sysinfo 001d __syscall_error"
	strings:
		$1 = { 89 DA B8 66 00 00 00 BB 08 00 00 00 8D 4C 24 04 FF 15 ?? ?? ?? ?? 89 D3 83 F8 83 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_82_1_0 {
	meta:
		name = "wcstol"
		size = 55
		refs = "0004 __libc_tsd_LOCALE 002f ____wcstol_l_internal"
	strings:
		$1 = { 83 EC 2C A1 ?? ?? ?? ?? 65 8B 00 C7 44 24 0C 00 00 00 00 89 44 24 10 8B 44 24 38 89 44 24 08 8B 44 24 34 89 44 24 04 8B 44 24 30 89 04 24 E8 ?? ?? ?? ?? 83 C4 2C C3 }
	condition:
		$1
}

rule file_934_1_0 {
	meta:
		name = "strtol"
		size = 55
		refs = "0004 __libc_tsd_LOCALE 002f ____strtol_l_internal"
	strings:
		$1 = { 83 EC 2C A1 ?? ?? ?? ?? 65 8B 00 C7 44 24 0C 00 00 00 00 89 44 24 10 8B 44 24 38 89 44 24 08 8B 44 24 34 89 44 24 04 8B 44 24 30 89 04 24 E8 ?? ?? ?? ?? 83 C4 2C C3 }
	condition:
		$1
}

rule file_1298_1_0 {
	meta:
		name = "strtoll"
		size = 55
		refs = "0004 __libc_tsd_LOCALE 002f ____strtoll_l_internal"
	strings:
		$1 = { 83 EC 2C A1 ?? ?? ?? ?? 65 8B 00 C7 44 24 0C 00 00 00 00 89 44 24 10 8B 44 24 38 89 44 24 08 8B 44 24 34 89 44 24 04 8B 44 24 30 89 04 24 E8 ?? ?? ?? ?? 83 C4 2C C3 }
	condition:
		$1
}

rule file_799_1_0 {
	meta:
		name = "strtoul"
		size = 55
		refs = "0004 __libc_tsd_LOCALE 002f ____strtoul_l_internal"
	strings:
		$1 = { 83 EC 2C A1 ?? ?? ?? ?? 65 8B 00 C7 44 24 0C 00 00 00 00 89 44 24 10 8B 44 24 38 89 44 24 08 8B 44 24 34 89 44 24 04 8B 44 24 30 89 04 24 E8 ?? ?? ?? ?? 83 C4 2C C3 }
	condition:
		$1
}

rule file_814_1_0 {
	meta:
		name = "strtoull"
		size = 55
		refs = "0004 __libc_tsd_LOCALE 002f ____strtoull_l_internal"
	strings:
		$1 = { 83 EC 2C A1 ?? ?? ?? ?? 65 8B 00 C7 44 24 0C 00 00 00 00 89 44 24 10 8B 44 24 38 89 44 24 08 8B 44 24 34 89 44 24 04 8B 44 24 30 89 04 24 E8 ?? ?? ?? ?? 83 C4 2C C3 }
	condition:
		$1
}

rule file_717_1_0 {
	meta:
		name = "wcstoll"
		size = 55
		refs = "0004 __libc_tsd_LOCALE 002f ____wcstoll_l_internal"
	strings:
		$1 = { 83 EC 2C A1 ?? ?? ?? ?? 65 8B 00 C7 44 24 0C 00 00 00 00 89 44 24 10 8B 44 24 38 89 44 24 08 8B 44 24 34 89 44 24 04 8B 44 24 30 89 04 24 E8 ?? ?? ?? ?? 83 C4 2C C3 }
	condition:
		$1
}

rule file_209_1_0 {
	meta:
		name = "wcstoul"
		size = 55
		refs = "0004 __libc_tsd_LOCALE 002f ____wcstoul_l_internal"
	strings:
		$1 = { 83 EC 2C A1 ?? ?? ?? ?? 65 8B 00 C7 44 24 0C 00 00 00 00 89 44 24 10 8B 44 24 38 89 44 24 08 8B 44 24 34 89 44 24 04 8B 44 24 30 89 04 24 E8 ?? ?? ?? ?? 83 C4 2C C3 }
	condition:
		$1
}

rule file_854_1_0 {
	meta:
		name = "wcstoull"
		size = 55
		refs = "0004 __libc_tsd_LOCALE 002f ____wcstoull_l_internal"
	strings:
		$1 = { 83 EC 2C A1 ?? ?? ?? ?? 65 8B 00 C7 44 24 0C 00 00 00 00 89 44 24 10 8B 44 24 38 89 44 24 08 8B 44 24 34 89 44 24 04 8B 44 24 30 89 04 24 E8 ?? ?? ?? ?? 83 C4 2C C3 }
	condition:
		$1
}

rule file_83_0_0 {
	meta:
		name = "nfsservctl"
		size = 37
		refs = "0014 _dl_sysinfo 0020 __syscall_error"
	strings:
		$1 = { 53 8B 54 24 10 8B 4C 24 0C 8B 5C 24 08 B8 A9 00 00 00 FF 15 ?? ?? ?? ?? 5B 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_84_0_0 {
	meta:
		name = "listxattr"
		size = 37
		refs = "0014 _dl_sysinfo 0020 __syscall_error"
	strings:
		$1 = { 53 8B 54 24 10 8B 4C 24 0C 8B 5C 24 08 B8 E8 00 00 00 FF 15 ?? ?? ?? ?? 5B 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_85_0_0 {
	meta:
		name = "memfrob"
		size = 36
	strings:
		$1 = { 53 8B 5C 24 0C 8B 44 24 08 85 DB 8D 0C 18 89 C2 74 10 8D B6 00 00 00 00 80 32 2A 83 C2 01 39 CA 75 F6 5B C3 }
	condition:
		$1
}

rule file_86_0_0 {
	meta:
		name = "__exit_thread"
		size = 30
		refs = "000d _dl_sysinfo 001a __syscall_error"
	strings:
		$1 = { 89 DA 8B 5C 24 04 B8 01 00 00 00 FF 15 ?? ?? ?? ?? 89 D3 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_87_0_0 {
	meta:
		name = "sigignore"
		size = 106
		refs = "0051 __sigaction"
	strings:
		$1 = { 81 EC AC 00 00 00 31 C0 8D 54 24 18 B9 20 00 00 00 89 BC 24 A8 00 00 00 89 D7 89 9C 24 A4 00 00 00 8D 5C 24 14 F3 AB 8B 84 24 B0 00 00 00 89 5C 24 04 C7 44 24 08 00 00 00 00 C7 44 24 14 01 00 00 00 89 04 24 C7 84 24 98 00 00 00 00 00 00 00 E8 ?? ?? ?? ?? 8B 9C 24 A4 00 00 00 8B BC 24 A8 00 00 00 81 C4 AC 00 00 00 C3 }
	condition:
		$1
}

rule file_88_0_0 {
	meta:
		name = "seteuid"
		size = 130
		refs = "000e __nptl_setxid 0049 __libc_errno 0067 _dl_sysinfo"
	strings:
		$1 = { 53 83 EC 38 8B 4C 24 40 83 F9 FF 74 3B B8 ?? ?? ?? ?? 85 C0 74 45 8D 44 24 1C 89 04 24 C7 44 24 1C D0 00 00 00 C7 44 24 20 FF FF FF FF 89 4C 24 24 C7 44 24 28 FF FF FF FF E8 ?? ?? ?? ?? 83 C4 38 5B C3 90 8D 74 26 00 A1 ?? ?? ?? ?? 65 C7 00 16 00 00 00 B8 FF FF FF FF EB E3 83 CA FF 89 D3 B8 D0 00 00 00 FF 15 ?? ?? ?? ?? 3D 00 F0 FF FF 76 CC 8B 15 ?? ?? ?? ?? F7 D8 65 89 02 83 C8 FF EB BC }
	condition:
		$1
}

rule file_89_0_0 {
	meta:
		name = "setlinebuf"
		size = 43
		refs = "0023 _IO_setvbuf"
	strings:
		$1 = { 83 EC 1C 8B 44 24 20 C7 44 24 0C 00 00 00 00 C7 44 24 08 01 00 00 00 C7 44 24 04 00 00 00 00 89 04 24 E8 ?? ?? ?? ?? 83 C4 1C C3 }
	condition:
		$1
}

rule file_90_0_0 {
	meta:
		name = "__libc_init_secure"
		size = 77
		refs = "0001 __libc_enable_secure_decided 0015 __geteuid 001c __getuid 002b __libc_enable_secure 0039 __getegid 0040 __getgid"
	strings:
		$1 = { A1 ?? ?? ?? ?? 85 C0 74 07 F3 C3 90 8D 74 26 00 53 83 EC 08 E8 ?? ?? ?? ?? 89 C3 E8 ?? ?? ?? ?? BA 01 00 00 00 39 C3 74 0F 89 15 ?? ?? ?? ?? 83 C4 08 5B C3 8D 74 26 00 E8 ?? ?? ?? ?? 89 C3 E8 ?? ?? ?? ?? 31 D2 39 C3 0F 95 C2 EB DC }
	condition:
		$1
}

rule file_91_0_0 {
	meta:
		name = "fchmodat"
		size = 338
		refs = "002b __have_atfcts 0042 _dl_sysinfo 005c __libc_errno 008f strlen 00ca __snprintf 00fa __atfct_seterrno"
	strings:
		$1 = { 55 89 E5 83 EC 38 8B 55 14 89 75 F8 8B 75 0C 89 5D F4 89 7D FC F7 C2 FF FE FF FF 0F 85 EF 00 00 00 80 E6 01 0F 85 FE 00 00 00 A1 ?? ?? ?? ?? 85 C0 78 45 8B 5D 08 89 F1 8B 55 10 B8 32 01 00 00 FF 15 ?? ?? ?? ?? 3D 00 F0 FF FF 77 0D 8B 5D F4 8B 75 F8 8B 7D FC 89 EC 5D C3 8B 15 ?? ?? ?? ?? F7 D8 83 F8 26 65 89 02 0F 85 90 00 00 00 C7 05 ?? ?? ?? ?? FF FF FF FF 83 7D 08 9C 0F 84 86 00 00 00 80 3E 2F 0F 84 7D 00 00 00 89 34 24 E8 ?? ?? ?? ?? 85 C0 0F 84 A3 00 00 00 8D 50 20 83 C0 3E 8B 5D 08 83 E0 F0 29 C4 8D 7C 24 23 83 E7 F0 89 74 24 10 89 FE 89 5C 24 0C C7 44 24 08 ?? ?? ?? ?? 89 54 24 04 89 3C 24 E8 ?? ?? ?? ?? 89 F3 8B 4D 10 B8 0F 00 00 00 FF 15 ?? ?? ?? ?? 3D 00 F0 FF FF 0F 86 64 FF FF FF 8B 5D 08 F7 D8 89 7C 24 08 89 04 24 89 5C 24 04 E8 ?? ?? ?? ?? 83 C8 FF E9 47 FF FF FF 66 90 31 FF EB C2 8D 74 26 00 A1 ?? ?? ?? ?? 65 C7 00 16 00 00 00 B8 FF FF FF FF E9 27 FF FF FF 66 90 A1 ?? ?? ?? ?? 65 C7 00 5F 00 00 00 B8 FF FF FF FF E9 0F FF FF FF A1 ?? ?? ?? ?? 65 C7 00 02 00 00 00 83 C8 FF E9 FB FE FF FF }
	condition:
		$1
}

rule file_92_1_0 {
	meta:
		name = "__dlclose"
		size = 28
		refs = "000d _dlerror_run"
	strings:
		$1 = { 83 EC 0C B8 ?? ?? ?? ?? 8B 54 24 10 E8 ?? ?? ?? ?? 83 F8 01 19 C0 83 C4 0C F7 D0 C3 }
	condition:
		$1
}

rule file_93_0_0 {
	meta:
		name = "__ptsname_internal"
		size = 733
		refs = "000d __libc_errno 002c __isatty 0080 __ioctl 00a6 __xstat64 0125 _itoa_word 0162 memcpy 01c8 __fxstat64 022f __libc_ptyname1 0238 strlen 0276 __libc_ptyname2"
	strings:
		$1 = { 83 EC 5C 8B 44 24 64 89 5C 24 4C 8B 1D ?? ?? ?? ?? 89 6C 24 58 89 74 24 50 85 C0 89 7C 24 54 65 8B 2B 74 34 8B 44 24 60 89 04 24 E8 ?? ?? ?? ?? 85 C0 75 34 65 C7 03 19 00 00 00 B0 19 8B 5C 24 4C 8B 74 24 50 8B 7C 24 54 8B 6C 24 58 83 C4 5C C3 8D B4 26 00 00 00 00 65 C7 03 16 00 00 00 B8 16 00 00 00 EB D7 66 90 8B 54 24 60 8D 44 24 24 89 44 24 08 C7 44 24 04 30 54 04 80 89 14 24 E8 ?? ?? ?? ?? 85 C0 74 78 65 83 3B 16 74 4A 8B 44 24 6C 8B 54 24 64 C7 04 24 03 00 00 00 89 44 24 08 89 54 24 04 E8 ?? ?? ?? ?? 85 C0 78 4A 8B 4C 24 6C 8B 41 10 25 00 F0 00 00 3D 00 20 00 00 0F 84 A6 00 00 00 65 C7 03 19 00 00 00 B8 19 00 00 00 E9 67 FF FF FF 66 90 83 7C 24 68 0A 0F 87 CD 00 00 00 65 C7 03 22 00 00 00 B8 22 00 00 00 E9 49 FF FF FF 8D 74 26 00 65 8B 03 E9 3D FF FF FF 8D 44 24 3F 89 44 24 04 8B 44 24 24 C7 44 24 0C 00 00 00 00 C7 44 24 08 0A 00 00 00 C6 44 24 3F 00 89 04 24 E8 ?? ?? ?? ?? 8D 54 24 40 29 C2 8D 4A 09 3B 4C 24 68 77 AB 8B 4C 24 64 C7 01 2F 64 65 76 C7 41 04 2F 70 74 73 66 C7 41 08 2F 00 8B 4C 24 64 89 54 24 08 89 44 24 04 83 C1 09 89 0C 24 E8 ?? ?? ?? ?? E9 23 FF FF FF 8B 41 20 8B 51 24 89 C6 89 D7 89 D1 0F AC FE 08 81 E1 00 F0 FF FF 81 E6 FF 0F 00 00 09 F1 83 F9 03 74 18 83 F9 04 0F 84 EB 00 00 00 81 E9 88 00 00 00 83 F9 07 0F 87 1F FF FF FF 65 89 2B 31 C0 E9 8D FE FF FF 8B 44 24 6C 8B 54 24 60 C7 04 24 03 00 00 00 89 44 24 08 89 54 24 04 E8 ?? ?? ?? ?? 85 C0 0F 88 24 FF FF FF 8B 4C 24 6C 8B 41 20 8B 51 24 89 C6 89 D7 89 D1 0F AC FE 08 81 E1 00 F0 FF FF 81 E6 FF 0F 00 00 09 F1 83 F9 02 74 15 83 F9 04 0F 84 AE 00 00 00 83 C1 80 83 F9 07 0F 87 B5 FE FF FF 89 C6 25 FF 00 00 00 0F AC D6 0C 89 F1 30 C9 09 C1 89 4C 24 18 89 4C 24 24 C1 E9 04 C7 04 24 ?? ?? ?? ?? 89 4C 24 1C E8 ?? ?? ?? ?? 39 44 24 1C 0F 83 7F FE FF FF 8B 7C 24 64 BE ?? ?? ?? ?? B9 09 00 00 00 F3 A4 8B 54 24 1C 8B 4C 24 64 0F B6 82 ?? ?? ?? ?? C6 41 0A 00 88 41 08 8B 44 24 18 83 E0 0F 0F B6 80 ?? ?? ?? ?? 88 41 09 E9 0C FE FF FF 89 C6 25 FF 00 00 00 0F AC D6 0C 81 E6 00 FF FF FF 09 C6 81 FE BF 00 00 00 0F 86 24 FE FF FF 81 FE FF 00 00 00 0F 87 18 FE FF FF E9 F4 FE FF FF 89 C6 0F B6 C8 0F AC D6 0C 81 E6 00 FF FF FF 09 CE 83 FE 7F 0F 86 F9 FD FF FF 81 FE BF 00 00 00 0F 87 ED FD FF FF E9 33 FF FF FF }
	condition:
		$1
}

rule file_93_1_0 {
	meta:
		name = "__ptsname_r"
		size = 52
		refs = "002c __ptsname_internal"
	strings:
		$1 = { 83 EC 7C 8D 44 24 10 89 44 24 0C 8B 84 24 88 00 00 00 89 44 24 08 8B 84 24 84 00 00 00 89 44 24 04 8B 84 24 80 00 00 00 89 04 24 E8 ?? ?? ?? ?? 83 C4 7C C3 }
	condition:
		$1
}

rule file_93_2_0 {
	meta:
		name = "ptsname"
		size = 49
		refs = "001b __ptsname_r"
	strings:
		$1 = { 83 EC 1C 8B 44 24 20 C7 44 24 08 1E 00 00 00 C7 44 24 04 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 31 D2 85 C0 B8 ?? ?? ?? ?? 0F 44 D0 83 C4 1C 89 D0 C3 }
	condition:
		$1
}

rule file_94_0_0 {
	meta:
		name = "cbc_crypt"
		size = 406
		refs = "013c _des_crypt"
	strings:
		$1 = { 83 EC 6C 89 5C 24 5C 8B 9C 24 80 00 00 00 89 6C 24 68 BD 03 00 00 00 89 74 24 60 89 7C 24 64 0F B6 73 01 0F B6 3B 0F B6 4B 06 F6 44 24 78 07 89 F2 88 54 24 35 0F B6 53 03 89 F8 88 44 24 34 0F B6 43 02 C7 44 24 30 00 00 00 00 88 4C 24 3A 88 54 24 1D 88 54 24 37 0F B6 53 05 88 44 24 1C 88 44 24 36 0F B6 43 04 88 54 24 1F 88 54 24 39 0F B6 53 07 88 44 24 1E 88 44 24 38 88 54 24 3B 74 47 89 F8 88 03 89 F0 88 43 01 0F B6 44 24 1C 88 4B 06 88 53 07 88 43 02 0F B6 44 24 1D 88 43 03 0F B6 44 24 1E 88 43 04 0F B6 44 24 1F 88 43 05 89 E8 8B 5C 24 5C 8B 74 24 60 8B 7C 24 64 8B 6C 24 68 83 C4 6C C3 66 90 81 7C 24 78 00 20 00 00 77 AF 8B 44 24 7C 66 BD 02 00 8B 54 24 70 83 E0 01 89 44 24 2C 0F B6 02 88 44 24 24 0F B6 42 01 88 44 24 25 0F B6 42 02 88 44 24 26 0F B6 42 03 88 44 24 27 0F B6 42 04 88 44 24 28 0F B6 42 05 88 44 24 29 0F B6 42 06 88 44 24 2A 0F B6 42 07 88 44 24 2B 8D 44 24 24 89 44 24 08 8B 44 24 78 89 44 24 04 8B 44 24 74 89 04 24 E8 ?? ?? ?? ?? 85 C0 75 44 0F B6 44 24 36 0F B6 54 24 37 0F B6 7C 24 34 0F B6 74 24 35 88 44 24 1C 0F B6 44 24 38 88 54 24 1D 0F B6 54 24 39 0F B6 4C 24 3A 88 44 24 1E 88 54 24 1F 0F B6 54 24 3B E9 00 FF FF FF 8D B4 26 00 00 00 00 31 D2 F6 44 24 7C 02 0F 94 C2 89 D5 EB AE }
	condition:
		$1
}

rule file_94_1_0 {
	meta:
		name = "ecb_crypt"
		size = 168
		refs = "008a _des_crypt"
	strings:
		$1 = { 83 EC 4C B8 03 00 00 00 8B 54 24 58 C7 44 24 20 01 00 00 00 F6 C2 07 74 07 83 C4 4C C3 8D 76 00 81 FA 00 20 00 00 77 F1 8B 44 24 5C 8B 4C 24 50 83 E0 01 89 44 24 1C 0F B6 01 88 44 24 14 0F B6 41 01 88 44 24 15 0F B6 41 02 88 44 24 16 0F B6 41 03 88 44 24 17 0F B6 41 04 88 44 24 18 0F B6 41 05 88 44 24 19 0F B6 41 06 88 44 24 1A 0F B6 41 07 89 54 24 04 88 44 24 1B 8D 44 24 14 89 44 24 08 8B 44 24 54 89 04 24 E8 ?? ?? ?? ?? 89 C2 B8 02 00 00 00 85 D2 74 80 31 C0 F6 44 24 5C 02 0F 94 C0 E9 71 FF FF FF }
	condition:
		$1
}

rule file_95_0_0 {
	meta:
		name = "strxfrm"
		size = 47
		refs = "0004 __libc_tsd_LOCALE 0027 __strxfrm_l"
	strings:
		$1 = { 83 EC 1C A1 ?? ?? ?? ?? 65 8B 00 89 44 24 0C 8B 44 24 28 89 44 24 08 8B 44 24 24 89 44 24 04 8B 44 24 20 89 04 24 E8 ?? ?? ?? ?? 83 C4 1C C3 }
	condition:
		$1
}

rule file_1103_0_0 {
	meta:
		name = "__strtod_internal"
		size = 47
		refs = "0004 __libc_tsd_LOCALE 0027 ____strtod_l_internal"
	strings:
		$1 = { 83 EC 1C A1 ?? ?? ?? ?? 65 8B 00 89 44 24 0C 8B 44 24 28 89 44 24 08 8B 44 24 24 89 44 24 04 8B 44 24 20 89 04 24 E8 ?? ?? ?? ?? 83 C4 1C C3 }
	condition:
		$1
}

rule file_739_0_0 {
	meta:
		name = "__strtof_internal"
		size = 47
		refs = "0004 __libc_tsd_LOCALE 0027 ____strtof_l_internal"
	strings:
		$1 = { 83 EC 1C A1 ?? ?? ?? ?? 65 8B 00 89 44 24 0C 8B 44 24 28 89 44 24 08 8B 44 24 24 89 44 24 04 8B 44 24 20 89 04 24 E8 ?? ?? ?? ?? 83 C4 1C C3 }
	condition:
		$1
}

rule file_560_0_0 {
	meta:
		name = "__strtold_internal"
		size = 47
		refs = "0004 __libc_tsd_LOCALE 0027 ____strtold_l_internal"
	strings:
		$1 = { 83 EC 1C A1 ?? ?? ?? ?? 65 8B 00 89 44 24 0C 8B 44 24 28 89 44 24 08 8B 44 24 24 89 44 24 04 8B 44 24 20 89 04 24 E8 ?? ?? ?? ?? 83 C4 1C C3 }
	condition:
		$1
}

rule file_1093_0_0 {
	meta:
		name = "__wcstod_internal"
		size = 47
		refs = "0004 __libc_tsd_LOCALE 0027 ____wcstod_l_internal"
	strings:
		$1 = { 83 EC 1C A1 ?? ?? ?? ?? 65 8B 00 89 44 24 0C 8B 44 24 28 89 44 24 08 8B 44 24 24 89 44 24 04 8B 44 24 20 89 04 24 E8 ?? ?? ?? ?? 83 C4 1C C3 }
	condition:
		$1
}

rule file_1027_0_0 {
	meta:
		name = "__wcstof_internal"
		size = 47
		refs = "0004 __libc_tsd_LOCALE 0027 ____wcstof_l_internal"
	strings:
		$1 = { 83 EC 1C A1 ?? ?? ?? ?? 65 8B 00 89 44 24 0C 8B 44 24 28 89 44 24 08 8B 44 24 24 89 44 24 04 8B 44 24 20 89 04 24 E8 ?? ?? ?? ?? 83 C4 1C C3 }
	condition:
		$1
}

rule file_949_0_0 {
	meta:
		name = "__wcstold_internal"
		size = 47
		refs = "0004 __libc_tsd_LOCALE 0027 ____wcstold_l_internal"
	strings:
		$1 = { 83 EC 1C A1 ?? ?? ?? ?? 65 8B 00 89 44 24 0C 8B 44 24 28 89 44 24 08 8B 44 24 24 89 44 24 04 8B 44 24 20 89 04 24 E8 ?? ?? ?? ?? 83 C4 1C C3 }
	condition:
		$1
}

rule file_232_0_0 {
	meta:
		name = "wcsxfrm"
		size = 47
		refs = "0004 __libc_tsd_LOCALE 0027 __wcsxfrm_l"
	strings:
		$1 = { 83 EC 1C A1 ?? ?? ?? ?? 65 8B 00 89 44 24 0C 8B 44 24 28 89 44 24 08 8B 44 24 24 89 44 24 04 8B 44 24 20 89 04 24 E8 ?? ?? ?? ?? 83 C4 1C C3 }
	condition:
		$1
}

rule file_96_0_0 {
	meta:
		name = "endnetgrent_hook"
		size = 61
		refs = "0024 __nss_lookup_function"
	strings:
		$1 = { 53 89 C3 83 EC 18 8B 40 28 8D 50 FF 83 FA FD 76 07 83 C4 18 5B C3 66 90 C7 44 24 04 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 85 C0 74 05 89 1C 24 FF D0 C7 43 28 00 00 00 00 83 C4 18 5B C3 }
	condition:
		$1
}

rule file_96_1_0 {
	meta:
		name = "setup"
		size = 156
		refs = "004a __nss_lookup 006a __nss_netgroup_lookup"
	strings:
		$1 = { 83 EC 1C 89 C1 80 3D ?? ?? ?? ?? 00 89 5C 24 14 89 74 24 18 74 4A 8B 1D ?? ?? ?? ?? B8 01 00 00 00 C1 CB 09 65 33 1D 18 00 00 00 83 FB FF 74 1E 89 1A 89 4C 24 0C C7 44 24 08 00 00 00 00 C7 44 24 04 ?? ?? ?? ?? 89 14 24 E8 ?? ?? ?? ?? 8B 5C 24 14 8B 74 24 18 83 C4 1C C3 8D B6 00 00 00 00 89 D6 BA ?? ?? ?? ?? 89 F0 E8 ?? ?? ?? ?? BA FF FF FF FF 85 C0 75 02 8B 16 65 33 15 18 00 00 00 C1 C2 09 89 15 ?? ?? ?? ?? C6 05 ?? ?? ?? ?? 01 8B 5C 24 14 8B 74 24 18 83 C4 1C C3 }
	condition:
		$1
}

rule file_96_2_0 {
	meta:
		name = "__internal_setnetgrent_reuse"
		size = 358
		refs = "004b _dl_mcount_wrapper_check 008b __nss_next2 009b strlen 00a9 malloc 00cc memcpy 00fd __nss_lookup_function 0121 __libc_errno 0162 __assert_fail"
	strings:
		$1 = { 55 57 56 53 89 D3 83 EC 4C 89 44 24 24 89 D0 89 4C 24 2C 8D 6C 24 3C E8 04 FF FF FF 8D 43 28 89 44 24 28 89 C2 89 E8 E8 34 FF FF FF 85 C0 0F 85 04 01 00 00 8D 74 26 00 8B 43 10 85 C0 0F 85 FF 00 00 00 8B 44 24 3C 89 04 24 E8 ?? ?? ?? ?? 8B 44 24 24 89 5C 24 04 89 04 24 FF 54 24 3C 8B 54 24 28 C7 44 24 14 00 00 00 00 8B 73 28 89 6C 24 0C C7 44 24 08 00 00 00 00 C7 44 24 04 ?? ?? ?? ?? 89 14 24 89 44 24 10 89 C7 E8 ?? ?? ?? ?? 85 C0 74 55 8B 44 24 24 89 04 24 E8 ?? ?? ?? ?? 8D 70 01 83 C0 05 89 04 24 E8 ?? ?? ?? ?? 85 C0 89 C5 74 6D 8B 43 20 8B 54 24 24 89 45 00 8D 45 04 89 74 24 08 89 54 24 04 89 04 24 E8 ?? ?? ?? ?? 31 C0 83 FF 01 89 6B 20 0F 94 C0 83 C4 4C 5B 5E 5F 5D C3 90 8D 74 26 00 83 FF 01 0F 85 47 FF FF FF 89 34 24 C7 44 24 04 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 89 C6 0F 84 2D FF FF FF 89 04 24 E8 ?? ?? ?? ?? 89 1C 24 FF D6 E9 1B FF FF FF 8D 76 00 A1 ?? ?? ?? ?? 8B 54 24 2C 65 8B 00 89 02 83 C4 4C 31 C0 5B 5E 5F 5D C3 BF FF FF FF FF E9 51 FF FF FF C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 85 00 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_96_3_0 {
	meta:
		name = "nscd_getnetgrent"
		size = 119
		refs = "002a __rawmemchr"
	strings:
		$1 = { 53 83 EC 18 8B 5C 24 20 8B 53 18 8B 43 10 03 43 14 39 C2 73 5B 89 53 04 C7 03 00 00 00 00 89 14 24 C7 44 24 04 00 00 00 00 E8 ?? ?? ?? ?? 83 C0 01 89 43 18 89 43 08 C7 44 24 04 00 00 00 00 89 04 24 E8 ?? ?? ?? ?? 83 C0 01 89 43 18 89 43 0C C7 44 24 04 00 00 00 00 89 04 24 E8 ?? ?? ?? ?? 83 C0 01 89 43 18 B8 01 00 00 00 83 C4 18 5B C3 B8 FF FF FF FF EB F4 }
	condition:
		$1
}

rule file_96_4_0 {
	meta:
		name = "free_memory.isra.0"
		size = 64
		refs = "0018 free"
	strings:
		$1 = { 56 89 C6 53 89 D3 83 EC 14 8B 08 85 C9 74 25 90 8B 01 89 0C 24 89 06 E8 ?? ?? ?? ?? 8B 0E 85 C9 75 EE 8B 03 85 C0 74 12 8B 10 89 04 24 89 13 E8 ?? ?? ?? ?? 8B 03 85 C0 75 EE 83 C4 14 5B 5E C3 }
	condition:
		$1
}

rule file_96_11_0 {
	meta:
		name = "internal_setnetgrent"
		size = 63
		refs = "0020 __libc_errno"
	strings:
		$1 = { 83 EC 0C 89 5C 24 04 8B 5C 24 14 89 74 24 08 8B 74 24 10 8D 53 24 8D 43 20 E8 A2 FF FF FF 8B 0D ?? ?? ?? ?? 89 DA 89 F0 8B 5C 24 04 8B 74 24 08 83 C4 0C 65 03 0D 00 00 00 00 E9 91 FD FF FF }
	condition:
		$1
}

rule file_96_12_0 {
	meta:
		name = "setnetgrent"
		size = 164
		refs = "0028 __nss_not_use_nscd_netgroup 0045 __nss_database_custom 0058 __nscd_setnetgrent 0079 internal_setnetgrent"
	strings:
		$1 = { 53 31 C0 83 EC 18 B9 01 00 00 00 8B 5C 24 20 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 0D ?? ?? ?? ?? 0F 85 22 07 00 00 A1 ?? ?? ?? ?? 83 F8 00 7E 6F 83 C0 01 83 F8 64 7E 2F C7 05 ?? ?? ?? ?? 00 00 00 00 80 3D ?? ?? ?? ?? 00 75 21 C7 44 24 04 ?? ?? ?? ?? 89 1C 24 E8 ?? ?? ?? ?? 85 C0 89 C2 79 1D EB 09 8D 74 26 00 A3 ?? ?? ?? ?? C7 44 24 04 ?? ?? ?? ?? 89 1C 24 E8 ?? ?? ?? ?? 89 C2 65 83 3D 0C 00 00 00 00 74 01 F0 83 2D ?? ?? ?? ?? 01 0F 85 C2 06 00 00 83 C4 18 89 D0 5B C3 66 90 74 A1 EB C9 }
	condition:
		$1
}

rule file_96_13_0 {
	meta:
		name = "internal_endnetgrent"
		size = 30
	strings:
		$1 = { 53 83 EC 08 8B 5C 24 10 89 D8 E8 F1 FB FF FF 83 C4 08 8D 53 24 8D 43 20 5B E9 B2 FE FF FF }
	condition:
		$1
}

rule file_96_14_0 {
	meta:
		name = "endnetgrent"
		size = 74
		refs = "002a internal_endnetgrent"
	strings:
		$1 = { 83 EC 1C 31 C0 B9 01 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 0D ?? ?? ?? ?? 0F 85 77 06 00 00 C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 65 83 3D 0C 00 00 00 00 74 01 F0 83 2D ?? ?? ?? ?? 01 0F 85 63 06 00 00 83 C4 1C C3 }
	condition:
		$1
}

rule file_96_15_0 {
	meta:
		name = "internal_getnetgrent_r"
		size = 473
		refs = "002b __nss_lookup_function 0041 __libc_errno 0054 _dl_mcount_wrapper_check 00ab strcmp 00e9 strlen 00fa malloc 0127 memcpy"
	strings:
		$1 = { 55 57 56 53 83 EC 2C 8B 5C 24 4C 8B 43 28 85 C0 0F 84 7B 01 00 00 83 F8 FF 0F 84 A4 01 00 00 C7 44 24 04 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 85 C0 89 C7 0F 84 58 01 00 00 65 8B 15 00 00 00 00 A1 ?? ?? ?? ?? 01 C2 89 54 24 1C 90 8D 74 26 00 89 3C 24 E8 ?? ?? ?? ?? 8B 44 24 1C 89 1C 24 89 44 24 0C 8B 44 24 54 89 44 24 08 8B 44 24 50 89 44 24 04 FF D7 83 F8 02 0F 84 BA 00 00 00 83 F8 01 0F 85 0A 01 00 00 83 3B 01 0F 85 0B 01 00 00 8B 6B 20 8B 73 04 85 ED 74 20 8D B6 00 00 00 00 8D 45 04 89 44 24 04 89 34 24 E8 ?? ?? ?? ?? 85 C0 74 9D 8B 6D 00 85 ED 75 E6 8B 43 24 85 C0 89 C5 89 44 24 18 74 1E 8D 45 04 89 44 24 04 89 34 24 E8 ?? ?? ?? ?? 85 C0 0F 84 72 FF FF FF 8B 6D 00 85 ED 75 E2 89 34 24 E8 ?? ?? ?? ?? 89 C2 83 C0 05 89 04 24 89 54 24 14 E8 ?? ?? ?? ?? 8B 54 24 14 85 C0 89 C6 0F 84 85 00 00 00 8B 44 24 18 83 C2 01 89 06 8B 4B 04 8D 46 04 89 54 24 08 89 04 24 89 4C 24 04 E8 ?? ?? ?? ?? 89 73 24 E9 1D FF FF FF 90 8D 74 26 00 8B 53 24 85 D2 74 52 89 D6 8B 7C 24 58 EB 05 90 85 C0 75 24 8B 06 89 F9 89 DA 89 43 24 8B 43 20 89 06 8D 46 04 89 73 20 E8 0B FB FF FF 8B 73 24 85 F6 75 DC 85 C0 74 21 8B 43 28 85 C0 74 1A C7 44 24 04 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 85 C0 89 C7 0F 85 BF FE FF FF 83 C4 2C 31 C0 5B 5E 5F 5D C3 8B 53 04 8B 44 24 40 89 10 8B 44 24 44 8B 53 08 89 10 8B 44 24 48 8B 53 0C 89 10 83 C4 2C B8 01 00 00 00 5B 5E 5F 5D C3 BF ?? ?? ?? ?? 65 8B 15 00 00 00 00 A1 ?? ?? ?? ?? E9 6C FE FF FF }
	condition:
		$1
}

rule file_96_16_0 {
	meta:
		name = "__getnetgrent_r"
		size = 134
		refs = "0023 __libc_errno 0062 internal_getnetgrent_r"
	strings:
		$1 = { 83 EC 2C 31 C0 B9 01 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 0D ?? ?? ?? ?? 0F 85 67 04 00 00 A1 ?? ?? ?? ?? 65 03 05 00 00 00 00 C7 44 24 0C ?? ?? ?? ?? 89 44 24 18 8B 44 24 40 89 44 24 14 8B 44 24 3C 89 44 24 10 8B 44 24 38 89 44 24 08 8B 44 24 34 89 44 24 04 8B 44 24 30 89 04 24 E8 ?? ?? ?? ?? 89 C2 65 83 3D 0C 00 00 00 00 74 01 F0 83 2D ?? ?? ?? ?? 01 0F 85 19 04 00 00 89 D0 83 C4 2C C3 }
	condition:
		$1
}

rule file_96_17_0 {
	meta:
		name = "innetgr"
		size = 953
		refs = "000b __nss_not_use_nscd_netgroup 007c _dl_mcount_wrapper_check 00b0 __nss_lookup_function 00ff __nss_next2 015c __libc_errno 01bb __strcasecmp 01e5 strcmp 02a9 strlen 02bb malloc 02e3 memcpy 0325 __nss_database_custom 035c __nscd_innetgr 03b5 __assert_fail"
	strings:
		$1 = { 55 57 56 53 81 EC 7C 04 00 00 A1 ?? ?? ?? ?? 83 F8 00 0F 8E 63 03 00 00 83 C0 01 83 F8 64 A3 ?? ?? ?? ?? 0F 8F F0 02 00 00 8D 44 24 44 B9 0B 00 00 00 89 44 24 30 8B 7C 24 30 31 C0 F3 AB 65 A1 00 00 00 00 8B 94 24 90 04 00 00 89 44 24 3C 89 54 24 38 8D 54 24 6C 8D 44 24 40 E8 00 F9 FF FF 85 C0 0F 85 A3 00 00 00 8B 74 24 54 85 F6 0F 85 21 03 00 00 8B 44 24 40 89 04 24 E8 ?? ?? ?? ?? 8B 44 24 38 8D 54 24 44 89 54 24 04 89 04 24 FF 54 24 40 83 F8 01 89 C3 0F 84 9A 00 00 00 31 F6 8B 44 24 6C C7 44 24 04 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 85 C0 89 C7 74 11 89 04 24 E8 ?? ?? ?? ?? 8D 44 24 44 89 04 24 FF D7 85 F6 0F 85 24 02 00 00 8D 54 24 40 8D 44 24 6C C7 44 24 14 00 00 00 00 89 5C 24 10 89 54 24 0C C7 44 24 08 00 00 00 00 C7 44 24 04 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 85 C0 0F 84 5D FF FF FF 8B 44 24 68 85 C0 0F 84 60 02 00 00 8B 10 89 54 24 68 8B 54 24 64 89 10 89 44 24 64 83 C0 04 89 44 24 38 E9 20 FF FF FF 90 8D 74 26 00 8B 44 24 6C C7 44 24 04 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 85 C0 89 C6 0F 84 48 FF FF FF 8B 7C 24 3C 03 3D ?? ?? ?? ?? 89 34 24 E8 ?? ?? ?? ?? 8D 44 24 70 8D 54 24 44 89 7C 24 0C C7 44 24 08 00 04 00 00 89 44 24 04 89 14 24 FF D6 83 F8 01 0F 85 62 01 00 00 83 7C 24 44 01 0F 84 97 00 00 00 8B 44 24 48 85 C0 74 22 8B 9C 24 94 04 00 00 85 DB 74 17 8B 94 24 94 04 00 00 89 04 24 89 54 24 04 E8 ?? ?? ?? ?? 85 C0 75 9D 8B 44 24 4C 85 C0 74 26 8B 8C 24 98 04 00 00 85 C9 74 1B 8B 94 24 98 04 00 00 89 04 24 89 54 24 04 E8 ?? ?? ?? ?? 85 C0 0F 85 6F FF FF FF 8B 44 24 50 85 C0 74 26 8B 94 24 9C 04 00 00 85 D2 74 1B 8B 94 24 9C 04 00 00 89 04 24 89 54 24 04 E8 ?? ?? ?? ?? 85 C0 0F 85 41 FF FF FF BE 01 00 00 00 BB 02 00 00 00 E9 72 FE FF FF 66 90 8B 6C 24 64 8B 5C 24 48 85 ED 74 22 8D 74 26 00 8D 45 04 89 44 24 04 89 1C 24 E8 ?? ?? ?? ?? 85 C0 0F 84 09 FF FF FF 8B 6D 00 85 ED 75 E2 8B 54 24 68 85 D2 89 D5 89 54 24 34 74 1E 8D 45 04 89 44 24 04 89 1C 24 E8 ?? ?? ?? ?? 85 C0 0F 84 DD FE FF FF 8B 6D 00 85 ED 75 E2 8B 84 24 90 04 00 00 89 5C 24 04 89 04 24 E8 ?? ?? ?? ?? 85 C0 0F 84 BB FE FF FF 89 1C 24 E8 ?? ?? ?? ?? 8D 48 01 83 C0 05 89 04 24 89 4C 24 2C E8 ?? ?? ?? ?? 8B 4C 24 2C 85 C0 89 C5 0F 84 BB 00 00 00 8B 54 24 34 83 C0 04 89 50 FC 89 4C 24 08 89 5C 24 04 89 04 24 E8 ?? ?? ?? ?? 89 6C 24 68 E9 70 FE FF FF 31 F6 E9 2D FF FF FF 31 DB 83 FE 01 0F 94 C3 8D 44 24 64 8D 54 24 68 E8 E4 F8 FF FF 81 C4 7C 04 00 00 89 D8 5B 5E 5F 5D C3 C7 05 ?? ?? ?? ?? 00 00 00 00 80 3D ?? ?? ?? ?? 00 0F 85 F9 FC FF FF 8B 84 24 9C 04 00 00 8B 94 24 98 04 00 00 89 44 24 0C 8B 84 24 94 04 00 00 89 54 24 08 8B 94 24 90 04 00 00 89 44 24 04 89 14 24 E8 ?? ?? ?? ?? 85 C0 89 C3 0F 88 BF FC FF FF 81 C4 7C 04 00 00 89 D8 5B 5E 5F 5D C3 31 DB EB 84 74 A6 8D 76 00 E9 A4 FC FF FF 8D 76 00 BE FF FF FF FF 8D 76 00 E9 8F FE FF FF C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 A5 01 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_97_0_0 {
	meta:
		name = "__getsgnam_r"
		size = 454
		refs = "0051 __libc_errno 0070 _dl_mcount_wrapper_check 00d4 __nss_next2 0163 __nss_gshadow_lookup2"
	strings:
		$1 = { 55 57 56 53 83 EC 4C 80 3D ?? ?? ?? ?? 00 8B 5C 24 64 0F 84 38 01 00 00 A1 ?? ?? ?? ?? C1 C8 09 65 33 05 18 00 00 00 89 44 24 3C A1 ?? ?? ?? ?? C1 C8 09 65 33 05 18 00 00 00 83 F8 FF 89 44 24 38 0F 94 C0 0F B6 C0 85 C0 0F 85 CC 00 00 00 8B 15 ?? ?? ?? ?? 8D 6C 24 3C 89 D7 65 03 3D 00 00 00 00 89 54 24 2C 66 90 8B 44 24 3C 89 04 24 E8 ?? ?? ?? ?? 8B 44 24 6C 8B 54 24 68 89 7C 24 10 89 5C 24 04 89 44 24 0C 8B 44 24 60 89 54 24 08 89 04 24 FF 54 24 3C 83 F8 FE 89 C6 75 0E 8B 54 24 2C 65 83 3A 22 0F 84 84 00 00 00 8D 44 24 38 C7 44 24 14 00 00 00 00 89 74 24 10 89 6C 24 0C C7 44 24 08 00 00 00 00 C7 44 24 04 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 85 C0 74 8C 83 FE 01 8B 44 24 70 74 23 C7 00 00 00 00 00 0F 86 CE 00 00 00 8B 54 24 2C 65 8B 02 83 F8 22 74 49 83 C4 4C 5B 5E 5F 5D C3 8D 76 00 89 18 31 C0 8B 54 24 2C 65 89 02 83 C4 4C 5B 5E 5F 5D C3 8B 15 ?? ?? ?? ?? BE FF FF FF FF 89 54 24 2C 8D B6 00 00 00 00 8B 44 24 70 8B 54 24 2C C7 00 00 00 00 00 65 8B 02 83 F8 22 75 B7 83 FE FE 74 B2 B0 16 EB BD 90 8D 44 24 3C 31 C9 89 04 24 BA ?? ?? ?? ?? 8D 44 24 38 E8 ?? ?? ?? ?? 83 EC 04 85 C0 75 3A 8B 54 24 3C 65 33 15 18 00 00 00 C1 C2 09 89 15 ?? ?? ?? ?? 8B 54 24 38 65 33 15 18 00 00 00 C1 C2 09 89 15 ?? ?? ?? ?? C6 05 ?? ?? ?? ?? 01 E9 A5 FE FF FF 8D B6 00 00 00 00 BA FF FF FF FF 65 33 15 18 00 00 00 C1 C2 09 89 15 ?? ?? ?? ?? EB D7 31 C0 E9 46 FF FF FF }
	condition:
		$1
}

rule file_806_0_0 {
	meta:
		name = "__getaliasbyname_r"
		size = 454
		refs = "0051 __libc_errno 0070 _dl_mcount_wrapper_check 00d4 __nss_next2 0163 __nss_aliases_lookup2"
	strings:
		$1 = { 55 57 56 53 83 EC 4C 80 3D ?? ?? ?? ?? 00 8B 5C 24 64 0F 84 38 01 00 00 A1 ?? ?? ?? ?? C1 C8 09 65 33 05 18 00 00 00 89 44 24 3C A1 ?? ?? ?? ?? C1 C8 09 65 33 05 18 00 00 00 83 F8 FF 89 44 24 38 0F 94 C0 0F B6 C0 85 C0 0F 85 CC 00 00 00 8B 15 ?? ?? ?? ?? 8D 6C 24 3C 89 D7 65 03 3D 00 00 00 00 89 54 24 2C 66 90 8B 44 24 3C 89 04 24 E8 ?? ?? ?? ?? 8B 44 24 6C 8B 54 24 68 89 7C 24 10 89 5C 24 04 89 44 24 0C 8B 44 24 60 89 54 24 08 89 04 24 FF 54 24 3C 83 F8 FE 89 C6 75 0E 8B 54 24 2C 65 83 3A 22 0F 84 84 00 00 00 8D 44 24 38 C7 44 24 14 00 00 00 00 89 74 24 10 89 6C 24 0C C7 44 24 08 00 00 00 00 C7 44 24 04 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 85 C0 74 8C 83 FE 01 8B 44 24 70 74 23 C7 00 00 00 00 00 0F 86 CE 00 00 00 8B 54 24 2C 65 8B 02 83 F8 22 74 49 83 C4 4C 5B 5E 5F 5D C3 8D 76 00 89 18 31 C0 8B 54 24 2C 65 89 02 83 C4 4C 5B 5E 5F 5D C3 8B 15 ?? ?? ?? ?? BE FF FF FF FF 89 54 24 2C 8D B6 00 00 00 00 8B 44 24 70 8B 54 24 2C C7 00 00 00 00 00 65 8B 02 83 F8 22 75 B7 83 FE FE 74 B2 B0 16 EB BD 90 8D 44 24 3C 31 C9 89 04 24 BA ?? ?? ?? ?? 8D 44 24 38 E8 ?? ?? ?? ?? 83 EC 04 85 C0 75 3A 8B 54 24 3C 65 33 15 18 00 00 00 C1 C2 09 89 15 ?? ?? ?? ?? 8B 54 24 38 65 33 15 18 00 00 00 C1 C2 09 89 15 ?? ?? ?? ?? C6 05 ?? ?? ?? ?? 01 E9 A5 FE FF FF 8D B6 00 00 00 00 BA FF FF FF FF 65 33 15 18 00 00 00 C1 C2 09 89 15 ?? ?? ?? ?? EB D7 31 C0 E9 46 FF FF FF }
	condition:
		$1
}

rule file_1410_0_0 {
	meta:
		name = "__getprotobyname_r"
		size = 454
		refs = "0051 __libc_errno 0070 _dl_mcount_wrapper_check 00d4 __nss_next2 0163 __nss_protocols_lookup2"
	strings:
		$1 = { 55 57 56 53 83 EC 4C 80 3D ?? ?? ?? ?? 00 8B 5C 24 64 0F 84 38 01 00 00 A1 ?? ?? ?? ?? C1 C8 09 65 33 05 18 00 00 00 89 44 24 3C A1 ?? ?? ?? ?? C1 C8 09 65 33 05 18 00 00 00 83 F8 FF 89 44 24 38 0F 94 C0 0F B6 C0 85 C0 0F 85 CC 00 00 00 8B 15 ?? ?? ?? ?? 8D 6C 24 3C 89 D7 65 03 3D 00 00 00 00 89 54 24 2C 66 90 8B 44 24 3C 89 04 24 E8 ?? ?? ?? ?? 8B 44 24 6C 8B 54 24 68 89 7C 24 10 89 5C 24 04 89 44 24 0C 8B 44 24 60 89 54 24 08 89 04 24 FF 54 24 3C 83 F8 FE 89 C6 75 0E 8B 54 24 2C 65 83 3A 22 0F 84 84 00 00 00 8D 44 24 38 C7 44 24 14 00 00 00 00 89 74 24 10 89 6C 24 0C C7 44 24 08 00 00 00 00 C7 44 24 04 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 85 C0 74 8C 83 FE 01 8B 44 24 70 74 23 C7 00 00 00 00 00 0F 86 CE 00 00 00 8B 54 24 2C 65 8B 02 83 F8 22 74 49 83 C4 4C 5B 5E 5F 5D C3 8D 76 00 89 18 31 C0 8B 54 24 2C 65 89 02 83 C4 4C 5B 5E 5F 5D C3 8B 15 ?? ?? ?? ?? BE FF FF FF FF 89 54 24 2C 8D B6 00 00 00 00 8B 44 24 70 8B 54 24 2C C7 00 00 00 00 00 65 8B 02 83 F8 22 75 B7 83 FE FE 74 B2 B0 16 EB BD 90 8D 44 24 3C 31 C9 89 04 24 BA ?? ?? ?? ?? 8D 44 24 38 E8 ?? ?? ?? ?? 83 EC 04 85 C0 75 3A 8B 54 24 3C 65 33 15 18 00 00 00 C1 C2 09 89 15 ?? ?? ?? ?? 8B 54 24 38 65 33 15 18 00 00 00 C1 C2 09 89 15 ?? ?? ?? ?? C6 05 ?? ?? ?? ?? 01 E9 A5 FE FF FF 8D B6 00 00 00 00 BA FF FF FF FF 65 33 15 18 00 00 00 C1 C2 09 89 15 ?? ?? ?? ?? EB D7 31 C0 E9 46 FF FF FF }
	condition:
		$1
}

rule file_1273_0_0 {
	meta:
		name = "__getprotobynumber_r"
		size = 454
		refs = "0051 __libc_errno 0070 _dl_mcount_wrapper_check 00d4 __nss_next2 0163 __nss_protocols_lookup2"
	strings:
		$1 = { 55 57 56 53 83 EC 4C 80 3D ?? ?? ?? ?? 00 8B 5C 24 64 0F 84 38 01 00 00 A1 ?? ?? ?? ?? C1 C8 09 65 33 05 18 00 00 00 89 44 24 3C A1 ?? ?? ?? ?? C1 C8 09 65 33 05 18 00 00 00 83 F8 FF 89 44 24 38 0F 94 C0 0F B6 C0 85 C0 0F 85 CC 00 00 00 8B 15 ?? ?? ?? ?? 8D 6C 24 3C 89 D7 65 03 3D 00 00 00 00 89 54 24 2C 66 90 8B 44 24 3C 89 04 24 E8 ?? ?? ?? ?? 8B 44 24 6C 8B 54 24 68 89 7C 24 10 89 5C 24 04 89 44 24 0C 8B 44 24 60 89 54 24 08 89 04 24 FF 54 24 3C 83 F8 FE 89 C6 75 0E 8B 54 24 2C 65 83 3A 22 0F 84 84 00 00 00 8D 44 24 38 C7 44 24 14 00 00 00 00 89 74 24 10 89 6C 24 0C C7 44 24 08 00 00 00 00 C7 44 24 04 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 85 C0 74 8C 83 FE 01 8B 44 24 70 74 23 C7 00 00 00 00 00 0F 86 CE 00 00 00 8B 54 24 2C 65 8B 02 83 F8 22 74 49 83 C4 4C 5B 5E 5F 5D C3 8D 76 00 89 18 31 C0 8B 54 24 2C 65 89 02 83 C4 4C 5B 5E 5F 5D C3 8B 15 ?? ?? ?? ?? BE FF FF FF FF 89 54 24 2C 8D B6 00 00 00 00 8B 44 24 70 8B 54 24 2C C7 00 00 00 00 00 65 8B 02 83 F8 22 75 B7 83 FE FE 74 B2 B0 16 EB BD 90 8D 44 24 3C 31 C9 89 04 24 BA ?? ?? ?? ?? 8D 44 24 38 E8 ?? ?? ?? ?? 83 EC 04 85 C0 75 3A 8B 54 24 3C 65 33 15 18 00 00 00 C1 C2 09 89 15 ?? ?? ?? ?? 8B 54 24 38 65 33 15 18 00 00 00 C1 C2 09 89 15 ?? ?? ?? ?? C6 05 ?? ?? ?? ?? 01 E9 A5 FE FF FF 8D B6 00 00 00 00 BA FF FF FF FF 65 33 15 18 00 00 00 C1 C2 09 89 15 ?? ?? ?? ?? EB D7 31 C0 E9 46 FF FF FF }
	condition:
		$1
}

rule file_374_0_0 {
	meta:
		name = "__getrpcbyname_r"
		size = 454
		refs = "0051 __libc_errno 0070 _dl_mcount_wrapper_check 00d4 __nss_next2 0163 __nss_rpc_lookup2"
	strings:
		$1 = { 55 57 56 53 83 EC 4C 80 3D ?? ?? ?? ?? 00 8B 5C 24 64 0F 84 38 01 00 00 A1 ?? ?? ?? ?? C1 C8 09 65 33 05 18 00 00 00 89 44 24 3C A1 ?? ?? ?? ?? C1 C8 09 65 33 05 18 00 00 00 83 F8 FF 89 44 24 38 0F 94 C0 0F B6 C0 85 C0 0F 85 CC 00 00 00 8B 15 ?? ?? ?? ?? 8D 6C 24 3C 89 D7 65 03 3D 00 00 00 00 89 54 24 2C 66 90 8B 44 24 3C 89 04 24 E8 ?? ?? ?? ?? 8B 44 24 6C 8B 54 24 68 89 7C 24 10 89 5C 24 04 89 44 24 0C 8B 44 24 60 89 54 24 08 89 04 24 FF 54 24 3C 83 F8 FE 89 C6 75 0E 8B 54 24 2C 65 83 3A 22 0F 84 84 00 00 00 8D 44 24 38 C7 44 24 14 00 00 00 00 89 74 24 10 89 6C 24 0C C7 44 24 08 00 00 00 00 C7 44 24 04 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 85 C0 74 8C 83 FE 01 8B 44 24 70 74 23 C7 00 00 00 00 00 0F 86 CE 00 00 00 8B 54 24 2C 65 8B 02 83 F8 22 74 49 83 C4 4C 5B 5E 5F 5D C3 8D 76 00 89 18 31 C0 8B 54 24 2C 65 89 02 83 C4 4C 5B 5E 5F 5D C3 8B 15 ?? ?? ?? ?? BE FF FF FF FF 89 54 24 2C 8D B6 00 00 00 00 8B 44 24 70 8B 54 24 2C C7 00 00 00 00 00 65 8B 02 83 F8 22 75 B7 83 FE FE 74 B2 B0 16 EB BD 90 8D 44 24 3C 31 C9 89 04 24 BA ?? ?? ?? ?? 8D 44 24 38 E8 ?? ?? ?? ?? 83 EC 04 85 C0 75 3A 8B 54 24 3C 65 33 15 18 00 00 00 C1 C2 09 89 15 ?? ?? ?? ?? 8B 54 24 38 65 33 15 18 00 00 00 C1 C2 09 89 15 ?? ?? ?? ?? C6 05 ?? ?? ?? ?? 01 E9 A5 FE FF FF 8D B6 00 00 00 00 BA FF FF FF FF 65 33 15 18 00 00 00 C1 C2 09 89 15 ?? ?? ?? ?? EB D7 31 C0 E9 46 FF FF FF }
	condition:
		$1
}

rule file_1495_0_0 {
	meta:
		name = "__getrpcbynumber_r"
		size = 454
		refs = "0051 __libc_errno 0070 _dl_mcount_wrapper_check 00d4 __nss_next2 0163 __nss_rpc_lookup2"
	strings:
		$1 = { 55 57 56 53 83 EC 4C 80 3D ?? ?? ?? ?? 00 8B 5C 24 64 0F 84 38 01 00 00 A1 ?? ?? ?? ?? C1 C8 09 65 33 05 18 00 00 00 89 44 24 3C A1 ?? ?? ?? ?? C1 C8 09 65 33 05 18 00 00 00 83 F8 FF 89 44 24 38 0F 94 C0 0F B6 C0 85 C0 0F 85 CC 00 00 00 8B 15 ?? ?? ?? ?? 8D 6C 24 3C 89 D7 65 03 3D 00 00 00 00 89 54 24 2C 66 90 8B 44 24 3C 89 04 24 E8 ?? ?? ?? ?? 8B 44 24 6C 8B 54 24 68 89 7C 24 10 89 5C 24 04 89 44 24 0C 8B 44 24 60 89 54 24 08 89 04 24 FF 54 24 3C 83 F8 FE 89 C6 75 0E 8B 54 24 2C 65 83 3A 22 0F 84 84 00 00 00 8D 44 24 38 C7 44 24 14 00 00 00 00 89 74 24 10 89 6C 24 0C C7 44 24 08 00 00 00 00 C7 44 24 04 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 85 C0 74 8C 83 FE 01 8B 44 24 70 74 23 C7 00 00 00 00 00 0F 86 CE 00 00 00 8B 54 24 2C 65 8B 02 83 F8 22 74 49 83 C4 4C 5B 5E 5F 5D C3 8D 76 00 89 18 31 C0 8B 54 24 2C 65 89 02 83 C4 4C 5B 5E 5F 5D C3 8B 15 ?? ?? ?? ?? BE FF FF FF FF 89 54 24 2C 8D B6 00 00 00 00 8B 44 24 70 8B 54 24 2C C7 00 00 00 00 00 65 8B 02 83 F8 22 75 B7 83 FE FE 74 B2 B0 16 EB BD 90 8D 44 24 3C 31 C9 89 04 24 BA ?? ?? ?? ?? 8D 44 24 38 E8 ?? ?? ?? ?? 83 EC 04 85 C0 75 3A 8B 54 24 3C 65 33 15 18 00 00 00 C1 C2 09 89 15 ?? ?? ?? ?? 8B 54 24 38 65 33 15 18 00 00 00 C1 C2 09 89 15 ?? ?? ?? ?? C6 05 ?? ?? ?? ?? 01 E9 A5 FE FF FF 8D B6 00 00 00 00 BA FF FF FF FF 65 33 15 18 00 00 00 C1 C2 09 89 15 ?? ?? ?? ?? EB D7 31 C0 E9 46 FF FF FF }
	condition:
		$1
}

rule file_847_0_0 {
	meta:
		name = "__getspnam_r"
		size = 454
		refs = "0051 __libc_errno 0070 _dl_mcount_wrapper_check 00d4 __nss_next2 0163 __nss_shadow_lookup2"
	strings:
		$1 = { 55 57 56 53 83 EC 4C 80 3D ?? ?? ?? ?? 00 8B 5C 24 64 0F 84 38 01 00 00 A1 ?? ?? ?? ?? C1 C8 09 65 33 05 18 00 00 00 89 44 24 3C A1 ?? ?? ?? ?? C1 C8 09 65 33 05 18 00 00 00 83 F8 FF 89 44 24 38 0F 94 C0 0F B6 C0 85 C0 0F 85 CC 00 00 00 8B 15 ?? ?? ?? ?? 8D 6C 24 3C 89 D7 65 03 3D 00 00 00 00 89 54 24 2C 66 90 8B 44 24 3C 89 04 24 E8 ?? ?? ?? ?? 8B 44 24 6C 8B 54 24 68 89 7C 24 10 89 5C 24 04 89 44 24 0C 8B 44 24 60 89 54 24 08 89 04 24 FF 54 24 3C 83 F8 FE 89 C6 75 0E 8B 54 24 2C 65 83 3A 22 0F 84 84 00 00 00 8D 44 24 38 C7 44 24 14 00 00 00 00 89 74 24 10 89 6C 24 0C C7 44 24 08 00 00 00 00 C7 44 24 04 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 85 C0 74 8C 83 FE 01 8B 44 24 70 74 23 C7 00 00 00 00 00 0F 86 CE 00 00 00 8B 54 24 2C 65 8B 02 83 F8 22 74 49 83 C4 4C 5B 5E 5F 5D C3 8D 76 00 89 18 31 C0 8B 54 24 2C 65 89 02 83 C4 4C 5B 5E 5F 5D C3 8B 15 ?? ?? ?? ?? BE FF FF FF FF 89 54 24 2C 8D B6 00 00 00 00 8B 44 24 70 8B 54 24 2C C7 00 00 00 00 00 65 8B 02 83 F8 22 75 B7 83 FE FE 74 B2 B0 16 EB BD 90 8D 44 24 3C 31 C9 89 04 24 BA ?? ?? ?? ?? 8D 44 24 38 E8 ?? ?? ?? ?? 83 EC 04 85 C0 75 3A 8B 54 24 3C 65 33 15 18 00 00 00 C1 C2 09 89 15 ?? ?? ?? ?? 8B 54 24 38 65 33 15 18 00 00 00 C1 C2 09 89 15 ?? ?? ?? ?? C6 05 ?? ?? ?? ?? 01 E9 A5 FE FF FF 8D B6 00 00 00 00 BA FF FF FF FF 65 33 15 18 00 00 00 C1 C2 09 89 15 ?? ?? ?? ?? EB D7 31 C0 E9 46 FF FF FF }
	condition:
		$1
}

rule file_98_0_0 {
	meta:
		name = "getsockname"
		size = 34
		refs = "0012 _dl_sysinfo 001d __syscall_error"
	strings:
		$1 = { 89 DA B8 66 00 00 00 BB 06 00 00 00 8D 4C 24 04 FF 15 ?? ?? ?? ?? 89 D3 83 F8 83 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_100_0_0 {
	meta:
		name = "__vm86"
		size = 35
		refs = "0011 _dl_sysinfo 001e __syscall_error"
	strings:
		$1 = { 89 DA 8B 4C 24 08 8B 5C 24 04 B8 A6 00 00 00 FF 15 ?? ?? ?? ?? 89 D3 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_101_0_0 {
	meta:
		name = "__getlogin_r_chk"
		size = 38
		refs = "0022 __chk_fail 001d getlogin_r"
	strings:
		$1 = { 83 EC 0C 8B 44 24 14 3B 44 24 18 8B 54 24 10 77 10 89 44 24 14 89 54 24 10 83 C4 0C E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1441_0_0 {
	meta:
		name = "__getcwd_chk"
		size = 38
		refs = "0022 __chk_fail 001d __getcwd"
	strings:
		$1 = { 83 EC 0C 8B 44 24 14 3B 44 24 18 8B 54 24 10 77 10 89 44 24 14 89 54 24 10 83 C4 0C E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_850_0_0 {
	meta:
		name = "__getdomainname_chk"
		size = 38
		refs = "0022 __chk_fail 001d getdomainname"
	strings:
		$1 = { 83 EC 0C 8B 44 24 14 3B 44 24 18 8B 54 24 10 77 10 89 44 24 14 89 54 24 10 83 C4 0C E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_845_0_0 {
	meta:
		name = "__gethostname_chk"
		size = 38
		refs = "0022 __chk_fail 001d __gethostname"
	strings:
		$1 = { 83 EC 0C 8B 44 24 14 3B 44 24 18 8B 54 24 10 77 10 89 44 24 14 89 54 24 10 83 C4 0C E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_102_0_0 {
	meta:
		name = "semtimedop"
		size = 50
		refs = "001f _dl_sysinfo 002d __syscall_error"
	strings:
		$1 = { 55 53 57 BB 04 00 00 00 8B 4C 24 10 8B 54 24 18 8B 7C 24 14 8B 6C 24 1C B8 75 00 00 00 FF 15 ?? ?? ?? ?? 5F 5B 5D 3D 00 F0 FF FF 0F 87 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_103_0_0 {
	meta:
		name = "__vswprintf_chk"
		size = 246
		refs = "004a _IO_wstrn_jumps 0062 _IO_no_init 0072 _IO_fwide 00a2 _IO_wstr_init_static 00c0 _IO_vfwprintf 00f2 __chk_fail"
	strings:
		$1 = { 57 56 53 81 EC 80 02 00 00 8B B4 24 94 02 00 00 39 B4 24 9C 02 00 00 8B BC 24 90 02 00 00 0F 82 CD 00 00 00 85 F6 C7 84 24 28 01 00 00 00 00 00 00 0F 84 B3 00 00 00 8D 44 24 24 8D 9C 24 E0 00 00 00 89 44 24 0C C7 44 24 10 ?? ?? ?? ?? C7 44 24 08 00 00 00 00 C7 44 24 04 00 80 00 00 89 1C 24 E8 ?? ?? ?? ?? C7 44 24 04 01 00 00 00 89 1C 24 E8 ?? ?? ?? ?? 8B 84 24 98 02 00 00 C7 07 00 00 00 00 85 C0 7E 08 83 8C 24 1C 01 00 00 04 83 EE 01 89 7C 24 0C 89 74 24 08 89 7C 24 04 89 1C 24 E8 ?? ?? ?? ?? 8B 84 24 A4 02 00 00 89 1C 24 89 44 24 08 8B 84 24 A0 02 00 00 89 44 24 04 E8 ?? ?? ?? ?? 8B 94 24 38 01 00 00 8D 8C 24 80 01 00 00 39 4A 18 74 13 8B 52 10 C7 02 00 00 00 00 81 C4 80 02 00 00 5B 5E 5F C3 B8 FF FF FF FF EB EF E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_104_0_0 {
	meta:
		name = "__swapoff"
		size = 31
		refs = "000d _dl_sysinfo 001a __syscall_error"
	strings:
		$1 = { 89 DA 8B 5C 24 04 B8 73 00 00 00 FF 15 ?? ?? ?? ?? 89 D3 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_105_0_0 {
	meta:
		name = "__gmtime_r"
		size = 35
		refs = "001b __tz_convert"
	strings:
		$1 = { 83 EC 1C 8B 44 24 24 C7 44 24 04 00 00 00 00 89 44 24 08 8B 44 24 20 89 04 24 E8 ?? ?? ?? ?? 83 C4 1C C3 }
	condition:
		$1
}

rule file_106_0_0 {
	meta:
		name = "__rmdir"
		size = 31
		refs = "000d _dl_sysinfo 001a __syscall_error"
	strings:
		$1 = { 89 DA 8B 5C 24 04 B8 28 00 00 00 FF 15 ?? ?? ?? ?? 89 D3 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_107_0_0 {
	meta:
		name = "read_int"
		size = 103
	strings:
		$1 = { 55 57 BF FF FF FF 7F 56 53 8B 10 0F B6 0A 83 E9 30 8D B4 26 00 00 00 00 83 C2 01 89 10 0F B6 1A 83 EB 30 83 FB 09 77 31 85 C9 78 EC 81 F9 CC CC CC 0C 7F 2C 8D 34 89 89 FD 01 F6 29 DD B9 FF FF FF FF 01 F3 39 EE 0F 4E CB 83 C2 01 89 10 0F B6 1A 83 EB 30 83 FB 09 76 CF 5B 89 C8 5E 5F 5D C3 B9 FF FF FF FF EB B1 }
	condition:
		$1
}

rule file_107_1_0 {
	meta:
		name = "__parse_one_specmb"
		size = 1566
		refs = "00ad __printf_modifier_table 0165 __printf_function_table 01ed __strchrnul 046a __handle_registered_modifier_mb 0544 __printf_arginfo_table"
	strings:
		$1 = { 55 57 56 53 83 EC 1C 8B 7C 24 30 8B 5C 24 38 8D 77 01 89 74 24 30 0F B6 53 0C 0F B6 43 0D C7 43 24 FF FF FF FF C7 43 10 20 00 00 00 83 E2 07 83 E0 F2 88 53 0C 88 43 0D 0F B6 47 01 0F B6 C8 83 E9 30 83 F9 09 0F 86 B5 01 00 00 90 8D 74 26 00 83 E8 20 3C 29 0F 86 85 00 00 00 83 E2 20 74 07 C7 43 10 20 00 00 00 C7 43 20 FF FF FF FF C7 43 04 00 00 00 00 0F B6 06 3C 2A 0F 84 E0 01 00 00 83 E8 30 31 FF 83 F8 09 0F 86 0A 02 00 00 C7 43 1C FF FF FF FF C7 03 FF FF FF FF 80 3E 2E 0F 84 8C 01 00 00 80 63 0C F8 80 63 0D FD A1 ?? ?? ?? ?? 66 C7 43 0E 00 00 85 C0 0F 85 92 03 00 00 0F B6 16 8D 46 01 89 44 24 30 83 EA 4C 80 FA 2E 76 77 89 74 24 30 0F B6 0E E9 86 00 00 00 8D 76 00 0F B6 C0 FF 24 85 ?? ?? ?? ?? 8D B6 00 00 00 00 80 4B 0D 08 8D 74 26 00 83 C6 01 89 74 24 30 0F B6 06 84 C0 0F 85 46 FF FF FF E9 4C FF FF FF 90 C7 43 10 30 00 00 00 EB DF 8D B4 26 00 00 00 00 83 CA 20 88 53 0C EB D0 83 CA 40 88 53 0C EB C8 83 CA 80 88 53 0C EB C0 83 CA 08 88 53 0C EB B8 83 CA 10 88 53 0C EB B0 0F B6 D2 FF 24 95 ?? ?? ?? ?? 8D B6 00 00 00 00 80 63 0C FA 0F B6 4E 01 8D 46 02 83 3D ?? ?? ?? ?? 00 89 4B 08 89 44 24 30 C7 43 30 FF FF FF FF 0F 85 C5 03 00 00 8B 43 08 C7 43 2C 01 00 00 00 83 F8 64 0F 84 66 03 00 00 0F 8F 0B 04 00 00 83 F8 47 0F 8F E1 03 00 00 83 F8 45 0F 8D 24 03 00 00 83 F8 41 0F 84 1B 03 00 00 83 F8 43 0F 84 06 03 00 00 C7 43 2C 00 00 00 00 8D B6 00 00 00 00 83 7B 24 FF 0F 84 D6 02 00 00 85 C0 8B 44 24 30 0F 84 B2 02 00 00 89 43 14 C7 44 24 04 25 00 00 00 89 04 24 E8 ?? ?? ?? ?? 89 43 18 83 C4 1C 89 F8 5B 5E 5F 5D C3 66 90 8D 44 24 30 E8 87 FD FF FF 85 C0 74 0D 8B 54 24 30 80 3A 24 0F 84 A6 01 00 00 89 74 24 30 0F B6 47 01 0F B6 53 0C E9 25 FE FF FF 90 8D 74 26 00 8D 56 01 89 54 24 30 0F B6 46 01 3C 2A 0F 84 4D 01 00 00 83 E8 30 83 F8 09 0F 86 21 01 00 00 C7 03 00 00 00 00 89 D6 E9 48 FE FF FF 8D 74 26 00 8D 7E 01 89 7C 24 30 0F B6 46 01 83 E8 30 83 F8 09 76 45 8B 44 24 34 89 FE 89 7C 24 30 BF 01 00 00 00 89 43 20 83 C0 01 89 44 24 34 E9 FD FD FF FF 8D B4 26 00 00 00 00 8D 44 24 30 E8 EF FC FF FF 83 F8 FF 74 03 89 43 04 8B 74 24 30 E9 DC FD FF FF 8D B6 00 00 00 00 8D 44 24 30 E8 CF FC FF FF 85 C0 74 2B 8B 54 24 30 80 3A 24 75 22 83 F8 FF 74 13 8B 74 24 3C 8D 48 FF 89 4B 20 8B 0E 39 C8 0F 42 C1 89 06 83 C2 01 89 54 24 30 8D 76 00 8B 43 20 85 C0 0F 88 78 FF FF FF 8B 74 24 30 31 FF E9 88 FD FF FF 66 90 80 7E 01 68 0F 84 DA 00 00 00 80 4B 0C 02 0F B6 4E 01 8D 46 02 E9 41 FE FF FF 8D B6 00 00 00 00 80 4B 0C 05 0F B6 4E 01 8D 46 02 E9 2B FE FF FF 0F B6 53 0C 8D 46 02 83 CA 04 88 53 0C 0F B6 4E 01 80 F9 6C 0F 85 11 FE FF FF 89 44 24 30 EB 04 0F B6 53 0C 83 CA 01 83 C0 01 88 53 0C 0F B6 48 FF E9 F5 FD FF FF 66 90 8D 44 24 30 E8 17 FC FF FF 83 F8 FF 74 02 89 03 8B 74 24 30 E9 1B FD FF FF 8D B4 26 00 00 00 00 8D 6E 02 89 6C 24 30 0F B6 46 02 83 E8 30 83 F8 09 76 60 8B 44 24 34 83 C7 01 89 EE 89 6C 24 30 89 43 1C 83 C0 01 89 44 24 34 E9 E5 FC FF FF 90 8D 72 01 83 F8 FF 89 74 24 30 74 13 8B 7C 24 3C 8D 48 FF 89 4B 24 8B 0F 39 C8 0F 42 C1 89 07 0F B6 42 01 0F B6 53 0C E9 64 FC FF FF 8D 46 02 89 44 24 30 8D 46 03 80 4B 0D 02 0F B6 4E 02 E9 60 FD FF FF 8D 44 24 30 E8 84 FB FF FF 85 C0 74 09 8B 54 24 30 80 3A 24 74 17 8B 43 1C 85 C0 0F 89 5C FF FF FF E9 7A FF FF FF 8D B4 26 00 00 00 00 83 F8 FF 74 13 8B 74 24 3C 8D 48 FF 89 4B 1C 8B 0E 39 C8 0F 42 C1 89 06 83 C2 01 89 54 24 30 EB C8 0F B6 16 83 3C 90 00 0F 84 61 FC FF FF 8D 4C 24 30 89 5C 24 04 89 0C 24 E8 ?? ?? ?? ?? 85 C0 74 09 8B 74 24 30 E9 44 FC FF FF 8B 44 24 30 0F B6 08 83 C0 01 E9 D9 FC FF FF 8D B6 00 00 00 00 83 E8 01 89 43 18 89 43 14 83 C4 1C 89 F8 5B 5E 5F 5D C3 90 8D 74 26 00 8B 53 2C 85 D2 0F 84 1F FD FF FF 8B 74 24 34 01 D7 89 73 24 E9 11 FD FF FF C7 43 28 02 00 00 00 E9 FB FC FF FF 0F B6 53 0C 83 E2 01 80 FA 01 19 D2 30 D2 81 C2 07 01 00 00 89 53 28 E9 DF FC FF FF 83 F8 75 74 09 83 F8 78 0F 85 C4 FC FF FF 0F B6 53 0C F6 C2 01 74 10 C7 43 28 00 01 00 00 E9 BC FC FF FF 8D 74 26 00 F6 C2 04 74 0C C7 43 28 00 02 00 00 E9 A7 FC FF FF 83 E2 02 74 0C C7 43 28 00 04 00 00 E9 96 FC FF FF 31 D2 F6 43 0D 02 0F 95 C2 89 53 28 E9 85 FC FF FF A1 ?? ?? ?? ?? 8B 04 88 85 C0 0F 84 2B FC FF FF 8D 53 30 89 54 24 0C 8D 53 28 89 54 24 08 C7 44 24 04 01 00 00 00 89 1C 24 FF D0 85 C0 89 43 2C 0F 88 05 FC FF FF 8B 43 08 E9 47 FC FF FF 83 F8 58 0F 84 6D FF FF FF 7F 48 83 F8 53 90 0F 85 25 FC FF FF C7 43 28 04 00 00 00 E9 26 FC FF FF 83 F8 6F 0F 84 4C FF FF FF 7F 45 83 F8 67 0F 8E 17 FF FF FF 83 F8 69 0F 84 38 FF FF FF 83 F8 6E 0F 85 F3 FB FF FF C7 43 28 00 08 00 00 E9 F4 FB FF FF 83 F8 61 0F 84 F0 FE FF FF 83 F8 63 0F 85 D5 FB FF FF C7 43 28 01 00 00 00 E9 D6 FB FF FF 83 F8 73 74 1B 0F 8F EC FE FF FF 83 F8 70 0F 85 B5 FB FF FF C7 43 28 05 00 00 00 E9 B6 FB FF FF C7 43 28 03 00 00 00 E9 AA FB FF FF }
	condition:
		$1
}

rule file_108_0_0 {
	meta:
		name = "__flock"
		size = 35
		refs = "0011 _dl_sysinfo 001e __syscall_error"
	strings:
		$1 = { 89 DA 8B 4C 24 08 8B 5C 24 04 B8 8F 00 00 00 FF 15 ?? ?? ?? ?? 89 D3 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_109_3_0 {
	meta:
		name = "putgrent"
		size = 466
		refs = "008f fprintf 01a9 __libc_errno 01ca __overflow"
	strings:
		$1 = { 55 57 56 53 83 EC 2C 8B 6C 24 40 8B 74 24 44 85 ED 0F 84 91 01 00 00 85 F6 0F 84 89 01 00 00 8B 06 25 00 80 00 00 75 32 8B 5E 48 65 8B 3D 08 00 00 00 3B 7B 08 74 1F B9 01 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 0B 0F 85 82 01 00 00 8B 5E 48 89 7B 08 83 43 04 01 8B 45 00 0F B6 08 80 F9 2D 74 09 80 F9 2B 0F 85 B2 00 00 00 8B 4D 04 BB ?? ?? ?? ?? 89 44 24 08 C7 44 24 04 ?? ?? ?? ?? 89 34 24 85 C9 0F 44 CB 89 4C 24 0C E8 ?? ?? ?? ?? 85 C0 78 50 8B 45 0C 85 C0 0F 84 B6 00 00 00 8B 00 85 C0 0F 84 AC 00 00 00 31 DB BF ?? ?? ?? ?? EB 14 8D 76 00 8B 45 0C 83 C3 01 8B 04 98 85 C0 0F 84 8F 00 00 00 85 DB B9 ?? ?? ?? ?? 0F 44 CF 89 44 24 08 89 4C 24 04 89 34 24 E8 ?? ?? ?? ?? 85 C0 79 D1 F7 06 00 80 00 00 75 24 8B 56 48 83 6A 04 01 75 1B C7 42 08 00 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 83 2A 01 0F 85 CB 00 00 00 B8 FF FF FF FF 83 C4 2C 5B 5E 5F 5D C3 8B 4D 04 BF ?? ?? ?? ?? 8B 5D 08 89 44 24 08 C7 44 24 04 ?? ?? ?? ?? 85 C9 0F 44 CF 89 5C 24 10 89 4C 24 0C 89 34 24 E8 ?? ?? ?? ?? E9 42 FF FF FF 8D B4 26 00 00 00 00 8B 46 14 3B 46 18 73 5E C6 00 0A 83 C0 01 B9 0A 00 00 00 89 46 14 F7 06 00 80 00 00 75 20 8B 56 48 83 6A 04 01 75 17 C7 42 08 00 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 83 2A 01 75 54 85 C9 0F 88 75 FF FF FF 83 C4 2C 31 C0 5B 5E 5F 5D C3 A1 ?? ?? ?? ?? 65 C7 00 16 00 00 00 B8 FF FF FF FF E9 5A FF FF FF C7 44 24 04 0A 00 00 00 89 34 24 E8 ?? ?? ?? ?? 89 C1 EB 9C }
	condition:
		$1
}

rule file_110_0_0 {
	meta:
		name = "svc_exit"
		size = 43
		refs = "0005 __rpc_thread_svc_pollfd 0011 free 001c __rpc_thread_svc_max_pollfd"
	strings:
		$1 = { 53 83 EC 18 E8 ?? ?? ?? ?? 89 C3 8B 00 89 04 24 E8 ?? ?? ?? ?? C7 03 00 00 00 00 E8 ?? ?? ?? ?? C7 00 00 00 00 00 83 C4 18 5B C3 }
	condition:
		$1
}

rule file_110_1_0 {
	meta:
		name = "svc_run"
		size = 319
		refs = "000c __rpc_thread_svc_max_pollfd 0023 __rpc_thread_svc_pollfd 004a realloc 009d __poll 00b6 svc_getreq_poll 00c9 __libc_errno 00ea _libc_intl_domainname 00ef __dcgettext 00f7 perror 00ff free"
	strings:
		$1 = { 55 57 56 31 F6 53 31 DB 83 EC 2C E8 ?? ?? ?? ?? 89 44 24 1C 8D 74 26 00 8B 44 24 1C 8B 28 85 ED 75 0F E8 ?? ?? ?? ?? 8B 00 85 C0 0F 84 CA 00 00 00 39 EE 0F 84 87 00 00 00 8D 04 ED 00 00 00 00 89 EF 89 44 24 04 89 1C 24 E8 ?? ?? ?? ?? 85 C0 0F 84 B5 00 00 00 89 EE 89 C3 85 ED 7E 2F E8 ?? ?? ?? ?? 89 DA 8B 00 8D 2C E8 8D B6 00 00 00 00 8B 08 83 C0 08 83 C2 08 89 4A F8 0F B7 48 FC 66 C7 42 FE 00 00 66 89 4A FC 39 E8 75 E3 C7 44 24 08 FF FF FF FF 89 7C 24 04 89 1C 24 E8 ?? ?? ?? ?? 83 F8 FF 74 22 85 C0 0F 84 6A FF FF FF 89 44 24 04 89 1C 24 E8 ?? ?? ?? ?? E9 59 FF FF FF 90 89 F7 EB 96 8D 74 26 00 A1 ?? ?? ?? ?? 65 83 38 04 0F 84 41 FF FF FF C7 44 24 08 05 00 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 89 1C 24 E8 ?? ?? ?? ?? 83 C4 2C 5B 5E 5F 5D C3 C7 44 24 08 05 00 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 89 1C 24 E8 ?? ?? ?? ?? 83 C4 2C 5B 5E 5F 5D C3 }
	condition:
		$1
}

rule file_111_0_0 {
	meta:
		name = "getchar_unlocked"
		size = 39
		refs = "0002 _IO_stdin 001f __uflow"
	strings:
		$1 = { 8B 15 ?? ?? ?? ?? 8B 4A 04 3B 4A 08 73 0A 0F B6 01 83 C1 01 89 4A 04 C3 83 EC 1C 89 14 24 E8 ?? ?? ?? ?? 83 C4 1C C3 }
	condition:
		$1
}

rule file_112_0_0 {
	meta:
		name = "inotify_init"
		size = 23
		refs = "0007 _dl_sysinfo 0012 __syscall_error"
	strings:
		$1 = { B8 23 01 00 00 FF 15 ?? ?? ?? ?? 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_113_0_0 {
	meta:
		name = "__mpn_mul"
		size = 849
		refs = "0046 __mpn_mul_1 0096 __mpn_addmul_1 00d2 __mpn_add_n 0125 __mpn_impn_mul_n 01dd __mpn_mul"
	strings:
		$1 = { 55 89 E5 57 56 53 83 EC 5C 8B 7D 18 83 FF 1F 0F 8F D3 00 00 00 31 C0 85 FF 0F 84 C1 00 00 00 8B 55 14 8B 02 83 F8 01 0F 86 3B 01 00 00 8B 5D 10 8B 75 0C 8B 55 08 89 44 24 0C 89 5C 24 08 89 74 24 04 89 14 24 E8 ?? ?? ?? ?? 8B 5D 08 8B 55 10 8B 4D 10 89 DE C1 E2 02 83 C6 04 83 FF 01 89 04 8B 7E 7D 8B 5D 14 8B 4D 08 83 C3 04 8D 3C B9 89 7D E4 89 F7 89 DE 89 D3 EB 2E 8D B6 00 00 00 00 8B 55 10 8B 4D 0C 89 44 24 0C 89 3C 24 89 54 24 08 89 4C 24 04 E8 ?? ?? ?? ?? 89 04 1F 83 C6 04 83 C7 04 3B 7D E4 74 38 8B 06 83 F8 01 77 D1 B8 00 00 00 00 75 E4 8B 55 10 83 C6 04 8B 4D 0C 89 7C 24 04 89 3C 24 83 C7 04 89 54 24 0C 89 4C 24 08 E8 ?? ?? ?? ?? 89 44 1F FC 3B 7D E4 75 C9 90 8D 65 F4 5B 5E 5F 5D C3 8D 04 FD 1E 00 00 00 8B 75 14 83 E0 F0 8B 55 0C 8B 4D 08 29 C4 8D 5C 24 23 83 E3 F0 89 5C 24 10 89 74 24 08 89 54 24 04 89 7C 24 0C 89 0C 24 89 5D D4 8D 1C BD 00 00 00 00 89 45 BC E8 ?? ?? ?? ?? 8B 75 08 8B 55 0C 89 5D DC 8B 45 BC 01 DE 89 75 CC 8B 75 10 01 DA 89 55 D8 29 FE 39 F7 0F 8E 1C 01 00 00 85 F6 75 70 8B 75 10 8B 55 08 8D 44 3E FF 8B 04 82 8D 65 F4 5B 5E 5F 5D C3 8D 76 00 74 26 8B 4D 10 8B 45 08 85 C9 8D 14 88 7E 0E 90 C7 00 00 00 00 00 83 C0 04 39 D0 75 F3 31 C0 E9 BE FE FF FF 8D 74 26 00 8B 45 10 85 C0 7E EE 8B 4D 08 31 C0 8B 5D 0C 8B 75 10 8D B6 00 00 00 00 8B 14 83 89 14 81 83 C0 01 39 F0 75 F3 31 C0 E9 8E FE FF FF 8D 74 26 00 8B 55 D4 8B 4D D8 8B 5D 14 89 74 24 10 89 14 24 89 4C 24 0C 89 5C 24 04 89 7C 24 08 E8 ?? ?? ?? ?? 8B 5D CC 8B 4D D4 89 7C 24 0C 89 5C 24 04 89 4C 24 08 89 1C 24 E8 ?? ?? ?? ?? 8B 55 D4 8B 4D DC 03 55 DC 01 D9 8B 1A 83 C2 04 83 C1 04 01 D8 89 41 FC 39 C3 77 31 39 D1 0F 84 31 FF FF FF 83 EE 01 85 F6 0F 8E 26 FF FF FF 31 C0 8D 74 26 00 8B 1C 82 89 1C 81 83 C0 01 39 F0 75 F3 E9 0E FF FF FF 8D B6 00 00 00 00 83 EE 01 0F 84 FF FE FF FF 8B 02 83 C1 04 83 C2 04 83 C0 01 89 41 FC 85 C0 74 E5 EB B2 8D 76 00 29 C4 89 FA 8D 4C 24 23 F7 DA 83 E1 F0 29 FE 89 4D D0 01 D9 8B 5D CC 03 5D DC 89 4D C8 83 C1 04 89 4D C0 89 55 C4 89 75 E0 8D B4 26 00 00 00 00 8B 4D D4 89 DE 8B 55 14 89 7C 24 0C 2B 75 DC 89 4C 24 10 8B 4D D8 89 54 24 08 8B 55 D0 89 4C 24 04 89 14 24 E8 ?? ?? ?? ?? 8B 4D D0 89 74 24 04 89 34 24 89 7C 24 0C 89 4C 24 08 E8 ?? ?? ?? ?? 8B 75 C8 8D 53 04 89 5D CC 8B 0E 01 C8 39 C1 8B 4D C0 89 03 89 F8 77 5A 39 CA 74 1C 8D 70 FF 85 F6 7E 15 31 C0 89 5D E4 8B 1C 81 89 1C 82 83 C0 01 39 F0 75 F3 8B 5D E4 8B 4D C4 8B 75 E0 01 4D E0 8B 45 E0 8B 55 DC 01 55 D8 01 F8 01 D3 39 C7 0F 8E 6A FF FF FF E9 19 FE FF FF 90 8D 74 26 00 8B 31 83 C2 04 83 C1 04 83 C6 01 89 72 FC 85 F6 75 A6 83 E8 01 75 E9 EB BF }
	condition:
		$1
}

rule file_114_0_0 {
	meta:
		name = "__dup"
		size = 31
		refs = "000d _dl_sysinfo 001a __syscall_error"
	strings:
		$1 = { 89 DA 8B 5C 24 04 B8 29 00 00 00 FF 15 ?? ?? ?? ?? 89 D3 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_115_3_0 {
	meta:
		name = "__gets_chk"
		size = 400
		refs = "0025 _IO_stdin 00ca _IO_getline 0143 __uflow 0155 __chk_fail 0187 _Unwind_Resume"
	strings:
		$1 = { 83 EC 3C 89 7C 24 34 8B 7C 24 44 89 74 24 30 8B 74 24 40 89 5C 24 2C 89 6C 24 38 85 FF 0F 84 68 01 00 00 8B 1D ?? ?? ?? ?? 8B 03 89 DA 25 00 80 00 00 75 3D 8B 6B 48 65 8B 15 08 00 00 00 3B 55 08 0F 84 F1 00 00 00 B9 01 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 4D 00 0F 85 2F 01 00 00 8B 6B 48 89 55 08 8B 15 ?? ?? ?? ?? 83 45 04 01 8B 4A 04 3B 4A 08 0F 83 C2 00 00 00 0F B6 01 83 C1 01 89 4A 04 83 F8 0A 0F 84 A1 00 00 00 8B 15 ?? ?? ?? ?? 8B 0A 89 CD 83 E1 DF 89 0A 83 E5 20 88 06 8D 47 FF 89 44 24 08 8D 46 01 89 44 24 04 A1 ?? ?? ?? ?? C7 44 24 10 00 00 00 00 C7 44 24 0C 0A 00 00 00 89 04 24 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 83 C0 01 8B 0A F6 C1 20 75 72 09 CD 89 2A 39 F8 73 6E C6 04 06 00 F7 03 00 80 00 00 75 24 8B 53 48 83 6A 04 01 75 1B C7 42 08 00 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 83 2A 01 0F 85 87 00 00 00 89 F0 8B 5C 24 2C 8B 74 24 30 8B 7C 24 34 8B 6C 24 38 83 C4 3C C3 8D 74 26 00 31 C0 EB AE 8D 74 26 00 89 DA E9 2E FF FF FF 89 14 24 E8 ?? ?? ?? ?? 83 F8 FF 0F 85 36 FF FF FF 31 F6 EB 96 E8 ?? ?? ?? ?? F7 03 00 80 00 00 89 C6 75 20 8B 53 48 83 6A 04 01 75 17 C7 42 08 00 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 83 2A 01 75 26 89 34 24 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_116_0_0 {
	meta:
		name = "__ftruncate64"
		size = 49
		refs = "0014 _dl_sysinfo 0023 __libc_errno"
	strings:
		$1 = { 53 8B 54 24 10 8B 4C 24 0C 8B 5C 24 08 B8 C2 00 00 00 FF 15 ?? ?? ?? ?? 3D 00 F0 FF FF 77 02 5B C3 8B 15 ?? ?? ?? ?? F7 D8 65 89 02 83 C8 FF 5B C3 }
	condition:
		$1
}

rule file_117_0_0 {
	meta:
		name = "__libc_fork"
		size = 708
		refs = "000b __fork_handlers 0060 _IO_list_lock 00a2 _dl_sysinfo 00cb __fork_generation_pointer 00f2 _dl_cpuclock_offset 00f7 __nptl_set_robust 0111 _IO_iter_begin 0124 _IO_iter_file 0143 _IO_iter_next 014a _IO_iter_end 0153 _IO_list_resetlock 015c _dl_load_lock 01c9 __fork_lock 01dc __libc_errno 0202 _IO_list_unlock 029c __assert_fail"
	strings:
		$1 = { 55 89 E5 57 56 53 83 EC 2C 8B 1D ?? ?? ?? ?? 85 DB 0F 84 59 02 00 00 8B 43 14 85 C0 74 EB 8B 15 ?? ?? ?? ?? 8D 48 01 F0 0F B1 4A 14 75 DB 31 F6 EB 0C 8D B6 00 00 00 00 F0 FF 43 14 89 C6 8B 43 04 85 C0 74 02 FF D0 83 EC 20 8D 44 24 1F 83 E0 F0 89 18 8B 1B 89 70 04 85 DB 75 DC 89 45 E4 E8 ?? ?? ?? ?? 65 A1 68 00 00 00 89 45 D8 65 8B 15 6C 00 00 00 89 D0 89 55 E0 F7 D8 65 A3 6C 00 00 00 65 8B 0D 08 00 00 00 31 F6 89 CF 89 4D DC 83 C7 68 BB 11 00 20 01 89 F1 89 F2 B8 78 00 00 00 FF 15 ?? ?? ?? ?? 3D 00 F0 FF FF 89 C6 0F 87 28 01 00 00 85 C0 0F 85 2D 01 00 00 65 A1 68 00 00 00 39 45 D8 0F 84 B2 01 00 00 A1 ?? ?? ?? ?? 85 C0 74 03 83 00 04 65 A1 68 00 00 00 65 A3 6C 00 00 00 0F 31 65 A3 1C 02 00 00 65 89 15 20 02 00 00 A3 ?? ?? ?? ?? B8 ?? ?? ?? ?? 85 C0 89 15 ?? ?? ?? ?? 74 0B 8B 45 DC 89 04 24 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 C3 EB 30 8D B4 26 00 00 00 00 89 1C 24 E8 ?? ?? ?? ?? 8B 40 48 C7 00 00 00 00 00 C7 40 04 00 00 00 00 C7 40 08 00 00 00 00 89 1C 24 E8 ?? ?? ?? ?? 89 C3 E8 ?? ?? ?? ?? 39 C3 75 CE E8 ?? ?? ?? ?? 8B 5D E4 C7 05 ?? ?? ?? ?? 00 00 00 00 C7 05 ?? ?? ?? ?? 00 00 00 00 C7 05 ?? ?? ?? ?? 00 00 00 00 85 DB C7 05 ?? ?? ?? ?? 01 00 00 00 C7 05 ?? ?? ?? ?? 00 00 00 00 C7 05 ?? ?? ?? ?? 00 00 00 00 74 2D 8D B6 00 00 00 00 8B 55 E4 8B 02 8B 50 0C 85 D2 74 07 FF D2 8B 4D E4 8B 01 C7 40 14 01 00 00 00 8B 45 E4 8B 40 04 85 C0 89 45 E4 75 D9 C7 05 ?? ?? ?? ?? 00 00 00 00 8D 65 F4 89 F0 5B 5E 5F 5D C3 A1 ?? ?? ?? ?? F7 DE 65 89 30 83 CE FF 65 A1 68 00 00 00 39 45 D8 0F 85 A9 00 00 00 8B 55 E0 65 89 15 6C 00 00 00 E8 ?? ?? ?? ?? 8B 4D E4 85 C9 74 C4 BF F0 00 00 00 8D B6 00 00 00 00 8B 4D E4 8B 01 8B 50 08 85 D2 74 07 FF D2 8B 55 E4 8B 02 F0 FF 48 14 0F 94 C2 84 D2 74 1D 8B 50 18 85 D2 74 16 BA 01 00 00 00 65 8B 0D 20 00 00 00 8B 58 14 83 C9 01 89 F8 CD 80 8B 4D E4 8B 49 04 85 C9 89 4D E4 75 B8 8D 65 F4 89 F0 5B 5E 5F 5D C3 8D B6 00 00 00 00 C7 45 E4 00 00 00 00 E9 E3 FD FF FF C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 8D 00 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 D3 00 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_118_0_0 {
	meta:
		name = "_IO_vasprintf"
		size = 426
		refs = "002a malloc 0068 _IO_no_init 0086 _IO_str_jumps 008b _IO_str_init_static_internal 00bb free 00c4 _IO_vfprintf 00f7 realloc 015d memcpy"
	strings:
		$1 = { 81 EC DC 00 00 00 C7 04 24 64 00 00 00 89 9C 24 CC 00 00 00 89 B4 24 D0 00 00 00 89 BC 24 D4 00 00 00 89 AC 24 D8 00 00 00 E8 ?? ?? ?? ?? 85 C0 0F 84 6A 01 00 00 8D 7C 24 20 89 C3 89 3C 24 C7 44 24 10 00 00 00 00 C7 44 24 0C 00 00 00 00 C7 44 24 08 FF FF FF FF C7 44 24 04 00 80 00 00 C7 44 24 68 00 00 00 00 E8 ?? ?? ?? ?? 89 3C 24 89 5C 24 0C C7 44 24 08 64 00 00 00 89 5C 24 04 C7 84 24 B4 00 00 00 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 84 24 E8 00 00 00 89 3C 24 83 64 24 20 FE 89 44 24 08 8B 84 24 E4 00 00 00 C7 84 24 B8 00 00 00 ?? ?? ?? ?? C7 84 24 BC 00 00 00 ?? ?? ?? ?? 89 44 24 04 E8 ?? ?? ?? ?? 85 C0 89 C7 0F 88 B6 00 00 00 8B 44 24 30 8B 5C 24 34 8B 54 24 38 29 C3 29 C2 8D 6B 01 D1 EA 39 D5 72 4D 8B 44 24 3C 89 6C 24 04 89 04 24 E8 ?? ?? ?? ?? 8B 94 24 E0 00 00 00 85 C0 89 02 74 6E C6 44 28 FF 00 89 F8 8B 9C 24 CC 00 00 00 8B B4 24 D0 00 00 00 8B BC 24 D4 00 00 00 8B AC 24 D8 00 00 00 81 C4 DC 00 00 00 C3 8D B6 00 00 00 00 89 2C 24 E8 ?? ?? ?? ?? 8B 94 24 E0 00 00 00 85 C0 89 02 74 9E 8B 74 24 3C 89 5C 24 08 89 04 24 89 74 24 04 E8 ?? ?? ?? ?? 89 34 24 E8 ?? ?? ?? ?? 8B 94 24 E0 00 00 00 8B 02 85 C0 75 92 8B 44 24 3C 8B 94 24 E0 00 00 00 89 02 EB 83 8D 76 00 8B 44 24 3C 89 04 24 E8 ?? ?? ?? ?? E9 74 FF FF FF 8D B4 26 00 00 00 00 BF FF FF FF FF E9 63 FF FF FF }
	condition:
		$1
}

rule file_119_2_0 {
	meta:
		name = "getservbyport"
		size = 276
		refs = "006d __getservbyport_r 0092 realloc 009e free 00a3 __libc_errno 00fd malloc"
	strings:
		$1 = { 55 31 C0 57 B9 01 00 00 00 56 53 83 EC 3C 8B 74 24 54 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 0D ?? ?? ?? ?? 0F 85 EA 00 00 00 A1 ?? ?? ?? ?? 8D 7C 24 2C 8B 2D ?? ?? ?? ?? 85 C0 75 10 E9 A9 00 00 00 8D B6 00 00 00 00 A3 ?? ?? ?? ?? 89 44 24 0C 8B 44 24 50 89 7C 24 14 89 6C 24 10 C7 44 24 08 ?? ?? ?? ?? 89 74 24 04 89 04 24 E8 ?? ?? ?? ?? 83 F8 22 75 6A 8B 2D ?? ?? ?? ?? 8B 1D ?? ?? ?? ?? 01 ED 89 6C 24 04 89 1C 24 89 2D ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 75 AE 89 1C 24 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 00 00 00 00 65 C7 00 0C 00 00 00 C7 44 24 2C 00 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 83 2D ?? ?? ?? ?? 01 75 50 8B 44 24 2C 83 C4 3C 5B 5E 5F 5D C3 A1 ?? ?? ?? ?? 85 C0 75 D7 EB CD C7 04 24 00 04 00 00 C7 05 ?? ?? ?? ?? 00 04 00 00 E8 ?? ?? ?? ?? 85 C0 A3 ?? ?? ?? ?? 74 AE BD 00 04 00 00 E9 39 FF FF FF }
	condition:
		$1
}

rule file_416_2_0 {
	meta:
		name = "getservbyname"
		size = 276
		refs = "006d __getservbyname_r 0092 realloc 009e free 00a3 __libc_errno 00fd malloc"
	strings:
		$1 = { 55 31 C0 57 B9 01 00 00 00 56 53 83 EC 3C 8B 74 24 54 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 0D ?? ?? ?? ?? 0F 85 EA 00 00 00 A1 ?? ?? ?? ?? 8D 7C 24 2C 8B 2D ?? ?? ?? ?? 85 C0 75 10 E9 A9 00 00 00 8D B6 00 00 00 00 A3 ?? ?? ?? ?? 89 44 24 0C 8B 44 24 50 89 7C 24 14 89 6C 24 10 C7 44 24 08 ?? ?? ?? ?? 89 74 24 04 89 04 24 E8 ?? ?? ?? ?? 83 F8 22 75 6A 8B 2D ?? ?? ?? ?? 8B 1D ?? ?? ?? ?? 01 ED 89 6C 24 04 89 1C 24 89 2D ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 75 AE 89 1C 24 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 00 00 00 00 65 C7 00 0C 00 00 00 C7 44 24 2C 00 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 83 2D ?? ?? ?? ?? 01 75 50 8B 44 24 2C 83 C4 3C 5B 5E 5F 5D C3 A1 ?? ?? ?? ?? 85 C0 75 D7 EB CD C7 04 24 00 04 00 00 C7 05 ?? ?? ?? ?? 00 04 00 00 E8 ?? ?? ?? ?? 85 C0 A3 ?? ?? ?? ?? 74 AE BD 00 04 00 00 E9 39 FF FF FF }
	condition:
		$1
}

rule file_120_0_0 {
	meta:
		name = "_IO_helper_overflow"
		size = 210
		refs = "009a __wmemmove 00c4 __woverflow"
	strings:
		$1 = { 83 EC 2C 89 74 24 20 8B 74 24 30 89 5C 24 1C 89 7C 24 24 8B 7C 24 34 89 6C 24 28 8B 56 58 8B 8E 54 01 00 00 8B 42 0C 8B 5A 10 29 C3 C1 FB 02 85 DB 75 2D 8B 4A 10 3B 4A 14 73 6D 89 39 83 C1 04 89 4A 10 89 F8 8B 5C 24 1C 8B 74 24 20 8B 7C 24 24 8B 6C 24 28 83 C4 2C C3 8D B4 26 00 00 00 00 8B 91 94 00 00 00 89 5C 24 08 89 44 24 04 89 0C 24 FF 52 1C 8D 50 FF 83 FA FD 77 4C 8B 56 58 8D 2C 85 00 00 00 00 29 C3 8B 52 0C 89 5C 24 08 8D 04 2A 89 14 24 89 44 24 04 E8 ?? ?? ?? ?? 8B 56 58 29 6A 10 85 D2 75 8B 89 7C 24 34 8B 5C 24 1C 89 74 24 30 8B 7C 24 24 8B 74 24 20 8B 6C 24 28 83 C4 2C E9 ?? ?? ?? ?? BF FF FF FF FF E9 71 FF FF FF }
	condition:
		$1
}

rule file_120_2_0 {
	meta:
		name = "buffered_vfprintf"
		size = 476
		refs = "0026 _IO_fwide 00a3 _IO_vfwprintf 00aa _pthread_cleanup_push_defer 00cc _IO_funlockfile 0182 _pthread_cleanup_pop_restore"
	strings:
		$1 = { 55 89 E5 57 89 D7 56 53 89 C3 81 EC BC 81 00 00 C7 44 24 04 01 00 00 00 8D 74 24 0C 89 04 24 89 8D 60 FE FF FF E8 ?? ?? ?? ?? 8B 8D 60 FE FF FF 83 F8 01 0F 85 7F 01 00 00 8D 95 1C FF FF FF 89 95 DC FE FF FF 8B 53 3C 8D 85 84 FE FF FF 89 B5 2C FF FF FF 89 B5 28 FF FF FF 81 C6 00 20 00 00 89 7C 24 04 89 4C 24 08 89 04 24 89 B5 30 FF FF FF 89 5D D8 C7 85 EC FE FF FF 01 00 00 00 C7 85 84 FE FF FF 04 80 AD FB C7 85 CC FE FF FF 00 00 00 00 89 95 C0 FE FF FF C7 85 18 FF FF FF ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 C6 B8 ?? ?? ?? ?? 85 C0 0F 95 C0 0F B6 C0 89 C7 0F 84 09 01 00 00 8D 85 74 FE FF FF 89 5C 24 08 C7 44 24 04 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 8B 03 25 00 80 00 00 75 44 65 8B 15 08 00 00 00 89 95 64 FE FF FF 8B 53 48 8B 8D 64 FE FF FF 3B 4A 08 74 25 B9 01 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 0A 0F 85 DF 00 00 00 8B 53 48 8B 85 64 FE FF FF 89 42 08 83 42 04 01 8B 85 DC FE FF FF 8B 48 0C 8B 50 10 29 CA C1 FA 02 85 D2 7E 2A 8B 83 94 00 00 00 89 54 24 08 89 95 60 FE FF FF 89 4C 24 04 89 1C 24 FF 50 1C 8B 95 60 FE FF FF 39 D0 B8 FF FF FF FF 0F 45 F0 F7 03 00 80 00 00 74 24 85 FF 74 16 8D 85 74 FE FF FF C7 44 24 04 00 00 00 00 89 04 24 E8 ?? ?? ?? ?? 8D 65 F4 89 F0 5B 5E 5F 5D C3 8B 53 48 83 6A 04 01 75 D3 C7 42 08 00 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 83 2A 01 75 50 EB BA 8D B6 00 00 00 00 8D 65 F4 BE FF FF FF FF 5B 89 F0 5E 5F 5D C3 C7 85 74 FE FF FF ?? ?? ?? ?? 89 9D 78 FE FF FF E9 FC FE FF FF }
	condition:
		$1
}

rule file_120_6_0 {
	meta:
		name = "_IO_vfwprintf"
		size = 19547
		refs = "000e __libc_errno 002a _IO_fwide 0088 __wcschrnul 00a8 _pthread_cleanup_push_defer 00c2 _IO_funlockfile 0163 __printf_function_table 0171 __printf_modifier_table 017e __printf_va_arg_table 02c8 free 031c _pthread_cleanup_pop_restore 04e4 __parse_one_specwc 0587 memmove 0658 _IO_wpadn 0c4e __btowc 1706 __printf_fphex 1884 __strerror_r 18d7 __strnlen 194c __mbsrtowcs 1c96 _itowa_lower_digits 1eac __printf_fp 26f5 memset 272b __printf_arginfo_table 2901 __assert_fail 290d __libc_fatal 291d _nl_current_LC_NUMERIC 2e43 _itowa_upper_digits 30f6 _itowa 332e __wcsnlen 39c2 __woverflow 3bc4 __libc_alloca_cutoff 3bd4 malloc 3ddf __wcslen 3fd6 __readonly_area"
	strings:
		$1 = { 55 89 E5 57 56 53 81 EC 2C 11 00 00 8B 1D ?? ?? ?? ?? 8B 75 08 65 8B 1B C7 44 24 04 01 00 00 00 89 34 24 89 9D 98 EF FF FF E8 ?? ?? ?? ?? 83 F8 01 0F 85 09 03 00 00 8B 06 A8 08 0F 85 07 26 00 00 8B 45 0C 85 C0 0F 84 5C 28 00 00 C7 44 24 04 01 00 00 00 89 34 24 E8 ?? ?? ?? ?? 83 F8 01 0F 85 DB 02 00 00 8B 1E F6 C3 02 0F 85 10 02 00 00 8B 55 0C 8B 7D 10 C7 44 24 04 25 00 00 00 89 14 24 89 BD BC EF FF FF E8 ?? ?? ?? ?? F6 C7 80 C7 85 9C EF FF FF 00 00 00 00 89 85 A8 EF FF FF 89 85 B8 EF FF FF 75 6F B8 ?? ?? ?? ?? 85 C0 0F 84 08 36 00 00 8D 85 F4 EF FF FF 89 74 24 08 C7 44 24 04 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 8B 1E C7 85 9C EF FF FF 01 00 00 00 81 E3 00 80 00 00 75 34 8B 56 48 65 8B 3D 08 00 00 00 3B 7A 08 74 21 89 D8 B9 01 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 0A 0F 85 30 4D 00 00 8B 56 48 89 7A 08 83 42 04 01 8B 85 A8 EF FF FF 2B 45 0C C1 F8 02 89 85 B0 EF FF FF 8B 95 B0 EF FF FF 8B 86 94 00 00 00 89 34 24 89 54 24 08 8B 55 0C 89 54 24 04 FF 50 1C 39 85 B0 EF FF FF 0F 85 57 01 00 00 8B 95 B8 EF FF FF 8B 02 85 C0 0F 84 CF 01 00 00 8B 3D ?? ?? ?? ?? 85 FF 0F 85 B6 02 00 00 8B 1D ?? ?? ?? ?? 85 DB 0F 85 A8 02 00 00 A1 ?? ?? ?? ?? 85 C0 0F 85 9B 02 00 00 C7 85 94 EF FF FF 00 00 00 00 C7 85 6C EF FF FF 00 00 00 00 C7 85 78 EF FF FF 00 00 00 00 C7 85 7C EF FF FF FF FF FF FF C7 85 74 EF FF FF 00 00 00 00 8D 42 04 8B 52 04 31 DB 89 85 B8 EF FF FF C7 85 40 EF FF FF 00 00 00 00 C7 85 48 EF FF FF 00 00 00 00 89 D0 83 E8 20 83 F8 5A 89 95 84 EF FF FF C7 85 4C EF FF FF 00 00 00 00 C7 85 44 EF FF FF 00 00 00 00 C7 85 50 EF FF FF 00 00 00 00 C7 85 64 EF FF FF 00 00 00 00 C7 85 5C EF FF FF 00 00 00 00 C7 85 68 EF FF FF 00 00 00 00 C7 85 58 EF FF FF 00 00 00 00 C7 85 70 EF FF FF 00 00 00 00 C7 85 60 EF FF FF FF FF FF FF C7 85 3C EF FF FF 00 00 00 00 C7 85 54 EF FF FF 20 00 00 00 0F 87 AA 01 00 00 0F B6 82 ?? ?? ?? ?? 8D 7D E8 89 BD A0 EF FF FF 8B 04 85 ?? ?? ?? ?? FF E0 8D B4 26 00 00 00 00 8B 4D 10 89 F0 8B 55 0C E8 D3 49 00 00 89 85 B0 EF FF FF 8B 85 B0 EF FF FF 8D 65 F4 5B 5E 5F 5D C3 8D B4 26 00 00 00 00 C7 85 94 EF FF FF 00 00 00 00 31 DB C7 85 B0 EF FF FF FF FF FF FF 8B 85 94 EF FF FF 89 04 24 E8 ?? ?? ?? ?? 89 1C 24 E8 ?? ?? ?? ?? F7 06 00 80 00 00 75 24 8B 56 48 83 6A 04 01 75 1B C7 42 08 00 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 83 2A 01 0F 85 48 4B 00 00 8B 95 9C EF FF FF 85 D2 74 89 8D 85 F4 EF FF FF 89 04 24 C7 44 24 04 00 00 00 00 E8 ?? ?? ?? ?? 8B 85 B0 EF FF FF 8D 65 F4 5B 5E 5F 5D C3 66 90 C7 85 94 EF FF FF 00 00 00 00 31 DB EB 80 66 90 C7 85 B0 EF FF FF FF FF FF FF 8B 85 B0 EF FF FF 8D 65 F4 5B 5E 5F 5D C3 8B 85 B8 EF FF FF 8D 50 04 8B 40 04 89 95 B8 EF FF FF 89 95 C8 EF FF FF 83 E8 30 83 F8 09 0F 86 25 45 00 00 8B 55 10 8B 45 10 8B 12 83 C0 04 89 85 0C EF FF FF 85 D2 89 95 70 EF FF FF 0F 88 65 45 00 00 81 BD 70 EF FF FF DE FF FF 1F 0F 87 31 44 00 00 81 BD 70 EF FF FF C7 03 00 00 76 30 8B 85 70 EF FF FF 8D 3C 85 80 00 00 00 81 FF 00 10 00 00 0F 87 01 45 00 00 8D 47 1E 83 E0 F0 29 C4 8D 44 24 23 83 E0 F0 01 F8 89 85 A0 EF FF FF 8B 85 B8 EF FF FF 8B 00 89 85 84 EF FF FF 83 E8 20 83 F8 5A 0F 86 A2 2F 00 00 8B 95 0C EF FF FF 89 55 10 83 BD 84 EF FF FF 00 75 46 8B 15 ?? ?? ?? ?? 65 C7 02 16 00 00 00 E9 8F FE FF FF C7 85 94 EF FF FF 00 00 00 00 31 DB C7 85 6C EF FF FF 00 00 00 00 C7 85 78 EF FF FF 00 00 00 00 C7 85 7C EF FF FF FF FF FF FF C7 85 74 EF FF FF 00 00 00 00 81 EC 90 06 00 00 8D 7C 24 23 83 E7 F0 89 1C 24 89 BD 90 EF FF FF C7 85 C0 EF FF FF 00 00 00 00 E8 ?? ?? ?? ?? 83 BD 7C EF FF FF FF 0F 84 91 24 00 00 8B 85 A8 EF FF FF 89 85 B8 EF FF FF 8B 00 85 C0 0F 84 E2 24 00 00 8B 9D A8 EF FF FF 31 C9 31 FF 89 B5 88 EF FF FF 89 CE C7 85 A4 EF FF FF 00 00 00 00 C7 85 A0 EF FF FF 80 06 00 00 90 03 B5 90 EF FF FF 8D 95 C0 EF FF FF 89 7C 24 04 89 1C 24 89 54 24 0C 89 74 24 08 E8 ?? ?? ?? ?? 8B 5E 18 83 85 A4 EF FF FF 01 89 9D B8 EF FF FF 01 C7 8B 03 85 C0 0F 84 6C 21 00 00 6B B5 A4 EF FF FF 34 39 B5 A0 EF FF FF 77 B5 8B 8D A0 EF FF FF 31 D2 8D 4C 09 0F 83 E1 F0 89 8D 80 EF FF FF 83 C1 1E 89 8D AC EF FF FF 89 C8 B9 10 00 00 00 F7 F1 8B 8D 80 EF FF FF C1 E0 04 29 C4 8B 85 A0 EF FF FF 8D 54 24 23 83 E2 F0 01 D1 03 85 80 EF FF FF 39 8D 90 EF FF FF 8B 8D 80 EF FF FF 89 14 24 89 74 24 08 89 95 F0 EE FF FF 0F 44 C8 8B 85 90 EF FF FF 89 8D A0 EF FF FF 89 44 24 04 E8 ?? ?? ?? ?? 8B 95 F0 EE FF FF 89 95 90 EF FF FF E9 2C FF FF FF 8B 85 B8 EF FF FF 8D 50 04 8B 40 04 89 95 B8 EF FF FF 89 85 84 EF FF FF 83 E8 20 83 F8 5A 0F 87 07 28 00 00 0F B6 80 ?? ?? ?? ?? C7 85 68 EF FF FF 00 00 00 00 C7 85 64 EF FF FF 00 00 00 00 8B 04 85 ?? ?? ?? ?? FF E0 8B 85 B8 EF FF FF 8D 50 04 8B 40 04 89 95 B8 EF FF FF 89 85 84 EF FF FF 83 E8 20 83 F8 5A 0F 87 D5 28 00 00 0F B6 80 ?? ?? ?? ?? C7 85 68 EF FF FF 01 00 00 00 C7 85 64 EF FF FF 01 00 00 00 8B 04 85 ?? ?? ?? ?? FF E0 8B BD 70 EF FF FF 83 EF 01 83 BD 4C EF FF FF 00 89 BD A0 EF FF FF 75 41 85 FF 7E 3D 89 7C 24 08 C7 44 24 04 20 00 00 00 89 34 24 E8 ?? ?? ?? ?? 81 BD B0 EF FF FF FE FF FF 7F 0F 87 32 41 00 00 BA FF FF FF 7F 2B 95 B0 EF FF FF 01 85 B0 EF FF FF 39 D0 0F 87 2C 0A 00 00 8B 55 10 8B 46 58 8B 4D 10 83 C2 04 85 C0 89 95 64 EF FF FF 8B 11 0F 84 21 41 00 00 8B 48 10 3B 48 14 0F 83 15 41 00 00 89 11 83 C1 04 83 C2 01 89 48 10 0F 84 F6 FB FF FF 81 BD B0 EF FF FF FF FF FF 7F 0F 84 E6 FB FF FF 8B BD B0 EF FF FF 83 C7 01 83 BD 4C EF FF FF 00 74 44 83 BD A0 EF FF FF 00 7E 3B 8B 95 A0 EF FF FF C7 44 24 04 20 00 00 00 89 34 24 89 54 24 08 E8 ?? ?? ?? ?? 81 FF FE FF FF 7F 0F 87 8F 40 00 00 BA FE FF FF 7F 01 C7 2B 95 B0 EF FF FF 39 D0 0F 87 B8 40 00 00 85 DB 0F 85 D6 3B 00 00 8B 9D B8 EF FF FF C7 44 24 04 25 00 00 00 83 C3 04 89 1C 24 89 9D B8 EF FF FF E8 ?? ?? ?? ?? 85 FF 89 85 B8 EF FF FF 0F 88 85 3B 00 00 8B 96 94 00 00 00 29 D8 C1 F8 02 89 5C 24 04 89 44 24 08 89 34 24 FF 52 1C 8B 95 B8 EF FF FF 89 D1 29 D9 31 DB C1 F9 02 39 C8 0F 85 2B FB FF FF B9 FF FF FF 7F 29 F9 39 C8 0F 8F 44 40 00 00 01 F8 83 85 78 EF FF FF 01 83 3A 00 89 85 B0 EF FF FF 0F 84 0E FB FF FF 8B 9D 64 EF FF FF 89 5D 10 E9 FE F9 FF FF 8B BD 88 EF FF FF 83 EF 01 83 BD 14 EF FF FF 00 75 41 85 FF 7E 3D 89 7C 24 08 C7 44 24 04 20 00 00 00 89 34 24 E8 ?? ?? ?? ?? 81 BD B0 EF FF FF FE FF FF 7F 0F 87 74 32 00 00 BA FF FF FF 7F 2B 95 B0 EF FF FF 01 85 B0 EF FF FF 39 D0 0F 87 BD 30 00 00 6B 85 78 EF FF FF 34 03 85 90 EF FF FF 0F 84 4A 38 00 00 6B 40 24 0C 8B 8D 80 EF FF FF 8B 14 01 8B 46 58 85 C0 0F 84 88 38 00 00 8B 48 10 3B 48 14 0F 83 7C 38 00 00 89 11 83 C1 04 83 C2 01 89 48 10 0F 84 5B FA FF FF 81 BD B0 EF FF FF FF FF FF 7F 0F 84 4B FA FF FF 83 85 B0 EF FF FF 01 83 BD 14 EF FF FF 00 74 41 85 FF 7E 3D 89 7C 24 08 C7 44 24 04 20 00 00 00 89 34 24 E8 ?? ?? ?? ?? 81 BD B0 EF FF FF FE FF FF 7F 0F 87 CB 31 00 00 BA FF FF FF 7F 2B 95 B0 EF FF FF 01 85 B0 EF FF FF 39 D0 0F 87 14 30 00 00 89 1C 24 E8 ?? ?? ?? ?? 8B 8D B0 EF FF FF 85 C9 0F 88 42 3F 00 00 6B 9D 78 EF FF FF 34 03 9D 90 EF FF FF 8B 8E 94 00 00 00 8B 53 14 8B 43 18 89 34 24 89 54 24 04 29 D0 C1 F8 02 89 44 24 08 FF 51 1C 8B 53 18 2B 53 14 31 DB C1 FA 02 39 D0 0F 85 A5 F9 FF FF BA FF FF FF 7F 2B 95 B0 EF FF FF 83 85 78 EF FF FF 01 01 85 B0 EF FF FF 39 D0 0F 8F 85 02 00 00 8B 9D 78 EF FF FF 39 9D A4 EF FF FF 0F 86 F9 F9 FF FF 6B BD 78 EF FF FF 34 03 BD 90 EF FF FF 0F B6 47 0C 89 C2 C0 EA 03 89 D3 89 C2 83 E3 01 C0 EA 04 89 9D 10 EF FF FF 89 D3 89 C2 83 E3 01 C0 EA 05 89 9D 24 EF FF FF 89 D3 89 C2 83 E3 01 C0 EA 06 89 9D 14 EF FF FF 89 D3 89 C2 C0 EA 07 83 E3 01 0F B6 D2 89 9D 20 EF FF FF 89 C3 89 95 1C EF FF FF 89 C2 83 E3 01 D0 EA 89 9D 34 EF FF FF 89 D3 83 E3 01 89 9D 2C EF FF FF 0F B6 57 0D 89 D1 D0 E9 89 CB 89 C1 83 E3 01 C0 E9 02 89 9D 28 EF FF FF 89 CB 8B 0F 83 E3 01 89 9D 30 EF FF FF 8B 5F 04 C0 EA 03 89 8D 8C EF FF FF 89 9D 88 EF FF FF 89 D3 8B 57 20 83 E3 01 89 9D 08 EF FF FF 0F B6 5F 10 83 FA FF 88 9D 1B EF FF FF 8B 5F 08 89 9D 38 EF FF FF 74 1D 8B 9D 80 EF FF FF 8D 14 52 8B 14 93 85 D2 89 95 88 EF FF FF 89 57 04 0F 88 8F 1F 00 00 8B 47 1C 83 F8 FF 74 1C 8B 9D 80 EF FF FF 8D 04 40 8B 04 83 85 C0 89 85 8C EF FF FF 89 07 0F 88 56 1F 00 00 8B 9D 88 EF FF FF 39 9D 8C EF FF FF 89 D8 0F 4D 85 8C EF FF FF 3D C8 03 00 00 0F 8E 26 1F 00 00 8D 1C 85 80 00 00 00 81 FB 00 10 00 00 0F 87 AB 3D 00 00 83 C3 1E 83 E3 F0 29 DC 8B 9D 8C EF FF FF 8D 4C 24 23 83 E1 F0 39 9D 88 EF FF FF 8B 9D 88 EF FF FF 8D 04 9D 80 00 00 00 8B 9D 8C EF FF FF 8D 14 9D 80 00 00 00 0F 4C C2 31 DB 01 C1 89 8D A0 EF FF FF 81 BD 38 EF FF FF FF 00 00 00 0F 8F 79 1E 00 00 A1 ?? ?? ?? ?? 85 C0 0F 84 6C 1E 00 00 8B 8D 38 EF FF FF 8B 95 38 EF FF FF 8B 0C 88 C1 E2 02 89 95 04 EF FF FF 85 C9 0F 84 4C 1E 00 00 8B 4F 2C C1 E1 02 8D 51 1E 83 E2 F0 29 D4 8D 54 24 23 83 E2 F0 89 95 0C EF FF FF 8B 57 2C 85 D2 74 34 8B 47 24 8B 95 80 EF FF FF 8D 04 40 8D 04 82 89 85 AC EF FF FF 8B 85 0C EF FF FF 8B 95 AC EF FF FF 01 C1 89 10 83 C0 04 83 C2 0C 39 C8 75 F4 A1 ?? ?? ?? ?? 8B 8D 0C EF FF FF 89 7C 24 04 8B BD 04 EF FF FF 89 34 24 89 4C 24 08 FF 14 38 83 F8 FE 0F 84 D3 1D 00 00 85 C0 0F 88 29 F7 FF FF 81 BD B0 EF FF FF FE FF FF 7F 0F 87 53 3C 00 00 BA FF FF FF 7F 2B 95 B0 EF FF FF 01 85 B0 EF FF FF 39 D0 0F 86 06 FD FF FF A1 ?? ?? ?? ?? 65 C7 00 4B 00 00 00 E9 EF F6 FF FF 83 BD 30 EF FF FF 00 0F 85 EC FB FF FF 8B BD 88 EF FF FF 83 EF 01 83 BD 14 EF FF FF 00 75 41 85 FF 7E 3D 89 7C 24 08 C7 44 24 04 20 00 00 00 89 34 24 E8 ?? ?? ?? ?? 81 BD B0 EF FF FF FE FF FF 7F 0F 87 60 2E 00 00 BA FF FF FF 7F 2B 95 B0 EF FF FF 01 85 B0 EF FF FF 39 D0 0F 87 16 0B 00 00 6B 85 78 EF FF FF 34 03 85 90 EF FF FF 0F 84 AE 3D 00 00 6B 40 24 0C 8B 95 80 EF FF FF 8B 04 02 25 FF 00 00 00 89 04 24 E8 ?? ?? ?? ?? 8B 56 58 85 D2 0F 84 6F 3D 00 00 8B 4A 10 3B 4A 14 0F 83 63 3D 00 00 89 01 83 C1 04 83 C0 01 89 4A 10 0F 84 3A F6 FF FF 81 BD B0 EF FF FF FF FF FF 7F 0F 84 2A F6 FF FF 83 85 B0 EF FF FF 01 83 BD 14 EF FF FF 00 0F 84 1C FC FF FF 85 FF 0F 8E 14 FC FF FF 89 7C 24 08 C7 44 24 04 20 00 00 00 89 34 24 E8 ?? ?? ?? ?? 81 BD B0 EF FF FF FE FF FF 7F 0F 87 A2 2D 00 00 BA FF FF FF 7F 2B 95 B0 EF FF FF 01 85 B0 EF FF FF 39 D0 0F 86 D7 FB FF FF 8B 0D ?? ?? ?? ?? 65 C7 01 4B 00 00 00 E9 BF F5 FF FF 8B 85 B8 EF FF FF 8D 50 04 8B 40 04 89 95 B8 EF FF FF 89 85 84 EF FF FF 83 E8 20 83 F8 5A 0F 87 7D 23 00 00 0F B6 80 ?? ?? ?? ?? C7 85 48 EF FF FF 01 00 00 00 8B 04 85 ?? ?? ?? ?? FF E0 8B 85 B8 EF FF FF 8D 50 04 8B 40 04 89 95 B8 EF FF FF 89 85 84 EF FF FF 83 E8 20 83 F8 5A 0F 87 C9 24 00 00 0F B6 80 ?? ?? ?? ?? C7 85 44 EF FF FF 01 00 00 00 8B 04 85 ?? ?? ?? ?? FF E0 C7 85 68 EF FF FF 08 00 00 00 83 BD 64 EF FF FF 00 0F 84 6E 21 00 00 8B 55 10 8B 4D 10 8B 45 10 C7 85 44 EF FF FF 00 00 00 00 8B 12 8B 49 04 83 C0 08 89 85 64 EF FF FF 89 95 5C EF FF FF 89 8D 58 EF FF FF C7 85 48 EF FF FF 00 00 00 00 C7 85 AC EF FF FF 00 00 00 00 83 BD 60 EF FF FF 00 0F 8C 5F 23 00 00 0F 85 D8 22 00 00 8B BD 58 EF FF FF 0B BD 5C EF FF FF 0F 85 C6 22 00 00 83 BD 40 EF FF FF 00 8B BD A0 EF FF FF 0F 84 A4 22 00 00 83 BD 68 EF FF FF 08 0F 85 97 22 00 00 8B 85 A0 EF FF FF 83 EF 04 C7 85 54 EF FF FF 20 00 00 00 C7 40 FC 30 00 00 00 8B 95 5C EF FF FF 0B 95 58 EF FF FF 0F 95 C1 0F B6 C9 89 8D 5C EF FF FF 8B 85 A0 EF FF FF 29 F8 C1 F8 02 39 85 60 EF FF FF 7F 25 83 BD 5C EF FF FF 00 74 1C 83 BD 68 EF FF FF 08 75 13 83 BD 40 EF FF FF 00 74 0A C7 47 FC 30 00 00 00 83 EF 04 8B 95 A0 EF FF FF C7 85 50 EF FF FF 00 00 00 00 29 FA 89 95 A0 EF FF FF C1 FA 02 F7 DA 89 D0 03 85 60 EF FF FF 0F 48 85 50 EF FF FF 83 BD 4C EF FF FF 00 89 95 58 EF FF FF 89 85 50 EF FF FF 0F 85 26 1B 00 00 89 D0 2B 85 50 EF FF FF 03 85 70 EF FF FF 83 BD 5C EF FF FF 00 89 85 70 EF FF FF 74 25 83 BD 68 EF FF FF 10 75 1C 83 BD 40 EF FF FF 00 0F 95 C2 83 E8 02 84 D2 0F 44 85 70 EF FF FF 89 85 70 EF FF FF 8B 85 48 EF FF FF 0B 85 AC EF FF FF 0B 85 44 EF FF FF 83 F8 01 83 95 70 EF FF FF FF 83 BD 54 EF FF FF 20 0F 84 2A 26 00 00 83 BD AC EF FF FF 00 0F 84 E8 25 00 00 8B 46 58 85 C0 0F 84 40 38 00 00 8B 50 10 3B 50 14 0F 83 34 38 00 00 C7 02 2D 00 00 00 83 C2 04 89 50 10 81 BD B0 EF FF FF FF FF FF 7F 0F 84 4C F3 FF FF 83 85 B0 EF FF FF 01 83 BD 5C EF FF FF 00 0F 84 8F 00 00 00 83 BD 68 EF FF FF 10 0F 85 82 00 00 00 83 BD 40 EF FF FF 00 74 79 8B 46 58 85 C0 0F 84 F7 2C 00 00 8B 50 10 3B 50 14 0F 83 EB 2C 00 00 C7 02 30 00 00 00 83 C2 04 89 50 10 81 BD B0 EF FF FF FF FF FF 7F 0F 84 EF F2 FF FF 8B 46 58 85 C0 0F 84 86 2C 00 00 8B 50 10 3B 50 14 0F 83 7A 2C 00 00 8B 8D 84 EF FF FF 83 C2 04 89 4A FC 83 C1 01 89 50 10 0F 84 C0 F2 FF FF 81 BD B0 EF FF FF FE FF FF 7F 0F 84 }
	condition:
		$1
}

rule file_120_7_0 {
	meta:
		name = "read_int"
		size = 74
	strings:
		$1 = { 55 BD FF FF FF 7F 57 56 53 8B 08 8B 11 83 EA 30 EB 22 85 D2 78 1E 81 FA CC CC CC 0C 7F 13 6B F2 0A 89 EF 29 DF 83 CA FF 01 F3 39 F7 0F 4D D3 EB 03 83 CA FF 83 C1 04 8B 19 83 EB 30 83 FB 09 76 D1 89 08 89 D0 5B 5E 5F 5D C3 }
	condition:
		$1
}

rule file_120_8_0 {
	meta:
		name = "group_number"
		size = 172
		refs = "0040 mempcpy"
	strings:
		$1 = { 55 89 E5 57 89 D7 56 53 83 EC 2C 0F BE 19 8D 53 FF 80 FA 7D 0F 87 88 00 00 00 89 FA 41 29 C2 83 E2 FC 8D 72 1E 83 E6 F0 29 F4 8D 74 24 1B 83 E6 F0 89 54 24 08 89 44 24 04 89 34 24 89 4D E4 E8 ?? ?? ?? ?? 8B 4D E4 89 4D E0 89 C2 89 F8 EB 4E 83 EA 04 8B 0A 4B 8D 78 FC 89 48 FC 75 3E 39 F2 76 3A 8B 4D 08 8D 78 F8 89 48 F8 8B 45 E0 0F BE 18 84 DB 78 05 80 FB 7F 75 12 89 F8 83 EA 04 8B 0A 83 E8 04 39 F2 89 08 77 F2 EB 16 84 DB 74 05 FF 45 E0 EB 07 8B 4D E0 0F BE 59 FF 89 F8 39 F2 77 AE 8D 65 F4 5B 5E 5F 5D C2 04 00 }
	condition:
		$1
}

rule file_120_9_0 {
	meta:
		name = "_i18n_number_rewrite"
		size = 281
		refs = "0019 __wctrans 002b __towctrans 0061 __libc_alloca_cutoff 008f malloc 00a8 mempcpy 00b5 _nl_current_LC_CTYPE 010b free"
	strings:
		$1 = { 55 89 E5 57 56 53 89 C3 83 EC 3C C7 04 24 ?? ?? ?? ?? 89 55 D0 89 4D DC E8 ?? ?? ?? ?? C7 04 24 2E 00 00 00 89 44 24 04 89 C7 E8 ?? ?? ?? ?? 89 7C 24 04 C7 04 24 2C 00 00 00 89 45 D8 E8 ?? ?? ?? ?? 8B 55 D0 29 DA 83 E2 FC 81 FA 00 10 00 00 89 45 D4 B8 01 00 00 00 76 16 89 14 24 89 55 D0 E8 ?? ?? ?? ?? 8B 55 D0 85 C0 0F 95 C0 0F B6 C0 84 C0 88 45 E3 74 11 8D 42 1E 83 E0 F0 29 C4 8D 74 24 1B 83 E6 F0 EB 14 89 14 24 89 55 D0 E8 ?? ?? ?? ?? 8B 55 D0 85 C0 89 C6 74 73 89 54 24 08 89 5C 24 04 89 34 24 E8 ?? ?? ?? ?? 8B 4D DC 83 E9 04 89 C2 A1 ?? ?? ?? ?? 65 8B 00 89 45 E4 EB 36 8B 02 8D 58 D0 83 FB 09 77 0D 8B 5D E4 8B 1B 8B 44 83 30 89 01 EB 1C 85 FF 74 16 89 C3 83 E3 FD 83 FB 2C 74 02 EB 0A 83 F8 2E 8B 45 D8 0F 45 45 D4 89 01 83 E9 04 83 EA 04 39 F2 8D 59 04 73 C0 80 7D E3 00 75 08 89 34 24 E8 ?? ?? ?? ?? 8D 65 F4 89 D8 5B 5E 5F 5D C3 }
	condition:
		$1
}

rule file_121_0_0 {
	meta:
		name = "__sched_setparam"
		size = 35
		refs = "0011 _dl_sysinfo 001e __syscall_error"
	strings:
		$1 = { 89 DA 8B 4C 24 08 8B 5C 24 04 B8 9A 00 00 00 FF 15 ?? ?? ?? ?? 89 D3 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_122_0_0 {
	meta:
		name = "__vswscanf"
		size = 159
		refs = "001d _IO_wstr_jumps 003a _IO_no_init 004a _IO_fwide 006d _IO_wstr_init_static 0093 _IO_vfwscanf"
	strings:
		$1 = { 53 81 EC 88 01 00 00 8D 5C 24 24 8D 84 24 C4 00 00 00 89 44 24 0C 89 1C 24 C7 44 24 10 ?? ?? ?? ?? C7 44 24 08 00 00 00 00 C7 44 24 04 00 80 00 00 C7 44 24 6C 00 00 00 00 E8 ?? ?? ?? ?? 89 1C 24 C7 44 24 04 01 00 00 00 E8 ?? ?? ?? ?? 8B 84 24 90 01 00 00 89 1C 24 C7 44 24 0C 00 00 00 00 C7 44 24 08 00 00 00 00 89 44 24 04 E8 ?? ?? ?? ?? 8B 84 24 98 01 00 00 89 1C 24 C7 44 24 0C 00 00 00 00 89 44 24 08 8B 84 24 94 01 00 00 89 44 24 04 E8 ?? ?? ?? ?? 81 C4 88 01 00 00 5B C3 }
	condition:
		$1
}

rule file_123_0_0 {
	meta:
		name = "insque"
		size = 46
	strings:
		$1 = { 8B 44 24 08 8B 54 24 04 85 C0 74 14 8B 08 89 10 85 C9 74 03 89 51 04 89 0A 89 42 04 C3 8D 76 00 C7 02 00 00 00 00 C7 42 04 00 00 00 00 C3 }
	condition:
		$1
}

rule file_123_1_0 {
	meta:
		name = "remque"
		size = 24
	strings:
		$1 = { 8B 44 24 04 8B 10 8B 40 04 85 D2 74 03 89 42 04 85 C0 74 02 89 10 F3 C3 }
	condition:
		$1
}

rule file_124_0_0 {
	meta:
		name = "strcat"
		size = 426
	strings:
		$1 = { 57 8B 54 24 08 8B 4C 24 0C F6 01 FF 0F 84 92 01 00 00 F7 C2 03 00 00 00 74 39 F6 02 FF 0F 84 A6 00 00 00 42 F7 C2 03 00 00 00 74 27 F6 02 FF 0F 84 94 00 00 00 42 F7 C2 03 00 00 00 74 15 F6 02 FF 0F 84 82 00 00 00 42 EB 09 8D B6 00 00 00 00 83 C2 10 8B 02 BF FF FE FE FE 01 C7 73 59 31 C7 81 CF FF FE FE FE 47 75 4E 8B 42 04 BF FF FE FE FE 01 C7 73 3F 31 C7 81 CF FF FE FE FE 47 75 34 8B 42 08 BF FF FE FE FE 01 C7 73 25 31 C7 81 CF FF FE FE FE 47 75 1A 8B 42 0C BF FF FE FE FE 01 C7 73 0B 31 C7 81 CF FF FE FE FE 47 74 A2 83 C2 04 83 C2 04 83 C2 04 84 C0 74 0E 42 84 E4 74 09 42 A9 00 00 FF 00 74 01 42 29 CA F7 C1 03 00 00 00 74 44 8A 01 88 04 11 20 C0 0F 84 C4 00 00 00 41 F7 C1 03 00 00 00 74 2E 8A 01 88 04 11 20 C0 0F 84 AE 00 00 00 41 F7 C1 03 00 00 00 74 18 8A 01 88 04 11 20 C0 0F 84 98 00 00 00 41 EB 08 90 89 44 11 0C 83 C1 10 8B 01 BF FF FE FE FE 01 C7 73 64 31 C7 81 CF FF FE FE FE 47 75 59 89 04 11 8B 41 04 BF FF FE FE FE 01 C7 73 47 31 C7 81 CF FF FE FE FE 47 75 3C 89 44 11 04 8B 41 08 BF FF FE FE FE 01 C7 73 29 31 C7 81 CF FF FE FE FE 47 75 1E 89 44 11 08 8B 41 0C BF FF FE FE FE 01 C7 73 0B 31 C7 81 CF FF FE FE FE 47 74 93 83 C1 04 83 C1 04 83 C1 04 88 04 11 08 C0 74 17 88 64 11 01 08 E4 74 0F C1 E8 10 88 44 11 02 08 C0 74 04 88 64 11 03 8B 44 24 08 5F C3 }
	condition:
		$1
}

rule file_125_0_0 {
	meta:
		name = "__libc_tcdrain"
		size = 152
		refs = "002a _dl_sysinfo 0047 __libc_errno 0056 __libc_enable_asynccancel 0081 __libc_disable_asynccancel"
	strings:
		$1 = { 83 EC 0C 89 5C 24 04 89 74 24 08 65 A1 0C 00 00 00 85 C0 75 40 BA 01 00 00 00 B9 09 54 00 00 8B 5C 24 10 B8 36 00 00 00 FF 15 ?? ?? ?? ?? 3D 00 F0 FF FF 77 10 89 C3 89 D8 8B 74 24 08 8B 5C 24 04 83 C4 0C C3 8B 15 ?? ?? ?? ?? F7 D8 65 89 02 83 C8 FF EB E0 E8 ?? ?? ?? ?? BA 01 00 00 00 B9 09 54 00 00 8B 5C 24 10 89 C6 B8 36 00 00 00 FF 15 ?? ?? ?? ?? 3D 00 F0 FF FF 77 0B 89 C3 89 F0 E8 ?? ?? ?? ?? EB B0 89 C3 A1 ?? ?? ?? ?? F7 DB 65 89 18 83 C8 FF EB E4 }
	condition:
		$1
}

rule file_71_0_3 {
	meta:
		name = "__libc_tcdrain"
		size = 152
		refs = "002a _dl_sysinfo 0047 errno 0056 __pthread_enable_asynccancel 0081 __pthread_disable_asynccancel"
	strings:
		$1 = { 83 EC 0C 89 5C 24 04 89 74 24 08 65 A1 0C 00 00 00 85 C0 75 40 BA 01 00 00 00 B9 09 54 00 00 8B 5C 24 10 B8 36 00 00 00 FF 15 ?? ?? ?? ?? 3D 00 F0 FF FF 77 10 89 C3 89 D8 8B 74 24 08 8B 5C 24 04 83 C4 0C C3 8B 15 ?? ?? ?? ?? F7 D8 65 89 02 83 C8 FF EB E0 E8 ?? ?? ?? ?? BA 01 00 00 00 B9 09 54 00 00 8B 5C 24 10 89 C6 B8 36 00 00 00 FF 15 ?? ?? ?? ?? 3D 00 F0 FF FF 77 0B 89 C3 89 F0 E8 ?? ?? ?? ?? EB B0 89 C3 A1 ?? ?? ?? ?? F7 DB 65 89 18 83 C8 FF EB E4 }
	condition:
		$1
}

rule file_126_0_0 {
	meta:
		name = "__sched_rr_get_interval"
		size = 35
		refs = "0011 _dl_sysinfo 001e __syscall_error"
	strings:
		$1 = { 89 DA 8B 4C 24 08 8B 5C 24 04 B8 A1 00 00 00 FF 15 ?? ?? ?? ?? 89 D3 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_127_0_0 {
	meta:
		name = "fileno"
		size = 42
		refs = "0019 __libc_errno"
	strings:
		$1 = { 8B 44 24 04 F7 00 00 20 00 00 74 0C 8B 40 38 85 C0 78 05 F3 C3 8D 76 00 A1 ?? ?? ?? ?? 65 C7 00 09 00 00 00 B8 FF FF FF FF C3 }
	condition:
		$1
}

rule file_128_0_0 {
	meta:
		name = "__default_morecore"
		size = 27
		refs = "000b __sbrk"
	strings:
		$1 = { 83 EC 1C 8B 44 24 20 89 04 24 E8 ?? ?? ?? ?? 31 D2 83 F8 FF 0F 44 C2 83 C4 1C C3 }
	condition:
		$1
}

rule file_129_6_0 {
	meta:
		name = "setsgent"
		size = 142
		refs = "0056 __nss_gshadow_lookup2 0062 __nss_setent 0068 __libc_errno"
	strings:
		$1 = { 83 EC 2C 31 C0 B9 01 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 0D ?? ?? ?? ?? 0F 85 B6 01 00 00 C7 44 24 1C 00 00 00 00 C7 44 24 18 00 00 00 00 C7 44 24 14 00 00 00 00 C7 44 24 10 ?? ?? ?? ?? C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 ?? ?? ?? ?? C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 65 8B 0A 65 83 3D 0C 00 00 00 00 74 01 F0 83 2D ?? ?? ?? ?? 01 0F 85 61 01 00 00 65 89 0A 83 C4 2C C3 }
	condition:
		$1
}

rule file_1074_6_0 {
	meta:
		name = "setaliasent"
		size = 142
		refs = "0056 __nss_aliases_lookup2 0062 __nss_setent 0068 __libc_errno"
	strings:
		$1 = { 83 EC 2C 31 C0 B9 01 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 0D ?? ?? ?? ?? 0F 85 B6 01 00 00 C7 44 24 1C 00 00 00 00 C7 44 24 18 00 00 00 00 C7 44 24 14 00 00 00 00 C7 44 24 10 ?? ?? ?? ?? C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 ?? ?? ?? ?? C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 65 8B 0A 65 83 3D 0C 00 00 00 00 74 01 F0 83 2D ?? ?? ?? ?? 01 0F 85 61 01 00 00 65 89 0A 83 C4 2C C3 }
	condition:
		$1
}

rule file_1122_6_0 {
	meta:
		name = "setgrent"
		size = 142
		refs = "0056 __nss_group_lookup2 0062 __nss_setent 0068 __libc_errno"
	strings:
		$1 = { 83 EC 2C 31 C0 B9 01 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 0D ?? ?? ?? ?? 0F 85 B6 01 00 00 C7 44 24 1C 00 00 00 00 C7 44 24 18 00 00 00 00 C7 44 24 14 00 00 00 00 C7 44 24 10 ?? ?? ?? ?? C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 ?? ?? ?? ?? C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 65 8B 0A 65 83 3D 0C 00 00 00 00 74 01 F0 83 2D ?? ?? ?? ?? 01 0F 85 61 01 00 00 65 89 0A 83 C4 2C C3 }
	condition:
		$1
}

rule file_731_6_0 {
	meta:
		name = "setpwent"
		size = 142
		refs = "0056 __nss_passwd_lookup2 0062 __nss_setent 0068 __libc_errno"
	strings:
		$1 = { 83 EC 2C 31 C0 B9 01 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 0D ?? ?? ?? ?? 0F 85 B6 01 00 00 C7 44 24 1C 00 00 00 00 C7 44 24 18 00 00 00 00 C7 44 24 14 00 00 00 00 C7 44 24 10 ?? ?? ?? ?? C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 ?? ?? ?? ?? C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 65 8B 0A 65 83 3D 0C 00 00 00 00 74 01 F0 83 2D ?? ?? ?? ?? 01 0F 85 61 01 00 00 65 89 0A 83 C4 2C C3 }
	condition:
		$1
}

rule file_535_6_0 {
	meta:
		name = "setspent"
		size = 142
		refs = "0056 __nss_shadow_lookup2 0062 __nss_setent 0068 __libc_errno"
	strings:
		$1 = { 83 EC 2C 31 C0 B9 01 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 0D ?? ?? ?? ?? 0F 85 B6 01 00 00 C7 44 24 1C 00 00 00 00 C7 44 24 18 00 00 00 00 C7 44 24 14 00 00 00 00 C7 44 24 10 ?? ?? ?? ?? C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 ?? ?? ?? ?? C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 65 8B 0A 65 83 3D 0C 00 00 00 00 74 01 F0 83 2D ?? ?? ?? ?? 01 0F 85 61 01 00 00 65 89 0A 83 C4 2C C3 }
	condition:
		$1
}

rule file_129_7_0 {
	meta:
		name = "endsgent"
		size = 136
		refs = "004f __nss_gshadow_lookup2 005b __nss_endent 0061 __libc_errno"
	strings:
		$1 = { A1 ?? ?? ?? ?? 85 C0 74 7D 83 EC 2C 31 C0 B9 01 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 0D ?? ?? ?? ?? 0F 85 3D 01 00 00 C7 44 24 14 00 00 00 00 C7 44 24 10 ?? ?? ?? ?? C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 ?? ?? ?? ?? C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 65 8B 0A 65 83 3D 0C 00 00 00 00 74 01 F0 83 2D ?? ?? ?? ?? 01 0F 85 F8 00 00 00 65 89 0A 83 C4 2C F3 C3 }
	condition:
		$1
}

rule file_1074_7_0 {
	meta:
		name = "endaliasent"
		size = 136
		refs = "004f __nss_aliases_lookup2 005b __nss_endent 0061 __libc_errno"
	strings:
		$1 = { A1 ?? ?? ?? ?? 85 C0 74 7D 83 EC 2C 31 C0 B9 01 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 0D ?? ?? ?? ?? 0F 85 3D 01 00 00 C7 44 24 14 00 00 00 00 C7 44 24 10 ?? ?? ?? ?? C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 ?? ?? ?? ?? C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 65 8B 0A 65 83 3D 0C 00 00 00 00 74 01 F0 83 2D ?? ?? ?? ?? 01 0F 85 F8 00 00 00 65 89 0A 83 C4 2C F3 C3 }
	condition:
		$1
}

rule file_1122_7_0 {
	meta:
		name = "endgrent"
		size = 136
		refs = "004f __nss_group_lookup2 005b __nss_endent 0061 __libc_errno"
	strings:
		$1 = { A1 ?? ?? ?? ?? 85 C0 74 7D 83 EC 2C 31 C0 B9 01 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 0D ?? ?? ?? ?? 0F 85 3D 01 00 00 C7 44 24 14 00 00 00 00 C7 44 24 10 ?? ?? ?? ?? C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 ?? ?? ?? ?? C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 65 8B 0A 65 83 3D 0C 00 00 00 00 74 01 F0 83 2D ?? ?? ?? ?? 01 0F 85 F8 00 00 00 65 89 0A 83 C4 2C F3 C3 }
	condition:
		$1
}

rule file_1022_7_0 {
	meta:
		name = "endprotoent"
		size = 136
		refs = "004f __nss_protocols_lookup2 005b __nss_endent 0061 __libc_errno"
	strings:
		$1 = { A1 ?? ?? ?? ?? 85 C0 74 7D 83 EC 2C 31 C0 B9 01 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 0D ?? ?? ?? ?? 0F 85 3D 01 00 00 C7 44 24 14 00 00 00 00 C7 44 24 10 ?? ?? ?? ?? C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 ?? ?? ?? ?? C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 65 8B 0A 65 83 3D 0C 00 00 00 00 74 01 F0 83 2D ?? ?? ?? ?? 01 0F 85 F8 00 00 00 65 89 0A 83 C4 2C F3 C3 }
	condition:
		$1
}

rule file_731_7_0 {
	meta:
		name = "endpwent"
		size = 136
		refs = "004f __nss_passwd_lookup2 005b __nss_endent 0061 __libc_errno"
	strings:
		$1 = { A1 ?? ?? ?? ?? 85 C0 74 7D 83 EC 2C 31 C0 B9 01 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 0D ?? ?? ?? ?? 0F 85 3D 01 00 00 C7 44 24 14 00 00 00 00 C7 44 24 10 ?? ?? ?? ?? C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 ?? ?? ?? ?? C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 65 8B 0A 65 83 3D 0C 00 00 00 00 74 01 F0 83 2D ?? ?? ?? ?? 01 0F 85 F8 00 00 00 65 89 0A 83 C4 2C F3 C3 }
	condition:
		$1
}

rule file_368_7_0 {
	meta:
		name = "endrpcent"
		size = 136
		refs = "004f __nss_rpc_lookup2 005b __nss_endent 0061 __libc_errno"
	strings:
		$1 = { A1 ?? ?? ?? ?? 85 C0 74 7D 83 EC 2C 31 C0 B9 01 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 0D ?? ?? ?? ?? 0F 85 3D 01 00 00 C7 44 24 14 00 00 00 00 C7 44 24 10 ?? ?? ?? ?? C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 ?? ?? ?? ?? C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 65 8B 0A 65 83 3D 0C 00 00 00 00 74 01 F0 83 2D ?? ?? ?? ?? 01 0F 85 F8 00 00 00 65 89 0A 83 C4 2C F3 C3 }
	condition:
		$1
}

rule file_1391_7_0 {
	meta:
		name = "endservent"
		size = 136
		refs = "004f __nss_services_lookup2 005b __nss_endent 0061 __libc_errno"
	strings:
		$1 = { A1 ?? ?? ?? ?? 85 C0 74 7D 83 EC 2C 31 C0 B9 01 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 0D ?? ?? ?? ?? 0F 85 3D 01 00 00 C7 44 24 14 00 00 00 00 C7 44 24 10 ?? ?? ?? ?? C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 ?? ?? ?? ?? C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 65 8B 0A 65 83 3D 0C 00 00 00 00 74 01 F0 83 2D ?? ?? ?? ?? 01 0F 85 F8 00 00 00 65 89 0A 83 C4 2C F3 C3 }
	condition:
		$1
}

rule file_535_7_0 {
	meta:
		name = "endspent"
		size = 136
		refs = "004f __nss_shadow_lookup2 005b __nss_endent 0061 __libc_errno"
	strings:
		$1 = { A1 ?? ?? ?? ?? 85 C0 74 7D 83 EC 2C 31 C0 B9 01 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 0D ?? ?? ?? ?? 0F 85 3D 01 00 00 C7 44 24 14 00 00 00 00 C7 44 24 10 ?? ?? ?? ?? C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 ?? ?? ?? ?? C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 65 8B 0A 65 83 3D 0C 00 00 00 00 74 01 F0 83 2D ?? ?? ?? ?? 01 0F 85 F8 00 00 00 65 89 0A 83 C4 2C F3 C3 }
	condition:
		$1
}

rule file_129_8_0 {
	meta:
		name = "__getsgent_r"
		size = 184
		refs = "006b __nss_gshadow_lookup2 008b __nss_getent_r 0091 __libc_errno"
	strings:
		$1 = { 53 31 C0 83 EC 48 B9 01 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 0D ?? ?? ?? ?? 0F 85 D5 00 00 00 8B 44 24 5C C7 44 24 30 00 00 00 00 C7 44 24 1C 00 00 00 00 C7 44 24 18 00 00 00 00 89 44 24 2C 8B 44 24 58 C7 44 24 14 ?? ?? ?? ?? C7 44 24 10 ?? ?? ?? ?? C7 44 24 0C ?? ?? ?? ?? 89 44 24 28 8B 44 24 54 C7 44 24 08 ?? ?? ?? ?? C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? 89 44 24 24 8B 44 24 50 89 44 24 20 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 65 8B 1A 89 C1 65 83 3D 0C 00 00 00 00 74 01 F0 83 2D ?? ?? ?? ?? 01 75 5A 65 89 1A 83 C4 48 89 C8 5B C3 }
	condition:
		$1
}

rule file_1074_8_0 {
	meta:
		name = "__getaliasent_r"
		size = 184
		refs = "006b __nss_aliases_lookup2 008b __nss_getent_r 0091 __libc_errno"
	strings:
		$1 = { 53 31 C0 83 EC 48 B9 01 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 0D ?? ?? ?? ?? 0F 85 D5 00 00 00 8B 44 24 5C C7 44 24 30 00 00 00 00 C7 44 24 1C 00 00 00 00 C7 44 24 18 00 00 00 00 89 44 24 2C 8B 44 24 58 C7 44 24 14 ?? ?? ?? ?? C7 44 24 10 ?? ?? ?? ?? C7 44 24 0C ?? ?? ?? ?? 89 44 24 28 8B 44 24 54 C7 44 24 08 ?? ?? ?? ?? C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? 89 44 24 24 8B 44 24 50 89 44 24 20 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 65 8B 1A 89 C1 65 83 3D 0C 00 00 00 00 74 01 F0 83 2D ?? ?? ?? ?? 01 75 5A 65 89 1A 83 C4 48 89 C8 5B C3 }
	condition:
		$1
}

rule file_1122_8_0 {
	meta:
		name = "__getgrent_r"
		size = 184
		refs = "006b __nss_group_lookup2 008b __nss_getent_r 0091 __libc_errno"
	strings:
		$1 = { 53 31 C0 83 EC 48 B9 01 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 0D ?? ?? ?? ?? 0F 85 D5 00 00 00 8B 44 24 5C C7 44 24 30 00 00 00 00 C7 44 24 1C 00 00 00 00 C7 44 24 18 00 00 00 00 89 44 24 2C 8B 44 24 58 C7 44 24 14 ?? ?? ?? ?? C7 44 24 10 ?? ?? ?? ?? C7 44 24 0C ?? ?? ?? ?? 89 44 24 28 8B 44 24 54 C7 44 24 08 ?? ?? ?? ?? C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? 89 44 24 24 8B 44 24 50 89 44 24 20 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 65 8B 1A 89 C1 65 83 3D 0C 00 00 00 00 74 01 F0 83 2D ?? ?? ?? ?? 01 75 5A 65 89 1A 83 C4 48 89 C8 5B C3 }
	condition:
		$1
}

rule file_1022_8_0 {
	meta:
		name = "__getprotoent_r"
		size = 184
		refs = "006b __nss_protocols_lookup2 008b __nss_getent_r 0091 __libc_errno"
	strings:
		$1 = { 53 31 C0 83 EC 48 B9 01 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 0D ?? ?? ?? ?? 0F 85 D5 00 00 00 8B 44 24 5C C7 44 24 30 00 00 00 00 C7 44 24 1C 00 00 00 00 C7 44 24 18 ?? ?? ?? ?? 89 44 24 2C 8B 44 24 58 C7 44 24 14 ?? ?? ?? ?? C7 44 24 10 ?? ?? ?? ?? C7 44 24 0C ?? ?? ?? ?? 89 44 24 28 8B 44 24 54 C7 44 24 08 ?? ?? ?? ?? C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? 89 44 24 24 8B 44 24 50 89 44 24 20 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 65 8B 1A 89 C1 65 83 3D 0C 00 00 00 00 74 01 F0 83 2D ?? ?? ?? ?? 01 75 5A 65 89 1A 83 C4 48 89 C8 5B C3 }
	condition:
		$1
}

rule file_731_8_0 {
	meta:
		name = "__getpwent_r"
		size = 184
		refs = "006b __nss_passwd_lookup2 008b __nss_getent_r 0091 __libc_errno"
	strings:
		$1 = { 53 31 C0 83 EC 48 B9 01 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 0D ?? ?? ?? ?? 0F 85 D5 00 00 00 8B 44 24 5C C7 44 24 30 00 00 00 00 C7 44 24 1C 00 00 00 00 C7 44 24 18 00 00 00 00 89 44 24 2C 8B 44 24 58 C7 44 24 14 ?? ?? ?? ?? C7 44 24 10 ?? ?? ?? ?? C7 44 24 0C ?? ?? ?? ?? 89 44 24 28 8B 44 24 54 C7 44 24 08 ?? ?? ?? ?? C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? 89 44 24 24 8B 44 24 50 89 44 24 20 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 65 8B 1A 89 C1 65 83 3D 0C 00 00 00 00 74 01 F0 83 2D ?? ?? ?? ?? 01 75 5A 65 89 1A 83 C4 48 89 C8 5B C3 }
	condition:
		$1
}

rule file_368_8_0 {
	meta:
		name = "__getrpcent_r"
		size = 184
		refs = "006b __nss_rpc_lookup2 008b __nss_getent_r 0091 __libc_errno"
	strings:
		$1 = { 53 31 C0 83 EC 48 B9 01 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 0D ?? ?? ?? ?? 0F 85 D5 00 00 00 8B 44 24 5C C7 44 24 30 00 00 00 00 C7 44 24 1C 00 00 00 00 C7 44 24 18 ?? ?? ?? ?? 89 44 24 2C 8B 44 24 58 C7 44 24 14 ?? ?? ?? ?? C7 44 24 10 ?? ?? ?? ?? C7 44 24 0C ?? ?? ?? ?? 89 44 24 28 8B 44 24 54 C7 44 24 08 ?? ?? ?? ?? C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? 89 44 24 24 8B 44 24 50 89 44 24 20 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 65 8B 1A 89 C1 65 83 3D 0C 00 00 00 00 74 01 F0 83 2D ?? ?? ?? ?? 01 75 5A 65 89 1A 83 C4 48 89 C8 5B C3 }
	condition:
		$1
}

rule file_1391_8_0 {
	meta:
		name = "__getservent_r"
		size = 184
		refs = "006b __nss_services_lookup2 008b __nss_getent_r 0091 __libc_errno"
	strings:
		$1 = { 53 31 C0 83 EC 48 B9 01 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 0D ?? ?? ?? ?? 0F 85 D5 00 00 00 8B 44 24 5C C7 44 24 30 00 00 00 00 C7 44 24 1C 00 00 00 00 C7 44 24 18 ?? ?? ?? ?? 89 44 24 2C 8B 44 24 58 C7 44 24 14 ?? ?? ?? ?? C7 44 24 10 ?? ?? ?? ?? C7 44 24 0C ?? ?? ?? ?? 89 44 24 28 8B 44 24 54 C7 44 24 08 ?? ?? ?? ?? C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? 89 44 24 24 8B 44 24 50 89 44 24 20 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 65 8B 1A 89 C1 65 83 3D 0C 00 00 00 00 74 01 F0 83 2D ?? ?? ?? ?? 01 75 5A 65 89 1A 83 C4 48 89 C8 5B C3 }
	condition:
		$1
}

rule file_535_8_0 {
	meta:
		name = "__getspent_r"
		size = 184
		refs = "006b __nss_shadow_lookup2 008b __nss_getent_r 0091 __libc_errno"
	strings:
		$1 = { 53 31 C0 83 EC 48 B9 01 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 0D ?? ?? ?? ?? 0F 85 D5 00 00 00 8B 44 24 5C C7 44 24 30 00 00 00 00 C7 44 24 1C 00 00 00 00 C7 44 24 18 00 00 00 00 89 44 24 2C 8B 44 24 58 C7 44 24 14 ?? ?? ?? ?? C7 44 24 10 ?? ?? ?? ?? C7 44 24 0C ?? ?? ?? ?? 89 44 24 28 8B 44 24 54 C7 44 24 08 ?? ?? ?? ?? C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? 89 44 24 24 8B 44 24 50 89 44 24 20 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 65 8B 1A 89 C1 65 83 3D 0C 00 00 00 00 74 01 F0 83 2D ?? ?? ?? ?? 01 75 5A 65 89 1A 83 C4 48 89 C8 5B C3 }
	condition:
		$1
}

rule file_130_0_0 {
	meta:
		name = "__gethostname"
		size = 163
		refs = "002a uname 003a strlen 005b memcpy 0091 __libc_errno"
	strings:
		$1 = { 81 EC AC 01 00 00 8D 44 24 1A 89 04 24 89 9C 24 A0 01 00 00 8B 9C 24 B4 01 00 00 89 B4 24 A4 01 00 00 89 BC 24 A8 01 00 00 E8 ?? ?? ?? ?? 85 C0 75 56 8D 7C 24 5B 89 3C 24 E8 ?? ?? ?? ?? 89 7C 24 04 8D 70 01 89 D8 39 DE 0F 46 C6 89 44 24 08 8B 84 24 B0 01 00 00 89 04 24 E8 ?? ?? ?? ?? 31 C0 39 DE 77 2B 8B 9C 24 A0 01 00 00 8B B4 24 A4 01 00 00 8B BC 24 A8 01 00 00 81 C4 AC 01 00 00 C3 8D B4 26 00 00 00 00 B8 FF FF FF FF EB D6 90 A1 ?? ?? ?? ?? 65 C7 00 24 00 00 00 B8 FF FF FF FF EB C2 }
	condition:
		$1
}

rule file_131_0_0 {
	meta:
		name = "posix_spawnattr_setsigdefault"
		size = 130
	strings:
		$1 = { 57 B8 80 00 00 00 56 8B 54 24 0C 8B 74 24 10 8D 7A 08 F7 C7 01 00 00 00 75 36 F7 C7 02 00 00 00 75 4E 89 C1 31 D2 C1 E9 02 A8 02 F3 A5 74 0B 0F B7 16 66 89 17 BA 02 00 00 00 A8 01 74 07 0F B6 04 16 88 04 17 31 C0 5E 5F C3 8D B6 00 00 00 00 0F B6 06 8D 7A 09 83 C6 01 F7 C7 02 00 00 00 88 42 08 B8 7F 00 00 00 74 B9 8D B4 26 00 00 00 00 0F B7 16 83 C7 02 83 C6 02 83 E8 02 66 89 57 FE EB A0 }
	condition:
		$1
}

rule file_132_0_0 {
	meta:
		name = "fchflags"
		size = 45
		refs = "0005 __libc_errno"
	strings:
		$1 = { 8B 54 24 04 A1 ?? ?? ?? ?? 85 D2 78 13 65 C7 00 26 00 00 00 B8 FF FF FF FF C3 8D B6 00 00 00 00 65 C7 00 16 00 00 00 B8 FF FF FF FF C3 }
	condition:
		$1
}

rule file_133_0_0 {
	meta:
		name = "__socket"
		size = 34
		refs = "0012 _dl_sysinfo 001d __syscall_error"
	strings:
		$1 = { 89 DA B8 66 00 00 00 BB 01 00 00 00 8D 4C 24 04 FF 15 ?? ?? ?? ?? 89 D3 83 F8 83 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_134_0_0 {
	meta:
		name = "open_translit"
		size = 234
		refs = "0015 __libc_dlopen_mode 0030 __libc_dlsym 0058 __libc_dlclose"
	strings:
		$1 = { 53 89 C3 83 EC 18 C7 44 24 04 01 00 00 80 8B 40 20 89 04 24 E8 ?? ?? ?? ?? 85 C0 89 43 24 0F 84 BC 00 00 00 C7 44 24 04 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 85 C0 74 19 8D 53 0C 89 54 24 08 8D 53 08 89 54 24 04 8B 13 89 14 24 FF D0 85 C0 74 1F 8B 43 24 89 04 24 E8 ?? ?? ?? ?? B8 01 00 00 00 C7 43 24 00 00 00 00 83 C4 18 5B C3 8D 76 00 8B 43 24 C7 44 24 04 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 85 C0 89 43 10 74 C7 8B 43 24 C7 44 24 04 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? C7 44 24 04 ?? ?? ?? ?? 89 43 18 8B 43 24 89 04 24 E8 ?? ?? ?? ?? C7 44 24 04 ?? ?? ?? ?? 89 43 14 8B 43 24 89 04 24 E8 ?? ?? ?? ?? C7 43 28 01 00 00 00 89 43 1C 83 C4 18 31 C0 5B C3 8D B6 00 00 00 00 83 C4 18 B8 01 00 00 00 5B C3 }
	condition:
		$1
}

rule file_134_1_0 {
	meta:
		name = "trans_compare"
		size = 25
		refs = "0015 strcmp"
		altNames = "__gconv_alias_compare known_compare"
	strings:
		$1 = { 8B 44 24 08 8B 00 89 44 24 08 8B 44 24 04 8B 00 89 44 24 04 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_134_4_0 {
	meta:
		name = "__gconv_transliterate"
		size = 1104
		refs = "0043 _nl_current_LC_CTYPE 02dd _dl_mcount_wrapper_check"
	strings:
		$1 = { 55 57 56 53 83 EC 6C 8B 8C 24 90 00 00 00 8B 09 89 4C 24 2C 8B 8C 24 80 00 00 00 8B 49 14 89 4C 24 38 8B 8C 24 80 00 00 00 8B 01 85 C0 74 12 8B 4C 24 38 C1 C9 09 65 33 0D 18 00 00 00 89 4C 24 38 8B 15 ?? ?? ?? ?? 65 8B 12 8B 3A 89 54 24 24 8B 87 18 01 00 00 85 C0 0F 84 FA 00 00 00 8B 8F 1C 01 00 00 8B 97 20 01 00 00 8B AF 28 01 00 00 89 4C 24 40 8B 8F 24 01 00 00 89 54 24 3C 89 4C 24 4C 8B 4C 24 2C 83 C1 04 39 8C 24 94 00 00 00 0F 82 B2 01 00 00 8B 94 24 94 00 00 00 89 44 24 34 C7 44 24 28 00 00 00 00 83 C2 03 29 CA C1 EA 02 83 C2 01 89 54 24 44 8B 54 24 28 31 FF 03 54 24 34 8B 4C 24 40 8B 44 24 2C D1 EA 8B 74 24 44 89 54 24 24 8B 0C 91 8B 54 24 3C 89 4C 24 30 8D 0C 8A 8B 11 EB 1B 66 90 83 C7 01 8B 14 B9 85 D2 0F 84 8E 01 00 00 83 C0 04 39 F7 0F 84 5D 01 00 00 39 10 89 C3 74 E1 85 FF 0F 85 71 01 00 00 39 9C 24 94 00 00 00 0F 86 54 01 00 00 8B 54 24 3C 03 7C 24 30 8B 0B 39 0C BA 0F 82 41 01 00 00 8B 4C 24 24 89 4C 24 34 8B 54 24 34 39 54 24 28 0F 82 73 FF FF FF 8B 0D ?? ?? ?? ?? 65 8B 09 8B 39 89 4C 24 24 8D 74 26 00 8B AF 34 01 00 00 85 ED 75 26 8B 87 2C 01 00 00 BE 06 00 00 00 85 C0 0F 85 82 00 00 00 8D 76 00 83 C4 6C 89 F0 5B 5E 5F 5D C3 8D B6 00 00 00 00 8B 84 24 90 00 00 00 8B 8F 38 01 00 00 8B 00 89 44 24 28 8B 30 8B 44 24 2C 83 C0 04 39 84 24 94 00 00 00 0F 82 97 00 00 00 31 DB 85 ED 7F 2B EB A9 8D B4 26 00 00 00 00 3B 71 04 77 13 89 F2 29 C2 89 D0 31 D2 F7 71 08 85 D2 0F 84 57 02 00 00 83 C3 01 83 C1 0C 39 DD 74 80 8B 01 39 C6 73 D8 8B 87 2C 01 00 00 BE 06 00 00 00 85 C0 74 81 8B 9F 30 01 00 00 8B 4C 24 24 89 5C 24 58 8B 01 8B B8 2C 01 00 00 8B 44 24 2C 83 C0 04 39 84 24 94 00 00 00 0F 83 73 01 00 00 8B 8C 24 94 00 00 00 31 C0 39 4C 24 2C 0F 95 C0 8D 44 40 04 89 C6 83 C4 6C 89 F0 5B 5E 5F 5D C3 8D B4 26 00 00 00 00 8B 8C 24 94 00 00 00 BE 04 00 00 00 39 4C 24 2C 0F 84 1A FF FF FF 83 C4 6C BE 07 00 00 00 5B 89 F0 5E 5F 5D C3 8D 76 00 8B 54 24 24 83 C2 01 89 54 24 28 E9 B7 FE FF FF 85 D2 75 DA 8B 4C 24 24 8B 54 24 4C 89 7C 24 48 8B 7C 24 38 8B 1C 8A 8B 44 9D 00 90 8D 74 26 00 85 C0 8D 4C 9D 00 0F 84 9C 00 00 00 83 C3 01 8D 44 9D 00 EB 05 8D 76 00 89 D3 89 C6 83 C0 04 8B 16 85 D2 8D 53 01 75 F0 89 4C 24 58 8B 8C 24 98 00 00 00 8B 01 89 3C 24 89 44 24 5C E8 ?? ?? ?? ?? 8B 8C 24 84 00 00 00 8D 44 24 5C 8D 54 24 58 C7 44 24 1C 00 00 00 00 C7 44 24 18 00 00 00 00 89 4C 24 04 8B 8C 24 80 00 00 00 C7 44 24 14 00 00 00 00 89 44 24 10 89 74 24 0C 89 54 24 08 89 0C 24 FF D7 83 F8 06 75 26 83 C3 01 8B 44 9D 00 85 C0 0F 85 68 FF FF FF 8B 7C 24 48 8B 4C 24 2C 8D 1C B9 E9 C7 FD FF FF 89 CE E9 79 FF FF FF 83 F8 04 8B 7C 24 48 89 C6 74 1B 83 F8 05 0F 84 15 FE FF FF 8B 44 24 5C 8B 8C 24 98 00 00 00 89 01 E9 03 FE FF FF 8B 8C 24 90 00 00 00 8D 04 BD 00 00 00 00 66 31 F6 01 01 8B 84 24 9C 00 00 00 83 00 01 EB CF 8B 8C 24 98 00 00 00 8B 01 8B 4C 24 38 89 44 24 5C 89 0C 24 E8 ?? ?? ?? ?? 8B 8C 24 84 00 00 00 8D 44 24 5C 89 44 24 10 8D 04 BB 89 44 24 0C 8D 44 24 58 C7 44 24 1C 00 00 00 00 89 4C 24 04 8B 8C 24 80 00 00 00 C7 44 24 18 00 00 00 00 C7 44 24 14 00 00 00 00 89 44 24 08 89 0C 24 8B 4C 24 38 FF D1 83 F8 06 0F 84 78 FD FF FF 83 F8 04 75 16 8B 84 24 9C 00 00 00 8B 8C 24 90 00 00 00 83 00 01 31 C0 83 01 04 8B 54 24 5C 89 C6 8B 8C 24 98 00 00 00 89 11 E9 08 FE FF FF 8B 44 24 28 31 F6 8B 8C 24 90 00 00 00 83 C0 04 89 01 8B 84 24 9C 00 00 00 83 00 01 E9 28 FD FF FF }
	condition:
		$1
}

rule file_134_5_0 {
	meta:
		name = "__gconv_translit_find"
		size = 593
		refs = "0046 __tfind 00a6 strlen 00ac __gconv_path_elem 00e8 memcmp 00f8 __gconv_max_path_elem_len 0108 malloc 0134 mempcpy 0172 stpcpy 01c0 __tsearch 0220 __gconv_get_path 024d __assert_fail"
	strings:
		$1 = { 55 57 56 53 83 EC 2C 8B 38 85 FF 0F 84 1C 02 00 00 89 C3 B9 01 00 00 00 31 C0 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 0D ?? ?? ?? ?? 0F 85 1F 02 00 00 C7 44 24 08 ?? ?? ?? ?? C7 44 24 04 ?? ?? ?? ?? 89 1C 24 E8 ?? ?? ?? ?? 85 C0 89 C6 74 50 8B 00 8B 50 24 85 D2 74 3C 31 FF 83 FA FF 74 28 65 83 3D 0C 00 00 00 00 74 01 F0 83 2D ?? ?? ?? ?? 01 0F 85 E9 01 00 00 83 C4 2C 89 F8 5B 5E 5F 5D C3 8D B6 00 00 00 00 E8 13 FA FF FF 85 C0 0F 84 4B 01 00 00 BF 01 00 00 00 EB C4 8D 74 26 00 8B 03 89 04 24 E8 ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? 85 F6 8D 50 01 89 54 24 18 0F 84 5C 01 00 00 83 7C 24 18 04 C7 44 24 1C 01 00 00 00 76 29 C7 44 24 08 03 00 00 00 C7 44 24 04 ?? ?? ?? ?? 8B 13 8D 44 02 FD 89 04 24 E8 ?? ?? ?? ?? 31 D2 85 C0 0F 95 C2 89 54 24 1C A1 ?? ?? ?? ?? 8B 54 24 18 8D 44 50 2F 89 04 24 E8 ?? ?? ?? ?? 85 C0 89 C6 74 83 31 C0 B9 0B 00 00 00 89 F7 F3 AB 8D 46 2C 89 06 8B 54 24 18 89 54 24 08 8B 13 89 04 24 89 54 24 04 E8 ?? ?? ?? ?? 8B 3D ?? ?? ?? ?? 8B 17 89 46 20 85 D2 74 59 89 FD EB 1D 90 8D 74 26 00 89 F0 E8 49 F9 FF FF 85 C0 74 7D 83 C5 08 8B 55 00 85 D2 74 3B 8B 46 20 8B 3B 89 54 24 04 89 04 24 E8 ?? ?? ?? ?? 8B 54 24 18 89 7C 24 04 89 54 24 08 89 04 24 E8 ?? ?? ?? ?? 8B 4C 24 1C 85 C9 74 BE C7 00 2E 73 6F 00 EB B6 8D B6 00 00 00 00 C7 46 20 00 00 00 00 BF 01 00 00 00 C7 44 24 08 ?? ?? ?? ?? C7 44 24 04 ?? ?? ?? ?? 89 34 24 E8 ?? ?? ?? ?? 85 C0 B8 01 00 00 00 0F 44 F8 E9 8D FE FF FF 90 8D 74 26 00 31 FF EB D0 8D 74 26 00 8B 06 8B 10 89 13 8B 50 04 89 53 04 8B 50 08 89 53 08 8B 50 0C 89 53 0C 8B 50 10 89 53 10 8B 50 14 89 53 14 8B 50 18 89 53 18 8B 40 1C 89 43 1C 8B 06 83 40 28 01 E9 45 FE FF FF 89 44 24 14 E8 ?? ?? ?? ?? 8B 44 24 14 E9 92 FE FF FF C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 4C 01 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_135_0_0 {
	meta:
		name = "_itoa_word"
		size = 179
		refs = "0003 _itoa_upper_digits 001b _itoa_lower_digits"
	strings:
		$1 = { 57 56 BE ?? ?? ?? ?? 53 8B 44 24 1C 8B 7C 24 18 8B 4C 24 10 8B 5C 24 14 85 C0 B8 ?? ?? ?? ?? 0F 44 F0 83 FF 0A 74 61 83 FF 10 74 2C 83 FF 08 74 3F 8D B4 26 00 00 00 00 89 C8 31 D2 F7 F7 83 EB 01 0F B6 14 16 85 C0 89 C1 88 13 75 EB 89 D8 5B 5E 5F C3 90 8D 74 26 00 89 C8 83 EB 01 83 E0 0F 0F B6 04 06 C1 E9 04 85 C9 88 03 75 EB EB DE 90 89 C8 83 EB 01 83 E0 07 0F B6 04 06 C1 E9 03 85 C9 88 03 75 EB EB C6 90 BF CD CC CC CC 8D 76 00 89 C8 83 EB 01 F7 E7 C1 EA 03 8D 04 92 01 C0 29 C1 85 D2 0F B6 04 0E 89 D1 88 03 75 E3 89 D8 5B 5E 5F C3 }
	condition:
		$1
}

rule file_135_1_0 {
	meta:
		name = "_itoa"
		size = 540
		refs = "0003 _itoa_upper_digits 001f _itoa_lower_digits 0041 _itoa_base_table"
	strings:
		$1 = { 55 57 BF ?? ?? ?? ?? 56 53 83 EC 1C 8B 54 24 40 8B 74 24 3C 8B 4C 24 30 8B 44 24 34 85 D2 BA ?? ?? ?? ?? 0F 44 FA 83 FE 08 0F 84 E9 00 00 00 83 FE 10 0F 84 A8 00 00 00 8D 54 76 FA 85 C0 8D 2C 95 ?? ?? ?? ?? 0F 84 75 01 00 00 8B 5D 08 39 D8 0F 82 AC 01 00 00 31 D2 F7 F3 89 44 24 04 89 C8 F7 F3 89 D1 89 54 24 14 8B 54 24 04 F7 F3 89 44 24 0C 89 C8 89 54 24 10 BA 03 00 00 00 8B 4C 24 38 8D 54 94 04 8D 5C 24 08 89 54 24 04 89 1C 24 31 DB 85 C0 74 16 66 90 31 D2 83 E9 01 F7 F6 83 C3 01 0F B6 14 17 85 C0 88 11 75 EC 8B 04 24 39 44 24 04 0F 85 17 01 00 00 39 4C 24 38 75 11 8B 5C 24 38 83 E9 01 C6 43 FF 30 8D B6 00 00 00 00 83 C4 1C 89 C8 5B 5E 5F 5D C3 8D B6 00 00 00 00 85 C0 0F 84 B0 00 00 00 8B 74 24 38 89 CB 8B 4C 24 38 83 EE 08 8D 76 00 89 DA 83 E9 01 83 E2 0F 0F B6 14 17 C1 EB 04 39 F1 88 11 75 EB E9 8E 00 00 00 8D B6 00 00 00 00 85 C0 74 54 8B 74 24 38 89 CB 8B 4C 24 38 83 EE 0A 8D B4 26 00 00 00 00 89 DA 83 E9 01 83 E2 07 0F B6 14 17 C1 EB 03 39 F1 88 11 75 EB 89 C2 83 E2 01 C1 E2 02 09 DA D1 E8 0F 84 A4 00 00 00 8B 4C 24 38 0F B6 14 17 8B 5C 24 38 83 E9 0B 88 53 F5 EB 0D 90 8D 74 26 00 89 C8 8B 4C 24 38 66 90 89 C2 83 E9 01 83 E2 07 0F B6 14 17 C1 E8 03 85 C0 88 11 75 EB 83 C4 1C 89 C8 5B 5E 5F 5D C3 90 89 C8 8B 4C 24 38 66 90 89 C2 83 E9 01 83 E2 0F 0F B6 14 17 C1 E8 04 85 C0 88 11 75 EB 83 C4 1C 89 C8 5B 5E 5F 5D C3 90 89 C8 BA 01 00 00 00 89 4C 24 0C E9 AD FE FF FF 0F BE 45 05 39 D8 7E 11 83 E9 01 83 C3 01 C6 01 30 0F BE 45 05 39 D8 7F EF 8B 5C 24 04 8B 03 83 EB 04 89 5C 24 04 E9 95 FE FF FF 89 D0 E9 76 FF FF FF 89 C2 89 C8 F7 F3 89 44 24 0C 89 D0 89 54 24 10 BA 02 00 00 00 E9 61 FE FF FF }
	condition:
		$1
}

rule file_135_2_0 {
	meta:
		name = "_fitoa_word"
		size = 98
		refs = "0029 _itoa_word"
	strings:
		$1 = { 56 53 83 EC 20 8B 44 24 38 8B 74 24 30 89 44 24 0C 8B 44 24 34 89 44 24 08 8D 44 24 20 89 44 24 04 8B 44 24 2C 89 04 24 E8 ?? ?? ?? ?? 8D 54 24 20 39 D0 73 25 89 C2 89 F1 8D B4 26 00 00 00 00 0F B6 1A 83 C2 01 83 C1 01 88 59 FF 8D 5C 24 20 39 DA 75 EC 89 DA 29 C2 01 D6 83 C4 20 89 F0 5B 5E C3 }
	condition:
		$1
}

rule file_135_3_0 {
	meta:
		name = "_fitoa"
		size = 106
		refs = "0031 _itoa"
	strings:
		$1 = { 56 53 83 EC 3C 8B 44 24 58 8B 4C 24 48 8B 5C 24 4C 8B 74 24 50 89 44 24 10 8B 44 24 54 89 0C 24 89 5C 24 04 89 44 24 0C 8D 44 24 38 89 44 24 08 E8 ?? ?? ?? ?? 8D 54 24 38 39 D0 73 25 89 C2 89 F1 8D B4 26 00 00 00 00 0F B6 1A 83 C2 01 83 C1 01 88 59 FF 8D 5C 24 38 39 DA 75 EC 89 DA 29 C2 01 D6 83 C4 3C 89 F0 5B 5E C3 }
	condition:
		$1
}

rule file_136_0_0 {
	meta:
		name = "__setsid"
		size = 23
		refs = "0007 _dl_sysinfo 0012 __syscall_error"
	strings:
		$1 = { B8 42 00 00 00 FF 15 ?? ?? ?? ?? 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_137_0_0 {
	meta:
		name = "strptime"
		size = 46
		refs = "0004 __libc_tsd_LOCALE 0023 __strptime_internal"
	strings:
		$1 = { 83 EC 1C A1 ?? ?? ?? ?? 8B 4C 24 28 8B 54 24 24 65 8B 00 C7 04 24 00 00 00 00 89 44 24 04 8B 44 24 20 E8 ?? ?? ?? ?? 83 EC 08 83 C4 1C C3 }
	condition:
		$1
}

rule file_138_0_0 {
	meta:
		name = "__nscd_getgrouplist"
		size = 841
		refs = "0013 strlen 001b __gr_map_handle 003e __nscd_get_map_ref 0079 __nscd_cache_search 010c _dl_sysinfo 0193 __nscd_open_socket 01f8 memcpy 023c __nscd_unmap 0265 realloc 029b __readall 02d2 __nss_not_use_nscd_group 0304 __assert_fail"
	strings:
		$1 = { 55 57 56 53 83 EC 4C 8B 54 24 60 8B 7C 24 64 89 14 24 E8 ?? ?? ?? ?? C7 44 24 08 ?? ?? ?? ?? C7 44 24 04 ?? ?? ?? ?? C7 04 24 0C 00 00 00 83 C0 01 89 44 24 2C 8D 44 24 30 89 44 24 0C E8 ?? ?? ?? ?? C7 44 24 24 00 00 00 00 89 C5 83 FD FF 0F 84 16 01 00 00 8B 4C 24 2C 8B 54 24 60 C7 44 24 10 0C 00 00 00 89 6C 24 0C 89 4C 24 08 89 54 24 04 C7 04 24 0F 00 00 00 E8 ?? ?? ?? ?? 85 C0 0F 84 E6 00 00 00 8B 50 18 8D 48 24 89 4C 24 28 8B 48 20 89 54 24 34 8B 50 1C 89 4C 24 3C 89 54 24 38 8B 50 04 8D 74 10 18 8B 55 00 8B 44 24 30 8B 5A 08 39 C3 0F 85 02 02 00 00 8B 5C 24 28 8D 0C 8B 39 CE 0F 82 FD 01 00 00 8B 44 24 38 BB FF FF FF FF 83 F8 01 0F 84 DC 00 00 00 83 F8 FF 0F 84 24 02 00 00 8B 4C 24 68 8B 01 85 C0 0F 8E 33 02 00 00 8B 4C 24 6C 31 C0 8B 11 89 3C 82 8D 70 01 83 FB FF 74 0B B8 06 00 00 00 FF 15 ?? ?? ?? ?? 83 FD FF 74 19 8B 55 00 8B 44 24 30 8B 52 08 39 C2 75 15 F0 83 6D 0C 01 0F 84 0A 01 00 00 83 C4 4C 89 F0 5B 5E 5F 5D C3 89 54 24 30 83 E2 01 75 15 83 44 24 24 01 83 7C 24 24 05 74 09 83 FE FF 0F 85 F6 FE FF FF F0 83 6D 0C 01 0F 84 B7 01 00 00 83 FE FF 74 C8 BD FF FF FF FF 8B 54 24 2C 8D 5C 24 34 8B 4C 24 60 89 5C 24 0C C7 44 24 10 0C 00 00 00 C7 44 24 08 0F 00 00 00 89 54 24 04 89 0C 24 E8 ?? ?? ?? ?? 83 F8 FF 89 C3 0F 84 2E 01 00 00 8B 44 24 38 C7 44 24 28 00 00 00 00 83 F8 01 0F 85 24 FF FF FF 8B 74 24 3C 85 F6 0F 88 21 01 00 00 8B 54 24 68 3B 32 0F 8D 81 00 00 00 8B 54 24 28 8B 4C 24 6C 85 D2 8B 01 0F 84 AB 00 00 00 8D 14 B5 00 00 00 00 89 54 24 08 8B 54 24 28 89 04 24 89 54 24 04 E8 ?? ?? ?? ?? 83 FE 00 0F 8C FB FE FF FF 0F 84 E7 FE FF FF 8B 4C 24 6C 8B 11 39 3A 0F 84 E7 FE FF FF 31 C0 EB 0C 8D 76 00 39 3C 82 0F 84 D7 FE FF FF 83 C0 01 39 F0 75 F0 E9 C5 FE FF FF 8D 76 00 89 2C 24 E8 ?? ?? ?? ?? 83 C4 4C 89 F0 5B 5E 5F 5D C3 8D B6 00 00 00 00 8B 54 24 6C 8D 04 B5 04 00 00 00 89 44 24 04 8B 02 89 04 24 E8 ?? ?? ?? ?? 85 C0 74 45 8B 4C 24 6C 8B 74 24 3C 89 01 8B 4C 24 68 8D 56 01 89 11 8B 54 24 28 85 D2 0F 85 55 FF FF FF C1 E6 02 89 74 24 08 89 44 24 04 89 1C 24 E8 ?? ?? ?? ?? 8B 74 24 3C 8D 14 B5 00 00 00 00 39 D0 0F 84 4A FF FF FF BE FF FF FF FF E9 44 FE FF FF BE FE FF FF FF E9 56 FE FF FF BE FF FF FF FF E9 4C FE FF FF C7 05 ?? ?? ?? ?? 01 00 00 00 BE FF FF FF FF E9 2C FE FF FF C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 64 00 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 01 00 00 00 EB 9E 8D 74 26 00 89 2C 24 E8 ?? ?? ?? ?? E9 3C FE FF FF C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 8F 00 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_139_0_0 {
	meta:
		name = "__uselocale"
		size = 336
		refs = "0007 __libc_tsd_LOCALE 001a _nl_global_locale 0025 _nl_current_LC_COLLATE_used 002f _nl_current_LC_COLLATE 003a _nl_current_LC_CTYPE_used 0044 _nl_current_LC_CTYPE 004c _nl_current_LC_MONETARY_used 0056 _nl_current_LC_MONETARY 0061 _nl_current_LC_NUMERIC_used 006b _nl_current_LC_NUMERIC 0076 _nl_current_LC_TIME_used 0080 _nl_current_LC_TIME 008b _nl_current_LC_MESSAGES_used 0095 _nl_current_LC_MESSAGES 00a0 _nl_current_LC_PAPER_used 00aa _nl_current_LC_PAPER 00b5 _nl_current_LC_NAME_used 00bf _nl_current_LC_NAME 00ca _nl_current_LC_ADDRESS_used 00d4 _nl_current_LC_ADDRESS 00df _nl_current_LC_TELEPHONE_used 00e9 _nl_current_LC_TELEPHONE 00f4 _nl_current_LC_MEASUREMENT_used 00fe _nl_current_LC_MEASUREMENT 0109 _nl_current_LC_IDENTIFICATION_used 0113 _nl_current_LC_IDENTIFICATION 0122 __libc_tsd_CTYPE_B 012b __libc_tsd_CTYPE_TOLOWER 013a __libc_tsd_CTYPE_TOUPPER"
	strings:
		$1 = { 53 8B 54 24 08 8B 0D ?? ?? ?? ?? 85 D2 65 8B 01 0F 84 2B 01 00 00 83 FA FF BB ?? ?? ?? ?? 0F 44 D3 65 89 11 B9 ?? ?? ?? ?? 85 C9 74 0C 8B 0D ?? ?? ?? ?? 8D 5A 0C 65 89 19 B9 ?? ?? ?? ?? 85 C9 74 09 8B 0D ?? ?? ?? ?? 65 89 11 B9 ?? ?? ?? ?? 85 C9 74 0C 8B 0D ?? ?? ?? ?? 8D 5A 10 65 89 19 B9 ?? ?? ?? ?? 85 C9 74 0C 8B 0D ?? ?? ?? ?? 8D 5A 04 65 89 19 B9 ?? ?? ?? ?? 85 C9 74 0C 8B 0D ?? ?? ?? ?? 8D 5A 08 65 89 19 B9 ?? ?? ?? ?? 85 C9 74 0C 8B 0D ?? ?? ?? ?? 8D 5A 14 65 89 19 B9 ?? ?? ?? ?? 85 C9 74 0C 8B 0D ?? ?? ?? ?? 8D 5A 1C 65 89 19 B9 ?? ?? ?? ?? 85 C9 74 0C 8B 0D ?? ?? ?? ?? 8D 5A 20 65 89 19 B9 ?? ?? ?? ?? 85 C9 74 0C 8B 0D ?? ?? ?? ?? 8D 5A 24 65 89 19 B9 ?? ?? ?? ?? 85 C9 74 0C 8B 0D ?? ?? ?? ?? 8D 5A 28 65 89 19 B9 ?? ?? ?? ?? 85 C9 74 0C 8B 0D ?? ?? ?? ?? 8D 5A 2C 65 89 19 B9 ?? ?? ?? ?? 85 C9 74 0C 8B 0D ?? ?? ?? ?? 8D 5A 30 65 89 19 8B 5A 34 8B 0D ?? ?? ?? ?? 65 89 19 8B 0D ?? ?? ?? ?? 8B 5A 38 65 89 19 8B 4A 3C 8B 15 ?? ?? ?? ?? 65 89 0A 3D ?? ?? ?? ?? BA FF FF FF FF 0F 44 C2 5B C3 }
	condition:
		$1
}

rule file_140_0_0 {
	meta:
		name = "xdr_int64_t"
		size = 206
	strings:
		$1 = { 83 EC 2C 89 5C 24 24 8B 5C 24 30 89 74 24 28 8B 74 24 34 8B 03 83 F8 01 74 4E 72 1C 83 F8 02 0F 94 C0 0F B6 C0 8B 5C 24 24 8B 74 24 28 83 C4 2C C3 8D B4 26 00 00 00 00 8B 06 8B 56 04 89 44 24 1C 8B 43 04 89 54 24 18 8D 54 24 18 89 54 24 04 89 1C 24 FF 50 24 85 C0 75 56 31 C0 8B 5C 24 24 8B 74 24 28 83 C4 2C C3 8B 43 04 8D 54 24 18 89 54 24 04 89 1C 24 FF 50 20 85 C0 74 DD 8B 43 04 8D 54 24 1C 89 54 24 04 89 1C 24 FF 50 20 85 C0 74 C8 8B 44 24 1C 89 06 8B 44 24 18 89 46 04 B8 01 00 00 00 E9 7C FF FF FF 8D B4 26 00 00 00 00 8B 43 04 8D 54 24 1C 89 54 24 04 89 1C 24 FF 50 24 85 C0 0F 95 C0 0F B6 C0 E9 57 FF FF FF }
	condition:
		$1
}

rule file_140_2_0 {
	meta:
		name = "xdr_uint64_t"
		size = 222
	strings:
		$1 = { 83 EC 2C 89 74 24 24 8B 74 24 30 89 5C 24 20 8B 5C 24 34 89 7C 24 28 8B 06 83 F8 01 74 5A 72 20 83 F8 02 0F 94 C0 0F B6 C0 8B 5C 24 20 8B 74 24 24 8B 7C 24 28 83 C4 2C C3 8D B4 26 00 00 00 00 8B 03 8B 53 04 89 44 24 1C 8B 46 04 89 54 24 18 8D 54 24 18 89 54 24 04 89 34 24 FF 50 24 85 C0 75 5E 31 C0 8B 5C 24 20 8B 74 24 24 8B 7C 24 28 83 C4 2C C3 8D 74 26 00 8B 46 04 8D 54 24 18 89 54 24 04 89 34 24 FF 50 20 85 C0 74 D5 8B 46 04 8D 54 24 1C 89 54 24 04 89 34 24 FF 50 20 85 C0 74 C0 8B 44 24 18 8B 74 24 1C 89 43 04 B8 01 00 00 00 89 33 E9 70 FF FF FF 8D B4 26 00 00 00 00 8B 46 04 8D 54 24 1C 89 54 24 04 89 34 24 FF 50 24 85 C0 0F 95 C0 0F B6 C0 E9 4B FF FF FF }
	condition:
		$1
}

rule file_140_4_0 {
	meta:
		name = "xdr_int32_t"
		size = 72
		altNames = "xdr_uint32_t"
	strings:
		$1 = { 8B 44 24 04 8B 4C 24 08 8B 10 83 FA 01 74 29 73 17 8B 50 04 89 4C 24 08 89 44 24 04 8B 42 24 FF E0 8D B4 26 00 00 00 00 31 C0 83 FA 02 0F 94 C0 C3 8D B4 26 00 00 00 00 8B 50 04 89 4C 24 08 89 44 24 04 8B 42 20 FF E0 }
	condition:
		$1
}

rule file_140_6_0 {
	meta:
		name = "xdr_int16_t"
		size = 109
	strings:
		$1 = { 83 EC 2C 8B 44 24 30 8B 10 83 FA 01 74 32 72 10 31 C0 83 FA 02 0F 94 C0 83 C4 2C C3 8D 74 26 00 8B 4C 24 34 0F BF 11 8D 4C 24 1C 89 54 24 1C 8B 50 04 89 4C 24 04 89 04 24 FF 52 24 83 C4 2C C3 8B 50 04 8D 4C 24 1C 89 4C 24 04 89 04 24 FF 52 20 89 C2 31 C0 85 D2 74 BF 8B 44 24 1C 8B 54 24 34 66 89 02 B8 01 00 00 00 83 C4 2C C3 }
	condition:
		$1
}

rule file_140_7_0 {
	meta:
		name = "xdr_uint16_t"
		size = 109
	strings:
		$1 = { 83 EC 2C 8B 44 24 30 8B 10 83 FA 01 74 32 72 10 31 C0 83 FA 02 0F 94 C0 83 C4 2C C3 8D 74 26 00 8B 4C 24 34 0F B7 11 8D 4C 24 1C 89 54 24 1C 8B 50 04 89 4C 24 04 89 04 24 FF 52 24 83 C4 2C C3 8B 50 04 8D 4C 24 1C 89 4C 24 04 89 04 24 FF 52 20 89 C2 31 C0 85 D2 74 BF 8B 44 24 1C 8B 54 24 34 66 89 02 B8 01 00 00 00 83 C4 2C C3 }
	condition:
		$1
}

rule file_140_8_0 {
	meta:
		name = "xdr_int8_t"
		size = 108
	strings:
		$1 = { 83 EC 2C 8B 44 24 30 8B 10 83 FA 01 74 32 72 10 31 C0 83 FA 02 0F 94 C0 83 C4 2C C3 8D 74 26 00 8B 4C 24 34 0F BE 11 8D 4C 24 1C 89 54 24 1C 8B 50 04 89 4C 24 04 89 04 24 FF 52 24 83 C4 2C C3 8B 50 04 8D 4C 24 1C 89 4C 24 04 89 04 24 FF 52 20 89 C2 31 C0 85 D2 74 BF 8B 44 24 1C 8B 54 24 34 88 02 B8 01 00 00 00 83 C4 2C C3 }
	condition:
		$1
}

rule file_140_9_0 {
	meta:
		name = "xdr_uint8_t"
		size = 108
	strings:
		$1 = { 83 EC 2C 8B 44 24 30 8B 10 83 FA 01 74 32 72 10 31 C0 83 FA 02 0F 94 C0 83 C4 2C C3 8D 74 26 00 8B 4C 24 34 0F B6 11 8D 4C 24 1C 89 54 24 1C 8B 50 04 89 4C 24 04 89 04 24 FF 52 24 83 C4 2C C3 8B 50 04 8D 4C 24 1C 89 4C 24 04 89 04 24 FF 52 20 89 C2 31 C0 85 D2 74 BF 8B 44 24 1C 8B 54 24 34 88 02 B8 01 00 00 00 83 C4 2C C3 }
	condition:
		$1
}

rule file_141_0_0 {
	meta:
		name = "__remap_file_pages"
		size = 49
		refs = "001e _dl_sysinfo 002c __syscall_error"
	strings:
		$1 = { 57 56 53 8B 7C 24 20 8B 74 24 1C 8B 54 24 18 8B 4C 24 14 8B 5C 24 10 B8 01 01 00 00 FF 15 ?? ?? ?? ?? 5B 5E 5F 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_142_3_0 {
	meta:
		name = "___vfprintf_chk"
		size = 247
		refs = "006e vfprintf 00f3 _Unwind_Resume"
	strings:
		$1 = { 83 EC 1C 89 5C 24 10 8B 5C 24 20 89 74 24 14 8B 74 24 24 89 7C 24 18 8B 03 25 00 80 00 00 75 32 8B 53 48 65 8B 3D 08 00 00 00 3B 7A 08 74 1F B9 01 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 0A 0F 85 AF 00 00 00 8B 53 48 89 7A 08 83 42 04 01 85 F6 7E 04 83 4B 3C 04 8B 44 24 2C 89 1C 24 89 44 24 08 8B 44 24 28 89 44 24 04 E8 ?? ?? ?? ?? 85 F6 89 C1 8B 53 3C 7E 06 83 E2 FB 89 53 3C 83 E2 EB F7 03 00 80 00 00 89 53 3C 75 20 8B 53 48 83 6A 04 01 75 17 C7 42 08 00 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 83 2A 01 75 54 89 C8 8B 5C 24 10 8B 74 24 14 8B 7C 24 18 83 C4 1C C3 83 63 3C EB 89 C6 F7 03 00 80 00 00 75 20 8B 53 48 83 6A 04 01 75 17 C7 42 08 00 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 83 2A 01 75 1D 89 34 24 E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1262_3_0 {
	meta:
		name = "__vfwprintf_chk"
		size = 247
		refs = "006e _IO_vfwprintf 00f3 _Unwind_Resume"
	strings:
		$1 = { 83 EC 1C 89 5C 24 10 8B 5C 24 20 89 74 24 14 8B 74 24 24 89 7C 24 18 8B 03 25 00 80 00 00 75 32 8B 53 48 65 8B 3D 08 00 00 00 3B 7A 08 74 1F B9 01 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 0A 0F 85 AF 00 00 00 8B 53 48 89 7A 08 83 42 04 01 85 F6 7E 04 83 4B 3C 04 8B 44 24 2C 89 1C 24 89 44 24 08 8B 44 24 28 89 44 24 04 E8 ?? ?? ?? ?? 85 F6 89 C1 8B 53 3C 7E 06 83 E2 FB 89 53 3C 83 E2 EB F7 03 00 80 00 00 89 53 3C 75 20 8B 53 48 83 6A 04 01 75 17 C7 42 08 00 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 83 2A 01 75 54 89 C8 8B 5C 24 10 8B 74 24 14 8B 7C 24 18 83 C4 1C C3 83 63 3C EB 89 C6 F7 03 00 80 00 00 75 20 8B 53 48 83 6A 04 01 75 17 C7 42 08 00 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 83 2A 01 75 1D 89 34 24 E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_143_0_0 {
	meta:
		name = "sigemptyset"
		size = 131
		refs = "0071 __libc_errno"
	strings:
		$1 = { 57 8B 7C 24 08 85 FF 74 67 F7 C7 01 00 00 00 BA 80 00 00 00 75 4A F7 C7 02 00 00 00 75 32 89 D1 31 C0 C1 E9 02 F6 C2 02 F3 AB 75 14 83 E2 01 75 07 31 C0 5F C3 8D 76 00 C6 07 00 31 C0 EB F4 90 66 C7 07 00 00 83 C7 02 83 E2 01 74 E4 EB E9 90 66 C7 07 00 00 83 EA 02 83 C7 02 EB C1 8D 76 00 C6 07 00 B2 7F 83 C7 01 EB AC 8D B6 00 00 00 00 A1 ?? ?? ?? ?? 65 C7 00 16 00 00 00 B8 FF FF FF FF 5F C3 }
	condition:
		$1
}

rule file_144_0_0 {
	meta:
		name = "w_addword"
		size = 194
		refs = "0030 realloc 0080 calloc 00b7 free"
	strings:
		$1 = { 83 EC 2C 85 D2 89 5C 24 20 89 C3 89 74 24 24 89 7C 24 28 74 5B 8B 00 03 43 08 89 54 24 1C 8D 04 85 08 00 00 00 89 44 24 04 8B 43 04 89 04 24 E8 ?? ?? ?? ?? 8B 54 24 1C 85 C0 89 C6 74 7D 8B 03 8B 4B 08 89 73 04 8D 3C 08 83 C0 01 89 14 BE 8B 53 04 01 C1 89 03 31 C0 C7 04 8A 00 00 00 00 8B 5C 24 20 8B 74 24 24 8B 7C 24 28 83 C4 2C C3 90 C7 44 24 04 01 00 00 00 C7 04 24 01 00 00 00 E8 ?? ?? ?? ?? 85 C0 89 C7 74 31 8B 03 03 43 08 89 7C 24 1C 8D 04 85 08 00 00 00 89 44 24 04 8B 43 04 89 04 24 E8 ?? ?? ?? ?? 8B 54 24 1C 85 C0 89 C6 75 8B 89 3C 24 E8 ?? ?? ?? ?? B8 01 00 00 00 EB 9D }
	condition:
		$1
}

rule file_144_1_0 {
	meta:
		name = "w_addchar"
		size = 168
		refs = "0064 realloc 007e free 00a4 __assert_fail"
	strings:
		$1 = { 83 EC 2C 89 74 24 24 8B 32 3B 31 89 5C 24 20 89 C3 89 7C 24 28 0F B6 7C 24 30 74 2C 85 C0 74 11 89 F8 88 04 33 8B 02 8D 48 01 89 0A C6 44 03 01 00 89 D8 8B 74 24 24 8B 5C 24 20 8B 7C 24 28 83 C4 2C C3 90 8D 74 26 00 85 C0 74 04 85 F6 74 34 8D 46 64 83 C6 65 89 01 89 74 24 04 89 1C 24 89 54 24 1C E8 ?? ?? ?? ?? 8B 54 24 1C 85 C0 74 08 8B 32 89 C3 EB AA 66 90 89 1C 24 31 DB E8 ?? ?? ?? ?? EB AD C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 65 00 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_144_2_0 {
	meta:
		name = "parse_backslash"
		size = 119
	strings:
		$1 = { 83 EC 2C 89 74 24 20 8B 74 24 34 89 5C 24 1C 89 6C 24 28 8B 6C 24 30 89 7C 24 24 89 C7 8B 1E 8D 43 01 0F BE 5C 1D 01 84 DB 75 1D B8 05 00 00 00 8B 5C 24 1C 8B 74 24 20 8B 7C 24 24 8B 6C 24 28 83 C4 2C C2 08 00 66 90 80 FB 0A 74 1B 8B 07 89 1C 24 E8 F9 FE FF FF 85 C0 89 07 74 13 83 06 01 31 C0 EB CC 8D 74 26 00 89 06 31 C0 EB C2 66 90 B8 01 00 00 00 EB B9 }
	condition:
		$1
}

rule file_144_3_0 {
	meta:
		name = "parse_qtd_backslash"
		size = 223
	strings:
		$1 = { 83 EC 3C 89 5C 24 2C 8B 5C 24 44 89 6C 24 38 89 CD 89 74 24 30 89 C6 89 7C 24 34 89 D7 8B 0B 8D 41 01 89 44 24 1C 8B 44 24 40 0F BE 54 08 01 80 FA 24 74 7C 7E 52 80 FA 5C 74 75 80 FA 60 66 90 74 6E 8B 54 24 40 0F BE 04 0A 89 E9 89 FA 89 04 24 8B 06 E8 78 FE FF FF 85 C0 89 06 74 22 8B 13 8B 4C 24 40 0F BE 54 11 01 89 E9 89 14 24 89 FA E8 5B FE FF FF 85 C0 89 06 75 49 90 8D 74 26 00 B8 01 00 00 00 EB 42 90 80 FA 22 74 23 8D 76 00 7F B0 84 D2 B8 05 00 00 00 74 2E 80 FA 0A 75 A2 8B 54 24 1C 31 C0 89 13 EB 1F 8D B6 00 00 00 00 8B 06 89 E9 89 14 24 89 FA E8 12 FE FF FF 85 C0 89 06 74 BC 83 03 01 31 C0 8B 5C 24 2C 8B 74 24 30 8B 7C 24 34 8B 6C 24 38 83 C4 3C C2 08 00 }
	condition:
		$1
}

rule file_144_4_0 {
	meta:
		name = "w_addmem"
		size = 200
		refs = "004b realloc 0069 mempcpy 009e free 00c4 __assert_fail"
	strings:
		$1 = { 83 EC 2C 89 74 24 20 8B 74 24 34 89 7C 24 24 89 D7 8B 12 89 5C 24 1C 89 C3 8B 01 89 6C 24 28 8D 2C 16 39 C5 76 6A 85 DB 74 04 85 C0 74 76 8D 14 36 BD 64 00 00 00 83 FA 64 0F 42 D5 01 D0 89 01 83 C0 01 89 44 24 04 89 1C 24 E8 ?? ?? ?? ?? 85 C0 74 45 8B 17 89 C3 8B 44 24 30 01 DA 89 74 24 08 89 14 24 89 44 24 04 E8 ?? ?? ?? ?? C6 00 00 01 37 89 D8 8B 74 24 20 8B 5C 24 1C 8B 7C 24 24 8B 6C 24 28 83 C4 2C C2 08 00 8D B6 00 00 00 00 85 DB 75 C3 EB DC 66 90 89 1C 24 31 DB E8 ?? ?? ?? ?? EB CE C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 80 00 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_144_5_0 {
	meta:
		name = "exec_comm"
		size = 1890
		refs = "0031 __have_sock_cloexec 004b __pipe2 00a0 __pipe 00b5 __fork 00e0 __close 0116 __read 0147 strchr 0219 __libc_errno 0240 __waitpid 02d9 free 0420 __kill 059e __dup2 05d2 __open 05f9 __fxstat64 062c _exit 06c1 __unsetenv 06d2 __environ 06ea __execve 06ef abort 0759 __fcntl"
	strings:
		$1 = { 55 57 56 53 81 EC 3C 01 00 00 85 C0 89 44 24 28 89 4C 24 24 C7 44 24 34 00 00 00 00 0F 84 FE 02 00 00 8B 44 24 28 80 38 00 0F 84 F1 02 00 00 8B 3D ?? ?? ?? ?? 89 D6 85 FF 78 5D 8D 5C 24 38 C7 44 24 04 00 00 08 00 89 1C 24 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 85 D2 75 14 83 F8 FF 0F 84 C6 04 00 00 BA 01 00 00 00 89 15 ?? ?? ?? ?? 83 FA 00 0F 8E EB 03 00 00 85 C0 79 2E 8D B6 00 00 00 00 B8 01 00 00 00 81 C4 3C 01 00 00 5B 5E 5F 5D C2 14 00 8D B6 00 00 00 00 8D 5C 24 38 89 1C 24 E8 ?? ?? ?? ?? 85 C0 78 D8 31 DB 89 F7 C7 44 24 1C 00 00 00 00 E8 ?? ?? ?? ?? 83 F8 00 89 44 24 2C 0F 8C 6A 05 00 00 0F 84 87 04 00 00 85 DB 66 90 0F 85 7C 05 00 00 8B 44 24 3C 31 F6 89 04 24 E8 ?? ?? ?? ?? 8B 9C 24 58 01 00 00 C7 44 24 3C FF FF FF FF 85 DB 0F 84 AF 02 00 00 8D 84 24 B0 00 00 00 89 44 24 04 8B 44 24 38 C7 44 24 08 80 00 00 00 89 04 24 E8 ?? ?? ?? ?? 83 F8 FF 0F 84 F5 00 00 00 85 C0 89 44 24 20 0F 8E F8 00 00 00 31 DB EB 73 90 8D 74 26 00 8B 94 24 60 01 00 00 89 6C 24 04 89 14 24 E8 ?? ?? ?? ?? 85 C0 0F 85 DD 01 00 00 83 FE 02 BE 00 00 00 00 74 3C 8B 17 8B 84 24 58 01 00 00 E8 E5 FA FF FF 83 F8 01 0F 84 9C 02 00 00 8B 94 24 50 01 00 00 8B 44 24 24 C7 44 24 1C 00 00 00 00 C7 02 00 00 00 00 C7 00 00 00 00 00 C7 07 00 00 00 00 83 C3 01 39 5C 24 20 0F 8E 55 FF FF FF 0F B6 94 1C B0 00 00 00 8B 84 24 5C 01 00 00 0F BE EA 89 6C 24 04 89 04 24 88 54 24 1B E8 ?? ?? ?? ?? 85 C0 0F 85 68 FF FF FF 83 FE 03 0F 84 87 01 00 00 8B 07 8B 4C 24 1C 31 D2 89 2C 24 83 C1 01 80 7C 24 1B 0A 0F 44 D1 8B 8C 24 50 01 00 00 89 54 24 1C 8B 54 24 24 E8 1D FB FF FF 85 C0 89 07 0F 84 03 02 00 00 BE 01 00 00 00 EB 85 8D 74 26 00 A1 ?? ?? ?? ?? 65 83 38 04 0F 84 D4 FE FF FF 8B 6C 24 2C 8D 5C 24 34 90 C7 44 24 08 01 00 00 00 89 5C 24 04 89 2C 24 E8 ?? ?? ?? ?? 83 F8 FF 0F 85 C3 02 00 00 A1 ?? ?? ?? ?? 65 83 38 04 74 D8 8B 44 24 38 8D 94 24 B0 00 00 00 C7 44 24 08 80 00 00 00 89 54 24 04 89 04 24 E8 ?? ?? ?? ?? 83 F8 FF 0F 85 C2 02 00 00 A1 ?? ?? ?? ?? 65 83 38 04 74 CD 83 6C 24 1C 01 8B 5C 24 1C 8B 54 24 24 EB 02 89 C3 83 FB FF 0F 84 0B 04 00 00 8B 02 85 C0 0F 84 01 04 00 00 8B 0F 80 7C 01 FF 0A 0F 85 F4 03 00 00 8D 70 FF 89 32 C6 44 01 FF 00 8B 0A 8D 43 FF 85 C9 75 CB 8B 07 89 5C 24 1C 89 04 24 E8 ?? ?? ?? ?? 8B 84 24 50 01 00 00 8B 54 24 24 C7 00 00 00 00 00 C7 02 00 00 00 00 C7 07 00 00 00 00 8B 44 24 38 BB 01 00 00 00 89 04 24 E8 ?? ?? ?? ?? 8B 44 24 34 C7 44 24 38 FF FF FF FF 85 C0 0F 85 95 FD FF FF 90 31 C0 81 C4 3C 01 00 00 5B 5E 5F 5D C2 14 00 90 80 7C 24 1B 0A 74 19 89 F0 83 E0 FD 83 F8 01 0F 85 54 FE FF FF BE 02 00 00 00 E9 0E FE FF FF 90 83 FE 01 B8 03 00 00 00 0F 44 F0 E9 39 FE FF FF 8B 17 8B 84 24 58 01 00 00 E8 E2 F8 FF FF 83 F8 01 0F 84 99 00 00 00 8B 94 24 50 01 00 00 8B 44 24 24 C7 02 00 00 00 00 0F B6 94 1C B0 00 00 00 C7 00 00 00 00 00 31 C0 C7 07 00 00 00 00 88 54 24 1B 0F BE EA E9 31 FE FF FF 8B 74 24 2C 66 90 8B 44 24 38 8D 94 24 B0 00 00 00 C7 44 24 08 80 00 00 00 89 54 24 04 89 04 24 E8 ?? ?? ?? ?? 83 F8 FF 0F 84 A0 00 00 00 85 C0 0F 8E A7 00 00 00 8D 94 24 B0 00 00 00 8B 8C 24 50 01 00 00 01 44 24 1C 89 14 24 8B 54 24 24 89 44 24 04 8B 07 E8 2C FB FF FF 83 EC 08 85 C0 89 07 75 A3 8D 76 00 8B 44 24 2C C7 44 24 04 09 00 00 00 89 04 24 E8 ?? ?? ?? ?? 8B 5C 24 2C C7 44 24 08 00 00 00 00 C7 44 24 04 00 00 00 00 89 1C 24 E8 ?? ?? ?? ?? 83 F8 FF 75 0B A1 ?? ?? ?? ?? 65 83 38 04 74 D8 8B 44 24 38 89 04 24 E8 ?? ?? ?? ?? E9 1F FC FF FF 0F 8D 41 FC FF FF 89 F6 8D BC 27 00 00 00 00 E9 27 FC FF FF 8D 76 00 A1 ?? ?? ?? ?? 65 83 38 04 0F 84 29 FF FF FF 8D 5C 24 34 90 8D 74 26 00 C7 44 24 08 01 00 00 00 89 5C 24 04 89 34 24 E8 ?? ?? ?? ?? 83 F8 FF 75 3F A1 ?? ?? ?? ?? 65 83 38 04 74 DC 8D 84 24 B0 00 00 00 89 44 24 04 8B 44 24 38 C7 44 24 08 80 00 00 00 89 04 24 E8 ?? ?? ?? ?? 83 F8 FF 75 20 A1 ?? ?? ?? ?? 65 83 38 04 74 D1 E9 A3 FD FF FF 85 C0 0F 84 C0 FE FF FF EB C2 8D B6 00 00 00 00 85 C0 8D B6 00 00 00 00 0F 8F DA FE FF FF E9 80 FD FF FF 90 8D 74 26 00 85 C0 0F 84 E3 FB FF FF 90 8D B4 26 00 00 00 00 E9 33 FD FF FF 8D 76 00 8B 15 ?? ?? ?? ?? 65 83 3A 26 0F 85 2A FB FF FF BA FF FF FF FF E9 25 FB FF FF 85 C0 0F 8E 41 FD FF FF 89 44 24 20 E9 DC FB FF FF 85 DB 0F 85 2E 01 00 00 8B 9C 24 54 01 00 00 8B 44 24 28 C7 44 24 40 ?? ?? ?? ?? C7 44 24 44 ?? ?? ?? ?? 83 E3 10 89 44 24 48 C7 44 24 4C 00 00 00 00 8B 44 24 3C 83 F8 01 0F 84 A1 01 00 00 C7 44 24 04 01 00 00 00 89 04 24 E8 ?? ?? ?? ?? 8B 44 24 3C 89 04 24 E8 ?? ?? ?? ?? 85 DB 0F 85 03 01 00 00 C7 04 24 02 00 00 00 E8 ?? ?? ?? ?? C7 44 24 04 01 00 00 00 C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 F8 02 89 C3 0F 85 12 01 00 00 8D 44 24 50 89 44 24 08 C7 44 24 04 02 00 00 00 C7 04 24 03 00 00 00 E8 ?? ?? ?? ?? 85 C0 75 23 8B 44 24 60 25 00 F0 00 00 3D 00 20 00 00 75 13 8B 44 24 70 35 03 01 00 00 0B 44 24 74 0F 84 95 00 00 00 C7 04 24 5A 00 00 00 E8 ?? ?? ?? ?? 8B 44 24 38 89 04 24 E8 ?? ?? ?? ?? 8B 44 24 3C 89 04 24 E8 ?? ?? ?? ?? B8 01 00 00 00 E9 33 FA FF FF 8B 74 24 2C 8D 5C 24 34 C7 44 24 08 00 00 00 00 89 5C 24 04 89 34 24 E8 ?? ?? ?? ?? 83 F8 FF 0F 85 A1 00 00 00 A1 ?? ?? ?? ?? 65 83 38 04 74 D8 31 C0 E9 99 FC FF FF 8B 44 24 28 31 DB C7 44 24 40 ?? ?? ?? ?? C7 44 24 4C 00 00 00 00 C7 44 24 44 ?? ?? ?? ?? 89 44 24 48 E9 D5 FE FF FF 89 5C 24 1C E9 41 FC FF FF C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 44 24 38 89 04 24 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? 89 44 24 08 8D 44 24 40 89 44 24 04 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 0F 88 E6 FE FF FF C7 44 24 04 02 00 00 00 89 04 24 E8 ?? ?? ?? ?? 89 1C 24 E8 ?? ?? ?? ?? E9 C9 FE FF FF 39 44 24 2C 0F 85 FE FB FF FF 83 7C 24 34 01 19 C0 F7 D0 83 E0 05 E9 52 F9 FF FF 8B 35 ?? ?? ?? ?? 85 F6 0F 8E 6D FE FF FF C7 44 24 08 00 00 00 00 C7 44 24 04 02 00 00 00 C7 04 24 01 00 00 00 E8 ?? ?? ?? ?? E9 4C FE FF FF }
	condition:
		$1
}

rule file_144_6_0 {
	meta:
		name = "parse_backtick"
		size = 352
		refs = "0092 free"
	strings:
		$1 = { 55 57 56 53 83 EC 4C 8B 5C 24 64 89 54 24 2C 8B 74 24 60 89 44 24 28 C7 44 24 38 00 00 00 00 8B 13 C7 44 24 34 00 00 00 00 C7 44 24 3C 00 00 00 00 0F BE 04 16 84 C0 0F 84 1C 01 00 00 89 CD 31 FF 3C 5C 0F 84 AF 00 00 00 3C 60 74 53 3C 27 75 09 BA 01 00 00 00 29 FA 89 D7 89 04 24 8B 44 24 3C 8D 4C 24 38 8D 54 24 34 E8 42 F5 FF FF 85 C0 89 44 24 3C 0F 84 D8 00 00 00 8B 03 8D 50 01 89 13 0F BE 44 06 01 84 C0 75 B7 8B 44 24 3C 89 04 24 E8 ?? ?? ?? ?? B8 05 00 00 00 EB 4E 8D 76 00 8B 44 24 74 8B 4C 24 2C 8B 54 24 28 89 2C 24 89 44 24 10 8B 44 24 70 89 44 24 0C 8B 44 24 6C 89 44 24 08 8B 44 24 68 89 44 24 04 8B 44 24 3C E8 BC F7 FF FF 83 EC 14 8B 54 24 3C 89 44 24 24 89 14 24 E8 ?? ?? ?? ?? 8B 44 24 24 83 C4 4C 5B 5E 5F 5D C2 18 00 8D 76 00 85 FF 74 2C 89 5C 24 04 8D 4C 24 38 89 34 24 8D 54 24 34 8D 44 24 3C E8 CC F5 FF FF 83 EC 08 85 C0 75 BC BF 01 00 00 00 E9 55 FF FF FF 8D 76 00 83 C2 01 89 13 8D 4C 24 38 89 5C 24 04 8D 54 24 34 89 34 24 8D 44 24 3C E8 1B F5 FF FF 83 EC 08 85 C0 0F 84 2A FF FF FF EB 85 B8 01 00 00 00 EB 92 31 C0 E9 2E FF FF FF }
	condition:
		$1
}

rule file_144_7_0 {
	meta:
		name = "eval_expr_multdiv"
		size = 243
		refs = "0066 __libc_tsd_CTYPE_B"
	strings:
		$1 = { 55 57 89 D7 56 89 C6 53 83 EC 2C E8 C0 01 00 00 85 C0 74 47 83 C4 2C B8 05 00 00 00 5B 5E 5F 5D C3 8B 7C 24 0C 0F B6 1D 00 00 00 00 80 FB 2A 0F 84 98 00 00 00 80 FB 2F 75 76 83 C1 01 89 F0 89 0E 8D 54 24 1C E8 86 01 00 00 85 C0 75 C6 8B 07 89 C2 C1 FA 1F F7 7C 24 1C 89 07 8B 0E 0F B6 19 84 DB 74 4C 8B 2D ?? ?? ?? ?? 0F BE D3 65 8B 45 00 F6 44 50 01 20 74 B4 8D 51 01 89 7C 24 0C EB 1F 8D B4 26 00 00 00 00 0F B6 1A 84 DB 74 21 65 8B 7D 00 0F BE C3 83 C2 01 F6 44 47 01 20 74 20 85 D2 89 D1 89 16 75 E0 E9 74 FF FF FF 8D 76 00 83 C4 2C 31 C0 5B 5E 5F 5D C3 8D B6 00 00 00 00 80 FB 2A 8B 7C 24 0C 0F 85 68 FF FF FF 83 C1 01 89 F0 89 0E 8D 54 24 1C E8 F3 00 00 00 85 C0 0F 85 2F FF FF FF 8B 07 0F AF 44 24 1C 89 07 E9 68 FF FF FF }
	condition:
		$1
}

rule file_144_8_0 {
	meta:
		name = "eval_expr_val"
		size = 229
		refs = "001e __libc_tsd_CTYPE_B 00a8 strtol"
	strings:
		$1 = { 55 89 D5 57 89 C7 56 53 83 EC 1C 8B 00 85 C0 0F 84 C2 00 00 00 0F B6 08 84 C9 74 78 8B 15 ?? ?? ?? ?? 0F BE D9 65 8B 12 F6 44 5A 01 20 89 C3 75 18 EB 22 90 8D 74 26 00 0F B6 0B 84 C9 74 59 0F BE F1 F6 44 72 01 20 74 0C 83 C3 01 75 EA 0F B6 0D 00 00 00 00 80 F9 28 75 3E 0F B6 10 84 D2 74 22 80 FA 29 74 1D 8D 48 01 EB 09 90 8D 74 26 00 84 D2 74 0F 89 0F 0F B6 11 89 C8 83 C1 01 80 FA 29 75 ED 84 D2 75 36 83 C4 1C B8 05 00 00 00 5B 5E 5F 5D C3 89 C3 66 90 C7 44 24 08 00 00 00 00 89 7C 24 04 89 1C 24 E8 ?? ?? ?? ?? 39 1F 89 45 00 74 D4 31 C0 83 C4 1C 5B 5E 5F 5D C3 C6 00 00 83 C0 01 89 EA 89 07 8D 43 01 E8 61 FE FF FF 85 C0 75 B4 31 C0 EB DE 0F B6 0D 00 00 00 00 31 DB E9 70 FF FF FF }
	condition:
		$1
}

rule file_144_9_0 {
	meta:
		name = "eval_expr"
		size = 204
		refs = "0060 __libc_tsd_CTYPE_B"
	strings:
		$1 = { 57 56 89 D6 53 83 EC 20 89 44 24 0C 8D 44 24 0C E8 EB FE FF FF 85 C0 74 3B 83 C4 20 B8 05 00 00 00 5B 5E 5F C3 0F B6 1D 00 00 00 00 80 FB 2B 74 77 80 FB 2D 75 62 83 C1 01 8D 54 24 1C 8D 44 24 0C 89 4C 24 0C E8 B6 FE FF FF 85 C0 75 CB 8B 44 24 1C 29 06 8B 4C 24 0C 0F B6 19 84 DB 74 39 A1 ?? ?? ?? ?? 65 8B 38 0F BE C3 F6 44 47 01 20 74 BB 8D 41 01 EB 16 66 90 0F B6 18 84 DB 74 19 0F BE D3 83 C0 01 F6 44 57 01 20 74 A0 85 C0 89 C1 89 44 24 0C 75 E2 EB 8D 83 C4 20 31 C0 5B 5E 5F C3 8D B4 26 00 00 00 00 83 C1 01 8D 54 24 1C 8D 44 24 0C 89 4C 24 0C E8 44 FE FF FF 85 C0 0F 85 55 FF FF FF 8B 44 24 1C 01 06 EB 88 }
	condition:
		$1
}

rule file_144_10_0 {
	meta:
		name = "w_addstr"
		size = 120
		refs = "0025 strlen 0074 __assert_fail"
	strings:
		$1 = { 83 EC 2C 89 5C 24 1C 8B 5C 24 30 89 74 24 20 89 7C 24 24 89 6C 24 28 85 DB 74 39 89 1C 24 89 C6 89 D7 89 CD E8 ?? ?? ?? ?? 89 E9 89 FA 89 1C 24 89 44 24 04 89 F0 E8 65 F3 FF FF 83 EC 08 8B 5C 24 1C 8B 74 24 20 8B 7C 24 24 8B 6C 24 28 83 C4 2C C2 04 00 C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 9A 00 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_144_11_0 {
	meta:
		name = "parse_tilde"
		size = 893
		refs = "003d strchr 00a9 __strnlen 00cc memcpy 00f9 __libc_errno 0151 __getpwnam_r 01df getenv 02bc __getuid 033d __getpwuid_r"
	strings:
		$1 = { 55 89 E5 57 56 53 83 EC 6C 8B 75 08 89 45 BC 8B 02 89 55 B8 89 4D B4 85 C0 74 39 8B 55 BC 8B 1A 0F B6 44 03 FF 3C 3D 74 20 3C 3A 0F 85 DF 01 00 00 C7 44 24 04 3D 00 00 00 89 1C 24 E8 ?? ?? ?? ?? 85 C0 0F 84 C7 01 00 00 8B 45 10 85 C0 0F 85 BC 01 00 00 8B 5D 0C 8B 0B 8D 51 01 8D 3C 16 0F B6 07 84 C0 0F 84 6D 01 00 00 3C 3A 0F 84 65 01 00 00 3C 2F 0F 84 5D 01 00 00 89 D3 8D 74 26 00 3C 09 74 0C 3C 20 74 08 84 C0 0F 85 18 01 00 00 39 D3 0F 84 3F 01 00 00 F7 D1 BE E8 03 00 00 01 D9 89 4C 24 04 89 3C 24 E8 ?? ?? ?? ?? 8D 50 1F 83 E2 F0 29 D4 8D 54 24 23 83 E2 F0 C6 04 02 00 89 44 24 08 89 7C 24 04 89 14 24 E8 ?? ?? ?? ?? 81 EC 00 04 00 00 8D 7C 24 23 8D 4D CC 83 E7 F0 89 5D B0 89 4D A8 89 45 C4 8D 45 C8 89 45 C0 EB 43 8D B4 26 00 00 00 00 A1 ?? ?? ?? ?? 65 83 38 22 0F 85 39 01 00 00 8D 8E F7 03 00 00 31 D2 83 E1 F0 BB 10 00 00 00 8D 41 1E 01 CE F7 F3 C1 E0 04 29 C4 8D 44 24 23 83 E0 F0 8D 14 08 39 D7 89 C7 0F 45 F1 8B 5D C0 8B 45 C4 89 74 24 0C 89 7C 24 08 89 5C 24 10 8B 5D A8 89 04 24 89 5C 24 04 E8 ?? ?? ?? ?? 85 C0 75 9F 8B 45 C8 8B 5D B0 85 C0 0F 84 DC 00 00 00 8B 45 E0 85 C0 0F 84 D1 00 00 00 8B 75 BC 89 04 24 8B 4D B4 8B 55 B8 8B 06 E8 FB FD FF FF 83 EC 04 89 06 8B 75 0C 83 EB 01 89 1E 85 C0 0F 94 C0 8D 65 F4 0F B6 C0 5B 5E 5F 5D C2 0C 00 8D 74 26 00 3C 5C 0F 84 E0 00 00 00 83 C3 01 0F B6 04 1E 84 C0 0F 84 D1 FE FF FF 3C 2F 0F 84 C9 FE FF FF 3C 3A 0F 85 B1 FE FF FF 39 D3 0F 85 C1 FE FF FF C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 0F 84 D0 00 00 00 8B 5D BC 89 04 24 8B 4D B4 8B 55 B8 8B 03 E8 82 FD FF FF 83 EC 04 85 C0 89 03 75 8B B8 01 00 00 00 EB 23 66 90 8B 4D B4 89 D8 8B 55 B8 C7 04 24 7E 00 00 00 E8 EC EE FF FF 8B 5D BC 85 C0 89 03 0F 94 C0 0F B6 C0 8D 65 F4 5B 5E 5F 5D C2 0C 00 90 8D 74 26 00 8B 5D B0 8B 75 BC C7 04 24 7E 00 00 00 8B 4D B4 8B 55 B8 8B 06 E8 B6 EE FF FF 89 C6 8B 45 BC 89 30 31 C0 85 F6 0F 84 1F FF FF FF 8B 45 C4 8B 55 B8 8B 4D B4 89 04 24 89 F0 E8 02 FD FF FF 8B 55 BC 83 EC 04 89 02 E9 FF FE FF FF 90 8D 74 26 00 8B 75 BC C7 04 24 7E 00 00 00 8B 4D B4 8B 55 B8 8B 06 E8 69 EE FF FF 85 C0 89 06 0F 94 C0 8D 65 F4 0F B6 C0 5B 5E 5F 5D C2 0C 00 E8 ?? ?? ?? ?? 81 EC 00 04 00 00 BE E8 03 00 00 8D 7C 24 23 8D 5D C8 83 E7 F0 8D 4D CC 89 5D C0 89 4D AC 89 45 C4 EB 3D 90 8D 74 26 00 A1 ?? ?? ?? ?? 65 83 38 22 75 64 8D 8E F7 03 00 00 31 D2 83 E1 F0 BB 10 00 00 00 8D 41 1E 01 CE F7 F3 C1 E0 04 29 C4 8D 44 24 23 83 E0 F0 8D 14 08 39 D7 89 C7 0F 45 F1 8B 5D C0 8B 45 C4 89 74 24 0C 89 7C 24 08 89 5C 24 10 8B 5D AC 89 04 24 89 5C 24 04 E8 ?? ?? ?? ?? 85 C0 75 A3 8B 45 C8 85 C0 74 0B 8B 45 E0 85 C0 0F 85 94 FE FF FF 8B 75 BC C7 04 24 7E 00 00 00 8B 4D B4 8B 55 B8 8B 06 E8 A2 ED FF FF 85 C0 89 06 0F 85 1A FE FF FF E9 8A FE FF FF }
	condition:
		$1
}

rule file_144_12_0 {
	meta:
		name = "parse_arith"
		size = 924
		refs = "007a free 023e _itoa_word 0341 _itoa"
	strings:
		$1 = { 55 57 56 53 89 C3 83 EC 6C 8B B4 24 84 00 00 00 89 54 24 28 8B BC 24 80 00 00 00 89 4C 24 2C C7 44 24 3C 00 00 00 00 8B 16 C7 44 24 38 00 00 00 00 C7 44 24 40 00 00 00 00 0F BE 04 17 84 C0 0F 84 9D 02 00 00 BD 01 00 00 00 3C 5C 0F 84 5E 02 00 00 7F 3C 3C 28 0F 84 4C 02 00 00 8D 74 26 00 0F 8E A2 00 00 00 3C 29 0F 84 6A 01 00 00 3C 3B 75 34 8B 44 24 40 89 04 24 E8 ?? ?? ?? ?? B8 02 00 00 00 83 C4 6C 5B 5E 5F 5D C2 10 00 8D 76 00 3C 60 0F 84 F0 00 00 00 7F 56 3C 5D 8D 74 26 00 0F 84 4A 01 00 00 89 04 24 8B 44 24 40 8D 4C 24 3C 8D 54 24 38 E8 D6 EC FF FF 85 C0 89 44 24 40 0F 84 12 02 00 00 8B 06 8D 50 01 89 16 0F BE 44 07 01 84 C0 0F 85 70 FF FF FF 8B 44 24 40 89 04 24 E8 ?? ?? ?? ?? B8 05 00 00 00 EB 96 8D 76 00 3C 7B 0F 84 7A FF FF FF 3C 7D 75 AA 8D 74 26 00 E9 6D FF FF FF 8D 76 00 3C 0A 8D B6 00 00 00 00 0F 84 5C FF FF FF 3C 24 75 8C 8B 84 24 88 00 00 00 8D 4C 24 3C C7 44 24 18 01 00 00 00 8D 54 24 38 C7 44 24 14 00 00 00 00 C7 44 24 10 00 00 00 00 89 44 24 08 8D 44 24 40 C7 44 24 0C 00 00 00 00 89 74 24 04 89 3C 24 E8 43 02 00 00 83 EC 1C 85 C0 0F 84 5E FF FF FF 8B 54 24 40 89 44 24 24 89 14 24 E8 ?? ?? ?? ?? 8B 44 24 24 E9 02 FF FF FF 8D B4 26 00 00 00 00 8B 84 24 88 00 00 00 83 C2 01 89 16 8D 4C 24 3C C7 44 24 14 00 00 00 00 8D 54 24 38 C7 44 24 10 00 00 00 00 89 44 24 08 8D 44 24 40 C7 44 24 0C 00 00 00 00 89 74 24 04 89 3C 24 E8 18 F6 FF FF 83 EC 18 85 C0 0F 84 F3 FE FF FF EB 93 8D 76 00 83 ED 01 0F 84 08 01 00 00 C7 04 24 29 00 00 00 E9 BC FE FF FF 8D 76 00 83 FD 01 0F 85 8F 00 00 00 8B 8C 24 8C 00 00 00 85 C9 0F 84 80 00 00 00 8B 44 24 40 C7 44 24 44 00 00 00 00 80 38 00 75 5F 8D 44 24 5F 89 44 24 04 8B 44 24 44 C7 44 24 0C 00 00 00 00 C7 44 24 08 0A 00 00 00 C6 44 24 5F 00 89 04 24 E8 ?? ?? ?? ?? 8B 54 24 28 89 04 24 8B 4C 24 2C 8B 03 E8 AC F9 FF FF 83 EC 04 89 03 8B 44 24 40 89 04 24 E8 ?? ?? ?? ?? 8B 13 31 C0 85 D2 0F 94 C0 83 C4 6C 5B 5E 5F 5D C2 10 00 8D 54 24 44 E8 BF F7 FF FF 85 C0 74 94 8D 76 00 8B 44 24 40 89 04 24 E8 ?? ?? ?? ?? 83 C4 6C B8 05 00 00 00 5B 5E 5F 5D C2 10 00 90 8D 74 26 00 83 C5 01 E9 F6 FD FF FF 89 74 24 04 8D 4C 24 3C 89 3C 24 8D 54 24 38 8D 44 24 40 E8 F8 EB FF FF 83 EC 08 85 C0 0F 84 F3 FD FF FF E9 90 FE FF FF B8 01 00 00 00 E9 A1 FD FF FF 31 C0 E9 F5 FD FF FF 8B AC 24 8C 00 00 00 C7 44 24 44 00 00 00 00 85 ED 75 8C 80 7C 17 01 29 8D 42 01 0F 85 7E FF FF FF 89 06 8B 44 24 40 31 F6 80 38 00 75 33 89 F7 C1 FF 1F 8D 44 24 5F C7 44 24 10 00 00 00 00 C7 44 24 0C 0A 00 00 00 89 44 24 08 89 34 24 89 7C 24 04 C6 44 24 5F 00 E8 ?? ?? ?? ?? E9 F8 FE FF FF 8D 54 24 44 E8 ED F6 FF FF 85 C0 0F 85 2D FF FF FF 8B 74 24 44 85 F6 79 B4 8B 4C 24 2C F7 DE 8B 54 24 28 89 F7 8B 03 C1 FF 1F C7 04 24 2D 00 00 00 E8 10 EA FF FF 85 C0 89 03 75 96 8B 44 24 40 89 04 24 E8 ?? ?? ?? ?? B8 01 00 00 00 E9 E7 FC FF FF }
	condition:
		$1
}

rule file_144_13_0 {
	meta:
		name = "parse_dollars"
		size = 6097
		refs = "00b8 __libc_tsd_CTYPE_B 02f2 pthread_setcancelstate 038e free 0558 __assert_fail 05dc strchr 06a4 strtol 06aa __libc_argc 0746 __strdup 0769 __setenv 07a8 strlen 07cb _itoa_word 0d44 getenv 0e3c __libc_argv 0f20 fnmatch 102a malloc 106b stpcpy 1157 strspn 117c strcspn 1296 __getpid 14b1 __fxprintf 15d8 _libc_intl_domainname 15dd __dcgettext 1613 mempcpy"
	strings:
		$1 = { 55 57 56 53 81 EC BC 00 00 00 8B 9C 24 D4 00 00 00 89 44 24 44 8B AC 24 D0 00 00 00 89 54 24 48 89 4C 24 4C 8B 03 89 C2 83 C2 01 8D 4C 15 00 89 44 24 34 0F B6 01 89 4C 24 40 3C 27 0F 84 46 01 00 00 0F 8E 38 01 00 00 3C 28 0F 84 B8 01 00 00 3C 5B 0F 84 68 01 00 00 8B 4C 24 40 89 13 C7 44 24 68 00 00 00 00 C7 44 24 64 00 00 00 00 0F B6 01 31 C9 C7 44 24 70 00 00 00 00 C7 44 24 6C 00 00 00 00 3C 7B 0F 94 C1 85 C9 89 4C 24 50 0F 84 1C 05 00 00 8B 54 24 34 8B 4C 24 34 C7 44 24 54 00 00 00 00 83 C2 02 89 13 0F B6 44 0D 02 3C 23 0F 84 92 05 00 00 8B 3D ?? ?? ?? ?? 0F BE C8 65 8B 37 F6 44 4E 01 04 0F 85 93 03 00 00 3C 5F 0F 84 8B 03 00 00 8D 41 D0 83 F8 09 0F 87 E7 04 00 00 8D 44 24 68 31 F6 8D 54 24 64 89 44 24 3C 89 F0 89 54 24 38 8D 76 00 89 0C 24 8B 54 24 38 8B 4C 24 3C E8 E8 E8 FF FF 85 C0 0F 84 70 04 00 00 8B 54 24 50 85 D2 0F 84 42 11 00 00 8B 13 8D 72 01 89 33 0F B6 54 15 01 0F BE CA 8D 79 D0 83 FF 09 76 C5 89 F1 89 C6 C7 44 24 38 01 00 00 00 0F BE C2 89 CA 3C 2D 0F 84 84 0F 00 00 0F 8F 66 08 00 00 3C 25 0F 84 4E 0F 00 00 3C 2B 8D 74 26 00 0F 84 6A 0F 00 00 3C 23 0F 84 13 0F 00 00 BA 05 00 00 00 31 FF E9 0F 04 00 00 8D B6 00 00 00 00 84 C0 0F 85 18 02 00 00 8B 5C 24 44 C7 04 24 24 00 00 00 8B 4C 24 4C 8B 54 24 48 8B 03 E8 4E E8 FF FF 89 03 31 D2 85 C0 0F 94 C2 81 C4 BC 00 00 00 89 D0 5B 5E 5F 5D C2 1C 00 8D B6 00 00 00 00 8B 44 24 34 83 C0 02 89 03 8B 84 24 D8 00 00 00 C7 44 24 0C 01 00 00 00 89 44 24 08 8B 54 24 48 8B 4C 24 4C 8B 44 24 44 89 5C 24 04 89 2C 24 E8 6C FA FF FF 83 EC 10 89 C2 81 C4 BC 00 00 00 89 D0 5B 5E 5F 5D C2 1C 00 8B 44 24 34 83 C0 02 89 C7 01 EF 80 3F 28 89 44 24 30 0F 84 90 01 00 00 8B 84 24 D8 00 00 00 BA 04 00 00 00 83 E0 04 0F 85 76 FF FF FF 8B 4C 24 30 C7 44 24 7C 00 00 00 00 C7 44 24 78 00 00 00 00 89 0B 8B 8C 24 E8 00 00 00 85 C9 0F 44 84 24 DC 00 00 00 31 F6 89 84 24 DC 00 00 00 0F B6 07 84 C0 0F 84 B2 03 00 00 0F BE D0 31 FF 89 F0 66 BE 01 00 C7 44 24 30 01 00 00 00 EB 38 8D 76 00 80 FA 22 0F 84 A7 01 00 00 89 14 24 8D 4C 24 7C 8D 54 24 78 E8 4F E7 FF FF 85 C0 0F 84 8F 03 00 00 8B 13 8D 4A 01 89 0B 0F BE 54 15 01 84 D2 0F 84 63 03 00 00 80 FA 27 0F 84 52 01 00 00 7E C0 80 FA 28 90 8D 74 26 00 0F 84 7A 01 00 00 80 FA 29 75 B6 85 FF 8D 76 00 75 AF 83 EE 01 75 AA 85 C0 89 C6 0F 84 6D 10 00 00 B8 ?? ?? ?? ?? 85 C0 C7 84 24 80 00 00 00 00 00 00 00 0F 84 6D 14 00 00 8D 84 24 80 00 00 00 89 44 24 04 C7 04 24 01 00 00 00 E8 ?? ?? ?? ?? 8B 94 24 D8 00 00 00 8B 4C 24 4C 8B 84 24 DC 00 00 00 8B 9C 24 E4 00 00 00 8B AC 24 E0 00 00 00 89 54 24 04 8B 54 24 44 89 0C 24 8B 4C 24 48 89 44 24 08 89 F0 89 5C 24 10 89 6C 24 0C E8 6E E9 FF FF 83 EC 14 89 C2 8B 84 24 80 00 00 00 C7 44 24 04 00 00 00 00 89 54 24 28 89 04 24 E8 ?? ?? ?? ?? 8B 54 24 28 89 34 24 89 54 24 28 E8 ?? ?? ?? ?? 8B 54 24 28 E9 10 FE FF FF 90 8D 74 26 00 3C 22 0F 85 B0 FC FF FF E9 DB FD FF FF 8D 76 00 8B 4C 24 34 8B 54 24 34 0F B6 44 0D 03 31 C9 83 C2 03 89 54 24 38 89 D6 84 C0 0F 84 50 FE FF FF 85 C9 75 1C 3C 29 0F 84 34 04 00 00 3C 28 66 90 75 1C 8D B6 00 00 00 00 83 C1 01 EB 11 8D 76 00 3C 28 74 F4 3C 29 0F 94 C0 0F B6 C0 29 C1 83 C2 01 0F B6 44 15 00 89 D6 84 C0 75 C4 E9 0F FE FF FF 8D B4 26 00 00 00 00 85 FF 0F 84 40 01 00 00 31 C9 83 FF 01 0F 95 C1 89 CF 01 FF E9 60 FE FF FF 8D B4 26 00 00 00 00 85 FF 0F 84 30 01 00 00 31 C9 83 FF 02 0F 95 C1 89 CF E9 42 FE FF FF 90 83 FF 01 83 D6 00 E9 36 FE FF FF 90 8D 74 26 00 8D 44 24 68 31 F6 8D 54 24 64 89 44 24 3C 89 F0 89 54 24 38 89 6C 24 30 89 0C 24 8B 54 24 38 8B 4C 24 3C E8 68 E5 FF FF 85 C0 0F 84 F0 00 00 00 8B 13 8B 4C 24 30 65 8B 2F 8D 72 01 89 33 0F B6 54 11 01 0F BE CA F6 44 4D 00 08 75 CB 80 FA 5F 74 C6 8B 6C 24 30 89 F2 89 C6 C7 44 24 38 00 00 00 00 8B 7C 24 50 85 FF 0F 85 B2 01 00 00 C7 44 24 3C 00 00 00 00 31 FF C7 44 24 30 00 00 00 00 83 EA 01 89 13 8B 4C 24 40 80 39 7B 0F 84 76 01 00 00 85 F6 0F 84 70 08 00 00 0F B6 06 0F BE D0 83 EA 30 83 FA 09 0F 86 84 01 00 00 8B 54 24 38 85 D2 0F 84 28 08 00 00 3C 24 0F 84 6D 0D 00 00 3C 2A 0F 94 C2 3C 40 0F 94 C0 0F 84 28 06 00 00 84 D2 0F 85 20 06 00 00 C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 D7 05 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 74 26 00 BF 01 00 00 00 E9 27 FD FF FF 8D B6 00 00 00 00 BF 02 00 00 00 E9 17 FD FF FF 8D B6 00 00 00 00 89 C6 BA 01 00 00 00 31 FF 89 34 24 89 54 24 28 E8 ?? ?? ?? ?? 89 3C 24 E8 ?? ?? ?? ?? 8B 54 24 28 81 C4 BC 00 00 00 5B 5E 5F 89 D0 5D C2 1C 00 3C 23 0F 84 BD 10 00 00 C7 44 24 54 00 00 00 00 E9 F1 FA FF FF 8D 76 00 89 4C 24 04 C7 04 24 ?? ?? ?? ?? 89 54 24 28 89 4C 24 2C E8 ?? ?? ?? ?? 8B 54 24 28 8B 4C 24 2C 85 C0 0F 84 1D 08 00 00 89 0C 24 31 C0 8D 4C 24 68 8D 54 24 64 E8 EE E3 FF FF 85 C0 89 C6 0F 84 E6 0C 00 00 8B 13 C7 44 24 38 01 00 00 00 83 C2 01 89 13 E9 A2 FE FF FF 89 C6 89 34 24 E8 ?? ?? ?? ?? BA 05 00 00 00 E9 77 FB FF FF 8D 74 26 00 BA 01 00 00 00 E9 69 FB FF FF 8D B6 00 00 00 00 89 CA 83 C2 03 89 13 0F B6 44 0D 03 C7 44 24 54 01 00 00 00 E9 55 FA FF FF 8D B4 26 00 00 00 00 8B 03 BA 05 00 00 00 80 7C 05 00 7D 0F 85 0F FF FF FF E9 73 FE FF FF 90 0F BE 44 15 00 E9 BA FA FF FF 8D B6 00 00 00 00 C7 44 24 08 0A 00 00 00 C7 44 24 04 00 00 00 00 89 34 24 E8 ?? ?? ?? ?? 3B 05 ?? ?? ?? ?? 0F 8C 86 07 00 00 F6 84 24 D8 00 00 00 20 0F 85 0D 0C 00 00 C7 44 24 34 00 00 00 00 31 ED 8D 74 26 00 8B 44 24 30 85 C0 0F 84 9C 00 00 00 8B 5C 24 30 83 EB 23 83 FB 2F 89 5C 24 38 0F 86 50 01 00 00 C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 26 06 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 ED 74 16 80 7D 00 00 0F 85 4C 07 00 00 8B 44 24 3C 85 C0 0F 84 67 02 00 00 8B 5C 24 34 85 DB 0F 85 7D 0E 00 00 85 FF 0F 84 BB 0D 00 00 89 3C 24 E8 ?? ?? ?? ?? BA 01 00 00 00 85 C0 89 C5 0F 84 30 FE FF FF C7 44 24 08 01 00 00 00 89 6C 24 04 89 34 24 E8 ?? ?? ?? ?? C7 44 24 34 01 00 00 00 8D 76 00 89 34 24 E8 ?? ?? ?? ?? 89 3C 24 E8 ?? ?? ?? ?? 8B 4C 24 54 85 C9 0F 84 21 06 00 00 85 ED C6 84 24 AF 00 00 00 00 0F 84 63 0F 00 00 89 2C 24 E8 ?? ?? ?? ?? 8D 94 24 AF 00 00 00 89 54 24 04 C7 44 24 0C 00 00 00 00 C7 44 24 08 0A 00 00 00 89 04 24 E8 ?? ?? ?? ?? 8B 5C 24 44 8B 54 24 48 8B 4C 24 4C 89 04 24 8B 03 E8 7B F0 FF FF 83 EC 04 8B 54 24 34 89 03 85 D2 0F 84 AE F9 FF FF 89 2C 24 E8 ?? ?? ?? ?? 8B 6C 24 44 8B 45 00 E9 9A F9 FF FF 8D B6 00 00 00 00 80 7C 35 01 29 0F 85 05 FA FF FF 8B 44 24 38 8B 94 24 D8 00 00 00 89 03 C7 44 24 0C 00 00 00 00 89 54 24 08 E9 A3 F9 FF FF 8D B4 26 00 00 00 00 FF 24 9D ?? ?? ?? ?? 85 FF C7 44 24 7C 00 00 00 00 C7 44 24 78 00 00 00 00 C7 44 24 74 00 00 00 00 0F 84 7A 0A 00 00 0F B6 07 84 C0 0F 84 6F 0A 00 00 89 74 24 50 89 FB 31 F6 C7 44 24 40 00 00 00 00 89 6C 24 58 EB 54 3C 24 0F 84 42 04 00 00 3C 27 0F 84 1C 04 00 00 3C 22 0F 84 BB 03 00 00 0F BE 13 89 DD 8B 44 24 74 89 14 24 8D 4C 24 7C 8D 54 24 78 E8 37 E1 FF FF 85 C0 89 44 24 74 0F 84 E6 03 00 00 89 EB 83 C3 01 0F 84 09 0A 00 00 0F B6 45 01 84 C0 0F 84 FD 09 00 00 3C 2A 74 20 7E A6 3C 5C 0F 84 8E 03 00 00 3C 7E 8D 74 26 00 0F 84 E5 02 00 00 3C 3F 75 A6 8D B6 00 00 00 00 85 F6 74 9C 8B 44 24 74 8D 4C 24 7C C7 04 24 5C 00 00 00 8D 54 24 78 E8 D4 E0 FF FF 85 C0 89 44 24 74 0F 84 83 03 00 00 0F BE 13 89 DD E9 77 FF FF FF 85 ED 0F 84 0D FF FF FF 80 7D 00 00 75 0C 8B 44 24 3C 85 C0 0F 85 FB FE FF FF 83 7C 24 38 2F 0F 86 FA 04 00 00 C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 73 07 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 ED 74 16 80 7D 00 00 0F 85 BE FE FF FF 8B 44 24 3C 85 C0 0F 84 B2 FE FF FF 8B 44 24 34 31 D2 85 C0 0F 84 E6 FB FF FF 89 2C 24 89 54 24 28 E8 ?? ?? ?? ?? 8B 54 24 28 E9 D1 FB FF FF 3C 3D 0F 84 10 07 00 00 0F 8F 33 07 00 00 3C 3A 0F 85 A0 F7 FF FF 8D 4A 01 8D 7C 0D 00 0F BE 07 C7 04 24 ?? ?? ?? ?? 89 54 24 28 89 4C 24 2C 89 44 24 04 E8 ?? ?? ?? ?? 8B 54 24 28 8B 4C 24 2C 85 C0 0F 84 6E F7 FF FF 89 0B 0F BE 3F 83 C2 02 8D 44 15 00 C7 44 24 3C 01 00 00 00 89 7C 24 30 89 13 0F B6 00 31 FF 84 C0 0F 84 B9 FA FF FF 89 74 24 5C 89 C1 31 F6 C7 44 24 50 00 00 00 00 89 F8 C7 44 24 58 00 00 00 00 EB 4C 90 8D 74 26 00 80 F9 22 0F 84 BF 00 00 00 80 F9 27 0F 84 9E 00 00 00 8D B6 00 00 00 00 8B 13 8D 4C 24 70 0F BE 54 15 00 89 14 24 8D 54 24 6C E8 79 DF FF FF 85 C0 74 6D 8B 0B 8D 51 01 89 13 0F B6 4C 0D 01 84 C9 0F 84 D0 02 00 00 80 F9 5C 74 24 7E B2 80 F9 7B 0F 84 89 00 00 00 80 F9 7D 75 BC 85 F6 75 B8 85 FF 0F 84 1A 0A 00 00 83 EF 01 EB AB 8D 76 00 85 F6 75 A4 8D 4A 01 89 0B 80 7C 15 01 00 0F 84 EE 09 00 00 C7 04 24 5C 00 00 00 8D 4C 24 70 8D 54 24 6C E8 10 DF FF FF 85 C0 0F 85 78 FF FF FF 8B 74 24 5C 89 C7 BA 01 00 00 00 E9 91 FA FF FF 85 F6 74 3C 83 FE 01 0F 95 C2 0F B6 F2 01 F6 E9 54 FF FF FF 8D 74 26 00 85 F6 74 34 83 FE 02 0F 95 C2 0F B6 F2 E9 3E FF FF FF 8D B6 00 00 00 00 83 FE 01 83 D7 00 E9 2D FF FF FF 90 8D 74 26 00 BE 01 00 00 00 E9 1E FF FF FF 8D B6 00 00 00 00 BE 02 00 00 00 E9 0E FF FF FF 8D B6 00 00 00 00 8B 6C 24 54 85 ED 0F 84 8C 04 00 00 8B 15 ?? ?? ?? ?? 31 C0 C7 44 24 0C 00 00 00 00 C7 44 24 08 0A 00 00 00 C6 84 24 9A 00 00 00 00 85 D2 8D 4A FF 0F 4F C1 8D 94 24 9A 00 00 00 89 54 24 04 89 04 24 E8 ?? ?? ?? ?? 8B 6C 24 44 8B 54 24 48 8B 4C 24 4C 89 04 24 8B 45 00 E8 AA EC FF FF 83 EC 04 89 45 00 89 34 24 E8 ?? ?? ?? ?? 89 3C 24 E8 ?? ?? ?? ?? 8B 5D 00 31 D2 85 DB 0F 94 C2 E9 D0 F5 FF FF 85 F6 0F 85 BD FC FF FF 8B 6C 24 78 85 ED 0F 85 B1 FC FF FF 8D 84 24 80 00 00 00 89 44 24 04 8D 4C 24 7C C7 44 24 08 00 00 00 00 8D 54 24 78 89 1C 24 8D 44 24 74 C7 84 24 80 00 00 00 00 00 00 00 E8 BF EC FF FF 83 EC 0C 85 C0 0F 84 06 01 00 00 8B 4C 24 34 89 C2 8B 74 24 50 8B 6C 24 58 85 C9 0F 85 CF 06 00 00 8B 44 24 74 89 54 24 28 89 04 24 E8 ?? ?? ?? ?? 8B 54 24 28 E9 2E F9 FF FF 83 FE 02 0F 84 E4 01 00 00 85 F6 0F 85 34 FC FF FF BE 02 00 00 00 89 DD E9 4D FC FF FF 8B 44 24 74 8D 54 24 78 C7 04 24 5C 00 00 00 8D 4C 24 7C 8D 6B 01 E8 5D DD FF FF 89 44 24 74 0F BE 53 01 84 D2 0F 84 FB 09 00 00 85 C0 0F 85 FE FB FF FF 8B 74 24 50 E9 3A FE FF FF 83 FE 01 0F 84 8B 01 00 00 85 F6 90 0F 85 DA FB FF FF BE 01 00 00 00 89 DD E9 F3 FB FF FF 8B AC 24 D8 00 00 00 8D 84 24 80 00 00 00 89 44 24 04 8D 4C 24 7C C7 44 24 18 01 00 00 00 8D 54 24 78 C7 44 24 14 00 00 00 00 8D 44 24 74 C7 44 24 10 00 00 00 00 C7 44 24 0C 00 00 00 00 89 6C 24 08 89 1C 24 C7 84 24 80 00 00 00 00 00 00 00 E8 D9 F2 FF FF 83 EC 1C 85 C0 0F 85 FA FE FF FF 03 9C 24 80 00 00 00 89 DD E9 85 FB FF FF 89 34 24 E8 ?? ?? ?? ?? 89 C5 85 ED 0F 84 62 F9 FF FF C7 44 24 34 00 00 00 00 E9 71 F9 FF FF 8B 74 24 5C 89 C7 E9 76 F7 FF FF 8B 4C 24 54 85 C9 0F 84 4E 05 00 00 8D 84 24 9A 00 00 00 89 44 24 04 A1 ?? ?? ?? ?? C7 44 24 0C 00 00 00 00 C7 44 24 08 0A 00 00 00 C6 84 24 9A 00 00 00 00 83 E8 01 89 04 24 E8 ?? ?? ?? ?? C7 44 24 54 00 00 00 00 89 C5 EB 95 85 ED 0F 84 A1 05 00 00 8B 84 24 E8 00 00 00 85 C0 75 0F 8B BC 24 DC 00 00 00 85 FF 0F 85 45 03 00 00 8B 5C 24 44 89 2C 24 8B 4C 24 4C 8B 54 24 48 8B 03 E8 73 EA FF FF 83 EC 04 8B 74 24 34 89 03 85 F6 0F 84 A6 F3 FF FF 89 2C 24 E8 ?? ?? ?? ?? 8B 03 E9 97 F3 FF FF 8B 44 24 50 85 C0 0F 85 66 04 00 00 C7 44 24 38 00 00 00 00 31 F6 31 FF C7 44 24 3C 00 00 00 00 C7 44 24 30 00 00 00 00 E9 A6 F6 FF FF 8B 15 ?? ?? ?? ?? 8B 2C 82 E9 02 FF FF FF 31 F6 89 DD E9 74 FA FF FF 8B 5C 24 38 FF 24 9D ?? ?? ?? ?? 85 ED 0F 84 2A 06 00 00 80 7D 00 00 0F 84 14 06 00 00 89 34 24 E8 ?? ?? ?? ?? 89 3C 24 E8 ?? ?? ?? ?? 83 7C 24 54 00 0F 85 0B F9 FF FF E9 2F FF FF FF 66 90 85 ED 74 06 80 7D 00 00 75 D4 8B 44 24 34 85 C0 0F 85 4A 06 00 00 85 ED 0F 84 F6 00 00 00 8B 44 24 3C 85 C0 0F 85 EA 00 00 00 31 D2 E9 C8 F6 FF FF 85 FF 0F 84 AF F8 FF FF 85 ED 90 8D 74 26 00 0F 84 A2 F8 FF FF 80 3F 00 74 93 89 2C 24 E8 ?? ?? ?? ?? 83 7C 24 30 4C 8D 5C 05 00 0F 84 7F 00 00 00 0F 87 0D 06 00 00 83 7C 24 30 23 0F 84 4E 06 00 00 83 7C 24 30 25 0F 85 60 FF FF FF EB 20 C7 44 24 08 00 00 00 00 89 5C 24 04 89 3C 24 E8 ?? ?? ?? ?? 83 F8 01 0F 85 B9 06 00 00 83 EB 01 39 EB 73 DC E9 3F F8 FF FF 8D B4 26 00 00 00 00 0F B6 13 C6 03 00 C7 44 24 08 00 00 00 00 89 6C 24 04 89 3C 24 88 54 24 28 E8 ?? ?? ?? ?? 0F B6 54 24 28 88 13 83 F8 01 0F 85 C6 06 00 00 83 EB 01 39 EB 73 CB E9 FE F7 FF FF 85 ED 8D 74 26 00 0F 84 0F FA FF FF 80 7D 00 00 75 0C 8B 44 24 3C 85 C0 0F 85 FD F9 FF FF 8B 44 24 34 85 C0 0F 85 3F 05 00 00 85 FF 0F 84 38 07 00 00 89 3C 24 E8 ?? ?? ?? ?? BA 01 00 00 00 85 C0 89 C5 0F 84 C6 F5 FF FF 89 34 24 E8 ?? ?? ?? ?? 89 3C 24 E8 ?? ?? ?? ?? 83 7C 24 54 00 C7 44 24 34 01 00 00 00 0F 85 AE F7 FF FF E9 D2 FD FF FF 90 8D 74 26 00 84 D2 0F 84 7D 03 00 00 8B 15 ?? ?? ?? ?? 31 ED }
	condition:
		$1
}

rule file_144_14_0 {
	meta:
		name = "wordfree"
		size = 73
		refs = "0027 free"
	strings:
		$1 = { 56 53 83 EC 14 8B 74 24 20 85 F6 74 36 8B 56 04 85 D2 74 2F 8B 46 08 8D 1C 82 8B 03 85 C0 74 14 89 04 24 83 C3 04 E8 ?? ?? ?? ?? 8B 03 85 C0 75 EF 8B 56 04 89 14 24 E8 ?? ?? ?? ?? C7 46 04 00 00 00 00 83 C4 14 5B 5E C3 }
	condition:
		$1
}

rule file_144_15_0 {
	meta:
		name = "wordexp"
		size = 3058
		refs = "009b calloc 00c7 getenv 018d strchr 0348 wordfree 0361 free 099b glob 0a4e globfree 0ad4 __strdup 0b1d __assert_fail"
	strings:
		$1 = { 55 57 56 53 81 EC AC 00 00 00 8B 84 24 C4 00 00 00 F6 84 24 C8 00 00 00 08 8B AC 24 C0 00 00 00 C7 44 24 64 00 00 00 00 8B 00 C7 44 24 60 00 00 00 00 C7 44 24 68 00 00 00 00 89 44 24 4C 8B 84 24 C4 00 00 00 8B 40 04 89 44 24 40 8B 84 24 C4 00 00 00 8B 40 08 89 44 24 48 0F 85 A0 08 00 00 8B 94 24 C8 00 00 00 83 E2 02 89 54 24 44 75 4F 8B 84 24 C4 00 00 00 F6 84 24 C8 00 00 00 01 C7 00 00 00 00 00 C7 44 24 04 04 00 00 00 0F 85 AA 07 00 00 C7 04 24 01 00 00 00 E8 ?? ?? ?? ?? 8B 94 24 C4 00 00 00 85 C0 89 42 04 0F 84 AE 07 00 00 8B 84 24 C4 00 00 00 C7 40 08 00 00 00 00 C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 89 44 24 2C 0F 84 8B 0A 00 00 0F B6 10 89 C3 8D 44 24 6C 89 44 24 38 89 C1 8B 74 24 38 84 D2 75 16 EB 58 80 FA 20 74 14 80 FA 0A 74 0F 83 C3 01 0F B6 13 84 D2 74 44 80 FA 09 75 E7 39 F1 0F 86 6C 07 00 00 3A 54 24 6C 0F 84 62 07 00 00 89 F0 8D 76 00 EB 0A 8D B6 00 00 00 00 3A 10 74 CE 83 C0 01 39 C8 75 F5 83 C3 01 88 10 0F B6 13 8D 48 01 84 D2 75 C2 8D B6 00 00 00 00 C6 01 00 0F B6 45 00 C7 44 24 5C 00 00 00 00 84 C0 0F 84 31 07 00 00 31 D2 E9 82 00 00 00 66 90 3C 24 0F 84 E0 04 00 00 0F 8F BA 02 00 00 3C 22 0F 84 02 04 00 00 0F BE F0 89 74 24 04 C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 0F 84 20 07 00 00 8B 54 24 68 85 D2 74 16 8B 84 24 C4 00 00 00 E8 43 CF FF FF 85 C0 89 C6 0F 85 29 02 00 00 C7 44 24 64 00 00 00 00 C7 44 24 60 00 00 00 00 C7 44 24 68 00 00 00 00 90 8B 44 24 5C 8D 50 01 0F B6 44 05 01 89 54 24 5C 84 C0 0F 84 A8 06 00 00 3C 3F 74 24 0F 8E 76 FF FF FF 3C 5C 0F 84 B6 04 00 00 8D B6 00 00 00 00 0F 8F 92 01 00 00 3C 5B 0F 85 70 FF FF FF 66 90 8B 54 24 5C C7 44 24 70 00 00 00 00 C7 44 24 74 00 00 00 00 C7 44 24 78 00 00 00 00 0F B6 5C 15 00 89 D7 84 DB 0F 84 40 09 00 00 BE 01 00 00 00 8D 44 24 70 89 74 24 34 89 D6 C7 44 24 28 00 00 00 00 89 44 24 3C 89 6C 24 30 E9 86 00 00 00 90 80 FB 22 0F 84 0F 01 00 00 83 7C 24 28 01 0F 84 4C 09 00 00 80 FB 24 0F 84 5B 05 00 00 80 FB 5C 0F 85 96 00 00 00 8B 44 24 28 85 C0 0F 84 D6 04 00 00 8D 44 24 5C 89 44 24 04 8B 44 24 30 8D 4C 24 64 8D 54 24 60 89 04 24 8D 44 24 68 E8 3E D0 FF FF 83 EC 08 89 44 24 34 8B 44 24 34 85 C0 0F 85 D6 04 00 00 8D 76 00 8B 7C 24 5C 8B 44 24 30 8D 77 01 89 F7 89 74 24 5C 0F B6 1C 30 84 DB 0F 84 74 08 00 00 8B 44 24 2C 0F BE EB 89 6C 24 04 89 04 24 E8 ?? ?? ?? ?? 85 C0 0F 85 1C 06 00 00 80 FB 27 0F 85 57 FF FF FF 8B 54 24 28 85 D2 0F 84 A3 04 00 00 83 7C 24 28 01 74 6F 8B 44 24 68 8D 4C 24 64 89 2C 24 8D 54 24 60 E8 90 CE FF FF 85 C0 89 44 24 68 75 90 8B 44 24 3C 8B 74 24 34 8B 6C 24 30 89 04 24 E8 ?? ?? ?? ?? 85 F6 0F 84 7C FE FF FF 8B 44 24 68 BE 01 00 00 00 89 04 24 E8 ?? ?? ?? ?? 81 C4 AC 00 00 00 89 F0 5B 5E 5F 5D C3 8D B6 00 00 00 00 8B 44 24 28 85 C0 0F 84 44 04 00 00 83 7C 24 28 02 75 91 C7 44 24 28 00 00 00 00 E9 34 FF FF FF 3C 60 0F 84 A8 00 00 00 3C 7E 0F 85 D6 FD FF FF 8B 94 24 C4 00 00 00 8D 5C 24 60 8D 4C 24 64 8B 02 89 DA 89 2C 24 89 44 24 08 8D 44 24 5C 89 44 24 04 8D 44 24 68 E8 DD DC FF FF 83 EC 0C 85 C0 89 C6 0F 84 F0 FD FF FF 8B 44 24 68 89 04 24 E8 ?? ?? ?? ?? 83 FE 01 0F 84 70 FF FF FF 8B 7C 24 44 85 FF 0F 84 34 01 00 00 8B 84 24 C4 00 00 00 8B 54 24 4C 89 10 8B 54 24 40 89 50 04 8B 54 24 48 89 50 08 81 C4 AC 00 00 00 89 F0 5B 5E 5F 5D C3 8D B4 26 00 00 00 00 3C 27 0F 84 80 00 00 00 3C 2A 0F 85 3E FD FF FF E9 CB FD FF FF 8D 76 00 F6 84 24 C8 00 00 00 04 0F 85 32 07 00 00 8B 44 24 38 83 C2 01 89 54 24 5C 8B 94 24 C8 00 00 00 8D 5C 24 60 89 2C 24 8D 4C 24 64 89 44 24 14 8B 44 24 2C 89 54 24 08 89 DA 89 44 24 10 8B 84 24 C4 00 00 00 89 44 24 0C 8D 44 24 5C 89 44 24 04 8D 44 24 68 E8 6F D7 FF FF 83 EC 18 85 C0 89 C6 0F 84 22 FD FF FF E9 2D FF FF FF 90 8D 74 26 00 8D 42 01 0F B6 54 15 01 89 44 24 5C 84 D2 0F 84 0D 01 00 00 80 FA 27 74 7F 8B 44 24 68 8D 5C 24 60 0F BE CA EB 1F 66 90 8B 54 24 5C 8D 4A 01 89 4C 24 5C 0F BE 4C 15 01 84 C9 0F 84 E5 00 00 00 80 F9 27 74 53 89 0C 24 89 DA 8D 4C 24 64 E8 B5 CC FF FF 85 C0 89 44 24 68 75 CD BE 01 00 00 00 89 04 24 E8 ?? ?? ?? ?? 83 FE 01 0F 84 3C FE FF FF 8B 7C 24 44 85 FF 0F 85 CC FE FF FF 8B 84 24 C4 00 00 00 89 04 24 E8 ?? ?? ?? ?? E9 B8 FE FF FF 8D B4 26 00 00 00 00 8B 5C 24 60 85 DB 0F 85 74 FC FF FF 8B 84 24 C4 00 00 00 31 D2 E8 86 CB FF FF 85 C0 89 C6 0F 84 5C FC FF FF E9 EC FD FF FF 8D B4 26 00 00 00 00 0F BE 44 15 01 8D 4A 01 89 4C 24 5C 84 C0 74 49 8B 9C 24 C8 00 00 00 3C 24 0F 84 71 01 00 00 7F 47 3C 22 74 AB 89 04 24 8B 44 24 68 8D 4C 24 64 8D 54 24 60 E8 07 CC FF FF 85 C0 89 44 24 68 0F 84 E7 05 00 00 8B 44 24 5C 8D 48 01 0F BE 44 05 01 89 4C 24 5C 84 C0 75 BE 8B 44 24 68 BE 05 00 00 00 E9 31 FF FF FF 90 3C 5C 0F 84 F0 00 00 00 3C 60 75 B1 F6 C3 04 0F 85 A1 05 00 00 83 C1 01 8D 44 24 5C 89 4C 24 5C 8D 54 24 60 89 44 24 04 8D 4C 24 64 C7 44 24 14 00 00 00 00 8D 44 24 68 C7 44 24 10 00 00 00 00 C7 44 24 0C 00 00 00 00 89 5C 24 08 89 2C 24 E8 D4 D5 FF FF 83 EC 18 85 C0 74 82 89 C6 8B 44 24 68 E9 CA FE FF FF 66 90 8B 44 24 38 8D 5C 24 60 8B 94 24 C8 00 00 00 8D 4C 24 64 C7 44 24 18 00 00 00 00 89 2C 24 89 44 24 14 8B 44 24 2C 89 54 24 08 89 DA 89 44 24 10 8B 84 24 C4 00 00 00 89 44 24 0C 8D 44 24 5C 89 44 24 04 8D 44 24 68 E8 34 E1 FF FF 83 EC 1C 85 C0 89 C6 0F 84 27 FB FF FF E9 32 FD FF FF 66 90 8D 44 24 5C 8D 5C 24 60 89 44 24 04 8D 4C 24 64 89 DA 89 2C 24 8D 44 24 68 E8 A2 CB FF FF 83 EC 08 85 C0 89 C6 0F 84 F5 FA FF FF E9 00 FD FF FF 8D 44 24 5C 89 44 24 04 8D 4C 24 64 89 2C 24 8D 54 24 60 8D 44 24 68 E8 F4 CB FF FF 83 EC 08 85 C0 0F 84 BE FE FF FF E9 37 FF FF FF 8D 74 26 00 8B 44 24 38 8D 4C 24 64 C7 44 24 18 01 00 00 00 8D 54 24 60 89 5C 24 08 89 2C 24 89 44 24 14 8B 44 24 2C 89 44 24 10 8B 84 24 C4 00 00 00 89 44 24 0C 8D 44 24 5C 89 44 24 04 8D 44 24 68 E8 7D E0 FF FF 83 EC 1C 85 C0 0F 84 67 FE FF FF E9 E0 FE FF FF 90 8D 74 26 00 8B 54 24 30 8D 44 24 5C 89 44 24 04 8D 4C 24 64 8D 44 24 68 89 14 24 8D 54 24 60 E8 E8 CA FF FF 83 EC 08 89 44 24 34 8B 44 24 34 85 C0 0F 84 2D FB FF FF 8B 74 24 34 8B 44 24 3C 89 04 24 E8 ?? ?? ?? ?? 8B 44 24 68 E9 64 FD FF FF 8D 74 26 00 C7 44 24 28 01 00 00 00 E9 07 FB FF FF 8D 76 00 C7 44 24 28 02 00 00 00 E9 F7 FA FF FF 8D 76 00 31 C0 8B 54 24 38 83 7C 24 28 02 8D 4C 24 64 0F 94 C0 89 44 24 18 8B 44 24 2C 89 54 24 14 8B 54 24 3C 89 44 24 10 8B 84 24 C8 00 00 00 89 54 24 0C 8B 54 24 30 89 44 24 08 8D 44 24 5C 89 44 24 04 8D 44 24 68 89 14 24 8D 54 24 60 E8 A7 DF FF FF 83 EC 1C 85 C0 89 44 24 34 0F 84 90 FA FF FF E9 5E FF FF FF 8B 50 08 89 D0 83 C0 01 89 04 24 E8 ?? ?? ?? ?? 8B 94 24 C4 00 00 00 85 C0 89 42 04 0F 85 60 F8 FF FF 8B 44 24 68 89 04 24 BE 01 00 00 00 E8 ?? ?? ?? ?? 81 C4 AC 00 00 00 89 F0 5B 5E 5F 5D C3 39 F1 0F 85 75 F8 FF FF 89 F0 E9 A7 F8 FF FF 8D 74 26 00 8B 54 24 68 31 F6 85 D2 0F 84 C7 FA FF FF 8B 84 24 C4 00 00 00 E8 46 C8 FF FF 81 C4 AC 00 00 00 5B 89 C6 89 F0 5E 5F 5D C3 89 74 24 04 C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 0F 85 E7 02 00 00 8B 44 24 68 8D 5C 24 60 89 34 24 8D 4C 24 64 89 DA E8 D9 C8 FF FF 85 C0 89 44 24 68 0F 85 DD F8 FF FF 31 C0 E9 69 FF FF FF 8D B6 00 00 00 00 8B 84 24 C4 00 00 00 89 04 24 E8 ?? ?? ?? ?? C7 44 24 40 00 00 00 00 E9 44 F7 FF FF 8B 6C 24 30 89 F2 83 EA 01 8B 44 24 3C 89 54 24 5C 8B 54 24 68 E8 BA C7 FF FF C7 44 24 64 00 00 00 00 C7 44 24 60 00 00 00 00 C7 44 24 68 00 00 00 00 85 C0 89 C6 0F 85 47 FE FF FF 8B 44 24 70 85 C0 0F 84 E4 01 00 00 89 6C 24 28 8B AC 24 C4 00 00 00 BF 01 00 00 00 8D 74 26 00 8B 44 24 74 8D 54 24 7C 89 54 24 0C C7 44 24 08 00 00 00 00 C7 44 24 04 10 00 00 00 8B 04 30 89 04 24 E8 ?? ?? ?? ?? 85 C0 0F 85 51 01 00 00 8B 44 24 2C 80 38 00 0F 85 C4 00 00 00 8B 84 24 80 00 00 00 8B 00 85 C0 0F 84 09 02 00 00 89 04 24 8B 44 24 68 8D 4C 24 64 8D 54 24 60 E8 57 D6 FF FF 83 EC 04 83 7C 24 7C 01 89 44 24 68 76 5F 85 C0 74 5B BB 01 00 00 00 EB 0E 8D B6 00 00 00 00 8B 44 24 68 85 C0 74 46 C7 04 24 20 00 00 00 8D 4C 24 64 8D 54 24 60 E8 AC C7 FF FF 85 C0 89 44 24 68 74 21 8B 94 24 80 00 00 00 8D 4C 24 64 8B 14 9A 89 14 24 8D 54 24 60 E8 FA D5 FF FF 83 EC 04 89 44 24 68 83 C3 01 3B 5C 24 7C 72 B2 8D 54 24 7C 89 14 24 E8 ?? ?? ?? ?? 8B 44 24 68 85 C0 0F 84 8A 00 00 00 83 C6 04 3B 7C 24 70 8D 47 01 0F 83 D6 00 00 00 89 C7 E9 03 FF FF FF 8D 76 00 8B 44 24 68 85 C0 74 20 89 04 24 E8 ?? ?? ?? ?? C7 44 24 64 00 00 00 00 C7 44 24 60 00 00 00 00 C7 44 24 68 00 00 00 00 8B 44 24 7C 31 DB 85 C0 75 1C EB 7C 8D 74 26 00 89 C2 89 E8 E8 37 C6 FF FF 85 C0 75 1F 83 C3 01 3B 5C 24 7C 73 62 8B 84 24 80 00 00 00 8B 04 98 89 04 24 E8 ?? ?? ?? ?? 85 C0 75 D4 8D 54 24 7C 89 14 24 E8 ?? ?? ?? ?? BE 01 00 00 00 E9 AD FC FF FF 8D B6 00 00 00 00 83 F8 01 74 EB C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 8B 01 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D B4 26 00 00 00 00 8D 44 24 7C 83 C6 04 89 04 24 E8 ?? ?? ?? ?? 8D 47 01 3B 7C 24 70 0F 82 2A FF FF FF 8B 6C 24 28 8B 54 24 3C 89 14 24 E8 ?? ?? ?? ?? E9 77 F6 FF FF 89 F2 89 C5 E9 C0 FD FF FF 8D 54 24 6C C7 44 24 6C 20 09 0A 00 89 54 24 38 89 54 24 2C E9 D0 F5 FF FF 8D 44 24 70 89 44 24 3C E9 9A FD FF FF BE 04 00 00 00 8B 44 24 68 89 04 24 E8 ?? ?? ?? ?? E9 57 F8 FF FF 8B 44 24 68 BE 04 00 00 00 E9 6C F9 FF FF 31 C0 BE 01 00 00 00 E9 60 F9 FF FF BE 02 00 00 00 EB CE 90 80 FB 5C 0F 85 53 F7 FF FF E9 C4 F6 FF FF C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 92 01 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_145_0_0 {
	meta:
		name = "__wcrtomb_chk"
		size = 75
		refs = "0004 _nl_current_LC_CTYPE 0047 __chk_fail 0042 __wcrtomb"
	strings:
		$1 = { 83 EC 0C A1 ?? ?? ?? ?? 89 74 24 08 8B 74 24 1C 89 5C 24 04 8B 54 24 10 8B 4C 24 14 65 8B 00 8B 5C 24 18 8B 00 39 70 58 77 1C 89 5C 24 18 8B 74 24 08 8B 5C 24 04 89 4C 24 14 89 54 24 10 83 C4 0C E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_146_0_0 {
	meta:
		name = "critical_factorization"
		size = 368
	strings:
		$1 = { 55 57 56 BE FF FF FF FF 53 31 DB 83 EC 18 89 4C 24 14 B9 01 00 00 00 89 54 24 08 C7 44 24 0C 01 00 00 00 89 44 24 10 90 8D 14 19 3B 54 24 08 73 30 8B 7C 24 10 8B 6C 24 10 01 F7 0F B6 04 0F 38 44 15 00 0F 83 A7 00 00 00 89 D0 89 D3 B9 01 00 00 00 29 F0 8D 14 19 3B 54 24 08 89 44 24 0C 72 D0 8B 44 24 10 31 DB BF FF FF FF FF 8B 4C 24 14 8B 6C 24 0C C7 44 24 10 01 00 00 00 89 34 24 89 44 24 04 89 29 B9 01 00 00 00 8D B6 00 00 00 00 8D 14 19 39 54 24 08 76 2C 8B 6C 24 04 8B 74 24 04 01 FD 0F B6 44 0D 00 38 04 16 76 63 89 D5 89 D3 B9 01 00 00 00 29 FD 8D 14 19 39 54 24 08 89 6C 24 10 77 D4 8B 34 24 8D 47 01 83 C6 01 39 F0 73 0A 8B 44 24 0C 89 44 24 10 89 F0 8B 74 24 10 8B 4C 24 14 89 31 83 C4 18 5B 5E 5F 5D C3 66 90 74 3E 89 DE B9 01 00 00 00 83 C3 01 C7 44 24 0C 01 00 00 00 E9 1F FF FF FF 8D B4 26 00 00 00 00 74 2E 89 DF B9 01 00 00 00 83 C3 01 C7 44 24 10 01 00 00 00 E9 67 FF FF FF 8D B4 26 00 00 00 00 3B 4C 24 0C 74 1A 83 C1 01 E9 EA FE FF FF 66 90 3B 4C 24 10 74 1A 83 C1 01 E9 42 FF FF FF 66 90 89 4C 24 0C 89 D3 B9 01 00 00 00 E9 C8 FE FF FF 89 4C 24 10 89 D3 B9 01 00 00 00 E9 20 FF FF FF }
	condition:
		$1
}

rule file_146_1_0 {
	meta:
		name = "two_way_long_needle"
		size = 956
		refs = "008e memcmp 00f8 memchr"
	strings:
		$1 = { 55 57 89 D7 56 53 81 EC 5C 04 00 00 8B 9C 24 70 04 00 00 89 4C 24 28 8D 4C 24 4C 89 44 24 18 8B 44 24 28 89 DA E8 66 FE FF FF 8D 94 24 50 04 00 00 89 44 24 20 8D 44 24 50 8D B4 26 00 00 00 00 89 18 83 C0 04 39 D0 75 F7 31 C0 85 DB 8B 6C 24 28 8D 73 FF 74 16 66 90 0F B6 54 05 00 89 F1 29 C1 83 C0 01 39 D8 89 4C 94 50 75 EC 8B 44 24 20 8B 54 24 4C 8B 4C 24 28 89 44 24 08 8B 44 24 28 89 54 24 2C 89 0C 24 01 D0 89 44 24 04 E8 ?? ?? ?? ?? 85 C0 0F 85 8E 01 00 00 8B 44 24 20 8D 53 FF 31 F6 8B 4C 24 28 89 5C 24 24 89 D3 C7 44 24 1C 00 00 00 00 83 E8 01 01 C1 89 44 24 30 8B 44 24 20 89 4C 24 34 F7 D8 01 C1 89 44 24 38 89 4C 24 3C 8D B6 00 00 00 00 8B 6C 24 1C 03 6C 24 24 C7 44 24 04 00 00 00 00 89 E8 29 F8 03 7C 24 18 89 44 24 08 89 3C 24 E8 ?? ?? ?? ?? 85 C0 0F 85 17 01 00 00 85 ED 0F 84 0F 01 00 00 8B 7C 24 18 0F B6 44 2F FF 8B 44 84 50 85 C0 74 23 85 F6 74 0F 8B 54 24 24 2B 54 24 2C 39 44 24 2C 0F 47 C2 01 44 24 1C 31 F6 89 EF EB 9E 8D B6 00 00 00 00 8B 44 24 20 3B 74 24 20 8B 4C 24 1C 8B 54 24 28 0F 43 C6 01 C1 03 4C 24 18 01 C2 39 D8 89 4C 24 14 73 2F 0F B6 09 38 0A 0F 85 94 00 00 00 8B 4C 24 14 89 C7 F7 DF 01 FA 01 F9 89 DF EB 0B 66 90 0F B6 1C 01 38 1C 02 75 77 83 C0 01 39 F8 72 F0 89 FB 8B 44 24 30 8B 4C 24 1C 01 C1 03 4C 24 18 3B 74 24 20 0F 83 FC 01 00 00 8B 7C 24 34 0F B6 11 38 17 0F 85 ED 01 00 00 03 4C 24 38 89 5C 24 14 8B 7C 24 3C EB 0F 90 0F B6 1C 01 8D 50 FF 38 1C 07 75 06 89 D0 39 F0 75 EE 8B 5C 24 14 83 C6 01 39 C6 0F 87 C6 01 00 00 8B 7C 24 2C 8B 74 24 24 01 7C 24 1C 29 FE 89 EF E9 DA FE FF FF 66 90 89 FB 8B 54 24 1C 31 F6 89 EF 2B 54 24 20 8D 54 10 01 89 54 24 1C E9 BD FE FF FF 31 C0 81 C4 5C 04 00 00 5B 5E 5F 5D C3 89 D8 8B 4C 24 28 2B 44 24 20 3B 44 24 20 0F 42 44 24 20 31 F6 03 4C 24 20 89 5C 24 1C 83 C0 01 89 44 24 3C 89 44 24 4C 8B 44 24 20 89 4C 24 2C 8B 4C 24 28 8B 6C 24 2C 83 E8 01 01 C1 89 44 24 24 8B 44 24 20 89 4C 24 30 F7 D8 89 44 24 28 01 C5 8D B4 26 00 00 00 00 8B 5C 24 1C C7 44 24 04 00 00 00 00 01 F3 89 D8 29 F8 03 7C 24 18 89 44 24 08 89 3C 24 E8 ?? ?? ?? ?? 85 C0 0F 85 71 FF FF FF 85 DB 0F 84 69 FF FF FF 8B 54 24 18 0F B6 44 1A FF 8B 44 84 50 85 C0 74 0D 01 C6 89 DF EB B7 8D B4 26 00 00 00 00 8B 4C 24 20 8B 54 24 1C 01 F1 83 EA 01 03 4C 24 18 39 54 24 20 73 34 8B 7C 24 2C 0F B6 01 38 07 8B 44 24 20 0F 85 88 00 00 00 03 4C 24 28 89 DF EB 10 8D B6 00 00 00 00 0F B6 1C 01 38 5C 05 00 75 6E 83 C0 01 39 D0 72 EF 89 FB 8B 7C 24 24 01 F7 03 7C 24 18 83 7C 24 24 FF 74 41 8B 54 24 30 0F B6 07 38 02 75 64 BA 01 00 00 00 31 C0 2B 54 24 20 89 5C 24 34 89 6C 24 38 8B 6C 24 30 89 D3 EB 17 8D B6 00 00 00 00 0F B6 4C 05 FF 0F B6 54 07 FF 83 E8 01 38 D1 75 2A 39 D8 75 EB 8B 44 24 18 81 C4 5C 04 00 00 5B 01 F0 5E 5F 5D C3 66 90 89 FB 89 F2 89 DF 2B 54 24 20 8D 74 10 01 E9 ED FE FF FF 8B 5C 24 34 8B 6C 24 38 03 74 24 3C 89 DF E9 DA FE FF FF 8B 44 24 20 E9 2F FE FF FF 8B 44 24 18 03 44 24 1C E9 61 FE FF FF }
	condition:
		$1
}

rule file_146_2_0 {
	meta:
		name = "strstr"
		size = 1106
		refs = "0073 strchr 0197 memcmp 0202 memchr"
	strings:
		$1 = { 55 57 56 53 83 EC 6C 8B BC 24 80 00 00 00 8B AC 24 84 00 00 00 0F B6 17 84 D2 0F 84 F7 03 00 00 0F B6 45 00 84 C0 0F 84 97 00 00 00 89 EE 89 F9 BB 01 00 00 00 EB 08 90 0F B6 06 84 C0 74 1D 38 C2 0F 94 C0 83 C1 01 0F B6 11 21 C3 83 C6 01 84 D2 75 E5 80 3E 00 0F 85 FC 00 00 00 84 DB 75 63 0F BE 45 00 89 F3 29 EB 89 44 24 04 8D 47 01 89 04 24 E8 ?? ?? ?? ?? 85 C0 89 44 24 20 0F 84 D5 00 00 00 83 FB 01 0F 84 BD 03 00 00 01 DF 29 DE 89 F8 BD 01 00 00 00 2B 44 24 20 39 7C 24 20 89 74 24 2C 0F 46 E8 83 FB 1F 0F 86 B9 00 00 00 8B 4C 24 2C 89 EA 8B 44 24 20 89 1C 24 E8 7F FB FF FF 89 C7 83 C4 6C 89 F8 5B 5E 5F 5D C3 8B 4C 24 20 89 D8 03 4C 24 28 8B 54 24 28 2B 44 24 28 89 4C 24 3C 8B 4C 24 2C 3B 44 24 28 0F 42 44 24 28 89 6C 24 24 89 DD 0F B6 14 11 83 C0 01 8B 4C 24 3C 89 44 24 5C 89 44 24 48 8B 44 24 28 88 54 24 1C 8B 54 24 2C 83 C0 01 01 C2 89 44 24 30 8B 44 24 28 89 54 24 40 8B 54 24 28 8B 7C 24 40 83 E8 01 F7 DA 89 44 24 38 0F B6 01 01 D7 38 44 24 1C 89 54 24 44 8D 51 01 0F 84 14 02 00 00 8D 76 00 84 C0 0F 85 F7 01 00 00 83 C4 6C 31 FF 5B 89 F8 5E 5F 5D C3 8D 74 26 00 8D 4C 24 5C 89 DA 89 F0 E8 5B F9 FF FF 8B 54 24 5C 8B 4C 24 2C 89 54 24 34 89 0C 24 89 44 24 28 89 44 24 08 8B 44 24 2C 01 D0 89 44 24 04 E8 ?? ?? ?? ?? 85 C0 0F 85 2A FF FF FF 8B 44 24 28 89 DA 31 F6 8B 4C 24 2C 2B 54 24 34 C7 44 24 1C 00 00 00 00 83 E8 01 01 C1 89 4C 24 38 8B 4C 24 28 8B 7C 24 38 89 44 24 30 89 54 24 40 F7 D9 89 4C 24 3C 01 CF 8D 74 26 00 8B 54 24 1C C7 44 24 04 00 00 00 00 01 DA 89 D0 29 E8 03 6C 24 20 89 44 24 08 89 54 24 24 89 2C 24 E8 ?? ?? ?? ?? 85 C0 0F 85 4A FF FF FF 8B 44 24 24 85 C0 0F 84 3E FF FF FF 8B 44 24 28 3B 74 24 28 8B 4C 24 1C 8B 54 24 2C 0F 43 C6 01 C1 03 4C 24 20 01 C2 39 C3 89 4C 24 44 76 39 0F B6 09 38 0A 0F 85 9C 00 00 00 8B 4C 24 44 89 C5 F7 DD 01 EA 89 5C 24 44 01 E9 EB 0F 8D B6 00 00 00 00 0F B6 1C 01 38 1C 02 75 77 83 C0 01 39 44 24 44 77 EE 8B 5C 24 44 8B 44 24 30 8B 4C 24 1C 01 C1 03 4C 24 20 39 74 24 28 0F 86 80 01 00 00 8B 6C 24 38 0F B6 11 38 55 00 0F 85 70 01 00 00 03 4C 24 3C 89 5C 24 44 EB 0E 0F B6 1C 01 8D 50 FF 38 1C 07 75 06 89 D0 39 F0 75 EE 8B 5C 24 44 83 C6 01 39 F0 0F 82 5A 01 00 00 8B 6C 24 34 01 6C 24 1C 8B 74 24 40 8B 6C 24 24 E9 02 FF FF FF 66 90 8B 5C 24 44 8B 54 24 1C 31 F6 2B 54 24 28 8D 54 10 01 89 54 24 1C EB DD 8B 6C 24 4C 84 D2 0F 84 54 FE FF FF 8B 74 24 34 03 74 24 48 8D 1C 2E 89 D8 2B 44 24 24 C7 44 24 04 00 00 00 00 89 44 24 08 8B 44 24 20 03 44 24 24 89 04 24 E8 ?? ?? ?? ?? 85 C0 0F 85 1F FE FF FF 85 DB 0F 84 17 FE FF FF 8B 54 24 28 89 5C 24 24 01 F2 03 54 24 20 89 D1 0F B6 01 8D 51 01 38 44 24 1C 0F 85 EF FD FF FF 8B 44 24 30 2B 54 24 3C 83 EA 01 39 C5 89 54 24 34 76 32 8B 5C 24 40 83 C1 02 0F B6 51 FF 03 4C 24 44 38 13 74 18 E9 A4 00 00 00 8D 74 26 00 0F B6 54 01 FE 38 54 07 FF 0F 85 91 00 00 00 83 C0 01 39 C5 77 EA 8B 44 24 34 8B 5C 24 20 03 44 24 38 8B 74 24 2C 03 74 24 38 01 C3 83 7C 24 38 FF 74 3E 0F B6 13 38 16 0F 85 2E FF FF FF BA 01 00 00 00 31 C0 2B 54 24 28 89 6C 24 4C 89 D5 EB 1C 8D B4 26 00 00 00 00 0F B6 4C 06 FF 0F B6 54 03 FF 83 E8 01 38 D1 0F 85 FB FE FF FF 39 E8 75 E7 8B 7C 24 20 03 7C 24 34 E9 B5 FC FF FF 8B 44 24 28 E9 A7 FE FF FF 89 EE BB 01 00 00 00 E9 30 FC FF FF 8B 7C 24 20 03 7C 24 1C E9 93 FC FF FF 84 D2 0F 84 20 FD FF FF 8B 54 24 34 2B 54 24 28 8D 74 10 01 E9 C3 FE FF FF 8B 7C 24 20 E9 71 FC FF FF }
	condition:
		$1
}

rule file_147_2_0 {
	meta:
		name = "__libc_allocate_rtsig"
		size = 59
	strings:
		$1 = { A1 ?? ?? ?? ?? 83 F8 FF 74 23 8B 15 ?? ?? ?? ?? 39 D0 7F 14 8B 4C 24 04 85 C9 74 14 8D 50 01 89 15 ?? ?? ?? ?? C3 66 90 B8 FF FF FF FF F3 C3 90 8D 42 FF A3 ?? ?? ?? ?? 89 D0 C3 }
	condition:
		$1
}

rule file_149_3_0 {
	meta:
		name = "_IO_ftell"
		size = 384
		refs = "0076 _IO_seekoff_unlocked 00da __libc_errno 017c _Unwind_Resume"
		altNames = "ftello"
	strings:
		$1 = { 83 EC 3C 89 74 24 30 8B 74 24 40 89 5C 24 2C 89 7C 24 34 89 6C 24 38 8B 06 25 00 80 00 00 75 32 8B 56 48 65 8B 1D 08 00 00 00 3B 5A 08 74 1F B9 01 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 0A 0F 85 38 01 00 00 8B 56 48 89 5A 08 83 42 04 01 C7 44 24 10 00 00 00 00 C7 44 24 0C 01 00 00 00 C7 44 24 04 00 00 00 00 C7 44 24 08 00 00 00 00 89 34 24 E8 ?? ?? ?? ?? 8B 3E 89 D5 89 D3 89 C2 89 C1 F7 D5 F7 D2 F7 C7 00 01 00 00 74 0D 89 E8 09 D0 74 07 8B 46 68 85 C0 7E 7B 81 E7 00 80 00 00 75 0B 8B 76 48 83 6E 04 01 74 4A 66 90 09 D5 74 24 89 CF 89 C8 C1 FF 1F 39 DF 75 79 8B 5C 24 2C 8B 74 24 30 8B 7C 24 34 8B 6C 24 38 83 C4 3C C3 90 8D 74 26 00 8B 15 ?? ?? ?? ?? B8 FF FF FF FF 65 8B 0A 85 C9 75 D5 65 C7 02 05 00 00 00 EB CC 90 8D 74 26 00 C7 46 08 00 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 83 2E 01 75 7D EB 9F 8D B4 26 00 00 00 00 8B 46 2C 2B 46 24 89 C2 C1 FA 1F 29 C1 19 D3 89 CA 89 DD F7 D2 F7 D5 E9 69 FF FF FF 8D 74 26 00 A1 ?? ?? ?? ?? 65 C7 00 4B 00 00 00 B8 FF FF FF FF E9 71 FF FF FF F7 06 00 80 00 00 89 C3 75 20 8B 56 48 83 6A 04 01 75 17 C7 42 08 00 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 83 2A 01 75 20 89 1C 24 E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_151_2_0 {
	meta:
		name = "__new_exitfn"
		size = 302
		refs = "00a4 __new_exitfn_called 00f2 calloc 0126 __assert_fail"
	strings:
		$1 = { 55 31 C0 57 B9 01 00 00 00 56 53 83 EC 1C 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 0D ?? ?? ?? ?? 0F 85 85 01 00 00 8B 44 24 30 8B 38 85 FF 0F 84 D2 00 00 00 89 FE 31 ED 8B 5E 04 85 DB 74 34 8D 53 FF 89 D0 C1 E0 04 8B 4C 06 08 85 C9 75 39 83 EB 02 C1 E3 04 8D 4C 1E 08 EB 12 90 8D 74 26 00 83 E9 10 8B 41 10 85 C0 75 1E 83 EA 01 85 D2 89 D3 75 ED 8B 06 89 F5 C7 46 04 00 00 00 00 85 C0 74 54 89 C6 EB B2 66 90 83 FB 20 74 45 89 D8 83 C3 01 C1 E0 04 8D 54 06 08 89 5E 04 C7 02 01 00 00 00 83 05 ?? ?? ?? ?? 01 83 15 ?? ?? ?? ?? 00 65 83 3D 0C 00 00 00 00 74 01 F0 83 2D ?? ?? ?? ?? 01 0F 85 F3 00 00 00 83 C4 1C 89 D0 5B 5E 5F 5D C3 85 ED 74 0C 8D 55 08 C7 45 04 01 00 00 00 EB BA C7 44 24 04 08 02 00 00 C7 04 24 01 00 00 00 E8 ?? ?? ?? ?? 85 C0 89 C5 74 2E 89 38 8B 44 24 30 89 28 EB D0 C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 63 00 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 31 D2 EB 82 }
	condition:
		$1
}

rule file_151_3_0 {
	meta:
		name = "__internal_atexit"
		size = 69
		refs = "000b __new_exitfn"
	strings:
		$1 = { 83 EC 1C 8B 44 24 2C 89 04 24 E8 ?? ?? ?? ?? 85 C0 74 2B 8B 54 24 20 65 33 15 18 00 00 00 C1 C2 09 89 50 04 8B 54 24 24 89 50 08 8B 54 24 28 89 50 0C C7 00 04 00 00 00 31 C0 83 C4 1C C3 B8 FF FF FF FF EB F5 }
	condition:
		$1
}

rule file_151_4_0 {
	meta:
		name = "__cxa_atexit"
		size = 43
		refs = "000b __exit_funcs 0023 __internal_atexit"
	strings:
		$1 = { 83 EC 1C 8B 44 24 28 C7 44 24 0C ?? ?? ?? ?? 89 44 24 08 8B 44 24 24 89 44 24 04 8B 44 24 20 89 04 24 E8 ?? ?? ?? ?? 83 C4 1C C3 }
	condition:
		$1
}

rule file_1172_3_0 {
	meta:
		name = "___vfscanf"
		size = 43
		refs = "0023 _IO_vfscanf_internal"
	strings:
		$1 = { 83 EC 1C 8B 44 24 28 C7 44 24 0C 00 00 00 00 89 44 24 08 8B 44 24 24 89 44 24 04 8B 44 24 20 89 04 24 E8 ?? ?? ?? ?? 83 C4 1C C3 }
	condition:
		$1
}

rule file_1094_0_0 {
	meta:
		name = "__assert"
		size = 39
		refs = "0023 __assert_fail"
	strings:
		$1 = { 83 EC 1C 8B 44 24 28 C7 44 24 0C 00 00 00 00 89 44 24 08 8B 44 24 24 89 44 24 04 8B 44 24 20 89 04 24 E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_849_3_0 {
	meta:
		name = "__vfwscanf"
		size = 43
		refs = "0023 _IO_vfwscanf"
	strings:
		$1 = { 83 EC 1C 8B 44 24 28 C7 44 24 0C 00 00 00 00 89 44 24 08 8B 44 24 24 89 44 24 04 8B 44 24 20 89 04 24 E8 ?? ?? ?? ?? 83 C4 1C C3 }
	condition:
		$1
}

rule file_813_0_0 {
	meta:
		name = "strtoimax"
		size = 43
		refs = "0023 __strtoll_internal"
	strings:
		$1 = { 83 EC 1C 8B 44 24 28 C7 44 24 0C 00 00 00 00 89 44 24 08 8B 44 24 24 89 44 24 04 8B 44 24 20 89 04 24 E8 ?? ?? ?? ?? 83 C4 1C C3 }
	condition:
		$1
}

rule file_754_0_0 {
	meta:
		name = "strtoumax"
		size = 43
		refs = "0023 __strtoull_internal"
	strings:
		$1 = { 83 EC 1C 8B 44 24 28 C7 44 24 0C 00 00 00 00 89 44 24 08 8B 44 24 24 89 44 24 04 8B 44 24 20 89 04 24 E8 ?? ?? ?? ?? 83 C4 1C C3 }
	condition:
		$1
}

rule file_700_0_0 {
	meta:
		name = "wcstoimax"
		size = 43
		refs = "0023 __wcstoll_internal"
	strings:
		$1 = { 83 EC 1C 8B 44 24 28 C7 44 24 0C 00 00 00 00 89 44 24 08 8B 44 24 24 89 44 24 04 8B 44 24 20 89 04 24 E8 ?? ?? ?? ?? 83 C4 1C C3 }
	condition:
		$1
}

rule file_542_0_0 {
	meta:
		name = "wcstoumax"
		size = 43
		refs = "0023 __wcstoull_internal"
	strings:
		$1 = { 83 EC 1C 8B 44 24 28 C7 44 24 0C 00 00 00 00 89 44 24 08 8B 44 24 24 89 44 24 04 8B 44 24 20 89 04 24 E8 ?? ?? ?? ?? 83 C4 1C C3 }
	condition:
		$1
}

rule file_152_0_0 {
	meta:
		name = "__sched_getscheduler"
		size = 31
		refs = "000d _dl_sysinfo 001a __syscall_error"
	strings:
		$1 = { 89 DA 8B 5C 24 04 B8 9D 00 00 00 FF 15 ?? ?? ?? ?? 89 D3 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_153_0_0 {
	meta:
		name = "putmsg"
		size = 84
		refs = "002a _dl_sysinfo 0046 __libc_errno"
	strings:
		$1 = { 83 EC 0C 89 1C 24 8B 54 24 18 89 74 24 04 8B 4C 24 14 BE FF FF FF FF 89 7C 24 08 8B 5C 24 10 8B 7C 24 1C B8 BD 00 00 00 FF 15 ?? ?? ?? ?? 3D 00 F0 FF FF 77 0F 8B 1C 24 8B 74 24 04 8B 7C 24 08 83 C4 0C C3 8B 15 ?? ?? ?? ?? F7 D8 65 89 02 83 C8 FF EB E1 }
	condition:
		$1
}

rule file_154_0_0 {
	meta:
		name = "__wcscat_chk"
		size = 83
		refs = "004f __chk_fail"
	strings:
		$1 = { 57 56 53 8B 44 24 10 8B 7C 24 14 8B 5C 24 18 89 C1 EB 07 90 8D 74 26 00 89 F3 85 DB 74 30 8B 11 83 C1 04 8D 73 FF 85 D2 75 EE 8B 34 97 85 F6 89 74 91 FC 74 15 8D 76 00 83 C2 01 39 DA 74 0F 8B 34 97 85 F6 89 74 91 FC 75 EE 5B 5E 5F C3 E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_155_0_0 {
	meta:
		name = "__readlinkat_chk"
		size = 56
		refs = "0034 __chk_fail 002f readlinkat"
	strings:
		$1 = { 53 83 EC 08 8B 44 24 1C 3B 44 24 20 8B 54 24 10 8B 4C 24 14 8B 5C 24 18 77 19 89 5C 24 18 89 44 24 1C 89 4C 24 14 89 54 24 10 83 C4 08 5B E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_156_0_0 {
	meta:
		name = "_IO_wpadn"
		size = 164
	strings:
		$1 = { 55 57 BF ?? ?? ?? ?? 56 53 83 EC 5C 8B 54 24 74 8B 6C 24 70 8B 5C 24 78 83 FA 20 74 20 83 FA 30 BF ?? ?? ?? ?? 74 16 8D 44 24 4C 8D 4C 24 0C 90 89 10 83 E8 04 39 C8 75 F7 8D 7C 24 10 31 F6 83 FB 0F 7F 0C EB 3A 66 90 83 EB 10 83 FB 0F 7E 30 8B 85 94 00 00 00 C7 44 24 08 10 00 00 00 89 7C 24 04 89 2C 24 FF 50 1C 01 C6 83 F8 10 74 D9 83 C4 5C 89 F0 5B 5E 5F 5D C3 8D B4 26 00 00 00 00 85 DB 7E EB 8B 85 94 00 00 00 89 5C 24 08 89 7C 24 04 89 2C 24 FF 50 1C 83 C4 5C 5B 01 C6 89 F0 5E 5F 5D C3 }
	condition:
		$1
}

rule file_157_0_0 {
	meta:
		name = "mkostemps"
		size = 67
		refs = "0027 __gen_tempname 0031 __libc_errno"
	strings:
		$1 = { 83 EC 1C 8B 44 24 24 85 C0 78 25 8B 54 24 28 89 44 24 04 8B 44 24 20 C7 44 24 0C 00 00 00 00 89 54 24 08 89 04 24 E8 ?? ?? ?? ?? 83 C4 1C C3 90 A1 ?? ?? ?? ?? 65 C7 00 16 00 00 00 B8 FF FF FF FF EB E8 }
	condition:
		$1
}

rule file_158_0_0 {
	meta:
		name = "fgets_unlocked"
		size = 185
		refs = "005b _IO_getline 006e __libc_errno"
	strings:
		$1 = { 83 EC 3C 8B 44 24 44 89 5C 24 2C 8B 5C 24 48 89 74 24 30 8B 74 24 40 89 7C 24 34 85 C0 89 6C 24 38 0F 8E 89 00 00 00 83 F8 01 0F 84 84 00 00 00 8B 13 83 E8 01 89 D7 83 E2 DF 89 13 83 E7 20 C7 44 24 10 01 00 00 00 C7 44 24 0C 0A 00 00 00 89 44 24 08 89 74 24 04 89 1C 24 E8 ?? ?? ?? ?? 31 C9 8B 13 85 C0 74 19 F6 C2 20 74 34 8B 2D ?? ?? ?? ?? 31 C9 65 83 7D 00 0B 74 25 90 8D 74 26 00 09 D7 89 CE 89 3B 89 F0 8B 5C 24 2C 8B 74 24 30 8B 7C 24 34 8B 6C 24 38 83 C4 3C C3 8D 74 26 00 C6 04 06 00 89 F1 8B 13 EB D6 8D B6 00 00 00 00 31 F6 EB D2 C6 06 00 EB CD }
	condition:
		$1
}

rule file_159_0_0 {
	meta:
		name = "enlarge_userbuf.part.0"
		size = 475
		refs = "0093 __wmemcpy 00d9 _IO_wsetb 0151 wmemset 01c6 __assert_fail"
	strings:
		$1 = { 83 EC 4C 89 4C 24 28 8B 48 58 89 7C 24 44 F6 40 3C 08 89 5C 24 3C 8B 79 14 89 74 24 40 89 6C 24 48 89 7C 24 24 8B 79 0C 89 7C 24 18 74 1A B8 01 00 00 00 8B 5C 24 3C 8B 74 24 40 8B 7C 24 44 8B 6C 24 48 83 C4 4C C3 90 8D 3C 95 90 01 00 00 8B 69 18 89 C3 89 54 24 1C 89 4C 24 20 89 7C 24 2C 89 3C 24 FF 90 98 00 00 00 8B 54 24 1C 8B 4C 24 20 85 C0 89 C6 74 B7 85 ED 74 34 8B 7B 58 8B 47 1C 2B 47 18 89 6C 24 04 89 34 24 C1 F8 02 89 44 24 08 E8 ?? ?? ?? ?? 89 2C 24 FF 93 9C 00 00 00 8B 4C 24 20 8B 54 24 1C C7 41 18 00 00 00 00 8B 44 24 2C 8B 7C 24 24 C7 44 24 0C 01 00 00 00 89 74 24 04 01 F0 89 44 24 08 89 1C 24 2B 7C 24 18 89 54 24 1C 89 4C 24 20 E8 ?? ?? ?? ?? 8B 54 24 50 C1 FF 02 8B 4C 24 20 85 D2 8B 54 24 1C 74 70 8B 41 0C 89 FB C1 FB 1F 89 71 08 29 E8 83 E0 FC 01 F0 89 41 0C 8B 41 10 29 E8 83 E0 FC 01 F0 89 41 10 8B 41 14 29 E8 83 E0 FC 01 F0 89 41 14 8B 01 29 E8 83 E0 FC 01 F0 89 01 8B 41 1C 39 5C 24 28 89 41 04 7F 06 7C 6E 39 FA 72 6A 29 FA 8D 04 BE 89 54 24 08 C7 44 24 04 00 00 00 00 89 04 24 E8 ?? ?? ?? ?? 31 C0 E9 D7 FE FF FF 8D 74 26 00 8B 41 08 89 FB C1 FB 1F 89 71 0C 29 E8 83 E0 FC 01 F0 89 41 08 8B 01 29 E8 83 E0 FC 01 F0 89 01 8B 41 04 29 E8 83 E0 FC 01 F0 89 41 04 8B 41 10 29 E8 83 E0 FC 01 F0 89 41 10 8B 41 1C 39 5C 24 28 89 41 14 7D 2A C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 E6 00 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D B6 00 00 00 00 0F 8F 66 FF FF FF E9 5D FF FF FF }
	condition:
		$1
}

rule file_159_1_0 {
	meta:
		name = "_IO_wstr_underflow"
		size = 104
	strings:
		$1 = { 83 EC 08 89 1C 24 8B 5C 24 0C 89 74 24 04 8B 43 58 8B 50 10 8B 70 04 39 F2 76 05 89 50 04 89 D6 8B 0B 81 E1 00 0C 00 00 81 F9 00 0C 00 00 74 28 8B 10 39 D6 B8 FF FF FF FF 77 0D 8B 1C 24 8B 74 24 04 83 C4 08 C3 66 90 8B 02 8B 1C 24 8B 74 24 04 83 C4 08 C3 8D 76 00 8B 48 14 81 23 FF F7 FF FF 89 10 89 48 10 EB CA }
	condition:
		$1
}

rule file_159_2_0 {
	meta:
		name = "_IO_wstr_finish"
		size = 64
		refs = "003c _IO_wdefault_finish"
	strings:
		$1 = { 53 83 EC 18 8B 5C 24 20 8B 43 58 8B 50 18 85 D2 74 12 F6 43 3C 08 75 0C 89 14 24 FF 93 9C 00 00 00 8B 43 58 C7 40 18 00 00 00 00 89 5C 24 20 C7 44 24 24 00 00 00 00 83 C4 18 5B E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_159_3_0 {
	meta:
		name = "_IO_wstr_pbackfail"
		size = 37
		refs = "0021 _IO_wdefault_pbackfail"
	strings:
		$1 = { 8B 44 24 04 8B 54 24 08 F6 00 08 74 0B 83 FA FF 74 06 B8 FF FF FF FF C3 89 54 24 08 89 44 24 04 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_159_4_0 {
	meta:
		name = "_IO_wstr_overflow"
		size = 455
		refs = "00dc __wmemcpy 011c wmemset 013e _IO_wsetb"
	strings:
		$1 = { 83 EC 3C 31 D2 89 7C 24 34 8B 7C 24 40 89 5C 24 2C 8B 5C 24 44 89 74 24 30 89 6C 24 38 8B 07 83 FB FF 0F 94 C2 A8 08 74 1F 83 FA 01 19 DB 89 D8 8B 74 24 30 8B 5C 24 2C 8B 7C 24 34 8B 6C 24 38 83 C4 3C C3 8D 74 26 00 89 C1 81 E1 00 0C 00 00 81 F9 00 04 00 00 0F 84 54 01 00 00 8B 47 58 8B 48 10 8B 70 18 2B 48 0C 89 74 24 18 8B 70 1C C1 F9 02 2B 74 24 18 C1 FE 02 8D 2C 16 39 E9 0F 82 0C 01 00 00 F6 47 3C 08 74 0E BB FF FF FF FF EB 9D 8D B4 26 00 00 00 00 8D 46 32 8D 2C 00 39 EE 77 E8 C1 E0 03 89 54 24 10 89 44 24 1C 89 04 24 FF 97 98 00 00 00 8B 54 24 10 85 C0 89 C1 74 CA 8B 44 24 18 85 C0 74 37 8B 44 24 18 89 0C 24 89 74 24 08 89 4C 24 14 89 44 24 04 E8 ?? ?? ?? ?? 8B 44 24 18 89 04 24 FF 97 9C 00 00 00 8B 47 58 8B 4C 24 14 8B 54 24 10 C7 40 18 00 00 00 00 8D 04 B1 29 F5 89 6C 24 08 C7 44 24 04 00 00 00 00 89 04 24 89 54 24 10 89 4C 24 14 E8 ?? ?? ?? ?? 8B 4C 24 14 8B 44 24 1C C7 44 24 0C 01 00 00 00 89 3C 24 89 4C 24 04 01 C8 89 44 24 08 E8 ?? ?? ?? ?? 8B 47 58 8B 4C 24 14 8B 54 24 10 8B 70 08 2B 74 24 18 89 48 0C 83 E6 FC 01 CE 89 70 08 8B 30 2B 74 24 18 83 E6 FC 01 CE 89 30 8B 70 04 2B 74 24 18 83 E6 FC 01 CE 89 70 04 8B 70 10 2B 74 24 18 83 E6 FC 01 CE 8B 48 1C 89 70 10 89 48 14 85 D2 8B 50 10 75 08 89 1A 83 C2 04 89 50 10 3B 50 04 0F 86 86 FE FF FF 89 50 04 E9 7E FE FF FF 80 CC 08 89 07 8B 47 58 8B 08 8B 70 04 89 48 10 89 30 E9 9B FE FF FF }
	condition:
		$1
}

rule file_159_5_0 {
	meta:
		name = "_IO_wstr_seekoff"
		size = 565
	strings:
		$1 = { 83 EC 2C 89 6C 24 28 8B 6C 24 40 89 74 24 20 8B 54 24 30 89 7C 24 24 8B 74 24 34 89 5C 24 1C 8B 7C 24 38 85 ED 75 69 8B 02 F6 C4 04 0F 84 16 01 00 00 F6 C4 08 0F 84 9D 00 00 00 8B 54 24 30 8B 4A 58 8B 59 04 39 59 10 0F 43 59 10 2B 59 08 C1 FB 02 83 7C 24 3C 01 0F 84 43 01 00 00 83 7C 24 3C 02 75 09 89 DA C1 FA 1F 01 DE 11 D7 85 FF 0F 88 B1 01 00 00 39 F3 0F 8C 73 01 00 00 8D 04 B5 00 00 00 00 89 FA 03 41 0C 89 41 10 89 F0 EB 2E 8B 4A 58 8B 59 04 8B 51 08 39 59 10 0F 43 59 10 29 D3 C1 FB 02 F7 C5 01 00 00 00 75 49 83 E5 02 B8 FF FF FF FF BA FF FF FF FF 85 ED 75 94 8B 5C 24 1C 8B 74 24 20 8B 7C 24 24 8B 6C 24 28 83 C4 2C C3 8D B6 00 00 00 00 8B 44 24 30 BD 01 00 00 00 8B 48 58 8B 59 04 8B 51 08 39 59 10 0F 43 59 10 29 D3 C1 FB 02 83 7C 24 3C 01 0F 84 87 00 00 00 83 7C 24 3C 02 75 09 89 DA C1 FA 1F 01 DE 11 D7 85 FF 0F 88 0D 01 00 00 39 F3 0F 8C 97 00 00 00 8B 41 08 8D 14 B5 00 00 00 00 83 E5 02 01 C2 8D 04 98 89 11 89 FA 89 41 04 89 F0 E9 79 FF FF FF 8D B4 26 00 00 00 00 A8 08 74 1C 8B 44 24 30 8B 50 58 8B 02 2B 42 08 C1 F8 02 89 C2 C1 FA 1F E9 59 FF FF FF 8D 76 00 8B 44 24 30 8B 50 58 8B 42 10 2B 42 0C C1 F8 02 89 C2 C1 FA 1F E9 3C FF FF FF 8D B6 00 00 00 00 8B 01 29 D0 C1 F8 02 89 C2 C1 FA 1F 01 C6 11 D7 E9 74 FF FF FF 8D 76 00 8B 41 10 2B 41 0C C1 F8 02 89 C2 C1 FA 1F 01 C6 11 D7 E9 B6 FE FF FF 90 8B 54 24 30 8B 42 20 2B 42 1C 39 F0 0F 8D 57 FF FF FF 8B 44 24 30 89 F2 89 F9 C7 04 24 01 00 00 00 E8 42 FC FF FF 85 C0 75 44 8B 44 24 30 8B 48 58 E9 33 FF FF FF 66 90 8B 54 24 30 8B 42 20 2B 42 1C 39 F0 0F 8D 7B FE FF FF 8B 44 24 30 89 F2 89 F9 C7 04 24 00 00 00 00 E8 0A FC FF FF 85 C0 75 0C 8B 44 24 30 8B 48 58 E9 57 FE FF FF B8 FF FF FF FF BA FF FF FF FF E9 89 FE FF FF }
	condition:
		$1
}

rule file_159_6_0 {
	meta:
		name = "_IO_wstr_init_static"
		size = 163
		refs = "002b __wcslen 0046 _IO_wsetb"
	strings:
		$1 = { 83 EC 2C 8B 44 24 38 89 5C 24 1C 8B 5C 24 34 89 74 24 20 8B 74 24 30 89 7C 24 24 8B 7C 24 3C 85 C0 89 6C 24 28 75 59 89 1C 24 E8 ?? ?? ?? ?? 8D 2C 83 C7 44 24 0C 00 00 00 00 89 6C 24 08 89 5C 24 04 89 34 24 E8 ?? ?? ?? ?? 8B 46 58 85 FF 89 58 0C 89 58 08 89 18 74 3F 89 78 10 89 68 14 89 78 04 C7 86 98 00 00 00 00 00 00 00 8B 5C 24 1C 8B 74 24 20 8B 7C 24 24 8B 6C 24 28 83 C4 2C C3 8D 2C 83 39 EB 72 AB 89 DD F7 D5 83 E5 FC 01 DD EB A0 8D B6 00 00 00 00 89 58 10 89 58 14 89 68 04 EB BF }
	condition:
		$1
}

rule file_159_7_0 {
	meta:
		name = "_IO_wstr_count"
		size = 24
	strings:
		$1 = { 8B 44 24 04 8B 50 58 8B 42 04 39 42 10 0F 43 42 10 2B 42 08 C1 F8 02 C3 }
	condition:
		$1
}

rule file_160_2_0 {
	meta:
		name = "_IO_ungetc"
		size = 183
		refs = "0065 _IO_sputbackc"
	strings:
		$1 = { 83 EC 1C 89 74 24 14 8B 74 24 20 89 5C 24 10 8B 5C 24 24 89 7C 24 18 83 FE FF 0F 84 90 00 00 00 8B 03 25 00 80 00 00 75 2E 8B 53 48 65 8B 3D 08 00 00 00 3B 7A 08 74 1B B9 01 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 0A 75 6A 8B 53 48 89 7A 08 83 42 04 01 81 E6 FF 00 00 00 89 74 24 04 89 1C 24 E8 ?? ?? ?? ?? F7 03 00 80 00 00 89 C2 75 25 8B 4B 48 83 69 04 01 75 1C C7 41 08 00 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 83 29 01 75 2D 90 8D 74 26 00 89 D0 8B 5C 24 10 8B 74 24 14 8B 7C 24 18 83 C4 1C C3 8D B6 00 00 00 00 BA FF FF FF FF EB E1 }
	condition:
		$1
}

rule file_161_0_0 {
	meta:
		name = "__dladdr1"
		size = 88
		refs = "0023 _dl_addr"
	strings:
		$1 = { 83 EC 1C 8B 44 24 2C 83 F8 01 74 24 83 F8 02 C7 04 24 00 00 00 00 74 28 8B 54 24 24 31 C9 8B 44 24 20 E8 ?? ?? ?? ?? 83 EC 04 83 C4 1C C3 66 90 8B 44 24 28 89 04 24 EB DF 8D B4 26 00 00 00 00 8B 4C 24 28 8B 54 24 24 8B 44 24 20 E8 ?? ?? ?? ?? 83 EC 04 83 C4 1C C3 }
	condition:
		$1
}

rule file_162_0_0 {
	meta:
		name = "__fxprintf"
		size = 191
		refs = "0014 stderr 0026 strlen 0071 __vfwprintf 008f _IO_vfprintf 00bb __assert_fail"
	strings:
		$1 = { 55 89 E5 57 56 53 83 EC 2C 8B 75 08 8B 5D 0C 85 F6 0F 44 35 ?? ?? ?? ?? 8B 46 68 85 C0 7E 61 89 65 E4 89 1C 24 E8 ?? ?? ?? ?? 83 C0 01 8D 14 85 12 00 00 00 83 E2 F0 29 D4 85 C0 8D 7C 24 10 74 21 0F BE 0B 84 C9 78 53 31 D2 EB 0C 8D 74 26 00 0F BE 0C 13 84 C9 78 43 89 0C 97 83 C2 01 39 D0 75 EE 8D 45 10 89 7C 24 04 89 34 24 89 44 24 08 E8 ?? ?? ?? ?? 8B 65 E4 8D 65 F4 5B 5E 5F 5D C3 8D 45 10 89 5C 24 04 89 34 24 89 44 24 08 E8 ?? ?? ?? ?? 8D 65 F4 5B 5E 5F 5D C3 C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 2E 00 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_163_0_0 {
	meta:
		name = "__vdprintf_chk"
		size = 216
		refs = "001b _IO_wfile_jumps 003b _IO_no_init 0049 _IO_file_jumps 004e _IO_file_init 0061 _IO_file_attach 00a3 _IO_vfprintf 00d2 _IO_un_link"
	strings:
		$1 = { 56 53 81 EC 84 01 00 00 8D 84 24 C4 00 00 00 8D 5C 24 2C 89 44 24 0C C7 44 24 10 ?? ?? ?? ?? C7 44 24 08 00 00 00 00 C7 44 24 04 00 80 00 00 89 1C 24 C7 44 24 74 00 00 00 00 E8 ?? ?? ?? ?? 89 1C 24 C7 84 24 C0 00 00 00 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 84 24 90 01 00 00 89 1C 24 89 44 24 04 E8 ?? ?? ?? ?? 85 C0 74 60 8B 44 24 2C 25 F3 EF FF FF 83 C8 44 89 44 24 2C 8B 84 24 94 01 00 00 85 C0 7E 05 83 4C 24 68 04 8B 84 24 9C 01 00 00 89 1C 24 89 44 24 08 8B 84 24 98 01 00 00 89 44 24 04 E8 ?? ?? ?? ?? C7 44 24 04 00 00 00 00 89 1C 24 89 C6 8B 84 24 C0 00 00 00 FF 50 08 81 C4 84 01 00 00 89 F0 5B 5E C3 89 1C 24 BE FF FF FF FF E8 ?? ?? ?? ?? EB E6 }
	condition:
		$1
}

rule file_164_0_0 {
	meta:
		name = "__tcgetattr"
		size = 189
		refs = "001e _dl_sysinfo 00af __libc_errno"
	strings:
		$1 = { 57 B9 01 54 00 00 56 53 83 EC 30 8B 74 24 44 8D 54 24 0C 8B 5C 24 40 B8 36 00 00 00 FF 15 ?? ?? ?? ?? 3D 00 F0 FF FF 0F 87 80 00 00 00 85 C0 75 75 8B 54 24 0C 8B 4C 24 18 89 16 8B 54 24 10 89 4E 0C 0F B6 4C 24 1C 89 56 04 8B 54 24 14 88 4E 10 89 56 08 81 E2 0F 10 00 00 89 56 34 89 56 38 8B 54 24 1D 89 56 11 8B 54 24 21 89 56 15 8B 54 24 25 89 56 19 8B 54 24 29 89 56 1D 0F B7 54 24 2D 66 89 56 21 0F B6 54 24 2F C7 46 24 00 00 00 00 C7 46 28 00 00 00 00 C7 46 2C 00 00 00 00 88 56 23 C6 46 30 00 83 C4 30 5B 5E 5F C3 8B 15 ?? ?? ?? ?? F7 D8 65 89 02 83 C8 FF EB E9 }
	condition:
		$1
}

rule file_165_0_0 {
	meta:
		name = "ptrace"
		size = 113
		refs = "002d _dl_sysinfo 0046 __libc_errno"
	strings:
		$1 = { 83 EC 18 89 5C 24 10 8B 5C 24 1C 89 74 24 14 8B 54 24 24 8D 74 24 0C 8B 4C 24 20 8D 43 FF 83 F8 02 0F 47 74 24 28 B8 1A 00 00 00 FF 15 ?? ?? ?? ?? 3D 00 F0 FF FF 77 29 85 C0 78 19 85 DB 74 15 83 FB 03 77 10 A1 ?? ?? ?? ?? 65 C7 00 00 00 00 00 8B 44 24 0C 8B 5C 24 10 8B 74 24 14 83 C4 18 C3 8B 15 ?? ?? ?? ?? F7 D8 65 89 02 83 C8 FF EB E4 }
	condition:
		$1
}

rule file_166_0_0 {
	meta:
		name = "__inet_aton"
		size = 270
		refs = "0009 __libc_errno 005a strtoul 00fe __libc_tsd_CTYPE_B"
	strings:
		$1 = { 55 57 56 53 83 EC 3C 8B 15 ?? ?? ?? ?? 8B 5C 24 50 C7 44 24 28 00 00 00 00 65 8B 12 89 54 24 1C 8B 15 ?? ?? ?? ?? 65 C7 02 00 00 00 00 0F BE 03 83 E8 30 83 F8 09 77 58 8D 54 24 28 89 54 24 18 89 D5 8D 74 24 2C 8D 7C 24 2B C7 44 24 08 00 00 00 00 89 74 24 04 89 1C 24 E8 ?? ?? ?? ?? 83 F8 FF 74 45 8B 54 24 2C 0F B6 0A 80 F9 2E 75 49 39 FD 74 1D 3D FF 00 00 00 77 16 88 45 00 0F BE 42 01 83 C5 01 8D 5A 01 83 E8 30 83 F8 09 76 BB 90 8B 44 24 1C 8B 15 ?? ?? ?? ?? 65 89 02 31 C0 83 C4 3C 5B 5E 5F 5D C3 90 8B 15 ?? ?? ?? ?? 65 83 3A 22 75 AF EB DA 66 90 80 F9 00 75 3A 39 DA 90 74 CE 2B 6C 24 18 3B 04 AD ?? ?? ?? ?? 77 C1 8B 54 24 54 85 D2 74 0C 8B 54 24 54 0F C8 0B 44 24 28 89 02 8B 44 24 1C 8B 15 ?? ?? ?? ?? 65 89 02 B8 01 00 00 00 EB A8 7C 97 0F BE F1 8B 0D ?? ?? ?? ?? 65 8B 09 F6 44 71 01 20 74 84 EB AF }
	condition:
		$1
}

rule file_166_1_0 {
	meta:
		name = "inet_addr"
		size = 41
		refs = "0013 __inet_aton"
	strings:
		$1 = { 83 EC 2C 8D 44 24 1C 89 44 24 04 8B 44 24 30 89 04 24 E8 ?? ?? ?? ?? BA FF FF FF FF 85 C0 0F 45 54 24 1C 83 C4 2C 89 D0 C3 }
	condition:
		$1
}

rule file_167_1_0 {
	meta:
		name = "svcunix_getargs"
		size = 28
		altNames = "svctcp_getargs"
	strings:
		$1 = { 8B 54 24 0C 8B 44 24 08 89 54 24 08 8B 54 24 04 8B 52 2C 83 C2 08 89 54 24 04 FF E0 }
	condition:
		$1
}

rule file_167_2_0 {
	meta:
		name = "svcunix_freeargs"
		size = 35
		altNames = "svctcp_freeargs"
	strings:
		$1 = { 8B 44 24 04 8B 4C 24 0C 8B 54 24 08 8B 40 2C C7 40 08 02 00 00 00 83 C0 08 89 4C 24 08 89 44 24 04 FF E2 }
	condition:
		$1
}

rule file_167_3_0 {
	meta:
		name = "makefd_xprt"
		size = 264
		refs = "0023 malloc 006c xdrrec_create 009a xprt_register 00cb _libc_intl_domainname 00d0 __dcgettext 00f0 __fxprintf 00fa free"
	strings:
		$1 = { 83 EC 4C C7 04 24 34 01 00 00 89 4C 24 2C 89 5C 24 3C 89 74 24 40 89 7C 24 44 89 C7 89 6C 24 48 89 D5 E8 ?? ?? ?? ?? C7 04 24 B0 01 00 00 89 C3 E8 ?? ?? ?? ?? 8B 4C 24 2C 85 C0 89 C6 74 79 85 DB 74 75 C7 00 02 00 00 00 83 C0 08 C7 44 24 14 ?? ?? ?? ?? C7 44 24 10 ?? ?? ?? ?? 89 5C 24 0C 89 4C 24 08 89 6C 24 04 89 04 24 E8 ?? ?? ?? ?? 89 73 2C 83 C6 20 C7 43 30 00 00 00 00 89 73 24 C7 43 0C 00 00 00 00 C7 43 08 ?? ?? ?? ?? 66 C7 43 04 00 00 89 3B 89 1C 24 E8 ?? ?? ?? ?? 89 D8 8B 74 24 40 8B 5C 24 3C 8B 7C 24 44 8B 6C 24 48 83 C4 4C C3 8D 74 26 00 C7 44 24 08 05 00 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 44 24 08 ?? ?? ?? ?? C7 44 24 04 ?? ?? ?? ?? C7 04 24 00 00 00 00 89 44 24 0C E8 ?? ?? ?? ?? 89 1C 24 31 DB E8 ?? ?? ?? ?? 89 34 24 E8 ?? ?? ?? ?? EB 96 }
	condition:
		$1
}

rule file_167_4_0 {
	meta:
		name = "writeunix"
		size = 274
		refs = "0022 __getpid 002b __geteuid 0032 __getegid 00c0 __sendmsg 00c9 __libc_errno"
	strings:
		$1 = { 55 57 56 53 83 EC 5C 8B 5C 24 78 85 DB 0F 8E D5 00 00 00 8B 7C 24 78 8D 74 24 34 8B 54 24 70 8B 1A E8 ?? ?? ?? ?? 89 44 24 1C E8 ?? ?? ?? ?? 89 C5 E8 ?? ?? ?? ?? 8B 4C 24 1C 8B 54 24 74 89 2D ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 01 00 00 00 89 0D ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 02 00 00 00 A3 ?? ?? ?? ?? 8D 44 24 2C C7 05 ?? ?? ?? ?? 18 00 00 00 89 54 24 2C 89 7C 24 30 89 44 24 3C C7 44 24 40 01 00 00 00 C7 44 24 34 00 00 00 00 C7 44 24 38 00 00 00 00 C7 44 24 44 ?? ?? ?? ?? C7 44 24 48 18 00 00 00 C7 44 24 4C 00 00 00 00 8D 76 00 C7 44 24 08 00 00 00 00 89 74 24 04 89 1C 24 E8 ?? ?? ?? ?? 85 C0 79 30 A1 ?? ?? ?? ?? 65 83 38 04 74 DD 8B 54 24 70 C7 44 24 78 FF FF FF FF 8B 42 2C C7 00 00 00 00 00 8B 44 24 78 83 C4 5C 5B 5E 5F 5D C3 8D 74 26 00 29 C7 01 44 24 74 85 FF 0F 8F 15 FF FF FF 8B 44 24 78 83 C4 5C 5B 5E 5F 5D C3 }
	condition:
		$1
}

rule file_167_5_0 {
	meta:
		name = "readunix"
		size = 317
		refs = "002f __poll 00cd __setsockopt 00e8 __recvmsg 00f1 __libc_errno"
	strings:
		$1 = { 57 56 53 83 EC 50 8B 74 24 60 8D 7C 24 24 8B 1E C7 44 24 08 B8 88 00 00 C7 44 24 04 01 00 00 00 89 3C 24 89 5C 24 24 66 C7 44 24 28 01 00 E8 ?? ?? ?? ?? 83 F8 FF 0F 84 DC 00 00 00 85 C0 0F 84 BC 00 00 00 0F B7 44 24 2A A8 38 0F 85 AF 00 00 00 A8 01 74 BB 8B 44 24 64 8D 7C 24 34 C7 44 24 10 04 00 00 00 C7 44 24 08 10 00 00 00 C7 44 24 04 01 00 00 00 89 44 24 2C 8B 44 24 68 89 1C 24 C7 44 24 40 01 00 00 00 C7 44 24 34 00 00 00 00 89 44 24 30 8D 44 24 2C 89 44 24 3C 8D 44 24 20 89 44 24 0C C7 44 24 38 00 00 00 00 C7 44 24 44 ?? ?? ?? ?? C7 44 24 48 1C 00 00 00 C7 44 24 4C 00 00 00 00 C7 44 24 20 01 00 00 00 E8 ?? ?? ?? ?? 85 C0 75 2B 8D 76 00 C7 44 24 08 00 00 00 00 89 7C 24 04 89 1C 24 E8 ?? ?? ?? ?? 85 C0 79 40 A1 ?? ?? ?? ?? 65 83 38 04 74 DD 90 8D 74 26 00 8B 46 2C C7 00 00 00 00 00 B8 FF FF FF FF 83 C4 50 5B 5E 5F C3 8D 76 00 A1 ?? ?? ?? ?? 65 83 38 04 75 DD 0F B7 44 24 2A E9 24 FF FF FF 8D 76 00 F6 44 24 4C 08 75 C9 85 C0 74 C5 EB D1 }
	condition:
		$1
}

rule file_167_6_0 {
	meta:
		name = "svcunix_destroy"
		size = 104
		refs = "0016 xprt_unregister 0020 __close 0041 free"
		altNames = "svctcp_destroy"
	strings:
		$1 = { 83 EC 1C 89 5C 24 14 8B 5C 24 20 89 74 24 18 8B 73 2C 89 1C 24 E8 ?? ?? ?? ?? 8B 03 89 04 24 E8 ?? ?? ?? ?? 66 83 7B 04 00 75 35 8B 46 0C 8B 40 1C 85 C0 74 08 8D 56 08 89 14 24 FF D0 89 34 24 E8 ?? ?? ?? ?? 8B 74 24 18 89 5C 24 20 8B 5C 24 14 83 C4 1C E9 ?? ?? ?? ?? 8D B4 26 00 00 00 00 66 C7 43 04 00 00 EB D5 }
	condition:
		$1
}

rule file_167_7_0 {
	meta:
		name = "svcunix_reply"
		size = 81
		refs = "002d xdr_replymsg 003f xdrrec_endofrecord"
		altNames = "svctcp_reply"
	strings:
		$1 = { 83 EC 1C 8B 44 24 20 89 5C 24 14 8B 54 24 24 89 74 24 18 8B 40 2C C7 40 08 00 00 00 00 8D 58 08 8B 40 04 89 02 89 54 24 04 89 1C 24 E8 ?? ?? ?? ?? 89 1C 24 C7 44 24 04 01 00 00 00 89 C6 E8 ?? ?? ?? ?? 89 F0 8B 5C 24 14 8B 74 24 18 83 C4 1C C3 }
	condition:
		$1
}

rule file_167_8_0 {
	meta:
		name = "svcunix_stat"
		size = 41
		refs = "0019 xdrrec_eof"
		altNames = "svctcp_stat"
	strings:
		$1 = { 83 EC 1C 8B 44 24 20 8B 50 2C 31 C0 8B 0A 85 C9 74 13 83 C2 08 89 14 24 E8 ?? ?? ?? ?? 83 F8 01 19 C0 83 C0 02 83 C4 1C C3 }
	condition:
		$1
}

rule file_167_9_0 {
	meta:
		name = "svcunix_recv"
		size = 135
		refs = "0028 xdrrec_skiprecord 0034 xdr_callmsg"
	strings:
		$1 = { 83 EC 1C 8B 44 24 20 89 5C 24 10 89 74 24 14 8B 74 24 24 89 7C 24 18 8B 58 2C 8D 7B 08 C7 43 08 01 00 00 00 89 3C 24 E8 ?? ?? ?? ?? 89 74 24 04 89 3C 24 E8 ?? ?? ?? ?? 85 C0 75 1C C7 03 00 00 00 00 31 C0 8B 5C 24 10 8B 74 24 14 8B 7C 24 18 83 C4 1C C3 8D 74 26 00 8B 06 89 43 04 B8 01 00 00 00 C7 46 24 01 00 00 00 C7 46 28 ?? ?? ?? ?? C7 46 2C 1C 00 00 00 8B 5C 24 10 8B 74 24 14 8B 7C 24 18 83 C4 1C C3 }
	condition:
		$1
}

rule file_167_11_0 {
	meta:
		name = "rendezvous_request"
		size = 171
		refs = "0021 __libc_errno 0042 accept"
	strings:
		$1 = { 55 57 56 53 81 EC AC 00 00 00 8B AC 24 C0 00 00 00 8D 74 24 32 8D 5C 24 1C 8B 7D 2C EB 0D 66 90 A1 ?? ?? ?? ?? 65 83 38 04 75 73 89 5C 24 08 89 74 24 04 8B 45 00 C7 44 24 1C 6E 00 00 00 89 04 24 E8 ?? ?? ?? ?? 85 C0 78 D6 8B 17 8B 4F 04 C7 44 24 20 00 00 00 00 C7 44 24 24 00 00 00 00 C7 44 24 28 00 00 00 00 C7 44 24 2C 00 00 00 00 66 C7 44 24 20 01 00 E8 75 FA FF FF 8B 54 24 20 89 50 10 8B 54 24 24 89 50 14 8B 54 24 28 89 50 18 8B 54 24 2C 89 50 1C 8B 54 24 1C 89 50 0C 81 C4 AC 00 00 00 31 C0 5B 5E 5F 5D C3 }
	condition:
		$1
}

rule file_167_12_0 {
	meta:
		name = "svcunix_create"
		size = 622
		refs = "005f strlen 0082 memcpy 0096 __bind 00aa __getsockname 00c5 _libc_intl_domainname 00ca __dcgettext 00d2 perror 00fc __listen 010c malloc 015d _null_auth 0178 xprt_register 01a4 __close 01c8 __socket 0228 __fxprintf 0230 free"
	strings:
		$1 = { 55 31 ED 57 56 53 81 EC 9C 00 00 00 8B 9C 24 B0 00 00 00 C7 44 24 1C 10 00 00 00 83 FB FF 0F 84 8C 01 00 00 8D 74 24 22 BA 6E 00 00 00 F7 C6 02 00 00 00 89 F7 0F 85 A5 01 00 00 89 D1 31 C0 C1 E9 02 83 E2 02 F3 AB 0F 85 43 01 00 00 8B 84 24 BC 00 00 00 66 C7 44 24 22 01 00 89 04 24 E8 ?? ?? ?? ?? 89 C7 83 C0 01 89 44 24 08 8B 84 24 BC 00 00 00 83 C7 03 89 44 24 04 8D 44 24 24 89 04 24 E8 ?? ?? ?? ?? 89 7C 24 08 89 74 24 04 89 1C 24 89 7C 24 1C E8 ?? ?? ?? ?? 8D 44 24 1C 89 44 24 08 89 74 24 04 89 1C 24 E8 ?? ?? ?? ?? 85 C0 74 3E C7 44 24 08 05 00 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 85 ED 0F 85 C2 00 00 00 31 F6 81 C4 9C 00 00 00 89 F0 5B 5E 5F 5D C3 8D 76 00 C7 44 24 04 80 00 00 00 89 1C 24 E8 ?? ?? ?? ?? 85 C0 75 AE C7 04 24 08 00 00 00 E8 ?? ?? ?? ?? C7 04 24 34 01 00 00 89 C7 E8 ?? ?? ?? ?? 85 C0 89 C6 0F 84 C8 00 00 00 85 FF 0F 84 C0 00 00 00 8B 84 24 B4 00 00 00 89 7E 2C 89 1E C7 46 30 00 00 00 00 89 07 8B 84 24 B8 00 00 00 C7 46 08 ?? ?? ?? ?? 66 C7 46 04 FF FF 89 47 04 A1 ?? ?? ?? ?? 89 46 20 A1 ?? ?? ?? ?? 89 46 24 A1 ?? ?? ?? ?? 89 46 28 89 34 24 E8 ?? ?? ?? ?? 81 C4 9C 00 00 00 89 F0 5B 5E 5F 5D C3 8D B4 26 00 00 00 00 66 C7 07 00 00 E9 B3 FE FF FF 8D B6 00 00 00 00 89 1C 24 E8 ?? ?? ?? ?? E9 31 FF FF FF 8D 76 00 C7 44 24 08 00 00 00 00 C7 44 24 04 01 00 00 00 C7 04 24 01 00 00 00 E8 ?? ?? ?? ?? 85 C0 89 C3 78 71 BD 01 00 00 00 E9 48 FE FF FF 8D 74 26 00 8D 7C 24 24 B2 6C E9 50 FE FF FF 90 8D 74 26 00 C7 44 24 08 05 00 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 44 24 08 ?? ?? ?? ?? C7 44 24 04 ?? ?? ?? ?? C7 04 24 00 00 00 00 89 44 24 0C E8 ?? ?? ?? ?? 89 3C 24 E8 ?? ?? ?? ?? 89 34 24 31 F6 E8 ?? ?? ?? ?? E9 9D FE FF FF C7 44 24 08 05 00 00 00 31 F6 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? E9 72 FE FF FF }
	condition:
		$1
}

rule file_167_13_0 {
	meta:
		name = "svcunixfd_create"
		size = 17
	strings:
		$1 = { 8B 4C 24 0C 8B 54 24 08 8B 44 24 04 E9 BF F7 FF FF }
	condition:
		$1
}

rule file_168_0_0 {
	meta:
		name = "strerror"
		size = 164
		refs = "0027 __strerror_r 0041 __libc_errno 007b malloc 0099 _libc_intl_domainname 009e __dcgettext"
	strings:
		$1 = { 83 EC 1C 89 74 24 14 8B 74 24 20 C7 44 24 08 00 00 00 00 C7 44 24 04 00 00 00 00 89 5C 24 10 89 34 24 89 7C 24 18 E8 ?? ?? ?? ?? 85 C0 74 10 8B 5C 24 10 8B 74 24 14 8B 7C 24 18 83 C4 1C C3 8B 3D ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 65 8B 1F 74 22 A1 ?? ?? ?? ?? 65 89 1F 85 C0 74 29 C7 44 24 08 00 04 00 00 89 44 24 04 89 34 24 E8 ?? ?? ?? ?? EB BC C7 04 24 00 04 00 00 E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? EB CB C7 44 24 08 05 00 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 8B }
	condition:
		$1
}

rule file_171_0_0 {
	meta:
		name = "__real_chown"
		size = 49
		refs = "0014 _dl_sysinfo 0023 __libc_errno"
	strings:
		$1 = { 53 8B 54 24 10 8B 4C 24 0C 8B 5C 24 08 B8 D4 00 00 00 FF 15 ?? ?? ?? ?? 3D 00 F0 FF FF 77 02 5B C3 8B 15 ?? ?? ?? ?? F7 D8 65 89 02 83 C8 FF 5B C3 }
	condition:
		$1
}

rule file_172_3_0 {
	meta:
		name = "___fprintf_chk"
		size = 247
		refs = "006e vfprintf 00f3 _Unwind_Resume"
	strings:
		$1 = { 83 EC 1C 89 5C 24 10 8B 5C 24 20 89 74 24 14 8B 74 24 24 89 7C 24 18 8B 03 25 00 80 00 00 75 32 8B 53 48 65 8B 3D 08 00 00 00 3B 7A 08 74 1F B9 01 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 0A 0F 85 AF 00 00 00 8B 53 48 89 7A 08 83 42 04 01 85 F6 7E 04 83 4B 3C 04 8D 44 24 2C 89 44 24 08 8B 44 24 28 89 1C 24 89 44 24 04 E8 ?? ?? ?? ?? 85 F6 89 C1 8B 53 3C 7E 06 83 E2 FB 89 53 3C 83 E2 EB F7 03 00 80 00 00 89 53 3C 75 20 8B 53 48 83 6A 04 01 75 17 C7 42 08 00 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 83 2A 01 75 54 89 C8 8B 5C 24 10 8B 74 24 14 8B 7C 24 18 83 C4 1C C3 83 63 3C EB 89 C6 F7 03 00 80 00 00 75 20 8B 53 48 83 6A 04 01 75 17 C7 42 08 00 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 83 2A 01 75 1D 89 34 24 E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_328_3_0 {
	meta:
		name = "__fwprintf_chk"
		size = 247
		refs = "006e _IO_vfwprintf 00f3 _Unwind_Resume"
	strings:
		$1 = { 83 EC 1C 89 5C 24 10 8B 5C 24 20 89 74 24 14 8B 74 24 24 89 7C 24 18 8B 03 25 00 80 00 00 75 32 8B 53 48 65 8B 3D 08 00 00 00 3B 7A 08 74 1F B9 01 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 0A 0F 85 AF 00 00 00 8B 53 48 89 7A 08 83 42 04 01 85 F6 7E 04 83 4B 3C 04 8D 44 24 2C 89 44 24 08 8B 44 24 28 89 1C 24 89 44 24 04 E8 ?? ?? ?? ?? 85 F6 89 C1 8B 53 3C 7E 06 83 E2 FB 89 53 3C 83 E2 EB F7 03 00 80 00 00 89 53 3C 75 20 8B 53 48 83 6A 04 01 75 17 C7 42 08 00 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 83 2A 01 75 54 89 C8 8B 5C 24 10 8B 74 24 14 8B 7C 24 18 83 C4 1C C3 83 63 3C EB 89 C6 F7 03 00 80 00 00 75 20 8B 53 48 83 6A 04 01 75 17 C7 42 08 00 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 83 2A 01 75 1D 89 34 24 E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_173_0_0 {
	meta:
		name = "gethostid"
		size = 335
		refs = "0024 __open_nocancel 0041 __read_nocancel 004e _dl_sysinfo 0069 __gethostname 00a1 __libc_errno 00fa __gethostbyname_r 0140 memcpy"
	strings:
		$1 = { 55 89 E5 57 56 53 81 EC AC 00 00 00 C7 44 24 08 00 00 00 00 C7 44 24 04 00 80 00 00 C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 78 2E 89 C3 8D 45 84 C7 44 24 08 04 00 00 00 89 44 24 04 89 1C 24 E8 ?? ?? ?? ?? 89 C2 B8 06 00 00 00 FF 15 ?? ?? ?? ?? 83 FA 04 8B 45 84 74 1F 8D 45 A7 C7 44 24 04 40 00 00 00 89 04 24 E8 ?? ?? ?? ?? 85 C0 78 06 80 7D A7 00 75 11 31 C0 8D 65 F4 5B 5E 5F 5D C3 8D B4 26 00 00 00 00 81 EC 10 04 00 00 BB 00 04 00 00 8D 7C 24 27 83 E7 F0 EB 3A 8D 74 26 00 A1 ?? ?? ?? ?? 65 83 38 22 75 CC 8D 4C 1B 0F 31 D2 83 E1 F0 BE 10 00 00 00 8D 41 1E 01 CB F7 F6 C1 E0 04 29 C4 8D 44 24 27 83 E0 F0 8D 14 08 39 D7 89 C7 0F 45 D9 8D 45 8C 89 44 24 14 8D 55 80 8D 45 A7 8D 75 90 89 54 24 10 89 5C 24 0C 89 7C 24 08 89 74 24 04 89 04 24 E8 ?? ?? ?? ?? 85 C0 75 07 8B 45 80 85 C0 75 0F 83 7D 8C FF 74 91 90 E9 62 FF FF FF 8D 76 00 83 78 0C 04 BA 04 00 00 00 0F 4E 50 0C 8B 40 10 8D 4D 88 C7 45 88 00 00 00 00 8B 00 89 54 24 08 89 0C 24 89 44 24 04 E8 ?? ?? ?? ?? 8B 45 88 C1 C0 10 E9 2A FF FF FF }
	condition:
		$1
}

rule file_174_0_0 {
	meta:
		name = "__atomic_writev_replacement"
		size = 368
		refs = "00b5 mempcpy 00d5 __write 00e3 free 00f9 __libc_errno 011c __libc_alloca_cutoff 012c malloc 0150 _Unwind_Resume"
	strings:
		$1 = { 55 89 E5 57 56 89 D6 53 83 EC 3C 85 C9 89 45 DC 89 4D E4 0F 8E F8 00 00 00 8B 52 04 81 FA FF FF FF 7F 0F 87 D0 00 00 00 31 C0 31 DB BF FF FF FF 7F EB 15 90 8D 74 26 00 8B 54 C6 04 89 F9 29 D9 39 D1 0F 82 B0 00 00 00 01 D3 83 C0 01 3B 45 E4 75 E6 81 FB 00 10 00 00 0F 87 BA 00 00 00 8D 43 1E 83 E0 F0 29 C4 8D 44 24 1B 83 E0 F0 89 45 E0 8B 45 E4 C7 45 D8 00 00 00 00 85 C0 7E 45 31 C9 89 DF 8B 45 E0 89 5D D4 89 CB EB 0F 8D 74 26 00 83 C3 01 83 C6 08 3B 5D E4 74 25 8B 0E 89 FA 39 7E 04 0F 46 56 04 89 04 24 89 4C 24 04 89 54 24 08 89 55 D0 E8 ?? ?? ?? ?? 8B 55 D0 29 D7 75 D0 8B 5D D4 8B 45 E0 89 5C 24 08 89 44 24 04 8B 45 DC 89 04 24 E8 ?? ?? ?? ?? 8B 55 D8 89 45 D0 89 14 24 E8 ?? ?? ?? ?? 8B 45 D0 8D 65 F4 5B 5E 5F 5D C3 8D B6 00 00 00 00 A1 ?? ?? ?? ?? 65 C7 00 16 00 00 00 8D 65 F4 B8 FF FF FF FF 5B 5E 5F 5D C3 31 DB E9 46 FF FF FF 89 1C 24 E8 ?? ?? ?? ?? 85 C0 0F 85 36 FF FF FF 89 1C 24 E8 ?? ?? ?? ?? 85 C0 89 45 E0 74 1D 89 45 D8 E9 3F FF FF FF 89 C3 8B 45 D8 89 04 24 E8 ?? ?? ?? ?? 89 1C 24 E8 ?? ?? ?? ?? C7 45 D8 00 00 00 00 B8 FF FF FF FF E9 74 FF FF FF 89 C3 C7 45 D8 00 00 00 00 EB D1 }
	condition:
		$1
}

rule file_174_1_0 {
	meta:
		name = "__libc_writev"
		size = 231
		refs = "0032 _dl_sysinfo 0061 __libc_errno 00a3 __libc_enable_asynccancel 00ca __libc_disable_asynccancel"
	strings:
		$1 = { 83 EC 2C 89 5C 24 1C 8B 54 24 38 89 74 24 20 8B 5C 24 30 89 7C 24 24 8B 74 24 34 89 6C 24 28 65 A1 0C 00 00 00 85 C0 75 75 89 F1 B8 92 00 00 00 FF 15 ?? ?? ?? ?? 3D 00 F0 FF FF 77 51 89 C5 85 ED 78 1D 89 E8 8B 5C 24 1C 8B 74 24 20 8B 7C 24 24 8B 6C 24 28 83 C4 2C C3 8D B4 26 00 00 00 00 A1 ?? ?? ?? ?? 65 83 38 16 75 D8 83 FA 08 7E D3 89 D1 89 D8 8B 7C 24 24 89 F2 8B 5C 24 1C 8B 74 24 20 8B 6C 24 28 83 C4 2C E9 02 FE FF FF 8B 0D ?? ?? ?? ?? F7 D8 65 89 01 83 C8 FF EB 9F 89 54 24 0C E8 ?? ?? ?? ?? 8B 54 24 0C 89 F1 89 C7 B8 92 00 00 00 FF 15 ?? ?? ?? ?? 3D 00 F0 FF FF 77 16 89 C5 89 F8 89 54 24 0C E8 ?? ?? ?? ?? 8B 54 24 0C E9 68 FF FF FF 8B 0D ?? ?? ?? ?? F7 D8 65 89 01 83 C8 FF EB DA }
	condition:
		$1
}

rule file_175_0_0 {
	meta:
		name = "fexecve"
		size = 229
		refs = "0066 __snprintf 0076 __execve 007c __libc_errno 009b __xstat"
	strings:
		$1 = { 81 EC 9C 00 00 00 89 9C 24 90 00 00 00 8B 9C 24 A4 00 00 00 89 B4 24 94 00 00 00 8B B4 24 A8 00 00 00 89 BC 24 98 00 00 00 85 DB 0F 84 87 00 00 00 8B 84 24 A0 00 00 00 C1 E8 1F 84 C0 75 79 85 F6 74 75 8B 84 24 A0 00 00 00 8D 7C 24 1D C7 44 24 08 ?? ?? ?? ?? C7 44 24 04 1B 00 00 00 89 3C 24 89 44 24 0C E8 ?? ?? ?? ?? 89 74 24 08 89 5C 24 04 89 3C 24 E8 ?? ?? ?? ?? 8B 1D ?? ?? ?? ?? 8D 44 24 38 65 8B 33 89 44 24 08 C7 44 24 04 ?? ?? ?? ?? C7 04 24 03 00 00 00 E8 ?? ?? ?? ?? 85 C0 74 0C 65 83 3B 02 B8 26 00 00 00 0F 44 F0 65 89 33 EB 10 8D 74 26 00 A1 ?? ?? ?? ?? 65 C7 00 16 00 00 00 B8 FF FF FF FF 8B 9C 24 90 00 00 00 8B B4 24 94 00 00 00 8B BC 24 98 00 00 00 81 C4 9C 00 00 00 C3 }
	condition:
		$1
}

rule file_176_0_0 {
	meta:
		name = "__getdtablesize"
		size = 41
		refs = "0013 __getrlimit"
	strings:
		$1 = { 83 EC 2C 8D 44 24 18 89 44 24 04 C7 04 24 07 00 00 00 E8 ?? ?? ?? ?? BA 00 01 00 00 85 C0 0F 49 54 24 18 83 C4 2C 89 D0 C3 }
	condition:
		$1
}

rule file_177_0_0 {
	meta:
		name = "__frexp"
		size = 103
	strings:
		$1 = { 8B 4C 24 04 8B 44 24 08 89 C2 25 FF FF FF 7F 09 C1 74 49 31 C9 3D 00 00 F0 7F 73 40 3D 00 00 10 00 73 1F DD 44 24 04 DC 0D ?? ?? ?? ?? B9 CA FF FF FF DD 5C 24 04 9B 8B 44 24 08 89 C2 25 FF FF FF 7F C1 E8 14 81 E2 FF FF 0F 80 2D FE 03 00 00 81 CA 00 00 E0 3F 01 C1 89 54 24 08 8B 44 24 0C DD 44 24 04 89 08 C3 }
	condition:
		$1
}

rule file_178_2_0 {
	meta:
		name = "getgrent"
		size = 124
		refs = "004a __getgrent_r 004f __nss_getent 0055 __libc_errno"
	strings:
		$1 = { 53 31 C0 83 EC 28 B9 01 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 0D ?? ?? ?? ?? 75 5D C7 44 24 14 00 00 00 00 C7 44 24 10 ?? ?? ?? ?? C7 44 24 0C 00 04 00 00 C7 44 24 08 ?? ?? ?? ?? C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 65 8B 1A 89 C1 65 83 3D 0C 00 00 00 00 74 01 F0 83 2D ?? ?? ?? ?? 01 75 17 65 89 1A 83 C4 28 89 C8 5B C3 }
	condition:
		$1
}

rule file_275_2_0 {
	meta:
		name = "getaliasent"
		size = 124
		refs = "004a __getaliasent_r 004f __nss_getent 0055 __libc_errno"
	strings:
		$1 = { 53 31 C0 83 EC 28 B9 01 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 0D ?? ?? ?? ?? 75 5D C7 44 24 14 00 00 00 00 C7 44 24 10 ?? ?? ?? ?? C7 44 24 0C 00 04 00 00 C7 44 24 08 ?? ?? ?? ?? C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 65 8B 1A 89 C1 65 83 3D 0C 00 00 00 00 74 01 F0 83 2D ?? ?? ?? ?? 01 75 17 65 89 1A 83 C4 28 89 C8 5B C3 }
	condition:
		$1
}

rule file_286_2_0 {
	meta:
		name = "getprotoent"
		size = 124
		refs = "004a __getprotoent_r 004f __nss_getent 0055 __libc_errno"
	strings:
		$1 = { 53 31 C0 83 EC 28 B9 01 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 0D ?? ?? ?? ?? 75 5D C7 44 24 14 00 00 00 00 C7 44 24 10 ?? ?? ?? ?? C7 44 24 0C 00 04 00 00 C7 44 24 08 ?? ?? ?? ?? C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 65 8B 1A 89 C1 65 83 3D 0C 00 00 00 00 74 01 F0 83 2D ?? ?? ?? ?? 01 75 17 65 89 1A 83 C4 28 89 C8 5B C3 }
	condition:
		$1
}

rule file_599_2_0 {
	meta:
		name = "getpwent"
		size = 124
		refs = "004a __getpwent_r 004f __nss_getent 0055 __libc_errno"
	strings:
		$1 = { 53 31 C0 83 EC 28 B9 01 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 0D ?? ?? ?? ?? 75 5D C7 44 24 14 00 00 00 00 C7 44 24 10 ?? ?? ?? ?? C7 44 24 0C 00 04 00 00 C7 44 24 08 ?? ?? ?? ?? C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 65 8B 1A 89 C1 65 83 3D 0C 00 00 00 00 74 01 F0 83 2D ?? ?? ?? ?? 01 75 17 65 89 1A 83 C4 28 89 C8 5B C3 }
	condition:
		$1
}

rule file_704_2_0 {
	meta:
		name = "getrpcent"
		size = 124
		refs = "004a __getrpcent_r 004f __nss_getent 0055 __libc_errno"
	strings:
		$1 = { 53 31 C0 83 EC 28 B9 01 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 0D ?? ?? ?? ?? 75 5D C7 44 24 14 00 00 00 00 C7 44 24 10 ?? ?? ?? ?? C7 44 24 0C 00 04 00 00 C7 44 24 08 ?? ?? ?? ?? C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 65 8B 1A 89 C1 65 83 3D 0C 00 00 00 00 74 01 F0 83 2D ?? ?? ?? ?? 01 75 17 65 89 1A 83 C4 28 89 C8 5B C3 }
	condition:
		$1
}

rule file_1030_2_0 {
	meta:
		name = "getservent"
		size = 124
		refs = "004a __getservent_r 004f __nss_getent 0055 __libc_errno"
	strings:
		$1 = { 53 31 C0 83 EC 28 B9 01 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 0D ?? ?? ?? ?? 75 5D C7 44 24 14 00 00 00 00 C7 44 24 10 ?? ?? ?? ?? C7 44 24 0C 00 04 00 00 C7 44 24 08 ?? ?? ?? ?? C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 65 8B 1A 89 C1 65 83 3D 0C 00 00 00 00 74 01 F0 83 2D ?? ?? ?? ?? 01 75 17 65 89 1A 83 C4 28 89 C8 5B C3 }
	condition:
		$1
}

rule file_1283_2_0 {
	meta:
		name = "getsgent"
		size = 124
		refs = "004a __getsgent_r 004f __nss_getent 0055 __libc_errno"
	strings:
		$1 = { 53 31 C0 83 EC 28 B9 01 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 0D ?? ?? ?? ?? 75 5D C7 44 24 14 00 00 00 00 C7 44 24 10 ?? ?? ?? ?? C7 44 24 0C 00 04 00 00 C7 44 24 08 ?? ?? ?? ?? C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 65 8B 1A 89 C1 65 83 3D 0C 00 00 00 00 74 01 F0 83 2D ?? ?? ?? ?? 01 75 17 65 89 1A 83 C4 28 89 C8 5B C3 }
	condition:
		$1
}

rule file_534_2_0 {
	meta:
		name = "getspent"
		size = 124
		refs = "004a __getspent_r 004f __nss_getent 0055 __libc_errno"
	strings:
		$1 = { 53 31 C0 83 EC 28 B9 01 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 0D ?? ?? ?? ?? 75 5D C7 44 24 14 00 00 00 00 C7 44 24 10 ?? ?? ?? ?? C7 44 24 0C 00 04 00 00 C7 44 24 08 ?? ?? ?? ?? C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 65 8B 1A 89 C1 65 83 3D 0C 00 00 00 00 74 01 F0 83 2D ?? ?? ?? ?? 01 75 17 65 89 1A 83 C4 28 89 C8 5B C3 }
	condition:
		$1
}

rule file_179_0_0 {
	meta:
		name = "shmat"
		size = 100
		refs = "002f _dl_sysinfo 0040 __libc_errno"
	strings:
		$1 = { 83 EC 20 89 5C 24 10 8B 54 24 2C BB 15 00 00 00 89 74 24 14 8B 4C 24 24 8D 74 24 0C 89 7C 24 18 8B 7C 24 28 89 6C 24 1C B8 75 00 00 00 FF 15 ?? ?? ?? ?? 3D 00 F0 FF FF 8B 6C 24 0C 76 10 8B 15 ?? ?? ?? ?? F7 D8 BD FF FF FF FF 65 89 02 89 E8 8B 5C 24 10 8B 74 24 14 8B 7C 24 18 8B 6C 24 1C 83 C4 20 C3 }
	condition:
		$1
}

rule file_180_0_0 {
	meta:
		name = "__posix_spawn_file_actions_realloc"
		size = 71
		refs = "0025 realloc"
	strings:
		$1 = { 83 EC 1C 89 5C 24 14 8B 5C 24 20 89 74 24 18 8B 33 83 C6 08 8D 04 B6 C1 E0 02 89 44 24 04 8B 43 08 89 04 24 E8 ?? ?? ?? ?? BA 0C 00 00 00 85 C0 74 07 89 43 08 30 D2 89 33 89 D0 8B 5C 24 14 8B 74 24 18 83 C4 1C C3 }
	condition:
		$1
}

rule file_180_1_0 {
	meta:
		name = "posix_spawn_file_actions_init"
		size = 93
	strings:
		$1 = { 57 8B 7C 24 08 BA 4C 00 00 00 F7 C7 01 00 00 00 75 2E F7 C7 02 00 00 00 75 36 89 D1 31 C0 C1 E9 02 F6 C2 02 F3 AB 74 08 66 C7 07 00 00 83 C7 02 83 E2 01 74 03 C6 07 00 31 C0 5F C3 8D 74 26 00 C6 07 00 83 C7 01 B2 4B F7 C7 02 00 00 00 74 CA 66 C7 07 00 00 83 EA 02 83 C7 02 EB BD }
	condition:
		$1
}

rule file_181_3_0 {
	meta:
		name = "_IO_getwc"
		size = 199
		refs = "008d __wuflow 00c3 _Unwind_Resume"
	strings:
		$1 = { 56 53 83 EC 14 8B 5C 24 20 8B 03 25 00 80 00 00 75 32 8B 53 48 65 8B 35 08 00 00 00 3B 72 08 74 1F B9 01 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 0A 0F 85 8D 00 00 00 8B 53 48 89 72 08 83 42 04 01 8B 53 58 85 D2 74 3E 8B 0A 3B 4A 04 73 37 8B 31 83 C1 04 89 0A F7 03 00 80 00 00 75 20 8B 53 48 83 6A 04 01 75 17 C7 42 08 00 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 83 2A 01 75 52 83 C4 14 89 F0 5B 5E C3 89 1C 24 E8 ?? ?? ?? ?? 89 C6 EB C4 F7 03 00 80 00 00 89 C6 75 20 8B 53 48 83 6A 04 01 75 17 C7 42 08 00 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 83 2A 01 75 1D 89 34 24 E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_182_0_0 {
	meta:
		name = "round_and_return"
		size = 613
		refs = "00d7 __mpn_rshift 0112 __libc_errno 01c1 __mpn_construct_double"
	strings:
		$1 = { 83 EC 3C 81 FA 02 FC FF FF 89 5C 24 2C 8B 5C 24 48 89 74 24 30 89 C6 89 7C 24 34 8B 7C 24 40 89 4C 24 14 8B 4C 24 44 89 6C 24 38 0F 8D F1 00 00 00 B8 02 FC FF FF 29 D0 83 F8 35 0F 8F 87 01 00 00 BD 01 00 00 00 D3 E5 31 C9 83 ED 01 85 FD 0F 95 C1 09 CB 83 F8 35 0F 84 DB 01 00 00 83 F8 1F 0F 8E 82 00 00 00 B9 01 FC FF FF 29 D1 89 CA 83 E1 1F C1 FA 05 85 D2 8B 3C 96 8D 2C 95 00 00 00 00 74 22 01 F5 89 F2 89 6C 24 18 89 44 24 1C 90 31 C0 83 3A 00 0F 95 C0 83 C2 04 09 C3 39 EA 75 EF 8B 44 24 1C BA 01 00 00 00 D3 E2 83 EA 01 85 D7 0F 95 C2 83 E0 1F 89 44 24 0C 8D 46 04 0F B6 D2 C7 44 24 08 01 00 00 00 09 D3 89 44 24 04 89 34 24 89 4C 24 10 E8 ?? ?? ?? ?? 8B 4C 24 10 C7 46 04 00 00 00 00 EB 29 B9 01 FC FF FF 8B 3E 29 D1 89 44 24 0C C7 44 24 08 02 00 00 00 89 74 24 04 89 34 24 89 4C 24 10 E8 ?? ?? ?? ?? 8B 4C 24 10 A1 ?? ?? ?? ?? BA 01 FC FF FF 65 C7 00 22 00 00 00 0F A3 CF 73 31 85 DB 8B 06 75 08 A8 01 0F 84 EB 00 00 00 8D 48 01 39 C8 8B 46 04 89 0E 0F 87 93 00 00 00 A9 00 00 20 00 0F 85 99 00 00 00 81 FA 01 FC FF FF 74 38 81 FA 00 04 00 00 7E 3D 8B 44 24 14 85 C0 75 20 D9 05 ?? ?? ?? ?? 8B 5C 24 2C 8B 74 24 30 8B 7C 24 34 8B 6C 24 38 83 C4 3C C3 8D B6 00 00 00 00 D9 05 ?? ?? ?? ?? EB DE A9 00 00 10 00 B8 02 FC FF FF 0F 45 D0 8B 44 24 14 89 74 24 40 8B 5C 24 2C 8B 74 24 30 8B 7C 24 34 8B 6C 24 38 89 44 24 48 89 54 24 44 83 C4 3C E9 ?? ?? ?? ?? 8D 76 00 A1 ?? ?? ?? ?? D9 EE 65 C7 00 22 00 00 00 EB 96 83 C0 01 A9 00 00 20 00 89 46 04 0F 84 67 FF FF FF 83 C2 01 C7 44 24 0C 01 00 00 00 C7 44 24 08 02 00 00 00 89 74 24 04 89 34 24 89 54 24 10 E8 ?? ?? ?? ?? 8B 54 24 10 81 4E 04 00 00 10 00 E9 3C FF FF FF 8D 74 26 00 BB 01 00 00 00 D3 E3 83 EB 01 85 FB 0F 84 26 FF FF FF E9 FE FE FF FF 90 8B 7E 04 B9 14 00 00 00 8B 16 C7 46 04 00 00 00 00 C7 06 00 00 00 00 85 FF 0F 95 C0 85 D2 0F 95 C2 09 D0 0F B6 C0 09 C3 E9 AC FE FF FF }
	condition:
		$1
}

rule file_182_1_0 {
	meta:
		name = "str_to_mpn.isra.0"
		size = 652
		refs = "00b1 _tens_in_limb 0144 __mpn_mul_1"
	strings:
		$1 = { 55 89 D5 57 56 31 F6 53 89 C3 83 EC 2C 8B 54 24 40 89 4C 24 18 C7 44 24 14 00 00 00 00 C7 02 00 00 00 00 31 D2 8D 76 00 0F BE 03 8D 48 D0 80 F9 09 76 1B 8B 4C 24 4C 85 C9 74 0C 8B 4C 24 4C 3A 01 0F 84 99 00 00 00 03 5C 24 48 0F BE 03 83 ED 01 83 C3 01 8D 0C B6 83 C2 01 85 ED 8D 74 48 D0 7E 36 83 FA 09 75 C1 8B 7C 24 14 85 FF 0F 85 B5 00 00 00 8B 54 24 40 8B 4C 24 18 C7 44 24 14 01 00 00 00 89 31 31 F6 C7 02 01 00 00 00 31 D2 EB 97 8D B4 26 00 00 00 00 8B 4C 24 44 8B 01 85 C0 7E 0C 8D 0C 02 83 F9 09 0F 8E 02 01 00 00 8B 04 95 ?? ?? ?? ?? 8B 54 24 14 85 D2 0F 85 14 01 00 00 8B 4C 24 18 8B 54 24 40 89 31 C7 02 01 00 00 00 83 C4 2C 89 D8 5B 5E 5F 5D C3 90 8D 74 26 00 0F B6 41 01 84 C0 0F 84 96 01 00 00 38 43 01 0F 85 52 FF FF FF B8 01 00 00 00 89 54 24 1C EB 09 38 14 03 0F 85 5F 01 00 00 83 C0 01 0F B6 14 01 89 C7 84 D2 75 EA 8B 54 24 1C 01 FB 0F BE 03 E9 2A FF FF FF 8D 74 26 00 8B 4C 24 14 C7 44 24 0C 00 CA 9A 3B 89 4C 24 08 8B 4C 24 18 89 4C 24 04 89 0C 24 E8 ?? ?? ?? ?? 8B 7C 24 40 8B 17 8B 7C 24 18 89 C1 8B 07 01 C6 39 F0 89 37 76 1D 8B 7C 24 18 83 C7 04 8D 76 00 83 EA 01 0F 84 00 01 00 00 8B 07 83 C0 01 85 C0 AB 74 ED 31 C0 01 C8 0F 84 CB 00 00 00 8B 4C 24 40 31 F6 8B 11 8B 4C 24 18 89 04 91 8B 54 24 40 8B 4C 24 40 8B 12 83 C2 01 89 54 24 14 89 11 31 D2 E9 7A FE FF FF 66 90 8B 54 24 44 0F AF 34 85 ?? ?? ?? ?? 8B 04 8D ?? ?? ?? ?? C7 02 00 00 00 00 8B 54 24 14 85 D2 0F 84 EC FE FF FF 8B 4C 24 14 89 44 24 0C 89 4C 24 08 8B 4C 24 18 89 4C 24 04 89 0C 24 E8 ?? ?? ?? ?? 8B 7C 24 40 8B 17 8B 7C 24 18 89 C1 8B 07 01 C6 39 F0 89 37 76 18 8B 7C 24 18 83 C7 04 66 90 83 EA 01 74 66 8B 07 83 C0 01 85 C0 AB 74 F1 31 C0 01 C8 0F 84 A8 FE FF FF 8B 4C 24 40 8B 11 8B 4C 24 18 89 04 91 8B 4C 24 40 83 C2 01 89 D8 89 11 83 C4 2C 5B 5E 5F 5D C3 8D B4 26 00 00 00 00 8B 54 24 40 31 F6 8B 12 89 54 24 14 31 D2 E9 C5 FD FF FF 90 8D 74 26 00 8B 54 24 1C E9 D6 FD FF FF B8 01 00 00 00 E9 02 FF FF FF B8 01 00 00 00 EB 9F BF 01 00 00 00 E9 8E FE FF FF }
	condition:
		$1
}

rule file_182_2_0 {
	meta:
		name = "____strtod_l_internal"
		size = 7757
		refs = "0034 strlen 028c _nl_C_locobj 035b __correctly_grouped_prefixmb 0650 _fpioconst_pow10 0689 __tens 069a __mpn_mul 0826 __libc_errno 08ff memcpy 0b81 __mpn_lshift 0c0a __mpn_cmp 0d09 __mpn_submul_1 0d35 __mpn_add_n 0ff2 __strncasecmp_l 18fe __mpn_rshift 199a ____strtoull_l_internal"
	strings:
		$1 = { 55 57 56 53 81 EC CC 01 00 00 8B 94 24 EC 01 00 00 8B 42 04 8B 94 24 E8 01 00 00 85 D2 0F 85 D8 1B 00 00 31 ED C7 44 24 60 00 00 00 00 8B 78 24 89 3C 24 E8 ?? ?? ?? ?? 8B 94 24 EC 01 00 00 8B 9C 24 E0 01 00 00 C7 84 24 80 00 00 00 00 00 00 00 8B 4A 34 83 EB 01 89 44 24 58 90 8D 74 26 00 83 C3 01 0F BE 13 0F BE C2 F6 44 41 01 20 75 F0 80 FA 2D 89 D8 0F 84 85 02 00 00 80 FA 2B C7 44 24 64 00 00 00 00 0F 84 0C 04 00 00 0F B6 0F 84 C9 88 4C 24 40 0F 84 BE 12 00 00 3A 0B 0F 85 DD 01 00 00 31 C0 EB 0A 90 3A 0C 03 0F 85 CF 01 00 00 83 C0 01 0F B6 0C 07 89 C6 84 C9 75 EA 0F B6 04 33 3C 2F 0F 8E B6 01 00 00 3C 39 0F 8F AE 01 00 00 8B B4 24 EC 01 00 00 80 FA 30 8B 76 38 89 74 24 34 0F 84 D7 06 00 00 8B 74 24 60 31 C0 85 F6 0F 94 C0 89 44 24 5C 0F 85 92 1A 00 00 89 5C 24 54 C7 44 24 38 0A 00 00 00 8B 74 24 34 0F BE C2 8B 0C 86 8D 42 D0 3C 09 76 55 83 7C 24 38 10 89 CE 0F 95 44 24 44 80 F9 60 0F 8F C8 06 00 00 80 7C 24 40 00 74 25 0F B6 44 24 40 38 03 0F 85 D0 01 00 00 31 C0 EB 09 3A 0C 03 0F 85 C3 01 00 00 83 C0 01 0F B6 0C 07 84 C9 75 EC 39 5C 24 54 75 0E 83 7C 24 38 10 0F 84 04 07 00 00 8D 76 00 89 DE C7 44 24 44 00 00 00 00 8D 42 D0 3C 09 0F 86 63 01 00 00 83 7C 24 38 10 0F 84 40 01 00 00 8B 44 24 5C 85 C0 0F 84 02 1B 00 00 85 ED 0F 85 7F 1A 00 00 83 7C 24 44 01 19 C0 80 7C 24 40 00 89 44 24 4C 74 26 0F B6 4C 24 40 31 C0 38 0E 74 10 E9 85 15 00 00 66 90 3A 0C 06 0F 85 DF 01 00 00 83 C0 01 0F B6 0C 07 84 C9 75 EC 8B 4C 24 44 03 74 24 58 89 5C 24 54 8B 5C 24 4C 89 7C 24 5C 89 74 24 40 0F BE 06 29 F1 EB 3A 90 8D 74 26 00 8B 7C 24 34 0F BE D0 8B 14 97 89 54 24 48 83 EA 61 80 FA 05 0F 87 82 06 00 00 83 FB FF 75 10 3C 30 89 F0 0F 95 C2 2B 44 24 40 84 D2 0F 45 D8 83 C6 01 0F BE 06 8D 50 D0 80 FA 09 8D 2C 31 76 DA 83 7C 24 38 10 74 B9 8B 4C 24 34 89 5C 24 4C 8B 7C 24 5C 8B 5C 24 54 89 74 24 34 0F B6 14 81 C6 44 24 40 00 80 FA 65 0F 85 3F 02 00 00 83 7C 24 38 10 0F 84 34 02 00 00 E9 61 01 00 00 8D 76 00 8D 42 D0 3C 09 0F 86 47 FE FF FF A1 ?? ?? ?? ?? 0F B6 04 90 3C 69 0F 84 3A 0D 00 00 3C 6E 0F 84 B0 0D 00 00 8B BC 24 E4 01 00 00 85 FF 0F 84 E9 00 00 00 8B BC 24 E0 01 00 00 D9 EE 8B B4 24 E4 01 00 00 89 3E 81 C4 CC 01 00 00 5B 5E 5F 5D C3 8B 4C 24 34 0F BE C2 8B 04 81 83 E8 61 3C 05 0F 87 AB FE FF FF 8D 76 00 83 44 24 44 01 89 F0 8D 70 01 0F BE 50 01 E9 7F FE FF FF 90 8D 74 26 00 83 C3 01 0F BE 50 01 C7 44 24 64 01 00 00 00 E9 78 FD FF FF 80 7C 24 44 00 0F 84 3D 14 00 00 83 7C 24 38 10 89 F0 0F 94 C1 3C 65 75 12 84 C9 89 DE C7 44 24 44 00 00 00 00 0F 84 3B FE FF FF 8B 74 24 60 8B 7C 24 54 89 6C 24 0C 89 5C 24 04 89 74 24 08 89 3C 24 88 4C 24 2C E8 ?? ?? ?? ?? 8B 94 24 E4 01 00 00 0F B6 4C 24 2C 85 D2 74 21 39 C7 0F 84 08 17 00 00 89 84 24 E0 01 00 00 8B 94 24 E0 01 00 00 8B AC 24 E4 01 00 00 89 55 00 90 8B 44 24 64 85 C0 0F 85 9D 04 00 00 81 C4 CC 01 00 00 5B D9 EE 5E 5F 5D C3 8D B4 26 00 00 00 00 8B 44 24 34 8B 6C 24 44 8B 14 90 83 7C 24 38 10 0F 94 44 24 40 80 FA 70 0F 85 7A 04 00 00 80 7C 24 40 00 0F 84 6F 04 00 00 C6 44 24 40 01 0F BE 56 01 80 FA 2D 0F 84 C6 04 00 00 8D 4E 01 80 FA 2B 89 4C 24 34 C7 44 24 54 00 00 00 00 0F 84 40 0A 00 00 8D 42 D0 3C 09 0F 87 9A 00 00 00 80 7C 24 40 00 0F 85 38 04 00 00 8B 44 24 54 85 C0 0F 84 9B 0B 00 00 8B 4C 24 44 81 C1 68 01 00 00 89 4C 24 6C 89 74 24 68 8B 84 24 80 00 00 00 8B 4C 24 34 8B 74 24 6C 89 5C 24 5C 8D B6 00 00 00 00 8D 04 80 8D 44 42 D0 39 F0 89 84 24 80 00 00 00 0F 8F 08 19 00 00 83 C1 01 0F BE 11 8D 5A D0 80 FB 09 76 DC 89 4C 24 34 8B 4C 24 54 8B 5C 24 5C 8B 74 24 68 85 C9 74 24 F7 D8 89 84 24 80 00 00 00 EB 19 90 8D 74 26 00 83 C3 01 0F BE 50 01 E9 E8 FB FF FF 8D 74 26 00 89 74 24 34 3B 6C 24 44 89 F0 7E 1C 80 7E FF 30 75 16 8D B6 00 00 00 00 83 E8 01 8D 14 28 29 F2 80 78 FF 30 74 F2 89 D5 85 ED 7E 0C 39 6C 24 44 0F 84 41 02 00 00 66 90 8B 84 24 E4 01 00 00 85 C0 74 0D 8B 74 24 34 8B 8C 24 E4 01 00 00 89 31 85 ED 0F 84 90 FE FF FF 8B 44 24 4C 85 C0 0F 84 05 03 00 00 0F B6 47 01 0F B6 37 0F B6 0B 88 44 24 34 EB 0B 8D 74 26 00 0F B6 4B 01 83 C3 01 89 F2 38 CA 75 F3 80 7C 24 34 00 74 24 0F B6 4B 01 3A 4C 24 34 75 E6 B8 01 00 00 00 EB 08 8D 76 00 3A 14 03 75 D7 83 C0 01 0F B6 14 07 84 D2 75 F0 8B 44 24 4C 8B 54 24 4C 03 44 24 58 8B B4 24 80 00 00 00 C1 E2 02 01 C3 83 7C 24 38 10 0F 45 54 24 4C 2B 6C 24 4C 29 D6 89 74 24 34 89 B4 24 80 00 00 00 83 7C 24 38 10 0F 84 BD 08 00 00 8B 74 24 34 85 F6 0F 88 0A 0B 00 00 89 EA 2B 54 24 44 3B 54 24 34 0F 4F 54 24 34 8B 74 24 44 8B 44 24 34 01 D6 29 D0 89 F2 01 C2 81 FA 35 01 00 00 89 74 24 44 89 84 24 80 00 00 00 0F 8F CC 12 00 00 3D BD FE FF FF 0F 8C 3E 02 00 00 8B 54 24 44 85 D2 0F 8E F8 03 00 00 8B 74 24 60 8D BC 24 90 00 00 00 8B 44 24 58 89 7C 24 40 8B 54 24 44 8D 7C 24 7C 8B 4C 24 40 89 74 24 0C 8D B4 24 80 00 00 00 89 44 24 08 89 D8 89 74 24 04 89 3C 24 89 74 24 5C 89 7C 24 54 E8 3D F7 FF FF 8B 74 24 7C 89 C3 8B 84 24 80 00 00 00 85 C0 0F 8E BB 02 00 00 8D 94 24 28 01 00 00 B9 ?? ?? ?? ?? 89 54 24 38 BF 01 00 00 00 89 54 24 50 8B 54 24 40 89 5C 24 48 89 CB 8B 4C 24 38 89 6C 24 34 EB 60 89 6C 24 10 8B 03 89 54 24 04 89 0C 24 89 74 24 08 8D 04 85 ?? ?? ?? ?? 89 44 24 0C 89 54 24 28 89 4C 24 2C E8 ?? ?? ?? ?? 8B 54 24 28 8B 4C 24 2C 8B 74 24 7C 01 EE 85 C0 89 74 24 7C 75 07 83 EE 01 89 74 24 7C 8B 84 24 80 00 00 00 89 D5 89 CA 89 E9 01 FF 83 C3 10 85 C0 0F 84 05 02 00 00 85 F8 74 EF 8B 6B 04 31 F8 89 84 24 80 00 00 00 83 ED 02 39 F5 7E 89 89 54 24 0C 89 74 24 10 89 6C 24 08 8B 03 89 0C 24 89 54 24 28 89 4C 24 2C 8D 04 85 ?? ?? ?? ?? 89 44 24 04 E8 ?? ?? ?? ?? 8B 4C 24 2C 8B 54 24 28 EB 87 8B 94 24 80 00 00 00 85 D2 0F 89 B2 FD FF FF 89 5C 24 54 0F B6 4C 24 40 83 E8 01 89 7C 24 40 8B 5C 24 44 8B BC 24 EC 01 00 00 EB 54 90 8D 74 26 00 0F BE 10 83 EA 30 83 FA 09 0F 97 C2 84 D2 75 3C 80 38 30 0F 85 60 01 00 00 8B B4 24 80 00 00 00 83 ED 01 83 EB 01 80 F9 01 19 D2 83 E2 FD 8D 54 32 04 89 94 24 80 00 00 00 C1 EA 1F 84 D2 0F 84 35 01 00 00 85 ED 0F 8E 2D 01 00 00 83 E8 01 84 C9 74 AD 0F BE 30 8B 57 34 0F B7 14 72 66 C1 EA 0C 83 F2 01 83 E2 01 EB A3 8D B4 26 00 00 00 00 0F BE 43 01 83 3C 86 78 0F 84 92 0B 00 00 8B 4C 24 60 31 C0 85 C9 0F 94 C0 89 44 24 5C 0F 85 AD 13 00 00 89 5C 24 54 C7 44 24 38 0A 00 00 00 E9 9B 0B 00 00 8D 74 26 00 80 7C 24 44 00 0F 85 2D F9 FF FF 80 F9 66 0F 8E 64 F9 FF FF E9 1F F9 FF FF 8B BC 24 80 00 00 00 89 7C 24 34 E9 6A FD FF FF 8B 4C 24 64 A1 ?? ?? ?? ?? 85 C9 65 C7 00 22 00 00 00 0F 84 63 FB FF FF 81 C4 CC 01 00 00 D9 EE 5B D9 E0 5E 5F 5D C3 89 74 24 34 E9 13 FA FF FF 8B 44 24 54 85 C0 0F 84 F2 08 00 00 8B 4C 24 44 8D 0C 8D 32 04 00 00 89 4C 24 6C E9 C2 FB FF FF 8B 4C 24 58 0F BE 04 0B 8D 48 D0 80 F9 09 0F 86 EB F8 FF FF 8B 4C 24 34 8B 04 81 83 E8 61 3C 05 0F 86 D9 F8 FF FF E9 83 FA FF FF 89 5C 24 4C 8B 7C 24 5C 8B 5C 24 54 8B 54 24 48 E9 0A FB FF FF 8D 46 02 0F BE 56 02 89 44 24 34 C7 44 24 54 01 00 00 00 E9 3A FB FF FF 89 5C 24 44 8B 7C 24 40 8B 5C 24 54 E9 06 FC FF FF 3B 54 24 50 8B 6C 24 34 8B 5C 24 48 75 1B 8B 7C 24 40 8D 04 B5 00 00 00 00 89 44 24 08 89 54 24 04 89 3C 24 E8 ?? ?? ?? ?? 8D 46 FF 89 F7 0F BD 94 84 90 00 00 00 C1 E7 05 83 F2 1F 29 D7 81 FF 00 04 00 00 89 7C 24 38 0F 8F 7C 0F 00 00 83 7C 24 38 35 0F 8E 8D 07 00 00 8B 54 24 38 83 EA 35 89 D7 C1 FF 05 83 E2 1F 89 54 24 34 0F 85 1B 08 00 00 8B 84 BC 90 00 00 00 8D 4F FF 8B 94 BC 94 00 00 00 C7 44 24 58 1F 00 00 00 89 84 24 88 00 00 00 8B 84 8C 90 00 00 00 89 94 24 8C 00 00 00 89 44 24 48 8D 84 24 88 00 00 00 89 44 24 4C 8B B4 24 90 00 00 00 31 C0 85 F6 75 14 8B 54 24 40 8D B6 00 00 00 00 83 C0 01 8B 1C 82 85 DB 74 F6 8B 54 24 38 8B 74 24 58 8B 7C 24 48 83 EA 01 39 C8 0F 9C C0 39 6C 24 44 89 74 24 04 89 3C 24 0F 9C C1 09 C8 8B 4C 24 64 0F B6 C0 89 44 24 08 8B 44 24 4C E8 1E F1 FF FF E9 DE F8 FF FF 8D B4 24 88 00 00 00 B9 14 00 00 00 8D BC 24 90 00 00 00 BA 12 00 00 00 89 74 24 4C 8D B4 24 80 00 00 00 89 7C 24 40 8D 7C 24 7C C7 44 24 38 00 00 00 00 89 74 24 5C 89 7C 24 54 2B 6C 24 44 C6 44 24 68 00 39 CD 89 6C 24 48 7E 0C 83 C2 02 89 54 24 48 C6 44 24 68 01 8B 74 24 40 BF ?? ?? ?? ?? 8B 6C 24 48 89 5C 24 6C 31 DB C7 44 24 34 00 00 00 00 89 74 24 44 8D B4 24 28 01 00 00 89 74 24 50 89 F2 29 C5 BE 01 00 00 00 EB 3B 8D 74 26 00 8B 5F 04 8B 07 89 14 24 89 54 24 28 83 EB 02 8D 0C 9D 00 00 00 00 8D 04 85 ?? ?? ?? ?? 89 4C 24 08 89 44 24 04 E8 ?? ?? ?? ?? 8B 54 24 28 01 F6 83 C7 10 85 ED 74 62 85 F5 74 F3 31 F5 85 DB 74 BF 89 5C 24 10 8B 4C 24 44 89 54 24 0C 8B 47 04 83 E8 02 89 44 24 08 8B 07 89 0C 24 89 54 24 28 8D 04 85 ?? ?? ?? ?? 89 44 24 04 E8 ?? ?? ?? ?? 8B 4F 04 8B 54 24 28 8D 5C 0B FE 85 C0 0F 85 39 03 00 00 89 D0 83 EB 01 8B 54 24 44 01 F6 83 C7 10 85 ED 89 44 24 44 75 9E 3B 54 24 40 89 5C 24 34 8B 5C 24 6C 0F 84 B6 0E 00 00 8B 44 24 58 8B 74 24 5C 8B 6C 24 60 8B 7C 24 54 8B 4C 24 40 8B 54 24 48 89 44 24 08 89 D8 89 74 24 04 89 6C 24 0C 89 3C 24 E8 1F F2 FF FF 8B 74 24 34 83 EE 01 0F BD 9C B4 28 01 00 00 89 74 24 48 83 F3 1F 7E 40 8B 6C 24 50 8B 7C 24 34 89 5C 24 0C 89 6C 24 04 89 7C 24 08 89 2C 24 E8 ?? ?? ?? ?? 8B 74 24 40 8B 44 24 7C 89 5C 24 0C 89 74 24 04 89 44 24 08 89 34 24 E8 ?? ?? ?? ?? 85 C0 0F 85 8F 05 00 00 8B 7C 24 38 83 7C 24 34 01 89 BC 24 80 00 00 00 0F 84 33 0A 00 00 83 7C 24 34 02 0F 84 F1 07 00 00 8B 74 24 34 8B 6C 24 48 8B 44 24 7C 83 EE 02 8B BC AC 28 01 00 00 89 74 24 44 8B AC B4 28 01 00 00 8B 74 24 34 89 44 24 08 29 C6 89 F0 8B 74 24 50 8D 04 86 8B 74 24 40 89 44 24 04 89 34 24 E8 ?? ?? ?? ?? 8B 4C 24 7C 85 C0 7E 12 C7 84 8C 90 00 00 00 00 00 00 00 83 C1 01 89 4C 24 7C 3B 4C 24 34 0F 8C 5E 0B 00 00 8B 74 24 40 85 C9 8D 94 24 8C 00 00 00 8D 44 8E FC 7E 0F 8D 76 00 8B 08 83 E8 04 89 48 08 39 D0 75 F4 8B 74 24 34 C7 84 24 90 00 00 00 00 00 00 00 C7 44 24 60 00 00 00 00 8B 8C B4 90 00 00 00 C7 84 B4 28 01 00 00 00 00 00 00 8B 74 24 34 8B 44 24 40 83 C6 01 89 74 24 54 8B 74 24 44 8D 34 B0 89 74 24 5C 90 39 F9 BE FF FF FF FF 74 4C 8B 74 24 48 89 CA 8B B4 B4 90 00 00 00 89 F0 89 74 24 30 F7 F7 89 C6 89 D1 89 E8 F7 E6 89 C3 EB 11 8D B6 00 00 00 00 31 C0 39 EB 0F 92 C0 29 EB 29 C2 39 CA 77 0F 75 14 8B 44 24 44 3B 9C 84 90 00 00 00 76 07 83 EE 01 01 F9 73 DB 8B 4C 24 54 8B 44 24 50 8B 54 24 40 89 74 24 0C 89 4C 24 08 89 44 24 04 89 14 24 E8 ?? ?? ?? ?? 8B 4C 24 34 39 84 8C 90 00 00 00 74 1F 8B 54 24 40 83 EE 01 8B 44 24 50 89 4C 24 0C 89 54 24 04 89 44 24 08 89 14 24 E8 ?? ?? ?? ?? 8B 44 24 48 8B 54 24 34 8B 8C 84 90 00 00 00 85 C0 89 8C 94 90 00 00 00 7E 19 8B 44 24 5C 8D 94 24 8C 00 00 00 66 90 8B 18 83 E8 04 89 58 08 39 D0 75 F4 8B 44 24 38 C7 84 24 90 00 00 00 00 00 00 00 85 C0 0F 85 2D 05 00 00 85 F6 0F 84 4B 05 00 00 8B 9C 24 80 00 00 00 0F BD C6 BA 20 00 00 00 83 F0 1F 29 C2 29 C3 83 FA 35 89 9C 24 80 00 00 00 0F 8E B4 0F 00 00 8D 78 35 B9 EB FF FF FF 89 7C 24 60 8B 7C 24 34 29 C1 89 F0 D3 E8 89 84 24 88 00 00 00 8B 8C BC 90 00 00 00 85 C9 8B 44 24 34 75 22 8B 6C 24 34 85 ED 78 1A 8B 54 24 40 EB 0A 90 8D 74 26 00 83 F8 FF 74 0A 83 E8 01 8B 3C 82 85 FF 74 F1 F7 D0 8B 4C 24 64 C1 E8 1F 0A 44 24 68 8D 53 FF 89 34 24 0F B6 C0 89 44 24 08 B8 1F 00 00 00 2B 44 24 60 89 44 24 04 8B 44 24 4C E8 D1 EC FF FF E9 91 F4 FF FF 89 D0 8B 54 24 44 89 44 24 44 E9 63 FC FF FF 8D 46 02 0F BE 56 02 89 44 24 34 E9 B0 F5 FF FF 8B BC 24 EC 01 00 00 0F B6 03 8B 57 34 0F BE C8 F6 44 4A 01 10 75 16 8D B6 00 00 00 00 83 C3 01 0F B6 03 0F BE C8 F6 44 4A 01 10 74 F0 3C 30 75 11 8D 74 26 00 83 C3 01 0F B6 03 3C 30 74 F6 0F BE C8 8D 71 D0 83 C3 01 83 FE 09 0F 87 7F 02 00 00 8B 3C B5 ?? ?? ?? ?? B9 15 00 00 00 8B 44 24 44 89 54 24 40 29 F9 D3 E6 8D 4C 87 FB 03 4C 24 34 89 B4 24 8C 00 00 00 BE 14 00 00 00 29 FE BF 01 00 00 00 89 4C 24 38 89 8C 24 80 00 00 00 8D B6 00 00 00 00 83 ED 01 85 ED 7E 41 0F BE 03 8B 54 24 40 F6 44 42 01 10 75 07 03 5C 24 58 0F BE 03 8D 48 D0 83 F9 09 0F 87 98 00 00 00 89 C8 83 C3 01 83 FE 02 7E 56 8D 4E FD 83 ED 01 D3 E0 83 EE 04 09 84 BC 88 00 00 00 85 ED 7F BF 83 FF 01 75 0B C7 84 24 88 00 00 00 00 00 00 00 8B 4C 24 64 8D 84 24 88 00 00 00 8B 54 24 38 C7 44 24 08 00 00 00 00 C7 44 24 04 00 00 00 00 C7 04 24 00 00 00 00 E8 95 EB FF FF E9 55 F3 FF FF B9 03 00 00 00 89 C2 29 F1 D3 EA 8D 4E 1D D3 E0 09 94 BC 88 00 00 00 85 FF 89 C1 0F 84 C5 08 00 00 89 84 24 88 00 00 00 83 C6 1C 31 FF E9 46 FF FF FF 8D B6 00 00 00 00 8B 8C 24 EC 01 00 00 83 C3 01 8B 51 38 8B 04 82 83 E8 57 E9 55 FF FF FF 8B 44 24 4C 2B 44 24 44 05 35 01 00 00 89 44 24 6C E9 5D F4 FF FF C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 03 00 00 00 C7 44 24 04 ?? ?? ?? ?? 89 1C 24 E8 ?? ?? ?? ?? 85 C0 0F 85 A6 F2 FF FF 8B 84 }
	condition:
		$1
}

rule file_182_3_0 {
	meta:
		name = "__strtod_l"
		size = 43
		refs = "0023 ____strtod_l_internal"
	strings:
		$1 = { 83 EC 1C 8B 44 24 28 C7 44 24 08 00 00 00 00 89 44 24 0C 8B 44 24 24 89 44 24 04 8B 44 24 20 89 04 24 E8 ?? ?? ?? ?? 83 C4 1C C3 }
	condition:
		$1
}

rule file_947_3_0 {
	meta:
		name = "__strtof_l"
		size = 43
		refs = "0023 ____strtof_l_internal"
	strings:
		$1 = { 83 EC 1C 8B 44 24 28 C7 44 24 08 00 00 00 00 89 44 24 0C 8B 44 24 24 89 44 24 04 8B 44 24 20 89 04 24 E8 ?? ?? ?? ?? 83 C4 1C C3 }
	condition:
		$1
}

rule file_192_3_0 {
	meta:
		name = "__strtold_l"
		size = 43
		refs = "0023 ____strtold_l_internal"
	strings:
		$1 = { 83 EC 1C 8B 44 24 28 C7 44 24 08 00 00 00 00 89 44 24 0C 8B 44 24 24 89 44 24 04 8B 44 24 20 89 04 24 E8 ?? ?? ?? ?? 83 C4 1C C3 }
	condition:
		$1
}

rule file_617_3_0 {
	meta:
		name = "__wcstod_l"
		size = 43
		refs = "0023 ____wcstod_l_internal"
	strings:
		$1 = { 83 EC 1C 8B 44 24 28 C7 44 24 08 00 00 00 00 89 44 24 0C 8B 44 24 24 89 44 24 04 8B 44 24 20 89 04 24 E8 ?? ?? ?? ?? 83 C4 1C C3 }
	condition:
		$1
}

rule file_364_3_0 {
	meta:
		name = "__wcstof_l"
		size = 43
		refs = "0023 ____wcstof_l_internal"
	strings:
		$1 = { 83 EC 1C 8B 44 24 28 C7 44 24 08 00 00 00 00 89 44 24 0C 8B 44 24 24 89 44 24 04 8B 44 24 20 89 04 24 E8 ?? ?? ?? ?? 83 C4 1C C3 }
	condition:
		$1
}

rule file_1404_3_0 {
	meta:
		name = "__wcstold_l"
		size = 43
		refs = "0023 ____wcstold_l_internal"
	strings:
		$1 = { 83 EC 1C 8B 44 24 28 C7 44 24 08 00 00 00 00 89 44 24 0C 8B 44 24 24 89 44 24 04 8B 44 24 20 89 04 24 E8 ?? ?? ?? ?? 83 C4 1C C3 }
	condition:
		$1
}

rule file_183_0_0 {
	meta:
		name = "__xpg_basename"
		size = 167
		refs = "0022 strrchr"
	strings:
		$1 = { 53 B8 ?? ?? ?? ?? 83 EC 18 8B 5C 24 20 85 DB 74 57 80 3B 00 74 52 C7 44 24 04 2F 00 00 00 89 1C 24 E8 ?? ?? ?? ?? 85 C0 74 4E 80 78 01 00 75 40 39 C3 73 34 80 78 FF 2F 74 0E EB 40 8D 74 26 00 80 7A FF 2F 89 D0 75 38 8D 50 FF 39 DA 75 F1 80 38 00 89 D8 74 12 66 90 83 C0 01 80 78 01 00 75 F7 8D B4 26 00 00 00 00 83 C4 18 5B C3 8D 76 00 83 C4 18 83 C0 01 5B C3 89 D8 EB EC 89 C2 66 90 8D 42 FF 39 C3 C6 02 00 73 DE 80 7A FE 2F 75 0E EB D6 8D B6 00 00 00 00 80 78 FF 2F 74 CA 83 E8 01 39 D8 75 F3 EB C1 }
	condition:
		$1
}

rule file_184_0_0 {
	meta:
		name = "__ppoll_chk"
		size = 75
		refs = "0047 __chk_fail 0042 ppoll"
	strings:
		$1 = { 83 EC 0C 8B 44 24 20 8B 54 24 14 89 5C 24 04 8B 4C 24 10 89 74 24 08 8B 5C 24 18 C1 E8 03 8B 74 24 1C 39 D0 72 20 89 74 24 1C 8B 74 24 08 89 5C 24 18 8B 5C 24 04 89 54 24 14 89 4C 24 10 83 C4 0C E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_185_0_0 {
	meta:
		name = "execl"
		size = 346
		refs = "006f realloc 0089 __environ 00a4 __execve 00b8 free 0143 memcpy"
	strings:
		$1 = { 55 57 56 53 81 EC 2C 10 00 00 8B 84 24 44 10 00 00 8D B4 24 48 10 00 00 85 C0 89 44 24 20 0F 84 A7 00 00 00 8D 54 24 20 BB 01 00 00 00 89 D5 BF 00 04 00 00 8D 74 26 00 83 C6 04 8B 46 FC 89 44 9D 00 83 C3 01 85 C0 74 3F 39 DF 75 EB 39 D5 8D 0C 3F 8D 04 FD 00 00 00 00 0F 84 A1 00 00 00 89 44 24 04 89 2C 24 89 54 24 14 89 4C 24 18 E8 ?? ?? ?? ?? 8B 54 24 14 8B 4C 24 18 85 C0 74 6E 89 C5 89 CF EB B3 8D 76 00 A1 ?? ?? ?? ?? 89 6C 24 04 89 54 24 14 89 44 24 08 8B 84 24 40 10 00 00 89 04 24 E8 ?? ?? ?? ?? 8B 54 24 14 39 D5 74 10 89 2C 24 89 44 24 18 E8 ?? ?? ?? ?? 8B 44 24 18 81 C4 2C 10 00 00 5B 5E 5F 5D C3 A1 ?? ?? ?? ?? 89 44 24 08 8D 44 24 20 89 44 24 04 8B 84 24 40 10 00 00 89 04 24 E8 ?? ?? ?? ?? EB D3 89 2C 24 E8 ?? ?? ?? ?? B8 FF FF FF FF EB C4 8D 74 26 00 89 44 24 04 C7 04 24 00 00 00 00 89 54 24 14 89 4C 24 18 E8 ?? ?? ?? ?? 8B 54 24 14 8B 4C 24 18 85 C0 89 44 24 1C 74 CD 8B 44 24 1C C1 E7 02 89 7C 24 08 89 6C 24 04 89 54 24 14 89 04 24 89 4C 24 18 E8 ?? ?? ?? ?? 8B 4C 24 18 8B 6C 24 1C 8B 54 24 14 89 CF E9 DE FE FF FF }
	condition:
		$1
}

rule file_186_0_0 {
	meta:
		name = "_rpc_dtablesize"
		size = 33
		refs = "0014 __getdtablesize"
	strings:
		$1 = { A1 ?? ?? ?? ?? 85 C0 74 07 F3 C3 90 8D 74 26 00 83 EC 0C E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_187_0_0 {
	meta:
		name = "__mpn_mod_1"
		size = 68
	strings:
		$1 = { 56 31 D2 53 8B 44 24 10 8B 74 24 0C 8B 5C 24 14 85 C0 74 21 8D 48 FF 8B 14 8E 39 DA 73 22 8D 48 FE 85 C9 78 10 8D 76 00 8B 04 8E 83 E9 01 F7 F3 83 F9 FF 75 F3 89 D0 5B 5E C3 8D B6 00 00 00 00 31 D2 EB DD }
	condition:
		$1
}

rule file_188_3_0 {
	meta:
		name = "fputc"
		size = 238
		refs = "00b4 __overflow 00ea _Unwind_Resume"
		altNames = "_IO_putc"
	strings:
		$1 = { 83 EC 1C 89 5C 24 10 8B 5C 24 24 89 74 24 14 8B 74 24 20 89 7C 24 18 8B 03 25 00 80 00 00 75 32 8B 53 48 65 8B 3D 08 00 00 00 3B 7A 08 74 1F B9 01 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 0A 0F 85 A6 00 00 00 8B 53 48 89 7A 08 83 42 04 01 8B 53 14 3B 53 18 73 4C 89 F0 89 F1 88 02 83 C2 01 81 E1 FF 00 00 00 89 53 14 F7 03 00 80 00 00 75 20 8B 53 48 83 6A 04 01 75 17 C7 42 08 00 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 83 2A 01 75 66 89 C8 8B 5C 24 10 8B 74 24 14 8B 7C 24 18 83 C4 1C C3 81 E6 FF 00 00 00 89 74 24 04 89 1C 24 E8 ?? ?? ?? ?? 89 C1 EB B0 F7 03 00 80 00 00 89 C6 75 20 8B 53 48 83 6A 04 01 75 17 C7 42 08 00 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 83 2A 01 75 1D 89 34 24 E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_189_0_0 {
	meta:
		name = "__finite"
		size = 17
	strings:
		$1 = { 8B 44 24 08 B9 FF FF EF FF 29 C1 31 C8 C1 E8 1F C3 }
	condition:
		$1
}

rule file_190_0_0 {
	meta:
		name = "siggetmask"
		size = 19
		refs = "000b __sigblock"
	strings:
		$1 = { 83 EC 1C C7 04 24 00 00 00 00 E8 ?? ?? ?? ?? 83 C4 1C C3 }
	condition:
		$1
}

rule file_191_0_0 {
	meta:
		name = "_nl_intern_locale_data"
		size = 896
		refs = "0068 malloc 015d __assert_fail 0319 free 031e __libc_errno"
	strings:
		$1 = { 55 57 56 53 83 EC 2C 83 F9 07 0F 86 0D 03 00 00 89 C7 89 D5 8B 12 83 FF 03 B8 17 10 05 20 74 12 89 FB B8 20 07 09 20 81 F3 15 11 03 20 85 FF 0F 45 C3 39 D0 0F 85 E3 02 00 00 8B 45 04 3B 04 BD ?? ?? ?? ?? 0F 82 D3 02 00 00 8D 14 85 08 00 00 00 39 D1 0F 86 C4 02 00 00 8D 04 85 24 00 00 00 89 04 24 89 4C 24 1C E8 ?? ?? ?? ?? 8B 4C 24 1C 85 C0 0F 84 B8 02 00 00 C7 40 14 00 00 00 00 C7 40 10 00 00 00 00 8B 55 04 89 68 04 89 48 08 C7 40 18 00 00 00 00 85 D2 C7 40 1C 00 00 00 00 89 50 20 0F 84 88 02 00 00 8B 75 08 39 F1 0F 82 62 02 00 00 31 DB 89 4C 24 18 EB 34 90 8D 74 26 00 85 FF 0F 85 94 02 00 00 83 FB 46 76 43 8D 76 00 01 EE 89 74 98 24 83 C3 01 39 D3 0F 84 4F 02 00 00 8B 74 9D 08 39 74 24 18 0F 82 26 02 00 00 83 FF 0C 77 CC FF 24 BD ?? ?? ?? ?? 90 8D 74 26 00 83 FB 0F 0F 87 2F 02 00 00 8D B4 26 00 00 00 00 8B 0C BD ?? ?? ?? ?? 83 3C 99 05 75 B3 F7 C6 03 00 00 00 0F 85 EC 01 00 00 8B 74 35 00 89 74 98 24 EB A3 90 8D 74 26 00 83 FB 01 76 D3 C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 89 00 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D B4 26 00 00 00 00 83 FB 04 76 A3 C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 88 00 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D B4 26 00 00 00 00 83 FB 0C 0F 86 6F FF FF FF C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 87 00 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 76 00 83 FB 06 0F 86 3F FF FF FF C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 86 00 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 76 00 83 FB 02 0F 86 0F FF FF FF C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 85 00 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 76 00 83 FB 04 0F 86 DF FE FF FF C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 84 00 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 76 00 83 FB 2D 0F 86 AF FE FF FF C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 83 00 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 76 00 83 FB 12 0F 86 7F FE FF FF C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 82 00 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 76 00 83 FB 05 0F 86 4F FE FF FF C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 80 00 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 76 00 83 FB 6E 0F 86 1F FE FF FF C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 81 00 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 65 C7 00 16 00 00 00 31 C0 90 8D 74 26 00 83 C4 2C 5B 5E 5F 5D C3 C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 8A 00 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 8C 00 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_191_1_0 {
	meta:
		name = "_nl_load_locale"
		size = 671
		refs = "002d __open_nocancel 004e __fxstat64 006f __libc_errno 00a4 __mmap 00c1 _dl_sysinfo 00d2 _nl_intern_locale_data 0101 free 013a __munmap 015d malloc 0191 __read_nocancel 01e8 _nl_category_name_sizes 01f8 _nl_category_name_idxs 0214 _nl_category_names 021d mempcpy 0243 memcpy"
	strings:
		$1 = { 55 89 E5 57 56 89 C6 53 81 EC AC 00 00 00 C7 40 04 01 00 00 00 C7 40 08 00 00 00 00 C7 44 24 04 00 00 08 00 8B 00 89 55 80 89 04 24 E8 ?? ?? ?? ?? 85 C0 0F 88 B0 00 00 00 89 C3 8D 45 88 89 44 24 08 89 5C 24 04 C7 04 24 03 00 00 00 E8 ?? ?? ?? ?? 85 C0 0F 88 C2 00 00 00 8B 45 98 25 00 F0 00 00 3D 00 40 00 00 0F 84 5C 01 00 00 8B 15 ?? ?? ?? ?? 8B 45 B4 65 8B 12 C7 44 24 14 00 00 00 00 89 5C 24 10 C7 44 24 0C 02 00 00 00 C7 44 24 08 01 00 00 00 89 44 24 04 C7 04 24 00 00 00 00 89 55 84 E8 ?? ?? ?? ?? 83 F8 FF 89 C7 0F 84 8D 00 00 00 C7 45 84 01 00 00 00 B8 06 00 00 00 FF 15 ?? ?? ?? ?? 85 FF 74 20 8B 4D B4 89 FA 8B 45 80 E8 ?? ?? ?? ?? 85 C0 74 4F 8B 5D 84 C7 00 00 00 00 00 89 58 0C 89 46 08 8D 65 F4 5B 5E 5F 5D C3 8B BD 7C FF FF FF 89 85 74 FF FF FF 89 3C 24 E8 ?? ?? ?? ?? 8B 85 74 FF FF FF 85 C0 75 0D 8B 15 ?? ?? ?? ?? 65 C7 02 16 00 00 00 B8 06 00 00 00 FF 15 ?? ?? ?? ?? EB C0 83 7D 84 01 75 BA 8B 45 B4 89 3C 24 89 44 24 04 E8 ?? ?? ?? ?? EB A9 8B 15 ?? ?? ?? ?? 65 83 3A 26 0F 85 41 01 00 00 8B 55 B4 89 14 24 89 95 74 FF FF FF E8 ?? ?? ?? ?? 8B 95 74 FF FF FF 85 C0 89 C7 0F 84 14 01 00 00 85 D2 7E 3C 89 B5 78 FF FF FF 89 D7 89 C6 89 85 7C FF FF FF 89 7C 24 08 89 74 24 04 89 1C 24 E8 ?? ?? ?? ?? 85 C0 0F 8E 54 FF FF FF 29 C7 01 C6 85 FF 7F E0 8B BD 7C FF FF FF 8B B5 78 FF FF FF 8B 45 84 8B 15 ?? ?? ?? ?? C7 45 84 00 00 00 00 65 89 02 E9 F1 FE FF FF B8 06 00 00 00 FF 15 ?? ?? ?? ?? 8B 3E 31 C0 83 C9 FF 8B 55 80 F2 AE F7 D1 8D 41 FF 0F B6 8A ?? ?? ?? ?? 8D 5C 08 24 83 E3 F0 29 DC 0F B6 9A ?? ?? ?? ?? 89 44 24 08 8B 06 8D 7C 24 27 83 E7 F0 89 3C 24 89 8D 74 FF FF FF 81 C3 ?? ?? ?? ?? 89 44 24 04 E8 ?? ?? ?? ?? C7 00 2F 53 59 53 83 C0 05 C6 40 FF 5F 8B 8D 74 FF FF FF 89 5C 24 04 89 04 24 83 C1 01 89 4C 24 08 E8 ?? ?? ?? ?? C7 44 24 04 00 00 08 00 89 3C 24 E8 ?? ?? ?? ?? 85 C0 89 C3 0F 88 88 FE FF FF 8D 55 88 89 54 24 08 89 44 24 04 C7 04 24 03 00 00 00 E8 ?? ?? ?? ?? 85 C0 0F 89 ED FD FF FF E9 97 FE FF FF C7 45 84 00 00 00 00 E9 29 FE FF FF C7 45 84 01 00 00 00 31 FF E9 1B FE FF FF }
	condition:
		$1
}

rule file_191_2_0 {
	meta:
		name = "_nl_unload_locale"
		size = 92
		refs = "001d free 0053 __munmap"
	strings:
		$1 = { 53 89 C3 83 EC 18 8B 50 10 85 D2 74 02 FF D2 8B 43 0C 85 C0 75 2A 8B 43 04 89 04 24 E8 ?? ?? ?? ?? 8B 43 0C 83 F8 02 74 0A 8B 03 89 04 24 E8 ?? ?? ?? ?? 89 1C 24 E8 ?? ?? ?? ?? 83 C4 18 5B C3 83 F8 01 75 DF 8B 43 08 89 44 24 04 8B 43 04 89 04 24 E8 ?? ?? ?? ?? 8B 43 0C EB C8 }
	condition:
		$1
}

rule file_192_0_0 {
	meta:
		name = "round_and_return"
		size = 573
		refs = "00d7 __mpn_rshift 0112 __libc_errno 01e1 __mpn_construct_long_double"
	strings:
		$1 = { 83 EC 3C 81 FA 02 C0 FF FF 89 5C 24 2C 8B 5C 24 48 89 74 24 30 89 C6 89 7C 24 34 8B 7C 24 40 89 4C 24 14 8B 4C 24 44 89 6C 24 38 0F 8D F1 00 00 00 B8 02 C0 FF FF 29 D0 83 F8 40 0F 8F A7 01 00 00 BD 01 00 00 00 D3 E5 31 C9 83 ED 01 85 FD 0F 95 C1 09 CB 83 F8 40 0F 84 B3 01 00 00 83 F8 1F 0F 8E 82 00 00 00 B9 01 C0 FF FF 29 D1 89 CA 83 E1 1F C1 FA 05 85 D2 8B 3C 96 8D 2C 95 00 00 00 00 74 22 01 F5 89 F2 89 6C 24 18 89 44 24 1C 90 31 C0 83 3A 00 0F 95 C0 83 C2 04 09 C3 39 EA 75 EF 8B 44 24 1C BA 01 00 00 00 D3 E2 83 EA 01 85 D7 0F 95 C2 83 E0 1F 89 44 24 0C 8D 46 04 0F B6 D2 C7 44 24 08 01 00 00 00 09 D3 89 44 24 04 89 34 24 89 4C 24 10 E8 ?? ?? ?? ?? 8B 4C 24 10 C7 46 04 00 00 00 00 EB 29 B9 01 C0 FF FF 8B 3E 29 D1 89 44 24 0C C7 44 24 08 02 00 00 00 89 74 24 04 89 34 24 89 4C 24 10 E8 ?? ?? ?? ?? 8B 4C 24 10 A1 ?? ?? ?? ?? BA 01 C0 FF FF 65 C7 00 22 00 00 00 0F A3 CF 73 4B 85 DB 8B 06 75 08 A8 01 0F 84 C3 00 00 00 8D 48 01 39 C8 89 0E 76 6A 83 46 04 01 75 64 83 C2 01 C7 44 24 0C 01 00 00 00 C7 44 24 08 02 00 00 00 89 74 24 04 89 34 24 89 54 24 10 E8 ?? ?? ?? ?? 8B 54 24 10 81 4E 04 00 00 00 80 81 FA 00 40 00 00 7E 43 8B 44 24 14 85 C0 75 1E D9 05 ?? ?? ?? ?? 8B 5C 24 2C 8B 74 24 30 8B 7C 24 34 8B 6C 24 38 83 C4 3C C3 8D 74 26 00 D9 05 ?? ?? ?? ?? EB E0 81 FA 01 C0 FF FF 75 C2 8B 4E 04 B8 02 C0 FF FF 85 C9 0F 48 D0 8B 44 24 14 89 74 24 40 8B 5C 24 2C 8B 74 24 30 8B 7C 24 34 8B 6C 24 38 89 44 24 48 89 54 24 44 83 C4 3C E9 ?? ?? ?? ?? 8D 76 00 A1 ?? ?? ?? ?? D9 EE 65 C7 00 22 00 00 00 EB 90 BB 01 00 00 00 D3 E3 83 EB 01 85 FB 0F 84 68 FF FF FF E9 26 FF FF FF 90 8B 7E 04 B9 1F 00 00 00 8B 16 C7 46 04 00 00 00 00 C7 06 00 00 00 00 85 FF 0F 95 C0 85 D2 0F 95 C2 09 D0 0F B6 C0 09 C3 E9 D4 FE FF FF }
	condition:
		$1
}

rule file_192_2_0 {
	meta:
		name = "____strtold_l_internal"
		size = 7643
		refs = "0034 strlen 028c _nl_C_locobj 0354 __correctly_grouped_prefixmb 062f _fpioconst_pow10 066f __tens 067c memcpy 06c2 __mpn_mul 075d __mpn_lshift 07e4 __mpn_cmp 08e1 __mpn_submul_1 090d __mpn_add_n 0b0a __libc_errno 0f7e __strncasecmp_l 19d3 ____strtoull_l_internal"
	strings:
		$1 = { 55 57 56 53 81 EC DC 10 00 00 8B 94 24 FC 10 00 00 8B 42 04 8B 94 24 F8 10 00 00 85 D2 0F 85 79 1D 00 00 31 ED C7 44 24 58 00 00 00 00 8B 78 24 89 3C 24 E8 ?? ?? ?? ?? 8B B4 24 FC 10 00 00 8B 9C 24 F0 10 00 00 C7 84 24 80 00 00 00 00 00 00 00 8B 4E 34 83 EB 01 89 44 24 60 90 8D 74 26 00 83 C3 01 0F BE 13 0F BE C2 F6 44 41 01 20 75 F0 80 FA 2D 89 D8 0F 84 7E 02 00 00 80 FA 2B C7 44 24 64 00 00 00 00 0F 84 F7 03 00 00 0F B6 07 84 C0 88 44 24 3C 0F 84 7E 12 00 00 3A 03 0F 85 DD 01 00 00 31 C0 EB 0A 90 3A 0C 03 0F 85 CF 01 00 00 83 C0 01 0F B6 0C 07 89 C6 84 C9 75 EA 0F B6 04 33 3C 2F 0F 8E B6 01 00 00 3C 39 0F 8F AE 01 00 00 8B B4 24 FC 10 00 00 80 FA 30 8B 76 38 89 74 24 38 0F 84 C0 09 00 00 8B 74 24 58 31 C0 85 F6 0F 94 C0 89 44 24 5C 0F 85 94 1C 00 00 89 5C 24 54 C7 44 24 44 0A 00 00 00 8B 74 24 38 0F BE C2 8B 0C 86 8D 42 D0 3C 09 76 55 83 7C 24 44 10 89 CE 0F 95 44 24 40 80 F9 60 0F 8F B0 09 00 00 80 7C 24 3C 00 74 25 0F B6 44 24 3C 38 03 0F 85 C9 01 00 00 31 C0 EB 09 3A 0C 03 0F 85 BC 01 00 00 83 C0 01 0F B6 0C 07 84 C9 75 EC 39 5C 24 54 75 0E 83 7C 24 44 10 0F 84 EC 09 00 00 8D 76 00 89 DE C7 44 24 40 00 00 00 00 8D 42 D0 3C 09 0F 86 63 01 00 00 83 7C 24 44 10 0F 84 40 01 00 00 8B 44 24 5C 85 C0 0F 84 D8 1A 00 00 85 ED 0F 85 55 1A 00 00 83 7C 24 40 01 19 C0 80 7C 24 3C 00 89 44 24 4C 74 26 0F B6 4C 24 3C 31 C0 38 0E 74 10 E9 5F 15 00 00 66 90 3A 0C 06 0F 85 D0 01 00 00 83 C0 01 0F B6 0C 07 84 C9 75 EC 8B 4C 24 40 03 74 24 60 89 5C 24 54 8B 5C 24 4C 89 7C 24 5C 89 74 24 3C 0F BE 06 29 F1 EB 3A 90 8D 74 26 00 8B 7C 24 38 0F BE D0 8B 14 97 89 54 24 48 83 EA 61 80 FA 05 0F 87 6A 09 00 00 83 FB FF 75 10 3C 30 89 F0 0F 95 C2 2B 44 24 3C 84 D2 0F 45 D8 83 C6 01 0F BE 06 8D 50 D0 80 FA 09 8D 2C 31 76 DA 83 7C 24 44 10 74 B9 8B 4C 24 38 89 5C 24 4C 8B 7C 24 5C 8B 5C 24 54 89 74 24 38 0F B6 14 81 C6 44 24 3C 00 80 FA 65 0F 85 26 02 00 00 83 7C 24 44 10 0F 84 1B 02 00 00 E9 52 01 00 00 8D 76 00 8D 42 D0 3C 09 0F 86 47 FE FF FF A1 ?? ?? ?? ?? 0F B6 04 90 3C 69 0F 84 C6 0C 00 00 3C 6E 0F 84 3C 0D 00 00 8B BC 24 F4 10 00 00 85 FF 0F 84 E1 00 00 00 8B B4 24 F0 10 00 00 D9 EE 8B 9C 24 F4 10 00 00 89 33 81 C4 DC 10 00 00 5B 5E 5F 5D C3 8B 4C 24 38 0F BE C2 8B 04 81 83 E8 61 3C 05 0F 87 AB FE FF FF 8D 76 00 83 44 24 40 01 0F BE 56 01 83 C6 01 E9 81 FE FF FF 83 C3 01 0F BE 50 01 C7 44 24 64 01 00 00 00 E9 7F FD FF FF 80 7C 24 40 00 0F 84 54 15 00 00 83 7C 24 44 10 89 F0 0F 94 C1 3C 65 75 12 84 C9 89 DE C7 44 24 40 00 00 00 00 0F 84 42 FE FF FF 8B 74 24 58 8B 7C 24 54 89 6C 24 0C 89 5C 24 04 89 74 24 08 89 3C 24 88 4C 24 30 E8 ?? ?? ?? ?? 8B 94 24 F4 10 00 00 0F B6 4C 24 30 85 D2 74 20 39 C7 0F 84 A0 17 00 00 89 84 24 F0 10 00 00 8B 94 24 F0 10 00 00 8B AC 24 F4 10 00 00 89 55 00 8B 44 24 64 85 C0 0F 85 8D 07 00 00 81 C4 DC 10 00 00 5B D9 EE 5E 5F 5D C3 8B 44 24 38 8B 6C 24 40 8B 14 90 83 7C 24 44 10 0F 94 44 24 3C 80 FA 70 0F 85 71 07 00 00 80 7C 24 3C 00 0F 84 66 07 00 00 C6 44 24 3C 01 0F BE 56 01 80 FA 2D 0F 84 BD 07 00 00 8D 4E 01 80 FA 2B 89 4C 24 38 C7 44 24 54 00 00 00 00 0F 84 03 0A 00 00 8D 42 D0 3C 09 0F 87 90 00 00 00 80 7C 24 3C 00 0F 85 2F 07 00 00 8B 44 24 54 85 C0 0F 84 36 0B 00 00 8B 4C 24 40 81 C1 83 13 00 00 89 4C 24 6C 89 74 24 68 8B 84 24 80 00 00 00 8B 4C 24 38 8B 74 24 6C 89 5C 24 5C 90 8D 74 26 00 8D 04 80 8D 44 42 D0 39 F0 89 84 24 80 00 00 00 0F 8F 10 17 00 00 83 C1 01 0F BE 11 8D 5A D0 80 FB 09 76 DC 89 4C 24 38 8B 4C 24 54 8B 5C 24 5C 8B 74 24 68 85 C9 74 1B F7 D8 89 84 24 80 00 00 00 EB 10 83 C3 01 0F BE 50 01 E9 FD FB FF FF 89 74 24 38 3B 6C 24 40 89 F0 7E 1D 80 7E FF 30 75 17 8D B4 26 00 00 00 00 83 E8 01 8D 14 28 29 F2 80 78 FF 30 74 F2 89 D5 85 ED 7E 0C 39 6C 24 40 0F 84 49 05 00 00 66 90 8B 84 24 F4 10 00 00 85 C0 74 0D 8B 44 24 38 8B B4 24 F4 10 00 00 89 06 85 ED 0F 84 A0 FE FF FF 8B 44 24 4C 85 C0 0F 84 05 06 00 00 0F B6 57 01 0F B6 37 0F B6 0B 88 54 24 38 EB 0B 8D 74 26 00 0F B6 4B 01 83 C3 01 89 F0 38 C8 75 F3 80 7C 24 38 00 74 24 0F B6 4B 01 3A 4C 24 38 75 E6 B8 01 00 00 00 EB 08 8D 76 00 3A 14 03 75 D7 83 C0 01 0F B6 14 07 84 D2 75 F0 8B 44 24 4C 03 44 24 60 8B BC 24 80 00 00 00 01 D8 89 44 24 50 8B 44 24 4C C1 E0 02 83 7C 24 44 10 0F 45 44 24 4C 2B 6C 24 4C 29 C7 89 BC 24 80 00 00 00 83 7C 24 44 10 0F 84 89 08 00 00 85 FF 0F 88 15 0B 00 00 89 E8 2B 44 24 40 39 F8 0F 4F C7 8B 5C 24 40 29 C7 89 BC 24 80 00 00 00 01 C3 89 D8 01 F8 3D 45 13 00 00 89 5C 24 40 0F 8F D2 12 00 00 81 FF AA EC FF FF 0F 8C 4A 05 00 00 8B 44 24 40 85 C0 0F 8F 06 06 00 00 8D 9C 24 A0 00 00 00 B8 18 00 00 00 8D 8C 24 88 00 00 00 BA 16 00 00 00 89 5C 24 3C 8D B4 24 80 00 00 00 8D 5C 24 7C C7 44 24 44 00 00 00 00 89 4C 24 4C 89 74 24 68 89 5C 24 5C 2B 6C 24 40 C6 44 24 6C 00 39 C5 89 6C 24 48 7E 0C 83 C2 02 89 54 24 48 C6 44 24 6C 01 8B 54 24 48 8D AC 24 B8 08 00 00 BE ?? ?? ?? ?? 8B 5C 24 3C 89 6C 24 54 C7 44 24 38 00 00 00 00 29 FA 89 D7 89 EA 89 5C 24 40 31 ED BB 01 00 00 00 EB 37 8B 6E 04 8B 06 89 14 24 89 54 24 2C 83 ED 02 8D 0C AD 00 00 00 00 8D 04 85 ?? ?? ?? ?? 89 4C 24 08 89 44 24 04 E8 ?? ?? ?? ?? 8B 54 24 2C 01 DB 83 C6 10 85 FF 74 62 85 DF 74 F3 31 DF 85 ED 74 BF 89 6C 24 10 8B 4C 24 40 89 54 24 0C 8B 46 04 83 E8 02 89 44 24 08 8B 06 89 0C 24 89 54 24 2C 8D 04 85 ?? ?? ?? ?? 89 44 24 04 E8 ?? ?? ?? ?? 8B 4E 04 8B 54 24 2C 8D 6C 0D FE 85 C0 0F 85 D8 04 00 00 89 D0 83 ED 01 8B 54 24 40 01 DB 83 C6 10 85 FF 89 44 24 40 75 9E 3B 54 24 3C 89 6C 24 38 0F 84 02 12 00 00 8B 44 24 60 8B 7C 24 58 8B 5C 24 68 8B 74 24 5C 89 44 24 08 8B 4C 24 3C 8B 54 24 48 8B 44 24 50 89 7C 24 0C 89 5C 24 04 89 34 24 E8 43 F6 FF FF 8B 7C 24 38 83 EF 01 0F BD 9C BC B8 08 00 00 89 7C 24 48 83 F3 1F 7E 40 8B 7C 24 54 8B 74 24 38 89 5C 24 0C 89 7C 24 04 89 74 24 08 89 3C 24 E8 ?? ?? ?? ?? 8B 44 24 7C 89 5C 24 0C 8B 5C 24 3C 89 44 24 08 89 5C 24 04 89 1C 24 E8 ?? ?? ?? ?? 85 C0 0F 85 34 09 00 00 8B 74 24 44 83 7C 24 38 01 89 B4 24 80 00 00 00 0F 84 47 0E 00 00 83 7C 24 38 02 0F 84 D5 0B 00 00 8B 5C 24 38 8B 44 24 7C 8B 74 24 38 8B 4C 24 48 83 EB 02 8B AC 9C B8 08 00 00 89 5C 24 40 8B 5C 24 54 29 C6 8B BC 8C B8 08 00 00 89 44 24 08 8D 04 B3 8B 74 24 3C 89 44 24 04 89 34 24 E8 ?? ?? ?? ?? 8B 54 24 7C 85 C0 7E 12 C7 84 94 A0 00 00 00 00 00 00 00 83 C2 01 89 54 24 7C 3B 54 24 38 0F 8C 49 0F 00 00 85 D2 7E 1C 8B 5C 24 3C 8D 44 93 FC 8D 94 24 9C 00 00 00 90 8B 08 83 E8 04 89 48 08 39 D0 75 F4 8B 74 24 38 8B 5C 24 44 C7 84 24 A0 00 00 00 00 00 00 00 C7 44 24 58 00 00 00 00 8B 8C B4 A0 00 00 00 C7 84 B4 B8 08 00 00 00 00 00 00 89 5C 24 50 8B 5C 24 38 8B 74 24 40 83 C3 01 89 5C 24 60 8B 5C 24 3C 8D 34 B3 89 74 24 5C 39 F9 BE FF FF FF FF 74 45 8B 5C 24 48 89 CA 8B 9C 9C A0 00 00 00 89 D8 F7 F7 89 C6 89 D1 89 E8 F7 E6 89 C3 EB 0E 8D 76 00 31 C0 39 EB 0F 92 C0 29 EB 29 C2 39 CA 77 0F 75 14 8B 44 24 40 3B 9C 84 A0 00 00 00 76 07 83 EE 01 01 F9 73 DB 8B 5C 24 54 8B 4C 24 60 89 74 24 0C 89 5C 24 04 8B 5C 24 3C 89 4C 24 08 89 1C 24 E8 ?? ?? ?? ?? 8B 5C 24 38 39 84 9C A0 00 00 00 74 1F 89 5C 24 0C 8B 5C 24 54 83 EE 01 89 5C 24 08 8B 5C 24 3C 89 5C 24 04 89 1C 24 E8 ?? ?? ?? ?? 8B 5C 24 48 8B 44 24 48 8B 8C 9C A0 00 00 00 8B 5C 24 38 85 C0 89 8C 9C A0 00 00 00 7E 1D 8B 44 24 5C 8D 94 24 9C 00 00 00 8D B6 00 00 00 00 8B 18 83 E8 04 89 58 08 39 D0 75 F4 8B 44 24 50 C7 84 24 A0 00 00 00 00 00 00 00 85 C0 0F 85 0D 09 00 00 85 F6 0F 84 2B 09 00 00 8B 9C 24 80 00 00 00 0F BD C6 BA 20 00 00 00 83 F0 1F 29 C2 29 C3 83 FA 40 89 9C 24 80 00 00 00 0F 8E 5F 12 00 00 8D 78 40 B9 E0 FF FF FF 89 7C 24 58 8B 7C 24 38 29 C1 89 F0 D3 E8 89 84 24 88 00 00 00 8B 8C BC A0 00 00 00 85 C9 8B 44 24 38 75 1D 8B 6C 24 38 85 ED 78 15 8B 54 24 3C EB 05 83 F8 FF 74 0A 83 E8 01 8B 3C 82 85 FF 74 F1 F7 D0 8B 4C 24 64 C1 E8 1F 0A 44 24 6C 8D 53 FF 89 34 24 0F B6 C0 89 44 24 08 B8 1F 00 00 00 2B 44 24 58 89 44 24 04 8B 44 24 4C E8 26 F1 FF FF E9 B6 F8 FF FF 8B 94 24 80 00 00 00 85 D2 0F 89 AA FA FF FF 89 5C 24 54 83 E8 01 8B 5C 24 40 89 7C 24 5C 0F B6 4C 24 3C 8B BC 24 FC 10 00 00 EB 54 90 8D 74 26 00 0F BE 10 83 EA 30 83 FA 09 0F 97 C2 84 D2 75 3C 80 38 30 0F 85 67 01 00 00 8B B4 24 80 00 00 00 83 ED 01 83 EB 01 80 F9 01 19 D2 83 E2 FD 8D 54 32 04 89 94 24 80 00 00 00 C1 EA 1F 84 D2 0F 84 3C 01 00 00 85 ED 0F 8E 34 01 00 00 83 E8 01 84 C9 74 AD 0F BE 30 8B 57 34 0F B7 14 72 66 C1 EA 0C 83 F2 01 83 E2 01 EB A3 0F BE 43 01 83 3C 86 78 0F 84 69 08 00 00 8B 4C 24 58 31 C0 85 C9 0F 94 C0 89 44 24 5C 0F 85 C6 12 00 00 89 5C 24 54 C7 44 24 44 0A 00 00 00 E9 72 08 00 00 8D 76 00 80 7C 24 40 00 0F 85 45 F6 FF FF 80 F9 66 0F 8E 7C F6 FF FF E9 37 F6 FF FF 8B BC 24 80 00 00 00 89 5C 24 50 E9 6A FA FF FF A1 ?? ?? ?? ?? 65 C7 00 22 00 00 00 8B 44 24 64 85 C0 0F 84 73 F8 FF FF 81 C4 DC 10 00 00 D9 EE 5B D9 E0 5E 5F 5D C3 89 74 24 38 E9 2B F7 FF FF 8B 44 24 54 85 C0 0F 84 8B 05 00 00 8B 4C 24 40 8D 0C 8D 3D 40 00 00 89 4C 24 6C E9 CB F8 FF FF 8B 4C 24 60 0F BE 04 0B 8D 48 D0 80 F9 09 0F 86 03 F6 FF FF 8B 4C 24 38 8B 04 81 83 E8 61 3C 05 0F 86 F1 F5 FF FF E9 94 F7 FF FF 89 5C 24 4C 8B 7C 24 5C 8B 5C 24 54 8B 54 24 48 E9 13 F8 FF FF 8D 46 02 0F BE 56 02 89 44 24 38 C7 44 24 54 01 00 00 00 E9 43 F8 FF FF 89 D0 8B 54 24 40 89 44 24 40 E9 C4 FA FF FF 89 5C 24 40 8B 7C 24 5C 8B 5C 24 54 E9 F7 F8 FF FF 8B 44 24 60 8D B4 24 A0 00 00 00 8B 7C 24 58 8D 9C 24 80 00 00 00 89 74 24 3C 8B 54 24 40 8D 74 24 7C 8B 4C 24 3C 89 44 24 08 8B 44 24 50 89 5C 24 04 89 7C 24 0C 89 34 24 89 5C 24 68 89 74 24 5C E8 59 F1 FF FF 8B 5C 24 7C 89 44 24 50 8B 84 24 80 00 00 00 85 C0 0F 8E EA 00 00 00 8D 94 24 B8 08 00 00 BF ?? ?? ?? ?? 8B 4C 24 3C BE 01 00 00 00 89 54 24 54 89 6C 24 38 EB 5C 89 6C 24 10 8B 07 89 4C 24 04 89 14 24 89 5C 24 08 8D 04 85 ?? ?? ?? ?? 89 44 24 0C 89 54 24 2C 89 4C 24 30 E8 ?? ?? ?? ?? 8B 54 24 2C 8B 4C 24 30 8B 5C 24 7C 01 EB 85 C0 89 5C 24 7C 75 07 83 EB 01 89 5C 24 7C 8B 84 24 80 00 00 00 89 CD 89 D1 89 EA 01 F6 83 C7 10 85 C0 74 4A 85 F0 74 F3 8B 6F 04 31 F0 89 84 24 80 00 00 00 83 ED 02 39 DD 7E 8D 89 4C 24 0C 89 5C 24 10 89 6C 24 08 8B 07 89 14 24 89 54 24 2C 89 4C 24 30 8D 04 85 ?? ?? ?? ?? 89 44 24 04 E8 ?? ?? ?? ?? 8B 4C 24 30 8B 54 24 2C EB 8B 3B 4C 24 54 8B 6C 24 38 75 1B 8B 74 24 3C 8D 04 9D 00 00 00 00 89 44 24 08 89 4C 24 04 89 34 24 E8 ?? ?? ?? ?? 8D 53 FF 89 DF 0F BD 84 94 A0 00 00 00 C1 E7 05 83 F0 1F 29 C7 81 FF 00 40 00 00 89 7C 24 44 0F 8F 48 0B 00 00 83 7C 24 44 40 0F 8E F0 02 00 00 8B 44 24 44 83 E8 40 89 C6 C1 FE 05 83 E0 1F 89 44 24 38 0F 85 87 03 00 00 8B 8C B4 A0 00 00 00 8D 46 FF 8B 9C B4 A4 00 00 00 8B 94 84 A0 00 00 00 C7 44 24 60 1F 00 00 00 89 8C 24 88 00 00 00 8D 8C 24 88 00 00 00 89 9C 24 8C 00 00 00 89 54 24 48 89 4C 24 4C 8B B4 24 A0 00 00 00 31 C9 85 F6 75 0F 8B 54 24 3C 90 83 C1 01 8B 1C 8A 85 DB 74 F6 8B 54 24 44 8B 5C 24 60 8B 74 24 48 83 EA 01 39 C1 0F 9C C0 39 6C 24 40 89 5C 24 04 89 34 24 0F 9C C1 09 C8 8B 4C 24 64 0F B6 C0 89 44 24 08 8B 44 24 4C E8 3E ED FF FF E9 CE F4 FF FF 8D 46 02 0F BE 56 02 89 44 24 38 E9 ED F5 FF FF 8B 94 24 FC 10 00 00 8B 44 24 50 8B 72 34 0F B6 10 0F BE C2 F6 44 46 01 10 75 1A 8B 4C 24 50 66 90 83 C1 01 0F B6 11 0F BE C2 F6 44 46 01 10 74 F0 89 4C 24 50 80 FA 30 75 19 8B 44 24 50 8D 76 00 83 C0 01 0F B6 10 80 FA 30 74 F5 89 44 24 50 0F BE C2 8D 50 D0 83 FA 09 0F 86 45 02 00 00 8B 8C 24 FC 10 00 00 8B 5C 24 50 8B 51 38 83 C3 01 8B 04 82 83 E8 57 8B 14 85 ?? ?? ?? ?? B9 20 00 00 00 89 74 24 3C 29 D1 D3 E0 8B 4C 24 40 89 84 24 8C 00 00 00 B8 1F 00 00 00 29 D0 8D 54 8A FB 01 FA BF 01 00 00 00 89 54 24 44 89 94 24 80 00 00 00 8D B4 26 00 00 00 00 83 ED 01 85 ED 7E 45 0F BE 13 8B 74 24 3C F6 44 56 01 10 75 07 03 5C 24 60 0F BE 13 8D 4A D0 83 F9 09 0F 87 70 03 00 00 89 CA 83 C3 01 83 F8 02 0F 8E 32 03 00 00 8D 48 FD 83 ED 01 D3 E2 83 E8 04 09 94 BC 88 00 00 00 85 ED 7F BB 83 FF 01 75 0B C7 84 24 88 00 00 00 00 00 00 00 8B 4C 24 64 8D 84 24 88 00 00 00 8B 54 24 44 C7 44 24 08 00 00 00 00 C7 44 24 04 00 00 00 00 C7 04 24 00 00 00 00 E8 E9 EB FF FF E9 79 F3 FF FF 8B 44 24 4C 2B 44 24 40 05 45 13 00 00 89 44 24 6C E9 C2 F4 FF FF C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 03 00 00 00 C7 44 24 04 ?? ?? ?? ?? 89 1C 24 E8 ?? ?? ?? ?? 85 C0 0F 85 1A F3 FF FF 8B 84 24 F4 10 00 00 85 C0 74 34 8D 73 03 83 C3 08 89 34 24 C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 05 00 00 00 C7 44 24 04 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 8C 24 F4 10 00 00 85 C0 0F 44 F3 89 31 8B 44 24 64 85 C0 0F 85 C8 08 00 00 D9 05 ?? ?? ?? ?? E9 E5 F2 FF FF C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 03 00 00 00 C7 44 24 04 ?? ?? ?? ?? 89 1C 24 E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_193_0_0 {
	meta:
		name = "getutmp"
		size = 138
	strings:
		$1 = { 83 EC 08 B8 80 01 00 00 89 7C 24 04 8B 7C 24 10 89 34 24 8B 74 24 0C F7 C7 01 00 00 00 75 39 F7 C7 02 00 00 00 75 51 89 C1 31 D2 C1 E9 02 A8 02 F3 A5 74 0B 0F B7 16 66 89 17 BA 02 00 00 00 A8 01 74 07 0F B6 04 16 88 04 17 8B 34 24 8B 7C 24 04 83 C4 08 C3 8D 76 00 0F B6 06 83 C7 01 83 C6 01 88 47 FF F7 C7 02 00 00 00 B8 7F 01 00 00 74 B6 8D B4 26 00 00 00 00 0F B7 16 83 C7 02 83 C6 02 83 E8 02 66 89 57 FE EB 9D }
	condition:
		$1
}

rule file_194_0_0 {
	meta:
		name = "__sysv_signal"
		size = 187
		refs = "0036 __libc_errno 00a4 __sigaction"
	strings:
		$1 = { 81 EC 3C 01 00 00 83 BC 24 44 01 00 00 FF 89 9C 24 30 01 00 00 8B 94 24 40 01 00 00 89 B4 24 34 01 00 00 89 BC 24 38 01 00 00 74 09 85 D2 7E 05 83 FA 40 7E 33 A1 ?? ?? ?? ?? 65 C7 00 16 00 00 00 B8 FF FF FF FF 8B 9C 24 30 01 00 00 8B B4 24 34 01 00 00 8B BC 24 38 01 00 00 81 C4 3C 01 00 00 C3 8D B6 00 00 00 00 8B 84 24 44 01 00 00 8D 5C 24 1C B9 20 00 00 00 89 DF 8D 74 24 18 C7 84 24 9C 00 00 00 00 00 00 E0 89 44 24 18 31 C0 F3 AB 8D 84 24 A4 00 00 00 89 14 24 89 44 24 08 89 74 24 04 E8 ?? ?? ?? ?? 89 C2 B8 FF FF FF FF 85 D2 0F 49 84 24 A4 00 00 00 EB 8B }
	condition:
		$1
}

rule file_196_0_0 {
	meta:
		name = "__getsockopt"
		size = 34
		refs = "0012 _dl_sysinfo 001d __syscall_error"
	strings:
		$1 = { 89 DA B8 66 00 00 00 BB 0F 00 00 00 8D 4C 24 04 FF 15 ?? ?? ?? ?? 89 D3 83 F8 83 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_197_0_0 {
	meta:
		name = "posix_spawnattr_setschedpolicy"
		size = 29
	strings:
		$1 = { 8B 54 24 08 B8 16 00 00 00 83 FA 02 76 02 F3 C3 8B 44 24 04 89 90 0C 01 00 00 31 C0 C3 }
	condition:
		$1
}

rule file_199_0_0 {
	meta:
		name = "erand48"
		size = 39
		refs = "0013 __libc_drand48_data 001b __erand48_r"
	strings:
		$1 = { 83 EC 2C 8D 44 24 18 89 44 24 08 8B 44 24 30 C7 44 24 04 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? DD 44 24 18 83 C4 2C C3 }
	condition:
		$1
}

rule file_200_0_0 {
	meta:
		name = "__fstat"
		size = 35
		refs = "001b __fxstat"
		altNames = "fstat64"
	strings:
		$1 = { 83 EC 1C 8B 44 24 24 C7 04 24 03 00 00 00 89 44 24 08 8B 44 24 20 89 44 24 04 E8 ?? ?? ?? ?? 83 C4 1C C3 }
	condition:
		$1
}

rule file_804_0_0 {
	meta:
		name = "__lstat"
		size = 35
		refs = "001b __lxstat"
	strings:
		$1 = { 83 EC 1C 8B 44 24 24 C7 04 24 03 00 00 00 89 44 24 08 8B 44 24 20 89 44 24 04 E8 ?? ?? ?? ?? 83 C4 1C C3 }
	condition:
		$1
}

rule file_953_0_0 {
	meta:
		name = "__stat"
		size = 35
		refs = "001b __xstat"
	strings:
		$1 = { 83 EC 1C 8B 44 24 24 C7 04 24 03 00 00 00 89 44 24 08 8B 44 24 20 89 44 24 04 E8 ?? ?? ?? ?? 83 C4 1C C3 }
	condition:
		$1
}

rule file_592_0_0 {
	meta:
		name = "lstat64"
		size = 35
		refs = "001b __lxstat64"
	strings:
		$1 = { 83 EC 1C 8B 44 24 24 C7 04 24 03 00 00 00 89 44 24 08 8B 44 24 20 89 44 24 04 E8 ?? ?? ?? ?? 83 C4 1C C3 }
	condition:
		$1
}

rule file_603_0_0 {
	meta:
		name = "stat64"
		size = 35
		refs = "001b __xstat64"
	strings:
		$1 = { 83 EC 1C 8B 44 24 24 C7 04 24 03 00 00 00 89 44 24 08 8B 44 24 20 89 44 24 04 E8 ?? ?? ?? ?? 83 C4 1C C3 }
	condition:
		$1
}

rule file_201_0_0 {
	meta:
		name = "revoke"
		size = 18
		refs = "0001 __libc_errno"
		altNames = "__sigreturn fattach fdetach lchmod setlogin sstk"
	strings:
		$1 = { A1 ?? ?? ?? ?? 65 C7 00 26 00 00 00 B8 FF FF FF FF C3 }
	condition:
		$1
}

rule file_202_0_0 {
	meta:
		name = "_IO_obstack_xsputn"
		size = 169
		refs = "004a memcpy 0080 _obstack_newchunk 00a0 mempcpy"
	strings:
		$1 = { 83 EC 1C 89 74 24 14 8B 74 24 20 89 7C 24 18 8B 7C 24 28 89 5C 24 10 8B 46 14 8B 56 18 8B 9E 98 00 00 00 8D 0C 38 39 CA 73 66 29 D0 03 43 0C 8D 14 38 39 53 10 89 43 0C 72 3E 8B 54 24 24 89 7C 24 08 89 04 24 89 54 24 04 E8 ?? ?? ?? ?? 8B 43 0C 8B 53 08 01 F8 89 46 14 8B 43 10 89 56 10 89 46 18 89 43 0C 89 F8 8B 5C 24 10 8B 74 24 14 8B 7C 24 18 83 C4 1C C3 90 89 7C 24 04 89 1C 24 E8 ?? ?? ?? ?? 8B 43 0C EB B1 8D B4 26 00 00 00 00 8B 54 24 24 89 7C 24 08 89 04 24 89 54 24 04 E8 ?? ?? ?? ?? 89 46 14 EB BC }
	condition:
		$1
}

rule file_202_1_0 {
	meta:
		name = "_IO_obstack_overflow"
		size = 139
		refs = "0039 _obstack_newchunk 0087 __assert_fail"
	strings:
		$1 = { 83 EC 2C 8B 44 24 34 89 74 24 28 8B 74 24 30 89 5C 24 24 83 F8 FF 8B 9E 98 00 00 00 74 49 8B 53 0C 8D 4A 01 3B 4B 10 76 1E C7 44 24 04 01 00 00 00 89 1C 24 89 44 24 1C E8 ?? ?? ?? ?? 8B 53 0C 8B 44 24 1C 8D 4A 01 88 02 8B 53 08 89 4E 14 89 56 10 8B 53 10 89 56 18 8B 74 24 28 89 53 0C 8B 5C 24 24 83 C4 2C C3 C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 2F 00 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_202_2_0 {
	meta:
		name = "_IO_obstack_vprintf"
		size = 426
		refs = "0059 _IO_no_init 006d _IO_obstack_jumps 0099 _IO_str_init_static_internal 00e9 _IO_vfprintf 012c _obstack_newchunk 015e __assert_fail"
	strings:
		$1 = { 81 EC DC 00 00 00 89 9C 24 CC 00 00 00 8B 9C 24 E0 00 00 00 89 B4 24 D0 00 00 00 8D 74 24 24 C7 44 24 10 00 00 00 00 C7 44 24 0C 00 00 00 00 C7 44 24 08 FF FF FF FF C7 44 24 04 00 80 00 00 89 34 24 89 BC 24 D4 00 00 00 89 AC 24 D8 00 00 00 C7 44 24 6C 00 00 00 00 E8 ?? ?? ?? ?? 8B 53 10 8B 4B 0C 8B 43 08 C7 84 24 B8 00 00 00 ?? ?? ?? ?? 89 D5 89 D7 29 CD 29 C7 75 0E 83 FD 3F 0F 8E 9C 00 00 00 8B 43 08 89 EF 89 44 24 04 89 4C 24 0C 89 7C 24 08 89 34 24 E8 ?? ?? ?? ?? 8B 54 24 34 8B 44 24 3C 29 D0 39 F8 0F 85 D7 00 00 00 8B 43 0C 89 C1 2B 4B 08 01 CA 39 54 24 38 0F 85 9F 00 00 00 01 C5 8B 84 24 E8 00 00 00 89 6B 0C 89 34 24 89 9C 24 BC 00 00 00 89 44 24 08 8B 84 24 E4 00 00 00 89 44 24 04 E8 ?? ?? ?? ?? 8B 54 24 38 2B 54 24 3C 8B B4 24 D0 00 00 00 01 53 0C 8B BC 24 D4 00 00 00 8B 9C 24 CC 00 00 00 8B AC 24 D8 00 00 00 81 C4 DC 00 00 00 C3 90 8D 74 26 00 C7 44 24 04 40 00 00 00 89 1C 24 E8 ?? ?? ?? ?? 8B 4B 0C 8B 6B 10 29 CD 0F 85 46 FF FF FF C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 97 00 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 A2 00 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 9F 00 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_203_0_0 {
	meta:
		name = "skip"
		size = 217
	strings:
		$1 = { 57 89 C7 56 53 0F B6 08 0F BE D1 85 D2 74 57 31 F6 EB 3B 90 8D 74 26 00 83 FE 01 74 53 0F B6 18 83 C7 01 88 5F FF 83 FA 23 0F 84 99 00 00 00 83 FA 20 74 64 83 FA 09 74 5F 83 FA 0A 74 5A 89 C2 0F B6 4A 01 8D 42 01 0F BE D1 85 D2 74 18 83 FA 22 75 C5 89 C2 83 F6 01 0F B6 4A 01 8D 42 01 0F BE D1 85 D2 75 E8 C6 47 FF 00 5B 5E 5F C3 66 90 80 F9 5C 74 13 0F B6 08 89 C2 88 0F 83 C7 01 EB BF 8D B4 26 00 00 00 00 80 78 01 22 75 E7 8D 50 01 B9 22 00 00 00 EB E2 C6 00 00 83 C0 01 88 0D ?? ?? ?? ?? EB 05 66 90 83 C0 01 0F BE 10 83 FA 09 74 F5 83 FA 0A 74 F0 83 FA 20 74 EB 8D 76 00 EB A4 8D B6 00 00 00 00 C6 00 00 C6 47 FF 00 88 0D ?? ?? ?? ?? 5B 5E 5F C3 }
	condition:
		$1
}

rule file_203_1_0 {
	meta:
		name = "setttyent"
		size = 84
		refs = "0010 rewind 0030 _IO_new_fopen"
	strings:
		$1 = { 83 EC 1C A1 ?? ?? ?? ?? 85 C0 74 14 89 04 24 E8 ?? ?? ?? ?? B8 01 00 00 00 83 C4 1C C3 8D 76 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 A3 ?? ?? ?? ?? 74 13 81 08 00 80 00 00 B8 01 00 00 00 83 C4 1C C3 8D 74 26 00 31 C0 EB C5 }
	condition:
		$1
}

rule file_203_2_0 {
	meta:
		name = "getttyent"
		size = 706
		refs = "002c fgets_unlocked 0048 strchr 0052 __libc_tsd_CTYPE_B 00bf __uflow 00d1 setttyent"
	strings:
		$1 = { 55 57 56 53 83 EC 1C 8B 15 ?? ?? ?? ?? 85 D2 0F 84 BB 00 00 00 8D 76 00 89 54 24 08 C7 44 24 04 64 00 00 00 C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 0F 84 A1 00 00 00 C7 44 24 04 0A 00 00 00 C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 40 8B 2D ?? ?? ?? ?? B8 ?? ?? ?? ?? 0F B6 15 ?? ?? ?? ?? 65 8B 5D 00 0F BE CA F6 44 4B 01 20 74 10 83 C0 01 0F B6 10 0F BE CA F6 44 4B 01 20 75 F0 80 FA 23 75 5E 8B 15 ?? ?? ?? ?? EB 8B 8D 76 00 8B 15 ?? ?? ?? ?? EB 1B 0F B6 01 83 C1 01 89 4A 04 83 F8 0A 0F 84 6E FF FF FF 83 F8 FF 0F 84 65 FF FF FF 8B 4A 04 3B 4A 08 72 DD 89 14 24 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? EB D6 90 8D 74 26 00 E8 ?? ?? ?? ?? 85 C0 75 AC 31 C0 83 C4 1C 5B 5E 5F 5D C3 84 D2 74 9E C6 05 ?? ?? ?? ?? 00 A3 ?? ?? ?? ?? E8 C8 FD FF FF A3 ?? ?? ?? ?? 89 C3 80 38 00 0F 85 84 01 00 00 C7 05 ?? ?? ?? ?? 00 00 00 00 C7 05 ?? ?? ?? ?? 00 00 00 00 C7 05 ?? ?? ?? ?? 00 00 00 00 C7 05 ?? ?? ?? ?? 00 00 00 00 0F B6 03 84 C0 75 2F EB 73 8D B4 26 00 00 00 00 0F BE 4B 03 65 8B 55 00 F6 44 4A 01 20 74 27 83 25 ?? ?? ?? ?? FE 89 D8 E8 63 FD FF FF 89 C3 0F B6 00 84 C0 74 46 89 DE BF ?? ?? ?? ?? B9 03 00 00 00 F3 A6 74 CA BF ?? ?? ?? ?? 89 DE B9 02 00 00 00 F3 A6 75 52 0F BE 4B 02 65 8B 55 00 F6 44 4A 01 20 74 43 89 D8 83 0D ?? ?? ?? ?? 01 E8 1D FD FF FF 89 C3 0F B6 00 84 C0 75 BA 80 3D ?? ?? ?? ?? 23 0F 85 9A 00 00 00 8D B4 26 00 00 00 00 83 C3 01 0F BE 03 83 F8 20 74 F5 83 F8 09 74 F0 E9 7E 00 00 00 8D 76 00 BF ?? ?? ?? ?? B9 06 00 00 00 89 DE F3 A6 75 20 0F BE 4B 06 65 8B 55 00 F6 44 4A 01 20 74 11 83 0D ?? ?? ?? ?? 02 E9 53 FF FF FF 90 8D 74 26 00 BF ?? ?? ?? ?? B9 06 00 00 00 89 DE F3 A6 75 26 80 7B 06 3D 75 20 C7 44 24 04 3D 00 00 00 89 1C 24 E8 ?? ?? ?? ?? 83 F8 01 83 D8 FF A3 ?? ?? ?? ?? E9 18 FF FF FF 80 3D ?? ?? ?? ?? 23 0F 84 75 FF FF FF 3C 23 0F 84 6D FF FF FF 89 1D ?? ?? ?? ?? 80 3B 00 75 0A C7 05 ?? ?? ?? ?? 00 00 00 00 C7 44 24 04 0A 00 00 00 89 1C 24 E8 ?? ?? ?? ?? 85 C0 74 30 C6 00 00 83 C4 1C B8 ?? ?? ?? ?? 5B 5E 5F 5D C3 E8 2F FC FF FF A3 ?? ?? ?? ?? 89 C3 80 38 00 75 19 C7 05 ?? ?? ?? ?? 00 00 00 00 E9 70 FE FF FF B8 ?? ?? ?? ?? E9 25 FE FF FF E8 05 FC FF FF 89 C3 E9 5A FE FF FF }
	condition:
		$1
}

rule file_203_3_0 {
	meta:
		name = "endttyent"
		size = 50
		refs = "0016 _IO_new_fclose"
	strings:
		$1 = { 8B 15 ?? ?? ?? ?? B8 01 00 00 00 85 D2 74 21 83 EC 1C 89 14 24 E8 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 00 00 00 00 83 F8 FF 0F 95 C0 83 C4 1C 0F B6 C0 F3 C3 }
	condition:
		$1
}

rule file_203_4_0 {
	meta:
		name = "getttynam"
		size = 58
		refs = "000a setttyent 001a strcmp 0023 getttyent 002e endttyent"
	strings:
		$1 = { 56 53 83 EC 14 8B 74 24 20 E8 ?? ?? ?? ?? EB 12 8B 03 89 34 24 89 44 24 04 E8 ?? ?? ?? ?? 85 C0 74 0B E8 ?? ?? ?? ?? 85 C0 89 C3 75 E3 E8 ?? ?? ?? ?? 83 C4 14 89 D8 5B 5E C3 }
	condition:
		$1
}

rule file_204_0_0 {
	meta:
		name = "quotactl"
		size = 43
		refs = "0019 _dl_sysinfo 0026 __syscall_error"
	strings:
		$1 = { 56 53 8B 74 24 18 8B 54 24 14 8B 4C 24 10 8B 5C 24 0C B8 83 00 00 00 FF 15 ?? ?? ?? ?? 5B 5E 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_205_0_0 {
	meta:
		name = "__strchrnul"
		size = 351
	strings:
		$1 = { 57 8B 44 24 08 8B 54 24 0C 88 D6 89 D1 C1 E2 10 66 89 CA A8 03 74 4C 8A 08 38 CA 0F 84 3C 01 00 00 84 C9 0F 84 34 01 00 00 40 A8 03 74 35 8A 08 38 CA 0F 84 25 01 00 00 84 C9 0F 84 1D 01 00 00 40 A8 03 74 1E 8A 08 38 CA 0F 84 0E 01 00 00 84 C9 0F 84 06 01 00 00 40 EB 09 8D B6 00 00 00 00 83 C0 10 8B 08 31 D1 BF FF FE FE FE 01 CF 0F 83 CB 00 00 00 31 CF 81 CF FF FE FE FE 47 0F 85 BC 00 00 00 31 D1 BF FF FE FE FE 01 CF 0F 83 AD 00 00 00 31 CF 81 CF FF FE FE FE 47 0F 85 9E 00 00 00 8B 48 04 31 D1 BF FF FE FE FE 01 CF 0F 83 89 00 00 00 31 CF 81 CF FF FE FE FE 47 75 7E 31 D1 BF FF FE FE FE 01 CF 73 73 31 CF 81 CF FF FE FE FE 47 75 68 8B 48 08 31 D1 BF FF FE FE FE 01 CF 73 57 31 CF 81 CF FF FE FE FE 47 75 4C 31 D1 BF FF FE FE FE 01 CF 73 41 31 CF 81 CF FF FE FE FE 47 75 36 8B 48 0C 31 D1 BF FF FE FE FE 01 CF 73 25 31 CF 81 CF FF FE FE FE 47 75 1A 31 D1 BF FF FE FE FE 01 CF 73 0F 31 CF 81 CF FF FE FE FE 47 0F 84 2A FF FF FF 83 C0 04 83 C0 04 83 C0 04 84 C9 74 1A 38 D1 74 16 40 84 ED 74 11 38 D5 74 0D 40 C1 E9 10 84 C9 74 05 38 D1 74 01 40 5F C3 }
	condition:
		$1
}

rule file_206_0_0 {
	meta:
		name = "__waitid"
		size = 174
		refs = "0035 _dl_sysinfo 005a __libc_errno 0069 __libc_enable_asynccancel 0098 __libc_disable_asynccancel"
	strings:
		$1 = { 83 EC 1C 89 5C 24 0C 89 74 24 10 89 7C 24 14 89 6C 24 18 65 8B 3D 0C 00 00 00 85 FF 75 4A 8B 5C 24 20 8B 4C 24 24 8B 54 24 28 8B 74 24 2C B8 1C 01 00 00 FF 15 ?? ?? ?? ?? 3D 00 F0 FF FF 77 18 89 C7 89 F8 8B 5C 24 0C 8B 74 24 10 8B 7C 24 14 8B 6C 24 18 83 C4 1C C3 8B 15 ?? ?? ?? ?? F7 D8 65 89 02 83 C8 FF EB D8 E8 ?? ?? ?? ?? 31 FF 8B 5C 24 20 8B 4C 24 24 8B 54 24 28 8B 74 24 2C 89 C5 B8 1C 01 00 00 FF 15 ?? ?? ?? ?? 3D 00 F0 FF FF 77 0B 89 C7 89 E8 E8 ?? ?? ?? ?? EB A4 8B 15 ?? ?? ?? ?? F7 D8 65 89 02 83 C8 FF EB E5 }
	condition:
		$1
}

rule file_207_0_0 {
	meta:
		name = "__snprintf"
		size = 43
		refs = "0023 _IO_vsnprintf"
	strings:
		$1 = { 83 EC 1C 8D 44 24 2C 89 44 24 0C 8B 44 24 28 89 44 24 08 8B 44 24 24 89 44 24 04 8B 44 24 20 89 04 24 E8 ?? ?? ?? ?? 83 C4 1C C3 }
	condition:
		$1
}

rule file_214_0_0 {
	meta:
		name = "__asprintf_chk"
		size = 43
		refs = "0023 __vasprintf_chk"
	strings:
		$1 = { 83 EC 1C 8D 44 24 2C 89 44 24 0C 8B 44 24 28 89 44 24 08 8B 44 24 24 89 44 24 04 8B 44 24 20 89 04 24 E8 ?? ?? ?? ?? 83 C4 1C C3 }
	condition:
		$1
}

rule file_1066_0_0 {
	meta:
		name = "__dprintf_chk"
		size = 43
		refs = "0023 __vdprintf_chk"
	strings:
		$1 = { 83 EC 1C 8D 44 24 2C 89 44 24 0C 8B 44 24 28 89 44 24 08 8B 44 24 24 89 44 24 04 8B 44 24 20 89 04 24 E8 ?? ?? ?? ?? 83 C4 1C C3 }
	condition:
		$1
}

rule file_1390_1_0 {
	meta:
		name = "__obstack_printf_chk"
		size = 43
		refs = "0023 __obstack_vprintf_chk"
	strings:
		$1 = { 83 EC 1C 8D 44 24 2C 89 44 24 0C 8B 44 24 28 89 44 24 08 8B 44 24 24 89 44 24 04 8B 44 24 20 89 04 24 E8 ?? ?? ?? ?? 83 C4 1C C3 }
	condition:
		$1
}

rule file_1426_0_0 {
	meta:
		name = "__swprintf"
		size = 43
		refs = "0023 __vswprintf"
	strings:
		$1 = { 83 EC 1C 8D 44 24 2C 89 44 24 0C 8B 44 24 28 89 44 24 08 8B 44 24 24 89 44 24 04 8B 44 24 20 89 04 24 E8 ?? ?? ?? ?? 83 C4 1C C3 }
	condition:
		$1
}

rule file_892_10_0 {
	meta:
		name = "__syslog_chk"
		size = 43
		refs = "0023 __vsyslog_chk"
	strings:
		$1 = { 83 EC 1C 8D 44 24 2C 89 44 24 0C 8B 44 24 28 89 44 24 08 8B 44 24 24 89 44 24 04 8B 44 24 20 89 04 24 E8 ?? ?? ?? ?? 83 C4 1C C3 }
	condition:
		$1
}

rule file_208_0_0 {
	meta:
		name = "wcwidth"
		size = 114
		refs = "0004 _nl_current_LC_CTYPE"
	strings:
		$1 = { 83 EC 08 A1 ?? ?? ?? ?? 89 1C 24 8B 5C 24 0C 89 74 24 04 65 8B 00 89 DA 8B 00 8B 40 54 8B 08 D3 EA 3B 50 04 73 08 8B 54 90 14 85 D2 75 12 B8 FF FF FF FF 8B 1C 24 8B 74 24 04 83 C4 08 C3 66 90 8B 48 08 89 DE D3 EE 8B 48 0C 21 F1 8D 14 8A 8B 14 10 85 D2 74 D8 23 58 10 01 D0 0F B6 14 18 80 FA FF 0F B6 C2 74 C7 8B 1C 24 8B 74 24 04 83 C4 08 C3 }
	condition:
		$1
}

rule file_210_0_0 {
	meta:
		name = "__fcvt"
		size = 223
		refs = "0048 __fcvt_r 00c6 malloc"
	strings:
		$1 = { 83 EC 3C A1 ?? ?? ?? ?? 89 5C 24 30 F2 0F 10 44 24 40 8B 5C 24 48 89 74 24 34 8B 74 24 4C 89 7C 24 38 8B 7C 24 50 85 C0 74 3E 89 7C 24 10 F2 0F 11 04 24 89 74 24 0C 89 5C 24 08 C7 44 24 18 48 01 00 00 89 44 24 14 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 8B 5C 24 30 8B 74 24 34 8B 7C 24 38 83 C4 3C C3 8D B4 26 00 00 00 00 C7 44 24 18 14 00 00 00 F2 0F 11 04 24 F2 0F 11 44 24 20 C7 44 24 14 ?? ?? ?? ?? 89 7C 24 10 89 74 24 0C 89 5C 24 08 E8 ?? ?? ?? ?? F2 0F 10 44 24 20 83 F8 FF 74 19 B8 ?? ?? ?? ?? 8B 5C 24 30 8B 74 24 34 8B 7C 24 38 83 C4 3C C3 8D 74 26 00 C7 04 24 48 01 00 00 F2 0F 11 44 24 20 E8 ?? ?? ?? ?? F2 0F 10 44 24 20 85 C0 A3 ?? ?? ?? ?? 0F 85 4D FF FF FF EB C0 }
	condition:
		$1
}

rule file_210_1_0 {
	meta:
		name = "__ecvt"
		size = 64
		refs = "0033 __ecvt_r"
	strings:
		$1 = { 83 EC 2C 8B 44 24 40 DD 44 24 30 C7 44 24 18 14 00 00 00 DD 1C 24 C7 44 24 14 ?? ?? ?? ?? 89 44 24 10 8B 44 24 3C 89 44 24 0C 8B 44 24 38 89 44 24 08 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? 83 C4 2C C3 }
	condition:
		$1
}

rule file_210_2_0 {
	meta:
		name = "__gcvt"
		size = 58
		refs = "002f sprintf"
	strings:
		$1 = { 53 BA 11 00 00 00 83 EC 28 8B 44 24 38 8B 5C 24 3C DD 44 24 30 DD 5C 24 0C 83 F8 11 0F 4E D0 89 1C 24 89 54 24 08 C7 44 24 04 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 28 89 D8 5B C3 }
	condition:
		$1
}

rule file_211_0_0 {
	meta:
		name = "ualarm"
		size = 90
		refs = "003b __setitimer"
	strings:
		$1 = { 83 EC 3C 8B 44 24 40 C7 04 24 00 00 00 00 C7 44 24 18 00 00 00 00 C7 44 24 10 00 00 00 00 89 44 24 1C 8B 44 24 44 89 44 24 14 8D 44 24 20 89 44 24 08 8D 44 24 10 89 44 24 04 E8 ?? ?? ?? ?? BA FF FF FF FF 85 C0 78 0C 69 54 24 28 40 42 0F 00 03 54 24 2C 89 D0 83 C4 3C C3 }
	condition:
		$1
}

rule file_212_2_0 {
	meta:
		name = "svcraw_freeargs"
		size = 86
		refs = "0014 __rpc_thread_variables"
	strings:
		$1 = { 83 EC 0C 89 5C 24 04 8B 5C 24 14 89 74 24 08 8B 74 24 18 E8 ?? ?? ?? ?? 8B 80 B8 00 00 00 85 C0 74 26 C7 80 94 23 00 00 02 00 00 00 89 DA 05 94 23 00 00 89 74 24 14 8B 5C 24 04 8B 74 24 08 89 44 24 10 83 C4 0C FF E2 31 C0 8B 5C 24 04 8B 74 24 08 83 C4 0C C3 }
	condition:
		$1
}

rule file_212_3_0 {
	meta:
		name = "svcraw_getargs"
		size = 78
		refs = "0014 __rpc_thread_variables"
	strings:
		$1 = { 83 EC 0C 89 5C 24 04 8B 5C 24 14 89 74 24 08 8B 74 24 18 E8 ?? ?? ?? ?? 8B 80 B8 00 00 00 85 C0 74 1E 89 74 24 14 05 94 23 00 00 89 DA 8B 74 24 08 8B 5C 24 04 89 44 24 10 83 C4 0C FF E2 66 90 31 C0 8B 5C 24 04 8B 74 24 08 83 C4 0C C3 }
	condition:
		$1
}

rule file_212_4_0 {
	meta:
		name = "svcraw_reply"
		size = 125
		refs = "000c __rpc_thread_variables 004a xdr_replymsg"
	strings:
		$1 = { 83 EC 1C 89 5C 24 14 89 74 24 18 E8 ?? ?? ?? ?? 8B 98 B8 00 00 00 85 DB 74 38 8B 83 98 23 00 00 8D B3 94 23 00 00 C7 83 94 23 00 00 00 00 00 00 C7 44 24 04 00 00 00 00 89 34 24 FF 50 14 8B 44 24 24 89 34 24 89 44 24 04 E8 ?? ?? ?? ?? 85 C0 75 0E 31 C0 8B 5C 24 14 8B 74 24 18 83 C4 1C C3 8B 83 98 23 00 00 89 34 24 FF 50 10 B8 01 00 00 00 8B 5C 24 14 8B 74 24 18 83 C4 1C C3 }
	condition:
		$1
}

rule file_212_5_0 {
	meta:
		name = "svcraw_recv"
		size = 86
		refs = "0005 __rpc_thread_variables 0045 xdr_callmsg"
	strings:
		$1 = { 53 83 EC 18 E8 ?? ?? ?? ?? 8B 90 B8 00 00 00 31 C0 85 D2 74 3C 8B 82 98 23 00 00 8D 9A 94 23 00 00 C7 82 94 23 00 00 01 00 00 00 C7 44 24 04 00 00 00 00 89 1C 24 FF 50 14 8B 44 24 24 89 1C 24 89 44 24 04 E8 ?? ?? ?? ?? 85 C0 0F 95 C0 0F B6 C0 83 C4 18 5B C3 }
	condition:
		$1
}

rule file_212_6_0 {
	meta:
		name = "svcraw_create"
		size = 142
		refs = "0005 __rpc_thread_variables 005a xdrmem_create 0080 calloc"
	strings:
		$1 = { 53 83 EC 18 E8 ?? ?? ?? ?? 8B 98 B8 00 00 00 85 DB 74 5D 8D 83 AC 23 00 00 89 83 84 22 00 00 8D 83 94 23 00 00 C7 83 60 22 00 00 00 00 00 00 66 C7 83 64 22 00 00 00 00 C7 83 68 22 00 00 ?? ?? ?? ?? 89 04 24 C7 44 24 0C 02 00 00 00 C7 44 24 08 60 22 00 00 89 5C 24 04 E8 ?? ?? ?? ?? 8D 83 60 22 00 00 83 C4 18 5B C3 8D B4 26 00 00 00 00 C7 44 24 04 3C 25 00 00 C7 04 24 01 00 00 00 E8 ?? ?? ?? ?? 85 C0 89 C3 75 89 31 C0 EB D6 }
	condition:
		$1
}

rule file_213_0_0 {
	meta:
		name = "raise"
		size = 100
		refs = "001a _dl_sysinfo 0052 __libc_errno"
	strings:
		$1 = { 53 65 8B 1D 6C 00 00 00 65 8B 0D 68 00 00 00 85 C9 75 2D B8 E0 00 00 00 FF 15 ?? ?? ?? ?? 89 C1 65 A3 68 00 00 00 89 C3 8B 54 24 08 B8 0E 01 00 00 FF 15 ?? ?? ?? ?? 3D 00 F0 FF FF 77 12 5B C3 85 DB 7F E4 F7 C3 FF FF FF 7F 74 14 F7 DB EB D8 8B 15 ?? ?? ?? ?? F7 D8 65 89 02 83 C8 FF 5B C3 89 CB EB C4 }
	condition:
		$1
}

rule file_215_0_0 {
	meta:
		name = "plural_eval"
		size = 460
	strings:
		$1 = { 83 EC 1C 89 5C 24 0C 89 C3 8B 03 89 74 24 10 89 D6 89 7C 24 14 89 6C 24 18 83 F8 01 0F 84 86 00 00 00 0F 8E B0 00 00 00 83 F8 02 74 23 83 F8 03 74 56 31 F6 89 F0 8B 5C 24 0C 8B 74 24 10 8B 7C 24 14 8B 6C 24 18 83 C4 1C C3 8D B6 00 00 00 00 8B 43 08 89 F2 E8 A6 FF FF FF 8B 7B 04 83 FF 0F 89 C5 74 64 83 FF 0E 0F 85 93 00 00 00 85 C0 74 C1 8B 43 0C 89 F2 E8 85 FF FF FF 85 C0 0F 95 C0 0F B6 C0 89 C6 EB AD 90 8B 43 08 89 F2 E8 6E FF FF FF 83 F8 01 19 C0 F7 D0 8B 5C 83 10 8B 03 83 F8 01 0F 85 7A FF FF FF 8B 43 08 89 F2 E8 4E FF FF FF 85 C0 0F 94 C0 0F B6 C0 89 C6 E9 73 FF FF FF 8D B4 26 00 00 00 00 85 C0 74 5C BE 01 00 00 00 E9 5E FF FF FF 66 90 85 C0 0F 85 52 FF FF FF 8B 43 04 85 C0 0F 84 49 FF FF FF 83 F8 01 0F 85 3E FF FF FF 8B 73 08 E9 38 FF FF FF 8D 74 26 00 8B 43 0C 89 F2 83 EF 03 31 F6 E8 F1 FE FF FF 83 FF 0A 89 C1 0F 87 1A FF FF FF FF 24 BD ?? ?? ?? ?? 8D B4 26 00 00 00 00 8B 43 0C 89 F2 E8 CE FE FF FF 31 D2 85 C0 0F 95 C2 89 D6 E9 F4 FE FF FF 39 C5 0F 94 C0 0F B6 C0 89 C6 E9 E5 FE FF FF 31 D2 39 C5 0F 93 C2 89 D6 E9 D7 FE FF FF 39 C5 0F 96 C0 0F B6 C0 89 C6 E9 C8 FE FF FF 31 D2 39 C5 0F 97 C2 89 D6 E9 BA FE FF FF 39 C5 0F 92 C0 0F B6 C0 89 C6 E9 AB FE FF FF 89 EE 29 C6 E9 A2 FE FF FF 8D 34 28 E9 9A FE FF FF 89 E8 31 D2 F7 F1 89 D6 E9 8D FE FF FF 89 E8 31 D2 F7 F1 89 C6 E9 80 FE FF FF 89 C6 0F AF F5 E9 76 FE FF FF 31 D2 39 C5 0F 95 C2 89 D6 E9 68 FE FF FF }
	condition:
		$1
}

rule file_215_1_0 {
	meta:
		name = "plural_lookup"
		size = 101
		refs = "003b __rawmemchr"
	strings:
		$1 = { 57 89 CF 56 53 83 EC 10 8B 70 08 8B 46 60 E8 1D FE FF FF 89 FA 3B 46 64 8B 74 24 20 89 C3 B8 00 00 00 00 0F 43 D8 01 FE 85 DB 74 2C 89 14 24 83 EB 01 C7 44 24 04 00 00 00 00 E8 ?? ?? ?? ?? 8D 50 01 39 F2 72 E2 83 C4 10 89 F8 5B 5E 5F C2 04 00 8D B4 26 00 00 00 00 83 C4 10 89 D7 89 F8 5B 5E 5F C2 04 00 }
	condition:
		$1
}

rule file_215_2_0 {
	meta:
		name = "transcmp"
		size = 117
		refs = "0029 strcmp"
	strings:
		$1 = { 56 53 83 EC 14 8B 5C 24 24 8B 74 24 20 8B 53 10 85 D2 74 5C 8D 53 1C 8B 46 10 85 C0 74 4A 8D 46 1C 89 54 24 04 89 04 24 E8 ?? ?? ?? ?? 85 C0 75 30 8B 03 89 44 24 04 8B 06 89 04 24 E8 ?? ?? ?? ?? 85 C0 75 1C 8B 43 08 89 44 24 04 8B 46 08 89 04 24 E8 ?? ?? ?? ?? 85 C0 75 06 8B 46 04 2B 43 04 83 C4 14 5B 5E C3 90 8B 46 1C EB B4 8D 76 00 8B 53 1C EB A2 }
	condition:
		$1
}

rule file_215_9_0 {
	meta:
		name = "_nl_find_msg"
		size = 2415
		refs = "0043 strlen 0051 __hash_string 00dd strcmp 020e __pthread_rwlock_rdlock 0269 __pthread_rwlock_unlock 0311 _nl_load_domain 0345 _nl_current_LC_CTYPE 0366 __pthread_rwlock_wrlock 044c realloc 04a5 __gconv 04e5 malloc 0506 free 054a getenv 0631 __strdup 0675 _nl_find_msg 0690 strstr 06fd mempcpy 0748 _nl_C_locobj 07eb __gconv_open 0838 memcpy 0903 calloc"
	strings:
		$1 = { 55 89 E5 57 56 53 83 EC 5C 8B 58 04 89 45 B4 89 55 B0 89 4D C4 85 DB 0F 8E F3 02 00 00 8B 45 B4 8B 78 08 85 FF 0F 84 6D 01 00 00 8B 4F 30 8B 5F 14 85 C9 89 5D C8 0F 84 F4 00 00 00 8B 4D C4 89 0C 24 E8 ?? ?? ?? ?? 8B 4D C4 89 0C 24 89 45 BC E8 ?? ?? ?? ?? 8B 4F 2C 31 D2 89 C6 F7 F1 89 F0 8B 77 34 89 75 C0 89 CE 89 D3 8D 51 FE 89 55 D4 31 D2 F7 75 D4 8B 47 30 83 C2 01 29 D6 89 55 CC 29 CA 89 75 D4 89 55 B8 8B 55 C0 8B 34 98 85 D2 74 02 0F CE 85 F6 0F 84 FC 00 00 00 83 EE 01 39 75 C8 76 64 8B 57 0C 85 D2 89 55 AC 74 72 8B 4F 18 8B 14 F1 89 4D D0 0F CA 3B 55 BC 72 33 8B 4D D0 8B 07 8B 54 F1 04 8B 4D AC 85 C9 74 02 0F CA 01 D0 8B 4D C4 89 44 24 04 89 0C 24 E8 ?? ?? ?? ?? 85 C0 0F 94 C0 84 C0 0F 85 C2 00 00 00 8B 47 30 8B 55 B8 8B 4D CC 01 DA 01 D9 3B 5D D4 89 D3 0F 42 D9 EB 83 8D 76 00 8B 57 24 89 F1 2B 4D C8 8D 14 CA 8B 4D BC 3B 0A 73 D7 8B 42 04 EB B3 90 8B 57 18 89 55 D0 8B 14 F2 EB 8E 90 8D 74 26 00 8B 5D C8 31 F6 89 D9 EB 14 8D B4 26 00 00 00 00 89 F9 89 F7 0F 84 D6 01 00 00 8D 73 01 39 CE 73 47 8B 1F 8B 57 0C 89 75 D4 89 FE 89 CF 89 5D D0 89 55 CC 8B 5D D4 8B 4D CC 8B 46 18 01 FB D1 EB 85 C9 8B 44 D8 04 74 02 0F C8 8B 4D C4 03 45 D0 89 0C 24 89 44 24 04 E8 ?? ?? ?? ?? 83 F8 00 7D AF 3B 5D D4 89 DF 77 CB C7 45 D4 00 00 00 00 8B 45 D4 8D 65 F4 5B 5E 5F 5D C2 08 00 8D 74 26 00 89 75 C4 8B 5D C8 39 5D C4 0F 83 01 01 00 00 8B 57 0C 8B 07 85 D2 8B 57 1C 0F 84 29 01 00 00 8B 75 C4 8D 0C F2 8B 51 04 0F CA 01 C2 8B 01 89 55 D4 0F C8 83 C0 01 89 45 D0 8B 45 08 85 C0 0F 84 EE 00 00 00 8B 75 B0 85 F6 0F 84 29 01 00 00 8B 55 B0 8B 5A 08 85 DB 0F 84 1B 01 00 00 B8 ?? ?? ?? ?? 85 C0 74 0B 8D 47 40 89 04 24 E8 ?? ?? ?? ?? 8B 77 3C 85 F6 0F 84 C8 03 00 00 8B 47 38 8D 14 76 89 7D C0 8D 44 90 F4 89 C2 EB 0E 8D 76 00 85 F6 8D 57 F4 0F 84 0B 01 00 00 89 5C 24 04 8B 02 89 D7 83 EE 01 89 04 24 E8 ?? ?? ?? ?? 85 C0 75 DE 89 7D CC 8B 7D C0 BE ?? ?? ?? ?? 85 F6 74 08 8D 47 40 89 04 24 FF D6 8B 4D CC 85 C9 0F 84 E1 00 00 00 8B 75 CC 83 7E 04 FF 74 55 8B 46 08 85 C0 0F 84 07 06 00 00 83 F8 FF 0F 84 44 06 00 00 8B 5D C4 8B 04 98 85 C0 0F 84 3A 01 00 00 8D 78 04 8B 00 89 7D D4 89 45 D0 EB 26 8D 74 26 00 8B 55 C4 8B 47 28 2B 55 C8 8D 04 D0 8B 70 04 8B 00 89 75 D4 89 45 D0 8B 45 08 85 C0 0F 85 12 FF FF FF 8B 45 0C 8B 5D D0 89 18 8B 45 D4 8D 65 F4 5B 5E 5F 5D C2 08 00 90 8B 5D C4 8D 14 DA 03 42 04 89 45 D4 8B 02 83 C0 01 89 45 D0 EB C9 66 90 E8 ?? ?? ?? ?? E9 03 FD FF FF 8D B6 00 00 00 00 89 5D C4 E9 8B FE FF FF 8B 1D ?? ?? ?? ?? 85 DB 0F 84 0C 02 00 00 8B 1D ?? ?? ?? ?? 85 DB 0F 85 C9 FE FF FF A1 ?? ?? ?? ?? 65 8B 00 8B 00 8B 58 5C E9 B7 FE FF FF 8B 7D C0 C7 45 CC 00 00 00 00 E9 03 FF FF FF B8 ?? ?? ?? ?? 85 C0 74 0B 8D 47 40 89 04 24 E8 ?? ?? ?? ?? 8B 4F 3C 85 C9 89 4D BC 0F 84 C0 04 00 00 8B 55 BC 8B 4F 38 89 7D AC 89 5D C0 8D 04 52 8D 54 81 F4 89 4D B8 8B 4D BC 89 D3 89 CF EB 0D 66 90 83 EB 0C 85 FF 0F 84 4D 02 00 00 8B 45 C0 83 EF 01 89 5D CC 89 44 24 04 8B 03 89 04 24 E8 ?? ?? ?? ?? 85 C0 75 DA 8B 7D AC 85 F6 0F 84 AB FE FF FF 8D 47 40 89 04 24 E8 ?? ?? ?? ?? E9 9B FE FF FF B9 01 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 0D ?? ?? ?? ?? 0F 85 44 0C 00 00 8B 45 D4 31 DB 8B 15 ?? ?? ?? ?? 8B 7D CC 89 45 DC A1 ?? ?? ?? ?? 83 C0 04 89 45 E0 EB 57 8D 74 26 00 85 DB 0F 84 9E 00 00 00 83 C3 01 8B 35 ?? ?? ?? ?? 69 C3 F0 0F 00 00 89 34 24 89 44 24 04 A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 0F 84 A3 00 00 00 A3 ?? ?? ?? ?? 8D 50 04 83 C0 08 89 15 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 89 45 E0 83 EA 04 89 15 ?? ?? ?? ?? 83 FA 03 76 A8 8D 75 E4 8B 47 04 89 74 24 08 8B 75 E0 8B 4D D0 03 4D DC 8D 54 16 FC 89 54 24 04 8D 55 E0 89 14 24 8D 55 DC E8 ?? ?? ?? ?? 83 EC 0C A9 FB FF FF FF 0F 84 BB 00 00 00 83 F8 05 0F 85 10 01 00 00 8B 45 D4 85 DB 89 45 DC 0F 85 62 FF FF FF C7 04 24 F0 0F 00 00 BB 01 00 00 00 C7 05 ?? ?? ?? ?? F0 0F 00 00 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? 89 10 E9 62 FF FF FF 8B 06 89 34 24 A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 00 00 00 00 C7 05 ?? ?? ?? ?? 00 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 83 2D ?? ?? ?? ?? 01 0F 85 24 0B 00 00 C7 45 D4 FF FF FF FF E9 5D FC FF FF C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 89 C6 74 09 80 38 00 0F 85 B0 02 00 00 8B 1D ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 01 00 00 00 E9 CA FD FF FF A1 ?? ?? ?? ?? 8B 55 E0 8B 5D CC 8B 75 C4 29 C2 83 EA 04 89 10 8B 53 08 89 04 B2 8B 55 E0 29 D0 03 05 ?? ?? ?? ?? 89 C1 83 E0 FC 83 E1 03 01 CA 89 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? 65 83 3D 0C 00 00 00 00 74 01 F0 83 2D ?? ?? ?? ?? 01 0F 85 A5 0A 00 00 8B 43 08 8B 04 B0 E9 DF FC FF FF 65 83 3D 0C 00 00 00 00 74 01 F0 83 2D ?? ?? ?? ?? 01 0F 85 92 0A 00 00 C7 45 D4 00 00 00 00 E9 AB FB FF FF C7 45 CC 00 00 00 00 E9 68 FC FF FF 8B 7D AC 8B 5D C0 8B 55 BC 8B 4D B8 8D 44 52 03 C1 E0 02 89 44 24 04 89 0C 24 E8 ?? ?? ?? ?? 85 C0 0F 84 5D 02 00 00 89 47 38 89 1C 24 89 45 A8 E8 ?? ?? ?? ?? 8B 55 A8 85 C0 89 45 C0 0F 84 41 02 00 00 8B 5D BC B9 ?? ?? ?? ?? 8D 04 5B 8D 04 82 8B 55 C0 C7 40 04 FF FF FF FF 89 45 CC 89 10 8D 45 E4 8B 55 B0 89 44 24 04 8B 45 B4 C7 04 24 00 00 00 00 E8 ?? ?? ?? ?? 83 EC 08 85 C0 0F 84 76 01 00 00 C7 44 24 04 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 85 C0 0F 84 5E 01 00 00 0F B6 48 08 8D 58 08 31 D2 89 5D B8 84 C9 74 2E 89 7D B4 EB 0C 83 C2 01 0F B6 4C 10 08 84 C9 74 1A 8D 79 F7 89 FB 80 FB 17 88 5D BC 77 E7 BF 00 01 00 C0 89 D9 D3 E7 85 FF 79 DA 8B 7D B4 8D 42 1F 83 E0 F0 29 C4 8B 45 B8 8D 5C 24 1B 83 E3 F0 89 1C 24 89 54 24 08 89 44 24 04 89 5D BC 31 DB E8 ?? ?? ?? ?? C6 00 00 8B 45 C0 EB 0E 83 C0 01 80 FA 2F 0F 94 C2 0F B6 D2 01 D3 0F B6 10 84 D2 75 EB 2B 45 C0 83 C0 29 83 E0 F0 29 C4 8D 44 24 1B 83 E0 F0 89 45 B8 8B 45 C0 0F BE 10 8B 45 B8 84 D2 74 22 8B 4D C0 89 5D B4 8B 1D ?? ?? ?? ?? 83 C1 01 83 C0 01 8B 14 93 88 50 FF 0F BE 11 84 D2 75 E7 8B 5D B4 83 FB 01 0F 86 E7 00 00 00 C6 00 00 31 DB 8B 45 BC EB 0E 83 C0 01 80 FA 2F 0F 94 C2 0F B6 D2 01 D3 0F B6 10 84 D2 75 EB 2B 45 BC 8B 4D BC 83 C0 21 83 E0 F0 29 C4 8D 54 24 1B 83 E2 F0 89 55 B4 0F BE 11 8B 45 B4 84 D2 74 1F 89 5D BC 8B 1D ?? ?? ?? ?? 83 C1 01 83 C0 01 8B 14 93 88 50 FF 0F BE 11 84 D2 75 E7 8B 5D BC 83 FB 01 0F 86 93 00 00 00 8B 4D CC C6 00 00 8B 55 B4 8B 45 B8 C7 04 24 01 00 00 00 83 C1 04 E8 ?? ?? ?? ?? 83 EC 04 85 C0 0F 85 21 01 00 00 8B 5D CC C7 43 08 00 00 00 00 83 47 3C 01 E9 C4 FB FF FF 89 04 24 E8 ?? ?? ?? ?? 8D 50 01 89 14 24 89 55 A8 E8 ?? ?? ?? ?? 8B 55 A8 85 C0 89 C3 74 10 89 54 24 08 89 74 24 04 89 04 24 E8 ?? ?? ?? ?? 89 1D ?? ?? ?? ?? E9 1C FD FF FF 8B 57 38 89 55 B8 E9 B4 FD FF FF 85 DB C6 00 2F 8D 50 01 0F 84 F5 00 00 00 89 D0 E9 04 FF FF FF 85 DB C6 00 2F 8D 50 01 75 0C C6 40 01 2F 83 C0 02 E9 57 FF FF FF 89 D0 E9 50 FF FF FF 85 F6 74 5D 8D 47 40 89 04 24 E8 ?? ?? ?? ?? C7 45 D4 FF FF FF FF E9 00 F9 FF FF B9 01 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 0D ?? ?? ?? ?? 0F 85 CE 07 00 00 83 7E 08 00 74 2F 65 83 3D 0C 00 00 00 00 74 01 F0 83 2D ?? ?? ?? ?? 01 0F 85 C0 07 00 00 8B 7D CC 8B 47 08 E9 B3 F9 FF FF C7 45 D4 FF FF FF FF E9 AE F8 FF FF 8B 45 C8 C7 44 24 04 04 00 00 00 03 47 20 89 04 24 E8 ?? ?? ?? ?? 85 C0 89 46 08 0F 85 F4 FA FF FF C7 46 08 FF FF FF FF EB A7 83 C0 01 74 26 85 F6 74 0B 8D 47 40 89 04 24 E8 ?? ?? ?? ?? 8B 45 C0 89 04 24 E8 ?? ?? ?? ?? C7 45 D4 00 00 00 00 E9 59 F8 FF FF 8B 5D CC C7 43 04 FF FF FF FF E9 A5 FE FF FF C6 40 01 2F 83 C0 0A C7 40 F8 54 52 41 4E C7 40 FC 53 4C 49 54 E9 FC FD FF FF }
	condition:
		$1
}

rule file_215_10_0 {
	meta:
		name = "__dcigettext"
		size = 1754
		refs = "003d __pthread_rwlock_rdlock 0048 __libc_setlocale_lock 0051 _nl_state_lock 006c _nl_current_default_domain 0083 __current_locale_name 008d strlen 00af memcpy 00e0 __tfind 00e8 __pthread_rwlock_unlock 0106 _nl_msg_cat_cntr 0114 __libc_errno 011a _nl_domain_bindings 0153 strcmp 01d3 __getcwd 01f0 __rawmemchr 0202 strcpy 0213 _nl_category_name_idxs 0218 getenv 021e _nl_category_names 0284 stpcpy 02a2 mempcpy 0317 _nl_find_domain 033b _nl_find_msg 03dd __libc_enable_secure 03f7 strchr 04df _nl_default_dirname 05ce malloc 0662 __pthread_rwlock_wrlock 068d __tsearch 06be free"
	strings:
		$1 = { 55 89 E5 57 56 53 83 EC 7C 8B 4D 0C 85 C9 74 21 83 7D 1C 0C 77 06 83 7D 1C 06 75 20 8B 55 14 85 D2 74 0E 8B 45 0C 83 7D 18 01 0F 45 45 10 89 45 0C 8B 45 0C 8D 65 F4 5B 5E 5F 5D C3 BB ?? ?? ?? ?? 85 DB 74 12 C7 04 24 ?? ?? ?? ?? FF D3 C7 04 24 ?? ?? ?? ?? FF D3 8B 45 08 8B 55 08 C7 45 D8 00 00 00 00 85 C0 8B 45 0C 0F 44 15 ?? ?? ?? ?? 89 55 08 89 55 C8 8B 55 1C 89 45 E4 89 14 24 89 55 CC E8 ?? ?? ?? ?? 89 04 24 89 C6 E8 ?? ?? ?? ?? 8D 50 1F 83 E2 F0 29 D4 8D 54 24 1B 83 E2 F0 8D 48 01 89 4C 24 08 89 74 24 04 89 14 24 E8 ?? ?? ?? ?? 85 DB 89 45 A0 89 45 D0 74 0C C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 45 C8 C7 44 24 08 ?? ?? ?? ?? C7 44 24 04 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 89 45 A4 B8 ?? ?? ?? ?? 85 C0 74 09 C7 04 24 ?? ?? ?? ?? FF D0 8B 45 A4 85 C0 74 13 8B 45 A4 8B 10 A1 ?? ?? ?? ?? 39 42 0C 0F 84 F0 03 00 00 A1 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 65 8B 00 85 D2 89 55 B0 89 45 98 0F 84 AD 03 00 00 89 D3 8B 75 08 EB 12 66 90 0F 8C 97 03 00 00 8B 1B 85 DB 0F 84 AC 03 00 00 8D 43 0C 89 44 24 04 89 34 24 E8 ?? ?? ?? ?? 83 F8 00 75 DC 8B 53 04 89 5D B0 80 3A 2F 89 55 A8 0F 84 98 00 00 00 8B 45 A8 BF 02 10 00 00 BB 10 00 00 00 89 04 24 E8 ?? ?? ?? ?? 8D 70 01 89 75 B4 EB 1D 90 8D 74 26 00 8B 15 ?? ?? ?? ?? 65 83 3A 22 0F 85 D8 02 00 00 89 F8 D1 E8 8D 7C 07 20 8B 55 B4 8D 44 17 1E 31 D2 F7 F3 C1 E0 04 29 C4 A1 ?? ?? ?? ?? 8D 74 24 1B 83 E6 F0 65 C7 00 00 00 00 00 89 7C 24 04 89 34 24 E8 ?? ?? ?? ?? 85 C0 74 B5 8B 45 B0 89 75 A8 8B 58 04 C7 44 24 04 00 00 00 00 89 34 24 E8 ?? ?? ?? ?? C6 00 2F 83 C0 01 89 5C 24 04 89 04 24 E8 ?? ?? ?? ?? 8B 55 1C C7 04 24 ?? ?? ?? ?? 0F B6 B2 ?? ?? ?? ?? E8 ?? ?? ?? ?? 81 C6 ?? ?? ?? ?? 85 C0 89 C7 0F 84 97 02 00 00 80 38 00 0F 84 8E 02 00 00 8B 55 1C 89 14 24 E8 ?? ?? ?? ?? 80 38 43 89 C3 0F 84 9D 02 00 00 89 FB 8D 76 00 8B 45 08 89 04 24 E8 ?? ?? ?? ?? 89 34 24 89 45 9C E8 ?? ?? ?? ?? 8B 55 9C 8D 44 02 23 83 E0 F0 29 C4 8D 44 24 1B 83 E0 F0 89 74 24 04 89 04 24 89 45 AC E8 ?? ?? ?? ?? 66 C7 00 2F 00 8B 55 9C 83 C0 01 89 04 24 89 54 24 08 8B 55 08 89 54 24 04 E8 ?? ?? ?? ?? C7 00 2E 6D 6F 00 89 1C 24 E8 ?? ?? ?? ?? 83 C0 1F 83 E0 F0 29 C4 8D 44 24 1B 83 E0 F0 89 45 B4 66 90 0F B6 03 3C 3A 0F 84 4D 01 00 00 84 C0 8B 55 B4 0F 85 EE 00 00 00 C6 02 43 C6 42 01 00 8B 45 B4 80 78 01 00 0F 84 86 01 00 00 8B 75 B4 BF ?? ?? ?? ?? B9 06 00 00 00 F3 A6 0F 84 71 01 00 00 8B 55 B0 8B 4D AC 8B 45 A8 89 14 24 8B 55 B4 E8 ?? ?? ?? ?? 83 EC 04 85 C0 89 C6 74 A4 8B 4D 0C 8D 45 C4 8B 55 B0 89 44 24 04 89 F0 C7 04 24 01 00 00 00 E8 ?? ?? ?? ?? 83 EC 08 85 C0 0F 84 DE 00 00 00 89 C1 83 F9 FF 0F 84 23 01 00 00 8B 45 A4 85 C0 0F 84 12 02 00 00 8B 55 A4 8B 02 8B 15 ?? ?? ?? ?? 89 70 10 89 50 0C 8B 55 A4 8B 02 89 48 14 8B 02 8B 55 C4 89 50 18 8B 7D 14 8B 55 98 A1 ?? ?? ?? ?? 85 FF 65 89 10 0F 85 C1 01 00 00 B8 ?? ?? ?? ?? 85 C0 0F 84 26 03 00 00 89 4D 8C C7 04 24 ?? ?? ?? ?? FF D0 C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D 8C 89 4D 0C E9 6A FC FF FF 90 84 C0 74 10 83 C3 01 83 C2 01 88 42 FF 0F B6 03 3C 3A 75 EC A1 ?? ?? ?? ?? C6 02 00 85 C0 74 20 8B 45 B4 C7 44 24 04 2F 00 00 00 89 04 24 E8 ?? ?? ?? ?? 85 C0 0F 85 C5 FE FF FF 90 8D 74 26 00 8B 55 B4 0F B6 02 3C 43 0F 85 DC FE FF FF E9 CA FE FF FF 90 8D 74 26 00 83 C3 01 E9 A0 FE FF FF 8B 46 10 85 C0 8D 76 00 0F 84 92 FE FF FF 89 5D 94 31 FF 8B 5D B0 EB 0B 83 C7 01 8B 44 BE 10 85 C0 74 70 8B 4D 0C 8D 55 C4 89 54 24 04 89 DA C7 04 24 01 00 00 00 E8 ?? ?? ?? ?? 83 EC 08 85 C0 74 D6 89 C1 8B 74 BE 10 E9 D7 FE FF FF 8D 76 00 B8 ?? ?? ?? ?? 85 C0 74 18 C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 98 8B 15 ?? ?? ?? ?? 65 89 02 8B 45 14 85 C0 0F 85 73 FB FF FF 8B 45 0C 8D 65 F4 5B 5E 5F 5D C3 8B 5D 94 E9 05 FE FF FF 8B 45 1C 89 04 24 E8 ?? ?? ?? ?? 89 C3 E9 7B FD FF FF C7 45 B0 00 00 00 00 C7 45 A8 ?? ?? ?? ?? E9 1E FD FF FF 80 7B 01 00 0F 45 DF E9 5C FD FF FF 89 5D B0 C7 45 A8 ?? ?? ?? ?? E9 03 FD FF FF 8B 45 14 85 C0 75 33 8B 5A 14 BA ?? ?? ?? ?? 85 D2 0F 84 B8 01 00 00 C7 04 24 ?? ?? ?? ?? FF D2 C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 5D 0C 8B 45 0C 8D 65 F4 5B 5E 5F 5D C3 8B 4A 14 8B 42 10 8B 52 18 89 14 24 8B 55 18 E8 4F F0 FF FF 83 EC 04 89 C3 EB B5 8B 45 C4 8B 55 18 89 04 24 89 F0 E8 38 F0 FF FF 83 EC 04 89 C1 E9 25 FE FF FF 8B 45 0C 89 4D 8C 89 04 24 E8 ?? ?? ?? ?? 8B 7D A0 8B 4D 8C 83 C0 01 89 45 B4 8B 17 83 C7 04 8D 82 FF FE FE FE F7 D2 21 D0 25 80 80 80 80 74 EA 89 C2 C1 EA 10 A9 80 80 00 00 0F 44 C2 8D 57 02 0F 44 FA 00 C0 8B 55 9C 83 DF 03 2B 7D A0 89 4D 8C 8D 44 17 1E 03 45 B4 89 04 24 E8 ?? ?? ?? ?? 8B 4D 8C 85 C0 89 C3 0F 84 A2 FD FF FF 8B 45 0C 83 C7 01 8B 55 B4 89 44 24 04 8D 43 1C 89 54 24 08 89 04 24 E8 ?? ?? ?? ?? 8B 55 9C 83 C2 01 89 54 24 08 89 45 B4 8B 45 08 89 55 90 89 44 24 04 8B 45 B4 89 04 24 E8 ?? ?? ?? ?? 8B 55 90 8B 45 A0 03 55 B4 89 7C 24 08 89 14 24 89 44 24 04 89 55 90 E8 ?? ?? ?? ?? 8B 45 B4 8B 55 90 8B 4D 8C 89 73 10 89 03 8B 45 1C 89 53 08 89 4B 14 89 43 04 A1 ?? ?? ?? ?? 89 43 0C 8B 45 C4 89 43 18 B8 ?? ?? ?? ?? 85 C0 74 0C C7 04 24 ?? ?? ?? ?? FF D0 8B 4D 8C C7 44 24 08 ?? ?? ?? ?? C7 44 24 04 ?? ?? ?? ?? 89 1C 24 89 4D 8C E8 ?? ?? ?? ?? BA ?? ?? ?? ?? 8B 4D 8C 85 D2 89 C7 74 0C C7 04 24 ?? ?? ?? ?? FF D2 8B 4D 8C 85 FF 74 08 3B 1F 0F 84 CA FC FF FF 89 1C 24 89 4D 8C E8 ?? ?? ?? ?? 8B 4D 8C E9 B7 FC FF FF 89 4D 0C E9 5F F9 FF FF 89 5D 0C E9 57 F9 FF FF }
	condition:
		$1
}

rule file_215_11_0 {
	meta:
		name = "free_mem"
		size = 163
		refs = "0006 _nl_domain_bindings 001b _nl_default_dirname 0025 free 0047 _nl_current_default_domain 004c _nl_default_default_domain 006b __tdestroy"
	strings:
		$1 = { 53 83 EC 18 8B 1D ?? ?? ?? ?? 85 DB 74 38 66 90 8B 03 A3 ?? ?? ?? ?? 8B 43 04 3D ?? ?? ?? ?? 74 08 89 04 24 E8 ?? ?? ?? ?? 8B 43 08 89 04 24 E8 ?? ?? ?? ?? 89 1C 24 E8 ?? ?? ?? ?? 8B 1D ?? ?? ?? ?? 85 DB 75 CA A1 ?? ?? ?? ?? 3D ?? ?? ?? ?? 74 08 89 04 24 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? C7 44 24 04 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 00 00 00 00 85 C0 74 1C 8D B6 00 00 00 00 8B 18 89 04 24 89 1D ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 DB 89 D8 75 EA 83 C4 18 5B C3 }
	condition:
		$1
}

rule file_217_0_0 {
	meta:
		name = "__gconv"
		size = 543
		refs = "00b6 _dl_mcount_wrapper_check 01f7 __assert_fail"
	strings:
		$1 = { 83 F8 FF 0F 84 2F 01 00 00 55 57 56 53 89 C3 83 EC 3C 8B 00 83 E8 01 89 44 24 28 8B 44 24 58 85 C0 0F 84 D4 01 00 00 8B 44 24 50 89 D6 89 CD 8B 54 24 58 85 C0 C7 02 00 00 00 00 0F 84 8F 01 00 00 8B 4C 24 50 8B 11 8B 4C 24 28 8D 04 C9 8D 04 83 89 50 08 8B 54 24 54 89 50 0C 8B 43 04 8B 78 14 8B 00 85 C0 74 0A C1 CF 09 65 33 3D 18 00 00 00 85 F6 0F 84 C7 00 00 00 8B 16 85 D2 0F 84 BD 00 00 00 8B 44 24 50 85 C0 0F 84 48 01 00 00 8B 4C 24 50 8B 01 85 C0 0F 84 3A 01 00 00 8D 4B 08 89 6C 24 24 89 DD 89 D3 89 4C 24 2C EB 04 66 90 89 D3 89 3C 24 E8 ?? ?? ?? ?? 8B 54 24 58 8B 4C 24 24 C7 44 24 1C 00 00 00 00 C7 44 24 18 00 00 00 00 89 54 24 14 8B 54 24 2C C7 44 24 10 00 00 00 00 89 4C 24 0C 89 74 24 08 89 54 24 04 8B 45 04 89 04 24 FF D7 83 F8 04 75 14 8B 16 39 DA 74 0E 8B 5D 04 8B 5B 24 01 D3 39 5C 24 24 73 A1 89 EB 8B 4C 24 50 8B 11 85 D2 74 11 8B 4C 24 28 8D 14 C9 8B 4C 24 50 8B 54 93 08 89 11 83 C4 3C 5B 5E 5F 5D C2 0C 00 66 90 B8 08 00 00 00 C2 0C 00 89 3C 24 E8 ?? ?? ?? ?? 8B 54 24 28 8B 4C 24 58 8D 04 D2 8D 04 83 83 78 08 01 C7 44 24 1C 00 00 00 00 89 4C 24 14 19 C0 F7 D0 83 C0 02 89 44 24 18 8D 43 08 C7 44 24 10 00 00 00 00 C7 44 24 0C 00 00 00 00 C7 44 24 08 00 00 00 00 89 44 24 04 8B 43 04 89 04 24 FF D7 85 C0 75 1D 8B 74 24 28 89 D9 31 D2 8D 74 26 00 83 C2 01 83 C1 24 C7 41 F0 00 00 00 00 39 D6 73 EF 8B 4C 24 50 85 C9 0F 85 4C FF FF FF 83 C4 3C 5B 5E 5F 5D C2 0C 00 90 31 D2 E9 70 FE FF FF C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 4A 00 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 2C 00 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_218_3_0 {
	meta:
		name = "_IO_getdelim"
		size = 627
		refs = "0095 malloc 00e7 realloc 011a memcpy 0131 __underflow 015a memchr 0217 __libc_errno 026f _Unwind_Resume"
	strings:
		$1 = { 55 57 56 53 83 EC 2C 8B 5C 24 44 8B 74 24 4C 85 DB 0F 84 FF 01 00 00 8B 4C 24 40 85 C9 0F 84 F3 01 00 00 8B 0E 89 C8 89 CA 25 00 80 00 00 75 36 8B 56 48 65 8B 1D 08 00 00 00 3B 5A 08 74 21 B9 01 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 0A 0F 85 1B 02 00 00 8B 56 48 8B 0E 89 5A 08 83 42 04 01 89 CA 83 E1 20 0F 85 31 01 00 00 8B 44 24 40 8B 10 85 D2 74 0A 8B 54 24 44 8B 02 85 C0 75 24 8B 4C 24 44 C7 01 78 00 00 00 C7 04 24 78 00 00 00 E8 ?? ?? ?? ?? 8B 54 24 40 85 C0 89 02 0F 84 59 01 00 00 8B 7E 04 8B 5E 08 29 FB 85 DB 0F 8E 37 01 00 00 C7 44 24 1C 00 00 00 00 E9 86 00 00 00 8D 74 26 00 8B 4C 24 14 01 C9 39 C8 89 CF 8B 4C 24 40 0F 43 F8 89 7C 24 04 8B 01 89 54 24 18 89 04 24 E8 ?? ?? ?? ?? 8B 54 24 18 85 C0 0F 84 09 01 00 00 8B 4C 24 40 89 01 8B 4C 24 44 89 39 8B 7E 04 03 44 24 1C 89 5C 24 08 89 7C 24 04 89 04 24 89 54 24 18 E8 ?? ?? ?? ?? 8B 54 24 18 01 5E 04 85 D2 0F 85 B3 00 00 00 89 34 24 E8 ?? ?? ?? ?? 83 F8 FF 0F 84 A2 00 00 00 8B 7E 04 8B 5E 08 89 6C 24 1C 29 FB 8B 4C 24 48 89 5C 24 08 89 3C 24 89 4C 24 04 E8 ?? ?? ?? ?? 85 C0 89 C2 74 07 89 C3 29 FB 83 C3 01 8B 6C 24 1C 01 DD 83 FD FF 0F 8C AF 00 00 00 8B 4C 24 44 8D 45 01 8B 09 39 C8 89 4C 24 14 0F 87 39 FF FF FF 8B 4C 24 40 8B 01 E9 6C FF FF FF 8D B6 00 00 00 00 BD FF FF FF FF 80 E6 80 75 26 8B 56 48 83 6A 04 01 75 1D C7 42 08 00 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 83 2A 01 0F 85 B1 00 00 00 66 90 83 C4 2C 89 E8 5B 5E 5F 5D C3 8D B6 00 00 00 00 8B 54 24 40 8B 02 C6 04 28 00 8B 16 EB B7 89 34 24 E8 ?? ?? ?? ?? 83 F8 FF 75 0E 90 8D 74 26 00 8B 16 BD FF FF FF FF EB 9C 8B 7E 04 8B 5E 08 29 FB E9 A1 FE FF FF A1 ?? ?? ?? ?? BD FF FF FF FF 65 C7 00 16 00 00 00 EB A7 A1 ?? ?? ?? ?? BD FF FF FF FF 8B 16 65 C7 00 4B 00 00 00 E9 64 FF FF FF F7 06 00 80 00 00 89 C3 75 20 8B 56 48 83 6A 04 01 75 17 C7 42 08 00 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 83 2A 01 75 20 89 1C 24 E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_219_0_0 {
	meta:
		name = "check_match.9163"
		size = 355
		refs = "005f strcmp 0133 _dl_name_match_p 015f __assert_fail"
	strings:
		$1 = { 83 EC 2C 89 5C 24 1C 89 C3 89 74 24 20 8B 53 04 89 CE 89 7C 24 24 89 6C 24 28 0F B6 40 0C 83 E0 0F 85 D2 0F 84 F5 00 00 00 31 D2 66 83 7B 0E 00 0F 94 C2 85 56 24 0F 85 C4 00 00 00 BA 67 04 00 00 0F A3 C2 0F 83 B6 00 00 00 3B 5E 20 74 1C 8B 46 18 89 44 24 04 8B 46 1C 03 03 89 04 24 E8 ?? ?? ?? ?? 85 C0 0F 85 95 00 00 00 8B 7E 10 8B 56 14 85 FF 8B 82 A4 01 00 00 74 4D 85 C0 0F 84 A7 00 00 00 8B 4E 0C 0F B7 2C 48 89 E8 25 FF 7F 00 00 C1 E0 04 03 82 70 01 00 00 8B 70 04 3B 77 04 74 66 8B 47 08 85 C0 75 57 85 F6 75 53 66 85 ED 78 4E 89 D8 8B 74 24 20 8B 5C 24 1C 8B 7C 24 24 8B 6C 24 28 83 C4 2C C3 85 C0 74 E6 8B 56 0C 0F B7 14 50 8B 46 08 89 D1 C1 E0 1E 81 E1 FF 7F 00 00 C1 F8 1F 83 C0 03 39 C8 7F C7 66 85 D2 78 10 8B 46 04 8D 50 01 85 C0 89 56 04 75 03 89 1E 90 31 DB EB AE 8D 74 26 00 8B 17 89 54 24 04 8B 00 89 04 24 E8 ?? ?? ?? ?? 85 C0 74 96 EB 84 3C 06 0F 84 03 FF FF FF 31 DB EB 88 8B 47 0C 85 C0 90 74 80 E8 ?? ?? ?? ?? 85 C0 0F 84 73 FF FF FF C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 A7 00 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_219_1_0 {
	meta:
		name = "do_lookup_x"
		size = 2054
		refs = "00ba _dl_debug_mask 015e _dl_name_match_p 01e2 _dl_dynamic_weak 0215 _dl_ns 021e __pthread_mutex_lock 02c8 strcmp 02f8 __pthread_mutex_unlock 0456 _dl_higher_prime_number 0468 calloc 0561 free 0636 _dl_argv 0654 _dl_debug_printf 0683 _dl_dprintf 068f _exit"
	strings:
		$1 = { 55 57 56 53 81 EC 8C 00 00 00 89 44 24 70 8B 84 24 A0 00 00 00 89 54 24 2C 8B 94 24 A8 00 00 00 89 4C 24 38 8B B4 24 AC 00 00 00 89 44 24 78 8B 84 24 B0 00 00 00 8B 7A 04 89 44 24 68 8B 84 24 B4 00 00 00 89 44 24 60 8B 84 24 BC 00 00 00 89 44 24 7C 8B 2A 8B 44 24 2C 8B 54 24 2C 89 7C 24 4C C1 E8 05 83 E2 1F 89 44 24 30 89 54 24 34 8B 44 B5 00 C7 44 24 5C 00 00 00 00 C7 44 24 58 00 00 00 00 8B 58 14 3B 9C 24 B8 00 00 00 89 5C 24 6C 0F 84 D9 00 00 00 F6 44 24 7C 02 74 0D F6 83 94 01 00 00 03 0F 84 C5 00 00 00 F6 83 95 01 00 00 20 0F 85 B8 00 00 00 F6 05 ?? ?? ?? ?? 08 0F 85 65 05 00 00 8B BB 78 01 00 00 85 FF 89 7C 24 28 0F 84 99 00 00 00 8B 43 38 8B 93 84 01 00 00 8B 40 04 85 D2 89 44 24 3C 8B 43 34 8B 40 04 89 44 24 74 0F 84 9A 05 00 00 8B 44 24 30 23 83 7C 01 00 00 0F B6 4C 24 34 8B 3C 82 8B 54 24 2C 89 F8 D3 E8 0F B6 8B 80 01 00 00 D3 EA 89 54 24 24 0F B6 4C 24 24 89 FA D3 EA 21 D0 A8 01 0F 85 51 06 00 00 C7 44 24 64 00 00 00 00 83 7C 24 5C 01 74 4E 8B 4C 24 64 85 C9 75 26 8B 44 24 68 85 C0 74 1E 8B 40 0C 85 C0 74 17 8B 54 24 6C E8 ?? ?? ?? ?? 85 C0 0F 85 12 06 00 00 8D B6 00 00 00 00 83 C6 01 39 74 24 4C 0F 87 F2 FE FF FF 31 C0 81 C4 8C 00 00 00 5B 5E 5F 5D C3 8D B6 00 00 00 00 8B 44 24 58 85 C0 74 AA 0F B6 50 0C C0 EA 04 80 FA 02 74 3C 80 FA 0A 74 5F 80 FA 01 75 94 89 44 24 38 8B 84 24 A4 00 00 00 8B 54 24 38 8B 8C 24 A4 00 00 00 89 10 8B 44 24 6C 89 41 04 81 C4 8C 00 00 00 B8 01 00 00 00 5B 5E 5F 5D C3 8D 76 00 8B 15 ?? ?? ?? ?? 85 D2 74 C4 8B BC 24 A4 00 00 00 83 3F 00 0F 85 48 FF FF FF 89 07 8B 44 24 6C 89 47 04 E9 3A FF FF FF 89 44 24 38 8B 44 24 6C 6B 40 18 4C 05 ?? ?? ?? ?? 89 44 24 28 B8 ?? ?? ?? ?? 85 C0 74 09 8B 74 24 28 89 34 24 FF D0 8B 7C 24 28 8B 4C 24 28 8B 7F 18 8B 49 1C 85 FF 89 7C 24 34 89 4C 24 24 0F 84 4D 03 00 00 8B 44 24 2C 31 D2 F7 F1 8B 44 24 2C 83 E9 02 89 D7 31 D2 F7 F1 8B 4C 24 70 89 FB 89 7C 24 3C 89 4C 24 30 83 C2 01 89 D1 89 D5 8B 54 24 2C C1 E1 04 89 D0 89 EA 8D 74 1D 00 89 C5 C1 E3 04 03 5C 24 34 EB 1C 8D B4 26 00 00 00 00 85 FF 0F 84 90 00 00 00 01 CB 39 74 24 24 8D 04 16 76 6D 89 C6 39 2B 8B 7B 04 75 E4 8B 44 24 30 89 3C 24 89 54 24 1C 89 4C 24 18 89 44 24 04 E8 ?? ?? ?? ?? 8B 54 24 1C 8B 4C 24 18 85 C0 75 C0 F6 44 24 7C 02 0F 84 A0 02 00 00 8B 44 24 38 8B 94 24 A4 00 00 00 89 02 8B 44 24 6C 89 42 04 B8 ?? ?? ?? ?? 85 C0 0F 84 6E 04 00 00 8B 4C 24 28 89 0C 24 FF D0 B8 01 00 00 00 E9 68 FE FF FF 90 89 E8 89 F3 89 D5 89 C2 2B 5C 24 24 E9 55 FF FF FF 8D B4 26 00 00 00 00 8B 74 24 24 8B 7C 24 3C 8D 0C 76 8B 74 24 28 8B 76 20 89 F0 C1 E0 02 39 C1 0F 86 FF 00 00 00 8B 44 24 38 8B 74 24 74 03 30 F6 44 24 7C 02 74 7A 8B 6C 24 78 89 D3 89 74 24 30 8B 74 24 24 C1 E3 04 89 6C 24 24 8B 6C 24 34 89 F8 C1 E0 04 8D 44 05 04 8D B6 00 00 00 00 8B 08 85 C9 8D 48 FC 74 0C 01 D7 01 D8 39 FE 77 EF 29 F7 EB DC 8B 74 24 30 8B 6C 24 24 8B 54 24 2C 89 30 89 68 04 89 50 FC 8B 84 24 C0 00 00 00 89 41 0C 8B 4C 24 28 B8 ?? ?? ?? ?? 83 41 20 01 85 C0 0F 84 E2 FD FF FF 89 0C 24 FF D0 E9 D8 FD FF FF 8B 6C 24 6C 89 D3 89 74 24 30 8B 74 24 24 C1 E3 04 89 6C 24 24 8B 6C 24 34 89 F8 C1 E0 04 8D 44 05 04 8D 74 26 00 8B 08 85 C9 8D 48 FC 74 0C 01 D7 01 D8 39 FE 77 EF 29 F7 EB DE 8B 74 24 30 8B 54 24 2C 8B 6C 24 24 89 30 89 50 FC 8B 44 24 38 89 69 0C 89 41 08 0F B6 85 94 01 00 00 83 E0 03 3C 02 0F 85 79 FF FF FF 83 8D 04 02 00 00 08 E9 6D FF FF FF 8B 44 24 24 83 C0 01 E8 ?? ?? ?? ?? C7 04 24 10 00 00 00 89 44 24 04 89 C5 E8 ?? ?? ?? ?? 85 C0 89 44 24 30 0F 84 E9 01 00 00 8B 44 24 24 85 C0 0F 84 9A 01 00 00 8B 44 24 24 8D 75 FE 8B 7C 24 34 89 74 24 40 C1 E0 04 01 F8 89 44 24 4C 8D 74 26 00 8B 4F 04 85 C9 89 4C 24 3C 0F 84 7C 00 00 00 8B 07 31 D2 8B 77 0C 8B 4F 08 89 44 24 24 F7 F5 8B 44 24 24 89 74 24 44 89 4C 24 48 89 D6 31 D2 F7 74 24 40 8D 5A 01 89 DA C1 E2 04 89 F0 8D 0C 1E 8B 74 24 30 C1 E0 04 8D 44 06 04 EB 05 8D 76 00 89 F1 8B 30 85 F6 8D 70 FC 74 15 01 D0 39 CD 8D 34 19 77 EC 89 CE 29 EE EB D1 8D B6 00 00 00 00 8B 4C 24 3C 8B 44 24 24 89 4E 04 8B 4C 24 48 89 06 89 4E 08 8B 4C 24 44 89 4E 0C 83 C7 10 3B 7C 24 4C 0F 85 68 FF FF FF 8B 44 24 34 8B 4C 24 28 89 04 24 FF 51 24 8B 74 24 28 31 D2 8B 44 24 30 89 6C 24 24 89 6E 1C 89 46 18 8B 44 24 2C C7 46 24 ?? ?? ?? ?? F7 F5 8B 44 24 2C 89 D7 31 D2 F7 74 24 40 8B 44 24 30 89 44 24 34 83 C2 01 E9 CC FD FF FF 8B 43 08 8B 94 24 A4 00 00 00 89 02 8B 43 0C 89 42 04 E9 5D FD FF FF C7 44 24 04 1F 00 00 00 C7 04 24 10 00 00 00 E8 ?? ?? ?? ?? 85 C0 89 44 24 34 0F 84 A7 00 00 00 8B 4C 24 28 BA 85 10 42 08 C7 44 24 24 1F 00 00 00 89 41 18 8B 44 24 2C C7 41 1C 1F 00 00 00 C7 41 24 ?? ?? ?? ?? 8B 4C 24 2C F7 E2 8B 44 24 2C 29 D0 D1 E8 8D 3C 02 BA 09 CB 3D 8D C1 EF 04 89 F8 C1 E0 05 29 F8 8B 7C 24 2C 29 C7 8B 44 24 2C F7 E2 C1 EA 04 6B D2 1D 29 D1 89 CA 83 C2 01 E9 31 FD FF FF 8D 7D FE 89 7C 24 40 E9 0E FF FF FF 8B 43 04 8B 53 18 80 38 00 75 07 A1 ?? ?? ?? ?? 8B 00 89 44 24 08 8B 44 24 70 89 54 24 0C C7 04 24 ?? ?? ?? ?? 89 44 24 04 E8 ?? ?? ?? ?? 8B 5C 24 6C E9 64 FA FF FF B8 ?? ?? ?? ?? 85 C0 74 09 8B 4C 24 28 89 0C 24 FF D0 C7 44 24 04 ?? ?? ?? ?? C7 04 24 02 00 00 00 E8 ?? ?? ?? ?? C7 04 24 7F 00 00 00 E8 ?? ?? ?? ?? 8B 4C 24 38 83 39 FF 75 6E 8B 7C 24 70 89 54 24 48 89 7C 24 44 0F B6 0F 85 C9 74 55 89 CA 0F B6 4F 01 E3 4D C1 E2 04 01 CA 0F B6 4F 02 E3 42 C1 E2 04 01 CA 0F B6 4F 03 E3 37 C1 E2 04 01 CA 0F B6 4F 04 E3 2C C1 E2 04 83 C7 05 01 CA 0F B6 0F E3 1F C1 E2 04 B8 00 00 00 F0 47 01 CA 21 D0 81 E2 FF FF FF 0F C1 E8 18 0F B6 0F 31 C2 85 C9 75 E1 8B 4C 24 38 89 11 8B 4C 24 38 31 D2 8B 01 F7 74 24 28 8B 83 8C 01 00 00 8B 04 90 85 C0 89 44 24 64 0F 84 10 FA FF FF 8B 7C 24 4C EB 24 8D B4 26 00 00 00 00 8B 44 24 6C 8B 54 24 64 8B 80 88 01 00 00 8B 04 90 85 C0 89 44 24 64 0F 84 A8 00 00 00 C1 E0 04 03 44 24 3C 8D 4C 24 58 E8 2B F7 FF FF 85 C0 74 CF 89 7C 24 4C E9 26 FA FF FF B8 01 00 00 00 E9 03 FA FF FF 83 C8 FF E9 FB F9 FF FF 8B 44 24 2C 31 D2 F7 74 24 28 8B 83 88 01 00 00 8B 04 90 85 C0 0F 84 94 F9 FF FF 8B 93 8C 01 00 00 8B 7C 24 4C 8D 1C 82 EB 09 66 90 83 C3 04 A8 01 75 3D 8B 03 8B 54 24 2C 31 C2 D1 EA 75 ED 8B 44 24 6C 89 DA 8D 4C 24 58 2B 90 8C 01 00 00 89 D0 C1 F8 02 89 44 24 64 C1 E0 04 03 44 24 3C E8 A8 F6 FF FF 85 C0 0F 85 79 FF FF FF 8B 03 EB BC 89 7C 24 4C E9 36 F9 FF FF 89 7C 24 4C E9 35 F9 FF FF }
	condition:
		$1
}

rule file_219_2_0 {
	meta:
		name = "_dl_lookup_symbol_x"
		size = 2552
		refs = "013b _dl_debug_mask 02ca strlen 0313 stpcpy 0328 _dl_argv 04b8 __assert_fail 0520 __pthread_mutex_lock 052b _dl_load_lock 053a _dl_ns 0572 __pthread_mutex_unlock 05c5 _dl_lookup_symbol_x 05fe _dl_sysinfo 0759 _dl_debug_printf 077a malloc 07bc memcpy 07f5 _dl_scope_free 08eb _dl_debug_printf_c 09e2 _dl_signal_cerror"
	strings:
		$1 = { 55 89 E5 57 89 CF 56 BE 05 15 00 00 53 81 EC BC 00 00 00 89 45 A0 89 55 98 89 C2 0F B6 00 84 C0 74 19 8D B6 00 00 00 00 89 F1 83 C2 01 C1 E1 05 01 CE 01 C6 0F B6 02 84 C0 75 ED 8B 45 0C C7 45 B4 FF FF FF FF C7 45 B8 00 00 00 00 C7 45 BC 00 00 00 00 85 C0 74 0D F7 45 14 FA FF FF FF 0F 85 93 08 00 00 8B 5D 18 85 DB 0F 85 D9 02 00 00 8B 4D 08 C7 45 94 00 00 00 00 8B 01 85 C0 0F 84 F3 02 00 00 89 75 9C 8B 55 94 8B 5D 08 8B 75 18 EB 18 8D B4 26 00 00 00 00 0F 85 9A 01 00 00 83 C3 04 8B 03 31 D2 85 C0 74 47 8B 4D 98 89 44 24 08 8D 45 B8 89 44 24 04 8B 07 89 54 24 0C 8B 55 9C 89 4C 24 20 8B 4D 10 89 74 24 18 89 04 24 8B 45 A0 89 4C 24 1C 8B 4D 14 89 4C 24 14 8B 4D 0C 89 4C 24 10 8D 4D B4 E8 05 F7 FF FF 83 F8 00 7E A8 8B 45 B8 8B 75 9C 85 C0 0F 84 78 02 00 00 8B 17 85 D2 74 0B 0F B6 42 0D 83 E0 03 3C 03 74 51 8B 75 BC C7 45 9C 00 00 00 00 0F B6 86 94 01 00 00 83 E0 03 3C 02 0F 84 03 03 00 00 8B 8E FC 01 00 00 85 C9 0F 84 F6 07 00 00 8B 15 ?? ?? ?? ?? F7 C2 04 08 00 00 0F 85 0B 07 00 00 8B 45 B8 89 07 8D 65 F4 89 F0 5B 5E 5F 5D C2 14 00 8D 74 26 00 83 7D 10 01 0F 84 AC 00 00 00 8B 4D 08 C7 45 C0 00 00 00 00 C7 45 C4 00 00 00 00 8B 01 85 C0 0F 84 E9 01 00 00 8B 4D 94 8B 5D 08 89 75 9C EB 0D 83 C3 04 8B 03 85 C0 74 4D 8B 17 31 C9 8B 75 18 89 44 24 08 8D 45 C0 89 44 24 04 8B 45 A0 89 14 24 8B 55 9C 89 74 24 18 8B 75 14 89 4C 24 0C 8D 4D B4 C7 44 24 20 00 00 00 00 C7 44 24 1C 01 00 00 00 89 74 24 14 8B 75 0C 89 74 24 10 E8 0E F6 FF FF 85 C0 74 AA 8B 45 C0 85 C0 0F 84 7D 01 00 00 8B 55 98 39 55 C4 0F 84 71 01 00 00 8B 55 98 8B 07 89 55 BC 89 D6 89 45 B8 C7 45 9C 01 00 00 00 E9 03 FF FF FF 8B 75 BC 3B 75 98 74 EC 89 55 B8 8B 55 98 C7 45 9C 01 00 00 00 89 55 BC 89 D6 E9 E4 FE FF FF 8D 76 00 85 F6 0F 85 5E FE FF FF 8B 4D 0C 85 C9 0F 84 4D 02 00 00 8B 55 98 85 D2 0F 84 3B 02 00 00 8B 55 98 8B 5A 04 8B 75 0C 83 F8 FE B8 ?? ?? ?? ?? 8B 4D A0 C7 45 C8 ?? ?? ?? ?? C7 45 D0 ?? ?? ?? ?? 8B 16 89 4D CC B9 01 00 00 00 C7 45 D8 ?? ?? ?? ?? C7 45 E0 ?? ?? ?? ?? 89 55 D4 8B 56 0C 8D 75 CC 89 55 DC BA ?? ?? ?? ?? 0F 45 D0 B8 07 00 00 00 89 55 E4 8D 55 E8 89 55 A4 89 F2 EB 27 66 90 8B 02 89 95 70 FF FF FF 89 8D 74 FF FF FF 89 04 24 E8 ?? ?? ?? ?? 8B 95 70 FF FF FF 8B 8D 74 FF FF FF 83 C2 04 01 C1 3B 55 A4 75 D4 83 C1 1E 83 E1 F0 29 CC B9 ?? ?? ?? ?? 8D 54 24 33 83 E2 F0 89 D0 EB 09 8D 74 26 00 8B 0E 83 C6 04 89 4C 24 04 89 04 24 89 95 70 FF FF FF E8 ?? ?? ?? ?? 8B 95 70 FF FF FF 3B 75 A4 75 DE 80 3B 00 75 11 A1 ?? ?? ?? ?? 8B 18 B8 ?? ?? ?? ?? 85 DB 0F 44 D8 89 14 24 B9 ?? ?? ?? ?? E9 98 06 00 00 8D 76 00 8B 5D 08 8B 55 18 8B 03 8B 08 39 11 BA 00 00 00 00 74 0B 83 C2 01 8B 5D 18 39 1C 91 75 F5 89 55 94 E9 15 FD FF FF 8B 75 BC E9 94 FE FF FF 8B 07 85 C0 74 0B 0F B6 40 0C C0 E8 04 3C 02 74 07 8B 45 18 85 C0 74 0D C7 07 00 00 00 00 31 F6 E9 B5 FD FF FF F6 05 ?? ?? ?? ?? 01 75 EA 8B 45 98 85 C0 0F 84 3F 06 00 00 8B 55 98 8B 5A 04 8B 45 0C 85 C0 0F 84 B1 05 00 00 8B 75 0C B9 ?? ?? ?? ?? BA ?? ?? ?? ?? 8B 06 85 C0 0F 44 C1 8B 4D A0 8D 75 CC 89 55 D0 8D 55 D8 89 45 D4 B8 12 00 00 00 89 55 A4 89 F2 89 4D CC B9 01 00 00 00 C7 45 C8 ?? ?? ?? ?? 01 C1 3B 55 A4 0F 84 76 05 00 00 8B 02 89 95 70 FF FF FF 89 8D 74 FF FF FF 89 04 24 E8 ?? ?? ?? ?? 8B 95 70 FF FF FF 8B 8D 74 FF FF FF 83 C2 04 EB CE F6 45 14 01 0F 84 F3 FC FF FF 39 75 98 0F 84 AB 00 00 00 F6 86 04 02 00 00 08 0F 85 DD FC FF FF 8B 55 98 8B 92 F4 01 00 00 89 55 90 8B 55 98 8B 92 F0 01 00 00 89 55 8C 85 D2 89 55 88 74 4F 8B 02 85 C0 74 49 39 F0 74 12 89 D0 83 C0 04 8B 10 85 D2 74 3A 83 C0 04 39 F2 75 F3 8B 75 BC E9 9A FC FF FF 31 DB E9 C4 FD FF FF C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 ED 02 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 90 85 C0 74 31 8B 4D 90 8B 09 85 C9 89 4D 94 74 2C 8B 5D 90 31 C0 39 73 04 74 B0 83 C0 01 3B 45 94 74 1A 8B 55 90 39 74 82 04 75 EF EB 9D 8B 75 98 E9 37 FC FF FF C7 45 94 00 00 00 00 8B 45 14 8B 8E 50 02 00 00 8B 9E 54 02 00 00 83 E0 04 89 4D 84 89 5D 80 89 85 7C FF FF FF 0F 85 B4 00 00 00 B8 ?? ?? ?? ?? 85 C0 74 09 C7 04 24 ?? ?? ?? ?? FF D0 8B 55 98 6B 42 18 4C 8B 80 ?? ?? ?? ?? 39 F0 74 0B 85 C0 74 07 8B 40 0C 39 F0 75 F5 85 C0 90 74 1A 8B 55 80 8B 45 84 33 96 54 02 00 00 33 86 50 02 00 00 09 C2 0F 84 15 01 00 00 BB FF FF FF FF B8 ?? ?? ?? ?? 85 C0 74 09 C7 04 24 ?? ?? ?? ?? FF D0 8B B5 7C FF FF FF 85 F6 0F 85 20 01 00 00 83 FB FF 0F 85 EF FE FF FF 8B 75 18 89 F9 8B 55 98 8B 45 A0 89 74 24 10 8B 75 14 89 74 24 0C 8B 75 10 89 74 24 08 8B 75 0C 89 74 24 04 8B 75 08 89 34 24 E8 ?? ?? ?? ?? 83 EC 14 89 C6 E9 7D FB FF FF 31 C0 65 87 05 1C 00 00 00 83 F8 02 75 21 BA 01 00 00 00 65 8B 1D 08 00 00 00 65 8B 0D 20 00 00 00 83 C3 1C 83 C9 01 B0 F0 FF 15 ?? ?? ?? ?? B8 ?? ?? ?? ?? 85 C0 74 15 C7 04 24 ?? ?? ?? ?? FF D0 8B 55 98 8B 92 F0 01 00 00 89 55 8C 8B 4D 88 89 F0 39 4D 8C 89 C6 0F 84 DD 01 00 00 8B 5D 8C 85 DB 0F 84 D2 01 00 00 8B 5D 8C 8B 13 85 D2 0F 84 C5 01 00 00 39 D0 74 16 89 DA 83 C2 04 8B 0A 85 C9 0F 84 B2 01 00 00 83 C2 04 39 C8 75 EF 8B 55 80 33 90 54 02 00 00 8B 80 50 02 00 00 33 45 84 09 C2 0F 85 F0 FE FF FF E9 92 00 00 00 8B 8E 04 02 00 00 F6 C1 08 0F 85 83 00 00 00 8B 55 98 0F B6 82 94 01 00 00 83 E0 03 3C 02 74 35 83 C9 08 31 DB 89 8E 04 02 00 00 E9 C0 FE FF FF 65 C7 05 1C 00 00 00 01 00 00 00 83 FB FF 0F 85 C4 FD FF FF 8B 55 98 8B 92 CC 01 00 00 89 55 08 E9 C4 FE FF FF F6 82 04 02 00 00 08 75 C2 8B 55 98 8B 9A F8 01 00 00 3B 5D 94 76 72 8B 55 98 8B 4D 94 8B 82 F4 01 00 00 89 74 88 04 8B 82 F4 01 00 00 89 CA 83 C2 01 89 10 F6 05 ?? ?? ?? ?? 40 75 07 31 DB E9 57 FE FF FF 8B 55 98 8B 5A 18 8B 52 04 80 3A 00 75 07 A1 ?? ?? ?? ?? 8B 10 8B 46 04 8B 4E 18 80 38 00 75 07 A1 ?? ?? ?? ?? 8B 00 89 5C 24 10 89 54 24 0C 89 4C 24 08 89 44 24 04 C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB B4 85 DB 0F 84 97 00 00 00 01 DB 8D 04 9D 04 00 00 00 89 04 24 89 8D 74 FF FF FF E8 ?? ?? ?? ?? 8B 8D 74 FF FF FF 85 C0 89 C2 0F 84 13 FF FF FF 8B 4D 94 85 C9 74 31 8D 48 04 8B 45 98 89 0C 24 8B 4D 94 8B 80 F4 01 00 00 C1 E1 02 89 4C 24 08 89 95 70 FF FF FF 83 C0 04 89 44 24 04 E8 ?? ?? ?? ?? 8B 95 70 FF FF FF 8B 4D 94 89 C8 83 C0 01 89 74 8A 04 89 02 8B 4D 98 8B 81 F4 01 00 00 89 99 F8 01 00 00 89 91 F4 01 00 00 85 C0 0F 84 19 FF FF FF 89 04 24 E8 ?? ?? ?? ?? E9 0C FF FF FF B8 2C 00 00 00 BB 0A 00 00 00 E9 63 FF FF FF 8B 4D 98 8B 91 F4 01 00 00 85 D2 0F 84 13 FD FF FF 39 55 90 0F 84 17 01 00 00 8B 1A 85 DB 89 5D 94 0F 84 FD FC FF FF 3B 42 04 0F 84 25 FE FF FF 31 C9 83 C1 01 3B 4D 94 0F 84 E6 FC FF FF 3B 44 8A 04 75 EE E9 0C FE FF FF 8B 4D 98 83 E2 04 8B 41 04 0F 84 E6 F8 FF FF 8B 55 9C B9 ?? ?? ?? ?? 8B 5E 18 85 D2 BA ?? ?? ?? ?? 0F 44 CA 8B 56 04 89 5D 9C 80 3A 00 75 08 8B 15 ?? ?? ?? ?? 8B 12 8B 5D 98 80 38 00 8B 73 18 75 11 A1 ?? ?? ?? ?? BB ?? ?? ?? ?? 8B 00 85 C0 0F 44 C3 8B 5D A0 89 4C 24 14 8B 4D 9C 89 54 24 0C 89 74 24 08 89 5C 24 18 89 4C 24 10 89 44 24 04 C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 5D 0C 85 DB 74 41 8B 75 0C 8B 06 C7 04 24 ?? ?? ?? ?? 89 44 24 04 E8 ?? ?? ?? ?? 8B 75 BC E9 54 F8 FF FF C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 D7 02 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 75 BC E9 1C F8 FF FF C7 86 FC 01 00 00 01 00 00 00 E9 FB F7 FF FF 8B 4D 90 8B 11 3B 55 94 0F 86 E5 FB FF FF 8B 5D 94 3B 44 99 04 0F 84 09 FD FF FF 8B 4D 94 83 C1 01 39 CA 76 54 8B 5D 90 3B 44 8B 04 75 F0 E9 F1 FC FF FF BA ?? ?? ?? ?? 89 D0 E9 57 FA FF FF 83 C1 1E 83 E1 F0 29 CC B9 ?? ?? ?? ?? 8D 54 24 33 83 E2 F0 89 D0 89 4C 24 04 89 04 24 89 95 70 FF FF FF E8 ?? ?? ?? ?? 8B 95 70 FF FF FF 39 75 A4 74 0F 8B 0E 83 C6 04 EB DC 89 55 94 E9 72 FB FF FF 80 3B 00 75 11 A1 ?? ?? ?? ?? 8B 18 B8 ?? ?? ?? ?? 85 DB 0F 44 D8 89 14 24 B9 ?? ?? ?? ?? 89 DA 31 C0 E8 ?? ?? ?? ?? 83 EC 04 E9 A0 F9 FF FF BB ?? ?? ?? ?? E9 BD F9 FF FF }
	condition:
		$1
}

rule file_219_3_0 {
	meta:
		name = "_dl_setup_hash"
		size = 185
		refs = "00b5 __assert_fail"
	strings:
		$1 = { 8B 90 4C 01 00 00 85 D2 74 66 83 EC 1C 89 5C 24 10 89 74 24 14 89 7C 24 18 8B 52 04 8B 1A 89 98 78 01 00 00 8B 4A 08 8B 72 04 8D 79 FF 85 CF 75 64 89 B8 7C 01 00 00 83 C2 10 8B 7A FC 89 90 84 01 00 00 8D 14 8A 89 90 88 01 00 00 C1 E6 02 8D 14 9A 8B 5C 24 10 29 F2 8B 74 24 14 89 B8 80 01 00 00 8B 7C 24 18 89 90 8C 01 00 00 83 C4 1C C3 8B 50 30 85 D2 74 F8 8B 52 04 8B 0A 83 C2 08 89 90 8C 01 00 00 8D 14 8A 89 88 78 01 00 00 89 90 88 01 00 00 C3 C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 6C 03 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_220_0_0 {
	meta:
		name = "capset"
		size = 35
		refs = "0011 _dl_sysinfo 001e __syscall_error"
	strings:
		$1 = { 89 DA 8B 4C 24 08 8B 5C 24 04 B8 B9 00 00 00 FF 15 ?? ?? ?? ?? 89 D3 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_222_0_0 {
	meta:
		name = "__strftime_internal"
		size = 7448
		refs = "0272 memset 0310 memcpy 036c strlen 08e7 __tzname 114d mktime 159d _nl_get_alt_digit 1a7b _nl_get_era_entry 1bd1 __tzset"
	strings:
		$1 = { 55 57 56 53 81 EC EC 00 00 00 89 54 24 70 8B 94 24 08 01 00 00 8B 52 08 89 94 24 84 00 00 00 8B 94 24 00 01 00 00 8B 52 08 89 54 24 7C 8B 94 24 00 01 00 00 83 7C 24 7C 0C 8B 52 28 89 94 24 88 00 00 00 0F 8E 9F 01 00 00 83 6C 24 7C 0C 0F B6 11 84 D2 0F 84 EE 16 00 00 89 CD 89 C7 8D 8C 24 B4 00 00 00 C7 44 24 68 00 00 00 00 89 4C 24 64 EB 36 8D B6 00 00 00 00 8B 44 24 70 2B 44 24 68 83 F8 01 0F 86 0F 01 00 00 85 FF 74 05 88 17 83 C7 01 83 44 24 68 01 89 E8 0F B6 50 01 83 C5 01 84 D2 0F 84 2A 02 00 00 80 FA 25 75 CB 31 DB C7 44 24 78 00 00 00 00 C7 44 24 74 00 00 00 00 83 C5 01 0F BE 4D 00 80 F9 30 74 6D 7F 5B 80 F9 23 0F 84 A2 00 00 00 80 F9 2D 74 5D 0F BE C1 BE FF FF FF FF 8D 50 D0 83 FA 09 77 55 31 F6 EB 24 90 0F BE 45 00 0F 84 B6 00 00 00 8D 14 B6 8D 74 50 D0 83 C5 01 0F B6 4D 00 0F BE C1 8D 50 D0 83 FA 09 77 2D 81 FE CC CC CC 0C 7E D5 BE FF FF FF 7F EB DF 8D B6 00 00 00 00 80 F9 5E 74 5B 80 F9 5F 75 A9 8D B6 00 00 00 00 89 4C 24 74 EB 81 66 90 80 F9 45 0F 84 8F 00 00 00 80 F9 4F 0F 84 86 00 00 00 C7 44 24 6C 00 00 00 00 80 F9 7A 76 69 80 F9 25 0F 85 A0 00 00 00 89 EB C7 44 24 6C 01 00 00 00 E9 B3 00 00 00 90 BB 01 00 00 00 E9 3D FF FF FF 8D B6 00 00 00 00 C7 44 24 78 01 00 00 00 E9 2A FF FF FF 8D 76 00 C7 44 24 68 00 00 00 00 8B 44 24 68 81 C4 EC 00 00 00 5B 5E 5F 5D C3 90 3C 37 0F 8E 42 FF FF FF BE FF FF FF 7F E9 3F FF FF FF 8D B6 00 00 00 00 0F B6 C1 FF 24 85 ?? ?? ?? ?? 8D B6 00 00 00 00 0F B6 4D 01 83 C5 01 89 44 24 6C E9 72 FF FF FF 8B 54 24 7C 85 D2 BA 0C 00 00 00 0F 45 54 24 7C 89 54 24 7C E9 4D FE FF FF 8D B4 26 00 00 00 00 8D 45 FF BA 01 00 00 00 C7 44 24 6C 01 00 00 00 89 C3 83 E8 01 83 C2 01 80 78 01 25 75 F2 89 54 24 6C 31 C0 89 F2 8B 74 24 6C 2B 54 24 6C 0F 49 C2 01 C6 8B 44 24 70 2B 44 24 68 39 C6 0F 83 4D FF FF FF 85 FF 74 6E 85 D2 7E 29 83 7C 24 74 30 89 54 24 08 0F 84 8E 00 00 00 C7 44 24 04 20 00 00 00 89 3C 24 89 54 24 20 E8 ?? ?? ?? ?? 8B 54 24 20 01 D7 8B 4C 24 78 85 C9 74 7C 8B 44 24 6C 8B 54 24 6C 83 E8 01 85 D2 74 26 89 6C 24 74 8B AC 24 08 01 00 00 66 90 0F B6 0C 03 8B 55 3C 8B 14 8A 88 14 07 83 E8 01 83 F8 FF 75 EB 8B 6C 24 74 03 7C 24 6C 89 E8 83 C5 01 0F B6 50 01 01 74 24 68 84 D2 0F 85 D6 FD FF FF 85 FF 0F 84 C6 FE FF FF 8B 44 24 70 85 C0 0F 84 BA FE FF FF C6 07 00 E9 B2 FE FF FF 66 90 C7 44 24 04 30 00 00 00 E9 6D FF FF FF 8D 76 00 8B 54 24 6C 89 5C 24 04 89 3C 24 89 54 24 08 E8 ?? ?? ?? ?? EB A3 C7 84 24 80 00 00 00 01 00 00 00 31 D2 B8 01 00 00 00 8B 4C 24 78 85 DB 0F 44 84 24 80 00 00 00 0F 45 CA 89 84 24 80 00 00 00 8B 84 24 00 01 00 00 89 4C 24 78 8B 8C 24 84 00 00 00 8B 58 08 31 C0 83 FB 0B 0F 9F C0 83 C0 2E 8B 44 81 04 89 54 24 20 89 04 24 E8 ?? ?? ?? ?? 8B 54 24 20 89 F1 89 44 24 6C 8B 74 24 6C 29 C1 89 D0 0F 49 C1 01 C6 8B 44 24 70 2B 44 24 68 39 C6 0F 83 01 FE FF FF 85 FF 0F 84 1E FF FF FF 85 C9 7E 33 83 7C 24 74 30 89 4C 24 08 0F 84 28 14 00 00 89 3C 24 C7 44 24 04 20 00 00 00 89 4C 24 24 E8 ?? ?? ?? ?? 8B 94 24 00 01 00 00 8B 4C 24 24 8B 5A 08 01 CF 8B 8C 24 80 00 00 00 31 C0 83 FB 0C 0F 9D C0 83 C0 2E 85 C9 0F 84 F0 12 00 00 8B 8C 24 84 00 00 00 8B 54 24 6C 8B 5C 81 04 8B 44 24 6C 83 E8 01 85 D2 0F 84 AB FE FF FF 89 6C 24 74 8B AC 24 08 01 00 00 8D B4 26 00 00 00 00 0F B6 0C 03 8B 55 38 8B 14 8A 88 14 07 83 E8 01 83 F8 FF 75 EB E9 7B FE FF FF C7 84 24 80 00 00 00 00 00 00 00 E9 D7 FE FF FF C7 44 24 6C ?? ?? ?? ?? 8D B6 00 00 00 00 8B 8C 24 00 01 00 00 8B 84 24 08 01 00 00 8B 94 24 04 01 00 00 89 0C 24 8B 4C 24 6C 89 44 24 08 31 C0 89 54 24 04 BA FF FF FF FF E8 78 FB FF FF 89 F1 8B 54 24 70 89 C3 31 C0 29 D9 0F 49 C1 2B 54 24 68 01 D8 89 84 24 80 00 00 00 39 D0 0F 83 EC FC FF FF 85 FF 0F 84 6A 13 00 00 85 C9 89 FE 7E 32 83 7C 24 74 30 89 4C 24 08 0F 84 0A 12 00 00 C7 44 24 04 20 00 00 00 89 3C 24 89 54 24 20 89 4C 24 24 E8 ?? ?? ?? ?? 8B 4C 24 24 8B 54 24 20 8D 34 0F 8B 84 24 08 01 00 00 01 F3 8B 8C 24 04 01 00 00 89 44 24 08 8B 84 24 00 01 00 00 89 4C 24 04 8B 4C 24 6C 89 04 24 89 F0 E8 E7 FA FF FF 8B 4C 24 78 8B 94 24 80 00 00 00 01 54 24 68 85 C9 74 27 39 FB 76 23 8B B4 24 08 01 00 00 89 F8 8D B4 26 00 00 00 00 0F B6 08 83 C0 01 8B 56 3C 8B 14 8A 88 50 FF 39 C3 75 ED 89 E8 89 DF E9 3D FB FF FF C7 44 24 6C ?? ?? ?? ?? E9 EF FE FF FF 83 7C 24 6C 45 0F 84 94 FC FF FF 8B 84 24 00 01 00 00 83 FE 02 B9 02 00 00 00 0F 4D CE BB 93 24 49 92 89 8C 24 80 00 00 00 8B 40 18 89 C1 83 C1 06 89 C8 F7 EB 8D 04 0A 89 CA C1 FA 1F C1 F8 02 29 D0 8D 14 C5 00 00 00 00 29 C2 8B 84 24 00 01 00 00 29 CA 8B 40 1C 8D 4C 02 07 89 C8 F7 EB 8D 1C 0A C1 FB 02 C1 F9 1F 29 CB 90 8D 74 26 00 85 DB 0F 89 A8 0F 00 00 89 D9 C1 E9 1F 89 4C 24 6C 8B 44 24 6C 89 D9 F7 D9 85 C0 0F 44 CB 8D 9C 24 B4 00 00 00 8D 76 00 B8 CD CC CC CC 83 EB 01 F7 E1 C1 EA 03 8D 04 92 01 C0 29 C1 83 C1 30 85 D2 88 0B 89 D1 75 E1 8B 44 24 6C 85 C0 74 07 C6 43 FF 2D 83 EB 01 83 7C 24 74 2D 74 75 8B 94 24 80 00 00 00 89 D8 2B 44 24 64 01 C2 85 D2 7E 62 8B 44 24 70 2B 44 24 68 83 7C 24 74 5F 0F 84 35 10 00 00 39 84 24 80 00 00 00 0F 83 30 FB FF FF 8B 74 24 6C 85 F6 74 12 83 C3 01 85 FF 74 06 C6 07 2D 83 C7 01 83 44 24 68 01 85 FF 74 1E 89 54 24 08 89 3C 24 C7 44 24 04 30 00 00 00 89 54 24 20 E8 ?? ?? ?? ?? 8B 54 24 20 01 D7 01 54 24 68 31 F6 8B 54 24 64 31 C0 29 DA 89 54 24 6C 89 F2 8B 74 24 6C 2B 54 24 6C 0F 49 C2 01 C6 8B 44 24 70 2B 44 24 68 39 C6 0F 83 C3 FA FF FF 85 FF 0F 84 E0 FB FF FF 85 D2 7E 29 83 7C 24 74 30 89 54 24 08 0F 84 90 0F 00 00 C7 44 24 04 20 00 00 00 89 3C 24 89 54 24 20 E8 ?? ?? ?? ?? 8B 54 24 20 01 D7 8B 4C 24 78 85 C9 0F 84 4A 0F 00 00 8B 44 24 6C 8B 54 24 6C 83 E8 01 85 D2 0F 84 90 FB FF FF 89 6C 24 74 8B AC 24 08 01 00 00 8D 74 26 00 0F B6 0C 03 8B 55 3C 8B 14 8A 88 14 07 83 E8 01 83 F8 FF 75 EB E9 63 FB FF FF 8B 44 24 6C 85 C0 0F 85 AA FA FF FF 8B 94 24 00 01 00 00 85 DB B8 01 00 00 00 0F 44 44 24 78 8B 8C 24 84 00 00 00 89 44 24 78 0F B7 42 18 8B 5C 81 24 89 1C 24 E8 ?? ?? ?? ?? 89 F2 29 C2 89 84 24 80 00 00 00 8B 44 24 6C 8B B4 24 80 00 00 00 0F 49 C2 01 C6 8B 44 24 70 2B 44 24 68 39 C6 0F 83 E1 F9 FF FF 85 FF 0F 84 FE FA FF FF 85 D2 7E 3F 83 7C 24 74 30 89 54 24 08 0F 84 44 14 00 00 C7 44 24 04 20 00 00 00 89 3C 24 89 54 24 20 E8 ?? ?? ?? ?? 8B 54 24 20 8B 8C 24 84 00 00 00 01 D7 8B 94 24 00 01 00 00 0F B7 42 18 8B 5C 81 24 8B 4C 24 78 8B 84 24 80 00 00 00 85 C9 0F 84 1D 0F 00 00 8B 94 24 80 00 00 00 83 E8 01 85 D2 74 26 89 6C 24 74 8B AC 24 08 01 00 00 66 90 0F B6 0C 03 8B 55 3C 8B 14 8A 88 14 07 83 E8 01 83 F8 FF 75 EB 8B 6C 24 74 03 BC 24 80 00 00 00 E9 68 FA FF FF 83 7C 24 6C 45 0F 84 0C 12 00 00 83 7C 24 6C 4F 0F 84 9D F9 FF FF 8B 84 24 00 01 00 00 85 F6 B9 01 00 00 00 0F 4F CE 89 8C 24 80 00 00 00 8B 40 14 89 C3 81 C3 6C 07 00 00 E9 45 FD FF FF 83 FB 01 B8 00 00 00 00 19 C9 83 C1 01 85 DB 0F 44 44 24 78 89 4C 24 6C 89 44 24 78 8B 84 24 88 00 00 00 85 C0 74 0C 8B 84 24 88 00 00 00 80 38 00 75 3B 8B 94 24 00 01 00 00 8B 42 20 85 C0 78 1E 8B 8C 24 04 01 00 00 80 39 00 0F 84 EC 12 00 00 8B 04 85 ?? ?? ?? ?? 89 84 24 88 00 00 00 8B 84 24 88 00 00 00 85 C0 0F 84 57 11 00 00 8B 8C 24 88 00 00 00 89 0C 24 E8 ?? ?? ?? ?? 89 C3 89 F1 31 D2 29 C1 0F 49 D1 8D 34 02 8B 44 24 70 2B 44 24 68 39 C6 0F 83 6A F8 FF FF 85 FF 0F 84 87 F9 FF FF 85 C9 7E 29 83 7C 24 74 30 89 4C 24 08 0F 84 EB 10 00 00 C7 44 24 04 20 00 00 00 89 3C 24 89 4C 24 24 E8 ?? ?? ?? ?? 8B 4C 24 24 01 CF 8B 44 24 6C 85 C0 0F 84 20 0E 00 00 85 DB 8D 43 FF 74 37 89 6C 24 74 8B AC 24 08 01 00 00 89 74 24 78 8B B4 24 88 00 00 00 8D 74 26 00 0F B6 0C 06 8B 55 38 8B 14 8A 88 14 07 83 E8 01 83 F8 FF 75 EB 8B 6C 24 74 8B 74 24 78 01 DF E9 09 F9 FF FF 83 7C 24 6C 4F 0F 84 49 F8 FF FF 83 7C 24 6C 45 0F 84 E0 0E 00 00 8B 8C 24 84 00 00 00 8B 89 CC 00 00 00 89 4C 24 6C E9 78 FA FF FF 8B 84 24 00 01 00 00 85 F6 B9 01 00 00 00 0F 4F CE BA 93 24 49 92 89 8C 24 80 00 00 00 8B 40 18 89 C3 83 C3 06 89 D8 F7 EA 8D 04 1A 89 DA C1 FA 1F C1 F8 02 29 D0 8D 14 C5 00 00 00 00 29 C2 29 D3 83 C3 01 E9 AF FB FF FF 8B 5C 24 6C 85 DB 0F 85 D3 F7 FF FF C7 44 24 6C ?? ?? ?? ?? E9 16 FA FF FF 8B 5C 24 6C 85 DB 0F 85 BA F7 FF FF C7 44 24 6C ?? ?? ?? ?? E9 FD F9 FF FF 83 7C 24 6C 45 0F 84 72 10 00 00 8B 8C 24 00 01 00 00 B8 01 00 00 00 BA 1F 85 EB 51 8B 49 14 89 4C 24 3C 81 C1 6C 07 00 00 85 F6 0F 4F C6 89 84 24 80 00 00 00 89 C8 F7 EA 89 C8 C1 F8 1F C1 FA 05 29 C2 6B C2 64 89 D3 29 C1 89 C8 C1 E8 1F 29 C3 E9 27 FB FF FF 8B 44 24 6C 85 C0 0F 85 4B F7 FF FF 8B 94 24 00 01 00 00 85 DB B8 01 00 00 00 0F 44 44 24 78 8B 8C 24 84 00 00 00 8B 52 10 89 44 24 78 89 D0 05 1A 00 02 00 25 FF FF 00 00 8B 5C 81 24 89 1C 24 E8 ?? ?? ?? ?? 89 F2 29 C2 89 84 24 80 00 00 00 8B 44 24 6C 8B B4 24 80 00 00 00 0F 49 C2 01 C6 8B 44 24 70 2B 44 24 68 39 C6 0F 83 77 F6 FF FF 85 FF 0F 84 94 F7 FF FF 85 D2 7E 4A 83 7C 24 74 30 89 54 24 08 0F 84 6B 11 00 00 89 3C 24 C7 44 24 04 20 00 00 00 89 54 24 20 E8 ?? ?? ?? ?? 8B 8C 24 00 01 00 00 8B 54 24 20 8B 49 10 01 D7 8B 94 24 84 00 00 00 89 C8 05 1A 00 02 00 25 FF FF 00 00 8B 5C 82 24 8B 4C 24 78 8B 84 24 80 00 00 00 85 C9 0F 84 A8 0B 00 00 8B 94 24 80 00 00 00 83 E8 01 85 D2 0F 84 AD FC FF FF 89 6C 24 74 8B AC 24 08 01 00 00 90 0F B6 0C 03 8B 55 3C 8B 14 8A 88 14 07 83 E8 01 83 F8 FF 75 EB E9 83 FC FF FF 83 7C 24 6C 45 0F 84 3B F6 FF FF 8B 84 24 00 01 00 00 83 FE 02 B9 02 00 00 00 0F 4D CE 89 8C 24 80 00 00 00 8B 40 10 89 C3 83 C3 01 E9 E5 F9 FF FF 83 7C 24 6C 45 0F 84 0A F6 FF FF 8B 5C 24 7C 83 FE 02 B9 02 00 00 00 0F 4D CE 89 8C 24 80 00 00 00 83 7C 24 74 2D 0F 84 B9 F9 FF FF 83 7C 24 74 30 B8 5F 00 00 00 0F 44 44 24 74 89 44 24 74 E9 A1 F9 FF FF 8B 8C 24 84 00 00 00 B8 ?? ?? ?? ?? 8B 89 D0 00 00 00 80 39 00 0F 45 C1 89 44 24 6C E9 00 F8 FF FF 83 7C 24 6C 45 0F 84 A5 F5 FF FF 8B 84 24 00 01 00 00 83 FE 02 B9 02 00 00 00 0F 4D CE BA 93 24 49 92 89 8C 24 80 00 00 00 8B 48 1C 2B 48 18 83 C1 07 89 C8 F7 EA 8D 1C 0A C1 FB 02 C1 F9 1F 29 CB E9 3A F9 FF FF 83 7C 24 6C 45 0F 84 5F F5 FF FF 8B 84 24 00 01 00 00 83 FE 02 B9 02 00 00 00 0F 4D CE 89 8C 24 80 00 00 00 8B 18 E9 0F F9 FF FF 83 7C 24 6C 45 0F 84 34 F5 FF FF 8B 84 24 00 01 00 00 83 FE 02 B9 02 00 00 00 0F 4D CE 89 8C 24 80 00 00 00 8B 58 04 E9 E3 F8 FF FF 83 7C 24 6C 45 0F 84 08 F5 FF FF 83 FE 02 B9 02 00 00 00 8B 5C 24 7C 0F 4D CE 89 8C 24 80 00 00 00 E9 BD F8 FF FF 83 7C 24 6C 45 0F 84 E2 F4 FF FF 8B 84 24 00 01 00 00 83 FE 02 B9 02 00 00 00 0F 4D CE 89 8C 24 80 00 00 00 8B 58 08 E9 91 F8 FF FF 8B 44 24 6C 85 C0 0F 85 B5 F4 FF FF 8B 94 24 00 01 00 00 85 DB B8 01 00 00 00 0F 44 44 24 78 8B 8C 24 84 00 00 00 8B 52 18 89 44 24 78 89 D0 05 07 00 02 00 25 FF FF 00 00 8B 5C 81 24 89 1C 24 E8 ?? ?? ?? ?? 89 F2 29 C2 89 84 24 80 00 00 00 8B 44 24 6C 8B B4 24 80 00 00 00 0F 49 C2 01 C6 8B 44 24 70 2B 44 24 68 39 C6 0F 83 E1 F3 FF FF 85 FF 0F 84 FE F4 FF FF 85 D2 7E 4A 83 7C 24 74 30 89 54 24 08 0F 84 51 0E 00 00 89 3C 24 C7 44 24 04 20 00 00 00 89 54 24 20 E8 ?? ?? ?? ?? 8B 8C 24 00 01 00 00 8B 54 24 20 8B 49 18 01 D7 8B 94 24 84 00 00 00 89 C8 05 07 00 02 00 25 FF FF 00 00 8B 5C 82 24 8B 4C 24 78 8B 84 24 80 00 00 00 85 C9 0F 84 12 09 00 00 8B 94 24 80 00 00 00 83 E8 01 85 D2 0F 84 17 FA FF FF 89 6C 24 74 8B AC 24 08 01 00 00 8D 76 00 0F B6 0C 03 8B 55 3C 8B 14 8A 88 14 07 83 E8 01 83 F8 FF 75 EB E9 EB F9 FF FF 0F B6 4D FF 83 ED 01 E9 F9 F2 FF FF 89 F3 31 C0 83 EB 01 0F 49 C3 8D 70 01 8B 44 24 70 2B 44 24 68 39 C6 0F 83 15 F3 FF FF 85 FF 0F 84 32 F4 FF FF 85 DB 7E 21 83 7C 24 74 30 89 5C 24 08 0F 84 A3 0B 00 00 89 3C 24 01 DF C7 44 24 04 20 00 00 00 E8 ?? ?? ?? ?? C6 07 0A 83 C7 01 E9 02 F4 FF FF 8B 44 24 6C 85 C0 0F 85 A1 F2 FF FF 8B 44 24 6C 89 F3 83 EB 01 0F 49 C3 8D 70 01 8B 44 24 70 2B 44 24 68 39 C6 0F 83 B2 F2 FF FF 85 FF 0F 84 CF F3 FF FF 85 DB B8 25 00 00 00 7E 25 83 7C 24 74 30 89 5C 24 08 0F 84 F5 0C 00 00 89 3C 24 01 DF C7 44 24 04 20 00 00 00 E8 ?? ?? ?? ?? 0F B6 45 00 88 07 83 C7 01 E9 97 F3 FF FF 8B 94 24 00 01 00 00 8B 5A 20 85 DB 0F 88 F1 08 00 00 8B 5A 24 85 DB 0F 88 68 0A 00 00 89 F1 31 D2 8B 44 24 70 83 E9 01 0F 49 D1 2B 44 24 68 83 C2 01 39 C2 0F 83 38 F2 FF FF 85 FF 74 3B 85 C9 7E 31 83 7C 24 74 30 89 4C 24 08 0F 84 77 0C 00 00 C7 44 24 04 20 00 00 00 89 3C 24 89 54 24 20 89 4C 24 24 E8 ?? ?? ?? ?? 8B 4C 24 24 8B 54 24 20 01 CF C6 07 2B 83 C7 01 01 54 24 68 B8 89 88 88 88 F7 EB B8 89 88 88 88 8D 0C 1A BA 04 00 00 00 C1 FB 1F C1 F9 05 29 D9 83 FE 04 0F 4D D6 89 94 24 80 00 00 00 F7 E9 8D 04 0A 89 CA C1 F8 05 C1 FA 1F 29 D0 6B C0 28 8D 1C 08 E9 F2 F5 FF FF 83 7C 24 6C 45 0F 84 A2 0A 00 00 8B 84 24 00 01 00 00 83 FE 02 B9 02 00 00 00 }
	condition:
		$1
}

rule file_222_1_0 {
	meta:
		name = "__strftime_l"
		size = 52
	strings:
		$1 = { 83 EC 2C 8B 44 24 40 8B 4C 24 38 8B 54 24 34 C6 44 24 1F 00 89 44 24 08 8D 44 24 1F 89 44 24 04 8B 44 24 3C 89 04 24 8B 44 24 30 E8 B0 E2 FF FF 83 C4 2C C3 }
	condition:
		$1
}

rule file_223_0_0 {
	meta:
		name = "__atomic_preadv64_replacement"
		size = 366
		refs = "0099 __libc_pread64 00e8 memcpy 00ff free 0111 __libc_errno 014c __libc_alloca_cutoff 015c malloc"
	strings:
		$1 = { 55 89 E5 57 56 89 D6 53 83 EC 4C 8B 55 0C 85 C9 89 45 E0 8B 45 08 89 4D E4 89 55 DC 89 45 D8 0F 8E 1C 01 00 00 8B 4E 04 81 F9 FF FF FF 7F 0F 87 DC 00 00 00 31 C0 31 DB BF FF FF FF 7F EB 11 90 8B 4C C6 04 89 FA 29 DA 39 CA 0F 82 C0 00 00 00 01 CB 83 C0 01 3B 45 E4 75 E6 81 FB 00 10 00 00 0F 87 E2 00 00 00 8D 43 1E 83 E0 F0 29 C4 8D 7C 24 23 83 E7 F0 C7 45 D4 00 00 00 00 8B 45 D8 8B 55 DC 89 5C 24 08 89 7C 24 04 89 44 24 0C 8B 45 E0 89 54 24 10 89 04 24 E8 ?? ?? ?? ?? 85 C0 89 45 E0 0F 88 90 00 00 00 89 C3 8B 45 E4 85 C0 7E 47 89 FA 31 C9 89 F7 EB 12 8D B4 26 00 00 00 00 83 C1 01 83 C7 08 3B 4D E4 74 2D 8B 07 89 DE 39 5F 04 0F 46 77 04 89 54 24 04 89 04 24 89 74 24 08 89 55 D0 89 4D CC E8 ?? ?? ?? ?? 8B 55 D0 8B 4D CC 01 F2 29 F3 75 C8 8B 55 D4 89 14 24 E8 ?? ?? ?? ?? 8B 45 E0 8D 65 F4 5B 5E 5F 5D C2 08 00 A1 ?? ?? ?? ?? C7 45 E0 FF FF FF FF 65 C7 00 16 00 00 00 8B 45 E0 8D 65 F4 5B 5E 5F 5D C2 08 00 C7 45 D4 00 00 00 00 90 C7 45 E0 FF FF FF FF EB B7 31 DB E9 1E FF FF FF 89 1C 24 E8 ?? ?? ?? ?? 85 C0 0F 85 0E FF FF FF 89 1C 24 E8 ?? ?? ?? ?? 85 C0 89 C7 74 CA 89 45 D4 E9 0E FF FF FF }
	condition:
		$1
}

rule file_223_1_0 {
	meta:
		name = "preadv64"
		size = 240
		refs = "0038 _dl_sysinfo 0069 __libc_errno 0093 __libc_enable_asynccancel 00c0 __libc_disable_asynccancel"
	strings:
		$1 = { 83 EC 3C 89 5C 24 2C 8B 54 24 48 89 74 24 30 8B 5C 24 40 89 7C 24 34 8B 74 24 4C 89 6C 24 38 8B 7C 24 50 65 A1 0C 00 00 00 85 C0 75 61 8B 4C 24 44 B8 4D 01 00 00 FF 15 ?? ?? ?? ?? 3D 00 F0 FF FF 0F 87 86 00 00 00 89 C1 89 CD 85 ED 78 19 89 E8 8B 5C 24 2C 8B 74 24 30 8B 7C 24 34 8B 6C 24 38 83 C4 3C C3 8D 76 00 A1 ?? ?? ?? ?? 65 83 38 26 75 DC 89 D1 8B 54 24 44 89 D8 89 34 24 89 7C 24 04 E8 09 FE FF FF 83 EC 08 89 C5 EB C1 89 54 24 18 E8 ?? ?? ?? ?? 8B 54 24 18 8B 4C 24 44 89 44 24 1C B8 4D 01 00 00 FF 15 ?? ?? ?? ?? 3D 00 F0 FF FF 77 2B 89 C5 8B 44 24 1C 89 54 24 18 E8 ?? ?? ?? ?? 8B 54 24 18 E9 7E FF FF FF 8B 0D ?? ?? ?? ?? F7 D8 65 89 01 83 C9 FF E9 69 FF FF FF 8B 0D ?? ?? ?? ?? F7 D8 65 89 01 83 C8 FF EB C5 }
	condition:
		$1
}

rule file_224_0_0 {
	meta:
		name = "__wcsncpy"
		size = 194
	strings:
		$1 = { 57 56 53 8B 5C 24 18 8B 44 24 10 8B 4C 24 14 83 FB 03 8D 50 FC 76 3A 89 DF C1 EF 02 8B 31 85 F6 89 72 04 74 63 8B 71 04 85 F6 89 72 08 0F 84 7D 00 00 00 8B 71 08 85 F6 89 72 0C 74 7B 8B 71 0C 83 C2 10 83 C1 10 85 F6 89 32 74 3F 83 EF 01 75 CB 83 E3 03 74 28 66 90 8B 31 83 C2 04 83 C1 04 83 EB 01 89 32 74 17 85 F6 75 ED 90 8D 74 26 00 83 C2 04 83 EB 01 C7 02 00 00 00 00 75 F2 5B 5E 5F C3 8D B6 00 00 00 00 83 C2 04 89 D1 29 C1 C1 F9 02 F7 D9 8D 5C 0B FF 85 DB 74 E2 83 C2 04 83 EB 01 C7 02 00 00 00 00 75 C6 EB D2 8D 74 26 00 83 C2 08 EB D6 8D 76 00 83 C2 0C 90 8D 74 26 00 EB C9 }
	condition:
		$1
}

rule file_225_0_0 {
	meta:
		name = "__wcschrnul"
		size = 50
	strings:
		$1 = { 8B 44 24 04 8B 4C 24 08 8B 10 85 D2 74 1D 39 CA 75 10 EB 19 8D 74 26 00 39 CA 8D B6 00 00 00 00 74 09 83 C0 04 8B 10 85 D2 75 ED F3 C3 8D 76 00 F3 C3 }
	condition:
		$1
}

rule file_226_0_0 {
	meta:
		name = "timerfd_create"
		size = 35
		refs = "0011 _dl_sysinfo 001e __syscall_error"
	strings:
		$1 = { 89 DA 8B 4C 24 08 8B 5C 24 04 B8 42 01 00 00 FF 15 ?? ?? ?? ?? 89 D3 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_228_0_0 {
	meta:
		name = "lrand48_r"
		size = 47
		refs = "001b __nrand48_r"
	strings:
		$1 = { 83 EC 1C 8B 44 24 20 85 C0 74 1D 8B 54 24 24 89 44 24 04 89 04 24 89 54 24 08 E8 ?? ?? ?? ?? 83 C4 1C C3 90 8D 74 26 00 B8 FF FF FF FF EB F0 }
	condition:
		$1
}

rule file_1023_0_0 {
	meta:
		name = "mrand48_r"
		size = 47
		refs = "001b __jrand48_r"
	strings:
		$1 = { 83 EC 1C 8B 44 24 20 85 C0 74 1D 8B 54 24 24 89 44 24 04 89 04 24 89 54 24 08 E8 ?? ?? ?? ?? 83 C4 1C C3 90 8D 74 26 00 B8 FF FF FF FF EB F0 }
	condition:
		$1
}

rule file_229_0_0 {
	meta:
		name = "getw"
		size = 58
		refs = "0023 _IO_fread"
	strings:
		$1 = { 83 EC 2C 8B 44 24 30 C7 44 24 08 01 00 00 00 C7 44 24 04 04 00 00 00 89 44 24 0C 8D 44 24 1C 89 04 24 E8 ?? ?? ?? ?? BA FF FF FF FF 83 F8 01 0F 44 54 24 1C 83 C4 2C 89 D0 C3 }
	condition:
		$1
}

rule file_230_0_0 {
	meta:
		name = "__dcgettext"
		size = 59
		refs = "0033 __dcigettext"
	strings:
		$1 = { 83 EC 2C 8B 44 24 38 C7 44 24 10 00 00 00 00 C7 44 24 0C 00 00 00 00 C7 44 24 08 00 00 00 00 89 44 24 14 8B 44 24 34 89 44 24 04 8B 44 24 30 89 04 24 E8 ?? ?? ?? ?? 83 C4 2C C3 }
	condition:
		$1
}

rule file_231_0_0 {
	meta:
		name = "tcsendbreak"
		size = 96
		refs = "0033 __ioctl"
	strings:
		$1 = { 83 EC 1C 8B 44 24 24 85 C0 7E 35 8D 48 63 BA 1F 85 EB 51 89 C8 F7 EA 8B 44 24 20 C1 F9 1F C7 44 24 04 25 54 00 00 C1 FA 05 29 CA 89 54 24 08 89 04 24 E8 ?? ?? ?? ?? 83 C4 1C C3 90 8D 74 26 00 8B 44 24 20 C7 44 24 08 00 00 00 00 C7 44 24 04 09 54 00 00 89 04 24 E8 ?? ?? ?? ?? 83 C4 1C C3 }
	condition:
		$1
}

rule file_234_0_0 {
	meta:
		name = "_IO_mem_sync"
		size = 78
		refs = "0044 _IO_str_overflow"
	strings:
		$1 = { 53 83 EC 18 8B 5C 24 20 8B 43 14 3B 43 18 74 28 C6 00 00 8B 83 A0 00 00 00 8B 53 10 89 10 8B 43 14 8B 93 A4 00 00 00 2B 43 10 89 02 83 C4 18 31 C0 5B C3 90 8D 74 26 00 C7 44 24 04 00 00 00 00 89 1C 24 E8 ?? ?? ?? ?? 83 6B 14 01 EB C5 }
	condition:
		$1
}

rule file_234_1_0 {
	meta:
		name = "_IO_mem_finish"
		size = 105
		refs = "0022 realloc 0065 _IO_str_finish"
	strings:
		$1 = { 56 53 83 EC 14 8B 5C 24 20 8B 53 10 8B 43 14 8B B3 A0 00 00 00 89 14 24 29 D0 83 C0 01 89 44 24 04 E8 ?? ?? ?? ?? 89 06 8B 83 A0 00 00 00 8B 10 85 D2 74 1F 8B 43 14 2B 43 10 C6 04 02 00 8B 43 14 8B 93 A4 00 00 00 2B 43 10 89 02 C7 43 1C 00 00 00 00 89 5C 24 20 C7 44 24 24 00 00 00 00 83 C4 14 5B 5E E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_234_2_0 {
	meta:
		name = "open_memstream"
		size = 172
		refs = "000d malloc 0033 calloc 0049 _IO_init 006b _IO_str_init_static_internal 0090 free"
	strings:
		$1 = { 56 53 83 EC 14 C7 04 24 70 01 00 00 E8 ?? ?? ?? ?? 85 C0 0F 84 8F 00 00 00 89 C3 05 A8 00 00 00 89 43 48 C7 44 24 04 00 20 00 00 C7 04 24 01 00 00 00 E8 ?? ?? ?? ?? 85 C0 89 C6 74 6B C7 44 24 04 00 00 00 00 89 1C 24 E8 ?? ?? ?? ?? C7 83 94 00 00 00 ?? ?? ?? ?? 89 74 24 0C C7 44 24 08 00 20 00 00 89 74 24 04 89 1C 24 E8 ?? ?? ?? ?? 8B 44 24 20 83 23 FE C7 83 98 00 00 00 ?? ?? ?? ?? 89 83 A0 00 00 00 8B 44 24 24 C7 83 9C 00 00 00 ?? ?? ?? ?? 89 83 A4 00 00 00 89 D8 83 C4 14 5B 5E C3 8D B6 00 00 00 00 31 C0 EB F0 }
	condition:
		$1
}

rule file_235_0_0 {
	meta:
		name = "__getrusage"
		size = 35
		refs = "0011 _dl_sysinfo 001e __syscall_error"
	strings:
		$1 = { 89 DA 8B 4C 24 08 8B 5C 24 04 B8 4D 00 00 00 FF 15 ?? ?? ?? ?? 89 D3 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_236_0_0 {
	meta:
		name = "profil_count"
		size = 232
	strings:
		$1 = { 8B 0D ?? ?? ?? ?? 55 89 C5 57 56 53 3B 41 10 72 07 3B 41 14 89 CB 72 41 8B 3D ?? ?? ?? ?? 31 F6 A1 ?? ?? ?? ?? 83 EF 01 EB 12 8D B6 00 00 00 00 3B 69 14 72 5B 8D 73 01 39 F7 72 17 8D 1C 3E D1 EB 8D 0C 5B 8D 0C C8 3B 69 10 73 E4 8D 7B FF 39 F7 73 E9 8B 1D ?? ?? ?? ?? 89 E8 8B 73 08 2B 03 85 D2 74 4C C1 E8 02 F7 E6 0F AC D0 10 39 41 04 76 2C 8B 51 0C 8D 14 82 8B 02 83 F8 FF 74 2A 83 C0 01 89 02 5B 5E 5F 5D C3 8D B4 26 00 00 00 00 89 0D ?? ?? ?? ?? 8B 1D ?? ?? ?? ?? EB BB A1 ?? ?? ?? ?? 8B 40 0C 83 00 01 5B 5E 5F 5D C3 66 90 D1 E8 F7 E6 0F AC D0 10 39 41 04 76 1A 8B 51 0C 8D 14 42 0F B7 02 66 83 F8 FF 74 DD 83 C0 01 66 89 02 5B 5E 5F 5D C3 A1 ?? ?? ?? ?? 8B 40 0C 66 83 00 01 5B 5E 5F 5D C3 }
	condition:
		$1
}

rule file_236_1_0 {
	meta:
		name = "profil_counter_ushort"
		size = 18
	strings:
		$1 = { 83 EC 04 31 D2 8B 44 24 44 E8 02 FF FF FF 83 C4 04 C3 }
	condition:
		$1
}

rule file_236_2_0 {
	meta:
		name = "profil_counter_uint"
		size = 21
	strings:
		$1 = { 83 EC 04 BA 01 00 00 00 8B 44 24 44 E8 DF FE FF FF 83 C4 04 C3 }
	condition:
		$1
}

rule file_236_3_0 {
	meta:
		name = "pcmp"
		size = 33
	strings:
		$1 = { 8B 44 24 04 8B 00 8B 50 08 8B 44 24 08 8B 00 8B 48 08 B8 01 00 00 00 39 CA 72 04 39 D1 19 C0 F3 C3 }
	condition:
		$1
}

rule file_236_4_0 {
	meta:
		name = "insert.part.0"
		size = 298
		refs = "0036 malloc 00dc realloc 0111 memmove"
	strings:
		$1 = { 83 EC 3C 89 74 24 30 89 C6 A1 ?? ?? ?? ?? 89 7C 24 34 8B 7C 24 40 89 5C 24 2C 89 6C 24 38 85 C0 89 54 24 18 89 4C 24 1C 0F 85 9A 00 00 00 C7 04 24 18 00 00 00 E8 ?? ?? ?? ?? 89 C5 85 ED 0F 84 DF 00 00 00 A1 ?? ?? ?? ?? 89 44 24 14 29 F0 0F 85 9B 00 00 00 8D 04 76 8D 5C C5 00 83 7C 24 44 01 8B 47 04 8B 77 08 19 C9 31 D2 83 E1 FE 83 C1 04 F7 F1 8B 57 0C 89 33 89 53 08 89 43 04 8B 07 89 2D ?? ?? ?? ?? 89 43 0C 8B 44 24 18 89 43 10 8B 44 24 1C 89 43 14 8B 44 24 14 83 C0 01 A3 ?? ?? ?? ?? 31 C0 85 F6 75 05 83 FA 02 74 3A 8B 5C 24 2C 8B 74 24 30 8B 7C 24 34 8B 6C 24 38 83 C4 3C C3 8D B6 00 00 00 00 8D 44 40 03 C1 E0 03 89 44 24 04 A1 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 89 C5 E9 55 FF FF FF 90 89 2D ?? ?? ?? ?? EB BE 8D 04 40 C1 E0 03 8D 14 76 89 44 24 08 8D 44 76 03 8D 5C D5 00 8D 44 C5 00 89 5C 24 04 89 04 24 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 89 44 24 14 E9 39 FF FF FF B8 FF FF FF FF EB 84 }
	condition:
		$1
}

rule file_236_5_0 {
	meta:
		name = "__sprofil"
		size = 1091
		refs = "002c __profile_frequency 00bd qsort 0135 __udivdi3 02c9 __sigaction 031b __setitimer 0379 free 043f __assert_fail"
	strings:
		$1 = { 55 89 E5 57 56 53 81 EC DC 00 00 00 8B 75 0C 8B 5D 10 C1 E6 02 8D 46 12 83 E0 F0 29 C4 85 DB 8D 44 24 10 89 85 34 FF FF FF 74 2C E8 ?? ?? ?? ?? 89 C7 B8 40 42 0F 00 89 C2 C1 FA 1F F7 FF BA 83 DE 1B 43 89 C1 F7 E2 C1 EA 12 89 13 69 D2 40 42 0F 00 29 D1 89 4B 04 A1 ?? ?? ?? ?? 85 C0 0F 85 3A 03 00 00 8B 7D 0C C7 05 ?? ?? ?? ?? 00 00 00 00 C7 05 ?? ?? ?? ?? ?? ?? ?? ?? 85 FF 0F 8E 72 03 00 00 8B 85 34 FF FF FF 8B 55 08 01 C6 66 90 89 10 83 C0 04 83 C2 10 39 F0 75 F4 8B 45 0C 8B 95 34 FF FF FF C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 04 00 00 00 89 44 24 04 89 14 24 E8 ?? ?? ?? ?? 8B 45 14 C7 85 38 FF FF FF 00 00 00 00 83 E0 01 89 85 3C FF FF FF 90 8B 95 38 FF FF FF 8B 85 34 FF FF FF 8B 14 90 8B 5A 0C 89 95 40 FF FF FF 83 FB 01 0F 86 54 01 00 00 8B B5 3C FF FF FF 8B 7A 04 85 F6 0F 84 1E 02 00 00 8B 85 40 FF FF FF C1 EF 02 31 D2 0F A4 FA 12 8B 70 08 89 F8 C1 E0 12 89 5C 24 08 C7 44 24 0C 00 00 00 00 89 04 24 89 54 24 04 E8 ?? ?? ?? ?? B9 04 00 00 00 8D 14 30 89 95 44 FF FF FF 31 D2 F7 F1 F7 E3 0F AC D0 10 39 F8 89 F0 83 95 44 FF FF FF 00 F7 D0 03 85 44 FF FF FF 83 BD 3C FF FF FF 01 19 C9 31 D2 83 E1 FE 83 C1 04 F7 F1 F7 E3 0F AC D0 10 39 C7 0F 86 9A 02 00 00 8B 85 44 FF FF FF 29 F0 83 BD 3C FF FF FF 01 19 C9 31 D2 83 E1 FE 83 C1 04 F7 F1 F7 E3 0F AC D0 10 39 C7 0F 87 71 02 00 00 8B 3D ?? ?? ?? ?? 31 DB 31 C0 8B 15 ?? ?? ?? ?? 85 FF 74 5B 89 D0 89 F2 89 C6 8D 3C 5B C1 E7 03 8D 04 3E 8B 48 10 39 D1 76 33 3B 8D 44 FF FF FF 77 39 8B 85 3C FF FF FF 89 44 24 04 8B 85 40 FF FF FF 89 04 24 89 D8 E8 D6 FC FF FF 85 C0 0F 88 6E 01 00 00 8B 35 ?? ?? ?? ?? 8D 04 3E 83 C3 01 8B 50 14 3B 1D ?? ?? ?? ?? 72 AF 89 D6 89 D8 3B B5 44 FF FF FF 73 28 8B 95 3C FF FF FF 8B 8D 44 FF FF FF 89 54 24 04 8B 95 40 FF FF FF 89 14 24 89 F2 E8 8B FC FF FF 85 C0 0F 88 23 01 00 00 83 85 38 FF FF FF 01 8B 45 0C 39 85 38 FF FF FF 0F 85 75 FE FF FF 8B 1D ?? ?? ?? ?? 31 C0 85 DB 0F 84 23 01 00 00 A1 ?? ?? ?? ?? BA ?? ?? ?? ?? F6 45 14 01 C7 45 E0 00 00 00 10 A3 ?? ?? ?? ?? B8 ?? ?? ?? ?? 0F 44 C2 89 85 5C FF FF FF 8D 95 5C FF FF FF 8D 45 DC 8D 74 26 00 C7 00 FF FF FF FF 83 E8 04 39 D0 75 F3 C7 44 24 08 ?? ?? ?? ?? 89 44 24 04 C7 04 24 1B 00 00 00 E8 ?? ?? ?? ?? 85 C0 0F 88 BC 00 00 00 C7 85 54 FF FF FF 00 00 00 00 8B 85 54 FF FF FF C7 85 58 FF FF FF 01 00 00 00 8B 95 58 FF FF FF C7 44 24 08 ?? ?? ?? ?? C7 04 24 02 00 00 00 89 85 4C FF FF FF 8D 85 4C FF FF FF 89 44 24 04 89 95 50 FF FF FF E8 ?? ?? ?? ?? 8D 65 F4 5B 5E 5F 5D C3 90 8B 95 40 FF FF FF D1 EF 89 F8 C1 E0 11 8B 72 08 31 D2 0F A4 FA 11 89 5C 24 08 C7 44 24 0C 00 00 00 00 89 04 24 89 54 24 04 E8 ?? ?? ?? ?? B9 02 00 00 00 8D 14 30 89 95 44 FF FF FF E9 DE FD FF FF 8D B4 26 00 00 00 00 A1 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 00 00 00 00 C7 05 ?? ?? ?? ?? 00 00 00 00 B8 FF FF FF FF 8D 65 F4 5B 5E 5F 5D C3 C7 44 24 08 00 00 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 02 00 00 00 E8 ?? ?? ?? ?? 85 C0 78 D3 C7 44 24 08 00 00 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 1B 00 00 00 E8 ?? ?? ?? ?? 85 C0 78 B3 A1 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 8D 65 F4 31 C0 5B 5E 5F 5D C3 8B 55 0C 8B 85 34 FF FF FF C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 04 00 00 00 89 54 24 04 89 04 24 E8 ?? ?? ?? ?? E9 44 FE FF FF C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 65 00 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_237_0_0 {
	meta:
		name = "__memrchr"
		size = 214
	strings:
		$1 = { 57 56 53 8B 54 24 18 8B 4C 24 10 0F B6 5C 24 14 01 D1 85 D2 0F 84 B5 00 00 00 F6 C1 03 74 38 38 59 FF 8D 41 FF 75 14 EB 2A 8D B4 26 00 00 00 00 A8 03 74 2C 83 E8 01 38 18 74 18 83 EA 01 75 F0 31 D2 89 C1 29 D1 89 CA 39 D0 74 7F 83 E8 01 38 18 75 F5 5B 5E 5F C3 89 C8 8D B4 26 00 00 00 00 0F B6 74 24 14 89 F1 C1 E1 08 09 F1 89 CF C1 E7 10 09 CF 83 FA 03 77 1E EB C8 8D B6 00 00 00 00 38 58 02 74 38 38 58 01 74 3A 38 18 74 C5 83 EA 04 83 FA 03 76 AC 83 E8 04 8B 30 31 FE 89 F1 81 C6 FF FE FE 7E F7 D1 31 F1 81 E1 00 01 01 81 74 DD 38 58 03 75 CA 5B 83 C0 03 5E 5F C3 5B 83 C0 02 5E 5F C3 5B 83 C0 01 5E 5F C3 31 C0 EB 84 89 C8 E9 6A FF FF FF }
	condition:
		$1
}

rule file_238_2_0 {
	meta:
		name = "rewinddir"
		size = 101
		refs = "0036 __lseek"
	strings:
		$1 = { 53 31 C0 83 EC 18 B9 01 00 00 00 8B 5C 24 20 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 4B 04 75 45 C7 44 24 08 00 00 00 00 C7 44 24 04 00 00 00 00 8B 03 89 04 24 E8 ?? ?? ?? ?? C7 43 14 00 00 00 00 C7 43 10 00 00 00 00 C7 43 0C 00 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 83 6B 04 01 75 0F 83 C4 18 5B C3 }
	condition:
		$1
}

rule file_239_0_0 {
	meta:
		name = "__fgets_unlocked_chk"
		size = 185
		refs = "005b _IO_getline 008f __libc_errno 00b5 __chk_fail"
	strings:
		$1 = { 83 EC 3C 8B 44 24 48 89 5C 24 2C 8B 5C 24 4C 89 74 24 30 8B 74 24 44 89 7C 24 34 85 C0 89 6C 24 38 0F 8E 89 00 00 00 8B 13 83 E8 01 8B 6C 24 40 89 D7 83 E2 DF 83 E7 20 39 F0 0F 47 C6 89 13 C7 44 24 10 01 00 00 00 C7 44 24 0C 0A 00 00 00 89 44 24 08 89 6C 24 04 89 1C 24 E8 ?? ?? ?? ?? 8B 13 85 C0 89 C1 75 21 31 C0 09 FA 89 13 8B 5C 24 2C 8B 74 24 30 8B 7C 24 34 8B 6C 24 38 83 C4 3C C3 8D B4 26 00 00 00 00 F6 C2 20 74 0F 8B 2D ?? ?? ?? ?? 31 C0 65 83 7D 00 0B 75 CD 39 CE 76 14 8B 6C 24 40 C6 44 0D 00 00 89 E8 8B 13 EB BA 90 31 C0 EB B9 E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_240_0_0 {
	meta:
		name = "ntp_gettimex"
		size = 104
		refs = "001e __adjtimex"
	strings:
		$1 = { 53 81 EC 98 00 00 00 8D 44 24 10 8B 9C 24 A0 00 00 00 89 04 24 C7 44 24 10 00 00 00 00 E8 ?? ?? ?? ?? 8B 54 24 34 8B 4C 24 38 C7 43 14 00 00 00 00 C7 43 18 00 00 00 00 89 13 8B 54 24 1C 89 4B 04 C7 43 1C 00 00 00 00 C7 43 20 00 00 00 00 89 53 08 8B 54 24 20 89 53 0C 8B 54 24 60 89 53 10 81 C4 98 00 00 00 5B C3 }
	condition:
		$1
}

rule file_241_0_0 {
	meta:
		name = "__stpcpy"
		size = 65
	strings:
		$1 = { 8B 44 24 04 8B 4C 24 08 29 C1 81 E8 04 00 00 00 83 C0 04 8A 14 08 88 10 84 D2 74 24 8A 54 08 01 88 50 01 84 D2 74 18 8A 54 08 02 88 50 02 84 D2 74 0C 8A 54 08 03 88 50 03 84 D2 75 D3 40 40 40 C3 }
	condition:
		$1
}

rule file_242_0_0 {
	meta:
		name = "_dl_build_local_scope"
		size = 104
	strings:
		$1 = { 57 89 C7 56 53 8D 70 04 89 10 0F B6 82 94 01 00 00 83 E0 9F 83 C8 20 88 82 94 01 00 00 8B 82 F0 01 00 00 85 C0 74 36 8B 50 04 8D 58 04 85 D2 75 10 EB 2A 90 8D 74 26 00 83 C3 04 8B 13 85 D2 74 1C F6 82 94 01 00 00 60 75 EE 89 F0 83 C3 04 E8 AC FF FF FF 8B 13 85 D2 8D 34 86 75 E4 89 F0 29 F8 5B C1 F8 02 5E 5F C3 }
	condition:
		$1
}

rule file_242_1_0 {
	meta:
		name = "openaux"
		size = 74
		refs = "003a _dl_map_object"
	strings:
		$1 = { 56 B9 01 00 00 00 53 83 EC 14 8B 5C 24 20 8B 03 0F B6 90 94 01 00 00 83 E2 03 84 D2 0F B6 F2 8B 53 10 0F 45 CE 8B 70 18 89 74 24 08 8B 73 08 89 74 24 04 8B 73 04 89 34 24 E8 ?? ?? ?? ?? 83 EC 0C 89 43 14 83 C4 14 5B 5E C3 }
	condition:
		$1
}

rule file_242_2_0 {
	meta:
		name = "_dl_map_object_deps"
		size = 4108
		refs = "00a9 __libc_errno 0173 strchr 019c _dl_catch_error 0205 malloc 022e memcpy 0296 _dl_dst_count 02a7 __libc_enable_secure 02b7 strlen 02ef _dl_platformlen 033a _dl_dst_substitute 0349 _dl_debug_mask 0360 _dl_debug_printf 03c3 _dl_get_origin 04b6 _dl_signal_error 07a5 memset 089a memmove 08f3 _dl_scope_free 0a36 __assert_fail 0b0a free 0bbc _dl_argv 0e2f _dl_ns"
	strings:
		$1 = { 55 89 E5 57 89 CF 56 53 81 EC 9C 00 00 00 89 45 8C 8D 04 49 8B 4D 8C 8D 04 85 36 00 00 00 83 E0 F0 29 C4 8B 45 8C 8D 74 24 1F 83 E6 F0 89 B5 74 FF FF FF 89 46 04 8D 46 0C C7 06 00 00 00 00 89 46 08 0F B6 81 94 01 00 00 83 E0 9F 83 C8 20 85 FF 88 81 94 01 00 00 0F 84 1A 0A 00 00 8D 1C BA 89 D1 8D 46 18 89 5D B4 8B 19 83 C1 04 C7 40 F4 00 00 00 00 89 40 FC 83 C0 0C 89 58 EC 0F B6 93 94 01 00 00 83 E2 9F 83 CA 20 88 93 94 01 00 00 3B 4D B4 75 D3 8D 5F 01 8D 04 7F 8B 7E 04 89 5D A0 C1 E0 02 89 7D B4 8B 1D ?? ?? ?? ?? 01 F0 8B 3D ?? ?? ?? ?? 89 45 A4 C7 40 08 00 00 00 00 65 8B 1B C7 45 C8 00 00 00 00 65 C7 07 00 00 00 00 89 75 94 89 9D 78 FF FF FF C7 85 7C FF FF FF 00 00 00 00 C7 45 80 00 00 00 00 8B 7D B4 8B 75 94 C7 45 AC 00 00 00 00 8B 87 5C 01 00 00 C7 06 01 00 00 00 85 C0 0F 84 2C 03 00 00 8B 75 B4 8B 46 24 85 C0 0F 84 F6 02 00 00 8B 7D B4 8B 75 0C 8B 5D 08 8B 47 34 89 7D D0 8B 40 04 89 75 D8 8B 77 08 89 5D D4 89 45 A8 89 45 DC 8B 06 85 C0 0F 84 E7 02 00 00 8B 7D 94 C7 45 B0 00 00 00 00 89 7D 90 8D B4 26 00 00 00 00 83 F8 01 0F 85 AB 07 00 00 8B 7D A8 03 7E 04 C7 44 24 04 24 00 00 00 89 3C 24 E8 ?? ?? ?? ?? 85 C0 0F 85 0B 01 00 00 89 F8 89 45 E0 8D 45 D0 89 44 24 04 8D 4D C7 C7 04 24 ?? ?? ?? ?? 8D 55 C8 8D 45 CC E8 ?? ?? ?? ?? 8B 7D C8 83 EC 08 85 FF 0F 85 0C 03 00 00 8B 45 E4 F6 80 94 01 00 00 60 0F 84 B2 01 00 00 8B 55 AC 85 D2 74 0F 8B 5D B0 8B 7D AC 89 04 9F 83 C3 01 89 5D B0 83 C6 08 8B 06 85 C0 0F 85 77 FF FF FF 8B 4D AC 85 C9 74 71 8B 5D B0 8B 75 AC C7 04 9E 00 00 00 00 89 DE 83 C6 01 8D 04 F5 04 00 00 00 89 04 24 E8 ?? ?? ?? ?? 85 C0 89 C3 0F 84 78 08 00 00 8B 7D B4 C1 E6 02 83 C0 04 89 78 FC 89 74 24 08 8B 7D AC 89 04 24 89 7C 24 04 E8 ?? ?? ?? ?? 8B 7D B0 89 74 24 08 89 5C 24 04 8D 44 BB 08 89 04 24 E8 ?? ?? ?? ?? 8B 75 B4 80 8E 96 01 00 00 01 89 9E F0 01 00 00 8B 5D 94 8B 03 85 C0 74 1A 8B 45 94 8D 76 00 8B 40 08 85 C0 0F 84 8D 0D 00 00 8B 10 85 D2 75 EF 89 45 94 8B 5D 94 8B 5B 04 89 5D B4 E9 60 FE FF FF C7 44 24 04 00 00 00 00 89 04 24 E8 ?? ?? ?? ?? 85 C0 89 45 9C 0F 84 DA FE FF FF 8B 0D ?? ?? ?? ?? 85 C9 0F 85 F5 01 00 00 89 3C 24 E8 ?? ?? ?? ?? 8B 55 B4 89 C1 89 C3 8B 82 A8 01 00 00 85 C0 0F 84 E0 00 00 00 83 F8 FF 0F 84 2F 01 00 00 89 04 24 89 8D 70 FF FF FF E8 ?? ?? ?? ?? 8B 8D 70 FF FF FF 83 3D ?? ?? ?? ?? 03 BA 03 00 00 00 0F 43 15 ?? ?? ?? ?? 39 C2 0F 43 C2 83 F8 04 76 0A 83 E8 04 0F AF 45 9C 8D 1C 01 83 C3 1E 83 E3 F0 29 DC 8D 44 24 1F 83 E0 F0 C7 44 24 0C 00 00 00 00 89 44 24 08 89 7C 24 04 8B 5D B4 89 1C 24 E8 ?? ?? ?? ?? 80 38 00 0F 85 3A FE FF FF F6 05 ?? ?? ?? ?? 01 0F 84 80 FE FF FF 89 7C 24 04 C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? E9 6B FE FF FF 8D B4 26 00 00 00 00 8B 7D A4 83 EC 20 8D 54 24 1F 83 E2 F0 83 45 A0 01 C7 42 08 00 00 00 00 89 42 04 C7 02 00 00 00 00 89 57 08 0F B6 88 94 01 00 00 83 E1 9F 83 C9 20 88 88 94 01 00 00 89 55 A4 E9 0F FE FF FF 90 8B 42 04 80 38 00 0F 85 08 0C 00 00 89 8D 70 FF FF FF E8 ?? ?? ?? ?? 8B 8D 70 FF FF FF 89 C2 8B 45 B4 89 90 A8 01 00 00 8D 42 FF 89 45 98 31 C0 83 7D 98 FD 0F 87 03 FF FF FF 89 14 24 89 8D 70 FF FF FF E8 ?? ?? ?? ?? 8B 8D 70 FF FF FF E9 EA FE FF FF 90 8D 74 26 00 31 C0 E9 DE FE FF FF 8B BE F0 00 00 00 85 FF 0F 85 FC FC FF FF 8B 9E E8 00 00 00 85 DB 0F 85 EE FC FF FF C7 45 B0 00 00 00 00 E9 AA FD FF FF 8B 87 F0 01 00 00 85 C0 0F 85 C6 FC FF FF 39 7D 8C 0F 84 BD FC FF FF 0F B7 87 5A 01 00 00 66 85 C0 0F 84 AD FC FF FF 8B 5D 80 C1 E0 02 3B 85 7C FF FF FF 89 5D AC 0F 86 98 FC FF FF 83 C0 0F 83 E0 F0 8D 50 1E 81 E2 F0 FF 0F 00 29 D4 8D 54 24 1F 83 E2 F0 8D 0C 02 39 CB 0F 84 52 0B 00 00 89 55 AC 89 85 7C FF FF FF 89 55 80 E9 64 FC FF FF 90 C7 04 24 ?? ?? ?? ?? 31 C9 89 FA 31 C0 E8 ?? ?? ?? ?? 89 3C 24 89 85 70 FF FF FF E8 ?? ?? ?? ?? 8D 48 01 83 C0 1F 83 E0 F0 29 C4 8D 44 24 1F 83 E0 F0 89 4C 24 08 89 7C 24 04 89 04 24 E8 ?? ?? ?? ?? 8B 5D CC 89 1C 24 89 C6 E8 ?? ?? ?? ?? 8D 48 01 83 C0 1F 83 E0 F0 29 C4 8D 44 24 1F 83 E0 F0 89 4C 24 08 89 5C 24 04 89 04 24 E8 ?? ?? ?? ?? 8B 95 70 FF FF FF 80 7D C7 00 89 45 CC 0F 85 ED 09 00 00 C7 45 A4 FF FF FF FF 85 D2 0F 44 55 A4 89 75 C8 89 55 A4 8B 3D ?? ?? ?? ?? 65 8B 07 85 C0 75 13 8B 85 78 FF FF FF 85 C0 74 09 8B 9D 78 FF FF FF 65 89 1F 8B 45 8C 8B 80 F0 01 00 00 85 C0 89 45 98 74 1C 8B 55 8C 0F B6 82 94 01 00 00 83 E0 03 3C 02 0F 84 84 04 00 00 C7 45 98 00 00 00 00 8B 5D A0 8D 04 DD 04 00 00 00 89 04 24 E8 ?? ?? ?? ?? 85 C0 89 45 AC 0F 84 58 09 00 00 8B 5D A0 31 C9 8B 75 AC 8B 7D 8C 8B 95 74 FF FF FF C7 45 B4 00 00 00 00 8D 44 9E 04 89 9F 60 01 00 00 89 FB 89 87 5C 01 00 00 8B 7D 08 85 FF 8B 42 04 0F 85 A0 08 00 00 8B B3 5C 01 00 00 89 04 8E 8B 42 04 83 C1 01 80 A0 94 01 00 00 9F 8B 52 08 85 D2 75 D8 F6 05 ?? ?? ?? ?? 08 89 4D B4 0F 85 20 08 00 00 8B 7D 8C 8B 87 5C 01 00 00 8B 10 39 FA 89 55 A0 0F 85 E6 07 00 00 8B 4D 8C 8B B1 F4 01 00 00 85 F6 0F 84 AA 07 00 00 83 7D B4 01 76 25 8B 4D B4 8D 50 04 8D 1C 88 8B 0A 83 C2 04 0F B6 81 94 01 00 00 83 E0 9F 83 C8 20 39 DA 88 81 94 01 00 00 75 E4 8B 3E 8D 5E 04 89 5D 94 85 FF 0F 84 C8 00 00 00 31 FF EB 1A 8B 55 A0 8B 92 F4 01 00 00 89 55 A8 8B 5D A8 83 C7 01 39 3B 0F 86 AA 00 00 00 8B 44 BE 04 F6 80 94 01 00 00 60 74 D9 8B 4D A0 8B 81 F8 01 00 00 8D 04 85 04 00 00 00 89 04 24 E8 ?? ?? ?? ?? 85 C0 89 C3 0F 84 A3 01 00 00 8D 14 BD 00 00 00 00 83 C0 04 89 54 24 08 8B 55 94 89 04 24 89 54 24 04 E8 ?? ?? ?? ?? 8B 55 A0 8D 4F 01 89 4D 9C 8B 45 9C 8B 92 F4 01 00 00 8B 0A 89 55 A8 39 C1 89 F8 89 4D B0 0F 86 D7 06 00 00 8B 55 9C 8B 4C 96 04 F6 81 94 01 00 00 60 75 07 89 4C 83 04 83 C0 01 83 C2 01 3B 55 B0 75 E4 8B 4D 9C 89 03 8D 54 0A FF 29 FA 89 D7 8B 5D A8 83 C7 01 39 3B 0F 87 56 FF FF FF 83 7D B4 01 0F 86 69 06 00 00 8B 4D A0 8B 5D B4 8B 91 5C 01 00 00 C1 E3 02 89 5D 9C 8D 42 04 01 D3 8B 08 83 C0 04 80 A1 94 01 00 00 9F 39 D8 75 F0 8B 75 9C 89 54 24 04 89 74 24 08 8B 45 AC 89 04 24 E8 ?? ?? ?? ?? 8B 55 B4 89 65 84 01 D2 8D 42 10 83 E0 F0 29 C4 8D 4C 24 10 89 4D A8 89 0C 24 89 54 24 08 C7 44 24 04 00 00 00 00 E8 ?? ?? ?? ?? 8B 5D B4 B9 01 00 00 00 8B 75 B4 8B 45 AC C7 45 B0 02 00 00 00 83 EB 01 89 5D 90 8D 74 B0 FC 89 75 88 8B 7D A8 8B 45 AC 66 83 04 4F 01 3B 4D 90 8D 04 88 89 45 94 8B 18 73 34 8B 7D 88 8B 75 90 8D B4 26 00 00 00 00 8B 07 8B 80 F0 01 00 00 85 C0 75 0B EB 0F 66 90 83 C0 04 39 D3 74 69 8B 10 85 D2 75 F3 83 EE 01 83 EF 04 39 F1 72 D9 8B 4D B0 39 4D B4 0F 84 A2 00 00 00 8B 5D B0 8B 55 B4 8B 75 A8 2B 55 B0 C7 44 24 04 00 00 00 00 8D 04 5E 01 D2 89 54 24 08 83 C3 01 89 04 24 89 8D 70 FF FF FF E8 ?? ?? ?? ?? 8B 8D 70 FF FF FF 89 5D B0 E9 6C FF FF FF 8B 5D A0 8B 9B F4 01 00 00 89 5D A8 E9 0F FE FF FF 89 F2 29 CA 89 D0 C1 E0 02 89 55 8C 89 44 24 08 8B 45 AC 8B 55 B0 8D 14 90 89 54 24 04 8B 45 94 89 04 24 89 8D 70 FF FF FF E8 ?? ?? ?? ?? 8B 8D 70 FF FF FF 89 1F 8B 5D B0 8B 7D A8 8B 45 B4 0F B7 14 5F 29 C8 39 C2 0F 86 83 01 00 00 8B 4D B0 E9 5E FF FF FF 8B 65 84 8B 45 AC 8B 7D 9C C7 04 38 00 00 00 00 8B 55 A0 80 8A 96 01 00 00 01 8B 5D 98 89 82 F0 01 00 00 85 DB 74 0B 8B 4D 98 89 0C 24 E8 ?? ?? ?? ?? 8B 4D A4 85 C9 0F 85 35 04 00 00 8D 65 F4 5B 5E 5F 5D C2 08 00 83 E0 FD 3D FD FF FF 7F 0F 85 BA F8 FF FF 8B 7D A8 03 7E 04 C7 44 24 04 24 00 00 00 89 3C 24 E8 ?? ?? ?? ?? 85 C0 0F 85 F1 02 00 00 89 F8 81 3E FD FF FF 7F 89 45 E0 0F 84 92 02 00 00 F6 05 ?? ?? ?? ?? 01 0F 85 59 02 00 00 8D 45 D0 89 44 24 04 8D 4D C7 C7 04 24 ?? ?? ?? ?? 8D 55 C8 8D 45 CC E8 ?? ?? ?? ?? 8B 7D C8 83 EC 08 85 FF 89 45 9C 0F 85 21 01 00 00 8B 7D 90 83 EC 20 8D 5C 24 1F 83 E3 F0 8B 07 89 03 8B 47 04 89 43 04 8B 47 08 89 43 08 8B 45 E4 C7 07 00 00 00 00 89 47 04 8B 7D AC 85 FF 74 12 8B 7D B0 8B 55 AC 89 04 BA 8B 45 E4 83 C7 01 89 7D B0 F6 80 94 01 00 00 60 0F 84 B7 01 00 00 89 D9 EB 0D 66 90 39 42 04 0F 84 46 01 00 00 89 D1 8B 51 08 85 D2 75 EE 8B 03 8B 7D 90 89 07 8B 43 04 89 47 04 8B 43 08 89 47 08 E9 D2 F7 FF FF 8D B6 00 00 00 00 8B 82 5C 01 00 00 85 C0 0F 84 75 FB FF FF C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 FD 01 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D B6 00 00 00 00 8B 45 8C 0F B7 1C 4F 01 C0 89 44 24 08 8B 55 B0 8D 04 57 89 44 24 04 8D 04 4F 89 04 24 89 8D 70 FF FF FF E8 ?? ?? ?? ?? 8B 8D 70 FF FF FF 66 89 1C 77 E9 54 FD FF FF 8B 45 8C C7 45 A0 01 00 00 00 89 45 B4 31 C0 E9 1C F6 FF FF 8B 45 8C 31 C9 8B 50 04 B8 0C 00 00 00 C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 3C 24 E8 ?? ?? ?? ?? 8D 48 01 83 C0 1F 83 E0 F0 29 C4 8D 44 24 1F 83 E0 F0 89 4C 24 08 89 7C 24 04 89 04 24 E8 ?? ?? ?? ?? 8B 5D CC 89 1C 24 89 C6 E8 ?? ?? ?? ?? 8D 48 01 83 C0 1F 83 E0 F0 29 C4 8D 44 24 1F 83 E0 F0 89 4C 24 08 89 5C 24 04 89 04 24 E8 ?? ?? ?? ?? 80 7D C7 00 89 45 CC 74 08 89 3C 24 E8 ?? ?? ?? ?? 8B 45 9C 89 75 C8 85 C0 B8 FF FF FF FF 0F 45 45 9C 89 45 A4 E9 18 FA FF FF 8B 7D 90 89 5F 08 8B 51 08 3B 55 A4 8B 7D A4 8B 52 08 0F 44 F9 89 7D A4 89 51 08 8B 48 10 85 C9 74 06 8B 50 0C 89 51 0C 8B 50 0C 85 D2 74 03 89 4A 10 8B 53 04 8B 4A 10 89 48 10 89 42 10 8B 48 10 85 C9 74 03 89 41 0C 8B 7D A4 39 7D 90 89 50 0C 89 5D 90 0F 85 53 F6 FF FF 89 5D A4 E9 4B F6 FF FF 8B 7D 90 83 45 A0 01 8B 48 10 89 5F 08 0F B6 90 94 01 00 00 83 E2 9F 83 CA 20 85 C9 88 90 94 01 00 00 75 9C EB A0 8B 5D B4 8B 53 04 80 3A 00 75 08 8B 15 ?? ?? ?? ?? 8B 12 89 54 24 08 89 44 24 04 C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? E9 7B FD FF FF F6 05 ?? ?? ?? ?? 01 0F 85 96 01 00 00 8D 45 D0 89 44 24 04 8D 4D C7 C7 04 24 ?? ?? ?? ?? 8D 55 C8 8D 45 CC E8 ?? ?? ?? ?? 8B 45 C8 83 EC 08 85 C0 0F 84 71 FD FF FF 80 7D C7 00 0F 84 B8 F5 FF FF 89 04 24 E8 ?? ?? ?? ?? E9 AB F5 FF FF C7 44 24 04 00 00 00 00 89 04 24 E8 ?? ?? ?? ?? 85 C0 89 C3 0F 84 F5 FC FF FF A1 ?? ?? ?? ?? 85 C0 0F 85 58 F8 FF FF 89 3C 24 E8 ?? ?? ?? ?? 8B 55 B4 89 45 98 89 45 9C 8B 82 A8 01 00 00 85 C0 0F 84 95 00 00 00 83 F8 FF 0F 84 85 00 00 00 89 04 24 E8 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 03 BA 03 00 00 00 0F 43 15 ?? ?? ?? ?? 39 C2 0F 43 C2 83 F8 04 76 0C 83 E8 04 0F AF C3 03 45 98 89 45 9C 8B 45 9C 83 C0 1E 83 E0 F0 29 C4 8D 44 24 1F 83 E0 F0 C7 44 24 0C 00 00 00 00 89 44 24 08 89 7C 24 04 8B 5D B4 89 1C 24 E8 ?? ?? ?? ?? 80 38 00 0F 85 5B FC FF FF 81 3E FD FF FF 7F 0F 85 5C F6 FF FF C7 04 24 ?? ?? ?? ?? 31 C9 89 FA 31 C0 E8 ?? ?? ?? ?? 31 C0 E9 7C FF FF FF 8B 42 04 80 38 00 75 4E E8 ?? ?? ?? ?? 8B 4D B4 89 81 A8 01 00 00 8D 48 FF 89 C2 31 C0 83 F9 FD 0F 87 56 FF FF FF 89 14 24 E8 ?? ?? ?? ?? E9 49 FF FF FF 83 7D A4 FF B8 00 00 00 00 0F 45 45 A4 31 C9 8B 55 CC 89 45 A4 8B 45 C8 89 04 24 8B 45 A4 E8 ?? ?? ?? ?? C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 2F 01 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 7D B4 8B 57 04 80 3A 00 75 08 8B 15 ?? ?? ?? ?? 8B 12 89 54 24 08 89 44 24 04 C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? E9 3E FE FF FF 8B 7D A0 8B 75 B4 8B 87 5C 01 00 00 C1 E6 02 89 75 9C 89 74 24 08 89 44 24 04 8B 45 AC 89 04 24 E8 ?? ?? ?? ?? E9 F4 FA FF FF 8B 7D 9C 89 03 E9 4B F9 FF FF 8B 5D B4 C1 E3 02 89 5D 9C 89 5C 24 08 89 44 24 04 8B 45 AC 89 04 24 E8 ?? ?? ?? ?? 83 7D B4 01 0F 86 C4 FA FF FF E9 75 F9 FF FF C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 4E 02 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 3D ?? ?? ?? ?? 3B 7D 8C 0F 85 D1 F7 FF FF 85 C9 0F 84 C9 F7 FF FF 8B 5D AC C7 45 B0 00 00 00 00 8B 87 5C 01 00 00 8B 4D B0 8B 34 88 39 F7 74 11 8B 86 D0 01 00 00 85 C0 74 31 8B 40 04 85 C0 74 2A 83 45 B0 01 8B 75 B4 39 75 B0 75 D3 E9 8D F7 FF FF F6 80 95 01 00 00 02 0F 84 53 F7 FF FF 83 AB 60 01 00 00 01 E9 56 F7 FF FF 8B 96 F0 00 00 00 85 D2 0F 85 F4 00 00 00 8B 86 E8 00 00 00 85 C0 0F 85 E6 00 00 00 89 F2 89 D8 E8 82 F0 FF FF 3B 45 B4 89 C2 0F 87 AE 00 00 00 85 C0 74 65 8B 03 80 A0 94 01 00 00 9F 31 C0 83 C0 01 39 C2 74 53 8B 0C 83 80 A1 94 01 00 00 9F 85 C0 74 EB 8B 0C 83 8B 49 60 85 C9 74 E1 80 8E 95 01 00 00 80 EB D8 8B 45 8C 31 C9 8B 50 04 B8 0C 00 00 00 C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 3C 24 89 95 70 FF FF FF E8 ?? ?? ?? ?? 8B 95 70 FF FF FF E9 FA F5 FF FF 8D 04 95 08 00 00 00 89 04 24 89 95 70 FF FF FF E8 ?? ?? ?? ?? 8B 95 70 FF FF FF 85 C0 89 86 D0 01 00 00 74 5A 89 50 04 8D 48 08 C1 E2 02 89 08 89 54 24 08 89 5C 24 04 89 0C 24 E8 ?? ?? ?? ?? E9 F8 FE FF FF C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 35 02 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 56 04 31 C9 B8 16 00 00 00 C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 57 04 31 C9 B0 0C C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 FB 00 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 01 85 7C FF FF FF 89 55 80 89 55 AC E9 12 F1 FF FF 8D B4 26 00 00 00 00 }
	condition:
		$1
}

rule file_243_0_0 {
	meta:
		name = "dlinfo_doit"
		size = 231
		refs = "001f _dl_signal_error 00b1 strcpy 00dc _dl_tls_get_addr_soft 0082 _dl_rtld_di_serinfo"
	strings:
		$1 = { 53 83 EC 18 8B 5C 24 20 83 7B 08 0A 8B 43 04 76 17 C7 04 24 ?? ?? ?? ?? 31 C9 31 D2 31 C0 E8 ?? ?? ?? ?? 90 8D 74 26 00 8B 53 08 FF 24 95 ?? ?? ?? ?? 8D B6 00 00 00 00 8B 88 44 02 00 00 31 D2 85 C9 0F 85 90 00 00 00 8B 43 0C 89 10 83 C4 18 5B C3 8D B6 00 00 00 00 8B 50 18 8B 43 0C 89 10 83 C4 18 5B C3 8D 76 00 8B 53 0C 89 02 83 C4 18 5B C3 8D B6 00 00 00 00 8B 53 0C 83 C4 18 31 C9 5B E9 ?? ?? ?? ?? 66 90 8B 53 0C 83 C4 18 B9 01 00 00 00 5B E9 ?? ?? ?? ?? 8D B4 26 00 00 00 00 8B 80 A8 01 00 00 89 44 24 04 8B 43 0C 89 04 24 E8 ?? ?? ?? ?? 83 C4 18 5B C3 8D B6 00 00 00 00 8B 53 0C C7 02 00 00 00 00 8B 80 44 02 00 00 89 02 83 C4 18 5B C3 66 90 89 04 24 E8 ?? ?? ?? ?? 89 C2 E9 61 FF FF FF }
	condition:
		$1
}

rule file_243_1_0 {
	meta:
		name = "__dlinfo"
		size = 57
		refs = "002a _dlerror_run"
	strings:
		$1 = { 83 EC 1C 8B 44 24 2C 89 E2 89 04 24 8B 44 24 20 89 44 24 04 8B 44 24 24 89 44 24 08 8B 44 24 28 89 44 24 0C B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 F8 01 19 C0 83 C4 1C F7 D0 C3 }
	condition:
		$1
}

rule file_245_0_0 {
	meta:
		name = "_nl_init_alt_digit"
		size = 158
		refs = "002f malloc 0055 __rawmemchr 0092 _nl_cleanup_time"
	strings:
		$1 = { 57 56 53 89 C3 83 EC 10 8B 78 14 85 FF 74 5C 8B 47 14 85 C0 75 4E 8B B3 E0 00 00 00 C7 47 14 01 00 00 00 85 F6 74 3D C7 04 24 90 01 00 00 E8 ?? ?? ?? ?? 85 C0 89 47 0C 74 2A 31 DB EB 05 66 90 8B 47 0C 89 34 18 83 C3 04 89 34 24 C7 44 24 04 00 00 00 00 E8 ?? ?? ?? ?? 81 FB 90 01 00 00 8D 70 01 75 DC 83 C4 10 5B 5E 5F C3 C7 04 24 1C 00 00 00 E8 ?? ?? ?? ?? 31 D2 85 C0 89 43 14 74 E4 C7 04 10 00 00 00 00 83 C2 04 83 FA 1C 72 F1 C7 43 10 ?? ?? ?? ?? 8B 7B 14 E9 71 FF FF FF }
	condition:
		$1
}

rule file_245_1_0 {
	meta:
		name = "_nl_get_alt_digit"
		size = 130
		refs = "0018 __pthread_rwlock_wrlock 0025 __libc_setlocale_lock 0044 __pthread_rwlock_unlock"
	strings:
		$1 = { 56 53 83 EC 14 83 F8 63 77 6E 89 C6 8B 82 E0 00 00 00 80 38 00 74 61 B8 ?? ?? ?? ?? 89 D3 85 C0 74 09 C7 04 24 ?? ?? ?? ?? FF D0 8B 4B 14 85 C9 74 2E 8B 51 14 85 D2 74 27 8B 41 0C 85 C0 74 2E 8B 1C B0 B8 ?? ?? ?? ?? 85 C0 74 09 C7 04 24 ?? ?? ?? ?? FF D0 83 C4 14 89 D8 5B 5E C3 8D 76 00 89 D8 E8 F9 FE FF FF 8B 4B 14 85 C9 75 CB 31 DB EB D1 8D B6 00 00 00 00 31 DB 83 C4 14 89 D8 5B 5E C3 }
	condition:
		$1
}

rule file_245_2_0 {
	meta:
		name = "_nl_get_walt_digit"
		size = 253
		refs = "0023 __pthread_rwlock_wrlock 0030 __libc_setlocale_lock 0061 malloc 0085 wcschr 009f __pthread_rwlock_unlock 00f1 _nl_cleanup_time"
	strings:
		$1 = { 55 57 56 53 83 EC 1C 83 F8 63 0F 87 AA 00 00 00 89 C5 8B 82 AC 01 00 00 8B 18 85 DB 0F 84 98 00 00 00 B8 ?? ?? ?? ?? 89 D3 85 C0 74 09 C7 04 24 ?? ?? ?? ?? FF D0 8B 7B 14 85 FF 0F 84 85 00 00 00 8B 4F 18 85 C9 75 4C 8B B3 AC 01 00 00 C7 47 18 01 00 00 00 85 F6 74 3B C7 04 24 90 01 00 00 E8 ?? ?? ?? ?? 85 C0 89 47 10 74 6F 31 DB EB 03 8B 47 10 89 34 18 83 C3 04 89 34 24 C7 44 24 04 00 00 00 00 E8 ?? ?? ?? ?? 81 FB 90 01 00 00 8D 70 04 75 DC 8B 47 10 85 C0 74 40 8B 1C A8 B8 ?? ?? ?? ?? 85 C0 74 09 C7 04 24 ?? ?? ?? ?? FF D0 83 C4 1C 89 D8 5B 5E 5F 5D C3 83 C4 1C 31 DB 89 D8 5B 5E 5F 5D C3 C7 04 24 1C 00 00 00 E8 ?? ?? ?? ?? 31 D2 85 C0 89 43 14 75 04 31 DB EB BF C7 04 10 00 00 00 00 83 C2 04 83 FA 1C 72 F1 C7 43 10 ?? ?? ?? ?? 8B 7B 14 E9 44 FF FF FF }
	condition:
		$1
}

rule file_245_3_0 {
	meta:
		name = "_nl_parse_alt_digit"
		size = 254
		refs = "0024 __pthread_rwlock_wrlock 002f __libc_setlocale_lock 0073 strlen 008d strncmp 00ae __pthread_rwlock_unlock"
	strings:
		$1 = { 55 57 56 53 89 D3 83 EC 2C 8B 10 89 44 24 1C 8B 83 AC 01 00 00 89 54 24 18 8B 38 85 FF 0F 84 CC 00 00 00 B8 ?? ?? ?? ?? 85 C0 74 09 C7 04 24 ?? ?? ?? ?? FF D0 8B 4B 14 85 C9 0F 84 94 00 00 00 8B 71 14 85 F6 0F 84 89 00 00 00 8B 49 0C 85 C9 89 4C 24 10 0F 84 8C 00 00 00 BF FF FF FF FF 31 F6 31 DB 89 7C 24 14 90 8B 54 24 10 8B 3C 9A 89 3C 24 E8 ?? ?? ?? ?? 39 F0 89 C5 76 24 8B 54 24 18 89 44 24 08 89 3C 24 89 54 24 04 E8 ?? ?? ?? ?? 8B 54 24 14 85 C0 0F 44 D3 0F 44 F5 89 54 24 14 83 C3 01 83 FB 64 75 BF 8B 7C 24 14 B8 ?? ?? ?? ?? 85 C0 74 09 C7 04 24 ?? ?? ?? ?? FF D0 83 FF FF 74 2B 8B 44 24 1C 01 30 83 C4 2C 5B 89 F8 5E 5F 5D C3 89 D8 E8 F5 FC FF FF 8B 4B 14 85 C9 0F 85 65 FF FF FF 31 F6 BF FF FF FF FF EB BE 83 C4 2C BF FF FF FF FF 5B 89 F8 5E 5F 5D C3 }
	condition:
		$1
}

rule file_247_0_0 {
	meta:
		name = "is_dst"
		size = 209
	strings:
		$1 = { 57 31 FF 56 89 C6 53 0F B6 1A 80 FB 7B 0F 84 95 00 00 00 31 C0 3A 19 74 13 EB 25 90 8D 74 26 00 83 C0 01 0F B6 1C 02 3A 1C 01 75 14 84 DB 75 F0 89 F9 84 C9 74 1B 66 90 31 C0 5B 5E 5F C3 66 90 89 F9 84 C9 74 42 83 EA 01 83 C0 02 80 FB 7D 75 E7 8B 7C 24 14 85 FF 74 E1 0F B6 0C 02 80 F9 2F 74 57 84 C9 74 53 8B 5C 24 10 85 DB 74 CA 80 F9 3A 75 C5 83 C6 01 39 F2 74 C0 80 7A FE 3A BA 00 00 00 00 0F 45 C2 EB B2 80 FB 2F 74 C4 84 DB 74 C0 8B 4C 24 10 85 C9 74 9F 80 FB 3A 75 9A 66 90 EB AF 8D B6 00 00 00 00 0F B6 5A 01 BF 01 00 00 00 83 C2 01 E9 5A FF FF FF 83 C6 01 39 F2 0F 84 76 FF FF FF 8B 4C 24 10 85 C9 75 AE E9 67 FF FF FF }
	condition:
		$1
}

rule file_247_1_0 {
	meta:
		name = "local_strdup"
		size = 68
		refs = "0011 strlen 001c malloc 0030 memcpy"
	strings:
		$1 = { 83 EC 1C 89 04 24 89 5C 24 14 89 C3 89 74 24 18 E8 ?? ?? ?? ?? 8D 70 01 89 34 24 E8 ?? ?? ?? ?? 85 C0 74 1C 89 74 24 08 89 5C 24 04 89 04 24 E8 ?? ?? ?? ?? 8B 5C 24 14 8B 74 24 18 83 C4 1C C3 31 C0 EB F0 }
	condition:
		$1
}

rule file_247_2_0 {
	meta:
		name = "fillin_rpath"
		size = 726
		refs = "0030 __strsep_g 0042 strlen 0097 _dl_all_dirs 00c3 memcmp 0158 malloc 0183 mempcpy 01e8 memcpy 02ad _dl_signal_error"
	strings:
		$1 = { 55 57 89 D7 56 53 83 EC 3C 89 44 24 2C 89 4C 24 24 C7 44 24 20 00 00 00 00 8D B4 26 00 00 00 00 8B 44 24 24 8D 54 24 2C 89 14 24 89 44 24 04 E8 ?? ?? ?? ?? 85 C0 89 C6 0F 84 FB 01 00 00 89 34 24 E8 ?? ?? ?? ?? 85 C0 89 C3 0F 84 C0 01 00 00 83 F8 01 76 26 80 7C 06 FF 2F 74 17 E9 BF 01 00 00 8D B4 26 00 00 00 00 80 7C 1E FF 2F 0F 85 AD 01 00 00 83 EB 01 83 FB 01 75 ED 80 3E 2F BB 01 00 00 00 0F 85 97 01 00 00 8B 44 24 50 85 C0 0F 85 C8 01 00 00 8B 15 ?? ?? ?? ?? 85 D2 89 54 24 1C 74 75 89 D5 EB 08 90 8B 6D 00 85 ED 74 69 39 5D 10 75 F4 89 5C 24 08 8B 45 0C 89 34 24 89 44 24 04 E8 ?? ?? ?? ?? 85 C0 75 DD 8B 5C 24 20 85 DB 0F 84 77 01 00 00 3B 2F 0F 84 41 FF FF FF 8B 54 24 20 31 C0 8D 76 00 83 C0 01 39 D0 74 11 39 2C 87 75 F4 39 44 24 20 0F 85 22 FF FF FF 66 90 8D 0C 85 00 00 00 00 83 C0 01 89 44 24 20 89 2C 0F E9 0A FF FF FF 66 90 8B 6C 24 58 85 ED 0F 84 08 01 00 00 8B 54 24 58 89 14 24 E8 ?? ?? ?? ?? 83 C0 01 89 44 24 28 8B 0D ?? ?? ?? ?? 8D 14 8D 14 00 00 00 8D 44 13 01 03 44 24 28 89 54 24 18 89 4C 24 14 89 04 24 E8 ?? ?? ?? ?? 8B 54 24 18 8B 4C 24 14 85 C0 89 C5 0F 84 2E 01 00 00 01 D0 89 45 0C 89 5C 24 08 89 74 24 04 89 04 24 89 4C 24 14 E8 ?? ?? ?? ?? 3B 1D ?? ?? ?? ?? C6 00 00 8B 4C 24 14 89 5D 10 76 06 89 1D ?? ?? ?? ?? 31 D2 80 3E 2F 0F 95 C2 31 C0 01 D2 85 C9 74 0C 90 89 54 85 14 83 C0 01 39 C8 75 F5 8B 44 24 58 8B 54 24 54 85 C0 89 55 04 0F 84 C2 00 00 00 8B 54 24 28 8D 44 8B 15 01 E8 89 04 24 89 54 24 08 8B 54 24 58 89 54 24 04 E8 ?? ?? ?? ?? 89 45 08 8B 54 24 1C 89 2D ?? ?? ?? ?? 89 55 00 8B 54 24 20 89 2C 97 83 C2 01 89 54 24 20 E9 11 FE FF FF 90 BE ?? ?? ?? ?? E9 6F FE FF FF 8D B6 00 00 00 00 C6 04 1E 2F 83 C3 01 E9 5D FE FF FF C7 44 24 28 00 00 00 00 E9 FE FE FF FF 8B 54 24 20 89 F8 C7 04 97 00 00 00 00 83 C4 3C 5B 5E 5F 5D C3 C7 44 24 20 01 00 00 00 31 C9 E9 B1 FE FF FF 83 FB 05 74 4F 83 FB 09 0F 85 B5 FD FF FF C7 44 24 08 09 00 00 00 89 74 24 04 C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 0F 85 95 FD FF FF E9 05 FE FF FF C7 45 08 00 00 00 00 E9 53 FF FF FF C7 04 24 ?? ?? ?? ?? 31 C9 31 D2 B8 0C 00 00 00 E8 ?? ?? ?? ?? C7 44 24 08 05 00 00 00 89 74 24 04 C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 0F 85 4F FD FF FF E9 BF FD FF FF }
	condition:
		$1
}

rule file_247_3_0 {
	meta:
		name = "add_name_to_object"
		size = 224
		refs = "002b strcmp 0044 strlen 0055 malloc 0071 memcpy 00c7 __assert_fail 00dc _dl_signal_error"
	strings:
		$1 = { 55 89 E5 57 56 89 D6 53 83 EC 2C 8B 58 1C 85 DB 75 0F EB 7C 8D 74 26 00 8B 43 04 85 C0 74 21 89 C3 8B 03 89 34 24 89 44 24 04 E8 ?? ?? ?? ?? 85 C0 75 E5 8D 65 F4 5B 5E 5F 5D C3 90 8D 74 26 00 89 34 24 E8 ?? ?? ?? ?? 8D 50 01 83 C0 0D 89 04 24 89 55 E4 E8 ?? ?? ?? ?? 8B 55 E4 85 C0 89 C7 74 69 83 C0 0C 89 74 24 04 89 54 24 08 89 04 24 E8 ?? ?? ?? ?? C7 47 04 00 00 00 00 C7 47 08 00 00 00 00 89 7B 04 89 07 8D 65 F4 5B 5E 5F 5D C3 89 14 24 E8 ?? ?? ?? ?? 83 C0 0D 89 04 24 E8 ?? ?? ?? ?? 85 C0 74 24 C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 DA 01 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? 31 C9 89 F2 B8 0C 00 00 00 E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_247_4_0 {
	meta:
		name = "lose"
		size = 109
		refs = "001c __close 0033 free 0057 _dl_debug_state 0069 _dl_signal_error"
	strings:
		$1 = { 55 89 CD 57 89 C7 56 53 83 EC 1C 83 FA FF 8B 5C 24 34 8B 74 24 3C 74 08 89 14 24 E8 ?? ?? ?? ?? 85 DB 74 13 8B 83 A8 01 00 00 83 F8 FF 74 08 89 04 24 E8 ?? ?? ?? ?? 89 1C 24 E8 ?? ?? ?? ?? 8B 44 24 30 89 04 24 E8 ?? ?? ?? ?? 85 F6 74 0C C7 46 0C 00 00 00 00 E8 ?? ?? ?? ?? 8B 44 24 38 31 C9 89 EA 89 04 24 89 F8 E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_247_5_0 {
	meta:
		name = "_dl_map_object_from_fd"
		size = 3816
		refs = "0024 _dl_debug_initialize 0047 __fxstat64 0059 _dl_ns 00c6 __close 00d1 free 00fc _dl_debug_mask 0149 _dl_new_object 02c4 _dl_next_tls_modid 0302 _dl_pagesize 046a _dl_use_load_bias 0478 __mmap 0562 memset 07ba _dl_stack_flags 082c _dl_setup_hash 086d _dl_profile 0885 _dl_add_to_namespace_list 092e __mprotect 093f _dl_debug_state 097c __lseek 0992 __libc_read 0a12 _dl_initfirst 0ab3 malloc 0acd memcpy 0b0d __libc_errno 0b61 memmove 0bbd _dl_tls_dtv_slotinfo_list 0bca _dl_tls_setup 0bd9 _dl_allocate_tls 0bf3 _dl_sysinfo 0c33 _dl_tls_max_dtv_idx 0c5e _dl_deallocate_tls 0ca6 __assert_fail 0cf4 __stack_prot 0cfe _dl_make_stack_executable_hook 0e1e _dl_debug_printf 0e48 __munmap"
	strings:
		$1 = { 55 89 E5 57 56 53 81 EC 1C 01 00 00 89 95 48 FF FF FF 8B 55 1C 89 85 40 FF FF FF 31 C0 89 8D 4C FF FF FF E8 ?? ?? ?? ?? 89 85 44 FF FF FF 8D 45 88 89 44 24 08 8B 95 48 FF FF FF C7 04 24 03 00 00 00 89 54 24 04 E8 ?? ?? ?? ?? 85 C0 0F 88 32 0E 00 00 6B 45 1C 4C 8B B0 ?? ?? ?? ?? 85 F6 0F 84 8B 00 00 00 8B 45 8C 8B 5D E0 8B 4D E4 8B 7D 88 89 85 70 FF FF FF EB 0E 8D B4 26 00 00 00 00 8B 76 0C 85 F6 74 69 F6 86 95 01 00 00 20 75 F0 8B 96 E4 01 00 00 8B 86 E0 01 00 00 31 CA 31 D8 09 C2 75 DC 8B 86 D8 01 00 00 8B 95 70 FF FF FF 33 96 DC 01 00 00 31 F8 09 C2 75 C4 8B 95 48 FF FF FF 89 14 24 E8 ?? ?? ?? ?? 8B 4D 08 89 0C 24 E8 ?? ?? ?? ?? 8B 95 40 FF FF FF 89 F0 E8 CE FD FF FF 8D 65 F4 89 F0 5B 5E 5F 5D C3 8D 74 26 00 F6 45 14 04 0F 85 88 09 00 00 F6 05 ?? ?? ?? ?? 40 0F 85 91 0D 00 00 8B 95 44 FF FF FF 8B 42 0C 85 C0 0F 84 1F 08 00 00 83 F8 01 0F 85 99 0D 00 00 C6 85 37 FF FF FF 00 8B 55 1C 89 54 24 08 8B 7D 14 89 7C 24 04 8B 45 0C 89 04 24 8B 4D 10 8B 95 40 FF FF FF 8B 45 08 E8 ?? ?? ?? ?? 83 EC 0C 85 C0 89 C6 0F 84 84 0D 00 00 8B 8D 4C FF FF FF 8B 41 1C 0F B7 79 14 8B 51 20 89 86 54 01 00 00 0F B7 41 30 89 BD 3C FF FF FF 8B BD 4C FF FF FF 89 C3 C1 E3 05 8D 0C 13 3B 0F 66 89 86 58 01 00 00 0F 87 B8 07 00 00 8D 54 17 04 89 95 70 FF FF FF 8D 04 40 8D 04 C5 12 00 00 00 25 F0 FF FF 00 89 A5 38 FF FF FF 29 C4 8D 7C 24 37 C1 EF 02 89 BD 50 FF FF FF C1 E7 02 03 9D 70 FF FF FF 39 9D 70 FF FF FF 89 BD 58 FF FF FF 0F 83 03 09 00 00 8D 9D 78 FF FF FF 8B BD 70 FF FF FF C6 85 5C FF FF FF 00 C7 85 6C FF FF FF 00 00 00 00 C7 85 54 FF FF FF 07 00 00 00 89 9D 74 FF FF FF EB 44 90 83 F8 01 0F 84 E7 00 00 00 83 F8 02 75 1A 8B 47 08 89 46 08 8B 47 14 C1 E8 03 66 89 86 5A 01 00 00 8D B4 26 00 00 00 00 0F B7 86 58 01 00 00 83 C7 20 C1 E0 05 03 85 70 FF FF FF 39 C7 0F 83 9D 01 00 00 8B 07 83 F8 06 0F 84 6A 01 00 00 76 B0 3D 51 E5 74 64 0F 84 85 00 00 00 3D 52 E5 74 64 74 66 83 F8 07 75 C1 8B 47 14 85 C0 74 BA 89 86 34 02 00 00 8B 47 1C 85 C0 89 86 38 02 00 00 0F 85 43 01 00 00 C7 86 3C 02 00 00 00 00 00 00 8B 47 10 89 86 30 02 00 00 8B 47 08 89 86 2C 02 00 00 0F B6 86 94 01 00 00 83 E0 03 3C 01 0F 85 F9 08 00 00 E8 ?? ?? ?? ?? 89 86 44 02 00 00 E9 65 FF FF FF 90 8D 74 26 00 8B 47 08 89 86 48 02 00 00 8B 47 14 89 86 4C 02 00 00 E9 49 FF FF FF 90 8B 57 18 89 95 54 FF FF FF E9 3A FF FF FF 66 90 8B 0D ?? ?? ?? ?? 8B 47 1C 8D 51 FF 85 C2 89 95 2C FF FF FF 0F 85 DB 07 00 00 8B 5F 04 8B 57 08 89 9D 64 FF FF FF 8D 58 FF 89 D0 2B 85 64 FF FF FF 85 C3 0F 85 C5 07 00 00 8B 9D 6C FF FF FF F7 D9 83 85 6C FF FF FF 01 8D 04 5B 8B 9D 58 FF FF FF 8D 04 C3 89 D3 21 CB 89 9D 60 FF FF FF 89 18 8B 5F 10 01 D3 89 58 08 8B 9D 2C FF FF FF 03 58 08 03 57 14 21 CB 23 8D 64 FF FF FF 83 BD 6C FF FF FF 01 89 58 04 89 50 0C 89 48 10 76 1E 8B 95 60 FF FF FF 0F B6 8D 5C FF FF FF 3B 50 EC BA 01 00 00 00 0F 45 CA 88 8D 5C FF FF FF 8B 4F 18 BA 40 62 51 73 83 E1 07 C1 E1 02 D3 FA 83 E2 0F 89 50 14 E9 71 FE FF FF 90 8B 47 08 89 86 50 01 00 00 E9 62 FE FF FF 66 90 83 E8 01 23 47 08 89 86 3C 02 00 00 E9 B6 FE FF FF 8D B4 26 00 00 00 00 8B 85 6C FF FF FF 85 C0 0F 84 E5 06 00 00 8B BD 50 FF FF FF 8B 9D 58 FF FF FF 8B 04 BD 00 00 00 00 8B BD 6C FF FF FF 8D 54 7F FD 8D 0C D3 8B 79 0C 29 C7 83 BD 3C FF FF FF 03 0F 85 48 07 00 00 8B 95 50 FF FF FF 8B 14 95 10 00 00 00 89 54 24 14 8B 95 48 FF FF FF C7 44 24 0C 02 08 00 00 89 54 24 10 8B 95 50 FF FF FF 8B 14 95 14 00 00 00 89 7C 24 04 89 54 24 08 23 05 ?? ?? ?? ?? 89 04 24 89 8D 30 FF FF FF E8 ?? ?? ?? ?? 8B 8D 30 FF FF FF 83 F8 FF 89 86 AC 01 00 00 0F 84 55 01 00 00 8D 14 38 89 96 B0 01 00 00 8B 95 50 FF FF FF 2B 04 95 00 00 00 00 80 BD 5C FF FF FF 00 89 06 0F 85 5B 04 00 00 80 8E 95 01 00 00 40 8B 43 14 A8 04 89 85 50 FF FF FF 0F 85 22 01 00 00 8B 86 50 01 00 00 85 C0 0F 84 2D 01 00 00 8B 43 0C 8B 53 08 39 D0 0F 86 99 00 00 00 03 16 03 06 89 95 64 FF FF FF 8B 15 ?? ?? ?? ?? 89 85 68 FF FF FF 89 D1 F7 D9 89 8D 5C FF FF FF 8B 8D 64 FF FF FF 8D 44 11 FF 8B 8D 68 FF FF FF 23 85 5C FF FF FF 3B 85 68 FF FF FF 0F 46 C8 39 8D 64 FF FF FF 73 46 F6 85 50 FF FF FF 02 0F 84 E2 07 00 00 89 C8 2B 85 64 FF FF FF C7 44 24 04 00 00 00 00 89 44 24 08 8B 95 64 FF FF FF 89 14 24 89 8D 30 FF FF FF E8 ?? ?? ?? ?? 8B 43 14 8B 8D 30 FF FF FF A8 02 0F 84 EC 07 00 00 39 8D 68 FF FF FF 0F 87 41 04 00 00 83 C3 18 8B 95 6C FF FF FF 8D 04 52 8B 95 58 FF FF FF 8D 04 C2 39 C3 0F 83 CA 00 00 00 8B 53 04 8B 03 39 C2 0F 86 10 FF FF FF 8B 4B 10 29 C2 89 4C 24 14 8B 8D 48 FF FF FF C7 44 24 0C 12 08 00 00 89 4C 24 10 8B 4B 14 89 54 24 04 89 4C 24 08 03 06 89 04 24 E8 ?? ?? ?? ?? 83 F8 FF 0F 85 D7 FE FF FF BF ?? ?? ?? ?? E9 15 04 00 00 8B 43 04 03 06 89 86 B4 01 00 00 8B 86 50 01 00 00 85 C0 0F 85 D3 FE FF FF 8B 85 4C FF FF FF 8B 4B 10 8B 50 20 39 D1 0F 87 BF FE FF FF 8B 03 89 85 60 FF FF FF 89 C8 2B 85 60 FF FF FF 89 85 64 FF FF FF 8B 43 04 01 85 64 FF FF FF 8B 85 4C FF FF FF 0F B7 40 30 C1 E0 05 01 D0 39 85 64 FF FF FF 0F 82 85 FE FF FF 03 95 60 FF FF FF 29 CA 89 96 50 01 00 00 E9 72 FE FF FF 8B 56 08 8B A5 38 FF FF FF 85 D2 0F 84 BB 03 00 00 8B 1E 01 DA 85 D2 89 56 08 0F 84 0C 01 00 00 8D 4E 20 89 8D 6C FF FF FF 8B 02 85 C0 0F 85 0C 02 00 00 85 DB 74 60 8B 46 30 85 C0 74 03 01 58 04 8B 46 2C 85 C0 74 03 01 58 04 8B 46 34 85 C0 74 03 01 58 04 8B 46 38 85 C0 74 03 01 58 04 8B 46 3C 85 C0 74 03 01 58 04 8B 46 64 85 C0 74 03 01 58 04 8B 46 7C 85 C0 74 03 01 58 04 8B 86 E4 00 00 00 85 C0 74 03 01 58 04 8B 86 4C 01 00 00 85 C0 74 03 01 58 04 8B 46 70 85 C0 74 0C 8B 40 04 83 F8 07 0F 85 69 05 00 00 8B 46 3C 85 C0 74 0D 8B 46 44 83 78 04 0C 0F 85 82 05 00 00 8B 46 64 85 C0 74 0D 8B 46 6C 83 78 04 08 0F 85 92 05 00 00 8B 96 98 00 00 00 85 D2 74 21 8B 42 04 A8 02 89 86 08 02 00 00 74 03 89 56 60 A8 04 74 03 89 56 78 A8 08 74 06 89 96 80 00 00 00 8B 86 B8 00 00 00 85 C0 74 14 8B 50 04 89 96 04 02 00 00 83 E2 01 74 06 89 86 80 00 00 00 8B 9E 94 00 00 00 85 DB 74 07 C7 46 5C 00 00 00 00 F6 86 04 02 00 00 40 0F 85 84 06 00 00 8B 86 50 01 00 00 85 C0 0F 84 F1 02 00 00 03 06 89 86 50 01 00 00 A1 ?? ?? ?? ?? F7 D0 83 E0 01 85 85 54 FF FF FF 0F 85 23 05 00 00 8B 86 2C 02 00 00 85 C0 74 08 03 06 89 86 2C 02 00 00 8B 95 48 FF FF FF 89 14 24 E8 ?? ?? ?? ?? 85 C0 0F 85 1F 05 00 00 0F B6 86 94 01 00 00 89 C2 83 E2 03 80 FA 01 0F 84 0F 02 00 00 8B 96 54 01 00 00 8B 06 01 C2 F6 05 ?? ?? ?? ?? 40 89 96 54 01 00 00 0F 85 95 05 00 00 89 F0 E8 ?? ?? ?? ?? F6 45 14 08 75 0B 8B 46 60 85 C0 0F 85 D8 02 00 00 F6 86 04 02 00 00 20 0F 85 C2 01 00 00 8B 45 88 8B 55 8C 89 86 D8 01 00 00 8B 45 E0 89 96 DC 01 00 00 8B 55 E4 89 86 E0 01 00 00 A1 ?? ?? ?? ?? 89 96 E4 01 00 00 85 C0 0F 85 15 05 00 00 8B 55 1C 89 F0 E8 ?? ?? ?? ?? 8D 65 F4 89 F0 5B 5E 5F 5D C3 90 8D 74 26 00 89 54 86 20 83 C2 08 8B 02 85 C0 0F 84 F4 FD FF FF 83 F8 21 76 EA B9 FF FF FF 6F 29 C1 83 F9 0F 77 0E B9 29 00 00 70 29 C1 89 14 8E EB D6 66 90 8D 0C 00 D1 F9 83 F9 FC 76 11 8B 85 6C FF FF FF F7 D1 89 94 88 C8 00 00 00 EB B9 B9 FF FD FF 6F 29 C1 83 F9 0B 0F 86 BC 00 00 00 B9 FF FE FF 6F 29 C1 83 F9 0A 77 9D 8B 8D 6C FF FF FF 05 C0 00 00 10 F7 D8 89 14 81 EB 8B 8B 14 95 04 00 00 00 C7 44 24 08 00 00 00 00 8B 09 01 D0 29 D1 89 4C 24 04 89 04 24 E8 ?? ?? ?? ?? E9 7F FB FF FF C7 42 0C 01 00 00 00 E8 ?? ?? ?? ?? C6 85 37 FF FF FF 01 E9 D9 F7 FF FF 8D 43 1E 25 F0 FF 3F 00 29 C4 8D 7C 24 43 83 E7 F0 89 BD 70 FF FF FF C7 44 24 08 00 00 00 00 89 54 24 04 8B 95 48 FF FF FF 89 14 24 E8 ?? ?? ?? ?? 89 5C 24 08 89 7C 24 04 8B 95 48 FF FF FF 89 14 24 E8 ?? ?? ?? ?? 39 D8 0F 85 16 04 00 00 0F B7 86 58 01 00 00 89 C3 C1 E3 05 E9 F2 F7 FF FF 8B 8D 6C FF FF FF 05 CC 01 00 10 F7 D8 89 14 81 E9 D8 FE FF FF C7 44 24 14 00 00 00 00 C7 44 24 10 FF FF FF FF C7 44 24 0C 32 00 00 00 8B 43 14 89 44 24 08 8B 85 68 FF FF FF 89 0C 24 29 C8 89 44 24 04 E8 ?? ?? ?? ?? 83 F8 FF 0F 85 83 FB FF FF BF ?? ?? ?? ?? 8B A5 38 FF FF FF E9 FC 00 00 00 89 35 ?? ?? ?? ?? E9 33 FE FF FF 83 BD 3C FF FF FF 02 0F 85 E4 FD FF FF 83 E0 FC 88 86 94 01 00 00 E9 D6 FD FF FF 83 BD 3C FF FF FF 03 0F 85 53 FD FF FF 31 DB BF ?? ?? ?? ?? 80 BD 37 FF FF FF 00 B8 00 00 00 00 0F 45 85 44 FF FF FF 89 7C 24 08 89 74 24 04 89 44 24 0C 8B 4D 08 89 D8 89 0C 24 8B 8D 40 FF FF FF 8B 95 48 FF FF FF E8 0E F5 FF FF 8B 5D 08 31 F6 89 1C 24 E8 ?? ?? ?? ?? 8B 95 48 FF FF FF 89 14 24 E8 ?? ?? ?? ?? E9 E7 FD FF FF 8B 8D 4C FF FF FF 0F B7 59 30 C1 E3 05 89 1C 24 E8 ?? ?? ?? ?? 85 C0 74 4C 89 5C 24 08 8B 95 70 FF FF FF 89 04 24 89 54 24 04 E8 ?? ?? ?? ?? 80 8E 94 01 00 00 80 89 86 50 01 00 00 E9 D6 FC FF FF 31 DB BF ?? ?? ?? ?? 8B A5 38 FF FF FF E9 55 FF FF FF 31 DB BF ?? ?? ?? ?? EB EC 31 DB BF ?? ?? ?? ?? EB E3 BF ?? ?? ?? ?? A1 ?? ?? ?? ?? 65 8B 18 E9 31 FF FF FF 8B 96 CC 01 00 00 8D 86 5C 01 00 00 39 02 0F 84 14 FD FF FF 8B 86 64 01 00 00 8B 96 C8 01 00 00 89 30 8B 86 CC 01 00 00 C7 86 68 01 00 00 01 00 00 00 8D 14 95 FC FF FF FF 89 54 24 08 89 44 24 04 83 C0 04 89 04 24 E8 ?? ?? ?? ?? 8B 86 CC 01 00 00 8D 96 64 01 00 00 89 10 E9 C9 FC FF FF F7 45 14 00 00 00 20 0F 84 C5 00 00 00 03 06 0F B6 95 5C FF FF FF 89 86 AC 01 00 00 01 F8 89 86 B0 01 00 00 0F B6 86 95 01 00 00 83 F2 01 83 E2 01 C1 E2 06 83 E0 BF 09 D0 88 86 95 01 00 00 E9 CA F9 FF FF A1 ?? ?? ?? ?? 85 C0 0F 85 FA F6 FF FF E8 ?? ?? ?? ?? 85 C0 0F 85 98 00 00 00 31 C0 E8 ?? ?? ?? ?? 85 C0 89 C1 0F 84 87 00 00 00 89 00 8B 9D 74 FF FF FF 89 40 08 A1 ?? ?? ?? ?? C7 85 78 FF FF FF FF FF FF FF 89 41 10 B8 F3 00 00 00 89 8D 7C FF FF FF C7 45 80 FF FF 0F 00 C7 45 84 51 00 00 00 CD 80 85 C0 75 33 8B 85 78 FF FF FF 8D 04 C5 03 00 00 00 8E E8 A1 ?? ?? ?? ?? 83 C0 01 A3 ?? ?? ?? ?? 89 86 44 02 00 00 E9 EE F5 FF FF 31 DB BF ?? ?? ?? ?? E9 94 FE FF FF BA 01 00 00 00 89 C8 E8 ?? ?? ?? ?? 31 DB BF ?? ?? ?? ?? E9 7C FE FF FF BB 0C 00 00 00 BF ?? ?? ?? ?? E9 6D FE FF FF 83 F8 11 0F 84 8E FA FF FF C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 BF 00 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 C4 00 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 C8 00 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 0D ?? ?? ?? ?? 07 8B 45 18 FF 15 ?? ?? ?? ?? 85 C0 89 C3 0F 84 C3 FA FF FF BF ?? ?? ?? ?? E9 34 FD FF FF BF ?? ?? ?? ?? E9 EC FD FF FF 8B 85 50 FF FF FF 89 54 24 04 83 C8 02 89 44 24 08 8B 85 5C FF FF FF 23 85 64 FF FF FF 89 04 24 89 8D 30 FF FF FF E8 ?? ?? ?? ?? 8B 8D 30 FF FF FF 85 C0 0F 89 E5 F7 FF FF BF ?? ?? ?? ?? E9 A2 FC FF FF 8B 15 ?? ?? ?? ?? 89 44 24 08 89 D0 89 54 24 04 F7 D8 23 85 64 FF FF FF 89 04 24 89 8D 30 FF FF FF E8 ?? ?? ?? ?? 8B 8D 30 FF FF FF E9 E3 F7 FF FF 8B 46 58 85 C0 0F 84 E0 FA FF FF 8B 56 34 8B 52 04 03 50 04 89 F0 E8 01 F1 FF FF E9 CB FA FF FF BF ?? ?? ?? ?? E9 4E FD FF FF 0F B7 8E 58 01 00 00 C7 44 24 2C 08 00 00 00 89 4C 24 30 8B 8E 50 01 00 00 C7 44 24 24 08 00 00 00 89 54 24 20 C7 44 24 1C 08 00 00 00 89 4C 24 28 89 7C 24 18 C7 44 24 14 08 00 00 00 89 44 24 10 C7 44 24 0C 08 00 00 00 8B 46 08 C7 44 24 04 08 00 00 00 C7 04 24 ?? ?? ?? ?? 89 44 24 08 E8 ?? ?? ?? ?? E9 02 FA FF FF 8B 4D 14 85 C9 0F 89 71 F9 FF FF 8B 96 AC 01 00 00 8B 86 B0 01 00 00 89 14 24 29 D0 89 44 24 04 E8 ?? ?? ?? ?? 8B 46 1C 8B 50 08 85 D2 75 08 89 04 24 E8 ?? ?? ?? ?? 31 DB BF ?? ?? ?? ?? 80 BE 94 01 00 00 00 0F 89 D8 FB FF FF 8B 86 50 01 00 00 89 04 24 E8 ?? ?? ?? ?? E9 C5 FB FF FF C6 85 37 FF FF FF 00 BF ?? ?? ?? ?? 31 F6 E9 74 FC FF FF 8B 55 1C 89 54 24 08 8B 85 40 FF FF FF C7 04 24 ?? ?? ?? ?? 89 44 24 04 E8 ?? ?? ?? ?? E9 4D F2 FF FF C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 17 04 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? BF ?? ?? ?? ?? E9 24 FC FF FF }
	condition:
		$1
}

rule file_247_6_0 {
	meta:
		name = "open_verify.isra.2"
		size = 1202
		refs = "0024 __open 0039 __libc_errno 0057 __libc_read 0080 memcmp 01d2 _dl_osversion 0240 __close 02a3 __lseek 041f memcpy 042c free"
	strings:
		$1 = { 55 89 E5 57 56 89 CE 53 83 EC 3C 0F B6 4D 08 C7 44 24 04 00 00 08 00 89 04 24 89 45 D8 89 55 E4 88 4D D7 E8 ?? ?? ?? ?? 83 F8 FF 89 45 DC 0F 84 CC 01 00 00 8B 5D E4 8B 3D ?? ?? ?? ?? 83 C3 04 65 C7 07 00 00 00 00 C7 44 24 08 00 02 00 00 89 5C 24 04 89 04 24 E8 ?? ?? ?? ?? 8B 55 E4 83 F8 33 89 02 0F 8E D2 02 00 00 C7 44 24 08 08 00 00 00 C7 44 24 04 ?? ?? ?? ?? 89 1C 24 89 45 D0 E8 ?? ?? ?? ?? 8B 4D D0 85 C0 0F 85 F0 02 00 00 8B 55 E4 0F B6 42 0C 84 C0 0F 85 6D 01 00 00 8B 45 E4 C7 44 24 08 07 00 00 00 C7 44 24 04 ?? ?? ?? ?? 89 4D D0 83 C0 0D 89 04 24 E8 ?? ?? ?? ?? 8B 4D D0 85 C0 0F 85 52 01 00 00 8B 55 E4 83 7A 18 01 0F 85 12 03 00 00 66 83 7A 16 03 0F 85 57 01 00 00 0F B7 42 14 83 F8 03 0F 85 B8 02 00 00 8B 55 E4 66 83 7A 2E 20 0F 85 CE 02 00 00 8B 75 E4 0F B7 52 30 8B 46 20 89 D3 C1 E3 05 8D 34 03 39 CE 0F 87 C1 01 00 00 8B 7D E4 8D 44 07 04 89 45 E0 03 5D E0 39 5D E0 0F 83 D3 00 00 00 8B 5D E0 EB 19 8D B6 00 00 00 00 89 D0 83 C3 20 C1 E0 05 03 45 E0 39 C3 0F 83 B5 00 00 00 83 3B 04 75 E8 8B 73 10 83 FE 1F 76 E0 83 7B 1C 03 76 DA 8B 4B 04 8B 55 E4 8D 04 31 3B 02 0F 87 09 01 00 00 8D 7C 0A 04 EB 27 8D 76 00 8B 17 8B 47 04 83 C2 03 83 C0 03 83 E2 FC 83 E0 FC 8D 44 02 0C 8D 56 E0 39 D0 0F 87 D0 00 00 00 29 C6 01 C7 C7 44 24 08 10 00 00 00 C7 44 24 04 ?? ?? ?? ?? 89 3C 24 E8 ?? ?? ?? ?? 85 C0 75 C0 85 F6 0F 84 6F 01 00 00 8B 57 10 8B 5F 14 8B 4F 18 8B 47 1C 85 D2 75 69 8B 15 ?? ?? ?? ?? 85 D2 74 26 81 E3 FF 00 00 00 81 E1 FF 00 00 00 C1 E3 08 25 FF 00 00 00 01 D9 C1 E1 08 01 C1 39 D1 77 40 8D B4 26 00 00 00 00 8B 45 DC 8D 65 F4 5B 5E 5F 5D C3 8B 55 E4 80 7A 0B 03 75 08 3C 02 0F 86 82 FE FF FF 8B 55 E4 81 7A 04 7F 45 4C 46 0F 85 0C 02 00 00 80 7A 08 01 0F 84 83 01 00 00 C6 06 01 8B 45 DC 89 04 24 E8 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? C7 45 DC FF FF FF FF 8B 45 DC 65 C7 01 02 00 00 00 8D 65 F4 5B 5E 5F 5D C3 90 8D 74 26 00 8B 4D E4 0F B7 51 30 E9 C4 FE FF FF 8D 74 26 00 BF 10 00 00 00 31 D2 8D 46 1E F7 F7 C1 E0 04 29 C4 8B 45 DC 89 4C 24 04 8D 7C 24 1F C7 44 24 08 00 00 00 00 83 E7 F0 89 04 24 E8 ?? ?? ?? ?? 8B 45 DC 89 74 24 08 89 7C 24 04 89 04 24 E8 ?? ?? ?? ?? 39 C6 0F 84 DA FE FF FF 8B 0D ?? ?? ?? ?? BE ?? ?? ?? ?? 65 8B 19 EB 7B 8D B6 00 00 00 00 8D 53 1E 81 E2 F0 FF 3F 00 29 D4 89 44 24 04 8B 45 DC 8D 4C 24 1F 83 E1 F0 C7 44 24 08 00 00 00 00 89 4D E0 89 04 24 E8 ?? ?? ?? ?? 8B 4D E0 8B 45 DC 89 5C 24 08 89 4C 24 04 89 04 24 E8 ?? ?? ?? ?? 39 C3 75 A4 8B 75 E4 0F B7 56 30 89 D3 C1 E3 05 E9 F2 FD FF FF 8B 75 E4 0F B7 56 30 E9 FD FD FF FF 65 8B 1F BE ?? ?? ?? ?? B8 ?? ?? ?? ?? 85 DB 0F 45 F0 80 7D D7 00 0F 85 9E 00 00 00 8B 4D D8 89 D8 8B 55 DC C7 44 24 0C 00 00 00 00 89 74 24 08 C7 44 24 04 00 00 00 00 C7 04 24 00 00 00 00 E8 21 ED FF FF C7 44 24 08 08 00 00 00 C7 44 24 04 ?? ?? ?? ?? 89 1C 24 E8 ?? ?? ?? ?? 8B 4D D0 85 C0 0F 84 ED FC FF FF E9 75 FE FF FF 83 F8 02 0F 84 3F FD FF FF 31 DB BE ?? ?? ?? ?? EB 94 8B 55 E4 80 7A 09 01 74 15 31 DB BE ?? ?? ?? ?? EB 82 31 DB BE ?? ?? ?? ?? E9 76 FF FF FF 80 7A 0A 01 74 67 31 DB BE ?? ?? ?? ?? E9 64 FF FF FF 31 DB BE ?? ?? ?? ?? E9 58 FF FF FF 8B 7D D8 31 C0 83 C9 FF F2 AE F7 D1 8D 41 1E 83 E0 F0 29 C4 89 4C 24 08 8B 4D D8 8D 44 24 1F 83 E0 F0 89 04 24 89 4C 24 04 E8 ?? ?? ?? ?? 89 C7 8B 45 D8 89 04 24 E8 ?? ?? ?? ?? 89 7D D8 E9 1F FF FF FF 31 DB BE ?? ?? ?? ?? E9 09 FF FF FF 0F B6 42 0B 3C 03 0F 95 C2 74 04 84 C0 75 1B 8B 4D E4 0F B6 41 0C 84 C0 74 20 84 D2 74 18 31 DB BE ?? ?? ?? ?? E9 DF FE FF FF 31 DB BE ?? ?? ?? ?? E9 D3 FE FF FF 3C 02 77 E4 8B 7D E4 31 DB BE ?? ?? ?? ?? C7 44 24 08 07 00 00 00 C7 44 24 04 ?? ?? ?? ?? 83 C7 0D 89 3C 24 E8 ?? ?? ?? ?? 85 C0 B8 ?? ?? ?? ?? 0F 44 F0 E9 9B FE FF FF }
	condition:
		$1
}

rule file_247_7_0 {
	meta:
		name = "open_path.isra.3"
		size = 1340
		refs = "0082 _dl_debug_mask 00a2 mempcpy 01b0 __libc_errno 0210 _dl_ns 0245 __xstat64 027a malloc 02a6 memcpy 02e4 _dl_debug_printf 02ee __libc_enable_secure 0313 __fxstat64 032f __close 0428 _dl_debug_printf_c 04a2 _dl_argv 050b free"
	strings:
		$1 = { 55 89 E5 57 56 53 81 EC BC 00 00 00 89 85 74 FF FF FF 8B 45 08 89 95 78 FF FF FF 89 8D 70 FF FF FF 8B 00 85 C0 89 85 6C FF FF FF 0F 84 BE 01 00 00 8B 85 78 FF FF FF 03 05 ?? ?? ?? ?? 03 05 ?? ?? ?? ?? 8B 8D 6C FF FF FF C7 85 68 FF FF FF 00 00 00 00 83 C0 1E 83 E0 F0 29 C4 8B 85 78 FF FF FF 8B 31 8D 54 24 1B 83 E2 F0 89 55 84 F7 D0 C7 85 60 FF FF FF 00 00 00 00 89 85 64 FF FF FF 90 F6 05 ?? ?? ?? ?? 01 0F 85 B7 02 00 00 8B 46 10 89 44 24 08 8B 46 0C 89 44 24 04 8B 4D 84 89 0C 24 E8 ?? ?? ?? ?? 89 85 7C FF FF FF A1 ?? ?? ?? ?? 85 C0 0F 84 10 02 00 00 BB 01 00 00 00 C7 45 80 00 00 00 00 EB 41 90 83 FA FF 0F 84 2F 01 00 00 C7 44 9E 10 02 00 00 00 C7 45 80 01 00 00 00 8B 85 70 FF FF FF 85 C0 0F 85 FF 01 00 00 83 FA FF 0F 85 79 01 00 00 39 1D ?? ?? ?? ?? 8D 43 01 0F 86 A2 00 00 00 89 C3 83 7C 9E 10 01 74 E8 A1 ?? ?? ?? ?? 8D 44 D8 F8 8B 50 04 89 54 24 08 8B 00 89 44 24 04 8B 85 7C FF FF FF 89 04 24 E8 ?? ?? ?? ?? 8B 95 78 FF FF FF 89 54 24 08 8B 8D 74 FF FF FF 89 04 24 89 4C 24 04 E8 ?? ?? ?? ?? 89 C7 2B 7D 84 F6 05 ?? ?? ?? ?? 01 0F 85 74 01 00 00 C7 04 24 00 00 00 00 8B 55 10 8B 4D 18 8B 45 84 E8 CA F9 FF FF 89 C2 8B 44 9E 10 85 C0 0F 84 44 FF FF FF 83 F8 01 0F 95 C0 0F B6 C0 09 45 80 83 FA FF 0F 85 47 FF FF FF 39 1D ?? ?? ?? ?? 8D 43 01 0F 87 5E FF FF FF 8B 7D 80 85 FF 74 12 A1 ?? ?? ?? ?? 65 8B 00 83 F8 02 74 05 83 F8 0D 75 2E 83 85 6C FF FF FF 04 8B 95 6C FF FF FF 8B 45 80 09 85 68 FF FF FF 8B 32 85 F6 0F 85 9F FE FF FF 8B B5 68 FF FF FF 85 F6 0F 84 0C 03 00 00 BA FF FF FF FF 8D 65 F4 89 D0 5B 5E 5F 5D C3 66 90 8B 45 14 85 C0 74 1B 8B 55 14 6B 42 18 4C 8B 90 ?? ?? ?? ?? B8 01 00 00 00 F6 82 95 01 00 00 08 75 44 8B 8D 64 FF FF FF 8D 45 88 03 7D 84 C6 04 0F 00 89 44 24 08 8B 55 84 C7 04 24 03 00 00 00 89 54 24 04 E8 ?? ?? ?? ?? 85 C0 75 0F 8B 45 98 25 00 F0 00 00 3D 00 40 00 00 74 5E C7 44 9E 10 01 00 00 00 31 C0 09 45 80 E9 89 FE FF FF 66 90 89 3C 24 89 95 4C FF FF FF E8 ?? ?? ?? ?? 8B 4D 0C 8B 95 4C FF FF FF 85 C0 89 01 0F 84 9E 02 00 00 89 7C 24 08 8B 4D 84 89 04 24 89 4C 24 04 89 95 4C FF FF FF E8 ?? ?? ?? ?? 8B 95 4C FF FF FF 8D 65 F4 5B 5E 5F 89 D0 5D C3 C7 44 9E 10 02 00 00 00 B8 01 00 00 00 EB 9D C7 45 80 00 00 00 00 E9 EC FE FF FF 8B 45 84 C7 04 24 ?? ?? ?? ?? 89 44 24 04 E8 ?? ?? ?? ?? E9 74 FE FF FF A1 ?? ?? ?? ?? 85 C0 0F 84 F4 FD FF FF 8D 4D 88 89 54 24 04 89 4C 24 08 C7 04 24 03 00 00 00 89 95 4C FF FF FF E8 ?? ?? ?? ?? 8B 95 4C FF FF FF 85 C0 75 0A F6 45 99 08 0F 85 C3 FD FF FF 89 14 24 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 65 C7 00 02 00 00 00 E9 B3 FD FF FF 8B 7E 04 3B BD 60 FF FF FF 0F 84 3A FD FF FF A1 ?? ?? ?? ?? 03 05 ?? ?? ?? ?? 8B 56 08 89 A5 58 FF FF FF 83 C0 0F 83 E0 F0 29 C4 8D 4C 24 0C 89 55 80 89 8D 7C FF FF FF C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 95 6C FF FF FF 8B 02 85 C0 0F 84 FA 00 00 00 3B 78 04 0F 85 F1 00 00 00 8B 9D 6C FF FF FF 8D 4C 24 0D C7 85 60 FF FF FF 01 00 00 00 89 8D 50 FF FF FF 89 B5 5C FF FF FF 8B 50 10 89 54 24 08 8B 40 0C 89 44 24 04 8B 95 7C FF FF FF 89 14 24 E8 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 85 C9 89 85 54 FF FF FF 0F 84 89 00 00 00 31 F6 EB 4C 3B 85 50 FF FF FF 0F 84 D7 00 00 00 C6 40 FF 00 8B 95 60 FF FF FF B9 ?? ?? ?? ?? B8 ?? ?? ?? ?? 85 D2 8B 95 7C FF FF FF 0F 44 C1 89 04 24 89 54 24 04 E8 ?? ?? ?? ?? C7 85 60 FF FF FF 00 00 00 00 83 C6 01 3B 35 ?? ?? ?? ?? 73 39 8B 03 83 7C B0 14 01 74 EC A1 ?? ?? ?? ?? 8D 04 F0 8B 50 04 89 54 24 08 8B 00 89 44 24 04 8B 85 54 FF FF FF 89 04 24 E8 ?? ?? ?? ?? 39 85 7C FF FF FF 75 80 C6 00 00 EB 8B 83 C3 04 8B 03 85 C0 74 09 3B 78 04 0F 84 35 FF FF FF 8B B5 5C FF FF FF 8B 5D 80 85 DB 74 50 8B 4D 80 80 39 00 75 0A A1 ?? ?? ?? ?? 8B 00 89 45 80 8B 55 80 89 7C 24 04 C7 04 24 ?? ?? ?? ?? 89 54 24 08 E8 ?? ?? ?? ?? 89 BD 60 FF FF FF 8B A5 58 FF FF FF E9 BA FB FF FF 90 8D 74 26 00 8B 95 7C FF FF FF 80 3A 2F 0F 85 1A FF FF FF EB 8C 89 7C 24 04 C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB C7 8B 4D 08 8B 59 04 85 DB 74 0A 8B 01 89 04 24 E8 ?? ?? ?? ?? 81 7D 08 ?? ?? ?? ?? 0F 84 D3 FC FF FF 8B 45 08 BA FF FF FF FF C7 00 FF FF FF FF E9 C5 FC FF FF 89 14 24 E8 ?? ?? ?? ?? E9 B3 FC FF FF }
	condition:
		$1
}

rule file_247_8_0 {
	meta:
		name = "add_path.9405.isra.1.constprop.5"
		size = 168
		refs = "0073 mempcpy"
	strings:
		$1 = { 83 F8 FF 0F 84 8A 00 00 00 55 57 BF 02 00 00 00 56 89 C6 53 89 CB 83 EC 1C 8B 10 EB 1C 8D 76 00 8B 43 08 83 40 04 01 83 7A 10 02 8B 52 10 0F 42 D7 01 10 8B 16 85 D2 74 53 83 C6 04 80 7B 0C 00 75 DE 8B 4B 04 8B 43 08 8D 04 C8 83 C1 01 89 4B 04 8B 0B 8D 68 08 89 48 08 8B 42 10 83 F8 01 76 37 83 E8 01 89 44 24 08 8B 42 0C 89 0C 24 89 44 24 04 E8 ?? ?? ?? ?? 89 03 C6 00 00 8B 16 83 03 01 C7 45 04 00 00 00 00 85 D2 75 AD 83 C4 1C 5B 5E 5F 5D F3 C3 8D 76 00 19 C0 83 C0 2F 88 01 8B 03 83 C0 01 89 03 EB D1 }
	condition:
		$1
}

rule file_247_9_0 {
	meta:
		name = "expand_dynamic_string_token"
		size = 349
		refs = "0025 strchr 004f _dl_dst_count 0096 _dl_platformlen 00c8 malloc 00e0 _dl_dst_substitute 0101 _dl_get_origin 0159 __assert_fail"
	strings:
		$1 = { 83 EC 3C C7 44 24 04 24 00 00 00 89 14 24 89 5C 24 2C 89 C3 89 74 24 30 89 CE 89 6C 24 38 89 D5 89 7C 24 34 E8 ?? ?? ?? ?? 85 C0 75 1A 89 E8 8B 5C 24 2C 8B 74 24 30 8B 7C 24 34 8B 6C 24 38 83 C4 3C E9 A9 DE FF FF 89 74 24 04 89 04 24 E8 ?? ?? ?? ?? 85 C0 89 44 24 1C 74 D2 83 C9 FF 31 C0 89 EF F2 AE F7 D1 83 E9 01 85 DB 89 4C 24 18 0F 84 AF 00 00 00 8B BB A8 01 00 00 85 FF 74 79 83 FF FF 0F 84 91 00 00 00 31 C0 83 C9 FF F2 AE F7 D1 8D 41 FF 83 3D ?? ?? ?? ?? 03 B9 03 00 00 00 0F 43 0D ?? ?? ?? ?? 39 C1 0F 43 C1 83 F8 04 76 0C 83 E8 04 0F AF 44 24 1C 01 44 24 18 8B 44 24 18 83 C0 01 89 04 24 E8 ?? ?? ?? ?? 85 C0 74 50 89 74 24 0C 89 44 24 08 89 6C 24 04 89 1C 24 E8 ?? ?? ?? ?? 8B 5C 24 2C 8B 74 24 30 8B 7C 24 34 8B 6C 24 38 83 C4 3C C3 8B 43 04 80 38 00 75 39 E8 ?? ?? ?? ?? 89 C7 89 83 A8 01 00 00 83 E8 01 83 F8 FD 0F 86 6F FF FF FF 31 C0 E9 74 FF FF FF 31 C0 EB C0 E8 ?? ?? ?? ?? 89 C7 83 E8 01 83 F8 FD 0F 86 51 FF FF FF EB E0 C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 B5 01 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_247_10_0 {
	meta:
		name = "cache_rpath"
		size = 437
		refs = "0053 _dl_inhibit_rpath 00a8 malloc 00d7 free 0137 _dl_signal_error 0144 __libc_enable_secure"
	strings:
		$1 = { 83 EC 3C 89 5C 24 2C 89 D3 8B 12 89 74 24 30 89 7C 24 34 89 6C 24 38 83 FA FF 0F 84 D0 00 00 00 85 D2 89 C6 B8 01 00 00 00 74 15 8B 5C 24 2C 8B 74 24 30 8B 7C 24 34 8B 6C 24 38 83 C4 3C C3 90 8B 44 8E 20 85 C0 0F 84 AC 00 00 00 8B 50 04 8B 4E 34 A1 ?? ?? ?? ?? 8B 7E 04 03 51 04 85 C0 0F 85 DD 00 00 00 89 F0 B9 01 00 00 00 E8 2F FE FF FF 85 C0 89 C6 0F 84 C0 00 00 00 0F B6 10 31 C9 84 D2 0F 84 80 00 00 00 80 FA 3A 0F 94 C2 83 C0 01 0F B6 D2 01 D1 0F B6 10 84 D2 75 EB 8D 04 8D 08 00 00 00 89 04 24 E8 ?? ?? ?? ?? 85 C0 89 C5 74 6B 8B 44 24 40 B9 ?? ?? ?? ?? 89 EA 89 7C 24 08 C7 04 24 00 00 00 00 89 44 24 04 89 F0 E8 0D DD FF FF 89 34 24 E8 ?? ?? ?? ?? B8 01 00 00 00 89 2B C7 43 04 01 00 00 00 E9 3D FF FF FF 66 90 31 C0 E9 34 FF FF FF 90 C7 03 FF FF FF FF E9 28 FF FF FF 90 8D 74 26 00 89 04 24 E8 ?? ?? ?? ?? C7 03 FF FF FF FF 31 C0 E9 0E FF FF FF 89 34 24 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? 89 04 24 31 C9 31 D2 B8 0C 00 00 00 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? EB E8 83 3D ?? ?? ?? ?? 00 0F 85 16 FF FF FF 89 FD EB 12 90 8D 74 26 00 80 7C 24 1E 00 74 B1 83 C0 01 83 C5 01 0F B6 08 88 4C 24 1E 0F B6 4D 00 38 4C 24 1E 88 4C 24 1F 74 DE 80 7C 24 1F 00 74 1D 0F B6 08 84 C9 0F 84 D9 FE FF FF 83 C0 01 80 F9 3A 75 ED 80 38 00 75 B6 E9 C7 FE FF FF 80 7C 24 1E 3A 0F 84 67 FF FF FF 80 7C 24 1E 00 75 D1 E9 5B FF FF FF }
	condition:
		$1
}

rule file_247_11_0 {
	meta:
		name = "_dl_dst_count"
		size = 162
		refs = "000b __libc_enable_secure 0031 strchr"
	strings:
		$1 = { 55 57 56 31 F6 53 83 EC 1C 8B 2D ?? ?? ?? ?? 8B 7C 24 34 8B 44 24 30 EB 20 8D B4 26 00 00 00 00 83 C6 01 01 C3 C7 44 24 04 24 00 00 00 89 1C 24 E8 ?? ?? ?? ?? 85 C0 74 5F 8D 58 01 8B 44 24 30 B9 ?? ?? ?? ?? 89 6C 24 04 89 DA 89 3C 24 E8 AD E0 FF FF 85 C0 75 C9 8B 44 24 30 B9 ?? ?? ?? ?? 89 DA C7 44 24 04 00 00 00 00 89 3C 24 E8 8E E0 FF FF 85 C0 75 AA 8B 44 24 30 B9 ?? ?? ?? ?? 89 DA C7 44 24 04 00 00 00 00 89 3C 24 E8 6F E0 FF FF 85 C0 74 8E EB 89 90 83 C4 1C 89 F0 5B 5E 5F 5D C3 }
	condition:
		$1
}

rule file_247_12_0 {
	meta:
		name = "_dl_dst_substitute"
		size = 565
		refs = "0085 __libc_enable_secure 014c stpcpy 0191 _dl_platform 021e _dl_get_origin"
	strings:
		$1 = { 55 57 56 53 83 EC 2C 8B 44 24 44 8B 6C 24 4C 8B 74 24 44 C6 44 24 17 00 0F B6 08 8B 44 24 48 89 44 24 18 89 C3 8D 76 00 80 F9 24 74 56 88 0B 83 C3 01 85 ED 8D 7E 01 0F B6 4E 01 74 05 80 F9 3A 74 2E 84 C9 74 0A 89 FE EB DE 8B 5C 24 18 66 90 80 7C 24 17 00 0F 85 68 01 00 00 C6 03 00 8B 44 24 48 83 C4 2C 5B 5E 5F 5D C3 8D B6 00 00 00 00 80 7C 24 17 00 0F 85 1F 01 00 00 89 5C 24 18 89 FE EB A5 8B 0D ?? ?? ?? ?? 8D 7E 01 8B 44 24 44 89 FA 89 2C 24 89 4C 24 1C 89 4C 24 04 B9 ?? ?? ?? ?? E8 A9 DF FF FF 85 C0 89 C2 0F 84 BE 00 00 00 8B 4C 24 40 85 C9 0F 84 5C 01 00 00 8B 4C 24 40 8B 81 A8 01 00 00 8B 4C 24 1C C6 44 24 17 00 85 C9 74 10 8B 4C 24 40 F6 81 94 01 00 00 03 0F 94 44 24 17 8D 48 FF 83 F9 FD 76 54 83 FA 01 76 6F 01 D7 0F B6 07 84 C0 75 14 E9 4B FF FF FF 90 83 C7 01 0F B6 07 84 C0 0F 84 3C FF FF FF 85 ED 74 EE 3C 3A 75 EA 8B 44 24 48 39 44 24 18 0F 85 E9 00 00 00 0F B6 4F 01 84 C9 0F 84 DD 00 00 00 83 C7 01 8B 5C 24 48 E9 3F FF FF FF 8D 74 26 00 89 1C 24 89 44 24 04 89 54 24 10 E8 ?? ?? ?? ?? 8B 54 24 10 01 D7 0F B6 0F 89 C3 E9 E2 FE FF FF C6 03 24 83 C3 01 0F B6 4E 01 E9 D3 FE FF FF 8B 44 24 44 89 FA B9 ?? ?? ?? ?? C7 44 24 04 00 00 00 00 89 2C 24 E8 C6 DE FF FF 85 C0 89 C2 74 4E A1 ?? ?? ?? ?? E9 4A FF FF FF 8B 44 24 18 89 DA 2B 54 24 18 88 4C 24 10 E8 ?? ?? ?? ?? 0F B6 4C 24 10 C6 44 24 17 00 84 C0 0F 44 5C 24 18 E9 B8 FE FF FF 8B 44 24 18 89 DA 2B 54 24 18 E8 ?? ?? ?? ?? 84 C0 0F 44 5C 24 18 E9 7D FE FF FF 8B 44 24 44 89 FA B9 ?? ?? ?? ?? C7 44 24 04 00 00 00 00 89 2C 24 E8 57 DE FF FF 85 C0 89 C2 0F 84 5D FF FF FF B8 ?? ?? ?? ?? E9 D7 FE FF FF 0F B6 0F 8B 5C 24 18 E9 29 FE FF FF 89 44 24 10 E8 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 8B 54 24 10 89 4C 24 1C E9 92 FE FF FF }
	condition:
		$1
}

rule file_247_13_0 {
	meta:
		name = "_dl_init_paths"
		size = 623
		refs = "0010 _dl_platformlen 0018 _dl_platform 0024 _dl_important_hwcaps 0038 malloc 0099 _dl_all_dirs 015c strlen 0181 memcpy 01d1 __libc_enable_secure 0217 free 0240 _dl_signal_error 0264 __assert_fail"
	strings:
		$1 = { 55 B9 ?? ?? ?? ?? 89 E5 57 56 53 83 EC 2C 8B 15 ?? ?? ?? ?? 89 45 DC A1 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 EC 04 C7 04 24 0C 00 00 00 A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 A3 ?? ?? ?? ?? 0F 84 E5 01 00 00 8B 1D ?? ?? ?? ?? 89 C7 BA CD CC CC CC 8D 04 9D 27 00 00 00 F7 E2 C1 EA 04 8D 34 92 89 F0 C1 E0 06 89 04 24 E8 ?? ?? ?? ?? 85 C0 89 07 0F 84 EC 01 00 00 C1 E6 02 83 C7 04 89 F1 89 75 E4 01 C1 BE ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 00 00 00 00 A3 ?? ?? ?? ?? C7 40 04 ?? ?? ?? ?? C7 40 08 00 00 00 00 C7 40 0C ?? ?? ?? ?? C7 40 10 05 00 00 00 C7 45 E0 00 00 00 00 31 D2 85 DB 74 11 66 90 C7 44 90 14 00 00 00 00 83 C2 01 39 DA 75 F1 83 7D E0 01 74 43 89 08 83 C7 04 89 4F FC 8D 56 0A C7 41 04 ?? ?? ?? ?? C7 41 08 00 00 00 00 89 71 0C C7 41 10 09 00 00 00 03 45 E4 03 4D E4 80 3E 2F C7 45 E0 01 00 00 00 0F 85 2E 01 00 00 89 D6 EB A6 8D B6 00 00 00 00 8B 5D DC C7 00 00 00 00 00 C7 05 ?? ?? ?? ?? 09 00 00 00 C7 07 00 00 00 00 85 DB 74 08 8B 45 DC 80 38 00 75 13 C7 05 ?? ?? ?? ?? FF FF FF FF 8D 65 F4 5B 5E 5F 5D C3 90 89 04 24 E8 ?? ?? ?? ?? 8D 50 01 83 C0 1F 83 E0 F0 29 C4 89 54 24 08 8B 55 DC 8D 44 24 1F 83 E0 F0 89 04 24 89 54 24 04 E8 ?? ?? ?? ?? 89 C3 8B 45 DC 0F B6 10 84 D2 0F 84 92 00 00 00 B9 01 00 00 00 8D B6 00 00 00 00 83 EA 3A 80 FA 02 83 D1 00 83 C0 01 0F B6 10 84 D2 75 ED 8D 04 8D 04 00 00 00 89 04 24 E8 ?? ?? ?? ?? 85 C0 A3 ?? ?? ?? ?? 0F 84 99 00 00 00 8B 15 ?? ?? ?? ?? B9 ?? ?? ?? ?? C7 44 24 08 00 00 00 00 C7 44 24 04 ?? ?? ?? ?? 89 14 24 89 C2 89 D8 E8 2A DA FF FF A1 ?? ?? ?? ?? 8B 30 85 F6 74 12 C7 05 ?? ?? ?? ?? 00 00 00 00 8D 65 F4 5B 5E 5F 5D C3 89 04 24 E8 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? FF FF FF FF EB DA B8 08 00 00 00 EB 8C B8 ?? ?? ?? ?? 89 04 24 31 C9 31 D2 B8 0C 00 00 00 E8 ?? ?? ?? ?? C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 03 03 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? EB C4 }
	condition:
		$1
}

rule file_247_14_0 {
	meta:
		name = "_dl_map_object"
		size = 2046
		refs = "0028 _dl_nns 003e _dl_ns 0072 _dl_name_match_p 0092 _dl_debug_mask 00b3 strchr 011f __libc_stack_end 01a2 strlen 0254 _dl_debug_printf 02c5 _dl_inhibit_cache 02d0 _dl_load_cache_lookup 0335 __close 0569 strcmp 0615 _dl_new_object 0650 _dl_add_to_namespace_list 066d _dl_argv 06d8 free 06ed _dl_signal_error 070b __libc_enable_secure 0730 memcmp 0766 __libc_errno 07bd __assert_fail"
	strings:
		$1 = { 55 57 56 53 81 EC 5C 02 00 00 89 4C 24 28 8B 8C 24 78 02 00 00 85 C9 0F 88 A4 07 00 00 89 D3 8B 94 24 78 02 00 00 3B 15 ?? ?? ?? ?? 0F 83 6B 07 00 00 89 C6 6B 84 24 78 02 00 00 4C 8B A8 ?? ?? ?? ?? 85 ED 75 16 EB 48 F6 85 95 01 00 00 01 0F 84 F8 04 00 00 8B 6D 0C 85 ED 74 34 0F B6 8D 95 01 00 00 F6 C1 02 75 ED 83 E1 20 75 E8 89 EA 89 D8 E8 ?? ?? ?? ?? 85 C0 74 CE 81 C4 5C 02 00 00 89 E8 5B 5E 5F 5D C2 0C 00 8D B4 26 00 00 00 00 8B 3D ?? ?? ?? ?? F7 C7 40 00 00 00 0F 85 B7 05 00 00 C7 44 24 04 2F 00 00 00 89 1C 24 C6 44 24 43 00 E8 ?? ?? ?? ?? 85 C0 0F 84 D2 00 00 00 85 F6 0F 84 A1 01 00 00 8B AC 24 74 02 00 00 81 E5 00 00 00 10 31 C9 89 DA 89 F0 E8 91 F9 FF FF 85 C0 BA FF FF FF FF 89 44 24 44 74 1F 8D 54 24 4C C7 04 24 01 00 00 00 8D 4C 24 43 E8 D0 EB FF FF 83 F8 FF 89 C2 0F 84 DA 06 00 00 85 ED B8 00 00 00 00 0F 45 F0 83 FA FF 0F 84 A8 04 00 00 A1 ?? ?? ?? ?? 8D 4C 24 4C 89 74 24 04 89 44 24 48 8B 84 24 78 02 00 00 89 44 24 14 8D 44 24 48 89 44 24 10 8B 84 24 74 02 00 00 89 44 24 0C 8B 44 24 28 89 44 24 08 8B 44 24 44 89 04 24 89 D8 E8 7D DC FF FF 81 C4 5C 02 00 00 5B 5E 5F 89 C5 89 E8 5D C2 0C 00 C7 44 24 04 2F 00 00 00 89 1C 24 C6 44 24 43 00 E8 ?? ?? ?? ?? 85 C0 0F 85 D7 00 00 00 8B AC 24 74 02 00 00 81 E5 00 00 00 10 89 1C 24 E8 ?? ?? ?? ?? 83 C0 01 83 E7 01 89 44 24 34 0F 85 C7 05 00 00 85 F6 0F 84 53 02 00 00 8B 86 94 00 00 00 85 C0 0F 84 EC 02 00 00 83 3D ?? ?? ?? ?? FF 0F 84 C6 00 00 00 85 F6 89 F0 0F 44 05 ?? ?? ?? ?? 8B 8C 24 74 02 00 00 8D 54 24 43 89 54 24 10 8B 54 24 34 89 44 24 0C 8D 44 24 4C 89 44 24 08 8D 44 24 44 81 E1 00 00 00 04 89 44 24 04 89 D8 C7 04 24 ?? ?? ?? ?? E8 71 EF FF FF 83 F8 FF 89 C2 0F 94 C0 85 F6 0F 95 44 24 2C 84 C0 0F 85 6A 01 00 00 83 FA FF 74 73 F6 05 ?? ?? ?? ?? 01 0F 84 C3 FE FF FF C7 04 24 ?? ?? ?? ?? 89 54 24 24 E8 ?? ?? ?? ?? 8B 54 24 24 E9 AA FE FF FF 8D B4 26 00 00 00 00 89 D8 E8 F1 D6 FF FF 8B AC 24 74 02 00 00 81 E5 00 00 00 10 E9 5E FE FF FF 80 7C 24 30 00 8B 6C 24 3C 0F 84 8B 01 00 00 83 3D ?? ?? ?? ?? FF 89 F0 0F 85 45 FF FF FF B8 01 00 00 00 BA FF FF FF FF E9 79 FF FF FF 8B 84 24 74 02 00 00 25 00 00 00 04 89 44 24 3C 0F 85 46 04 00 00 A1 ?? ?? ?? ?? 85 C0 75 6C 89 D8 E8 ?? ?? ?? ?? 85 C0 89 44 24 30 74 5D 80 7C 24 2C 00 74 12 8B BE 04 02 00 00 81 E7 00 08 00 00 0F 85 27 04 00 00 8B 44 24 30 8D 54 24 4C C7 04 24 00 00 00 00 8D 4C 24 43 E8 C3 E9 FF FF 83 F8 FF 89 C2 74 25 8B 44 24 30 89 54 24 24 E8 3F D6 FF FF 8B 54 24 24 85 C0 89 44 24 44 0F 85 0A FF FF FF 89 14 24 E8 ?? ?? ?? ?? 80 7C 24 2C 00 0F 84 5B 02 00 00 8B BE 04 02 00 00 81 E7 00 08 00 00 89 F0 85 FF 0F 85 30 02 00 00 83 3D ?? ?? ?? ?? FF 0F 84 23 02 00 00 8D 54 24 43 8B 4C 24 3C 89 54 24 10 8B 54 24 34 89 44 24 0C 8D 44 24 4C 89 44 24 08 8D 44 24 44 89 44 24 04 89 D8 C7 04 24 ?? ?? ?? ?? E8 F7 ED FF FF 89 C2 E9 9B FE FF FF 80 7C 24 2C 00 0F 84 8B FE FF FF 8D BE E8 01 00 00 B9 1D 00 00 00 C7 04 24 ?? ?? ?? ?? 89 FA 89 F0 E8 0A F8 FF FF C6 44 24 2C 01 84 C0 0F 84 DB FE FF FF 8B 8C 24 74 02 00 00 8D 44 24 43 8B 54 24 34 89 44 24 10 8D 44 24 4C 89 44 24 08 8D 44 24 44 89 44 24 04 81 E1 00 00 00 04 89 D8 89 74 24 0C 89 3C 24 E8 86 ED FF FF 89 C2 E9 25 FE FF FF 8B 15 ?? ?? ?? ?? 89 54 24 2C 8B 44 24 2C 85 C0 0F 84 A5 FD FF FF 8B 54 24 2C 0F B6 82 94 01 00 00 83 E0 03 3C 02 0F 84 8F FD FF FF 8B 44 24 2C 89 D7 B9 0F 00 00 00 81 C7 98 01 00 00 C7 04 24 ?? ?? ?? ?? 89 FA E8 74 F7 FF FF 84 C0 0F 84 68 FD FF FF 8B 44 24 2C 85 F6 8B 8C 24 74 02 00 00 8D 54 24 43 89 54 24 10 8B 54 24 34 89 3C 24 0F 45 C6 89 44 24 0C 8D 44 24 4C 81 E1 00 00 00 04 89 44 24 08 8D 44 24 44 89 44 24 04 89 D8 E8 EC EC FF FF 83 F8 FF 89 C2 0F 85 8C FD FF FF E9 18 FD FF FF 8D 74 26 00 8B 84 24 74 02 00 00 89 F7 8B 15 ?? ?? ?? ?? C6 44 24 30 00 89 6C 24 3C 25 00 00 00 04 89 54 24 2C 89 44 24 38 EB 0F 90 8B BF 6C 01 00 00 85 FF 0F 84 93 FD FF FF 8D AF 98 01 00 00 B9 0F 00 00 00 C7 04 24 ?? ?? ?? ?? 89 EA 89 F8 E8 C7 F6 FF FF 84 C0 74 D3 8D 44 24 43 8B 4C 24 38 8B 54 24 34 89 44 24 10 8D 44 24 4C 89 44 24 08 8D 44 24 44 89 44 24 04 89 D8 89 74 24 0C 89 2C 24 E8 55 EC FF FF 83 F8 FF 75 54 3B 7C 24 2C 0F 94 C0 08 44 24 30 EB 93 8B 55 58 85 D2 0F 84 FD FA FF FF 8B 45 34 8B 40 04 03 42 04 89 1C 24 89 44 24 04 E8 ?? ?? ?? ?? 85 C0 0F 85 E0 FA FF FF 89 DA 89 E8 E8 12 D7 FF FF 80 8D 95 01 00 00 01 E9 F0 FA FF FF BA FF FF FF FF E9 A7 FC FF FF 89 C2 8B 6C 24 3C E9 9C FC FF FF 6B 84 24 78 02 00 00 4C 8B 80 ?? ?? ?? ?? 85 C0 0F 84 A5 FD FF FF 8B B8 04 02 00 00 81 E7 00 08 00 00 E9 8C FD FF FF 8B BC 24 70 02 00 00 85 FF 0F 84 1C 01 00 00 F6 05 ?? ?? ?? ?? 08 0F 85 0F 01 00 00 89 D8 E8 77 D3 FF FF 85 C0 89 C7 0F 84 E1 00 00 00 8B 94 24 78 02 00 00 8B 84 24 74 02 00 00 8B 4C 24 28 89 34 24 89 54 24 08 89 DA 89 44 24 04 89 F8 E8 ?? ?? ?? ?? 83 EC 0C 85 C0 89 C5 0F 84 AE 00 00 00 80 88 95 01 00 00 02 80 88 94 01 00 00 04 8B 94 24 78 02 00 00 C7 80 8C 01 00 00 ?? ?? ?? ?? C7 80 78 01 00 00 01 00 00 00 E8 ?? ?? ?? ?? E9 21 FA FF FF 85 F6 0F 84 13 FB FF FF 8B 56 04 8B 4E 18 80 3A 00 75 07 A1 ?? ?? ?? ?? 8B 10 8B AC 24 74 02 00 00 BF ?? ?? ?? ?? B8 ?? ?? ?? ?? 89 54 24 0C 8B 94 24 78 02 00 00 89 4C 24 10 89 5C 24 04 81 E5 00 00 00 10 0F 44 C7 89 54 24 08 89 04 24 E8 ?? ?? ?? ?? C7 44 24 04 2F 00 00 00 89 1C 24 C6 44 24 43 00 E8 ?? ?? ?? ?? 8B 3D ?? ?? ?? ?? 85 C0 0F 85 05 FA FF FF E9 CA FA FF FF 89 3C 24 E8 ?? ?? ?? ?? 31 C9 89 DA C7 04 24 ?? ?? ?? ?? B8 0C 00 00 00 E8 ?? ?? ?? ?? 80 7C 24 43 00 74 6D C7 04 24 ?? ?? ?? ?? 31 C9 89 DA 31 C0 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 85 C0 0F 85 22 FC FF FF E9 A8 FB FF FF C7 44 24 08 05 00 00 00 C7 44 24 04 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 85 C0 0F 84 14 FC FF FF 8B 44 24 30 C7 44 24 08 09 00 00 00 C7 44 24 04 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 85 C0 0F 85 95 FB FF FF E9 EB FB FF FF A1 ?? ?? ?? ?? 31 C9 89 DA 65 8B 00 C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 94 24 78 02 00 00 89 5C 24 04 C7 04 24 ?? ?? ?? ?? 89 54 24 08 E8 ?? ?? ?? ?? E9 19 FA FF FF C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 12 08 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 11 08 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 44 24 44 89 54 24 24 89 04 24 E8 ?? ?? ?? ?? 8B 54 24 24 E9 0D F9 FF FF }
	condition:
		$1
}

rule file_247_15_0 {
	meta:
		name = "_dl_rtld_di_serinfo"
		size = 380
		refs = "0123 _dl_ns"
	strings:
		$1 = { 57 56 89 C6 53 83 EC 20 84 C9 89 54 24 18 88 4C 24 1C 75 7C 8B 42 04 8B BE 94 00 00 00 8D 44 C2 08 C7 44 24 14 00 00 00 00 89 44 24 10 85 FF 0F 84 9B 00 00 00 8D 7C 24 10 A1 ?? ?? ?? ?? 89 F9 E8 8B EE FF FF 8D 96 E8 01 00 00 B9 1D 00 00 00 C7 04 24 ?? ?? ?? ?? 89 F0 E8 72 F3 FF FF 84 C0 75 46 F6 86 05 02 00 00 08 74 53 80 7C 24 1C 00 74 10 8B 44 24 18 8B 50 04 8D 14 D5 08 00 00 00 01 10 83 C4 20 5B 5E 5F C3 8D B4 26 00 00 00 00 C7 42 04 00 00 00 00 31 C0 C7 02 00 00 00 00 E9 73 FF FF FF 8D 74 26 00 8B 86 E8 01 00 00 89 F9 E8 1B EE FF FF F6 86 05 02 00 00 08 75 AD A1 ?? ?? ?? ?? 89 F9 E8 06 EE FF FF EB 9F 8D 74 26 00 89 F3 8D 7C 24 10 EB 0A 8B 9B 6C 01 00 00 85 DB 74 34 8D 93 98 01 00 00 B9 0F 00 00 00 C7 04 24 ?? ?? ?? ?? 89 D8 E8 D5 F2 FF FF 84 C0 74 D9 8B 83 98 01 00 00 89 F9 E8 C4 ED FF FF 8B 9B 6C 01 00 00 85 DB 75 CC 8B 5E 18 85 DB 0F 85 18 FF FF FF 8B 1D ?? ?? ?? ?? 85 DB 0F 84 0A FF FF FF 0F B6 83 94 01 00 00 83 E0 03 3C 02 0F 84 F8 FE FF FF 39 F3 0F 84 F0 FE FF FF 8D 93 98 01 00 00 B9 0F 00 00 00 C7 04 24 ?? ?? ?? ?? 89 D8 E8 6E F2 FF FF 84 C0 0F 84 CF FE FF FF 8B 83 98 01 00 00 89 F9 E8 59 ED FF FF E9 BD FE FF FF }
	condition:
		$1
}

rule file_247_16_0 {
	meta:
		name = "is_trusted_path_normalize"
		size = 259
		refs = "00c2 memcmp"
	strings:
		$1 = { 85 D2 75 0C E9 F7 00 00 00 31 C0 E9 E8 00 00 00 55 89 E5 57 56 53 83 EC 2C 80 38 3A 75 02 40 4A 83 C2 20 83 E2 F0 29 D4 8D 54 24 1B 83 E2 F0 89 55 E4 89 D1 EB 56 80 FA 2F 75 4D 80 78 01 2E 75 3A 0F B6 70 02 89 F3 80 FB 2E 75 1F 0F B6 78 03 89 FB 84 DB 74 05 80 FB 2F 75 10 3B 4D E4 76 06 49 80 39 2F 75 F5 83 C0 03 EB 21 89 F3 84 DB 74 05 80 FB 2F 75 05 83 C0 02 EB 11 3B 4D E4 76 08 80 79 FF 2F 75 02 EB 03 88 11 41 40 8A 10 84 D2 75 A4 3B 4D E4 74 06 80 79 FF 2F 74 04 C6 01 2F 41 89 CE 2B 75 E4 83 FE 04 76 1F 8B 55 E4 C7 44 24 08 05 00 00 00 C7 04 24 ?? ?? ?? ?? 89 54 24 04 E8 ?? ?? ?? ?? 85 C0 74 2C 83 FE 08 0F 86 36 FF FF FF 8B 5D E4 C7 44 24 08 09 00 00 00 C7 04 24 ?? ?? ?? ?? 89 5C 24 04 E8 ?? ?? ?? ?? 85 C0 0F 85 13 FF FF FF B0 01 8D 65 F4 5B 5E 5F 5D C3 31 C0 C3 }
	condition:
		$1
}

rule file_248_0_0 {
	meta:
		name = "ppoll"
		size = 528
		refs = "006d _dl_sysinfo 00a9 __libc_errno 0127 __sigprocmask 013e __poll 01b4 __libc_enable_asynccancel 01e0 __libc_disable_asynccancel"
	strings:
		$1 = { 81 EC CC 00 00 00 8B 94 24 D8 00 00 00 89 9C 24 BC 00 00 00 8B 9C 24 D0 00 00 00 89 B4 24 C0 00 00 00 8B B4 24 DC 00 00 00 89 BC 24 C4 00 00 00 85 D2 89 AC 24 C8 00 00 00 74 11 8B 02 8B 52 04 89 44 24 28 89 54 24 2C 8D 54 24 28 65 A1 0C 00 00 00 85 C0 0F 85 50 01 00 00 BF 08 00 00 00 8B 8C 24 D4 00 00 00 B8 35 01 00 00 FF 15 ?? ?? ?? ?? 3D 00 F0 FF FF 0F 87 71 01 00 00 89 C7 83 FF FF 74 25 89 F8 8B 9C 24 BC 00 00 00 8B B4 24 C0 00 00 00 8B BC 24 C4 00 00 00 8B AC 24 C8 00 00 00 81 C4 CC 00 00 00 C3 A1 ?? ?? ?? ?? 65 83 38 26 75 D0 85 D2 0F 84 CB 00 00 00 8B 0A 85 C9 0F 88 D9 00 00 00 8B 52 04 85 D2 0F 88 CE 00 00 00 81 FA FF C9 9A 3B 0F 8F C2 00 00 00 81 F9 9B C4 20 00 BF FF FF FF FF 7F 26 0F 84 9E 00 00 00 8D AA 3F 42 0F 00 BA 83 DE 1B 43 89 E8 F7 EA 69 C9 E8 03 00 00 C1 FD 1F C1 FA 12 29 EA 8D 3C 11 85 F6 74 55 8D 6C 24 30 89 6C 24 08 89 74 24 04 C7 04 24 02 00 00 00 E8 ?? ?? ?? ?? 8B 8C 24 D4 00 00 00 89 7C 24 08 89 1C 24 89 4C 24 04 E8 ?? ?? ?? ?? C7 44 24 08 00 00 00 00 89 6C 24 04 C7 04 24 02 00 00 00 89 C7 E8 ?? ?? ?? ?? E9 22 FF FF FF 8D B4 26 00 00 00 00 8B 8C 24 D4 00 00 00 89 7C 24 08 89 1C 24 89 4C 24 04 E8 ?? ?? ?? ?? 89 C7 E9 FD FE FF FF BF FF FF FF FF EB 82 81 FA C0 6F 90 26 0F 8F 76 FF FF FF E9 51 FF FF FF 65 C7 00 16 00 00 00 E9 D9 FE FF FF 89 54 24 1C BF 08 00 00 00 E8 ?? ?? ?? ?? 8B 54 24 1C 8B 8C 24 D4 00 00 00 89 C5 B8 35 01 00 00 FF 15 ?? ?? ?? ?? 3D 00 F0 FF FF 77 29 89 C7 89 E8 89 54 24 1C E8 ?? ?? ?? ?? 8B 54 24 1C E9 91 FE FF FF 8B 0D ?? ?? ?? ?? F7 D8 83 CF FF 65 89 01 E9 7E FE FF FF 8B 0D ?? ?? ?? ?? F7 D8 65 89 01 83 C8 FF EB C7 }
	condition:
		$1
}

rule file_249_0_0 {
	meta:
		name = "__atomic_readv_replacement"
		size = 374
		refs = "0083 __read 00d0 memcpy 00e7 free 00f9 __libc_errno 0134 __libc_alloca_cutoff 0144 malloc 0167 _Unwind_Resume"
	strings:
		$1 = { 55 89 E5 57 56 89 D6 53 83 EC 3C 85 C9 89 45 E0 89 4D E4 0F 8E 10 01 00 00 8B 52 04 81 FA FF FF FF 7F 0F 87 D0 00 00 00 31 C0 31 DB BF FF FF FF 7F EB 15 90 8D 74 26 00 8B 54 C6 04 89 F9 29 D9 39 D1 0F 82 B0 00 00 00 01 D3 83 C0 01 3B 45 E4 75 E6 81 FB 00 10 00 00 0F 87 D2 00 00 00 8D 43 1E 83 E0 F0 29 C4 8D 7C 24 1B 83 E7 F0 C7 45 DC 00 00 00 00 8B 45 E0 89 5C 24 08 89 7C 24 04 89 04 24 E8 ?? ?? ?? ?? 85 C0 89 45 E0 0F 88 8E 00 00 00 89 C3 8B 45 E4 85 C0 7E 45 89 FA 31 C9 89 F7 EB 10 90 8D 74 26 00 83 C1 01 83 C7 08 3B 4D E4 74 2D 8B 07 89 DE 39 5F 04 0F 46 77 04 89 54 24 04 89 04 24 89 74 24 08 89 55 D8 89 4D D4 E8 ?? ?? ?? ?? 8B 55 D8 8B 4D D4 01 F2 29 F3 75 C8 8B 45 DC 89 04 24 E8 ?? ?? ?? ?? 8B 45 E0 8D 65 F4 5B 5E 5F 5D C3 66 90 A1 ?? ?? ?? ?? C7 45 E0 FF FF FF FF 65 C7 00 16 00 00 00 8B 45 E0 8D 65 F4 5B 5E 5F 5D C3 C7 45 DC 00 00 00 00 8D 76 00 C7 45 E0 FF FF FF FF EB B7 31 DB E9 2E FF FF FF 89 1C 24 E8 ?? ?? ?? ?? 85 C0 0F 85 1E FF FF FF 89 1C 24 E8 ?? ?? ?? ?? 85 C0 89 C7 74 C8 89 45 DC E9 1E FF FF FF 89 C3 8B 45 DC 89 04 24 E8 ?? ?? ?? ?? 89 1C 24 E8 ?? ?? ?? ?? 89 C3 C7 45 DC 00 00 00 00 EB E2 }
	condition:
		$1
}

rule file_249_1_0 {
	meta:
		name = "__libc_readv"
		size = 231
		refs = "0032 _dl_sysinfo 0061 __libc_errno 00a3 __libc_enable_asynccancel 00ca __libc_disable_asynccancel"
	strings:
		$1 = { 83 EC 2C 89 5C 24 1C 8B 54 24 38 89 74 24 20 8B 5C 24 30 89 7C 24 24 8B 74 24 34 89 6C 24 28 65 A1 0C 00 00 00 85 C0 75 75 89 F1 B8 91 00 00 00 FF 15 ?? ?? ?? ?? 3D 00 F0 FF FF 77 51 89 C5 85 ED 78 1D 89 E8 8B 5C 24 1C 8B 74 24 20 8B 7C 24 24 8B 6C 24 28 83 C4 2C C3 8D B4 26 00 00 00 00 A1 ?? ?? ?? ?? 65 83 38 16 75 D8 83 FA 08 7E D3 89 D1 89 D8 8B 7C 24 24 89 F2 8B 5C 24 1C 8B 74 24 20 8B 6C 24 28 83 C4 2C E9 F2 FD FF FF 8B 0D ?? ?? ?? ?? F7 D8 65 89 01 83 C8 FF EB 9F 89 54 24 0C E8 ?? ?? ?? ?? 8B 54 24 0C 89 F1 89 C7 B8 91 00 00 00 FF 15 ?? ?? ?? ?? 3D 00 F0 FF FF 77 16 89 C5 89 F8 89 54 24 0C E8 ?? ?? ?? ?? 8B 54 24 0C E9 68 FF FF FF 8B 0D ?? ?? ?? ?? F7 D8 65 89 01 83 C8 FF EB DA }
	condition:
		$1
}

rule file_250_0_0 {
	meta:
		name = "__umask"
		size = 20
		refs = "000d _dl_sysinfo"
	strings:
		$1 = { 89 DA 8B 5C 24 04 B8 3C 00 00 00 FF 15 ?? ?? ?? ?? 89 D3 C3 }
	condition:
		$1
}

rule file_251_0_0 {
	meta:
		name = "__seed48_r"
		size = 72
	strings:
		$1 = { 8B 44 24 08 8B 54 24 04 8B 08 89 48 06 0F B7 48 04 66 89 48 0A 0F B7 4A 04 66 89 48 04 0F B7 4A 02 66 89 48 02 0F B7 12 C7 40 10 6D E6 EC DE C7 40 14 05 00 00 00 66 C7 40 0C 0B 00 66 89 10 66 C7 40 0E 01 00 31 C0 C3 }
	condition:
		$1
}

rule file_252_0_0 {
	meta:
		name = "sethostname"
		size = 35
		refs = "0011 _dl_sysinfo 001e __syscall_error"
	strings:
		$1 = { 89 DA 8B 4C 24 08 8B 5C 24 04 B8 4A 00 00 00 FF 15 ?? ?? ?? ?? 89 D3 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_253_0_0 {
	meta:
		name = "__validuser2_sa"
		size = 1129
		refs = "0040 __getline 006a __libc_tsd_CTYPE_B 00bb __libc_tsd_CTYPE_TOLOWER 018d free 01ad strcmp 0275 getnameinfo 02ce getaddrinfo 0322 memcmp 0336 freeaddrinfo 0387 innetgr"
	strings:
		$1 = { 55 57 56 53 81 EC AC 00 00 00 89 44 24 34 89 54 24 38 89 4C 24 3C C7 44 24 44 00 00 00 00 C7 44 24 48 00 00 00 00 66 90 8B 44 24 34 8D 54 24 48 89 54 24 04 89 44 24 08 8D 44 24 44 89 04 24 E8 ?? ?? ?? ?? 85 C0 0F 8E 79 01 00 00 8B 44 24 48 8B 54 24 44 C6 44 02 FF 00 8B 44 24 44 0F B6 10 84 D2 88 54 24 30 74 C0 8B 35 ?? ?? ?? ?? 0F BE FA 65 8B 2E 0F B7 54 7D 00 66 81 E2 00 20 66 89 54 24 2C 0F 84 6D 03 00 00 89 C2 90 8D 74 26 00 83 C2 01 0F B6 0A 84 C9 74 8E 0F BE D9 F6 44 5D 01 20 75 EC 80 F9 23 0F 84 7B FF FF FF 66 83 7C 24 2C 00 0F 85 1B 01 00 00 8B 0D ?? ?? ?? ?? EB 18 8D B4 26 00 00 00 00 65 8B 1E 0F BE FA F6 44 7B 01 20 0F 85 F7 00 00 00 65 8B 11 83 C0 01 8B 14 BA 88 50 FF 0F B6 10 84 D2 75 DC 89 C3 C6 00 00 8B 6C 24 44 B9 02 00 00 00 BE ?? ?? ?? ?? 89 EF F3 A6 0F 84 5C 02 00 00 BE ?? ?? ?? ?? B9 02 00 00 00 89 EF F3 A6 0F 84 7F 02 00 00 0F B6 45 00 3C 2D 0F 84 66 02 00 00 3C 2B 0F 85 07 01 00 00 80 7D 01 00 0F 85 FD 00 00 00 80 3B 00 B9 02 00 00 00 0F 44 9C 24 C0 00 00 00 BE ?? ?? ?? ?? 89 DF F3 A6 0F 84 71 02 00 00 BE ?? ?? ?? ?? B9 02 00 00 00 89 DF F3 A6 0F 84 92 02 00 00 0F B6 03 3C 2D 0F 84 B4 02 00 00 3C 2B 75 21 80 7B 01 00 75 1B 31 DB 8B 44 24 44 89 04 24 E8 ?? ?? ?? ?? 81 C4 AC 00 00 00 89 D8 5B 5E 5F 5D C3 8B 94 24 C4 00 00 00 89 5C 24 04 89 14 24 E8 ?? ?? ?? ?? 85 C0 0F 94 C0 0F B6 C0 85 C0 7F C6 85 C0 0F 84 63 FE FF FF BB FF FF FF FF EB B9 8D 74 26 00 88 54 24 30 80 7C 24 30 09 0F 85 7A 02 00 00 C6 00 00 8D 58 01 0F BE 40 01 84 C0 0F 84 67 01 00 00 65 8B 0E EB 10 66 90 83 C3 01 0F BE 03 84 C0 0F 84 52 01 00 00 F6 44 41 01 20 75 EB 89 D8 EB 12 8D B4 26 00 00 00 00 F6 44 51 01 20 0F 85 CB FE FF FF 83 C0 01 0F BE 10 84 D2 75 EB E9 BC FE FF FF 8D B6 00 00 00 00 BE 01 00 00 00 8B 54 24 3C 8D 44 24 72 C7 44 24 18 01 00 00 00 C7 44 24 14 00 00 00 00 C7 44 24 10 00 00 00 00 89 54 24 04 8B 54 24 38 C7 44 24 0C 2E 00 00 00 89 44 24 08 89 14 24 E8 ?? ?? ?? ?? 85 C0 75 18 8D 44 24 72 89 6C 24 04 89 04 24 E8 ?? ?? ?? ?? 85 C0 0F 84 A5 00 00 00 31 C0 C7 44 04 50 00 00 00 00 83 C0 04 83 F8 20 72 F0 8B 54 24 38 0F B7 02 C7 44 24 04 00 00 00 00 89 2C 24 89 44 24 54 8D 44 24 4C 89 44 24 0C 8D 44 24 50 89 44 24 08 E8 ?? ?? ?? ?? 85 C0 0F 85 4E FD FF FF 8B 54 24 4C 85 D2 89 54 24 2C 0F 84 68 01 00 00 8B 54 24 38 89 74 24 30 8B 6C 24 2C 0F B7 3A 89 D6 EB 0E 8D 76 00 8B 6D 1C 85 ED 0F 84 47 01 00 00 39 7D 04 75 F0 8B 45 10 89 74 24 04 89 44 24 08 8B 45 14 89 04 24 E8 ?? ?? ?? ?? 85 C0 75 D6 8B 74 24 30 8B 54 24 2C 89 14 24 E8 ?? ?? ?? ?? 83 FE 00 0F 8C 82 FE FF FF 0F 84 DF FC FF FF 8D B4 26 00 00 00 00 E9 E6 FD FF FF 8D 76 00 89 D8 8D B6 00 00 00 00 E9 89 FD FF FF 8B 94 24 C8 00 00 00 83 C5 02 C7 44 24 0C 00 00 00 00 C7 44 24 08 00 00 00 00 89 2C 24 89 54 24 04 E8 ?? ?? ?? ?? 89 C6 EB AB 83 C5 01 BE FF FF FF FF E9 A1 FE FF FF 8B 94 24 C8 00 00 00 83 C5 02 C7 44 24 0C 00 00 00 00 C7 44 24 08 00 00 00 00 89 2C 24 89 54 24 04 E8 ?? ?? ?? ?? 89 C6 F7 DE E9 6F FF FF FF 8B 94 24 C4 00 00 00 83 C3 02 C7 44 24 0C 00 00 00 00 C7 44 24 04 00 00 00 00 89 1C 24 89 54 24 08 E8 ?? ?? ?? ?? E9 C3 FD FF FF 0F B6 4C 24 30 E9 A4 FC FF FF 8B 94 24 C4 00 00 00 83 C3 02 C7 44 24 0C 00 00 00 00 C7 44 24 04 00 00 00 00 89 1C 24 89 54 24 08 E8 ?? ?? ?? ?? F7 D8 E9 8C FD FF FF 8B 94 24 C4 00 00 00 83 C3 01 89 1C 24 89 54 24 04 E8 ?? ?? ?? ?? 85 C0 0F 94 C0 0F B6 C0 F7 D8 E9 6B FD FF FF 31 F6 E9 D5 FE FF FF 80 7C 24 30 20 0F 84 7B FD FF FF E9 83 FC FF FF }
	condition:
		$1
}

rule file_253_1_0 {
	meta:
		name = "iruserfopen"
		size = 465
		refs = "0027 __lxstat64 0056 _libc_intl_domainname 005b __dcgettext 0066 __rcmd_errstr 0072 _IO_new_fclose 00c4 _IO_new_fopen 00d6 fileno 00ea __fxstat64"
	strings:
		$1 = { 83 EC 7C 89 74 24 74 8D 74 24 10 89 74 24 08 89 44 24 04 C7 04 24 03 00 00 00 89 5C 24 70 89 C3 89 7C 24 78 89 D7 E8 ?? ?? ?? ?? 85 C0 75 59 8B 4C 24 20 81 E1 00 F0 00 00 81 F9 00 80 00 00 74 77 C7 44 24 08 05 00 00 00 31 DB C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 47 85 DB A3 ?? ?? ?? ?? 74 0A 89 1C 24 31 DB E8 ?? ?? ?? ?? 89 D8 8B 74 24 74 8B 5C 24 70 8B 7C 24 78 83 C4 7C C3 C7 44 24 08 05 00 00 00 31 DB C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 75 B9 81 0B 00 80 00 00 EB C4 8D B6 00 00 00 00 89 1C 24 C7 44 24 04 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 89 C3 0F 84 B6 00 00 00 89 04 24 E8 ?? ?? ?? ?? 89 74 24 08 C7 04 24 03 00 00 00 89 44 24 04 E8 ?? ?? ?? ?? 85 C0 0F 88 BA 00 00 00 8B 44 24 28 85 C0 74 2A 39 F8 74 26 C7 44 24 08 05 00 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? E9 3C FF FF FF 90 8D 74 26 00 F6 44 24 20 12 75 31 83 7C 24 24 01 0F 86 70 FF FF FF C7 44 24 08 05 00 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? E9 04 FF FF FF 90 8D 74 26 00 C7 44 24 08 05 00 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? E9 DE FE FF FF 8D B4 26 00 00 00 00 C7 44 24 08 05 00 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? E9 B6 FE FF FF 8D B4 26 00 00 00 00 C7 44 24 08 05 00 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? E9 8E FE FF FF }
	condition:
		$1
}

rule file_253_2_0 {
	meta:
		name = "ruserok2_sa"
		size = 387
		refs = "0020 __check_rhosts_file 0033 __sysconf 0063 __getpwnam_r 008e strlen 00b3 mempcpy 00c9 __geteuid 00d9 seteuid 0117 _IO_new_fclose"
	strings:
		$1 = { 55 89 E5 57 56 89 CE 53 83 EC 5C 85 C9 89 45 C4 89 55 C0 0F 84 17 01 00 00 BB FF FF FF FF 0B 35 ?? ?? ?? ?? 74 45 C7 04 24 46 00 00 00 BE 10 00 00 00 E8 ?? ?? ?? ?? 8D 4D C8 8D 50 1E 83 E2 F0 29 D4 89 44 24 0C 8D 45 CC 89 44 24 04 8B 45 0C 8D 54 24 23 83 E2 F0 89 4C 24 10 89 54 24 08 89 04 24 E8 ?? ?? ?? ?? 85 C0 74 15 8D 65 F4 BB FF FF FF FF 89 D8 5B 5E 5F 5D C3 8D B6 00 00 00 00 8B 45 C8 85 C0 74 E4 8B 78 14 89 3C 24 E8 ?? ?? ?? ?? 31 D2 89 C1 83 C0 27 F7 F6 C1 E0 04 29 C4 8D 74 24 23 83 E6 F0 89 4C 24 08 89 7C 24 04 89 34 24 E8 ?? ?? ?? ?? C7 00 2F 2E 72 68 C7 40 04 6F 73 74 73 C6 40 08 00 E8 ?? ?? ?? ?? 89 C7 8B 45 C8 8B 40 08 89 04 24 E8 ?? ?? ?? ?? 8B 45 C8 8B 50 08 89 F0 E8 36 FD FF FF 85 C0 89 C6 74 2B 8B 45 10 8B 4D C0 8B 55 C4 89 44 24 08 8B 45 08 89 44 24 04 8B 45 0C 89 04 24 89 F0 E8 9F F8 FF FF 89 34 24 89 C3 E8 ?? ?? ?? ?? 89 3C 24 E8 ?? ?? ?? ?? 8D 65 F4 89 D8 5B 5E 5F 5D C3 8D 76 00 31 D2 B8 ?? ?? ?? ?? E8 E4 FC FF FF 85 C0 89 C7 0F 84 D3 FE FF FF 8B 45 10 8B 4D C0 8B 55 C4 89 44 24 08 8B 45 08 89 44 24 04 8B 45 0C 89 04 24 89 F8 E8 49 F8 FF FF 89 3C 24 89 C3 E8 ?? ?? ?? ?? 85 DB 0F 85 A5 FE FF FF 8D 65 F4 89 D8 5B 5E 5F 5D C3 }
	condition:
		$1
}

rule file_253_3_0 {
	meta:
		name = "rresvport_af"
		size = 364
		refs = "002a __libc_errno 006b __socket 00c9 __bind 0101 __close"
	strings:
		$1 = { 55 57 56 53 81 EC AC 00 00 00 0F B7 94 24 C4 00 00 00 8B 9C 24 C0 00 00 00 66 83 FA 02 74 29 66 83 FA 0A 0F 84 F7 00 00 00 A1 ?? ?? ?? ?? BE FF FF FF FF 65 C7 00 61 00 00 00 81 C4 AC 00 00 00 89 F0 5B 5E 5F 5D C3 90 C7 44 24 1C 10 00 00 00 0F B7 C2 C7 44 24 08 00 00 00 00 C7 44 24 04 01 00 00 00 89 04 24 89 54 24 18 E8 ?? ?? ?? ?? 8B 54 24 18 85 C0 89 C6 0F 88 E5 00 00 00 8D 6C 24 20 31 C0 B9 20 00 00 00 89 EF F3 AB 66 89 54 24 20 8B 3B 81 FF FF 01 00 00 0F 8F 91 00 00 00 C7 03 00 02 00 00 BF 00 02 00 00 89 FA 8D 74 26 00 8B 44 24 1C 89 6C 24 04 89 34 24 66 C1 CA 08 89 44 24 08 66 89 54 24 22 E8 ?? ?? ?? ?? 85 C0 0F 89 65 FF FF FF A1 ?? ?? ?? ?? 65 83 38 62 75 70 8B 03 3D 00 02 00 00 8D 50 FF B8 FF 03 00 00 0F 44 D0 39 D7 89 13 75 B8 89 34 24 BE FF FF FF FF E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 65 C7 00 0B 00 00 00 81 C4 AC 00 00 00 89 F0 5B 5E 5F 5D C3 66 90 C7 44 24 1C 1C 00 00 00 E9 23 FF FF FF 8D 76 00 81 FF FF 03 00 00 0F 8E 6E FF FF FF C7 03 FF 03 00 00 BF FF 03 00 00 E9 5E FF FF FF 8D 74 26 00 89 34 24 BE FF FF FF FF E8 ?? ?? ?? ?? E9 D8 FE FF FF BE FF FF FF FF E9 CE FE FF FF }
	condition:
		$1
}

rule file_253_4_0 {
	meta:
		name = "rcmd_af"
		size = 2785
		refs = "0033 __getpid 0097 __snprintf 00b8 getaddrinfo 00f7 __fxprintf 0176 free 0185 __strdup 01ad __sigblock 01e0 rresvport_af 0202 __fcntl 0218 __connect 0228 __close 022e __libc_errno 0292 getnameinfo 02a9 _libc_intl_domainname 02ae __dcgettext 02c2 __asprintf 0305 perror 03d5 __sleep 0413 __sigsetmask 041f freeaddrinfo 048b __listen 04f2 __write 0568 __poll 05ac accept 0628 strlen 0680 __writev 06a8 __read 0749 gai_strerror 07f6 __strerror_r"
	strings:
		$1 = { 55 57 56 53 81 EC AC 01 00 00 0F B7 B4 24 D8 01 00 00 0F B7 9C 24 C4 01 00 00 89 F0 83 E0 F7 66 83 F8 02 0F 84 DF 00 00 00 66 85 F6 0F 85 B4 08 00 00 E8 ?? ?? ?? ?? 8D BC 24 88 00 00 00 89 44 24 30 31 C0 C7 04 07 00 00 00 00 83 C0 04 83 F8 20 72 F1 C7 84 24 88 00 00 00 02 00 00 00 C7 84 24 8C 00 00 00 00 00 00 00 C7 84 24 90 00 00 00 01 00 00 00 66 C1 CB 08 0F B7 DB 89 5C 24 0C 8D 5C 24 58 C7 44 24 08 ?? ?? ?? ?? C7 44 24 04 08 00 00 00 89 1C 24 E8 ?? ?? ?? ?? 8B 94 24 C0 01 00 00 8D 44 24 48 89 44 24 0C 89 7C 24 08 89 5C 24 04 8B 02 89 04 24 E8 ?? ?? ?? ?? 85 C0 0F 84 8C 00 00 00 83 F8 FE 0F 85 73 06 00 00 8B 8C 24 C0 01 00 00 8B 11 85 D2 0F 84 62 06 00 00 89 54 24 08 BD FF FF FF FF C7 44 24 04 ?? ?? ?? ?? C7 04 24 00 00 00 00 E8 ?? ?? ?? ?? 81 C4 AC 01 00 00 89 E8 5B 5E 5F 5D C3 E8 ?? ?? ?? ?? 8D BC 24 88 00 00 00 89 44 24 30 31 C0 C7 04 07 00 00 00 00 83 C0 04 83 F8 20 72 F1 C7 84 24 88 00 00 00 02 00 00 00 89 B4 24 8C 00 00 00 C7 84 24 90 00 00 00 01 00 00 00 E9 29 FF FF FF 90 8D 74 26 00 8B 5C 24 48 66 C7 44 24 64 01 00 66 C7 44 24 6C 01 00 8B 43 18 85 C0 0F 84 0B 06 00 00 A1 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 8B 44 24 48 8B 40 18 89 04 24 E8 ?? ?? ?? ?? 85 C0 A3 ?? ?? ?? ?? 0F 84 AA 08 00 00 8B 94 24 C0 01 00 00 8B 5C 24 48 89 02 C7 04 24 00 00 40 00 31 FF E8 ?? ?? ?? ?? 8D B4 24 AA 00 00 00 C7 44 24 4C FF 03 00 00 C7 44 24 34 01 00 00 00 89 44 24 38 8D 74 26 00 0F B7 43 04 89 44 24 04 8D 44 24 4C 89 04 24 E8 ?? ?? ?? ?? 85 C0 89 C5 0F 88 FA 01 00 00 8B 44 24 30 C7 44 24 04 08 00 00 00 89 2C 24 89 44 24 08 E8 ?? ?? ?? ?? 8B 53 10 8B 43 14 89 2C 24 89 54 24 08 89 44 24 04 E8 ?? ?? ?? ?? 85 C0 0F 89 14 02 00 00 89 2C 24 E8 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 65 8B 29 83 FD 62 0F 84 6A 01 00 00 83 FD 6F B8 01 00 00 00 0F 44 F8 8B 43 1C 85 C0 0F 84 64 01 00 00 C7 44 24 18 01 00 00 00 C7 44 24 14 00 00 00 00 C7 44 24 10 00 00 00 00 C7 44 24 0C 2E 00 00 00 89 74 24 08 8B 43 10 C7 44 24 54 00 00 00 00 89 44 24 04 8B 43 14 89 4C 24 2C 89 04 24 E8 ?? ?? ?? ?? C7 44 24 08 05 00 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 54 24 54 89 74 24 08 89 14 24 89 44 24 04 E8 ?? ?? ?? ?? 8B 4C 24 2C 85 C0 78 2C 8B 44 24 54 C7 44 24 04 ?? ?? ?? ?? C7 04 24 00 00 00 00 89 44 24 08 E8 ?? ?? ?? ?? 8B 44 24 54 89 04 24 E8 ?? ?? ?? ?? 8B 4C 24 2C 65 89 29 C7 04 24 00 00 00 00 E8 ?? ?? ?? ?? 8B 5B 1C C7 44 24 18 01 00 00 00 C7 44 24 14 00 00 00 00 C7 44 24 10 00 00 00 00 C7 44 24 0C 2E 00 00 00 89 74 24 08 8B 43 10 89 44 24 04 8B 43 14 89 04 24 E8 ?? ?? ?? ?? C7 44 24 08 05 00 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 4C 24 54 89 74 24 08 89 0C 24 89 44 24 04 E8 ?? ?? ?? ?? 85 C0 0F 88 56 FE FF FF 8B 44 24 54 C7 44 24 04 ?? ?? ?? ?? C7 04 24 00 00 00 00 89 44 24 08 E8 ?? ?? ?? ?? 8B 44 24 54 89 04 24 E8 ?? ?? ?? ?? E9 29 FE FF FF 90 83 6C 24 4C 01 E9 1E FE FF FF 8D B6 00 00 00 00 85 FF 0F 84 08 04 00 00 83 7C 24 34 10 0F 8F FD 03 00 00 8B 54 24 34 31 FF 89 14 24 E8 ?? ?? ?? ?? 8B 5C 24 48 D1 64 24 34 E9 EA FD FF FF 66 90 A1 ?? ?? ?? ?? 65 83 38 0B 0F 84 93 03 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 00 00 00 00 E8 ?? ?? ?? ?? 8B 44 24 38 89 04 24 E8 ?? ?? ?? ?? 8B 44 24 48 89 04 24 E8 ?? ?? ?? ?? 81 C4 AC 01 00 00 BD FF FF FF FF 5B 89 E8 5E 5F 5D C3 8D 76 00 8B B4 24 D4 01 00 00 83 6C 24 4C 01 85 F6 0F 84 6D 04 00 00 0F B7 43 04 8D 54 24 4C 89 14 24 89 44 24 04 E8 ?? ?? ?? ?? 89 44 24 30 8B 4C 24 30 8B 43 10 85 C9 89 44 24 50 0F 88 B7 02 00 00 8B 44 24 30 8D 74 24 70 C7 44 24 04 01 00 00 00 89 04 24 E8 ?? ?? ?? ?? 8B 44 24 4C C7 44 24 08 ?? ?? ?? ?? C7 44 24 04 08 00 00 00 89 34 24 89 44 24 0C E8 ?? ?? ?? ?? 89 F1 8B 11 83 C1 04 8D 82 FF FE FE FE F7 D2 21 D0 25 80 80 80 80 74 EA 89 C3 C1 EB 10 A9 80 80 00 00 0F 44 C3 8D 59 02 0F 44 CB 00 C0 83 D9 03 89 F3 29 F1 83 C1 01 89 4C 24 08 89 74 24 04 89 2C 24 E8 ?? ?? ?? ?? 8B 13 83 C3 04 8D 8A FF FE FE FE F7 D2 21 D1 81 E1 80 80 80 80 74 E9 89 CF C1 EF 10 F7 C1 80 80 00 00 0F 44 CF 8D 7B 02 0F 44 DF 00 C9 83 DB 03 29 F3 83 C3 01 39 D8 0F 85 C9 03 00 00 8B 44 24 30 8B 0D ?? ?? ?? ?? 89 6C 24 60 89 44 24 68 8D 44 24 60 65 C7 01 00 00 00 00 C7 44 24 08 FF FF FF FF C7 44 24 04 02 00 00 00 89 04 24 89 4C 24 2C E8 ?? ?? ?? ?? 8B 4C 24 2C 85 C0 0F 8E F5 03 00 00 F6 44 24 6E 01 8D BC 24 D8 00 00 00 8D 5C 24 50 0F 84 DF 03 00 00 89 74 24 3C 8B 74 24 30 89 6C 24 34 89 CD 8D 74 26 00 89 5C 24 08 89 7C 24 04 89 34 24 E8 ?? ?? ?? ?? 83 F8 FF 75 07 65 83 7D 00 04 74 E4 89 C2 0F B7 84 24 D8 00 00 00 8B 6C 24 34 8B 74 24 3C 66 83 F8 02 0F 84 58 02 00 00 31 FF 66 83 F8 0A 0F 84 4C 02 00 00 8B 44 24 30 89 54 24 2C 89 04 24 E8 ?? ?? ?? ?? 8B 54 24 2C 85 D2 0F 88 7E 04 00 00 8B 8C 24 D4 01 00 00 66 81 EF 00 02 66 81 FF FF 01 89 11 0F 87 95 03 00 00 8B 84 24 C8 01 00 00 89 04 24 89 44 24 70 E8 ?? ?? ?? ?? 8B 94 24 CC 01 00 00 89 14 24 89 54 24 78 83 C0 01 89 44 24 74 E8 ?? ?? ?? ?? 8B 8C 24 D0 01 00 00 89 0C 24 89 8C 24 80 00 00 00 83 C0 01 89 44 24 7C E8 ?? ?? ?? ?? 83 C0 01 89 84 24 84 00 00 00 8D 76 00 C7 44 24 08 03 00 00 00 89 74 24 04 89 2C 24 E8 ?? ?? ?? ?? 83 F8 FF 75 0F A1 ?? ?? ?? ?? 65 83 38 04 74 DC 8D 74 26 00 C7 44 24 08 01 00 00 00 89 5C 24 04 89 2C 24 E8 ?? ?? ?? ?? 83 F8 FF 0F 85 8C 01 00 00 A1 ?? ?? ?? ?? 65 83 38 04 74 D8 C7 44 24 54 00 00 00 00 8B 94 24 C0 01 00 00 8B 02 C7 44 24 04 ?? ?? ?? ?? 89 44 24 08 8D 44 24 54 89 04 24 E8 ?? ?? ?? ?? 85 C0 78 28 8B 44 24 54 C7 44 24 04 ?? ?? ?? ?? C7 04 24 00 00 00 00 89 44 24 08 E8 ?? ?? ?? ?? 8B 44 24 54 89 04 24 E8 ?? ?? ?? ?? 8B 44 24 4C 85 C0 74 11 8B 94 24 D4 01 00 00 8B 02 89 04 24 E8 ?? ?? ?? ?? 89 2C 24 E8 ?? ?? ?? ?? E9 D0 FC FF FF 90 8D 74 26 00 89 04 24 BD FF FF FF FF E8 ?? ?? ?? ?? C7 44 24 04 ?? ?? ?? ?? C7 04 24 00 00 00 00 89 44 24 08 E8 ?? ?? ?? ?? 81 C4 AC 01 00 00 89 E8 5B 5E 5F 5D C3 8D B6 00 00 00 00 8B 8C 24 C0 01 00 00 C7 01 00 00 00 00 E9 19 FA FF FF C7 44 24 08 05 00 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 44 24 04 ?? ?? ?? ?? C7 04 24 00 00 00 00 89 44 24 08 E8 ?? ?? ?? ?? E9 48 FC FF FF 90 8D 74 26 00 8B 44 24 48 89 4C 24 2C 89 04 24 E8 ?? ?? ?? ?? 8B 4C 24 2C 8D 84 24 D8 00 00 00 C7 44 24 08 C8 00 00 00 89 44 24 04 65 8B 01 89 04 24 E8 ?? ?? ?? ?? 8B 8C 24 C0 01 00 00 89 44 24 0C 8B 01 C7 44 24 04 ?? ?? ?? ?? C7 04 24 00 00 00 00 89 44 24 08 E8 ?? ?? ?? ?? 8B 44 24 38 89 04 24 E8 ?? ?? ?? ?? E9 F3 FB FF FF 0F B7 BC 24 DA 00 00 00 66 C1 CF 08 E9 A3 FD FF FF 83 F8 01 0F 85 55 02 00 00 80 7C 24 50 00 75 27 8B 44 24 38 89 04 24 E8 ?? ?? ?? ?? 8B 44 24 48 89 04 24 E8 ?? ?? ?? ?? 81 C4 AC 01 00 00 89 E8 5B 5E 5F 5D C3 66 90 C7 44 24 08 01 00 00 00 89 5C 24 04 89 2C 24 E8 ?? ?? ?? ?? 83 F8 01 0F 85 80 FE FF FF C7 44 24 08 01 00 00 00 89 5C 24 04 C7 04 24 02 00 00 00 E8 ?? ?? ?? ?? 80 7C 24 50 0A 75 C4 E9 5C FE FF FF C7 44 24 08 01 00 00 00 8D 74 24 70 C7 44 24 04 ?? ?? ?? ?? 8D 5C 24 50 89 2C 24 E8 ?? ?? ?? ?? C7 44 24 4C 00 00 00 00 E9 33 FD FF FF A1 ?? ?? ?? ?? BD FF FF FF FF 65 C7 00 61 00 00 00 E9 FF F7 FF FF C7 44 24 08 05 00 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? C7 44 24 54 00 00 00 00 E8 ?? ?? ?? ?? 89 44 24 04 8D 44 24 54 89 04 24 E8 ?? ?? ?? ?? 85 C0 78 28 8B 44 24 54 C7 44 24 04 ?? ?? ?? ?? C7 04 24 00 00 00 00 89 44 24 08 E8 ?? ?? ?? ?? 8B 44 24 54 89 04 24 E8 ?? ?? ?? ?? 8B 44 24 30 89 04 24 E8 ?? ?? ?? ?? E9 C1 FD FF FF 65 8B 11 C7 44 24 54 00 00 00 00 85 D2 75 73 8D 5C 24 54 C7 44 24 08 05 00 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 1C 24 89 44 24 04 E8 ?? ?? ?? ?? 85 C0 79 88 EB AE C7 44 24 08 05 00 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? C7 44 24 54 00 00 00 00 E8 ?? ?? ?? ?? 89 44 24 04 8D 44 24 54 89 04 24 E8 ?? ?? ?? ?? 85 C0 0F 89 03 FD FF FF E9 26 FD FF FF C7 44 24 08 05 00 00 00 8D 5C 24 54 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? 89 4C 24 2C E8 ?? ?? ?? ?? 89 1C 24 89 44 24 04 E8 ?? ?? ?? ?? 8B 4C 24 2C 85 C0 0F 89 09 FF FF FF 65 83 39 00 0F 85 27 FF FF FF E9 46 FF FF FF 8D B6 00 00 00 00 C7 44 24 08 05 00 00 00 BD FF FF FF FF C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 44 24 04 ?? ?? ?? ?? C7 04 24 00 00 00 00 89 44 24 08 E8 ?? ?? ?? ?? E9 7D F6 FF FF C7 44 24 04 ?? ?? ?? ?? C7 04 24 00 00 00 00 E8 ?? ?? ?? ?? C7 44 24 4C 00 00 00 00 E9 8F FC FF FF 85 C0 C7 44 24 54 00 00 00 00 0F 85 19 FC FF FF 8B 94 24 C0 01 00 00 8B 1A C7 44 24 08 05 00 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 5C 24 08 89 44 24 04 E9 FC FB FF FF }
	condition:
		$1
}

rule file_253_5_0 {
	meta:
		name = "rcmd"
		size = 68
		refs = "003c rcmd_af"
	strings:
		$1 = { 83 EC 2C 8B 54 24 44 0F B7 44 24 34 C7 44 24 18 02 00 00 00 89 54 24 14 8B 54 24 40 89 44 24 04 8B 44 24 30 89 54 24 10 8B 54 24 3C 89 04 24 89 54 24 0C 8B 54 24 38 89 54 24 08 E8 ?? ?? ?? ?? 83 C4 2C C3 }
	condition:
		$1
}

rule file_253_6_0 {
	meta:
		name = "rresvport"
		size = 27
		refs = "0013 rresvport_af"
	strings:
		$1 = { 83 EC 1C 8B 44 24 20 C7 44 24 04 02 00 00 00 89 04 24 E8 ?? ?? ?? ?? 83 C4 1C C3 }
	condition:
		$1
}

rule file_712_0_0 {
	meta:
		name = "ether_aton"
		size = 27
		refs = "0013 ether_aton_r"
	strings:
		$1 = { 83 EC 1C 8B 44 24 20 C7 44 24 04 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 83 C4 1C C3 }
	condition:
		$1
}

rule file_1357_0_0 {
	meta:
		name = "ether_ntoa"
		size = 27
		refs = "0013 ether_ntoa_r"
	strings:
		$1 = { 83 EC 1C 8B 44 24 20 C7 44 24 04 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 83 C4 1C C3 }
	condition:
		$1
}

rule file_254_2_0 {
	meta:
		name = "hcreate"
		size = 27
		refs = "0013 hcreate_r"
	strings:
		$1 = { 83 EC 1C 8B 44 24 20 C7 44 24 04 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 83 C4 1C C3 }
	condition:
		$1
}

rule file_388_0_0 {
	meta:
		name = "lcong48"
		size = 27
		refs = "000b __libc_drand48_data 0013 __lcong48_r"
	strings:
		$1 = { 83 EC 1C 8B 44 24 20 C7 44 24 04 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 83 C4 1C C3 }
	condition:
		$1
}

rule file_1290_0_0 {
	meta:
		name = "srand48"
		size = 27
		refs = "000b __libc_drand48_data 0013 __srand48_r"
	strings:
		$1 = { 83 EC 1C 8B 44 24 20 C7 44 24 04 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 83 C4 1C C3 }
	condition:
		$1
}

rule file_253_7_0 {
	meta:
		name = "ruserok_af"
		size = 187
		refs = "004a getaddrinfo 008f freeaddrinfo"
	strings:
		$1 = { 55 31 C0 57 56 53 83 EC 4C 8B 74 24 60 8B 7C 24 68 8B 6C 24 6C 0F B7 54 24 70 C7 44 04 20 00 00 00 00 83 C0 04 83 F8 20 72 F0 8D 44 24 1C 89 44 24 0C 8D 44 24 20 89 44 24 08 C7 44 24 04 00 00 00 00 89 34 24 89 54 24 24 E8 ?? ?? ?? ?? 85 C0 75 62 8B 5C 24 1C 85 DB 75 0D EB 4F 8D 74 26 00 8B 5B 1C 85 DB 74 39 8B 53 10 8B 43 14 8B 4C 24 64 89 74 24 08 89 6C 24 04 89 3C 24 E8 1F F1 FF FF 85 C0 75 DB 8B 44 24 1C 31 DB 89 04 24 E8 ?? ?? ?? ?? 83 C4 4C 89 D8 5B 5E 5F 5D C3 8D 76 00 8B 44 24 1C BB FF FF FF FF EB E0 31 C0 BB FF FF FF FF EB D7 BB FF FF FF FF EB D8 }
	condition:
		$1
}

rule file_253_8_0 {
	meta:
		name = "ruserok"
		size = 51
		refs = "002b ruserok_af"
	strings:
		$1 = { 83 EC 2C 8B 44 24 3C C7 44 24 10 02 00 00 00 89 44 24 0C 8B 44 24 38 89 44 24 08 8B 44 24 34 89 44 24 04 8B 44 24 30 89 04 24 E8 ?? ?? ?? ?? 83 C4 2C C3 }
	condition:
		$1
}

rule file_253_9_0 {
	meta:
		name = "iruserok_af"
		size = 209
	strings:
		$1 = { 81 EC 9C 00 00 00 31 C0 0F B7 94 24 B0 00 00 00 B9 20 00 00 00 89 9C 24 90 00 00 00 8D 5C 24 10 89 BC 24 98 00 00 00 89 DF 89 B4 24 94 00 00 00 8B B4 24 A0 00 00 00 66 83 FA 02 F3 AB 74 29 31 C0 66 83 FA 0A 74 61 8B 9C 24 90 00 00 00 8B B4 24 94 00 00 00 8B BC 24 98 00 00 00 81 C4 9C 00 00 00 C3 90 8D 74 26 00 66 C7 44 24 10 02 00 8B 06 BA 10 00 00 00 89 44 24 14 8B 84 24 AC 00 00 00 8B 8C 24 A4 00 00 00 C7 44 24 08 ?? ?? ?? ?? 89 44 24 04 8B 84 24 A8 00 00 00 89 04 24 89 D8 E8 FB EF FF FF EB A0 90 66 C7 44 24 10 0A 00 8B 06 BA 1C 00 00 00 89 44 24 18 8B 46 04 89 44 24 1C 8B 46 08 89 44 24 20 8B 46 0C 89 44 24 24 EB A9 }
	condition:
		$1
}

rule file_253_10_0 {
	meta:
		name = "iruserok"
		size = 51
		refs = "002b iruserok_af"
	strings:
		$1 = { 83 EC 2C 8B 44 24 3C C7 44 24 10 02 00 00 00 89 44 24 0C 8B 44 24 38 89 44 24 08 8B 44 24 34 89 44 24 04 8D 44 24 30 89 04 24 E8 ?? ?? ?? ?? 83 C4 2C C3 }
	condition:
		$1
}

rule file_253_11_0 {
	meta:
		name = "__ivaliduser"
		size = 87
	strings:
		$1 = { 83 EC 2C B9 10 00 00 00 8B 44 24 34 8D 54 24 10 C7 44 24 08 ?? ?? ?? ?? C7 44 24 10 00 00 00 00 C7 44 24 18 00 00 00 00 89 44 24 14 8B 44 24 3C C7 44 24 1C 00 00 00 00 66 C7 44 24 10 02 00 89 44 24 04 8B 44 24 38 89 04 24 8B 44 24 30 E8 DD E8 FF FF 83 C4 2C C3 }
	condition:
		$1
}

rule file_254_1_0 {
	meta:
		name = "hsearch"
		size = 55
		refs = "002b hsearch_r"
	strings:
		$1 = { 83 EC 3C 8D 44 24 2C 8B 54 24 44 89 44 24 0C 8B 44 24 48 C7 44 24 10 ?? ?? ?? ?? 89 54 24 04 89 44 24 08 8B 44 24 40 89 04 24 E8 ?? ?? ?? ?? 8B 44 24 2C 83 C4 3C C3 }
	condition:
		$1
}

rule file_255_0_0 {
	meta:
		name = "psiginfo"
		size = 1173
		refs = "0030 fmemopen 005a _sys_siglist 0075 _libc_intl_domainname 007a __dcgettext 008e fprintf 0191 __libc_current_sigrtmin 019c __libc_current_sigrtmax 01e0 _IO_new_fclose 0226 __write_nocancel 02cd __fxprintf 0464 fwrite"
	strings:
		$1 = { 55 57 56 53 81 EC 3C 02 00 00 8D 7C 24 30 8B B4 24 50 02 00 00 C7 44 24 08 ?? ?? ?? ?? 8B AC 24 54 02 00 00 C7 44 24 04 00 02 00 00 89 3C 24 E8 ?? ?? ?? ?? 85 C0 0F 84 64 02 00 00 85 ED 89 C3 74 0A 80 7D 00 00 0F 85 EC 01 00 00 8B 2E 83 FD 40 0F 87 59 01 00 00 8B 04 AD ?? ?? ?? ?? 85 C0 0F 84 2A 01 00 00 C7 44 24 08 05 00 00 00 89 44 24 04 C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 44 24 04 ?? ?? ?? ?? 89 1C 24 89 44 24 08 E8 ?? ?? ?? ?? 8B 06 83 E8 04 83 F8 19 76 3C 8B 46 08 83 F8 FD 0F 84 D8 02 00 00 0F 8E AA 01 00 00 83 F8 FF 0F 84 A9 02 00 00 0F 8C 93 02 00 00 85 C0 90 0F 84 7A 02 00 00 3D 80 00 00 00 0F 85 0F 02 00 00 BA ?? ?? ?? ?? EB 31 8B 0C 85 ?? ?? ?? ?? 8B 14 85 ?? ?? ?? ?? 8B 2C 85 ?? ?? ?? ?? 8B 46 08 85 C9 74 AB 85 C0 7E A7 39 E8 77 A3 0F B6 4C 01 FF 01 CA 0F 84 D7 01 00 00 C7 44 24 08 05 00 00 00 89 54 24 04 C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 44 24 04 ?? ?? ?? ?? 89 1C 24 89 44 24 08 E8 ?? ?? ?? ?? 8B 06 83 F8 08 0F 84 40 01 00 00 83 F8 04 0F 84 37 01 00 00 83 F8 0B 0F 84 2E 01 00 00 83 F8 07 0F 84 25 01 00 00 83 F8 11 66 90 0F 84 3A 02 00 00 83 F8 1D 0F 84 A1 01 00 00 8B 46 10 89 44 24 0C 8B 46 0C C7 44 24 04 ?? ?? ?? ?? 89 1C 24 89 44 24 08 E8 ?? ?? ?? ?? EB 4D 90 E8 ?? ?? ?? ?? 39 C5 8B 2E 7C 15 E8 ?? ?? ?? ?? 39 C5 0F 8C 22 02 00 00 8B 2E 8D B6 00 00 00 00 C7 44 24 08 05 00 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 6C 24 08 89 1C 24 89 44 24 04 E8 ?? ?? ?? ?? 89 1C 24 E8 ?? ?? ?? ?? 89 FA 8B 0A 83 C2 04 8D 81 FF FE FE FE F7 D1 21 C8 25 80 80 80 80 74 EA 89 C1 C1 E9 10 A9 80 80 00 00 0F 44 C1 8D 4A 02 0F 44 D1 00 C0 83 DA 03 29 FA 89 7C 24 04 89 54 24 08 C7 04 24 02 00 00 00 E8 ?? ?? ?? ?? 81 C4 3C 02 00 00 5B 5E 5F 5D C3 8D 76 00 89 6C 24 08 C7 44 24 04 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? E9 FB FD FF FF 8D B4 26 00 00 00 00 83 F8 FA 0F 84 2F 01 00 00 0F 8E C9 00 00 00 83 F8 FB 0F 84 00 01 00 00 83 F8 FC 75 6B BA ?? ?? ?? ?? E9 8A FE FF FF 90 8B 46 0C C7 44 24 04 ?? ?? ?? ?? 89 1C 24 89 44 24 08 E8 ?? ?? ?? ?? E9 40 FF FF FF 8D 74 26 00 85 ED 74 5C 80 7D 00 00 74 56 BA ?? ?? ?? ?? 8B 06 89 6C 24 08 89 54 24 0C C7 44 24 04 ?? ?? ?? ?? 89 44 24 10 C7 04 24 00 00 00 00 E8 ?? ?? ?? ?? 81 C4 3C 02 00 00 5B 5E 5F 5D C3 8D 74 26 00 89 44 24 08 C7 44 24 04 ?? ?? ?? ?? 89 1C 24 E8 ?? ?? ?? ?? E9 3C FE FF FF 8D B4 26 00 00 00 00 BA ?? ?? ?? ?? 89 D5 EB A6 8D B4 26 00 00 00 00 8B 46 0C C7 44 24 04 ?? ?? ?? ?? 89 1C 24 89 44 24 08 E8 ?? ?? ?? ?? E9 B0 FE FF FF 8D 74 26 00 83 F8 C4 75 AB BA ?? ?? ?? ?? E9 CA FD FF FF 90 BA ?? ?? ?? ?? E9 BF FD FF FF 8D B6 00 00 00 00 BA ?? ?? ?? ?? E9 AF FD FF FF 8D B6 00 00 00 00 BA ?? ?? ?? ?? E9 9F FD FF FF 8D B6 00 00 00 00 BA ?? ?? ?? ?? E9 8F FD FF FF 8D B6 00 00 00 00 BA ?? ?? ?? ?? E9 7F FD FF FF 8D B6 00 00 00 00 BA ?? ?? ?? ?? E9 6F FD FF FF 8D B6 00 00 00 00 8B 46 10 89 44 24 10 8B 46 14 89 44 24 0C 8B 46 0C C7 44 24 04 ?? ?? ?? ?? 89 1C 24 89 44 24 08 E8 ?? ?? ?? ?? E9 12 FE FF FF 8B 06 89 44 24 2C E8 ?? ?? ?? ?? 29 44 24 2C E8 ?? ?? ?? ?? 8B 2E 29 E8 39 44 24 2C 7D 2B E8 ?? ?? ?? ?? 39 C5 74 57 8B 2E E8 ?? ?? ?? ?? C7 44 24 04 ?? ?? ?? ?? 89 1C 24 29 C5 89 6C 24 08 E8 ?? ?? ?? ?? E9 7F FC FF FF E8 ?? ?? ?? ?? 39 C5 8D B6 00 00 00 00 74 4E E8 ?? ?? ?? ?? 2B 06 C7 44 24 04 ?? ?? ?? ?? 89 1C 24 89 44 24 08 E8 ?? ?? ?? ?? E9 50 FC FF FF 8D B6 00 00 00 00 89 5C 24 0C C7 44 24 08 0A 00 00 00 C7 44 24 04 01 00 00 00 C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? E9 25 FC FF FF 8D 76 00 89 5C 24 0C C7 44 24 08 0A 00 00 00 C7 44 24 04 01 00 00 00 C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? E9 FD FB FF FF }
	condition:
		$1
}

rule file_256_0_0 {
	meta:
		name = "__strndup"
		size = 76
		refs = "0015 __strnlen 0022 malloc 003a memcpy"
	strings:
		$1 = { 56 53 83 EC 14 8B 44 24 24 8B 74 24 20 89 44 24 04 89 34 24 E8 ?? ?? ?? ?? 89 C3 83 C0 01 89 04 24 E8 ?? ?? ?? ?? 85 C0 74 1E C6 04 18 00 89 5C 24 08 89 74 24 04 89 04 24 E8 ?? ?? ?? ?? 83 C4 14 5B 5E C3 8D 74 26 00 31 C0 EB F2 }
	condition:
		$1
}

rule file_257_0_0 {
	meta:
		name = "__libc_init_first"
		size = 148
		refs = "0001 _dl_starting_up 0030 __fpu_control 0036 __libc_multiple_libcs 0042 __setfpucw 0048 __libc_argc 004e __libc_argv 0054 __environ 0059 __libc_init_secure 005e _dl_non_dynamic_init 006e __init_misc 0082 __ctype_init"
	strings:
		$1 = { B8 ?? ?? ?? ?? 83 EC 1C 85 C0 89 5C 24 10 8B 5C 24 20 89 74 24 14 8B 74 24 24 89 7C 24 18 8B 7C 24 28 74 09 A1 ?? ?? ?? ?? 85 C0 74 5B 0F B7 05 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 00 00 00 00 89 04 24 E8 ?? ?? ?? ?? 89 1D ?? ?? ?? ?? 89 35 ?? ?? ?? ?? 89 3D ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 7C 24 08 89 74 24 04 89 1C 24 E8 ?? ?? ?? ?? 8B 5C 24 10 8B 74 24 14 8B 7C 24 18 83 C4 1C E9 ?? ?? ?? ?? 66 90 C7 05 ?? ?? ?? ?? 01 00 00 00 EB B2 }
	condition:
		$1
}

rule file_258_2_0 {
	meta:
		name = "getspnam"
		size = 268
		refs = "0065 __getspnam_r 008a realloc 0096 free 009b __libc_errno 00f5 malloc"
	strings:
		$1 = { 55 31 C0 57 B9 01 00 00 00 56 53 83 EC 3C 8B 74 24 50 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 0D ?? ?? ?? ?? 0F 85 E2 00 00 00 A1 ?? ?? ?? ?? 8D 7C 24 2C 8B 1D ?? ?? ?? ?? 85 C0 75 10 E9 A1 00 00 00 8D B6 00 00 00 00 A3 ?? ?? ?? ?? 89 7C 24 10 89 5C 24 0C 89 44 24 08 C7 44 24 04 ?? ?? ?? ?? 89 34 24 E8 ?? ?? ?? ?? 83 F8 22 75 6A 8B 1D ?? ?? ?? ?? 8B 2D ?? ?? ?? ?? 01 DB 89 5C 24 04 89 2C 24 89 1D ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 75 B6 89 2C 24 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 00 00 00 00 65 C7 00 0C 00 00 00 C7 44 24 2C 00 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 83 2D ?? ?? ?? ?? 01 75 50 8B 44 24 2C 83 C4 3C 5B 5E 5F 5D C3 A1 ?? ?? ?? ?? 85 C0 75 D7 EB CD C7 04 24 00 04 00 00 C7 05 ?? ?? ?? ?? 00 04 00 00 E8 ?? ?? ?? ?? 85 C0 A3 ?? ?? ?? ?? 74 AE BB 00 04 00 00 E9 41 FF FF FF }
	condition:
		$1
}

rule file_1350_2_0 {
	meta:
		name = "getaliasbyname"
		size = 268
		refs = "0065 __getaliasbyname_r 008a realloc 0096 free 009b __libc_errno 00f5 malloc"
	strings:
		$1 = { 55 31 C0 57 B9 01 00 00 00 56 53 83 EC 3C 8B 74 24 50 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 0D ?? ?? ?? ?? 0F 85 E2 00 00 00 A1 ?? ?? ?? ?? 8D 7C 24 2C 8B 1D ?? ?? ?? ?? 85 C0 75 10 E9 A1 00 00 00 8D B6 00 00 00 00 A3 ?? ?? ?? ?? 89 7C 24 10 89 5C 24 0C 89 44 24 08 C7 44 24 04 ?? ?? ?? ?? 89 34 24 E8 ?? ?? ?? ?? 83 F8 22 75 6A 8B 1D ?? ?? ?? ?? 8B 2D ?? ?? ?? ?? 01 DB 89 5C 24 04 89 2C 24 89 1D ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 75 B6 89 2C 24 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 00 00 00 00 65 C7 00 0C 00 00 00 C7 44 24 2C 00 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 83 2D ?? ?? ?? ?? 01 75 50 8B 44 24 2C 83 C4 3C 5B 5E 5F 5D C3 A1 ?? ?? ?? ?? 85 C0 75 D7 EB CD C7 04 24 00 04 00 00 C7 05 ?? ?? ?? ?? 00 04 00 00 E8 ?? ?? ?? ?? 85 C0 A3 ?? ?? ?? ?? 74 AE BB 00 04 00 00 E9 41 FF FF FF }
	condition:
		$1
}

rule file_1029_2_0 {
	meta:
		name = "getgrgid"
		size = 268
		refs = "0065 __getgrgid_r 008a realloc 0096 free 009b __libc_errno 00f5 malloc"
	strings:
		$1 = { 55 31 C0 57 B9 01 00 00 00 56 53 83 EC 3C 8B 74 24 50 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 0D ?? ?? ?? ?? 0F 85 E2 00 00 00 A1 ?? ?? ?? ?? 8D 7C 24 2C 8B 1D ?? ?? ?? ?? 85 C0 75 10 E9 A1 00 00 00 8D B6 00 00 00 00 A3 ?? ?? ?? ?? 89 7C 24 10 89 5C 24 0C 89 44 24 08 C7 44 24 04 ?? ?? ?? ?? 89 34 24 E8 ?? ?? ?? ?? 83 F8 22 75 6A 8B 1D ?? ?? ?? ?? 8B 2D ?? ?? ?? ?? 01 DB 89 5C 24 04 89 2C 24 89 1D ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 75 B6 89 2C 24 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 00 00 00 00 65 C7 00 0C 00 00 00 C7 44 24 2C 00 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 83 2D ?? ?? ?? ?? 01 75 50 8B 44 24 2C 83 C4 3C 5B 5E 5F 5D C3 A1 ?? ?? ?? ?? 85 C0 75 D7 EB CD C7 04 24 00 04 00 00 C7 05 ?? ?? ?? ?? 00 04 00 00 E8 ?? ?? ?? ?? 85 C0 A3 ?? ?? ?? ?? 74 AE BB 00 04 00 00 E9 41 FF FF FF }
	condition:
		$1
}

rule file_517_2_0 {
	meta:
		name = "getgrnam"
		size = 268
		refs = "0065 __getgrnam_r 008a realloc 0096 free 009b __libc_errno 00f5 malloc"
	strings:
		$1 = { 55 31 C0 57 B9 01 00 00 00 56 53 83 EC 3C 8B 74 24 50 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 0D ?? ?? ?? ?? 0F 85 E2 00 00 00 A1 ?? ?? ?? ?? 8D 7C 24 2C 8B 1D ?? ?? ?? ?? 85 C0 75 10 E9 A1 00 00 00 8D B6 00 00 00 00 A3 ?? ?? ?? ?? 89 7C 24 10 89 5C 24 0C 89 44 24 08 C7 44 24 04 ?? ?? ?? ?? 89 34 24 E8 ?? ?? ?? ?? 83 F8 22 75 6A 8B 1D ?? ?? ?? ?? 8B 2D ?? ?? ?? ?? 01 DB 89 5C 24 04 89 2C 24 89 1D ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 75 B6 89 2C 24 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 00 00 00 00 65 C7 00 0C 00 00 00 C7 44 24 2C 00 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 83 2D ?? ?? ?? ?? 01 75 50 8B 44 24 2C 83 C4 3C 5B 5E 5F 5D C3 A1 ?? ?? ?? ?? 85 C0 75 D7 EB CD C7 04 24 00 04 00 00 C7 05 ?? ?? ?? ?? 00 04 00 00 E8 ?? ?? ?? ?? 85 C0 A3 ?? ?? ?? ?? 74 AE BB 00 04 00 00 E9 41 FF FF FF }
	condition:
		$1
}

rule file_434_2_0 {
	meta:
		name = "getprotobyname"
		size = 268
		refs = "0065 __getprotobyname_r 008a realloc 0096 free 009b __libc_errno 00f5 malloc"
	strings:
		$1 = { 55 31 C0 57 B9 01 00 00 00 56 53 83 EC 3C 8B 74 24 50 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 0D ?? ?? ?? ?? 0F 85 E2 00 00 00 A1 ?? ?? ?? ?? 8D 7C 24 2C 8B 1D ?? ?? ?? ?? 85 C0 75 10 E9 A1 00 00 00 8D B6 00 00 00 00 A3 ?? ?? ?? ?? 89 7C 24 10 89 5C 24 0C 89 44 24 08 C7 44 24 04 ?? ?? ?? ?? 89 34 24 E8 ?? ?? ?? ?? 83 F8 22 75 6A 8B 1D ?? ?? ?? ?? 8B 2D ?? ?? ?? ?? 01 DB 89 5C 24 04 89 2C 24 89 1D ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 75 B6 89 2C 24 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 00 00 00 00 65 C7 00 0C 00 00 00 C7 44 24 2C 00 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 83 2D ?? ?? ?? ?? 01 75 50 8B 44 24 2C 83 C4 3C 5B 5E 5F 5D C3 A1 ?? ?? ?? ?? 85 C0 75 D7 EB CD C7 04 24 00 04 00 00 C7 05 ?? ?? ?? ?? 00 04 00 00 E8 ?? ?? ?? ?? 85 C0 A3 ?? ?? ?? ?? 74 AE BB 00 04 00 00 E9 41 FF FF FF }
	condition:
		$1
}

rule file_1450_2_0 {
	meta:
		name = "getprotobynumber"
		size = 268
		refs = "0065 __getprotobynumber_r 008a realloc 0096 free 009b __libc_errno 00f5 malloc"
	strings:
		$1 = { 55 31 C0 57 B9 01 00 00 00 56 53 83 EC 3C 8B 74 24 50 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 0D ?? ?? ?? ?? 0F 85 E2 00 00 00 A1 ?? ?? ?? ?? 8D 7C 24 2C 8B 1D ?? ?? ?? ?? 85 C0 75 10 E9 A1 00 00 00 8D B6 00 00 00 00 A3 ?? ?? ?? ?? 89 7C 24 10 89 5C 24 0C 89 44 24 08 C7 44 24 04 ?? ?? ?? ?? 89 34 24 E8 ?? ?? ?? ?? 83 F8 22 75 6A 8B 1D ?? ?? ?? ?? 8B 2D ?? ?? ?? ?? 01 DB 89 5C 24 04 89 2C 24 89 1D ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 75 B6 89 2C 24 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 00 00 00 00 65 C7 00 0C 00 00 00 C7 44 24 2C 00 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 83 2D ?? ?? ?? ?? 01 75 50 8B 44 24 2C 83 C4 3C 5B 5E 5F 5D C3 A1 ?? ?? ?? ?? 85 C0 75 D7 EB CD C7 04 24 00 04 00 00 C7 05 ?? ?? ?? ?? 00 04 00 00 E8 ?? ?? ?? ?? 85 C0 A3 ?? ?? ?? ?? 74 AE BB 00 04 00 00 E9 41 FF FF FF }
	condition:
		$1
}

rule file_303_2_0 {
	meta:
		name = "getpwnam"
		size = 268
		refs = "0065 __getpwnam_r 008a realloc 0096 free 009b __libc_errno 00f5 malloc"
	strings:
		$1 = { 55 31 C0 57 B9 01 00 00 00 56 53 83 EC 3C 8B 74 24 50 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 0D ?? ?? ?? ?? 0F 85 E2 00 00 00 A1 ?? ?? ?? ?? 8D 7C 24 2C 8B 1D ?? ?? ?? ?? 85 C0 75 10 E9 A1 00 00 00 8D B6 00 00 00 00 A3 ?? ?? ?? ?? 89 7C 24 10 89 5C 24 0C 89 44 24 08 C7 44 24 04 ?? ?? ?? ?? 89 34 24 E8 ?? ?? ?? ?? 83 F8 22 75 6A 8B 1D ?? ?? ?? ?? 8B 2D ?? ?? ?? ?? 01 DB 89 5C 24 04 89 2C 24 89 1D ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 75 B6 89 2C 24 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 00 00 00 00 65 C7 00 0C 00 00 00 C7 44 24 2C 00 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 83 2D ?? ?? ?? ?? 01 75 50 8B 44 24 2C 83 C4 3C 5B 5E 5F 5D C3 A1 ?? ?? ?? ?? 85 C0 75 D7 EB CD C7 04 24 00 04 00 00 C7 05 ?? ?? ?? ?? 00 04 00 00 E8 ?? ?? ?? ?? 85 C0 A3 ?? ?? ?? ?? 74 AE BB 00 04 00 00 E9 41 FF FF FF }
	condition:
		$1
}

rule file_1080_2_0 {
	meta:
		name = "getpwuid"
		size = 268
		refs = "0065 __getpwuid_r 008a realloc 0096 free 009b __libc_errno 00f5 malloc"
	strings:
		$1 = { 55 31 C0 57 B9 01 00 00 00 56 53 83 EC 3C 8B 74 24 50 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 0D ?? ?? ?? ?? 0F 85 E2 00 00 00 A1 ?? ?? ?? ?? 8D 7C 24 2C 8B 1D ?? ?? ?? ?? 85 C0 75 10 E9 A1 00 00 00 8D B6 00 00 00 00 A3 ?? ?? ?? ?? 89 7C 24 10 89 5C 24 0C 89 44 24 08 C7 44 24 04 ?? ?? ?? ?? 89 34 24 E8 ?? ?? ?? ?? 83 F8 22 75 6A 8B 1D ?? ?? ?? ?? 8B 2D ?? ?? ?? ?? 01 DB 89 5C 24 04 89 2C 24 89 1D ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 75 B6 89 2C 24 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 00 00 00 00 65 C7 00 0C 00 00 00 C7 44 24 2C 00 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 83 2D ?? ?? ?? ?? 01 75 50 8B 44 24 2C 83 C4 3C 5B 5E 5F 5D C3 A1 ?? ?? ?? ?? 85 C0 75 D7 EB CD C7 04 24 00 04 00 00 C7 05 ?? ?? ?? ?? 00 04 00 00 E8 ?? ?? ?? ?? 85 C0 A3 ?? ?? ?? ?? 74 AE BB 00 04 00 00 E9 41 FF FF FF }
	condition:
		$1
}

rule file_353_2_0 {
	meta:
		name = "getrpcbyname"
		size = 268
		refs = "0065 __getrpcbyname_r 008a realloc 0096 free 009b __libc_errno 00f5 malloc"
	strings:
		$1 = { 55 31 C0 57 B9 01 00 00 00 56 53 83 EC 3C 8B 74 24 50 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 0D ?? ?? ?? ?? 0F 85 E2 00 00 00 A1 ?? ?? ?? ?? 8D 7C 24 2C 8B 1D ?? ?? ?? ?? 85 C0 75 10 E9 A1 00 00 00 8D B6 00 00 00 00 A3 ?? ?? ?? ?? 89 7C 24 10 89 5C 24 0C 89 44 24 08 C7 44 24 04 ?? ?? ?? ?? 89 34 24 E8 ?? ?? ?? ?? 83 F8 22 75 6A 8B 1D ?? ?? ?? ?? 8B 2D ?? ?? ?? ?? 01 DB 89 5C 24 04 89 2C 24 89 1D ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 75 B6 89 2C 24 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 00 00 00 00 65 C7 00 0C 00 00 00 C7 44 24 2C 00 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 83 2D ?? ?? ?? ?? 01 75 50 8B 44 24 2C 83 C4 3C 5B 5E 5F 5D C3 A1 ?? ?? ?? ?? 85 C0 75 D7 EB CD C7 04 24 00 04 00 00 C7 05 ?? ?? ?? ?? 00 04 00 00 E8 ?? ?? ?? ?? 85 C0 A3 ?? ?? ?? ?? 74 AE BB 00 04 00 00 E9 41 FF FF FF }
	condition:
		$1
}

rule file_531_2_0 {
	meta:
		name = "getrpcbynumber"
		size = 268
		refs = "0065 __getrpcbynumber_r 008a realloc 0096 free 009b __libc_errno 00f5 malloc"
	strings:
		$1 = { 55 31 C0 57 B9 01 00 00 00 56 53 83 EC 3C 8B 74 24 50 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 0D ?? ?? ?? ?? 0F 85 E2 00 00 00 A1 ?? ?? ?? ?? 8D 7C 24 2C 8B 1D ?? ?? ?? ?? 85 C0 75 10 E9 A1 00 00 00 8D B6 00 00 00 00 A3 ?? ?? ?? ?? 89 7C 24 10 89 5C 24 0C 89 44 24 08 C7 44 24 04 ?? ?? ?? ?? 89 34 24 E8 ?? ?? ?? ?? 83 F8 22 75 6A 8B 1D ?? ?? ?? ?? 8B 2D ?? ?? ?? ?? 01 DB 89 5C 24 04 89 2C 24 89 1D ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 75 B6 89 2C 24 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 00 00 00 00 65 C7 00 0C 00 00 00 C7 44 24 2C 00 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 83 2D ?? ?? ?? ?? 01 75 50 8B 44 24 2C 83 C4 3C 5B 5E 5F 5D C3 A1 ?? ?? ?? ?? 85 C0 75 D7 EB CD C7 04 24 00 04 00 00 C7 05 ?? ?? ?? ?? 00 04 00 00 E8 ?? ?? ?? ?? 85 C0 A3 ?? ?? ?? ?? 74 AE BB 00 04 00 00 E9 41 FF FF FF }
	condition:
		$1
}

rule file_499_2_0 {
	meta:
		name = "getsgnam"
		size = 268
		refs = "0065 __getsgnam_r 008a realloc 0096 free 009b __libc_errno 00f5 malloc"
	strings:
		$1 = { 55 31 C0 57 B9 01 00 00 00 56 53 83 EC 3C 8B 74 24 50 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 0D ?? ?? ?? ?? 0F 85 E2 00 00 00 A1 ?? ?? ?? ?? 8D 7C 24 2C 8B 1D ?? ?? ?? ?? 85 C0 75 10 E9 A1 00 00 00 8D B6 00 00 00 00 A3 ?? ?? ?? ?? 89 7C 24 10 89 5C 24 0C 89 44 24 08 C7 44 24 04 ?? ?? ?? ?? 89 34 24 E8 ?? ?? ?? ?? 83 F8 22 75 6A 8B 1D ?? ?? ?? ?? 8B 2D ?? ?? ?? ?? 01 DB 89 5C 24 04 89 2C 24 89 1D ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 75 B6 89 2C 24 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 00 00 00 00 65 C7 00 0C 00 00 00 C7 44 24 2C 00 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 83 2D ?? ?? ?? ?? 01 75 50 8B 44 24 2C 83 C4 3C 5B 5E 5F 5D C3 A1 ?? ?? ?? ?? 85 C0 75 D7 EB CD C7 04 24 00 04 00 00 C7 05 ?? ?? ?? ?? 00 04 00 00 E8 ?? ?? ?? ?? 85 C0 A3 ?? ?? ?? ?? 74 AE BB 00 04 00 00 E9 41 FF FF FF }
	condition:
		$1
}

rule file_259_0_0 {
	meta:
		name = "timerfd_settime"
		size = 43
		refs = "0019 _dl_sysinfo 0026 __syscall_error"
	strings:
		$1 = { 56 53 8B 74 24 18 8B 54 24 14 8B 4C 24 10 8B 5C 24 0C B8 45 01 00 00 FF 15 ?? ?? ?? ?? 5B 5E 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_260_0_0 {
	meta:
		name = "init_module"
		size = 49
		refs = "001e _dl_sysinfo 002c __syscall_error"
	strings:
		$1 = { 57 56 53 8B 7C 24 20 8B 74 24 1C 8B 54 24 18 8B 4C 24 14 8B 5C 24 10 B8 80 00 00 00 FF 15 ?? ?? ?? ?? 5B 5E 5F 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_261_0_0 {
	meta:
		name = "print_errno_message"
		size = 61
		refs = "001a __strerror_r 0032 __fxprintf"
	strings:
		$1 = { 81 EC 1C 04 00 00 8D 54 24 10 89 54 24 04 C7 44 24 08 00 04 00 00 89 04 24 E8 ?? ?? ?? ?? C7 44 24 04 ?? ?? ?? ?? C7 04 24 00 00 00 00 89 44 24 08 E8 ?? ?? ?? ?? 81 C4 1C 04 00 00 C3 }
	condition:
		$1
}

rule file_261_1_0 {
	meta:
		name = "error_tail"
		size = 458
		refs = "000d stderr 0028 strlen 008e __mbsrtowcs 00af __vfwprintf 00bd free 00c6 error_message_count 00df __fxprintf 00ec _IO_fflush 014f vfprintf 0169 __libc_alloca_cutoff 0187 realloc 01b3 fputws_unlocked 01c6 exit"
	strings:
		$1 = { 55 89 E5 57 56 53 83 EC 4C 89 45 C8 A1 ?? ?? ?? ?? 89 55 CC 89 4D D4 8B 58 68 85 DB 0F 8E 1B 01 00 00 89 0C 24 31 F6 E8 ?? ?? ?? ?? 8D 7D E0 C6 45 D3 00 8D 58 01 EB 0E 81 FB FE FF FF 7F 0F 87 BF 00 00 00 01 DB 8D 0C 9D 00 00 00 00 81 F9 00 10 00 00 0F 87 09 01 00 00 83 C1 1E 83 E1 F0 29 CC 8D 74 24 1F 83 E6 F0 8B 45 D4 8D 55 DC C7 07 00 00 00 00 C7 47 04 00 00 00 00 89 7C 24 0C 89 5C 24 08 89 54 24 04 89 34 24 89 45 DC E8 ?? ?? ?? ?? 39 C3 74 A2 83 F8 FF 74 68 8B 45 08 89 74 24 04 89 44 24 08 A1 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 80 7D D3 00 74 08 89 34 24 E8 ?? ?? ?? ?? 8B 55 CC 83 05 ?? ?? ?? ?? 01 85 D2 75 64 C7 44 24 04 ?? ?? ?? ?? C7 04 24 00 00 00 00 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 8B 45 C8 85 C0 0F 85 C4 00 00 00 8D 65 F4 5B 5E 5F 5D C3 80 7D D3 00 75 4F 8B 45 08 C7 44 24 04 ?? ?? ?? ?? 89 44 24 08 A1 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 8B 55 CC 83 05 ?? ?? ?? ?? 01 85 D2 74 9C 8B 45 CC E8 85 FE FF FF EB 92 8B 55 08 89 04 24 89 54 24 08 8B 55 D4 89 54 24 04 E8 ?? ?? ?? ?? E9 69 FF FF FF 89 34 24 E8 ?? ?? ?? ?? EB A7 89 0C 24 89 4D C4 E8 ?? ?? ?? ?? 8B 4D C4 85 C0 0F 85 E1 FE FF FF 80 7D D3 00 89 4C 24 04 0F 44 F0 89 34 24 E8 ?? ?? ?? ?? 85 C0 74 0B 89 C6 C6 45 D3 01 E9 CE FE FF FF 89 34 24 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? 89 44 24 04 E8 ?? ?? ?? ?? 8D 65 F4 5B 5E 5F 5D C3 8B 45 C8 89 04 24 E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_261_2_0 {
	meta:
		name = "__error"
		size = 151
		refs = "0002 pthread_setcancelstate 0027 stdout 002f _IO_fflush 0034 error_print_progname 0079 program_invocation_name 0091 __fxprintf"
	strings:
		$1 = { 53 BB ?? ?? ?? ?? 83 EC 28 85 DB C7 44 24 1C 00 00 00 00 74 11 8D 44 24 1C 89 44 24 04 C7 04 24 01 00 00 00 FF D3 A1 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 85 C0 74 3C FF D0 8D 44 24 3C 8B 4C 24 38 89 04 24 8B 54 24 34 8B 44 24 30 E8 DA FD FF FF 85 DB 74 14 8B 44 24 1C C7 44 24 04 00 00 00 00 89 04 24 E8 ?? ?? ?? ?? 83 C4 28 5B C3 90 8D 74 26 00 A1 ?? ?? ?? ?? C7 44 24 04 ?? ?? ?? ?? C7 04 24 00 00 00 00 89 44 24 08 E8 ?? ?? ?? ?? EB A7 }
	condition:
		$1
}

rule file_261_3_0 {
	meta:
		name = "__error_at_line"
		size = 290
		refs = "0008 error_one_per_line 0031 pthread_setcancelstate 0053 stdout 005b _IO_fflush 0060 error_print_progname 0091 __fxprintf 00f1 strcmp 0101 program_invocation_name"
	strings:
		$1 = { 57 56 53 83 EC 20 8B 3D ?? ?? ?? ?? 8B 5C 24 38 8B 74 24 3C 85 FF 74 18 39 35 ?? ?? ?? ?? 0F 84 AC 00 00 00 89 1D ?? ?? ?? ?? 89 35 ?? ?? ?? ?? BF ?? ?? ?? ?? 85 FF C7 44 24 1C 00 00 00 00 74 11 8D 44 24 1C 89 44 24 04 C7 04 24 01 00 00 00 FF D7 A1 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 85 C0 0F 84 94 00 00 00 FF D0 85 DB BA ?? ?? ?? ?? B8 ?? ?? ?? ?? 0F 44 C2 89 74 24 0C 89 5C 24 08 89 44 24 04 C7 04 24 00 00 00 00 E8 ?? ?? ?? ?? 8D 44 24 44 8B 4C 24 40 89 04 24 8B 54 24 34 8B 44 24 30 E8 E3 FC FF FF 85 FF 74 14 8B 44 24 1C C7 44 24 04 00 00 00 00 89 04 24 E8 ?? ?? ?? ?? 83 C4 20 5B 5E 5F C3 8D 74 26 00 A1 ?? ?? ?? ?? 39 C3 74 EC 85 C0 0F 84 43 FF FF FF 85 DB 0F 84 3B FF FF FF 89 5C 24 04 89 04 24 E8 ?? ?? ?? ?? 85 C0 74 CC E9 26 FF FF FF 66 90 A1 ?? ?? ?? ?? C7 44 24 04 ?? ?? ?? ?? C7 04 24 00 00 00 00 89 44 24 08 E8 ?? ?? ?? ?? E9 4C FF FF FF }
	condition:
		$1
}

rule file_262_0_0 {
	meta:
		name = "__sched_getparam"
		size = 35
		refs = "0011 _dl_sysinfo 001e __syscall_error"
	strings:
		$1 = { 89 DA 8B 4C 24 08 8B 5C 24 04 B8 9B 00 00 00 FF 15 ?? ?? ?? ?? 89 D3 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_263_0_0 {
	meta:
		name = "object_compare"
		size = 146
	strings:
		$1 = { 83 EC 0C 31 C0 8B 4C 24 10 8B 54 24 14 89 1C 24 89 74 24 04 8B 71 08 8B 5A 08 89 7C 24 08 39 DE 0F 92 C3 0F 97 C0 0F B6 DB 29 D8 75 1E 8B 31 B8 01 00 00 00 8B 49 04 8B 3A 8B 52 04 39 D1 76 28 39 D1 BB 01 00 00 00 73 17 29 D8 8B 1C 24 8B 74 24 04 8B 7C 24 08 83 C4 0C C3 8D B6 00 00 00 00 76 1E 31 DB EB E3 66 90 90 8D B4 26 00 00 00 00 73 16 31 C0 39 D1 BB 01 00 00 00 72 CC EB E1 90 39 FE 72 C5 31 DB EB C1 39 FE 77 B4 8D 74 26 00 EB E0 }
	condition:
		$1
}

rule file_263_1_0 {
	meta:
		name = "add_object.isra.1"
		size = 103
		refs = "001d malloc 0047 __tsearch"
	strings:
		$1 = { 83 EC 1C C7 04 24 0C 00 00 00 89 5C 24 10 89 C3 89 74 24 14 89 D6 89 7C 24 18 89 CF E8 ?? ?? ?? ?? 85 C0 74 3B 8B 16 83 C3 30 8B 4E 04 89 10 8B 17 89 48 04 89 50 08 C7 44 24 08 ?? ?? ?? ?? 89 5C 24 04 89 04 24 E8 ?? ?? ?? ?? 83 F8 01 19 C0 8B 5C 24 10 8B 74 24 14 8B 7C 24 18 83 C4 1C C3 B8 FF FF FF FF EB E9 }
	condition:
		$1
}

rule file_263_2_0 {
	meta:
		name = "process_entry"
		size = 765
		refs = "0041 mempcpy 007d __fxstatat 00f8 realloc 0151 __tfind 01b3 __lxstat 01c1 __libc_errno 0241 __xstat"
	strings:
		$1 = { 55 89 D5 57 56 89 CE 53 89 C3 81 EC AC 00 00 00 80 39 2E 8B BC 24 C0 00 00 00 0F 84 50 01 00 00 8B 53 14 8D 44 3A 02 3B 43 10 0F 87 B8 00 00 00 8B 43 0C 01 C2 89 14 24 89 7C 24 08 89 74 24 04 E8 ?? ?? ?? ?? C6 00 00 8B 55 04 8B 43 1C 83 FA FF 0F 84 39 01 00 00 83 E0 01 F7 D8 25 00 01 00 00 8D 7C 24 48 89 44 24 10 89 7C 24 0C 89 74 24 08 89 54 24 04 C7 04 24 03 00 00 00 E8 ?? ?? ?? ?? 85 C0 0F 88 37 01 00 00 8B 44 24 58 B9 01 00 00 00 8B 53 1C 25 00 F0 00 00 3D 00 40 00 00 74 0E 3D 00 A0 00 00 B9 04 00 00 00 74 02 31 C9 F6 C2 02 74 5C 8B 44 24 48 8B 74 24 4C 33 73 2C 89 44 24 2C 8B 43 28 31 44 24 2C 31 C0 0B 74 24 2C 74 3E 8D B6 00 00 00 00 81 C4 AC 00 00 00 5B 5E 5F 5D C2 08 00 8D 76 00 01 C0 89 43 10 89 44 24 04 8B 43 0C 89 04 24 E8 ?? ?? ?? ?? 85 C0 0F 84 EF 01 00 00 89 43 0C 8B 53 14 E9 24 FF FF FF 90 83 F9 01 0F 85 A7 01 00 00 83 E2 01 0F 85 8E 01 00 00 8B 44 24 48 8B 54 24 4C C7 44 24 08 ?? ?? ?? ?? 89 44 24 3C 8B 44 24 54 89 54 24 40 89 44 24 44 8D 43 30 89 44 24 04 8D 44 24 3C 89 04 24 E8 ?? ?? ?? ?? 85 C0 0F 84 3B 01 00 00 8D 76 00 31 C0 81 C4 AC 00 00 00 5B 5E 5F 5D C2 08 00 90 0F B6 41 01 84 C0 74 E8 3C 2E 0F 85 A0 FE FF FF 80 79 02 00 0F 85 96 FE FF FF 31 C0 EB D4 66 90 A8 04 75 03 8B 73 0C 8D 7C 24 48 A8 01 89 7C 24 08 89 74 24 04 C7 04 24 03 00 00 00 0F 84 8E 00 00 00 E8 ?? ?? ?? ?? 85 C0 0F 89 CA FE FF FF 90 A1 ?? ?? ?? ?? 65 8B 10 83 FA 02 74 0E 83 FA 0D B8 FF FF FF FF 0F 85 FD FE FF FF 8B 53 1C F6 C2 01 75 6D 83 BC 24 C4 00 00 00 0A 0F 84 DF 00 00 00 8B 45 04 83 F8 FF 0F 84 DD 00 00 00 C7 44 24 10 00 01 00 00 89 7C 24 0C 89 74 24 08 89 44 24 04 C7 04 24 03 00 00 00 E8 ?? ?? ?? ?? 85 C0 75 2F 8B 44 24 58 25 00 F0 00 00 3D 00 A0 00 00 75 1F 8B 53 1C B9 06 00 00 00 E9 71 FE FF FF 66 90 E8 ?? ?? ?? ?? E9 37 FE FF FF 8D B6 00 00 00 00 BA 0C 00 00 00 8D 43 14 89 44 24 0C 8B 43 20 8B 04 10 89 7C 24 04 89 44 24 08 8B 43 0C 89 04 24 FF 53 24 F6 43 1C 10 0F 84 5B FE FF FF 83 F8 02 0F 84 DA FE FF FF 81 C4 AC 00 00 00 5B 5E 5F 5D C2 08 00 90 8D 74 26 00 8D 4C 24 54 89 FA 89 D8 E8 EB FC FF FF 85 C0 75 CA 8D B4 26 00 00 00 00 89 E9 89 FA 89 D8 E8 45 00 00 00 EB B6 8D 76 00 8D 14 8D 00 00 00 00 EB 8C 8D B4 26 00 00 00 00 B9 06 00 00 00 E9 D5 FD FF FF 89 7C 24 08 89 74 24 04 C7 04 24 03 00 00 00 E8 ?? ?? ?? ?? E9 2A FF FF FF B8 FF FF FF FF E9 DB FD FF FF }
	condition:
		$1
}

rule file_263_3_0 {
	meta:
		name = "ftw_dir"
		size = 1579
		refs = "0049 malloc 0077 strlen 00a9 realloc 00d0 mempcpy 00df __readdir64 012e __closedir 0191 __openat64_nocancel 01ac __fdopendir 01bf _dl_sysinfo 01e1 __opendir 0241 __rawmemchr 02c2 __libc_errno 0394 __fchdir 03e5 free 04ff __chdir 05df __assert_fail"
	strings:
		$1 = { 55 89 C5 57 56 53 83 EC 4C 8B 40 14 C7 44 24 1C 00 00 00 00 89 54 24 28 8B 55 04 89 4C 24 20 89 44 24 24 89 C8 83 C0 04 85 C9 0F 44 44 24 1C 89 44 24 1C 8B 45 00 8B 1C 90 85 DB 0F 84 1F 01 00 00 C7 04 24 00 04 00 00 E8 ?? ?? ?? ?? 85 C0 89 44 24 14 0F 84 CF 03 00 00 8B 1B BA 00 04 00 00 89 6C 24 2C 89 D5 89 5C 24 18 31 DB EB 69 66 90 8D 78 13 89 3C 24 E8 ?? ?? ?? ?? 8D 34 18 89 C2 8D 46 02 39 E8 72 36 8D 04 12 B9 00 04 00 00 3D 00 04 00 00 0F 42 C1 01 C5 8B 44 24 14 89 6C 24 04 89 54 24 10 89 04 24 E8 ?? ?? ?? ?? 8B 54 24 10 85 C0 0F 84 17 03 00 00 89 44 24 14 03 5C 24 14 89 54 24 08 89 7C 24 04 89 1C 24 8D 5E 01 E8 ?? ?? ?? ?? C6 00 00 8B 54 24 18 89 14 24 E8 ?? ?? ?? ?? 85 C0 75 89 8B 6C 24 2C 8B 44 24 14 C6 04 18 00 8B 55 04 83 C3 01 8B 45 00 8B 34 90 8B 44 24 14 89 5C 24 04 89 04 24 E8 ?? ?? ?? ?? 8B 55 04 89 46 08 8B 45 00 8B 04 90 8B 70 08 85 F6 0F 84 AE 02 00 00 8B 54 24 18 89 14 24 E8 ?? ?? ?? ?? 8B 55 04 8B 45 00 8D 04 90 8B 08 C7 01 00 00 00 00 8B 08 C7 41 04 FF FF FF FF C7 00 00 00 00 00 8B 45 00 8B 1C 90 85 DB 0F 85 A7 04 00 00 8B 4C 24 1C 85 C9 74 68 8B 4C 24 1C 8B 01 83 F8 FF 74 5D C7 44 24 0C 00 00 00 00 C7 44 24 08 00 08 01 00 8B 55 0C 03 55 14 89 04 24 89 54 24 04 E8 ?? ?? ?? ?? C7 44 24 34 00 00 00 00 83 F8 FF 89 C3 0F 84 80 02 00 00 89 04 24 E8 ?? ?? ?? ?? 85 C0 89 44 24 34 75 39 B8 06 00 00 00 FF 15 ?? ?? ?? ?? 8B 44 24 34 EB 20 8D B4 26 00 00 00 00 F6 45 1C 04 8B 45 0C 0F 85 33 02 00 00 89 04 24 E8 ?? ?? ?? ?? 89 44 24 34 85 C0 0F 84 37 02 00 00 8B 00 8D 5C 24 34 8B 55 00 C7 44 24 3C 00 00 00 00 89 44 24 38 8B 45 04 89 1C 82 83 C0 01 3B 45 08 89 45 04 0F 84 F5 02 00 00 8B 45 1C A8 08 0F 84 3A 02 00 00 A8 04 0F 85 62 02 00 00 8B 75 0C 83 45 18 01 C7 44 24 04 00 00 00 00 89 34 24 E8 ?? ?? ?? ?? 39 C6 0F 84 72 03 00 00 80 78 FF 2F 74 09 C6 00 2F 8B 75 0C 83 C0 01 29 F0 89 45 14 8D B4 26 00 00 00 00 8B 54 24 34 85 D2 0F 84 A8 02 00 00 89 14 24 E8 ?? ?? ?? ?? 85 C0 89 C6 0F 84 03 03 00 00 8D 7E 13 89 3C 24 E8 ?? ?? ?? ?? 0F B6 56 12 89 F9 89 54 24 04 89 DA 89 04 24 89 E8 E8 59 FA FF FF 83 EC 08 85 C0 74 BA 89 C7 8B 44 24 34 85 C0 0F 84 F6 02 00 00 8B 54 24 3C 8B 1D ?? ?? ?? ?? 85 D2 65 8B 33 0F 85 12 03 00 00 89 04 24 E8 ?? ?? ?? ?? 8B 55 04 C7 44 24 38 FF FF FF FF 65 89 33 8D 42 FF 85 D2 89 45 04 0F 84 0B 01 00 00 8B 55 00 C7 04 82 00 00 00 00 F6 45 1C 10 0F 84 A7 00 00 00 83 FF 03 0F 85 9E 00 00 00 8B 45 14 8B 55 0C C6 44 02 FF 00 8B 44 24 24 83 6D 18 01 89 45 14 31 FF F6 45 1C 08 74 28 8B 54 24 28 8D 45 14 89 44 24 0C C7 44 24 08 05 00 00 00 89 54 24 04 8B 45 0C 89 04 24 FF 55 24 89 C7 8D B6 00 00 00 00 8B 44 24 20 85 C0 74 40 8B 45 1C A8 04 74 39 85 FF 74 15 A8 10 74 31 83 FF 01 74 2C 83 FF FF 74 27 8D B4 26 00 00 00 00 8B 4C 24 20 8B 01 85 C0 0F 84 5F 01 00 00 8B 00 89 04 24 E8 ?? ?? ?? ?? 85 C0 0F 85 4D 01 00 00 83 C4 4C 89 F8 5B 5E 5F 5D C3 8D B6 00 00 00 00 8B 45 14 8B 55 0C C6 44 02 FF 00 8B 4C 24 24 83 6D 18 01 85 FF 89 4D 14 75 8E E9 59 FF FF FF 90 8B 6C 24 2C 8B 1D ?? ?? ?? ?? 8B 44 24 14 65 8B 33 89 04 24 E8 ?? ?? ?? ?? 83 FE 0D 65 89 33 74 44 83 C4 4C BF FF FF FF FF 5B 89 F8 5E 5F 5D C3 8B 45 08 83 E8 01 89 45 04 E9 E7 FE FF FF 66 90 03 45 14 BA ?? ?? ?? ?? 80 38 00 0F 44 C2 E9 BA FD FF FF 90 8D 74 26 00 A1 ?? ?? ?? ?? 65 8B 30 83 FE 0D 75 BC 8B 54 24 28 8D 45 14 89 44 24 0C C7 44 24 08 02 00 00 00 89 54 24 04 8B 45 0C 89 04 24 FF 55 24 89 C7 E9 44 FF FF FF 8D 74 26 00 8B 54 24 28 8D 45 14 89 44 24 0C C7 44 24 08 01 00 00 00 89 54 24 04 8B 45 0C 89 04 24 FF 55 24 85 C0 89 C7 75 25 8B 45 1C E9 98 FD FF FF 66 90 8B 44 24 34 8B 00 89 04 24 E8 ?? ?? ?? ?? 85 C0 0F 89 88 FD FF FF BF FF FF FF FF 8B 1D ?? ?? ?? ?? 8B 44 24 34 65 8B 33 89 04 24 E8 ?? ?? ?? ?? 8B 55 04 65 89 33 8D 42 FF 85 D2 89 45 04 75 09 8B 45 08 83 E8 01 89 45 04 8B 55 00 C7 04 82 00 00 00 00 83 C4 4C 89 F8 5B 5E 5F 5D C3 83 7D 14 01 0F 84 99 00 00 00 C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 0F 89 95 FE FF FF E9 E1 FE FF FF C7 45 04 00 00 00 00 E9 FF FC FF FF 8B 4C 24 3C 80 39 00 0F 84 80 00 00 00 89 CE EB 09 8D 76 00 80 7F 01 00 74 34 89 34 24 C7 44 24 04 00 00 00 00 E8 ?? ?? ?? ?? 89 F1 89 DA C7 44 24 04 00 00 00 00 89 C7 29 F0 89 04 24 89 E8 E8 A0 F7 FF FF 8D 77 01 83 EC 08 85 C0 74 C6 8B 4C 24 3C 89 C7 8B 1D ?? ?? ?? ?? 65 8B 33 89 0C 24 E8 ?? ?? ?? ?? 65 89 33 E9 76 FD FF FF 31 FF E9 20 FD FF FF C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 0F 89 FC FD FF FF E9 48 FE FF FF 31 FF 90 8D 74 26 00 EB BE 85 FF 8B 4C 24 3C 75 B6 E9 61 FF FF FF C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 1A 02 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 2C 02 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 52 01 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_263_4_0 {
	meta:
		name = "ftw_startup"
		size = 1234
		refs = "0064 memset 006c strlen 0089 malloc 00a9 stpcpy 0129 __libc_errno 015d __lxstat 0187 __xstat 0286 __chdir 0294 free 02b8 __open 0361 __fchdir 036c _dl_sysinfo 0388 __tdestroy 03d5 __getcwd"
	strings:
		$1 = { 55 89 E5 57 56 89 D6 53 81 EC BC 00 00 00 8B 55 08 80 38 00 0F 84 21 04 00 00 85 D2 89 C3 B8 01 00 00 00 89 CF 0F 4F C2 8D 0C 85 00 00 00 00 8D 51 1E 83 E2 F0 29 D4 89 85 64 FF FF FF 8D 44 24 1F 83 E0 F0 89 4C 24 08 C7 44 24 04 00 00 00 00 89 04 24 C7 85 60 FF FF FF 00 00 00 00 89 85 5C FF FF FF E8 ?? ?? ?? ?? 89 1C 24 E8 ?? ?? ?? ?? BA 00 10 00 00 01 C0 3D 00 10 00 00 0F 43 D0 89 14 24 89 95 6C FF FF FF E8 ?? ?? ?? ?? 85 C0 89 85 68 FF FF FF 0F 84 2D 04 00 00 89 5C 24 04 89 04 24 89 85 48 FF FF FF E8 ?? ?? ?? ?? 8B 8D 48 FF FF FF 89 C2 8D 41 01 39 C2 77 0B EB 0F 66 90 83 EA 01 39 C2 74 06 80 7A FF 2F 74 F3 39 D1 C6 02 00 C7 85 74 FF FF FF 00 00 00 00 72 09 EB 0D 83 EA 01 39 CA 74 06 80 7A FF 2F 75 F3 8B 45 0C 29 CA 85 F6 89 95 70 FF FF FF BA ?? ?? ?? ?? 89 7D 80 C7 45 8C 00 00 00 00 89 85 78 FF FF FF B8 ?? ?? ?? ?? 0F 44 C2 F6 45 0C 04 89 85 7C FF FF FF 0F 85 81 01 00 00 8B 3D ?? ?? ?? ?? BB FF FF FF FF C7 85 50 FF FF FF 00 00 00 00 8B 75 0C 8D 45 90 89 85 4C FF FF FF 89 44 24 08 89 4C 24 04 83 E6 01 C7 04 24 03 00 00 00 74 24 E8 ?? ?? ?? ?? 85 C0 0F 89 87 00 00 00 65 8B 07 BE FF FF FF FF 89 85 54 FF FF FF E9 D1 00 00 00 8D 74 26 00 89 8D 48 FF FF FF E8 ?? ?? ?? ?? 8B 8D 48 FF FF FF 85 C0 79 5B 65 8B 07 BE FF FF FF FF 83 F8 02 89 85 54 FF FF FF 0F 85 A1 00 00 00 8B 85 4C FF FF FF 89 4C 24 04 C7 04 24 03 00 00 00 89 44 24 08 E8 ?? ?? ?? ?? 85 C0 75 7A 8B 45 A0 25 00 F0 00 00 3D 00 A0 00 00 75 6B 8D 85 70 FF FF FF 89 44 24 0C 8B 85 7C FF FF FF 8B 40 18 EB 3A 66 90 8B 45 A0 25 00 F0 00 00 3D 00 40 00 00 0F 84 F5 01 00 00 3D 00 A0 00 00 BA 10 00 00 00 B8 00 00 00 00 0F 45 D0 8D 85 70 FF FF FF 89 44 24 0C 8B 85 7C FF FF FF 8B 04 10 89 44 24 08 8B 85 4C FF FF FF 89 44 24 04 8B 85 68 FF FF FF 89 04 24 FF 55 80 89 C6 65 8B 07 89 85 54 FF FF FF F6 45 0C 10 0F 84 FD 00 00 00 8D 46 FE 83 F8 01 B8 00 00 00 00 0F 46 F0 83 FB FF 0F 85 EF 00 00 00 8B 85 50 FF FF FF 85 C0 0F 84 FD 00 00 00 8B 85 50 FF FF FF 89 04 24 E8 ?? ?? ?? ?? 8B 85 50 FF FF FF 89 04 24 E8 ?? ?? ?? ?? 8B 85 54 FF FF FF 65 89 07 E9 D3 00 00 00 66 90 C7 44 24 04 00 00 01 00 C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 F8 FF 89 C3 0F 84 E8 00 00 00 8B 85 64 FF FF FF 83 F8 01 0F 86 A8 01 00 00 8B 3D ?? ?? ?? ?? 83 E8 01 89 85 64 FF FF FF C7 85 50 FF FF FF 00 00 00 00 8B 85 70 FF FF FF 85 C0 0F 8E 54 01 00 00 83 F8 01 0F 84 8D 01 00 00 8B 95 68 FF FF FF 8D 44 02 FF 0F B6 08 C6 00 00 8B 85 68 FF FF FF 88 8D 48 FF FF FF 89 04 24 E8 ?? ?? ?? ?? 8B 95 68 FF FF FF 0F B6 8D 48 FF FF FF 89 C6 8B 85 70 FF FF FF 88 4C 02 FF 85 F6 0F 84 06 01 00 00 65 8B 07 89 85 54 FF FF FF 83 FB FF 0F 84 11 FF FF FF 89 1C 24 E8 ?? ?? ?? ?? B8 06 00 00 00 FF 15 ?? ?? ?? ?? 8B 85 54 FF FF FF 65 89 07 8B 45 8C C7 44 24 04 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 8B 85 68 FF FF FF 89 04 24 E8 ?? ?? ?? ?? 8B 85 54 FF FF FF 65 89 07 8D 65 F4 89 F0 5B 5E 5F 5D C2 08 00 8B 3D ?? ?? ?? ?? 31 F6 65 8B 07 83 F8 0D 89 85 54 FF FF FF 75 B4 C7 44 24 04 00 00 00 00 C7 04 24 00 00 00 00 E8 ?? ?? ?? ?? 85 C0 89 85 50 FF FF FF 0F 85 08 FF FF FF 65 8B 07 89 85 54 FF FF FF EB 87 8D B6 00 00 00 00 8B 45 90 85 F6 8B 55 94 89 45 84 8D 85 5C FF FF FF 89 55 88 89 85 54 FF FF FF 0F 84 8E 00 00 00 8B 95 4C FF FF FF 31 C9 8B 85 54 FF FF FF E8 A5 F5 FF FF 89 C6 65 8B 07 89 85 54 FF FF FF E9 12 FE FF FF A1 ?? ?? ?? ?? BE FF FF FF FF 65 C7 00 02 00 00 00 E9 52 FF FF FF 8B 85 78 FF FF FF 8B 8D 68 FF FF FF 83 E0 04 85 C0 0F 84 D4 FC FF FF 03 8D 70 FF FF FF B8 ?? ?? ?? ?? 80 39 00 0F 44 C8 E9 BE FC FF FF C7 85 50 FF FF FF 00 00 00 00 8B 3D ?? ?? ?? ?? E9 5C FE FF FF C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 C6 E9 9D FE FF FF 8B 95 4C FF FF FF 8D 4D 9C E8 AC F1 FF FF 85 C0 89 C6 0F 85 86 FD FF FF E9 55 FF FF FF 90 8D 74 26 00 BE FF FF FF FF E9 D1 FE FF FF }
	condition:
		$1
}

rule file_263_5_0 {
	meta:
		name = "ftw"
		size = 40
		altNames = "ftw64"
	strings:
		$1 = { 83 EC 1C 31 D2 8B 44 24 28 8B 4C 24 24 C7 44 24 04 00 00 00 00 89 04 24 8B 44 24 20 E8 FF FA FF FF 83 EC 08 83 C4 1C C3 }
	condition:
		$1
}

rule file_263_6_0 {
	meta:
		name = "__new_nftw"
		size = 75
		refs = "0039 __libc_errno"
		altNames = "__new_nftw64"
	strings:
		$1 = { 83 EC 1C 8B 44 24 2C A9 E0 FF FF FF 75 2A 89 44 24 04 8B 44 24 28 BA 01 00 00 00 8B 4C 24 24 89 04 24 8B 44 24 20 E8 C5 FA FF FF 83 EC 08 83 C4 1C C3 8D B6 00 00 00 00 A1 ?? ?? ?? ?? 65 C7 00 16 00 00 00 B8 FF FF FF FF EB E3 }
	condition:
		$1
}

rule file_264_0_0 {
	meta:
		name = "pmap_getmaps"
		size = 266
		refs = "0024 __get_socket 005a clnttcp_create 0083 xdr_pmaplist 0093 xdr_void 00be __close_nocancel 00f3 _libc_intl_domainname 00f8 __dcgettext 0104 clnt_perror"
	strings:
		$1 = { 83 EC 3C 89 5C 24 30 8B 5C 24 40 89 7C 24 38 89 74 24 34 C7 44 24 28 00 00 00 00 66 C7 43 02 00 6F 89 D8 E8 ?? ?? ?? ?? C7 44 24 14 F4 01 00 00 C7 44 24 10 32 00 00 00 C7 44 24 08 02 00 00 00 C7 44 24 04 A0 86 01 00 89 1C 24 89 44 24 2C 89 C7 8D 44 24 2C 89 44 24 0C E8 ?? ?? ?? ?? 85 C0 74 4F 89 C6 8B 40 04 8D 54 24 28 C7 44 24 18 3C 00 00 00 C7 44 24 1C 00 00 00 00 89 54 24 14 C7 44 24 10 ?? ?? ?? ?? C7 44 24 0C 00 00 00 00 C7 44 24 08 ?? ?? ?? ?? C7 44 24 04 04 00 00 00 89 34 24 FF 10 85 C0 75 38 8B 46 04 89 34 24 FF 50 10 83 FF FF 74 0C 8B 44 24 2C 89 04 24 E8 ?? ?? ?? ?? 66 C7 43 02 00 00 8B 44 24 28 8B 5C 24 30 8B 74 24 34 8B 7C 24 38 83 C4 3C C3 8D 74 26 00 C7 44 24 08 05 00 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 34 24 89 44 24 04 E8 ?? ?? ?? ?? EB 9E }
	condition:
		$1
}

rule file_265_0_0 {
	meta:
		name = "fputws_unlocked"
		size = 125
		refs = "001b __wcslen 002d _IO_fwide"
	strings:
		$1 = { 83 EC 1C 89 74 24 14 8B 74 24 20 89 5C 24 10 8B 5C 24 24 89 7C 24 18 89 34 24 E8 ?? ?? ?? ?? C7 44 24 04 01 00 00 00 89 1C 24 89 C7 E8 ?? ?? ?? ?? 83 F8 01 75 32 8B 83 94 00 00 00 89 7C 24 08 89 74 24 04 89 1C 24 FF 50 1C 39 F8 75 1A B8 01 00 00 00 8B 5C 24 10 8B 74 24 14 8B 7C 24 18 83 C4 1C C3 90 8D 74 26 00 B8 FF FF FF FF 8B 5C 24 10 8B 74 24 14 8B 7C 24 18 83 C4 1C C3 }
	condition:
		$1
}

rule file_266_1_0 {
	meta:
		name = "updwtmp_file"
		size = 559
		refs = "001d __open_nocancel 0033 alarm 0081 __sigaction 00c8 __fcntl_nocancel 00f0 __lseek64 0114 __moddi3 013b __write_nocancel 015f __ftruncate64 01b1 _dl_sysinfo"
	strings:
		$1 = { 55 57 56 53 81 EC 5C 01 00 00 8B 84 24 70 01 00 00 C7 44 24 04 01 80 00 00 89 04 24 E8 ?? ?? ?? ?? 85 C0 0F 88 FF 01 00 00 C7 04 24 00 00 00 00 89 C3 E8 ?? ?? ?? ?? 8D 74 24 3C B9 20 00 00 00 89 F7 8D 54 24 38 8D B4 24 C4 00 00 00 C7 44 24 38 ?? ?? ?? ?? 8D 6C 24 28 C7 84 24 BC 00 00 00 00 00 00 00 89 44 24 14 31 C0 F3 AB BF FF FF FF FF 89 54 24 04 89 74 24 08 C7 04 24 0E 00 00 00 E8 ?? ?? ?? ?? C7 04 24 0A 00 00 00 E8 ?? ?? ?? ?? 89 6C 24 08 C7 44 24 04 07 00 00 00 89 1C 24 C7 44 24 28 00 00 00 00 C7 44 24 2C 00 00 00 00 C7 44 24 30 00 00 00 00 C7 44 24 34 00 00 00 00 66 C7 44 24 28 01 00 E8 ?? ?? ?? ?? 85 C0 0F 88 AA 00 00 00 C7 44 24 0C 02 00 00 00 C7 44 24 04 00 00 00 00 C7 44 24 08 00 00 00 00 89 1C 24 E8 ?? ?? ?? ?? C7 44 24 08 80 01 00 00 C7 44 24 0C 00 00 00 00 89 04 24 89 54 24 04 89 44 24 18 89 54 24 1C E8 ?? ?? ?? ?? 89 D1 09 C1 0F 85 A6 00 00 00 8B 84 24 74 01 00 00 31 FF C7 44 24 08 80 01 00 00 89 1C 24 89 44 24 04 E8 ?? ?? ?? ?? 3D 80 01 00 00 74 1D 8B 54 24 18 BF FF FF FF FF 8B 4C 24 1C 89 1C 24 89 54 24 04 89 4C 24 08 E8 ?? ?? ?? ?? 89 6C 24 08 C7 44 24 04 07 00 00 00 89 1C 24 66 C7 44 24 28 02 00 E8 ?? ?? ?? ?? C7 04 24 00 00 00 00 E8 ?? ?? ?? ?? C7 44 24 08 00 00 00 00 89 74 24 04 C7 04 24 0E 00 00 00 E8 ?? ?? ?? ?? 8B 44 24 14 85 C0 75 6E B8 06 00 00 00 FF 15 ?? ?? ?? ?? 81 C4 5C 01 00 00 89 F8 5B 5E 5F 5D C3 8D B6 00 00 00 00 29 44 24 18 19 54 24 1C 8B 54 24 1C 8B 44 24 18 89 1C 24 89 54 24 08 89 44 24 04 E8 ?? ?? ?? ?? C7 44 24 0C 02 00 00 00 C7 44 24 04 00 00 00 00 C7 44 24 08 00 00 00 00 89 1C 24 E8 ?? ?? ?? ?? 85 D2 0F 89 12 FF FF FF E9 4E FF FF FF 8D 76 00 8B 44 24 14 89 04 24 E8 ?? ?? ?? ?? EB 84 66 90 BF FF FF FF FF EB 86 }
	condition:
		$1
}

rule file_266_2_0 {
	meta:
		name = "setutent_file"
		size = 580
		refs = "0034 __lseek64 0072 __libc_utmp_file_name 00d9 __open_nocancel 00ed __have_o_cloexec 010d __fcntl_nocancel 0158 __access 0239 _dl_sysinfo"
	strings:
		$1 = { 83 EC 1C A1 ?? ?? ?? ?? 89 5C 24 10 89 74 24 14 89 7C 24 18 85 C0 78 58 C7 44 24 0C 00 00 00 00 C7 44 24 04 00 00 00 00 C7 44 24 08 00 00 00 00 89 04 24 E8 ?? ?? ?? ?? B8 01 00 00 00 C7 05 ?? ?? ?? ?? 00 00 00 00 C7 05 ?? ?? ?? ?? 00 00 00 00 66 C7 05 ?? ?? ?? ?? FF FF 8B 5C 24 10 8B 74 24 14 8B 7C 24 18 83 C4 1C C3 8D B6 00 00 00 00 8B 15 ?? ?? ?? ?? B9 0E 00 00 00 BF ?? ?? ?? ?? 89 D6 F3 A6 0F 84 BE 00 00 00 B9 0E 00 00 00 BF ?? ?? ?? ?? 89 D6 F3 A6 0F 84 DA 00 00 00 BF ?? ?? ?? ?? B9 0F 00 00 00 89 D6 F3 A6 0F 84 F6 00 00 00 BF ?? ?? ?? ?? B9 0F 00 00 00 89 D6 F3 A6 0F 84 1A 01 00 00 C7 44 24 04 00 80 08 00 89 14 24 C6 05 ?? ?? ?? ?? 00 E8 ?? ?? ?? ?? 83 F8 FF A3 ?? ?? ?? ?? 0F 84 ED 00 00 00 8B 15 ?? ?? ?? ?? 85 D2 0F 8F 1F FF FF FF C7 44 24 08 00 00 00 00 C7 44 24 04 01 00 00 00 89 04 24 E8 ?? ?? ?? ?? 85 C0 0F 88 0A 01 00 00 8B 15 ?? ?? ?? ?? 85 D2 75 13 89 C2 83 E2 01 83 FA 01 19 D2 83 CA 01 89 15 ?? ?? ?? ?? 85 D2 0F 88 C9 00 00 00 A1 ?? ?? ?? ?? E9 D0 FE FF FF C7 44 24 04 00 00 00 00 C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? BA ?? ?? ?? ?? 85 C0 0F 84 5D FF FF FF 8B 15 ?? ?? ?? ?? E9 16 FF FF FF 8D 74 26 00 C7 44 24 04 00 00 00 00 C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? BA ?? ?? ?? ?? 85 C0 0F 84 2D FF FF FF 8B 15 ?? ?? ?? ?? E9 FA FE FF FF 8D 74 26 00 C7 44 24 04 00 00 00 00 C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? BA ?? ?? ?? ?? 85 C0 0F 85 FD FE FF FF 8B 15 ?? ?? ?? ?? E9 DE FE FF FF 8D 74 26 00 31 C0 E9 7B FE FF FF 90 C7 44 24 04 00 00 00 00 C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? BA ?? ?? ?? ?? 85 C0 0F 44 15 ?? ?? ?? ?? E9 BF FE FF FF 83 C8 01 89 44 24 08 A1 ?? ?? ?? ?? C7 44 24 04 02 00 00 00 89 04 24 E8 ?? ?? ?? ?? 83 F8 FF 0F 85 12 FF FF FF 8B 1D ?? ?? ?? ?? B8 06 00 00 00 FF 15 ?? ?? ?? ?? 31 C0 E9 16 FE FF FF }
	condition:
		$1
}

rule file_266_3_0 {
	meta:
		name = "__utmp_equal"
		size = 133
		refs = "0040 strncmp"
	strings:
		$1 = { 53 83 EC 18 0F B7 08 83 E9 05 66 83 F9 03 77 40 0F B7 0A 31 DB 83 E9 05 66 83 F9 03 77 2A 80 78 28 00 74 3C 80 7A 28 00 74 36 83 C2 28 83 C0 28 C7 44 24 08 04 00 00 00 89 54 24 04 89 04 24 E8 ?? ?? ?? ?? 85 C0 74 36 83 C4 18 89 D8 5B C3 90 31 DB 83 C4 18 89 D8 5B C3 8D B4 26 00 00 00 00 83 C2 08 83 C0 08 C7 44 24 08 20 00 00 00 89 54 24 04 89 04 24 E8 ?? ?? ?? ?? 85 C0 75 D2 BB 01 00 00 00 EB C3 }
	condition:
		$1
}

rule file_266_4_0 {
	meta:
		name = "internal_getut_r"
		size = 515
		refs = "001e alarm 0063 __sigaction 00a8 __fcntl_nocancel 00ed __read_nocancel 01c9 __libc_errno"
	strings:
		$1 = { 55 57 56 89 C6 53 89 D3 81 EC 5C 01 00 00 C7 04 24 00 00 00 00 8D 6C 24 38 89 4C 24 1C E8 ?? ?? ?? ?? 8D 54 24 3C B9 20 00 00 00 89 D7 C7 44 24 38 ?? ?? ?? ?? C7 84 24 BC 00 00 00 00 00 00 00 89 44 24 18 31 C0 F3 AB 8D BC 24 C4 00 00 00 89 6C 24 04 8D 6C 24 28 89 7C 24 08 C7 04 24 0E 00 00 00 E8 ?? ?? ?? ?? C7 04 24 0A 00 00 00 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 89 6C 24 08 C7 44 24 04 07 00 00 00 C7 44 24 28 00 00 00 00 89 04 24 C7 44 24 2C 00 00 00 00 C7 44 24 30 00 00 00 00 C7 44 24 34 00 00 00 00 E8 ?? ?? ?? ?? 85 C0 0F 88 3E 01 00 00 0F B7 06 8D 50 FF 66 83 FA 01 0F 86 C4 00 00 00 66 83 F8 04 0F 84 BA 00 00 00 66 83 F8 03 0F 84 B0 00 00 00 A1 ?? ?? ?? ?? C7 44 24 08 80 01 00 00 89 5C 24 04 89 04 24 E8 ?? ?? ?? ?? 3D 80 01 00 00 0F 85 CC 00 00 00 81 05 ?? ?? ?? ?? 80 01 00 00 89 F2 89 D8 83 15 ?? ?? ?? ?? 00 E8 5A FE FF FF 85 C0 74 BE 31 DB A1 ?? ?? ?? ?? 89 6C 24 08 C7 44 24 04 07 00 00 00 66 C7 44 24 28 02 00 89 04 24 E8 ?? ?? ?? ?? C7 04 24 00 00 00 00 E8 ?? ?? ?? ?? C7 44 24 08 00 00 00 00 89 7C 24 04 C7 04 24 0E 00 00 00 E8 ?? ?? ?? ?? 8B 4C 24 18 85 C9 74 0C 8B 44 24 18 89 04 24 E8 ?? ?? ?? ?? 81 C4 5C 01 00 00 89 D8 5B 5E 5F 5D C3 8D B4 26 00 00 00 00 A1 ?? ?? ?? ?? C7 44 24 08 80 01 00 00 89 5C 24 04 89 04 24 E8 ?? ?? ?? ?? 3D 80 01 00 00 75 20 81 05 ?? ?? ?? ?? 80 01 00 00 0F B7 03 83 15 ?? ?? ?? ?? 00 66 39 06 75 C7 E9 54 FF FF FF 66 90 A1 ?? ?? ?? ?? BB FF FF FF FF C7 05 ?? ?? ?? ?? FF FF FF FF C7 05 ?? ?? ?? ?? FF FF FF FF 65 C7 00 03 00 00 00 E9 2A FF FF FF 8B 44 24 1C BB FF FF FF FF C6 00 01 E9 39 FF FF FF }
	condition:
		$1
}

rule file_266_5_0 {
	meta:
		name = "pututline_file"
		size = 1726
		refs = "0027 __libc_utmp_file_name 0087 __open_nocancel 0098 __have_o_cloexec 00c5 __lseek64 00f9 __dup2 010c _dl_sysinfo 018d alarm 01d6 __sigaction 0222 __fcntl_nocancel 0293 __write_nocancel 0440 __moddi3 0497 __ftruncate64 04c8 __access 06a7 __assert_fail 06ac __libc_errno"
	strings:
		$1 = { 55 57 56 53 81 EC DC 02 00 00 8B 3D ?? ?? ?? ?? 85 FF 0F 88 6F 06 00 00 80 3D ?? ?? ?? ?? 00 0F 85 F2 00 00 00 8B 15 ?? ?? ?? ?? B9 0E 00 00 00 BF ?? ?? ?? ?? 89 D6 F3 A6 0F 84 79 04 00 00 B9 0E 00 00 00 BF ?? ?? ?? ?? 89 D6 F3 A6 0F 84 1D 05 00 00 BF ?? ?? ?? ?? B9 0F 00 00 00 89 D6 F3 A6 0F 84 49 05 00 00 BF ?? ?? ?? ?? B9 0F 00 00 00 89 D6 F3 A6 0F 84 65 05 00 00 C7 44 24 04 02 80 08 00 89 14 24 E8 ?? ?? ?? ?? 83 F8 FF 89 C3 0F 84 EA 05 00 00 8B 35 ?? ?? ?? ?? 85 F6 0F 8E 44 04 00 00 A1 ?? ?? ?? ?? C7 44 24 0C 01 00 00 00 C7 44 24 04 00 00 00 00 C7 44 24 08 00 00 00 00 89 04 24 E8 ?? ?? ?? ?? C7 44 24 0C 00 00 00 00 89 1C 24 89 44 24 04 89 54 24 08 E8 ?? ?? ?? ?? 21 D0 83 F8 FF 0F 84 1C 05 00 00 A1 ?? ?? ?? ?? 89 1C 24 89 44 24 04 E8 ?? ?? ?? ?? 85 C0 0F 88 03 05 00 00 B8 06 00 00 00 FF 15 ?? ?? ?? ?? C6 05 ?? ?? ?? ?? 01 83 3D ?? ?? ?? ?? 00 7C 36 0F 8E 7A 03 00 00 8B 94 24 F0 02 00 00 0F B7 05 ?? ?? ?? ?? 66 3B 02 0F 84 E3 01 00 00 8B 94 24 F0 02 00 00 B8 ?? ?? ?? ?? E8 12 FC FF FF 85 C0 0F 85 DD 01 00 00 8B 84 24 F0 02 00 00 8D 4C 24 27 8D 94 24 50 01 00 00 C6 44 24 27 00 E8 7E FC FF FF 80 7C 24 27 00 89 44 24 18 0F 85 2A 05 00 00 C7 04 24 00 00 00 00 8D 5C 24 3C E8 ?? ?? ?? ?? 89 DF B9 20 00 00 00 8D 54 24 38 8D 9C 24 C4 00 00 00 C7 44 24 38 ?? ?? ?? ?? 8D 74 24 28 C7 84 24 BC 00 00 00 00 00 00 00 89 5C 24 14 89 C5 31 C0 F3 AB 31 FF 89 54 24 04 89 5C 24 08 C7 04 24 0E 00 00 00 E8 ?? ?? ?? ?? C7 04 24 0A 00 00 00 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 89 74 24 08 C7 44 24 04 07 00 00 00 C7 44 24 28 00 00 00 00 89 04 24 C7 44 24 2C 00 00 00 00 C7 44 24 30 00 00 00 00 C7 44 24 34 00 00 00 00 66 C7 44 24 28 01 00 E8 ?? ?? ?? ?? 85 C0 0F 88 9A 00 00 00 8B 5C 24 18 85 DB 0F 88 B6 01 00 00 A1 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? C7 44 24 0C 00 00 00 00 05 80 FE FF FF A3 ?? ?? ?? ?? 83 D2 FF 31 FF 89 44 24 04 A1 ?? ?? ?? ?? 89 54 24 08 89 15 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 8B 8C 24 F0 02 00 00 A1 ?? ?? ?? ?? C7 44 24 08 80 01 00 00 89 4C 24 04 89 04 24 E8 ?? ?? ?? ?? 3D 80 01 00 00 0F 84 2E 01 00 00 8D B6 00 00 00 00 A1 ?? ?? ?? ?? 89 74 24 08 C7 44 24 04 07 00 00 00 66 C7 44 24 28 02 00 89 04 24 E8 ?? ?? ?? ?? C7 04 24 00 00 00 00 E8 ?? ?? ?? ?? 8B 5C 24 14 C7 44 24 08 00 00 00 00 C7 04 24 0E 00 00 00 89 5C 24 04 E8 ?? ?? ?? ?? 85 ED 75 14 81 C4 DC 02 00 00 89 F8 5B 5E 5F 5D C3 8D B4 26 00 00 00 00 89 2C 24 E8 ?? ?? ?? ?? 81 C4 DC 02 00 00 89 F8 5B 5E 5F 5D C3 8D 76 00 8D 50 FF 66 83 FA 01 76 0A 66 83 F8 04 0F 85 6D 02 00 00 C7 04 24 00 00 00 00 8D 5C 24 3C E8 ?? ?? ?? ?? 89 DF B9 20 00 00 00 8D 54 24 38 8D 9C 24 C4 00 00 00 8D 74 24 28 C7 44 24 38 ?? ?? ?? ?? C7 84 24 BC 00 00 00 00 00 00 00 89 C5 31 C0 F3 AB 89 F7 89 54 24 04 89 5C 24 08 C7 04 24 0E 00 00 00 89 5C 24 14 E8 ?? ?? ?? ?? C7 04 24 0A 00 00 00 E8 ?? ?? ?? ?? 31 C0 B9 04 00 00 00 F3 AB A1 ?? ?? ?? ?? 89 74 24 08 C7 44 24 04 07 00 00 00 66 C7 44 24 28 01 00 89 04 24 E8 ?? ?? ?? ?? 85 C0 0F 89 71 FE FF FF 31 FF E9 F8 FE FF FF 81 05 ?? ?? ?? ?? 80 01 00 00 83 15 ?? ?? ?? ?? 00 8B BC 24 F0 02 00 00 E9 BB FE FF FF 8D 76 00 A1 ?? ?? ?? ?? C7 44 24 0C 02 00 00 00 C7 44 24 04 00 00 00 00 C7 44 24 08 00 00 00 00 89 04 24 E8 ?? ?? ?? ?? C7 44 24 08 80 01 00 00 C7 44 24 0C 00 00 00 00 89 04 24 89 54 24 04 89 44 24 18 89 54 24 1C A3 ?? ?? ?? ?? 89 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 D1 09 C1 0F 85 D2 01 00 00 8B 94 24 F0 02 00 00 A1 ?? ?? ?? ?? C7 44 24 08 80 01 00 00 89 54 24 04 89 04 24 E8 ?? ?? ?? ?? 3D 80 01 00 00 0F 84 57 FF FF FF A1 ?? ?? ?? ?? 31 FF 8B 15 ?? ?? ?? ?? 89 44 24 04 A1 ?? ?? ?? ?? 89 54 24 08 89 04 24 E8 ?? ?? ?? ?? E9 08 FE FF FF 83 3D ?? ?? ?? ?? 00 0F 86 A9 FC FF FF 8D 76 00 E9 71 FC FF FF 8D 76 00 C7 44 24 04 00 00 00 00 C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? BA ?? ?? ?? ?? 85 C0 0F 84 A2 FB FF FF 8B 15 ?? ?? ?? ?? E9 5B FB FF FF 8D 74 26 00 A1 ?? ?? ?? ?? C7 44 24 08 00 00 00 00 C7 44 24 04 01 00 00 00 89 04 24 E8 ?? ?? ?? ?? 85 C0 78 41 8B 15 ?? ?? ?? ?? 85 D2 75 13 89 C2 83 E2 01 83 FA 01 19 D2 83 CA 01 89 15 ?? ?? ?? ?? 85 D2 0F 89 76 FB FF FF 83 C8 01 89 44 24 08 A1 ?? ?? ?? ?? C7 44 24 04 02 00 00 00 89 04 24 E8 ?? ?? ?? ?? 83 F8 FF 0F 85 51 FB FF FF 8B 1D ?? ?? ?? ?? B8 06 00 00 00 FF 15 ?? ?? ?? ?? 31 FF E9 89 FD FF FF 90 8D 74 26 00 C7 44 24 04 00 00 00 00 C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? BA ?? ?? ?? ?? 85 C0 0F 84 EA FA FF FF 8B 15 ?? ?? ?? ?? E9 B7 FA FF FF 8D 74 26 00 66 83 F8 03 0F 85 93 FB FF FF E9 84 FD FF FF 90 C7 44 24 04 00 00 00 00 C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? BA ?? ?? ?? ?? 85 C0 0F 85 AA FA FF FF 8B 15 ?? ?? ?? ?? E9 8B FA FF FF 8D 74 26 00 C7 44 24 04 00 00 00 00 C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? BA ?? ?? ?? ?? 85 C0 0F 44 15 ?? ?? ?? ?? E9 74 FA FF FF 90 B8 06 00 00 00 FF 15 ?? ?? ?? ?? 31 FF E9 DA FC FF FF 8D B6 00 00 00 00 8B 4C 24 18 8B 5C 24 1C 29 C1 A1 ?? ?? ?? ?? 19 D3 89 4C 24 04 89 5C 24 08 89 04 24 89 0D ?? ?? ?? ?? 89 1D ?? ?? ?? ?? E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? C7 44 24 0C 02 00 00 00 C7 44 24 04 00 00 00 00 C7 44 24 08 00 00 00 00 89 04 24 E8 ?? ?? ?? ?? 85 D2 0F 89 D4 FD FF FF E9 29 FC FF FF 90 31 FF E9 6D FC FF FF C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 90 01 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 31 FF 65 C7 00 0B 00 00 00 E9 36 FC FF FF }
	condition:
		$1
}

rule file_266_6_0 {
	meta:
		name = "getutline_r_file"
		size = 697
		refs = "0037 alarm 007c __sigaction 00c1 __fcntl_nocancel 00f1 __read_nocancel 0135 strncmp 01a1 __libc_errno 02b5 __assert_fail"
	strings:
		$1 = { 55 57 56 53 81 EC 5C 01 00 00 A1 ?? ?? ?? ?? 85 C0 0F 88 7E 02 00 00 A1 ?? ?? ?? ?? 23 05 ?? ?? ?? ?? 83 F8 FF 0F 84 24 02 00 00 C7 04 24 00 00 00 00 8D 5C 24 3C E8 ?? ?? ?? ?? 89 DF B9 20 00 00 00 8D 54 24 38 8D 9C 24 C4 00 00 00 C7 44 24 38 ?? ?? ?? ?? 8D 6C 24 28 C7 84 24 BC 00 00 00 00 00 00 00 89 44 24 1C 31 C0 F3 AB 89 54 24 04 89 5C 24 08 C7 04 24 0E 00 00 00 E8 ?? ?? ?? ?? C7 04 24 0A 00 00 00 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 89 6C 24 08 C7 44 24 04 07 00 00 00 C7 44 24 28 00 00 00 00 89 04 24 C7 44 24 2C 00 00 00 00 C7 44 24 30 00 00 00 00 C7 44 24 34 00 00 00 00 E8 ?? ?? ?? ?? 8B B4 24 70 01 00 00 83 C6 08 85 C0 0F 88 69 01 00 00 90 A1 ?? ?? ?? ?? C7 44 24 08 80 01 00 00 C7 44 24 04 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 3D 80 01 00 00 0F 85 A0 00 00 00 0F B7 05 ?? ?? ?? ?? 81 05 ?? ?? ?? ?? 80 01 00 00 83 15 ?? ?? ?? ?? 00 83 E8 06 66 83 F8 01 77 B7 C7 44 24 08 20 00 00 00 C7 44 24 04 ?? ?? ?? ?? 89 34 24 E8 ?? ?? ?? ?? 85 C0 75 9B 8B BC 24 74 01 00 00 BE ?? ?? ?? ?? 66 B8 80 01 F7 C7 01 00 00 00 0F 85 1A 01 00 00 F7 C7 02 00 00 00 0F 85 F9 00 00 00 89 C1 31 D2 C1 E9 02 A8 02 F3 A5 74 0B 0F B7 16 66 89 17 BA 02 00 00 00 A8 01 74 07 0F B6 04 16 88 04 17 8B 84 24 74 01 00 00 8B 94 24 78 01 00 00 89 02 EB 33 8D B6 00 00 00 00 A1 ?? ?? ?? ?? 8B 94 24 78 01 00 00 C7 05 ?? ?? ?? ?? FF FF FF FF C7 05 ?? ?? ?? ?? FF FF FF FF 65 C7 00 03 00 00 00 C7 02 00 00 00 00 A1 ?? ?? ?? ?? 89 6C 24 08 C7 44 24 04 07 00 00 00 66 C7 44 24 28 02 00 89 04 24 E8 ?? ?? ?? ?? C7 04 24 00 00 00 00 E8 ?? ?? ?? ?? C7 44 24 08 00 00 00 00 89 5C 24 04 C7 04 24 0E 00 00 00 E8 ?? ?? ?? ?? 8B 6C 24 1C 85 ED 75 17 8B 94 24 78 01 00 00 83 3A 01 19 C0 81 C4 5C 01 00 00 5B 5E 5F 5D C3 8B 44 24 1C 89 04 24 E8 ?? ?? ?? ?? EB DB 66 90 8B 94 24 78 01 00 00 C7 02 00 00 00 00 EB 9E 8B 94 24 78 01 00 00 C7 02 00 00 00 00 EB C7 0F B7 16 83 C7 02 83 C6 02 83 E8 02 66 89 57 FE E9 F2 FE FF FF 0F B6 05 ?? ?? ?? ?? BE ?? ?? ?? ?? 88 07 8B BC 24 74 01 00 00 B8 7F 01 00 00 83 C7 01 E9 C4 FE FF FF C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 59 01 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_266_7_0 {
	meta:
		name = "getutent_r_file"
		size = 667
		refs = "0037 alarm 007c __sigaction 00c1 __fcntl_nocancel 00e2 __read_nocancel 0297 __assert_fail"
	strings:
		$1 = { 55 57 56 53 81 EC 4C 01 00 00 A1 ?? ?? ?? ?? 85 C0 0F 88 60 02 00 00 A1 ?? ?? ?? ?? 23 05 ?? ?? ?? ?? 83 F8 FF 0F 84 35 02 00 00 C7 04 24 00 00 00 00 8D 5C 24 2C E8 ?? ?? ?? ?? 89 DF B9 20 00 00 00 8D 54 24 28 8D 9C 24 B4 00 00 00 C7 44 24 28 ?? ?? ?? ?? 8D 6C 24 18 C7 84 24 AC 00 00 00 00 00 00 00 89 C6 31 C0 F3 AB 31 FF 89 54 24 04 89 5C 24 08 C7 04 24 0E 00 00 00 E8 ?? ?? ?? ?? C7 04 24 0A 00 00 00 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 89 6C 24 08 C7 44 24 04 07 00 00 00 C7 44 24 18 00 00 00 00 89 04 24 C7 44 24 1C 00 00 00 00 C7 44 24 20 00 00 00 00 C7 44 24 24 00 00 00 00 E8 ?? ?? ?? ?? 85 C0 78 3F A1 ?? ?? ?? ?? C7 44 24 08 80 01 00 00 C7 44 24 04 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 89 6C 24 08 C7 44 24 04 07 00 00 00 66 C7 44 24 18 02 00 89 C7 A1 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? C7 04 24 00 00 00 00 E8 ?? ?? ?? ?? C7 44 24 08 00 00 00 00 89 5C 24 04 C7 04 24 0E 00 00 00 E8 ?? ?? ?? ?? 85 F6 0F 85 9C 00 00 00 81 FF 80 01 00 00 0F 85 A4 00 00 00 8B BC 24 60 01 00 00 BE ?? ?? ?? ?? B8 80 01 00 00 81 05 ?? ?? ?? ?? 80 01 00 00 83 15 ?? ?? ?? ?? 00 F7 C7 01 00 00 00 0F 85 B2 00 00 00 F7 C7 02 00 00 00 0F 85 CE 00 00 00 89 C1 31 D2 C1 E9 02 A8 02 F3 A5 75 31 A8 01 75 1D 8B 84 24 64 01 00 00 8B 94 24 60 01 00 00 89 10 31 C0 81 C4 4C 01 00 00 5B 5E 5F 5D C3 0F B6 04 16 88 04 17 EB DA 8D B4 26 00 00 00 00 0F B7 16 A8 01 66 89 17 BA 02 00 00 00 74 C4 EB DF 8D B4 26 00 00 00 00 89 34 24 E8 ?? ?? ?? ?? 81 FF 80 01 00 00 0F 84 5C FF FF FF 85 FF 74 14 C7 05 ?? ?? ?? ?? FF FF FF FF C7 05 ?? ?? ?? ?? FF FF FF FF 8B 94 24 64 01 00 00 B8 FF FF FF FF C7 02 00 00 00 00 81 C4 4C 01 00 00 5B 5E 5F 5D C3 8D B4 26 00 00 00 00 0F B6 05 ?? ?? ?? ?? BE ?? ?? ?? ?? 88 07 8B BC 24 60 01 00 00 B8 7F 01 00 00 83 C7 01 E9 2C FF FF FF 8D B6 00 00 00 00 0F B7 16 83 C7 02 83 C6 02 83 E8 02 66 89 57 FE E9 1D FF FF FF 8D 76 00 8B 84 24 64 01 00 00 C7 00 00 00 00 00 B8 FF FF FF FF E9 26 FF FF FF C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 CC 00 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_266_8_0 {
	meta:
		name = "endutent_file"
		size = 76
		refs = "0015 _dl_sysinfo 0048 __assert_fail"
	strings:
		$1 = { 53 83 EC 18 8B 1D ?? ?? ?? ?? 85 DB 78 1A B8 06 00 00 00 FF 15 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? FF FF FF FF 83 C4 18 5B C3 C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 10 02 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_266_9_0 {
	meta:
		name = "getutid_r_file"
		size = 304
		refs = "012c __assert_fail"
	strings:
		$1 = { 83 EC 2C A1 ?? ?? ?? ?? 89 5C 24 20 8B 5C 24 34 89 74 24 24 89 7C 24 28 85 C0 0F 88 EC 00 00 00 A1 ?? ?? ?? ?? 23 05 ?? ?? ?? ?? 83 F8 FF 0F 84 C4 00 00 00 8B 44 24 30 8D 4C 24 1F BA ?? ?? ?? ?? C6 44 24 1F 00 E8 35 F1 FF FF 85 C0 0F 88 A5 00 00 00 F6 C3 01 89 DF BE ?? ?? ?? ?? B8 80 01 00 00 75 74 F7 C7 02 00 00 00 75 54 89 C1 31 D2 C1 E9 02 A8 02 F3 A5 75 2F A8 01 75 1B 8B 44 24 38 89 18 31 C0 8B 5C 24 20 8B 74 24 24 8B 7C 24 28 83 C4 2C C3 8D 76 00 0F B6 04 16 88 04 17 EB DC 8D B4 26 00 00 00 00 0F B7 16 A8 01 66 89 17 BA 02 00 00 00 74 C6 EB DF 8D B4 26 00 00 00 00 0F B7 16 83 C7 02 83 C6 02 83 E8 02 66 89 57 FE EB 9A 8D B6 00 00 00 00 0F B6 05 ?? ?? ?? ?? 8D 7B 01 BE ?? ?? ?? ?? 88 03 B8 7F 01 00 00 E9 71 FF FF FF 90 8D 74 26 00 8B 44 24 38 C7 00 00 00 00 00 B8 FF FF FF FF E9 79 FF FF FF C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 3B 01 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_267_0_0 {
	meta:
		name = "cfsetspeed"
		size = 145
		refs = "002d __libc_errno 0050 cfsetispeed 005c cfsetospeed"
	strings:
		$1 = { 57 31 C0 56 53 83 EC 10 8B 7C 24 20 8B 5C 24 24 8B 34 C5 ?? ?? ?? ?? 39 DE 74 2D 39 1C C5 ?? ?? ?? ?? 74 4C 83 C0 01 83 F8 20 75 E4 A1 ?? ?? ?? ?? 65 C7 00 16 00 00 00 83 C4 10 B8 FF FF FF FF 5B 5E 5F C3 8D 74 26 00 89 5C 24 04 89 3C 24 E8 ?? ?? ?? ?? 89 5C 24 04 89 3C 24 E8 ?? ?? ?? ?? 83 C4 10 31 C0 5B 5E 5F C3 8D B4 26 00 00 00 00 89 74 24 04 89 3C 24 E8 ?? ?? ?? ?? 89 74 24 04 89 3C 24 E8 ?? ?? ?? ?? 83 C4 10 31 C0 5B 5E 5F C3 }
	condition:
		$1
}

rule file_268_0_0 {
	meta:
		name = "strcpy"
		size = 32
	strings:
		$1 = { 53 8B 44 24 08 8B 54 24 0C 89 C3 29 D3 8D 76 00 0F B6 0A 83 C2 01 84 C9 88 4C 1A FF 75 F2 5B C3 }
	condition:
		$1
}

rule file_269_3_0 {
	meta:
		name = "_IO_fflush"
		size = 204
		refs = "00c8 _Unwind_Resume 0096 _IO_flush_all"
	strings:
		$1 = { 56 53 83 EC 14 8B 5C 24 20 85 DB 0F 84 7F 00 00 00 8B 03 25 00 80 00 00 75 32 8B 53 48 65 8B 35 08 00 00 00 3B 72 08 74 1F B9 01 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 0A 0F 85 8A 00 00 00 8B 53 48 89 72 08 83 42 04 01 8B 83 94 00 00 00 89 1C 24 FF 50 30 83 F8 01 19 D2 F7 03 00 80 00 00 F7 D2 75 21 8B 4B 48 83 69 04 01 75 18 C7 41 08 00 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 83 29 01 75 51 90 83 C4 14 89 D0 5B 5E C3 83 C4 14 5B 5E E9 ?? ?? ?? ?? F7 03 00 80 00 00 89 C6 75 20 8B 53 48 83 6A 04 01 75 17 C7 42 08 00 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 83 2A 01 75 1D 89 34 24 E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_270_0_0 {
	meta:
		name = "__setgid"
		size = 84
		refs = "0002 __nptl_setxid 0039 _dl_sysinfo 0046 __libc_errno"
	strings:
		$1 = { 53 B8 ?? ?? ?? ?? 83 EC 38 85 C0 74 21 8B 5C 24 40 8D 44 24 1C 89 04 24 C7 44 24 1C D6 00 00 00 89 5C 24 20 E8 ?? ?? ?? ?? 83 C4 38 5B C3 8B 5C 24 40 B8 D6 00 00 00 FF 15 ?? ?? ?? ?? 3D 00 F0 FF FF 76 E5 8B 15 ?? ?? ?? ?? F7 D8 65 89 02 83 C8 FF EB D5 }
	condition:
		$1
}

rule file_271_0_0 {
	meta:
		name = "msort_with_tmp.part.0"
		size = 825
		refs = "00c1 mempcpy 0102 memcpy"
	strings:
		$1 = { 55 57 56 53 83 EC 3C 8B 18 89 4C 24 2C D1 E9 8B 74 24 2C 89 44 24 24 89 54 24 28 0F AF D9 29 CE 89 4C 24 14 01 D3 83 F9 01 76 05 E8 D0 FF FF FF 83 FE 01 76 0D 8B 44 24 24 89 F1 89 DA E8 BE FF FF FF 8B 44 24 24 8B 10 8B 48 08 8B 78 10 89 54 24 20 8B 50 0C 8B 40 04 89 4C 24 18 89 54 24 1C 83 F8 01 0F 84 C7 01 00 00 0F 82 A1 00 00 00 83 F8 02 0F 84 30 02 00 00 83 F8 03 8B 6C 24 28 0F 84 1B 01 00 00 85 F6 74 46 8B 54 24 14 85 D2 74 3E 8B 4C 24 1C 8B 54 24 18 89 5C 24 04 89 2C 24 89 4C 24 08 FF D2 85 C0 0F 8E 5A 01 00 00 8B 54 24 20 83 EE 01 89 5C 24 04 89 3C 24 89 54 24 08 E8 ?? ?? ?? ?? 03 5C 24 20 85 F6 89 C7 75 BA 8B 44 24 14 85 C0 0F 85 A7 00 00 00 90 8D 74 26 00 8B 4C 24 24 8B 44 24 2C 8B 51 10 29 F0 0F AF 44 24 20 89 54 24 04 8B 54 24 28 89 44 24 08 89 14 24 E8 ?? ?? ?? ?? 83 C4 3C 5B 5E 5F 5D C3 66 90 85 F6 8B 6C 24 28 74 B7 8B 44 24 14 85 C0 74 AF 89 E8 89 F5 89 C6 EB 1A 8B 03 83 ED 01 83 C3 04 83 C7 04 89 47 FC 85 ED 74 36 8B 44 24 14 85 C0 74 2E 8B 54 24 1C 8B 4C 24 18 89 5C 24 04 89 34 24 89 54 24 08 FF D1 85 C0 7F CD 8B 06 83 C7 04 83 C6 04 83 6C 24 14 01 89 47 FC 85 ED 75 CB 90 89 F0 89 EE 89 C5 8B 44 24 14 85 C0 0F 84 5E FF FF FF 8B 44 24 14 0F AF 44 24 20 89 6C 24 04 89 3C 24 89 44 24 08 E8 ?? ?? ?? ?? E9 40 FF FF FF 85 F6 0F 84 88 01 00 00 8B 44 24 14 8B 6C 24 28 85 C0 0F 84 78 01 00 00 89 E8 89 F5 89 C6 EB 19 8B 03 83 ED 01 83 C3 04 89 07 83 C7 04 85 ED 74 9F 8B 4C 24 14 85 C9 74 97 8B 4C 24 1C 8B 54 24 18 89 4C 24 08 8B 03 89 44 24 04 8B 06 89 04 24 FF D2 85 C0 7F CA 8B 06 83 C6 04 83 6C 24 14 01 89 07 EB C6 8D 74 26 00 8B 4C 24 20 89 6C 24 04 89 3C 24 89 4C 24 08 E8 ?? ?? ?? ?? 03 6C 24 20 83 6C 24 14 01 89 C7 E9 59 FE FF FF 8D 74 26 00 85 F6 0F 84 F8 00 00 00 8B 44 24 14 8B 6C 24 28 85 C0 0F 84 E8 00 00 00 89 E8 89 F5 89 C6 EB 27 8B 03 83 ED 01 83 C3 08 8B 53 FC 89 07 89 57 04 83 C7 08 85 ED 0F 84 05 FF FF FF 8B 44 24 14 85 C0 0F 84 F9 FE FF FF 8B 54 24 1C 8B 4C 24 18 89 5C 24 04 89 34 24 89 54 24 08 FF D1 85 C0 7F C0 8B 06 83 C6 08 8B 56 FC 83 6C 24 14 01 89 07 89 57 04 EB BC 8D 74 26 00 8B 6C 24 28 89 E9 89 F5 85 ED 74 48 8D 74 26 00 8B 74 24 14 85 F6 74 3C 8B 54 24 1C 8B 74 24 20 89 0C 24 89 4C 24 10 89 54 24 08 8B 54 24 18 89 5C 24 04 01 FE FF D2 8B 4C 24 10 85 C0 7E 39 8B 54 24 20 89 D8 83 ED 01 01 D3 39 F7 72 12 89 F7 85 ED 75 BC 89 EE 89 CD E9 CA FD FF FF 8D 76 00 8B 10 83 C7 04 83 C0 04 89 57 FC 39 FE 77 F1 89 F7 EB DD 90 8D 74 26 00 8B 54 24 20 89 C8 83 6C 24 14 01 01 D1 EB C3 90 8B 6C 24 28 E9 96 FD FF FF }
	condition:
		$1
}

rule file_271_1_0 {
	meta:
		name = "qsort_r"
		size = 697
		refs = "0049 __libc_errno 0054 malloc 0118 memcpy 018f free 01c0 _quicksort 0248 __sysconf"
	strings:
		$1 = { 55 89 E5 57 56 53 83 EC 6C 8B 7D 10 8B 45 0C 8D 34 C7 0F AF C7 83 FF 20 0F 46 F0 81 FE FF 03 00 00 0F 86 F9 01 00 00 8B 0D ?? ?? ?? ?? 85 C9 0F 84 0B 02 00 00 31 D2 89 F0 F7 F1 3B 05 ?? ?? ?? ?? 0F 87 59 01 00 00 8B 15 ?? ?? ?? ?? 65 8B 1A 89 34 24 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 65 89 1A 85 C0 89 45 B0 0F 84 34 01 00 00 89 45 E4 8B 45 14 83 FF 20 8B 55 18 89 7D D4 C7 45 D8 04 00 00 00 89 45 DC 89 55 E0 0F 86 42 01 00 00 8B 4D 0C 8B 45 E4 C1 E1 02 01 C8 89 45 C4 01 C8 39 45 C4 89 45 B4 0F 83 FB 01 00 00 8B 45 C4 8B 55 08 8B 5D B4 90 8D 74 26 00 89 10 83 C0 04 01 FA 39 C3 77 F5 8B 55 E4 01 CA 83 7D 0C 01 C7 45 D4 04 00 00 00 C7 45 D8 03 00 00 00 0F 86 9F 01 00 00 8B 4D 0C 8D 45 D4 E8 D5 FB FF FF 8B 55 08 C7 45 B8 00 00 00 00 89 55 BC 8B 45 B8 8B 55 C4 8B 1C 82 3B 5D BC 74 6F 8B 45 BC 8B 55 B4 89 7C 24 08 89 44 24 04 89 14 24 E8 ?? ?? ?? ?? 8B 45 B8 8B 4D BC 89 45 C0 EB 03 90 89 C3 89 D8 31 D2 2B 45 08 F7 F7 8B 55 C0 89 C6 8B 45 C4 89 0C 90 89 0C 24 89 7C 24 08 89 5C 24 04 E8 ?? ?? ?? ?? 8B 45 C4 89 D9 89 75 C0 8D 14 B0 8B 02 3B 45 BC 75 C8 89 1A 8B 55 B4 89 7C 24 08 89 1C 24 89 54 24 04 E8 ?? ?? ?? ?? 83 45 B8 01 8B 45 0C 01 7D BC 39 45 B8 0F 85 70 FF FF FF 8B 45 B0 89 04 24 E8 ?? ?? ?? ?? 8D 65 F4 5B 5E 5F 5D C3 90 8D 74 26 00 8B 55 18 8B 45 14 89 7C 24 08 89 54 24 10 8B 55 0C 89 44 24 0C 89 54 24 04 8B 55 08 89 14 24 E8 ?? ?? ?? ?? 8D 65 F4 5B 5E 5F 5D C3 8D 74 26 00 F7 C7 03 00 00 00 75 20 F6 45 08 03 75 1A 83 FF 04 0F 84 C6 00 00 00 83 FF 08 0F 84 9F 00 00 00 C7 45 D8 02 00 00 00 90 83 7D 0C 01 76 8A 8B 4D 0C 8D 45 D4 8B 55 08 E8 B4 FA FF FF 8B 45 B0 89 04 24 E8 ?? ?? ?? ?? E9 77 FF FF FF 8D 74 26 00 83 C6 1E 83 E6 F0 29 F4 8D 44 24 23 83 E0 F0 89 45 E4 C7 45 B0 00 00 00 00 E9 31 FE FF FF 66 90 C7 04 24 55 00 00 00 E8 ?? ?? ?? ?? BA FF FF FF 1F 83 F8 FF 74 0B 85 C0 8D 50 03 0F 49 D0 C1 FA 02 89 15 ?? ?? ?? ?? C7 04 24 1E 00 00 00 E8 ?? ?? ?? ?? 89 C1 A3 ?? ?? ?? ?? E9 B6 FD FF FF 8B 45 0C 85 C0 0F 85 61 FE FF FF E9 F9 FE FF FF F6 45 08 07 0F 85 57 FF FF FF C7 45 D8 01 00 00 00 E9 53 FF FF FF 8B 55 C4 E9 1B FE FF FF C7 45 D8 00 00 00 00 E9 3F FF FF FF }
	condition:
		$1
}

rule file_271_2_0 {
	meta:
		name = "qsort"
		size = 51
		refs = "002b qsort_r"
	strings:
		$1 = { 83 EC 2C 8B 44 24 3C C7 44 24 10 00 00 00 00 89 44 24 0C 8B 44 24 38 89 44 24 08 8B 44 24 34 89 44 24 04 8B 44 24 30 89 04 24 E8 ?? ?? ?? ?? 83 C4 2C C3 }
	condition:
		$1
}

rule file_272_0_0 {
	meta:
		name = "__nrand48_r"
		size = 71
		refs = "0014 __drand48_iterate"
	strings:
		$1 = { 53 83 EC 18 8B 5C 24 20 8B 44 24 24 89 1C 24 89 44 24 04 E8 ?? ?? ?? ?? 85 C0 78 24 0F B7 43 02 0F B7 53 04 66 D1 E8 C1 E2 0F 0F B7 C0 09 D0 8B 54 24 28 89 02 31 C0 83 C4 18 5B C3 8D 74 26 00 B8 FF FF FF FF EB F0 }
	condition:
		$1
}

rule file_273_0_0 {
	meta:
		name = "__get_sol"
		size = 123
		refs = "0077 __assert_fail"
	strings:
		$1 = { 56 BA ?? ?? ?? ?? 53 B8 FF FF FF FF 83 EC 14 8B 74 24 20 8B 5C 24 24 EB 12 8D B4 26 00 00 00 00 83 C2 0C 81 FA ?? ?? ?? ?? 74 22 8B 0A 83 F9 FF 74 25 39 5A 08 75 E9 39 72 04 74 17 83 F8 FF 0F 44 C1 83 C2 0C 81 FA ?? ?? ?? ?? 75 DE 83 C4 14 5B 5E C3 89 C8 EB F6 C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 44 00 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_273_1_0 {
	meta:
		name = "getsourcefilter"
		size = 345
		refs = "0056 memcpy 0070 __get_sol 0097 __getsockopt 00b9 __libc_errno 00d4 free 012b __libc_alloca_cutoff 013b malloc"
	strings:
		$1 = { 55 89 E5 57 56 53 83 EC 4C 8B 5D 1C 8B 75 14 8B 3B C1 E7 07 81 C7 8C 00 00 00 81 FF 00 10 00 00 89 7D E4 0F 87 FE 00 00 00 83 C7 1E 83 E7 F0 29 FC 8D 7C 24 23 83 E7 F0 C7 45 D4 01 00 00 00 8B 45 0C 8B 55 10 89 07 8D 47 04 89 54 24 04 89 74 24 08 89 04 24 E8 ?? ?? ?? ?? 8B 03 8B 55 10 89 87 88 00 00 00 89 74 24 04 0F B7 02 89 04 24 E8 ?? ?? ?? ?? 83 F8 FF 74 3F 89 44 24 04 8B 45 08 8D 4D E4 89 4C 24 10 89 7C 24 0C C7 44 24 08 30 00 00 00 89 04 24 E8 ?? ?? ?? ?? 85 C0 89 C6 74 47 8B 45 D4 85 C0 74 28 8D 65 F4 89 F0 5B 5E 5F 5D C3 8D B6 00 00 00 00 A1 ?? ?? ?? ?? BE FF FF FF FF 65 C7 00 16 00 00 00 8B 45 D4 85 C0 75 D8 89 3C 24 E8 ?? ?? ?? ?? 8D 65 F4 89 F0 5B 5E 5F 5D C3 8D B6 00 00 00 00 8B 8F 84 00 00 00 8B 45 18 89 08 8B 87 88 00 00 00 8D 8F 8C 00 00 00 39 03 0F 46 03 89 4C 24 04 C1 E0 07 89 44 24 08 8B 45 20 89 04 24 E8 ?? ?? ?? ?? 8B 87 88 00 00 00 89 03 E9 7A FF FF FF 89 3C 24 E8 ?? ?? ?? ?? 85 C0 0F 85 F2 FE FF FF 89 3C 24 E8 ?? ?? ?? ?? 85 C0 89 C7 74 0C C7 45 D4 00 00 00 00 E9 EE FE FF FF 83 CE FF E9 4F FF FF FF }
	condition:
		$1
}

rule file_274_0_0 {
	meta:
		name = "__strfmon"
		size = 55
		refs = "0014 __libc_tsd_LOCALE 002f __vstrfmon_l"
	strings:
		$1 = { 83 EC 2C 8D 44 24 3C 89 44 24 10 8B 44 24 38 89 44 24 0C A1 ?? ?? ?? ?? 65 8B 00 89 44 24 08 8B 44 24 34 89 44 24 04 8B 44 24 30 89 04 24 E8 ?? ?? ?? ?? 83 C4 2C C3 }
	condition:
		$1
}

rule file_276_0_0 {
	meta:
		name = "mknodat"
		size = 67
		refs = "003b __xmknodat"
	strings:
		$1 = { 83 EC 3C 8B 44 24 4C C7 04 24 01 00 00 00 89 44 24 28 8B 44 24 50 89 44 24 2C 8D 44 24 28 89 44 24 10 8B 44 24 48 89 44 24 0C 8B 44 24 44 89 44 24 08 8B 44 24 40 89 44 24 04 E8 ?? ?? ?? ?? 83 C4 3C C3 }
	condition:
		$1
}

rule file_277_0_0 {
	meta:
		name = "__libc_msync"
		size = 99
		refs = "001e _dl_sysinfo 0030 __libc_enable_asynccancel 0052 __libc_disable_asynccancel 002a __syscall_error"
		altNames = "msync"
	strings:
		$1 = { 65 83 3D 0C 00 00 00 00 75 25 53 8B 54 24 10 8B 4C 24 0C 8B 5C 24 08 B8 90 00 00 00 FF 15 ?? ?? ?? ?? 5B 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 E8 ?? ?? ?? ?? 50 53 8B 54 24 14 8B 4C 24 10 8B 5C 24 0C B8 90 00 00 00 FF 15 ?? ?? ?? ?? 5B 87 04 24 E8 ?? ?? ?? ?? 58 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_77_0_3 {
	meta:
		name = "__libc_msync"
		size = 99
		refs = "001e _dl_sysinfo 0030 __pthread_enable_asynccancel 0052 __pthread_disable_asynccancel 002a __syscall_error"
	strings:
		$1 = { 65 83 3D 0C 00 00 00 00 75 25 53 8B 54 24 10 8B 4C 24 0C 8B 5C 24 08 B8 90 00 00 00 FF 15 ?? ?? ?? ?? 5B 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 E8 ?? ?? ?? ?? 50 53 8B 54 24 14 8B 4C 24 10 8B 5C 24 0C B8 90 00 00 00 FF 15 ?? ?? ?? ?? 5B 87 04 24 E8 ?? ?? ?? ?? 58 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_77_2_3 {
	meta:
		name = "msync"
		size = 99
		refs = "001e _dl_sysinfo 0030 __pthread_enable_asynccancel 0052 __pthread_disable_asynccancel 002a __syscall_error"
	strings:
		$1 = { 65 83 3D 0C 00 00 00 00 75 25 53 8B 54 24 10 8B 4C 24 0C 8B 5C 24 08 B8 90 00 00 00 FF 15 ?? ?? ?? ?? 5B 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 E8 ?? ?? ?? ?? 50 53 8B 54 24 14 8B 4C 24 10 8B 5C 24 0C B8 90 00 00 00 FF 15 ?? ?? ?? ?? 5B 87 04 24 E8 ?? ?? ?? ?? 58 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_277_1_0 {
	meta:
		name = "__msync_nocancel"
		size = 37
		refs = "0014 _dl_sysinfo 0020 __syscall_error"
	strings:
		$1 = { 53 8B 54 24 10 8B 4C 24 0C 8B 5C 24 08 B8 90 00 00 00 FF 15 ?? ?? ?? ?? 5B 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_278_0_0 {
	meta:
		name = "__libc_sendmsg"
		size = 95
		refs = "001c _dl_sysinfo 002e __libc_enable_asynccancel 004e __libc_disable_asynccancel 0027 __syscall_error"
	strings:
		$1 = { 65 83 3D 0C 00 00 00 00 75 22 89 DA B8 66 00 00 00 BB 10 00 00 00 8D 4C 24 04 FF 15 ?? ?? ?? ?? 89 D3 83 F8 83 0F 83 ?? ?? ?? ?? C3 56 E8 ?? ?? ?? ?? 89 C6 89 DA B8 66 00 00 00 BB 10 00 00 00 8D 4C 24 08 FF 15 ?? ?? ?? ?? 89 D3 96 E8 ?? ?? ?? ?? 89 F0 5E 83 F8 83 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_72_0_3 {
	meta:
		name = "__libc_sendmsg"
		size = 95
		refs = "001c _dl_sysinfo 002e __pthread_enable_asynccancel 004e __pthread_disable_asynccancel 0027 __syscall_error"
	strings:
		$1 = { 65 83 3D 0C 00 00 00 00 75 22 89 DA B8 66 00 00 00 BB 10 00 00 00 8D 4C 24 04 FF 15 ?? ?? ?? ?? 89 D3 83 F8 83 0F 83 ?? ?? ?? ?? C3 56 E8 ?? ?? ?? ?? 89 C6 89 DA B8 66 00 00 00 BB 10 00 00 00 8D 4C 24 08 FF 15 ?? ?? ?? ?? 89 D3 96 E8 ?? ?? ?? ?? 89 F0 5E 83 F8 83 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_279_0_0 {
	meta:
		name = "mkostemps64"
		size = 75
		refs = "002a __gen_tempname 0039 __libc_errno"
	strings:
		$1 = { 83 EC 1C 8B 44 24 24 85 C0 78 2D 8B 54 24 28 89 44 24 04 8B 44 24 20 C7 44 24 0C 00 00 00 00 80 CE 80 89 54 24 08 89 04 24 E8 ?? ?? ?? ?? 83 C4 1C C3 8D B6 00 00 00 00 A1 ?? ?? ?? ?? 65 C7 00 16 00 00 00 B8 FF FF FF FF EB E3 }
	condition:
		$1
}

rule file_281_0_0 {
	meta:
		name = "posix_spawnattr_setflags"
		size = 34
	strings:
		$1 = { 8B 54 24 08 B8 16 00 00 00 66 F7 C2 80 FF 74 08 F3 C3 8D B6 00 00 00 00 8B 44 24 04 66 89 10 31 C0 C3 }
	condition:
		$1
}

rule file_282_0_0 {
	meta:
		name = "__fdelt_chk"
		size = 26
		refs = "0016 __chk_fail"
	strings:
		$1 = { 83 EC 0C 8B 44 24 10 3D FF 03 00 00 77 07 C1 F8 05 83 C4 0C C3 E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_283_0_0 {
	meta:
		name = "__wmemcpy_chk"
		size = 49
		refs = "002d __chk_fail 0028 memcpy"
	strings:
		$1 = { 83 EC 0C 8B 44 24 18 39 44 24 1C 8B 54 24 10 8B 4C 24 14 72 17 C1 E0 02 89 44 24 18 89 4C 24 14 89 54 24 10 83 C4 0C E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1006_0_0 {
	meta:
		name = "__wmemmove_chk"
		size = 49
		refs = "002d __chk_fail 0028 memmove"
	strings:
		$1 = { 83 EC 0C 8B 44 24 18 39 44 24 1C 8B 54 24 10 8B 4C 24 14 72 17 C1 E0 02 89 44 24 18 89 4C 24 14 89 54 24 10 83 C4 0C E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1058_0_0 {
	meta:
		name = "__wmempcpy_chk"
		size = 49
		refs = "002d __chk_fail 0028 mempcpy"
	strings:
		$1 = { 83 EC 0C 8B 44 24 18 39 44 24 1C 8B 54 24 10 8B 4C 24 14 72 17 C1 E0 02 89 44 24 18 89 4C 24 14 89 54 24 10 83 C4 0C E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_284_0_0 {
	meta:
		name = "strcspn"
		size = 174
	strings:
		$1 = { 8B 54 24 04 8B 44 24 08 31 C9 51 51 51 51 51 51 51 51 51 51 51 51 51 51 51 51 51 51 51 51 51 51 51 51 51 51 51 51 51 51 51 51 51 51 51 51 51 51 51 51 51 51 51 51 51 51 51 51 51 51 51 51 51 51 51 51 51 51 6A 00 6A 00 6A 00 6A 00 6A 00 6A 00 8A 08 84 C9 74 27 88 0C 0C 8A 48 01 F6 C1 FF 74 1C 88 0C 0C 8A 48 02 F6 C1 FF 74 11 88 0C 0C 8A 48 03 83 C0 04 88 0C 0C F6 C1 FF 75 D3 8D 42 FC 83 C0 04 8A 08 38 0C 0C 74 1B 8A 48 01 38 0C 0C 74 12 8A 48 02 38 0C 0C 74 09 8A 48 03 38 0C 0C 75 DE 40 40 40 81 C4 00 01 00 00 29 D0 C3 }
	condition:
		$1
}

rule file_285_3_0 {
	meta:
		name = "__vwprintf_chk"
		size = 263
		refs = "0005 stdout 007c _IO_vfwprintf 0103 _Unwind_Resume"
	strings:
		$1 = { 83 EC 2C 8B 15 ?? ?? ?? ?? 89 5C 24 1C 89 7C 24 24 8B 7C 24 30 89 74 24 20 8B 02 89 D3 89 6C 24 28 25 00 80 00 00 75 38 8B 72 48 65 8B 2D 08 00 00 00 3B 6E 08 74 25 B9 01 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 0E 0F 85 B7 00 00 00 8B 72 48 8B 15 ?? ?? ?? ?? 89 6E 08 83 46 04 01 85 FF 7E 04 83 4A 3C 04 8B 44 24 38 89 14 24 89 44 24 08 8B 44 24 34 89 44 24 04 E8 ?? ?? ?? ?? 85 FF 89 C2 7E 09 A1 ?? ?? ?? ?? 83 60 3C FB 83 63 3C EB F7 03 00 80 00 00 75 20 8B 4B 48 83 69 04 01 75 17 C7 41 08 00 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 83 29 01 75 58 89 D0 8B 5C 24 1C 8B 74 24 20 8B 7C 24 24 8B 6C 24 28 83 C4 2C C3 83 63 3C EB 89 C6 F7 03 00 80 00 00 75 20 8B 53 48 83 6A 04 01 75 17 C7 42 08 00 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 83 2A 01 75 1D 89 34 24 E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_453_3_0 {
	meta:
		name = "___vprintf_chk"
		size = 263
		refs = "0005 stdout 007c vfprintf 0103 _Unwind_Resume"
	strings:
		$1 = { 83 EC 2C 8B 15 ?? ?? ?? ?? 89 5C 24 1C 89 7C 24 24 8B 7C 24 30 89 74 24 20 8B 02 89 D3 89 6C 24 28 25 00 80 00 00 75 38 8B 72 48 65 8B 2D 08 00 00 00 3B 6E 08 74 25 B9 01 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 0E 0F 85 B7 00 00 00 8B 72 48 8B 15 ?? ?? ?? ?? 89 6E 08 83 46 04 01 85 FF 7E 04 83 4A 3C 04 8B 44 24 38 89 14 24 89 44 24 08 8B 44 24 34 89 44 24 04 E8 ?? ?? ?? ?? 85 FF 89 C2 7E 09 A1 ?? ?? ?? ?? 83 60 3C FB 83 63 3C EB F7 03 00 80 00 00 75 20 8B 4B 48 83 69 04 01 75 17 C7 41 08 00 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 83 29 01 75 58 89 D0 8B 5C 24 1C 8B 74 24 20 8B 7C 24 24 8B 6C 24 28 83 C4 2C C3 83 63 3C EB 89 C6 F7 03 00 80 00 00 75 20 8B 53 48 83 6A 04 01 75 17 C7 42 08 00 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 83 2A 01 75 1D 89 34 24 E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_288_0_0 {
	meta:
		name = "__alloc_dir"
		size = 324
		refs = "003f __fcntl 0066 malloc 00a9 __have_o_cloexec 0128 __libc_errno 0136 _dl_sysinfo"
	strings:
		$1 = { 83 EC 1C 84 D2 89 5C 24 10 89 C3 89 74 24 14 8B 74 24 20 89 7C 24 18 89 D7 0F 85 89 00 00 00 81 E1 00 00 08 00 0F 85 7D 00 00 00 C7 44 24 08 01 00 00 00 C7 44 24 04 02 00 00 00 89 1C 24 E8 ?? ?? ?? ?? 85 C0 0F 88 D5 00 00 00 85 F6 74 6E 8B 46 34 BE 00 80 00 00 3D 00 80 00 00 0F 43 F0 8D 46 18 89 04 24 E8 ?? ?? ?? ?? 85 C0 0F 84 8E 00 00 00 89 18 C7 40 04 00 00 00 00 89 70 08 C7 40 0C 00 00 00 00 C7 40 10 00 00 00 00 C7 40 14 00 00 00 00 8B 5C 24 10 8B 74 24 14 8B 7C 24 18 83 C4 1C C2 04 00 8D 76 00 A1 ?? ?? ?? ?? 85 C0 74 17 85 C0 0F 8E 72 FF FF FF 85 F6 75 92 B8 18 80 00 00 66 BE 00 80 EB 9A C7 44 24 08 00 00 00 00 C7 44 24 04 01 00 00 00 89 1C 24 E8 ?? ?? ?? ?? 83 E0 01 83 F8 01 19 C0 83 C8 01 85 C0 A3 ?? ?? ?? ?? 0F 8E 33 FF FF FF EB BF 8D B6 00 00 00 00 C7 04 24 18 20 00 00 E8 ?? ?? ?? ?? 85 C0 74 10 BE 00 20 00 00 E9 58 FF FF FF 8D B6 00 00 00 00 89 F8 84 C0 74 17 8B 15 ?? ?? ?? ?? 65 8B 0A B8 06 00 00 00 FF 15 ?? ?? ?? ?? 65 89 0A 31 C0 E9 4F FF FF FF }
	condition:
		$1
}

rule file_288_1_0 {
	meta:
		name = "__opendirat"
		size = 85
		refs = "0020 __openat_nocancel 0037 __alloc_dir 0043 __libc_errno"
	strings:
		$1 = { 80 3A 00 74 3D 83 EC 1C C7 44 24 0C 00 00 00 00 C7 44 24 08 00 88 09 00 89 54 24 04 89 04 24 E8 ?? ?? ?? ?? 85 C0 78 29 C7 04 24 00 00 00 00 31 C9 BA 01 00 00 00 E8 ?? ?? ?? ?? 83 EC 04 83 C4 1C C3 A1 ?? ?? ?? ?? 65 C7 00 02 00 00 00 31 C0 C3 31 C0 EB E9 }
	condition:
		$1
}

rule file_289_0_0 {
	meta:
		name = "__updwtmp"
		size = 283
		refs = "0068 __libc_utmp_file_functions 0098 __access"
	strings:
		$1 = { 83 EC 2C B9 0E 00 00 00 89 5C 24 1C 8B 5C 24 30 89 74 24 20 89 7C 24 24 BF ?? ?? ?? ?? 89 6C 24 28 8B 6C 24 34 89 DE F3 A6 74 5D B9 0E 00 00 00 BF ?? ?? ?? ?? 89 DE F3 A6 74 6D BF ?? ?? ?? ?? B9 0F 00 00 00 89 DE F3 A6 0F 84 81 00 00 00 BF ?? ?? ?? ?? B9 0F 00 00 00 89 DE F3 A6 0F 84 95 00 00 00 89 6C 24 34 A1 ?? ?? ?? ?? 89 5C 24 30 8B 74 24 20 8B 5C 24 1C 8B 7C 24 24 8B 6C 24 28 83 C4 2C FF E0 8D 76 00 C7 44 24 04 00 00 00 00 C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 75 8B BB ?? ?? ?? ?? EB BC 90 C7 44 24 04 00 00 00 00 C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 0F 85 77 FF FF FF BB ?? ?? ?? ?? EB 98 90 8D 74 26 00 C7 44 24 04 00 00 00 00 C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 0F 84 63 FF FF FF BB ?? ?? ?? ?? E9 6D FF FF FF 66 90 C7 44 24 04 00 00 00 00 C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 B8 ?? ?? ?? ?? 0F 45 D8 E9 48 FF FF FF }
	condition:
		$1
}

rule file_290_0_0 {
	meta:
		name = "__fchdir"
		size = 31
		refs = "000d _dl_sysinfo 001a __syscall_error"
	strings:
		$1 = { 89 DA 8B 5C 24 04 B8 85 00 00 00 FF 15 ?? ?? ?? ?? 89 D3 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_291_0_0 {
	meta:
		name = "__assert_fail_base"
		size = 372
		refs = "0002 pthread_setcancelstate 0032 __progname 0086 __asprintf 00aa __fxprintf 00af stderr 00b7 _IO_fflush 00bd _dl_pagesize 00fb __mmap 011b strcpy 0123 __abort_msg 0135 __munmap 0141 free 0146 abort 0162 __libc_write"
	strings:
		$1 = { 56 B8 ?? ?? ?? ?? 53 83 EC 44 85 C0 8B 5C 24 60 74 11 C7 44 24 04 00 00 00 00 C7 04 24 01 00 00 00 FF D0 85 DB B9 ?? ?? ?? ?? 0F 84 38 01 00 00 8B 15 ?? ?? ?? ?? BE ?? ?? ?? ?? B8 ?? ?? ?? ?? 80 3A 00 89 4C 24 1C 8B 4C 24 5C 89 5C 24 18 0F 44 C6 89 44 24 0C 8D 74 24 3C 8B 44 24 50 89 74 24 24 8B 74 24 54 89 4C 24 14 8B 4C 24 58 89 54 24 08 89 44 24 04 8D 44 24 38 89 74 24 20 89 4C 24 10 89 04 24 E8 ?? ?? ?? ?? 85 C0 0F 88 B8 00 00 00 8B 44 24 38 C7 44 24 04 ?? ?? ?? ?? C7 04 24 00 00 00 00 89 44 24 08 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 8B 44 24 3C C7 44 24 14 00 00 00 00 C7 44 24 10 FF FF FF FF C7 44 24 0C 22 00 00 00 01 D0 F7 DA 21 D0 C7 44 24 08 03 00 00 00 89 44 24 04 C7 04 24 00 00 00 00 89 44 24 3C E8 ?? ?? ?? ?? 83 F8 FF 89 C3 74 33 8B 44 24 3C 89 03 8B 44 24 38 89 44 24 04 8D 43 04 89 04 24 E8 ?? ?? ?? ?? 89 D8 87 05 ?? ?? ?? ?? 85 C0 74 0E 8B 10 89 04 24 89 54 24 04 E8 ?? ?? ?? ?? 8B 44 24 38 89 04 24 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 44 24 08 12 00 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 02 00 00 00 E8 ?? ?? ?? ?? EB DD B9 ?? ?? ?? ?? 89 CB E9 BC FE FF FF }
	condition:
		$1
}

rule file_291_1_0 {
	meta:
		name = "__assert_fail"
		size = 71
		refs = "0016 _libc_intl_domainname 001b __dcgettext 0043 __assert_fail_base"
	strings:
		$1 = { 83 EC 2C C7 44 24 08 05 00 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 54 24 3C 89 54 24 10 8B 54 24 38 89 04 24 89 54 24 0C 8B 54 24 34 89 54 24 08 8B 54 24 30 89 54 24 04 E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_295_0_0 {
	meta:
		name = "__lll_lock_wait_private"
		size = 46
		refs = "001e _dl_sysinfo"
	strings:
		$1 = { 52 53 56 BA 02 00 00 00 89 CB 31 F6 65 8B 0D 20 00 00 00 39 D0 75 0B B8 F0 00 00 00 FF 15 ?? ?? ?? ?? 89 D0 87 03 85 C0 75 ED 5E 5B 5A C3 }
	condition:
		$1
}

rule file_295_1_0 {
	meta:
		name = "__lll_unlock_wake_private"
		size = 41
		refs = "0021 _dl_sysinfo"
	strings:
		$1 = { 53 51 52 89 C3 C7 00 00 00 00 00 65 8B 0D 20 00 00 00 83 C9 01 BA 01 00 00 00 B8 F0 00 00 00 FF 15 ?? ?? ?? ?? 5A 59 5B C3 }
	condition:
		$1
}

rule file_296_0_0 {
	meta:
		name = "setegid"
		size = 130
		refs = "000e __nptl_setxid 0049 __libc_errno 0067 _dl_sysinfo"
	strings:
		$1 = { 53 83 EC 38 8B 4C 24 40 83 F9 FF 74 3B B8 ?? ?? ?? ?? 85 C0 74 45 8D 44 24 1C 89 04 24 C7 44 24 1C D2 00 00 00 C7 44 24 20 FF FF FF FF 89 4C 24 24 C7 44 24 28 FF FF FF FF E8 ?? ?? ?? ?? 83 C4 38 5B C3 90 8D 74 26 00 A1 ?? ?? ?? ?? 65 C7 00 16 00 00 00 B8 FF FF FF FF EB E3 83 CA FF 89 D3 B8 D2 00 00 00 FF 15 ?? ?? ?? ?? 3D 00 F0 FF FF 76 CC 8B 15 ?? ?? ?? ?? F7 D8 65 89 02 83 C8 FF EB BC }
	condition:
		$1
}

rule file_297_0_0 {
	meta:
		name = "creat64"
		size = 35
		refs = "001b __open64"
	strings:
		$1 = { 83 EC 1C 8B 44 24 24 C7 44 24 04 41 02 00 00 89 44 24 08 8B 44 24 20 89 04 24 E8 ?? ?? ?? ?? 83 C4 1C C3 }
	condition:
		$1
}

rule file_298_0_0 {
	meta:
		name = "__printf_fphex"
		size = 5625
		refs = "004e _nl_current_LC_NUMERIC 00b4 __isnan 00de __libc_tsd_CTYPE_B 0159 _IO_padn 0191 _nl_current_LC_MONETARY 01ce __isnanl 038c __isinf 03fc _itowa 0430 _itoa 0530 _itoa_word 0566 _itowa_lower_digits 05d6 strlen 0624 _IO_wpadn 0972 __isinfl 1097 __libc_tsd_CTYPE_TOLOWER 1274 __assert_fail 12af __woverflow 1326 __overflow"
	strings:
		$1 = { 55 57 56 53 81 EC 8C 01 00 00 8B 8C 24 A4 01 00 00 8B 9C 24 A4 01 00 00 8B AC 24 A0 01 00 00 8B 09 8B 5B 04 89 4C 24 70 8B 8C 24 A4 01 00 00 89 5C 24 68 0F B6 41 0D 89 C2 C0 EA 02 89 D3 83 E3 01 A8 01 89 5C 24 5C 0F 85 43 01 00 00 A1 ?? ?? ?? ?? 65 8B 00 8B 00 8B 48 24 8B 40 30 89 4C 24 6C 89 44 24 58 8B 4C 24 6C 80 39 00 0F 84 E2 11 00 00 8B 74 24 58 85 F6 0F 84 D6 11 00 00 8B 8C 24 A4 01 00 00 0F B6 59 0C F6 C3 01 0F 85 1E 01 00 00 8B 8C 24 A8 01 00 00 8B 01 F2 0F 10 00 F2 0F 11 84 24 C0 00 00 00 F2 0F 11 04 24 F2 0F 11 44 24 20 E8 ?? ?? ?? ?? F2 0F 10 44 24 20 85 C0 0F 84 BA 02 00 00 8B 84 24 A4 01 00 00 BF ?? ?? ?? ?? 0F BE 8C 24 C7 00 00 00 8B 50 08 A1 ?? ?? ?? ?? C1 E9 1F 65 8B 00 0F B7 04 50 BA ?? ?? ?? ?? 66 25 00 01 B8 ?? ?? ?? ?? 0F 44 FA BA ?? ?? ?? ?? 0F 44 D0 85 C9 75 09 F6 C3 50 8B 44 24 68 74 07 8B 44 24 68 83 E8 01 83 E8 03 83 E3 20 89 44 24 58 0F 85 FF 00 00 00 85 C0 0F 8E F7 00 00 00 8B 5C 24 5C 85 DB 0F 85 0B 09 00 00 8B 5C 24 58 C7 44 24 04 20 00 00 00 89 2C 24 89 54 24 44 89 5C 24 08 89 4C 24 40 E8 ?? ?? ?? ?? 8B 4C 24 40 8B 54 24 44 8B 74 24 58 39 F0 0F 84 B9 00 00 00 8D B4 26 00 00 00 00 BE FF FF FF FF 81 C4 8C 01 00 00 89 F0 5B 5E 5F 5D C3 8D B6 00 00 00 00 A1 ?? ?? ?? ?? 65 8B 00 8B 00 8B 58 2C 8B 80 D0 00 00 00 89 5C 24 6C 89 44 24 58 E9 B5 FE FF FF 8B 94 24 A8 01 00 00 8B 02 DB 28 D9 C0 DB BC 24 C0 00 00 00 D9 C0 DB 3C 24 DB 7C 24 30 E8 ?? ?? ?? ?? 85 C0 DB 6C 24 30 0F 84 8A 07 00 00 DD D8 8B 84 24 A4 01 00 00 BF ?? ?? ?? ?? 0F BE 8C 24 C9 00 00 00 8B 50 08 A1 ?? ?? ?? ?? C1 E9 1F 65 8B 00 0F B7 04 50 BA ?? ?? ?? ?? 66 25 00 01 B8 ?? ?? ?? ?? 0F 45 FA BA ?? ?? ?? ?? 0F 45 D0 E9 E1 FE FF FF 8D 74 26 00 31 F6 85 C9 0F 84 D6 00 00 00 8B 44 24 5C 85 C0 0F 84 8A 07 00 00 8B 45 58 85 C0 0F 84 AA 10 00 00 8B 48 10 3B 48 14 0F 83 9E 10 00 00 C7 01 2D 00 00 00 83 C1 04 89 48 10 83 C6 01 8B 44 24 5C 85 C0 0F 84 E0 00 00 00 8D 5F 0C 8B 45 58 83 C7 04 8B 57 FC 85 C0 0F 84 23 10 00 00 8B 48 10 3B 48 14 0F 83 17 10 00 00 83 FA FF 89 11 0F 94 C2 83 C1 04 89 48 10 84 D2 0F 85 D2 FE FF FF 83 C6 01 39 DF 75 C6 8B 9C 24 A4 01 00 00 F6 43 0C 20 0F 84 BF FE FF FF 8B 44 24 58 85 C0 0F 8E B3 FE FF FF 8B 44 24 5C 85 C0 0F 85 52 07 00 00 8B 4C 24 58 C7 44 24 04 20 00 00 00 89 2C 24 89 4C 24 08 E8 ?? ?? ?? ?? 3B 44 24 58 0F 85 80 FE FF FF 01 C6 81 C4 8C 01 00 00 89 F0 5B 5E 5F 5D C3 90 8B 8C 24 A4 01 00 00 0F B6 41 0C A8 40 0F 84 CD 06 00 00 8B 44 24 5C 85 C0 0F 84 81 08 00 00 8B 45 58 85 C0 0F 84 40 10 00 00 8B 48 10 3B 48 14 0F 83 34 10 00 00 C7 01 2B 00 00 00 83 C1 04 89 48 10 E9 12 FF FF FF 90 89 D7 8D 5E 03 29 F7 8B 45 14 3B 45 18 0F B6 14 37 0F 83 B7 0F 00 00 88 10 83 C0 01 89 45 14 83 C6 01 39 DE 75 E1 E9 32 FF FF FF 90 8D 74 26 00 F2 0F 11 04 24 F2 0F 11 44 24 20 E8 ?? ?? ?? ?? F2 0F 10 44 24 20 85 C0 0F 85 E6 05 00 00 F2 0F 11 44 24 60 8B 4C 24 64 31 C0 8B 9C 24 C4 00 00 00 8D 94 24 00 01 00 00 8B B4 24 C0 00 00 00 89 54 24 60 89 4C 24 74 8B 8C 24 A4 01 00 00 81 E3 FF FF 0F 00 89 F7 83 79 08 41 8D 8C 24 80 01 00 00 89 4C 24 08 0F 94 C0 89 44 24 10 C7 44 24 0C 10 00 00 00 89 34 24 89 5C 24 04 E8 ?? ?? ?? ?? 8B 8C 24 A4 01 00 00 8B 54 24 60 89 44 24 7C 31 C0 83 79 08 41 89 54 24 08 C7 44 24 0C 10 00 00 00 0F 94 C0 89 44 24 10 89 34 24 89 5C 24 04 E8 ?? ?? ?? ?? 8D 8C 24 4C 01 00 00 89 44 24 78 8B 44 24 7C 8B 54 24 78 39 C8 76 3A 90 8D 74 26 00 83 E8 04 83 EA 01 39 C8 C7 00 30 00 00 00 C6 02 30 77 ED 8B 54 24 7C F7 D1 8D 04 11 8B 4C 24 7C C1 E8 02 89 C2 F7 D0 01 44 24 78 F7 DA 8D 4C 91 FC 89 4C 24 7C 0F B7 8C 24 C6 00 00 00 8B 74 24 74 89 C8 66 25 F0 7F 66 83 F8 01 19 C0 83 C0 31 C1 EE 1F 09 DF 88 84 24 80 00 00 00 0F 94 C0 66 C1 E9 04 0F B6 C0 81 E1 FF 07 00 00 89 C2 0F 84 24 07 00 00 81 F9 FE 03 00 00 0F 8E B0 0A 00 00 81 E9 FF 03 00 00 89 8C 24 90 00 00 00 C7 84 24 98 00 00 00 00 00 00 00 85 D2 0F 84 16 07 00 00 8B 9C 24 90 00 00 00 8B 44 24 78 83 7C 24 70 FF 89 44 24 60 0F 84 D6 09 00 00 8D 8C 24 B0 00 00 00 89 4C 24 04 C7 44 24 0C 00 00 00 00 C7 44 24 08 0A 00 00 00 89 1C 24 89 8C 24 94 00 00 00 E8 ?? ?? ?? ?? 8D 94 24 E0 00 00 00 B9 CD CC CC CC 89 D7 89 84 24 90 00 00 00 8D B4 26 00 00 00 00 89 D8 83 EF 04 F7 E1 C1 EA 03 8D 04 92 01 C0 29 C3 85 D2 8B 04 9D ?? ?? ?? ?? 89 D3 89 07 75 E0 8B 8C 24 A4 01 00 00 B8 FC FF FF FF 8B 94 24 90 00 00 00 2B 94 24 94 00 00 00 85 F6 89 7C 24 74 0F B6 59 0C 75 0F 31 C9 F6 C3 50 0F 95 C1 B8 FD FF FF FF 29 C8 2B 44 24 70 8B 4C 24 70 8D 44 02 FE 03 44 24 68 85 C9 89 44 24 68 0F 8E D7 07 00 00 8B 54 24 5C B8 01 00 00 00 85 D2 75 0C 8B 4C 24 6C 89 0C 24 E8 ?? ?? ?? ?? 29 44 24 68 83 E3 20 0F 85 F9 06 00 00 8B 9C 24 A4 01 00 00 83 7B 10 30 0F 84 E8 06 00 00 8B 44 24 68 85 C0 0F 8E DC 06 00 00 8B 44 24 5C 85 C0 0F 84 50 09 00 00 8B 54 24 68 C7 44 24 04 20 00 00 00 89 2C 24 89 54 24 08 E8 ?? ?? ?? ?? 3B 44 24 68 0F 85 46 FB FF FF 8B 7C 24 68 85 F6 0F 84 AA 06 00 00 8B 44 24 5C 85 C0 0F 84 76 07 00 00 8B 45 58 85 C0 0F 84 58 0D 00 00 8B 50 10 3B 50 14 0F 83 4C 0D 00 00 C7 02 2D 00 00 00 83 C2 04 89 50 10 83 C7 01 8B 4C 24 5C 85 C9 0F 84 B4 06 00 00 8B 45 58 85 C0 0F 84 0B 0E 00 00 8B 50 10 3B 50 14 0F 83 FF 0D 00 00 C7 02 30 00 00 00 83 C2 04 89 50 10 8B 8C 24 A4 01 00 00 8B 54 24 5C 8B 49 08 89 C8 83 C0 17 85 D2 0F 84 96 06 00 00 8B 55 58 85 D2 0F 84 79 0D 00 00 8B 4A 10 3B 4A 14 0F 83 6D 0D 00 00 83 F8 FF 89 01 0F 94 C0 83 C1 04 89 4A 10 84 C0 0F 85 91 FA FF FF 8B 9C 24 A4 01 00 00 83 C7 02 F6 43 0C 20 75 0A 83 7B 10 30 0F 84 EF 08 00 00 8B 44 24 5C 85 C0 0F 84 63 06 00 00 8B 45 58 85 C0 0F 84 8C 0E 00 00 8B 50 10 3B 50 14 0F 83 80 0E 00 00 0F BE 8C 24 80 00 00 00 83 F9 FF 89 0A 0F 94 C1 83 C2 04 89 50 10 84 C9 0F 85 36 FA FF FF 8B 44 24 70 8D 5F 01 85 C0 0F 8E CF 06 00 00 8B 44 24 5C 85 C0 0F 85 43 05 00 00 8B 4C 24 6C 89 0C 24 E8 ?? ?? ?? ?? 8B 4C 24 6C 29 F9 89 CF 85 C0 89 C6 74 29 90 8B 45 14 3B 45 18 0F B6 54 1F FF 0F 83 CF 0B 00 00 88 10 83 C0 01 89 45 14 83 C3 01 83 EE 01 75 DF 8D B4 26 00 00 00 00 8B 44 24 70 85 C0 0F 8E 8B 00 00 00 8B 7C 24 5C 8B 44 24 78 2B 44 24 60 03 44 24 70 8B 74 24 60 2B 74 24 78 3B 74 24 70 0F 4F 74 24 70 85 FF 89 44 24 58 0F 85 5F 06 00 00 8B 7C 24 78 29 DF 85 F6 74 25 90 8D 74 26 00 8B 45 14 3B 45 18 0F B6 14 1F 0F 83 E7 0D 00 00 88 10 83 C0 01 89 45 14 83 C3 01 83 EE 01 75 E0 83 7C 24 58 00 0F 8E 7A 06 00 00 8B 54 24 58 C7 44 24 04 30 00 00 00 89 2C 24 89 54 24 08 E8 ?? ?? ?? ?? 3B 44 24 58 0F 85 43 F9 FF FF 01 C3 8B 8C 24 A4 01 00 00 8B 49 08 89 C8 8B 4C 24 5C 83 C0 0F 85 C9 0F 84 4E 06 00 00 8B 55 58 85 D2 0F 84 82 0C 00 00 8B 4A 10 3B 4A 14 0F 83 76 0C 00 00 83 F8 FF 89 01 0F 94 C0 83 C1 04 89 4A 10 84 C0 0F 85 F9 F8 FF FF 83 BC 24 98 00 00 00 01 8B 54 24 5C 19 C0 83 E0 FE 83 C0 2D 85 D2 0F 84 25 06 00 00 8B 55 58 85 D2 0F 84 B7 0C 00 00 8B 4A 10 3B 4A 14 0F 83 AB 0C 00 00 89 01 83 C1 04 89 4A 10 8B 44 24 5C 8D 73 02 8B BC 24 94 00 00 00 2B BC 24 90 00 00 00 85 C0 0F 85 31 06 00 00 8B 84 24 90 00 00 00 29 D8 85 FF 89 C3 74 23 66 90 8B 45 14 3B 45 18 0F B6 54 33 FE 0F 83 CC 0B 00 00 88 10 83 C0 01 89 45 14 83 C6 01 83 EF 01 75 DF 8B 8C 24 A4 01 00 00 F6 41 0C 20 0F 84 63 F8 FF FF 8B 41 10 83 F8 30 0F 84 57 F8 FF FF 8B 4C 24 68 85 C9 0F 8E 4B F8 FF FF 8B 54 24 5C 85 D2 0F 84 9A 08 00 00 8B 5C 24 68 89 44 24 04 89 2C 24 89 5C 24 08 E8 ?? ?? ?? ?? 3B 44 24 68 0F 85 1C F8 FF FF 01 C6 E9 97 F9 FF FF 90 8D 74 26 00 D9 C0 DB 3C 24 DB 7C 24 30 E8 ?? ?? ?? ?? 85 C0 DB 6C 24 30 0F 84 F6 00 00 00 DD D8 8B 94 24 A4 01 00 00 BF ?? ?? ?? ?? 8B 4A 08 8B 15 ?? ?? ?? ?? 65 8B 12 0F B7 0C 4A BA ?? ?? ?? ?? 66 81 E1 00 01 B9 ?? ?? ?? ?? 0F 44 FA BA ?? ?? ?? ?? 0F 44 D1 89 C1 C1 E9 1F E9 41 F7 FF FF 8D 74 26 00 8B 45 14 3B 45 18 0F 83 64 09 00 00 C6 00 2D 83 C0 01 89 45 14 E9 7F F8 FF FF 8D B6 00 00 00 00 A8 10 0F 84 74 F8 FF FF 8B 44 24 5C 85 C0 0F 84 CC 01 00 00 8B 45 58 85 C0 0F 84 7E 0A 00 00 8B 48 10 3B 48 14 0F 83 72 0A 00 00 C7 01 20 00 00 00 83 C1 04 89 48 10 E9 3D F8 FF FF 8D 74 26 00 8B 54 24 58 C7 44 24 04 20 00 00 00 89 2C 24 89 54 24 08 E8 ?? ?? ?? ?? E9 A9 F8 FF FF 8D 76 00 89 44 24 08 C7 44 24 04 20 00 00 00 89 2C 24 89 54 24 44 89 4C 24 40 E8 ?? ?? ?? ?? 8B 54 24 44 8B 4C 24 40 E9 F4 F6 FF FF 8D B4 26 00 00 00 00 8B 84 24 A4 01 00 00 8D 94 24 00 01 00 00 DB BC 24 B0 00 00 00 8B 8C 24 B8 00 00 00 8B B4 24 C4 00 00 00 89 54 24 60 83 78 08 41 89 4C 24 78 8B 8C 24 C0 00 00 00 89 54 24 08 0F 94 C0 0F B6 C0 89 0C 24 89 CF 89 74 24 04 89 44 24 10 C7 44 24 0C 10 00 00 00 89 74 24 7C 89 4C 24 40 E8 ?? ?? ?? ?? 8B 4C 24 40 8D 94 24 80 01 00 00 89 C3 8B 84 24 A4 01 00 00 83 78 08 41 89 54 24 08 89 0C 24 0F 94 C0 0F B6 C0 89 74 24 04 8D B4 24 F0 00 00 00 89 44 24 10 C7 44 24 0C 10 00 00 00 E8 ?? ?? ?? ?? 39 F3 89 DA 89 C1 76 31 90 8D 74 26 00 83 EA 01 83 E9 04 39 F2 C6 02 30 C7 01 30 00 00 00 75 ED 8D 4B FF 8D B4 24 80 01 00 00 29 CA 29 CE 8D 9C 1E 6F FF FF FF 8D 44 90 FC 8B 74 24 78 0F B6 0B C1 EE 0F 83 E6 01 0B 7C 24 7C 88 8C 24 80 00 00 00 0F 94 C2 83 C0 04 89 44 24 7C 0F B7 84 24 C8 00 00 00 83 C3 01 0F B6 D2 89 5C 24 78 25 FF 7F 00 00 0F 85 E5 00 00 00 85 D2 0F 85 0D 02 00 00 C7 84 24 90 00 00 00 01 40 00 00 EB 53 8B 45 14 3B 45 18 0F 83 C4 08 00 00 C6 00 2B 83 C0 01 89 45 14 E9 9F F6 FF FF 8D B6 00 00 00 00 8B 45 14 3B 45 18 0F 83 22 09 00 00 C6 00 20 83 C0 01 89 45 14 E9 7F F6 FF FF 8D B6 00 00 00 00 85 C0 0F 85 B8 01 00 00 C7 84 24 90 00 00 00 FE 03 00 00 C7 84 24 98 00 00 00 01 00 00 00 83 BC 24 7C 01 00 00 30 75 20 8D 9C 24 00 01 00 00 8D 84 24 80 01 00 00 89 DA 83 E8 04 83 EA 01 83 78 FC 30 74 F4 89 54 24 60 83 7C 24 70 FF 0F 84 B5 02 00 00 8B 44 24 60 2B 44 24 78 39 44 24 70 7D 1F 8B 54 24 78 8B 5C 24 70 80 3C 1A 38 0F 8F 14 04 00 00 0F 84 D2 03 00 00 8D B4 26 00 00 00 00 8B 9C 24 90 00 00 00 E9 96 F8 FF FF 8D 74 26 00 3D 01 40 00 00 0F 8E 25 03 00 00 2D 02 40 00 00 89 84 24 90 00 00 00 C7 84 24 98 00 00 00 00 00 00 00 E9 49 F8 FF FF 90 8B 45 58 85 C0 0F 84 2D 06 00 00 8B 50 10 3B 50 14 0F 83 21 06 00 00 8B 4C 24 58 83 F9 FF 89 0A 0F 94 C1 83 C2 04 89 50 10 84 C9 0F 85 A7 F4 FF FF 8D 5F 02 E9 C7 FA FF FF 8D B4 26 00 00 00 00 31 FF E9 4F F9 FF FF 90 8B 9C 24 A4 01 00 00 0F B6 43 0C A8 40 0F 84 E5 00 00 00 8B 74 24 5C 85 F6 0F 84 C9 02 00 00 8B 45 58 85 C0 0F 84 98 07 00 00 8B 50 10 3B 50 14 0F 83 8C 07 00 00 C7 02 2B 00 00 00 83 C2 04 89 50 10 E9 3E F9 FF FF 90 8B 45 14 3B 45 18 0F 83 19 07 00 00 C6 00 30 83 C0 01 89 45 14 E9 55 F9 FF FF 8D B6 00 00 00 00 8B 55 14 3B 55 18 0F 83 67 08 00 00 88 02 83 C2 01 89 55 14 E9 7E F9 FF FF 8D B4 26 00 00 00 00 8B 45 14 3B 45 18 0F 83 54 06 00 00 0F B6 9C 24 80 00 00 00 83 C0 01 88 58 FF 89 45 14 E9 B0 F9 FF FF 8D B6 00 00 00 00 F6 C3 08 0F 84 3D F8 FF FF E9 1B F8 FF FF 66 90 31 DB C7 84 24 98 00 00 00 00 00 00 00 E9 3D F7 FF FF 8D B6 00 00 00 00 8B 45 14 3B 45 18 0F 83 52 07 00 00 C6 00 2D 83 C0 01 89 45 14 E9 93 F8 FF FF 8D B6 00 00 00 00 A8 10 0F 84 88 F8 FF FF 8B 5C 24 5C 85 DB 0F 84 4E 03 00 00 8B 45 58 85 C0 0F 84 0F 06 00 00 8B 50 10 3B 50 14 0F 83 03 06 00 00 C7 02 20 00 00 00 83 C2 04 89 50 10 E9 51 F8 FF FF 8D 74 26 00 8B 8C 24 A4 01 00 00 F6 41 0C 08 0F 84 06 FA FF FF E9 1B F9 FF FF 66 90 85 F6 0F 84 F9 06 00 00 8B 54 24 7C 89 D8 F7 D8 8D 3C 82 EB 0F 8D 76 00 83 C3 01 83 EE 01 0F 84 DD 06 00 00 8B 45 58 8B 14 9F 85 C0 0F 84 15 05 00 00 8B 48 10 3B 48 14 0F 83 09 05 00 00 83 FA FF 89 11 0F 94 C2 83 C1 04 89 48 10 84 D2 74 C8 E9 EB F2 FF FF 8B 8C 24 A4 01 00 00 8B 49 08 89 C8 83 C0 0F 8D 74 26 00 8B 55 14 3B 55 18 0F 83 C8 06 00 00 88 02 83 C2 01 89 55 14 E9 C6 F9 FF FF 8D B4 26 00 00 00 00 8B 55 14 3B 55 18 0F 83 23 05 00 00 88 02 83 C2 01 89 55 14 E9 E1 F9 FF FF 8D B4 26 00 00 00 00 C7 44 24 70 00 00 00 00 E9 1D F6 FF FF 8D 76 00 8B 4C 24 60 2B 4C 24 78 8B 9C 24 90 00 00 00 89 4C 24 70 E9 02 F6 FF FF 85 FF 0F 84 F9 F9 FF FF 8B 54 24 74 F7 DB 8D 1C 9A EB 11 90 8D 74 26 00 83 C6 01 83 EF 01 0F 84 DD F9 FF FF 8B 45 58 8B 54 B3 F8 85 C0 0F 84 5B 04 00 00 8B 48 10 3B 48 14 0F 83 4F 04 00 00 83 FA FF 89 11 0F 94 C2 83 C1 04 89 48 10 84 D2 74 C7 E9 1A F2 FF FF 66 90 8B 4C 24 68 C7 44 24 04 20 00 00 00 89 2C 24 89 4C 24 08 E8 ?? ?? ?? ?? E9 AB F6 FF FF 8D 76 00 C7 84 24 90 00 00 00 FF 03 00 00 C7 84 24 98 00 00 00 01 00 00 00 29 8C 24 90 00 00 00 E9 46 F5 FF FF 8D B6 00 00 00 00 C7 84 24 90 00 00 00 02 40 00 00 C7 84 24 98 00 00 00 01 00 00 00 29 84 24 90 00 00 00 E9 1E F5 FF FF 8D B6 00 00 00 00 8B 45 14 3B 45 18 0F 83 27 05 00 00 C6 00 2B 83 C0 01 89 45 14 E9 83 F6 FF FF 8D B6 00 00 00 00 8B 44 24 68 85 C0 0F 8E 05 F7 FF FF 8B 44 24 5C }
	condition:
		$1
}

rule file_299_0_0 {
	meta:
		name = "__sched_setscheduler"
		size = 37
		refs = "0014 _dl_sysinfo 0020 __syscall_error"
	strings:
		$1 = { 53 8B 54 24 10 8B 4C 24 0C 8B 5C 24 08 B8 9C 00 00 00 FF 15 ?? ?? ?? ?? 5B 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_300_0_0 {
	meta:
		name = "_dl_runtime_resolve"
		size = 30
		refs = "000c _dl_fixup"
	strings:
		$1 = { 50 51 52 8B 54 24 10 8B 44 24 0C E8 ?? ?? ?? ?? 5A 8B 0C 24 89 04 24 8B 44 24 04 C2 0C 00 }
	condition:
		$1
}

rule file_300_1_0 {
	meta:
		name = "_dl_runtime_profile"
		size = 180
		refs = "002b _dl_profile_fixup 009d _dl_call_pltexit"
	strings:
		$1 = { 54 83 04 24 08 55 50 51 52 89 E1 83 EC 08 C7 44 24 04 FF FF FF FF 8D 54 24 04 89 14 24 51 8B 4C 24 28 8B 54 24 24 8B 44 24 20 E8 ?? ?? ?? ?? 8B 14 24 85 D2 79 0F 5A 5A 8B 0C 24 89 04 24 8B 44 24 04 C2 14 00 89 1C 24 89 D3 57 56 8D 74 24 2C 89 D9 83 CB 04 83 E3 FC 89 E7 29 DF 89 E3 89 FC C1 E9 02 F3 A5 8B 33 8B 7B 04 89 03 8B 53 0C 8B 4B 10 8B 43 14 FF 13 89 DC 8B 5C 24 08 83 EC 14 89 04 24 89 54 24 04 DB 7C 24 08 DB 7C 24 14 54 8D 4C 24 24 8B 44 24 38 8B 54 24 3C E8 ?? ?? ?? ?? 8B 04 24 8B 54 24 04 DB 6C 24 14 DB 6C 24 08 83 C4 3C C3 }
	condition:
		$1
}

rule file_302_0_0 {
	meta:
		name = "__correctly_grouped_prefixmb"
		size = 660
		refs = "001b strlen"
	strings:
		$1 = { 55 57 56 53 83 EC 3C 8B 44 24 5C 8B 7C 24 58 85 C0 0F 84 D7 00 00 00 89 3C 24 E8 ?? ?? ?? ?? 8B 54 24 50 39 54 24 54 0F 86 B0 00 00 00 83 E8 01 83 EA 01 89 44 24 20 89 FD 89 54 24 1C 8B 7C 24 54 83 EF 01 39 7C 24 50 0F 87 A0 00 00 00 0F B6 4D 00 8B 74 24 54 03 74 24 20 88 4C 24 26 EB 10 83 EF 01 83 EE 01 3B 7C 24 1C 0F 84 7E 00 00 00 0F B6 44 24 26 38 46 FF 75 E6 0F B6 45 01 84 C0 74 23 3A 46 FE 75 D9 8D 45 02 89 F2 EB 10 66 90 0F B6 5A FD 83 C0 01 83 EA 01 38 D9 75 C2 0F B6 08 84 C9 75 EB 39 7C 24 50 89 7C 24 2C 77 3F 8B 4C 24 5C 8B 54 24 54 0F BE 01 29 FA 83 C0 01 39 C2 74 3D 8D 0C 07 39 C2 0F 4F F9 89 7C 24 54 8B 44 24 54 39 44 24 50 0F 82 60 FF FF FF 8B 54 24 50 39 54 24 54 0F 43 54 24 54 89 54 24 54 8B 44 24 54 83 C4 3C 5B 5E 5F 5D C3 8D B6 00 00 00 00 89 4C 24 28 8D 74 26 00 8B 54 24 28 8B 44 24 28 0F B6 52 01 83 C0 01 84 D2 88 54 24 27 0F 85 4C 01 00 00 8B 4C 24 28 0F B6 09 88 4C 24 27 80 7C 24 27 00 8D 77 FF 0F 88 94 00 00 00 80 7C 24 27 7F 0F 84 89 00 00 00 39 74 24 50 0F 87 3F 01 00 00 03 7C 24 20 80 7C 24 26 00 0F 84 18 01 00 00 89 74 24 18 0F B6 54 24 26 3A 57 FF 0F 85 C6 00 00 00 8D 45 01 89 F9 EB 19 8D B4 26 00 00 00 00 0F B6 59 FE 83 C0 01 83 E9 01 38 DA 0F 85 A6 00 00 00 0F B6 10 84 D2 75 E7 8B 4C 24 18 39 4C 24 50 8B 7C 24 18 0F 87 E1 00 00 00 0F BE 44 24 27 2B 74 24 18 39 C6 0F 84 4C FF FF FF 8B 44 24 2C 83 E8 01 89 44 24 54 E9 03 FF FF FF 8D 74 26 00 39 74 24 50 0F 87 14 FF FF FF 03 7C 24 20 80 7C 24 26 00 74 28 0F B6 44 24 26 3A 47 FF 75 31 8D 45 01 89 F9 EB 10 66 90 0F B6 59 FE 83 C0 01 83 E9 01 38 DA 75 1A 0F B6 10 84 D2 75 EB 39 74 24 50 89 F7 0F 86 EF FE FF FF E9 D0 FE FF FF 66 90 83 EE 01 83 EF 01 39 74 24 1C 75 B9 8B 44 24 54 83 C4 3C 5B 5E 5F 5D C3 83 6C 24 18 01 83 EF 01 8B 4C 24 18 39 4C 24 1C 0F 85 16 FF FF FF 2B 74 24 1C 0F BE 44 24 27 39 F0 0F 8D 8F FE FF FF 8B 44 24 2C 83 E8 01 89 44 24 54 E9 60 FE FF FF 89 44 24 28 E9 B6 FE FF FF 89 74 24 18 8B 4C 24 18 89 F7 39 4C 24 50 0F 86 1F FF FF FF 29 FE EB C2 31 F6 EB BE }
	condition:
		$1
}

rule file_304_0_0 {
	meta:
		name = "add_pad"
		size = 110
		refs = "0048 memset"
	strings:
		$1 = { 53 89 C3 83 EC 28 8B 00 83 FA 01 8D 48 F4 74 50 85 D2 75 0C 01 C2 89 13 83 C4 28 5B C3 8D 76 00 C6 44 0B 0C 01 8D 04 0B 8D 4A FE 83 C0 0E 88 48 FF 8D 4A FE 89 4C 24 08 C7 44 24 04 00 00 00 00 89 04 24 89 54 24 1C E8 ?? ?? ?? ?? 8B 03 8B 54 24 1C 01 C2 89 13 83 C4 28 5B C3 90 8D 74 26 00 01 C2 C6 44 0B 0C 00 89 13 83 C4 28 5B C3 }
	condition:
		$1
}

rule file_304_1_0 {
	meta:
		name = "option_alloc"
		size = 212
		refs = "00c1 __assert_fail"
	strings:
		$1 = { 83 EC 2C 89 5C 24 1C 89 C3 8D 41 FF 83 F8 01 89 74 24 20 89 D6 8B 54 24 30 89 7C 24 24 89 6C 24 28 76 05 83 F9 04 75 70 83 FA 07 77 70 8B 3B 89 FD 83 ED 0C 0F 84 8B 00 00 00 21 C5 29 E9 21 C1 89 D8 01 CA E8 47 FF FF FF 8B 13 89 D8 8D 7A F4 01 F2 89 13 83 EA 0C F7 DA 83 E2 07 E8 2F FF FF FF 8B 03 83 E8 0C A8 07 75 37 C1 E8 03 83 E8 01 3D FF 00 00 00 7F 26 88 43 0D 8D 44 3B 0C 8B 5C 24 1C 8B 74 24 20 8B 7C 24 24 8B 6C 24 28 83 C4 2C C3 8D B6 00 00 00 00 83 F9 08 74 8B 31 C0 EB DD C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 D4 00 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C7 02 BD 02 00 00 00 89 3B E9 66 FF FF FF }
	condition:
		$1
}

rule file_304_2_0 {
	meta:
		name = "get_opt_end"
		size = 62
	strings:
		$1 = { 39 CA 73 34 80 3A 00 74 1F 53 8D 5A 02 39 D9 72 1F 0F B6 5A 01 8D 54 1A 02 39 D1 72 13 89 10 31 C0 5B C3 90 8D 74 26 00 83 C2 01 89 10 31 C0 C3 B8 FF FF FF FF 5B C3 90 B8 FF FF FF FF C3 }
	condition:
		$1
}

rule file_304_4_0 {
	meta:
		name = "inet6_option_init"
		size = 51
	strings:
		$1 = { 8B 54 24 0C 8B 44 24 04 83 FA 3B 75 1B 89 50 08 8B 54 24 08 C7 00 0C 00 00 00 C7 40 04 29 00 00 00 89 02 31 C0 C3 66 90 83 FA 36 74 E0 B8 FF FF FF FF C3 }
	condition:
		$1
}

rule file_304_5_0 {
	meta:
		name = "inet6_option_append"
		size = 87
		refs = "0040 memcpy"
	strings:
		$1 = { 56 BE 01 00 00 00 53 83 EC 14 8B 5C 24 24 80 3B 00 74 07 0F B6 73 01 83 C6 02 8B 44 24 2C 89 F2 8B 4C 24 28 89 04 24 8B 44 24 20 E8 60 FE FF FF 85 C0 74 1C 89 74 24 08 89 5C 24 04 89 04 24 E8 ?? ?? ?? ?? 31 C0 83 C4 14 5B 5E C3 8D 74 26 00 B8 FF FF FF FF EB EF }
	condition:
		$1
}

rule file_304_6_0 {
	meta:
		name = "inet6_option_alloc"
		size = 25
	strings:
		$1 = { 8B 54 24 10 8B 44 24 04 8B 4C 24 0C 89 54 24 04 8B 54 24 08 E9 17 FE FF FF }
	condition:
		$1
}

rule file_304_7_0 {
	meta:
		name = "inet6_option_next"
		size = 173
	strings:
		$1 = { 83 EC 1C 8B 44 24 20 89 5C 24 10 8B 5C 24 24 89 74 24 14 89 7C 24 18 83 78 04 29 75 6B 8B 50 08 83 FA 3B 75 5B 8B 10 83 FA 0D 76 5C 0F B6 48 0D 8D 0C CD 08 00 00 00 8D 71 0C 39 F2 72 4A 8B 13 8D 74 08 0C 85 D2 74 58 83 C0 0E 39 C2 72 39 8D 7C 24 0C 89 F1 89 F8 E8 94 FE FF FF 85 C0 75 28 8B 54 24 0C 89 13 89 F1 89 F8 E8 81 FE FF FF 8B 5C 24 10 8B 74 24 14 8B 7C 24 18 83 C4 1C C3 90 83 FA 36 74 A0 8D 76 00 B8 FF FF FF FF 8B 5C 24 10 8B 74 24 14 8B 7C 24 18 83 C4 1C C3 8D 76 00 8D 50 0E 89 54 24 0C 8D 7C 24 0C EB B7 }
	condition:
		$1
}

rule file_304_8_0 {
	meta:
		name = "inet6_option_find"
		size = 189
	strings:
		$1 = { 55 57 56 53 83 EC 10 8B 5C 24 24 8B 6C 24 2C 83 7B 04 29 75 70 8B 43 08 83 F8 3B 0F 85 91 00 00 00 8B 03 83 F8 0D 76 5D 0F B6 53 0D 8D 14 D5 08 00 00 00 8D 4A 0C 39 C8 72 4B 8B 44 24 28 8D 74 13 0C 83 C3 0E 8B 10 85 D2 74 5D 39 DA 72 36 8D 7C 24 0C 89 F1 89 F8 E8 E4 FD FF FF 85 C0 74 12 EB 23 8D B6 00 00 00 00 0F B6 03 39 E8 8D 76 00 74 26 8B 5C 24 0C 89 F1 89 DA 89 F8 E8 BF FD FF FF 85 C0 74 E3 83 C4 10 B8 FF FF FF FF 5B 5E 5F 5D C3 8D B6 00 00 00 00 8B 44 24 28 89 18 83 C4 10 31 C0 5B 5E 5F 5D C3 89 5C 24 0C 8D 7C 24 0C EB C4 83 F8 36 0F 84 66 FF FF FF EB C8 }
	condition:
		$1
}

rule file_305_0_0 {
	meta:
		name = "wcsrchr"
		size = 32
	strings:
		$1 = { 53 8B 54 24 08 31 C0 8B 5C 24 0C 90 8D 74 26 00 8B 0A 39 D9 0F 44 C2 83 C2 04 85 C9 75 F2 5B C3 }
	condition:
		$1
}

rule file_306_0_0 {
	meta:
		name = "__getcontext"
		size = 100
		refs = "0051 _dl_sysinfo 005d __syscall_error"
	strings:
		$1 = { 8B 44 24 04 C7 40 40 00 00 00 00 89 48 3C 89 50 38 89 78 24 89 70 28 89 68 2C 8B 0C 24 89 48 4C 8D 4C 24 04 89 48 30 89 58 34 31 D2 66 8C E2 89 50 18 8D 88 EC 00 00 00 89 48 60 D9 31 D9 21 53 8D 50 6C 31 C9 BB 00 00 00 00 B8 7E 00 00 00 FF 15 ?? ?? ?? ?? 5B 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? 31 C0 C3 }
	condition:
		$1
}

rule file_307_0_0 {
	meta:
		name = "splice"
		size = 135
		refs = "002d _dl_sysinfo 0042 __libc_enable_asynccancel 0076 __libc_disable_asynccancel 003c __syscall_error"
	strings:
		$1 = { 65 83 3D 0C 00 00 00 00 75 37 55 57 56 53 8B 6C 24 28 8B 7C 24 24 8B 74 24 20 8B 54 24 1C 8B 4C 24 18 8B 5C 24 14 B8 39 01 00 00 FF 15 ?? ?? ?? ?? 5B 5E 5F 5D 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 E8 ?? ?? ?? ?? 50 55 57 56 53 8B 6C 24 2C 8B 7C 24 28 8B 74 24 24 8B 54 24 20 8B 4C 24 1C 8B 5C 24 18 B8 39 01 00 00 FF 15 ?? ?? ?? ?? 5B 5E 5F 5D 87 04 24 E8 ?? ?? ?? ?? 58 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_307_1_0 {
	meta:
		name = "__splice_nocancel"
		size = 55
		refs = "0023 _dl_sysinfo 0032 __syscall_error"
	strings:
		$1 = { 55 57 56 53 8B 6C 24 28 8B 7C 24 24 8B 74 24 20 8B 54 24 1C 8B 4C 24 18 8B 5C 24 14 B8 39 01 00 00 FF 15 ?? ?? ?? ?? 5B 5E 5F 5D 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_308_0_0 {
	meta:
		name = "__wcsrtombs"
		size = 736
		refs = "003f _nl_current_LC_CTYPE 0094 __wcsnlen 00b5 _dl_mcount_wrapper_check 0128 __libc_errno 0150 __wcslen 0220 __assert_fail 027c _nl_C_LC_CTYPE 0285 __wcsmbs_load_conv 02b3 __wcsmbs_gconv_fcts_c"
	strings:
		$1 = { 55 BA ?? ?? ?? ?? 57 56 53 81 EC 7C 01 00 00 8B 84 24 9C 01 00 00 C7 44 24 6C 00 00 00 00 8B B4 24 90 01 00 00 C7 44 24 58 00 00 00 00 C7 44 24 5C 01 00 00 00 85 C0 0F 44 C2 89 44 24 60 A1 ?? ?? ?? ?? C7 44 24 54 01 00 00 00 65 8B 00 8B 18 8B 4B 14 85 C9 0F 84 1F 02 00 00 8B 43 14 8B 78 08 8B 17 8B 5F 14 85 D2 74 0A C1 CB 09 65 33 1D 18 00 00 00 85 F6 8B 84 24 94 01 00 00 0F 84 C5 00 00 00 8B 28 8B 84 24 98 01 00 00 89 2C 24 89 44 24 04 E8 ?? ?? ?? ?? 89 1C 24 89 74 24 4C 8D 44 85 04 8B AC 24 98 01 00 00 89 44 24 28 01 F5 89 6C 24 50 E8 ?? ?? ?? ?? 8B 44 24 28 8D 54 24 40 89 54 24 14 C7 44 24 1C 01 00 00 00 C7 44 24 18 00 00 00 00 89 44 24 0C 8B 84 24 94 01 00 00 C7 44 24 10 00 00 00 00 89 3C 24 89 44 24 08 8D 44 24 4C 89 44 24 04 FF D3 89 C2 8B 44 24 4C 89 C5 29 F5 F7 C2 FB FF FF FF 0F 85 DC 00 00 00 80 78 FF 00 0F 84 0F 01 00 00 83 FA 05 74 1A 85 D2 74 16 83 FA 04 74 11 A1 ?? ?? ?? ?? BD FF FF FF FF 65 C7 00 54 00 00 00 81 C4 7C 01 00 00 89 E8 5B 5E 5F 5D C3 8D 76 00 8B 30 31 ED 89 34 24 E8 ?? ?? ?? ?? 89 74 24 3C 8D 44 86 04 89 44 24 2C 8B 44 24 60 8D 74 24 70 8B 50 04 8B 00 89 54 24 48 89 44 24 44 8D 44 24 44 89 44 24 60 8D 84 24 70 01 00 00 89 44 24 50 89 1C 24 89 74 24 4C E8 ?? ?? ?? ?? 8D 44 24 40 89 44 24 14 8B 44 24 2C C7 44 24 1C 01 00 00 00 C7 44 24 18 00 00 00 00 C7 44 24 10 00 00 00 00 89 44 24 0C 8D 44 24 3C 89 44 24 08 8D 44 24 4C 89 44 24 04 89 3C 24 FF D3 8B 54 24 4C 89 D1 29 F1 01 CD 83 F8 05 74 A8 A9 FB FF FF FF 89 D1 89 C2 74 65 8D 42 FA 83 F8 01 0F 86 22 FF FF FF 83 FA 05 0F 84 38 FF FF FF C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 8B 00 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 74 26 00 39 C6 74 62 8B 44 24 60 8B 00 85 C0 0F 85 82 00 00 00 8B 84 24 94 01 00 00 C7 00 00 00 00 00 83 ED 01 E9 CA FE FF FF 90 80 79 FF 00 74 F1 C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 63 00 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 81 FB ?? ?? ?? ?? 74 30 89 D8 E8 ?? ?? ?? ?? E9 CD FD FF FF C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 7F 00 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 A2 FD FF FF C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 80 00 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_309_0_0 {
	meta:
		name = "__brk"
		size = 51
		refs = "000c _dl_sysinfo 0013 __curbrk 0021 __libc_errno"
	strings:
		$1 = { 53 8B 5C 24 08 B8 2D 00 00 00 FF 15 ?? ?? ?? ?? 89 C2 A3 ?? ?? ?? ?? 31 C0 39 D3 77 03 5B C3 90 A1 ?? ?? ?? ?? 65 C7 00 0C 00 00 00 B8 FF FF FF FF 5B C3 }
	condition:
		$1
}

rule file_311_0_0 {
	meta:
		name = "putw"
		size = 48
		refs = "0023 _IO_fwrite"
	strings:
		$1 = { 83 EC 1C 8B 44 24 24 C7 44 24 08 01 00 00 00 C7 44 24 04 04 00 00 00 89 44 24 0C 8D 44 24 20 89 04 24 E8 ?? ?? ?? ?? 83 F8 01 19 C0 83 C4 1C C3 }
	condition:
		$1
}

rule file_312_0_0 {
	meta:
		name = "__wctype_l"
		size = 122
		refs = "0011 strlen 0053 memcmp"
	strings:
		$1 = { 55 57 56 53 31 DB 83 EC 2C 8B 54 24 40 89 14 24 E8 ?? ?? ?? ?? 89 C6 8B 44 24 44 8B 00 89 44 24 1C 8B 68 4C EB 0F 66 90 8D 6C 3D 01 80 7D 00 00 74 3E 83 C3 01 89 2C 24 E8 ?? ?? ?? ?? 39 C6 89 C7 75 E5 8B 54 24 40 89 74 24 08 89 6C 24 04 89 14 24 E8 ?? ?? ?? ?? 85 C0 75 CD 8B 54 24 1C 03 5A 68 8B 44 9A 24 83 C4 2C 5B 5E 5F 5D C3 66 90 83 C4 2C 31 C0 5B 5E 5F 5D C3 }
	condition:
		$1
}

rule file_313_0_0 {
	meta:
		name = "free_database_entries"
		size = 97
		refs = "002d free 0035 __tdestroy"
	strings:
		$1 = { 57 89 C7 56 53 83 EC 10 85 C0 74 4D 8D 74 26 00 8B 5F 04 85 DB 75 0B EB 2E 8D B4 26 00 00 00 00 89 F3 8B 53 1C 85 D2 74 10 C7 44 24 04 ?? ?? ?? ?? 89 14 24 E8 ?? ?? ?? ?? 8B 33 89 1C 24 E8 ?? ?? ?? ?? 85 F6 75 D9 8B 1F 89 3C 24 E8 ?? ?? ?? ?? 85 DB 74 04 89 DF EB B7 83 C4 10 5B 5E 5F 90 C3 }
	condition:
		$1
}

rule file_313_1_0 {
	meta:
		name = "known_compare"
		size = 35
		refs = "0019 strcmp"
	strings:
		$1 = { 8B 44 24 04 8B 54 24 08 39 D0 74 14 8B 12 89 54 24 08 8B 00 89 44 24 04 E9 ?? ?? ?? ?? 8D 76 00 31 C0 C3 }
	condition:
		$1
}

rule file_313_2_0 {
	meta:
		name = "nss_parse_service_list"
		size = 949
		refs = "000b __libc_tsd_CTYPE_B 0087 malloc 00ad mempcpy 01d6 __strncasecmp 031c free"
	strings:
		$1 = { 55 57 56 89 C6 53 83 EC 3C 8B 15 ?? ?? ?? ?? C7 44 24 2C 00 00 00 00 65 8B 3A 8D 54 24 2C 89 54 24 14 89 FD 8D 74 26 00 0F B6 06 0F BE C8 F6 44 4D 01 20 0F 85 EE 00 00 00 84 C0 0F 84 DF 02 00 00 3C 5B 0F 84 D7 02 00 00 89 F3 90 8D 74 26 00 EB 14 8D B6 00 00 00 00 0F BE D0 F6 44 55 01 20 75 0E 3C 5B 74 0A 83 C3 01 0F B6 03 84 C0 75 E8 39 DE 0F 84 A8 02 00 00 89 DA 29 F2 8D 42 25 89 04 24 89 54 24 10 E8 ?? ?? ?? ?? 8B 54 24 10 85 C0 89 C7 0F 84 87 02 00 00 83 C0 24 89 47 20 89 74 24 04 89 DE 89 54 24 08 89 04 24 E8 ?? ?? ?? ?? C6 00 00 C7 47 1C 00 00 00 00 C7 47 04 00 00 00 00 C7 47 08 00 00 00 00 C7 47 0C 00 00 00 00 C7 47 10 01 00 00 00 C7 47 14 01 00 00 00 C7 47 18 00 00 00 00 C7 07 00 00 00 00 0F B6 03 0F BE C8 F6 44 4D 01 20 74 10 83 C6 01 0F B6 06 0F BE D0 F6 44 55 01 20 75 F0 3C 5B 74 24 8B 54 24 14 89 7C 24 14 89 3A 0F B6 06 0F BE C8 F6 44 4D 01 20 0F 84 12 FF FF FF 83 C6 01 E9 F9 FE FF FF 90 83 C6 01 0F B6 06 84 C0 74 0A 0F BE D0 F6 44 55 01 20 75 EC 8B 15 ?? ?? ?? ?? 65 8B 2A 31 D2 3C 21 0F 94 C2 89 54 24 18 75 07 0F B6 46 01 83 C6 01 84 C0 0F 84 AF 01 00 00 0F BE C8 F6 44 4D 01 20 0F 85 A1 01 00 00 3C 3D 0F 84 99 01 00 00 3C 5D 0F 84 91 01 00 00 89 F3 EB 17 90 8D 74 26 00 0F BE D0 F6 44 55 01 20 75 12 3C 3D 74 0E 3C 5D 74 0A 83 C3 01 0F B6 03 84 C0 75 E4 89 D8 29 F0 83 F8 07 0F 84 77 01 00 00 83 F8 08 0F 85 56 01 00 00 C7 44 24 08 08 00 00 00 C7 44 24 04 ?? ?? ?? ?? 89 34 24 E8 ?? ?? ?? ?? 85 C0 0F 85 06 01 00 00 C7 44 24 1C 00 00 00 00 EB 07 8D 74 26 00 83 C3 01 0F B6 03 0F BE D0 F6 44 55 01 20 75 F0 3C 3D 0F 85 10 01 00 00 83 C3 01 0F B6 03 0F BE D0 F6 44 55 01 20 75 F0 84 C0 89 D9 0F 84 F6 00 00 00 3C 3D 0F 84 EE 00 00 00 3C 5D 75 1C 66 90 E9 E3 00 00 00 8D 76 00 0F BE D0 F6 44 55 01 20 75 12 3C 3D 74 0E 3C 5D 74 0A 83 C3 01 0F B6 03 84 C0 75 E4 89 D8 29 C8 83 F8 06 0F 84 17 01 00 00 83 F8 08 89 DE 0F 85 AC 00 00 00 C7 44 24 08 08 00 00 00 C7 44 24 04 ?? ?? ?? ?? 89 0C 24 E8 ?? ?? ?? ?? 85 C0 0F 85 8C 00 00 00 8B 4C 24 18 8B 54 24 1C 85 C9 74 48 83 C2 02 8B 4C 97 04 89 47 04 89 47 08 89 47 0C 89 47 10 89 4C 97 04 0F B6 03 0F BE C8 F6 44 4D 01 20 74 14 8D 74 26 00 83 C6 01 0F B6 06 0F BE D0 F6 44 55 01 20 75 F0 3C 5D 0F 84 C8 00 00 00 0F B6 06 E9 6D FE FF FF 89 44 97 0C EB C9 66 90 C7 44 24 08 08 00 00 00 C7 44 24 04 ?? ?? ?? ?? 89 34 24 E8 ?? ?? ?? ?? 85 C0 75 14 C7 44 24 1C FE FF FF FF E9 E2 FE FF FF 8D B4 26 00 00 00 00 89 3C 24 E8 ?? ?? ?? ?? 8B 44 24 2C 83 C4 3C 5B 5E 5F 5D C3 8D 74 26 00 C7 44 24 08 07 00 00 00 C7 44 24 04 ?? ?? ?? ?? 89 34 24 E8 ?? ?? ?? ?? 85 C0 74 5C C7 44 24 08 07 00 00 00 C7 44 24 04 ?? ?? ?? ?? 89 34 24 E8 ?? ?? ?? ?? 85 C0 75 B0 C7 44 24 1C FF FF FF FF E9 7E FE FF FF 8D 76 00 C7 44 24 08 06 00 00 00 C7 44 24 04 ?? ?? ?? ?? 89 0C 24 E8 ?? ?? ?? ?? 85 C0 75 84 89 DE B8 01 00 00 00 E9 EC FE FF FF 83 C6 01 E9 64 FD FF FF C7 44 24 1C 01 00 00 00 E9 3E FE FF FF }
	condition:
		$1
}

rule file_313_10_0 {
	meta:
		name = "__nss_database_lookup"
		size = 861
		refs = "0093 strcmp 012f malloc 0169 _IO_new_fopen 01ed __getline 0216 __strchrnul 022a __libc_tsd_CTYPE_B 029b strlen 02c9 memcpy 0318 free 0324 _IO_new_fclose"
	strings:
		$1 = { 83 EC 5C 31 C0 89 5C 24 4C B9 01 00 00 00 8B 5C 24 6C 89 74 24 50 8B 74 24 60 89 7C 24 54 89 6C 24 58 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 0D ?? ?? ?? ?? 0F 85 63 08 00 00 8B 03 85 C0 74 30 65 83 3D 0C 00 00 00 00 74 01 F0 83 2D ?? ?? ?? ?? 01 0F 85 55 08 00 00 31 C0 8B 5C 24 4C 8B 74 24 50 8B 7C 24 54 8B 6C 24 58 83 C4 5C C3 66 90 8B 2D ?? ?? ?? ?? 85 ED 0F 84 DB 00 00 00 8B 7D 00 85 FF 74 21 8D 76 00 8B 47 08 89 34 24 89 44 24 04 E8 ?? ?? ?? ?? 85 C0 75 05 8B 47 04 89 03 8B 3F 85 FF 75 E2 8B 03 85 C0 74 24 65 83 3D 0C 00 00 00 00 74 01 F0 83 2D ?? ?? ?? ?? 01 0F 85 F9 07 00 00 83 3B 01 19 C0 EB 8F 90 8D 74 26 00 8B 7C 24 64 85 FF 74 30 8B 75 00 85 F6 74 29 90 8B 46 08 89 44 24 04 8B 44 24 64 89 04 24 E8 ?? ?? ?? ?? 85 C0 75 05 8B 46 04 89 03 8B 36 85 F6 75 DE 8B 03 85 C0 75 A4 8B 74 24 68 B8 ?? ?? ?? ?? 85 F6 0F 45 44 24 68 89 44 24 68 E8 1F FB FF FF 85 C0 89 03 74 85 C7 04 24 0D 00 00 00 E8 ?? ?? ?? ?? 85 C0 0F 84 71 FF FF FF 8B 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? 89 10 8B 13 C7 40 08 ?? ?? ?? ?? 89 50 04 E9 53 FF FF FF C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 89 44 24 18 0F 84 D5 01 00 00 81 08 00 80 00 00 C7 04 24 08 00 00 00 E8 ?? ?? ?? ?? 85 C0 0F 84 AF 01 00 00 89 5C 24 2C 8B 5C 24 18 C7 00 00 00 00 00 C7 40 04 00 00 00 00 C7 44 24 38 00 00 00 00 C7 44 24 3C 00 00 00 00 C7 44 24 1C 00 00 00 00 89 44 24 24 89 74 24 28 EB 0F 8D B6 00 00 00 00 F6 03 10 0F 85 2B 01 00 00 8D 44 24 3C 89 44 24 04 8D 44 24 38 89 5C 24 08 89 04 24 E8 ?? ?? ?? ?? 85 C0 0F 88 0B 01 00 00 8B 54 24 38 8D 44 02 FF 80 38 0A 0F 84 EE 00 00 00 89 14 24 C7 44 24 04 23 00 00 00 E8 ?? ?? ?? ?? C6 00 00 8B 6C 24 38 0F B6 55 00 84 D2 74 A7 A1 ?? ?? ?? ?? 0F BE F2 65 8B 00 F6 44 70 01 20 74 1E 90 8D 74 26 00 83 C5 01 0F B6 55 00 0F BE CA F6 44 48 01 20 75 EF 84 D2 0F 84 77 FF FF FF 80 FA 3A 0F 84 6E FF FF FF 89 EE EB 07 66 90 80 FA 3A 74 18 83 C6 01 0F B6 16 84 D2 0F 84 55 FF FF FF 0F BE CA F6 44 48 01 20 74 E3 39 EE 0F 84 43 FF FF FF C6 06 00 83 C6 01 89 2C 24 89 74 24 20 E8 ?? ?? ?? ?? 8D 78 01 83 C0 0D 89 04 24 E8 ?? ?? ?? ?? 85 C0 89 C6 0F 84 19 FF FF FF 83 C0 0C 89 46 08 89 7C 24 08 89 6C 24 04 89 04 24 E8 ?? ?? ?? ?? 8B 44 24 20 E8 6A F9 FF FF C7 06 00 00 00 00 89 46 04 8B 44 24 1C 85 C0 74 4C 8B 44 24 1C 89 30 89 74 24 1C E9 DA FE FF FF 66 90 C6 00 00 8B 54 24 38 E9 06 FF FF FF 8B 44 24 38 8B 6C 24 24 8B 74 24 28 8B 5C 24 2C 89 04 24 E8 ?? ?? ?? ?? 8B 44 24 18 89 04 24 E8 ?? ?? ?? ?? 89 2D ?? ?? ?? ?? E9 4B FD FF FF 8B 44 24 24 89 30 89 74 24 1C E9 8E FE FF FF 8B 44 24 18 89 04 24 E8 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 00 00 00 00 E9 A5 FD FF FF }
	condition:
		$1
}

rule file_313_11_0 {
	meta:
		name = "__nss_configure_lookup"
		size = 189
		refs = "0023 strcmp 0037 __libc_errno 0096 __nss_database_custom"
	strings:
		$1 = { 55 57 56 53 31 DB 83 EC 1C 8B 7C 24 30 8D 76 00 89 DE C1 E6 04 81 C6 ?? ?? ?? ?? 89 74 24 04 89 3C 24 E8 ?? ?? ?? ?? 83 F8 00 74 2C 7C 08 83 C3 01 83 FB 0E 75 DA A1 ?? ?? ?? ?? BF FF FF FF FF 65 C7 00 16 00 00 00 83 C4 1C 89 F8 5B 5E 5F 5D C3 8D B4 26 00 00 00 00 8B 46 0C 31 FF 85 C0 74 E6 8B 44 24 34 E8 76 F8 FF FF 85 C0 89 C5 74 C6 89 F8 B9 01 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 0D ?? ?? ?? ?? 0F 85 DE 04 00 00 8B 46 0C 89 28 C6 83 ?? ?? ?? ?? 01 65 83 3D 0C 00 00 00 00 74 01 F0 83 2D ?? ?? ?? ?? 01 0F 85 CA 04 00 00 83 C4 1C 89 F8 5B 5E 5F 5D C3 }
	condition:
		$1
}

rule file_313_12_0 {
	meta:
		name = "__nss_lookup_function"
		size = 738
		refs = "0047 __tsearch 0098 malloc 00e1 strlen 011a stpcpy 012c strcpy 0141 __libc_dlsym 01b2 strcmp 01df __tdelete 01ea free 0207 __libc_errno 025f __libc_dlopen_mode"
	strings:
		$1 = { 55 31 C0 89 E5 B9 01 00 00 00 83 EC 38 89 5D F4 89 75 F8 89 7D FC 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 0D ?? ?? ?? ?? 0F 85 9F 04 00 00 8B 75 08 8D 7D 0C C7 44 24 08 ?? ?? ?? ?? 89 3C 24 83 C6 1C 89 74 24 04 E8 ?? ?? ?? ?? 85 C0 0F 84 15 01 00 00 89 C3 8B 00 39 F8 74 35 8B 50 04 C1 CA 09 65 33 15 18 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 83 2D ?? ?? ?? ?? 01 0F 85 5D 04 00 00 8B 5D F4 89 D0 8B 75 F8 8B 7D FC 89 EC 5D C3 90 C7 04 24 08 00 00 00 E8 ?? ?? ?? ?? 85 C0 89 45 E4 0F 84 28 01 00 00 8B 45 E4 8B 55 E4 89 03 8B 45 0C 89 02 8B 55 08 8B 5A 18 85 DB 0F 84 AE 00 00 00 8B 43 04 85 C0 0F 84 28 01 00 00 31 D2 83 F8 FF 74 76 8B 55 08 89 65 E0 8B 5A 20 89 1C 24 E8 ?? ?? ?? ?? 8B 75 0C 89 34 24 89 C7 E8 ?? ?? ?? ?? 8D 44 07 16 83 E0 F0 29 C4 8D 44 24 11 C7 44 24 0C 5F 6E 73 73 8D 7C 24 0C 66 C7 44 24 10 5F 00 89 5C 24 04 89 04 24 E8 ?? ?? ?? ?? C6 00 5F 83 C0 01 89 74 24 04 89 04 24 E8 ?? ?? ?? ?? 89 7C 24 04 8B 55 08 8B 42 18 8B 40 04 89 04 24 E8 ?? ?? ?? ?? 8B 65 E0 89 C2 8B 4D E4 89 D0 65 33 05 18 00 00 00 C1 C0 09 89 41 04 E9 07 FF FF FF 8D B4 26 00 00 00 00 31 D2 E9 F9 FE FF FF 90 A1 ?? ?? ?? ?? 8B 4A 20 BA ?? ?? ?? ?? 85 C0 0F 44 C2 8B 58 04 89 4D E0 85 DB 75 19 E9 4C 01 00 00 8D B4 26 00 00 00 00 8B 43 08 85 C0 0F 84 E0 00 00 00 89 C3 8B 55 E0 89 54 24 04 8B 03 89 04 24 E8 ?? ?? ?? ?? 85 C0 75 DE 8B 55 08 89 5A 18 E9 FD FE FF FF 8B 55 08 C7 42 18 00 00 00 00 C7 44 24 08 ?? ?? ?? ?? 89 74 24 04 89 3C 24 E8 ?? ?? ?? ?? 8B 45 E4 89 04 24 E8 ?? ?? ?? ?? 31 D2 E9 73 FE FF FF 8B 55 08 89 E6 8B 5A 20 89 1C 24 E8 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 65 8B 09 83 C0 1C 83 E0 F0 29 C4 8D 44 24 13 89 4D E0 8D 7C 24 0C 89 5C 24 04 C7 44 24 0C 6C 69 62 6E C7 44 24 10 73 73 5F 00 89 04 24 E8 ?? ?? ?? ?? C7 00 2E 73 6F 00 C6 40 05 00 66 C7 40 03 2E 32 8B 55 08 8B 5A 18 C7 44 24 04 01 00 00 80 89 3C 24 E8 ?? ?? ?? ?? 8B 55 08 89 43 04 8B 42 18 8B 50 04 85 D2 74 55 8B 55 08 89 F4 8B 42 18 8B 40 04 E9 4A FE FF FF 83 C3 08 C7 04 24 0C 00 00 00 E8 ?? ?? ?? ?? 85 C0 89 03 0F 84 29 FF FF FF 8B 4D E0 8B 55 08 89 08 8B 03 C7 40 04 00 00 00 00 8B 03 C7 40 08 00 00 00 00 8B 1B 85 DB 89 5A 18 0F 85 FF FD FF FF E9 07 FF FF FF 8B 55 E0 8B 0D ?? ?? ?? ?? C7 40 04 FF FF FF FF 65 89 11 EB 96 8D 58 04 EB A4 }
	condition:
		$1
}

rule file_313_13_0 {
	meta:
		name = "__nss_next2"
		size = 222
		refs = "003b __nss_lookup_function 00da __libc_fatal"
	strings:
		$1 = { 55 57 56 53 83 EC 1C 8B 44 24 44 8B 5C 24 30 8B 7C 24 34 8B 6C 24 38 85 C0 8B 74 24 3C 74 69 8B 03 83 78 04 01 0F 84 85 00 00 00 8B 00 85 C0 74 47 89 03 89 7C 24 04 89 04 24 E8 ?? ?? ?? ?? 85 C0 89 06 74 0B 83 C4 1C 31 C0 5B 5E 5F 5D C3 90 85 ED 74 14 89 6C 24 04 8B 03 89 04 24 E8 ?? ?? ?? ?? 85 C0 89 06 75 DD 8B 03 8B 48 08 85 C9 74 BA 8D B4 26 00 00 00 00 83 C4 1C B8 FF FF FF FF 5B 5E 5F 5D C3 8D 76 00 8B 54 24 40 83 C2 02 83 FA 04 77 3E 8B 03 83 7C 90 04 01 75 8E 83 C4 1C B8 01 00 00 00 5B 5E 5F 5D C3 8D B6 00 00 00 00 83 78 08 01 0F 85 71 FF FF FF 83 78 0C 01 0F 85 67 FF FF FF 83 78 10 01 0F 85 5D FF FF FF 66 90 EB CB C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_313_14_0 {
	meta:
		name = "__nss_lookup"
		size = 173
		refs = "0021 __nss_lookup_function"
	strings:
		$1 = { 55 57 56 53 83 EC 1C 8B 5C 24 30 8B 7C 24 34 8B 74 24 3C 8B 6C 24 38 89 7C 24 04 8B 03 89 04 24 E8 ?? ?? ?? ?? 85 C0 89 06 74 15 90 8D 74 26 00 83 C4 1C 31 C0 5B 5E 5F 5D C3 8D B6 00 00 00 00 85 ED 75 06 EB 14 85 ED 74 14 89 6C 24 04 8B 03 89 04 24 E8 ?? ?? ?? ?? 89 06 85 C0 75 D2 8B 03 8B 50 08 85 D2 75 21 8B 00 85 C0 74 33 89 03 89 7C 24 04 89 04 24 E8 ?? ?? ?? ?? 85 C0 89 06 75 AF EB C3 90 8D 74 26 00 8B 00 85 C0 74 12 83 C4 1C B8 FF FF FF FF 5B 5E 5F 5D C3 90 8D 74 26 00 83 C4 1C B8 01 00 00 00 5B 5E 5F 5D C3 }
	condition:
		$1
}

rule file_313_16_0 {
	meta:
		name = "free_mem"
		size = 114
		refs = "0037 free 0050 __libc_dlclose"
	strings:
		$1 = { 57 56 53 83 EC 10 8B 3D ?? ?? ?? ?? 85 FF 74 5B 8B 07 C7 05 ?? ?? ?? ?? 00 00 00 00 E8 ?? ?? ?? ?? 8B 5F 04 85 DB 75 19 EB 39 8D B6 00 00 00 00 8B 73 08 89 1C 24 E8 ?? ?? ?? ?? 85 F6 74 24 89 F3 8B 43 04 8D 50 FF 83 FA FD 77 E4 89 04 24 E8 ?? ?? ?? ?? 8B 73 08 89 1C 24 E8 ?? ?? ?? ?? 85 F6 75 DC 89 3C 24 E8 ?? ?? ?? ?? 83 C4 10 5B 5E 5F C3 }
	condition:
		$1
}

rule file_313_17_0 {
	meta:
		name = "__nss_next"
		size = 59
		refs = "0033 __nss_next2"
	strings:
		$1 = { 83 EC 2C 8B 44 24 40 C7 44 24 08 00 00 00 00 89 44 24 14 8B 44 24 3C 89 44 24 10 8B 44 24 38 89 44 24 0C 8B 44 24 34 89 44 24 04 8B 44 24 30 89 04 24 E8 ?? ?? ?? ?? 83 C4 2C C3 }
	condition:
		$1
}

rule file_314_0_0 {
	meta:
		name = "__sleep"
		size = 554
		refs = "007c __sigprocmask 00c2 __sigaction 0103 __nanosleep 015a __libc_errno 0226 __pthread_unwind"
	strings:
		$1 = { 55 57 56 53 81 EC BC 01 00 00 8B 9C 24 D0 01 00 00 85 DB 0F 84 E0 01 00 00 C7 44 24 20 00 00 00 00 31 D2 8D 74 24 24 8D 6C 24 1C EB 0F 8D 76 00 85 DB 0F 84 D9 00 00 00 8B 54 24 1C 81 FB FF FF FF 7F B8 FF FF FF 7F 0F 46 C3 B9 20 00 00 00 01 D0 89 F7 89 44 24 1C 29 C3 31 C0 F3 AB 8D 84 24 A4 00 00 00 89 44 24 08 89 74 24 04 C7 04 24 00 00 00 00 C7 44 24 24 00 00 01 00 E8 ?? ?? ?? ?? 85 C0 0F 85 C0 00 00 00 8B 84 24 A4 00 00 00 25 00 00 01 00 75 65 B9 20 00 00 00 89 F7 F3 AB 8D 84 24 24 01 00 00 89 44 24 08 C7 44 24 04 00 00 00 00 C7 04 24 11 00 00 00 C7 44 24 24 00 00 01 00 E8 ?? ?? ?? ?? 85 C0 0F 88 8A 00 00 00 83 BC 24 24 01 00 00 01 0F 84 B4 00 00 00 8D 84 24 A4 00 00 00 C7 44 24 08 00 00 00 00 89 44 24 04 C7 04 24 02 00 00 00 E8 ?? ?? ?? ?? 89 6C 24 04 89 2C 24 E8 ?? ?? ?? ?? 85 C0 89 C7 0F 84 1F FF FF FF 85 FF 75 13 31 C0 81 C4 BC 01 00 00 5B 5E 5F 5D C3 8D B6 00 00 00 00 31 C0 81 7C 24 20 FF 64 CD 1D 0F 9F C0 03 44 24 1C 81 C4 BC 01 00 00 01 D8 5B 5E 5F 5D C3 66 90 81 C4 BC 01 00 00 B8 FF FF FF FF 5B 5E 5F 5D C3 8B 1D ?? ?? ?? ?? 8D 84 24 A4 00 00 00 65 8B 33 C7 44 24 08 00 00 00 00 89 44 24 04 C7 04 24 02 00 00 00 E8 ?? ?? ?? ?? B8 FF FF FF FF 65 89 33 EB 8D 8D B6 00 00 00 00 8D 6C 24 1C BE FF FF FF 7F EB 1C 90 8D 74 26 00 85 DB 74 25 81 FB FE FF FF 7F 89 F0 0F 46 C3 2B 5C 24 20 89 44 24 1C 89 6C 24 04 89 2C 24 E8 ?? ?? ?? ?? 85 C0 89 C7 74 D7 8B 35 ?? ?? ?? ?? 8D 84 24 A4 00 00 00 65 8B 2E C7 44 24 08 00 00 00 00 89 44 24 04 C7 04 24 02 00 00 00 E8 ?? ?? ?? ?? 65 89 2E E9 18 FF FF FF 65 A1 84 00 00 00 83 E0 B9 83 F8 08 0F 85 0A FF FF FF 65 C7 05 28 02 00 00 FF FF FF FF F0 65 83 0D 84 00 00 00 10 65 A1 80 00 00 00 E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_315_0_0 {
	meta:
		name = "posix_spawnattr_getschedparam"
		size = 19
	strings:
		$1 = { 8B 44 24 04 8B 90 08 01 00 00 8B 44 24 08 89 10 31 C0 C3 }
	condition:
		$1
}

rule file_316_0_0 {
	meta:
		name = "skip_string"
		size = 57
		refs = "0009 __libc_tsd_CTYPE_B"
	strings:
		$1 = { 0F B6 10 84 D2 74 30 8B 0D ?? ?? ?? ?? 53 65 8B 19 EB 19 90 8D 74 26 00 80 FA 23 74 19 80 FA 2C 74 14 83 C0 01 0F B6 10 84 D2 74 0A 0F BE CA F6 44 4B 01 20 74 E2 5B F3 C3 }
	condition:
		$1
}

rule file_316_1_0 {
	meta:
		name = "arg_trimdomain_list"
		size = 409
		refs = "0010 _res_hconf 003a __strndup 0046 __libc_tsd_CTYPE_B 00ec _libc_intl_domainname 00f1 __dcgettext 0119 __asprintf 0139 __fxprintf 0145 free"
	strings:
		$1 = { 55 57 BF 00 00 03 80 56 53 89 CB 83 EC 4C 8B 2D ?? ?? ?? ?? 89 44 24 28 89 54 24 2C 89 D8 E8 9D FF FF FF 89 C6 29 D8 83 FD 03 0F 8F A9 00 00 00 89 1C 24 89 F3 89 44 24 04 E8 ?? ?? ?? ?? 89 04 AD ?? ?? ?? ?? A1 ?? ?? ?? ?? 83 C5 01 89 2D ?? ?? ?? ?? 0F B6 0E 65 8B 10 0F BE C1 F6 44 42 01 20 74 15 90 8D 74 26 00 83 C3 01 0F B6 0B 0F BE C1 F6 44 42 01 20 75 F0 83 E9 2C 80 F9 0F 77 40 89 F8 D3 E0 85 C0 79 38 0F B6 43 01 8D 73 01 89 F3 0F BE C8 F6 44 4A 01 20 74 15 90 8D 74 26 00 83 C3 01 0F B6 03 0F BE C8 F6 44 4A 01 20 75 F0 3C 23 0F 84 9D 00 00 00 84 C0 0F 84 95 00 00 00 0F B6 03 3C 23 74 08 84 C0 0F 85 4D FF FF FF 83 C4 4C 89 D8 5B 5E 5F 5D C3 C7 44 24 08 05 00 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 54 24 2C C7 44 24 10 04 00 00 00 89 54 24 0C 8B 54 24 28 89 44 24 04 8D 44 24 3C 89 04 24 89 54 24 08 E8 ?? ?? ?? ?? 85 C0 78 28 8B 44 24 3C C7 44 24 04 ?? ?? ?? ?? C7 04 24 00 00 00 00 89 44 24 08 E8 ?? ?? ?? ?? 8B 44 24 3C 89 04 24 E8 ?? ?? ?? ?? 31 DB 83 C4 4C 89 D8 5B 5E 5F 5D C3 C7 44 24 08 05 00 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 54 24 2C 89 54 24 0C 8B 54 24 28 89 44 24 04 8D 44 24 3C 89 04 24 89 54 24 08 E8 ?? ?? ?? ?? 85 C0 79 8C 31 DB EB B2 }
	condition:
		$1
}

rule file_316_2_0 {
	meta:
		name = "arg_spoof.isra.1"
		size = 165
		refs = "0023 _res_hconf 004f __strncasecmp"
	strings:
		$1 = { 83 EC 1C 89 5C 24 10 89 74 24 14 89 C6 89 7C 24 18 E8 0A FE FF FF 89 C2 89 C3 29 F2 83 FA 03 74 57 8B 3D ?? ?? ?? ?? 89 F8 83 C8 06 83 FA 06 A3 ?? ?? ?? ?? 74 22 83 FA 04 75 1D C7 44 24 08 04 00 00 00 C7 44 24 04 ?? ?? ?? ?? 89 34 24 E8 ?? ?? ?? ?? 85 C0 74 0E 90 89 F8 83 E0 FB 83 C8 02 A3 ?? ?? ?? ?? 89 D8 8B 74 24 14 8B 5C 24 10 8B 7C 24 18 83 C4 1C C3 90 C7 44 24 08 03 00 00 00 C7 44 24 04 ?? ?? ?? ?? 89 34 24 E8 ?? ?? ?? ?? 8B 3D ?? ?? ?? ?? 85 C0 75 BE 83 E7 F9 89 3D ?? ?? ?? ?? EB C0 }
	condition:
		$1
}

rule file_316_3_0 {
	meta:
		name = "arg_bool"
		size = 251
		refs = "0029 __strncasecmp 003a _res_hconf 00a3 _libc_intl_domainname 00a8 __dcgettext 00c4 __asprintf 00e4 __fxprintf 00f0 free"
	strings:
		$1 = { 83 EC 3C C7 44 24 08 02 00 00 00 C7 44 24 04 ?? ?? ?? ?? 89 0C 24 89 5C 24 30 89 CB 89 74 24 34 89 C6 89 7C 24 38 89 D7 E8 ?? ?? ?? ?? 85 C0 75 1F 8B 54 24 40 8D 43 02 09 15 ?? ?? ?? ?? 8B 5C 24 30 8B 74 24 34 8B 7C 24 38 83 C4 3C C3 66 90 C7 44 24 08 03 00 00 00 C7 44 24 04 ?? ?? ?? ?? 89 1C 24 E8 ?? ?? ?? ?? 85 C0 75 24 8B 54 24 40 8D 43 03 8B 5C 24 30 8B 74 24 34 8B 7C 24 38 F7 D2 21 15 ?? ?? ?? ?? 83 C4 3C C3 90 8D 74 26 00 C7 44 24 08 05 00 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 5C 24 10 89 7C 24 0C 89 74 24 08 89 44 24 04 8D 44 24 2C 89 04 24 E8 ?? ?? ?? ?? 85 C0 78 28 8B 44 24 2C C7 44 24 04 ?? ?? ?? ?? C7 04 24 00 00 00 00 89 44 24 08 E8 ?? ?? ?? ?? 8B 44 24 2C 89 04 24 E8 ?? ?? ?? ?? 31 C0 E9 43 FF FF FF }
	condition:
		$1
}

rule file_316_4_0 {
	meta:
		name = "do_init"
		size = 899
		refs = "0002 _res_hconf 0022 getenv 0046 _IO_new_fopen 0080 fgets_unlocked 00a5 __strchrnul 00ab __libc_tsd_CTYPE_B 0117 __strncasecmp 0174 _libc_intl_domainname 0179 __dcgettext 019d __asprintf 01c1 __fxprintf 01cd free 01de _IO_new_fclose"
	strings:
		$1 = { 55 BA ?? ?? ?? ?? 57 31 C0 56 89 D7 53 B9 0C 00 00 00 81 EC 5C 01 00 00 F3 AB C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 44 24 04 ?? ?? ?? ?? 89 44 24 34 85 C0 B8 ?? ?? ?? ?? 0F 45 44 24 34 89 04 24 89 44 24 34 E8 ?? ?? ?? ?? 85 C0 89 44 24 30 0F 84 8C 01 00 00 81 08 00 80 00 00 C7 44 24 2C 00 00 00 00 8D 74 26 00 8B 44 24 30 8D 54 24 50 C7 44 24 04 00 01 00 00 89 14 24 89 44 24 08 E8 ?? ?? ?? ?? 85 C0 0F 84 4A 01 00 00 8D 44 24 50 C7 44 24 04 0A 00 00 00 8D 5C 24 50 89 04 24 83 44 24 2C 01 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? C6 00 00 0F B6 44 24 50 65 8B 32 0F BE D0 F6 44 56 01 20 74 14 8D 74 26 00 83 C3 01 0F B6 03 0F BE D0 F6 44 56 01 20 75 F0 3C 23 74 8C 84 C0 74 88 89 D8 E8 89 FB FF FF 31 D2 89 74 24 3C 89 D7 89 C1 29 D9 89 44 24 38 89 CE 8D B4 26 00 00 00 00 89 FD C1 E5 04 81 C5 ?? ?? ?? ?? 89 74 24 08 89 6C 24 04 89 1C 24 E8 ?? ?? ?? ?? 85 C0 75 3A 89 EA 8B 0A 83 C2 04 8D 81 FF FE FE FE F7 D1 21 C8 25 80 80 80 80 74 EA 89 C1 C1 E9 10 A9 80 80 00 00 0F 44 C1 8D 4A 02 0F 44 D1 00 C0 83 DA 03 29 EA 39 D6 0F 84 4F 01 00 00 83 C7 01 83 FF 07 75 9F C7 44 24 08 05 00 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 54 24 2C 89 5C 24 10 89 54 24 0C 8B 54 24 34 89 44 24 04 8D 44 24 4C 89 04 24 89 54 24 08 E8 ?? ?? ?? ?? 85 C0 0F 88 BF FE FF FF 8B 44 24 4C C7 44 24 04 ?? ?? ?? ?? C7 04 24 00 00 00 00 89 44 24 08 E8 ?? ?? ?? ?? 8B 44 24 4C 89 04 24 E8 ?? ?? ?? ?? E9 92 FE FF FF 8B 44 24 30 89 04 24 E8 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 05 E8 59 FC FF FF C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 18 89 C1 BA 01 00 00 00 C7 04 24 10 00 00 00 B8 ?? ?? ?? ?? E8 E1 FC FF FF C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 18 89 C1 BA 01 00 00 00 C7 04 24 08 00 00 00 B8 ?? ?? ?? ?? E8 B9 FC FF FF C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 11 89 C1 BA 01 00 00 00 B8 ?? ?? ?? ?? E8 48 FA FF FF C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 1B 89 C1 BA 01 00 00 00 B8 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 00 00 00 00 E8 1D FA FF FF C7 05 ?? ?? ?? ?? 01 00 00 00 81 C4 5C 01 00 00 5B 5E 5F 5D C3 89 FA 8B 7C 24 38 8B 74 24 3C C1 E2 04 81 C2 ?? ?? ?? ?? 0F BE 07 F6 44 46 01 20 74 10 8D 76 00 83 C7 01 0F BE 07 F6 44 46 01 20 75 F3 0F B6 42 0B 3C 01 0F 84 84 00 00 00 3C 02 0F 84 8F 00 00 00 3C 03 0F 85 77 FD FF FF 8B 42 0C 89 F9 8B 54 24 2C 89 04 24 8B 44 24 34 E8 FA FB FF FF 89 C3 85 DB 0F 84 58 FD FF FF 0F B6 03 84 C0 0F 84 4D FD FF FF 8B 15 ?? ?? ?? ?? 65 8B 0A 0F BE D0 F6 44 51 01 20 74 1A 66 90 83 C3 01 0F B6 03 84 C0 0F 84 2A FD FF FF 0F BE D0 F6 44 51 01 20 75 E8 3C 23 0F 84 18 FD FF FF C7 44 24 08 05 00 00 00 C7 44 24 04 ?? ?? ?? ?? E9 0C FE FF FF 8B 54 24 2C 89 F9 8B 44 24 34 E8 3C F9 FF FF 89 C3 EB 90 89 F8 E8 D1 FA FF FF 89 C3 EB 85 }
	condition:
		$1
}

rule file_316_7_0 {
	meta:
		name = "_res_hconf_init"
		size = 56
		refs = "0001 __pthread_once"
	strings:
		$1 = { B8 ?? ?? ?? ?? 83 EC 1C 85 C0 74 15 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? FF D0 83 C4 1C C3 83 3D ?? ?? ?? ?? 00 75 F3 E8 41 FC FF FF 83 0D ?? ?? ?? ?? 02 EB E5 }
	condition:
		$1
}

rule file_316_8_0 {
	meta:
		name = "_res_hconf_reorder_addrs"
		size = 731
		refs = "0002 _res_hconf 00ea __libc_errno 010d __socket 0148 __close 0174 __ifreq 0196 malloc 0229 __ioctl 0260 realloc 0275 free 02d7 __assert_fail"
	strings:
		$1 = { F6 05 ?? ?? ?? ?? 08 74 30 83 EC 6C 8B 44 24 70 89 5C 24 5C 89 74 24 60 89 7C 24 64 83 78 08 02 89 6C 24 68 74 1A 8B 5C 24 5C 8B 74 24 60 8B 7C 24 64 8B 6C 24 68 83 C4 6C F3 C3 90 8D 74 26 00 8B 35 ?? ?? ?? ?? 85 F6 0F 8E 9A 00 00 00 8B 44 24 70 8B 40 10 8B 10 89 44 24 30 85 D2 89 54 24 38 74 C3 8B 2D ?? ?? ?? ?? 83 C0 04 89 44 24 34 89 54 24 2C 85 F6 7E 2E 8B 4C 24 2C 8B 45 04 8B 39 31 F8 85 45 08 74 40 89 EA 31 C0 EB 11 66 90 89 D1 83 C2 0C 8B 59 10 31 FB 85 59 14 74 29 83 C0 01 39 F0 75 EA 8B 44 24 34 83 44 24 34 04 8B 54 24 34 89 44 24 30 8B 52 FC 85 D2 89 54 24 2C 75 B2 E9 5F FF FF FF 90 8B 44 24 38 8B 4C 24 30 8B 54 24 70 89 01 8B 4C 24 2C 8B 42 10 89 08 E9 42 FF FF FF 8D 74 26 00 8B 15 ?? ?? ?? ?? 65 8B 12 C7 44 24 08 00 00 00 00 C7 44 24 04 02 00 00 00 C7 04 24 02 00 00 00 89 54 24 2C E8 ?? ?? ?? ?? 85 C0 89 C5 0F 88 0B FF FF FF 31 C0 B9 01 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 0D ?? ?? ?? ?? 0F 85 79 02 00 00 8B 0D ?? ?? ?? ?? 85 C9 7E 1C 89 2C 24 E8 ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? 85 F6 0F 84 CC FE FF FF E9 EF FE FF FF 90 8D 44 24 4C 89 44 24 04 8D 44 24 48 89 6C 24 08 89 04 24 E8 ?? ?? ?? ?? 8B 4C 24 48 85 C9 89 4C 24 30 0F 84 21 01 00 00 8B 44 24 4C 8D 04 40 C1 E0 02 89 04 24 E8 ?? ?? ?? ?? 85 C0 A3 ?? ?? ?? ?? 0F 84 0C 01 00 00 8B 54 24 4C 85 D2 0F 8E FA 00 00 00 8B 5C 24 30 31 FF 31 F6 89 6C 24 3C EB 19 8D B4 26 00 00 00 00 8D 2C 7F C1 E5 02 83 C3 20 83 C6 01 39 74 24 4C 7E 78 66 83 7B 10 02 75 E7 8D 14 7F C1 E2 02 01 D0 89 D5 89 54 24 34 89 DA 2B 54 24 30 C7 00 02 00 00 00 89 54 24 20 8B 54 24 30 8B 4C 24 20 83 C2 10 8B 4C 0A 04 89 48 04 8B 44 24 3C 89 5C 24 08 C7 44 24 04 1B 89 00 00 89 54 24 28 89 04 24 E8 ?? ?? ?? ?? 8B 54 24 28 85 C0 A1 ?? ?? ?? ?? 78 94 8B 4C 24 20 83 C7 01 8B 54 11 04 8B 4C 24 34 89 54 08 08 E9 76 FF FF FF 89 E9 8B 6C 24 3C 89 4C 24 04 89 04 24 E8 ?? ?? ?? ?? 85 C0 A3 ?? ?? ?? ?? 74 4A 8B 44 24 48 89 04 24 E8 ?? ?? ?? ?? 8B 4C 24 2C 8B 15 ?? ?? ?? ?? 89 3D ?? ?? ?? ?? 65 89 0A 65 83 3D 0C 00 00 00 00 74 01 F0 83 2D ?? ?? ?? ?? 01 0F 85 1F 01 00 00 E9 9B FE FF FF 31 FF EB CC 31 C9 31 FF EB A5 31 FF EB B6 C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 C7 01 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_316_9_0 {
	meta:
		name = "_res_hconf_trim_domain"
		size = 115
		refs = "000f strlen 0016 _res_hconf 004b __strcasecmp"
	strings:
		$1 = { 55 57 56 53 83 EC 2C 8B 44 24 40 89 04 24 E8 ?? ?? ?? ?? 89 C3 A1 ?? ?? ?? ?? 85 C0 89 44 24 1C 7E 3A 31 ED 8D 74 26 00 8B 34 AD ?? ?? ?? ?? 89 34 24 E8 ?? ?? ?? ?? 39 C3 76 18 89 DF 29 C7 03 7C 24 40 89 74 24 04 89 3C 24 E8 ?? ?? ?? ?? 85 C0 74 15 83 C5 01 3B 6C 24 1C 75 CC 83 C4 2C 5B 5E 5F 5D C3 8D 74 26 00 C6 07 00 83 C4 2C 5B 5E 5F 5D C3 }
	condition:
		$1
}

rule file_316_10_0 {
	meta:
		name = "_res_hconf_trim_domains"
		size = 83
		refs = "0007 _res_hconf 0026 _res_hconf_trim_domain"
	strings:
		$1 = { 56 53 83 EC 14 8B 1D ?? ?? ?? ?? 8B 74 24 20 85 DB 75 0D 83 C4 14 5B 5E C3 8D B4 26 00 00 00 00 8B 06 89 04 24 E8 ?? ?? ?? ?? 8B 46 04 8B 00 85 C0 74 E0 BB 04 00 00 00 89 04 24 E8 ?? ?? ?? ?? 8B 46 04 8B 04 18 83 C3 04 85 C0 75 EB 83 C4 14 5B 5E C3 }
	condition:
		$1
}

rule file_317_0_0 {
	meta:
		name = "__isoc99_vswscanf"
		size = 164
		refs = "001d _IO_wstr_jumps 003a _IO_no_init 004a _IO_fwide 006d _IO_wstr_init_static 0098 _IO_vfwscanf"
	strings:
		$1 = { 53 81 EC 88 01 00 00 8D 5C 24 24 8D 84 24 C4 00 00 00 89 44 24 0C 89 1C 24 C7 44 24 10 ?? ?? ?? ?? C7 44 24 08 00 00 00 00 C7 44 24 04 00 80 00 00 C7 44 24 6C 00 00 00 00 E8 ?? ?? ?? ?? 89 1C 24 C7 44 24 04 01 00 00 00 E8 ?? ?? ?? ?? 8B 84 24 90 01 00 00 89 1C 24 C7 44 24 0C 00 00 00 00 C7 44 24 08 00 00 00 00 89 44 24 04 E8 ?? ?? ?? ?? 8B 84 24 98 01 00 00 89 1C 24 C7 44 24 0C 00 00 00 00 83 4C 24 60 10 89 44 24 08 8B 84 24 94 01 00 00 89 44 24 04 E8 ?? ?? ?? ?? 81 C4 88 01 00 00 5B C3 }
	condition:
		$1
}

rule file_319_0_0 {
	meta:
		name = "flush_cleanup"
		size = 98
	strings:
		$1 = { A1 ?? ?? ?? ?? 85 C0 74 2C F7 00 00 80 00 00 75 24 8B 50 48 83 6A 04 01 75 1B C7 42 08 00 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 83 2A 01 0F 85 DA 19 00 00 83 2D ?? ?? ?? ?? 01 75 22 C7 05 ?? ?? ?? ?? 00 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 83 2D ?? ?? ?? ?? 01 0F 85 BB 19 00 00 F3 C3 }
	condition:
		$1
}

rule file_319_3_0 {
	meta:
		name = "save_for_backup"
		size = 476
		refs = "0093 malloc 00c4 memcpy 00df free 016c memmove 01ad mempcpy"
	strings:
		$1 = { 55 57 89 C7 56 89 D6 53 83 EC 3C 8B 58 0C 89 54 24 20 8B 50 30 29 DE 85 D2 89 5C 24 24 0F 84 15 01 00 00 89 F3 89 D0 90 8B 48 08 8B 00 39 CB 0F 4F D9 85 C0 75 F2 8B 47 2C 89 F5 29 DD 89 44 24 28 8B 47 24 8B 4C 24 28 29 C1 39 CD 77 3A 29 E9 85 DB 0F 88 F8 00 00 00 85 ED 0F 85 A8 00 00 00 01 C1 85 D2 89 4F 28 74 10 8D B4 26 00 00 00 00 29 72 08 8B 12 85 D2 75 F7 31 C0 83 C4 3C 5B 5E 5F 5D C3 90 8D 74 26 00 8D 45 64 89 04 24 89 44 24 2C E8 ?? ?? ?? ?? 85 C0 89 C2 0F 84 31 01 00 00 85 DB 8D 48 64 0F 88 E5 00 00 00 03 5C 24 24 89 0C 24 89 6C 24 08 89 5C 24 04 89 4C 24 18 89 44 24 1C E8 ?? ?? ?? ?? 8B 4C 24 18 8B 54 24 1C 8B 47 24 89 54 24 1C 89 4C 24 18 89 04 24 E8 ?? ?? ?? ?? 8B 54 24 1C 8B 74 24 20 2B 77 0C 8B 4C 24 18 89 57 24 03 54 24 2C 89 57 2C 8B 57 30 E9 5E FF FF FF 8D 74 26 00 03 5C 24 24 01 C8 89 6C 24 08 89 04 24 89 5C 24 04 89 4C 24 18 E8 ?? ?? ?? ?? 8B 74 24 20 8B 4C 24 18 2B 77 0C 8B 57 30 03 4F 24 E9 2A FF FF FF 8B 58 2C 8B 40 24 89 D9 29 C1 85 F6 89 5C 24 28 0F 89 12 FF FF FF 89 F3 89 DA 01 C8 F7 DA 89 54 24 08 8B 54 24 28 89 04 24 89 4C 24 18 01 DA 89 54 24 04 E8 ?? ?? ?? ?? 8B 4C 24 18 8B 57 0C 89 C8 29 D8 8B 5C 24 20 03 47 24 89 54 24 04 29 D3 89 5C 24 08 89 04 24 EB 8C 89 D8 03 5C 24 28 F7 D8 89 0C 24 89 44 24 08 89 5C 24 04 89 54 24 1C 89 4C 24 18 E8 ?? ?? ?? ?? 8B 5C 24 24 89 74 24 08 89 5C 24 04 89 04 24 E8 ?? ?? ?? ?? 8B 54 24 1C 8B 4C 24 18 E9 FE FE FF FF B8 FF FF FF FF E9 9F FE FF FF }
	condition:
		$1
}

rule file_319_23_0 {
	meta:
		name = "_IO_un_link"
		size = 488
		refs = "0014 _pthread_cleanup_push_defer 00c1 _IO_list_all 0158 _pthread_cleanup_pop_restore"
	strings:
		$1 = { 57 56 53 83 EC 20 8B 5C 24 30 F6 03 80 0F 84 49 01 00 00 B8 ?? ?? ?? ?? 85 C0 0F 95 C0 0F B6 C0 89 C6 0F 84 AB 01 00 00 8D 44 24 10 C7 44 24 08 00 00 00 00 C7 44 24 04 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 65 8B 15 08 00 00 00 3B 15 ?? ?? ?? ?? 74 25 31 C0 B9 01 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 0D ?? ?? ?? ?? 0F 85 69 17 00 00 89 15 ?? ?? ?? ?? 8B 03 83 05 ?? ?? ?? ?? 01 89 1D ?? ?? ?? ?? 25 00 80 00 00 75 32 8B 53 48 65 8B 3D 08 00 00 00 3B 7A 08 74 1F B9 01 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 0A 0F 85 35 17 00 00 8B 53 48 89 7A 08 83 42 04 01 A1 ?? ?? ?? ?? 85 C0 74 36 39 C3 0F 84 BF 00 00 00 8B 50 34 85 D2 74 27 39 D3 75 1C 8D 74 26 00 E9 E9 00 00 00 8D 76 00 39 C3 8D B6 00 00 00 00 0F 84 B2 00 00 00 89 C2 8B 42 34 85 C0 75 E9 8B 03 89 C2 80 E2 7F F6 C4 80 89 13 75 24 8B 53 48 83 6A 04 01 75 1B C7 42 08 00 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 83 2A 01 0F 85 C6 16 00 00 83 2D ?? ?? ?? ?? 01 C7 05 ?? ?? ?? ?? 00 00 00 00 74 24 85 F6 74 14 8D 44 24 10 C7 44 24 04 00 00 00 00 89 04 24 E8 ?? ?? ?? ?? 83 C4 20 5B 5E 5F C3 90 8D 74 26 00 C7 05 ?? ?? ?? ?? 00 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 83 2D ?? ?? ?? ?? 01 0F 85 79 16 00 00 EB B8 8D 74 26 00 8B 43 34 83 05 ?? ?? ?? ?? 01 A3 ?? ?? ?? ?? E9 5B FF FF FF 8D 74 26 00 83 C2 34 8B 03 8B 4B 34 83 05 ?? ?? ?? ?? 01 89 0A 89 C2 80 E2 7F F6 C4 80 89 13 0F 85 68 FF FF FF E9 3F FF FF FF 8D 50 34 EB D8 C7 44 24 10 ?? ?? ?? ?? C7 44 24 14 00 00 00 00 E9 5C FE FF FF }
	condition:
		$1
}

rule file_319_24_0 {
	meta:
		name = "_IO_link_in"
		size = 459
		refs = "0026 _pthread_cleanup_push_defer 00ab _IO_list_all 010c _pthread_cleanup_pop_restore"
	strings:
		$1 = { 83 EC 3C 89 5C 24 2C 8B 5C 24 40 89 74 24 30 89 7C 24 34 89 6C 24 38 8B 03 A8 80 0F 85 EF 00 00 00 0C 80 89 03 B8 ?? ?? ?? ?? 85 C0 0F 95 C0 0F B6 C0 89 C6 0F 84 7C 01 00 00 8D 44 24 10 C7 44 24 08 00 00 00 00 C7 44 24 04 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 65 8B 15 08 00 00 00 3B 15 ?? ?? ?? ?? 74 25 31 C0 B9 01 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 0D ?? ?? ?? ?? 0F 85 9F 15 00 00 89 15 ?? ?? ?? ?? 8B 3B 8B 0D ?? ?? ?? ?? 89 1D ?? ?? ?? ?? 89 F8 83 C1 01 25 00 80 00 00 89 0D ?? ?? ?? ?? 74 7E A1 ?? ?? ?? ?? 83 05 ?? ?? ?? ?? 01 89 1D ?? ?? ?? ?? 89 43 34 83 E9 01 85 C9 C7 05 ?? ?? ?? ?? 00 00 00 00 89 0D ?? ?? ?? ?? 75 22 C7 05 ?? ?? ?? ?? 00 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 83 2D ?? ?? ?? ?? 01 0F 85 3B 15 00 00 85 F6 74 14 8D 44 24 10 C7 44 24 04 00 00 00 00 89 04 24 E8 ?? ?? ?? ?? 8B 5C 24 2C 8B 74 24 30 8B 7C 24 34 8B 6C 24 38 83 C4 3C C3 8D 74 26 00 8B 53 48 65 8B 2D 08 00 00 00 3B 6A 08 74 21 B9 01 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 0A 0F 85 F3 14 00 00 8B 53 48 8B 3B 89 6A 08 A1 ?? ?? ?? ?? 83 42 04 01 83 05 ?? ?? ?? ?? 01 81 E7 00 80 00 00 89 43 34 89 1D ?? ?? ?? ?? 75 32 8B 42 04 83 E8 01 85 C0 89 42 04 8B 0D ?? ?? ?? ?? 0F 85 2F FF FF FF C7 42 08 00 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 83 2A 01 0F 85 A4 14 00 00 8B 0D ?? ?? ?? ?? E9 09 FF FF FF C7 44 24 10 ?? ?? ?? ?? C7 44 24 14 00 00 00 00 E9 8B FE FF FF }
	condition:
		$1
}

rule file_319_25_0 {
	meta:
		name = "_IO_least_marker"
		size = 40
	strings:
		$1 = { 8B 54 24 04 8B 44 24 08 2B 42 0C 8B 52 30 85 D2 74 14 8D B6 00 00 00 00 8B 4A 08 8B 12 39 C8 0F 4F C1 85 D2 75 F2 F3 C3 }
	condition:
		$1
}

rule file_319_26_0 {
	meta:
		name = "_IO_switch_to_main_get_area"
		size = 38
	strings:
		$1 = { 8B 44 24 04 8B 50 08 8B 48 2C 81 20 FF FE FF FF 89 50 2C 8B 50 24 89 48 08 8B 48 0C 89 50 04 89 50 0C 89 48 24 C3 }
	condition:
		$1
}

rule file_319_27_0 {
	meta:
		name = "_IO_switch_to_backup_area"
		size = 40
	strings:
		$1 = { 53 8B 44 24 08 8B 48 08 8B 50 2C 8B 58 24 81 08 00 01 00 00 89 48 2C 8B 48 0C 89 50 08 89 58 0C 89 50 04 89 48 24 5B C3 }
	condition:
		$1
}

rule file_319_28_0 {
	meta:
		name = "_IO_switch_to_get_mode"
		size = 109
	strings:
		$1 = { 53 83 EC 18 8B 5C 24 20 8B 43 14 3B 43 10 77 38 8B 13 F6 C6 01 75 29 8B 4B 1C 39 43 08 89 4B 0C 73 03 89 43 08 80 E6 F7 89 43 04 89 43 18 89 43 10 31 C0 89 13 83 C4 18 5B C3 8D B6 00 00 00 00 8B 4B 28 89 4B 0C EB DD 8B 83 94 00 00 00 C7 44 24 04 FF FF FF FF 89 1C 24 FF 50 0C 83 F8 FF 74 05 8B 43 14 EB AA B8 FF FF FF FF EB C8 }
	condition:
		$1
}

rule file_319_29_0 {
	meta:
		name = "_IO_free_backup_area"
		size = 93
		refs = "0033 free"
	strings:
		$1 = { 53 83 EC 18 8B 5C 24 20 8B 03 F6 C4 01 74 49 80 E4 FE 8B 53 2C 89 03 8B 43 08 89 53 08 8B 53 24 89 43 2C 8B 43 0C 89 53 04 89 53 0C 89 43 24 89 04 24 E8 ?? ?? ?? ?? C7 43 24 00 00 00 00 C7 43 2C 00 00 00 00 C7 43 28 00 00 00 00 83 C4 18 5B C3 8D B4 26 00 00 00 00 8B 43 24 EB D2 }
	condition:
		$1
}

rule file_319_30_0 {
	meta:
		name = "__overflow"
		size = 41
	strings:
		$1 = { 8B 44 24 04 8B 4C 24 08 8B 50 68 85 D2 75 07 C7 40 68 FF FF FF FF 8B 90 94 00 00 00 89 4C 24 08 89 44 24 04 8B 42 0C FF E0 }
	condition:
		$1
}

rule file_319_31_0 {
	meta:
		name = "__underflow"
		size = 193
		refs = "009c _IO_switch_to_get_mode 00bb _IO_free_backup_area"
	strings:
		$1 = { 53 83 EC 18 8B 5C 24 20 8B 43 68 85 C0 75 49 C7 43 68 FF FF FF FF F7 03 00 08 00 00 75 7A 8B 43 04 8B 53 08 39 D0 72 61 8B 03 F6 C4 01 75 39 8B 43 30 85 C0 74 7A 8B 53 08 89 D8 E8 90 F8 FF FF 85 C0 75 19 8B 83 94 00 00 00 89 5C 24 20 8B 40 10 83 C4 18 5B FF E0 90 83 F8 FF 74 B9 83 C4 18 B8 FF FF FF FF 5B C3 90 80 E4 FE 8B 4B 2C 89 03 8B 43 24 89 53 2C 8B 53 0C 89 4B 08 39 C1 89 43 0C 89 53 24 89 43 04 76 A6 0F B6 00 83 C4 18 5B C3 8D B4 26 00 00 00 00 89 1C 24 E8 ?? ?? ?? ?? 83 F8 FF 0F 85 75 FF FF FF EB B2 90 8D 74 26 00 8B 4B 24 85 C9 74 8D 89 1C 24 E8 ?? ?? ?? ?? EB 83 }
	condition:
		$1
}

rule file_319_32_0 {
	meta:
		name = "__uflow"
		size = 193
		refs = "009c _IO_switch_to_get_mode 00bb _IO_free_backup_area"
	strings:
		$1 = { 53 83 EC 18 8B 5C 24 20 8B 43 68 85 C0 75 49 C7 43 68 FF FF FF FF F7 03 00 08 00 00 75 7A 8B 53 04 8B 43 08 39 C2 72 61 8B 13 F6 C6 01 75 39 8B 43 30 85 C0 74 7A 8B 53 08 89 D8 E8 C0 F7 FF FF 85 C0 75 19 8B 83 94 00 00 00 89 5C 24 20 8B 40 14 83 C4 18 5B FF E0 90 83 F8 FF 74 B9 83 C4 18 B8 FF FF FF FF 5B C3 90 80 E6 FE 8B 4B 2C 89 13 8B 53 24 89 43 2C 8B 43 0C 89 4B 08 39 D1 89 53 0C 89 43 24 89 53 04 76 A6 0F B6 02 83 C2 01 89 53 04 83 C4 18 5B C3 90 89 1C 24 E8 ?? ?? ?? ?? 83 F8 FF 0F 85 75 FF FF FF EB B2 90 8D 74 26 00 8B 43 24 85 C0 74 8D 89 1C 24 E8 ?? ?? ?? ?? EB 83 }
	condition:
		$1
}

rule file_319_33_0 {
	meta:
		name = "_IO_setb"
		size = 95
		refs = "0059 __munmap"
	strings:
		$1 = { 53 83 EC 18 8B 5C 24 20 8B 43 1C 85 C0 74 05 F6 03 01 74 2C 8B 44 24 24 89 43 1C 8B 44 24 28 89 43 20 8B 44 24 2C 85 C0 75 0E 83 0B 01 83 C4 18 5B C3 8D B6 00 00 00 00 83 23 FE 83 C4 18 5B C3 8B 53 20 89 04 24 29 C2 81 C2 FF 0F 00 00 81 E2 00 F0 FF FF 89 54 24 04 E8 ?? ?? ?? ?? EB B5 }
	condition:
		$1
}

rule file_319_34_0 {
	meta:
		name = "_IO_doallocbuf"
		size = 88
		refs = "004f _IO_setb"
	strings:
		$1 = { 53 83 EC 18 8B 5C 24 20 8B 43 1C 85 C0 74 09 83 C4 18 5B C3 8D 74 26 00 F6 03 02 74 07 8B 43 68 85 C0 7E 11 8B 83 94 00 00 00 89 1C 24 FF 50 34 83 F8 FF 75 DA 8D 43 48 89 44 24 08 8D 43 47 89 1C 24 C7 44 24 0C 00 00 00 00 89 44 24 04 E8 ?? ?? ?? ?? 83 C4 18 5B C3 }
	condition:
		$1
}

rule file_319_36_0 {
	meta:
		name = "_IO_default_uflow"
		size = 55
	strings:
		$1 = { 53 83 EC 18 8B 5C 24 20 8B 83 94 00 00 00 89 1C 24 FF 50 10 83 F8 FF 74 17 8B 53 04 0F B6 02 83 C2 01 89 53 04 83 C4 18 5B C3 8D B6 00 00 00 00 B8 FF FF FF FF EB EE }
	condition:
		$1
}

rule file_319_37_0 {
	meta:
		name = "_IO_default_xsputn"
		size = 174
		refs = "0096 mempcpy"
	strings:
		$1 = { 55 31 C0 57 56 53 83 EC 1C 8B 54 24 38 8B 6C 24 30 85 D2 0F 84 8D 00 00 00 8B 74 24 38 8B 5C 24 34 8D B4 26 00 00 00 00 8B 4D 14 8B 7D 18 39 F9 73 2D 29 CF 39 FE 0F 46 FE 83 FF 14 77 4A 85 FF 74 1B 31 C0 8D 74 26 00 0F B6 14 03 88 14 01 83 C0 01 39 F8 75 F2 01 F9 01 FB 89 4D 14 29 FE 85 F6 74 3D 0F B6 13 83 C3 01 8B 85 94 00 00 00 89 2C 24 89 54 24 04 FF 50 0C 83 F8 FF 74 22 83 EE 01 EB A5 90 8D 74 26 00 89 5C 24 04 01 FB 89 7C 24 08 89 0C 24 E8 ?? ?? ?? ?? 89 45 14 EB BE 90 8B 44 24 38 29 F0 83 C4 1C 5B 5E 5F 5D C3 }
	condition:
		$1
}

rule file_319_39_0 {
	meta:
		name = "_IO_default_xsgetn"
		size = 135
		refs = "0057 __underflow 007c mempcpy"
	strings:
		$1 = { 55 57 56 53 83 EC 1C 8B 74 24 30 8B 7C 24 34 8B 6C 24 38 90 8D 74 26 00 8B 46 04 8B 5E 08 39 D8 73 2D 29 C3 39 DD 0F 46 DD 83 FB 14 77 42 85 DB 74 1B 31 D2 8D 74 26 00 0F B6 0C 10 88 0C 17 83 C2 01 39 DA 75 F2 01 D8 01 DF 89 46 04 29 DD 85 ED 74 0D 89 34 24 E8 ?? ?? ?? ?? 83 F8 FF 75 B8 8B 44 24 38 83 C4 1C 5B 5E 5F 29 E8 5D C3 66 90 89 3C 24 89 5C 24 08 89 44 24 04 E8 ?? ?? ?? ?? 01 5E 04 89 C7 EB C6 }
	condition:
		$1
}

rule file_319_40_0 {
	meta:
		name = "_IO_default_setbuf"
		size = 188
		refs = "0055 _IO_setb"
	strings:
		$1 = { 83 EC 1C 89 5C 24 10 8B 5C 24 20 89 74 24 14 8B 74 24 24 89 7C 24 18 8B 7C 24 28 8B 83 94 00 00 00 89 1C 24 FF 50 30 83 F8 FF 0F 84 88 00 00 00 85 FF 74 04 85 F6 75 60 83 0B 02 8D 43 48 89 44 24 08 8D 43 47 C7 44 24 0C 00 00 00 00 89 44 24 04 89 1C 24 E8 ?? ?? ?? ?? C7 43 18 00 00 00 00 C7 43 14 00 00 00 00 C7 43 10 00 00 00 00 C7 43 08 00 00 00 00 C7 43 04 00 00 00 00 C7 43 0C 00 00 00 00 89 D8 8B 74 24 14 8B 5C 24 10 8B 7C 24 18 83 C4 1C C3 8D 76 00 83 23 FD 01 F7 C7 44 24 0C 00 00 00 00 89 7C 24 08 89 74 24 04 89 1C 24 E8 ?? ?? ?? ?? EB A2 90 31 DB EB C7 }
	condition:
		$1
}

rule file_319_41_0 {
	meta:
		name = "_IO_default_seekpos"
		size = 57
	strings:
		$1 = { 53 83 EC 28 8B 4C 24 30 8B 44 24 3C 8B 54 24 38 8B 99 94 00 00 00 89 44 24 10 8B 44 24 34 C7 44 24 0C 00 00 00 00 89 54 24 08 89 0C 24 89 44 24 04 FF 53 24 83 C4 28 5B C3 }
	condition:
		$1
}

rule file_319_42_0 {
	meta:
		name = "_IO_default_doallocate"
		size = 111
		refs = "0033 __mmap 005a _IO_setb"
	strings:
		$1 = { 83 EC 2C C7 44 24 14 00 00 00 00 C7 44 24 10 FF FF FF FF C7 44 24 0C 22 00 00 00 C7 44 24 08 03 00 00 00 C7 44 24 04 00 20 00 00 C7 04 24 00 00 00 00 E8 ?? ?? ?? ?? 83 F8 FF 74 2C 8D 90 00 20 00 00 89 44 24 04 8B 44 24 30 C7 44 24 0C 01 00 00 00 89 54 24 08 89 04 24 E8 ?? ?? ?? ?? B8 01 00 00 00 83 C4 2C C3 90 B8 FF FF FF FF EB F4 }
	condition:
		$1
}

rule file_319_43_0 {
	meta:
		name = "_IO_old_init"
		size = 149
	strings:
		$1 = { 8B 54 24 08 8B 44 24 04 81 CA 00 00 AD FB 89 10 C7 40 3C 00 00 00 00 C7 40 1C 00 00 00 00 C7 40 20 00 00 00 00 C7 40 0C 00 00 00 00 C7 40 04 00 00 00 00 C7 40 08 00 00 00 00 C7 40 10 00 00 00 00 C7 40 14 00 00 00 00 C7 40 18 00 00 00 00 C7 40 34 00 00 00 00 C7 40 24 00 00 00 00 C7 40 28 00 00 00 00 C7 40 2C 00 00 00 00 C7 40 30 00 00 00 00 66 C7 40 44 00 00 8B 40 48 85 C0 74 14 C7 00 00 00 00 00 C7 40 04 00 00 00 00 C7 40 08 00 00 00 00 F3 C3 }
	condition:
		$1
}

rule file_319_44_0 {
	meta:
		name = "_IO_init"
		size = 43
		refs = "0014 _IO_old_init"
	strings:
		$1 = { 53 83 EC 08 8B 5C 24 10 8B 44 24 14 89 1C 24 89 44 24 04 E8 ?? ?? ?? ?? C7 43 68 FF FF FF FF C7 43 5C 00 00 00 00 83 C4 08 5B C3 }
	condition:
		$1
}

rule file_319_45_0 {
	meta:
		name = "_IO_no_init"
		size = 162
		refs = "0027 _IO_old_init"
	strings:
		$1 = { 83 EC 14 89 74 24 0C 8B 44 24 1C 8B 74 24 18 89 7C 24 10 8B 7C 24 20 89 5C 24 08 8B 5C 24 24 89 44 24 04 89 34 24 E8 ?? ?? ?? ?? 85 FF 89 7E 68 78 59 8B 44 24 28 89 5E 58 C7 43 18 00 00 00 00 C7 43 1C 00 00 00 00 C7 43 08 00 00 00 00 C7 03 00 00 00 00 C7 43 04 00 00 00 00 C7 43 0C 00 00 00 00 C7 43 10 00 00 00 00 C7 43 14 00 00 00 00 C7 43 20 00 00 00 00 C7 43 24 00 00 00 00 C7 43 28 00 00 00 00 89 83 B8 00 00 00 C7 46 5C 00 00 00 00 8B 5C 24 08 8B 74 24 0C 8B 7C 24 10 83 C4 14 C3 }
	condition:
		$1
}

rule file_319_47_0 {
	meta:
		name = "_IO_default_finish"
		size = 125
		refs = "0038 free 0069 __munmap 004c _IO_un_link"
	strings:
		$1 = { 53 83 EC 18 8B 5C 24 20 8B 43 1C 85 C0 74 05 F6 03 01 74 3C 8B 43 30 85 C0 74 12 90 8D 74 26 00 C7 40 04 00 00 00 00 8B 00 85 C0 75 F3 8B 43 24 85 C0 74 0F 89 04 24 E8 ?? ?? ?? ?? C7 43 24 00 00 00 00 89 5C 24 20 83 C4 18 5B E9 ?? ?? ?? ?? 8B 53 20 89 04 24 29 C2 81 C2 FF 0F 00 00 81 E2 00 F0 FF FF 89 54 24 04 E8 ?? ?? ?? ?? C7 43 20 00 00 00 00 C7 43 1C 00 00 00 00 EB 97 }
	condition:
		$1
}

rule file_319_49_0 {
	meta:
		name = "_IO_sputbackc"
		size = 69
	strings:
		$1 = { 53 83 EC 18 8B 5C 24 20 8B 44 24 24 8B 53 04 3B 53 0C 76 05 38 42 FF 74 1F 8B 93 94 00 00 00 89 44 24 04 89 1C 24 FF 52 18 83 F8 FF 74 03 83 23 EF 83 C4 18 5B C3 66 90 83 EA 01 25 FF 00 00 00 89 53 04 EB E9 }
	condition:
		$1
}

rule file_319_50_0 {
	meta:
		name = "_IO_sungetc"
		size = 70
	strings:
		$1 = { 53 83 EC 18 8B 5C 24 20 8B 43 04 3B 43 0C 76 18 8D 50 FF 89 53 04 0F B6 40 FF 83 23 EF 83 C4 18 5B C3 8D B6 00 00 00 00 8B 83 94 00 00 00 C7 44 24 04 FF FF FF FF 89 1C 24 FF 50 18 83 F8 FF 75 D9 83 C4 18 5B C3 }
	condition:
		$1
}

rule file_319_51_0 {
	meta:
		name = "_IO_adjust_column"
		size = 63
	strings:
		$1 = { 53 8B 4C 24 0C 8B 5C 24 10 8D 04 19 39 C1 73 1C 80 78 FF 0A 8D 50 FF 75 0F EB 1D 90 8D 74 26 00 83 EA 01 80 3A 0A 74 10 39 CA 75 F4 8B 44 24 08 01 D8 5B C3 8D 74 26 00 29 D0 83 E8 01 5B C3 }
	condition:
		$1
}

rule file_319_52_0 {
	meta:
		name = "_IO_flush_all_lockp"
		size = 529
		refs = "0018 _pthread_cleanup_push_defer 0085 _IO_list_all 01af _pthread_cleanup_pop_restore"
	strings:
		$1 = { 55 57 56 53 83 EC 3C 8B 74 24 50 C7 44 24 1C 00 00 00 00 85 F6 74 6C B8 ?? ?? ?? ?? 85 C0 0F 84 D8 01 00 00 8D 44 24 20 C7 44 24 08 00 00 00 00 C7 44 24 04 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? C7 44 24 1C 01 00 00 00 65 8B 15 08 00 00 00 3B 15 ?? ?? ?? ?? 74 25 31 C0 B9 01 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 0D ?? ?? ?? ?? 0F 85 15 0A 00 00 89 15 ?? ?? ?? ?? 83 05 ?? ?? ?? ?? 01 8B 1D ?? ?? ?? ?? 31 ED 8B 3D ?? ?? ?? ?? 85 DB 0F 84 F1 00 00 00 65 8B 15 08 00 00 00 89 54 24 18 EB 12 66 90 8B 1D ?? ?? ?? ?? 89 C7 85 DB 0F 84 D2 00 00 00 85 F6 89 1D ?? ?? ?? ?? 74 3C 8B 03 25 00 80 00 00 75 33 8B 53 48 8B 4C 24 18 3B 4A 08 74 23 B9 01 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 0A 0F 85 AB 09 00 00 8B 53 48 8B 44 24 18 89 42 08 83 42 04 01 8B 43 68 85 C0 0F 8E B7 00 00 00 8B 43 58 8B 48 0C 39 48 10 76 1F 8B 83 94 00 00 00 C7 44 24 04 FF FF FF FF 89 1C 24 FF 50 0C 83 F8 FF B8 FF FF FF FF 0F 44 E8 85 F6 74 31 F7 03 00 80 00 00 75 29 8B 53 48 83 6A 04 01 75 20 C7 42 08 00 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 83 2A 01 0F 85 44 09 00 00 90 8D 74 26 00 A1 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 00 00 00 00 39 C7 0F 85 29 FF FF FF 8B 5B 34 85 DB 0F 85 2E FF FF FF 85 F6 74 09 83 2D ?? ?? ?? ?? 01 74 41 8B 4C 24 1C 85 C9 74 14 8D 44 24 20 C7 44 24 04 00 00 00 00 89 04 24 E8 ?? ?? ?? ?? 83 C4 3C 89 E8 5B 5E 5F 5D C3 8D 76 00 8B 53 10 39 53 14 0F 87 48 FF FF FF E9 62 FF FF FF 8D B4 26 00 00 00 00 C7 05 ?? ?? ?? ?? 00 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 83 2D ?? ?? ?? ?? 01 0F 85 B9 08 00 00 EB 9B C7 44 24 20 ?? ?? ?? ?? C7 44 24 24 ?? ?? ?? ?? E9 37 FE FF FF }
	condition:
		$1
}

rule file_319_53_0 {
	meta:
		name = "_IO_cleanup"
		size = 440
		refs = "0014 _IO_flush_all_lockp 001a _IO_list_all 008c __sched_yield"
	strings:
		$1 = { 55 57 56 53 BB 01 00 00 00 83 EC 2C C7 04 24 00 00 00 00 E8 ?? ?? ?? ?? 8B 2D ?? ?? ?? ?? 65 8B 35 08 00 00 00 85 ED 89 44 24 1C 0F 84 E1 00 00 00 8D B4 26 00 00 00 00 8B 45 00 89 C7 83 E7 02 0F 85 BA 00 00 00 25 08 10 00 00 83 F8 08 0F 84 AC 00 00 00 8B 45 68 85 C0 0F 84 A1 00 00 00 8B 4D 48 85 C9 0F 84 3D 01 00 00 3B 71 08 0F 84 1D 01 00 00 89 F8 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 19 85 C0 0F 84 95 00 00 00 E8 ?? ?? ?? ?? 8B 4D 48 85 C9 0F 84 13 01 00 00 3B 71 08 0F 84 FC 00 00 00 89 F8 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 19 85 C0 BF 01 00 00 00 0F 85 8F 00 00 00 8B 45 48 89 70 08 C7 40 04 01 00 00 00 80 3D ?? ?? ?? ?? 00 75 07 8B 45 00 A8 01 74 4A 8B 85 94 00 00 00 C7 44 24 08 00 00 00 00 C7 44 24 04 00 00 00 00 89 2C 24 FF 50 2C 83 FF 02 75 61 90 C7 45 68 FF FF FF FF 8B 6D 34 85 ED 0F 85 26 FF FF FF 8B 44 24 1C 83 C4 2C 5B 5E 5F 5D C3 66 90 31 FF EB 9D 8D 74 26 00 83 C8 01 8B 4D 1C 89 45 00 A1 ?? ?? ?? ?? 89 2D ?? ?? ?? ?? 89 4D 60 89 45 5C 8B 45 20 29 C8 89 45 64 EB 92 8D 74 26 00 E8 ?? ?? ?? ?? BF 02 00 00 00 E9 6F FF FF FF 90 8B 4D 48 85 C9 74 99 83 69 04 01 75 93 C7 41 08 00 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 83 29 01 0F 85 1B 07 00 00 E9 73 FF FF FF 8D 76 00 31 FF 83 41 04 01 E9 33 FF FF FF 90 8D 74 26 00 BF 01 00 00 00 EB EB 31 FF E9 20 FF FF FF BF 01 00 00 00 E9 16 FF FF FF }
	condition:
		$1
}

rule file_319_54_0 {
	meta:
		name = "_IO_flush_all"
		size = 19
		refs = "000b _IO_flush_all_lockp"
	strings:
		$1 = { 83 EC 1C C7 04 24 01 00 00 00 E8 ?? ?? ?? ?? 83 C4 1C C3 }
	condition:
		$1
}

rule file_319_55_0 {
	meta:
		name = "_IO_flush_all_linebuffered"
		size = 462
		refs = "0002 _pthread_cleanup_push_defer 0075 _IO_list_all 0192 _pthread_cleanup_pop_restore"
	strings:
		$1 = { 55 B8 ?? ?? ?? ?? 57 56 53 83 EC 3C 85 C0 0F 95 C0 0F B6 C0 89 44 24 1C 0F 84 9B 01 00 00 8D 44 24 20 C7 44 24 08 00 00 00 00 C7 44 24 04 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 65 8B 15 08 00 00 00 3B 15 ?? ?? ?? ?? 74 25 31 C0 B9 01 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 0D ?? ?? ?? ?? 0F 85 67 06 00 00 89 15 ?? ?? ?? ?? A1 ?? ?? ?? ?? 8B 1D ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? 83 C0 01 85 DB A3 ?? ?? ?? ?? 0F 84 BD 00 00 00 65 8B 3D 08 00 00 00 BD 01 00 00 00 EB 13 8D 76 00 8B 1D ?? ?? ?? ?? 89 C6 85 DB 0F 84 97 00 00 00 8B 03 89 1D ?? ?? ?? ?? 25 00 80 00 00 75 28 8B 53 48 3B 7A 08 74 1C 89 E9 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 0A 0F 85 02 06 00 00 8B 53 48 89 7A 08 83 42 04 01 8B 03 25 08 02 00 00 3D 00 02 00 00 0F 84 A7 00 00 00 F7 03 00 80 00 00 75 24 8B 53 48 83 6A 04 01 75 1B C7 42 08 00 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 83 2A 01 0F 85 C6 05 00 00 A1 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 00 00 00 00 39 C6 0F 85 64 FF FF FF 8B 5B 34 85 DB 0F 85 69 FF FF FF A1 ?? ?? ?? ?? 83 E8 01 85 C0 A3 ?? ?? ?? ?? 75 22 C7 05 ?? ?? ?? ?? 00 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 83 2D ?? ?? ?? ?? 01 0F 85 7D 05 00 00 8B 44 24 1C 85 C0 74 14 8D 44 24 20 C7 44 24 04 00 00 00 00 89 04 24 E8 ?? ?? ?? ?? 83 C4 3C 5B 5E 5F 5D C3 66 90 8B 83 94 00 00 00 C7 44 24 04 FF FF FF FF 89 1C 24 FF 50 0C E9 40 FF FF FF C7 44 24 20 ?? ?? ?? ?? C7 44 24 24 00 00 00 00 E9 6C FE FF FF }
	condition:
		$1
}

rule file_319_56_0 {
	meta:
		name = "_IO_init_marker"
		size = 84
		refs = "004c _IO_switch_to_get_mode"
	strings:
		$1 = { 83 EC 1C 89 5C 24 14 8B 5C 24 24 89 74 24 18 8B 74 24 20 8B 03 89 5E 04 F6 C4 08 75 2B F6 C4 01 8B 43 04 75 1B 2B 43 0C 89 46 08 8B 43 30 89 06 89 73 30 8B 5C 24 14 8B 74 24 18 83 C4 1C C3 90 2B 43 08 89 46 08 EB E3 89 1C 24 E8 ?? ?? ?? ?? 8B 03 EB C9 }
	condition:
		$1
}

rule file_319_57_0 {
	meta:
		name = "_IO_remove_marker"
		size = 53
	strings:
		$1 = { 8B 4C 24 04 8B 41 04 8B 50 30 85 D2 74 1C 39 D1 75 12 EB 18 8D 74 26 00 39 C1 8D B6 00 00 00 00 74 0E 89 C2 8B 02 85 C0 75 EE F3 C3 8D 50 30 90 8B 09 89 0A C3 }
	condition:
		$1
}

rule file_319_59_0 {
	meta:
		name = "_IO_marker_delta"
		size = 47
	strings:
		$1 = { 8B 4C 24 04 8B 41 04 85 C0 74 1E F7 00 00 01 00 00 8B 50 04 75 0A 2B 50 0C 8B 41 08 29 D0 C3 90 2B 50 08 8B 41 08 29 D0 C3 B8 FF FF FF FF C3 }
	condition:
		$1
}

rule file_319_60_0 {
	meta:
		name = "_IO_seekmark"
		size = 160
	strings:
		$1 = { 83 EC 08 8B 54 24 10 89 1C 24 89 74 24 04 8B 42 04 3B 44 24 0C 75 79 8B 52 08 8B 08 85 D2 78 40 F6 C5 01 74 33 80 E5 FE 8B 58 2C 89 08 8B 48 08 89 58 08 8B 58 0C 89 48 2C 8B 48 24 89 58 24 89 48 0C 01 CA 8B 1C 24 89 50 04 8B 74 24 04 31 C0 83 C4 08 C3 8D 74 26 00 8B 48 0C EB E5 8D 76 00 F6 C5 01 75 23 8B 58 08 80 CD 01 8B 70 24 89 08 8B 48 2C 89 58 2C 8B 58 0C 89 70 0C 89 48 08 89 58 24 EB BE 8D 74 26 00 8B 48 08 EB B5 8D 76 00 B8 FF FF FF FF 8B 1C 24 8B 74 24 04 83 C4 08 C3 }
	condition:
		$1
}

rule file_319_61_0 {
	meta:
		name = "_IO_unsave_markers"
		size = 42
		refs = "001e _IO_free_backup_area"
	strings:
		$1 = { 8B 44 24 04 8B 48 30 85 C9 74 07 C7 40 30 00 00 00 00 8B 50 24 85 D2 74 0F 89 44 24 04 E9 ?? ?? ?? ?? 8D B6 00 00 00 00 F3 C3 }
	condition:
		$1
}

rule file_1117_23_0 {
	meta:
		name = "_IO_unsave_wmarkers"
		size = 42
		refs = "001e _IO_free_wbackup_area"
	strings:
		$1 = { 8B 44 24 04 8B 48 30 85 C9 74 07 C7 40 30 00 00 00 00 8B 50 24 85 D2 74 0F 89 44 24 04 E9 ?? ?? ?? ?? 8D B6 00 00 00 00 F3 C3 }
	condition:
		$1
}

rule file_319_62_0 {
	meta:
		name = "_IO_default_pbackfail"
		size = 334
		refs = "00dc malloc 00fb memcpy 0106 free"
	strings:
		$1 = { 83 EC 3C 89 5C 24 2C 8B 5C 24 40 89 74 24 30 89 6C 24 38 89 7C 24 34 8B 7C 24 44 8B 73 04 8B 6B 0C 39 EE 77 5B 8B 13 F6 C6 01 0F 85 98 00 00 00 8B 43 24 85 C0 0F 84 E5 00 00 00 89 F1 8B 73 2C 80 CE 01 89 13 8B 53 08 89 43 0C 89 73 08 89 4B 24 89 53 2C 8D 46 FF 89 43 04 89 F8 88 46 FF 89 F8 25 FF 00 00 00 8B 5C 24 2C 8B 74 24 30 8B 7C 24 34 8B 6C 24 38 83 C4 3C C3 8D B6 00 00 00 00 F7 03 00 01 00 00 75 CC 0F B6 46 FF 39 F8 74 30 8B 6B 24 85 ED 0F 84 85 00 00 00 89 F2 89 D8 E8 3C E8 FF FF 85 C0 0F 85 98 00 00 00 8B 4B 04 8B 13 8B 73 2C 8B 43 24 EB 87 8D B4 26 00 00 00 00 83 EE 01 89 73 04 EB 97 8B 53 08 29 EA 8D 04 12 89 04 24 89 54 24 18 89 44 24 1C E8 ?? ?? ?? ?? 8B 54 24 18 85 C0 74 5C 8D 34 10 89 54 24 08 89 6C 24 04 89 34 24 89 44 24 18 E8 ?? ?? ?? ?? 8B 43 0C 89 04 24 E8 ?? ?? ?? ?? 8B 4C 24 18 89 73 28 89 4B 0C 03 4C 24 1C 89 4B 08 E9 34 FF FF FF C7 04 24 80 00 00 00 E8 ?? ?? ?? ?? 85 C0 74 14 8D A8 80 00 00 00 89 F1 8B 13 89 6B 28 89 EE E9 FC FE FF FF B8 FF FF FF FF E9 18 FF FF FF }
	condition:
		$1
}

rule file_319_73_0 {
	meta:
		name = "_IO_list_lock"
		size = 60
	strings:
		$1 = { 65 8B 15 08 00 00 00 3B 15 ?? ?? ?? ?? 74 25 31 C0 B9 01 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 0D ?? ?? ?? ?? 0F 85 69 01 00 00 89 15 ?? ?? ?? ?? 83 05 ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule file_319_74_0 {
	meta:
		name = "_IO_list_unlock"
		size = 45
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 75 22 C7 05 ?? ?? ?? ?? 00 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 83 2D ?? ?? ?? ?? 01 0F 85 3C 01 00 00 F3 C3 }
	condition:
		$1
}

rule file_319_75_0 {
	meta:
		name = "_IO_list_resetlock"
		size = 31
	strings:
		$1 = { C7 05 ?? ?? ?? ?? 00 00 00 00 C7 05 ?? ?? ?? ?? 00 00 00 00 C7 05 ?? ?? ?? ?? 00 00 00 00 C3 }
	condition:
		$1
}

rule file_319_76_0 {
	meta:
		name = "buffer_free"
		size = 76
		refs = "0032 __munmap"
	strings:
		$1 = { A1 ?? ?? ?? ?? C6 05 ?? ?? ?? ?? 01 85 C0 74 3A 83 EC 1C 90 8D 74 26 00 8B 50 64 81 C2 FF 0F 00 00 81 E2 00 F0 FF FF 89 54 24 04 8B 40 60 89 04 24 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 8B 40 5C 85 C0 A3 ?? ?? ?? ?? 75 D1 83 C4 1C F3 C3 }
	condition:
		$1
}

rule file_320_0_0 {
	meta:
		name = "truncate64"
		size = 49
		refs = "0014 _dl_sysinfo 0023 __libc_errno"
	strings:
		$1 = { 53 8B 54 24 10 8B 4C 24 0C 8B 5C 24 08 B8 C1 00 00 00 FF 15 ?? ?? ?? ?? 3D 00 F0 FF FF 77 02 5B C3 8B 15 ?? ?? ?? ?? F7 D8 65 89 02 83 C8 FF 5B C3 }
	condition:
		$1
}

rule file_321_0_0 {
	meta:
		name = "__libc_write"
		size = 99
		refs = "001e _dl_sysinfo 0030 __libc_enable_asynccancel 0052 __libc_disable_asynccancel 002a __syscall_error"
		altNames = "__write"
	strings:
		$1 = { 65 83 3D 0C 00 00 00 00 75 25 53 8B 54 24 10 8B 4C 24 0C 8B 5C 24 08 B8 04 00 00 00 FF 15 ?? ?? ?? ?? 5B 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 E8 ?? ?? ?? ?? 50 53 8B 54 24 14 8B 4C 24 10 8B 5C 24 0C B8 04 00 00 00 FF 15 ?? ?? ?? ?? 5B 87 04 24 E8 ?? ?? ?? ?? 58 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_141_0_3 {
	meta:
		name = "__libc_write"
		size = 99
		refs = "001e _dl_sysinfo 0030 __pthread_enable_asynccancel 0052 __pthread_disable_asynccancel 002a __syscall_error"
	strings:
		$1 = { 65 83 3D 0C 00 00 00 00 75 25 53 8B 54 24 10 8B 4C 24 0C 8B 5C 24 08 B8 04 00 00 00 FF 15 ?? ?? ?? ?? 5B 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 E8 ?? ?? ?? ?? 50 53 8B 54 24 14 8B 4C 24 10 8B 5C 24 0C B8 04 00 00 00 FF 15 ?? ?? ?? ?? 5B 87 04 24 E8 ?? ?? ?? ?? 58 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_141_2_3 {
	meta:
		name = "__write"
		size = 99
		refs = "001e _dl_sysinfo 0030 __pthread_enable_asynccancel 0052 __pthread_disable_asynccancel 002a __syscall_error"
	strings:
		$1 = { 65 83 3D 0C 00 00 00 00 75 25 53 8B 54 24 10 8B 4C 24 0C 8B 5C 24 08 B8 04 00 00 00 FF 15 ?? ?? ?? ?? 5B 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 E8 ?? ?? ?? ?? 50 53 8B 54 24 14 8B 4C 24 10 8B 5C 24 0C B8 04 00 00 00 FF 15 ?? ?? ?? ?? 5B 87 04 24 E8 ?? ?? ?? ?? 58 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_321_1_0 {
	meta:
		name = "__write_nocancel"
		size = 37
		refs = "0014 _dl_sysinfo 0020 __syscall_error"
	strings:
		$1 = { 53 8B 54 24 10 8B 4C 24 0C 8B 5C 24 08 B8 04 00 00 00 FF 15 ?? ?? ?? ?? 5B 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_322_0_0 {
	meta:
		name = "wctomb"
		size = 123
		refs = "0014 __wctomb_state 0020 __wcrtomb 0031 _nl_current_LC_CTYPE 0062 _nl_C_LC_CTYPE 006b __wcsmbs_load_conv 0075 __wcsmbs_gconv_fcts_c"
	strings:
		$1 = { 53 83 EC 18 8B 44 24 20 85 C0 74 24 8B 54 24 24 C7 44 24 08 ?? ?? ?? ?? 89 04 24 89 54 24 04 E8 ?? ?? ?? ?? 83 C4 18 5B C3 8D B4 26 00 00 00 00 A1 ?? ?? ?? ?? 65 8B 00 8B 18 8B 53 14 85 D2 74 1F C7 05 ?? ?? ?? ?? 00 00 00 00 8B 42 08 C7 05 ?? ?? ?? ?? 00 00 00 00 8B 40 34 83 C4 18 5B C3 81 FB ?? ?? ?? ?? 74 0C 89 D8 E8 ?? ?? ?? ?? 8B 53 14 EB CD BA ?? ?? ?? ?? EB C6 }
	condition:
		$1
}

rule file_323_0_0 {
	meta:
		name = "sigrelse"
		size = 103
		refs = "001f __sigprocmask 0036 sigdelset"
	strings:
		$1 = { 53 81 EC 98 00 00 00 8D 5C 24 10 89 5C 24 08 C7 44 24 04 00 00 00 00 C7 04 24 02 00 00 00 E8 ?? ?? ?? ?? 85 C0 78 39 8B 84 24 A0 00 00 00 89 1C 24 89 44 24 04 E8 ?? ?? ?? ?? 85 C0 78 22 C7 44 24 08 00 00 00 00 89 5C 24 04 C7 04 24 02 00 00 00 E8 ?? ?? ?? ?? 81 C4 98 00 00 00 5B C3 66 90 B8 FF FF FF FF EB EF }
	condition:
		$1
}

rule file_670_0_0 {
	meta:
		name = "sighold"
		size = 103
		refs = "001f __sigprocmask 0036 sigaddset"
	strings:
		$1 = { 53 81 EC 98 00 00 00 8D 5C 24 10 89 5C 24 08 C7 44 24 04 00 00 00 00 C7 04 24 02 00 00 00 E8 ?? ?? ?? ?? 85 C0 78 39 8B 84 24 A0 00 00 00 89 1C 24 89 44 24 04 E8 ?? ?? ?? ?? 85 C0 78 22 C7 44 24 08 00 00 00 00 89 5C 24 04 C7 04 24 02 00 00 00 E8 ?? ?? ?? ?? 81 C4 98 00 00 00 5B C3 66 90 B8 FF FF FF FF EB EF }
	condition:
		$1
}

rule file_324_0_0 {
	meta:
		name = "__mempcpy"
		size = 34
	strings:
		$1 = { 8B 4C 24 0C 89 F8 8B 7C 24 04 89 F2 8B 74 24 08 FC D1 E9 73 01 A4 D1 E9 73 02 66 A5 F3 A5 97 89 D6 C3 }
	condition:
		$1
}

rule file_326_0_0 {
	meta:
		name = "l64a"
		size = 58
	strings:
		$1 = { 8B 54 24 04 B8 ?? ?? ?? ?? 85 D2 74 2B 31 C0 90 89 D1 83 C0 01 83 E1 3F 0F B6 89 ?? ?? ?? ?? C1 EA 06 88 88 ?? ?? ?? ?? 85 D2 75 E4 C6 80 ?? ?? ?? ?? 00 B8 ?? ?? ?? ?? F3 C3 }
	condition:
		$1
}

rule file_327_0_0 {
	meta:
		name = "rexec_af"
		size = 1455
		refs = "0053 __snprintf 00a3 getaddrinfo 00c7 free 00d6 __strdup 011b ruserpass 0139 __socket 0159 __connect 0162 __libc_errno 0175 __close 017f __sleep 0198 perror 0212 __listen 022e __getsockname 0246 __libc_sa_len 0280 getnameinfo 02ac sprintf 02f5 __write 031b accept 0358 freeaddrinfo 0375 strtol 03bf strlen 0420 __writev 046e __read"
	strings:
		$1 = { 55 57 56 53 81 EC AC 01 00 00 8B 94 24 C8 01 00 00 8D 7C 24 60 0F B7 84 24 C4 01 00 00 66 C1 C8 08 0F B7 C0 0F B7 9C 24 D8 01 00 00 89 54 24 24 8B 94 24 CC 01 00 00 89 44 24 0C C7 44 24 08 ?? ?? ?? ?? C7 44 24 04 20 00 00 00 89 3C 24 89 54 24 28 E8 ?? ?? ?? ?? 31 C0 C6 44 24 7F 00 C7 44 04 40 00 00 00 00 83 C0 04 83 F8 20 72 F0 8B 94 24 C0 01 00 00 8D 44 24 34 89 44 24 0C 8D 44 24 40 89 44 24 08 89 7C 24 04 8B 02 89 5C 24 44 C7 44 24 48 01 00 00 00 C7 44 24 40 02 00 00 00 89 04 24 E8 ?? ?? ?? ?? 85 C0 0F 85 D7 02 00 00 8B 44 24 34 8B 50 18 85 D2 0F 84 2F 04 00 00 A1 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 8B 44 24 34 8B 40 18 89 04 24 E8 ?? ?? ?? ?? 85 C0 A3 ?? ?? ?? ?? 0F 84 71 04 00 00 8B 94 24 C0 01 00 00 BB 06 00 00 00 BE 01 00 00 00 89 02 8D 84 24 CC 01 00 00 89 44 24 08 8D 84 24 C8 01 00 00 89 44 24 04 8B 44 24 34 8B 40 18 89 04 24 E8 ?? ?? ?? ?? 8B 44 24 34 C7 44 24 08 00 00 00 00 8B 50 08 89 54 24 04 8B 40 04 89 04 24 E8 ?? ?? ?? ?? 85 C0 89 C5 78 6D 8B 44 24 34 8B 50 10 8B 40 14 89 2C 24 89 54 24 08 89 44 24 04 E8 ?? ?? ?? ?? 85 C0 79 67 A1 ?? ?? ?? ?? 65 83 38 6F 75 1C 83 EB 01 74 17 89 2C 24 E8 ?? ?? ?? ?? 89 34 24 01 F6 E8 ?? ?? ?? ?? EB 9A 8D 76 00 8B 44 24 34 BD FF FF FF FF 8B 40 18 89 04 24 E8 ?? ?? ?? ?? 81 C4 AC 01 00 00 89 E8 5B 5E 5F 5D C3 8D B4 26 00 00 00 00 C7 04 24 ?? ?? ?? ?? BD FF FF FF FF E8 ?? ?? ?? ?? EB D9 90 8D 74 26 00 8B 84 24 D4 01 00 00 85 C0 0F 84 39 03 00 00 8B 44 24 34 C7 44 24 08 00 00 00 00 8B 48 08 89 4C 24 04 8B 40 04 89 04 24 E8 ?? ?? ?? ?? 85 C0 89 C3 0F 88 9E 03 00 00 C7 44 24 04 01 00 00 00 8D B4 24 20 01 00 00 89 04 24 E8 ?? ?? ?? ?? 8D 44 24 38 89 44 24 08 89 74 24 04 89 1C 24 C7 44 24 38 80 00 00 00 E8 ?? ?? ?? ?? 85 C0 0F 88 4A 03 00 00 0F B7 84 24 20 01 00 00 89 04 24 E8 ?? ?? ?? ?? 3B 44 24 38 0F 85 EB 02 00 00 C7 44 24 18 02 00 00 00 C7 44 24 14 20 00 00 00 89 7C 24 10 C7 44 24 0C 00 00 00 00 C7 44 24 08 00 00 00 00 89 44 24 04 89 34 24 E8 ?? ?? ?? ?? 31 C9 66 C7 44 24 2E 00 00 85 C0 0F 84 CC 00 00 00 8D BC 24 80 00 00 00 89 4C 24 08 C7 44 24 04 ?? ?? ?? ?? 89 3C 24 E8 ?? ?? ?? ?? 89 F9 8B 11 83 C1 04 8D 82 FF FE FE FE F7 D2 21 D0 25 80 80 80 80 74 EA 89 C6 C1 EE 10 A9 80 80 00 00 0F 44 C6 8D 71 02 0F 44 CE 00 C0 83 D9 03 29 F9 83 C1 01 89 4C 24 08 8D 74 24 3C 89 7C 24 04 89 2C 24 E8 ?? ?? ?? ?? C7 44 24 3C 80 00 00 00 8D B4 26 00 00 00 00 8D 84 24 A0 00 00 00 89 74 24 08 89 44 24 04 89 1C 24 E8 ?? ?? ?? ?? 83 F8 FF 75 6C A1 ?? ?? ?? ?? 65 83 38 04 74 D9 89 1C 24 E8 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 2C 24 BD FF FF FF FF E8 ?? ?? ?? ?? 8B 44 24 34 89 04 24 E8 ?? ?? ?? ?? E9 3B FE FF FF C7 44 24 08 0A 00 00 00 C7 44 24 04 00 00 00 00 89 3C 24 E8 ?? ?? ?? ?? 66 89 44 24 2E 0F B7 C8 E9 0F FF FF FF BD FF FF FF FF E9 0C FE FF FF 89 1C 24 89 44 24 20 E8 ?? ?? ?? ?? 8B 4C 24 20 85 C9 78 93 8B 94 24 D4 01 00 00 89 0A 8B 84 24 C8 01 00 00 89 04 24 89 84 24 80 00 00 00 E8 ?? ?? ?? ?? 83 C0 01 89 84 24 84 00 00 00 8B 84 24 CC 01 00 00 89 04 24 89 84 24 88 00 00 00 E8 ?? ?? ?? ?? 83 C0 01 89 84 24 8C 00 00 00 8B 84 24 D0 01 00 00 89 04 24 89 84 24 90 00 00 00 E8 ?? ?? ?? ?? 83 C0 01 89 84 24 94 00 00 00 8D 76 00 C7 44 24 08 03 00 00 00 89 7C 24 04 89 2C 24 E8 ?? ?? ?? ?? 83 F8 FF 75 0B A1 ?? ?? ?? ?? 65 83 38 04 74 DC 8B 84 24 C8 01 00 00 3B 44 24 24 74 08 89 04 24 E8 ?? ?? ?? ?? 8B 84 24 CC 01 00 00 3B 44 24 28 74 08 89 04 24 E8 ?? ?? ?? ?? C7 44 24 08 01 00 00 00 89 74 24 04 89 2C 24 E8 ?? ?? ?? ?? 83 F8 01 0F 85 F3 00 00 00 80 7C 24 3C 00 75 11 8B 44 24 34 89 04 24 E8 ?? ?? ?? ?? E9 09 FD FF FF C7 44 24 08 01 00 00 00 89 74 24 04 89 2C 24 E8 ?? ?? ?? ?? 83 F8 01 75 1F C7 44 24 08 01 00 00 00 89 74 24 04 C7 04 24 02 00 00 00 E8 ?? ?? ?? ?? 80 7C 24 3C 0A 75 C8 66 83 7C 24 2E 00 0F 84 6C FE FF FF 8B 94 24 D4 01 00 00 8B 02 89 04 24 E8 ?? ?? ?? ?? E9 56 FE FF FF 8B 94 24 C0 01 00 00 BD FF FF FF FF A1 ?? ?? ?? ?? C7 02 00 00 00 00 65 C7 00 02 00 00 00 E9 8C FC FF FF C7 44 24 08 01 00 00 00 8D BC 24 80 00 00 00 C7 44 24 04 ?? ?? ?? ?? 8D 74 24 3C 89 2C 24 E8 ?? ?? ?? ?? 66 C7 44 24 2E 00 00 E9 6E FE FF FF A1 ?? ?? ?? ?? 65 C7 00 16 00 00 00 89 1C 24 E8 ?? ?? ?? ?? E9 EB FD FF FF C7 04 24 ?? ?? ?? ?? BD FF FF FF FF E8 ?? ?? ?? ?? E9 2E FC FF FF 8B 94 24 C0 01 00 00 8B 02 89 04 24 E8 ?? ?? ?? ?? E9 47 FF FF FF C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 1C 24 E8 ?? ?? ?? ?? E9 A6 FD FF FF 89 2C 24 BD FF FF FF FF E8 ?? ?? ?? ?? E9 ED FB FF FF }
	condition:
		$1
}

rule file_327_1_0 {
	meta:
		name = "rexec"
		size = 67
		refs = "003b rexec_af"
	strings:
		$1 = { 83 EC 2C 8B 44 24 44 C7 44 24 18 02 00 00 00 89 44 24 14 8B 44 24 40 89 44 24 10 8B 44 24 3C 89 44 24 0C 8B 44 24 38 89 44 24 08 8B 44 24 34 89 44 24 04 8B 44 24 30 89 04 24 E8 ?? ?? ?? ?? 83 C4 2C C3 }
	condition:
		$1
}

rule file_329_0_0 {
	meta:
		name = "__posix_fadvise64_l64"
		size = 52
		refs = "0023 _dl_sysinfo"
	strings:
		$1 = { 55 53 56 57 8B 5C 24 14 8B 4C 24 18 8B 54 24 1C 8B 74 24 20 8B 7C 24 24 8B 6C 24 28 B8 10 01 00 00 FF 15 ?? ?? ?? ?? 5F 5E 5B 5D F7 D8 C3 B8 26 00 00 00 C3 }
	condition:
		$1
}

rule file_329_1_0 {
	meta:
		name = "__posix_fadvise64_l32"
		size = 40
		refs = "001e _dl_sysinfo"
	strings:
		$1 = { 57 56 53 8B 7C 24 20 8B 74 24 1C 8B 54 24 18 8B 4C 24 14 8B 5C 24 10 B8 FA 00 00 00 FF 15 ?? ?? ?? ?? 5B 5E 5F F7 D8 C3 }
	condition:
		$1
}

rule file_331_0_0 {
	meta:
		name = "map_newlink"
		size = 102
	strings:
		$1 = { 57 56 53 8B 74 24 10 85 F6 7E 2A 89 C7 8B 01 83 F8 FF 74 4C 39 F8 74 4A 83 C1 04 31 C0 EB 0F 90 8B 19 83 FB FF 74 19 83 C1 04 39 FB 74 0C 83 C0 01 39 F0 75 EB B8 FF FF FF FF 5B 5E 5F C2 04 00 85 C0 89 39 7E F4 8D 48 FF 69 D8 9C 00 00 00 69 C9 9C 00 00 00 01 D3 89 1C 0A 5B 5E 5F C2 04 00 89 39 31 C0 EB D4 }
	condition:
		$1
}

rule file_331_1_0 {
	meta:
		name = "getifaddrs_internal"
		size = 2680
		refs = "003f __netlink_open 005a __netlink_request 0155 __netlink_free_handle 0163 _dl_sysinfo 0229 calloc 0267 memset 0462 memcpy 050f mempcpy 0a46 free 0a6f __assert_fail 0a74 abort"
	strings:
		$1 = { 55 89 E5 57 56 53 81 EC 8C 00 00 00 C7 00 00 00 00 00 89 45 9C 8D 45 D4 89 04 24 C7 45 D4 00 00 00 00 C7 45 D8 00 00 00 00 C7 45 DC 00 00 00 00 C7 45 E0 00 00 00 00 C7 45 E4 00 00 00 00 E8 ?? ?? ?? ?? 85 C0 0F 88 E5 09 00 00 8D 55 D4 C7 44 24 04 12 00 00 00 89 14 24 E8 ?? ?? ?? ?? 85 C0 0F 88 87 01 00 00 8D 4D D4 C7 44 24 04 16 00 00 00 89 0C 24 83 45 DC 01 E8 ?? ?? ?? ?? 85 C0 0F 88 68 01 00 00 8B 5D E0 85 DB 89 5D C0 0F 84 75 01 00 00 8B 7D D8 89 5D C4 C7 45 AC 00 00 00 00 C7 45 BC 00 00 00 00 C7 45 A8 00 00 00 00 66 90 8B 45 C4 8B 70 08 8B 40 04 85 C0 74 73 83 FE 0F 76 6E 8B 10 83 FA 0F 76 67 39 D6 73 25 8D 76 00 EB 5E 8D B6 00 00 00 00 83 C2 03 83 E2 FC 29 D6 01 D0 83 FE 0F 76 49 8B 10 83 FA 0F 76 42 39 F2 77 3E 39 78 0C 75 E1 8B 4D C4 8B 49 0C 39 48 08 75 D6 0F B7 48 04 66 83 F9 03 74 24 66 83 F9 10 74 66 66 83 F9 14 0F 94 C1 83 C2 03 83 E2 FC 0F B6 C9 29 D6 01 D0 01 4D BC 83 FE 0F 77 B9 66 90 8B 5D C4 8B 1B 85 DB 89 5D C4 0F 85 70 FF FF FF 8B 5D BC 31 F6 03 5D A8 0F 85 C1 00 00 00 8D 4D D4 89 0C 24 E8 ?? ?? ?? ?? 8B 5D D4 B8 06 00 00 00 FF 15 ?? ?? ?? ?? 8D 65 F4 89 F0 5B 5E 5F 5D C3 8D B4 26 00 00 00 00 8D 4A E0 8D 58 20 83 F9 03 89 5D A4 89 4D B8 76 5B 0F B7 48 20 66 83 F9 03 76 51 39 4D B8 72 4C 66 83 78 22 07 8D 59 FC 89 5D B4 74 5B 89 45 B4 8B 5D A4 89 55 B0 8B 45 B8 EB 1C 90 8D 74 26 00 0F B7 0B 66 83 F9 03 76 1D 39 C1 77 19 66 83 7B 02 07 8D 51 FC 74 28 83 C1 03 83 E1 FC 29 C8 01 CB 83 F8 03 77 DA 8B 45 B4 8B 55 B0 83 45 A8 01 E9 EB FE FF FF BE FF FF FF FF E9 57 FF FF FF 8B 45 B4 89 55 B4 8B 55 B0 8B 4D B4 01 4D AC EB DC 31 F6 E9 3F FF FF FF 69 DB 9C 00 00 00 8B 75 AC C7 04 24 01 00 00 00 01 DE 89 74 24 04 89 75 8C E8 ?? ?? ?? ?? 85 C0 89 45 A0 74 B9 8B 75 A8 C1 E6 02 89 F0 83 C0 1E 83 E0 F0 29 C4 89 75 88 8D 74 24 1F 83 E6 F0 89 75 94 8B 75 88 C7 44 24 04 FF FF FF FF 89 74 24 08 8B 75 94 89 34 24 E8 ?? ?? ?? ?? 03 5D A0 C7 45 98 00 00 00 00 89 5D B0 8B 5D C0 8B 7B 08 8B 5B 04 85 DB 0F 84 E7 01 00 00 83 FF 0F 0F 86 DE 01 00 00 8B 33 83 FE 0F 0F 86 D3 01 00 00 39 F7 0F 82 CB 01 00 00 89 F2 89 DE 89 FB EB 2B 8D 76 00 8B 06 83 C0 03 83 E0 FC 29 C3 01 C6 83 FB 0F 0F 86 AB 01 00 00 8B 16 83 FA 0F 0F 86 A0 01 00 00 39 DA 0F 87 98 01 00 00 8B 7D D8 39 7E 0C 75 D0 8B 45 C0 8B 40 0C 39 46 08 75 C5 0F B7 46 04 66 83 F8 03 0F 84 77 01 00 00 66 83 F8 10 0F 84 F5 02 00 00 66 83 F8 14 75 A7 83 EA 18 8B 46 14 89 55 C4 8B 55 A8 8D 7E 18 8B 4D 94 89 7D BC 8B 7D 98 83 E8 01 89 14 24 8B 55 A0 03 7D A8 E8 BE F8 FF FF 83 EC 04 83 F8 FF 0F 84 FC 06 00 00 69 C0 9C 00 00 00 8B 4D A0 69 D7 9C 00 00 00 03 55 A0 85 FF 8B 44 01 08 89 55 A4 89 42 08 7E 0C 8D 47 FF 69 C0 9C 00 00 00 89 14 01 83 45 98 01 83 7D C4 03 0F 86 58 04 00 00 0F B7 46 18 66 83 F8 03 0F 86 4A 04 00 00 39 45 C4 0F 82 41 04 00 00 8B 7D A4 89 5D 90 8B 5D BC 89 75 B4 8B 75 A4 83 C7 1C 89 7D AC EB 3A 66 90 66 83 FA 01 0F 84 FE 01 00 00 0F B7 03 83 C0 03 83 E0 FC 29 45 C4 01 C3 83 7D C4 03 0F 86 00 04 00 00 0F B7 03 66 83 F8 03 0F 86 F3 03 00 00 3B 45 C4 0F 87 EA 03 00 00 8D 53 04 89 55 B8 8D 50 FC 89 55 BC 0F B7 53 02 66 83 FA 02 0F 84 26 01 00 00 76 AC 66 83 FA 03 0F 84 E2 00 00 00 66 83 FA 04 75 A6 8B 46 14 8D 56 64 85 C0 74 0B B9 09 00 00 00 31 C0 89 D7 F3 AB 89 56 14 8B 55 B4 0F B6 42 10 66 89 46 64 0F B6 42 10 3C 02 0F 84 C5 04 00 00 3C 0A 0F 84 5C 04 00 00 83 7D BC 24 0F 87 65 FF FF FF 8D 46 66 8B 55 BC 89 04 24 89 54 24 08 8B 55 B8 89 54 24 04 E8 ?? ?? ?? ?? E9 47 FF FF FF 90 8D 74 26 00 8B 5D C0 8B 1B 85 DB 89 5D C0 0F 85 F8 FD FF FF 8B 45 A0 03 45 8C 39 45 B0 0F 87 C0 05 00 00 8B 45 98 85 C0 74 3C 8B 45 A8 85 C0 74 35 8B 45 94 8B 4D 88 69 5D A8 9C 00 00 00 03 5D A0 8B 55 A0 01 C1 EB 11 8D 74 26 00 83 C0 04 81 C2 9C 00 00 00 39 C8 74 0D 83 38 FF 75 EE 89 9A 64 FF FF FF EB E6 8B 55 A0 31 F6 8B 45 9C 89 10 E9 6D FC FF FF 8D B4 26 00 00 00 00 83 E8 03 83 F8 11 0F 87 7F 05 00 00 8B 55 BC 8D 86 88 00 00 00 89 46 04 89 04 24 89 54 24 08 8B 55 B8 89 54 24 04 E8 ?? ?? ?? ?? C6 00 00 E9 97 FE FF FF 90 8D 74 26 00 8B 46 0C 85 C0 74 4E 8B 46 1C B9 09 00 00 00 8B 7D AC 8D 56 64 89 56 14 89 46 64 8B 46 20 89 46 68 8B 46 24 89 46 6C 8B 46 28 89 46 70 8B 46 2C 89 46 74 8B 46 30 89 46 78 8B 46 34 89 46 7C 8B 46 38 89 86 80 00 00 00 8B 46 3C 89 86 84 00 00 00 31 C0 F3 AB 8B 55 B4 8B 7D AC 89 7E 0C 0F B6 42 10 66 89 46 1C 0F B6 42 10 3C 02 0F 84 E6 03 00 00 3C 0A 0F 84 7D 03 00 00 83 7D BC 24 8D 46 1E 0F 87 0B FE FF FF E9 A4 FE FF FF 8D 74 26 00 8B 46 0C 85 C0 0F 84 D4 03 00 00 8D 46 64 89 46 14 8B 4D B4 0F B6 51 10 66 89 10 0F B6 51 10 80 FA 02 0F 84 B0 02 00 00 80 FA 0A 0F 84 49 02 00 00 83 C0 02 83 7D BC 24 0F 87 C4 FD FF FF E9 5D FE FF FF 90 8D 74 26 00 83 EA 20 8B 46 14 89 55 BC 8B 55 A8 8D 7E 20 8B 4D 94 83 E8 01 89 14 24 8B 55 A0 E8 D8 F5 FF FF 83 EC 04 83 F8 FF 0F 84 16 04 00 00 69 C0 9C 00 00 00 03 45 A0 83 7D BC 03 89 45 C4 8B 46 18 8B 55 C4 89 42 08 0F 86 6D FC FF FF 0F B7 46 20 66 83 F8 03 0F 86 5F FC FF FF 39 45 BC 0F 82 56 FC FF FF 8B 4D C4 81 C2 88 00 00 00 89 5D B4 8B 5D BC 89 55 B8 89 75 BC 83 C1 28 89 4D AC EB 36 90 66 83 FE 01 0F 84 EE 00 00 00 0F B7 07 83 C0 03 83 E0 FC 29 C3 01 C7 83 FB 03 0F 86 27 01 00 00 0F B7 07 66 83 F8 03 0F 86 1A 01 00 00 39 D8 0F 87 12 01 00 00 0F B7 77 02 8D 4F 04 8D 50 FC 66 83 FE 02 74 33 76 B9 66 83 FE 03 74 7B 66 83 FE 07 75 B7 8B 45 B0 8B 75 C4 89 46 18 89 C6 01 D6 89 54 24 08 89 4C 24 04 89 04 24 E8 ?? ?? ?? ?? 89 75 B0 EB 95 8D 76 00 83 FA 24 77 8D 8B 75 C4 89 F0 83 C0 70 66 C7 46 64 11 00 89 54 24 08 89 4C 24 04 89 04 24 89 55 84 E8 ?? ?? ?? ?? 8B 55 84 88 56 6F 8B 55 BC 8B 42 14 89 46 68 0F B7 42 12 66 89 46 6C 89 F0 83 C0 64 89 46 14 E9 48 FF FF FF 8D B6 00 00 00 00 83 E8 03 83 F8 11 0F 87 36 FF FF FF 8B 45 B8 8B 75 C4 89 46 04 89 54 24 08 89 4C 24 04 89 04 24 E8 ?? ?? ?? ?? C6 00 00 E9 15 FF FF FF 8D 76 00 83 FA 24 0F 87 09 FF FF FF 8B 75 C4 66 C7 46 1C 11 00 89 4C 24 04 8B 4D AC 89 54 24 08 89 55 84 89 0C 24 E8 ?? ?? ?? ?? 8B 55 84 88 56 27 8B 75 BC 8B 55 C4 8B 46 14 89 42 20 0F B7 46 12 66 89 42 24 89 D0 83 C0 1C 89 42 0C E9 C3 FE FF FF 8B 5D B4 8B 75 BC E9 E6 FA FF FF 8B 5D 90 8B 75 B4 8B 4D A4 8B 41 04 85 C0 0F 84 1B 02 00 00 8B 7D A4 8B 47 0C 85 C0 0F 84 C4 FA FF FF 0F B7 10 66 85 D2 0F 84 B8 FA FF FF 66 83 FA 11 0F 84 AE FA FF FF 89 F8 83 C0 40 66 83 FA 02 89 47 10 0F 84 D8 01 00 00 66 83 FA 0A 0F 84 7C 01 00 00 8B 7D A4 66 89 57 40 E9 86 FA FF FF 83 7D BC 10 0F 85 7E FB FF FF 8B 7D B8 8B 0F 89 48 08 8B 4F 04 89 48 0C 8B 4F 08 89 48 10 8B 4F 0C 89 48 14 8B 53 04 81 E2 FF C0 00 00 81 FA FE 80 00 00 74 1A 80 7B 04 FF 0F 85 49 FB FF FF 0F B6 53 05 83 E2 0F 80 FA 02 0F 85 39 FB FF FF 8B 4D B4 8B 51 14 89 50 18 E9 2B FB FF FF 90 83 7D BC 04 0F 85 20 FB FF FF 8B 7D B8 8B 17 89 50 04 E9 13 FB FF FF 83 7D BC 10 0F 85 09 FB FF FF 8B 4D B8 8B 11 89 56 6C 8B 51 04 89 56 70 8B 51 08 89 56 74 8B 51 0C 89 56 78 8B 43 04 25 FF C0 00 00 3D FE 80 00 00 74 19 80 7B 04 FF 0F 85 D6 FA FF FF 0F B6 43 05 83 E0 0F 3C 02 0F 85 C7 FA FF FF 8B 55 B4 8B 42 14 89 46 7C E9 B9 FA FF FF 8D B4 26 00 00 00 00 83 7D BC 04 0F 85 A8 FA FF FF 8B 55 B8 8B 02 89 46 68 E9 9B FA FF FF 83 7D BC 10 0F 85 91 FA FF FF 8B 4D B8 8B 11 89 56 24 8B 51 04 89 56 28 8B 51 08 89 56 2C 8B 51 0C 89 56 30 8B 43 04 25 FF C0 00 00 3D FE 80 00 00 74 19 80 7B 04 FF 0F 85 5E FA FF FF 0F B6 43 05 83 E0 0F 3C 02 0F 85 4F FA FF FF 8B 55 B4 8B 42 14 89 46 34 E9 41 FA FF FF 8D B4 26 00 00 00 00 83 7D BC 04 0F 85 30 FA FF FF 8B 55 B8 8B 02 89 46 20 E9 23 FA FF FF 8B 45 AC 89 46 0C E9 27 FC FF FF 8B 45 A4 B9 80 00 00 00 83 C0 48 8B 7D A4 66 89 57 40 0F B6 56 11 39 D1 0F 47 CA 89 CF C1 EF 03 85 FF 8D 14 38 74 11 8D B4 26 00 00 00 00 C6 00 FF 83 C0 01 39 D0 75 F6 83 E1 07 BA 08 00 00 00 29 CA 89 D1 BA FF FF FF FF D3 E2 88 10 E9 C4 F8 FF FF 8B 45 A4 B9 20 00 00 00 83 C0 44 EB AC 8B 46 14 8B 7D A8 8B 4D 94 8B 55 A0 83 E8 01 89 3C 24 E8 E0 F1 FF FF 83 EC 04 83 F8 FF 74 22 69 C0 9C 00 00 00 8B 55 A0 8B 4D A4 8B 44 02 04 89 41 04 E9 AE FD FF FF BE FF FF FF FF E9 2D F7 FF FF 8B 45 A0 BE F5 FF FF FF 89 04 24 E8 ?? ?? ?? ?? E9 FF F6 FF FF C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 31 03 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_331_2_0 {
	meta:
		name = "__netlink_free_handle"
		size = 58
		refs = "0008 __libc_errno 0026 free"
	strings:
		$1 = { 57 56 53 83 EC 10 8B 35 ?? ?? ?? ?? 8B 44 24 20 65 8B 3E 8B 40 0C 85 C0 74 16 8D B6 00 00 00 00 8B 18 89 04 24 E8 ?? ?? ?? ?? 85 DB 89 D8 75 F0 65 89 3E 83 C4 10 5B 5E 5F C3 }
	condition:
		$1
}

rule file_331_3_0 {
	meta:
		name = "__netlink_request"
		size = 639
		refs = "0081 __libc_errno 00b8 __sendto 010d __recvmsg 01fa malloc 0221 memcpy 0253 time"
	strings:
		$1 = { 55 89 E5 57 56 53 81 EC 9C 10 00 00 8B 75 08 8D 4C 24 27 83 E1 F0 89 4D 90 8B 46 08 89 4D A4 C7 45 A8 00 10 00 00 85 C0 0F 84 1D 02 00 00 8B 55 0C 8D 5D B8 C7 45 AC 00 00 00 00 C7 45 B8 14 00 00 00 66 C7 45 BE 01 03 66 89 55 BC C7 45 C4 00 00 00 00 89 45 C0 C6 45 C8 00 66 C7 45 C9 00 00 C6 45 CB 00 C7 45 B0 00 00 00 00 C7 45 B4 00 00 00 00 66 C7 45 AC 10 00 EB 15 8D B6 00 00 00 00 A1 ?? ?? ?? ?? 65 83 38 04 0F 85 92 00 00 00 8D 45 AC C7 44 24 14 0C 00 00 00 89 44 24 10 C7 44 24 0C 00 00 00 00 C7 44 24 08 14 00 00 00 89 5C 24 04 8B 06 89 04 24 E8 ?? ?? ?? ?? 83 F8 FF 74 BF 85 C0 78 5C 8D 76 00 8D 4D AC 8D 5D A4 89 4D CC C7 45 D0 0C 00 00 00 89 5D D4 C7 45 D8 01 00 00 00 C7 45 DC 00 00 00 00 C7 45 E0 00 00 00 00 C7 45 E4 00 00 00 00 90 8D 45 CC C7 44 24 08 00 00 00 00 89 44 24 04 8B 06 89 04 24 E8 ?? ?? ?? ?? 83 F8 FF 75 1A A1 ?? ?? ?? ?? 65 83 38 04 74 D7 8D 65 F4 B8 FF FF FF FF 5B 5E 5F 5D C3 66 90 85 C0 78 ED 8B 7D B0 85 FF 75 8D F6 45 E4 20 75 E0 83 F8 0F 76 82 8B 4D 90 8B 11 83 FA 0F 0F 86 74 FF FF FF 39 D0 0F 82 6C FF FF FF 8B 4E 04 8B 7D 90 C7 45 94 00 00 00 00 89 45 8C EB 1C 66 90 83 C2 03 83 E2 FC 29 D0 01 D7 83 F8 0F 76 51 8B 17 83 FA 0F 76 4A 39 C2 77 46 3B 4F 0C 75 E1 8B 5E 08 39 5F 08 75 D9 0F B7 5F 04 83 45 94 01 66 83 FB 03 0F 84 B6 00 00 00 66 83 FB 02 75 C1 83 FA 23 0F 87 B4 00 00 00 A1 ?? ?? ?? ?? 65 C7 00 05 00 00 00 E9 58 FF FF FF 8D B4 26 00 00 00 00 8B 5D 8C 31 D2 8B 4D 94 85 C9 75 14 84 D2 0F 84 E4 FE FF FF 8D 65 F4 31 C0 5B 5E 5F 5D C3 66 90 8D 43 10 89 04 24 88 55 88 E8 ?? ?? ?? ?? 85 C0 89 C7 0F 84 19 FF FF FF 8B 4D 90 83 C0 10 C7 40 F0 00 00 00 00 89 5C 24 08 89 04 24 89 4C 24 04 E8 ?? ?? ?? ?? 0F B6 55 88 89 5F 08 89 47 04 8B 46 08 89 47 0C 8B 46 0C 85 C0 74 0A 8B 46 10 89 38 89 7E 10 EB 96 89 7E 0C EB F6 C7 04 24 00 00 00 00 E8 ?? ?? ?? ?? 89 46 08 E9 CF FD FF FF 8B 5D 8C BA 01 00 00 00 E9 69 FF FF FF 8B 47 10 8B 15 ?? ?? ?? ?? F7 D8 65 89 02 E9 A2 FE FF FF }
	condition:
		$1
}

rule file_331_4_0 {
	meta:
		name = "__netlink_close"
		size = 20
		refs = "000e _dl_sysinfo"
	strings:
		$1 = { 53 8B 44 24 08 8B 18 B8 06 00 00 00 FF 15 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule file_331_5_0 {
	meta:
		name = "__netlink_open"
		size = 191
		refs = "0021 __socket 0062 __bind 0084 __getsockname 00a9 _dl_sysinfo"
	strings:
		$1 = { 56 53 83 EC 24 C7 44 24 08 00 00 00 00 8B 5C 24 30 C7 44 24 04 03 00 00 00 C7 04 24 10 00 00 00 E8 ?? ?? ?? ?? 85 C0 89 03 0F 88 89 00 00 00 8D 74 24 14 C7 44 24 08 0C 00 00 00 89 74 24 04 89 04 24 C7 44 24 14 00 00 00 00 C7 44 24 18 00 00 00 00 C7 44 24 1C 00 00 00 00 66 C7 44 24 14 10 00 E8 ?? ?? ?? ?? 85 C0 78 36 8D 44 24 10 89 44 24 08 89 74 24 04 8B 03 C7 44 24 10 0C 00 00 00 89 04 24 E8 ?? ?? ?? ?? 85 C0 78 14 8B 44 24 18 89 43 04 31 C0 83 C4 24 5B 5E C3 90 8D 74 26 00 8B 1B B8 06 00 00 00 FF 15 ?? ?? ?? ?? B8 FF FF FF FF EB E1 8D 74 26 00 B8 FF FF FF FF EB D6 }
	condition:
		$1
}

rule file_331_6_0 {
	meta:
		name = "getifaddrs"
		size = 25
	strings:
		$1 = { 53 83 EC 08 8B 5C 24 10 89 D8 E8 71 F5 FF FF 83 F8 F5 74 F4 83 C4 08 5B C3 }
	condition:
		$1
}

rule file_332_3_0 {
	meta:
		name = "putwchar"
		size = 246
		refs = "0009 _IO_stdout 00bc __woverflow 00f2 _Unwind_Resume"
	strings:
		$1 = { 83 EC 1C 89 5C 24 10 8B 1D ?? ?? ?? ?? 89 74 24 14 8B 74 24 20 89 7C 24 18 8B 03 89 DF 25 00 80 00 00 75 38 8B 53 48 65 8B 3D 08 00 00 00 3B 7A 08 74 7D B9 01 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 0A 0F 85 AA 00 00 00 8B 53 48 89 7A 08 8B 3D ?? ?? ?? ?? 83 42 04 01 8B 57 58 85 D2 74 51 8B 4A 10 3B 4A 14 73 49 89 31 83 C1 04 89 4A 10 F7 03 00 80 00 00 75 20 8B 53 48 83 6A 04 01 75 17 C7 42 08 00 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 83 2A 01 75 67 89 F0 8B 5C 24 10 8B 74 24 14 8B 7C 24 18 83 C4 1C C3 8D 76 00 89 DF EB A4 89 74 24 04 89 3C 24 E8 ?? ?? ?? ?? 89 C6 EB AF F7 03 00 80 00 00 89 C6 75 20 8B 53 48 83 6A 04 01 75 17 C7 42 08 00 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 83 2A 01 75 1D 89 34 24 E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_333_0_0 {
	meta:
		name = "futimesat"
		size = 355
		refs = "0007 __have_atfcts 0032 _dl_sysinfo 006b strlen 00a6 __snprintf 00d2 __atfct_seterrno 00f6 __futimes 0132 __libc_errno"
	strings:
		$1 = { 55 89 E5 83 EC 38 A1 ?? ?? ?? ?? 89 75 F8 8B 75 0C 89 5D F4 89 7D FC 85 C0 78 35 85 F6 0F 84 C5 00 00 00 8B 5D 08 89 F1 8B 55 10 B8 2B 01 00 00 FF 15 ?? ?? ?? ?? 3D 00 F0 FF FF 0F 87 EF 00 00 00 8B 5D F4 8B 75 F8 8B 7D FC 89 EC 5D C3 66 90 85 F6 0F 84 A8 00 00 00 83 7D 08 9C 0F 84 7E 00 00 00 80 3E 2F 74 79 89 34 24 E8 ?? ?? ?? ?? 85 C0 0F 84 D8 00 00 00 8D 50 20 83 C0 3E 8B 5D 08 83 E0 F0 29 C4 8D 7C 24 23 83 E7 F0 89 74 24 10 89 FE 89 5C 24 0C C7 44 24 08 ?? ?? ?? ?? 89 54 24 04 89 3C 24 E8 ?? ?? ?? ?? 89 F3 8B 4D 10 B8 0F 01 00 00 FF 15 ?? ?? ?? ?? 3D 00 F0 FF FF 76 80 8B 5D 08 F7 D8 89 7C 24 08 89 04 24 89 5C 24 04 E8 ?? ?? ?? ?? 83 C8 FF E9 63 FF FF FF 66 90 31 FF EB C6 8D 74 26 00 8B 45 10 8B 5D 08 89 44 24 04 89 1C 24 E8 ?? ?? ?? ?? E9 42 FF FF FF 90 8B 5D 08 83 EC 30 8D 7C 24 23 83 E7 F0 C7 44 24 08 ?? ?? ?? ?? 89 FE 89 5C 24 0C C7 44 24 04 1D 00 00 00 89 3C 24 E8 ?? ?? ?? ?? E9 7A FF FF FF 8B 15 ?? ?? ?? ?? F7 D8 83 F8 26 65 89 02 75 96 C7 05 ?? ?? ?? ?? FF FF FF FF E9 09 FF FF FF A1 ?? ?? ?? ?? 65 C7 00 02 00 00 00 83 C8 FF E9 DE FE FF FF }
	condition:
		$1
}

rule file_334_0_0 {
	meta:
		name = "__getpeername"
		size = 34
		refs = "0012 _dl_sysinfo 001d __syscall_error"
	strings:
		$1 = { 89 DA B8 66 00 00 00 BB 07 00 00 00 8D 4C 24 04 FF 15 ?? ?? ?? ?? 89 D3 83 F8 83 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_335_0_0 {
	meta:
		name = "__lxstat"
		size = 139
		refs = "0020 _dl_sysinfo 005a __libc_errno 0082 __xstat32_conv"
	strings:
		$1 = { 53 83 EC 78 83 BC 24 80 00 00 00 01 74 2A 8D 4C 24 10 8B 9C 24 84 00 00 00 B8 C4 00 00 00 FF 15 ?? ?? ?? ?? 3D 00 F0 FF FF 77 2D 85 C0 74 39 83 C4 78 5B C3 8D 74 26 00 8B 9C 24 84 00 00 00 8B 8C 24 88 00 00 00 B8 6B 00 00 00 FF 15 ?? ?? ?? ?? 3D 00 F0 FF FF 76 D7 8B 15 ?? ?? ?? ?? F7 D8 65 89 02 83 C8 FF EB C7 8B 84 24 88 00 00 00 89 4C 24 04 8B 8C 24 80 00 00 00 89 44 24 08 89 0C 24 E8 ?? ?? ?? ?? 83 C4 78 5B C3 }
	condition:
		$1
}

rule file_336_0_0 {
	meta:
		name = "do_sigpause"
		size = 129
		refs = "0034 __sigsuspend 0062 __sigprocmask 0072 sigdelset"
	strings:
		$1 = { 56 53 81 EC 94 00 00 00 85 D2 75 3C 89 44 24 10 8D 44 24 14 8D 74 26 00 C7 00 00 00 00 00 8D 94 24 90 00 00 00 83 C0 04 39 D0 75 EC 8D 5C 24 10 89 1C 24 E8 ?? ?? ?? ?? 81 C4 94 00 00 00 5B 5E C3 8D B4 26 00 00 00 00 8D 5C 24 10 89 C6 89 5C 24 08 C7 44 24 04 00 00 00 00 C7 04 24 00 00 00 00 E8 ?? ?? ?? ?? 85 C0 78 10 89 74 24 04 89 1C 24 E8 ?? ?? ?? ?? 85 C0 79 B6 B8 FF FF FF FF EB B7 }
	condition:
		$1
}

rule file_336_1_0 {
	meta:
		name = "__sigpause"
		size = 92
		refs = "0034 __libc_enable_asynccancel 004a __libc_disable_asynccancel"
	strings:
		$1 = { 83 EC 1C 89 5C 24 14 8B 54 24 24 89 74 24 18 8B 5C 24 20 65 A1 0C 00 00 00 85 C0 75 12 89 D8 8B 74 24 18 8B 5C 24 14 83 C4 1C E9 41 FF FF FF 89 54 24 0C E8 ?? ?? ?? ?? 8B 54 24 0C 89 C6 89 D8 E8 2B FF FF FF 89 C3 89 F0 E8 ?? ?? ?? ?? 89 D8 8B 74 24 18 8B 5C 24 14 83 C4 1C C3 }
	condition:
		$1
}

rule file_336_2_0 {
	meta:
		name = "__default_sigpause"
		size = 27
		refs = "0013 __sigpause"
	strings:
		$1 = { 83 EC 1C 8B 44 24 20 C7 44 24 04 00 00 00 00 89 04 24 E8 ?? ?? ?? ?? 83 C4 1C C3 }
	condition:
		$1
}

rule file_769_1_0 {
	meta:
		name = "__canonicalize_file_name"
		size = 27
		refs = "0013 __realpath"
	strings:
		$1 = { 83 EC 1C 8B 44 24 20 C7 44 24 04 00 00 00 00 89 04 24 E8 ?? ?? ?? ?? 83 C4 1C C3 }
	condition:
		$1
}

rule file_1064_3_0 {
	meta:
		name = "__res_ninit"
		size = 27
		refs = "0013 __res_vinit"
	strings:
		$1 = { 83 EC 1C 8B 44 24 20 C7 44 24 04 00 00 00 00 89 04 24 E8 ?? ?? ?? ?? 83 C4 1C C3 }
	condition:
		$1
}

rule file_566_0_0 {
	meta:
		name = "atof"
		size = 27
		refs = "0013 strtod"
	strings:
		$1 = { 83 EC 1C 8B 44 24 20 C7 44 24 04 00 00 00 00 89 04 24 E8 ?? ?? ?? ?? 83 C4 1C C3 }
	condition:
		$1
}

rule file_336_3_0 {
	meta:
		name = "__xpg_sigpause"
		size = 27
		refs = "0013 __sigpause"
	strings:
		$1 = { 83 EC 1C 8B 44 24 20 C7 44 24 04 01 00 00 00 89 04 24 E8 ?? ?? ?? ?? 83 C4 1C C3 }
	condition:
		$1
}

rule file_1064_5_0 {
	meta:
		name = "__res_nclose"
		size = 27
		refs = "0013 __res_iclose"
	strings:
		$1 = { 83 EC 1C 8B 44 24 20 C7 44 24 04 01 00 00 00 89 04 24 E8 ?? ?? ?? ?? 83 C4 1C C3 }
	condition:
		$1
}

rule file_21_17_1 {
	meta:
		name = "__splitstack_releasecontext"
		size = 27
		refs = "0013 __morestack_release_segments"
	strings:
		$1 = { 83 EC 1C 8B 44 24 20 C7 44 24 04 01 00 00 00 89 04 24 E8 ?? ?? ?? ?? 83 C4 1C C3 }
	condition:
		$1
}

rule file_175_2_1 {
	meta:
		name = "free_segments"
		size = 27
		refs = "0013 __morestack_release_segments"
	strings:
		$1 = { 83 EC 1C 8B 44 24 20 C7 44 24 04 01 00 00 00 89 04 24 E8 ?? ?? ?? ?? 83 C4 1C C3 }
	condition:
		$1
}

rule file_337_0_0 {
	meta:
		name = "_nl_explode_name"
		size = 604
		refs = "0143 _nl_normalize_codeset 0166 strcmp 0202 __rawmemchr 0230 free"
	strings:
		$1 = { 55 57 56 53 83 EC 2C 8B 74 24 40 8B 44 24 44 8B 4C 24 4C 8B 6C 24 50 8B 54 24 48 8B 7C 24 54 C7 02 00 00 00 00 C7 01 00 00 00 00 C7 45 00 00 00 00 00 C7 07 00 00 00 00 89 30 0F B6 06 3C 5F 0F 84 AB 01 00 00 84 C0 0F 84 A3 01 00 00 3C 40 0F 84 9B 01 00 00 3C 2E 0F 84 93 01 00 00 89 F3 90 EB 19 8D B6 00 00 00 00 84 D2 74 1A 80 FA 40 90 0F 84 1A 01 00 00 80 FA 2E 74 65 83 C3 01 0F B6 13 80 FA 5F 75 E2 39 DE 89 D8 0F 84 60 01 00 00 31 F6 80 FA 40 0F 84 FD 00 00 00 80 FA 5F 0F 84 14 01 00 00 80 FA 2E 74 47 80 FA 40 0F 84 E6 00 00 00 8B 01 85 C0 74 0B 89 F2 83 E2 FB 80 38 00 0F 44 F2 8B 45 00 85 C0 74 0B 89 F2 83 E2 FD 80 38 00 0F 44 F2 83 C4 2C 89 F0 5B 5E 5F 5D C3 90 39 DE 0F 84 08 01 00 00 31 F6 8D B6 00 00 00 00 8D 43 01 C6 03 00 89 45 00 0F B6 53 01 F6 C2 BF 0F 84 1C 01 00 00 89 44 24 10 89 C7 EB 04 66 90 89 DF 0F B6 57 01 8D 5F 01 F6 C2 BF 75 F2 89 7C 24 10 89 F7 83 CF 02 39 D8 89 7C 24 1C 0F 84 16 01 00 00 89 DA 29 C2 89 54 24 04 89 04 24 89 4C 24 14 E8 ?? ?? ?? ?? 8B 7C 24 54 85 C0 89 C2 89 07 0F 84 FB 00 00 00 89 44 24 04 8B 45 00 89 54 24 18 89 04 24 E8 ?? ?? ?? ?? 8B 54 24 18 8B 4C 24 14 85 C0 0F 84 B2 00 00 00 8B 7C 24 10 83 CE 03 0F B6 57 01 E9 1F FF FF FF 8D B6 00 00 00 00 39 DE 74 5C 31 F6 66 90 8B 54 24 48 8D 43 01 C6 03 00 89 02 89 F0 83 C8 08 80 7B 01 00 0F 45 F0 E9 FD FE FF FF 8D 76 00 C6 03 00 83 C3 01 89 19 0F B6 50 01 84 D2 74 50 80 FA 2E 75 12 EB 49 90 83 C3 01 0F B6 13 80 FA 2E 74 3D 84 D2 74 39 80 FA 40 75 EC BE 04 00 00 00 EB AD 90 8D 74 26 00 89 34 24 31 F6 C7 44 24 04 00 00 00 00 89 4C 24 14 E8 ?? ?? ?? ?? 8B 4C 24 14 89 C3 0F B6 10 E9 95 FE FF FF 8D 74 26 00 BE 04 00 00 00 E9 82 FE FF FF 83 CE 02 89 C3 E9 7D FE FF FF 89 14 24 E8 ?? ?? ?? ?? 8B 7C 24 10 8B 74 24 1C 8B 4C 24 14 0F B6 57 01 E9 60 FE FF FF 8B 74 24 1C E9 57 FE FF FF BE FF FF FF FF E9 79 FE FF FF }
	condition:
		$1
}

rule file_338_3_0 {
	meta:
		name = "fseeko"
		size = 216
		refs = "0069 _IO_seekoff_unlocked 00d4 _Unwind_Resume"
		altNames = "fseek"
	strings:
		$1 = { 56 53 83 EC 24 8B 5C 24 30 8B 03 25 00 80 00 00 75 32 8B 53 48 65 8B 35 08 00 00 00 3B 72 08 74 1F B9 01 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 0A 0F 85 9E 00 00 00 8B 53 48 89 72 08 83 42 04 01 8B 44 24 38 C7 44 24 10 03 00 00 00 89 1C 24 89 44 24 0C 8B 44 24 34 89 C2 C1 FA 1F 89 44 24 04 89 54 24 08 E8 ?? ?? ?? ?? 21 D0 F7 D0 83 F8 01 19 D2 F7 03 00 80 00 00 75 20 8B 4B 48 83 69 04 01 75 17 C7 41 08 00 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 83 29 01 75 46 83 C4 24 89 D0 5B 5E C3 F7 03 00 80 00 00 89 C6 75 20 8B 53 48 83 6A 04 01 75 17 C7 42 08 00 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 83 2A 01 75 1D 89 34 24 E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_339_0_0 {
	meta:
		name = "_dl_discover_osversion"
		size = 238
		refs = "0011 __uname 00a0 __open 00be __read 00c8 __close"
	strings:
		$1 = { 57 56 53 81 EC E0 01 00 00 8D 44 24 5A 89 04 24 E8 ?? ?? ?? ?? 8D 94 24 DC 00 00 00 85 C0 75 70 89 D0 31 FF 31 F6 0F BE 18 8D 53 D0 80 FA 09 77 51 0F BE 50 01 8D 48 01 83 EB 30 8D 42 D0 3C 09 77 1A 8D B6 00 00 00 00 8D 04 9B 83 C1 01 8D 5C 42 D0 0F BE 11 8D 42 D0 3C 09 76 EC C1 E6 08 83 C7 01 09 DE 80 FA 2E 8D 41 01 75 11 83 FF 03 75 B5 89 F0 81 C4 E0 01 00 00 5B 5E 5F C3 83 FF 03 74 EF B9 03 00 00 00 29 F9 C1 E1 03 D3 E6 EB E1 C7 44 24 04 00 00 00 00 C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 89 C3 78 3D 8D 7C 24 1A C7 44 24 08 40 00 00 00 89 7C 24 04 89 04 24 E8 ?? ?? ?? ?? 89 1C 24 89 C6 E8 ?? ?? ?? ?? 85 F6 7E 17 B9 3F 00 00 00 83 FE 3F 0F 4E CE 89 FA C6 44 0C 1A 00 E9 39 FF FF FF B8 FF FF FF FF EB 85 }
	condition:
		$1
}

rule file_340_0_0 {
	meta:
		name = "__gconv_open"
		size = 1784
		refs = "001e strchr 00a6 _nl_current_LC_CTYPE 00b6 strlen 00d5 mempcpy 010e __gconv_find_transform 0141 __gconv_translit_find 0166 malloc 0195 memset 01f8 _nl_C_locobj 0211 __strcasecmp_l 0359 __libc_errno 036c __gconv_close_transform 03e2 free 0440 memcpy 04ee __gconv_transliterate"
	strings:
		$1 = { 55 89 E5 57 56 53 83 EC 5C C7 44 24 04 2F 00 00 00 89 04 24 89 45 D4 89 55 D0 89 4D B8 E8 ?? ?? ?? ?? 85 C0 0F 84 51 05 00 00 83 C0 01 C7 44 24 04 2F 00 00 00 89 04 24 E8 ?? ?? ?? ?? C7 45 CC 00 00 00 00 C7 45 C4 00 00 00 00 85 C0 74 0A 80 78 01 00 0F 85 BD 03 00 00 8B 55 D0 C7 44 24 04 2F 00 00 00 89 14 24 E8 ?? ?? ?? ?? 85 C0 74 21 83 C0 01 C7 44 24 04 2F 00 00 00 89 04 24 E8 ?? ?? ?? ?? 85 C0 74 0A 80 78 01 00 0F 85 FD 04 00 00 8B 45 D4 80 38 2F 75 4C 80 78 01 2F 75 46 80 78 02 00 75 40 A1 ?? ?? ?? ?? 65 8B 00 8B 00 8B 70 5C 89 34 24 E8 ?? ?? ?? ?? 8D 50 21 83 E2 F0 29 D4 8D 5C 24 1B 83 E3 F0 89 44 24 08 89 74 24 04 89 1C 24 E8 ?? ?? ?? ?? 66 C7 00 2F 2F C6 40 02 00 89 5D D4 8B 55 D0 80 3A 2F 75 0A 80 7A 01 2F 0F 84 11 02 00 00 8B 45 08 8D 4D DC 8B 55 D0 89 44 24 04 8D 45 E0 89 04 24 8B 45 D4 E8 ?? ?? ?? ?? C7 45 C8 00 00 00 00 83 EC 08 85 C0 89 45 C0 0F 85 CC 01 00 00 8B 45 CC 85 C0 74 28 8B 75 CC 31 DB 90 8D 74 26 00 8B 3E 85 FF 74 0F 89 F0 E8 ?? ?? ?? ?? 85 C0 0F 85 8E 05 00 00 89 F3 8B 76 04 85 F6 75 E2 8B 5D E0 8D 34 DB C1 E6 02 8D 46 08 89 04 24 E8 ?? ?? ?? ?? 85 C0 89 45 C8 0F 84 E2 01 00 00 8B 4D C8 8B 45 DC 89 19 89 41 04 89 C8 83 C0 08 89 74 24 08 C7 44 24 04 00 00 00 00 89 04 24 E8 ?? ?? ?? ?? 8B 4D E0 85 C9 0F 84 4F 01 00 00 8B 45 C8 31 F6 C7 45 D0 00 00 00 00 89 45 D4 8B 55 D0 8B 4D C8 8B 5D CC 8D 04 D2 8D 54 81 20 8B 4D D4 85 DB 89 45 BC 89 51 1C 0F 84 C5 00 00 00 8D 74 26 00 8B 53 0C 31 FF 85 D2 75 13 E9 A8 00 00 00 66 90 83 C7 01 39 7B 0C 0F 86 9A 00 00 00 C7 44 24 08 ?? ?? ?? ?? 8B 43 08 8B 04 B8 89 44 24 04 8B 45 DC 8B 44 30 0C 89 04 24 E8 ?? ?? ?? ?? 85 C0 75 CF 8B 43 18 C7 45 E4 00 00 00 00 85 C0 74 17 8B 4D DC 8D 55 E4 8B 4C 31 10 89 14 24 89 4C 24 04 FF D0 85 C0 75 50 C7 04 24 14 00 00 00 E8 ?? ?? ?? ?? 85 C0 0F 84 49 01 00 00 8B 4B 10 89 08 8B 4B 14 89 48 04 8B 4B 1C C7 40 10 00 00 00 00 89 48 08 8B 4D E4 89 48 0C 8B 4D D4 8B 79 28 85 FF 75 08 E9 0D 01 00 00 90 89 D7 8B 57 10 85 D2 75 F7 83 C7 10 89 07 8B 5B 04 85 DB 0F 85 3F FF FF FF 8B 5D E0 8D 43 FF 3B 45 D0 0F 86 1B 04 00 00 8B 4D C4 8B 55 D4 8B 45 DC 89 4A 10 69 54 30 30 E0 1F 00 00 89 14 24 89 55 B4 E8 ?? ?? ?? ?? 8B 4D D4 85 C0 89 41 08 8B 55 B4 0F 84 C3 00 00 00 01 D0 83 C1 24 83 45 D0 01 83 C6 3C 89 41 E8 3B 5D D0 89 4D D4 0F 87 C0 FE FF FF 8B 45 C8 8B 4D B8 89 01 8B 45 C0 8D 65 F4 5B 5E 5F 5D C2 04 00 80 7A 02 00 0F 85 E5 FD FF FF A1 ?? ?? ?? ?? 65 8B 00 8B 00 8B 70 5C 89 34 24 E8 ?? ?? ?? ?? 8D 50 21 83 E2 F0 29 D4 8D 5C 24 1B 83 E3 F0 89 44 24 08 89 74 24 04 89 1C 24 E8 ?? ?? ?? ?? 66 C7 00 2F 2F C6 40 02 00 89 5D D0 E9 A0 FD FF FF 8B 0D ?? ?? ?? ?? 89 4D D4 65 8B 09 89 4D CC 8B 45 DC 89 DA E8 ?? ?? ?? ?? 8B 45 CC 8B 4D D4 C7 45 C0 03 00 00 00 C7 45 C8 00 00 00 00 65 89 01 E9 67 FF FF FF 8B 55 BC 8B 4D C8 8D 7C 91 28 E9 F1 FE FF FF 8B 0D ?? ?? ?? ?? 8B 7D D0 8B 45 D0 89 4D D4 65 8B 09 83 EF 01 85 C0 89 4D CC 74 4C 8B 55 C8 8D 04 FF 8D 74 82 28 8D B4 26 00 00 00 00 8B 06 85 C0 74 1E 66 90 8B 50 08 8B 58 10 85 D2 0F 85 D2 02 00 00 89 04 24 E8 ?? ?? ?? ?? 85 DB 89 D8 75 E4 8B 46 E0 83 EE 24 89 04 24 E8 ?? ?? ?? ?? 85 FF 74 05 83 EF 01 EB C5 8B 45 C8 89 04 24 E8 ?? ?? ?? ?? 8B 5D E0 E9 50 FF FF FF 8D 58 01 89 DA 2B 55 D4 8D 42 1F 83 E0 F0 29 C4 8D 44 24 1B 83 E0 F0 C6 04 10 00 89 54 24 08 8B 55 D4 89 04 24 89 54 24 04 E8 ?? ?? ?? ?? 89 1C 24 89 45 D4 E8 ?? ?? ?? ?? 8D 50 01 83 C0 1F 83 E0 F0 29 C4 8D 44 24 1B 83 E0 F0 89 5C 24 04 89 54 24 08 89 04 24 E8 ?? ?? ?? ?? 89 C3 0F B6 00 3C 2C 75 10 8D B6 00 00 00 00 83 C3 01 0F B6 03 3C 2C 74 F6 84 C0 8D 73 01 0F 84 E6 00 00 00 0F B6 06 84 C0 74 0B 83 C6 01 3C 2C 75 F2 C6 46 FF 00 C7 45 CC 00 00 00 00 C7 45 C4 00 00 00 00 85 DB 0F 84 9C FB FF FF C7 44 24 08 ?? ?? ?? ?? C7 44 24 04 ?? ?? ?? ?? 89 1C 24 E8 ?? ?? ?? ?? 85 C0 0F 85 E5 00 00 00 8B 45 CC 85 C0 0F 84 64 01 00 00 8B 4D CC 81 79 10 ?? ?? ?? ?? 74 49 89 C8 EB 0B 81 7A 10 ?? ?? ?? ?? 89 D0 74 3A 8B 50 04 85 D2 75 EE 83 EC 30 31 C9 8D 54 24 1B 83 E2 F0 C7 04 0A 00 00 00 00 83 C1 04 83 F9 20 72 F1 C7 42 08 ?? ?? ?? ?? C7 42 0C 01 00 00 00 C7 42 10 ?? ?? ?? ?? 89 50 04 0F B6 06 89 F3 3C 2C 75 0C 66 90 83 C3 01 0F B6 03 3C 2C 74 F6 84 C0 0F 84 FF FA FF FF 8D 73 01 8D 76 00 0F B6 06 84 C0 0F 84 4A FF FF FF 83 C6 01 3C 2C 75 EE C6 46 FF 00 E9 3A FF FF FF C7 45 CC 00 00 00 00 C7 45 C4 00 00 00 00 E9 CB FA FF FF 83 C0 01 8B 4D D0 2B 45 D0 8D 50 1F 83 E2 F0 29 D4 8D 54 24 1B 83 E2 F0 C6 04 02 00 89 44 24 08 89 4C 24 04 89 14 24 E8 ?? ?? ?? ?? 89 45 D0 E9 CF FA FF FF C7 44 24 08 ?? ?? ?? ?? C7 44 24 04 ?? ?? ?? ?? 89 1C 24 E8 ?? ?? ?? ?? 85 C0 74 62 8B 45 CC 85 C0 0F 84 9F 00 00 00 8B 7D CC EB 04 66 90 89 C7 8B 07 85 C0 74 1C C7 44 24 08 ?? ?? ?? ?? 89 44 24 04 89 1C 24 E8 ?? ?? ?? ?? 85 C0 0F 84 29 FF FF FF 8B 47 04 85 C0 75 D5 83 EC 30 31 C9 8D 44 24 1B 83 E0 F0 C7 04 08 00 00 00 00 83 C1 04 83 F9 20 72 F1 89 18 89 47 04 E9 FD FE FF FF C7 45 C4 02 00 00 00 E9 F1 FE FF FF 83 EC 30 31 C0 8D 7C 24 1B 83 E7 F0 C7 04 07 00 00 00 00 83 C0 04 83 F8 20 72 F1 C7 47 08 ?? ?? ?? ?? C7 47 0C 01 00 00 00 C7 47 10 ?? ?? ?? ?? 89 7D CC E9 B9 FE FF FF 8D 74 26 00 83 EC 30 31 C0 8D 7C 24 1B 83 E7 F0 C7 04 07 00 00 00 00 83 C0 04 83 F8 20 72 F1 89 1F 89 7D CC E9 90 FE FF FF 8D 76 00 8B 48 0C 89 45 B4 89 0C 24 FF D2 8B 45 B4 E9 1B FD FF FF 8B 55 D0 8B 4D C8 8D 04 D2 8B 55 C4 83 CA 01 89 54 81 10 E9 18 FC FF FF 85 DB 74 0E 8B 46 04 89 43 04 8B 76 04 E9 65 FA FF FF 8B 76 04 89 75 CC E9 5A FA FF FF }
	condition:
		$1
}

rule file_344_0_0 {
	meta:
		name = "atexit"
		size = 52
		refs = "0001 __dso_handle 0025 __cxa_atexit"
	strings:
		$1 = { B8 ?? ?? ?? ?? 83 EC 1C 85 C0 74 21 A1 ?? ?? ?? ?? 89 44 24 08 8B 44 24 20 C7 44 24 04 00 00 00 00 89 04 24 E8 ?? ?? ?? ?? 83 C4 1C C3 B8 ?? ?? ?? ?? EB DD }
	condition:
		$1
}

rule file_345_0_0 {
	meta:
		name = "utime"
		size = 35
		refs = "0011 _dl_sysinfo 001e __syscall_error"
	strings:
		$1 = { 89 DA 8B 4C 24 08 8B 5C 24 04 B8 1E 00 00 00 FF 15 ?? ?? ?? ?? 89 D3 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_346_0_0 {
	meta:
		name = "strchr"
		size = 359
	strings:
		$1 = { 57 8B 44 24 08 8B 54 24 0C 88 D6 89 D1 C1 E2 10 66 89 CA A8 03 74 4C 8A 08 38 CA 0F 84 44 01 00 00 84 C9 0F 84 11 01 00 00 40 A8 03 74 35 8A 08 38 CA 0F 84 2D 01 00 00 84 C9 0F 84 FA 00 00 00 40 A8 03 74 1E 8A 08 38 CA 0F 84 16 01 00 00 84 C9 0F 84 E3 00 00 00 40 EB 09 8D B6 00 00 00 00 83 C0 10 8B 08 31 D1 BF FF FE FE FE 01 CF 0F 83 D3 00 00 00 31 CF 81 CF FF FE FE FE 47 0F 85 C4 00 00 00 31 D1 BF FF FE FE FE 01 CF 0F 83 A8 00 00 00 31 CF 81 CF FF FE FE FE 47 0F 85 99 00 00 00 8B 48 04 31 D1 BF FF FE FE FE 01 CF 0F 83 91 00 00 00 31 CF 81 CF FF FE FE FE 47 0F 85 82 00 00 00 31 D1 BF FF FE FE FE 01 CF 73 6D 31 CF 81 CF FF FE FE FE 47 75 62 8B 48 08 31 D1 BF FF FE FE FE 01 CF 73 5B 31 CF 81 CF FF FE FE FE 47 75 50 31 D1 BF FF FE FE FE 01 CF 73 3E 31 CF 81 CF FF FE FE FE 47 75 33 8B 48 0C 31 D1 BF FF FE FE FE 01 CF 73 29 31 CF 81 CF FF FE FE FE 47 75 1E 31 D1 BF FF FE FE FE 01 CF 73 0F 31 CF 81 CF FF FE FE FE 47 0F 84 26 FF FF FF 31 C0 5F C3 83 C0 04 83 C0 04 83 C0 04 84 C9 74 1A 38 D1 74 EB 40 84 ED 74 11 38 D5 74 E2 40 C1 E9 10 84 C9 74 05 38 D1 74 D6 40 5F C3 }
	condition:
		$1
}

rule file_347_0_0 {
	meta:
		name = "mbrtoc16"
		size = 707
		refs = "0062 _nl_current_LC_CTYPE 00c2 _dl_mcount_wrapper_check 01b7 __libc_errno 025a __assert_fail 027b _nl_C_LC_CTYPE 0288 __wcsmbs_load_conv 02ba __wcsmbs_gconv_fcts_c"
	strings:
		$1 = { 83 EC 7C B8 ?? ?? ?? ?? 89 5C 24 6C 8B 9C 24 8C 00 00 00 89 74 24 70 89 7C 24 74 89 6C 24 78 85 DB 0F 44 D8 8B 03 85 C0 0F 88 42 01 00 00 8B 84 24 84 00 00 00 C7 44 24 48 00 00 00 00 C7 44 24 4C 01 00 00 00 C7 44 24 44 01 00 00 00 85 C0 89 5C 24 50 C7 44 24 5C 00 00 00 00 0F 84 A7 01 00 00 A1 ?? ?? ?? ?? 8D 6C 24 30 8D 54 24 34 89 6C 24 3C 89 54 24 40 65 8B 00 8B 30 8B 46 14 85 C0 0F 84 F3 01 00 00 8B 7E 14 8B 8C 24 84 00 00 00 89 4C 24 38 03 8C 24 88 00 00 00 89 4C 24 2C 0F 82 B9 01 00 00 8B 07 8B 70 14 8B 00 85 C0 74 0A C1 CE 09 65 33 35 18 00 00 00 89 34 24 89 54 24 28 E8 ?? ?? ?? ?? 8B 44 24 2C 8B 54 24 28 C7 44 24 1C 01 00 00 00 C7 44 24 18 00 00 00 00 89 44 24 0C 8D 44 24 38 89 44 24 08 8D 44 24 3C 89 54 24 14 C7 44 24 10 00 00 00 00 89 44 24 04 8B 07 89 04 24 FF D6 A9 FB FF FF FF 74 15 8D 50 FA 83 FA 01 0F 86 90 00 00 00 83 F8 05 0F 85 19 01 00 00 8B 54 24 30 8B 44 24 38 2B 84 24 84 00 00 00 81 FA FF FF 00 00 0F 8F 94 00 00 00 8B B4 24 80 00 00 00 85 F6 74 0A 8B 8C 24 80 00 00 00 66 89 11 39 6C 24 3C 74 39 85 D2 75 35 8B 44 24 50 8B 18 85 DB 0F 85 2C 01 00 00 31 C0 EB 23 8D 76 00 25 FF FF FF 7F 8B 94 24 80 00 00 00 89 03 8B 43 04 66 89 02 B8 FD FF FF FF C7 43 04 00 00 00 00 8B 5C 24 6C 8B 74 24 70 8B 7C 24 74 8B 6C 24 78 83 C4 7C C3 8D 74 26 00 83 F8 05 0F 84 70 FF FF FF 83 F8 07 74 7A A1 ?? ?? ?? ?? 65 C7 00 54 00 00 00 B8 FF FF FF FF EB C7 8D B4 26 00 00 00 00 8B 8C 24 80 00 00 00 85 C9 74 14 8B B4 24 80 00 00 00 89 D1 C1 F9 0A 66 81 E9 40 28 66 89 0E 81 E2 FF 03 00 00 81 C2 00 DC 00 00 81 0B 00 00 00 80 89 53 04 EB 8A 66 90 C7 84 24 88 00 00 00 01 00 00 00 C7 84 24 84 00 00 00 ?? ?? ?? ?? C7 84 24 80 00 00 00 00 00 00 00 E9 33 FE FF FF 66 90 B8 FE FF FF FF E9 56 FF FF FF C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 71 00 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 BC 24 84 00 00 00 FF C7 44 24 2C FF FF FF FF 0F 85 31 FE FF FF E9 3D FF FF FF 81 FE ?? ?? ?? ?? 74 38 89 F0 89 54 24 28 E8 ?? ?? ?? ?? 8B 54 24 28 E9 F1 FD FF FF C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 80 00 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? BF ?? ?? ?? ?? E9 C6 FD FF FF }
	condition:
		$1
}

rule file_348_0_0 {
	meta:
		name = "__posix_openpt"
		size = 270
		refs = "0029 __open 0070 __statfs 00a9 __close 00ae __libc_errno"
	strings:
		$1 = { 83 EC 5C 8B 15 ?? ?? ?? ?? 89 5C 24 54 89 74 24 58 85 D2 0F 85 DF 00 00 00 8B 44 24 60 C7 04 24 ?? ?? ?? ?? 89 44 24 04 E8 ?? ?? ?? ?? 83 F8 FF 89 C3 0F 84 90 00 00 00 A1 ?? ?? ?? ?? 85 C0 74 1F C7 05 ?? ?? ?? ?? 01 00 00 00 89 D8 8B 74 24 58 8B 5C 24 54 83 C4 5C C3 8D B4 26 00 00 00 00 8D 74 24 10 89 74 24 04 C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 75 0A 81 7C 24 10 D1 1C 00 00 74 BF 89 74 24 04 C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 75 0A 81 7C 24 10 73 13 00 00 74 A1 89 1C 24 BB FF FF FF FF E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 01 00 00 00 65 C7 00 02 00 00 00 EB 86 8D 76 00 A1 ?? ?? ?? ?? 65 8B 00 83 F8 13 74 09 83 F8 02 0F 85 6D FF FF FF 89 D8 8B 74 24 58 C7 05 ?? ?? ?? ?? 01 00 00 00 8B 5C 24 54 83 C4 5C C3 66 90 A1 ?? ?? ?? ?? BB FF FF FF FF 65 C7 00 02 00 00 00 E9 3D FF FF FF }
	condition:
		$1
}

rule file_348_1_0 {
	meta:
		name = "__bsd_getpt"
		size = 139
		refs = "0008 __libc_ptyname1 002e __libc_ptyname2 0042 __libc_errno 0066 __open"
	strings:
		$1 = { 57 BA 70 00 00 00 56 BF ?? ?? ?? ?? 53 83 EC 20 C7 44 24 15 2F 64 65 76 8D 74 24 15 C7 44 24 19 2F 70 74 79 C6 44 24 1F 00 88 54 24 1D BB ?? ?? ?? ?? BA 30 00 00 00 EB 1D 8D B4 26 00 00 00 00 8B 0D ?? ?? ?? ?? 65 83 39 02 74 23 83 C3 01 0F B6 13 84 D2 74 22 C7 44 24 04 02 00 00 00 89 34 24 88 54 24 1E E8 ?? ?? ?? ?? 83 F8 FF 74 D1 83 C4 20 5B 5E 5F C3 66 90 83 C7 01 0F B6 17 84 D2 75 A7 65 C7 01 02 00 00 00 EB E4 }
	condition:
		$1
}

rule file_348_2_0 {
	meta:
		name = "__getpt"
		size = 32
		refs = "000b __posix_openpt 001c __bsd_getpt"
	strings:
		$1 = { 83 EC 1C C7 04 24 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 FF 74 04 83 C4 1C C3 83 C4 1C E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_349_0_0 {
	meta:
		name = "__bb_exit_func"
		size = 501
		refs = "0017 _IO_new_fopen 0057 fwrite_unlocked 005d __bb_head 00c6 __overflow 0184 _IO_new_fclose 0198 perror"
	strings:
		$1 = { 55 57 56 53 83 EC 4C C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 0F 84 6D 01 00 00 81 08 00 80 00 00 89 C3 8D 44 24 2C 89 5C 24 0C C7 44 24 08 01 00 00 00 C7 44 24 04 14 00 00 00 89 04 24 C7 44 24 2C 67 6D 6F 6E C7 44 24 30 01 00 00 00 E8 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 85 C9 0F 84 17 01 00 00 8D B4 26 00 00 00 00 8B 41 0C 89 44 24 28 8B 43 14 3B 43 18 0F 83 52 01 00 00 C6 00 02 83 C0 01 89 43 14 39 43 18 BF 04 00 00 00 8D 74 24 28 89 CD 76 1C 0F B6 16 83 C0 01 83 C6 01 88 50 FF 89 43 14 83 EF 01 74 20 8B 43 14 39 43 18 77 E4 0F B6 06 83 C6 01 89 1C 24 89 44 24 04 E8 ?? ?? ?? ?? 83 F8 FF 75 DC 90 8B 44 24 28 89 E9 31 ED 85 C0 0F 84 95 00 00 00 8B 71 14 8D 14 AD 00 00 00 00 BF 04 00 00 00 8B 43 14 89 54 24 14 01 D6 83 C6 01 3B 43 18 0F 83 A0 00 00 00 0F B6 56 FF 83 C0 01 88 50 FF 89 43 14 83 C6 01 83 EF 01 75 E2 8B 54 24 14 03 51 08 BE 04 00 00 00 3B 43 18 8D 7A 01 73 1D 0F B6 57 FF 83 C0 01 88 50 FF 89 43 14 83 C7 01 83 EE 01 74 26 8B 43 14 3B 43 18 72 E3 0F B6 47 FF 89 1C 24 89 4C 24 1C 89 44 24 04 E8 ?? ?? ?? ?? 8B 4C 24 1C 83 F8 FF 75 D3 90 83 C5 01 39 6C 24 28 0F 87 6B FF FF FF 8B 49 10 85 C9 0F 85 F0 FE FF FF 89 1C 24 E8 ?? ?? ?? ?? 83 C4 4C 5B 5E 5F 5D C3 C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 4C 5B 5E 5F 5D C3 0F B6 46 FF 89 1C 24 89 4C 24 1C 89 44 24 04 E8 ?? ?? ?? ?? 8B 4C 24 1C 83 F8 FF 75 0C 8B 54 24 14 8B 43 14 E9 50 FF FF FF 8B 43 14 E9 3C FF FF FF C7 44 24 04 02 00 00 00 89 1C 24 89 4C 24 1C E8 ?? ?? ?? ?? 8B 43 14 8B 4C 24 1C E9 97 FE FF FF }
	condition:
		$1
}

rule file_350_0_0 {
	meta:
		name = "__libc_accept4"
		size = 182
		refs = "001c _dl_sysinfo 002a __libc_enable_asynccancel 004a __libc_disable_asynccancel 005c __syscall_error"
	strings:
		$1 = { 65 83 3D 0C 00 00 00 00 75 1E 89 DA B8 66 00 00 00 BB 12 00 00 00 8D 4C 24 04 FF 15 ?? ?? ?? ?? 89 D3 83 F8 83 73 30 C3 56 E8 ?? ?? ?? ?? 89 C6 89 DA B8 66 00 00 00 BB 12 00 00 00 8D 4C 24 08 FF 15 ?? ?? ?? ?? 89 D3 96 E8 ?? ?? ?? ?? 89 F0 5E 83 F8 83 73 01 C3 83 F8 EA 0F 85 ?? ?? ?? ?? 53 A1 ?? ?? ?? ?? 85 C0 75 3A C7 44 24 08 FF FF FF FF C7 44 24 14 00 00 00 00 B8 66 00 00 00 BB 12 00 00 00 8D 4C 24 08 FF 15 ?? ?? ?? ?? 83 F8 EA B8 FF FF FF FF 74 05 B8 01 00 00 00 A3 ?? ?? ?? ?? 85 C0 B8 EA FF FF FF 79 05 B8 DA FF FF FF 5B E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_351_0_0 {
	meta:
		name = "dysize"
		size = 98
	strings:
		$1 = { 83 EC 08 8B 4C 24 0C 89 1C 24 BB 6D 01 00 00 89 74 24 04 F6 C1 03 75 2B 89 C8 BA 1F 85 EB 51 F7 EA 89 CE C1 FE 1F 89 D0 C1 F8 05 29 F0 6B C0 64 39 C1 75 1C C1 FA 07 29 F2 69 D2 90 01 00 00 39 D1 74 0D 89 D8 8B 74 24 04 8B 1C 24 83 C4 08 C3 BB 6E 01 00 00 8B 74 24 04 89 D8 8B 1C 24 83 C4 08 C3 }
	condition:
		$1
}

rule file_352_0_0 {
	meta:
		name = "__statvfs64"
		size = 157
		refs = "0035 __statfs64 0053 __xstat64 0074 __internal_statvfs64"
	strings:
		$1 = { 81 EC EC 00 00 00 89 B4 24 E0 00 00 00 8B B4 24 F0 00 00 00 89 BC 24 E4 00 00 00 8D 7C 24 1C 89 7C 24 04 89 9C 24 DC 00 00 00 89 34 24 89 AC 24 E8 00 00 00 E8 ?? ?? ?? ?? 85 C0 89 C3 75 39 8D 6C 24 70 89 6C 24 08 89 74 24 04 C7 04 24 03 00 00 00 E8 ?? ?? ?? ?? 89 7C 24 08 89 34 24 83 F8 FF 8B 84 24 F4 00 00 00 0F 44 EB 89 6C 24 0C 89 44 24 04 E8 ?? ?? ?? ?? 89 D8 8B B4 24 E0 00 00 00 8B 9C 24 DC 00 00 00 8B BC 24 E4 00 00 00 8B AC 24 E8 00 00 00 81 C4 EC 00 00 00 C3 }
	condition:
		$1
}

rule file_355_0_0 {
	meta:
		name = "mkstemp"
		size = 43
		refs = "0023 __gen_tempname"
	strings:
		$1 = { 83 EC 1C 8B 44 24 20 C7 44 24 0C 00 00 00 00 C7 44 24 08 00 00 00 00 C7 44 24 04 00 00 00 00 89 04 24 E8 ?? ?? ?? ?? 83 C4 1C C3 }
	condition:
		$1
}

rule file_356_0_0 {
	meta:
		name = "svc_find"
		size = 78
		refs = "0010 __rpc_thread_variables"
	strings:
		$1 = { 55 89 D5 57 89 C7 56 53 83 EC 1C 89 4C 24 0C E8 ?? ?? ?? ?? 8B 4C 24 0C 8B 98 B4 00 00 00 85 DB 74 26 31 F6 EB 0C 66 90 8B 03 89 DE 85 C0 74 0E 89 C3 39 7B 04 75 F1 39 6B 08 75 EC 89 D8 89 31 83 C4 1C 5B 5E 5F 5D C3 31 C0 31 F6 EB F0 }
	condition:
		$1
}

rule file_356_1_0 {
	meta:
		name = "xprt_register"
		size = 256
		refs = "0008 __rpc_thread_variables 0023 _rpc_dtablesize 003d __rpc_thread_svc_max_pollfd 0046 __rpc_thread_svc_pollfd 0072 realloc 00a9 __rpc_thread_svc_fdset 00ec malloc"
	strings:
		$1 = { 55 57 56 53 83 EC 1C E8 ?? ?? ?? ?? 8B 7C 24 30 8B 37 89 C3 8B 80 B0 00 00 00 85 C0 0F 84 BE 00 00 00 E8 ?? ?? ?? ?? 39 C6 7D 67 8B 83 B0 00 00 00 81 FE FF 03 00 00 89 3C B0 7E 64 E8 ?? ?? ?? ?? 89 C5 8B 18 E8 ?? ?? ?? ?? 31 D2 89 C7 EB 0D 8B 07 8D 0C D0 83 39 FF 74 76 83 C2 01 39 DA 7C EF 8D 04 DD 08 00 00 00 89 44 24 04 8B 07 89 04 24 E8 ?? ?? ?? ?? 85 C0 74 18 8B 55 00 89 07 8D 4A 01 89 4D 00 89 34 D0 8B 55 00 66 C7 44 D0 FC C3 00 83 C4 1C 5B 5E 5F 5D C3 8D B6 00 00 00 00 85 F6 8D 5E 1F 0F 49 DE E8 ?? ?? ?? ?? 89 F2 C1 FA 1F C1 EA 1B 8D 0C 16 83 E1 1F 29 D1 BA 01 00 00 00 C1 FB 05 D3 E2 09 14 98 E9 6D FF FF FF 90 89 31 66 C7 41 04 C3 00 83 C4 1C 5B 5E 5F 5D C3 E8 ?? ?? ?? ?? C1 E0 02 89 04 24 E8 ?? ?? ?? ?? 85 C0 89 83 B0 00 00 00 0F 85 24 FF FF FF EB 92 }
	condition:
		$1
}

rule file_356_2_0 {
	meta:
		name = "xprt_unregister"
		size = 176
		refs = "001a _rpc_dtablesize 0023 __rpc_thread_variables 005f __rpc_thread_svc_fdset 0081 __rpc_thread_svc_max_pollfd 0098 __rpc_thread_svc_pollfd"
	strings:
		$1 = { 83 EC 1C 89 5C 24 0C 8B 5C 24 20 89 74 24 10 89 7C 24 14 89 6C 24 18 8B 33 E8 ?? ?? ?? ?? 39 C6 7D 12 E8 ?? ?? ?? ?? 8B 80 B0 00 00 00 8D 04 B0 39 18 74 14 8B 5C 24 0C 8B 74 24 10 8B 7C 24 14 8B 6C 24 18 83 C4 1C C3 81 FE FF 03 00 00 C7 00 00 00 00 00 7F 2A 85 F6 8D 5E 1F 0F 49 DE E8 ?? ?? ?? ?? 89 F2 C1 FA 1F C1 EA 1B 8D 0C 16 83 E1 1F 29 D1 BA FE FF FF FF C1 FB 05 D3 C2 21 14 98 E8 ?? ?? ?? ?? 31 DB 89 C5 8B 38 EB 06 8D 76 00 83 C3 01 39 FB 7D 9D E8 ?? ?? ?? ?? 8B 00 8D 04 D8 39 30 75 EB C7 00 FF FF FF FF 8B 7D 00 EB E0 }
	condition:
		$1
}

rule file_356_3_0 {
	meta:
		name = "svc_register"
		size = 186
		refs = "0038 malloc 0058 __rpc_thread_variables 00a2 pmap_set"
	strings:
		$1 = { 56 53 83 EC 24 8B 54 24 38 8D 4C 24 1C 8B 44 24 34 E8 EA FD FF FF 85 C0 74 16 89 C3 8B 44 24 3C 39 43 0C 74 4C 31 F6 83 C4 24 89 F0 5B 5E C3 90 C7 04 24 14 00 00 00 E8 ?? ?? ?? ?? 85 C0 89 C3 74 E3 8B 44 24 34 89 43 04 8B 44 24 38 89 43 08 8B 44 24 3C 89 43 0C E8 ?? ?? ?? ?? 8B 90 B4 00 00 00 C7 43 10 00 00 00 00 89 13 89 98 B4 00 00 00 8B 54 24 40 BE 01 00 00 00 85 D2 74 A9 8B 44 24 30 0F B7 40 04 89 44 24 0C 8B 44 24 40 89 44 24 08 8B 44 24 38 89 44 24 04 8B 44 24 34 89 04 24 E8 ?? ?? ?? ?? 85 C0 0F 84 77 FF FF FF C7 43 10 01 00 00 00 E9 6D FF FF FF }
	condition:
		$1
}

rule file_356_4_0 {
	meta:
		name = "svc_unregister"
		size = 135
		refs = "0040 free 0064 pmap_unset 0079 __rpc_thread_variables"
	strings:
		$1 = { 83 EC 2C 89 74 24 24 8B 74 24 30 8D 4C 24 18 89 7C 24 28 8B 7C 24 34 89 5C 24 20 89 F0 89 FA E8 1C FD FF FF 85 C0 74 40 89 C3 8B 44 24 18 85 C0 74 46 8B 13 89 10 C7 03 00 00 00 00 89 1C 24 E8 ?? ?? ?? ?? 8D 4C 24 1C 89 FA 89 F0 E8 EF FC FF FF 85 C0 74 07 8B 48 10 85 C9 75 0C 89 7C 24 04 89 34 24 E8 ?? ?? ?? ?? 8B 5C 24 20 8B 74 24 24 8B 7C 24 28 83 C4 2C C3 E8 ?? ?? ?? ?? 8B 13 89 90 B4 00 00 00 EB AF }
	condition:
		$1
}

rule file_356_5_0 {
	meta:
		name = "svc_sendreply"
		size = 89
	strings:
		$1 = { 83 EC 4C 8B 44 24 50 8D 4C 24 10 C7 44 24 14 01 00 00 00 C7 44 24 18 00 00 00 00 C7 44 24 28 00 00 00 00 8B 50 20 89 54 24 1C 8B 50 24 89 54 24 20 8B 50 28 89 54 24 24 8B 54 24 58 89 54 24 2C 8B 54 24 54 89 54 24 30 8B 50 08 89 4C 24 04 89 04 24 FF 52 0C 83 C4 4C C3 }
	condition:
		$1
}

rule file_356_6_0 {
	meta:
		name = "svcerr_noproc"
		size = 73
	strings:
		$1 = { 83 EC 4C 8B 44 24 50 8D 4C 24 10 C7 44 24 14 01 00 00 00 C7 44 24 18 00 00 00 00 C7 44 24 28 03 00 00 00 8B 50 20 89 54 24 1C 8B 50 24 89 54 24 20 8B 50 28 89 54 24 24 8B 50 08 89 4C 24 04 89 04 24 FF 52 0C 83 C4 4C C3 }
	condition:
		$1
}

rule file_356_7_0 {
	meta:
		name = "svcerr_decode"
		size = 73
	strings:
		$1 = { 83 EC 4C 8B 44 24 50 8D 4C 24 10 C7 44 24 14 01 00 00 00 C7 44 24 18 00 00 00 00 C7 44 24 28 04 00 00 00 8B 50 20 89 54 24 1C 8B 50 24 89 54 24 20 8B 50 28 89 54 24 24 8B 50 08 89 4C 24 04 89 04 24 FF 52 0C 83 C4 4C C3 }
	condition:
		$1
}

rule file_356_8_0 {
	meta:
		name = "svcerr_systemerr"
		size = 73
	strings:
		$1 = { 83 EC 4C 8B 44 24 50 8D 4C 24 10 C7 44 24 14 01 00 00 00 C7 44 24 18 00 00 00 00 C7 44 24 28 05 00 00 00 8B 50 20 89 54 24 1C 8B 50 24 89 54 24 20 8B 50 28 89 54 24 24 8B 50 08 89 4C 24 04 89 04 24 FF 52 0C 83 C4 4C C3 }
	condition:
		$1
}

rule file_356_9_0 {
	meta:
		name = "svcerr_auth"
		size = 60
	strings:
		$1 = { 83 EC 4C 8B 44 24 50 8D 4C 24 10 8B 54 24 54 C7 44 24 14 01 00 00 00 C7 44 24 18 01 00 00 00 C7 44 24 1C 01 00 00 00 89 54 24 20 8B 50 08 89 4C 24 04 89 04 24 FF 52 0C 83 C4 4C C3 }
	condition:
		$1
}

rule file_356_10_0 {
	meta:
		name = "svcerr_weakauth"
		size = 60
	strings:
		$1 = { 83 EC 4C 8B 44 24 50 8D 4C 24 10 C7 44 24 14 01 00 00 00 C7 44 24 18 01 00 00 00 C7 44 24 1C 01 00 00 00 8B 50 08 C7 44 24 20 05 00 00 00 89 4C 24 04 89 04 24 FF 52 0C 83 C4 4C C3 }
	condition:
		$1
}

rule file_356_11_0 {
	meta:
		name = "svcerr_noprog"
		size = 73
	strings:
		$1 = { 83 EC 4C 8B 44 24 50 8D 4C 24 10 C7 44 24 14 01 00 00 00 C7 44 24 18 00 00 00 00 C7 44 24 28 01 00 00 00 8B 50 20 89 54 24 1C 8B 50 24 89 54 24 20 8B 50 28 89 54 24 24 8B 50 08 89 4C 24 04 89 04 24 FF 52 0C 83 C4 4C C3 }
	condition:
		$1
}

rule file_356_12_0 {
	meta:
		name = "svcerr_progvers"
		size = 89
	strings:
		$1 = { 83 EC 4C 8B 44 24 50 8D 4C 24 10 C7 44 24 14 01 00 00 00 C7 44 24 18 00 00 00 00 C7 44 24 28 02 00 00 00 8B 50 20 89 54 24 1C 8B 50 24 89 54 24 20 8B 50 28 89 54 24 24 8B 54 24 54 89 54 24 2C 8B 54 24 58 89 54 24 30 8B 50 08 89 4C 24 04 89 04 24 FF 52 0C 83 C4 4C C3 }
	condition:
		$1
}

rule file_356_13_0 {
	meta:
		name = "svc_getreq_common"
		size = 483
		refs = "0021 __rpc_thread_variables 00ac _null_auth 011c svcerr_progvers 014c svcerr_noprog 0188 _authenticate"
	strings:
		$1 = { 55 57 56 53 81 EC 5C 05 00 00 8D 84 24 A0 00 00 00 89 44 24 5C 8D 84 24 30 02 00 00 89 44 24 68 E8 ?? ?? ?? ?? 8B 94 24 70 05 00 00 89 44 24 1C 8B 80 B0 00 00 00 8B 34 90 85 F6 0F 84 F5 00 00 00 8D B4 26 00 00 00 00 8B 46 08 8D 54 24 40 89 54 24 04 89 34 24 FF 10 85 C0 0F 84 C0 00 00 00 8D 84 24 C0 03 00 00 8B 5C 24 58 89 44 24 38 8B 44 24 4C 89 74 24 3C 85 DB 89 44 24 20 8B 44 24 50 89 44 24 24 8B 44 24 54 89 44 24 28 8B 44 24 58 89 44 24 2C 8B 44 24 5C 89 44 24 30 8B 44 24 60 89 44 24 34 0F 85 CD 00 00 00 A1 ?? ?? ?? ?? C7 46 28 00 00 00 00 89 46 20 8B 54 24 1C 8B 82 B4 00 00 00 85 C0 0F 84 7C 00 00 00 8B 4C 24 20 31 D2 31 FF 8B 6C 24 24 BB FF FF FF FF EB 07 90 8B 00 85 C0 74 26 39 48 04 75 F5 8B 50 08 39 EA 0F 84 DA 00 00 00 39 D3 0F 47 DA 39 FA 76 02 89 D7 8B 00 BA 01 00 00 00 85 C0 75 DA 85 D2 74 38 89 7C 24 08 89 5C 24 04 89 34 24 E8 ?? ?? ?? ?? 8B 46 08 89 34 24 FF 50 04 85 C0 74 30 83 F8 01 0F 84 12 FF FF FF 81 C4 5C 05 00 00 5B 5E 5F 5D C3 8D B4 26 00 00 00 00 89 34 24 E8 ?? ?? ?? ?? 8B 46 08 89 34 24 FF 50 04 85 C0 75 D0 8B 46 08 89 34 24 FF 50 14 81 C4 5C 05 00 00 5B 5E 5F 5D C3 8D B4 26 00 00 00 00 8D 54 24 40 8D 44 24 20 89 54 24 04 89 04 24 E8 ?? ?? ?? ?? 85 C0 0F 84 26 FF FF FF C7 44 24 78 01 00 00 00 8D 54 24 70 C7 44 24 7C 01 00 00 00 89 84 24 80 00 00 00 8B 46 08 C7 44 24 74 01 00 00 00 89 54 24 04 89 34 24 FF 50 0C E9 57 FF FF FF 8D B4 26 00 00 00 00 8D 54 24 20 89 74 24 04 89 14 24 FF 50 0C E9 3D FF FF FF }
	condition:
		$1
}

rule file_356_14_0 {
	meta:
		name = "svc_getreq_poll"
		size = 136
		refs = "0010 __rpc_thread_svc_max_pollfd 0029 __rpc_thread_variables 003d xprt_unregister 0072 svc_getreq_common"
	strings:
		$1 = { 55 57 56 53 83 EC 2C 8B 74 24 44 85 F6 74 71 E8 ?? ?? ?? ?? 31 F6 8B 5C 24 40 31 ED 89 44 24 1C 8B 08 EB 2F 8D 74 26 00 E8 ?? ?? ?? ?? 83 C5 01 8B 80 B0 00 00 00 8B 04 B8 89 04 24 E8 ?? ?? ?? ?? 39 6C 24 44 7E 39 8B 44 24 1C 8B 08 83 C6 01 83 C3 08 39 CE 7D 29 8B 3B 83 FF FF 74 EF 0F B7 43 06 66 85 C0 74 E6 A8 20 75 BD 89 3C 24 83 C5 01 E8 ?? ?? ?? ?? 39 6C 24 44 7F CB 8D 74 26 00 83 C4 2C 5B 5E 5F 5D C3 }
	condition:
		$1
}

rule file_356_15_0 {
	meta:
		name = "svc_getreqset"
		size = 132
		refs = "000d _rpc_dtablesize 0058 svc_getreq_common"
	strings:
		$1 = { 55 57 56 BE FF FF FF FF 53 83 EC 2C E8 ?? ?? ?? ?? C7 44 24 1C 00 04 00 00 3D 00 04 00 00 0F 4F 44 24 1C 31 DB 89 44 24 1C 8B 7C 24 1C 8B 44 24 40 85 FF 89 44 24 18 7E 43 8D B4 26 00 00 00 00 8B 44 24 18 8B 28 83 C0 04 89 44 24 18 EB 19 90 8D 44 1F FF 89 04 24 E8 ?? ?? ?? ?? 8D 4F FF BF 01 00 00 00 D3 E7 31 FD 0F BC FD 0F 44 FE 83 C7 01 75 DD 83 C3 20 3B 5C 24 1C 7C C4 83 C4 2C 5B 5E 5F 5D C3 }
	condition:
		$1
}

rule file_356_16_0 {
	meta:
		name = "svc_getreq"
		size = 50
		refs = "0026 svc_getreqset"
	strings:
		$1 = { 57 B9 20 00 00 00 81 EC 98 00 00 00 31 C0 8D 54 24 10 89 D7 FC F3 AB 8B 84 24 A0 00 00 00 89 14 24 89 44 24 10 E8 ?? ?? ?? ?? 81 C4 98 00 00 00 5F C3 }
	condition:
		$1
}

rule file_356_17_0 {
	meta:
		name = "__rpc_thread_svc_cleanup"
		size = 49
		refs = "0005 __rpc_thread_variables 001e svc_unregister"
	strings:
		$1 = { 53 83 EC 18 E8 ?? ?? ?? ?? 89 C3 EB 15 8D 76 00 8B 4A 08 89 4C 24 04 8B 52 04 89 14 24 E8 ?? ?? ?? ?? 8B 93 B4 00 00 00 85 D2 75 E4 83 C4 18 5B C3 }
	condition:
		$1
}

rule file_357_0_0 {
	meta:
		name = "__fxstatat64"
		size = 361
		refs = "001d __have_atfcts 0037 _dl_sysinfo 004d __libc_errno 0096 strlen 00d1 __snprintf 010a __atfct_seterrno"
	strings:
		$1 = { 55 89 E5 83 EC 38 83 7D 08 03 89 7D FC 8B 7D 10 89 5D F4 89 75 F8 0F 85 1C 01 00 00 A1 ?? ?? ?? ?? 85 C0 78 4D 8B 5D 0C 89 F9 8B 55 14 8B 75 18 B8 2C 01 00 00 FF 15 ?? ?? ?? ?? 3D 00 F0 FF FF 0F 86 08 01 00 00 83 F8 DA 74 1D 8B 15 ?? ?? ?? ?? F7 D8 65 89 02 B8 FF FF FF FF 8B 5D F4 8B 75 F8 8B 7D FC 89 EC 5D C3 C7 05 ?? ?? ?? ?? FF FF FF FF F7 45 18 FF FE FF FF 0F 85 B9 00 00 00 83 7D 0C 9C 0F 84 9F 00 00 00 80 3F 2F 0F 84 96 00 00 00 89 3C 24 E8 ?? ?? ?? ?? 85 C0 0F 84 B3 00 00 00 8D 48 20 83 C0 3E 8B 5D 0C 83 E0 F0 29 C4 8D 74 24 23 83 E6 F0 89 7C 24 10 89 F7 89 5C 24 0C C7 44 24 08 ?? ?? ?? ?? 89 4C 24 04 89 34 24 E8 ?? ?? ?? ?? F7 45 18 00 01 00 00 89 FB 8B 4D 14 74 35 B8 C4 00 00 00 FF 15 ?? ?? ?? ?? 3D 00 F0 FF FF 0F 86 62 FF FF FF 8B 5D 0C F7 D8 89 04 24 89 74 24 08 89 5C 24 04 E8 ?? ?? ?? ?? 83 C8 FF E9 45 FF FF FF 66 90 B8 C3 00 00 00 FF 15 ?? ?? ?? ?? EB C9 8D 76 00 31 F6 8D B6 00 00 00 00 EB A3 8D B6 00 00 00 00 A1 ?? ?? ?? ?? 65 C7 00 16 00 00 00 B8 FF FF FF FF E9 0D FF FF FF 31 C0 E9 06 FF FF FF A1 ?? ?? ?? ?? 65 C7 00 02 00 00 00 83 C8 FF E9 F2 FE FF FF }
	condition:
		$1
}

rule file_358_0_0 {
	meta:
		name = "setdomainname"
		size = 35
		refs = "0011 _dl_sysinfo 001e __syscall_error"
	strings:
		$1 = { 89 DA 8B 4C 24 08 8B 5C 24 04 B8 79 00 00 00 FF 15 ?? ?? ?? ?? 89 D3 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_359_0_0 {
	meta:
		name = "__posix_spawn"
		size = 67
		refs = "003b __spawni"
	strings:
		$1 = { 83 EC 2C 8B 44 24 44 C7 44 24 18 00 00 00 00 89 44 24 14 8B 44 24 40 89 44 24 10 8B 44 24 3C 89 44 24 0C 8B 44 24 38 89 44 24 08 8B 44 24 34 89 44 24 04 8B 44 24 30 89 04 24 E8 ?? ?? ?? ?? 83 C4 2C C3 }
	condition:
		$1
}

rule file_360_1_0 {
	meta:
		name = "svcudp_getargs"
		size = 28
	strings:
		$1 = { 8B 54 24 0C 8B 44 24 08 89 54 24 08 8B 54 24 04 8B 52 30 83 C2 08 89 54 24 04 FF E0 }
	condition:
		$1
}

rule file_360_2_0 {
	meta:
		name = "svcudp_freeargs"
		size = 35
	strings:
		$1 = { 8B 44 24 04 8B 4C 24 0C 8B 54 24 08 8B 40 30 C7 40 08 02 00 00 00 83 C0 08 89 4C 24 08 89 44 24 04 FF E2 }
	condition:
		$1
}

rule file_360_3_0 {
	meta:
		name = "svcudp_destroy"
		size = 81
		refs = "0010 xprt_unregister 001a __close 0037 free"
	strings:
		$1 = { 56 53 83 EC 14 8B 5C 24 20 8B 73 30 89 1C 24 E8 ?? ?? ?? ?? 8B 03 89 04 24 E8 ?? ?? ?? ?? 8B 46 0C 8B 40 1C 85 C0 74 08 8D 56 08 89 14 24 FF D0 8B 43 2C 89 04 24 E8 ?? ?? ?? ?? 89 34 24 E8 ?? ?? ?? ?? 89 5C 24 20 83 C4 14 5B 5E E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_360_4_0 {
	meta:
		name = "svcudp_recv"
		size = 775
		refs = "0089 __recvmsg 0129 xdr_callmsg 01b7 memcmp 01fa __sendto 022f __recvfrom 0244 __libc_errno 02f2 __sendmsg"
	strings:
		$1 = { 55 57 56 53 83 EC 5C 8B 5C 24 70 8D 7C 24 4C 8B 6B 30 8D 73 10 89 74 24 30 8D 73 34 89 F0 8D 4B 3C 89 EE 89 C5 89 4C 24 38 8D B4 26 00 00 00 00 8B 43 48 C7 44 24 4C 10 00 00 00 85 C0 0F 84 C5 01 00 00 8B 43 2C 8B 4C 24 30 89 43 34 8B 06 89 4B 3C 8B 4C 24 38 89 6B 44 C7 43 48 01 00 00 00 89 43 38 8D 43 58 89 43 4C C7 43 40 10 00 00 00 C7 43 50 DC 00 00 00 C7 44 24 08 00 00 00 00 89 4C 24 04 8B 03 89 04 24 E8 ?? ?? ?? ?? 85 C0 0F 88 9E 01 00 00 8B 7B 50 89 F5 8B 4B 40 83 FF 0B 89 4C 24 4C 76 42 8B 53 4C 85 D2 74 3B 8B 32 83 FE 0B 89 74 24 34 76 1B 83 C6 03 01 D7 83 E6 FC 01 D6 89 7C 24 3C 8D 7E 0C 39 7C 24 3C 0F 83 8D 01 00 00 8B 72 04 85 F6 75 0E 83 7A 08 08 0F 84 DB 01 00 00 8D 74 26 00 C7 43 4C 00 00 00 00 C7 43 50 00 00 00 00 89 4B 0C 83 F8 0F 0F 8E 50 01 00 00 8B 45 0C 8D 75 08 C7 45 08 01 00 00 00 C7 44 24 04 00 00 00 00 89 34 24 FF 50 14 8B 7C 24 74 89 34 24 89 7C 24 04 E8 ?? ?? ?? ?? 85 C0 0F 84 1D 01 00 00 8B 07 89 45 04 8B AD B0 01 00 00 B8 01 00 00 00 85 ED 0F 84 07 01 00 00 8B 43 30 31 D2 8B B8 B0 01 00 00 8B 70 04 8B 0F 89 F0 C1 E1 02 F7 F1 8B 47 04 8B 2C 90 8D 57 1C 85 ED 75 12 E9 0A 01 00 00 66 90 8B 6D 28 85 ED 0F 84 FD 00 00 00 3B 75 00 75 F0 8B 47 18 39 45 04 75 E8 8B 4F 14 39 4D 08 75 E0 8B 47 10 39 45 0C 75 D8 8D 45 10 89 54 24 04 C7 44 24 08 10 00 00 00 89 04 24 89 54 24 2C E8 ?? ?? ?? ?? 8B 54 24 2C 85 C0 75 B5 8B 7B 48 8B 55 20 8B 4D 24 85 FF 0F 85 02 01 00 00 8B 44 24 4C 8B 74 24 30 C7 44 24 0C 00 00 00 00 89 4C 24 08 89 44 24 14 89 74 24 10 89 54 24 04 8B 03 89 04 24 E8 ?? ?? ?? ?? B8 01 00 00 00 EB 4F 8D 76 00 8B 4C 24 30 89 7C 24 14 C7 44 24 0C 00 00 00 00 89 4C 24 10 8B 06 89 44 24 08 8B 43 2C 89 44 24 04 8B 03 89 04 24 E8 ?? ?? ?? ?? 8B 4C 24 4C 83 F8 FF 89 4B 0C 0F 85 BD 00 00 00 A1 ?? ?? ?? ?? 65 83 38 04 0F 84 DE FD FF FF 31 C0 83 C4 5C 5B 5E 5F 5D C3 8D 74 26 00 8B 3E 83 C7 03 83 E7 FC 01 FE 39 74 24 3C 0F 82 5F FE FF FF E9 6F FE FF FF 8D B4 26 00 00 00 00 8B 4C 24 74 8B 74 24 30 8B 41 14 89 47 18 8B 41 10 89 47 14 8B 41 0C 89 47 10 8B 43 10 89 47 1C 8B 46 04 89 42 04 8B 46 08 89 42 08 8B 46 0C 89 42 0C 83 C4 5C B8 01 00 00 00 5B 5E 5F 5D C3 83 7C 24 34 17 0F 86 1E FE FF FF C7 42 0C 00 00 00 00 E9 20 FE FF FF 8B 7C 24 38 89 53 34 89 4B 38 C7 44 24 08 00 00 00 00 89 7C 24 04 8B 03 89 04 24 E8 ?? ?? ?? ?? B8 01 00 00 00 E9 54 FF FF FF 89 F5 E9 F2 FD FF FF }
	condition:
		$1
}

rule file_360_5_0 {
	meta:
		name = "svcudp_reply"
		size = 702
		refs = "0047 xdr_replymsg 00a5 __sendto 0120 _libc_intl_domainname 0125 __dcgettext 013d __fxprintf 016e __sendmsg 01ac xdrmem_create 022f malloc 026b free"
	strings:
		$1 = { 83 EC 4C 89 5C 24 3C 8B 5C 24 50 89 74 24 40 89 7C 24 44 89 6C 24 48 8B 6C 24 54 8B 73 30 8B 46 0C 8D 7E 08 C7 46 08 00 00 00 00 C7 44 24 04 00 00 00 00 89 3C 24 FF 50 14 8B 46 04 89 45 00 89 6C 24 04 89 3C 24 E8 ?? ?? ?? ?? 85 C0 75 19 31 D2 89 D0 8B 5C 24 3C 8B 74 24 40 8B 7C 24 44 8B 6C 24 48 83 C4 4C C3 90 8B 46 0C 89 3C 24 FF 50 10 89 C5 8B 43 48 85 C0 0F 85 D2 00 00 00 8B 53 0C 8D 43 10 89 44 24 10 C7 44 24 0C 00 00 00 00 89 6C 24 08 89 54 24 14 8B 43 2C 89 44 24 04 8B 03 89 04 24 E8 ?? ?? ?? ?? 39 E8 75 A2 8B 86 B0 01 00 00 BA 01 00 00 00 85 C0 74 95 85 ED 78 91 8B 4B 30 8B B9 B0 01 00 00 8B 77 0C 8B 47 08 8B 34 B0 85 F6 0F 84 45 01 00 00 8B 07 31 D2 C1 E0 02 89 44 24 2C 8B 06 F7 74 24 2C 8B 47 04 8D 04 90 8B 10 85 D2 74 16 39 D6 75 0B EB 7E 8D 76 00 39 C6 74 74 89 C2 8B 42 28 85 C0 75 F3 C7 44 24 08 05 00 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 44 24 04 ?? ?? ?? ?? C7 04 24 00 00 00 00 89 44 24 08 E8 ?? ?? ?? ?? BA 01 00 00 00 E9 06 FF FF FF 90 8D 74 26 00 8B 43 2C 89 6B 38 89 43 34 8D 43 3C C7 44 24 08 00 00 00 00 89 44 24 04 8B 03 89 04 24 E8 ?? ?? ?? ?? E9 32 FF FF FF 90 8D 42 28 8B 56 28 89 10 8B 46 20 8B 53 2C 89 6E 24 89 56 20 89 43 2C C7 44 24 0C 00 00 00 00 8B 11 89 44 24 04 8D 41 08 89 04 24 89 4C 24 24 89 54 24 08 E8 ?? ?? ?? ?? 8B 4C 24 24 8B 57 18 8B 41 04 89 56 04 8B 57 14 89 06 89 56 08 8B 57 10 89 56 0C 8B 57 1C 89 56 10 8B 57 20 89 56 14 8B 57 24 89 56 18 8B 57 28 89 56 1C 8B 53 30 8B 92 B0 01 00 00 8B 0A 31 D2 C1 E1 02 F7 F1 8B 47 04 8D 04 90 8B 10 89 56 28 89 30 8B 47 0C 8B 57 08 89 34 82 83 C0 01 31 D2 F7 37 89 57 0C BA 01 00 00 00 E9 32 FE FF FF C7 04 24 2C 00 00 00 89 54 24 28 89 4C 24 24 E8 ?? ?? ?? ?? 8B 54 24 28 8B 4C 24 24 85 C0 89 C6 89 44 24 2C 74 67 8B 01 89 4C 24 24 89 54 24 28 89 04 24 E8 ?? ?? ?? ?? 8B 4C 24 24 85 C0 0F 85 20 FF FF FF 8B 44 24 2C 89 04 24 E8 ?? ?? ?? ?? C7 44 24 08 05 00 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 44 24 04 ?? ?? ?? ?? C7 04 24 00 00 00 00 89 44 24 08 E8 ?? ?? ?? ?? 8B 54 24 28 E9 A5 FD FF FF C7 44 24 08 05 00 00 00 C7 44 24 04 ?? ?? ?? ?? EB C1 }
	condition:
		$1
}

rule file_360_6_0 {
	meta:
		name = "svcudp_bufcreate"
		size = 686
		refs = "0051 bindresvport 006d __getsockname 0081 malloc 00e8 xdrmem_create 0141 __setsockopt 016d xprt_register 0195 _libc_intl_domainname 019a __dcgettext 01a2 perror 01ae __close 01d7 __bind 01f8 __socket 025c __fxprintf 0266 free"
	strings:
		$1 = { 55 57 31 FF 56 53 83 EC 5C 8B 74 24 70 C7 44 24 38 10 00 00 00 83 FE FF 0F 84 C2 01 00 00 8D 5C 24 40 89 5C 24 04 89 34 24 C7 44 24 40 00 00 00 00 C7 44 24 44 00 00 00 00 C7 44 24 48 00 00 00 00 C7 44 24 4C 00 00 00 00 66 C7 44 24 40 02 00 E8 ?? ?? ?? ?? 85 C0 0F 85 63 01 00 00 8D 44 24 38 89 44 24 08 89 5C 24 04 89 34 24 E8 ?? ?? ?? ?? 85 C0 0F 85 07 01 00 00 C7 04 24 34 01 00 00 E8 ?? ?? ?? ?? C7 04 24 B4 01 00 00 89 C3 E8 ?? ?? ?? ?? 89 C7 8B 44 24 74 39 44 24 78 89 C5 0F 43 6C 24 78 83 C5 03 83 E5 FC 89 2C 24 E8 ?? ?? ?? ?? 85 FF 89 C2 0F 84 64 01 00 00 85 DB 0F 84 5C 01 00 00 85 C0 0F 84 54 01 00 00 89 2F 89 43 2C 89 44 24 04 8D 47 08 89 04 24 C7 44 24 0C 01 00 00 00 89 6C 24 08 E8 ?? ?? ?? ?? 0F B7 44 24 42 C7 87 B0 01 00 00 00 00 00 00 89 7B 30 83 C7 20 66 C1 C8 08 66 89 43 04 8D 44 24 3C 89 7B 24 C7 43 08 ?? ?? ?? ?? 89 33 C7 44 24 10 04 00 00 00 89 44 24 0C C7 44 24 08 08 00 00 00 C7 44 24 04 00 00 00 00 89 34 24 C7 44 24 3C 01 00 00 00 E8 ?? ?? ?? ?? 85 C0 0F 85 C3 00 00 00 C7 44 24 3C FF 00 00 00 B0 FF 69 C0 01 01 01 01 B9 40 00 00 00 8D 53 34 89 D7 F3 AB 89 1C 24 E8 ?? ?? ?? ?? 83 C4 5C 89 D8 5B 5E 5F 5D C3 90 8D 74 26 00 C7 44 24 08 05 00 00 00 31 DB C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 85 FF 74 C7 89 34 24 E8 ?? ?? ?? ?? 83 C4 5C 89 D8 5B 5E 5F 5D C3 8D 74 26 00 8B 44 24 38 89 5C 24 04 89 34 24 66 C7 44 24 42 00 00 89 44 24 08 E8 ?? ?? ?? ?? E9 7D FE FF FF C7 44 24 08 11 00 00 00 C7 44 24 04 02 00 00 00 C7 04 24 02 00 00 00 E8 ?? ?? ?? ?? 85 C0 89 C6 0F 88 7D 00 00 00 BF 01 00 00 00 E9 0E FE FF FF C7 44 24 3C 00 00 00 00 31 C0 E9 38 FF FF FF 90 C7 44 24 08 05 00 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? 89 54 24 2C E8 ?? ?? ?? ?? C7 44 24 08 ?? ?? ?? ?? C7 44 24 04 ?? ?? ?? ?? C7 04 24 00 00 00 00 89 44 24 0C E8 ?? ?? ?? ?? 89 1C 24 31 DB E8 ?? ?? ?? ?? 89 3C 24 E8 ?? ?? ?? ?? 8B 54 24 2C 89 14 24 E8 ?? ?? ?? ?? E9 EE FE FF FF C7 44 24 08 05 00 00 00 31 DB C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? E9 C3 FE FF FF }
	condition:
		$1
}

rule file_360_7_0 {
	meta:
		name = "svcudp_create"
		size = 35
		refs = "001b svcudp_bufcreate"
	strings:
		$1 = { 83 EC 1C 8B 44 24 20 C7 44 24 08 60 22 00 00 C7 44 24 04 60 22 00 00 89 04 24 E8 ?? ?? ?? ?? 83 C4 1C C3 }
	condition:
		$1
}

rule file_360_8_0 {
	meta:
		name = "svcudp_enablecache"
		size = 314
		refs = "0033 _libc_intl_domainname 0038 __dcgettext 0050 __fxprintf 0070 malloc 0096 calloc 00fc free"
	strings:
		$1 = { 83 EC 1C 8B 44 24 20 89 5C 24 10 89 74 24 14 89 7C 24 18 8B 58 30 8B 83 B0 01 00 00 85 C0 74 48 C7 44 24 08 05 00 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 44 24 04 ?? ?? ?? ?? C7 04 24 00 00 00 00 89 44 24 08 E8 ?? ?? ?? ?? 31 C0 8B 5C 24 10 8B 74 24 14 8B 7C 24 18 83 C4 1C C3 66 90 C7 04 24 2C 00 00 00 E8 ?? ?? ?? ?? 85 C0 89 C6 74 66 8B 44 24 24 C7 04 24 04 00 00 00 C7 46 0C 00 00 00 00 89 06 C1 E0 02 89 44 24 04 E8 ?? ?? ?? ?? 85 C0 89 C7 89 46 04 74 55 8B 44 24 24 C7 04 24 04 00 00 00 89 44 24 04 E8 ?? ?? ?? ?? 85 C0 89 46 08 74 57 89 B3 B0 01 00 00 B8 01 00 00 00 8B 5C 24 10 8B 74 24 14 8B 7C 24 18 83 C4 1C C3 8D B4 26 00 00 00 00 C7 44 24 08 05 00 00 00 C7 44 24 04 ?? ?? ?? ?? E9 3B FF FF FF 8D 76 00 89 34 24 E8 ?? ?? ?? ?? C7 44 24 08 05 00 00 00 C7 44 24 04 ?? ?? ?? ?? E9 1B FF FF FF 89 3C 24 E8 ?? ?? ?? ?? 89 34 24 E8 ?? ?? ?? ?? C7 44 24 08 05 00 00 00 C7 44 24 04 ?? ?? ?? ?? E9 F6 FE FF FF }
	condition:
		$1
}

rule file_362_0_0 {
	meta:
		name = "isfdtype"
		size = 92
		refs = "0009 __libc_errno 002f __fxstat64"
	strings:
		$1 = { 83 EC 7C 89 5C 24 74 8B 1D ?? ?? ?? ?? 8D 44 24 10 89 74 24 78 65 8B 33 89 44 24 08 8B 84 24 80 00 00 00 C7 04 24 03 00 00 00 89 44 24 04 E8 ?? ?? ?? ?? 65 89 33 85 C0 75 16 8B 44 24 20 25 00 F0 00 00 3B 84 24 84 00 00 00 0F 94 C0 0F B6 C0 8B 5C 24 74 8B 74 24 78 83 C4 7C C3 }
	condition:
		$1
}

rule file_363_0_0 {
	meta:
		name = "setpriority"
		size = 37
		refs = "0014 _dl_sysinfo 0020 __syscall_error"
	strings:
		$1 = { 53 8B 54 24 10 8B 4C 24 0C 8B 5C 24 08 B8 61 00 00 00 FF 15 ?? ?? ?? ?? 5B 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_364_0_0 {
	meta:
		name = "str_to_mpn"
		size = 481
		refs = "0083 _tens_in_limb 00c0 __mpn_mul_1"
	strings:
		$1 = { 55 89 D5 57 31 FF 56 31 F6 53 89 C3 83 EC 2C 8B 54 24 40 89 4C 24 1C C7 02 00 00 00 00 31 D2 90 8B 03 8D 48 D0 83 F9 09 76 06 8B 43 04 83 C3 04 83 ED 01 83 C3 04 8D 0C B6 83 C2 01 85 ED 8D 74 48 D0 7E 24 83 FA 09 75 D7 85 FF 75 5B 8B 54 24 40 66 BF 01 00 8B 4C 24 1C 89 31 31 F6 C7 02 01 00 00 00 31 D2 EB B9 90 8B 4C 24 44 8B 01 85 C0 7E 0C 8D 0C 02 83 F9 09 0F 8E AA 00 00 00 85 FF 8B 04 95 ?? ?? ?? ?? 0F 85 BC 00 00 00 8B 4C 24 1C 8B 54 24 40 89 31 C7 02 01 00 00 00 83 C4 2C 89 D8 5B 5E 5F 5D C3 90 8B 4C 24 1C 89 7C 24 08 C7 44 24 0C 00 CA 9A 3B 89 4C 24 04 89 0C 24 E8 ?? ?? ?? ?? 8B 7C 24 40 8B 17 8B 7C 24 1C 89 C1 8B 07 01 C6 39 F0 89 37 76 21 8B 7C 24 1C 83 C7 04 8D B4 26 00 00 00 00 83 EA 01 0F 84 DF 00 00 00 8B 07 83 C0 01 85 C0 AB 74 ED 31 C0 01 C1 8B 54 24 40 0F 84 B7 00 00 00 8B 02 31 F6 8B 7C 24 1C 89 0C 87 8B 02 89 C7 83 C7 01 89 3A 31 D2 E9 FC FE FF FF 8D 74 26 00 8B 54 24 44 0F AF 34 85 ?? ?? ?? ?? 85 FF 8B 04 8D ?? ?? ?? ?? C7 02 00 00 00 00 0F 84 44 FF FF FF 8B 4C 24 1C 89 7C 24 08 89 44 24 0C 89 4C 24 04 89 0C 24 E8 ?? ?? ?? ?? 8B 7C 24 40 8B 17 8B 7C 24 1C 89 C1 8B 07 01 C6 39 F0 89 37 76 18 8B 7C 24 1C 83 C7 04 66 90 83 EA 01 74 55 8B 07 83 C0 01 85 C0 AB 74 F1 31 C0 01 C8 0F 84 04 FF FF FF 8B 4C 24 40 8B 11 8B 4C 24 1C 89 04 91 8B 4C 24 40 83 C2 01 89 D8 89 11 83 C4 2C 5B 5E 5F 5D C3 8D B4 26 00 00 00 00 8B 3A 31 F6 31 D2 E9 55 FE FF FF 90 8D 74 26 00 B8 01 00 00 00 E9 23 FF FF FF B8 01 00 00 00 EB B0 }
	condition:
		$1
}

rule file_364_1_0 {
	meta:
		name = "round_and_return"
		size = 425
		refs = "007f __mpn_rshift 0088 __libc_errno 0125 __mpn_construct_float"
	strings:
		$1 = { 83 EC 3C 83 FA 82 89 5C 24 2C 89 C3 89 74 24 30 8B 74 24 40 89 7C 24 34 8B 7C 24 48 89 6C 24 38 89 CD 8B 4C 24 44 7D 70 B8 82 FF FF FF 29 D0 83 F8 18 0F 8F F8 00 00 00 C7 44 24 1C 01 00 00 00 D3 64 24 1C 8B 4C 24 1C 83 E9 01 85 F1 8B 33 0F 95 C1 0F B6 C9 09 CF 83 F8 18 0F 84 30 01 00 00 B9 81 FF FF FF 29 D1 89 44 24 0C C7 44 24 08 01 00 00 00 89 5C 24 04 89 1C 24 89 4C 24 18 E8 ?? ?? ?? ?? 8B 4C 24 18 A1 ?? ?? ?? ?? BA 81 FF FF FF 65 C7 00 22 00 00 00 0F A3 CE 73 23 85 FF 8B 03 75 08 A8 01 0F 84 95 00 00 00 83 C0 01 A9 00 00 00 01 89 03 0F 85 9D 00 00 00 83 FA 81 74 38 81 FA 80 00 00 00 7E 3D 85 ED D9 05 ?? ?? ?? ?? 75 16 8B 5C 24 2C 8B 74 24 30 8B 7C 24 34 8B 6C 24 38 83 C4 3C C3 66 90 DD D8 D9 05 ?? ?? ?? ?? EB E0 8D B6 00 00 00 00 A9 00 00 80 00 B8 82 FF FF FF 0F 45 D0 89 6C 24 48 8B 74 24 30 89 5C 24 40 8B 7C 24 34 8B 5C 24 2C 8B 6C 24 38 89 54 24 44 83 C4 3C E9 ?? ?? ?? ?? 8D B4 26 00 00 00 00 A1 ?? ?? ?? ?? D9 EE 65 C7 00 22 00 00 00 EB 92 BF 01 00 00 00 D3 E7 83 EF 01 85 F7 0F 84 6E FF FF FF E9 54 FF FF FF 90 83 C2 01 C7 44 24 0C 01 00 00 00 C7 44 24 08 01 00 00 00 89 5C 24 04 89 1C 24 89 54 24 18 E8 ?? ?? ?? ?? 8B 54 24 18 81 0B 00 00 80 00 E9 36 FF FF FF 8D B6 00 00 00 00 31 C0 85 F6 0F 95 C0 B9 17 00 00 00 09 C7 C7 03 00 00 00 00 E9 DE FE FF FF }
	condition:
		$1
}

rule file_364_2_0 {
	meta:
		name = "____wcstof_l_internal"
		size = 6938
		refs = "0065 __iswspace_l 00e9 __towlower_l 02b7 __correctly_grouped_prefixwc 04d2 _fpioconst_pow10 04fc __tens 050d __mpn_mul 05c5 __iswxdigit_l 0794 _nl_C_locobj 08de memcpy 0b50 __mpn_lshift 0bdd __mpn_cmp 0d31 __mpn_submul_1 0d5d __mpn_add_n 11e1 __wcsncasecmp_l 1743 __mpn_rshift 1901 ____wcstoull_l_internal 1953 __libc_errno"
	strings:
		$1 = { 55 57 56 53 81 EC DC 00 00 00 8B 94 24 FC 00 00 00 8B 42 04 8B 94 24 F8 00 00 00 85 D2 0F 85 20 1A 00 00 C7 44 24 68 00 00 00 00 C7 44 24 58 00 00 00 00 8B 40 30 8B B4 24 F0 00 00 00 8B 9C 24 FC 00 00 00 C7 84 24 84 00 00 00 00 00 00 00 89 44 24 5C 83 EE 04 66 90 83 C6 04 8B 2E 89 5C 24 04 89 2C 24 E8 ?? ?? ?? ?? 85 C0 75 EB 83 FD 2D 89 F0 0F 84 E0 06 00 00 83 FD 2B C7 44 24 70 00 00 00 00 0F 84 57 07 00 00 3B 6C 24 5C 0F 84 DD 06 00 00 8D 45 D0 83 F8 09 0F 87 F1 06 00 00 83 FD 30 C7 44 24 54 0A 00 00 00 0F 84 D2 0D 00 00 8B 4C 24 58 89 F3 8B 54 24 58 85 C9 0F 95 C0 EB 10 8D B4 26 00 00 00 00 84 C0 74 0E 83 C3 04 8B 2B 83 FD 30 74 F6 39 D5 74 EE 8B 94 24 FC 00 00 00 89 2C 24 89 54 24 04 E8 ?? ?? ?? ?? 8D 4D D0 83 F9 09 89 C7 0F 87 5D 01 00 00 89 DF C7 44 24 4C 00 00 00 00 83 F9 09 0F 86 32 01 00 00 83 7C 24 54 10 0F 84 08 01 00 00 8B 44 24 58 85 C0 0F 85 9B 18 00 00 8B 44 24 68 89 F9 85 C0 0F 85 9C 18 00 00 83 7C 24 4C 01 8B 74 24 4C 19 D2 3B 6C 24 5C 89 54 24 58 0F 84 C4 01 00 00 8B 94 24 FC 00 00 00 89 2C 24 89 54 24 04 E8 ?? ?? ?? ?? 83 7C 24 54 10 0F 94 44 24 60 83 F8 70 0F 85 1C 02 00 00 80 7C 24 60 00 0F 84 11 02 00 00 C6 44 24 60 01 8B 57 04 83 FA 2D 0F 84 FA 06 00 00 83 FA 2B 8D 4F 04 C7 44 24 68 00 00 00 00 0F 84 D5 0C 00 00 8D 42 D0 83 F8 09 0F 87 E9 01 00 00 80 7C 24 60 00 0F 85 9F 06 00 00 8B 44 24 68 85 C0 0F 84 06 0D 00 00 8B 44 24 4C 83 C0 3D 89 44 24 6C 89 5C 24 74 8B 84 24 84 00 00 00 8B 5C 24 6C 90 8D 04 80 8D 44 42 D0 39 D8 89 84 24 84 00 00 00 0F 8F 51 17 00 00 83 C1 04 8B 11 8D 6A D0 83 FD 09 76 DD 8B 54 24 68 8B 5C 24 74 85 D2 0F 84 86 01 00 00 F7 D8 89 84 24 84 00 00 00 E9 78 01 00 00 8B 94 24 FC 00 00 00 89 2C 24 89 54 24 04 E8 ?? ?? ?? ?? 83 E8 61 83 F8 05 0F 87 D9 FE FF FF 83 44 24 4C 01 83 C7 04 8B 2F 8D 4D D0 E9 B3 FE FF FF 8D B6 00 00 00 00 83 7C 24 54 10 0F 95 C0 83 FF 60 76 0D 84 C0 75 09 83 FF 66 0F 86 89 FE FF FF 3B 6C 24 5C 0F 84 84 05 00 00 84 C0 66 90 0F 84 AB 0C 00 00 83 7C 24 54 10 0F 94 C2 83 FF 65 75 08 84 D2 0F 84 60 FE FF FF 8B 4C 24 68 8B 7C 24 58 89 5C 24 04 89 34 24 89 4C 24 0C 89 7C 24 08 88 54 24 2C E8 ?? ?? ?? ?? 8B 94 24 F4 00 00 00 85 D2 0F B6 54 24 2C 74 1F 39 C6 0F 84 30 15 00 00 89 84 24 F0 00 00 00 8B 9C 24 F0 00 00 00 8B 8C 24 F4 00 00 00 89 19 8B 44 24 70 D9 EE 85 C0 0F 84 4E 04 00 00 DD D8 8D B6 00 00 00 00 81 C4 DC 00 00 00 D9 EE 5B D9 E0 5E 5F 5D C3 90 89 5C 24 60 83 C7 04 89 F3 8B 69 04 89 D6 EB 3D 8B 94 24 FC 00 00 00 89 2C 24 89 54 24 04 E8 ?? ?? ?? ?? 83 E8 61 83 F8 05 0F 87 7D 0B 00 00 83 FE FF 75 11 83 FD 30 89 D8 0F 95 C2 2B 44 24 4C 84 D2 0F 45 F0 83 C7 04 8B 2F 83 C3 01 8D 45 D0 83 F8 09 76 DA 83 7C 24 54 10 74 B4 8B 94 24 FC 00 00 00 89 2C 24 89 74 24 58 89 DE 8B 5C 24 60 89 54 24 04 E8 ?? ?? ?? ?? C6 44 24 60 00 83 F8 65 0F 84 59 04 00 00 89 F9 39 74 24 4C 0F 8C 03 02 00 00 85 F6 8B 6C 24 4C 7E 0D 39 74 24 4C 0F 84 D3 02 00 00 8D 76 00 8B 84 24 F4 00 00 00 85 C0 74 09 8B BC 24 F4 00 00 00 89 0F 85 F6 0F 84 64 03 00 00 8B 44 24 58 89 DF 85 C0 74 2F 8B 54 24 5C 39 13 74 09 89 D0 83 C3 04 39 03 75 F9 8B 4C 24 58 89 C8 C1 E0 02 83 7C 24 54 10 8D 7C 8B 04 0F 45 C1 29 CE 29 84 24 84 00 00 00 83 7C 24 54 10 8B 9C 24 FC 00 00 00 0F 84 9C 01 00 00 8B 84 24 84 00 00 00 85 C0 0F 88 4A 04 00 00 89 F2 29 EA 39 C2 0F 4F D0 01 D5 29 D0 89 EA 01 C2 83 FA 27 89 6C 24 50 89 84 24 84 00 00 00 0F 8F 1F 16 00 00 83 F8 D4 0F 8C 39 16 00 00 8B 54 24 50 85 D2 0F 8E 58 05 00 00 8D 9C 24 90 00 00 00 8B 54 24 50 89 F8 89 5C 24 5C 8B 4C 24 5C 8D 9C 24 84 00 00 00 89 5C 24 6C 89 5C 24 04 8D 9C 24 80 00 00 00 89 1C 24 89 5C 24 68 E8 C1 F7 FF FF 8B 9C 24 80 00 00 00 89 C7 8B 84 24 84 00 00 00 85 C0 0F 8E 31 04 00 00 8D 94 24 B0 00 00 00 BD 01 00 00 00 89 54 24 64 89 D1 8B 54 24 5C 89 74 24 58 BE ?? ?? ?? ?? C7 44 24 60 ?? ?? ?? ?? 89 7C 24 54 89 54 24 4C EB 69 89 7C 24 10 8B 06 89 54 24 04 89 0C 24 89 5C 24 08 8D 04 85 ?? ?? ?? ?? 89 44 24 0C 89 54 24 2C 89 4C 24 30 E8 ?? ?? ?? ?? 8B 54 24 2C 8B 4C 24 30 8B 9C 24 80 00 00 00 01 FB 85 C0 89 9C 24 80 00 00 00 75 0A 83 EB 01 89 9C 24 80 00 00 00 8B 84 24 84 00 00 00 89 D7 89 CA 89 F9 01 ED 83 C6 10 85 C0 0F 84 62 03 00 00 85 E8 74 EF 8B 7E 04 31 E8 89 84 24 84 00 00 00 83 EF 02 39 DF 7E 80 89 54 24 0C 89 5C 24 10 89 7C 24 08 8B 06 89 0C 24 89 54 24 2C 89 4C 24 30 8D 04 85 ?? ?? ?? ?? 89 44 24 04 E8 ?? ?? ?? ?? 8B 4C 24 30 8B 54 24 2C E9 7B FF FF FF 66 90 83 EF 04 83 EE 01 83 7F FC 30 74 F4 E9 F2 FD FF FF 8D B4 26 00 00 00 00 83 C7 04 89 5C 24 04 8B 07 89 04 24 E8 ?? ?? ?? ?? 85 C0 74 EB EB 04 90 83 C7 04 8B 07 83 F8 30 74 F6 8D 50 D0 83 C7 04 83 FA 09 0F 87 7A 10 00 00 8B 04 95 ?? ?? ?? ?? B9 18 00 00 00 BB 17 00 00 00 83 EE 01 29 C1 29 C3 D3 E2 89 94 24 88 00 00 00 8D 54 A8 FB 03 94 24 84 00 00 00 85 F6 89 94 24 84 00 00 00 0F 8E 08 0F 00 00 8B AC 24 FC 00 00 00 EB 24 8D 76 00 83 FB 02 0F 8E 1F 0F 00 00 8D 4B FD 83 EB 04 D3 E0 09 84 24 88 00 00 00 83 EE 01 0F 84 D4 0E 00 00 89 6C 24 04 8B 07 89 04 24 E8 ?? ?? ?? ?? 8D 57 04 85 C0 0F 44 FA 8B 17 83 C7 04 8D 42 D0 83 F8 09 76 BC 89 6C 24 04 89 14 24 E8 ?? ?? ?? ?? 83 E8 57 EB AB 8D 76 00 8B 84 24 84 00 00 00 85 C0 0F 89 21 FD FF FF 89 E8 83 EF 04 89 5C 24 68 89 F5 0F B6 5C 24 60 89 4C 24 6C 89 C6 EB 4F 90 8B 07 83 E8 30 83 F8 09 0F 97 C0 84 C0 75 3C 83 3F 30 0F 85 D8 01 00 00 8B 8C 24 84 00 00 00 83 ED 01 83 EE 01 80 FB 01 19 C0 83 E0 FD 8D 44 08 04 89 84 24 84 00 00 00 C1 E8 1F 84 C0 0F 84 AD 01 00 00 85 ED 0F 8E A5 01 00 00 83 EF 04 84 DB 74 AE 8B 94 24 FC 00 00 00 89 54 24 04 8B 07 89 04 24 E8 ?? ?? ?? ?? 85 C0 0F 94 C0 EB 9D 8B 94 24 F4 00 00 00 85 D2 74 0F 8B B4 24 F4 00 00 00 89 06 8D B6 00 00 00 00 8B 4C 24 70 85 C9 0F 85 BC FB FF FF D9 EE 81 C4 DC 00 00 00 5B 5E 5F 5D C3 8D B4 26 00 00 00 00 8B 68 04 83 C6 04 3B 6C 24 5C C7 44 24 70 01 00 00 00 0F 85 23 F9 FF FF 8B 46 04 83 F8 2F 0F 86 17 F9 FF FF 83 F8 39 0F 86 1A F9 FF FF E9 09 F9 FF FF 8D B6 00 00 00 00 C7 44 24 04 ?? ?? ?? ?? 89 2C 24 E8 ?? ?? ?? ?? 83 F8 69 0F 84 1D 0E 00 00 83 F8 6E 0F 84 13 0A 00 00 8B 9C 24 F4 00 00 00 85 DB 74 87 8B B4 24 F0 00 00 00 D9 EE 8B 9C 24 F4 00 00 00 89 33 81 C4 DC 00 00 00 5B 5E 5F 5D C3 8D B6 00 00 00 00 83 C6 04 8B 68 04 E9 9E F8 FF FF 90 8D 74 26 00 83 7C 24 54 10 0F 84 9C FB FF FF E9 82 F9 FF FF 39 DE 0F 85 F3 F8 FF FF 83 7C 24 54 10 8D 76 00 0F 85 E5 F8 FF FF 8B 53 04 8D 42 D0 83 F8 09 0F 86 D6 F8 FF FF 8B 84 24 FC 00 00 00 89 14 24 89 4C 24 30 89 44 24 04 E8 ?? ?? ?? ?? 8B 4C 24 30 83 E8 61 83 F8 05 0F 87 3A FA FF FF E9 AA F8 FF FF 8D B4 26 00 00 00 00 8B 44 24 68 85 C0 0F 84 49 09 00 00 8B 44 24 4C 8D 04 85 95 00 00 00 89 44 24 6C E9 58 F9 FF FF 89 EA F7 DA 39 C2 0F 4C D0 E9 B1 FB FF FF 66 90 8D 4F 08 8B 57 08 C7 44 24 68 01 00 00 00 E9 07 F9 FF FF 90 8D 74 26 00 89 F0 8B 5C 24 68 89 EE 8B 4C 24 6C 89 C5 E9 05 FB FF FF 8B 4C 24 64 8B 7C 24 54 8B 74 24 58 89 54 24 4C 39 CA 75 21 8D 04 9D 00 00 00 00 89 44 24 08 8B 44 24 5C 89 54 24 04 89 04 24 E8 ?? ?? ?? ?? 8D B6 00 00 00 00 8D 43 FF 89 D9 0F BD 94 84 90 00 00 00 C1 E1 05 83 F2 1F 29 D1 89 4C 24 4C 83 C1 80 0F 8F 68 11 00 00 83 7C 24 4C 18 0F 8E CA 05 00 00 8B 54 24 4C 83 EA 18 89 D7 C1 FF 05 83 E2 1F 0F 84 F3 08 00 00 8D 4A FF 39 F8 8B AC BC 90 00 00 00 89 4C 24 54 0F 8F 52 0D 00 00 8D 84 24 88 00 00 00 89 6C 24 58 89 44 24 60 8B 44 24 58 89 D1 D3 E8 89 84 24 88 00 00 00 89 F8 8B BC 24 90 00 00 00 31 C9 85 FF 75 15 8B 54 24 5C 8D B4 26 00 00 00 00 83 C1 01 8B 1C 8A 85 DB 74 F6 8B 54 24 4C 8B 5C 24 54 89 2C 24 83 EA 01 39 C1 0F 9C C0 39 74 24 50 89 5C 24 04 0F 9C C1 09 C8 8B 4C 24 70 0F B6 C0 89 44 24 08 8B 44 24 60 E8 9A F4 FF FF E9 8B FD FF FF 90 8D 74 26 00 8D 9C 24 88 00 00 00 B9 0A 00 00 00 89 5C 24 60 8D 9C 24 90 00 00 00 BA 08 00 00 00 89 5C 24 5C 8D 9C 24 84 00 00 00 89 5C 24 6C 8D 9C 24 80 00 00 00 C7 44 24 4C 00 00 00 00 89 5C 24 68 2B 74 24 50 C6 44 24 7F 00 39 CE 89 74 24 58 7E 0C 83 C2 02 89 54 24 58 C6 44 24 7F 01 8B 5C 24 5C BE ?? ?? ?? ?? 8B 6C 24 58 89 7C 24 74 31 FF C7 44 24 54 00 00 00 00 89 5C 24 50 8D 9C 24 B0 00 00 00 89 5C 24 64 89 DA 29 C5 BB 01 00 00 00 EB 37 8B 7E 04 8B 06 89 14 24 89 54 24 2C 83 EF 02 8D 0C BD 00 00 00 00 8D 04 85 ?? ?? ?? ?? 89 4C 24 08 89 44 24 04 E8 ?? ?? ?? ?? 8B 54 24 2C 01 DB 83 C6 10 85 ED 74 69 85 DD 74 F3 31 DD 85 FF 74 BF 89 7C 24 10 8B 4C 24 50 89 54 24 0C 8B 46 04 83 E8 02 89 44 24 08 8B 06 89 0C 24 89 54 24 2C 8D 04 85 ?? ?? ?? ?? 89 44 24 04 E8 ?? ?? ?? ?? 8B 4E 04 8B 54 24 2C 8D 7C 0F FE 85 C0 0F 85 95 03 00 00 89 D0 83 EF 01 8B 54 24 50 01 DB 83 C6 10 85 ED 89 44 24 50 75 9E 8D B4 26 00 00 00 00 3B 54 24 5C 89 7C 24 54 8B 7C 24 74 0F 84 7D 0C 00 00 8B 5C 24 6C 89 F8 8B 74 24 68 8B 4C 24 5C 8B 54 24 58 89 5C 24 04 89 34 24 E8 40 F1 FF FF 8B 7C 24 54 83 EF 01 0F BD 9C BC B0 00 00 00 89 7C 24 58 83 F3 1F 7E 43 8B 7C 24 64 8B 74 24 54 89 5C 24 0C 89 7C 24 04 89 74 24 08 89 3C 24 E8 ?? ?? ?? ?? 8B 84 24 80 00 00 00 89 5C 24 0C 8B 5C 24 5C 89 44 24 08 89 5C 24 04 89 1C 24 E8 ?? ?? ?? ?? 85 C0 0F 85 15 06 00 00 8B 74 24 4C 83 7C 24 54 01 89 B4 24 84 00 00 00 0F 84 CB 04 00 00 83 7C 24 54 02 0F 84 AB 03 00 00 8B 5C 24 54 8B 84 24 80 00 00 00 8B 74 24 54 8B 4C 24 58 83 EB 02 8B AC 9C B0 00 00 00 89 5C 24 50 8B 5C 24 64 29 C6 8B BC 8C B0 00 00 00 89 44 24 08 8D 04 B3 8B 74 24 5C 89 44 24 04 89 34 24 E8 ?? ?? ?? ?? 85 C0 8B 84 24 80 00 00 00 7E 15 C7 84 84 90 00 00 00 00 00 00 00 83 C0 01 89 84 24 80 00 00 00 39 44 24 54 0F 8E EF 06 00 00 8B 5C 24 54 8B 4C 24 4C 29 C3 89 DA C1 E2 05 85 C9 0F 8E CD 0B 00 00 03 54 24 4C 83 FA 18 0F 8F 74 0B 00 00 C7 84 24 88 00 00 00 00 00 00 00 89 54 24 4C C7 44 24 6C 00 00 00 00 85 C0 7E 1A 8B 74 24 5C 8D 14 9E 8D B4 26 00 00 00 00 8B 4C 86 FC 89 0C 82 83 E8 01 75 F4 85 DB 78 1E 8B 54 24 5C 83 C3 01 31 C0 8D B4 26 00 00 00 00 C7 04 82 00 00 00 00 83 C0 01 39 D8 75 F2 8B 74 24 54 83 7C 24 4C 18 C7 84 B4 B0 00 00 00 00 00 00 00 8B 8C B4 90 00 00 00 0F 8F 77 0C 00 00 8B 5C 24 54 8B 74 24 50 83 C3 01 89 5C 24 74 8B 5C 24 5C 8D 34 B3 89 74 24 78 8D B4 26 00 00 00 00 39 F9 BE FF FF FF FF 74 44 8B 5C 24 58 89 CA 8B 9C 9C 90 00 00 00 89 D8 F7 F7 89 C6 89 D1 89 E8 F7 E6 89 C3 EB 0D 66 90 31 C0 39 EB 0F 92 C0 29 EB 29 C2 39 CA 77 0F 75 14 8B 44 24 50 3B 9C 84 90 00 00 00 76 07 83 EE 01 01 F9 73 DB 8B 5C 24 64 8B 4C 24 74 89 74 24 0C 89 5C 24 04 8B 5C 24 5C 89 4C 24 08 89 1C 24 E8 ?? ?? ?? ?? 8B 5C 24 54 39 84 9C 90 00 00 00 74 1F 89 5C 24 0C 8B 5C 24 64 83 EE 01 89 5C 24 08 8B 5C 24 5C 89 5C 24 04 89 1C 24 E8 ?? ?? ?? ?? 8B 5C 24 58 8B 44 24 58 8B 8C 9C 90 00 00 00 8B 5C 24 54 85 C0 89 8C 9C 90 00 00 00 7E 1D 8B 44 24 78 8D 94 24 8C 00 00 00 8D B6 00 00 00 00 8B 18 83 E8 04 89 58 08 39 D0 75 F4 8B 44 24 4C C7 84 24 90 00 00 00 00 00 00 00 85 C0 0F 85 45 06 00 00 85 F6 0F 84 55 06 00 00 8B 9C 24 84 00 00 00 0F BD C6 BA 20 00 00 00 83 F0 1F 29 C2 29 C3 83 FA 18 89 9C 24 84 00 00 00 0F 8E D7 0C 00 00 8D 78 18 B9 08 00 00 00 89 7C 24 6C 8B 7C 24 54 29 C1 89 F0 D3 E8 89 84 24 88 00 00 00 8B 8C BC 90 00 00 00 85 C9 8B 44 24 54 75 22 8B 7C 24 54 85 FF 78 1A 8B 54 24 5C EB 0A 90 8D 74 26 00 83 F8 FF 74 0A 83 E8 01 8B 0C 82 85 C9 74 F1 F7 D0 8B 4C 24 70 C1 E8 1F 0A 44 24 7F 8D 53 FF 89 34 24 0F B6 C0 89 44 24 08 B8 1F 00 00 00 2B 44 24 6C 89 44 24 04 8B 44 24 60 E8 F1 EF FF FF E9 E2 F8 FF FF 8D 74 26 00 89 D0 8B 54 24 50 89 44 24 50 E9 07 FC FF FF 8D 4F 08 8B 57 08 E9 20 F3 FF FF 8B BC 24 FC 00 00 00 89 7C 24 04 8B 46 04 89 04 24 E8 ?? ?? ?? ?? 83 F8 78 0F 85 0F F2 FF FF 8B 6E 08 83 C6 08 C7 44 24 68 00 00 00 00 C7 44 24 54 10 00 00 00 E9 F4 F1 FF FF 89 74 24 58 89 DE 8B 5C 24 60 E9 81 F2 FF FF 8B 6C 24 58 2B 6C 24 4C 83 C5 27 89 6C 24 6C E9 F1 F2 FF FF 3B 74 24 50 0F 84 64 03 00 00 C1 E3 02 89 5C 24 08 8B 5C 24 5C 8D 84 24 88 00 00 00 89 04 24 89 44 24 60 89 5C 24 04 E8 ?? ?? ?? ?? B9 1A 00 00 00 BA 56 55 55 55 2B 4C 24 4C 89 C8 F7 EA 8B 84 24 84 00 00 00 C1 F9 1F 29 CA 8D 4A 02 E9 CD FA FF FF 83 FF 70 0F 85 4C F3 FF FF 39 DE 0F 85 B9 F1 FF FF E9 3F F3 FF FF 83 BC 24 80 00 00 00 01 8B BC 24 B0 00 00 00 8B B4 24 B4 00 00 00 0F 8E E7 03 00 00 8B AC 24 94 00 00 00 8B 94 24 90 00 00 00 C7 44 24 50 00 00 00 00 89 F9 F7 D9 89 4C 24 54 8D B4 26 00 00 00 00 39 F5 0F 84 20 04 00 00 89 D0 89 EA F7 F6 89 C3 89 D5 89 F8 F7 E3 89 D1 39 E9 77 08 85 C0 74 10 39 E9 75 0C 83 EB 01 29 F8 83 D9 00 01 F5 73 E8 31 D2 29 C2 19 CD 8B 44 24 4C 85 C0 0F 85 0E 04 00 00 85 DB 0F 84 76 04 00 00 8B 8C 24 84 00 00 00 0F BD C3 83 F0 1F 29 C1 89 4C 24 4C 89 8C 24 84 00 00 00 B9 20 00 00 00 29 C1 83 F9 18 0F 8E AA 0A 00 00 B9 08 00 00 }
	condition:
		$1
}

rule file_365_0_0 {
	meta:
		name = "mkstemps"
		size = 67
		refs = "0027 __gen_tempname 0031 __libc_errno"
	strings:
		$1 = { 83 EC 1C 8B 44 24 24 85 C0 78 25 89 44 24 04 8B 44 24 20 C7 44 24 0C 00 00 00 00 C7 44 24 08 00 00 00 00 89 04 24 E8 ?? ?? ?? ?? 83 C4 1C C3 90 A1 ?? ?? ?? ?? 65 C7 00 16 00 00 00 B8 FF FF FF FF EB E8 }
	condition:
		$1
}

rule file_367_0_0 {
	meta:
		name = "sendfile"
		size = 43
		refs = "0019 _dl_sysinfo 0026 __syscall_error"
	strings:
		$1 = { 56 53 8B 74 24 18 8B 54 24 14 8B 4C 24 10 8B 5C 24 0C B8 BB 00 00 00 FF 15 ?? ?? ?? ?? 5B 5E 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_368_6_0 {
	meta:
		name = "setrpcent"
		size = 142
		refs = "0056 __nss_rpc_lookup2 0062 __nss_setent 0068 __libc_errno"
	strings:
		$1 = { 83 EC 2C 31 C0 B9 01 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 0D ?? ?? ?? ?? 0F 85 B6 01 00 00 8B 44 24 30 C7 44 24 1C 00 00 00 00 C7 44 24 18 ?? ?? ?? ?? C7 44 24 10 ?? ?? ?? ?? 89 44 24 14 C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 ?? ?? ?? ?? C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 65 8B 0A 65 83 3D 0C 00 00 00 00 74 01 F0 83 2D ?? ?? ?? ?? 01 0F 85 61 01 00 00 65 89 0A 83 C4 2C C3 }
	condition:
		$1
}

rule file_1022_6_0 {
	meta:
		name = "setprotoent"
		size = 142
		refs = "0056 __nss_protocols_lookup2 0062 __nss_setent 0068 __libc_errno"
	strings:
		$1 = { 83 EC 2C 31 C0 B9 01 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 0D ?? ?? ?? ?? 0F 85 B6 01 00 00 8B 44 24 30 C7 44 24 1C 00 00 00 00 C7 44 24 18 ?? ?? ?? ?? C7 44 24 10 ?? ?? ?? ?? 89 44 24 14 C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 ?? ?? ?? ?? C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 65 8B 0A 65 83 3D 0C 00 00 00 00 74 01 F0 83 2D ?? ?? ?? ?? 01 0F 85 61 01 00 00 65 89 0A 83 C4 2C C3 }
	condition:
		$1
}

rule file_1391_6_0 {
	meta:
		name = "setservent"
		size = 142
		refs = "0056 __nss_services_lookup2 0062 __nss_setent 0068 __libc_errno"
	strings:
		$1 = { 83 EC 2C 31 C0 B9 01 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 0D ?? ?? ?? ?? 0F 85 B6 01 00 00 8B 44 24 30 C7 44 24 1C 00 00 00 00 C7 44 24 18 ?? ?? ?? ?? C7 44 24 10 ?? ?? ?? ?? 89 44 24 14 C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 ?? ?? ?? ?? C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 65 8B 0A 65 83 3D 0C 00 00 00 00 74 01 F0 83 2D ?? ?? ?? ?? 01 0F 85 61 01 00 00 65 89 0A 83 C4 2C C3 }
	condition:
		$1
}

rule file_369_0_0 {
	meta:
		name = "tmpfile64"
		size = 162
		refs = "0030 __path_search 0054 __gen_tempname 0062 __unlink 0072 _IO_fdopen 009c __close"
	strings:
		$1 = { 56 53 81 EC 24 10 00 00 8D 5C 24 20 C7 44 24 10 00 00 00 00 C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 00 00 00 00 C7 44 24 04 00 10 00 00 89 1C 24 E8 ?? ?? ?? ?? 85 C0 75 50 C7 44 24 0C 00 00 00 00 C7 44 24 08 00 80 00 00 C7 44 24 04 00 00 00 00 89 1C 24 E8 ?? ?? ?? ?? 85 C0 89 C6 78 2A 89 1C 24 E8 ?? ?? ?? ?? C7 44 24 04 ?? ?? ?? ?? 89 34 24 E8 ?? ?? ?? ?? 85 C0 89 C3 74 1C 81 C4 24 10 00 00 89 D8 5B 5E C3 90 31 DB 81 C4 24 10 00 00 89 D8 5B 5E C3 8D 76 00 89 34 24 E8 ?? ?? ?? ?? EB DA }
	condition:
		$1
}

rule file_370_0_0 {
	meta:
		name = "__fcntl_nocancel"
		size = 49
		refs = "0014 _dl_sysinfo 0023 __libc_errno"
	strings:
		$1 = { 53 8B 54 24 10 8B 4C 24 0C 8B 5C 24 08 B8 DD 00 00 00 FF 15 ?? ?? ?? ?? 3D 00 F0 FF FF 77 02 5B C3 8B 15 ?? ?? ?? ?? F7 D8 65 89 02 83 C8 FF 5B C3 }
	condition:
		$1
}

rule file_16_0_3 {
	meta:
		name = "__fcntl_nocancel"
		size = 49
		refs = "0014 _dl_sysinfo 0023 errno"
	strings:
		$1 = { 53 8B 54 24 10 8B 4C 24 0C 8B 5C 24 08 B8 DD 00 00 00 FF 15 ?? ?? ?? ?? 3D 00 F0 FF FF 77 02 5B C3 8B 15 ?? ?? ?? ?? F7 D8 65 89 02 83 C8 FF 5B C3 }
	condition:
		$1
}

rule file_370_1_0 {
	meta:
		name = "__libc_fcntl"
		size = 165
		refs = "0028 _dl_sysinfo 0045 __libc_errno 0066 __libc_enable_asynccancel 008f __libc_disable_asynccancel"
	strings:
		$1 = { 83 EC 1C 89 5C 24 14 8B 54 24 28 89 74 24 18 65 A1 0C 00 00 00 85 C0 75 3A 8B 5C 24 20 8B 4C 24 24 B8 DD 00 00 00 FF 15 ?? ?? ?? ?? 3D 00 F0 FF FF 77 10 89 C3 89 D8 8B 74 24 18 8B 5C 24 14 83 C4 1C C3 8B 15 ?? ?? ?? ?? F7 D8 65 89 02 83 C8 FF EB E0 83 7C 24 24 0E 74 07 83 7C 24 24 07 75 B8 89 54 24 0C E8 ?? ?? ?? ?? 8B 54 24 0C 8B 5C 24 20 8B 4C 24 24 89 C6 B8 DD 00 00 00 FF 15 ?? ?? ?? ?? 3D 00 F0 FF FF 77 0B 89 C3 89 F0 E8 ?? ?? ?? ?? EB A0 8B 15 ?? ?? ?? ?? F7 D8 65 89 02 83 C8 FF EB E5 }
	condition:
		$1
}

rule file_16_1_3 {
	meta:
		name = "__libc_fcntl"
		size = 165
		refs = "0028 _dl_sysinfo 0045 errno 0066 __pthread_enable_asynccancel 008f __pthread_disable_asynccancel"
	strings:
		$1 = { 83 EC 1C 89 5C 24 14 8B 54 24 28 89 74 24 18 65 A1 0C 00 00 00 85 C0 75 3A 8B 5C 24 20 8B 4C 24 24 B8 DD 00 00 00 FF 15 ?? ?? ?? ?? 3D 00 F0 FF FF 77 10 89 C3 89 D8 8B 74 24 18 8B 5C 24 14 83 C4 1C C3 8B 15 ?? ?? ?? ?? F7 D8 65 89 02 83 C8 FF EB E0 83 7C 24 24 0E 74 07 83 7C 24 24 07 75 B8 89 54 24 0C E8 ?? ?? ?? ?? 8B 54 24 0C 8B 5C 24 20 8B 4C 24 24 89 C6 B8 DD 00 00 00 FF 15 ?? ?? ?? ?? 3D 00 F0 FF FF 77 0B 89 C3 89 F0 E8 ?? ?? ?? ?? EB A0 8B 15 ?? ?? ?? ?? F7 D8 65 89 02 83 C8 FF EB E5 }
	condition:
		$1
}

rule file_371_0_0 {
	meta:
		name = "xdr_pmap"
		size = 121
		refs = "001b xdr_u_long"
	strings:
		$1 = { 83 EC 1C 89 5C 24 14 8B 5C 24 20 89 74 24 18 8B 74 24 24 89 1C 24 89 74 24 04 E8 ?? ?? ?? ?? 85 C0 75 15 31 C0 8B 5C 24 14 8B 74 24 18 83 C4 1C C3 8D B4 26 00 00 00 00 8D 46 04 89 44 24 04 89 1C 24 E8 ?? ?? ?? ?? 85 C0 74 D8 8D 46 08 89 44 24 04 89 1C 24 E8 ?? ?? ?? ?? 85 C0 74 C5 83 C6 0C 89 74 24 24 8B 74 24 18 89 5C 24 20 8B 5C 24 14 83 C4 1C E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_372_0_0 {
	meta:
		name = "do_encoding"
		size = 38
	strings:
		$1 = { 8B 44 24 04 8B 50 24 8B 42 34 85 C0 75 12 8B 42 24 3B 42 28 BA 00 00 00 00 0F 45 C2 C3 8D 76 00 B8 FF FF FF FF C3 }
	condition:
		$1
}

rule file_372_3_0 {
	meta:
		name = "do_in"
		size = 174
		refs = "0041 _dl_mcount_wrapper_check"
	strings:
		$1 = { 57 56 53 83 EC 30 8B 44 24 48 8B 5C 24 40 89 44 24 2C 8B 44 24 54 8B 7B 24 89 43 28 8B 44 24 58 89 43 2C 8B 44 24 44 89 43 3C 8B 17 8B 77 14 85 D2 74 0A C1 CE 09 65 33 35 18 00 00 00 89 34 24 E8 ?? ?? ?? ?? 8D 44 24 28 89 44 24 14 8B 44 24 4C C7 44 24 1C 00 00 00 00 C7 44 24 18 00 00 00 00 C7 44 24 10 00 00 00 00 89 44 24 0C 8D 44 24 2C 89 44 24 08 8D 43 28 89 44 24 04 89 3C 24 FF D6 8B 4C 24 2C 8B 54 24 50 89 0A 8B 54 24 5C 8B 4B 28 83 F8 07 89 0A BA 02 00 00 00 77 07 8B 14 85 ?? ?? ?? ?? 83 C4 30 89 D0 5B 5E 5F C3 }
	condition:
		$1
}

rule file_372_4_0 {
	meta:
		name = "do_unshift"
		size = 174
		refs = "0042 _dl_mcount_wrapper_check"
	strings:
		$1 = { 83 EC 3C 89 5C 24 30 8B 44 24 48 8B 5C 24 40 89 74 24 34 89 7C 24 38 89 43 54 8B 44 24 4C 8B 7B 50 89 43 58 8B 44 24 44 89 43 68 8B 0F 8B 77 14 85 C9 74 0A C1 CE 09 65 33 35 18 00 00 00 89 34 24 E8 ?? ?? ?? ?? 8D 44 24 2C 89 44 24 14 8D 43 54 C7 44 24 1C 00 00 00 00 C7 44 24 18 01 00 00 00 C7 44 24 10 00 00 00 00 C7 44 24 0C 00 00 00 00 C7 44 24 08 00 00 00 00 89 44 24 04 89 3C 24 FF D6 8B 54 24 50 8B 4B 54 89 0A BA 02 00 00 00 83 F8 07 77 07 8B 14 85 ?? ?? ?? ?? 89 D0 8B 5C 24 30 8B 74 24 34 8B 7C 24 38 83 C4 3C C3 }
	condition:
		$1
}

rule file_372_5_0 {
	meta:
		name = "do_out"
		size = 174
		refs = "0041 _dl_mcount_wrapper_check"
	strings:
		$1 = { 57 56 53 83 EC 30 8B 44 24 48 8B 5C 24 40 89 44 24 2C 8B 44 24 54 8B 7B 50 89 43 54 8B 44 24 58 89 43 58 8B 44 24 44 89 43 68 8B 07 8B 77 14 85 C0 74 0A C1 CE 09 65 33 35 18 00 00 00 89 34 24 E8 ?? ?? ?? ?? 8D 44 24 28 89 44 24 14 8B 44 24 4C C7 44 24 1C 00 00 00 00 C7 44 24 18 00 00 00 00 C7 44 24 10 00 00 00 00 89 44 24 0C 8D 44 24 2C 89 44 24 08 8D 43 54 89 44 24 04 89 3C 24 FF D6 8B 4C 24 2C 8B 54 24 50 89 0A 8B 54 24 5C 8B 4B 54 83 F8 07 89 0A BA 02 00 00 00 77 07 8B 14 85 ?? ?? ?? ?? 83 C4 30 89 D0 5B 5E 5F C3 }
	condition:
		$1
}

rule file_372_6_0 {
	meta:
		name = "do_length"
		size = 162
		refs = "0055 _dl_mcount_wrapper_check"
	strings:
		$1 = { 55 89 E5 83 EC 48 8B 55 18 8B 45 10 89 5D F4 8B 5D 08 89 75 F8 C1 E2 02 89 45 E0 8D 42 12 83 E0 F0 29 C4 8D 4C 24 20 01 CA 89 7D FC 8B 7B 24 89 53 2C 8B 55 0C 89 4B 28 89 53 3C 8B 07 8B 77 14 85 C0 74 0A C1 CE 09 65 33 35 18 00 00 00 89 34 24 83 C3 28 E8 ?? ?? ?? ?? 8D 55 E4 89 54 24 14 8B 55 14 89 5C 24 04 89 3C 24 C7 44 24 1C 00 00 00 00 89 54 24 0C 8D 55 E0 C7 44 24 18 00 00 00 00 C7 44 24 10 00 00 00 00 89 54 24 08 FF D6 8B 45 E0 2B 45 10 8B 5D F4 8B 75 F8 8B 7D FC 89 EC 5D C3 }
	condition:
		$1
}

rule file_372_7_0 {
	meta:
		name = "_IO_fwide"
		size = 465
		refs = "0072 __wcsmbs_clone_conv 0119 __libio_translit 01a0 __assert_fail"
	strings:
		$1 = { 83 EC 4C 8B 44 24 54 89 5C 24 3C 8B 5C 24 50 89 6C 24 48 89 74 24 40 85 C0 89 7C 24 44 8B 6B 68 0F 88 A2 01 00 00 85 ED 0F 85 3C 01 00 00 85 C0 0F 84 34 01 00 00 8B 73 58 8B 46 04 8D 56 3C 89 53 54 C7 46 2C 00 00 00 00 C7 46 30 00 00 00 00 89 06 8B 46 0C 89 46 10 8B 43 58 C7 40 34 00 00 00 00 C7 40 38 00 00 00 00 8D 44 24 20 89 54 24 1C E8 ?? ?? ?? ?? 8B 54 24 1C 83 7C 24 24 01 0F 85 FB 00 00 00 83 7C 24 2C 01 0F 85 14 01 00 00 89 E8 89 D7 B9 1E 00 00 00 BD 01 00 00 00 F3 AB C7 46 5C 01 00 00 00 C7 46 74 01 00 00 00 8B 44 24 20 C7 46 6C 01 00 00 00 C7 46 40 ?? ?? ?? ?? C7 46 44 ?? ?? ?? ?? 89 46 60 8B 43 58 C7 86 88 00 00 00 01 00 00 00 C7 86 A0 00 00 00 01 00 00 00 C7 86 98 00 00 00 01 00 00 00 83 C0 2C 89 46 78 8B 44 24 28 C7 46 48 ?? ?? ?? ?? C7 46 4C ?? ?? ?? ?? C7 46 50 ?? ?? ?? ?? 89 86 8C 00 00 00 8B 43 58 C7 86 B0 00 00 00 ?? ?? ?? ?? C7 46 54 ?? ?? ?? ?? C7 46 58 ?? ?? ?? ?? 83 C0 2C 89 86 A4 00 00 00 8B 43 58 8B 80 B8 00 00 00 89 83 94 00 00 00 C7 44 24 0C 01 00 00 00 C7 44 24 04 00 00 00 00 C7 44 24 08 00 00 00 00 89 1C 24 FF 50 40 89 43 4C 89 53 50 89 6B 68 89 E8 8B 5C 24 3C 8B 74 24 40 8B 7C 24 44 8B 6C 24 48 83 C4 4C C3 C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 8A 00 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 8B 00 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 ED 75 9E 83 CD FF EB 96 }
	condition:
		$1
}

rule file_373_0_0 {
	meta:
		name = "__ldexpl"
		size = 114
		refs = "0011 __finitel 003c __scalbnl 0063 __libc_errno"
	strings:
		$1 = { 83 EC 2C DB 6C 24 30 D9 C0 DB 3C 24 DB 7C 24 10 E8 ?? ?? ?? ?? 85 C0 DB 6C 24 10 74 0C D9 EE D9 C9 DB E9 DD D9 7A 09 75 07 83 C4 2C C3 8D 76 00 8B 44 24 3C DB 3C 24 89 44 24 0C E8 ?? ?? ?? ?? D9 C0 DB 3C 24 DB 7C 24 10 E8 ?? ?? ?? ?? 85 C0 DB 6C 24 10 74 0C D9 EE D9 C9 DB E9 DD D9 7A C9 75 C7 A1 ?? ?? ?? ?? 65 C7 00 22 00 00 00 83 C4 2C C3 }
	condition:
		$1
}

rule file_84_0_2 {
	meta:
		name = "__ldexpl"
		size = 114
		refs = "0011 __finitel 003c __scalbnl 0063 errno"
	strings:
		$1 = { 83 EC 2C DB 6C 24 30 D9 C0 DB 3C 24 DB 7C 24 10 E8 ?? ?? ?? ?? 85 C0 DB 6C 24 10 74 0C D9 EE D9 C9 DB E9 DD D9 7A 09 75 07 83 C4 2C C3 8D 76 00 8B 44 24 3C DB 3C 24 89 44 24 0C E8 ?? ?? ?? ?? D9 C0 DB 3C 24 DB 7C 24 10 E8 ?? ?? ?? ?? 85 C0 DB 6C 24 10 74 0C D9 EE D9 C9 DB E9 DD D9 7A C9 75 C7 A1 ?? ?? ?? ?? 65 C7 00 22 00 00 00 83 C4 2C C3 }
	condition:
		$1
}

rule file_375_0_0 {
	meta:
		name = "__waitpid"
		size = 99
		refs = "001e _dl_sysinfo 0030 __libc_enable_asynccancel 0052 __libc_disable_asynccancel 002a __syscall_error"
		altNames = "waitpid"
	strings:
		$1 = { 65 83 3D 0C 00 00 00 00 75 25 53 8B 54 24 10 8B 4C 24 0C 8B 5C 24 08 B8 07 00 00 00 FF 15 ?? ?? ?? ?? 5B 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 E8 ?? ?? ?? ?? 50 53 8B 54 24 14 8B 4C 24 10 8B 5C 24 0C B8 07 00 00 00 FF 15 ?? ?? ?? ?? 5B 87 04 24 E8 ?? ?? ?? ?? 58 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_121_0_3 {
	meta:
		name = "__waitpid"
		size = 99
		refs = "001e _dl_sysinfo 0030 __pthread_enable_asynccancel 0052 __pthread_disable_asynccancel 002a __syscall_error"
	strings:
		$1 = { 65 83 3D 0C 00 00 00 00 75 25 53 8B 54 24 10 8B 4C 24 0C 8B 5C 24 08 B8 07 00 00 00 FF 15 ?? ?? ?? ?? 5B 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 E8 ?? ?? ?? ?? 50 53 8B 54 24 14 8B 4C 24 10 8B 5C 24 0C B8 07 00 00 00 FF 15 ?? ?? ?? ?? 5B 87 04 24 E8 ?? ?? ?? ?? 58 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_121_2_3 {
	meta:
		name = "waitpid"
		size = 99
		refs = "001e _dl_sysinfo 0030 __pthread_enable_asynccancel 0052 __pthread_disable_asynccancel 002a __syscall_error"
	strings:
		$1 = { 65 83 3D 0C 00 00 00 00 75 25 53 8B 54 24 10 8B 4C 24 0C 8B 5C 24 08 B8 07 00 00 00 FF 15 ?? ?? ?? ?? 5B 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 E8 ?? ?? ?? ?? 50 53 8B 54 24 14 8B 4C 24 10 8B 5C 24 0C B8 07 00 00 00 FF 15 ?? ?? ?? ?? 5B 87 04 24 E8 ?? ?? ?? ?? 58 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_375_1_0 {
	meta:
		name = "__waitpid_nocancel"
		size = 37
		refs = "0014 _dl_sysinfo 0020 __syscall_error"
	strings:
		$1 = { 53 8B 54 24 10 8B 4C 24 0C 8B 5C 24 08 B8 07 00 00 00 FF 15 ?? ?? ?? ?? 5B 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_376_0_0 {
	meta:
		name = "posix_spawn_file_actions_adddup2"
		size = 156
		refs = "0017 __sysconf 0084 __posix_spawn_file_actions_realloc"
	strings:
		$1 = { 83 EC 1C 89 5C 24 14 8B 5C 24 28 C7 04 24 04 00 00 00 89 74 24 18 E8 ?? ?? ?? ?? 89 DA C1 EA 1F 84 D2 74 14 B8 09 00 00 00 8B 5C 24 14 8B 74 24 18 83 C4 1C C3 8D 76 00 8B 54 24 24 C1 EA 1F 84 D2 75 E1 39 C3 7D DD 39 44 24 24 7D D7 8B 54 24 20 8B 42 04 3B 02 74 28 8B 74 24 20 8D 0C 80 83 C0 01 8B 56 08 8D 14 8A 8B 4C 24 24 C7 02 01 00 00 00 89 5A 08 89 4A 04 89 46 04 31 C0 EB AA 90 89 14 24 E8 ?? ?? ?? ?? 89 C2 B8 0C 00 00 00 85 D2 75 96 8B 4C 24 20 8B 41 04 EB BC }
	condition:
		$1
}

rule file_377_0_0 {
	meta:
		name = "wcschr"
		size = 25
	strings:
		$1 = { 8B 44 24 04 8B 4C 24 08 8B 10 39 CA 74 09 83 C0 04 85 D2 75 F3 31 C0 F3 C3 }
	condition:
		$1
}

rule file_378_0_0 {
	meta:
		name = "clnt_create"
		size = 758
		refs = "0063 strcpy 009d clntunix_create 00d1 __libc_errno 0116 __gethostbyname_r 0132 __rpc_thread_createerr 01bb memcpy 0201 __getprotobyname_r 02b2 clnttcp_create 02ed clntudp_create"
	strings:
		$1 = { 55 B9 05 00 00 00 89 E5 57 BF ?? ?? ?? ?? 56 53 81 EC DC 00 00 00 8B 75 14 F3 A6 0F 85 8F 00 00 00 8D 9D 7A FF FF FF BA 6E 00 00 00 F6 C3 02 89 DF 8D B5 7C FF FF FF 0F 85 15 01 00 00 89 D1 31 C0 C1 E9 02 83 E2 02 F3 AB 0F 85 F9 00 00 00 8B 45 08 89 34 24 66 C7 85 7A FF FF FF 01 00 89 44 24 04 E8 ?? ?? ?? ?? 8D 85 40 FF FF FF 8B 4D 10 89 44 24 0C 8B 45 0C C7 44 24 14 00 00 00 00 C7 44 24 10 00 00 00 00 89 4C 24 08 89 44 24 04 89 1C 24 C7 85 40 FF FF FF FF FF FF FF E8 ?? ?? ?? ?? 8D 65 F4 5B 5E 5F 5D C3 8D B4 26 00 00 00 00 81 EC 10 04 00 00 BB 00 04 00 00 8D 44 24 27 83 E0 F0 8D BD 44 FF FF FF 8D B5 38 FF FF FF EB 25 A1 ?? ?? ?? ?? 65 83 38 22 75 56 01 DB B9 10 00 00 00 8D 43 1E 31 D2 F7 F1 C1 E0 04 29 C4 8D 44 24 27 83 E0 F0 8B 4D 08 89 44 24 08 8D 85 64 FF FF FF 89 7C 24 14 89 74 24 10 89 5C 24 0C 89 44 24 04 89 0C 24 E8 ?? ?? ?? ?? 85 C0 75 0A 8B 85 38 FF FF FF 85 C0 75 38 83 BD 44 FF FF FF FF 74 9F E8 ?? ?? ?? ?? C7 00 0D 00 00 00 8D 65 F4 31 C0 5B 5E 5F 5D C3 66 90 66 C7 07 00 00 E9 FD FE FF FF 89 F7 B2 6C E9 E2 FE FF FF 90 8D 74 26 00 83 78 08 02 0F 85 CD 00 00 00 C7 85 60 FF FF FF 00 00 00 00 8B 48 10 8D 95 58 FF FF FF C7 85 5C FF FF FF 00 00 00 00 8B 40 0C BB 00 04 00 00 66 C7 85 54 FF FF FF 02 00 8D BD 3C FF FF FF 66 C7 85 56 FF FF FF 00 00 8D B5 48 FF FF FF 8B 09 89 44 24 08 89 14 24 89 4C 24 04 E8 ?? ?? ?? ?? 81 EC 10 04 00 00 8D 44 24 27 83 E0 F0 EB 1C 66 90 01 DB B9 10 00 00 00 8D 43 1E 31 D2 F7 F1 C1 E0 04 29 C4 8D 44 24 27 83 E0 F0 89 44 24 08 8B 45 14 89 7C 24 10 89 5C 24 0C 89 74 24 04 89 04 24 E8 ?? ?? ?? ?? 85 C0 75 0A 8B 85 3C FF FF FF 85 C0 75 3D A1 ?? ?? ?? ?? 65 83 38 22 74 B2 E8 ?? ?? ?? ?? C7 00 11 00 00 00 C7 40 08 60 00 00 00 31 C0 E9 6A FE FF FF E8 ?? ?? ?? ?? C7 00 0C 00 00 00 C7 40 08 61 00 00 00 31 C0 E9 51 FE FF FF 8B 40 08 C7 85 40 FF FF FF FF FF FF FF 83 F8 06 74 1E 83 F8 11 74 54 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 C7 40 08 60 00 00 00 31 C0 E9 21 FE FF FF 8D 85 40 FF FF FF 8B 4D 10 89 44 24 0C 8B 45 0C C7 44 24 14 00 00 00 00 C7 44 24 10 00 00 00 00 89 4C 24 08 89 44 24 04 8D 85 54 FF FF FF 89 04 24 E8 ?? ?? ?? ?? E9 E6 FD FF FF 8D 85 40 FF FF FF 8B 4D 10 89 44 24 14 8B 45 0C C7 44 24 0C 05 00 00 00 C7 44 24 10 00 00 00 00 89 4C 24 08 89 44 24 04 8D 85 54 FF FF FF 89 04 24 E8 ?? ?? ?? ?? E9 AB FD FF FF }
	condition:
		$1
}

rule file_379_0_0 {
	meta:
		name = "__statvfs_getflags"
		size = 1610
		refs = "00d8 __setmntent 011c __getmntent_r 0138 strcmp 01b0 __xstat64 0209 strchr 0243 __endmntent 03e3 rewind 0646 __assert_fail"
	strings:
		$1 = { 55 57 56 53 81 EC AC 04 00 00 8B 8C 24 C8 04 00 00 8B 9C 24 C0 04 00 00 8B 84 24 C4 04 00 00 85 C9 0F 84 CF 02 00 00 3D A0 9F 00 00 0F 84 24 05 00 00 7E 4C 3D D0 0B D0 0B 0F 84 FD 04 00 00 90 0F 8E 0E 02 00 00 3D 4E 54 46 53 0F 84 83 04 00 00 0F 8E 28 03 00 00 3D 42 53 46 58 0F 84 90 05 00 00 3D 72 65 65 62 75 48 C7 44 24 1C 00 00 00 00 BE ?? ?? ?? ?? C7 44 24 18 00 00 00 00 EB 48 3D 73 13 00 00 0F 84 97 04 00 00 0F 8E 04 02 00 00 3D 44 4D 00 00 0F 84 EE 04 00 00 8D 74 26 00 0F 8F 5F 02 00 00 3D D1 1C 00 00 0F 84 BF 04 00 00 C7 44 24 1C 00 00 00 00 31 F6 C7 44 24 18 00 00 00 00 90 8D 74 26 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 89 44 24 14 0F 84 EE 01 00 00 8B 44 24 14 8D AC 24 A0 00 00 00 81 08 00 80 00 00 8D B4 26 00 00 00 00 8D 44 24 28 89 44 24 04 8B 44 24 14 C7 44 24 0C 00 04 00 00 89 6C 24 08 89 04 24 E8 ?? ?? ?? ?? 85 C0 0F 84 A0 02 00 00 85 DB 74 14 8B 44 24 2C 89 1C 24 89 44 24 04 E8 ?? ?? ?? ?? 85 C0 75 C0 85 F6 74 54 8B 7C 24 30 89 34 24 89 7C 24 04 E8 ?? ?? ?? ?? 85 C0 74 40 8B 54 24 18 85 D2 74 14 8B 54 24 18 89 7C 24 04 89 14 24 E8 ?? ?? ?? ?? 85 C0 74 24 8B 44 24 1C 85 C0 74 84 8B 4C 24 1C 89 7C 24 04 89 0C 24 E8 ?? ?? ?? ?? 85 C0 0F 85 6C FF FF FF 8D 74 26 00 8D 44 24 40 89 44 24 08 8B 44 24 2C C7 04 24 03 00 00 00 89 44 24 04 E8 ?? ?? ?? ?? 85 C0 0F 88 44 FF FF FF 8B 94 24 C8 04 00 00 8B 02 8B 52 04 33 54 24 44 33 44 24 40 09 C2 0F 85 28 FF FF FF 8B 5C 24 34 31 ED 85 DB 75 1B EB 57 8D 74 26 00 80 7B 01 6F 75 32 80 7B 02 00 75 2C 83 CD 01 85 C0 74 40 89 C3 C7 44 24 04 2C 00 00 00 89 1C 24 E8 ?? ?? ?? ?? 85 C0 0F 84 DB 01 00 00 C6 00 00 83 C0 01 80 3B 72 74 C8 BF ?? ?? ?? ?? 89 DE B9 07 00 00 00 F3 A6 0F 85 7C 01 00 00 83 CD 02 85 C0 75 C0 8B 44 24 14 89 04 24 E8 ?? ?? ?? ?? 81 C4 AC 04 00 00 89 E8 5B 5E 5F 5D C3 3D 53 EF 00 00 0F 84 A9 02 00 00 0F 8E F5 00 00 00 3D EB E0 27 00 0F 84 68 03 00 00 3D 94 19 02 01 0F 85 36 FE FF FF C7 44 24 1C 00 00 00 00 BE ?? ?? ?? ?? C7 44 24 18 00 00 00 00 E9 33 FE FF FF 3D 68 81 7E C9 0F 84 1E 03 00 00 0F 8E 8F 00 00 00 3D 49 E8 95 F9 0F 84 F3 02 00 00 3D 87 01 00 00 0F 85 F5 FD FF FF C7 44 24 1C 00 00 00 00 BE ?? ?? ?? ?? C7 44 24 18 00 00 00 00 E9 F2 FD FF FF C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 89 44 24 14 0F 85 F2 FD FF FF 81 C4 AC 04 00 00 31 ED 5B 89 E8 5E 5F 5D C3 3D 69 69 00 00 0F 84 DE 01 00 00 3D 60 96 00 00 0F 85 96 FD FF FF C7 44 24 1C 00 00 00 00 BE ?? ?? ?? ?? C7 44 24 18 00 00 00 00 E9 93 FD FF FF 3D 3E 68 23 91 0F 85 71 FD FF FF C7 44 24 1C 00 00 00 00 BE ?? ?? ?? ?? C7 44 24 18 00 00 00 00 E9 6E FD FF FF 3D A2 9F 00 00 0F 85 4C FD FF FF C7 44 24 1C 00 00 00 00 BE ?? ?? ?? ?? C7 44 24 18 00 00 00 00 E9 49 FD FF FF 3D 4A 46 53 31 0F 84 82 02 00 00 3D 73 49 65 52 0F 85 1C FD FF FF C7 44 24 1C 00 00 00 00 BE ?? ?? ?? ?? C7 44 24 18 00 00 00 00 E9 19 FD FF FF 90 BF ?? ?? ?? ?? 89 DE B9 07 00 00 00 F3 A6 75 38 83 CD 08 E9 2F FE FF FF 85 DB 0F 95 C0 85 F6 0F 84 C1 00 00 00 84 C0 74 37 8B 44 24 14 31 DB 89 04 24 E8 ?? ?? ?? ?? E9 14 FD FF FF 8D 74 26 00 31 C0 E9 24 FE FF FF 90 BF ?? ?? ?? ?? 89 DE B9 06 00 00 00 F3 A6 75 28 83 CD 04 E9 E7 FD FF FF 85 F6 0F 84 0E 02 00 00 C7 44 24 1C 00 00 00 00 31 F6 C7 44 24 18 00 00 00 00 EB AD 8D 74 26 00 BF ?? ?? ?? ?? B9 05 00 00 00 89 DE F3 A6 75 08 83 CD 10 E9 AF FD FF FF BF ?? ?? ?? ?? B9 05 00 00 00 89 DE F3 A6 75 08 83 CD 40 E9 97 FD FF FF BF ?? ?? ?? ?? B9 08 00 00 00 89 DE F3 A6 75 0B 81 CD 00 04 00 00 E9 7C FD FF FF BF ?? ?? ?? ?? B9 0B 00 00 00 89 DE F3 A6 75 26 81 CD 00 08 00 00 E9 61 FD FF FF 84 C0 0F 85 3B FF FF FF 8B 44 24 14 31 ED 89 04 24 E8 ?? ?? ?? ?? E9 96 FD FF FF B9 09 00 00 00 89 DE BF ?? ?? ?? ?? 89 EA F3 A6 0F 97 C3 0F 92 C1 80 CE 10 38 CB 0F 44 EA E9 23 FD FF FF C7 44 24 1C 00 00 00 00 BE ?? ?? ?? ?? C7 44 24 18 00 00 00 00 E9 DA FB FF FF C7 44 24 1C 00 00 00 00 BE ?? ?? ?? ?? C7 44 24 18 00 00 00 00 E9 C0 FB FF FF C7 44 24 1C ?? ?? ?? ?? BE ?? ?? ?? ?? C7 44 24 18 ?? ?? ?? ?? E9 A6 FB FF FF C7 44 24 1C 00 00 00 00 BE ?? ?? ?? ?? C7 44 24 18 00 00 00 00 E9 8C FB FF FF C7 44 24 1C 00 00 00 00 BE ?? ?? ?? ?? C7 44 24 18 00 00 00 00 E9 72 FB FF FF C7 44 24 1C 00 00 00 00 BE ?? ?? ?? ?? C7 44 24 18 00 00 00 00 E9 58 FB FF FF C7 44 24 1C 00 00 00 00 BE ?? ?? ?? ?? C7 44 24 18 00 00 00 00 E9 3E FB FF FF C7 44 24 1C 00 00 00 00 BE ?? ?? ?? ?? C7 44 24 18 00 00 00 00 E9 24 FB FF FF C7 44 24 1C 00 00 00 00 BE ?? ?? ?? ?? C7 44 24 18 00 00 00 00 E9 0A FB FF FF C7 44 24 1C 00 00 00 00 BE ?? ?? ?? ?? C7 44 24 18 00 00 00 00 E9 F0 FA FF FF C7 44 24 1C 00 00 00 00 BE ?? ?? ?? ?? C7 44 24 18 00 00 00 00 E9 D6 FA FF FF C7 44 24 1C 00 00 00 00 BE ?? ?? ?? ?? C7 44 24 18 00 00 00 00 E9 BC FA FF FF C7 44 24 1C 00 00 00 00 BE ?? ?? ?? ?? C7 44 24 18 00 00 00 00 E9 A2 FA FF FF C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 C7 00 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_379_1_0 {
	meta:
		name = "__internal_statvfs"
		size = 264
		refs = "00ce __statvfs_getflags"
	strings:
		$1 = { 57 56 BE 18 00 00 00 53 83 EC 10 8B 44 24 28 8B 5C 24 24 8B 48 28 8B 50 04 85 C9 89 13 0F 45 D1 89 53 04 8B 50 08 8D 4B 30 F6 C1 01 89 53 08 8B 50 0C 89 53 0C 8B 50 10 89 53 10 8B 50 14 89 53 14 8B 50 18 89 53 18 8B 50 1C C7 43 24 00 00 00 00 89 53 20 8B 50 24 89 53 2C 0F 85 80 00 00 00 F6 C1 02 0F 85 8F 00 00 00 89 F7 31 D2 83 E7 FC C7 04 11 00 00 00 00 83 C2 04 39 FA 72 F2 01 D1 F7 C6 02 00 00 00 74 08 66 C7 01 00 00 83 C1 02 83 E6 01 74 03 C6 01 00 8B 53 18 89 53 1C 8B 50 2C F6 C2 20 74 12 89 D0 83 F0 20 89 43 28 83 C4 10 5B 5E 5F C3 8D 76 00 8B 54 24 2C 89 54 24 08 8B 00 89 44 24 04 8B 44 24 20 89 04 24 E8 ?? ?? ?? ?? 89 43 28 83 C4 10 5B 5E 5F C3 8D 74 26 00 8D 4B 31 66 BE 17 00 F6 C1 02 C6 43 30 00 0F 84 75 FF FF FF 8D 74 26 00 66 C7 01 00 00 83 EE 02 83 C1 02 E9 61 FF FF FF }
	condition:
		$1
}

rule file_380_0_0 {
	meta:
		name = "ftok"
		size = 79
		refs = "001e __xstat64"
	strings:
		$1 = { 83 EC 7C 8D 44 24 10 89 44 24 08 8B 84 24 80 00 00 00 C7 04 24 03 00 00 00 89 44 24 04 E8 ?? ?? ?? ?? 85 C0 78 22 0F B6 44 24 10 0F B7 54 24 68 C1 E0 10 09 D0 8B 94 24 84 00 00 00 C1 E2 18 09 D0 83 C4 7C C3 8D 76 00 B8 FF FF FF FF EB F2 }
	condition:
		$1
}

rule file_381_1_0 {
	meta:
		name = "__funlockfile"
		size = 38
	strings:
		$1 = { 8B 44 24 04 8B 50 48 83 6A 04 01 75 17 C7 42 08 00 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 83 2A 01 75 02 F3 C3 }
	condition:
		$1
}

rule file_382_0_0 {
	meta:
		name = "call_dl_lookup"
		size = 84
		refs = "003f _dl_lookup_symbol_x"
	strings:
		$1 = { 83 EC 2C 89 5C 24 24 8B 5C 24 30 89 74 24 28 8B 13 8B 4B 14 8B 43 04 C7 44 24 10 00 00 00 00 8B 73 0C C7 44 24 08 00 00 00 00 89 74 24 0C 8B 73 08 89 74 24 04 8B B2 CC 01 00 00 89 34 24 E8 ?? ?? ?? ?? 83 EC 14 89 03 8B 74 24 28 8B 5C 24 24 83 C4 2C C3 }
	condition:
		$1
}

rule file_382_1_0 {
	meta:
		name = "do_sym"
		size = 788
		refs = "000e _dl_nns 0014 _dl_ns 005a _dl_addr_inside_object 00c8 _dl_lookup_symbol_x 0214 _dl_catch_error 024a _dl_sysinfo 0294 _dl_signal_error 029c strlen 02be memcpy 02fe free"
	strings:
		$1 = { 55 89 E5 57 89 CF 56 89 C6 53 83 EC 6C A1 ?? ?? ?? ?? 8B 1D ?? ?? ?? ?? 89 55 B0 C7 45 C4 00 00 00 00 85 C0 89 5D B4 74 62 31 C0 89 75 AC 89 C6 85 DB 74 39 8D 74 26 00 3B BB AC 01 00 00 72 26 3B BB B0 01 00 00 73 1E F6 83 95 01 00 00 40 0F 85 B3 00 00 00 89 FA 89 D8 E8 ?? ?? ?? ?? 85 C0 0F 85 A2 00 00 00 8B 5B 0C 85 DB 75 CB 83 C6 01 3B 35 ?? ?? ?? ?? 73 10 6B C6 4C 8B 98 ?? ?? ?? ?? EB AD 90 8D 74 26 00 8B 75 AC 85 F6 0F 84 DE 00 00 00 83 FE FF 74 78 8B 45 08 8D 4D C4 8B 55 0C C7 44 24 10 00 00 00 00 C7 44 24 08 00 00 00 00 89 44 24 04 8D 86 D0 01 00 00 89 04 24 8B 45 B0 89 54 24 0C 89 F2 E8 ?? ?? ?? ?? 83 EC 14 8B 55 C4 85 D2 0F 84 E8 00 00 00 85 C0 0F 84 D9 00 00 00 8B 00 03 42 04 0F B6 52 0C 83 E2 0F 80 FA 0A 0F 84 66 01 00 00 8D 65 F4 5B 5E 5F 5D C2 08 00 8D B4 26 00 00 00 00 89 5D B4 E9 5D FF FF FF 8B 55 B4 3B 15 ?? ?? ?? ?? 0F 84 46 01 00 00 8B 55 B4 EB 06 8D 74 26 00 89 C2 8B 82 6C 01 00 00 85 C0 75 F4 8B 45 B4 81 C2 D0 01 00 00 89 14 24 8B 55 B4 8D 4D C4 C7 44 24 0C 00 00 00 00 C7 44 24 08 00 00 00 00 89 44 24 10 8B 45 08 89 44 24 04 8B 45 B0 E8 ?? ?? ?? ?? 83 EC 14 E9 5E FF FF FF 65 A1 0C 00 00 00 85 C0 75 4E 8B 45 0C 8D 4D C4 8B 55 B4 C7 44 24 10 00 00 00 00 C7 44 24 08 00 00 00 00 83 C8 01 89 44 24 0C 8B 45 08 89 44 24 04 8B 82 CC 01 00 00 89 04 24 8B 45 B0 E8 ?? ?? ?? ?? 83 EC 14 E9 14 FF FF FF 31 C0 E9 22 FF FF FF 31 C0 E9 2E FF FF FF 8B 45 08 8B 55 B0 89 45 D8 8B 45 0C 89 55 D4 8B 55 B4 83 C8 05 89 45 DC 8D 45 C4 89 55 D0 89 45 E4 65 C7 05 1C 00 00 00 01 00 00 00 8D 45 D0 89 44 24 04 8D 4D C3 8D 55 CC 8D 45 C8 C7 04 24 ?? ?? ?? ?? C7 45 CC 00 00 00 00 E8 ?? ?? ?? ?? 83 EC 08 89 45 B4 65 87 35 1C 00 00 00 83 FE 02 75 24 BA 01 00 00 00 65 8B 1D 08 00 00 00 65 8B 0D 20 00 00 00 B8 F0 00 00 00 83 C3 1C 83 C9 01 FF 15 ?? ?? ?? ?? 8B 5D CC 85 DB 75 43 8B 45 D0 E9 72 FE FF FF FF D0 90 E9 92 FE FF FF 85 D2 89 F6 8D BC 27 00 00 00 00 74 14 3B BA AC 01 00 00 72 0C 3B BA B0 01 00 00 0F 82 99 FE FF FF C7 04 24 ?? ?? ?? ?? 31 C9 31 D2 31 C0 E8 ?? ?? ?? ?? 89 1C 24 E8 ?? ?? ?? ?? 8D 50 01 83 C0 1F 83 E0 F0 29 C4 8D 44 24 23 83 E0 F0 89 54 24 08 89 5C 24 04 89 04 24 E8 ?? ?? ?? ?? 8B 7D C8 89 3C 24 89 C6 E8 ?? ?? ?? ?? 8D 48 01 83 C0 1F 83 E0 F0 29 C4 8D 44 24 23 83 E0 F0 89 4C 24 08 89 7C 24 04 89 04 24 E8 ?? ?? ?? ?? 80 7D C3 00 74 0E 89 1C 24 89 45 A8 E8 ?? ?? ?? ?? 8B 45 A8 89 C2 8B 45 B4 31 C9 89 34 24 E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_382_2_0 {
	meta:
		name = "_dl_vsym"
		size = 180
	strings:
		$1 = { 83 EC 2C 89 5C 24 20 31 DB 89 74 24 24 89 CE 89 7C 24 28 89 4C 24 10 C7 44 24 18 01 00 00 00 0F B6 0E 85 C9 74 55 89 CB 0F B6 4E 01 E3 4D C1 E3 04 01 CB 0F B6 4E 02 E3 42 C1 E3 04 01 CB 0F B6 4E 03 E3 37 C1 E3 04 01 CB 0F B6 4E 04 E3 2C C1 E3 04 83 C6 05 01 CB 0F B6 0E E3 1F C1 E3 04 BF 00 00 00 F0 46 01 CB 21 DF 81 E3 FF FF FF 0F C1 EF 18 0F B6 0E 31 FB 85 C9 75 E1 8D 4C 24 10 89 0C 24 8B 4C 24 30 C7 44 24 04 00 00 00 00 89 5C 24 14 C7 44 24 1C 00 00 00 00 E8 41 FC FF FF 83 EC 08 8B 5C 24 20 8B 74 24 24 8B 7C 24 28 83 C4 2C C2 04 00 }
	condition:
		$1
}

rule file_382_3_0 {
	meta:
		name = "_dl_sym"
		size = 30
	strings:
		$1 = { 83 EC 1C C7 44 24 04 02 00 00 00 C7 04 24 00 00 00 00 E8 09 FC FF FF 83 EC 08 83 C4 1C C3 }
	condition:
		$1
}

rule file_383_0_0 {
	meta:
		name = "__libc_poll"
		size = 99
		refs = "001e _dl_sysinfo 0030 __libc_enable_asynccancel 0052 __libc_disable_asynccancel 002a __syscall_error"
		altNames = "__poll"
	strings:
		$1 = { 65 83 3D 0C 00 00 00 00 75 25 53 8B 54 24 10 8B 4C 24 0C 8B 5C 24 08 B8 A8 00 00 00 FF 15 ?? ?? ?? ?? 5B 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 E8 ?? ?? ?? ?? 50 53 8B 54 24 14 8B 4C 24 10 8B 5C 24 0C B8 A8 00 00 00 FF 15 ?? ?? ?? ?? 5B 87 04 24 E8 ?? ?? ?? ?? 58 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_383_1_0 {
	meta:
		name = "__poll_nocancel"
		size = 37
		refs = "0014 _dl_sysinfo 0020 __syscall_error"
	strings:
		$1 = { 53 8B 54 24 10 8B 4C 24 0C 8B 5C 24 08 B8 A8 00 00 00 FF 15 ?? ?? ?? ?? 5B 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_384_0_0 {
	meta:
		name = "_openchild"
		size = 383
		refs = "000c __pipe 002d __fork 004c __close 0058 __dup 0075 stderr 007d _IO_fflush 0082 _rpc_dtablesize 00c1 execlp 00cd perror 00d9 _exit 00f0 _IO_fdopen"
	strings:
		$1 = { 53 83 EC 28 8D 44 24 10 89 04 24 E8 ?? ?? ?? ?? 85 C0 0F 88 60 01 00 00 8D 44 24 18 89 04 24 E8 ?? ?? ?? ?? 85 C0 0F 88 24 01 00 00 E8 ?? ?? ?? ?? 83 F8 FF 89 C3 0F 84 FC 00 00 00 85 C0 0F 85 9C 00 00 00 C7 04 24 00 00 00 00 E8 ?? ?? ?? ?? 8B 44 24 10 89 04 24 E8 ?? ?? ?? ?? C7 04 24 01 00 00 00 E8 ?? ?? ?? ?? 8B 44 24 1C 89 04 24 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 58 FF 83 FB 02 7E 12 66 90 89 1C 24 83 EB 01 E8 ?? ?? ?? ?? 83 FB 02 75 F0 A1 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 8B 44 24 30 C7 44 24 08 00 00 00 00 89 44 24 04 89 04 24 E8 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 04 24 FF FF FF FF E8 ?? ?? ?? ?? 8D 76 00 8B 44 24 14 C7 44 24 04 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 8B 54 24 34 89 02 8B 44 24 10 89 04 24 E8 ?? ?? ?? ?? 8B 44 24 18 C7 44 24 04 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 8B 54 24 38 89 02 8B 44 24 1C 89 04 24 E8 ?? ?? ?? ?? 83 C4 28 89 D8 5B C3 90 8D 74 26 00 8B 44 24 18 89 04 24 E8 ?? ?? ?? ?? 8B 44 24 1C 89 04 24 E8 ?? ?? ?? ?? 8B 44 24 10 BB FF FF FF FF 89 04 24 E8 ?? ?? ?? ?? 8B 44 24 14 89 04 24 E8 ?? ?? ?? ?? 83 C4 28 89 D8 5B C3 8D 74 26 00 BB FF FF FF FF EB AD }
	condition:
		$1
}

rule file_385_0_0 {
	meta:
		name = "strrchr"
		size = 441
	strings:
		$1 = { 57 56 31 C0 8B 74 24 0C 8B 4C 24 10 88 CD 89 CA C1 E1 10 66 89 D1 F7 C6 03 00 00 00 0F 84 81 00 00 00 8A 16 38 D1 75 02 89 F0 08 D2 0F 84 84 01 00 00 46 F7 C6 03 00 00 00 74 68 8A 16 38 D1 75 02 89 F0 08 D2 0F 84 6B 01 00 00 46 F7 C6 03 00 00 00 74 4F 8A 16 38 D1 75 02 89 F0 08 D2 0F 84 52 01 00 00 46 EB 3C 00 00 00 83 EE 04 83 EE 04 83 EE 04 F7 C2 00 00 00 FF 75 0E 8D 46 0F EB 20 83 EE 04 83 EE 04 83 EE 04 F7 C2 00 00 FF 00 75 05 8D 46 0E EB 0A 8D 46 0C 84 F6 75 03 8D 46 0D 83 C6 10 8B 16 BF FF FE FE FE 01 D7 0F 83 DA 00 00 00 31 D7 81 CF FF FE FE FE 47 0F 85 CB 00 00 00 31 CA BF FF FE FE FE 01 D7 73 9E 31 D7 81 CF FF FE FE FE 47 75 A9 8B 56 04 BF FF FE FE FE 01 D7 0F 83 A2 00 00 00 31 D7 81 CF FF FE FE FE 47 0F 85 93 00 00 00 31 CA BF FF FE FE FE 01 D7 0F 83 68 FF FF FF 31 D7 81 CF FF FE FE FE 47 0F 85 6F FF FF FF 8B 56 08 BF FF FE FE FE 01 D7 73 66 31 D7 81 CF FF FE FE FE 47 75 5B 31 CA BF FF FE FE FE 01 D7 0F 83 36 FF FF FF 31 D7 81 CF FF FE FE FE 47 0F 85 3D FF FF FF 8B 56 0C BF FF FE FE FE 01 D7 73 2E 31 D7 81 CF FF FE FE FE 47 75 23 31 CA BF FF FE FE FE 01 D7 0F 83 04 FF FF FF 31 D7 81 CF FF FE FE FE 47 0F 84 22 FF FF FF E9 06 FF FF FF 83 C6 04 83 C6 04 83 C6 04 38 CA 75 02 89 F0 84 D2 74 20 38 CE 75 03 8D 46 01 84 F6 74 15 C1 EA 10 38 CA 75 03 8D 46 02 84 D2 74 07 38 CE 75 03 8D 46 03 5E 5F C3 }
	condition:
		$1
}

rule file_386_0_0 {
	meta:
		name = "__gettext_extract_plural"
		size = 226
		refs = "002d strstr 0057 __libc_tsd_CTYPE_B 0090 strtoul 00ab __gettextparse 00bb __gettext_germanic_plural"
	strings:
		$1 = { 83 EC 3C 85 C0 89 74 24 30 89 CE 89 6C 24 38 89 D5 89 5C 24 2C 89 7C 24 34 0F 84 99 00 00 00 C7 44 24 04 ?? ?? ?? ?? 89 C3 89 04 24 E8 ?? ?? ?? ?? C7 44 24 04 ?? ?? ?? ?? 89 1C 24 89 C7 E8 ?? ?? ?? ?? 85 C0 74 71 85 FF 74 6D 0F B6 50 09 8D 58 09 84 D2 74 62 A1 ?? ?? ?? ?? 65 8B 00 EB 0A 83 C3 01 0F B6 13 84 D2 74 4E 0F B6 CA F6 44 48 01 20 75 EC 83 EA 30 80 FA 09 77 3C 8D 44 24 14 C7 44 24 08 0A 00 00 00 89 44 24 04 89 1C 24 E8 ?? ?? ?? ?? 3B 5C 24 14 74 1E 89 06 8D 44 24 18 83 C7 07 89 04 24 89 7C 24 18 E8 ?? ?? ?? ?? 85 C0 74 26 90 8D 74 26 00 C7 45 00 ?? ?? ?? ?? C7 06 02 00 00 00 8B 5C 24 2C 8B 74 24 30 8B 7C 24 34 8B 6C 24 38 83 C4 3C C3 8B 44 24 1C 89 45 00 EB E3 }
	condition:
		$1
}

rule file_387_0_0 {
	meta:
		name = "basename"
		size = 39
		refs = "0014 strrchr"
	strings:
		$1 = { 53 83 EC 18 8B 5C 24 20 C7 44 24 04 2F 00 00 00 89 1C 24 E8 ?? ?? ?? ?? 85 C0 8D 50 01 0F 45 DA 83 C4 18 89 D8 5B C3 }
	condition:
		$1
}

rule file_390_0_0 {
	meta:
		name = "__copysignf"
		size = 30
	strings:
		$1 = { 8B 54 24 08 8B 44 24 04 81 E2 00 00 00 80 25 FF FF FF 7F 09 D0 89 44 24 04 D9 44 24 04 C3 }
	condition:
		$1
}

rule file_391_0_0 {
	meta:
		name = "__gai_sigqueue"
		size = 156
		refs = "0043 __getuid 005e _dl_sysinfo 008e __libc_errno"
	strings:
		$1 = { 81 EC 9C 00 00 00 89 9C 24 8C 00 00 00 89 D3 89 CA 89 BC 24 94 00 00 00 B9 20 00 00 00 89 E7 89 AC 24 98 00 00 00 89 C5 31 C0 89 B4 24 90 00 00 00 F3 AB 89 54 24 0C 89 2C 24 C7 44 24 08 C4 FF FF FF E8 ?? ?? ?? ?? 89 E9 89 E2 89 5C 24 14 8B 5C 24 0C 89 44 24 10 B8 B2 00 00 00 FF 15 ?? ?? ?? ?? 3D 00 F0 FF FF 77 23 8B 9C 24 8C 00 00 00 8B B4 24 90 00 00 00 8B BC 24 94 00 00 00 8B AC 24 98 00 00 00 81 C4 9C 00 00 00 C3 8B 15 ?? ?? ?? ?? F7 D8 65 89 02 83 C8 FF EB CD }
	condition:
		$1
}

rule file_392_0_0 {
	meta:
		name = "____wcstoll_l_internal"
		size = 1444
		refs = "0066 __iswspace_l 00c2 __strtol_ull_max_tab 00cb __strtol_ull_rem_tab 00dd __strtol_ul_max_tab 01ae __libc_errno 0223 __iswalpha_l 0246 __towupper_l 058a __correctly_grouped_prefixwc"
	strings:
		$1 = { 55 57 56 53 83 EC 5C 8B 54 24 7C 8B 8C 24 80 00 00 00 8B 7C 24 78 85 D2 8B 41 04 0F 85 89 04 00 00 31 DB C7 44 24 28 00 00 00 00 83 FF 01 0F 84 8C 01 00 00 89 F8 C1 E8 1F 84 C0 0F 85 7F 01 00 00 83 FF 24 0F 8F 76 01 00 00 8B 6C 24 70 8B B4 24 80 00 00 00 EB 04 90 83 C5 04 89 74 24 04 8B 45 00 89 04 24 E8 ?? ?? ?? ?? 85 C0 75 EA 8B 75 00 89 E8 85 F6 0F 84 82 03 00 00 83 FE 2D 0F 84 04 02 00 00 83 FE 2B C7 44 24 44 00 00 00 00 0F 84 6B 01 00 00 83 FE 30 0F 84 01 02 00 00 85 FF 0F 84 32 01 00 00 83 FF 0A 0F 84 29 01 00 00 8D 47 FE C6 44 24 2F 00 C7 44 24 30 00 00 00 00 8B 0C C5 ?? ?? ?? ?? 85 F6 0F B6 90 ?? ?? ?? ?? 89 4C 24 40 8B 0C C5 ?? ?? ?? ?? 8B 04 85 ?? ?? ?? ?? 88 54 24 3C 89 4C 24 38 89 44 24 20 0F 84 A3 03 00 00 39 6C 24 30 89 EB 0F 84 8E 03 00 00 31 D2 89 6C 24 34 89 D5 89 FA 8B 7C 24 30 EB 23 90 3B 74 24 28 0F 85 F6 00 00 00 80 7C 24 2F 00 0F 84 EB 00 00 00 83 C3 04 8B 33 85 F6 74 28 39 DF 74 24 8D 46 D0 83 F8 09 77 D6 39 D0 7D 18 3B 6C 24 20 0F 83 A0 01 00 00 83 C3 04 8B 33 0F AF EA 01 C5 85 F6 75 D8 89 EA 8B 6C 24 34 89 D0 31 D2 C7 44 24 34 00 00 00 00 39 DD 0F 84 98 02 00 00 8B 6C 24 74 85 ED 74 06 8B 4C 24 74 89 19 8B 7C 24 34 85 FF 0F 85 CE 00 00 00 8B 74 24 44 85 F6 0F 84 59 03 00 00 81 FA 00 00 00 80 77 0F 0F 82 34 03 00 00 83 F8 00 0F 86 2B 03 00 00 A1 ?? ?? ?? ?? 65 C7 00 22 00 00 00 E9 BC 00 00 00 66 90 A1 ?? ?? ?? ?? 31 D2 65 C7 00 16 00 00 00 31 C0 83 C4 5C 5B 5E 5F 5D C3 85 DB 0F 85 34 03 00 00 B8 08 00 00 00 BF 0A 00 00 00 C6 44 24 2F 00 C7 44 24 30 00 00 00 00 E9 C3 FE FF FF 8D 74 26 00 83 C5 04 8B 70 04 E9 8A FE FF FF 90 8D 74 26 00 8B 8C 24 80 00 00 00 89 34 24 89 54 24 1C 89 4C 24 04 E8 ?? ?? ?? ?? 8B 54 24 1C 85 C0 0F 84 23 FF FF FF 8B 8C 24 80 00 00 00 89 34 24 89 54 24 1C 89 4C 24 04 E8 ?? ?? ?? ?? 8B 54 24 1C 83 E8 37 E9 E4 FE FF FF 66 90 8B 4C 24 44 BA FF FF FF 7F A1 ?? ?? ?? ?? 85 C9 65 C7 00 22 00 00 00 B8 FF FF FF FF 0F 84 56 FF FF FF 31 C0 BA 00 00 00 80 E9 4A FF FF FF 66 90 8B 70 04 83 C5 04 C7 44 24 44 01 00 00 00 83 FE 30 0F 85 FF FD FF FF F7 C7 EF FF FF FF 0F 85 FB FD FF FF 8B B4 24 80 00 00 00 89 74 24 04 8B 45 04 89 04 24 E8 ?? ?? ?? ?? 83 F8 58 0F 84 B4 01 00 00 85 FF 0F 85 15 02 00 00 B8 06 00 00 00 BF 08 00 00 00 8B 75 00 E9 CE FD FF FF 8D 74 26 00 89 D7 89 EA 8B 6C 24 34 89 FE 89 C1 C1 FE 1F 89 D0 89 74 24 24 0F B6 74 24 3C 31 D2 89 7C 24 20 89 6C 24 4C 89 D5 89 7C 24 3C 89 C7 C7 44 24 34 00 00 00 00 89 74 24 48 8B 74 24 20 8B 44 24 24 0F AF F5 31 ED 0F AF C7 01 C6 8B 44 24 20 F7 E7 89 CF 01 F2 89 44 24 10 8B 44 24 38 89 54 24 14 8B 54 24 40 03 7C 24 10 13 6C 24 14 31 FA 31 E8 09 C2 83 C3 04 8B 33 85 F6 0F 84 01 01 00 00 3B 5C 24 30 0F 84 04 01 00 00 8D 4E D0 83 F9 09 76 46 80 7C 24 2F 00 74 06 39 74 24 28 74 D4 8B 8C 24 80 00 00 00 89 34 24 89 54 24 1C 89 4C 24 04 E8 ?? ?? ?? ?? 85 C0 0F 84 C3 00 00 00 8B 8C 24 80 00 00 00 89 34 24 89 4C 24 04 E8 ?? ?? ?? ?? 8B 54 24 1C 8D 48 C9 3B 4C 24 3C 0F 8D 9F 00 00 00 39 6C 24 38 72 21 77 06 39 7C 24 40 72 19 3B 4C 24 48 0F 86 3F FF FF FF 85 D2 0F 85 37 FF FF FF 8D B4 26 00 00 00 00 C7 44 24 34 01 00 00 00 E9 5D FF FF FF 8B 6C 24 70 8D B4 26 00 00 00 00 8B 5C 24 74 85 DB 0F 84 8D 00 00 00 89 E8 2B 44 24 70 83 F8 07 7F 13 8B 54 24 74 31 C0 8B 4C 24 70 89 0A 31 D2 E9 9E FD FF FF 8B B4 24 80 00 00 00 89 74 24 04 8B 45 FC 89 04 24 E8 ?? ?? ?? ?? 83 F8 58 75 D2 83 7D F8 30 75 CC 8B 44 24 74 83 ED 04 31 D2 89 28 31 C0 E9 6B FD FF FF 8D 76 00 89 EA 89 F8 8B 6C 24 4C E9 F3 FC FF FF 89 F8 89 EA E9 F2 FC FF FF 83 C5 08 B0 0E BF 10 00 00 00 E9 4F FE FF FF 31 C0 31 D2 E9 CA FC FF FF 89 EB 31 C0 31 D2 E9 BF FC FF FF 31 C0 31 D2 E9 26 FD FF FF 8B 58 2C 0F B6 13 83 EA 01 80 FA 7D 0F 87 65 FB FF FF 8B 40 34 85 C0 89 44 24 28 B8 00 00 00 00 0F 44 D8 E9 59 FB FF FF 8D B6 00 00 00 00 F7 D8 83 D2 00 83 C4 5C 5B F7 DA 5E 5F 5D C3 8B 75 00 E9 B7 FB FF FF 81 FA FF FF FF 7F 0F 86 D5 FC FF FF A1 ?? ?? ?? ?? BA FF FF FF 7F 65 C7 00 22 00 00 00 83 C8 FF E9 BC FC FF FF 39 74 24 28 0F 84 78 FF FF FF 85 F6 89 EF 75 28 EB 4B 66 90 8B 8C 24 80 00 00 00 89 34 24 89 4C 24 04 E8 ?? ?? ?? ?? 83 E8 37 83 F8 09 7F 2E 83 C7 04 8B 37 85 F6 74 25 8D 46 D0 83 F8 09 76 EF 3B 74 24 28 74 E9 8B 8C 24 80 00 00 00 89 34 24 89 4C 24 04 E8 ?? ?? ?? ?? 85 C0 75 B7 8B 74 24 28 89 7C 24 04 BF 0A 00 00 00 89 5C 24 0C 89 2C 24 89 74 24 08 E8 ?? ?? ?? ?? 8B 75 00 C6 44 24 2F 01 89 44 24 30 B8 08 00 00 00 E9 1B FB FF FF }
	condition:
		$1
}

rule file_392_1_0 {
	meta:
		name = "__wcstoll_l"
		size = 51
		refs = "002b ____wcstoll_l_internal"
	strings:
		$1 = { 83 EC 2C 8B 44 24 3C C7 44 24 0C 00 00 00 00 89 44 24 10 8B 44 24 38 89 44 24 08 8B 44 24 34 89 44 24 04 8B 44 24 30 89 04 24 E8 ?? ?? ?? ?? 83 C4 2C C3 }
	condition:
		$1
}

rule file_1496_1_0 {
	meta:
		name = "__strtol_l"
		size = 51
		refs = "002b ____strtol_l_internal"
	strings:
		$1 = { 83 EC 2C 8B 44 24 3C C7 44 24 0C 00 00 00 00 89 44 24 10 8B 44 24 38 89 44 24 08 8B 44 24 34 89 44 24 04 8B 44 24 30 89 04 24 E8 ?? ?? ?? ?? 83 C4 2C C3 }
	condition:
		$1
}

rule file_1394_1_0 {
	meta:
		name = "__strtoll_l"
		size = 51
		refs = "002b ____strtoll_l_internal"
	strings:
		$1 = { 83 EC 2C 8B 44 24 3C C7 44 24 0C 00 00 00 00 89 44 24 10 8B 44 24 38 89 44 24 08 8B 44 24 34 89 44 24 04 8B 44 24 30 89 04 24 E8 ?? ?? ?? ?? 83 C4 2C C3 }
	condition:
		$1
}

rule file_829_1_0 {
	meta:
		name = "__strtoul_l"
		size = 51
		refs = "002b ____strtoul_l_internal"
	strings:
		$1 = { 83 EC 2C 8B 44 24 3C C7 44 24 0C 00 00 00 00 89 44 24 10 8B 44 24 38 89 44 24 08 8B 44 24 34 89 44 24 04 8B 44 24 30 89 04 24 E8 ?? ?? ?? ?? 83 C4 2C C3 }
	condition:
		$1
}

rule file_1301_1_0 {
	meta:
		name = "__strtoull_l"
		size = 51
		refs = "002b ____strtoull_l_internal"
	strings:
		$1 = { 83 EC 2C 8B 44 24 3C C7 44 24 0C 00 00 00 00 89 44 24 10 8B 44 24 38 89 44 24 08 8B 44 24 34 89 44 24 04 8B 44 24 30 89 04 24 E8 ?? ?? ?? ?? 83 C4 2C C3 }
	condition:
		$1
}

rule file_1413_1_0 {
	meta:
		name = "__wcstol_l"
		size = 51
		refs = "002b ____wcstol_l_internal"
	strings:
		$1 = { 83 EC 2C 8B 44 24 3C C7 44 24 0C 00 00 00 00 89 44 24 10 8B 44 24 38 89 44 24 08 8B 44 24 34 89 44 24 04 8B 44 24 30 89 04 24 E8 ?? ?? ?? ?? 83 C4 2C C3 }
	condition:
		$1
}

rule file_1241_1_0 {
	meta:
		name = "__wcstoul_l"
		size = 51
		refs = "002b ____wcstoul_l_internal"
	strings:
		$1 = { 83 EC 2C 8B 44 24 3C C7 44 24 0C 00 00 00 00 89 44 24 10 8B 44 24 38 89 44 24 08 8B 44 24 34 89 44 24 04 8B 44 24 30 89 04 24 E8 ?? ?? ?? ?? 83 C4 2C C3 }
	condition:
		$1
}

rule file_544_1_0 {
	meta:
		name = "__wcstoull_l"
		size = 51
		refs = "002b ____wcstoull_l_internal"
	strings:
		$1 = { 83 EC 2C 8B 44 24 3C C7 44 24 0C 00 00 00 00 89 44 24 10 8B 44 24 38 89 44 24 08 8B 44 24 34 89 44 24 04 8B 44 24 30 89 04 24 E8 ?? ?? ?? ?? 83 C4 2C C3 }
	condition:
		$1
}

rule file_393_0_0 {
	meta:
		name = "allocate_dtv"
		size = 76
		refs = "0005 _dl_tls_max_dtv_idx 0025 calloc"
	strings:
		$1 = { 83 EC 1C 8B 15 ?? ?? ?? ?? 89 74 24 18 C7 44 24 04 08 00 00 00 89 5C 24 14 89 C3 8D 72 0E 83 C2 10 89 14 24 E8 ?? ?? ?? ?? 85 C0 74 1B 8D 50 08 89 30 89 53 04 89 D8 8B 74 24 18 8B 5C 24 14 83 C4 1C C3 90 8D 74 26 00 31 DB EB E9 }
	condition:
		$1
}

rule file_393_1_0 {
	meta:
		name = "_dl_next_tls_modid"
		size = 233
		refs = "0002 _dl_tls_dtv_gaps 000b _dl_tls_max_dtv_idx 001c _dl_tls_static_nelem 002c _dl_tls_dtv_slotinfo_list 0081 __assert_fail"
	strings:
		$1 = { 80 3D ?? ?? ?? ?? 00 75 0F 8B 15 ?? ?? ?? ?? 8D 42 01 A3 ?? ?? ?? ?? C3 83 EC 2C A1 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 89 5C 24 1C 8B 0D ?? ?? ?? ?? 89 74 24 20 83 C0 01 39 D0 89 7C 24 24 89 6C 24 28 77 6A 8B 31 31 DB 8D 6A 01 89 C7 29 DF 39 F7 73 36 8B 7C F9 0C 85 FF 74 3B 83 C0 01 39 E8 76 E9 C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 4B 00 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 76 00 8B 49 04 01 F3 85 C9 74 04 8B 31 EB B5 39 C2 72 14 8B 5C 24 1C 8B 74 24 20 8B 7C 24 24 8B 6C 24 28 83 C4 2C C3 8D 4A 01 39 C1 75 11 8D 42 01 C6 05 ?? ?? ?? ?? 00 A3 ?? ?? ?? ?? EB D4 C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 59 00 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_393_2_0 {
	meta:
		name = "_dl_get_tls_static_info"
		size = 16
		refs = "0002 _dl_tls_static_size 0009 _dl_tls_static_align"
	strings:
		$1 = { 8B 0D ?? ?? ?? ?? 89 08 A1 ?? ?? ?? ?? 89 02 C3 }
	condition:
		$1
}

rule file_393_3_0 {
	meta:
		name = "_dl_allocate_tls_storage"
		size = 239
		refs = "0004 _dl_tls_static_align 000e _dl_tls_static_size 0022 __libc_memalign 0096 free"
	strings:
		$1 = { 83 EC 2C A1 ?? ?? ?? ?? 89 5C 24 20 8B 1D ?? ?? ?? ?? 89 74 24 24 89 7C 24 28 89 04 24 89 5C 24 04 E8 ?? ?? ?? ?? 85 C0 0F 84 BA 00 00 00 8D 9C 18 40 FB FF FF 89 C6 F6 C3 01 89 DF BA C0 04 00 00 75 7D F7 C7 02 00 00 00 0F 85 89 00 00 00 89 D1 31 C0 C1 E9 02 F6 C2 02 F3 AB 75 53 83 E2 01 75 1E 89 D8 E8 47 FE FF FF 85 C0 74 21 8B 5C 24 20 8B 74 24 24 8B 7C 24 28 83 C4 2C C3 8D 76 00 C6 07 00 89 D8 E8 26 FE FF FF 85 C0 75 DF 89 34 24 89 44 24 1C E8 ?? ?? ?? ?? 8B 44 24 1C 8B 5C 24 20 8B 74 24 24 8B 7C 24 28 83 C4 2C C3 66 90 66 C7 07 00 00 83 C7 02 83 E2 01 74 A5 EB C1 90 8D 7B 01 B2 BF F7 C7 02 00 00 00 C6 03 00 0F 84 7B FF FF FF 8D 74 26 00 66 C7 07 00 00 83 EA 02 83 C7 02 E9 67 FF FF FF 31 C0 E9 7E FF FF FF }
	condition:
		$1
}

rule file_393_4_0 {
	meta:
		name = "_dl_allocate_tls_init"
		size = 538
		refs = "0018 _dl_tls_dtv_slotinfo_list 001d _dl_tls_max_dtv_idx 00cf mempcpy 00e3 memset 0190 __assert_fail"
	strings:
		$1 = { 55 57 56 53 83 EC 3C 85 C0 89 44 24 2C 0F 84 8F 01 00 00 8B 50 04 8B 0D ?? ?? ?? ?? A1 ?? ?? ?? ?? C7 44 24 1C 00 00 00 00 89 54 24 28 89 4C 24 20 C7 44 24 24 00 00 00 00 8D B4 26 00 00 00 00 8B 6C 24 24 31 DB 8B 54 24 20 85 ED 0F 94 C3 3B 1A 0F 83 FC 00 00 00 8B 54 24 24 01 DA 39 D0 0F 82 33 01 00 00 8B 4C 24 20 8D 74 D9 0C E9 95 00 00 00 8D B6 00 00 00 00 39 98 44 02 00 00 0F 85 2A 01 00 00 8B A8 34 02 00 00 8B B8 30 02 00 00 39 FD 0F 82 3A 01 00 00 39 EA 0F 82 56 01 00 00 8B 4C 24 2C 29 FD 29 D1 8B 54 24 28 89 4C 24 18 8D 0C DA 8B 54 24 18 C6 41 04 01 89 11 89 7C 24 08 8B 80 2C 02 00 00 89 14 24 89 44 24 04 E8 ?? ?? ?? ?? 89 6C 24 08 C7 44 24 04 00 00 00 00 89 04 24 E8 ?? ?? ?? ?? 8B 4C 24 20 83 C3 01 39 19 76 5C 8B 44 24 24 83 C6 08 01 D8 39 05 ?? ?? ?? ?? 0F 82 91 00 00 00 8B 06 85 C0 74 DA 8B 56 FC 39 54 24 1C 0F 43 54 24 1C 89 54 24 1C 8B 90 40 02 00 00 83 FA 01 0F 87 4C FF FF FF 8B 80 44 02 00 00 83 C3 01 8B 54 24 28 8B 4C 24 20 8D 04 C2 C7 00 FF FF FF FF C6 40 04 00 39 19 77 A4 A1 ?? ?? ?? ?? 01 5C 24 24 39 44 24 24 73 3B 8B 54 24 20 8B 52 04 85 D2 89 54 24 20 0F 85 D0 FE FF FF C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 BE 01 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 74 26 00 8B 54 24 1C 8B 4C 24 28 89 11 8B 44 24 2C 83 C4 3C 5B 5E 5F 5D C3 C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 A6 01 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 A7 01 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 A9 01 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_393_5_0 {
	meta:
		name = "_dl_allocate_tls"
		size = 37
		refs = "0019 _dl_allocate_tls_storage 0010 _dl_allocate_tls_init"
	strings:
		$1 = { 83 EC 0C 85 C0 74 11 E8 94 FB FF FF 83 C4 0C E9 ?? ?? ?? ?? 8D 74 26 00 E8 ?? ?? ?? ?? 83 C4 0C E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_393_6_0 {
	meta:
		name = "_dl_deallocate_tls"
		size = 113
		refs = "0035 free 0057 _dl_tls_static_size"
	strings:
		$1 = { 55 31 ED 57 89 C7 56 53 83 EC 2C 8B 70 04 88 54 24 1F 89 F3 8B 56 F8 EB 26 8D B4 26 00 00 00 00 83 C5 01 80 7B 0C 00 75 13 8B 4B 08 83 F9 FF 74 0B 89 0C 24 E8 ?? ?? ?? ?? 8B 56 F8 83 C3 08 39 D5 72 DD 83 EE 08 89 34 24 E8 ?? ?? ?? ?? 80 7C 24 1F 00 74 14 2B 3D ?? ?? ?? ?? 8D 87 C0 04 00 00 89 04 24 E8 ?? ?? ?? ?? 83 C4 2C 5B 5E 5F 5D C3 }
	condition:
		$1
}

rule file_393_7_0 {
	meta:
		name = "_dl_tls_get_addr_soft"
		size = 111
		refs = "0027 _dl_tls_generation 004e _dl_tls_dtv_slotinfo_list"
	strings:
		$1 = { 83 EC 0C 8B 44 24 10 89 1C 24 89 74 24 04 89 7C 24 08 8B 80 44 02 00 00 85 C0 74 4F 65 8B 15 04 00 00 00 8B 0A 3B 0D ?? ?? ?? ?? 75 1A 8B 04 C2 31 D2 83 F8 FF 0F 44 C2 8B 1C 24 8B 74 24 04 8B 7C 24 08 83 C4 0C C3 3B 42 F8 73 1F 8B 1D ?? ?? ?? ?? 89 C6 8B 3B 39 F8 72 0B 8B 5B 04 29 FE 8B 3B 39 F7 76 F5 3B 4C F3 08 73 C2 31 C0 EB C9 }
	condition:
		$1
}

rule file_393_8_0 {
	meta:
		name = "_dl_add_to_slotinfo"
		size = 214
		refs = "0015 _dl_tls_dtv_slotinfo_list 0045 malloc 0070 _dl_tls_generation 00ae _dl_signal_error 00d2 __assert_fail"
	strings:
		$1 = { 83 EC 2C 89 6C 24 28 8B 6C 24 30 89 5C 24 1C 89 74 24 20 8B 35 ?? ?? ?? ?? 89 7C 24 24 8B 9D 44 02 00 00 EB 05 8D 76 00 89 C6 8B 06 39 C3 72 3F 29 C3 8B 46 04 85 C0 75 EF 85 DB 75 75 C7 04 24 F8 01 00 00 E8 ?? ?? ?? ?? 85 C0 89 C2 89 46 04 74 41 8D 70 08 B9 7C 00 00 00 C7 00 3E 00 00 00 89 F7 89 D6 C7 40 04 00 00 00 00 89 D8 F3 AB A1 ?? ?? ?? ?? 89 6C DE 0C 8B 7C 24 24 8B 6C 24 28 83 C0 01 89 44 DE 08 8B 5C 24 1C 8B 74 24 20 83 C4 2C C3 C7 04 24 ?? ?? ?? ?? 31 C9 BA ?? ?? ?? ?? B8 0C 00 00 00 83 05 ?? ?? ?? ?? 01 E8 ?? ?? ?? ?? C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 57 03 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_395_0_0 {
	meta:
		name = "time"
		size = 26
		refs = "000e _dl_sysinfo"
	strings:
		$1 = { 53 31 DB 8B 54 24 08 B8 0D 00 00 00 FF 15 ?? ?? ?? ?? 85 D2 74 02 89 02 5B C3 }
	condition:
		$1
}

rule file_396_0_0 {
	meta:
		name = "epoll_ctl"
		size = 43
		refs = "0019 _dl_sysinfo 0026 __syscall_error"
	strings:
		$1 = { 56 53 8B 74 24 18 8B 54 24 14 8B 4C 24 10 8B 5C 24 0C B8 FF 00 00 00 FF 15 ?? ?? ?? ?? 5B 5E 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_397_0_0 {
	meta:
		name = "_nl_init_era_entries.part.0"
		size = 541
		refs = "0007 __pthread_rwlock_wrlock 0015 __libc_setlocale_lock 002e __pthread_rwlock_unlock 0061 free 008f realloc 00e5 __rawmemchr 011f wcschr 01d0 malloc 01f3 _nl_cleanup_time"
	strings:
		$1 = { 55 57 56 89 C6 53 B8 ?? ?? ?? ?? 83 EC 2C 85 C0 74 09 C7 04 24 ?? ?? ?? ?? FF D0 8B 6E 14 85 ED 0F 84 A2 01 00 00 8B 45 08 85 C0 74 1B B8 ?? ?? ?? ?? 85 C0 74 09 C7 04 24 ?? ?? ?? ?? FF D0 83 C4 2C 5B 5E 5F 5D C3 90 8B 86 EC 00 00 00 85 C0 89 44 24 18 75 22 8B 45 00 85 C0 74 0F 89 04 24 E8 ?? ?? ?? ?? C7 45 00 00 00 00 00 C7 45 08 01 00 00 00 EB B8 8D 76 00 8B 44 24 18 3B 45 04 8B 5D 00 74 11 6B C0 34 89 1C 24 89 44 24 04 E8 ?? ?? ?? ?? 89 C3 85 DB 0F 84 62 01 00 00 8B 44 24 18 31 FF 8B B6 F0 00 00 00 89 6C 24 1C 89 5D 00 89 45 04 E9 8A 00 00 00 0F 84 DA 00 00 00 31 C0 83 3B 2B 0F 95 C0 8D 44 00 FF 89 43 30 8D 46 20 83 C7 01 89 43 20 83 C3 34 C7 44 24 04 00 00 00 00 89 04 24 E8 ?? ?? ?? ?? 83 C0 01 89 43 F0 C7 44 24 04 00 00 00 00 89 04 24 E8 ?? ?? ?? ?? 83 C0 01 89 C2 29 F2 83 C2 03 F7 D2 83 E2 03 01 C2 89 53 F4 89 14 24 C7 44 24 04 00 00 00 00 E8 ?? ?? ?? ?? 83 C0 04 89 43 F8 C7 44 24 04 00 00 00 00 89 04 24 E8 ?? ?? ?? ?? 3B 7C 24 18 8D 70 04 74 76 8B 06 89 03 8B 46 04 89 43 04 8B 56 08 89 53 08 8B 6E 0C 89 6C 24 10 89 6B 0C 8B 46 10 89 44 24 14 89 43 10 8B 46 14 89 43 14 8B 4E 18 39 C2 89 4B 18 8B 6E 1C 89 6B 1C 0F 8D 38 FF FF FF 31 C0 83 3B 2B 0F 94 C0 8D 44 00 FF 89 43 30 E9 39 FF FF FF 8D 74 26 00 39 4C 24 10 7C E2 0F 85 1A FF FF FF 8B 44 24 14 39 E8 0F 8F 0E FF FF FF EB CE 8D B6 00 00 00 00 8B 6C 24 1C C7 45 08 01 00 00 00 E9 65 FE FF FF C7 04 24 1C 00 00 00 E8 ?? ?? ?? ?? 31 D2 85 C0 89 46 14 0F 84 4C FE FF FF C7 04 10 00 00 00 00 83 C2 04 83 FA 1C 72 F1 C7 46 10 ?? ?? ?? ?? 8B 6E 14 E9 27 FE FF FF 8B 45 00 89 04 24 E8 ?? ?? ?? ?? C7 45 04 00 00 00 00 C7 45 00 00 00 00 00 E9 4F FE FF FF }
	condition:
		$1
}

rule file_397_1_0 {
	meta:
		name = "_nl_get_era_entry"
		size = 351
	strings:
		$1 = { 55 57 56 89 C6 53 83 EC 1C 8B 5A 14 85 DB 0F 84 94 00 00 00 8B 7B 08 85 FF 0F 84 89 00 00 00 8B 7B 04 8B 4E 14 8B 6E 10 8B 76 0C 85 FF 89 74 24 0C 0F 84 99 00 00 00 8B 13 31 DB 89 2C 24 EB 20 0F 84 C2 00 00 00 3B 4A 14 7F 2D 90 8D 74 26 00 0F 84 DA 00 00 00 83 C3 01 83 C2 34 39 FB 74 70 8B 72 08 89 D0 39 F1 7E D7 3B 4A 14 7C 32 74 70 7E E4 8D B6 00 00 00 00 39 F1 8D B6 00 00 00 00 7C 1E 75 D2 8B 34 24 3B 72 0C 7C 14 8D 74 26 00 75 C4 8B 6C 24 0C 3B 6A 10 7F BB 90 8D 74 26 00 83 C4 1C 5B 5E 5F 5D C3 8B 8A EC 00 00 00 85 C9 74 12 89 D0 89 54 24 04 E8 23 FD FF FF 8B 54 24 04 8B 5A 14 85 DB 0F 85 53 FF FF FF 8D 74 26 00 83 C4 1C 31 C0 5B 5E 5F 5D C3 8D B6 00 00 00 00 8B 6A 18 39 2C 24 89 6C 24 08 7C B4 74 52 8B 6C 24 08 39 2C 24 7F 81 0F 85 59 FF FF FF 8D 76 00 EB 4B 8D B6 00 00 00 00 8B 2C 24 3B 6A 0C 66 90 0F 8F 53 FF FF FF 0F 85 2A FF FF FF 8B 6C 24 0C 3B 6A 10 0F 8C 1D FF FF FF E9 3B FF FF FF 66 90 8B 6A 18 89 6C 24 08 EB B5 8D B4 26 00 00 00 00 8B 6C 24 0C 3B 6A 1C 0F 8E 53 FF FF FF 8B 6C 24 0C 3B 6A 1C 0F 8C FC FE FF FF E9 19 FF FF FF }
	condition:
		$1
}

rule file_397_2_0 {
	meta:
		name = "_nl_select_era_entry"
		size = 68
	strings:
		$1 = { 53 89 C3 83 EC 18 8B 4A 14 85 C9 74 13 8B 41 08 85 C0 74 0C 6B C3 34 03 01 83 C4 18 5B C3 66 90 8B 82 EC 00 00 00 85 C0 74 12 89 D0 89 54 24 0C E8 4B FC FF FF 8B 54 24 0C 8B 4A 14 85 C9 75 D4 31 C0 EB D5 }
	condition:
		$1
}

rule file_398_0_0 {
	meta:
		name = "at_quick_exit"
		size = 44
		refs = "0001 __dso_handle 001d __cxa_at_quick_exit"
	strings:
		$1 = { B8 ?? ?? ?? ?? 83 EC 1C 85 C0 74 19 A1 ?? ?? ?? ?? 89 44 24 04 8B 44 24 20 89 04 24 E8 ?? ?? ?? ?? 83 C4 1C C3 B8 ?? ?? ?? ?? EB E5 }
	condition:
		$1
}

rule file_399_0_0 {
	meta:
		name = "drand48"
		size = 39
		refs = "000f __libc_drand48_data 001b __erand48_r"
	strings:
		$1 = { 83 EC 2C 8D 44 24 18 89 44 24 08 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? DD 44 24 18 83 C4 2C C3 }
	condition:
		$1
}

rule file_400_0_0 {
	meta:
		name = "lock_and_info"
		size = 92
		refs = "001d _dl_addr"
	strings:
		$1 = { 83 EC 1C 85 C0 89 5C 24 14 89 74 24 18 74 49 31 C9 89 D6 C7 04 24 00 00 00 00 31 DB E8 ?? ?? ?? ?? B9 01 00 00 00 83 EC 04 85 C0 0F 44 F3 89 D8 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 0D ?? ?? ?? ?? 0F 85 88 07 00 00 89 F0 8B 5C 24 14 8B 74 24 18 83 C4 1C C3 66 90 31 F6 EB EC }
	condition:
		$1
}

rule file_400_2_0 {
	meta:
		name = "tr_where"
		size = 283
		refs = "0031 strlen 006c mempcpy 00ac _fitoa 00e1 fprintf"
	strings:
		$1 = { 85 C0 0F 84 E4 00 00 00 55 89 E5 57 56 53 83 EC 3C 85 D2 0F 84 E7 00 00 00 89 C6 8B 42 08 89 D3 BF ?? ?? ?? ?? 85 C0 0F 84 88 00 00 00 89 04 24 E8 ?? ?? ?? ?? B9 ?? ?? ?? ?? 8D 50 2C 83 E2 F0 29 D4 BA ?? ?? ?? ?? 8D 7C 24 27 83 E7 F0 C6 07 28 3B 73 0C 89 44 24 08 8B 43 08 0F 42 D1 89 55 E4 89 44 24 04 8D 47 01 89 04 24 E8 ?? ?? ?? ?? 8B 55 E4 8B 12 83 C0 03 89 50 FD 8B 4B 0C 89 F2 2B 53 0C 29 F1 3B 73 0C 89 44 24 08 C7 44 24 10 00 00 00 00 0F 42 D1 89 D0 C1 F8 1F C7 44 24 0C 10 00 00 00 89 14 24 89 44 24 04 E8 ?? ?? ?? ?? 66 C7 00 29 00 8B 03 BA ?? ?? ?? ?? 85 C0 74 30 89 44 24 08 A1 ?? ?? ?? ?? 89 74 24 14 89 7C 24 10 89 54 24 0C C7 44 24 04 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 8D 65 F4 5B 5E 5F 5D F3 C3 66 90 BA ?? ?? ?? ?? 89 D0 EB C7 8D B4 26 00 00 00 00 89 44 24 08 A1 ?? ?? ?? ?? C7 44 24 04 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? EB CA }
	condition:
		$1
}

rule file_400_3_0 {
	meta:
		name = "tr_memalignhook"
		size = 212
		refs = "0030 __memalign_hook 003c __malloc_hook 008b fprintf 00cc memalign"
	strings:
		$1 = { 83 EC 3C 89 5C 24 2C 8B 5C 24 48 8D 54 24 10 89 7C 24 34 8B 7C 24 44 89 6C 24 38 89 74 24 30 89 D8 E8 5A FE FF FF 8B 0D ?? ?? ?? ?? 85 C9 89 0D ?? ?? ?? ?? 89 C5 A1 ?? ?? ?? ?? A3 ?? ?? ?? ?? 74 7E 8B 44 24 40 89 5C 24 08 89 7C 24 04 89 04 24 FF D1 89 C6 89 EA 89 D8 C7 05 ?? ?? ?? ?? ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? E8 6E FE FF FF A1 ?? ?? ?? ?? 89 7C 24 0C 89 74 24 08 C7 44 24 04 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 65 83 3D 0C 00 00 00 00 74 01 F0 83 2D ?? ?? ?? ?? 01 0F 85 B9 05 00 00 89 F0 8B 5C 24 2C 8B 74 24 30 8B 7C 24 34 8B 6C 24 38 83 C4 3C C3 8D 76 00 8B 44 24 40 89 7C 24 04 89 04 24 E8 ?? ?? ?? ?? 89 C6 EB 81 }
	condition:
		$1
}

rule file_400_4_0 {
	meta:
		name = "tr_mallochook"
		size = 180
		refs = "0030 __malloc_hook 006f fprintf 00ac malloc"
	strings:
		$1 = { 83 EC 3C 89 5C 24 2C 8B 5C 24 44 8D 54 24 10 89 7C 24 34 8B 7C 24 40 89 6C 24 38 89 74 24 30 89 D8 E8 7A FD FF FF 8B 0D ?? ?? ?? ?? 85 C9 89 0D ?? ?? ?? ?? 89 C5 74 70 89 5C 24 04 89 3C 24 FF D1 89 C6 89 EA 89 D8 C7 05 ?? ?? ?? ?? ?? ?? ?? ?? E8 AA FD FF FF A1 ?? ?? ?? ?? 89 7C 24 0C 89 74 24 08 C7 44 24 04 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 65 83 3D 0C 00 00 00 00 74 01 F0 83 2D ?? ?? ?? ?? 01 0F 85 05 05 00 00 89 F0 8B 5C 24 2C 8B 74 24 30 8B 7C 24 34 8B 6C 24 38 83 C4 3C C3 8D B4 26 00 00 00 00 89 3C 24 E8 ?? ?? ?? ?? 89 C6 EB 8F }
	condition:
		$1
}

rule file_400_7_0 {
	meta:
		name = "tr_reallochook"
		size = 374
		refs = "002e __free_hook 0038 __malloc_hook 0044 __realloc_hook 00ad fprintf 011c realloc"
	strings:
		$1 = { 83 EC 3C 89 5C 24 2C 8B 5C 24 48 8D 54 24 10 89 7C 24 34 8B 7C 24 40 89 6C 24 38 89 74 24 30 89 D8 E8 BA FC FF FF 89 C5 A1 ?? ?? ?? ?? A3 ?? ?? ?? ?? A1 ?? ?? ?? ?? A3 ?? ?? ?? ?? A1 ?? ?? ?? ?? 85 C0 A3 ?? ?? ?? ?? 0F 84 C2 00 00 00 8B 54 24 44 89 5C 24 08 89 3C 24 89 54 24 04 FF D0 89 C6 89 EA 89 D8 C7 05 ?? ?? ?? ?? ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? E8 B8 FC FF FF 85 F6 0F 84 C0 00 00 00 85 FF 0F 84 90 00 00 00 A1 ?? ?? ?? ?? 89 7C 24 08 C7 44 24 04 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 89 EA 89 D8 E8 86 FC FF FF 8B 54 24 44 A1 ?? ?? ?? ?? 89 74 24 08 C7 44 24 04 ?? ?? ?? ?? 89 54 24 0C 89 04 24 E8 ?? ?? ?? ?? 65 83 3D 0C 00 00 00 00 74 01 F0 83 2D ?? ?? ?? ?? 01 0F 85 ED 03 00 00 89 F0 8B 5C 24 2C 8B 74 24 30 8B 7C 24 34 8B 6C 24 38 83 C4 3C C3 8D B4 26 00 00 00 00 8B 44 24 44 89 3C 24 89 44 24 04 E8 ?? ?? ?? ?? 89 C6 E9 3A FF FF FF 90 8B 44 24 44 89 74 24 08 C7 44 24 04 ?? ?? ?? ?? 89 44 24 0C A1 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? EB 90 90 8D 74 26 00 8B 54 24 44 A1 ?? ?? ?? ?? 89 7C 24 08 C7 44 24 04 ?? ?? ?? ?? 89 54 24 0C 89 04 24 E8 ?? ?? ?? ?? E9 65 FF FF FF }
	condition:
		$1
}

rule file_400_8_0 {
	meta:
		name = "tr_freehook"
		size = 218
		refs = "003a fprintf 0040 mallwatch 004e __free_hook 00d4 free"
	strings:
		$1 = { 56 53 83 EC 24 8B 5C 24 30 8B 74 24 34 85 DB 74 6E 8D 54 24 10 89 F0 E8 44 FB FF FF 89 C2 89 F0 E8 9B FB FF FF A1 ?? ?? ?? ?? 89 5C 24 08 C7 44 24 04 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 3B 1D ?? ?? ?? ?? 74 42 A1 ?? ?? ?? ?? 85 C0 A3 ?? ?? ?? ?? 74 7C 89 74 24 04 89 1C 24 FF D0 C7 05 ?? ?? ?? ?? ?? ?? ?? ?? 65 83 3D 0C 00 00 00 00 74 01 F0 83 2D ?? ?? ?? ?? 01 0F 85 F1 02 00 00 83 C4 24 5B 5E C3 8D 76 00 65 83 3D 0C 00 00 00 00 74 01 F0 83 2D ?? ?? ?? ?? 01 0F 85 E0 02 00 00 31 C0 B9 01 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 0D ?? ?? ?? ?? 0F 85 D1 02 00 00 A1 ?? ?? ?? ?? 85 C0 A3 ?? ?? ?? ?? 75 87 8D 76 00 89 1C 24 E8 ?? ?? ?? ?? EB 83 }
	condition:
		$1
}

rule file_400_14_0 {
	meta:
		name = "mtrace"
		size = 457
		refs = "0023 __secure_getenv 0039 malloc 0053 _IO_new_fopen 0068 fileno 0080 __fcntl 00d1 _IO_setvbuf 00f6 fwrite 00fb __free_hook 0115 __malloc_hook 012b __realloc_hook 013f __memalign_hook 0155 __dso_handle 0180 __cxa_atexit 0192 mallwatch 01bc free"
	strings:
		$1 = { A1 ?? ?? ?? ?? 85 C0 74 07 C3 8D B6 00 00 00 00 83 EC 1C C7 04 24 ?? ?? ?? ?? 89 5C 24 14 89 74 24 18 E8 ?? ?? ?? ?? 85 C0 89 C3 0F 84 5F 01 00 00 C7 04 24 00 02 00 00 E8 ?? ?? ?? ?? 85 C0 89 C6 0F 84 3D 01 00 00 C7 44 24 04 ?? ?? ?? ?? 89 1C 24 E8 ?? ?? ?? ?? 85 C0 A3 ?? ?? ?? ?? 0F 84 54 01 00 00 89 04 24 E8 ?? ?? ?? ?? C7 44 24 08 00 00 00 00 C7 44 24 04 01 00 00 00 89 04 24 E8 ?? ?? ?? ?? 85 C0 89 C3 78 24 A1 ?? ?? ?? ?? 83 CB 01 89 04 24 E8 ?? ?? ?? ?? 89 5C 24 08 C7 44 24 04 02 00 00 00 89 04 24 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? C7 44 24 0C 00 02 00 00 C7 44 24 08 00 00 00 00 89 74 24 04 89 04 24 89 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? C7 44 24 08 08 00 00 00 C7 44 24 04 01 00 00 00 C7 04 24 ?? ?? ?? ?? 89 44 24 0C E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? A3 ?? ?? ?? ?? A1 ?? ?? ?? ?? 85 D2 C7 05 ?? ?? ?? ?? ?? ?? ?? ?? A3 ?? ?? ?? ?? A1 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? A3 ?? ?? ?? ?? A1 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? A3 ?? ?? ?? ?? 75 30 B8 ?? ?? ?? ?? 85 C0 C7 05 ?? ?? ?? ?? 01 00 00 00 74 5B A1 ?? ?? ?? ?? 89 44 24 08 C7 44 24 04 00 00 00 00 C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 5C 24 14 8B 74 24 18 83 C4 1C C3 8B 0D ?? ?? ?? ?? 85 C9 74 EA C7 04 24 00 02 00 00 E8 ?? ?? ?? ?? 85 C0 89 C6 74 D8 BB ?? ?? ?? ?? E9 91 FE FF FF 66 90 89 34 24 E8 ?? ?? ?? ?? EB C2 B8 ?? ?? ?? ?? EB A3 }
	condition:
		$1
}

rule file_400_15_0 {
	meta:
		name = "muntrace"
		size = 112
		refs = "0028 fwrite 0035 _IO_new_fclose 0049 __free_hook 0053 __malloc_hook 005d __realloc_hook 0067 __memalign_hook"
	strings:
		$1 = { A1 ?? ?? ?? ?? 85 C0 74 65 83 EC 1C 89 44 24 0C C7 44 24 08 06 00 00 00 C7 44 24 04 01 00 00 00 C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 00 00 00 00 A3 ?? ?? ?? ?? A1 ?? ?? ?? ?? A3 ?? ?? ?? ?? A1 ?? ?? ?? ?? A3 ?? ?? ?? ?? A1 ?? ?? ?? ?? A3 ?? ?? ?? ?? 83 C4 1C F3 C3 }
	condition:
		$1
}

rule file_401_0_0 {
	meta:
		name = "bsearch"
		size = 98
	strings:
		$1 = { 55 31 ED 57 56 53 83 EC 1C 8B 7C 24 38 85 FF 74 45 89 F8 89 EF 89 C5 EB 10 8D B4 26 00 00 00 00 74 36 8D 7B 01 39 EF 73 2D 8B 74 24 3C 8D 5C 3D 00 8B 54 24 30 D1 EB 0F AF F3 03 74 24 34 89 14 24 8B 54 24 40 89 74 24 04 FF D2 83 F8 00 7D D0 89 DD 39 EF 72 D3 31 F6 83 C4 1C 89 F0 5B 5E 5F 5D C3 }
	condition:
		$1
}

rule file_402_0_0 {
	meta:
		name = "_dl_resolve_conflicts"
		size = 232
		refs = "0009 _dl_debug_mask 0036 _dl_num_cache_relocations 0063 _dl_reloc_bad_type 00c0 __assert_fail 00cd _dl_argv 00df _dl_debug_printf"
	strings:
		$1 = { 55 57 56 53 83 EC 1C F6 05 ?? ?? ?? ?? 20 8B 7C 24 30 8B 5C 24 34 8B 6C 24 38 0F 85 A4 00 00 00 8B 47 18 85 C0 75 79 89 E8 29 D8 C1 F8 02 69 C0 AB AA AA AA 01 05 ?? ?? ?? ?? 39 DD 76 39 66 90 0F B6 53 04 8B 33 83 FA 08 74 35 85 D2 74 21 83 FA 07 77 3C 83 FA 06 73 0F 83 FA 01 74 0A 31 C9 89 F8 E8 ?? ?? ?? ?? 90 8B 43 08 89 06 8D 76 00 83 C3 0C 39 DD 77 C9 83 C4 1C 5B 5E 5F 5D C3 90 8B 43 08 03 07 89 06 EB E7 8D B4 26 00 00 00 00 83 FA 2A 75 C9 8B 43 08 03 07 FF D0 89 06 EB D0 C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 38 00 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 47 04 80 38 00 75 07 A1 ?? ?? ?? ?? 8B 00 89 44 24 04 C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? E9 38 FF FF FF }
	condition:
		$1
}

rule file_403_1_0 {
	meta:
		name = "cfgetispeed"
		size = 27
	strings:
		$1 = { 8B 44 24 04 8B 10 85 D2 78 0E 8B 40 08 25 0F 10 00 00 C3 90 8D 74 26 00 31 C0 C3 }
	condition:
		$1
}

rule file_403_2_0 {
	meta:
		name = "cfsetospeed"
		size = 66
		refs = "0031 __libc_errno"
	strings:
		$1 = { 8B 54 24 08 8B 4C 24 04 F7 C2 F0 EF FF FF 74 0B 8D 82 FF EF FF FF 83 F8 0E 77 15 8B 41 08 89 51 38 25 F0 EF FF FF 09 D0 89 41 08 31 C0 C3 66 90 A1 ?? ?? ?? ?? 65 C7 00 16 00 00 00 B8 FF FF FF FF C3 }
	condition:
		$1
}

rule file_403_3_0 {
	meta:
		name = "cfsetispeed"
		size = 90
		refs = "0049 __libc_errno"
	strings:
		$1 = { 8B 54 24 08 8B 44 24 04 F7 C2 F0 EF FF FF 74 28 8D 8A FF EF FF FF 83 F9 0E 77 2D 89 50 34 8B 48 08 81 20 FF FF FF 7F 81 E1 F0 EF FF FF 09 D1 89 48 08 31 C0 C3 8D 76 00 85 D2 89 50 34 75 DF 81 08 00 00 00 80 31 C0 C3 A1 ?? ?? ?? ?? 65 C7 00 16 00 00 00 B8 FF FF FF FF C3 }
	condition:
		$1
}

rule file_404_0_0 {
	meta:
		name = "__libc_pwrite64"
		size = 172
		refs = "0038 _dl_sysinfo 005d __libc_errno 006c __libc_enable_asynccancel 0095 __libc_disable_asynccancel"
	strings:
		$1 = { 83 EC 1C 89 74 24 10 8B 74 24 2C 89 7C 24 14 8B 7C 24 30 89 5C 24 0C 89 6C 24 18 65 A1 0C 00 00 00 85 C0 75 46 8B 5C 24 20 8B 4C 24 24 8B 54 24 28 B8 B5 00 00 00 FF 15 ?? ?? ?? ?? 3D 00 F0 FF FF 77 18 89 C6 89 F0 8B 5C 24 0C 8B 74 24 10 8B 7C 24 14 8B 6C 24 18 83 C4 1C C3 8B 15 ?? ?? ?? ?? F7 D8 65 89 02 83 C8 FF EB D8 E8 ?? ?? ?? ?? 8B 5C 24 20 8B 4C 24 24 8B 54 24 28 89 C5 B8 B5 00 00 00 FF 15 ?? ?? ?? ?? 3D 00 F0 FF FF 77 0B 89 C6 89 E8 E8 ?? ?? ?? ?? EB AA 89 C6 A1 ?? ?? ?? ?? F7 DE 65 89 30 83 C8 FF EB E4 }
	condition:
		$1
}

rule file_78_0_3 {
	meta:
		name = "__libc_pwrite64"
		size = 172
		refs = "0038 _dl_sysinfo 005d errno 006c __pthread_enable_asynccancel 0095 __pthread_disable_asynccancel"
	strings:
		$1 = { 83 EC 1C 89 74 24 10 8B 74 24 2C 89 7C 24 14 8B 7C 24 30 89 5C 24 0C 89 6C 24 18 65 A1 0C 00 00 00 85 C0 75 46 8B 5C 24 20 8B 4C 24 24 8B 54 24 28 B8 B5 00 00 00 FF 15 ?? ?? ?? ?? 3D 00 F0 FF FF 77 18 89 C6 89 F0 8B 5C 24 0C 8B 74 24 10 8B 7C 24 14 8B 6C 24 18 83 C4 1C C3 8B 15 ?? ?? ?? ?? F7 D8 65 89 02 83 C8 FF EB D8 E8 ?? ?? ?? ?? 8B 5C 24 20 8B 4C 24 24 8B 54 24 28 89 C5 B8 B5 00 00 00 FF 15 ?? ?? ?? ?? 3D 00 F0 FF FF 77 0B 89 C6 89 E8 E8 ?? ?? ?? ?? EB AA 89 C6 A1 ?? ?? ?? ?? F7 DE 65 89 30 83 C8 FF EB E4 }
	condition:
		$1
}

rule file_405_0_0 {
	meta:
		name = "name_to_handle_at"
		size = 49
		refs = "001e _dl_sysinfo 002c __syscall_error"
	strings:
		$1 = { 57 56 53 8B 7C 24 20 8B 74 24 1C 8B 54 24 18 8B 4C 24 14 8B 5C 24 10 B8 55 01 00 00 FF 15 ?? ?? ?? ?? 5B 5E 5F 3D 01 F0 FF FF 0F 83 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_406_0_0 {
	meta:
		name = "__read_chk"
		size = 66
		refs = "001d _dl_sysinfo 002e __chk_fail 0034 __libc_errno"
	strings:
		$1 = { 53 83 EC 08 8B 54 24 18 3B 54 24 1C 77 1F 8B 4C 24 14 8B 5C 24 10 B8 03 00 00 00 FF 15 ?? ?? ?? ?? 3D 00 F0 FF FF 77 0A 83 C4 08 5B C3 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? F7 D8 65 89 02 83 C8 FF EB E6 }
	condition:
		$1
}

rule file_407_0_0 {
	meta:
		name = "__dngettext"
		size = 51
		refs = "002b __dcngettext"
	strings:
		$1 = { 83 EC 2C 8B 44 24 3C C7 44 24 10 05 00 00 00 89 44 24 0C 8B 44 24 38 89 44 24 08 8B 44 24 34 89 44 24 04 8B 44 24 30 89 04 24 E8 ?? ?? ?? ?? 83 C4 2C C3 }
	condition:
		$1
}

rule file_408_0_0 {
	meta:
		name = "nscd_getserv_r"
		size = 1761
		refs = "001c __serv_map_handle 0033 __nscd_get_map_ref 0045 strlen 00a6 mempcpy 00bc memcpy 0102 __nscd_cache_search 01cc __nscd_open_socket 021e __libc_errno 023b _dl_sysinfo 025c __nscd_unmap 0272 free 04f0 __readvall 0522 __nss_not_use_nscd_services 0569 __readall 0618 __libc_alloca_cutoff 062b malloc 06d3 __assert_fail"
	strings:
		$1 = { 55 89 E5 57 56 89 CE 53 81 EC 9C 00 00 00 89 45 B0 8D 45 BC 89 44 24 0C C7 44 24 08 ?? ?? ?? ?? C7 44 24 04 ?? ?? ?? ?? C7 04 24 12 00 00 00 89 55 A8 E8 ?? ?? ?? ?? 85 F6 89 C7 0F 84 01 05 00 00 89 34 24 E8 ?? ?? ?? ?? 89 C3 8B 55 A8 8D 54 13 02 81 FA 00 10 00 00 89 55 A0 0F 87 B3 05 00 00 89 E2 8B 45 A0 83 C0 1E 83 E0 F0 29 C4 8D 44 24 23 83 E0 F0 29 E2 89 55 84 89 45 9C C7 45 80 01 00 00 00 83 C3 01 B8 ?? ?? ?? ?? 8B 55 A8 85 F6 0F 44 F0 8B 45 B0 89 54 24 08 89 44 24 04 8B 45 9C 89 04 24 E8 ?? ?? ?? ?? C6 00 2F 83 C0 01 89 5C 24 08 89 74 24 04 89 04 24 E8 ?? ?? ?? ?? 8B 55 10 C7 45 A8 00 00 00 00 F7 DA 83 E2 03 89 55 8C 8D B6 00 00 00 00 83 FF FF 0F 84 C7 00 00 00 8B 4D A0 8B 45 9C 8B 55 08 C7 44 24 10 18 00 00 00 89 7C 24 0C 89 4C 24 08 89 44 24 04 89 14 24 E8 ?? ?? ?? ?? 85 C0 0F 84 9A 00 00 00 8B 50 18 8D 48 30 89 4D B4 8B 48 20 8B 70 2C 8B 58 28 89 55 D0 8B 50 1C 89 4D D8 03 4D B4 89 55 D4 8B 50 24 89 75 E4 8B 75 BC 89 5D E0 01 D1 89 55 DC 8B 50 04 89 4D A4 89 55 AC 8B 17 8B 4A 08 89 4D B0 B9 FE FF FF FF 39 75 B0 0F 84 39 01 00 00 C7 45 AC 01 00 00 00 8B 42 08 39 F0 0F 85 1C 04 00 00 89 CE F0 83 6F 0C 01 0F 84 DA 00 00 00 8B 55 AC 85 D2 0F 84 E2 00 00 00 8D B4 26 00 00 00 00 8B 45 80 85 C0 0F 84 E6 00 00 00 8D 65 F4 89 F0 5B 5E 5F 5D C3 8D 76 00 8D 45 D0 8B 55 08 89 44 24 0C 8B 4D A0 8B 45 9C C7 44 24 10 18 00 00 00 89 54 24 08 89 4C 24 04 89 04 24 E8 ?? ?? ?? ?? 83 F8 FF 89 45 B0 0F 84 44 03 00 00 C7 45 94 FF FF FF FF C7 45 98 00 00 00 00 C7 45 A4 00 00 00 00 C7 45 AC 00 00 00 00 C7 45 B4 00 00 00 00 8B 45 D4 8B 55 18 83 F8 FF C7 02 00 00 00 00 0F 84 E2 03 00 00 83 F8 01 0F 84 AB 00 00 00 A1 ?? ?? ?? ?? 31 C9 65 C7 00 00 00 00 00 83 7D B0 FF 74 0E 8B 5D B0 B8 06 00 00 00 FF 15 ?? ?? ?? ?? 83 FF FF 0F 84 D0 00 00 00 8B 17 8B 75 BC E9 14 FF FF FF 8D B6 00 00 00 00 89 3C 24 E8 ?? ?? ?? ?? 8B 55 AC 85 D2 0F 85 25 FF FF FF 8B 45 A4 89 04 24 E8 ?? ?? ?? ?? 8B 45 80 85 C0 0F 85 1A FF FF FF 8B 45 9C 89 04 24 E8 ?? ?? ?? ?? 8D 65 F4 89 F0 5B 5E 5F 5D C3 66 90 8B 4D A4 8D 1C 99 89 5D 98 8B 5D AC 8D 44 18 18 39 45 98 89 45 94 0F 87 56 03 00 00 C7 45 AC 01 00 00 00 C7 45 B0 FF FF FF FF E9 38 FF FF FF 90 8B 4D D8 8B 75 DC 8B 55 8C 8B 45 10 8D 1C 0E 01 DA 89 5D 90 8B 5D E0 01 D0 F7 D8 83 E0 03 89 5D 88 8D 1C 9D 04 00 00 00 01 DA 01 C2 3B 55 14 89 9D 78 FF FF FF 76 21 A1 ?? ?? ?? ?? B9 22 00 00 00 65 C7 00 22 00 00 00 E9 16 FF FF FF 8D 76 00 89 CE E9 5F FE FF FF 90 8B 5D 0C 01 C6 8B 55 10 03 55 8C 8B 45 E4 89 53 04 8B 9D 78 FF FF FF 01 D3 8B 55 0C 01 D9 01 CE 89 42 08 8B 45 B4 89 1A 89 4A 0C 85 C0 0F 84 25 01 00 00 8B 4D 90 8B 45 B4 89 1C 24 89 4C 24 08 89 44 24 04 E8 ?? ?? ?? ?? 8B 4D E0 85 C9 0F 8E D5 01 00 00 C1 E1 02 31 C0 89 7D 90 8B 7D 0C 31 DB 89 4D B4 8B 4D A4 90 8B 57 04 03 1C 01 89 34 02 03 34 01 83 C0 04 3B 45 B4 75 EC 8B 7D 90 8B 4D B4 8B 55 0C 8B 42 04 C7 04 08 00 00 00 00 8B 45 98 01 D8 39 45 94 0F 82 B3 02 00 00 8B 45 10 03 45 14 39 C6 0F 87 82 02 00 00 8B 75 98 85 F6 0F 84 32 01 00 00 8B 55 0C 8B 4D 98 8B 42 04 8B 00 89 4C 24 04 89 5C 24 08 89 04 24 E8 ?? ?? ?? ?? 8B 4D 0C 8B 45 D8 8B 11 80 7C 02 FF 00 74 18 8B 07 31 C9 8B 40 08 3B 45 BC 0F 94 C1 83 E9 02 E9 16 FE FF FF 8D 76 00 8B 51 0C 8B 45 DC 80 7C 02 FF 00 75 DB 8B 75 E0 85 F6 7E 37 8B 59 04 8B 4D A4 8B 13 8B 01 80 7C 02 FF 00 75 C3 89 7D B4 31 C0 89 CF EB 13 66 90 8B 0C 83 8B 14 87 80 7C 11 FF 00 0F 85 22 01 00 00 83 C0 01 39 F0 75 E8 8B 7D B4 8B 4D 0C 8B 55 18 89 0A 31 C9 E9 B9 FD FF FF 8D B6 00 00 00 00 8B 45 88 89 5D C0 8B 5D 90 85 C0 89 5D C4 0F 8E F7 00 00 00 8B 45 AC 85 C0 0F 85 1C 02 00 00 8B 5D 88 8B 45 84 C1 E3 02 01 D8 3D 00 10 00 00 0F 87 D8 01 00 00 89 E2 8D 43 1E 83 E0 F0 29 C4 8D 44 24 23 83 E0 F0 29 E2 01 55 84 89 45 A4 C7 45 AC 01 00 00 00 8B 45 A4 89 5D CC 03 5D 90 89 45 C8 B8 02 00 00 00 8B 55 B0 89 44 24 08 8D 45 C0 89 44 24 04 89 14 24 E8 ?? ?? ?? ?? B9 FF FF FF FF 39 D8 0F 85 2A FD FF FF E9 63 FE FF FF 66 90 85 DB 75 46 8B 4D 18 8B 55 0C 89 11 31 C9 E9 10 FD FF FF 90 8D 74 26 00 C7 05 ?? ?? ?? ?? 01 00 00 00 B9 FF FF FF FF C7 45 A4 00 00 00 00 C7 45 AC 00 00 00 00 E9 FD FC FF FF 31 DB E9 02 FB FF FF 31 C9 31 DB E9 50 FE FF FF 8B 4D 0C 89 5C 24 08 8B 41 04 8B 00 89 44 24 04 8B 45 B0 89 04 24 E8 ?? ?? ?? ?? 39 D8 74 9B B9 FF FF FF FF E9 B0 FC FF FF 8B 7D B4 E9 7D FE FF FF B8 01 00 00 00 E9 51 FF FF FF A8 01 89 45 BC 75 2C 83 45 A8 01 83 7D A8 05 74 22 83 F9 FF 74 1D 8B 4D AC 85 C9 0F 85 2A FB FF FF 8B 45 A4 89 04 24 E8 ?? ?? ?? ?? E9 1A FB FF FF 66 90 F0 83 6F 0C 01 74 19 83 F9 FF 8D B6 00 00 00 00 0F 84 42 FD FF FF BF FF FF FF FF EB C6 8D 76 00 89 3C 24 89 8D 7C FF FF FF E8 ?? ?? ?? ?? 8B 8D 7C FF FF FF EB D1 C7 05 ?? ?? ?? ?? 01 00 00 00 B9 FF FF FF FF E9 21 FC FF FF B9 FF FF FF FF E9 4B FB FF FF 89 14 24 E8 ?? ?? ?? ?? 85 C0 0F 85 3D FA FF FF 8B 4D A0 89 0C 24 E8 ?? ?? ?? ?? 85 C0 89 45 9C 0F 84 9D 00 00 00 C7 45 80 00 00 00 00 C7 45 84 00 00 00 00 E9 37 FA FF FF 8B 45 98 85 C0 0F 84 A7 FC FF FF 8B 07 B9 FE FF FF FF 8B 40 08 3B 45 BC 0F 85 C0 FB FF FF E9 8F FC FF FF 8B 45 98 85 C0 0F 85 85 FD FF FF 90 8D 74 26 00 E9 EC FE FF FF 89 04 24 E8 ?? ?? ?? ?? 85 C0 90 0F 85 17 FE FF FF 89 1C 24 E8 ?? ?? ?? ?? 85 C0 89 45 A4 0F 85 24 FE FF FF B9 0C 00 00 00 E9 78 FB FF FF C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 F8 00 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? BE FF FF FF FF E9 BA FA FF FF }
	condition:
		$1
}

rule file_408_1_0 {
	meta:
		name = "__nscd_getservbyname_r"
		size = 119
		refs = "0037 strlen"
	strings:
		$1 = { 83 EC 3C 89 5C 24 2C 8B 5C 24 40 8B 4C 24 44 8B 54 24 54 89 74 24 30 8B 74 24 50 89 1C 24 89 7C 24 34 8B 7C 24 48 89 6C 24 38 8B 6C 24 4C 89 54 24 1C 89 4C 24 18 E8 ?? ?? ?? ?? 8B 54 24 1C 89 74 24 4C 8B 4C 24 18 89 6C 24 48 8B 74 24 30 89 7C 24 44 8B 6C 24 38 89 54 24 50 8B 7C 24 34 C7 44 24 40 10 00 00 00 89 C2 89 D8 8B 5C 24 2C 83 C4 3C E9 99 F8 FF FF }
	condition:
		$1
}

rule file_408_2_0 {
	meta:
		name = "__nscd_getservbyport_r"
		size = 102
		refs = "0028 _itoa_word"
	strings:
		$1 = { 83 EC 3C 8D 44 24 2F 89 44 24 04 8B 44 24 40 C7 44 24 0C 00 00 00 00 C7 44 24 08 0A 00 00 00 C6 44 24 2F 00 89 04 24 E8 ?? ?? ?? ?? 8B 4C 24 54 8D 54 24 30 C7 04 24 11 00 00 00 89 4C 24 10 8B 4C 24 50 29 C2 89 4C 24 0C 8B 4C 24 4C 89 4C 24 08 8B 4C 24 48 89 4C 24 04 8B 4C 24 44 E8 2E F8 FF FF 83 C4 3C C3 }
	condition:
		$1
}

rule file_408_3_0 {
	meta:
		name = "serv_map_free"
		size = 36
		refs = "0001 __serv_map_handle 001b free"
	strings:
		$1 = { A1 ?? ?? ?? ?? 83 F8 FF 74 18 83 EC 1C 89 04 24 C7 05 ?? ?? ?? ?? FF FF FF FF E8 ?? ?? ?? ?? 83 C4 1C F3 C3 }
	condition:
		$1
}

rule file_773_3_0 {
	meta:
		name = "gr_map_free"
		size = 36
		refs = "0001 __gr_map_handle 001b free"
	strings:
		$1 = { A1 ?? ?? ?? ?? 83 F8 FF 74 18 83 EC 1C 89 04 24 C7 05 ?? ?? ?? ?? FF FF FF FF E8 ?? ?? ?? ?? 83 C4 1C F3 C3 }
	condition:
		$1
}

rule file_823_5_0 {
	meta:
		name = "hst_map_free"
		size = 36
		refs = "0001 __hst_map_handle 001b free"
	strings:
		$1 = { A1 ?? ?? ?? ?? 83 F8 FF 74 18 83 EC 1C 89 04 24 C7 05 ?? ?? ?? ?? FF FF FF FF E8 ?? ?? ?? ?? 83 C4 1C F3 C3 }
	condition:
		$1
}

rule file_454_3_0 {
	meta:
		name = "pw_map_free"
		size = 36
		refs = "001b free"
	strings:
		$1 = { A1 ?? ?? ?? ?? 83 F8 FF 74 18 83 EC 1C 89 04 24 C7 05 ?? ?? ?? ?? FF FF FF FF E8 ?? ?? ?? ?? 83 C4 1C F3 C3 }
	condition:
		$1
}

rule file_409_0_0 {
	meta:
		name = "inet_nsap_addr"
		size = 242
		refs = "0054 __libc_tsd_CTYPE_TOUPPER 005d __libc_tsd_CTYPE_B"
	strings:
		$1 = { 55 31 C0 57 56 53 83 EC 04 8B 54 24 18 0F B6 1A 8D 4A 01 84 DB 0F 84 C1 00 00 00 90 8D 74 26 00 3B 44 24 20 0F 83 B2 00 00 00 80 FB 2B 0F 84 99 00 00 00 80 FB 2E 0F 84 90 00 00 00 80 FB 2F 90 0F 84 86 00 00 00 0F B6 CB F6 C1 80 0F 85 96 00 00 00 8B 1D ?? ?? ?? ?? 65 8B 33 8B 1D ?? ?? ?? ?? 0F B6 2C 8E 65 8B 1B F6 44 6B 01 10 89 1C 24 74 76 8D 4D D0 0F B6 7A 01 89 EB 83 F9 0A 19 C9 83 E1 F9 83 C1 37 29 CB 8D 4A 02 89 FA 84 D2 89 DD 74 55 81 E7 FF 00 00 00 8B 1C 24 0F B6 14 BE F6 44 53 01 10 74 41 8D 5A D0 C1 E5 04 83 FB 0A 19 DB 83 C0 01 83 E3 F9 83 C3 37 29 DA 8B 5C 24 1C 09 EA 88 13 83 C3 01 89 5C 24 1C 89 CA 0F B6 1A 8D 4A 01 84 DB 0F 85 44 FF FF FF 83 C4 04 5B 5E 5F 5D C3 8D 74 26 00 83 C4 04 31 C0 5B 5E 5F 5D C3 }
	condition:
		$1
}

rule file_409_1_0 {
	meta:
		name = "inet_nsap_ntoa"
		size = 185
	strings:
		$1 = { 55 57 56 BE 37 00 00 00 53 83 EC 04 8B 54 24 20 8B 44 24 18 C7 04 24 FF 00 00 00 8B 7C 24 1C 85 D2 BA ?? ?? ?? ?? 0F 45 54 24 20 3D FF 00 00 00 0F 4F 04 24 89 54 24 20 89 D1 89 04 24 8B 1C 24 B8 01 00 00 00 85 DB 7E 48 8D B4 26 00 00 00 00 0F B6 54 07 FF C0 EA 04 0F B6 EA 83 FD 09 BD 30 00 00 00 0F 4F EE 01 EA 88 11 0F B6 54 07 FF 83 E2 0F 0F B6 EA 83 FD 09 BD 30 00 00 00 0F 4F EE 01 EA A8 01 88 51 01 8D 51 02 74 14 3B 04 24 7C 1F C6 02 00 8B 44 24 20 83 C4 04 5B 5E 5F 5D C3 3B 04 24 7D EC 83 C0 01 89 D1 EB A4 8D 74 26 00 C6 41 02 2E 8D 51 03 EB EC }
	condition:
		$1
}

rule file_410_0_0 {
	meta:
		name = "read_int"
		size = 95
	strings:
		$1 = { 55 BD FF FF FF 7F 57 56 53 8B 08 8B 11 83 EA 30 83 C1 04 8B 19 83 EB 30 83 FB 09 77 2E 85 D2 78 EF 81 FA CC CC CC 0C 7F 2F 8D 34 92 89 EF 01 F6 29 DF BA FF FF FF FF 01 F3 39 FE 0F 4E D3 83 C1 04 8B 19 83 EB 30 83 FB 09 76 D2 89 08 89 D0 5B 5E 5F 5D C3 8D 74 26 00 BA FF FF FF FF EB B1 }
	condition:
		$1
}

rule file_410_1_0 {
	meta:
		name = "__parse_one_specwc"
		size = 1437
		refs = "00b2 __printf_modifier_table 00ec __handle_registered_modifier_wc 0109 __printf_function_table 0165 __wcschrnul 0557 __printf_arginfo_table"
	strings:
		$1 = { 55 57 56 53 83 EC 1C 8B 4C 24 30 8B 5C 24 38 8D 71 04 89 CF 89 74 24 30 0F B6 43 0D 89 F1 0F B6 53 0C C7 43 24 FF FF FF FF C7 43 10 20 00 00 00 83 E0 F6 83 C8 04 83 E2 07 88 53 0C 88 43 0D 8B 47 04 8D 68 D0 83 FD 09 0F 86 D2 01 00 00 66 90 83 E8 20 83 F8 29 0F 86 1C 01 00 00 89 4C 24 30 83 E2 20 74 07 C7 43 10 20 00 00 00 C7 43 20 FF FF FF FF C7 43 04 00 00 00 00 8B 06 83 F8 2A 0F 84 1B 02 00 00 83 E8 30 31 ED 83 F8 09 0F 86 3D 02 00 00 C7 43 1C FF FF FF FF C7 03 FF FF FF FF 83 3E 2E 0F 84 C7 01 00 00 80 63 0C F8 80 63 0D FD A1 ?? ?? ?? ?? 66 C7 43 0E 00 00 85 C0 75 18 8B 3E 8D 4E 04 89 4C 24 30 8D 47 B4 83 F8 2E 77 37 FF 24 85 ?? ?? ?? ?? 8B 16 83 3C 90 00 74 E0 8D 54 24 30 89 5C 24 04 89 14 24 E8 ?? ?? ?? ?? 85 C0 0F 85 9C 04 00 00 8B 4C 24 30 8B 39 83 C1 04 8D B4 26 00 00 00 00 A1 ?? ?? ?? ?? 89 7B 08 89 4C 24 30 C7 43 30 FF FF FF FF 85 C0 0F 85 27 04 00 00 8D 47 BF 83 F8 37 C7 43 2C 01 00 00 00 0F 86 BA 00 00 00 C7 43 2C 00 00 00 00 8D 76 00 83 7B 24 FF 0F 84 06 01 00 00 85 FF 8B 44 24 30 0F 84 B2 00 00 00 89 43 14 C7 44 24 04 25 00 00 00 89 04 24 E8 ?? ?? ?? ?? 89 43 18 83 C4 1C 89 E8 5B 5E 5F 5D C3 66 90 FF 24 85 ?? ?? ?? ?? 90 80 4B 0D 08 8D 74 26 00 8B 46 04 8D 4E 04 85 C0 74 26 89 CE E9 B7 FE FF FF 8D B4 26 00 00 00 00 C7 43 10 30 00 00 00 8B 46 04 8D 4E 04 85 C0 75 E1 8D B4 26 00 00 00 00 89 4C 24 30 89 CE E9 9D FE FF FF 90 8D 74 26 00 83 CA 20 88 53 0C EB B8 83 CA 40 88 53 0C EB B0 83 CA 80 88 53 0C EB A8 83 CA 08 88 53 0C EB A0 83 CA 10 88 53 0C EB 98 FF 24 85 ?? ?? ?? ?? 90 80 63 0C FA 8B 7E 04 8D 4E 08 E9 01 FF FF FF 90 83 E8 04 89 43 18 89 43 14 83 C4 1C 89 E8 5B 5E 5F 5D C3 90 8D 74 26 00 8D 44 24 30 E8 77 FD FF FF 85 C0 74 0D 8B 54 24 30 83 3A 24 0F 84 6E 02 00 00 89 74 24 30 8B 47 04 89 F1 0F B6 53 0C E9 04 FE FF FF 8D 74 26 00 8B 43 2C 85 C0 0F 84 EF FE FF FF 8B 4C 24 34 01 C5 89 4B 24 E9 E1 FE FF FF 8D B4 26 00 00 00 00 8B 46 04 8D 56 04 89 54 24 30 83 F8 2A 0F 84 DD 01 00 00 83 E8 30 83 F8 09 0F 86 19 01 00 00 C7 03 00 00 00 00 89 D6 E9 0D FE FF FF 8D 74 26 00 8B 46 04 8D 7E 04 89 7C 24 30 83 E8 30 83 F8 09 76 3E 8B 44 24 34 89 FE BD 01 00 00 00 89 7C 24 30 89 43 20 83 C0 01 89 44 24 34 E9 C3 FD FF FF 8D 44 24 30 E8 C7 FC FF FF 83 F8 FF 74 03 89 43 04 8B 74 24 30 E9 A9 FD FF FF 8D B6 00 00 00 00 8D 44 24 30 E8 A7 FC FF FF 85 C0 74 2B 8B 54 24 30 83 3A 24 75 22 83 F8 FF 74 13 8B 74 24 3C 8D 48 FF 89 4B 20 8B 0E 39 C8 0F 42 C1 89 06 83 C2 04 89 54 24 30 8D 76 00 8B 43 20 85 C0 78 83 8B 74 24 30 31 ED E9 59 FD FF FF 8D B6 00 00 00 00 0F B6 53 0C 8D 4E 08 83 CA 04 88 53 0C 8B 7E 04 83 FF 6C 0F 85 AF FD FF FF EB 39 90 8D 74 26 00 83 7E 04 68 0F 84 77 01 00 00 80 4B 0C 02 8B 7E 04 8D 4E 08 E9 8F FD FF FF 8D B4 26 00 00 00 00 80 4B 0C 05 8B 7E 04 8D 4E 08 E9 79 FD FF FF 90 0F B6 53 0C 83 CA 01 83 C1 04 88 53 0C 8B 79 FC E9 63 FD FF FF 8D 76 00 8D 44 24 30 E8 EF FB FF FF 83 F8 FF 74 02 89 03 8B 74 24 30 E9 E8 FC FF FF 8D B4 26 00 00 00 00 0F B6 43 0C 83 E0 01 3C 01 19 C0 30 C0 05 07 01 00 00 89 43 28 E9 5E FD FF FF 8D B6 00 00 00 00 C7 43 28 01 00 00 00 E9 4C FD FF FF 8D 74 26 00 C7 43 28 00 08 00 00 E9 3C FD FF FF 8D 74 26 00 C7 43 28 05 00 00 00 E9 2C FD FF FF 8D 74 26 00 C7 43 28 03 00 00 00 E9 1C FD FF FF 8D 74 26 00 C7 43 28 04 00 00 00 E9 0C FD FF FF 8D 74 26 00 0F B6 43 0C A8 01 74 50 C7 43 28 00 01 00 00 E9 F4 FC FF FF 8D 74 26 00 C7 43 28 02 00 00 00 E9 E4 FC FF FF 8D 74 26 00 8B 46 08 8D 7E 08 89 7C 24 30 83 E8 30 83 F8 09 76 7E 8B 44 24 34 83 C5 01 89 FE 89 7C 24 30 89 43 1C 83 C0 01 89 44 24 34 E9 1B FC FF FF 66 90 A8 04 75 41 A8 02 0F 84 7C 00 00 00 C7 43 28 00 04 00 00 E9 98 FC FF FF 8D 72 04 83 F8 FF 89 74 24 30 74 13 8B 7C 24 3C 8D 48 FF 89 4B 24 8B 0F 39 C8 0F 42 C1 89 07 8B 42 04 89 F1 0F B6 53 0C E9 7B FB FF FF C7 43 28 00 02 00 00 E9 5F FC FF FF 80 4B 0D 02 8B 7E 08 8D 4E 0C E9 18 FC FF FF 8D 44 24 30 E8 A7 FA FF FF 85 C0 74 09 8B 54 24 30 83 3A 24 74 23 8B 43 1C 85 C0 0F 89 A7 FE FF FF E9 5C FF FF FF 66 90 31 C0 F6 43 0D 02 0F 95 C0 89 43 28 E9 17 FC FF FF 83 F8 FF 74 13 8B 74 24 3C 8D 48 FF 89 4B 1C 8B 0E 39 C8 0F 42 C1 89 06 83 C2 04 89 54 24 30 EB BC 81 FF FF 00 00 00 0F 8F CD FB FF FF A1 ?? ?? ?? ?? 8B 04 B8 85 C0 0F 84 BD FB FF FF 8D 53 30 89 54 24 0C 8D 53 28 89 54 24 08 C7 44 24 04 01 00 00 00 89 1C 24 FF D0 8B 7B 08 85 C0 89 43 2C 0F 89 B1 FB FF FF E9 8F FB FF FF 8B 74 24 30 E9 23 FB FF FF }
	condition:
		$1
}

rule file_411_0_0 {
	meta:
		name = "ttyslot"
		size = 183
		refs = "0011 __sysconf 002d setttyent 0044 __ttyname_r 0055 endttyent 0079 strrchr 0092 strcmp 009e getttyent"
	strings:
		$1 = { 55 89 E5 57 56 53 83 EC 1C C7 04 24 48 00 00 00 E8 ?? ?? ?? ?? 89 C6 B8 20 00 00 00 83 C6 01 0F 44 F0 31 DB 8D 46 1E 83 E0 F0 29 C4 E8 ?? ?? ?? ?? 8D 7C 24 1B 83 E7 F0 89 74 24 08 89 7C 24 04 89 1C 24 E8 ?? ?? ?? ?? 85 C0 74 1C 83 C3 01 83 FB 03 75 E4 E8 ?? ?? ?? ?? 31 DB 8D 65 F4 89 D8 5B 5E 5F 5D C3 8D 76 00 C7 44 24 04 2F 00 00 00 BB 01 00 00 00 89 3C 24 E8 ?? ?? ?? ?? 8D 70 01 85 C0 0F 44 F7 EB 16 90 89 74 24 04 8B 00 89 04 24 E8 ?? ?? ?? ?? 85 C0 74 0E 83 C3 01 E8 ?? ?? ?? ?? 85 C0 75 E2 EB AC 90 8D B4 26 00 00 00 00 E8 ?? ?? ?? ?? EB A4 }
	condition:
		$1
}

rule file_412_0_0 {
	meta:
		name = "__atomic_pwritev_replacement"
		size = 342
		refs = "00a8 mempcpy 00cc __pwrite 00da free 00f1 __libc_errno 0119 __libc_alloca_cutoff 012f malloc"
	strings:
		$1 = { 55 89 E5 57 56 53 83 EC 3C 85 C9 89 45 DC 89 4D E4 0F 8E F4 00 00 00 8B 4A 04 81 F9 FF FF FF 7F 0F 87 CA 00 00 00 31 C0 31 DB BF FF FF FF 7F EB 17 8D B4 26 00 00 00 00 8B 4C C2 04 89 FE 29 DE 39 CE 0F 82 A8 00 00 00 01 CB 83 C0 01 3B 45 E4 75 E6 81 FB 00 10 00 00 0F 87 B4 00 00 00 8D 43 1E 83 E0 F0 29 C4 8D 44 24 1F 83 E0 F0 89 45 E0 8B 45 E4 C7 45 D8 00 00 00 00 85 C0 7E 35 31 F6 8B 45 E0 89 D7 89 5D D4 89 F3 8B 75 E4 8D 76 00 8B 4F 04 83 C3 01 83 C7 08 89 4C 24 08 8B 4F F8 89 04 24 89 4C 24 04 E8 ?? ?? ?? ?? 39 F3 75 E0 8B 5D D4 8B 45 08 89 5C 24 08 89 44 24 0C 8B 45 E0 89 44 24 04 8B 45 DC 89 04 24 E8 ?? ?? ?? ?? 8B 55 D8 89 45 D0 89 14 24 E8 ?? ?? ?? ?? 8B 45 D0 8D 65 F4 5B 5E 5F 5D C2 04 00 90 8D 74 26 00 A1 ?? ?? ?? ?? 65 C7 00 16 00 00 00 8D 65 F4 B8 FF FF FF FF 5B 5E 5F 5D C2 04 00 31 DB E9 4C FF FF FF 89 1C 24 89 55 D0 E8 ?? ?? ?? ?? 8B 55 D0 85 C0 0F 85 36 FF FF FF 89 1C 24 89 55 D0 E8 ?? ?? ?? ?? 8B 55 D0 85 C0 89 45 E0 74 08 89 45 D8 E9 39 FF FF FF C7 45 D8 00 00 00 00 B8 FF FF FF FF E9 7A FF FF FF }
	condition:
		$1
}

rule file_412_1_0 {
	meta:
		name = "pwritev"
		size = 257
		refs = "0045 _dl_sysinfo 0071 __libc_errno 0097 __libc_enable_asynccancel 00d1 __libc_disable_asynccancel"
	strings:
		$1 = { 83 EC 3C 89 5C 24 2C 8B 54 24 48 89 74 24 30 8B 5C 24 40 89 7C 24 34 8B 74 24 4C 89 6C 24 38 65 A1 0C 00 00 00 85 C0 75 69 89 F0 8B 4C 24 44 C1 F8 1F 89 44 24 14 8B 7C 24 14 89 74 24 10 B8 4E 01 00 00 FF 15 ?? ?? ?? ?? 3D 00 F0 FF FF 0F 87 8A 00 00 00 89 C7 85 FF 78 16 89 F8 8B 5C 24 2C 8B 74 24 30 8B 7C 24 34 8B 6C 24 38 83 C4 3C C3 A1 ?? ?? ?? ?? 65 83 38 26 75 DF 89 D1 8B 54 24 44 89 D8 89 34 24 E8 15 FE FF FF 83 EC 04 89 C7 EB C8 89 54 24 18 E8 ?? ?? ?? ?? 8B 54 24 18 89 74 24 10 8B 4C 24 44 89 C5 89 F0 C1 F8 1F 89 44 24 14 8B 7C 24 14 B8 4E 01 00 00 FF 15 ?? ?? ?? ?? 3D 00 F0 FF FF 77 29 89 C7 89 E8 89 54 24 18 E8 ?? ?? ?? ?? 8B 54 24 18 E9 78 FF FF FF 8B 0D ?? ?? ?? ?? F7 D8 83 CF FF 65 89 01 E9 65 FF FF FF 8B 0D ?? ?? ?? ?? F7 D8 65 89 01 83 C8 FF EB C7 }
	condition:
		$1
}

rule file_413_2_0 {
	meta:
		name = "fwide"
		size = 229
		refs = "0088 _IO_fwide"
	strings:
		$1 = { 83 EC 1C 83 7C 24 24 00 89 5C 24 10 8B 5C 24 20 89 74 24 14 89 7C 24 18 0F 8C A2 00 00 00 75 18 8B 53 68 89 D0 8B 5C 24 10 8B 74 24 14 8B 7C 24 18 83 C4 1C C3 8D 76 00 BE 01 00 00 00 8B 53 68 85 D2 75 DF 8B 03 25 00 80 00 00 75 2E 8B 53 48 65 8B 3D 08 00 00 00 3B 7A 08 74 1B B9 01 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 0A 75 74 8B 53 48 89 7A 08 83 42 04 01 83 FE FF 74 50 89 74 24 04 89 1C 24 E8 ?? ?? ?? ?? F7 03 00 80 00 00 89 C2 75 8D 8B 4B 48 83 69 04 01 75 84 C7 41 08 00 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 83 29 01 75 38 E9 68 FF FF FF 90 8D 74 26 00 BE FF FF FF FF E9 73 FF FF FF 8D B6 00 00 00 00 8B 43 68 85 C0 75 B5 C7 43 68 FF FF FF FF B8 FF FF FF FF EB A7 }
	condition:
		$1
}

rule file_414_0_0 {
	meta:
		name = "calc_sizes"
		size = 125
	strings:
		$1 = { 56 53 89 D3 83 EC 04 8B 08 8B 70 10 85 C9 74 60 83 42 08 01 31 C0 EB 03 83 C0 01 83 C1 18 8B 51 EC 85 D2 75 F3 8B 51 E8 85 D2 75 EC 8B 51 F8 85 D2 75 E5 8B 51 FC 85 D2 75 DE 8D 14 40 01 43 04 01 13 85 F6 74 1E 8B 06 85 C0 74 18 8D 74 26 00 89 DA 83 C6 10 E8 A6 FF FF FF 83 43 0C 01 8B 06 85 C0 75 EC 83 C4 04 5B 5E C3 8D B6 00 00 00 00 8B 48 04 85 C9 74 CB 83 42 08 01 EB C5 }
	condition:
		$1
}

rule file_414_1_0 {
	meta:
		name = "argp_default_parser"
		size = 282
		refs = "004d __argp_state_help 006d program_invocation_name 0072 strrchr 0088 program_invocation_short_name 00d6 strtol 00f0 __sleep"
	strings:
		$1 = { 56 53 83 EC 14 8B 44 24 20 8B 74 24 24 8B 5C 24 28 83 F8 FD 0F 84 8E 00 00 00 7F 14 83 F8 FC 0F 84 93 00 00 00 83 C4 14 B8 07 00 00 00 5B 5E C3 83 F8 FE 74 2B 83 F8 3F 75 EB C7 44 24 08 7A 02 00 00 8B 43 30 89 1C 24 89 44 24 04 E8 ?? ?? ?? ?? 83 C4 14 31 C0 5B 5E C3 8D B4 26 00 00 00 00 C7 44 24 04 2F 00 00 00 89 34 24 89 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 89 43 28 0F 84 8F 00 00 00 83 C0 01 89 43 28 A3 ?? ?? ?? ?? 8B 43 10 83 E0 03 83 F8 01 75 05 8B 43 08 89 30 31 C0 83 C4 14 5B 5E C3 8D 74 26 00 C7 44 24 08 01 02 00 00 EB 90 8D B6 00 00 00 00 85 F6 B8 ?? ?? ?? ?? 0F 44 F0 C7 44 24 08 0A 00 00 00 C7 44 24 04 00 00 00 00 89 34 24 E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? EB 13 8D B4 26 00 00 00 00 C7 04 24 01 00 00 00 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 8D 50 FF 85 C0 89 15 ?? ?? ?? ?? 7F E2 31 C0 EB 94 8D B6 00 00 00 00 89 73 28 89 F0 E9 6D FF FF FF }
	condition:
		$1
}

rule file_414_2_0 {
	meta:
		name = "convert_options"
		size = 679
		refs = "0068 __libc_tsd_CTYPE_B 00d8 strcmp"
	strings:
		$1 = { 55 57 56 53 83 EC 3C 89 44 24 20 89 54 24 24 89 C2 8B 00 89 4C 24 28 8B 6A 10 85 C0 0F 84 6E 02 00 00 89 6C 24 2C 89 C3 89 C5 8D B6 00 00 00 00 8B 53 04 85 D2 75 0A 8B 3B 85 FF 0F 84 57 01 00 00 8B 43 0C A8 04 0F 85 1C 01 00 00 89 C1 89 DD 83 E1 08 0F 85 07 01 00 00 A8 08 75 50 8D 42 FF 3D FE 00 00 00 77 46 A1 ?? ?? ?? ?? 65 8B 00 F6 44 50 01 40 74 37 8B 74 24 54 8B 4E 04 8D 41 01 88 11 89 46 04 8B 75 08 85 F6 74 1E 8B 74 24 54 8D 41 02 C6 41 01 3A F6 45 0C 01 89 46 04 74 0A 8D 41 03 C6 41 02 3A 89 46 04 C6 00 00 8B 33 85 F6 0F 84 A9 00 00 00 8B 54 24 54 8B 12 8B 4A 08 89 54 24 1C 8B 01 89 4C 24 18 85 C0 74 1F 89 CF 89 74 24 04 89 04 24 E8 ?? ?? ?? ?? 85 C0 0F 84 8C 00 00 00 83 C7 10 8B 07 85 C0 75 E3 8B 54 24 54 8B 42 08 8B 55 08 89 30 85 D2 0F 84 8E 00 00 00 8B 55 0C 83 E2 01 83 FA 01 19 D2 83 C2 02 8B 4B 04 89 50 04 C7 40 08 00 00 00 00 85 C9 0F 84 64 01 00 00 8B 74 24 1C 81 E1 FF FF FF 00 8B 54 24 50 2B 56 34 C1 FA 02 69 D2 39 8E E3 38 83 C2 01 C1 E2 18 01 CA 8B 4C 24 54 89 50 0C 8D 50 10 89 51 08 C7 40 10 00 00 00 00 8D B6 00 00 00 00 83 C3 18 E9 C8 FE FF FF 8B 4D 0C E9 E0 FE FF FF 89 FA 2B 54 24 18 83 FA F1 7D E5 8B 54 24 54 8B 42 08 8B 55 08 89 30 85 D2 0F 85 72 FF FF FF 31 D2 E9 79 FF FF FF 66 90 8B 73 10 85 F6 0F 85 9E FE FF FF 8B 4B 14 85 C9 0F 85 93 FE FF FF 8B 74 24 20 8B 6C 24 2C 8B 46 04 8B 54 24 50 85 ED 8B 4C 24 50 8B 74 24 28 89 02 8B 44 24 20 89 42 04 8B 54 24 54 8B 42 04 8B 54 24 24 C7 41 0C 00 00 00 00 89 71 14 89 41 08 89 51 10 C7 41 18 00 00 00 00 C7 41 20 00 00 00 00 C7 41 1C 00 00 00 00 74 34 8B 55 00 31 C0 85 D2 74 18 90 8D 74 26 00 83 C0 01 89 C2 C1 E2 04 8B 7C 15 00 85 FF 75 F0 C1 E0 02 8B 4C 24 54 8B 74 24 50 8B 51 0C 89 56 1C 01 C2 89 51 0C 8B 44 24 50 8B 74 24 50 83 C0 24 85 ED 74 34 8B 7D 00 85 FF 74 2D 89 C2 89 F8 8B 7C 24 54 31 C9 66 90 89 14 24 89 F2 83 C5 10 89 7C 24 04 8D 59 01 E8 94 FD FF FF 89 D9 89 C2 8B 45 00 85 C0 75 E1 89 D0 83 C4 3C 5B 5E 5F 5D C3 8D B4 26 00 00 00 00 8B 4D 04 E9 94 FE FF FF 8B 4C 24 20 8B 41 04 85 C0 0F 85 1A FF FF FF 8B 44 24 50 31 F6 EB 9A }
	condition:
		$1
}

rule file_414_3_0 {
	meta:
		name = "argp_version_parser"
		size = 167
		refs = "0021 argp_program_version_hook 0049 argp_program_version 0064 fprintf 0089 __dcgettext 0095 __argp_error 00a3 exit"
	strings:
		$1 = { 53 B8 07 00 00 00 83 EC 18 83 7C 24 20 56 8B 5C 24 28 74 0C 83 C4 18 5B C3 8D B4 26 00 00 00 00 A1 ?? ?? ?? ?? 85 C0 74 1F 89 5C 24 04 8B 53 30 89 14 24 FF D0 F6 43 10 20 74 60 83 C4 18 31 C0 5B C3 8D B6 00 00 00 00 A1 ?? ?? ?? ?? 85 C0 74 1F 89 44 24 08 C7 44 24 04 ?? ?? ?? ?? 8B 43 30 89 04 24 E8 ?? ?? ?? ?? EB CB 8D B6 00 00 00 00 C7 44 24 08 05 00 00 00 C7 44 24 04 ?? ?? ?? ?? 8B 03 8B 40 18 89 04 24 E8 ?? ?? ?? ?? 89 1C 24 89 44 24 04 E8 ?? ?? ?? ?? EB 9A C7 04 24 00 00 00 00 E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_414_4_0 {
	meta:
		name = "__argp_parse"
		size = 3163
		refs = "009a malloc 013b memset 01fc stderr 0204 stdout 032a program_invocation_short_name 03aa _getopt_long_only_r 03f5 strchr 04bd argp_program_version 06a3 free 0735 __dcgettext 0753 __argp_error 0787 __argp_state_help 083c _getopt_long_r 0b11 strrchr 0b27 argp_program_version_hook 0bb3 fprintf"
	strings:
		$1 = { 55 89 E5 57 56 53 81 EC DC 00 00 00 F6 45 14 10 0F 84 62 04 00 00 8B 45 14 8B 4D 08 C7 85 4C FF FF FF 00 00 00 00 C7 85 50 FF FF FF 00 00 00 00 83 E0 04 89 85 3C FF FF FF 0F 94 C0 85 C9 0F B6 C0 89 85 48 FF FF FF C7 85 54 FF FF FF 00 00 00 00 0F 84 79 02 00 00 8B 45 08 8D 95 48 FF FF FF E8 9B FA FF FF 8B BD 50 FF FF FF 8B 85 4C FF FF FF 8B B5 54 FF FF FF 83 C7 01 8D 14 FF 8D 5C 82 04 8B 85 48 FF FF FF 01 F3 C1 E3 02 8D 44 18 01 89 04 24 89 95 38 FF FF FF E8 ?? ?? ?? ?? B9 0C 00 00 00 8B 95 38 FF FF FF 85 C0 89 45 E4 0F 84 0C 02 00 00 8D 0C FF 01 F2 8D 3C 88 01 C3 C1 E6 02 8D 14 90 89 74 24 08 C7 44 24 04 00 00 00 00 89 3C 24 89 95 70 FF FF FF 89 95 38 FF FF FF 89 45 9C 89 7D A4 89 9D 6C FF FF FF C7 85 74 FF FF FF 01 00 00 00 C7 85 78 FF FF FF 01 00 00 00 C7 85 7C FF FF FF 00 00 00 00 C7 45 80 00 00 00 00 C7 45 84 00 00 00 00 C7 45 88 00 00 00 00 C7 45 8C 00 00 00 00 C7 45 90 00 00 00 00 C7 45 94 00 00 00 00 C7 45 98 00 00 00 00 E8 ?? ?? ?? ?? 8B 95 38 FF FF FF 8D 85 68 FF FF FF F6 45 14 08 89 85 58 FF FF FF 89 9D 5C FF FF FF 89 95 60 FF FF FF 89 BD 64 FF FF FF 0F 84 7B 01 00 00 C6 03 2D 83 C3 01 89 9D 5C FF FF FF C6 03 00 8B 85 60 FF FF FF C7 00 00 00 00 00 8B 45 08 85 C0 89 85 68 FF FF FF 0F 84 97 03 00 00 8D 85 58 FF FF FF 31 D2 89 44 24 04 8B 45 9C 31 C9 89 04 24 8B 45 08 E8 EB FA FF FF 8B 75 9C 89 C2 89 45 A0 8B 85 68 FF FF FF 89 85 40 FF FF FF 8D 5D AC 31 C0 B9 0E 00 00 00 89 DF F3 AB 8B 85 40 FF FF FF 39 F2 C7 45 A8 01 00 00 00 89 45 AC 8B 45 0C 89 45 B0 8B 45 10 89 45 B4 8B 45 14 89 45 BC A1 ?? ?? ?? ?? 89 45 D8 A1 ?? ?? ?? ?? 89 45 DC 8D 85 68 FF FF FF 89 45 E0 0F 86 EE 00 00 00 8B 45 1C 89 46 18 EB 4A 8D B6 00 00 00 00 8B 56 20 83 C6 24 89 55 D0 8B 56 F4 89 55 C8 8B 56 F8 89 55 CC 8B 56 E8 89 5C 24 08 C7 44 24 04 00 00 00 00 C7 04 24 03 00 00 01 89 55 C0 FF D0 8B 55 D0 89 56 FC 3B 75 A0 73 4D 83 F8 07 0F 85 B4 02 00 00 8B 46 10 85 C0 74 0C 8B 40 1C 8B 56 14 8B 04 90 89 46 18 8B 06 85 C0 75 A3 8B 46 04 8B 40 10 85 C0 74 14 8B 00 85 C0 74 0E 8B 46 1C 8B 56 18 89 10 8B 06 85 C0 75 85 83 C6 24 B8 07 00 00 00 3B 75 A0 72 B3 83 F8 07 89 C1 74 51 85 C0 74 4D 90 8D 74 26 00 8D 65 F4 89 C8 5B 5E 5F 5D C3 8D B6 00 00 00 00 BB 34 00 00 00 31 F6 BA 09 00 00 00 BF 01 00 00 00 E9 A6 FD FF FF 66 90 8B 95 3C FF FF FF 85 D2 0F 84 83 FE FF FF C6 03 2B 83 C3 01 89 9D 5C FF FF FF E9 72 FE FF FF 90 8B 45 BC A8 02 0F 85 35 02 00 00 8B 45 B4 C7 85 78 FF FF FF 01 00 00 00 39 45 10 0F 84 CF 07 00 00 A1 ?? ?? ?? ?? 89 45 D4 8B 45 C4 8B 7D B8 85 C0 74 0B 39 F8 7E 07 C7 45 C4 00 00 00 00 8B 45 A8 85 C0 0F 84 47 02 00 00 8B 45 C4 85 C0 0F 85 3C 02 00 00 F6 45 BC 40 89 BD 74 FF FF FF C7 85 7C FF FF FF FF FF FF FF 0F 84 92 04 00 00 8D 85 74 FF FF FF 89 44 24 14 8B 85 70 FF FF FF C7 44 24 10 00 00 00 00 89 44 24 0C 8B 85 6C FF FF FF 89 44 24 08 8B 45 B4 89 44 24 04 8B 45 B0 89 04 24 E8 ?? ?? ?? ?? 89 C6 8B BD 74 FF FF FF 83 FE FF 89 7D B8 0F 84 AE 01 00 00 83 FE 3F 0F 84 C5 05 00 00 83 FE 01 0F 84 EC 05 00 00 89 F2 C1 FA 18 85 D2 89 95 44 FF FF FF 0F 85 D1 02 00 00 8B 85 6C FF FF FF 89 74 24 04 89 04 24 E8 ?? ?? ?? ?? 85 C0 0F 84 0F 03 00 00 8B 7D 9C 8B 4D A0 39 CF 72 10 E9 00 03 00 00 83 C7 24 39 CF 0F 83 F5 02 00 00 3B 47 08 66 90 73 EE 8B 07 8B 4D 80 85 C0 0F 84 E1 02 00 00 8B 57 20 89 55 D0 8B 57 18 89 55 C8 8B 57 1C 89 55 CC 8B 57 0C 89 4C 24 04 89 5C 24 08 89 34 24 89 55 C0 FF D0 8B 4D D0 89 4F 20 83 F8 07 0F 84 C9 07 00 00 85 C0 0F 84 C6 FE FF FF 89 C1 E9 6E 06 00 00 8D B6 00 00 00 00 83 EC 50 31 C0 8D 54 24 27 83 EC 30 83 E2 F0 8D 5C 24 27 89 D6 83 E3 F0 C7 04 03 00 00 00 00 83 C0 04 83 F8 1C 72 F1 31 C0 B9 10 00 00 00 89 D7 89 53 10 F3 AB 8B 45 08 85 C0 74 08 8B 45 08 8D 72 10 89 02 A1 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 85 C0 0F 84 56 06 00 00 C7 46 10 ?? ?? ?? ?? 8D 46 20 8B 55 14 C7 00 00 00 00 00 C7 85 4C FF FF FF 00 00 00 00 C7 85 50 FF FF FF 00 00 00 00 83 E2 04 0F 94 C0 0F B6 C0 89 95 3C FF FF FF 89 85 48 FF FF FF C7 85 54 FF FF FF 00 00 00 00 89 5D 08 E9 3A FB FF FF 8D 76 00 85 C0 0F 84 44 FD FF FF 89 C1 E9 91 FD FF FF 90 8B 55 9C C7 85 40 FF FF FF 00 00 00 00 89 55 A0 89 D6 E9 82 FC FF FF 90 A8 01 8B 45 B4 C7 85 78 FF FF FF 00 00 00 00 0F 84 C3 FD FF FF 83 E8 04 89 45 B4 83 45 B0 01 E9 B4 FD FF FF 8D 74 26 00 83 FF 01 C7 45 A8 00 00 00 00 7E 1C 8B 45 B4 8B 44 B8 FC 80 38 2D 75 10 80 78 01 2D 75 0A 80 78 02 00 75 04 89 7D C4 90 39 7D B0 0F 8F A7 02 00 00 8B 45 B8 3B 45 B0 0F 84 30 04 00 00 8B 7D 18 85 FF 0F 84 A8 05 00 00 8B 55 18 89 02 8B 75 A0 8B 7D 9C 83 EE 24 39 FE 89 FA 73 15 E9 F1 05 00 00 8D B4 26 00 00 00 00 83 F8 07 0F 85 E7 03 00 00 8B 3E B8 07 00 00 00 85 FF 74 36 8B 46 20 89 45 D0 8B 46 18 89 45 C8 8B 46 1C 89 45 CC 8B 46 0C 89 5C 24 08 C7 44 24 04 00 00 00 00 C7 04 24 04 00 00 01 89 45 C0 FF D7 8B 55 D0 89 56 20 8B 55 9C 83 EE 24 89 D7 39 D6 73 AD 8B 75 A0 89 C1 83 EE 24 83 F8 07 75 08 30 C9 8D B6 00 00 00 00 39 F7 77 47 89 CF 66 90 8B 06 85 C0 74 33 8B 56 20 89 55 D0 8B 56 18 89 55 C8 8B 56 1C 89 55 CC 8B 56 0C 89 5C 24 08 C7 44 24 04 00 00 00 00 C7 04 24 07 00 00 01 89 55 C0 FF D0 8B 45 D0 89 46 20 83 EE 24 3B 75 9C 73 BF 89 F9 83 F9 07 B8 16 00 00 00 0F 44 C8 8B 45 E4 89 8D 38 FF FF FF 89 04 24 E8 ?? ?? ?? ?? 8B 8D 38 FF FF FF 8D 65 F4 5B 5E 5F 89 C8 5D C3 90 8B 95 44 FF FF FF 8B 45 9C 8B 4D 80 8D 7C D2 F7 8D 3C B8 8B 07 85 C0 0F 84 43 02 00 00 8B 57 20 89 55 D0 8B 57 18 89 55 C8 8B 57 1C 89 55 CC 8B 57 0C 89 4C 24 04 89 F1 C1 E1 08 C1 F9 08 89 0C 24 89 55 C0 89 5C 24 08 FF D0 8B 4D D0 89 4F 20 E9 4D FD FF FF 8D 76 00 89 F2 8B 85 68 FF FF FF C7 44 24 08 05 00 00 00 C7 44 24 04 ?? ?? ?? ?? 8B 40 18 89 95 38 FF FF FF 89 04 24 E8 ?? ?? ?? ?? 8B 95 38 FF FF FF C7 44 24 04 ?? ?? ?? ?? 89 1C 24 89 54 24 08 89 44 24 0C E8 ?? ?? ?? ?? 8B 95 38 FF FF FF 8D 76 00 83 FA 01 0F 84 38 FE FF FF B9 07 00 00 00 8B 45 D8 C7 44 24 08 04 01 00 00 89 1C 24 89 8D 38 FF FF FF 89 44 24 04 E8 ?? ?? ?? ?? 8B 8D 38 FF FF FF 8D B4 26 00 00 00 00 8B 7D 9C 8B 75 A0 39 F7 0F 83 2F 02 00 00 89 F2 89 CE 8D B6 00 00 00 00 8B 07 85 C0 74 36 8B 57 20 89 55 D0 8B 57 18 89 55 C8 8B 57 1C 89 55 CC 8B 57 0C 89 5C 24 08 C7 44 24 04 00 00 00 00 C7 04 24 05 00 00 01 89 55 C0 FF D0 8B 45 D0 8B 55 A0 89 47 20 83 C7 24 39 D7 72 BD 89 F1 89 D6 8B 7D 9C 83 EE 24 E9 3E FE FF FF 8D B6 00 00 00 00 8B 85 70 FF FF FF 8D 95 74 FF FF FF 89 54 24 14 C7 44 24 10 00 00 00 00 89 44 24 0C 8B 85 6C FF FF FF 89 44 24 08 8B 45 B4 89 44 24 04 8B 45 B0 89 04 24 E8 ?? ?? ?? ?? 89 C6 E9 69 FB FF FF 90 F6 45 BC 04 0F 85 4F FD FF FF 8B 45 B4 8B 34 B8 83 C7 01 89 75 80 8B 55 9C 83 EF 01 3B 55 A0 89 BD 44 FF FF FF 89 7D B8 0F 83 78 02 00 00 8B 85 44 FF FF FF 8D 7A 24 90 8D 48 01 89 4D B8 8B 4F DC 85 C9 74 73 8B 47 FC 89 45 D0 8B 47 F4 89 45 C8 8B 47 F8 89 45 CC 8B 47 E8 89 5C 24 08 89 74 24 04 C7 04 24 00 00 00 00 89 45 C0 FF D1 8B 4D D0 89 4F FC 83 F8 07 0F 84 11 03 00 00 85 C0 8B 4D B8 75 19 8D 74 26 00 3B 8D 44 FF FF FF 0F 8F D4 00 00 00 C7 45 A8 01 00 00 00 31 C0 83 F8 07 BE 01 00 00 00 0F 85 70 FB FF FF 89 F2 E9 66 FE FF FF 8D B6 00 00 00 00 89 45 B8 39 7D A0 0F 86 E2 01 00 00 83 C7 24 E9 6C FF FF FF 8D 74 26 00 89 F2 8B B5 70 FF FF FF 39 56 0C 75 0B EB 0F 90 83 C6 10 39 56 0C 74 06 8B 06 85 C0 75 F2 8B 85 68 FF FF FF C7 44 24 08 05 00 00 00 C7 44 24 04 ?? ?? ?? ?? 8B 40 18 89 95 38 FF FF FF 89 04 24 E8 ?? ?? ?? ?? 8B 0E BE ?? ?? ?? ?? C7 44 24 04 ?? ?? ?? ?? 89 1C 24 85 C9 0F 44 CE 89 44 24 0C 89 4C 24 08 E8 ?? ?? ?? ?? 8B 95 38 FF FF FF E9 D4 FD FF FF 8D 74 26 00 83 BD 7C FF FF FF FF 0F 85 CC FD FF FF C7 85 44 FF FF FF 00 00 00 00 E9 3B FA FF FF 8D 74 26 00 2B 8D 44 FF FF FF 31 C0 01 4F E8 E9 25 FF FF FF 8B 75 80 E9 96 FE FF FF 85 C0 0F 84 11 FC FF FF 8B 75 A0 89 C1 83 EE 24 E9 63 FC FF FF 8B 7D 9C 31 C9 8B 75 A0 39 FE 77 10 EB 65 90 8D 74 26 00 83 F9 07 0F 85 42 01 00 00 8B 47 0C 85 C0 66 90 75 44 8B 07 B9 07 00 00 00 85 C0 74 39 8B 57 20 89 55 D0 8B 57 18 89 55 C8 8B 57 1C C7 45 C0 00 00 00 00 89 5C 24 08 C7 44 24 04 00 00 00 00 89 55 CC C7 04 24 02 00 00 01 FF D0 8B 75 A0 89 C1 8B 45 D0 89 47 20 83 C7 24 39 F7 72 A3 8B 7D 9C 83 EE 24 39 F7 77 67 83 F9 07 74 1A E9 68 01 00 00 8D B4 26 00 00 00 00 83 F8 07 90 8D 74 26 00 0F 85 D2 00 00 00 8B 16 B8 07 00 00 00 85 D2 74 33 8B 46 20 89 45 D0 8B 46 18 89 45 C8 8B 46 1C 89 45 CC 8B 46 0C 89 5C 24 08 C7 44 24 04 00 00 00 00 C7 04 24 01 00 00 01 89 45 C0 FF D2 8B 55 D0 89 56 20 83 EE 24 3B 75 9C 73 AC 89 C1 83 F9 07 B8 00 00 00 00 0F 44 C8 8B 45 18 85 C0 74 08 8B 45 B8 8B 55 18 89 02 85 C9 0F 84 DD FA FF FF 83 F9 07 0F 85 AF FC FF FF E9 80 FC FF FF B8 07 00 00 00 E9 ED FD FF FF 8B 55 10 8B 32 85 F6 0F 84 24 F8 FF FF 89 34 24 C7 44 24 04 2F 00 00 00 E8 ?? ?? ?? ?? 8D 50 01 85 C0 0F 45 F2 89 75 D4 E9 0C F8 FF FF 8B 3D ?? ?? ?? ?? 8D 46 10 85 FF 0F 85 99 F9 FF FF E9 9E F9 FF FF 85 C9 0F 84 B6 FE FF FF E9 05 FF FF FF 85 C0 8D B6 00 00 00 00 0F 84 20 FF FF FF 89 C1 E9 6C FF FF FF 8D 76 00 F6 45 BC 02 B9 07 00 00 00 0F 85 FF FB FF FF 8B 75 D8 85 F6 0F 84 F4 FB FF FF 8B 85 68 FF FF FF C7 44 24 08 05 00 00 00 8B 75 D4 C7 44 24 04 ?? ?? ?? ?? 8B 40 18 89 8D 38 FF FF FF 89 04 24 E8 ?? ?? ?? ?? 89 74 24 08 89 44 24 04 8B 45 D8 89 04 24 E8 ?? ?? ?? ?? 8B 8D 38 FF FF FF E9 AC FB FF FF 31 C9 E9 77 FA FF FF 85 C9 0F 84 A5 FE FF FF E9 F3 FE FF FF 8B 57 DC 8B 45 B8 83 E8 01 85 D2 89 45 B8 0F 84 19 FD FF FF 8B 47 F4 89 45 C8 8B 47 F8 89 45 CC 8B 47 E8 89 5C 24 08 C7 44 24 04 00 00 00 00 C7 04 24 06 00 00 01 89 45 C0 FF D2 8B 4D D0 39 7D A0 89 4F FC 76 2C 83 F8 07 75 27 8B 45 B8 83 C7 24 E9 54 FC FF FF 89 F2 8B B5 44 FF FF FF 85 F6 0F 85 DE FC FF FF E9 D1 FA FF FF 8D B4 26 00 00 00 00 85 C0 0F 85 95 FC FF FF 8B 4D B0 89 4D B8 E9 75 FC FF FF }
	condition:
		$1
}

rule file_414_5_0 {
	meta:
		name = "__argp_input"
		size = 51
	strings:
		$1 = { 8B 44 24 08 8B 4C 24 04 85 C0 74 24 8B 50 34 8B 42 34 8B 52 38 39 D0 72 0E EB 15 90 8D 74 26 00 83 C0 24 39 D0 73 09 39 48 04 75 F4 8B 40 18 C3 31 C0 C3 }
	condition:
		$1
}

rule file_415_1_0 {
	meta:
		name = "do_release_shlib"
		size = 144
		refs = "003c __libc_dlclose 008c __assert_fail"
	strings:
		$1 = { 53 83 EC 18 8B 44 24 24 8B 54 24 20 83 F8 03 8B 1A 75 3D 3B 1D ?? ?? ?? ?? 8B 43 04 74 42 8D 50 02 83 FA 02 77 21 83 E8 01 83 F8 FD 89 43 04 75 16 8B 43 08 85 C0 74 0F 89 04 24 E8 ?? ?? ?? ?? C7 43 08 00 00 00 00 83 C4 18 5B C3 8D 74 26 00 85 C0 74 BF 83 C4 18 5B C3 8D B4 26 00 00 00 00 85 C0 7E 08 83 E8 01 89 43 04 EB DB C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 AE 00 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_415_2_0 {
	meta:
		name = "__gconv_release_shlib"
		size = 33
		refs = "0019 __twalk"
	strings:
		$1 = { 83 EC 1C A3 ?? ?? ?? ?? A1 ?? ?? ?? ?? C7 44 24 04 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 83 C4 1C C3 }
	condition:
		$1
}

rule file_415_3_0 {
	meta:
		name = "__gconv_find_shlib"
		size = 481
		refs = "002f __tfind 006a __libc_dlopen_mode 0085 __libc_dlsym 0140 strlen 014d malloc 016b memcpy 0193 __tsearch 01a3 free 01b4 __gconv_release_shlib 01dd __assert_fail"
	strings:
		$1 = { 83 EC 3C 89 44 24 1C 8D 44 24 1C C7 44 24 08 ?? ?? ?? ?? C7 44 24 04 ?? ?? ?? ?? 89 04 24 89 5C 24 2C 89 74 24 30 89 7C 24 34 89 6C 24 38 E8 ?? ?? ?? ?? 85 C0 0F 84 FD 00 00 00 8B 18 85 DB 0F 84 63 01 00 00 8B 43 04 83 F8 FE 0F 8D B7 00 00 00 8B 4B 08 85 C9 0F 85 61 01 00 00 C7 44 24 04 01 00 00 80 8B 03 89 04 24 E8 ?? ?? ?? ?? 85 C0 89 43 08 0F 84 2F 01 00 00 C7 44 24 04 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 85 C0 89 43 0C 0F 84 1B 01 00 00 C7 44 24 04 ?? ?? ?? ?? 8B 43 08 89 04 24 E8 ?? ?? ?? ?? 89 43 10 C7 44 24 04 ?? ?? ?? ?? 8B 43 08 89 04 24 E8 ?? ?? ?? ?? 89 43 14 8B 43 0C 65 33 05 18 00 00 00 C1 C0 09 89 43 0C 8B 43 10 85 C0 74 0D 65 33 05 18 00 00 00 C1 C0 09 89 43 10 8B 43 14 85 C0 74 0D 65 33 05 18 00 00 00 C1 C0 09 89 43 14 C7 43 04 01 00 00 00 EB 1E 8D B4 26 00 00 00 00 8B 53 08 85 D2 74 10 8D 48 01 BA 01 00 00 00 85 C0 0F 4F D1 89 53 04 89 D8 8B 74 24 30 8B 5C 24 2C 8B 7C 24 34 8B 6C 24 38 83 C4 3C C3 8D 76 00 8B 7C 24 1C 89 3C 24 E8 ?? ?? ?? ?? 89 C5 83 C0 19 89 04 24 E8 ?? ?? ?? ?? 85 C0 89 C6 89 C3 74 4F 83 C0 18 83 C5 01 89 6C 24 08 89 7C 24 04 89 04 24 E8 ?? ?? ?? ?? C7 44 24 08 ?? ?? ?? ?? C7 44 24 04 ?? ?? ?? ?? 89 34 24 C7 46 04 FD FF FF FF C7 46 08 00 00 00 00 89 06 E8 ?? ?? ?? ?? 85 C0 0F 85 A6 FE FF FF 89 34 24 E8 ?? ?? ?? ?? 90 31 DB E9 70 FF FF FF 89 D8 31 DB E8 ?? ?? ?? ?? E9 62 FF FF FF C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 74 00 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_415_4_0 {
	meta:
		name = "free_mem"
		size = 38
		refs = "0014 __tdestroy"
	strings:
		$1 = { 83 EC 1C A1 ?? ?? ?? ?? C7 44 24 04 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 00 00 00 00 83 C4 1C C3 }
	condition:
		$1
}

rule file_415_5_0 {
	meta:
		name = "do_release_all"
		size = 36
		refs = "0013 __libc_dlclose 0020 free"
	strings:
		$1 = { 53 83 EC 18 8B 5C 24 20 8B 43 08 85 C0 74 08 89 04 24 E8 ?? ?? ?? ?? 89 5C 24 20 83 C4 18 5B E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_417_0_0 {
	meta:
		name = "__fortify_fail"
		size = 59
		refs = "0012 __libc_argv 0035 __libc_message"
	strings:
		$1 = { 56 89 C6 53 BB ?? ?? ?? ?? 83 EC 14 8D 74 26 00 8B 15 ?? ?? ?? ?? 8B 12 89 74 24 08 C7 44 24 04 ?? ?? ?? ?? C7 04 24 02 00 00 00 85 D2 0F 44 D3 89 54 24 0C E8 ?? ?? ?? ?? EB D5 }
	condition:
		$1
}

rule file_418_0_0 {
	meta:
		name = "__iswctype"
		size = 107
		altNames = "__iswctype_l"
	strings:
		$1 = { 83 EC 08 31 C0 8B 54 24 10 89 1C 24 89 74 24 04 85 D2 74 4C 8B 0A 8B 5C 24 0C D3 EB 3B 5A 04 73 3F 8B 5C 9A 14 85 DB 74 37 8B 4A 08 8B 74 24 0C D3 EE 8B 4A 0C 21 F1 8D 0C 8B 8B 0C 0A 85 C9 74 1F 8B 44 24 0C C1 E8 05 23 42 10 8D 04 81 0F B6 4C 24 0C 8B 04 02 D3 E8 83 E0 01 90 8D 74 26 00 8B 1C 24 8B 74 24 04 83 C4 08 C3 }
	condition:
		$1
}

rule file_419_0_0 {
	meta:
		name = "memcpy_uppcase"
		size = 59
		refs = "0024 __towupper_l"
	strings:
		$1 = { 55 89 D5 57 56 89 C6 53 89 CB 83 EC 1C 85 C9 8B 7C 24 30 74 1C 8D 76 00 89 7C 24 04 8B 44 9D FC 89 04 24 E8 ?? ?? ?? ?? 89 44 9E FC 83 EB 01 75 E7 83 C4 1C 89 F0 5B 5E 5F 5D C3 }
	condition:
		$1
}

rule file_419_1_0 {
	meta:
		name = "__strftime_internal"
		size = 7972
		refs = "01d6 wmemset 0352 __wcslen 0424 __towlower_l 0585 __towupper_l 1008 __tzname 106e __mbsrtowcs_l 14b5 mktime 1730 __wmemcpy 1776 _nl_get_walt_digit 1cea _nl_get_era_entry 1e32 __tzset"
	strings:
		$1 = { 55 89 E5 57 56 53 81 EC 2C 01 00 00 89 95 68 FF FF FF 8B 55 10 8B 52 08 89 95 54 FF FF FF 8B 55 08 8B 52 08 89 95 5C FF FF FF 8B 55 08 83 BD 5C FF FF FF 0C 8B 52 28 89 95 50 FF FF FF 0F 8E AD 02 00 00 83 AD 5C FF FF FF 0C 8B 11 85 D2 0F 84 33 19 00 00 89 CF 89 85 74 FF FF FF C7 85 70 FF FF FF 00 00 00 00 EB 47 8B 85 68 FF FF FF 2B 85 70 FF FF FF 83 F8 01 0F 86 33 02 00 00 8B B5 74 FF FF FF 85 F6 74 11 8B 8D 74 FF FF FF 89 11 83 C1 04 89 8D 74 FF FF FF 83 85 70 FF FF FF 01 89 F8 8B 50 04 83 C7 04 85 D2 0F 84 91 01 00 00 83 FA 25 75 B4 31 C0 C7 85 60 FF FF FF 00 00 00 00 C7 85 64 FF FF FF 00 00 00 00 83 C7 04 8B 0F 83 F9 30 0F 84 A0 01 00 00 0F 8F 8A 01 00 00 83 F9 23 0F 84 A9 01 00 00 83 F9 2D 0F 84 88 01 00 00 8D 51 D0 BE FF FF FF FF 83 FA 09 77 41 31 F6 EB 23 8D B4 26 00 00 00 00 8B 17 0F 84 C8 01 00 00 8D 0C B6 83 C7 04 8D 74 4A D0 8B 0F 8D 51 D0 83 FA 09 77 1A 81 FE CC CC CC 0C 7E DC BE FF FF FF 7F 83 C7 04 8B 0F 8D 51 D0 83 FA 09 76 E6 83 F9 45 0F 84 81 01 00 00 83 F9 4F 0F 84 78 01 00 00 C7 85 6C FF FF FF 00 00 00 00 83 F9 7A 0F 86 25 01 00 00 89 FA 83 F9 25 89 D7 0F 85 88 15 00 00 BB 01 00 00 00 89 F1 31 C0 29 D9 0F 49 C1 8D 34 03 8B 85 68 FF FF FF 2B 85 70 FF FF FF 39 C6 0F 83 1B 01 00 00 8B 85 74 FF FF FF 85 C0 0F 84 82 00 00 00 85 C9 7E 4E 83 BD 64 FF FF FF 30 89 4C 24 08 0F 84 38 17 00 00 C7 44 24 04 20 00 00 00 8B 85 74 FF FF FF 89 95 EC FE FF FF 89 8D F0 FE FF FF 89 04 24 E8 ?? ?? ?? ?? 8B 85 74 FF FF FF 8B 8D F0 FE FF FF 8B 95 EC FE FF FF 8D 04 88 89 85 74 FF FF FF 8B 8D 60 FF FF FF 85 C9 0F 84 3D 15 00 00 8B 4D 10 8B 85 74 FF FF FF 89 0C 24 89 D9 E8 AA FD FF FF 8B 95 74 FF FF FF 8D 14 9A 89 95 74 FF FF FF 89 F8 83 C7 04 8B 50 04 01 B5 70 FF FF FF 85 D2 0F 85 74 FE FF FF 90 8D 74 26 00 8B 95 74 FF FF FF 85 D2 74 70 8B 85 68 FF FF FF 85 C0 74 66 8B 8D 74 FF FF FF C7 01 00 00 00 00 EB 58 8D B6 00 00 00 00 83 F9 5E 74 33 83 F9 5F 0F 85 7A FE FF FF 66 90 89 8D 64 FF FF FF E9 47 FE FF FF 90 8D 74 26 00 FF 24 8D ?? ?? ?? ?? 90 B8 01 00 00 00 E9 30 FE FF FF 8D B6 00 00 00 00 C7 85 60 FF FF FF 01 00 00 00 E9 1B FE FF FF 90 C7 85 70 FF FF FF 00 00 00 00 8B 85 70 FF FF FF 8D 65 F4 5B 5E 5F 5D C3 89 8D 6C FF FF FF 83 C7 04 8B 0F E9 82 FE FF FF 83 FA 37 0F 8E 2F FE FF FF BE FF FF FF 7F E9 46 FE FF FF 90 8D 74 26 00 8B BD 5C FF FF FF BA 0C 00 00 00 85 FF 0F 45 95 5C FF FF FF 89 95 5C FF FF FF E9 3B FD FF FF 31 DB 85 C0 B8 01 00 00 00 0F 45 D8 8B 45 08 BA 00 00 00 00 0F 44 95 60 FF FF FF 8B 48 08 31 C0 89 95 60 FF FF FF 8B 95 54 FF FF FF 83 F9 0B 0F 9F C0 83 C0 62 8B 54 82 04 89 8D F0 FE FF FF 89 14 24 E8 ?? ?? ?? ?? 8B 8D F0 FE FF FF 29 C6 89 85 6C FF FF FF B8 00 00 00 00 0F 49 C6 03 85 6C FF FF FF 89 85 58 FF FF FF 8B 85 68 FF FF FF 2B 85 70 FF FF FF 39 85 58 FF FF FF 0F 83 20 FF FF FF 8B 85 74 FF FF FF 85 C0 0F 84 B4 00 00 00 85 F6 7E 3C 83 BD 64 FF FF FF 30 89 74 24 08 0F 84 17 16 00 00 C7 44 24 04 20 00 00 00 8B 8D 74 FF FF FF 89 0C 24 E8 ?? ?? ?? ?? 8B 55 08 8B 85 74 FF FF FF 8B 4A 08 8D 04 B0 89 85 74 FF FF FF 31 C0 83 F9 0C 0F 9D C0 85 DB 0F 84 1F 15 00 00 8B 8D 54 FF FF FF 83 C0 62 8B 74 81 04 8B 8D 6C FF FF FF 85 C9 74 38 89 BD 64 FF FF FF 8B 9D 6C FF FF FF 89 F7 8B 75 10 66 90 89 74 24 04 8B 44 9F FC 89 04 24 E8 ?? ?? ?? ?? 8B 95 74 FF FF FF 89 44 9A FC 83 EB 01 75 E1 8B BD 64 FF FF FF 8B 95 74 FF FF FF 8B 85 6C FF FF FF 8D 14 82 89 95 74 FF FF FF 8B 8D 58 FF FF FF 89 F8 01 8D 70 FF FF FF E9 3C FC FF FF C7 85 6C FF FF FF ?? ?? ?? ?? 90 8B 4D 10 8B 45 0C 8B 55 08 89 4C 24 08 8B 8D 6C FF FF FF 89 44 24 04 31 C0 89 14 24 BA FF FF FF FF E8 6A FB FF FF 89 F1 8B 95 68 FF FF FF 89 C3 31 C0 29 D9 0F 49 C1 2B 95 70 FF FF FF 01 D8 89 85 58 FF FF FF 39 D0 0F 83 F3 FD FF FF 8B 85 74 FF FF FF 85 C0 0F 84 43 15 00 00 85 C9 8B B5 74 FF FF FF 7E 48 83 BD 64 FF FF FF 30 89 4C 24 08 0F 84 17 14 00 00 8B 85 74 FF FF FF C7 44 24 04 20 00 00 00 89 04 24 89 95 EC FE FF FF 89 8D F0 FE FF FF E8 ?? ?? ?? ?? 8B 8D F0 FE FF FF 8B 85 74 FF FF FF 8B 95 EC FE FF FF 8D 34 88 8B 4D 10 8D 1C 9E 8B 45 0C 89 4C 24 08 8B 4D 08 89 44 24 04 89 F0 89 0C 24 8B 8D 6C FF FF FF E8 BF FA FF FF 8B 85 58 FF FF FF 01 85 70 FF FF FF 8B 85 60 FF FF FF 85 C0 0F 84 05 13 00 00 3B 9D 74 FF FF FF 0F 86 F9 12 00 00 8B B5 74 FF FF FF 89 BD 74 FF FF FF 89 F7 8B 75 10 89 74 24 04 8B 07 83 C7 04 89 04 24 E8 ?? ?? ?? ?? 89 47 FC 39 FB 77 E8 8B BD 74 FF FF FF 89 9D 74 FF FF FF 89 F8 E9 FE FA FF FF C7 85 6C FF FF FF ?? ?? ?? ?? E9 BE FE FF FF BB 01 00 00 00 E9 55 FD FF FF 8B 85 6C FF FF FF 85 C0 0F 85 2E 11 00 00 C7 85 6C FF FF FF ?? ?? ?? ?? E9 97 FE FF FF 8B 85 6C FF FF FF 85 C0 0F 85 11 11 00 00 C7 85 6C FF FF FF ?? ?? ?? ?? E9 7A FE FF FF 83 BD 6C FF FF FF 45 0F 84 DD 16 00 00 8B 45 08 BA 01 00 00 00 8B 40 14 89 C1 81 C1 6C 07 00 00 85 F6 0F 4F D6 89 C8 89 95 58 FF FF FF BA 1F 85 EB 51 F7 EA 89 C8 C1 F8 1F C1 FA 05 29 C2 6B C2 64 89 D3 29 C1 89 C8 C1 E8 1F 29 C3 8D B6 00 00 00 00 85 DB 0F 89 10 11 00 00 89 D9 C1 E9 1F 89 8D 6C FF FF FF 8B 85 6C FF FF FF 89 D9 F7 D9 85 C0 0F 44 CB 8D 5D E8 8D 76 00 B8 CD CC CC CC 83 EB 04 F7 E1 C1 EA 03 8D 04 92 01 C0 29 C1 83 C1 30 85 D2 89 0B 89 D1 75 E1 8B 85 6C FF FF FF 85 C0 74 0A C7 43 FC 2D 00 00 00 83 EB 04 8D 55 E8 29 DA 83 BD 64 FF FF FF 2D 0F 84 C5 00 00 00 8B 8D 58 FF FF FF 89 D0 C1 F8 02 29 C1 85 C9 0F 8E B0 00 00 00 8B 85 68 FF FF FF 2B 85 70 FF FF FF 83 BD 64 FF FF FF 5F 0F 84 9D 11 00 00 39 85 58 FF FF FF 0F 83 C1 FB FF FF 8B B5 6C FF FF FF 85 F6 74 2E 8B 95 74 FF FF FF 83 C3 04 85 D2 74 15 8B 95 74 FF FF FF C7 02 2D 00 00 00 83 C2 04 89 95 74 FF FF FF 83 85 70 FF FF FF 01 8D 55 E8 29 DA 8B 85 74 FF FF FF 85 C0 74 41 8B 85 74 FF FF FF 89 4C 24 08 C7 44 24 04 30 00 00 00 89 95 EC FE FF FF 89 04 24 89 8D F0 FE FF FF E8 ?? ?? ?? ?? 8B 85 74 FF FF FF 8B 8D F0 FE FF FF 8B 95 EC FE FF FF 8D 04 88 89 85 74 FF FF FF 01 8D 70 FF FF FF 31 F6 C1 FA 02 31 C0 89 95 6C FF FF FF 89 F2 8B B5 6C FF FF FF 2B 95 6C FF FF FF 0F 49 C2 01 C6 8B 85 68 FF FF FF 2B 85 70 FF FF FF 39 C6 0F 83 04 FB FF FF 8B 85 74 FF FF FF 85 C0 0F 84 6B FA FF FF 85 D2 7E 42 83 BD 64 FF FF FF 30 89 54 24 08 0F 84 A1 10 00 00 C7 44 24 04 20 00 00 00 8B 8D 74 FF FF FF 89 95 EC FE FF FF 89 0C 24 E8 ?? ?? ?? ?? 8B 85 74 FF FF FF 8B 95 EC FE FF FF 8D 04 90 89 85 74 FF FF FF 8B 85 60 FF FF FF 85 C0 0F 84 0A 0F 00 00 8B 55 10 8B 8D 6C FF FF FF 8B 85 74 FF FF FF 89 14 24 89 DA E8 99 F7 FF FF 8B 8D 74 FF FF FF 8B 95 6C FF FF FF 8D 0C 91 89 8D 74 FF FF FF E9 E4 F9 FF FF 8B 95 6C FF FF FF 85 D2 0F 85 A9 0E 00 00 85 C0 B8 01 00 00 00 8B 8D 54 FF FF FF 0F 44 85 60 FF FF FF 89 85 60 FF FF FF 8B 45 08 8B 40 10 89 85 14 FF FF FF 05 4E 00 02 00 25 FF FF 00 00 8B 54 81 24 89 14 24 89 95 EC FE FF FF E8 ?? ?? ?? ?? 89 F1 8B 95 EC FE FF FF 29 C1 89 C3 8B 85 6C FF FF FF 0F 49 C1 8D 34 18 8B 85 68 FF FF FF 2B 85 70 FF FF FF 39 C6 0F 83 F3 F9 FF FF 8B 85 74 FF FF FF 85 C0 0F 84 5A F9 FF FF 85 C9 7E 61 83 BD 64 FF FF FF 30 89 4C 24 08 0F 84 DB 15 00 00 C7 44 24 04 20 00 00 00 8B 85 74 FF FF FF 89 8D F0 FE FF FF 89 04 24 E8 ?? ?? ?? ?? 8B 8D F0 FE FF FF 8B 95 74 FF FF FF 8D 14 8A 8B 4D 08 89 95 74 FF FF FF 8B 49 10 89 C8 8B 8D 54 FF FF FF 05 4E 00 02 00 25 FF FF 00 00 8B 54 81 24 8D 76 00 8B 85 60 FF FF FF 85 C0 0F 84 06 10 00 00 8B 45 10 89 D9 89 04 24 8B 85 74 FF FF FF E8 6F F6 FF FF 8B 8D 74 FF FF FF 8D 0C 99 89 8D 74 FF FF FF E9 C0 F8 FF FF 8B 9D 6C FF FF FF 85 DB 0F 85 0D 10 00 00 8B 85 6C FF FF FF 89 F3 83 EB 01 0F 49 C3 8D 70 01 8B 85 68 FF FF FF 2B 85 70 FF FF FF 39 C6 0F 83 18 F9 FF FF 8B 8D 74 FF FF FF 85 C9 0F 84 7F F8 FF FF 85 DB B8 25 00 00 00 7E 38 83 BD 64 FF FF FF 30 89 5C 24 08 0F 84 CF 14 00 00 8B 8D 74 FF FF FF C7 44 24 04 20 00 00 00 89 0C 24 E8 ?? ?? ?? ?? 8B 85 74 FF FF FF 8D 04 98 89 85 74 FF FF FF 8B 07 8B 95 74 FF FF FF 89 02 83 C2 04 89 95 74 FF FF FF E9 28 F8 FF FF 8B 95 6C FF FF FF 85 D2 0F 85 ED 0C 00 00 85 C0 B8 01 00 00 00 8B 8D 54 FF FF FF 0F 44 85 60 FF FF FF 89 85 60 FF FF FF 8B 45 08 8B 40 18 89 85 2C FF FF FF 05 3B 00 02 00 25 FF FF 00 00 8B 54 81 24 89 14 24 89 95 EC FE FF FF E8 ?? ?? ?? ?? 89 F1 8B 95 EC FE FF FF 29 C1 89 C3 8B 85 6C FF FF FF 0F 49 C1 8D 34 18 8B 85 68 FF FF FF 2B 85 70 FF FF FF 39 C6 0F 83 37 F8 FF FF 8B 85 74 FF FF FF 85 C0 0F 84 9E F7 FF FF 85 C9 0F 8E A1 FE FF FF 83 BD 64 FF FF FF 30 89 4C 24 08 0F 84 42 14 00 00 C7 44 24 04 20 00 00 00 8B 85 74 FF FF FF 89 8D F0 FE FF FF 89 04 24 E8 ?? ?? ?? ?? 8B 8D F0 FE FF FF 8B 95 74 FF FF FF 8D 14 8A 8B 4D 08 89 95 74 FF FF FF 8B 49 18 89 C8 8B 8D 54 FF FF FF 05 3B 00 02 00 25 FF FF 00 00 8B 54 81 24 E9 3E FE FF FF 8D 57 FC 8B 4F FC E9 68 F6 FF FF 83 BD 6C FF FF FF 45 0F 84 EE 0B 00 00 8B 45 08 83 FE 02 B9 02 00 00 00 0F 4D CE 89 8D 58 FF FF FF 8B 58 04 E9 22 FB FF FF 85 C0 B8 01 00 00 00 0F 44 85 60 FF FF FF 89 85 60 FF FF FF 8B 85 6C FF FF FF 85 C0 0F 85 B0 0B 00 00 8B 45 08 8B 8D 54 FF FF FF 8B 40 10 89 85 20 FF FF FF 05 42 00 02 00 25 FF FF 00 00 8B 54 81 24 89 14 24 89 95 EC FE FF FF E8 ?? ?? ?? ?? 89 F1 8B 95 EC FE FF FF 29 C1 89 C3 8B 85 6C FF FF FF 0F 49 C1 8D 34 18 8B 85 68 FF FF FF 2B 85 70 FF FF FF 39 C6 0F 83 0E F7 FF FF 8B 85 74 FF FF FF 85 C0 0F 84 75 F6 FF FF 85 C9 0F 8E 78 FD FF FF 83 BD 64 FF FF FF 30 89 4C 24 08 0F 84 FF 12 00 00 C7 44 24 04 20 00 00 00 8B 85 74 FF FF FF 89 8D F0 FE FF FF 89 04 24 E8 ?? ?? ?? ?? 8B 8D F0 FE FF FF 8B 95 74 FF FF FF 8D 14 8A 8B 4D 08 89 95 74 FF FF FF 8B 49 10 89 C8 8B 8D 54 FF FF FF 05 42 00 02 00 25 FF FF 00 00 8B 54 81 24 E9 15 FD FF FF 8B 95 6C FF FF FF 85 D2 0F 85 CF 0A 00 00 8B 4D 08 85 C0 B8 01 00 00 00 0F 44 85 60 FF FF FF 8B 49 18 89 85 60 FF FF FF 89 C8 8B 8D 54 FF FF FF 05 34 00 02 00 25 FF FF 00 00 8B 54 81 24 89 14 24 89 95 EC FE FF FF E8 ?? ?? ?? ?? 89 F1 8B 95 EC FE FF FF 29 C1 89 C3 8B 85 6C FF FF FF 0F 49 C1 8D 34 18 8B 85 68 FF FF FF 2B 85 70 FF FF FF 39 C6 0F 83 1D F6 FF FF 8B 85 74 FF FF FF 85 C0 0F 84 84 F5 FF FF 85 C9 0F 8E 87 FC FF FF 83 BD 64 FF FF FF 30 89 4C 24 08 0F 84 1B 12 00 00 C7 44 24 04 20 00 00 00 8B 85 74 FF FF FF 89 8D F0 FE FF FF 89 04 24 E8 ?? ?? ?? ?? 8B 8D F0 FE FF FF 8B 95 74 FF FF FF 8D 14 8A 8B 4D 08 89 95 74 FF FF FF 8B 49 18 89 C8 8B 8D 54 FF FF FF 05 34 00 02 00 25 FF FF 00 00 8B 54 81 24 E9 24 FC FF FF 8B 45 08 8B 50 20 85 D2 0F 88 00 0D 00 00 8B 48 24 85 C9 0F 88 FA 0D 00 00 89 F3 31 D2 8B 85 68 FF FF FF 83 EB 01 0F 49 D3 2B 85 70 FF FF FF 83 C2 01 39 C2 0F 83 6A F5 FF FF 8B 85 74 FF FF FF 85 C0 74 67 85 DB 7E 4E 83 BD 64 FF FF FF 30 89 5C 24 08 0F 84 E8 10 00 00 8B 85 74 FF FF FF C7 44 24 04 20 00 00 00 89 95 EC FE FF FF 89 8D F0 FE FF FF 89 04 24 E8 ?? ?? ?? ?? 8B 85 74 FF FF FF 8B 8D F0 FE FF FF 8B 95 EC FE FF FF 8D 04 98 89 85 74 FF FF FF 8B 85 74 FF FF FF C7 00 2B 00 00 00 83 C0 04 89 85 74 FF FF FF 01 95 70 FF FF FF B8 89 88 88 88 F7 E9 89 C8 C1 F8 1F 8D 1C 0A B9 04 00 00 00 C1 FB 05 29 C3 83 FE 04 B8 89 88 88 88 0F 4D CE F7 EB 89 8D 58 FF FF FF 8D 04 1A 89 DA C1 F8 05 C1 FA 1F 29 D0 6B C0 28 8D 1C 18 E9 47 F8 FF FF 83 BD 6C FF FF FF 45 0F 84 EA 08 00 00 8B 55 08 8B 45 08 8B 52 14 8B 40 18 89 95 40 FF FF FF 8B 55 08 89 85 44 FF FF FF 8B 52 1C 89 D3 29 C3 81 C3 7E 01 00 00 89 95 58 FF FF FF 89 D8 BA 93 24 49 92 F7 EA 8D 04 1A 89 DA C1 FA 1F C1 F8 02 29 D0 8D 14 C5 00 00 00 00 29 C2 8B 85 58 FF FF FF 29 D8 8D 44 10 03 8B 95 40 FF FF FF 85 C0 89 85 48 FF FF FF 0F 88 43 0D 00 00 81 C2 6C 07 00 00 B8 93 FE FF FF F6 C2 03 89 95 4C FF FF FF 75 50 BB 1F 85 EB 51 89 D0 F7 EB 8B 85 4C FF FF FF 89 D3 C1 F8 1F C1 FA 05 29 C2 6B D2 64 39 95 4C FF FF FF 89 85 3C FF FF FF B8 92 FE FF FF 75 21 C1 FB 07 8B 85 4C FF FF FF 2B 9D 3C FF FF FF 69 DB 90 01 00 00 29 D8 83 F8 01 19 C0 2D 6D 01 00 00 03 85 58 FF FF FF BA 93 24 49 92 89 C3 2B 9D 44 FF FF FF 89 85 58 FF FF FF 81 C3 7E 01 00 00 89 D8 F7 EA 8D 04 1A 89 DA C1 FA 1F C1 F8 02 29 D0 8D 14 C5 00 00 00 00 29 C2 8B 85 58 FF FF FF 29 D8 8D 44 10 03 85 C0 78 18 8B 95 40 FF FF FF 89 85 48 FF FF FF 81 C2 6D 07 00 00 89 95 4C FF FF FF 83 F9 47 0F 84 0D 0B 00 00 83 F9 67 0F 84 CD 0A 00 00 8B 85 48 FF FF FF 83 FE 02 B9 02 00 00 00 BA 93 24 49 92 0F 4D CE 8B 9D 48 FF FF FF 89 8D 58 FF FF FF F7 EA 8B 85 48 FF FF FF 01 D3 C1 FB 02 C1 F8 1F 29 C3 83 C3 01 E9 B8 F6 FF FF 83 BD 6C FF FF FF 45 0F 84 5B 07 00 00 8B 45 08 83 FE 02 B9 02 00 00 00 0F 4D CE 89 8D 58 FF FF FF 8B 40 10 89 C3 83 C3 01 E9 8A F6 FF FF 83 F8 01 19 C9 83 C1 01 85 C0 B8 00 00 00 00 0F 44 85 60 FF FF FF 89 85 60 FF FF FF 8B 85 50 FF FF FF 85 C0 74 0B 8B 85 50 FF FF FF 80 38 00 75 3D 8B 55 08 8B 42 20 85 C0 78 19 8B 55 0C 80 3A 00 0F }
	condition:
		$1
}

rule file_419_2_0 {
	meta:
		name = "__wcsftime_l"
		size = 52
	strings:
		$1 = { 83 EC 2C 8B 44 24 40 8B 4C 24 38 8B 54 24 34 C6 44 24 1F 00 89 44 24 08 8D 44 24 1F 89 44 24 04 8B 44 24 3C 89 04 24 8B 44 24 30 E8 A0 E0 FF FF 83 C4 2C C3 }
	condition:
		$1
}

rule file_420_3_0 {
	meta:
		name = "_IO_new_fsetpos64"
		size = 307
		refs = "006b _IO_seekpos_unlocked 00d1 __libc_errno 012f _Unwind_Resume"
	strings:
		$1 = { 83 EC 1C 89 5C 24 10 8B 5C 24 20 89 74 24 14 8B 74 24 24 89 7C 24 18 8B 03 25 00 80 00 00 75 32 8B 53 48 65 8B 3D 08 00 00 00 3B 7A 08 74 1F B9 01 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 0F B1 0A 0F 85 EB 00 00 00 8B 53 48 89 7A 08 83 42 04 01 C7 44 24 0C 03 00 00 00 8B 06 8B 56 04 89 1C 24 89 44 24 04 89 54 24 08 E8 ?? ?? ?? ?? 21 D0 83 F8 FF 74 5A 8B 43 68 85 C0 7E 0D 8B 43 54 89 04 24 FF 50 10 85 C0 78 66 31 D2 F7 03 00 80 00 00 75 24 8B 4B 48 83 69 04 01 75 1B C7 41 08 00 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 83 29 01 0F 85 87 00 00 00 89 D0 8B 5C 24 10 8B 74 24 14 8B 7C 24 18 83 C4 1C C3 8D B6 00 00 00 00 A1 ?? ?? ?? ?? BA FF FF FF FF 65 8B 08 85 C9 75 AB 65 C7 00 05 00 00 00 EB A2 8D B6 00 00 00 00 8B 4B 58 8B 46 08 8B 56 0C 89 41 2C 89 51 30 EB 89 F7 03 00 80 00 00 89 C6 75 20 8B 53 48 83 6A 04 01 75 17 C7 42 08 00 00 00 00 65 83 3D 0C 00 00 00 00 74 01 F0 83 2A 01 75 20 89 34 24 E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_421_0_0 {
	meta:
		name = "div"
		size = 46
		altNames = "ldiv"
	strings:
		$1 = { 53 8B 5C 24 0C 8B 4C 24 08 89 DA 89 D8 C1 FA 1F F7 7C 24 10 85 DB 78 0B 85 D2 79 07 2B 54 24 10 83 C0 01 89 01 89 C8 89 51 04 5B C2 04 00 }
	condition:
		$1
}

rule file_422_0_0 {
	meta:
		name = "__mpn_add_n"
		size = 144
	strings:
		$1 = { 57 56 8B 7C 24 0C 8B 74 24 10 8B 54 24 14 8B 4C 24 18 89 C8 C1 E9 03 F7 D8 83 E0 07 74 1A 41 C1 E0 02 29 C7 29 C6 29 C2 C1 E8 02 8D 84 C0 ?? ?? ?? ?? FF E0 8D 74 26 00 8B 06 13 02 89 07 8B 46 04 13 42 04 89 47 04 8B 46 08 13 42 08 89 47 08 8B 46 0C 13 42 0C 89 47 0C 8B 46 10 13 42 10 89 47 10 8B 46 14 13 42 14 89 47 14 8B 46 18 13 42 18 89 47 18 8B 46 1C 13 42 1C 89 47 1C 8D 7F 20 8D 76 20 8D 52 20 49 75 AF 19 C0 F7 D8 5E 5F C3 }
	condition:
		$1
}

rule file_423_0_0 {
	meta:
		name = "_dl_mcount_wrapper"
		size = 27
		refs = "0013 _dl_mcount"
	strings:
		$1 = { 83 EC 1C 8B 44 24 20 89 44 24 04 8B 44 24 1C 89 04 24 E8 ?? ?? ?? ?? 83 C4 1C C3 }
	condition:
		$1
}

rule file_423_1_0 {
	meta:
		name = "_dl_mcount_wrapper_check"
		size = 37
		refs = "0001 _dl_profile_map 001c _dl_mcount"
	strings:
		$1 = { A1 ?? ?? ?? ?? 85 C0 74 1A 83 EC 1C 8B 44 24 20 89 44 24 04 8B 44 24 1C 89 04 24 E8 ?? ?? ?? ?? 83 C4 1C F3 C3 }
	condition:
		$1
}

rule file_424_0_0 {
	meta:
		name = "posix_spawnattr_getschedpolicy"
		size = 19
	strings:
		$1 = { 8B 44 24 04 8B 90 0C 01 00 00 8B 44 24 08 89 10 31 C0 C3 }
	condition:
		$1
}

rule file_425_0_0 {
	meta:
		name = "__fbufsize"
		size = 31
	strings:
		$1 = { 8B 54 24 04 8B 42 68 85 C0 7E 0D 8B 52 58 8B 42 1C 2B 42 18 C1 F8 02 C3 8B 42 20 2B 42 1C C3 }
	condition:
		$1
}

rule file_426_0_0 {
	meta:
		name = "check_one_fd"
		size = 228
		refs = "002f __libc_fcntl 0059 __libc_errno 0089 __open_nocancel 00a5 __fxstat64"
	strings:
		$1 = { 81 EC 8C 00 00 00 C7 44 24 04 01 00 00 00 89 04 24 89 5C 24 7C 89 C3 89 AC 24 88 00 00 00 89 D5 89 B4 24 80 00 00 00 89 BC 24 84 00 00 00 E8 ?? ?? ?? ?? 83 F8 FF 74 20 8B 5C 24 7C 8B B4 24 80 00 00 00 8B BC 24 84 00 00 00 8B AC 24 88 00 00 00 81 C4 8C 00 00 00 C3 A1 ?? ?? ?? ?? 65 83 38 09 75 D5 89 E8 83 E0 03 83 E8 01 74 5E BE 03 01 00 00 31 FF B8 ?? ?? ?? ?? C7 44 24 08 00 00 00 00 89 6C 24 04 89 04 24 E8 ?? ?? ?? ?? 39 C3 75 37 8D 44 24 10 89 44 24 08 89 5C 24 04 C7 04 24 03 00 00 00 E8 ?? ?? ?? ?? 85 C0 75 1B 8B 44 24 20 25 00 F0 00 00 3D 00 20 00 00 75 0B 39 7C 24 34 74 16 90 8D 74 26 00 F4 EB FD BE 07 01 00 00 31 FF B8 ?? ?? ?? ?? EB A0 39 74 24 30 75 E9 E9 54 FF FF FF }
	condition:
		$1
}

rule file_426_1_0 {
	meta:
		name = "__libc_check_standard_fds"
		size = 48
	strings:
		$1 = { 83 EC 0C BA 01 00 02 00 31 C0 E8 01 FF FF FF BA 00 00 02 00 B8 01 00 00 00 E8 F2 FE FF FF BA 00 00 02 00 B8 02 00 00 00 83 C4 0C E9 E0 FE FF FF }
	condition:
		$1
}

rule file_427_0_0 {
	meta:
		name = "tcsetattr"
		size = 250
		refs = "009b _dl_sysinfo 00a8 __libc_errno"
	strings:
		$1 = { 83 EC 3C 8B 44 24 44 89 74 24 34 8B 74 24 48 89 5C 24 30 89 7C 24 38 83 F8 01 0F 84 D0 00 00 00 83 F8 02 0F 84 B7 00 00 00 85 C0 0F 85 87 00 00 00 B9 02 54 00 00 8B 46 04 8D 54 24 0C 8B 3E 8B 5C 24 40 89 44 24 10 8B 46 08 81 E7 FF FF FF 7F 89 7C 24 0C 89 44 24 14 8B 46 0C 89 44 24 18 0F B6 46 10 88 44 24 1C 8B 46 11 89 44 24 1D 8B 46 15 89 44 24 21 8B 46 19 89 44 24 25 8B 46 1D 89 44 24 29 0F B7 46 21 66 89 44 24 2D 0F B6 46 23 88 44 24 2F B8 36 00 00 00 FF 15 ?? ?? ?? ?? 3D 00 F0 FF FF 76 23 8B 15 ?? ?? ?? ?? F7 D8 65 89 02 83 C8 FF EB 13 66 90 A1 ?? ?? ?? ?? 65 C7 00 16 00 00 00 B8 FF FF FF FF 8B 5C 24 30 8B 74 24 34 8B 7C 24 38 83 C4 3C C3 8D B4 26 00 00 00 00 B9 04 54 00 00 E9 4C FF FF FF 8D B6 00 00 00 00 B9 03 54 00 00 E9 3C FF FF FF }
	condition:
		$1
}

rule file_428_0_0 {
	meta:
		name = "__setresuid"
		size = 100
		refs = "0002 __nptl_setxid 0049 _dl_sysinfo 0056 __libc_errno"
	strings:
		$1 = { 53 B8 ?? ?? ?? ?? 83 EC 38 85 C0 8B 4C 24 44 8B 54 24 48 74 29 8B 5C 24 40 8D 44 24 1C 89 04 24 C7 44 24 1C D0 00 00 00 89 4C 24 24 89 5C 24 20 89 54 24 28 E8 ?? ?? ?? ?? 83 C4 38 5B C3 8B 5C 24 40 B8 D0 00 00 00 FF 15 ?? ?? ?? ?? 3D 00 F0 FF FF 76 E5 8B 15 ?? ?? ?? ?? F7 D8 65 89 02 83 C8 FF EB D5 }
	condition:
		$1
}

rule file_429_0_0 {
	meta:
		name = "__mbrlen"
		size = 53
		refs = "002d __mbrtowc"
	strings:
		$1 = { 83 EC 1C BA ?? ?? ?? ?? 8B 44 24 28 C7 04 24 00 00 00 00 85 C0 0F 44 C2 89 44 24 0C 8B 44 24 24 89 44 24 08 8B 44 24 20 89 44 24 04 E8 ?? ?? ?? ?? 83 C4 1C C3 }
	condition:
		$1
}

rule file_430_0_0 {
	meta:
		name = "__fread_unlocked_chk"
		size = 127
		refs = "005c _IO_sgetn 007b __chk_fail"
	strings:
		$1 = { 83 EC 1C 89 5C 24 10 8B 5C 24 2C 89 7C 24 18 8B 7C 24 28 89 74 24 14 89 D8 89 DE 09 F8 0F AF F7 3D FF FF 00 00 77 45 3B 74 24 24 77 4D 85 F6 75 17 31 DB 89 D8 8B 74 24 14 8B 5C 24 10 8B 7C 24 18 83 C4 1C C3 8D 76 00 8B 44 24 20 89 74 24 08 89 44 24 04 8B 44 24 30 89 04 24 E8 ?? ?? ?? ?? 39 C6 74 CF 31 D2 F7 F7 89 C3 EB C7 85 FF 74 B7 31 D2 89 F0 F7 F7 39 D8 74 AD E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_431_0_0 {
	meta:
		name = "inet6_opt_init"
		size = 55
	strings:
		$1 = { 8B 4C 24 04 B8 02 00 00 00 8B 54 24 08 85 C9 74 24 85 D2 74 1B F6 C2 07 75 16 81 FA 00 08 00 00 77 0E C1 EA 03 83 EA 01 88 51 01 C3 8D 74 26 00 B8 FF FF FF FF F3 C3 }
	condition:
		$1
}

rule file_431_1_0 {
	meta:
		name = "inet6_opt_append"
		size = 284
		refs = "00bc memset"
	strings:
		$1 = { 83 EC 3C 89 7C 24 34 8B 7C 24 48 89 5C 24 2C 0F B6 4C 24 54 89 74 24 30 0F B6 5C 24 4C 89 6C 24 38 83 FF 01 0F 86 D6 00 00 00 80 FB 01 0F 86 CD 00 00 00 81 7C 24 50 FF 00 00 00 0F 87 BF 00 00 00 8D 41 FF 3C 07 0F 87 B4 00 00 00 8D 69 FF 85 CD 0F 85 A9 00 00 00 39 4C 24 50 0F 82 9F 00 00 00 8D 77 02 89 F2 89 F0 C1 FA 1F F7 F9 8B 44 24 40 29 D1 21 E9 85 C0 0F 84 9B 00 00 00 01 CE 03 74 24 50 3B 74 24 44 77 77 83 F9 01 74 7A 85 C9 74 32 8B 44 24 40 8D 51 FE 01 F8 88 50 01 0F B6 D2 83 C0 02 C6 40 FE 01 89 54 24 08 C7 44 24 04 00 00 00 00 89 04 24 89 4C 24 1C E8 ?? ?? ?? ?? 8B 4C 24 1C 8B 44 24 40 01 F9 0F B6 54 24 50 01 C8 88 50 01 8B 54 24 58 83 C0 02 88 58 FE 89 02 8B 54 24 50 8D 44 11 02 8B 5C 24 2C 8B 74 24 30 8B 7C 24 34 8B 6C 24 38 83 C4 3C C3 8D 74 26 00 B8 FF FF FF FF EB E1 90 8B 44 24 40 C6 04 38 00 EB B2 8D B6 00 00 00 00 01 F9 EB C4 }
	condition:
		$1
}

rule file_431_2_0 {
	meta:
		name = "inet6_opt_finish"
		size = 119
		refs = "0050 memset"
	strings:
		$1 = { 53 83 EC 18 8B 4C 24 28 8B 44 24 20 83 F9 01 76 5F 89 CA F7 DA 83 E2 07 85 C0 8D 1C 11 74 35 3B 5C 24 24 77 4B 83 FA 01 74 36 85 D2 74 26 01 C1 83 EA 02 88 51 01 0F B6 D2 83 C1 02 C6 41 FE 01 89 54 24 08 C7 44 24 04 00 00 00 00 89 0C 24 E8 ?? ?? ?? ?? 83 C4 18 89 D8 5B C3 90 8D 74 26 00 C6 04 08 00 83 C4 18 89 D8 5B C3 90 8D 74 26 00 BB FF FF FF FF EB DD }
	condition:
		$1
}

rule file_431_3_0 {
	meta:
		name = "inet6_opt_set_val"
		size = 60
		refs = "0029 memcpy"
	strings:
		$1 = { 83 EC 1C 89 5C 24 14 8B 44 24 20 8B 5C 24 24 89 74 24 18 8B 54 24 28 8B 74 24 2C 01 D8 89 54 24 04 89 74 24 08 89 04 24 E8 ?? ?? ?? ?? 8D 04 1E 8B 5C 24 14 8B 74 24 18 83 C4 1C C3 }
	condition:
		$1
}

rule file_431_4_0 {
	meta:
		name = "inet6_opt_next"
		size = 120
	strings:
		$1 = { 56 53 8B 44 24 14 8B 74 24 0C 8B 5C 24 10 85 C0 75 36 B0 02 8D 74 26 00 39 D8 73 11 8D 14 06 0F B6 0A 84 C9 75 12 83 C0 01 39 D8 72 EF B8 FF FF FF FF 5B 5E C3 8D 76 00 80 F9 01 75 13 0F B6 52 01 8D 44 10 02 EB D1 90 83 F8 01 77 CB EB DE 90 0F B6 72 01 8D 44 30 02 39 C3 72 D1 8B 5C 24 18 83 C2 02 88 0B 8B 4C 24 1C 0F B6 5A FF 89 19 8B 4C 24 20 89 11 5B 5E C3 }
	condition:
		$1
}

rule file_431_5_0 {
	meta:
		name = "inet6_opt_find"
		size = 152
	strings:
		$1 = { 55 57 56 53 8B 44 24 1C 8B 74 24 14 8B 6C 24 18 0F B6 7C 24 20 85 C0 75 57 B0 02 90 8D 74 26 00 39 E8 73 3E 8D 14 06 0F B6 0A 84 C9 75 22 89 FA 83 C0 01 84 D2 75 E9 8B 4C 24 24 01 C6 8B 5C 24 28 C7 01 00 00 00 00 89 33 5B 5E 5F 5D C3 66 90 89 FB 38 D9 74 22 0F B6 52 01 8D 44 10 02 39 E8 72 C2 5B B8 FF FF FF FF 5E 5F 5D C3 8D 74 26 00 83 F8 01 77 AB EB EB 90 0F B6 4A 01 8D 44 01 02 39 C5 72 DE 8B 5C 24 24 83 C2 02 89 0B 8B 4C 24 28 89 11 5B 5E 5F 5D C3 }
	condition:
		$1
}

rule file_431_6_0 {
	meta:
		name = "inet6_opt_get_val"
		size = 60
		refs = "0029 memcpy"
	strings:
		$1 = { 83 EC 1C 89 5C 24 14 8B 44 24 20 8B 5C 24 24 89 74 24 18 8B 74 24 2C 01 D8 89 44 24 04 8B 44 24 28 89 74 24 08 89 04 24 E8 ?? ?? ?? ?? 8D 04 1E 8B 5C 24 14 8B 74 24 18 83 C4 1C C3 }
	condition:
		$1
}

rule file_433_0_0 {
	meta:
		name = "setfsgid"
		size = 18
		refs = "000c _dl_sysinfo"
	strings:
		$1 = { 53 8B 5C 24 08 B8 D8 00 00 00 FF 15 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule file_435_0_0 {
	meta:
		name = "_nl_find_locale"
		size = 1118
		refs = "0022 __libc_enable_secure 0034 _nl_C_name 003f strcmp 0052 _nl_POSIX_name 006f _nl_load_locale_from_archive 0098 getenv 00aa _nl_category_name_idxs 00af _nl_category_names 00e1 _nl_C 0100 strchr 0110 _nl_default_locale_path 0125 _nl_expand_alias 0159 memcpy 0184 _nl_explode_name 0199 _nl_locale_file_list 01ef _nl_make_l10nflist 0292 _nl_C_locobj 02bf __gconv_compare_alias 02f5 __strcasecmp_l 0386 _nl_load_locale 0396 free 03b4 strrchr 03d4 __strndup 045a __assert_fail"
	strings:
		$1 = { 55 89 E5 83 EC 78 89 7D FC 8B 7D 08 89 75 F8 89 C6 89 5D F4 89 CB 89 55 C0 8B 07 80 38 00 74 70 8B 0D ?? ?? ?? ?? 85 C9 0F 85 C6 00 00 00 8B 17 C7 44 24 04 ?? ?? ?? ?? 89 14 24 89 55 C4 E8 ?? ?? ?? ?? 85 C0 0F 84 8D 00 00 00 8B 55 C4 C7 44 24 04 ?? ?? ?? ?? 89 14 24 E8 ?? ?? ?? ?? 85 C0 74 76 85 F6 0F 85 B4 00 00 00 89 FA 89 D8 E8 ?? ?? ?? ?? 85 C0 0F 84 92 00 00 00 8B 5D F4 8B 75 F8 8B 7D FC 89 EC 5D C2 04 00 8D B6 00 00 00 00 C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 89 07 74 05 80 38 00 75 41 0F B6 83 ?? ?? ?? ?? 05 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 85 C0 89 07 74 05 80 38 00 75 22 C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 89 07 75 12 C7 07 ?? ?? ?? ?? 8B 04 9D ?? ?? ?? ?? EB 94 90 8B 07 80 38 00 74 E9 E9 2C FF FF FF C7 44 24 04 2F 00 00 00 89 04 24 E8 ?? ?? ?? ?? 85 C0 75 D0 E9 21 FF FF FF 8B 17 BE ?? ?? ?? ?? C7 45 C0 10 00 00 00 89 55 C4 8B 55 C4 89 14 24 E8 ?? ?? ?? ?? 85 C0 89 C2 0F 84 6C 02 00 00 89 D7 31 C0 83 C9 FF F2 AE F7 D1 8D 41 1E 83 E0 F0 29 C4 8D 44 24 3B 83 E0 F0 89 4C 24 08 89 54 24 04 89 04 24 E8 ?? ?? ?? ?? 8D 55 E4 89 54 24 14 8D 55 E0 89 54 24 10 8D 55 DC 89 54 24 0C 8D 55 D8 89 54 24 08 8D 55 D4 89 54 24 04 89 04 24 E8 ?? ?? ?? ?? 89 C7 83 C0 01 0F 84 E9 01 00 00 8B 45 D8 8D 14 9D ?? ?? ?? ?? 0F B6 8B ?? ?? ?? ?? 89 14 24 C7 44 24 28 00 00 00 00 89 44 24 20 8B 45 E4 81 C1 ?? ?? ?? ?? 89 4C 24 24 89 7C 24 0C 89 44 24 1C 8B 45 E0 89 74 24 04 89 55 B8 89 4D BC 89 44 24 18 8B 45 DC 89 44 24 14 8B 45 D4 89 44 24 10 8B 45 C0 89 44 24 08 E8 ?? ?? ?? ?? 8B 55 B8 8B 4D BC 85 C0 89 45 C4 0F 84 27 01 00 00 83 E7 01 0F 85 82 01 00 00 8B 45 C4 83 78 04 00 0F 84 69 01 00 00 8B 45 C4 83 78 08 00 0F 84 B8 01 00 00 83 7D E0 00 0F 84 9A 00 00 00 8B 55 C4 8B 42 08 8B 14 9D ?? ?? ?? ?? 8B 54 90 24 85 D2 0F 84 F0 01 00 00 83 CE FF 89 D7 89 F1 31 C0 F2 AE F7 D1 83 C1 20 83 E1 F0 29 CC 8D 5C 24 3B 83 E3 F0 89 D8 E8 ?? ?? ?? ?? 8B 55 E0 89 F1 31 C0 89 D7 F2 AE F7 D1 83 C1 20 83 E1 F0 29 CC 8D 74 24 3B 83 E6 F0 89 F0 E8 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 89 D8 0F BE 10 83 C0 01 8B 14 91 88 50 FF 84 D2 75 F0 89 F2 0F BE 02 83 C2 01 8B 04 81 88 42 FF 84 C0 75 F0 89 DA 89 F0 E8 ?? ?? ?? ?? 85 C0 0F 85 B1 00 00 00 8B 45 C4 8B 58 08 83 3B 00 0F 84 CC 00 00 00 8B 45 D8 85 C0 74 42 C7 44 24 08 ?? ?? ?? ?? C7 44 24 04 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 85 C0 8B 45 C4 8B 58 08 75 07 C7 43 1C 01 00 00 00 8B 53 18 89 D8 83 FA FD 0F 87 63 FD FF FF 83 C2 01 89 53 18 E9 58 FD FF FF 8B 45 C4 8B 58 08 EB DF 8B 45 D8 C7 44 24 28 01 00 00 00 89 4C 24 24 89 7C 24 0C 89 44 24 20 8B 45 E4 89 74 24 04 89 14 24 89 44 24 1C 8B 45 E0 89 44 24 18 8B 45 DC 89 44 24 14 8B 45 D4 89 44 24 10 8B 45 C0 89 44 24 08 E8 ?? ?? ?? ?? 85 C0 89 45 C4 0F 85 88 FE FF FF 31 C0 E9 F8 FC FF FF 89 DA E8 ?? ?? ?? ?? E9 8B FE FF FF 8B 45 E4 89 04 24 E8 ?? ?? ?? ?? E9 6E FE FF FF 8B 17 E9 8D FD FF FF C7 44 24 04 2F 00 00 00 8B 00 89 04 24 E8 ?? ?? ?? ?? 80 78 FE 2F 8D 50 FF 74 09 83 EA 01 80 7A FF 2F 75 F7 29 D0 89 44 24 04 89 14 24 E8 ?? ?? ?? ?? 89 03 E9 FB FE FF FF 89 C2 8B 40 10 85 C0 74 2F 89 D7 31 F6 EB 19 66 90 8B 47 10 8B 40 08 85 C0 75 1F 83 C7 04 8B 47 10 83 C6 01 85 C0 74 12 8B 50 04 85 D2 75 E2 89 DA E8 ?? ?? ?? ?? EB D9 31 F6 8B 55 C4 83 C6 04 8B 04 B2 89 42 10 8B 34 B2 85 F6 89 75 C4 0F 85 F4 FD FF FF 31 C0 E9 41 FC FF FF C7 44 24 0C ?? ?? ?? ?? C7 44 24 08 E4 00 00 00 C7 44 24 04 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_435_1_0 {
	meta:
		name = "_nl_remove_locale"
		size = 58
		refs = "000f _nl_locale_file_list 0031 _nl_unload_locale"
	strings:
		$1 = { 83 6A 18 01 75 32 83 7A 0C 02 74 22 8B 0C 85 ?? ?? ?? ?? 39 51 08 74 08 8B 49 0C 39 51 08 75 F8 C7 41 04 00 00 00 00 C7 41 08 00 00 00 00 89 D0 E9 ?? ?? ?? ?? 8D 76 00 F3 C3 }
	condition:
		$1
}

rule file_435_2_0 {
	meta:
		name = "strip"
		size = 104
		refs = "0006 _nl_C_locobj"
	strings:
		$1 = { 55 31 ED 57 8B 3D ?? ?? ?? ?? 56 8B 35 ?? ?? ?? ?? 53 EB 36 0F BE D9 F6 04 5E 08 75 14 80 F9 2C 7C 18 80 F9 2E 7E 0A 80 F9 3A 74 05 80 F9 5F 75 09 8B 0C 9F 40 88 48 FF EB 0F 80 F9 2F 75 0A 45 83 FD 03 74 13 C6 00 2F 40 42 8A 0A 84 C9 75 C4 EB 06 C6 00 2F 40 EB 02 29 C5 8D 14 28 4A 7E F2 5B C6 00 00 5E 5F 5D C3 }
	condition:
		$1
}

rule file_436_0_0 {
	meta:
		name = "__xstat64_conv"
		size = 189
		refs = "0010 __libc_errno"
	strings:
		$1 = { 83 7C 24 04 03 8B 54 24 08 8B 44 24 0C 74 19 A1 ?? ?? ?? ?? 65 C7 00 16 00 00 00 B8 FF F