@samples
Feature: Basic smell detection
  In order to write better software
  As a developer
  I want to detect the smels in my Ruby code

  @inline
  Scenario: Correct smells from inline.rb
    When I run reek spec/samples/inline.rb
    Then the exit status indicates smells
    And it reports:
    """
    spec/samples/inline.rb -- 41 warnings:
      File has no descriptive comment (IrresponsibleModule)
      Inline declares the class variable @@directory (ClassVariable)
      Inline declares the class variable @@rootdir (ClassVariable)
      Inline#self.rootdir calls env.nil? twice (Duplication)
      Inline#self.rootdir has approx 8 statements (LongMethod)
      Inline::C declares the class variable @@type_map (ClassVariable)
      Inline::C has at least 13 instance variables (LargeClass)
      Inline::C takes parameters [options, src] to 5 methods (DataClump)
      Inline::C tests $DEBUG at least 7 times (SimulatedPolymorphism)
      Inline::C tests $TESTING at least 4 times (SimulatedPolymorphism)
      Inline::C tests @@type_map.has_key?(type) at least 3 times (SimulatedPolymorphism)
      Inline::C#build calls ($? == 0) twice (Duplication)
      Inline::C#build calls Inline.directory 5 times (Duplication)
      Inline::C#build calls io.puts 6 times (Duplication)
      Inline::C#build calls io.puts("#endif") twice (Duplication)
      Inline::C#build calls io.puts("#ifdef __cplusplus") twice (Duplication)
      Inline::C#build calls module_name twice (Duplication)
      Inline::C#build calls warn("Output:\n#{result}") twice (Duplication)
      Inline::C#build contains iterators nested 2 deep (NestedIterators)
      Inline::C#build has approx 60 statements (LongMethod)
      Inline::C#build has the variable name 'n' (UncommunicativeName)
      Inline::C#build has the variable name 't' (UncommunicativeName)
      Inline::C#c has the name 'c' (UncommunicativeName)
      Inline::C#crap_for_windoze calls Config::CONFIG["libdir"] twice (Duplication)
      Inline::C#generate calls result.sub!(/\A\n/, "") twice (Duplication)
      Inline::C#generate calls signature["args"] twice (Duplication)
      Inline::C#generate calls signature["args"].map twice (Duplication)
      Inline::C#generate has approx 32 statements (LongMethod)
      Inline::C#initialize calls stack.empty? twice (Duplication)
      Inline::C#load calls so_name twice (Duplication)
      Inline::C#module_name has the variable name 'm' (UncommunicativeName)
      Inline::C#module_name has the variable name 'x' (UncommunicativeName)
      Inline::C#parse_signature has approx 15 statements (LongMethod)
      Inline::C#parse_signature has boolean parameter 'raw' (ControlCouple)
      Inline::C#parse_signature has the variable name 'x' (UncommunicativeName)
      Inline::C#parse_signature is controlled by argument raw (ControlCouple)
      Inline::C#strip_comments doesn't depend on instance state (LowCohesion)
      Inline::C#strip_comments refers to src more than self (LowCohesion)
      Module#inline calls Inline.const_get(lang) twice (Duplication)
      Module#inline has approx 11 statements (LongMethod)
      Module#inline is controlled by argument options (ControlCouple)

    """

  Scenario: Correct smells from optparse.rb
    When I run reek spec/samples/optparse.rb
    Then the exit status indicates smells
    And it reports:
    """
    spec/samples/optparse.rb -- 109 warnings:
      OptionParser has at least 42 methods (LargeClass)
      OptionParser has the variable name 'f' (UncommunicativeName)
      OptionParser has the variable name 'k' (UncommunicativeName)
      OptionParser has the variable name 'o' (UncommunicativeName)
      OptionParser has the variable name 's' (UncommunicativeName)
      OptionParser has the variable name 'v' (UncommunicativeName)
      OptionParser tests ((argv.size == 1) and Array.===(argv[0])) at least 3 times (SimulatedPolymorphism)
      OptionParser tests a at least 7 times (SimulatedPolymorphism)
      OptionParser tests default_pattern at least 7 times (SimulatedPolymorphism)
      OptionParser tests not_style at least 3 times (SimulatedPolymorphism)
      OptionParser tests s at least 7 times (SimulatedPolymorphism)
      OptionParser#complete contains iterators nested 2 deep (NestedIterators)
      OptionParser#complete has 4 parameters (LongParameterList)
      OptionParser#complete has boolean parameter 'icase' (ControlCouple)
      OptionParser#getopts calls result[opt] = false twice (Duplication)
      OptionParser#getopts has approx 17 statements (LongMethod)
      OptionParser#load has the variable name 's' (UncommunicativeName)
      OptionParser#make_switch calls (long << o = q.downcase) twice (Duplication)
      OptionParser#make_switch calls (sdesc << "-#{q}") twice (Duplication)
      OptionParser#make_switch calls default_style.guess(arg = a) 4 times (Duplication)
      OptionParser#make_switch calls notwice(NilClass, klass, "type") twice (Duplication)
      OptionParser#make_switch calls notwice(a ? (Object) : (TrueClass), klass, "type") twice (Duplication)
      OptionParser#make_switch calls pattern.method(:convert) twice (Duplication)
      OptionParser#make_switch calls pattern.method(:convert).to_proc twice (Duplication)
      OptionParser#make_switch calls pattern.respond_to?(:convert) twice (Duplication)
      OptionParser#make_switch calls q.downcase 3 times (Duplication)
      OptionParser#make_switch calls search(:atype, FalseClass) twice (Duplication)
      OptionParser#make_switch calls search(:atype, o) 6 times (Duplication)
      OptionParser#make_switch contains iterators nested 2 deep (NestedIterators)
      OptionParser#make_switch contains iterators nested 3 deep (NestedIterators)
      OptionParser#make_switch has approx 68 statements (LongMethod)
      OptionParser#make_switch has the variable name 'a' (UncommunicativeName)
      OptionParser#make_switch has the variable name 'c' (UncommunicativeName)
      OptionParser#make_switch has the variable name 'n' (UncommunicativeName)
      OptionParser#make_switch has the variable name 'o' (UncommunicativeName)
      OptionParser#make_switch has the variable name 'q' (UncommunicativeName)
      OptionParser#make_switch has the variable name 's' (UncommunicativeName)
      OptionParser#make_switch has the variable name 'v' (UncommunicativeName)
      OptionParser#order calls argv[0] twice (Duplication)
      OptionParser#order refers to argv more than self (LowCohesion)
      OptionParser#parse calls argv[0] twice (Duplication)
      OptionParser#parse refers to argv more than self (LowCohesion)
      OptionParser#parse_in_order calls $!.set_option(arg, true) twice (Duplication)
      OptionParser#parse_in_order calls cb.call(val) twice (Duplication)
      OptionParser#parse_in_order calls raise($!.set_option(arg, true)) twice (Duplication)
      OptionParser#parse_in_order calls raise(*exc) twice (Duplication)
      OptionParser#parse_in_order calls setter.call(sw.switch_name, val) twice (Duplication)
      OptionParser#parse_in_order calls sw.block twice (Duplication)
      OptionParser#parse_in_order calls sw.switch_name twice (Duplication)
      OptionParser#parse_in_order contains iterators nested 2 deep (NestedIterators)
      OptionParser#parse_in_order contains iterators nested 3 deep (NestedIterators)
      OptionParser#parse_in_order has approx 28 statements (LongMethod)
      OptionParser#parse_in_order is controlled by argument setter (ControlCouple)
      OptionParser#permute calls argv[0] twice (Duplication)
      OptionParser#permute refers to argv more than self (LowCohesion)
      OptionParser#search has the variable name 'k' (UncommunicativeName)
      OptionParser#summarize has 4 parameters (LongParameterList)
      OptionParser#summarize has the variable name 'l' (UncommunicativeName)
      OptionParser#ver has the variable name 'v' (UncommunicativeName)
      OptionParser::CompletingHash#match contains iterators nested 2 deep (NestedIterators)
      OptionParser::Completion#complete calls candidates.size twice (Duplication)
      OptionParser::Completion#complete calls k.id2name twice (Duplication)
      OptionParser::Completion#complete has approx 22 statements (LongMethod)
      OptionParser::Completion#complete has boolean parameter 'icase' (ControlCouple)
      OptionParser::Completion#complete has the variable name 'k' (UncommunicativeName)
      OptionParser::Completion#complete has the variable name 'v' (UncommunicativeName)
      OptionParser::Completion#complete refers to candidates more than self (LowCohesion)
      OptionParser::List#accept has the parameter name 't' (UncommunicativeName)
      OptionParser::List#accept is controlled by argument pat (ControlCouple)
      OptionParser::List#accept refers to pat more than self (LowCohesion)
      OptionParser::List#add_banner refers to opt more than self (LowCohesion)
      OptionParser::List#complete has 4 parameters (LongParameterList)
      OptionParser::List#complete has boolean parameter 'icase' (ControlCouple)
      OptionParser::List#reject has the parameter name 't' (UncommunicativeName)
      OptionParser::List#summarize refers to opt more than self (LowCohesion)
      OptionParser::List#update has 5 parameters (LongParameterList)
      OptionParser::List#update has approx 6 statements (LongMethod)
      OptionParser::List#update has the variable name 'o' (UncommunicativeName)
      OptionParser::List#update is controlled by argument lopts (ControlCouple)
      OptionParser::List#update is controlled by argument sopts (ControlCouple)
      OptionParser::ParseError#set_option is controlled by argument eq (ControlCouple)
      OptionParser::Switch#add_banner has the variable name 's' (UncommunicativeName)
      OptionParser::Switch#conv_arg calls conv twice (Duplication)
      OptionParser::Switch#initialize has 7 parameters (LongParameterList)
      OptionParser::Switch#parse_arg calls pattern twice (Duplication)
      OptionParser::Switch#parse_arg calls s.length twice (Duplication)
      OptionParser::Switch#parse_arg has approx 11 statements (LongMethod)
      OptionParser::Switch#parse_arg has the variable name 'm' (UncommunicativeName)
      OptionParser::Switch#parse_arg has the variable name 's' (UncommunicativeName)
      OptionParser::Switch#self.guess has the variable name 't' (UncommunicativeName)
      OptionParser::Switch#self.incompatible_argument_styles has the parameter name 't' (UncommunicativeName)
      OptionParser::Switch#summarize calls (indent + l) twice (Duplication)
      OptionParser::Switch#summarize calls arg 4 times (Duplication)
      OptionParser::Switch#summarize calls left.collect twice (Duplication)
      OptionParser::Switch#summarize calls left.collect { |s| s.length }.max twice (Duplication)
      OptionParser::Switch#summarize calls left.collect { |s| s.length }.max.to_i twice (Duplication)
      OptionParser::Switch#summarize calls left.shift twice (Duplication)
      OptionParser::Switch#summarize calls left[-1] 3 times (Duplication)
      OptionParser::Switch#summarize calls s.length 3 times (Duplication)
      OptionParser::Switch#summarize contains iterators nested 2 deep (NestedIterators)
      OptionParser::Switch#summarize has 5 parameters (LongParameterList)
      OptionParser::Switch#summarize has approx 25 statements (LongMethod)
      OptionParser::Switch#summarize has the variable name 'l' (UncommunicativeName)
      OptionParser::Switch#summarize has the variable name 'r' (UncommunicativeName)
      OptionParser::Switch#summarize has the variable name 's' (UncommunicativeName)
      OptionParser::Switch::NoArgument#parse is controlled by argument arg (ControlCouple)
      OptionParser::Switch::OptionalArgument#parse is controlled by argument arg (ControlCouple)
      OptionParser::Switch::PlacedArgument#parse has approx 6 statements (LongMethod)
      OptionParser::Switch::RequiredArgument#parse is controlled by argument arg (ControlCouple)

    """

  Scenario: Correct smells from redcloth.rb
    When I run reek spec/samples/redcloth.rb
    Then the exit status indicates smells
    And it reports:
    """
    spec/samples/redcloth.rb -- 97 warnings:
      RedCloth has at least 44 methods (LargeClass)
      RedCloth has the variable name 'a' (UncommunicativeName)
      RedCloth has the variable name 'b' (UncommunicativeName)
      RedCloth takes parameters [atts, cite, content, tag] to 3 methods (DataClump)
      RedCloth tests atts at least 6 times (SimulatedPolymorphism)
      RedCloth tests codepre.zero? at least 3 times (SimulatedPolymorphism)
      RedCloth tests href at least 3 times (SimulatedPolymorphism)
      RedCloth tests title at least 4 times (SimulatedPolymorphism)
      RedCloth#block_markdown_atx refers to text more than self (LowCohesion)
      RedCloth#block_markdown_bq has approx 6 statements (LongMethod)
      RedCloth#block_markdown_rule refers to text more than self (LowCohesion)
      RedCloth#block_markdown_setext refers to text more than self (LowCohesion)
      RedCloth#block_textile_lists calls (line_id - 1) twice (Duplication)
      RedCloth#block_textile_lists calls depth.last 5 times (Duplication)
      RedCloth#block_textile_lists calls depth.last.length twice (Duplication)
      RedCloth#block_textile_lists calls depth[i] twice (Duplication)
      RedCloth#block_textile_lists calls lines[(line_id - 1)] twice (Duplication)
      RedCloth#block_textile_lists calls tl.length 3 times (Duplication)
      RedCloth#block_textile_lists contains iterators nested 3 deep (NestedIterators)
      RedCloth#block_textile_lists has approx 20 statements (LongMethod)
      RedCloth#block_textile_lists has the variable name 'i' (UncommunicativeName)
      RedCloth#block_textile_lists has the variable name 'v' (UncommunicativeName)
      RedCloth#block_textile_lists refers to depth more than self (LowCohesion)
      RedCloth#block_textile_table contains iterators nested 2 deep (NestedIterators)
      RedCloth#block_textile_table contains iterators nested 3 deep (NestedIterators)
      RedCloth#block_textile_table has approx 18 statements (LongMethod)
      RedCloth#block_textile_table has the variable name 'x' (UncommunicativeName)
      RedCloth#blocks contains iterators nested 2 deep (NestedIterators)
      RedCloth#blocks has approx 18 statements (LongMethod)
      RedCloth#blocks has boolean parameter 'deep_code' (ControlCouple)
      RedCloth#blocks is controlled by argument deep_code (ControlCouple)
      RedCloth#check_refs is controlled by argument text (ControlCouple)
      RedCloth#clean_html calls tags[tag] twice (Duplication)
      RedCloth#clean_html contains iterators nested 3 deep (NestedIterators)
      RedCloth#clean_html doesn't depend on instance state (LowCohesion)
      RedCloth#clean_html has approx 14 statements (LongMethod)
      RedCloth#clean_html has the variable name 'q' (UncommunicativeName)
      RedCloth#clean_html has the variable name 'q2' (UncommunicativeName)
      RedCloth#clean_html refers to raw more than self (LowCohesion)
      RedCloth#clean_html refers to tags more than self (LowCohesion)
      RedCloth#clean_white_space has approx 7 statements (LongMethod)
      RedCloth#clean_white_space refers to text more than self (LowCohesion)
      RedCloth#flush_left doesn't depend on instance state (LowCohesion)
      RedCloth#flush_left refers to indt more than self (LowCohesion)
      RedCloth#flush_left refers to text more than self (LowCohesion)
      RedCloth#footnote_ref refers to text more than self (LowCohesion)
      RedCloth#glyphs_textile has approx 10 statements (LongMethod)
      RedCloth#htmlesc doesn't depend on instance state (LowCohesion)
      RedCloth#htmlesc refers to str more than self (LowCohesion)
      RedCloth#incoming_entities refers to text more than self (LowCohesion)
      RedCloth#initialize has the variable name 'r' (UncommunicativeName)
      RedCloth#inline contains iterators nested 2 deep (NestedIterators)
      RedCloth#inline_markdown_link has approx 6 statements (LongMethod)
      RedCloth#inline_markdown_link has the variable name 'm' (UncommunicativeName)
      RedCloth#inline_markdown_reflink has approx 8 statements (LongMethod)
      RedCloth#inline_markdown_reflink has the variable name 'm' (UncommunicativeName)
      RedCloth#inline_textile_code has the variable name 'm' (UncommunicativeName)
      RedCloth#inline_textile_image has approx 17 statements (LongMethod)
      RedCloth#inline_textile_image has the variable name 'href_a1' (UncommunicativeName)
      RedCloth#inline_textile_image has the variable name 'href_a2' (UncommunicativeName)
      RedCloth#inline_textile_image has the variable name 'm' (UncommunicativeName)
      RedCloth#inline_textile_link has approx 9 statements (LongMethod)
      RedCloth#inline_textile_link has the variable name 'm' (UncommunicativeName)
      RedCloth#inline_textile_span contains iterators nested 2 deep (NestedIterators)
      RedCloth#inline_textile_span has approx 8 statements (LongMethod)
      RedCloth#inline_textile_span has the variable name 'm' (UncommunicativeName)
      RedCloth#lT has the name 'lT' (UncommunicativeName)
      RedCloth#no_textile doesn't depend on instance state (LowCohesion)
      RedCloth#no_textile refers to text more than self (LowCohesion)
      RedCloth#pba calls $1.length twice (Duplication)
      RedCloth#pba has approx 21 statements (LongMethod)
      RedCloth#pba is controlled by argument text_in (ControlCouple)
      RedCloth#pba refers to style more than self (LowCohesion)
      RedCloth#pba refers to text more than self (LowCohesion)
      RedCloth#refs_markdown has the variable name 'm' (UncommunicativeName)
      RedCloth#refs_textile has the variable name 'm' (UncommunicativeName)
      RedCloth#retrieve has the variable name 'i' (UncommunicativeName)
      RedCloth#retrieve has the variable name 'r' (UncommunicativeName)
      RedCloth#rip_offtags calls ((codepre - used_offtags.length) > 0) twice (Duplication)
      RedCloth#rip_offtags calls (@pre_list.last << line) twice (Duplication)
      RedCloth#rip_offtags calls (codepre - used_offtags.length) twice (Duplication)
      RedCloth#rip_offtags calls @pre_list.last twice (Duplication)
      RedCloth#rip_offtags calls codepre.zero? twice (Duplication)
      RedCloth#rip_offtags calls htmlesc(line, :NoQuotes) twice (Duplication)
      RedCloth#rip_offtags calls used_offtags.length twice (Duplication)
      RedCloth#rip_offtags calls used_offtags["notextile"] 3 times (Duplication)
      RedCloth#rip_offtags has approx 18 statements (LongMethod)
      RedCloth#textile_bq has 4 parameters (LongParameterList)
      RedCloth#textile_bq is controlled by argument atts (ControlCouple)
      RedCloth#textile_bq is controlled by argument cite (ControlCouple)
      RedCloth#textile_fn_ has 5 parameters (LongParameterList)
      RedCloth#textile_fn_ is controlled by argument atts (ControlCouple)
      RedCloth#textile_p has 4 parameters (LongParameterList)
      RedCloth#textile_p is controlled by argument atts (ControlCouple)
      RedCloth#textile_popup_help has the parameter name 'windowH' (UncommunicativeName)
      RedCloth#textile_popup_help has the parameter name 'windowW' (UncommunicativeName)
      RedCloth#to_html has approx 24 statements (LongMethod)

    """
