# -*- encoding: utf-8 -*-

Gem::Specification.new do |s|
  s.name = "ParseTree"
  s.version = "3.0.5"

  s.required_rubygems_version = Gem::Requirement.new(">= 0") if s.respond_to? :required_rubygems_version=
  s.authors = ["Ryan Davis"]
  s.date = "2010-03-27"
  s.description = "ParseTree is a C extension (using RubyInline) that extracts the parse\ntree for an entire class or a specific method and returns it as a\ns-expression (aka sexp) using ruby's arrays, strings, symbols, and\nintegers.\n\nAs an example:\n\n  def conditional1(arg1)\n    if arg1 == 0 then\n      return 1\n    end\n    return 0\n  end\n\nbecomes:\n\n  [:defn,\n    :conditional1,\n    [:scope,\n     [:block,\n      [:args, :arg1],\n      [:if,\n       [:call, [:lvar, :arg1], :==, [:array, [:lit, 0]]],\n       [:return, [:lit, 1]],\n       nil],\n      [:return, [:lit, 0]]]]]"
  s.email = ["ryand-ruby@zenspider.com"]
  s.executables = ["parse_tree_abc", "parse_tree_audit", "parse_tree_deps", "parse_tree_show"]
  s.extra_rdoc_files = ["History.txt", "Manifest.txt", "README.txt"]
  s.files = ["bin/parse_tree_abc", "bin/parse_tree_audit", "bin/parse_tree_deps", "bin/parse_tree_show", "History.txt", "Manifest.txt", "README.txt"]
  s.homepage = "http://rubyforge.org/projects/parsetree/"
  s.rdoc_options = ["--main", "README.txt"]
  s.require_paths = ["lib", "test"]
  s.rubyforge_project = "parsetree"
  s.rubygems_version = "1.8.23.2"
  s.summary = "ParseTree is a C extension (using RubyInline) that extracts the parse tree for an entire class or a specific method and returns it as a s-expression (aka sexp) using ruby's arrays, strings, symbols, and integers"

  if s.respond_to? :specification_version then
    s.specification_version = 3

    if Gem::Version.new(Gem::VERSION) >= Gem::Version.new('1.2.0') then
      s.add_runtime_dependency(%q<RubyInline>, [">= 3.7.0"])
      s.add_runtime_dependency(%q<sexp_processor>, [">= 3.0.0"])
      s.add_development_dependency(%q<rubyforge>, [">= 2.0.4"])
      s.add_development_dependency(%q<minitest>, [">= 1.6.0"])
      s.add_development_dependency(%q<hoe>, [">= 2.6.0"])
    else
      s.add_dependency(%q<RubyInline>, [">= 3.7.0"])
      s.add_dependency(%q<sexp_processor>, [">= 3.0.0"])
      s.add_dependency(%q<rubyforge>, [">= 2.0.4"])
      s.add_dependency(%q<minitest>, [">= 1.6.0"])
      s.add_dependency(%q<hoe>, [">= 2.6.0"])
    end
  else
    s.add_dependency(%q<RubyInline>, [">= 3.7.0"])
    s.add_dependency(%q<sexp_processor>, [">= 3.0.0"])
    s.add_dependency(%q<rubyforge>, [">= 2.0.4"])
    s.add_dependency(%q<minitest>, [">= 1.6.0"])
    s.add_dependency(%q<hoe>, [">= 2.6.0"])
  end
end
