
#line 1 "/Users/aslakhellesoy/scm/gherkin/tasks/../ragel/i18n/ru.c.rl"
#include <assert.h>
#include <ruby.h>

#if defined(_WIN32)
#include <stddef.h>
#endif

#ifdef HAVE_RUBY_RE_H
#include <ruby/re.h>
#else
#include <re.h>
#endif

#ifdef HAVE_RUBY_ENCODING_H
#include <ruby/encoding.h>
#define ENCODED_STR_NEW(ptr, len) \
    rb_enc_str_new(ptr, len, rb_utf8_encoding())
#else
#define ENCODED_STR_NEW(ptr, len) \
    rb_str_new(ptr, len)
#endif

#define LF_FLAG      0
#define CRLF_FLAG    1
#define LF           "\n"
#define CRLF         "\r\n"

#ifndef RSTRING_PTR
#define RSTRING_PTR(s) (RSTRING(s)->ptr)
#endif

#ifndef RSTRING_LEN
#define RSTRING_LEN(s) (RSTRING(s)->len)
#endif

#define DATA_GET(FROM, TYPE, NAME) \
  Data_Get_Struct(FROM, TYPE, NAME); \
  if (NAME == NULL) { \
    rb_raise(rb_eArgError, "NULL found for " # NAME " when it shouldn't be."); \
  }
 
typedef struct lexer_state {
  int content_len;
  int line_number;
  int current_line;
  int start_col;
  int eol;
  size_t mark;
  size_t keyword_start;
  size_t keyword_end;
  size_t next_keyword_start;
  size_t content_start;
  size_t content_end;
  size_t query_start;
  size_t last_newline;
  size_t final_newline;
} lexer_state;

static VALUE mGherkin;
static VALUE mCLexer;
static VALUE cI18nLexer;
static VALUE rb_eGherkinLexingError;

#define LEN(AT, P) (P - data - lexer->AT)
#define MARK(M, P) (lexer->M = (P) - data)
#define PTR_TO(P) (data + lexer->P)

#define STORE_KW_END_CON(EVENT) \
  store_multiline_kw_con(listener, # EVENT, \
    PTR_TO(keyword_start), LEN(keyword_start, PTR_TO(keyword_end - 1)), \
    PTR_TO(content_start), LEN(content_start, PTR_TO(content_end)), \
    lexer->current_line, lexer->eol); \
    if (lexer->content_end != 0) { \
      p = PTR_TO(content_end - 1); \
    } \
    lexer->content_end = 0

#define STORE_ATTR(ATTR) \
    store_attr(listener, # ATTR, \
      PTR_TO(content_start), LEN(content_start, p), \
      lexer->line_number)


#line 239 "/Users/aslakhellesoy/scm/gherkin/tasks/../ragel/i18n/ru.c.rl"


/** Data **/

#line 92 "ext/gherkin_lexer_ru/gherkin_lexer_ru.c"
static const char _lexer_actions[] = {
	0, 1, 0, 1, 1, 1, 2, 1, 
	3, 1, 4, 1, 5, 1, 6, 1, 
	7, 1, 8, 1, 9, 1, 10, 1, 
	11, 1, 14, 1, 15, 1, 16, 1, 
	17, 1, 18, 1, 19, 1, 20, 1, 
	21, 2, 1, 16, 2, 11, 0, 2, 
	12, 13, 2, 15, 0, 2, 15, 2, 
	2, 15, 14, 2, 15, 17, 2, 16, 
	4, 2, 16, 5, 2, 16, 6, 2, 
	16, 7, 2, 16, 8, 2, 16, 14, 
	2, 18, 19, 2, 20, 0, 2, 20, 
	2, 2, 20, 14, 2, 20, 17, 3, 
	3, 12, 13, 3, 9, 12, 13, 3, 
	10, 12, 13, 3, 11, 12, 13, 3, 
	12, 13, 16, 3, 15, 12, 13, 4, 
	1, 12, 13, 16, 4, 15, 0, 12, 
	13
};

static const short _lexer_key_offsets[] = {
	0, 0, 12, 23, 24, 25, 27, 38, 
	39, 40, 44, 49, 54, 59, 64, 68, 
	72, 74, 75, 76, 77, 78, 79, 80, 
	81, 82, 83, 84, 85, 86, 87, 88, 
	89, 94, 101, 106, 110, 116, 119, 121, 
	127, 138, 139, 141, 142, 143, 144, 145, 
	146, 147, 148, 149, 150, 151, 152, 153, 
	154, 155, 156, 157, 158, 159, 160, 161, 
	162, 163, 164, 165, 166, 167, 168, 169, 
	170, 171, 172, 173, 174, 175, 176, 177, 
	178, 179, 180, 187, 189, 192, 194, 196, 
	198, 200, 202, 204, 215, 217, 219, 221, 
	223, 225, 227, 229, 231, 233, 235, 237, 
	239, 241, 243, 245, 247, 249, 251, 252, 
	253, 254, 255, 256, 257, 258, 259, 260, 
	261, 262, 263, 264, 265, 266, 267, 268, 
	269, 270, 271, 272, 274, 275, 276, 277, 
	278, 279, 280, 281, 282, 283, 284, 285, 
	286, 287, 288, 289, 290, 291, 292, 293, 
	294, 295, 304, 315, 317, 319, 322, 324, 
	326, 328, 330, 332, 334, 336, 338, 340, 
	342, 344, 346, 348, 350, 352, 354, 356, 
	358, 360, 362, 364, 366, 369, 371, 373, 
	375, 377, 379, 381, 383, 385, 387, 389, 
	391, 393, 395, 397, 399, 401, 403, 405, 
	407, 409, 411, 413, 415, 417, 419, 421, 
	423, 425, 427, 430, 432, 434, 436, 438, 
	440, 442, 444, 446, 448, 450, 452, 454, 
	456, 458, 460, 462, 464, 466, 468, 470, 
	472, 474, 476, 478, 480, 482, 484, 486, 
	488, 490, 492, 494, 496, 498, 500, 502, 
	504, 506, 508, 510, 512, 514, 516, 518, 
	520, 522, 525, 528, 530, 532, 534, 536, 
	538, 540, 542, 544, 546, 548, 550, 552, 
	554, 556, 558, 560, 562, 564, 566, 568, 
	570, 572, 574, 576, 578, 580, 582, 584, 
	586, 588, 590, 592, 594, 596, 598, 600, 
	601, 602, 603, 604, 605, 606, 607, 609, 
	610, 611, 612, 613, 614, 615, 616, 617, 
	618, 619, 620, 621, 622, 623, 624, 625, 
	626, 627, 628, 629, 630, 631, 632, 633, 
	634, 635, 636, 637, 638, 639, 640, 641, 
	642, 643, 652, 663, 665, 667, 670, 672, 
	674, 676, 678, 680, 682, 684, 686, 688, 
	690, 692, 694, 696, 698, 700, 702, 704, 
	706, 708, 710, 712, 714, 717, 719, 721, 
	723, 725, 727, 729, 731, 733, 735, 737, 
	739, 741, 743, 745, 747, 749, 751, 753, 
	755, 757, 759, 761, 763, 765, 767, 769, 
	771, 773, 775, 777, 779, 781, 783, 785, 
	787, 789, 791, 793, 795, 797, 799, 801, 
	803, 805, 807, 810, 813, 815, 817, 819, 
	821, 823, 825, 827, 829, 831, 833, 835, 
	837, 839, 841, 843, 845, 847, 849, 851, 
	853, 855, 857, 859, 861, 863, 865, 867, 
	869, 871, 873, 875, 877, 879, 881, 883, 
	885, 886, 887, 888, 889, 890, 891, 892, 
	893, 894, 895, 896, 897, 898, 899, 900, 
	909, 920, 922, 924, 927, 929, 931, 933, 
	935, 937, 939, 941, 943, 945, 947, 949, 
	951, 953, 955, 957, 959, 961, 963, 965, 
	967, 969, 971, 974, 976, 978, 980, 982, 
	984, 986, 988, 990, 992, 994, 996, 998, 
	1000, 1002, 1004, 1006, 1008, 1010, 1012, 1014, 
	1016, 1019, 1021, 1023, 1025, 1027, 1029, 1031, 
	1033, 1035, 1037, 1039, 1041, 1043, 1045, 1047, 
	1049, 1051, 1053, 1055, 1057, 1059, 1061, 1063, 
	1065, 1067, 1069, 1071, 1074, 1076, 1078, 1080, 
	1082, 1084, 1086, 1088, 1090, 1092, 1094, 1096, 
	1098, 1100, 1102, 1104, 1106, 1108, 1110, 1112, 
	1114, 1116, 1118, 1120, 1122, 1124, 1126, 1128, 
	1130, 1132, 1134, 1136, 1138, 1140, 1142, 1144, 
	1146, 1148, 1150, 1152, 1155, 1158, 1160, 1162, 
	1164, 1166, 1168, 1170, 1172, 1174, 1176, 1178, 
	1180, 1182, 1184, 1186, 1188, 1190, 1192, 1194, 
	1196, 1198, 1200, 1202, 1204, 1206, 1208, 1210, 
	1212, 1214, 1216, 1218, 1220, 1222, 1224, 1226, 
	1228, 1230, 1231, 1232, 1234, 1236, 1237, 1238, 
	1239, 1240, 1241, 1242, 1243, 1244, 1252, 1257, 
	1259, 1261, 1263, 1265, 1267, 1269, 1271, 1273, 
	1275, 1277, 1279, 1281, 1283, 1285, 1287, 1289, 
	1291, 1293, 1295, 1297, 1299, 1301, 1303, 1305, 
	1307, 1309, 1311, 1313, 1315, 1317, 1319, 1321, 
	1324, 1326, 1328, 1330, 1332, 1334, 1336, 1338, 
	1340, 1342, 1344, 1346, 1348, 1350, 1352, 1354, 
	1356, 1358, 1360, 1362, 1364, 1366, 1368, 1370, 
	1372, 1374, 1376, 1378, 1380, 1382, 1384, 1386, 
	1388, 1390, 1392, 1394, 1396, 1398, 1401, 1403, 
	1405, 1407, 1409, 1411, 1413, 1415, 1417, 1419, 
	1421, 1423, 1425, 1427, 1429, 1431, 1433, 1435, 
	1437, 1439, 1441, 1443, 1445, 1447, 1449, 1451, 
	1453, 1455, 1457, 1459, 1461, 1463, 1465, 1467, 
	1469, 1471, 1473, 1474, 1475, 1476, 1477, 1478, 
	1479, 1480, 1481, 1482, 1483, 1484, 1485, 1486, 
	1487, 1488, 1489, 1490, 1491, 1492
};

static const char _lexer_trans_keys[] = {
	-48, -17, 10, 32, 34, 35, 37, 42, 
	64, 124, 9, 13, -112, -108, -107, -105, 
	-104, -102, -99, -97, -95, -94, -92, 32, 
	10, 10, 13, -48, 10, 32, 34, 35, 
	37, 42, 64, 124, 9, 13, 34, 34, 
	10, 32, 9, 13, 10, 32, 34, 9, 
	13, 10, 32, 34, 9, 13, 10, 32, 
	34, 9, 13, 10, 32, 34, 9, 13, 
	10, 32, 9, 13, 10, 32, 9, 13, 
	10, 13, 10, 95, 70, 69, 65, 84, 
	85, 82, 69, 95, 69, 78, 68, 95, 
	37, 13, 32, 64, 9, 10, 9, 10, 
	13, 32, 64, 11, 12, 10, 32, 64, 
	9, 13, 32, 124, 9, 13, 10, 32, 
	92, 124, 9, 13, 10, 92, 124, 10, 
	92, 10, 32, 92, 124, 9, 13, -48, 
	10, 32, 34, 35, 37, 42, 64, 124, 
	9, 13, -48, -80, -66, -48, -67, -48, 
	-66, -48, -65, -47, -125, -47, -127, -47, 
	-126, -48, -72, -48, -68, -47, -127, -48, 
	-69, -48, -72, -48, -67, -48, -80, -47, 
	-121, -48, -75, -48, -67, -48, -72, -47, 
	-113, 58, 10, 10, -48, 10, 32, 35, 
	124, 9, 13, -92, 10, -48, -47, 10, 
	-72, 10, -47, 10, -121, 10, -48, 10, 
	-80, 10, 10, 58, -48, 10, 32, 34, 
	35, 37, 42, 64, 124, 9, 13, -125, 
	10, -48, 10, -67, 10, -48, 10, -70, 
	10, -47, 10, -122, 10, -48, 10, -72, 
	10, -48, 10, -66, 10, -48, 10, -67, 
	10, -48, 10, -80, 10, -48, 10, -69, 
	10, -48, 32, -66, -48, -77, -48, -76, 
	-48, -80, -47, -126, -48, -66, -48, -68, 
	-47, -125, 32, -48, -74, -48, -75, -47, 
	-128, -125, -48, -75, -48, -76, -47, -117, 
	-47, -127, -47, -126, -48, -66, -47, -128, 
	-48, -72, -47, -113, 58, 10, 10, -48, 
	10, 32, 35, 37, 42, 64, 9, 13, 
	-112, -108, -107, -104, -102, -99, -97, -95, 
	-94, -92, 10, 10, 32, -48, 10, -80, 
	-66, 10, -48, 10, -67, 10, -48, 10, 
	-66, 10, -48, 10, -65, 10, -47, 10, 
	-125, 10, -47, 10, -127, 10, -47, 10, 
	-126, 10, -48, 10, -72, 10, -48, 10, 
	-68, 10, -47, 10, -127, 10, -48, 10, 
	-69, 10, -48, 10, -72, 10, -48, 10, 
	32, -66, 10, -48, 10, -77, 10, -48, 
	10, -76, 10, -48, 10, -80, 10, -47, 
	10, -126, 10, -48, 10, -66, 10, -48, 
	10, -68, 10, -47, 10, -125, 10, 10, 
	32, -48, 10, -74, 10, -48, 10, -75, 
	10, -47, 10, -125, 10, -47, 10, -127, 
	10, -47, 10, -126, 10, -47, 10, -116, 
	10, -47, 10, -126, -122, 10, -47, 10, 
	-128, 10, -47, 10, -125, 10, -48, 10, 
	-70, 10, -47, 10, -126, 10, -47, 10, 
	-125, 10, -47, 10, -128, 10, -48, 10, 
	-80, 10, 10, 32, -47, 10, -127, 10, 
	-47, 10, -122, 10, -48, 10, -75, 10, 
	-48, 10, -67, 10, -48, 10, -80, 10, 
	-47, 10, -128, 10, -48, 10, -72, 10, 
	-47, 10, -113, 10, 10, 58, -48, 10, 
	-75, 10, -48, 10, -67, 10, -48, 10, 
	-80, 10, -47, 10, -128, 10, -48, 10, 
	-72, 10, -48, 10, -71, 10, -48, 10, 
	-66, 10, -48, 10, 32, -48, -47, 10, 
	-72, 10, -47, 10, -121, 10, -48, 10, 
	-80, 10, -125, 10, -48, 10, -67, 10, 
	-48, 10, -70, 10, -47, 10, -122, 10, 
	-48, 10, -72, 10, -48, 10, -66, 10, 
	-48, 10, -67, 10, -48, 10, -80, 10, 
	-48, 10, -69, 10, 10, 95, 10, 70, 
	10, 69, 10, 65, 10, 84, 10, 85, 
	10, 82, 10, 69, 10, 95, 10, 69, 
	10, 78, 10, 68, 10, 95, 10, 37, 
	-47, -127, -47, -126, -47, -116, -47, -126, 
	-122, -47, -128, -47, -125, -48, -70, -47, 
	-126, -47, -125, -47, -128, -48, -80, 32, 
	-47, -127, -47, -122, -48, -75, -48, -67, 
	-48, -80, -47, -128, -48, -72, -47, -113, 
	58, 10, 10, -48, 10, 32, 35, 37, 
	42, 64, 9, 13, -112, -108, -107, -104, 
	-102, -99, -97, -95, -94, -92, 10, 10, 
	32, -48, 10, -80, -66, 10, -48, 10, 
	-67, 10, -48, 10, -66, 10, -48, 10, 
	-65, 10, -47, 10, -125, 10, -47, 10, 
	-127, 10, -47, 10, -126, 10, -48, 10, 
	-72, 10, -48, 10, -68, 10, -47, 10, 
	-127, 10, -48, 10, -69, 10, -48, 10, 
	-72, 10, -48, 10, 32, -66, 10, -48, 
	10, -77, 10, -48, 10, -76, 10, -48, 
	10, -80, 10, -47, 10, -126, 10, -48, 
	10, -66, 10, -48, 10, -68, 10, -47, 
	10, -125, 10, 10, 32, -48, 10, -74, 
	10, -48, 10, -75, 10, -47, 10, -125, 
	10, -47, 10, -127, 10, -47, 10, -126, 
	10, -47, 10, -116, 10, -47, 10, -122, 
	10, -48, 10, -75, 10, -48, 10, -67, 
	10, -48, 10, -80, 10, -47, 10, -128, 
	10, -48, 10, -72, 10, -48, 10, -71, 
	10, 10, 58, -48, 10, -66, 10, -48, 
	10, 32, -48, -47, 10, -72, 10, -47, 
	10, -121, 10, -48, 10, -80, 10, -125, 
	10, -48, 10, -67, 10, -48, 10, -70, 
	10, -47, 10, -122, 10, -48, 10, -72, 
	10, -48, 10, -66, 10, -48, 10, -67, 
	10, -48, 10, -80, 10, -48, 10, -69, 
	10, 10, 95, 10, 70, 10, 69, 10, 
	65, 10, 84, 10, 85, 10, 82, 10, 
	69, 10, 95, 10, 69, 10, 78, 10, 
	68, 10, 95, 10, 37, -48, -75, -48, 
	-67, -48, -80, -47, -128, -48, -72, -48, 
	-71, 58, 10, 10, -48, 10, 32, 35, 
	37, 42, 64, 9, 13, -112, -108, -107, 
	-104, -102, -99, -97, -95, -94, -92, 10, 
	10, 32, -48, 10, -80, -66, 10, -48, 
	10, -67, 10, -48, 10, -66, 10, -48, 
	10, -65, 10, -47, 10, -125, 10, -47, 
	10, -127, 10, -47, 10, -126, 10, -48, 
	10, -72, 10, -48, 10, -68, 10, -47, 
	10, -127, 10, -48, 10, -69, 10, -48, 
	10, -72, 10, -48, 10, 32, -66, 10, 
	-48, 10, -77, 10, -48, 10, -76, 10, 
	-48, 10, -80, 10, -47, 10, -126, 10, 
	-48, 10, -66, 10, -48, 10, -68, 10, 
	-47, 10, -125, 10, 10, 32, -48, 10, 
	-74, 10, -48, 10, -75, 10, -47, 10, 
	-128, -125, 10, -48, 10, -75, 10, -48, 
	10, -76, 10, -47, 10, -117, 10, -47, 
	10, -127, 10, -47, 10, -126, 10, -48, 
	10, -66, 10, -47, 10, -128, 10, -48, 
	10, -72, 10, -47, 10, -113, 10, 10, 
	58, -47, 10, -127, 10, -47, 10, -126, 
	10, -47, 10, -116, 10, -47, 10, -126, 
	-122, 10, -47, 10, -128, 10, -47, 10, 
	-125, 10, -48, 10, -70, 10, -47, 10, 
	-126, 10, -47, 10, -125, 10, -47, 10, 
	-128, 10, -48, 10, -80, 10, 10, 32, 
	-47, 10, -127, 10, -47, 10, -122, 10, 
	-48, 10, -75, 10, -48, 10, -67, 10, 
	-48, 10, -80, 10, -48, 10, -75, 10, 
	-48, 10, -67, 10, -48, 10, -80, 10, 
	-47, 10, -128, 10, -48, 10, -72, 10, 
	-48, 10, -71, 10, -48, 10, -66, 10, 
	-48, 10, 32, -48, -47, 10, -72, 10, 
	-47, 10, -121, 10, -48, 10, -80, 10, 
	-125, 10, -48, 10, -67, 10, -48, 10, 
	-70, 10, -47, 10, -122, 10, -48, 10, 
	-72, 10, -48, 10, -66, 10, -48, 10, 
	-67, 10, -48, 10, -80, 10, -48, 10, 
	-69, 10, 10, 95, 10, 70, 10, 69, 
	10, 65, 10, 84, 10, 85, 10, 82, 
	10, 69, 10, 95, 10, 69, 10, 78, 
	10, 68, 10, 95, 10, 37, -48, -66, 
	-48, 32, -48, -47, -72, -47, -121, -48, 
	-80, 58, 10, 10, -48, 10, 32, 35, 
	37, 64, 9, 13, -105, -97, -95, -92, 
	10, -48, 10, -67, 10, -48, 10, -80, 
	10, -47, 10, -121, 10, -48, 10, -75, 
	10, -48, 10, -67, 10, -48, 10, -72, 
	10, -47, 10, -113, 10, 10, 58, -47, 
	10, -128, 10, -48, 10, -75, 10, -48, 
	10, -76, 10, -47, 10, -117, 10, -47, 
	10, -127, 10, -47, 10, -126, 10, -48, 
	10, -66, 10, -47, 10, -128, 10, -47, 
	10, -126, -122, 10, -47, 10, -128, 10, 
	-47, 10, -125, 10, -48, 10, -70, 10, 
	-47, 10, -126, 10, -47, 10, -125, 10, 
	-47, 10, -128, 10, -48, 10, -80, 10, 
	10, 32, -47, 10, -127, 10, -47, 10, 
	-122, 10, -48, 10, -75, 10, -48, 10, 
	-67, 10, -48, 10, -80, 10, -48, 10, 
	-75, 10, -48, 10, -67, 10, -48, 10, 
	-80, 10, -47, 10, -128, 10, -48, 10, 
	-72, 10, -48, 10, -71, 10, -48, -47, 
	10, -72, 10, -47, 10, -121, 10, -48, 
	10, -80, 10, -125, 10, -48, 10, -67, 
	10, -48, 10, -70, 10, -47, 10, -122, 
	10, -48, 10, -72, 10, -48, 10, -66, 
	10, -48, 10, -67, 10, -48, 10, -80, 
	10, -48, 10, -69, 10, 10, 95, 10, 
	70, 10, 69, 10, 65, 10, 84, 10, 
	85, 10, 82, 10, 69, 10, 95, 10, 
	69, 10, 78, 10, 68, 10, 95, 10, 
	37, -125, -48, -67, -48, -70, -47, -122, 
	-48, -72, -48, -66, -48, -67, -48, -80, 
	-48, -69, -69, -65, 0
};

static const char _lexer_single_lengths[] = {
	0, 10, 11, 1, 1, 2, 9, 1, 
	1, 2, 3, 3, 3, 3, 2, 2, 
	2, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	3, 5, 3, 2, 4, 3, 2, 4, 
	9, 1, 2, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 5, 2, 3, 2, 2, 2, 
	2, 2, 2, 9, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 2, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 7, 11, 2, 2, 3, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 3, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 3, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 3, 3, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 1, 
	1, 1, 1, 1, 1, 1, 2, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 7, 11, 2, 2, 3, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 3, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 3, 3, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 7, 
	11, 2, 2, 3, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 3, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	3, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 3, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 3, 3, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 1, 1, 2, 2, 1, 1, 1, 
	1, 1, 1, 1, 1, 6, 5, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 3, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 3, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 0
};

static const char _lexer_range_lengths[] = {
	0, 1, 0, 0, 0, 0, 1, 0, 
	0, 1, 1, 1, 1, 1, 1, 1, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	1, 1, 1, 1, 1, 0, 0, 1, 
	1, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 1, 0, 0, 0, 0, 0, 
	0, 0, 0, 1, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 1, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 1, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 1, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 1, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0
};

static const short _lexer_index_offsets[] = {
	0, 0, 12, 24, 26, 28, 31, 42, 
	44, 46, 50, 55, 60, 65, 70, 74, 
	78, 81, 83, 85, 87, 89, 91, 93, 
	95, 97, 99, 101, 103, 105, 107, 109, 
	111, 116, 123, 128, 132, 138, 142, 145, 
	151, 162, 164, 167, 169, 171, 173, 175, 
	177, 179, 181, 183, 185, 187, 189, 191, 
	193, 195, 197, 199, 201, 203, 205, 207, 
	209, 211, 213, 215, 217, 219, 221, 223, 
	225, 227, 229, 231, 233, 235, 237, 239, 
	241, 243, 245, 252, 255, 259, 262, 265, 
	268, 271, 274, 277, 288, 291, 294, 297, 
	300, 303, 306, 309, 312, 315, 318, 321, 
	324, 327, 330, 333, 336, 339, 342, 344, 
	346, 348, 350, 352, 354, 356, 358, 360, 
	362, 364, 366, 368, 370, 372, 374, 376, 
	378, 380, 382, 384, 387, 389, 391, 393, 
	395, 397, 399, 401, 403, 405, 407, 409, 
	411, 413, 415, 417, 419, 421, 423, 425, 
	427, 429, 438, 450, 453, 456, 460, 463, 
	466, 469, 472, 475, 478, 481, 484, 487, 
	490, 493, 496, 499, 502, 505, 508, 511, 
	514, 517, 520, 523, 526, 530, 533, 536, 
	539, 542, 545, 548, 551, 554, 557, 560, 
	563, 566, 569, 572, 575, 578, 581, 584, 
	587, 590, 593, 596, 599, 602, 605, 608, 
	611, 614, 617, 621, 624, 627, 630, 633, 
	636, 639, 642, 645, 648, 651, 654, 657, 
	660, 663, 666, 669, 672, 675, 678, 681, 
	684, 687, 690, 693, 696, 699, 702, 705, 
	708, 711, 714, 717, 720, 723, 726, 729, 
	732, 735, 738, 741, 744, 747, 750, 753, 
	756, 759, 763, 767, 770, 773, 776, 779, 
	782, 785, 788, 791, 794, 797, 800, 803, 
	806, 809, 812, 815, 818, 821, 824, 827, 
	830, 833, 836, 839, 842, 845, 848, 851, 
	854, 857, 860, 863, 866, 869, 872, 875, 
	877, 879, 881, 883, 885, 887, 889, 892, 
	894, 896, 898, 900, 902, 904, 906, 908, 
	910, 912, 914, 916, 918, 920, 922, 924, 
	926, 928, 930, 932, 934, 936, 938, 940, 
	942, 944, 946, 948, 950, 952, 954, 956, 
	958, 960, 969, 981, 984, 987, 991, 994, 
	997, 1000, 1003, 1006, 1009, 1012, 1015, 1018, 
	1021, 1024, 1027, 1030, 1033, 1036, 1039, 1042, 
	1045, 1048, 1051, 1054, 1057, 1061, 1064, 1067, 
	1070, 1073, 1076, 1079, 1082, 1085, 1088, 1091, 
	1094, 1097, 1100, 1103, 1106, 1109, 1112, 1115, 
	1118, 1121, 1124, 1127, 1130, 1133, 1136, 1139, 
	1142, 1145, 1148, 1151, 1154, 1157, 1160, 1163, 
	1166, 1169, 1172, 1175, 1178, 1181, 1184, 1187, 
	1190, 1193, 1196, 1200, 1204, 1207, 1210, 1213, 
	1216, 1219, 1222, 1225, 1228, 1231, 1234, 1237, 
	1240, 1243, 1246, 1249, 1252, 1255, 1258, 1261, 
	1264, 1267, 1270, 1273, 1276, 1279, 1282, 1285, 
	1288, 1291, 1294, 1297, 1300, 1303, 1306, 1309, 
	1312, 1314, 1316, 1318, 1320, 1322, 1324, 1326, 
	1328, 1330, 1332, 1334, 1336, 1338, 1340, 1342, 
	1351, 1363, 1366, 1369, 1373, 1376, 1379, 1382, 
	1385, 1388, 1391, 1394, 1397, 1400, 1403, 1406, 
	1409, 1412, 1415, 1418, 1421, 1424, 1427, 1430, 
	1433, 1436, 1439, 1443, 1446, 1449, 1452, 1455, 
	1458, 1461, 1464, 1467, 1470, 1473, 1476, 1479, 
	1482, 1485, 1488, 1491, 1494, 1497, 1500, 1503, 
	1506, 1510, 1513, 1516, 1519, 1522, 1525, 1528, 
	1531, 1534, 1537, 1540, 1543, 1546, 1549, 1552, 
	1555, 1558, 1561, 1564, 1567, 1570, 1573, 1576, 
	1579, 1582, 1585, 1588, 1592, 1595, 1598, 1601, 
	1604, 1607, 1610, 1613, 1616, 1619, 1622, 1625, 
	1628, 1631, 1634, 1637, 1640, 1643, 1646, 1649, 
	1652, 1655, 1658, 1661, 1664, 1667, 1670, 1673, 
	1676, 1679, 1682, 1685, 1688, 1691, 1694, 1697, 
	1700, 1703, 1706, 1709, 1713, 1717, 1720, 1723, 
	1726, 1729, 1732, 1735, 1738, 1741, 1744, 1747, 
	1750, 1753, 1756, 1759, 1762, 1765, 1768, 1771, 
	1774, 1777, 1780, 1783, 1786, 1789, 1792, 1795, 
	1798, 1801, 1804, 1807, 1810, 1813, 1816, 1819, 
	1822, 1825, 1827, 1829, 1832, 1835, 1837, 1839, 
	1841, 1843, 1845, 1847, 1849, 1851, 1859, 1865, 
	1868, 1871, 1874, 1877, 1880, 1883, 1886, 1889, 
	1892, 1895, 1898, 1901, 1904, 1907, 1910, 1913, 
	1916, 1919, 1922, 1925, 1928, 1931, 1934, 1937, 
	1940, 1943, 1946, 1949, 1952, 1955, 1958, 1961, 
	1965, 1968, 1971, 1974, 1977, 1980, 1983, 1986, 
	1989, 1992, 1995, 1998, 2001, 2004, 2007, 2010, 
	2013, 2016, 2019, 2022, 2025, 2028, 2031, 2034, 
	2037, 2040, 2043, 2046, 2049, 2052, 2055, 2058, 
	2061, 2064, 2067, 2070, 2073, 2076, 2080, 2083, 
	2086, 2089, 2092, 2095, 2098, 2101, 2104, 2107, 
	2110, 2113, 2116, 2119, 2122, 2125, 2128, 2131, 
	2134, 2137, 2140, 2143, 2146, 2149, 2152, 2155, 
	2158, 2161, 2164, 2167, 2170, 2173, 2176, 2179, 
	2182, 2185, 2188, 2190, 2192, 2194, 2196, 2198, 
	2200, 2202, 2204, 2206, 2208, 2210, 2212, 2214, 
	2216, 2218, 2220, 2222, 2224, 2226
};

static const short _lexer_trans_targs[] = {
	2, 755, 6, 6, 7, 16, 18, 3, 
	32, 35, 6, 0, 3, 41, 59, 65, 
	3, 109, 45, 130, 301, 617, 620, 0, 
	4, 0, 0, 5, 6, 17, 5, 2, 
	6, 6, 7, 16, 18, 3, 32, 35, 
	6, 0, 8, 0, 9, 0, 10, 9, 
	9, 0, 11, 11, 12, 11, 11, 11, 
	11, 12, 11, 11, 11, 11, 13, 11, 
	11, 11, 11, 14, 11, 11, 6, 15, 
	15, 0, 6, 15, 15, 0, 6, 17, 
	16, 6, 0, 19, 0, 20, 0, 21, 
	0, 22, 0, 23, 0, 24, 0, 25, 
	0, 26, 0, 27, 0, 28, 0, 29, 
	0, 30, 0, 31, 0, 757, 0, 0, 
	0, 0, 0, 33, 34, 6, 34, 34, 
	32, 33, 33, 6, 34, 32, 34, 0, 
	35, 36, 35, 0, 40, 39, 38, 36, 
	39, 37, 0, 38, 36, 37, 0, 38, 
	37, 40, 39, 38, 36, 39, 37, 2, 
	40, 40, 7, 16, 18, 3, 32, 35, 
	40, 0, 42, 0, 43, 47, 0, 44, 
	0, 45, 0, 46, 0, 3, 0, 48, 
	0, 49, 0, 50, 0, 51, 0, 52, 
	0, 53, 0, 54, 0, 55, 0, 56, 
	0, 57, 0, 58, 0, 3, 0, 60, 
	0, 61, 0, 62, 0, 63, 0, 64, 
	0, 3, 0, 66, 0, 67, 0, 68, 
	0, 69, 0, 70, 0, 71, 0, 72, 
	0, 73, 0, 74, 0, 75, 0, 76, 
	0, 77, 0, 78, 0, 79, 0, 80, 
	0, 82, 81, 82, 81, 83, 82, 82, 
	6, 6, 82, 81, 84, 82, 81, 85, 
	92, 82, 81, 86, 82, 81, 87, 82, 
	81, 88, 82, 81, 89, 82, 81, 90, 
	82, 81, 82, 91, 81, 2, 6, 6, 
	7, 16, 18, 3, 32, 35, 6, 0, 
	93, 82, 81, 94, 82, 81, 95, 82, 
	81, 96, 82, 81, 97, 82, 81, 98, 
	82, 81, 99, 82, 81, 100, 82, 81, 
	101, 82, 81, 102, 82, 81, 103, 82, 
	81, 104, 82, 81, 105, 82, 81, 106, 
	82, 81, 107, 82, 81, 108, 82, 81, 
	90, 82, 81, 110, 117, 0, 111, 0, 
	112, 0, 113, 0, 114, 0, 115, 0, 
	116, 0, 3, 0, 118, 0, 119, 0, 
	120, 0, 121, 0, 122, 0, 123, 0, 
	124, 0, 125, 0, 126, 0, 127, 0, 
	128, 0, 129, 0, 3, 0, 131, 0, 
	132, 295, 0, 133, 0, 134, 0, 135, 
	0, 136, 0, 137, 0, 138, 0, 139, 
	0, 140, 0, 141, 0, 142, 0, 143, 
	0, 144, 0, 145, 0, 146, 0, 147, 
	0, 148, 0, 149, 0, 150, 0, 151, 
	0, 153, 152, 153, 152, 154, 153, 153, 
	6, 281, 155, 6, 153, 152, 155, 156, 
	174, 155, 180, 160, 201, 209, 255, 258, 
	153, 152, 153, 91, 152, 157, 153, 152, 
	158, 162, 153, 152, 159, 153, 152, 160, 
	153, 152, 161, 153, 152, 155, 153, 152, 
	163, 153, 152, 164, 153, 152, 165, 153, 
	152, 166, 153, 152, 167, 153, 152, 168, 
	153, 152, 169, 153, 152, 170, 153, 152, 
	171, 153, 152, 172, 153, 152, 173, 153, 
	152, 155, 153, 152, 175, 153, 152, 176, 
	153, 152, 177, 153, 152, 178, 153, 152, 
	179, 153, 152, 155, 153, 152, 181, 153, 
	188, 152, 182, 153, 152, 183, 153, 152, 
	184, 153, 152, 185, 153, 152, 186, 153, 
	152, 187, 153, 152, 155, 153, 152, 189, 
	153, 152, 190, 153, 152, 191, 153, 152, 
	192, 153, 152, 193, 153, 152, 194, 153, 
	152, 195, 153, 152, 196, 153, 152, 153, 
	197, 152, 198, 153, 152, 199, 153, 152, 
	200, 153, 152, 155, 153, 152, 202, 153, 
	152, 203, 153, 152, 204, 153, 152, 205, 
	153, 152, 206, 153, 152, 207, 153, 152, 
	208, 153, 152, 155, 153, 152, 210, 153, 
	152, 211, 243, 153, 152, 212, 153, 152, 
	213, 153, 152, 214, 153, 152, 215, 153, 
	152, 216, 153, 152, 217, 153, 152, 218, 
	153, 152, 219, 153, 152, 220, 153, 152, 
	221, 153, 152, 222, 153, 152, 223, 153, 
	152, 224, 153, 152, 225, 153, 152, 153, 
	226, 152, 227, 153, 152, 228, 153, 152, 
	229, 153, 152, 230, 153, 152, 231, 153, 
	152, 232, 153, 152, 233, 153, 152, 234, 
	153, 152, 235, 153, 152, 236, 153, 152, 
	237, 153, 152, 238, 153, 152, 239, 153, 
	152, 240, 153, 152, 241, 153, 152, 242, 
	153, 152, 153, 91, 152, 244, 153, 152, 
	245, 153, 152, 246, 153, 152, 247, 153, 
	152, 248, 153, 152, 249, 153, 152, 250, 
	153, 152, 251, 153, 152, 252, 153, 152, 
	253, 153, 152, 254, 153, 152, 242, 153, 
	152, 256, 153, 152, 257, 153, 152, 183, 
	153, 91, 152, 259, 264, 153, 152, 260, 
	153, 152, 261, 153, 152, 262, 153, 152, 
	263, 153, 152, 242, 153, 152, 265, 153, 
	152, 266, 153, 152, 267, 153, 152, 268, 
	153, 152, 269, 153, 152, 270, 153, 152, 
	271, 153, 152, 272, 153, 152, 273, 153, 
	152, 274, 153, 152, 275, 153, 152, 276, 
	153, 152, 277, 153, 152, 278, 153, 152, 
	279, 153, 152, 280, 153, 152, 242, 153, 
	152, 153, 282, 152, 153, 283, 152, 153, 
	284, 152, 153, 285, 152, 153, 286, 152, 
	153, 287, 152, 153, 288, 152, 153, 289, 
	152, 153, 290, 152, 153, 291, 152, 153, 
	292, 152, 153, 293, 152, 153, 294, 152, 
	153, 6, 152, 296, 0, 297, 0, 298, 
	0, 299, 0, 300, 0, 3, 0, 302, 
	0, 303, 448, 0, 304, 0, 305, 0, 
	306, 0, 307, 0, 308, 0, 309, 0, 
	310, 0, 311, 0, 312, 0, 313, 0, 
	314, 0, 315, 0, 316, 0, 317, 0, 
	318, 0, 319, 0, 320, 0, 321, 0, 
	322, 0, 323, 0, 324, 0, 325, 0, 
	326, 0, 327, 0, 328, 0, 329, 0, 
	330, 0, 331, 0, 332, 0, 333, 0, 
	334, 0, 335, 0, 337, 336, 337, 336, 
	338, 337, 337, 6, 434, 339, 6, 337, 
	336, 339, 340, 358, 339, 364, 344, 385, 
	393, 408, 411, 337, 336, 337, 91, 336, 
	341, 337, 336, 342, 346, 337, 336, 343, 
	337, 336, 344, 337, 336, 345, 337, 336, 
	339, 337, 336, 347, 337, 336, 348, 337, 
	336, 349, 337, 336, 350, 337, 336, 351, 
	337, 336, 352, 337, 336, 353, 337, 336, 
	354, 337, 336, 355, 337, 336, 356, 337, 
	336, 357, 337, 336, 339, 337, 336, 359, 
	337, 336, 360, 337, 336, 361, 337, 336, 
	362, 337, 336, 363, 337, 336, 339, 337, 
	336, 365, 337, 372, 336, 366, 337, 336, 
	367, 337, 336, 368, 337, 336, 369, 337, 
	336, 370, 337, 336, 371, 337, 336, 339, 
	337, 336, 373, 337, 336, 374, 337, 336, 
	375, 337, 336, 376, 337, 336, 377, 337, 
	336, 378, 337, 336, 379, 337, 336, 380, 
	337, 336, 337, 381, 336, 382, 337, 336, 
	383, 337, 336, 384, 337, 336, 339, 337, 
	336, 386, 337, 336, 387, 337, 336, 388, 
	337, 336, 389, 337, 336, 390, 337, 336, 
	391, 337, 336, 392, 337, 336, 339, 337, 
	336, 394, 337, 336, 395, 337, 336, 396, 
	337, 336, 397, 337, 336, 398, 337, 336, 
	399, 337, 336, 400, 337, 336, 401, 337, 
	336, 402, 337, 336, 403, 337, 336, 404, 
	337, 336, 405, 337, 336, 406, 337, 336, 
	407, 337, 336, 337, 91, 336, 409, 337, 
	336, 410, 337, 336, 367, 337, 91, 336, 
	412, 417, 337, 336, 413, 337, 336, 414, 
	337, 336, 415, 337, 336, 416, 337, 336, 
	407, 337, 336, 418, 337, 336, 419, 337, 
	336, 420, 337, 336, 421, 337, 336, 422, 
	337, 336, 423, 337, 336, 424, 337, 336, 
	425, 337, 336, 426, 337, 336, 427, 337, 
	336, 428, 337, 336, 429, 337, 336, 430, 
	337, 336, 431, 337, 336, 432, 337, 336, 
	433, 337, 336, 407, 337, 336, 337, 435, 
	336, 337, 436, 336, 337, 437, 336, 337, 
	438, 336, 337, 439, 336, 337, 440, 336, 
	337, 441, 336, 337, 442, 336, 337, 443, 
	336, 337, 444, 336, 337, 445, 336, 337, 
	446, 336, 337, 447, 336, 337, 6, 336, 
	449, 0, 450, 0, 451, 0, 452, 0, 
	453, 0, 454, 0, 455, 0, 456, 0, 
	457, 0, 458, 0, 459, 0, 460, 0, 
	461, 0, 463, 462, 463, 462, 464, 463, 
	463, 6, 603, 465, 6, 463, 462, 465, 
	466, 484, 465, 490, 470, 511, 538, 577, 
	580, 463, 462, 463, 91, 462, 467, 463, 
	462, 468, 472, 463, 462, 469, 463, 462, 
	470, 463, 462, 471, 463, 462, 465, 463, 
	462, 473, 463, 462, 474, 463, 462, 475, 
	463, 462, 476, 463, 462, 477, 463, 462, 
	478, 463, 462, 479, 463, 462, 480, 463, 
	462, 481, 463, 462, 482, 463, 462, 483, 
	463, 462, 465, 463, 462, 485, 463, 462, 
	486, 463, 462, 487, 463, 462, 488, 463, 
	462, 489, 463, 462, 465, 463, 462, 491, 
	463, 498, 462, 492, 463, 462, 493, 463, 
	462, 494, 463, 462, 495, 463, 462, 496, 
	463, 462, 497, 463, 462, 465, 463, 462, 
	499, 463, 462, 500, 463, 462, 501, 463, 
	462, 502, 463, 462, 503, 463, 462, 504, 
	463, 462, 505, 463, 462, 506, 463, 462, 
	463, 507, 462, 508, 463, 462, 509, 463, 
	462, 510, 463, 462, 465, 463, 462, 512, 
	463, 462, 513, 532, 463, 462, 514, 463, 
	462, 515, 463, 462, 516, 463, 462, 517, 
	463, 462, 518, 463, 462, 519, 463, 462, 
	520, 463, 462, 521, 463, 462, 522, 463, 
	462, 523, 463, 462, 524, 463, 462, 525, 
	463, 462, 526, 463, 462, 527, 463, 462, 
	528, 463, 462, 529, 463, 462, 530, 463, 
	462, 531, 463, 462, 463, 91, 462, 533, 
	463, 462, 534, 463, 462, 535, 463, 462, 
	536, 463, 462, 537, 463, 462, 465, 463, 
	462, 539, 463, 462, 540, 565, 463, 462, 
	541, 463, 462, 542, 463, 462, 543, 463, 
	462, 544, 463, 462, 545, 463, 462, 546, 
	463, 462, 547, 463, 462, 548, 463, 462, 
	549, 463, 462, 550, 463, 462, 551, 463, 
	462, 552, 463, 462, 553, 463, 462, 554, 
	463, 462, 463, 555, 462, 556, 463, 462, 
	557, 463, 462, 558, 463, 462, 559, 463, 
	462, 560, 463, 462, 561, 463, 462, 562, 
	463, 462, 563, 463, 462, 564, 463, 462, 
	525, 463, 462, 566, 463, 462, 567, 463, 
	462, 568, 463, 462, 569, 463, 462, 570, 
	463, 462, 571, 463, 462, 572, 463, 462, 
	573, 463, 462, 574, 463, 462, 575, 463, 
	462, 576, 463, 462, 531, 463, 462, 578, 
	463, 462, 579, 463, 462, 493, 463, 91, 
	462, 581, 586, 463, 462, 582, 463, 462, 
	583, 463, 462, 584, 463, 462, 585, 463, 
	462, 531, 463, 462, 587, 463, 462, 588, 
	463, 462, 589, 463, 462, 590, 463, 462, 
	591, 463, 462, 592, 463, 462, 593, 463, 
	462, 594, 463, 462, 595, 463, 462, 596, 
	463, 462, 597, 463, 462, 598, 463, 462, 
	599, 463, 462, 600, 463, 462, 601, 463, 
	462, 602, 463, 462, 531, 463, 462, 463, 
	604, 462, 463, 605, 462, 463, 606, 462, 
	463, 607, 462, 463, 608, 462, 463, 609, 
	462, 463, 610, 462, 463, 611, 462, 463, 
	612, 462, 463, 613, 462, 463, 614, 462, 
	463, 615, 462, 463, 616, 462, 463, 6, 
	462, 618, 0, 619, 0, 112, 4, 0, 
	621, 738, 0, 622, 0, 623, 0, 624, 
	0, 625, 0, 626, 0, 627, 0, 629, 
	628, 629, 628, 630, 629, 629, 6, 724, 
	6, 629, 628, 631, 646, 662, 701, 629, 
	628, 632, 629, 628, 633, 629, 628, 634, 
	629, 628, 635, 629, 628, 636, 629, 628, 
	637, 629, 628, 638, 629, 628, 639, 629, 
	628, 640, 629, 628, 641, 629, 628, 642, 
	629, 628, 643, 629, 628, 644, 629, 628, 
	645, 629, 628, 629, 91, 628, 647, 629, 
	628, 648, 629, 628, 649, 629, 628, 650, 
	629, 628, 651, 629, 628, 652, 629, 628, 
	653, 629, 628, 654, 629, 628, 655, 629, 
	628, 656, 629, 628, 657, 629, 628, 658, 
	629, 628, 659, 629, 628, 660, 629, 628, 
	661, 629, 628, 641, 629, 628, 663, 629, 
	628, 664, 689, 629, 628, 665, 629, 628, 
	666, 629, 628, 667, 629, 628, 668, 629, 
	628, 669, 629, 628, 670, 629, 628, 671, 
	629, 628, 672, 629, 628, 673, 629, 628, 
	674, 629, 628, 675, 629, 628, 676, 629, 
	628, 677, 629, 628, 678, 629, 628, 629, 
	679, 628, 680, 629, 628, 681, 629, 628, 
	682, 629, 628, 683, 629, 628, 684, 629, 
	628, 685, 629, 628, 686, 629, 628, 687, 
	629, 628, 688, 629, 628, 660, 629, 628, 
	690, 629, 628, 691, 629, 628, 692, 629, 
	628, 693, 629, 628, 694, 629, 628, 695, 
	629, 628, 696, 629, 628, 697, 629, 628, 
	698, 629, 628, 699, 629, 628, 700, 629, 
	628, 645, 629, 628, 702, 707, 629, 628, 
	703, 629, 628, 704, 629, 628, 705, 629, 
	628, 706, 629, 628, 645, 629, 628, 708, 
	629, 628, 709, 629, 628, 710, 629, 628, 
	711, 629, 628, 712, 629, 628, 713, 629, 
	628, 714, 629, 628, 715, 629, 628, 716, 
	629, 628, 717, 629, 628, 718, 629, 628, 
	719, 629, 628, 720, 629, 628, 721, 629, 
	628, 722, 629, 628, 723, 629, 628, 645, 
	629, 628, 629, 725, 628, 629, 726, 628, 
	629, 727, 628, 629, 728, 628, 629, 729, 
	628, 629, 730, 628, 629, 731, 628, 629, 
	732, 628, 629, 733, 628, 629, 734, 628, 
	629, 735, 628, 629, 736, 628, 629, 737, 
	628, 629, 6, 628, 739, 0, 740, 0, 
	741, 0, 742, 0, 743, 0, 744, 0, 
	745, 0, 746, 0, 747, 0, 748, 0, 
	749, 0, 750, 0, 751, 0, 752, 0, 
	753, 0, 754, 0, 626, 0, 756, 0, 
	6, 0, 0, 0
};

static const char _lexer_trans_actions[] = {
	25, 0, 47, 0, 5, 1, 0, 25, 
	1, 31, 0, 39, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 39, 
	0, 39, 39, 50, 99, 19, 0, 25, 
	47, 0, 5, 1, 0, 25, 1, 31, 
	0, 39, 0, 39, 0, 39, 47, 0, 
	0, 39, 119, 41, 41, 41, 3, 111, 
	29, 29, 29, 0, 111, 29, 29, 29, 
	0, 111, 29, 0, 29, 0, 95, 7, 
	7, 39, 47, 0, 0, 39, 103, 21, 
	0, 47, 39, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 39, 0, 39, 39, 
	39, 39, 39, 0, 23, 107, 23, 23, 
	44, 23, 0, 47, 0, 1, 0, 39, 
	0, 0, 0, 39, 47, 33, 33, 80, 
	33, 33, 39, 0, 35, 0, 39, 0, 
	0, 47, 0, 0, 35, 0, 0, 89, 
	47, 0, 86, 83, 37, 89, 83, 92, 
	0, 39, 0, 39, 0, 0, 39, 0, 
	39, 0, 39, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 39, 0, 39, 0, 
	39, 124, 50, 47, 0, 77, 47, 0, 
	74, 74, 0, 0, 0, 47, 0, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 47, 17, 0, 56, 115, 27, 
	53, 50, 27, 56, 50, 59, 27, 39, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 0, 39, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 39, 0, 39, 0, 
	39, 124, 50, 47, 0, 77, 47, 0, 
	65, 29, 77, 65, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	47, 0, 47, 11, 0, 0, 47, 0, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 47, 
	0, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 47, 
	0, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 47, 11, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 11, 0, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 11, 0, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 39, 0, 39, 0, 
	39, 0, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 124, 50, 47, 0, 
	77, 47, 0, 71, 29, 77, 71, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 47, 0, 47, 15, 0, 
	0, 47, 0, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 47, 0, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 47, 15, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 15, 0, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 15, 0, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 124, 50, 47, 0, 77, 47, 
	0, 68, 29, 77, 68, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 47, 0, 47, 13, 0, 0, 47, 
	0, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	47, 0, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 47, 13, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 47, 0, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 13, 
	0, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 13, 
	0, 0, 39, 0, 39, 0, 0, 39, 
	0, 0, 39, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 39, 0, 39, 124, 
	50, 47, 0, 77, 47, 0, 62, 29, 
	62, 0, 0, 0, 0, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 47, 9, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 47, 
	0, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 9, 0, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 0
};

static const char _lexer_eof_actions[] = {
	0, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39
};

static const int lexer_start = 1;
static const int lexer_first_final = 757;
static const int lexer_error = 0;

static const int lexer_en_main = 1;


#line 243 "/Users/aslakhellesoy/scm/gherkin/tasks/../ragel/i18n/ru.c.rl"

static VALUE 
strip_i(VALUE str, VALUE ary)
{
  rb_funcall(str, rb_intern("strip!"), 0);
  rb_ary_push(ary, str);
  
  return Qnil;
}

static VALUE 
multiline_strip(VALUE text)
{
  VALUE map = rb_ary_new();
  VALUE split = rb_str_split(text, "\n");
  
  rb_iterate(rb_each, split, strip_i, map);
  
  return split;
}

static void 
store_kw_con(VALUE listener, const char * event_name, 
             const char * keyword_at, size_t keyword_length, 
             const char * at,         size_t length, 
             int current_line)
{
  VALUE con = Qnil, kw = Qnil;
  kw = ENCODED_STR_NEW(keyword_at, keyword_length);
  con = ENCODED_STR_NEW(at, length);
  rb_funcall(con, rb_intern("strip!"), 0);
  rb_funcall(listener, rb_intern(event_name), 3, kw, con, INT2FIX(current_line)); 
}

static void
store_multiline_kw_con(VALUE listener, const char * event_name,
                      const char * keyword_at, size_t keyword_length,
                      const char * at,         size_t length,
                      int current_line, int eol)
{
  VALUE con = Qnil, kw = Qnil, name = Qnil, desc = Qnil;

  kw = ENCODED_STR_NEW(keyword_at, keyword_length);
  con = ENCODED_STR_NEW(at, length);

  VALUE split = multiline_strip(con);
  
  name = rb_funcall(split, rb_intern("shift"), 0);
  desc = rb_ary_join(split, rb_str_new2( \
          eol == CRLF_FLAG ? CRLF : LF ));

  if( name == Qnil ) 
  {
    name = rb_str_new2("");
  }
  if( rb_funcall(desc, rb_intern("size"), 0) == 0) 
  {
    desc = rb_str_new2("");
  }
  rb_funcall(name, rb_intern("strip!"), 0);
  rb_funcall(desc, rb_intern("strip!"), 0);
  rb_funcall(listener, rb_intern(event_name), 4, kw, name, desc, INT2FIX(current_line)); 
}

static void 
store_attr(VALUE listener, const char * attr_type,
           const char * at, size_t length, 
           int line)
{
  VALUE val = ENCODED_STR_NEW(at, length);
  rb_funcall(listener, rb_intern(attr_type), 2, val, INT2FIX(line));
}

static void 
store_pystring_content(VALUE listener, 
          int start_col, 
          const char *at, size_t length, 
          int current_line)
{
  VALUE con = ENCODED_STR_NEW(at, length);
  // Gherkin will crash gracefully if the string representation of start_col pushes the pattern past 32 characters
  char pat[32]; 
  snprintf(pat, 32, "^[\t ]{0,%d}", start_col); 
  VALUE re = rb_reg_regcomp(rb_str_new2(pat));
  VALUE re2 = rb_reg_regcomp(rb_str_new2("\r\\Z"));
  VALUE unescape_escaped_quotes = rb_reg_regcomp(rb_str_new2("\\\\\"\\\\\"\\\\\""));
  rb_funcall(con, rb_intern("gsub!"), 2, re, rb_str_new2(""));
  rb_funcall(con, rb_intern("sub!"), 2, re2, rb_str_new2(""));
  rb_funcall(con, rb_intern("gsub!"), 2, unescape_escaped_quotes, rb_str_new2("\"\"\""));
  rb_funcall(listener, rb_intern("py_string"), 2, con, INT2FIX(current_line));
}

static void 
raise_lexer_error(const char * at, int line)
{ 
  rb_raise(rb_eGherkinLexingError, "Lexing error on line %d: '%s'. See http://wiki.github.com/aslakhellesoy/gherkin/lexingerror for more information.", line, at);
}

static int 
count_char(char char_to_count, char *str) {

  int count = 0;
  int i = 0;
  while(str[i] != '\0') {
    if(str[i] == char_to_count) {
      count++;
    }
    i++;
  }
  return count;
}

static void lexer_init(lexer_state *lexer) {
  lexer->content_start = 0;
  lexer->content_end = 0;
  lexer->content_len = 0;
  lexer->mark = 0;
  lexer->keyword_start = 0;
  lexer->keyword_end = 0;
  lexer->next_keyword_start = 0;
  lexer->line_number = 1;
  lexer->last_newline = 0;
  lexer->final_newline = 0;
  lexer->start_col = 0;
  lexer->eol = LF_FLAG;
}

static VALUE CLexer_alloc(VALUE klass)
{
  VALUE obj;
  lexer_state *lxr = ALLOC(lexer_state);
  lexer_init(lxr);

  obj = Data_Wrap_Struct(klass, NULL, -1, lxr);

  return obj;
}

static VALUE CLexer_init(VALUE self, VALUE listener)
{
  rb_iv_set(self, "@listener", listener);
  
  lexer_state *lxr = NULL;
  DATA_GET(self, lexer_state, lxr);
  lexer_init(lxr);
  
  return self;
}

static VALUE CLexer_scan(VALUE self, VALUE input, VALUE uri, VALUE offset)
{
  VALUE listener = rb_iv_get(self, "@listener");
  rb_funcall(listener, rb_intern("location"), 2, uri, offset);

  lexer_state *lexer = NULL;
  DATA_GET(self, lexer_state, lexer);

  VALUE input_copy = rb_str_dup(input);

  rb_str_append(input_copy, rb_str_new2("\n%_FEATURE_END_%"));
  char *data = RSTRING_PTR(input_copy);
  size_t len = RSTRING_LEN(input_copy);
  
  if (count_char('\r', data) > (count_char('\n', data) / 2)) {
    lexer->eol = CRLF_FLAG;
  }
  
  if (len == 0) { 
    rb_raise(rb_eGherkinLexingError, "No content to lex.");
  } else {

    const char *p, *pe, *eof;
    int cs = 0;
    
    VALUE current_row = Qnil;

    p = data;
    pe = data + len;
    eof = pe;
    
    assert(*pe == '\0' && "pointer does not end on NULL");
    
    
#line 1548 "ext/gherkin_lexer_ru/gherkin_lexer_ru.c"
	{
	cs = lexer_start;
	}

#line 426 "/Users/aslakhellesoy/scm/gherkin/tasks/../ragel/i18n/ru.c.rl"
    
#line 1555 "ext/gherkin_lexer_ru/gherkin_lexer_ru.c"
	{
	int _klen;
	unsigned int _trans;
	const char *_acts;
	unsigned int _nacts;
	const char *_keys;

	if ( p == pe )
		goto _test_eof;
	if ( cs == 0 )
		goto _out;
_resume:
	_keys = _lexer_trans_keys + _lexer_key_offsets[cs];
	_trans = _lexer_index_offsets[cs];

	_klen = _lexer_single_lengths[cs];
	if ( _klen > 0 ) {
		const char *_lower = _keys;
		const char *_mid;
		const char *_upper = _keys + _klen - 1;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + ((_upper-_lower) >> 1);
			if ( (*p) < *_mid )
				_upper = _mid - 1;
			else if ( (*p) > *_mid )
				_lower = _mid + 1;
			else {
				_trans += (_mid - _keys);
				goto _match;
			}
		}
		_keys += _klen;
		_trans += _klen;
	}

	_klen = _lexer_range_lengths[cs];
	if ( _klen > 0 ) {
		const char *_lower = _keys;
		const char *_mid;
		const char *_upper = _keys + (_klen<<1) - 2;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + (((_upper-_lower) >> 1) & ~1);
			if ( (*p) < _mid[0] )
				_upper = _mid - 2;
			else if ( (*p) > _mid[1] )
				_lower = _mid + 2;
			else {
				_trans += ((_mid - _keys)>>1);
				goto _match;
			}
		}
		_trans += _klen;
	}

_match:
	cs = _lexer_trans_targs[_trans];

	if ( _lexer_trans_actions[_trans] == 0 )
		goto _again;

	_acts = _lexer_actions + _lexer_trans_actions[_trans];
	_nacts = (unsigned int) *_acts++;
	while ( _nacts-- > 0 )
	{
		switch ( *_acts++ )
		{
	case 0:
#line 86 "/Users/aslakhellesoy/scm/gherkin/tasks/../ragel/i18n/ru.c.rl"
	{
		MARK(content_start, p);
    lexer->current_line = lexer->line_number;
  }
	break;
	case 1:
#line 91 "/Users/aslakhellesoy/scm/gherkin/tasks/../ragel/i18n/ru.c.rl"
	{
    MARK(content_start, p);
  }
	break;
	case 2:
#line 95 "/Users/aslakhellesoy/scm/gherkin/tasks/../ragel/i18n/ru.c.rl"
	{
    lexer->current_line = lexer->line_number;
    lexer->start_col = p - data - lexer->last_newline;
  }
	break;
	case 3:
#line 100 "/Users/aslakhellesoy/scm/gherkin/tasks/../ragel/i18n/ru.c.rl"
	{
    int len = LEN(content_start, PTR_TO(final_newline));

    if (len < 0) len = 0;

    store_pystring_content(listener, lexer->start_col, PTR_TO(content_start), len, lexer->current_line);
  }
	break;
	case 4:
#line 108 "/Users/aslakhellesoy/scm/gherkin/tasks/../ragel/i18n/ru.c.rl"
	{
    STORE_KW_END_CON(feature);
  }
	break;
	case 5:
#line 112 "/Users/aslakhellesoy/scm/gherkin/tasks/../ragel/i18n/ru.c.rl"
	{
    STORE_KW_END_CON(background);
  }
	break;
	case 6:
#line 116 "/Users/aslakhellesoy/scm/gherkin/tasks/../ragel/i18n/ru.c.rl"
	{
    STORE_KW_END_CON(scenario);
  }
	break;
	case 7:
#line 120 "/Users/aslakhellesoy/scm/gherkin/tasks/../ragel/i18n/ru.c.rl"
	{
    STORE_KW_END_CON(scenario_outline);
  }
	break;
	case 8:
#line 124 "/Users/aslakhellesoy/scm/gherkin/tasks/../ragel/i18n/ru.c.rl"
	{
    STORE_KW_END_CON(examples);
  }
	break;
	case 9:
#line 128 "/Users/aslakhellesoy/scm/gherkin/tasks/../ragel/i18n/ru.c.rl"
	{
    store_kw_con(listener, "step",
      PTR_TO(keyword_start), LEN(keyword_start, PTR_TO(keyword_end)),
      PTR_TO(content_start), LEN(content_start, p), 
      lexer->current_line);
  }
	break;
	case 10:
#line 135 "/Users/aslakhellesoy/scm/gherkin/tasks/../ragel/i18n/ru.c.rl"
	{
    STORE_ATTR(comment);
    lexer->mark = 0;
  }
	break;
	case 11:
#line 140 "/Users/aslakhellesoy/scm/gherkin/tasks/../ragel/i18n/ru.c.rl"
	{
    STORE_ATTR(tag);
    lexer->mark = 0;
  }
	break;
	case 12:
#line 145 "/Users/aslakhellesoy/scm/gherkin/tasks/../ragel/i18n/ru.c.rl"
	{
    lexer->line_number += 1;
    MARK(final_newline, p);
  }
	break;
	case 13:
#line 150 "/Users/aslakhellesoy/scm/gherkin/tasks/../ragel/i18n/ru.c.rl"
	{
    MARK(last_newline, p + 1);
  }
	break;
	case 14:
#line 154 "/Users/aslakhellesoy/scm/gherkin/tasks/../ragel/i18n/ru.c.rl"
	{
    if (lexer->mark == 0) {
      MARK(mark, p);
    }
  }
	break;
	case 15:
#line 160 "/Users/aslakhellesoy/scm/gherkin/tasks/../ragel/i18n/ru.c.rl"
	{
    MARK(keyword_end, p);
    MARK(keyword_start, PTR_TO(mark));
    MARK(content_start, p + 1);
    lexer->mark = 0;
  }
	break;
	case 16:
#line 167 "/Users/aslakhellesoy/scm/gherkin/tasks/../ragel/i18n/ru.c.rl"
	{
    MARK(content_end, p);
  }
	break;
	case 17:
#line 171 "/Users/aslakhellesoy/scm/gherkin/tasks/../ragel/i18n/ru.c.rl"
	{
    p = p - 1;
    lexer->current_line = lexer->line_number;
    current_row = rb_ary_new();
  }
	break;
	case 18:
#line 177 "/Users/aslakhellesoy/scm/gherkin/tasks/../ragel/i18n/ru.c.rl"
	{
		MARK(content_start, p);
  }
	break;
	case 19:
#line 181 "/Users/aslakhellesoy/scm/gherkin/tasks/../ragel/i18n/ru.c.rl"
	{
    VALUE con = ENCODED_STR_NEW(PTR_TO(content_start), LEN(content_start, p));
    rb_funcall(con, rb_intern("strip!"), 0);
    VALUE re_pipe      = rb_reg_regcomp(rb_str_new2("\\\\\\|"));
    VALUE re_backslash = rb_reg_regcomp(rb_str_new2("\\\\\\\\"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_pipe,      rb_str_new2("|"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_backslash, rb_str_new2("\\"));

    rb_ary_push(current_row, con);
  }
	break;
	case 20:
#line 192 "/Users/aslakhellesoy/scm/gherkin/tasks/../ragel/i18n/ru.c.rl"
	{
    rb_funcall(listener, rb_intern("row"), 2, current_row, INT2FIX(lexer->current_line));
  }
	break;
	case 21:
#line 196 "/Users/aslakhellesoy/scm/gherkin/tasks/../ragel/i18n/ru.c.rl"
	{
    if (cs < lexer_first_final) {
      if (raise_lexer_error != NULL) {
        size_t count = 0;
        int newstr_count = 0;
        size_t len;
        const char *buff;
        if (lexer->last_newline != 0) {
          len = LEN(last_newline, eof);
          buff = PTR_TO(last_newline);
        } else {
          len = strlen(data);
          buff = data;
        }

        char newstr[len]; 

        for (count = 0; count < len; count++) {
          if(buff[count] == 10) {
            newstr[newstr_count] = '\0'; // terminate new string at first newline found
            break;
          } else {
            if (buff[count] == '%') {
              newstr[newstr_count++] = buff[count];
              newstr[newstr_count] = buff[count];
            } else {
              newstr[newstr_count] = buff[count];
            }
          }
          newstr_count++;
        }

        int line = lexer->line_number;
        lexer_init(lexer); // Re-initialize so we can scan again with the same lexer
        raise_lexer_error(newstr, line);
      }
    } else {
      rb_funcall(listener, rb_intern("eof"), 0);
    }
  }
	break;
#line 1823 "ext/gherkin_lexer_ru/gherkin_lexer_ru.c"
		}
	}

_again:
	if ( cs == 0 )
		goto _out;
	if ( ++p != pe )
		goto _resume;
	_test_eof: {}
	if ( p == eof )
	{
	const char *__acts = _lexer_actions + _lexer_eof_actions[cs];
	unsigned int __nacts = (unsigned int) *__acts++;
	while ( __nacts-- > 0 ) {
		switch ( *__acts++ ) {
	case 21:
#line 196 "/Users/aslakhellesoy/scm/gherkin/tasks/../ragel/i18n/ru.c.rl"
	{
    if (cs < lexer_first_final) {
      if (raise_lexer_error != NULL) {
        size_t count = 0;
        int newstr_count = 0;
        size_t len;
        const char *buff;
        if (lexer->last_newline != 0) {
          len = LEN(last_newline, eof);
          buff = PTR_TO(last_newline);
        } else {
          len = strlen(data);
          buff = data;
        }

        char newstr[len]; 

        for (count = 0; count < len; count++) {
          if(buff[count] == 10) {
            newstr[newstr_count] = '\0'; // terminate new string at first newline found
            break;
          } else {
            if (buff[count] == '%') {
              newstr[newstr_count++] = buff[count];
              newstr[newstr_count] = buff[count];
            } else {
              newstr[newstr_count] = buff[count];
            }
          }
          newstr_count++;
        }

        int line = lexer->line_number;
        lexer_init(lexer); // Re-initialize so we can scan again with the same lexer
        raise_lexer_error(newstr, line);
      }
    } else {
      rb_funcall(listener, rb_intern("eof"), 0);
    }
  }
	break;
#line 1882 "ext/gherkin_lexer_ru/gherkin_lexer_ru.c"
		}
	}
	}

	_out: {}
	}

#line 427 "/Users/aslakhellesoy/scm/gherkin/tasks/../ragel/i18n/ru.c.rl"

    assert(p <= pe && "data overflow after parsing execute");
    assert(lexer->content_start <= len && "content starts after data end");
    assert(lexer->mark < len && "mark is after data end");
    
    // Reset lexer by re-initializing the whole thing
    lexer_init(lexer);

    if (cs == lexer_error) {
      rb_raise(rb_eGherkinLexingError, "Invalid format, lexing fails.");
    } else {
      return Qtrue;
    }
  }
}

void Init_gherkin_lexer_ru()
{
  mGherkin = rb_define_module("Gherkin");
  rb_eGherkinLexingError = rb_const_get(mGherkin, rb_intern("LexingError"));

  mCLexer = rb_define_module_under(mGherkin, "CLexer");
  cI18nLexer = rb_define_class_under(mCLexer, "Ru", rb_cObject);
  rb_define_alloc_func(cI18nLexer, CLexer_alloc);
  rb_define_method(cI18nLexer, "initialize", CLexer_init, 1);
  rb_define_method(cI18nLexer, "scan", CLexer_scan, 3);
}

