
#line 1 "/Users/aslakhellesoy/scm/gherkin/tasks/../ragel/i18n/ja.c.rl"
#include <assert.h>
#include <ruby.h>

#if defined(_WIN32)
#include <stddef.h>
#endif

#ifdef HAVE_RUBY_RE_H
#include <ruby/re.h>
#else
#include <re.h>
#endif

#ifdef HAVE_RUBY_ENCODING_H
#include <ruby/encoding.h>
#define ENCODED_STR_NEW(ptr, len) \
    rb_enc_str_new(ptr, len, rb_utf8_encoding())
#else
#define ENCODED_STR_NEW(ptr, len) \
    rb_str_new(ptr, len)
#endif

#define LF_FLAG      0
#define CRLF_FLAG    1
#define LF           "\n"
#define CRLF         "\r\n"

#ifndef RSTRING_PTR
#define RSTRING_PTR(s) (RSTRING(s)->ptr)
#endif

#ifndef RSTRING_LEN
#define RSTRING_LEN(s) (RSTRING(s)->len)
#endif

#define DATA_GET(FROM, TYPE, NAME) \
  Data_Get_Struct(FROM, TYPE, NAME); \
  if (NAME == NULL) { \
    rb_raise(rb_eArgError, "NULL found for " # NAME " when it shouldn't be."); \
  }
 
typedef struct lexer_state {
  int content_len;
  int line_number;
  int current_line;
  int start_col;
  int eol;
  size_t mark;
  size_t keyword_start;
  size_t keyword_end;
  size_t next_keyword_start;
  size_t content_start;
  size_t content_end;
  size_t query_start;
  size_t last_newline;
  size_t final_newline;
} lexer_state;

static VALUE mGherkin;
static VALUE mCLexer;
static VALUE cI18nLexer;
static VALUE rb_eGherkinLexingError;

#define LEN(AT, P) (P - data - lexer->AT)
#define MARK(M, P) (lexer->M = (P) - data)
#define PTR_TO(P) (data + lexer->P)

#define STORE_KW_END_CON(EVENT) \
  store_multiline_kw_con(listener, # EVENT, \
    PTR_TO(keyword_start), LEN(keyword_start, PTR_TO(keyword_end - 1)), \
    PTR_TO(content_start), LEN(content_start, PTR_TO(content_end)), \
    lexer->current_line, lexer->eol); \
    if (lexer->content_end != 0) { \
      p = PTR_TO(content_end - 1); \
    } \
    lexer->content_end = 0

#define STORE_ATTR(ATTR) \
    store_attr(listener, # ATTR, \
      PTR_TO(content_start), LEN(content_start, p), \
      lexer->line_number)


#line 239 "/Users/aslakhellesoy/scm/gherkin/tasks/../ragel/i18n/ja.c.rl"


/** Data **/

#line 92 "ext/gherkin_lexer_ja/gherkin_lexer_ja.c"
static const char _lexer_actions[] = {
	0, 1, 0, 1, 1, 1, 2, 1, 
	3, 1, 4, 1, 5, 1, 6, 1, 
	7, 1, 8, 1, 9, 1, 10, 1, 
	11, 1, 14, 1, 15, 1, 16, 1, 
	17, 1, 18, 1, 19, 1, 20, 1, 
	21, 2, 1, 16, 2, 11, 0, 2, 
	12, 13, 2, 15, 0, 2, 15, 2, 
	2, 15, 14, 2, 15, 17, 2, 16, 
	4, 2, 16, 5, 2, 16, 6, 2, 
	16, 7, 2, 16, 8, 2, 16, 14, 
	2, 18, 19, 2, 20, 0, 2, 20, 
	2, 2, 20, 14, 2, 20, 17, 3, 
	3, 12, 13, 3, 9, 12, 13, 3, 
	10, 12, 13, 3, 11, 12, 13, 3, 
	12, 13, 16, 3, 15, 12, 13, 4, 
	1, 12, 13, 16, 4, 15, 0, 12, 
	13
};

static const short _lexer_key_offsets[] = {
	0, 0, 16, 19, 23, 24, 25, 26, 
	27, 29, 44, 46, 47, 48, 49, 50, 
	51, 52, 53, 54, 62, 64, 66, 68, 
	70, 72, 74, 76, 78, 80, 82, 84, 
	86, 88, 90, 92, 107, 108, 109, 110, 
	111, 112, 113, 114, 115, 116, 117, 118, 
	119, 120, 131, 134, 137, 139, 141, 143, 
	145, 147, 149, 151, 153, 155, 157, 159, 
	161, 163, 165, 167, 169, 171, 173, 175, 
	178, 181, 183, 185, 187, 189, 191, 193, 
	195, 197, 199, 201, 203, 205, 207, 209, 
	211, 213, 215, 217, 219, 221, 223, 225, 
	227, 229, 231, 233, 236, 238, 240, 242, 
	244, 246, 249, 251, 253, 255, 257, 259, 
	261, 263, 265, 267, 269, 271, 273, 275, 
	277, 279, 281, 283, 285, 287, 289, 291, 
	293, 295, 297, 299, 301, 303, 305, 307, 
	309, 311, 313, 315, 317, 319, 321, 323, 
	325, 327, 329, 331, 333, 335, 337, 339, 
	341, 343, 344, 345, 346, 347, 348, 349, 
	350, 351, 363, 367, 372, 374, 376, 378, 
	380, 382, 384, 386, 388, 390, 392, 394, 
	396, 398, 400, 402, 404, 406, 408, 411, 
	413, 415, 417, 419, 421, 423, 425, 427, 
	429, 432, 435, 437, 439, 441, 443, 445, 
	447, 449, 451, 453, 455, 457, 459, 461, 
	463, 465, 467, 469, 471, 473, 475, 477, 
	479, 481, 483, 485, 487, 489, 492, 494, 
	496, 498, 500, 502, 505, 507, 509, 511, 
	513, 515, 517, 519, 521, 523, 525, 527, 
	529, 531, 533, 535, 537, 539, 541, 543, 
	545, 547, 549, 551, 553, 555, 557, 559, 
	561, 563, 565, 567, 569, 571, 573, 575, 
	577, 579, 581, 583, 585, 587, 589, 591, 
	593, 595, 597, 599, 601, 602, 603, 607, 
	612, 617, 622, 627, 631, 635, 637, 638, 
	639, 640, 641, 642, 643, 644, 645, 646, 
	647, 648, 649, 650, 651, 652, 653, 658, 
	665, 670, 674, 680, 683, 685, 691, 706, 
	708, 710, 712, 714, 716, 717, 718, 719, 
	720, 721, 722, 723, 724, 725, 726, 727, 
	728, 731, 732, 733, 734, 735, 736, 737, 
	738, 739, 740, 741, 742, 743, 744, 745, 
	746, 747, 748, 749, 751, 753, 754, 755, 
	756, 757, 758, 759, 760, 761, 762, 763, 
	764, 765, 766, 767, 768, 769, 770, 771, 
	772, 784, 788, 793, 795, 797, 799, 801, 
	803, 805, 807, 809, 811, 813, 815, 817, 
	819, 821, 823, 825, 827, 829, 832, 834, 
	836, 838, 840, 842, 844, 846, 848, 850, 
	852, 854, 856, 858, 860, 862, 864, 866, 
	868, 870, 872, 874, 876, 878, 880, 882, 
	884, 886, 888, 890, 892, 894, 896, 898, 
	900, 902, 904, 906, 908, 910, 912, 914, 
	916, 918, 920, 922, 924, 926, 928, 930, 
	932, 933, 934, 935, 936, 937, 938, 939, 
	940, 941, 942, 944, 945, 946, 947, 948, 
	949, 950, 951, 964, 968, 973, 975, 977, 
	979, 981, 983, 985, 987, 989, 991, 993, 
	995, 997, 999, 1001, 1003, 1005, 1007, 1009, 
	1012, 1014, 1016, 1018, 1020, 1022, 1024, 1026, 
	1028, 1030, 1033, 1036, 1038, 1040, 1042, 1044, 
	1046, 1048, 1050, 1052, 1054, 1056, 1058, 1060, 
	1062, 1064, 1066, 1068, 1070, 1072, 1074, 1076, 
	1078, 1080, 1082, 1084, 1086, 1088, 1090, 1093, 
	1095, 1097, 1099, 1101, 1103, 1106, 1108, 1110, 
	1112, 1114, 1116, 1118, 1120, 1122, 1124, 1126, 
	1128, 1130, 1132, 1134, 1136, 1138, 1140, 1142, 
	1144, 1146, 1148, 1150, 1152, 1154, 1156, 1158, 
	1160, 1162, 1164, 1166, 1168, 1170, 1172, 1174, 
	1176, 1178, 1180, 1182, 1184, 1186, 1188, 1190, 
	1192, 1194, 1196, 1198, 1200, 1202, 1204, 1206, 
	1208, 1210, 1212, 1214, 1215, 1216, 1217, 1218, 
	1219, 1220, 1221, 1222, 1223, 1224, 1225, 1226, 
	1227, 1228, 1229, 1230, 1231, 1232, 1233, 1234, 
	1235, 1236, 1237
};

static const char _lexer_trans_keys[] = {
	-29, -28, -27, -26, -24, -17, 10, 32, 
	34, 35, 37, 42, 64, 124, 9, 13, 
	-127, -126, -125, -117, -105, -97, -86, -29, 
	-127, -92, 10, 10, 13, -29, -28, -27, 
	-26, -24, 10, 32, 34, 35, 37, 42, 
	64, 124, 9, 13, -67, -66, -122, -29, 
	-127, -105, -117, 58, 10, 10, -29, -26, 
	10, 32, 35, 124, 9, 13, -125, 10, 
	-107, 10, -29, 10, -126, 10, -93, 10, 
	-29, 10, -125, 10, -68, 10, -29, 10, 
	-125, 10, -127, 10, -29, 10, -125, 10, 
	-93, 10, 10, 58, -29, -28, -27, -26, 
	-24, 10, 32, 34, 35, 37, 42, 64, 
	124, 9, 13, -119, -115, -26, -113, -112, 
	-87, -97, -24, -125, -67, 58, 10, 10, 
	-29, -28, -26, -24, 10, 32, 35, 37, 
	64, 9, 13, -126, -125, 10, -75, -73, 
	10, -29, 10, -125, 10, -77, 10, -29, 
	10, -125, 10, -105, 10, -29, 10, -125, 
	10, -85, 10, 10, 58, -29, 10, -125, 
	10, -118, 10, -29, 10, -125, 10, -86, 
	10, -29, 10, -126, 10, -86, 10, -29, 
	10, 58, -126, -125, 10, -94, 10, -29, 
	10, -126, 10, -90, 10, -29, 10, -125, 
	10, -120, 10, -29, 10, -125, 10, -87, 
	10, -29, 10, -126, 10, -92, 10, -29, 
	10, -125, 10, -77, 10, -122, 10, -29, 
	10, -125, 10, -77, 10, -29, 10, -125, 
	10, -105, 10, -29, 10, -125, 10, -84, 
	10, -29, 10, 58, -125, 10, -68, 10, 
	-29, 10, -125, 10, -120, 10, -122, -107, 
	10, -29, 10, -125, 10, -77, 10, -29, 
	10, -125, 10, -105, 10, -29, 10, -125, 
	10, -84, 10, -29, 10, -126, 10, -93, 
	10, -29, 10, -125, 10, -68, 10, -29, 
	10, -125, 10, -127, 10, -29, 10, -125, 
	10, -93, 10, -66, 10, -117, 10, -87, 
	10, -97, 10, -24, 10, -125, 10, -67, 
	10, -125, 10, -116, 10, -26, 10, -103, 
	10, -81, 10, 10, 95, 10, 70, 10, 
	69, 10, 65, 10, 84, 10, 85, 10, 
	82, 10, 69, 10, 95, 10, 69, 10, 
	78, 10, 68, 10, 95, 10, 37, -125, 
	-116, -26, -103, -81, 58, 10, 10, -29, 
	-28, -27, -26, 10, 32, 35, 37, 42, 
	64, 9, 13, -127, -126, -125, 10, -117, 
	-105, -97, -86, 10, -29, 10, -127, 10, 
	-92, 10, -29, 10, -127, 10, -117, 10, 
	-29, 10, -127, 10, -105, 10, -29, 10, 
	-127, 10, -96, 10, -29, 10, -126, 10, 
	-119, 10, -29, 10, -127, 10, -80, 10, 
	-126, -73, 10, -29, 10, -125, 10, -118, 
	10, -29, 10, -125, 10, -86, 10, -29, 
	10, -126, 10, -86, 10, -29, 10, 58, 
	-126, -125, 10, -94, 10, -29, 10, -126, 
	10, -90, 10, -29, 10, -125, 10, -120, 
	10, -29, 10, -125, 10, -87, 10, -29, 
	10, -126, 10, -92, 10, -29, 10, -125, 
	10, -77, 10, 10, 58, -122, 10, -29, 
	10, -125, 10, -77, 10, -29, 10, -125, 
	10, -105, 10, -29, 10, -125, 10, -84, 
	10, -29, 10, 58, -125, 10, -68, 10, 
	-29, 10, -125, 10, -120, 10, -122, -107, 
	10, -29, 10, -125, 10, -77, 10, -29, 
	10, -125, 10, -105, 10, -29, 10, -125, 
	10, -84, 10, -29, 10, -126, 10, -93, 
	10, -29, 10, -125, 10, -68, 10, -29, 
	10, -125, 10, -127, 10, -29, 10, -125, 
	10, -93, 10, -67, 10, -122, 10, -119, 
	10, -115, 10, -26, 10, -113, 10, -112, 
	10, -87, 10, -97, 10, -24, 10, -125, 
	10, -67, 10, 10, 95, 10, 70, 10, 
	69, 10, 65, 10, 84, 10, 85, 10, 
	82, 10, 69, 10, 95, 10, 69, 10, 
	78, 10, 68, 10, 95, 10, 37, 10, 
	32, 34, 34, 10, 32, 9, 13, 10, 
	32, 34, 9, 13, 10, 32, 34, 9, 
	13, 10, 32, 34, 9, 13, 10, 32, 
	34, 9, 13, 10, 32, 9, 13, 10, 
	32, 9, 13, 10, 13, 10, 95, 70, 
	69, 65, 84, 85, 82, 69, 95, 69, 
	78, 68, 95, 37, 32, 13, 32, 64, 
	9, 10, 9, 10, 13, 32, 64, 11, 
	12, 10, 32, 64, 9, 13, 32, 124, 
	9, 13, 10, 32, 92, 124, 9, 13, 
	10, 92, 124, 10, 92, 10, 32, 92, 
	124, 9, 13, -29, -28, -27, -26, -24, 
	10, 32, 34, 35, 37, 42, 64, 124, 
	9, 13, -87, 10, -97, 10, -24, 10, 
	-125, 10, -67, 10, -29, -127, -117, -29, 
	-127, -96, -29, -126, -119, -29, -127, -80, 
	-126, -75, -73, -29, -125, -77, -29, -125, 
	-105, -29, -125, -85, -29, -125, -118, -29, 
	-125, -86, -29, -126, -86, -29, 58, -126, 
	-125, -94, -29, -126, -90, -29, -125, -120, 
	-29, -125, -87, -29, -126, -92, -29, -125, 
	-77, 58, 10, 10, -29, -28, -27, -26, 
	10, 32, 35, 37, 42, 64, 9, 13, 
	-127, -126, -125, 10, -117, -105, -97, -86, 
	10, -29, 10, -127, 10, -92, 10, -29, 
	10, -127, 10, -117, 10, -29, 10, -127, 
	10, -105, 10, -29, 10, -127, 10, -96, 
	10, -29, 10, -126, 10, -119, 10, -29, 
	10, -127, 10, -80, 10, -126, -73, 10, 
	-29, 10, -125, 10, -118, 10, -29, 10, 
	-125, 10, -86, 10, -29, 10, -126, 10, 
	-86, 10, 10, 58, -107, 10, -29, 10, 
	-126, 10, -93, 10, -29, 10, -125, 10, 
	-68, 10, -29, 10, -125, 10, -127, 10, 
	-29, 10, -125, 10, -93, 10, -67, 10, 
	-122, 10, -119, 10, -115, 10, -26, 10, 
	-113, 10, -112, 10, -87, 10, -97, 10, 
	-24, 10, -125, 10, -67, 10, 10, 95, 
	10, 70, 10, 69, 10, 65, 10, 84, 
	10, 85, 10, 82, 10, 69, 10, 95, 
	10, 69, 10, 78, 10, 68, 10, 95, 
	10, 37, 10, 32, -122, -29, -125, -77, 
	-29, -125, -105, -29, -125, -84, -29, 58, 
	-125, -68, -29, -125, -120, 10, 10, -29, 
	-28, -27, -26, -24, 10, 32, 35, 37, 
	42, 64, 9, 13, -127, -126, -125, 10, 
	-117, -105, -97, -86, 10, -29, 10, -127, 
	10, -92, 10, -29, 10, -127, 10, -117, 
	10, -29, 10, -127, 10, -105, 10, -29, 
	10, -127, 10, -96, 10, -29, 10, -126, 
	10, -119, 10, -29, 10, -127, 10, -80, 
	10, -126, -73, 10, -29, 10, -125, 10, 
	-118, 10, -29, 10, -125, 10, -86, 10, 
	-29, 10, -126, 10, -86, 10, -29, 10, 
	58, -126, -125, 10, -94, 10, -29, 10, 
	-126, 10, -90, 10, -29, 10, -125, 10, 
	-120, 10, -29, 10, -125, 10, -87, 10, 
	-29, 10, -126, 10, -92, 10, -29, 10, 
	-125, 10, -77, 10, 10, 58, -122, 10, 
	-29, 10, -125, 10, -77, 10, -29, 10, 
	-125, 10, -105, 10, -29, 10, -125, 10, 
	-84, 10, -29, 10, 58, -125, 10, -68, 
	10, -29, 10, -125, 10, -120, 10, -122, 
	-107, 10, -29, 10, -125, 10, -77, 10, 
	-29, 10, -125, 10, -105, 10, -29, 10, 
	-125, 10, -84, 10, -29, 10, -126, 10, 
	-93, 10, -29, 10, -125, 10, -68, 10, 
	-29, 10, -125, 10, -127, 10, -29, 10, 
	-125, 10, -93, 10, -67, 10, -122, 10, 
	-119, 10, -115, 10, -26, 10, -113, 10, 
	-112, 10, -87, 10, -97, 10, -24, 10, 
	-125, 10, -67, 10, -125, 10, -116, 10, 
	-26, 10, -103, 10, -81, 10, 10, 95, 
	10, 70, 10, 69, 10, 65, 10, 84, 
	10, 85, 10, 82, 10, 69, 10, 95, 
	10, 69, 10, 78, 10, 68, 10, 95, 
	10, 37, 10, 32, -122, -107, -29, -125, 
	-77, -29, -125, -105, -29, -125, -84, -29, 
	-126, -93, -29, -125, -68, -29, -125, -127, 
	-29, -125, -93, -69, -65, 0
};

static const char _lexer_single_lengths[] = {
	0, 14, 3, 4, 1, 1, 1, 1, 
	2, 13, 2, 1, 1, 1, 1, 1, 
	1, 1, 1, 6, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 13, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 9, 3, 3, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 3, 
	3, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 3, 2, 2, 2, 2, 
	2, 3, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 1, 1, 1, 1, 1, 1, 1, 
	1, 10, 4, 5, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 3, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	3, 3, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 3, 2, 2, 
	2, 2, 2, 3, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 1, 1, 2, 3, 
	3, 3, 3, 2, 2, 2, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 3, 5, 
	3, 2, 4, 3, 2, 4, 13, 2, 
	2, 2, 2, 2, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	3, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 2, 2, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	10, 4, 5, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 3, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 2, 1, 1, 1, 1, 1, 
	1, 1, 11, 4, 5, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 3, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 3, 3, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 3, 2, 
	2, 2, 2, 2, 3, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 0
};

static const char _lexer_range_lengths[] = {
	0, 1, 0, 0, 0, 0, 0, 0, 
	0, 1, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 1, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 1, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 1, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 1, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 1, 1, 
	1, 1, 1, 1, 1, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 1, 1, 
	1, 1, 1, 0, 0, 1, 1, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	1, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 1, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0
};

static const short _lexer_index_offsets[] = {
	0, 0, 16, 20, 25, 27, 29, 31, 
	33, 36, 51, 54, 56, 58, 60, 62, 
	64, 66, 68, 70, 78, 81, 84, 87, 
	90, 93, 96, 99, 102, 105, 108, 111, 
	114, 117, 120, 123, 138, 140, 142, 144, 
	146, 148, 150, 152, 154, 156, 158, 160, 
	162, 164, 175, 179, 183, 186, 189, 192, 
	195, 198, 201, 204, 207, 210, 213, 216, 
	219, 222, 225, 228, 231, 234, 237, 240, 
	244, 248, 251, 254, 257, 260, 263, 266, 
	269, 272, 275, 278, 281, 284, 287, 290, 
	293, 296, 299, 302, 305, 308, 311, 314, 
	317, 320, 323, 326, 330, 333, 336, 339, 
	342, 345, 349, 352, 355, 358, 361, 364, 
	367, 370, 373, 376, 379, 382, 385, 388, 
	391, 394, 397, 400, 403, 406, 409, 412, 
	415, 418, 421, 424, 427, 430, 433, 436, 
	439, 442, 445, 448, 451, 454, 457, 460, 
	463, 466, 469, 472, 475, 478, 481, 484, 
	487, 490, 492, 494, 496, 498, 500, 502, 
	504, 506, 518, 523, 529, 532, 535, 538, 
	541, 544, 547, 550, 553, 556, 559, 562, 
	565, 568, 571, 574, 577, 580, 583, 587, 
	590, 593, 596, 599, 602, 605, 608, 611, 
	614, 618, 622, 625, 628, 631, 634, 637, 
	640, 643, 646, 649, 652, 655, 658, 661, 
	664, 667, 670, 673, 676, 679, 682, 685, 
	688, 691, 694, 697, 700, 703, 707, 710, 
	713, 716, 719, 722, 726, 729, 732, 735, 
	738, 741, 744, 747, 750, 753, 756, 759, 
	762, 765, 768, 771, 774, 777, 780, 783, 
	786, 789, 792, 795, 798, 801, 804, 807, 
	810, 813, 816, 819, 822, 825, 828, 831, 
	834, 837, 840, 843, 846, 849, 852, 855, 
	858, 861, 864, 867, 870, 872, 874, 878, 
	883, 888, 893, 898, 902, 906, 909, 911, 
	913, 915, 917, 919, 921, 923, 925, 927, 
	929, 931, 933, 935, 937, 939, 941, 946, 
	953, 958, 962, 968, 972, 975, 981, 996, 
	999, 1002, 1005, 1008, 1011, 1013, 1015, 1017, 
	1019, 1021, 1023, 1025, 1027, 1029, 1031, 1033, 
	1035, 1039, 1041, 1043, 1045, 1047, 1049, 1051, 
	1053, 1055, 1057, 1059, 1061, 1063, 1065, 1067, 
	1069, 1071, 1073, 1075, 1078, 1081, 1083, 1085, 
	1087, 1089, 1091, 1093, 1095, 1097, 1099, 1101, 
	1103, 1105, 1107, 1109, 1111, 1113, 1115, 1117, 
	1119, 1131, 1136, 1142, 1145, 1148, 1151, 1154, 
	1157, 1160, 1163, 1166, 1169, 1172, 1175, 1178, 
	1181, 1184, 1187, 1190, 1193, 1196, 1200, 1203, 
	1206, 1209, 1212, 1215, 1218, 1221, 1224, 1227, 
	1230, 1233, 1236, 1239, 1242, 1245, 1248, 1251, 
	1254, 1257, 1260, 1263, 1266, 1269, 1272, 1275, 
	1278, 1281, 1284, 1287, 1290, 1293, 1296, 1299, 
	1302, 1305, 1308, 1311, 1314, 1317, 1320, 1323, 
	1326, 1329, 1332, 1335, 1338, 1341, 1344, 1347, 
	1350, 1352, 1354, 1356, 1358, 1360, 1362, 1364, 
	1366, 1368, 1370, 1373, 1375, 1377, 1379, 1381, 
	1383, 1385, 1387, 1400, 1405, 1411, 1414, 1417, 
	1420, 1423, 1426, 1429, 1432, 1435, 1438, 1441, 
	1444, 1447, 1450, 1453, 1456, 1459, 1462, 1465, 
	1469, 1472, 1475, 1478, 1481, 1484, 1487, 1490, 
	1493, 1496, 1500, 1504, 1507, 1510, 1513, 1516, 
	1519, 1522, 1525, 1528, 1531, 1534, 1537, 1540, 
	1543, 1546, 1549, 1552, 1555, 1558, 1561, 1564, 
	1567, 1570, 1573, 1576, 1579, 1582, 1585, 1589, 
	1592, 1595, 1598, 1601, 1604, 1608, 1611, 1614, 
	1617, 1620, 1623, 1626, 1629, 1632, 1635, 1638, 
	1641, 1644, 1647, 1650, 1653, 1656, 1659, 1662, 
	1665, 1668, 1671, 1674, 1677, 1680, 1683, 1686, 
	1689, 1692, 1695, 1698, 1701, 1704, 1707, 1710, 
	1713, 1716, 1719, 1722, 1725, 1728, 1731, 1734, 
	1737, 1740, 1743, 1746, 1749, 1752, 1755, 1758, 
	1761, 1764, 1767, 1770, 1772, 1774, 1776, 1778, 
	1780, 1782, 1784, 1786, 1788, 1790, 1792, 1794, 
	1796, 1798, 1800, 1802, 1804, 1806, 1808, 1810, 
	1812, 1814, 1816
};

static const short _lexer_trans_targs[] = {
	2, 10, 36, 41, 153, 600, 9, 9, 
	276, 285, 287, 301, 302, 305, 9, 0, 
	3, 328, 578, 0, 4, 316, 319, 322, 
	0, 5, 0, 6, 0, 7, 0, 0, 
	8, 9, 286, 8, 2, 10, 36, 41, 
	153, 9, 9, 276, 285, 287, 301, 302, 
	305, 9, 0, 11, 15, 0, 12, 0, 
	13, 0, 14, 0, 7, 0, 16, 0, 
	17, 0, 19, 18, 19, 18, 20, 311, 
	19, 19, 9, 9, 19, 18, 21, 19, 
	18, 22, 19, 18, 23, 19, 18, 24, 
	19, 18, 25, 19, 18, 26, 19, 18, 
	27, 19, 18, 28, 19, 18, 29, 19, 
	18, 30, 19, 18, 31, 19, 18, 32, 
	19, 18, 33, 19, 18, 34, 19, 18, 
	19, 35, 18, 2, 10, 36, 41, 153, 
	9, 9, 276, 285, 287, 301, 302, 305, 
	9, 0, 37, 0, 38, 0, 39, 0, 
	40, 0, 7, 0, 42, 0, 43, 0, 
	44, 0, 45, 0, 46, 0, 47, 0, 
	49, 48, 49, 48, 50, 127, 129, 134, 
	49, 49, 9, 139, 9, 49, 48, 51, 
	105, 49, 48, 52, 62, 49, 48, 53, 
	49, 48, 54, 49, 48, 55, 49, 48, 
	56, 49, 48, 57, 49, 48, 58, 49, 
	48, 59, 49, 48, 60, 49, 48, 61, 
	49, 48, 49, 35, 48, 63, 49, 48, 
	64, 49, 48, 65, 49, 48, 66, 49, 
	48, 67, 49, 48, 68, 49, 48, 69, 
	49, 48, 70, 49, 48, 71, 49, 48, 
	72, 49, 35, 48, 73, 89, 49, 48, 
	74, 49, 48, 75, 49, 48, 76, 49, 
	48, 77, 49, 48, 78, 49, 48, 79, 
	49, 48, 80, 49, 48, 81, 49, 48, 
	82, 49, 48, 83, 49, 48, 84, 49, 
	48, 85, 49, 48, 86, 49, 48, 87, 
	49, 48, 88, 49, 48, 61, 49, 48, 
	90, 49, 48, 91, 49, 48, 92, 49, 
	48, 93, 49, 48, 94, 49, 48, 95, 
	49, 48, 96, 49, 48, 97, 49, 48, 
	98, 49, 48, 99, 49, 48, 100, 49, 
	35, 48, 101, 49, 48, 102, 49, 48, 
	103, 49, 48, 104, 49, 48, 61, 49, 
	48, 106, 115, 49, 48, 107, 49, 48, 
	108, 49, 48, 109, 49, 48, 110, 49, 
	48, 111, 49, 48, 112, 49, 48, 113, 
	49, 48, 114, 49, 48, 61, 49, 48, 
	116, 49, 48, 117, 49, 48, 118, 49, 
	48, 119, 49, 48, 120, 49, 48, 121, 
	49, 48, 122, 49, 48, 123, 49, 48, 
	124, 49, 48, 125, 49, 48, 126, 49, 
	48, 61, 49, 48, 128, 49, 48, 61, 
	49, 48, 130, 49, 48, 131, 49, 48, 
	132, 49, 48, 133, 49, 48, 61, 49, 
	48, 135, 49, 48, 136, 49, 48, 137, 
	49, 48, 138, 49, 48, 61, 49, 48, 
	49, 140, 48, 49, 141, 48, 49, 142, 
	48, 49, 143, 48, 49, 144, 48, 49, 
	145, 48, 49, 146, 48, 49, 147, 48, 
	49, 148, 48, 49, 149, 48, 49, 150, 
	48, 49, 151, 48, 49, 152, 48, 49, 
	9, 48, 154, 0, 155, 0, 156, 0, 
	157, 0, 158, 0, 159, 0, 161, 160, 
	161, 160, 162, 249, 251, 256, 161, 161, 
	9, 261, 275, 9, 161, 160, 163, 182, 
	227, 161, 160, 164, 167, 173, 176, 161, 
	160, 165, 161, 160, 166, 161, 160, 35, 
	161, 160, 168, 161, 160, 169, 161, 160, 
	170, 161, 160, 171, 161, 160, 172, 161, 
	160, 35, 161, 160, 174, 161, 160, 175, 
	161, 160, 170, 161, 160, 177, 161, 160, 
	178, 161, 160, 179, 161, 160, 180, 161, 
	160, 181, 161, 160, 35, 161, 160, 170, 
	183, 161, 160, 184, 161, 160, 185, 161, 
	160, 186, 161, 160, 187, 161, 160, 188, 
	161, 160, 189, 161, 160, 190, 161, 160, 
	191, 161, 160, 192, 161, 160, 193, 161, 
	35, 160, 194, 211, 161, 160, 195, 161, 
	160, 196, 161, 160, 197, 161, 160, 198, 
	161, 160, 199, 161, 160, 200, 161, 160, 
	201, 161, 160, 202, 161, 160, 203, 161, 
	160, 204, 161, 160, 205, 161, 160, 206, 
	161, 160, 207, 161, 160, 208, 161, 160, 
	209, 161, 160, 210, 161, 160, 161, 35, 
	160, 212, 161, 160, 213, 161, 160, 214, 
	161, 160, 215, 161, 160, 216, 161, 160, 
	217, 161, 160, 218, 161, 160, 219, 161, 
	160, 220, 161, 160, 221, 161, 160, 222, 
	161, 35, 160, 223, 161, 160, 224, 161, 
	160, 225, 161, 160, 226, 161, 160, 210, 
	161, 160, 228, 237, 161, 160, 229, 161, 
	160, 230, 161, 160, 231, 161, 160, 232, 
	161, 160, 233, 161, 160, 234, 161, 160, 
	235, 161, 160, 236, 161, 160, 210, 161, 
	160, 238, 161, 160, 239, 161, 160, 240, 
	161, 160, 241, 161, 160, 242, 161, 160, 
	243, 161, 160, 244, 161, 160, 245, 161, 
	160, 246, 161, 160, 247, 161, 160, 248, 
	161, 160, 210, 161, 160, 250, 161, 160, 
	170, 161, 160, 252, 161, 160, 253, 161, 
	160, 254, 161, 160, 255, 161, 160, 35, 
	161, 160, 257, 161, 160, 258, 161, 160, 
	259, 161, 160, 260, 161, 160, 210, 161, 
	160, 161, 262, 160, 161, 263, 160, 161, 
	264, 160, 161, 265, 160, 161, 266, 160, 
	161, 267, 160, 161, 268, 160, 161, 269, 
	160, 161, 270, 160, 161, 271, 160, 161, 
	272, 160, 161, 273, 160, 161, 274, 160, 
	161, 9, 160, 161, 35, 160, 277, 0, 
	278, 0, 279, 278, 278, 0, 280, 280, 
	281, 280, 280, 280, 280, 281, 280, 280, 
	280, 280, 282, 280, 280, 280, 280, 283, 
	280, 280, 9, 284, 284, 0, 9, 284, 
	284, 0, 9, 286, 285, 9, 0, 288, 
	0, 289, 0, 290, 0, 291, 0, 292, 
	0, 293, 0, 294, 0, 295, 0, 296, 
	0, 297, 0, 298, 0, 299, 0, 300, 
	0, 602, 0, 7, 0, 0, 0, 0, 
	0, 303, 304, 9, 304, 304, 302, 303, 
	303, 9, 304, 302, 304, 0, 305, 306, 
	305, 0, 310, 309, 308, 306, 309, 307, 
	0, 308, 306, 307, 0, 308, 307, 310, 
	309, 308, 306, 309, 307, 2, 10, 36, 
	41, 153, 310, 310, 276, 285, 287, 301, 
	302, 305, 310, 0, 312, 19, 18, 313, 
	19, 18, 314, 19, 18, 315, 19, 18, 
	34, 19, 18, 317, 0, 318, 0, 12, 
	0, 320, 0, 321, 0, 12, 0, 323, 
	0, 324, 0, 325, 0, 326, 0, 327, 
	0, 7, 0, 12, 329, 338, 0, 330, 
	0, 331, 0, 332, 0, 333, 0, 334, 
	0, 335, 0, 336, 0, 337, 0, 16, 
	0, 339, 0, 340, 0, 341, 0, 342, 
	0, 343, 0, 344, 0, 345, 0, 346, 
	0, 347, 0, 348, 456, 0, 349, 440, 
	0, 350, 0, 351, 0, 352, 0, 353, 
	0, 354, 0, 355, 0, 356, 0, 357, 
	0, 358, 0, 359, 0, 360, 0, 361, 
	0, 362, 0, 363, 0, 364, 0, 365, 
	0, 366, 0, 368, 367, 368, 367, 369, 
	413, 415, 420, 368, 368, 9, 425, 439, 
	9, 368, 367, 370, 389, 400, 368, 367, 
	371, 374, 380, 383, 368, 367, 372, 368, 
	367, 373, 368, 367, 35, 368, 367, 375, 
	368, 367, 376, 368, 367, 377, 368, 367, 
	378, 368, 367, 379, 368, 367, 35, 368, 
	367, 381, 368, 367, 382, 368, 367, 377, 
	368, 367, 384, 368, 367, 385, 368, 367, 
	386, 368, 367, 387, 368, 367, 388, 368, 
	367, 35, 368, 367, 377, 390, 368, 367, 
	391, 368, 367, 392, 368, 367, 393, 368, 
	367, 394, 368, 367, 395, 368, 367, 396, 
	368, 367, 397, 368, 367, 398, 368, 367, 
	399, 368, 367, 368, 35, 367, 401, 368, 
	367, 402, 368, 367, 403, 368, 367, 404, 
	368, 367, 405, 368, 367, 406, 368, 367, 
	407, 368, 367, 408, 368, 367, 409, 368, 
	367, 410, 368, 367, 411, 368, 367, 412, 
	368, 367, 399, 368, 367, 414, 368, 367, 
	377, 368, 367, 416, 368, 367, 417, 368, 
	367, 418, 368, 367, 419, 368, 367, 35, 
	368, 367, 421, 368, 367, 422, 368, 367, 
	423, 368, 367, 424, 368, 367, 399, 368, 
	367, 368, 426, 367, 368, 427, 367, 368, 
	428, 367, 368, 429, 367, 368, 430, 367, 
	368, 431, 367, 368, 432, 367, 368, 433, 
	367, 368, 434, 367, 368, 435, 367, 368, 
	436, 367, 368, 437, 367, 368, 438, 367, 
	368, 9, 367, 368, 35, 367, 441, 0, 
	442, 0, 443, 0, 444, 0, 445, 0, 
	446, 0, 447, 0, 448, 0, 449, 0, 
	450, 0, 451, 366, 0, 452, 0, 453, 
	0, 454, 0, 455, 0, 365, 0, 458, 
	457, 458, 457, 459, 546, 548, 553, 558, 
	458, 458, 9, 563, 577, 9, 458, 457, 
	460, 479, 524, 458, 457, 461, 464, 470, 
	473, 458, 457, 462, 458, 457, 463, 458, 
	457, 35, 458, 457, 465, 458, 457, 466, 
	458, 457, 467, 458, 457, 468, 458, 457, 
	469, 458, 457, 35, 458, 457, 471, 458, 
	457, 472, 458, 457, 467, 458, 457, 474, 
	458, 457, 475, 458, 457, 476, 458, 457, 
	477, 458, 457, 478, 458, 457, 35, 458, 
	457, 467, 480, 458, 457, 481, 458, 457, 
	482, 458, 457, 483, 458, 457, 484, 458, 
	457, 485, 458, 457, 486, 458, 457, 487, 
	458, 457, 488, 458, 457, 489, 458, 457, 
	490, 458, 35, 457, 491, 508, 458, 457, 
	492, 458, 457, 493, 458, 457, 494, 458, 
	457, 495, 458, 457, 496, 458, 457, 497, 
	458, 457, 498, 458, 457, 499, 458, 457, 
	500, 458, 457, 501, 458, 457, 502, 458, 
	457, 503, 458, 457, 504, 458, 457, 505, 
	458, 457, 506, 458, 457, 507, 458, 457, 
	458, 35, 457, 509, 458, 457, 510, 458, 
	457, 511, 458, 457, 512, 458, 457, 513, 
	458, 457, 514, 458, 457, 515, 458, 457, 
	516, 458, 457, 517, 458, 457, 518, 458, 
	457, 519, 458, 35, 457, 520, 458, 457, 
	521, 458, 457, 522, 458, 457, 523, 458, 
	457, 507, 458, 457, 525, 534, 458, 457, 
	526, 458, 457, 527, 458, 457, 528, 458, 
	457, 529, 458, 457, 530, 458, 457, 531, 
	458, 457, 532, 458, 457, 533, 458, 457, 
	507, 458, 457, 535, 458, 457, 536, 458, 
	457, 537, 458, 457, 538, 458, 457, 539, 
	458, 457, 540, 458, 457, 541, 458, 457, 
	542, 458, 457, 543, 458, 457, 544, 458, 
	457, 545, 458, 457, 507, 458, 457, 547, 
	458, 457, 467, 458, 457, 549, 458, 457, 
	550, 458, 457, 551, 458, 457, 552, 458, 
	457, 35, 458, 457, 554, 458, 457, 555, 
	458, 457, 556, 458, 457, 557, 458, 457, 
	507, 458, 457, 559, 458, 457, 560, 458, 
	457, 561, 458, 457, 562, 458, 457, 507, 
	458, 457, 458, 564, 457, 458, 565, 457, 
	458, 566, 457, 458, 567, 457, 458, 568, 
	457, 458, 569, 457, 458, 570, 457, 458, 
	571, 457, 458, 572, 457, 458, 573, 457, 
	458, 574, 457, 458, 575, 457, 458, 576, 
	457, 458, 9, 457, 458, 35, 457, 579, 
	588, 0, 580, 0, 581, 0, 582, 0, 
	583, 0, 584, 0, 585, 0, 586, 0, 
	587, 0, 365, 0, 589, 0, 590, 0, 
	591, 0, 592, 0, 593, 0, 594, 0, 
	595, 0, 596, 0, 597, 0, 598, 0, 
	599, 0, 46, 0, 601, 0, 9, 0, 
	0, 0
};

static const char _lexer_trans_actions[] = {
	25, 25, 25, 25, 25, 0, 47, 0, 
	5, 1, 0, 25, 1, 31, 0, 39, 
	0, 0, 0, 39, 0, 0, 0, 0, 
	39, 0, 39, 0, 39, 0, 39, 39, 
	50, 99, 19, 0, 25, 25, 25, 25, 
	25, 47, 0, 5, 1, 0, 25, 1, 
	31, 0, 39, 0, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 124, 50, 47, 0, 77, 77, 
	47, 0, 74, 74, 0, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	47, 17, 0, 56, 56, 56, 56, 56, 
	115, 27, 53, 50, 27, 56, 50, 59, 
	27, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	124, 50, 47, 0, 77, 77, 77, 77, 
	47, 0, 62, 29, 62, 0, 0, 0, 
	0, 47, 0, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 47, 9, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 9, 0, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	9, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	9, 0, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 124, 50, 
	47, 0, 77, 77, 77, 77, 47, 0, 
	65, 29, 77, 65, 0, 0, 0, 0, 
	0, 47, 0, 0, 0, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 11, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 11, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 11, 47, 0, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	11, 0, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 47, 11, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 11, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 11, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 11, 0, 47, 11, 0, 0, 39, 
	0, 39, 47, 0, 0, 39, 119, 41, 
	41, 41, 3, 111, 29, 29, 29, 0, 
	111, 29, 29, 29, 0, 111, 29, 0, 
	29, 0, 95, 7, 7, 39, 47, 0, 
	0, 39, 103, 21, 0, 47, 39, 0, 
	39, 0, 39, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 39, 39, 39, 39, 
	39, 0, 23, 107, 23, 23, 44, 23, 
	0, 47, 0, 1, 0, 39, 0, 0, 
	0, 39, 47, 33, 33, 80, 33, 33, 
	39, 0, 35, 0, 39, 0, 0, 47, 
	0, 0, 35, 0, 0, 89, 89, 89, 
	89, 89, 47, 0, 86, 83, 37, 89, 
	83, 92, 0, 39, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 0, 0, 39, 0, 
	39, 0, 39, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 0, 39, 0, 0, 
	39, 0, 39, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 39, 0, 39, 0, 
	39, 0, 39, 124, 50, 47, 0, 77, 
	77, 77, 77, 47, 0, 71, 29, 77, 
	71, 0, 0, 0, 0, 0, 47, 0, 
	0, 0, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 15, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 15, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 15, 47, 0, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 47, 15, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 15, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 15, 0, 47, 15, 0, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 39, 0, 39, 124, 
	50, 47, 0, 77, 77, 77, 77, 77, 
	47, 0, 68, 29, 77, 68, 0, 0, 
	0, 0, 0, 47, 0, 0, 0, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 13, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 13, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 13, 47, 
	0, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 13, 0, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	47, 13, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 13, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 13, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 13, 0, 47, 13, 0, 0, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 0
};

static const char _lexer_eof_actions[] = {
	0, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39
};

static const int lexer_start = 1;
static const int lexer_first_final = 602;
static const int lexer_error = 0;

static const int lexer_en_main = 1;


#line 243 "/Users/aslakhellesoy/scm/gherkin/tasks/../ragel/i18n/ja.c.rl"

static VALUE 
strip_i(VALUE str, VALUE ary)
{
  rb_funcall(str, rb_intern("strip!"), 0);
  rb_ary_push(ary, str);
  
  return Qnil;
}

static VALUE 
multiline_strip(VALUE text)
{
  VALUE map = rb_ary_new();
  VALUE split = rb_str_split(text, "\n");
  
  rb_iterate(rb_each, split, strip_i, map);
  
  return split;
}

static void 
store_kw_con(VALUE listener, const char * event_name, 
             const char * keyword_at, size_t keyword_length, 
             const char * at,         size_t length, 
             int current_line)
{
  VALUE con = Qnil, kw = Qnil;
  kw = ENCODED_STR_NEW(keyword_at, keyword_length);
  con = ENCODED_STR_NEW(at, length);
  rb_funcall(con, rb_intern("strip!"), 0);
  rb_funcall(listener, rb_intern(event_name), 3, kw, con, INT2FIX(current_line)); 
}

static void
store_multiline_kw_con(VALUE listener, const char * event_name,
                      const char * keyword_at, size_t keyword_length,
                      const char * at,         size_t length,
                      int current_line, int eol)
{
  VALUE con = Qnil, kw = Qnil, name = Qnil, desc = Qnil;

  kw = ENCODED_STR_NEW(keyword_at, keyword_length);
  con = ENCODED_STR_NEW(at, length);

  VALUE split = multiline_strip(con);
  
  name = rb_funcall(split, rb_intern("shift"), 0);
  desc = rb_ary_join(split, rb_str_new2( \
          eol == CRLF_FLAG ? CRLF : LF ));

  if( name == Qnil ) 
  {
    name = rb_str_new2("");
  }
  if( rb_funcall(desc, rb_intern("size"), 0) == 0) 
  {
    desc = rb_str_new2("");
  }
  rb_funcall(name, rb_intern("strip!"), 0);
  rb_funcall(desc, rb_intern("strip!"), 0);
  rb_funcall(listener, rb_intern(event_name), 4, kw, name, desc, INT2FIX(current_line)); 
}

static void 
store_attr(VALUE listener, const char * attr_type,
           const char * at, size_t length, 
           int line)
{
  VALUE val = ENCODED_STR_NEW(at, length);
  rb_funcall(listener, rb_intern(attr_type), 2, val, INT2FIX(line));
}

static void 
store_pystring_content(VALUE listener, 
          int start_col, 
          const char *at, size_t length, 
          int current_line)
{
  VALUE con = ENCODED_STR_NEW(at, length);
  // Gherkin will crash gracefully if the string representation of start_col pushes the pattern past 32 characters
  char pat[32]; 
  snprintf(pat, 32, "^[\t ]{0,%d}", start_col); 
  VALUE re = rb_reg_regcomp(rb_str_new2(pat));
  VALUE re2 = rb_reg_regcomp(rb_str_new2("\r\\Z"));
  VALUE unescape_escaped_quotes = rb_reg_regcomp(rb_str_new2("\\\\\"\\\\\"\\\\\""));
  rb_funcall(con, rb_intern("gsub!"), 2, re, rb_str_new2(""));
  rb_funcall(con, rb_intern("sub!"), 2, re2, rb_str_new2(""));
  rb_funcall(con, rb_intern("gsub!"), 2, unescape_escaped_quotes, rb_str_new2("\"\"\""));
  rb_funcall(listener, rb_intern("py_string"), 2, con, INT2FIX(current_line));
}

static void 
raise_lexer_error(const char * at, int line)
{ 
  rb_raise(rb_eGherkinLexingError, "Lexing error on line %d: '%s'. See http://wiki.github.com/aslakhellesoy/gherkin/lexingerror for more information.", line, at);
}

static int 
count_char(char char_to_count, char *str) {

  int count = 0;
  int i = 0;
  while(str[i] != '\0') {
    if(str[i] == char_to_count) {
      count++;
    }
    i++;
  }
  return count;
}

static void lexer_init(lexer_state *lexer) {
  lexer->content_start = 0;
  lexer->content_end = 0;
  lexer->content_len = 0;
  lexer->mark = 0;
  lexer->keyword_start = 0;
  lexer->keyword_end = 0;
  lexer->next_keyword_start = 0;
  lexer->line_number = 1;
  lexer->last_newline = 0;
  lexer->final_newline = 0;
  lexer->start_col = 0;
  lexer->eol = LF_FLAG;
}

static VALUE CLexer_alloc(VALUE klass)
{
  VALUE obj;
  lexer_state *lxr = ALLOC(lexer_state);
  lexer_init(lxr);

  obj = Data_Wrap_Struct(klass, NULL, -1, lxr);

  return obj;
}

static VALUE CLexer_init(VALUE self, VALUE listener)
{
  rb_iv_set(self, "@listener", listener);
  
  lexer_state *lxr = NULL;
  DATA_GET(self, lexer_state, lxr);
  lexer_init(lxr);
  
  return self;
}

static VALUE CLexer_scan(VALUE self, VALUE input, VALUE uri, VALUE offset)
{
  VALUE listener = rb_iv_get(self, "@listener");
  rb_funcall(listener, rb_intern("location"), 2, uri, offset);

  lexer_state *lexer = NULL;
  DATA_GET(self, lexer_state, lexer);

  VALUE input_copy = rb_str_dup(input);

  rb_str_append(input_copy, rb_str_new2("\n%_FEATURE_END_%"));
  char *data = RSTRING_PTR(input_copy);
  size_t len = RSTRING_LEN(input_copy);
  
  if (count_char('\r', data) > (count_char('\n', data) / 2)) {
    lexer->eol = CRLF_FLAG;
  }
  
  if (len == 0) { 
    rb_raise(rb_eGherkinLexingError, "No content to lex.");
  } else {

    const char *p, *pe, *eof;
    int cs = 0;
    
    VALUE current_row = Qnil;

    p = data;
    pe = data + len;
    eof = pe;
    
    assert(*pe == '\0' && "pointer does not end on NULL");
    
    
#line 1319 "ext/gherkin_lexer_ja/gherkin_lexer_ja.c"
	{
	cs = lexer_start;
	}

#line 426 "/Users/aslakhellesoy/scm/gherkin/tasks/../ragel/i18n/ja.c.rl"
    
#line 1326 "ext/gherkin_lexer_ja/gherkin_lexer_ja.c"
	{
	int _klen;
	unsigned int _trans;
	const char *_acts;
	unsigned int _nacts;
	const char *_keys;

	if ( p == pe )
		goto _test_eof;
	if ( cs == 0 )
		goto _out;
_resume:
	_keys = _lexer_trans_keys + _lexer_key_offsets[cs];
	_trans = _lexer_index_offsets[cs];

	_klen = _lexer_single_lengths[cs];
	if ( _klen > 0 ) {
		const char *_lower = _keys;
		const char *_mid;
		const char *_upper = _keys + _klen - 1;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + ((_upper-_lower) >> 1);
			if ( (*p) < *_mid )
				_upper = _mid - 1;
			else if ( (*p) > *_mid )
				_lower = _mid + 1;
			else {
				_trans += (_mid - _keys);
				goto _match;
			}
		}
		_keys += _klen;
		_trans += _klen;
	}

	_klen = _lexer_range_lengths[cs];
	if ( _klen > 0 ) {
		const char *_lower = _keys;
		const char *_mid;
		const char *_upper = _keys + (_klen<<1) - 2;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + (((_upper-_lower) >> 1) & ~1);
			if ( (*p) < _mid[0] )
				_upper = _mid - 2;
			else if ( (*p) > _mid[1] )
				_lower = _mid + 2;
			else {
				_trans += ((_mid - _keys)>>1);
				goto _match;
			}
		}
		_trans += _klen;
	}

_match:
	cs = _lexer_trans_targs[_trans];

	if ( _lexer_trans_actions[_trans] == 0 )
		goto _again;

	_acts = _lexer_actions + _lexer_trans_actions[_trans];
	_nacts = (unsigned int) *_acts++;
	while ( _nacts-- > 0 )
	{
		switch ( *_acts++ )
		{
	case 0:
#line 86 "/Users/aslakhellesoy/scm/gherkin/tasks/../ragel/i18n/ja.c.rl"
	{
		MARK(content_start, p);
    lexer->current_line = lexer->line_number;
  }
	break;
	case 1:
#line 91 "/Users/aslakhellesoy/scm/gherkin/tasks/../ragel/i18n/ja.c.rl"
	{
    MARK(content_start, p);
  }
	break;
	case 2:
#line 95 "/Users/aslakhellesoy/scm/gherkin/tasks/../ragel/i18n/ja.c.rl"
	{
    lexer->current_line = lexer->line_number;
    lexer->start_col = p - data - lexer->last_newline;
  }
	break;
	case 3:
#line 100 "/Users/aslakhellesoy/scm/gherkin/tasks/../ragel/i18n/ja.c.rl"
	{
    int len = LEN(content_start, PTR_TO(final_newline));

    if (len < 0) len = 0;

    store_pystring_content(listener, lexer->start_col, PTR_TO(content_start), len, lexer->current_line);
  }
	break;
	case 4:
#line 108 "/Users/aslakhellesoy/scm/gherkin/tasks/../ragel/i18n/ja.c.rl"
	{
    STORE_KW_END_CON(feature);
  }
	break;
	case 5:
#line 112 "/Users/aslakhellesoy/scm/gherkin/tasks/../ragel/i18n/ja.c.rl"
	{
    STORE_KW_END_CON(background);
  }
	break;
	case 6:
#line 116 "/Users/aslakhellesoy/scm/gherkin/tasks/../ragel/i18n/ja.c.rl"
	{
    STORE_KW_END_CON(scenario);
  }
	break;
	case 7:
#line 120 "/Users/aslakhellesoy/scm/gherkin/tasks/../ragel/i18n/ja.c.rl"
	{
    STORE_KW_END_CON(scenario_outline);
  }
	break;
	case 8:
#line 124 "/Users/aslakhellesoy/scm/gherkin/tasks/../ragel/i18n/ja.c.rl"
	{
    STORE_KW_END_CON(examples);
  }
	break;
	case 9:
#line 128 "/Users/aslakhellesoy/scm/gherkin/tasks/../ragel/i18n/ja.c.rl"
	{
    store_kw_con(listener, "step",
      PTR_TO(keyword_start), LEN(keyword_start, PTR_TO(keyword_end)),
      PTR_TO(content_start), LEN(content_start, p), 
      lexer->current_line);
  }
	break;
	case 10:
#line 135 "/Users/aslakhellesoy/scm/gherkin/tasks/../ragel/i18n/ja.c.rl"
	{
    STORE_ATTR(comment);
    lexer->mark = 0;
  }
	break;
	case 11:
#line 140 "/Users/aslakhellesoy/scm/gherkin/tasks/../ragel/i18n/ja.c.rl"
	{
    STORE_ATTR(tag);
    lexer->mark = 0;
  }
	break;
	case 12:
#line 145 "/Users/aslakhellesoy/scm/gherkin/tasks/../ragel/i18n/ja.c.rl"
	{
    lexer->line_number += 1;
    MARK(final_newline, p);
  }
	break;
	case 13:
#line 150 "/Users/aslakhellesoy/scm/gherkin/tasks/../ragel/i18n/ja.c.rl"
	{
    MARK(last_newline, p + 1);
  }
	break;
	case 14:
#line 154 "/Users/aslakhellesoy/scm/gherkin/tasks/../ragel/i18n/ja.c.rl"
	{
    if (lexer->mark == 0) {
      MARK(mark, p);
    }
  }
	break;
	case 15:
#line 160 "/Users/aslakhellesoy/scm/gherkin/tasks/../ragel/i18n/ja.c.rl"
	{
    MARK(keyword_end, p);
    MARK(keyword_start, PTR_TO(mark));
    MARK(content_start, p + 1);
    lexer->mark = 0;
  }
	break;
	case 16:
#line 167 "/Users/aslakhellesoy/scm/gherkin/tasks/../ragel/i18n/ja.c.rl"
	{
    MARK(content_end, p);
  }
	break;
	case 17:
#line 171 "/Users/aslakhellesoy/scm/gherkin/tasks/../ragel/i18n/ja.c.rl"
	{
    p = p - 1;
    lexer->current_line = lexer->line_number;
    current_row = rb_ary_new();
  }
	break;
	case 18:
#line 177 "/Users/aslakhellesoy/scm/gherkin/tasks/../ragel/i18n/ja.c.rl"
	{
		MARK(content_start, p);
  }
	break;
	case 19:
#line 181 "/Users/aslakhellesoy/scm/gherkin/tasks/../ragel/i18n/ja.c.rl"
	{
    VALUE con = ENCODED_STR_NEW(PTR_TO(content_start), LEN(content_start, p));
    rb_funcall(con, rb_intern("strip!"), 0);
    VALUE re_pipe      = rb_reg_regcomp(rb_str_new2("\\\\\\|"));
    VALUE re_backslash = rb_reg_regcomp(rb_str_new2("\\\\\\\\"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_pipe,      rb_str_new2("|"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_backslash, rb_str_new2("\\"));

    rb_ary_push(current_row, con);
  }
	break;
	case 20:
#line 192 "/Users/aslakhellesoy/scm/gherkin/tasks/../ragel/i18n/ja.c.rl"
	{
    rb_funcall(listener, rb_intern("row"), 2, current_row, INT2FIX(lexer->current_line));
  }
	break;
	case 21:
#line 196 "/Users/aslakhellesoy/scm/gherkin/tasks/../ragel/i18n/ja.c.rl"
	{
    if (cs < lexer_first_final) {
      if (raise_lexer_error != NULL) {
        size_t count = 0;
        int newstr_count = 0;
        size_t len;
        const char *buff;
        if (lexer->last_newline != 0) {
          len = LEN(last_newline, eof);
          buff = PTR_TO(last_newline);
        } else {
          len = strlen(data);
          buff = data;
        }

        char newstr[len]; 

        for (count = 0; count < len; count++) {
          if(buff[count] == 10) {
            newstr[newstr_count] = '\0'; // terminate new string at first newline found
            break;
          } else {
            if (buff[count] == '%') {
              newstr[newstr_count++] = buff[count];
              newstr[newstr_count] = buff[count];
            } else {
              newstr[newstr_count] = buff[count];
            }
          }
          newstr_count++;
        }

        int line = lexer->line_number;
        lexer_init(lexer); // Re-initialize so we can scan again with the same lexer
        raise_lexer_error(newstr, line);
      }
    } else {
      rb_funcall(listener, rb_intern("eof"), 0);
    }
  }
	break;
#line 1594 "ext/gherkin_lexer_ja/gherkin_lexer_ja.c"
		}
	}

_again:
	if ( cs == 0 )
		goto _out;
	if ( ++p != pe )
		goto _resume;
	_test_eof: {}
	if ( p == eof )
	{
	const char *__acts = _lexer_actions + _lexer_eof_actions[cs];
	unsigned int __nacts = (unsigned int) *__acts++;
	while ( __nacts-- > 0 ) {
		switch ( *__acts++ ) {
	case 21:
#line 196 "/Users/aslakhellesoy/scm/gherkin/tasks/../ragel/i18n/ja.c.rl"
	{
    if (cs < lexer_first_final) {
      if (raise_lexer_error != NULL) {
        size_t count = 0;
        int newstr_count = 0;
        size_t len;
        const char *buff;
        if (lexer->last_newline != 0) {
          len = LEN(last_newline, eof);
          buff = PTR_TO(last_newline);
        } else {
          len = strlen(data);
          buff = data;
        }

        char newstr[len]; 

        for (count = 0; count < len; count++) {
          if(buff[count] == 10) {
            newstr[newstr_count] = '\0'; // terminate new string at first newline found
            break;
          } else {
            if (buff[count] == '%') {
              newstr[newstr_count++] = buff[count];
              newstr[newstr_count] = buff[count];
            } else {
              newstr[newstr_count] = buff[count];
            }
          }
          newstr_count++;
        }

        int line = lexer->line_number;
        lexer_init(lexer); // Re-initialize so we can scan again with the same lexer
        raise_lexer_error(newstr, line);
      }
    } else {
      rb_funcall(listener, rb_intern("eof"), 0);
    }
  }
	break;
#line 1653 "ext/gherkin_lexer_ja/gherkin_lexer_ja.c"
		}
	}
	}

	_out: {}
	}

#line 427 "/Users/aslakhellesoy/scm/gherkin/tasks/../ragel/i18n/ja.c.rl"

    assert(p <= pe && "data overflow after parsing execute");
    assert(lexer->content_start <= len && "content starts after data end");
    assert(lexer->mark < len && "mark is after data end");
    
    // Reset lexer by re-initializing the whole thing
    lexer_init(lexer);

    if (cs == lexer_error) {
      rb_raise(rb_eGherkinLexingError, "Invalid format, lexing fails.");
    } else {
      return Qtrue;
    }
  }
}

void Init_gherkin_lexer_ja()
{
  mGherkin = rb_define_module("Gherkin");
  rb_eGherkinLexingError = rb_const_get(mGherkin, rb_intern("LexingError"));

  mCLexer = rb_define_module_under(mGherkin, "CLexer");
  cI18nLexer = rb_define_class_under(mCLexer, "Ja", rb_cObject);
  rb_define_alloc_func(cI18nLexer, CLexer_alloc);
  rb_define_method(cI18nLexer, "initialize", CLexer_init, 1);
  rb_define_method(cI18nLexer, "scan", CLexer_scan, 3);
}

