
if (CMAKE_VERSION VERSION_LESS 3.1.0)
    message(FATAL_ERROR "Qt 5 Scxml module requires at least CMake version 3.1.0")
endif()

get_filename_component(_qt5Scxml_install_prefix "/opt/local/libexec/qt5/lib/cmake/Qt5Scxml/../../../" ABSOLUTE)

# For backwards compatibility only. Use Qt5Scxml_VERSION instead.
set(Qt5Scxml_VERSION_STRING 5.13.2)

set(Qt5Scxml_LIBRARIES Qt5::Scxml)

macro(_qt5_Scxml_check_file_exists file)
    if(NOT EXISTS "${file}" )
        message(FATAL_ERROR "The imported target \"Qt5::Scxml\" references the file
   \"${file}\"
but this file does not exist.  Possible reasons include:
* The file was deleted, renamed, or moved to another location.
* An install or uninstall procedure did not complete successfully.
* The installation package was faulty and contained
   \"${CMAKE_CURRENT_LIST_FILE}\"
but not all the files it references.
")
    endif()
endmacro()


macro(_populate_Scxml_target_properties Configuration LIB_LOCATION IMPLIB_LOCATION
      IsDebugAndRelease)
    set_property(TARGET Qt5::Scxml APPEND PROPERTY IMPORTED_CONFIGURATIONS ${Configuration})

    set(imported_location "${_qt5Scxml_install_prefix}/lib/${LIB_LOCATION}")
    _qt5_Scxml_check_file_exists(${imported_location})
    set(_deps
        ${_Qt5Scxml_LIB_DEPENDENCIES}
    )
    set(_static_deps
    )

    set_target_properties(Qt5::Scxml PROPERTIES
        "IMPORTED_LOCATION_${Configuration}" ${imported_location}
        # For backward compatibility with CMake < 2.8.12
        "IMPORTED_LINK_INTERFACE_LIBRARIES_${Configuration}" "${_deps};${_static_deps}"
    )
    set_property(TARGET Qt5::Scxml APPEND PROPERTY INTERFACE_LINK_LIBRARIES
                 "${_deps}"
    )


endmacro()

if (NOT TARGET Qt5::Scxml)

    set(_Qt5Scxml_OWN_INCLUDE_DIRS
      "${_qt5Scxml_install_prefix}/lib/QtScxml.framework"
      "${_qt5Scxml_install_prefix}/lib/QtScxml.framework/Headers"
    )
    set(Qt5Scxml_PRIVATE_INCLUDE_DIRS
        "${_qt5Scxml_install_prefix}/lib/QtScxml.framework/Versions/5/Headers/5.13.2/"
        "${_qt5Scxml_install_prefix}/lib/QtScxml.framework/Versions/5/Headers/5.13.2/QtScxml"
    )

    foreach(_dir ${_Qt5Scxml_OWN_INCLUDE_DIRS})
        _qt5_Scxml_check_file_exists(${_dir})
    endforeach()


    set(Qt5Scxml_INCLUDE_DIRS ${_Qt5Scxml_OWN_INCLUDE_DIRS})

    set(Qt5Scxml_DEFINITIONS -DQT_SCXML_LIB)
    set(Qt5Scxml_COMPILE_DEFINITIONS QT_SCXML_LIB)
    set(_Qt5Scxml_MODULE_DEPENDENCIES "Qml;Core")


    set(Qt5Scxml_OWN_PRIVATE_INCLUDE_DIRS ${Qt5Scxml_PRIVATE_INCLUDE_DIRS})

    set(_Qt5Scxml_FIND_DEPENDENCIES_REQUIRED)
    if (Qt5Scxml_FIND_REQUIRED)
        set(_Qt5Scxml_FIND_DEPENDENCIES_REQUIRED REQUIRED)
    endif()
    set(_Qt5Scxml_FIND_DEPENDENCIES_QUIET)
    if (Qt5Scxml_FIND_QUIETLY)
        set(_Qt5Scxml_DEPENDENCIES_FIND_QUIET QUIET)
    endif()
    set(_Qt5Scxml_FIND_VERSION_EXACT)
    if (Qt5Scxml_FIND_VERSION_EXACT)
        set(_Qt5Scxml_FIND_VERSION_EXACT EXACT)
    endif()

    set(Qt5Scxml_EXECUTABLE_COMPILE_FLAGS "")

    foreach(_module_dep ${_Qt5Scxml_MODULE_DEPENDENCIES})
        if (NOT Qt5${_module_dep}_FOUND)
            find_package(Qt5${_module_dep}
                5.13.2 ${_Qt5Scxml_FIND_VERSION_EXACT}
                ${_Qt5Scxml_DEPENDENCIES_FIND_QUIET}
                ${_Qt5Scxml_FIND_DEPENDENCIES_REQUIRED}
                PATHS "/opt/local/libexec/qt5/lib/cmake/Qt5Scxml/.." NO_DEFAULT_PATH
            )
        endif()

        if (NOT Qt5${_module_dep}_FOUND)
            set(Qt5Scxml_FOUND False)
            return()
        endif()

        list(APPEND Qt5Scxml_INCLUDE_DIRS "${Qt5${_module_dep}_INCLUDE_DIRS}")
        list(APPEND Qt5Scxml_PRIVATE_INCLUDE_DIRS "${Qt5${_module_dep}_PRIVATE_INCLUDE_DIRS}")
        list(APPEND Qt5Scxml_DEFINITIONS ${Qt5${_module_dep}_DEFINITIONS})
        list(APPEND Qt5Scxml_COMPILE_DEFINITIONS ${Qt5${_module_dep}_COMPILE_DEFINITIONS})
        list(APPEND Qt5Scxml_EXECUTABLE_COMPILE_FLAGS ${Qt5${_module_dep}_EXECUTABLE_COMPILE_FLAGS})
    endforeach()
    list(REMOVE_DUPLICATES Qt5Scxml_INCLUDE_DIRS)
    list(REMOVE_DUPLICATES Qt5Scxml_PRIVATE_INCLUDE_DIRS)
    list(REMOVE_DUPLICATES Qt5Scxml_DEFINITIONS)
    list(REMOVE_DUPLICATES Qt5Scxml_COMPILE_DEFINITIONS)
    list(REMOVE_DUPLICATES Qt5Scxml_EXECUTABLE_COMPILE_FLAGS)

    set(_Qt5Scxml_LIB_DEPENDENCIES "Qt5::Qml;Qt5::Core")


    add_library(Qt5::Scxml SHARED IMPORTED)
    set_property(TARGET Qt5::Scxml PROPERTY FRAMEWORK 1)

    set_property(TARGET Qt5::Scxml PROPERTY
      INTERFACE_INCLUDE_DIRECTORIES ${_Qt5Scxml_OWN_INCLUDE_DIRS})
    set_property(TARGET Qt5::Scxml PROPERTY
      INTERFACE_COMPILE_DEFINITIONS QT_SCXML_LIB)

    set_property(TARGET Qt5::Scxml PROPERTY INTERFACE_QT_ENABLED_FEATURES scxml-ecmascriptdatamodel)
    set_property(TARGET Qt5::Scxml PROPERTY INTERFACE_QT_DISABLED_FEATURES )

    set(_Qt5Scxml_PRIVATE_DIRS_EXIST TRUE)
    foreach (_Qt5Scxml_PRIVATE_DIR ${Qt5Scxml_OWN_PRIVATE_INCLUDE_DIRS})
        if (NOT EXISTS ${_Qt5Scxml_PRIVATE_DIR})
            set(_Qt5Scxml_PRIVATE_DIRS_EXIST FALSE)
        endif()
    endforeach()

    if (_Qt5Scxml_PRIVATE_DIRS_EXIST)
        add_library(Qt5::ScxmlPrivate INTERFACE IMPORTED)
        set_property(TARGET Qt5::ScxmlPrivate PROPERTY
            INTERFACE_INCLUDE_DIRECTORIES ${Qt5Scxml_OWN_PRIVATE_INCLUDE_DIRS}
        )
        set(_Qt5Scxml_PRIVATEDEPS)
        foreach(dep ${_Qt5Scxml_LIB_DEPENDENCIES})
            if (TARGET ${dep}Private)
                list(APPEND _Qt5Scxml_PRIVATEDEPS ${dep}Private)
            endif()
        endforeach()
        set_property(TARGET Qt5::ScxmlPrivate PROPERTY
            INTERFACE_LINK_LIBRARIES Qt5::Scxml ${_Qt5Scxml_PRIVATEDEPS}
        )
    endif()

    _populate_Scxml_target_properties(RELEASE "QtScxml.framework/QtScxml" "" FALSE)





    file(GLOB pluginTargets "/opt/local/libexec/qt5/lib/cmake/Qt5Scxml/Qt5Scxml_*Plugin.cmake")

    macro(_populate_Scxml_plugin_properties Plugin Configuration PLUGIN_LOCATION)
        set_property(TARGET Qt5::${Plugin} APPEND PROPERTY IMPORTED_CONFIGURATIONS ${Configuration})

        set(imported_location "${_qt5Scxml_install_prefix}/plugins/${PLUGIN_LOCATION}")
        _qt5_Scxml_check_file_exists(${imported_location})
        set_target_properties(Qt5::${Plugin} PROPERTIES
            "IMPORTED_LOCATION_${Configuration}" ${imported_location}
        )
    endmacro()

    if (pluginTargets)
        foreach(pluginTarget ${pluginTargets})
            include(${pluginTarget})
        endforeach()
    endif()



    include("/opt/local/libexec/qt5/lib/cmake/Qt5Scxml/Qt5ScxmlConfigExtras.cmake")

    include("/opt/local/libexec/qt5/lib/cmake/Qt5Scxml/Qt5ScxmlMacros.cmake")

_qt5_Scxml_check_file_exists("/opt/local/libexec/qt5/lib/cmake/Qt5Scxml/Qt5ScxmlConfigVersion.cmake")

endif()
