/*
 * Decompiled with CFR 0.152.
 */
package org.qore.jni.compiler;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import org.qore.jni.QoreURLClassLoader;
import org.qore.jni.compiler.CompilerOutput;
import org.qore.jni.compiler.FileManagerImpl;
import org.qore.jni.compiler.QoreJavaCompilerException;
import org.qore.jni.compiler.QoreJavaFileManager;

public class QoreJavaCompiler<T> {
    static final String JAVA_EXTENSION = ".java";
    private final QoreURLClassLoader classLoader;
    private final JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
    private final List<String> options;
    private DiagnosticCollector<JavaFileObject> diagnostics;
    private final FileManagerImpl javaFileManager;

    public QoreJavaCompiler() {
        this((Iterable<String>)null);
    }

    public QoreJavaCompiler(Iterable<String> iterable) {
        this(QoreURLClassLoader.getCurrent(), iterable);
    }

    public QoreJavaCompiler(String[] stringArray) {
        this(QoreURLClassLoader.getCurrent(), stringArray == null ? (List<String>)null : Arrays.asList(stringArray));
    }

    public QoreJavaCompiler(QoreURLClassLoader qoreURLClassLoader, Iterable<String> iterable) {
        if (this.compiler == null) {
            throw new IllegalStateException("Cannot find the system Java compiler. Check that your class path includes tools.jar");
        }
        this.classLoader = new QoreURLClassLoader(qoreURLClassLoader.getPtr(), (ClassLoader)qoreURLClassLoader);
        this.diagnostics = null;
        QoreJavaFileManager qoreJavaFileManager = new QoreJavaFileManager(this.classLoader, this.compiler.getStandardFileManager(this.diagnostics, null, null));
        this.javaFileManager = new FileManagerImpl(qoreJavaFileManager, this.classLoader);
        this.options = new ArrayList<String>();
        try {
            ArrayList<File> arrayList = new ArrayList<File>();
            if (iterable != null) {
                boolean bl = false;
                for (String string : iterable) {
                    this.options.add(string);
                }
            }
            for (URL uRL : qoreURLClassLoader.getURLs()) {
                String string = URLDecoder.decode(uRL.getPath(), StandardCharsets.UTF_8);
                File file = new File(string);
                arrayList.add(file);
            }
            if (arrayList.size() > 0) {
                qoreJavaFileManager.setLocation(StandardLocation.CLASS_PATH, arrayList);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new RuntimeException(iOException);
        }
    }

    public synchronized CompilerOutput<T> compile(String string, String string2, Class<?> ... classArray) throws QoreJavaCompilerException, ClassCastException {
        return this.compile(string, string2, (DiagnosticCollector<JavaFileObject>)null, classArray);
    }

    public synchronized CompilerOutput<T> compile(String string, CharSequence charSequence, Class<?> ... classArray) throws QoreJavaCompilerException, ClassCastException {
        return this.compile(string, charSequence, (DiagnosticCollector<JavaFileObject>)null, classArray);
    }

    public synchronized CompilerOutput<T> compile(String string, String string2, DiagnosticCollector<JavaFileObject> diagnosticCollector, Class<?> ... classArray) throws QoreJavaCompilerException, ClassCastException {
        return this.compile(string, (CharSequence)string2, diagnosticCollector, classArray);
    }

    public synchronized CompilerOutput<T> compile(String string, CharSequence charSequence, DiagnosticCollector<JavaFileObject> diagnosticCollector, Class<?> ... classArray) throws QoreJavaCompilerException, ClassCastException {
        this.diagnostics = diagnosticCollector;
        HashMap<String, CharSequence> hashMap = new HashMap<String, CharSequence>(1);
        hashMap.put(string, charSequence);
        Map<String, CompilerOutput<T>> map = this.compile(hashMap, diagnosticCollector);
        CompilerOutput<T> compilerOutput = map.get(string);
        if (compilerOutput == null) {
            throw new QoreJavaCompilerException(String.format("Compilation succeeded, but requested class '%s' is not present; byte code for the following classes was produced: %s", string, map.keySet()), hashMap.keySet(), this.diagnostics);
        }
        return this.castable(compilerOutput, classArray);
    }

    /*
     * Exception decompiling
     */
    public synchronized Map<String, CompilerOutput<T>> compile(Map<String, CharSequence> var1_1, DiagnosticCollector<JavaFileObject> var2_2) throws QoreJavaCompilerException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Class<T> loadClass(String string) throws ClassNotFoundException {
        return this.classLoader.loadClass(string);
    }

    public void addClassPath(String string) {
        this.classLoader.addPath(string);
    }

    public void injectClass(String string, byte[] byArray) {
        this.classLoader.addPendingClass(string, byArray);
    }

    private CompilerOutput<T> castable(CompilerOutput<T> compilerOutput, Class<?> ... classArray) throws ClassCastException {
        for (Class clazz : classArray) {
            if (clazz.isAssignableFrom(compilerOutput.cls)) continue;
            throw new ClassCastException(clazz.getName());
        }
        return compilerOutput;
    }

    static URI toURI(String string) {
        try {
            return new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new RuntimeException(uRISyntaxException);
        }
    }

    public ClassLoader getClassLoader() {
        return this.javaFileManager.getClassLoader();
    }
}

