/*
 * Decompiled with CFR 0.152.
 */
package org.qore.jni.compiler;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import org.qore.jni.QoreJavaFileObject;
import org.qore.jni.QoreURLClassLoader;
import org.qore.jni.compiler.JavaFileObjectImpl;
import org.qore.jni.compiler.QoreJavaCompiler;

final class FileManagerImpl
extends ForwardingJavaFileManager<JavaFileManager> {
    private final QoreURLClassLoader classLoader;
    private final Map<URI, JavaFileObject> fileObjects = new HashMap<URI, JavaFileObject>();
    private final ArrayList<JavaFileObject> outputObjects = new ArrayList();

    public FileManagerImpl(JavaFileManager javaFileManager, QoreURLClassLoader qoreURLClassLoader) {
        super(javaFileManager);
        this.classLoader = qoreURLClassLoader;
    }

    public void clearOutputFiles() {
        this.outputObjects.clear();
    }

    public ArrayList<JavaFileObject> getOutputFiles() {
        return this.outputObjects;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public FileObject getFileForInput(JavaFileManager.Location location, String string, String string2) throws IOException {
        FileObject fileObject = this.fileObjects.get(this.uri(location, string, string2));
        if (fileObject != null) {
            return fileObject;
        }
        return super.getFileForInput(location, string, string2);
    }

    public void putFileForInput(StandardLocation standardLocation, String string, String string2, JavaFileObject javaFileObject) {
        this.fileObjects.put(this.uri(standardLocation, string, string2), javaFileObject);
    }

    private URI uri(JavaFileManager.Location location, String string, String string2) {
        return QoreJavaCompiler.toURI(location.getName() + "/" + string + "/" + string2);
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String string, JavaFileObject.Kind kind, FileObject fileObject) throws IOException {
        JavaFileObjectImpl javaFileObjectImpl = new JavaFileObjectImpl(string, kind);
        this.classLoader.add(string, (QoreJavaFileObject)javaFileObjectImpl);
        this.outputObjects.add(javaFileObjectImpl);
        return javaFileObjectImpl;
    }

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location location) {
        return this.classLoader;
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location location, JavaFileObject javaFileObject) {
        String string = javaFileObject instanceof JavaFileObjectImpl ? javaFileObject.getName() : super.inferBinaryName(location, javaFileObject);
        return string;
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String string, Set<JavaFileObject.Kind> set, boolean bl) throws IOException {
        Iterable<JavaFileObject> iterable = super.list(location, string, set, bl);
        ArrayList<JavaFileObject> arrayList = new ArrayList<JavaFileObject>();
        if (location == StandardLocation.CLASS_PATH && set.contains((Object)JavaFileObject.Kind.CLASS)) {
            for (JavaFileObject javaFileObject : this.fileObjects.values()) {
                if (javaFileObject.getKind() != JavaFileObject.Kind.CLASS || !javaFileObject.getName().startsWith(string)) continue;
                arrayList.add(javaFileObject);
            }
            this.classLoader.files().forEach(qoreJavaFileObject -> arrayList.add((JavaFileObject)qoreJavaFileObject));
        } else if (location == StandardLocation.SOURCE_PATH && set.contains((Object)JavaFileObject.Kind.SOURCE)) {
            for (JavaFileObject javaFileObject : this.fileObjects.values()) {
                if (javaFileObject.getKind() != JavaFileObject.Kind.SOURCE || !javaFileObject.getName().startsWith(string)) continue;
                arrayList.add(javaFileObject);
            }
        }
        for (JavaFileObject javaFileObject : iterable) {
            arrayList.add(javaFileObject);
        }
        return arrayList;
    }
}

