
/* simple text-based menu package 09-00, revised 03-02-02 AG */

/* menu: print a menu given by title, list of key/option pairs, default option
   and prompt, and return the key selected by the user */

/* Example:

==> menu "Menu" [("1","1st choice"),("2","2nd choice"),("q","Quit")] \
   "q" "Your choice:"

*** Menu ***

1:	1st choice
2:	2nd choice
q:	Quit

Your choice: <CR>
"q"

*/

public menu TITLE OPTS DFLT PROMPT;
private write_opt OPT, check_opt OPTS DFLT PROMPT ANS, lookup OPTS DFLT ANS;

menu TITLE:String OPTS:List DFLT PROMPT:String
			= writes ("\n*** "++TITLE++" ***\n\n") ||
			  do write_opt OPTS ||
			  writes ("\n"++PROMPT++" ") || flush ||
			  check_opt OPTS DFLT PROMPT (lookup OPTS DFLT reads);

write_opt (KEY:String,TEXT:String)
			= writes (KEY++":\t"++TEXT++"\n");

check_opt OPTS:List DFLT PROMPT:String ANS:String
			= ANS;
check_opt OPTS:List DFLT PROMPT:String ANS
			= writes ("\nWrong choice, please try again:\n\n"++
				  PROMPT++" ") || flush ||
			  check_opt OPTS DFLT PROMPT (lookup OPTS DFLT reads)
			      otherwise;

lookup OPTS:List DFLT:String ""
			= DFLT;
lookup [] DFLT ANS:String
			= ();
lookup [(KEY:String,TEXT:String)|OPTS:List] DFLT KEY
			= KEY;
lookup [(KEY:String,TEXT:String)|OPTS:List] DFLT ANS:String
			= lookup OPTS DFLT ANS otherwise;

/* read_prompt: read a string (with prompt) from user */

/* Example:

==> read_prompt "Enter string:"
Enter string: bla<CR>
"bla"

*/

public read_prompt PROMPT;

read_prompt PROMPT:String
			= writes (PROMPT++" ") || flush || reads;

/* yes_or_no: read yes or no from user, with prompt, return "y" or "n" */

/* Example:

==> yes_or_no "Yes/No?"
Yes/No? <CR>
Please enter y(es) or n(o): y<CR>
"y"

*/

public yes_or_no PROMPT;
private check_yes_no ANS;

yes_or_no PROMPT:String	= writes (PROMPT++" ") || flush || check_yes_no reads;

check_yes_no "yes"	= "y";
check_yes_no "no"	= "n";
check_yes_no ANS:String	= ANS if (ANS="y") or (ANS="n");
			= writes "Please enter y(es) or n(o): " || flush ||
			  check_yes_no reads
			      otherwise;
