<h1 align="center" style="margin:1em;">
  <a href="https://scitools.org.uk/cartopy/docs/latest/">
    <img src="https://scitools.org.uk/cartopy/docs/latest/_static/cartopy.png"
         alt="Cartopy"></a>
</h1>

<h4 align="center">
    Cartopy is a Python package designed to make drawing maps for
    data analysis and visualisation easy.
</h4>

<p align="center">
<!-- https://shields.io/ is a good source of these -->
<a href="https://anaconda.org/conda-forge/cartopy">
<img src="https://img.shields.io/conda/dn/conda-forge/cartopy.svg"
 alt="conda-forge downloads" /></a>
<a href="https://github.com/SciTools/cartopy/releases">
<img src="https://img.shields.io/github/tag/SciTools/cartopy.svg"
 alt="Latest version" /></a>
<a href="https://github.com/SciTools/cartopy/commits/main">
<img src="https://img.shields.io/github/commits-since/SciTools/cartopy/latest.svg"
 alt="Commits since last release" /></a>
<a href="https://github.com/SciTools/cartopy/graphs/contributors">
<img src="https://img.shields.io/github/contributors/SciTools/cartopy.svg"
 alt="# contributors" /></a>
<a href="https://zenodo.org/badge/latestdoi/5282596">
<img src="https://zenodo.org/badge/5282596.svg"
 alt="zenodo" /></a>
<a href="https://gitter.im/SciTools/cartopy?utm_source=badge&utm_medium=badge&utm_campaign=pr-badge">
<img src="https://badges.gitter.im/SciTools/cartopy.svg" alt="Gitter Chat" /></a>
<a href="https://results.pre-commit.ci/latest/github/SciTools/cartopy/main">
<img src="https://results.pre-commit.ci/badge/github/SciTools/cartopy/main.svg"
 alt="pre-commit.ci" /></a>
</p>
<br>

# Table of contents

<!--
NOTE: toc auto-generated with https://github.com/jonschlinkert/markdown-toc
    $> markdown-toc -i --bullets='-' README.md

NOTE: This entire README can be markdown linted with
    https://github.com/igorshubovych/markdownlint-cli
    $ echo '{"no-inline-html": false}' > .markdownrc
    $ markdownlint README.md
-->

<!-- toc -->

- [Overview](#overview)
- [Get in touch](#get-in-touch)
- [License and copyright](#license-and-copyright)

<!-- tocstop -->

## Overview

Cartopy is a Python package designed to make drawing maps for data
analysis and visualisation easy.

It features:

- object oriented projection definitions
- point, line, polygon and image transformations between projections
- integration to expose advanced mapping in Matplotlib with a simple and
  intuitive interface
- powerful vector data handling by integrating shapefile reading with Shapely
  capabilities

Documentation can be found at <https://scitools.org.uk/cartopy/docs/latest/>.

## Get in touch

- Ask usage questions on
  [StackOverflow](https://stackoverflow.com/questions/tagged/cartopy).
- For less well defined questions, ideas, general discussion or announcements of
  related projects use the
  [Cartopy category on Matplotlib's Discourse](https://discourse.matplotlib.org/c/3rdparty/cartopy/19).
- Report bugs, suggest features or view the source code on
  [GitHub](https://github.com/SciTools/cartopy).
- To chat with developers and other users you can use the
  [Gitter Chat](https://gitter.im/SciTools/cartopy).


## Credits, copyright and license

Cartopy is developed collaboratively under the SciTools umberella.

A full list of codecontributors ("Cartopy contributors") can be found at
https://github.com/SciTools/cartopy/graphs/contributors.

Code is just one of many ways of positively contributing to Cartopy, please see
our [contributing guide](.github/CONTRIBUTING.md) for more details on how
you can get involved.

Cartopy is released under the 3-Clause BSD license with a shared copyright model.
See [LICENSE](LICENSE) for full terms.

The [Met Office](https://metoffice.gov.uk) has made a significant
contribution to the development, maintenance and support of this library.
All Met Office contributions are copyright on behalf of the British Crown.
